/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaKernelModule;
import agent.frida.manager.FridaModule;
import agent.frida.model.iface2.FridaModelTargetModule;
import agent.frida.model.impl.FridaModelTargetKernelModuleContainerImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Module", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="BaseAddress", type=Address.class), @TargetAttributeType(name="ImageName", type=String.class), @TargetAttributeType(name="Len", type=String.class), @TargetAttributeType(type=Void.class)})
public class FridaModelTargetKernelModuleImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetModule {
    protected static String indexModule(FridaModule module) {
        return FridaClient.getId(module);
    }

    protected static String keyModule(FridaModule module) {
        return PathUtils.makeKey((String)FridaModelTargetKernelModuleImpl.indexModule(module));
    }

    public FridaModelTargetKernelModuleImpl(FridaModelTargetKernelModuleContainerImpl modules, FridaKernelModule module) {
        super(modules.getModel(), (TargetObject)modules, FridaModelTargetKernelModuleImpl.keyModule(module), module, "Module");
        AddressSpace space = this.getModel().getAddressSpace("ram");
        this.changeAttributes(List.of(), List.of(), Map.of("_short_display", module.getName(), "_module_name", module.getPath(), "ImageName", module.getPath()), "Initialized");
        try {
            Address address = space.getAddress(module.getRangeAddress());
            AddressRangeImpl range = new AddressRangeImpl(address, module.getRangeSize().longValue());
            this.changeAttributes(List.of(), List.of(), Map.of("_range", range, "BaseAddress", address, "Len", Long.toHexString(module.getRangeSize())), "Initialized");
        }
        catch (AddressFormatException | AddressOverflowException throwable) {
            // empty catch block
        }
    }

    @Override
    public String getDescription(int level) {
        FridaModule module = (FridaModule)this.getModelObject();
        return module.getName();
    }

    protected Address doGetBase() {
        return null;
    }

    @Override
    public FridaModule getModule() {
        return (FridaModule)this.getModelObject();
    }

    @Override
    public void setRange(AddressRangeImpl range) {
        if (range != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_range", range, "BaseAddress", range.getMinAddress(), "Len", Long.toHexString(range.getLength())), "Initialized");
        }
    }
}

