/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaContext;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaThread;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public class FridaListThreadsCommand
extends AbstractFridaCommand<Void> {
    protected final FridaProcess process;
    private List<FridaThread> threads = new ArrayList<FridaThread>();

    public FridaListThreadsCommand(FridaManagerImpl manager, FridaProcess process) {
        super(manager);
        this.process = process;
    }

    @Override
    public void invoke() {
        this.manager.loadScript(this, "list_threads", "result = Process.enumerateThreads();");
        for (FridaThread thread : this.threads) {
            this.manager.addThreadIfAbsent(this.process, thread);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaThread thread = new FridaThread(this.process);
        if (element.isJsonPrimitive()) {
            Msg.error((Object)this, (Object)element.getAsString());
            return;
        }
        JsonObject modDetails = element.getAsJsonObject();
        thread.setTid(modDetails.get("id").getAsLong());
        String state = modDetails.get("state").getAsString();
        thread.setState(FridaState.byValue(state));
        JsonObject cpuContext = (JsonObject)modDetails.get("context");
        thread.setContext(new FridaContext(cpuContext));
        this.threads.add(thread);
    }
}

