/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgExceptionFilter;
import agent.dbgeng.manager.cmd.DbgListExceptionFiltersCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.model.iface2.DbgModelTargetDebugContainer;
import agent.dbgeng.model.iface2.DbgModelTargetException;
import agent.dbgeng.model.iface2.DbgModelTargetExceptionContainer;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.impl.DbgModelTargetExceptionImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ExceptionContainer", elements={@TargetElementType(type=DbgModelTargetExceptionImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetExceptionContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetExceptionContainer {
    protected final DbgModelTargetDebugContainer debug;
    protected final Map<String, DbgModelTargetExceptionImpl> exceptions = new WeakValueHashMap();

    public DbgModelTargetExceptionContainerImpl(DbgModelTargetDebugContainer debug) {
        super(debug.getModel(), (TargetObject)debug, "Exceptions", "ExceptionContainer");
        this.debug = debug;
        this.requestElements(true);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        DbgModelTargetProcess targetProcess = this.getParentProcess();
        DbgProcessImpl currentProcess = this.getManager().getCurrentProcess();
        if (!refresh || currentProcess != null && !currentProcess.equals(targetProcess.getProcess())) {
            return AsyncUtils.NIL;
        }
        return this.listExceptionFilters().thenAccept(byName -> {
            List excObjs;
            DbgModelTargetExceptionContainerImpl dbgModelTargetExceptionContainerImpl = this;
            synchronized (dbgModelTargetExceptionContainerImpl) {
                excObjs = byName.stream().map(this::getTargetException).collect(Collectors.toList());
            }
            this.setElements(excObjs, Map.of(), "Refreshed");
        });
    }

    public synchronized DbgModelTargetException getTargetException(DbgExceptionFilter filter) {
        String id = filter.getName();
        DbgModelTargetExceptionImpl exc = this.exceptions.get(id);
        if (exc != null && exc.getFilter().getName().equals(id)) {
            return exc;
        }
        exc = new DbgModelTargetExceptionImpl(this, filter);
        this.exceptions.put(filter.getName(), exc);
        return exc;
    }

    public CompletableFuture<List<DbgExceptionFilter>> listExceptionFilters() {
        DbgManagerImpl manager = this.getManager();
        return manager.execute(new DbgListExceptionFiltersCommand(manager));
    }
}

