/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import pdb.PdbUtils;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.LocalSymbolStore;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInputStream;
import pdb.symbolserver.SymbolStore;

public class SymbolServerService {
    private static final int MAX_TRY_COUNT = 3;
    private SymbolStore symbolStore;
    private List<SymbolServer> symbolServers;

    public SymbolServerService(SymbolStore symbolStore, List<SymbolServer> symbolServers) {
        this.symbolStore = symbolStore;
        this.symbolServers = new ArrayList<SymbolServer>();
        this.symbolServers.add(symbolStore);
        this.symbolServers.addAll(symbolServers);
    }

    public boolean isValid() {
        return this.symbolStore instanceof LocalSymbolStore;
    }

    public SymbolStore getSymbolStore() {
        return this.symbolStore;
    }

    public List<SymbolServer> getSymbolServers() {
        return new ArrayList<SymbolServer>(this.symbolServers.subList(1, this.symbolServers.size()));
    }

    public int getRemoteSymbolServerCount() {
        int remoteSymbolServerCount = (int)this.getSymbolServers().stream().filter(ss -> !ss.isLocal()).count();
        return remoteSymbolServerCount;
    }

    public List<SymbolFileLocation> find(SymbolFileInfo symbolFileInfo, TaskMonitor monitor) throws CancelledException {
        return this.find(symbolFileInfo, FindOption.NO_OPTIONS, monitor);
    }

    public List<SymbolFileLocation> find(SymbolFileInfo symbolFileInfo, Set<FindOption> findOptions, TaskMonitor monitor) throws CancelledException {
        if (StringUtils.isBlank((CharSequence)symbolFileInfo.getName())) {
            Msg.warn((Object)this, (Object)(this.logPrefix() + ": Unable to search for empty filename: " + symbolFileInfo));
            return List.of();
        }
        ArrayList<SymbolFileLocation> allFindResults = new ArrayList<SymbolFileLocation>();
        HashSet<String> uniqueSymbolFilePaths = new HashSet<String>();
        block0: for (SymbolServer symbolServer : this.symbolServers) {
            monitor.checkCanceled();
            if (!symbolServer.isLocal() && !findOptions.contains((Object)FindOption.ALLOW_REMOTE)) {
                Msg.debug((Object)this, (Object)(this.logPrefix() + ": skipping non-local symbol server " + symbolServer.getDescriptiveName()));
                continue;
            }
            Msg.debug((Object)this, (Object)(this.logPrefix() + ": querying " + symbolServer.getDescriptiveName() + " for " + symbolFileInfo.getDescription()));
            List<SymbolFileLocation> symbolServerFindResults = symbolServer.find(symbolFileInfo, findOptions, monitor);
            Msg.debug((Object)this, (Object)(this.logPrefix() + ": got " + symbolServerFindResults.size() + " results from " + symbolServer.getDescriptiveName()));
            for (SymbolFileLocation symbolFileLocation : symbolServerFindResults) {
                if (!uniqueSymbolFilePaths.add(symbolFileLocation.getLocationStr())) continue;
                allFindResults.add(symbolFileLocation);
                if (!findOptions.contains((Object)FindOption.ONLY_FIRST_RESULT)) continue;
                break block0;
            }
        }
        Msg.debug((Object)this, (Object)(this.logPrefix() + ": found " + allFindResults.size() + " matches"));
        return allFindResults;
    }

    public File getSymbolFile(SymbolFileLocation symbolFileLocation, TaskMonitor monitor) throws CancelledException, IOException {
        Msg.debug((Object)this, (Object)(this.logPrefix() + ": getting symbol file: " + symbolFileLocation.getLocationStr()));
        SymbolFileLocation localSymbolFileLocation = this.ensureLocalUncompressedFile(symbolFileLocation, monitor);
        Msg.debug((Object)this, (Object)(this.logPrefix() + ": local file now: " + localSymbolFileLocation.getLocationStr()));
        SymbolStore symbolStore = (SymbolStore)localSymbolFileLocation.getSymbolServer();
        return symbolStore.getFile(localSymbolFileLocation.getPath());
    }

    public SymbolFileLocation getLocalSymbolFileLocation(SymbolFileLocation symbolFileLocation, TaskMonitor monitor) throws CancelledException, IOException {
        Msg.debug((Object)this, (Object)(this.logPrefix() + ": getting symbol file: " + symbolFileLocation.getLocationStr()));
        SymbolFileLocation localSymbolFileLocation = this.ensureLocalUncompressedFile(symbolFileLocation, monitor);
        return localSymbolFileLocation;
    }

    private SymbolFileLocation ensureLocalUncompressedFile(SymbolFileLocation symbolFileLocation, TaskMonitor monitor) throws IOException, CancelledException {
        if (!(symbolFileLocation.getSymbolServer() instanceof SymbolStore)) {
            symbolFileLocation = this.copyRemoteToLocal(symbolFileLocation, monitor);
        }
        SymbolStore localSymbolStore = (SymbolStore)symbolFileLocation.getSymbolServer();
        if (SymbolStore.isCompressedFilename(symbolFileLocation.getPath())) {
            File cabFile = localSymbolStore.getFile(symbolFileLocation.getPath());
            File adminDir = this.symbolStore.getAdminDir();
            if (!adminDir.isDirectory()) {
                adminDir = cabFile.getParentFile();
            }
            File temporaryExtractFile = new File(adminDir, "ghidra_cab_extract_tmp_" + System.currentTimeMillis());
            Msg.debug((Object)this, (Object)"%s: decompressing file %s".formatted(this.logPrefix(), symbolFileLocation.getLocationStr()));
            String originalName = PdbUtils.extractSingletonCabToFile(cabFile, temporaryExtractFile, monitor);
            String uncompressedPath = this.symbolStore.giveFile(symbolFileLocation.getFileInfo(), temporaryExtractFile, originalName, monitor);
            symbolFileLocation = new SymbolFileLocation(uncompressedPath, this.symbolStore, symbolFileLocation.getFileInfo());
            Msg.debug((Object)this, (Object)"%s: new decompressed file %s".formatted(this.logPrefix(), symbolFileLocation.getLocationStr()));
        }
        return symbolFileLocation;
    }

    private SymbolFileLocation copyRemoteToLocal(SymbolFileLocation symbolFileLocation, TaskMonitor monitor) throws CancelledException, IOException {
        int tryCount = 0;
        while (true) {
            SymbolFileLocation symbolFileLocation2;
            block10: {
                Msg.debug((Object)this, (Object)"%s try[%d]: copying file %s from remote to local %s".formatted(this.logPrefix(), tryCount, symbolFileLocation.getLocationStr(), this.symbolStore.getName()));
                String remoteFilename = FilenameUtils.getName((String)symbolFileLocation.getPath());
                SymbolServerInputStream symbolServerInputStream = symbolFileLocation.getSymbolServer().getFileStream(symbolFileLocation.getPath(), monitor);
                try {
                    String newPath = this.symbolStore.putStream(symbolFileLocation.getFileInfo(), symbolServerInputStream, remoteFilename, monitor);
                    symbolFileLocation2 = new SymbolFileLocation(newPath, this.symbolStore, symbolFileLocation.getFileInfo());
                    if (symbolServerInputStream == null) break block10;
                }
                catch (Throwable newPath) {
                    try {
                        if (symbolServerInputStream != null) {
                            try {
                                symbolServerInputStream.close();
                            }
                            catch (Throwable throwable) {
                                newPath.addSuppressed(throwable);
                            }
                        }
                        throw newPath;
                    }
                    catch (IOException e) {
                        String msg = "%s: error copying file %s to %s: %s".formatted(this.logPrefix(), symbolFileLocation.getLocationStr(), this.symbolStore.getName(), e.getMessage());
                        if (++tryCount >= 3) {
                            Msg.error((Object)this, (Object)msg);
                            throw e;
                        }
                        Msg.warn((Object)this, (Object)msg);
                        continue;
                    }
                }
                symbolServerInputStream.close();
            }
            return symbolFileLocation2;
            break;
        }
    }

    private String logPrefix() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return String.format("SymbolServerService:\n\tsymbolStore: %s,\n\tsymbolServers:\n\t\t%s\n", this.symbolStore.toString(), this.symbolServers.subList(1, this.symbolServers.size()).stream().map(Object::toString).collect(Collectors.joining("\n\t\t")));
    }
}

