/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractVirtualFunctionTablePathMsType
extends AbstractMsType {
    protected List<RecordNumber> bases = new ArrayList<RecordNumber>();

    public AbstractVirtualFunctionTablePathMsType(AbstractPdb pdb, PdbByteReader reader, int intSize) throws PdbException {
        super(pdb, reader);
        int count = reader.parseVarSizedCount(intSize);
        for (int i = 0; i < count; ++i) {
            RecordNumber baseRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, intSize);
            this.bases.add(baseRecordNumber);
        }
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(String.format("VFTPath: count=%d\n", this.bases.size()));
        for (int i = 0; i < this.bases.size(); ++i) {
            builder.append(String.format("   base[%d]=%s\n", i, this.pdb.getTypeRecord(this.bases.get(i)).toString()));
        }
    }
}

