/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfFileReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfFreePageMap;
import ghidra.util.exception.CancelledException;
import java.io.IOException;

class MsfFreePageMap700
extends MsfFreePageMap {
    MsfFreePageMap700(Msf msf) {
        super(msf);
    }

    @Override
    boolean isBig() {
        return true;
    }

    @Override
    void deserialize() throws IOException, CancelledException {
        int log2BitsPerPage = this.msf.getLog2PageSize() + 3;
        long freePageMapNumPages = Msf.floorDivisionWithLog2Divisor(this.msf.getNumPages(), log2BitsPerPage);
        int nextPageNumber = this.msf.getCurrentFreePageMapFirstPageNumber();
        MsfFileReader fileReader = this.msf.getFileReader();
        int pageSize = this.msf.getPageSize();
        while (freePageMapNumPages > 0L) {
            this.msf.checkCanceled();
            byte[] bytes = new byte[pageSize];
            fileReader.read(nextPageNumber, 0, pageSize, bytes, 0);
            this.addMap(bytes);
            --freePageMapNumPages;
            nextPageNumber += pageSize;
        }
    }
}

