/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class AbstractC13Lines
extends C13Section {
    private long offCon;
    private int segCon;
    private int flags;
    private long lenCon;
    private List<FileRecord> fileRecords = new ArrayList<FileRecord>();

    protected AbstractC13Lines(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        super(ignore);
        boolean hasColumn;
        if (reader.numRemaining() < 12) {
            throw new PdbException("Not enough data for header");
        }
        this.offCon = reader.parseUnsignedIntVal();
        this.segCon = reader.parseUnsignedShortVal();
        this.flags = reader.parseUnsignedShortVal();
        this.lenCon = reader.parseUnsignedIntVal();
        boolean bl = hasColumn = (this.flags & 1) != 0;
        while (reader.hasMore()) {
            monitor.checkCanceled();
            FileRecord fileRecord = FileRecord.parse(reader, hasColumn, monitor);
            if (fileRecord == null) break;
            this.fileRecords.add(fileRecord);
        }
    }

    long getOffCon() {
        return this.offCon;
    }

    int getSegCon() {
        return this.segCon;
    }

    int getFlags() {
        return this.flags;
    }

    long getLenCon() {
        return this.lenCon;
    }

    public String toString() {
        return String.format("%s: offCon = %ld, segCon = %d, flags = 0x%04x, lenCon = %d; num records = %d", this.getClass().getSimpleName(), this.offCon, this.segCon, this.flags, this.lenCon, this.fileRecords.size());
    }

    @Override
    void dump(Writer writer) throws IOException {
        writer.write("C13Lines----------------------------------------------------\n");
        this.dumpInternal(writer);
        writer.write("End C13Lines------------------------------------------------\n");
    }

    protected void dumpInternal(Writer writer) throws IOException {
        writer.write(String.format("offCon: 0x%08x segCon: %d flags: 0x%08x lenCon: 0x%08x\n", this.offCon, this.segCon, this.flags, this.lenCon));
        for (FileRecord record : this.fileRecords) {
            record.dump(writer, this.offCon);
        }
    }

    static class FileRecord {
        private long fileId;
        private long nLines;
        private long lenFileBlock;
        private List<LineRecord> lineRecords = new ArrayList<LineRecord>();

        static FileRecord parse(PdbByteReader reader, boolean hasColumn, TaskMonitor monitor) throws PdbException {
            return new FileRecord(reader, hasColumn, monitor);
        }

        private FileRecord(PdbByteReader reader, boolean hasColumn, TaskMonitor monitor) throws PdbException {
            int sizeColumns;
            if (reader.numRemaining() < 12) {
                throw new PdbException("Not enough data for FileRecord header");
            }
            this.fileId = reader.parseUnsignedIntVal();
            this.nLines = reader.parseUnsignedIntVal();
            this.lenFileBlock = reader.parseUnsignedIntVal();
            long lenMinusHeader = this.lenFileBlock - 12L;
            Long x = this.nLines;
            int nLinesI = x.intValue();
            int sizeLines = nLinesI * 8;
            int sizeRequired = sizeLines + (sizeColumns = nLinesI * (hasColumn ? 4 : 0));
            if (lenMinusHeader != (long)sizeRequired) {
                throw new PdbException("Corrupt FileRecord");
            }
            if (reader.numRemaining() < sizeRequired) {
                throw new PdbException("Not enough data for FileRecord records");
            }
            PdbByteReader lineReader = reader.getSubPdbByteReader(sizeLines);
            PdbByteReader columnReader = hasColumn ? reader.getSubPdbByteReader(sizeColumns) : null;
            int i = 0;
            while ((long)i < this.nLines) {
                LineRecord lineRecord = LineRecord.parse(lineReader, columnReader);
                this.lineRecords.add(lineRecord);
                ++i;
            }
        }

        long getFileId() {
            return this.fileId;
        }

        long getNLines() {
            return this.nLines;
        }

        long getLenFileBlock() {
            return this.lenFileBlock;
        }

        List<LineRecord> getLineRecords() {
            return this.lineRecords;
        }

        void dump(Writer writer, long offCon) throws IOException {
            writer.write(String.format("fileId: %06x, nLines: %d, lenFileBlock: %d\n", this.getFileId(), this.getNLines(), this.getLenFileBlock()));
            int i = 0;
            while ((long)i < this.getNLines()) {
                List<LineRecord> records = this.getLineRecords();
                records.get(i).dump(writer, offCon);
                writer.write("\n");
                ++i;
            }
        }
    }

    static class ColumnRecord {
        private int offsetColumnStart;
        private int offsetColumnEnd;

        int getOffsetColumnStart() {
            return this.offsetColumnStart;
        }

        int getOffsetColumnEnd() {
            return this.offsetColumnEnd;
        }

        static ColumnRecord parse(PdbByteReader reader) throws PdbException {
            return new ColumnRecord(reader);
        }

        private ColumnRecord(PdbByteReader reader) throws PdbException {
            this.offsetColumnStart = reader.parseUnsignedShortVal();
            this.offsetColumnEnd = reader.parseUnsignedShortVal();
        }

        public String toString() {
            return String.format("Start: 0x%04x, End: 0x%04x", this.getOffsetColumnStart(), this.getOffsetColumnEnd());
        }
    }

    static class LineRecord {
        private long offset;
        private long bitVals;
        private ColumnRecord columnRecord = null;

        long getOffset() {
            return this.offset;
        }

        long getBitVals() {
            return this.bitVals;
        }

        long getLineNumStart() {
            return this.bitVals & 0xFFFFFFL;
        }

        long getDeltaLineEnd() {
            return this.bitVals >> 24 & 0x7FL;
        }

        ColumnRecord getColumnRecord() {
            return this.columnRecord;
        }

        boolean isStatement() {
            return (this.bitVals & 0x80000000L) != 0L;
        }

        boolean isExpression() {
            return !this.isStatement();
        }

        static LineRecord parse(PdbByteReader lineReader, PdbByteReader columnReader) throws PdbException {
            return new LineRecord(lineReader, columnReader);
        }

        private LineRecord(PdbByteReader lineReader, PdbByteReader columnReader) throws PdbException {
            this.offset = lineReader.parseUnsignedIntVal();
            this.bitVals = lineReader.parseUnsignedIntVal();
            if (columnReader != null) {
                this.columnRecord = ColumnRecord.parse(columnReader);
            }
        }

        private boolean isSpecialLine() {
            long start = this.getLineNumStart();
            return start == 0xFEEFEEL || start == 0xF00F00L;
        }

        void dump(Writer writer, long offCon) throws IOException {
            String lineStart;
            String string = lineStart = this.isSpecialLine() ? String.format("%06x", this.getLineNumStart()) : String.format("%d", this.getLineNumStart());
            if (this.columnRecord != null) {
                if ((long)this.columnRecord.getOffsetColumnEnd() != 0L) {
                    writer.write(String.format("%5d:%5d-%5d-%5d 0x%08x %s", this.getLineNumStart(), this.columnRecord.getOffsetColumnStart(), this.getLineNumStart() + this.getDeltaLineEnd(), this.columnRecord.getOffsetColumnEnd(), this.getOffset() + offCon, this.isStatement() ? "Statement" : "Expression"));
                } else {
                    writer.write(String.format("%s-%5d 0x%08x %s", lineStart, this.columnRecord.getOffsetColumnStart(), this.getOffset() + offCon, this.isStatement() ? "Statement" : "Expression"));
                }
            } else {
                writer.write(String.format("%s 0x%08x %s", lineStart, this.getOffset() + offCon, this.isStatement() ? "Statement" : "Expression"));
            }
        }
    }
}

