/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class RISCVAddressAnalyzer
extends ConstantPropagationAnalyzer {
    public static final String RISCV___GLOBAL_POINTER = "__global_pointer$";
    private Address gp_assumption_value;
    private static final String REGISTER_GP = "gp";
    private Register gp;
    private static final String PROCESSOR_NAME = "RISCV";

    public RISCVAddressAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        boolean canAnalyze = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
        if (!canAnalyze) {
            return false;
        }
        this.gp = program.getRegister(REGISTER_GP);
        return true;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.gp_assumption_value = null;
        this.checkForGlobalGP(program, set, monitor);
        return super.added(program, set, monitor, log);
    }

    public AddressSetView flowConstants(Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ProgramContext programContext;
        RegisterValue gpVal;
        Function func = program.getFunctionManager().getFunctionContaining(flowStart);
        if (!(func == null || this.gp_assumption_value == null || (gpVal = (programContext = program.getProgramContext()).getRegisterValue(this.gp, flowStart)) != null && gpVal.hasValue())) {
            gpVal = new RegisterValue(this.gp, BigInteger.valueOf(this.gp_assumption_value.getOffset()));
            try {
                program.getProgramContext().setRegisterValue(func.getEntryPoint(), func.getEntryPoint(), gpVal);
            }
            catch (ContextChangeException e) {
                throw new AssertException("unexpected", (Throwable)e);
            }
        }
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption){
            private boolean mustStopNow;
            {
                this.mustStopNow = false;
            }

            public boolean evaluateContextBefore(VarnodeContext context, Instruction instr) {
                return this.mustStopNow;
            }

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                return this.mustStopNow;
            }
        };
        AddressSet resultSet = symEval.flowConstants(flowStart, null, (ContextEvaluator)eval, true, monitor);
        return resultSet;
    }

    private void checkForGlobalGP(Program program, AddressSetView set, TaskMonitor monitor) {
        Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)RISCV___GLOBAL_POINTER, err -> Msg.error((Object)((Object)this), (Object)err));
        if (symbol != null) {
            this.gp_assumption_value = symbol.getAddress();
            return;
        }
    }
}

