/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import help.validator.TagProcessor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;

public class HTMLFileParser {
    private static final String COMMENT_END_TAG = "-->";
    private static final String COMMENT_START_TAG = "!--";

    public static void scanHtmlFile(Path file, TagProcessor tagProcessor) throws IOException {
        InputStreamReader isr = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]));
        try (LineNumberReader rdr = new LineNumberReader(isr);){
            String text;
            tagProcessor.startOfFile(file);
            while ((text = rdr.readLine()) != null) {
                Line line = new Line(file, text, rdr.getLineNumber());
                HTMLFileParser.processLine(line, rdr, file, tagProcessor);
            }
            tagProcessor.endOfFile();
        }
    }

    private static void processLine(Line line, LineNumberReader rdr, Path file, TagProcessor tagProcessor) throws IOException {
        if (line == null) {
            return;
        }
        int tagStartIndex = -1;
        int tagNameEndIndex = -1;
        String tagType = null;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c != '<') continue;
            boolean isComment = line.regionMatches(i + 1, COMMENT_START_TAG, 0, 3);
            if (isComment) {
                int start = i + COMMENT_START_TAG.length() + 1;
                TagBlock commentBlock = HTMLFileParser.skipPastCommentEnd(rdr, line, start);
                Line next = commentBlock.remainingText;
                HTMLFileParser.processLine(next, rdr, file, tagProcessor);
                return;
            }
            tagStartIndex = i;
            ScanResult result = HTMLFileParser.getTagName(line, i + 1);
            tagType = result.text;
            if (tagProcessor.isTagSupported(tagType)) {
                tagNameEndIndex = i + tagType.length() + 1;
                break;
            }
            tagStartIndex = -1;
            i = result.lastPosition;
        }
        if (tagStartIndex < 0) {
            tagProcessor.processText(line.text);
            return;
        }
        Line precedingText = line.substring(0, tagStartIndex);
        Line remainingText = line.substring(tagNameEndIndex);
        tagProcessor.processText(precedingText.text);
        TagBlock tagBlock = HTMLFileParser.getTagBody(rdr, remainingText);
        String tagBody = tagBlock.tagContent;
        Line postTagText = tagBlock.remainingText;
        int lineNum = rdr.getLineNumber();
        HTMLFileParser.processTag(tagType, tagBody, file, lineNum, tagProcessor);
        HTMLFileParser.processLine(postTagText, rdr, file, tagProcessor);
    }

    private static TagBlock getTagBody(LineNumberReader rdr, Line line) throws IOException {
        Object tagBody = "";
        int tagEnd = -1;
        while ((tagEnd = line.indexOf('>')) < 0) {
            tagBody = (String)tagBody + line.text + " ";
            String nextLineText = rdr.readLine();
            if (nextLineText == null) {
                line = null;
                break;
            }
            line = new Line(line.file, nextLineText, line.lineNumber);
        }
        if (line != null) {
            tagBody = (String)tagBody + line.substring((int)0, (int)tagEnd).text;
            line = line.substring(tagEnd + 1);
        }
        TagBlock tag = new TagBlock(line, (String)tagBody);
        return tag;
    }

    private static TagBlock skipPastCommentEnd(LineNumberReader rdr, Line line, int start) throws IOException {
        line = line.substring(start);
        Object comment = "";
        while (!line.contains(COMMENT_END_TAG)) {
            comment = (String)comment + line.text + "\n";
            String text = rdr.readLine();
            line = new Line(line.file, text, rdr.getLineNumber());
        }
        int index = line.indexOf(COMMENT_END_TAG, 0);
        if (index >= 0) {
            comment = (String)comment + line.substring((int)0, (int)index).text;
            line = line.substring(index + COMMENT_END_TAG.length());
        }
        TagBlock tag = new TagBlock(line, (String)comment);
        return tag;
    }

    private static ScanResult getTagName(Line line, int index) throws IOException {
        int end = index;
        int i = index;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == '<') {
                throw new IOException("Bad tag on line " + line.lineNumber + ": " + line.file);
            }
            if (c == ' ' || c == '\t' || c == '>') {
                return new ScanResult(line.text.substring(index, i), i);
            }
            ++i;
            ++end;
        }
        if (end > index) {
            return new ScanResult(line.text.substring(index, end), end);
        }
        return null;
    }

    private static String processTag(String tagType, String tagBody, Path file, int lineNum, TagProcessor tagProcessor) throws IOException {
        if (tagBody.indexOf(60) >= 0 || tagBody.indexOf(62) >= 0) {
            throw new IOException("Bad Tag at line " + lineNum);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        StringBuffer buf = new StringBuffer();
        String attr2 = null;
        TagProcessor.TagProcessingState mode = TagProcessor.TagProcessingState.LOOKING_FOR_NEXT_ATTR;
        char term = '\u0000';
        int end = tagBody.length();
        block5: for (int ix = 0; ix < end; ++ix) {
            char c = tagBody.charAt(ix);
            switch (mode) {
                case READING_ATTR: {
                    if (c == '=') {
                        attr2 = buf.toString().toLowerCase();
                        mode = TagProcessor.TagProcessingState.LOOKING_FOR_VALUE;
                        continue block5;
                    }
                    if (c == ' ' || c == '\t') {
                        attr2 = buf.toString().toLowerCase();
                        map.put(attr2, null);
                        mode = TagProcessor.TagProcessingState.LOOKING_FOR_NEXT_ATTR;
                        continue block5;
                    }
                    buf.append(c);
                    continue block5;
                }
                case LOOKING_FOR_VALUE: {
                    if (c == ' ' || c == '\t') continue block5;
                    if (c == '\"' || c == '\'') {
                        buf = new StringBuffer();
                        mode = TagProcessor.TagProcessingState.READING_VALUE;
                        term = c;
                        continue block5;
                    }
                    buf = new StringBuffer();
                    buf.append(c);
                    mode = TagProcessor.TagProcessingState.READING_VALUE;
                    term = '\u0000';
                    continue block5;
                }
                case READING_VALUE: {
                    if (c == term || term == '\u0000' && (c == ' ' || c == '\t')) {
                        map.put(attr2, buf.toString());
                        mode = TagProcessor.TagProcessingState.LOOKING_FOR_NEXT_ATTR;
                        continue block5;
                    }
                    buf.append(c);
                    continue block5;
                }
                default: {
                    if (c == ' ' || c == '\t') continue block5;
                    buf = new StringBuffer();
                    buf.append(c);
                    mode = TagProcessor.TagProcessingState.READING_ATTR;
                }
            }
        }
        if (mode == TagProcessor.TagProcessingState.READING_ATTR) {
            map.put(buf.toString().toLowerCase(), null);
        } else if (mode == TagProcessor.TagProcessingState.LOOKING_FOR_VALUE) {
            map.put(attr2, null);
        } else if (mode == TagProcessor.TagProcessingState.READING_VALUE) {
            map.put(attr2, buf.toString());
        }
        tagProcessor.processTag(tagType, map, file, lineNum);
        buf = new StringBuffer();
        buf.append('<');
        buf.append(tagType);
        for (String attr2 : map.keySet()) {
            String value = map.get(attr2);
            buf.append(' ');
            buf.append(attr2);
            if (value == null) continue;
            buf.append("=\"");
            buf.append(value);
            buf.append("\"");
        }
        buf.append('>');
        return buf.toString();
    }

    private static class Line {
        private Path file;
        private String text;
        private int lineNumber;

        Line(Path file, String text, int lineNumber) {
            this.file = file;
            this.text = text;
            this.lineNumber = lineNumber;
        }

        int indexOf(char c) {
            return this.text.indexOf(c);
        }

        boolean contains(String s) {
            return this.text.contains(s);
        }

        Line substring(int from) {
            return new Line(this.file, this.text.substring(from), this.lineNumber);
        }

        Line substring(int from, int exclusiveEnd) {
            return new Line(this.file, this.text.substring(from, exclusiveEnd), this.lineNumber);
        }

        int indexOf(String s, int from) {
            return this.text.indexOf(s, from);
        }

        boolean regionMatches(int from, String s, int ooffset, int len) {
            return this.text.regionMatches(from, s, ooffset, len);
        }

        char charAt(int i) {
            return this.text.charAt(i);
        }

        int length() {
            return this.text.length();
        }

        public String toString() {
            return "{\n\tfile: " + this.file.getFileName() + ",\n\tline_number: " + this.lineNumber + ",\n\ttext: " + this.text + "\n}";
        }
    }

    private static class TagBlock {
        private Line remainingText;
        private String tagContent;

        TagBlock(Line remainingText, String tagContent) {
            this.remainingText = remainingText;
            this.tagContent = tagContent;
        }

        public String toString() {
            return "{\n\tcontent: " + this.tagContent + ",\n\tpost_text: " + this.remainingText + "\n}";
        }
    }

    private static class ScanResult {
        private String text;
        private int lastPosition;

        ScanResult(String text, int lastPosition) {
            this.text = text;
            this.lastPosition = lastPosition;
        }

        public String toString() {
            return "{\n\ttext: " + this.text + ",\n\tlast_position: " + this.lastPosition + "\n}";
        }
    }
}

