/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.trace.database.program.AbstractDBTraceProgramViewListing;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import java.util.Iterator;

public class DBTraceProgramViewFragment
implements ProgramFragment {
    protected final AbstractDBTraceProgramViewListing listing;
    protected final TraceMemoryRegion region;

    public DBTraceProgramViewFragment(AbstractDBTraceProgramViewListing listing, TraceMemoryRegion region) {
        this.listing = listing;
        this.region = region;
    }

    public String getComment() {
        return "";
    }

    public void setComment(String comment) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.region.getName();
    }

    public void setName(String name) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public int getNumParents() {
        return 1;
    }

    public ProgramModule[] getParents() {
        return new ProgramModule[]{this.listing.rootModule};
    }

    public String[] getParentNames() {
        return new String[]{"Trace Tree"};
    }

    public String getTreeName() {
        return "Trace Tree";
    }

    public boolean contains(Address addr) {
        return this.region.getRange().contains(addr) && this.region.getLifespan().contains((Comparable)Long.valueOf(this.listing.program.snap));
    }

    public boolean contains(Address start, Address end) {
        AddressRange range = this.region.getRange();
        return range.contains(start) && range.contains(end) && this.region.getLifespan().contains((Comparable)Long.valueOf(this.listing.program.snap));
    }

    public boolean contains(AddressSetView rangeSet) {
        if (!this.region.getLifespan().contains((Comparable)Long.valueOf(this.listing.program.snap))) {
            return false;
        }
        for (AddressRange range : rangeSet) {
            AddressRange regionRange = this.region.getRange();
            if (regionRange.contains(range.getMinAddress()) && regionRange.contains(range.getMaxAddress())) continue;
            return false;
        }
        return true;
    }

    protected AddressSet toAddressSet() {
        return new AddressSet(this.region.getMinAddress(), this.region.getMaxAddress());
    }

    public boolean isEmpty() {
        return false;
    }

    public Address getMinAddress() {
        return this.region.getMinAddress();
    }

    public Address getMaxAddress() {
        return this.region.getMaxAddress();
    }

    public int getNumAddressRanges() {
        return 1;
    }

    public AddressRangeIterator getAddressRanges() {
        return this.toAddressSet().getAddressRanges();
    }

    public AddressRangeIterator getAddressRanges(boolean forward) {
        return this.toAddressSet().getAddressRanges(forward);
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return this.toAddressSet().getAddressRanges(start, forward);
    }

    public Iterator<AddressRange> iterator() {
        return this.toAddressSet().iterator();
    }

    public Iterator<AddressRange> iterator(boolean forward) {
        return this.toAddressSet().iterator(forward);
    }

    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.toAddressSet().iterator(start, forward);
    }

    public long getNumAddresses() {
        return this.toAddressSet().getNumAddresses();
    }

    public AddressIterator getAddresses(boolean forward) {
        return this.toAddressSet().getAddresses(forward);
    }

    public AddressIterator getAddresses(Address start, boolean forward) {
        return this.toAddressSet().getAddresses(start, forward);
    }

    public boolean intersects(AddressSetView addrSet) {
        return this.toAddressSet().intersects(addrSet);
    }

    public boolean intersects(Address start, Address end) {
        return this.toAddressSet().intersects(start, end);
    }

    public AddressSet intersect(AddressSetView view) {
        return this.toAddressSet().intersect(view);
    }

    public AddressSet intersectRange(Address start, Address end) {
        return this.toAddressSet().intersectRange(start, end);
    }

    public AddressSet union(AddressSetView addrSet) {
        return this.toAddressSet().union(addrSet);
    }

    public AddressSet subtract(AddressSetView addrSet) {
        return this.toAddressSet().subtract(addrSet);
    }

    public AddressSet xor(AddressSetView addrSet) {
        return this.toAddressSet().xor(addrSet);
    }

    public boolean hasSameAddresses(AddressSetView view) {
        return this.toAddressSet().hasSameAddresses(view);
    }

    public AddressRange getFirstRange() {
        return new AddressRangeImpl(this.region.getMinAddress(), this.region.getMaxAddress());
    }

    public AddressRange getLastRange() {
        return new AddressRangeImpl(this.region.getMinAddress(), this.region.getMaxAddress());
    }

    public AddressRange getRangeContaining(Address address) {
        if (this.contains(address)) {
            return this.getFirstRange();
        }
        return null;
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        return this.toAddressSet().findFirstAddressInCommon(set);
    }

    public boolean contains(CodeUnit codeUnit) {
        return this.contains(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
    }

    public CodeUnitIterator getCodeUnits() {
        return this.listing.getCodeUnits((AddressSetView)this.toAddressSet(), true);
    }

    public void move(Address min, Address max) throws NotFoundException {
        throw new UnsupportedOperationException();
    }
}

