/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.guest;

import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.database.guest.DBTraceGuestPlatform;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbolView;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.List;

public interface InternalTracePlatform
extends TracePlatform {
    public static final String REG_MAP_BE = "__reg_map_be__";
    public static final String REG_MAP_LE = "__reg_map_le__";

    public static String regMap(Register register) {
        return register.isBigEndian() ? REG_MAP_BE : REG_MAP_LE;
    }

    public int getIntKey();

    public DBTraceGuestPlatform.DBTraceGuestLanguage getLanguageEntry();

    @Override
    default public AddressRange getConventionalRegisterRange(AddressSpace space, Register register) {
        AddressRange result = this.mapGuestToHost(TraceRegisterUtils.rangeForRegister(register));
        if (result == null) {
            throw new IllegalArgumentException("Register " + register + " is not mapped");
        }
        if (space == null) {
            return result;
        }
        if (register.getAddressSpace().isRegisterSpace()) {
            if (result.getAddressSpace() != space.getPhysicalSpace()) {
                throw new IllegalArgumentException("Register " + register + " does not map to space " + space + "'s physical space (" + space.getPhysicalSpace() + ")");
            }
            return new AddressRangeImpl(space.getOverlayAddress(result.getMinAddress()), space.getOverlayAddress(result.getMaxAddress()));
        }
        if (result.getAddressSpace() != space) {
            throw new IllegalArgumentException("Memory-mapped register " + register + " does not map to space " + space);
        }
        return result;
    }

    @Override
    default public String getConventionalRegisterObjectName(Register register) {
        Address pmin = this.mapGuestToHost(register.getAddress());
        if (pmin == null) {
            return register.getName();
        }
        TraceSymbolManager symbolManager = this.getTrace().getSymbolManager();
        TraceNamespaceSymbol nsRegMap = (TraceNamespaceSymbol)symbolManager.namespaces().getGlobalNamed(InternalTracePlatform.regMap(register));
        List<TraceLabelSymbol> labels = symbolManager.labels().getAt(0L, null, pmin, false).stream().filter(s -> s.getParentNamespace() == nsRegMap).toList();
        if (labels.isEmpty()) {
            return register.getName();
        }
        return ((TraceLabelSymbol)labels.iterator().next()).getName();
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(TargetObjectSchema schema, List<String> path, Register register) {
        PathMatcher matcher = schema.searchFor(TargetRegister.class, path, true);
        if (matcher.isEmpty()) {
            return matcher;
        }
        String name = this.getConventionalRegisterObjectName(register);
        return matcher.applyKeys(PathPredicates.Align.RIGHT, List.of(name));
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(TraceObject container, Register register) {
        return this.getConventionalRegisterPath(container.getTargetSchema(), container.getCanonicalPath().getKeyList(), register);
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(TargetObject container, Register register) {
        return this.getConventionalRegisterPath(container.getSchema(), container.getPath(), register);
    }

    @Override
    default public PathMatcher getConventionalRegisterPath(AddressSpace space, Register register) {
        List path = PathUtils.parse((String)space.getName());
        TargetObjectSchema rootSchema = this.getTrace().getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return null;
        }
        TargetObjectSchema schema = rootSchema.getSuccessorSchema(path);
        return this.getConventionalRegisterPath(schema, path, register);
    }

    @Override
    default public TraceLabelSymbol addRegisterMapOverride(Register register, String objectName) {
        TraceLabelSymbol traceLabelSymbol;
        block10: {
            Address hostAddr = this.mapGuestToHost(register.getAddress());
            if (hostAddr == null) {
                throw new IllegalStateException("Given register is not mapped to the host, or it's not in the guest language");
            }
            LockHold hold = this.getTrace().lockWrite();
            try {
                TraceSymbolManager symbolManager = this.getTrace().getSymbolManager();
                TraceNamespaceSymbol globals = symbolManager.getGlobalNamespace();
                TraceNamespaceSymbolView namespaces = symbolManager.namespaces();
                String regMap = InternalTracePlatform.regMap(register);
                TraceNamespaceSymbol nsRegMap = (TraceNamespaceSymbol)namespaces.getGlobalNamed(regMap);
                if (nsRegMap == null) {
                    nsRegMap = namespaces.add(regMap, globals, SourceType.USER_DEFINED);
                }
                traceLabelSymbol = symbolManager.labels().create(0L, null, hostAddr, objectName, nsRegMap, SourceType.USER_DEFINED);
                if (hold == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateNameException | InvalidInputException e) {
                    throw new AssertionError();
                }
            }
            hold.close();
        }
        return traceLabelSymbol;
    }

    default public AddressRange getRegistersRange() {
        Language language = this.getLanguage();
        AddressSpace regSpace = language.getAddressFactory().getRegisterSpace();
        AddressSetView regAddrs = language.getRegisterAddresses();
        AddressIterator minIt = regAddrs.getAddresses(regSpace.getMinAddress(), true);
        if (!minIt.hasNext()) {
            return null;
        }
        AddressIterator maxIt = regAddrs.getAddresses(regSpace.getMaxAddress(), false);
        return new AddressRangeImpl(minIt.next(), maxIt.next());
    }
}

