/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import com.google.common.collect.Collections2;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.EnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import ghidra.app.plugin.core.debug.gui.time.SnapshotRow;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DebuggerSnapshotTablePanel
extends JPanel {
    protected final EnumeratedColumnTableModel<SnapshotRow> snapshotTableModel;
    protected final GTable snapshotTable;
    protected final GhidraTableFilterPanel<SnapshotRow> snapshotFilterPanel;
    protected boolean hideScratch = true;
    private Trace currentTrace;
    private Long currentSnap;
    protected final SnapshotListener listener = new SnapshotListener();

    public DebuggerSnapshotTablePanel(PluginTool tool) {
        super(new BorderLayout());
        this.snapshotTableModel = new DefaultEnumeratedColumnTableModel(tool, "Snapshots", SnapshotTableColumns.class);
        this.snapshotTable = new GTable(this.snapshotTableModel);
        this.snapshotTable.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.snapshotTable));
        this.snapshotFilterPanel = new GhidraTableFilterPanel((JTable)this.snapshotTable, this.snapshotTableModel);
        this.add((Component)this.snapshotFilterPanel, "South");
        TableColumnModel columnModel = this.snapshotTable.getColumnModel();
        TableColumn snapCol = columnModel.getColumn(SnapshotTableColumns.SNAP.ordinal());
        snapCol.setPreferredWidth(40);
        TableColumn timeCol = columnModel.getColumn(SnapshotTableColumns.TIMESTAMP.ordinal());
        timeCol.setPreferredWidth(200);
        TableColumn etCol = columnModel.getColumn(SnapshotTableColumns.EVENT_THREAD.ordinal());
        etCol.setPreferredWidth(40);
        TableColumn schdCol = columnModel.getColumn(SnapshotTableColumns.SCHEDULE.ordinal());
        schdCol.setPreferredWidth(60);
        TableColumn descCol = columnModel.getColumn(SnapshotTableColumns.DESCRIPTION.ordinal());
        descCol.setPreferredWidth(200);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.listener);
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.listener);
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadSnapshots();
    }

    public Trace getTrace() {
        return this.currentTrace;
    }

    public void setHideScratchSnapshots(boolean hideScratch) {
        if (this.hideScratch == hideScratch) {
            return;
        }
        this.hideScratch = hideScratch;
        if (hideScratch) {
            this.deleteScratchSnapshots();
        } else {
            this.loadScratchSnapshots();
        }
    }

    protected void loadSnapshots() {
        this.snapshotTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceTimeManager manager = this.currentTrace.getTimeManager();
        Collection snapshots = this.hideScratch ? manager.getSnapshots(0L, true, Long.MAX_VALUE, true) : manager.getAllSnapshots();
        this.snapshotTableModel.addAll(Collections2.transform((Collection)snapshots, s -> new SnapshotRow(this.currentTrace, (TraceSnapshot)s)));
    }

    protected void deleteScratchSnapshots() {
        this.snapshotTableModel.deleteWith(s -> s.getSnap() < 0L);
    }

    protected void loadScratchSnapshots() {
        if (this.currentTrace == null) {
            return;
        }
        TraceTimeManager manager = this.currentTrace.getTimeManager();
        this.snapshotTableModel.addAll(Collections2.transform((Collection)manager.getSnapshots(Long.MIN_VALUE, true, 0L, false), s -> new SnapshotRow(this.currentTrace, (TraceSnapshot)s)));
    }

    public ListSelectionModel getSelectionModel() {
        return this.snapshotTable.getSelectionModel();
    }

    public Long getSelectedSnapshot() {
        SnapshotRow row = (SnapshotRow)this.snapshotFilterPanel.getSelectedItem();
        return row == null ? null : Long.valueOf(row.getSnap());
    }

    public void setSelectedSnapshot(Long snap) {
        Long curSnap;
        this.currentSnap = snap;
        if (snap == null) {
            this.snapshotTable.clearSelection();
            return;
        }
        SnapshotRow sel = (SnapshotRow)this.snapshotFilterPanel.getSelectedItem();
        Long l = curSnap = sel == null ? null : Long.valueOf(sel.getSnap());
        if (Objects.equals(curSnap, snap)) {
            return;
        }
        SnapshotRow row = (SnapshotRow)this.snapshotTableModel.findFirst(r -> r.getSnap() == snap.longValue());
        if (row == null) {
            this.snapshotTable.clearSelection();
            return;
        }
        this.snapshotFilterPanel.setSelectedItem((Object)row);
    }

    private class SnapshotListener
    extends TraceDomainObjectListener {
        public SnapshotListener() {
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.ADDED, this::snapAdded);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.CHANGED, this::snapChanged);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.DELETED, this::snapDeleted);
        }

        private void objectRestored() {
            DebuggerSnapshotTablePanel.this.loadSnapshots();
        }

        private void snapAdded(TraceSnapshot snapshot) {
            if (snapshot.getKey() < 0L && DebuggerSnapshotTablePanel.this.hideScratch) {
                return;
            }
            SnapshotRow row = new SnapshotRow(DebuggerSnapshotTablePanel.this.currentTrace, snapshot);
            DebuggerSnapshotTablePanel.this.snapshotTableModel.add((Object)row);
            if (DebuggerSnapshotTablePanel.this.currentSnap.longValue() == snapshot.getKey()) {
                DebuggerSnapshotTablePanel.this.snapshotFilterPanel.setSelectedItem((Object)row);
            }
        }

        private void snapChanged(TraceSnapshot snapshot) {
            if (snapshot.getKey() < 0L && DebuggerSnapshotTablePanel.this.hideScratch) {
                return;
            }
            DebuggerSnapshotTablePanel.this.snapshotTableModel.notifyUpdatedWith(row -> row.getSnapshot() == snapshot);
        }

        private void snapDeleted(TraceSnapshot snapshot) {
            if (snapshot.getKey() < 0L && DebuggerSnapshotTablePanel.this.hideScratch) {
                return;
            }
            DebuggerSnapshotTablePanel.this.snapshotTableModel.deleteWith(row -> row.getSnapshot() == snapshot);
        }
    }

    protected static enum SnapshotTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<SnapshotTableColumns, SnapshotRow>
    {
        SNAP("Snap", Long.class, SnapshotRow::getSnap),
        TIMESTAMP("Timestamp", String.class, SnapshotRow::getTimeStamp),
        EVENT_THREAD("Event Thread", String.class, SnapshotRow::getEventThreadName),
        SCHEDULE("Schedule", String.class, SnapshotRow::getSchedule),
        DESCRIPTION("Description", String.class, SnapshotRow::getDescription, SnapshotRow::setDescription);

        private final String header;
        private final Function<SnapshotRow, ?> getter;
        private final BiConsumer<SnapshotRow, Object> setter;
        private final Class<?> cls;

        private <T> SnapshotTableColumns(String header, Class<T> cls, Function<SnapshotRow, T> getter) {
            this(header, cls, getter, null);
        }

        private <T> SnapshotTableColumns(String header, Class<T> cls, Function<SnapshotRow, T> getter, BiConsumer<SnapshotRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(SnapshotRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(SnapshotRow row) {
            return this.setter != null;
        }

        public void setValueOf(SnapshotRow row, Object value) {
            this.setter.accept(row, value);
        }
    }
}

