/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.LocationTracker;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public enum PCByStackLocationTrackingSpec implements LocationTrackingSpec,
LocationTracker
{
    INSTANCE;

    public static final String CONFIG_NAME = "TRACK_PC_BY_STACK";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Track Program Counter (by Stack)";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.TrackLocationAction.ICON_PC_BY_STACK;
    }

    @Override
    public String computeTitle(DebuggerCoordinates coordinates) {
        return "Stack's PC";
    }

    @Override
    public LocationTracker getTracker() {
        return this;
    }

    public Address doComputeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        TraceThread thread = coordinates.getThread();
        long snap = coordinates.getSnap();
        TraceStack stack = trace.getStackManager().getLatestStack(thread, snap);
        if (stack == null) {
            return null;
        }
        int level = coordinates.getFrame();
        TraceStackFrame frame = stack.getFrame(level, false);
        if (frame == null) {
            return null;
        }
        return frame.getProgramCounter(snap);
    }

    @Override
    public CompletableFuture<Address> computeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates) {
        return CompletableFuture.supplyAsync(() -> this.doComputeTraceAddress(tool, coordinates));
    }

    @Override
    public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        if (stack.getThread() != coordinates.getThread()) {
            return false;
        }
        if (!coordinates.getTime().isSnapOnly()) {
            return false;
        }
        TraceStack curStack = coordinates.getTrace().getStackManager().getLatestStack(stack.getThread(), coordinates.getSnap());
        return stack == curStack;
    }

    @Override
    public boolean affectedByBytesChange(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
        return false;
    }
}

