/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.List;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class AnnotationSetRefList
extends Item<AnnotationSetRefList> {
    private int hashCode = 0;
    private AnnotationSetItem[] annotationSets;

    protected AnnotationSetRefList(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationSetRefList(DexFile dexFile, AnnotationSetItem[] annotationSets) {
        super(dexFile);
        this.annotationSets = annotationSets;
    }

    public static AnnotationSetRefList internAnnotationSetRefList(DexFile dexFile, List<AnnotationSetItem> annotationSets) {
        AnnotationSetItem[] annotationSetsArray = new AnnotationSetItem[annotationSets.size()];
        annotationSets.toArray(annotationSetsArray);
        AnnotationSetRefList annotationSetRefList = new AnnotationSetRefList(dexFile, annotationSetsArray);
        return dexFile.AnnotationSetRefListsSection.intern(annotationSetRefList);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.annotationSets = new AnnotationSetItem[in.readInt()];
        for (int i = 0; i < this.annotationSets.length; ++i) {
            this.annotationSets[i] = (AnnotationSetItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, in.readInt());
        }
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 4 + this.annotationSets.length * 4;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate(4, "size: 0x" + Integer.toHexString(this.annotationSets.length) + " (" + this.annotationSets.length + ")");
            for (AnnotationSetItem annotationSetItem : this.annotationSets) {
                out.annotate(4, "annotation_set_off: 0x" + Integer.toHexString(annotationSetItem.getOffset()));
            }
        }
        out.writeInt(this.annotationSets.length);
        for (AnnotationSetItem annotationSetItem : this.annotationSets) {
            out.writeInt(annotationSetItem.getOffset());
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATION_SET_REF_LIST;
    }

    @Override
    public String getConciseIdentity() {
        return "annotation_set_item @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(AnnotationSetRefList o) {
        int comp = this.annotationSets.length - o.annotationSets.length;
        if (comp != 0) {
            return comp;
        }
        for (int i = 0; i < this.annotationSets.length; ++i) {
            comp = this.annotationSets[i].compareTo(o.annotationSets[i]);
            if (comp == 0) continue;
            return comp;
        }
        return comp;
    }

    public AnnotationSetItem[] getAnnotationSets() {
        return this.annotationSets;
    }

    private void calcHashCode() {
        this.hashCode = 0;
        for (AnnotationSetItem annotationSetItem : this.annotationSets) {
            this.hashCode = this.hashCode * 31 + annotationSetItem.hashCode();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AnnotationSetRefList other = (AnnotationSetRefList)o;
        return this.compareTo(other) == 0;
    }
}

