/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Row<V> {
    public int y = -1;
    public int height = -1;
    public int index = Integer.MAX_VALUE;
    private TreeMap<Integer, V> verticesByColumn = new TreeMap();
    private Map<V, Integer> columnsByVertex = new HashMap<V, Integer>();

    Row() {
    }

    Row(int index) {
        this.index = index;
    }

    public void setColumn(V v, int col) {
        this.columnsByVertex.put((Integer)v, col);
        this.verticesByColumn.put(col, v);
    }

    public int getColumn(V v) {
        if (!this.columnsByVertex.containsKey(v)) {
            throw new IllegalArgumentException("Vertex is not in row: " + v);
        }
        return this.columnsByVertex.get(v);
    }

    public V getVertex(int column) {
        return this.verticesByColumn.get(column);
    }

    public int getColumnCount() {
        if (this.verticesByColumn.isEmpty()) {
            return 0;
        }
        Integer largestColumn = this.verticesByColumn.lastKey();
        Integer smallestColumn = this.verticesByColumn.firstKey();
        int diff = Math.abs(largestColumn - smallestColumn);
        return diff + 1;
    }

    public Integer getStartColumn() {
        return this.verticesByColumn.firstKey();
    }

    public int getEndColumn() {
        return this.verticesByColumn.lastKey();
    }

    public List<V> getVertices() {
        Integer start = this.verticesByColumn.firstKey();
        Integer n = this.getColumnCount();
        IntStream columnIndexes = IntStream.range(start, start + n);
        List vertices = columnIndexes.mapToObj(col -> this.verticesByColumn.get(col)).filter(v -> v != null).collect(Collectors.toList());
        return vertices;
    }

    public int getPaddedHeight(boolean isCondensed) {
        if (!isCondensed) {
            return this.height + 50;
        }
        if (this.height == 0) {
            return 0;
        }
        return this.height + 25;
    }

    public boolean isInitialized() {
        return this.y > -1 && this.height > -1 && this.index > Integer.MAX_VALUE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{\n\trow: " + this.index + ",\n\ty: " + this.y + ",\n\theight: " + this.height + ",\n\tpadded height: " + this.getPaddedHeight(false) + ",\n\tcolumn count: " + this.getColumnCount() + "\n}";
    }

    void dispose() {
        this.verticesByColumn.clear();
        this.columnsByVertex.clear();
    }
}

