/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeMnemonicSettingsDefinition;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.data.Integer16DataType;
import ghidra.program.model.data.Integer3DataType;
import ghidra.program.model.data.Integer5DataType;
import ghidra.program.model.data.Integer6DataType;
import ghidra.program.model.data.Integer7DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.PaddingSettingsDefinition;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.SignedByteDataType;
import ghidra.program.model.data.SignedDWordDataType;
import ghidra.program.model.data.SignedQWordDataType;
import ghidra.program.model.data.SignedWordDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.StringRenderParser;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.UnsignedInteger16DataType;
import ghidra.program.model.data.UnsignedInteger3DataType;
import ghidra.program.model.data.UnsignedInteger5DataType;
import ghidra.program.model.data.UnsignedInteger6DataType;
import ghidra.program.model.data.UnsignedInteger7DataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.DataConverter;
import ghidra.util.StringFormat;
import java.math.BigInteger;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;

public abstract class AbstractIntegerDataType
extends BuiltIn
implements ArrayStringable {
    static final String C_SIGNED_CHAR = "signed char";
    static final String C_UNSIGNED_CHAR = "unsigned char";
    static final String C_SIGNED_SHORT = "short";
    static final String C_UNSIGNED_SHORT = "unsigned short";
    static final String C_SIGNED_INT = "int";
    static final String C_UNSIGNED_INT = "unsigned int";
    static final String C_SIGNED_LONG = "long";
    static final String C_UNSIGNED_LONG = "unsigned long";
    static final String C_SIGNED_LONGLONG = "long long";
    static final String C_UNSIGNED_LONGLONG = "unsigned long long";
    protected static final PaddingSettingsDefinition PADDING = PaddingSettingsDefinition.DEF;
    protected static final EndianSettingsDefinition ENDIAN = EndianSettingsDefinition.DEF;
    protected static final DataTypeMnemonicSettingsDefinition MNEMONIC = DataTypeMnemonicSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{FormatSettingsDefinition.DEF_HEX, PADDING, ENDIAN, MNEMONIC};
    private final boolean signed;
    private static AbstractIntegerDataType[] signedTypes;
    private static AbstractIntegerDataType[] unsignedTypes;

    public AbstractIntegerDataType(String name, boolean signed, DataTypeManager dtm) {
        super(null, name, dtm);
        this.signed = signed;
    }

    protected FormatSettingsDefinition getFormatSettingsDefinition() {
        return FormatSettingsDefinition.DEF_HEX;
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    public boolean isSigned() {
        return this.signed;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.name.toUpperCase();
    }

    @Override
    public String getMnemonic(Settings settings) {
        int mnemonicStyle = MNEMONIC.getMnemonicStyle(settings);
        if (mnemonicStyle == 1) {
            return this.getAssemblyMnemonic();
        }
        if (mnemonicStyle == 2) {
            return this.getCMnemonic();
        }
        return this.name;
    }

    public String getAssemblyMnemonic() {
        return this.name;
    }

    public String getCMnemonic() {
        String str = this.getCDeclaration();
        return str != null ? str : this.name;
    }

    public String getCDeclaration() {
        int size = this.getLength();
        if (size <= 0) {
            return null;
        }
        DataOrganization dataOrganization = this.getDataOrganization();
        if (size == dataOrganization.getCharSize()) {
            return this.signed ? C_SIGNED_CHAR : C_UNSIGNED_CHAR;
        }
        if (size == dataOrganization.getIntegerSize()) {
            return this.signed ? C_SIGNED_INT : C_UNSIGNED_INT;
        }
        if (size == dataOrganization.getShortSize()) {
            return this.signed ? C_SIGNED_SHORT : C_UNSIGNED_SHORT;
        }
        if (size == dataOrganization.getLongSize()) {
            return this.signed ? C_SIGNED_LONG : C_UNSIGNED_LONG;
        }
        if (size == dataOrganization.getLongLongSize()) {
            return this.signed ? C_SIGNED_LONGLONG : C_UNSIGNED_LONGLONG;
        }
        return null;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        int size = this.getLength();
        if (size <= 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, 0) != size) {
            return null;
        }
        DataConverter dc = DataConverter.getInstance((boolean)ENDIAN.isBigEndian(settings, buf));
        if (size > 8) {
            return dc.getBigInteger(bytes, size, this.isSigned());
        }
        long val = dc.getValue(bytes, size);
        return new Scalar(size * 8, val, this.isSigned());
    }

    protected static int getBitCount(Class<? extends Number> type) {
        if (type == Byte.class) {
            return 8;
        }
        if (type == Short.class) {
            return 16;
        }
        if (type == Integer.class) {
            return 32;
        }
        if (type == Long.class) {
            return 64;
        }
        throw new AssertionError();
    }

    protected BigInteger castValueToEncode(Object value) throws DataTypeEncodeException {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Scalar) {
            return ((Scalar)value).getBigInteger();
        }
        if (value instanceof Character) {
            int numeric = Character.getNumericValue(((Character)value).charValue());
            if (numeric < 0) {
                throw new DataTypeEncodeException("Character cannot be converted to number", value, this);
            }
            return BigInteger.valueOf(numeric);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            Number number = (Number)value;
            BigInteger signedVal = BigInteger.valueOf(number.longValue());
            if (this.isSigned() || signedVal.signum() >= 0) {
                return signedVal;
            }
            return signedVal.add(BigInteger.ONE.shiftLeft(AbstractIntegerDataType.getBitCount(number.getClass())));
        }
        throw new DataTypeEncodeException("Unsupported value type", value, this);
    }

    @Override
    public boolean isEncodable() {
        return true;
    }

    @Override
    public byte[] encodeValue(Object value, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        BigInteger minValueInclusive;
        if (length == -1) {
            length = this.getLength();
        }
        if (length != this.getLength()) {
            throw new DataTypeEncodeException("Length mismatch", value, this);
        }
        BigInteger bigValue = this.castValueToEncode(value);
        if (bigValue.signum() == -1 && !this.isSigned()) {
            throw new DataTypeEncodeException("Unsigned type cannot have negative value", value, this);
        }
        BigInteger maxValueExclusive = BigInteger.ONE.shiftLeft(length * 8 - (this.isSigned() ? 1 : 0));
        BigInteger bigInteger = minValueInclusive = this.isSigned() ? BigInteger.ONE.shiftLeft(length * 8 - 1).negate() : BigInteger.ZERO;
        if (bigValue.compareTo(maxValueExclusive) >= 0) {
            throw new DataTypeEncodeException("Value is too large", bigValue, this);
        }
        if (minValueInclusive.compareTo(bigValue) > 0) {
            throw new DataTypeEncodeException("Value is too small", bigValue, this);
        }
        return Utils.bigIntegerToBytes(bigValue, length, ENDIAN.isBigEndian(settings, buf));
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        if (this.getLength() > 8) {
            return BigInteger.class;
        }
        return Scalar.class;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        int size = this.getLength();
        if (size <= 0 && (size = length) <= 0) {
            return "??";
        }
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, 0) != size) {
            return "??";
        }
        BigInteger value = DataConverter.getInstance((boolean)ENDIAN.isBigEndian(settings, buf)).getBigInteger(bytes, size, true);
        if (this.getFormatSettingsDefinition().getFormat(settings) == 4) {
            return StringDataInstance.getCharRepresentation(this, bytes, settings);
        }
        return this.getRepresentation(value, settings, 8 * length);
    }

    String getRepresentation(BigInteger bigInt, Settings settings, int bitLength) {
        int nominalLen;
        Object valStr;
        boolean negative;
        int format = this.getFormatSettingsDefinition().getFormat(settings);
        boolean padded = PADDING.isPadded(settings);
        boolean bl = negative = bigInt.signum() < 0;
        if (negative && (!this.signed || format != 1)) {
            bigInt = bigInt.add(BigInteger.valueOf(2L).pow(bitLength));
        }
        switch (format) {
            default: {
                valStr = bigInt.toString(16).toUpperCase() + "h";
                nominalLen = (bitLength + 3) / 4;
                break;
            }
            case 1: {
                return bigInt.toString(10);
            }
            case 2: {
                valStr = bigInt.toString(2) + "b";
                nominalLen = bitLength;
                break;
            }
            case 3: {
                valStr = bigInt.toString(8) + "o";
                nominalLen = (bitLength + 2) / 3;
            }
        }
        if (padded) {
            valStr = StringFormat.padIt((String)valStr, (int)(nominalLen + 1), (char)'\u0000', (boolean)true);
        }
        return valStr;
    }

    @Override
    public byte[] encodeRepresentation(String repr, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        BigInteger umax;
        BigInteger smax;
        BigInteger value;
        String suffix;
        int radix;
        int format = this.getFormatSettingsDefinition().getFormat(settings);
        switch (format) {
            case 4: {
                StringDataInstance sdi = StringDataInstance.getStringDataInstance(this, buf, settings, this.getLength());
                try {
                    return sdi.encodeReplacementFromCharRepresentation(repr);
                }
                catch (StringRenderParser.StringParseException | MalformedInputException | UnmappableCharacterException e) {
                    throw new DataTypeEncodeException((Object)repr, this, (Throwable)e);
                }
            }
            case 0: {
                radix = 16;
                suffix = "h";
                break;
            }
            case 1: {
                radix = 10;
                suffix = "";
                break;
            }
            case 2: {
                radix = 2;
                suffix = "b";
                break;
            }
            case 3: {
                radix = 8;
                suffix = "o";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (!repr.endsWith(suffix)) {
            throw new DataTypeEncodeException("value must have " + suffix + " suffix", repr, this);
        }
        try {
            value = new BigInteger(repr.substring(0, repr.length() - suffix.length()), radix);
        }
        catch (Exception e) {
            throw new DataTypeEncodeException((Object)repr, this, e);
        }
        if (format != 1 && this.isSigned() && (smax = (umax = BigInteger.ONE.shiftLeft(8 * length)).shiftRight(1)).compareTo(value) <= 0 && value.compareTo(umax) < 0) {
            value = value.subtract(umax);
        }
        return this.encodeValue(value, buf, settings, length);
    }

    @Override
    public boolean hasStringValue(Settings settings) {
        int format = this.getFormatSettingsDefinition().getFormat(settings);
        return format == 4;
    }

    @Override
    public String getArrayDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        if (this.hasStringValue(settings) && buf.isInitializedMemory()) {
            return new StringDataInstance(this, settings, buf, len, true).getLabel("s_", "STR", "STRING", options);
        }
        return null;
    }

    @Override
    public String getArrayDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutOffset) {
        if (this.hasStringValue(settings) && buf.isInitializedMemory()) {
            return new StringDataInstance(this, settings, buf, len, true).getOffcutLabelString("s_", "STR", "STRING", options, offcutOffset);
        }
        return null;
    }

    public abstract AbstractIntegerDataType getOppositeSignednessDataType();

    @Override
    public boolean isEquivalent(DataType dt) {
        return dt.getClass().equals(this.getClass());
    }

    private static AbstractIntegerDataType[] getSignedTypes() {
        if (signedTypes == null) {
            signedTypes = new AbstractIntegerDataType[]{SignedByteDataType.dataType, SignedWordDataType.dataType, Integer3DataType.dataType, SignedDWordDataType.dataType, Integer5DataType.dataType, Integer6DataType.dataType, Integer7DataType.dataType, SignedQWordDataType.dataType, Integer16DataType.dataType};
        }
        return signedTypes;
    }

    private static AbstractIntegerDataType[] getUnsignedTypes() {
        if (unsignedTypes == null) {
            unsignedTypes = new AbstractIntegerDataType[]{ByteDataType.dataType, WordDataType.dataType, UnsignedInteger3DataType.dataType, DWordDataType.dataType, UnsignedInteger5DataType.dataType, UnsignedInteger6DataType.dataType, UnsignedInteger7DataType.dataType, QWordDataType.dataType, UnsignedInteger16DataType.dataType};
        }
        return unsignedTypes;
    }

    public static DataType getSignedDataType(int size, DataTypeManager dtm) {
        DataOrganization dataOrganization;
        if (size < 1) {
            return DefaultDataType.dataType;
        }
        if (size == 16) {
            return Integer16DataType.dataType;
        }
        if (size > 8) {
            return new ArrayDataType(SignedByteDataType.dataType, size, 1);
        }
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            if (size == dataOrganization.getIntegerSize()) {
                return IntegerDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getShortSize()) {
                return ShortDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongSize()) {
                return LongDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongLongSize()) {
                return LongLongDataType.dataType.clone(dtm);
            }
        }
        return AbstractIntegerDataType.getSignedTypes()[size - 1];
    }

    public static AbstractIntegerDataType[] getSignedDataTypes(DataTypeManager dtm) {
        DataOrganization dataOrganization;
        AbstractIntegerDataType[] dataTypes = (AbstractIntegerDataType[])AbstractIntegerDataType.getSignedTypes().clone();
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            int index = dataOrganization.getLongLongSize() - 1;
            if (index >= 0 && index < 8) {
                dataTypes[index] = LongLongDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getLongSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = LongDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getShortSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = ShortDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getIntegerSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = IntegerDataType.dataType.clone(dtm);
            }
        }
        return dataTypes;
    }

    public static DataType getUnsignedDataType(int size, DataTypeManager dtm) {
        DataOrganization dataOrganization;
        if (size < 1) {
            return DefaultDataType.dataType;
        }
        if (size == 16) {
            return UnsignedInteger16DataType.dataType;
        }
        if (size > 8) {
            return Undefined.getUndefinedDataType(size);
        }
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            if (size == dataOrganization.getIntegerSize()) {
                return UnsignedIntegerDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getShortSize()) {
                return UnsignedShortDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongSize()) {
                return UnsignedLongDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongLongSize()) {
                return UnsignedLongLongDataType.dataType.clone(dtm);
            }
        }
        return AbstractIntegerDataType.getUnsignedTypes()[size - 1];
    }

    public static AbstractIntegerDataType[] getUnsignedDataTypes(DataTypeManager dtm) {
        DataOrganization dataOrganization;
        AbstractIntegerDataType[] dataTypes = (AbstractIntegerDataType[])AbstractIntegerDataType.getUnsignedTypes().clone();
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            int index = dataOrganization.getLongLongSize() - 1;
            if (index >= 0 && index < 8) {
                dataTypes[index] = UnsignedLongLongDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getLongSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = UnsignedLongDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getShortSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = UnsignedShortDataType.dataType.clone(dtm);
            }
            if ((index = dataOrganization.getIntegerSize() - 1) >= 0 && index < 8) {
                dataTypes[index] = UnsignedIntegerDataType.dataType.clone(dtm);
            }
        }
        return dataTypes;
    }
}

