/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class GlobalSymbol
implements Symbol {
    private GlobalNamespace globalNamespace;

    GlobalSymbol(GlobalNamespace globalNamespace) {
        this.globalNamespace = globalNamespace;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public Address getAddress() {
        return Address.NO_ADDRESS;
    }

    @Override
    public Program getProgram() {
        return this.globalNamespace.memory.getProgram();
    }

    @Override
    public String getName() {
        return "global";
    }

    @Override
    public String getName(boolean includeNamespace) {
        return this.getName();
    }

    @Override
    public String[] getPath() {
        return new String[0];
    }

    @Override
    public Namespace getParentNamespace() {
        return null;
    }

    @Override
    public Symbol getParentSymbol() {
        return null;
    }

    @Override
    public boolean isDescendant(Namespace namespace) {
        return true;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return false;
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.GLOBAL;
    }

    @Override
    public int getReferenceCount() {
        return 0;
    }

    @Override
    public boolean hasMultipleReferences() {
        return false;
    }

    @Override
    public boolean hasReferences() {
        return false;
    }

    @Override
    public Reference[] getReferences() {
        return new Reference[0];
    }

    @Override
    public Reference[] getReferences(TaskMonitor monitor) {
        return new Reference[0];
    }

    public Reference[] getAssociatedReferences() {
        return new Reference[0];
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    public void setName(String newName, SourceType source) throws DuplicateNameException, InvalidInputException {
        throw new UnsupportedOperationException("Setting the name of the Global symbol is not allowed.");
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public boolean isPinned() {
        return false;
    }

    @Override
    public void setPinned(boolean pinned) {
        throw new UnsupportedOperationException("Can't pin the global symbol");
    }

    @Override
    public void setSource(SourceType source) {
        throw new UnsupportedOperationException("Setting the source of the Global symbol is not allowed.");
    }

    @Override
    public SourceType getSource() {
        throw new UnsupportedOperationException("Getting the source of the Global symbol is not allowed.");
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean setPrimary() {
        return false;
    }

    @Override
    public boolean isExternalEntryPoint() {
        return false;
    }

    @Override
    public long getID() {
        return 0L;
    }

    @Override
    public Object getObject() {
        return this.globalNamespace;
    }

    @Override
    public void setNamespace(Namespace newNamespace) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        throw new UnsupportedOperationException("Cannot change the Global namespace");
    }

    @Override
    public void setNameAndNamespace(String newName, Namespace newNamespace, SourceType source) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        throw new UnsupportedOperationException("Cannot change the Global name and/or namespace");
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

