/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.Iterator;

public class AddressRangeChunker
implements Iterable<AddressRange> {
    private Address end;
    private Address nextStartAddress;
    private int chunkSize;

    public AddressRangeChunker(AddressRange range, int chunkSize) throws IllegalArgumentException {
        this(range.getMinAddress(), range.getMaxAddress(), chunkSize);
    }

    public AddressRangeChunker(Address start, Address end, int chunkSize) throws IllegalArgumentException {
        AddressSpace endSpace;
        if (start == null) {
            throw new IllegalArgumentException("Start address cannot be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("End address cannot be null");
        }
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Start address cannot be greater than end address");
        }
        AddressSpace startSpace = start.getAddressSpace();
        if (!startSpace.equals(endSpace = end.getAddressSpace())) {
            throw new IllegalArgumentException("Address must be in the same address space");
        }
        if (chunkSize < 1) {
            throw new IllegalArgumentException("Chunk size must be greater than 0");
        }
        this.end = end;
        this.nextStartAddress = start;
        this.chunkSize = chunkSize;
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return new Iterator<AddressRange>(){

            @Override
            public boolean hasNext() {
                return AddressRangeChunker.this.nextStartAddress != null;
            }

            @Override
            public AddressRange next() {
                if (AddressRangeChunker.this.nextStartAddress == null) {
                    return null;
                }
                long available = AddressRangeChunker.this.end.subtract(AddressRangeChunker.this.nextStartAddress) + 1L;
                int size = AddressRangeChunker.this.chunkSize;
                if (available >= 0L && available < (long)AddressRangeChunker.this.chunkSize) {
                    size = (int)available;
                }
                Address currentStart = AddressRangeChunker.this.nextStartAddress;
                Address currentEnd = AddressRangeChunker.this.nextStartAddress.add(size - 1);
                AddressRangeChunker.this.nextStartAddress = currentEnd.compareTo(AddressRangeChunker.this.end) == 0 ? null : currentEnd.add(1L);
                return new AddressRangeImpl(currentStart, currentEnd);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

