/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.data.DBContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.program.database.DataTypeArchiveDB;
import ghidra.program.database.DataTypeArchiveDBChangeSet;
import ghidra.program.database.DataTypeArchiveMergeManagerFactory;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class DataTypeArchiveContentHandler
extends DBContentHandler {
    private static ImageIcon DATA_TYPE_ARCHIVE_ICON;
    private static final String PROGRAM_ICON_PATH = "images/closedBookBlue.png";
    public static final String DATA_TYPE_ARCHIVE_CONTENT_TYPE = "Archive";

    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject obj, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(obj instanceof DataTypeArchiveDB)) {
            throw new IOException("Unsupported domain object: " + obj.getClass().getName());
        }
        return this.createFile((DataTypeArchiveDB)obj, DATA_TYPE_ARCHIVE_CONTENT_TYPE, fs, path, name, monitor);
    }

    public DomainObjectAdapter getImmutableObject(FolderItem item, Object consumer, int version, int minChangeVersion, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(DATA_TYPE_ARCHIVE_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        DataTypeArchiveDB dataTypeArchive = null;
        boolean success = false;
        try {
            bf = dbItem.open(version, minChangeVersion);
            dbh = new DBHandle((BufferFile)bf);
            int openMode = 2;
            dataTypeArchive = new DataTypeArchiveDB(dbh, openMode, monitor, consumer);
            this.getDataTypeArchiveChangeSet(dataTypeArchive, bf);
            success = true;
            DataTypeArchiveDB dataTypeArchiveDB = dataTypeArchive;
            return dataTypeArchiveDB;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getImmutableObject failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg);
        }
        finally {
            if (!success) {
                if (dataTypeArchive != null) {
                    dataTypeArchive.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    public DomainObjectAdapter getReadOnlyObject(FolderItem item, int version, boolean okToUpgrade, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(DATA_TYPE_ARCHIVE_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        DataTypeArchiveDB dataTypeArchive = null;
        boolean success = false;
        try {
            bf = dbItem.open(version);
            dbh = new DBHandle((BufferFile)bf);
            int openMode = okToUpgrade ? 3 : 1;
            dataTypeArchive = new DataTypeArchiveDB(dbh, openMode, monitor, consumer);
            this.getDataTypeArchiveChangeSet(dataTypeArchive, bf);
            success = true;
            DataTypeArchiveDB dataTypeArchiveDB = dataTypeArchive;
            return dataTypeArchiveDB;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getReadOnlyObject failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg);
        }
        finally {
            if (!success) {
                if (dataTypeArchive != null) {
                    dataTypeArchive.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    public DomainObjectAdapter getDomainObject(FolderItem item, FileSystem userfs, long checkoutId, boolean okToUpgrade, boolean recover, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(DATA_TYPE_ARCHIVE_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        DataTypeArchiveDB dataTypeArchive = null;
        boolean success = false;
        try {
            boolean isRecovered2;
            bf = dbItem.openForUpdate(checkoutId);
            dbh = new DBHandle((BufferFile)bf, recover, monitor);
            int openMode = okToUpgrade ? 3 : 1;
            dataTypeArchive = new DataTypeArchiveDB(dbh, openMode, monitor, consumer);
            if (checkoutId == -1L) {
                this.getDataTypeArchiveChangeSet(dataTypeArchive, bf);
            }
            if (recover && (isRecovered2 = this.recoverChangeSet(dataTypeArchive, dbh))) {
                dataTypeArchive.setChanged(true);
            }
            success = true;
            DataTypeArchiveDB isRecovered2 = dataTypeArchive;
            return isRecovered2;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getDomainObject failed", (Throwable)t);
            t.printStackTrace();
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg);
        }
        finally {
            if (!success) {
                if (dataTypeArchive != null) {
                    dataTypeArchive.release(consumer);
                }
                if (dbh != null) {
                    dbh.close();
                }
                if (bf != null) {
                    bf.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoverChangeSet(DataTypeArchiveDB dataTypeArchive, DBHandle dbh) throws IOException {
        boolean recovered = false;
        DataTypeArchiveDBChangeSet changeSet = (DataTypeArchiveDBChangeSet)dataTypeArchive.getChangeSet();
        LocalBufferFile cf = dbh.getRecoveryChangeSetFile();
        if (cf != null) {
            DBHandle cfh = null;
            try {
                cfh = new DBHandle((BufferFile)cf);
                changeSet.read(cfh);
                recovered = true;
            }
            finally {
                if (cfh != null) {
                    cfh.close();
                }
                cf.dispose();
            }
        }
        return recovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTypeArchiveDBChangeSet getDataTypeArchiveChangeSet(DataTypeArchiveDB dataTypeArchive, ManagedBufferFile bf) throws IOException {
        DataTypeArchiveDBChangeSet changeSet = (DataTypeArchiveDBChangeSet)dataTypeArchive.getChangeSet();
        BufferFile cf = bf.getNextChangeDataFile(true);
        DBHandle cfh = null;
        while (cf != null) {
            try {
                cfh = new DBHandle(cf);
                changeSet.read(cfh);
            }
            finally {
                if (cfh != null) {
                    cfh.close();
                    cfh = null;
                }
                cf.dispose();
            }
            cf = bf.getNextChangeDataFile(false);
        }
        return changeSet;
    }

    public ChangeSet getChangeSet(FolderItem item, int fromVer, int toVer) throws VersionException, IOException {
        String contentType = item.getContentType();
        if (contentType != null && !contentType.equals(DATA_TYPE_ARCHIVE_CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        DatabaseItem dbItem = (DatabaseItem)item;
        ManagedBufferFile bf = null;
        DBHandle dbh = null;
        DataTypeArchiveDB dataTypeArchive = null;
        try {
            bf = dbItem.open(toVer, fromVer);
            dbh = new DBHandle((BufferFile)bf);
            int openMode = 2;
            dataTypeArchive = new DataTypeArchiveDB(dbh, openMode, null, (Object)this);
            DataTypeArchiveDBChangeSet dataTypeArchiveDBChangeSet = this.getDataTypeArchiveChangeSet(dataTypeArchive, bf);
            return dataTypeArchiveDBChangeSet;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)"getChangeSet failed", (Throwable)t);
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            throw new IOException("Open failed: " + msg);
        }
        finally {
            if (dataTypeArchive != null) {
                dataTypeArchive.release((Object)this);
            }
            if (dbh != null) {
                dbh.close();
            }
            if (bf != null) {
                bf.dispose();
            }
        }
    }

    public Class<? extends DomainObject> getDomainObjectClass() {
        return DataTypeArchiveDB.class;
    }

    public String getContentType() {
        return DATA_TYPE_ARCHIVE_CONTENT_TYPE;
    }

    public String getContentTypeDisplayString() {
        return "Data Type Archive";
    }

    public String getDefaultToolName() {
        return "CodeBrowser";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon() {
        Class<DataTypeArchiveContentHandler> clazz = DataTypeArchiveContentHandler.class;
        synchronized (DataTypeArchiveContentHandler.class) {
            if (DATA_TYPE_ARCHIVE_ICON == null) {
                DATA_TYPE_ARCHIVE_ICON = ResourceManager.loadImage((String)PROGRAM_ICON_PATH);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DATA_TYPE_ARCHIVE_ICON;
        }
    }

    public boolean isPrivateContentType() {
        return false;
    }

    public DomainObjectMergeManager getMergeManager(DomainObject resultsObj, DomainObject sourceObj, DomainObject originalObj, DomainObject latestObj) {
        return DataTypeArchiveMergeManagerFactory.getMergeManager(resultsObj, sourceObj, originalObj, latestObj);
    }
}

