/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ConstructState;
import ghidra.app.plugin.processors.sleigh.ContextCache;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighInstructionPrototype;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ParserContext;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextImpl;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.WrappedMemBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class SleighParserContext
implements ParserContext {
    private MemBuffer memBuffer;
    private Address addr;
    private Address nextInstrAddr;
    private Address next2InstAddr;
    private Address refAddr;
    private Address destAddr;
    private SleighInstructionPrototype prototype;
    private AddressSpace constantSpace;
    private HashMap<ConstructState, FixedHandle> handleMap;
    private ArrayList<ContextSet> contextcommit;
    private int[] context;

    public SleighParserContext(MemBuffer memBuf, SleighInstructionPrototype prototype, ProcessorContextView processorContext) {
        this.handleMap = new HashMap();
        this.prototype = prototype;
        this.constantSpace = prototype.getLanguage().getAddressFactory().getConstantSpace();
        this.memBuffer = memBuf;
        this.addr = memBuf.getAddress();
        int contextSize = prototype.getContextCache().getContextSize();
        this.context = new int[contextSize];
        this.contextcommit = new ArrayList();
        try {
            this.nextInstrAddr = this.addr.add(prototype.getLength());
        }
        catch (AddressOutOfBoundsException exc) {
            this.nextInstrAddr = null;
        }
        prototype.getContextCache().getContext(processorContext, this.context);
    }

    @Override
    public SleighInstructionPrototype getPrototype() {
        return this.prototype;
    }

    public SleighParserContext(Address aAddr, Address nAddr, Address rAddr, Address dAddr) {
        this.memBuffer = null;
        this.prototype = null;
        this.context = null;
        this.contextcommit = null;
        this.addr = aAddr;
        this.nextInstrAddr = nAddr;
        this.refAddr = rAddr;
        this.destAddr = dAddr;
        this.handleMap = new HashMap();
    }

    public SleighParserContext(SleighParserContext origContext, int delayByteCount) {
        this.memBuffer = origContext.memBuffer;
        this.prototype = origContext.prototype;
        this.context = origContext.context;
        this.contextcommit = origContext.contextcommit;
        this.addr = origContext.addr;
        this.refAddr = origContext.refAddr;
        this.destAddr = origContext.destAddr;
        this.constantSpace = origContext.constantSpace;
        this.handleMap = origContext.handleMap;
        try {
            this.nextInstrAddr = this.addr.add(this.prototype.getLength() + delayByteCount);
        }
        catch (AddressOutOfBoundsException exc) {
            this.nextInstrAddr = null;
        }
    }

    Iterator<ContextSet> getContextCommits() {
        return this.contextcommit != null ? this.contextcommit.iterator() : null;
    }

    public void addCommit(ConstructState point, TripleSymbol sym, int num, int mask) {
        ContextSet set = new ContextSet();
        set.sym = sym;
        set.point = point;
        set.num = num;
        set.mask = mask;
        set.value = this.context[num] & mask;
        this.contextcommit.add(set);
    }

    public void applyCommits(ProcessorContext ctx) throws MemoryAccessException {
        if (this.contextcommit.size() == 0) {
            return;
        }
        ContextCache contextCache = this.prototype.getContextCache();
        ParserWalker walker = new ParserWalker(this);
        walker.baseState();
        for (ContextSet set : this.contextcommit) {
            FixedHandle hand;
            if (set.sym instanceof OperandSymbol) {
                int ind = ((OperandSymbol)set.sym).getIndex();
                hand = this.getFixedHandle(set.point.getSubState(ind));
            } else {
                hand = new FixedHandle();
                set.sym.getFixedHandle(hand, walker);
            }
            long offset = hand.offset_offset;
            AddressSpace curSpace = this.addr.getAddressSpace();
            if (hand.space.getType() == 0) {
                offset *= (long)curSpace.getAddressableUnitSize();
            }
            Address address = curSpace.getAddress(offset);
            contextCache.setContext(ctx, address, set.num, set.mask, set.value);
        }
        this.contextcommit.clear();
    }

    public FixedHandle getFixedHandle(ConstructState constructState) {
        FixedHandle handle = this.handleMap.get(constructState);
        if (handle == null) {
            handle = new FixedHandle();
            this.handleMap.put(constructState, handle);
        }
        return handle;
    }

    public Address getAddr() {
        return this.addr;
    }

    public Address getNaddr() {
        return this.nextInstrAddr;
    }

    public Address getN2addr() {
        if (this.next2InstAddr != null) {
            return this.next2InstAddr;
        }
        this.next2InstAddr = this.computeNext2Address();
        if (this.next2InstAddr == null) {
            this.next2InstAddr = this.nextInstrAddr;
        }
        return this.next2InstAddr;
    }

    private Address computeNext2Address() {
        if (this.memBuffer == null || this.nextInstrAddr == null) {
            return null;
        }
        try {
            Address nextAddr = this.nextInstrAddr;
            Language language = this.prototype.getLanguage();
            ProcessorContextImpl ctx = new ProcessorContextImpl(language);
            RegisterValue ctxVal = this.getContextRegisterValue();
            if (ctxVal != null) {
                ctx.setRegisterValue(ctxVal);
            }
            int offset = (int)nextAddr.subtract(this.addr);
            WrappedMemBuffer nearbymem = new WrappedMemBuffer(this.memBuffer, offset);
            SleighInstructionPrototype proto = (SleighInstructionPrototype)language.parse(nearbymem, ctx, true);
            return nextAddr.addNoWrap(proto.getLength());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AddressSpace getCurSpace() {
        return this.addr.getAddressSpace();
    }

    public AddressSpace getConstSpace() {
        return this.constantSpace;
    }

    public MemBuffer getMemBuffer() {
        return this.memBuffer;
    }

    public int getInstructionBytes(int offset, int bytestart, int size) throws MemoryAccessException {
        byte[] bytes = new byte[size];
        int readSize = this.memBuffer.getBytes(bytes, offset += bytestart);
        if (offset == 0 && readSize == 0) {
            throw new MemoryAccessException("invalid memory");
        }
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result <<= 8;
            result |= bytes[i] & 0xFF;
        }
        return result;
    }

    public int getInstructionBits(int offset, int startbit, int size) throws MemoryAccessException {
        offset += startbit / 8;
        int bytesize = ((startbit %= 8) + size - 1) / 8 + 1;
        byte[] bytes = new byte[bytesize];
        int readSize = this.memBuffer.getBytes(bytes, offset);
        if (offset == 0 && readSize == 0) {
            throw new MemoryAccessException("invalid memory");
        }
        int res = 0;
        for (int i = 0; i < bytesize; ++i) {
            res <<= 8;
            res |= bytes[i] & 0xFF;
        }
        res <<= 8 * (4 - bytesize) + startbit;
        return res >>>= 32 - size;
    }

    public RegisterValue getContextRegisterValue() {
        Register baseContextRegister = this.prototype.getLanguage().getContextBaseRegister();
        if (baseContextRegister == null) {
            return null;
        }
        int ctxByteLen = baseContextRegister.getMinimumByteSize();
        byte[] ctxValueBytes = new byte[ctxByteLen];
        for (int i = 0; i < this.context.length; ++i) {
            int word = this.context[i];
            for (int n = 3; n >= 0; --n) {
                int byteIndex = i * 4 + n;
                this.setByte(ctxValueBytes, byteIndex, (byte)word);
                word >>= 8;
            }
        }
        byte[] ctxValueMaskBytes = new byte[2 * ctxByteLen];
        Arrays.fill(ctxValueMaskBytes, 0, ctxByteLen, (byte)-1);
        System.arraycopy(ctxValueBytes, 0, ctxValueMaskBytes, ctxByteLen, ctxByteLen);
        return new RegisterValue(baseContextRegister, ctxValueMaskBytes);
    }

    private void setByte(byte[] bytes, int index, byte b) {
        if (index < bytes.length) {
            bytes[index] = b;
        }
    }

    public int getContextBytes(int bytestart, int bytesize) {
        int intstart = bytestart / 4;
        int res = this.context[intstart];
        int byteOffset = bytestart % 4;
        int unusedBytes = 4 - bytesize;
        res <<= byteOffset * 8;
        res >>>= unusedBytes * 8;
        int remaining = bytesize - 4 + byteOffset;
        if (remaining > 0 && ++intstart < this.context.length) {
            int res2 = this.context[intstart];
            unusedBytes = 4 - remaining;
            res |= (res2 >>>= unusedBytes * 8);
        }
        return res;
    }

    public int[] getContextBytes() {
        return this.context;
    }

    public int getContextBits(int startbit, int bitsize) {
        int intstart = startbit / 32;
        int res = this.context[intstart];
        int bitOffset = startbit % 32;
        int unusedBits = 32 - bitsize;
        res <<= bitOffset;
        res >>>= unusedBits;
        int remaining = bitsize - 32 + bitOffset;
        if (remaining > 0 && ++intstart < this.context.length) {
            int res2 = this.context[intstart];
            unusedBits = 32 - remaining;
            res |= (res2 >>>= unusedBits);
        }
        return res;
    }

    public void setContextWord(int i, int val, int mask) {
        this.context[i] = this.context[i] & ~mask | mask & val;
    }

    ConstructState getRootState() {
        return this.prototype.getRootState();
    }

    public boolean isValid(MemBuffer buf) {
        return buf == this.memBuffer && this.addr.equals(buf.getAddress());
    }

    public Address getFlowRefAddr() {
        if (this.refAddr == null) {
            throw new SleighException("Flow reference (inst_ref) is undefined at " + this.getAddr());
        }
        return this.refAddr;
    }

    public Address getFlowDestAddr() {
        if (this.destAddr == null) {
            throw new SleighException("Flow destination (inst_dest) is undefined at " + this.getAddr());
        }
        return this.destAddr;
    }

    static class ContextSet {
        public TripleSymbol sym;
        public int num;
        public int mask;
        public int value;
        public ConstructState point;

        ContextSet() {
        }
    }
}

