/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.impl;

import db.DBHandle;
import db.OpenMode;
import db.buffers.BufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.framework.data.DBContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class VTSessionContentHandler
extends DBContentHandler {
    private static ImageIcon ICON = ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/start-here_16.png"), (int)16, (int)16);
    public static final String CONTENT_TYPE = "VersionTracking";

    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject domainObject, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(domainObject instanceof VTSessionDB)) {
            throw new IOException("Unsupported domain object: " + domainObject.getClass().getName());
        }
        return this.createFile((VTSessionDB)domainObject, CONTENT_TYPE, fs, path, name, monitor);
    }

    public ChangeSet getChangeSet(FolderItem versionedFolderItem, int olderVersion, int newerVersion) throws VersionException, IOException {
        return null;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentTypeDisplayString() {
        return "Version Tracking Session";
    }

    public String getDefaultToolName() {
        return "Version Tracking";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainObjectAdapter getDomainObject(FolderItem item, FileSystem userfs, long checkoutId, boolean okToUpgrade, boolean okToRecover, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        VTSessionDB vTSessionDB;
        block11: {
            String contentType = item.getContentType();
            if (!contentType.equals(CONTENT_TYPE)) {
                throw new IOException("Unsupported content type: " + contentType);
            }
            DatabaseItem dbItem = (DatabaseItem)item;
            ManagedBufferFile bf = dbItem.openForUpdate(checkoutId);
            DBHandle dbh = new DBHandle((BufferFile)bf, okToRecover, monitor);
            boolean success = false;
            try {
                VTSessionDB db = VTSessionDB.getVTSession(dbh, OpenMode.UPGRADE, consumer, monitor);
                success = true;
                vTSessionDB = db;
                if (success) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (!success) {
                        dbh.close();
                    }
                    throw throwable;
                }
                catch (VersionException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (CancelledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    Msg.error((Object)((Object)this), (Object)"getDomainObject failed", (Throwable)t);
                    String msg = t.getMessage();
                    if (msg == null) {
                        msg = t.toString();
                    }
                    throw new IOException("Open failed: " + msg);
                }
            }
            dbh.close();
        }
        return vTSessionDB;
    }

    public Class<? extends DomainObject> getDomainObjectClass() {
        return VTSessionDB.class;
    }

    public Icon getIcon() {
        return ICON;
    }

    public DomainObjectAdapter getImmutableObject(FolderItem item, Object consumer, int version, int minChangeVersion, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        String contentType = item.getContentType();
        if (!contentType.equals(CONTENT_TYPE)) {
            throw new IOException("Unsupported content type: " + contentType);
        }
        return this.getReadOnlyObject(item, -1, false, consumer, monitor);
    }

    public DomainObjectMergeManager getMergeManager(DomainObject resultsObj, DomainObject sourceObj, DomainObject originalObj, DomainObject latestObj) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainObjectAdapter getReadOnlyObject(FolderItem item, int version, boolean okToUpgrade, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        VTSessionDB vTSessionDB;
        block9: {
            String contentType = item.getContentType();
            if (contentType != null && !contentType.equals(CONTENT_TYPE)) {
                throw new IOException("Unsupported content type: " + contentType);
            }
            DatabaseItem dbItem = (DatabaseItem)item;
            ManagedBufferFile bf = dbItem.open();
            DBHandle dbh = new DBHandle((BufferFile)bf);
            boolean success = false;
            try {
                VTSessionDB manager = VTSessionDB.getVTSession(dbh, OpenMode.READ_ONLY, consumer, monitor);
                success = true;
                vTSessionDB = manager;
                if (success) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (!success) {
                        dbh.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable t) {
                    Msg.error((Object)((Object)this), (Object)"Get read-only object failed", (Throwable)t);
                    String msg = t.getMessage();
                    if (msg == null) {
                        msg = t.toString();
                    }
                    throw new IOException("Open failed: " + msg);
                }
            }
            dbh.close();
        }
        return vTSessionDB;
    }

    public boolean isPrivateContentType() {
        return true;
    }
}

