/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.service.Location;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class FidPopulateResult {
    private LibraryRecord libraryRecord;
    private LinkedHashMap<Location, Disposition> extremeFailureMap;
    private ArrayList<Location> unresolvedSymbols;
    private List<Count> maxChildRefs;
    private int totalDisposition = 0;
    private int numIncluded = 0;
    private int numThunk = 0;
    private int numFiltered = 0;
    private int numFailedMinimum = 0;
    private int numMemAccess = 0;
    private int numNoDefinedSymbol = 0;
    private int numDuplicates = 0;

    FidPopulateResult(LibraryRecord libraryRecord) {
        this.libraryRecord = libraryRecord;
        this.unresolvedSymbols = new ArrayList();
        this.extremeFailureMap = new LinkedHashMap();
    }

    void disposition(DomainFile domainFile, String functionName, Address functionEntryPoint, Disposition disposition) {
        ++this.totalDisposition;
        switch (disposition) {
            case FAILED_FUNCTION_FILTER: {
                ++this.numFiltered;
                return;
            }
            case FAILS_MINIMUM_SHORTHASH_LENGTH: {
                ++this.numFailedMinimum;
                return;
            }
            case INCLUDED: {
                ++this.numIncluded;
                return;
            }
            case IS_THUNK: {
                ++this.numThunk;
                return;
            }
            case DUPLICATE_INFO: {
                ++this.numDuplicates;
                return;
            }
            case MEMORY_ACCESS_EXCEPTION: {
                ++this.numMemAccess;
                break;
            }
            case NO_DEFINED_SYMBOL: {
                ++this.numNoDefinedSymbol;
                break;
            }
        }
        this.extremeFailureMap.put(new Location(domainFile, functionName, functionEntryPoint), disposition);
    }

    void addUnresolvedSymbol(String functionName) {
        this.unresolvedSymbols.add(new Location(null, functionName, null));
    }

    public LibraryRecord getLibraryRecord() {
        return this.libraryRecord;
    }

    public Map<Location, Disposition> getResults() {
        return Collections.unmodifiableMap(this.extremeFailureMap);
    }

    public int getTotalAdded() {
        return this.numIncluded;
    }

    public int getTotalExcluded() {
        return this.totalDisposition - this.numIncluded;
    }

    public int getTotalAttempted() {
        return this.totalDisposition;
    }

    public Map<Disposition, Integer> getFailures() {
        HashMap<Disposition, Integer> result = new HashMap<Disposition, Integer>();
        result.put(Disposition.INCLUDED, this.numIncluded);
        result.put(Disposition.IS_THUNK, this.numThunk);
        result.put(Disposition.FAILED_FUNCTION_FILTER, this.numFiltered);
        result.put(Disposition.FAILS_MINIMUM_SHORTHASH_LENGTH, this.numFailedMinimum);
        result.put(Disposition.MEMORY_ACCESS_EXCEPTION, this.numMemAccess);
        result.put(Disposition.NO_DEFINED_SYMBOL, this.numNoDefinedSymbol);
        result.put(Disposition.DUPLICATE_INFO, this.numDuplicates);
        return result;
    }

    public List<Location> getUnresolvedSymbols() {
        return new ArrayList<Location>(this.unresolvedSymbols);
    }

    public List<Count> getMaxChildReferences() {
        return this.maxChildRefs;
    }

    public void addChildReferences(int max, Map<String, Count> childHistogram) {
        TreeSet<Count> resort = new TreeSet<Count>();
        for (Map.Entry<String, Count> entry : childHistogram.entrySet()) {
            Count count = entry.getValue();
            count.name = entry.getKey();
            resort.add(count);
        }
        this.maxChildRefs = new LinkedList<Count>();
        int i = 0;
        for (Count count : resort) {
            this.maxChildRefs.add(count);
            if (++i < max) continue;
            break;
        }
    }

    public static enum Disposition {
        INCLUDED,
        IS_THUNK,
        FAILED_FUNCTION_FILTER,
        FAILS_MINIMUM_SHORTHASH_LENGTH,
        NO_DEFINED_SYMBOL,
        MEMORY_ACCESS_EXCEPTION,
        DUPLICATE_INFO;

    }

    public static class Count
    implements Comparable<Count> {
        public String name;
        public int count;
        public boolean isVeryCommon;

        @Override
        public int compareTo(Count o) {
            if (this.count == o.count) {
                return this.name.compareTo(o.name);
            }
            return this.count < o.count ? 1 : -1;
        }
    }
}

