/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.plugin;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.script.AskDialog;
import ghidra.feature.fid.db.FidFile;
import ghidra.feature.fid.db.FidFileManager;
import ghidra.feature.fid.plugin.ActiveFidConfigureDialog;
import ghidra.feature.fid.plugin.PopulateFidDialog;
import ghidra.feature.fid.service.FidService;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateFileException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Function ID", description="This plugin is for creating and maintaining function identification libraries.")
public class FidPlugin
extends ProgramPlugin
implements ChangeListener {
    private static final String MENU_GROUP_1 = "group1";
    static final String FUNCTION_ID_NAME = "Function ID";
    public static final String FID_HELP = "FunctionID";
    private FidService service;
    private FidFileManager fidFileManager;
    private DockingAction chooseAction;
    private DockingAction createAction;
    private DockingAction attachAction;
    private DockingAction detachAction;
    private DockingAction populateAction;

    public FidPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(() -> this.updateActions());
    }

    private void updateActions() {
        this.enableActions();
    }

    protected void init() {
        super.init();
        this.fidFileManager = FidFileManager.getInstance();
        this.fidFileManager.addChangeListener(this);
        this.service = new FidService();
        this.createStandardActions();
        this.enableActions();
    }

    protected void cleanup() {
        this.fidFileManager.removeChangeListener(this);
        super.cleanup();
    }

    private void createStandardActions() {
        DockingAction action = new DockingAction("Choose Active FidDbs", this.getName()){

            public void actionPerformed(ActionContext context) {
                FidPlugin.this.chooseActiveFidDbs();
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Tools", FUNCTION_ID_NAME, "Choose active FidDbs..."}, null, MENU_GROUP_1, -1, "1"));
        action.setDescription("Select which FidDbs are used during Fid Search");
        action.setHelpLocation(new HelpLocation(FID_HELP, "chooseactivemenu"));
        this.tool.addAction((DockingActionIf)action);
        this.chooseAction = action;
        action = new DockingAction("Create new empty FidDb", this.getName()){

            public void actionPerformed(ActionContext context) {
                FidPlugin.this.createFidDb();
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Tools", FUNCTION_ID_NAME, "Create new empty FidDb..."}, null, MENU_GROUP_1, -1, "2"));
        action.setDescription("Create a new, empty FidDb file in your file system");
        action.setHelpLocation(new HelpLocation(FID_HELP, "createemptyfid"));
        this.tool.addAction((DockingActionIf)action);
        this.createAction = action;
        action = new DockingAction("Attach existing FidDb", this.getName()){

            public void actionPerformed(ActionContext context) {
                FidPlugin.this.attachFidDb();
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Tools", FUNCTION_ID_NAME, "Attach existing FidDb..."}, null, MENU_GROUP_1, -1, "3"));
        action.setDescription("Attach an existing FidDb file from your file system");
        action.setHelpLocation(new HelpLocation(FID_HELP, "attachfid"));
        this.tool.addAction((DockingActionIf)action);
        this.attachAction = action;
        action = new DockingAction("Detach attached FidDb", this.getName()){

            public void actionPerformed(ActionContext context) {
                FidPlugin.this.removeFidFile();
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Tools", FUNCTION_ID_NAME, "Detach attached FidDb..."}, null, MENU_GROUP_1, -1, "4"));
        action.setDescription("Detach an already attached FidDb");
        action.setHelpLocation(new HelpLocation(FID_HELP, "detachfid"));
        this.tool.addAction((DockingActionIf)action);
        this.detachAction = action;
        action = new DockingAction("Populate FidDb from programs", this.getName()){

            public void actionPerformed(ActionContext context) {
                PopulateFidDialog populateFidDialog = new PopulateFidDialog(FidPlugin.this.tool, FidPlugin.this.service);
                FidPlugin.this.tool.showDialog((DialogComponentProvider)populateFidDialog);
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Tools", FUNCTION_ID_NAME, "Populate FidDb from programs..."}, null, MENU_GROUP_1, -1, "5"));
        action.setDescription("Populate an existing FidDb with all programs under a domain folder");
        action.setHelpLocation(new HelpLocation(FID_HELP, "populatedialog"));
        this.tool.addAction((DockingActionIf)action);
        this.populateAction = action;
    }

    private synchronized void chooseActiveFidDbs() {
        ActiveFidConfigureDialog dialog = new ActiveFidConfigureDialog(this.fidFileManager.getFidFiles());
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    private void createFidDb() {
        File dbFile = this.askFile("Create new FidDb file", "Create");
        if (dbFile == null) {
            return;
        }
        if (!dbFile.getName().endsWith(".fidb")) {
            dbFile = new File(dbFile.getParentFile(), dbFile.getName() + ".fidb");
        }
        try {
            this.fidFileManager.createNewFidDatabase(dbFile);
        }
        catch (DuplicateFileException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error creating new FidDb file", (Object)("File already exists: " + dbFile.getAbsolutePath()));
        }
        catch (IOException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error creating new FidDb file", (Object)"Caught IOException creating FidDb file", (Throwable)e);
        }
    }

    private void attachFidDb() {
        File dbFile = this.askFile("Attach existing FidDb file", "Attach");
        if (dbFile != null) {
            this.fidFileManager.addUserFidFile(dbFile);
        }
    }

    private void removeFidFile() {
        FidFile fidFile = this.askChoice("Choose FidDb to detach", "Please choose the FidDb to detach", this.fidFileManager.getUserAddedFiles(), null);
        if (fidFile != null) {
            this.fidFileManager.removeUserFile(fidFile);
        }
    }

    private void enableActions() {
        boolean atLeastOneFidDb = this.fidFileManager.getFidFiles().size() > 0;
        boolean atLeastOneUserFidDb = this.fidFileManager.getUserAddedFiles().size() > 0;
        this.chooseAction.setEnabled(atLeastOneFidDb);
        this.createAction.setEnabled(true);
        this.attachAction.setEnabled(true);
        this.detachAction.setEnabled(atLeastOneUserFidDb);
        this.populateAction.setEnabled(atLeastOneUserFidDb);
    }

    private File askFile(String title, String approveButtonText) {
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
        chooser.setApproveButtonText(approveButtonText);
        chooser.setTitle(title);
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        return chooser.getSelectedFile();
    }

    private <T> T askChoice(String title, String message, List<T> choices, T defaultValue) {
        AskDialog dialog = new AskDialog(null, title, message, 0, choices, defaultValue);
        if (dialog.isCanceled()) {
            return null;
        }
        Object s = dialog.getChoiceValue();
        return (T)s;
    }
}

