/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.PicProcessor;
import ghidra.app.plugin.core.analysis.RegisterContextBuilder;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.graph.DirectedGraph;
import ghidra.util.graph.Edge;
import ghidra.util.graph.Vertex;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class Pic17c7xxAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "PIC-17C7xx";
    private static final String DESCRIPTION = "Analyzes PIC-17 instructions.";
    private static final int INSTRUCTION_LENGTH = 2;
    private static final long RESET_VECTOR_OFFSET = 0L;
    private static final Character DEST_W = Character.valueOf('w');
    private static final Character DEST_FREG = Character.valueOf('f');
    private static final Character S_0 = Character.valueOf('0');
    private static final String CODE_SPACE_NAME = "CODE";
    private static final HashSet<String> WREG_MODIFICATION_MNEMONICS = new HashSet();
    private static final HashSet<String> REG_S_MODIFICATION_MNEMONICS;
    private static final HashSet<String> REG_MODIFICATION_MNEMONICS;
    private static final HashSet<String> FREG_INSTRUCTIONS;
    private static final HashSet<String> FREG_BIT_INSTRUCTIONS;
    private static final HashSet<String> SKIP_INSTRUCTIONS;
    private static final HashMap<String, String[]> FREG_BIT_NAMES_MAP;
    private Program program;
    private Listing listing;
    private EquateTable equateTable;
    private ReferenceManager refMgr;
    private Register alustaReg;
    private Register bsrReg;
    private Register pclathReg;
    private Register pclReg;
    private Register wReg;
    private Register fs32Reg;
    private Register fs10Reg;
    private RegisterContextBuilder wContext;
    private RegisterContextBuilder pclathContext;
    private RegisterContextBuilder fs32Context;
    private RegisterContextBuilder fs10Context;
    private RegisterContextBuilder bsrContext;
    private AddressSet disassemblyPoints;
    private AddressSet clearPoints;

    public Pic17c7xxAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.DISASSEMBLY.after().after().after());
    }

    public boolean canAnalyze(Program p) {
        return p.getLanguage().getProcessor() == PicProcessor.PROCESSOR_PIC_17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean added(Program p, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        this.program = p;
        this.listing = this.program.getListing();
        this.refMgr = this.program.getReferenceManager();
        this.equateTable = this.program.getEquateTable();
        this.alustaReg = this.program.getRegister("ALUSTA");
        this.pclathReg = this.program.getRegister("PCLATH");
        this.pclReg = this.program.getRegister("PCL");
        this.wReg = this.program.getRegister("WREG");
        this.bsrReg = this.program.getRegister("BSR");
        this.fs32Reg = this.program.getRegister("FS32");
        this.fs10Reg = this.program.getRegister("FS10");
        this.wContext = new RegisterContextBuilder(this.program, this.wReg, false);
        this.pclathContext = new RegisterContextBuilder(this.program, this.pclathReg, 255L);
        this.fs32Context = new RegisterContextBuilder(this.program, this.fs32Reg, 3L);
        this.fs10Context = new RegisterContextBuilder(this.program, this.fs10Reg, 3L);
        this.bsrContext = new RegisterContextBuilder(this.program, this.bsrReg, 255L);
        this.disassemblyPoints = new AddressSet();
        this.clearPoints = new AddressSet();
        try {
            DirectedGraph graph = this.buildGraph(this.program, set, monitor);
            HashSet<Vertex> completed = new HashSet<Vertex>();
            LinkedList<Vertex> vertexList = new LinkedList<Vertex>();
            Vector entryPts = graph.getEntryPoints();
            for (Vertex v : entryPts) {
                v = this.getOptimalSource(graph, v);
                vertexList.add(v);
                completed.add(v);
            }
            while (!vertexList.isEmpty()) {
                Vertex v = (Vertex)vertexList.removeFirst();
                this.blockAdded((CodeBlock)v.referent(), monitor);
                Set children = graph.getChildren(v);
                for (Vertex child : children) {
                    if (completed.contains(child)) continue;
                    vertexList.add(child);
                    completed.add(child);
                }
            }
            if (!this.disassemblyPoints.isEmpty()) {
                AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)this.program);
                mgr.disassemble((AddressSetView)this.disassemblyPoints);
            }
            if (!this.clearPoints.isEmpty()) {
                AddressRangeIterator ranges = this.clearPoints.getAddressRanges();
                while (ranges.hasNext()) {
                    AddressRange range = (AddressRange)ranges.next();
                    this.program.getListing().clearCodeUnits(range.getMinAddress(), range.getMaxAddress(), false);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (CancelledException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.program = null;
            this.listing = null;
            this.refMgr = null;
            this.equateTable = null;
            this.alustaReg = null;
            this.pclathReg = null;
            this.pclReg = null;
            this.wReg = null;
            this.fs32Reg = null;
            this.fs10Reg = null;
            this.bsrReg = null;
        }
    }

    private Vertex getOptimalSource(DirectedGraph graph, Vertex v) {
        boolean hasFallFromVertex;
        Vertex optimalVertex = v;
        block0: do {
            hasFallFromVertex = false;
            for (Edge edge : graph.getIncomingEdges(optimalVertex)) {
                if (!this.isFallThroughEdge(edge)) continue;
                hasFallFromVertex = true;
                optimalVertex = edge.from();
                continue block0;
            }
        } while (hasFallFromVertex);
        return optimalVertex;
    }

    private boolean isFallThroughEdge(Edge edge) {
        CodeBlock fromBlock = (CodeBlock)edge.from().referent();
        CodeBlock toBlock = (CodeBlock)edge.to().referent();
        return fromBlock.getMaxAddress().add(1L).equals((Object)toBlock.getMinAddress());
    }

    private Vertex getConnectedVertex(DirectedGraph graph, CodeBlock block, Vertex srcVertex) {
        Vertex v;
        boolean srcFound = false;
        Vertex[] vertices = graph.getVerticesHavingReferent((Object)block);
        if (vertices.length != 0) {
            Iterator iterator;
            v = vertices[0];
            if (srcVertex != null && (iterator = graph.getIncomingEdges(v).iterator()).hasNext()) {
                Edge edge = (Edge)iterator.next();
                srcFound = edge.from() == srcVertex;
            }
        } else {
            v = new Vertex((Object)block);
            graph.add(v);
        }
        if (srcVertex != null && !srcFound) {
            Edge e = new Edge(srcVertex, v);
            graph.add(e);
        }
        return v;
    }

    private DirectedGraph buildGraph(Program p, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        HashSet<Address> blockEntrySet = new HashSet<Address>();
        SimpleBlockModel model = new SimpleBlockModel(this.program);
        CodeBlockIterator blockIter = model.getCodeBlocksContaining(set, monitor);
        while (blockIter.hasNext()) {
            blockEntrySet.add(blockIter.next().getFirstStartAddress());
        }
        DirectedGraph graph = new DirectedGraph();
        Iterator iter = blockEntrySet.iterator();
        while (iter.hasNext()) {
            CodeBlock srcBlock = model.getCodeBlockAt((Address)iter.next(), monitor);
            Vertex srcVertex = this.getConnectedVertex(graph, srcBlock, null);
            CodeBlockReferenceIterator refIter = srcBlock.getDestinations(monitor);
            while (refIter.hasNext()) {
                CodeBlockReference blockRef = refIter.next();
                Address destAddr = blockRef.getReference();
                if (!blockEntrySet.contains(destAddr) || destAddr.equals((Object)srcBlock.getFirstStartAddress())) continue;
                CodeBlock destBlock = blockRef.getDestinationBlock();
                this.getConnectedVertex(graph, destBlock, srcVertex);
            }
        }
        return graph;
    }

    private void blockAdded(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        boolean newBlock = true;
        InstructionIterator instIter = this.listing.getInstructions((AddressSetView)block, true);
        while (!monitor.isCancelled() && instIter.hasNext()) {
            String mnemonic;
            FlowType flowType;
            Instruction instr = instIter.next();
            if (newBlock) {
                this.startNewBlock(instr);
                newBlock = false;
            }
            if ((flowType = instr.getFlowType()).isCall() || flowType.isJump()) {
                this.handleCallOrBranch(instr);
            }
            if (FREG_INSTRUCTIONS.contains(mnemonic = instr.getMnemonicString())) {
                this.markupFRegInstruction(instr, 0, null);
            } else if ("MOVFP".equals(mnemonic) || "MOVPF".equals(mnemonic)) {
                this.markupFRegInstruction(instr, 0, RefType.READ);
                this.markupFRegInstruction(instr, 1, RefType.WRITE);
            } else if (mnemonic.equals("TABLRD")) {
                this.markupFRegInstruction(instr, 2, RefType.WRITE);
            } else if (mnemonic.equals("TLRD")) {
                this.markupFRegInstruction(instr, 1, RefType.WRITE);
            } else if (mnemonic.equals("TABLWT")) {
                this.markupFRegInstruction(instr, 2, RefType.READ);
            } else if (mnemonic.equals("TLWT")) {
                this.markupFRegInstruction(instr, 1, RefType.READ);
            } else if (FREG_BIT_INSTRUCTIONS.contains(mnemonic)) {
                this.markupFRegAndBitInstruction(instr);
            } else if ("BADCALL".equals(mnemonic)) {
                Address addr = instr.getMinAddress();
                this.clearPoints.addRange(addr, addr);
            }
            if (this.handleWRegModification(instr)) continue;
            this.checkRegisterAccess(instr);
        }
        this.pclathContext.writeValue(block.getMaxAddress());
        this.fs32Context.writeValue(block.getMaxAddress());
        this.fs10Context.writeValue(block.getMaxAddress());
        this.bsrContext.writeValue(block.getMaxAddress());
        monitor.checkCanceled();
    }

    private void markupFRegAndBitInstruction(Instruction instr) {
        if (instr.getNumOperands() != 2) {
            return;
        }
        String regName = this.markupFRegInstruction(instr, 0, null);
        if (regName == null) {
            return;
        }
        Object[] objs = instr.getOpObjects(1);
        if (objs.length != 1 || !(objs[0] instanceof Scalar)) {
            return;
        }
        int bit = (int)((Scalar)objs[0]).getUnsignedValue();
        String[] bitNames = FREG_BIT_NAMES_MAP.get(regName);
        if (bitNames == null || bit >= bitNames.length || bitNames[bit] == null) {
            return;
        }
        String bitName = bitNames[bit];
        Equate bitEquate = this.equateTable.getEquate(bitName);
        if (bitEquate == null) {
            try {
                bitEquate = this.equateTable.createEquate(bitName, (long)bit);
            }
            catch (Exception e) {
                return;
            }
        }
        bitEquate.addReference(instr.getMinAddress(), 1);
    }

    private String markupFRegInstruction(Instruction instr, int opIndex, RefType refType) {
        Address addr;
        Object[] objs = instr.getOpObjects(opIndex);
        if (objs.length != 1) {
            return null;
        }
        Register reg = null;
        if (objs[0] instanceof Register) {
            return ((Register)objs[0]).getName();
        }
        if (objs[0] instanceof Address) {
            addr = (Address)objs[0];
            reg = this.program.getRegister(addr, 1);
        } else if (objs[0] instanceof Scalar) {
            long offset = ((Scalar)objs[0]).getUnsignedValue();
            long bank = 0L;
            if (offset >= 16L && offset <= 23L) {
                if (!this.bsrContext.hasValue()) {
                    return null;
                }
                bank = this.bsrContext.longValue() & 0xFL;
            } else if (offset >= 32L) {
                if (!this.bsrContext.hasValue()) {
                    return null;
                }
                bank = this.bsrContext.longValue() >> 4;
            }
            addr = this.program.getAddressFactory().getAddressSpace("DATA").getAddress(offset += bank << 8);
            reg = this.program.getRegister(addr);
        } else {
            return null;
        }
        if (refType == null) {
            List repObjs;
            refType = RefType.READ;
            String mnemonic = instr.getMnemonicString();
            if ("CLRF".equals(mnemonic) || "MOVWF".equals(mnemonic)) {
                refType = RefType.WRITE;
            } else if (FREG_BIT_INSTRUCTIONS.contains(mnemonic)) {
                if ("BCF".equals(mnemonic) || "BSF".equals(mnemonic)) {
                    refType = RefType.READ_WRITE;
                }
            } else if (opIndex == 0 && instr.getNumOperands() == 2 && (repObjs = instr.getDefaultOperandRepresentationList(1)).size() == 1 && DEST_FREG.equals(repObjs.get(0))) {
                refType = RefType.READ_WRITE;
            }
        }
        if (addr.isMemoryAddress()) {
            this.refMgr.addMemoryReference(instr.getMinAddress(), addr, refType, SourceType.ANALYSIS, opIndex);
        }
        return reg != null ? reg.getName() : null;
    }

    private boolean isCodeAddress(Address addr) {
        return CODE_SPACE_NAME.equals(addr.getAddressSpace().getName());
    }

    private void startNewBlock(Instruction instr) {
        Address skipFromAddr;
        Reference ref;
        Address instrAddr = instr.getMinAddress();
        long instrOffset = instrAddr.getOffset();
        if (instrOffset == 0L) {
            this.bsrContext.setValueAt(instr, 0L, true);
            this.fs32Context.setValueAt(instr, 3L, true);
            this.fs10Context.setValueAt(instr, 3L, true);
            this.pclathContext.setValueAt(instr, 0L, true);
            this.wContext.setValueUnknown();
            return;
        }
        this.pclathContext.setValueAt(instr, instrAddr, true);
        this.bsrContext.setValueAt(instr, instrAddr, true);
        this.fs32Context.setValueAt(instr, instrAddr, true);
        this.fs10Context.setValueAt(instr, instrAddr, true);
        this.wContext.setValueAt(instr, instrAddr, true);
        Instruction fallFromInstr = this.getFallFrom(instr);
        if (fallFromInstr != null) {
            Address fallFrom = fallFromInstr.getMinAddress();
            this.pclathContext.setValueAt(instr, fallFrom, false);
            this.bsrContext.setValueAt(instr, fallFrom, false);
            this.fs32Context.setValueAt(instr, fallFrom, false);
            this.fs10Context.setValueAt(instr, fallFrom, false);
            this.wContext.setValueAt(instr, fallFrom, false);
        } else if (instrOffset >= 4L && (ref = this.refMgr.getReference(skipFromAddr = instrAddr.subtract(4L), instrAddr, -1)) != null && ref.getReferenceType() == RefType.CONDITIONAL_JUMP) {
            this.pclathContext.setValueAt(instr, skipFromAddr, false);
            this.bsrContext.setValueAt(instr, skipFromAddr, false);
            this.fs32Context.setValueAt(instr, skipFromAddr, false);
            this.fs10Context.setValueAt(instr, skipFromAddr, false);
            this.wContext.setValueAt(instr, skipFromAddr, false);
        }
        ReferenceIterator refIter = this.refMgr.getReferencesTo(instrAddr);
        while (!(this.pclathContext.hasValue() && this.bsrContext.hasValue() && this.fs32Context.hasValue() && this.fs10Context.hasValue() && this.wContext.hasValue() || !refIter.hasNext())) {
            ref = refIter.next();
            Address fromAddr = ref.getFromAddress();
            if (!this.isCodeAddress(fromAddr)) continue;
            this.pclathContext.setValueAt(instr, fromAddr, false);
            this.bsrContext.setValueAt(instr, fromAddr, false);
            this.fs32Context.setValueAt(instr, fromAddr, false);
            this.fs10Context.setValueAt(instr, fromAddr, false);
            this.wContext.setValueAt(instr, fromAddr, false);
            break;
        }
    }

    private void handleCallOrBranch(Instruction instr) {
        String mnemonic = instr.getMnemonicString();
        if ("GOTO".equals(mnemonic) || "CALL".equals(mnemonic)) {
            Address destAddr = instr.getAddress(0);
            if (destAddr != null) {
                long val = destAddr.getOffset() >> 9;
                try {
                    this.program.getProgramContext().setValue(this.pclathReg, destAddr, destAddr, BigInteger.valueOf(val));
                }
                catch (ContextChangeException contextChangeException) {}
            }
        } else if ("LCALL".equals(mnemonic)) {
            Object[] objs = instr.getOpObjects(0);
            if (objs.length == 1 && objs[0] instanceof Scalar) {
                Scalar s = (Scalar)objs[0];
                this.handleComputedFlow(instr, s.getUnsignedValue(), 0);
            }
        } else if (SKIP_INSTRUCTIONS.contains(mnemonic)) {
            Address skipAddr = instr.getMinAddress().add(4L);
            this.refMgr.addMemoryReference(instr.getMinAddress(), skipAddr, (RefType)RefType.CONDITIONAL_JUMP, SourceType.ANALYSIS, -1);
            this.disassembleAt(skipAddr);
        }
    }

    private void disassembleAt(Address addr) {
        if (this.listing.getInstructionAt(addr) == null) {
            this.disassemblyPoints.addRange(addr, addr);
        }
    }

    private boolean handleWRegModification(Instruction instr) {
        String mnemonic = instr.getMnemonicString();
        boolean modUnknown = false;
        if ("CLRW".equals(mnemonic)) {
            this.wContext.setValueAt(instr, 0L, false);
            return true;
        }
        if ("MOVLW".equals(mnemonic)) {
            Scalar s = instr.getScalar(0);
            if (s != null) {
                this.wContext.setValueAt(instr, s.getUnsignedValue(), false);
                return true;
            }
            modUnknown = true;
        } else if ("MOVFP".equals(mnemonic) || "MOVPF".equals(mnemonic)) {
            Object[] objs = instr.getOpObjects(1);
            if (objs.length == 0) {
                return false;
            }
            if (this.wReg.equals(objs[0]) || this.wReg.getAddress().equals(objs[0])) {
                this.wContext.setValueUnknown();
                return true;
            }
        } else if (REG_S_MODIFICATION_MNEMONICS.contains(mnemonic) && instr.getNumOperands() == 2) {
            List repObjs = instr.getDefaultOperandRepresentationList(1);
            if (repObjs.size() == 1 && S_0.equals(repObjs.get(0))) {
                this.wContext.setValueUnknown();
                return false;
            }
        } else if (REG_MODIFICATION_MNEMONICS.contains(mnemonic) && instr.getNumOperands() == 2) {
            List repObjs = instr.getDefaultOperandRepresentationList(1);
            if (repObjs.size() == 1 && DEST_W.equals(repObjs.get(0))) {
                this.wContext.setValueUnknown();
                return true;
            }
        } else if (WREG_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            modUnknown = true;
        }
        if (modUnknown) {
            this.wContext.setValueUnknown();
            return true;
        }
        return false;
    }

    private void checkRegisterAccess(Instruction instr) {
        Object[] objs;
        if (instr.getNumOperands() == 0) {
            return;
        }
        String mnemonic = instr.getMnemonicString();
        if ("MOVLB".equals(mnemonic)) {
            this.bsrContext.writeValue(instr.getMaxAddress());
            Scalar s = instr.getScalar(0);
            if (s != null) {
                long value = (this.bsrContext.hasValue() ? this.bsrContext.longValue() : 0L) & 0xF0L;
                this.bsrContext.setValueAt(instr, value |= s.getUnsignedValue() & 0xFL, false);
            } else {
                this.bsrContext.setValueUnknown();
            }
            return;
        }
        if ("MOVLR".equals(mnemonic)) {
            this.bsrContext.writeValue(instr.getMaxAddress());
            Scalar s = instr.getScalar(0);
            if (s != null) {
                long value = (this.bsrContext.hasValue() ? this.bsrContext.longValue() : 0L) & 0xFL;
                this.bsrContext.setValueAt(instr, value |= (s.getUnsignedValue() & 0xFL) << 4, false);
            } else {
                this.bsrContext.setValueUnknown();
            }
            return;
        }
        int opIndex = 0;
        if ("MOVFP".equals(mnemonic) || "MOVPF".equals(mnemonic)) {
            opIndex = 1;
        }
        if ((objs = instr.getOpObjects(opIndex)).length == 0) {
            return;
        }
        if (this.alustaReg.equals(objs[0]) || this.alustaReg.getAddress().equals(objs[0])) {
            this.handleStatusModification(instr);
        }
        if (this.bsrReg.equals(objs[0]) || this.bsrReg.getAddress().equals(objs[0])) {
            this.handleBSRModification(instr);
        } else if (this.pclathReg.equals(objs[0]) || this.pclathReg.getAddress().equals(objs[0])) {
            this.handlePclathModification(instr);
        } else if (this.pclReg.equals(objs[0]) || this.pclReg.getAddress().equals(objs[0])) {
            this.handlePclModification(instr);
        } else if (this.isRead(instr, this.pclReg)) {
            this.pclathContext.writeValue(instr.getMaxAddress());
            this.pclathContext.setValueAt(instr, instr.getMaxAddress().add(1L).getOffset() >> 8, false);
        }
    }

    private void handleStatusModification(Instruction instr) {
        this.fs32Context.writeValue(instr.getMaxAddress());
        this.fs10Context.writeValue(instr.getMaxAddress());
        String mnemonic = instr.getMnemonicString();
        if ("CLRF".equals(mnemonic)) {
            this.fs32Context.setValueAt(instr, 0L, false);
            this.fs10Context.setValueAt(instr, 0L, false);
        } else if ("SETF".equals(mnemonic)) {
            this.fs32Context.setValueAt(instr, 3L, false);
            this.fs10Context.setValueAt(instr, 3L, false);
        } else if ("BSF".equals(mnemonic)) {
            Scalar s = instr.getScalar(1);
            boolean success = false;
            if (s != null) {
                int bit = (int)s.getUnsignedValue();
                success = bit == 6 || bit == 7 ? this.fs32Context.setBitAt(instr, bit - 6) : (bit == 4 || bit == 5 ? this.fs10Context.setBitAt(instr, bit - 4) : true);
            }
            if (!success) {
                Msg.warn((Object)((Object)this), (Object)("Unhandled ALUSTA bit-set at: " + instr.getMinAddress()));
            }
        } else if ("BCF".equals(mnemonic)) {
            Scalar s = instr.getScalar(1);
            boolean success = false;
            if (s != null) {
                int bit = (int)s.getUnsignedValue();
                success = bit == 6 || bit == 7 ? this.fs32Context.clearBitAt(instr, bit - 6) : (bit == 4 || bit == 5 ? this.fs10Context.clearBitAt(instr, bit - 4) : true);
            }
            if (!success) {
                Msg.warn((Object)((Object)this), (Object)("Unhandled ALUSTA bit-set at: " + instr.getMinAddress()));
            }
        } else if ("BTG".equals(mnemonic)) {
            Scalar s = instr.getScalar(1);
            if (s != null) {
                RegisterContextBuilder ctx;
                byte bit = (byte)s.getUnsignedValue();
                if (bit == 6 || bit == 7) {
                    ctx = this.fs32Context;
                    bit = (byte)(bit - 6);
                } else if (bit == 4 || bit == 5) {
                    ctx = this.fs10Context;
                    bit = (byte)(bit - 4);
                } else {
                    return;
                }
                if (!ctx.hasValue()) {
                    return;
                }
                byte bitmask = (byte)(1 << bit);
                long fsVal = ctx.longValue();
                fsVal = (fsVal & (long)bitmask) == 0L ? (long)((byte)(fsVal | (long)bitmask)) : (long)((byte)(fsVal & (long)(~bitmask)));
                ctx.setValueAt(instr, fsVal, false);
            } else {
                Msg.warn((Object)((Object)this), (Object)("Unhandled ALUSTA bit-toggle at: " + instr.getMinAddress()));
                this.fs32Context.setValueUnknown();
                this.fs10Context.setValueUnknown();
            }
        } else if ("MOVWF".equals(mnemonic)) {
            if (this.wContext.hasValue()) {
                this.fs32Context.setValueAt(instr, this.wContext.longValue() >> 6, false);
                this.fs10Context.setValueAt(instr, this.wContext.longValue() >> 4, false);
            } else {
                this.fs32Context.setValueUnknown();
                this.fs10Context.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled ALUSTA change at: " + instr.getMinAddress()));
            }
        } else if ("MOVFP".equals(mnemonic) || "MOVPF".equals(mnemonic)) {
            Object[] objs = instr.getOpObjects(0);
            if (objs.length == 0 && (this.wReg.equals(objs[0]) || this.wReg.getAddress().equals(objs[0])) && this.wContext.hasValue()) {
                this.fs32Context.setValueAt(instr, this.wContext.longValue() >> 6, false);
                this.fs10Context.setValueAt(instr, this.wContext.longValue() >> 4, false);
            } else {
                this.fs32Context.setValueUnknown();
                this.fs10Context.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled ALUSTA change at: " + instr.getMinAddress()));
            }
        } else if (REG_S_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            this.fs32Context.setValueUnknown();
            this.fs10Context.setValueUnknown();
            Msg.warn((Object)((Object)this), (Object)("Unhandled ALUSTA change at: " + instr.getMinAddress()));
        } else if (REG_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            if (instr.getNumOperands() == 2) {
                List repObjs = instr.getDefaultOperandRepresentationList(1);
                if (repObjs.size() == 1 && DEST_FREG.equals(repObjs.get(0))) {
                    this.fs32Context.setValueUnknown();
                    this.fs10Context.setValueUnknown();
                    Msg.warn((Object)((Object)this), (Object)("Unhandled ALUSTA change at: " + instr.getMinAddress()));
                }
            } else if (instr.getNumOperands() == 1) {
                this.fs32Context.setValueUnknown();
                this.fs10Context.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled ALUSTA change at: " + instr.getMinAddress()));
            }
        }
    }

    private void handleBSRModification(Instruction instr) {
        this.bsrContext.writeValue(instr.getMaxAddress());
        String mnemonic = instr.getMnemonicString();
        if ("CLRF".equals(mnemonic)) {
            this.bsrContext.setValueAt(instr, 0L, false);
        } else if ("BSF".equals(mnemonic)) {
            if (!this.bsrContext.setBitAt(instr, instr.getScalar(1), 0)) {
                Msg.warn((Object)((Object)this), (Object)("Unhandled BSR bit-set at: " + instr.getMinAddress()));
            }
        } else if ("BCF".equals(mnemonic)) {
            if (!this.bsrContext.clearBitAt(instr, instr.getScalar(1), 0)) {
                Msg.warn((Object)((Object)this), (Object)("Unhandled BSR bit-set at: " + instr.getMinAddress()));
            }
        } else if ("BTG".equals(mnemonic)) {
            Scalar s = instr.getScalar(1);
            if (s != null && this.bsrContext.hasValue()) {
                byte bitmask = (byte)(1 << (int)s.getUnsignedValue());
                long bsrVal = this.bsrContext.longValue();
                bsrVal = (bsrVal & (long)bitmask) == 0L ? (long)((byte)(bsrVal | (long)bitmask)) : (long)((byte)(bsrVal & (long)(~bitmask)));
                this.bsrContext.setValueAt(instr, bsrVal, false);
            } else {
                Msg.warn((Object)((Object)this), (Object)("Unhandled BSR bit-toggle at: " + instr.getMinAddress()));
                this.bsrContext.setValueUnknown();
            }
        } else if ("MOVWF".equals(mnemonic)) {
            if (this.wContext.hasValue()) {
                this.bsrContext.setValueAt(instr, this.wContext.longValue(), false);
            } else {
                this.bsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled BSR change at: " + instr.getMinAddress()));
            }
        } else if ("MOVFP".equals(mnemonic) || "MOVPF".equals(mnemonic)) {
            Object[] objs = instr.getOpObjects(0);
            if (objs.length == 0 && (this.wReg.equals(objs[0]) || this.wReg.getAddress().equals(objs[0])) && this.wContext.hasValue()) {
                this.bsrContext.setValueAt(instr, this.wContext.longValue(), false);
            } else {
                this.bsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled BSR change at: " + instr.getMinAddress()));
            }
        } else if (REG_S_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            this.bsrContext.setValueUnknown();
            Msg.warn((Object)((Object)this), (Object)("Unhandled BSR change at: " + instr.getMinAddress()));
        } else if (REG_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            if (instr.getNumOperands() == 2) {
                List repObjs = instr.getDefaultOperandRepresentationList(1);
                if (repObjs.size() == 1 && DEST_FREG.equals(repObjs.get(0))) {
                    this.bsrContext.setValueUnknown();
                    Msg.warn((Object)((Object)this), (Object)("Unhandled BSR change at: " + instr.getMinAddress()));
                }
            } else if (instr.getNumOperands() == 1) {
                this.bsrContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled BSR change at: " + instr.getMinAddress()));
            }
        }
    }

    private void handlePclathModification(Instruction instr) {
        this.pclathContext.writeValue(instr.getMaxAddress());
        String mnemonic = instr.getMnemonicString();
        if ("CLRF".equals(mnemonic)) {
            this.pclathContext.setValueAt(instr, 0L, false);
        } else if ("BSF".equals(mnemonic)) {
            if (!this.pclathContext.setBitAt(instr, instr.getScalar(1), 0)) {
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH bit-set at: " + instr.getMinAddress()));
            }
        } else if ("BCF".equals(mnemonic)) {
            if (!this.pclathContext.clearBitAt(instr, instr.getScalar(1), 0)) {
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH bit-set at: " + instr.getMinAddress()));
            }
        } else if ("INCF".equals(mnemonic)) {
            if (this.pclathContext.hasValue()) {
                this.pclathContext.setValueAt(instr, this.pclathContext.longValue() + 1L, false);
            } else {
                this.pclathContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH change at: " + instr.getMinAddress()));
            }
        } else if ("DECF".equals(mnemonic)) {
            if (this.pclathContext.hasValue()) {
                this.pclathContext.setValueAt(instr, this.pclathContext.longValue() - 1L, false);
            } else {
                this.pclathContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH change at: " + instr.getMinAddress()));
            }
        } else if ("MOVWF".equals(mnemonic)) {
            if (this.wContext.hasValue()) {
                this.pclathContext.setValueAt(instr, this.wContext.longValue(), false);
            } else {
                this.pclathContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH change at: " + instr.getMinAddress()));
            }
        } else if ("MOVFP".equals(mnemonic) || "MOVPF".equals(mnemonic)) {
            Object[] objs = instr.getOpObjects(0);
            if (objs.length == 0 && (this.wReg.equals(objs[0]) || this.wReg.getAddress().equals(objs[0])) && this.wContext.hasValue()) {
                this.pclathContext.setValueAt(instr, this.wContext.longValue(), false);
            } else {
                this.pclathContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH change at: " + instr.getMinAddress()));
            }
        } else if (REG_S_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            this.pclathContext.setValueUnknown();
            Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH change at: " + instr.getMinAddress()));
        } else if (REG_MODIFICATION_MNEMONICS.contains(mnemonic)) {
            if (instr.getNumOperands() == 2) {
                List repObjs = instr.getDefaultOperandRepresentationList(1);
                if (repObjs.size() == 1 && DEST_FREG.equals(repObjs.get(0))) {
                    this.pclathContext.setValueUnknown();
                    Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH change at: " + instr.getMinAddress()));
                }
            } else if (instr.getNumOperands() == 1) {
                this.pclathContext.setValueUnknown();
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCLATH change at: " + instr.getMinAddress()));
            }
        }
    }

    private void handlePclModification(Instruction instr) {
        String mnemonic = instr.getMnemonicString();
        if ("MOVWF".equals(mnemonic)) {
            if (this.wContext.hasValue()) {
                this.handleComputedFlow(instr, this.wContext.longValue(), -1);
            } else {
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCL modification (WREG unknown): " + instr.getMinAddress()));
            }
        } else if ("MOVFP".equals(mnemonic) || "MOVPF".equals(mnemonic)) {
            Object[] objs = instr.getOpObjects(0);
            if (objs.length == 0 && (this.wReg.equals(objs[0]) || this.wReg.getAddress().equals(objs[0])) && this.wContext.hasValue()) {
                this.handleComputedFlow(instr, this.wContext.longValue(), -1);
            } else {
                Msg.warn((Object)((Object)this), (Object)("Unhandled PCL modification (WREG unknown): " + instr.getMinAddress()));
            }
        }
    }

    private void handleComputedFlow(Instruction instr, long pclByte, int refOpIndex) {
        if (this.pclathContext.hasValue()) {
            long offset = ((this.pclathContext.longValue() << 8) + pclByte) * 2L;
            Address destAddr = instr.getMinAddress().getNewAddress(offset);
            this.refMgr.addMemoryReference(instr.getMinAddress(), destAddr, (RefType)instr.getFlowType(), SourceType.ANALYSIS, refOpIndex);
            if (this.listing.getUndefinedDataAt(destAddr) != null) {
                try {
                    this.program.getProgramContext().setValue(this.pclathReg, destAddr, destAddr, this.pclathContext.value());
                    this.disassembleAt(destAddr);
                }
                catch (ContextChangeException e) {
                    Msg.error((Object)((Object)this), (Object)"Unexpected Error", (Throwable)e);
                }
            }
        }
    }

    private Instruction getFallFrom(Instruction instr) {
        Address fallFromAddr;
        if (instr != null && (fallFromAddr = instr.getFallFrom()) != null) {
            return this.listing.getInstructionAt(fallFromAddr);
        }
        return null;
    }

    private boolean isRead(Instruction instr, Register reg) {
        Object[] objs;
        for (Object obj : objs = instr.getInputObjects()) {
            if (!(obj instanceof Address) || !reg.getAddress().equals(obj)) continue;
            return true;
        }
        return false;
    }

    static {
        WREG_MODIFICATION_MNEMONICS.add("ADDLW");
        WREG_MODIFICATION_MNEMONICS.add("ANDLW");
        WREG_MODIFICATION_MNEMONICS.add("IORLW");
        WREG_MODIFICATION_MNEMONICS.add("MOVLW");
        WREG_MODIFICATION_MNEMONICS.add("SUBLW");
        WREG_MODIFICATION_MNEMONICS.add("XORLW");
        REG_S_MODIFICATION_MNEMONICS = new HashSet();
        REG_S_MODIFICATION_MNEMONICS.add("CLRF");
        REG_S_MODIFICATION_MNEMONICS.add("DAW");
        REG_S_MODIFICATION_MNEMONICS.add("NEGW");
        REG_S_MODIFICATION_MNEMONICS.add("SETF");
        REG_MODIFICATION_MNEMONICS = new HashSet();
        REG_MODIFICATION_MNEMONICS.add("ADDWF");
        REG_MODIFICATION_MNEMONICS.add("ADDWFC");
        REG_MODIFICATION_MNEMONICS.add("ANDWF");
        REG_MODIFICATION_MNEMONICS.add("COMF");
        REG_MODIFICATION_MNEMONICS.add("DECF");
        REG_MODIFICATION_MNEMONICS.add("DECFSZ");
        REG_MODIFICATION_MNEMONICS.add("DCFSNZ");
        REG_MODIFICATION_MNEMONICS.add("INCF");
        REG_MODIFICATION_MNEMONICS.add("INCFSZ");
        REG_MODIFICATION_MNEMONICS.add("INCFNZ");
        REG_MODIFICATION_MNEMONICS.add("IORWF");
        REG_MODIFICATION_MNEMONICS.add("MOVWF");
        REG_MODIFICATION_MNEMONICS.add("RLCF");
        REG_MODIFICATION_MNEMONICS.add("RLNCF");
        REG_MODIFICATION_MNEMONICS.add("RRCF");
        REG_MODIFICATION_MNEMONICS.add("RRNCF");
        REG_MODIFICATION_MNEMONICS.add("SUBWF");
        REG_MODIFICATION_MNEMONICS.add("SUBWFB");
        REG_MODIFICATION_MNEMONICS.add("SWAPF");
        REG_MODIFICATION_MNEMONICS.add("XORWF");
        FREG_INSTRUCTIONS = new HashSet();
        FREG_INSTRUCTIONS.add("ADDWF");
        FREG_INSTRUCTIONS.add("ADDWFC");
        FREG_INSTRUCTIONS.add("ANDWF");
        FREG_INSTRUCTIONS.add("CLRF");
        FREG_INSTRUCTIONS.add("COMF");
        FREG_INSTRUCTIONS.add("CPFSEQ");
        FREG_INSTRUCTIONS.add("CPFSGT");
        FREG_INSTRUCTIONS.add("CPFSLT");
        FREG_INSTRUCTIONS.add("DAW");
        FREG_INSTRUCTIONS.add("DECF");
        FREG_INSTRUCTIONS.add("DECFSZ");
        FREG_INSTRUCTIONS.add("DCFSNZ");
        FREG_INSTRUCTIONS.add("INCF");
        FREG_INSTRUCTIONS.add("INCFSZ");
        FREG_INSTRUCTIONS.add("INFSNZ");
        FREG_INSTRUCTIONS.add("IORWF");
        FREG_INSTRUCTIONS.add("MOVWF");
        FREG_INSTRUCTIONS.add("MULWF");
        FREG_INSTRUCTIONS.add("NEGW");
        FREG_INSTRUCTIONS.add("RLCF");
        FREG_INSTRUCTIONS.add("RLNCF");
        FREG_INSTRUCTIONS.add("RRCF");
        FREG_INSTRUCTIONS.add("RRNCF");
        FREG_INSTRUCTIONS.add("SETF");
        FREG_INSTRUCTIONS.add("SUBWF");
        FREG_INSTRUCTIONS.add("SUBWFB");
        FREG_INSTRUCTIONS.add("SWAPF");
        FREG_INSTRUCTIONS.add("TSTFSZ");
        FREG_INSTRUCTIONS.add("XORWF");
        FREG_BIT_INSTRUCTIONS = new HashSet();
        FREG_BIT_INSTRUCTIONS.add("BCF");
        FREG_BIT_INSTRUCTIONS.add("BSF");
        FREG_BIT_INSTRUCTIONS.add("BTFSC");
        FREG_BIT_INSTRUCTIONS.add("BTFSS");
        FREG_BIT_INSTRUCTIONS.add("BTG");
        SKIP_INSTRUCTIONS = new HashSet();
        SKIP_INSTRUCTIONS.add("CPFSEQ");
        SKIP_INSTRUCTIONS.add("CPFSGT");
        SKIP_INSTRUCTIONS.add("CPFSLT");
        SKIP_INSTRUCTIONS.add("DECFSZ");
        SKIP_INSTRUCTIONS.add("DCFSNZ");
        SKIP_INSTRUCTIONS.add("INCFSZ");
        SKIP_INSTRUCTIONS.add("INFSNZ");
        SKIP_INSTRUCTIONS.add("TSTFSZ");
        SKIP_INSTRUCTIONS.add("BTFSC");
        SKIP_INSTRUCTIONS.add("BTFSS");
        FREG_BIT_NAMES_MAP = new HashMap();
        FREG_BIT_NAMES_MAP.put("ALUSTA", new String[]{"C", "DC", "Z", "OV", "FS0", "FS1", "FS2", "FS3"});
        FREG_BIT_NAMES_MAP.put("T0STA", new String[]{null, "T0SP0", "T0PS1", "T0PS2", "T0PS3", "T0CS", "T0SE", "INTEDG"});
        FREG_BIT_NAMES_MAP.put("CPUSTA", new String[]{"!BOR", "!POR", "!PD", "!TO", "GLINTD", "STKAV"});
        FREG_BIT_NAMES_MAP.put("INTSTA", new String[]{"INTE", "T0IE", "T0CKIE", "PEIE", "INTF", "T0IF", "T0CKIF", "PEIF"});
        FREG_BIT_NAMES_MAP.put("RCSTA1", new String[]{"RX9D", "OERR", "FERR", null, "CREN", "SREN", "RX9", "SPEN"});
        FREG_BIT_NAMES_MAP.put("TXSTA1", new String[]{"TX9D", "TRMT", null, null, "SYNC", "TXEN", "TX9", "CSRC"});
        FREG_BIT_NAMES_MAP.put("PIR1", new String[]{"RC1IF", "TX1IF", "CA1IF", "CA2IF", "TMR1IF", "TMR2IF", "TMR3IF", "RBIF"});
        FREG_BIT_NAMES_MAP.put("PIE1", new String[]{"RC1IE", "TX1IE", "CA1IE", "CA2IE", "TMR1IE", "TMR2IE", "TMR3IE", "RBIE"});
        FREG_BIT_NAMES_MAP.put("PW1DCL", new String[]{null, null, null, null, null, null, "DC0", "DC1"});
        FREG_BIT_NAMES_MAP.put("PW2DCL", new String[]{null, null, null, null, null, "TM2PW2", "DC0", "DC1"});
        FREG_BIT_NAMES_MAP.put("PW1DCH", new String[]{"DC2", "DC3", "DC4", "DC5", "DC6", "DC7", "DC8", "DC9"});
        FREG_BIT_NAMES_MAP.put("PW2DCH", new String[]{"DC2", "DC3", "DC4", "DC5", "DC6", "DC7", "DC8", "DC9"});
        FREG_BIT_NAMES_MAP.put("TCON1", new String[]{"TMR1CS", "TMR2CS", "TMR3CS", "T16", "CA1ED0", "CA1ED1", "CA2ED0", "CA2ED1"});
        FREG_BIT_NAMES_MAP.put("TCON2", new String[]{"TMR1ON", "TMR2ON", "TMR3ON", "CA1!PR3", "PWM1ON", "PWM2ON", "CA1OVF", "CA2OVF"});
        FREG_BIT_NAMES_MAP.put("PIR2", new String[]{"RC2IF", "TX2IF", "CA3IF", "CA4IF", null, "ADIF", "BCLIF", "SSPIF"});
        FREG_BIT_NAMES_MAP.put("PIE2", new String[]{"RC2IE", "TX2IF", "CA3IF", "CA4IF", null, "ADIE", "BCLIE", "SSPIE"});
        FREG_BIT_NAMES_MAP.put("RCSTA2", new String[]{"RX9D", "OERR", "FERR", null, "CREN", "SREN", "RX9", "SPEN"});
        FREG_BIT_NAMES_MAP.put("TXSTA2", new String[]{"TX9D", "TRMT", null, null, "SYNC", "TXEN", "TX9", "CSRC"});
        FREG_BIT_NAMES_MAP.put("ADCON0", new String[]{"ADON", null, "GO!DONE", null, "CHS0", "CHS1", "CHS2", "CHS3"});
        FREG_BIT_NAMES_MAP.put("ADCON1", new String[]{"PCFG0", "PCFG1", "PCFG2", "PCFG3", null, "ADFM", "ADCS0", "ADCS1"});
    }
}

