/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptLoadException;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.python.PythonScript;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;

public class PythonScriptProvider
extends GhidraScriptProvider {
    private static final Pattern BLOCK_COMMENT = Pattern.compile("'''");

    public void createNewScript(ResourceFile newScript, String category) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(newScript.getFile(false)));
        this.writeHeader(writer, category);
        writer.println("");
        this.writeBody(writer);
        writer.println("");
        writer.close();
    }

    public Pattern getBlockCommentStart() {
        return BLOCK_COMMENT;
    }

    public Pattern getBlockCommentEnd() {
        return BLOCK_COMMENT;
    }

    public String getCommentCharacter() {
        return "#";
    }

    protected String getCertifyHeaderStart() {
        return "## ###";
    }

    protected String getCertificationBodyPrefix() {
        return "#";
    }

    protected String getCertifyHeaderEnd() {
        return "##";
    }

    public String getDescription() {
        return "Python";
    }

    public String getExtension() {
        return ".py";
    }

    public GhidraScript getScriptInstance(ResourceFile sourceFile, PrintWriter writer) throws GhidraScriptLoadException {
        try {
            Class<?> clazz = Class.forName(PythonScript.class.getName());
            GhidraScript script = (GhidraScript)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            script.setSourceFile(sourceFile);
            return script;
        }
        catch (Exception e) {
            throw new GhidraScriptLoadException((Throwable)e);
        }
    }
}

