/* ###
 * IP: Apache License 2.0 with LLVM Exceptions
 */
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif



#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include <string>


typedef jbyte ByteArray;

SWIGINTERN ByteArray *new_ByteArray(int nelements){
  return new jbyte[nelements]();
}
SWIGINTERN void delete_ByteArray(ByteArray *self){
  delete [] self;
}
SWIGINTERN jbyte ByteArray_getitem(ByteArray *self,int index){
  return self[index];
}
SWIGINTERN void ByteArray_setitem(ByteArray *self,int index,jbyte value){
  self[index] = value;
}
SWIGINTERN jbyte *ByteArray_cast(ByteArray *self){
  return self;
}
SWIGINTERN ByteArray *ByteArray_frompointer(jbyte *t){
  return (ByteArray *) t;
}

#include <algorithm>
#include <string>


#include "lldb/lldb-public.h"
#include "lldb/API/SBAddress.h"
#include "lldb/API/SBAttachInfo.h"
#include "lldb/API/SBBlock.h"
#include "lldb/API/SBBreakpoint.h"
#include "lldb/API/SBBreakpointLocation.h"
#include "lldb/API/SBBreakpointName.h"
#include "lldb/API/SBBroadcaster.h"
#include "lldb/API/SBCommandInterpreter.h"
#include "lldb/API/SBCommandInterpreterRunOptions.h"
#include "lldb/API/SBCommandReturnObject.h"
#include "lldb/API/SBCommunication.h"
#include "lldb/API/SBCompileUnit.h"
#include "lldb/API/SBData.h"
#include "lldb/API/SBDebugger.h"
#include "lldb/API/SBDeclaration.h"
#include "lldb/API/SBEnvironment.h"
#include "lldb/API/SBError.h"
#include "lldb/API/SBEvent.h"
#include "lldb/API/SBExecutionContext.h"
#include "lldb/API/SBExpressionOptions.h"
#include "lldb/API/SBFile.h"
#include "lldb/API/SBFileSpec.h"
#include "lldb/API/SBFileSpecList.h"
#include "lldb/API/SBFrame.h"
#include "lldb/API/SBFunction.h"
#include "lldb/API/SBHostOS.h"
#include "lldb/API/SBInstruction.h"
#include "lldb/API/SBInstructionList.h"
#include "lldb/API/SBLanguageRuntime.h"
#include "lldb/API/SBLaunchInfo.h"
#include "lldb/API/SBLineEntry.h"
#include "lldb/API/SBListener.h"
#include "lldb/API/SBMemoryRegionInfo.h"
#include "lldb/API/SBMemoryRegionInfoList.h"
#include "lldb/API/SBModule.h"
#include "lldb/API/SBModuleSpec.h"
#include "lldb/API/SBPlatform.h"
#include "lldb/API/SBProcess.h"
#include "lldb/API/SBProcessInfo.h"
#include "lldb/API/SBQueue.h"
#include "lldb/API/SBQueueItem.h"
#include "lldb/API/SBReproducer.h"
#include "lldb/API/SBSection.h"
#include "lldb/API/SBSourceManager.h"
#include "lldb/API/SBStream.h"
#include "lldb/API/SBStringList.h"
#include "lldb/API/SBStructuredData.h"
#include "lldb/API/SBSymbol.h"
#include "lldb/API/SBSymbolContext.h"
#include "lldb/API/SBSymbolContextList.h"
#include "lldb/API/SBTarget.h"
#include "lldb/API/SBThread.h"
#include "lldb/API/SBThreadCollection.h"
#include "lldb/API/SBThreadPlan.h"
#include "lldb/API/SBTrace.h"
#include "lldb/API/SBType.h"
#include "lldb/API/SBTypeCategory.h"
#include "lldb/API/SBTypeEnumMember.h"
#include "lldb/API/SBTypeFilter.h"
#include "lldb/API/SBTypeFormat.h"
#include "lldb/API/SBTypeNameSpecifier.h"
#include "lldb/API/SBTypeSummary.h"
#include "lldb/API/SBTypeSynthetic.h"
#include "lldb/API/SBUnixSignals.h"
#include "lldb/API/SBValue.h"
#include "lldb/API/SBValueList.h"
#include "lldb/API/SBVariablesOptions.h"
#include "lldb/API/SBWatchpoint.h"


using namespace lldb_private;
using namespace lldb;


#include <stdint.h>		// Use the C99 official header

SWIGINTERN std::string lldb_SBAddress___repr__(lldb::SBAddress *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBBlock___repr__(lldb::SBBlock *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBBreakpoint___repr__(lldb::SBBreakpoint *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBBreakpointLocation___repr__(lldb::SBBreakpointLocation *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelFull);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBBreakpointName___repr__(lldb::SBBreakpointName *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBCommandReturnObject___repr__(lldb::SBCommandReturnObject *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN void lldb_SBCommandReturnObject_SetImmediateOutputFile__SWIG_2(lldb::SBCommandReturnObject *self,lldb::FileSP BORROWED,bool transfer_ownership){
            self->SetImmediateOutputFile(BORROWED);
        }
SWIGINTERN void lldb_SBCommandReturnObject_SetImmediateErrorFile__SWIG_2(lldb::SBCommandReturnObject *self,lldb::FileSP BORROWED,bool transfer_ownership){
            self->SetImmediateErrorFile(BORROWED);
        }
SWIGINTERN void lldb_SBCommandReturnObject_Print(lldb::SBCommandReturnObject *self,char const *str){
            self->Printf("%s", str);
        }
SWIGINTERN std::string lldb_SBCompileUnit___repr__(lldb::SBCompileUnit *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBData___repr__(lldb::SBData *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN lldb::FileSP lldb_SBDebugger_GetInputFileHandle(lldb::SBDebugger *self){
            return self->GetInputFile().GetFile();
        }
SWIGINTERN lldb::FileSP lldb_SBDebugger_GetOutputFileHandle(lldb::SBDebugger *self){
            return self->GetOutputFile().GetFile();
        }
SWIGINTERN lldb::FileSP lldb_SBDebugger_GetErrorFileHandle(lldb::SBDebugger *self){
            return self->GetErrorFile().GetFile();
        }
SWIGINTERN std::string lldb_SBDebugger___repr__(lldb::SBDebugger *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBDeclaration___repr__(lldb::SBDeclaration *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBError___repr__(lldb::SBError *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN lldb::SBFile lldb_SBFile_MakeBorrowed(lldb::FileSP BORROWED){
            return lldb::SBFile(BORROWED);
        }
SWIGINTERN lldb::SBFile lldb_SBFile_MakeForcingIOMethods(lldb::FileSP FORCE_IO_METHODS){
            return lldb::SBFile(FORCE_IO_METHODS);
        }
SWIGINTERN lldb::SBFile lldb_SBFile_MakeBorrowedForcingIOMethods(lldb::FileSP BORROWED_FORCE_IO_METHODS){
            return lldb::SBFile(BORROWED_FORCE_IO_METHODS);
        }
SWIGINTERN std::string lldb_SBFileSpec___repr__(lldb::SBFileSpec *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBFrame___repr__(lldb::SBFrame *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBFunction___repr__(lldb::SBFunction *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBInstruction___repr__(lldb::SBInstruction *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBInstructionList___repr__(lldb::SBInstructionList *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBLineEntry___repr__(lldb::SBLineEntry *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBMemoryRegionInfo___repr__(lldb::SBMemoryRegionInfo *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBModule___repr__(lldb::SBModule *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBModuleSpec___repr__(lldb::SBModuleSpec *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBModuleSpecList___repr__(lldb::SBModuleSpecList *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBProcess___repr__(lldb::SBProcess *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBSection___repr__(lldb::SBSection *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN void lldb_SBStream_RedirectToFileHandle(lldb::SBStream *self,lldb::FileSP file,bool transfer_fh_ownership){
            self->RedirectToFile(file);
        }
SWIGINTERN std::string lldb_SBSymbol___repr__(lldb::SBSymbol *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBSymbolContext___repr__(lldb::SBSymbolContext *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBSymbolContextList___repr__(lldb::SBSymbolContextList *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTarget___repr__(lldb::SBTarget *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBThread___repr__(lldb::SBThread *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeMember___repr__(lldb::SBTypeMember *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeMemberFunction___repr__(lldb::SBTypeMemberFunction *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBType___repr__(lldb::SBType *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeCategory___repr__(lldb::SBTypeCategory *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeEnumMember___repr__(lldb::SBTypeEnumMember *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeFilter___repr__(lldb::SBTypeFilter *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeFormat___repr__(lldb::SBTypeFormat *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeNameSpecifier___repr__(lldb::SBTypeNameSpecifier *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeSummary___repr__(lldb::SBTypeSummary *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBTypeSynthetic___repr__(lldb::SBTypeSynthetic *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelBrief);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBValue___repr__(lldb::SBValue *self){
    lldb::SBStream stream;
    self->GetDescription (stream);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }
SWIGINTERN std::string lldb_SBValueList___str__(lldb::SBValueList *self){
           lldb::SBStream description;
           const size_t n = self->GetSize();
           if (n)
           {
               for (size_t i=0; i<n; ++i)
                   self->GetValueAtIndex(i).GetDescription(description);
           }
           else
           {
               description.Printf("<empty> lldb.SBValueList()");
           }
           const char *desc = description.GetData();
           size_t desc_len = description.GetSize();
           if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r'))
               --desc_len;
           return std::string(desc, desc_len);
       }
SWIGINTERN std::string lldb_SBWatchpoint___repr__(lldb::SBWatchpoint *self){
    lldb::SBStream stream;
    self->GetDescription (stream, lldb::eDescriptionLevelVerbose);
    const char *desc = stream.GetData();
    size_t desc_len = stream.GetSize();
    if (desc_len > 0 && (desc[desc_len-1] == '\n' || desc[desc_len-1] == '\r')) {
      --desc_len;
    }
    return std::string(desc, desc_len);
  }

#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1ByteArray(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  ByteArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (ByteArray *)new_ByteArray(arg1);
  *(ByteArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1ByteArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ByteArray *arg1 = (ByteArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ByteArray **)&jarg1; 
  delete_ByteArray(arg1);
}


SWIGEXPORT jbyte JNICALL Java_SWIG_lldbJNI_ByteArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jbyte jresult = 0 ;
  ByteArray *arg1 = (ByteArray *) 0 ;
  int arg2 ;
  jbyte result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ByteArray **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ByteArray_getitem(arg1,arg2);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_ByteArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jbyte jarg3) {
  ByteArray *arg1 = (ByteArray *) 0 ;
  int arg2 ;
  jbyte arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ByteArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3; 
  ByteArray_setitem(arg1,arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_ByteArray_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ByteArray *arg1 = (ByteArray *) 0 ;
  jbyte *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ByteArray **)&jarg1; 
  result = (jbyte *)ByteArray_cast(arg1);
  *(jbyte **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_ByteArray_1frompointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  jbyte *arg1 = (jbyte *) 0 ;
  ByteArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(jbyte **)&jarg1; 
  result = (ByteArray *)ByteArray_frompointer(arg1);
  *(ByteArray **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_INT32_1MAX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(2147483647);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_UINT32_1MAX_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_UINT64_1MAX_1get(JNIEnv *jenv, jclass jcls) {
  jobject jresult = 0 ;
  unsigned long long result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned long long)(18446744073709551615ULL);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1GENERIC_1ERROR_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1BREAK_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1DEFAULT_1BREAK_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1WATCH_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1WATCH_1TYPE_1READ_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1u << 0));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1WATCH_1TYPE_1WRITE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1u << 1));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1PC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1SP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1FP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1RA_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1FLAGS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1ARG1_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1ARG2_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(6);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1ARG3_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(7);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1ARG4_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(8);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1ARG5_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(9);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1ARG6_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(10);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1ARG7_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(11);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1REGNUM_1GENERIC_1ARG8_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(12);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1STOP_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1ADDRESS_1get(JNIEnv *jenv, jclass jcls) {
  jobject jresult = 0 ;
  unsigned long long result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned long long)(18446744073709551615ULL);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1INDEX32_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1IVAR_1OFFSET_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1IMAGE_1TOKEN_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1MODULE_1VERSION_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1REGNUM_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1UID_1get(JNIEnv *jenv, jclass jcls) {
  jobject jresult = 0 ;
  unsigned long long result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned long long)(18446744073709551615ULL);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1PROCESS_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1THREAD_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1FRAME_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1SIGNAL_1NUMBER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(2147483647);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1OFFSET_1get(JNIEnv *jenv, jclass jcls) {
  jobject jresult = 0 ;
  unsigned long long result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned long long)(18446744073709551615ULL);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1LINE_1NUMBER_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1COLUMN_1NUMBER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1QUEUE_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(0);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1CPU_1ID_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(4294967295U);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_LLDB_1ARCH_1DEFAULT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)("systemArch");
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_LLDB_1ARCH_1DEFAULT_132BIT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)("systemArch32");
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_LLDB_1ARCH_1DEFAULT_164BIT_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)("systemArch64");
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1INVALID_1CPUTYPE_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((0xFFFFFFFEu));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_LLDB_1MAX_1NUM_1OPTION_1SETS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(32);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_1ALL_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(0xFFFFFFFFU);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_11_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 0));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_12_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 1));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_13_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 2));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_14_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 3));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_15_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 4));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_16_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 5));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_17_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 6));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_18_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 7));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_19_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 8));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_110_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 9));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_111_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 10));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_LLDB_1OPT_1SET_112_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)((1U << 11));
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eStateInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StateType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StateType)lldb::eStateInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_kLastStateType_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StateType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StateType)lldb::kLastStateType;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagNone_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagNone;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagExec_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagExec;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagDebug_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagDebug;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagStopAtEntry_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagStopAtEntry;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagDisableASLR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagDisableASLR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagDisableSTDIO_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagDisableSTDIO;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagLaunchInTTY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagLaunchInTTY;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagLaunchInShell_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagLaunchInShell;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagLaunchInSeparateProcessGroup_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagLaunchInSeparateProcessGroup;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagDontSetExitStatus_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagDontSetExitStatus;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagDetachOnError_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagDetachOnError;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagShellExpandArguments_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagShellExpandArguments;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagCloseTTYOnExit_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagCloseTTYOnExit;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLaunchFlagInheritTCCFromParent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LaunchFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LaunchFlags)lldb::eLaunchFlagInheritTCCFromParent;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eByteOrderInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ByteOrder result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ByteOrder)lldb::eByteOrderInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eByteOrderBig_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ByteOrder result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ByteOrder)lldb::eByteOrderBig;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eByteOrderPDP_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ByteOrder result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ByteOrder)lldb::eByteOrderPDP;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eByteOrderLittle_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ByteOrder result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ByteOrder)lldb::eByteOrderLittle;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eEncodingInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::Encoding result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::Encoding)lldb::eEncodingInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFormatDefault_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::Format result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::Format)lldb::eFormatDefault;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFormatInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::Format result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::Format)lldb::eFormatInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFormatComplexFloat_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::Format result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::Format)lldb::eFormatComplexFloat;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eDescriptionLevelBrief_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::DescriptionLevel result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::DescriptionLevel)lldb::eDescriptionLevelBrief;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eScriptLanguageNone_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ScriptLanguage result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ScriptLanguage)lldb::eScriptLanguageNone;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eScriptLanguageDefault_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ScriptLanguage result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ScriptLanguage)lldb::eScriptLanguageDefault;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eRegisterKindEHFrame_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::RegisterKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::RegisterKind)lldb::eRegisterKindEHFrame;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eStopReasonInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StopReason result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StopReason)lldb::eStopReasonInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eExpressionCompleted_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ExpressionResults result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ExpressionResults)lldb::eExpressionCompleted;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSearchDepthInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SearchDepth result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SearchDepth)lldb::eSearchDepthInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_kLastSearchDepthKind_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SearchDepth result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SearchDepth)lldb::kLastSearchDepthKind;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeVariableGlobal_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeVariableGlobal;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeVariableStatic_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeVariableStatic;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeVariableArgument_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeVariableArgument;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeVariableLocal_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeVariableLocal;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeRegister_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeRegister;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeRegisterSet_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeRegisterSet;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeConstResult_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeConstResult;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eValueTypeVariableThreadLocal_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ValueType)lldb::eValueTypeVariableThreadLocal;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eInputReaderGranularityInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::InputReaderGranularity result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::InputReaderGranularity)lldb::eInputReaderGranularityInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextTarget_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextTarget;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextModule_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextModule;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextCompUnit_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextCompUnit;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextFunction_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextFunction;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextBlock_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextBlock;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextLineEntry_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextLineEntry;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextSymbol_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextSymbol;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextEverything_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextEverything;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextVariable_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextVariable;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolContextLastItem_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolContextItem result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolContextItem)lldb::eSymbolContextLastItem;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_ePermissionsWritable_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::Permissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::Permissions)lldb::ePermissionsWritable;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_ePermissionsReadable_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::Permissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::Permissions)lldb::ePermissionsReadable;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_ePermissionsExecutable_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::Permissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::Permissions)lldb::ePermissionsExecutable;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeInvalidType_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeInvalidType;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeAdded_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeAdded;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeRemoved_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeRemoved;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeLocationsAdded_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeLocationsAdded;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeLocationsRemoved_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeLocationsRemoved;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeLocationsResolved_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeLocationsResolved;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeEnabled_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeEnabled;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeDisabled_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeDisabled;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeCommandChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeCommandChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeConditionChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeConditionChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeIgnoreChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeIgnoreChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeThreadChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeThreadChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBreakpointEventTypeAutoContinueChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BreakpointEventType)lldb::eBreakpointEventTypeAutoContinueChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeInvalidType_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeInvalidType;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeAdded_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeAdded;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeRemoved_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeRemoved;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeEnabled_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeEnabled;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeDisabled_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeDisabled;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeCommandChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeCommandChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeConditionChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeConditionChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeIgnoreChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeIgnoreChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeThreadChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeThreadChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointEventTypeTypeChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointEventType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointEventType)lldb::eWatchpointEventTypeTypeChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeUnknown_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeUnknown;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeC89_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeC89;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeC;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeAda83_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeAda83;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeC_1plus_1plus_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeC_plus_plus;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeCobol74_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeCobol74;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeCobol85_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeCobol85;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeFortran77_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeFortran77;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeFortran90_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeFortran90;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypePascal83_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypePascal83;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeModula2_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeModula2;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeJava_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeJava;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeC99_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeC99;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeAda95_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeAda95;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeFortran95_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeFortran95;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypePLI_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypePLI;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeObjC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeObjC;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeObjC_1plus_1plus_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeObjC_plus_plus;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeUPC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeUPC;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypePython_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypePython;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeOpenCL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeOpenCL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeGo_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeGo;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeModula3_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeModula3;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeHaskell_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeHaskell;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeC_1plus_1plus_103_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeC_plus_plus_03;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeC_1plus_1plus_111_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeC_plus_plus_11;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeOCaml_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeOCaml;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeRust_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeRust;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeC11_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeC11;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeSwift_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeSwift;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeJulia_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeJulia;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeDylan_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeDylan;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeC_1plus_1plus_114_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeC_plus_plus_14;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeFortran03_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeFortran03;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeFortran08_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeFortran08;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeMipsAssembler_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeMipsAssembler;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLanguageTypeExtRenderScript_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::LanguageType)lldb::eLanguageTypeExtRenderScript;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eInstrumentationRuntimeTypeAddressSanitizer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::InstrumentationRuntimeType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::InstrumentationRuntimeType)lldb::eInstrumentationRuntimeTypeAddressSanitizer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eInstrumentationRuntimeTypeThreadSanitizer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::InstrumentationRuntimeType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::InstrumentationRuntimeType)lldb::eInstrumentationRuntimeTypeThreadSanitizer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eInstrumentationRuntimeTypeUndefinedBehaviorSanitizer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::InstrumentationRuntimeType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::InstrumentationRuntimeType)lldb::eInstrumentationRuntimeTypeUndefinedBehaviorSanitizer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eInstrumentationRuntimeTypeMainThreadChecker_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::InstrumentationRuntimeType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::InstrumentationRuntimeType)lldb::eInstrumentationRuntimeTypeMainThreadChecker;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eInstrumentationRuntimeTypeSwiftRuntimeReporting_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::InstrumentationRuntimeType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::InstrumentationRuntimeType)lldb::eInstrumentationRuntimeTypeSwiftRuntimeReporting;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eNoDynamicValues_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::DynamicValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::DynamicValueType)lldb::eNoDynamicValues;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eDynamicCanRunTarget_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::DynamicValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::DynamicValueType)lldb::eDynamicCanRunTarget;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eDynamicDontRunTarget_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::DynamicValueType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::DynamicValueType)lldb::eDynamicDontRunTarget;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eStopShowColumnAnsiOrCaret_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StopShowColumn result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StopShowColumn)lldb::eStopShowColumnAnsiOrCaret;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eStopShowColumnAnsi_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StopShowColumn result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StopShowColumn)lldb::eStopShowColumnAnsi;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eStopShowColumnCaret_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StopShowColumn result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StopShowColumn)lldb::eStopShowColumnCaret;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eStopShowColumnNone_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StopShowColumn result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StopShowColumn)lldb::eStopShowColumnNone;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eArgTypeAddress_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandArgumentType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandArgumentType)lldb::eArgTypeAddress;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolTypeAny_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolType)lldb::eSymbolTypeAny;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSymbolTypeInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SymbolType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SymbolType)lldb::eSymbolTypeInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eEmulateInstructionOptionNone_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::EmulateInstructionOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::EmulateInstructionOptions)lldb::eEmulateInstructionOptionNone;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eEmulateInstructionOptionAutoAdvancePC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::EmulateInstructionOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::EmulateInstructionOptions)lldb::eEmulateInstructionOptionAutoAdvancePC;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eEmulateInstructionOptionIgnoreConditions_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::EmulateInstructionOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::EmulateInstructionOptions)lldb::eEmulateInstructionOptionIgnoreConditions;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFunctionNameTypeNone_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FunctionNameType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FunctionNameType)lldb::eFunctionNameTypeNone;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFunctionNameTypeAuto_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FunctionNameType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FunctionNameType)lldb::eFunctionNameTypeAuto;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFunctionNameTypeFull_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FunctionNameType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FunctionNameType)lldb::eFunctionNameTypeFull;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFunctionNameTypeBase_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FunctionNameType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FunctionNameType)lldb::eFunctionNameTypeBase;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFunctionNameTypeMethod_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FunctionNameType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FunctionNameType)lldb::eFunctionNameTypeMethod;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFunctionNameTypeSelector_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FunctionNameType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FunctionNameType)lldb::eFunctionNameTypeSelector;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFunctionNameTypeAny_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FunctionNameType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FunctionNameType)lldb::eFunctionNameTypeAny;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBasicTypeInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BasicType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BasicType)lldb::eBasicTypeInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eBasicTypeVoid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::BasicType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::BasicType)lldb::eBasicTypeVoid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTraceTypeNone_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TraceType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TraceType)lldb::eTraceTypeNone;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eStructuredDataTypeInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StructuredDataType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StructuredDataType)lldb::eStructuredDataTypeInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eStructuredDataTypeNull_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::StructuredDataType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::StructuredDataType)lldb::eStructuredDataTypeNull;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassInvalid_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassInvalid;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassArray_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassArray;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassBlockPointer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassBlockPointer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassBuiltin_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassBuiltin;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassClass_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassClass;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassComplexFloat_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassComplexFloat;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassComplexInteger_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassComplexInteger;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassEnumeration_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassEnumeration;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassFunction_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassFunction;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassMemberPointer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassMemberPointer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassObjCObject_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassObjCObject;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassObjCInterface_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassObjCInterface;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassObjCObjectPointer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassObjCObjectPointer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassPointer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassPointer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassReference_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassReference;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassStruct_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassStruct;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassTypedef_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassTypedef;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassUnion_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassUnion;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassVector_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassVector;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassOther_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassOther;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeClassAny_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeClass result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeClass)lldb::eTypeClassAny;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTemplateArgumentKindNull_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TemplateArgumentKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TemplateArgumentKind)lldb::eTemplateArgumentKindNull;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eLastFormatterMatchType_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FormatterMatchType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FormatterMatchType)lldb::eLastFormatterMatchType;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionNone_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionNone;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionCascade_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionCascade;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionSkipPointers_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionSkipPointers;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionSkipReferences_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionSkipReferences;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionHideChildren_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionHideChildren;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionHideValue_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionHideValue;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionShowOneLiner_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionShowOneLiner;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionHideNames_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionHideNames;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionNonCacheable_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionNonCacheable;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionHideEmptyAggregates_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionHideEmptyAggregates;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeOptionFrontEndWantsDereference_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeOptions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeOptions)lldb::eTypeOptionFrontEndWantsDereference;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsUserRead_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsUserRead;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsUserWrite_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsUserWrite;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsUserExecute_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsUserExecute;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsGroupRead_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsGroupRead;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsGroupWrite_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsGroupWrite;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsGroupExecute_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsGroupExecute;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsWorldRead_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsWorldRead;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsWorldWrite_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsWorldWrite;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsWorldExecute_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsWorldExecute;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsUserRW_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsUserRW;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFileFilePermissionsUserRX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFileFilePermissionsUserRX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsUserRWX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsUserRWX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsGroupRW_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsGroupRW;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsGroupRX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsGroupRX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsGroupRWX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsGroupRWX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsWorldRW_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsWorldRW;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsWorldRX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsWorldRX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsWorldRWX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsWorldRWX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsEveryoneR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsEveryoneR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsEveryoneW_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsEveryoneW;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsEveryoneX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsEveryoneX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsEveryoneRW_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsEveryoneRW;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsEveryoneRX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsEveryoneRX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsEveryoneRWX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsEveryoneRWX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsFileDefault_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsFileDefault;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eFilePermissionsDirectoryDefault_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::FilePermissions result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::FilePermissions)lldb::eFilePermissionsDirectoryDefault;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eQueueItemKindUnknown_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::QueueItemKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::QueueItemKind)lldb::eQueueItemKindUnknown;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eQueueKindUnknown_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::QueueKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::QueueKind)lldb::eQueueKindUnknown;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eExpressionEvaluationParse_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::ExpressionEvaluationPhase result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::ExpressionEvaluationPhase)lldb::eExpressionEvaluationParse;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eInstructionControlFlowKindUnknown_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::InstructionControlFlowKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::InstructionControlFlowKind)lldb::eInstructionControlFlowKindUnknown;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointKindWrite_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointKind)lldb::eWatchpointKindWrite;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eWatchpointKindRead_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::WatchpointKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::WatchpointKind)lldb::eWatchpointKindRead;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eGdbSignalBadAccess_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::GdbSignal result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::GdbSignal)lldb::eGdbSignalBadAccess;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eGdbSignalBadInstruction_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::GdbSignal result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::GdbSignal)lldb::eGdbSignalBadInstruction;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eGdbSignalArithmetic_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::GdbSignal result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::GdbSignal)lldb::eGdbSignalArithmetic;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eGdbSignalEmulation_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::GdbSignal result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::GdbSignal)lldb::eGdbSignalEmulation;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eGdbSignalSoftware_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::GdbSignal result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::GdbSignal)lldb::eGdbSignalSoftware;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eGdbSignalBreakpoint_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::GdbSignal result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::GdbSignal)lldb::eGdbSignalBreakpoint;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eMemberFunctionKindUnknown_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::MemberFunctionKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::MemberFunctionKind)lldb::eMemberFunctionKindUnknown;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeHasChildren_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeHasChildren;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeHasValue_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeHasValue;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsArray_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsArray;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsBlock_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsBlock;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsBuiltIn_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsBuiltIn;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsClass_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsClass;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsCPlusPlus_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsCPlusPlus;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsEnumeration_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsEnumeration;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsFuncPrototype_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsFuncPrototype;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsMember_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsMember;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsObjC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsObjC;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsPointer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsPointer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsReference_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsReference;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsStructUnion_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsStructUnion;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsTemplate_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsTemplate;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsTypedef_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsTypedef;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsVector_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsVector;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsScalar_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsScalar;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsInteger_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsInteger;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsFloat_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsFloat;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsComplex_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsComplex;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeIsSigned_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeIsSigned;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeInstanceIsPointer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeFlags)lldb::eTypeInstanceIsPointer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandRequiresTarget_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandRequiresTarget;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandRequiresProcess_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandRequiresProcess;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandRequiresThread_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandRequiresThread;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandRequiresFrame_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandRequiresFrame;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandRequiresRegContext_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandRequiresRegContext;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandTryTargetAPILock_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandTryTargetAPILock;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandProcessMustBeLaunched_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandProcessMustBeLaunched;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandProcessMustBePaused_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandProcessMustBePaused;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eCommandProcessMustBeTraced_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::CommandFlags result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::CommandFlags)lldb::eCommandProcessMustBeTraced;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeSummaryCapped_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeSummaryCapping result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeSummaryCapping)lldb::eTypeSummaryCapped;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTypeSummaryUncapped_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TypeSummaryCapping result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TypeSummaryCapping)lldb::eTypeSummaryUncapped;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSaveCoreUnspecified_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SaveCoreStyle result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SaveCoreStyle)lldb::eSaveCoreUnspecified;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSaveCoreFull_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SaveCoreStyle result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SaveCoreStyle)lldb::eSaveCoreFull;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSaveCoreDirtyOnly_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SaveCoreStyle result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SaveCoreStyle)lldb::eSaveCoreDirtyOnly;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eSaveCoreStackOnly_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::SaveCoreStyle result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SaveCoreStyle)lldb::eSaveCoreStackOnly;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTraceItemKindError_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TraceItemKind result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TraceItemKind)lldb::eTraceItemKindError;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_eTraceCursorSeekTypeBeginning_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  lldb::TraceCursorSeekType result;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::TraceCursorSeekType)lldb::eTraceCursorSeekTypeBeginning;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAddress_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBAddress *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBAddress *)new lldb::SBAddress();
  *(lldb::SBAddress **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAddress_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = 0 ;
  lldb::SBAddress *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress const & reference is null");
    return 0;
  } 
  result = (lldb::SBAddress *)new lldb::SBAddress((lldb::SBAddress const &)*arg1);
  *(lldb::SBAddress **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAddress_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBSection arg1 ;
  lldb::addr_t arg2 ;
  lldb::SBSection *argp1 ;
  lldb::SBAddress *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(lldb::SBSection **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBSection");
    return 0;
  }
  arg1 = *argp1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (lldb::SBAddress *)new lldb::SBAddress(arg1,arg2);
  *(lldb::SBAddress **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAddress_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::addr_t arg1 ;
  lldb::SBTarget *arg2 = 0 ;
  lldb::SBAddress *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg1);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg1, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg1 = 0;
    if (sz > 0) {
      arg1 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg1 = (arg1 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg2 = *(lldb::SBTarget **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return 0;
  } 
  result = (lldb::SBAddress *)new lldb::SBAddress(arg1,*arg2);
  *(lldb::SBAddress **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBAddress(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAddress_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (bool)((lldb::SBAddress const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAddress_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBAddress_1GetFileAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (lldb::addr_t)((lldb::SBAddress const *)arg1)->GetFileAddress();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBAddress_1GetLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBTarget *arg2 = 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  arg2 = *(lldb::SBTarget **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget const & reference is null");
    return 0;
  } 
  result = (lldb::addr_t)((lldb::SBAddress const *)arg1)->GetLoadAddress((lldb::SBTarget const &)*arg2);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAddress_1SetLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBTarget *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = *(lldb::SBTarget **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return ;
  } 
  (arg1)->SetLoadAddress(arg2,*arg3);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAddress_1OffsetAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jboolean jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::addr_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (bool)(arg1)->OffsetAddress(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAddress_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAddress_1GetSection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBSection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (arg1)->GetSection();
  *(lldb::SBSection **)&jresult = new lldb::SBSection((const lldb::SBSection &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBAddress_1GetOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (lldb::addr_t)(arg1)->GetOffset();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAddress_1SetAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBSection arg2 ;
  lldb::addr_t arg3 ;
  lldb::SBSection *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  argp2 = *(lldb::SBSection **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBSection");
    return ;
  }
  arg2 = *argp2; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  (arg1)->SetAddress(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAddress_1GetSymbolContext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  uint32_t arg2 ;
  lldb::SBSymbolContext result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetSymbolContext(arg2);
  *(lldb::SBSymbolContext **)&jresult = new lldb::SBSymbolContext((const lldb::SBSymbolContext &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAddress_1GetModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (arg1)->GetModule();
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAddress_1GetCompileUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBCompileUnit result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (arg1)->GetCompileUnit();
  *(lldb::SBCompileUnit **)&jresult = new lldb::SBCompileUnit((const lldb::SBCompileUnit &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAddress_1GetFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBFunction result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (arg1)->GetFunction();
  *(lldb::SBFunction **)&jresult = new lldb::SBFunction((const lldb::SBFunction &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAddress_1GetBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (arg1)->GetBlock();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAddress_1GetSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBSymbol result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (arg1)->GetSymbol();
  *(lldb::SBSymbol **)&jresult = new lldb::SBSymbol((const lldb::SBSymbol &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAddress_1GetLineEntry(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  lldb::SBLineEntry result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = (arg1)->GetLineEntry();
  *(lldb::SBLineEntry **)&jresult = new lldb::SBLineEntry((const lldb::SBLineEntry &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBAddress_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBAddress *arg1 = (lldb::SBAddress *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAddress **)&jarg1; 
  result = lldb_SBAddress___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAttachInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBAttachInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBAttachInfo *)new lldb::SBAttachInfo();
  *(lldb::SBAttachInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAttachInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  lldb::pid_t arg1 ;
  lldb::SBAttachInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg1);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg1, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg1 = 0;
    if (sz > 0) {
      arg1 = (lldb::pid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg1 = (arg1 << 8) | (lldb::pid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (lldb::SBAttachInfo *)new lldb::SBAttachInfo(arg1);
  *(lldb::SBAttachInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAttachInfo_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool arg2 ;
  lldb::SBAttachInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = jarg2 ? true : false; 
  result = (lldb::SBAttachInfo *)new lldb::SBAttachInfo((char const *)arg1,arg2);
  *(lldb::SBAttachInfo **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAttachInfo_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool arg2 ;
  bool arg3 ;
  lldb::SBAttachInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  result = (lldb::SBAttachInfo *)new lldb::SBAttachInfo((char const *)arg1,arg2,arg3);
  *(lldb::SBAttachInfo **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBAttachInfo_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAttachInfo *arg1 = 0 ;
  lldb::SBAttachInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAttachInfo const & reference is null");
    return 0;
  } 
  result = (lldb::SBAttachInfo *)new lldb::SBAttachInfo((lldb::SBAttachInfo const &)*arg1);
  *(lldb::SBAttachInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  lldb::pid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (lldb::pid_t)(arg1)->GetProcessID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  lldb::pid_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::pid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::pid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  (arg1)->SetProcessID(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetExecutable_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetExecutable((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetExecutable_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  lldb::SBFileSpec arg2 ;
  lldb::SBFileSpec *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  argp2 = *(lldb::SBFileSpec **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFileSpec");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetExecutable(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetWaitForLaunch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (bool)(arg1)->GetWaitForLaunch();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetWaitForLaunch_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetWaitForLaunch(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetWaitForLaunch_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jboolean jarg3) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  (arg1)->SetWaitForLaunch(arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetIgnoreExisting(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (bool)(arg1)->GetIgnoreExisting();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetIgnoreExisting(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetIgnoreExisting(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetResumeCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetResumeCount();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetResumeCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetResumeCount(arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetProcessPluginName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (char *)(arg1)->GetProcessPluginName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetProcessPluginName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetProcessPluginName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetUserID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetUserID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetGroupID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetGroupID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1UserIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (bool)(arg1)->UserIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GroupIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (bool)(arg1)->GroupIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetUserID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetUserID(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetGroupID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetGroupID(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetEffectiveUserID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetEffectiveUserID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetEffectiveGroupID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetEffectiveGroupID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1EffectiveUserIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (bool)(arg1)->EffectiveUserIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1EffectiveGroupIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (bool)(arg1)->EffectiveGroupIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetEffectiveUserID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetEffectiveUserID(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetEffectiveGroupID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetEffectiveGroupID(arg2);
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetParentProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  lldb::pid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (lldb::pid_t)(arg1)->GetParentProcessID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetParentProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  lldb::pid_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::pid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::pid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  (arg1)->SetParentProcessID(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1ParentProcessIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (bool)(arg1)->ParentProcessIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1GetListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  lldb::SBListener result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  result = (arg1)->GetListener();
  *(lldb::SBListener **)&jresult = new lldb::SBListener((const lldb::SBListener &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBAttachInfo_1SetListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener & reference is null");
    return ;
  } 
  (arg1)->SetListener(*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBAttachInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBAttachInfo *arg1 = (lldb::SBAttachInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBAttachInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBlock_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBBlock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBBlock *)new lldb::SBBlock();
  *(lldb::SBBlock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBlock_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = 0 ;
  lldb::SBBlock *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBlock const & reference is null");
    return 0;
  } 
  result = (lldb::SBBlock *)new lldb::SBBlock((lldb::SBBlock const &)*arg1);
  *(lldb::SBBlock **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBBlock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBlock_1IsInlined(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (bool)((lldb::SBBlock const *)arg1)->IsInlined();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBlock_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (bool)((lldb::SBBlock const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBlock_1GetInlinedName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (char *)((lldb::SBBlock const *)arg1)->GetInlinedName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetInlinedCallSiteFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = ((lldb::SBBlock const *)arg1)->GetInlinedCallSiteFile();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetInlinedCallSiteLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (uint32_t)((lldb::SBBlock const *)arg1)->GetInlinedCallSiteLine();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetInlinedCallSiteColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (uint32_t)((lldb::SBBlock const *)arg1)->GetInlinedCallSiteColumn();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetParent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (arg1)->GetParent();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetContainingInlinedBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (arg1)->GetContainingInlinedBlock();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetSibling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (arg1)->GetSibling();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetFirstChild(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (arg1)->GetFirstChild();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetNumRanges(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumRanges();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetRangeStartAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  uint32_t arg2 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetRangeStartAddress(arg2);
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetRangeEndAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  uint32_t arg2 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetRangeEndAddress(arg2);
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetRangeIndexForBlockAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBAddress arg2 ;
  lldb::SBAddress *argp2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  argp2 = *(lldb::SBAddress **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBAddress");
    return 0;
  }
  arg2 = *argp2; 
  result = (uint32_t)(arg1)->GetRangeIndexForBlockAddress(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBlock_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetVariables_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3, jboolean jarg4, jboolean jarg5, jint jarg6) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBFrame *arg2 = 0 ;
  bool arg3 ;
  bool arg4 ;
  bool arg5 ;
  lldb::DynamicValueType arg6 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  arg2 = *(lldb::SBFrame **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFrame & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  arg6 = (lldb::DynamicValueType)jarg6; 
  result = (arg1)->GetVariables(*arg2,arg3,arg4,arg5,arg6);
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBlock_1GetVariables_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3, jboolean jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  lldb::SBTarget *arg2 = 0 ;
  bool arg3 ;
  bool arg4 ;
  bool arg5 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  arg2 = *(lldb::SBTarget **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  result = (arg1)->GetVariables(*arg2,arg3,arg4,arg5);
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBlock_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBlock *arg1 = (lldb::SBBlock *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBlock **)&jarg1; 
  result = lldb_SBBlock___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBBreakpoint *)new lldb::SBBreakpoint();
  *(lldb::SBBreakpoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = 0 ;
  lldb::SBBreakpoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpoint const & reference is null");
    return 0;
  } 
  result = (lldb::SBBreakpoint *)new lldb::SBBreakpoint((lldb::SBBreakpoint const &)*arg1);
  *(lldb::SBBreakpoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBBreakpoint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::break_id_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (lldb::break_id_t)((lldb::SBBreakpoint const *)arg1)->GetID();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (bool)((lldb::SBBreakpoint const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1ClearAllBreakpointSites(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  (arg1)->ClearAllBreakpointSites();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = ((lldb::SBBreakpoint const *)arg1)->GetTarget();
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1FindLocationByAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBBreakpointLocation result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->FindLocationByAddress(arg2);
  *(lldb::SBBreakpointLocation **)&jresult = new lldb::SBBreakpointLocation((const lldb::SBBreakpointLocation &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1FindLocationIDByAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::addr_t arg2 ;
  lldb::break_id_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (lldb::break_id_t)(arg1)->FindLocationIDByAddress(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1FindLocationByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::break_id_t arg2 ;
  lldb::SBBreakpointLocation result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = (lldb::break_id_t)jarg2; 
  result = (arg1)->FindLocationByID(arg2);
  *(lldb::SBBreakpointLocation **)&jresult = new lldb::SBBreakpointLocation((const lldb::SBBreakpointLocation &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetLocationAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  uint32_t arg2 ;
  lldb::SBBreakpointLocation result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetLocationAtIndex(arg2);
  *(lldb::SBBreakpointLocation **)&jresult = new lldb::SBBreakpointLocation((const lldb::SBBreakpointLocation &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetEnabled(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1IsEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (bool)(arg1)->IsEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetOneShot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetOneShot(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1IsOneShot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (bool)(arg1)->IsOneShot();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1IsInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (bool)(arg1)->IsInternal();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetHitCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (uint32_t)((lldb::SBBreakpoint const *)arg1)->GetHitCount();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetIgnoreCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetIgnoreCount(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetIgnoreCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (uint32_t)((lldb::SBBreakpoint const *)arg1)->GetIgnoreCount();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetCondition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetCondition((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetCondition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (char *)(arg1)->GetCondition();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetAutoContinue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAutoContinue(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetAutoContinue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (bool)(arg1)->GetAutoContinue();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetThreadID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::tid_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::tid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::tid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  (arg1)->SetThreadID(arg2);
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetThreadID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::tid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (lldb::tid_t)(arg1)->GetThreadID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetThreadIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetThreadIndex(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetThreadIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (uint32_t)((lldb::SBBreakpoint const *)arg1)->GetThreadIndex();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetThreadName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetThreadName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetThreadName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (char *)((lldb::SBBreakpoint const *)arg1)->GetThreadName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetQueueName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetQueueName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetQueueName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (char *)((lldb::SBBreakpoint const *)arg1)->GetQueueName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetScriptCallbackFunction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetScriptCallbackFunction((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetScriptCallbackFunction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStructuredData *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBStructuredData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStructuredData & reference is null");
    return 0;
  } 
  result = (arg1)->SetScriptCallbackFunction((char const *)arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetScriptCallbackBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->SetScriptCallbackBody((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SetCommandLineCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return ;
  } 
  (arg1)->SetCommandLineCommands(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetCommandLineCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetCommandLineCommands(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1AddName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->AddName((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1AddNameWithErrorHandling(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->AddNameWithErrorHandling((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1RemoveName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->RemoveName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1MatchesName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->MatchesName((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetNames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return ;
  } 
  (arg1)->GetNames(*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetNumResolvedLocations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = ((lldb::SBBreakpoint const *)arg1)->GetNumResolvedLocations();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetNumLocations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = ((lldb::SBBreakpoint const *)arg1)->GetNumLocations();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetDescription_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetDescription_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  result = (bool)(arg1)->GetDescription(*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1AddLocation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::SBAddress *arg2 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  arg2 = *(lldb::SBAddress **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress & reference is null");
    return 0;
  } 
  result = (arg1)->AddLocation(*arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1SerializeToStructuredData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (arg1)->SerializeToStructuredData();
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1EventIsBreakpointEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)lldb::SBBreakpoint::EventIsBreakpointEvent((lldb::SBEvent const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetBreakpointEventTypeFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::BreakpointEventType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (lldb::BreakpointEventType)lldb::SBBreakpoint::GetBreakpointEventTypeFromEvent((lldb::SBEvent const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetBreakpointFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBBreakpoint::GetBreakpointFromEvent((lldb::SBEvent const &)*arg1);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetBreakpointLocationAtIndexFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  uint32_t arg2 ;
  lldb::SBBreakpointLocation result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  arg2 = (uint32_t)jarg2; 
  result = lldb::SBBreakpoint::GetBreakpointLocationAtIndexFromEvent((lldb::SBEvent const &)*arg1,arg2);
  *(lldb::SBBreakpointLocation **)&jresult = new lldb::SBBreakpointLocation((const lldb::SBBreakpointLocation &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1GetNumBreakpointLocationsFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (uint32_t)lldb::SBBreakpoint::GetNumBreakpointLocationsFromEvent((lldb::SBEvent const &)*arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1IsHardware(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = (bool)(arg1)->IsHardware();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpoint_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpoint *arg1 = (lldb::SBBreakpoint *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1; 
  result = lldb_SBBreakpoint___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpointList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = 0 ;
  lldb::SBBreakpointList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return 0;
  } 
  result = (lldb::SBBreakpointList *)new lldb::SBBreakpointList(*arg1);
  *(lldb::SBBreakpointList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBBreakpointList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBBreakpointList *arg1 = (lldb::SBBreakpointList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBBreakpointList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointList_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointList *arg1 = (lldb::SBBreakpointList *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointList **)&jarg1; 
  result = ((lldb::SBBreakpointList const *)arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointList_1GetBreakpointAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpointList *arg1 = (lldb::SBBreakpointList *) 0 ;
  size_t arg2 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointList **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (arg1)->GetBreakpointAtIndex(arg2);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointList_1FindBreakpointByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpointList *arg1 = (lldb::SBBreakpointList *) 0 ;
  lldb::break_id_t arg2 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointList **)&jarg1; 
  arg2 = (lldb::break_id_t)jarg2; 
  result = (arg1)->FindBreakpointByID(arg2);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointList_1Append(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBBreakpointList *arg1 = (lldb::SBBreakpointList *) 0 ;
  lldb::SBBreakpoint *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpointList **)&jarg1; 
  arg2 = *(lldb::SBBreakpoint **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpoint const & reference is null");
    return ;
  } 
  (arg1)->Append((lldb::SBBreakpoint const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointList_1AppendIfUnique(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointList *arg1 = (lldb::SBBreakpointList *) 0 ;
  lldb::SBBreakpoint *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpointList **)&jarg1; 
  arg2 = *(lldb::SBBreakpoint **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpoint const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->AppendIfUnique((lldb::SBBreakpoint const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointList_1AppendByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBBreakpointList *arg1 = (lldb::SBBreakpointList *) 0 ;
  lldb::break_id_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointList **)&jarg1; 
  arg2 = (lldb::break_id_t)jarg2; 
  (arg1)->AppendByID(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBBreakpointList *arg1 = (lldb::SBBreakpointList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpointLocation_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBBreakpointLocation *)new lldb::SBBreakpointLocation();
  *(lldb::SBBreakpointLocation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpointLocation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = 0 ;
  lldb::SBBreakpointLocation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpointLocation const & reference is null");
    return 0;
  } 
  result = (lldb::SBBreakpointLocation *)new lldb::SBBreakpointLocation((lldb::SBBreakpointLocation const &)*arg1);
  *(lldb::SBBreakpointLocation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBBreakpointLocation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::break_id_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (lldb::break_id_t)(arg1)->GetID();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (bool)((lldb::SBBreakpointLocation const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (arg1)->GetAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (lldb::addr_t)(arg1)->GetLoadAddress();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetEnabled(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1IsEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (bool)(arg1)->IsEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetHitCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (uint32_t)(arg1)->GetHitCount();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetIgnoreCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (uint32_t)(arg1)->GetIgnoreCount();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetIgnoreCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetIgnoreCount(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetCondition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetCondition((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetCondition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (char *)(arg1)->GetCondition();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetAutoContinue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (bool)(arg1)->GetAutoContinue();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetAutoContinue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAutoContinue(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetScriptCallbackFunction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetScriptCallbackFunction((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetScriptCallbackFunction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStructuredData *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBStructuredData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStructuredData & reference is null");
    return 0;
  } 
  result = (arg1)->SetScriptCallbackFunction((char const *)arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetScriptCallbackBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->SetScriptCallbackBody((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetCommandLineCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return ;
  } 
  (arg1)->SetCommandLineCommands(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetCommandLineCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetCommandLineCommands(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetThreadID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::tid_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::tid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::tid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  (arg1)->SetThreadID(arg2);
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetThreadID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::tid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (lldb::tid_t)(arg1)->GetThreadID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetThreadIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetThreadIndex(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetThreadIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (uint32_t)((lldb::SBBreakpointLocation const *)arg1)->GetThreadIndex();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetThreadName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetThreadName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetThreadName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (char *)((lldb::SBBreakpointLocation const *)arg1)->GetThreadName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1SetQueueName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetQueueName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetQueueName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (char *)((lldb::SBBreakpointLocation const *)arg1)->GetQueueName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1IsResolved(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (bool)(arg1)->IsResolved();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  lldb::DescriptionLevel arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  arg3 = (lldb::DescriptionLevel)jarg3; 
  result = (bool)(arg1)->GetDescription(*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1GetBreakpoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = (arg1)->GetBreakpoint();
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointLocation_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointLocation *arg1 = (lldb::SBBreakpointLocation *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointLocation **)&jarg1; 
  result = lldb_SBBreakpointLocation___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpointName_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBBreakpointName *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBBreakpointName *)new lldb::SBBreakpointName();
  *(lldb::SBBreakpointName **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpointName_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBBreakpointName *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return 0;
  } 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (lldb::SBBreakpointName *)new lldb::SBBreakpointName(*arg1,(char const *)arg2);
  *(lldb::SBBreakpointName **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpointName_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpoint *arg1 = 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBBreakpointName *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpoint **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpoint & reference is null");
    return 0;
  } 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (lldb::SBBreakpointName *)new lldb::SBBreakpointName(*arg1,(char const *)arg2);
  *(lldb::SBBreakpointName **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBreakpointName_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointName *arg1 = 0 ;
  lldb::SBBreakpointName *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpointName const & reference is null");
    return 0;
  } 
  result = (lldb::SBBreakpointName *)new lldb::SBBreakpointName((lldb::SBBreakpointName const &)*arg1);
  *(lldb::SBBreakpointName **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBBreakpointName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (bool)((lldb::SBBreakpointName const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (char *)((lldb::SBBreakpointName const *)arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetEnabled(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1IsEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (bool)(arg1)->IsEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetOneShot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetOneShot(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1IsOneShot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (bool)((lldb::SBBreakpointName const *)arg1)->IsOneShot();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetIgnoreCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetIgnoreCount(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetIgnoreCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (uint32_t)((lldb::SBBreakpointName const *)arg1)->GetIgnoreCount();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetCondition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetCondition((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetCondition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (char *)(arg1)->GetCondition();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetAutoContinue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAutoContinue(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetAutoContinue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (bool)(arg1)->GetAutoContinue();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetThreadID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  lldb::tid_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::tid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::tid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  (arg1)->SetThreadID(arg2);
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetThreadID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  lldb::tid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (lldb::tid_t)(arg1)->GetThreadID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetThreadIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetThreadIndex(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetThreadIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (uint32_t)((lldb::SBBreakpointName const *)arg1)->GetThreadIndex();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetThreadName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetThreadName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetThreadName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (char *)((lldb::SBBreakpointName const *)arg1)->GetThreadName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetQueueName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetQueueName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetQueueName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (char *)((lldb::SBBreakpointName const *)arg1)->GetQueueName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetScriptCallbackFunction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetScriptCallbackFunction((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetScriptCallbackFunction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStructuredData *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBStructuredData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStructuredData & reference is null");
    return 0;
  } 
  result = (arg1)->SetScriptCallbackFunction((char const *)arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetCommandLineCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return ;
  } 
  (arg1)->SetCommandLineCommands(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetCommandLineCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetCommandLineCommands(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetScriptCallbackBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->SetScriptCallbackBody((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetHelpString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (char *)((lldb::SBBreakpointName const *)arg1)->GetHelpString();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetHelpString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetHelpString((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetAllowList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (bool)((lldb::SBBreakpointName const *)arg1)->GetAllowList();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetAllowList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAllowList(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetAllowDelete(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (bool)(arg1)->GetAllowDelete();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetAllowDelete(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAllowDelete(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetAllowDisable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = (bool)(arg1)->GetAllowDisable();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1SetAllowDisable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAllowDisable(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBreakpointName_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBreakpointName *arg1 = (lldb::SBBreakpointName *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBreakpointName **)&jarg1; 
  result = lldb_SBBreakpointName___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBroadcaster_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBBroadcaster *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBBroadcaster *)new lldb::SBBroadcaster();
  *(lldb::SBBroadcaster **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBroadcaster_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::SBBroadcaster *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (lldb::SBBroadcaster *)new lldb::SBBroadcaster((char const *)arg1);
  *(lldb::SBBroadcaster **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBBroadcaster_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBBroadcaster *arg1 = 0 ;
  lldb::SBBroadcaster *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  result = (lldb::SBBroadcaster *)new lldb::SBBroadcaster((lldb::SBBroadcaster const &)*arg1);
  *(lldb::SBBroadcaster **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  result = (bool)((lldb::SBBroadcaster const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1BroadcastEventByType_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  uint32_t arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->BroadcastEventByType(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1BroadcastEventByType_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->BroadcastEventByType(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1BroadcastEvent_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return ;
  } 
  arg3 = jarg3 ? true : false; 
  (arg1)->BroadcastEvent((lldb::SBEvent const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1BroadcastEvent_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return ;
  } 
  (arg1)->BroadcastEvent((lldb::SBEvent const &)*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1AddInitialEventsToListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener const & reference is null");
    return ;
  } 
  arg3 = (uint32_t)jarg3; 
  (arg1)->AddInitialEventsToListener((lldb::SBListener const &)*arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1AddListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  result = (uint32_t)(arg1)->AddListener((lldb::SBListener const &)*arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  result = (char *)((lldb::SBBroadcaster const *)arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1EventTypeHasListeners(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  uint32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (bool)(arg1)->EventTypeHasListeners(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1RemoveListener_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  uint32_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  result = (bool)(arg1)->RemoveListener((lldb::SBListener const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBBroadcaster_1RemoveListener_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBBroadcaster *arg1 = (lldb::SBBroadcaster *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBBroadcaster **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->RemoveListener((lldb::SBListener const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1eBroadcastBitThreadShouldExit_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommandInterpreter::eBroadcastBitThreadShouldExit;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1eBroadcastBitResetPrompt_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommandInterpreter::eBroadcastBitResetPrompt;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1eBroadcastBitQuitCommandReceived_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommandInterpreter::eBroadcastBitQuitCommandReceived;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1eBroadcastBitAsynchronousOutputData_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommandInterpreter::eBroadcastBitAsynchronousOutputData;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1eBroadcastBitAsynchronousErrorData_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommandInterpreter::eBroadcastBitAsynchronousErrorData;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBCommandInterpreter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = 0 ;
  lldb::SBCommandInterpreter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandInterpreter const & reference is null");
    return 0;
  } 
  result = (lldb::SBCommandInterpreter *)new lldb::SBCommandInterpreter((lldb::SBCommandInterpreter const &)*arg1);
  *(lldb::SBCommandInterpreter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBCommandInterpreter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetArgumentTypeAsCString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  lldb::CommandArgumentType arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::CommandArgumentType)jarg1; 
  result = (char *)lldb::SBCommandInterpreter::GetArgumentTypeAsCString(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetArgumentDescriptionAsCString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  lldb::CommandArgumentType arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::CommandArgumentType)jarg1; 
  result = (char *)lldb::SBCommandInterpreter::GetArgumentDescriptionAsCString(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1EventIsCommandInterpreterEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)lldb::SBCommandInterpreter::EventIsCommandInterpreterEvent((lldb::SBEvent const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreter const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetIOHandlerControlSequence(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jchar jarg2) {
  jstring jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = (char)jarg2; 
  result = (char *)(arg1)->GetIOHandlerControlSequence(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetPromptOnQuit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)(arg1)->GetPromptOnQuit();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1SetPromptOnQuit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetPromptOnQuit(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1AllowExitCodeOnQuit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->AllowExitCodeOnQuit(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HasCustomQuitExitCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)(arg1)->HasCustomQuitExitCode();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetQuitStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (int)(arg1)->GetQuitStatus();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1ResolveCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBCommandReturnObject *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(lldb::SBCommandReturnObject **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject & reference is null");
    return ;
  } 
  (arg1)->ResolveCommand((char const *)arg2,*arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1CommandExists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->CommandExists((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1AliasExists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->AliasExists((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  lldb::SBBroadcaster result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (arg1)->GetBroadcaster();
  *(lldb::SBBroadcaster **)&jresult = new lldb::SBBroadcaster((const lldb::SBBroadcaster &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetBroadcasterClass(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)lldb::SBCommandInterpreter::GetBroadcasterClass();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HasCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)(arg1)->HasCommands();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HasAliases(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)(arg1)->HasAliases();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HasAliasOptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)(arg1)->HasAliasOptions();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1IsInteractive(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)(arg1)->IsInteractive();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetProcess(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (arg1)->GetProcess();
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1GetDebugger(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  lldb::SBDebugger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (arg1)->GetDebugger();
  *(lldb::SBDebugger **)&jresult = new lldb::SBDebugger((const lldb::SBDebugger &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1SourceInitFileInHomeDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  lldb::SBCommandReturnObject *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = *(lldb::SBCommandReturnObject **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject & reference is null");
    return ;
  } 
  (arg1)->SourceInitFileInHomeDirectory(*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1SourceInitFileInCurrentWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  lldb::SBCommandReturnObject *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = *(lldb::SBCommandReturnObject **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject & reference is null");
    return ;
  } 
  (arg1)->SourceInitFileInCurrentWorkingDirectory(*arg2);
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HandleCommand_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jint jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBCommandReturnObject *arg3 = 0 ;
  bool arg4 ;
  lldb::ReturnStatus result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBCommandReturnObject **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  result = (lldb::ReturnStatus)(arg1)->HandleCommand((char const *)arg2,*arg3,arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HandleCommand_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBCommandReturnObject *arg3 = 0 ;
  lldb::ReturnStatus result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBCommandReturnObject **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject & reference is null");
    return 0;
  } 
  result = (lldb::ReturnStatus)(arg1)->HandleCommand((char const *)arg2,*arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HandleCommand_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  jint jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBExecutionContext *arg3 = 0 ;
  lldb::SBCommandReturnObject *arg4 = 0 ;
  bool arg5 ;
  lldb::ReturnStatus result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBExecutionContext **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBExecutionContext & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBCommandReturnObject **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  result = (lldb::ReturnStatus)(arg1)->HandleCommand((char const *)arg2,*arg3,*arg4,arg5);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HandleCommand_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jint jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBExecutionContext *arg3 = 0 ;
  lldb::SBCommandReturnObject *arg4 = 0 ;
  lldb::ReturnStatus result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBExecutionContext **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBExecutionContext & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBCommandReturnObject **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject & reference is null");
    return 0;
  } 
  result = (lldb::ReturnStatus)(arg1)->HandleCommand((char const *)arg2,*arg3,*arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HandleCommandsFromFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBExecutionContext *arg3 = 0 ;
  lldb::SBCommandInterpreterRunOptions *arg4 = 0 ;
  lldb::SBCommandReturnObject arg5 ;
  lldb::SBCommandReturnObject *argp5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return ;
  } 
  arg3 = *(lldb::SBExecutionContext **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBExecutionContext & reference is null");
    return ;
  } 
  arg4 = *(lldb::SBCommandInterpreterRunOptions **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandInterpreterRunOptions & reference is null");
    return ;
  } 
  argp5 = *(lldb::SBCommandReturnObject **)&jarg5; 
  if (!argp5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBCommandReturnObject");
    return ;
  }
  arg5 = *argp5; 
  (arg1)->HandleCommandsFromFile(*arg2,*arg3,*arg4,arg5);
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HandleCompletion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6, jobject jarg6_) {
  jint jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  int arg4 ;
  int arg5 ;
  lldb::SBStringList *arg6 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = *(lldb::SBStringList **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  result = (int)(arg1)->HandleCompletion((char const *)arg2,arg3,arg4,arg5,*arg6);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1HandleCompletionWithDescriptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jint jarg4, jint jarg5, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_) {
  jint jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  int arg4 ;
  int arg5 ;
  lldb::SBStringList *arg6 = 0 ;
  lldb::SBStringList *arg7 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = *(lldb::SBStringList **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  arg7 = *(lldb::SBStringList **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  result = (int)(arg1)->HandleCompletionWithDescriptions((char const *)arg2,arg3,arg4,arg5,*arg6,*arg7);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1IsActive(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)(arg1)->IsActive();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreter_1WasInterrupted(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreter *arg1 = (lldb::SBCommandInterpreter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreter **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreter const *)arg1)->WasInterrupted();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBCommandInterpreterRunOptions(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBCommandInterpreterRunOptions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBCommandInterpreterRunOptions *)new lldb::SBCommandInterpreterRunOptions();
  *(lldb::SBCommandInterpreterRunOptions **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBCommandInterpreterRunOptions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1GetStopOnContinue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreterRunOptions const *)arg1)->GetStopOnContinue();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1SetStopOnContinue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetStopOnContinue(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1GetStopOnError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreterRunOptions const *)arg1)->GetStopOnError();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1SetStopOnError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetStopOnError(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1GetStopOnCrash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreterRunOptions const *)arg1)->GetStopOnCrash();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1SetStopOnCrash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetStopOnCrash(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1GetEchoCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreterRunOptions const *)arg1)->GetEchoCommands();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1SetEchoCommands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetEchoCommands(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1GetPrintResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreterRunOptions const *)arg1)->GetPrintResults();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1SetPrintResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetPrintResults(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1GetPrintErrors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreterRunOptions const *)arg1)->GetPrintErrors();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1SetPrintErrors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetPrintErrors(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1GetAddToHistory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  result = (bool)((lldb::SBCommandInterpreterRunOptions const *)arg1)->GetAddToHistory();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandInterpreterRunOptions_1SetAddToHistory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommandInterpreterRunOptions *arg1 = (lldb::SBCommandInterpreterRunOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandInterpreterRunOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAddToHistory(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBCommandReturnObject_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBCommandReturnObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBCommandReturnObject *)new lldb::SBCommandReturnObject();
  *(lldb::SBCommandReturnObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBCommandReturnObject_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = 0 ;
  lldb::SBCommandReturnObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject const & reference is null");
    return 0;
  } 
  result = (lldb::SBCommandReturnObject *)new lldb::SBCommandReturnObject((lldb::SBCommandReturnObject const &)*arg1);
  *(lldb::SBCommandReturnObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBCommandReturnObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = (bool)((lldb::SBCommandReturnObject const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1GetOutput_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = (char *)(arg1)->GetOutput();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1GetError_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = (char *)(arg1)->GetError();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1GetOutputSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = (arg1)->GetOutputSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1GetErrorSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = (arg1)->GetErrorSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1GetOutput_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  bool arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (char *)(arg1)->GetOutput(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1GetError_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jstring jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  bool arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (char *)(arg1)->GetError(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1PutOutput_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->PutOutput(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1PutError_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->PutError(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1PutOutput_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->PutOutput(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1PutError_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->PutError(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::ReturnStatus arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = (lldb::ReturnStatus)jarg2; 
  (arg1)->SetStatus(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetError_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::SBError *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return ;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  (arg1)->SetError(*arg2,(char const *)arg3);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetError_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::SBError *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return ;
  } 
  (arg1)->SetError(*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetError_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetError((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1GetStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::ReturnStatus result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = (lldb::ReturnStatus)(arg1)->GetStatus();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1Succeeded(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = (bool)(arg1)->Succeeded();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1HasResult(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = (bool)(arg1)->HasResult();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1AppendMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->AppendMessage((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1AppendWarning(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->AppendWarning((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetImmediateOutputFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetImmediateOutputFile(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetImmediateErrorFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetImmediateErrorFile(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetImmediateOutputFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetImmediateOutputFile(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetImmediateErrorFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetImmediateErrorFile(arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  result = lldb_SBCommandReturnObject___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetImmediateOutputFile_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  bool arg3 ;
  lldb::FileSP *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg2 = *argp2; 
  arg3 = jarg3 ? true : false; 
  lldb_SBCommandReturnObject_SetImmediateOutputFile__SWIG_2(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1SetImmediateErrorFile_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  bool arg3 ;
  lldb::FileSP *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg2 = *argp2; 
  arg3 = jarg3 ? true : false; 
  lldb_SBCommandReturnObject_SetImmediateErrorFile__SWIG_2(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1PutCString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  (arg1)->PutCString((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommandReturnObject_1Print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBCommandReturnObject *arg1 = (lldb::SBCommandReturnObject *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommandReturnObject **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  lldb_SBCommandReturnObject_Print(arg1,(char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1eBroadcastBitDisconnected_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommunication::eBroadcastBitDisconnected;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1eBroadcastBitReadThreadGotBytes_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommunication::eBroadcastBitReadThreadGotBytes;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1eBroadcastBitReadThreadDidExit_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommunication::eBroadcastBitReadThreadDidExit;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1eBroadcastBitReadThreadShouldExit_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommunication::eBroadcastBitReadThreadShouldExit;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1eBroadcastBitPacketAvailable_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommunication::eBroadcastBitPacketAvailable;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1eAllEventBits_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBCommunication::eAllEventBits;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBCommunication_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBCommunication *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBCommunication *)new lldb::SBCommunication();
  *(lldb::SBCommunication **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBCommunication_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::SBCommunication *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (lldb::SBCommunication *)new lldb::SBCommunication((char const *)arg1);
  *(lldb::SBCommunication **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBCommunication(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommunication_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  result = (bool)((lldb::SBCommunication const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommunication_1GetBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  lldb::SBBroadcaster result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  result = (arg1)->GetBroadcaster();
  *(lldb::SBBroadcaster **)&jresult = new lldb::SBBroadcaster((const lldb::SBBroadcaster &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCommunication_1GetBroadcasterClass(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)lldb::SBCommunication::GetBroadcasterClass();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1AdoptFileDesriptor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  jint jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  int arg2 ;
  bool arg3 ;
  lldb::ConnectionStatus result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (lldb::ConnectionStatus)(arg1)->AdoptFileDesriptor(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1Connect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::ConnectionStatus result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (lldb::ConnectionStatus)(arg1)->Connect((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCommunication_1Disconnect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  lldb::ConnectionStatus result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  result = (lldb::ConnectionStatus)(arg1)->Disconnect();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommunication_1IsConnected(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  result = (bool)((lldb::SBCommunication const *)arg1)->IsConnected();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommunication_1GetCloseOnEOF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  result = (bool)(arg1)->GetCloseOnEOF();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBCommunication_1SetCloseOnEOF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetCloseOnEOF(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommunication_1Read(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  uint32_t arg4 ;
  lldb::ConnectionStatus *arg5 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  arg5 = *(lldb::ConnectionStatus **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::ConnectionStatus & reference is null");
    return 0;
  } 
  result = (arg1)->Read(arg2,arg3,arg4,*arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCommunication_1Write(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  lldb::ConnectionStatus *arg4 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = *(lldb::ConnectionStatus **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::ConnectionStatus & reference is null");
    return 0;
  } 
  result = (arg1)->Write((void const *)arg2,arg3,*arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommunication_1ReadThreadStart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  result = (bool)(arg1)->ReadThreadStart();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommunication_1ReadThreadStop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  result = (bool)(arg1)->ReadThreadStop();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommunication_1ReadThreadIsRunning(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  result = (bool)(arg1)->ReadThreadIsRunning();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCommunication_1SetReadThreadBytesReceivedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBCommunication *arg1 = (lldb::SBCommunication *) 0 ;
  lldb::SBCommunication::ReadThreadBytesReceived arg2 = (lldb::SBCommunication::ReadThreadBytesReceived) 0 ;
  void *arg3 = (void *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCommunication **)&jarg1; 
  arg2 = *(lldb::SBCommunication::ReadThreadBytesReceived *)&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = (bool)(arg1)->SetReadThreadBytesReceivedCallback(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBCompileUnit_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBCompileUnit *)new lldb::SBCompileUnit();
  *(lldb::SBCompileUnit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBCompileUnit_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = 0 ;
  lldb::SBCompileUnit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCompileUnit const & reference is null");
    return 0;
  } 
  result = (lldb::SBCompileUnit *)new lldb::SBCompileUnit((lldb::SBCompileUnit const &)*arg1);
  *(lldb::SBCompileUnit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBCompileUnit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  result = (bool)((lldb::SBCompileUnit const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  result = ((lldb::SBCompileUnit const *)arg1)->GetFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetNumLineEntries(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  result = (uint32_t)((lldb::SBCompileUnit const *)arg1)->GetNumLineEntries();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetLineEntryAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  uint32_t arg2 ;
  lldb::SBLineEntry result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = ((lldb::SBCompileUnit const *)arg1)->GetLineEntryAtIndex(arg2);
  *(lldb::SBLineEntry **)&jresult = new lldb::SBLineEntry((const lldb::SBLineEntry &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1FindLineEntryIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  lldb::SBLineEntry *arg2 = 0 ;
  bool arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = *(lldb::SBLineEntry **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBLineEntry & reference is null");
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  result = (uint32_t)((lldb::SBCompileUnit const *)arg1)->FindLineEntryIndex(*arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1FindLineEntryIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  lldb::SBLineEntry *arg2 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = *(lldb::SBLineEntry **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBLineEntry & reference is null");
    return 0;
  } 
  result = (uint32_t)((lldb::SBCompileUnit const *)arg1)->FindLineEntryIndex(*arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1FindLineEntryIndex_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  lldb::SBFileSpec *arg4 = (lldb::SBFileSpec *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = *(lldb::SBFileSpec **)&jarg4; 
  result = (uint32_t)((lldb::SBCompileUnit const *)arg1)->FindLineEntryIndex(arg2,arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1FindLineEntryIndex_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jboolean jarg5) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  lldb::SBFileSpec *arg4 = (lldb::SBFileSpec *) 0 ;
  bool arg5 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = *(lldb::SBFileSpec **)&jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (uint32_t)((lldb::SBCompileUnit const *)arg1)->FindLineEntryIndex(arg2,arg3,arg4,arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetSupportFileAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  uint32_t arg2 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = ((lldb::SBCompileUnit const *)arg1)->GetSupportFileAtIndex(arg2);
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetNumSupportFiles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  result = (uint32_t)((lldb::SBCompileUnit const *)arg1)->GetNumSupportFiles();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1FindSupportFileIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  uint32_t arg2 ;
  lldb::SBFileSpec *arg3 = 0 ;
  bool arg4 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(lldb::SBFileSpec **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  result = (uint32_t)(arg1)->FindSupportFileIndex(arg2,(lldb::SBFileSpec const &)*arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetTypes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  uint32_t arg2 ;
  lldb::SBTypeList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetTypes(arg2);
  *(lldb::SBTypeList **)&jresult = new lldb::SBTypeList((const lldb::SBTypeList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetTypes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  lldb::SBTypeList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  result = (arg1)->GetTypes();
  *(lldb::SBTypeList **)&jresult = new lldb::SBTypeList((const lldb::SBTypeList &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  result = (lldb::LanguageType)(arg1)->GetLanguage();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBCompileUnit_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBCompileUnit *arg1 = (lldb::SBCompileUnit *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBCompileUnit **)&jarg1; 
  result = lldb_SBCompileUnit___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBData_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBData *)new lldb::SBData();
  *(lldb::SBData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBData_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBData *arg1 = 0 ;
  lldb::SBData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBData const & reference is null");
    return 0;
  } 
  result = (lldb::SBData *)new lldb::SBData((lldb::SBData const &)*arg1);
  *(lldb::SBData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jshort JNICALL Java_SWIG_lldbJNI_SBData_1GetAddressByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  result = (uint8_t)(arg1)->GetAddressByteSize();
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBData_1SetAddressByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  uint8_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = (uint8_t)jarg2; 
  (arg1)->SetAddressByteSize(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBData_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  result = (bool)(arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1GetByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  result = (arg1)->GetByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBData_1GetByteOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::ByteOrder result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  result = (lldb::ByteOrder)(arg1)->GetByteOrder();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBData_1SetByteOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::ByteOrder arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = (lldb::ByteOrder)jarg2; 
  (arg1)->SetByteOrder(arg2);
}


SWIGEXPORT jfloat JNICALL Java_SWIG_lldbJNI_SBData_1GetFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jfloat jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (float)(arg1)->GetFloat(*arg2,arg3);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_SWIG_lldbJNI_SBData_1GetDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jdouble jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (double)(arg1)->GetDouble(*arg2,arg3);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1GetLongDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jlong jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  long double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (long double)(arg1)->GetLongDouble(*arg2,arg3);
  *(long double **)&jresult = new long double((const long double &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBData_1GetAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jobject jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (lldb::addr_t)(arg1)->GetAddress(*arg2,arg3);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_SWIG_lldbJNI_SBData_1GetUnsignedInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jshort jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (uint8_t)(arg1)->GetUnsignedInt8(*arg2,arg3);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBData_1GetUnsignedInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jint jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  uint16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (uint16_t)(arg1)->GetUnsignedInt16(*arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1GetUnsignedInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jlong jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (uint32_t)(arg1)->GetUnsignedInt32(*arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBData_1GetUnsignedInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jobject jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (uint64_t)(arg1)->GetUnsignedInt64(*arg2,arg3);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_SWIG_lldbJNI_SBData_1GetSignedInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jbyte jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  int8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (int8_t)(arg1)->GetSignedInt8(*arg2,arg3);
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_SWIG_lldbJNI_SBData_1GetSignedInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jshort jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  int16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (int16_t)(arg1)->GetSignedInt16(*arg2,arg3);
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBData_1GetSignedInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jint jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (int32_t)(arg1)->GetSignedInt32(*arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1GetSignedInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jlong jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (int64_t)(arg1)->GetSignedInt64(*arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBData_1GetString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jstring jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (char *)(arg1)->GetString(*arg2,arg3);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  lldb::addr_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (bool)(arg1)->GetDescription(*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1ReadRawData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::offset_t arg3 ;
  void *arg4 = (void *) 0 ;
  size_t arg5 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::offset_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::offset_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg4 = *(void **)&jarg4; 
  arg5 = (size_t)jarg5; 
  result = (arg1)->ReadRawData(*arg2,arg3,arg4,arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBData_1SetData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jint jarg5, jshort jarg6) {
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  void *arg3 = (void *) 0 ;
  size_t arg4 ;
  lldb::ByteOrder arg5 ;
  uint8_t arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return ;
  } 
  arg3 = *(void **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = (lldb::ByteOrder)jarg5; 
  arg6 = (uint8_t)jarg6; 
  (arg1)->SetData(*arg2,(void const *)arg3,arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBData_1SetDataWithOwnership(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jint jarg5, jshort jarg6) {
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBError *arg2 = 0 ;
  void *arg3 = (void *) 0 ;
  size_t arg4 ;
  lldb::ByteOrder arg5 ;
  uint8_t arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return ;
  } 
  arg3 = *(void **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = (lldb::ByteOrder)jarg5; 
  arg6 = (uint8_t)jarg6; 
  (arg1)->SetDataWithOwnership(*arg2,(void const *)arg3,arg4,arg5,arg6);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1Append(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  lldb::SBData *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(lldb::SBData **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBData const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->Append((lldb::SBData const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1CreateDataFromCString(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::ByteOrder arg1 ;
  uint32_t arg2 ;
  char *arg3 = (char *) 0 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::ByteOrder)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = lldb::SBData::CreateDataFromCString(arg1,arg2,(char const *)arg3);
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1CreateDataFromUInt64Array(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::ByteOrder arg1 ;
  uint32_t arg2 ;
  uint64_t *arg3 = (uint64_t *) 0 ;
  size_t arg4 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::ByteOrder)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(uint64_t **)&jarg3; 
  arg4 = (size_t)jarg4; 
  result = lldb::SBData::CreateDataFromUInt64Array(arg1,arg2,arg3,arg4);
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1CreateDataFromUInt32Array(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::ByteOrder arg1 ;
  uint32_t arg2 ;
  uint32_t *arg3 = (uint32_t *) 0 ;
  size_t arg4 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::ByteOrder)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(uint32_t **)&jarg3; 
  arg4 = (size_t)jarg4; 
  result = lldb::SBData::CreateDataFromUInt32Array(arg1,arg2,arg3,arg4);
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1CreateDataFromSInt64Array(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::ByteOrder arg1 ;
  uint32_t arg2 ;
  int64_t *arg3 = (int64_t *) 0 ;
  size_t arg4 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::ByteOrder)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(int64_t **)&jarg3; 
  arg4 = (size_t)jarg4; 
  result = lldb::SBData::CreateDataFromSInt64Array(arg1,arg2,arg3,arg4);
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1CreateDataFromSInt32Array(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::ByteOrder arg1 ;
  uint32_t arg2 ;
  int32_t *arg3 = (int32_t *) 0 ;
  size_t arg4 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::ByteOrder)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(int32_t **)&jarg3; 
  arg4 = (size_t)jarg4; 
  result = lldb::SBData::CreateDataFromSInt32Array(arg1,arg2,arg3,arg4);
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBData_1CreateDataFromDoubleArray(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::ByteOrder arg1 ;
  uint32_t arg2 ;
  double *arg3 = (double *) 0 ;
  size_t arg4 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::ByteOrder)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(double **)&jarg3; 
  arg4 = (size_t)jarg4; 
  result = lldb::SBData::CreateDataFromDoubleArray(arg1,arg2,arg3,arg4);
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1SetDataFromCString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->SetDataFromCString((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1SetDataFromUInt64Array(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  uint64_t *arg2 = (uint64_t *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(uint64_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)(arg1)->SetDataFromUInt64Array(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1SetDataFromUInt32Array(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  uint32_t *arg2 = (uint32_t *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(uint32_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)(arg1)->SetDataFromUInt32Array(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1SetDataFromSInt64Array(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  int64_t *arg2 = (int64_t *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(int64_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)(arg1)->SetDataFromSInt64Array(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1SetDataFromSInt32Array(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  int32_t *arg2 = (int32_t *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(int32_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)(arg1)->SetDataFromSInt32Array(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBData_1SetDataFromDoubleArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  double *arg2 = (double *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)(arg1)->SetDataFromDoubleArray(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBData_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBData *arg1 = (lldb::SBData *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBData **)&jarg1; 
  result = lldb_SBData___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBDebugger_1eBroadcastBitProgress_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBDebugger::eBroadcastBitProgress;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBDebugger_1eBroadcastBitWarning_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBDebugger::eBroadcastBitWarning;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBDebugger_1eBroadcastBitError_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBDebugger::eBroadcastBitError;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetProgressFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobjectArray jarg4, jbooleanArray jarg5) {
  jstring jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  uint64_t *arg2 = 0 ;
  uint64_t *arg3 = 0 ;
  uint64_t *arg4 = 0 ;
  bool *arg5 = 0 ;
  uint64_t temp2 ;
  uint64_t temp3 ;
  uint64_t temp4 ;
  bool temp5 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp2 = (uint64_t)0;
    arg2 = &temp2; 
  }
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp3 = (uint64_t)0;
    arg3 = &temp3; 
  }
  {
    if (!jarg4) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg4) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp4 = (uint64_t)0;
    arg4 = &temp4; 
  }
  {
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg5) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    temp5 = false;
    arg5 = &temp5; 
  }
  result = (char *)lldb::SBDebugger::GetProgressFromEvent((lldb::SBEvent const &)*arg1,*arg2,*arg3,*arg4,*arg5);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(temp2>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jenv->SetObjectArrayElement(jarg2, 0, bigint);
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(temp3>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jenv->SetObjectArrayElement(jarg3, 0, bigint);
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(temp4>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jenv->SetObjectArrayElement(jarg4, 0, bigint);
  }
  {
    jboolean jvalue = (jboolean)temp5;
    jenv->SetBooleanArrayRegion(jarg5, 0, 1, &jvalue);
  }
  
  
  
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetDiagnosticFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBDebugger::GetDiagnosticFromEvent((lldb::SBEvent const &)*arg1);
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBBroadcaster result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetBroadcaster();
  *(lldb::SBBroadcaster **)&jresult = new lldb::SBBroadcaster((const lldb::SBBroadcaster &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1Initialize(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  lldb::SBDebugger::Initialize();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1InitializeWithErrorHandling(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  result = lldb::SBDebugger::InitializeWithErrorHandling();
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1PrintStackTraceOnError(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  lldb::SBDebugger::PrintStackTraceOnError();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1Terminate(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  lldb::SBDebugger::Terminate();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1Create_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBDebugger result;
  
  (void)jenv;
  (void)jcls;
  result = lldb::SBDebugger::Create();
  *(lldb::SBDebugger **)&jresult = new lldb::SBDebugger((const lldb::SBDebugger &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1Create_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jlong jresult = 0 ;
  bool arg1 ;
  lldb::SBDebugger result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = lldb::SBDebugger::Create(arg1);
  *(lldb::SBDebugger **)&jresult = new lldb::SBDebugger((const lldb::SBDebugger &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1Create_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jboolean jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  bool arg1 ;
  lldb::LogOutputCallback arg2 = (lldb::LogOutputCallback) 0 ;
  void *arg3 = (void *) 0 ;
  lldb::SBDebugger result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  arg2 = *(lldb::LogOutputCallback *)&jarg2; 
  arg3 = *(void **)&jarg3; 
  result = lldb::SBDebugger::Create(arg1,arg2,arg3);
  *(lldb::SBDebugger **)&jresult = new lldb::SBDebugger((const lldb::SBDebugger &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1Destroy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBDebugger *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBDebugger & reference is null");
    return ;
  } 
  lldb::SBDebugger::Destroy(*arg1);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1MemoryPressureDetected(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  lldb::SBDebugger::MemoryPressureDetected();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBDebugger_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBDebugger *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBDebugger *)new lldb::SBDebugger();
  *(lldb::SBDebugger **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBDebugger_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = 0 ;
  lldb::SBDebugger *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBDebugger const & reference is null");
    return 0;
  } 
  result = (lldb::SBDebugger *)new lldb::SBDebugger((lldb::SBDebugger const &)*arg1);
  *(lldb::SBDebugger **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBDebugger(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (bool)((lldb::SBDebugger const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAsync(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetAsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (bool)(arg1)->GetAsync();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SkipLLDBInitFiles(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SkipLLDBInitFiles(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetInputFileHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = lldb_SBDebugger_GetInputFileHandle(arg1);
  *(lldb::FileSP **)&jresult = new lldb::FileSP((const lldb::FileSP &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetOutputFileHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = lldb_SBDebugger_GetOutputFileHandle(arg1);
  *(lldb::FileSP **)&jresult = new lldb::FileSP((const lldb::FileSP &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetErrorFileHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = lldb_SBDebugger_GetErrorFileHandle(arg1);
  *(lldb::FileSP **)&jresult = new lldb::FileSP((const lldb::FileSP &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetSetting_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->GetSetting((char const *)arg2);
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetSetting_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetSetting();
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetInputString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->SetInputString((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetInputFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->SetInputFile(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetOutputFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->SetOutputFile(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetErrorFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->SetErrorFile(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetInputFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->SetInputFile(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetOutputFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->SetOutputFile(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetErrorFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->SetErrorFile(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetInputFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBFile result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetInputFile();
  *(lldb::SBFile **)&jresult = new lldb::SBFile((const lldb::SBFile &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetOutputFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBFile result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetOutputFile();
  *(lldb::SBFile **)&jresult = new lldb::SBFile((const lldb::SBFile &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetErrorFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBFile result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetErrorFile();
  *(lldb::SBFile **)&jresult = new lldb::SBFile((const lldb::SBFile &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetCommandInterpreter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  SwigValueWrapper< lldb::SBCommandInterpreter > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetCommandInterpreter();
  *(lldb::SBCommandInterpreter **)&jresult = new lldb::SBCommandInterpreter((const lldb::SBCommandInterpreter &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1HandleCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->HandleCommand((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBListener result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetListener();
  *(lldb::SBListener **)&jresult = new lldb::SBListener((const lldb::SBListener &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1HandleProcessEvent_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBProcess *arg2 = 0 ;
  lldb::SBEvent *arg3 = 0 ;
  lldb::SBFile arg4 ;
  lldb::SBFile arg5 ;
  lldb::SBFile *argp4 ;
  lldb::SBFile *argp5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(lldb::SBProcess **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBProcess const & reference is null");
    return ;
  } 
  arg3 = *(lldb::SBEvent **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return ;
  } 
  argp4 = *(lldb::SBFile **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return ;
  }
  arg4 = *argp4; 
  argp5 = *(lldb::SBFile **)&jarg5; 
  if (!argp5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return ;
  }
  arg5 = *argp5; 
  (arg1)->HandleProcessEvent((lldb::SBProcess const &)*arg2,(lldb::SBEvent const &)*arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1HandleProcessEvent_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jlong jarg5) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBProcess *arg2 = 0 ;
  lldb::SBEvent *arg3 = 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg4 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg5 ;
  lldb::FileSP *argp4 ;
  lldb::FileSP *argp5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(lldb::SBProcess **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBProcess const & reference is null");
    return ;
  } 
  arg3 = *(lldb::SBEvent **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return ;
  } 
  argp4 = *(lldb::FileSP **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg4 = *argp4; 
  argp5 = *(lldb::FileSP **)&jarg5; 
  if (!argp5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg5 = *argp5; 
  (arg1)->HandleProcessEvent((lldb::SBProcess const &)*arg2,(lldb::SBEvent const &)*arg3,arg4,arg5);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1CreateTarget_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jboolean jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  bool arg5 ;
  lldb::SBError *arg6 = 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = jarg5 ? true : false; 
  arg6 = *(lldb::SBError **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->CreateTarget((char const *)arg2,(char const *)arg3,(char const *)arg4,arg5,*arg6);
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1CreateTargetWithFileAndTargetTriple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->CreateTargetWithFileAndTargetTriple((char const *)arg2,(char const *)arg3);
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1CreateTargetWithFileAndArch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->CreateTargetWithFileAndArch((char const *)arg2,(char const *)arg3);
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1CreateTarget_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->CreateTarget((char const *)arg2);
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetDummyTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetDummyTarget();
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1DeleteTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTarget *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(lldb::SBTarget **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->DeleteTarget(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetTargetAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t arg2 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetTargetAtIndex(arg2);
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetIndexOfTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTarget arg2 ;
  lldb::SBTarget *argp2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  result = (uint32_t)(arg1)->GetIndexOfTarget(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1FindTargetWithProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::pid_t arg2 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::pid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::pid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->FindTargetWithProcessID(arg2);
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1FindTargetWithFileAndArch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->FindTargetWithFileAndArch((char const *)arg2,(char const *)arg3);
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetNumTargets(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumTargets();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetSelectedTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetSelectedTarget();
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetSelectedTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTarget *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(lldb::SBTarget **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return ;
  } 
  (arg1)->SetSelectedTarget(*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetSelectedPlatform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBPlatform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetSelectedPlatform();
  *(lldb::SBPlatform **)&jresult = new lldb::SBPlatform((const lldb::SBPlatform &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetSelectedPlatform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBPlatform *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(lldb::SBPlatform **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBPlatform & reference is null");
    return ;
  } 
  (arg1)->SetSelectedPlatform(*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetNumPlatforms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumPlatforms();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetPlatformAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t arg2 ;
  lldb::SBPlatform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetPlatformAtIndex(arg2);
  *(lldb::SBPlatform **)&jresult = new lldb::SBPlatform((const lldb::SBPlatform &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetNumAvailablePlatforms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumAvailablePlatforms();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetAvailablePlatformInfoAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t arg2 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetAvailablePlatformInfoAtIndex(arg2);
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetSourceManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  SwigValueWrapper< lldb::SBSourceManager > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetSourceManager();
  *(lldb::SBSourceManager **)&jresult = new lldb::SBSourceManager((const lldb::SBSourceManager &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetCurrentPlatform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->SetCurrentPlatform((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetCurrentPlatformSDKRoot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->SetCurrentPlatformSDKRoot((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetUseExternalEditor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->SetUseExternalEditor(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetUseExternalEditor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (bool)(arg1)->GetUseExternalEditor();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetUseColor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)(arg1)->SetUseColor(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetUseColor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (bool)((lldb::SBDebugger const *)arg1)->GetUseColor();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetDefaultArchitecture(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  size_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (size_t)jarg2; 
  result = (bool)lldb::SBDebugger::GetDefaultArchitecture(arg1,arg2);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetDefaultArchitecture(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jboolean jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (bool)lldb::SBDebugger::SetDefaultArchitecture((char const *)arg1);
  jresult = (jboolean)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetScriptingLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::ScriptLanguage result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (lldb::ScriptLanguage)(arg1)->GetScriptingLanguage((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetVersionString(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)lldb::SBDebugger::GetVersionString();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBDebugger_1StateAsCString(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  lldb::StateType arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::StateType)jarg1; 
  result = (char *)lldb::SBDebugger::StateAsCString(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetBuildConfiguration(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  result = lldb::SBDebugger::GetBuildConfiguration();
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1StateIsRunningState(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  lldb::StateType arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::StateType)jarg1; 
  result = (bool)lldb::SBDebugger::StateIsRunningState(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1StateIsStoppedState(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  lldb::StateType arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::StateType)jarg1; 
  result = (bool)lldb::SBDebugger::StateIsStoppedState(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1EnableLog(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobjectArray jarg3) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  char **arg3 = (char **) 0 ;
  jint size3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  result = (bool)(arg1)->EnableLog((char const *)arg2,(char const **)arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetLoggingCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::LogOutputCallback arg2 = (lldb::LogOutputCallback) 0 ;
  void *arg3 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(lldb::LogOutputCallback *)&jarg2; 
  arg3 = *(void **)&jarg3; 
  (arg1)->SetLoggingCallback(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1DispatchInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  void *arg2 = (void *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (size_t)jarg3; 
  (arg1)->DispatchInput((void const *)arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1DispatchInputInterrupt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  (arg1)->DispatchInputInterrupt();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1DispatchInputEndOfFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  (arg1)->DispatchInputEndOfFile();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetInstanceName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (char *)(arg1)->GetInstanceName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1FindDebuggerWithID(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  lldb::SBDebugger result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = lldb::SBDebugger::FindDebuggerWithID(arg1);
  *(lldb::SBDebugger **)&jresult = new lldb::SBDebugger((const lldb::SBDebugger &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetInternalVariable(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = lldb::SBDebugger::SetInternalVariable((char const *)arg1,(char const *)arg2,(char const *)arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetInternalVariableValue(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStringList result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = lldb::SBDebugger::GetInternalVariableValue((char const *)arg1,(char const *)arg2);
  *(lldb::SBStringList **)&jresult = new lldb::SBStringList((const lldb::SBStringList &)result); 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetTerminalWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (uint32_t)((lldb::SBDebugger const *)arg1)->GetTerminalWidth();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetTerminalWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetTerminalWidth(arg2);
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::user_id_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (lldb::user_id_t)(arg1)->GetID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetPrompt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (char *)((lldb::SBDebugger const *)arg1)->GetPrompt();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetPrompt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetPrompt((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetReproducerPath(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (char *)((lldb::SBDebugger const *)arg1)->GetReproducerPath();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetScriptLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::ScriptLanguage result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (lldb::ScriptLanguage)((lldb::SBDebugger const *)arg1)->GetScriptLanguage();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetScriptLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::ScriptLanguage arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (lldb::ScriptLanguage)jarg2; 
  (arg1)->SetScriptLanguage(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetCloseInputOnEOF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (bool)((lldb::SBDebugger const *)arg1)->GetCloseInputOnEOF();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1SetCloseInputOnEOF(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetCloseInputOnEOF(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetCategory_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBTypeCategory result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->GetCategory((char const *)arg2);
  *(lldb::SBTypeCategory **)&jresult = new lldb::SBTypeCategory((const lldb::SBTypeCategory &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetCategory_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::LanguageType arg2 ;
  lldb::SBTypeCategory result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (lldb::LanguageType)jarg2; 
  result = (arg1)->GetCategory(arg2);
  *(lldb::SBTypeCategory **)&jresult = new lldb::SBTypeCategory((const lldb::SBTypeCategory &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1CreateCategory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBTypeCategory result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->CreateCategory((char const *)arg2);
  *(lldb::SBTypeCategory **)&jresult = new lldb::SBTypeCategory((const lldb::SBTypeCategory &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDebugger_1DeleteCategory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->DeleteCategory((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetNumCategories(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumCategories();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetCategoryAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  uint32_t arg2 ;
  lldb::SBTypeCategory result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetCategoryAtIndex(arg2);
  *(lldb::SBTypeCategory **)&jresult = new lldb::SBTypeCategory((const lldb::SBTypeCategory &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetDefaultCategory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTypeCategory result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = (arg1)->GetDefaultCategory();
  *(lldb::SBTypeCategory **)&jresult = new lldb::SBTypeCategory((const lldb::SBTypeCategory &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetFormatForType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTypeNameSpecifier arg2 ;
  lldb::SBTypeNameSpecifier *argp2 ;
  lldb::SBTypeFormat result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::SBTypeNameSpecifier **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTypeNameSpecifier");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->GetFormatForType(arg2);
  *(lldb::SBTypeFormat **)&jresult = new lldb::SBTypeFormat((const lldb::SBTypeFormat &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetSummaryForType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTypeNameSpecifier arg2 ;
  lldb::SBTypeNameSpecifier *argp2 ;
  lldb::SBTypeSummary result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::SBTypeNameSpecifier **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTypeNameSpecifier");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->GetSummaryForType(arg2);
  *(lldb::SBTypeSummary **)&jresult = new lldb::SBTypeSummary((const lldb::SBTypeSummary &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetFilterForType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTypeNameSpecifier arg2 ;
  lldb::SBTypeNameSpecifier *argp2 ;
  lldb::SBTypeFilter result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::SBTypeNameSpecifier **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTypeNameSpecifier");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->GetFilterForType(arg2);
  *(lldb::SBTypeFilter **)&jresult = new lldb::SBTypeFilter((const lldb::SBTypeFilter &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetSyntheticForType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBTypeNameSpecifier arg2 ;
  lldb::SBTypeNameSpecifier *argp2 ;
  lldb::SBTypeSynthetic result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  argp2 = *(lldb::SBTypeNameSpecifier **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTypeNameSpecifier");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->GetSyntheticForType(arg2);
  *(lldb::SBTypeSynthetic **)&jresult = new lldb::SBTypeSynthetic((const lldb::SBTypeSynthetic &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1GetScriptInterpreterInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::ScriptLanguage arg2 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (lldb::ScriptLanguage)jarg2; 
  result = (arg1)->GetScriptInterpreterInfo(arg2);
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBDebugger_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  result = lldb_SBDebugger___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDebugger_1RunCommandInterpreter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jboolean jarg3, jlong jarg4, jobject jarg4_, jintArray jarg5, jbooleanArray jarg6, jbooleanArray jarg7) {
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  bool arg2 ;
  bool arg3 ;
  lldb::SBCommandInterpreterRunOptions *arg4 = 0 ;
  int *arg5 = 0 ;
  bool *arg6 = 0 ;
  bool *arg7 = 0 ;
  bool btemp6 ;
  jboolean *jbtemp6 ;
  bool btemp7 ;
  jboolean *jbtemp7 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  arg4 = *(lldb::SBCommandInterpreterRunOptions **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandInterpreterRunOptions & reference is null");
    return ;
  } 
  {
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg5) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    arg5 = (int *) jenv->GetIntArrayElements(jarg5, 0); 
  }
  {
    if (!jarg6) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg6) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    jbtemp6 = jenv->GetBooleanArrayElements(jarg6, 0);
    btemp6 = (*jbtemp6) ? true : false;
    arg6 = &btemp6;
  }
  {
    if (!jarg7) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg7) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    jbtemp7 = jenv->GetBooleanArrayElements(jarg7, 0);
    btemp7 = (*jbtemp7) ? true : false;
    arg7 = &btemp7;
  }
  (arg1)->RunCommandInterpreter(arg2,arg3,*arg4,*arg5,*arg6,*arg7);
  {
    jenv->ReleaseIntArrayElements(jarg5, (jint *)arg5, 0); 
  }
  {
    *jbtemp6 = btemp6 ? (jboolean)1 : (jboolean)0;
    jenv->ReleaseBooleanArrayElements(jarg6, (jboolean *)jbtemp6, 0);
  }
  {
    *jbtemp7 = btemp7 ? (jboolean)1 : (jboolean)0;
    jenv->ReleaseBooleanArrayElements(jarg7, (jboolean *)jbtemp7, 0);
  }
  
  
  
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1RunREPL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::LanguageType arg2 ;
  char *arg3 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = (lldb::LanguageType)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->RunREPL(arg2,(char const *)arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDebugger_1LoadTraceFromFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBDebugger *arg1 = (lldb::SBDebugger *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::SBFileSpec *arg3 = 0 ;
  lldb::SBTrace result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBDebugger **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBFileSpec **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  result = (arg1)->LoadTraceFromFile(*arg2,(lldb::SBFileSpec const &)*arg3);
  *(lldb::SBTrace **)&jresult = new lldb::SBTrace((const lldb::SBTrace &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBDeclaration_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBDeclaration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBDeclaration *)new lldb::SBDeclaration();
  *(lldb::SBDeclaration **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBDeclaration_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDeclaration *arg1 = 0 ;
  lldb::SBDeclaration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDeclaration **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBDeclaration const & reference is null");
    return 0;
  } 
  result = (lldb::SBDeclaration *)new lldb::SBDeclaration((lldb::SBDeclaration const &)*arg1);
  *(lldb::SBDeclaration **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBDeclaration(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDeclaration_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  result = (bool)((lldb::SBDeclaration const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDeclaration_1GetFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  result = ((lldb::SBDeclaration const *)arg1)->GetFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDeclaration_1GetLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  result = (uint32_t)((lldb::SBDeclaration const *)arg1)->GetLine();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBDeclaration_1GetColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  result = (uint32_t)((lldb::SBDeclaration const *)arg1)->GetColumn();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBDeclaration_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDeclaration_1SetFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  lldb::SBFileSpec arg2 ;
  lldb::SBFileSpec *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  argp2 = *(lldb::SBFileSpec **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFileSpec");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetFileSpec(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDeclaration_1SetLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetLine(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBDeclaration_1SetColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetColumn(arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBDeclaration_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBDeclaration *arg1 = (lldb::SBDeclaration *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBDeclaration **)&jarg1; 
  result = lldb_SBDeclaration___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBError_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBError *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBError *)new lldb::SBError();
  *(lldb::SBError **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBError_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBError *arg1 = 0 ;
  lldb::SBError *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError const & reference is null");
    return 0;
  } 
  result = (lldb::SBError *)new lldb::SBError((lldb::SBError const &)*arg1);
  *(lldb::SBError **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBError(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBError **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBError_1GetCString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  result = (char *)((lldb::SBError const *)arg1)->GetCString();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBError_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBError_1Fail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  result = (bool)((lldb::SBError const *)arg1)->Fail();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBError_1Success(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  result = (bool)((lldb::SBError const *)arg1)->Success();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBError_1GetError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  result = (uint32_t)((lldb::SBError const *)arg1)->GetError();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBError_1GetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  lldb::ErrorType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  result = (lldb::ErrorType)((lldb::SBError const *)arg1)->GetType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBError_1SetError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  uint32_t arg2 ;
  lldb::ErrorType arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (lldb::ErrorType)jarg3; 
  (arg1)->SetError(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBError_1SetErrorToErrno(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  (arg1)->SetErrorToErrno();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBError_1SetErrorToGenericError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  (arg1)->SetErrorToGenericError();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBError_1SetErrorString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetErrorString((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBError_1SetErrorStringWithFormat_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jint jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (int)(arg1)->SetErrorStringWithFormat((char const *)arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBError_1SetErrorStringWithFormat_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (int)(arg1)->SetErrorStringWithFormat((char const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBError_1SetErrorStringWithFormat_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)(arg1)->SetErrorStringWithFormat((char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBError_1SetErrorStringWithFormat_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)(arg1)->SetErrorStringWithFormat((char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBError_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  result = (bool)((lldb::SBError const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBError_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBError **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBError_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBError *arg1 = (lldb::SBError *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBError **)&jarg1; 
  result = lldb_SBError___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBEnvironment_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBEnvironment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBEnvironment *)new lldb::SBEnvironment();
  *(lldb::SBEnvironment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBEnvironment_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEnvironment *arg1 = 0 ;
  lldb::SBEnvironment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEnvironment const & reference is null");
    return 0;
  } 
  result = (lldb::SBEnvironment *)new lldb::SBEnvironment((lldb::SBEnvironment const &)*arg1);
  *(lldb::SBEnvironment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBEnvironment(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBEnvironment_1GetNumValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  result = (arg1)->GetNumValues();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBEnvironment_1Get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)(arg1)->Get((char const *)arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBEnvironment_1GetNameAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  size_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (char *)(arg1)->GetNameAtIndex(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBEnvironment_1GetValueAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  size_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (char *)(arg1)->GetValueAtIndex(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBEnvironment_1GetEntries(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  lldb::SBStringList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  result = (arg1)->GetEntries();
  *(lldb::SBStringList **)&jresult = new lldb::SBStringList((const lldb::SBStringList &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBEnvironment_1PutEntry(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->PutEntry((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBEnvironment_1SetEntries(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList const & reference is null");
    return ;
  } 
  arg3 = jarg3 ? true : false; 
  (arg1)->SetEntries((lldb::SBStringList const &)*arg2,arg3);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBEnvironment_1Set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = jarg4 ? true : false; 
  result = (bool)(arg1)->Set((char const *)arg2,(char const *)arg3,arg4);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBEnvironment_1Unset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->Unset((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBEnvironment_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBEnvironment *arg1 = (lldb::SBEnvironment *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEnvironment **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBEvent_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBEvent *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBEvent *)new lldb::SBEvent();
  *(lldb::SBEvent **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBEvent_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::SBEvent *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (lldb::SBEvent *)new lldb::SBEvent((lldb::SBEvent const &)*arg1);
  *(lldb::SBEvent **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBEvent_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::SBEvent *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  result = (lldb::SBEvent *)new lldb::SBEvent(arg1,(char const *)arg2,arg3);
  *(lldb::SBEvent **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBEvent_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  result = (bool)((lldb::SBEvent const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBEvent_1GetDataFlavor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  result = (char *)(arg1)->GetDataFlavor();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBEvent_1GetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  result = (uint32_t)((lldb::SBEvent const *)arg1)->GetType();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBEvent_1GetBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  lldb::SBBroadcaster result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  result = ((lldb::SBEvent const *)arg1)->GetBroadcaster();
  *(lldb::SBBroadcaster **)&jresult = new lldb::SBBroadcaster((const lldb::SBBroadcaster &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBEvent_1GetBroadcasterClass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  result = (char *)((lldb::SBEvent const *)arg1)->GetBroadcasterClass();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBEvent_1BroadcasterMatchesRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  lldb::SBBroadcaster *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  arg2 = *(lldb::SBBroadcaster **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->BroadcasterMatchesRef((lldb::SBBroadcaster const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBEvent_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBEvent_1GetCStringFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (char *)lldb::SBEvent::GetCStringFromEvent((lldb::SBEvent const &)*arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBEvent_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = (lldb::SBEvent *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBEvent **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)((lldb::SBEvent const *)arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBExecutionContext_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBExecutionContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBExecutionContext *)new lldb::SBExecutionContext();
  *(lldb::SBExecutionContext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBExecutionContext_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBExecutionContext *arg1 = 0 ;
  lldb::SBExecutionContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExecutionContext **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBExecutionContext const & reference is null");
    return 0;
  } 
  result = (lldb::SBExecutionContext *)new lldb::SBExecutionContext((lldb::SBExecutionContext const &)*arg1);
  *(lldb::SBExecutionContext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBExecutionContext_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = 0 ;
  lldb::SBExecutionContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget const & reference is null");
    return 0;
  } 
  result = (lldb::SBExecutionContext *)new lldb::SBExecutionContext((lldb::SBTarget const &)*arg1);
  *(lldb::SBExecutionContext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBExecutionContext_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = 0 ;
  lldb::SBExecutionContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBProcess const & reference is null");
    return 0;
  } 
  result = (lldb::SBExecutionContext *)new lldb::SBExecutionContext((lldb::SBProcess const &)*arg1);
  *(lldb::SBExecutionContext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBExecutionContext_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBThread arg1 ;
  lldb::SBThread *argp1 ;
  lldb::SBExecutionContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(lldb::SBThread **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBThread");
    return 0;
  }
  arg1 = *argp1; 
  result = (lldb::SBExecutionContext *)new lldb::SBExecutionContext(arg1);
  *(lldb::SBExecutionContext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBExecutionContext_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = 0 ;
  lldb::SBExecutionContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFrame const & reference is null");
    return 0;
  } 
  result = (lldb::SBExecutionContext *)new lldb::SBExecutionContext((lldb::SBFrame const &)*arg1);
  *(lldb::SBExecutionContext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBExecutionContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBExecutionContext *arg1 = (lldb::SBExecutionContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBExecutionContext **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBExecutionContext_1GetTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBExecutionContext *arg1 = (lldb::SBExecutionContext *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExecutionContext **)&jarg1; 
  result = ((lldb::SBExecutionContext const *)arg1)->GetTarget();
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBExecutionContext_1GetProcess(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBExecutionContext *arg1 = (lldb::SBExecutionContext *) 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExecutionContext **)&jarg1; 
  result = ((lldb::SBExecutionContext const *)arg1)->GetProcess();
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBExecutionContext_1GetThread(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBExecutionContext *arg1 = (lldb::SBExecutionContext *) 0 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExecutionContext **)&jarg1; 
  result = ((lldb::SBExecutionContext const *)arg1)->GetThread();
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBExecutionContext_1GetFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBExecutionContext *arg1 = (lldb::SBExecutionContext *) 0 ;
  lldb::SBFrame result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExecutionContext **)&jarg1; 
  result = ((lldb::SBExecutionContext const *)arg1)->GetFrame();
  *(lldb::SBFrame **)&jresult = new lldb::SBFrame((const lldb::SBFrame &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBExpressionOptions_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBExpressionOptions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBExpressionOptions *)new lldb::SBExpressionOptions();
  *(lldb::SBExpressionOptions **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBExpressionOptions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = 0 ;
  lldb::SBExpressionOptions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBExpressionOptions const & reference is null");
    return 0;
  } 
  result = (lldb::SBExpressionOptions *)new lldb::SBExpressionOptions((lldb::SBExpressionOptions const &)*arg1);
  *(lldb::SBExpressionOptions **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBExpressionOptions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetCoerceResultToId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)((lldb::SBExpressionOptions const *)arg1)->GetCoerceResultToId();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetCoerceResultToId_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetCoerceResultToId(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetCoerceResultToId_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetCoerceResultToId();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetUnwindOnError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)((lldb::SBExpressionOptions const *)arg1)->GetUnwindOnError();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetUnwindOnError_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetUnwindOnError(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetUnwindOnError_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetUnwindOnError();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetIgnoreBreakpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)((lldb::SBExpressionOptions const *)arg1)->GetIgnoreBreakpoints();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetIgnoreBreakpoints_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetIgnoreBreakpoints(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetIgnoreBreakpoints_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetIgnoreBreakpoints();
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetFetchDynamicValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  lldb::DynamicValueType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (lldb::DynamicValueType)((lldb::SBExpressionOptions const *)arg1)->GetFetchDynamicValue();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetFetchDynamicValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  lldb::DynamicValueType arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = (lldb::DynamicValueType)jarg2; 
  (arg1)->SetFetchDynamicValue(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetFetchDynamicValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetFetchDynamicValue();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetTimeoutInMicroSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (uint32_t)((lldb::SBExpressionOptions const *)arg1)->GetTimeoutInMicroSeconds();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetTimeoutInMicroSeconds_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetTimeoutInMicroSeconds(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetTimeoutInMicroSeconds_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetTimeoutInMicroSeconds();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetOneThreadTimeoutInMicroSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (uint32_t)((lldb::SBExpressionOptions const *)arg1)->GetOneThreadTimeoutInMicroSeconds();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetOneThreadTimeoutInMicroSeconds_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetOneThreadTimeoutInMicroSeconds(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetOneThreadTimeoutInMicroSeconds_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetOneThreadTimeoutInMicroSeconds();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetTryAllThreads(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)((lldb::SBExpressionOptions const *)arg1)->GetTryAllThreads();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetTryAllThreads_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetTryAllThreads(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetTryAllThreads_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetTryAllThreads();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetStopOthers(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)((lldb::SBExpressionOptions const *)arg1)->GetStopOthers();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetStopOthers_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetStopOthers(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetStopOthers_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetStopOthers();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetTrapExceptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)((lldb::SBExpressionOptions const *)arg1)->GetTrapExceptions();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetTrapExceptions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetTrapExceptions(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetTrapExceptions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetTrapExceptions();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  lldb::LanguageType arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = (lldb::LanguageType)jarg2; 
  (arg1)->SetLanguage(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetGenerateDebugInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)(arg1)->GetGenerateDebugInfo();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetGenerateDebugInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetGenerateDebugInfo(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetGenerateDebugInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetGenerateDebugInfo();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetSuppressPersistentResult(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)(arg1)->GetSuppressPersistentResult();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetSuppressPersistentResult_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetSuppressPersistentResult(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetSuppressPersistentResult_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetSuppressPersistentResult();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetPrefix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (char *)((lldb::SBExpressionOptions const *)arg1)->GetPrefix();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetPrefix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetPrefix((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetAutoApplyFixIts_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAutoApplyFixIts(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetAutoApplyFixIts_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetAutoApplyFixIts();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetAutoApplyFixIts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)(arg1)->GetAutoApplyFixIts();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetRetriesWithFixIts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  uint64_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (uint64_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  (arg1)->SetRetriesWithFixIts(arg2);
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetRetriesWithFixIts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (uint64_t)(arg1)->GetRetriesWithFixIts();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetTopLevel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)(arg1)->GetTopLevel();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetTopLevel_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetTopLevel(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetTopLevel_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  (arg1)->SetTopLevel();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1GetAllowJIT(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  result = (bool)(arg1)->GetAllowJIT();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBExpressionOptions_1SetAllowJIT(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBExpressionOptions *arg1 = (lldb::SBExpressionOptions *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBExpressionOptions **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetAllowJIT(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBFile *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBFile *)new lldb::SBFile();
  *(lldb::SBFile **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  bool arg3 ;
  lldb::SBFile *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = jarg3 ? true : false; 
  result = (lldb::SBFile *)new lldb::SBFile(arg1,(char const *)arg2,arg3);
  *(lldb::SBFile **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFile_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg1 ;
  lldb::FileSP *argp1 ;
  lldb::SBFile *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(lldb::FileSP **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg1 = *argp1; 
  result = (lldb::SBFile *)new lldb::SBFile(arg1);
  *(lldb::SBFile **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFile_1MakeBorrowed(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg1 ;
  lldb::FileSP *argp1 ;
  lldb::SBFile result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(lldb::FileSP **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg1 = *argp1; 
  result = lldb_SBFile_MakeBorrowed(arg1);
  *(lldb::SBFile **)&jresult = new lldb::SBFile((const lldb::SBFile &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFile_1MakeForcingIOMethods(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg1 ;
  lldb::FileSP *argp1 ;
  lldb::SBFile result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(lldb::FileSP **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg1 = *argp1; 
  result = lldb_SBFile_MakeForcingIOMethods(arg1);
  *(lldb::SBFile **)&jresult = new lldb::SBFile((const lldb::SBFile &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFile_1MakeBorrowedForcingIOMethods(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg1 ;
  lldb::FileSP *argp1 ;
  lldb::SBFile result;
  
  (void)jenv;
  (void)jcls;
  argp1 = *(lldb::FileSP **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return 0;
  }
  arg1 = *argp1; 
  result = lldb_SBFile_MakeBorrowedForcingIOMethods(arg1);
  *(lldb::SBFile **)&jresult = new lldb::SBFile((const lldb::SBFile &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBFile(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBFile *arg1 = (lldb::SBFile *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBFile **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFile_1Read(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::SBFile *arg1 = (lldb::SBFile *) 0 ;
  uint8_t *arg2 = (uint8_t *) 0 ;
  size_t arg3 ;
  size_t *arg4 = (size_t *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFile **)&jarg1; 
  arg2 = *(uint8_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = *(size_t **)&jarg4; 
  result = (arg1)->Read(arg2,arg3,arg4);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFile_1Write(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::SBFile *arg1 = (lldb::SBFile *) 0 ;
  uint8_t *arg2 = (uint8_t *) 0 ;
  size_t arg3 ;
  size_t *arg4 = (size_t *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFile **)&jarg1; 
  arg2 = *(uint8_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = *(size_t **)&jarg4; 
  result = (arg1)->Write((uint8_t const *)arg2,arg3,arg4);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBFile_1Flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBFile *arg1 = (lldb::SBFile *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFile **)&jarg1; 
  (arg1)->Flush();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFile_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFile *arg1 = (lldb::SBFile *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFile **)&jarg1; 
  result = (bool)((lldb::SBFile const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFile_1Close(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFile *arg1 = (lldb::SBFile *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFile **)&jarg1; 
  result = (arg1)->Close();
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFile_1GetFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFile *arg1 = (lldb::SBFile *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFile **)&jarg1; 
  result = (arg1)->GetFile();
  *(lldb::FileSP **)&jresult = new lldb::FileSP((const lldb::FileSP &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFileSpec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBFileSpec *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBFileSpec *)new lldb::SBFileSpec();
  *(lldb::SBFileSpec **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFileSpec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFileSpec *arg1 = 0 ;
  lldb::SBFileSpec *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  result = (lldb::SBFileSpec *)new lldb::SBFileSpec((lldb::SBFileSpec const &)*arg1);
  *(lldb::SBFileSpec **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFileSpec_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::SBFileSpec *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (lldb::SBFileSpec *)new lldb::SBFileSpec((char const *)arg1);
  *(lldb::SBFileSpec **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFileSpec_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  bool arg2 ;
  lldb::SBFileSpec *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = jarg2 ? true : false; 
  result = (lldb::SBFileSpec *)new lldb::SBFileSpec((char const *)arg1,arg2);
  *(lldb::SBFileSpec **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFileSpec_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  result = (bool)((lldb::SBFileSpec const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFileSpec_1Exists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  result = (bool)((lldb::SBFileSpec const *)arg1)->Exists();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFileSpec_1ResolveExecutableLocation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  result = (bool)(arg1)->ResolveExecutableLocation();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFileSpec_1GetFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  result = (char *)((lldb::SBFileSpec const *)arg1)->GetFilename();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFileSpec_1GetDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  result = (char *)((lldb::SBFileSpec const *)arg1)->GetDirectory();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBFileSpec_1SetFilename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetFilename((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBFileSpec_1SetDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetDirectory((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFileSpec_1GetPath(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (uint32_t)((lldb::SBFileSpec const *)arg1)->GetPath(arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBFileSpec_1ResolvePath(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (int)lldb::SBFileSpec::ResolvePath((char const *)arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFileSpec_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)((lldb::SBFileSpec const *)arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBFileSpec_1AppendPathComponent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->AppendPathComponent((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFileSpec_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFileSpec *arg1 = (lldb::SBFileSpec *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpec **)&jarg1; 
  result = lldb_SBFileSpec___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFileSpecList_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBFileSpecList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBFileSpecList *)new lldb::SBFileSpecList();
  *(lldb::SBFileSpecList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFileSpecList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFileSpecList *arg1 = 0 ;
  lldb::SBFileSpecList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpecList **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (lldb::SBFileSpecList *)new lldb::SBFileSpecList((lldb::SBFileSpecList const &)*arg1);
  *(lldb::SBFileSpecList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBFileSpecList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBFileSpecList *arg1 = (lldb::SBFileSpecList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBFileSpecList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFileSpecList_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFileSpecList *arg1 = (lldb::SBFileSpecList *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpecList **)&jarg1; 
  result = (uint32_t)((lldb::SBFileSpecList const *)arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFileSpecList_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBFileSpecList *arg1 = (lldb::SBFileSpecList *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFileSpecList **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)((lldb::SBFileSpecList const *)arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBFileSpecList_1Append(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBFileSpecList *arg1 = (lldb::SBFileSpecList *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFileSpecList **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return ;
  } 
  (arg1)->Append((lldb::SBFileSpec const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFileSpecList_1AppendIfUnique(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBFileSpecList *arg1 = (lldb::SBFileSpecList *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFileSpecList **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->AppendIfUnique((lldb::SBFileSpec const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBFileSpecList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBFileSpecList *arg1 = (lldb::SBFileSpecList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpecList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFileSpecList_1FindFileIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  lldb::SBFileSpecList *arg1 = (lldb::SBFileSpecList *) 0 ;
  uint32_t arg2 ;
  lldb::SBFileSpec *arg3 = 0 ;
  bool arg4 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBFileSpecList **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(lldb::SBFileSpec **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  result = (uint32_t)(arg1)->FindFileIndex(arg2,(lldb::SBFileSpec const &)*arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFileSpecList_1GetFileSpecAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBFileSpecList *arg1 = (lldb::SBFileSpecList *) 0 ;
  uint32_t arg2 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFileSpecList **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = ((lldb::SBFileSpecList const *)arg1)->GetFileSpecAtIndex(arg2);
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFrame_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBFrame *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBFrame *)new lldb::SBFrame();
  *(lldb::SBFrame **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFrame_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = 0 ;
  lldb::SBFrame *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFrame const & reference is null");
    return 0;
  } 
  result = (lldb::SBFrame *)new lldb::SBFrame((lldb::SBFrame const &)*arg1);
  *(lldb::SBFrame **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBFrame(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFrame_1IsEqual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBFrame *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = *(lldb::SBFrame **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFrame const & reference is null");
    return 0;
  } 
  result = (bool)((lldb::SBFrame const *)arg1)->IsEqual((lldb::SBFrame const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFrame_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (bool)((lldb::SBFrame const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetFrameID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (uint32_t)((lldb::SBFrame const *)arg1)->GetFrameID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBFrame_1GetCFA(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (lldb::addr_t)((lldb::SBFrame const *)arg1)->GetCFA();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBFrame_1GetPC(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (lldb::addr_t)((lldb::SBFrame const *)arg1)->GetPC();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFrame_1SetPC(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jboolean jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::addr_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (bool)(arg1)->SetPC(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBFrame_1GetSP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (lldb::addr_t)((lldb::SBFrame const *)arg1)->GetSP();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBFrame_1GetFP(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (lldb::addr_t)((lldb::SBFrame const *)arg1)->GetFP();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetPCAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetPCAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetSymbolContext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  uint32_t arg2 ;
  lldb::SBSymbolContext result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = ((lldb::SBFrame const *)arg1)->GetSymbolContext(arg2);
  *(lldb::SBSymbolContext **)&jresult = new lldb::SBSymbolContext((const lldb::SBSymbolContext &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetModule();
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetCompileUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBCompileUnit result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetCompileUnit();
  *(lldb::SBCompileUnit **)&jresult = new lldb::SBCompileUnit((const lldb::SBCompileUnit &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBFunction result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetFunction();
  *(lldb::SBFunction **)&jresult = new lldb::SBFunction((const lldb::SBFunction &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBSymbol result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetSymbol();
  *(lldb::SBSymbol **)&jresult = new lldb::SBSymbol((const lldb::SBSymbol &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetBlock();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFrame_1GetFunctionName_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (char *)(arg1)->GetFunctionName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFrame_1GetDisplayFunctionName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (char *)(arg1)->GetDisplayFunctionName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBFrame_1GuessLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (lldb::LanguageType)((lldb::SBFrame const *)arg1)->GuessLanguage();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFrame_1IsInlined_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (bool)(arg1)->IsInlined();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFrame_1IsArtificial_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (bool)(arg1)->IsArtificial();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1EvaluateExpression_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->EvaluateExpression((char const *)arg2);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1EvaluateExpression_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::DynamicValueType arg3 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::DynamicValueType)jarg3; 
  result = (arg1)->EvaluateExpression((char const *)arg2,arg3);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1EvaluateExpression_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::DynamicValueType arg3 ;
  bool arg4 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::DynamicValueType)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (arg1)->EvaluateExpression((char const *)arg2,arg3,arg4);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1EvaluateExpression_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBExpressionOptions *arg3 = 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBExpressionOptions **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBExpressionOptions & reference is null");
    return 0;
  } 
  result = (arg1)->EvaluateExpression((char const *)arg2,*arg3);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetFrameBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetFrameBlock();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetLineEntry(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBLineEntry result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetLineEntry();
  *(lldb::SBLineEntry **)&jresult = new lldb::SBLineEntry((const lldb::SBLineEntry &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetThread(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = ((lldb::SBFrame const *)arg1)->GetThread();
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFrame_1Disassemble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (char *)((lldb::SBFrame const *)arg1)->Disassemble();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBFrame_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetVariables_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jboolean jarg3, jboolean jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  bool arg2 ;
  bool arg3 ;
  bool arg4 ;
  bool arg5 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  result = (arg1)->GetVariables(arg2,arg3,arg4,arg5);
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetVariables_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jboolean jarg3, jboolean jarg4, jboolean jarg5, jint jarg6) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  bool arg2 ;
  bool arg3 ;
  bool arg4 ;
  bool arg5 ;
  lldb::DynamicValueType arg6 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  arg6 = (lldb::DynamicValueType)jarg6; 
  result = (arg1)->GetVariables(arg2,arg3,arg4,arg5,arg6);
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetVariables_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBVariablesOptions *arg2 = 0 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = *(lldb::SBVariablesOptions **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBVariablesOptions const & reference is null");
    return 0;
  } 
  result = (arg1)->GetVariables((lldb::SBVariablesOptions const &)*arg2);
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetRegisters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = (arg1)->GetRegisters();
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1FindVariable_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindVariable((char const *)arg2);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1FindVariable_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::DynamicValueType arg3 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::DynamicValueType)jarg3; 
  result = (arg1)->FindVariable((char const *)arg2,arg3);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1FindRegister(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindRegister((char const *)arg2);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetValueForVariablePath_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->GetValueForVariablePath((char const *)arg2);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1GetValueForVariablePath_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::DynamicValueType arg3 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::DynamicValueType)jarg3; 
  result = (arg1)->GetValueForVariablePath((char const *)arg2,arg3);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1FindValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::ValueType arg3 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::ValueType)jarg3; 
  result = (arg1)->FindValue((char const *)arg2,arg3);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFrame_1FindValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::ValueType arg3 ;
  lldb::DynamicValueType arg4 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::ValueType)jarg3; 
  arg4 = (lldb::DynamicValueType)jarg4; 
  result = (arg1)->FindValue((char const *)arg2,arg3,arg4);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFrame_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFrame_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFrame *arg1 = (lldb::SBFrame *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFrame **)&jarg1; 
  result = lldb_SBFrame___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFunction_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBFunction *)new lldb::SBFunction();
  *(lldb::SBFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBFunction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFunction *arg1 = 0 ;
  lldb::SBFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFunction const & reference is null");
    return 0;
  } 
  result = (lldb::SBFunction *)new lldb::SBFunction((lldb::SBFunction const &)*arg1);
  *(lldb::SBFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBFunction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFunction_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (bool)((lldb::SBFunction const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFunction_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (char *)((lldb::SBFunction const *)arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFunction_1GetDisplayName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (char *)((lldb::SBFunction const *)arg1)->GetDisplayName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFunction_1GetMangledName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (char *)((lldb::SBFunction const *)arg1)->GetMangledName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFunction_1GetInstructions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  lldb::SBTarget arg2 ;
  lldb::SBTarget *argp2 ;
  lldb::SBInstructionList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->GetInstructions(arg2);
  *(lldb::SBInstructionList **)&jresult = new lldb::SBInstructionList((const lldb::SBInstructionList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFunction_1GetInstructions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  lldb::SBTarget arg2 ;
  char *arg3 = (char *) 0 ;
  lldb::SBTarget *argp2 ;
  lldb::SBInstructionList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->GetInstructions(arg2,(char const *)arg3);
  *(lldb::SBInstructionList **)&jresult = new lldb::SBInstructionList((const lldb::SBInstructionList &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFunction_1GetStartAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (arg1)->GetStartAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFunction_1GetEndAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (arg1)->GetEndAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFunction_1GetArgumentName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  uint32_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (char *)(arg1)->GetArgumentName(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFunction_1GetPrologueByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (uint32_t)(arg1)->GetPrologueByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFunction_1GetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  lldb::SBType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (arg1)->GetType();
  *(lldb::SBType **)&jresult = new lldb::SBType((const lldb::SBType &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBFunction_1GetBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (arg1)->GetBlock();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBFunction_1GetLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (lldb::LanguageType)(arg1)->GetLanguage();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFunction_1GetIsOptimized(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = (bool)(arg1)->GetIsOptimized();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBFunction_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBFunction_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBFunction *arg1 = (lldb::SBFunction *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBFunction **)&jarg1; 
  result = lldb_SBFunction___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBHostOS_1GetProgramFileSpec(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  result = lldb::SBHostOS::GetProgramFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBHostOS_1GetLLDBPythonPath(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  result = lldb::SBHostOS::GetLLDBPythonPath();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBHostOS_1GetLLDBPath(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  lldb::PathType arg1 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::PathType)jarg1; 
  result = lldb::SBHostOS::GetLLDBPath(arg1);
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBHostOS_1GetUserHomeDirectory(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  result = lldb::SBHostOS::GetUserHomeDirectory();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBHostOS_1ThreadCreated(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  lldb::SBHostOS::ThreadCreated((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBHostOS_1ThreadCreate(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::thread_func_t arg2 = (lldb::thread_func_t) 0 ;
  void *arg3 = (void *) 0 ;
  lldb::SBError *arg4 = (lldb::SBError *) 0 ;
  lldb::thread_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg4_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(lldb::thread_func_t *)&jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = *(lldb::SBError **)&jarg4; 
  result = lldb::SBHostOS::ThreadCreate((char const *)arg1,arg2,arg3,arg4);
  *(lldb::thread_t **)&jresult = new lldb::thread_t((const lldb::thread_t &)result); 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBHostOS_1ThreadCancel(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::thread_t arg1 ;
  lldb::SBError *arg2 = (lldb::SBError *) 0 ;
  lldb::thread_t *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  argp1 = *(lldb::thread_t **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::thread_t");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = *(lldb::SBError **)&jarg2; 
  result = (bool)lldb::SBHostOS::ThreadCancel(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBHostOS_1ThreadDetach(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::thread_t arg1 ;
  lldb::SBError *arg2 = (lldb::SBError *) 0 ;
  lldb::thread_t *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  argp1 = *(lldb::thread_t **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::thread_t");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = *(lldb::SBError **)&jarg2; 
  result = (bool)lldb::SBHostOS::ThreadDetach(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBHostOS_1ThreadJoin(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::thread_t arg1 ;
  lldb::thread_result_t *arg2 = (lldb::thread_result_t *) 0 ;
  lldb::SBError *arg3 = (lldb::SBError *) 0 ;
  lldb::thread_t *argp1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  argp1 = *(lldb::thread_t **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::thread_t");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = *(lldb::thread_result_t **)&jarg2; 
  arg3 = *(lldb::SBError **)&jarg3; 
  result = (bool)lldb::SBHostOS::ThreadJoin(arg1,arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBHostOS(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBHostOS *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBHostOS *)new lldb::SBHostOS();
  *(lldb::SBHostOS **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBHostOS(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBHostOS *arg1 = (lldb::SBHostOS *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBHostOS **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBInstruction_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBInstruction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBInstruction *)new lldb::SBInstruction();
  *(lldb::SBInstruction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBInstruction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBInstruction *arg1 = 0 ;
  lldb::SBInstruction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBInstruction const & reference is null");
    return 0;
  } 
  result = (lldb::SBInstruction *)new lldb::SBInstruction((lldb::SBInstruction const &)*arg1);
  *(lldb::SBInstruction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBInstruction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstruction_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  result = (bool)(arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBInstruction_1GetAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  result = (arg1)->GetAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBInstruction_1GetMnemonic(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBTarget arg2 ;
  lldb::SBTarget *argp2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  result = (char *)(arg1)->GetMnemonic(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBInstruction_1GetOperands(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBTarget arg2 ;
  lldb::SBTarget *argp2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  result = (char *)(arg1)->GetOperands(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBInstruction_1GetComment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBTarget arg2 ;
  lldb::SBTarget *argp2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  result = (char *)(arg1)->GetComment(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBInstruction_1GetControlFlowKind(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBTarget arg2 ;
  lldb::SBTarget *argp2 ;
  lldb::InstructionControlFlowKind result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  result = (lldb::InstructionControlFlowKind)(arg1)->GetControlFlowKind(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBInstruction_1GetData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBTarget arg2 ;
  lldb::SBTarget *argp2 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->GetData(arg2);
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBInstruction_1GetByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  result = (arg1)->GetByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstruction_1DoesBranch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  result = (bool)(arg1)->DoesBranch();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstruction_1HasDelaySlot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  result = (bool)(arg1)->HasDelaySlot();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstruction_1CanSetBreakpoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  result = (bool)(arg1)->CanSetBreakpoint();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBInstruction_1Print_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->Print(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBInstruction_1Print_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->Print(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstruction_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstruction_1EmulateWithFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBFrame *arg2 = 0 ;
  uint32_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  arg2 = *(lldb::SBFrame **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFrame & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  result = (bool)(arg1)->EmulateWithFrame(*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstruction_1DumpEmulation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->DumpEmulation((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstruction_1TestEmulation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jboolean jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (bool)(arg1)->TestEmulation(*arg2,(char const *)arg3);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBInstruction_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBInstruction *arg1 = (lldb::SBInstruction *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstruction **)&jarg1; 
  result = lldb_SBInstruction___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBInstructionList_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBInstructionList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBInstructionList *)new lldb::SBInstructionList();
  *(lldb::SBInstructionList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBInstructionList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBInstructionList *arg1 = 0 ;
  lldb::SBInstructionList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstructionList **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBInstructionList const & reference is null");
    return 0;
  } 
  result = (lldb::SBInstructionList *)new lldb::SBInstructionList((lldb::SBInstructionList const &)*arg1);
  *(lldb::SBInstructionList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBInstructionList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstructionList_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  result = (bool)((lldb::SBInstructionList const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBInstructionList_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  result = (arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBInstructionList_1GetInstructionAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  uint32_t arg2 ;
  lldb::SBInstruction result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetInstructionAtIndex(arg2);
  *(lldb::SBInstruction **)&jresult = new lldb::SBInstruction((const lldb::SBInstruction &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBInstructionList_1GetInstructionsCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  lldb::SBAddress *arg2 = 0 ;
  lldb::SBAddress *arg3 = 0 ;
  bool arg4 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  arg2 = *(lldb::SBAddress **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress const & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBAddress **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress const & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  result = (arg1)->GetInstructionsCount((lldb::SBAddress const &)*arg2,(lldb::SBAddress const &)*arg3,arg4);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBInstructionList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBInstructionList_1AppendInstruction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  lldb::SBInstruction arg2 ;
  lldb::SBInstruction *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  argp2 = *(lldb::SBInstruction **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBInstruction");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->AppendInstruction(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBInstructionList_1Print_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->Print(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBInstructionList_1Print_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->Print(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstructionList_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBInstructionList_1DumpEmulationForAllInstructions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->DumpEmulationForAllInstructions((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBInstructionList_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBInstructionList *arg1 = (lldb::SBInstructionList *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBInstructionList **)&jarg1; 
  result = lldb_SBInstructionList___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBLanguageRuntime_1GetLanguageTypeFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::LanguageType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (lldb::LanguageType)lldb::SBLanguageRuntime::GetLanguageTypeFromString((char const *)arg1);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLanguageRuntime_1GetNameForLanguageType(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  lldb::LanguageType arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (lldb::LanguageType)jarg1; 
  result = (char *)lldb::SBLanguageRuntime::GetNameForLanguageType(arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBLanguageRuntime(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBLanguageRuntime *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBLanguageRuntime *)new lldb::SBLanguageRuntime();
  *(lldb::SBLanguageRuntime **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBLanguageRuntime(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBLanguageRuntime *arg1 = (lldb::SBLanguageRuntime *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBLanguageRuntime **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBLaunchInfo(JNIEnv *jenv, jclass jcls, jobjectArray jarg1) {
  jlong jresult = 0 ;
  char **arg1 = (char **) 0 ;
  jint size1 ;
  lldb::SBLaunchInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    int i = 0;
    if (jarg1) {
      size1 = jenv->GetArrayLength(jarg1);
      
      arg1 = new char*[size1+1];
      
      
      
      for (i = 0; i<size1; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg1, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg1[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg1[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg1[i] = 0;
    } else {
      arg1 = 0;
      size1 = 0;
    }
  }
  result = (lldb::SBLaunchInfo *)new lldb::SBLaunchInfo((char const **)arg1);
  *(lldb::SBLaunchInfo **)&jresult = result; 
  {
    int i;
    for (i=0; i<size1; i++)
    
    delete[] arg1[i];
    delete[] arg1;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::pid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (lldb::pid_t)(arg1)->GetProcessID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetUserID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetUserID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetGroupID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetGroupID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1UserIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (bool)(arg1)->UserIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GroupIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (bool)(arg1)->GroupIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetUserID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetUserID(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetGroupID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetGroupID(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetExecutableFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (arg1)->GetExecutableFile();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetExecutableFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::SBFileSpec arg2 ;
  bool arg3 ;
  lldb::SBFileSpec *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  argp2 = *(lldb::SBFileSpec **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFileSpec");
    return ;
  }
  arg2 = *argp2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->SetExecutableFile(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::SBListener result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (arg1)->GetListener();
  *(lldb::SBListener **)&jresult = new lldb::SBListener((const lldb::SBListener &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener & reference is null");
    return ;
  } 
  (arg1)->SetListener(*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetNumArguments(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumArguments();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetArgumentAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (char *)(arg1)->GetArgumentAtIndex(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetArguments(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jboolean jarg3) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char **arg2 = (char **) 0 ;
  bool arg3 ;
  jint size2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  arg3 = jarg3 ? true : false; 
  (arg1)->SetArguments((char const **)arg2,arg3);
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetNumEnvironmentEntries(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumEnvironmentEntries();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetEnvironmentEntryAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (char *)(arg1)->GetEnvironmentEntryAtIndex(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetEnvironmentEntries(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jboolean jarg3) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char **arg2 = (char **) 0 ;
  bool arg3 ;
  jint size2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  arg3 = jarg3 ? true : false; 
  (arg1)->SetEnvironmentEntries((char const **)arg2,arg3);
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetEnvironment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::SBEnvironment *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = *(lldb::SBEnvironment **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEnvironment const & reference is null");
    return ;
  } 
  arg3 = jarg3 ? true : false; 
  (arg1)->SetEnvironment((lldb::SBEnvironment const &)*arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetEnvironment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::SBEnvironment result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (arg1)->GetEnvironment();
  *(lldb::SBEnvironment **)&jresult = new lldb::SBEnvironment((const lldb::SBEnvironment &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (char *)((lldb::SBLaunchInfo const *)arg1)->GetWorkingDirectory();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetWorkingDirectory((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetLaunchFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetLaunchFlags();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetLaunchFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetLaunchFlags(arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetProcessPluginName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (char *)(arg1)->GetProcessPluginName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetProcessPluginName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetProcessPluginName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetShell(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (char *)(arg1)->GetShell();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetShell(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetShell((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetShellExpandArguments(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (bool)(arg1)->GetShellExpandArguments();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetShellExpandArguments(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetShellExpandArguments(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetResumeCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetResumeCount();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetResumeCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetResumeCount(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1AddCloseFileAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (bool)(arg1)->AddCloseFileAction(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1AddDuplicateFileAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  int arg2 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (bool)(arg1)->AddDuplicateFileAction(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1AddOpenFileAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jboolean jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  result = (bool)(arg1)->AddOpenFileAction(arg2,(char const *)arg3,arg4,arg5);
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1AddSuppressFileAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3, jboolean jarg4) {
  jboolean jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  int arg2 ;
  bool arg3 ;
  bool arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  result = (bool)(arg1)->AddSuppressFileAction(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetLaunchEventData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetLaunchEventData((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetLaunchEventData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (char *)((lldb::SBLaunchInfo const *)arg1)->GetLaunchEventData();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetDetachOnError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (bool)((lldb::SBLaunchInfo const *)arg1)->GetDetachOnError();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetDetachOnError(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetDetachOnError(arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetScriptedProcessClassName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = (char *)((lldb::SBLaunchInfo const *)arg1)->GetScriptedProcessClassName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetScriptedProcessClassName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetScriptedProcessClassName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1GetScriptedProcessDictionary(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  result = ((lldb::SBLaunchInfo const *)arg1)->GetScriptedProcessDictionary();
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLaunchInfo_1SetScriptedProcessDictionary(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  lldb::SBStructuredData arg2 ;
  lldb::SBStructuredData *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  argp2 = *(lldb::SBStructuredData **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBStructuredData");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetScriptedProcessDictionary(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBLaunchInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBLaunchInfo *arg1 = (lldb::SBLaunchInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBLaunchInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBLineEntry_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBLineEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBLineEntry *)new lldb::SBLineEntry();
  *(lldb::SBLineEntry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBLineEntry_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLineEntry *arg1 = 0 ;
  lldb::SBLineEntry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBLineEntry const & reference is null");
    return 0;
  } 
  result = (lldb::SBLineEntry *)new lldb::SBLineEntry((lldb::SBLineEntry const &)*arg1);
  *(lldb::SBLineEntry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBLineEntry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLineEntry_1GetStartAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  result = ((lldb::SBLineEntry const *)arg1)->GetStartAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLineEntry_1GetEndAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  result = ((lldb::SBLineEntry const *)arg1)->GetEndAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLineEntry_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  result = (bool)((lldb::SBLineEntry const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLineEntry_1GetFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  result = ((lldb::SBLineEntry const *)arg1)->GetFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLineEntry_1GetLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  result = (uint32_t)((lldb::SBLineEntry const *)arg1)->GetLine();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBLineEntry_1GetColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  result = (uint32_t)((lldb::SBLineEntry const *)arg1)->GetColumn();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBLineEntry_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLineEntry_1SetFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  lldb::SBFileSpec arg2 ;
  lldb::SBFileSpec *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  argp2 = *(lldb::SBFileSpec **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFileSpec");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetFileSpec(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLineEntry_1SetLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetLine(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBLineEntry_1SetColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetColumn(arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBLineEntry_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBLineEntry *arg1 = (lldb::SBLineEntry *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBLineEntry **)&jarg1; 
  result = lldb_SBLineEntry___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBListener_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBListener *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBListener *)new lldb::SBListener();
  *(lldb::SBListener **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBListener_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::SBListener *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (lldb::SBListener *)new lldb::SBListener((char const *)arg1);
  *(lldb::SBListener **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBListener_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBListener *arg1 = 0 ;
  lldb::SBListener *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBListener **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener const & reference is null");
    return 0;
  } 
  result = (lldb::SBListener *)new lldb::SBListener((lldb::SBListener const &)*arg1);
  *(lldb::SBListener **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBListener(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBListener **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBListener_1AddEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return ;
  } 
  (arg1)->AddEvent((lldb::SBEvent const &)*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBListener_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  result = (bool)((lldb::SBListener const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBListener_1StartListeningForEventClass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBDebugger *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  uint32_t arg4 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBDebugger **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBDebugger & reference is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (uint32_t)jarg4; 
  result = (uint32_t)(arg1)->StartListeningForEventClass(*arg2,(char const *)arg3,arg4);
  jresult = (jlong)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBListener_1StopListeningForEventClass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBDebugger *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  uint32_t arg4 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBDebugger **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBDebugger & reference is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (uint32_t)jarg4; 
  result = (uint32_t)(arg1)->StopListeningForEventClass(*arg2,(char const *)arg3,arg4);
  jresult = (jlong)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBListener_1StartListeningForEvents(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBBroadcaster *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBBroadcaster **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  result = (uint32_t)(arg1)->StartListeningForEvents((lldb::SBBroadcaster const &)*arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1StopListeningForEvents(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBBroadcaster *arg2 = 0 ;
  uint32_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBBroadcaster **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  result = (bool)(arg1)->StopListeningForEvents((lldb::SBBroadcaster const &)*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1WaitForEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  uint32_t arg2 ;
  lldb::SBEvent *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(lldb::SBEvent **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->WaitForEvent(arg2,*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1WaitForEventForBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  uint32_t arg2 ;
  lldb::SBBroadcaster *arg3 = 0 ;
  lldb::SBEvent *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(lldb::SBBroadcaster **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBEvent **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->WaitForEventForBroadcaster(arg2,(lldb::SBBroadcaster const &)*arg3,*arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1WaitForEventForBroadcasterWithType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  uint32_t arg2 ;
  lldb::SBBroadcaster *arg3 = 0 ;
  uint32_t arg4 ;
  lldb::SBEvent *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(lldb::SBBroadcaster **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  arg4 = (uint32_t)jarg4; 
  arg5 = *(lldb::SBEvent **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->WaitForEventForBroadcasterWithType(arg2,(lldb::SBBroadcaster const &)*arg3,arg4,*arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1PeekAtNextEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->PeekAtNextEvent(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1PeekAtNextEventForBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBBroadcaster *arg2 = 0 ;
  lldb::SBEvent *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBBroadcaster **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBEvent **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->PeekAtNextEventForBroadcaster((lldb::SBBroadcaster const &)*arg2,*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1PeekAtNextEventForBroadcasterWithType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBBroadcaster *arg2 = 0 ;
  uint32_t arg3 ;
  lldb::SBEvent *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBBroadcaster **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  arg4 = *(lldb::SBEvent **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->PeekAtNextEventForBroadcasterWithType((lldb::SBBroadcaster const &)*arg2,arg3,*arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1GetNextEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetNextEvent(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1GetNextEventForBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBBroadcaster *arg2 = 0 ;
  lldb::SBEvent *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBBroadcaster **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBEvent **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetNextEventForBroadcaster((lldb::SBBroadcaster const &)*arg2,*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1GetNextEventForBroadcasterWithType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBBroadcaster *arg2 = 0 ;
  uint32_t arg3 ;
  lldb::SBEvent *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBBroadcaster **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBroadcaster const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  arg4 = *(lldb::SBEvent **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetNextEventForBroadcasterWithType((lldb::SBBroadcaster const &)*arg2,arg3,*arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBListener_1HandleBroadcastEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBListener *arg1 = (lldb::SBListener *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBListener **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->HandleBroadcastEvent((lldb::SBEvent const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBMemoryRegionInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBMemoryRegionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBMemoryRegionInfo *)new lldb::SBMemoryRegionInfo();
  *(lldb::SBMemoryRegionInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBMemoryRegionInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = 0 ;
  lldb::SBMemoryRegionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBMemoryRegionInfo const & reference is null");
    return 0;
  } 
  result = (lldb::SBMemoryRegionInfo *)new lldb::SBMemoryRegionInfo((lldb::SBMemoryRegionInfo const &)*arg1);
  *(lldb::SBMemoryRegionInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBMemoryRegionInfo_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jobject jarg2, jobject jarg3, jlong jarg4, jboolean jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::addr_t arg2 ;
  lldb::addr_t arg3 ;
  uint32_t arg4 ;
  bool arg5 ;
  bool arg6 ;
  lldb::SBMemoryRegionInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg4 = (uint32_t)jarg4; 
  arg5 = jarg5 ? true : false; 
  arg6 = jarg6 ? true : false; 
  result = (lldb::SBMemoryRegionInfo *)new lldb::SBMemoryRegionInfo((char const *)arg1,arg2,arg3,arg4,arg5,arg6);
  *(lldb::SBMemoryRegionInfo **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBMemoryRegionInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1GetRegionBase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (lldb::addr_t)(arg1)->GetRegionBase();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1GetRegionEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (lldb::addr_t)(arg1)->GetRegionEnd();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1IsReadable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (bool)(arg1)->IsReadable();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1IsWritable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (bool)(arg1)->IsWritable();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1IsExecutable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (bool)(arg1)->IsExecutable();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1IsMapped(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (bool)(arg1)->IsMapped();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (char *)(arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1HasDirtyMemoryPageList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (bool)(arg1)->HasDirtyMemoryPageList();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1GetNumDirtyPages(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumDirtyPages();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1GetDirtyPageAddressAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jobject jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  uint32_t arg2 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (lldb::addr_t)(arg1)->GetDirtyPageAddressAtIndex(arg2);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1GetPageSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = (int)(arg1)->GetPageSize();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfo_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBMemoryRegionInfo *arg1 = (lldb::SBMemoryRegionInfo *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfo **)&jarg1; 
  result = lldb_SBMemoryRegionInfo___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBMemoryRegionInfoList_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBMemoryRegionInfoList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBMemoryRegionInfoList *)new lldb::SBMemoryRegionInfoList();
  *(lldb::SBMemoryRegionInfoList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBMemoryRegionInfoList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBMemoryRegionInfoList *arg1 = 0 ;
  lldb::SBMemoryRegionInfoList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfoList **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBMemoryRegionInfoList const & reference is null");
    return 0;
  } 
  result = (lldb::SBMemoryRegionInfoList *)new lldb::SBMemoryRegionInfoList((lldb::SBMemoryRegionInfoList const &)*arg1);
  *(lldb::SBMemoryRegionInfoList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBMemoryRegionInfoList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBMemoryRegionInfoList *arg1 = (lldb::SBMemoryRegionInfoList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBMemoryRegionInfoList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfoList_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBMemoryRegionInfoList *arg1 = (lldb::SBMemoryRegionInfoList *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfoList **)&jarg1; 
  result = (uint32_t)((lldb::SBMemoryRegionInfoList const *)arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfoList_1GetMemoryRegionContainingAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::SBMemoryRegionInfoList *arg1 = (lldb::SBMemoryRegionInfoList *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBMemoryRegionInfo *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBMemoryRegionInfoList **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = *(lldb::SBMemoryRegionInfo **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBMemoryRegionInfo & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetMemoryRegionContainingAddress(arg2,*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfoList_1GetMemoryRegionAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::SBMemoryRegionInfoList *arg1 = (lldb::SBMemoryRegionInfoList *) 0 ;
  uint32_t arg2 ;
  lldb::SBMemoryRegionInfo *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBMemoryRegionInfoList **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(lldb::SBMemoryRegionInfo **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBMemoryRegionInfo & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetMemoryRegionAtIndex(arg2,*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfoList_1Append_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBMemoryRegionInfoList *arg1 = (lldb::SBMemoryRegionInfoList *) 0 ;
  lldb::SBMemoryRegionInfo *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBMemoryRegionInfoList **)&jarg1; 
  arg2 = *(lldb::SBMemoryRegionInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBMemoryRegionInfo & reference is null");
    return ;
  } 
  (arg1)->Append(*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfoList_1Append_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBMemoryRegionInfoList *arg1 = (lldb::SBMemoryRegionInfoList *) 0 ;
  lldb::SBMemoryRegionInfoList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBMemoryRegionInfoList **)&jarg1; 
  arg2 = *(lldb::SBMemoryRegionInfoList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBMemoryRegionInfoList & reference is null");
    return ;
  } 
  (arg1)->Append(*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBMemoryRegionInfoList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBMemoryRegionInfoList *arg1 = (lldb::SBMemoryRegionInfoList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBMemoryRegionInfoList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBModule_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBModule *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBModule *)new lldb::SBModule();
  *(lldb::SBModule **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBModule_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = 0 ;
  lldb::SBModule *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModule const & reference is null");
    return 0;
  } 
  result = (lldb::SBModule *)new lldb::SBModule((lldb::SBModule const &)*arg1);
  *(lldb::SBModule **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBModule_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpec *arg1 = 0 ;
  lldb::SBModule *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModuleSpec const & reference is null");
    return 0;
  } 
  result = (lldb::SBModule *)new lldb::SBModule((lldb::SBModuleSpec const &)*arg1);
  *(lldb::SBModule **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBModule_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = 0 ;
  lldb::addr_t arg2 ;
  lldb::SBModule *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBProcess & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (lldb::SBModule *)new lldb::SBModule(*arg1,arg2);
  *(lldb::SBModule **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBModule(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBModule **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModule_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (bool)((lldb::SBModule const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModule_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModule_1IsFileBacked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (bool)((lldb::SBModule const *)arg1)->IsFileBacked();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = ((lldb::SBModule const *)arg1)->GetFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetPlatformFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = ((lldb::SBModule const *)arg1)->GetPlatformFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModule_1SetPlatformFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->SetPlatformFileSpec((lldb::SBFileSpec const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetRemoteInstallFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (arg1)->GetRemoteInstallFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModule_1SetRemoteInstallFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->SetRemoteInstallFileSpec(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBModule_1GetUUIDString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (char *)((lldb::SBModule const *)arg1)->GetUUIDString();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindSection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBSection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindSection((char const *)arg2);
  *(lldb::SBSection **)&jresult = new lldb::SBSection((const lldb::SBSection &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1ResolveFileAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->ResolveFileAddress(arg2);
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1ResolveSymbolContextForAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBAddress *arg2 = 0 ;
  uint32_t arg3 ;
  lldb::SBSymbolContext result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = *(lldb::SBAddress **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->ResolveSymbolContextForAddress((lldb::SBAddress const &)*arg2,arg3);
  *(lldb::SBSymbolContext **)&jresult = new lldb::SBSymbolContext((const lldb::SBSymbolContext &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModule_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetNumCompileUnits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumCompileUnits();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetCompileUnitAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  uint32_t arg2 ;
  lldb::SBCompileUnit result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetCompileUnitAtIndex(arg2);
  *(lldb::SBCompileUnit **)&jresult = new lldb::SBCompileUnit((const lldb::SBCompileUnit &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindCompileUnits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  result = (arg1)->FindCompileUnits((lldb::SBFileSpec const &)*arg2);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetNumSymbols(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (arg1)->GetNumSymbols();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetSymbolAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  size_t arg2 ;
  lldb::SBSymbol result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (arg1)->GetSymbolAtIndex(arg2);
  *(lldb::SBSymbol **)&jresult = new lldb::SBSymbol((const lldb::SBSymbol &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindSymbol_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SymbolType arg3 ;
  lldb::SBSymbol result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::SymbolType)jarg3; 
  result = (arg1)->FindSymbol((char const *)arg2,arg3);
  *(lldb::SBSymbol **)&jresult = new lldb::SBSymbol((const lldb::SBSymbol &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindSymbol_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBSymbol result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindSymbol((char const *)arg2);
  *(lldb::SBSymbol **)&jresult = new lldb::SBSymbol((const lldb::SBSymbol &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindSymbols_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SymbolType arg3 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::SymbolType)jarg3; 
  result = (arg1)->FindSymbols((char const *)arg2,arg3);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindSymbols_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindSymbols((char const *)arg2);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetNumSections(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (arg1)->GetNumSections();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetSectionAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  size_t arg2 ;
  lldb::SBSection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (arg1)->GetSectionAtIndex(arg2);
  *(lldb::SBSection **)&jresult = new lldb::SBSection((const lldb::SBSection &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindFunctions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->FindFunctions((char const *)arg2,arg3);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindFunctions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindFunctions((char const *)arg2);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindFirstType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindFirstType((char const *)arg2);
  *(lldb::SBType **)&jresult = new lldb::SBType((const lldb::SBType &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindTypes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBTypeList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindTypes((char const *)arg2);
  *(lldb::SBTypeList **)&jresult = new lldb::SBTypeList((const lldb::SBTypeList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetTypeByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::user_id_t arg2 ;
  lldb::SBType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::user_id_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::user_id_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->GetTypeByID(arg2);
  *(lldb::SBType **)&jresult = new lldb::SBType((const lldb::SBType &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetBasicType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::BasicType arg2 ;
  lldb::SBType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = (lldb::BasicType)jarg2; 
  result = (arg1)->GetBasicType(arg2);
  *(lldb::SBType **)&jresult = new lldb::SBType((const lldb::SBType &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetTypes_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  uint32_t arg2 ;
  lldb::SBTypeList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetTypes(arg2);
  *(lldb::SBTypeList **)&jresult = new lldb::SBTypeList((const lldb::SBTypeList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetTypes_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBTypeList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (arg1)->GetTypes();
  *(lldb::SBTypeList **)&jresult = new lldb::SBTypeList((const lldb::SBTypeList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindGlobalVariables(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBTarget *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  uint32_t arg4 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = *(lldb::SBTarget **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (uint32_t)jarg4; 
  result = (arg1)->FindGlobalVariables(*arg2,(char const *)arg3,arg4);
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1FindFirstGlobalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBTarget *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = *(lldb::SBTarget **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->FindFirstGlobalVariable(*arg2,(char const *)arg3);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBModule_1GetByteOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::ByteOrder result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (lldb::ByteOrder)(arg1)->GetByteOrder();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetAddressByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (uint32_t)(arg1)->GetAddressByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBModule_1GetTriple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = (char *)(arg1)->GetTriple();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  uint32_t *arg2 = (uint32_t *) 0 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  arg2 = *(uint32_t **)&jarg2; 
  arg3 = (uint32_t)jarg3; 
  result = (uint32_t)(arg1)->GetVersion(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetSymbolFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = ((lldb::SBModule const *)arg1)->GetSymbolFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetObjectFileHeaderAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = ((lldb::SBModule const *)arg1)->GetObjectFileHeaderAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetObjectFileEntryPointAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = ((lldb::SBModule const *)arg1)->GetObjectFileEntryPointAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModule_1GetNumberAllocatedModules(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)lldb::SBModule::GetNumberAllocatedModules();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModule_1GarbageCollectAllocatedModules(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  lldb::SBModule::GarbageCollectAllocatedModules();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBModule_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBModule *arg1 = (lldb::SBModule *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModule **)&jarg1; 
  result = lldb_SBModule___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBModuleSpec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBModuleSpec *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBModuleSpec *)new lldb::SBModuleSpec();
  *(lldb::SBModuleSpec **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBModuleSpec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpec *arg1 = 0 ;
  lldb::SBModuleSpec *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModuleSpec const & reference is null");
    return 0;
  } 
  result = (lldb::SBModuleSpec *)new lldb::SBModuleSpec((lldb::SBModuleSpec const &)*arg1);
  *(lldb::SBModuleSpec **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBModuleSpec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = (bool)((lldb::SBModuleSpec const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1GetFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = (arg1)->GetFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1SetFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return ;
  } 
  (arg1)->SetFileSpec((lldb::SBFileSpec const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1GetPlatformFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = (arg1)->GetPlatformFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1SetPlatformFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return ;
  } 
  (arg1)->SetPlatformFileSpec((lldb::SBFileSpec const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1GetSymbolFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = (arg1)->GetSymbolFileSpec();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1SetSymbolFileSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return ;
  } 
  (arg1)->SetSymbolFileSpec((lldb::SBFileSpec const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1GetObjectName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = (char *)(arg1)->GetObjectName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1SetObjectName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetObjectName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1GetTriple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = (char *)(arg1)->GetTriple();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1SetTriple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetTriple((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1GetUUIDBytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  uint8_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = (uint8_t *)(arg1)->GetUUIDBytes();
  *(uint8_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1GetUUIDLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = (arg1)->GetUUIDLength();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1SetUUIDBytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  uint8_t *arg2 = (uint8_t *) 0 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  arg2 = *(uint8_t **)&jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)(arg1)->SetUUIDBytes((uint8_t const *)arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBModuleSpec_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBModuleSpec *arg1 = (lldb::SBModuleSpec *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpec **)&jarg1; 
  result = lldb_SBModuleSpec___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBModuleSpecList_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBModuleSpecList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBModuleSpecList *)new lldb::SBModuleSpecList();
  *(lldb::SBModuleSpecList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBModuleSpecList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpecList *arg1 = 0 ;
  lldb::SBModuleSpecList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModuleSpecList const & reference is null");
    return 0;
  } 
  result = (lldb::SBModuleSpecList *)new lldb::SBModuleSpecList((lldb::SBModuleSpecList const &)*arg1);
  *(lldb::SBModuleSpecList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBModuleSpecList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1GetModuleSpecifications(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::SBModuleSpecList result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = lldb::SBModuleSpecList::GetModuleSpecifications((char const *)arg1);
  *(lldb::SBModuleSpecList **)&jresult = new lldb::SBModuleSpecList((const lldb::SBModuleSpecList &)result); 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1Append_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  lldb::SBModuleSpec *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  arg2 = *(lldb::SBModuleSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModuleSpec const & reference is null");
    return ;
  } 
  (arg1)->Append((lldb::SBModuleSpec const &)*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1Append_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  lldb::SBModuleSpecList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  arg2 = *(lldb::SBModuleSpecList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModuleSpecList const & reference is null");
    return ;
  } 
  (arg1)->Append((lldb::SBModuleSpecList const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1FindFirstMatchingSpec(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  lldb::SBModuleSpec *arg2 = 0 ;
  lldb::SBModuleSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  arg2 = *(lldb::SBModuleSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModuleSpec const & reference is null");
    return 0;
  } 
  result = (arg1)->FindFirstMatchingSpec((lldb::SBModuleSpec const &)*arg2);
  *(lldb::SBModuleSpec **)&jresult = new lldb::SBModuleSpec((const lldb::SBModuleSpec &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1FindMatchingSpecs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  lldb::SBModuleSpec *arg2 = 0 ;
  lldb::SBModuleSpecList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  arg2 = *(lldb::SBModuleSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModuleSpec const & reference is null");
    return 0;
  } 
  result = (arg1)->FindMatchingSpecs((lldb::SBModuleSpec const &)*arg2);
  *(lldb::SBModuleSpecList **)&jresult = new lldb::SBModuleSpecList((const lldb::SBModuleSpecList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  result = (arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1GetSpecAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  size_t arg2 ;
  lldb::SBModuleSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (arg1)->GetSpecAtIndex(arg2);
  *(lldb::SBModuleSpec **)&jresult = new lldb::SBModuleSpec((const lldb::SBModuleSpec &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBModuleSpecList_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBModuleSpecList *arg1 = (lldb::SBModuleSpecList *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBModuleSpecList **)&jarg1; 
  result = lldb_SBModuleSpecList___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBPlatformConnectOptions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::SBPlatformConnectOptions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (lldb::SBPlatformConnectOptions *)new lldb::SBPlatformConnectOptions((char const *)arg1);
  *(lldb::SBPlatformConnectOptions **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBPlatformConnectOptions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBPlatformConnectOptions *arg1 = 0 ;
  lldb::SBPlatformConnectOptions *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBPlatformConnectOptions const & reference is null");
    return 0;
  } 
  result = (lldb::SBPlatformConnectOptions *)new lldb::SBPlatformConnectOptions((lldb::SBPlatformConnectOptions const &)*arg1);
  *(lldb::SBPlatformConnectOptions **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBPlatformConnectOptions(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBPlatformConnectOptions *arg1 = (lldb::SBPlatformConnectOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatformConnectOptions_1GetURL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatformConnectOptions *arg1 = (lldb::SBPlatformConnectOptions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1; 
  result = (char *)(arg1)->GetURL();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformConnectOptions_1SetURL(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBPlatformConnectOptions *arg1 = (lldb::SBPlatformConnectOptions *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetURL((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBPlatformConnectOptions_1GetRsyncEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBPlatformConnectOptions *arg1 = (lldb::SBPlatformConnectOptions *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1; 
  result = (bool)(arg1)->GetRsyncEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformConnectOptions_1EnableRsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jboolean jarg4) {
  lldb::SBPlatformConnectOptions *arg1 = (lldb::SBPlatformConnectOptions *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = jarg4 ? true : false; 
  (arg1)->EnableRsync((char const *)arg2,(char const *)arg3,arg4);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformConnectOptions_1DisableRsync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBPlatformConnectOptions *arg1 = (lldb::SBPlatformConnectOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1; 
  (arg1)->DisableRsync();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatformConnectOptions_1GetLocalCacheDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatformConnectOptions *arg1 = (lldb::SBPlatformConnectOptions *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1; 
  result = (char *)(arg1)->GetLocalCacheDirectory();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformConnectOptions_1SetLocalCacheDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBPlatformConnectOptions *arg1 = (lldb::SBPlatformConnectOptions *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformConnectOptions **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetLocalCacheDirectory((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBPlatformShellCommand_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBPlatformShellCommand *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (lldb::SBPlatformShellCommand *)new lldb::SBPlatformShellCommand((char const *)arg1,(char const *)arg2);
  *(lldb::SBPlatformShellCommand **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBPlatformShellCommand_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::SBPlatformShellCommand *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (lldb::SBPlatformShellCommand *)new lldb::SBPlatformShellCommand((char const *)arg1);
  *(lldb::SBPlatformShellCommand **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBPlatformShellCommand_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBPlatformShellCommand *arg1 = 0 ;
  lldb::SBPlatformShellCommand *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBPlatformShellCommand const & reference is null");
    return 0;
  } 
  result = (lldb::SBPlatformShellCommand *)new lldb::SBPlatformShellCommand((lldb::SBPlatformShellCommand const &)*arg1);
  *(lldb::SBPlatformShellCommand **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBPlatformShellCommand(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1GetShell(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  result = (char *)(arg1)->GetShell();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1SetShell(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetShell((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1GetCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  result = (char *)(arg1)->GetCommand();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1SetCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetCommand((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1GetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  result = (char *)(arg1)->GetWorkingDirectory();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1SetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetWorkingDirectory((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1GetTimeoutSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  result = (uint32_t)(arg1)->GetTimeoutSeconds();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1SetTimeoutSeconds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  (arg1)->SetTimeoutSeconds(arg2);
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1GetSignal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  result = (int)(arg1)->GetSignal();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1GetStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  result = (int)(arg1)->GetStatus();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatformShellCommand_1GetOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatformShellCommand *arg1 = (lldb::SBPlatformShellCommand *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatformShellCommand **)&jarg1; 
  result = (char *)(arg1)->GetOutput();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBPlatform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBPlatform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBPlatform *)new lldb::SBPlatform();
  *(lldb::SBPlatform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBPlatform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  lldb::SBPlatform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (lldb::SBPlatform *)new lldb::SBPlatform((char const *)arg1);
  *(lldb::SBPlatform **)&jresult = result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBPlatform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetHostPlatform(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBPlatform result;
  
  (void)jenv;
  (void)jcls;
  result = lldb::SBPlatform::GetHostPlatform();
  *(lldb::SBPlatform **)&jresult = new lldb::SBPlatform((const lldb::SBPlatform &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBPlatform_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (bool)((lldb::SBPlatform const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatform_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (char *)(arg1)->GetWorkingDirectory();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBPlatform_1SetWorkingDirectory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *arg2 = (char *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (bool)(arg1)->SetWorkingDirectory((char const *)arg2);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (char *)(arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1ConnectRemote(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::SBPlatformConnectOptions *arg2 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = *(lldb::SBPlatformConnectOptions **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBPlatformConnectOptions & reference is null");
    return 0;
  } 
  result = (arg1)->ConnectRemote(*arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatform_1DisconnectRemote(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  (arg1)->DisconnectRemote();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBPlatform_1IsConnected(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (bool)(arg1)->IsConnected();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetTriple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (char *)(arg1)->GetTriple();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetHostname(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (char *)(arg1)->GetHostname();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetOSBuild(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (char *)(arg1)->GetOSBuild();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetOSDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (char *)(arg1)->GetOSDescription();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetOSMajorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (uint32_t)(arg1)->GetOSMajorVersion();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetOSMinorVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (uint32_t)(arg1)->GetOSMinorVersion();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetOSUpdateVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (uint32_t)(arg1)->GetOSUpdateVersion();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBPlatform_1SetSDKRoot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->SetSDKRoot((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1Get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBFileSpec *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBFileSpec **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  result = (arg1)->Get(*arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1Put(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBFileSpec *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBFileSpec **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  result = (arg1)->Put(*arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1Install(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBFileSpec *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBFileSpec **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  result = (arg1)->Install(*arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1Run(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::SBPlatformShellCommand *arg2 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = *(lldb::SBPlatformShellCommand **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBPlatformShellCommand & reference is null");
    return 0;
  } 
  result = (arg1)->Run(*arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1Launch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::SBLaunchInfo *arg2 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = *(lldb::SBLaunchInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBLaunchInfo & reference is null");
    return 0;
  } 
  result = (arg1)->Launch(*arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1Kill(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::pid_t arg2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::pid_t const)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::pid_t const)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->Kill(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1MakeDirectory_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->MakeDirectory((char const *)arg2,arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1MakeDirectory_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->MakeDirectory((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetFilePermissions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (uint32_t)(arg1)->GetFilePermissions((char const *)arg2);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1SetFilePermissions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->SetFilePermissions((char const *)arg2,arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetUnixSignals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::SBUnixSignals result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (arg1)->GetUnixSignals();
  *(lldb::SBUnixSignals **)&jresult = new lldb::SBUnixSignals((const lldb::SBUnixSignals &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBPlatform_1GetEnvironment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBPlatform *arg1 = (lldb::SBPlatform *) 0 ;
  lldb::SBEnvironment result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBPlatform **)&jarg1; 
  result = (arg1)->GetEnvironment();
  *(lldb::SBEnvironment **)&jresult = new lldb::SBEnvironment((const lldb::SBEnvironment &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1eBroadcastBitStateChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBProcess::eBroadcastBitStateChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1eBroadcastBitInterrupt_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBProcess::eBroadcastBitInterrupt;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1eBroadcastBitSTDOUT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBProcess::eBroadcastBitSTDOUT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1eBroadcastBitSTDERR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBProcess::eBroadcastBitSTDERR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1eBroadcastBitProfileData_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBProcess::eBroadcastBitProfileData;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1eBroadcastBitStructuredData_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBProcess::eBroadcastBitStructuredData;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBProcess_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBProcess *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBProcess *)new lldb::SBProcess();
  *(lldb::SBProcess **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBProcess_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = 0 ;
  lldb::SBProcess *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBProcess const & reference is null");
    return 0;
  } 
  result = (lldb::SBProcess *)new lldb::SBProcess((lldb::SBProcess const &)*arg1);
  *(lldb::SBProcess **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBProcess(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcess_1GetBroadcasterClassName(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)lldb::SBProcess::GetBroadcasterClassName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcess_1GetPluginName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (char *)(arg1)->GetPluginName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcess_1GetShortPluginName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (char *)(arg1)->GetShortPluginName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBProcess_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (bool)((lldb::SBProcess const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = ((lldb::SBProcess const *)arg1)->GetTarget();
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1GetByteOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::ByteOrder result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (lldb::ByteOrder)((lldb::SBProcess const *)arg1)->GetByteOrder();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1PutSTDIN(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (arg1)->PutSTDIN((char const *)arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetSTDOUT(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = ((lldb::SBProcess const *)arg1)->GetSTDOUT(arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetSTDERR(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = ((lldb::SBProcess const *)arg1)->GetSTDERR(arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetAsyncProfileData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = ((lldb::SBProcess const *)arg1)->GetAsyncProfileData(arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBProcess_1ReportEventState_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  lldb::SBFile arg3 ;
  lldb::SBFile *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return ;
  } 
  argp3 = *(lldb::SBFile **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return ;
  }
  arg3 = *argp3; 
  ((lldb::SBProcess const *)arg1)->ReportEventState((lldb::SBEvent const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBProcess_1ReportEventState_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg3 ;
  lldb::FileSP *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return ;
  } 
  argp3 = *(lldb::FileSP **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg3 = *argp3; 
  ((lldb::SBProcess const *)arg1)->ReportEventState((lldb::SBEvent const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBProcess_1AppendEventStateReport(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBEvent *arg2 = 0 ;
  lldb::SBCommandReturnObject *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return ;
  } 
  arg3 = *(lldb::SBCommandReturnObject **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBCommandReturnObject & reference is null");
    return ;
  } 
  (arg1)->AppendEventStateReport((lldb::SBEvent const &)*arg2,*arg3);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1RemoteAttachToProcessWithID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::pid_t arg2 ;
  lldb::SBError *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::pid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::pid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = *(lldb::SBError **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->RemoteAttachToProcessWithID(arg2,*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1RemoteLaunch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jlong jarg8, jboolean jarg9, jlong jarg10, jobject jarg10_) {
  jboolean jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char **arg2 = (char **) 0 ;
  char **arg3 = (char **) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  char *arg6 = (char *) 0 ;
  char *arg7 = (char *) 0 ;
  uint32_t arg8 ;
  bool arg9 ;
  lldb::SBError *arg10 = 0 ;
  jint size2 ;
  jint size3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg10_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = (uint32_t)jarg8; 
  arg9 = jarg9 ? true : false; 
  arg10 = *(lldb::SBError **)&jarg10;
  if (!arg10) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->RemoteLaunch((char const **)arg2,(char const **)arg3,(char const *)arg4,(char const *)arg5,(char const *)arg6,(char const *)arg7,arg8,arg9,*arg10);
  jresult = (jboolean)result; 
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetNumThreads(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumThreads();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetThreadAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  size_t arg2 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (arg1)->GetThreadAtIndex(arg2);
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetThreadByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::tid_t arg2 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::tid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::tid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->GetThreadByID(arg2);
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetThreadByIndexID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t arg2 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetThreadByIndexID(arg2);
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetSelectedThread(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = ((lldb::SBProcess const *)arg1)->GetSelectedThread();
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1CreateOSPluginThread(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::tid_t arg2 ;
  lldb::addr_t arg3 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::tid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::tid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->CreateOSPluginThread(arg2,arg3);
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1SetSelectedThread(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBThread *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = *(lldb::SBThread **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBThread const & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->SetSelectedThread((lldb::SBThread const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1SetSelectedThreadByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jboolean jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::tid_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::tid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::tid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (bool)(arg1)->SetSelectedThreadByID(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1SetSelectedThreadByIndexID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (bool)(arg1)->SetSelectedThreadByIndexID(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetNumQueues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumQueues();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetQueueAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t arg2 ;
  lldb::SBQueue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetQueueAtIndex(arg2);
  *(lldb::SBQueue **)&jresult = new lldb::SBQueue((const lldb::SBQueue &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1GetState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::StateType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (lldb::StateType)(arg1)->GetState();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1GetExitStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (int)(arg1)->GetExitStatus();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcess_1GetExitDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (char *)(arg1)->GetExitDescription();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBProcess_1GetProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::pid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (lldb::pid_t)(arg1)->GetProcessID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetUniqueID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (uint32_t)(arg1)->GetUniqueID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetAddressByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (uint32_t)((lldb::SBProcess const *)arg1)->GetAddressByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1Destroy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->Destroy();
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1Continue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->Continue();
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1Stop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->Stop();
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1Kill(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->Kill();
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1Detach(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->Detach();
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1Signal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  int arg2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (arg1)->Signal(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetUnixSignals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBUnixSignals result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->GetUnixSignals();
  *(lldb::SBUnixSignals **)&jresult = new lldb::SBUnixSignals((const lldb::SBUnixSignals &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetStopID_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  bool arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (uint32_t)(arg1)->GetStopID(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetStopID_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (uint32_t)(arg1)->GetStopID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBProcess_1SendAsyncInterrupt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  (arg1)->SendAsyncInterrupt();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1ReadMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::addr_t arg2 ;
  void *arg3 = (void *) 0 ;
  size_t arg4 ;
  lldb::SBError *arg5 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = *(void **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = *(lldb::SBError **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->ReadMemory(arg2,arg3,arg4,*arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1WriteMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::addr_t arg2 ;
  void *arg3 = (void *) 0 ;
  size_t arg4 ;
  lldb::SBError *arg5 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = *(void **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = *(lldb::SBError **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->WriteMemory(arg2,(void const *)arg3,arg4,*arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1ReadCStringFromMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::addr_t arg2 ;
  void *arg3 = (void *) 0 ;
  size_t arg4 ;
  lldb::SBError *arg5 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = *(void **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = *(lldb::SBError **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->ReadCStringFromMemory(arg2,arg3,arg4,*arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBProcess_1ReadUnsignedFromMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jobject jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::addr_t arg2 ;
  uint32_t arg3 ;
  lldb::SBError *arg4 = 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = *(lldb::SBError **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (uint64_t)(arg1)->ReadUnsignedFromMemory(arg2,arg3,*arg4);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBProcess_1ReadPointerFromMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  jobject jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBError *arg3 = 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = *(lldb::SBError **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (lldb::addr_t)(arg1)->ReadPointerFromMemory(arg2,*arg3);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBProcess_1GetStateFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::StateType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (lldb::StateType)lldb::SBProcess::GetStateFromEvent((lldb::SBEvent const &)*arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1GetRestartedFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)lldb::SBProcess::GetRestartedFromEvent((lldb::SBEvent const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetNumRestartedReasonsFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBProcess::GetNumRestartedReasonsFromEvent((lldb::SBEvent const &)*arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcess_1GetRestartedReasonAtIndexFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  size_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  arg2 = (size_t)jarg2; 
  result = (char *)lldb::SBProcess::GetRestartedReasonAtIndexFromEvent((lldb::SBEvent const &)*arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetProcessFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBProcess::GetProcessFromEvent((lldb::SBEvent const &)*arg1);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1GetInterruptedFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)lldb::SBProcess::GetInterruptedFromEvent((lldb::SBEvent const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetStructuredDataFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBProcess::GetStructuredDataFromEvent((lldb::SBEvent const &)*arg1);
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1EventIsProcessEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)lldb::SBProcess::EventIsProcessEvent((lldb::SBEvent const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1EventIsStructuredDataEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)lldb::SBProcess::EventIsStructuredDataEvent((lldb::SBEvent const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBBroadcaster result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = ((lldb::SBProcess const *)arg1)->GetBroadcaster();
  *(lldb::SBBroadcaster **)&jresult = new lldb::SBBroadcaster((const lldb::SBBroadcaster &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetExtendedCrashInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->GetExtendedCrashInformation();
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetNumSupportedHardwareWatchpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBError *arg2 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (uint32_t)((lldb::SBProcess const *)arg1)->GetNumSupportedHardwareWatchpoints(*arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1LoadImage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBError *arg3 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBError **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (uint32_t)(arg1)->LoadImage(*arg2,*arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1LoadImageUsingPaths(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBStringList *arg3 = 0 ;
  lldb::SBFileSpec *arg4 = 0 ;
  lldb::SBError *arg5 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBStringList **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBFileSpec **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg5 = *(lldb::SBError **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (uint32_t)(arg1)->LoadImageUsingPaths((lldb::SBFileSpec const &)*arg2,*arg3,*arg4,*arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1UnloadImage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t arg2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->UnloadImage(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1SendEventData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->SendEventData((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetNumExtendedBacktraceTypes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumExtendedBacktraceTypes();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcess_1GetExtendedBacktraceTypeAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  uint32_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (char *)(arg1)->GetExtendedBacktraceTypeAtIndex(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetHistoryThreads(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBThreadCollection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->GetHistoryThreads(arg2);
  *(lldb::SBThreadCollection **)&jresult = new lldb::SBThreadCollection((const lldb::SBThreadCollection &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcess_1IsInstrumentationRuntimePresent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::InstrumentationRuntimeType arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (lldb::InstrumentationRuntimeType)jarg2; 
  result = (bool)(arg1)->IsInstrumentationRuntimePresent(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1SaveCore_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SaveCoreStyle arg4 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (lldb::SaveCoreStyle)jarg4; 
  result = (arg1)->SaveCore((char const *)arg2,(char const *)arg3,arg4);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1SaveCore_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->SaveCore((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetMemoryRegionInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBMemoryRegionInfo *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = *(lldb::SBMemoryRegionInfo **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBMemoryRegionInfo & reference is null");
    return 0;
  } 
  result = (arg1)->GetMemoryRegionInfo(arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetMemoryRegions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBMemoryRegionInfoList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->GetMemoryRegions();
  *(lldb::SBMemoryRegionInfoList **)&jresult = new lldb::SBMemoryRegionInfoList((const lldb::SBMemoryRegionInfoList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1GetProcessInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::SBProcessInfo result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = (arg1)->GetProcessInfo();
  *(lldb::SBProcessInfo **)&jresult = new lldb::SBProcessInfo((const lldb::SBProcessInfo &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBProcess_1AllocateMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jobject jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  size_t arg2 ;
  uint32_t arg3 ;
  lldb::SBError *arg4 = 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = *(lldb::SBError **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (lldb::addr_t)(arg1)->AllocateMemory(arg2,arg3,*arg4);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcess_1DeallocateMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->DeallocateMemory(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcess_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBProcess *arg1 = (lldb::SBProcess *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcess **)&jarg1; 
  result = lldb_SBProcess___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBProcessInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBProcessInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBProcessInfo *)new lldb::SBProcessInfo();
  *(lldb::SBProcessInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBProcessInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcessInfo *arg1 = 0 ;
  lldb::SBProcessInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBProcessInfo const & reference is null");
    return 0;
  } 
  result = (lldb::SBProcessInfo *)new lldb::SBProcessInfo((lldb::SBProcessInfo const &)*arg1);
  *(lldb::SBProcessInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBProcessInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (bool)(arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (char *)(arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetExecutableFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (arg1)->GetExecutableFile();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  lldb::pid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (lldb::pid_t)(arg1)->GetProcessID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetUserID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetUserID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetGroupID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetGroupID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1UserIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (bool)(arg1)->UserIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GroupIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (bool)(arg1)->GroupIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetEffectiveUserID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetEffectiveUserID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetEffectiveGroupID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (uint32_t)(arg1)->GetEffectiveGroupID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1EffectiveUserIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (bool)(arg1)->EffectiveUserIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1EffectiveGroupIDIsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (bool)(arg1)->EffectiveGroupIDIsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetParentProcessID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  lldb::pid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (lldb::pid_t)(arg1)->GetParentProcessID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBProcessInfo_1GetTriple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBProcessInfo *arg1 = (lldb::SBProcessInfo *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBProcessInfo **)&jarg1; 
  result = (char *)(arg1)->GetTriple();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBQueue_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBQueue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBQueue *)new lldb::SBQueue();
  *(lldb::SBQueue **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBQueue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  lldb::QueueSP *arg1 = 0 ;
  lldb::SBQueue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::QueueSP **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::QueueSP const & reference is null");
    return 0;
  } 
  result = (lldb::SBQueue *)new lldb::SBQueue((lldb::QueueSP const &)*arg1);
  *(lldb::SBQueue **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBQueue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBQueue_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (bool)((lldb::SBQueue const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBQueue_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueue_1GetProcess(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (arg1)->GetProcess();
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBQueue_1GetQueueID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  lldb::queue_id_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (lldb::queue_id_t)((lldb::SBQueue const *)arg1)->GetQueueID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBQueue_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (char *)((lldb::SBQueue const *)arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBQueue_1GetKind(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  lldb::QueueKind result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (lldb::QueueKind)(arg1)->GetKind();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueue_1GetIndexID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (uint32_t)((lldb::SBQueue const *)arg1)->GetIndexID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueue_1GetNumThreads(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumThreads();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueue_1GetThreadAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  uint32_t arg2 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetThreadAtIndex(arg2);
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueue_1GetNumPendingItems(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumPendingItems();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueue_1GetPendingItemAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  uint32_t arg2 ;
  lldb::SBQueueItem result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetPendingItemAtIndex(arg2);
  *(lldb::SBQueueItem **)&jresult = new lldb::SBQueueItem((const lldb::SBQueueItem &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueue_1GetNumRunningItems(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBQueue *arg1 = (lldb::SBQueue *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueue **)&jarg1; 
  result = (uint32_t)(arg1)->GetNumRunningItems();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBQueueItem_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBQueueItem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBQueueItem *)new lldb::SBQueueItem();
  *(lldb::SBQueueItem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBQueueItem_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  lldb::QueueItemSP *arg1 = 0 ;
  lldb::SBQueueItem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::QueueItemSP **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::QueueItemSP const & reference is null");
    return 0;
  } 
  result = (lldb::SBQueueItem *)new lldb::SBQueueItem((lldb::QueueItemSP const &)*arg1);
  *(lldb::SBQueueItem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBQueueItem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBQueueItem_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  result = (bool)((lldb::SBQueueItem const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBQueueItem_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBQueueItem_1GetKind(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  lldb::QueueItemKind result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  result = (lldb::QueueItemKind)((lldb::SBQueueItem const *)arg1)->GetKind();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBQueueItem_1SetKind(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  lldb::QueueItemKind arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  arg2 = (lldb::QueueItemKind)jarg2; 
  (arg1)->SetKind(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueueItem_1GetAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  result = ((lldb::SBQueueItem const *)arg1)->GetAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBQueueItem_1SetAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  lldb::SBAddress arg2 ;
  lldb::SBAddress *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  argp2 = *(lldb::SBAddress **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBAddress");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetAddress(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBQueueItem_1SetQueueItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  lldb::QueueItemSP *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  arg2 = *(lldb::QueueItemSP **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::QueueItemSP const & reference is null");
    return ;
  } 
  (arg1)->SetQueueItem((lldb::QueueItemSP const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBQueueItem_1GetExtendedBacktraceThread(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBQueueItem *arg1 = (lldb::SBQueueItem *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBQueueItem **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->GetExtendedBacktraceThread((char const *)arg2);
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBReproducer_1Capture(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)lldb::SBReproducer::Capture((char const *)arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBReproducer_1PassiveReplay(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jstring jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (char *)lldb::SBReproducer::PassiveReplay((char const *)arg1);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBReproducer_1SetAutoGenerate(JNIEnv *jenv, jclass jcls, jboolean jarg1) {
  jboolean jresult = 0 ;
  bool arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1 ? true : false; 
  result = (bool)lldb::SBReproducer::SetAutoGenerate(arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBReproducer_1SetWorkingDirectory(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  lldb::SBReproducer::SetWorkingDirectory((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBReproducer(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBReproducer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBReproducer *)new lldb::SBReproducer();
  *(lldb::SBReproducer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBReproducer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBReproducer *arg1 = (lldb::SBReproducer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBReproducer **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSection_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBSection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBSection *)new lldb::SBSection();
  *(lldb::SBSection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSection_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = 0 ;
  lldb::SBSection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBSection const & reference is null");
    return 0;
  } 
  result = (lldb::SBSection *)new lldb::SBSection((lldb::SBSection const &)*arg1);
  *(lldb::SBSection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBSection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBSection **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSection_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (bool)((lldb::SBSection const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBSection_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (char *)(arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1GetParent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  lldb::SBSection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (arg1)->GetParent();
  *(lldb::SBSection **)&jresult = new lldb::SBSection((const lldb::SBSection &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1FindSubSection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBSection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindSubSection((char const *)arg2);
  *(lldb::SBSection **)&jresult = new lldb::SBSection((const lldb::SBSection &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1GetNumSubSections(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (arg1)->GetNumSubSections();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1GetSubSectionAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  size_t arg2 ;
  lldb::SBSection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (arg1)->GetSubSectionAtIndex(arg2);
  *(lldb::SBSection **)&jresult = new lldb::SBSection((const lldb::SBSection &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBSection_1GetFileAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (lldb::addr_t)(arg1)->GetFileAddress();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBSection_1GetLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  lldb::SBTarget *arg2 = 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  arg2 = *(lldb::SBTarget **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget & reference is null");
    return 0;
  } 
  result = (lldb::addr_t)(arg1)->GetLoadAddress(*arg2);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBSection_1GetByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (lldb::addr_t)(arg1)->GetByteSize();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBSection_1GetFileOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (uint64_t)(arg1)->GetFileOffset();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBSection_1GetFileByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (uint64_t)(arg1)->GetFileByteSize();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1GetSectionData_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (arg1)->GetSectionData();
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1GetSectionData_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  uint64_t arg2 ;
  uint64_t arg3 ;
  lldb::SBData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (uint64_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (uint64_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (uint64_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->GetSectionData(arg2,arg3);
  *(lldb::SBData **)&jresult = new lldb::SBData((const lldb::SBData &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBSection_1GetSectionType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  lldb::SectionType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (lldb::SectionType)(arg1)->GetSectionType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1GetPermissions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (uint32_t)((lldb::SBSection const *)arg1)->GetPermissions();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1GetTargetByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (uint32_t)(arg1)->GetTargetByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSection_1GetAlignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = (uint32_t)(arg1)->GetAlignment();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSection_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBSection_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBSection *arg1 = (lldb::SBSection *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSection **)&jarg1; 
  result = lldb_SBSection___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSourceManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSourceManager *arg1 = 0 ;
  lldb::SBSourceManager *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSourceManager **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBSourceManager const & reference is null");
    return 0;
  } 
  result = (lldb::SBSourceManager *)new lldb::SBSourceManager((lldb::SBSourceManager const &)*arg1);
  *(lldb::SBSourceManager **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBSourceManager(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBSourceManager *arg1 = (lldb::SBSourceManager *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBSourceManager **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSourceManager_1DisplaySourceLinesWithLineNumbers(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jlong jarg5, jstring jarg6, jlong jarg7, jobject jarg7_) {
  jlong jresult = 0 ;
  lldb::SBSourceManager *arg1 = (lldb::SBSourceManager *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  uint32_t arg5 ;
  char *arg6 = (char *) 0 ;
  lldb::SBStream *arg7 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg7_;
  arg1 = *(lldb::SBSourceManager **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  arg5 = (uint32_t)jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = *(lldb::SBStream **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (arg1)->DisplaySourceLinesWithLineNumbers((lldb::SBFileSpec const &)*arg2,arg3,arg4,arg5,(char const *)arg6,*arg7);
  jresult = (jlong)result; 
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSourceManager_1DisplaySourceLinesWithLineNumbersAndColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jstring jarg7, jlong jarg8, jobject jarg8_) {
  jlong jresult = 0 ;
  lldb::SBSourceManager *arg1 = (lldb::SBSourceManager *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  uint32_t arg5 ;
  uint32_t arg6 ;
  char *arg7 = (char *) 0 ;
  lldb::SBStream *arg8 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg8_;
  arg1 = *(lldb::SBSourceManager **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  arg5 = (uint32_t)jarg5; 
  arg6 = (uint32_t)jarg6; 
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = *(lldb::SBStream **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (arg1)->DisplaySourceLinesWithLineNumbersAndColumn((lldb::SBFileSpec const &)*arg2,arg3,arg4,arg5,arg6,(char const *)arg7,*arg8);
  jresult = (jlong)result; 
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBStream(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBStream *)new lldb::SBStream();
  *(lldb::SBStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBStream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBStream **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBStream_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  result = (bool)((lldb::SBStream const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBStream_1GetData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  result = (char *)(arg1)->GetData();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStream_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  result = (arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStream_1Print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->Print((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStream_1RedirectToFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jboolean jarg3) {
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  char *arg2 = (char *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = jarg3 ? true : false; 
  (arg1)->RedirectToFile((char const *)arg2,arg3);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStream_1RedirectToFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  lldb::SBFile arg2 ;
  lldb::SBFile *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  argp2 = *(lldb::SBFile **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFile");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->RedirectToFile(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStream_1RedirectToFile_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  lldb::FileSP *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->RedirectToFile(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStream_1RedirectToFileHandle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  SwigValueWrapper< std::shared_ptr< lldb_private::File > > arg2 ;
  bool arg3 ;
  lldb::FileSP *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  argp2 = *(lldb::FileSP **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::FileSP");
    return ;
  }
  arg2 = *argp2; 
  arg3 = jarg3 ? true : false; 
  lldb_SBStream_RedirectToFileHandle(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStream_1RedirectToFileDescriptor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  int arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  (arg1)->RedirectToFileDescriptor(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStream_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBStream *arg1 = (lldb::SBStream *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStream **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBStringList_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBStringList *)new lldb::SBStringList();
  *(lldb::SBStringList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBStringList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBStringList *arg1 = 0 ;
  lldb::SBStringList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStringList **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList const & reference is null");
    return 0;
  } 
  result = (lldb::SBStringList *)new lldb::SBStringList((lldb::SBStringList const &)*arg1);
  *(lldb::SBStringList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBStringList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBStringList *arg1 = (lldb::SBStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBStringList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBStringList_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBStringList *arg1 = (lldb::SBStringList *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStringList **)&jarg1; 
  result = (bool)((lldb::SBStringList const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStringList_1AppendString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBStringList *arg1 = (lldb::SBStringList *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStringList **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->AppendString((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStringList_1AppendList_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  lldb::SBStringList *arg1 = (lldb::SBStringList *) 0 ;
  char **arg2 = (char **) 0 ;
  int arg3 ;
  jint size2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStringList **)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  arg3 = (int)jarg3; 
  (arg1)->AppendList((char const **)arg2,arg3);
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStringList_1AppendList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBStringList *arg1 = (lldb::SBStringList *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBStringList **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList const & reference is null");
    return ;
  } 
  (arg1)->AppendList((lldb::SBStringList const &)*arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStringList_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBStringList *arg1 = (lldb::SBStringList *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStringList **)&jarg1; 
  result = (uint32_t)((lldb::SBStringList const *)arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBStringList_1GetStringAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  lldb::SBStringList *arg1 = (lldb::SBStringList *) 0 ;
  size_t arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStringList **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = (char *)(arg1)->GetStringAtIndex(arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStringList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBStringList *arg1 = (lldb::SBStringList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStringList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBStructuredData_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBStructuredData *)new lldb::SBStructuredData();
  *(lldb::SBStructuredData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBStructuredData_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = 0 ;
  lldb::SBStructuredData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStructuredData const & reference is null");
    return 0;
  } 
  result = (lldb::SBStructuredData *)new lldb::SBStructuredData((lldb::SBStructuredData const &)*arg1);
  *(lldb::SBStructuredData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBStructuredData_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  lldb::EventSP *arg1 = 0 ;
  lldb::SBStructuredData *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::EventSP **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::EventSP const & reference is null");
    return 0;
  } 
  result = (lldb::SBStructuredData *)new lldb::SBStructuredData((lldb::EventSP const &)*arg1);
  *(lldb::SBStructuredData **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBStructuredData(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBStructuredData_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  result = (bool)((lldb::SBStructuredData const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBStructuredData_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  lldb::StructuredDataType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  result = (lldb::StructuredDataType)((lldb::SBStructuredData const *)arg1)->GetType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  result = ((lldb::SBStructuredData const *)arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetKeys(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  result = (bool)((lldb::SBStructuredData const *)arg1)->GetKeys(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetValueForKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = ((lldb::SBStructuredData const *)arg1)->GetValueForKey((char const *)arg2);
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetItemAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  size_t arg2 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = ((lldb::SBStructuredData const *)arg1)->GetItemAtIndex(arg2);
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetIntegerValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  uint64_t arg2 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (uint64_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (uint64_t)((lldb::SBStructuredData const *)arg1)->GetIntegerValue(arg2);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetIntegerValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  result = (uint64_t)((lldb::SBStructuredData const *)arg1)->GetIntegerValue();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetFloatValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)((lldb::SBStructuredData const *)arg1)->GetFloatValue(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetFloatValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  result = (double)((lldb::SBStructuredData const *)arg1)->GetFloatValue();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetBooleanValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jboolean jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  bool arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (bool)((lldb::SBStructuredData const *)arg1)->GetBooleanValue(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetBooleanValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  result = (bool)((lldb::SBStructuredData const *)arg1)->GetBooleanValue();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetStringValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = ((lldb::SBStructuredData const *)arg1)->GetStringValue(arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetAsJSON(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = ((lldb::SBStructuredData const *)arg1)->GetAsJSON(*arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStructuredData_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = ((lldb::SBStructuredData const *)arg1)->GetDescription(*arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStructuredData_1SetFromJSON_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (arg1)->SetFromJSON(*arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBStructuredData_1SetFromJSON_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBStructuredData *arg1 = (lldb::SBStructuredData *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBStructuredData **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->SetFromJSON((char const *)arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSymbol_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBSymbol *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBSymbol *)new lldb::SBSymbol();
  *(lldb::SBSymbol **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSymbol_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbol *arg1 = 0 ;
  lldb::SBSymbol *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBSymbol const & reference is null");
    return 0;
  } 
  result = (lldb::SBSymbol *)new lldb::SBSymbol((lldb::SBSymbol const &)*arg1);
  *(lldb::SBSymbol **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSymbol_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (bool)((lldb::SBSymbol const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (char *)((lldb::SBSymbol const *)arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetDisplayName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (char *)((lldb::SBSymbol const *)arg1)->GetDisplayName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetMangledName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (char *)((lldb::SBSymbol const *)arg1)->GetMangledName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetInstructions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  lldb::SBTarget arg2 ;
  lldb::SBTarget *argp2 ;
  lldb::SBInstructionList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->GetInstructions(arg2);
  *(lldb::SBInstructionList **)&jresult = new lldb::SBInstructionList((const lldb::SBInstructionList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetInstructions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  lldb::SBTarget arg2 ;
  char *arg3 = (char *) 0 ;
  lldb::SBTarget *argp2 ;
  lldb::SBInstructionList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  argp2 = *(lldb::SBTarget **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBTarget");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->GetInstructions(arg2,(char const *)arg3);
  *(lldb::SBInstructionList **)&jresult = new lldb::SBInstructionList((const lldb::SBInstructionList &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetStartAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (arg1)->GetStartAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetEndAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (arg1)->GetEndAddress();
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (uint64_t)(arg1)->GetValue();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (uint64_t)(arg1)->GetSize();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetPrologueByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (uint32_t)(arg1)->GetPrologueByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  lldb::SymbolType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (lldb::SymbolType)(arg1)->GetType();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSymbol_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSymbol_1IsExternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (bool)(arg1)->IsExternal();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSymbol_1IsSynthetic(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = (bool)(arg1)->IsSynthetic();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBSymbol_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBSymbol *arg1 = (lldb::SBSymbol *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbol **)&jarg1; 
  result = lldb_SBSymbol___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSymbolContext_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBSymbolContext *)new lldb::SBSymbolContext();
  *(lldb::SBSymbolContext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSymbolContext_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *arg1 = 0 ;
  lldb::SBSymbolContext *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBSymbolContext const & reference is null");
    return 0;
  } 
  result = (lldb::SBSymbolContext *)new lldb::SBSymbolContext((lldb::SBSymbolContext const &)*arg1);
  *(lldb::SBSymbolContext **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBSymbolContext(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  result = (bool)((lldb::SBSymbolContext const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1GetModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  result = (arg1)->GetModule();
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1GetCompileUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBCompileUnit result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  result = (arg1)->GetCompileUnit();
  *(lldb::SBCompileUnit **)&jresult = new lldb::SBCompileUnit((const lldb::SBCompileUnit &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1GetFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBFunction result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  result = (arg1)->GetFunction();
  *(lldb::SBFunction **)&jresult = new lldb::SBFunction((const lldb::SBFunction &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1GetBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBBlock result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  result = (arg1)->GetBlock();
  *(lldb::SBBlock **)&jresult = new lldb::SBBlock((const lldb::SBBlock &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1GetLineEntry(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBLineEntry result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  result = (arg1)->GetLineEntry();
  *(lldb::SBLineEntry **)&jresult = new lldb::SBLineEntry((const lldb::SBLineEntry &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1GetSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBSymbol result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  result = (arg1)->GetSymbol();
  *(lldb::SBSymbol **)&jresult = new lldb::SBSymbol((const lldb::SBSymbol &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1SetModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBModule arg2 ;
  lldb::SBModule *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  argp2 = *(lldb::SBModule **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBModule");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetModule(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1SetCompileUnit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBCompileUnit arg2 ;
  lldb::SBCompileUnit *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  argp2 = *(lldb::SBCompileUnit **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBCompileUnit");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetCompileUnit(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1SetFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBFunction arg2 ;
  lldb::SBFunction *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  argp2 = *(lldb::SBFunction **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBFunction");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetFunction(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1SetBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBBlock arg2 ;
  lldb::SBBlock *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  argp2 = *(lldb::SBBlock **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBBlock");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetBlock(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1SetLineEntry(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBLineEntry arg2 ;
  lldb::SBLineEntry *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  argp2 = *(lldb::SBLineEntry **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBLineEntry");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetLineEntry(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1SetSymbol(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBSymbol arg2 ;
  lldb::SBSymbol *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  argp2 = *(lldb::SBSymbol **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBSymbol");
    return ;
  }
  arg2 = *argp2; 
  (arg1)->SetSymbol(arg2);
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1GetParentOfInlinedScope(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBAddress *arg2 = 0 ;
  lldb::SBAddress *arg3 = 0 ;
  lldb::SBSymbolContext result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  arg2 = *(lldb::SBAddress **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress const & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBAddress **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress & reference is null");
    return 0;
  } 
  result = ((lldb::SBSymbolContext const *)arg1)->GetParentOfInlinedScope((lldb::SBAddress const &)*arg2,*arg3);
  *(lldb::SBSymbolContext **)&jresult = new lldb::SBSymbolContext((const lldb::SBSymbolContext &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBSymbolContext_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBSymbolContext *arg1 = (lldb::SBSymbolContext *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContext **)&jarg1; 
  result = lldb_SBSymbolContext___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSymbolContextList_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBSymbolContextList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBSymbolContextList *)new lldb::SBSymbolContextList();
  *(lldb::SBSymbolContextList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBSymbolContextList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContextList *arg1 = 0 ;
  lldb::SBSymbolContextList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBSymbolContextList const & reference is null");
    return 0;
  } 
  result = (lldb::SBSymbolContextList *)new lldb::SBSymbolContextList((lldb::SBSymbolContextList const &)*arg1);
  *(lldb::SBSymbolContextList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBSymbolContextList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSymbolContextList_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  result = (bool)((lldb::SBSymbolContextList const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContextList_1GetSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  result = (uint32_t)((lldb::SBSymbolContextList const *)arg1)->GetSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBSymbolContextList_1GetContextAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  uint32_t arg2 ;
  lldb::SBSymbolContext result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetContextAtIndex(arg2);
  *(lldb::SBSymbolContext **)&jresult = new lldb::SBSymbolContext((const lldb::SBSymbolContext &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContextList_1Append_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  lldb::SBSymbolContext *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  arg2 = *(lldb::SBSymbolContext **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBSymbolContext & reference is null");
    return ;
  } 
  (arg1)->Append(*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContextList_1Append_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  lldb::SBSymbolContextList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  arg2 = *(lldb::SBSymbolContextList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBSymbolContextList & reference is null");
    return ;
  } 
  (arg1)->Append(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBSymbolContextList_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetDescription(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBSymbolContextList_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBSymbolContextList_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBSymbolContextList *arg1 = (lldb::SBSymbolContextList *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBSymbolContextList **)&jarg1; 
  result = lldb_SBSymbolContextList___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBTarget_1eBroadcastBitBreakpointChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBTarget::eBroadcastBitBreakpointChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBTarget_1eBroadcastBitModulesLoaded_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBTarget::eBroadcastBitModulesLoaded;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBTarget_1eBroadcastBitModulesUnloaded_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBTarget::eBroadcastBitModulesUnloaded;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBTarget_1eBroadcastBitWatchpointChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBTarget::eBroadcastBitWatchpointChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBTarget_1eBroadcastBitSymbolsLoaded_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBTarget::eBroadcastBitSymbolsLoaded;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBTarget_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBTarget *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBTarget *)new lldb::SBTarget();
  *(lldb::SBTarget **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBTarget_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = 0 ;
  lldb::SBTarget *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBTarget const & reference is null");
    return 0;
  } 
  result = (lldb::SBTarget *)new lldb::SBTarget((lldb::SBTarget const &)*arg1);
  *(lldb::SBTarget **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBTarget(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBTarget_1GetBroadcasterClassName(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)lldb::SBTarget::GetBroadcasterClassName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (bool)((lldb::SBTarget const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1EventIsTargetEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)lldb::SBTarget::EventIsTargetEvent((lldb::SBEvent const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetTargetFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::SBTarget result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBTarget::GetTargetFromEvent((lldb::SBEvent const &)*arg1);
  *(lldb::SBTarget **)&jresult = new lldb::SBTarget((const lldb::SBTarget &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetNumModulesFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (uint32_t)lldb::SBTarget::GetNumModulesFromEvent((lldb::SBEvent const &)*arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetModuleAtIndexFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  lldb::SBEvent *arg2 = 0 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (uint32_t)jarg1; 
  arg2 = *(lldb::SBEvent **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBTarget::GetModuleAtIndexFromEvent(arg1,(lldb::SBEvent const &)*arg2);
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetProcess(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (arg1)->GetProcess();
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetPlatform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBPlatform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (arg1)->GetPlatform();
  *(lldb::SBPlatform **)&jresult = new lldb::SBPlatform((const lldb::SBPlatform &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1Install(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (arg1)->Install();
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1Launch_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobjectArray jarg3, jobjectArray jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jstring jarg8, jlong jarg9, jboolean jarg10, jlong jarg11, jobject jarg11_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  char **arg3 = (char **) 0 ;
  char **arg4 = (char **) 0 ;
  char *arg5 = (char *) 0 ;
  char *arg6 = (char *) 0 ;
  char *arg7 = (char *) 0 ;
  char *arg8 = (char *) 0 ;
  uint32_t arg9 ;
  bool arg10 ;
  lldb::SBError *arg11 = 0 ;
  jint size3 ;
  jint size4 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg11_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener & reference is null");
    return 0;
  } 
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  {
    int i = 0;
    if (jarg4) {
      size4 = jenv->GetArrayLength(jarg4);
      
      arg4 = new char*[size4+1];
      
      
      
      for (i = 0; i<size4; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg4, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg4[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg4[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg4[i] = 0;
    } else {
      arg4 = 0;
      size4 = 0;
    }
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = 0;
  if (jarg8) {
    arg8 = (char *)jenv->GetStringUTFChars(jarg8, 0);
    if (!arg8) return 0;
  }
  arg9 = (uint32_t)jarg9; 
  arg10 = jarg10 ? true : false; 
  arg11 = *(lldb::SBError **)&jarg11;
  if (!arg11) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->Launch(*arg2,(char const **)arg3,(char const **)arg4,(char const *)arg5,(char const *)arg6,(char const *)arg7,(char const *)arg8,arg9,arg10,*arg11);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  {
    int i;
    for (i=0; i<size4; i++)
    
    delete[] arg4[i];
    delete[] arg4;
    
    
    
    
  }
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  if (arg8) jenv->ReleaseStringUTFChars(jarg8, (const char *)arg8);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1LaunchSimple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char **arg2 = (char **) 0 ;
  char **arg3 = (char **) 0 ;
  char *arg4 = (char *) 0 ;
  jint size2 ;
  jint size3 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  {
    int i = 0;
    if (jarg3) {
      size3 = jenv->GetArrayLength(jarg3);
      
      arg3 = new char*[size3+1];
      
      
      
      for (i = 0; i<size3; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg3, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg3[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg3[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg3[i] = 0;
    } else {
      arg3 = 0;
      size3 = 0;
    }
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (arg1)->LaunchSimple((char const **)arg2,(char const **)arg3,(char const *)arg4);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
  {
    int i;
    for (i=0; i<size3; i++)
    
    delete[] arg3[i];
    delete[] arg3;
    
    
    
    
  }
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1Launch_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBLaunchInfo *arg2 = 0 ;
  lldb::SBError *arg3 = 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBLaunchInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBLaunchInfo & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBError **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->Launch(*arg2,*arg3);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1LoadCore_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->LoadCore((char const *)arg2);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1LoadCore_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBError *arg3 = 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBError **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->LoadCore((char const *)arg2,*arg3);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1Attach(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBAttachInfo *arg2 = 0 ;
  lldb::SBError *arg3 = 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBAttachInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAttachInfo & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBError **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->Attach(*arg2,*arg3);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1AttachToProcessWithID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  lldb::pid_t arg3 ;
  lldb::SBError *arg4 = 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener & reference is null");
    return 0;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::pid_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::pid_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg4 = *(lldb::SBError **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->AttachToProcessWithID(*arg2,arg3,*arg4);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1AttachToProcessWithName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jboolean jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  bool arg4 ;
  lldb::SBError *arg5 = 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener & reference is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = jarg4 ? true : false; 
  arg5 = *(lldb::SBError **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->AttachToProcessWithName(*arg2,(char const *)arg3,arg4,*arg5);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ConnectRemote(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBListener *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  lldb::SBError *arg5 = 0 ;
  lldb::SBProcess result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBListener **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBListener & reference is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(lldb::SBError **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->ConnectRemote(*arg2,(char const *)arg3,(char const *)arg4,*arg5);
  *(lldb::SBProcess **)&jresult = new lldb::SBProcess((const lldb::SBProcess &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetExecutable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (arg1)->GetExecutable();
  *(lldb::SBFileSpec **)&jresult = new lldb::SBFileSpec((const lldb::SBFileSpec &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBTarget_1AppendImageSearchPath(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jlong jarg4, jobject jarg4_) {
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBError *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = *(lldb::SBError **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return ;
  } 
  (arg1)->AppendImageSearchPath((char const *)arg2,(char const *)arg3,*arg4);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1AddModule_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBModule *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBModule **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModule & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->AddModule(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1AddModule_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (arg1)->AddModule((char const *)arg2,(char const *)arg3,(char const *)arg4);
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1AddModule_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (arg1)->AddModule((char const *)arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1AddModule_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBModuleSpec *arg2 = 0 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBModuleSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModuleSpec const & reference is null");
    return 0;
  } 
  result = (arg1)->AddModule((lldb::SBModuleSpec const &)*arg2);
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetNumModules(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (uint32_t)((lldb::SBTarget const *)arg1)->GetNumModules();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetModuleAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t arg2 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (arg1)->GetModuleAtIndex(arg2);
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1RemoveModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBModule arg2 ;
  lldb::SBModule *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBModule **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBModule");
    return 0;
  }
  arg2 = *argp2; 
  result = (bool)(arg1)->RemoveModule(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetDebugger(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBDebugger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = ((lldb::SBTarget const *)arg1)->GetDebugger();
  *(lldb::SBDebugger **)&jresult = new lldb::SBDebugger((const lldb::SBDebugger &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBModule result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  result = (arg1)->FindModule((lldb::SBFileSpec const &)*arg2);
  *(lldb::SBModule **)&jresult = new lldb::SBModule((const lldb::SBModule &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindCompileUnits(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  result = (arg1)->FindCompileUnits((lldb::SBFileSpec const &)*arg2);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBTarget_1GetByteOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::ByteOrder result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (lldb::ByteOrder)(arg1)->GetByteOrder();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetAddressByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (uint32_t)(arg1)->GetAddressByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBTarget_1GetTriple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (char *)(arg1)->GetTriple();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBTarget_1GetABIName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (char *)(arg1)->GetABIName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetDataByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (uint32_t)(arg1)->GetDataByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetCodeByteSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (uint32_t)(arg1)->GetCodeByteSize();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetMaximumNumberOfChildrenToDisplay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (uint32_t)((lldb::SBTarget const *)arg1)->GetMaximumNumberOfChildrenToDisplay();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1SetSectionLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBSection arg2 ;
  lldb::addr_t arg3 ;
  lldb::SBSection *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBSection **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBSection");
    return 0;
  }
  arg2 = *argp2; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->SetSectionLoadAddress(arg2,arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ClearSectionLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBSection arg2 ;
  lldb::SBSection *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBSection **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBSection");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->ClearSectionLoadAddress(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1SetModuleLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBModule arg2 ;
  int64_t arg3 ;
  lldb::SBModule *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBModule **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBModule");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (int64_t)jarg3; 
  result = (arg1)->SetModuleLoadAddress(arg2,arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ClearModuleLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBModule arg2 ;
  lldb::SBModule *argp2 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBModule **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBModule");
    return 0;
  }
  arg2 = *argp2; 
  result = (arg1)->ClearModuleLoadAddress(arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindFunctions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->FindFunctions((char const *)arg2,arg3);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindFunctions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindFunctions((char const *)arg2);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindFirstType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindFirstType((char const *)arg2);
  *(lldb::SBType **)&jresult = new lldb::SBType((const lldb::SBType &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindTypes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBTypeList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindTypes((char const *)arg2);
  *(lldb::SBTypeList **)&jresult = new lldb::SBTypeList((const lldb::SBTypeList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetBasicType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::BasicType arg2 ;
  lldb::SBType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (lldb::BasicType)jarg2; 
  result = (arg1)->GetBasicType(arg2);
  *(lldb::SBType **)&jresult = new lldb::SBType((const lldb::SBType &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetSourceManager(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  SwigValueWrapper< lldb::SBSourceManager > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (arg1)->GetSourceManager();
  *(lldb::SBSourceManager **)&jresult = new lldb::SBSourceManager((const lldb::SBSourceManager &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindGlobalVariables_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->FindGlobalVariables((char const *)arg2,arg3);
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindFirstGlobalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindFirstGlobalVariable((char const *)arg2);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindGlobalVariables_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::MatchType arg4 ;
  lldb::SBValueList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = (lldb::MatchType)jarg4; 
  result = (arg1)->FindGlobalVariables((char const *)arg2,arg3,arg4);
  *(lldb::SBValueList **)&jresult = new lldb::SBValueList((const lldb::SBValueList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindGlobalFunctions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::MatchType arg4 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = (lldb::MatchType)jarg4; 
  result = (arg1)->FindGlobalFunctions((char const *)arg2,arg3,arg4);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBTarget_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ResolveFileAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->ResolveFileAddress(arg2);
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ResolveLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->ResolveLoadAddress(arg2);
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ResolvePastLoadAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t arg2 ;
  lldb::addr_t arg3 ;
  lldb::SBAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->ResolvePastLoadAddress(arg2,arg3);
  *(lldb::SBAddress **)&jresult = new lldb::SBAddress((const lldb::SBAddress &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ResolveSymbolContextForAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBAddress *arg2 = 0 ;
  uint32_t arg3 ;
  lldb::SBSymbolContext result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBAddress **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->ResolveSymbolContextForAddress((lldb::SBAddress const &)*arg2,arg3);
  *(lldb::SBSymbolContext **)&jresult = new lldb::SBSymbolContext((const lldb::SBSymbolContext &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ReadMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBAddress arg2 ;
  void *arg3 = (void *) 0 ;
  size_t arg4 ;
  lldb::SBError *arg5 = 0 ;
  lldb::SBAddress const *argp2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBAddress **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBAddress const");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = *(lldb::SBError **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->ReadMemory(arg2,arg3,arg4,*arg5);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByLocation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->BreakpointCreateByLocation((char const *)arg2,arg3);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByLocation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  uint32_t arg3 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->BreakpointCreateByLocation((lldb::SBFileSpec const &)*arg2,arg3);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByLocation_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  uint32_t arg3 ;
  lldb::addr_t arg4 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg4) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg4);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg4, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg4 = 0;
    if (sz > 0) {
      arg4 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg4 = (arg4 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->BreakpointCreateByLocation((lldb::SBFileSpec const &)*arg2,arg3,arg4);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByLocation_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  uint32_t arg3 ;
  lldb::addr_t arg4 ;
  lldb::SBFileSpecList *arg5 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg4) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg4);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg4, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg4 = 0;
    if (sz > 0) {
      arg4 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg4 = (arg4 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg5 = *(lldb::SBFileSpecList **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateByLocation((lldb::SBFileSpec const &)*arg2,arg3,arg4,*arg5);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByLocation_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  lldb::addr_t arg5 ;
  lldb::SBFileSpecList *arg6 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg6_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg5);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg5, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg5 = 0;
    if (sz > 0) {
      arg5 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg5 = (arg5 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg6 = *(lldb::SBFileSpecList **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateByLocation((lldb::SBFileSpec const &)*arg2,arg3,arg4,arg5,*arg6);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByLocation_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg5, jlong jarg6, jobject jarg6_, jboolean jarg7) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  lldb::addr_t arg5 ;
  lldb::SBFileSpecList *arg6 = 0 ;
  bool arg7 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg6_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg5) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg5);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg5, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg5 = 0;
    if (sz > 0) {
      arg5 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg5 = (arg5 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg6 = *(lldb::SBFileSpecList **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList & reference is null");
    return 0;
  } 
  arg7 = jarg7 ? true : false; 
  result = (arg1)->BreakpointCreateByLocation((lldb::SBFileSpec const &)*arg2,arg3,arg4,arg5,*arg6,arg7);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByName_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->BreakpointCreateByName((char const *)arg2,(char const *)arg3);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByName_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->BreakpointCreateByName((char const *)arg2);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByName_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::SBFileSpecList *arg4 = 0 ;
  lldb::SBFileSpecList *arg5 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = *(lldb::SBFileSpecList **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg5 = *(lldb::SBFileSpecList **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateByName((char const *)arg2,arg3,(lldb::SBFileSpecList const &)*arg4,(lldb::SBFileSpecList const &)*arg5);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByName_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jint jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  uint32_t arg3 ;
  lldb::LanguageType arg4 ;
  lldb::SBFileSpecList *arg5 = 0 ;
  lldb::SBFileSpecList *arg6 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = (lldb::LanguageType)jarg4; 
  arg5 = *(lldb::SBFileSpecList **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg6 = *(lldb::SBFileSpecList **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateByName((char const *)arg2,arg3,arg4,(lldb::SBFileSpecList const &)*arg5,(lldb::SBFileSpecList const &)*arg6);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByNames_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char **arg2 = (char **) 0 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  lldb::SBFileSpecList *arg5 = 0 ;
  lldb::SBFileSpecList *arg6 = 0 ;
  jint size2 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  arg5 = *(lldb::SBFileSpecList **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg6 = *(lldb::SBFileSpecList **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateByNames((char const **)arg2,arg3,arg4,(lldb::SBFileSpecList const &)*arg5,(lldb::SBFileSpecList const &)*arg6);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByNames_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jlong jarg4, jint jarg5, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char **arg2 = (char **) 0 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  lldb::LanguageType arg5 ;
  lldb::SBFileSpecList *arg6 = 0 ;
  lldb::SBFileSpecList *arg7 = 0 ;
  jint size2 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  arg5 = (lldb::LanguageType)jarg5; 
  arg6 = *(lldb::SBFileSpecList **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg7 = *(lldb::SBFileSpecList **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateByNames((char const **)arg2,arg3,arg4,arg5,(lldb::SBFileSpecList const &)*arg6,(lldb::SBFileSpecList const &)*arg7);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByNames_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jlong jarg4, jint jarg5, jobject jarg6, jlong jarg7, jobject jarg7_, jlong jarg8, jobject jarg8_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char **arg2 = (char **) 0 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  lldb::LanguageType arg5 ;
  lldb::addr_t arg6 ;
  lldb::SBFileSpecList *arg7 = 0 ;
  lldb::SBFileSpecList *arg8 = 0 ;
  jint size2 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg7_;
  (void)jarg8_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  arg5 = (lldb::LanguageType)jarg5; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg6) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg6);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg6, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg6 = 0;
    if (sz > 0) {
      arg6 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg6 = (arg6 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg7 = *(lldb::SBFileSpecList **)&jarg7;
  if (!arg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg8 = *(lldb::SBFileSpecList **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateByNames((char const **)arg2,arg3,arg4,arg5,arg6,(lldb::SBFileSpecList const &)*arg7,(lldb::SBFileSpecList const &)*arg8);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByRegex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->BreakpointCreateByRegex((char const *)arg2,(char const *)arg3);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByRegex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->BreakpointCreateByRegex((char const *)arg2);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByRegex_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::LanguageType arg3 ;
  lldb::SBFileSpecList *arg4 = 0 ;
  lldb::SBFileSpecList *arg5 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::LanguageType)jarg3; 
  arg4 = *(lldb::SBFileSpecList **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg5 = *(lldb::SBFileSpecList **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateByRegex((char const *)arg2,arg3,(lldb::SBFileSpecList const &)*arg4,(lldb::SBFileSpecList const &)*arg5);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateBySourceRegex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jstring jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBFileSpec *arg3 = 0 ;
  char *arg4 = (char *) 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBFileSpec **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (arg1)->BreakpointCreateBySourceRegex((char const *)arg2,(lldb::SBFileSpec const &)*arg3,(char const *)arg4);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateBySourceRegex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBFileSpec *arg3 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBFileSpec **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateBySourceRegex((char const *)arg2,(lldb::SBFileSpec const &)*arg3);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateBySourceRegex_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBFileSpecList *arg3 = 0 ;
  lldb::SBFileSpecList *arg4 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBFileSpecList **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBFileSpecList **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateBySourceRegex((char const *)arg2,(lldb::SBFileSpecList const &)*arg3,(lldb::SBFileSpecList const &)*arg4);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateBySourceRegex_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBFileSpecList *arg3 = 0 ;
  lldb::SBFileSpecList *arg4 = 0 ;
  lldb::SBStringList *arg5 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBFileSpecList **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBFileSpecList **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg5 = *(lldb::SBStringList **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateBySourceRegex((char const *)arg2,(lldb::SBFileSpecList const &)*arg3,(lldb::SBFileSpecList const &)*arg4,(lldb::SBStringList const &)*arg5);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateForException(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::LanguageType arg2 ;
  bool arg3 ;
  bool arg4 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (lldb::LanguageType)jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  result = (arg1)->BreakpointCreateForException(arg2,arg3,arg4);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateByAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::addr_t arg2 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  result = (arg1)->BreakpointCreateByAddress(arg2);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetEnvironment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBEnvironment result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (arg1)->GetEnvironment();
  *(lldb::SBEnvironment **)&jresult = new lldb::SBEnvironment((const lldb::SBEnvironment &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateBySBAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBAddress *arg2 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBAddress **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBAddress & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateBySBAddress(*arg2);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateFromScript_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jboolean jarg6) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStructuredData *arg3 = 0 ;
  lldb::SBFileSpecList *arg4 = 0 ;
  lldb::SBFileSpecList *arg5 = 0 ;
  bool arg6 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBStructuredData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStructuredData & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBFileSpecList **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg5 = *(lldb::SBFileSpecList **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg6 = jarg6 ? true : false; 
  result = (arg1)->BreakpointCreateFromScript((char const *)arg2,*arg3,(lldb::SBFileSpecList const &)*arg4,(lldb::SBFileSpecList const &)*arg5,arg6);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointCreateFromScript_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStructuredData *arg3 = 0 ;
  lldb::SBFileSpecList *arg4 = 0 ;
  lldb::SBFileSpecList *arg5 = 0 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBStructuredData **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStructuredData & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBFileSpecList **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  arg5 = *(lldb::SBFileSpecList **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpecList const & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointCreateFromScript((char const *)arg2,*arg3,(lldb::SBFileSpecList const &)*arg4,(lldb::SBFileSpecList const &)*arg5);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetNumBreakpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (uint32_t)((lldb::SBTarget const *)arg1)->GetNumBreakpoints();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetBreakpointAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t arg2 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = ((lldb::SBTarget const *)arg1)->GetBreakpointAtIndex(arg2);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointDelete(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::break_id_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (lldb::break_id_t)jarg2; 
  result = (bool)(arg1)->BreakpointDelete(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindBreakpointByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::break_id_t arg2 ;
  lldb::SBBreakpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (lldb::break_id_t)jarg2; 
  result = (arg1)->FindBreakpointByID(arg2);
  *(lldb::SBBreakpoint **)&jresult = new lldb::SBBreakpoint((const lldb::SBBreakpoint &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1FindBreakpointsByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBBreakpointList *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBBreakpointList **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpointList & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->FindBreakpointsByName((char const *)arg2,*arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBTarget_1DeleteBreakpointName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  (arg1)->DeleteBreakpointName((char const *)arg2);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBTarget_1GetBreakpointNames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBStringList *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBStringList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return ;
  } 
  (arg1)->GetBreakpointNames(*arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1EnableAllBreakpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (bool)(arg1)->EnableAllBreakpoints();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1DisableAllBreakpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (bool)(arg1)->DisableAllBreakpoints();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1DeleteAllBreakpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (bool)(arg1)->DeleteAllBreakpoints();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointsCreateFromFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBBreakpointList *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBBreakpointList **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpointList & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointsCreateFromFile(*arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointsCreateFromFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBStringList *arg3 = 0 ;
  lldb::SBBreakpointList *arg4 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBStringList **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStringList & reference is null");
    return 0;
  } 
  arg4 = *(lldb::SBBreakpointList **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpointList & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointsCreateFromFile(*arg2,*arg3,*arg4);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointsWriteToFile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointsWriteToFile(*arg2);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointsWriteToFile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBBreakpointList *arg3 = 0 ;
  bool arg4 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBBreakpointList **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpointList & reference is null");
    return 0;
  } 
  arg4 = jarg4 ? true : false; 
  result = (arg1)->BreakpointsWriteToFile(*arg2,*arg3,arg4);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1BreakpointsWriteToFile_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBFileSpec *arg2 = 0 ;
  lldb::SBBreakpointList *arg3 = 0 ;
  lldb::SBError result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBFileSpec **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBFileSpec & reference is null");
    return 0;
  } 
  arg3 = *(lldb::SBBreakpointList **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBBreakpointList & reference is null");
    return 0;
  } 
  result = (arg1)->BreakpointsWriteToFile(*arg2,*arg3);
  *(lldb::SBError **)&jresult = new lldb::SBError((const lldb::SBError &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetNumWatchpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (uint32_t)((lldb::SBTarget const *)arg1)->GetNumWatchpoints();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetWatchpointAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  uint32_t arg2 ;
  lldb::SBWatchpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = ((lldb::SBTarget const *)arg1)->GetWatchpointAtIndex(arg2);
  *(lldb::SBWatchpoint **)&jresult = new lldb::SBWatchpoint((const lldb::SBWatchpoint &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1DeleteWatchpoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::watch_id_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (lldb::watch_id_t)jarg2; 
  result = (bool)(arg1)->DeleteWatchpoint(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindWatchpointByID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::watch_id_t arg2 ;
  lldb::SBWatchpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = (lldb::watch_id_t)jarg2; 
  result = (arg1)->FindWatchpointByID(arg2);
  *(lldb::SBWatchpoint **)&jresult = new lldb::SBWatchpoint((const lldb::SBWatchpoint &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1EnableAllWatchpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (bool)(arg1)->EnableAllWatchpoints();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1DisableAllWatchpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (bool)(arg1)->DisableAllWatchpoints();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1DeleteAllWatchpoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (bool)(arg1)->DeleteAllWatchpoints();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1WatchAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jboolean jarg4, jboolean jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::addr_t arg2 ;
  size_t arg3 ;
  bool arg4 ;
  bool arg5 ;
  lldb::SBError *arg6 = 0 ;
  lldb::SBWatchpoint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (lldb::addr_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (lldb::addr_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = (size_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = jarg5 ? true : false; 
  arg6 = *(lldb::SBError **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->WatchAddress(arg2,arg3,arg4,arg5,*arg6);
  *(lldb::SBWatchpoint **)&jresult = new lldb::SBWatchpoint((const lldb::SBWatchpoint &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetBroadcaster(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBBroadcaster result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = ((lldb::SBTarget const *)arg1)->GetBroadcaster();
  *(lldb::SBBroadcaster **)&jresult = new lldb::SBBroadcaster((const lldb::SBBroadcaster &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1CreateValueFromAddress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBAddress arg3 ;
  lldb::SBType arg4 ;
  lldb::SBAddress *argp3 ;
  lldb::SBType *argp4 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(lldb::SBAddress **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBAddress");
    return 0;
  }
  arg3 = *argp3; 
  argp4 = *(lldb::SBType **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBType");
    return 0;
  }
  arg4 = *argp4; 
  result = (arg1)->CreateValueFromAddress((char const *)arg2,arg3,arg4);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1CreateValueFromData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBData arg3 ;
  lldb::SBType arg4 ;
  lldb::SBData *argp3 ;
  lldb::SBType *argp4 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(lldb::SBData **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBData");
    return 0;
  }
  arg3 = *argp3; 
  argp4 = *(lldb::SBType **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBType");
    return 0;
  }
  arg4 = *argp4; 
  result = (arg1)->CreateValueFromData((char const *)arg2,arg3,arg4);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1CreateValueFromExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (arg1)->CreateValueFromExpression((char const *)arg2,(char const *)arg3);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ReadInstructions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBAddress arg2 ;
  uint32_t arg3 ;
  lldb::SBAddress *argp2 ;
  lldb::SBInstructionList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBAddress **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBAddress");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (uint32_t)jarg3; 
  result = (arg1)->ReadInstructions(arg2,arg3);
  *(lldb::SBInstructionList **)&jresult = new lldb::SBInstructionList((const lldb::SBInstructionList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1ReadInstructions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBAddress arg2 ;
  uint32_t arg3 ;
  char *arg4 = (char *) 0 ;
  lldb::SBAddress *argp2 ;
  lldb::SBInstructionList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBAddress **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBAddress");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  result = (arg1)->ReadInstructions(arg2,arg3,(char const *)arg4);
  *(lldb::SBInstructionList **)&jresult = new lldb::SBInstructionList((const lldb::SBInstructionList &)result); 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetInstructions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBAddress arg2 ;
  void *arg3 = (void *) 0 ;
  size_t arg4 ;
  lldb::SBAddress *argp2 ;
  lldb::SBInstructionList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBAddress **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBAddress");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (size_t)jarg4; 
  result = (arg1)->GetInstructions(arg2,(void const *)arg3,arg4);
  *(lldb::SBInstructionList **)&jresult = new lldb::SBInstructionList((const lldb::SBInstructionList &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetInstructionsWithFlavor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBAddress arg2 ;
  char *arg3 = (char *) 0 ;
  void *arg4 = (void *) 0 ;
  size_t arg5 ;
  lldb::SBAddress *argp2 ;
  lldb::SBInstructionList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  argp2 = *(lldb::SBAddress **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null lldb::SBAddress");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(void **)&jarg4; 
  arg5 = (size_t)jarg5; 
  result = (arg1)->GetInstructionsWithFlavor(arg2,(char const *)arg3,(void const *)arg4,arg5);
  *(lldb::SBInstructionList **)&jresult = new lldb::SBInstructionList((const lldb::SBInstructionList &)result); 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindSymbols_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SymbolType arg3 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (lldb::SymbolType)jarg3; 
  result = (arg1)->FindSymbols((char const *)arg2,arg3);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1FindSymbols_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBSymbolContextList result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->FindSymbols((char const *)arg2);
  *(lldb::SBSymbolContextList **)&jresult = new lldb::SBSymbolContextList((const lldb::SBSymbolContextList &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1GetDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  lldb::DescriptionLevel arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  arg3 = (lldb::DescriptionLevel)jarg3; 
  result = (bool)(arg1)->GetDescription(*arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBTarget_1GetStackRedZoneSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::addr_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (lldb::addr_t)(arg1)->GetStackRedZoneSize();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1IsLoaded(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBModule *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBModule **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBModule const & reference is null");
    return 0;
  } 
  result = (bool)((lldb::SBTarget const *)arg1)->IsLoaded((lldb::SBModule const &)*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetLaunchInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  SwigValueWrapper< lldb::SBLaunchInfo > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = ((lldb::SBTarget const *)arg1)->GetLaunchInfo();
  *(lldb::SBLaunchInfo **)&jresult = new lldb::SBLaunchInfo((const lldb::SBLaunchInfo &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBTarget_1SetLaunchInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBLaunchInfo *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBLaunchInfo **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBLaunchInfo const & reference is null");
    return ;
  } 
  (arg1)->SetLaunchInfo((lldb::SBLaunchInfo const &)*arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBTarget_1SetCollectingStats(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetCollectingStats(arg2);
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBTarget_1GetCollectingStats(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (bool)(arg1)->GetCollectingStats();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetStatistics(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBStructuredData result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (arg1)->GetStatistics();
  *(lldb::SBStructuredData **)&jresult = new lldb::SBStructuredData((const lldb::SBStructuredData &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1EvaluateExpression_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (arg1)->EvaluateExpression((char const *)arg2);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1EvaluateExpression_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBExpressionOptions *arg3 = 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBExpressionOptions **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBExpressionOptions const & reference is null");
    return 0;
  } 
  result = (arg1)->EvaluateExpression((char const *)arg2,(lldb::SBExpressionOptions const &)*arg3);
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBTarget_1_1_1repr_1_1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = lldb_SBTarget___repr__(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1GetTrace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBTrace result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  result = (arg1)->GetTrace();
  *(lldb::SBTrace **)&jresult = new lldb::SBTrace((const lldb::SBTrace &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBTarget_1CreateTrace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  lldb::SBTarget *arg1 = (lldb::SBTarget *) 0 ;
  lldb::SBError *arg2 = 0 ;
  lldb::SBTrace result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBTarget **)&jarg1; 
  arg2 = *(lldb::SBError **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return 0;
  } 
  result = (arg1)->CreateTrace(*arg2);
  *(lldb::SBTrace **)&jresult = new lldb::SBTrace((const lldb::SBTrace &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBThread_1eBroadcastBitStackChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBThread::eBroadcastBitStackChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBThread_1eBroadcastBitThreadSuspended_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBThread::eBroadcastBitThreadSuspended;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBThread_1eBroadcastBitThreadResumed_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBThread::eBroadcastBitThreadResumed;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBThread_1eBroadcastBitSelectedFrameChanged_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBThread::eBroadcastBitSelectedFrameChanged;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBThread_1eBroadcastBitThreadSelected_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)lldb::SBThread::eBroadcastBitThreadSelected;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBThread_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lldb::SBThread *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lldb::SBThread *)new lldb::SBThread();
  *(lldb::SBThread **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_new_1SBThread_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBThread *arg1 = 0 ;
  lldb::SBThread *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBThread const & reference is null");
    return 0;
  } 
  result = (lldb::SBThread *)new lldb::SBThread((lldb::SBThread const &)*arg1);
  *(lldb::SBThread **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_delete_1SBThread(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lldb::SBThread **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBThread_1GetBroadcasterClassName(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)lldb::SBThread::GetBroadcasterClassName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBThread_1EventIsThreadEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = (bool)lldb::SBThread::EventIsThreadEvent((lldb::SBEvent const &)*arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBThread_1GetStackFrameFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::SBFrame result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBThread::GetStackFrameFromEvent((lldb::SBEvent const &)*arg1);
  *(lldb::SBFrame **)&jresult = new lldb::SBFrame((const lldb::SBFrame &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBThread_1GetThreadFromEvent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBEvent *arg1 = 0 ;
  lldb::SBThread result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBEvent **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBEvent const & reference is null");
    return 0;
  } 
  result = lldb::SBThread::GetThreadFromEvent((lldb::SBEvent const &)*arg1);
  *(lldb::SBThread **)&jresult = new lldb::SBThread((const lldb::SBThread &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBThread_1IsValid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (bool)((lldb::SBThread const *)arg1)->IsValid();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBThread_1Clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jint JNICALL Java_SWIG_lldbJNI_SBThread_1GetStopReason(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::StopReason result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (lldb::StopReason)(arg1)->GetStopReason();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBThread_1GetStopReasonDataCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (arg1)->GetStopReasonDataCount();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBThread_1GetStopReasonDataAtIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jobject jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  uint32_t arg2 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  result = (uint64_t)(arg1)->GetStopReasonDataAtIndex(arg2);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBThread_1GetStopReasonExtendedInfoAsJSON(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::SBStream *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = *(lldb::SBStream **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetStopReasonExtendedInfoAsJSON(*arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBThread_1GetStopReasonExtendedBacktraces(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::InstrumentationRuntimeType arg2 ;
  lldb::SBThreadCollection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = (lldb::InstrumentationRuntimeType)jarg2; 
  result = (arg1)->GetStopReasonExtendedBacktraces(arg2);
  *(lldb::SBThreadCollection **)&jresult = new lldb::SBThreadCollection((const lldb::SBThreadCollection &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBThread_1GetStopDescription(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  result = (arg1)->GetStopDescription(arg2,arg3);
  jresult = (jlong)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBThread_1GetStopReturnValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::SBValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (arg1)->GetStopReturnValue();
  *(lldb::SBValue **)&jresult = new lldb::SBValue((const lldb::SBValue &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBThread_1GetThreadID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::tid_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (lldb::tid_t)((lldb::SBThread const *)arg1)->GetThreadID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBThread_1GetIndexID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (uint32_t)((lldb::SBThread const *)arg1)->GetIndexID();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBThread_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (char *)((lldb::SBThread const *)arg1)->GetName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_SWIG_lldbJNI_SBThread_1GetQueueName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (char *)((lldb::SBThread const *)arg1)->GetQueueName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_SWIG_lldbJNI_SBThread_1GetQueueID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::queue_id_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = (lldb::queue_id_t)((lldb::SBThread const *)arg1)->GetQueueID();
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_SWIG_lldbJNI_SBThread_1GetInfoItemByPathAsString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::SBStream *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(lldb::SBStream **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBStream & reference is null");
    return 0;
  } 
  result = (bool)(arg1)->GetInfoItemByPathAsString((char const *)arg2,*arg3);
  jresult = (jboolean)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_SWIG_lldbJNI_SBThread_1GetQueue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::SBQueue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  result = ((lldb::SBThread const *)arg1)->GetQueue();
  *(lldb::SBQueue **)&jresult = new lldb::SBQueue((const lldb::SBQueue &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBThread_1StepOver_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::RunMode arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = (lldb::RunMode)jarg2; 
  (arg1)->StepOver(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBThread_1StepOver_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  (arg1)->StepOver();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBThread_1StepOver_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::RunMode arg2 ;
  lldb::SBError *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = (lldb::RunMode)jarg2; 
  arg3 = *(lldb::SBError **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "lldb::SBError & reference is null");
    return ;
  } 
  (arg1)->StepOver(arg2,*arg3);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBThread_1StepInto_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  lldb::RunMode arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = (lldb::RunMode)jarg2; 
  (arg1)->StepInto(arg2);
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBThread_1StepInto_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  (arg1)->StepInto();
}


SWIGEXPORT void JNICALL Java_SWIG_lldbJNI_SBThread_1StepInto_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  lldb::SBThread *arg1 = (lldb::SBThread *) 0 ;
  char *arg2 = (char *) 0 ;
  lldb::RunMode arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lldb::SBThread **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (lldb::R