--# -path=.:prelude

concrete LexiconUrd of Lexicon = CatUrd ** 
--open ResUrd, Prelude in {
  open ParadigmsUrd, Prelude in {

  flags 
    optimize=values ;
    coding = utf8;

  lin
  airplane_N = mkN "جہاز" ;
  answer_V2S = mkV2  (compoundV "جواب" (mkV "دینا")) ;
  apartment_N = mkN "کمرہ" ;
  apple_N = mkN "سیب" ;
  art_N = mkN "فن" ;
  ask_V2Q = mkV2 (mkV "پوچھنا") ;
  baby_N = mkN "بچہ" ;
  bad_A = mkA "برا" ;
  bank_N = mkN "بینک" ;
  beautiful_A = mkA "خوبصورت" ;
  become_VA = mkV "بننا";
  beer_N = mkN "بییر" ;
  beg_V2V =  mkV2V (compoundV "التجا" (mkV "کرنا")) "سے" "کہ" False;
  big_A = mkA "بڑا" ;
  bike_N = mkN "سایکل" feminine ;
  bird_N = mkN "پرندہ" ;
  black_A =  mkA "کالا" ;
  blue_A = mkA "نیلا" ;
  boat_N = mkN "کشتی" ;
  book_N = mkN "کتاب" feminine ;
  boot_N = mkN "جوتا" ;
  boss_N = mkN "صاحب" ;
  boy_N = mkN "لڑکا" ;
  bread_N = mkN "روٹی" ;
  break_V2 = mkV2 (mkV "توڑنا") ;
  broad_A = mkA "کھلا" ;
  brother_N2 = mkN2 (mkN "بھای") (mkPrep "کا" "کا") "کے" ; --not correct
  brown_A = mkA "نسواری" ;
  butter_N = mkN "مکھن" ;
  buy_V2 = mkV2 (mkV "خریدنا") "کو";
  camera_N = mkN "کیمرہ" ;
  cap_N = mkN "ٹوپی" ;
  car_N = mkN "گاڑی" ;
  carpet_N = mkN "تپائی" ;
  cat_N = mkN "بلی" ;
  ceiling_N = mkN "چھت" feminine ;
  chair_N = mkN "کرسی" ;
  cheese_N = mkN "پنیر" feminine ;
  child_N = mkN "بچہ"  ;
  church_N = mkCmpdNoun "گرجا" (mkN "گھر") ;
  city_N = mkN "شہر"  ;
  clean_A = mkA "صاف" ;
  clever_A = mkA "ہوشیار" ;  
  close_V2 =  mkV2 (compoundV "بند" do_V2); 
  coat_N = mkN "کوٹ" ;
  cold_A = mkA "ٹھنڈا" ;
  come_V = mkV "آنا" ;
  computer_N = mkN "کمپیوٹر" ;
  country_N = mkN "ملک" ;
  cousin_N = mkCmpdNoun "چچا" (mkN "زاد") ; -- a compund noun made of two nouns
  cow_N = mkN "گاے" feminine ;
  die_V = mkV "مرنا" ;
  dirty_A = mkA "گندا" ;
  distance_N3 = mkN3 (mkN "فاصلہ") (mkPrep "کا" "کا") "کے" "سے"  ;
  doctor_N = mkN "معالج" ;
  dog_N = mkN "کتا" ;
  door_N = mkN "دروازہ" ;
  drink_V2 = mkV2 (mkV "پینا");
  easy_A2V = mkA "آسان" "" ;
  eat_V2 = mkV2 (mkV "کھانا") "" ;
  empty_A = mkA "خالی" ;
  enemy_N = mkN "دشمن" ;
  factory_N = mkN "کارخانہ" ;
  father_N2 = mkN2 (mkN "ابا") (mkPrep "کا" "کا") "کے"  ;
  fear_VS = mkV "ڈرنا";
  find_V2 = mkV2 (mkV "پانا") ;
  fish_N = mkN "مچھلی" ;
  floor_N = mkN "فرش" ;
  forget_V2 = mkV2 (mkV "بھولنا")  ;
  fridge_N = mkN "فریج" ;
  friend_N = mkN "دوست" masculine ;
  fruit_N = mkN "پھل" ;
--  fun_AV = mkAV (regA "f?ن") ;
  garden_N = mkN "باغ" ;
  girl_N = mkN "لڑکی" ;
  glove_N = mkN "دستانہ" ;
  gold_N = mkN "سونا" ;
  good_A = mkA "اچھا" ;
  go_V = mkV "جانا" ;
  green_A = mkA "سبز" ;
  harbour_N = mkCmpdNoun "بندر" (mkN "گاہ") ;
  hate_V2 = mkV2 (compoundV "نفرت" do_V2) ;
  hat_N = mkN "ٹوپی" ;
--  have_V2 = dirV2 (mk5V "ہa?ع" "ہاس" "ہاد" "ہاد" "ہa??نگ") ;
  hear_V2 = mkV2 (mkV "سننا") ;
  hill_N = mkN "پہاڑی" ;
  hope_VS = (compoundV "امید" do_V2);
  horse_N = mkN "گھوڑا" ;
  hot_A = mkA "گرم" ;
  house_N = mkN "گھر" ;
  important_A = mkA "اہم" ;
  industry_N = mkN "صنعت" feminine ;
  iron_N = mkN "لوہا" ;
  king_N = mkN "بادشاہ" ;
  know_V2 = mkV2 (mkV "جاننا") ;
  know_VS = (mkV "جاننا") ;
  know_VQ = (mkV "جاننا") ;
  lake_N = mkN "جھیل" feminine ;
  lamp_N = mkN "لیمپ" ;
  learn_V2 = mkV2 (mkV "سیکھنا") ;
  leather_N = mkN "چمڑا" ;
  leave_V2 = mkV2 (mkV "جانا") ;
  like_V2 = mkV2 (compoundV "پسند" do_V2) "کو";
  listen_V2 = mkV2 (mkV "سننا") ;
  live_V = mkV "رہنا" ; ---- touch
  long_A = mkA "لمبا" ;
  lose_V2 = mkV2 (compoundV "کھو" do_V2) ;
  love_N = mkN "محبت" ;
  love_V2 = mkV2 (compoundV "پیار" do_V2) "کو";
  man_N = mkN "آدمی" "آدمی" "آدمی" "آدمی" "آدمیوں" "آدمیو" masculine ; 
  married_A2 = mkA "شادی شدہ" "سے" ;
  meat_N = mkN "گوشت" ;
  milk_N = mkN "دودھ" ;
  moon_N = mkN "چاند" ;
  mother_N2 = mkN2 (mkN "ماں") (mkPrep "کی" "کی") "کے";   -- not covered need to be discussed
  mountain_N = mkN "پہاڑی" ;
  music_N = mkN "موسیقی" ;
  narrow_A = mkA "باریک" ;
  new_A = mkA "نیا" ;
  newspaper_N = mkN "اخبار" ;
  oil_N = mkN "تیل" ;
  old_A = mkA "بوڑھا" ;
  open_V2 = mkV2 (mkV "کھولنا") ;
  paint_V2A = mkV2 (compoundV "رنگ" do_V2) ;
  paper_N = mkN "کاغز" ;
  paris_PN = mkPN "پیرس" ;
  peace_N = mkN "امن" ;
  pen_N = mkN "پنسل" ;
  planet_N = mkN "سیارہ" ;
  plastic_N = mkN "پلاسٹک" ;
  play_V2 = mkV2 (mkV "کھیلنا") ;
  policeman_N = mkCmpdNoun "پولیس" (mkN "والا") ; 
  priest_N = (mkN "پیغمبر") ;
--  probable_AS = mkAS (regA "پr?بابلع") ;
  queen_N = mkN "شہزادی" ;
  radio_N = mkN "ریڈیو" ;
  rain_V0 = compoundV "بارش" (mkV "ہونا" ) ;
  read_V2 = mkV2 (mkV "پڑھنا");
  red_A = mkA "لال" ;
  religion_N = mkN "مزہب" ;
  restaurant_N = mkN "ہوٹل" ;
--  river_N = mkN "دریا" masculine ;
  rock_N = mkN "چٹان" ;
--  roof_N = mkN "چھت"   masculine ;
  rubber_N = mkN "ربڑ" ;
  run_V = mkV "دوڑنا" ;
  say_VS = mkV "کہنا" ;
  school_N = mkN "سکول" ;
  science_N = mkN "سانس" ;
  sea_N = mkN "سمندر" ;
  seek_V2 = mkV2 (compoundV "تلاش" do_V2) ;
  see_V2 = mkV2 (mkV "دیکھنا") ;
  sell_V3 = mkV3 (mkV "بیچنا") "کو" "";
  send_V3 = mkV3 (mkV "بھیجنا") "کو" "";
  sheep_N = mkN "بھیڑ" feminine ;
  ship_N = mkN "جہاز" ;
  shirt_N = mkN "قمیص" feminine;
  shoe_N = mkN "جوتا" ;
  shop_N = mkN "دوکان" feminine ;
  short_A = mkA "چھوٹا" ;
  silver_N = mkN "چاندی" ;
  sister_N = mkN "بہن" feminine ;
  sleep_V = mkV "سونا" ;
  small_A = mkA "چھوٹا" ;
  snake_N = mkN "سانپ" ;
  sock_N = mkN "جراب" feminine ;
  speak_V2 = mkV2 (mkV "بولنا") ;
  star_N = mkN "ستارا" ;
  steel_N = mkN "سٹیل" ;
  stone_N = mkN "پتھر" ;
  stove_N = mkN "چولہا" ;
  student_N = mkCmpdNoun "طالب" (mkN "علم") ;
  stupid_A = mkA "احمق" ;
  sun_N = mkN "سورج" ;
  switch8off_V2 = mkV2 (mkV "چلانا") ;
  switch8on_V2 = mkV2 (compoundV "بند" do_V2) ;
  table_N = mkN "میز" feminine ;
  talk_V3 = mkV3 (mkV "بولنا") "سے" "[کے بارے میN]";
  teacher_N = mkN "استاد" ;
  teach_V2 = mkV2 (mkV "پڑھنا") ;
  television_N = mkN "تیلیویژن" ;
  thick_A = mkA "موٹا" ;
  thin_A = mkA "پتلا" ;
  train_N = mkN "گاڑی" ;
  travel_V = (compoundV "سفر" do_V2) ;
--  tree_N = mkN "درخت" masculine ;
-- ---- trousers_N = mkN "تr??سعرس" ;
  ugly_A = mkA "بدصورت" ;
  understand_V2 = mkV2 (mkV "سمجھنا") ;
  university_N = mkN "یونیورسٹی" ;
  village_N = mkN "گاوں" ;
  wait_V2 = mkV2 (compoundV "انتظار" do_V2) ;
  walk_V = mkV "چلنا" ;
  warm_A = mkA "گرم" ;
  war_N = mkN "جنگ" ;
  watch_V2 = mkV2 (mkV "دیکھنا") ;
  water_N = mkN "پانی" ; -- not covered masculine ending with y
  white_A = mkA "سفید" ;
  window_N = mkN "کھڑکی" ;
  wine_N = mkN "شراب" feminine ;
  win_V2 = mkV2 (mkV "جیتنا") ;
  woman_N = mkN "عورت" feminine ;
  wonder_VQ = compoundV "حیران" (mkV "ہونا") ;
  wood_N = mkN "لکڑی" ;
  write_V2 = mkV2 (mkV "لکھنا") ;
  yellow_A = mkA "پیلا" ;
  young_A = mkA "جوان" ;
  do_V2 = mkV2 (mkV "کرنا")  ;
  now_Adv = mkAdv "اب" ;
  already_Adv = mkAdv "[پہلے ہy]" ;
  song_N = mkN "گانا" ;
  add_V3 = mkV3 (compoundV "اضافہ" do_V2) "" "" ;
  number_N = mkN "ہندسہ" ;
  put_V2 = mkV2 (mkV "ڈالنا") ;
  stop_V = mkV "رکنا"  ;
  jump_V = mkV "چھلانگنا" ;

  left_Ord = {s = "بایاں" ; n = singular};
  right_Ord = {s= "دایاں" ; n = singular};
  far_Adv = mkAdv "دور" ;
  correct_A = mkA "صیح" ;
  dry_A = mkA "خشک" ;
  dull_A = mkA "نالایق" ;
  full_A = mkA "مکمل" ;
  heavy_A = mkA "بھاری" ;
  near_A = mkA "قریبی" ;
  rotten_A = mkA "خراب" ;
  round_A = mkA "گول" ;
  sharp_A = mkA "تیز" ;
  smooth_A = mkA "ہموار" ;
  straight_A = mkA "سیدھا" ;
  wet_A = mkA "گیلا" ; ----
  wide_A = mkA "کھلا" ;
  animal_N = mkN "جانور" ;
  ashes_N = mkN "راکھ" feminine; -- FIXME: plural only?
  back_N = mkN "قمر" feminine ;
  bark_N = mkN "بارک" ;
  belly_N = mkN "دھنی" ;
  blood_N = mkN "خون" ;
  bone_N = mkN "ہڈی" ;
  breast_N = mkN "چھاتی" ;
  cloud_N = mkN "بادل" ;
  day_N = mkN "دن" ;
  dust_N = mkN "دھول" ;
  ear_N = mkN "کان" ;
  earth_N = mkN "زمین" feminine ;
  egg_N = mkN "انڈہ" ;
  eye_N = mkN "آنکھ" feminine ;
  fat_N = mkN "موٹا" ;
  feather_N = mkN "پر" ;
  fingernail_N = mkN "ناخن" ;
  fire_N = mkN "آگ" feminine ;
  flower_N = mkN "پھول" ;
  fog_N = mkN "دھند" feminine ;
  foot_N = mkN "پاوں" ; -- not properly covered need to be discussed
  forest_N = mkN "جنگل" ;
  grass_N = mkN "گھاس" feminine ;
  guts_N = mkN "گٹ" ; -- FIXME: no singular
  hair_N = mkN "بال" ;
  hand_N = mkN "ہاتھ" ;
  head_N = mkN "سر" ;
  heart_N = mkN "دل" ;
  horn_N = mkN "گھنٹی" ;
  husband_N = mkN "شوہر" ;
  ice_N = mkN "برف" feminine ;
  knee_N = mkN "کہنی" ;
  leaf_N = mkN "پتہ" ;
  leg_N = mkN "ٹانگ" feminine ;
  liver_N = mkN "جگر" ;
  louse_N = mkN "گھر" ;
  mouth_N = mkN "منہ" ;
  name_N = mkN "نام" ;
  neck_N = mkN "گردن" feminine ;
  night_N = mkN "رات" feminine ;
  nose_N = mkN "ناک" ;
  person_N = mkN "شخص" ;
  rain_N = mkN "بارش" feminine ;
  road_N = mkN "سڑک" ;
  root_N = mkN "جڑ" feminine ;
  rope_N = mkN "رسی" ;
  salt_N = mkN "نمک" feminine ;
  sand_N = mkN "ریت" feminine ;
  seed_N = mkN "بیج"  ;
  skin_N = mkN "جلد" feminine ;
  sky_N = mkN "آسمان" ;
  smoke_N = mkN "دھواں"; -- singular masc nouns ending with aN,wN yet to be implemented
  snow_N = mkN "برف" feminine ;
  stick_N = mkN "چھڑی" ;
  tail_N = mkN "دم" ;
  tongue_N = mkN "زبان" feminine ;
--  tooth_N = mkN "دانت" masculine;
  wife_N = mkN "بیوی" ;
  wind_N = mkN "آندھی" ;
  wing_N = mkN "پر" ;
  worm_N = mkN "گرم" ;
  year_N = mkN "سال" ;
  blow_V = mkV "چلنا" ;
  breathe_V = compoundV "سانس" (mkV "لینا" ) ;
  burn_V = mkV "جلنا" ;
  dig_V = mkV "کھودنا" ;
  fall_V = mkV "گرنا" ;
  float_V = mkV "تیرنا" ;
  flow_V = mkV  "بہنا" ;
  fly_V = mkV "اڑنا" ;
  freeze_V = mkV "جمنا";
  give_V3 = mkV3 (mkV "دینا") "کو" "";
  laugh_V = mkV "ہنسنا" ;
--  lie_N = mkN "جھوت" masculine ;
  lie_V = compoundV "جھوٹ" (mkV "بولنا" );
  play_V = mkV "کھیلنا" ;
  sew_V = mkV "سینا" ;
  sing_V = mkV "گانا" ;
  sit_V = mkV "بیٹھنا" ;
  smell_V = mkV "سونگنا" ;
  spit_V = mkV "تھوکنا" ;
  stand_V = compoundV "کھڑے" (mkV "ہونا" );
  swell_V = mkV "سوجھنا" ;
  swim_V = mkV "تیرنا" ;
  think_V = mkV "سوچنا" ;
  turn_V = mkV "مڑنا";
  vomit_V = compoundV "التی" (mkV "کرنا") ;
  bite_V2 = mkV2 (mkV "کاٹنا") ;
  count_V2 = mkV2 (mkV "گننا") ;
  cut_V2 = mkV2 (mkV "کاتنا") ;
  fear_V2 = mkV2 (mkV "ڈرنا") ;
  fight_V2 = mkV2 (mkV "لڑنا") ;
  hit_V2 = mkV2 (compoundV "ٹھوکر" (mkV "مارنا" ));
  hold_V2 = mkV2 (mkV "پکڑنا") ;
  hunt_V2 = mkV2 (compoundV "شکار" do_V2);
  kill_V2 =  mkV2 (compoundV "مار" (mkV "ڈالنا" )) ;
  pull_V2 = mkV2 (mkV "کھنچنا");
  push_V2 = mkV2 (mkV "دھکیلنا") "کو" ;
  rub_V2 = mkV2 (mkV "رگڑنا") ;
  scratch_V2 = mkV2 (mkV "کھرچنا") "کو" ;
  split_V2 = mkV2 (mkV "بانٹنا") "کو" ;
--  squeeze_V2 = dirV2 (regV "سq?ععزع") ;
--  stab_V2 = dirV2 (regDuplV "ستاب") ;
  suck_V2 = mkV2 (mkV "چوسنا") ;
  throw_V2 = mkV2 (mkV "پھینکنا") ;
  tie_V2 = mkV2 (mkV "باندھنا") ;
  wash_V2 = mkV2 (mkV "دھونا") ;
  wipe_V2 = mkV2 (compoundV "صاف" (mkV "کرنا" ));

----  other_A = regA "؟تہعر" ;

  grammar_N = mkN "گردان" ;
  language_N = mkN "زبان" feminine ;
  rule_N = mkN "اصول" ;

---- added 4/6/2007
    john_PN = mkPN "جان" ;
    question_N = mkN "سوال" ;
    ready_A = mkA "تیار" ;
    reason_N = mkN "وجہ" feminine ;
    today_Adv = mkAdv "آج" ;
    uncertain_A = mkA ["غیریقینی"] ;
    
 
}
