-- This dictionary is derived from SALDO, see:
-- https://spraakbanken.gu.se/eng/resource/saldo
--
-- Original module by Malin Ahlberg has been moved to OldDictSwe.
-- Both are inherited by DictSwe.
-- This updated version with renamed identifiers is maintained by John J. Camilleri

abstract NewDictSweAbs = Cat ** {

flags
  coding=utf8 ;

fun
  A_bomb_1_N : N ; -- A-bomb..nn.1
  A_kassa_1_N : N ; -- A-kassa..nn.1
  A_lag_1_N : N ; -- A-lag..nn.1
  A_lagare_1_N : N ; -- A-lagare..nn.1
  A_människa_1_N : N ; -- A-människa..nn.1
  A_vitamin_1_N : N ; -- A-vitamin..nn.1
  A_vitaminbrist_1_N : N ; -- A-vitaminbrist..nn.1
  ABS_broms_1_N : N ; -- ABS-broms..nn.1
  ADHD_symtom_1_N : N ; -- ADHD-symtom..nn.1
  AT_läkare_1_N : N ; -- AT-läkare..nn.1
  AV_block_1_N : N ; -- AV-block..nn.1
  Administrator_1_N : N ; -- Administrator..nn.1
  Afghanistaninsats_1_N : N ; -- Afghanistaninsats..nn.1
  Afghanistantrupp_1_N : N ; -- Afghanistantrupp..nn.1
  Afrikatrad_1_N : N ; -- Afrikatrad..nn.1
  Alexanderhugg_1_N : N ; -- Alexanderhugg..nn.1
  Alfapet_1_N : N ; -- Alfapet..nn.1
  Almedalental_1_N : N ; -- Almedalental..nn.1
  Almedalstal_1_N : N ; -- Almedalstal..nn.1
  Almedalsvecka_1_N : N ; -- Almedalsvecka..nn.1
  Android_1_N : N ; -- Android..nn.1
  Androidlur_1_N : N ; -- Androidlur..nn.1
  Androidmobil_1_N : N ; -- Androidmobil..nn.1
  Antarktisfördrag_1_N : N ; -- Antarktisfördrag..nn.1
  Antarktisprojekt_1_N : N ; -- Antarktisprojekt..nn.1
  Apolloprogram_1_N : N ; -- Apolloprogram..nn.1
  Arianeraket_1_N : N ; -- Arianeraket..nn.1
  Asien_rundresa_1_N : N ; -- Asien-rundresa..nn.1
  B_lag_1_N : N ; -- B-lag..nn.1
  B_människa_1_N : N ; -- B-människa..nn.1
  B_vitamin_1_N : N ; -- B-vitamin..nn.1
  B_vitaminbrist_1_N : N ; -- B-vitaminbrist..nn.1
  BLARK_1_N : N ; -- BLARK..nn.1
  BNP_tillväxt_1_N : N ; -- BNP-tillväxt..nn.1
  Bachfuga_1_N : N ; -- Bachfuga..nn.1
  Ballograf_1_N : N ; -- Ballograf..nn.1
  Banverk_1_N : N ; -- Banverk..nn.1
  Banverkspersonal_1_N : N ; -- Banverkspersonal..nn.1
  Bayeuxtapet_1_N : N ; -- Bayeuxtapet..nn.1
  Beethovensonat_1_N : N ; -- Beethovensonat..nn.1
  Berlinmur_1_N : N ; -- Berlinmur..nn.1
  Bondbrud_1_N : N ; -- Bondbrud..nn.1
  Bondfilm_1_N : N ; -- Bondfilm..nn.1
  Bonnierkoncern_1_N : N ; -- Bonnierkoncern..nn.1
  Bristoltrakt_1_N : N ; -- Bristoltrakt..nn.1
  Bromelia_1_N : N ; -- Bromelia..nn.1
  Brommamamma_1_N : N ; -- Brommamamma..nn.1
  C_dur_1_N : N ; -- C-dur..nn.1
  C_durskala_1_N : N ; -- C-durskala..nn.1
  C_vitamin_1_N : N ; -- C-vitamin..nn.1
  C_vitaminbrist_1_N : N ; -- C-vitaminbrist..nn.1
  C14_metod_1_N : N ; -- C14-metod..nn.1
  CD_spelare_1_N : N ; -- CD-spelare..nn.1
  CP_skadad_1_A : A ; -- CP-skadad..av.1
  Calzone_1_N : N ; -- Calzone..nn.1
  Centauristjärna_1_N : N ; -- Centauristjärna..nn.1
  Chicago_baserad_1_A : A ; -- Chicago-baserad..av.1
  Chicagobaserad_1_A : A ; -- Chicagobaserad..av.1
  Citroen_1_N : N ; -- Citroen..nn.1
  Cointreau_1_N : N ; -- Cointreau..nn.1
  Cp_skadad_1_A : A ; -- Cp-skadad..av.1
  D_vitamin_1_N : N ; -- D-vitamin..nn.1
  D_vitaminbrist_1_N : N ; -- D-vitaminbrist..nn.1
  DNA_kedja_1_N : N ; -- DNA-kedja..nn.1
  DNA_molekyl_1_N : N ; -- DNA-molekyl..nn.1
  DNA_profil_1_N : N ; -- DNA-profil..nn.1
  DNA_sekvens_1_N : N ; -- DNA-sekvens..nn.1
  DNA_sekvensering_1_N : N ; -- DNA-sekvensering..nn.1
  DNA_sträng_1_N : N ; -- DNA-sträng..nn.1
  DNA_test_1_N : N ; -- DNA-test..nn.1
  DNA_testa_1_V : V ; -- DNA-testa..vb.1
  DNA_testande_1_N : N ; -- DNA-testande..nn.1
  DNA_testning_1_N : N ; -- DNA-testning..nn.1
  DNA_uppsättning_1_N : N ; -- DNA-uppsättning..nn.1
  DVD_film_1_N : N ; -- DVD-film..nn.1
  DVD_spelare_1_N : N ; -- DVD-spelare..nn.1
  Delftporslin_1_N : N ; -- Delftporslin..nn.1
  DraMaten_1_N : N ; -- DraMaten..nn.1
  Dramaten_1_N : N ; -- Dramaten..nn.1
  Dramatenchef_1_N : N ; -- Dramatenchef..nn.1
  Dubaifrossa_1_N : N ; -- Dubaifrossa..nn.1
  E_godkänd_1_A : A ; -- E-godkänd..av.1
  EHEC_smitta_1_N : N ; -- EHEC-smitta..nn.1
  EHEC_1_N : N ; -- EHEC..nn.1
  EU_intern_1_A : A ; -- EU-intern..av.1
  EU_kommission_1_N : N ; -- EU-kommission..nn.1
  EU_korrespondent_1_N : N ; -- EU-korrespondent..nn.1
  EU_land_1_N : N ; -- EU-land..nn.1
  EU_migrant_1_N : N ; -- EU-migrant..nn.1
  EU_minister_1_N : N ; -- EU-minister..nn.1
  EU_parlament_1_N : N ; -- EU-parlament..nn.1
  EU_parlamentariker_1_N : N ; -- EU-parlamentariker..nn.1
  EU_skeptisk_1_A : A ; -- EU-skeptisk..av.1
  EU_utvidgning_1_N : N ; -- EU-utvidgning..nn.1
  EU_val_1_N : N ; -- EU-val..nn.1
  Efta_land_1_N : N ; -- Efta-land..nn.1
  Eisenhowerepok_1_N : N ; -- Eisenhowerepok..nn.1
  Europaparlament_1_N : N ; -- Europaparlament..nn.1
  Europaråd_1_N : N ; -- Europaråd..nn.1
  Europarådsparlament_1_N : N ; -- Europarådsparlament..nn.1
  Europarådsparlamentariker_1_N : N ; -- Europarådsparlamentariker..nn.1
  Europaunion_1_N : N ; -- Europaunion..nn.1
  FN_organ_1_N : N ; -- FN-organ..nn.1
  FN_tribunal_1_N : N ; -- FN-tribunal..nn.1
  Facebookbild_1_N : N ; -- Facebookbild..nn.1
  Facebookgrupp_1_N : N ; -- Facebookgrupp..nn.1
  Falubo_1_N : N ; -- Falubo..nn.1
  Fia_1_N : N ; -- Fia..nn.1
  Finans_1_N : N ; -- Finans..nn.1
  Fisk_1_N : N ; -- Fisk..nn.1
  Foppatoffel_1_N : N ; -- Foppatoffel..nn.1
  Frankenstein_1_N : N ; -- Frankenstein..nn.1
  Frimurareorden_1_N : N ; -- Frimurareorden..nn.1
  Frimurarorden_1_N : N ; -- Frimurarorden..nn.1
  G_kraft_1_N : N ; -- G-kraft..nn.1
  G_punkt_1_N : N ; -- G-punkt..nn.1
  GPS_a_1_V : V ; -- GPS-a..vb.1
  GPSa_1_V : V ; -- GPSa..vb.1
  GPSa_2_V : V ; -- GPSa..vb.2
  Gadaffitrogen_1_A : A ; -- Gadaffitrogen..av.1
  Gnosjöanda_1_N : N ; -- Gnosjöanda..nn.1
  Golgatavandring_1_N : N ; -- Golgatavandring..nn.1
  Gotlandsfärja_1_N : N ; -- Gotlandsfärja..nn.1
  Greenwichmeridian_1_N : N ; -- Greenwichmeridian..nn.1
  Gripenplan_1_N : N ; -- Gripenplan..nn.1
  Gävlebo_1_N : N ; -- Gävlebo..nn.1
  Göteborgsmålare_1_N : N ; -- Göteborgsmålare..nn.1
  Hagasessa_1_N : N ; -- Hagasessa..nn.1
  Hausdorffdimension_1_N : N ; -- Hausdorffdimension..nn.1
  Havanna_1_N : N ; -- Havanna..nn.1
  Havannacigarr_1_N : N ; -- Havannacigarr..nn.1
  Helsingforsvän_1_N : N ; -- Helsingforsvän..nn.1
  Higgsboson_1_N : N ; -- Higgsboson..nn.1
  Higgspartikel_1_N : N ; -- Higgspartikel..nn.1
  Hiroshimabomb_1_N : N ; -- Hiroshimabomb..nn.1
  Hitchcockfilm_1_N : N ; -- Hitchcockfilm..nn.1
  Hollywoodfru_1_N : N ; -- Hollywoodfru..nn.1
  Hultsfredsfestival_1_N : N ; -- Hultsfredsfestival..nn.1
  Hårgalåt_1_N : N ; -- Hårgalåt..nn.1
  I_land_1_N : N ; -- I-land..nn.1
  IB_avslöjande_1_N : N ; -- IB-avslöjande..nn.1
  IC_krets_1_N : N ; -- IC-krets..nn.1
  ID_bricka_1_N : N ; -- ID-bricka..nn.1
  ID_kort_1_N : N ; -- ID-kort..nn.1
  IKEA_möbel_1_N : N ; -- IKEA-möbel..nn.1
  IP_nummer_1_N : N ; -- IP-nummer..nn.1
  IT_företag_1_N : N ; -- IT-företag..nn.1
  IT_jätte_1_N : N ; -- IT-jätte..nn.1
  Ikeavaruhus_1_N : N ; -- Ikeavaruhus..nn.1
  Internet_1_N : N ; -- Internet..nn.1
  Jacksoninspirerad_1_A : A ; -- Jacksoninspirerad..av.1
  Jantelag_1_N : N ; -- Jantelag..nn.1
  Japanoro_1_N : N ; -- Japanoro..nn.1
  Jungfru_1_N : N ; -- Jungfru..nn.1
  Jupitermåne_1_N : N ; -- Jupitermåne..nn.1
  K_märka_1_V : V ; -- K-märka..vb.1
  K_märkande_1_N : N ; -- K-märkande..nn.1
  KU_anmäla_1_V : V ; -- KU-anmäla..vb.1
  Kafkaartad_1_A : A ; -- Kafkaartad..av.1
  Kafkaesk_1_A : A ; -- Kafkaesk..av.1
  Kafkalik_1_A : A ; -- Kafkalik..av.1
  Kafkastämning_1_N : N ; -- Kafkastämning..nn.1
  Kairobesök_1_N : N ; -- Kairobesök..nn.1
  Kalmarbo_1_N : N ; -- Kalmarbo..nn.1
  Karlstadsbo_1_N : N ; -- Karlstadsbo..nn.1
  Katynmassaker_1_N : N ; -- Katynmassaker..nn.1
  Kevlar_1_N : N ; -- Kevlar..nn.1
  Kinabesök_1_N : N ; -- Kinabesök..nn.1
  Kirunatrakt_1_N : N ; -- Kirunatrakt..nn.1
  Kleopatragestalt_1_N : N ; -- Kleopatragestalt..nn.1
  Koranbränning_1_N : N ; -- Koranbränning..nn.1
  Koranbål_1_N : N ; -- Koranbål..nn.1
  Koreakrig_1_N : N ; -- Koreakrig..nn.1
  Kramforstrakt_1_N : N ; -- Kramforstrakt..nn.1
  Kremldirektiv_1_N : N ; -- Kremldirektiv..nn.1
  Krimkrig_1_N : N ; -- Krimkrig..nn.1
  Kräfta_2_N : N ; -- Kräfta..nn.2
  Kubakris_1_N : N ; -- Kubakris..nn.1
  Köchelnummer_1_N : N ; -- Köchelnummer..nn.1
  Köpenhamnsackord_1_N : N ; -- Köpenhamnsackord..nn.1
  LCD_skärm_1_N : N ; -- LCD-skärm..nn.1
  LCD_teve_1_N : N ; -- LCD-teve..nn.1
  LED_belysning_1_N : N ; -- LED-belysning..nn.1
  LED_lampa_1_N : N ; -- LED-lampa..nn.1
  LKAB_konflikt_1_N : N ; -- LKAB-konflikt..nn.1
  LO_chef_1_N : N ; -- LO-chef..nn.1
  LO_ordförande_1_N : N ; -- LO-ordförande..nn.1
  Lejon_1_N : N ; -- Lejon..nn.1
  Linköpingsbo_1_N : N ; -- Linköpingsbo..nn.1
  Linnélärjunge_1_N : N ; -- Linnélärjunge..nn.1
  Lissabonfördrag_1_N : N ; -- Lissabonfördrag..nn.1
  Livsmedelsverk_1_N : N ; -- Livsmedelsverk..nn.1
  Ljubjankafängelse_1_N : N ; -- Ljubjankafängelse..nn.1
  Londonbaserad_1_A : A ; -- Londonbaserad..av.1
  Lulebo_1_N : N ; -- Lulebo..nn.1
  Luleåbo_1_N : N ; -- Luleåbo..nn.1
  MAO_aktivitet_1_N : N ; -- MAO-aktivitet..nn.1
  MAO_enzym_1_N : N ; -- MAO-enzym..nn.1
  MEFA_1_N : N ; -- MEFA..nn.1
  MP3_bok_1_N : N ; -- MP3-bok..nn.1
  MP3_spelare_1_N : N ; -- MP3-spelare..nn.1
  Malmöbo_1_N : N ; -- Malmöbo..nn.1
  Malmökafé_1_N : N ; -- Malmökafé..nn.1
  Marseillebaserad_1_A : A ; -- Marseillebaserad..av.1
  Marsresa_1_N : N ; -- Marsresa..nn.1
  Marylandaccent_1_N : N ; -- Marylandaccent..nn.1
  Mecka_1_N : N ; -- Mecka..nn.1
  Medelhavsinspirerad_1_A : A ; -- Medelhavsinspirerad..av.1
  Medelhavsland_1_N : N ; -- Medelhavsland..nn.1
  Medelshavskultur_1_N : N ; -- Medelshavskultur..nn.1
  Mellanösternkonflikt_1_N : N ; -- Mellanösternkonflikt..nn.1
  Mello_1_N : N ; -- Mello..nn.1
  Melodifestival_1_N : N ; -- Melodifestival..nn.1
  Merca_1_N : N ; -- Merca..nn.1
  Mercedes_1_N : N ; -- Mercedes..nn.1
  Mersa_1_N : N ; -- Mersa..nn.1
  Metallordförande_1_N : N ; -- Metallordförande..nn.1
  Migrationsverk_1_N : N ; -- Migrationsverk..nn.1
  Miljöförvaltning_1_N : N ; -- Miljöförvaltning..nn.1
  Mississippiflod_1_N : N ; -- Mississippiflod..nn.1
  Missouriflod_1_N : N ; -- Missouriflod..nn.1
  Monopol_1_N : N ; -- Monopol..nn.1
  Montessoriskola_1_N : N ; -- Montessoriskola..nn.1
  Mosebok_1_N : N ; -- Mosebok..nn.1
  Moskvaborgmästare_1_N : N ; -- Moskvaborgmästare..nn.1
  Moskvatrogen_1_A : A ; -- Moskvatrogen..av.1
  Moskvatrogenhet_1_N : N ; -- Moskvatrogenhet..nn.1
  Moskvavänlig_1_A : A ; -- Moskvavänlig..av.1
  Moskvavänlighet_1_N : N ; -- Moskvavänlighet..nn.1
  Moskvich_1_N : N ; -- Moskvich..nn.1
  Moskvitj_1_N : N ; -- Moskvitj..nn.1
  Muhammedkarikatyr_1_N : N ; -- Muhammedkarikatyr..nn.1
  Munchlitografi_1_N : N ; -- Munchlitografi..nn.1
  Mångfaldsbarometer_1_N : N ; -- Mångfaldsbarometer..nn.1
  NSA_läcka_1_N : N ; -- NSA-läcka..nn.1
  Nationalencyklopedi_1_N : N ; -- Nationalencyklopedi..nn.1
  Natohelikopter_1_N : N ; -- Natohelikopter..nn.1
  Natoledd_1_A : A ; -- Natoledd..av.1
  Natomedlemskap_1_N : N ; -- Natomedlemskap..nn.1
  Natosoldat_1_N : N ; -- Natosoldat..nn.1
  Natotrupp_1_N : N ; -- Natotrupp..nn.1
  Naturvårdsverk_1_N : N ; -- Naturvårdsverk..nn.1
  Newcastlesjuka_1_N : N ; -- Newcastlesjuka..nn.1
  Newcastlesmitta_1_N : N ; -- Newcastlesmitta..nn.1
  Nobelpriskandidat_1_N : N ; -- Nobelpriskandidat..nn.1
  Nordpolsexpedition_1_N : N ; -- Nordpolsexpedition..nn.1
  Norrmalmstorgssyndrom_1_N : N ; -- Norrmalmstorgssyndrom..nn.1
  OCR_a_1_V : V ; -- OCR-a..vb.1
  OCR_ande_1_N : N ; -- OCR-ande..nn.1
  OCRa_1_V : V ; -- OCRa..vb.1
  OCRande_1_N : N ; -- OCRande..nn.1
  OECD_land_1_N : N ; -- OECD-land..nn.1
  OK_1_A : A ; -- OK..av.1
  Oscarsbelönad_1_A : A ; -- Oscarsbelönad..av.1
  Oscarsnominerad_1_A : A ; -- Oscarsnominerad..av.1
  Osloavtal_1_N : N ; -- Osloavtal..nn.1
  Othello_1_N : N ; -- Othello..nn.1
  Oxe_1_N : N ; -- Oxe..nn.1
  Oxfordkommatering_1_N : N ; -- Oxfordkommatering..nn.1
  Oxfordstudent_1_N : N ; -- Oxfordstudent..nn.1
  PCB_förbud_1_N : N ; -- PCB-förbud..nn.1
  PCB_förening_1_N : N ; -- PCB-förening..nn.1
  PCB_förgiftning_1_N : N ; -- PCB-förgiftning..nn.1
  PCB_halt_1_N : N ; -- PCB-halt..nn.1
  PCB_olja_1_N : N ; -- PCB-olja..nn.1
  PIN_kod_1_N : N ; -- PIN-kod..nn.1
  PR_kupp_1_N : N ; -- PR-kupp..nn.1
  PR_man_1_N : N ; -- PR-man..nn.1
  PRkupp_1_N : N ; -- PRkupp..nn.1
  PVC_beläggning_1_N : N ; -- PVC-beläggning..nn.1
  Palestinafråga_1_N : N ; -- Palestinafråga..nn.1
  Palmehat_1_N : N ; -- Palmehat..nn.1
  Papyrusaktie_1_N : N ; -- Papyrusaktie..nn.1
  Parisflygplats_1_N : N ; -- Parisflygplats..nn.1
  Patentverk_1_N : N ; -- Patentverk..nn.1
  Pippiinspirerad_1_A : A ; -- Pippiinspirerad..av.1
  PowerPoint_1_N : N ; -- PowerPoint..nn.1
  Powerpoint_1_N : N ; -- Powerpoint..nn.1
  QR_kod_1_N : N ; -- QR-kod..nn.1
  ROT_avdrag_1_N : N ; -- ROT-avdrag..nn.1
  RUT_avdrag_1_N : N ; -- RUT-avdrag..nn.1
  Rembrandt_1_N : N ; -- Rembrandt..nn.1
  Rikspolisstyrelse_1_N : N ; -- Rikspolisstyrelse..nn.1
  Rioja_1_N : N ; -- Rioja..nn.1
  Risk_1_N : N ; -- Risk..nn.1
  Rolls_1_N : N ; -- Rolls..nn.1
  Romeo_och_Julia_strategi_1_N : N ; -- Romeo-och-Julia-strategi..nn.1
  SAP_program_1_N : N ; -- SAP-program..nn.1
  SAS_chef_1_N : N ; -- SAS-chef..nn.1
  SAS_flygvärdinna_1_N : N ; -- SAS-flygvärdinna..nn.1
  SCOPE_rapport_1_N : N ; -- SCOPE-rapport..nn.1
  SIFO_undersökning_1_N : N ; -- SIFO-undersökning..nn.1
  SIM_kort_1_N : N ; -- SIM-kort..nn.1
  SMSa_1_V : V ; -- SMSa..vb.1
  Saab_1_N : N ; -- Saab..nn.1
  Salazar_regim_1_N : N ; -- Salazar-regim..nn.1
  Shakespearedrama_1_N : N ; -- Shakespearedrama..nn.1
  Sheratonstil_1_N : N ; -- Sheratonstil..nn.1
  Sifoundersökning_1_N : N ; -- Sifoundersökning..nn.1
  Sir_1_N : N ; -- Sir..nn.1
  Sjöfartsverk_1_N : N ; -- Sjöfartsverk..nn.1
  Skagenmålare_1_N : N ; -- Skagenmålare..nn.1
  Skolinspektion_1_N : N ; -- Skolinspektion..nn.1
  Skolverk_1_N : N ; -- Skolverk..nn.1
  Skorpion_1_N : N ; -- Skorpion..nn.1
  Skytt_1_N : N ; -- Skytt..nn.1
  Sokratesdialog_1_N : N ; -- Sokratesdialog..nn.1
  Sovjetsystem_1_N : N ; -- Sovjetsystem..nn.1
  Stadsbyggnadskontor_1_N : N ; -- Stadsbyggnadskontor..nn.1
  Stasiagent_1_N : N ; -- Stasiagent..nn.1
  Stasianställd_1_A : A ; -- Stasianställd..av.1
  Statoilmack_1_N : N ; -- Statoilmack..nn.1
  Statskontor_1_N : N ; -- Statskontor..nn.1
  Stenbock_1_N : N ; -- Stenbock..nn.1
  Stillahavsfiske_1_N : N ; -- Stillahavsfiske..nn.1
  Stillahavsskvadron_1_N : N ; -- Stillahavsskvadron..nn.1
  Stockholmsarena_1_N : N ; -- Stockholmsarena..nn.1
  Stockholmsbörs_1_N : N ; -- Stockholmsbörs..nn.1
  Stockholmsfotograf_1_N : N ; -- Stockholmsfotograf..nn.1
  Stockholmsguide_1_N : N ; -- Stockholmsguide..nn.1
  Stockholmshelg_1_N : N ; -- Stockholmshelg..nn.1
  Stockholmsmässig_1_A : A ; -- Stockholmsmässig..av.1
  Stockholmsområde_1_N : N ; -- Stockholmsområde..nn.1
  Stockholmsregion_1_N : N ; -- Stockholmsregion..nn.1
  Stockholmssyndrom_1_N : N ; -- Stockholmssyndrom..nn.1
  Stockholmstrakt_1_N : N ; -- Stockholmstrakt..nn.1
  Strindbergsutgåva_1_N : N ; -- Strindbergsutgåva..nn.1
  Strålsäkerhetsmyndighet_1_N : N ; -- Strålsäkerhetsmyndighet..nn.1
  Sturemord_1_N : N ; -- Sturemord..nn.1
  Stureplansmördare_1_N : N ; -- Stureplansmördare..nn.1
  Stureplansprofil_1_N : N ; -- Stureplansprofil..nn.1
  Sundsvallsbo_1_N : N ; -- Sundsvallsbo..nn.1
  Svensson_1_N : N ; -- Svensson..nn.1
  Sverigedemokrat_1_N : N ; -- Sverigedemokrat..nn.1
  Sverigemästerskap_1_N : N ; -- Sverigemästerskap..nn.1
  Södermalmsbo_1_N : N ; -- Södermalmsbo..nn.1
  Södermalmvåning_1_N : N ; -- Södermalmvåning..nn.1
  T_shirt_1_N : N ; -- T-shirt..nn.1
  T_sprit_1_N : N ; -- T-sprit..nn.1
  T_tröja_1_N : N ; -- T-tröja..nn.1
  TV_abonnemang_1_N : N ; -- TV-abonnemang..nn.1
  TV_antenn_1_N : N ; -- TV-antenn..nn.1
  TV_apparat_1_N : N ; -- TV-apparat..nn.1
  TV_bild_1_N : N ; -- TV-bild..nn.1
  TV_chef_1_N : N ; -- TV-chef..nn.1
  TV_evangelist_1_N : N ; -- TV-evangelist..nn.1
  TV_intervju_1_N : N ; -- TV-intervju..nn.1
  TV_kamera_1_N : N ; -- TV-kamera..nn.1
  TV_kanal_1_N : N ; -- TV-kanal..nn.1
  TV_konferens_1_N : N ; -- TV-konferens..nn.1
  TV_leverantör_1_N : N ; -- TV-leverantör..nn.1
  TV_mast_1_N : N ; -- TV-mast..nn.1
  TV_meteorolog_1_N : N ; -- TV-meteorolog..nn.1
  TV_mottagare_1_N : N ; -- TV-mottagare..nn.1
  TV_nyhet_1_N : N ; -- TV-nyhet..nn.1
  TV_predikant_1_N : N ; -- TV-predikant..nn.1
  TV_producent_1_N : N ; -- TV-producent..nn.1
  TV_profil_1_N : N ; -- TV-profil..nn.1
  TV_program_1_N : N ; -- TV-program..nn.1
  TV_reklam_1_N : N ; -- TV-reklam..nn.1
  TV_reparatör_1_N : N ; -- TV-reparatör..nn.1
  TV_ruta_1_N : N ; -- TV-ruta..nn.1
  TV_serie_1_N : N ; -- TV-serie..nn.1
  TV_signal_1_N : N ; -- TV-signal..nn.1
  TV_skärm_1_N : N ; -- TV-skärm..nn.1
  TV_soffa_1_N : N ; -- TV-soffa..nn.1
  TV_studio_1_N : N ; -- TV-studio..nn.1
  TV_sändare_1_N : N ; -- TV-sändare..nn.1
  TV_sändning_1_N : N ; -- TV-sändning..nn.1
  TV_såpa_1_N : N ; -- TV-såpa..nn.1
  TV_tittande_1_N : N ; -- TV-tittande..nn.1
  TV_tittare_1_N : N ; -- TV-tittare..nn.1
  TV_övervakning_1_N : N ; -- TV-övervakning..nn.1
  Tarzanfilm_1_N : N ; -- Tarzanfilm..nn.1
  Telialand_1_N : N ; -- Telialand..nn.1
  Teutoburgerslag_1_N : N ; -- Teutoburgerslag..nn.1
  Tjernobylnedfall_1_N : N ; -- Tjernobylnedfall..nn.1
  Tjernobylolycka_1_N : N ; -- Tjernobylolycka..nn.1
  Tokyobörs_1_N : N ; -- Tokyobörs..nn.1
  Trafikkontor_1_N : N ; -- Trafikkontor..nn.1
  Trafiksäkerhetsverk_1_N : N ; -- Trafiksäkerhetsverk..nn.1
  Tvilling_1_N : N ; -- Tvilling..nn.1
  Törnrosasömn_1_N : N ; -- Törnrosasömn..nn.1
  U_land_1_N : N ; -- U-land..nn.1
  U_sväng_1_N : N ; -- U-sväng..nn.1
  USA_vänlig_1_A : A ; -- USA-vänlig..av.1
  USA_vänlighet_1_N : N ; -- USA-vänlighet..nn.1
  USB_minne_1_N : N ; -- USB-minne..nn.1
  USB_sladd_1_N : N ; -- USB-sladd..nn.1
  Uno_1_N : N ; -- Uno..nn.1
  Uppsalabo_1_N : N ; -- Uppsalabo..nn.1
  VAB_dag_1_N : N ; -- VAB-dag..nn.1
  VAB_1_N : N ; -- VAB..nn.1
  VABB_dag_1_N : N ; -- VABB-dag..nn.1
  VABB_1_N : N ; -- VABB..nn.1
  VVS_armatur_1_N : N ; -- VVS-armatur..nn.1
  Vadstenadiarium_1_N : N ; -- Vadstenadiarium..nn.1
  Vattuman_1_N : N ; -- Vattuman..nn.1
  Vaxholmskonflikt_1_N : N ; -- Vaxholmskonflikt..nn.1
  Vellingemoderat_1_N : N ; -- Vellingemoderat..nn.1
  Viagra_1_N : N ; -- Viagra..nn.1
  Vietnamkrig_1_N : N ; -- Vietnamkrig..nn.1
  Vietnampolitik_1_N : N ; -- Vietnampolitik..nn.1
  Vietnamveteran_1_N : N ; -- Vietnamveteran..nn.1
  Visa_kort_1_N : N ; -- Visa-kort..nn.1
  Visakort_1_N : N ; -- Visakort..nn.1
  Visbyvecka_1_N : N ; -- Visbyvecka..nn.1
  Volkswagenbuss_1_N : N ; -- Volkswagenbuss..nn.1
  Volvo_1_N : N ; -- Volvo..nn.1
  Volvoanställd_1_A : A ; -- Volvoanställd..av.1
  Vädur_1_N : N ; -- Vädur..nn.1
  Vägverk_1_N : N ; -- Vägverk..nn.1
  Världsbank_1_N : N ; -- Världsbank..nn.1
  Världsnaturfond_1_N : N ; -- Världsnaturfond..nn.1
  Vätternrunda_1_N : N ; -- Vätternrunda..nn.1
  Växjötrakt_1_N : N ; -- Växjötrakt..nn.1
  Våg_1_N : N ; -- Våg..nn.1
  X_formad_1_A : A ; -- X-formad..av.1
  X_formig_1_A : A ; -- X-formig..av.1
  X_kromosom_1_N : N ; -- X-kromosom..nn.1
  Xformad_1_A : A ; -- Xformad..av.1
  Xformig_1_A : A ; -- Xformig..av.1
  Y_kromosom_1_N : N ; -- Y-kromosom..nn.1
  Yalelås_1_N : N ; -- Yalelås..nn.1
  Yatzy_1_N : N ; -- Yatzy..nn.1
  Z_partikel_1_N : N ; -- Z-partikel..nn.1
  Zlatan_groda_1_N : N ; -- Zlatan-groda..nn.1
  _00_tal_1_N : N ; -- _00-tal..nn.1
  _1100_tal_1_N : N ; -- _1100-tal..nn.1
  _12_kanthylsa_1_N : N ; -- _12-kanthylsa..nn.1
  _12_kantshylsa_1_N : N ; -- _12-kantshylsa..nn.1
  _1200_tal_1_N : N ; -- _1200-tal..nn.1
  _1300_tal_1_N : N ; -- _1300-tal..nn.1
  _1400_tal_1_N : N ; -- _1400-tal..nn.1
  _15_årsstraff_1_N : N ; -- _15-årsstraff..nn.1
  _1500_tal_1_N : N ; -- _1500-tal..nn.1
  _1600_tal_1_N : N ; -- _1600-tal..nn.1
  _1700_tal_1_N : N ; -- _1700-tal..nn.1
  _1800_tal_1_N : N ; -- _1800-tal..nn.1
  _1800_talsmode_1_N : N ; -- _1800-talsmode..nn.1
  _1870_tal_1_N : N ; -- _1870-tal..nn.1
  _1880_tal_1_N : N ; -- _1880-tal..nn.1
  _1890_tal_1_N : N ; -- _1890-tal..nn.1
  _1900_tal_1_N : N ; -- _1900-tal..nn.1
  _1910_tal_1_N : N ; -- _1910-tal..nn.1
  _1920_tal_1_N : N ; -- _1920-tal..nn.1
  _1930_tal_1_N : N ; -- _1930-tal..nn.1
  _1940_tal_1_N : N ; -- _1940-tal..nn.1
  _1950_tal_1_N : N ; -- _1950-tal..nn.1
  _1960_tal_1_N : N ; -- _1960-tal..nn.1
  _1970_tal_1_N : N ; -- _1970-tal..nn.1
  _1980_tal_1_N : N ; -- _1980-tal..nn.1
  _1990_tal_1_N : N ; -- _1990-tal..nn.1
  _2_taktsolja_1_N : N ; -- _2-taktsolja..nn.1
  _20_tal_1_N : N ; -- _20-tal..nn.1
  _2000_tal_1_N : N ; -- _2000-tal..nn.1
  _3_fasström_1_N : N ; -- _3-fasström..nn.1
  _30_tal_1_N : N ; -- _30-tal..nn.1
  _40_tal_1_N : N ; -- _40-tal..nn.1
  _40_åring_1_N : N ; -- _40-åring..nn.1
  _5_armad_1_A : A ; -- _5-armad..av.1
  _5_punktslaser_1_N : N ; -- _5-punktslaser..nn.1
  _50_tal_1_N : N ; -- _50-tal..nn.1
  _50_talsinspirerad_1_A : A ; -- _50-talsinspirerad..av.1
  _60_tal_1_N : N ; -- _60-tal..nn.1
  _60_årsjubileum_1_N : N ; -- _60-årsjubileum..nn.1
  _7_armad_1_A : A ; -- _7-armad..av.1
  _70_tal_1_N : N ; -- _70-tal..nn.1
  _80_tal_1_N : N ; -- _80-tal..nn.1
  _90_tal_1_N : N ; -- _90-tal..nn.1
  _95_oktanig_1_A : A ; -- _95-oktanig..av.1
  a_bomb_1_N : N ; -- a-bomb..nn.1
  a_kassa_1_N : N ; -- a-kassa..nn.1
  a_vitaminbrist_1_N : N ; -- a-vitaminbrist..nn.1
  abakus_1_N : N ; -- abakus..nn.1
  abalone_1_N : N ; -- abalone..nn.1
  abandon_1_N : N ; -- abandon..nn.1
  abbedissa_1_N : N ; -- abbedissa..nn.1
  abborre_1_N : N ; -- abborre..nn.1
  abborrfisk_1_N : N ; -- abborrfisk..nn.1
  abborrliknande_1_A : A ; -- abborrliknande..av.1
  abborrpinne_1_N : N ; -- abborrpinne..nn.1
  abbot_1_N : N ; -- abbot..nn.1
  abbotlig_1_A : A ; -- abbotlig..av.1
  abbotskap_1_N : N ; -- abbotskap..nn.1
  abbotskloster_1_N : N ; -- abbotskloster..nn.1
  abbotsstav_1_N : N ; -- abbotsstav..nn.1
  abbotsstift_1_N : N ; -- abbotsstift..nn.1
  abbotsvärdighet_1_N : N ; -- abbotsvärdighet..nn.1
  abbreviation_1_N : N ; -- abbreviation..nn.1
  abbreviatur_1_N : N ; -- abbreviatur..nn.1
  abbreviera_1_V : V ; -- abbreviera..vb.1
  abbrevierande_1_N : N ; -- abbrevierande..nn.1
  abbrevierbar_1_A : A ; -- abbrevierbar..av.1
  abbrevierbarhet_1_N : N ; -- abbrevierbarhet..nn.1
  abbreviering_1_N : N ; -- abbreviering..nn.1
  abbé_1_N : N ; -- abbé..nn.1
  abc_bok_1_N : N ; -- abc-bok..nn.1
  abchazisk_1_A : A ; -- abchazisk..av.1
  abderitisk_1_A : A ; -- abderitisk..av.1
  abdikation_1_N : N ; -- abdikation..nn.1
  abdikationsakt_1_N : N ; -- abdikationsakt..nn.1
  abdikationshot_1_N : N ; -- abdikationshot..nn.1
  abdikera_1_V : V ; -- abdikera..vb.1
  abdikerande_1_N : N ; -- abdikerande..nn.1
  abdikerbar_1_A : A ; -- abdikerbar..av.1
  abdikerbarhet_1_N : N ; -- abdikerbarhet..nn.1
  abdikering_1_N : N ; -- abdikering..nn.1
  abdomen_1_N : N ; -- abdomen..nn.1
  abdominal_1_A : A ; -- abdominal..av.1
  abducensnervsjukdom_1_N : N ; -- abducensnervsjukdom..nn.1
  abducensnervskada_1_N : N ; -- abducensnervskada..nn.1
  aber_1_N : N ; -- aber..nn.1
  aberration_1_N : N ; -- aberration..nn.1
  abessinier_1_N : N ; -- abessinier..nn.1
  abessinsk_1_A : A ; -- abessinsk..av.1
  abessinska_1_N : N ; -- abessinska..nn.1
  abessiv_1_N : N ; -- abessiv..nn.1
  abetalipoproteinemi_1_N : N ; -- abetalipoproteinemi..nn.1
  abilitet_1_N : N ; -- abilitet..nn.1
  abiturient_1_N : N ; -- abiturient..nn.1
  abiturientexamen_1_N : N ; -- abiturientexamen..nn.1
  ablation_1_N : N ; -- ablation..nn.1
  ablativ_1_N : N ; -- ablativ..nn.1
  ablativform_1_N : N ; -- ablativform..nn.1
  abnorm_1_A : A ; -- abnorm..av.1
  abnormalitet_1_N : N ; -- abnormalitet..nn.1
  abnormitet_1_N : N ; -- abnormitet..nn.1
  abolition_1_N : N ; -- abolition..nn.1
  abolitionist_1_N : N ; -- abolitionist..nn.1
  abolitionistisk_1_A : A ; -- abolitionistisk..av.1
  abominabel_1_A : A ; -- abominabel..av.1
  abonnemang_1_N : N ; -- abonnemang..nn.1
  abonnemangspris_1_N : N ; -- abonnemangspris..nn.1
  abonnent_1_N : N ; -- abonnent..nn.1
  abonnera_1_V : V ; -- abonnera..vb.1
  abonnerande_1_N : N ; -- abonnerande..nn.1
  abonnerbar_1_A : A ; -- abonnerbar..av.1
  abonnerbarhet_1_N : N ; -- abonnerbarhet..nn.1
  abonnering_1_N : N ; -- abonnering..nn.1
  aborigin_1_N : N ; -- aborigin..nn.1
  aboriginer_1_N : N ; -- aboriginer..nn.1
  aboriginsk_1_A : A ; -- aboriginsk..av.1
  aborre_1_N : N ; -- aborre..nn.1
  abort_1_N : N ; -- abort..nn.1
  abortera_1_V : V ; -- abortera..vb.1
  aborterande_1_N : N ; -- aborterande..nn.1
  aborterbar_1_A : A ; -- aborterbar..av.1
  aborterbarhet_1_N : N ; -- aborterbarhet..nn.1
  abortering_1_N : N ; -- abortering..nn.1
  abortfråga_1_N : N ; -- abortfråga..nn.1
  abortiv_1_A : A ; -- abortiv..av.1
  abortmotstånd_1_N : N ; -- abortmotstånd..nn.1
  abortmotståndare_1_N : N ; -- abortmotståndare..nn.1
  abortpiller_1_N : N ; -- abortpiller..nn.1
  aborträtt_1_N : N ; -- aborträtt..nn.1
  abortrådgivning_1_N : N ; -- abortrådgivning..nn.1
  abortrådgivning_2_N : N ; -- abortrådgivning..nn.2
  abortör_1_N : N ; -- abortör..nn.1
  abradera_1_V : V ; -- abradera..vb.1
  abraderande_1_N : N ; -- abraderande..nn.1
  abraderbar_1_A : A ; -- abraderbar..av.1
  abraderbarhet_1_N : N ; -- abraderbarhet..nn.1
  abradering_1_N : N ; -- abradering..nn.1
  abrasion_1_N : N ; -- abrasion..nn.1
  abrovink_1_N : N ; -- abrovink..nn.1
  abrovinsch_1_N : N ; -- abrovinsch..nn.1
  abrupt_1_A : A ; -- abrupt..av.1
  abrupthet_1_N : N ; -- abrupthet..nn.1
  abscess_1_N : N ; -- abscess..nn.1
  abscessbildning_1_N : N ; -- abscessbildning..nn.1
  absens_1_N : N ; -- absens..nn.1
  absensepilepsi_1_N : N ; -- absensepilepsi..nn.1
  absid_1_N : N ; -- absid..nn.1
  absint_1_N : N ; -- absint..nn.1
  abskissa_1_N : N ; -- abskissa..nn.1
  absolut_1_A : A ; -- absolut..av.1
  absolutbelopp_1_N : N ; -- absolutbelopp..nn.1
  absoluthet_1_N : N ; -- absoluthet..nn.1
  absolution_1_N : N ; -- absolution..nn.1
  absolutism_1_N : N ; -- absolutism..nn.1
  absolutist_1_N : N ; -- absolutist..nn.1
  absolutistisk_1_A : A ; -- absolutistisk..av.1
  absolutiv_1_N : N ; -- absolutiv..nn.1
  absolutivobjekt_1_N : N ; -- absolutivobjekt..nn.1
  absolutivsubjekt_1_N : N ; -- absolutivsubjekt..nn.1
  absolvera_1_V : V ; -- absolvera..vb.1
  absolverande_1_N : N ; -- absolverande..nn.1
  absolverbar_1_A : A ; -- absolverbar..av.1
  absolverbarhet_1_N : N ; -- absolverbarhet..nn.1
  absolvering_1_N : N ; -- absolvering..nn.1
  absorbator_1_N : N ; -- absorbator..nn.1
  absorber_1_N : N ; -- absorber..nn.1
  absorbera_1_V : V ; -- absorbera..vb.1
  absorbera_2_V : V ; -- absorbera..vb.2
  absorberande_1_N : N ; -- absorberande..nn.1
  absorberbar_1_A : A ; -- absorberbar..av.1
  absorberbarhet_1_N : N ; -- absorberbarhet..nn.1
  absorbering_1_N : N ; -- absorbering..nn.1
  absorberingsförmåga_1_N : N ; -- absorberingsförmåga..nn.1
  absorption_1_N : N ; -- absorption..nn.1
  absorptionslinje_1_N : N ; -- absorptionslinje..nn.1
  abstinens_1_N : N ; -- abstinens..nn.1
  abstinenssyndrom_1_N : N ; -- abstinenssyndrom..nn.1
  abstrahera_1_V : V ; -- abstrahera..vb.1
  abstraherande_1_N : N ; -- abstraherande..nn.1
  abstraherbar_1_A : A ; -- abstraherbar..av.1
  abstraherbarhet_1_N : N ; -- abstraherbarhet..nn.1
  abstrahering_1_N : N ; -- abstrahering..nn.1
  abstrakt_1_A : A ; -- abstrakt..av.1
  abstrakt_1_N : N ; -- abstrakt..nn.1
  abstrakthet_1_N : N ; -- abstrakthet..nn.1
  abstraktion_1_N : N ; -- abstraktion..nn.1
  abstraktionsförmåga_1_N : N ; -- abstraktionsförmåga..nn.1
  abstraktändelse_1_N : N ; -- abstraktändelse..nn.1
  abstrus_1_A : A ; -- abstrus..av.1
  absurd_1_A : A ; -- absurd..av.1
  absurdhet_1_N : N ; -- absurdhet..nn.1
  absurdism_1_N : N ; -- absurdism..nn.1
  absurdistisk_1_A : A ; -- absurdistisk..av.1
  absurditet_1_N : N ; -- absurditet..nn.1
  abundans_1_N : N ; -- abundans..nn.1
  abundant_1_A : A ; -- abundant..av.1
  abyssal_1_A : A ; -- abyssal..av.1
  acanthamoebakeratit_1_N : N ; -- acanthamoebakeratit..nn.1
  accedera_1_V : V ; -- accedera..vb.1
  accederande_1_N : N ; -- accederande..nn.1
  accederbar_1_A : A ; -- accederbar..av.1
  accederbarhet_1_N : N ; -- accederbarhet..nn.1
  accedering_1_N : N ; -- accedering..nn.1
  acceleration_1_N : N ; -- acceleration..nn.1
  accelerationsfält_1_N : N ; -- accelerationsfält..nn.1
  accelerationslag_1_N : N ; -- accelerationslag..nn.1
  accelerator_1_N : N ; -- accelerator..nn.1
  acceleratormaskin_1_N : N ; -- acceleratormaskin..nn.1
  acceleratorsystem_1_N : N ; -- acceleratorsystem..nn.1
  accelerera_1_V : V ; -- accelerera..vb.1
  accelerera_2_V : V ; -- accelerera..vb.2
  accelererande_1_N : N ; -- accelererande..nn.1
  accelererbar_1_A : A ; -- accelererbar..av.1
  accelererbarhet_1_N : N ; -- accelererbarhet..nn.1
  accelerering_1_N : N ; -- accelerering..nn.1
  accent_1_N : N ; -- accent..nn.1
  accentbeteckning_1_N : N ; -- accentbeteckning..nn.1
  accentförskjutning_1_N : N ; -- accentförskjutning..nn.1
  accenttecken_1_N : N ; -- accenttecken..nn.1
  accentuera_1_V : V ; -- accentuera..vb.1
  accentuerande_1_N : N ; -- accentuerande..nn.1
  accentuerbar_1_A : A ; -- accentuerbar..av.1
  accentuerbarhet_1_N : N ; -- accentuerbarhet..nn.1
  accentuering_1_N : N ; -- accentuering..nn.1
  accept_1_N : N ; -- accept..nn.1
  accept_2_N : N ; -- accept..nn.2
  acceptabel_1_A : A ; -- acceptabel..av.1
  acceptans_1_N : N ; -- acceptans..nn.1
  acceptant_1_N : N ; -- acceptant..nn.1
  acceptera_1_V : V ; -- acceptera..vb.1
  accepterande_1_N : N ; -- accepterande..nn.1
  accepterbar_1_A : A ; -- accepterbar..av.1
  accepterbarhet_1_N : N ; -- accepterbarhet..nn.1
  acceptering_1_N : N ; -- acceptering..nn.1
  acceptkredit_1_N : N ; -- acceptkredit..nn.1
  acceptpris_1_N : N ; -- acceptpris..nn.1
  access_1_N : N ; -- access..nn.1
  accessa_1_V : V ; -- accessa..vb.1
  accessande_1_N : N ; -- accessande..nn.1
  accession_1_N : N ; -- accession..nn.1
  accessionskatalog_1_N : N ; -- accessionskatalog..nn.1
  accessoar_1_N : N ; -- accessoar..nn.1
  accessorisk_1_A : A ; -- accessorisk..av.1
  accesstid_1_N : N ; -- accesstid..nn.1
  accidens_1_N : N ; -- accidens..nn.1
  accidenstryck_1_N : N ; -- accidenstryck..nn.1
  accidentell_1_A : A ; -- accidentell..av.1
  accis_1_N : N ; -- accis..nn.1
  accisfri_1_A : A ; -- accisfri..av.1
  accispliktig_1_A : A ; -- accispliktig..av.1
  acerolakörsbär_1_N : N ; -- acerolakörsbär..nn.1
  acetaldehyd_1_N : N ; -- acetaldehyd..nn.1
  acetat_1_N : N ; -- acetat..nn.1
  aceton_1_N : N ; -- aceton..nn.1
  acetylen_1_N : N ; -- acetylen..nn.1
  acetylengas_1_N : N ; -- acetylengas..nn.1
  acetylenlampa_1_N : N ; -- acetylenlampa..nn.1
  acetylsalicylsyra_1_N : N ; -- acetylsalicylsyra..nn.1
  aciditet_1_N : N ; -- aciditet..nn.1
  acidos_1_N : N ; -- acidos..nn.1
  acinetobacterinfektion_1_N : N ; -- acinetobacterinfektion..nn.1
  acinärcellskarcinom_1_N : N ; -- acinärcellskarcinom..nn.1
  ackja_1_N : N ; -- ackja..nn.1
  acklamation_1_N : N ; -- acklamation..nn.1
  acklamationsval_1_N : N ; -- acklamationsval..nn.1
  acklimatisation_1_N : N ; -- acklimatisation..nn.1
  acklimatisera_1_V : V ; -- acklimatisera..vb.1
  acklimatiserande_1_N : N ; -- acklimatiserande..nn.1
  acklimatiserbar_1_A : A ; -- acklimatiserbar..av.1
  acklimatiserbarhet_1_N : N ; -- acklimatiserbarhet..nn.1
  acklimatisering_1_N : N ; -- acklimatisering..nn.1
  ackommodation_1_N : N ; -- ackommodation..nn.1
  ackommodationsförmåga_1_N : N ; -- ackommodationsförmåga..nn.1
  ackommodationsväxel_1_N : N ; -- ackommodationsväxel..nn.1
  ackommodera_1_V : V ; -- ackommodera..vb.1
  ackommoderande_1_N : N ; -- ackommoderande..nn.1
  ackommoderbar_1_A : A ; -- ackommoderbar..av.1
  ackommoderbarhet_1_N : N ; -- ackommoderbarhet..nn.1
  ackommodering_1_N : N ; -- ackommodering..nn.1
  ackompanjatör_1_N : N ; -- ackompanjatör..nn.1
  ackompanjemang_1_N : N ; -- ackompanjemang..nn.1
  ackompanjera_1_V : V ; -- ackompanjera..vb.1
  ackompanjerande_1_N : N ; -- ackompanjerande..nn.1
  ackompanjerbar_1_A : A ; -- ackompanjerbar..av.1
  ackompanjerbarhet_1_N : N ; -- ackompanjerbarhet..nn.1
  ackompanjering_1_N : N ; -- ackompanjering..nn.1
  ackord_1_N : N ; -- ackord..nn.1
  ackord_2_N : N ; -- ackord..nn.2
  ackordera_1_V : V ; -- ackordera..vb.1
  ackorderande_1_N : N ; -- ackorderande..nn.1
  ackorderbar_1_A : A ; -- ackorderbar..av.1
  ackorderbarhet_1_N : N ; -- ackorderbarhet..nn.1
  ackordering_1_N : N ; -- ackordering..nn.1
  ackordgrepp_1_N : N ; -- ackordgrepp..nn.1
  ackordion_1_N : N ; -- ackordion..nn.1
  ackordlära_1_N : N ; -- ackordlära..nn.1
  ackordsarbete_1_N : N ; -- ackordsarbete..nn.1
  ackordshets_1_N : N ; -- ackordshets..nn.1
  ackordslön_1_N : N ; -- ackordslön..nn.1
  ackordssumma_1_N : N ; -- ackordssumma..nn.1
  ackordssättning_1_N : N ; -- ackordssättning..nn.1
  ackordsättning_1_N : N ; -- ackordsättning..nn.1
  ackreditera_1_V : V ; -- ackreditera..vb.1
  ackrediterande_1_N : N ; -- ackrediterande..nn.1
  ackrediterbar_1_A : A ; -- ackrediterbar..av.1
  ackrediterbarhet_1_N : N ; -- ackrediterbarhet..nn.1
  ackreditering_1_N : N ; -- ackreditering..nn.1
  ackumulation_1_N : N ; -- ackumulation..nn.1
  ackumulator_1_N : N ; -- ackumulator..nn.1
  ackumulera_1_V : V ; -- ackumulera..vb.1
  ackumulerande_1_N : N ; -- ackumulerande..nn.1
  ackumulerbar_1_A : A ; -- ackumulerbar..av.1
  ackumulerbarhet_1_N : N ; -- ackumulerbarhet..nn.1
  ackumulering_1_N : N ; -- ackumulering..nn.1
  ackurat_1_A : A ; -- ackurat..av.1
  ackuratess_1_N : N ; -- ackuratess..nn.1
  ackusativ_1_A : A ; -- ackusativ..av.1
  ackusativ_1_N : N ; -- ackusativ..nn.1
  ackusativobjekt_1_N : N ; -- ackusativobjekt..nn.1
  ackusativändelse_1_N : N ; -- ackusativändelse..nn.1
  ackusatorisk_1_A : A ; -- ackusatorisk..av.1
  ackuschör_1_N : N ; -- ackuschör..nn.1
  ackuschörska_1_N : N ; -- ackuschörska..nn.1
  ackvirera_1_V : V ; -- ackvirera..vb.1
  ackvirerande_1_N : N ; -- ackvirerande..nn.1
  ackvirerbar_1_A : A ; -- ackvirerbar..av.1
  ackvirerbarhet_1_N : N ; -- ackvirerbarhet..nn.1
  ackvirering_1_N : N ; -- ackvirering..nn.1
  ackvisition_1_N : N ; -- ackvisition..nn.1
  ackvisitionskatalog_1_N : N ; -- ackvisitionskatalog..nn.1
  ackvisitör_1_N : N ; -- ackvisitör..nn.1
  acne_1_N : N ; -- acne..nn.1
  actinobacillusinfektion_1_N : N ; -- actinobacillusinfektion..nn.1
  actinomycetalesinfektion_1_N : N ; -- actinomycetalesinfektion..nn.1
  action_1_N : N ; -- action..nn.1
  actionfilm_1_N : N ; -- actionfilm..nn.1
  actionrulle_1_N : N ; -- actionrulle..nn.1
  actionstjärna_1_N : N ; -- actionstjärna..nn.1
  adagio_1_N : N ; -- adagio..nn.1
  adagiosats_1_N : N ; -- adagiosats..nn.1
  adamantinom_1_N : N ; -- adamantinom..nn.1
  adamsdräkt_1_N : N ; -- adamsdräkt..nn.1
  adamsäpple_1_N : N ; -- adamsäpple..nn.1
  adaptation_1_N : N ; -- adaptation..nn.1
  adapter_1_N : N ; -- adapter..nn.1
  adaptera_1_V : V ; -- adaptera..vb.1
  adapterande_1_N : N ; -- adapterande..nn.1
  adapterbar_1_A : A ; -- adapterbar..av.1
  adapterbarhet_1_N : N ; -- adapterbarhet..nn.1
  adaptering_1_N : N ; -- adaptering..nn.1
  adaption_1_N : N ; -- adaption..nn.1
  adaptiv_1_A : A ; -- adaptiv..av.1
  addend_1_N : N ; -- addend..nn.1
  addenda_1_N : N ; -- addenda..nn.1
  addera_1_V : V ; -- addera..vb.1
  adderande_1_N : N ; -- adderande..nn.1
  adderbar_1_A : A ; -- adderbar..av.1
  adderbarhet_1_N : N ; -- adderbarhet..nn.1
  addering_1_N : N ; -- addering..nn.1
  addiktion_1_N : N ; -- addiktion..nn.1
  addiktolog_1_N : N ; -- addiktolog..nn.1
  additament_1_N : N ; -- additament..nn.1
  addition_1_N : N ; -- addition..nn.1
  additionstecken_1_N : N ; -- additionstecken..nn.1
  additiv_1_A : A ; -- additiv..av.1
  additiv_1_N : N ; -- additiv..nn.1
  adduktion_1_N : N ; -- adduktion..nn.1
  adekvat_1_A : A ; -- adekvat..av.1
  adel_1_N : N ; -- adel..nn.1
  adelsbrev_1_N : N ; -- adelsbrev..nn.1
  adelsdam_1_N : N ; -- adelsdam..nn.1
  adelsgods_1_N : N ; -- adelsgods..nn.1
  adelshem_1_N : N ; -- adelshem..nn.1
  adelshögfärd_1_N : N ; -- adelshögfärd..nn.1
  adelskalender_1_N : N ; -- adelskalender..nn.1
  adelskap_1_N : N ; -- adelskap..nn.1
  adelskrets_1_N : N ; -- adelskrets..nn.1
  adelskultur_1_N : N ; -- adelskultur..nn.1
  adelsman_1_N : N ; -- adelsman..nn.1
  adelsmatrikel_1_N : N ; -- adelsmatrikel..nn.1
  adelsmärke_1_N : N ; -- adelsmärke..nn.1
  adelsprivilegium_1_N : N ; -- adelsprivilegium..nn.1
  adelssläkt_1_N : N ; -- adelssläkt..nn.1
  adelsstånd_1_N : N ; -- adelsstånd..nn.1
  adelsätt_1_N : N ; -- adelsätt..nn.1
  adenit_1_N : N ; -- adenit..nn.1
  adenofibrom_1_N : N ; -- adenofibrom..nn.1
  adenoid_1_A : A ; -- adenoid..av.1
  adenoid_1_N : N ; -- adenoid..nn.1
  adenokarcinom_1_N : N ; -- adenokarcinom..nn.1
  adenolymfom_1_N : N ; -- adenolymfom..nn.1
  adenom_1_N : N ; -- adenom..nn.1
  adenomyoepiteliom_1_N : N ; -- adenomyoepiteliom..nn.1
  adenomyom_1_N : N ; -- adenomyom..nn.1
  adenophoreainfektion_1_N : N ; -- adenophoreainfektion..nn.1
  adenosarkom_1_N : N ; -- adenosarkom..nn.1
  adenovirusinfektion_1_N : N ; -- adenovirusinfektion..nn.1
  adept_1_N : N ; -- adept..nn.1
  adertonde_1_A : A ; -- adertonde..av.1
  adertonhundratal_1_N : N ; -- adertonhundratal..nn.1
  adessiv_1_N : N ; -- adessiv..nn.1
  adhd_symtom_1_N : N ; -- adhd-symtom..nn.1
  adherens_1_N : N ; -- adherens..nn.1
  adhesion_1_N : N ; -- adhesion..nn.1
  adhesionskraft_1_N : N ; -- adhesionskraft..nn.1
  adhesiv_1_A : A ; -- adhesiv..av.1
  adiabatisk_1_A : A ; -- adiabatisk..av.1
  adiafora_1_N : N ; -- adiafora..nn.1
  adiaforistisk_1_A : A ; -- adiaforistisk..av.1
  adidasgympasko_1_N : N ; -- adidasgympasko..nn.1
  adipositas_1_N : N ; -- adipositas..nn.1
  adjektiv_1_N : N ; -- adjektiv..nn.1
  adjektivattribut_1_N : N ; -- adjektivattribut..nn.1
  adjektivfras_1_N : N ; -- adjektivfras..nn.1
  adjektivisk_1_A : A ; -- adjektivisk..av.1
  adjektivistisk_1_A : A ; -- adjektivistisk..av.1
  adjektivändelse_1_N : N ; -- adjektivändelse..nn.1
  adjungera_1_V : V ; -- adjungera..vb.1
  adjungerande_1_N : N ; -- adjungerande..nn.1
  adjungerbar_1_A : A ; -- adjungerbar..av.1
  adjungerbarhet_1_N : N ; -- adjungerbarhet..nn.1
  adjungering_1_N : N ; -- adjungering..nn.1
  adjunkt_1_N : N ; -- adjunkt..nn.1
  adjunktion_1_N : N ; -- adjunktion..nn.1
  adjunktur_1_N : N ; -- adjunktur..nn.1
  adjutant_1_N : N ; -- adjutant..nn.1
  adjö_1_N : N ; -- adjö..nn.1
  adla_1_V : V ; -- adla..vb.1
  adlande_1_N : N ; -- adlande..nn.1
  adlig_1_A : A ; -- adlig..av.1
  adlighet_1_N : N ; -- adlighet..nn.1
  administration_1_N : N ; -- administration..nn.1
  administrativ_1_A : A ; -- administrativ..av.1
  administrator_1_N : N ; -- administrator..nn.1
  administratör_1_N : N ; -- administratör..nn.1
  administratörsstatus_1_N : N ; -- administratörsstatus..nn.1
  administrera_1_V : V ; -- administrera..vb.1
  administrerande_1_N : N ; -- administrerande..nn.1
  administrerbar_1_A : A ; -- administrerbar..av.1
  administrerbarhet_1_N : N ; -- administrerbarhet..nn.1
  administrering_1_N : N ; -- administrering..nn.1
  admonition_1_N : N ; -- admonition..nn.1
  adnexasjukdom_1_N : N ; -- adnexasjukdom..nn.1
  adnexit_1_N : N ; -- adnexit..nn.1
  adobe_1_N : N ; -- adobe..nn.1
  adolescens_1_N : N ; -- adolescens..nn.1
  adonis_1_N : N ; -- adonis..nn.1
  adonisgestalt_1_N : N ; -- adonisgestalt..nn.1
  adoptant_1_N : N ; -- adoptant..nn.1
  adoptera_1_V : V ; -- adoptera..vb.1
  adopterande_1_N : N ; -- adopterande..nn.1
  adopterbar_1_A : A ; -- adopterbar..av.1
  adopterbarhet_1_N : N ; -- adopterbarhet..nn.1
  adoptering_1_N : N ; -- adoptering..nn.1
  adoption_1_N : N ; -- adoption..nn.1
  adoptiv_1_A : A ; -- adoptiv..av.1
  adoptivbarn_1_N : N ; -- adoptivbarn..nn.1
  adoptivförälder_1_N : N ; -- adoptivförälder..nn.1
  adoptivson_1_N : N ; -- adoptivson..nn.1
  adoratör_1_N : N ; -- adoratör..nn.1
  adrenalin_1_N : N ; -- adrenalin..nn.1
  adrenalinkick_1_N : N ; -- adrenalinkick..nn.1
  adrenalinstinn_1_A : A ; -- adrenalinstinn..av.1
  adrenoleukodystrofi_1_N : N ; -- adrenoleukodystrofi..nn.1
  adrenomyeloneuropati_1_N : N ; -- adrenomyeloneuropati..nn.1
  adress_1_N : N ; -- adress..nn.1
  adressat_1_N : N ; -- adressat..nn.1
  adressbuss_1_N : N ; -- adressbuss..nn.1
  adressera_1_V : V ; -- adressera..vb.1
  adresserande_1_N : N ; -- adresserande..nn.1
  adresserbar_1_A : A ; -- adresserbar..av.1
  adresserbarhet_1_N : N ; -- adresserbarhet..nn.1
  adressering_1_N : N ; -- adressering..nn.1
  adresskalender_1_N : N ; -- adresskalender..nn.1
  adresskort_1_N : N ; -- adresskort..nn.1
  adresskälla_1_N : N ; -- adresskälla..nn.1
  adresslapp_1_N : N ; -- adresslapp..nn.1
  adriatisk_1_A : A ; -- adriatisk..av.1
  adsorbera_1_V : V ; -- adsorbera..vb.1
  adsorberande_1_N : N ; -- adsorberande..nn.1
  adsorberbar_1_A : A ; -- adsorberbar..av.1
  adsorberbarhet_1_N : N ; -- adsorberbarhet..nn.1
  adsorbering_1_N : N ; -- adsorbering..nn.1
  adsorption_1_N : N ; -- adsorption..nn.1
  adstringerande_1_A : A ; -- adstringerande..av.1
  aducera_1_V : V ; -- aducera..vb.1
  aducerande_1_N : N ; -- aducerande..nn.1
  aducerbar_1_A : A ; -- aducerbar..av.1
  aducerbarhet_1_N : N ; -- aducerbarhet..nn.1
  aducering_1_N : N ; -- aducering..nn.1
  advent_1_N : N ; -- advent..nn.1
  adventist_1_N : N ; -- adventist..nn.1
  adventistisk_1_A : A ; -- adventistisk..av.1
  adventiv_1_A : A ; -- adventiv..av.1
  adventskalender_1_N : N ; -- adventskalender..nn.1
  adventsljusstake_1_N : N ; -- adventsljusstake..nn.1
  adventsmys_1_N : N ; -- adventsmys..nn.1
  adventsstake_1_N : N ; -- adventsstake..nn.1
  adventsstjärna_1_N : N ; -- adventsstjärna..nn.1
  adverb_1_N : N ; -- adverb..nn.1
  adverbial_1_N : N ; -- adverbial..nn.1
  adverbialbestämning_1_N : N ; -- adverbialbestämning..nn.1
  adverbialsats_1_N : N ; -- adverbialsats..nn.1
  adverbiell_1_A : A ; -- adverbiell..av.1
  advers_1_N : N ; -- advers..nn.1
  adversativ_1_A : A ; -- adversativ..av.1
  advocera_1_V : V ; -- advocera..vb.1
  advocerande_1_N : N ; -- advocerande..nn.1
  advocerbar_1_A : A ; -- advocerbar..av.1
  advocerbarhet_1_N : N ; -- advocerbarhet..nn.1
  advocering_1_N : N ; -- advocering..nn.1
  advokat_1_N : N ; -- advokat..nn.1
  advokatbyrå_1_N : N ; -- advokatbyrå..nn.1
  advokatfiskal_1_N : N ; -- advokatfiskal..nn.1
  advokathjälp_1_N : N ; -- advokathjälp..nn.1
  advokatknep_1_N : N ; -- advokatknep..nn.1
  advokatkontor_1_N : N ; -- advokatkontor..nn.1
  advokatorisk_1_A : A ; -- advokatorisk..av.1
  advokatsamfund_1_N : N ; -- advokatsamfund..nn.1
  advokatstorm_1_N : N ; -- advokatstorm..nn.1
  advokatyr_1_N : N ; -- advokatyr..nn.1
  adxukiböna_1_N : N ; -- adxukiböna..nn.1
  aerob_1_A : A ; -- aerob..av.1
  aerobisk_1_A : A ; -- aerobisk..av.1
  aerodrom_1_N : N ; -- aerodrom..nn.1
  aerodynamik_1_N : N ; -- aerodynamik..nn.1
  aerodynamisk_1_A : A ; -- aerodynamisk..av.1
  aerofagi_1_N : N ; -- aerofagi..nn.1
  aerogel_1_N : N ; -- aerogel..nn.1
  aerogram_1_N : N ; -- aerogram..nn.1
  aerologi_1_N : N ; -- aerologi..nn.1
  aeromekanik_1_N : N ; -- aeromekanik..nn.1
  aeronaut_1_N : N ; -- aeronaut..nn.1
  aeronautik_1_N : N ; -- aeronautik..nn.1
  aeronautisk_1_A : A ; -- aeronautisk..av.1
  aeroplan_1_N : N ; -- aeroplan..nn.1
  aerosol_1_N : N ; -- aerosol..nn.1
  aerosolform_1_N : N ; -- aerosolform..nn.1
  aerostat_1_N : N ; -- aerostat..nn.1
  aerostatik_1_N : N ; -- aerostatik..nn.1
  aerostatisk_1_A : A ; -- aerostatisk..av.1
  afaki_1_N : N ; -- afaki..nn.1
  afasi_1_N : N ; -- afasi..nn.1
  afasisk_1_A : A ; -- afasisk..av.1
  afatiker_1_N : N ; -- afatiker..nn.1
  afatisk_1_A : A ; -- afatisk..av.1
  afelium_1_N : N ; -- afelium..nn.1
  affekt_1_N : N ; -- affekt..nn.1
  affektanfall_1_N : N ; -- affektanfall..nn.1
  affektation_1_N : N ; -- affektation..nn.1
  affekterad_1_A : A ; -- affekterad..av.1
  affektfri_1_A : A ; -- affektfri..av.1
  affektion_1_N : N ; -- affektion..nn.1
  affektionsvärde_1_N : N ; -- affektionsvärde..nn.1
  affektiv_1_A : A ; -- affektiv..av.1
  afficiera_1_V : V ; -- afficiera..vb.1
  afficierande_1_N : N ; -- afficierande..nn.1
  afficierbar_1_A : A ; -- afficierbar..av.1
  afficierbarhet_1_N : N ; -- afficierbarhet..nn.1
  afficiering_1_N : N ; -- afficiering..nn.1
  affidavit_1_N : N ; -- affidavit..nn.1
  affin_1_A : A ; -- affin..av.1
  affinage_1_N : N ; -- affinage..nn.1
  affinera_1_V : V ; -- affinera..vb.1
  affinerande_1_N : N ; -- affinerande..nn.1
  affinerbar_1_A : A ; -- affinerbar..av.1
  affinerbarhet_1_N : N ; -- affinerbarhet..nn.1
  affinering_1_N : N ; -- affinering..nn.1
  affinitet_1_N : N ; -- affinitet..nn.1
  affirmativ_1_A : A ; -- affirmativ..av.1
  affisch_1_N : N ; -- affisch..nn.1
  affischera_1_V : V ; -- affischera..vb.1
  affischerande_1_N : N ; -- affischerande..nn.1
  affischerbar_1_A : A ; -- affischerbar..av.1
  affischerbarhet_1_N : N ; -- affischerbarhet..nn.1
  affischering_1_N : N ; -- affischering..nn.1
  affischkampanj_1_N : N ; -- affischkampanj..nn.1
  affischmässig_1_A : A ; -- affischmässig..av.1
  affischnamn_1_N : N ; -- affischnamn..nn.1
  affischpelare_1_N : N ; -- affischpelare..nn.1
  affischstil_1_N : N ; -- affischstil..nn.1
  affischör_1_N : N ; -- affischör..nn.1
  affix_1_N : N ; -- affix..nn.1
  affrikata_1_N : N ; -- affrikata..nn.1
  affär_1_N : N ; -- affär..nn.1
  affärsavtal_1_N : N ; -- affärsavtal..nn.1
  affärsbank_1_N : N ; -- affärsbank..nn.1
  affärsbegåvning_1_N : N ; -- affärsbegåvning..nn.1
  affärsbegåvning_2_N : N ; -- affärsbegåvning..nn.2
  affärsbekant_1_N : N ; -- affärsbekant..nn.1
  affärsbiträde_1_N : N ; -- affärsbiträde..nn.1
  affärsbrev_1_N : N ; -- affärsbrev..nn.1
  affärsbyrå_1_N : N ; -- affärsbyrå..nn.1
  affärscentrum_1_N : N ; -- affärscentrum..nn.1
  affärsdistrikt_1_N : N ; -- affärsdistrikt..nn.1
  affärsdrivande_1_A : A ; -- affärsdrivande..av.1
  affärsfastighet_1_N : N ; -- affärsfastighet..nn.1
  affärsförbindelse_1_N : N ; -- affärsförbindelse..nn.1
  affärsföretag_1_N : N ; -- affärsföretag..nn.1
  affärsförslag_1_N : N ; -- affärsförslag..nn.1
  affärsgata_1_N : N ; -- affärsgata..nn.1
  affärsgeni_1_N : N ; -- affärsgeni..nn.1
  affärshandling_1_N : N ; -- affärshandling..nn.1
  affärshuvud_1_N : N ; -- affärshuvud..nn.1
  affärsidé_1_N : N ; -- affärsidé..nn.1
  affärskedja_1_N : N ; -- affärskedja..nn.1
  affärskvarter_1_N : N ; -- affärskvarter..nn.1
  affärsliv_1_N : N ; -- affärsliv..nn.1
  affärslokal_1_N : N ; -- affärslokal..nn.1
  affärsman_1_N : N ; -- affärsman..nn.1
  affärsmannamässig_1_A : A ; -- affärsmannamässig..av.1
  affärsmoral_1_N : N ; -- affärsmoral..nn.1
  affärsmässig_1_A : A ; -- affärsmässig..av.1
  affärsmässig_2_A : A ; -- affärsmässig..av.2
  affärsmässighet_1_N : N ; -- affärsmässighet..nn.1
  affärspapper_1_N : N ; -- affärspapper..nn.1
  affärsresa_1_N : N ; -- affärsresa..nn.1
  affärsresenär_1_N : N ; -- affärsresenär..nn.1
  affärsstil_1_N : N ; -- affärsstil..nn.1
  affärsstråk_1_N : N ; -- affärsstråk..nn.1
  affärsställning_1_N : N ; -- affärsställning..nn.1
  affärstid_1_N : N ; -- affärstid..nn.1
  affärstransaktion_1_N : N ; -- affärstransaktion..nn.1
  affärsuppgörelse_1_N : N ; -- affärsuppgörelse..nn.1
  affärsverk_1_N : N ; -- affärsverk..nn.1
  affärsverksamhet_1_N : N ; -- affärsverksamhet..nn.1
  affärsvärld_1_N : N ; -- affärsvärld..nn.1
  afghan_1_N : N ; -- afghan..nn.1
  afghansk_1_A : A ; -- afghansk..av.1
  afghanska_1_N : N ; -- afghanska..nn.1
  afghanska_2_N : N ; -- afghanska..nn.2
  afibrinogenemi_1_N : N ; -- afibrinogenemi..nn.1
  afoni_1_N : N ; -- afoni..nn.1
  aforism_1_N : N ; -- aforism..nn.1
  aforistiker_1_N : N ; -- aforistiker..nn.1
  aforistisk_1_A : A ; -- aforistisk..av.1
  afrikaans_1_N : N ; -- afrikaans..nn.1
  afrikainspirerad_1_A : A ; -- afrikainspirerad..av.1
  afrikan_1_N : N ; -- afrikan..nn.1
  afrikanisera_1_V : V ; -- afrikanisera..vb.1
  afrikaniserande_1_N : N ; -- afrikaniserande..nn.1
  afrikaniserbar_1_A : A ; -- afrikaniserbar..av.1
  afrikaniserbarhet_1_N : N ; -- afrikaniserbarhet..nn.1
  afrikanisering_1_N : N ; -- afrikanisering..nn.1
  afrikansk_1_A : A ; -- afrikansk..av.1
  afrikanska_1_N : N ; -- afrikanska..nn.1
  afro_asiatisk_1_A : A ; -- afro-asiatisk..av.1
  afroamerikan_1_N : N ; -- afroamerikan..nn.1
  afroamerikansk_1_A : A ; -- afroamerikansk..av.1
  afroasiatisk_1_A : A ; -- afroasiatisk..av.1
  afrodisiakum_1_N : N ; -- afrodisiakum..nn.1
  afrofobi_1_N : N ; -- afrofobi..nn.1
  afrofrisyr_1_N : N ; -- afrofrisyr..nn.1
  afrokam_1_N : N ; -- afrokam..nn.1
  afrosvensk_1_N : N ; -- afrosvensk..nn.1
  afton_1_N : N ; -- afton..nn.1
  aftonandakt_1_N : N ; -- aftonandakt..nn.1
  aftonbelysning_1_N : N ; -- aftonbelysning..nn.1
  aftonbrasa_1_N : N ; -- aftonbrasa..nn.1
  aftonbön_1_N : N ; -- aftonbön..nn.1
  aftondagg_1_N : N ; -- aftondagg..nn.1
  aftondräkt_1_N : N ; -- aftondräkt..nn.1
  aftonfjäril_1_N : N ; -- aftonfjäril..nn.1
  aftongudstjänst_1_N : N ; -- aftongudstjänst..nn.1
  aftonhandske_1_N : N ; -- aftonhandske..nn.1
  aftonhimmel_1_N : N ; -- aftonhimmel..nn.1
  aftonklänning_1_N : N ; -- aftonklänning..nn.1
  aftonkvist_1_N : N ; -- aftonkvist..nn.1
  aftonkyla_1_N : N ; -- aftonkyla..nn.1
  aftonluft_1_N : N ; -- aftonluft..nn.1
  aftonmål_1_N : N ; -- aftonmål..nn.1
  aftonmåltid_1_N : N ; -- aftonmåltid..nn.1
  aftonpipa_1_N : N ; -- aftonpipa..nn.1
  aftonplenum_1_N : N ; -- aftonplenum..nn.1
  aftonpromenad_1_N : N ; -- aftonpromenad..nn.1
  aftonpsalm_1_N : N ; -- aftonpsalm..nn.1
  aftonrodnad_1_N : N ; -- aftonrodnad..nn.1
  aftonsamkväm_1_N : N ; -- aftonsamkväm..nn.1
  aftonskola_1_N : N ; -- aftonskola..nn.1
  aftonskymning_1_N : N ; -- aftonskymning..nn.1
  aftonsol_1_N : N ; -- aftonsol..nn.1
  aftonstjärna_1_N : N ; -- aftonstjärna..nn.1
  aftonstund_1_N : N ; -- aftonstund..nn.1
  aftonstämning_1_N : N ; -- aftonstämning..nn.1
  aftonsång_1_N : N ; -- aftonsång..nn.1
  aftontidning_1_N : N ; -- aftontidning..nn.1
  aftontoalett_1_N : N ; -- aftontoalett..nn.1
  aftonunderhållning_1_N : N ; -- aftonunderhållning..nn.1
  aftonvard_1_N : N ; -- aftonvard..nn.1
  aftonvind_1_N : N ; -- aftonvind..nn.1
  aftonvisit_1_N : N ; -- aftonvisit..nn.1
  ag_1_N : N ; -- ag..nn.1
  aga_1_N : N ; -- aga..nn.1
  aga_2_N : N ; -- aga..nn.2
  aga_1_V : V ; -- aga..vb.1
  agammaglobulinemi_1_N : N ; -- agammaglobulinemi..nn.1
  agande_1_N : N ; -- agande..nn.1
  agar_1_N : N ; -- agar..nn.1
  agat_1_N : N ; -- agat..nn.1
  agatglas_1_N : N ; -- agatglas..nn.1
  agave_1_N : N ; -- agave..nn.1
  agenda_1_N : N ; -- agenda..nn.1
  agens_1_N : N ; -- agens..nn.1
  agent_1_N : N ; -- agent..nn.1
  agentfilm_1_N : N ; -- agentfilm..nn.1
  agentkontor_1_N : N ; -- agentkontor..nn.1
  agentskap_1_N : N ; -- agentskap..nn.1
  agentur_1_N : N ; -- agentur..nn.1
  agera_1_V : V ; -- agera..vb.1
  agera_2_V : V ; -- agera..vb.2
  agerande_1_N : N ; -- agerande..nn.1
  agerbar_1_A : A ; -- agerbar..av.1
  agerbarhet_1_N : N ; -- agerbarhet..nn.1
  ageusi_1_N : N ; -- ageusi..nn.1
  agg_1_N : N ; -- agg..nn.1
  aggande_1_A : A ; -- aggande..av.1
  aggfri_1_A : A ; -- aggfri..av.1
  agglomerat_1_N : N ; -- agglomerat..nn.1
  agglomeration_1_N : N ; -- agglomeration..nn.1
  agglomerera_1_V : V ; -- agglomerera..vb.1
  agglomererande_1_N : N ; -- agglomererande..nn.1
  agglomererbar_1_A : A ; -- agglomererbar..av.1
  agglomererbarhet_1_N : N ; -- agglomererbarhet..nn.1
  agglomerering_1_N : N ; -- agglomerering..nn.1
  agglutination_1_N : N ; -- agglutination..nn.1
  agglutinera_1_V : V ; -- agglutinera..vb.1
  agglutinerande_1_N : N ; -- agglutinerande..nn.1
  agglutinerbar_1_A : A ; -- agglutinerbar..av.1
  agglutinerbarhet_1_N : N ; -- agglutinerbarhet..nn.1
  agglutinering_1_N : N ; -- agglutinering..nn.1
  aggravera_1_V : V ; -- aggravera..vb.1
  aggregat_1_N : N ; -- aggregat..nn.1
  aggregation_1_N : N ; -- aggregation..nn.1
  aggregationsform_1_N : N ; -- aggregationsform..nn.1
  aggregationstillstånd_1_N : N ; -- aggregationstillstånd..nn.1
  aggression_1_N : N ; -- aggression..nn.1
  aggressionsbehov_1_N : N ; -- aggressionsbehov..nn.1
  aggressionshämning_1_N : N ; -- aggressionshämning..nn.1
  aggressiv_1_A : A ; -- aggressiv..av.1
  aggressivitet_1_N : N ; -- aggressivitet..nn.1
  agitation_1_N : N ; -- agitation..nn.1
  agitationsresa_1_N : N ; -- agitationsresa..nn.1
  agitationsvisa_1_N : N ; -- agitationsvisa..nn.1
  agitator_1_N : N ; -- agitator..nn.1
  agitatorisk_1_A : A ; -- agitatorisk..av.1
  agitera_1_V : V ; -- agitera..vb.1
  agiterande_1_N : N ; -- agiterande..nn.1
  agiterbar_1_A : A ; -- agiterbar..av.1
  agiterbarhet_1_N : N ; -- agiterbarhet..nn.1
  agitering_1_N : N ; -- agitering..nn.1
  agn_1_N : N ; -- agn..nn.1
  agna_1_V : V ; -- agna..vb.1
  agnande_1_N : N ; -- agnande..nn.1
  agnat_1_N : N ; -- agnat..nn.1
  agnatisk_1_A : A ; -- agnatisk..av.1
  agnblommig_1_A : A ; -- agnblommig..av.1
  agnborst_1_N : N ; -- agnborst..nn.1
  agnosi_1_N : N ; -- agnosi..nn.1
  agnosticism_1_N : N ; -- agnosticism..nn.1
  agnostiker_1_N : N ; -- agnostiker..nn.1
  agnostisk_1_A : A ; -- agnostisk..av.1
  agnrost_1_N : N ; -- agnrost..nn.1
  agogik_1_N : N ; -- agogik..nn.1
  agoni_1_N : N ; -- agoni..nn.1
  agonistisk_1_A : A ; -- agonistisk..av.1
  agorafobi_1_N : N ; -- agorafobi..nn.1
  agraff_1_N : N ; -- agraff..nn.1
  agrafi_1_N : N ; -- agrafi..nn.1
  agranulocytos_1_N : N ; -- agranulocytos..nn.1
  agrar_1_A : A ; -- agrar..av.1
  agrar_1_N : N ; -- agrar..nn.1
  agrarförbund_1_N : N ; -- agrarförbund..nn.1
  agrarkommunistisk_1_A : A ; -- agrarkommunistisk..av.1
  agrarpolitik_1_N : N ; -- agrarpolitik..nn.1
  agreabel_1_A : A ; -- agreabel..av.1
  agremang_1_N : N ; -- agremang..nn.1
  agrikultur_1_N : N ; -- agrikultur..nn.1
  agrikulturell_1_A : A ; -- agrikulturell..av.1
  agrikulturkemi_1_N : N ; -- agrikulturkemi..nn.1
  agronom_1_N : N ; -- agronom..nn.1
  agronomi_1_N : N ; -- agronomi..nn.1
  agronomisk_1_A : A ; -- agronomisk..av.1
  aguti_1_N : N ; -- aguti..nn.1
  agyri_1_N : N ; -- agyri..nn.1
  aha_upplevelse_1_N : N ; -- aha-upplevelse..nn.1
  ahaupplevelse_1_N : N ; -- ahaupplevelse..nn.1
  aids_demens_1_N : N ; -- aids-demens..nn.1
  aids_1_N : N ; -- aids..nn.1
  aidsmedicin_1_N : N ; -- aidsmedicin..nn.1
  aidspanik_1_N : N ; -- aidspanik..nn.1
  aidssjuk_1_A : A ; -- aidssjuk..av.1
  aikido_1_N : N ; -- aikido..nn.1
  aikidotrick_1_N : N ; -- aikidotrick..nn.1
  air_1_N : N ; -- air..nn.1
  airbag_1_N : N ; -- airbag..nn.1
  airbagsensor_1_N : N ; -- airbagsensor..nn.1
  airdaleterrier_1_N : N ; -- airdaleterrier..nn.1
  ajour_1_A : A ; -- ajour..av.1
  ajournera_1_V : V ; -- ajournera..vb.1
  ajournerande_1_N : N ; -- ajournerande..nn.1
  ajournerbar_1_A : A ; -- ajournerbar..av.1
  ajournerbarhet_1_N : N ; -- ajournerbarhet..nn.1
  ajournering_1_N : N ; -- ajournering..nn.1
  ajowain_1_N : N ; -- ajowain..nn.1
  ajowan_1_N : N ; -- ajowan..nn.1
  ajwain_1_N : N ; -- ajwain..nn.1
  ajwan_1_N : N ; -- ajwan..nn.1
  akacia_1_N : N ; -- akacia..nn.1
  akademi_1_N : N ; -- akademi..nn.1
  akademiker_1_N : N ; -- akademiker..nn.1
  akademisk_1_A : A ; -- akademisk..av.1
  akademist_1_N : N ; -- akademist..nn.1
  akant_1_N : N ; -- akant..nn.1
  akantolys_1_N : N ; -- akantolys..nn.1
  akantom_1_N : N ; -- akantom..nn.1
  akantus_1_N : N ; -- akantus..nn.1
  akantusblad_1_N : N ; -- akantusblad..nn.1
  akatalasemi_1_N : N ; -- akatalasemi..nn.1
  akatalektisk_1_A : A ; -- akatalektisk..av.1
  akilleshäl_1_N : N ; -- akilleshäl..nn.1
  akillessena_1_N : N ; -- akillessena..nn.1
  akleja_1_N : N ; -- akleja..nn.1
  aklorhydri_1_N : N ; -- aklorhydri..nn.1
  akne_1_N : N ; -- akne..nn.1
  akneiformutslag_1_N : N ; -- akneiformutslag..nn.1
  akondroplasi_1_N : N ; -- akondroplasi..nn.1
  akribi_1_N : N ; -- akribi..nn.1
  akro_osteolys_1_N : N ; -- akro-osteolys..nn.1
  akrobat_1_N : N ; -- akrobat..nn.1
  akrobatik_1_N : N ; -- akrobatik..nn.1
  akrobatisk_1_A : A ; -- akrobatisk..av.1
  akrobatisk_2_A : A ; -- akrobatisk..av.2
  akrocefali_1_N : N ; -- akrocefali..nn.1
  akrocefalosyndaktyli_1_N : N ; -- akrocefalosyndaktyli..nn.1
  akrodermatit_1_N : N ; -- akrodermatit..nn.1
  akrodyni_1_N : N ; -- akrodyni..nn.1
  akromatisk_1_A : A ; -- akromatisk..av.1
  akromegali_1_N : N ; -- akromegali..nn.1
  akronym_1_N : N ; -- akronym..nn.1
  akropol_1_N : N ; -- akropol..nn.1
  akrospirom_1_N : N ; -- akrospirom..nn.1
  akrostikon_1_N : N ; -- akrostikon..nn.1
  akroterion_1_N : N ; -- akroterion..nn.1
  akryl_1_N : N ; -- akryl..nn.1
  akt_1_N : N ; -- akt..nn.1
  akta_1_V : V ; -- akta..vb.1
  akta_2_V : V ; -- akta..vb.2
  aktande_1_N : N ; -- aktande..nn.1
  aktant_1_N : N ; -- aktant..nn.1
  akter_1_N : N ; -- akter..nn.1
  akterdel_1_N : N ; -- akterdel..nn.1
  akterdäck_1_N : N ; -- akterdäck..nn.1
  akterhytt_1_N : N ; -- akterhytt..nn.1
  akterkastell_1_N : N ; -- akterkastell..nn.1
  akterlig_1_A : A ; -- akterlig..av.1
  akterlik_1_N : N ; -- akterlik..nn.1
  aktersalong_1_N : N ; -- aktersalong..nn.1
  aktersegel_1_N : N ; -- aktersegel..nn.1
  akterseglad_1_A : A ; -- akterseglad..av.1
  akterskepp_1_N : N ; -- akterskepp..nn.1
  aktersnurra_1_N : N ; -- aktersnurra..nn.1
  akterspegel_1_N : N ; -- akterspegel..nn.1
  akterst_1_Adv : Adv ; -- akterst..ab.1
  akterstäv_1_N : N ; -- akterstäv..nn.1
  akterut_1_Adv : Adv ; -- akterut..ab.1
  akterända_1_N : N ; -- akterända..nn.1
  akteröver_1_Adv : Adv ; -- akteröver..ab.1
  aktförklaring_1_N : N ; -- aktförklaring..nn.1
  aktgivning_1_N : N ; -- aktgivning..nn.1
  aktie_1_N : N ; -- aktie..nn.1
  aktiebolag_1_N : N ; -- aktiebolag..nn.1
  aktiebrev_1_N : N ; -- aktiebrev..nn.1
  aktiebubbla_1_N : N ; -- aktiebubbla..nn.1
  aktiebörs_1_N : N ; -- aktiebörs..nn.1
  aktieemission_1_N : N ; -- aktieemission..nn.1
  aktiefond_1_N : N ; -- aktiefond..nn.1
  aktiehandel_1_N : N ; -- aktiehandel..nn.1
  aktieinnehav_1_N : N ; -- aktieinnehav..nn.1
  aktiekapital_1_N : N ; -- aktiekapital..nn.1
  aktiekupong_1_N : N ; -- aktiekupong..nn.1
  aktiekurs_1_N : N ; -- aktiekurs..nn.1
  aktiemajoritet_1_N : N ; -- aktiemajoritet..nn.1
  aktiemarknad_1_N : N ; -- aktiemarknad..nn.1
  aktieportfölj_1_N : N ; -- aktieportfölj..nn.1
  aktiepost_1_N : N ; -- aktiepost..nn.1
  aktiespara_1_V : V ; -- aktiespara..vb.1
  aktiesparande_1_N : N ; -- aktiesparande..nn.1
  aktiesparare_1_N : N ; -- aktiesparare..nn.1
  aktiesparklubb_1_N : N ; -- aktiesparklubb..nn.1
  aktiestock_1_N : N ; -- aktiestock..nn.1
  aktieutdelning_1_N : N ; -- aktieutdelning..nn.1
  aktievinst_1_N : N ; -- aktievinst..nn.1
  aktieägande_1_N : N ; -- aktieägande..nn.1
  aktieägare_1_N : N ; -- aktieägare..nn.1
  aktindelning_1_N : N ; -- aktindelning..nn.1
  aktinium_1_N : N ; -- aktinium..nn.1
  aktinobacillos_1_N : N ; -- aktinobacillos..nn.1
  aktinomykos_1_N : N ; -- aktinomykos..nn.1
  aktion_1_N : N ; -- aktion..nn.1
  aktionistisk_1_A : A ; -- aktionistisk..av.1
  aktionsart_1_N : N ; -- aktionsart..nn.1
  aktionsgrupp_1_N : N ; -- aktionsgrupp..nn.1
  aktionsplan_1_N : N ; -- aktionsplan..nn.1
  aktionsradie_1_N : N ; -- aktionsradie..nn.1
  aktionsström_1_N : N ; -- aktionsström..nn.1
  aktionssätt_1_N : N ; -- aktionssätt..nn.1
  aktionsturbin_1_N : N ; -- aktionsturbin..nn.1
  aktiv_1_A : A ; -- aktiv..av.1
  aktiva_1_N : N ; -- aktiva..nn.1
  aktivera_1_V : V ; -- aktivera..vb.1
  aktiverande_1_N : N ; -- aktiverande..nn.1
  aktiverbar_1_A : A ; -- aktiverbar..av.1
  aktiverbarhet_1_N : N ; -- aktiverbarhet..nn.1
  aktivering_1_N : N ; -- aktivering..nn.1
  aktiveringsmönster_1_N : N ; -- aktiveringsmönster..nn.1
  aktivism_1_N : N ; -- aktivism..nn.1
  aktivist_1_N : N ; -- aktivist..nn.1
  aktivistisk_1_A : A ; -- aktivistisk..av.1
  aktivitet_1_N : N ; -- aktivitet..nn.1
  aktivitetsersättning_1_N : N ; -- aktivitetsersättning..nn.1
  aktivum_1_N : N ; -- aktivum..nn.1
  aktning_1_N : N ; -- aktning..nn.1
  aktningsbetygelse_1_N : N ; -- aktningsbetygelse..nn.1
  aktningsbevis_1_N : N ; -- aktningsbevis..nn.1
  aktningsfull_1_A : A ; -- aktningsfull..av.1
  aktningsfullhet_1_N : N ; -- aktningsfullhet..nn.1
  aktningsvärd_1_A : A ; -- aktningsvärd..av.1
  aktningsvärdhet_1_N : N ; -- aktningsvärdhet..nn.1
  aktor_1_N : N ; -- aktor..nn.1
  aktris_1_N : N ; -- aktris..nn.1
  aktsam_1_A : A ; -- aktsam..av.1
  aktsamhet_1_N : N ; -- aktsamhet..nn.1
  aktsamhetsplikt_1_N : N ; -- aktsamhetsplikt..nn.1
  aktslut_1_N : N ; -- aktslut..nn.1
  aktstycke_1_N : N ; -- aktstycke..nn.1
  aktualisation_1_N : N ; -- aktualisation..nn.1
  aktualisera_1_V : V ; -- aktualisera..vb.1
  aktualiserande_1_N : N ; -- aktualiserande..nn.1
  aktualiserbar_1_A : A ; -- aktualiserbar..av.1
  aktualiserbarhet_1_N : N ; -- aktualiserbarhet..nn.1
  aktualisering_1_N : N ; -- aktualisering..nn.1
  aktualism_1_N : N ; -- aktualism..nn.1
  aktualistisk_1_A : A ; -- aktualistisk..av.1
  aktualitet_1_N : N ; -- aktualitet..nn.1
  aktualitetspress_1_N : N ; -- aktualitetspress..nn.1
  aktuarie_1_N : N ; -- aktuarie..nn.1
  aktuell_1_A : A ; -- aktuell..av.1
  aktör_1_N : N ; -- aktör..nn.1
  akupunktur_1_N : N ; -- akupunktur..nn.1
  akupunktör_1_N : N ; -- akupunktör..nn.1
  akustik_1_N : N ; -- akustik..nn.1
  akustiker_1_N : N ; -- akustiker..nn.1
  akustikplatta_1_N : N ; -- akustikplatta..nn.1
  akustikusneurinom_1_N : N ; -- akustikusneurinom..nn.1
  akustisk_1_A : A ; -- akustisk..av.1
  akut_1_Adv : Adv ; -- akut..ab.1
  akut_1_A : A ; -- akut..av.1
  akut_1_N : N ; -- akut..nn.1
  akutavdelning_1_N : N ; -- akutavdelning..nn.1
  akutfall_1_N : N ; -- akutfall..nn.1
  akutfasreaktion_1_N : N ; -- akutfasreaktion..nn.1
  akuthjälp_1_N : N ; -- akuthjälp..nn.1
  akutmottagning_1_N : N ; -- akutmottagning..nn.1
  akutopererad_1_A : A ; -- akutopererad..av.1
  akutvård_1_N : N ; -- akutvård..nn.1
  akutvårdsdata_1_N : N ; -- akutvårdsdata..nn.1
  akvakultur_1_N : N ; -- akvakultur..nn.1
  akvamarin_1_N : N ; -- akvamarin..nn.1
  akvanaut_1_N : N ; -- akvanaut..nn.1
  akvaplaning_1_N : N ; -- akvaplaning..nn.1
  akvarell_1_N : N ; -- akvarell..nn.1
  akvarellfärg_1_N : N ; -- akvarellfärg..nn.1
  akvarellist_1_N : N ; -- akvarellist..nn.1
  akvarellmålare_1_N : N ; -- akvarellmålare..nn.1
  akvarelltryck_1_N : N ; -- akvarelltryck..nn.1
  akvarellutställning_1_N : N ; -- akvarellutställning..nn.1
  akvariefisk_1_N : N ; -- akvariefisk..nn.1
  akvaristik_1_N : N ; -- akvaristik..nn.1
  akvaristisk_1_A : A ; -- akvaristisk..av.1
  akvarium_1_N : N ; -- akvarium..nn.1
  akvatint_1_N : N ; -- akvatint..nn.1
  akvatisk_1_A : A ; -- akvatisk..av.1
  akvavit_1_N : N ; -- akvavit..nn.1
  akvedukt_1_N : N ; -- akvedukt..nn.1
  al_1_N : N ; -- al..nn.1
  alabaster_1_N : N ; -- alabaster..nn.1
  alabasterliknande_1_A : A ; -- alabasterliknande..av.1
  alabastervit_1_A : A ; -- alabastervit..av.1
  aladåb_1_N : N ; -- aladåb..nn.1
  alagreck_1_N : N ; -- alagreck..nn.1
  alan_1_N : N ; -- alan..nn.1
  alanin_1_N : N ; -- alanin..nn.1
  alant_1_N : N ; -- alant..nn.1
  alarm_1_N : N ; -- alarm..nn.1
  alarm_2_N : N ; -- alarm..nn.2
  alarmanordning_1_N : N ; -- alarmanordning..nn.1
  alarmera_1_V : V ; -- alarmera..vb.1
  alarmerande_1_A : A ; -- alarmerande..av.1
  alarmerande_1_N : N ; -- alarmerande..nn.1
  alarmerbar_1_A : A ; -- alarmerbar..av.1
  alarmerbarhet_1_N : N ; -- alarmerbarhet..nn.1
  alarmering_1_N : N ; -- alarmering..nn.1
  alarmism_1_N : N ; -- alarmism..nn.1
  alarmist_1_N : N ; -- alarmist..nn.1
  alarmistisk_1_A : A ; -- alarmistisk..av.1
  alarmklocka_1_N : N ; -- alarmklocka..nn.1
  alarmsignal_1_N : N ; -- alarmsignal..nn.1
  alarmskott_1_N : N ; -- alarmskott..nn.1
  alarmtrumma_1_N : N ; -- alarmtrumma..nn.1
  alba_1_N : N ; -- alba..nn.1
  alban_1_N : N ; -- alban..nn.1
  albansk_1_A : A ; -- albansk..av.1
  albanska_1_N : N ; -- albanska..nn.1
  albanska_2_N : N ; -- albanska..nn.2
  albatross_1_N : N ; -- albatross..nn.1
  albigens_1_N : N ; -- albigens..nn.1
  albigenser_1_N : N ; -- albigenser..nn.1
  albigensisk_1_A : A ; -- albigensisk..av.1
  albinism_1_N : N ; -- albinism..nn.1
  albinistisk_1_A : A ; -- albinistisk..av.1
  albino_1_N : N ; -- albino..nn.1
  album_1_N : N ; -- album..nn.1
  albumin_1_N : N ; -- albumin..nn.1
  albuminuri_1_N : N ; -- albuminuri..nn.1
  albuske_1_N : N ; -- albuske..nn.1
  albyl_1_N : N ; -- albyl..nn.1
  alcantara_1_N : N ; -- alcantara..nn.1
  aldehyd_1_N : N ; -- aldehyd..nn.1
  aldrig_1_Adv : Adv ; -- aldrig..ab.1
  ale_1_N : N ; -- ale..nn.1
  alemann_1_N : N ; -- alemann..nn.1
  alert_1_A : A ; -- alert..av.1
  alexanderhugg_1_N : N ; -- alexanderhugg..nn.1
  alexandrin_1_N : N ; -- alexandrin..nn.1
  alexandrinsk_1_A : A ; -- alexandrinsk..av.1
  alexi_1_N : N ; -- alexi..nn.1
  alf_1_N : N ; -- alf..nn.1
  alfa_1_N : N ; -- alfa..nn.1
  alfabet_1_N : N ; -- alfabet..nn.1
  alfabetisera_1_V : V ; -- alfabetisera..vb.1
  alfabetiserande_1_N : N ; -- alfabetiserande..nn.1
  alfabetiserbar_1_A : A ; -- alfabetiserbar..av.1
  alfabetiserbarhet_1_N : N ; -- alfabetiserbarhet..nn.1
  alfabetisering_1_N : N ; -- alfabetisering..nn.1
  alfabetisk_1_A : A ; -- alfabetisk..av.1
  alfahanne_1_N : N ; -- alfahanne..nn.1
  alfalfa_1_N : N ; -- alfalfa..nn.1
  alfamannosidos_1_N : N ; -- alfamannosidos..nn.1
  alfametyltyrosin_1_N : N ; -- alfametyltyrosin..nn.1
  alfanumerisk_1_A : A ; -- alfanumerisk..av.1
  alfapartikel_1_N : N ; -- alfapartikel..nn.1
  alfapet_1_N : N ; -- alfapet..nn.1
  alfastrålning_1_N : N ; -- alfastrålning..nn.1
  alfasönderfall_1_N : N ; -- alfasönderfall..nn.1
  alfatalassemi_1_N : N ; -- alfatalassemi..nn.1
  alfavirusinfektion_1_N : N ; -- alfavirusinfektion..nn.1
  alfkors_1_N : N ; -- alfkors..nn.1
  alfons_1_N : N ; -- alfons..nn.1
  alfågel_1_N : N ; -- alfågel..nn.1
  alfågelskytte_1_N : N ; -- alfågelskytte..nn.1
  alförrädare_1_N : N ; -- alförrädare..nn.1
  alg_1_N : N ; -- alg..nn.1
  algblomning_1_N : N ; -- algblomning..nn.1
  algebra_1_N : N ; -- algebra..nn.1
  algebraiker_1_N : N ; -- algebraiker..nn.1
  algebraisk_1_A : A ; -- algebraisk..av.1
  algerier_1_N : N ; -- algerier..nn.1
  algerisk_1_A : A ; -- algerisk..av.1
  algeriska_1_N : N ; -- algeriska..nn.1
  algmatta_1_N : N ; -- algmatta..nn.1
  algolog_1_N : N ; -- algolog..nn.1
  algologi_1_N : N ; -- algologi..nn.1
  algologisk_1_A : A ; -- algologisk..av.1
  algonk_1_N : N ; -- algonk..nn.1
  algoritm_1_N : N ; -- algoritm..nn.1
  algren_1_N : N ; -- algren..nn.1
  algtvätt_1_N : N ; -- algtvätt..nn.1
  alibi_1_N : N ; -- alibi..nn.1
  alibibevis_1_N : N ; -- alibibevis..nn.1
  alibistisk_1_A : A ; -- alibistisk..av.1
  alienation_1_N : N ; -- alienation..nn.1
  alienationsupplevelse_1_N : N ; -- alienationsupplevelse..nn.1
  alienera_1_V : V ; -- alienera..vb.1
  alienerande_1_N : N ; -- alienerande..nn.1
  alienerbar_1_A : A ; -- alienerbar..av.1
  alienerbarhet_1_N : N ; -- alienerbarhet..nn.1
  alienering_1_N : N ; -- alienering..nn.1
  alifatisk_1_A : A ; -- alifatisk..av.1
  alika_1_N : N ; -- alika..nn.1
  alimentär_1_A : A ; -- alimentär..av.1
  alisarin_1_N : N ; -- alisarin..nn.1
  alka_1_N : N ; -- alka..nn.1
  alkaisk_1_A : A ; -- alkaisk..av.1
  alkali_1_N : N ; -- alkali..nn.1
  alkaliblått_1_N : N ; -- alkaliblått..nn.1
  alkalilut_1_N : N ; -- alkalilut..nn.1
  alkalimetall_1_N : N ; -- alkalimetall..nn.1
  alkalisk_1_A : A ; -- alkalisk..av.1
  alkaloid_1_N : N ; -- alkaloid..nn.1
  alkalos_1_N : N ; -- alkalos..nn.1
  alkan_1_N : N ; -- alkan..nn.1
  alkanna_1_N : N ; -- alkanna..nn.1
  alkanol_1_N : N ; -- alkanol..nn.1
  alkaptonuri_1_N : N ; -- alkaptonuri..nn.1
  alkekung_1_N : N ; -- alkekung..nn.1
  alkemi_1_N : N ; -- alkemi..nn.1
  alkemisk_1_A : A ; -- alkemisk..av.1
  alkemist_1_N : N ; -- alkemist..nn.1
  alkemistisk_1_A : A ; -- alkemistisk..av.1
  alkfågel_1_N : N ; -- alkfågel..nn.1
  alkis_1_N : N ; -- alkis..nn.1
  alkohol_1_N : N ; -- alkohol..nn.1
  alkoholabstinens_1_N : N ; -- alkoholabstinens..nn.1
  alkoholabstinensanfall_1_N : N ; -- alkoholabstinensanfall..nn.1
  alkoholberusning_1_N : N ; -- alkoholberusning..nn.1
  alkoholcirrhos_1_N : N ; -- alkoholcirrhos..nn.1
  alkoholcirros_1_N : N ; -- alkoholcirros..nn.1
  alkoholfri_1_A : A ; -- alkoholfri..av.1
  alkoholförbud_1_N : N ; -- alkoholförbud..nn.1
  alkoholförgiftning_1_N : N ; -- alkoholförgiftning..nn.1
  alkoholförtäring_1_N : N ; -- alkoholförtäring..nn.1
  alkoholhalt_1_N : N ; -- alkoholhalt..nn.1
  alkoholhaltig_1_A : A ; -- alkoholhaltig..av.1
  alkoholinnehav_1_N : N ; -- alkoholinnehav..nn.1
  alkoholintoxikation_1_N : N ; -- alkoholintoxikation..nn.1
  alkoholiserad_1_A : A ; -- alkoholiserad..av.1
  alkoholisk_1_A : A ; -- alkoholisk..av.1
  alkoholism_1_N : N ; -- alkoholism..nn.1
  alkoholist_1_N : N ; -- alkoholist..nn.1
  alkoholistanstalt_1_N : N ; -- alkoholistanstalt..nn.1
  alkoholistisk_1_A : A ; -- alkoholistisk..av.1
  alkoholkardiomyopati_1_N : N ; -- alkoholkardiomyopati..nn.1
  alkoholkonsumtion_1_N : N ; -- alkoholkonsumtion..nn.1
  alkoholmissbruk_1_N : N ; -- alkoholmissbruk..nn.1
  alkoholmissbrukande_1_N : N ; -- alkoholmissbrukande..nn.1
  alkoholmissbrukare_1_N : N ; -- alkoholmissbrukare..nn.1
  alkoholneuropati_1_N : N ; -- alkoholneuropati..nn.1
  alkoholometer_1_N : N ; -- alkoholometer..nn.1
  alkoholpolicy_1_N : N ; -- alkoholpolicy..nn.1
  alkoholpolitik_1_N : N ; -- alkoholpolitik..nn.1
  alkoholpolitisk_1_A : A ; -- alkoholpolitisk..av.1
  alkoholpsykos_1_N : N ; -- alkoholpsykos..nn.1
  alkoholpåverkad_1_A : A ; -- alkoholpåverkad..av.1
  alkoholrelaterad_1_A : A ; -- alkoholrelaterad..av.1
  alkoholskada_1_N : N ; -- alkoholskada..nn.1
  alkoholskatt_1_N : N ; -- alkoholskatt..nn.1
  alkoholstark_1_A : A ; -- alkoholstark..av.1
  alkoholstyrka_1_N : N ; -- alkoholstyrka..nn.1
  alkoholsvag_1_A : A ; -- alkoholsvag..av.1
  alkoholsvaghet_1_N : N ; -- alkoholsvaghet..nn.1
  alkoholtest_1_N : N ; -- alkoholtest..nn.1
  alkoholvana_1_N : N ; -- alkoholvana..nn.1
  alkolås_1_N : N ; -- alkolås..nn.1
  alkotest_1_N : N ; -- alkotest..nn.1
  alkotte_1_N : N ; -- alkotte..nn.1
  alkov_1_N : N ; -- alkov..nn.1
  alkovsäng_1_N : N ; -- alkovsäng..nn.1
  alkyd_1_N : N ; -- alkyd..nn.1
  alkyl_1_N : N ; -- alkyl..nn.1
  alkyn_1_N : N ; -- alkyn..nn.1
  alla_1_N : N ; -- alla..nn.1
  allativ_1_N : N ; -- allativ..nn.1
  allbekant_1_A : A ; -- allbekant..av.1
  alldaglig_1_A : A ; -- alldaglig..av.1
  alldaglighet_1_N : N ; -- alldaglighet..nn.1
  alldeles_1_Adv : Adv ; -- alldeles..ab.1
  allegat_1_N : N ; -- allegat..nn.1
  allegori_1_N : N ; -- allegori..nn.1
  allegorisera_1_V : V ; -- allegorisera..vb.1
  allegoriserande_1_N : N ; -- allegoriserande..nn.1
  allegoriserbar_1_A : A ; -- allegoriserbar..av.1
  allegoriserbarhet_1_N : N ; -- allegoriserbarhet..nn.1
  allegorisering_1_N : N ; -- allegorisering..nn.1
  allegorisk_1_A : A ; -- allegorisk..av.1
  allegretto_1_N : N ; -- allegretto..nn.1
  allegro_1_N : N ; -- allegro..nn.1
  allegrosats_1_N : N ; -- allegrosats..nn.1
  allehanda_1_A : A ; -- allehanda..av.1
  allel_1_N : N ; -- allel..nn.1
  allemansfond_1_N : N ; -- allemansfond..nn.1
  allemansrätt_1_N : N ; -- allemansrätt..nn.1
  allen_1_A : A ; -- allen..av.1
  allena_1_A : A ; -- allena..av.1
  allenarådande_1_A : A ; -- allenarådande..av.1
  allenastyre_1_N : N ; -- allenastyre..nn.1
  allergen_1_A : A ; -- allergen..av.1
  allergen_1_N : N ; -- allergen..nn.1
  allergi_1_N : N ; -- allergi..nn.1
  allergiframkallande_1_A : A ; -- allergiframkallande..av.1
  allergiker_1_N : N ; -- allergiker..nn.1
  allergimedicin_1_N : N ; -- allergimedicin..nn.1
  allergisk_1_A : A ; -- allergisk..av.1
  allergitablett_1_N : N ; -- allergitablett..nn.1
  allergolog_1_N : N ; -- allergolog..nn.1
  allergologi_1_N : N ; -- allergologi..nn.1
  allestädesnärvarande_1_A : A ; -- allestädesnärvarande..av.1
  alleuropeisk_1_A : A ; -- alleuropeisk..av.1
  allfader_1_N : N ; -- allfader..nn.1
  allfarväg_1_N : N ; -- allfarväg..nn.1
  allgod_1_A : A ; -- allgod..av.1
  allgodhet_1_N : N ; -- allgodhet..nn.1
  allhelgonadag_1_N : N ; -- allhelgonadag..nn.1
  allhelgonamässa_1_N : N ; -- allhelgonamässa..nn.1
  allhärskare_1_N : N ; -- allhärskare..nn.1
  allians_1_N : N ; -- allians..nn.1
  alliansfri_1_A : A ; -- alliansfri..av.1
  allianskollega_1_N : N ; -- allianskollega..nn.1
  alliansparti_1_N : N ; -- alliansparti..nn.1
  alliansregering_1_N : N ; -- alliansregering..nn.1
  alliansring_1_N : N ; -- alliansring..nn.1
  alliera_1_V : V ; -- alliera..vb.1
  allierad_1_A : A ; -- allierad..av.1
  allierande_1_N : N ; -- allierande..nn.1
  allierbar_1_A : A ; -- allierbar..av.1
  allierbarhet_1_N : N ; -- allierbarhet..nn.1
  alliering_1_N : N ; -- alliering..nn.1
  alligator_1_N : N ; -- alligator..nn.1
  allitteration_1_N : N ; -- allitteration..nn.1
  allitterera_1_V : V ; -- allitterera..vb.1
  allittererande_1_N : N ; -- allittererande..nn.1
  allittererbar_1_A : A ; -- allittererbar..av.1
  allittererbarhet_1_N : N ; -- allittererbarhet..nn.1
  allitterering_1_N : N ; -- allitterering..nn.1
  allkonstnär_1_N : N ; -- allkonstnär..nn.1
  allkonstverk_1_N : N ; -- allkonstverk..nn.1
  allmakt_1_N : N ; -- allmakt..nn.1
  allmaktsord_1_N : N ; -- allmaktsord..nn.1
  allmoge_1_N : N ; -- allmoge..nn.1
  allmogeblå_1_A : A ; -- allmogeblå..av.1
  allmogebroderi_1_N : N ; -- allmogebroderi..nn.1
  allmogedräkt_1_N : N ; -- allmogedräkt..nn.1
  allmogekultur_1_N : N ; -- allmogekultur..nn.1
  allmogemål_1_N : N ; -- allmogemål..nn.1
  allmogesed_1_N : N ; -- allmogesed..nn.1
  allmogesmycke_1_N : N ; -- allmogesmycke..nn.1
  allmogespråk_1_N : N ; -- allmogespråk..nn.1
  allmogevävnad_1_N : N ; -- allmogevävnad..nn.1
  allmosa_1_N : N ; -- allmosa..nn.1
  allmän_1_A : A ; -- allmän..av.1
  allmänanda_1_N : N ; -- allmänanda..nn.1
  allmänbefinnande_1_N : N ; -- allmänbefinnande..nn.1
  allmänbegrepp_1_N : N ; -- allmänbegrepp..nn.1
  allmänbegåvning_1_N : N ; -- allmänbegåvning..nn.1
  allmänbegåvning_2_N : N ; -- allmänbegåvning..nn.2
  allmänbilda_1_V : V ; -- allmänbilda..vb.1
  allmänbildad_1_A : A ; -- allmänbildad..av.1
  allmänbildande_1_N : N ; -- allmänbildande..nn.1
  allmänbildning_1_N : N ; -- allmänbildning..nn.1
  allmänborgerlig_1_A : A ; -- allmänborgerlig..av.1
  allmänfarlig_1_A : A ; -- allmänfarlig..av.1
  allmänfarlighet_1_N : N ; -- allmänfarlighet..nn.1
  allmängiltig_1_A : A ; -- allmängiltig..av.1
  allmängiltighet_1_N : N ; -- allmängiltighet..nn.1
  allmängods_1_N : N ; -- allmängods..nn.1
  allmänhet_1_N : N ; -- allmänhet..nn.1
  allmänhumanistisk_1_A : A ; -- allmänhumanistisk..av.1
  allmänintresse_1_N : N ; -- allmänintresse..nn.1
  allmänläkare_1_N : N ; -- allmänläkare..nn.1
  allmänmodernistisk_1_A : A ; -- allmänmodernistisk..av.1
  allmänmänsklig_1_A : A ; -- allmänmänsklig..av.1
  allmänmänsklighet_1_N : N ; -- allmänmänsklighet..nn.1
  allmännelig_1_A : A ; -- allmännelig..av.1
  allmännelighet_1_N : N ; -- allmännelighet..nn.1
  allmänning_1_N : N ; -- allmänning..nn.1
  allmännytta_1_N : N ; -- allmännytta..nn.1
  allmännyttig_1_A : A ; -- allmännyttig..av.1
  allmännyttighet_1_N : N ; -- allmännyttighet..nn.1
  allmänpolitisk_1_A : A ; -- allmänpolitisk..av.1
  allmänpraktiker_1_N : N ; -- allmänpraktiker..nn.1
  allmänpraktiserande_1_A : A ; -- allmänpraktiserande..av.1
  allmänprevention_1_N : N ; -- allmänprevention..nn.1
  allmänpreventiv_1_A : A ; -- allmänpreventiv..av.1
  allmäntillstånd_1_N : N ; -- allmäntillstånd..nn.1
  allmäntjänstgöring_1_N : N ; -- allmäntjänstgöring..nn.1
  allnationell_1_A : A ; -- allnationell..av.1
  allod_1_N : N ; -- allod..nn.1
  allodial_1_A : A ; -- allodial..av.1
  allodium_1_N : N ; -- allodium..nn.1
  allofon_1_N : N ; -- allofon..nn.1
  allograf_1_N : N ; -- allograf..nn.1
  allokera_1_V : V ; -- allokera..vb.1
  allokerande_1_N : N ; -- allokerande..nn.1
  allokerbar_1_A : A ; -- allokerbar..av.1
  allokerbarhet_1_N : N ; -- allokerbarhet..nn.1
  allokering_1_N : N ; -- allokering..nn.1
  allokton_1_A : A ; -- allokton..av.1
  allokution_1_N : N ; -- allokution..nn.1
  allomfattande_1_A : A ; -- allomfattande..av.1
  allomorf_1_A : A ; -- allomorf..av.1
  allomorf_1_N : N ; -- allomorf..nn.1
  allongeperuk_1_N : N ; -- allongeperuk..nn.1
  allopat_1_N : N ; -- allopat..nn.1
  allopati_1_N : N ; -- allopati..nn.1
  allopatisk_1_A : A ; -- allopatisk..av.1
  allraheligaste_1_A : A ; -- allraheligaste..av.1
  allriskförsäkring_1_N : N ; -- allriskförsäkring..nn.1
  allround_1_A : A ; -- allround..av.1
  allroundsåg_1_N : N ; -- allroundsåg..nn.1
  allrum_1_N : N ; -- allrum..nn.1
  allrådande_1_A : A ; -- allrådande..av.1
  alls_1_Adv : Adv ; -- alls..ab.1
  allseende_1_A : A ; -- allseende..av.1
  allshärjarting_1_N : N ; -- allshärjarting..nn.1
  allsidig_1_A : A ; -- allsidig..av.1
  allsidighet_1_N : N ; -- allsidighet..nn.1
  allsköns_1_A : A ; -- allsköns..av.1
  allsmäktig_1_A : A ; -- allsmäktig..av.1
  allsmäktighet_1_N : N ; -- allsmäktighet..nn.1
  allströmsapparat_1_N : N ; -- allströmsapparat..nn.1
  allsvensk_1_A : A ; -- allsvensk..av.1
  allsvenska_1_N : N ; -- allsvenska..nn.1
  allsvåldig_1_A : A ; -- allsvåldig..av.1
  allsvåldighet_1_N : N ; -- allsvåldighet..nn.1
  allsång_1_N : N ; -- allsång..nn.1
  allsångsledare_1_N : N ; -- allsångsledare..nn.1
  allt_1_Adv : Adv ; -- allt..ab.1
  allt_1_N : N ; -- allt..nn.1
  alltemellan_1_Adv : Adv ; -- alltemellan..ab.1
  alltemellanåt_1_Adv : Adv ; -- alltemellanåt..ab.1
  alltframgent_1_Adv : Adv ; -- alltframgent..ab.1
  alltför_1_Adv : Adv ; -- alltför..ab.1
  alltiallo_1_N : N ; -- alltiallo..nn.1
  alltigenom_1_Adv : Adv ; -- alltigenom..ab.1
  allting_1_N : N ; -- allting..nn.1
  alltmer_1_Adv : Adv ; -- alltmer..ab.1
  alltmera_1_Adv : Adv ; -- alltmera..ab.1
  alltmindre_1_Adv : Adv ; -- alltmindre..ab.1
  alltnog_1_Adv : Adv ; -- alltnog..ab.1
  alltomfattande_1_A : A ; -- alltomfattande..av.1
  alltså_1_Adv : Adv ; -- alltså..ab.1
  alludera_1_V : V ; -- alludera..vb.1
  alluderande_1_N : N ; -- alluderande..nn.1
  alluderbar_1_A : A ; -- alluderbar..av.1
  alluderbarhet_1_N : N ; -- alluderbarhet..nn.1
  alludering_1_N : N ; -- alludering..nn.1
  allusion_1_N : N ; -- allusion..nn.1
  allusionsvis_1_Adv : Adv ; -- allusionsvis..ab.1
  alluvial_1_A : A ; -- alluvial..av.1
  alluvialbildning_1_N : N ; -- alluvialbildning..nn.1
  alluvialland_1_N : N ; -- alluvialland..nn.1
  alluvialperiod_1_N : N ; -- alluvialperiod..nn.1
  alluvium_1_N : N ; -- alluvium..nn.1
  allvar_1_N : N ; -- allvar..nn.1
  allvarlig_1_A : A ; -- allvarlig..av.1
  allvarligen_1_Adv : Adv ; -- allvarligen..ab.1
  allvarlighet_1_N : N ; -- allvarlighet..nn.1
  allvarsam_1_A : A ; -- allvarsam..av.1
  allvarsamhet_1_N : N ; -- allvarsamhet..nn.1
  allvarsord_1_N : N ; -- allvarsord..nn.1
  allvarstyngd_1_A : A ; -- allvarstyngd..av.1
  allvarstyngdhet_1_N : N ; -- allvarstyngdhet..nn.1
  allvetande_1_A : A ; -- allvetande..av.1
  allvetare_1_N : N ; -- allvetare..nn.1
  allvis_1_A : A ; -- allvis..av.1
  allvishet_1_N : N ; -- allvishet..nn.1
  allväders_1_A : A ; -- allväders..av.1
  allvädersskydd_1_N : N ; -- allvädersskydd..nn.1
  allvädersstövel_1_N : N ; -- allvädersstövel..nn.1
  allätande_1_A : A ; -- allätande..av.1
  allätare_1_N : N ; -- allätare..nn.1
  allé_1_N : N ; -- allé..nn.1
  alm_1_N : N ; -- alm..nn.1
  almanack_1_N : N ; -- almanack..nn.1
  almanacka_1_N : N ; -- almanacka..nn.1
  almanacksblad_1_N : N ; -- almanacksblad..nn.1
  alme_1_N : N ; -- alme..nn.1
  almfällning_1_N : N ; -- almfällning..nn.1
  almgren_1_N : N ; -- almgren..nn.1
  almsav_1_N : N ; -- almsav..nn.1
  almsjuka_1_N : N ; -- almsjuka..nn.1
  almstrid_1_N : N ; -- almstrid..nn.1
  aln_1_N : N ; -- aln..nn.1
  alnmått_1_N : N ; -- alnmått..nn.1
  alnsbred_1_A : A ; -- alnsbred..av.1
  alnsdjup_1_A : A ; -- alnsdjup..av.1
  alnshög_1_A : A ; -- alnshög..av.1
  alnslång_1_A : A ; -- alnslång..av.1
  aloe_1_N : N ; -- aloe..nn.1
  aloebaserad_1_A : A ; -- aloebaserad..av.1
  alopecia_1_N : N ; -- alopecia..nn.1
  alp_1_N : N ; -- alp..nn.1
  alpacka_1_N : N ; -- alpacka..nn.1
  alpacka_2_N : N ; -- alpacka..nn.2
  alpackatyg_1_N : N ; -- alpackatyg..nn.1
  alpackaull_1_N : N ; -- alpackaull..nn.1
  alpbestigning_1_N : N ; -- alpbestigning..nn.1
  alpget_1_N : N ; -- alpget..nn.1
  alphorn_1_N : N ; -- alphorn..nn.1
  alpidyll_1_N : N ; -- alpidyll..nn.1
  alpin_1_A : A ; -- alpin..av.1
  alpinism_1_N : N ; -- alpinism..nn.1
  alpinist_1_N : N ; -- alpinist..nn.1
  alpinsk_1_A : A ; -- alpinsk..av.1
  alpjägare_1_N : N ; -- alpjägare..nn.1
  alpkedja_1_N : N ; -- alpkedja..nn.1
  alpland_1_N : N ; -- alpland..nn.1
  alpregion_1_N : N ; -- alpregion..nn.1
  alpros_1_N : N ; -- alpros..nn.1
  alpspets_1_N : N ; -- alpspets..nn.1
  alpstav_1_N : N ; -- alpstav..nn.1
  alpstig_1_N : N ; -- alpstig..nn.1
  alptopp_1_N : N ; -- alptopp..nn.1
  alpvandring_1_N : N ; -- alpvandring..nn.1
  alpviol_1_N : N ; -- alpviol..nn.1
  alpväg_1_N : N ; -- alpväg..nn.1
  alruna_1_N : N ; -- alruna..nn.1
  alsikeklöver_1_N : N ; -- alsikeklöver..nn.1
  alspån_1_N : N ; -- alspån..nn.1
  alster_1_N : N ; -- alster..nn.1
  alstra_1_V : V ; -- alstra..vb.1
  alstrande_1_N : N ; -- alstrande..nn.1
  alstrare_1_N : N ; -- alstrare..nn.1
  alstring_1_N : N ; -- alstring..nn.1
  alt_1_N : N ; -- alt..nn.1
  altaisk_1_A : A ; -- altaisk..av.1
  altan_1_N : N ; -- altan..nn.1
  altanbräda_1_N : N ; -- altanbräda..nn.1
  altandörr_1_N : N ; -- altandörr..nn.1
  altanfäste_1_N : N ; -- altanfäste..nn.1
  altarbild_1_N : N ; -- altarbild..nn.1
  altarbord_1_N : N ; -- altarbord..nn.1
  altarbrun_1_N : N ; -- altarbrun..nn.1
  altardisk_1_N : N ; -- altardisk..nn.1
  altarduk_1_N : N ; -- altarduk..nn.1
  altare_1_N : N ; -- altare..nn.1
  altargång_1_N : N ; -- altargång..nn.1
  altarkläde_1_N : N ; -- altarkläde..nn.1
  altarkors_1_N : N ; -- altarkors..nn.1
  altarkärl_1_N : N ; -- altarkärl..nn.1
  altarlykta_1_N : N ; -- altarlykta..nn.1
  altarmålning_1_N : N ; -- altarmålning..nn.1
  altarprydnad_1_N : N ; -- altarprydnad..nn.1
  altarring_1_N : N ; -- altarring..nn.1
  altarrund_1_N : N ; -- altarrund..nn.1
  altarskrud_1_N : N ; -- altarskrud..nn.1
  altarskåp_1_N : N ; -- altarskåp..nn.1
  altartavla_1_N : N ; -- altartavla..nn.1
  altartjänst_1_N : N ; -- altartjänst..nn.1
  altaruppsats_1_N : N ; -- altaruppsats..nn.1
  altbasun_1_N : N ; -- altbasun..nn.1
  altea_1_N : N ; -- altea..nn.1
  alteasirap_1_N : N ; -- alteasirap..nn.1
  alteration_1_N : N ; -- alteration..nn.1
  altererad_1_A : A ; -- altererad..av.1
  alternativ_1_A : A ; -- alternativ..av.1
  alternativ_1_N : N ; -- alternativ..nn.1
  alternativfråga_1_N : N ; -- alternativfråga..nn.1
  alternativkurs_1_N : N ; -- alternativkurs..nn.1
  alternativt_1_Adv : Adv ; -- alternativt..ab.1
  alternatvinkel_1_N : N ; -- alternatvinkel..nn.1
  alternera_1_V : V ; -- alternera..vb.1
  alternerande_1_N : N ; -- alternerande..nn.1
  alternerbar_1_A : A ; -- alternerbar..av.1
  alternerbarhet_1_N : N ; -- alternerbarhet..nn.1
  alternering_1_N : N ; -- alternering..nn.1
  altfiol_1_N : N ; -- altfiol..nn.1
  altflöjt_1_N : N ; -- altflöjt..nn.1
  althorn_1_N : N ; -- althorn..nn.1
  altita_1_N : N ; -- altita..nn.1
  altitud_1_N : N ; -- altitud..nn.1
  altklarinett_1_N : N ; -- altklarinett..nn.1
  altklav_1_N : N ; -- altklav..nn.1
  altparti_1_N : N ; -- altparti..nn.1
  altruism_1_N : N ; -- altruism..nn.1
  altruist_1_N : N ; -- altruist..nn.1
  altruistisk_1_A : A ; -- altruistisk..av.1
  altröst_1_N : N ; -- altröst..nn.1
  altsträng_1_N : N ; -- altsträng..nn.1
  altstämma_1_N : N ; -- altstämma..nn.1
  altsångare_1_N : N ; -- altsångare..nn.1
  altsångerska_1_N : N ; -- altsångerska..nn.1
  altviolin_1_N : N ; -- altviolin..nn.1
  aluminera_1_V : V ; -- aluminera..vb.1
  aluminerande_1_N : N ; -- aluminerande..nn.1
  aluminerbar_1_A : A ; -- aluminerbar..av.1
  aluminerbarhet_1_N : N ; -- aluminerbarhet..nn.1
  aluminering_1_N : N ; -- aluminering..nn.1
  aluminium_1_N : N ; -- aluminium..nn.1
  aluminiumfabrik_1_N : N ; -- aluminiumfabrik..nn.1
  aluminiumfolie_1_N : N ; -- aluminiumfolie..nn.1
  aluminiumjon_1_N : N ; -- aluminiumjon..nn.1
  aluminiumkärl_1_N : N ; -- aluminiumkärl..nn.1
  aluminiumlinjal_1_N : N ; -- aluminiumlinjal..nn.1
  aluminiumnät_1_N : N ; -- aluminiumnät..nn.1
  aluminiumpulver_1_N : N ; -- aluminiumpulver..nn.1
  aluminiumsmältverk_1_N : N ; -- aluminiumsmältverk..nn.1
  alumn_1_N : N ; -- alumn..nn.1
  alun_1_N : N ; -- alun..nn.1
  alunhaltig_1_A : A ; -- alunhaltig..av.1
  alunit_1_N : N ; -- alunit..nn.1
  alunskiffer_1_N : N ; -- alunskiffer..nn.1
  alv_1_N : N ; -- alv..nn.1
  alv_2_N : N ; -- alv..nn.2
  alvar_1_N : N ; -- alvar..nn.1
  alvarsmark_1_N : N ; -- alvarsmark..nn.1
  alveol_1_N : N ; -- alveol..nn.1
  alveolar_1_A : A ; -- alveolar..av.1
  alveolar_1_N : N ; -- alveolar..nn.1
  alveolarben_1_N : N ; -- alveolarben..nn.1
  alveolarresorption_1_N : N ; -- alveolarresorption..nn.1
  alvluckra_1_V : V ; -- alvluckra..vb.1
  alvluckrande_1_N : N ; -- alvluckrande..nn.1
  alvplog_1_N : N ; -- alvplog..nn.1
  alzheimer_1_N : N ; -- alzheimer..nn.1
  alzheimers_1_N : N ; -- alzheimers..nn.1
  amalgam_1_N : N ; -- amalgam..nn.1
  amalgamera_1_V : V ; -- amalgamera..vb.1
  amalgamerande_1_N : N ; -- amalgamerande..nn.1
  amalgamerbar_1_A : A ; -- amalgamerbar..av.1
  amalgamerbarhet_1_N : N ; -- amalgamerbarhet..nn.1
  amalgamering_1_N : N ; -- amalgamering..nn.1
  amanuens_1_N : N ; -- amanuens..nn.1
  amarant_1_N : N ; -- amarant..nn.1
  amaryllis_1_N : N ; -- amaryllis..nn.1
  amason_1_N : N ; -- amason..nn.1
  amatör_1_N : N ; -- amatör..nn.1
  amatörastronom_1_N : N ; -- amatörastronom..nn.1
  amatörbestämmelse_1_N : N ; -- amatörbestämmelse..nn.1
  amatörbombtillverkning_1_N : N ; -- amatörbombtillverkning..nn.1
  amatörforskare_1_N : N ; -- amatörforskare..nn.1
  amatöridrott_1_N : N ; -- amatöridrott..nn.1
  amatörism_1_N : N ; -- amatörism..nn.1
  amatöristisk_1_A : A ; -- amatöristisk..av.1
  amatörmässig_1_A : A ; -- amatörmässig..av.1
  amatörmässighet_1_N : N ; -- amatörmässighet..nn.1
  amatörmålare_1_N : N ; -- amatörmålare..nn.1
  amatörprojekt_1_N : N ; -- amatörprojekt..nn.1
  amatörregel_1_N : N ; -- amatörregel..nn.1
  amatörsändare_1_N : N ; -- amatörsändare..nn.1
  amatörteater_1_N : N ; -- amatörteater..nn.1
  amatörteleskop_1_N : N ; -- amatörteleskop..nn.1
  amatörvideo_1_N : N ; -- amatörvideo..nn.1
  amazon_1_N : N ; -- amazon..nn.1
  ambassad_1_N : N ; -- ambassad..nn.1
  ambassadpersonal_1_N : N ; -- ambassadpersonal..nn.1
  ambassadris_1_N : N ; -- ambassadris..nn.1
  ambassadråd_1_N : N ; -- ambassadråd..nn.1
  ambassadsekreterare_1_N : N ; -- ambassadsekreterare..nn.1
  ambassadör_1_N : N ; -- ambassadör..nn.1
  ambassadörsmässig_1_A : A ; -- ambassadörsmässig..av.1
  ambassadörspost_1_N : N ; -- ambassadörspost..nn.1
  ambidexter_1_A : A ; -- ambidexter..av.1
  ambidextri_1_N : N ; -- ambidextri..nn.1
  ambiguitet_1_N : N ; -- ambiguitet..nn.1
  ambiofoni_1_N : N ; -- ambiofoni..nn.1
  ambition_1_N : N ; -- ambition..nn.1
  ambitionsnivå_1_N : N ; -- ambitionsnivå..nn.1
  ambitionssak_1_N : N ; -- ambitionssak..nn.1
  ambitiös_1_A : A ; -- ambitiös..av.1
  ambivalens_1_N : N ; -- ambivalens..nn.1
  ambivalent_1_A : A ; -- ambivalent..av.1
  amblyopi_1_N : N ; -- amblyopi..nn.1
  ambra_1_N : N ; -- ambra..nn.1
  ambradoft_1_N : N ; -- ambradoft..nn.1
  ambrosia_1_N : N ; -- ambrosia..nn.1
  ambrosisk_1_A : A ; -- ambrosisk..av.1
  ambulans_1_N : N ; -- ambulans..nn.1
  ambulansflyg_1_N : N ; -- ambulansflyg..nn.1
  ambulansförare_1_N : N ; -- ambulansförare..nn.1
  ambulanshelikopter_1_N : N ; -- ambulanshelikopter..nn.1
  ambulanskår_1_N : N ; -- ambulanskår..nn.1
  ambulansman_1_N : N ; -- ambulansman..nn.1
  ambulanspersonal_1_N : N ; -- ambulanspersonal..nn.1
  ambulanssjukskötare_1_N : N ; -- ambulanssjukskötare..nn.1
  ambulanssjuksköterska_1_N : N ; -- ambulanssjuksköterska..nn.1
  ambulanssjukvårdare_1_N : N ; -- ambulanssjukvårdare..nn.1
  ambulatorisk_1_A : A ; -- ambulatorisk..av.1
  ambulera_1_V : V ; -- ambulera..vb.1
  ambulerande_1_N : N ; -- ambulerande..nn.1
  ambulerbar_1_A : A ; -- ambulerbar..av.1
  ambulerbarhet_1_N : N ; -- ambulerbarhet..nn.1
  ambulering_1_N : N ; -- ambulering..nn.1
  ameloblastom_1_N : N ; -- ameloblastom..nn.1
  amendemang_1_N : N ; -- amendemang..nn.1
  amenorre_1_N : N ; -- amenorre..nn.1
  americium_1_N : N ; -- americium..nn.1
  amerikabiljett_1_N : N ; -- amerikabiljett..nn.1
  amerikan_1_N : N ; -- amerikan..nn.1
  amerikanare_1_N : N ; -- amerikanare..nn.1
  amerikanisera_1_V : V ; -- amerikanisera..vb.1
  amerikaniserande_1_N : N ; -- amerikaniserande..nn.1
  amerikaniserbar_1_A : A ; -- amerikaniserbar..av.1
  amerikaniserbarhet_1_N : N ; -- amerikaniserbarhet..nn.1
  amerikanisering_1_N : N ; -- amerikanisering..nn.1
  amerikanism_1_N : N ; -- amerikanism..nn.1
  amerikansk_1_A : A ; -- amerikansk..av.1
  amerikanska_1_N : N ; -- amerikanska..nn.1
  amerikanska_2_N : N ; -- amerikanska..nn.2
  amerikansktillverkad_1_A : A ; -- amerikansktillverkad..av.1
  ametist_1_N : N ; -- ametist..nn.1
  ametistblå_1_A : A ; -- ametistblå..av.1
  ametistsmycke_1_N : N ; -- ametistsmycke..nn.1
  amfetamin_1_N : N ; -- amfetamin..nn.1
  amfetaminbeslag_1_N : N ; -- amfetaminbeslag..nn.1
  amfetaminmissbruk_1_N : N ; -- amfetaminmissbruk..nn.1
  amfibie_1_N : N ; -- amfibie..nn.1
  amfibieplan_1_N : N ; -- amfibieplan..nn.1
  amfibisk_1_A : A ; -- amfibisk..av.1
  amfibolit_1_N : N ; -- amfibolit..nn.1
  amfiteater_1_N : N ; -- amfiteater..nn.1
  amfiteatralisk_1_A : A ; -- amfiteatralisk..av.1
  amfora_1_N : N ; -- amfora..nn.1
  ami_1_N : N ; -- ami..nn.1
  amid_1_N : N ; -- amid..nn.1
  amin_1_N : N ; -- amin..nn.1
  aminosyra_1_N : N ; -- aminosyra..nn.1
  amiral_1_N : N ; -- amiral..nn.1
  amiralitet_1_N : N ; -- amiralitet..nn.1
  amiralsflagga_1_N : N ; -- amiralsflagga..nn.1
  amiralsperson_1_N : N ; -- amiralsperson..nn.1
  amiralstitel_1_N : N ; -- amiralstitel..nn.1
  amma_1_N : N ; -- amma..nn.1
  amma_1_V : V ; -- amma..vb.1
  ammande_1_N : N ; -- ammande..nn.1
  ammoniak_1_N : N ; -- ammoniak..nn.1
  ammoniaklukt_1_N : N ; -- ammoniaklukt..nn.1
  ammoniaklösning_1_N : N ; -- ammoniaklösning..nn.1
  ammonit_1_N : N ; -- ammonit..nn.1
  ammonium_1_N : N ; -- ammonium..nn.1
  ammoniumklorid_1_N : N ; -- ammoniumklorid..nn.1
  ammoniumnitrat_1_N : N ; -- ammoniumnitrat..nn.1
  ammoniumnitratlösning_1_N : N ; -- ammoniumnitratlösning..nn.1
  ammunition_1_N : N ; -- ammunition..nn.1
  ammunitionsväska_1_N : N ; -- ammunitionsväska..nn.1
  amnesi_1_N : N ; -- amnesi..nn.1
  amnesti_1_N : N ; -- amnesti..nn.1
  amnestidekret_1_N : N ; -- amnestidekret..nn.1
  amnestilag_1_N : N ; -- amnestilag..nn.1
  amning_1_N : N ; -- amning..nn.1
  amningsbehå_1_N : N ; -- amningsbehå..nn.1
  amningsdepression_1_N : N ; -- amningsdepression..nn.1
  amningsfanatiker_1_N : N ; -- amningsfanatiker..nn.1
  amningsfanatism_1_N : N ; -- amningsfanatism..nn.1
  amningsfascism_1_N : N ; -- amningsfascism..nn.1
  amningsfascist_1_N : N ; -- amningsfascist..nn.1
  amningsförakt_1_N : N ; -- amningsförakt..nn.1
  amningsmobbare_1_N : N ; -- amningsmobbare..nn.1
  amningssvårighet_1_N : N ; -- amningssvårighet..nn.1
  amnionbandsyndrom_1_N : N ; -- amnionbandsyndrom..nn.1
  amoebiasis_1_N : N ; -- amoebiasis..nn.1
  amoralisk_1_A : A ; -- amoralisk..av.1
  amoralism_1_N : N ; -- amoralism..nn.1
  amoralitet_1_N : N ; -- amoralitet..nn.1
  amorbåge_1_N : N ; -- amorbåge..nn.1
  amorf_1_A : A ; -- amorf..av.1
  amorfism_1_N : N ; -- amorfism..nn.1
  amorin_1_N : N ; -- amorin..nn.1
  amortera_1_V : V ; -- amortera..vb.1
  amorterande_1_N : N ; -- amorterande..nn.1
  amorterbar_1_A : A ; -- amorterbar..av.1
  amorterbarhet_1_N : N ; -- amorterbarhet..nn.1
  amortering_1_N : N ; -- amortering..nn.1
  amorteringsfond_1_N : N ; -- amorteringsfond..nn.1
  amorteringsfri_1_A : A ; -- amorteringsfri..av.1
  amorteringslån_1_N : N ; -- amorteringslån..nn.1
  amorteringsplan_1_N : N ; -- amorteringsplan..nn.1
  amorös_1_A : A ; -- amorös..av.1
  ampel_1_A : A ; -- ampel..av.1
  ampel_1_N : N ; -- ampel..nn.1
  amper_1_A : A ; -- amper..av.1
  ampere_1_N : N ; -- ampere..nn.1
  amperemeter_1_N : N ; -- amperemeter..nn.1
  amperesekund_1_N : N ; -- amperesekund..nn.1
  amperevarv_1_N : N ; -- amperevarv..nn.1
  amperhet_1_N : N ; -- amperhet..nn.1
  amplifiera_1_V : V ; -- amplifiera..vb.1
  amplifierande_1_N : N ; -- amplifierande..nn.1
  amplifierbar_1_A : A ; -- amplifierbar..av.1
  amplifierbarhet_1_N : N ; -- amplifierbarhet..nn.1
  amplifiering_1_N : N ; -- amplifiering..nn.1
  amplitud_1_N : N ; -- amplitud..nn.1
  amplitudmodulera_1_V : V ; -- amplitudmodulera..vb.1
  amplitudmodulerande_1_N : N ; -- amplitudmodulerande..nn.1
  amplitudmodulerbar_1_A : A ; -- amplitudmodulerbar..av.1
  amplitudmodulerbarhet_1_N : N ; -- amplitudmodulerbarhet..nn.1
  amplitudmodulering_1_N : N ; -- amplitudmodulering..nn.1
  ampull_1_N : N ; -- ampull..nn.1
  amputation_1_N : N ; -- amputation..nn.1
  amputera_1_V : V ; -- amputera..vb.1
  amputerande_1_N : N ; -- amputerande..nn.1
  amputerbar_1_A : A ; -- amputerbar..av.1
  amputerbarhet_1_N : N ; -- amputerbarhet..nn.1
  amputering_1_N : N ; -- amputering..nn.1
  amsaga_1_N : N ; -- amsaga..nn.1
  amt_1_N : N ; -- amt..nn.1
  amtman_1_N : N ; -- amtman..nn.1
  amulett_1_N : N ; -- amulett..nn.1
  amylas_1_N : N ; -- amylas..nn.1
  amyloidneuropati_1_N : N ; -- amyloidneuropati..nn.1
  amyloidos_1_N : N ; -- amyloidos..nn.1
  amyloidplack_1_N : N ; -- amyloidplack..nn.1
  amyotrofi_1_N : N ; -- amyotrofi..nn.1
  amöba_1_N : N ; -- amöba..nn.1
  amöbadysenteri_1_N : N ; -- amöbadysenteri..nn.1
  amöbainfektion_1_N : N ; -- amöbainfektion..nn.1
  ana_1_V : V ; -- ana..vb.1
  anabaptism_1_N : N ; -- anabaptism..nn.1
  anabaptist_1_N : N ; -- anabaptist..nn.1
  anabaptistisk_1_A : A ; -- anabaptistisk..av.1
  anabatisk_1_A : A ; -- anabatisk..av.1
  anabol_1_A : A ; -- anabol..av.1
  anabol_1_N : N ; -- anabol..nn.1
  anadrom_1_A : A ; -- anadrom..av.1
  anaerob_1_A : A ; -- anaerob..av.1
  anafor_1_N : N ; -- anafor..nn.1
  anaforisk_1_A : A ; -- anaforisk..av.1
  anafylaxi_1_N : N ; -- anafylaxi..nn.1
  anagram_1_N : N ; -- anagram..nn.1
  anakolut_1_N : N ; -- anakolut..nn.1
  anakolutisk_1_A : A ; -- anakolutisk..av.1
  anakonda_1_N : N ; -- anakonda..nn.1
  anakoret_1_N : N ; -- anakoret..nn.1
  anakreontisk_1_A : A ; -- anakreontisk..av.1
  anakronism_1_N : N ; -- anakronism..nn.1
  anakronistisk_1_A : A ; -- anakronistisk..av.1
  anal_1_A : A ; -- anal..av.1
  analatresi_1_N : N ; -- analatresi..nn.1
  analbuminemi_1_N : N ; -- analbuminemi..nn.1
  analcancer_1_N : N ; -- analcancer..nn.1
  analeptik_1_N : N ; -- analeptik..nn.1
  analfabet_1_N : N ; -- analfabet..nn.1
  analfabetisk_1_A : A ; -- analfabetisk..av.1
  analfabetism_1_N : N ; -- analfabetism..nn.1
  analfena_1_N : N ; -- analfena..nn.1
  analfissur_1_N : N ; -- analfissur..nn.1
  analgetika_1_N : N ; -- analgetika..nn.1
  analinkontinens_1_N : N ; -- analinkontinens..nn.1
  analkörtel_1_N : N ; -- analkörtel..nn.1
  analkörtelcancer_1_N : N ; -- analkörtelcancer..nn.1
  analkörteltumör_1_N : N ; -- analkörteltumör..nn.1
  analog_1_A : A ; -- analog..av.1
  analogi_1_N : N ; -- analogi..nn.1
  analogibevis_1_N : N ; -- analogibevis..nn.1
  analogibildning_1_N : N ; -- analogibildning..nn.1
  analogisk_1_A : A ; -- analogisk..av.1
  analogislut_1_N : N ; -- analogislut..nn.1
  analsex_1_N : N ; -- analsex..nn.1
  analsfinkter_1_N : N ; -- analsfinkter..nn.1
  analsjukdom_1_N : N ; -- analsjukdom..nn.1
  analtumör_1_N : N ; -- analtumör..nn.1
  analulcer_1_N : N ; -- analulcer..nn.1
  analys_1_N : N ; -- analys..nn.1
  analysera_1_V : V ; -- analysera..vb.1
  analyserande_1_N : N ; -- analyserande..nn.1
  analyserbar_1_A : A ; -- analyserbar..av.1
  analyserbarhet_1_N : N ; -- analyserbarhet..nn.1
  analysering_1_N : N ; -- analysering..nn.1
  analysmetodik_1_N : N ; -- analysmetodik..nn.1
  analytiker_1_N : N ; -- analytiker..nn.1
  analytisk_1_A : A ; -- analytisk..av.1
  analöppning_1_N : N ; -- analöppning..nn.1
  anamma_1_V : V ; -- anamma..vb.1
  anammande_1_N : N ; -- anammande..nn.1
  anamnes_1_N : N ; -- anamnes..nn.1
  ananas_1_N : N ; -- ananas..nn.1
  ananassallad_1_N : N ; -- ananassallad..nn.1
  anande_1_N : N ; -- anande..nn.1
  anapest_1_N : N ; -- anapest..nn.1
  anapestisk_1_A : A ; -- anapestisk..av.1
  anaplasi_1_N : N ; -- anaplasi..nn.1
  anaplasmainfektion_1_N : N ; -- anaplasmainfektion..nn.1
  anaplasmos_1_N : N ; -- anaplasmos..nn.1
  anarki_1_N : N ; -- anarki..nn.1
  anarkisk_1_A : A ; -- anarkisk..av.1
  anarkism_1_N : N ; -- anarkism..nn.1
  anarkist_1_N : N ; -- anarkist..nn.1
  anarkistisk_1_A : A ; -- anarkistisk..av.1
  anarkokapitalistisk_1_A : A ; -- anarkokapitalistisk..av.1
  anarkokommunistisk_1_A : A ; -- anarkokommunistisk..av.1
  anarkoprimitivistisk_1_A : A ; -- anarkoprimitivistisk..av.1
  anarkosyndikalism_1_N : N ; -- anarkosyndikalism..nn.1
  anarkosyndikalist_1_N : N ; -- anarkosyndikalist..nn.1
  anarkosyndikalistisk_1_A : A ; -- anarkosyndikalistisk..av.1
  anastas_1_N : N ; -- anastas..nn.1
  anastatisk_1_A : A ; -- anastatisk..av.1
  anastigmatisk_1_A : A ; -- anastigmatisk..av.1
  anastomos_1_N : N ; -- anastomos..nn.1
  anastomosläckage_1_N : N ; -- anastomosläckage..nn.1
  anatema_1_N : N ; -- anatema..nn.1
  anatolisk_1_A : A ; -- anatolisk..av.1
  anatom_1_N : N ; -- anatom..nn.1
  anatomi_1_N : N ; -- anatomi..nn.1
  anatomisal_1_N : N ; -- anatomisal..nn.1
  anatomisk_1_A : A ; -- anatomisk..av.1
  anbefalla_1_V : V ; -- anbefalla..vb.1
  anbefallande_1_N : N ; -- anbefallande..nn.1
  anbefallning_1_N : N ; -- anbefallning..nn.1
  anbelanga_1_V : V ; -- anbelanga..vb.1
  anbelangande_1_N : N ; -- anbelangande..nn.1
  anblick_1_N : N ; -- anblick..nn.1
  anblåspipa_1_N : N ; -- anblåspipa..nn.1
  anbringa_1_V : V ; -- anbringa..vb.1
  anbringande_1_N : N ; -- anbringande..nn.1
  anbringning_1_N : N ; -- anbringning..nn.1
  anbrott_1_N : N ; -- anbrott..nn.1
  anbud_1_N : N ; -- anbud..nn.1
  anbudsgivare_1_N : N ; -- anbudsgivare..nn.1
  ancestor_1_N : N ; -- ancestor..nn.1
  anciennitet_1_N : N ; -- anciennitet..nn.1
  and_1_N : N ; -- and..nn.1
  and_2_N : N ; -- and..nn.2
  anda_1_N : N ; -- anda..nn.1
  andakt_1_N : N ; -- andakt..nn.1
  andaktsbok_1_N : N ; -- andaktsbok..nn.1
  andaktsfull_1_A : A ; -- andaktsfull..av.1
  andaktsfullhet_1_N : N ; -- andaktsfullhet..nn.1
  andaktslitteratur_1_N : N ; -- andaktslitteratur..nn.1
  andaktssal_1_N : N ; -- andaktssal..nn.1
  andaktsstund_1_N : N ; -- andaktsstund..nn.1
  andaktsutövning_1_N : N ; -- andaktsutövning..nn.1
  andaktsövning_1_N : N ; -- andaktsövning..nn.1
  andalusisk_1_A : A ; -- andalusisk..av.1
  andante_1_N : N ; -- andante..nn.1
  ande_1_N : N ; -- ande..nn.1
  andebesvärjare_1_N : N ; -- andebesvärjare..nn.1
  andebesvärjelse_1_N : N ; -- andebesvärjelse..nn.1
  andedrag_1_N : N ; -- andedrag..nn.1
  andedräkt_1_N : N ; -- andedräkt..nn.1
  andefattig_1_A : A ; -- andefattig..av.1
  andefattigdom_1_N : N ; -- andefattigdom..nn.1
  andefattighet_1_N : N ; -- andefattighet..nn.1
  andekraft_1_N : N ; -- andekraft..nn.1
  andel_1_N : N ; -- andel..nn.1
  andelsförening_1_N : N ; -- andelsförening..nn.1
  andelös_1_A : A ; -- andelös..av.1
  andelöshet_1_N : N ; -- andelöshet..nn.1
  andemeddelande_1_N : N ; -- andemeddelande..nn.1
  andemening_1_N : N ; -- andemening..nn.1
  anderike_1_N : N ; -- anderike..nn.1
  anderöst_1_N : N ; -- anderöst..nn.1
  andeskådande_1_N : N ; -- andeskådande..nn.1
  andeskådare_1_N : N ; -- andeskådare..nn.1
  andeskåderi_1_N : N ; -- andeskåderi..nn.1
  andeskådning_1_N : N ; -- andeskådning..nn.1
  andestämma_1_N : N ; -- andestämma..nn.1
  andesyn_1_N : N ; -- andesyn..nn.1
  andetag_1_N : N ; -- andetag..nn.1
  andeuppenbarelse_1_N : N ; -- andeuppenbarelse..nn.1
  andeutdrivare_1_N : N ; -- andeutdrivare..nn.1
  andevärld_1_N : N ; -- andevärld..nn.1
  andeväsen_1_N : N ; -- andeväsen..nn.1
  andfigur_1_N : N ; -- andfigur..nn.1
  andfådd_1_A : A ; -- andfådd..av.1
  andfåddhet_1_N : N ; -- andfåddhet..nn.1
  andfågel_1_N : N ; -- andfågel..nn.1
  andhämtning_1_N : N ; -- andhämtning..nn.1
  andhämtningspaus_1_N : N ; -- andhämtningspaus..nn.1
  andhål_1_N : N ; -- andhål..nn.1
  andjakt_1_N : N ; -- andjakt..nn.1
  andlig_1_A : A ; -- andlig..av.1
  andligen_1_Adv : Adv ; -- andligen..ab.1
  andlighet_1_N : N ; -- andlighet..nn.1
  andlös_1_A : A ; -- andlös..av.1
  andlöshet_1_N : N ; -- andlöshet..nn.1
  andmat_1_N : N ; -- andmat..nn.1
  andning_1_N : N ; -- andning..nn.1
  andningsacidos_1_N : N ; -- andningsacidos..nn.1
  andningsalkalos_1_N : N ; -- andningsalkalos..nn.1
  andningsapparat_1_N : N ; -- andningsapparat..nn.1
  andningsbesvär_1_N : N ; -- andningsbesvär..nn.1
  andningsenzym_1_N : N ; -- andningsenzym..nn.1
  andningsförlamning_1_N : N ; -- andningsförlamning..nn.1
  andningshjälp_1_N : N ; -- andningshjälp..nn.1
  andningshål_1_N : N ; -- andningshål..nn.1
  andningsinsufficiens_1_N : N ; -- andningsinsufficiens..nn.1
  andningsljud_1_N : N ; -- andningsljud..nn.1
  andningsorgan_1_N : N ; -- andningsorgan..nn.1
  andningsparalys_1_N : N ; -- andningsparalys..nn.1
  andningspaus_1_N : N ; -- andningspaus..nn.1
  andningsreaktion_1_N : N ; -- andningsreaktion..nn.1
  andningsrör_1_N : N ; -- andningsrör..nn.1
  andningsrörelse_1_N : N ; -- andningsrörelse..nn.1
  andningsskydd_1_N : N ; -- andningsskydd..nn.1
  andningsstillestånd_1_N : N ; -- andningsstillestånd..nn.1
  andningsstörning_1_N : N ; -- andningsstörning..nn.1
  andningssvikt_1_N : N ; -- andningssvikt..nn.1
  andningssvårighet_1_N : N ; -- andningssvårighet..nn.1
  andningsuppehåll_1_N : N ; -- andningsuppehåll..nn.1
  andningsväg_1_N : N ; -- andningsväg..nn.1
  andnöd_1_N : N ; -- andnöd..nn.1
  andorran_1_N : N ; -- andorran..nn.1
  andorransk_1_A : A ; -- andorransk..av.1
  andorranska_1_N : N ; -- andorranska..nn.1
  andouillette_1_N : N ; -- andouillette..nn.1
  andra_1_V : V ; -- andra..vb.1
  andrabas_1_N : N ; -- andrabas..nn.1
  andrabil_1_N : N ; -- andrabil..nn.1
  andraderivata_1_N : N ; -- andraderivata..nn.1
  andrag_1_N : N ; -- andrag..nn.1
  andragande_1_N : N ; -- andragande..nn.1
  andragradsekvation_1_N : N ; -- andragradsekvation..nn.1
  andrahandsbutik_1_N : N ; -- andrahandsbutik..nn.1
  andrahandscitat_1_N : N ; -- andrahandscitat..nn.1
  andrahandsfaktorer_1_N : N ; -- andrahandsfaktorer..nn.1
  andrahandsföremål_1_N : N ; -- andrahandsföremål..nn.1
  andrahandsinformation_1_N : N ; -- andrahandsinformation..nn.1
  andrahandskälla_1_N : N ; -- andrahandskälla..nn.1
  andrahandsuppgift_1_N : N ; -- andrahandsuppgift..nn.1
  andrahandsval_1_N : N ; -- andrahandsval..nn.1
  andrahandsvärde_1_N : N ; -- andrahandsvärde..nn.1
  andrake_1_N : N ; -- andrake..nn.1
  andraklassbiljett_1_N : N ; -- andraklassbiljett..nn.1
  andraklasspassagerare_1_N : N ; -- andraklasspassagerare..nn.1
  andranamn_1_N : N ; -- andranamn..nn.1
  andraopponent_1_N : N ; -- andraopponent..nn.1
  andraplacering_1_N : N ; -- andraplacering..nn.1
  andraplans_1_A : A ; -- andraplans..av.1
  andraplats_1_N : N ; -- andraplats..nn.1
  andraslagsförmåga_1_N : N ; -- andraslagsförmåga..nn.1
  andratenor_1_N : N ; -- andratenor..nn.1
  andratidning_1_N : N ; -- andratidning..nn.1
  andreaskors_1_N : N ; -- andreaskors..nn.1
  andrebas_1_N : N ; -- andrebas..nn.1
  andrechef_1_N : N ; -- andrechef..nn.1
  andreopponent_1_N : N ; -- andreopponent..nn.1
  andretenor_1_N : N ; -- andretenor..nn.1
  androblastom_1_N : N ; -- androblastom..nn.1
  androfani_1_N : N ; -- androfani..nn.1
  androfobi_1_N : N ; -- androfobi..nn.1
  androgenokänslighetssyndrom_1_N : N ; -- androgenokänslighetssyndrom..nn.1
  androgyn_1_A : A ; -- androgyn..av.1
  androgyn_1_N : N ; -- androgyn..nn.1
  androgynhet_1_N : N ; -- androgynhet..nn.1
  android_1_N : N ; -- android..nn.1
  androidlur_1_N : N ; -- androidlur..nn.1
  androidmobil_1_N : N ; -- androidmobil..nn.1
  andryg_1_A : A ; -- andryg..av.1
  andryghet_1_N : N ; -- andryghet..nn.1
  andsträck_1_N : N ; -- andsträck..nn.1
  andtruten_1_A : A ; -- andtruten..av.1
  andtrutenhet_1_N : N ; -- andtrutenhet..nn.1
  andtäppa_1_N : N ; -- andtäppa..nn.1
  andtäppt_1_A : A ; -- andtäppt..av.1
  andur_1_N : N ; -- andur..nn.1
  andäktig_1_A : A ; -- andäktig..av.1
  andäktighet_1_N : N ; -- andäktighet..nn.1
  anekdot_1_N : N ; -- anekdot..nn.1
  anekdotartad_1_A : A ; -- anekdotartad..av.1
  anekdotberättare_1_N : N ; -- anekdotberättare..nn.1
  anekdotflora_1_N : N ; -- anekdotflora..nn.1
  anekdotisk_1_A : A ; -- anekdotisk..av.1
  anekdotsamling_1_N : N ; -- anekdotsamling..nn.1
  anemi_1_N : N ; -- anemi..nn.1
  anemisk_1_A : A ; -- anemisk..av.1
  anemometer_1_N : N ; -- anemometer..nn.1
  anemon_1_N : N ; -- anemon..nn.1
  anencefali_1_N : N ; -- anencefali..nn.1
  aneroidbarometer_1_N : N ; -- aneroidbarometer..nn.1
  anestesi_1_N : N ; -- anestesi..nn.1
  anestesiolog_1_N : N ; -- anestesiolog..nn.1
  anestesiologi_1_N : N ; -- anestesiologi..nn.1
  anestesirum_1_N : N ; -- anestesirum..nn.1
  anestetika_1_N : N ; -- anestetika..nn.1
  anestetisk_1_A : A ; -- anestetisk..av.1
  anetoderma_1_N : N ; -- anetoderma..nn.1
  aneuploidi_1_N : N ; -- aneuploidi..nn.1
  aneurysm_1_N : N ; -- aneurysm..nn.1
  anfader_1_N : N ; -- anfader..nn.1
  anfall_1_N : N ; -- anfall..nn.1
  anfalla_1_V : V ; -- anfalla..vb.1
  anfallande_1_N : N ; -- anfallande..nn.1
  anfallare_1_N : N ; -- anfallare..nn.1
  anfallsbas_1_N : N ; -- anfallsbas..nn.1
  anfallsfront_1_N : N ; -- anfallsfront..nn.1
  anfallskrig_1_N : N ; -- anfallskrig..nn.1
  anfallslinje_1_N : N ; -- anfallslinje..nn.1
  anfallsmässig_1_A : A ; -- anfallsmässig..av.1
  anfallsområde_1_N : N ; -- anfallsområde..nn.1
  anfallsrörelse_1_N : N ; -- anfallsrörelse..nn.1
  anfallssignal_1_N : N ; -- anfallssignal..nn.1
  anfallsspel_1_N : N ; -- anfallsspel..nn.1
  anfallsspelare_1_N : N ; -- anfallsspelare..nn.1
  anfallsvapen_1_N : N ; -- anfallsvapen..nn.1
  anfallsvinkel_1_N : N ; -- anfallsvinkel..nn.1
  anfallsvåg_1_N : N ; -- anfallsvåg..nn.1
  anfang_1_N : N ; -- anfang..nn.1
  anfart_1_N : N ; -- anfart..nn.1
  anflog_1_N : N ; -- anflog..nn.1
  anflygning_1_N : N ; -- anflygning..nn.1
  anfräta_1_V : V ; -- anfräta..vb.1
  anfrätande_1_N : N ; -- anfrätande..nn.1
  anfrätning_1_N : N ; -- anfrätning..nn.1
  anfrätt_1_A : A ; -- anfrätt..av.1
  anfäkta_1_V : V ; -- anfäkta..vb.1
  anfäktad_1_A : A ; -- anfäktad..av.1
  anfäktande_1_N : N ; -- anfäktande..nn.1
  anfäktelse_1_N : N ; -- anfäktelse..nn.1
  anfäktning_1_N : N ; -- anfäktning..nn.1
  anföra_1_V : V ; -- anföra..vb.1
  anförande_1_N : N ; -- anförande..nn.1
  anförare_1_N : N ; -- anförare..nn.1
  anförarförmåga_1_N : N ; -- anförarförmåga..nn.1
  anförarskap_1_N : N ; -- anförarskap..nn.1
  anförarskicklighet_1_N : N ; -- anförarskicklighet..nn.1
  anföring_1_N : N ; -- anföring..nn.1
  anföringssats_1_N : N ; -- anföringssats..nn.1
  anföringstecken_1_N : N ; -- anföringstecken..nn.1
  anföringsverb_1_N : N ; -- anföringsverb..nn.1
  anförtro_1_V : V ; -- anförtro..vb.1
  anförtroende_1_N : N ; -- anförtroende..nn.1
  anförvant_1_N : N ; -- anförvant..nn.1
  anförvantskap_1_N : N ; -- anförvantskap..nn.1
  ange_1_V : V ; -- ange..vb.1
  angel_1_N : N ; -- angel..nn.1
  angelologi_1_N : N ; -- angelologi..nn.1
  angelsachsare_1_N : N ; -- angelsachsare..nn.1
  angelsachsisk_1_A : A ; -- angelsachsisk..av.1
  angelsaxare_1_N : N ; -- angelsaxare..nn.1
  angelsaxisk_1_A : A ; -- angelsaxisk..av.1
  angelägen_1_A : A ; -- angelägen..av.1
  angelägenhet_1_N : N ; -- angelägenhet..nn.1
  angenäm_1_A : A ; -- angenäm..av.1
  angenämhet_1_N : N ; -- angenämhet..nn.1
  angina_1_N : N ; -- angina..nn.1
  angiodysplasi_1_N : N ; -- angiodysplasi..nn.1
  angiofibrom_1_N : N ; -- angiofibrom..nn.1
  angiografi_1_N : N ; -- angiografi..nn.1
  angiokeratom_1_N : N ; -- angiokeratom..nn.1
  angioleiomyom_1_N : N ; -- angioleiomyom..nn.1
  angiolipom_1_N : N ; -- angiolipom..nn.1
  angiologi_1_N : N ; -- angiologi..nn.1
  angiom_1_N : N ; -- angiom..nn.1
  angiomatos_1_N : N ; -- angiomatos..nn.1
  angiomyolipom_1_N : N ; -- angiomyolipom..nn.1
  angiomyom_1_N : N ; -- angiomyom..nn.1
  angiosperm_1_N : N ; -- angiosperm..nn.1
  angioödem_1_N : N ; -- angioödem..nn.1
  angit_1_N : N ; -- angit..nn.1
  angivande_1_N : N ; -- angivande..nn.1
  angivare_1_N : N ; -- angivare..nn.1
  angivelse_1_N : N ; -- angivelse..nn.1
  angivelsebrott_1_N : N ; -- angivelsebrott..nn.1
  angiveri_1_N : N ; -- angiveri..nn.1
  angiverilag_1_N : N ; -- angiverilag..nn.1
  angla_1_V : V ; -- angla..vb.1
  anglande_1_N : N ; -- anglande..nn.1
  anglicism_1_N : N ; -- anglicism..nn.1
  anglicistisk_1_A : A ; -- anglicistisk..av.1
  anglifiera_1_V : V ; -- anglifiera..vb.1
  anglifierande_1_N : N ; -- anglifierande..nn.1
  anglifierbar_1_A : A ; -- anglifierbar..av.1
  anglifierbarhet_1_N : N ; -- anglifierbarhet..nn.1
  anglifiering_1_N : N ; -- anglifiering..nn.1
  anglikansk_1_A : A ; -- anglikansk..av.1
  anglisera_1_V : V ; -- anglisera..vb.1
  angliserande_1_N : N ; -- angliserande..nn.1
  angliserbar_1_A : A ; -- angliserbar..av.1
  angliserbarhet_1_N : N ; -- angliserbarhet..nn.1
  anglisering_1_N : N ; -- anglisering..nn.1
  anglist_1_N : N ; -- anglist..nn.1
  angloamerikansk_1_A : A ; -- angloamerikansk..av.1
  anglosachsare_1_N : N ; -- anglosachsare..nn.1
  anglosachsisk_1_A : A ; -- anglosachsisk..av.1
  anglosaxare_1_N : N ; -- anglosaxare..nn.1
  anglosaxisk_1_A : A ; -- anglosaxisk..av.1
  angläs_1_N : N ; -- angläs..nn.1
  angolan_1_N : N ; -- angolan..nn.1
  angolansk_1_A : A ; -- angolansk..av.1
  angolanska_1_N : N ; -- angolanska..nn.1
  angoragarn_1_N : N ; -- angoragarn..nn.1
  angoraget_1_N : N ; -- angoraget..nn.1
  angorajumper_1_N : N ; -- angorajumper..nn.1
  angorakatt_1_N : N ; -- angorakatt..nn.1
  angoraull_1_N : N ; -- angoraull..nn.1
  angostura_1_N : N ; -- angostura..nn.1
  angrepp_1_N : N ; -- angrepp..nn.1
  angreppsmål_1_N : N ; -- angreppsmål..nn.1
  angreppspunkt_1_N : N ; -- angreppspunkt..nn.1
  angreppssätt_1_N : N ; -- angreppssätt..nn.1
  angripa_1_V : V ; -- angripa..vb.1
  angripande_1_N : N ; -- angripande..nn.1
  angripare_1_N : N ; -- angripare..nn.1
  angripbar_1_A : A ; -- angripbar..av.1
  angränsa_1_V : V ; -- angränsa..vb.1
  angränsande_1_A : A ; -- angränsande..av.1
  angränsande_1_N : N ; -- angränsande..nn.1
  angå_1_V : V ; -- angå..vb.1
  angöra_1_V : V ; -- angöra..vb.1
  angörande_1_N : N ; -- angörande..nn.1
  anhalt_1_N : N ; -- anhalt..nn.1
  anhang_1_N : N ; -- anhang..nn.1
  anhopa_1_V : V ; -- anhopa..vb.1
  anhopande_1_N : N ; -- anhopande..nn.1
  anhopning_1_N : N ; -- anhopning..nn.1
  anhängare_1_N : N ; -- anhängare..nn.1
  anhängarskara_1_N : N ; -- anhängarskara..nn.1
  anhängig_1_A : A ; -- anhängig..av.1
  anhåll_1_N : N ; -- anhåll..nn.1
  anhålla_1_V : V ; -- anhålla..vb.1
  anhållan_1_N : N ; -- anhållan..nn.1
  anhållande_1_N : N ; -- anhållande..nn.1
  anhållningsbeslut_1_N : N ; -- anhållningsbeslut..nn.1
  anhörig_1_A : A ; -- anhörig..av.1
  anhörigdag_1_N : N ; -- anhörigdag..nn.1
  anhörighet_1_N : N ; -- anhörighet..nn.1
  anhöriginvandring_1_N : N ; -- anhöriginvandring..nn.1
  anhörigvård_1_N : N ; -- anhörigvård..nn.1
  anhörigvårdare_1_N : N ; -- anhörigvårdare..nn.1
  anilin_1_N : N ; -- anilin..nn.1
  anilinfärg_1_N : N ; -- anilinfärg..nn.1
  anilinfärgad_1_A : A ; -- anilinfärgad..av.1
  anilinolja_1_N : N ; -- anilinolja..nn.1
  anilinröd_1_A : A ; -- anilinröd..av.1
  animal_1_A : A ; -- animal..av.1
  animalisk_1_A : A ; -- animalisk..av.1
  animation_1_N : N ; -- animation..nn.1
  animatör_1_N : N ; -- animatör..nn.1
  animera_1_V : V ; -- animera..vb.1
  animerad_1_A : A ; -- animerad..av.1
  animerande_1_N : N ; -- animerande..nn.1
  animerbar_1_A : A ; -- animerbar..av.1
  animerbarhet_1_N : N ; -- animerbarhet..nn.1
  animering_1_N : N ; -- animering..nn.1
  animism_1_N : N ; -- animism..nn.1
  animistisk_1_A : A ; -- animistisk..av.1
  animositet_1_N : N ; -- animositet..nn.1
  aning_1_N : N ; -- aning..nn.1
  aningen_1_Adv : Adv ; -- aningen..ab.1
  aningens_1_Adv : Adv ; -- aningens..ab.1
  aningsfull_1_A : A ; -- aningsfull..av.1
  aningslös_1_A : A ; -- aningslös..av.1
  aningslöshet_1_N : N ; -- aningslöshet..nn.1
  aniridi_1_N : N ; -- aniridi..nn.1
  anis_1_N : N ; -- anis..nn.1
  anisakiasis_1_N : N ; -- anisakiasis..nn.1
  anisbrännvin_1_N : N ; -- anisbrännvin..nn.1
  anisbröd_1_N : N ; -- anisbröd..nn.1
  aniseikoni_1_N : N ; -- aniseikoni..nn.1
  anisett_1_N : N ; -- anisett..nn.1
  anisettlikör_1_N : N ; -- anisettlikör..nn.1
  anislikör_1_N : N ; -- anislikör..nn.1
  anisokori_1_N : N ; -- anisokori..nn.1
  anisolja_1_N : N ; -- anisolja..nn.1
  anisometropi_1_N : N ; -- anisometropi..nn.1
  anjon_1_N : N ; -- anjon..nn.1
  anka_1_N : N ; -- anka..nn.1
  ankar_1_N : N ; -- ankar..nn.1
  ankararm_1_N : N ; -- ankararm..nn.1
  ankarboj_1_N : N ; -- ankarboj..nn.1
  ankarbult_1_N : N ; -- ankarbult..nn.1
  ankare_1_N : N ; -- ankare..nn.1
  ankarfly_1_N : N ; -- ankarfly..nn.1
  ankarfäste_1_N : N ; -- ankarfäste..nn.1
  ankargrund_1_N : N ; -- ankargrund..nn.1
  ankarjärn_1_N : N ; -- ankarjärn..nn.1
  ankarkabel_1_N : N ; -- ankarkabel..nn.1
  ankarklys_1_N : N ; -- ankarklys..nn.1
  ankarkropp_1_N : N ; -- ankarkropp..nn.1
  ankarkätting_1_N : N ; -- ankarkätting..nn.1
  ankarlindning_1_N : N ; -- ankarlindning..nn.1
  ankarplats_1_N : N ; -- ankarplats..nn.1
  ankarslut_1_N : N ; -- ankarslut..nn.1
  ankarspel_1_N : N ; -- ankarspel..nn.1
  ankarstock_1_N : N ; -- ankarstock..nn.1
  ankartross_1_N : N ; -- ankartross..nn.1
  ankartåg_1_N : N ; -- ankartåg..nn.1
  ankarur_1_N : N ; -- ankarur..nn.1
  ankbonde_1_N : N ; -- ankbonde..nn.1
  ankbröst_1_N : N ; -- ankbröst..nn.1
  ankdamm_1_N : N ; -- ankdamm..nn.1
  ankel_1_N : N ; -- ankel..nn.1
  ankelled_1_N : N ; -- ankelled..nn.1
  ankellång_1_A : A ; -- ankellång..av.1
  ankelsocka_1_N : N ; -- ankelsocka..nn.1
  ankism_1_N : N ; -- ankism..nn.1
  ankistisk_1_A : A ; -- ankistisk..av.1
  anklaga_1_V : V ; -- anklaga..vb.1
  anklagande_1_N : N ; -- anklagande..nn.1
  anklagare_1_N : N ; -- anklagare..nn.1
  anklagelse_1_N : N ; -- anklagelse..nn.1
  anklagelseakt_1_N : N ; -- anklagelseakt..nn.1
  anklagelsepunkt_1_N : N ; -- anklagelsepunkt..nn.1
  anklagelseskrift_1_N : N ; -- anklagelseskrift..nn.1
  anklang_1_N : N ; -- anklang..nn.1
  ankläpp_1_N : N ; -- ankläpp..nn.1
  anknyta_1_V : V ; -- anknyta..vb.1
  anknytande_1_N : N ; -- anknytande..nn.1
  anknytning_1_N : N ; -- anknytning..nn.1
  ankomma_1_V : V ; -- ankomma..vb.1
  ankommande_1_N : N ; -- ankommande..nn.1
  ankommen_1_A : A ; -- ankommen..av.1
  ankommenhet_1_N : N ; -- ankommenhet..nn.1
  ankomst_1_N : N ; -- ankomst..nn.1
  ankomstdag_1_N : N ; -- ankomstdag..nn.1
  ankomsthall_1_N : N ; -- ankomsthall..nn.1
  ankomstkommun_1_N : N ; -- ankomstkommun..nn.1
  ankomstort_1_N : N ; -- ankomstort..nn.1
  ankomststation_1_N : N ; -- ankomststation..nn.1
  ankomsttid_1_N : N ; -- ankomsttid..nn.1
  ankra_1_V : V ; -- ankra..vb.1
  ankrande_1_N : N ; -- ankrande..nn.1
  ankring_1_N : N ; -- ankring..nn.1
  ankringsplats_1_N : N ; -- ankringsplats..nn.1
  ankunge_1_N : N ; -- ankunge..nn.1
  ankylos_1_N : N ; -- ankylos..nn.1
  ankylostomiasis_1_N : N ; -- ankylostomiasis..nn.1
  ankägg_1_N : N ; -- ankägg..nn.1
  anlag_1_N : N ; -- anlag..nn.1
  anlagsbärare_1_N : N ; -- anlagsbärare..nn.1
  anlagstest_1_N : N ; -- anlagstest..nn.1
  anlagstestning_1_N : N ; -- anlagstestning..nn.1
  anledning_1_N : N ; -- anledning..nn.1
  anlete_1_N : N ; -- anlete..nn.1
  anletsdrag_1_N : N ; -- anletsdrag..nn.1
  anligga_1_V : V ; -- anligga..vb.1
  anliggande_1_N : N ; -- anliggande..nn.1
  anliggning_1_N : N ; -- anliggning..nn.1
  anliggningspunkt_1_N : N ; -- anliggningspunkt..nn.1
  anliggningsyta_1_N : N ; -- anliggningsyta..nn.1
  anlita_1_V : V ; -- anlita..vb.1
  anlitande_1_N : N ; -- anlitande..nn.1
  anlopp_1_N : N ; -- anlopp..nn.1
  anloppshamn_1_N : N ; -- anloppshamn..nn.1
  anlupen_1_A : A ; -- anlupen..av.1
  anlupenhet_1_N : N ; -- anlupenhet..nn.1
  anlägga_1_V : V ; -- anlägga..vb.1
  anläggande_1_N : N ; -- anläggande..nn.1
  anläggare_1_N : N ; -- anläggare..nn.1
  anläggning_1_N : N ; -- anläggning..nn.1
  anläggning_2_N : N ; -- anläggning..nn.2
  anläggningsarbetare_1_N : N ; -- anläggningsarbetare..nn.1
  anläggningskostnad_1_N : N ; -- anläggningskostnad..nn.1
  anläggningsplats_1_N : N ; -- anläggningsplats..nn.1
  anläggningstillgång_1_N : N ; -- anläggningstillgång..nn.1
  anläggningsyta_1_N : N ; -- anläggningsyta..nn.1
  anlända_1_V : V ; -- anlända..vb.1
  anländande_1_N : N ; -- anländande..nn.1
  anlöpa_1_V : V ; -- anlöpa..vb.1
  anlöpande_1_N : N ; -- anlöpande..nn.1
  anlöpning_1_N : N ; -- anlöpning..nn.1
  anlöpningshamn_1_N : N ; -- anlöpningshamn..nn.1
  anmana_1_V : V ; -- anmana..vb.1
  anmanande_1_N : N ; -- anmanande..nn.1
  anmaning_1_N : N ; -- anmaning..nn.1
  anmarsch_1_N : N ; -- anmarsch..nn.1
  anmarschering_1_N : N ; -- anmarschering..nn.1
  anmoda_1_V : V ; -- anmoda..vb.1
  anmodande_1_N : N ; -- anmodande..nn.1
  anmoder_1_N : N ; -- anmoder..nn.1
  anmäla_1_V : V ; -- anmäla..vb.1
  anmälan_2_N : N ; -- anmälan..nn.2
  anmälande_1_N : N ; -- anmälande..nn.1
  anmälare_1_N : N ; -- anmälare..nn.1
  anmälning_1_N : N ; -- anmälning..nn.1
  anmälningsbenägenhet_1_N : N ; -- anmälningsbenägenhet..nn.1
  anmälningsplikt_1_N : N ; -- anmälningsplikt..nn.1
  anmälningspliktig_1_A : A ; -- anmälningspliktig..av.1
  anmälningsskyldig_1_A : A ; -- anmälningsskyldig..av.1
  anmälningstid_1_N : N ; -- anmälningstid..nn.1
  anmärka_1_V : V ; -- anmärka..vb.1
  anmärkande_1_N : N ; -- anmärkande..nn.1
  anmärkare_1_N : N ; -- anmärkare..nn.1
  anmärkning_1_N : N ; -- anmärkning..nn.1
  anmärkningsbok_1_N : N ; -- anmärkningsbok..nn.1
  anmärkningsvärd_1_A : A ; -- anmärkningsvärd..av.1
  anmärkningsvärdhet_1_N : N ; -- anmärkningsvärdhet..nn.1
  annalist_1_N : N ; -- annalist..nn.1
  annalkande_1_A : A ; -- annalkande..av.1
  annalkande_1_N : N ; -- annalkande..nn.1
  annalskrivning_1_N : N ; -- annalskrivning..nn.1
  annandag_1_N : N ; -- annandag..nn.1
  annanstans_1_Adv : Adv ; -- annanstans..ab.1
  annars_1_Adv : Adv ; -- annars..ab.1
  annatto_1_N : N ; -- annatto..nn.1
  annektera_1_V : V ; -- annektera..vb.1
  annekterande_1_N : N ; -- annekterande..nn.1
  annekterbar_1_A : A ; -- annekterbar..av.1
  annekterbarhet_1_N : N ; -- annekterbarhet..nn.1
  annektering_1_N : N ; -- annektering..nn.1
  annektion_1_N : N ; -- annektion..nn.1
  annex_1_N : N ; -- annex..nn.1
  annexförsamling_1_N : N ; -- annexförsamling..nn.1
  annexion_1_N : N ; -- annexion..nn.1
  annexionspolitik_1_N : N ; -- annexionspolitik..nn.1
  annexkyrka_1_N : N ; -- annexkyrka..nn.1
  annihilation_1_N : N ; -- annihilation..nn.1
  annihilera_1_V : V ; -- annihilera..vb.1
  annihilerande_1_N : N ; -- annihilerande..nn.1
  annihilerbar_1_A : A ; -- annihilerbar..av.1
  annihilerbarhet_1_N : N ; -- annihilerbarhet..nn.1
  annihilering_1_N : N ; -- annihilering..nn.1
  anno_1_Adv : Adv ; -- anno..ab.1
  annons_1_N : N ; -- annons..nn.1
  annonsblad_1_N : N ; -- annonsblad..nn.1
  annonsbojkott_1_N : N ; -- annonsbojkott..nn.1
  annonsbyrå_1_N : N ; -- annonsbyrå..nn.1
  annonsera_1_V : V ; -- annonsera..vb.1
  annonserande_1_N : N ; -- annonserande..nn.1
  annonserbar_1_A : A ; -- annonserbar..av.1
  annonserbarhet_1_N : N ; -- annonserbarhet..nn.1
  annonsering_1_N : N ; -- annonsering..nn.1
  annonsinkomst_1_N : N ; -- annonsinkomst..nn.1
  annonskampanj_1_N : N ; -- annonskampanj..nn.1
  annonspelare_1_N : N ; -- annonspelare..nn.1
  annonsplats_1_N : N ; -- annonsplats..nn.1
  annonssvar_1_N : N ; -- annonssvar..nn.1
  annonstavla_1_N : N ; -- annonstavla..nn.1
  annonstidning_1_N : N ; -- annonstidning..nn.1
  annonsör_1_N : N ; -- annonsör..nn.1
  annorledes_1_Adv : Adv ; -- annorledes..ab.1
  annorlunda_1_Adv : Adv ; -- annorlunda..ab.1
  annorlunda_1_A : A ; -- annorlunda..av.1
  annorstädes_1_Adv : Adv ; -- annorstädes..ab.1
  annotation_1_N : N ; -- annotation..nn.1
  annotationsbok_1_N : N ; -- annotationsbok..nn.1
  annotera_1_V : V ; -- annotera..vb.1
  annoterande_1_N : N ; -- annoterande..nn.1
  annoterbar_1_A : A ; -- annoterbar..av.1
  annoterbarhet_1_N : N ; -- annoterbarhet..nn.1
  annotering_1_N : N ; -- annotering..nn.1
  annuell_1_A : A ; -- annuell..av.1
  annuitet_1_N : N ; -- annuitet..nn.1
  annuitetslån_1_N : N ; -- annuitetslån..nn.1
  annullera_1_V : V ; -- annullera..vb.1
  annullerande_1_N : N ; -- annullerande..nn.1
  annullerbar_1_A : A ; -- annullerbar..av.1
  annullerbarhet_1_N : N ; -- annullerbarhet..nn.1
  annullering_1_N : N ; -- annullering..nn.1
  anod_1_N : N ; -- anod..nn.1
  anodisera_1_V : V ; -- anodisera..vb.1
  anodiserande_1_N : N ; -- anodiserande..nn.1
  anodiserbar_1_A : A ; -- anodiserbar..av.1
  anodiserbarhet_1_N : N ; -- anodiserbarhet..nn.1
  anodisering_1_N : N ; -- anodisering..nn.1
  anodonti_1_N : N ; -- anodonti..nn.1
  anoftalmi_1_N : N ; -- anoftalmi..nn.1
  anomal_1_A : A ; -- anomal..av.1
  anomali_1_N : N ; -- anomali..nn.1
  anomalisk_1_A : A ; -- anomalisk..av.1
  anomalistisk_1_A : A ; -- anomalistisk..av.1
  anomi_1_N : N ; -- anomi..nn.1
  anonym_1_A : A ; -- anonym..av.1
  anonymhet_1_N : N ; -- anonymhet..nn.1
  anonymisera_1_V : V ; -- anonymisera..vb.1
  anonymiserande_1_N : N ; -- anonymiserande..nn.1
  anonymiserbar_1_A : A ; -- anonymiserbar..av.1
  anonymiserbarhet_1_N : N ; -- anonymiserbarhet..nn.1
  anonymisering_1_N : N ; -- anonymisering..nn.1
  anonymiseringsverktyg_1_N : N ; -- anonymiseringsverktyg..nn.1
  anonymitet_1_N : N ; -- anonymitet..nn.1
  anorak_1_N : N ; -- anorak..nn.1
  anordna_1_V : V ; -- anordna..vb.1
  anordnande_1_N : N ; -- anordnande..nn.1
  anordnare_1_N : N ; -- anordnare..nn.1
  anordning_1_N : N ; -- anordning..nn.1
  anorektiker_1_N : N ; -- anorektiker..nn.1
  anorektisk_1_A : A ; -- anorektisk..av.1
  anorektiskhet_1_N : N ; -- anorektiskhet..nn.1
  anorexi_1_N : N ; -- anorexi..nn.1
  anorexihets_1_N : N ; -- anorexihets..nn.1
  anormal_1_A : A ; -- anormal..av.1
  anosmi_1_N : N ; -- anosmi..nn.1
  anoxemi_1_N : N ; -- anoxemi..nn.1
  anoxi_1_N : N ; -- anoxi..nn.1
  anpart_1_N : N ; -- anpart..nn.1
  anpassa_1_V : V ; -- anpassa..vb.1
  anpassande_1_N : N ; -- anpassande..nn.1
  anpassbar_1_A : A ; -- anpassbar..av.1
  anpassbarhet_1_N : N ; -- anpassbarhet..nn.1
  anpasslig_1_A : A ; -- anpasslig..av.1
  anpasslighet_1_N : N ; -- anpasslighet..nn.1
  anpassling_1_N : N ; -- anpassling..nn.1
  anpassning_1_N : N ; -- anpassning..nn.1
  anpassningsbar_1_A : A ; -- anpassningsbar..av.1
  anpassningsförmåga_1_N : N ; -- anpassningsförmåga..nn.1
  anpassningsgrupp_1_N : N ; -- anpassningsgrupp..nn.1
  anpassningsklinik_1_N : N ; -- anpassningsklinik..nn.1
  anrik_1_A : A ; -- anrik..av.1
  anrika_1_V : V ; -- anrika..vb.1
  anrikande_1_N : N ; -- anrikande..nn.1
  anrikhet_1_N : N ; -- anrikhet..nn.1
  anrikning_1_N : N ; -- anrikning..nn.1
  anrikningsanläggning_1_N : N ; -- anrikningsanläggning..nn.1
  anrop_1_N : N ; -- anrop..nn.1
  anropa_1_V : V ; -- anropa..vb.1
  anropande_1_N : N ; -- anropande..nn.1
  anropning_1_N : N ; -- anropning..nn.1
  anropsknapp_1_N : N ; -- anropsknapp..nn.1
  anropsnummer_1_N : N ; -- anropsnummer..nn.1
  anropssignal_1_N : N ; -- anropssignal..nn.1
  anryckning_1_N : N ; -- anryckning..nn.1
  anrätta_1_V : V ; -- anrätta..vb.1
  anrättande_1_N : N ; -- anrättande..nn.1
  anrättning_1_N : N ; -- anrättning..nn.1
  ans_1_N : N ; -- ans..nn.1
  ansa_1_V : V ; -- ansa..vb.1
  ansamla_1_V : V ; -- ansamla..vb.1
  ansamlande_1_N : N ; -- ansamlande..nn.1
  ansamling_1_N : N ; -- ansamling..nn.1
  ansande_1_N : N ; -- ansande..nn.1
  ansats_1_N : N ; -- ansats..nn.1
  ansatsbana_1_N : N ; -- ansatsbana..nn.1
  ansatsrör_1_N : N ; -- ansatsrör..nn.1
  anse_1_V : V ; -- anse..vb.1
  ansedd_1_A : A ; -- ansedd..av.1
  anseddhet_1_N : N ; -- anseddhet..nn.1
  ansedel_1_N : N ; -- ansedel..nn.1
  anseende_1_N : N ; -- anseende..nn.1
  ansenlig_1_A : A ; -- ansenlig..av.1
  ansenlighet_1_N : N ; -- ansenlighet..nn.1
  ansikte_1_N : N ; -- ansikte..nn.1
  ansiktsasymmetri_1_N : N ; -- ansiktsasymmetri..nn.1
  ansiktsbehandling_1_N : N ; -- ansiktsbehandling..nn.1
  ansiktsbehåring_1_N : N ; -- ansiktsbehåring..nn.1
  ansiktsbjudning_1_N : N ; -- ansiktsbjudning..nn.1
  ansiktsblind_1_A : A ; -- ansiktsblind..av.1
  ansiktsblindhet_1_N : N ; -- ansiktsblindhet..nn.1
  ansiktscancer_1_N : N ; -- ansiktscancer..nn.1
  ansiktsdermatos_1_N : N ; -- ansiktsdermatos..nn.1
  ansiktsdrag_1_N : N ; -- ansiktsdrag..nn.1
  ansiktsform_1_N : N ; -- ansiktsform..nn.1
  ansiktsfärg_1_N : N ; -- ansiktsfärg..nn.1
  ansiktsförlamning_1_N : N ; -- ansiktsförlamning..nn.1
  ansiktsigenkänning_1_N : N ; -- ansiktsigenkänning..nn.1
  ansiktskräm_1_N : N ; -- ansiktskräm..nn.1
  ansiktslyft_1_N : N ; -- ansiktslyft..nn.1
  ansiktslyftning_1_N : N ; -- ansiktslyftning..nn.1
  ansiktslös_1_A : A ; -- ansiktslös..av.1
  ansiktsmask_1_N : N ; -- ansiktsmask..nn.1
  ansiktsmissbildning_1_N : N ; -- ansiktsmissbildning..nn.1
  ansiktsmuskel_1_N : N ; -- ansiktsmuskel..nn.1
  ansiktsmålning_1_N : N ; -- ansiktsmålning..nn.1
  ansiktsnerv_1_N : N ; -- ansiktsnerv..nn.1
  ansiktsnervssjukdom_1_N : N ; -- ansiktsnervssjukdom..nn.1
  ansiktsneuralgi_1_N : N ; -- ansiktsneuralgi..nn.1
  ansiktsoval_1_N : N ; -- ansiktsoval..nn.1
  ansiktsskada_1_N : N ; -- ansiktsskada..nn.1
  ansiktsskydd_1_N : N ; -- ansiktsskydd..nn.1
  ansiktssmärta_1_N : N ; -- ansiktssmärta..nn.1
  ansiktstumör_1_N : N ; -- ansiktstumör..nn.1
  ansiktsuttryck_1_N : N ; -- ansiktsuttryck..nn.1
  ansjovis_1_N : N ; -- ansjovis..nn.1
  anskaffa_1_V : V ; -- anskaffa..vb.1
  anskaffande_1_N : N ; -- anskaffande..nn.1
  anskaffare_1_N : N ; -- anskaffare..nn.1
  anskaffbar_1_A : A ; -- anskaffbar..av.1
  anskaffning_1_N : N ; -- anskaffning..nn.1
  anskaffningsdag_1_N : N ; -- anskaffningsdag..nn.1
  anskaffningskostnad_1_N : N ; -- anskaffningskostnad..nn.1
  anskri_1_N : N ; -- anskri..nn.1
  anskriven_1_A : A ; -- anskriven..av.1
  anskrämlig_1_A : A ; -- anskrämlig..av.1
  anskrämlighet_1_N : N ; -- anskrämlighet..nn.1
  anslag_1_N : N ; -- anslag..nn.1
  anslagsbeviljande_1_A : A ; -- anslagsbeviljande..av.1
  anslagsbevillning_1_N : N ; -- anslagsbevillning..nn.1
  anslagsframställning_1_N : N ; -- anslagsframställning..nn.1
  anslagsfråga_1_N : N ; -- anslagsfråga..nn.1
  anslagsgivande_1_A : A ; -- anslagsgivande..av.1
  anslagsmässig_1_A : A ; -- anslagsmässig..av.1
  anslagssumma_1_N : N ; -- anslagssumma..nn.1
  anslagstavla_1_N : N ; -- anslagstavla..nn.1
  anslagstid_1_N : N ; -- anslagstid..nn.1
  anslagsäskande_1_N : N ; -- anslagsäskande..nn.1
  ansluta_1_V : V ; -- ansluta..vb.1
  anslutande_1_N : N ; -- anslutande..nn.1
  anslutning_1_N : N ; -- anslutning..nn.1
  anslutningsavtal_1_N : N ; -- anslutningsavtal..nn.1
  anslutningsbox_1_N : N ; -- anslutningsbox..nn.1
  anslutningskabel_1_N : N ; -- anslutningskabel..nn.1
  anslutningskontakt_1_N : N ; -- anslutningskontakt..nn.1
  anslutningspunkt_1_N : N ; -- anslutningspunkt..nn.1
  anslutningsserver_1_N : N ; -- anslutningsserver..nn.1
  anslutningssladd_1_N : N ; -- anslutningssladd..nn.1
  anslå_1_V : V ; -- anslå..vb.1
  anslående_1_A : A ; -- anslående..av.1
  anslående_1_N : N ; -- anslående..nn.1
  ansning_1_N : N ; -- ansning..nn.1
  anspann_1_N : N ; -- anspann..nn.1
  anspela_1_V : V ; -- anspela..vb.1
  anspelande_1_N : N ; -- anspelande..nn.1
  anspelning_1_N : N ; -- anspelning..nn.1
  anspråk_1_N : N ; -- anspråk..nn.1
  anspråklös_1_A : A ; -- anspråklös..av.1
  anspråksfull_1_A : A ; -- anspråksfull..av.1
  anspråksfullhet_1_N : N ; -- anspråksfullhet..nn.1
  anspråkslös_1_A : A ; -- anspråkslös..av.1
  anspråkslöshet_1_N : N ; -- anspråkslöshet..nn.1
  anspänd_1_A : A ; -- anspänd..av.1
  anspändhet_1_N : N ; -- anspändhet..nn.1
  anspänning_1_N : N ; -- anspänning..nn.1
  anstalt_1_N : N ; -- anstalt..nn.1
  anstalta_1_V : V ; -- anstalta..vb.1
  anstaltande_1_N : N ; -- anstaltande..nn.1
  anstaltspastor_1_N : N ; -- anstaltspastor..nn.1
  anstaltsvistelse_1_N : N ; -- anstaltsvistelse..nn.1
  anstaltsvård_1_N : N ; -- anstaltsvård..nn.1
  anstifta_1_V : V ; -- anstifta..vb.1
  anstiftande_1_N : N ; -- anstiftande..nn.1
  anstiftare_1_N : N ; -- anstiftare..nn.1
  anstiftelse_1_N : N ; -- anstiftelse..nn.1
  anstorma_1_V : V ; -- anstorma..vb.1
  anstormande_1_N : N ; -- anstormande..nn.1
  anstormning_1_N : N ; -- anstormning..nn.1
  anstruken_1_A : A ; -- anstruken..av.1
  anstrukenhet_1_N : N ; -- anstrukenhet..nn.1
  anstryka_1_V : V ; -- anstryka..vb.1
  anstrykande_1_N : N ; -- anstrykande..nn.1
  anstrykare_1_N : N ; -- anstrykare..nn.1
  anstrykning_1_N : N ; -- anstrykning..nn.1
  anstränga_1_V : V ; -- anstränga..vb.1
  ansträngande_1_A : A ; -- ansträngande..av.1
  ansträngande_1_N : N ; -- ansträngande..nn.1
  ansträngd_1_A : A ; -- ansträngd..av.1
  ansträngdhet_1_N : N ; -- ansträngdhet..nn.1
  ansträngning_1_N : N ; -- ansträngning..nn.1
  ansträngningsinkontinens_1_N : N ; -- ansträngningsinkontinens..nn.1
  anstucken_1_A : A ; -- anstucken..av.1
  anstuckenhet_1_N : N ; -- anstuckenhet..nn.1
  anställa_1_V : V ; -- anställa..vb.1
  anställande_1_N : N ; -- anställande..nn.1
  anställare_1_N : N ; -- anställare..nn.1
  anställbar_1_A : A ; -- anställbar..av.1
  anställd_1_A : A ; -- anställd..av.1
  anställning_1_N : N ; -- anställning..nn.1
  anställningsavtal_1_N : N ; -- anställningsavtal..nn.1
  anställningsbar_1_A : A ; -- anställningsbar..av.1
  anställningsintervju_1_N : N ; -- anställningsintervju..nn.1
  anställningskommitté_1_N : N ; -- anställningskommitté..nn.1
  anställningskontrakt_1_N : N ; -- anställningskontrakt..nn.1
  anställningsrättighet_1_N : N ; -- anställningsrättighet..nn.1
  anställningsskydd_1_N : N ; -- anställningsskydd..nn.1
  anställningsstopp_1_N : N ; -- anställningsstopp..nn.1
  anställningstid_1_N : N ; -- anställningstid..nn.1
  anställningstrygghet_1_N : N ; -- anställningstrygghet..nn.1
  anställningsvillkor_1_N : N ; -- anställningsvillkor..nn.1
  anständig_1_A : A ; -- anständig..av.1
  anständighet_1_N : N ; -- anständighet..nn.1
  anständighetsbegrepp_1_N : N ; -- anständighetsbegrepp..nn.1
  anständigtvis_1_Adv : Adv ; -- anständigtvis..ab.1
  anstå_1_V : V ; -- anstå..vb.1
  anstående_1_N : N ; -- anstående..nn.1
  anstånd_1_N : N ; -- anstånd..nn.1
  anståndstid_1_N : N ; -- anståndstid..nn.1
  anstöt_1_N : N ; -- anstöt..nn.1
  anstötlig_1_A : A ; -- anstötlig..av.1
  anstötlighet_1_N : N ; -- anstötlighet..nn.1
  ansvar_1_N : N ; -- ansvar..nn.1
  ansvara_1_V : V ; -- ansvara..vb.1
  ansvarande_1_N : N ; -- ansvarande..nn.1
  ansvarig_1_A : A ; -- ansvarig..av.1
  ansvarighet_1_N : N ; -- ansvarighet..nn.1
  ansvarighetsförsäkring_1_N : N ; -- ansvarighetsförsäkring..nn.1
  ansvaring_1_N : N ; -- ansvaring..nn.1
  ansvarsbefrielse_1_N : N ; -- ansvarsbefrielse..nn.1
  ansvarsfri_1_A : A ; -- ansvarsfri..av.1
  ansvarsfrihet_1_N : N ; -- ansvarsfrihet..nn.1
  ansvarsfull_1_A : A ; -- ansvarsfull..av.1
  ansvarsfullhet_1_N : N ; -- ansvarsfullhet..nn.1
  ansvarsförsäkring_1_N : N ; -- ansvarsförsäkring..nn.1
  ansvarskännande_1_A : A ; -- ansvarskännande..av.1
  ansvarskännande_1_N : N ; -- ansvarskännande..nn.1
  ansvarskänsla_1_N : N ; -- ansvarskänsla..nn.1
  ansvarslös_1_A : A ; -- ansvarslös..av.1
  ansvarslöshet_1_N : N ; -- ansvarslöshet..nn.1
  ansvarsnämnd_1_N : N ; -- ansvarsnämnd..nn.1
  ansvarsområde_1_N : N ; -- ansvarsområde..nn.1
  ansvarspåföljd_1_N : N ; -- ansvarspåföljd..nn.1
  ansvarsskyldig_1_A : A ; -- ansvarsskyldig..av.1
  ansvarsskyldighet_1_N : N ; -- ansvarsskyldighet..nn.1
  ansvarstagande_1_A : A ; -- ansvarstagande..av.1
  ansvarstagande_1_N : N ; -- ansvarstagande..nn.1
  ansvarsutkrävande_1_N : N ; -- ansvarsutkrävande..nn.1
  ansvarsyrkande_1_N : N ; -- ansvarsyrkande..nn.1
  ansvälla_1_V : V ; -- ansvälla..vb.1
  ansvällande_1_N : N ; -- ansvällande..nn.1
  ansvälld_1_A : A ; -- ansvälld..av.1
  ansvälldhet_1_N : N ; -- ansvälldhet..nn.1
  ansvällning_1_N : N ; -- ansvällning..nn.1
  ansätta_1_V : V ; -- ansätta..vb.1
  ansättande_1_N : N ; -- ansättande..nn.1
  ansättning_1_N : N ; -- ansättning..nn.1
  ansättningsskruv_1_N : N ; -- ansättningsskruv..nn.1
  ansöka_1_V : V ; -- ansöka..vb.1
  ansökande_1_N : N ; -- ansökande..nn.1
  ansökarland_1_N : N ; -- ansökarland..nn.1
  ansökning_1_N : N ; -- ansökning..nn.1
  ansökningshandling_1_N : N ; -- ansökningshandling..nn.1
  ansökningspapper_1_N : N ; -- ansökningspapper..nn.1
  ansökningstid_1_N : N ; -- ansökningstid..nn.1
  ansökningstryck_1_N : N ; -- ansökningstryck..nn.1
  anta_1_V : V ; -- anta..vb.1
  antabus_1_N : N ; -- antabus..nn.1
  antagande_1_N : N ; -- antagande..nn.1
  antaglig_1_A : A ; -- antaglig..av.1
  antagligen_1_Adv : Adv ; -- antagligen..ab.1
  antaglighet_1_N : N ; -- antaglighet..nn.1
  antagning_1_N : N ; -- antagning..nn.1
  antagningsbevis_1_N : N ; -- antagningsbevis..nn.1
  antagonism_1_N : N ; -- antagonism..nn.1
  antagonist_1_N : N ; -- antagonist..nn.1
  antagonistisk_1_A : A ; -- antagonistisk..av.1
  antal_1_N : N ; -- antal..nn.1
  antalsberäkning_1_N : N ; -- antalsberäkning..nn.1
  antalsmässig_1_A : A ; -- antalsmässig..av.1
  antarktisk_1_A : A ; -- antarktisk..av.1
  antasta_1_V : V ; -- antasta..vb.1
  antastande_1_N : N ; -- antastande..nn.1
  antavla_1_N : N ; -- antavla..nn.1
  antecedentia_1_N : N ; -- antecedentia..nn.1
  antecipation_1_N : N ; -- antecipation..nn.1
  antecipativ_1_A : A ; -- antecipativ..av.1
  antecipera_1_V : V ; -- antecipera..vb.1
  anteciperande_1_N : N ; -- anteciperande..nn.1
  anteciperbar_1_A : A ; -- anteciperbar..av.1
  anteciperbarhet_1_N : N ; -- anteciperbarhet..nn.1
  antecipering_1_N : N ; -- antecipering..nn.1
  anteckna_1_V : V ; -- anteckna..vb.1
  antecknande_1_N : N ; -- antecknande..nn.1
  antecknare_1_N : N ; -- antecknare..nn.1
  anteckning_1_N : N ; -- anteckning..nn.1
  anteckningsblock_1_N : N ; -- anteckningsblock..nn.1
  anteckningsbok_1_N : N ; -- anteckningsbok..nn.1
  antedatera_1_V : V ; -- antedatera..vb.1
  antedaterande_1_N : N ; -- antedaterande..nn.1
  antedaterbar_1_A : A ; -- antedaterbar..av.1
  antedaterbarhet_1_N : N ; -- antedaterbarhet..nn.1
  antedatering_1_N : N ; -- antedatering..nn.1
  antediluviansk_1_A : A ; -- antediluviansk..av.1
  antefix_1_N : N ; -- antefix..nn.1
  antenn_1_N : N ; -- antenn..nn.1
  antennkabel_1_N : N ; -- antennkabel..nn.1
  antennkörtel_1_N : N ; -- antennkörtel..nn.1
  antennuttag_1_N : N ; -- antennuttag..nn.1
  antependium_1_N : N ; -- antependium..nn.1
  antepenultima_1_N : N ; -- antepenultima..nn.1
  anti_gbm_sjukdom_1_N : N ; -- anti-gbm-sjukdom..nn.1
  anti_1_A : A ; -- anti..av.1
  antiabortlag_1_N : N ; -- antiabortlag..nn.1
  antiamerikansk_1_A : A ; -- antiamerikansk..av.1
  antibakteriell_1_A : A ; -- antibakteriell..av.1
  antibarbarus_1_N : N ; -- antibarbarus..nn.1
  antibiotika_1_N : N ; -- antibiotika..nn.1
  antibiotikabehandling_1_N : N ; -- antibiotikabehandling..nn.1
  antibiotikaresistens_1_N : N ; -- antibiotikaresistens..nn.1
  antibiotikaresistent_1_A : A ; -- antibiotikaresistent..av.1
  antibiotikum_1_N : N ; -- antibiotikum..nn.1
  antibiotisk_1_A : A ; -- antibiotisk..av.1
  antichambrera_1_V : V ; -- antichambrera..vb.1
  antichambrerande_1_N : N ; -- antichambrerande..nn.1
  antichambrerbar_1_A : A ; -- antichambrerbar..av.1
  antichambrerbarhet_1_N : N ; -- antichambrerbarhet..nn.1
  antichambrering_1_N : N ; -- antichambrering..nn.1
  anticyklon_1_N : N ; -- anticyklon..nn.1
  antidemokrat_1_N : N ; -- antidemokrat..nn.1
  antidemokratisk_1_A : A ; -- antidemokratisk..av.1
  antidepressiv_1_A : A ; -- antidepressiv..av.1
  antidiskrimineringsbyrå_1_N : N ; -- antidiskrimineringsbyrå..nn.1
  antidot_1_N : N ; -- antidot..nn.1
  antielitistisk_1_A : A ; -- antielitistisk..av.1
  antietablissemangsretorik_1_N : N ; -- antietablissemangsretorik..nn.1
  antieuropeisk_1_A : A ; -- antieuropeisk..av.1
  antiexpressionistisk_1_A : A ; -- antiexpressionistisk..av.1
  antifascistisk_1_A : A ; -- antifascistisk..av.1
  antifoni_1_N : N ; -- antifoni..nn.1
  antifosfolipidsyndrom_1_N : N ; -- antifosfolipidsyndrom..nn.1
  antifundamentalistisk_1_A : A ; -- antifundamentalistisk..av.1
  antigen_1_N : N ; -- antigen..nn.1
  antiguan_1_N : N ; -- antiguan..nn.1
  antiguansk_1_A : A ; -- antiguansk..av.1
  antiguanska_1_N : N ; -- antiguanska..nn.1
  antihelix_1_N : N ; -- antihelix..nn.1
  antihistamin_1_N : N ; -- antihistamin..nn.1
  antihjälte_1_N : N ; -- antihjälte..nn.1
  antihumanistisk_1_A : A ; -- antihumanistisk..av.1
  antiidealistisk_1_A : A ; -- antiidealistisk..av.1
  antiimperialistisk_1_A : A ; -- antiimperialistisk..av.1
  antiindividualistisk_1_A : A ; -- antiindividualistisk..av.1
  antiinflammatorisk_1_A : A ; -- antiinflammatorisk..av.1
  antiintellektualism_1_N : N ; -- antiintellektualism..nn.1
  antiintellektualistisk_1_A : A ; -- antiintellektualistisk..av.1
  antiintellektuell_1_A : A ; -- antiintellektuell..av.1
  antiislamistisk_1_A : A ; -- antiislamistisk..av.1
  antijudisk_1_A : A ; -- antijudisk..av.1
  antik_1_A : A ; -- antik..av.1
  antik_1_N : N ; -- antik..nn.1
  antikbehandla_1_V : V ; -- antikbehandla..vb.1
  antikbehandlande_1_N : N ; -- antikbehandlande..nn.1
  antikfynda_1_V : V ; -- antikfynda..vb.1
  antikfyndande_1_N : N ; -- antikfyndande..nn.1
  antikisera_1_V : V ; -- antikisera..vb.1
  antikiserande_1_N : N ; -- antikiserande..nn.1
  antikiserbar_1_A : A ; -- antikiserbar..av.1
  antikiserbarhet_1_N : N ; -- antikiserbarhet..nn.1
  antikisering_1_N : N ; -- antikisering..nn.1
  antiklerikal_1_A : A ; -- antiklerikal..av.1
  antiklimax_1_N : N ; -- antiklimax..nn.1
  antiklinal_1_N : N ; -- antiklinal..nn.1
  antikljus_1_N : N ; -- antikljus..nn.1
  antikommunism_1_N : N ; -- antikommunism..nn.1
  antikommunistisk_1_A : A ; -- antikommunistisk..av.1
  antikonceptionell_1_A : A ; -- antikonceptionell..av.1
  antikorruptionsaktivist_1_N : N ; -- antikorruptionsaktivist..nn.1
  antikorruptionskonferens_1_N : N ; -- antikorruptionskonferens..nn.1
  antikrist_1_N : N ; -- antikrist..nn.1
  antikristlig_1_A : A ; -- antikristlig..av.1
  antikropp_1_N : N ; -- antikropp..nn.1
  antikroppsbrist_1_N : N ; -- antikroppsbrist..nn.1
  antiksamling_1_N : N ; -- antiksamling..nn.1
  antikva_1_N : N ; -- antikva..nn.1
  antikvariat_1_N : N ; -- antikvariat..nn.1
  antikvarie_1_N : N ; -- antikvarie..nn.1
  antikvarisk_1_A : A ; -- antikvarisk..av.1
  antikverad_1_A : A ; -- antikverad..av.1
  antikvitet_1_N : N ; -- antikvitet..nn.1
  antikvitetshandel_1_N : N ; -- antikvitetshandel..nn.1
  antikvitetshandlare_1_N : N ; -- antikvitetshandlare..nn.1
  antikvitetsjägare_1_N : N ; -- antikvitetsjägare..nn.1
  antikvitetssamling_1_N : N ; -- antikvitetssamling..nn.1
  antikvärde_1_N : N ; -- antikvärde..nn.1
  antilop_1_N : N ; -- antilop..nn.1
  antimakass_1_N : N ; -- antimakass..nn.1
  antimateria_1_N : N ; -- antimateria..nn.1
  antimilitarism_1_N : N ; -- antimilitarism..nn.1
  antimilitarist_1_N : N ; -- antimilitarist..nn.1
  antimilitaristisk_1_A : A ; -- antimilitaristisk..av.1
  antimon_1_N : N ; -- antimon..nn.1
  antimonglans_1_N : N ; -- antimonglans..nn.1
  antimögelbehandlad_1_A : A ; -- antimögelbehandlad..av.1
  antinazistisk_1_A : A ; -- antinazistisk..av.1
  antingen_1_Adv : Adv ; -- antingen..ab.1
  antinomi_1_N : N ; -- antinomi..nn.1
  antioxidant_1_N : N ; -- antioxidant..nn.1
  antioxidationsmedel_1_N : N ; -- antioxidationsmedel..nn.1
  antipartikel_1_N : N ; -- antipartikel..nn.1
  antipassad_1_N : N ; -- antipassad..nn.1
  antipati_1_N : N ; -- antipati..nn.1
  antipatisk_1_A : A ; -- antipatisk..av.1
  antipod_1_N : N ; -- antipod..nn.1
  antipodisk_1_A : A ; -- antipodisk..av.1
  antipolitisk_1_A : A ; -- antipolitisk..av.1
  antipsykiatri_1_N : N ; -- antipsykiatri..nn.1
  antirasistisk_1_A : A ; -- antirasistisk..av.1
  antireflexbehandla_1_V : V ; -- antireflexbehandla..vb.1
  antireligiös_1_A : A ; -- antireligiös..av.1
  antirojalistisk_1_A : A ; -- antirojalistisk..av.1
  antirullningsfena_1_N : N ; -- antirullningsfena..nn.1
  antirynkkräm_1_N : N ; -- antirynkkräm..nn.1
  antisemit_1_N : N ; -- antisemit..nn.1
  antisemitisk_1_A : A ; -- antisemitisk..av.1
  antisemitism_1_N : N ; -- antisemitism..nn.1
  antisemitledare_1_N : N ; -- antisemitledare..nn.1
  antiseptik_1_N : N ; -- antiseptik..nn.1
  antiseptika_1_N : N ; -- antiseptika..nn.1
  antiseptisk_1_A : A ; -- antiseptisk..av.1
  antisionism_1_N : N ; -- antisionism..nn.1
  antisionistisk_1_A : A ; -- antisionistisk..av.1
  antiskating_1_N : N ; -- antiskating..nn.1
  antisladdsystem_1_N : N ; -- antisladdsystem..nn.1
  antistatisk_1_A : A ; -- antistatisk..av.1
  antistatmedel_1_N : N ; -- antistatmedel..nn.1
  antisyrisk_1_A : A ; -- antisyrisk..av.1
  antites_1_N : N ; -- antites..nn.1
  antitetisk_1_A : A ; -- antitetisk..av.1
  antitoxin_1_N : N ; -- antitoxin..nn.1
  antitragus_1_N : N ; -- antitragus..nn.1
  antivibrationshandtag_1_N : N ; -- antivibrationshandtag..nn.1
  antiviral_1_A : A ; -- antiviral..av.1
  antivirusexpert_1_N : N ; -- antivirusexpert..nn.1
  antivirusprogram_1_N : N ; -- antivirusprogram..nn.1
  antiålderskräm_1_N : N ; -- antiålderskräm..nn.1
  antologi_1_N : N ; -- antologi..nn.1
  antonym_1_A : A ; -- antonym..av.1
  antonym_1_N : N ; -- antonym..nn.1
  antracit_1_N : N ; -- antracit..nn.1
  antracitkol_1_N : N ; -- antracitkol..nn.1
  antrakos_1_N : N ; -- antrakos..nn.1
  antrakosilikos_1_N : N ; -- antrakosilikos..nn.1
  antrax_1_N : N ; -- antrax..nn.1
  antropisk_1_A : A ; -- antropisk..av.1
  antropocentrisk_1_A : A ; -- antropocentrisk..av.1
  antropofag_1_N : N ; -- antropofag..nn.1
  antropofagi_1_N : N ; -- antropofagi..nn.1
  antropoid_1_N : N ; -- antropoid..nn.1
  antropolog_1_N : N ; -- antropolog..nn.1
  antropologi_1_N : N ; -- antropologi..nn.1
  antropologisk_1_A : A ; -- antropologisk..av.1
  antropomorf_1_A : A ; -- antropomorf..av.1
  antropomorfisk_1_A : A ; -- antropomorfisk..av.1
  antropomorfism_1_N : N ; -- antropomorfism..nn.1
  antropomorfistisk_1_A : A ; -- antropomorfistisk..av.1
  antroposof_1_N : N ; -- antroposof..nn.1
  antroposofi_1_N : N ; -- antroposofi..nn.1
  antroposofisk_1_A : A ; -- antroposofisk..av.1
  anträda_1_V : V ; -- anträda..vb.1
  anträdande_1_N : N ; -- anträdande..nn.1
  anträde_1_N : N ; -- anträde..nn.1
  anträffa_1_V : V ; -- anträffa..vb.1
  anträffande_1_N : N ; -- anträffande..nn.1
  anträffbar_1_A : A ; -- anträffbar..av.1
  anträffbarhet_1_N : N ; -- anträffbarhet..nn.1
  antvarda_1_V : V ; -- antvarda..vb.1
  antvardande_1_N : N ; -- antvardande..nn.1
  antyda_1_V : V ; -- antyda..vb.1
  antydande_1_N : N ; -- antydande..nn.1
  antydning_1_N : N ; -- antydning..nn.1
  antydningsvis_1_Adv : Adv ; -- antydningsvis..ab.1
  antända_1_V : V ; -- antända..vb.1
  antändande_1_N : N ; -- antändande..nn.1
  antändbar_1_A : A ; -- antändbar..av.1
  antändbarhet_1_N : N ; -- antändbarhet..nn.1
  antändning_1_N : N ; -- antändning..nn.1
  antåg_1_N : N ; -- antåg..nn.1
  antåga_1_V : V ; -- antåga..vb.1
  antågande_1_N : N ; -- antågande..nn.1
  anuri_1_N : N ; -- anuri..nn.1
  anus_1_N : N ; -- anus..nn.1
  anvisa_1_V : V ; -- anvisa..vb.1
  anvisande_1_N : N ; -- anvisande..nn.1
  anvisning_1_N : N ; -- anvisning..nn.1
  anvisningskommun_1_N : N ; -- anvisningskommun..nn.1
  anvisningsläkare_1_N : N ; -- anvisningsläkare..nn.1
  använda_1_V : V ; -- använda..vb.1
  användande_1_N : N ; -- användande..nn.1
  användare_1_N : N ; -- användare..nn.1
  användargrupp_1_N : N ; -- användargrupp..nn.1
  användarvänlig_1_A : A ; -- användarvänlig..av.1
  användarvänlighet_1_N : N ; -- användarvänlighet..nn.1
  användbar_1_A : A ; -- användbar..av.1
  användbarhet_1_N : N ; -- användbarhet..nn.1
  användbarhetsaspekt_1_N : N ; -- användbarhetsaspekt..nn.1
  användning_1_N : N ; -- användning..nn.1
  användningslösning_1_N : N ; -- användningslösning..nn.1
  användningsmöjlighet_1_N : N ; -- användningsmöjlighet..nn.1
  användningsområde_1_N : N ; -- användningsområde..nn.1
  användningssätt_1_N : N ; -- användningssätt..nn.1
  aorist_1_N : N ; -- aorist..nn.1
  aorta_1_N : N ; -- aorta..nn.1
  aortaaneurysm_1_N : N ; -- aortaaneurysm..nn.1
  aortabristning_1_N : N ; -- aortabristning..nn.1
  aortabråck_1_N : N ; -- aortabråck..nn.1
  aortabåge_1_N : N ; -- aortabåge..nn.1
  aortabågesyndrom_1_N : N ; -- aortabågesyndrom..nn.1
  aortadissektion_1_N : N ; -- aortadissektion..nn.1
  aortaförträngning_1_N : N ; -- aortaförträngning..nn.1
  aortainflammation_1_N : N ; -- aortainflammation..nn.1
  aortainsufficiens_1_N : N ; -- aortainsufficiens..nn.1
  aortaklaff_1_N : N ; -- aortaklaff..nn.1
  aortaklaffinsufficiens_1_N : N ; -- aortaklaffinsufficiens..nn.1
  aortaklaffläckage_1_N : N ; -- aortaklaffläckage..nn.1
  aortaklaffprolaps_1_N : N ; -- aortaklaffprolaps..nn.1
  aortaklaffstenos_1_N : N ; -- aortaklaffstenos..nn.1
  aortaklafförträngning_1_N : N ; -- aortaklafförträngning..nn.1
  aortakoarktation_1_N : N ; -- aortakoarktation..nn.1
  aortaruptur_1_N : N ; -- aortaruptur..nn.1
  aortasjukdom_1_N : N ; -- aortasjukdom..nn.1
  aortastenos_1_N : N ; -- aortastenos..nn.1
  aortit_syndrom_1_N : N ; -- aortit-syndrom..nn.1
  aortit_1_N : N ; -- aortit..nn.1
  apa_1_A : A ; -- apa..av.1
  apa_1_N : N ; -- apa..nn.1
  apache_1_N : N ; -- apache..nn.1
  apanage_1_N : N ; -- apanage..nn.1
  apanagebelopp_1_N : N ; -- apanagebelopp..nn.1
  apart_1_A : A ; -- apart..av.1
  apart_1_N : N ; -- apart..nn.1
  apartheid_1_N : N ; -- apartheid..nn.1
  apartheidlag_1_N : N ; -- apartheidlag..nn.1
  apartheidregim_1_N : N ; -- apartheidregim..nn.1
  apati_1_N : N ; -- apati..nn.1
  apatisk_1_A : A ; -- apatisk..av.1
  apatit_1_N : N ; -- apatit..nn.1
  apbrödsträd_1_N : N ; -- apbrödsträd..nn.1
  apc_resistens_1_N : N ; -- apc-resistens..nn.1
  apekatt_1_N : N ; -- apekatt..nn.1
  apel_1_N : N ; -- apel..nn.1
  apelgrå_1_A : A ; -- apelgrå..av.1
  apelkastad_1_A : A ; -- apelkastad..av.1
  apelsin_1_N : N ; -- apelsin..nn.1
  apelsingelé_1_N : N ; -- apelsingelé..nn.1
  apelsinglass_1_N : N ; -- apelsinglass..nn.1
  apelsinjuice_1_N : N ; -- apelsinjuice..nn.1
  apelsinklyfta_1_N : N ; -- apelsinklyfta..nn.1
  apelsinmarmelad_1_N : N ; -- apelsinmarmelad..nn.1
  apelsinmousse_1_N : N ; -- apelsinmousse..nn.1
  apelsinmoussetårta_1_N : N ; -- apelsinmoussetårta..nn.1
  apelsinsaft_1_N : N ; -- apelsinsaft..nn.1
  apelsinskal_1_N : N ; -- apelsinskal..nn.1
  apelsinträd_1_N : N ; -- apelsinträd..nn.1
  aperi_1_N : N ; -- aperi..nn.1
  aperitif_1_N : N ; -- aperitif..nn.1
  apermi_1_N : N ; -- apermi..nn.1
  apertur_1_N : N ; -- apertur..nn.1
  apetidin_1_N : N ; -- apetidin..nn.1
  apex_1_N : N ; -- apex..nn.1
  aphelium_1_N : N ; -- aphelium..nn.1
  aphjärna_1_N : N ; -- aphjärna..nn.1
  aphona_1_N : N ; -- aphona..nn.1
  apkoppa_1_N : N ; -- apkoppa..nn.1
  aplik_1_A : A ; -- aplik..av.1
  aplik_1_N : N ; -- aplik..nn.1
  apliknande_1_A : A ; -- apliknande..av.1
  aplomb_1_N : N ; -- aplomb..nn.1
  apmänniska_1_N : N ; -- apmänniska..nn.1
  apne_1_N : N ; -- apne..nn.1
  apné_1_N : N ; -- apné..nn.1
  apodiktisk_1_A : A ; -- apodiktisk..av.1
  apogeum_1_N : N ; -- apogeum..nn.1
  apokalyps_1_N : N ; -- apokalyps..nn.1
  apokalyptisk_1_A : A ; -- apokalyptisk..av.1
  apokope_1_N : N ; -- apokope..nn.1
  apokrin_1_A : A ; -- apokrin..av.1
  apokryfisk_1_A : A ; -- apokryfisk..av.1
  apolitisk_1_A : A ; -- apolitisk..av.1
  apollinisk_1_A : A ; -- apollinisk..av.1
  apollinsk_1_A : A ; -- apollinsk..av.1
  apollofjäril_1_N : N ; -- apollofjäril..nn.1
  apologet_1_N : N ; -- apologet..nn.1
  apologetik_1_N : N ; -- apologetik..nn.1
  apologetisk_1_A : A ; -- apologetisk..av.1
  apologi_1_N : N ; -- apologi..nn.1
  apologist_1_N : N ; -- apologist..nn.1
  apomorfi_1_N : N ; -- apomorfi..nn.1
  apoplektisk_1_A : A ; -- apoplektisk..av.1
  apoplexi_1_N : N ; -- apoplexi..nn.1
  apostel_1_N : N ; -- apostel..nn.1
  aposteriorisk_1_A : A ; -- aposteriorisk..av.1
  apostolisk_1_A : A ; -- apostolisk..av.1
  apostrof_1_N : N ; -- apostrof..nn.1
  apostrofera_1_V : V ; -- apostrofera..vb.1
  apostroferande_1_N : N ; -- apostroferande..nn.1
  apostroferbar_1_A : A ; -- apostroferbar..av.1
  apostroferbarhet_1_N : N ; -- apostroferbarhet..nn.1
  apostrofering_1_N : N ; -- apostrofering..nn.1
  apotek_1_N : N ; -- apotek..nn.1
  apotekare_1_N : N ; -- apotekare..nn.1
  apotekskedja_1_N : N ; -- apotekskedja..nn.1
  apotekskö_1_N : N ; -- apotekskö..nn.1
  apoteksväxt_1_N : N ; -- apoteksväxt..nn.1
  apoteksvåg_1_N : N ; -- apoteksvåg..nn.1
  apoteos_1_N : N ; -- apoteos..nn.1
  apothesium_1_N : N ; -- apothesium..nn.1
  app_1_N : N ; -- app..nn.1
  appa_1_V : V ; -- appa..vb.1
  apparans_1_N : N ; -- apparans..nn.1
  apparat_1_N : N ; -- apparat..nn.1
  apparatrum_1_N : N ; -- apparatrum..nn.1
  apparatur_1_N : N ; -- apparatur..nn.1
  apparition_1_N : N ; -- apparition..nn.1
  appell_1_N : N ; -- appell..nn.1
  appellant_1_N : N ; -- appellant..nn.1
  appellationsdomstol_1_N : N ; -- appellationsdomstol..nn.1
  appellativ_1_N : N ; -- appellativ..nn.1
  appellera_1_V : V ; -- appellera..vb.1
  appellerande_1_N : N ; -- appellerande..nn.1
  appellerbar_1_A : A ; -- appellerbar..av.1
  appellerbarhet_1_N : N ; -- appellerbarhet..nn.1
  appellering_1_N : N ; -- appellering..nn.1
  appendicit_1_N : N ; -- appendicit..nn.1
  appendix_1_N : N ; -- appendix..nn.1
  appendixcancer_1_N : N ; -- appendixcancer..nn.1
  appendixtumör_1_N : N ; -- appendixtumör..nn.1
  apperception_1_N : N ; -- apperception..nn.1
  applicera_1_V : V ; -- applicera..vb.1
  applicerande_1_N : N ; -- applicerande..nn.1
  applicerbar_1_A : A ; -- applicerbar..av.1
  applicerbarhet_1_N : N ; -- applicerbarhet..nn.1
  applicering_1_N : N ; -- applicering..nn.1
  applikation_1_N : N ; -- applikation..nn.1
  applikator_1_N : N ; -- applikator..nn.1
  applikatorisk_1_A : A ; -- applikatorisk..av.1
  applikatur_1_N : N ; -- applikatur..nn.1
  applåd_1_N : N ; -- applåd..nn.1
  applådera_1_V : V ; -- applådera..vb.1
  applåderande_1_N : N ; -- applåderande..nn.1
  applåderbar_1_A : A ; -- applåderbar..av.1
  applåderbarhet_1_N : N ; -- applåderbarhet..nn.1
  applådering_1_N : N ; -- applådering..nn.1
  applådsalva_1_N : N ; -- applådsalva..nn.1
  applådåska_1_N : N ; -- applådåska..nn.1
  apport_1_N : N ; -- apport..nn.1
  apportera_1_V : V ; -- apportera..vb.1
  apporterande_1_N : N ; -- apporterande..nn.1
  apporterbar_1_A : A ; -- apporterbar..av.1
  apporterbarhet_1_N : N ; -- apporterbarhet..nn.1
  apportering_1_N : N ; -- apportering..nn.1
  apposition_1_N : N ; -- apposition..nn.1
  appreciera_1_V : V ; -- appreciera..vb.1
  apprecierande_1_N : N ; -- apprecierande..nn.1
  apprecierbar_1_A : A ; -- apprecierbar..av.1
  apprecierbarhet_1_N : N ; -- apprecierbarhet..nn.1
  appreciering_1_N : N ; -- appreciering..nn.1
  appretera_1_V : V ; -- appretera..vb.1
  appreterande_1_N : N ; -- appreterande..nn.1
  appreterbar_1_A : A ; -- appreterbar..av.1
  appreterbarhet_1_N : N ; -- appreterbarhet..nn.1
  appretering_1_N : N ; -- appretering..nn.1
  appretur_1_N : N ; -- appretur..nn.1
  appretyr_1_N : N ; -- appretyr..nn.1
  approach_1_N : N ; -- approach..nn.1
  approbabel_1_A : A ; -- approbabel..av.1
  approbatur_1_N : N ; -- approbatur..nn.1
  approchera_1_V : V ; -- approchera..vb.1
  approcherande_1_N : N ; -- approcherande..nn.1
  approcherbar_1_A : A ; -- approcherbar..av.1
  approcherbarhet_1_N : N ; -- approcherbarhet..nn.1
  approchering_1_N : N ; -- approchering..nn.1
  approximation_1_N : N ; -- approximation..nn.1
  approximationsteori_1_N : N ; -- approximationsteori..nn.1
  approximationsvis_1_Adv : Adv ; -- approximationsvis..ab.1
  approximativ_1_A : A ; -- approximativ..av.1
  approximera_1_V : V ; -- approximera..vb.1
  approximerande_1_N : N ; -- approximerande..nn.1
  approximerbar_1_A : A ; -- approximerbar..av.1
  approximerbarhet_1_N : N ; -- approximerbarhet..nn.1
  approximering_1_N : N ; -- approximering..nn.1
  aprak_1_A : A ; -- aprak..av.1
  apraxi_1_N : N ; -- apraxi..nn.1
  aprikos_1_N : N ; -- aprikos..nn.1
  april_1_N : N ; -- april..nn.1
  aprildag_1_N : N ; -- aprildag..nn.1
  aprilskämt_1_N : N ; -- aprilskämt..nn.1
  aprilsnö_1_N : N ; -- aprilsnö..nn.1
  aprilväder_1_N : N ; -- aprilväder..nn.1
  apriorisk_1_A : A ; -- apriorisk..av.1
  apropå_1_Adv : Adv ; -- apropå..ab.1
  apropå_1_N : N ; -- apropå..nn.1
  apsjukdom_1_N : N ; -- apsjukdom..nn.1
  apsort_1_N : N ; -- apsort..nn.1
  apspel_1_N : N ; -- apspel..nn.1
  aptera_1_V : V ; -- aptera..vb.1
  apterande_1_N : N ; -- apterande..nn.1
  apterbar_1_A : A ; -- apterbar..av.1
  apterbarhet_1_N : N ; -- apterbarhet..nn.1
  aptering_1_N : N ; -- aptering..nn.1
  aptit_1_N : N ; -- aptit..nn.1
  aptitlig_1_A : A ; -- aptitlig..av.1
  aptitlighet_1_N : N ; -- aptitlighet..nn.1
  aptitlöshet_1_N : N ; -- aptitlöshet..nn.1
  aptitretande_1_A : A ; -- aptitretande..av.1
  aptitretare_1_N : N ; -- aptitretare..nn.1
  apudom_1_N : N ; -- apudom..nn.1
  ar_1_N : N ; -- ar..nn.1
  ara_1_N : N ; -- ara..nn.1
  arab_1_N : N ; -- arab..nn.1
  arabesk_1_N : N ; -- arabesk..nn.1
  arabeskmönster_1_N : N ; -- arabeskmönster..nn.1
  arabisk_1_A : A ; -- arabisk..av.1
  arabiska_1_N : N ; -- arabiska..nn.1
  arabiska_2_N : N ; -- arabiska..nn.2
  arabiskspråkig_1_A : A ; -- arabiskspråkig..av.1
  arabisktalande_1_A : A ; -- arabisktalande..av.1
  arabist_1_N : N ; -- arabist..nn.1
  arabland_1_N : N ; -- arabland..nn.1
  arabvärld_1_N : N ; -- arabvärld..nn.1
  araknidism_1_N : N ; -- araknidism..nn.1
  araknodaktyli_1_N : N ; -- araknodaktyli..nn.1
  araknoidalcysta_1_N : N ; -- araknoidalcysta..nn.1
  araknoidit_1_N : N ; -- araknoidit..nn.1
  aralia_1_N : N ; -- aralia..nn.1
  arameiska_1_N : N ; -- arameiska..nn.1
  aramid_1_N : N ; -- aramid..nn.1
  arbeta_1_V : V ; -- arbeta..vb.1
  arbetande_1_N : N ; -- arbetande..nn.1
  arbetarbostad_1_N : N ; -- arbetarbostad..nn.1
  arbetare_1_N : N ; -- arbetare..nn.1
  arbetareparti_1_N : N ; -- arbetareparti..nn.1
  arbetarförening_1_N : N ; -- arbetarförening..nn.1
  arbetargrupp_1_N : N ; -- arbetargrupp..nn.1
  arbetarinstitut_1_N : N ; -- arbetarinstitut..nn.1
  arbetarklass_1_N : N ; -- arbetarklass..nn.1
  arbetarkommun_1_N : N ; -- arbetarkommun..nn.1
  arbetarkvarter_1_N : N ; -- arbetarkvarter..nn.1
  arbetarparti_1_N : N ; -- arbetarparti..nn.1
  arbetarregering_1_N : N ; -- arbetarregering..nn.1
  arbetarråd_1_N : N ; -- arbetarråd..nn.1
  arbetarrörelse_1_N : N ; -- arbetarrörelse..nn.1
  arbetarskydd_1_N : N ; -- arbetarskydd..nn.1
  arbetarskyddsstyrelse_1_N : N ; -- arbetarskyddsstyrelse..nn.1
  arbetarstam_1_N : N ; -- arbetarstam..nn.1
  arbetarsång_1_N : N ; -- arbetarsång..nn.1
  arbetaruppror_1_N : N ; -- arbetaruppror..nn.1
  arbetarväljare_1_N : N ; -- arbetarväljare..nn.1
  arbete_1_N : N ; -- arbete..nn.1
  arbetsam_1_A : A ; -- arbetsam..av.1
  arbetsamhet_1_N : N ; -- arbetsamhet..nn.1
  arbetsanstalt_1_N : N ; -- arbetsanstalt..nn.1
  arbetsavtal_1_N : N ; -- arbetsavtal..nn.1
  arbetsbas_1_N : N ; -- arbetsbas..nn.1
  arbetsbelastning_1_N : N ; -- arbetsbelastning..nn.1
  arbetsbelysning_1_N : N ; -- arbetsbelysning..nn.1
  arbetsbeskrivning_1_N : N ; -- arbetsbeskrivning..nn.1
  arbetsbesparande_1_A : A ; -- arbetsbesparande..av.1
  arbetsbesparing_1_N : N ; -- arbetsbesparing..nn.1
  arbetsbetyg_1_N : N ; -- arbetsbetyg..nn.1
  arbetsbi_1_N : N ; -- arbetsbi..nn.1
  arbetsblus_1_N : N ; -- arbetsblus..nn.1
  arbetsbok_1_N : N ; -- arbetsbok..nn.1
  arbetsbord_1_N : N ; -- arbetsbord..nn.1
  arbetsbredd_1_N : N ; -- arbetsbredd..nn.1
  arbetsbrist_1_N : N ; -- arbetsbrist..nn.1
  arbetsbyte_1_N : N ; -- arbetsbyte..nn.1
  arbetsbänk_1_N : N ; -- arbetsbänk..nn.1
  arbetsbås_1_N : N ; -- arbetsbås..nn.1
  arbetsbörda_1_N : N ; -- arbetsbörda..nn.1
  arbetschef_1_N : N ; -- arbetschef..nn.1
  arbetsdag_1_N : N ; -- arbetsdag..nn.1
  arbetsdelning_1_N : N ; -- arbetsdelning..nn.1
  arbetsdjur_1_N : N ; -- arbetsdjur..nn.1
  arbetsdomstol_1_N : N ; -- arbetsdomstol..nn.1
  arbetsdräkt_1_N : N ; -- arbetsdräkt..nn.1
  arbetsdräng_1_N : N ; -- arbetsdräng..nn.1
  arbetsduglig_1_A : A ; -- arbetsduglig..av.1
  arbetsduglighet_1_N : N ; -- arbetsduglighet..nn.1
  arbetsfolk_1_N : N ; -- arbetsfolk..nn.1
  arbetsform_1_N : N ; -- arbetsform..nn.1
  arbetsfred_1_N : N ; -- arbetsfred..nn.1
  arbetsfri_1_A : A ; -- arbetsfri..av.1
  arbetsfält_1_N : N ; -- arbetsfält..nn.1
  arbetsfånge_1_N : N ; -- arbetsfånge..nn.1
  arbetsför_1_A : A ; -- arbetsför..av.1
  arbetsfördelning_1_N : N ; -- arbetsfördelning..nn.1
  arbetsförhet_1_N : N ; -- arbetsförhet..nn.1
  arbetsförhållande_1_N : N ; -- arbetsförhållande..nn.1
  arbetsförman_1_N : N ; -- arbetsförman..nn.1
  arbetsförmedlare_1_N : N ; -- arbetsförmedlare..nn.1
  arbetsförmedling_1_N : N ; -- arbetsförmedling..nn.1
  arbetsförmåga_1_N : N ; -- arbetsförmåga..nn.1
  arbetsförmågeutredning_1_N : N ; -- arbetsförmågeutredning..nn.1
  arbetsförtjänst_1_N : N ; -- arbetsförtjänst..nn.1
  arbetsgivaravgift_1_N : N ; -- arbetsgivaravgift..nn.1
  arbetsgivare_1_N : N ; -- arbetsgivare..nn.1
  arbetsgivareförening_1_N : N ; -- arbetsgivareförening..nn.1
  arbetsgivarförening_1_N : N ; -- arbetsgivarförening..nn.1
  arbetsgivarinträde_1_N : N ; -- arbetsgivarinträde..nn.1
  arbetsgivarorganisation_1_N : N ; -- arbetsgivarorganisation..nn.1
  arbetsglädje_1_N : N ; -- arbetsglädje..nn.1
  arbetsgrupp_1_N : N ; -- arbetsgrupp..nn.1
  arbetshandikapp_1_N : N ; -- arbetshandikapp..nn.1
  arbetshandikappad_1_A : A ; -- arbetshandikappad..av.1
  arbetshandske_1_N : N ; -- arbetshandske..nn.1
  arbetshus_1_N : N ; -- arbetshus..nn.1
  arbetshypotes_1_N : N ; -- arbetshypotes..nn.1
  arbetshäst_1_N : N ; -- arbetshäst..nn.1
  arbetsinkomst_1_N : N ; -- arbetsinkomst..nn.1
  arbetsinrättning_1_N : N ; -- arbetsinrättning..nn.1
  arbetsinsats_1_N : N ; -- arbetsinsats..nn.1
  arbetsinställelse_1_N : N ; -- arbetsinställelse..nn.1
  arbetsintensitet_1_N : N ; -- arbetsintensitet..nn.1
  arbetsintensiv_1_A : A ; -- arbetsintensiv..av.1
  arbetsintervju_1_N : N ; -- arbetsintervju..nn.1
  arbetsiver_1_N : N ; -- arbetsiver..nn.1
  arbetsjacka_1_N : N ; -- arbetsjacka..nn.1
  arbetskamrat_1_N : N ; -- arbetskamrat..nn.1
  arbetskarl_1_N : N ; -- arbetskarl..nn.1
  arbetsklimat_1_N : N ; -- arbetsklimat..nn.1
  arbetskommendering_1_N : N ; -- arbetskommendering..nn.1
  arbetskonflikt_1_N : N ; -- arbetskonflikt..nn.1
  arbetskostnad_1_N : N ; -- arbetskostnad..nn.1
  arbetskraft_1_N : N ; -- arbetskraft..nn.1
  arbetskraftsintensiv_1_A : A ; -- arbetskraftsintensiv..av.1
  arbetskraftsinvandrare_1_N : N ; -- arbetskraftsinvandrare..nn.1
  arbetskraftsinvandring_1_N : N ; -- arbetskraftsinvandring..nn.1
  arbetskrävande_1_A : A ; -- arbetskrävande..av.1
  arbetsköpare_1_N : N ; -- arbetsköpare..nn.1
  arbetslag_1_N : N ; -- arbetslag..nn.1
  arbetsledande_1_A : A ; -- arbetsledande..av.1
  arbetsledare_1_N : N ; -- arbetsledare..nn.1
  arbetsliv_1_N : N ; -- arbetsliv..nn.1
  arbetslivserfarenhet_1_N : N ; -- arbetslivserfarenhet..nn.1
  arbetslivsfond_1_N : N ; -- arbetslivsfond..nn.1
  arbetslokal_1_N : N ; -- arbetslokal..nn.1
  arbetslust_1_N : N ; -- arbetslust..nn.1
  arbetsläger_1_N : N ; -- arbetsläger..nn.1
  arbetslängd_1_N : N ; -- arbetslängd..nn.1
  arbetslön_1_N : N ; -- arbetslön..nn.1
  arbetslös_1_A : A ; -- arbetslös..av.1
  arbetslöshet_1_N : N ; -- arbetslöshet..nn.1
  arbetslöshetsförsäkring_1_N : N ; -- arbetslöshetsförsäkring..nn.1
  arbetslöshetsperiod_1_N : N ; -- arbetslöshetsperiod..nn.1
  arbetslöshetsstatistik_1_N : N ; -- arbetslöshetsstatistik..nn.1
  arbetsmanskap_1_N : N ; -- arbetsmanskap..nn.1
  arbetsmarknad_1_N : N ; -- arbetsmarknad..nn.1
  arbetsmarknadskonflikt_1_N : N ; -- arbetsmarknadskonflikt..nn.1
  arbetsmarknadsminister_1_N : N ; -- arbetsmarknadsminister..nn.1
  arbetsmarknadsmässig_1_A : A ; -- arbetsmarknadsmässig..av.1
  arbetsmarknadspolitik_1_N : N ; -- arbetsmarknadspolitik..nn.1
  arbetsmarknadspolitisk_1_A : A ; -- arbetsmarknadspolitisk..av.1
  arbetsmarknadsstatistik_1_N : N ; -- arbetsmarknadsstatistik..nn.1
  arbetsmarknadsstyrelse_1_N : N ; -- arbetsmarknadsstyrelse..nn.1
  arbetsmarknadsutbildning_1_N : N ; -- arbetsmarknadsutbildning..nn.1
  arbetsmarknadsåtgärd_1_N : N ; -- arbetsmarknadsåtgärd..nn.1
  arbetsmaskin_1_N : N ; -- arbetsmaskin..nn.1
  arbetsmaterial_1_N : N ; -- arbetsmaterial..nn.1
  arbetsmetod_1_N : N ; -- arbetsmetod..nn.1
  arbetsmiljö_1_N : N ; -- arbetsmiljö..nn.1
  arbetsmiljöbrott_1_N : N ; -- arbetsmiljöbrott..nn.1
  arbetsmiljömässig_1_A : A ; -- arbetsmiljömässig..av.1
  arbetsmiljömål_1_N : N ; -- arbetsmiljömål..nn.1
  arbetsminne_1_N : N ; -- arbetsminne..nn.1
  arbetsminnestest_1_N : N ; -- arbetsminnestest..nn.1
  arbetsmoment_1_N : N ; -- arbetsmoment..nn.1
  arbetsmoral_1_N : N ; -- arbetsmoral..nn.1
  arbetsmyra_1_N : N ; -- arbetsmyra..nn.1
  arbetsmängd_1_N : N ; -- arbetsmängd..nn.1
  arbetsmänniska_1_N : N ; -- arbetsmänniska..nn.1
  arbetsmässig_1_A : A ; -- arbetsmässig..av.1
  arbetsmätning_1_N : N ; -- arbetsmätning..nn.1
  arbetsnamn_1_N : N ; -- arbetsnamn..nn.1
  arbetsnarkoman_1_N : N ; -- arbetsnarkoman..nn.1
  arbetsnedläggelse_1_N : N ; -- arbetsnedläggelse..nn.1
  arbetsnämnd_1_N : N ; -- arbetsnämnd..nn.1
  arbetsoförmögen_1_A : A ; -- arbetsoförmögen..av.1
  arbetsområde_1_N : N ; -- arbetsområde..nn.1
  arbetsordning_1_N : N ; -- arbetsordning..nn.1
  arbetsorganisation_1_N : N ; -- arbetsorganisation..nn.1
  arbetspass_1_N : N ; -- arbetspass..nn.1
  arbetspendla_1_V : V ; -- arbetspendla..vb.1
  arbetspendlande_1_N : N ; -- arbetspendlande..nn.1
  arbetspersonal_1_N : N ; -- arbetspersonal..nn.1
  arbetsplan_1_N : N ; -- arbetsplan..nn.1
  arbetsplats_1_N : N ; -- arbetsplats..nn.1
  arbetsplatsolycka_1_N : N ; -- arbetsplatsolycka..nn.1
  arbetsplenum_1_N : N ; -- arbetsplenum..nn.1
  arbetspremiss_1_N : N ; -- arbetspremiss..nn.1
  arbetsprogram_1_N : N ; -- arbetsprogram..nn.1
  arbetsprov_1_N : N ; -- arbetsprov..nn.1
  arbetsredskap_1_N : N ; -- arbetsredskap..nn.1
  arbetsrelaterad_1_A : A ; -- arbetsrelaterad..av.1
  arbetsrelation_1_N : N ; -- arbetsrelation..nn.1
  arbetsro_1_N : N ; -- arbetsro..nn.1
  arbetsrum_1_N : N ; -- arbetsrum..nn.1
  arbetsrätt_1_N : N ; -- arbetsrätt..nn.1
  arbetsrättslig_1_A : A ; -- arbetsrättslig..av.1
  arbetssal_1_N : N ; -- arbetssal..nn.1
  arbetsschema_1_N : N ; -- arbetsschema..nn.1
  arbetsseger_1_N : N ; -- arbetsseger..nn.1
  arbetssituation_1_N : N ; -- arbetssituation..nn.1
  arbetsskada_1_N : N ; -- arbetsskada..nn.1
  arbetsskadad_1_A : A ; -- arbetsskadad..av.1
  arbetsskicklig_1_A : A ; -- arbetsskicklig..av.1
  arbetsskicklighet_1_N : N ; -- arbetsskicklighet..nn.1
  arbetsskräck_1_N : N ; -- arbetsskräck..nn.1
  arbetsskygg_1_A : A ; -- arbetsskygg..av.1
  arbetsskygghet_1_N : N ; -- arbetsskygghet..nn.1
  arbetsstudieman_1_N : N ; -- arbetsstudieman..nn.1
  arbetsstycke_1_N : N ; -- arbetsstycke..nn.1
  arbetsstyrka_1_N : N ; -- arbetsstyrka..nn.1
  arbetssätt_1_N : N ; -- arbetssätt..nn.1
  arbetssång_1_N : N ; -- arbetssång..nn.1
  arbetssökande_1_A : A ; -- arbetssökande..av.1
  arbetssökande_1_N : N ; -- arbetssökande..nn.1
  arbetssökande_2_N : N ; -- arbetssökande..nn.2
  arbetstagare_1_N : N ; -- arbetstagare..nn.1
  arbetstakt_1_N : N ; -- arbetstakt..nn.1
  arbetstemperatur_1_N : N ; -- arbetstemperatur..nn.1
  arbetsterapeut_1_N : N ; -- arbetsterapeut..nn.1
  arbetsterapi_1_N : N ; -- arbetsterapi..nn.1
  arbetstid_1_N : N ; -- arbetstid..nn.1
  arbetstidsförkortning_1_N : N ; -- arbetstidsförkortning..nn.1
  arbetstidsregel_1_N : N ; -- arbetstidsregel..nn.1
  arbetstidsreglering_1_N : N ; -- arbetstidsreglering..nn.1
  arbetstillfälle_1_N : N ; -- arbetstillfälle..nn.1
  arbetstillstånd_1_N : N ; -- arbetstillstånd..nn.1
  arbetstimme_1_N : N ; -- arbetstimme..nn.1
  arbetsträna_1_V : V ; -- arbetsträna..vb.1
  arbetstränande_1_N : N ; -- arbetstränande..nn.1
  arbetsträning_1_N : N ; -- arbetsträning..nn.1
  arbetstvist_1_N : N ; -- arbetstvist..nn.1
  arbetsuppgift_1_N : N ; -- arbetsuppgift..nn.1
  arbetsutskott_1_N : N ; -- arbetsutskott..nn.1
  arbetsvan_1_A : A ; -- arbetsvan..av.1
  arbetsvana_1_N : N ; -- arbetsvana..nn.1
  arbetsvecka_1_N : N ; -- arbetsvecka..nn.1
  arbetsverktyg_1_N : N ; -- arbetsverktyg..nn.1
  arbetsvilja_1_N : N ; -- arbetsvilja..nn.1
  arbetsvillig_1_A : A ; -- arbetsvillig..av.1
  arbetsvillighet_1_N : N ; -- arbetsvillighet..nn.1
  arbetsvillkor_1_N : N ; -- arbetsvillkor..nn.1
  arbetsvärdering_1_N : N ; -- arbetsvärdering..nn.1
  arbetsväska_1_N : N ; -- arbetsväska..nn.1
  arbetsvård_1_N : N ; -- arbetsvård..nn.1
  arbetsår_1_N : N ; -- arbetsår..nn.1
  arbitrage_1_N : N ; -- arbitrage..nn.1
  arbiträr_1_A : A ; -- arbiträr..av.1
  arboretum_1_N : N ; -- arboretum..nn.1
  arborist_1_N : N ; -- arborist..nn.1
  arborr_1_N : N ; -- arborr..nn.1
  arborra_1_V : V ; -- arborra..vb.1
  arborrande_1_N : N ; -- arborrande..nn.1
  arbovirusencefalit_1_N : N ; -- arbovirusencefalit..nn.1
  arbovirusinfektion_1_N : N ; -- arbovirusinfektion..nn.1
  arcusmoln_1_N : N ; -- arcusmoln..nn.1
  ardenner_1_N : N ; -- ardenner..nn.1
  area_1_N : N ; -- area..nn.1
  areal_1_N : N ; -- areal..nn.1
  arealmässig_1_A : A ; -- arealmässig..av.1
  arena_1_N : N ; -- arena..nn.1
  arenabygge_1_N : N ; -- arenabygge..nn.1
  arenateater_1_N : N ; -- arenateater..nn.1
  arenavirusinfektion_1_N : N ; -- arenavirusinfektion..nn.1
  areometer_1_N : N ; -- areometer..nn.1
  areopag_1_N : N ; -- areopag..nn.1
  arg_1_A : A ; -- arg..av.1
  argbigga_1_N : N ; -- argbigga..nn.1
  argentinare_1_N : N ; -- argentinare..nn.1
  argentinsk_1_A : A ; -- argentinsk..av.1
  argentinska_1_N : N ; -- argentinska..nn.1
  arghet_1_N : N ; -- arghet..nn.1
  argininbärnstensaciduri_1_N : N ; -- argininbärnstensaciduri..nn.1
  argon_1_N : N ; -- argon..nn.1
  argot_1_N : N ; -- argot..nn.1
  argsint_1_A : A ; -- argsint..av.1
  argsinthet_1_N : N ; -- argsinthet..nn.1
  argument_1_N : N ; -- argument..nn.1
  argumentation_1_N : N ; -- argumentation..nn.1
  argumentationsanalys_1_N : N ; -- argumentationsanalys..nn.1
  argumentativ_1_A : A ; -- argumentativ..av.1
  argumentera_1_V : V ; -- argumentera..vb.1
  argumenterande_1_N : N ; -- argumenterande..nn.1
  argumenterbar_1_A : A ; -- argumenterbar..av.1
  argumenterbarhet_1_N : N ; -- argumenterbarhet..nn.1
  argumentering_1_N : N ; -- argumentering..nn.1
  argumentrik_1_A : A ; -- argumentrik..av.1
  argumentrikedom_1_N : N ; -- argumentrikedom..nn.1
  argusöga_1_N : N ; -- argusöga..nn.1
  argyri_1_N : N ; -- argyri..nn.1
  arhinencefali_1_N : N ; -- arhinencefali..nn.1
  aria_1_N : N ; -- aria..nn.1
  ariadnetråd_1_N : N ; -- ariadnetråd..nn.1
  arian_1_N : N ; -- arian..nn.1
  arianism_1_N : N ; -- arianism..nn.1
  ariansk_1_A : A ; -- ariansk..av.1
  arid_1_A : A ; -- arid..av.1
  arier_1_N : N ; -- arier..nn.1
  arioso_1_N : N ; -- arioso..nn.1
  arisk_1_A : A ; -- arisk..av.1
  aristokrat_1_N : N ; -- aristokrat..nn.1
  aristokrati_1_N : N ; -- aristokrati..nn.1
  aristokratisk_1_A : A ; -- aristokratisk..av.1
  aristokratvälde_1_N : N ; -- aristokratvälde..nn.1
  aritet_1_N : N ; -- aritet..nn.1
  aritmetik_1_N : N ; -- aritmetik..nn.1
  aritmetiker_1_N : N ; -- aritmetiker..nn.1
  aritmetisk_1_A : A ; -- aritmetisk..av.1
  ark_1_N : N ; -- ark..nn.1
  ark_2_N : N ; -- ark..nn.2
  arkad_1_N : N ; -- arkad..nn.1
  arkadgång_1_N : N ; -- arkadgång..nn.1
  arkadisk_1_A : A ; -- arkadisk..av.1
  arkadspel_1_N : N ; -- arkadspel..nn.1
  arkaisera_1_V : V ; -- arkaisera..vb.1
  arkaiserande_1_N : N ; -- arkaiserande..nn.1
  arkaiserbar_1_A : A ; -- arkaiserbar..av.1
  arkaiserbarhet_1_N : N ; -- arkaiserbarhet..nn.1
  arkaisering_1_N : N ; -- arkaisering..nn.1
  arkaisk_1_A : A ; -- arkaisk..av.1
  arkaism_1_N : N ; -- arkaism..nn.1
  arkaistisk_1_A : A ; -- arkaistisk..av.1
  arkebusera_1_V : V ; -- arkebusera..vb.1
  arkebuserande_1_N : N ; -- arkebuserande..nn.1
  arkebuserbar_1_A : A ; -- arkebuserbar..av.1
  arkebuserbarhet_1_N : N ; -- arkebuserbarhet..nn.1
  arkebusering_1_N : N ; -- arkebusering..nn.1
  arkeikum_1_N : N ; -- arkeikum..nn.1
  arkeolog_1_N : N ; -- arkeolog..nn.1
  arkeologi_1_N : N ; -- arkeologi..nn.1
  arkeologisk_1_A : A ; -- arkeologisk..av.1
  arkeologiämne_1_N : N ; -- arkeologiämne..nn.1
  arkeologkongress_1_N : N ; -- arkeologkongress..nn.1
  arketyp_1_N : N ; -- arketyp..nn.1
  arketypisk_1_A : A ; -- arketypisk..av.1
  arkiater_1_N : N ; -- arkiater..nn.1
  arkipelag_1_N : N ; -- arkipelag..nn.1
  arkitekt_1_N : N ; -- arkitekt..nn.1
  arkitektonik_1_N : N ; -- arkitektonik..nn.1
  arkitektonisk_1_A : A ; -- arkitektonisk..av.1
  arkitektur_1_N : N ; -- arkitektur..nn.1
  arkitekturpolitik_1_N : N ; -- arkitekturpolitik..nn.1
  arkitekturpolitisk_1_A : A ; -- arkitekturpolitisk..av.1
  arkitekturritning_1_N : N ; -- arkitekturritning..nn.1
  arkitrav_1_N : N ; -- arkitrav..nn.1
  arkiv_1_N : N ; -- arkiv..nn.1
  arkivalieskåp_1_N : N ; -- arkivalieskåp..nn.1
  arkivalisk_1_A : A ; -- arkivalisk..av.1
  arkivarbetare_1_N : N ; -- arkivarbetare..nn.1
  arkivarbete_1_N : N ; -- arkivarbete..nn.1
  arkivarie_1_N : N ; -- arkivarie..nn.1
  arkivera_1_V : V ; -- arkivera..vb.1
  arkiverande_1_N : N ; -- arkiverande..nn.1
  arkiverbar_1_A : A ; -- arkiverbar..av.1
  arkiverbarhet_1_N : N ; -- arkiverbarhet..nn.1
  arkivering_1_N : N ; -- arkivering..nn.1
  arkivexemplar_1_N : N ; -- arkivexemplar..nn.1
  arkivforskning_1_N : N ; -- arkivforskning..nn.1
  arkivmaterial_1_N : N ; -- arkivmaterial..nn.1
  arkivolt_1_N : N ; -- arkivolt..nn.1
  arkivsamling_1_N : N ; -- arkivsamling..nn.1
  arkivstudie_1_N : N ; -- arkivstudie..nn.1
  arksignatur_1_N : N ; -- arksignatur..nn.1
  arktisk_1_A : A ; -- arktisk..av.1
  arkvis_1_Adv : Adv ; -- arkvis..ab.1
  arm_1_A : A ; -- arm..av.1
  arm_1_N : N ; -- arm..nn.1
  armada_1_N : N ; -- armada..nn.1
  armagnac_1_N : N ; -- armagnac..nn.1
  armatur_1_N : N ; -- armatur..nn.1
  armband_1_N : N ; -- armband..nn.1
  armbandslås_1_N : N ; -- armbandslås..nn.1
  armbandsur_1_N : N ; -- armbandsur..nn.1
  armbindel_1_N : N ; -- armbindel..nn.1
  armborst_1_N : N ; -- armborst..nn.1
  armborstpil_1_N : N ; -- armborstpil..nn.1
  armborstskytt_1_N : N ; -- armborstskytt..nn.1
  armbrott_1_N : N ; -- armbrott..nn.1
  armbrytning_1_N : N ; -- armbrytning..nn.1
  armbågande_1_N : N ; -- armbågande..nn.1
  armbåge_1_N : N ; -- armbåge..nn.1
  armbågsben_1_N : N ; -- armbågsben..nn.1
  armbågsled_1_N : N ; -- armbågsled..nn.1
  armbågsnerv_1_N : N ; -- armbågsnerv..nn.1
  armbågsskydd_1_N : N ; -- armbågsskydd..nn.1
  armbågssträckare_1_N : N ; -- armbågssträckare..nn.1
  armbågsutskott_1_N : N ; -- armbågsutskott..nn.1
  armböjning_1_N : N ; -- armböjning..nn.1
  armcylinder_1_N : N ; -- armcylinder..nn.1
  armdyna_1_N : N ; -- armdyna..nn.1
  armenier_1_N : N ; -- armenier..nn.1
  armenisk_1_A : A ; -- armenisk..av.1
  armeniska_1_N : N ; -- armeniska..nn.1
  armeniska_2_N : N ; -- armeniska..nn.2
  armera_1_V : V ; -- armera..vb.1
  armerande_1_N : N ; -- armerande..nn.1
  armerbar_1_A : A ; -- armerbar..av.1
  armerbarhet_1_N : N ; -- armerbarhet..nn.1
  armering_1_N : N ; -- armering..nn.1
  armeringsjärn_1_N : N ; -- armeringsjärn..nn.1
  armfläta_1_N : N ; -- armfläta..nn.1
  armfoting_1_N : N ; -- armfoting..nn.1
  armföring_1_N : N ; -- armföring..nn.1
  armgång_1_N : N ; -- armgång..nn.1
  armhet_1_N : N ; -- armhet..nn.1
  armhävning_1_N : N ; -- armhävning..nn.1
  armhåla_1_N : N ; -- armhåla..nn.1
  armhålsstöd_1_N : N ; -- armhålsstöd..nn.1
  armkraft_1_N : N ; -- armkraft..nn.1
  armkrok_1_N : N ; -- armkrok..nn.1
  armkrokskedja_1_N : N ; -- armkrokskedja..nn.1
  armled_1_N : N ; -- armled..nn.1
  armljusstake_1_N : N ; -- armljusstake..nn.1
  armlängd_1_N : N ; -- armlängd..nn.1
  armlås_1_N : N ; -- armlås..nn.1
  armmudd_1_N : N ; -- armmudd..nn.1
  armmuskel_1_N : N ; -- armmuskel..nn.1
  armod_1_N : N ; -- armod..nn.1
  armodslöfte_1_N : N ; -- armodslöfte..nn.1
  armpolyp_1_N : N ; -- armpolyp..nn.1
  armring_1_N : N ; -- armring..nn.1
  armrörelse_1_N : N ; -- armrörelse..nn.1
  armskada_1_N : N ; -- armskada..nn.1
  armslängd_1_N : N ; -- armslängd..nn.1
  armslång_1_A : A ; -- armslång..av.1
  armstark_1_A : A ; -- armstark..av.1
  armstjock_1_A : A ; -- armstjock..av.1
  armstol_1_N : N ; -- armstol..nn.1
  armsträckning_1_N : N ; -- armsträckning..nn.1
  armstump_1_N : N ; -- armstump..nn.1
  armstyrka_1_N : N ; -- armstyrka..nn.1
  armstöd_1_N : N ; -- armstöd..nn.1
  armsvag_1_A : A ; -- armsvag..av.1
  armsvett_1_N : N ; -- armsvett..nn.1
  armtag_1_N : N ; -- armtag..nn.1
  armtrakt_1_N : N ; -- armtrakt..nn.1
  armveck_1_N : N ; -- armveck..nn.1
  armé_1_N : N ; -- armé..nn.1
  arméattaché_1_N : N ; -- arméattaché..nn.1
  arméavdelning_1_N : N ; -- arméavdelning..nn.1
  arméchef_1_N : N ; -- arméchef..nn.1
  arméförband_1_N : N ; -- arméförband..nn.1
  arméfördelning_1_N : N ; -- arméfördelning..nn.1
  arméförvaltning_1_N : N ; -- arméförvaltning..nn.1
  armégeneral_1_N : N ; -- armégeneral..nn.1
  armégevär_1_N : N ; -- armégevär..nn.1
  arméhelikopter_1_N : N ; -- arméhelikopter..nn.1
  arméhäst_1_N : N ; -- arméhäst..nn.1
  armékommuniké_1_N : N ; -- armékommuniké..nn.1
  armékår_1_N : N ; -- armékår..nn.1
  arméorganisation_1_N : N ; -- arméorganisation..nn.1
  arméstab_1_N : N ; -- arméstab..nn.1
  arméunderstöd_1_N : N ; -- arméunderstöd..nn.1
  arom_1_N : N ; -- arom..nn.1
  aromatisk_1_A : A ; -- aromatisk..av.1
  aromglas_1_N : N ; -- aromglas..nn.1
  aromkupa_1_N : N ; -- aromkupa..nn.1
  arpeggio_1_N : N ; -- arpeggio..nn.1
  arr_1_N : N ; -- arr..nn.1
  arra_1_V : V ; -- arra..vb.1
  arrak_1_N : N ; -- arrak..nn.1
  arrakpunch_1_N : N ; -- arrakpunch..nn.1
  arrakpunsch_1_N : N ; -- arrakpunsch..nn.1
  arrakspunsch_1_N : N ; -- arrakspunsch..nn.1
  arrakssmak_1_N : N ; -- arrakssmak..nn.1
  arrakstoddy_1_N : N ; -- arrakstoddy..nn.1
  arrangemang_1_N : N ; -- arrangemang..nn.1
  arrangemangsmässig_1_A : A ; -- arrangemangsmässig..av.1
  arrangera_1_V : V ; -- arrangera..vb.1
  arrangerande_1_N : N ; -- arrangerande..nn.1
  arrangerbar_1_A : A ; -- arrangerbar..av.1
  arrangerbarhet_1_N : N ; -- arrangerbarhet..nn.1
  arrangering_1_N : N ; -- arrangering..nn.1
  arrangör_1_N : N ; -- arrangör..nn.1
  arrangörsmässig_1_A : A ; -- arrangörsmässig..av.1
  arrendator_1_N : N ; -- arrendator..nn.1
  arrende_1_N : N ; -- arrende..nn.1
  arrendeavgift_1_N : N ; -- arrendeavgift..nn.1
  arrendebelopp_1_N : N ; -- arrendebelopp..nn.1
  arrendekontrakt_1_N : N ; -- arrendekontrakt..nn.1
  arrendera_1_V : V ; -- arrendera..vb.1
  arrenderande_1_N : N ; -- arrenderande..nn.1
  arrenderbar_1_A : A ; -- arrenderbar..av.1
  arrenderbarhet_1_N : N ; -- arrenderbarhet..nn.1
  arrendering_1_N : N ; -- arrendering..nn.1
  arrendevillkor_1_N : N ; -- arrendevillkor..nn.1
  arrest_1_N : N ; -- arrest..nn.1
  arrestant_1_N : N ; -- arrestant..nn.1
  arrestavdelning_1_N : N ; -- arrestavdelning..nn.1
  arrestera_1_V : V ; -- arrestera..vb.1
  arresterande_1_N : N ; -- arresterande..nn.1
  arresterbar_1_A : A ; -- arresterbar..av.1
  arresterbarhet_1_N : N ; -- arresterbarhet..nn.1
  arrestering_1_N : N ; -- arrestering..nn.1
  arresteringsorder_1_N : N ; -- arresteringsorder..nn.1
  arrestlokal_1_N : N ; -- arrestlokal..nn.1
  arrestrum_1_N : N ; -- arrestrum..nn.1
  arreststraff_1_N : N ; -- arreststraff..nn.1
  arresttid_1_N : N ; -- arresttid..nn.1
  arriverad_1_A : A ; -- arriverad..av.1
  arrivist_1_N : N ; -- arrivist..nn.1
  arriärgarde_1_N : N ; -- arriärgarde..nn.1
  arrogans_1_N : N ; -- arrogans..nn.1
  arrogant_1_A : A ; -- arrogant..av.1
  arrondera_1_V : V ; -- arrondera..vb.1
  arronderande_1_N : N ; -- arronderande..nn.1
  arronderbar_1_A : A ; -- arronderbar..av.1
  arronderbarhet_1_N : N ; -- arronderbarhet..nn.1
  arrondering_1_N : N ; -- arrondering..nn.1
  arrondissemang_1_N : N ; -- arrondissemang..nn.1
  arrondissement_1_N : N ; -- arrondissement..nn.1
  arrowrot_1_N : N ; -- arrowrot..nn.1
  arschel_1_N : N ; -- arschel..nn.1
  arschle_1_N : N ; -- arschle..nn.1
  arsel_1_N : N ; -- arsel..nn.1
  arsenal_1_N : N ; -- arsenal..nn.1
  arsenalsbyggnad_1_N : N ; -- arsenalsbyggnad..nn.1
  arsenik_1_N : N ; -- arsenik..nn.1
  arsenikdos_1_N : N ; -- arsenikdos..nn.1
  arsenikfri_1_A : A ; -- arsenikfri..av.1
  arsenikförgiftning_1_N : N ; -- arsenikförgiftning..nn.1
  arsenikhalt_1_N : N ; -- arsenikhalt..nn.1
  arsenikhaltig_1_A : A ; -- arsenikhaltig..av.1
  arsenikkis_1_N : N ; -- arsenikkis..nn.1
  arsenikmord_1_N : N ; -- arsenikmord..nn.1
  arsenikväte_1_N : N ; -- arsenikväte..nn.1
  arsle_1_N : N ; -- arsle..nn.1
  art_1_N : N ; -- art..nn.1
  artbank_1_N : N ; -- artbank..nn.1
  artbeskrivning_1_N : N ; -- artbeskrivning..nn.1
  artbestämma_1_V : V ; -- artbestämma..vb.1
  artbestämmande_1_N : N ; -- artbestämmande..nn.1
  artbestämning_1_N : N ; -- artbestämning..nn.1
  artbildning_1_N : N ; -- artbildning..nn.1
  artbildningsteori_1_N : N ; -- artbildningsteori..nn.1
  artdatabank_1_N : N ; -- artdatabank..nn.1
  artefakt_1_N : N ; -- artefakt..nn.1
  artegen_1_A : A ; -- artegen..av.1
  artegenhet_1_N : N ; -- artegenhet..nn.1
  arteriell_1_A : A ; -- arteriell..av.1
  arterioskleros_1_N : N ; -- arterioskleros..nn.1
  arterit_1_N : N ; -- arterit..nn.1
  arterivirusinfektion_1_N : N ; -- arterivirusinfektion..nn.1
  artesisk_1_A : A ; -- artesisk..av.1
  artfrämmande_1_A : A ; -- artfrämmande..av.1
  artfrände_1_N : N ; -- artfrände..nn.1
  artförändring_1_N : N ; -- artförändring..nn.1
  artificiell_1_A : A ; -- artificiell..av.1
  artig_1_A : A ; -- artig..av.1
  artighet_1_N : N ; -- artighet..nn.1
  artighetsbetygelse_1_N : N ; -- artighetsbetygelse..nn.1
  artighetsbevis_1_N : N ; -- artighetsbevis..nn.1
  artighetsfras_1_N : N ; -- artighetsfras..nn.1
  artighetsvisit_1_N : N ; -- artighetsvisit..nn.1
  artikel_1_N : N ; -- artikel..nn.1
  artikelförfattare_1_N : N ; -- artikelförfattare..nn.1
  artikelserie_1_N : N ; -- artikelserie..nn.1
  artikulation_1_N : N ; -- artikulation..nn.1
  artikulationsbas_1_N : N ; -- artikulationsbas..nn.1
  artikulationsrubbning_1_N : N ; -- artikulationsrubbning..nn.1
  artikulationsställe_1_N : N ; -- artikulationsställe..nn.1
  artikulera_1_V : V ; -- artikulera..vb.1
  artikulerande_1_N : N ; -- artikulerande..nn.1
  artikulerbar_1_A : A ; -- artikulerbar..av.1
  artikulerbarhet_1_N : N ; -- artikulerbarhet..nn.1
  artikulering_1_N : N ; -- artikulering..nn.1
  artilleri_1_N : N ; -- artilleri..nn.1
  artilleribatteri_1_N : N ; -- artilleribatteri..nn.1
  artilleribeskjutning_1_N : N ; -- artilleribeskjutning..nn.1
  artilleriduell_1_N : N ; -- artilleriduell..nn.1
  artillerield_1_N : N ; -- artillerield..nn.1
  artilleriförband_1_N : N ; -- artilleriförband..nn.1
  artillerigranat_1_N : N ; -- artillerigranat..nn.1
  artillerimanskap_1_N : N ; -- artillerimanskap..nn.1
  artilleripjäs_1_N : N ; -- artilleripjäs..nn.1
  artilleriregemente_1_N : N ; -- artilleriregemente..nn.1
  artillerist_1_N : N ; -- artillerist..nn.1
  artillerivapen_1_N : N ; -- artillerivapen..nn.1
  artist_1_N : N ; -- artist..nn.1
  artistbana_1_N : N ; -- artistbana..nn.1
  artisteri_1_N : N ; -- artisteri..nn.1
  artistframträdande_1_N : N ; -- artistframträdande..nn.1
  artistisk_1_A : A ; -- artistisk..av.1
  artistliv_1_N : N ; -- artistliv..nn.1
  artistmässig_1_A : A ; -- artistmässig..av.1
  artistnamn_1_N : N ; -- artistnamn..nn.1
  artnamn_1_N : N ; -- artnamn..nn.1
  artonde_1_A : A ; -- artonde..av.1
  artonhundranittiotal_1_N : N ; -- artonhundranittiotal..nn.1
  artonhundrasjuttiotal_1_N : N ; -- artonhundrasjuttiotal..nn.1
  artonhundratal_1_N : N ; -- artonhundratal..nn.1
  artonhundratalsmode_1_N : N ; -- artonhundratalsmode..nn.1
  artonhundraåttiotal_1_N : N ; -- artonhundraåttiotal..nn.1
  artonårig_1_A : A ; -- artonårig..av.1
  artonåring_1_N : N ; -- artonåring..nn.1
  artonårsdag_1_N : N ; -- artonårsdag..nn.1
  artonårsmyndighet_1_N : N ; -- artonårsmyndighet..nn.1
  artotek_1_N : N ; -- artotek..nn.1
  artralgi_1_N : N ; -- artralgi..nn.1
  artrik_1_A : A ; -- artrik..av.1
  artrikhet_1_N : N ; -- artrikhet..nn.1
  artrit_1_N : N ; -- artrit..nn.1
  artrogrypos_1_N : N ; -- artrogrypos..nn.1
  artros_1_N : N ; -- artros..nn.1
  artroskopi_1_N : N ; -- artroskopi..nn.1
  artskild_1_A : A ; -- artskild..av.1
  artskildhet_1_N : N ; -- artskildhet..nn.1
  artskillnad_1_N : N ; -- artskillnad..nn.1
  artär_1_N : N ; -- artär..nn.1
  artärbråck_1_N : N ; -- artärbråck..nn.1
  artärinflammation_1_N : N ; -- artärinflammation..nn.1
  artärvägg_1_N : N ; -- artärvägg..nn.1
  arv_1_N : N ; -- arv..nn.1
  arve_1_N : N ; -- arve..nn.1
  arvedel_1_N : N ; -- arvedel..nn.1
  arvegods_1_N : N ; -- arvegods..nn.1
  arvejord_1_N : N ; -- arvejord..nn.1
  arvfiende_1_N : N ; -- arvfiende..nn.1
  arvfurste_1_N : N ; -- arvfurste..nn.1
  arvföljd_1_N : N ; -- arvföljd..nn.1
  arvföljdskrig_1_N : N ; -- arvföljdskrig..nn.1
  arvförening_1_N : N ; -- arvförening..nn.1
  arvinge_1_N : N ; -- arvinge..nn.1
  arvkonung_1_N : N ; -- arvkonung..nn.1
  arvland_1_N : N ; -- arvland..nn.1
  arvlåtare_1_N : N ; -- arvlåtare..nn.1
  arvlös_1_A : A ; -- arvlös..av.1
  arvlöshet_1_N : N ; -- arvlöshet..nn.1
  arvode_1_N : N ; -- arvode..nn.1
  arvodera_1_V : V ; -- arvodera..vb.1
  arvoderande_1_N : N ; -- arvoderande..nn.1
  arvoderbar_1_A : A ; -- arvoderbar..av.1
  arvoderbarhet_1_N : N ; -- arvoderbarhet..nn.1
  arvodering_1_N : N ; -- arvodering..nn.1
  arvodesbelopp_1_N : N ; -- arvodesbelopp..nn.1
  arvord_1_N : N ; -- arvord..nn.1
  arvprins_1_N : N ; -- arvprins..nn.1
  arvrike_1_N : N ; -- arvrike..nn.1
  arvsanlag_1_N : N ; -- arvsanlag..nn.1
  arvsanspråk_1_N : N ; -- arvsanspråk..nn.1
  arvsberättigad_1_A : A ; -- arvsberättigad..av.1
  arvsfaktor_1_N : N ; -- arvsfaktor..nn.1
  arvsfond_1_N : N ; -- arvsfond..nn.1
  arvsfråga_1_N : N ; -- arvsfråga..nn.1
  arvsföljd_1_N : N ; -- arvsföljd..nn.1
  arvskatt_1_N : N ; -- arvskatt..nn.1
  arvskifte_1_N : N ; -- arvskifte..nn.1
  arvslott_1_N : N ; -- arvslott..nn.1
  arvsmassa_1_N : N ; -- arvsmassa..nn.1
  arvsmedel_1_N : N ; -- arvsmedel..nn.1
  arvsmolekyl_1_N : N ; -- arvsmolekyl..nn.1
  arvsmässig_1_A : A ; -- arvsmässig..av.1
  arvsordning_1_N : N ; -- arvsordning..nn.1
  arvsrätt_1_N : N ; -- arvsrätt..nn.1
  arvssak_1_N : N ; -- arvssak..nn.1
  arvsskatt_1_N : N ; -- arvsskatt..nn.1
  arvstvist_1_N : N ; -- arvstvist..nn.1
  arvsynd_1_N : N ; -- arvsynd..nn.1
  arvtagare_1_N : N ; -- arvtagare..nn.1
  arvtant_1_N : N ; -- arvtant..nn.1
  arytmi_1_N : N ; -- arytmi..nn.1
  as_1_N : N ; -- as..nn.1
  as_2_N : N ; -- as..nn.2
  asa_1_V : V ; -- asa..vb.1
  asagud_1_N : N ; -- asagud..nn.1
  asalära_1_N : N ; -- asalära..nn.1
  asande_1_N : N ; -- asande..nn.1
  asasläkt_1_N : N ; -- asasläkt..nn.1
  asatid_1_N : N ; -- asatid..nn.1
  asatro_1_N : N ; -- asatro..nn.1
  asatroende_1_A : A ; -- asatroende..av.1
  asbagge_1_N : N ; -- asbagge..nn.1
  asberusad_1_A : A ; -- asberusad..av.1
  asbest_1_N : N ; -- asbest..nn.1
  asbestarbetare_1_N : N ; -- asbestarbetare..nn.1
  asbestartad_1_A : A ; -- asbestartad..av.1
  asbestcement_1_N : N ; -- asbestcement..nn.1
  asbestlunga_1_N : N ; -- asbestlunga..nn.1
  asbestos_1_N : N ; -- asbestos..nn.1
  asbestplatta_1_N : N ; -- asbestplatta..nn.1
  asbestsanering_1_N : N ; -- asbestsanering..nn.1
  asbesttråd_1_N : N ; -- asbesttråd..nn.1
  ascaridiasis_1_N : N ; -- ascaridiasis..nn.1
  ascarididainfektion_1_N : N ; -- ascarididainfektion..nn.1
  ascendent_1_N : N ; -- ascendent..nn.1
  aschel_1_N : N ; -- aschel..nn.1
  aschle_1_N : N ; -- aschle..nn.1
  ascites_1_N : N ; -- ascites..nn.1
  asenkel_1_A : A ; -- asenkel..av.1
  aseptik_1_N : N ; -- aseptik..nn.1
  aseptisk_1_A : A ; -- aseptisk..av.1
  asexuell_1_A : A ; -- asexuell..av.1
  asfalt_1_N : N ; -- asfalt..nn.1
  asfaltemulsion_1_N : N ; -- asfaltemulsion..nn.1
  asfaltera_1_V : V ; -- asfaltera..vb.1
  asfalterande_1_N : N ; -- asfalterande..nn.1
  asfalterbar_1_A : A ; -- asfalterbar..av.1
  asfalterbarhet_1_N : N ; -- asfalterbarhet..nn.1
  asfaltering_1_N : N ; -- asfaltering..nn.1
  asfaltlack_1_N : N ; -- asfaltlack..nn.1
  asfaltmoped_1_N : N ; -- asfaltmoped..nn.1
  asfaltplatta_1_N : N ; -- asfaltplatta..nn.1
  asfluga_1_N : N ; -- asfluga..nn.1
  asfull_1_A : A ; -- asfull..av.1
  asfyxi_1_N : N ; -- asfyxi..nn.1
  asfyxiskada_1_N : N ; -- asfyxiskada..nn.1
  asfågel_1_N : N ; -- asfågel..nn.1
  asförbannad_1_A : A ; -- asförbannad..av.1
  asgam_1_N : N ; -- asgam..nn.1
  asgarva_1_V : V ; -- asgarva..vb.1
  ashkenaz_1_N : N ; -- ashkenaz..nn.1
  ashkenazisk_1_A : A ; -- ashkenazisk..av.1
  asiat_1_N : N ; -- asiat..nn.1
  asiatisk_1_A : A ; -- asiatisk..av.1
  asiatiska_1_N : N ; -- asiatiska..nn.1
  asimut_1_N : N ; -- asimut..nn.1
  ask_1_N : N ; -- ask..nn.1
  aska_1_N : N ; -- aska..nn.1
  aska_1_V : V ; -- aska..vb.1
  askande_1_N : N ; -- askande..nn.1
  askblond_1_A : A ; -- askblond..av.1
  aske_1_N : N ; -- aske..nn.1
  askenas_1_N : N ; -- askenas..nn.1
  askeruption_1_N : N ; -- askeruption..nn.1
  askes_1_N : N ; -- askes..nn.1
  asket_1_N : N ; -- asket..nn.1
  asketisk_1_A : A ; -- asketisk..av.1
  asketism_1_N : N ; -- asketism..nn.1
  asketliv_1_N : N ; -- asketliv..nn.1
  askexplosion_1_N : N ; -- askexplosion..nn.1
  askfat_1_N : N ; -- askfat..nn.1
  askfri_1_A : A ; -- askfri..av.1
  askfrihet_1_N : N ; -- askfrihet..nn.1
  askgrå_1_A : A ; -- askgrå..av.1
  askhot_1_N : N ; -- askhot..nn.1
  askhög_1_N : N ; -- askhög..nn.1
  askkoncentration_1_N : N ; -- askkoncentration..nn.1
  askkopp_1_N : N ; -- askkopp..nn.1
  askkris_1_N : N ; -- askkris..nn.1
  asklock_1_N : N ; -- asklock..nn.1
  askmoln_1_N : N ; -- askmoln..nn.1
  askonsdag_1_N : N ; -- askonsdag..nn.1
  askorbinsyra_1_N : N ; -- askorbinsyra..nn.1
  askorbinsyrabrist_1_N : N ; -- askorbinsyrabrist..nn.1
  askpartikel_1_N : N ; -- askpartikel..nn.1
  askpuff_1_N : N ; -- askpuff..nn.1
  askregn_1_N : N ; -- askregn..nn.1
  askskott_1_N : N ; -- askskott..nn.1
  askskottssjuka_1_N : N ; -- askskottssjuka..nn.1
  askspridning_1_N : N ; -- askspridning..nn.1
  asktipp_1_N : N ; -- asktipp..nn.1
  askträ_1_N : N ; -- askträ..nn.1
  askunge_1_N : N ; -- askunge..nn.1
  askurna_1_N : N ; -- askurna..nn.1
  asocial_1_A : A ; -- asocial..av.1
  asocialitet_1_N : N ; -- asocialitet..nn.1
  asp_1_N : N ; -- asp..nn.1
  aspackad_1_A : A ; -- aspackad..av.1
  aspartylglukosaminuri_1_N : N ; -- aspartylglukosaminuri..nn.1
  aspbark_1_N : N ; -- aspbark..nn.1
  aspdunge_1_N : N ; -- aspdunge..nn.1
  aspe_1_N : N ; -- aspe..nn.1
  aspekt_1_N : N ; -- aspekt..nn.1
  aspergillos_1_N : N ; -- aspergillos..nn.1
  aspgren_1_N : N ; -- aspgren..nn.1
  asphänge_1_N : N ; -- asphänge..nn.1
  aspirant_1_N : N ; -- aspirant..nn.1
  aspirata_1_N : N ; -- aspirata..nn.1
  aspiration_1_N : N ; -- aspiration..nn.1
  aspirationspneumoni_1_N : N ; -- aspirationspneumoni..nn.1
  aspirera_1_V : V ; -- aspirera..vb.1
  aspirerad_1_A : A ; -- aspirerad..av.1
  aspirerande_1_N : N ; -- aspirerande..nn.1
  aspirerbar_1_A : A ; -- aspirerbar..av.1
  aspirerbarhet_1_N : N ; -- aspirerbarhet..nn.1
  aspirering_1_N : N ; -- aspirering..nn.1
  aspirin_1_N : N ; -- aspirin..nn.1
  asplöv_1_N : N ; -- asplöv..nn.1
  aspsly_1_N : N ; -- aspsly..nn.1
  ass_1_N : N ; -- ass..nn.1
  assegaj_1_N : N ; -- assegaj..nn.1
  assessor_1_N : N ; -- assessor..nn.1
  assiett_1_N : N ; -- assiett..nn.1
  assiettgaffel_1_N : N ; -- assiettgaffel..nn.1
  assignant_1_N : N ; -- assignant..nn.1
  assignation_1_N : N ; -- assignation..nn.1
  assignera_1_V : V ; -- assignera..vb.1
  assignerande_1_N : N ; -- assignerande..nn.1
  assignerbar_1_A : A ; -- assignerbar..av.1
  assignerbarhet_1_N : N ; -- assignerbarhet..nn.1
  assignering_1_N : N ; -- assignering..nn.1
  assimilation_1_N : N ; -- assimilation..nn.1
  assimilationsprocess_1_N : N ; -- assimilationsprocess..nn.1
  assimilera_1_V : V ; -- assimilera..vb.1
  assimilerande_1_N : N ; -- assimilerande..nn.1
  assimilerbar_1_A : A ; -- assimilerbar..av.1
  assimilerbarhet_1_N : N ; -- assimilerbarhet..nn.1
  assimilering_1_N : N ; -- assimilering..nn.1
  assist_1_N : N ; -- assist..nn.1
  assistans_1_N : N ; -- assistans..nn.1
  assistdrottning_1_N : N ; -- assistdrottning..nn.1
  assistent_1_N : N ; -- assistent..nn.1
  assistera_1_V : V ; -- assistera..vb.1
  assisterande_1_N : N ; -- assisterande..nn.1
  assisterbar_1_A : A ; -- assisterbar..av.1
  assisterbarhet_1_N : N ; -- assisterbarhet..nn.1
  assistering_1_N : N ; -- assistering..nn.1
  assistkung_1_N : N ; -- assistkung..nn.1
  association_1_N : N ; -- association..nn.1
  associationsbana_1_N : N ; -- associationsbana..nn.1
  associationskedja_1_N : N ; -- associationskedja..nn.1
  associationslexikon_1_N : N ; -- associationslexikon..nn.1
  associationspsykologi_1_N : N ; -- associationspsykologi..nn.1
  associationsrik_1_A : A ; -- associationsrik..av.1
  associationsrikedom_1_N : N ; -- associationsrikedom..nn.1
  associativ_1_A : A ; -- associativ..av.1
  associera_1_V : V ; -- associera..vb.1
  associerande_1_N : N ; -- associerande..nn.1
  associerbar_1_A : A ; -- associerbar..av.1
  associerbarhet_1_N : N ; -- associerbarhet..nn.1
  associering_1_N : N ; -- associering..nn.1
  assonans_1_N : N ; -- assonans..nn.1
  assuradör_1_N : N ; -- assuradör..nn.1
  assurans_1_N : N ; -- assurans..nn.1
  assuransspruta_1_N : N ; -- assuransspruta..nn.1
  assurera_1_V : V ; -- assurera..vb.1
  assurerande_1_N : N ; -- assurerande..nn.1
  assurerbar_1_A : A ; -- assurerbar..av.1
  assurerbarhet_1_N : N ; -- assurerbarhet..nn.1
  assurering_1_N : N ; -- assurering..nn.1
  assyrier_1_N : N ; -- assyrier..nn.1
  assyrisk_1_A : A ; -- assyrisk..av.1
  assyriska_1_N : N ; -- assyriska..nn.1
  assyriska_2_N : N ; -- assyriska..nn.2
  asså_1_Adv : Adv ; -- asså..ab.1
  astat_1_N : N ; -- astat..nn.1
  asteni_1_N : N ; -- asteni..nn.1
  asteniker_1_N : N ; -- asteniker..nn.1
  astenisk_1_A : A ; -- astenisk..av.1
  astenopi_1_N : N ; -- astenopi..nn.1
  astenozoospermi_1_N : N ; -- astenozoospermi..nn.1
  aster_1_N : N ; -- aster..nn.1
  asterisk_1_N : N ; -- asterisk..nn.1
  asteroid_1_N : N ; -- asteroid..nn.1
  asteroidnedfall_1_N : N ; -- asteroidnedfall..nn.1
  asteroidnedslag_1_N : N ; -- asteroidnedslag..nn.1
  astigmatiker_1_N : N ; -- astigmatiker..nn.1
  astigmatisk_1_A : A ; -- astigmatisk..av.1
  astigmatism_1_N : N ; -- astigmatism..nn.1
  astma_1_N : N ; -- astma..nn.1
  astmatiker_1_N : N ; -- astmatiker..nn.1
  astmatisk_1_A : A ; -- astmatisk..av.1
  astrakan_1_N : N ; -- astrakan..nn.1
  astrakan_2_N : N ; -- astrakan..nn.2
  astral_1_A : A ; -- astral..av.1
  astralkropp_1_N : N ; -- astralkropp..nn.1
  astrocytom_1_N : N ; -- astrocytom..nn.1
  astrofotografi_1_N : N ; -- astrofotografi..nn.1
  astrofysik_1_N : N ; -- astrofysik..nn.1
  astrofysiker_1_N : N ; -- astrofysiker..nn.1
  astrolabium_1_N : N ; -- astrolabium..nn.1
  astrolog_1_N : N ; -- astrolog..nn.1
  astrologi_1_N : N ; -- astrologi..nn.1
  astrologisk_1_A : A ; -- astrologisk..av.1
  astronaut_1_N : N ; -- astronaut..nn.1
  astronautik_1_N : N ; -- astronautik..nn.1
  astronom_1_N : N ; -- astronom..nn.1
  astronomi_1_N : N ; -- astronomi..nn.1
  astronomisk_1_A : A ; -- astronomisk..av.1
  astronomisk_2_A : A ; -- astronomisk..av.2
  astrovirusinfektion_1_N : N ; -- astrovirusinfektion..nn.1
  asyl_1_N : N ; -- asyl..nn.1
  asylland_1_N : N ; -- asylland..nn.1
  asylmottagning_1_N : N ; -- asylmottagning..nn.1
  asylpolitik_1_N : N ; -- asylpolitik..nn.1
  asylrätt_1_N : N ; -- asylrätt..nn.1
  asylskäl_1_N : N ; -- asylskäl..nn.1
  asylsökande_1_A : A ; -- asylsökande..av.1
  asylsökande_1_N : N ; -- asylsökande..nn.1
  asymmetri_1_N : N ; -- asymmetri..nn.1
  asymmetrisk_1_A : A ; -- asymmetrisk..av.1
  asymptot_1_N : N ; -- asymptot..nn.1
  asyndes_1_N : N ; -- asyndes..nn.1
  asyndetisk_1_A : A ; -- asyndetisk..av.1
  asyndeton_1_N : N ; -- asyndeton..nn.1
  asynja_1_N : N ; -- asynja..nn.1
  asynkron_1_A : A ; -- asynkron..av.1
  asystoli_1_N : N ; -- asystoli..nn.1
  asätare_1_N : N ; -- asätare..nn.1
  ataktisk_1_A : A ; -- ataktisk..av.1
  ataraktika_1_N : N ; -- ataraktika..nn.1
  ataraxi_1_N : N ; -- ataraxi..nn.1
  atavism_1_N : N ; -- atavism..nn.1
  atavistisk_1_A : A ; -- atavistisk..av.1
  ataxi_1_N : N ; -- ataxi..nn.1
  ateism_1_N : N ; -- ateism..nn.1
  ateist_1_N : N ; -- ateist..nn.1
  ateistisk_1_A : A ; -- ateistisk..av.1
  atelektas_1_N : N ; -- atelektas..nn.1
  ateljé_1_N : N ; -- ateljé..nn.1
  ateljébild_1_N : N ; -- ateljébild..nn.1
  ateljéfönster_1_N : N ; -- ateljéfönster..nn.1
  ateljévåning_1_N : N ; -- ateljévåning..nn.1
  atenienn_1_N : N ; -- atenienn..nn.1
  atensk_1_A : A ; -- atensk..av.1
  aterogenes_1_N : N ; -- aterogenes..nn.1
  aterom_1_N : N ; -- aterom..nn.1
  ateroskleros_1_N : N ; -- ateroskleros..nn.1
  atetos_1_N : N ; -- atetos..nn.1
  atlantisk_1_A : A ; -- atlantisk..av.1
  atlantångare_1_N : N ; -- atlantångare..nn.1
  atlas_1_N : N ; -- atlas..nn.1
  atlas_2_N : N ; -- atlas..nn.2
  atlasbindning_1_N : N ; -- atlasbindning..nn.1
  atlaskota_1_N : N ; -- atlaskota..nn.1
  atlasspinnare_1_N : N ; -- atlasspinnare..nn.1
  atlet_1_N : N ; -- atlet..nn.1
  atletisk_1_A : A ; -- atletisk..av.1
  atletklubb_1_N : N ; -- atletklubb..nn.1
  atmosfär_1_N : N ; -- atmosfär..nn.1
  atmosfärforskare_1_N : N ; -- atmosfärforskare..nn.1
  atmosfärisk_1_A : A ; -- atmosfärisk..av.1
  atmosfärkemist_1_N : N ; -- atmosfärkemist..nn.1
  atmosfärsförhållande_1_N : N ; -- atmosfärsförhållande..nn.1
  atmosfärslager_1_N : N ; -- atmosfärslager..nn.1
  atmosfärstryck_1_N : N ; -- atmosfärstryck..nn.1
  atmosfärtryck_1_N : N ; -- atmosfärtryck..nn.1
  atoll_1_N : N ; -- atoll..nn.1
  atom_1_N : N ; -- atom..nn.1
  atombomb_1_N : N ; -- atombomb..nn.1
  atombomba_1_V : V ; -- atombomba..vb.1
  atombombande_1_N : N ; -- atombombande..nn.1
  atombombsfällning_1_N : N ; -- atombombsfällning..nn.1
  atombombsöverlevande_1_A : A ; -- atombombsöverlevande..av.1
  atombrygga_1_N : N ; -- atombrygga..nn.1
  atomdriven_1_A : A ; -- atomdriven..av.1
  atomenergi_1_N : N ; -- atomenergi..nn.1
  atomenergiorgan_1_N : N ; -- atomenergiorgan..nn.1
  atomenergiorganisation_1_N : N ; -- atomenergiorganisation..nn.1
  atomfysik_1_N : N ; -- atomfysik..nn.1
  atomgrupp_1_N : N ; -- atomgrupp..nn.1
  atomism_1_N : N ; -- atomism..nn.1
  atomistisk_1_A : A ; -- atomistisk..av.1
  atomjon_1_N : N ; -- atomjon..nn.1
  atomklocka_1_N : N ; -- atomklocka..nn.1
  atomkraft_1_N : N ; -- atomkraft..nn.1
  atomkraftmikroskop_1_N : N ; -- atomkraftmikroskop..nn.1
  atomkraftsutbyggnad_1_N : N ; -- atomkraftsutbyggnad..nn.1
  atomkärna_1_N : N ; -- atomkärna..nn.1
  atomlära_1_N : N ; -- atomlära..nn.1
  atommassa_1_N : N ; -- atommassa..nn.1
  atommodell_1_N : N ; -- atommodell..nn.1
  atomnummer_1_N : N ; -- atomnummer..nn.1
  atomreaktor_1_N : N ; -- atomreaktor..nn.1
  atomspektrum_1_N : N ; -- atomspektrum..nn.1
  atomteori_1_N : N ; -- atomteori..nn.1
  atomubåt_1_N : N ; -- atomubåt..nn.1
  atomur_1_N : N ; -- atomur..nn.1
  atomvapen_1_N : N ; -- atomvapen..nn.1
  atomvikt_1_N : N ; -- atomvikt..nn.1
  atomvinter_1_N : N ; -- atomvinter..nn.1
  atomär_1_A : A ; -- atomär..av.1
  atonal_1_A : A ; -- atonal..av.1
  atoni_1_N : N ; -- atoni..nn.1
  atopi_1_N : N ; -- atopi..nn.1
  atrieflimmer_1_N : N ; -- atrieflimmer..nn.1
  atrium_1_N : N ; -- atrium..nn.1
  atrofi_1_N : N ; -- atrofi..nn.1
  atrofiera_1_V : V ; -- atrofiera..vb.1
  atrofierande_1_N : N ; -- atrofierande..nn.1
  atrofierbar_1_A : A ; -- atrofierbar..av.1
  atrofierbarhet_1_N : N ; -- atrofierbarhet..nn.1
  atrofiering_1_N : N ; -- atrofiering..nn.1
  atrofisk_1_A : A ; -- atrofisk..av.1
  atropin_1_N : N ; -- atropin..nn.1
  att_sats_1_N : N ; -- att-sats..nn.1
  attaché_1_N : N ; -- attaché..nn.1
  attachéväska_1_N : N ; -- attachéväska..nn.1
  attack_1_N : N ; -- attack..nn.1
  attackdykare_1_N : N ; -- attackdykare..nn.1
  attackera_1_V : V ; -- attackera..vb.1
  attackerande_1_N : N ; -- attackerande..nn.1
  attackerbar_1_A : A ; -- attackerbar..av.1
  attackerbarhet_1_N : N ; -- attackerbarhet..nn.1
  attackering_1_N : N ; -- attackering..nn.1
  attackflyg_1_N : N ; -- attackflyg..nn.1
  attackflygplan_1_N : N ; -- attackflygplan..nn.1
  attackförmåga_1_N : N ; -- attackförmåga..nn.1
  attackhelikopter_1_N : N ; -- attackhelikopter..nn.1
  attackplan_1_N : N ; -- attackplan..nn.1
  attacksignal_1_N : N ; -- attacksignal..nn.1
  attan_1_N : N ; -- attan..nn.1
  attentat_1_N : N ; -- attentat..nn.1
  attentator_1_N : N ; -- attentator..nn.1
  attentatsman_1_N : N ; -- attentatsman..nn.1
  attest_1_N : N ; -- attest..nn.1
  attestera_1_V : V ; -- attestera..vb.1
  attesterande_1_N : N ; -- attesterande..nn.1
  attesterbar_1_A : A ; -- attesterbar..av.1
  attesterbarhet_1_N : N ; -- attesterbarhet..nn.1
  attestering_1_N : N ; -- attestering..nn.1
  attika_1_N : N ; -- attika..nn.1
  attila_1_N : N ; -- attila..nn.1
  attiralj_1_N : N ; -- attiralj..nn.1
  attisk_1_A : A ; -- attisk..av.1
  attityd_1_N : N ; -- attityd..nn.1
  attitydförändring_1_N : N ; -- attitydförändring..nn.1
  attitydmässig_1_A : A ; -- attitydmässig..av.1
  attitydundersökning_1_N : N ; -- attitydundersökning..nn.1
  attrahera_1_V : V ; -- attrahera..vb.1
  attraherande_1_N : N ; -- attraherande..nn.1
  attraherbar_1_A : A ; -- attraherbar..av.1
  attraherbarhet_1_N : N ; -- attraherbarhet..nn.1
  attrahering_1_N : N ; -- attrahering..nn.1
  attraktion_1_N : N ; -- attraktion..nn.1
  attraktionskraft_1_N : N ; -- attraktionskraft..nn.1
  attraktionslag_1_N : N ; -- attraktionslag..nn.1
  attraktiv_1_A : A ; -- attraktiv..av.1
  attraktivitet_1_N : N ; -- attraktivitet..nn.1
  attrapp_1_N : N ; -- attrapp..nn.1
  attrappera_1_V : V ; -- attrappera..vb.1
  attrapperande_1_N : N ; -- attrapperande..nn.1
  attrapperbar_1_A : A ; -- attrapperbar..av.1
  attrapperbarhet_1_N : N ; -- attrapperbarhet..nn.1
  attrappering_1_N : N ; -- attrappering..nn.1
  attribuera_1_V : V ; -- attribuera..vb.1
  attribuerande_1_N : N ; -- attribuerande..nn.1
  attribuerbar_1_A : A ; -- attribuerbar..av.1
  attribuerbarhet_1_N : N ; -- attribuerbarhet..nn.1
  attribuering_1_N : N ; -- attribuering..nn.1
  attribut_1_N : N ; -- attribut..nn.1
  attribution_1_N : N ; -- attribution..nn.1
  attributiv_1_A : A ; -- attributiv..av.1
  attributsamling_1_N : N ; -- attributsamling..nn.1
  attributsats_1_N : N ; -- attributsats..nn.1
  atypi_1_N : N ; -- atypi..nn.1
  atypisk_1_A : A ; -- atypisk..av.1
  au_pair_flicka_1_N : N ; -- au-pair-flicka..nn.1
  au_pair_1_N : N ; -- au-pair..nn.1
  aubergin_1_N : N ; -- aubergin..nn.1
  aubergine_1_N : N ; -- aubergine..nn.1
  audiens_1_N : N ; -- audiens..nn.1
  audiensdag_1_N : N ; -- audiensdag..nn.1
  audienssal_1_N : N ; -- audienssal..nn.1
  audienssökande_1_N : N ; -- audienssökande..nn.1
  audiogram_1_N : N ; -- audiogram..nn.1
  audiologi_1_N : N ; -- audiologi..nn.1
  audiometer_1_N : N ; -- audiometer..nn.1
  audiovisuell_1_A : A ; -- audiovisuell..av.1
  audit_1_N : N ; -- audit..nn.1
  auditiv_1_A : A ; -- auditiv..av.1
  auditorium_1_N : N ; -- auditorium..nn.1
  auditör_1_N : N ; -- auditör..nn.1
  audivisuell_1_A : A ; -- audivisuell..av.1
  auerlampa_1_N : N ; -- auerlampa..nn.1
  auerstrumpa_1_N : N ; -- auerstrumpa..nn.1
  augiasstall_1_N : N ; -- augiasstall..nn.1
  augment_1_N : N ; -- augment..nn.1
  augur_1_N : N ; -- augur..nn.1
  augusti_1_N : N ; -- augusti..nn.1
  augustidag_1_N : N ; -- augustidag..nn.1
  augustimånsken_1_N : N ; -- augustimånsken..nn.1
  augustinatt_1_N : N ; -- augustinatt..nn.1
  augustipäron_1_N : N ; -- augustipäron..nn.1
  augustisol_1_N : N ; -- augustisol..nn.1
  augustnominerad_1_A : A ; -- augustnominerad..av.1
  auktion_1_N : N ; -- auktion..nn.1
  auktionera_1_V : V ; -- auktionera..vb.1
  auktionerande_1_N : N ; -- auktionerande..nn.1
  auktionerare_1_N : N ; -- auktionerare..nn.1
  auktionerbar_1_A : A ; -- auktionerbar..av.1
  auktionerbarhet_1_N : N ; -- auktionerbarhet..nn.1
  auktionering_1_N : N ; -- auktionering..nn.1
  auktionist_1_N : N ; -- auktionist..nn.1
  auktionsbridge_1_N : N ; -- auktionsbridge..nn.1
  auktionsdag_1_N : N ; -- auktionsdag..nn.1
  auktionsförrättare_1_N : N ; -- auktionsförrättare..nn.1
  auktionsinrop_1_N : N ; -- auktionsinrop..nn.1
  auktionskammare_1_N : N ; -- auktionskammare..nn.1
  auktionsklubba_1_N : N ; -- auktionsklubba..nn.1
  auktionsprotokoll_1_N : N ; -- auktionsprotokoll..nn.1
  auktionsutropare_1_N : N ; -- auktionsutropare..nn.1
  auktionsverk_1_N : N ; -- auktionsverk..nn.1
  auktor_1_N : N ; -- auktor..nn.1
  auktorisation_1_N : N ; -- auktorisation..nn.1
  auktorisera_1_V : V ; -- auktorisera..vb.1
  auktoriserande_1_N : N ; -- auktoriserande..nn.1
  auktoriserbar_1_A : A ; -- auktoriserbar..av.1
  auktoriserbarhet_1_N : N ; -- auktoriserbarhet..nn.1
  auktorisering_1_N : N ; -- auktorisering..nn.1
  auktoritativ_1_A : A ; -- auktoritativ..av.1
  auktoritet_1_N : N ; -- auktoritet..nn.1
  auktoritetsbunden_1_A : A ; -- auktoritetsbunden..av.1
  auktoritetsbundenhet_1_N : N ; -- auktoritetsbundenhet..nn.1
  auktoritetstro_1_N : N ; -- auktoritetstro..nn.1
  auktoritär_1_A : A ; -- auktoritär..av.1
  auktorrätt_1_N : N ; -- auktorrätt..nn.1
  auktorskap_1_N : N ; -- auktorskap..nn.1
  auktorsrätt_1_N : N ; -- auktorsrätt..nn.1
  aula_1_N : N ; -- aula..nn.1
  aura_1_N : N ; -- aura..nn.1
  auramigrän_1_N : N ; -- auramigrän..nn.1
  auskultant_1_N : N ; -- auskultant..nn.1
  auskultation_1_N : N ; -- auskultation..nn.1
  auskultera_1_V : V ; -- auskultera..vb.1
  auskulterande_1_N : N ; -- auskulterande..nn.1
  auskulterbar_1_A : A ; -- auskulterbar..av.1
  auskulterbarhet_1_N : N ; -- auskulterbarhet..nn.1
  auskultering_1_N : N ; -- auskultering..nn.1
  australiensare_1_N : N ; -- australiensare..nn.1
  australiensisk_1_A : A ; -- australiensisk..av.1
  australier_1_N : N ; -- australier..nn.1
  australisk_1_A : A ; -- australisk..av.1
  australiska_1_N : N ; -- australiska..nn.1
  autarki_1_N : N ; -- autarki..nn.1
  autencitet_1_N : N ; -- autencitet..nn.1
  autenticera_1_V : V ; -- autenticera..vb.1
  autenticerande_1_N : N ; -- autenticerande..nn.1
  autenticerbar_1_A : A ; -- autenticerbar..av.1
  autenticerbarhet_1_N : N ; -- autenticerbarhet..nn.1
  autenticering_1_N : N ; -- autenticering..nn.1
  autenticitet_1_N : N ; -- autenticitet..nn.1
  autentifiera_1_V : V ; -- autentifiera..vb.1
  autentifierande_1_N : N ; -- autentifierande..nn.1
  autentifierbar_1_A : A ; -- autentifierbar..av.1
  autentifierbarhet_1_N : N ; -- autentifierbarhet..nn.1
  autentifiering_1_N : N ; -- autentifiering..nn.1
  autentisera_1_V : V ; -- autentisera..vb.1
  autentiserande_1_N : N ; -- autentiserande..nn.1
  autentiserbar_1_A : A ; -- autentiserbar..av.1
  autentiserbarhet_1_N : N ; -- autentiserbarhet..nn.1
  autentisering_1_N : N ; -- autentisering..nn.1
  autentisk_1_A : A ; -- autentisk..av.1
  auteur_1_N : N ; -- auteur..nn.1
  autism_1_N : N ; -- autism..nn.1
  autist_1_N : N ; -- autist..nn.1
  autistisk_1_A : A ; -- autistisk..av.1
  auto_PEEP_1_N : N ; -- auto-PEEP..nn.1
  autodafé_1_N : N ; -- autodafé..nn.1
  autodidakt_1_N : N ; -- autodidakt..nn.1
  autodigestion_1_N : N ; -- autodigestion..nn.1
  autodrom_1_N : N ; -- autodrom..nn.1
  autograf_1_N : N ; -- autograf..nn.1
  autografjägare_1_N : N ; -- autografjägare..nn.1
  autografsamling_1_N : N ; -- autografsamling..nn.1
  autoimmun_1_A : A ; -- autoimmun..av.1
  autoklav_1_N : N ; -- autoklav..nn.1
  autokrat_1_N : N ; -- autokrat..nn.1
  autokrati_1_N : N ; -- autokrati..nn.1
  autokratisk_1_A : A ; -- autokratisk..av.1
  autokton_1_A : A ; -- autokton..av.1
  autolys_1_N : N ; -- autolys..nn.1
  automagisk_1_A : A ; -- automagisk..av.1
  automat_1_N : N ; -- automat..nn.1
  automatateori_1_N : N ; -- automatateori..nn.1
  automateld_1_N : N ; -- automateld..nn.1
  automatgevär_1_N : N ; -- automatgevär..nn.1
  automatik_1_N : N ; -- automatik..nn.1
  automation_1_N : N ; -- automation..nn.1
  automatisera_1_V : V ; -- automatisera..vb.1
  automatiserande_1_N : N ; -- automatiserande..nn.1
  automatiserbar_1_A : A ; -- automatiserbar..av.1
  automatiserbarhet_1_N : N ; -- automatiserbarhet..nn.1
  automatisering_1_N : N ; -- automatisering..nn.1
  automatisk_1_A : A ; -- automatisk..av.1
  automatkarbin_1_N : N ; -- automatkarbin..nn.1
  automatsäkring_1_N : N ; -- automatsäkring..nn.1
  automatteori_1_N : N ; -- automatteori..nn.1
  automatuttag_1_N : N ; -- automatuttag..nn.1
  automatvapen_1_N : N ; -- automatvapen..nn.1
  automobil_1_N : N ; -- automobil..nn.1
  autonom_1_A : A ; -- autonom..av.1
  autonomi_1_N : N ; -- autonomi..nn.1
  autopilot_1_N : N ; -- autopilot..nn.1
  autopsi_1_N : N ; -- autopsi..nn.1
  autostrada_1_N : N ; -- autostrada..nn.1
  autotypi_1_N : N ; -- autotypi..nn.1
  av_1_A : A ; -- av..av.1
  ava_1_N : N ; -- ava..nn.1
  ava_1_V : V ; -- ava..vb.1
  avaktivera_1_V : V ; -- avaktivera..vb.1
  avaktiverande_1_N : N ; -- avaktiverande..nn.1
  avaktiverbar_1_A : A ; -- avaktiverbar..av.1
  avaktiverbarhet_1_N : N ; -- avaktiverbarhet..nn.1
  avaktivering_1_N : N ; -- avaktivering..nn.1
  avancemang_1_N : N ; -- avancemang..nn.1
  avancera_1_V : V ; -- avancera..vb.1
  avancerad_1_A : A ; -- avancerad..av.1
  avancerande_1_N : N ; -- avancerande..nn.1
  avancerbar_1_A : A ; -- avancerbar..av.1
  avancerbarhet_1_N : N ; -- avancerbarhet..nn.1
  avancering_1_N : N ; -- avancering..nn.1
  avande_1_N : N ; -- avande..nn.1
  avannons_1_N : N ; -- avannons..nn.1
  avannonsera_1_V : V ; -- avannonsera..vb.1
  avannonserande_1_N : N ; -- avannonserande..nn.1
  avannonserbar_1_A : A ; -- avannonserbar..av.1
  avannonserbarhet_1_N : N ; -- avannonserbarhet..nn.1
  avannonsering_1_N : N ; -- avannonsering..nn.1
  avans_1_N : N ; -- avans..nn.1
  avantgarde_1_N : N ; -- avantgarde..nn.1
  avantgardism_1_N : N ; -- avantgardism..nn.1
  avantgardist_1_N : N ; -- avantgardist..nn.1
  avantgardistisk_1_A : A ; -- avantgardistisk..av.1
  avantloge_1_N : N ; -- avantloge..nn.1
  avantscen_1_N : N ; -- avantscen..nn.1
  avart_1_N : N ; -- avart..nn.1
  avatar_1_N : N ; -- avatar..nn.1
  avbalka_1_V : V ; -- avbalka..vb.1
  avbalkande_1_N : N ; -- avbalkande..nn.1
  avbalkning_1_N : N ; -- avbalkning..nn.1
  avbarka_1_V : V ; -- avbarka..vb.1
  avbarkning_1_N : N ; -- avbarkning..nn.1
  avbasning_1_N : N ; -- avbasning..nn.1
  avbeställa_1_V : V ; -- avbeställa..vb.1
  avbeställande_1_N : N ; -- avbeställande..nn.1
  avbeställning_1_N : N ; -- avbeställning..nn.1
  avbeta_1_V : V ; -- avbeta..vb.1
  avbetala_1_V : V ; -- avbetala..vb.1
  avbetalande_1_N : N ; -- avbetalande..nn.1
  avbetalning_1_N : N ; -- avbetalning..nn.1
  avbetalningsaffär_1_N : N ; -- avbetalningsaffär..nn.1
  avbetalningsarrangemang_1_N : N ; -- avbetalningsarrangemang..nn.1
  avbetalningsköp_1_N : N ; -- avbetalningsköp..nn.1
  avbetalningslån_1_N : N ; -- avbetalningslån..nn.1
  avbetalningsplan_1_N : N ; -- avbetalningsplan..nn.1
  avbetalningsvillkor_1_N : N ; -- avbetalningsvillkor..nn.1
  avbetande_1_N : N ; -- avbetande..nn.1
  avbetingning_1_N : N ; -- avbetingning..nn.1
  avbetning_1_N : N ; -- avbetning..nn.1
  avbetsling_1_N : N ; -- avbetsling..nn.1
  avbild_1_N : N ; -- avbild..nn.1
  avbilda_1_V : V ; -- avbilda..vb.1
  avbildande_1_N : N ; -- avbildande..nn.1
  avbildning_1_N : N ; -- avbildning..nn.1
  avbildningsfel_1_N : N ; -- avbildningsfel..nn.1
  avbinda_1_V : V ; -- avbinda..vb.1
  avbindande_1_N : N ; -- avbindande..nn.1
  avbindning_1_N : N ; -- avbindning..nn.1
  avbitare_1_N : N ; -- avbitare..nn.1
  avbitartång_1_N : N ; -- avbitartång..nn.1
  avbiten_1_A : A ; -- avbiten..av.1
  avbitning_1_N : N ; -- avbitning..nn.1
  avbländning_1_N : N ; -- avbländning..nn.1
  avblåsa_1_V : V ; -- avblåsa..vb.1
  avblåsande_1_N : N ; -- avblåsande..nn.1
  avblåsning_1_N : N ; -- avblåsning..nn.1
  avboka_1_V : V ; -- avboka..vb.1
  avbokande_1_N : N ; -- avbokande..nn.1
  avbokning_1_N : N ; -- avbokning..nn.1
  avborstning_1_N : N ; -- avborstning..nn.1
  avbrott_1_N : N ; -- avbrott..nn.1
  avbruten_1_A : A ; -- avbruten..av.1
  avbryta_1_V : V ; -- avbryta..vb.1
  avbrytande_1_N : N ; -- avbrytande..nn.1
  avbrytare_1_N : N ; -- avbrytare..nn.1
  avbrytning_1_N : N ; -- avbrytning..nn.1
  avbräck_1_N : N ; -- avbräck..nn.1
  avbränning_1_N : N ; -- avbränning..nn.1
  avbröstning_1_N : N ; -- avbröstning..nn.1
  avbytarbänk_1_N : N ; -- avbytarbänk..nn.1
  avbytare_1_N : N ; -- avbytare..nn.1
  avbäring_1_N : N ; -- avbäring..nn.1
  avbärning_1_N : N ; -- avbärning..nn.1
  avböja_1_V : V ; -- avböja..vb.1
  avböja_2_V : V ; -- avböja..vb.2
  avböjande_1_N : N ; -- avböjande..nn.1
  avböjning_1_N : N ; -- avböjning..nn.1
  avbön_1_N : N ; -- avbön..nn.1
  avbörda_1_V : V ; -- avbörda..vb.1
  avbördande_1_N : N ; -- avbördande..nn.1
  avdagata_1_V : V ; -- avdagata..vb.1
  avdagatagande_1_N : N ; -- avdagatagande..nn.1
  avdamning_1_N : N ; -- avdamning..nn.1
  avdankad_1_A : A ; -- avdankad..av.1
  avdela_1_V : V ; -- avdela..vb.1
  avdelande_1_N : N ; -- avdelande..nn.1
  avdelning_1_N : N ; -- avdelning..nn.1
  avdelningschef_1_N : N ; -- avdelningschef..nn.1
  avdelningsdirektör_1_N : N ; -- avdelningsdirektör..nn.1
  avdelningskontor_1_N : N ; -- avdelningskontor..nn.1
  avdelningsläkare_1_N : N ; -- avdelningsläkare..nn.1
  avdelningssköterska_1_N : N ; -- avdelningssköterska..nn.1
  avdelningsvis_1_Adv : Adv ; -- avdelningsvis..ab.1
  avdikning_1_N : N ; -- avdikning..nn.1
  avdiskning_1_N : N ; -- avdiskning..nn.1
  avdomning_1_N : N ; -- avdomning..nn.1
  avdrag_1_N : N ; -- avdrag..nn.1
  avdragsgill_1_A : A ; -- avdragsgill..av.1
  avdragsglad_1_A : A ; -- avdragsglad..av.1
  avdragsmöjlighet_1_N : N ; -- avdragsmöjlighet..nn.1
  avdragsrätt_1_N : N ; -- avdragsrätt..nn.1
  avdramatisera_1_V : V ; -- avdramatisera..vb.1
  avdramatiserande_1_N : N ; -- avdramatiserande..nn.1
  avdramatiserbar_1_A : A ; -- avdramatiserbar..av.1
  avdramatiserbarhet_1_N : N ; -- avdramatiserbarhet..nn.1
  avdramatisering_1_N : N ; -- avdramatisering..nn.1
  avdrift_1_N : N ; -- avdrift..nn.1
  avdriva_1_V : V ; -- avdriva..vb.1
  avdrivande_1_N : N ; -- avdrivande..nn.1
  avdukning_1_N : N ; -- avdukning..nn.1
  avdunsta_1_V : V ; -- avdunsta..vb.1
  avdunstande_1_N : N ; -- avdunstande..nn.1
  avdunstning_1_N : N ; -- avdunstning..nn.1
  avdämma_1_V : V ; -- avdämma..vb.1
  avdämmande_1_N : N ; -- avdämmande..nn.1
  avdämning_1_N : N ; -- avdämning..nn.1
  avdöd_1_A : A ; -- avdöd..av.1
  avdöma_1_V : V ; -- avdöma..vb.1
  avdömande_1_N : N ; -- avdömande..nn.1
  ave_1_N : N ; -- ave..nn.1
  avec_1_N : N ; -- avec..nn.1
  avel_1_N : N ; -- avel..nn.1
  avelsdjur_1_N : N ; -- avelsdjur..nn.1
  avelsduglig_1_A : A ; -- avelsduglig..av.1
  avelshingst_1_N : N ; -- avelshingst..nn.1
  avelssto_1_N : N ; -- avelssto..nn.1
  avenbok_1_N : N ; -- avenbok..nn.1
  aveny_1_N : N ; -- aveny..nn.1
  avers_1_N : N ; -- avers..nn.1
  aversion_1_N : N ; -- aversion..nn.1
  aversionsterapi_1_N : N ; -- aversionsterapi..nn.1
  avfall_1_N : N ; -- avfall..nn.1
  avfalla_1_V : V ; -- avfalla..vb.1
  avfallande_1_N : N ; -- avfallande..nn.1
  avfallen_1_A : A ; -- avfallen..av.1
  avfallsbrunn_1_N : N ; -- avfallsbrunn..nn.1
  avfallsdike_1_N : N ; -- avfallsdike..nn.1
  avfallsfoder_1_N : N ; -- avfallsfoder..nn.1
  avfallshantering_1_N : N ; -- avfallshantering..nn.1
  avfallskvarn_1_N : N ; -- avfallskvarn..nn.1
  avfallsråvara_1_N : N ; -- avfallsråvara..nn.1
  avfallsupplag_1_N : N ; -- avfallsupplag..nn.1
  avfallsvatten_1_N : N ; -- avfallsvatten..nn.1
  avfallsvirke_1_N : N ; -- avfallsvirke..nn.1
  avfalsning_1_N : N ; -- avfalsning..nn.1
  avfart_1_N : N ; -- avfart..nn.1
  avfasning_1_N : N ; -- avfasning..nn.1
  avfatta_1_V : V ; -- avfatta..vb.1
  avfattande_1_N : N ; -- avfattande..nn.1
  avfattning_1_N : N ; -- avfattning..nn.1
  avfejning_1_N : N ; -- avfejning..nn.1
  avfetta_1_V : V ; -- avfetta..vb.1
  avfettande_1_N : N ; -- avfettande..nn.1
  avfettning_1_N : N ; -- avfettning..nn.1
  avfettningsmedel_1_N : N ; -- avfettningsmedel..nn.1
  avfilning_1_N : N ; -- avfilning..nn.1
  avfiltrering_1_N : N ; -- avfiltrering..nn.1
  avfjällning_1_N : N ; -- avfjällning..nn.1
  avflagnad_1_A : A ; -- avflagnad..av.1
  avflytta_1_V : V ; -- avflytta..vb.1
  avflyttande_1_N : N ; -- avflyttande..nn.1
  avflyttning_1_N : N ; -- avflyttning..nn.1
  avflyttningsförbud_1_N : N ; -- avflyttningsförbud..nn.1
  avflöde_1_N : N ; -- avflöde..nn.1
  avfolka_1_V : V ; -- avfolka..vb.1
  avfolkande_1_N : N ; -- avfolkande..nn.1
  avfolkning_1_N : N ; -- avfolkning..nn.1
  avfolkningsområde_1_N : N ; -- avfolkningsområde..nn.1
  avfordra_1_V : V ; -- avfordra..vb.1
  avfordrande_1_N : N ; -- avfordrande..nn.1
  avforsling_1_N : N ; -- avforsling..nn.1
  avfrosta_1_V : V ; -- avfrosta..vb.1
  avfrostande_1_N : N ; -- avfrostande..nn.1
  avfrostning_1_N : N ; -- avfrostning..nn.1
  avfukta_1_V : V ; -- avfukta..vb.1
  avfuktande_1_N : N ; -- avfuktande..nn.1
  avfuktare_1_N : N ; -- avfuktare..nn.1
  avfyra_1_V : V ; -- avfyra..vb.1
  avfyrande_1_N : N ; -- avfyrande..nn.1
  avfyrning_1_N : N ; -- avfyrning..nn.1
  avfyrningskod_1_N : N ; -- avfyrningskod..nn.1
  avfyrningsprocedur_1_N : N ; -- avfyrningsprocedur..nn.1
  avfällig_1_A : A ; -- avfällig..av.1
  avfällighet_1_N : N ; -- avfällighet..nn.1
  avfälling_1_N : N ; -- avfälling..nn.1
  avfärd_1_N : N ; -- avfärd..nn.1
  avfärda_1_V : V ; -- avfärda..vb.1
  avfärdande_1_N : N ; -- avfärdande..nn.1
  avfärgning_1_N : N ; -- avfärgning..nn.1
  avföda_1_N : N ; -- avföda..nn.1
  avföra_1_V : V ; -- avföra..vb.1
  avförande_1_N : N ; -- avförande..nn.1
  avföring_1_N : N ; -- avföring..nn.1
  avföringsinkontinens_1_N : N ; -- avföringsinkontinens..nn.1
  avföringsmedel_1_N : N ; -- avföringsmedel..nn.1
  avföringstransplantat_1_N : N ; -- avföringstransplantat..nn.1
  avföringstransplantation_1_N : N ; -- avföringstransplantation..nn.1
  avgasförgiftning_1_N : N ; -- avgasförgiftning..nn.1
  avgasrening_1_N : N ; -- avgasrening..nn.1
  avgasrör_1_N : N ; -- avgasrör..nn.1
  avge_1_V : V ; -- avge..vb.1
  avgift_1_N : N ; -- avgift..nn.1
  avgifta_1_V : V ; -- avgifta..vb.1
  avgiftande_1_N : N ; -- avgiftande..nn.1
  avgiftning_1_N : N ; -- avgiftning..nn.1
  avgiftningsklinik_1_N : N ; -- avgiftningsklinik..nn.1
  avgiftsbelägga_1_V : V ; -- avgiftsbelägga..vb.1
  avgiftsbeläggande_1_N : N ; -- avgiftsbeläggande..nn.1
  avgiftsfri_1_A : A ; -- avgiftsfri..av.1
  avgiftsfrihet_1_N : N ; -- avgiftsfrihet..nn.1
  avgivande_1_N : N ; -- avgivande..nn.1
  avgjord_1_A : A ; -- avgjord..av.1
  avgjutning_1_N : N ; -- avgjutning..nn.1
  avglans_1_N : N ; -- avglans..nn.1
  avgnagning_1_N : N ; -- avgnagning..nn.1
  avgnuggning_1_N : N ; -- avgnuggning..nn.1
  avgrena_1_V : V ; -- avgrena..vb.1
  avgrenande_1_N : N ; -- avgrenande..nn.1
  avgrening_1_N : N ; -- avgrening..nn.1
  avgrund_1_N : N ; -- avgrund..nn.1
  avgrundsande_1_N : N ; -- avgrundsande..nn.1
  avgrundsdjup_1_A : A ; -- avgrundsdjup..av.1
  avgrundsdjup_1_N : N ; -- avgrundsdjup..nn.1
  avgrundseld_1_N : N ; -- avgrundseld..nn.1
  avgrundslik_1_A : A ; -- avgrundslik..av.1
  avgrundsrand_1_N : N ; -- avgrundsrand..nn.1
  avgrundsskara_1_N : N ; -- avgrundsskara..nn.1
  avgränsa_1_V : V ; -- avgränsa..vb.1
  avgränsande_1_N : N ; -- avgränsande..nn.1
  avgränsning_1_N : N ; -- avgränsning..nn.1
  avgud_1_N : N ; -- avgud..nn.1
  avguda_1_V : V ; -- avguda..vb.1
  avgudabild_1_N : N ; -- avgudabild..nn.1
  avgudadyrkare_1_N : N ; -- avgudadyrkare..nn.1
  avgudande_1_N : N ; -- avgudande..nn.1
  avguderi_1_N : N ; -- avguderi..nn.1
  avgäld_1_N : N ; -- avgäld..nn.1
  avgärda_1_V : V ; -- avgärda..vb.1
  avgärdande_1_N : N ; -- avgärdande..nn.1
  avgärdning_1_N : N ; -- avgärdning..nn.1
  avgå_1_V : V ; -- avgå..vb.1
  avgående_1_N : N ; -- avgående..nn.1
  avgång_1_N : N ; -- avgång..nn.1
  avgångsbetyg_1_N : N ; -- avgångsbetyg..nn.1
  avgångsbidrag_1_N : N ; -- avgångsbidrag..nn.1
  avgångsersättning_1_N : N ; -- avgångsersättning..nn.1
  avgångshall_1_N : N ; -- avgångshall..nn.1
  avgångsklass_1_N : N ; -- avgångsklass..nn.1
  avgångskrav_1_N : N ; -- avgångskrav..nn.1
  avgångssignal_1_N : N ; -- avgångssignal..nn.1
  avgångstid_1_N : N ; -- avgångstid..nn.1
  avgångsvederlag_1_N : N ; -- avgångsvederlag..nn.1
  avgöra_1_V : V ; -- avgöra..vb.1
  avgörande_1_A : A ; -- avgörande..av.1
  avgörande_1_N : N ; -- avgörande..nn.1
  avhackning_1_N : N ; -- avhackning..nn.1
  avhakning_1_N : N ; -- avhakning..nn.1
  avhandla_1_V : V ; -- avhandla..vb.1
  avhandlande_1_N : N ; -- avhandlande..nn.1
  avhandling_1_N : N ; -- avhandling..nn.1
  avhaspling_1_N : N ; -- avhaspling..nn.1
  avhjälpa_1_V : V ; -- avhjälpa..vb.1
  avhjälpande_1_N : N ; -- avhjälpande..nn.1
  avhopp_1_N : N ; -- avhopp..nn.1
  avhoppad_1_A : A ; -- avhoppad..av.1
  avhoppare_1_N : N ; -- avhoppare..nn.1
  avhorna_1_V : V ; -- avhorna..vb.1
  avhornande_1_N : N ; -- avhornande..nn.1
  avhorning_1_N : N ; -- avhorning..nn.1
  avhuggning_1_N : N ; -- avhuggning..nn.1
  avhumanisera_1_V : V ; -- avhumanisera..vb.1
  avhumaniserande_1_N : N ; -- avhumaniserande..nn.1
  avhumanisering_1_N : N ; -- avhumanisering..nn.1
  avhysa_1_V : V ; -- avhysa..vb.1
  avhysande_1_N : N ; -- avhysande..nn.1
  avhysning_1_N : N ; -- avhysning..nn.1
  avhyvling_1_N : N ; -- avhyvling..nn.1
  avhäktning_1_N : N ; -- avhäktning..nn.1
  avhällning_1_N : N ; -- avhällning..nn.1
  avhällningsöppning_1_N : N ; -- avhällningsöppning..nn.1
  avhämta_1_V : V ; -- avhämta..vb.1
  avhämtande_1_N : N ; -- avhämtande..nn.1
  avhämtning_1_N : N ; -- avhämtning..nn.1
  avhända_1_V : V ; -- avhända..vb.1
  avhändande_1_N : N ; -- avhändande..nn.1
  avhändbar_1_A : A ; -- avhändbar..av.1
  avhändbarhet_1_N : N ; -- avhändbarhet..nn.1
  avhänga_1_V : V ; -- avhänga..vb.1
  avhängande_1_N : N ; -- avhängande..nn.1
  avhängd_1_A : A ; -- avhängd..av.1
  avhängig_1_A : A ; -- avhängig..av.1
  avhängighet_1_N : N ; -- avhängighet..nn.1
  avhärda_1_V : V ; -- avhärda..vb.1
  avhärdande_1_N : N ; -- avhärdande..nn.1
  avhästning_1_N : N ; -- avhästning..nn.1
  avhåll_1_N : N ; -- avhåll..nn.1
  avhålla_1_V : V ; -- avhålla..vb.1
  avhållande_1_N : N ; -- avhållande..nn.1
  avhållen_1_A : A ; -- avhållen..av.1
  avhållsam_1_A : A ; -- avhållsam..av.1
  avhållsamhet_1_N : N ; -- avhållsamhet..nn.1
  avhöra_1_V : V ; -- avhöra..vb.1
  avhörande_1_N : N ; -- avhörande..nn.1
  avhösta_1_V : V ; -- avhösta..vb.1
  avhöstande_1_N : N ; -- avhöstande..nn.1
  avi_1_N : N ; -- avi..nn.1
  aviarium_1_N : N ; -- aviarium..nn.1
  aviatik_1_N : N ; -- aviatik..nn.1
  aviatiker_1_N : N ; -- aviatiker..nn.1
  aviatisk_1_A : A ; -- aviatisk..av.1
  aviatör_1_N : N ; -- aviatör..nn.1
  avig_1_A : A ; -- avig..av.1
  aviga_1_N : N ; -- aviga..nn.1
  avigsida_1_N : N ; -- avigsida..nn.1
  avindividualisera_1_V : V ; -- avindividualisera..vb.1
  avindividualiserande_1_N : N ; -- avindividualiserande..nn.1
  avindividualisering_1_N : N ; -- avindividualisering..nn.1
  avinstallera_1_V : V ; -- avinstallera..vb.1
  avinstallerande_1_N : N ; -- avinstallerande..nn.1
  avinstallerbar_1_A : A ; -- avinstallerbar..av.1
  avinstallering_1_N : N ; -- avinstallering..nn.1
  avintellektualisera_1_V : V ; -- avintellektualisera..vb.1
  avintellektualiserande_1_N : N ; -- avintellektualiserande..nn.1
  avintellektualiserbar_1_A : A ; -- avintellektualiserbar..av.1
  avintellektualisering_1_N : N ; -- avintellektualisering..nn.1
  avis_1_N : N ; -- avis..nn.1
  avisa_1_N : N ; -- avisa..nn.1
  avisa_1_V : V ; -- avisa..vb.1
  avisande_1_N : N ; -- avisande..nn.1
  avisera_1_V : V ; -- avisera..vb.1
  aviserande_1_N : N ; -- aviserande..nn.1
  aviserbar_1_A : A ; -- aviserbar..av.1
  aviserbarhet_1_N : N ; -- aviserbarhet..nn.1
  avisering_1_N : N ; -- avisering..nn.1
  aviseringsperiod_1_N : N ; -- aviseringsperiod..nn.1
  avisning_1_N : N ; -- avisning..nn.1
  avisningsanläggning_1_N : N ; -- avisningsanläggning..nn.1
  avisofartyg_1_N : N ; -- avisofartyg..nn.1
  avitaminos_1_N : N ; -- avitaminos..nn.1
  avjaga_1_V : V ; -- avjaga..vb.1
  avjagande_1_N : N ; -- avjagande..nn.1
  avjämna_1_V : V ; -- avjämna..vb.1
  avjämnande_1_N : N ; -- avjämnande..nn.1
  avjämning_1_N : N ; -- avjämning..nn.1
  avkalka_1_V : V ; -- avkalka..vb.1
  avkalkande_1_N : N ; -- avkalkande..nn.1
  avkapning_1_N : N ; -- avkapning..nn.1
  avkasta_1_V : V ; -- avkasta..vb.1
  avkastande_1_N : N ; -- avkastande..nn.1
  avkastning_1_N : N ; -- avkastning..nn.1
  avkastningskrav_1_N : N ; -- avkastningskrav..nn.1
  avklappning_1_N : N ; -- avklappning..nn.1
  avklara_1_V : V ; -- avklara..vb.1
  avklara_2_V : V ; -- avklara..vb.2
  avklarande_1_N : N ; -- avklarande..nn.1
  avklarnad_1_A : A ; -- avklarnad..av.1
  avklinga_1_V : V ; -- avklinga..vb.1
  avklingande_1_N : N ; -- avklingande..nn.1
  avklippning_1_N : N ; -- avklippning..nn.1
  avklä_1_V : V ; -- avklä..vb.1
  avklädande_1_N : N ; -- avklädande..nn.1
  avklädning_1_N : N ; -- avklädning..nn.1
  avknackning_1_N : N ; -- avknackning..nn.1
  avknipning_1_N : N ; -- avknipning..nn.1
  avknoppa_1_V : V ; -- avknoppa..vb.1
  avknoppande_1_N : N ; -- avknoppande..nn.1
  avknoppning_1_N : N ; -- avknoppning..nn.1
  avknoppningsföretag_1_N : N ; -- avknoppningsföretag..nn.1
  avknäppning_1_N : N ; -- avknäppning..nn.1
  avkoda_1_V : V ; -- avkoda..vb.1
  avkok_1_N : N ; -- avkok..nn.1
  avkokning_1_N : N ; -- avkokning..nn.1
  avkolonisera_1_V : V ; -- avkolonisera..vb.1
  avkoloniserande_1_N : N ; -- avkoloniserande..nn.1
  avkoloniserbar_1_A : A ; -- avkoloniserbar..av.1
  avkoloniserbarhet_1_N : N ; -- avkoloniserbarhet..nn.1
  avkolonisering_1_N : N ; -- avkolonisering..nn.1
  avkomling_1_N : N ; -- avkomling..nn.1
  avkomma_1_N : N ; -- avkomma..nn.1
  avkomst_1_N : N ; -- avkomst..nn.1
  avkomsträtt_1_N : N ; -- avkomsträtt..nn.1
  avkoppla_1_V : V ; -- avkoppla..vb.1
  avkopplande_1_N : N ; -- avkopplande..nn.1
  avkoppling_1_N : N ; -- avkoppling..nn.1
  avkorta_1_V : V ; -- avkorta..vb.1
  avkortande_1_N : N ; -- avkortande..nn.1
  avkortning_1_N : N ; -- avkortning..nn.1
  avkrattning_1_N : N ; -- avkrattning..nn.1
  avkriminalisera_1_V : V ; -- avkriminalisera..vb.1
  avkriminaliserande_1_N : N ; -- avkriminaliserande..nn.1
  avkriminaliserbar_1_A : A ; -- avkriminaliserbar..av.1
  avkriminaliserbarhet_1_N : N ; -- avkriminaliserbarhet..nn.1
  avkriminalisering_1_N : N ; -- avkriminalisering..nn.1
  avkristna_1_V : V ; -- avkristna..vb.1
  avkristnande_1_N : N ; -- avkristnande..nn.1
  avkristning_1_N : N ; -- avkristning..nn.1
  avkrok_1_N : N ; -- avkrok..nn.1
  avkrokning_1_N : N ; -- avkrokning..nn.1
  avkrängning_1_N : N ; -- avkrängning..nn.1
  avkräva_1_V : V ; -- avkräva..vb.1
  avkrävande_1_N : N ; -- avkrävande..nn.1
  avkrävning_1_N : N ; -- avkrävning..nn.1
  avkunna_1_V : V ; -- avkunna..vb.1
  avkunnande_1_N : N ; -- avkunnande..nn.1
  avkvistning_1_N : N ; -- avkvistning..nn.1
  avkyla_1_V : V ; -- avkyla..vb.1
  avkylare_1_N : N ; -- avkylare..nn.1
  avkylning_1_N : N ; -- avkylning..nn.1
  avkänna_1_V : V ; -- avkänna..vb.1
  avkännare_1_N : N ; -- avkännare..nn.1
  avkänning_1_N : N ; -- avkänning..nn.1
  avkänningssystem_1_N : N ; -- avkänningssystem..nn.1
  avköna_1_V : V ; -- avköna..vb.1
  avkönande_1_N : N ; -- avkönande..nn.1
  avkörningsramp_1_N : N ; -- avkörningsramp..nn.1
  avla_1_V : V ; -- avla..vb.1
  avlagd_1_A : A ; -- avlagd..av.1
  avlagra_1_V : V ; -- avlagra..vb.1
  avlagrande_1_N : N ; -- avlagrande..nn.1
  avlagring_1_N : N ; -- avlagring..nn.1
  avlande_1_N : N ; -- avlande..nn.1
  avlassning_1_N : N ; -- avlassning..nn.1
  avlasta_1_V : V ; -- avlasta..vb.1
  avlastande_1_N : N ; -- avlastande..nn.1
  avlastare_1_N : N ; -- avlastare..nn.1
  avlastning_1_N : N ; -- avlastning..nn.1
  avlastningsort_1_N : N ; -- avlastningsort..nn.1
  avlastningsplats_1_N : N ; -- avlastningsplats..nn.1
  avlat_1_N : N ; -- avlat..nn.1
  avlatsbrev_1_N : N ; -- avlatsbrev..nn.1
  avleda_1_V : V ; -- avleda..vb.1
  avledande_1_N : N ; -- avledande..nn.1
  avledare_1_N : N ; -- avledare..nn.1
  avledning_1_N : N ; -- avledning..nn.1
  avledningsdike_1_N : N ; -- avledningsdike..nn.1
  avledningsrör_1_N : N ; -- avledningsrör..nn.1
  avledningsändelse_1_N : N ; -- avledningsändelse..nn.1
  avlelse_1_N : N ; -- avlelse..nn.1
  avleverera_1_V : V ; -- avleverera..vb.1
  avleverering_1_N : N ; -- avleverering..nn.1
  avlida_1_V : V ; -- avlida..vb.1
  avlidande_1_N : N ; -- avlidande..nn.1
  avliden_1_A : A ; -- avliden..av.1
  avlindning_1_N : N ; -- avlindning..nn.1
  avling_1_N : N ; -- avling..nn.1
  avlinge_1_N : N ; -- avlinge..nn.1
  avliva_1_V : V ; -- avliva..vb.1
  avlivande_1_N : N ; -- avlivande..nn.1
  avljud_1_N : N ; -- avljud..nn.1
  avljudsvokal_1_N : N ; -- avljudsvokal..nn.1
  avlocka_1_V : V ; -- avlocka..vb.1
  avlockande_1_N : N ; -- avlockande..nn.1
  avlopp_1_N : N ; -- avlopp..nn.1
  avloppsbrunn_1_N : N ; -- avloppsbrunn..nn.1
  avloppsdike_1_N : N ; -- avloppsdike..nn.1
  avloppskanal_1_N : N ; -- avloppskanal..nn.1
  avloppsledning_1_N : N ; -- avloppsledning..nn.1
  avloppsledningsrör_1_N : N ; -- avloppsledningsrör..nn.1
  avloppsrensare_1_N : N ; -- avloppsrensare..nn.1
  avloppsrensning_1_N : N ; -- avloppsrensning..nn.1
  avloppsrensningsslang_1_N : N ; -- avloppsrensningsslang..nn.1
  avloppsränna_1_N : N ; -- avloppsränna..nn.1
  avloppsrör_1_N : N ; -- avloppsrör..nn.1
  avloppssystem_1_N : N ; -- avloppssystem..nn.1
  avloppstrumma_1_N : N ; -- avloppstrumma..nn.1
  avloppsvatten_1_N : N ; -- avloppsvatten..nn.1
  avlossa_1_V : V ; -- avlossa..vb.1
  avlossande_1_N : N ; -- avlossande..nn.1
  avlusa_1_V : V ; -- avlusa..vb.1
  avlusande_1_N : N ; -- avlusande..nn.1
  avlusning_1_N : N ; -- avlusning..nn.1
  avlusningsmedel_1_N : N ; -- avlusningsmedel..nn.1
  avluta_1_V : V ; -- avluta..vb.1
  avlutande_1_N : N ; -- avlutande..nn.1
  avlysa_1_V : V ; -- avlysa..vb.1
  avlysande_1_N : N ; -- avlysande..nn.1
  avlysning_1_N : N ; -- avlysning..nn.1
  avlyssna_1_V : V ; -- avlyssna..vb.1
  avlyssnande_1_N : N ; -- avlyssnande..nn.1
  avlyssning_1_N : N ; -- avlyssning..nn.1
  avlyssningsapparatur_1_N : N ; -- avlyssningsapparatur..nn.1
  avlyssningshärva_1_N : N ; -- avlyssningshärva..nn.1
  avlyssningsskandal_1_N : N ; -- avlyssningsskandal..nn.1
  avlyssningsutrustning_1_N : N ; -- avlyssningsutrustning..nn.1
  avlägga_1_V : V ; -- avlägga..vb.1
  avläggande_1_N : N ; -- avläggande..nn.1
  avläggare_1_N : N ; -- avläggare..nn.1
  avläggning_1_N : N ; -- avläggning..nn.1
  avlägsen_1_A : A ; -- avlägsen..av.1
  avlägsenhet_1_N : N ; -- avlägsenhet..nn.1
  avlägsna_1_V : V ; -- avlägsna..vb.1
  avlägsnande_1_N : N ; -- avlägsnande..nn.1
  avlämna_1_V : V ; -- avlämna..vb.1
  avlämnande_1_N : N ; -- avlämnande..nn.1
  avlämning_1_N : N ; -- avlämning..nn.1
  avlänka_1_V : V ; -- avlänka..vb.1
  avlänkande_1_N : N ; -- avlänkande..nn.1
  avläsa_1_V : V ; -- avläsa..vb.1
  avläsande_1_N : N ; -- avläsande..nn.1
  avläsare_1_N : N ; -- avläsare..nn.1
  avläsbar_1_A : A ; -- avläsbar..av.1
  avläsbarhet_1_N : N ; -- avläsbarhet..nn.1
  avläsning_1_N : N ; -- avläsning..nn.1
  avlång_1_A : A ; -- avlång..av.1
  avlånghet_1_N : N ; -- avlånghet..nn.1
  avlåta_1_V : V ; -- avlåta..vb.1
  avlåtande_1_N : N ; -- avlåtande..nn.1
  avlöna_1_V : V ; -- avlöna..vb.1
  avlönande_1_N : N ; -- avlönande..nn.1
  avlöning_1_N : N ; -- avlöning..nn.1
  avlöpa_1_V : V ; -- avlöpa..vb.1
  avlöpande_1_N : N ; -- avlöpande..nn.1
  avlöpning_1_N : N ; -- avlöpning..nn.1
  avlösa_1_V : V ; -- avlösa..vb.1
  avlösande_1_N : N ; -- avlösande..nn.1
  avlösning_1_N : N ; -- avlösning..nn.1
  avlöva_1_V : V ; -- avlöva..vb.1
  avlövande_1_N : N ; -- avlövande..nn.1
  avlövning_1_N : N ; -- avlövning..nn.1
  avlövningsmedel_1_N : N ; -- avlövningsmedel..nn.1
  avmagnetisera_1_V : V ; -- avmagnetisera..vb.1
  avmagnetiserande_1_N : N ; -- avmagnetiserande..nn.1
  avmagnetiserbar_1_A : A ; -- avmagnetiserbar..av.1
  avmagnetiserbarhet_1_N : N ; -- avmagnetiserbarhet..nn.1
  avmagnetisering_1_N : N ; -- avmagnetisering..nn.1
  avmagnetiseringsprocess_1_N : N ; -- avmagnetiseringsprocess..nn.1
  avmagrad_1_A : A ; -- avmagrad..av.1
  avmagring_1_N : N ; -- avmagring..nn.1
  avmarsch_1_N : N ; -- avmarsch..nn.1
  avmaska_1_V : V ; -- avmaska..vb.1
  avmaskande_1_N : N ; -- avmaskande..nn.1
  avmaskning_1_N : N ; -- avmaskning..nn.1
  avmaskningskur_1_N : N ; -- avmaskningskur..nn.1
  avmasta_1_V : V ; -- avmasta..vb.1
  avmastande_1_N : N ; -- avmastande..nn.1
  avmatta_1_V : V ; -- avmatta..vb.1
  avmattande_1_N : N ; -- avmattande..nn.1
  avmattning_1_N : N ; -- avmattning..nn.1
  avmattningsperiod_1_N : N ; -- avmattningsperiod..nn.1
  avmejning_1_N : N ; -- avmejning..nn.1
  avmejsling_1_N : N ; -- avmejsling..nn.1
  avmystifiera_1_V : V ; -- avmystifiera..vb.1
  avmystifierande_1_N : N ; -- avmystifierande..nn.1
  avmystifierbar_1_A : A ; -- avmystifierbar..av.1
  avmystifierbarhet_1_N : N ; -- avmystifierbarhet..nn.1
  avmystifiering_1_N : N ; -- avmystifiering..nn.1
  avmäta_1_V : V ; -- avmäta..vb.1
  avmätande_1_N : N ; -- avmätande..nn.1
  avmätning_1_N : N ; -- avmätning..nn.1
  avmätt_1_A : A ; -- avmätt..av.1
  avmätthet_1_N : N ; -- avmätthet..nn.1
  avmålning_1_N : N ; -- avmålning..nn.1
  avmönstra_1_V : V ; -- avmönstra..vb.1
  avmönstring_1_N : N ; -- avmönstring..nn.1
  avnavla_1_V : V ; -- avnavla..vb.1
  avnavlande_1_N : N ; -- avnavlande..nn.1
  avnazifiera_1_V : V ; -- avnazifiera..vb.1
  avnazifierande_1_N : N ; -- avnazifierande..nn.1
  avnazifierbar_1_A : A ; -- avnazifierbar..av.1
  avnazifierbarhet_1_N : N ; -- avnazifierbarhet..nn.1
  avnazifiering_1_N : N ; -- avnazifiering..nn.1
  avnjuta_1_V : V ; -- avnjuta..vb.1
  avnjutande_1_N : N ; -- avnjutande..nn.1
  avnypning_1_N : N ; -- avnypning..nn.1
  avnystning_1_N : N ; -- avnystning..nn.1
  avnämare_1_N : N ; -- avnämare..nn.1
  avnötning_1_N : N ; -- avnötning..nn.1
  avocado_1_N : N ; -- avocado..nn.1
  avocadosås_1_N : N ; -- avocadosås..nn.1
  avog_1_A : A ; -- avog..av.1
  avoghet_1_N : N ; -- avoghet..nn.1
  avokado_1_N : N ; -- avokado..nn.1
  avokadosås_1_N : N ; -- avokadosås..nn.1
  avpackning_1_N : N ; -- avpackning..nn.1
  avpassa_1_V : V ; -- avpassa..vb.1
  avpassande_1_N : N ; -- avpassande..nn.1
  avpassning_1_N : N ; -- avpassning..nn.1
  avpatrullera_1_V : V ; -- avpatrullera..vb.1
  avpatrullerande_1_N : N ; -- avpatrullerande..nn.1
  avpatrullerbar_1_A : A ; -- avpatrullerbar..av.1
  avpatrullerbarhet_1_N : N ; -- avpatrullerbarhet..nn.1
  avpatrullering_1_N : N ; -- avpatrullering..nn.1
  avpersonifiera_1_V : V ; -- avpersonifiera..vb.1
  avpersonifierande_1_N : N ; -- avpersonifierande..nn.1
  avpersonifiering_1_N : N ; -- avpersonifiering..nn.1
  avplana_1_V : V ; -- avplana..vb.1
  avplanande_1_N : N ; -- avplanande..nn.1
  avplaning_1_N : N ; -- avplaning..nn.1
  avplockning_1_N : N ; -- avplockning..nn.1
  avpolering_1_N : N ; -- avpolering..nn.1
  avpolitisera_1_V : V ; -- avpolitisera..vb.1
  avpolitiserande_1_N : N ; -- avpolitiserande..nn.1
  avpolitiserbar_1_A : A ; -- avpolitiserbar..av.1
  avpolitiserbarhet_1_N : N ; -- avpolitiserbarhet..nn.1
  avpolitisering_1_N : N ; -- avpolitisering..nn.1
  avpollettera_1_V : V ; -- avpollettera..vb.1
  avpolletterande_1_N : N ; -- avpolletterande..nn.1
  avpolletterbar_1_A : A ; -- avpolletterbar..av.1
  avpolletterbarhet_1_N : N ; -- avpolletterbarhet..nn.1
  avpollettering_1_N : N ; -- avpollettering..nn.1
  avporträttera_1_V : V ; -- avporträttera..vb.1
  avporträtterande_1_N : N ; -- avporträtterande..nn.1
  avporträtterbar_1_A : A ; -- avporträtterbar..av.1
  avporträtterbarhet_1_N : N ; -- avporträtterbarhet..nn.1
  avporträttering_1_N : N ; -- avporträttering..nn.1
  avpressa_1_V : V ; -- avpressa..vb.1
  avpressande_1_N : N ; -- avpressande..nn.1
  avprickning_1_N : N ; -- avprickning..nn.1
  avputsning_1_N : N ; -- avputsning..nn.1
  avrad_1_N : N ; -- avrad..nn.1
  avradikalisera_1_V : V ; -- avradikalisera..vb.1
  avradikaliserande_1_N : N ; -- avradikaliserande..nn.1
  avradikalisering_1_N : N ; -- avradikalisering..nn.1
  avrakad_1_A : A ; -- avrakad..av.1
  avreagera_1_V : V ; -- avreagera..vb.1
  avreagerande_1_N : N ; -- avreagerande..nn.1
  avreagerbar_1_A : A ; -- avreagerbar..av.1
  avreagerbarhet_1_N : N ; -- avreagerbarhet..nn.1
  avreagering_1_N : N ; -- avreagering..nn.1
  avreda_1_V : V ; -- avreda..vb.1
  avredande_1_N : N ; -- avredande..nn.1
  avredning_1_N : N ; -- avredning..nn.1
  avregistrera_1_V : V ; -- avregistrera..vb.1
  avregistrerande_1_N : N ; -- avregistrerande..nn.1
  avregistrerbar_1_A : A ; -- avregistrerbar..av.1
  avregistrerbarhet_1_N : N ; -- avregistrerbarhet..nn.1
  avregistrering_1_N : N ; -- avregistrering..nn.1
  avreglera_1_V : V ; -- avreglera..vb.1
  avreglerande_1_N : N ; -- avreglerande..nn.1
  avreglerbar_1_A : A ; -- avreglerbar..av.1
  avreglerbarhet_1_N : N ; -- avreglerbarhet..nn.1
  avreglering_1_N : N ; -- avreglering..nn.1
  avrens_1_N : N ; -- avrens..nn.1
  avrensning_1_N : N ; -- avrensning..nn.1
  avresa_1_N : N ; -- avresa..nn.1
  avresa_1_V : V ; -- avresa..vb.1
  avresande_1_N : N ; -- avresande..nn.1
  avringning_1_N : N ; -- avringning..nn.1
  avrinna_1_V : V ; -- avrinna..vb.1
  avrinnande_1_N : N ; -- avrinnande..nn.1
  avrinning_1_N : N ; -- avrinning..nn.1
  avritning_1_N : N ; -- avritning..nn.1
  avrivning_1_N : N ; -- avrivning..nn.1
  avromantisera_1_V : V ; -- avromantisera..vb.1
  avromantiserande_1_N : N ; -- avromantiserande..nn.1
  avromantiserbar_1_A : A ; -- avromantiserbar..av.1
  avromantiserbarhet_1_N : N ; -- avromantiserbarhet..nn.1
  avromantisering_1_N : N ; -- avromantisering..nn.1
  avrop_1_N : N ; -- avrop..nn.1
  avrullning_1_N : N ; -- avrullning..nn.1
  avrunda_1_V : V ; -- avrunda..vb.1
  avrundande_1_N : N ; -- avrundande..nn.1
  avrundning_1_N : N ; -- avrundning..nn.1
  avrusta_1_V : V ; -- avrusta..vb.1
  avrustande_1_N : N ; -- avrustande..nn.1
  avrustning_1_N : N ; -- avrustning..nn.1
  avräkna_1_V : V ; -- avräkna..vb.1
  avräknande_1_N : N ; -- avräknande..nn.1
  avräkning_1_N : N ; -- avräkning..nn.1
  avräkningsnota_1_N : N ; -- avräkningsnota..nn.1
  avrätta_1_V : V ; -- avrätta..vb.1
  avrättande_1_N : N ; -- avrättande..nn.1
  avrättning_1_N : N ; -- avrättning..nn.1
  avrättningsdag_1_N : N ; -- avrättningsdag..nn.1
  avrättningslista_1_N : N ; -- avrättningslista..nn.1
  avrättningsplats_1_N : N ; -- avrättningsplats..nn.1
  avråda_1_V : V ; -- avråda..vb.1
  avrådande_1_N : N ; -- avrådande..nn.1
  avröjning_1_N : N ; -- avröjning..nn.1
  avsadling_1_N : N ; -- avsadling..nn.1
  avsaknad_1_N : N ; -- avsaknad..nn.1
  avsaktning_1_N : N ; -- avsaktning..nn.1
  avsalta_1_V : V ; -- avsalta..vb.1
  avsaltande_1_N : N ; -- avsaltande..nn.1
  avsalu_1_N : N ; -- avsalu..nn.1
  avsats_1_N : N ; -- avsats..nn.1
  avse_1_V : V ; -- avse..vb.1
  avsedd_1_A : A ; -- avsedd..av.1
  avseende_1_N : N ; -- avseende..nn.1
  avsegla_1_V : V ; -- avsegla..vb.1
  avseglande_1_N : N ; -- avseglande..nn.1
  avsegling_1_N : N ; -- avsegling..nn.1
  avseglingsdag_1_N : N ; -- avseglingsdag..nn.1
  avseglingsort_1_N : N ; -- avseglingsort..nn.1
  avselning_1_N : N ; -- avselning..nn.1
  avsevärd_1_A : A ; -- avsevärd..av.1
  avsides_1_A : A ; -- avsides..av.1
  avsidesliv_1_N : N ; -- avsidesliv..nn.1
  avsigkommen_1_A : A ; -- avsigkommen..av.1
  avsigkommenhet_1_N : N ; -- avsigkommenhet..nn.1
  avsikt_1_N : N ; -- avsikt..nn.1
  avsiktlig_1_A : A ; -- avsiktlig..av.1
  avsiktligen_1_Adv : Adv ; -- avsiktligen..ab.1
  avsiktlighet_1_N : N ; -- avsiktlighet..nn.1
  avsiktsbisats_1_N : N ; -- avsiktsbisats..nn.1
  avsiktsförklaring_1_N : N ; -- avsiktsförklaring..nn.1
  avsiktslös_1_A : A ; -- avsiktslös..av.1
  avsiktssats_1_N : N ; -- avsiktssats..nn.1
  avsilning_1_N : N ; -- avsilning..nn.1
  avsittning_1_N : N ; -- avsittning..nn.1
  avsjunga_1_V : V ; -- avsjunga..vb.1
  avsjungande_1_N : N ; -- avsjungande..nn.1
  avskaffa_1_V : V ; -- avskaffa..vb.1
  avskaffande_1_N : N ; -- avskaffande..nn.1
  avskaffning_1_N : N ; -- avskaffning..nn.1
  avskakning_1_N : N ; -- avskakning..nn.1
  avskalning_1_N : N ; -- avskalning..nn.1
  avskava_1_V : V ; -- avskava..vb.1
  avskavande_1_N : N ; -- avskavande..nn.1
  avskavning_1_N : N ; -- avskavning..nn.1
  avsked_1_N : N ; -- avsked..nn.1
  avskeda_1_V : V ; -- avskeda..vb.1
  avskedande_1_N : N ; -- avskedande..nn.1
  avskedsbrev_1_N : N ; -- avskedsbrev..nn.1
  avskedsbägare_1_N : N ; -- avskedsbägare..nn.1
  avskedsdikt_1_N : N ; -- avskedsdikt..nn.1
  avskedsfest_1_N : N ; -- avskedsfest..nn.1
  avskedsföreställning_1_N : N ; -- avskedsföreställning..nn.1
  avskedshälsning_1_N : N ; -- avskedshälsning..nn.1
  avskedskalas_1_N : N ; -- avskedskalas..nn.1
  avskedsknull_1_N : N ; -- avskedsknull..nn.1
  avskedskyss_1_N : N ; -- avskedskyss..nn.1
  avskedsmiddag_1_N : N ; -- avskedsmiddag..nn.1
  avskedsord_1_N : N ; -- avskedsord..nn.1
  avskedsskål_1_N : N ; -- avskedsskål..nn.1
  avskedssång_1_N : N ; -- avskedssång..nn.1
  avskedstagande_1_N : N ; -- avskedstagande..nn.1
  avskedstal_1_N : N ; -- avskedstal..nn.1
  avskedsturné_1_N : N ; -- avskedsturné..nn.1
  avskedsuppvaktning_1_N : N ; -- avskedsuppvaktning..nn.1
  avskedsvisit_1_N : N ; -- avskedsvisit..nn.1
  avskeppa_1_V : V ; -- avskeppa..vb.1
  avskeppning_1_N : N ; -- avskeppning..nn.1
  avskeppningshamn_1_N : N ; -- avskeppningshamn..nn.1
  avskeppningsort_1_N : N ; -- avskeppningsort..nn.1
  avskild_1_A : A ; -- avskild..av.1
  avskildhet_1_N : N ; -- avskildhet..nn.1
  avskilja_1_V : V ; -- avskilja..vb.1
  avskiljande_1_N : N ; -- avskiljande..nn.1
  avskiljbar_1_A : A ; -- avskiljbar..av.1
  avskiljbarhet_1_N : N ; -- avskiljbarhet..nn.1
  avskiljning_1_N : N ; -- avskiljning..nn.1
  avskjuta_1_V : V ; -- avskjuta..vb.1
  avskjutande_1_N : N ; -- avskjutande..nn.1
  avskjutning_1_N : N ; -- avskjutning..nn.1
  avskogning_1_N : N ; -- avskogning..nn.1
  avskottning_1_N : N ; -- avskottning..nn.1
  avskrap_1_N : N ; -- avskrap..nn.1
  avskrapning_1_N : N ; -- avskrapning..nn.1
  avskrift_1_N : N ; -- avskrift..nn.1
  avskriva_1_V : V ; -- avskriva..vb.1
  avskrivande_1_N : N ; -- avskrivande..nn.1
  avskrivare_1_N : N ; -- avskrivare..nn.1
  avskrivning_1_N : N ; -- avskrivning..nn.1
  avskrivningsobjekt_1_N : N ; -- avskrivningsobjekt..nn.1
  avskrot_1_N : N ; -- avskrot..nn.1
  avskrubbning_1_N : N ; -- avskrubbning..nn.1
  avskruvning_1_N : N ; -- avskruvning..nn.1
  avskräcka_1_V : V ; -- avskräcka..vb.1
  avskräckande_1_N : N ; -- avskräckande..nn.1
  avskräckning_1_N : N ; -- avskräckning..nn.1
  avskräckningsmedel_1_N : N ; -- avskräckningsmedel..nn.1
  avskräckningspolitik_1_N : N ; -- avskräckningspolitik..nn.1
  avskräda_1_V : V ; -- avskräda..vb.1
  avskrädande_1_N : N ; -- avskrädande..nn.1
  avskräde_1_N : N ; -- avskräde..nn.1
  avskrädeshög_1_N : N ; -- avskrädeshög..nn.1
  avskrädning_1_N : N ; -- avskrädning..nn.1
  avskuddning_1_N : N ; -- avskuddning..nn.1
  avskumning_1_N : N ; -- avskumning..nn.1
  avskurning_1_N : N ; -- avskurning..nn.1
  avsky_1_V : V ; -- avsky..vb.1
  avskydd_1_A : A ; -- avskydd..av.1
  avskyende_1_N : N ; -- avskyende..nn.1
  avskyffling_1_N : N ; -- avskyffling..nn.1
  avskyväckande_1_A : A ; -- avskyväckande..av.1
  avskyvärd_1_A : A ; -- avskyvärd..av.1
  avskyvärdhet_1_N : N ; -- avskyvärdhet..nn.1
  avskära_1_V : V ; -- avskära..vb.1
  avskärande_1_N : N ; -- avskärande..nn.1
  avskärare_1_N : N ; -- avskärare..nn.1
  avskärma_1_V : V ; -- avskärma..vb.1
  avskärmande_1_N : N ; -- avskärmande..nn.1
  avskärmning_1_N : N ; -- avskärmning..nn.1
  avskärning_1_N : N ; -- avskärning..nn.1
  avsköljning_1_N : N ; -- avsköljning..nn.1
  avslag_1_N : N ; -- avslag..nn.1
  avslagen_1_A : A ; -- avslagen..av.1
  avslagenhet_1_N : N ; -- avslagenhet..nn.1
  avslappnad_1_A : A ; -- avslappnad..av.1
  avslappning_1_N : N ; -- avslappning..nn.1
  avslappningsskiva_1_N : N ; -- avslappningsskiva..nn.1
  avslappningsövning_1_N : N ; -- avslappningsövning..nn.1
  avslickning_1_N : N ; -- avslickning..nn.1
  avslipa_1_V : V ; -- avslipa..vb.1
  avslipande_1_N : N ; -- avslipande..nn.1
  avslipning_1_N : N ; -- avslipning..nn.1
  avslita_1_V : V ; -- avslita..vb.1
  avslitande_1_N : N ; -- avslitande..nn.1
  avslut_1_N : N ; -- avslut..nn.1
  avsluta_1_V : V ; -- avsluta..vb.1
  avslutande_1_N : N ; -- avslutande..nn.1
  avslutning_1_N : N ; -- avslutning..nn.1
  avslutningsfest_1_N : N ; -- avslutningsfest..nn.1
  avslutningsvis_1_Adv : Adv ; -- avslutningsvis..ab.1
  avslängning_1_N : N ; -- avslängning..nn.1
  avsläppning_1_N : N ; -- avsläppning..nn.1
  avslå_1_V : V ; -- avslå..vb.1
  avslående_1_N : N ; -- avslående..nn.1
  avslöja_1_V : V ; -- avslöja..vb.1
  avslöjande_1_N : N ; -- avslöjande..nn.1
  avslöjning_1_N : N ; -- avslöjning..nn.1
  avsmak_1_N : N ; -- avsmak..nn.1
  avsmaka_1_V : V ; -- avsmaka..vb.1
  avsmakande_1_N : N ; -- avsmakande..nn.1
  avsmakning_1_N : N ; -- avsmakning..nn.1
  avsmalna_1_V : V ; -- avsmalna..vb.1
  avsmalnande_1_N : N ; -- avsmalnande..nn.1
  avsmalning_1_N : N ; -- avsmalning..nn.1
  avsmältning_1_N : N ; -- avsmältning..nn.1
  avsnitt_1_N : N ; -- avsnitt..nn.1
  avsnoppa_1_V : V ; -- avsnoppa..vb.1
  avsnoppad_1_A : A ; -- avsnoppad..av.1
  avsnoppande_1_N : N ; -- avsnoppande..nn.1
  avsnäsning_1_N : N ; -- avsnäsning..nn.1
  avsnöra_1_V : V ; -- avsnöra..vb.1
  avsnörande_1_N : N ; -- avsnörande..nn.1
  avsnörning_1_N : N ; -- avsnörning..nn.1
  avsnörningsteori_1_N : N ; -- avsnörningsteori..nn.1
  avsocialisera_1_V : V ; -- avsocialisera..vb.1
  avsocialiserande_1_N : N ; -- avsocialiserande..nn.1
  avsocialiserbar_1_A : A ; -- avsocialiserbar..av.1
  avsocialiserbarhet_1_N : N ; -- avsocialiserbarhet..nn.1
  avsocialisering_1_N : N ; -- avsocialisering..nn.1
  avsomna_1_V : V ; -- avsomna..vb.1
  avsomnande_1_N : N ; -- avsomnande..nn.1
  avsopning_1_N : N ; -- avsopning..nn.1
  avspark_1_N : N ; -- avspark..nn.1
  avsparkning_1_N : N ; -- avsparkning..nn.1
  avspegla_1_V : V ; -- avspegla..vb.1
  avspeglande_1_N : N ; -- avspeglande..nn.1
  avspegling_1_N : N ; -- avspegling..nn.1
  avspela_1_V : V ; -- avspela..vb.1
  avspelande_1_N : N ; -- avspelande..nn.1
  avspelning_1_N : N ; -- avspelning..nn.1
  avspisa_1_V : V ; -- avspisa..vb.1
  avspisande_1_N : N ; -- avspisande..nn.1
  avspisning_1_N : N ; -- avspisning..nn.1
  avspolning_1_N : N ; -- avspolning..nn.1
  avsprång_1_N : N ; -- avsprång..nn.1
  avspänd_1_A : A ; -- avspänd..av.1
  avspändhet_1_N : N ; -- avspändhet..nn.1
  avspänning_1_N : N ; -- avspänning..nn.1
  avspänningspedagog_1_N : N ; -- avspänningspedagog..nn.1
  avspärra_1_V : V ; -- avspärra..vb.1
  avspärrande_1_N : N ; -- avspärrande..nn.1
  avspärrning_1_N : N ; -- avspärrning..nn.1
  avspärrningsband_1_N : N ; -- avspärrningsband..nn.1
  avstalinisera_1_V : V ; -- avstalinisera..vb.1
  avstaliniserande_1_N : N ; -- avstaliniserande..nn.1
  avstaliniserbar_1_A : A ; -- avstaliniserbar..av.1
  avstaliniserbarhet_1_N : N ; -- avstaliniserbarhet..nn.1
  avstalinisering_1_N : N ; -- avstalinisering..nn.1
  avstamp_1_N : N ; -- avstamp..nn.1
  avstanna_1_V : V ; -- avstanna..vb.1
  avstannande_1_N : N ; -- avstannande..nn.1
  avstava_1_V : V ; -- avstava..vb.1
  avstavande_1_N : N ; -- avstavande..nn.1
  avstavning_1_N : N ; -- avstavning..nn.1
  avstavningsregel_1_N : N ; -- avstavningsregel..nn.1
  avstavningssätt_1_N : N ; -- avstavningssätt..nn.1
  avsteg_1_N : N ; -- avsteg..nn.1
  avstickare_1_N : N ; -- avstickare..nn.1
  avstickning_1_N : N ; -- avstickning..nn.1
  avstigning_1_N : N ; -- avstigning..nn.1
  avstigningsplats_1_N : N ; -- avstigningsplats..nn.1
  avstjälpning_1_N : N ; -- avstjälpning..nn.1
  avstjälpningscentral_1_N : N ; -- avstjälpningscentral..nn.1
  avstjälpningsplats_1_N : N ; -- avstjälpningsplats..nn.1
  avstressa_1_V : V ; -- avstressa..vb.1
  avstressad_1_A : A ; -- avstressad..av.1
  avstressande_1_N : N ; -- avstressande..nn.1
  avstycka_1_V : V ; -- avstycka..vb.1
  avstyckande_1_N : N ; -- avstyckande..nn.1
  avstyckning_1_N : N ; -- avstyckning..nn.1
  avstyra_1_V : V ; -- avstyra..vb.1
  avstyrande_1_N : N ; -- avstyrande..nn.1
  avstyrka_1_V : V ; -- avstyrka..vb.1
  avstyrkande_1_N : N ; -- avstyrkande..nn.1
  avställa_1_V : V ; -- avställa..vb.1
  avställande_1_N : N ; -- avställande..nn.1
  avställning_1_N : N ; -- avställning..nn.1
  avställningsyta_1_N : N ; -- avställningsyta..nn.1
  avstämma_1_V : V ; -- avstämma..vb.1
  avstämmande_1_N : N ; -- avstämmande..nn.1
  avstämning_1_N : N ; -- avstämning..nn.1
  avstämpling_1_N : N ; -- avstämpling..nn.1
  avstänga_1_V : V ; -- avstänga..vb.1
  avstängande_1_N : N ; -- avstängande..nn.1
  avstängare_1_N : N ; -- avstängare..nn.1
  avstängning_1_N : N ; -- avstängning..nn.1
  avstå_1_V : V ; -- avstå..vb.1
  avstående_1_N : N ; -- avstående..nn.1
  avstånd_1_N : N ; -- avstånd..nn.1
  avståndsbedömning_1_N : N ; -- avståndsbedömning..nn.1
  avståndsinformation_1_N : N ; -- avståndsinformation..nn.1
  avståndskraft_1_N : N ; -- avståndskraft..nn.1
  avståndsmätare_1_N : N ; -- avståndsmätare..nn.1
  avståndsmätning_1_N : N ; -- avståndsmätning..nn.1
  avståndstagande_1_N : N ; -- avståndstagande..nn.1
  avstöra_1_V : V ; -- avstöra..vb.1
  avstörande_1_N : N ; -- avstörande..nn.1
  avstöta_1_V : V ; -- avstöta..vb.1
  avstötande_1_N : N ; -- avstötande..nn.1
  avstötning_1_N : N ; -- avstötning..nn.1
  avsugning_1_N : N ; -- avsugning..nn.1
  avsutten_1_A : A ; -- avsutten..av.1
  avsvalkning_1_N : N ; -- avsvalkning..nn.1
  avsvalna_1_V : V ; -- avsvalna..vb.1
  avsvalnande_1_N : N ; -- avsvalnande..nn.1
  avsvalning_1_N : N ; -- avsvalning..nn.1
  avsvalningshastighet_1_N : N ; -- avsvalningshastighet..nn.1
  avsvavla_1_V : V ; -- avsvavla..vb.1
  avsvavlande_1_N : N ; -- avsvavlande..nn.1
  avsvimma_1_V : V ; -- avsvimma..vb.1
  avsvimmande_1_N : N ; -- avsvimmande..nn.1
  avsvimning_1_N : N ; -- avsvimning..nn.1
  avsvuren_1_A : A ; -- avsvuren..av.1
  avsvärja_1_V : V ; -- avsvärja..vb.1
  avsvärjande_1_N : N ; -- avsvärjande..nn.1
  avsvärjning_1_N : N ; -- avsvärjning..nn.1
  avsyna_1_V : V ; -- avsyna..vb.1
  avsynande_1_N : N ; -- avsynande..nn.1
  avsynare_1_N : N ; -- avsynare..nn.1
  avsyning_1_N : N ; -- avsyning..nn.1
  avsäga_1_V : V ; -- avsäga..vb.1
  avsägande_1_N : N ; -- avsägande..nn.1
  avsägelse_1_N : N ; -- avsägelse..nn.1
  avsända_1_V : V ; -- avsända..vb.1
  avsändande_1_N : N ; -- avsändande..nn.1
  avsändare_1_N : N ; -- avsändare..nn.1
  avsändarnummer_1_N : N ; -- avsändarnummer..nn.1
  avsändning_1_N : N ; -- avsändning..nn.1
  avsätta_1_V : V ; -- avsätta..vb.1
  avsättande_1_N : N ; -- avsättande..nn.1
  avsättlig_1_A : A ; -- avsättlig..av.1
  avsättlighet_1_N : N ; -- avsättlighet..nn.1
  avsättning_1_N : N ; -- avsättning..nn.1
  avsättningsbassäng_1_N : N ; -- avsättningsbassäng..nn.1
  avsåga_1_V : V ; -- avsåga..vb.1
  avsågande_1_N : N ; -- avsågande..nn.1
  avsågning_1_N : N ; -- avsågning..nn.1
  avsöka_1_V : V ; -- avsöka..vb.1
  avsökande_1_N : N ; -- avsökande..nn.1
  avsökare_1_N : N ; -- avsökare..nn.1
  avsöndra_1_V : V ; -- avsöndra..vb.1
  avsöndrande_1_N : N ; -- avsöndrande..nn.1
  avsöndring_1_N : N ; -- avsöndring..nn.1
  avta_1_V : V ; -- avta..vb.1
  avtacka_1_V : V ; -- avtacka..vb.1
  avtackande_1_N : N ; -- avtackande..nn.1
  avtacklad_1_A : A ; -- avtacklad..av.1
  avtackling_1_N : N ; -- avtackling..nn.1
  avtackning_1_N : N ; -- avtackning..nn.1
  avtagande_1_A : A ; -- avtagande..av.1
  avtagande_1_N : N ; -- avtagande..nn.1
  avtagbar_1_A : A ; -- avtagbar..av.1
  avtagbarhet_1_N : N ; -- avtagbarhet..nn.1
  avtagning_1_N : N ; -- avtagning..nn.1
  avtagsväg_1_N : N ; -- avtagsväg..nn.1
  avtal_1_N : N ; -- avtal..nn.1
  avtala_1_V : V ; -- avtala..vb.1
  avtalande_1_N : N ; -- avtalande..nn.1
  avtalsbrott_1_N : N ; -- avtalsbrott..nn.1
  avtalsenlig_1_A : A ; -- avtalsenlig..av.1
  avtalsenlighet_1_N : N ; -- avtalsenlighet..nn.1
  avtalsfrihet_1_N : N ; -- avtalsfrihet..nn.1
  avtalsförhandling_1_N : N ; -- avtalsförhandling..nn.1
  avtalsmässig_1_A : A ; -- avtalsmässig..av.1
  avtalspension_1_N : N ; -- avtalspension..nn.1
  avtalspensionär_1_N : N ; -- avtalspensionär..nn.1
  avtalsperiod_1_N : N ; -- avtalsperiod..nn.1
  avtalsrätt_1_N : N ; -- avtalsrätt..nn.1
  avtalsrörelse_1_N : N ; -- avtalsrörelse..nn.1
  avtalssekreterare_1_N : N ; -- avtalssekreterare..nn.1
  avtalsslutande_1_A : A ; -- avtalsslutande..av.1
  avtalsstridig_1_A : A ; -- avtalsstridig..av.1
  avtappa_1_V : V ; -- avtappa..vb.1
  avtappande_1_N : N ; -- avtappande..nn.1
  avtappning_1_N : N ; -- avtappning..nn.1
  avteckna_1_V : V ; -- avteckna..vb.1
  avtecknande_1_N : N ; -- avtecknande..nn.1
  avteckning_1_N : N ; -- avteckning..nn.1
  avtjäna_1_V : V ; -- avtjäna..vb.1
  avtjänande_1_N : N ; -- avtjänande..nn.1
  avtona_1_V : V ; -- avtona..vb.1
  avtonande_1_N : N ; -- avtonande..nn.1
  avtoning_1_N : N ; -- avtoning..nn.1
  avtorka_1_V : V ; -- avtorka..vb.1
  avtorkning_1_N : N ; -- avtorkning..nn.1
  avtrappa_1_V : V ; -- avtrappa..vb.1
  avtrappande_1_N : N ; -- avtrappande..nn.1
  avtroppning_1_N : N ; -- avtroppning..nn.1
  avtrubba_1_V : V ; -- avtrubba..vb.1
  avtrubbande_1_N : N ; -- avtrubbande..nn.1
  avtrubbning_1_N : N ; -- avtrubbning..nn.1
  avtryck_1_N : N ; -- avtryck..nn.1
  avtryckare_1_N : N ; -- avtryckare..nn.1
  avtryckning_1_N : N ; -- avtryckning..nn.1
  avträda_1_V : V ; -- avträda..vb.1
  avträdande_1_N : N ; -- avträdande..nn.1
  avträdare_1_N : N ; -- avträdare..nn.1
  avträde_1_N : N ; -- avträde..nn.1
  avträdelse_1_N : N ; -- avträdelse..nn.1
  avtunna_1_V : V ; -- avtunna..vb.1
  avtunnande_1_N : N ; -- avtunnande..nn.1
  avtunning_1_N : N ; -- avtunning..nn.1
  avtvagning_1_N : N ; -- avtvagning..nn.1
  avtvinga_1_V : V ; -- avtvinga..vb.1
  avtvingande_1_N : N ; -- avtvingande..nn.1
  avtvättning_1_N : N ; -- avtvättning..nn.1
  avtvå_1_V : V ; -- avtvå..vb.1
  avtvående_1_N : N ; -- avtvående..nn.1
  avtyning_1_N : N ; -- avtyning..nn.1
  avtäcka_1_V : V ; -- avtäcka..vb.1
  avtäckande_1_N : N ; -- avtäckande..nn.1
  avtäckning_1_N : N ; -- avtäckning..nn.1
  avtäckningsceremoni_1_N : N ; -- avtäckningsceremoni..nn.1
  avtändande_1_A : A ; -- avtändande..av.1
  avtärd_1_A : A ; -- avtärd..av.1
  avtärdhet_1_N : N ; -- avtärdhet..nn.1
  avtåg_1_N : N ; -- avtåg..nn.1
  avtåga_1_V : V ; -- avtåga..vb.1
  avtågande_1_N : N ; -- avtågande..nn.1
  avulavirusinfektion_1_N : N ; -- avulavirusinfektion..nn.1
  avund_1_N : N ; -- avund..nn.1
  avundsam_1_A : A ; -- avundsam..av.1
  avundsamhet_1_N : N ; -- avundsamhet..nn.1
  avundsfri_1_A : A ; -- avundsfri..av.1
  avundsfull_1_A : A ; -- avundsfull..av.1
  avundsjuk_1_A : A ; -- avundsjuk..av.1
  avundsjuka_1_N : N ; -- avundsjuka..nn.1
  avundsjukhet_1_N : N ; -- avundsjukhet..nn.1
  avundsman_1_N : N ; -- avundsman..nn.1
  avundsvärd_1_A : A ; -- avundsvärd..av.1
  avundsvärdhet_1_N : N ; -- avundsvärdhet..nn.1
  avvakta_1_V : V ; -- avvakta..vb.1
  avvaktande_1_N : N ; -- avvaktande..nn.1
  avvara_1_V : V ; -- avvara..vb.1
  avvarad_1_A : A ; -- avvarad..av.1
  avvarande_1_N : N ; -- avvarande..nn.1
  avvattna_1_V : V ; -- avvattna..vb.1
  avvattnande_1_N : N ; -- avvattnande..nn.1
  avvattning_1_N : N ; -- avvattning..nn.1
  avveckla_1_V : V ; -- avveckla..vb.1
  avvecklande_1_N : N ; -- avvecklande..nn.1
  avveckling_1_N : N ; -- avveckling..nn.1
  avvecklingsbeslut_1_N : N ; -- avvecklingsbeslut..nn.1
  avverka_1_V : V ; -- avverka..vb.1
  avverkande_1_N : N ; -- avverkande..nn.1
  avverkning_1_N : N ; -- avverkning..nn.1
  avverkningsarbete_1_N : N ; -- avverkningsarbete..nn.1
  avverkningsrätt_1_N : N ; -- avverkningsrätt..nn.1
  avvika_1_V : V ; -- avvika..vb.1
  avvikande_1_A : A ; -- avvikande..av.1
  avvikande_1_N : N ; -- avvikande..nn.1
  avvikare_1_N : N ; -- avvikare..nn.1
  avvikelse_1_N : N ; -- avvikelse..nn.1
  avvikelseprocent_1_N : N ; -- avvikelseprocent..nn.1
  avviken_1_A : A ; -- avviken..av.1
  avvindning_1_N : N ; -- avvindning..nn.1
  avvinna_1_V : V ; -- avvinna..vb.1
  avvinnande_1_N : N ; -- avvinnande..nn.1
  avvisa_1_V : V ; -- avvisa..vb.1
  avvisande_1_N : N ; -- avvisande..nn.1
  avvisare_1_N : N ; -- avvisare..nn.1
  avvisning_1_N : N ; -- avvisning..nn.1
  avvisningsbeslut_1_N : N ; -- avvisningsbeslut..nn.1
  avvita_1_V : V ; -- avvita..vb.1
  avvitande_1_N : N ; -- avvitande..nn.1
  avvittra_1_V : V ; -- avvittra..vb.1
  avvittrande_1_N : N ; -- avvittrande..nn.1
  avväg_1_N : N ; -- avväg..nn.1
  avväga_1_V : V ; -- avväga..vb.1
  avvägande_1_N : N ; -- avvägande..nn.1
  avvägning_1_N : N ; -- avvägning..nn.1
  avvägningsinstrument_1_N : N ; -- avvägningsinstrument..nn.1
  avvältring_1_N : N ; -- avvältring..nn.1
  avvända_1_V : V ; -- avvända..vb.1
  avvändande_1_N : N ; -- avvändande..nn.1
  avvändning_1_N : N ; -- avvändning..nn.1
  avvänja_1_V : V ; -- avvänja..vb.1
  avvänjande_1_N : N ; -- avvänjande..nn.1
  avvänjning_1_N : N ; -- avvänjning..nn.1
  avvänjningstid_1_N : N ; -- avvänjningstid..nn.1
  avväpna_1_V : V ; -- avväpna..vb.1
  avväpnande_1_A : A ; -- avväpnande..av.1
  avväpnande_1_N : N ; -- avväpnande..nn.1
  avvärja_1_V : V ; -- avvärja..vb.1
  avvärjande_1_N : N ; -- avvärjande..nn.1
  avvärjning_1_N : N ; -- avvärjning..nn.1
  avväxling_1_N : N ; -- avväxling..nn.1
  avytterlig_1_A : A ; -- avytterlig..av.1
  avytterlighet_1_N : N ; -- avytterlighet..nn.1
  avyttra_1_V : V ; -- avyttra..vb.1
  avyttrande_1_N : N ; -- avyttrande..nn.1
  aväta_1_V : V ; -- aväta..vb.1
  avätande_1_N : N ; -- avätande..nn.1
  avåkning_1_N : N ; -- avåkning..nn.1
  ax_1_N : N ; -- ax..nn.1
  ax_2_N : N ; -- ax..nn.2
  axa_1_V : V ; -- axa..vb.1
  axande_1_N : N ; -- axande..nn.1
  axblommig_1_A : A ; -- axblommig..av.1
  axel_1_N : N ; -- axel..nn.1
  axelband_1_N : N ; -- axelband..nn.1
  axelbred_1_A : A ; -- axelbred..av.1
  axelbössa_1_N : N ; -- axelbössa..nn.1
  axeldiameter_1_N : N ; -- axeldiameter..nn.1
  axelfraktur_1_N : N ; -- axelfraktur..nn.1
  axelgehäng_1_N : N ; -- axelgehäng..nn.1
  axelhål_1_N : N ; -- axelhål..nn.1
  axelhölster_1_N : N ; -- axelhölster..nn.1
  axelinflammation_1_N : N ; -- axelinflammation..nn.1
  axelklaff_1_N : N ; -- axelklaff..nn.1
  axelkoppling_1_N : N ; -- axelkoppling..nn.1
  axellager_1_N : N ; -- axellager..nn.1
  axelled_1_N : N ; -- axelled..nn.1
  axelledsdislokation_1_N : N ; -- axelledsdislokation..nn.1
  axelledsluxation_1_N : N ; -- axelledsluxation..nn.1
  axellång_1_A : A ; -- axellång..av.1
  axelmuff_1_N : N ; -- axelmuff..nn.1
  axelrem_1_N : N ; -- axelrem..nn.1
  axelremsväska_1_N : N ; -- axelremsväska..nn.1
  axelriktning_1_N : N ; -- axelriktning..nn.1
  axelring_1_N : N ; -- axelring..nn.1
  axelryckning_1_N : N ; -- axelryckning..nn.1
  axelset_1_N : N ; -- axelset..nn.1
  axelsmärta_1_N : N ; -- axelsmärta..nn.1
  axelsprint_1_N : N ; -- axelsprint..nn.1
  axelvadd_1_N : N ; -- axelvadd..nn.1
  axformig_1_A : A ; -- axformig..av.1
  axial_1_A : A ; -- axial..av.1
  axillarkrycka_1_N : N ; -- axillarkrycka..nn.1
  axiom_1_N : N ; -- axiom..nn.1
  axiomatisera_1_V : V ; -- axiomatisera..vb.1
  axiomatiserande_1_N : N ; -- axiomatiserande..nn.1
  axiomatiserbar_1_A : A ; -- axiomatiserbar..av.1
  axiomatiserbarhet_1_N : N ; -- axiomatiserbarhet..nn.1
  axiomatisering_1_N : N ; -- axiomatisering..nn.1
  axiomatisk_1_A : A ; -- axiomatisk..av.1
  axion_1_N : N ; -- axion..nn.1
  axionförtätning_1_N : N ; -- axionförtätning..nn.1
  axla_1_V : V ; -- axla..vb.1
  axlande_1_N : N ; -- axlande..nn.1
  axplock_1_N : N ; -- axplock..nn.1
  axsvingel_1_N : N ; -- axsvingel..nn.1
  ayahuasca_1_N : N ; -- ayahuasca..nn.1
  ayatolla_1_N : N ; -- ayatolla..nn.1
  ayatollah_1_N : N ; -- ayatollah..nn.1
  ayrshireboskap_1_N : N ; -- ayrshireboskap..nn.1
  azalea_1_N : N ; -- azalea..nn.1
  azerbajdzjan_1_N : N ; -- azerbajdzjan..nn.1
  azerbajdzjansk_1_A : A ; -- azerbajdzjansk..av.1
  azerbajdzjanska_1_N : N ; -- azerbajdzjanska..nn.1
  azerbajdzjanska_2_N : N ; -- azerbajdzjanska..nn.2
  azimut_1_N : N ; -- azimut..nn.1
  azoospermi_1_N : N ; -- azoospermi..nn.1
  azotemi_1_N : N ; -- azotemi..nn.1
  aztek_1_N : N ; -- aztek..nn.1
  aztekisk_1_A : A ; -- aztekisk..av.1
  azur_1_N : N ; -- azur..nn.1
  azurblå_1_A : A ; -- azurblå..av.1
  azurfärg_1_N : N ; -- azurfärg..nn.1
  ba_1_Adv : Adv ; -- ba..ab.1
  babbel_1_N : N ; -- babbel..nn.1
  babbla_1_V : V ; -- babbla..vb.1
  babblande_1_N : N ; -- babblande..nn.1
  babblare_1_N : N ; -- babblare..nn.1
  babian_1_N : N ; -- babian..nn.1
  babianröv_1_N : N ; -- babianröv..nn.1
  babord_1_Adv : Adv ; -- babord..ab.1
  babord_1_N : N ; -- babord..nn.1
  babordsida_1_N : N ; -- babordsida..nn.1
  babordsvakt_1_N : N ; -- babordsvakt..nn.1
  babordsåra_1_N : N ; -- babordsåra..nn.1
  babusjka_1_N : N ; -- babusjka..nn.1
  baby_1_N : N ; -- baby..nn.1
  babyboom_1_N : N ; -- babyboom..nn.1
  babybyxa_1_N : N ; -- babybyxa..nn.1
  babydräkt_1_N : N ; -- babydräkt..nn.1
  babylonier_1_N : N ; -- babylonier..nn.1
  babylonisk_1_A : A ; -- babylonisk..av.1
  babylycka_1_N : N ; -- babylycka..nn.1
  babysitter_1_N : N ; -- babysitter..nn.1
  babysketch_1_N : N ; -- babysketch..nn.1
  baccarat_1_N : N ; -- baccarat..nn.1
  bacill_1_N : N ; -- bacill..nn.1
  bacillbärare_1_N : N ; -- bacillbärare..nn.1
  bacillfri_1_A : A ; -- bacillfri..av.1
  bacillskräck_1_N : N ; -- bacillskräck..nn.1
  back_1_N : N ; -- back..nn.1
  backa_1_N : N ; -- backa..nn.1
  backa_1_V : V ; -- backa..vb.1
  backa_2_V : V ; -- backa..vb.2
  backanal_1_N : N ; -- backanal..nn.1
  backanalant_1_N : N ; -- backanalant..nn.1
  backanalisk_1_A : A ; -- backanalisk..av.1
  backande_1_N : N ; -- backande..nn.1
  backanis_1_N : N ; -- backanis..nn.1
  backant_1_N : N ; -- backant..nn.1
  backe_1_N : N ; -- backe..nn.1
  backfisch_1_N : N ; -- backfisch..nn.1
  backgammon_1_N : N ; -- backgammon..nn.1
  backhammer_1_N : N ; -- backhammer..nn.1
  backhand_1_N : N ; -- backhand..nn.1
  backhoppare_1_N : N ; -- backhoppare..nn.1
  backhoppning_1_N : N ; -- backhoppning..nn.1
  backig_1_A : A ; -- backig..av.1
  backighet_1_N : N ; -- backighet..nn.1
  backkrön_1_N : N ; -- backkrön..nn.1
  backlandskap_1_N : N ; -- backlandskap..nn.1
  backning_1_N : N ; -- backning..nn.1
  backpacker_1_N : N ; -- backpacker..nn.1
  backpacking_1_N : N ; -- backpacking..nn.1
  backsignal_1_N : N ; -- backsignal..nn.1
  backsippa_1_N : N ; -- backsippa..nn.1
  backslag_1_N : N ; -- backslag..nn.1
  backspegel_1_N : N ; -- backspegel..nn.1
  backstag_1_N : N ; -- backstag..nn.1
  backström_1_N : N ; -- backström..nn.1
  backstuga_1_N : N ; -- backstuga..nn.1
  backstugusittare_1_N : N ; -- backstugusittare..nn.1
  backsvala_1_N : N ; -- backsvala..nn.1
  backsöta_1_N : N ; -- backsöta..nn.1
  backtimjan_1_N : N ; -- backtimjan..nn.1
  backup_1_N : N ; -- backup..nn.1
  backupa_1_V : V ; -- backupa..vb.1
  backupande_1_N : N ; -- backupande..nn.1
  backupp_1_N : N ; -- backupp..nn.1
  backuppa_1_V : V ; -- backuppa..vb.1
  backuppande_1_N : N ; -- backuppande..nn.1
  backvial_1_N : N ; -- backvial..nn.1
  backväxel_1_N : N ; -- backväxel..nn.1
  bacon_1_N : N ; -- bacon..nn.1
  bad_1_N : N ; -- bad..nn.1
  bada_1_V : V ; -- bada..vb.1
  badande_1_N : N ; -- badande..nn.1
  badanka_1_N : N ; -- badanka..nn.1
  badanläggning_1_N : N ; -- badanläggning..nn.1
  badanstalt_1_N : N ; -- badanstalt..nn.1
  badare_1_N : N ; -- badare..nn.1
  badbassäng_1_N : N ; -- badbassäng..nn.1
  badbild_1_N : N ; -- badbild..nn.1
  badborste_1_N : N ; -- badborste..nn.1
  badbyxa_1_N : N ; -- badbyxa..nn.1
  badda_1_V : V ; -- badda..vb.1
  baddande_1_N : N ; -- baddande..nn.1
  baddare_1_N : N ; -- baddare..nn.1
  baddjävel_1_N : N ; -- baddjävel..nn.1
  baddning_1_N : N ; -- baddning..nn.1
  baddräkt_1_N : N ; -- baddräkt..nn.1
  badensare_1_N : N ; -- badensare..nn.1
  badensisk_1_A : A ; -- badensisk..av.1
  badflicka_1_N : N ; -- badflicka..nn.1
  badförbud_1_N : N ; -- badförbud..nn.1
  badgäst_1_N : N ; -- badgäst..nn.1
  badhandduk_1_N : N ; -- badhandduk..nn.1
  badhus_1_N : N ; -- badhus..nn.1
  badhytt_1_N : N ; -- badhytt..nn.1
  badinrättning_1_N : N ; -- badinrättning..nn.1
  badkappa_1_N : N ; -- badkappa..nn.1
  badkar_1_N : N ; -- badkar..nn.1
  badkarseffekt_1_N : N ; -- badkarseffekt..nn.1
  badkarskant_1_N : N ; -- badkarskant..nn.1
  badklippa_1_N : N ; -- badklippa..nn.1
  badlakan_1_N : N ; -- badlakan..nn.1
  badläkare_1_N : N ; -- badläkare..nn.1
  badminton_1_N : N ; -- badminton..nn.1
  badmintonboll_1_N : N ; -- badmintonboll..nn.1
  badmintonrack_1_N : N ; -- badmintonrack..nn.1
  badmintonracket_1_N : N ; -- badmintonracket..nn.1
  badmössa_1_N : N ; -- badmössa..nn.1
  badning_1_N : N ; -- badning..nn.1
  badort_1_N : N ; -- badort..nn.1
  badortsliv_1_N : N ; -- badortsliv..nn.1
  badortsstad_1_N : N ; -- badortsstad..nn.1
  badplats_1_N : N ; -- badplats..nn.1
  badresa_1_N : N ; -- badresa..nn.1
  badrum_1_N : N ; -- badrum..nn.1
  badrumsdörr_1_N : N ; -- badrumsdörr..nn.1
  badrumsfläkt_1_N : N ; -- badrumsfläkt..nn.1
  badrumsfärg_1_N : N ; -- badrumsfärg..nn.1
  badrumsgolv_1_N : N ; -- badrumsgolv..nn.1
  badrumskakel_1_N : N ; -- badrumskakel..nn.1
  badrumsmöbel_1_N : N ; -- badrumsmöbel..nn.1
  badrumsskåp_1_N : N ; -- badrumsskåp..nn.1
  badrumsspegel_1_N : N ; -- badrumsspegel..nn.1
  badsalt_1_N : N ; -- badsalt..nn.1
  badsemester_1_N : N ; -- badsemester..nn.1
  badsjö_1_N : N ; -- badsjö..nn.1
  badsko_1_N : N ; -- badsko..nn.1
  badstrand_1_N : N ; -- badstrand..nn.1
  badstuga_1_N : N ; -- badstuga..nn.1
  badställe_1_N : N ; -- badställe..nn.1
  badtoffel_1_N : N ; -- badtoffel..nn.1
  badtunna_1_N : N ; -- badtunna..nn.1
  badturist_1_N : N ; -- badturist..nn.1
  badvakt_1_N : N ; -- badvakt..nn.1
  badvatten_1_N : N ; -- badvatten..nn.1
  bag_in_box_1_N : N ; -- bag-in-box..nn.1
  bag_1_N : N ; -- bag..nn.1
  bagage_1_N : N ; -- bagage..nn.1
  bagage_2_N : N ; -- bagage..nn.2
  bagagehylla_1_N : N ; -- bagagehylla..nn.1
  bagageinlämning_1_N : N ; -- bagageinlämning..nn.1
  bagagekärra_1_N : N ; -- bagagekärra..nn.1
  bagagelucka_1_N : N ; -- bagagelucka..nn.1
  bagagerum_1_N : N ; -- bagagerum..nn.1
  bagagestropp_1_N : N ; -- bagagestropp..nn.1
  bagageutrymme_1_N : N ; -- bagageutrymme..nn.1
  bagagevagn_1_N : N ; -- bagagevagn..nn.1
  bagarbod_1_N : N ; -- bagarbod..nn.1
  bagare_1_N : N ; -- bagare..nn.1
  bagarmössa_1_N : N ; -- bagarmössa..nn.1
  bagarstuga_1_N : N ; -- bagarstuga..nn.1
  bagatell_1_N : N ; -- bagatell..nn.1
  bagatellartad_1_A : A ; -- bagatellartad..av.1
  bagatellisera_1_V : V ; -- bagatellisera..vb.1
  bagatelliserande_1_N : N ; -- bagatelliserande..nn.1
  bagatelliserbar_1_A : A ; -- bagatelliserbar..av.1
  bagatelliserbarhet_1_N : N ; -- bagatelliserbarhet..nn.1
  bagatellisering_1_N : N ; -- bagatellisering..nn.1
  bagatellmål_1_N : N ; -- bagatellmål..nn.1
  bagel_1_N : N ; -- bagel..nn.1
  bageri_1_N : N ; -- bageri..nn.1
  bagerimargarin_1_N : N ; -- bagerimargarin..nn.1
  bagerirörelse_1_N : N ; -- bagerirörelse..nn.1
  bagg_1_N : N ; -- bagg..nn.1
  baggböla_1_V : V ; -- baggböla..vb.1
  baggbölande_1_N : N ; -- baggbölande..nn.1
  baggbölare_1_N : N ; -- baggbölare..nn.1
  baggböleri_1_N : N ; -- baggböleri..nn.1
  bagge_1_N : N ; -- bagge..nn.1
  bagis_1_N : N ; -- bagis..nn.1
  baguette_1_N : N ; -- baguette..nn.1
  bahaman_1_N : N ; -- bahaman..nn.1
  bahamansk_1_A : A ; -- bahamansk..av.1
  bahamanska_1_N : N ; -- bahamanska..nn.1
  bahrainare_1_N : N ; -- bahrainare..nn.1
  bahrainsk_1_A : A ; -- bahrainsk..av.1
  bahrainska_1_N : N ; -- bahrainska..nn.1
  bahytt_1_N : N ; -- bahytt..nn.1
  baissa_1_V : V ; -- baissa..vb.1
  baissande_1_N : N ; -- baissande..nn.1
  baisse_1_N : N ; -- baisse..nn.1
  baissespekulation_1_N : N ; -- baissespekulation..nn.1
  baja_maja_1_N : N ; -- baja-maja..nn.1
  baja_1_V : V ; -- baja..vb.1
  bajadär_1_N : N ; -- bajadär..nn.1
  bajamaja_1_N : N ; -- bajamaja..nn.1
  bajande_1_N : N ; -- bajande..nn.1
  bajersk_1_A : A ; -- bajersk..av.1
  bajonett_1_N : N ; -- bajonett..nn.1
  bajonettanfall_1_N : N ; -- bajonettanfall..nn.1
  bajonettbalja_1_N : N ; -- bajonettbalja..nn.1
  bajonettfattning_1_N : N ; -- bajonettfattning..nn.1
  bajonettförsedd_1_A : A ; -- bajonettförsedd..av.1
  bajonettspets_1_N : N ; -- bajonettspets..nn.1
  bajrare_1_N : N ; -- bajrare..nn.1
  bajs_1_N : N ; -- bajs..nn.1
  bajsa_1_V : V ; -- bajsa..vb.1
  bajsande_1_N : N ; -- bajsande..nn.1
  bajsbrun_1_A : A ; -- bajsbrun..av.1
  bajshög_1_N : N ; -- bajshög..nn.1
  bajsig_1_A : A ; -- bajsig..av.1
  bajskorv_1_N : N ; -- bajskorv..nn.1
  bajsnödig_1_A : A ; -- bajsnödig..av.1
  bajstransplantat_1_N : N ; -- bajstransplantat..nn.1
  bajstransplantation_1_N : N ; -- bajstransplantation..nn.1
  bak_1_N : N ; -- bak..nn.1
  bak_2_N : N ; -- bak..nn.2
  baka_1_V : V ; -- baka..vb.1
  bakande_1_N : N ; -- bakande..nn.1
  bakarv_1_N : N ; -- bakarv..nn.1
  bakarvinge_1_N : N ; -- bakarvinge..nn.1
  bakaxel_1_N : N ; -- bakaxel..nn.1
  bakaxelväxel_1_N : N ; -- bakaxelväxel..nn.1
  bakben_1_N : N ; -- bakben..nn.1
  bakbinda_1_V : V ; -- bakbinda..vb.1
  bakbindande_1_N : N ; -- bakbindande..nn.1
  bakbindning_1_N : N ; -- bakbindning..nn.1
  bakblåsare_1_N : N ; -- bakblåsare..nn.1
  bakdanta_1_V : V ; -- bakdanta..vb.1
  bakdantande_1_N : N ; -- bakdantande..nn.1
  bakdantare_1_N : N ; -- bakdantare..nn.1
  bakdanteri_1_N : N ; -- bakdanteri..nn.1
  bakdel_1_N : N ; -- bakdel..nn.1
  bakdäck_1_N : N ; -- bakdäck..nn.1
  bakdörr_1_N : N ; -- bakdörr..nn.1
  bakelit_1_N : N ; -- bakelit..nn.1
  bakelse_1_N : N ; -- bakelse..nn.1
  bakerst_1_Adv : Adv ; -- bakerst..ab.1
  bakersta_1_A : A ; -- bakersta..av.1
  bakficka_1_N : N ; -- bakficka..nn.1
  bakflygel_1_N : N ; -- bakflygel..nn.1
  bakfot_1_N : N ; -- bakfot..nn.1
  bakfull_1_A : A ; -- bakfull..av.1
  bakfullhet_1_N : N ; -- bakfullhet..nn.1
  bakfylla_1_N : N ; -- bakfylla..nn.1
  bakgata_1_N : N ; -- bakgata..nn.1
  bakgrund_1_N : N ; -- bakgrund..nn.1
  bakgrundsfigur_1_N : N ; -- bakgrundsfigur..nn.1
  bakgrundsljud_1_N : N ; -- bakgrundsljud..nn.1
  bakgrundsmusik_1_N : N ; -- bakgrundsmusik..nn.1
  bakgrundsreportage_1_N : N ; -- bakgrundsreportage..nn.1
  bakgrundsskildring_1_N : N ; -- bakgrundsskildring..nn.1
  bakgrundssorl_1_N : N ; -- bakgrundssorl..nn.1
  bakgrundsstrålning_1_N : N ; -- bakgrundsstrålning..nn.1
  bakgrundstal_1_N : N ; -- bakgrundstal..nn.1
  bakgrundston_1_N : N ; -- bakgrundston..nn.1
  bakgrundsvariabel_1_N : N ; -- bakgrundsvariabel..nn.1
  bakgård_1_N : N ; -- bakgård..nn.1
  bakhal_1_A : A ; -- bakhal..av.1
  bakhas_1_N : N ; -- bakhas..nn.1
  bakhjul_1_N : N ; -- bakhjul..nn.1
  bakhjulsdriven_1_A : A ; -- bakhjulsdriven..av.1
  bakhov_1_N : N ; -- bakhov..nn.1
  bakhuvud_1_N : N ; -- bakhuvud..nn.1
  bakhåll_1_N : N ; -- bakhåll..nn.1
  baki_1_Adv : Adv ; -- baki..ab.1
  bakifrån_1_Adv : Adv ; -- bakifrån..ab.1
  bakis_1_A : A ; -- bakis..av.1
  bakjour_1_N : N ; -- bakjour..nn.1
  bakkant_1_N : N ; -- bakkant..nn.1
  bakkappa_1_N : N ; -- bakkappa..nn.1
  bakkropp_1_N : N ; -- bakkropp..nn.1
  bakladdare_1_N : N ; -- bakladdare..nn.1
  bakladdning_1_N : N ; -- bakladdning..nn.1
  baklampa_1_N : N ; -- baklampa..nn.1
  bakland_1_N : N ; -- bakland..nn.1
  bakljus_1_N : N ; -- bakljus..nn.1
  bakljusramp_1_N : N ; -- bakljusramp..nn.1
  baklucka_1_N : N ; -- baklucka..nn.1
  baklukt_1_N : N ; -- baklukt..nn.1
  baklängesordbok_1_N : N ; -- baklängesordbok..nn.1
  baklängesvandring_1_N : N ; -- baklängesvandring..nn.1
  bakläxa_1_N : N ; -- bakläxa..nn.1
  bakning_1_N : N ; -- bakning..nn.1
  bakom_1_A : A ; -- bakom..av.1
  bakomliggande_1_A : A ; -- bakomliggande..av.1
  bakomsittande_1_A : A ; -- bakomsittande..av.1
  bakomvarande_1_A : A ; -- bakomvarande..av.1
  bakplåt_1_N : N ; -- bakplåt..nn.1
  bakplåtspapper_1_N : N ; -- bakplåtspapper..nn.1
  bakport_1_N : N ; -- bakport..nn.1
  bakprojektion_1_N : N ; -- bakprojektion..nn.1
  bakpulver_1_N : N ; -- bakpulver..nn.1
  bakpå_1_Adv : Adv ; -- bakpå..ab.1
  bakrus_1_N : N ; -- bakrus..nn.1
  bakruta_1_N : N ; -- bakruta..nn.1
  baksida_1_N : N ; -- baksida..nn.1
  baksidesreklam_1_N : N ; -- baksidesreklam..nn.1
  baksidestext_1_N : N ; -- baksidestext..nn.1
  bakslag_1_N : N ; -- bakslag..nn.1
  bakslagsventil_1_N : N ; -- bakslagsventil..nn.1
  bakslug_1_A : A ; -- bakslug..av.1
  bakslughet_1_N : N ; -- bakslughet..nn.1
  baksmälla_1_N : N ; -- baksmälla..nn.1
  bakspår_1_N : N ; -- bakspår..nn.1
  baksteg_1_N : N ; -- baksteg..nn.1
  bakstreck_1_N : N ; -- bakstreck..nn.1
  baksträvare_1_N : N ; -- baksträvare..nn.1
  bakström_1_N : N ; -- bakström..nn.1
  bakstycke_1_N : N ; -- bakstycke..nn.1
  baksäte_1_N : N ; -- baksäte..nn.1
  baktal_1_N : N ; -- baktal..nn.1
  baktala_1_V : V ; -- baktala..vb.1
  baktalande_1_N : N ; -- baktalande..nn.1
  baktalare_1_N : N ; -- baktalare..nn.1
  baktanke_1_N : N ; -- baktanke..nn.1
  baktass_1_N : N ; -- baktass..nn.1
  baktericid_1_A : A ; -- baktericid..av.1
  baktericid_1_N : N ; -- baktericid..nn.1
  bakterie_1_N : N ; -- bakterie..nn.1
  bakterieart_1_N : N ; -- bakterieart..nn.1
  bakteriedödande_1_A : A ; -- bakteriedödande..av.1
  bakterieflora_1_N : N ; -- bakterieflora..nn.1
  bakteriefri_1_A : A ; -- bakteriefri..av.1
  bakteriehärd_1_N : N ; -- bakteriehärd..nn.1
  bakterieinfektion_1_N : N ; -- bakterieinfektion..nn.1
  bakteriekultur_1_N : N ; -- bakteriekultur..nn.1
  bakteriell_1_A : A ; -- bakteriell..av.1
  bakteriesmittad_1_A : A ; -- bakteriesmittad..av.1
  bakteriofag_1_N : N ; -- bakteriofag..nn.1
  bakteriolog_1_N : N ; -- bakteriolog..nn.1
  bakteriologi_1_N : N ; -- bakteriologi..nn.1
  bakteriologisk_1_A : A ; -- bakteriologisk..av.1
  baktill_1_Adv : Adv ; -- baktill..ab.1
  baktrappa_1_N : N ; -- baktrappa..nn.1
  baktung_1_A : A ; -- baktung..av.1
  baktunghet_1_N : N ; -- baktunghet..nn.1
  bakugn_1_N : N ; -- bakugn..nn.1
  bakut_1_Adv : Adv ; -- bakut..ab.1
  bakvagn_1_N : N ; -- bakvagn..nn.1
  bakvatten_1_N : N ; -- bakvatten..nn.1
  bakverk_1_N : N ; -- bakverk..nn.1
  bakvid_1_Adv : Adv ; -- bakvid..ab.1
  bakvikt_1_N : N ; -- bakvikt..nn.1
  bakvinge_1_N : N ; -- bakvinge..nn.1
  bakväg_1_N : N ; -- bakväg..nn.1
  bakvägg_1_N : N ; -- bakvägg..nn.1
  bakvänd_1_A : A ; -- bakvänd..av.1
  bakvändhet_1_N : N ; -- bakvändhet..nn.1
  bakända_1_N : N ; -- bakända..nn.1
  bakände_1_N : N ; -- bakände..nn.1
  bakåtblickande_1_A : A ; -- bakåtblickande..av.1
  bakåtkammad_1_A : A ; -- bakåtkammad..av.1
  bakåtlutad_1_A : A ; -- bakåtlutad..av.1
  bakåtriktad_1_A : A ; -- bakåtriktad..av.1
  bakåträknande_1_A : A ; -- bakåträknande..av.1
  bakåtsteg_1_N : N ; -- bakåtsteg..nn.1
  bakåtsträvande_1_A : A ; -- bakåtsträvande..av.1
  bakåtsträvare_1_N : N ; -- bakåtsträvare..nn.1
  baköver_1_Adv : Adv ; -- baköver..ab.1
  bal_1_N : N ; -- bal..nn.1
  bal_2_N : N ; -- bal..nn.2
  bala_1_V : V ; -- bala..vb.1
  balaclava_1_N : N ; -- balaclava..nn.1
  balaklava_1_N : N ; -- balaklava..nn.1
  balalajka_1_N : N ; -- balalajka..nn.1
  balalajkaspelare_1_N : N ; -- balalajkaspelare..nn.1
  balande_1_N : N ; -- balande..nn.1
  balans_1_N : N ; -- balans..nn.1
  balans_2_N : N ; -- balans..nn.2
  balansakt_1_N : N ; -- balansakt..nn.1
  balansera_1_V : V ; -- balansera..vb.1
  balansera_2_V : V ; -- balansera..vb.2
  balanserad_1_A : A ; -- balanserad..av.1
  balanserande_1_N : N ; -- balanserande..nn.1
  balanserbar_1_A : A ; -- balanserbar..av.1
  balanserbarhet_1_N : N ; -- balanserbarhet..nn.1
  balansering_1_N : N ; -- balansering..nn.1
  balanserstång_1_N : N ; -- balanserstång..nn.1
  balansgång_1_N : N ; -- balansgång..nn.1
  balanshjul_1_N : N ; -- balanshjul..nn.1
  balanskonstnär_1_N : N ; -- balanskonstnär..nn.1
  balanskonto_1_N : N ; -- balanskonto..nn.1
  balansnummer_1_N : N ; -- balansnummer..nn.1
  balansorgan_1_N : N ; -- balansorgan..nn.1
  balansplog_1_N : N ; -- balansplog..nn.1
  balansroder_1_N : N ; -- balansroder..nn.1
  balansrubbning_1_N : N ; -- balansrubbning..nn.1
  balansräkning_1_N : N ; -- balansräkning..nn.1
  balanssinne_1_N : N ; -- balanssinne..nn.1
  balansvåg_1_N : N ; -- balansvåg..nn.1
  balata_1_N : N ; -- balata..nn.1
  baldakin_1_N : N ; -- baldakin..nn.1
  baldersbrå_1_N : N ; -- baldersbrå..nn.1
  baldrottning_1_N : N ; -- baldrottning..nn.1
  bale_1_N : N ; -- bale..nn.1
  balett_1_N : N ; -- balett..nn.1
  balettdans_1_N : N ; -- balettdans..nn.1
  balettdansör_1_N : N ; -- balettdansör..nn.1
  balettdansös_1_N : N ; -- balettdansös..nn.1
  balettflicka_1_N : N ; -- balettflicka..nn.1
  balettmästare_1_N : N ; -- balettmästare..nn.1
  balgäst_1_N : N ; -- balgäst..nn.1
  balinesisk_1_A : A ; -- balinesisk..av.1
  balja_1_N : N ; -- balja..nn.1
  baljväxt_1_N : N ; -- baljväxt..nn.1
  balk_1_N : N ; -- balk..nn.1
  balkanfolk_1_N : N ; -- balkanfolk..nn.1
  balkaniserad_1_A : A ; -- balkaniserad..av.1
  balkanisering_1_N : N ; -- balkanisering..nn.1
  balkansk_1_A : A ; -- balkansk..av.1
  balkknä_1_N : N ; -- balkknä..nn.1
  balklänning_1_N : N ; -- balklänning..nn.1
  balkmått_1_N : N ; -- balkmått..nn.1
  balkong_1_N : N ; -- balkong..nn.1
  balkongdörr_1_N : N ; -- balkongdörr..nn.1
  balkonglåda_1_N : N ; -- balkonglåda..nn.1
  balkongräcke_1_N : N ; -- balkongräcke..nn.1
  balksko_1_N : N ; -- balksko..nn.1
  balkverk_1_N : N ; -- balkverk..nn.1
  balkvägare_1_N : N ; -- balkvägare..nn.1
  ball_1_A : A ; -- ball..av.1
  ballad_1_N : N ; -- ballad..nn.1
  balladdiktning_1_N : N ; -- balladdiktning..nn.1
  ballast_1_N : N ; -- ballast..nn.1
  balle_1_N : N ; -- balle..nn.1
  ballerina_1_N : N ; -- ballerina..nn.1
  ballhet_1_N : N ; -- ballhet..nn.1
  ballistik_1_N : N ; -- ballistik..nn.1
  ballistisk_1_A : A ; -- ballistisk..av.1
  ballograf_1_N : N ; -- ballograf..nn.1
  ballong_1_N : N ; -- ballong..nn.1
  ballongbluff_1_N : N ; -- ballongbluff..nn.1
  ballongboll_1_N : N ; -- ballongboll..nn.1
  ballongburen_1_A : A ; -- ballongburen..av.1
  ballongdäck_1_N : N ; -- ballongdäck..nn.1
  ballongfamilj_1_N : N ; -- ballongfamilj..nn.1
  ballongfärd_1_N : N ; -- ballongfärd..nn.1
  ballonggas_1_N : N ; -- ballonggas..nn.1
  ballonggondol_1_N : N ; -- ballonggondol..nn.1
  ballongmage_1_N : N ; -- ballongmage..nn.1
  ballongpojke_1_N : N ; -- ballongpojke..nn.1
  ballongprick_1_N : N ; -- ballongprick..nn.1
  ballongsegel_1_N : N ; -- ballongsegel..nn.1
  ballongvisp_1_N : N ; -- ballongvisp..nn.1
  balloptikon_1_N : N ; -- balloptikon..nn.1
  ballotera_1_V : V ; -- ballotera..vb.1
  balloterande_1_N : N ; -- balloterande..nn.1
  balloterbar_1_A : A ; -- balloterbar..av.1
  balloterbarhet_1_N : N ; -- balloterbarhet..nn.1
  ballotering_1_N : N ; -- ballotering..nn.1
  balneolog_1_N : N ; -- balneolog..nn.1
  balneologi_1_N : N ; -- balneologi..nn.1
  balneologisk_1_A : A ; -- balneologisk..av.1
  balsa_1_N : N ; -- balsa..nn.1
  balsal_1_N : N ; -- balsal..nn.1
  balsam_1_N : N ; -- balsam..nn.1
  balsamdoftande_1_A : A ; -- balsamdoftande..av.1
  balsamera_1_V : V ; -- balsamera..vb.1
  balsamerande_1_N : N ; -- balsamerande..nn.1
  balsamerbar_1_A : A ; -- balsamerbar..av.1
  balsamerbarhet_1_N : N ; -- balsamerbarhet..nn.1
  balsamering_1_N : N ; -- balsamering..nn.1
  balsamin_1_N : N ; -- balsamin..nn.1
  balsamisk_1_A : A ; -- balsamisk..av.1
  balsamterpentin_1_N : N ; -- balsamterpentin..nn.1
  balsaträ_1_N : N ; -- balsaträ..nn.1
  balt_1_N : N ; -- balt..nn.1
  baltisk_1_A : A ; -- baltisk..av.1
  baltiska_1_N : N ; -- baltiska..nn.1
  baltutlämning_1_N : N ; -- baltutlämning..nn.1
  baluns_1_N : N ; -- baluns..nn.1
  baluster_1_N : N ; -- baluster..nn.1
  balustrad_1_N : N ; -- balustrad..nn.1
  bamba_1_N : N ; -- bamba..nn.1
  bambu_1_N : N ; -- bambu..nn.1
  bamburör_1_N : N ; -- bamburör..nn.1
  bambusoffa_1_N : N ; -- bambusoffa..nn.1
  ban_1_N : N ; -- ban..nn.1
  ban_2_N : N ; -- ban..nn.2
  bana_1_N : N ; -- bana..nn.1
  banal_1_A : A ; -- banal..av.1
  banalisera_1_V : V ; -- banalisera..vb.1
  banaliserande_1_N : N ; -- banaliserande..nn.1
  banaliserbar_1_A : A ; -- banaliserbar..av.1
  banaliserbarhet_1_N : N ; -- banaliserbarhet..nn.1
  banalisering_1_N : N ; -- banalisering..nn.1
  banalitet_1_N : N ; -- banalitet..nn.1
  banan_1_N : N ; -- banan..nn.1
  bananbana_1_N : N ; -- bananbana..nn.1
  bananfluga_1_N : N ; -- bananfluga..nn.1
  bananformad_1_A : A ; -- bananformad..av.1
  banankontakt_1_N : N ; -- banankontakt..nn.1
  bananrepublik_1_N : N ; -- bananrepublik..nn.1
  bananstock_1_N : N ; -- bananstock..nn.1
  bananträd_1_N : N ; -- bananträd..nn.1
  banarbete_1_N : N ; -- banarbete..nn.1
  banbrytande_1_A : A ; -- banbrytande..av.1
  banbrytare_1_N : N ; -- banbrytare..nn.1
  banco_1_N : N ; -- banco..nn.1
  band_1_N : N ; -- band..nn.1
  banda_1_V : V ; -- banda..vb.1
  bandage_1_N : N ; -- bandage..nn.1
  bandande_1_N : N ; -- bandande..nn.1
  bandel_1_N : N ; -- bandel..nn.1
  banderol_1_N : N ; -- banderol..nn.1
  banderoll_1_N : N ; -- banderoll..nn.1
  bandfordon_1_N : N ; -- bandfordon..nn.1
  bandformig_1_A : A ; -- bandformig..av.1
  bandgenerator_1_N : N ; -- bandgenerator..nn.1
  bandhund_1_N : N ; -- bandhund..nn.1
  bandit_1_N : N ; -- bandit..nn.1
  banditaktig_1_A : A ; -- banditaktig..av.1
  banditgäng_1_N : N ; -- banditgäng..nn.1
  bandjärn_1_N : N ; -- bandjärn..nn.1
  bandkantning_1_N : N ; -- bandkantning..nn.1
  bandkniv_1_N : N ; -- bandkniv..nn.1
  bandmedlem_1_N : N ; -- bandmedlem..nn.1
  bandolär_1_N : N ; -- bandolär..nn.1
  bandotek_1_N : N ; -- bandotek..nn.1
  bandspektrum_1_N : N ; -- bandspektrum..nn.1
  bandspelare_1_N : N ; -- bandspelare..nn.1
  bandstation_1_N : N ; -- bandstation..nn.1
  bandstump_1_N : N ; -- bandstump..nn.1
  bandsåg_1_N : N ; -- bandsåg..nn.1
  bandtraktor_1_N : N ; -- bandtraktor..nn.1
  bandupptagning_1_N : N ; -- bandupptagning..nn.1
  bandvimpel_1_N : N ; -- bandvimpel..nn.1
  bandyboll_1_N : N ; -- bandyboll..nn.1
  bandyfanatiker_1_N : N ; -- bandyfanatiker..nn.1
  bandyklubba_1_N : N ; -- bandyklubba..nn.1
  bandyrör_1_N : N ; -- bandyrör..nn.1
  bandyslag_1_N : N ; -- bandyslag..nn.1
  bane_1_N : N ; -- bane..nn.1
  banehugg_1_N : N ; -- banehugg..nn.1
  baneman_1_N : N ; -- baneman..nn.1
  baner_1_N : N ; -- baner..nn.1
  banerförare_1_N : N ; -- banerförare..nn.1
  banesår_1_N : N ; -- banesår..nn.1
  bang_1_A : A ; -- bang..av.1
  bang_1_N : N ; -- bang..nn.1
  banghet_1_N : N ; -- banghet..nn.1
  bangladeshare_1_N : N ; -- bangladeshare..nn.1
  bangladeshier_1_N : N ; -- bangladeshier..nn.1
  bangladeshisk_1_A : A ; -- bangladeshisk..av.1
  bangladeshiska_1_N : N ; -- bangladeshiska..nn.1
  bangolf_1_N : N ; -- bangolf..nn.1
  bangård_1_N : N ; -- bangård..nn.1
  banhall_1_N : N ; -- banhall..nn.1
  baning_1_N : N ; -- baning..nn.1
  banjo_1_N : N ; -- banjo..nn.1
  banjoinstrument_1_N : N ; -- banjoinstrument..nn.1
  bank_1_N : N ; -- bank..nn.1
  bank_2_N : N ; -- bank..nn.2
  banka_1_V : V ; -- banka..vb.1
  bankande_1_N : N ; -- bankande..nn.1
  bankanställd_1_A : A ; -- bankanställd..av.1
  bankbok_1_N : N ; -- bankbok..nn.1
  bankdirektion_1_N : N ; -- bankdirektion..nn.1
  bankdirektör_1_N : N ; -- bankdirektör..nn.1
  bankett_1_N : N ; -- bankett..nn.1
  bankfack_1_N : N ; -- bankfack..nn.1
  bankföretag_1_N : N ; -- bankföretag..nn.1
  bankgiro_1_N : N ; -- bankgiro..nn.1
  bankhus_1_N : N ; -- bankhus..nn.1
  bankinrättning_1_N : N ; -- bankinrättning..nn.1
  bankinspektion_1_N : N ; -- bankinspektion..nn.1
  bankir_1_N : N ; -- bankir..nn.1
  bankirfirma_1_N : N ; -- bankirfirma..nn.1
  bankirhustru_1_N : N ; -- bankirhustru..nn.1
  bankkamrer_1_N : N ; -- bankkamrer..nn.1
  bankkapital_1_N : N ; -- bankkapital..nn.1
  bankkassör_1_N : N ; -- bankkassör..nn.1
  bankkollaps_1_N : N ; -- bankkollaps..nn.1
  bankkonto_1_N : N ; -- bankkonto..nn.1
  bankkontor_1_N : N ; -- bankkontor..nn.1
  bankkort_1_N : N ; -- bankkort..nn.1
  bankkund_1_N : N ; -- bankkund..nn.1
  banklag_1_N : N ; -- banklag..nn.1
  banklån_1_N : N ; -- banklån..nn.1
  bankman_1_N : N ; -- bankman..nn.1
  bankmässig_1_A : A ; -- bankmässig..av.1
  banknisse_1_N : N ; -- banknisse..nn.1
  banko_1_N : N ; -- banko..nn.1
  bankofullmäktig_1_N : N ; -- bankofullmäktig..nn.1
  bankomat_1_N : N ; -- bankomat..nn.1
  bankomatkort_1_N : N ; -- bankomatkort..nn.1
  bankomatkupp_1_N : N ; -- bankomatkupp..nn.1
  bankomatrånare_1_N : N ; -- bankomatrånare..nn.1
  bankpalats_1_N : N ; -- bankpalats..nn.1
  bankpanik_1_N : N ; -- bankpanik..nn.1
  bankreglering_1_N : N ; -- bankreglering..nn.1
  bankrutt_1_A : A ; -- bankrutt..av.1
  bankrutt_1_N : N ; -- bankrutt..nn.1
  bankruttera_1_V : V ; -- bankruttera..vb.1
  bankrutterande_1_N : N ; -- bankrutterande..nn.1
  bankrutterbar_1_A : A ; -- bankrutterbar..av.1
  bankrutterbarhet_1_N : N ; -- bankrutterbarhet..nn.1
  bankruttering_1_N : N ; -- bankruttering..nn.1
  bankruttförklaring_1_N : N ; -- bankruttförklaring..nn.1
  bankruttmässig_1_A : A ; -- bankruttmässig..av.1
  bankruttör_1_N : N ; -- bankruttör..nn.1
  bankränta_1_N : N ; -- bankränta..nn.1
  bankrån_1_N : N ; -- bankrån..nn.1
  bankrånare_1_N : N ; -- bankrånare..nn.1
  bankrörelse_1_N : N ; -- bankrörelse..nn.1
  banksektor_1_N : N ; -- banksektor..nn.1
  banksparande_1_N : N ; -- banksparande..nn.1
  bankstyrelse_1_N : N ; -- bankstyrelse..nn.1
  banktjänsteman_1_N : N ; -- banktjänsteman..nn.1
  bankväsen_1_N : N ; -- bankväsen..nn.1
  bankväxel_1_N : N ; -- bankväxel..nn.1
  banlöpning_1_N : N ; -- banlöpning..nn.1
  bann_1_N : N ; -- bann..nn.1
  banna_1_V : V ; -- banna..vb.1
  bannande_1_N : N ; -- bannande..nn.1
  bannbulla_1_N : N ; -- bannbulla..nn.1
  bannlysa_1_V : V ; -- bannlysa..vb.1
  bannlysande_1_N : N ; -- bannlysande..nn.1
  bannlysning_1_N : N ; -- bannlysning..nn.1
  bannstråle_1_N : N ; -- bannstråle..nn.1
  bannät_1_N : N ; -- bannät..nn.1
  banrekord_1_N : N ; -- banrekord..nn.1
  banrörelse_1_N : N ; -- banrörelse..nn.1
  banskjutning_1_N : N ; -- banskjutning..nn.1
  banskytte_1_N : N ; -- banskytte..nn.1
  banta_1_V : V ; -- banta..vb.1
  banta_2_V : V ; -- banta..vb.2
  bantamvikt_1_N : N ; -- bantamvikt..nn.1
  bantamviktare_1_N : N ; -- bantamviktare..nn.1
  bantande_1_N : N ; -- bantande..nn.1
  bantlär_1_N : N ; -- bantlär..nn.1
  bantning_1_N : N ; -- bantning..nn.1
  bantningshysteri_1_N : N ; -- bantningshysteri..nn.1
  bantningskur_1_N : N ; -- bantningskur..nn.1
  bantningsmedel_1_N : N ; -- bantningsmedel..nn.1
  bantningspiller_1_N : N ; -- bantningspiller..nn.1
  bantufolk_1_N : N ; -- bantufolk..nn.1
  bantuspråk_1_N : N ; -- bantuspråk..nn.1
  banunderhåll_1_N : N ; -- banunderhåll..nn.1
  banvagn_1_N : N ; -- banvagn..nn.1
  banvakt_1_N : N ; -- banvakt..nn.1
  banvall_1_N : N ; -- banvall..nn.1
  banverk_1_N : N ; -- banverk..nn.1
  banverkspersonal_1_N : N ; -- banverkspersonal..nn.1
  baptism_1_N : N ; -- baptism..nn.1
  baptist_1_N : N ; -- baptist..nn.1
  baptistdop_1_N : N ; -- baptistdop..nn.1
  baptisterium_1_N : N ; -- baptisterium..nn.1
  baptistisk_1_A : A ; -- baptistisk..av.1
  baptistpastor_1_N : N ; -- baptistpastor..nn.1
  baptistpredikant_1_N : N ; -- baptistpredikant..nn.1
  bar_1_A : A ; -- bar..av.1
  bar_1_N : N ; -- bar..nn.1
  bar_2_N : N ; -- bar..nn.2
  bara_1_Adv : Adv ; -- bara..ab.1
  barack_1_N : N ; -- barack..nn.1
  barackläger_1_N : N ; -- barackläger..nn.1
  bararmad_1_A : A ; -- bararmad..av.1
  baraxlad_1_A : A ; -- baraxlad..av.1
  barbadier_1_N : N ; -- barbadier..nn.1
  barbadisk_1_A : A ; -- barbadisk..av.1
  barbadiska_1_N : N ; -- barbadiska..nn.1
  barbar_1_N : N ; -- barbar..nn.1
  barbarhövding_1_N : N ; -- barbarhövding..nn.1
  barbari_1_N : N ; -- barbari..nn.1
  barbarisk_1_A : A ; -- barbarisk..av.1
  barbarism_1_N : N ; -- barbarism..nn.1
  barbent_1_A : A ; -- barbent..av.1
  barberare_1_N : N ; -- barberare..nn.1
  barberarstol_1_N : N ; -- barberarstol..nn.1
  barbiturat_1_N : N ; -- barbiturat..nn.1
  barbröstad_1_A : A ; -- barbröstad..av.1
  bard_1_N : N ; -- bard..nn.1
  bardisan_1_N : N ; -- bardisan..nn.1
  bardisk_1_N : N ; -- bardisk..nn.1
  bardun_1_N : N ; -- bardun..nn.1
  bardval_1_N : N ; -- bardval..nn.1
  barett_1_N : N ; -- barett..nn.1
  barfota_1_A : A ; -- barfota..av.1
  barfotad_1_A : A ; -- barfotad..av.1
  barfotalasse_1_N : N ; -- barfotalasse..nn.1
  barfotaläkare_1_N : N ; -- barfotaläkare..nn.1
  barfotalöpning_1_N : N ; -- barfotalöpning..nn.1
  barfotamunk_1_N : N ; -- barfotamunk..nn.1
  barfrost_1_N : N ; -- barfrost..nn.1
  barhet_1_N : N ; -- barhet..nn.1
  barhuvad_1_A : A ; -- barhuvad..av.1
  barhänt_1_A : A ; -- barhänt..av.1
  bariton_1_N : N ; -- bariton..nn.1
  barium_1_N : N ; -- barium..nn.1
  bariumförening_1_N : N ; -- bariumförening..nn.1
  bariumsalt_1_N : N ; -- bariumsalt..nn.1
  bariumsulfat_1_N : N ; -- bariumsulfat..nn.1
  bark_1_N : N ; -- bark..nn.1
  bark_2_N : N ; -- bark..nn.2
  barka_1_V : V ; -- barka..vb.1
  barka_2_V : V ; -- barka..vb.2
  barkande_1_N : N ; -- barkande..nn.1
  barkaroll_1_N : N ; -- barkaroll..nn.1
  barkass_1_N : N ; -- barkass..nn.1
  barkborre_1_N : N ; -- barkborre..nn.1
  barkbröd_1_N : N ; -- barkbröd..nn.1
  barkbåt_1_N : N ; -- barkbåt..nn.1
  barkis_1_N : N ; -- barkis..nn.1
  barklag_1_N : N ; -- barklag..nn.1
  barkskepp_1_N : N ; -- barkskepp..nn.1
  barkspade_1_N : N ; -- barkspade..nn.1
  barktäkt_1_N : N ; -- barktäkt..nn.1
  barkund_1_N : N ; -- barkund..nn.1
  barkympa_1_V : V ; -- barkympa..vb.1
  barkympande_1_N : N ; -- barkympande..nn.1
  barlast_1_N : N ; -- barlast..nn.1
  barlasta_1_V : V ; -- barlasta..vb.1
  barlastande_1_N : N ; -- barlastande..nn.1
  barlastköl_1_N : N ; -- barlastköl..nn.1
  barlastning_1_N : N ; -- barlastning..nn.1
  barm_1_N : N ; -- barm..nn.1
  barmark_1_N : N ; -- barmark..nn.1
  barmhärtig_1_A : A ; -- barmhärtig..av.1
  barmhärtighet_1_N : N ; -- barmhärtighet..nn.1
  barmhärtighetsgärning_1_N : N ; -- barmhärtighetsgärning..nn.1
  barmhärtighetsmord_1_N : N ; -- barmhärtighetsmord..nn.1
  barmhärtighetsverk_1_N : N ; -- barmhärtighetsverk..nn.1
  barn_1_N : N ; -- barn..nn.1
  barnadödlighet_1_N : N ; -- barnadödlighet..nn.1
  barnafar_1_N : N ; -- barnafar..nn.1
  barnafödande_1_N : N ; -- barnafödande..nn.1
  barnaföderska_1_N : N ; -- barnaföderska..nn.1
  barnaga_1_N : N ; -- barnaga..nn.1
  barnahjärta_1_N : N ; -- barnahjärta..nn.1
  barnalstrande_1_N : N ; -- barnalstrande..nn.1
  barnamord_1_N : N ; -- barnamord..nn.1
  barnamördare_1_N : N ; -- barnamördare..nn.1
  barnansikte_1_N : N ; -- barnansikte..nn.1
  barnarbete_1_N : N ; -- barnarbete..nn.1
  barnarbetskraft_1_N : N ; -- barnarbetskraft..nn.1
  barnarov_1_N : N ; -- barnarov..nn.1
  barnasinne_1_N : N ; -- barnasinne..nn.1
  barnasjäl_1_N : N ; -- barnasjäl..nn.1
  barnaskara_1_N : N ; -- barnaskara..nn.1
  barnatro_1_N : N ; -- barnatro..nn.1
  barnavård_1_N : N ; -- barnavård..nn.1
  barnavårdscentral_1_N : N ; -- barnavårdscentral..nn.1
  barnavårdsman_1_N : N ; -- barnavårdsman..nn.1
  barnavårdsnämnd_1_N : N ; -- barnavårdsnämnd..nn.1
  barnbarn_1_N : N ; -- barnbarn..nn.1
  barnbarnsbarn_1_N : N ; -- barnbarnsbarn..nn.1
  barnbeck_1_N : N ; -- barnbeck..nn.1
  barnbegränsning_1_N : N ; -- barnbegränsning..nn.1
  barnbespisning_1_N : N ; -- barnbespisning..nn.1
  barnbesök_1_N : N ; -- barnbesök..nn.1
  barnbidrag_1_N : N ; -- barnbidrag..nn.1
  barnbok_1_N : N ; -- barnbok..nn.1
  barnboksfigur_1_N : N ; -- barnboksfigur..nn.1
  barnby_1_N : N ; -- barnby..nn.1
  barnbördshus_1_N : N ; -- barnbördshus..nn.1
  barncrosshjälm_1_N : N ; -- barncrosshjälm..nn.1
  barncykel_1_N : N ; -- barncykel..nn.1
  barndaghem_1_N : N ; -- barndaghem..nn.1
  barndom_1_N : N ; -- barndom..nn.1
  barndomsforskning_1_N : N ; -- barndomsforskning..nn.1
  barndomshem_1_N : N ; -- barndomshem..nn.1
  barndomskompis_1_N : N ; -- barndomskompis..nn.1
  barndomsminne_1_N : N ; -- barndomsminne..nn.1
  barndomsparadis_1_N : N ; -- barndomsparadis..nn.1
  barndomsstad_1_N : N ; -- barndomsstad..nn.1
  barndomstillstånd_1_N : N ; -- barndomstillstånd..nn.1
  barndomsupplevelse_1_N : N ; -- barndomsupplevelse..nn.1
  barndomsvän_1_N : N ; -- barndomsvän..nn.1
  barndop_1_N : N ; -- barndop..nn.1
  barndos_1_N : N ; -- barndos..nn.1
  barnfamilj_1_N : N ; -- barnfamilj..nn.1
  barnfattigdom_1_N : N ; -- barnfattigdom..nn.1
  barnfetma_1_N : N ; -- barnfetma..nn.1
  barnflicka_1_N : N ; -- barnflicka..nn.1
  barnfotomodell_1_N : N ; -- barnfotomodell..nn.1
  barnfödd_1_A : A ; -- barnfödd..av.1
  barnförbjuden_1_A : A ; -- barnförbjuden..av.1
  barnförbjudenhet_1_N : N ; -- barnförbjudenhet..nn.1
  barnförlamning_1_N : N ; -- barnförlamning..nn.1
  barngrupp_1_N : N ; -- barngrupp..nn.1
  barnhem_1_N : N ; -- barnhem..nn.1
  barnhemsbarn_1_N : N ; -- barnhemsbarn..nn.1
  barnhemsplacering_1_N : N ; -- barnhemsplacering..nn.1
  barnhus_1_N : N ; -- barnhus..nn.1
  barnhusbarn_1_N : N ; -- barnhusbarn..nn.1
  barnhuvud_1_N : N ; -- barnhuvud..nn.1
  barnjungfru_1_N : N ; -- barnjungfru..nn.1
  barnkalas_1_N : N ; -- barnkalas..nn.1
  barnkammare_1_N : N ; -- barnkammare..nn.1
  barnkammarfönster_1_N : N ; -- barnkammarfönster..nn.1
  barnkammarsaga_1_N : N ; -- barnkammarsaga..nn.1
  barnklinik_1_N : N ; -- barnklinik..nn.1
  barnknullare_1_N : N ; -- barnknullare..nn.1
  barnkoloni_1_N : N ; -- barnkoloni..nn.1
  barnkonvention_1_N : N ; -- barnkonvention..nn.1
  barnkorståg_1_N : N ; -- barnkorståg..nn.1
  barnkropp_1_N : N ; -- barnkropp..nn.1
  barnkär_1_A : A ; -- barnkär..av.1
  barnkör_1_N : N ; -- barnkör..nn.1
  barnledig_1_A : A ; -- barnledig..av.1
  barnledighet_1_N : N ; -- barnledighet..nn.1
  barnlek_1_N : N ; -- barnlek..nn.1
  barnläkare_1_N : N ; -- barnläkare..nn.1
  barnläkarskrå_1_N : N ; -- barnläkarskrå..nn.1
  barnlös_1_A : A ; -- barnlös..av.1
  barnlöshet_1_N : N ; -- barnlöshet..nn.1
  barnmat_1_N : N ; -- barnmat..nn.1
  barnmedicin_1_N : N ; -- barnmedicin..nn.1
  barnmedicin_2_N : N ; -- barnmedicin..nn.2
  barnmedicinsk_1_A : A ; -- barnmedicinsk..av.1
  barnmisshandel_1_N : N ; -- barnmisshandel..nn.1
  barnmorska_1_N : N ; -- barnmorska..nn.1
  barnneurolog_1_N : N ; -- barnneurolog..nn.1
  barnomsorg_1_N : N ; -- barnomsorg..nn.1
  barnomsorgsavgift_1_N : N ; -- barnomsorgsavgift..nn.1
  barnomsorgskostnad_1_N : N ; -- barnomsorgskostnad..nn.1
  barnparkering_1_N : N ; -- barnparkering..nn.1
  barnpassning_1_N : N ; -- barnpassning..nn.1
  barnpiga_1_N : N ; -- barnpiga..nn.1
  barnplågeri_1_N : N ; -- barnplågeri..nn.1
  barnpornografi_1_N : N ; -- barnpornografi..nn.1
  barnpornografisk_1_A : A ; -- barnpornografisk..av.1
  barnporr_1_N : N ; -- barnporr..nn.1
  barnporranklagad_1_A : A ; -- barnporranklagad..av.1
  barnporrhärva_1_N : N ; -- barnporrhärva..nn.1
  barnporrmål_1_N : N ; -- barnporrmål..nn.1
  barnprogram_1_N : N ; -- barnprogram..nn.1
  barnpsykiatri_1_N : N ; -- barnpsykiatri..nn.1
  barnpsykiatrisk_1_A : A ; -- barnpsykiatrisk..av.1
  barnrik_1_A : A ; -- barnrik..av.1
  barnrov_1_N : N ; -- barnrov..nn.1
  barnrättskämpe_1_N : N ; -- barnrättskämpe..nn.1
  barnröst_1_N : N ; -- barnröst..nn.1
  barnsaga_1_N : N ; -- barnsaga..nn.1
  barnsak_1_N : N ; -- barnsak..nn.1
  barnsbörd_1_N : N ; -- barnsbörd..nn.1
  barnsjukdom_1_N : N ; -- barnsjukdom..nn.1
  barnsjukhus_1_N : N ; -- barnsjukhus..nn.1
  barnsko_1_N : N ; -- barnsko..nn.1
  barnskottkärra_1_N : N ; -- barnskottkärra..nn.1
  barnskratt_1_N : N ; -- barnskratt..nn.1
  barnskrik_1_N : N ; -- barnskrik..nn.1
  barnskötare_1_N : N ; -- barnskötare..nn.1
  barnskötarlinje_1_N : N ; -- barnskötarlinje..nn.1
  barnsköterska_1_N : N ; -- barnsköterska..nn.1
  barnslig_1_A : A ; -- barnslig..av.1
  barnslighet_1_N : N ; -- barnslighet..nn.1
  barnsmugglare_1_N : N ; -- barnsmugglare..nn.1
  barnsmugglarliga_1_N : N ; -- barnsmugglarliga..nn.1
  barnsmuggling_1_N : N ; -- barnsmuggling..nn.1
  barnsnor_1_N : N ; -- barnsnor..nn.1
  barnsnöd_1_N : N ; -- barnsnöd..nn.1
  barnsoldat_1_N : N ; -- barnsoldat..nn.1
  barnspråk_1_N : N ; -- barnspråk..nn.1
  barnstuga_1_N : N ; -- barnstuga..nn.1
  barnsäker_1_A : A ; -- barnsäker..av.1
  barnsäkerhet_1_N : N ; -- barnsäkerhet..nn.1
  barnsäng_1_N : N ; -- barnsäng..nn.1
  barnsängsfeber_1_N : N ; -- barnsängsfeber..nn.1
  barnsängskvinna_1_N : N ; -- barnsängskvinna..nn.1
  barnteckning_1_N : N ; -- barnteckning..nn.1
  barntillsyn_1_N : N ; -- barntillsyn..nn.1
  barntillåten_1_A : A ; -- barntillåten..av.1
  barntillåtenhet_1_N : N ; -- barntillåtenhet..nn.1
  barntoalett_1_N : N ; -- barntoalett..nn.1
  barnunge_1_N : N ; -- barnunge..nn.1
  barnvagn_1_N : N ; -- barnvagn..nn.1
  barnvakt_1_N : N ; -- barnvakt..nn.1
  barnvattenkanna_1_N : N ; -- barnvattenkanna..nn.1
  barnvisa_1_N : N ; -- barnvisa..nn.1
  barnvälgörenhetsorganisation_1_N : N ; -- barnvälgörenhetsorganisation..nn.1
  barnvänlig_1_A : A ; -- barnvänlig..av.1
  barock_1_A : A ; -- barock..av.1
  barock_1_N : N ; -- barock..nn.1
  barockkonst_1_N : N ; -- barockkonst..nn.1
  barocklyrik_1_N : N ; -- barocklyrik..nn.1
  barockmusik_1_N : N ; -- barockmusik..nn.1
  barockmässig_1_A : A ; -- barockmässig..av.1
  barockmålare_1_N : N ; -- barockmålare..nn.1
  barockpalats_1_N : N ; -- barockpalats..nn.1
  barockpärla_1_N : N ; -- barockpärla..nn.1
  barockstil_1_N : N ; -- barockstil..nn.1
  barograf_1_N : N ; -- barograf..nn.1
  barogram_1_N : N ; -- barogram..nn.1
  barometer_1_N : N ; -- barometer..nn.1
  barometerfall_1_N : N ; -- barometerfall..nn.1
  barometerstånd_1_N : N ; -- barometerstånd..nn.1
  barometrisk_1_A : A ; -- barometrisk..av.1
  baron_1_N : N ; -- baron..nn.1
  baronessa_1_N : N ; -- baronessa..nn.1
  barospirator_1_N : N ; -- barospirator..nn.1
  barr_1_N : N ; -- barr..nn.1
  barr_2_N : N ; -- barr..nn.2
  barra_1_V : V ; -- barra..vb.1
  barrande_1_N : N ; -- barrande..nn.1
  barrdoft_1_N : N ; -- barrdoft..nn.1
  barre_1_N : N ; -- barre..nn.1
  barrig_1_A : A ; -- barrig..av.1
  barrikad_1_N : N ; -- barrikad..nn.1
  barrikadera_1_V : V ; -- barrikadera..vb.1
  barrikaderande_1_N : N ; -- barrikaderande..nn.1
  barrikaderbar_1_A : A ; -- barrikaderbar..av.1
  barrikaderbarhet_1_N : N ; -- barrikaderbarhet..nn.1
  barrikadering_1_N : N ; -- barrikadering..nn.1
  barrikadkämpe_1_N : N ; -- barrikadkämpe..nn.1
  barrikadstrid_1_N : N ; -- barrikadstrid..nn.1
  barriär_1_N : N ; -- barriär..nn.1
  barriärrev_1_N : N ; -- barriärrev..nn.1
  barrskog_1_N : N ; -- barrskog..nn.1
  barrskogsgräns_1_N : N ; -- barrskogsgräns..nn.1
  barrskogsnunna_1_N : N ; -- barrskogsnunna..nn.1
  barrskogsregion_1_N : N ; -- barrskogsregion..nn.1
  barrskogstäckt_1_A : A ; -- barrskogstäckt..av.1
  barrträd_1_N : N ; -- barrträd..nn.1
  barrträdskotte_1_N : N ; -- barrträdskotte..nn.1
  barrträdsplanta_1_N : N ; -- barrträdsplanta..nn.1
  barrträdssort_1_N : N ; -- barrträdssort..nn.1
  barrved_1_N : N ; -- barrved..nn.1
  barservering_1_N : N ; -- barservering..nn.1
  barsk_1_A : A ; -- barsk..av.1
  barskhet_1_N : N ; -- barskhet..nn.1
  barskrapad_1_A : A ; -- barskrapad..av.1
  barskåp_1_N : N ; -- barskåp..nn.1
  barstol_1_N : N ; -- barstol..nn.1
  bartender_1_N : N ; -- bartender..nn.1
  barvinter_1_N : N ; -- barvinter..nn.1
  barysfär_1_N : N ; -- barysfär..nn.1
  baryt_1_N : N ; -- baryt..nn.1
  baryton_1_N : N ; -- baryton..nn.1
  bas_1_N : N ; -- bas..nn.1
  bas_2_N : N ; -- bas..nn.2
  bas_3_N : N ; -- bas..nn.3
  bas_4_N : N ; -- bas..nn.4
  basa_1_V : V ; -- basa..vb.1
  basal_1_A : A ; -- basal..av.1
  basalt_1_N : N ; -- basalt..nn.1
  basande_1_N : N ; -- basande..nn.1
  basar_1_N : N ; -- basar..nn.1
  basbelopp_1_N : N ; -- basbelopp..nn.1
  baseball_1_N : N ; -- baseball..nn.1
  baseballsträ_1_N : N ; -- baseballsträ..nn.1
  baseballträ_1_N : N ; -- baseballträ..nn.1
  baseboll_1_N : N ; -- baseboll..nn.1
  baseboll_2_N : N ; -- baseboll..nn.2
  basebollsträ_1_N : N ; -- basebollsträ..nn.1
  basebollträ_1_N : N ; -- basebollträ..nn.1
  basedow_1_N : N ; -- basedow..nn.1
  basenhet_1_N : N ; -- basenhet..nn.1
  basera_1_V : V ; -- basera..vb.1
  baserande_1_N : N ; -- baserande..nn.1
  baserbar_1_A : A ; -- baserbar..av.1
  baserbarhet_1_N : N ; -- baserbarhet..nn.1
  basering_1_N : N ; -- basering..nn.1
  basfiol_1_N : N ; -- basfiol..nn.1
  basfiolsfodral_1_N : N ; -- basfiolsfodral..nn.1
  basfiolsfodralsmakare_1_N : N ; -- basfiolsfodralsmakare..nn.1
  basfiolsfodralsmakaregesäll_1_N : N ; -- basfiolsfodralsmakaregesäll..nn.1
  basfärdighet_1_N : N ; -- basfärdighet..nn.1
  basföda_1_N : N ; -- basföda..nn.1
  basgitarr_1_N : N ; -- basgitarr..nn.1
  basilika_1_N : N ; -- basilika..nn.1
  basilisk_1_N : N ; -- basilisk..nn.1
  basis_1_N : N ; -- basis..nn.1
  basisk_1_A : A ; -- basisk..av.1
  basist_1_N : N ; -- basist..nn.1
  bask_1_N : N ; -- bask..nn.1
  basker_1_N : N ; -- basker..nn.1
  basket_1_N : N ; -- basket..nn.1
  basketboll_1_N : N ; -- basketboll..nn.1
  basketboll_2_N : N ; -- basketboll..nn.2
  basketproffs_1_N : N ; -- basketproffs..nn.1
  baskisk_1_A : A ; -- baskisk..av.1
  baskiska_1_N : N ; -- baskiska..nn.1
  baskiska_2_N : N ; -- baskiska..nn.2
  basklarinett_1_N : N ; -- basklarinett..nn.1
  basklav_1_N : N ; -- basklav..nn.1
  baslinje_1_N : N ; -- baslinje..nn.1
  basläger_1_N : N ; -- basläger..nn.1
  basning_1_N : N ; -- basning..nn.1
  basnot_1_N : N ; -- basnot..nn.1
  basorganisation_1_N : N ; -- basorganisation..nn.1
  baspar_1_N : N ; -- baspar..nn.1
  basparti_1_N : N ; -- basparti..nn.1
  basplatta_1_N : N ; -- basplatta..nn.1
  basrelief_1_N : N ; -- basrelief..nn.1
  basrelieftavla_1_N : N ; -- basrelieftavla..nn.1
  basröst_1_N : N ; -- basröst..nn.1
  basse_1_N : N ; -- basse..nn.1
  basset_1_N : N ; -- basset..nn.1
  bassetthorn_1_N : N ; -- bassetthorn..nn.1
  bassning_1_N : N ; -- bassning..nn.1
  basstation_1_N : N ; -- basstation..nn.1
  bassträcka_1_N : N ; -- bassträcka..nn.1
  bassträng_1_N : N ; -- bassträng..nn.1
  basstämma_1_N : N ; -- basstämma..nn.1
  bassäng_1_N : N ; -- bassäng..nn.1
  bassångare_1_N : N ; -- bassångare..nn.1
  bast_1_N : N ; -- bast..nn.1
  bast_2_N : N ; -- bast..nn.2
  basta_1_V : V ; -- basta..vb.1
  bastande_1_N : N ; -- bastande..nn.1
  bastant_1_A : A ; -- bastant..av.1
  bastanthet_1_N : N ; -- bastanthet..nn.1
  bastard_1_N : N ; -- bastard..nn.1
  bastardform_1_N : N ; -- bastardform..nn.1
  bastardnäktergal_1_N : N ; -- bastardnäktergal..nn.1
  bastcell_1_N : N ; -- bastcell..nn.1
  bastfiber_1_N : N ; -- bastfiber..nn.1
  bastingering_1_N : N ; -- bastingering..nn.1
  bastion_1_N : N ; -- bastion..nn.1
  bastkjol_1_N : N ; -- bastkjol..nn.1
  bastmatta_1_N : N ; -- bastmatta..nn.1
  baston_1_N : N ; -- baston..nn.1
  bastonad_1_N : N ; -- bastonad..nn.1
  bastrep_1_N : N ; -- bastrep..nn.1
  bastrumma_1_N : N ; -- bastrumma..nn.1
  bastu_1_N : N ; -- bastu..nn.1
  bastuaggregat_1_N : N ; -- bastuaggregat..nn.1
  bastuba_1_N : N ; -- bastuba..nn.1
  bastubad_1_N : N ; -- bastubad..nn.1
  bastuförening_1_N : N ; -- bastuförening..nn.1
  bastuklubb_1_N : N ; -- bastuklubb..nn.1
  bastuugn_1_N : N ; -- bastuugn..nn.1
  bastuvärme_1_N : N ; -- bastuvärme..nn.1
  basun_1_N : N ; -- basun..nn.1
  basunblåsande_1_N : N ; -- basunblåsande..nn.1
  basunist_1_N : N ; -- basunist..nn.1
  basunklang_1_N : N ; -- basunklang..nn.1
  basunregister_1_N : N ; -- basunregister..nn.1
  basunstöt_1_N : N ; -- basunstöt..nn.1
  basvara_1_N : N ; -- basvara..nn.1
  basvinkel_1_N : N ; -- basvinkel..nn.1
  basväg_1_N : N ; -- basväg..nn.1
  basyta_1_N : N ; -- basyta..nn.1
  basår_1_N : N ; -- basår..nn.1
  batalj_1_N : N ; -- batalj..nn.1
  bataljmålare_1_N : N ; -- bataljmålare..nn.1
  bataljmålning_1_N : N ; -- bataljmålning..nn.1
  bataljon_1_N : N ; -- bataljon..nn.1
  bataljonsadjutant_1_N : N ; -- bataljonsadjutant..nn.1
  bataljonschef_1_N : N ; -- bataljonschef..nn.1
  bataljonsvis_1_Adv : Adv ; -- bataljonsvis..ab.1
  batat_1_N : N ; -- batat..nn.1
  batik_1_N : N ; -- batik..nn.1
  batist_1_N : N ; -- batist..nn.1
  batong_1_N : N ; -- batong..nn.1
  batongslag_1_N : N ; -- batongslag..nn.1
  batongstånd_1_N : N ; -- batongstånd..nn.1
  batongsvingande_1_A : A ; -- batongsvingande..av.1
  batongsvingande_1_N : N ; -- batongsvingande..nn.1
  batteri_1_N : N ; -- batteri..nn.1
  batteridrift_1_N : N ; -- batteridrift..nn.1
  batteridriven_1_A : A ; -- batteridriven..av.1
  batterield_1_N : N ; -- batterield..nn.1
  batteriklämma_1_N : N ; -- batteriklämma..nn.1
  batteriladdare_1_N : N ; -- batteriladdare..nn.1
  batteriladdning_1_N : N ; -- batteriladdning..nn.1
  batteriprovare_1_N : N ; -- batteriprovare..nn.1
  batteriradio_1_N : N ; -- batteriradio..nn.1
  batterisekatör_1_N : N ; -- batterisekatör..nn.1
  batterist_1_N : N ; -- batterist..nn.1
  batteritändning_1_N : N ; -- batteritändning..nn.1
  batting_1_N : N ; -- batting..nn.1
  batysfär_1_N : N ; -- batysfär..nn.1
  baud_1_N : N ; -- baud..nn.1
  bautasten_1_N : N ; -- bautasten..nn.1
  bauxit_1_N : N ; -- bauxit..nn.1
  baxa_1_V : V ; -- baxa..vb.1
  baxande_1_N : N ; -- baxande..nn.1
  baxna_1_V : V ; -- baxna..vb.1
  baxnande_1_N : N ; -- baxnande..nn.1
  bayersk_1_A : A ; -- bayersk..av.1
  bazooka_1_N : N ; -- bazooka..nn.1
  be_1_V : V ; -- be..vb.1
  bea_1_N : N ; -- bea..nn.1
  beagle_1_N : N ; -- beagle..nn.1
  beakta_1_V : V ; -- beakta..vb.1
  beaktande_1_N : N ; -- beaktande..nn.1
  beaktansvärd_1_A : A ; -- beaktansvärd..av.1
  bearbeta_1_V : V ; -- bearbeta..vb.1
  bearbetande_1_N : N ; -- bearbetande..nn.1
  bearbetare_1_N : N ; -- bearbetare..nn.1
  bearbetning_1_N : N ; -- bearbetning..nn.1
  bearnaise_1_N : N ; -- bearnaise..nn.1
  bearnaisesås_1_N : N ; -- bearnaisesås..nn.1
  bearnäs_1_N : N ; -- bearnäs..nn.1
  bearnässås_1_N : N ; -- bearnässås..nn.1
  beatifiera_1_V : V ; -- beatifiera..vb.1
  beatifierande_1_N : N ; -- beatifierande..nn.1
  beatifierbar_1_A : A ; -- beatifierbar..av.1
  beatifierbarhet_1_N : N ; -- beatifierbarhet..nn.1
  beatifiering_1_N : N ; -- beatifiering..nn.1
  beatnik_1_N : N ; -- beatnik..nn.1
  bebis_1_N : N ; -- bebis..nn.1
  beblandande_1_N : N ; -- beblandande..nn.1
  beblandelse_1_N : N ; -- beblandelse..nn.1
  bebo_1_V : V ; -- bebo..vb.1
  bebodd_1_A : A ; -- bebodd..av.1
  beboelig_1_A : A ; -- beboelig..av.1
  beboelighet_1_N : N ; -- beboelighet..nn.1
  beboende_1_N : N ; -- beboende..nn.1
  bebolig_1_A : A ; -- bebolig..av.1
  bebolighet_1_N : N ; -- bebolighet..nn.1
  bebop_1_N : N ; -- bebop..nn.1
  bebygga_1_V : V ; -- bebygga..vb.1
  bebyggande_1_N : N ; -- bebyggande..nn.1
  bebyggare_1_N : N ; -- bebyggare..nn.1
  bebyggelse_1_N : N ; -- bebyggelse..nn.1
  bebyggelsenamn_1_N : N ; -- bebyggelsenamn..nn.1
  bebåda_1_V : V ; -- bebåda..vb.1
  bebådande_1_N : N ; -- bebådande..nn.1
  bebådelse_1_N : N ; -- bebådelse..nn.1
  bebådelsedag_1_N : N ; -- bebådelsedag..nn.1
  bebådning_1_N : N ; -- bebådning..nn.1
  becherovka_1_N : N ; -- becherovka..nn.1
  beck_1_N : N ; -- beck..nn.1
  becka_1_V : V ; -- becka..vb.1
  beckande_1_N : N ; -- beckande..nn.1
  beckasin_1_N : N ; -- beckasin..nn.1
  beckig_1_A : A ; -- beckig..av.1
  beckighet_1_N : N ; -- beckighet..nn.1
  beckmörk_1_A : A ; -- beckmörk..av.1
  beckmörker_1_N : N ; -- beckmörker..nn.1
  beckpärla_1_N : N ; -- beckpärla..nn.1
  becksvart_1_A : A ; -- becksvart..av.1
  becquerel_1_N : N ; -- becquerel..nn.1
  bedagad_1_A : A ; -- bedagad..av.1
  bedarra_1_V : V ; -- bedarra..vb.1
  bedarrande_1_N : N ; -- bedarrande..nn.1
  bedarrning_1_N : N ; -- bedarrning..nn.1
  bedjande_1_A : A ; -- bedjande..av.1
  bedjande_1_N : N ; -- bedjande..nn.1
  bedra_1_V : V ; -- bedra..vb.1
  bedragande_1_N : N ; -- bedragande..nn.1
  bedragare_1_N : N ; -- bedragare..nn.1
  bedragerska_1_N : N ; -- bedragerska..nn.1
  bedrift_1_N : N ; -- bedrift..nn.1
  bedriva_1_V : V ; -- bedriva..vb.1
  bedrivande_1_N : N ; -- bedrivande..nn.1
  bedrägeri_1_N : N ; -- bedrägeri..nn.1
  bedrägeribrott_1_N : N ; -- bedrägeribrott..nn.1
  bedrägerirotel_1_N : N ; -- bedrägerirotel..nn.1
  bedräglig_1_A : A ; -- bedräglig..av.1
  bedräglighet_1_N : N ; -- bedräglighet..nn.1
  bedröva_1_V : V ; -- bedröva..vb.1
  bedrövad_1_A : A ; -- bedrövad..av.1
  bedrövande_1_N : N ; -- bedrövande..nn.1
  bedrövelse_1_N : N ; -- bedrövelse..nn.1
  bedrövlig_1_A : A ; -- bedrövlig..av.1
  bedrövlighet_1_N : N ; -- bedrövlighet..nn.1
  beduin_1_N : N ; -- beduin..nn.1
  bedyra_1_V : V ; -- bedyra..vb.1
  bedyrande_1_N : N ; -- bedyrande..nn.1
  bedåra_1_V : V ; -- bedåra..vb.1
  bedårande_1_A : A ; -- bedårande..av.1
  bedårande_1_N : N ; -- bedårande..nn.1
  bedöma_1_V : V ; -- bedöma..vb.1
  bedömande_1_N : N ; -- bedömande..nn.1
  bedömare_1_N : N ; -- bedömare..nn.1
  bedömning_1_N : N ; -- bedömning..nn.1
  bedöva_1_V : V ; -- bedöva..vb.1
  bedövande_1_N : N ; -- bedövande..nn.1
  bedövning_1_N : N ; -- bedövning..nn.1
  bedövningsmedel_1_N : N ; -- bedövningsmedel..nn.1
  beediga_1_V : V ; -- beediga..vb.1
  beedigande_1_N : N ; -- beedigande..nn.1
  beende_1_A : A ; -- beende..av.1
  beende_1_N : N ; -- beende..nn.1
  befalla_1_V : V ; -- befalla..vb.1
  befallande_1_A : A ; -- befallande..av.1
  befallande_1_N : N ; -- befallande..nn.1
  befallning_1_N : N ; -- befallning..nn.1
  befallningshavande_1_N : N ; -- befallningshavande..nn.1
  befallningsman_1_N : N ; -- befallningsman..nn.1
  befara_1_V : V ; -- befara..vb.1
  befara_2_V : V ; -- befara..vb.2
  befarande_1_N : N ; -- befarande..nn.1
  befaren_1_A : A ; -- befaren..av.1
  befattning_1_N : N ; -- befattning..nn.1
  befattningshavare_1_N : N ; -- befattningshavare..nn.1
  befattningsmässig_1_A : A ; -- befattningsmässig..av.1
  befinna_1_V : V ; -- befinna..vb.1
  befinnande_1_N : N ; -- befinnande..nn.1
  befintlig_1_A : A ; -- befintlig..av.1
  befintlighet_1_N : N ; -- befintlighet..nn.1
  befjädrad_1_A : A ; -- befjädrad..av.1
  befjädring_1_N : N ; -- befjädring..nn.1
  befläcka_1_V : V ; -- befläcka..vb.1
  befläckande_1_N : N ; -- befläckande..nn.1
  befläckelse_1_N : N ; -- befläckelse..nn.1
  befogad_1_A : A ; -- befogad..av.1
  befogenhet_1_N : N ; -- befogenhet..nn.1
  befogenhetsförskjutning_1_N : N ; -- befogenhetsförskjutning..nn.1
  befolka_1_V : V ; -- befolka..vb.1
  befolkande_1_N : N ; -- befolkande..nn.1
  befolkning_1_N : N ; -- befolkning..nn.1
  befolkningsexplosion_1_N : N ; -- befolkningsexplosion..nn.1
  befolkningsgrupp_1_N : N ; -- befolkningsgrupp..nn.1
  befolkningsmässig_1_A : A ; -- befolkningsmässig..av.1
  befolkningspolitik_1_N : N ; -- befolkningspolitik..nn.1
  befolkningspolitisk_1_A : A ; -- befolkningspolitisk..av.1
  befolkningspyramid_1_N : N ; -- befolkningspyramid..nn.1
  befolkningsstatistik_1_N : N ; -- befolkningsstatistik..nn.1
  befolkningstillväxt_1_N : N ; -- befolkningstillväxt..nn.1
  befolkningsundersökning_1_N : N ; -- befolkningsundersökning..nn.1
  befolkningsökning_1_N : N ; -- befolkningsökning..nn.1
  befordra_1_V : V ; -- befordra..vb.1
  befordran_1_N : N ; -- befordran..nn.1
  befordrande_1_N : N ; -- befordrande..nn.1
  befordrare_1_N : N ; -- befordrare..nn.1
  befordring_1_N : N ; -- befordring..nn.1
  befordringsgrund_1_N : N ; -- befordringsgrund..nn.1
  befordringsgång_1_N : N ; -- befordringsgång..nn.1
  befrakta_1_V : V ; -- befrakta..vb.1
  befraktande_1_N : N ; -- befraktande..nn.1
  befraktare_1_N : N ; -- befraktare..nn.1
  befraktning_1_N : N ; -- befraktning..nn.1
  befransad_1_A : A ; -- befransad..av.1
  befria_1_V : V ; -- befria..vb.1
  befriande_1_A : A ; -- befriande..av.1
  befriande_1_N : N ; -- befriande..nn.1
  befriare_1_N : N ; -- befriare..nn.1
  befrielse_1_N : N ; -- befrielse..nn.1
  befrielseakt_1_N : N ; -- befrielseakt..nn.1
  befrielsearmé_1_N : N ; -- befrielsearmé..nn.1
  befrielsefront_1_N : N ; -- befrielsefront..nn.1
  befrielsekamp_1_N : N ; -- befrielsekamp..nn.1
  befrielsekrig_1_N : N ; -- befrielsekrig..nn.1
  befrielserörelse_1_N : N ; -- befrielserörelse..nn.1
  befrukta_1_V : V ; -- befrukta..vb.1
  befruktande_1_N : N ; -- befruktande..nn.1
  befruktning_1_N : N ; -- befruktning..nn.1
  befruktningsorgan_1_N : N ; -- befruktningsorgan..nn.1
  befruktningsögonblick_1_N : N ; -- befruktningsögonblick..nn.1
  befrynda_1_V : V ; -- befrynda..vb.1
  befryndad_1_A : A ; -- befryndad..av.1
  befryndande_1_N : N ; -- befryndande..nn.1
  befrämja_1_V : V ; -- befrämja..vb.1
  befrämjande_1_N : N ; -- befrämjande..nn.1
  befrämjare_1_N : N ; -- befrämjare..nn.1
  befullmäktiga_1_V : V ; -- befullmäktiga..vb.1
  befullmäktigande_1_N : N ; -- befullmäktigande..nn.1
  befäl_1_N : N ; -- befäl..nn.1
  befäl_2_N : N ; -- befäl..nn.2
  befälhavande_1_A : A ; -- befälhavande..av.1
  befälhavare_1_N : N ; -- befälhavare..nn.1
  befälselev_1_N : N ; -- befälselev..nn.1
  befälsföring_1_N : N ; -- befälsföring..nn.1
  befälsgrad_1_N : N ; -- befälsgrad..nn.1
  befälsordning_1_N : N ; -- befälsordning..nn.1
  befälsperson_1_N : N ; -- befälsperson..nn.1
  befälsställning_1_N : N ; -- befälsställning..nn.1
  befälstalang_1_N : N ; -- befälstalang..nn.1
  befälstecken_1_N : N ; -- befälstecken..nn.1
  befälsuppdrag_1_N : N ; -- befälsuppdrag..nn.1
  befängd_1_A : A ; -- befängd..av.1
  befängdhet_1_N : N ; -- befängdhet..nn.1
  befästa_1_V : V ; -- befästa..vb.1
  befästande_1_N : N ; -- befästande..nn.1
  befästning_1_N : N ; -- befästning..nn.1
  befästningsgrav_1_N : N ; -- befästningsgrav..nn.1
  befästningskonst_1_N : N ; -- befästningskonst..nn.1
  befästningslinje_1_N : N ; -- befästningslinje..nn.1
  befästningsskydd_1_N : N ; -- befästningsskydd..nn.1
  befästningsverk_1_N : N ; -- befästningsverk..nn.1
  begabba_1_V : V ; -- begabba..vb.1
  begabbande_1_N : N ; -- begabbande..nn.1
  begabbare_1_N : N ; -- begabbare..nn.1
  begabberi_1_N : N ; -- begabberi..nn.1
  begagna_1_V : V ; -- begagna..vb.1
  begagnad_1_A : A ; -- begagnad..av.1
  begagnande_1_N : N ; -- begagnande..nn.1
  begagnatköp_1_N : N ; -- begagnatköp..nn.1
  begapa_1_V : V ; -- begapa..vb.1
  begapande_1_N : N ; -- begapande..nn.1
  begapning_1_N : N ; -- begapning..nn.1
  begeistrad_1_A : A ; -- begeistrad..av.1
  begeistring_1_N : N ; -- begeistring..nn.1
  beginerå_1_N : N ; -- beginerå..nn.1
  begivande_1_N : N ; -- begivande..nn.1
  begiven_1_A : A ; -- begiven..av.1
  begivenhet_1_N : N ; -- begivenhet..nn.1
  begivenhet_2_N : N ; -- begivenhet..nn.2
  begjuta_1_V : V ; -- begjuta..vb.1
  begjutande_1_N : N ; -- begjutande..nn.1
  begjutning_1_N : N ; -- begjutning..nn.1
  beglänsa_1_V : V ; -- beglänsa..vb.1
  beglänsande_1_N : N ; -- beglänsande..nn.1
  beglänsning_1_N : N ; -- beglänsning..nn.1
  begonia_1_N : N ; -- begonia..nn.1
  begrava_1_V : V ; -- begrava..vb.1
  begravande_1_N : N ; -- begravande..nn.1
  begravning_1_N : N ; -- begravning..nn.1
  begravningsakt_1_N : N ; -- begravningsakt..nn.1
  begravningsbok_1_N : N ; -- begravningsbok..nn.1
  begravningsbyrå_1_N : N ; -- begravningsbyrå..nn.1
  begravningsceremoni_1_N : N ; -- begravningsceremoni..nn.1
  begravningsdag_1_N : N ; -- begravningsdag..nn.1
  begravningsentreprenör_1_N : N ; -- begravningsentreprenör..nn.1
  begravningsgäst_1_N : N ; -- begravningsgäst..nn.1
  begravningshjälp_1_N : N ; -- begravningshjälp..nn.1
  begravningshögtidlighet_1_N : N ; -- begravningshögtidlighet..nn.1
  begravningskalas_1_N : N ; -- begravningskalas..nn.1
  begravningskassa_1_N : N ; -- begravningskassa..nn.1
  begravningskrans_1_N : N ; -- begravningskrans..nn.1
  begravningsmarsch_1_N : N ; -- begravningsmarsch..nn.1
  begravningsmin_1_N : N ; -- begravningsmin..nn.1
  begravningsplats_1_N : N ; -- begravningsplats..nn.1
  begravningspoesi_1_N : N ; -- begravningspoesi..nn.1
  begravningsprocession_1_N : N ; -- begravningsprocession..nn.1
  begravningspsalm_1_N : N ; -- begravningspsalm..nn.1
  begravningsringning_1_N : N ; -- begravningsringning..nn.1
  begravningsspel_1_N : N ; -- begravningsspel..nn.1
  begravningståg_1_N : N ; -- begravningståg..nn.1
  begrepp_1_N : N ; -- begrepp..nn.1
  begreppsanalys_1_N : N ; -- begreppsanalys..nn.1
  begreppsanalytisk_1_A : A ; -- begreppsanalytisk..av.1
  begreppsapparat_1_N : N ; -- begreppsapparat..nn.1
  begreppsbestämning_1_N : N ; -- begreppsbestämning..nn.1
  begreppsbildning_1_N : N ; -- begreppsbildning..nn.1
  begreppsexercis_1_N : N ; -- begreppsexercis..nn.1
  begreppsförvirring_1_N : N ; -- begreppsförvirring..nn.1
  begreppsindelning_1_N : N ; -- begreppsindelning..nn.1
  begreppsinnehåll_1_N : N ; -- begreppsinnehåll..nn.1
  begreppslig_1_A : A ; -- begreppslig..av.1
  begreppslighet_1_N : N ; -- begreppslighet..nn.1
  begreppsmässig_1_A : A ; -- begreppsmässig..av.1
  begreppsmässighet_1_N : N ; -- begreppsmässighet..nn.1
  begreppsnivå_1_N : N ; -- begreppsnivå..nn.1
  begreppssystem_1_N : N ; -- begreppssystem..nn.1
  begripa_1_V : V ; -- begripa..vb.1
  begripande_1_N : N ; -- begripande..nn.1
  begriplig_1_A : A ; -- begriplig..av.1
  begriplighet_1_N : N ; -- begriplighet..nn.1
  begrunda_1_V : V ; -- begrunda..vb.1
  begrundande_1_N : N ; -- begrundande..nn.1
  begränsa_1_V : V ; -- begränsa..vb.1
  begränsad_1_A : A ; -- begränsad..av.1
  begränsande_1_N : N ; -- begränsande..nn.1
  begränsning_1_N : N ; -- begränsning..nn.1
  begränsningslinje_1_N : N ; -- begränsningslinje..nn.1
  begränsningsyta_1_N : N ; -- begränsningsyta..nn.1
  begråta_1_V : V ; -- begråta..vb.1
  begråtande_1_N : N ; -- begråtande..nn.1
  begynna_1_V : V ; -- begynna..vb.1
  begynnande_1_N : N ; -- begynnande..nn.1
  begynnelse_1_N : N ; -- begynnelse..nn.1
  begynnelsebokstav_1_N : N ; -- begynnelsebokstav..nn.1
  begynnelsehastighet_1_N : N ; -- begynnelsehastighet..nn.1
  begynnelselön_1_N : N ; -- begynnelselön..nn.1
  begynnelserim_1_N : N ; -- begynnelserim..nn.1
  begynnelseskede_1_N : N ; -- begynnelseskede..nn.1
  begynnelsespråk_1_N : N ; -- begynnelsespråk..nn.1
  begynnelsestadium_1_N : N ; -- begynnelsestadium..nn.1
  begynnelsevärde_1_N : N ; -- begynnelsevärde..nn.1
  begär_1_N : N ; -- begär..nn.1
  begära_1_V : V ; -- begära..vb.1
  begärande_1_N : N ; -- begärande..nn.1
  begärelse_1_N : N ; -- begärelse..nn.1
  begärlig_1_A : A ; -- begärlig..av.1
  begärlighet_1_N : N ; -- begärlighet..nn.1
  begärsliv_1_N : N ; -- begärsliv..nn.1
  begå_1_V : V ; -- begå..vb.1
  begående_1_N : N ; -- begående..nn.1
  begåva_1_V : V ; -- begåva..vb.1
  begåvad_1_A : A ; -- begåvad..av.1
  begåvande_1_N : N ; -- begåvande..nn.1
  begåvning_1_N : N ; -- begåvning..nn.1
  begåvning_2_N : N ; -- begåvning..nn.2
  begåvningsmässig_1_A : A ; -- begåvningsmässig..av.1
  begåvningsreserv_1_N : N ; -- begåvningsreserv..nn.1
  behag_1_N : N ; -- behag..nn.1
  behaga_1_V : V ; -- behaga..vb.1
  behagande_1_N : N ; -- behagande..nn.1
  behagfull_1_A : A ; -- behagfull..av.1
  behagfullhet_1_N : N ; -- behagfullhet..nn.1
  behaglig_1_A : A ; -- behaglig..av.1
  behaglighet_1_N : N ; -- behaglighet..nn.1
  behagsjuk_1_A : A ; -- behagsjuk..av.1
  behagsjuka_1_N : N ; -- behagsjuka..nn.1
  behagsjukhet_1_N : N ; -- behagsjukhet..nn.1
  behandla_1_V : V ; -- behandla..vb.1
  behandlande_1_N : N ; -- behandlande..nn.1
  behandling_1_N : N ; -- behandling..nn.1
  behandlingsalternativ_1_N : N ; -- behandlingsalternativ..nn.1
  behandlingsbar_1_A : A ; -- behandlingsbar..av.1
  behandlingsbarhet_1_N : N ; -- behandlingsbarhet..nn.1
  behandlingsenhet_1_N : N ; -- behandlingsenhet..nn.1
  behandlingshem_1_N : N ; -- behandlingshem..nn.1
  behandlingsmetod_1_N : N ; -- behandlingsmetod..nn.1
  behandlingsmässig_1_A : A ; -- behandlingsmässig..av.1
  behandlingsprogram_1_N : N ; -- behandlingsprogram..nn.1
  behandlingsrum_1_N : N ; -- behandlingsrum..nn.1
  behandlingssätt_1_N : N ; -- behandlingssätt..nn.1
  behandskad_1_A : A ; -- behandskad..av.1
  behaviorism_1_N : N ; -- behaviorism..nn.1
  behaviorist_1_N : N ; -- behaviorist..nn.1
  behavioristisk_1_A : A ; -- behavioristisk..av.1
  behjälplig_1_A : A ; -- behjälplig..av.1
  behjälplighet_1_N : N ; -- behjälplighet..nn.1
  behjärtad_1_A : A ; -- behjärtad..av.1
  behjärtansvärd_1_A : A ; -- behjärtansvärd..av.1
  behjärtenhet_1_N : N ; -- behjärtenhet..nn.1
  behornad_1_A : A ; -- behornad..av.1
  behov_1_N : N ; -- behov..nn.1
  behovlös_1_A : A ; -- behovlös..av.1
  behovlöshet_1_N : N ; -- behovlöshet..nn.1
  behovsprincip_1_N : N ; -- behovsprincip..nn.1
  behovsprövad_1_A : A ; -- behovsprövad..av.1
  behovsprövning_1_N : N ; -- behovsprövning..nn.1
  behovstillfredsställelse_1_N : N ; -- behovstillfredsställelse..nn.1
  behovstryck_1_N : N ; -- behovstryck..nn.1
  behäftad_1_A : A ; -- behäftad..av.1
  behändig_1_A : A ; -- behändig..av.1
  behändighet_1_N : N ; -- behändighet..nn.1
  behänga_1_V : V ; -- behänga..vb.1
  behängande_1_N : N ; -- behängande..nn.1
  behängning_1_N : N ; -- behängning..nn.1
  behärska_1_V : V ; -- behärska..vb.1
  behärskad_1_A : A ; -- behärskad..av.1
  behärskande_1_N : N ; -- behärskande..nn.1
  behärskning_1_N : N ; -- behärskning..nn.1
  behå_1_N : N ; -- behå..nn.1
  behålla_1_V : V ; -- behålla..vb.1
  behållande_1_N : N ; -- behållande..nn.1
  behållare_1_N : N ; -- behållare..nn.1
  behållen_1_A : A ; -- behållen..av.1
  behållning_1_N : N ; -- behållning..nn.1
  behårad_1_A : A ; -- behårad..av.1
  behåring_1_N : N ; -- behåring..nn.1
  behörig_1_A : A ; -- behörig..av.1
  behörighet_1_N : N ; -- behörighet..nn.1
  behörighetsbevis_1_N : N ; -- behörighetsbevis..nn.1
  behöva_1_V : V ; -- behöva..vb.1
  behövande_1_A : A ; -- behövande..av.1
  behövande_1_N : N ; -- behövande..nn.1
  behövlig_1_A : A ; -- behövlig..av.1
  behövlighet_1_N : N ; -- behövlighet..nn.1
  beige_1_A : A ; -- beige..av.1
  beige_1_N : N ; -- beige..nn.1
  beivra_1_V : V ; -- beivra..vb.1
  beivrande_1_N : N ; -- beivrande..nn.1
  beivrare_1_N : N ; -- beivrare..nn.1
  bej_1_N : N ; -- bej..nn.1
  bejaka_1_V : V ; -- bejaka..vb.1
  bejakande_1_N : N ; -- bejakande..nn.1
  bejakning_1_N : N ; -- bejakning..nn.1
  bejubla_1_V : V ; -- bejubla..vb.1
  bejublande_1_N : N ; -- bejublande..nn.1
  bekaja_1_V : V ; -- bekaja..vb.1
  bekajande_1_N : N ; -- bekajande..nn.1
  bekant_1_A : A ; -- bekant..av.1
  bekant_1_N : N ; -- bekant..nn.1
  bekanta_1_V : V ; -- bekanta..vb.1
  bekantande_1_N : N ; -- bekantande..nn.1
  bekantgöra_1_V : V ; -- bekantgöra..vb.1
  bekantgörande_1_N : N ; -- bekantgörande..nn.1
  bekanting_1_N : N ; -- bekanting..nn.1
  bekantskap_1_N : N ; -- bekantskap..nn.1
  bekantskapskrets_1_N : N ; -- bekantskapskrets..nn.1
  bekika_1_V : V ; -- bekika..vb.1
  bekikande_1_N : N ; -- bekikande..nn.1
  beklaga_1_V : V ; -- beklaga..vb.1
  beklagande_1_N : N ; -- beklagande..nn.1
  beklagansvärd_1_A : A ; -- beklagansvärd..av.1
  beklaglig_1_A : A ; -- beklaglig..av.1
  beklagligen_1_Adv : Adv ; -- beklagligen..ab.1
  beklaglighet_1_N : N ; -- beklaglighet..nn.1
  beklagligtvis_1_Adv : Adv ; -- beklagligtvis..ab.1
  beklä_1_V : V ; -- beklä..vb.1
  beklädande_1_N : N ; -- beklädande..nn.1
  beklädnad_1_N : N ; -- beklädnad..nn.1
  beklädning_1_N : N ; -- beklädning..nn.1
  beklämd_1_A : A ; -- beklämd..av.1
  beklämdhet_1_N : N ; -- beklämdhet..nn.1
  beklämmande_1_A : A ; -- beklämmande..av.1
  beklämning_1_N : N ; -- beklämning..nn.1
  beknip_1_N : N ; -- beknip..nn.1
  beknipa_1_V : V ; -- beknipa..vb.1
  beknipande_1_N : N ; -- beknipande..nn.1
  bekomma_1_V : V ; -- bekomma..vb.1
  bekommande_1_N : N ; -- bekommande..nn.1
  bekosta_1_V : V ; -- bekosta..vb.1
  bekostande_1_N : N ; -- bekostande..nn.1
  bekostnad_1_N : N ; -- bekostnad..nn.1
  bekransa_1_V : V ; -- bekransa..vb.1
  bekransande_1_N : N ; -- bekransande..nn.1
  bekransning_1_N : N ; -- bekransning..nn.1
  bekriga_1_V : V ; -- bekriga..vb.1
  bekrigande_1_N : N ; -- bekrigande..nn.1
  bekräfta_1_V : V ; -- bekräfta..vb.1
  bekräftande_1_N : N ; -- bekräftande..nn.1
  bekräftelse_1_N : N ; -- bekräftelse..nn.1
  bekräftelsebehov_1_N : N ; -- bekräftelsebehov..nn.1
  bekräftelsesökande_1_A : A ; -- bekräftelsesökande..av.1
  bekröna_1_V : V ; -- bekröna..vb.1
  bekrönande_1_N : N ; -- bekrönande..nn.1
  bekröning_1_N : N ; -- bekröning..nn.1
  bekväm_1_A : A ; -- bekväm..av.1
  bekvämhet_1_N : N ; -- bekvämhet..nn.1
  bekvämlighet_1_N : N ; -- bekvämlighet..nn.1
  bekvämlighetsflagg_1_N : N ; -- bekvämlighetsflagg..nn.1
  bekvämlighetshänsyn_1_N : N ; -- bekvämlighetshänsyn..nn.1
  bekvämlighetsinrättning_1_N : N ; -- bekvämlighetsinrättning..nn.1
  bekymmer_1_N : N ; -- bekymmer..nn.1
  bekymmerfri_1_A : A ; -- bekymmerfri..av.1
  bekymmersam_1_A : A ; -- bekymmersam..av.1
  bekymmersamhet_1_N : N ; -- bekymmersamhet..nn.1
  bekymmersfri_1_A : A ; -- bekymmersfri..av.1
  bekymmersfull_1_A : A ; -- bekymmersfull..av.1
  bekymmerslös_1_A : A ; -- bekymmerslös..av.1
  bekymmerslöshet_1_N : N ; -- bekymmerslöshet..nn.1
  bekymmersrynka_1_N : N ; -- bekymmersrynka..nn.1
  bekymra_1_V : V ; -- bekymra..vb.1
  bekymrad_1_A : A ; -- bekymrad..av.1
  bekymrande_1_N : N ; -- bekymrande..nn.1
  bekyttad_1_A : A ; -- bekyttad..av.1
  bekämpa_1_V : V ; -- bekämpa..vb.1
  bekämpande_1_N : N ; -- bekämpande..nn.1
  bekämpare_1_N : N ; -- bekämpare..nn.1
  bekämpning_1_N : N ; -- bekämpning..nn.1
  bekämpningsmedel_1_N : N ; -- bekämpningsmedel..nn.1
  bekänna_1_V : V ; -- bekänna..vb.1
  bekännande_1_N : N ; -- bekännande..nn.1
  bekännare_1_N : N ; -- bekännare..nn.1
  bekännelse_1_N : N ; -- bekännelse..nn.1
  bekännelsefrihet_1_N : N ; -- bekännelsefrihet..nn.1
  bekännelseroman_1_N : N ; -- bekännelseroman..nn.1
  bekännelseskrift_1_N : N ; -- bekännelseskrift..nn.1
  belacka_1_V : V ; -- belacka..vb.1
  belackande_1_N : N ; -- belackande..nn.1
  belackare_1_N : N ; -- belackare..nn.1
  belag_1_N : N ; -- belag..nn.1
  belamra_1_V : V ; -- belamra..vb.1
  belamrande_1_N : N ; -- belamrande..nn.1
  belanga_1_V : V ; -- belanga..vb.1
  belangande_1_N : N ; -- belangande..nn.1
  belasta_1_V : V ; -- belasta..vb.1
  belastande_1_N : N ; -- belastande..nn.1
  belastning_1_N : N ; -- belastning..nn.1
  belastningsregister_1_N : N ; -- belastningsregister..nn.1
  belastningsskada_1_N : N ; -- belastningsskada..nn.1
  belastningsuppgift_1_N : N ; -- belastningsuppgift..nn.1
  belcanto_1_N : N ; -- belcanto..nn.1
  bele_1_V : V ; -- bele..vb.1
  beledsaga_1_V : V ; -- beledsaga..vb.1
  beledsagande_1_N : N ; -- beledsagande..nn.1
  beledsagare_1_N : N ; -- beledsagare..nn.1
  beledsagning_1_N : N ; -- beledsagning..nn.1
  beleende_1_N : N ; -- beleende..nn.1
  belemnit_1_N : N ; -- belemnit..nn.1
  belevad_1_A : A ; -- belevad..av.1
  belevenhet_1_N : N ; -- belevenhet..nn.1
  belgare_1_N : N ; -- belgare..nn.1
  belgier_1_N : N ; -- belgier..nn.1
  belgisk_1_A : A ; -- belgisk..av.1
  belgiska_1_N : N ; -- belgiska..nn.1
  belizier_1_N : N ; -- belizier..nn.1
  belizisk_1_A : A ; -- belizisk..av.1
  beliziska_1_N : N ; -- beliziska..nn.1
  beljuga_1_V : V ; -- beljuga..vb.1
  beljugande_1_N : N ; -- beljugande..nn.1
  belladonna_1_N : N ; -- belladonna..nn.1
  belletrist_1_N : N ; -- belletrist..nn.1
  belletristik_1_N : N ; -- belletristik..nn.1
  belletristisk_1_A : A ; -- belletristisk..av.1
  bellis_1_N : N ; -- bellis..nn.1
  bellit_1_N : N ; -- bellit..nn.1
  belopp_1_N : N ; -- belopp..nn.1
  belysa_1_V : V ; -- belysa..vb.1
  belysande_1_A : A ; -- belysande..av.1
  belysande_1_N : N ; -- belysande..nn.1
  belysning_1_N : N ; -- belysning..nn.1
  belysningsarmatur_1_N : N ; -- belysningsarmatur..nn.1
  belysningsmässa_1_N : N ; -- belysningsmässa..nn.1
  belysningsström_1_N : N ; -- belysningsström..nn.1
  belysningsstyrka_1_N : N ; -- belysningsstyrka..nn.1
  belägen_1_A : A ; -- belägen..av.1
  belägenhet_1_N : N ; -- belägenhet..nn.1
  belägg_1_N : N ; -- belägg..nn.1
  belägga_1_V : V ; -- belägga..vb.1
  beläggande_1_N : N ; -- beläggande..nn.1
  beläggning_1_N : N ; -- beläggning..nn.1
  beläggningsgrad_1_N : N ; -- beläggningsgrad..nn.1
  beläggningsring_1_N : N ; -- beläggningsring..nn.1
  beläggningssnöre_1_N : N ; -- beläggningssnöre..nn.1
  beläggningsstämpel_1_N : N ; -- beläggningsstämpel..nn.1
  beläggställe_1_N : N ; -- beläggställe..nn.1
  belägra_1_V : V ; -- belägra..vb.1
  belägrande_1_N : N ; -- belägrande..nn.1
  belägring_1_N : N ; -- belägring..nn.1
  belägringsartilleri_1_N : N ; -- belägringsartilleri..nn.1
  belägringskonst_1_N : N ; -- belägringskonst..nn.1
  belägringstillstånd_1_N : N ; -- belägringstillstånd..nn.1
  belägringstorn_1_N : N ; -- belägringstorn..nn.1
  beläsenhet_1_N : N ; -- beläsenhet..nn.1
  beläst_1_A : A ; -- beläst..av.1
  belästhet_1_N : N ; -- belästhet..nn.1
  beläte_1_N : N ; -- beläte..nn.1
  belåna_1_V : V ; -- belåna..vb.1
  belånande_1_N : N ; -- belånande..nn.1
  belåning_1_N : N ; -- belåning..nn.1
  belåningsgrad_1_N : N ; -- belåningsgrad..nn.1
  belåten_1_A : A ; -- belåten..av.1
  belåtenhet_1_N : N ; -- belåtenhet..nn.1
  belöna_1_V : V ; -- belöna..vb.1
  belönande_1_N : N ; -- belönande..nn.1
  belöning_1_N : N ; -- belöning..nn.1
  belöningsmedalj_1_N : N ; -- belöningsmedalj..nn.1
  belöningssystem_1_N : N ; -- belöningssystem..nn.1
  bemanna_1_V : V ; -- bemanna..vb.1
  bemannad_1_A : A ; -- bemannad..av.1
  bemannande_1_N : N ; -- bemannande..nn.1
  bemanning_1_N : N ; -- bemanning..nn.1
  bemanningsföretag_1_N : N ; -- bemanningsföretag..nn.1
  bemanningsverksamhet_1_N : N ; -- bemanningsverksamhet..nn.1
  bemantla_1_V : V ; -- bemantla..vb.1
  bemantlande_1_N : N ; -- bemantlande..nn.1
  bemedla_1_V : V ; -- bemedla..vb.1
  bemedlad_1_A : A ; -- bemedlad..av.1
  bemedlande_1_N : N ; -- bemedlande..nn.1
  bemedling_1_N : N ; -- bemedling..nn.1
  bemyndiga_1_V : V ; -- bemyndiga..vb.1
  bemyndigande_1_N : N ; -- bemyndigande..nn.1
  bemälde_1_A : A ; -- bemälde..av.1
  bemänga_1_V : V ; -- bemänga..vb.1
  bemängande_1_N : N ; -- bemängande..nn.1
  bemärka_1_V : V ; -- bemärka..vb.1
  bemärkande_1_N : N ; -- bemärkande..nn.1
  bemärkelse_1_N : N ; -- bemärkelse..nn.1
  bemärkelsedag_1_N : N ; -- bemärkelsedag..nn.1
  bemärkt_1_A : A ; -- bemärkt..av.1
  bemärkthet_1_N : N ; -- bemärkthet..nn.1
  bemästra_1_V : V ; -- bemästra..vb.1
  bemästrande_1_N : N ; -- bemästrande..nn.1
  bemåla_1_V : V ; -- bemåla..vb.1
  bemålande_1_N : N ; -- bemålande..nn.1
  bemålning_1_N : N ; -- bemålning..nn.1
  bemödande_1_N : N ; -- bemödande..nn.1
  bemöta_1_V : V ; -- bemöta..vb.1
  bemötande_1_N : N ; -- bemötande..nn.1
  ben_1_N : N ; -- ben..nn.1
  bena_1_N : N ; -- bena..nn.1
  bena_1_V : V ; -- bena..vb.1
  benande_1_N : N ; -- benande..nn.1
  benaska_1_N : N ; -- benaska..nn.1
  benbildning_1_N : N ; -- benbildning..nn.1
  benbrosk_1_N : N ; -- benbrosk..nn.1
  benbrott_1_N : N ; -- benbrott..nn.1
  benediktin_1_N : N ; -- benediktin..nn.1
  benediktinerkloster_1_N : N ; -- benediktinerkloster..nn.1
  benediktinermunk_1_N : N ; -- benediktinermunk..nn.1
  benediktinerorden_1_N : N ; -- benediktinerorden..nn.1
  benediktinkloster_1_N : N ; -- benediktinkloster..nn.1
  benediktinorden_1_N : N ; -- benediktinorden..nn.1
  beneficium_1_N : N ; -- beneficium..nn.1
  benefik_1_A : A ; -- benefik..av.1
  benfisk_1_N : N ; -- benfisk..nn.1
  benfragment_1_N : N ; -- benfragment..nn.1
  benfri_1_A : A ; -- benfri..av.1
  benfärgad_1_A : A ; -- benfärgad..av.1
  bengalisk_1_A : A ; -- bengalisk..av.1
  benget_1_N : N ; -- benget..nn.1
  bengädda_1_N : N ; -- bengädda..nn.1
  benhinna_1_N : N ; -- benhinna..nn.1
  benhinneinflammation_1_N : N ; -- benhinneinflammation..nn.1
  benhus_1_N : N ; -- benhus..nn.1
  benhård_1_A : A ; -- benhård..av.1
  benhårdhet_1_N : N ; -- benhårdhet..nn.1
  benig_1_A : A ; -- benig..av.1
  benign_1_A : A ; -- benign..av.1
  beninier_1_N : N ; -- beninier..nn.1
  beninsk_1_A : A ; -- beninsk..av.1
  beninska_1_N : N ; -- beninska..nn.1
  benjamin_1_N : N ; -- benjamin..nn.1
  benjaminfikus_1_N : N ; -- benjaminfikus..nn.1
  benkirurg_1_N : N ; -- benkirurg..nn.1
  benknota_1_N : N ; -- benknota..nn.1
  benknäckare_1_N : N ; -- benknäckare..nn.1
  benling_1_N : N ; -- benling..nn.1
  benlås_1_N : N ; -- benlås..nn.1
  benmjöl_1_N : N ; -- benmjöl..nn.1
  benmuskel_1_N : N ; -- benmuskel..nn.1
  benmärg_1_N : N ; -- benmärg..nn.1
  benmärgscancer_1_N : N ; -- benmärgscancer..nn.1
  benpipa_1_N : N ; -- benpipa..nn.1
  benporslin_1_N : N ; -- benporslin..nn.1
  benprotes_1_N : N ; -- benprotes..nn.1
  benrangel_1_N : N ; -- benrangel..nn.1
  benrangelsman_1_N : N ; -- benrangelsman..nn.1
  benrest_1_N : N ; -- benrest..nn.1
  benröta_1_N : N ; -- benröta..nn.1
  bensen_1_N : N ; -- bensen..nn.1
  bensin_1_N : N ; -- bensin..nn.1
  bensinautomat_1_N : N ; -- bensinautomat..nn.1
  bensinbolag_1_N : N ; -- bensinbolag..nn.1
  bensinbomb_1_N : N ; -- bensinbomb..nn.1
  bensinbrist_1_N : N ; -- bensinbrist..nn.1
  bensindriven_1_A : A ; -- bensindriven..av.1
  bensindunk_1_N : N ; -- bensindunk..nn.1
  bensinförbrukning_1_N : N ; -- bensinförbrukning..nn.1
  bensinförsäljning_1_N : N ; -- bensinförsäljning..nn.1
  bensinmack_1_N : N ; -- bensinmack..nn.1
  bensinmotor_1_N : N ; -- bensinmotor..nn.1
  bensinpris_1_N : N ; -- bensinpris..nn.1
  bensinpump_1_N : N ; -- bensinpump..nn.1
  bensinskatt_1_N : N ; -- bensinskatt..nn.1
  bensinskattehöjning_1_N : N ; -- bensinskattehöjning..nn.1
  bensinslukande_1_A : A ; -- bensinslukande..av.1
  bensinsnål_1_A : A ; -- bensinsnål..av.1
  bensinsnålhet_1_N : N ; -- bensinsnålhet..nn.1
  bensinstation_1_N : N ; -- bensinstation..nn.1
  bensinstopp_1_N : N ; -- bensinstopp..nn.1
  bensintank_1_N : N ; -- bensintank..nn.1
  bensintillsats_1_N : N ; -- bensintillsats..nn.1
  benskada_1_N : N ; -- benskada..nn.1
  benskena_1_N : N ; -- benskena..nn.1
  benskydd_1_N : N ; -- benskydd..nn.1
  benskör_1_A : A ; -- benskör..av.1
  benskörhet_1_N : N ; -- benskörhet..nn.1
  bensoe_1_N : N ; -- bensoe..nn.1
  bensoesyra_1_N : N ; -- bensoesyra..nn.1
  bensol_1_N : N ; -- bensol..nn.1
  benspets_1_N : N ; -- benspets..nn.1
  benstamp_1_N : N ; -- benstamp..nn.1
  benstomme_1_N : N ; -- benstomme..nn.1
  bensträckare_1_N : N ; -- bensträckare..nn.1
  benstråle_1_N : N ; -- benstråle..nn.1
  bensubstans_1_N : N ; -- bensubstans..nn.1
  bensvulst_1_N : N ; -- bensvulst..nn.1
  bensår_1_N : N ; -- bensår..nn.1
  bentonit_1_N : N ; -- bentonit..nn.1
  bentonitlager_1_N : N ; -- bentonitlager..nn.1
  bentrakt_1_N : N ; -- bentrakt..nn.1
  bentuberkulos_1_N : N ; -- bentuberkulos..nn.1
  bentyl_1_N : N ; -- bentyl..nn.1
  benutskott_1_N : N ; -- benutskott..nn.1
  benved_1_N : N ; -- benved..nn.1
  benvit_1_A : A ; -- benvit..av.1
  benvävnad_1_N : N ; -- benvävnad..nn.1
  benägen_1_A : A ; -- benägen..av.1
  benägenhet_1_N : N ; -- benägenhet..nn.1
  benämna_1_V : V ; -- benämna..vb.1
  benämnande_1_N : N ; -- benämnande..nn.1
  benämning_1_N : N ; -- benämning..nn.1
  benåda_1_V : V ; -- benåda..vb.1
  benådande_1_N : N ; -- benådande..nn.1
  benådning_1_N : N ; -- benådning..nn.1
  beordra_1_V : V ; -- beordra..vb.1
  beordrande_1_N : N ; -- beordrande..nn.1
  beostare_1_N : N ; -- beostare..nn.1
  bepansra_1_V : V ; -- bepansra..vb.1
  bepansrande_1_N : N ; -- bepansrande..nn.1
  bepansring_1_N : N ; -- bepansring..nn.1
  beprisa_1_V : V ; -- beprisa..vb.1
  beprisande_1_N : N ; -- beprisande..nn.1
  beprisning_1_N : N ; -- beprisning..nn.1
  bepryda_1_V : V ; -- bepryda..vb.1
  beprydande_1_N : N ; -- beprydande..nn.1
  beprövad_1_A : A ; -- beprövad..av.1
  bepudra_1_V : V ; -- bepudra..vb.1
  bepudrande_1_N : N ; -- bepudrande..nn.1
  beramad_1_A : A ; -- beramad..av.1
  berber_1_N : N ; -- berber..nn.1
  berberis_1_N : N ; -- berberis..nn.1
  berceuse_1_N : N ; -- berceuse..nn.1
  bereda_1_V : V ; -- bereda..vb.1
  beredande_1_N : N ; -- beredande..nn.1
  beredare_1_N : N ; -- beredare..nn.1
  beredd_1_A : A ; -- beredd..av.1
  beredelse_1_N : N ; -- beredelse..nn.1
  beredning_1_N : N ; -- beredning..nn.1
  beredning_2_N : N ; -- beredning..nn.2
  beredningsnämnd_1_N : N ; -- beredningsnämnd..nn.1
  beredningssätt_1_N : N ; -- beredningssätt..nn.1
  beredningsutskott_1_N : N ; -- beredningsutskott..nn.1
  beredskap_1_N : N ; -- beredskap..nn.1
  beredskapsarbete_1_N : N ; -- beredskapsarbete..nn.1
  beredskapskommissarie_1_N : N ; -- beredskapskommissarie..nn.1
  beredskapslager_1_N : N ; -- beredskapslager..nn.1
  beredskapslagring_1_N : N ; -- beredskapslagring..nn.1
  beredskapsmässig_1_A : A ; -- beredskapsmässig..av.1
  beredskapsplan_1_N : N ; -- beredskapsplan..nn.1
  beredskapsstat_1_N : N ; -- beredskapsstat..nn.1
  beredskapstid_1_N : N ; -- beredskapstid..nn.1
  beredskapstjänst_1_N : N ; -- beredskapstjänst..nn.1
  beredvillig_1_A : A ; -- beredvillig..av.1
  beredvillighet_1_N : N ; -- beredvillighet..nn.1
  berest_1_A : A ; -- berest..av.1
  beresthet_1_N : N ; -- beresthet..nn.1
  berg_och_dalbana_1_N : N ; -- berg-och-dalbana..nn.1
  berg_1_N : N ; -- berg..nn.1
  bergakung_1_N : N ; -- bergakung..nn.1
  bergamott_1_N : N ; -- bergamott..nn.1
  bergand_1_N : N ; -- bergand..nn.1
  bergart_1_N : N ; -- bergart..nn.1
  bergartslager_1_N : N ; -- bergartslager..nn.1
  bergbana_1_N : N ; -- bergbana..nn.1
  bergbestigare_1_N : N ; -- bergbestigare..nn.1
  bergbestigning_1_N : N ; -- bergbestigning..nn.1
  bergborr_1_N : N ; -- bergborr..nn.1
  bergborrning_1_N : N ; -- bergborrning..nn.1
  bergbäck_1_N : N ; -- bergbäck..nn.1
  bergfast_1_A : A ; -- bergfast..av.1
  bergfin_1_A : A ; -- bergfin..av.1
  bergfink_1_N : N ; -- bergfink..nn.1
  berggrund_1_N : N ; -- berggrund..nn.1
  berggylta_1_N : N ; -- berggylta..nn.1
  berghäll_1_N : N ; -- berghäll..nn.1
  bergig_1_A : A ; -- bergig..av.1
  bergighet_1_N : N ; -- bergighet..nn.1
  bergis_1_A : A ; -- bergis..av.1
  bergis_1_N : N ; -- bergis..nn.1
  bergkam_1_N : N ; -- bergkam..nn.1
  bergklack_1_N : N ; -- bergklack..nn.1
  bergknalle_1_N : N ; -- bergknalle..nn.1
  bergkristall_1_N : N ; -- bergkristall..nn.1
  bergkrön_1_N : N ; -- bergkrön..nn.1
  bergkulle_1_N : N ; -- bergkulle..nn.1
  bergland_1_N : N ; -- bergland..nn.1
  berglandskap_1_N : N ; -- berglandskap..nn.1
  bergnymf_1_N : N ; -- bergnymf..nn.1
  bergolja_1_N : N ; -- bergolja..nn.1
  bergpass_1_N : N ; -- bergpass..nn.1
  bergras_1_N : N ; -- bergras..nn.1
  bergrum_1_N : N ; -- bergrum..nn.1
  bergrygg_1_N : N ; -- bergrygg..nn.1
  bergsartilleri_1_N : N ; -- bergsartilleri..nn.1
  bergsbestigare_1_N : N ; -- bergsbestigare..nn.1
  bergsbestigning_1_N : N ; -- bergsbestigning..nn.1
  bergsbestigningsexpedition_1_N : N ; -- bergsbestigningsexpedition..nn.1
  bergsbestigningsolycka_1_N : N ; -- bergsbestigningsolycka..nn.1
  bergsbrant_1_N : N ; -- bergsbrant..nn.1
  bergsbruk_1_N : N ; -- bergsbruk..nn.1
  bergsbygd_1_N : N ; -- bergsbygd..nn.1
  bergsdrift_1_N : N ; -- bergsdrift..nn.1
  bergsformation_1_N : N ; -- bergsformation..nn.1
  bergsget_1_N : N ; -- bergsget..nn.1
  bergsglaciär_1_N : N ; -- bergsglaciär..nn.1
  bergsgorilla_1_N : N ; -- bergsgorilla..nn.1
  bergshantering_1_N : N ; -- bergshantering..nn.1
  bergsingenjör_1_N : N ; -- bergsingenjör..nn.1
  bergsjägare_1_N : N ; -- bergsjägare..nn.1
  bergskam_1_N : N ; -- bergskam..nn.1
  bergskedja_1_N : N ; -- bergskedja..nn.1
  bergskedjebildning_1_N : N ; -- bergskedjebildning..nn.1
  bergsklack_1_N : N ; -- bergsklack..nn.1
  bergsklimat_1_N : N ; -- bergsklimat..nn.1
  bergsklyfta_1_N : N ; -- bergsklyfta..nn.1
  bergsklättrare_1_N : N ; -- bergsklättrare..nn.1
  bergsklättring_1_N : N ; -- bergsklättring..nn.1
  bergskred_1_N : N ; -- bergskred..nn.1
  bergskreva_1_N : N ; -- bergskreva..nn.1
  bergskrön_1_N : N ; -- bergskrön..nn.1
  bergslag_1_N : N ; -- bergslag..nn.1
  bergslager_1_N : N ; -- bergslager..nn.1
  bergslandskap_1_N : N ; -- bergslandskap..nn.1
  bergsluft_1_N : N ; -- bergsluft..nn.1
  bergsman_1_N : N ; -- bergsman..nn.1
  bergsmassiv_1_N : N ; -- bergsmassiv..nn.1
  bergsområde_1_N : N ; -- bergsområde..nn.1
  bergspets_1_N : N ; -- bergspets..nn.1
  bergsplatå_1_N : N ; -- bergsplatå..nn.1
  bergsrygg_1_N : N ; -- bergsrygg..nn.1
  bergssida_1_N : N ; -- bergssida..nn.1
  bergsskola_1_N : N ; -- bergsskola..nn.1
  bergssluttning_1_N : N ; -- bergssluttning..nn.1
  bergsstam_1_N : N ; -- bergsstam..nn.1
  bergsstup_1_N : N ; -- bergsstup..nn.1
  bergstopp_1_N : N ; -- bergstopp..nn.1
  bergstrakt_1_N : N ; -- bergstrakt..nn.1
  bergstup_1_N : N ; -- bergstup..nn.1
  bergsyra_1_N : N ; -- bergsyra..nn.1
  bergszebra_1_N : N ; -- bergszebra..nn.1
  bergsäker_1_A : A ; -- bergsäker..av.1
  bergsäkerhet_1_N : N ; -- bergsäkerhet..nn.1
  bergtagen_1_A : A ; -- bergtagen..av.1
  bergtall_1_N : N ; -- bergtall..nn.1
  bergtopp_1_N : N ; -- bergtopp..nn.1
  bergtroll_1_N : N ; -- bergtroll..nn.1
  berguv_1_N : N ; -- berguv..nn.1
  bergvandrare_1_N : N ; -- bergvandrare..nn.1
  bergvandring_1_N : N ; -- bergvandring..nn.1
  bergvind_1_N : N ; -- bergvind..nn.1
  bergvägg_1_N : N ; -- bergvägg..nn.1
  bergvärme_1_N : N ; -- bergvärme..nn.1
  bergås_1_N : N ; -- bergås..nn.1
  beridare_1_N : N ; -- beridare..nn.1
  beriden_1_A : A ; -- beriden..av.1
  berika_1_V : V ; -- berika..vb.1
  berikande_1_N : N ; -- berikande..nn.1
  beriktiga_1_V : V ; -- beriktiga..vb.1
  beriktigande_1_N : N ; -- beriktigande..nn.1
  berkelium_1_N : N ; -- berkelium..nn.1
  berkis_1_N : N ; -- berkis..nn.1
  berlinerblå_1_A : A ; -- berlinerblå..av.1
  berlinerblått_1_N : N ; -- berlinerblått..nn.1
  berlock_1_N : N ; -- berlock..nn.1
  bermudarigg_1_N : N ; -- bermudarigg..nn.1
  bernäs_1_N : N ; -- bernäs..nn.1
  bernässås_1_N : N ; -- bernässås..nn.1
  bero_1_V : V ; -- bero..vb.1
  beroende_1_A : A ; -- beroende..av.1
  beroende_1_N : N ; -- beroende..nn.1
  beroende_2_N : N ; -- beroende..nn.2
  beroendeframkallande_1_A : A ; -- beroendeframkallande..av.1
  beroendeförhållande_1_N : N ; -- beroendeförhållande..nn.1
  beroendeproblem_1_N : N ; -- beroendeproblem..nn.1
  beroendeställning_1_N : N ; -- beroendeställning..nn.1
  berså_1_N : N ; -- berså..nn.1
  bertel_1_N : N ; -- bertel..nn.1
  berusa_1_V : V ; -- berusa..vb.1
  berusad_1_A : A ; -- berusad..av.1
  berusande_1_A : A ; -- berusande..av.1
  berusande_1_N : N ; -- berusande..nn.1
  berusning_1_N : N ; -- berusning..nn.1
  berusningsgrad_1_N : N ; -- berusningsgrad..nn.1
  beryktad_1_A : A ; -- beryktad..av.1
  beryll_1_N : N ; -- beryll..nn.1
  beryllgrön_1_A : A ; -- beryllgrön..av.1
  beryllium_1_N : N ; -- beryllium..nn.1
  beräkna_1_V : V ; -- beräkna..vb.1
  beräknad_1_A : A ; -- beräknad..av.1
  beräknande_1_A : A ; -- beräknande..av.1
  beräknande_1_N : N ; -- beräknande..nn.1
  beräknelig_1_A : A ; -- beräknelig..av.1
  beräknelighet_1_N : N ; -- beräknelighet..nn.1
  beräkning_1_N : N ; -- beräkning..nn.1
  beräkningsgrund_1_N : N ; -- beräkningsgrund..nn.1
  beräkningsmetod_1_N : N ; -- beräkningsmetod..nn.1
  beräkningsmässig_1_A : A ; -- beräkningsmässig..av.1
  beräkningssätt_1_N : N ; -- beräkningssätt..nn.1
  berätta_1_V : V ; -- berätta..vb.1
  berättande_1_A : A ; -- berättande..av.1
  berättande_1_N : N ; -- berättande..nn.1
  berättarbegåvning_1_N : N ; -- berättarbegåvning..nn.1
  berättare_1_N : N ; -- berättare..nn.1
  berättarförmåga_1_N : N ; -- berättarförmåga..nn.1
  berättarglädje_1_N : N ; -- berättarglädje..nn.1
  berättarjag_1_N : N ; -- berättarjag..nn.1
  berättarkonst_1_N : N ; -- berättarkonst..nn.1
  berättarmässig_1_A : A ; -- berättarmässig..av.1
  berättarperspektiv_1_N : N ; -- berättarperspektiv..nn.1
  berättarröst_1_N : N ; -- berättarröst..nn.1
  berättarstil_1_N : N ; -- berättarstil..nn.1
  berättartalang_1_N : N ; -- berättartalang..nn.1
  berättarteknik_1_N : N ; -- berättarteknik..nn.1
  berättarteknisk_1_A : A ; -- berättarteknisk..av.1
  berättelse_1_N : N ; -- berättelse..nn.1
  berättiga_1_V : V ; -- berättiga..vb.1
  berättigad_1_A : A ; -- berättigad..av.1
  berättigande_1_N : N ; -- berättigande..nn.1
  berömd_1_A : A ; -- berömd..av.1
  berömdhet_1_N : N ; -- berömdhet..nn.1
  berömlig_1_A : A ; -- berömlig..av.1
  berömlighet_1_N : N ; -- berömlighet..nn.1
  berömma_1_V : V ; -- berömma..vb.1
  berömmande_1_N : N ; -- berömmande..nn.1
  berömmelse_1_N : N ; -- berömmelse..nn.1
  berömvärd_1_A : A ; -- berömvärd..av.1
  berömvärdhet_1_N : N ; -- berömvärdhet..nn.1
  beröra_1_V : V ; -- beröra..vb.1
  berörande_1_N : N ; -- berörande..nn.1
  berörd_1_A : A ; -- berörd..av.1
  beröring_1_N : N ; -- beröring..nn.1
  beröringsassociation_1_N : N ; -- beröringsassociation..nn.1
  beröringselektricitet_1_N : N ; -- beröringselektricitet..nn.1
  beröringsfri_1_A : A ; -- beröringsfri..av.1
  beröringspunkt_1_N : N ; -- beröringspunkt..nn.1
  beröringsskräck_1_N : N ; -- beröringsskräck..nn.1
  beröringsångest_1_N : N ; -- beröringsångest..nn.1
  beröva_1_V : V ; -- beröva..vb.1
  berövande_1_N : N ; -- berövande..nn.1
  besanna_1_V : V ; -- besanna..vb.1
  besannande_1_N : N ; -- besannande..nn.1
  besatt_1_A : A ; -- besatt..av.1
  besatthet_1_N : N ; -- besatthet..nn.1
  bese_1_V : V ; -- bese..vb.1
  beseende_1_N : N ; -- beseende..nn.1
  besegla_1_V : V ; -- besegla..vb.1
  beseglande_1_N : N ; -- beseglande..nn.1
  besegling_1_N : N ; -- besegling..nn.1
  besegra_1_V : V ; -- besegra..vb.1
  besegrande_1_N : N ; -- besegrande..nn.1
  besegrare_1_N : N ; -- besegrare..nn.1
  besick_1_N : N ; -- besick..nn.1
  besiffrad_1_A : A ; -- besiffrad..av.1
  besiffring_1_N : N ; -- besiffring..nn.1
  besiktiga_1_V : V ; -- besiktiga..vb.1
  besiktigande_1_N : N ; -- besiktigande..nn.1
  besiktning_1_N : N ; -- besiktning..nn.1
  besiktningsinstrument_1_N : N ; -- besiktningsinstrument..nn.1
  besiktningsman_1_N : N ; -- besiktningsman..nn.1
  besiktningsprotokoll_1_N : N ; -- besiktningsprotokoll..nn.1
  besinna_1_V : V ; -- besinna..vb.1
  besinnad_1_A : A ; -- besinnad..av.1
  besinnande_1_N : N ; -- besinnande..nn.1
  besinning_1_N : N ; -- besinning..nn.1
  besinningsfull_1_A : A ; -- besinningsfull..av.1
  besinningsfullhet_1_N : N ; -- besinningsfullhet..nn.1
  besinningslös_1_A : A ; -- besinningslös..av.1
  besinningslöshet_1_N : N ; -- besinningslöshet..nn.1
  besique_1_N : N ; -- besique..nn.1
  besitta_1_V : V ; -- besitta..vb.1
  besittande_1_N : N ; -- besittande..nn.1
  besittning_1_N : N ; -- besittning..nn.1
  besittningshavare_1_N : N ; -- besittningshavare..nn.1
  besittningsrätt_1_N : N ; -- besittningsrätt..nn.1
  besittningsskydd_1_N : N ; -- besittningsskydd..nn.1
  besittningstagande_1_N : N ; -- besittningstagande..nn.1
  besittningstid_1_N : N ; -- besittningstid..nn.1
  besjunga_1_V : V ; -- besjunga..vb.1
  besjungande_1_N : N ; -- besjungande..nn.1
  besjungen_1_A : A ; -- besjungen..av.1
  besjäla_1_V : V ; -- besjäla..vb.1
  besjälad_1_A : A ; -- besjälad..av.1
  besjälande_1_N : N ; -- besjälande..nn.1
  besk_1_A : A ; -- besk..av.1
  besk_1_N : N ; -- besk..nn.1
  beska_1_N : N ; -- beska..nn.1
  beskaffad_1_A : A ; -- beskaffad..av.1
  beskaffenhet_1_N : N ; -- beskaffenhet..nn.1
  beskatta_1_V : V ; -- beskatta..vb.1
  beskattande_1_N : N ; -- beskattande..nn.1
  beskattning_1_N : N ; -- beskattning..nn.1
  beskattningsbar_1_A : A ; -- beskattningsbar..av.1
  beskattningsbarhet_1_N : N ; -- beskattningsbarhet..nn.1
  beskattningsgrund_1_N : N ; -- beskattningsgrund..nn.1
  beskattningsgrundande_1_A : A ; -- beskattningsgrundande..av.1
  beskattningsmakt_1_N : N ; -- beskattningsmakt..nn.1
  beskattningsnämnd_1_N : N ; -- beskattningsnämnd..nn.1
  beskattningsprincip_1_N : N ; -- beskattningsprincip..nn.1
  beskattningsrätt_1_N : N ; -- beskattningsrätt..nn.1
  beskattningssätt_1_N : N ; -- beskattningssätt..nn.1
  beskattningsår_1_N : N ; -- beskattningsår..nn.1
  besked_1_N : N ; -- besked..nn.1
  beskedlig_1_A : A ; -- beskedlig..av.1
  beskedlighet_1_N : N ; -- beskedlighet..nn.1
  beskhet_1_N : N ; -- beskhet..nn.1
  beskicka_1_V : V ; -- beskicka..vb.1
  beskickande_1_N : N ; -- beskickande..nn.1
  beskickning_1_N : N ; -- beskickning..nn.1
  beskickningschef_1_N : N ; -- beskickningschef..nn.1
  beskjuta_1_V : V ; -- beskjuta..vb.1
  beskjutande_1_N : N ; -- beskjutande..nn.1
  beskjutning_1_N : N ; -- beskjutning..nn.1
  beskriva_1_V : V ; -- beskriva..vb.1
  beskrivande_1_A : A ; -- beskrivande..av.1
  beskrivande_1_N : N ; -- beskrivande..nn.1
  beskrivbar_1_A : A ; -- beskrivbar..av.1
  beskrivbarhet_1_N : N ; -- beskrivbarhet..nn.1
  beskrivning_1_N : N ; -- beskrivning..nn.1
  besksöta_1_N : N ; -- besksöta..nn.1
  beskugga_1_V : V ; -- beskugga..vb.1
  beskuggande_1_N : N ; -- beskuggande..nn.1
  beskuggning_1_N : N ; -- beskuggning..nn.1
  beskydd_1_N : N ; -- beskydd..nn.1
  beskydda_1_V : V ; -- beskydda..vb.1
  beskyddande_1_N : N ; -- beskyddande..nn.1
  beskyddare_1_N : N ; -- beskyddare..nn.1
  beskyddarverksamhet_1_N : N ; -- beskyddarverksamhet..nn.1
  beskylla_1_V : V ; -- beskylla..vb.1
  beskyllande_1_N : N ; -- beskyllande..nn.1
  beskyllning_1_N : N ; -- beskyllning..nn.1
  beskäftig_1_A : A ; -- beskäftig..av.1
  beskäftighet_1_N : N ; -- beskäftighet..nn.1
  beskällare_1_N : N ; -- beskällare..nn.1
  beskällaresjuka_1_N : N ; -- beskällaresjuka..nn.1
  beskällarsjuka_1_N : N ; -- beskällarsjuka..nn.1
  beskänkt_1_A : A ; -- beskänkt..av.1
  beskära_1_V : V ; -- beskära..vb.1
  beskära_2_V : V ; -- beskära..vb.2
  beskärande_1_N : N ; -- beskärande..nn.1
  beskärd_1_A : A ; -- beskärd..av.1
  beskärm_1_N : N ; -- beskärm..nn.1
  beskärma_1_V : V ; -- beskärma..vb.1
  beskärmande_1_N : N ; -- beskärmande..nn.1
  beskärmare_1_N : N ; -- beskärmare..nn.1
  beskärmelse_1_N : N ; -- beskärmelse..nn.1
  beskärning_1_N : N ; -- beskärning..nn.1
  beskåda_1_V : V ; -- beskåda..vb.1
  beskådande_1_N : N ; -- beskådande..nn.1
  beskådning_1_N : N ; -- beskådning..nn.1
  beslag_1_N : N ; -- beslag..nn.1
  beslagare_1_N : N ; -- beslagare..nn.1
  beslaglägga_1_V : V ; -- beslaglägga..vb.1
  beslagläggande_1_N : N ; -- beslagläggande..nn.1
  beslagsband_1_N : N ; -- beslagsband..nn.1
  beslagsrätt_1_N : N ; -- beslagsrätt..nn.1
  beslagssmed_1_N : N ; -- beslagssmed..nn.1
  beslagssmide_1_N : N ; -- beslagssmide..nn.1
  beslagta_1_V : V ; -- beslagta..vb.1
  beslagtagande_1_N : N ; -- beslagtagande..nn.1
  beslut_1_N : N ; -- beslut..nn.1
  besluta_1_V : V ; -- besluta..vb.1
  beslutande_1_N : N ; -- beslutande..nn.1
  beslutanderätt_1_N : N ; -- beslutanderätt..nn.1
  besluten_1_A : A ; -- besluten..av.1
  beslutenhet_1_N : N ; -- beslutenhet..nn.1
  beslutenlig_1_A : A ; -- beslutenlig..av.1
  beslutenlighet_1_N : N ; -- beslutenlighet..nn.1
  beslutfattande_1_A : A ; -- beslutfattande..av.1
  beslutfattande_1_N : N ; -- beslutfattande..nn.1
  beslutfattare_1_N : N ; -- beslutfattare..nn.1
  beslutför_1_A : A ; -- beslutför..av.1
  beslutförhet_1_N : N ; -- beslutförhet..nn.1
  beslutmässig_1_A : A ; -- beslutmässig..av.1
  beslutmässighet_1_N : N ; -- beslutmässighet..nn.1
  beslutnivå_1_N : N ; -- beslutnivå..nn.1
  beslutsam_1_A : A ; -- beslutsam..av.1
  beslutsamhet_1_N : N ; -- beslutsamhet..nn.1
  beslutsenlig_1_A : A ; -- beslutsenlig..av.1
  beslutsenlighet_1_N : N ; -- beslutsenlighet..nn.1
  beslutsfattande_1_A : A ; -- beslutsfattande..av.1
  beslutsfattande_1_N : N ; -- beslutsfattande..nn.1
  beslutsfattare_1_N : N ; -- beslutsfattare..nn.1
  beslutsför_1_A : A ; -- beslutsför..av.1
  beslutsförhet_1_N : N ; -- beslutsförhet..nn.1
  beslutsförmåga_1_N : N ; -- beslutsförmåga..nn.1
  beslutshierarki_1_N : N ; -- beslutshierarki..nn.1
  beslutskaos_1_N : N ; -- beslutskaos..nn.1
  beslutskapabel_1_A : A ; -- beslutskapabel..av.1
  beslutskorridor_1_N : N ; -- beslutskorridor..nn.1
  beslutsmässig_1_A : A ; -- beslutsmässig..av.1
  beslutsmässighet_1_N : N ; -- beslutsmässighet..nn.1
  beslutsnivå_1_N : N ; -- beslutsnivå..nn.1
  beslutsprocess_1_N : N ; -- beslutsprocess..nn.1
  beslutsrum_1_N : N ; -- beslutsrum..nn.1
  beslutsrymd_1_N : N ; -- beslutsrymd..nn.1
  beslutsrätt_1_N : N ; -- beslutsrätt..nn.1
  beslutsunderlag_1_N : N ; -- beslutsunderlag..nn.1
  beslutsångest_1_N : N ; -- beslutsångest..nn.1
  besläktad_1_A : A ; -- besläktad..av.1
  beslå_1_V : V ; -- beslå..vb.1
  beslående_1_N : N ; -- beslående..nn.1
  beslöja_1_V : V ; -- beslöja..vb.1
  beslöjad_1_A : A ; -- beslöjad..av.1
  beslöjande_1_N : N ; -- beslöjande..nn.1
  beslöjning_1_N : N ; -- beslöjning..nn.1
  besman_1_N : N ; -- besman..nn.1
  besmanskrok_1_N : N ; -- besmanskrok..nn.1
  besmitta_1_V : V ; -- besmitta..vb.1
  besmittande_1_N : N ; -- besmittande..nn.1
  besmittelse_1_N : N ; -- besmittelse..nn.1
  besmörja_1_V : V ; -- besmörja..vb.1
  besmörjande_1_N : N ; -- besmörjande..nn.1
  besockra_1_V : V ; -- besockra..vb.1
  besockrande_1_N : N ; -- besockrande..nn.1
  besolda_1_V : V ; -- besolda..vb.1
  besoldande_1_N : N ; -- besoldande..nn.1
  besoldning_1_N : N ; -- besoldning..nn.1
  bespara_1_V : V ; -- bespara..vb.1
  besparande_1_N : N ; -- besparande..nn.1
  besparing_1_N : N ; -- besparing..nn.1
  besparingskrav_1_N : N ; -- besparingskrav..nn.1
  besparingsskog_1_N : N ; -- besparingsskog..nn.1
  besparingstorped_1_N : N ; -- besparingstorped..nn.1
  bespeja_1_V : V ; -- bespeja..vb.1
  bespejande_1_N : N ; -- bespejande..nn.1
  bespejning_1_N : N ; -- bespejning..nn.1
  bespisa_1_V : V ; -- bespisa..vb.1
  bespisande_1_N : N ; -- bespisande..nn.1
  bespisning_1_N : N ; -- bespisning..nn.1
  bespola_1_V : V ; -- bespola..vb.1
  bespolande_1_N : N ; -- bespolande..nn.1
  bespotta_1_V : V ; -- bespotta..vb.1
  bespottande_1_N : N ; -- bespottande..nn.1
  bespottare_1_N : N ; -- bespottare..nn.1
  bespottelse_1_N : N ; -- bespottelse..nn.1
  bespruta_1_V : V ; -- bespruta..vb.1
  besprutande_1_N : N ; -- besprutande..nn.1
  besprutning_1_N : N ; -- besprutning..nn.1
  besprutningsmedel_1_N : N ; -- besprutningsmedel..nn.1
  besprutningsvätska_1_N : N ; -- besprutningsvätska..nn.1
  bessemerblåsning_1_N : N ; -- bessemerblåsning..nn.1
  bessemerstål_1_N : N ; -- bessemerstål..nn.1
  bessemerugn_1_N : N ; -- bessemerugn..nn.1
  besservisser_1_N : N ; -- besservisser..nn.1
  besserwisser_1_N : N ; -- besserwisser..nn.1
  besserwisserattityd_1_N : N ; -- besserwisserattityd..nn.1
  besserwissra_1_V : V ; -- besserwissra..vb.1
  besserwissrande_1_N : N ; -- besserwissrande..nn.1
  best_1_N : N ; -- best..nn.1
  bestialisk_1_A : A ; -- bestialisk..av.1
  bestialitet_1_N : N ; -- bestialitet..nn.1
  bestick_1_N : N ; -- bestick..nn.1
  besticka_1_V : V ; -- besticka..vb.1
  bestickande_1_A : A ; -- bestickande..av.1
  bestickande_1_N : N ; -- bestickande..nn.1
  bestickföring_1_N : N ; -- bestickföring..nn.1
  besticklig_1_A : A ; -- besticklig..av.1
  besticklighet_1_N : N ; -- besticklighet..nn.1
  bestickning_1_N : N ; -- bestickning..nn.1
  bestiga_1_V : V ; -- bestiga..vb.1
  bestigande_1_N : N ; -- bestigande..nn.1
  bestigning_1_N : N ; -- bestigning..nn.1
  bestjäla_1_V : V ; -- bestjäla..vb.1
  bestjälande_1_N : N ; -- bestjälande..nn.1
  bestorma_1_V : V ; -- bestorma..vb.1
  bestormande_1_N : N ; -- bestormande..nn.1
  bestormning_1_N : N ; -- bestormning..nn.1
  bestraffa_1_V : V ; -- bestraffa..vb.1
  bestraffande_1_N : N ; -- bestraffande..nn.1
  bestraffning_1_N : N ; -- bestraffning..nn.1
  bestraffningskrig_1_N : N ; -- bestraffningskrig..nn.1
  bestraffningsmedel_1_N : N ; -- bestraffningsmedel..nn.1
  bestraffningssätt_1_N : N ; -- bestraffningssätt..nn.1
  bestrida_1_V : V ; -- bestrida..vb.1
  bestridande_1_N : N ; -- bestridande..nn.1
  bestryka_1_V : V ; -- bestryka..vb.1
  bestrykande_1_N : N ; -- bestrykande..nn.1
  bestrykning_1_N : N ; -- bestrykning..nn.1
  bestråla_1_V : V ; -- bestråla..vb.1
  bestrålande_1_N : N ; -- bestrålande..nn.1
  bestrålning_1_N : N ; -- bestrålning..nn.1
  beströ_1_V : V ; -- beströ..vb.1
  beströende_1_N : N ; -- beströende..nn.1
  bestseller_1_N : N ; -- bestseller..nn.1
  bestsellerförfattare_1_N : N ; -- bestsellerförfattare..nn.1
  bestycka_1_V : V ; -- bestycka..vb.1
  bestyckande_1_N : N ; -- bestyckande..nn.1
  bestyckning_1_N : N ; -- bestyckning..nn.1
  bestyr_1_N : N ; -- bestyr..nn.1
  bestyra_1_V : V ; -- bestyra..vb.1
  bestyrande_1_N : N ; -- bestyrande..nn.1
  bestyrka_1_V : V ; -- bestyrka..vb.1
  bestyrkande_1_N : N ; -- bestyrkande..nn.1
  beställa_1_V : V ; -- beställa..vb.1
  beställa_2_V : V ; -- beställa..vb.2
  beställande_1_N : N ; -- beställande..nn.1
  beställare_1_N : N ; -- beställare..nn.1
  beställning_1_N : N ; -- beställning..nn.1
  beställningsarbete_1_N : N ; -- beställningsarbete..nn.1
  beställningsavgift_1_N : N ; -- beställningsavgift..nn.1
  beställningsmord_1_N : N ; -- beställningsmord..nn.1
  beställningsverk_1_N : N ; -- beställningsverk..nn.1
  beställsam_1_A : A ; -- beställsam..av.1
  beställsamhet_1_N : N ; -- beställsamhet..nn.1
  beställt_1_A : A ; -- beställt..av.1
  bestämbar_1_A : A ; -- bestämbar..av.1
  bestämbarhet_1_N : N ; -- bestämbarhet..nn.1
  bestämd_1_A : A ; -- bestämd..av.1
  bestämdhet_1_N : N ; -- bestämdhet..nn.1
  bestämma_1_V : V ; -- bestämma..vb.1
  bestämmande_1_N : N ; -- bestämmande..nn.1
  bestämmanderätt_1_N : N ; -- bestämmanderätt..nn.1
  bestämmelse_1_N : N ; -- bestämmelse..nn.1
  bestämmelseort_1_N : N ; -- bestämmelseort..nn.1
  bestämning_1_N : N ; -- bestämning..nn.1
  bestämningsord_1_N : N ; -- bestämningsord..nn.1
  beständig_1_A : A ; -- beständig..av.1
  beständighet_1_N : N ; -- beständighet..nn.1
  bestänka_1_V : V ; -- bestänka..vb.1
  bestänkande_1_N : N ; -- bestänkande..nn.1
  bestänkning_1_N : N ; -- bestänkning..nn.1
  bestå_1_V : V ; -- bestå..vb.1
  bestå_2_V : V ; -- bestå..vb.2
  bestående_1_A : A ; -- bestående..av.1
  bestående_1_N : N ; -- bestående..nn.1
  bestånd_1_N : N ; -- bestånd..nn.1
  beståndande_1_A : A ; -- beståndande..av.1
  beståndsbildande_1_A : A ; -- beståndsbildande..av.1
  beståndsdel_1_N : N ; -- beståndsdel..nn.1
  beståndsmässig_1_A : A ; -- beståndsmässig..av.1
  bestört_1_A : A ; -- bestört..av.1
  bestörthet_1_N : N ; -- bestörthet..nn.1
  bestörtning_1_N : N ; -- bestörtning..nn.1
  besudla_1_V : V ; -- besudla..vb.1
  besudlande_1_N : N ; -- besudlande..nn.1
  besudling_1_N : N ; -- besudling..nn.1
  besutten_1_A : A ; -- besutten..av.1
  besuttenhet_1_N : N ; -- besuttenhet..nn.1
  besvara_1_V : V ; -- besvara..vb.1
  besvarande_1_N : N ; -- besvarande..nn.1
  besvikelse_1_N : N ; -- besvikelse..nn.1
  besviken_1_A : A ; -- besviken..av.1
  besvikenhet_1_N : N ; -- besvikenhet..nn.1
  besvär_1_N : N ; -- besvär..nn.1
  besvära_1_V : V ; -- besvära..vb.1
  besvärad_1_A : A ; -- besvärad..av.1
  besvärande_1_A : A ; -- besvärande..av.1
  besvärande_1_N : N ; -- besvärande..nn.1
  besvärja_1_V : V ; -- besvärja..vb.1
  besvärjande_1_N : N ; -- besvärjande..nn.1
  besvärjare_1_N : N ; -- besvärjare..nn.1
  besvärjelse_1_N : N ; -- besvärjelse..nn.1
  besvärjelseformel_1_N : N ; -- besvärjelseformel..nn.1
  besvärjning_1_N : N ; -- besvärjning..nn.1
  besvärlig_1_A : A ; -- besvärlig..av.1
  besvärlighet_1_N : N ; -- besvärlighet..nn.1
  besvärsfri_1_A : A ; -- besvärsfri..av.1
  besvärsgrund_1_N : N ; -- besvärsgrund..nn.1
  besvärshandling_1_N : N ; -- besvärshandling..nn.1
  besvärshänvisning_1_N : N ; -- besvärshänvisning..nn.1
  besvärsinlaga_1_N : N ; -- besvärsinlaga..nn.1
  besvärsinstans_1_N : N ; -- besvärsinstans..nn.1
  besvärsmyndighet_1_N : N ; -- besvärsmyndighet..nn.1
  besvärsmål_1_N : N ; -- besvärsmål..nn.1
  besvärsrätt_1_N : N ; -- besvärsrätt..nn.1
  besvärsskrift_1_N : N ; -- besvärsskrift..nn.1
  besvärssubjekt_1_N : N ; -- besvärssubjekt..nn.1
  besvärstid_1_N : N ; -- besvärstid..nn.1
  besvärsväg_1_N : N ; -- besvärsväg..nn.1
  besvågrad_1_A : A ; -- besvågrad..av.1
  besynnerlig_1_A : A ; -- besynnerlig..av.1
  besynnerlighet_1_N : N ; -- besynnerlighet..nn.1
  besätta_1_V : V ; -- besätta..vb.1
  besättande_1_N : N ; -- besättande..nn.1
  besättning_1_N : N ; -- besättning..nn.1
  besättningsband_1_N : N ; -- besättningsband..nn.1
  besättningsman_1_N : N ; -- besättningsman..nn.1
  besättningsmedlem_1_N : N ; -- besättningsmedlem..nn.1
  beså_1_V : V ; -- beså..vb.1
  besående_1_N : N ; -- besående..nn.1
  besök_1_N : N ; -- besök..nn.1
  besöka_1_V : V ; -- besöka..vb.1
  besökande_1_N : N ; -- besökande..nn.1
  besökande_2_N : N ; -- besökande..nn.2
  besökare_1_N : N ; -- besökare..nn.1
  besöksadress_1_N : N ; -- besöksadress..nn.1
  besöksbok_1_N : N ; -- besöksbok..nn.1
  besöksdag_1_N : N ; -- besöksdag..nn.1
  besöksfåtölj_1_N : N ; -- besöksfåtölj..nn.1
  besöksförbud_1_N : N ; -- besöksförbud..nn.1
  besöksnäring_1_N : N ; -- besöksnäring..nn.1
  besöksrekord_1_N : N ; -- besöksrekord..nn.1
  besöksrestriktion_1_N : N ; -- besöksrestriktion..nn.1
  besöksrum_1_N : N ; -- besöksrum..nn.1
  besöksstol_1_N : N ; -- besöksstol..nn.1
  besökstid_1_N : N ; -- besökstid..nn.1
  besökstopp_1_N : N ; -- besökstopp..nn.1
  besörja_1_V : V ; -- besörja..vb.1
  besörjande_1_N : N ; -- besörjande..nn.1
  bet_1_N : N ; -- bet..nn.1
  beta_1_N : N ; -- beta..nn.1
  beta_2_N : N ; -- beta..nn.2
  beta_1_V : V ; -- beta..vb.1
  beta_2_V : V ; -- beta..vb.2
  betablockerare_1_N : N ; -- betablockerare..nn.1
  betagande_1_A : A ; -- betagande..av.1
  betagande_1_N : N ; -- betagande..nn.1
  betagen_1_A : A ; -- betagen..av.1
  betagenhet_1_N : N ; -- betagenhet..nn.1
  betala_1_V : V ; -- betala..vb.1
  betalande_1_N : N ; -- betalande..nn.1
  betalare_1_N : N ; -- betalare..nn.1
  betalartikel_1_N : N ; -- betalartikel..nn.1
  betalbar_1_A : A ; -- betalbar..av.1
  betalbarhet_1_N : N ; -- betalbarhet..nn.1
  betalkort_1_N : N ; -- betalkort..nn.1
  betalkurs_1_N : N ; -- betalkurs..nn.1
  betalning_1_N : N ; -- betalning..nn.1
  betalningsanmärkning_1_N : N ; -- betalningsanmärkning..nn.1
  betalningsanstånd_1_N : N ; -- betalningsanstånd..nn.1
  betalningsavtal_1_N : N ; -- betalningsavtal..nn.1
  betalningsbalans_1_N : N ; -- betalningsbalans..nn.1
  betalningsbevis_1_N : N ; -- betalningsbevis..nn.1
  betalningsdag_1_N : N ; -- betalningsdag..nn.1
  betalningsfri_1_A : A ; -- betalningsfri..av.1
  betalningsfrist_1_N : N ; -- betalningsfrist..nn.1
  betalningsföreläggande_1_N : N ; -- betalningsföreläggande..nn.1
  betalningsförmåga_1_N : N ; -- betalningsförmåga..nn.1
  betalningsgill_1_A : A ; -- betalningsgill..av.1
  betalningsinställelse_1_N : N ; -- betalningsinställelse..nn.1
  betalningsmedel_1_N : N ; -- betalningsmedel..nn.1
  betalningsskyldig_1_A : A ; -- betalningsskyldig..av.1
  betalningsskyldighet_1_N : N ; -- betalningsskyldighet..nn.1
  betalningssäkra_1_V : V ; -- betalningssäkra..vb.1
  betalningstermin_1_N : N ; -- betalningstermin..nn.1
  betalningstid_1_N : N ; -- betalningstid..nn.1
  betalningsvilja_1_N : N ; -- betalningsvilja..nn.1
  betalningsvillkor_1_N : N ; -- betalningsvillkor..nn.1
  betalsex_1_N : N ; -- betalsex..nn.1
  betaltjänst_1_N : N ; -- betaltjänst..nn.1
  betande_1_N : N ; -- betande..nn.1
  betapartikel_1_N : N ; -- betapartikel..nn.1
  betastrålande_1_A : A ; -- betastrålande..av.1
  betastrålning_1_N : N ; -- betastrålning..nn.1
  betasönderfall_1_N : N ; -- betasönderfall..nn.1
  betatron_1_N : N ; -- betatron..nn.1
  bete_1_N : N ; -- bete..nn.1
  bete_2_N : N ; -- bete..nn.2
  beteckna_1_V : V ; -- beteckna..vb.1
  betecknande_1_A : A ; -- betecknande..av.1
  betecknande_1_N : N ; -- betecknande..nn.1
  beteckning_1_N : N ; -- beteckning..nn.1
  beteckningssätt_1_N : N ; -- beteckningssätt..nn.1
  beteende_1_N : N ; -- beteende..nn.1
  beteendebehandling_1_N : N ; -- beteendebehandling..nn.1
  beteendeforskning_1_N : N ; -- beteendeforskning..nn.1
  beteendemässig_1_A : A ; -- beteendemässig..av.1
  beteendemönster_1_N : N ; -- beteendemönster..nn.1
  beteendepsykologi_1_N : N ; -- beteendepsykologi..nn.1
  beteenderubbning_1_N : N ; -- beteenderubbning..nn.1
  beteendeterapeut_1_N : N ; -- beteendeterapeut..nn.1
  beteendeterapi_1_N : N ; -- beteendeterapi..nn.1
  beteendevetare_1_N : N ; -- beteendevetare..nn.1
  beteendevetenskap_1_N : N ; -- beteendevetenskap..nn.1
  beteendevetenskaplig_1_A : A ; -- beteendevetenskaplig..av.1
  betel_1_N : N ; -- betel..nn.1
  betelblad_1_N : N ; -- betelblad..nn.1
  betelnöt_1_N : N ; -- betelnöt..nn.1
  betelpalm_1_N : N ; -- betelpalm..nn.1
  beteltuggare_1_N : N ; -- beteltuggare..nn.1
  beteltuggning_1_N : N ; -- beteltuggning..nn.1
  betesgång_1_N : N ; -- betesgång..nn.1
  beteshage_1_N : N ; -- beteshage..nn.1
  betesland_1_N : N ; -- betesland..nn.1
  betesmark_1_N : N ; -- betesmark..nn.1
  betesområde_1_N : N ; -- betesområde..nn.1
  betesplats_1_N : N ; -- betesplats..nn.1
  betessläpp_1_N : N ; -- betessläpp..nn.1
  betesutsläpp_1_N : N ; -- betesutsläpp..nn.1
  beting_1_N : N ; -- beting..nn.1
  beting_2_N : N ; -- beting..nn.2
  betinga_1_V : V ; -- betinga..vb.1
  betingad_1_A : A ; -- betingad..av.1
  betingande_1_N : N ; -- betingande..nn.1
  betingelse_1_N : N ; -- betingelse..nn.1
  betingning_1_N : N ; -- betingning..nn.1
  betingsarbete_1_N : N ; -- betingsarbete..nn.1
  betingsläsning_1_N : N ; -- betingsläsning..nn.1
  betitla_1_V : V ; -- betitla..vb.1
  betitlande_1_N : N ; -- betitlande..nn.1
  betitta_1_V : V ; -- betitta..vb.1
  betittande_1_N : N ; -- betittande..nn.1
  betjäna_1_V : V ; -- betjäna..vb.1
  betjänande_1_N : N ; -- betjänande..nn.1
  betjäning_1_N : N ; -- betjäning..nn.1
  betjäningsavgift_1_N : N ; -- betjäningsavgift..nn.1
  betjänt_1_A : A ; -- betjänt..av.1
  betjänt_1_N : N ; -- betjänt..nn.1
  betkampanj_1_N : N ; -- betkampanj..nn.1
  betmedel_1_N : N ; -- betmedel..nn.1
  betning_1_N : N ; -- betning..nn.1
  betodling_1_N : N ; -- betodling..nn.1
  betona_1_V : V ; -- betona..vb.1
  betonad_1_A : A ; -- betonad..av.1
  betonande_1_N : N ; -- betonande..nn.1
  betong_1_N : N ; -- betong..nn.1
  betongbjälklag_1_N : N ; -- betongbjälklag..nn.1
  betongblandare_1_N : N ; -- betongblandare..nn.1
  betongblock_1_N : N ; -- betongblock..nn.1
  betongbädd_1_N : N ; -- betongbädd..nn.1
  betongera_1_V : V ; -- betongera..vb.1
  betongerande_1_N : N ; -- betongerande..nn.1
  betongerbar_1_A : A ; -- betongerbar..av.1
  betongerbarhet_1_N : N ; -- betongerbarhet..nn.1
  betongering_1_N : N ; -- betongering..nn.1
  betongfärg_1_N : N ; -- betongfärg..nn.1
  betonggolv_1_N : N ; -- betonggolv..nn.1
  betonghinder_1_N : N ; -- betonghinder..nn.1
  betonghäck_1_N : N ; -- betonghäck..nn.1
  betongmaskin_1_N : N ; -- betongmaskin..nn.1
  betongparti_1_N : N ; -- betongparti..nn.1
  betongpåle_1_N : N ; -- betongpåle..nn.1
  betongsugga_1_N : N ; -- betongsugga..nn.1
  betongvalv_1_N : N ; -- betongvalv..nn.1
  betongvibrator_1_N : N ; -- betongvibrator..nn.1
  betoning_1_N : N ; -- betoning..nn.1
  betrakta_1_V : V ; -- betrakta..vb.1
  betraktande_1_N : N ; -- betraktande..nn.1
  betraktare_1_N : N ; -- betraktare..nn.1
  betraktelse_1_N : N ; -- betraktelse..nn.1
  betraktelsesätt_1_N : N ; -- betraktelsesätt..nn.1
  betro_1_V : V ; -- betro..vb.1
  betrodd_1_A : A ; -- betrodd..av.1
  betroddhet_1_N : N ; -- betroddhet..nn.1
  betroende_1_N : N ; -- betroende..nn.1
  betryck_1_N : N ; -- betryck..nn.1
  betrycka_1_V : V ; -- betrycka..vb.1
  betryckande_1_N : N ; -- betryckande..nn.1
  betryckt_1_A : A ; -- betryckt..av.1
  betryckthet_1_N : N ; -- betryckthet..nn.1
  betrygga_1_V : V ; -- betrygga..vb.1
  betryggande_1_A : A ; -- betryggande..av.1
  betryggande_1_N : N ; -- betryggande..nn.1
  beträda_1_V : V ; -- beträda..vb.1
  beträdande_1_N : N ; -- beträdande..nn.1
  beträffa_1_V : V ; -- beträffa..vb.1
  beträffande_1_N : N ; -- beträffande..nn.1
  beträngd_1_A : A ; -- beträngd..av.1
  beträngdhet_1_N : N ; -- beträngdhet..nn.1
  bets_1_N : N ; -- bets..nn.1
  betsa_1_V : V ; -- betsa..vb.1
  betsande_1_N : N ; -- betsande..nn.1
  betsel_1_N : N ; -- betsel..nn.1
  betsla_1_V : V ; -- betsla..vb.1
  betslande_1_N : N ; -- betslande..nn.1
  betsling_1_N : N ; -- betsling..nn.1
  betsmedel_1_N : N ; -- betsmedel..nn.1
  betsning_1_N : N ; -- betsning..nn.1
  betsocker_1_N : N ; -- betsocker..nn.1
  betsockerindustri_1_N : N ; -- betsockerindustri..nn.1
  bett_1_N : N ; -- bett..nn.1
  bettel_1_N : N ; -- bettel..nn.1
  bettla_1_V : V ; -- bettla..vb.1
  bettlande_1_N : N ; -- bettlande..nn.1
  bettlare_1_N : N ; -- bettlare..nn.1
  bettleri_1_N : N ; -- bettleri..nn.1
  bettskena_1_N : N ; -- bettskena..nn.1
  betunga_1_V : V ; -- betunga..vb.1
  betungande_1_A : A ; -- betungande..av.1
  betungande_1_N : N ; -- betungande..nn.1
  betuttad_1_A : A ; -- betuttad..av.1
  betvinga_1_V : V ; -- betvinga..vb.1
  betvingande_1_A : A ; -- betvingande..av.1
  betvingande_1_N : N ; -- betvingande..nn.1
  betvingare_1_N : N ; -- betvingare..nn.1
  betvivla_1_V : V ; -- betvivla..vb.1
  betvivlande_1_N : N ; -- betvivlande..nn.1
  betyda_1_V : V ; -- betyda..vb.1
  betydande_1_A : A ; -- betydande..av.1
  betydande_1_N : N ; -- betydande..nn.1
  betydelse_1_N : N ; -- betydelse..nn.1
  betydelsebärande_1_A : A ; -- betydelsebärande..av.1
  betydelsefattig_1_A : A ; -- betydelsefattig..av.1
  betydelsefull_1_A : A ; -- betydelsefull..av.1
  betydelsefullhet_1_N : N ; -- betydelsefullhet..nn.1
  betydelseförskjutning_1_N : N ; -- betydelseförskjutning..nn.1
  betydelseförändring_1_N : N ; -- betydelseförändring..nn.1
  betydelseglidning_1_N : N ; -- betydelseglidning..nn.1
  betydelselager_1_N : N ; -- betydelselager..nn.1
  betydelselära_1_N : N ; -- betydelselära..nn.1
  betydelselös_1_A : A ; -- betydelselös..av.1
  betydelselöshet_1_N : N ; -- betydelselöshet..nn.1
  betydelsemässig_1_A : A ; -- betydelsemässig..av.1
  betydelsenyans_1_N : N ; -- betydelsenyans..nn.1
  betydelseskikt_1_N : N ; -- betydelseskikt..nn.1
  betydelseutveckling_1_N : N ; -- betydelseutveckling..nn.1
  betydenhet_1_N : N ; -- betydenhet..nn.1
  betydlig_1_A : A ; -- betydlig..av.1
  betydlighet_1_N : N ; -- betydlighet..nn.1
  betyg_1_N : N ; -- betyg..nn.1
  betyga_1_V : V ; -- betyga..vb.1
  betygande_1_N : N ; -- betygande..nn.1
  betygelse_1_N : N ; -- betygelse..nn.1
  betyghöjning_1_N : N ; -- betyghöjning..nn.1
  betygkramare_1_N : N ; -- betygkramare..nn.1
  betygsavskrift_1_N : N ; -- betygsavskrift..nn.1
  betygsfri_1_A : A ; -- betygsfri..av.1
  betygsgrad_1_N : N ; -- betygsgrad..nn.1
  betygshets_1_N : N ; -- betygshets..nn.1
  betygshöjning_1_N : N ; -- betygshöjning..nn.1
  betygsjäkt_1_N : N ; -- betygsjäkt..nn.1
  betygskatalog_1_N : N ; -- betygskatalog..nn.1
  betygsnämnd_1_N : N ; -- betygsnämnd..nn.1
  betygsskala_1_N : N ; -- betygsskala..nn.1
  betygsstress_1_N : N ; -- betygsstress..nn.1
  betygssänkning_1_N : N ; -- betygssänkning..nn.1
  betygssätta_1_V : V ; -- betygssätta..vb.1
  betygssättande_1_N : N ; -- betygssättande..nn.1
  betygssättning_1_N : N ; -- betygssättning..nn.1
  betygsänkning_1_N : N ; -- betygsänkning..nn.1
  betygsätta_1_V : V ; -- betygsätta..vb.1
  betygsättande_1_N : N ; -- betygsättande..nn.1
  betygsättning_1_N : N ; -- betygsättning..nn.1
  betäcka_1_V : V ; -- betäcka..vb.1
  betäckande_1_N : N ; -- betäckande..nn.1
  betäckning_1_N : N ; -- betäckning..nn.1
  betäckningsavgift_1_N : N ; -- betäckningsavgift..nn.1
  betänka_1_V : V ; -- betänka..vb.1
  betänkande_1_N : N ; -- betänkande..nn.1
  betänketid_1_N : N ; -- betänketid..nn.1
  betänklig_1_A : A ; -- betänklig..av.1
  betänklighet_1_N : N ; -- betänklighet..nn.1
  betänksam_1_A : A ; -- betänksam..av.1
  betänksamhet_1_N : N ; -- betänksamhet..nn.1
  betänkt_1_A : A ; -- betänkt..av.1
  beundra_1_V : V ; -- beundra..vb.1
  beundrande_1_N : N ; -- beundrande..nn.1
  beundransvärd_1_A : A ; -- beundransvärd..av.1
  beundransvärdhet_1_N : N ; -- beundransvärdhet..nn.1
  beundrare_1_N : N ; -- beundrare..nn.1
  beundrarinna_1_N : N ; -- beundrarinna..nn.1
  bevaka_1_V : V ; -- bevaka..vb.1
  bevakande_1_N : N ; -- bevakande..nn.1
  bevakning_1_N : N ; -- bevakning..nn.1
  bevakningsinlaga_1_N : N ; -- bevakningsinlaga..nn.1
  bevakningsinsats_1_N : N ; -- bevakningsinsats..nn.1
  bevakningskedja_1_N : N ; -- bevakningskedja..nn.1
  bevakningsområde_1_N : N ; -- bevakningsområde..nn.1
  bevakningsuppdrag_1_N : N ; -- bevakningsuppdrag..nn.1
  bevandrad_1_A : A ; -- bevandrad..av.1
  bevara_1_V : V ; -- bevara..vb.1
  bevarande_1_N : N ; -- bevarande..nn.1
  bevarandeomständighet_1_N : N ; -- bevarandeomständighet..nn.1
  bevare_1_V : V ; -- bevare..vb.1
  bevattna_1_V : V ; -- bevattna..vb.1
  bevattnande_1_N : N ; -- bevattnande..nn.1
  bevattning_1_N : N ; -- bevattning..nn.1
  bevattningsanläggning_1_N : N ; -- bevattningsanläggning..nn.1
  bevattningsförbud_1_N : N ; -- bevattningsförbud..nn.1
  bevattningskanal_1_N : N ; -- bevattningskanal..nn.1
  bevattningsregel_1_N : N ; -- bevattningsregel..nn.1
  bevattningssystem_1_N : N ; -- bevattningssystem..nn.1
  beveka_1_V : V ; -- beveka..vb.1
  bevekande_1_A : A ; -- bevekande..av.1
  bevekande_1_N : N ; -- bevekande..nn.1
  bevekelse_1_N : N ; -- bevekelse..nn.1
  bevekelsegrund_1_N : N ; -- bevekelsegrund..nn.1
  bevilja_1_V : V ; -- bevilja..vb.1
  beviljande_1_N : N ; -- beviljande..nn.1
  bevillning_1_N : N ; -- bevillning..nn.1
  bevillningsavgift_1_N : N ; -- bevillningsavgift..nn.1
  bevillningsutskott_1_N : N ; -- bevillningsutskott..nn.1
  bevingad_1_A : A ; -- bevingad..av.1
  bevis_1_N : N ; -- bevis..nn.1
  bevisa_1_V : V ; -- bevisa..vb.1
  bevisande_1_N : N ; -- bevisande..nn.1
  bevisbar_1_A : A ; -- bevisbar..av.1
  bevisbarhet_1_N : N ; -- bevisbarhet..nn.1
  bevisbörda_1_N : N ; -- bevisbörda..nn.1
  bevisföring_1_N : N ; -- bevisföring..nn.1
  bevisförvanskning_1_N : N ; -- bevisförvanskning..nn.1
  beviskedja_1_N : N ; -- beviskedja..nn.1
  beviskraft_1_N : N ; -- beviskraft..nn.1
  beviskraftig_1_A : A ; -- beviskraftig..av.1
  beviskraftighet_1_N : N ; -- beviskraftighet..nn.1
  beviskrav_1_N : N ; -- beviskrav..nn.1
  bevislig_1_A : A ; -- bevislig..av.1
  bevisligen_1_Adv : Adv ; -- bevisligen..ab.1
  bevislighet_1_N : N ; -- bevislighet..nn.1
  bevismaterial_1_N : N ; -- bevismaterial..nn.1
  bevismedel_1_N : N ; -- bevismedel..nn.1
  bevismässig_1_A : A ; -- bevismässig..av.1
  bevisning_1_N : N ; -- bevisning..nn.1
  bevisprövning_1_N : N ; -- bevisprövning..nn.1
  bevisskyldig_1_A : A ; -- bevisskyldig..av.1
  bevisskyldighet_1_N : N ; -- bevisskyldighet..nn.1
  bevissvårighet_1_N : N ; -- bevissvårighet..nn.1
  bevissäkring_1_N : N ; -- bevissäkring..nn.1
  bevista_1_V : V ; -- bevista..vb.1
  bevistande_1_N : N ; -- bevistande..nn.1
  bevisvärde_1_N : N ; -- bevisvärde..nn.1
  bevisvärdering_1_N : N ; -- bevisvärdering..nn.1
  bevittna_1_V : V ; -- bevittna..vb.1
  bevittnande_1_N : N ; -- bevittnande..nn.1
  bevuxen_1_A : A ; -- bevuxen..av.1
  bevänt_1_A : A ; -- bevänt..av.1
  beväpna_1_V : V ; -- beväpna..vb.1
  beväpnad_1_A : A ; -- beväpnad..av.1
  beväpnande_1_N : N ; -- beväpnande..nn.1
  beväpning_1_N : N ; -- beväpning..nn.1
  bevära_1_V : V ; -- bevära..vb.1
  bevärande_1_N : N ; -- bevärande..nn.1
  bevärdiga_1_V : V ; -- bevärdiga..vb.1
  bevärdigande_1_N : N ; -- bevärdigande..nn.1
  beväring_1_N : N ; -- beväring..nn.1
  beväxt_1_A : A ; -- beväxt..av.1
  bevågen_1_A : A ; -- bevågen..av.1
  bevågenhet_1_N : N ; -- bevågenhet..nn.1
  bezique_1_N : N ; -- bezique..nn.1
  bhutanes_1_N : N ; -- bhutanes..nn.1
  bhutanesisk_1_A : A ; -- bhutanesisk..av.1
  bhutanesiska_1_N : N ; -- bhutanesiska..nn.1
  bi_1_A : A ; -- bi..av.1
  bi_1_N : N ; -- bi..nn.1
  biaccent_1_N : N ; -- biaccent..nn.1
  bias_1_N : N ; -- bias..nn.1
  biavel_1_N : N ; -- biavel..nn.1
  biavsikt_1_N : N ; -- biavsikt..nn.1
  bibana_1_N : N ; -- bibana..nn.1
  bibehålla_1_V : V ; -- bibehålla..vb.1
  bibehållande_1_N : N ; -- bibehållande..nn.1
  bibehållen_1_A : A ; -- bibehållen..av.1
  bibel_1_N : N ; -- bibel..nn.1
  bibelcitat_1_N : N ; -- bibelcitat..nn.1
  bibelexeget_1_N : N ; -- bibelexeget..nn.1
  bibelforskning_1_N : N ; -- bibelforskning..nn.1
  bibelförklaring_1_N : N ; -- bibelförklaring..nn.1
  bibelhandskrift_1_N : N ; -- bibelhandskrift..nn.1
  bibelkanon_1_N : N ; -- bibelkanon..nn.1
  bibelkommission_1_N : N ; -- bibelkommission..nn.1
  bibelkonkordans_1_N : N ; -- bibelkonkordans..nn.1
  bibelkristen_1_A : A ; -- bibelkristen..av.1
  bibelkristenhet_1_N : N ; -- bibelkristenhet..nn.1
  bibelkritik_1_N : N ; -- bibelkritik..nn.1
  bibelkunnig_1_A : A ; -- bibelkunnig..av.1
  bibelkunnighet_1_N : N ; -- bibelkunnighet..nn.1
  bibelord_1_N : N ; -- bibelord..nn.1
  bibelsamtal_1_N : N ; -- bibelsamtal..nn.1
  bibelsprängd_1_A : A ; -- bibelsprängd..av.1
  bibelsprängdhet_1_N : N ; -- bibelsprängdhet..nn.1
  bibelspråk_1_N : N ; -- bibelspråk..nn.1
  bibelställe_1_N : N ; -- bibelställe..nn.1
  bibelsällskap_1_N : N ; -- bibelsällskap..nn.1
  bibeltext_1_N : N ; -- bibeltext..nn.1
  bibeltolkning_1_N : N ; -- bibeltolkning..nn.1
  bibeltroende_1_A : A ; -- bibeltroende..av.1
  bibeltrogen_1_A : A ; -- bibeltrogen..av.1
  bibeltrogenhet_1_N : N ; -- bibeltrogenhet..nn.1
  bibelvers_1_N : N ; -- bibelvers..nn.1
  bibelöversättning_1_N : N ; -- bibelöversättning..nn.1
  bibestämning_1_N : N ; -- bibestämning..nn.1
  bibetydelse_1_N : N ; -- bibetydelse..nn.1
  biblicism_1_N : N ; -- biblicism..nn.1
  biblicistisk_1_A : A ; -- biblicistisk..av.1
  bibliofil_1_N : N ; -- bibliofil..nn.1
  bibliofilupplaga_1_N : N ; -- bibliofilupplaga..nn.1
  bibliograf_1_N : N ; -- bibliograf..nn.1
  bibliografi_1_N : N ; -- bibliografi..nn.1
  bibliografisk_1_A : A ; -- bibliografisk..av.1
  biblioman_1_N : N ; -- biblioman..nn.1
  bibliomani_1_N : N ; -- bibliomani..nn.1
  bibliometri_1_N : N ; -- bibliometri..nn.1
  bibliotek_1_N : N ; -- bibliotek..nn.1
  bibliotekarie_1_N : N ; -- bibliotekarie..nn.1
  biblioteksavgift_1_N : N ; -- biblioteksavgift..nn.1
  biblioteksband_1_N : N ; -- biblioteksband..nn.1
  biblioteksbelysning_1_N : N ; -- biblioteksbelysning..nn.1
  biblioteksbord_1_N : N ; -- biblioteksbord..nn.1
  biblioteksbrand_1_N : N ; -- biblioteksbrand..nn.1
  bibliotekshögskola_1_N : N ; -- bibliotekshögskola..nn.1
  bibliotekskatalog_1_N : N ; -- bibliotekskatalog..nn.1
  bibliotekslån_1_N : N ; -- bibliotekslån..nn.1
  biblisk_1_A : A ; -- biblisk..av.1
  biblomma_1_N : N ; -- biblomma..nn.1
  bibringa_1_V : V ; -- bibringa..vb.1
  bibringande_1_N : N ; -- bibringande..nn.1
  bibröd_1_N : N ; -- bibröd..nn.1
  biceps_1_N : N ; -- biceps..nn.1
  bicepsmuskel_1_N : N ; -- bicepsmuskel..nn.1
  bicepssena_1_N : N ; -- bicepssena..nn.1
  bida_1_V : V ; -- bida..vb.1
  bidande_1_N : N ; -- bidande..nn.1
  bidevindare_1_N : N ; -- bidevindare..nn.1
  bidevindsegel_1_N : N ; -- bidevindsegel..nn.1
  bidevindseglare_1_N : N ; -- bidevindseglare..nn.1
  bidra_1_V : V ; -- bidra..vb.1
  bidrag_1_N : N ; -- bidrag..nn.1
  bidragande_1_A : A ; -- bidragande..av.1
  bidragande_1_N : N ; -- bidragande..nn.1
  bidragsberoende_1_N : N ; -- bidragsberoende..nn.1
  bidragsdel_1_N : N ; -- bidragsdel..nn.1
  bidragsfusk_1_N : N ; -- bidragsfusk..nn.1
  bidragsfuskare_1_N : N ; -- bidragsfuskare..nn.1
  bidragsförskott_1_N : N ; -- bidragsförskott..nn.1
  bidragsgivare_1_N : N ; -- bidragsgivare..nn.1
  bidragsgrundande_1_A : A ; -- bidragsgrundande..av.1
  bidragsmiljon_1_N : N ; -- bidragsmiljon..nn.1
  bidragsskyldighet_1_N : N ; -- bidragsskyldighet..nn.1
  bidrottning_1_N : N ; -- bidrottning..nn.1
  bidé_1_N : N ; -- bidé..nn.1
  biedermeierstil_1_N : N ; -- biedermeierstil..nn.1
  bieffekt_1_N : N ; -- bieffekt..nn.1
  bienn_1_A : A ; -- bienn..av.1
  biennal_1_N : N ; -- biennal..nn.1
  bifall_1_N : N ; -- bifall..nn.1
  bifalla_1_V : V ; -- bifalla..vb.1
  bifallande_1_N : N ; -- bifallande..nn.1
  bifallsnick_1_N : N ; -- bifallsnick..nn.1
  bifallsrop_1_N : N ; -- bifallsrop..nn.1
  bifallsstorm_1_N : N ; -- bifallsstorm..nn.1
  bifallsyttring_1_N : N ; -- bifallsyttring..nn.1
  bifenyl_1_N : N ; -- bifenyl..nn.1
  biff_1_A : A ; -- biff..av.1
  biff_1_N : N ; -- biff..nn.1
  biffdjur_1_N : N ; -- biffdjur..nn.1
  biffig_1_A : A ; -- biffig..av.1
  biffighet_1_N : N ; -- biffighet..nn.1
  biffko_1_N : N ; -- biffko..nn.1
  biffrad_1_N : N ; -- biffrad..nn.1
  biffstek_1_N : N ; -- biffstek..nn.1
  biffyxa_1_N : N ; -- biffyxa..nn.1
  bifigur_1_N : N ; -- bifigur..nn.1
  bifilar_1_A : A ; -- bifilar..av.1
  bifilär_1_A : A ; -- bifilär..av.1
  biflod_1_N : N ; -- biflod..nn.1
  biflöde_1_N : N ; -- biflöde..nn.1
  bifoga_1_V : V ; -- bifoga..vb.1
  bifogande_1_N : N ; -- bifogande..nn.1
  bifokalglas_1_N : N ; -- bifokalglas..nn.1
  biform_1_N : N ; -- biform..nn.1
  bifurkation_1_N : N ; -- bifurkation..nn.1
  biförtjänst_1_N : N ; -- biförtjänst..nn.1
  bigami_1_N : N ; -- bigami..nn.1
  bigamist_1_N : N ; -- bigamist..nn.1
  bigarrå_1_N : N ; -- bigarrå..nn.1
  bigata_1_N : N ; -- bigata..nn.1
  bigift_1_N : N ; -- bigift..nn.1
  bigott_1_A : A ; -- bigott..av.1
  bigotteri_1_N : N ; -- bigotteri..nn.1
  bigram_1_N : N ; -- bigram..nn.1
  bigård_1_N : N ; -- bigård..nn.1
  bihandling_1_N : N ; -- bihandling..nn.1
  bihang_1_N : N ; -- bihang..nn.1
  bihav_1_N : N ; -- bihav..nn.1
  bihus_1_N : N ; -- bihus..nn.1
  bihustru_1_N : N ; -- bihustru..nn.1
  bihuva_1_N : N ; -- bihuva..nn.1
  bihåla_1_N : N ; -- bihåla..nn.1
  bihåleinflammation_1_N : N ; -- bihåleinflammation..nn.1
  biinkomst_1_N : N ; -- biinkomst..nn.1
  bikarbonat_1_N : N ; -- bikarbonat..nn.1
  bikini_1_N : N ; -- bikini..nn.1
  bikiniprydd_1_A : A ; -- bikiniprydd..av.1
  biklöv_1_N : N ; -- biklöv..nn.1
  bikonkav_1_A : A ; -- bikonkav..av.1
  bikonvex_1_A : A ; -- bikonvex..av.1
  bikrona_1_N : N ; -- bikrona..nn.1
  bikt_1_N : N ; -- bikt..nn.1
  bikta_1_V : V ; -- bikta..vb.1
  biktande_1_N : N ; -- biktande..nn.1
  biktbarn_1_N : N ; -- biktbarn..nn.1
  biktfar_1_N : N ; -- biktfar..nn.1
  biktstol_1_N : N ; -- biktstol..nn.1
  bikupa_1_N : N ; -- bikupa..nn.1
  bikvadrat_1_N : N ; -- bikvadrat..nn.1
  bikvadratisk_1_A : A ; -- bikvadratisk..av.1
  bil_1_N : N ; -- bil..nn.1
  bila_1_N : N ; -- bila..nn.1
  bila_1_V : V ; -- bila..vb.1
  bila_2_V : V ; -- bila..vb.2
  bilabial_1_A : A ; -- bilabial..av.1
  bilaccis_1_N : N ; -- bilaccis..nn.1
  bilaffär_1_N : N ; -- bilaffär..nn.1
  bilaga_1_N : N ; -- bilaga..nn.1
  biland_1_N : N ; -- biland..nn.1
  bilande_1_N : N ; -- bilande..nn.1
  bilantenn_1_N : N ; -- bilantenn..nn.1
  bilateral_1_A : A ; -- bilateral..av.1
  bilbana_1_N : N ; -- bilbana..nn.1
  bilbatteri_1_N : N ; -- bilbatteri..nn.1
  bilbesiktning_1_N : N ; -- bilbesiktning..nn.1
  bilbingo_1_N : N ; -- bilbingo..nn.1
  bilboké_1_N : N ; -- bilboké..nn.1
  bilbrand_1_N : N ; -- bilbrand..nn.1
  bilbransch_1_N : N ; -- bilbransch..nn.1
  bilbroms_1_N : N ; -- bilbroms..nn.1
  bilburen_1_A : A ; -- bilburen..av.1
  bilbyggeri_1_N : N ; -- bilbyggeri..nn.1
  bilbälte_1_N : N ; -- bilbälte..nn.1
  bild_1_N : N ; -- bild..nn.1
  bilda_1_V : V ; -- bilda..vb.1
  bildad_1_A : A ; -- bildad..av.1
  bildammsugare_1_N : N ; -- bildammsugare..nn.1
  bildande_1_A : A ; -- bildande..av.1
  bildande_1_N : N ; -- bildande..nn.1
  bildband_1_N : N ; -- bildband..nn.1
  bildbar_1_A : A ; -- bildbar..av.1
  bildbarhet_1_N : N ; -- bildbarhet..nn.1
  bildberättelse_1_N : N ; -- bildberättelse..nn.1
  bildbevis_1_N : N ; -- bildbevis..nn.1
  bilderbok_1_N : N ; -- bilderbok..nn.1
  bildflöde_1_N : N ; -- bildflöde..nn.1
  bildgalleri_1_N : N ; -- bildgalleri..nn.1
  bildgåta_1_N : N ; -- bildgåta..nn.1
  bildhuggare_1_N : N ; -- bildhuggare..nn.1
  bildhuggarkonst_1_N : N ; -- bildhuggarkonst..nn.1
  bildhuggarmejsel_1_N : N ; -- bildhuggarmejsel..nn.1
  bildhuggeri_1_N : N ; -- bildhuggeri..nn.1
  bildhållning_1_N : N ; -- bildhållning..nn.1
  bildinnehav_1_N : N ; -- bildinnehav..nn.1
  bildkarta_1_N : N ; -- bildkarta..nn.1
  bildkonst_1_N : N ; -- bildkonst..nn.1
  bildkryss_1_N : N ; -- bildkryss..nn.1
  bildlig_1_A : A ; -- bildlig..av.1
  bildlighet_1_N : N ; -- bildlighet..nn.1
  bildlik_1_A : A ; -- bildlik..av.1
  bildlikhet_1_N : N ; -- bildlikhet..nn.1
  bildmanipulation_1_N : N ; -- bildmanipulation..nn.1
  bildmaterial_1_N : N ; -- bildmaterial..nn.1
  bildminne_1_N : N ; -- bildminne..nn.1
  bildmonitor_1_N : N ; -- bildmonitor..nn.1
  bildmässig_1_A : A ; -- bildmässig..av.1
  bildmässighet_1_N : N ; -- bildmässighet..nn.1
  bildning_1_N : N ; -- bildning..nn.1
  bildningsanstalt_1_N : N ; -- bildningsanstalt..nn.1
  bildningsaristokrat_1_N : N ; -- bildningsaristokrat..nn.1
  bildningsfel_1_N : N ; -- bildningsfel..nn.1
  bildningsföraktare_1_N : N ; -- bildningsföraktare..nn.1
  bildningsförbund_1_N : N ; -- bildningsförbund..nn.1
  bildningsgrad_1_N : N ; -- bildningsgrad..nn.1
  bildningsgång_1_N : N ; -- bildningsgång..nn.1
  bildningshögfärd_1_N : N ; -- bildningshögfärd..nn.1
  bildningsmässig_1_A : A ; -- bildningsmässig..av.1
  bildningsnivå_1_N : N ; -- bildningsnivå..nn.1
  bildningsorganisation_1_N : N ; -- bildningsorganisation..nn.1
  bildningsroman_1_N : N ; -- bildningsroman..nn.1
  bildningstörst_1_N : N ; -- bildningstörst..nn.1
  bildningsverksamhet_1_N : N ; -- bildningsverksamhet..nn.1
  bildningsvärme_1_N : N ; -- bildningsvärme..nn.1
  bildprakt_1_N : N ; -- bildprakt..nn.1
  bildradio_1_N : N ; -- bildradio..nn.1
  bildredaktör_1_N : N ; -- bildredaktör..nn.1
  bildreportage_1_N : N ; -- bildreportage..nn.1
  bildrik_1_A : A ; -- bildrik..av.1
  bildrikedom_1_N : N ; -- bildrikedom..nn.1
  bildrulle_1_N : N ; -- bildrulle..nn.1
  bildrulle_2_1_N : N ; -- bildrulle_2..nn.1
  bildruta_1_N : N ; -- bildruta..nn.1
  bildrör_1_N : N ; -- bildrör..nn.1
  bildsida_1_N : N ; -- bildsida..nn.1
  bildsignal_1_N : N ; -- bildsignal..nn.1
  bildskrift_1_N : N ; -- bildskrift..nn.1
  bildskärm_1_N : N ; -- bildskärm..nn.1
  bildskärpa_1_N : N ; -- bildskärpa..nn.1
  bildskön_1_A : A ; -- bildskön..av.1
  bildskönhet_1_N : N ; -- bildskönhet..nn.1
  bildsnidare_1_N : N ; -- bildsnidare..nn.1
  bildsnideri_1_N : N ; -- bildsnideri..nn.1
  bildspel_1_N : N ; -- bildspel..nn.1
  bildspråk_1_N : N ; -- bildspråk..nn.1
  bildsten_1_N : N ; -- bildsten..nn.1
  bildstod_1_N : N ; -- bildstod..nn.1
  bildstormare_1_N : N ; -- bildstormare..nn.1
  bildstrid_1_N : N ; -- bildstrid..nn.1
  bildsvit_1_N : N ; -- bildsvit..nn.1
  bildtelefon_1_N : N ; -- bildtelefon..nn.1
  bildtelegrafi_1_N : N ; -- bildtelegrafi..nn.1
  bildtext_1_N : N ; -- bildtext..nn.1
  bildtolkning_1_N : N ; -- bildtolkning..nn.1
  bildverk_1_N : N ; -- bildverk..nn.1
  bildvävnad_1_N : N ; -- bildvävnad..nn.1
  bildäck_1_N : N ; -- bildäck..nn.1
  bildöverföring_1_N : N ; -- bildöverföring..nn.1
  bilfabrik_1_N : N ; -- bilfabrik..nn.1
  bilfabrikör_1_N : N ; -- bilfabrikör..nn.1
  bilfri_1_A : A ; -- bilfri..av.1
  bilfärd_1_N : N ; -- bilfärd..nn.1
  bilfärja_1_N : N ; -- bilfärja..nn.1
  bilfönster_1_N : N ; -- bilfönster..nn.1
  bilförare_1_N : N ; -- bilförare..nn.1
  bilförsäkring_1_N : N ; -- bilförsäkring..nn.1
  bilförsäljare_1_N : N ; -- bilförsäljare..nn.1
  bilgolv_1_N : N ; -- bilgolv..nn.1
  bilhammare_1_N : N ; -- bilhammare..nn.1
  bilhjul_1_N : N ; -- bilhjul..nn.1
  bilhögtalare_1_N : N ; -- bilhögtalare..nn.1
  bilindustri_1_N : N ; -- bilindustri..nn.1
  bilingual_1_A : A ; -- bilingual..av.1
  bilingualism_1_N : N ; -- bilingualism..nn.1
  bilism_1_N : N ; -- bilism..nn.1
  bilist_1_N : N ; -- bilist..nn.1
  bilistisk_1_A : A ; -- bilistisk..av.1
  biljard_1_N : N ; -- biljard..nn.1
  biljardboll_1_N : N ; -- biljardboll..nn.1
  biljardbollsuniversum_1_N : N ; -- biljardbollsuniversum..nn.1
  biljardbord_1_N : N ; -- biljardbord..nn.1
  biljardkäpp_1_N : N ; -- biljardkäpp..nn.1
  biljardkö_1_N : N ; -- biljardkö..nn.1
  biljardsalong_1_N : N ; -- biljardsalong..nn.1
  biljardspel_1_N : N ; -- biljardspel..nn.1
  biljett_1_N : N ; -- biljett..nn.1
  biljettautomat_1_N : N ; -- biljettautomat..nn.1
  biljettbok_1_N : N ; -- biljettbok..nn.1
  biljettbokning_1_N : N ; -- biljettbokning..nn.1
  biljettbråk_1_N : N ; -- biljettbråk..nn.1
  biljettexpedition_1_N : N ; -- biljettexpedition..nn.1
  biljettficka_1_N : N ; -- biljettficka..nn.1
  biljettförsäljare_1_N : N ; -- biljettförsäljare..nn.1
  biljettförsäljning_1_N : N ; -- biljettförsäljning..nn.1
  biljetthäfte_1_N : N ; -- biljetthäfte..nn.1
  biljetthärva_1_N : N ; -- biljetthärva..nn.1
  biljettinkomst_1_N : N ; -- biljettinkomst..nn.1
  biljettkontor_1_N : N ; -- biljettkontor..nn.1
  biljettkontroll_1_N : N ; -- biljettkontroll..nn.1
  biljettköp_1_N : N ; -- biljettköp..nn.1
  biljettlucka_1_N : N ; -- biljettlucka..nn.1
  biljettlös_1_A : A ; -- biljettlös..av.1
  biljettmaskin_1_N : N ; -- biljettmaskin..nn.1
  biljettpris_1_N : N ; -- biljettpris..nn.1
  biljettsläpp_1_N : N ; -- biljettsläpp..nn.1
  biljettvisering_1_N : N ; -- biljettvisering..nn.1
  biljettång_1_N : N ; -- biljettång..nn.1
  biljon_1_N : N ; -- biljon..nn.1
  biljonte_1_A : A ; -- biljonte..av.1
  biljud_1_N : N ; -- biljud..nn.1
  bilkaross_1_N : N ; -- bilkaross..nn.1
  bilkarta_1_N : N ; -- bilkarta..nn.1
  bilklädsel_1_N : N ; -- bilklädsel..nn.1
  bilkonstruktör_1_N : N ; -- bilkonstruktör..nn.1
  bilkrasch_1_N : N ; -- bilkrasch..nn.1
  bilkrock_1_N : N ; -- bilkrock..nn.1
  bilkupé_1_N : N ; -- bilkupé..nn.1
  bilkyrkogård_1_N : N ; -- bilkyrkogård..nn.1
  bilkår_1_N : N ; -- bilkår..nn.1
  bilkårist_1_N : N ; -- bilkårist..nn.1
  bilkö_1_N : N ; -- bilkö..nn.1
  bilköp_1_N : N ; -- bilköp..nn.1
  bilkörning_1_N : N ; -- bilkörning..nn.1
  bill_1_N : N ; -- bill..nn.1
  bill_2_N : N ; -- bill..nn.2
  billa_1_N : N ; -- billa..nn.1
  billampa_1_N : N ; -- billampa..nn.1
  billast_1_N : N ; -- billast..nn.1
  billiard_1_N : N ; -- billiard..nn.1
  billig_1_A : A ; -- billig..av.1
  billighet_1_N : N ; -- billighet..nn.1
  billighet_2_N : N ; -- billighet..nn.2
  billighetsupplaga_1_N : N ; -- billighetsupplaga..nn.1
  billion_1_N : N ; -- billion..nn.1
  billionte_1_A : A ; -- billionte..av.1
  billjus_1_N : N ; -- billjus..nn.1
  billots_1_N : N ; -- billots..nn.1
  billykta_1_N : N ; -- billykta..nn.1
  billån_1_N : N ; -- billån..nn.1
  billås_1_N : N ; -- billås..nn.1
  bilmaskin_1_N : N ; -- bilmaskin..nn.1
  bilmekaniker_1_N : N ; -- bilmekaniker..nn.1
  bilmotor_1_N : N ; -- bilmotor..nn.1
  bilmärke_1_N : N ; -- bilmärke..nn.1
  bilmålvakt_1_N : N ; -- bilmålvakt..nn.1
  bilnavigator_1_N : N ; -- bilnavigator..nn.1
  bilning_1_N : N ; -- bilning..nn.1
  bilnummer_1_N : N ; -- bilnummer..nn.1
  bilnyckel_1_N : N ; -- bilnyckel..nn.1
  bilolycka_1_N : N ; -- bilolycka..nn.1
  bilpark_1_N : N ; -- bilpark..nn.1
  bilparkering_1_N : N ; -- bilparkering..nn.1
  bilplåt_1_N : N ; -- bilplåt..nn.1
  bilpool_1_N : N ; -- bilpool..nn.1
  bilprovning_1_N : N ; -- bilprovning..nn.1
  bilradio_1_N : N ; -- bilradio..nn.1
  bilradioapparat_1_N : N ; -- bilradioapparat..nn.1
  bilrally_1_N : N ; -- bilrally..nn.1
  bilratt_1_N : N ; -- bilratt..nn.1
  bilregister_1_N : N ; -- bilregister..nn.1
  bilrengöring_1_N : N ; -- bilrengöring..nn.1
  bilresa_1_N : N ; -- bilresa..nn.1
  bilring_1_N : N ; -- bilring..nn.1
  bilrock_1_N : N ; -- bilrock..nn.1
  bilruta_1_N : N ; -- bilruta..nn.1
  bilschampo_1_N : N ; -- bilschampo..nn.1
  bilschamposvamp_1_N : N ; -- bilschamposvamp..nn.1
  bilsjuk_1_A : A ; -- bilsjuk..av.1
  bilsjuka_1_N : N ; -- bilsjuka..nn.1
  bilsjukhet_1_N : N ; -- bilsjukhet..nn.1
  bilskatt_1_N : N ; -- bilskatt..nn.1
  bilskojare_1_N : N ; -- bilskojare..nn.1
  bilskola_1_N : N ; -- bilskola..nn.1
  bilskrot_1_N : N ; -- bilskrot..nn.1
  bilskrotning_1_N : N ; -- bilskrotning..nn.1
  bilskrotningspremie_1_N : N ; -- bilskrotningspremie..nn.1
  bilsläpkärra_1_N : N ; -- bilsläpkärra..nn.1
  bilspackel_1_N : N ; -- bilspackel..nn.1
  bilstol_1_N : N ; -- bilstol..nn.1
  bilstöld_1_N : N ; -- bilstöld..nn.1
  bilsäte_1_N : N ; -- bilsäte..nn.1
  biltak_1_N : N ; -- biltak..nn.1
  biltelefon_1_N : N ; -- biltelefon..nn.1
  biltillverkare_1_N : N ; -- biltillverkare..nn.1
  biltillverkning_1_N : N ; -- biltillverkning..nn.1
  biltjuv_1_N : N ; -- biltjuv..nn.1
  biltog_1_A : A ; -- biltog..av.1
  biltoghet_1_N : N ; -- biltoghet..nn.1
  biltrafik_1_N : N ; -- biltrafik..nn.1
  biltull_1_N : N ; -- biltull..nn.1
  biltunnel_1_N : N ; -- biltunnel..nn.1
  biltur_1_N : N ; -- biltur..nn.1
  biltvätt_1_N : N ; -- biltvätt..nn.1
  biltvättborste_1_N : N ; -- biltvättborste..nn.1
  biltävling_1_N : N ; -- biltävling..nn.1
  bilvax_1_N : N ; -- bilvax..nn.1
  bilverkstad_1_N : N ; -- bilverkstad..nn.1
  bilvrak_1_N : N ; -- bilvrak..nn.1
  bilväg_1_N : N ; -- bilväg..nn.1
  bilyxa_1_N : N ; -- bilyxa..nn.1
  bilägare_1_N : N ; -- bilägare..nn.1
  biläger_1_N : N ; -- biläger..nn.1
  bilägga_1_V : V ; -- bilägga..vb.1
  biläggande_1_N : N ; -- biläggande..nn.1
  biläggning_1_N : N ; -- biläggning..nn.1
  bilåkning_1_N : N ; -- bilåkning..nn.1
  bimbo_1_N : N ; -- bimbo..nn.1
  bimbofilm_1_N : N ; -- bimbofilm..nn.1
  bimetall_1_N : N ; -- bimetall..nn.1
  bimetallism_1_N : N ; -- bimetallism..nn.1
  bimåne_1_N : N ; -- bimåne..nn.1
  binamn_1_N : N ; -- binamn..nn.1
  bind_1_N : N ; -- bind..nn.1
  binda_1_N : N ; -- binda..nn.1
  binda_1_V : V ; -- binda..vb.1
  bindande_1_A : A ; -- bindande..av.1
  bindande_1_N : N ; -- bindande..nn.1
  bindare_1_N : N ; -- bindare..nn.1
  bindbjälke_1_N : N ; -- bindbjälke..nn.1
  bindehinna_1_N : N ; -- bindehinna..nn.1
  bindehinneinflammation_1_N : N ; -- bindehinneinflammation..nn.1
  bindel_1_N : N ; -- bindel..nn.1
  bindemedel_1_N : N ; -- bindemedel..nn.1
  bindenyckel_1_N : N ; -- bindenyckel..nn.1
  bindeord_1_N : N ; -- bindeord..nn.1
  binderi_1_N : N ; -- binderi..nn.1
  bindestreck_1_N : N ; -- bindestreck..nn.1
  bindesubstans_1_N : N ; -- bindesubstans..nn.1
  bindesäck_1_N : N ; -- bindesäck..nn.1
  bindevokal_1_N : N ; -- bindevokal..nn.1
  bindgalen_1_A : A ; -- bindgalen..av.1
  bindgalenhet_1_N : N ; -- bindgalenhet..nn.1
  bindgarn_1_N : N ; -- bindgarn..nn.1
  bindning_1_N : N ; -- bindning..nn.1
  bindningstid_1_N : N ; -- bindningstid..nn.1
  bindnål_1_N : N ; -- bindnål..nn.1
  bindsel_1_N : N ; -- bindsel..nn.1
  bindsle_1_N : N ; -- bindsle..nn.1
  bindsten_1_N : N ; -- bindsten..nn.1
  bindsula_1_N : N ; -- bindsula..nn.1
  bindtråd_1_N : N ; -- bindtråd..nn.1
  bindväv_1_N : N ; -- bindväv..nn.1
  bindvävsfiber_1_N : N ; -- bindvävsfiber..nn.1
  bindvävshinna_1_N : N ; -- bindvävshinna..nn.1
  bindvävskapsel_1_N : N ; -- bindvävskapsel..nn.1
  bindvävssjukdom_1_N : N ; -- bindvävssjukdom..nn.1
  bindvävssäck_1_N : N ; -- bindvävssäck..nn.1
  bindvävstråd_1_N : N ; -- bindvävstråd..nn.1
  bindämne_1_N : N ; -- bindämne..nn.1
  binga_1_N : N ; -- binga..nn.1
  binge_1_N : N ; -- binge..nn.1
  bingel_1_N : N ; -- bingel..nn.1
  bingo_1_N : N ; -- bingo..nn.1
  bingobricka_1_N : N ; -- bingobricka..nn.1
  bingosugen_1_A : A ; -- bingosugen..av.1
  bingosugenhet_1_N : N ; -- bingosugenhet..nn.1
  binjure_1_N : N ; -- binjure..nn.1
  binjurebark_1_N : N ; -- binjurebark..nn.1
  binka_1_N : N ; -- binka..nn.1
  binnikemask_1_N : N ; -- binnikemask..nn.1
  binokel_1_N : N ; -- binokel..nn.1
  binokulär_1_A : A ; -- binokulär..av.1
  binom_1_N : N ; -- binom..nn.1
  binomial_1_A : A ; -- binomial..av.1
  binär_1_A : A ; -- binär..av.1
  binäring_1_N : N ; -- binäring..nn.1
  bio_1_N : N ; -- bio..nn.1
  bioaktuell_1_A : A ; -- bioaktuell..av.1
  biobank_1_N : N ; -- biobank..nn.1
  biobankning_1_N : N ; -- biobankning..nn.1
  biobesök_1_N : N ; -- biobesök..nn.1
  biobiljett_1_N : N ; -- biobiljett..nn.1
  biobränsle_1_N : N ; -- biobränsle..nn.1
  biocid_1_N : N ; -- biocid..nn.1
  biodlare_1_N : N ; -- biodlare..nn.1
  biodling_1_N : N ; -- biodling..nn.1
  biodrivmedel_1_N : N ; -- biodrivmedel..nn.1
  bioduk_1_N : N ; -- bioduk..nn.1
  biodynamik_1_N : N ; -- biodynamik..nn.1
  biodynamisk_1_A : A ; -- biodynamisk..av.1
  biofilm_1_N : N ; -- biofilm..nn.1
  biofysik_1_N : N ; -- biofysik..nn.1
  biofysisk_1_A : A ; -- biofysisk..av.1
  bioföreställning_1_N : N ; -- bioföreställning..nn.1
  biogas_1_N : N ; -- biogas..nn.1
  biogasanläggning_1_N : N ; -- biogasanläggning..nn.1
  biogasdriven_1_A : A ; -- biogasdriven..av.1
  biogasproduktion_1_N : N ; -- biogasproduktion..nn.1
  biogasrening_1_N : N ; -- biogasrening..nn.1
  biogen_1_A : A ; -- biogen..av.1
  biogenes_1_N : N ; -- biogenes..nn.1
  biogenetisk_1_A : A ; -- biogenetisk..av.1
  biogeografi_1_N : N ; -- biogeografi..nn.1
  biograf_1_N : N ; -- biograf..nn.1
  biografbyrå_1_N : N ; -- biografbyrå..nn.1
  biografera_1_V : V ; -- biografera..vb.1
  biograferande_1_N : N ; -- biograferande..nn.1
  biograferbar_1_A : A ; -- biograferbar..av.1
  biograferbarhet_1_N : N ; -- biograferbarhet..nn.1
  biografering_1_N : N ; -- biografering..nn.1
  biografföreståndare_1_N : N ; -- biografföreståndare..nn.1
  biografi_1_N : N ; -- biografi..nn.1
  biografisk_1_A : A ; -- biografisk..av.1
  biografmässig_1_A : A ; -- biografmässig..av.1
  biograforgel_1_N : N ; -- biograforgel..nn.1
  biografpublik_1_N : N ; -- biografpublik..nn.1
  biografteater_1_N : N ; -- biografteater..nn.1
  biokemi_1_N : N ; -- biokemi..nn.1
  biokemisk_1_A : A ; -- biokemisk..av.1
  biokemist_1_N : N ; -- biokemist..nn.1
  bioklimatologi_1_N : N ; -- bioklimatologi..nn.1
  biokronologi_1_N : N ; -- biokronologi..nn.1
  biolog_1_N : N ; -- biolog..nn.1
  biologi_1_N : N ; -- biologi..nn.1
  biologibok_1_N : N ; -- biologibok..nn.1
  biologisk_1_A : A ; -- biologisk..av.1
  biomassa_1_N : N ; -- biomassa..nn.1
  biomedicin_1_N : N ; -- biomedicin..nn.1
  biomedicinsk_1_A : A ; -- biomedicinsk..av.1
  biometri_1_N : N ; -- biometri..nn.1
  biometrisk_1_A : A ; -- biometrisk..av.1
  biomständighet_1_N : N ; -- biomständighet..nn.1
  biopremiär_1_N : N ; -- biopremiär..nn.1
  bioreaktor_1_N : N ; -- bioreaktor..nn.1
  biorytm_1_N : N ; -- biorytm..nn.1
  biosalong_1_N : N ; -- biosalong..nn.1
  biosfär_1_N : N ; -- biosfär..nn.1
  bioteknik_1_N : N ; -- bioteknik..nn.1
  bioteknisk_1_A : A ; -- bioteknisk..av.1
  bioteknologisk_1_A : A ; -- bioteknologisk..av.1
  biotisk_1_A : A ; -- biotisk..av.1
  biotop_1_N : N ; -- biotop..nn.1
  biotyp_1_N : N ; -- biotyp..nn.1
  biperson_1_N : N ; -- biperson..nn.1
  biplan_1_N : N ; -- biplan..nn.1
  biplanet_1_N : N ; -- biplanet..nn.1
  bipolaritet_1_N : N ; -- bipolaritet..nn.1
  bipolär_1_A : A ; -- bipolär..av.1
  biprodukt_1_N : N ; -- biprodukt..nn.1
  bir_1_N : N ; -- bir..nn.1
  bira_1_N : N ; -- bira..nn.1
  birdie_1_N : N ; -- birdie..nn.1
  birem_1_N : N ; -- birem..nn.1
  birfilare_1_N : N ; -- birfilare..nn.1
  biroll_1_N : N ; -- biroll..nn.1
  birot_1_N : N ; -- birot..nn.1
  bisak_1_N : N ; -- bisak..nn.1
  bisam_1_N : N ; -- bisam..nn.1
  bisamhälle_1_N : N ; -- bisamhälle..nn.1
  bisamoxe_1_N : N ; -- bisamoxe..nn.1
  bisamråtta_1_N : N ; -- bisamråtta..nn.1
  bisamsvin_1_N : N ; -- bisamsvin..nn.1
  bisarr_1_A : A ; -- bisarr..av.1
  bisarreri_1_N : N ; -- bisarreri..nn.1
  bisarrhet_1_N : N ; -- bisarrhet..nn.1
  bisats_1_N : N ; -- bisats..nn.1
  bisatsordföljd_1_N : N ; -- bisatsordföljd..nn.1
  bischoff_1_N : N ; -- bischoff..nn.1
  bisektris_1_N : N ; -- bisektris..nn.1
  bisexualitet_1_N : N ; -- bisexualitet..nn.1
  bisexuell_1_A : A ; -- bisexuell..av.1
  bisfenol_1_N : N ; -- bisfenol..nn.1
  bisittare_1_N : N ; -- bisittare..nn.1
  biskop_1_N : N ; -- biskop..nn.1
  biskoplig_1_A : A ; -- biskoplig..av.1
  biskoplighet_1_N : N ; -- biskoplighet..nn.1
  biskopsdöme_1_N : N ; -- biskopsdöme..nn.1
  biskopskors_1_N : N ; -- biskopskors..nn.1
  biskopskräckla_1_N : N ; -- biskopskräckla..nn.1
  biskopskräkla_1_N : N ; -- biskopskräkla..nn.1
  biskopsmössa_1_N : N ; -- biskopsmössa..nn.1
  biskopsmöte_1_N : N ; -- biskopsmöte..nn.1
  biskopsskrud_1_N : N ; -- biskopsskrud..nn.1
  biskopsstav_1_N : N ; -- biskopsstav..nn.1
  biskopsstift_1_N : N ; -- biskopsstift..nn.1
  biskopsstol_1_N : N ; -- biskopsstol..nn.1
  biskopssäte_1_N : N ; -- biskopssäte..nn.1
  biskopsval_1_N : N ; -- biskopsval..nn.1
  biskopsvisitation_1_N : N ; -- biskopsvisitation..nn.1
  biskvi_1_N : N ; -- biskvi..nn.1
  bisköldkörtel_1_N : N ; -- bisköldkörtel..nn.1
  biskötsel_1_N : N ; -- biskötsel..nn.1
  bismak_1_N : N ; -- bismak..nn.1
  bisol_1_N : N ; -- bisol..nn.1
  bison_1_N : N ; -- bison..nn.1
  bisonoxe_1_N : N ; -- bisonoxe..nn.1
  bisp_1_N : N ; -- bisp..nn.1
  bispringa_1_V : V ; -- bispringa..vb.1
  bispringande_1_N : N ; -- bispringande..nn.1
  bissauguinean_1_N : N ; -- bissauguinean..nn.1
  bissauguineansk_1_A : A ; -- bissauguineansk..av.1
  bissauguineanska_1_N : N ; -- bissauguineanska..nn.1
  bissera_1_V : V ; -- bissera..vb.1
  bisserande_1_N : N ; -- bisserande..nn.1
  bisserbar_1_A : A ; -- bisserbar..av.1
  bisserbarhet_1_N : N ; -- bisserbarhet..nn.1
  bissering_1_N : N ; -- bissering..nn.1
  bister_1_A : A ; -- bister..av.1
  bister_1_N : N ; -- bister..nn.1
  bisterhet_1_N : N ; -- bisterhet..nn.1
  bistick_1_N : N ; -- bistick..nn.1
  bisting_1_N : N ; -- bisting..nn.1
  bistock_1_N : N ; -- bistock..nn.1
  bistro_1_N : N ; -- bistro..nn.1
  bisträcka_1_V : V ; -- bisträcka..vb.1
  bisträckande_1_N : N ; -- bisträckande..nn.1
  bisturi_1_N : N ; -- bisturi..nn.1
  bistyng_1_N : N ; -- bistyng..nn.1
  bistå_1_V : V ; -- bistå..vb.1
  bistående_1_N : N ; -- bistående..nn.1
  bistånd_1_N : N ; -- bistånd..nn.1
  biståndsförvaltning_1_N : N ; -- biståndsförvaltning..nn.1
  biståndsland_1_N : N ; -- biståndsland..nn.1
  biståndsminister_1_N : N ; -- biståndsminister..nn.1
  biståndsmål_1_N : N ; -- biståndsmål..nn.1
  biståndsorgan_1_N : N ; -- biståndsorgan..nn.1
  biståndspolitik_1_N : N ; -- biståndspolitik..nn.1
  biståndspolitisk_1_A : A ; -- biståndspolitisk..av.1
  biståndsprogram_1_N : N ; -- biståndsprogram..nn.1
  biståndsprojekt_1_N : N ; -- biståndsprojekt..nn.1
  biståndsskepp_1_N : N ; -- biståndsskepp..nn.1
  bisvärm_1_N : N ; -- bisvärm..nn.1
  bisyssla_1_N : N ; -- bisyssla..nn.1
  bisätta_1_V : V ; -- bisätta..vb.1
  bisättande_1_N : N ; -- bisättande..nn.1
  bisättning_1_N : N ; -- bisättning..nn.1
  bit_1_N : N ; -- bit..nn.1
  bit_2_N : N ; -- bit..nn.2
  bita_1_V : V ; -- bita..vb.1
  bita_2_V : V ; -- bita..vb.2
  bitande_1_A : A ; -- bitande..av.1
  bitande_1_N : N ; -- bitande..nn.1
  bitanke_1_N : N ; -- bitanke..nn.1
  bitch_1_N : N ; -- bitch..nn.1
  bitchig_1_A : A ; -- bitchig..av.1
  bitecken_1_N : N ; -- bitecken..nn.1
  biten_1_A : A ; -- biten..av.1
  bitestikel_1_N : N ; -- bitestikel..nn.1
  bitmärke_1_N : N ; -- bitmärke..nn.1
  biton_1_N : N ; -- biton..nn.1
  bitryck_1_N : N ; -- bitryck..nn.1
  biträda_1_V : V ; -- biträda..vb.1
  biträdande_1_A : A ; -- biträdande..av.1
  biträdande_1_N : N ; -- biträdande..nn.1
  biträde_1_N : N ; -- biträde..nn.1
  bits_1_N : N ; -- bits..nn.1
  bitshållare_1_N : N ; -- bitshållare..nn.1
  bitsk_1_A : A ; -- bitsk..av.1
  bitskhet_1_N : N ; -- bitskhet..nn.1
  bitsocker_1_N : N ; -- bitsocker..nn.1
  bitsår_1_N : N ; -- bitsår..nn.1
  bittelitenhet_1_N : N ; -- bittelitenhet..nn.1
  bitter_1_A : A ; -- bitter..av.1
  bitterhet_1_N : N ; -- bitterhet..nn.1
  bitterkall_1_A : A ; -- bitterkall..av.1
  bitterligen_1_Adv : Adv ; -- bitterligen..ab.1
  bitterljuv_1_A : A ; -- bitterljuv..av.1
  bitterljuvhet_1_N : N ; -- bitterljuvhet..nn.1
  bittermandel_1_N : N ; -- bittermandel..nn.1
  bittermandelolja_1_N : N ; -- bittermandelolja..nn.1
  bittersalt_1_A : A ; -- bittersalt..av.1
  bittersalt_1_N : N ; -- bittersalt..nn.1
  bittersta_1_A : A ; -- bittersta..av.1
  bittersöt_1_A : A ; -- bittersöt..av.1
  bittersöta_1_N : N ; -- bittersöta..nn.1
  bituminös_1_A : A ; -- bituminös..av.1
  bitvarg_1_N : N ; -- bitvarg..nn.1
  bitvis_1_Adv : Adv ; -- bitvis..ab.1
  bivack_1_N : N ; -- bivack..nn.1
  bivackera_1_V : V ; -- bivackera..vb.1
  bivackerande_1_N : N ; -- bivackerande..nn.1
  bivackerbar_1_A : A ; -- bivackerbar..av.1
  bivackerbarhet_1_N : N ; -- bivackerbarhet..nn.1
  bivackering_1_N : N ; -- bivackering..nn.1
  bivax_1_N : N ; -- bivax..nn.1
  biverkning_1_N : N ; -- biverkning..nn.1
  biverkningsfall_1_N : N ; -- biverkningsfall..nn.1
  biverkningsrapport_1_N : N ; -- biverkningsrapport..nn.1
  bivråk_1_N : N ; -- bivråk..nn.1
  biväg_1_N : N ; -- biväg..nn.1
  biyngel_1_N : N ; -- biyngel..nn.1
  biämne_1_N : N ; -- biämne..nn.1
  biätare_1_N : N ; -- biätare..nn.1
  bjuda_1_V : V ; -- bjuda..vb.1
  bjudande_1_N : N ; -- bjudande..nn.1
  bjudcigarr_1_N : N ; -- bjudcigarr..nn.1
  bjudning_1_N : N ; -- bjudning..nn.1
  bjugg_1_N : N ; -- bjugg..nn.1
  bjussa_1_V : V ; -- bjussa..vb.1
  bjussande_1_N : N ; -- bjussande..nn.1
  bjäbb_1_N : N ; -- bjäbb..nn.1
  bjäbba_1_V : V ; -- bjäbba..vb.1
  bjäbbande_1_N : N ; -- bjäbbande..nn.1
  bjäbbig_1_A : A ; -- bjäbbig..av.1
  bjäbbighet_1_N : N ; -- bjäbbighet..nn.1
  bjäfs_1_N : N ; -- bjäfs..nn.1
  bjälke_1_N : N ; -- bjälke..nn.1
  bjälkhuvud_1_N : N ; -- bjälkhuvud..nn.1
  bjälklag_1_N : N ; -- bjälklag..nn.1
  bjälkverk_1_N : N ; -- bjälkverk..nn.1
  bjällerklang_1_N : N ; -- bjällerklang..nn.1
  bjällko_1_N : N ; -- bjällko..nn.1
  bjällra_1_N : N ; -- bjällra..nn.1
  bjärt_1_A : A ; -- bjärt..av.1
  bjärtgrön_1_A : A ; -- bjärtgrön..av.1
  bjärthet_1_N : N ; -- bjärthet..nn.1
  bjässe_1_N : N ; -- bjässe..nn.1
  björk_1_N : N ; -- björk..nn.1
  björkblad_1_N : N ; -- björkblad..nn.1
  björke_1_N : N ; -- björke..nn.1
  björkgren_1_N : N ; -- björkgren..nn.1
  björkgräns_1_N : N ; -- björkgräns..nn.1
  björkhage_1_N : N ; -- björkhage..nn.1
  björklag_1_N : N ; -- björklag..nn.1
  björklöv_1_N : N ; -- björklöv..nn.1
  björkna_1_N : N ; -- björkna..nn.1
  björknäver_1_N : N ; -- björknäver..nn.1
  björkpollen_1_N : N ; -- björkpollen..nn.1
  björkregion_1_N : N ; -- björkregion..nn.1
  björkris_1_N : N ; -- björkris..nn.1
  björksav_1_N : N ; -- björksav..nn.1
  björkskog_1_N : N ; -- björkskog..nn.1
  björksly_1_N : N ; -- björksly..nn.1
  björksopp_1_N : N ; -- björksopp..nn.1
  björktrast_1_N : N ; -- björktrast..nn.1
  björkved_1_N : N ; -- björkved..nn.1
  björn_1_N : N ; -- björn..nn.1
  björna_1_V : V ; -- björna..vb.1
  björnande_1_N : N ; -- björnande..nn.1
  björnbindsel_1_N : N ; -- björnbindsel..nn.1
  björnbindsle_1_N : N ; -- björnbindsle..nn.1
  björnbär_1_N : N ; -- björnbär..nn.1
  björnbärsbuske_1_N : N ; -- björnbärsbuske..nn.1
  björnfloka_1_N : N ; -- björnfloka..nn.1
  björngrop_1_N : N ; -- björngrop..nn.1
  björnhallon_1_N : N ; -- björnhallon..nn.1
  björnhona_1_N : N ; -- björnhona..nn.1
  björnhund_1_N : N ; -- björnhund..nn.1
  björnide_1_N : N ; -- björnide..nn.1
  björninna_1_N : N ; -- björninna..nn.1
  björnjakt_1_N : N ; -- björnjakt..nn.1
  björnliknande_1_A : A ; -- björnliknande..av.1
  björnloka_1_N : N ; -- björnloka..nn.1
  björnmossa_1_N : N ; -- björnmossa..nn.1
  björnram_1_N : N ; -- björnram..nn.1
  björnsax_1_N : N ; -- björnsax..nn.1
  björnskall_1_N : N ; -- björnskall..nn.1
  björnskinn_1_N : N ; -- björnskinn..nn.1
  björnskinnsmössa_1_N : N ; -- björnskinnsmössa..nn.1
  björnskådning_1_N : N ; -- björnskådning..nn.1
  björntjänst_1_N : N ; -- björntjänst..nn.1
  björntråd_1_N : N ; -- björntråd..nn.1
  black_1_A : A ; -- black..av.1
  black_1_N : N ; -- black..nn.1
  blackhet_1_N : N ; -- blackhet..nn.1
  blackig_1_A : A ; -- blackig..av.1
  blackighet_1_N : N ; -- blackighet..nn.1
  blackout_1_N : N ; -- blackout..nn.1
  blad_1_N : N ; -- blad..nn.1
  blada_1_V : V ; -- blada..vb.1
  bladande_1_N : N ; -- bladande..nn.1
  bladbagge_1_N : N ; -- bladbagge..nn.1
  bladbildning_1_N : N ; -- bladbildning..nn.1
  bladbyte_1_N : N ; -- bladbyte..nn.1
  bladder_1_N : N ; -- bladder..nn.1
  bladdra_1_V : V ; -- bladdra..vb.1
  bladdrande_1_N : N ; -- bladdrande..nn.1
  bladfot_1_N : N ; -- bladfot..nn.1
  bladfoting_1_N : N ; -- bladfoting..nn.1
  bladguld_1_N : N ; -- bladguld..nn.1
  bladig_1_A : A ; -- bladig..av.1
  bladknopp_1_N : N ; -- bladknopp..nn.1
  bladkrans_1_N : N ; -- bladkrans..nn.1
  bladkål_1_N : N ; -- bladkål..nn.1
  bladloppa_1_N : N ; -- bladloppa..nn.1
  bladlus_1_N : N ; -- bladlus..nn.1
  bladlängd_1_N : N ; -- bladlängd..nn.1
  bladmage_1_N : N ; -- bladmage..nn.1
  bladmetall_1_N : N ; -- bladmetall..nn.1
  bladminerare_1_N : N ; -- bladminerare..nn.1
  bladmossa_1_N : N ; -- bladmossa..nn.1
  bladmögel_1_N : N ; -- bladmögel..nn.1
  bladnerv_1_N : N ; -- bladnerv..nn.1
  bladning_1_N : N ; -- bladning..nn.1
  bladrik_1_A : A ; -- bladrik..av.1
  bladrullsjuka_1_N : N ; -- bladrullsjuka..nn.1
  bladrött_1_N : N ; -- bladrött..nn.1
  bladsilver_1_N : N ; -- bladsilver..nn.1
  bladskaft_1_N : N ; -- bladskaft..nn.1
  bladskärarmyra_1_N : N ; -- bladskärarmyra..nn.1
  bladspänning_1_N : N ; -- bladspänning..nn.1
  bladstekel_1_N : N ; -- bladstekel..nn.1
  bladställning_1_N : N ; -- bladställning..nn.1
  bladverk_1_N : N ; -- bladverk..nn.1
  bladväxt_1_N : N ; -- bladväxt..nn.1
  blaffa_1_N : N ; -- blaffa..nn.1
  blaggarn_1_N : N ; -- blaggarn..nn.1
  blaj_1_N : N ; -- blaj..nn.1
  blaja_1_V : V ; -- blaja..vb.1
  blajande_1_N : N ; -- blajande..nn.1
  blam_1_N : N ; -- blam..nn.1
  blamage_1_N : N ; -- blamage..nn.1
  blamant_1_A : A ; -- blamant..av.1
  blanchera_1_V : V ; -- blanchera..vb.1
  blancherande_1_N : N ; -- blancherande..nn.1
  blancherbar_1_A : A ; -- blancherbar..av.1
  blancherbarhet_1_N : N ; -- blancherbarhet..nn.1
  blanchering_1_N : N ; -- blanchering..nn.1
  blancmangé_1_N : N ; -- blancmangé..nn.1
  blanda_1_V : V ; -- blanda..vb.1
  blandad_1_A : A ; -- blandad..av.1
  blandande_1_N : N ; -- blandande..nn.1
  blandare_1_N : N ; -- blandare..nn.1
  blanddricka_1_N : N ; -- blanddricka..nn.1
  blanddryck_1_N : N ; -- blanddryck..nn.1
  blandekonomi_1_N : N ; -- blandekonomi..nn.1
  blandfoder_1_N : N ; -- blandfoder..nn.1
  blandfolk_1_N : N ; -- blandfolk..nn.1
  blandform_1_N : N ; -- blandform..nn.1
  blandfärg_1_N : N ; -- blandfärg..nn.1
  blandkultur_1_N : N ; -- blandkultur..nn.1
  blandning_1_N : N ; -- blandning..nn.1
  blandningsförhållande_1_N : N ; -- blandningsförhållande..nn.1
  blandningskran_1_N : N ; -- blandningskran..nn.1
  blandras_1_N : N ; -- blandras..nn.1
  blandrashund_1_N : N ; -- blandrashund..nn.1
  blandskog_1_N : N ; -- blandskog..nn.1
  blandspråk_1_N : N ; -- blandspråk..nn.1
  blandsäd_1_N : N ; -- blandsäd..nn.1
  blandtyp_1_N : N ; -- blandtyp..nn.1
  blandvatten_1_N : N ; -- blandvatten..nn.1
  blandäktenskap_1_N : N ; -- blandäktenskap..nn.1
  blank_1_A : A ; -- blank..av.1
  blanka_1_N : N ; -- blanka..nn.1
  blanka_1_V : V ; -- blanka..vb.1
  blankande_1_N : N ; -- blankande..nn.1
  blankborste_1_N : N ; -- blankborste..nn.1
  blankett_1_N : N ; -- blankett..nn.1
  blankettraseri_1_N : N ; -- blankettraseri..nn.1
  blankettskåp_1_N : N ; -- blankettskåp..nn.1
  blankgalvad_1_A : A ; -- blankgalvad..av.1
  blankhet_1_N : N ; -- blankhet..nn.1
  blankis_1_N : N ; -- blankis..nn.1
  blanklax_1_N : N ; -- blanklax..nn.1
  blankläder_1_N : N ; -- blankläder..nn.1
  blankning_1_N : N ; -- blankning..nn.1
  blankningsaffär_1_N : N ; -- blankningsaffär..nn.1
  blankningsförbud_1_N : N ; -- blankningsförbud..nn.1
  blankoaccept_1_N : N ; -- blankoaccept..nn.1
  blankocheck_1_N : N ; -- blankocheck..nn.1
  blankofullmakt_1_N : N ; -- blankofullmakt..nn.1
  blankoförsäljning_1_N : N ; -- blankoförsäljning..nn.1
  blankokredit_1_N : N ; -- blankokredit..nn.1
  blankotransport_1_N : N ; -- blankotransport..nn.1
  blankoväxel_1_N : N ; -- blankoväxel..nn.1
  blankoöverlåtelse_1_N : N ; -- blankoöverlåtelse..nn.1
  blankpolera_1_V : V ; -- blankpolera..vb.1
  blankpolerande_1_N : N ; -- blankpolerande..nn.1
  blankpolerbar_1_A : A ; -- blankpolerbar..av.1
  blankpolerbarhet_1_N : N ; -- blankpolerbarhet..nn.1
  blankpolering_1_N : N ; -- blankpolering..nn.1
  blankputsad_1_A : A ; -- blankputsad..av.1
  blankröstare_1_N : N ; -- blankröstare..nn.1
  blanksej_1_N : N ; -- blanksej..nn.1
  blankskinn_1_N : N ; -- blankskinn..nn.1
  blankslipa_1_V : V ; -- blankslipa..vb.1
  blankslipande_1_N : N ; -- blankslipande..nn.1
  blankslipning_1_N : N ; -- blankslipning..nn.1
  blanksliten_1_A : A ; -- blanksliten..av.1
  blanksmörja_1_N : N ; -- blanksmörja..nn.1
  blanksvärta_1_N : N ; -- blanksvärta..nn.1
  blankvatten_1_N : N ; -- blankvatten..nn.1
  blankvers_1_N : N ; -- blankvers..nn.1
  blankål_1_N : N ; -- blankål..nn.1
  blark_1_N : N ; -- blark..nn.1
  blarr_1_N : N ; -- blarr..nn.1
  blarra_1_V : V ; -- blarra..vb.1
  blarrande_1_N : N ; -- blarrande..nn.1
  blaserad_1_A : A ; -- blaserad..av.1
  blasfemi_1_N : N ; -- blasfemi..nn.1
  blasfemisk_1_A : A ; -- blasfemisk..av.1
  blask_1_N : N ; -- blask..nn.1
  blaska_1_N : N ; -- blaska..nn.1
  blaska_1_V : V ; -- blaska..vb.1
  blaskande_1_N : N ; -- blaskande..nn.1
  blaskig_1_A : A ; -- blaskig..av.1
  blaskighet_1_N : N ; -- blaskighet..nn.1
  blasonering_1_N : N ; -- blasonering..nn.1
  blast_1_N : N ; -- blast..nn.1
  blastula_1_N : N ; -- blastula..nn.1
  blasé_1_A : A ; -- blasé..av.1
  blatte_1_N : N ; -- blatte..nn.1
  blazer_1_N : N ; -- blazer..nn.1
  blazerklädd_1_A : A ; -- blazerklädd..av.1
  bleck_1_N : N ; -- bleck..nn.1
  bleckblåsinstrument_1_N : N ; -- bleckblåsinstrument..nn.1
  bleckburk_1_N : N ; -- bleckburk..nn.1
  bleckinstrument_1_N : N ; -- bleckinstrument..nn.1
  bleckmusik_1_N : N ; -- bleckmusik..nn.1
  bleckplåt_1_N : N ; -- bleckplåt..nn.1
  bleckslagare_1_N : N ; -- bleckslagare..nn.1
  bleckslageri_1_N : N ; -- bleckslageri..nn.1
  blecksmak_1_N : N ; -- blecksmak..nn.1
  blek_1_A : A ; -- blek..av.1
  bleka_1_V : V ; -- bleka..vb.1
  blekande_1_N : N ; -- blekande..nn.1
  blekansikte_1_N : N ; -- blekansikte..nn.1
  blekblå_1_A : A ; -- blekblå..av.1
  bleke_1_N : N ; -- bleke..nn.1
  blekeri_1_N : N ; -- blekeri..nn.1
  blekfet_1_A : A ; -- blekfet..av.1
  blekfethet_1_N : N ; -- blekfethet..nn.1
  blekfis_1_N : N ; -- blekfis..nn.1
  blekglaserad_1_A : A ; -- blekglaserad..av.1
  blekgul_1_A : A ; -- blekgul..av.1
  blekhet_1_N : N ; -- blekhet..nn.1
  bleking_1_N : N ; -- bleking..nn.1
  blekingseka_1_N : N ; -- blekingseka..nn.1
  blekingsk_1_A : A ; -- blekingsk..av.1
  blekingska_1_N : N ; -- blekingska..nn.1
  blekingska_2_N : N ; -- blekingska..nn.2
  blekjord_1_N : N ; -- blekjord..nn.1
  bleklagd_1_A : A ; -- bleklagd..av.1
  bleklagdhet_1_N : N ; -- bleklagdhet..nn.1
  blekmedel_1_N : N ; -- blekmedel..nn.1
  blekna_1_V : V ; -- blekna..vb.1
  bleknande_1_N : N ; -- bleknande..nn.1
  blekning_1_N : N ; -- blekning..nn.1
  bleknos_1_N : N ; -- bleknos..nn.1
  blekröd_1_A : A ; -- blekröd..av.1
  bleksiktig_1_A : A ; -- bleksiktig..av.1
  bleksiktighet_1_N : N ; -- bleksiktighet..nn.1
  bleksot_1_N : N ; -- bleksot..nn.1
  blekvätska_1_N : N ; -- blekvätska..nn.1
  blemma_1_N : N ; -- blemma..nn.1
  blemmig_1_A : A ; -- blemmig..av.1
  blessera_1_V : V ; -- blessera..vb.1
  blesserande_1_N : N ; -- blesserande..nn.1
  blesserbar_1_A : A ; -- blesserbar..av.1
  blesserbarhet_1_N : N ; -- blesserbarhet..nn.1
  blessering_1_N : N ; -- blessering..nn.1
  blessyr_1_N : N ; -- blessyr..nn.1
  bli_1_V : V ; -- bli..vb.1
  blick_1_N : N ; -- blick..nn.1
  blicka_1_V : V ; -- blicka..vb.1
  blickande_1_N : N ; -- blickande..nn.1
  blickfält_1_N : N ; -- blickfält..nn.1
  blickfång_1_N : N ; -- blickfång..nn.1
  blickpunkt_1_N : N ; -- blickpunkt..nn.1
  blickstilla_1_A : A ; -- blickstilla..av.1
  blid_1_A : A ; -- blid..av.1
  blida_1_N : N ; -- blida..nn.1
  blidgrad_1_N : N ; -- blidgrad..nn.1
  blidhet_1_N : N ; -- blidhet..nn.1
  blidka_1_V : V ; -- blidka..vb.1
  blidkande_1_N : N ; -- blidkande..nn.1
  blidvinter_1_N : N ; -- blidvinter..nn.1
  blidväder_1_N : N ; -- blidväder..nn.1
  bliende_1_N : N ; -- bliende..nn.1
  blig_1_N : N ; -- blig..nn.1
  bliga_1_V : V ; -- bliga..vb.1
  bligande_1_N : N ; -- bligande..nn.1
  blind_1_A : A ; -- blind..av.1
  blinda_1_N : N ; -- blinda..nn.1
  blindalfabet_1_N : N ; -- blindalfabet..nn.1
  blindbock_1_N : N ; -- blindbock..nn.1
  blindbotten_1_N : N ; -- blindbotten..nn.1
  blindbroms_1_N : N ; -- blindbroms..nn.1
  blinddörr_1_N : N ; -- blinddörr..nn.1
  blindera_1_V : V ; -- blindera..vb.1
  blinderande_1_N : N ; -- blinderande..nn.1
  blinderbar_1_A : A ; -- blinderbar..av.1
  blinderbarhet_1_N : N ; -- blinderbarhet..nn.1
  blindering_1_N : N ; -- blindering..nn.1
  blindflygning_1_N : N ; -- blindflygning..nn.1
  blindfönster_1_N : N ; -- blindfönster..nn.1
  blindgata_1_N : N ; -- blindgata..nn.1
  blindgångare_1_N : N ; -- blindgångare..nn.1
  blindhet_1_N : N ; -- blindhet..nn.1
  blindhund_1_N : N ; -- blindhund..nn.1
  blindinstitut_1_N : N ; -- blindinstitut..nn.1
  blindkarta_1_N : N ; -- blindkarta..nn.1
  blindlandning_1_N : N ; -- blindlandning..nn.1
  blindlykta_1_N : N ; -- blindlykta..nn.1
  blindnässla_1_N : N ; -- blindnässla..nn.1
  blindparti_1_N : N ; -- blindparti..nn.1
  blindpassagerare_1_N : N ; -- blindpassagerare..nn.1
  blindpatron_1_N : N ; -- blindpatron..nn.1
  blindpipa_1_N : N ; -- blindpipa..nn.1
  blindpressa_1_V : V ; -- blindpressa..vb.1
  blindpressande_1_N : N ; -- blindpressande..nn.1
  blindpressning_1_N : N ; -- blindpressning..nn.1
  blindrote_1_N : N ; -- blindrote..nn.1
  blindrå_1_N : N ; -- blindrå..nn.1
  blindschack_1_N : N ; -- blindschack..nn.1
  blindskola_1_N : N ; -- blindskola..nn.1
  blindskrift_1_N : N ; -- blindskrift..nn.1
  blindskär_1_N : N ; -- blindskär..nn.1
  blindspår_1_N : N ; -- blindspår..nn.1
  blindstyre_1_N : N ; -- blindstyre..nn.1
  blindtarm_1_N : N ; -- blindtarm..nn.1
  blindtarmsinflammation_1_N : N ; -- blindtarmsinflammation..nn.1
  blindtarmsoperation_1_N : N ; -- blindtarmsoperation..nn.1
  blindtryck_1_N : N ; -- blindtryck..nn.1
  bling_bling_1_N : N ; -- bling-bling..nn.1
  bling_1_N : N ; -- bling..nn.1
  blinga_1_V : V ; -- blinga..vb.1
  blingande_1_N : N ; -- blingande..nn.1
  blingning_1_N : N ; -- blingning..nn.1
  blini_1_N : N ; -- blini..nn.1
  blink_1_N : N ; -- blink..nn.1
  blink_2_N : N ; -- blink..nn.2
  blinka_1_V : V ; -- blinka..vb.1
  blinkande_1_N : N ; -- blinkande..nn.1
  blinker_1_N : N ; -- blinker..nn.1
  blinkfyr_1_N : N ; -- blinkfyr..nn.1
  blinkhinna_1_N : N ; -- blinkhinna..nn.1
  blinkljus_1_N : N ; -- blinkljus..nn.1
  blinkning_1_N : N ; -- blinkning..nn.1
  blinning_1_N : N ; -- blinning..nn.1
  blip_1_N : N ; -- blip..nn.1
  blipp_1_N : N ; -- blipp..nn.1
  blippa_1_V : V ; -- blippa..vb.1
  blippande_1_N : N ; -- blippande..nn.1
  blippning_1_N : N ; -- blippning..nn.1
  blivande_1_A : A ; -- blivande..av.1
  blivande_1_N : N ; -- blivande..nn.1
  blixt_1_N : N ; -- blixt..nn.1
  blixtanfall_1_N : N ; -- blixtanfall..nn.1
  blixtbelysning_1_N : N ; -- blixtbelysning..nn.1
  blixtbesök_1_N : N ; -- blixtbesök..nn.1
  blixtfoto_1_N : N ; -- blixtfoto..nn.1
  blixtfotografera_1_V : V ; -- blixtfotografera..vb.1
  blixtfotograferande_1_N : N ; -- blixtfotograferande..nn.1
  blixtfotograferbar_1_A : A ; -- blixtfotograferbar..av.1
  blixtfotograferbarhet_1_N : N ; -- blixtfotograferbarhet..nn.1
  blixtfotografering_1_N : N ; -- blixtfotografering..nn.1
  blixtfyr_1_N : N ; -- blixtfyr..nn.1
  blixtförälskad_1_A : A ; -- blixtförälskad..av.1
  blixthalka_1_N : N ; -- blixthalka..nn.1
  blixtinkalla_1_V : V ; -- blixtinkalla..vb.1
  blixtinkallad_1_A : A ; -- blixtinkallad..av.1
  blixtinkallande_1_N : N ; -- blixtinkallande..nn.1
  blixtinkallelse_1_N : N ; -- blixtinkallelse..nn.1
  blixtinvasion_1_N : N ; -- blixtinvasion..nn.1
  blixtkrig_1_N : N ; -- blixtkrig..nn.1
  blixtlampa_1_N : N ; -- blixtlampa..nn.1
  blixtljus_1_N : N ; -- blixtljus..nn.1
  blixtlås_1_N : N ; -- blixtlås..nn.1
  blixtnedslag_1_N : N ; -- blixtnedslag..nn.1
  blixtpatron_1_N : N ; -- blixtpatron..nn.1
  blixtpulver_1_N : N ; -- blixtpulver..nn.1
  blixtra_1_V : V ; -- blixtra..vb.1
  blixtrande_1_A : A ; -- blixtrande..av.1
  blixtrande_1_N : N ; -- blixtrande..nn.1
  blixtsamtal_1_N : N ; -- blixtsamtal..nn.1
  blixtsnabb_1_A : A ; -- blixtsnabb..av.1
  blixtsnabbhet_1_N : N ; -- blixtsnabbhet..nn.1
  blixtutryckning_1_N : N ; -- blixtutryckning..nn.1
  blixtvisit_1_N : N ; -- blixtvisit..nn.1
  block_1_N : N ; -- block..nn.1
  blocka_1_V : V ; -- blocka..vb.1
  blockad_1_N : N ; -- blockad..nn.1
  blockadbrott_1_N : N ; -- blockadbrott..nn.1
  blockadbrytare_1_N : N ; -- blockadbrytare..nn.1
  blockalmanack_1_N : N ; -- blockalmanack..nn.1
  blockalmanacka_1_N : N ; -- blockalmanacka..nn.1
  blockande_1_N : N ; -- blockande..nn.1
  blockbildning_1_N : N ; -- blockbildning..nn.1
  blockchoklad_1_N : N ; -- blockchoklad..nn.1
  blockdiagram_1_N : N ; -- blockdiagram..nn.1
  blockera_1_V : V ; -- blockera..vb.1
  blockerande_1_N : N ; -- blockerande..nn.1
  blockerbar_1_A : A ; -- blockerbar..av.1
  blockerbarhet_1_N : N ; -- blockerbarhet..nn.1
  blockering_1_N : N ; -- blockering..nn.1
  blockflöjt_1_N : N ; -- blockflöjt..nn.1
  blockgräns_1_N : N ; -- blockgräns..nn.1
  blockhus_1_N : N ; -- blockhus..nn.1
  blockig_1_A : A ; -- blockig..av.1
  blockighet_1_N : N ; -- blockighet..nn.1
  blockmark_1_N : N ; -- blockmark..nn.1
  blockpolitik_1_N : N ; -- blockpolitik..nn.1
  blockpolitisk_1_A : A ; -- blockpolitisk..av.1
  blocksignal_1_N : N ; -- blocksignal..nn.1
  blockskiva_1_N : N ; -- blockskiva..nn.1
  blocksystem_1_N : N ; -- blocksystem..nn.1
  blocktalja_1_N : N ; -- blocktalja..nn.1
  blocktrissa_1_N : N ; -- blocktrissa..nn.1
  blocktyg_1_N : N ; -- blocktyg..nn.1
  blocktänkande_1_N : N ; -- blocktänkande..nn.1
  blockvagn_1_N : N ; -- blockvagn..nn.1
  blockämne_1_N : N ; -- blockämne..nn.1
  blocköverskridande_1_A : A ; -- blocköverskridande..av.1
  blod_hjärnbarriär_1_N : N ; -- blod-hjärnbarriär..nn.1
  blod_1_N : N ; -- blod..nn.1
  bloda_1_V : V ; -- bloda..vb.1
  blodande_1_N : N ; -- blodande..nn.1
  blodapelsin_1_N : N ; -- blodapelsin..nn.1
  blodbad_1_N : N ; -- blodbad..nn.1
  blodbank_1_N : N ; -- blodbank..nn.1
  blodbefläckad_1_A : A ; -- blodbefläckad..av.1
  blodbestänkt_1_A : A ; -- blodbestänkt..av.1
  blodbesudlad_1_A : A ; -- blodbesudlad..av.1
  blodblåsa_1_N : N ; -- blodblåsa..nn.1
  blodbok_1_N : N ; -- blodbok..nn.1
  blodbrist_1_N : N ; -- blodbrist..nn.1
  blodcancer_1_N : N ; -- blodcancer..nn.1
  blodcell_1_N : N ; -- blodcell..nn.1
  blodcirkulation_1_N : N ; -- blodcirkulation..nn.1
  bloddoping_1_N : N ; -- bloddoping..nn.1
  bloddrypande_1_A : A ; -- bloddrypande..av.1
  bloddränkt_1_A : A ; -- bloddränkt..av.1
  blodfattig_1_A : A ; -- blodfattig..av.1
  blodfattighet_1_N : N ; -- blodfattighet..nn.1
  blodfläck_1_N : N ; -- blodfläck..nn.1
  blodflöde_1_N : N ; -- blodflöde..nn.1
  blodfull_1_A : A ; -- blodfull..av.1
  blodfullhet_1_N : N ; -- blodfullhet..nn.1
  blodfyllning_1_N : N ; -- blodfyllning..nn.1
  blodfärgämne_1_N : N ; -- blodfärgämne..nn.1
  blodförgiftning_1_N : N ; -- blodförgiftning..nn.1
  blodförlust_1_N : N ; -- blodförlust..nn.1
  blodförtunnande_1_A : A ; -- blodförtunnande..av.1
  blodgenomströmning_1_N : N ; -- blodgenomströmning..nn.1
  blodgivarcentral_1_N : N ; -- blodgivarcentral..nn.1
  blodgivare_1_N : N ; -- blodgivare..nn.1
  blodgivning_1_N : N ; -- blodgivning..nn.1
  blodgrape_1_N : N ; -- blodgrape..nn.1
  blodgrupp_1_N : N ; -- blodgrupp..nn.1
  blodgång_1_N : N ; -- blodgång..nn.1
  blodhosta_1_N : N ; -- blodhosta..nn.1
  blodhostning_1_N : N ; -- blodhostning..nn.1
  blodhund_1_N : N ; -- blodhund..nn.1
  blodig_1_A : A ; -- blodig..av.1
  blodigel_1_N : N ; -- blodigel..nn.1
  blodighet_1_N : N ; -- blodighet..nn.1
  blodisande_1_A : A ; -- blodisande..av.1
  blodkorv_1_N : N ; -- blodkorv..nn.1
  blodkropp_1_N : N ; -- blodkropp..nn.1
  blodkräfta_1_N : N ; -- blodkräfta..nn.1
  blodkräkning_1_N : N ; -- blodkräkning..nn.1
  blodkärl_1_N : N ; -- blodkärl..nn.1
  blodkärlsbråck_1_N : N ; -- blodkärlsbråck..nn.1
  blodledare_1_N : N ; -- blodledare..nn.1
  blodlever_1_N : N ; -- blodlever..nn.1
  blodlutsalt_1_N : N ; -- blodlutsalt..nn.1
  blodlutssalt_1_N : N ; -- blodlutssalt..nn.1
  blodlönn_1_N : N ; -- blodlönn..nn.1
  blodlös_1_A : A ; -- blodlös..av.1
  blodlöshet_1_N : N ; -- blodlöshet..nn.1
  blodmat_1_N : N ; -- blodmat..nn.1
  blodnäva_1_N : N ; -- blodnäva..nn.1
  blodomlopp_1_N : N ; -- blodomlopp..nn.1
  blodpalt_1_N : N ; -- blodpalt..nn.1
  blodplasma_1_N : N ; -- blodplasma..nn.1
  blodplätt_1_N : N ; -- blodplätt..nn.1
  blodpropp_1_N : N ; -- blodpropp..nn.1
  blodprotein_1_N : N ; -- blodprotein..nn.1
  blodprov_1_N : N ; -- blodprov..nn.1
  blodprovstagning_1_N : N ; -- blodprovstagning..nn.1
  blodpudding_1_N : N ; -- blodpudding..nn.1
  blodpuddingsbit_1_N : N ; -- blodpuddingsbit..nn.1
  blodpump_1_N : N ; -- blodpump..nn.1
  blodpöl_1_N : N ; -- blodpöl..nn.1
  blodrand_1_N : N ; -- blodrand..nn.1
  blodregn_1_N : N ; -- blodregn..nn.1
  blodriska_1_N : N ; -- blodriska..nn.1
  blodrot_1_N : N ; -- blodrot..nn.1
  blodröd_1_A : A ; -- blodröd..av.1
  blodsband_1_N : N ; -- blodsband..nn.1
  blodsdiamant_1_N : N ; -- blodsdiamant..nn.1
  blodsdrama_1_N : N ; -- blodsdrama..nn.1
  blodsdroppe_1_N : N ; -- blodsdroppe..nn.1
  blodsdåd_1_N : N ; -- blodsdåd..nn.1
  blodserum_1_N : N ; -- blodserum..nn.1
  blodshämnare_1_N : N ; -- blodshämnare..nn.1
  blodshämnd_1_N : N ; -- blodshämnd..nn.1
  blodsjukdom_1_N : N ; -- blodsjukdom..nn.1
  blodsmak_1_N : N ; -- blodsmak..nn.1
  blodsmystik_1_N : N ; -- blodsmystik..nn.1
  blodsocker_1_N : N ; -- blodsocker..nn.1
  blodsockersvacka_1_N : N ; -- blodsockersvacka..nn.1
  blodspenning_1_N : N ; -- blodspenning..nn.1
  blodspottning_1_N : N ; -- blodspottning..nn.1
  blodsprängd_1_A : A ; -- blodsprängd..av.1
  blodsprängdhet_1_N : N ; -- blodsprängdhet..nn.1
  blodspår_1_N : N ; -- blodspår..nn.1
  blodstallning_1_N : N ; -- blodstallning..nn.1
  blodstensmalm_1_N : N ; -- blodstensmalm..nn.1
  blodstillande_1_A : A ; -- blodstillande..av.1
  blodstillning_1_N : N ; -- blodstillning..nn.1
  blodstinn_1_A : A ; -- blodstinn..av.1
  blodstinnhet_1_N : N ; -- blodstinnhet..nn.1
  blodstockning_1_N : N ; -- blodstockning..nn.1
  blodstänkt_1_A : A ; -- blodstänkt..av.1
  blodstörtning_1_N : N ; -- blodstörtning..nn.1
  blodsugande_1_A : A ; -- blodsugande..av.1
  blodsugare_1_N : N ; -- blodsugare..nn.1
  blodsugeri_1_N : N ; -- blodsugeri..nn.1
  blodsutgjutelse_1_N : N ; -- blodsutgjutelse..nn.1
  blodsvettning_1_N : N ; -- blodsvettning..nn.1
  blodsvulst_1_N : N ; -- blodsvulst..nn.1
  blodsystem_1_N : N ; -- blodsystem..nn.1
  blodsänka_1_N : N ; -- blodsänka..nn.1
  blodtappning_1_N : N ; -- blodtappning..nn.1
  blodtransfusion_1_N : N ; -- blodtransfusion..nn.1
  blodtryck_1_N : N ; -- blodtryck..nn.1
  blodtryckshöjande_1_A : A ; -- blodtryckshöjande..av.1
  blodtryckshöjning_1_N : N ; -- blodtryckshöjning..nn.1
  blodtryckssänkande_1_A : A ; -- blodtryckssänkande..av.1
  blodtryckssänkning_1_N : N ; -- blodtryckssänkning..nn.1
  blodtyp_1_N : N ; -- blodtyp..nn.1
  blodtörst_1_N : N ; -- blodtörst..nn.1
  blodtörstig_1_A : A ; -- blodtörstig..av.1
  blodtörstighet_1_N : N ; -- blodtörstighet..nn.1
  blodutgjutning_1_N : N ; -- blodutgjutning..nn.1
  blodvallning_1_N : N ; -- blodvallning..nn.1
  blodvite_1_N : N ; -- blodvite..nn.1
  blodvittring_1_N : N ; -- blodvittring..nn.1
  blodvärde_1_N : N ; -- blodvärde..nn.1
  blodvätska_1_N : N ; -- blodvätska..nn.1
  blodvåg_1_N : N ; -- blodvåg..nn.1
  blodåder_1_N : N ; -- blodåder..nn.1
  blodöverfyllnad_1_N : N ; -- blodöverfyllnad..nn.1
  blodöverföring_1_N : N ; -- blodöverföring..nn.1
  blog_1_N : N ; -- blog..nn.1
  bloga_1_V : V ; -- bloga..vb.1
  blogande_1_N : N ; -- blogande..nn.1
  blogare_1_N : N ; -- blogare..nn.1
  blogg_1_N : N ; -- blogg..nn.1
  blogga_1_V : V ; -- blogga..vb.1
  bloggande_1_N : N ; -- bloggande..nn.1
  bloggare_1_N : N ; -- bloggare..nn.1
  bloggerska_1_N : N ; -- bloggerska..nn.1
  blogginlägg_1_N : N ; -- blogginlägg..nn.1
  bloggosfär_1_N : N ; -- bloggosfär..nn.1
  bloginlägg_1_N : N ; -- bloginlägg..nn.1
  blogosfär_1_N : N ; -- blogosfär..nn.1
  blomaxel_1_N : N ; -- blomaxel..nn.1
  blombefruktning_1_N : N ; -- blombefruktning..nn.1
  blomblad_1_N : N ; -- blomblad..nn.1
  blombord_1_N : N ; -- blombord..nn.1
  blombotten_1_N : N ; -- blombotten..nn.1
  blombukett_1_N : N ; -- blombukett..nn.1
  blomdoft_1_N : N ; -- blomdoft..nn.1
  blomfat_1_N : N ; -- blomfat..nn.1
  blomfjäll_1_N : N ; -- blomfjäll..nn.1
  blomflock_1_N : N ; -- blomflock..nn.1
  blomfoder_1_N : N ; -- blomfoder..nn.1
  blomform_1_N : N ; -- blomform..nn.1
  blomfäste_1_N : N ; -- blomfäste..nn.1
  blomholk_1_N : N ; -- blomholk..nn.1
  blomhuvud_1_N : N ; -- blomhuvud..nn.1
  blomhylle_1_N : N ; -- blomhylle..nn.1
  blomhänge_1_N : N ; -- blomhänge..nn.1
  blomhölster_1_N : N ; -- blomhölster..nn.1
  blomjord_1_N : N ; -- blomjord..nn.1
  blomkalk_1_N : N ; -- blomkalk..nn.1
  blomklase_1_N : N ; -- blomklase..nn.1
  blomklädd_1_A : A ; -- blomklädd..av.1
  blomknippe_1_N : N ; -- blomknippe..nn.1
  blomknopp_1_N : N ; -- blomknopp..nn.1
  blomkolv_1_N : N ; -- blomkolv..nn.1
  blomkorg_1_N : N ; -- blomkorg..nn.1
  blomkrans_1_N : N ; -- blomkrans..nn.1
  blomkrona_1_N : N ; -- blomkrona..nn.1
  blomkruka_1_N : N ; -- blomkruka..nn.1
  blomkvast_1_N : N ; -- blomkvast..nn.1
  blomkäpp_1_N : N ; -- blomkäpp..nn.1
  blomkål_1_N : N ; -- blomkål..nn.1
  blomkålshuvud_1_N : N ; -- blomkålshuvud..nn.1
  blomkålssvamp_1_N : N ; -- blomkålssvamp..nn.1
  blomkålsöra_1_N : N ; -- blomkålsöra..nn.1
  blomlåda_1_N : N ; -- blomlåda..nn.1
  blomma_1_N : N ; -- blomma..nn.1
  blomma_1_V : V ; -- blomma..vb.1
  blommande_1_N : N ; -- blommande..nn.1
  blommerad_1_A : A ; -- blommerad..av.1
  blommig_1_A : A ; -- blommig..av.1
  blommighet_1_N : N ; -- blommighet..nn.1
  blommografera_1_V : V ; -- blommografera..vb.1
  blommograferande_1_N : N ; -- blommograferande..nn.1
  blommograferbar_1_A : A ; -- blommograferbar..av.1
  blommograferbarhet_1_N : N ; -- blommograferbarhet..nn.1
  blommografering_1_N : N ; -- blommografering..nn.1
  blommogram_1_N : N ; -- blommogram..nn.1
  blommönster_1_N : N ; -- blommönster..nn.1
  blomning_1_N : N ; -- blomning..nn.1
  blomningstid_1_N : N ; -- blomningstid..nn.1
  blomplanta_1_N : N ; -- blomplanta..nn.1
  blomskaft_1_N : N ; -- blomskaft..nn.1
  blomst_1_N : N ; -- blomst..nn.1
  blomster_1_N : N ; -- blomster..nn.1
  blomsteraffär_1_N : N ; -- blomsteraffär..nn.1
  blomsterbord_1_N : N ; -- blomsterbord..nn.1
  blomsterbädd_1_N : N ; -- blomsterbädd..nn.1
  blomsterdoft_1_N : N ; -- blomsterdoft..nn.1
  blomsterdoftande_1_A : A ; -- blomsterdoftande..av.1
  blomsterflicka_1_N : N ; -- blomsterflicka..nn.1
  blomsterförmedling_1_N : N ; -- blomsterförmedling..nn.1
  blomsterförsäljerska_1_N : N ; -- blomsterförsäljerska..nn.1
  blomstergirland_1_N : N ; -- blomstergirland..nn.1
  blomstergård_1_N : N ; -- blomstergård..nn.1
  blomsterhandel_1_N : N ; -- blomsterhandel..nn.1
  blomsterhandlare_1_N : N ; -- blomsterhandlare..nn.1
  blomsterhonung_1_N : N ; -- blomsterhonung..nn.1
  blomsterklädd_1_A : A ; -- blomsterklädd..av.1
  blomsterkrans_1_N : N ; -- blomsterkrans..nn.1
  blomsterkransa_1_V : V ; -- blomsterkransa..vb.1
  blomsterkvast_1_N : N ; -- blomsterkvast..nn.1
  blomsterlåda_1_N : N ; -- blomsterlåda..nn.1
  blomsterlök_1_N : N ; -- blomsterlök..nn.1
  blomstermålare_1_N : N ; -- blomstermålare..nn.1
  blomstermånad_1_N : N ; -- blomstermånad..nn.1
  blomsterodling_1_N : N ; -- blomsterodling..nn.1
  blomsterprakt_1_N : N ; -- blomsterprakt..nn.1
  blomsterrabatt_1_N : N ; -- blomsterrabatt..nn.1
  blomstersmycka_1_V : V ; -- blomstersmycka..vb.1
  blomsterspruta_1_N : N ; -- blomsterspruta..nn.1
  blomsterspråk_1_N : N ; -- blomsterspråk..nn.1
  blomstertid_1_N : N ; -- blomstertid..nn.1
  blomsterträdgård_1_N : N ; -- blomsterträdgård..nn.1
  blomsteruppsats_1_N : N ; -- blomsteruppsats..nn.1
  blomstervas_1_N : N ; -- blomstervas..nn.1
  blomsteräng_1_N : N ; -- blomsteräng..nn.1
  blomstjälk_1_N : N ; -- blomstjälk..nn.1
  blomstoft_1_N : N ; -- blomstoft..nn.1
  blomstra_1_V : V ; -- blomstra..vb.1
  blomstrande_1_N : N ; -- blomstrande..nn.1
  blomstring_1_N : N ; -- blomstring..nn.1
  blomstringsperiod_1_N : N ; -- blomstringsperiod..nn.1
  blomstringstid_1_N : N ; -- blomstringstid..nn.1
  blomställ_1_N : N ; -- blomställ..nn.1
  blomställning_1_N : N ; -- blomställning..nn.1
  blomtjuv_1_N : N ; -- blomtjuv..nn.1
  blomvas_1_N : N ; -- blomvas..nn.1
  blomvass_1_N : N ; -- blomvass..nn.1
  blomväxt_1_N : N ; -- blomväxt..nn.1
  blond_1_A : A ; -- blond..av.1
  blond_1_N : N ; -- blond..nn.1
  blondera_1_V : V ; -- blondera..vb.1
  blonderande_1_N : N ; -- blonderande..nn.1
  blonderbar_1_A : A ; -- blonderbar..av.1
  blonderbarhet_1_N : N ; -- blonderbarhet..nn.1
  blondering_1_N : N ; -- blondering..nn.1
  blondhet_1_N : N ; -- blondhet..nn.1
  blondin_1_N : N ; -- blondin..nn.1
  bloss_1_N : N ; -- bloss..nn.1
  blossa_1_V : V ; -- blossa..vb.1
  blossande_1_N : N ; -- blossande..nn.1
  blot_1_N : N ; -- blot..nn.1
  blota_1_V : V ; -- blota..vb.1
  blotande_1_N : N ; -- blotande..nn.1
  blott_1_A : A ; -- blott..av.1
  blotta_1_N : N ; -- blotta..nn.1
  blotta_1_V : V ; -- blotta..vb.1
  blottande_1_N : N ; -- blottande..nn.1
  blottare_1_N : N ; -- blottare..nn.1
  blottlägga_1_V : V ; -- blottlägga..vb.1
  blottläggande_1_N : N ; -- blottläggande..nn.1
  blottläggning_1_N : N ; -- blottläggning..nn.1
  blottställa_1_V : V ; -- blottställa..vb.1
  blottställande_1_N : N ; -- blottställande..nn.1
  blottställd_1_A : A ; -- blottställd..av.1
  blottställdhet_1_N : N ; -- blottställdhet..nn.1
  blottställning_1_N : N ; -- blottställning..nn.1
  blowout_1_N : N ; -- blowout..nn.1
  bludder_1_N : N ; -- bludder..nn.1
  bluddra_1_V : V ; -- bluddra..vb.1
  bluddrande_1_N : N ; -- bluddrande..nn.1
  blues_1_N : N ; -- blues..nn.1
  bluff_1_N : N ; -- bluff..nn.1
  bluffa_1_V : V ; -- bluffa..vb.1
  bluffaktura_1_N : N ; -- bluffaktura..nn.1
  bluffande_1_N : N ; -- bluffande..nn.1
  bluffbygge_1_N : N ; -- bluffbygge..nn.1
  bluffmakare_1_N : N ; -- bluffmakare..nn.1
  bluffpiller_1_N : N ; -- bluffpiller..nn.1
  bluffprojekt_1_N : N ; -- bluffprojekt..nn.1
  blund_1_N : N ; -- blund..nn.1
  blunda_1_V : V ; -- blunda..vb.1
  blundande_1_N : N ; -- blundande..nn.1
  blunddocka_1_N : N ; -- blunddocka..nn.1
  blunder_1_N : N ; -- blunder..nn.1
  blus_1_N : N ; -- blus..nn.1
  blusliv_1_N : N ; -- blusliv..nn.1
  bly_1_N : N ; -- bly..nn.1
  blya_1_V : V ; -- blya..vb.1
  blyacetat_1_N : N ; -- blyacetat..nn.1
  blyackumulator_1_N : N ; -- blyackumulator..nn.1
  blyaktig_1_A : A ; -- blyaktig..av.1
  blyande_1_N : N ; -- blyande..nn.1
  blyaska_1_N : N ; -- blyaska..nn.1
  blyazid_1_N : N ; -- blyazid..nn.1
  blybatteri_1_N : N ; -- blybatteri..nn.1
  blyblomma_1_N : N ; -- blyblomma..nn.1
  blydagg_1_N : N ; -- blydagg..nn.1
  blyerts_1_N : N ; -- blyerts..nn.1
  blyertsgrå_1_A : A ; -- blyertsgrå..av.1
  blyertspenna_1_N : N ; -- blyertspenna..nn.1
  blyfolie_1_N : N ; -- blyfolie..nn.1
  blyfri_1_A : A ; -- blyfri..av.1
  blyfärg_1_N : N ; -- blyfärg..nn.1
  blyfärgad_1_A : A ; -- blyfärgad..av.1
  blyförening_1_N : N ; -- blyförening..nn.1
  blyförgiftad_1_A : A ; -- blyförgiftad..av.1
  blyförgiftning_1_N : N ; -- blyförgiftning..nn.1
  blyg_1_A : A ; -- blyg..av.1
  blygd_1_N : N ; -- blygd..nn.1
  blygdben_1_N : N ; -- blygdben..nn.1
  blygdhår_1_N : N ; -- blygdhår..nn.1
  blygdhår_2_N : N ; -- blygdhår..nn.2
  blygdläpp_1_N : N ; -- blygdläpp..nn.1
  blyghet_1_N : N ; -- blyghet..nn.1
  blyglans_1_N : N ; -- blyglans..nn.1
  blyglas_1_N : N ; -- blyglas..nn.1
  blyglete_1_N : N ; -- blyglete..nn.1
  blygrå_1_A : A ; -- blygrå..av.1
  blygsam_1_A : A ; -- blygsam..av.1
  blygsamhet_1_N : N ; -- blygsamhet..nn.1
  blygsel_1_N : N ; -- blygsel..nn.1
  blygult_1_N : N ; -- blygult..nn.1
  blyhagel_1_N : N ; -- blyhagel..nn.1
  blyhalt_1_N : N ; -- blyhalt..nn.1
  blyhaltig_1_A : A ; -- blyhaltig..av.1
  blykula_1_N : N ; -- blykula..nn.1
  blykyld_1_A : A ; -- blykyld..av.1
  blyköl_1_N : N ; -- blyköl..nn.1
  blylod_1_N : N ; -- blylod..nn.1
  blymantel_1_N : N ; -- blymantel..nn.1
  blymönja_1_N : N ; -- blymönja..nn.1
  blyoxid_1_N : N ; -- blyoxid..nn.1
  blyplåt_1_N : N ; -- blyplåt..nn.1
  blysalva_1_N : N ; -- blysalva..nn.1
  blysocker_1_N : N ; -- blysocker..nn.1
  blytetraetyl_1_N : N ; -- blytetraetyl..nn.1
  blytung_1_A : A ; -- blytung..av.1
  blytunghet_1_N : N ; -- blytunghet..nn.1
  blytyngd_1_N : N ; -- blytyngd..nn.1
  blyvitt_1_N : N ; -- blyvitt..nn.1
  blyättika_1_N : N ; -- blyättika..nn.1
  bläck_1_N : N ; -- bläck..nn.1
  bläcka_1_N : N ; -- bläcka..nn.1
  bläcka_1_V : V ; -- bläcka..vb.1
  bläckande_1_N : N ; -- bläckande..nn.1
  bläckblåsa_1_N : N ; -- bläckblåsa..nn.1
  bläckfisk_1_N : N ; -- bläckfisk..nn.1
  bläckfläck_1_N : N ; -- bläckfläck..nn.1
  bläckhorn_1_N : N ; -- bläckhorn..nn.1
  bläckig_1_A : A ; -- bläckig..av.1
  bläckkörtel_1_N : N ; -- bläckkörtel..nn.1
  bläckpenna_1_N : N ; -- bläckpenna..nn.1
  bläckplump_1_N : N ; -- bläckplump..nn.1
  bläckpulver_1_N : N ; -- bläckpulver..nn.1
  bläcksuddare_1_N : N ; -- bläcksuddare..nn.1
  bläcksvamp_1_N : N ; -- bläcksvamp..nn.1
  bläcksvart_1_A : A ; -- bläcksvart..av.1
  bläcksäck_1_N : N ; -- bläcksäck..nn.1
  bläckteckning_1_N : N ; -- bläckteckning..nn.1
  bläda_1_V : V ; -- bläda..vb.1
  blädande_1_N : N ; -- blädande..nn.1
  blädderblock_1_N : N ; -- blädderblock..nn.1
  blädderbok_1_N : N ; -- blädderbok..nn.1
  bläddra_1_N : N ; -- bläddra..nn.1
  bläddra_1_V : V ; -- bläddra..vb.1
  bläddrande_1_N : N ; -- bläddrande..nn.1
  blädning_1_N : N ; -- blädning..nn.1
  blända_1_V : V ; -- blända..vb.1
  bländande_1_A : A ; -- bländande..av.1
  bländande_1_N : N ; -- bländande..nn.1
  bländare_1_N : N ; -- bländare..nn.1
  blände_1_N : N ; -- blände..nn.1
  bländfri_1_A : A ; -- bländfri..av.1
  bländning_1_N : N ; -- bländning..nn.1
  bländrisk_1_N : N ; -- bländrisk..nn.1
  bländskiva_1_N : N ; -- bländskiva..nn.1
  bländskydd_1_N : N ; -- bländskydd..nn.1
  bländverk_1_N : N ; -- bländverk..nn.1
  bländvit_1_A : A ; -- bländvit..av.1
  bläng_1_N : N ; -- bläng..nn.1
  blänga_1_V : V ; -- blänga..vb.1
  blängande_1_N : N ; -- blängande..nn.1
  blängning_1_N : N ; -- blängning..nn.1
  blänk_1_N : N ; -- blänk..nn.1
  blänka_1_V : V ; -- blänka..vb.1
  blänkande_1_N : N ; -- blänkande..nn.1
  blänkare_1_N : N ; -- blänkare..nn.1
  blänke_1_N : N ; -- blänke..nn.1
  blänkfyr_1_N : N ; -- blänkfyr..nn.1
  blänkning_1_N : N ; -- blänkning..nn.1
  bläs_1_N : N ; -- bläs..nn.1
  bläsand_1_N : N ; -- bläsand..nn.1
  bläsbock_1_N : N ; -- bläsbock..nn.1
  bläsgås_1_N : N ; -- bläsgås..nn.1
  blästa_1_V : V ; -- blästa..vb.1
  blästande_1_N : N ; -- blästande..nn.1
  bläster_1_N : N ; -- bläster..nn.1
  blästerrör_1_N : N ; -- blästerrör..nn.1
  blästerugn_1_N : N ; -- blästerugn..nn.1
  blästra_1_V : V ; -- blästra..vb.1
  blästrande_1_N : N ; -- blästrande..nn.1
  blå_1_A : A ; -- blå..av.1
  blåaktig_1_A : A ; -- blåaktig..av.1
  blåaktighet_1_N : N ; -- blåaktighet..nn.1
  blåanlupen_1_A : A ; -- blåanlupen..av.1
  blåblodig_1_A : A ; -- blåblodig..av.1
  blåblodighet_1_N : N ; -- blåblodighet..nn.1
  blåbyxa_1_N : N ; -- blåbyxa..nn.1
  blåbär_1_N : N ; -- blåbär..nn.1
  blåbärsbuske_1_N : N ; -- blåbärsbuske..nn.1
  blåbärspannkaka_1_N : N ; -- blåbärspannkaka..nn.1
  blåbärsplockare_1_N : N ; -- blåbärsplockare..nn.1
  blåbärsris_1_N : N ; -- blåbärsris..nn.1
  blåbärssaft_1_N : N ; -- blåbärssaft..nn.1
  blåbärssoppa_1_N : N ; -- blåbärssoppa..nn.1
  blåbärssylt_1_N : N ; -- blåbärssylt..nn.1
  blåduva_1_N : N ; -- blåduva..nn.1
  blådåre_1_N : N ; -- blådåre..nn.1
  blåeld_1_N : N ; -- blåeld..nn.1
  blåelse_1_N : N ; -- blåelse..nn.1
  blåfrusen_1_A : A ; -- blåfrusen..av.1
  blåförskjutning_1_N : N ; -- blåförskjutning..nn.1
  blågrå_1_A : A ; -- blågrå..av.1
  blågrön_1_A : A ; -- blågrön..av.1
  blågrönalg_1_N : N ; -- blågrönalg..nn.1
  blågul_1_A : A ; -- blågul..av.1
  blåhaj_1_N : N ; -- blåhaj..nn.1
  blåhake_1_N : N ; -- blåhake..nn.1
  blåhallon_1_N : N ; -- blåhallon..nn.1
  blåhet_1_N : N ; -- blåhet..nn.1
  blåhjon_1_N : N ; -- blåhjon..nn.1
  blåholts_1_N : N ; -- blåholts..nn.1
  blåis_1_N : N ; -- blåis..nn.1
  blåjacka_1_N : N ; -- blåjacka..nn.1
  blåjord_1_N : N ; -- blåjord..nn.1
  blåklint_1_N : N ; -- blåklint..nn.1
  blåklocka_1_N : N ; -- blåklocka..nn.1
  blåklädd_1_A : A ; -- blåklädd..av.1
  blåkopia_1_N : N ; -- blåkopia..nn.1
  blåkopiera_1_V : V ; -- blåkopiera..vb.1
  blåkopierande_1_N : N ; -- blåkopierande..nn.1
  blåkopierbar_1_A : A ; -- blåkopierbar..av.1
  blåkopierbarhet_1_N : N ; -- blåkopierbarhet..nn.1
  blåkopiering_1_N : N ; -- blåkopiering..nn.1
  blåkråka_1_N : N ; -- blåkråka..nn.1
  blåkullafärd_1_N : N ; -- blåkullafärd..nn.1
  blåkål_1_N : N ; -- blåkål..nn.1
  blåköra_1_V : V ; -- blåköra..vb.1
  blåkörande_1_N : N ; -- blåkörande..nn.1
  blålera_1_N : N ; -- blålera..nn.1
  blålila_1_A : A ; -- blålila..av.1
  blåljuga_1_V : V ; -- blåljuga..vb.1
  blåljus_1_N : N ; -- blåljus..nn.1
  blålusern_1_N : N ; -- blålusern..nn.1
  blåmes_1_N : N ; -- blåmes..nn.1
  blåmusseron_1_N : N ; -- blåmusseron..nn.1
  blåmussla_1_N : N ; -- blåmussla..nn.1
  blåmärke_1_N : N ; -- blåmärke..nn.1
  blåmålad_1_A : A ; -- blåmålad..av.1
  blåmålning_1_N : N ; -- blåmålning..nn.1
  blåna_1_V : V ; -- blåna..vb.1
  blånad_1_N : N ; -- blånad..nn.1
  blånande_1_N : N ; -- blånande..nn.1
  blåneka_1_V : V ; -- blåneka..vb.1
  blånekande_1_N : N ; -- blånekande..nn.1
  blåpenna_1_N : N ; -- blåpenna..nn.1
  blåprickig_1_A : A ; -- blåprickig..av.1
  blårandig_1_A : A ; -- blårandig..av.1
  blåregn_1_N : N ; -- blåregn..nn.1
  blårutig_1_A : A ; -- blårutig..av.1
  blåräv_1_N : N ; -- blåräv..nn.1
  blåröd_1_A : A ; -- blåröd..av.1
  blåsa_1_N : N ; -- blåsa..nn.1
  blåsa_1_V : V ; -- blåsa..vb.1
  blåsa_2_V : V ; -- blåsa..vb.2
  blåsande_1_N : N ; -- blåsande..nn.1
  blåsare_1_N : N ; -- blåsare..nn.1
  blåsbälg_1_N : N ; -- blåsbälg..nn.1
  blåsfoting_1_N : N ; -- blåsfoting..nn.1
  blåshals_1_N : N ; -- blåshals..nn.1
  blåshalskörtel_1_N : N ; -- blåshalskörtel..nn.1
  blåshål_1_N : N ; -- blåshål..nn.1
  blåsig_1_A : A ; -- blåsig..av.1
  blåsinstrument_1_N : N ; -- blåsinstrument..nn.1
  blåsippa_1_N : N ; -- blåsippa..nn.1
  blåsjuka_1_N : N ; -- blåsjuka..nn.1
  blåskatarr_1_N : N ; -- blåskatarr..nn.1
  blåskimrande_1_A : A ; -- blåskimrande..av.1
  blåslagen_1_A : A ; -- blåslagen..av.1
  blåslampa_1_N : N ; -- blåslampa..nn.1
  blåsljud_1_N : N ; -- blåsljud..nn.1
  blåsmask_1_N : N ; -- blåsmask..nn.1
  blåsning_1_N : N ; -- blåsning..nn.1
  blåsorkester_1_N : N ; -- blåsorkester..nn.1
  blåspistol_1_N : N ; -- blåspistol..nn.1
  blåsprit_1_N : N ; -- blåsprit..nn.1
  blåsrör_1_N : N ; -- blåsrör..nn.1
  blåssten_1_N : N ; -- blåssten..nn.1
  blåst_1_A : A ; -- blåst..av.1
  blåst_1_N : N ; -- blåst..nn.1
  blåsthet_1_N : N ; -- blåsthet..nn.1
  blåstrumpa_1_N : N ; -- blåstrumpa..nn.1
  blåställ_1_N : N ; -- blåställ..nn.1
  blåstång_1_N : N ; -- blåstång..nn.1
  blåsur_1_A : A ; -- blåsur..av.1
  blåsurhet_1_N : N ; -- blåsurhet..nn.1
  blåsvart_1_A : A ; -- blåsvart..av.1
  blåsväder_1_N : N ; -- blåsväder..nn.1
  blåsyra_1_N : N ; -- blåsyra..nn.1
  blåsört_1_N : N ; -- blåsört..nn.1
  blåtira_1_N : N ; -- blåtira..nn.1
  blåtonad_1_A : A ; -- blåtonad..av.1
  blåträ_1_N : N ; -- blåträ..nn.1
  blåtunga_1_N : N ; -- blåtunga..nn.1
  blåtåtel_1_N : N ; -- blåtåtel..nn.1
  blåval_1_N : N ; -- blåval..nn.1
  blåvarm_1_A : A ; -- blåvarm..av.1
  blåved_1_N : N ; -- blåved..nn.1
  blåvinge_1_N : N ; -- blåvinge..nn.1
  blåviolett_1_A : A ; -- blåviolett..av.1
  blåvit_1_A : A ; -- blåvit..av.1
  blåvitling_1_N : N ; -- blåvitling..nn.1
  blåvärme_1_N : N ; -- blåvärme..nn.1
  blåögd_1_A : A ; -- blåögd..av.1
  blåögdhet_1_N : N ; -- blåögdhet..nn.1
  blöda_1_V : V ; -- blöda..vb.1
  blödande_1_N : N ; -- blödande..nn.1
  blödare_1_N : N ; -- blödare..nn.1
  blödarsjuka_1_N : N ; -- blödarsjuka..nn.1
  blödig_1_A : A ; -- blödig..av.1
  blödighet_1_N : N ; -- blödighet..nn.1
  blödning_1_N : N ; -- blödning..nn.1
  blöja_1_N : N ; -- blöja..nn.1
  blöjbyte_1_N : N ; -- blöjbyte..nn.1
  blöjålder_1_N : N ; -- blöjålder..nn.1
  blöt_1_A : A ; -- blöt..av.1
  blöta_1_N : N ; -- blöta..nn.1
  blöta_1_V : V ; -- blöta..vb.1
  blötande_1_N : N ; -- blötande..nn.1
  blötdjur_1_N : N ; -- blötdjur..nn.1
  blötfoder_1_N : N ; -- blötfoder..nn.1
  blöthet_1_N : N ; -- blöthet..nn.1
  blötlägga_1_V : V ; -- blötlägga..vb.1
  blötläggande_1_N : N ; -- blötläggande..nn.1
  blötläggning_1_N : N ; -- blötläggning..nn.1
  blötläggningsmedel_1_N : N ; -- blötläggningsmedel..nn.1
  blötna_1_V : V ; -- blötna..vb.1
  blötnande_1_N : N ; -- blötnande..nn.1
  blötning_1_N : N ; -- blötning..nn.1
  blötröta_1_N : N ; -- blötröta..nn.1
  blötsnö_1_N : N ; -- blötsnö..nn.1
  blötsvart_1_A : A ; -- blötsvart..av.1
  bo_1_N : N ; -- bo..nn.1
  bo_1_V : V ; -- bo..vb.1
  boa_1_N : N ; -- boa..nn.1
  boaorm_1_N : N ; -- boaorm..nn.1
  board_1_N : N ; -- board..nn.1
  boardingcard_1_N : N ; -- boardingcard..nn.1
  boardingkort_1_N : N ; -- boardingkort..nn.1
  boasera_1_V : V ; -- boasera..vb.1
  boaserande_1_N : N ; -- boaserande..nn.1
  boaserbar_1_A : A ; -- boaserbar..av.1
  boaserbarhet_1_N : N ; -- boaserbarhet..nn.1
  boasering_1_N : N ; -- boasering..nn.1
  bob_1_N : N ; -- bob..nn.1
  bobb_1_N : N ; -- bobb..nn.1
  bobba_1_N : N ; -- bobba..nn.1
  bobba_1_V : V ; -- bobba..vb.1
  bobbande_1_N : N ; -- bobbande..nn.1
  bobin_1_N : N ; -- bobin..nn.1
  boboll_1_N : N ; -- boboll..nn.1
  boboll_2_N : N ; -- boboll..nn.2
  bobsleigh_1_N : N ; -- bobsleigh..nn.1
  boccia_1_N : N ; -- boccia..nn.1
  bock_1_N : N ; -- bock..nn.1
  bocka_1_V : V ; -- bocka..vb.1
  bockande_1_N : N ; -- bockande..nn.1
  bockbent_1_A : A ; -- bockbent..av.1
  bockbenthet_1_N : N ; -- bockbenthet..nn.1
  bockblad_1_N : N ; -- bockblad..nn.1
  bockbro_1_N : N ; -- bockbro..nn.1
  bockbränning_1_N : N ; -- bockbränning..nn.1
  bockfot_1_N : N ; -- bockfot..nn.1
  bockhorn_1_N : N ; -- bockhorn..nn.1
  bockhornsklöver_1_N : N ; -- bockhornsklöver..nn.1
  bockhornsklöverfrö_1_N : N ; -- bockhornsklöverfrö..nn.1
  bockning_1_N : N ; -- bockning..nn.1
  bockprov_1_N : N ; -- bockprov..nn.1
  bockskägg_1_N : N ; -- bockskägg..nn.1
  bocksprång_1_N : N ; -- bocksprång..nn.1
  bocktörne_1_N : N ; -- bocktörne..nn.1
  bockverktyg_1_N : N ; -- bockverktyg..nn.1
  bockvinkel_1_N : N ; -- bockvinkel..nn.1
  bocköl_1_N : N ; -- bocköl..nn.1
  bod_1_N : N ; -- bod..nn.1
  bodbetjänt_1_N : N ; -- bodbetjänt..nn.1
  bodega_1_N : N ; -- bodega..nn.1
  bodelning_1_N : N ; -- bodelning..nn.1
  bodknodd_1_N : N ; -- bodknodd..nn.1
  bodlänga_1_N : N ; -- bodlänga..nn.1
  bodmeri_1_N : N ; -- bodmeri..nn.1
  bodräkt_1_N : N ; -- bodräkt..nn.1
  bodybuilding_1_N : N ; -- bodybuilding..nn.1
  boende_1_N : N ; -- boende..nn.1
  boende_2_N : N ; -- boende..nn.2
  boendeform_1_N : N ; -- boendeform..nn.1
  boendekostnad_1_N : N ; -- boendekostnad..nn.1
  boendesegregering_1_N : N ; -- boendesegregering..nn.1
  boer_1_N : N ; -- boer..nn.1
  boett_1_N : N ; -- boett..nn.1
  boettlås_1_N : N ; -- boettlås..nn.1
  bofast_1_A : A ; -- bofast..av.1
  bofasthet_1_N : N ; -- bofasthet..nn.1
  bofink_1_N : N ; -- bofink..nn.1
  bofinksdrill_1_N : N ; -- bofinksdrill..nn.1
  bofinkssång_1_N : N ; -- bofinkssång..nn.1
  bofällig_1_A : A ; -- bofällig..av.1
  bofällighet_1_N : N ; -- bofällighet..nn.1
  bog_1_N : N ; -- bog..nn.1
  bogankare_1_N : N ; -- bogankare..nn.1
  bogblad_1_N : N ; -- bogblad..nn.1
  bogbruten_1_A : A ; -- bogbruten..av.1
  boggi_1_N : N ; -- boggi..nn.1
  boggitryck_1_N : N ; -- boggitryck..nn.1
  boghalt_1_A : A ; -- boghalt..av.1
  boghöjd_1_N : N ; -- boghöjd..nn.1
  bogpropeller_1_N : N ; -- bogpropeller..nn.1
  bogsera_1_V : V ; -- bogsera..vb.1
  bogserande_1_N : N ; -- bogserande..nn.1
  bogserare_1_N : N ; -- bogserare..nn.1
  bogserbar_1_A : A ; -- bogserbar..av.1
  bogserbarhet_1_N : N ; -- bogserbarhet..nn.1
  bogserbåt_1_N : N ; -- bogserbåt..nn.1
  bogsergalge_1_N : N ; -- bogsergalge..nn.1
  bogsering_1_N : N ; -- bogsering..nn.1
  bogserlina_1_N : N ; -- bogserlina..nn.1
  bogsersläp_1_N : N ; -- bogsersläp..nn.1
  bogsertross_1_N : N ; -- bogsertross..nn.1
  bogspröt_1_N : N ; -- bogspröt..nn.1
  bogvisir_1_N : N ; -- bogvisir..nn.1
  bogvåg_1_N : N ; -- bogvåg..nn.1
  bogvågsknall_1_N : N ; -- bogvågsknall..nn.1
  bohag_1_N : N ; -- bohag..nn.1
  bohagsförteckning_1_N : N ; -- bohagsförteckning..nn.1
  bohem_1_N : N ; -- bohem..nn.1
  bohemartad_1_A : A ; -- bohemartad..av.1
  bohemisk_1_A : A ; -- bohemisk..av.1
  bohemliv_1_N : N ; -- bohemliv..nn.1
  bohuseka_1_N : N ; -- bohuseka..nn.1
  bohusläning_1_N : N ; -- bohusläning..nn.1
  bohuslänning_1_N : N ; -- bohuslänning..nn.1
  bohuslänsk_1_A : A ; -- bohuslänsk..av.1
  bohuslänska_1_N : N ; -- bohuslänska..nn.1
  bohuslänska_2_N : N ; -- bohuslänska..nn.2
  boj_1_N : N ; -- boj..nn.1
  boj_2_N : N ; -- boj..nn.2
  boja_1_N : N ; -- boja..nn.1
  bojar_1_N : N ; -- bojar..nn.1
  bojkott_1_N : N ; -- bojkott..nn.1
  bojkotta_1_V : V ; -- bojkotta..vb.1
  bojkottande_1_N : N ; -- bojkottande..nn.1
  bojkottning_1_N : N ; -- bojkottning..nn.1
  bok_1_N : N ; -- bok..nn.1
  bok_2_N : N ; -- bok..nn.2
  boka_1_V : V ; -- boka..vb.1
  bokande_1_N : N ; -- bokande..nn.1
  bokanmälan_1_N : N ; -- bokanmälan..nn.1
  bokauktion_1_N : N ; -- bokauktion..nn.1
  bokband_1_N : N ; -- bokband..nn.1
  bokbindare_1_N : N ; -- bokbindare..nn.1
  bokbinderi_1_N : N ; -- bokbinderi..nn.1
  bokbindning_1_N : N ; -- bokbindning..nn.1
  bokbränning_1_N : N ; -- bokbränning..nn.1
  bokbuss_1_N : N ; -- bokbuss..nn.1
  bokcirkel_1_N : N ; -- bokcirkel..nn.1
  bokdamm_1_N : N ; -- bokdamm..nn.1
  boke_1_N : N ; -- boke..nn.1
  boken_1_A : A ; -- boken..av.1
  bokenhet_1_N : N ; -- bokenhet..nn.1
  bokfilm_1_N : N ; -- bokfilm..nn.1
  bokflod_1_N : N ; -- bokflod..nn.1
  bokform_1_N : N ; -- bokform..nn.1
  bokformat_1_N : N ; -- bokformat..nn.1
  bokföra_1_V : V ; -- bokföra..vb.1
  bokförande_1_N : N ; -- bokförande..nn.1
  bokförare_1_N : N ; -- bokförare..nn.1
  bokföring_1_N : N ; -- bokföring..nn.1
  bokföringsbrott_1_N : N ; -- bokföringsbrott..nn.1
  bokföringsmässig_1_A : A ; -- bokföringsmässig..av.1
  bokföringsmässighet_1_N : N ; -- bokföringsmässighet..nn.1
  bokföringsplikt_1_N : N ; -- bokföringsplikt..nn.1
  bokföringsskyldig_1_A : A ; -- bokföringsskyldig..av.1
  bokföringsskyldighet_1_N : N ; -- bokföringsskyldighet..nn.1
  bokföringsår_1_N : N ; -- bokföringsår..nn.1
  bokförlag_1_N : N ; -- bokförlag..nn.1
  bokförläggare_1_N : N ; -- bokförläggare..nn.1
  bokförråd_1_N : N ; -- bokförråd..nn.1
  bokhandel_1_N : N ; -- bokhandel..nn.1
  bokhandelsdisk_1_N : N ; -- bokhandelsdisk..nn.1
  bokhandlare_1_N : N ; -- bokhandlare..nn.1
  bokhantverk_1_N : N ; -- bokhantverk..nn.1
  bokhylla_1_N : N ; -- bokhylla..nn.1
  bokhållare_1_N : N ; -- bokhållare..nn.1
  bokhålleri_1_N : N ; -- bokhålleri..nn.1
  bokkasse_1_N : N ; -- bokkasse..nn.1
  bokkatalog_1_N : N ; -- bokkatalog..nn.1
  bokklubb_1_N : N ; -- bokklubb..nn.1
  bokkännare_1_N : N ; -- bokkännare..nn.1
  boklig_1_A : A ; -- boklig..av.1
  boklighet_1_N : N ; -- boklighet..nn.1
  boklärd_1_A : A ; -- boklärd..av.1
  boklärdhet_1_N : N ; -- boklärdhet..nn.1
  boklärdom_1_N : N ; -- boklärdom..nn.1
  bokläsande_1_A : A ; -- bokläsande..av.1
  bokläsande_1_N : N ; -- bokläsande..nn.1
  boklåda_1_N : N ; -- boklåda..nn.1
  boklån_1_N : N ; -- boklån..nn.1
  bokmagasin_1_N : N ; -- bokmagasin..nn.1
  bokmakulatur_1_N : N ; -- bokmakulatur..nn.1
  bokmal_1_N : N ; -- bokmal..nn.1
  bokmarknad_1_N : N ; -- bokmarknad..nn.1
  bokmärke_1_N : N ; -- bokmärke..nn.1
  bokmässa_1_N : N ; -- bokmässa..nn.1
  bokmål_1_N : N ; -- bokmål..nn.1
  bokna_1_V : V ; -- bokna..vb.1
  boknande_1_N : N ; -- boknande..nn.1
  bokning_1_N : N ; -- bokning..nn.1
  bokollon_1_N : N ; -- bokollon..nn.1
  bokomslag_1_N : N ; -- bokomslag..nn.1
  bokpärm_1_N : N ; -- bokpärm..nn.1
  bokrad_1_N : N ; -- bokrad..nn.1
  bokrea_1_N : N ; -- bokrea..nn.1
  bokrulle_1_N : N ; -- bokrulle..nn.1
  bokrygg_1_N : N ; -- bokrygg..nn.1
  boksamlare_1_N : N ; -- boksamlare..nn.1
  boksamling_1_N : N ; -- boksamling..nn.1
  boksida_1_N : N ; -- boksida..nn.1
  bokskatt_1_N : N ; -- bokskatt..nn.1
  bokskog_1_N : N ; -- bokskog..nn.1
  bokskrivande_1_A : A ; -- bokskrivande..av.1
  bokskrivande_1_N : N ; -- bokskrivande..nn.1
  bokskåp_1_N : N ; -- bokskåp..nn.1
  bokslukare_1_N : N ; -- bokslukare..nn.1
  bokslut_1_N : N ; -- bokslut..nn.1
  bokspråk_1_N : N ; -- bokspråk..nn.1
  bokstav_1_N : N ; -- bokstav..nn.1
  bokstavera_1_V : V ; -- bokstavera..vb.1
  bokstaverande_1_N : N ; -- bokstaverande..nn.1
  bokstaverbar_1_A : A ; -- bokstaverbar..av.1
  bokstaverbarhet_1_N : N ; -- bokstaverbarhet..nn.1
  bokstavering_1_N : N ; -- bokstavering..nn.1
  bokstavlig_1_A : A ; -- bokstavlig..av.1
  bokstavligen_1_Adv : Adv ; -- bokstavligen..ab.1
  bokstavlighet_1_N : N ; -- bokstavlighet..nn.1
  bokstavsbarn_1_N : N ; -- bokstavsbarn..nn.1
  bokstavsbeteckning_1_N : N ; -- bokstavsbeteckning..nn.1
  bokstavsdiagnos_1_N : N ; -- bokstavsdiagnos..nn.1
  bokstavsföljd_1_N : N ; -- bokstavsföljd..nn.1
  bokstavsinspiration_1_N : N ; -- bokstavsinspiration..nn.1
  bokstavsmystik_1_N : N ; -- bokstavsmystik..nn.1
  bokstavsordning_1_N : N ; -- bokstavsordning..nn.1
  bokstavsrim_1_N : N ; -- bokstavsrim..nn.1
  bokstavssallad_1_N : N ; -- bokstavssallad..nn.1
  bokstavsskrift_1_N : N ; -- bokstavsskrift..nn.1
  bokstavsstans_1_N : N ; -- bokstavsstans..nn.1
  bokstavstecken_1_N : N ; -- bokstavstecken..nn.1
  bokstavstro_1_N : N ; -- bokstavstro..nn.1
  bokstavstrogen_1_A : A ; -- bokstavstrogen..av.1
  bokstavstrogenhet_1_N : N ; -- bokstavstrogenhet..nn.1
  bokstavsträl_1_N : N ; -- bokstavsträl..nn.1
  bokstavsvuxen_1_A : A ; -- bokstavsvuxen..av.1
  bokstipendium_1_N : N ; -- bokstipendium..nn.1
  bokställ_1_N : N ; -- bokställ..nn.1
  bokstöd_1_N : N ; -- bokstöd..nn.1
  boksynt_1_A : A ; -- boksynt..av.1
  boksynthet_1_N : N ; -- boksynthet..nn.1
  boktitel_1_N : N ; -- boktitel..nn.1
  boktorn_1_N : N ; -- boktorn..nn.1
  boktrave_1_N : N ; -- boktrave..nn.1
  boktryck_1_N : N ; -- boktryck..nn.1
  boktryckare_1_N : N ; -- boktryckare..nn.1
  boktryckarkonst_1_N : N ; -- boktryckarkonst..nn.1
  boktryckeri_1_N : N ; -- boktryckeri..nn.1
  boktrycksstil_1_N : N ; -- boktrycksstil..nn.1
  bokuppslag_1_N : N ; -- bokuppslag..nn.1
  bokval_1_N : N ; -- bokval..nn.1
  bokverk_1_N : N ; -- bokverk..nn.1
  bokversion_1_N : N ; -- bokversion..nn.1
  bokvurm_1_N : N ; -- bokvurm..nn.1
  bokvän_1_N : N ; -- bokvän..nn.1
  bokälskare_1_N : N ; -- bokälskare..nn.1
  bol_1_N : N ; -- bol..nn.1
  bola_1_V : V ; -- bola..vb.1
  bolag_1_N : N ; -- bolag..nn.1
  bolagisera_1_V : V ; -- bolagisera..vb.1
  bolagiserande_1_N : N ; -- bolagiserande..nn.1
  bolagiserbar_1_A : A ; -- bolagiserbar..av.1
  bolagisering_1_N : N ; -- bolagisering..nn.1
  bolagsman_1_N : N ; -- bolagsman..nn.1
  bolagsordning_1_N : N ; -- bolagsordning..nn.1
  bolagsskog_1_N : N ; -- bolagsskog..nn.1
  bolagsstyrelse_1_N : N ; -- bolagsstyrelse..nn.1
  bolagsstämma_1_N : N ; -- bolagsstämma..nn.1
  bolagsägare_1_N : N ; -- bolagsägare..nn.1
  bolande_1_N : N ; -- bolande..nn.1
  bolare_1_N : N ; -- bolare..nn.1
  boleri_1_N : N ; -- boleri..nn.1
  bolero_1_N : N ; -- bolero..nn.1
  bolid_1_N : N ; -- bolid..nn.1
  bolin_1_N : N ; -- bolin..nn.1
  bolivian_1_N : N ; -- bolivian..nn.1
  boliviansk_1_A : A ; -- boliviansk..av.1
  bolivianska_1_N : N ; -- bolivianska..nn.1
  boll_1_N : N ; -- boll..nn.1
  bolla_1_V : V ; -- bolla..vb.1
  bollande_1_N : N ; -- bollande..nn.1
  bollbehandling_1_N : N ; -- bollbehandling..nn.1
  bollhav_1_N : N ; -- bollhav..nn.1
  bollhus_1_N : N ; -- bollhus..nn.1
  bollkalle_1_N : N ; -- bollkalle..nn.1
  bollkastning_1_N : N ; -- bollkastning..nn.1
  bollning_1_N : N ; -- bollning..nn.1
  bollplan_1_N : N ; -- bollplan..nn.1
  bollplank_1_N : N ; -- bollplank..nn.1
  bollpojke_1_N : N ; -- bollpojke..nn.1
  bollsinne_1_N : N ; -- bollsinne..nn.1
  bollspel_1_N : N ; -- bollspel..nn.1
  bollspelare_1_N : N ; -- bollspelare..nn.1
  bollträ_1_N : N ; -- bollträ..nn.1
  bolma_1_V : V ; -- bolma..vb.1
  bolmande_1_N : N ; -- bolmande..nn.1
  bolmört_1_N : N ; -- bolmört..nn.1
  bolmörtsgift_1_N : N ; -- bolmörtsgift..nn.1
  bolmörtsskivling_1_N : N ; -- bolmörtsskivling..nn.1
  bolsjevik_1_N : N ; -- bolsjevik..nn.1
  bolsjevikisk_1_A : A ; -- bolsjevikisk..av.1
  bolsjevism_1_N : N ; -- bolsjevism..nn.1
  bolsjevistisk_1_A : A ; -- bolsjevistisk..av.1
  bolster_1_N : N ; -- bolster..nn.1
  bolsterstock_1_N : N ; -- bolsterstock..nn.1
  bolstervagn_1_N : N ; -- bolstervagn..nn.1
  bolstervar_1_N : N ; -- bolstervar..nn.1
  bolån_1_N : N ; -- bolån..nn.1
  bolånekris_1_N : N ; -- bolånekris..nn.1
  bolånekund_1_N : N ; -- bolånekund..nn.1
  bolåneränta_1_N : N ; -- bolåneränta..nn.1
  bom_1_N : N ; -- bom..nn.1
  bomaterial_1_N : N ; -- bomaterial..nn.1
  bomb_1_N : N ; -- bomb..nn.1
  bomba_1_V : V ; -- bomba..vb.1
  bombad_1_A : A ; -- bombad..av.1
  bombande_1_N : N ; -- bombande..nn.1
  bombanfall_1_N : N ; -- bombanfall..nn.1
  bombardemang_1_N : N ; -- bombardemang..nn.1
  bombardera_1_V : V ; -- bombardera..vb.1
  bombarderande_1_N : N ; -- bombarderande..nn.1
  bombarderbar_1_A : A ; -- bombarderbar..av.1
  bombarderbarhet_1_N : N ; -- bombarderbarhet..nn.1
  bombardering_1_N : N ; -- bombardering..nn.1
  bombare_1_N : N ; -- bombare..nn.1
  bombasm_1_N : N ; -- bombasm..nn.1
  bombastisk_1_A : A ; -- bombastisk..av.1
  bombattack_1_N : N ; -- bombattack..nn.1
  bombattentat_1_N : N ; -- bombattentat..nn.1
  bombdåd_1_N : N ; -- bombdåd..nn.1
  bombering_1_N : N ; -- bombering..nn.1
  bombfast_1_A : A ; -- bombfast..av.1
  bombfasthet_1_N : N ; -- bombfasthet..nn.1
  bombflyg_1_N : N ; -- bombflyg..nn.1
  bombfri_1_A : A ; -- bombfri..av.1
  bombfällning_1_N : N ; -- bombfällning..nn.1
  bombhot_1_N : N ; -- bombhot..nn.1
  bombkrater_1_N : N ; -- bombkrater..nn.1
  bombkrig_1_N : N ; -- bombkrig..nn.1
  bomblarm_1_N : N ; -- bomblarm..nn.1
  bombman_1_N : N ; -- bombman..nn.1
  bombmatta_1_N : N ; -- bombmatta..nn.1
  bombnedslag_1_N : N ; -- bombnedslag..nn.1
  bombning_1_N : N ; -- bombning..nn.1
  bomboffer_1_N : N ; -- bomboffer..nn.1
  bombplan_1_N : N ; -- bombplan..nn.1
  bombraid_1_N : N ; -- bombraid..nn.1
  bombräd_1_N : N ; -- bombräd..nn.1
  bombsikte_1_N : N ; -- bombsikte..nn.1
  bombskydd_1_N : N ; -- bombskydd..nn.1
  bombskyddssektion_1_N : N ; -- bombskyddssektion..nn.1
  bombsplitter_1_N : N ; -- bombsplitter..nn.1
  bombsäker_1_A : A ; -- bombsäker..av.1
  bombsäkerhet_1_N : N ; -- bombsäkerhet..nn.1
  bombtillverkning_1_N : N ; -- bombtillverkning..nn.1
  bomcylinder_1_N : N ; -- bomcylinder..nn.1
  bomma_1_V : V ; -- bomma..vb.1
  bommande_1_N : N ; -- bommande..nn.1
  bomolja_1_N : N ; -- bomolja..nn.1
  bomsadel_1_N : N ; -- bomsadel..nn.1
  bomsegel_1_N : N ; -- bomsegel..nn.1
  bomskott_1_N : N ; -- bomskott..nn.1
  bomull_1_N : N ; -- bomull..nn.1
  bomullsbal_1_N : N ; -- bomullsbal..nn.1
  bomullsband_1_N : N ; -- bomullsband..nn.1
  bomullsbuske_1_N : N ; -- bomullsbuske..nn.1
  bomullsflanell_1_N : N ; -- bomullsflanell..nn.1
  bomullsfrö_1_N : N ; -- bomullsfrö..nn.1
  bomullsfrökaka_1_N : N ; -- bomullsfrökaka..nn.1
  bomullsfröolja_1_N : N ; -- bomullsfröolja..nn.1
  bomullsgarn_1_N : N ; -- bomullsgarn..nn.1
  bomullsklänning_1_N : N ; -- bomullsklänning..nn.1
  bomullskrut_1_N : N ; -- bomullskrut..nn.1
  bomullspinne_1_N : N ; -- bomullspinne..nn.1
  bomullsplantage_1_N : N ; -- bomullsplantage..nn.1
  bomullsplockare_1_N : N ; -- bomullsplockare..nn.1
  bomullsservett_1_N : N ; -- bomullsservett..nn.1
  bomullsskjorta_1_N : N ; -- bomullsskjorta..nn.1
  bomullsspinneri_1_N : N ; -- bomullsspinneri..nn.1
  bomullsstrumpa_1_N : N ; -- bomullsstrumpa..nn.1
  bomullstops_1_N : N ; -- bomullstops..nn.1
  bomullstrassel_1_N : N ; -- bomullstrassel..nn.1
  bomullstrikå_1_N : N ; -- bomullstrikå..nn.1
  bomullstråd_1_N : N ; -- bomullstråd..nn.1
  bomullstuss_1_N : N ; -- bomullstuss..nn.1
  bomullstyg_1_N : N ; -- bomullstyg..nn.1
  bomullsväv_1_N : N ; -- bomullsväv..nn.1
  bomullsvävnad_1_N : N ; -- bomullsvävnad..nn.1
  bomullsväxt_1_N : N ; -- bomullsväxt..nn.1
  bomärke_1_N : N ; -- bomärke..nn.1
  bona_1_V : V ; -- bona..vb.1
  bonad_1_N : N ; -- bonad..nn.1
  bonande_1_N : N ; -- bonande..nn.1
  bonbonjär_1_N : N ; -- bonbonjär..nn.1
  bondage_1_N : N ; -- bondage..nn.1
  bondaktig_1_A : A ; -- bondaktig..av.1
  bondaktighet_1_N : N ; -- bondaktighet..nn.1
  bondbrud_1_N : N ; -- bondbrud..nn.1
  bondböna_1_N : N ; -- bondböna..nn.1
  bonddryg_1_A : A ; -- bonddryg..av.1
  bonddryghet_1_N : N ; -- bonddryghet..nn.1
  bonddräng_1_N : N ; -- bonddräng..nn.1
  bonde_1_N : N ; -- bonde..nn.1
  bondearmé_1_N : N ; -- bondearmé..nn.1
  bondebefolkning_1_N : N ; -- bondebefolkning..nn.1
  bondefred_1_N : N ; -- bondefred..nn.1
  bondegeneration_1_N : N ; -- bondegeneration..nn.1
  bondehemman_1_N : N ; -- bondehemman..nn.1
  bondehär_1_N : N ; -- bondehär..nn.1
  bondekultur_1_N : N ; -- bondekultur..nn.1
  bondenostalgi_1_N : N ; -- bondenostalgi..nn.1
  bondenostalgisk_1_A : A ; -- bondenostalgisk..av.1
  bondepraktika_1_N : N ; -- bondepraktika..nn.1
  bondeprotest_1_N : N ; -- bondeprotest..nn.1
  bondesamhälle_1_N : N ; -- bondesamhälle..nn.1
  bondesjäl_1_N : N ; -- bondesjäl..nn.1
  bondeskog_1_N : N ; -- bondeskog..nn.1
  bondesläkt_1_N : N ; -- bondesläkt..nn.1
  bondestånd_1_N : N ; -- bondestånd..nn.1
  bondetåg_1_N : N ; -- bondetåg..nn.1
  bondeuppbåd_1_N : N ; -- bondeuppbåd..nn.1
  bondeuppror_1_N : N ; -- bondeuppror..nn.1
  bondfamilj_1_N : N ; -- bondfamilj..nn.1
  bondflicka_1_N : N ; -- bondflicka..nn.1
  bondfolk_1_N : N ; -- bondfolk..nn.1
  bondfångare_1_N : N ; -- bondfångare..nn.1
  bondförnuft_1_N : N ; -- bondförnuft..nn.1
  bondförstånd_1_N : N ; -- bondförstånd..nn.1
  bondförsök_1_N : N ; -- bondförsök..nn.1
  bondgumma_1_N : N ; -- bondgumma..nn.1
  bondgård_1_N : N ; -- bondgård..nn.1
  bondhustru_1_N : N ; -- bondhustru..nn.1
  bondkalas_1_N : N ; -- bondkalas..nn.1
  bondkatt_1_N : N ; -- bondkatt..nn.1
  bondkomik_1_N : N ; -- bondkomik..nn.1
  bondkomiker_1_N : N ; -- bondkomiker..nn.1
  bondland_1_N : N ; -- bondland..nn.1
  bondlurk_1_N : N ; -- bondlurk..nn.1
  bondläpp_1_N : N ; -- bondläpp..nn.1
  bondmora_1_N : N ; -- bondmora..nn.1
  bondneka_1_V : V ; -- bondneka..vb.1
  bondnekande_1_N : N ; -- bondnekande..nn.1
  bondpermis_1_N : N ; -- bondpermis..nn.1
  bondpermission_1_N : N ; -- bondpermission..nn.1
  bondpolska_1_N : N ; -- bondpolska..nn.1
  bondsk_1_A : A ; -- bondsk..av.1
  bondska_1_N : N ; -- bondska..nn.1
  bondskhet_1_N : N ; -- bondskhet..nn.1
  bondslug_1_A : A ; -- bondslug..av.1
  bondslughet_1_N : N ; -- bondslughet..nn.1
  bondspelman_1_N : N ; -- bondspelman..nn.1
  bondstuga_1_N : N ; -- bondstuga..nn.1
  bondtolva_1_N : N ; -- bondtolva..nn.1
  bondtur_1_N : N ; -- bondtur..nn.1
  bondtölp_1_N : N ; -- bondtölp..nn.1
  bondvischa_1_N : N ; -- bondvischa..nn.1
  bondånger_1_N : N ; -- bondånger..nn.1
  bong_1_N : N ; -- bong..nn.1
  bonga_1_V : V ; -- bonga..vb.1
  bongande_1_N : N ; -- bongande..nn.1
  bongotrumma_1_N : N ; -- bongotrumma..nn.1
  boning_1_N : N ; -- boning..nn.1
  boningshus_1_N : N ; -- boningshus..nn.1
  boningsort_1_N : N ; -- boningsort..nn.1
  boningsplats_1_N : N ; -- boningsplats..nn.1
  boningsrum_1_N : N ; -- boningsrum..nn.1
  bonitera_1_V : V ; -- bonitera..vb.1
  boniterande_1_N : N ; -- boniterande..nn.1
  boniterbar_1_A : A ; -- boniterbar..av.1
  boniterbarhet_1_N : N ; -- boniterbarhet..nn.1
  bonitering_1_N : N ; -- bonitering..nn.1
  bonitet_1_N : N ; -- bonitet..nn.1
  bonjour_1_N : N ; -- bonjour..nn.1
  bonmot_1_N : N ; -- bonmot..nn.1
  bonnett_1_N : N ; -- bonnett..nn.1
  bonnig_1_A : A ; -- bonnig..av.1
  bonnläpp_1_N : N ; -- bonnläpp..nn.1
  bonobo_1_N : N ; -- bonobo..nn.1
  bonus_1_N : N ; -- bonus..nn.1
  bonusbarn_1_N : N ; -- bonusbarn..nn.1
  bonusklass_1_N : N ; -- bonusklass..nn.1
  bonusregel_1_N : N ; -- bonusregel..nn.1
  bonussystem_1_N : N ; -- bonussystem..nn.1
  bonvax_1_N : N ; -- bonvax..nn.1
  bookmaker_1_N : N ; -- bookmaker..nn.1
  boom_1_N : N ; -- boom..nn.1
  booma_1_V : V ; -- booma..vb.1
  boomande_1_N : N ; -- boomande..nn.1
  boomår_1_N : N ; -- boomår..nn.1
  boosta_1_V : V ; -- boosta..vb.1
  boostande_1_N : N ; -- boostande..nn.1
  boostning_1_N : N ; -- boostning..nn.1
  boota_1_V : V ; -- boota..vb.1
  boparasit_1_N : N ; -- boparasit..nn.1
  boplats_1_N : N ; -- boplats..nn.1
  boplatsgrävning_1_N : N ; -- boplatsgrävning..nn.1
  bopris_1_N : N ; -- bopris..nn.1
  boprisbubbla_1_N : N ; -- boprisbubbla..nn.1
  bor_1_N : N ; -- bor..nn.1
  borax_1_N : N ; -- borax..nn.1
  bord_1_N : N ; -- bord..nn.1
  borda_1_V : V ; -- borda..vb.1
  bordande_1_N : N ; -- bordande..nn.1
  borddans_1_N : N ; -- borddans..nn.1
  bordduk_1_N : N ; -- bordduk..nn.1
  bordeaux_1_N : N ; -- bordeaux..nn.1
  bordeauxvin_1_N : N ; -- bordeauxvin..nn.1
  bordeauxvätska_1_N : N ; -- bordeauxvätska..nn.1
  bordell_1_N : N ; -- bordell..nn.1
  bordellverksamhet_1_N : N ; -- bordellverksamhet..nn.1
  bordellvärd_1_N : N ; -- bordellvärd..nn.1
  bordgång_1_N : N ; -- bordgång..nn.1
  bordhyvel_1_N : N ; -- bordhyvel..nn.1
  bordlägga_1_V : V ; -- bordlägga..vb.1
  bordläggande_1_N : N ; -- bordläggande..nn.1
  bordläggning_1_N : N ; -- bordläggning..nn.1
  bordläggningsplenum_1_N : N ; -- bordläggningsplenum..nn.1
  bordlöpare_1_N : N ; -- bordlöpare..nn.1
  bordning_1_N : N ; -- bordning..nn.1
  bordplanka_1_N : N ; -- bordplanka..nn.1
  bordsamtal_1_N : N ; -- bordsamtal..nn.1
  bordsben_1_N : N ; -- bordsben..nn.1
  bordsbeställning_1_N : N ; -- bordsbeställning..nn.1
  bordsbön_1_N : N ; -- bordsbön..nn.1
  bordsdam_1_N : N ; -- bordsdam..nn.1
  bordsdryck_1_N : N ; -- bordsdryck..nn.1
  bordservis_1_N : N ; -- bordservis..nn.1
  bordsfilt_1_N : N ; -- bordsfilt..nn.1
  bordsgranne_1_N : N ; -- bordsgranne..nn.1
  bordsgäst_1_N : N ; -- bordsgäst..nn.1
  bordsilver_1_N : N ; -- bordsilver..nn.1
  bordskamrat_1_N : N ; -- bordskamrat..nn.1
  bordskant_1_N : N ; -- bordskant..nn.1
  bordskavaljer_1_N : N ; -- bordskavaljer..nn.1
  bordskick_1_N : N ; -- bordskick..nn.1
  bordskiva_1_N : N ; -- bordskiva..nn.1
  bordskniv_1_N : N ; -- bordskniv..nn.1
  bordskrydda_1_N : N ; -- bordskrydda..nn.1
  bordslampa_1_N : N ; -- bordslampa..nn.1
  bordslinne_1_N : N ; -- bordslinne..nn.1
  bordsmargarin_1_N : N ; -- bordsmargarin..nn.1
  bordssalt_1_N : N ; -- bordssalt..nn.1
  bordssamtal_1_N : N ; -- bordssamtal..nn.1
  bordsservis_1_N : N ; -- bordsservis..nn.1
  bordssilver_1_N : N ; -- bordssilver..nn.1
  bordsskick_1_N : N ; -- bordsskick..nn.1
  bordsskiva_1_N : N ; -- bordsskiva..nn.1
  bordsspegel_1_N : N ; -- bordsspegel..nn.1
  bordsstudsare_1_N : N ; -- bordsstudsare..nn.1
  bordsställ_1_N : N ; -- bordsställ..nn.1
  bordssällskap_1_N : N ; -- bordssällskap..nn.1
  bordstudsare_1_N : N ; -- bordstudsare..nn.1
  bordsuppsats_1_N : N ; -- bordsuppsats..nn.1
  bordsvatten_1_N : N ; -- bordsvatten..nn.1
  bordsvin_1_N : N ; -- bordsvin..nn.1
  bordsvisa_1_N : N ; -- bordsvisa..nn.1
  bordtennis_1_N : N ; -- bordtennis..nn.1
  bordtennisbord_1_N : N ; -- bordtennisbord..nn.1
  bordtennisrack_1_N : N ; -- bordtennisrack..nn.1
  bordtennisracket_1_N : N ; -- bordtennisracket..nn.1
  bordvisa_1_N : N ; -- bordvisa..nn.1
  boreal_1_A : A ; -- boreal..av.1
  boren_1_A : A ; -- boren..av.1
  borg_1_N : N ; -- borg..nn.1
  borga_1_V : V ; -- borga..vb.1
  borgande_1_N : N ; -- borgande..nn.1
  borgaras_1_N : N ; -- borgaras..nn.1
  borgarbeväpning_1_N : N ; -- borgarbeväpning..nn.1
  borgarbrev_1_N : N ; -- borgarbrev..nn.1
  borgardöme_1_N : N ; -- borgardöme..nn.1
  borgare_1_N : N ; -- borgare..nn.1
  borgarfamilj_1_N : N ; -- borgarfamilj..nn.1
  borgargarde_1_N : N ; -- borgargarde..nn.1
  borgarhus_1_N : N ; -- borgarhus..nn.1
  borgarklass_1_N : N ; -- borgarklass..nn.1
  borgarpress_1_N : N ; -- borgarpress..nn.1
  borgarråd_1_N : N ; -- borgarråd..nn.1
  borgarskola_1_N : N ; -- borgarskola..nn.1
  borgarsläkt_1_N : N ; -- borgarsläkt..nn.1
  borgarstånd_1_N : N ; -- borgarstånd..nn.1
  borgensförbindelse_1_N : N ; -- borgensförbindelse..nn.1
  borgenslån_1_N : N ; -- borgenslån..nn.1
  borgensman_1_N : N ; -- borgensman..nn.1
  borgenssumma_1_N : N ; -- borgenssumma..nn.1
  borgensåtagande_1_N : N ; -- borgensåtagande..nn.1
  borgenär_1_N : N ; -- borgenär..nn.1
  borgenärsed_1_N : N ; -- borgenärsed..nn.1
  borgerlig_1_A : A ; -- borgerlig..av.1
  borgerlighet_1_N : N ; -- borgerlighet..nn.1
  borgerlighet_2_N : N ; -- borgerlighet..nn.2
  borgerskap_1_N : N ; -- borgerskap..nn.1
  borgfred_1_N : N ; -- borgfred..nn.1
  borggård_1_N : N ; -- borggård..nn.1
  borgis_1_N : N ; -- borgis..nn.1
  borgmästare_1_N : N ; -- borgmästare..nn.1
  borgruin_1_N : N ; -- borgruin..nn.1
  borgtorn_1_N : N ; -- borgtorn..nn.1
  boricka_1_N : N ; -- boricka..nn.1
  borkarbid_1_N : N ; -- borkarbid..nn.1
  bornera_1_V : V ; -- bornera..vb.1
  bornerad_1_A : A ; -- bornerad..av.1
  bornerande_1_N : N ; -- bornerande..nn.1
  bornering_1_N : N ; -- bornering..nn.1
  bornyr_1_N : N ; -- bornyr..nn.1
  borr_1_N : N ; -- borr..nn.1
  borr_2_N : N ; -- borr..nn.2
  borra_1_V : V ; -- borra..vb.1
  borrande_1_N : N ; -- borrande..nn.1
  borrchuck_1_N : N ; -- borrchuck..nn.1
  borrdiameter_1_N : N ; -- borrdiameter..nn.1
  borrelia_1_N : N ; -- borrelia..nn.1
  borreliavaccin_1_N : N ; -- borreliavaccin..nn.1
  borrhammare_1_N : N ; -- borrhammare..nn.1
  borrhål_1_N : N ; -- borrhål..nn.1
  borrhålsvägg_1_N : N ; -- borrhålsvägg..nn.1
  borrigg_1_N : N ; -- borrigg..nn.1
  borrjigg_1_N : N ; -- borrjigg..nn.1
  borrklinka_1_N : N ; -- borrklinka..nn.1
  borrkrona_1_N : N ; -- borrkrona..nn.1
  borrkärna_1_N : N ; -- borrkärna..nn.1
  borrlängd_1_N : N ; -- borrlängd..nn.1
  borrmaskin_1_N : N ; -- borrmaskin..nn.1
  borrmussla_1_N : N ; -- borrmussla..nn.1
  borrning_1_N : N ; -- borrning..nn.1
  borrningsolycka_1_N : N ; -- borrningsolycka..nn.1
  borrplattform_1_N : N ; -- borrplattform..nn.1
  borrspindel_1_N : N ; -- borrspindel..nn.1
  borrspån_1_N : N ; -- borrspån..nn.1
  borrstål_1_N : N ; -- borrstål..nn.1
  borrsväng_1_N : N ; -- borrsväng..nn.1
  borrtorn_1_N : N ; -- borrtorn..nn.1
  borrutrustning_1_N : N ; -- borrutrustning..nn.1
  borsjtj_1_N : N ; -- borsjtj..nn.1
  borst_1_N : N ; -- borst..nn.1
  borsta_1_V : V ; -- borsta..vb.1
  borstande_1_N : N ; -- borstande..nn.1
  borstbindare_1_N : N ; -- borstbindare..nn.1
  borstbinderi_1_N : N ; -- borstbinderi..nn.1
  borste_1_N : N ; -- borste..nn.1
  borstgarnityr_1_N : N ; -- borstgarnityr..nn.1
  borstgräs_1_N : N ; -- borstgräs..nn.1
  borstig_1_A : A ; -- borstig..av.1
  borstighet_1_N : N ; -- borstighet..nn.1
  borstlös_1_A : A ; -- borstlös..av.1
  borstlöshet_1_N : N ; -- borstlöshet..nn.1
  borstmask_1_N : N ; -- borstmask..nn.1
  borstnate_1_N : N ; -- borstnate..nn.1
  borstnejlika_1_N : N ; -- borstnejlika..nn.1
  borstning_1_N : N ; -- borstning..nn.1
  borstsvans_1_N : N ; -- borstsvans..nn.1
  borstviskare_1_N : N ; -- borstviskare..nn.1
  borsyra_1_N : N ; -- borsyra..nn.1
  bortadopterad_1_A : A ; -- bortadopterad..av.1
  bortafiasko_1_N : N ; -- bortafiasko..nn.1
  bortaförlora_1_V : V ; -- bortaförlora..vb.1
  bortaförlust_1_N : N ; -- bortaförlust..nn.1
  bortaförsäkring_1_N : N ; -- bortaförsäkring..nn.1
  bortalag_1_N : N ; -- bortalag..nn.1
  bortalagad_1_A : A ; -- bortalagad..av.1
  bortamatch_1_N : N ; -- bortamatch..nn.1
  bortaplan_1_N : N ; -- bortaplan..nn.1
  bortarbeta_1_V : V ; -- bortarbeta..vb.1
  bortarbetande_1_N : N ; -- bortarbetande..nn.1
  bortarbetning_1_N : N ; -- bortarbetning..nn.1
  bortarrendering_1_N : N ; -- bortarrendering..nn.1
  bortaseger_1_N : N ; -- bortaseger..nn.1
  bortasegra_1_V : V ; -- bortasegra..vb.1
  bortaspelare_1_N : N ; -- bortaspelare..nn.1
  bortauktionering_1_N : N ; -- bortauktionering..nn.1
  bortavaro_1_N : N ; -- bortavaro..nn.1
  bortavinna_1_V : V ; -- bortavinna..vb.1
  bortavinst_1_N : N ; -- bortavinst..nn.1
  bortbjuden_1_A : A ; -- bortbjuden..av.1
  bortbjudning_1_N : N ; -- bortbjudning..nn.1
  bortblandning_1_N : N ; -- bortblandning..nn.1
  bortblåsning_1_N : N ; -- bortblåsning..nn.1
  bortblåst_1_A : A ; -- bortblåst..av.1
  bortbyting_1_N : N ; -- bortbyting..nn.1
  bortdomna_1_V : V ; -- bortdomna..vb.1
  bortdomnande_1_N : N ; -- bortdomnande..nn.1
  bortdomning_1_N : N ; -- bortdomning..nn.1
  bortdriva_1_V : V ; -- bortdriva..vb.1
  bortdrivande_1_N : N ; -- bortdrivande..nn.1
  bortdrivning_1_N : N ; -- bortdrivning..nn.1
  bortdunstning_1_N : N ; -- bortdunstning..nn.1
  bortdöende_1_A : A ; -- bortdöende..av.1
  bortdömning_1_N : N ; -- bortdömning..nn.1
  borterst_1_Adv : Adv ; -- borterst..ab.1
  bortfall_1_N : N ; -- bortfall..nn.1
  bortfalla_1_V : V ; -- bortfalla..vb.1
  bortfallande_1_N : N ; -- bortfallande..nn.1
  bortflugen_1_A : A ; -- bortflugen..av.1
  bortflyttning_1_N : N ; -- bortflyttning..nn.1
  bortforsla_1_V : V ; -- bortforsla..vb.1
  bortforslande_1_N : N ; -- bortforslande..nn.1
  bortforsling_1_N : N ; -- bortforsling..nn.1
  bortfärd_1_N : N ; -- bortfärd..nn.1
  bortföra_1_V : V ; -- bortföra..vb.1
  bortförande_1_N : N ; -- bortförande..nn.1
  bortförklara_1_V : V ; -- bortförklara..vb.1
  bortförklarande_1_N : N ; -- bortförklarande..nn.1
  bortförklaring_1_N : N ; -- bortförklaring..nn.1
  bortförklaringsteologi_1_N : N ; -- bortförklaringsteologi..nn.1
  bortgivande_1_N : N ; -- bortgivande..nn.1
  bortglömd_1_A : A ; -- bortglömd..av.1
  bortglömdhet_1_N : N ; -- bortglömdhet..nn.1
  bortgå_1_V : V ; -- bortgå..vb.1
  bortgående_1_N : N ; -- bortgående..nn.1
  bortgång_1_N : N ; -- bortgång..nn.1
  bortgången_1_A : A ; -- bortgången..av.1
  bortifrån_1_Adv : Adv ; -- bortifrån..ab.1
  bortkastad_1_A : A ; -- bortkastad..av.1
  bortklippning_1_N : N ; -- bortklippning..nn.1
  bortkollring_1_N : N ; -- bortkollring..nn.1
  bortkommen_1_A : A ; -- bortkommen..av.1
  bortkommenhet_1_N : N ; -- bortkommenhet..nn.1
  bortkörd_1_A : A ; -- bortkörd..av.1
  bortlottning_1_N : N ; -- bortlottning..nn.1
  bortlova_1_V : V ; -- bortlova..vb.1
  bortlovande_1_N : N ; -- bortlovande..nn.1
  bortläggning_1_N : N ; -- bortläggning..nn.1
  bortlåning_1_N : N ; -- bortlåning..nn.1
  bortmarsch_1_N : N ; -- bortmarsch..nn.1
  bortmontera_1_V : V ; -- bortmontera..vb.1
  bortmota_1_V : V ; -- bortmota..vb.1
  bortmotande_1_N : N ; -- bortmotande..nn.1
  bortmotning_1_N : N ; -- bortmotning..nn.1
  bortnötning_1_N : N ; -- bortnötning..nn.1
  bortodling_1_N : N ; -- bortodling..nn.1
  bortoperera_1_V : V ; -- bortoperera..vb.1
  bortopererande_1_N : N ; -- bortopererande..nn.1
  bortovaro_1_N : N ; -- bortovaro..nn.1
  bortplockning_1_N : N ; -- bortplockning..nn.1
  bortplottrande_1_N : N ; -- bortplottrande..nn.1
  bortrakning_1_N : N ; -- bortrakning..nn.1
  bortrationalisera_1_V : V ; -- bortrationalisera..vb.1
  bortrationaliserande_1_N : N ; -- bortrationaliserande..nn.1
  bortrationalisering_1_N : N ; -- bortrationalisering..nn.1
  bortrensning_1_N : N ; -- bortrensning..nn.1
  bortresa_1_N : N ; -- bortresa..nn.1
  bortresonera_1_V : V ; -- bortresonera..vb.1
  bortresonerande_1_N : N ; -- bortresonerande..nn.1
  bortresonerbar_1_A : A ; -- bortresonerbar..av.1
  bortresonerbarhet_1_N : N ; -- bortresonerbarhet..nn.1
  bortresonering_1_N : N ; -- bortresonering..nn.1
  bortrest_1_A : A ; -- bortrest..av.1
  bortresthet_1_N : N ; -- bortresthet..nn.1
  bortrinna_1_V : V ; -- bortrinna..vb.1
  bortrinnande_1_N : N ; -- bortrinnande..nn.1
  bortrivning_1_N : N ; -- bortrivning..nn.1
  bortryckning_1_N : N ; -- bortryckning..nn.1
  bortryckt_1_A : A ; -- bortryckt..av.1
  borträkna_1_V : V ; -- borträkna..vb.1
  borträknande_1_N : N ; -- borträknande..nn.1
  bortröjning_1_N : N ; -- bortröjning..nn.1
  bortröva_1_V : V ; -- bortröva..vb.1
  bortrövande_1_N : N ; -- bortrövande..nn.1
  bortschabblad_1_A : A ; -- bortschabblad..av.1
  bortschackring_1_N : N ; -- bortschackring..nn.1
  bortse_1_V : V ; -- bortse..vb.1
  bortseende_1_N : N ; -- bortseende..nn.1
  bortsida_1_N : N ; -- bortsida..nn.1
  bortskaffa_1_V : V ; -- bortskaffa..vb.1
  bortskaffande_1_N : N ; -- bortskaffande..nn.1
  bortskaffning_1_N : N ; -- bortskaffning..nn.1
  bortskjuten_1_A : A ; -- bortskjuten..av.1
  bortskrapning_1_N : N ; -- bortskrapning..nn.1
  bortskrivning_1_N : N ; -- bortskrivning..nn.1
  bortskrämma_1_V : V ; -- bortskrämma..vb.1
  bortskrämmande_1_N : N ; -- bortskrämmande..nn.1
  bortskrämning_1_N : N ; -- bortskrämning..nn.1
  bortskämd_1_A : A ; -- bortskämd..av.1
  bortskämdhet_1_N : N ; -- bortskämdhet..nn.1
  bortskänka_1_V : V ; -- bortskänka..vb.1
  bortskänkande_1_N : N ; -- bortskänkande..nn.1
  bortskänkning_1_N : N ; -- bortskänkning..nn.1
  bortskärning_1_N : N ; -- bortskärning..nn.1
  bortsköljning_1_N : N ; -- bortsköljning..nn.1
  bortslumpa_1_V : V ; -- bortslumpa..vb.1
  bortslumpande_1_N : N ; -- bortslumpande..nn.1
  bortslumpning_1_N : N ; -- bortslumpning..nn.1
  bortsluta_1_V : V ; -- bortsluta..vb.1
  bortslutande_1_N : N ; -- bortslutande..nn.1
  bortspolning_1_N : N ; -- bortspolning..nn.1
  bortsprängning_1_N : N ; -- bortsprängning..nn.1
  bortstötning_1_N : N ; -- bortstötning..nn.1
  bortsättning_1_N : N ; -- bortsättning..nn.1
  bortta_1_V : V ; -- bortta..vb.1
  borttagande_1_N : N ; -- borttagande..nn.1
  borttagning_1_N : N ; -- borttagning..nn.1
  borttappa_1_V : V ; -- borttappa..vb.1
  borttappad_1_A : A ; -- borttappad..av.1
  borttappande_1_N : N ; -- borttappande..nn.1
  borttorka_1_V : V ; -- borttorka..vb.1
  borttorkande_1_N : N ; -- borttorkande..nn.1
  borttränga_1_V : V ; -- borttränga..vb.1
  bortträngande_1_N : N ; -- bortträngande..nn.1
  bortträngning_1_N : N ; -- bortträngning..nn.1
  borttvagning_1_N : N ; -- borttvagning..nn.1
  borttvättning_1_N : N ; -- borttvättning..nn.1
  bortvikt_1_N : N ; -- bortvikt..nn.1
  bortvräka_1_V : V ; -- bortvräka..vb.1
  bortvräkande_1_N : N ; -- bortvräkande..nn.1
  bortväg_1_N : N ; -- bortväg..nn.1
  bortvältning_1_N : N ; -- bortvältning..nn.1
  bortvältring_1_N : N ; -- bortvältring..nn.1
  bortvänd_1_A : A ; -- bortvänd..av.1
  bortända_1_N : N ; -- bortända..nn.1
  bortände_1_N : N ; -- bortände..nn.1
  bortödsling_1_N : N ; -- bortödsling..nn.1
  bortöver_1_Adv : Adv ; -- bortöver..ab.1
  bosatt_1_A : A ; -- bosatt..av.1
  bosch_1_N : N ; -- bosch..nn.1
  boskap_1_N : N ; -- boskap..nn.1
  boskapsavel_1_N : N ; -- boskapsavel..nn.1
  boskapsdrift_1_N : N ; -- boskapsdrift..nn.1
  boskapsfoder_1_N : N ; -- boskapsfoder..nn.1
  boskapshjord_1_N : N ; -- boskapshjord..nn.1
  boskapsmarknad_1_N : N ; -- boskapsmarknad..nn.1
  boskapspest_1_N : N ; -- boskapspest..nn.1
  boskapsras_1_N : N ; -- boskapsras..nn.1
  boskapsskötande_1_A : A ; -- boskapsskötande..av.1
  boskapsskötare_1_N : N ; -- boskapsskötare..nn.1
  boskapsskötsel_1_N : N ; -- boskapsskötsel..nn.1
  boskapsstock_1_N : N ; -- boskapsstock..nn.1
  boskapsstängsel_1_N : N ; -- boskapsstängsel..nn.1
  boskapstjuv_1_N : N ; -- boskapstjuv..nn.1
  boskapsuppfödning_1_N : N ; -- boskapsuppfödning..nn.1
  boskifte_1_N : N ; -- boskifte..nn.1
  boskillnad_1_N : N ; -- boskillnad..nn.1
  bosniak_1_N : N ; -- bosniak..nn.1
  bosnienkroatisk_1_A : A ; -- bosnienkroatisk..av.1
  bosnienserbisk_1_A : A ; -- bosnienserbisk..av.1
  bosnier_1_N : N ; -- bosnier..nn.1
  bosnisk_1_A : A ; -- bosnisk..av.1
  bosniska_1_N : N ; -- bosniska..nn.1
  boson_1_N : N ; -- boson..nn.1
  boss_1_N : N ; -- boss..nn.1
  boss_2_N : N ; -- boss..nn.2
  bossig_1_A : A ; -- bossig..av.1
  bossighet_1_N : N ; -- bossighet..nn.1
  bossvälde_1_N : N ; -- bossvälde..nn.1
  bostad_1_N : N ; -- bostad..nn.1
  bostadsadress_1_N : N ; -- bostadsadress..nn.1
  bostadsband_1_N : N ; -- bostadsband..nn.1
  bostadsbestånd_1_N : N ; -- bostadsbestånd..nn.1
  bostadsbidrag_1_N : N ; -- bostadsbidrag..nn.1
  bostadsbolag_1_N : N ; -- bostadsbolag..nn.1
  bostadsbrist_1_N : N ; -- bostadsbrist..nn.1
  bostadsbubbla_1_N : N ; -- bostadsbubbla..nn.1
  bostadsbyggande_1_N : N ; -- bostadsbyggande..nn.1
  bostadsexpert_1_N : N ; -- bostadsexpert..nn.1
  bostadsförbättringslån_1_N : N ; -- bostadsförbättringslån..nn.1
  bostadsföretag_1_N : N ; -- bostadsföretag..nn.1
  bostadsförmedling_1_N : N ; -- bostadsförmedling..nn.1
  bostadshus_1_N : N ; -- bostadshus..nn.1
  bostadsinspektion_1_N : N ; -- bostadsinspektion..nn.1
  bostadsklipp_1_N : N ; -- bostadsklipp..nn.1
  bostadskooperation_1_N : N ; -- bostadskooperation..nn.1
  bostadskredit_1_N : N ; -- bostadskredit..nn.1
  bostadskvarter_1_N : N ; -- bostadskvarter..nn.1
  bostadskö_1_N : N ; -- bostadskö..nn.1
  bostadsköp_1_N : N ; -- bostadsköp..nn.1
  bostadslägenhet_1_N : N ; -- bostadslägenhet..nn.1
  bostadslänga_1_N : N ; -- bostadslänga..nn.1
  bostadslån_1_N : N ; -- bostadslån..nn.1
  bostadslös_1_A : A ; -- bostadslös..av.1
  bostadslöshet_1_N : N ; -- bostadslöshet..nn.1
  bostadsmarknad_1_N : N ; -- bostadsmarknad..nn.1
  bostadsmiljö_1_N : N ; -- bostadsmiljö..nn.1
  bostadsmässig_1_A : A ; -- bostadsmässig..av.1
  bostadsnämnd_1_N : N ; -- bostadsnämnd..nn.1
  bostadsområde_1_N : N ; -- bostadsområde..nn.1
  bostadspolitik_1_N : N ; -- bostadspolitik..nn.1
  bostadspolitisk_1_A : A ; -- bostadspolitisk..av.1
  bostadspris_1_N : N ; -- bostadspris..nn.1
  bostadsproduktion_1_N : N ; -- bostadsproduktion..nn.1
  bostadsrätt_1_N : N ; -- bostadsrätt..nn.1
  bostadsrättsförening_1_N : N ; -- bostadsrättsförening..nn.1
  bostadsrättsinnehavare_1_N : N ; -- bostadsrättsinnehavare..nn.1
  bostadsrättspris_1_N : N ; -- bostadsrättspris..nn.1
  bostadssocial_1_A : A ; -- bostadssocial..av.1
  bostadssparande_1_N : N ; -- bostadssparande..nn.1
  bostadsstyrelse_1_N : N ; -- bostadsstyrelse..nn.1
  bostadssökande_1_N : N ; -- bostadssökande..nn.1
  bostadstillägg_1_N : N ; -- bostadstillägg..nn.1
  boston_1_N : N ; -- boston..nn.1
  bostongurka_1_N : N ; -- bostongurka..nn.1
  bostonvals_1_N : N ; -- bostonvals..nn.1
  boställe_1_N : N ; -- boställe..nn.1
  bosättare_1_N : N ; -- bosättare..nn.1
  bosättning_1_N : N ; -- bosättning..nn.1
  bosättningsaffär_1_N : N ; -- bosättningsaffär..nn.1
  bosättningslån_1_N : N ; -- bosättningslån..nn.1
  bosättningsort_1_N : N ; -- bosättningsort..nn.1
  bosättningsstopp_1_N : N ; -- bosättningsstopp..nn.1
  bot_1_N : N ; -- bot..nn.1
  bot_2_N : N ; -- bot..nn.2
  bot_3_N : N ; -- bot..nn.3
  bota_1_V : V ; -- bota..vb.1
  botande_1_N : N ; -- botande..nn.1
  botanik_1_N : N ; -- botanik..nn.1
  botaniker_1_N : N ; -- botaniker..nn.1
  botanikspade_1_N : N ; -- botanikspade..nn.1
  botanisera_1_V : V ; -- botanisera..vb.1
  botaniserande_1_N : N ; -- botaniserande..nn.1
  botanisering_1_N : N ; -- botanisering..nn.1
  botanisk_1_A : A ; -- botanisk..av.1
  botanist_1_N : N ; -- botanist..nn.1
  botanistspade_1_N : N ; -- botanistspade..nn.1
  botbar_1_A : A ; -- botbar..av.1
  botbarhet_1_N : N ; -- botbarhet..nn.1
  botdag_1_N : N ; -- botdag..nn.1
  botemedel_1_N : N ; -- botemedel..nn.1
  botfärdig_1_A : A ; -- botfärdig..av.1
  botfärdighet_1_N : N ; -- botfärdighet..nn.1
  botgörare_1_N : N ; -- botgörare..nn.1
  botgörartåg_1_N : N ; -- botgörartåg..nn.1
  botgörelse_1_N : N ; -- botgörelse..nn.1
  botgöring_1_N : N ; -- botgöring..nn.1
  botlig_1_A : A ; -- botlig..av.1
  botlighet_1_N : N ; -- botlighet..nn.1
  botox_1_N : N ; -- botox..nn.1
  botoxförlamning_1_N : N ; -- botoxförlamning..nn.1
  botswanier_1_N : N ; -- botswanier..nn.1
  botswansk_1_A : A ; -- botswansk..av.1
  botswanska_1_N : N ; -- botswanska..nn.1
  botten_1_A : A ; -- botten..av.1
  botten_1_N : N ; -- botten..nn.1
  bottenavlagring_1_N : N ; -- bottenavlagring..nn.1
  bottenbjälke_1_N : N ; -- bottenbjälke..nn.1
  bottendjur_1_N : N ; -- bottendjur..nn.1
  bottendålig_1_A : A ; -- bottendålig..av.1
  bottendålighet_1_N : N ; -- bottendålighet..nn.1
  bottendöd_1_N : N ; -- bottendöd..nn.1
  bottenfast_1_A : A ; -- bottenfast..av.1
  bottenformation_1_N : N ; -- bottenformation..nn.1
  bottenfrysa_1_V : V ; -- bottenfrysa..vb.1
  bottenfrysande_1_N : N ; -- bottenfrysande..nn.1
  bottenfällning_1_N : N ; -- bottenfällning..nn.1
  bottenfärg_1_N : N ; -- bottenfärg..nn.1
  bottengarn_1_N : N ; -- bottengarn..nn.1
  bottenhederlig_1_A : A ; -- bottenhederlig..av.1
  bottenhederlighet_1_N : N ; -- bottenhederlighet..nn.1
  bottenis_1_N : N ; -- bottenis..nn.1
  bottenkran_1_N : N ; -- bottenkran..nn.1
  bottenkurs_1_N : N ; -- bottenkurs..nn.1
  bottenkvark_1_N : N ; -- bottenkvark..nn.1
  bottenkänning_1_N : N ; -- bottenkänning..nn.1
  bottenlag_1_N : N ; -- bottenlag..nn.1
  bottenlevande_1_A : A ; -- bottenlevande..av.1
  bottenläge_1_N : N ; -- bottenläge..nn.1
  bottenlån_1_N : N ; -- bottenlån..nn.1
  bottenlös_1_A : A ; -- bottenlös..av.1
  bottenlöshet_1_N : N ; -- bottenlöshet..nn.1
  bottenmagnet_1_N : N ; -- bottenmagnet..nn.1
  bottenmorän_1_N : N ; -- bottenmorän..nn.1
  bottennapp_1_N : N ; -- bottennapp..nn.1
  bottenplan_1_N : N ; -- bottenplan..nn.1
  bottenplatta_1_N : N ; -- bottenplatta..nn.1
  bottenrekord_1_N : N ; -- bottenrekord..nn.1
  bottenrev_1_N : N ; -- bottenrev..nn.1
  bottenreva_1_V : V ; -- bottenreva..vb.1
  bottenrevande_1_N : N ; -- bottenrevande..nn.1
  bottensats_1_N : N ; -- bottensats..nn.1
  bottensediment_1_N : N ; -- bottensediment..nn.1
  bottenskikt_1_N : N ; -- bottenskikt..nn.1
  bottenskola_1_N : N ; -- bottenskola..nn.1
  bottenskrap_1_N : N ; -- bottenskrap..nn.1
  bottenskrapa_1_N : N ; -- bottenskrapa..nn.1
  bottenskrapa_1_V : V ; -- bottenskrapa..vb.1
  bottenskrapande_1_N : N ; -- bottenskrapande..nn.1
  bottenskvätt_1_N : N ; -- bottenskvätt..nn.1
  bottenskyla_1_N : N ; -- bottenskyla..nn.1
  bottenstock_1_N : N ; -- bottenstock..nn.1
  bottentryck_1_N : N ; -- bottentryck..nn.1
  bottenvatten_1_N : N ; -- bottenvatten..nn.1
  bottenventil_1_N : N ; -- bottenventil..nn.1
  bottenvåning_1_N : N ; -- bottenvåning..nn.1
  bottenyta_1_N : N ; -- bottenyta..nn.1
  bottin_1_N : N ; -- bottin..nn.1
  bottna_1_V : V ; -- bottna..vb.1
  bottnande_1_N : N ; -- bottnande..nn.1
  bottning_1_N : N ; -- bottning..nn.1
  bottnisk_1_A : A ; -- bottnisk..av.1
  botulin_1_N : N ; -- botulin..nn.1
  botulism_1_N : N ; -- botulism..nn.1
  boudoir_1_N : N ; -- boudoir..nn.1
  bouillabaisse_1_N : N ; -- bouillabaisse..nn.1
  boule_1_N : N ; -- boule..nn.1
  boulevard_1_N : N ; -- boulevard..nn.1
  boulevardpress_1_N : N ; -- boulevardpress..nn.1
  bouppteckning_1_N : N ; -- bouppteckning..nn.1
  bouquet_1_N : N ; -- bouquet..nn.1
  bourbon_1_N : N ; -- bourbon..nn.1
  bourgeoisie_1_N : N ; -- bourgeoisie..nn.1
  bourgogne_1_N : N ; -- bourgogne..nn.1
  bourgognevin_1_N : N ; -- bourgognevin..nn.1
  boutique_1_N : N ; -- boutique..nn.1
  boutredare_1_N : N ; -- boutredare..nn.1
  boutredning_1_N : N ; -- boutredning..nn.1
  boutredningsman_1_N : N ; -- boutredningsman..nn.1
  bouzouki_1_N : N ; -- bouzouki..nn.1
  bov_1_N : N ; -- bov..nn.1
  bovaktig_1_A : A ; -- bovaktig..av.1
  bovaktighet_1_N : N ; -- bovaktighet..nn.1
  bovete_1_N : N ; -- bovete..nn.1
  boveteplätt_1_N : N ; -- boveteplätt..nn.1
  bovfysionomi_1_N : N ; -- bovfysionomi..nn.1
  bovstreck_1_N : N ; -- bovstreck..nn.1
  bowla_1_V : V ; -- bowla..vb.1
  bowlande_1_N : N ; -- bowlande..nn.1
  bowlare_1_N : N ; -- bowlare..nn.1
  bowling_1_N : N ; -- bowling..nn.1
  bowlingbana_1_N : N ; -- bowlingbana..nn.1
  bowlinghall_1_N : N ; -- bowlinghall..nn.1
  bowlingklot_1_N : N ; -- bowlingklot..nn.1
  box_1_N : N ; -- box..nn.1
  box_2_N : N ; -- box..nn.2
  boxa_1_V : V ; -- boxa..vb.1
  boxande_1_N : N ; -- boxande..nn.1
  boxare_1_N : N ; -- boxare..nn.1
  boxboll_1_N : N ; -- boxboll..nn.1
  boxer_1_N : N ; -- boxer..nn.1
  boxervalp_1_N : N ; -- boxervalp..nn.1
  boxhandske_1_N : N ; -- boxhandske..nn.1
  boxkalv_1_N : N ; -- boxkalv..nn.1
  boxning_1_N : N ; -- boxning..nn.1
  boxningslokal_1_N : N ; -- boxningslokal..nn.1
  boxningsmatch_1_N : N ; -- boxningsmatch..nn.1
  boxningsring_1_N : N ; -- boxningsring..nn.1
  boxningstränad_1_A : A ; -- boxningstränad..av.1
  boxningsträning_1_N : N ; -- boxningsträning..nn.1
  boxnummer_1_N : N ; -- boxnummer..nn.1
  boyscout_1_N : N ; -- boyscout..nn.1
  boägg_1_N : N ; -- boägg..nn.1
  bra_1_Adv : Adv ; -- bra..ab.1
  bra_2_Adv : Adv ; -- bra..ab.2
  bra_1_A : A ; -- bra..av.1
  bra_2_A : A ; -- bra..av.2
  bracka_1_N : N ; -- bracka..nn.1
  brackig_1_A : A ; -- brackig..av.1
  brackighet_1_N : N ; -- brackighet..nn.1
  brackvattenlevande_1_A : A ; -- brackvattenlevande..av.1
  bragd_1_N : N ; -- bragd..nn.1
  bragdguld_1_N : N ; -- bragdguld..nn.1
  bragdlopp_1_N : N ; -- bragdlopp..nn.1
  bragdmässig_1_A : A ; -- bragdmässig..av.1
  bragelöfte_1_N : N ; -- bragelöfte..nn.1
  brailleskrift_1_N : N ; -- brailleskrift..nn.1
  brainstorming_1_N : N ; -- brainstorming..nn.1
  brak_1_N : N ; -- brak..nn.1
  braka_1_V : V ; -- braka..vb.1
  brakande_1_N : N ; -- brakande..nn.1
  brakfest_1_N : N ; -- brakfest..nn.1
  brakfiasko_1_N : N ; -- brakfiasko..nn.1
  brakmiddag_1_N : N ; -- brakmiddag..nn.1
  brakskit_1_N : N ; -- brakskit..nn.1
  brakskiva_1_N : N ; -- brakskiva..nn.1
  braksuccé_1_N : N ; -- braksuccé..nn.1
  brakteat_1_N : N ; -- brakteat..nn.1
  brakved_1_N : N ; -- brakved..nn.1
  brakycefal_1_A : A ; -- brakycefal..av.1
  brakycefali_1_N : N ; -- brakycefali..nn.1
  bralla_1_N : N ; -- bralla..nn.1
  brallis_1_N : N ; -- brallis..nn.1
  braman_1_N : N ; -- braman..nn.1
  bramanism_1_N : N ; -- bramanism..nn.1
  bramansk_1_A : A ; -- bramansk..av.1
  bramin_1_N : N ; -- bramin..nn.1
  bramsegel_1_N : N ; -- bramsegel..nn.1
  bramstång_1_N : N ; -- bramstång..nn.1
  brand_1_N : N ; -- brand..nn.1
  brandalarm_1_N : N ; -- brandalarm..nn.1
  brandartikel_1_N : N ; -- brandartikel..nn.1
  brandattentat_1_N : N ; -- brandattentat..nn.1
  brandbefäl_1_N : N ; -- brandbefäl..nn.1
  brandbil_1_N : N ; -- brandbil..nn.1
  brandbomb_1_N : N ; -- brandbomb..nn.1
  brandbotten_1_N : N ; -- brandbotten..nn.1
  brandchef_1_N : N ; -- brandchef..nn.1
  branddike_1_N : N ; -- branddike..nn.1
  branddörr_1_N : N ; -- branddörr..nn.1
  brandfackla_1_N : N ; -- brandfackla..nn.1
  brandfara_1_N : N ; -- brandfara..nn.1
  brandfarlig_1_A : A ; -- brandfarlig..av.1
  brandfarlighet_1_N : N ; -- brandfarlighet..nn.1
  brandfri_1_A : A ; -- brandfri..av.1
  brandförsvar_1_N : N ; -- brandförsvar..nn.1
  brandförsäkra_1_V : V ; -- brandförsäkra..vb.1
  brandförsäkring_1_N : N ; -- brandförsäkring..nn.1
  brandförsäkringsavtal_1_N : N ; -- brandförsäkringsavtal..nn.1
  brandförsäkringsbelopp_1_N : N ; -- brandförsäkringsbelopp..nn.1
  brandförsäkringsbolag_1_N : N ; -- brandförsäkringsbolag..nn.1
  brandförsäkringsvärde_1_N : N ; -- brandförsäkringsvärde..nn.1
  brandgata_1_N : N ; -- brandgata..nn.1
  brandgavel_1_N : N ; -- brandgavel..nn.1
  brandgranat_1_N : N ; -- brandgranat..nn.1
  brandgrav_1_N : N ; -- brandgrav..nn.1
  brandgul_1_A : A ; -- brandgul..av.1
  brandhärd_1_N : N ; -- brandhärd..nn.1
  brandhärdig_1_A : A ; -- brandhärdig..av.1
  brandhärdighet_1_N : N ; -- brandhärdighet..nn.1
  brandhärja_1_V : V ; -- brandhärja..vb.1
  brandhärjande_1_N : N ; -- brandhärjande..nn.1
  brandingenjör_1_N : N ; -- brandingenjör..nn.1
  brandinspektion_1_N : N ; -- brandinspektion..nn.1
  brandinspektör_1_N : N ; -- brandinspektör..nn.1
  brandkapten_1_N : N ; -- brandkapten..nn.1
  brandkatastrof_1_N : N ; -- brandkatastrof..nn.1
  brandkår_1_N : N ; -- brandkår..nn.1
  brandkårsfrivillig_1_A : A ; -- brandkårsfrivillig..av.1
  brandkårsutryckning_1_N : N ; -- brandkårsutryckning..nn.1
  brandlager_1_N : N ; -- brandlager..nn.1
  brandlarm_1_N : N ; -- brandlarm..nn.1
  brandlukt_1_N : N ; -- brandlukt..nn.1
  brandman_1_N : N ; -- brandman..nn.1
  brandmansgrepp_1_N : N ; -- brandmansgrepp..nn.1
  brandmur_1_N : N ; -- brandmur..nn.1
  brandoffer_1_N : N ; -- brandoffer..nn.1
  brandorsak_1_N : N ; -- brandorsak..nn.1
  brandpost_1_N : N ; -- brandpost..nn.1
  brandredskap_1_N : N ; -- brandredskap..nn.1
  brandrest_1_N : N ; -- brandrest..nn.1
  brandrök_1_N : N ; -- brandrök..nn.1
  brandrör_1_N : N ; -- brandrör..nn.1
  brandschaktare_1_N : N ; -- brandschaktare..nn.1
  brandsegel_1_N : N ; -- brandsegel..nn.1
  brandskada_1_N : N ; -- brandskada..nn.1
  brandskadad_1_A : A ; -- brandskadad..av.1
  brandskatt_1_N : N ; -- brandskatt..nn.1
  brandskatta_1_V : V ; -- brandskatta..vb.1
  brandskattande_1_N : N ; -- brandskattande..nn.1
  brandskattning_1_N : N ; -- brandskattning..nn.1
  brandskydd_1_N : N ; -- brandskydd..nn.1
  brandskyddslagstiftning_1_N : N ; -- brandskyddslagstiftning..nn.1
  brandskåp_1_N : N ; -- brandskåp..nn.1
  brandslang_1_N : N ; -- brandslang..nn.1
  brandsläckarattrapp_1_N : N ; -- brandsläckarattrapp..nn.1
  brandsläckare_1_N : N ; -- brandsläckare..nn.1
  brandsoldat_1_N : N ; -- brandsoldat..nn.1
  brandspruta_1_N : N ; -- brandspruta..nn.1
  brandstation_1_N : N ; -- brandstation..nn.1
  brandstege_1_N : N ; -- brandstege..nn.1
  brandstod_1_N : N ; -- brandstod..nn.1
  brandstodsbolag_1_N : N ; -- brandstodsbolag..nn.1
  brandstyrka_1_N : N ; -- brandstyrka..nn.1
  brandsvamp_1_N : N ; -- brandsvamp..nn.1
  brandsyn_1_N : N ; -- brandsyn..nn.1
  brandsäker_1_A : A ; -- brandsäker..av.1
  brandsäkerhet_1_N : N ; -- brandsäkerhet..nn.1
  brandtal_1_N : N ; -- brandtal..nn.1
  brandtorn_1_N : N ; -- brandtorn..nn.1
  brandvakt_1_N : N ; -- brandvakt..nn.1
  brandvarnare_1_N : N ; -- brandvarnare..nn.1
  brandväsen_1_N : N ; -- brandväsen..nn.1
  brandövning_1_N : N ; -- brandövning..nn.1
  bransch_1_N : N ; -- bransch..nn.1
  branschförening_1_N : N ; -- branschförening..nn.1
  branschledande_1_A : A ; -- branschledande..av.1
  branschmässig_1_A : A ; -- branschmässig..av.1
  branschorganisation_1_N : N ; -- branschorganisation..nn.1
  branschråd_1_N : N ; -- branschråd..nn.1
  branschtidning_1_N : N ; -- branschtidning..nn.1
  branschvana_1_N : N ; -- branschvana..nn.1
  brant_1_A : A ; -- brant..av.1
  brant_1_N : N ; -- brant..nn.1
  branthet_1_N : N ; -- branthet..nn.1
  brasa_1_N : N ; -- brasa..nn.1
  brasilian_1_N : N ; -- brasilian..nn.1
  brasilianare_1_N : N ; -- brasilianare..nn.1
  brasiliansk_1_A : A ; -- brasiliansk..av.1
  brasilianska_1_N : N ; -- brasilianska..nn.1
  brasilier_1_N : N ; -- brasilier..nn.1
  braska_1_V : V ; -- braska..vb.1
  braskande_1_A : A ; -- braskande..av.1
  braskande_1_N : N ; -- braskande..nn.1
  brasklapp_1_N : N ; -- brasklapp..nn.1
  brass_1_N : N ; -- brass..nn.1
  brassa_1_V : V ; -- brassa..vb.1
  brassande_1_N : N ; -- brassande..nn.1
  brasse_1_N : N ; -- brasse..nn.1
  braständare_1_N : N ; -- braständare..nn.1
  brasved_1_N : N ; -- brasved..nn.1
  brat_1_N : N ; -- brat..nn.1
  brats_1_N : N ; -- brats..nn.1
  bravad_1_N : N ; -- bravad..nn.1
  bravera_1_V : V ; -- bravera..vb.1
  braverande_1_N : N ; -- braverande..nn.1
  bravorop_1_N : N ; -- bravorop..nn.1
  bravur_1_N : N ; -- bravur..nn.1
  bravuraria_1_N : N ; -- bravuraria..nn.1
  bravurnummer_1_N : N ; -- bravurnummer..nn.1
  bravurroll_1_N : N ; -- bravurroll..nn.1
  braxen_1_N : N ; -- braxen..nn.1
  braxengräs_1_N : N ; -- braxengräs..nn.1
  braxenmygga_1_N : N ; -- braxenmygga..nn.1
  braxenpanka_1_N : N ; -- braxenpanka..nn.1
  bre_1_V : V ; -- bre..vb.1
  break_1_N : N ; -- break..nn.1
  breakdance_1_N : N ; -- breakdance..nn.1
  breccia_1_N : N ; -- breccia..nn.1
  bred_1_A : A ; -- bred..av.1
  bredande_1_N : N ; -- bredande..nn.1
  bredaxlad_1_A : A ; -- bredaxlad..av.1
  bredband_1_N : N ; -- bredband..nn.1
  bredbandsföretag_1_N : N ; -- bredbandsföretag..nn.1
  bredbar_1_A : A ; -- bredbar..av.1
  bredbarhet_1_N : N ; -- bredbarhet..nn.1
  bredbent_1_A : A ; -- bredbent..av.1
  bredbenthet_1_N : N ; -- bredbenthet..nn.1
  bredbladig_1_A : A ; -- bredbladig..av.1
  bredbladighet_1_N : N ; -- bredbladighet..nn.1
  bredbrättad_1_A : A ; -- bredbrättad..av.1
  bredbrättig_1_A : A ; -- bredbrättig..av.1
  bredbrättighet_1_N : N ; -- bredbrättighet..nn.1
  bredd_1_N : N ; -- bredd..nn.1
  bredda_1_V : V ; -- bredda..vb.1
  breddande_1_N : N ; -- breddande..nn.1
  breddgrad_1_N : N ; -- breddgrad..nn.1
  breddidrott_1_N : N ; -- breddidrott..nn.1
  breddmässig_1_A : A ; -- breddmässig..av.1
  breddning_1_N : N ; -- breddning..nn.1
  bredhet_1_N : N ; -- bredhet..nn.1
  bredkäftad_1_A : A ; -- bredkäftad..av.1
  bredmun_1_N : N ; -- bredmun..nn.1
  bredmynt_1_A : A ; -- bredmynt..av.1
  bredmynthet_1_N : N ; -- bredmynthet..nn.1
  bredrandig_1_A : A ; -- bredrandig..av.1
  bredrandighet_1_N : N ; -- bredrandighet..nn.1
  bredsida_1_N : N ; -- bredsida..nn.1
  bredskyggig_1_A : A ; -- bredskyggig..av.1
  bredskyggighet_1_N : N ; -- bredskyggighet..nn.1
  bredspackel_1_N : N ; -- bredspackel..nn.1
  bredspektrumantiviral_1_A : A ; -- bredspektrumantiviral..av.1
  bredspårig_1_A : A ; -- bredspårig..av.1
  bredspårighet_1_N : N ; -- bredspårighet..nn.1
  bredså_1_V : V ; -- bredså..vb.1
  bredsådd_1_N : N ; -- bredsådd..nn.1
  bredsående_1_N : N ; -- bredsående..nn.1
  bredvidläsning_1_N : N ; -- bredvidläsning..nn.1
  breende_1_N : N ; -- breende..nn.1
  brems_1_N : N ; -- brems..nn.1
  bremsa_1_V : V ; -- bremsa..vb.1
  bremsande_1_N : N ; -- bremsande..nn.1
  bremsning_1_N : N ; -- bremsning..nn.1
  bresilja_1_N : N ; -- bresilja..nn.1
  bretagnare_1_N : N ; -- bretagnare..nn.1
  bretagnisk_1_A : A ; -- bretagnisk..av.1
  bretagniska_1_N : N ; -- bretagniska..nn.1
  bretagniska_2_N : N ; -- bretagniska..nn.2
  breton_1_N : N ; -- breton..nn.1
  bretonsk_1_A : A ; -- bretonsk..av.1
  bretonska_1_N : N ; -- bretonska..nn.1
  bretonska_2_N : N ; -- bretonska..nn.2
  brev_1_N : N ; -- brev..nn.1
  brevbomb_1_N : N ; -- brevbomb..nn.1
  brevbärare_1_N : N ; -- brevbärare..nn.1
  brevbäring_1_N : N ; -- brevbäring..nn.1
  brevcensur_1_N : N ; -- brevcensur..nn.1
  brevdialog_1_N : N ; -- brevdialog..nn.1
  brevduva_1_N : N ; -- brevduva..nn.1
  brevenkät_1_N : N ; -- brevenkät..nn.1
  brevfack_1_N : N ; -- brevfack..nn.1
  brevfråga_1_N : N ; -- brevfråga..nn.1
  brevförsändelse_1_N : N ; -- brevförsändelse..nn.1
  brevhemlighet_1_N : N ; -- brevhemlighet..nn.1
  brevhuvud_1_N : N ; -- brevhuvud..nn.1
  breviarium_1_N : N ; -- breviarium..nn.1
  brevinkast_1_N : N ; -- brevinkast..nn.1
  brevkort_1_N : N ; -- brevkort..nn.1
  brevlapp_1_N : N ; -- brevlapp..nn.1
  brevledes_1_Adv : Adv ; -- brevledes..ab.1
  brevlåda_1_N : N ; -- brevlåda..nn.1
  brevlådeföretag_1_N : N ; -- brevlådeföretag..nn.1
  brevlådeliknande_1_A : A ; -- brevlådeliknande..av.1
  brevlådetömning_1_N : N ; -- brevlådetömning..nn.1
  brevpapper_1_N : N ; -- brevpapper..nn.1
  brevporto_1_N : N ; -- brevporto..nn.1
  brevpress_1_N : N ; -- brevpress..nn.1
  brevroman_1_N : N ; -- brevroman..nn.1
  brevsamling_1_N : N ; -- brevsamling..nn.1
  brevskola_1_N : N ; -- brevskola..nn.1
  brevskrivande_1_A : A ; -- brevskrivande..av.1
  brevskrivande_1_N : N ; -- brevskrivande..nn.1
  brevskrivare_1_N : N ; -- brevskrivare..nn.1
  brevskörd_1_N : N ; -- brevskörd..nn.1
  brevstil_1_N : N ; -- brevstil..nn.1
  brevställ_1_N : N ; -- brevställ..nn.1
  brevställare_1_N : N ; -- brevställare..nn.1
  brevsvar_1_N : N ; -- brevsvar..nn.1
  brevtelegram_1_N : N ; -- brevtelegram..nn.1
  brevvän_1_N : N ; -- brevvän..nn.1
  brevväxla_1_V : V ; -- brevväxla..vb.1
  brevväxlande_1_N : N ; -- brevväxlande..nn.1
  brevväxling_1_N : N ; -- brevväxling..nn.1
  brevvåg_1_N : N ; -- brevvåg..nn.1
  brevöppnare_1_N : N ; -- brevöppnare..nn.1
  bricka_1_N : N ; -- bricka..nn.1
  brickband_1_N : N ; -- brickband..nn.1
  brickbord_1_N : N ; -- brickbord..nn.1
  brickduk_1_N : N ; -- brickduk..nn.1
  bricklunch_1_N : N ; -- bricklunch..nn.1
  brickplockare_1_N : N ; -- brickplockare..nn.1
  brickunderlägg_1_N : N ; -- brickunderlägg..nn.1
  brickvävd_1_A : A ; -- brickvävd..av.1
  brickvävning_1_N : N ; -- brickvävning..nn.1
  bridge_1_N : N ; -- bridge..nn.1
  bridgebord_1_N : N ; -- bridgebord..nn.1
  bridgejunta_1_N : N ; -- bridgejunta..nn.1
  bridong_1_N : N ; -- bridong..nn.1
  bridreaktor_1_N : N ; -- bridreaktor..nn.1
  briefa_1_V : V ; -- briefa..vb.1
  briefande_1_N : N ; -- briefande..nn.1
  brigad_1_N : N ; -- brigad..nn.1
  brigadchef_1_N : N ; -- brigadchef..nn.1
  brigadgeneral_1_N : N ; -- brigadgeneral..nn.1
  brigadstab_1_N : N ; -- brigadstab..nn.1
  brigadvis_1_Adv : Adv ; -- brigadvis..ab.1
  brigadvis_1_A : A ; -- brigadvis..av.1
  brigadör_1_N : N ; -- brigadör..nn.1
  brigantin_1_N : N ; -- brigantin..nn.1
  brigg_1_N : N ; -- brigg..nn.1
  briggsegel_1_N : N ; -- briggsegel..nn.1
  brikett_1_N : N ; -- brikett..nn.1
  brikettera_1_V : V ; -- brikettera..vb.1
  briketterande_1_N : N ; -- briketterande..nn.1
  briketterbar_1_A : A ; -- briketterbar..av.1
  briketterbarhet_1_N : N ; -- briketterbarhet..nn.1
  brikettering_1_N : N ; -- brikettering..nn.1
  brikettpress_1_N : N ; -- brikettpress..nn.1
  brikollstöt_1_N : N ; -- brikollstöt..nn.1
  briljans_1_N : N ; -- briljans..nn.1
  briljant_1_A : A ; -- briljant..av.1
  briljant_1_N : N ; -- briljant..nn.1
  briljanterad_1_A : A ; -- briljanterad..av.1
  briljantglas_1_N : N ; -- briljantglas..nn.1
  briljantin_1_N : N ; -- briljantin..nn.1
  briljantring_1_N : N ; -- briljantring..nn.1
  briljantsmyckad_1_A : A ; -- briljantsmyckad..av.1
  briljantsmycke_1_N : N ; -- briljantsmycke..nn.1
  briljera_1_V : V ; -- briljera..vb.1
  briljerande_1_N : N ; -- briljerande..nn.1
  briljering_1_N : N ; -- briljering..nn.1
  brilliant_1_N : N ; -- brilliant..nn.1
  bringa_1_N : N ; -- bringa..nn.1
  bringa_1_V : V ; -- bringa..vb.1
  bringande_1_N : N ; -- bringande..nn.1
  brink_1_N : N ; -- brink..nn.1
  brinna_1_V : V ; -- brinna..vb.1
  brinna_2_V : V ; -- brinna..vb.2
  brinnande_1_A : A ; -- brinnande..av.1
  brinnande_1_N : N ; -- brinnande..nn.1
  brinnsträcka_1_N : N ; -- brinnsträcka..nn.1
  brio_1_N : N ; -- brio..nn.1
  bris_1_N : N ; -- bris..nn.1
  brisad_1_N : N ; -- brisad..nn.1
  brisans_1_N : N ; -- brisans..nn.1
  brisansgranat_1_N : N ; -- brisansgranat..nn.1
  brisant_1_A : A ; -- brisant..av.1
  brisant_1_N : N ; -- brisant..nn.1
  brisera_1_V : V ; -- brisera..vb.1
  briserande_1_N : N ; -- briserande..nn.1
  briserbar_1_A : A ; -- briserbar..av.1
  briserbarhet_1_N : N ; -- briserbarhet..nn.1
  brisering_1_N : N ; -- brisering..nn.1
  brisken_1_A : A ; -- brisken..av.1
  briskenhet_1_N : N ; -- briskenhet..nn.1
  brissling_1_N : N ; -- brissling..nn.1
  brist_1_N : N ; -- brist..nn.1
  brista_1_V : V ; -- brista..vb.1
  brista_2_V : V ; -- brista..vb.2
  bristande_1_A : A ; -- bristande..av.1
  bristande_1_N : N ; -- bristande..nn.1
  bristfällig_1_A : A ; -- bristfällig..av.1
  bristfällighet_1_N : N ; -- bristfällighet..nn.1
  bristläge_1_N : N ; -- bristläge..nn.1
  bristning_1_N : N ; -- bristning..nn.1
  bristningsgräns_1_N : N ; -- bristningsgräns..nn.1
  bristsituation_1_N : N ; -- bristsituation..nn.1
  bristsjukdom_1_N : N ; -- bristsjukdom..nn.1
  bristvara_1_N : N ; -- bristvara..nn.1
  bristyrke_1_N : N ; -- bristyrke..nn.1
  britanniametall_1_N : N ; -- britanniametall..nn.1
  britannisk_1_A : A ; -- britannisk..av.1
  brits_1_N : N ; -- brits..nn.1
  britt_1_N : N ; -- britt..nn.1
  brittisk_1_A : A ; -- brittisk..av.1
  brittiska_1_N : N ; -- brittiska..nn.1
  brittmässa_1_N : N ; -- brittmässa..nn.1
  brittsommar_1_N : N ; -- brittsommar..nn.1
  brittsommarväder_1_N : N ; -- brittsommarväder..nn.1
  bro_1_N : N ; -- bro..nn.1
  broa_1_V : V ; -- broa..vb.1
  broande_1_N : N ; -- broande..nn.1
  broavgift_1_N : N ; -- broavgift..nn.1
  brobana_1_N : N ; -- brobana..nn.1
  brobelastning_1_N : N ; -- brobelastning..nn.1
  brobygge_1_N : N ; -- brobygge..nn.1
  brobyggnad_1_N : N ; -- brobyggnad..nn.1
  brobänk_1_N : N ; -- brobänk..nn.1
  brochette_1_N : N ; -- brochette..nn.1
  brock_1_N : N ; -- brock..nn.1
  brock_2_N : N ; -- brock..nn.2
  brockband_1_N : N ; -- brockband..nn.1
  brockfågel_1_N : N ; -- brockfågel..nn.1
  brodd_1_N : N ; -- brodd..nn.1
  brodda_1_V : V ; -- brodda..vb.1
  broddande_1_N : N ; -- broddande..nn.1
  broder_1_N : N ; -- broder..nn.1
  brodera_1_V : V ; -- brodera..vb.1
  broderande_1_N : N ; -- broderande..nn.1
  broderbar_1_A : A ; -- broderbar..av.1
  broderbarhet_1_N : N ; -- broderbarhet..nn.1
  broderbok_1_N : N ; -- broderbok..nn.1
  broderbåge_1_N : N ; -- broderbåge..nn.1
  broderfolk_1_N : N ; -- broderfolk..nn.1
  brodergarn_1_N : N ; -- brodergarn..nn.1
  broderi_1_N : N ; -- broderi..nn.1
  brodering_1_N : N ; -- brodering..nn.1
  broderland_1_N : N ; -- broderland..nn.1
  broderlig_1_A : A ; -- broderlig..av.1
  broderlighet_1_N : N ; -- broderlighet..nn.1
  brodermord_1_N : N ; -- brodermord..nn.1
  brodermördare_1_N : N ; -- brodermördare..nn.1
  brodernål_1_N : N ; -- brodernål..nn.1
  brodersax_1_N : N ; -- brodersax..nn.1
  brodersilke_1_N : N ; -- brodersilke..nn.1
  broderskap_1_N : N ; -- broderskap..nn.1
  broderskärlek_1_N : N ; -- broderskärlek..nn.1
  brodersöm_1_N : N ; -- brodersöm..nn.1
  brodyr_1_N : N ; -- brodyr..nn.1
  brodös_1_N : N ; -- brodös..nn.1
  brofäste_1_N : N ; -- brofäste..nn.1
  brohus_1_N : N ; -- brohus..nn.1
  brohuvud_1_N : N ; -- brohuvud..nn.1
  broiler_1_N : N ; -- broiler..nn.1
  brok_1_N : N ; -- brok..nn.1
  brokad_1_N : N ; -- brokad..nn.1
  brokanal_1_N : N ; -- brokanal..nn.1
  brokar_1_N : N ; -- brokar..nn.1
  brokbladig_1_A : A ; -- brokbladig..av.1
  brokbladighet_1_N : N ; -- brokbladighet..nn.1
  brokblommig_1_A : A ; -- brokblommig..av.1
  brokblommighet_1_N : N ; -- brokblommighet..nn.1
  brokig_1_A : A ; -- brokig..av.1
  brokighet_1_N : N ; -- brokighet..nn.1
  brokista_1_N : N ; -- brokista..nn.1
  brokspett_1_N : N ; -- brokspett..nn.1
  brolla_1_N : N ; -- brolla..nn.1
  brolopp_1_N : N ; -- brolopp..nn.1
  brolägga_1_V : V ; -- brolägga..vb.1
  broläggande_1_N : N ; -- broläggande..nn.1
  brom_1_N : N ; -- brom..nn.1
  bromelia_1_N : N ; -- bromelia..nn.1
  bromera_1_V : V ; -- bromera..vb.1
  bromerande_1_N : N ; -- bromerande..nn.1
  bromerbar_1_A : A ; -- bromerbar..av.1
  bromerbarhet_1_N : N ; -- bromerbarhet..nn.1
  bromering_1_N : N ; -- bromering..nn.1
  bromförgiftning_1_N : N ; -- bromförgiftning..nn.1
  bromid_1_N : N ; -- bromid..nn.1
  bromism_1_N : N ; -- bromism..nn.1
  bromläcka_1_N : N ; -- bromläcka..nn.1
  broms_1_N : N ; -- broms..nn.1
  bromsa_1_V : V ; -- bromsa..vb.1
  bromsande_1_N : N ; -- bromsande..nn.1
  bromsare_1_N : N ; -- bromsare..nn.1
  bromsback_1_N : N ; -- bromsback..nn.1
  bromsband_1_N : N ; -- bromsband..nn.1
  bromsbelägg_1_N : N ; -- bromsbelägg..nn.1
  bromsblock_1_N : N ; -- bromsblock..nn.1
  bromscylinder_1_N : N ; -- bromscylinder..nn.1
  bromsfading_1_N : N ; -- bromsfading..nn.1
  bromsfel_1_N : N ; -- bromsfel..nn.1
  bromsgaller_1_N : N ; -- bromsgaller..nn.1
  bromshandtag_1_N : N ; -- bromshandtag..nn.1
  bromsilverpapper_1_N : N ; -- bromsilverpapper..nn.1
  bromsklaff_1_N : N ; -- bromsklaff..nn.1
  bromskloss_1_N : N ; -- bromskloss..nn.1
  bromskraft_1_N : N ; -- bromskraft..nn.1
  bromsljus_1_N : N ; -- bromsljus..nn.1
  bromsmedicin_1_N : N ; -- bromsmedicin..nn.1
  bromsning_1_N : N ; -- bromsning..nn.1
  bromsolja_1_N : N ; -- bromsolja..nn.1
  bromspedal_1_N : N ; -- bromspedal..nn.1
  bromsraket_1_N : N ; -- bromsraket..nn.1
  bromsservo_1_N : N ; -- bromsservo..nn.1
  bromsskiva_1_N : N ; -- bromsskiva..nn.1
  bromssko_1_N : N ; -- bromssko..nn.1
  bromsskärm_1_N : N ; -- bromsskärm..nn.1
  bromsspår_1_N : N ; -- bromsspår..nn.1
  bromssträcka_1_N : N ; -- bromssträcka..nn.1
  bromsstrålning_1_N : N ; -- bromsstrålning..nn.1
  bromssystem_1_N : N ; -- bromssystem..nn.1
  bromstrumma_1_N : N ; -- bromstrumma..nn.1
  bromsvagn_1_N : N ; -- bromsvagn..nn.1
  bromsvätska_1_N : N ; -- bromsvätska..nn.1
  bromtymolblått_1_N : N ; -- bromtymolblått..nn.1
  bromural_1_N : N ; -- bromural..nn.1
  bromväte_1_N : N ; -- bromväte..nn.1
  bromvätesyra_1_N : N ; -- bromvätesyra..nn.1
  bromyl_1_N : N ; -- bromyl..nn.1
  bronkialastma_1_N : N ; -- bronkialastma..nn.1
  bronkit_1_N : N ; -- bronkit..nn.1
  bronkografi_1_N : N ; -- bronkografi..nn.1
  bronkoskop_1_N : N ; -- bronkoskop..nn.1
  bronkoskopi_1_N : N ; -- bronkoskopi..nn.1
  brons_1_N : N ; -- brons..nn.1
  brons_2_N : N ; -- brons..nn.2
  brons_3_N : N ; -- brons..nn.3
  bronsborste_1_N : N ; -- bronsborste..nn.1
  bronsera_1_V : V ; -- bronsera..vb.1
  bronserande_1_N : N ; -- bronserande..nn.1
  bronserbar_1_A : A ; -- bronserbar..av.1
  bronserbarhet_1_N : N ; -- bronserbarhet..nn.1
  bronsering_1_N : N ; -- bronsering..nn.1
  bronsfärg_1_N : N ; -- bronsfärg..nn.1
  bronsfärgad_1_A : A ; -- bronsfärgad..av.1
  bronsförgylla_1_V : V ; -- bronsförgylla..vb.1
  bronsförgyllande_1_N : N ; -- bronsförgyllande..nn.1
  bronsinfattad_1_A : A ; -- bronsinfattad..av.1
  bronskanna_1_N : N ; -- bronskanna..nn.1
  bronsknapp_1_N : N ; -- bronsknapp..nn.1
  bronskärl_1_N : N ; -- bronskärl..nn.1
  bronsmedalj_1_N : N ; -- bronsmedalj..nn.1
  bronsmedaljör_1_N : N ; -- bronsmedaljör..nn.1
  bronsmynt_1_N : N ; -- bronsmynt..nn.1
  bronsmärke_1_N : N ; -- bronsmärke..nn.1
  bronssmycke_1_N : N ; -- bronssmycke..nn.1
  bronsspänne_1_N : N ; -- bronsspänne..nn.1
  bronsstaty_1_N : N ; -- bronsstaty..nn.1
  bronsstatyett_1_N : N ; -- bronsstatyett..nn.1
  bronssvärd_1_N : N ; -- bronssvärd..nn.1
  bronstavla_1_N : N ; -- bronstavla..nn.1
  bronsyxa_1_N : N ; -- bronsyxa..nn.1
  bronsålder_1_N : N ; -- bronsålder..nn.1
  bronsåldersfynd_1_N : N ; -- bronsåldersfynd..nn.1
  bronsåldersgrav_1_N : N ; -- bronsåldersgrav..nn.1
  bronsåldersmänniska_1_N : N ; -- bronsåldersmänniska..nn.1
  broolycka_1_N : N ; -- broolycka..nn.1
  bropelare_1_N : N ; -- bropelare..nn.1
  bropeng_1_N : N ; -- bropeng..nn.1
  bropenning_1_N : N ; -- bropenning..nn.1
  broplanka_1_N : N ; -- broplanka..nn.1
  bror_1_N : N ; -- bror..nn.1
  brorsa_1_N : N ; -- brorsa..nn.1
  brorsarv_1_N : N ; -- brorsarv..nn.1
  brorsbarn_1_N : N ; -- brorsbarn..nn.1
  brorsdotter_1_N : N ; -- brorsdotter..nn.1
  brorskål_1_N : N ; -- brorskål..nn.1
  brorslott_1_N : N ; -- brorslott..nn.1
  brorson_1_N : N ; -- brorson..nn.1
  brorsskål_1_N : N ; -- brorsskål..nn.1
  brosch_1_N : N ; -- brosch..nn.1
  broschera_1_V : V ; -- broschera..vb.1
  broscherad_1_A : A ; -- broscherad..av.1
  broscherande_1_N : N ; -- broscherande..nn.1
  broscherbar_1_A : A ; -- broscherbar..av.1
  broscherbarhet_1_N : N ; -- broscherbarhet..nn.1
  broschering_1_N : N ; -- broschering..nn.1
  broschyr_1_N : N ; -- broschyr..nn.1
  brosk_1_N : N ; -- brosk..nn.1
  broskartad_1_A : A ; -- broskartad..av.1
  broskfisk_1_N : N ; -- broskfisk..nn.1
  broskhinna_1_N : N ; -- broskhinna..nn.1
  broskskiva_1_N : N ; -- broskskiva..nn.1
  broskskivling_1_N : N ; -- broskskivling..nn.1
  brosksvamp_1_N : N ; -- brosksvamp..nn.1
  broskverk_1_N : N ; -- broskverk..nn.1
  broskvävnad_1_N : N ; -- broskvävnad..nn.1
  broslagning_1_N : N ; -- broslagning..nn.1
  brosme_1_N : N ; -- brosme..nn.1
  brospann_1_N : N ; -- brospann..nn.1
  brossla_1_V : V ; -- brossla..vb.1
  brosslande_1_N : N ; -- brosslande..nn.1
  brotsch_1_N : N ; -- brotsch..nn.1
  brotscha_1_V : V ; -- brotscha..vb.1
  brotschande_1_N : N ; -- brotschande..nn.1
  brott_1_N : N ; -- brott..nn.1
  brott_2_N : N ; -- brott..nn.2
  brottare_1_N : N ; -- brottare..nn.1
  brottarlegendar_1_N : N ; -- brottarlegendar..nn.1
  brottmål_1_N : N ; -- brottmål..nn.1
  brottmålsdomare_1_N : N ; -- brottmålsdomare..nn.1
  brottmålsdomstol_1_N : N ; -- brottmålsdomstol..nn.1
  brottmålsprocess_1_N : N ; -- brottmålsprocess..nn.1
  brottning_1_N : N ; -- brottning..nn.1
  brottningsgrepp_1_N : N ; -- brottningsgrepp..nn.1
  brottningskamp_1_N : N ; -- brottningskamp..nn.1
  brottningsmatch_1_N : N ; -- brottningsmatch..nn.1
  brottningsring_1_N : N ; -- brottningsring..nn.1
  brottsbalk_1_N : N ; -- brottsbalk..nn.1
  brottsbekämpande_1_N : N ; -- brottsbekämpande..nn.1
  brottsbekämpning_1_N : N ; -- brottsbekämpning..nn.1
  brottsbevakning_1_N : N ; -- brottsbevakning..nn.1
  brottsförebyggande_1_A : A ; -- brottsförebyggande..av.1
  brottshistoria_1_N : N ; -- brottshistoria..nn.1
  brottsjournalistik_1_N : N ; -- brottsjournalistik..nn.1
  brottsjö_1_N : N ; -- brottsjö..nn.1
  brottskonkurrens_1_N : N ; -- brottskonkurrens..nn.1
  brottslig_1_A : A ; -- brottslig..av.1
  brottslighet_1_N : N ; -- brottslighet..nn.1
  brottsling_1_N : N ; -- brottsling..nn.1
  brottsmisstanke_1_N : N ; -- brottsmisstanke..nn.1
  brottsmisstänkt_1_A : A ; -- brottsmisstänkt..av.1
  brottsmål_1_N : N ; -- brottsmål..nn.1
  brottsoffer_1_N : N ; -- brottsoffer..nn.1
  brottsplats_1_N : N ; -- brottsplats..nn.1
  brottsplatsexpert_1_N : N ; -- brottsplatsexpert..nn.1
  brottsplatstekniker_1_N : N ; -- brottsplatstekniker..nn.1
  brottsplatsundersökning_1_N : N ; -- brottsplatsundersökning..nn.1
  brottsprovokation_1_N : N ; -- brottsprovokation..nn.1
  brottsregister_1_N : N ; -- brottsregister..nn.1
  brottsrekvisit_1_N : N ; -- brottsrekvisit..nn.1
  brottsrubricering_1_N : N ; -- brottsrubricering..nn.1
  brottstillfälle_1_N : N ; -- brottstillfälle..nn.1
  brottstycke_1_N : N ; -- brottstycke..nn.1
  brottställe_1_N : N ; -- brottställe..nn.1
  brottsutreda_1_V : V ; -- brottsutreda..vb.1
  brottsutredande_1_N : N ; -- brottsutredande..nn.1
  brottsutredning_1_N : N ; -- brottsutredning..nn.1
  brottyta_1_N : N ; -- brottyta..nn.1
  brovalv_1_N : N ; -- brovalv..nn.1
  browning_1_N : N ; -- browning..nn.1
  broöppning_1_N : N ; -- broöppning..nn.1
  bruckel_1_N : N ; -- bruckel..nn.1
  bruckla_1_V : V ; -- bruckla..vb.1
  brucklande_1_N : N ; -- brucklande..nn.1
  brud_1_N : N ; -- brud..nn.1
  brudand_1_N : N ; -- brudand..nn.1
  brudborste_1_N : N ; -- brudborste..nn.1
  brudbröd_1_N : N ; -- brudbröd..nn.1
  brudbukett_1_N : N ; -- brudbukett..nn.1
  brudfoto_1_N : N ; -- brudfoto..nn.1
  brudfrämma_1_N : N ; -- brudfrämma..nn.1
  brudfölje_1_N : N ; -- brudfölje..nn.1
  brudgum_1_N : N ; -- brudgum..nn.1
  brudgåva_1_N : N ; -- brudgåva..nn.1
  brudklänning_1_N : N ; -- brudklänning..nn.1
  brudkrona_1_N : N ; -- brudkrona..nn.1
  brudköp_1_N : N ; -- brudköp..nn.1
  brudmystik_1_N : N ; -- brudmystik..nn.1
  brudnäbb_1_N : N ; -- brudnäbb..nn.1
  brudpall_1_N : N ; -- brudpall..nn.1
  brudpar_1_N : N ; -- brudpar..nn.1
  brudpäll_1_N : N ; -- brudpäll..nn.1
  brudrov_1_N : N ; -- brudrov..nn.1
  brudslöja_1_N : N ; -- brudslöja..nn.1
  brudsporre_1_N : N ; -- brudsporre..nn.1
  brudstol_1_N : N ; -- brudstol..nn.1
  brudsäng_1_N : N ; -- brudsäng..nn.1
  brudtärna_1_N : N ; -- brudtärna..nn.1
  brudöverlämning_1_N : N ; -- brudöverlämning..nn.1
  brugd_1_N : N ; -- brugd..nn.1
  bruk_1_N : N ; -- bruk..nn.1
  bruk_2_N : N ; -- bruk..nn.2
  bruka_1_V : V ; -- bruka..vb.1
  brukande_1_N : N ; -- brukande..nn.1
  brukare_1_N : N ; -- brukare..nn.1
  brukbar_1_A : A ; -- brukbar..av.1
  brukbarhet_1_N : N ; -- brukbarhet..nn.1
  bruklig_1_A : A ; -- bruklig..av.1
  bruklighet_1_N : N ; -- bruklighet..nn.1
  brukning_1_N : N ; -- brukning..nn.1
  brukningsenhet_1_N : N ; -- brukningsenhet..nn.1
  bruksanvisning_1_N : N ; -- bruksanvisning..nn.1
  bruksarbetare_1_N : N ; -- bruksarbetare..nn.1
  bruksartikel_1_N : N ; -- bruksartikel..nn.1
  bruksdisponent_1_N : N ; -- bruksdisponent..nn.1
  bruksdjur_1_N : N ; -- bruksdjur..nn.1
  bruksdrift_1_N : N ; -- bruksdrift..nn.1
  bruksföremål_1_N : N ; -- bruksföremål..nn.1
  brukshund_1_N : N ; -- brukshund..nn.1
  brukskonst_1_N : N ; -- brukskonst..nn.1
  brukslagare_1_N : N ; -- brukslagare..nn.1
  brukslev_1_N : N ; -- brukslev..nn.1
  brukslå_1_V : V ; -- brukslå..vb.1
  brukslående_1_N : N ; -- brukslående..nn.1
  bruksort_1_N : N ; -- bruksort..nn.1
  brukspatron_1_N : N ; -- brukspatron..nn.1
  bruksrörelse_1_N : N ; -- bruksrörelse..nn.1
  brukssamhälle_1_N : N ; -- brukssamhälle..nn.1
  bruksvärde_1_N : N ; -- bruksvärde..nn.1
  bruksvärdeshyra_1_N : N ; -- bruksvärdeshyra..nn.1
  brulépudding_1_N : N ; -- brulépudding..nn.1
  brumbas_1_N : N ; -- brumbas..nn.1
  brumbjörn_1_N : N ; -- brumbjörn..nn.1
  brumkör_1_N : N ; -- brumkör..nn.1
  brumma_1_V : V ; -- brumma..vb.1
  brummande_1_N : N ; -- brummande..nn.1
  brummare_1_N : N ; -- brummare..nn.1
  brumning_1_N : N ; -- brumning..nn.1
  brun_1_A : A ; -- brun..av.1
  brunaktig_1_A : A ; -- brunaktig..av.1
  brunaktighet_1_N : N ; -- brunaktighet..nn.1
  brunalg_1_N : N ; -- brunalg..nn.1
  brunand_1_N : N ; -- brunand..nn.1
  brunbetsa_1_V : V ; -- brunbetsa..vb.1
  brunbetsande_1_N : N ; -- brunbetsande..nn.1
  brunbetsning_1_N : N ; -- brunbetsning..nn.1
  brunbränd_1_A : A ; -- brunbränd..av.1
  brunbär_1_N : N ; -- brunbär..nn.1
  brunch_1_N : N ; -- brunch..nn.1
  brunchtest_1_N : N ; -- brunchtest..nn.1
  bruneier_1_N : N ; -- bruneier..nn.1
  bruneisk_1_A : A ; -- bruneisk..av.1
  bruneiska_1_N : N ; -- bruneiska..nn.1
  brunera_1_V : V ; -- brunera..vb.1
  brunerande_1_N : N ; -- brunerande..nn.1
  brunerbar_1_A : A ; -- brunerbar..av.1
  brunerbarhet_1_N : N ; -- brunerbarhet..nn.1
  brunering_1_N : N ; -- brunering..nn.1
  brunett_1_A : A ; -- brunett..av.1
  brunett_1_N : N ; -- brunett..nn.1
  brunfärga_1_V : V ; -- brunfärga..vb.1
  brunfärgad_1_A : A ; -- brunfärgad..av.1
  brunfärgande_1_N : N ; -- brunfärgande..nn.1
  brunglänsande_1_A : A ; -- brunglänsande..av.1
  brungrå_1_A : A ; -- brungrå..av.1
  brungul_1_A : A ; -- brungul..av.1
  brunhet_1_N : N ; -- brunhet..nn.1
  brunhyad_1_A : A ; -- brunhyad..av.1
  brunhårig_1_A : A ; -- brunhårig..av.1
  brunhårighet_1_N : N ; -- brunhårighet..nn.1
  brunjord_1_N : N ; -- brunjord..nn.1
  brunkol_1_N : N ; -- brunkol..nn.1
  brunkolsdoft_1_N : N ; -- brunkolsdoft..nn.1
  brunkulla_1_N : N ; -- brunkulla..nn.1
  brunkål_1_N : N ; -- brunkål..nn.1
  brunlackerad_1_A : A ; -- brunlackerad..av.1
  brunmurrig_1_A : A ; -- brunmurrig..av.1
  brunmurrighet_1_N : N ; -- brunmurrighet..nn.1
  brunmålad_1_A : A ; -- brunmålad..av.1
  brunn_1_N : N ; -- brunn..nn.1
  brunnsdrickning_1_N : N ; -- brunnsdrickning..nn.1
  brunnshus_1_N : N ; -- brunnshus..nn.1
  brunnskall_1_A : A ; -- brunnskall..av.1
  brunnskar_1_N : N ; -- brunnskar..nn.1
  brunnskur_1_N : N ; -- brunnskur..nn.1
  brunnsläkare_1_N : N ; -- brunnsläkare..nn.1
  brunnsort_1_N : N ; -- brunnsort..nn.1
  brunnspark_1_N : N ; -- brunnspark..nn.1
  brunnssvängel_1_N : N ; -- brunnssvängel..nn.1
  brunnsvatten_1_N : N ; -- brunnsvatten..nn.1
  brunnsöppning_1_N : N ; -- brunnsöppning..nn.1
  brunockra_1_N : N ; -- brunockra..nn.1
  brunrost_1_N : N ; -- brunrost..nn.1
  brunrutig_1_A : A ; -- brunrutig..av.1
  brunrutighet_1_N : N ; -- brunrutighet..nn.1
  brunråtta_1_N : N ; -- brunråtta..nn.1
  brunröd_1_A : A ; -- brunröd..av.1
  brunröta_1_N : N ; -- brunröta..nn.1
  brunskjorta_1_N : N ; -- brunskjorta..nn.1
  brunskära_1_N : N ; -- brunskära..nn.1
  brunsmutsig_1_A : A ; -- brunsmutsig..av.1
  brunst_1_N : N ; -- brunst..nn.1
  brunstig_1_A : A ; -- brunstig..av.1
  brunstighet_1_N : N ; -- brunstighet..nn.1
  brunsttid_1_N : N ; -- brunsttid..nn.1
  brunsvart_1_A : A ; -- brunsvart..av.1
  brunte_1_N : N ; -- brunte..nn.1
  brunögd_1_A : A ; -- brunögd..av.1
  brunögdhet_1_N : N ; -- brunögdhet..nn.1
  brunört_1_N : N ; -- brunört..nn.1
  brus_1_N : N ; -- brus..nn.1
  brusa_1_V : V ; -- brusa..vb.1
  brusande_1_N : N ; -- brusande..nn.1
  brusdryck_1_N : N ; -- brusdryck..nn.1
  brushane_1_N : N ; -- brushane..nn.1
  brushuvud_1_N : N ; -- brushuvud..nn.1
  brusig_1_A : A ; -- brusig..av.1
  brusighet_1_N : N ; -- brusighet..nn.1
  brustablett_1_N : N ; -- brustablett..nn.1
  brusten_1_A : A ; -- brusten..av.1
  brustenhet_1_N : N ; -- brustenhet..nn.1
  brutal_1_A : A ; -- brutal..av.1
  brutalisera_1_V : V ; -- brutalisera..vb.1
  brutaliserande_1_N : N ; -- brutaliserande..nn.1
  brutaliserbar_1_A : A ; -- brutaliserbar..av.1
  brutaliserbarhet_1_N : N ; -- brutaliserbarhet..nn.1
  brutalisering_1_N : N ; -- brutalisering..nn.1
  brutalitet_1_N : N ; -- brutalitet..nn.1
  bruten_1_A : A ; -- bruten..av.1
  brutta_1_N : N ; -- brutta..nn.1
  brutto_1_N : N ; -- brutto..nn.1
  bruttoavkastning_1_N : N ; -- bruttoavkastning..nn.1
  bruttobehållning_1_N : N ; -- bruttobehållning..nn.1
  bruttobelopp_1_N : N ; -- bruttobelopp..nn.1
  bruttodräktighet_1_N : N ; -- bruttodräktighet..nn.1
  bruttoformel_1_N : N ; -- bruttoformel..nn.1
  bruttoinkomst_1_N : N ; -- bruttoinkomst..nn.1
  bruttolön_1_N : N ; -- bruttolön..nn.1
  bruttonationalprodukt_1_N : N ; -- bruttonationalprodukt..nn.1
  bruttopris_1_N : N ; -- bruttopris..nn.1
  bruttoregisterton_1_N : N ; -- bruttoregisterton..nn.1
  bruttovikt_1_N : N ; -- bruttovikt..nn.1
  bruttovinst_1_N : N ; -- bruttovinst..nn.1
  bruttovärde_1_N : N ; -- bruttovärde..nn.1
  bry_1_N : N ; -- bry..nn.1
  bry_1_V : V ; -- bry..vb.1
  brydd_1_A : A ; -- brydd..av.1
  bryddhet_1_N : N ; -- bryddhet..nn.1
  bryderi_1_N : N ; -- bryderi..nn.1
  brydsam_1_A : A ; -- brydsam..av.1
  brydsamhet_1_N : N ; -- brydsamhet..nn.1
  bryende_1_N : N ; -- bryende..nn.1
  brygd_1_N : N ; -- brygd..nn.1
  brygga_1_N : N ; -- brygga..nn.1
  brygga_1_V : V ; -- brygga..vb.1
  brygga_2_V : V ; -- brygga..vb.2
  bryggande_1_N : N ; -- bryggande..nn.1
  bryggarbil_1_N : N ; -- bryggarbil..nn.1
  bryggare_1_N : N ; -- bryggare..nn.1
  bryggdans_1_N : N ; -- bryggdans..nn.1
  bryggeri_1_N : N ; -- bryggeri..nn.1
  bryggerijäst_1_N : N ; -- bryggerijäst..nn.1
  bryggerijätte_1_N : N ; -- bryggerijätte..nn.1
  brygghus_1_N : N ; -- brygghus..nn.1
  bryggjäst_1_N : N ; -- bryggjäst..nn.1
  bryggkaffe_1_N : N ; -- bryggkaffe..nn.1
  bryggkant_1_N : N ; -- bryggkant..nn.1
  bryggmald_1_A : A ; -- bryggmald..av.1
  bryggmalen_1_A : A ; -- bryggmalen..av.1
  bryggplats_1_N : N ; -- bryggplats..nn.1
  bryggvåg_1_N : N ; -- bryggvåg..nn.1
  brylling_1_N : N ; -- brylling..nn.1
  brylå_1_N : N ; -- brylå..nn.1
  brylépudding_1_N : N ; -- brylépudding..nn.1
  bryn_1_N : N ; -- bryn..nn.1
  bryna_1_V : V ; -- bryna..vb.1
  bryna_2_V : V ; -- bryna..vb.2
  brynande_1_N : N ; -- brynande..nn.1
  bryne_1_N : N ; -- bryne..nn.1
  brynja_1_N : N ; -- brynja..nn.1
  brynset_1_N : N ; -- brynset..nn.1
  brynsten_1_N : N ; -- brynsten..nn.1
  brynstål_1_N : N ; -- brynstål..nn.1
  bryolog_1_N : N ; -- bryolog..nn.1
  bryologi_1_N : N ; -- bryologi..nn.1
  brysk_1_A : A ; -- brysk..av.1
  bryskhet_1_N : N ; -- bryskhet..nn.1
  brysselkål_1_N : N ; -- brysselkål..nn.1
  brysselmatta_1_N : N ; -- brysselmatta..nn.1
  brysselspets_1_N : N ; -- brysselspets..nn.1
  bryta_1_V : V ; -- bryta..vb.1
  brytande_1_N : N ; -- brytande..nn.1
  brytare_1_N : N ; -- brytare..nn.1
  brytarfel_1_N : N ; -- brytarfel..nn.1
  brytbar_1_A : A ; -- brytbar..av.1
  brytbarhet_1_N : N ; -- brytbarhet..nn.1
  brytblad_1_N : N ; -- brytblad..nn.1
  brytbladskniv_1_N : N ; -- brytbladskniv..nn.1
  brytböna_1_N : N ; -- brytböna..nn.1
  bryte_1_N : N ; -- bryte..nn.1
  brytning_1_N : N ; -- brytning..nn.1
  brytningsexponent_1_N : N ; -- brytningsexponent..nn.1
  brytningsfel_1_N : N ; -- brytningsfel..nn.1
  brytningsförmåga_1_N : N ; -- brytningsförmåga..nn.1
  brytningsgräns_1_N : N ; -- brytningsgräns..nn.1
  brytningsindex_1_N : N ; -- brytningsindex..nn.1
  brytningsperiod_1_N : N ; -- brytningsperiod..nn.1
  brytningspunkt_1_N : N ; -- brytningspunkt..nn.1
  brytningstid_1_N : N ; -- brytningstid..nn.1
  brytningsvinkel_1_N : N ; -- brytningsvinkel..nn.1
  brytningsår_1_N : N ; -- brytningsår..nn.1
  brytpunkt_1_N : N ; -- brytpunkt..nn.1
  brytvapen_1_N : N ; -- brytvapen..nn.1
  bräck_1_N : N ; -- bräck..nn.1
  bräcka_1_V : V ; -- bräcka..vb.1
  bräckage_1_N : N ; -- bräckage..nn.1
  bräckande_1_N : N ; -- bräckande..nn.1
  bräckhammare_1_N : N ; -- bräckhammare..nn.1
  bräckjärn_1_N : N ; -- bräckjärn..nn.1
  bräckkorv_1_N : N ; -- bräckkorv..nn.1
  bräcklig_1_A : A ; -- bräcklig..av.1
  bräcklighet_1_N : N ; -- bräcklighet..nn.1
  bräckning_1_N : N ; -- bräckning..nn.1
  bräckt_1_A : A ; -- bräckt..av.1
  bräckthet_1_N : N ; -- bräckthet..nn.1
  bräckvatten_1_N : N ; -- bräckvatten..nn.1
  bräda_1_N : N ; -- bräda..nn.1
  bräda_1_V : V ; -- bräda..vb.1
  brädande_1_N : N ; -- brädande..nn.1
  brädbeklä_1_V : V ; -- brädbeklä..vb.1
  brädbeklädande_1_N : N ; -- brädbeklädande..nn.1
  brädbeklädd_1_A : A ; -- brädbeklädd..av.1
  brädbeklädnad_1_N : N ; -- brädbeklädnad..nn.1
  brädbeslå_1_V : V ; -- brädbeslå..vb.1
  brädbeslående_1_N : N ; -- brädbeslående..nn.1
  brädd_1_N : N ; -- brädd..nn.1
  brädda_1_V : V ; -- brädda..vb.1
  bräddande_1_N : N ; -- bräddande..nn.1
  bräddavlopp_1_N : N ; -- bräddavlopp..nn.1
  bräddfull_1_A : A ; -- bräddfull..av.1
  bräddfullhet_1_N : N ; -- bräddfullhet..nn.1
  bräddfylld_1_A : A ; -- bräddfylld..av.1
  bräddfylldhet_1_N : N ; -- bräddfylldhet..nn.1
  bräde_1_N : N ; -- bräde..nn.1
  brädfodra_1_V : V ; -- brädfodra..vb.1
  brädfodrande_1_N : N ; -- brädfodrande..nn.1
  brädgång_1_N : N ; -- brädgång..nn.1
  brädgård_1_N : N ; -- brädgård..nn.1
  brädplank_1_N : N ; -- brädplank..nn.1
  brädsegla_1_V : V ; -- brädsegla..vb.1
  brädseglande_1_N : N ; -- brädseglande..nn.1
  brädslå_1_V : V ; -- brädslå..vb.1
  brädslående_1_N : N ; -- brädslående..nn.1
  brädspel_1_N : N ; -- brädspel..nn.1
  brädvägg_1_N : N ; -- brädvägg..nn.1
  bräka_1_V : V ; -- bräka..vb.1
  bräkande_1_N : N ; -- bräkande..nn.1
  bräken_1_N : N ; -- bräken..nn.1
  bräkning_1_N : N ; -- bräkning..nn.1
  bräm_1_N : N ; -- bräm..nn.1
  bräma_1_V : V ; -- bräma..vb.1
  brämande_1_N : N ; -- brämande..nn.1
  bränna_1_V : V ; -- bränna..vb.1
  brännande_1_A : A ; -- brännande..av.1
  brännande_1_N : N ; -- brännande..nn.1
  brännare_1_N : N ; -- brännare..nn.1
  brännbar_1_A : A ; -- brännbar..av.1
  brännbarhet_1_N : N ; -- brännbarhet..nn.1
  brännblåsa_1_N : N ; -- brännblåsa..nn.1
  brännboll_1_N : N ; -- brännboll..nn.1
  brännboll_2_N : N ; -- brännboll..nn.2
  brännbollskast_1_N : N ; -- brännbollskast..nn.1
  brännbollsträ_1_N : N ; -- brännbollsträ..nn.1
  bränne_1_N : N ; -- bränne..nn.1
  bränneri_1_N : N ; -- bränneri..nn.1
  brännglas_1_N : N ; -- brännglas..nn.1
  brännhet_1_A : A ; -- brännhet..av.1
  brännhår_1_N : N ; -- brännhår..nn.1
  bränning_1_N : N ; -- bränning..nn.1
  brännjärn_1_N : N ; -- brännjärn..nn.1
  brännkammare_1_N : N ; -- brännkammare..nn.1
  brännlack_1_N : N ; -- brännlack..nn.1
  brännlackera_1_V : V ; -- brännlackera..vb.1
  brännlackerande_1_N : N ; -- brännlackerande..nn.1
  brännlackerbar_1_A : A ; -- brännlackerbar..av.1
  brännlackerbarhet_1_N : N ; -- brännlackerbarhet..nn.1
  brännlackering_1_N : N ; -- brännlackering..nn.1
  brännmanet_1_N : N ; -- brännmanet..nn.1
  brännmaterial_1_N : N ; -- brännmaterial..nn.1
  brännmärka_1_V : V ; -- brännmärka..vb.1
  brännmärkande_1_N : N ; -- brännmärkande..nn.1
  brännmärke_1_N : N ; -- brännmärke..nn.1
  brännmärkning_1_N : N ; -- brännmärkning..nn.1
  brännoffer_1_N : N ; -- brännoffer..nn.1
  brännolja_1_N : N ; -- brännolja..nn.1
  brännpunkt_1_N : N ; -- brännpunkt..nn.1
  brännskada_1_N : N ; -- brännskada..nn.1
  brännskada_1_V : V ; -- brännskada..vb.1
  brännskadad_1_A : A ; -- brännskadad..av.1
  brännskadande_1_N : N ; -- brännskadande..nn.1
  brännstål_1_N : N ; -- brännstål..nn.1
  brännsår_1_N : N ; -- brännsår..nn.1
  bränntorv_1_N : N ; -- bränntorv..nn.1
  brännugn_1_N : N ; -- brännugn..nn.1
  brännved_1_N : N ; -- brännved..nn.1
  brännvidd_1_N : N ; -- brännvidd..nn.1
  brännvin_1_N : N ; -- brännvin..nn.1
  brännvinsadvokat_1_N : N ; -- brännvinsadvokat..nn.1
  brännvinsbas_1_N : N ; -- brännvinsbas..nn.1
  brännvinsbord_1_N : N ; -- brännvinsbord..nn.1
  brännvinsbränneri_1_N : N ; -- brännvinsbränneri..nn.1
  brännvinsbränning_1_N : N ; -- brännvinsbränning..nn.1
  brännvinsdestilleri_1_N : N ; -- brännvinsdestilleri..nn.1
  brännvinsdestillering_1_N : N ; -- brännvinsdestillering..nn.1
  brännvinsglas_1_N : N ; -- brännvinsglas..nn.1
  brännvinsnäsa_1_N : N ; -- brännvinsnäsa..nn.1
  brännvinsprovare_1_N : N ; -- brännvinsprovare..nn.1
  brännyta_1_N : N ; -- brännyta..nn.1
  brännässla_1_N : N ; -- brännässla..nn.1
  bränsle_1_N : N ; -- bränsle..nn.1
  bränslebesparande_1_A : A ; -- bränslebesparande..av.1
  bränslebesparing_1_N : N ; -- bränslebesparing..nn.1
  bränslebrist_1_N : N ; -- bränslebrist..nn.1
  bränslecell_1_N : N ; -- bränslecell..nn.1
  bränslecellsdriven_1_A : A ; -- bränslecellsdriven..av.1
  bränslecellskonstruktion_1_N : N ; -- bränslecellskonstruktion..nn.1
  bränslecellskraftverk_1_N : N ; -- bränslecellskraftverk..nn.1
  bränslecellstyp_1_N : N ; -- bränslecellstyp..nn.1
  bränsledepå_1_N : N ; -- bränsledepå..nn.1
  bränsleelement_1_N : N ; -- bränsleelement..nn.1
  bränslefilter_1_N : N ; -- bränslefilter..nn.1
  bränslefält_1_N : N ; -- bränslefält..nn.1
  bränsleförbrukning_1_N : N ; -- bränsleförbrukning..nn.1
  bränsleförråd_1_N : N ; -- bränsleförråd..nn.1
  bränslegas_1_N : N ; -- bränslegas..nn.1
  bränslekanal_1_N : N ; -- bränslekanal..nn.1
  bränslekris_1_N : N ; -- bränslekris..nn.1
  bränslemätare_1_N : N ; -- bränslemätare..nn.1
  bränsleomvandlare_1_N : N ; -- bränsleomvandlare..nn.1
  bränsleransonering_1_N : N ; -- bränsleransonering..nn.1
  bränsleslukande_1_A : A ; -- bränsleslukande..av.1
  bränslesnål_1_A : A ; -- bränslesnål..av.1
  bränslesnålhet_1_N : N ; -- bränslesnålhet..nn.1
  bränslestav_1_N : N ; -- bränslestav..nn.1
  bränsletank_1_N : N ; -- bränsletank..nn.1
  bränsletillägg_1_N : N ; -- bränsletillägg..nn.1
  bränsletyp_1_N : N ; -- bränsletyp..nn.1
  bränsleåtgång_1_N : N ; -- bränsleåtgång..nn.1
  bräsch_1_N : N ; -- bräsch..nn.1
  bräsera_1_V : V ; -- bräsera..vb.1
  bräserande_1_N : N ; -- bräserande..nn.1
  bräserbar_1_A : A ; -- bräserbar..av.1
  bräserbarhet_1_N : N ; -- bräserbarhet..nn.1
  bräsering_1_N : N ; -- bräsering..nn.1
  bräsma_1_N : N ; -- bräsma..nn.1
  bräss_1_N : N ; -- bräss..nn.1
  brätte_1_N : N ; -- brätte..nn.1
  bråck_1_N : N ; -- bråck..nn.1
  bråckband_1_N : N ; -- bråckband..nn.1
  bråd_1_A : A ; -- bråd..av.1
  bråddjup_1_A : A ; -- bråddjup..av.1
  bråddjup_1_N : N ; -- bråddjup..nn.1
  bråddjuphet_1_N : N ; -- bråddjuphet..nn.1
  brådhet_1_N : N ; -- brådhet..nn.1
  brådmogen_1_A : A ; -- brådmogen..av.1
  brådmogenhet_1_N : N ; -- brådmogenhet..nn.1
  brådmognad_1_N : N ; -- brådmognad..nn.1
  brådska_1_N : N ; -- brådska..nn.1
  brådska_1_V : V ; -- brådska..vb.1
  brådskande_1_A : A ; -- brådskande..av.1
  brådskande_1_N : N ; -- brådskande..nn.1
  brådstörtad_1_A : A ; -- brådstörtad..av.1
  bråk_1_N : N ; -- bråk..nn.1
  bråka_1_N : N ; -- bråka..nn.1
  bråka_1_V : V ; -- bråka..vb.1
  bråka_2_V : V ; -- bråka..vb.2
  bråkande_1_N : N ; -- bråkande..nn.1
  bråkdel_1_N : N ; -- bråkdel..nn.1
  bråkig_1_A : A ; -- bråkig..av.1
  bråkighet_1_N : N ; -- bråkighet..nn.1
  bråkmakare_1_N : N ; -- bråkmakare..nn.1
  bråkräkning_1_N : N ; -- bråkräkning..nn.1
  bråkstake_1_N : N ; -- bråkstake..nn.1
  bråkstreck_1_N : N ; -- bråkstreck..nn.1
  bråktal_1_N : N ; -- bråktal..nn.1
  brånad_1_N : N ; -- brånad..nn.1
  bråte_1_N : N ; -- bråte..nn.1
  bråttom_1_A : A ; -- bråttom..av.1
  bröa_1_V : V ; -- bröa..vb.1
  bröande_1_N : N ; -- bröande..nn.1
  bröd_1_N : N ; -- bröd..nn.1
  bröda_1_V : V ; -- bröda..vb.1
  brödande_1_N : N ; -- brödande..nn.1
  brödbagge_1_N : N ; -- brödbagge..nn.1
  brödbak_1_N : N ; -- brödbak..nn.1
  brödbit_1_N : N ; -- brödbit..nn.1
  brödbrist_1_N : N ; -- brödbrist..nn.1
  brödburk_1_N : N ; -- brödburk..nn.1
  brödfat_1_N : N ; -- brödfat..nn.1
  brödfrukt_1_N : N ; -- brödfrukt..nn.1
  brödföda_1_N : N ; -- brödföda..nn.1
  bröding_1_N : N ; -- bröding..nn.1
  brödkaka_1_N : N ; -- brödkaka..nn.1
  brödkant_1_N : N ; -- brödkant..nn.1
  brödkavel_1_N : N ; -- brödkavel..nn.1
  brödkavle_1_N : N ; -- brödkavle..nn.1
  brödkniv_1_N : N ; -- brödkniv..nn.1
  brödkorg_1_N : N ; -- brödkorg..nn.1
  brödkö_1_N : N ; -- brödkö..nn.1
  brödlös_1_A : A ; -- brödlös..av.1
  brödlöshet_1_N : N ; -- brödlöshet..nn.1
  brödnagg_1_N : N ; -- brödnagg..nn.1
  brödpris_1_N : N ; -- brödpris..nn.1
  brödpudding_1_N : N ; -- brödpudding..nn.1
  brödrafolk_1_N : N ; -- brödrafolk..nn.1
  brödralag_1_N : N ; -- brödralag..nn.1
  brödrapar_1_N : N ; -- brödrapar..nn.1
  brödrasinne_1_N : N ; -- brödrasinne..nn.1
  brödraskap_1_N : N ; -- brödraskap..nn.1
  brödrost_1_N : N ; -- brödrost..nn.1
  brödsbrytelse_1_N : N ; -- brödsbrytelse..nn.1
  brödskiva_1_N : N ; -- brödskiva..nn.1
  brödskriveri_1_N : N ; -- brödskriveri..nn.1
  brödsmula_1_N : N ; -- brödsmula..nn.1
  brödspade_1_N : N ; -- brödspade..nn.1
  brödstil_1_N : N ; -- brödstil..nn.1
  brödstycke_1_N : N ; -- brödstycke..nn.1
  brödsäd_1_N : N ; -- brödsäd..nn.1
  brödtext_1_N : N ; -- brödtext..nn.1
  bröl_1_N : N ; -- bröl..nn.1
  bröla_1_V : V ; -- bröla..vb.1
  brölande_1_N : N ; -- brölande..nn.1
  bröllop_1_N : N ; -- bröllop..nn.1
  bröllopsbuss_1_N : N ; -- bröllopsbuss..nn.1
  bröllopsdag_1_N : N ; -- bröllopsdag..nn.1
  bröllopsdikt_1_N : N ; -- bröllopsdikt..nn.1
  bröllopsfest_1_N : N ; -- bröllopsfest..nn.1
  bröllopsfoto_1_N : N ; -- bröllopsfoto..nn.1
  bröllopsgäst_1_N : N ; -- bröllopsgäst..nn.1
  bröllopsgåva_1_N : N ; -- bröllopsgåva..nn.1
  bröllopsinspirerad_1_A : A ; -- bröllopsinspirerad..av.1
  bröllopsklänning_1_N : N ; -- bröllopsklänning..nn.1
  bröllopsmarsch_1_N : N ; -- bröllopsmarsch..nn.1
  bröllopsmåltid_1_N : N ; -- bröllopsmåltid..nn.1
  bröllopsnatt_1_N : N ; -- bröllopsnatt..nn.1
  bröllopspar_1_N : N ; -- bröllopspar..nn.1
  bröllopsplan_1_N : N ; -- bröllopsplan..nn.1
  bröllopspoet_1_N : N ; -- bröllopspoet..nn.1
  bröllopspresent_1_N : N ; -- bröllopspresent..nn.1
  bröllopsresa_1_N : N ; -- bröllopsresa..nn.1
  bröllopsresmål_1_N : N ; -- bröllopsresmål..nn.1
  bröllopssed_1_N : N ; -- bröllopssed..nn.1
  bröllopssällskap_1_N : N ; -- bröllopssällskap..nn.1
  bröllopstårta_1_N : N ; -- bröllopstårta..nn.1
  bröllopsvideo_1_N : N ; -- bröllopsvideo..nn.1
  bröllopsvittne_1_N : N ; -- bröllopsvittne..nn.1
  bröllopsyra_1_N : N ; -- bröllopsyra..nn.1
  bröst_1_N : N ; -- bröst..nn.1
  brösta_1_N : N ; -- brösta..nn.1
  bröstarv_1_N : N ; -- bröstarv..nn.1
  bröstarvinge_1_N : N ; -- bröstarvinge..nn.1
  bröstbarn_1_N : N ; -- bröstbarn..nn.1
  bröstben_1_N : N ; -- bröstben..nn.1
  bröstbild_1_N : N ; -- bröstbild..nn.1
  bröstböld_1_N : N ; -- bröstböld..nn.1
  bröstcancer_1_N : N ; -- bröstcancer..nn.1
  bröstcancerdiagnos_1_N : N ; -- bröstcancerdiagnos..nn.1
  bröstcancerkirurgi_1_N : N ; -- bröstcancerkirurgi..nn.1
  bröstfena_1_N : N ; -- bröstfena..nn.1
  bröstficka_1_N : N ; -- bröstficka..nn.1
  bröstförstoring_1_N : N ; -- bröstförstoring..nn.1
  bröstgång_1_N : N ; -- bröstgång..nn.1
  brösthåla_1_N : N ; -- brösthåla..nn.1
  brösthöjd_1_N : N ; -- brösthöjd..nn.1
  bröstimplantat_1_N : N ; -- bröstimplantat..nn.1
  bröstingrepp_1_N : N ; -- bröstingrepp..nn.1
  bröstkaramell_1_N : N ; -- bröstkaramell..nn.1
  bröstkatarr_1_N : N ; -- bröstkatarr..nn.1
  bröstklang_1_N : N ; -- bröstklang..nn.1
  bröstknöl_1_N : N ; -- bröstknöl..nn.1
  bröstkompression_1_N : N ; -- bröstkompression..nn.1
  bröstkorg_1_N : N ; -- bröstkorg..nn.1
  bröstkota_1_N : N ; -- bröstkota..nn.1
  bröstkramp_1_N : N ; -- bröstkramp..nn.1
  bröstkörtel_1_N : N ; -- bröstkörtel..nn.1
  bröstlapp_1_N : N ; -- bröstlapp..nn.1
  bröstlidande_1_N : N ; -- bröstlidande..nn.1
  bröstmjölk_1_N : N ; -- bröstmjölk..nn.1
  bröstmjölkspumpsutspel_1_N : N ; -- bröstmjölkspumpsutspel..nn.1
  bröstmur_1_N : N ; -- bröstmur..nn.1
  bröstmuskel_1_N : N ; -- bröstmuskel..nn.1
  bröstmått_1_N : N ; -- bröstmått..nn.1
  bröstning_1_N : N ; -- bröstning..nn.1
  bröstoperation_1_N : N ; -- bröstoperation..nn.1
  bröstparti_1_N : N ; -- bröstparti..nn.1
  bröstpatient_1_N : N ; -- bröstpatient..nn.1
  bröstpump_1_N : N ; -- bröstpump..nn.1
  bröstpumpsutspel_1_N : N ; -- bröstpumpsutspel..nn.1
  bröstregister_1_N : N ; -- bröstregister..nn.1
  bröstsimmare_1_N : N ; -- bröstsimmare..nn.1
  bröstsimtag_1_N : N ; -- bröstsimtag..nn.1
  bröstsjuk_1_A : A ; -- bröstsjuk..av.1
  bröstskydd_1_N : N ; -- bröstskydd..nn.1
  bröstsocker_1_N : N ; -- bröstsocker..nn.1
  bröstsugande_1_A : A ; -- bröstsugande..av.1
  bröstton_1_N : N ; -- bröstton..nn.1
  bröstvidd_1_N : N ; -- bröstvidd..nn.1
  bröstvärk_1_N : N ; -- bröstvärk..nn.1
  bröstvärn_1_N : N ; -- bröstvärn..nn.1
  bröstvårta_1_N : N ; -- bröstvårta..nn.1
  bröt_1_N : N ; -- bröt..nn.1
  bröthake_1_N : N ; -- bröthake..nn.1
  brötling_1_N : N ; -- brötling..nn.1
  bua_1_V : V ; -- bua..vb.1
  buande_1_N : N ; -- buande..nn.1
  bubba_1_V : V ; -- bubba..vb.1
  bubbande_1_N : N ; -- bubbande..nn.1
  bubbel_1_N : N ; -- bubbel..nn.1
  bubbelbad_1_N : N ; -- bubbelbad..nn.1
  bubbelbadkar_1_N : N ; -- bubbelbadkar..nn.1
  bubbelgum_1_N : N ; -- bubbelgum..nn.1
  bubbelkammare_1_N : N ; -- bubbelkammare..nn.1
  bubbelpool_1_N : N ; -- bubbelpool..nn.1
  bubbla_1_N : N ; -- bubbla..nn.1
  bubbla_1_V : V ; -- bubbla..vb.1
  bubblande_1_N : N ; -- bubblande..nn.1
  bubblare_1_N : N ; -- bubblare..nn.1
  bubblig_1_A : A ; -- bubblig..av.1
  bubblighet_1_N : N ; -- bubblighet..nn.1
  bubon_1_N : N ; -- bubon..nn.1
  buckla_1_N : N ; -- buckla..nn.1
  bucklig_1_A : A ; -- bucklig..av.1
  bucklighet_1_N : N ; -- bucklighet..nn.1
  buckram_1_N : N ; -- buckram..nn.1
  bud_1_N : N ; -- bud..nn.1
  buda_1_V : V ; -- buda..vb.1
  budande_1_N : N ; -- budande..nn.1
  budbyrå_1_N : N ; -- budbyrå..nn.1
  budbärare_1_N : N ; -- budbärare..nn.1
  buddha_1_N : N ; -- buddha..nn.1
  buddhism_1_N : N ; -- buddhism..nn.1
  buddhist_1_N : N ; -- buddhist..nn.1
  buddhistisk_1_A : A ; -- buddhistisk..av.1
  buddism_1_N : N ; -- buddism..nn.1
  buddist_1_N : N ; -- buddist..nn.1
  buddistisk_1_A : A ; -- buddistisk..av.1
  budget_1_N : N ; -- budget..nn.1
  budgetalternativ_1_N : N ; -- budgetalternativ..nn.1
  budgetansvarig_1_A : A ; -- budgetansvarig..av.1
  budgetarbete_1_N : N ; -- budgetarbete..nn.1
  budgetdisciplin_1_N : N ; -- budgetdisciplin..nn.1
  budgetera_1_V : V ; -- budgetera..vb.1
  budgeterande_1_N : N ; -- budgeterande..nn.1
  budgeterare_1_N : N ; -- budgeterare..nn.1
  budgeterbar_1_A : A ; -- budgeterbar..av.1
  budgeterbarhet_1_N : N ; -- budgeterbarhet..nn.1
  budgetering_1_N : N ; -- budgetering..nn.1
  budgetflyg_1_N : N ; -- budgetflyg..nn.1
  budgetförordning_1_N : N ; -- budgetförordning..nn.1
  budgetförslag_1_N : N ; -- budgetförslag..nn.1
  budgetmotion_1_N : N ; -- budgetmotion..nn.1
  budgetmässig_1_A : A ; -- budgetmässig..av.1
  budgetpolitik_1_N : N ; -- budgetpolitik..nn.1
  budgetpolitisk_1_A : A ; -- budgetpolitisk..av.1
  budgetproposition_1_N : N ; -- budgetproposition..nn.1
  budgetresa_1_N : N ; -- budgetresa..nn.1
  budgetsanering_1_N : N ; -- budgetsanering..nn.1
  budgetspa_1_N : N ; -- budgetspa..nn.1
  budgetstup_1_N : N ; -- budgetstup..nn.1
  budgetunderskott_1_N : N ; -- budgetunderskott..nn.1
  budgetvariant_1_N : N ; -- budgetvariant..nn.1
  budgetär_1_A : A ; -- budgetär..av.1
  budgetår_1_N : N ; -- budgetår..nn.1
  budgetöverskott_1_N : N ; -- budgetöverskott..nn.1
  budgivning_1_N : N ; -- budgivning..nn.1
  budkavel_1_N : N ; -- budkavel..nn.1
  budkavle_1_N : N ; -- budkavle..nn.1
  budkavlelöpning_1_N : N ; -- budkavlelöpning..nn.1
  budning_1_N : N ; -- budning..nn.1
  budo_1_N : N ; -- budo..nn.1
  budoar_1_N : N ; -- budoar..nn.1
  budoarmässig_1_A : A ; -- budoarmässig..av.1
  budord_1_N : N ; -- budord..nn.1
  budskap_1_N : N ; -- budskap..nn.1
  buff_1_N : N ; -- buff..nn.1
  buffa_1_N : N ; -- buffa..nn.1
  buffa_1_V : V ; -- buffa..vb.1
  buffande_1_N : N ; -- buffande..nn.1
  buffaopera_1_N : N ; -- buffaopera..nn.1
  buffel_1_N : N ; -- buffel..nn.1
  buffelaktig_1_A : A ; -- buffelaktig..av.1
  buffelaktighet_1_N : N ; -- buffelaktighet..nn.1
  buffelhjord_1_N : N ; -- buffelhjord..nn.1
  buffert_1_N : N ; -- buffert..nn.1
  buffertkapacitet_1_N : N ; -- buffertkapacitet..nn.1
  buffertlager_1_N : N ; -- buffertlager..nn.1
  buffertlösning_1_N : N ; -- buffertlösning..nn.1
  buffertstat_1_N : N ; -- buffertstat..nn.1
  bufflig_1_A : A ; -- bufflig..av.1
  bufflighet_1_N : N ; -- bufflighet..nn.1
  buffra_1_V : V ; -- buffra..vb.1
  buffrande_1_N : N ; -- buffrande..nn.1
  buffringsförmåga_1_N : N ; -- buffringsförmåga..nn.1
  buffé_1_N : N ; -- buffé..nn.1
  bug_1_N : N ; -- bug..nn.1
  buga_1_V : V ; -- buga..vb.1
  bugande_1_N : N ; -- bugande..nn.1
  bugg_1_N : N ; -- bugg..nn.1
  bugg_2_N : N ; -- bugg..nn.2
  bugga_1_V : V ; -- bugga..vb.1
  buggande_1_N : N ; -- buggande..nn.1
  buggfix_1_N : N ; -- buggfix..nn.1
  buggning_1_N : N ; -- buggning..nn.1
  bugning_1_N : N ; -- bugning..nn.1
  buk_1_N : N ; -- buk..nn.1
  bukett_1_N : N ; -- bukett..nn.1
  bukettgrönt_1_N : N ; -- bukettgrönt..nn.1
  bukfetma_1_N : N ; -- bukfetma..nn.1
  bukfett_1_N : N ; -- bukfett..nn.1
  bukfettslager_1_N : N ; -- bukfettslager..nn.1
  bukformig_1_A : A ; -- bukformig..av.1
  bukfylla_1_N : N ; -- bukfylla..nn.1
  bukfyllnad_1_N : N ; -- bukfyllnad..nn.1
  bukgjord_1_N : N ; -- bukgjord..nn.1
  bukhinna_1_N : N ; -- bukhinna..nn.1
  bukhinneinflammation_1_N : N ; -- bukhinneinflammation..nn.1
  bukhåla_1_N : N ; -- bukhåla..nn.1
  bukig_1_A : A ; -- bukig..av.1
  bukighet_1_N : N ; -- bukighet..nn.1
  buklanda_1_V : V ; -- buklanda..vb.1
  buklandande_1_N : N ; -- buklandande..nn.1
  bukmuskel_1_N : N ; -- bukmuskel..nn.1
  bukolisk_1_A : A ; -- bukolisk..av.1
  bukskott_1_N : N ; -- bukskott..nn.1
  bukspott_1_N : N ; -- bukspott..nn.1
  bukspottkörtel_1_N : N ; -- bukspottkörtel..nn.1
  bukstinn_1_A : A ; -- bukstinn..av.1
  bukstinnhet_1_N : N ; -- bukstinnhet..nn.1
  buksvåger_1_N : N ; -- buksvåger..nn.1
  bukt_1_N : N ; -- bukt..nn.1
  bukta_1_V : V ; -- bukta..vb.1
  buktala_1_V : V ; -- buktala..vb.1
  buktalande_1_N : N ; -- buktalande..nn.1
  buktalare_1_N : N ; -- buktalare..nn.1
  buktaleri_1_N : N ; -- buktaleri..nn.1
  buktande_1_N : N ; -- buktande..nn.1
  buktig_1_A : A ; -- buktig..av.1
  buktighet_1_N : N ; -- buktighet..nn.1
  buktning_1_N : N ; -- buktning..nn.1
  bukvägg_1_N : N ; -- bukvägg..nn.1
  bukvätska_1_N : N ; -- bukvätska..nn.1
  bula_1_N : N ; -- bula..nn.1
  bulb_1_N : N ; -- bulb..nn.1
  bulbjärn_1_N : N ; -- bulbjärn..nn.1
  buldan_1_N : N ; -- buldan..nn.1
  bulemi_1_N : N ; -- bulemi..nn.1
  bulemiker_1_N : N ; -- bulemiker..nn.1
  bulevard_1_N : N ; -- bulevard..nn.1
  bulgar_1_N : N ; -- bulgar..nn.1
  bulgarisk_1_A : A ; -- bulgarisk..av.1
  bulgariska_1_N : N ; -- bulgariska..nn.1
  bulgariska_2_N : N ; -- bulgariska..nn.2
  bulgur_1_N : N ; -- bulgur..nn.1
  bulimi_1_N : N ; -- bulimi..nn.1
  bulimiker_1_N : N ; -- bulimiker..nn.1
  buljong_1_N : N ; -- buljong..nn.1
  buljongben_1_N : N ; -- buljongben..nn.1
  buljongkött_1_N : N ; -- buljongkött..nn.1
  buljongtärning_1_N : N ; -- buljongtärning..nn.1
  bulk_1_N : N ; -- bulk..nn.1
  bulkfartyg_1_N : N ; -- bulkfartyg..nn.1
  bulklast_1_N : N ; -- bulklast..nn.1
  bulklastare_1_N : N ; -- bulklastare..nn.1
  bulkmedel_1_N : N ; -- bulkmedel..nn.1
  bulla_1_N : N ; -- bulla..nn.1
  bullbak_1_N : N ; -- bullbak..nn.1
  bulldogg_1_N : N ; -- bulldogg..nn.1
  bulldozer_1_N : N ; -- bulldozer..nn.1
  bulle_1_N : N ; -- bulle..nn.1
  buller_1_N : N ; -- buller..nn.1
  bullerbas_1_N : N ; -- bullerbas..nn.1
  bullerblomster_1_N : N ; -- bullerblomster..nn.1
  bullerdämpande_1_A : A ; -- bullerdämpande..av.1
  bullerdämpning_1_N : N ; -- bullerdämpning..nn.1
  bullerförminskande_1_A : A ; -- bullerförminskande..av.1
  bullerkrav_1_N : N ; -- bullerkrav..nn.1
  bullermatta_1_N : N ; -- bullermatta..nn.1
  bullersam_1_A : A ; -- bullersam..av.1
  bullersamhet_1_N : N ; -- bullersamhet..nn.1
  bullerskada_1_N : N ; -- bullerskada..nn.1
  bullerskärm_1_N : N ; -- bullerskärm..nn.1
  bullersten_1_N : N ; -- bullersten..nn.1
  bullerutsatt_1_A : A ; -- bullerutsatt..av.1
  bullervall_1_N : N ; -- bullervall..nn.1
  bullervägg_1_N : N ; -- bullervägg..nn.1
  bulletin_1_N : N ; -- bulletin..nn.1
  bullig_1_A : A ; -- bullig..av.1
  bullighet_1_N : N ; -- bullighet..nn.1
  bullra_1_V : V ; -- bullra..vb.1
  bullrande_1_N : N ; -- bullrande..nn.1
  bullrig_1_A : A ; -- bullrig..av.1
  bullrighet_1_N : N ; -- bullrighet..nn.1
  bullshit_1_N : N ; -- bullshit..nn.1
  bulna_1_V : V ; -- bulna..vb.1
  bulnad_1_N : N ; -- bulnad..nn.1
  bulnande_1_N : N ; -- bulnande..nn.1
  bulsig_1_A : A ; -- bulsig..av.1
  bulsighet_1_N : N ; -- bulsighet..nn.1
  bult_1_N : N ; -- bult..nn.1
  bulta_1_V : V ; -- bulta..vb.1
  bultande_1_N : N ; -- bultande..nn.1
  bulthuvud_1_N : N ; -- bulthuvud..nn.1
  bulthål_1_N : N ; -- bulthål..nn.1
  bultning_1_N : N ; -- bultning..nn.1
  bultpistol_1_N : N ; -- bultpistol..nn.1
  bultsax_1_N : N ; -- bultsax..nn.1
  bultskalle_1_N : N ; -- bultskalle..nn.1
  bulvan_1_N : N ; -- bulvan..nn.1
  bulvanverksamhet_1_N : N ; -- bulvanverksamhet..nn.1
  bumerang_1_N : N ; -- bumerang..nn.1
  bumling_1_N : N ; -- bumling..nn.1
  bums_1_Adv : Adv ; -- bums..ab.1
  bunden_1_A : A ; -- bunden..av.1
  bundenhet_1_N : N ; -- bundenhet..nn.1
  bundis_1_A : A ; -- bundis..av.1
  bundsförvant_1_N : N ; -- bundsförvant..nn.1
  bundsförvantskap_1_N : N ; -- bundsförvantskap..nn.1
  bungalow_1_N : N ; -- bungalow..nn.1
  bunke_1_N : N ; -- bunke..nn.1
  bunker_1_N : N ; -- bunker..nn.1
  bunkra_1_V : V ; -- bunkra..vb.1
  bunkrande_1_N : N ; -- bunkrande..nn.1
  bunkring_1_N : N ; -- bunkring..nn.1
  bunkringsolja_1_N : N ; -- bunkringsolja..nn.1
  bunkringsplats_1_N : N ; -- bunkringsplats..nn.1
  bunkringsstation_1_N : N ; -- bunkringsstation..nn.1
  bunkstål_1_N : N ; -- bunkstål..nn.1
  bunsenbrännare_1_N : N ; -- bunsenbrännare..nn.1
  bunt_1_N : N ; -- bunt..nn.1
  bunta_1_V : V ; -- bunta..vb.1
  buntande_1_N : N ; -- buntande..nn.1
  buntband_1_N : N ; -- buntband..nn.1
  buntmakare_1_N : N ; -- buntmakare..nn.1
  buntning_1_N : N ; -- buntning..nn.1
  buntvis_1_Adv : Adv ; -- buntvis..ab.1
  bur_1_N : N ; -- bur..nn.1
  burbrev_1_N : N ; -- burbrev..nn.1
  burdus_1_A : A ; -- burdus..av.1
  burfågel_1_N : N ; -- burfågel..nn.1
  burgarbar_1_N : N ; -- burgarbar..nn.1
  burgare_1_N : N ; -- burgare..nn.1
  burgarrestaurang_1_N : N ; -- burgarrestaurang..nn.1
  burgarställe_1_N : N ; -- burgarställe..nn.1
  burgen_1_A : A ; -- burgen..av.1
  burgenhet_1_N : N ; -- burgenhet..nn.1
  burgerbar_1_N : N ; -- burgerbar..nn.1
  burgerrestaurang_1_N : N ; -- burgerrestaurang..nn.1
  burgerställe_1_N : N ; -- burgerställe..nn.1
  burgund_1_N : N ; -- burgund..nn.1
  burgunder_1_N : N ; -- burgunder..nn.1
  burhöns_1_N : N ; -- burhöns..nn.1
  burk_1_N : N ; -- burk..nn.1
  burka_1_N : N ; -- burka..nn.1
  burka_1_V : V ; -- burka..vb.1
  burkaförbud_1_N : N ; -- burkaförbud..nn.1
  burkande_1_N : N ; -- burkande..nn.1
  burkhållare_1_N : N ; -- burkhållare..nn.1
  burkinier_1_N : N ; -- burkinier..nn.1
  burkinsk_1_A : A ; -- burkinsk..av.1
  burkinska_1_N : N ; -- burkinska..nn.1
  burkmat_1_N : N ; -- burkmat..nn.1
  burkslav_1_N : N ; -- burkslav..nn.1
  burköl_1_N : N ; -- burköl..nn.1
  burköppnare_1_N : N ; -- burköppnare..nn.1
  burlesk_1_A : A ; -- burlesk..av.1
  burlesk_1_N : N ; -- burlesk..nn.1
  burleskeri_1_N : N ; -- burleskeri..nn.1
  burman_1_N : N ; -- burman..nn.1
  burmansk_1_A : A ; -- burmansk..av.1
  burmanska_1_N : N ; -- burmanska..nn.1
  burmanska_2_N : N ; -- burmanska..nn.2
  burmes_1_N : N ; -- burmes..nn.1
  burmesisk_1_A : A ; -- burmesisk..av.1
  burmesiska_1_N : N ; -- burmesiska..nn.1
  burmesiska_2_N : N ; -- burmesiska..nn.2
  burnus_1_N : N ; -- burnus..nn.1
  burr_1_N : N ; -- burr..nn.1
  burrig_1_A : A ; -- burrig..av.1
  burrighet_1_N : N ; -- burrighet..nn.1
  burschikos_1_A : A ; -- burschikos..av.1
  burskap_1_N : N ; -- burskap..nn.1
  burspråk_1_N : N ; -- burspråk..nn.1
  burspråksfönster_1_N : N ; -- burspråksfönster..nn.1
  burundier_1_N : N ; -- burundier..nn.1
  burundisk_1_A : A ; -- burundisk..av.1
  burundiska_1_N : N ; -- burundiska..nn.1
  bus_1_N : N ; -- bus..nn.1
  busa_1_V : V ; -- busa..vb.1
  busande_1_N : N ; -- busande..nn.1
  buse_1_N : N ; -- buse..nn.1
  busenkel_1_A : A ; -- busenkel..av.1
  busfason_1_N : N ; -- busfason..nn.1
  busfrö_1_N : N ; -- busfrö..nn.1
  bush_1_N : N ; -- bush..nn.1
  bushman_1_N : N ; -- bushman..nn.1
  busig_1_A : A ; -- busig..av.1
  busighet_1_N : N ; -- busighet..nn.1
  business_1_N : N ; -- business..nn.1
  buska_1_V : V ; -- buska..vb.1
  buska_2_V : V ; -- buska..vb.2
  buskablyg_1_A : A ; -- buskablyg..av.1
  buskablyghet_1_N : N ; -- buskablyghet..nn.1
  buskage_1_N : N ; -- buskage..nn.1
  buskagitation_1_N : N ; -- buskagitation..nn.1
  buskande_1_N : N ; -- buskande..nn.1
  buskartad_1_A : A ; -- buskartad..av.1
  buskbevuxen_1_A : A ; -- buskbevuxen..av.1
  buske_1_N : N ; -- buske..nn.1
  buskig_1_A : A ; -- buskig..av.1
  buskighet_1_N : N ; -- buskighet..nn.1
  buskis_1_N : N ; -- buskis..nn.1
  buskliknande_1_A : A ; -- buskliknande..av.1
  buskskvätta_1_N : N ; -- buskskvätta..nn.1
  busksly_1_N : N ; -- busksly..nn.1
  busksnår_1_N : N ; -- busksnår..nn.1
  buskteater_1_N : N ; -- buskteater..nn.1
  buskväxt_1_N : N ; -- buskväxt..nn.1
  buskörare_1_N : N ; -- buskörare..nn.1
  buskörning_1_N : N ; -- buskörning..nn.1
  busliv_1_N : N ; -- busliv..nn.1
  busringa_1_V : V ; -- busringa..vb.1
  busringande_1_N : N ; -- busringande..nn.1
  busringare_1_N : N ; -- busringare..nn.1
  busringning_1_N : N ; -- busringning..nn.1
  buss_1_A : A ; -- buss..av.1
  buss_1_N : N ; -- buss..nn.1
  bussa_1_V : V ; -- bussa..vb.1
  bussande_1_N : N ; -- bussande..nn.1
  bussankomst_1_N : N ; -- bussankomst..nn.1
  bussarong_1_N : N ; -- bussarong..nn.1
  bussavgång_1_N : N ; -- bussavgång..nn.1
  busschaufför_1_N : N ; -- busschaufför..nn.1
  bussförare_1_N : N ; -- bussförare..nn.1
  bussförbindelse_1_N : N ; -- bussförbindelse..nn.1
  busshållplats_1_N : N ; -- busshållplats..nn.1
  bussig_1_A : A ; -- bussig..av.1
  bussighet_1_N : N ; -- bussighet..nn.1
  busskort_1_N : N ; -- busskort..nn.1
  busskrock_1_N : N ; -- busskrock..nn.1
  busskur_1_N : N ; -- busskur..nn.1
  busslast_1_N : N ; -- busslast..nn.1
  busslinje_1_N : N ; -- busslinje..nn.1
  bussning_1_N : N ; -- bussning..nn.1
  busspassagerare_1_N : N ; -- busspassagerare..nn.1
  bussresa_1_N : N ; -- bussresa..nn.1
  busstation_1_N : N ; -- busstation..nn.1
  busstaxa_1_N : N ; -- busstaxa..nn.1
  bussterminal_1_N : N ; -- bussterminal..nn.1
  busstidtabell_1_N : N ; -- busstidtabell..nn.1
  busstrafik_1_N : N ; -- busstrafik..nn.1
  busstransport_1_N : N ; -- busstransport..nn.1
  busstur_1_N : N ; -- busstur..nn.1
  busunge_1_N : N ; -- busunge..nn.1
  busvissla_1_V : V ; -- busvissla..vb.1
  busvisslande_1_N : N ; -- busvisslande..nn.1
  busvissling_1_N : N ; -- busvissling..nn.1
  busväder_1_N : N ; -- busväder..nn.1
  butadien_1_N : N ; -- butadien..nn.1
  butan_1_N : N ; -- butan..nn.1
  butanol_1_N : N ; -- butanol..nn.1
  butelj_1_N : N ; -- butelj..nn.1
  buteljborste_1_N : N ; -- buteljborste..nn.1
  buteljbotten_1_N : N ; -- buteljbotten..nn.1
  buteljera_1_V : V ; -- buteljera..vb.1
  buteljerande_1_N : N ; -- buteljerande..nn.1
  buteljerbar_1_A : A ; -- buteljerbar..av.1
  buteljerbarhet_1_N : N ; -- buteljerbarhet..nn.1
  buteljering_1_N : N ; -- buteljering..nn.1
  buteljglas_1_N : N ; -- buteljglas..nn.1
  buteljgrön_1_A : A ; -- buteljgrön..av.1
  buteljlack_1_N : N ; -- buteljlack..nn.1
  butik_1_N : N ; -- butik..nn.1
  butiksanställd_1_A : A ; -- butiksanställd..av.1
  butiksbaka_1_V : V ; -- butiksbaka..vb.1
  butiksbakad_1_A : A ; -- butiksbakad..av.1
  butiksbiträde_1_N : N ; -- butiksbiträde..nn.1
  butiksdörr_1_N : N ; -- butiksdörr..nn.1
  butiksfönster_1_N : N ; -- butiksfönster..nn.1
  butiksinnehavare_1_N : N ; -- butiksinnehavare..nn.1
  butikskedja_1_N : N ; -- butikskedja..nn.1
  butiksrån_1_N : N ; -- butiksrån..nn.1
  butiksstängningslag_1_N : N ; -- butiksstängningslag..nn.1
  butikstjuv_1_N : N ; -- butikstjuv..nn.1
  butiksägare_1_N : N ; -- butiksägare..nn.1
  butler_1_N : N ; -- butler..nn.1
  butter_1_A : A ; -- butter..av.1
  butterhet_1_N : N ; -- butterhet..nn.1
  butterkaka_1_N : N ; -- butterkaka..nn.1
  butyl_1_N : N ; -- butyl..nn.1
  butylalkohol_1_N : N ; -- butylalkohol..nn.1
  buxbom_1_N : N ; -- buxbom..nn.1
  by_1_N : N ; -- by..nn.1
  byalag_1_N : N ; -- byalag..nn.1
  byamål_1_N : N ; -- byamål..nn.1
  bybo_1_N : N ; -- bybo..nn.1
  byffé_1_N : N ; -- byffé..nn.1
  byfogde_1_N : N ; -- byfogde..nn.1
  byfåne_1_N : N ; -- byfåne..nn.1
  bygata_1_N : N ; -- bygata..nn.1
  bygd_1_N : N ; -- bygd..nn.1
  bygdeborg_1_N : N ; -- bygdeborg..nn.1
  bygdegård_1_N : N ; -- bygdegård..nn.1
  bygdemål_1_N : N ; -- bygdemål..nn.1
  bygdepatriotism_1_N : N ; -- bygdepatriotism..nn.1
  bygel_1_N : N ; -- bygel..nn.1
  bygelhorn_1_N : N ; -- bygelhorn..nn.1
  bygelhäst_1_N : N ; -- bygelhäst..nn.1
  bygellås_1_N : N ; -- bygellås..nn.1
  bygelrem_1_N : N ; -- bygelrem..nn.1
  bygga_1_V : V ; -- bygga..vb.1
  byggande_1_N : N ; -- byggande..nn.1
  byggarbetare_1_N : N ; -- byggarbetare..nn.1
  byggarbetskran_1_N : N ; -- byggarbetskran..nn.1
  byggarbetsplats_1_N : N ; -- byggarbetsplats..nn.1
  byggare_1_N : N ; -- byggare..nn.1
  byggbeslag_1_N : N ; -- byggbeslag..nn.1
  byggcontainer_1_N : N ; -- byggcontainer..nn.1
  byggdamm_1_N : N ; -- byggdamm..nn.1
  byggdispens_1_N : N ; -- byggdispens..nn.1
  bygge_1_N : N ; -- bygge..nn.1
  byggelement_1_N : N ; -- byggelement..nn.1
  byggenskap_1_N : N ; -- byggenskap..nn.1
  byggfirma_1_N : N ; -- byggfirma..nn.1
  byggflopp_1_N : N ; -- byggflopp..nn.1
  byggföretag_1_N : N ; -- byggföretag..nn.1
  byggherre_1_N : N ; -- byggherre..nn.1
  byggjätte_1_N : N ; -- byggjätte..nn.1
  byggkloss_1_N : N ; -- byggkloss..nn.1
  byggkostnad_1_N : N ; -- byggkostnad..nn.1
  bygglag_1_N : N ; -- bygglag..nn.1
  bygglekplats_1_N : N ; -- bygglekplats..nn.1
  bygglov_1_N : N ; -- bygglov..nn.1
  bygglåda_1_N : N ; -- bygglåda..nn.1
  byggmaterial_1_N : N ; -- byggmaterial..nn.1
  byggmiss_1_N : N ; -- byggmiss..nn.1
  byggmästardotter_1_N : N ; -- byggmästardotter..nn.1
  byggmästare_1_N : N ; -- byggmästare..nn.1
  byggnad_1_N : N ; -- byggnad..nn.1
  byggnadsarbetare_1_N : N ; -- byggnadsarbetare..nn.1
  byggnadsbråte_1_N : N ; -- byggnadsbråte..nn.1
  byggnadsfirma_1_N : N ; -- byggnadsfirma..nn.1
  byggnadsföretag_1_N : N ; -- byggnadsföretag..nn.1
  byggnadsindustri_1_N : N ; -- byggnadsindustri..nn.1
  byggnadskomplex_1_N : N ; -- byggnadskomplex..nn.1
  byggnadskonst_1_N : N ; -- byggnadskonst..nn.1
  byggnadskonstruktion_1_N : N ; -- byggnadskonstruktion..nn.1
  byggnadskontor_1_N : N ; -- byggnadskontor..nn.1
  byggnadskredit_1_N : N ; -- byggnadskredit..nn.1
  byggnadskreditiv_1_N : N ; -- byggnadskreditiv..nn.1
  byggnadslov_1_N : N ; -- byggnadslov..nn.1
  byggnadslån_1_N : N ; -- byggnadslån..nn.1
  byggnadsmaterial_1_N : N ; -- byggnadsmaterial..nn.1
  byggnadsminne_1_N : N ; -- byggnadsminne..nn.1
  byggnadsmässig_1_A : A ; -- byggnadsmässig..av.1
  byggnadsnämnd_1_N : N ; -- byggnadsnämnd..nn.1
  byggnadsplan_1_N : N ; -- byggnadsplan..nn.1
  byggnadsplats_1_N : N ; -- byggnadsplats..nn.1
  byggnadssnickare_1_N : N ; -- byggnadssnickare..nn.1
  byggnadssockel_1_N : N ; -- byggnadssockel..nn.1
  byggnadssten_1_N : N ; -- byggnadssten..nn.1
  byggnadsstil_1_N : N ; -- byggnadsstil..nn.1
  byggnadsstomme_1_N : N ; -- byggnadsstomme..nn.1
  byggnadsstyrelse_1_N : N ; -- byggnadsstyrelse..nn.1
  byggnadsställning_1_N : N ; -- byggnadsställning..nn.1
  byggnadssätt_1_N : N ; -- byggnadssätt..nn.1
  byggnadsteknik_1_N : N ; -- byggnadsteknik..nn.1
  byggnadsteknisk_1_A : A ; -- byggnadsteknisk..av.1
  byggnadstillstånd_1_N : N ; -- byggnadstillstånd..nn.1
  byggnadstimmer_1_N : N ; -- byggnadstimmer..nn.1
  byggnadsverk_1_N : N ; -- byggnadsverk..nn.1
  byggnadsvirke_1_N : N ; -- byggnadsvirke..nn.1
  byggnation_1_N : N ; -- byggnation..nn.1
  byggning_1_N : N ; -- byggning..nn.1
  byggnorm_1_N : N ; -- byggnorm..nn.1
  byggpass_1_N : N ; -- byggpass..nn.1
  byggplan_1_N : N ; -- byggplan..nn.1
  byggprojekt_1_N : N ; -- byggprojekt..nn.1
  byggsats_1_N : N ; -- byggsats..nn.1
  byggsektor_1_N : N ; -- byggsektor..nn.1
  byggstart_1_N : N ; -- byggstart..nn.1
  byggsten_1_N : N ; -- byggsten..nn.1
  byggstopp_1_N : N ; -- byggstopp..nn.1
  byggställning_1_N : N ; -- byggställning..nn.1
  byggtid_1_N : N ; -- byggtid..nn.1
  byggtork_1_N : N ; -- byggtork..nn.1
  byggvara_1_N : N ; -- byggvara..nn.1
  byggvaruhus_1_N : N ; -- byggvaruhus..nn.1
  byggvarukedja_1_N : N ; -- byggvarukedja..nn.1
  byhus_1_N : N ; -- byhus..nn.1
  byig_1_A : A ; -- byig..av.1
  byk_1_N : N ; -- byk..nn.1
  byka_1_V : V ; -- byka..vb.1
  bykande_1_N : N ; -- bykande..nn.1
  byke_1_N : N ; -- byke..nn.1
  bykgryta_1_N : N ; -- bykgryta..nn.1
  byling_1_N : N ; -- byling..nn.1
  bylsig_1_A : A ; -- bylsig..av.1
  bylsighet_1_N : N ; -- bylsighet..nn.1
  bylte_1_N : N ; -- bylte..nn.1
  bymoln_1_N : N ; -- bymoln..nn.1
  bymoské_1_N : N ; -- bymoské..nn.1
  byområde_1_N : N ; -- byområde..nn.1
  byordning_1_N : N ; -- byordning..nn.1
  byracka_1_N : N ; -- byracka..nn.1
  byrett_1_N : N ; -- byrett..nn.1
  byrå_1_N : N ; -- byrå..nn.1
  byrå_2_N : N ; -- byrå..nn.2
  byråassistent_1_N : N ; -- byråassistent..nn.1
  byråchef_1_N : N ; -- byråchef..nn.1
  byrådirektör_1_N : N ; -- byrådirektör..nn.1
  byråkrat_1_N : N ; -- byråkrat..nn.1
  byråkrati_1_N : N ; -- byråkrati..nn.1
  byråkratisera_1_V : V ; -- byråkratisera..vb.1
  byråkratiserande_1_N : N ; -- byråkratiserande..nn.1
  byråkratiserbar_1_A : A ; -- byråkratiserbar..av.1
  byråkratiserbarhet_1_N : N ; -- byråkratiserbarhet..nn.1
  byråkratisering_1_N : N ; -- byråkratisering..nn.1
  byråkratisk_1_A : A ; -- byråkratisk..av.1
  byråkratism_1_N : N ; -- byråkratism..nn.1
  byrålåda_1_N : N ; -- byrålåda..nn.1
  byråsekreterare_1_N : N ; -- byråsekreterare..nn.1
  bysamfällighet_1_N : N ; -- bysamfällighet..nn.1
  bysantin_1_N : N ; -- bysantin..nn.1
  bysantinism_1_N : N ; -- bysantinism..nn.1
  bysantinsk_1_A : A ; -- bysantinsk..av.1
  byskola_1_N : N ; -- byskola..nn.1
  bysnille_1_N : N ; -- bysnille..nn.1
  byssja_1_N : N ; -- byssja..nn.1
  byst_1_N : N ; -- byst..nn.1
  bystdrottning_1_N : N ; -- bystdrottning..nn.1
  bysthållare_1_N : N ; -- bysthållare..nn.1
  bystmått_1_N : N ; -- bystmått..nn.1
  bystämma_1_N : N ; -- bystämma..nn.1
  bysätta_1_V : V ; -- bysätta..vb.1
  bysättande_1_N : N ; -- bysättande..nn.1
  bysättning_1_N : N ; -- bysättning..nn.1
  byta_1_V : V ; -- byta..vb.1
  bytande_1_N : N ; -- bytande..nn.1
  byte_1_N : N ; -- byte..nn.1
  byte_2_N : N ; -- byte..nn.2
  bytesaffär_1_N : N ; -- bytesaffär..nn.1
  bytesartikel_1_N : N ; -- bytesartikel..nn.1
  bytesbalans_1_N : N ; -- bytesbalans..nn.1
  bytesbalansunderskott_1_N : N ; -- bytesbalansunderskott..nn.1
  bytesbalansöverskott_1_N : N ; -- bytesbalansöverskott..nn.1
  bytesbrev_1_N : N ; -- bytesbrev..nn.1
  bytesdjur_1_N : N ; -- bytesdjur..nn.1
  byteshandel_1_N : N ; -- byteshandel..nn.1
  byteshushållning_1_N : N ; -- byteshushållning..nn.1
  byteslägenhet_1_N : N ; -- byteslägenhet..nn.1
  bytesmedel_1_N : N ; -- bytesmedel..nn.1
  bytesobjekt_1_N : N ; -- bytesobjekt..nn.1
  bytesvara_1_N : N ; -- bytesvara..nn.1
  bytesvärde_1_N : N ; -- bytesvärde..nn.1
  byting_1_N : N ; -- byting..nn.1
  bytta_1_N : N ; -- bytta..nn.1
  byväg_1_N : N ; -- byväg..nn.1
  byx_1_N : N ; -- byx..nn.1
  byxa_1_N : N ; -- byxa..nn.1
  byxbak_1_N : N ; -- byxbak..nn.1
  byxben_1_N : N ; -- byxben..nn.1
  byxdress_1_N : N ; -- byxdress..nn.1
  byxdräkt_1_N : N ; -- byxdräkt..nn.1
  byxficka_1_N : N ; -- byxficka..nn.1
  byxholk_1_N : N ; -- byxholk..nn.1
  byxhälla_1_N : N ; -- byxhälla..nn.1
  byxis_1_A : A ; -- byxis..av.1
  byxkjol_1_N : N ; -- byxkjol..nn.1
  byxklämma_1_N : N ; -- byxklämma..nn.1
  byxklåda_1_N : N ; -- byxklåda..nn.1
  byxknä_1_N : N ; -- byxknä..nn.1
  byxlös_1_A : A ; -- byxlös..av.1
  byxlöshet_1_N : N ; -- byxlöshet..nn.1
  byxslag_1_N : N ; -- byxslag..nn.1
  byxångest_1_N : N ; -- byxångest..nn.1
  byäldste_1_N : N ; -- byäldste..nn.1
  bäbis_1_N : N ; -- bäbis..nn.1
  bäck_1_N : N ; -- bäck..nn.1
  bäckahäst_1_N : N ; -- bäckahäst..nn.1
  bäcken_1_N : N ; -- bäcken..nn.1
  bäckenben_1_N : N ; -- bäckenben..nn.1
  bäckenförträngning_1_N : N ; -- bäckenförträngning..nn.1
  bäckenhåla_1_N : N ; -- bäckenhåla..nn.1
  bäckenuppluckring_1_N : N ; -- bäckenuppluckring..nn.1
  bäckforell_1_N : N ; -- bäckforell..nn.1
  bäckmynning_1_N : N ; -- bäckmynning..nn.1
  bäckravin_1_N : N ; -- bäckravin..nn.1
  bäckröding_1_N : N ; -- bäckröding..nn.1
  bäckvatten_1_N : N ; -- bäckvatten..nn.1
  bäcköring_1_N : N ; -- bäcköring..nn.1
  bädd_1_N : N ; -- bädd..nn.1
  bädda_1_V : V ; -- bädda..vb.1
  bädda_2_V : V ; -- bädda..vb.2
  bäddande_1_N : N ; -- bäddande..nn.1
  bäddjacka_1_N : N ; -- bäddjacka..nn.1
  bäddning_1_N : N ; -- bäddning..nn.1
  bäddsoffa_1_N : N ; -- bäddsoffa..nn.1
  bäddutrustning_1_N : N ; -- bäddutrustning..nn.1
  bägare_1_N : N ; -- bägare..nn.1
  bägarkorall_1_N : N ; -- bägarkorall..nn.1
  bägarmanet_1_N : N ; -- bägarmanet..nn.1
  bägarsvamp_1_N : N ; -- bägarsvamp..nn.1
  bälg_1_N : N ; -- bälg..nn.1
  bälga_1_V : V ; -- bälga..vb.1
  bälgande_1_N : N ; -- bälgande..nn.1
  bälgformad_1_A : A ; -- bälgformad..av.1
  bälgkamera_1_N : N ; -- bälgkamera..nn.1
  bälgliknande_1_A : A ; -- bälgliknande..av.1
  bälgvante_1_N : N ; -- bälgvante..nn.1
  bälta_1_N : N ; -- bälta..nn.1
  bälta_1_V : V ; -- bälta..vb.1
  bältande_1_N : N ; -- bältande..nn.1
  bältdjur_1_N : N ; -- bältdjur..nn.1
  bälte_1_N : N ; -- bälte..nn.1
  bältesläggning_1_N : N ; -- bältesläggning..nn.1
  bältespännare_1_N : N ; -- bältespännare..nn.1
  bältestvång_1_N : N ; -- bältestvång..nn.1
  bältning_1_N : N ; -- bältning..nn.1
  bältros_1_N : N ; -- bältros..nn.1
  bända_1_V : V ; -- bända..vb.1
  bändande_1_N : N ; -- bändande..nn.1
  bändelband_1_N : N ; -- bändelband..nn.1
  bändjärn_1_N : N ; -- bändjärn..nn.1
  bändning_1_N : N ; -- bändning..nn.1
  bändsel_1_N : N ; -- bändsel..nn.1
  bändsla_1_V : V ; -- bändsla..vb.1
  bändslande_1_N : N ; -- bändslande..nn.1
  bäng_1_A : A ; -- bäng..av.1
  bängel_1_N : N ; -- bängel..nn.1
  bänghet_1_N : N ; -- bänghet..nn.1
  bänk_1_N : N ; -- bänk..nn.1
  bänka_1_V : V ; -- bänka..vb.1
  bänka_2_V : V ; -- bänka..vb.2
  bänkad_1_A : A ; -- bänkad..av.1
  bänkgranne_1_N : N ; -- bänkgranne..nn.1
  bänkkamrat_1_N : N ; -- bänkkamrat..nn.1
  bänknummer_1_N : N ; -- bänknummer..nn.1
  bänkplats_1_N : N ; -- bänkplats..nn.1
  bänkpress_1_N : N ; -- bänkpress..nn.1
  bänkrad_1_N : N ; -- bänkrad..nn.1
  bänkskåp_1_N : N ; -- bänkskåp..nn.1
  bänkslipmaskin_1_N : N ; -- bänkslipmaskin..nn.1
  bänkspis_1_N : N ; -- bänkspis..nn.1
  bänsel_1_N : N ; -- bänsel..nn.1
  bänsla_1_V : V ; -- bänsla..vb.1
  bänslande_1_N : N ; -- bänslande..nn.1
  bär_1_N : N ; -- bär..nn.1
  bära_1_V : V ; -- bära..vb.1
  bärande_1_A : A ; -- bärande..av.1
  bärande_1_N : N ; -- bärande..nn.1
  bärare_1_N : N ; -- bärare..nn.1
  bärarlag_1_N : N ; -- bärarlag..nn.1
  bärbar_1_A : A ; -- bärbar..av.1
  bärbarhet_1_N : N ; -- bärbarhet..nn.1
  bärbjälke_1_N : N ; -- bärbjälke..nn.1
  bärbuske_1_N : N ; -- bärbuske..nn.1
  bärfis_1_N : N ; -- bärfis..nn.1
  bärfrekvens_1_N : N ; -- bärfrekvens..nn.1
  bärga_1_V : V ; -- bärga..vb.1
  bärgande_1_N : N ; -- bärgande..nn.1
  bärgare_1_N : N ; -- bärgare..nn.1
  bärgarlön_1_N : N ; -- bärgarlön..nn.1
  bärgning_1_N : N ; -- bärgning..nn.1
  bärgningsbil_1_N : N ; -- bärgningsbil..nn.1
  bärgningsföretag_1_N : N ; -- bärgningsföretag..nn.1
  bärgningsledare_1_N : N ; -- bärgningsledare..nn.1
  bärgningspersonal_1_N : N ; -- bärgningspersonal..nn.1
  bärgningsväder_1_N : N ; -- bärgningsväder..nn.1
  bärhandtag_1_N : N ; -- bärhandtag..nn.1
  bärhjälp_1_N : N ; -- bärhjälp..nn.1
  bärig_1_A : A ; -- bärig..av.1
  bärighet_1_N : N ; -- bärighet..nn.1
  bäring_1_N : N ; -- bäring..nn.1
  bärkasse_1_N : N ; -- bärkasse..nn.1
  bärkotte_1_N : N ; -- bärkotte..nn.1
  bärkraft_1_N : N ; -- bärkraft..nn.1
  bärkraftig_1_A : A ; -- bärkraftig..av.1
  bärkraftighet_1_N : N ; -- bärkraftighet..nn.1
  bärlager_1_N : N ; -- bärlager..nn.1
  bärm_1_N : N ; -- bärm..nn.1
  bärmark_1_N : N ; -- bärmark..nn.1
  bärnstensfärgad_1_A : A ; -- bärnstensfärgad..av.1
  bärnstenssmycke_1_N : N ; -- bärnstenssmycke..nn.1
  bärnstenssyra_1_N : N ; -- bärnstenssyra..nn.1
  bärnäs_1_N : N ; -- bärnäs..nn.1
  bärnässås_1_N : N ; -- bärnässås..nn.1
  bärpelare_1_N : N ; -- bärpelare..nn.1
  bärplan_1_N : N ; -- bärplan..nn.1
  bärplansbåt_1_N : N ; -- bärplansbåt..nn.1
  bärplockare_1_N : N ; -- bärplockare..nn.1
  bärplockning_1_N : N ; -- bärplockning..nn.1
  bärpåse_1_N : N ; -- bärpåse..nn.1
  bärraket_1_N : N ; -- bärraket..nn.1
  bärrem_1_N : N ; -- bärrem..nn.1
  bärs_1_N : N ; -- bärs..nn.1
  bärs_2_N : N ; -- bärs..nn.2
  bärsa_1_N : N ; -- bärsa..nn.1
  bärsa_2_N : N ; -- bärsa..nn.2
  bärsa_1_V : V ; -- bärsa..vb.1
  bärsande_1_N : N ; -- bärsande..nn.1
  bärsele_1_N : N ; -- bärsele..nn.1
  bärstol_1_N : N ; -- bärstol..nn.1
  bärsärk_1_N : N ; -- bärsärk..nn.1
  bärsärkagång_1_N : N ; -- bärsärkagång..nn.1
  bärsärkaraseri_1_N : N ; -- bärsärkaraseri..nn.1
  bärvidd_1_N : N ; -- bärvidd..nn.1
  bärvin_1_N : N ; -- bärvin..nn.1
  bärvåg_1_N : N ; -- bärvåg..nn.1
  bäst_före_dag_1_N : N ; -- bäst-före-dag..nn.1
  bäst_före_datum_1_N : N ; -- bäst-före-datum..nn.1
  bästeman_1_N : N ; -- bästeman..nn.1
  bästföre_dag_1_N : N ; -- bästföre-dag..nn.1
  bästföre_datum_1_N : N ; -- bästföre-datum..nn.1
  bästföredag_1_N : N ; -- bästföredag..nn.1
  bästföredatum_1_N : N ; -- bästföredatum..nn.1
  bästis_1_N : N ; -- bästis..nn.1
  bästsäljande_1_A : A ; -- bästsäljande..av.1
  bästsäljare_1_N : N ; -- bästsäljare..nn.1
  bästsäljarism_1_N : N ; -- bästsäljarism..nn.1
  bästsäljarlista_1_N : N ; -- bästsäljarlista..nn.1
  bättra_1_V : V ; -- bättra..vb.1
  bättrande_1_N : N ; -- bättrande..nn.1
  bättring_1_N : N ; -- bättring..nn.1
  bäva_1_V : V ; -- bäva..vb.1
  bävande_1_N : N ; -- bävande..nn.1
  bäver_1_N : N ; -- bäver..nn.1
  bävergäll_1_N : N ; -- bävergäll..nn.1
  bävernylon_1_N : N ; -- bävernylon..nn.1
  bävernylonoverall_1_N : N ; -- bävernylonoverall..nn.1
  bäverpäls_1_N : N ; -- bäverpäls..nn.1
  bäverråtta_1_N : N ; -- bäverråtta..nn.1
  bävning_1_N : N ; -- bävning..nn.1
  båda_1_N : N ; -- båda..nn.1
  båda_1_V : V ; -- båda..vb.1
  bådande_1_N : N ; -- bådande..nn.1
  både_1_N : N ; -- både..nn.1
  båg_1_N : N ; -- båg..nn.1
  båga_1_V : V ; -- båga..vb.1
  bågande_1_N : N ; -- bågande..nn.1
  bågbro_1_N : N ; -- bågbro..nn.1
  båge_1_N : N ; -- båge..nn.1
  bågfil_1_N : N ; -- bågfil..nn.1
  bågform_1_N : N ; -- bågform..nn.1
  bågformad_1_A : A ; -- bågformad..av.1
  bågformig_1_A : A ; -- bågformig..av.1
  bågformighet_1_N : N ; -- bågformighet..nn.1
  bågfris_1_N : N ; -- bågfris..nn.1
  bågfält_1_N : N ; -- bågfält..nn.1
  bågfönster_1_N : N ; -- bågfönster..nn.1
  båggång_1_N : N ; -- båggång..nn.1
  bågig_1_A : A ; -- bågig..av.1
  båglampa_1_N : N ; -- båglampa..nn.1
  båglinje_1_N : N ; -- båglinje..nn.1
  bågljus_1_N : N ; -- bågljus..nn.1
  bågminut_1_N : N ; -- bågminut..nn.1
  bågna_1_V : V ; -- bågna..vb.1
  bågnande_1_N : N ; -- bågnande..nn.1
  bågsekund_1_N : N ; -- bågsekund..nn.1
  bågskytt_1_N : N ; -- bågskytt..nn.1
  bågskytte_1_N : N ; -- bågskytte..nn.1
  bågskyttefält_1_N : N ; -- bågskyttefält..nn.1
  bågsträng_1_N : N ; -- bågsträng..nn.1
  bågsvetsning_1_N : N ; -- bågsvetsning..nn.1
  bågsåg_1_N : N ; -- bågsåg..nn.1
  bågvalv_1_N : N ; -- bågvalv..nn.1
  båk_1_N : N ; -- båk..nn.1
  bål_1_N : N ; -- bål..nn.1
  bål_2_N : N ; -- bål..nn.2
  båld_1_A : A ; -- båld..av.1
  båldhet_1_N : N ; -- båldhet..nn.1
  bålgeting_1_N : N ; -- bålgeting..nn.1
  bålrullning_1_N : N ; -- bålrullning..nn.1
  bålrörelse_1_N : N ; -- bålrörelse..nn.1
  bålverk_1_N : N ; -- bålverk..nn.1
  bålväxt_1_N : N ; -- bålväxt..nn.1
  bångstyrig_1_A : A ; -- bångstyrig..av.1
  bångstyrighet_1_N : N ; -- bångstyrighet..nn.1
  bår_1_N : N ; -- bår..nn.1
  bårbärare_1_N : N ; -- bårbärare..nn.1
  bårbärning_1_N : N ; -- bårbärning..nn.1
  bård_1_N : N ; -- bård..nn.1
  bårdmönster_1_N : N ; -- bårdmönster..nn.1
  bårhus_1_N : N ; -- bårhus..nn.1
  bårlärka_1_N : N ; -- bårlärka..nn.1
  bås_1_N : N ; -- bås..nn.1
  båt_1_N : N ; -- båt..nn.1
  båta_1_V : V ; -- båta..vb.1
  båtande_1_N : N ; -- båtande..nn.1
  båtankomst_1_N : N ; -- båtankomst..nn.1
  båtavgång_1_N : N ; -- båtavgång..nn.1
  båtben_1_N : N ; -- båtben..nn.1
  båtbotten_1_N : N ; -- båtbotten..nn.1
  båtbrygga_1_N : N ; -- båtbrygga..nn.1
  båtbyggare_1_N : N ; -- båtbyggare..nn.1
  båtbygge_1_N : N ; -- båtbygge..nn.1
  båtbyggeri_1_N : N ; -- båtbyggeri..nn.1
  båtdäck_1_N : N ; -- båtdäck..nn.1
  båtfart_1_N : N ; -- båtfart..nn.1
  båtformig_1_A : A ; -- båtformig..av.1
  båtfärd_1_N : N ; -- båtfärd..nn.1
  båtgrav_1_N : N ; -- båtgrav..nn.1
  båthall_1_N : N ; -- båthall..nn.1
  båthus_1_N : N ; -- båthus..nn.1
  båtklubb_1_N : N ; -- båtklubb..nn.1
  båtliknande_1_A : A ; -- båtliknande..av.1
  båtlägenhet_1_N : N ; -- båtlägenhet..nn.1
  båtmotor_1_N : N ; -- båtmotor..nn.1
  båtmässa_1_N : N ; -- båtmässa..nn.1
  båtmössa_1_N : N ; -- båtmössa..nn.1
  båtnad_1_N : N ; -- båtnad..nn.1
  båtpendla_1_V : V ; -- båtpendla..vb.1
  båtpendlande_1_N : N ; -- båtpendlande..nn.1
  båtpendling_1_N : N ; -- båtpendling..nn.1
  båtplats_1_N : N ; -- båtplats..nn.1
  båtresa_1_N : N ; -- båtresa..nn.1
  båtshake_1_N : N ; -- båtshake..nn.1
  båtskjul_1_N : N ; -- båtskjul..nn.1
  båtskrå_1_N : N ; -- båtskrå..nn.1
  båtsman_1_N : N ; -- båtsman..nn.1
  båtsmansstol_1_N : N ; -- båtsmansstol..nn.1
  båtspant_1_N : N ; -- båtspant..nn.1
  båtterminal_1_N : N ; -- båtterminal..nn.1
  båttidtabell_1_N : N ; -- båttidtabell..nn.1
  båttrafik_1_N : N ; -- båttrafik..nn.1
  båttransport_1_N : N ; -- båttransport..nn.1
  båttur_1_N : N ; -- båttur..nn.1
  båttävling_1_N : N ; -- båttävling..nn.1
  båtutflykt_1_N : N ; -- båtutflykt..nn.1
  båtvagga_1_N : N ; -- båtvagga..nn.1
  båtvård_1_N : N ; -- båtvård..nn.1
  båtvårdsmedel_1_N : N ; -- båtvårdsmedel..nn.1
  båtyxa_1_N : N ; -- båtyxa..nn.1
  béarnaise_1_N : N ; -- béarnaise..nn.1
  béarnaisesås_1_N : N ; -- béarnaisesås..nn.1
  böckling_1_N : N ; -- böckling..nn.1
  bödel_1_N : N ; -- bödel..nn.1
  bödelsdräng_1_N : N ; -- bödelsdräng..nn.1
  bödelssvärd_1_N : N ; -- bödelssvärd..nn.1
  bödelsyxa_1_N : N ; -- bödelsyxa..nn.1
  bög_1_N : N ; -- bög..nn.1
  bögdöd_1_N : N ; -- bögdöd..nn.1
  bögporr_1_N : N ; -- bögporr..nn.1
  böhmare_1_N : N ; -- böhmare..nn.1
  böhmisk_1_A : A ; -- böhmisk..av.1
  böj_1_N : N ; -- böj..nn.1
  böja_1_V : V ; -- böja..vb.1
  böjande_1_N : N ; -- böjande..nn.1
  böjare_1_N : N ; -- böjare..nn.1
  böjarmuskel_1_N : N ; -- böjarmuskel..nn.1
  böjbar_1_A : A ; -- böjbar..av.1
  böjbarhet_1_N : N ; -- böjbarhet..nn.1
  böjd_1_A : A ; -- böjd..av.1
  böjdhet_1_N : N ; -- böjdhet..nn.1
  böjelse_1_N : N ; -- böjelse..nn.1
  böjhållfasthet_1_N : N ; -- böjhållfasthet..nn.1
  böjlig_1_A : A ; -- böjlig..av.1
  böjlighet_1_N : N ; -- böjlighet..nn.1
  böjmuskel_1_N : N ; -- böjmuskel..nn.1
  böjning_1_N : N ; -- böjning..nn.1
  böjningsexempel_1_N : N ; -- böjningsexempel..nn.1
  böjningsform_1_N : N ; -- böjningsform..nn.1
  böjningsmönster_1_N : N ; -- böjningsmönster..nn.1
  böjningssätt_1_N : N ; -- böjningssätt..nn.1
  böjningsändelse_1_N : N ; -- böjningsändelse..nn.1
  böjprov_1_N : N ; -- böjprov..nn.1
  böjträ_1_N : N ; -- böjträ..nn.1
  bök_1_N : N ; -- bök..nn.1
  böka_1_V : V ; -- böka..vb.1
  bökande_1_N : N ; -- bökande..nn.1
  bökig_1_A : A ; -- bökig..av.1
  bökning_1_N : N ; -- bökning..nn.1
  böl_1_N : N ; -- böl..nn.1
  böla_1_V : V ; -- böla..vb.1
  bölande_1_N : N ; -- bölande..nn.1
  böld_1_N : N ; -- böld..nn.1
  böldpest_1_N : N ; -- böldpest..nn.1
  bölja_1_N : N ; -- bölja..nn.1
  bölja_1_V : V ; -- bölja..vb.1
  böljande_1_N : N ; -- böljande..nn.1
  böljegång_1_N : N ; -- böljegång..nn.1
  böljeslag_1_N : N ; -- böljeslag..nn.1
  böljeslagsmärke_1_N : N ; -- böljeslagsmärke..nn.1
  bölning_1_N : N ; -- bölning..nn.1
  bön_1_N : N ; -- bön..nn.1
  böna_1_N : N ; -- böna..nn.1
  böna_1_V : V ; -- böna..vb.1
  bönande_1_N : N ; -- bönande..nn.1
  bönbok_1_N : N ; -- bönbok..nn.1
  böndag_1_N : N ; -- böndag..nn.1
  böneanrop_1_N : N ; -- böneanrop..nn.1
  bönegudstjänst_1_N : N ; -- bönegudstjänst..nn.1
  bönehus_1_N : N ; -- bönehus..nn.1
  böneman_1_N : N ; -- böneman..nn.1
  bönematta_1_N : N ; -- bönematta..nn.1
  bönemöte_1_N : N ; -- bönemöte..nn.1
  böneramp_1_N : N ; -- böneramp..nn.1
  bönerum_1_N : N ; -- bönerum..nn.1
  bönesal_1_N : N ; -- bönesal..nn.1
  böneskrift_1_N : N ; -- böneskrift..nn.1
  bönestund_1_N : N ; -- bönestund..nn.1
  böneutropare_1_N : N ; -- böneutropare..nn.1
  bönfalla_1_V : V ; -- bönfalla..vb.1
  bönfallande_1_N : N ; -- bönfallande..nn.1
  bönformig_1_A : A ; -- bönformig..av.1
  böngrodd_1_N : N ; -- böngrodd..nn.1
  bönhas_1_N : N ; -- bönhas..nn.1
  bönhus_1_N : N ; -- bönhus..nn.1
  bönhöra_1_V : V ; -- bönhöra..vb.1
  bönhörande_1_N : N ; -- bönhörande..nn.1
  bönhörelse_1_N : N ; -- bönhörelse..nn.1
  bönkaffe_1_N : N ; -- bönkaffe..nn.1
  bönlig_1_A : A ; -- bönlig..av.1
  bönpall_1_N : N ; -- bönpall..nn.1
  bönskida_1_N : N ; -- bönskida..nn.1
  bönväxt_1_N : N ; -- bönväxt..nn.1
  böra_1_V : V ; -- böra..vb.1
  börande_1_N : N ; -- börande..nn.1
  börd_1_N : N ; -- börd..nn.1
  börda_1_N : N ; -- börda..nn.1
  bördig_1_A : A ; -- bördig..av.1
  bördig_2_A : A ; -- bördig..av.2
  bördighet_1_N : N ; -- bördighet..nn.1
  bördsadel_1_N : N ; -- bördsadel..nn.1
  bördsaristokrati_1_N : N ; -- bördsaristokrati..nn.1
  bördshögfärd_1_N : N ; -- bördshögfärd..nn.1
  bördsrätt_1_N : N ; -- bördsrätt..nn.1
  bördsstolt_1_A : A ; -- bördsstolt..av.1
  bördsstolthet_1_N : N ; -- bördsstolthet..nn.1
  börja_1_V : V ; -- börja..vb.1
  börja_2_V : V ; -- börja..vb.2
  börjande_1_N : N ; -- börjande..nn.1
  börs_1_N : N ; -- börs..nn.1
  börs_2_N : N ; -- börs..nn.2
  börsanalys_1_N : N ; -- börsanalys..nn.1
  börsanalytiker_1_N : N ; -- börsanalytiker..nn.1
  börsbolag_1_N : N ; -- börsbolag..nn.1
  börsjobbare_1_N : N ; -- börsjobbare..nn.1
  börskaos_1_N : N ; -- börskaos..nn.1
  börskrasch_1_N : N ; -- börskrasch..nn.1
  börskurs_1_N : N ; -- börskurs..nn.1
  börsmäklare_1_N : N ; -- börsmäklare..nn.1
  börsmässig_1_A : A ; -- börsmässig..av.1
  börsnotera_1_V : V ; -- börsnotera..vb.1
  börsnoterande_1_N : N ; -- börsnoterande..nn.1
  börsnoterbar_1_A : A ; -- börsnoterbar..av.1
  börsnoterbarhet_1_N : N ; -- börsnoterbarhet..nn.1
  börsnotering_1_N : N ; -- börsnotering..nn.1
  börsoro_1_N : N ; -- börsoro..nn.1
  börsras_1_N : N ; -- börsras..nn.1
  börssal_1_N : N ; -- börssal..nn.1
  börsspekulant_1_N : N ; -- börsspekulant..nn.1
  börsspekulation_1_N : N ; -- börsspekulation..nn.1
  börsstyrelse_1_N : N ; -- börsstyrelse..nn.1
  börstelegraf_1_N : N ; -- börstelegraf..nn.1
  börsuppgång_1_N : N ; -- börsuppgång..nn.1
  börsutveckling_1_N : N ; -- börsutveckling..nn.1
  börsyra_1_N : N ; -- börsyra..nn.1
  börting_1_N : N ; -- börting..nn.1
  bössa_1_N : N ; -- bössa..nn.1
  bösshåll_1_N : N ; -- bösshåll..nn.1
  bössinsamling_1_N : N ; -- bössinsamling..nn.1
  bösta_1_V : V ; -- bösta..vb.1
  böstande_1_N : N ; -- böstande..nn.1
  böta_1_V : V ; -- böta..vb.1
  bötande_1_N : N ; -- bötande..nn.1
  bötesbelopp_1_N : N ; -- bötesbelopp..nn.1
  bötesstraff_1_N : N ; -- bötesstraff..nn.1
  bötessumma_1_N : N ; -- bötessumma..nn.1
  bötfälla_1_V : V ; -- bötfälla..vb.1
  bötfällande_1_N : N ; -- bötfällande..nn.1
  bövel_1_N : N ; -- bövel..nn.1
  cab_1_N : N ; -- cab..nn.1
  cabb_1_N : N ; -- cabb..nn.1
  cabotage_1_N : N ; -- cabotage..nn.1
  cabriolet_1_N : N ; -- cabriolet..nn.1
  caddie_1_N : N ; -- caddie..nn.1
  cafe_1_N : N ; -- cafe..nn.1
  cafeteria_1_N : N ; -- cafeteria..nn.1
  café_1_N : N ; -- café..nn.1
  cafébord_1_N : N ; -- cafébord..nn.1
  caldera_1_N : N ; -- caldera..nn.1
  californium_1_N : N ; -- californium..nn.1
  callcenter_1_N : N ; -- callcenter..nn.1
  callgirl_1_N : N ; -- callgirl..nn.1
  calmettevaccinering_1_N : N ; -- calmettevaccinering..nn.1
  calvados_1_N : N ; -- calvados..nn.1
  calypso_1_N : N ; -- calypso..nn.1
  calzone_1_N : N ; -- calzone..nn.1
  camembert_1_N : N ; -- camembert..nn.1
  camorra_1_N : N ; -- camorra..nn.1
  camouflage_1_N : N ; -- camouflage..nn.1
  camouflera_1_V : V ; -- camouflera..vb.1
  camouflerande_1_N : N ; -- camouflerande..nn.1
  camouflerbar_1_A : A ; -- camouflerbar..av.1
  camouflerbarhet_1_N : N ; -- camouflerbarhet..nn.1
  camouflering_1_N : N ; -- camouflering..nn.1
  camp_1_A : A ; -- camp..av.1
  campa_1_V : V ; -- campa..vb.1
  campande_1_N : N ; -- campande..nn.1
  campare_1_N : N ; -- campare..nn.1
  camphet_1_N : N ; -- camphet..nn.1
  camping_1_N : N ; -- camping..nn.1
  campingkök_1_N : N ; -- campingkök..nn.1
  campinglampa_1_N : N ; -- campinglampa..nn.1
  campingplats_1_N : N ; -- campingplats..nn.1
  campingstuga_1_N : N ; -- campingstuga..nn.1
  campus_1_N : N ; -- campus..nn.1
  canasta_1_N : N ; -- canasta..nn.1
  cancan_1_N : N ; -- cancan..nn.1
  cancer_1_N : N ; -- cancer..nn.1
  cancerbehandling_1_N : N ; -- cancerbehandling..nn.1
  cancerbekämpning_1_N : N ; -- cancerbekämpning..nn.1
  cancerfall_1_N : N ; -- cancerfall..nn.1
  cancerfara_1_N : N ; -- cancerfara..nn.1
  cancerform_1_N : N ; -- cancerform..nn.1
  cancerforskare_1_N : N ; -- cancerforskare..nn.1
  cancerforskning_1_N : N ; -- cancerforskning..nn.1
  cancerframkallande_1_A : A ; -- cancerframkallande..av.1
  cancerogen_1_A : A ; -- cancerogen..av.1
  cancerogen_1_N : N ; -- cancerogen..nn.1
  cancerrisk_1_N : N ; -- cancerrisk..nn.1
  cancersjuk_1_A : A ; -- cancersjuk..av.1
  cancerspridning_1_N : N ; -- cancerspridning..nn.1
  cancersvulst_1_N : N ; -- cancersvulst..nn.1
  cancertumör_1_N : N ; -- cancertumör..nn.1
  canceruppföljning_1_N : N ; -- canceruppföljning..nn.1
  candela_1_N : N ; -- candela..nn.1
  cannabis_1_N : N ; -- cannabis..nn.1
  cannabisodling_1_N : N ; -- cannabisodling..nn.1
  cannabisplanta_1_N : N ; -- cannabisplanta..nn.1
  canossavandring_1_N : N ; -- canossavandring..nn.1
  cantilena_1_N : N ; -- cantilena..nn.1
  cape_1_N : N ; -- cape..nn.1
  cappuccino_1_N : N ; -- cappuccino..nn.1
  cappuccinokopp_1_N : N ; -- cappuccinokopp..nn.1
  carambole_1_N : N ; -- carambole..nn.1
  carcinogen_1_A : A ; -- carcinogen..av.1
  carcinogen_1_N : N ; -- carcinogen..nn.1
  cardigan_1_N : N ; -- cardigan..nn.1
  carpa_1_V : V ; -- carpa..vb.1
  cartesiansk_1_A : A ; -- cartesiansk..av.1
  casanova_1_N : N ; -- casanova..nn.1
  cash_1_N : N ; -- cash..nn.1
  cashew_1_N : N ; -- cashew..nn.1
  cashewnöt_1_N : N ; -- cashewnöt..nn.1
  casino_1_N : N ; -- casino..nn.1
  casting_1_N : N ; -- casting..nn.1
  catch_as_catch_can_1_N : N ; -- catch-as-catch-can..nn.1
  catera_1_V : V ; -- catera..vb.1
  caterande_1_N : N ; -- caterande..nn.1
  catering_1_N : N ; -- catering..nn.1
  cateringbransch_1_N : N ; -- cateringbransch..nn.1
  caterpillar_1_N : N ; -- caterpillar..nn.1
  catgut_1_N : N ; -- catgut..nn.1
  catwalk_1_N : N ; -- catwalk..nn.1
  catwalka_1_V : V ; -- catwalka..vb.1
  catwalkande_1_N : N ; -- catwalkande..nn.1
  cavatina_1_N : N ; -- cavatina..nn.1
  cd_rom_1_N : N ; -- cd-rom..nn.1
  cd_spelare_1_N : N ; -- cd-spelare..nn.1
  ceder_1_N : N ; -- ceder..nn.1
  cedera_1_V : V ; -- cedera..vb.1
  cederande_1_N : N ; -- cederande..nn.1
  cederbar_1_A : A ; -- cederbar..av.1
  cederbarhet_1_N : N ; -- cederbarhet..nn.1
  cedering_1_N : N ; -- cedering..nn.1
  cederskog_1_N : N ; -- cederskog..nn.1
  cedilj_1_N : N ; -- cedilj..nn.1
  cediljtecken_1_N : N ; -- cediljtecken..nn.1
  cedrat_1_N : N ; -- cedrat..nn.1
  cedroolja_1_N : N ; -- cedroolja..nn.1
  celeber_1_A : A ; -- celeber..av.1
  celebrera_1_V : V ; -- celebrera..vb.1
  celebrerande_1_N : N ; -- celebrerande..nn.1
  celebrerbar_1_A : A ; -- celebrerbar..av.1
  celebrerbarhet_1_N : N ; -- celebrerbarhet..nn.1
  celebrering_1_N : N ; -- celebrering..nn.1
  celebritet_1_N : N ; -- celebritet..nn.1
  celebritetsjournalistik_1_N : N ; -- celebritetsjournalistik..nn.1
  celest_1_A : A ; -- celest..av.1
  celesta_1_N : N ; -- celesta..nn.1
  celibat_1_N : N ; -- celibat..nn.1
  celibatliv_1_N : N ; -- celibatliv..nn.1
  celibatlöfte_1_N : N ; -- celibatlöfte..nn.1
  cell_1_N : N ; -- cell..nn.1
  cella_1_N : N ; -- cella..nn.1
  cellandning_1_N : N ; -- cellandning..nn.1
  cellbildning_1_N : N ; -- cellbildning..nn.1
  cellbiologi_1_N : N ; -- cellbiologi..nn.1
  celldelning_1_N : N ; -- celldelning..nn.1
  cellfängelse_1_N : N ; -- cellfängelse..nn.1
  cellgift_1_N : N ; -- cellgift..nn.1
  cellgiftsbehandling_1_N : N ; -- cellgiftsbehandling..nn.1
  cellgranne_1_N : N ; -- cellgranne..nn.1
  cellini_1_N : N ; -- cellini..nn.1
  cellist_1_N : N ; -- cellist..nn.1
  cellkamrat_1_N : N ; -- cellkamrat..nn.1
  cellkärna_1_N : N ; -- cellkärna..nn.1
  cellmembran_1_N : N ; -- cellmembran..nn.1
  cello_1_N : N ; -- cello..nn.1
  cellodling_1_N : N ; -- cellodling..nn.1
  cellofan_1_N : N ; -- cellofan..nn.1
  cellplasma_1_N : N ; -- cellplasma..nn.1
  cellprov_1_N : N ; -- cellprov..nn.1
  cellsjok_1_N : N ; -- cellsjok..nn.1
  cellskikt_1_N : N ; -- cellskikt..nn.1
  cellskräck_1_N : N ; -- cellskräck..nn.1
  cellspänning_1_N : N ; -- cellspänning..nn.1
  cellstoff_1_N : N ; -- cellstoff..nn.1
  cellstraff_1_N : N ; -- cellstraff..nn.1
  cellstruktur_1_N : N ; -- cellstruktur..nn.1
  cellsubstans_1_N : N ; -- cellsubstans..nn.1
  cellterapi_1_N : N ; -- cellterapi..nn.1
  celltråd_1_N : N ; -- celltråd..nn.1
  celltyp_1_N : N ; -- celltyp..nn.1
  cellulas_1_N : N ; -- cellulas..nn.1
  celluloid_1_N : N ; -- celluloid..nn.1
  cellulosa_1_N : N ; -- cellulosa..nn.1
  cellulosaetanol_1_N : N ; -- cellulosaetanol..nn.1
  cellulosafabrik_1_N : N ; -- cellulosafabrik..nn.1
  cellulosaförtunning_1_N : N ; -- cellulosaförtunning..nn.1
  cellulosaindustri_1_N : N ; -- cellulosaindustri..nn.1
  cellulosalack_1_N : N ; -- cellulosalack..nn.1
  cellulosamolekyl_1_N : N ; -- cellulosamolekyl..nn.1
  cellulosanitrat_1_N : N ; -- cellulosanitrat..nn.1
  cellulosaplast_1_N : N ; -- cellulosaplast..nn.1
  cellulosavadd_1_N : N ; -- cellulosavadd..nn.1
  cellulär_1_A : A ; -- cellulär..av.1
  cellvägg_1_N : N ; -- cellvägg..nn.1
  cellvävnad_1_N : N ; -- cellvävnad..nn.1
  celsiusgrad_1_N : N ; -- celsiusgrad..nn.1
  celsiusskala_1_N : N ; -- celsiusskala..nn.1
  celsiustermometer_1_N : N ; -- celsiustermometer..nn.1
  celt_1_N : N ; -- celt..nn.1
  cembalist_1_N : N ; -- cembalist..nn.1
  cembalo_1_N : N ; -- cembalo..nn.1
  cembalobyggare_1_N : N ; -- cembalobyggare..nn.1
  cembalobygge_1_N : N ; -- cembalobygge..nn.1
  cembalotillverkning_1_N : N ; -- cembalotillverkning..nn.1
  cement_1_N : N ; -- cement..nn.1
  cementa_1_V : V ; -- cementa..vb.1
  cementande_1_N : N ; -- cementande..nn.1
  cementblandare_1_N : N ; -- cementblandare..nn.1
  cementera_1_V : V ; -- cementera..vb.1
  cementerande_1_N : N ; -- cementerande..nn.1
  cementerbar_1_A : A ; -- cementerbar..av.1
  cementerbarhet_1_N : N ; -- cementerbarhet..nn.1
  cementering_1_N : N ; -- cementering..nn.1
  cementfärg_1_N : N ; -- cementfärg..nn.1
  cementrör_1_N : N ; -- cementrör..nn.1
  cenakel_1_N : N ; -- cenakel..nn.1
  cendré_1_A : A ; -- cendré..av.1
  cendréfärgad_1_A : A ; -- cendréfärgad..av.1
  censor_1_N : N ; -- censor..nn.1
  censur_1_N : N ; -- censur..nn.1
  censurera_1_V : V ; -- censurera..vb.1
  censurerande_1_N : N ; -- censurerande..nn.1
  censurerbar_1_A : A ; -- censurerbar..av.1
  censurerbarhet_1_N : N ; -- censurerbarhet..nn.1
  censurering_1_N : N ; -- censurering..nn.1
  censurfrihet_1_N : N ; -- censurfrihet..nn.1
  censurförordning_1_N : N ; -- censurförordning..nn.1
  censurhinder_1_N : N ; -- censurhinder..nn.1
  censurtvång_1_N : N ; -- censurtvång..nn.1
  census_1_N : N ; -- census..nn.1
  cent_1_N : N ; -- cent..nn.1
  centaur_1_N : N ; -- centaur..nn.1
  centaurgestalt_1_N : N ; -- centaurgestalt..nn.1
  center_1_N : N ; -- center..nn.1
  center_2_N : N ; -- center..nn.2
  centerback_1_N : N ; -- centerback..nn.1
  centerbord_1_N : N ; -- centerbord..nn.1
  centercourt_1_N : N ; -- centercourt..nn.1
  centerforward_1_N : N ; -- centerforward..nn.1
  centerhalv_1_N : N ; -- centerhalv..nn.1
  centerism_1_N : N ; -- centerism..nn.1
  centerledare_1_N : N ; -- centerledare..nn.1
  centerparti_1_N : N ; -- centerparti..nn.1
  centerpartist_1_N : N ; -- centerpartist..nn.1
  centerpartistisk_1_A : A ; -- centerpartistisk..av.1
  centerprofil_1_N : N ; -- centerprofil..nn.1
  centigram_1_N : N ; -- centigram..nn.1
  centiliter_1_N : N ; -- centiliter..nn.1
  centilong_1_N : N ; -- centilong..nn.1
  centimeter_1_N : N ; -- centimeter..nn.1
  centimeterlång_1_A : A ; -- centimeterlång..av.1
  centimeterskala_1_N : N ; -- centimeterskala..nn.1
  centimeterstor_1_A : A ; -- centimeterstor..av.1
  centimetertjock_1_A : A ; -- centimetertjock..av.1
  centner_1_N : N ; -- centner..nn.1
  centra_1_V : V ; -- centra..vb.1
  central_1_A : A ; -- central..av.1
  central_1_N : N ; -- central..nn.1
  centralafrikan_1_N : N ; -- centralafrikan..nn.1
  centralafrikansk_1_A : A ; -- centralafrikansk..av.1
  centralafrikanska_1_N : N ; -- centralafrikanska..nn.1
  centralamerikan_1_N : N ; -- centralamerikan..nn.1
  centralamerikanare_1_N : N ; -- centralamerikanare..nn.1
  centralamerikansk_1_A : A ; -- centralamerikansk..av.1
  centralanstalt_1_N : N ; -- centralanstalt..nn.1
  centralantenn_1_N : N ; -- centralantenn..nn.1
  centralasiatisk_1_A : A ; -- centralasiatisk..av.1
  centralbank_1_N : N ; -- centralbank..nn.1
  centralbankschef_1_N : N ; -- centralbankschef..nn.1
  centralbyggnad_1_N : N ; -- centralbyggnad..nn.1
  centralbyrå_1_N : N ; -- centralbyrå..nn.1
  centraldirigerad_1_A : A ; -- centraldirigerad..av.1
  centralenhet_1_N : N ; -- centralenhet..nn.1
  centraleuropeisk_1_A : A ; -- centraleuropeisk..av.1
  centralfigur_1_N : N ; -- centralfigur..nn.1
  centralförbund_1_N : N ; -- centralförbund..nn.1
  centralförsvar_1_N : N ; -- centralförsvar..nn.1
  centralförvaltning_1_N : N ; -- centralförvaltning..nn.1
  centralgestalt_1_N : N ; -- centralgestalt..nn.1
  centralisation_1_N : N ; -- centralisation..nn.1
  centralisera_1_V : V ; -- centralisera..vb.1
  centraliserande_1_N : N ; -- centraliserande..nn.1
  centraliserbar_1_A : A ; -- centraliserbar..av.1
  centraliserbarhet_1_N : N ; -- centraliserbarhet..nn.1
  centralisering_1_N : N ; -- centralisering..nn.1
  centralism_1_N : N ; -- centralism..nn.1
  centralistisk_1_A : A ; -- centralistisk..av.1
  centralkommitté_1_N : N ; -- centralkommitté..nn.1
  centralkontor_1_N : N ; -- centralkontor..nn.1
  centralkyrka_1_N : N ; -- centralkyrka..nn.1
  centrallasarett_1_N : N ; -- centrallasarett..nn.1
  centrallyrik_1_N : N ; -- centrallyrik..nn.1
  centrallyrisk_1_A : A ; -- centrallyrisk..av.1
  centralmakt_1_N : N ; -- centralmakt..nn.1
  centralmått_1_N : N ; -- centralmått..nn.1
  centralnämnd_1_N : N ; -- centralnämnd..nn.1
  centralorganisation_1_N : N ; -- centralorganisation..nn.1
  centralort_1_N : N ; -- centralort..nn.1
  centralpunkt_1_N : N ; -- centralpunkt..nn.1
  centralradio_1_N : N ; -- centralradio..nn.1
  centralregering_1_N : N ; -- centralregering..nn.1
  centralrörelse_1_N : N ; -- centralrörelse..nn.1
  centralskola_1_N : N ; -- centralskola..nn.1
  centralstation_1_N : N ; -- centralstation..nn.1
  centralstimulantia_1_N : N ; -- centralstimulantia..nn.1
  centralstimulerande_1_A : A ; -- centralstimulerande..av.1
  centralstyrd_1_A : A ; -- centralstyrd..av.1
  centralstyrelse_1_N : N ; -- centralstyrelse..nn.1
  centralvärme_1_N : N ; -- centralvärme..nn.1
  centrande_1_N : N ; -- centrande..nn.1
  centrecourt_1_N : N ; -- centrecourt..nn.1
  centrera_1_V : V ; -- centrera..vb.1
  centrerande_1_N : N ; -- centrerande..nn.1
  centrerbar_1_A : A ; -- centrerbar..av.1
  centrerbarhet_1_N : N ; -- centrerbarhet..nn.1
  centrering_1_N : N ; -- centrering..nn.1
  centrifug_1_N : N ; -- centrifug..nn.1
  centrifugal_1_A : A ; -- centrifugal..av.1
  centrifugalkraft_1_N : N ; -- centrifugalkraft..nn.1
  centrifugalpump_1_N : N ; -- centrifugalpump..nn.1
  centrifugera_1_V : V ; -- centrifugera..vb.1
  centrifugerande_1_N : N ; -- centrifugerande..nn.1
  centrifugerbar_1_A : A ; -- centrifugerbar..av.1
  centrifugerbarhet_1_N : N ; -- centrifugerbarhet..nn.1
  centrifugering_1_N : N ; -- centrifugering..nn.1
  centripetal_1_A : A ; -- centripetal..av.1
  centripetalkraft_1_N : N ; -- centripetalkraft..nn.1
  centrisk_1_A : A ; -- centrisk..av.1
  centrum_1_N : N ; -- centrum..nn.1
  centumspråk_1_N : N ; -- centumspråk..nn.1
  centurion_1_N : N ; -- centurion..nn.1
  cepe_1_A : A ; -- cepe..av.1
  cerat_1_N : N ; -- cerat..nn.1
  cerebral_1_A : A ; -- cerebral..av.1
  cerebrospinal_1_A : A ; -- cerebrospinal..av.1
  cerebrospinalvätska_1_N : N ; -- cerebrospinalvätska..nn.1
  ceremoni_1_N : N ; -- ceremoni..nn.1
  ceremoniel_1_N : N ; -- ceremoniel..nn.1
  ceremoniell_1_A : A ; -- ceremoniell..av.1
  ceremonimästare_1_N : N ; -- ceremonimästare..nn.1
  ceremoniös_1_A : A ; -- ceremoniös..av.1
  cerise_1_A : A ; -- cerise..av.1
  cerise_1_N : N ; -- cerise..nn.1
  cerisefärgad_1_A : A ; -- cerisefärgad..av.1
  cerium_1_N : N ; -- cerium..nn.1
  cernera_1_V : V ; -- cernera..vb.1
  cernerande_1_N : N ; -- cernerande..nn.1
  cernerbar_1_A : A ; -- cernerbar..av.1
  cernerbarhet_1_N : N ; -- cernerbarhet..nn.1
  cernering_1_N : N ; -- cernering..nn.1
  cert_1_N : N ; -- cert..nn.1
  certeparti_1_N : N ; -- certeparti..nn.1
  certifiera_1_V : V ; -- certifiera..vb.1
  certifierande_1_N : N ; -- certifierande..nn.1
  certifiering_1_N : N ; -- certifiering..nn.1
  certifikat_1_N : N ; -- certifikat..nn.1
  cervelatkorv_1_N : N ; -- cervelatkorv..nn.1
  cesarisk_1_A : A ; -- cesarisk..av.1
  cesarism_1_N : N ; -- cesarism..nn.1
  cesium_1_N : N ; -- cesium..nn.1
  cession_1_N : N ; -- cession..nn.1
  cesur_1_N : N ; -- cesur..nn.1
  cha_cha_1_N : N ; -- cha-cha..nn.1
  chagrin_1_N : N ; -- chagrin..nn.1
  chagräng_1_N : N ; -- chagräng..nn.1
  chalmersk_1_A : A ; -- chalmersk..av.1
  chamotte_1_N : N ; -- chamotte..nn.1
  champagne_1_N : N ; -- champagne..nn.1
  champagnebaksmälla_1_N : N ; -- champagnebaksmälla..nn.1
  champagnebärgning_1_N : N ; -- champagnebärgning..nn.1
  champagneflaska_1_N : N ; -- champagneflaska..nn.1
  champagneglas_1_N : N ; -- champagneglas..nn.1
  champagnekork_1_N : N ; -- champagnekork..nn.1
  champagnesabel_1_N : N ; -- champagnesabel..nn.1
  champagnesprutande_1_A : A ; -- champagnesprutande..av.1
  champagnesprutande_1_N : N ; -- champagnesprutande..nn.1
  champagnevaskare_1_N : N ; -- champagnevaskare..nn.1
  champagnevisp_1_N : N ; -- champagnevisp..nn.1
  champinjon_1_N : N ; -- champinjon..nn.1
  champinjonbädd_1_N : N ; -- champinjonbädd..nn.1
  champion_1_N : N ; -- champion..nn.1
  championat_1_N : N ; -- championat..nn.1
  changemang_1_N : N ; -- changemang..nn.1
  changera_1_V : V ; -- changera..vb.1
  changerande_1_N : N ; -- changerande..nn.1
  changering_1_N : N ; -- changering..nn.1
  changsera_1_V : V ; -- changsera..vb.1
  changserande_1_N : N ; -- changserande..nn.1
  changsering_1_N : N ; -- changsering..nn.1
  chans_1_N : N ; -- chans..nn.1
  chansa_1_V : V ; -- chansa..vb.1
  chansande_1_N : N ; -- chansande..nn.1
  chansartad_1_A : A ; -- chansartad..av.1
  chansera_1_V : V ; -- chansera..vb.1
  chanserande_1_N : N ; -- chanserande..nn.1
  chansering_1_N : N ; -- chansering..nn.1
  chanslös_1_A : A ; -- chanslös..av.1
  chanslöshet_1_N : N ; -- chanslöshet..nn.1
  chansmässig_1_A : A ; -- chansmässig..av.1
  chansning_1_N : N ; -- chansning..nn.1
  chanson_1_N : N ; -- chanson..nn.1
  chansonett_1_N : N ; -- chansonett..nn.1
  chansonettsångerska_1_N : N ; -- chansonettsångerska..nn.1
  chanstagare_1_N : N ; -- chanstagare..nn.1
  chanstagning_1_N : N ; -- chanstagning..nn.1
  chapeau_claque_1_N : N ; -- chapeau-claque..nn.1
  char_1_N : N ; -- char..nn.1
  charabang_1_N : N ; -- charabang..nn.1
  charad_1_N : N ; -- charad..nn.1
  charge_1_N : N ; -- charge..nn.1
  chargera_1_V : V ; -- chargera..vb.1
  chargerande_1_N : N ; -- chargerande..nn.1
  chargerbar_1_A : A ; -- chargerbar..av.1
  chargerbarhet_1_N : N ; -- chargerbarhet..nn.1
  chargering_1_N : N ; -- chargering..nn.1
  chargé_d_affaires_1_N : N ; -- chargé-d-affaires..nn.1
  chark_1_N : N ; -- chark..nn.1
  charkuteri_1_N : N ; -- charkuteri..nn.1
  charkuterist_1_N : N ; -- charkuterist..nn.1
  charkuterivara_1_N : N ; -- charkuterivara..nn.1
  charkvara_1_N : N ; -- charkvara..nn.1
  charlatan_1_N : N ; -- charlatan..nn.1
  charlataneri_1_N : N ; -- charlataneri..nn.1
  charlatanmässig_1_A : A ; -- charlatanmässig..av.1
  charleston_1_N : N ; -- charleston..nn.1
  charm_1_N : N ; -- charm..nn.1
  charma_1_V : V ; -- charma..vb.1
  charmande_1_N : N ; -- charmande..nn.1
  charmant_1_A : A ; -- charmant..av.1
  charmera_1_V : V ; -- charmera..vb.1
  charmerande_1_N : N ; -- charmerande..nn.1
  charmerbar_1_A : A ; -- charmerbar..av.1
  charmerbarhet_1_N : N ; -- charmerbarhet..nn.1
  charmering_1_N : N ; -- charmering..nn.1
  charmeuse_1_N : N ; -- charmeuse..nn.1
  charmfull_1_A : A ; -- charmfull..av.1
  charmfullhet_1_N : N ; -- charmfullhet..nn.1
  charmig_1_A : A ; -- charmig..av.1
  charmighet_1_N : N ; -- charmighet..nn.1
  charmkurs_1_N : N ; -- charmkurs..nn.1
  charmkvark_1_N : N ; -- charmkvark..nn.1
  charmlös_1_A : A ; -- charmlös..av.1
  charmlöshet_1_N : N ; -- charmlöshet..nn.1
  charmoffensiv_1_N : N ; -- charmoffensiv..nn.1
  charmtroll_1_N : N ; -- charmtroll..nn.1
  charmör_1_N : N ; -- charmör..nn.1
  charner_1_N : N ; -- charner..nn.1
  charpi_1_N : N ; -- charpi..nn.1
  charta_1_N : N ; -- charta..nn.1
  charter_1_N : N ; -- charter..nn.1
  charterresa_1_N : N ; -- charterresa..nn.1
  charterturist_1_N : N ; -- charterturist..nn.1
  chartra_1_V : V ; -- chartra..vb.1
  chartrande_1_N : N ; -- chartrande..nn.1
  chartreuse_1_N : N ; -- chartreuse..nn.1
  chassi_1_N : N ; -- chassi..nn.1
  chassidism_1_N : N ; -- chassidism..nn.1
  chassidistisk_1_A : A ; -- chassidistisk..av.1
  chat_1_N : N ; -- chat..nn.1
  chateaubriand_1_N : N ; -- chateaubriand..nn.1
  chatt_1_N : N ; -- chatt..nn.1
  chatta_1_V : V ; -- chatta..vb.1
  chattande_1_N : N ; -- chattande..nn.1
  chattkonversation_1_N : N ; -- chattkonversation..nn.1
  chaufför_1_N : N ; -- chaufför..nn.1
  chausserad_1_A : A ; -- chausserad..av.1
  chaussé_1_N : N ; -- chaussé..nn.1
  chauvinism_1_N : N ; -- chauvinism..nn.1
  chauvinist_1_N : N ; -- chauvinist..nn.1
  chauvinistisk_1_A : A ; -- chauvinistisk..av.1
  check_1_N : N ; -- check..nn.1
  checka_1_V : V ; -- checka..vb.1
  checkande_1_N : N ; -- checkande..nn.1
  checkbok_1_N : N ; -- checkbok..nn.1
  checkhäfte_1_N : N ; -- checkhäfte..nn.1
  checkkonto_1_N : N ; -- checkkonto..nn.1
  checkkredit_1_N : N ; -- checkkredit..nn.1
  checklista_1_N : N ; -- checklista..nn.1
  checklön_1_N : N ; -- checklön..nn.1
  checkräkning_1_N : N ; -- checkräkning..nn.1
  checksumma_1_N : N ; -- checksumma..nn.1
  cheddarost_1_N : N ; -- cheddarost..nn.1
  chef_d_oeuvre_1_N : N ; -- chef-d-oeuvre..nn.1
  chef_1_N : N ; -- chef..nn.1
  chefa_1_V : V ; -- chefa..vb.1
  chefande_1_N : N ; -- chefande..nn.1
  chefredaktör_1_N : N ; -- chefredaktör..nn.1
  chefsegenskap_1_N : N ; -- chefsegenskap..nn.1
  chefsekonom_1_N : N ; -- chefsekonom..nn.1
  chefsfartyg_1_N : N ; -- chefsfartyg..nn.1
  chefsflytt_1_N : N ; -- chefsflytt..nn.1
  chefsideolog_1_N : N ; -- chefsideolog..nn.1
  chefsjobb_1_N : N ; -- chefsjobb..nn.1
  chefskap_1_N : N ; -- chefskap..nn.1
  chefskirurg_1_N : N ; -- chefskirurg..nn.1
  chefsmikrobiolog_1_N : N ; -- chefsmikrobiolog..nn.1
  chefsplats_1_N : N ; -- chefsplats..nn.1
  chefsskap_1_N : N ; -- chefsskap..nn.1
  chefsställning_1_N : N ; -- chefsställning..nn.1
  chefstjänsteman_1_N : N ; -- chefstjänsteman..nn.1
  chefsåklagare_1_N : N ; -- chefsåklagare..nn.1
  chemis_1_N : N ; -- chemis..nn.1
  chemisett_1_N : N ; -- chemisett..nn.1
  cherimoya_1_N : N ; -- cherimoya..nn.1
  chevaleresk_1_A : A ; -- chevaleresk..av.1
  chevelyr_1_N : N ; -- chevelyr..nn.1
  cheviot_1_N : N ; -- cheviot..nn.1
  chevreau_1_N : N ; -- chevreau..nn.1
  chevrotera_1_V : V ; -- chevrotera..vb.1
  chevroterande_1_N : N ; -- chevroterande..nn.1
  chevroterbar_1_A : A ; -- chevroterbar..av.1
  chevroterbarhet_1_N : N ; -- chevroterbarhet..nn.1
  chevrotering_1_N : N ; -- chevrotering..nn.1
  cheyenne_1_N : N ; -- cheyenne..nn.1
  chi_1_N : N ; -- chi..nn.1
  chibbe_1_N : N ; -- chibbe..nn.1
  chic_1_A : A ; -- chic..av.1
  chichet_1_N : N ; -- chichet..nn.1
  chiffer_1_N : N ; -- chiffer..nn.1
  chiffernyckel_1_N : N ; -- chiffernyckel..nn.1
  chifferskrift_1_N : N ; -- chifferskrift..nn.1
  chiffong_1_N : N ; -- chiffong..nn.1
  chiffonggarnering_1_N : N ; -- chiffonggarnering..nn.1
  chiffongklänning_1_N : N ; -- chiffongklänning..nn.1
  chiffonjé_1_N : N ; -- chiffonjé..nn.1
  chiffrera_1_V : V ; -- chiffrera..vb.1
  chiffrerande_1_N : N ; -- chiffrerande..nn.1
  chiffrerbar_1_A : A ; -- chiffrerbar..av.1
  chiffrerbarhet_1_N : N ; -- chiffrerbarhet..nn.1
  chiffrering_1_N : N ; -- chiffrering..nn.1
  chikan_1_N : N ; -- chikan..nn.1
  chikanera_1_V : V ; -- chikanera..vb.1
  chikanerande_1_N : N ; -- chikanerande..nn.1
  chikanerbar_1_A : A ; -- chikanerbar..av.1
  chikanerbarhet_1_N : N ; -- chikanerbarhet..nn.1
  chikanering_1_N : N ; -- chikanering..nn.1
  chilen_1_N : N ; -- chilen..nn.1
  chilenare_1_N : N ; -- chilenare..nn.1
  chilensk_1_A : A ; -- chilensk..av.1
  chilenska_1_N : N ; -- chilenska..nn.1
  chilesalpeter_1_N : N ; -- chilesalpeter..nn.1
  chilisås_1_N : N ; -- chilisås..nn.1
  chilla_1_V : V ; -- chilla..vb.1
  chillande_1_N : N ; -- chillande..nn.1
  chimpa_1_V : V ; -- chimpa..vb.1
  chimpande_1_N : N ; -- chimpande..nn.1
  chimpans_1_N : N ; -- chimpans..nn.1
  chimping_1_N : N ; -- chimping..nn.1
  chimpning_1_N : N ; -- chimpning..nn.1
  chimär_1_N : N ; -- chimär..nn.1
  chimärisk_1_A : A ; -- chimärisk..av.1
  chinchilla_1_N : N ; -- chinchilla..nn.1
  chinjong_1_N : N ; -- chinjong..nn.1
  chintz_1_N : N ; -- chintz..nn.1
  chip_1_N : N ; -- chip..nn.1
  chips_1_N : N ; -- chips..nn.1
  chipssug_1_N : N ; -- chipssug..nn.1
  chirre_1_N : N ; -- chirre..nn.1
  chock_1_N : N ; -- chock..nn.1
  chocka_1_V : V ; -- chocka..vb.1
  chockande_1_N : N ; -- chockande..nn.1
  chockartad_1_A : A ; -- chockartad..av.1
  chockbehandla_1_V : V ; -- chockbehandla..vb.1
  chockbehandlande_1_N : N ; -- chockbehandlande..nn.1
  chockbehandling_1_N : N ; -- chockbehandling..nn.1
  chockbeskatta_1_V : V ; -- chockbeskatta..vb.1
  chockbeskattande_1_N : N ; -- chockbeskattande..nn.1
  chockbeskattning_1_N : N ; -- chockbeskattning..nn.1
  chockbesked_1_N : N ; -- chockbesked..nn.1
  chockbild_1_N : N ; -- chockbild..nn.1
  chockera_1_V : V ; -- chockera..vb.1
  chockerande_1_N : N ; -- chockerande..nn.1
  chockerbar_1_A : A ; -- chockerbar..av.1
  chockerbarhet_1_N : N ; -- chockerbarhet..nn.1
  chockering_1_N : N ; -- chockering..nn.1
  chockfas_1_N : N ; -- chockfas..nn.1
  chockhöja_1_V : V ; -- chockhöja..vb.1
  chockhöjande_1_N : N ; -- chockhöjande..nn.1
  chockhöjning_1_N : N ; -- chockhöjning..nn.1
  chockreaktion_1_N : N ; -- chockreaktion..nn.1
  chockrosa_1_A : A ; -- chockrosa..av.1
  chockterapi_1_N : N ; -- chockterapi..nn.1
  chocktillstånd_1_N : N ; -- chocktillstånd..nn.1
  chockvåg_1_N : N ; -- chockvåg..nn.1
  choka_1_V : V ; -- choka..vb.1
  chokande_1_N : N ; -- chokande..nn.1
  choke_1_N : N ; -- choke..nn.1
  choklad_1_N : N ; -- choklad..nn.1
  choklad_2_N : N ; -- choklad..nn.2
  chokladbit_1_N : N ; -- chokladbit..nn.1
  chokladboll_1_N : N ; -- chokladboll..nn.1
  chokladbrun_1_A : A ; -- chokladbrun..av.1
  chokladglass_1_N : N ; -- chokladglass..nn.1
  chokladgodis_1_N : N ; -- chokladgodis..nn.1
  chokladgodis_2_N : N ; -- chokladgodis..nn.2
  chokladkaka_1_N : N ; -- chokladkaka..nn.1
  chokladlins_1_N : N ; -- chokladlins..nn.1
  chokladlycka_1_N : N ; -- chokladlycka..nn.1
  chokladpudding_1_N : N ; -- chokladpudding..nn.1
  chokladtårta_1_N : N ; -- chokladtårta..nn.1
  chorizo_stoppning_1_N : N ; -- chorizo-stoppning..nn.1
  chorizo_1_N : N ; -- chorizo..nn.1
  chosefri_1_A : A ; -- chosefri..av.1
  chosig_1_A : A ; -- chosig..av.1
  chuck_1_N : N ; -- chuck..nn.1
  cicero_1_N : N ; -- cicero..nn.1
  ciceron_1_N : N ; -- ciceron..nn.1
  cider_1_N : N ; -- cider..nn.1
  cig_1_N : N ; -- cig..nn.1
  cigarett_1_N : N ; -- cigarett..nn.1
  cigarettautomat_1_N : N ; -- cigarettautomat..nn.1
  cigarettetui_1_N : N ; -- cigarettetui..nn.1
  cigarettfimp_1_N : N ; -- cigarettfimp..nn.1
  cigarettförsäljning_1_N : N ; -- cigarettförsäljning..nn.1
  cigarettlimpa_1_N : N ; -- cigarettlimpa..nn.1
  cigarettpaket_1_N : N ; -- cigarettpaket..nn.1
  cigarettrök_1_N : N ; -- cigarettrök..nn.1
  cigarettrökning_1_N : N ; -- cigarettrökning..nn.1
  cigarettuttag_1_N : N ; -- cigarettuttag..nn.1
  cigarettändare_1_N : N ; -- cigarettändare..nn.1
  cigarettändarkontakt_1_N : N ; -- cigarettändarkontakt..nn.1
  cigarettändaruttag_1_N : N ; -- cigarettändaruttag..nn.1
  cigarill_1_N : N ; -- cigarill..nn.1
  cigarr_1_N : N ; -- cigarr..nn.1
  cigarrcigarett_1_N : N ; -- cigarrcigarett..nn.1
  cigarrcigarrett_1_N : N ; -- cigarrcigarrett..nn.1
  cigarrett_1_N : N ; -- cigarrett..nn.1
  cigarrettfimp_1_N : N ; -- cigarrettfimp..nn.1
  cigarrettlimpa_1_N : N ; -- cigarrettlimpa..nn.1
  cigarrettobak_1_N : N ; -- cigarrettobak..nn.1
  cigarrettpaket_1_N : N ; -- cigarrettpaket..nn.1
  cigarrettrök_1_N : N ; -- cigarrettrök..nn.1
  cigarrettuttag_1_N : N ; -- cigarrettuttag..nn.1
  cigarrettändare_1_N : N ; -- cigarrettändare..nn.1
  cigarrettändarkontakt_1_N : N ; -- cigarrettändarkontakt..nn.1
  cigarrettändaruttag_1_N : N ; -- cigarrettändaruttag..nn.1
  cigarrill_1_N : N ; -- cigarrill..nn.1
  cigarrlåda_1_N : N ; -- cigarrlåda..nn.1
  cigarrsnopp_1_N : N ; -- cigarrsnopp..nn.1
  cigarrsnoppare_1_N : N ; -- cigarrsnoppare..nn.1
  cigarrtändare_1_N : N ; -- cigarrtändare..nn.1
  cigg_1_N : N ; -- cigg..nn.1
  cikada_1_N : N ; -- cikada..nn.1
  ciklid_1_N : N ; -- ciklid..nn.1
  ciklidfisk_1_N : N ; -- ciklidfisk..nn.1
  ciklidfiskfauna_1_N : N ; -- ciklidfiskfauna..nn.1
  cikoria_1_N : N ; -- cikoria..nn.1
  ciliarkropp_1_N : N ; -- ciliarkropp..nn.1
  ciliarmuskel_1_N : N ; -- ciliarmuskel..nn.1
  cilie_1_N : N ; -- cilie..nn.1
  cineast_1_N : N ; -- cineast..nn.1
  cinematek_1_N : N ; -- cinematek..nn.1
  cineraria_1_N : N ; -- cineraria..nn.1
  cinnober_1_N : N ; -- cinnober..nn.1
  cinnoberfärg_1_N : N ; -- cinnoberfärg..nn.1
  cinnoberröd_1_A : A ; -- cinnoberröd..av.1
  cirkapris_1_N : N ; -- cirkapris..nn.1
  cirkel_1_N : N ; -- cirkel..nn.1
  cirkelbana_1_N : N ; -- cirkelbana..nn.1
  cirkelben_1_N : N ; -- cirkelben..nn.1
  cirkelbevis_1_N : N ; -- cirkelbevis..nn.1
  cirkelbåge_1_N : N ; -- cirkelbåge..nn.1
  cirkeldefinition_1_N : N ; -- cirkeldefinition..nn.1
  cirkelform_1_N : N ; -- cirkelform..nn.1
  cirkelformad_1_A : A ; -- cirkelformad..av.1
  cirkelgång_1_N : N ; -- cirkelgång..nn.1
  cirkelledare_1_N : N ; -- cirkelledare..nn.1
  cirkelperiferi_1_N : N ; -- cirkelperiferi..nn.1
  cirkelprocess_1_N : N ; -- cirkelprocess..nn.1
  cirkelrund_1_A : A ; -- cirkelrund..av.1
  cirkelrundhet_1_N : N ; -- cirkelrundhet..nn.1
  cirkelrörelse_1_N : N ; -- cirkelrörelse..nn.1
  cirkelsegment_1_N : N ; -- cirkelsegment..nn.1
  cirkelsektor_1_N : N ; -- cirkelsektor..nn.1
  cirkelslut_1_N : N ; -- cirkelslut..nn.1
  cirkelsåg_1_N : N ; -- cirkelsåg..nn.1
  cirkla_1_V : V ; -- cirkla..vb.1
  cirklande_1_N : N ; -- cirklande..nn.1
  cirkulation_1_N : N ; -- cirkulation..nn.1
  cirkulationsplats_1_N : N ; -- cirkulationsplats..nn.1
  cirkulationspump_1_N : N ; -- cirkulationspump..nn.1
  cirkulationsrubbning_1_N : N ; -- cirkulationsrubbning..nn.1
  cirkulera_1_V : V ; -- cirkulera..vb.1
  cirkulerande_1_N : N ; -- cirkulerande..nn.1
  cirkulerbar_1_A : A ; -- cirkulerbar..av.1
  cirkulerbarhet_1_N : N ; -- cirkulerbarhet..nn.1
  cirkulering_1_N : N ; -- cirkulering..nn.1
  cirkulär_1_A : A ; -- cirkulär..av.1
  cirkulär_1_N : N ; -- cirkulär..nn.1
  cirkulärbrev_1_N : N ; -- cirkulärbrev..nn.1
  cirkulärledare_1_N : N ; -- cirkulärledare..nn.1
  cirkumflex_1_N : N ; -- cirkumflex..nn.1
  cirkumpolar_1_A : A ; -- cirkumpolar..av.1
  cirkumpolär_1_A : A ; -- cirkumpolär..av.1
  cirkus_1_N : N ; -- cirkus..nn.1
  cirkusarena_1_N : N ; -- cirkusarena..nn.1
  cirkusartist_1_N : N ; -- cirkusartist..nn.1
  cirkusbyggnad_1_N : N ; -- cirkusbyggnad..nn.1
  cirkusdjur_1_N : N ; -- cirkusdjur..nn.1
  cirkuselefant_1_N : N ; -- cirkuselefant..nn.1
  cirkusföreställning_1_N : N ; -- cirkusföreställning..nn.1
  cirkusmanege_1_N : N ; -- cirkusmanege..nn.1
  cirkusmässig_1_A : A ; -- cirkusmässig..av.1
  cirkusnummer_1_N : N ; -- cirkusnummer..nn.1
  cirkustält_1_N : N ; -- cirkustält..nn.1
  cirkusvagn_1_N : N ; -- cirkusvagn..nn.1
  cirrhos_1_N : N ; -- cirrhos..nn.1
  cirros_1_N : N ; -- cirros..nn.1
  cirrus_1_N : N ; -- cirrus..nn.1
  cirrusmoln_1_N : N ; -- cirrusmoln..nn.1
  cisalpinsk_1_A : A ; -- cisalpinsk..av.1
  ciselera_1_V : V ; -- ciselera..vb.1
  ciselerande_1_N : N ; -- ciselerande..nn.1
  ciselerbar_1_A : A ; -- ciselerbar..av.1
  ciselerbarhet_1_N : N ; -- ciselerbarhet..nn.1
  ciselering_1_N : N ; -- ciselering..nn.1
  ciselör_1_N : N ; -- ciselör..nn.1
  cisperson_1_N : N ; -- cisperson..nn.1
  ciss_1_N : N ; -- ciss..nn.1
  cissexualitet_1_N : N ; -- cissexualitet..nn.1
  cissexuell_1_A : A ; -- cissexuell..av.1
  cissus_1_N : N ; -- cissus..nn.1
  cisterciens_1_N : N ; -- cisterciens..nn.1
  cistercienserkloster_1_N : N ; -- cistercienserkloster..nn.1
  cisterciensermunk_1_N : N ; -- cisterciensermunk..nn.1
  cistercienserorden_1_N : N ; -- cistercienserorden..nn.1
  cisterciensorden_1_N : N ; -- cisterciensorden..nn.1
  cistern_1_N : N ; -- cistern..nn.1
  cisulal_1_N : N ; -- cisulal..nn.1
  citadell_1_N : N ; -- citadell..nn.1
  citat_1_N : N ; -- citat..nn.1
  citation_1_N : N ; -- citation..nn.1
  citationstecken_1_N : N ; -- citationstecken..nn.1
  citatord_1_N : N ; -- citatord..nn.1
  citattecken_1_N : N ; -- citattecken..nn.1
  citera_1_V : V ; -- citera..vb.1
  citerande_1_N : N ; -- citerande..nn.1
  citerbar_1_A : A ; -- citerbar..av.1
  citerbarhet_1_N : N ; -- citerbarhet..nn.1
  citering_1_N : N ; -- citering..nn.1
  citrat_1_N : N ; -- citrat..nn.1
  citrin_1_N : N ; -- citrin..nn.1
  citroen_1_N : N ; -- citroen..nn.1
  citron_1_N : N ; -- citron..nn.1
  citronbakelse_1_N : N ; -- citronbakelse..nn.1
  citrondoft_1_N : N ; -- citrondoft..nn.1
  citronfjäril_1_N : N ; -- citronfjäril..nn.1
  citrongräsolja_1_N : N ; -- citrongräsolja..nn.1
  citrongul_1_A : A ; -- citrongul..av.1
  citronläsk_1_N : N ; -- citronläsk..nn.1
  citronmarinerad_1_A : A ; -- citronmarinerad..av.1
  citronmeliss_1_N : N ; -- citronmeliss..nn.1
  citronmousse_1_N : N ; -- citronmousse..nn.1
  citronolja_1_N : N ; -- citronolja..nn.1
  citronsaft_1_N : N ; -- citronsaft..nn.1
  citronskal_1_N : N ; -- citronskal..nn.1
  citronsorbet_1_N : N ; -- citronsorbet..nn.1
  citronsyra_1_N : N ; -- citronsyra..nn.1
  citronträd_1_N : N ; -- citronträd..nn.1
  citrus_1_N : N ; -- citrus..nn.1
  citrusfrukt_1_N : N ; -- citrusfrukt..nn.1
  citrussmak_1_N : N ; -- citrussmak..nn.1
  citterspel_1_N : N ; -- citterspel..nn.1
  citterspelare_1_N : N ; -- citterspelare..nn.1
  cittra_1_N : N ; -- cittra..nn.1
  cittra_2_N : N ; -- cittra..nn.2
  city_1_N : N ; -- city..nn.1
  citydress_1_N : N ; -- citydress..nn.1
  citykärna_1_N : N ; -- citykärna..nn.1
  cityliv_1_N : N ; -- cityliv..nn.1
  cityljus_1_N : N ; -- cityljus..nn.1
  civil_1_A : A ; -- civil..av.1
  civilanställd_1_A : A ; -- civilanställd..av.1
  civilbefolkning_1_N : N ; -- civilbefolkning..nn.1
  civilbegravning_1_N : N ; -- civilbegravning..nn.1
  civildepartement_1_N : N ; -- civildepartement..nn.1
  civilekonom_1_N : N ; -- civilekonom..nn.1
  civilflyg_1_N : N ; -- civilflyg..nn.1
  civilförsvar_1_N : N ; -- civilförsvar..nn.1
  civilförsvarspersonal_1_N : N ; -- civilförsvarspersonal..nn.1
  civilingenjör_1_N : N ; -- civilingenjör..nn.1
  civilisation_1_N : N ; -- civilisation..nn.1
  civilisationsprocess_1_N : N ; -- civilisationsprocess..nn.1
  civilisatorisk_1_A : A ; -- civilisatorisk..av.1
  civilisera_1_V : V ; -- civilisera..vb.1
  civiliserad_1_A : A ; -- civiliserad..av.1
  civiliserande_1_N : N ; -- civiliserande..nn.1
  civiliserbar_1_A : A ; -- civiliserbar..av.1
  civiliserbarhet_1_N : N ; -- civiliserbarhet..nn.1
  civilisering_1_N : N ; -- civilisering..nn.1
  civilist_1_N : N ; -- civilist..nn.1
  civilklädd_1_A : A ; -- civilklädd..av.1
  civilkurage_1_N : N ; -- civilkurage..nn.1
  civillag_1_N : N ; -- civillag..nn.1
  civilmilitär_1_A : A ; -- civilmilitär..av.1
  civilmilitär_1_N : N ; -- civilmilitär..nn.1
  civilminister_1_N : N ; -- civilminister..nn.1
  civilmotstånd_1_N : N ; -- civilmotstånd..nn.1
  civilmål_1_N : N ; -- civilmål..nn.1
  civilprocess_1_N : N ; -- civilprocess..nn.1
  civilrätt_1_N : N ; -- civilrätt..nn.1
  civilrättslig_1_A : A ; -- civilrättslig..av.1
  civilstat_1_N : N ; -- civilstat..nn.1
  civilstånd_1_N : N ; -- civilstånd..nn.1
  civiläktenskap_1_N : N ; -- civiläktenskap..nn.1
  clairobscur_1_N : N ; -- clairobscur..nn.1
  clairvoyance_1_N : N ; -- clairvoyance..nn.1
  clairvoyant_1_A : A ; -- clairvoyant..av.1
  cleara_1_V : V ; -- cleara..vb.1
  clearande_1_N : N ; -- clearande..nn.1
  clearing_1_N : N ; -- clearing..nn.1
  clematis_1_N : N ; -- clematis..nn.1
  clementin_1_N : N ; -- clementin..nn.1
  clinch_1_N : N ; -- clinch..nn.1
  clips_1_N : N ; -- clips..nn.1
  clitoris_1_N : N ; -- clitoris..nn.1
  cloisonvägg_1_N : N ; -- cloisonvägg..nn.1
  cloqué_1_N : N ; -- cloqué..nn.1
  clou_1_N : N ; -- clou..nn.1
  clown_1_N : N ; -- clown..nn.1
  clowneri_1_N : N ; -- clowneri..nn.1
  clownupptåg_1_N : N ; -- clownupptåg..nn.1
  club_blazer_1_N : N ; -- club-blazer..nn.1
  clubstek_1_N : N ; -- clubstek..nn.1
  coach_1_N : N ; -- coach..nn.1
  coca_1_N : N ; -- coca..nn.1
  cocacola_1_N : N ; -- cocacola..nn.1
  cochleaimplantat_1_N : N ; -- cochleaimplantat..nn.1
  cochlearimplantat_1_N : N ; -- cochlearimplantat..nn.1
  cockerspaniel_1_N : N ; -- cockerspaniel..nn.1
  cockpit_1_N : N ; -- cockpit..nn.1
  cocktail_1_N : N ; -- cocktail..nn.1
  cocktailbjudning_1_N : N ; -- cocktailbjudning..nn.1
  cocktailbord_1_N : N ; -- cocktailbord..nn.1
  cocktailbär_1_N : N ; -- cocktailbär..nn.1
  cocktailglas_1_N : N ; -- cocktailglas..nn.1
  cocktailmusik_1_N : N ; -- cocktailmusik..nn.1
  cocktailparty_1_N : N ; -- cocktailparty..nn.1
  coda_1_N : N ; -- coda..nn.1
  codex_1_N : N ; -- codex..nn.1
  cointreau_1_N : N ; -- cointreau..nn.1
  coitus_1_N : N ; -- coitus..nn.1
  cokacola_1_N : N ; -- cokacola..nn.1
  cokakola_1_N : N ; -- cokakola..nn.1
  cola_1_N : N ; -- cola..nn.1
  colibakterie_1_N : N ; -- colibakterie..nn.1
  collage_1_N : N ; -- collage..nn.1
  college_1_N : N ; -- college..nn.1
  collegeflicka_1_N : N ; -- collegeflicka..nn.1
  collegepojke_1_N : N ; -- collegepojke..nn.1
  collegetröja_1_N : N ; -- collegetröja..nn.1
  collie_1_N : N ; -- collie..nn.1
  collier_1_N : N ; -- collier..nn.1
  cologne_1_N : N ; -- cologne..nn.1
  colombian_1_N : N ; -- colombian..nn.1
  colombiansk_1_A : A ; -- colombiansk..av.1
  colombianska_1_N : N ; -- colombianska..nn.1
  coltan_1_N : N ; -- coltan..nn.1
  come_back_1_N : N ; -- come-back..nn.1
  comeback_1_N : N ; -- comeback..nn.1
  commando_1_N : N ; -- commando..nn.1
  commandotrupp_1_N : N ; -- commandotrupp..nn.1
  comorier_1_N : N ; -- comorier..nn.1
  comorisk_1_A : A ; -- comorisk..av.1
  comoriska_1_N : N ; -- comoriska..nn.1
  complet_1_N : N ; -- complet..nn.1
  conferencier_1_N : N ; -- conferencier..nn.1
  conférencier_1_N : N ; -- conférencier..nn.1
  consensus_1_N : N ; -- consensus..nn.1
  consensuskultur_1_N : N ; -- consensuskultur..nn.1
  consommé_1_N : N ; -- consommé..nn.1
  container_1_N : N ; -- container..nn.1
  containerfartyg_1_N : N ; -- containerfartyg..nn.1
  contortatall_1_N : N ; -- contortatall..nn.1
  cool_1_A : A ; -- cool..av.1
  coolhet_1_N : N ; -- coolhet..nn.1
  copy_cat_1_N : N ; -- copy-cat..nn.1
  copycat_1_N : N ; -- copycat..nn.1
  copyright_1_N : N ; -- copyright..nn.1
  copywriter_1_N : N ; -- copywriter..nn.1
  corioliskraft_1_N : N ; -- corioliskraft..nn.1
  cornichon_1_N : N ; -- cornichon..nn.1
  coronacell_1_N : N ; -- coronacell..nn.1
  corps_de_logi_1_N : N ; -- corps-de-logi..nn.1
  corpus_1_N : N ; -- corpus..nn.1
  cortege_1_N : N ; -- cortege..nn.1
  cortex_1_N : N ; -- cortex..nn.1
  cortical_1_A : A ; -- cortical..av.1
  cortison_1_N : N ; -- cortison..nn.1
  cortisonbehandling_1_N : N ; -- cortisonbehandling..nn.1
  cortège_1_N : N ; -- cortège..nn.1
  cosinus_1_N : N ; -- cosinus..nn.1
  costarican_1_N : N ; -- costarican..nn.1
  costaricansk_1_A : A ; -- costaricansk..av.1
  costaricanska_1_N : N ; -- costaricanska..nn.1
  cotangens_1_N : N ; -- cotangens..nn.1
  cotangent_1_N : N ; -- cotangent..nn.1
  coulomb_1_N : N ; -- coulomb..nn.1
  countrymusik_1_N : N ; -- countrymusik..nn.1
  countrysång_1_N : N ; -- countrysång..nn.1
  coupe_1_N : N ; -- coupe..nn.1
  couronne_1_N : N ; -- couronne..nn.1
  courtage_1_N : N ; -- courtage..nn.1
  cous_cous_1_N : N ; -- cous-cous..nn.1
  couscous_1_N : N ; -- couscous..nn.1
  cover_1_N : N ; -- cover..nn.1
  coverlåt_1_N : N ; -- coverlåt..nn.1
  coverversion_1_N : N ; -- coverversion..nn.1
  covra_1_V : V ; -- covra..vb.1
  cowboy_1_N : N ; -- cowboy..nn.1
  cowboyhatt_1_N : N ; -- cowboyhatt..nn.1
  coyote_1_N : N ; -- coyote..nn.1
  cp_skadad_1_A : A ; -- cp-skadad..av.1
  crawl_1_N : N ; -- crawl..nn.1
  crawla_1_V : V ; -- crawla..vb.1
  crawlande_1_N : N ; -- crawlande..nn.1
  crazy_1_A : A ; -- crazy..av.1
  cred_1_N : N ; -- cred..nn.1
  credd_1_N : N ; -- credd..nn.1
  credo_1_N : N ; -- credo..nn.1
  creme_1_N : N ; -- creme..nn.1
  creme_2_N : N ; -- creme..nn.2
  crepe_1_N : N ; -- crepe..nn.1
  crescendo_1_N : N ; -- crescendo..nn.1
  cricket_1_N : N ; -- cricket..nn.1
  cricketklubba_1_N : N ; -- cricketklubba..nn.1
  croissant_1_N : N ; -- croissant..nn.1
  croquis_1_N : N ; -- croquis..nn.1
  crosschecking_1_N : N ; -- crosschecking..nn.1
  crosshandske_1_N : N ; -- crosshandske..nn.1
  crosshjälm_1_N : N ; -- crosshjälm..nn.1
  croupier_1_N : N ; -- croupier..nn.1
  crust_1_N : N ; -- crust..nn.1
  crème_de_la_crème_1_N : N ; -- crème-de-la-crème..nn.1
  crème_1_N : N ; -- crème..nn.1
  crème_2_N : N ; -- crème..nn.2
  crèpe_1_N : N ; -- crèpe..nn.1
  crêpe_1_N : N ; -- crêpe..nn.1
  crêpegarn_1_N : N ; -- crêpegarn..nn.1
  csardas_1_N : N ; -- csardas..nn.1
  cuban_1_N : N ; -- cuban..nn.1
  cubansk_1_A : A ; -- cubansk..av.1
  cumulus_1_N : N ; -- cumulus..nn.1
  cumuluscell_1_N : N ; -- cumuluscell..nn.1
  cumulusmoln_1_N : N ; -- cumulusmoln..nn.1
  cup_1_N : N ; -- cup..nn.1
  curare_1_N : N ; -- curare..nn.1
  curatera_1_V : V ; -- curatera..vb.1
  curaterande_1_N : N ; -- curaterande..nn.1
  curaterbar_1_A : A ; -- curaterbar..av.1
  curaterbarhet_1_N : N ; -- curaterbarhet..nn.1
  curator_1_N : N ; -- curator..nn.1
  curaçao_1_N : N ; -- curaçao..nn.1
  curera_1_V : V ; -- curera..vb.1
  curerande_1_N : N ; -- curerande..nn.1
  curerbar_1_A : A ; -- curerbar..av.1
  curerbarhet_1_N : N ; -- curerbarhet..nn.1
  curia_1_N : N ; -- curia..nn.1
  curie_1_N : N ; -- curie..nn.1
  curium_1_N : N ; -- curium..nn.1
  curla_1_V : V ; -- curla..vb.1
  curla_2_V : V ; -- curla..vb.2
  curlande_1_N : N ; -- curlande..nn.1
  curling_1_N : N ; -- curling..nn.1
  curlingbarn_1_N : N ; -- curlingbarn..nn.1
  curlingfinal_1_N : N ; -- curlingfinal..nn.1
  curlingförälder_1_N : N ; -- curlingförälder..nn.1
  curlingtävling_1_N : N ; -- curlingtävling..nn.1
  currygryta_1_N : N ; -- currygryta..nn.1
  cyan_1_N : N ; -- cyan..nn.1
  cyanblå_1_A : A ; -- cyanblå..av.1
  cyanid_1_N : N ; -- cyanid..nn.1
  cyankalium_1_N : N ; -- cyankalium..nn.1
  cyanobakterie_1_N : N ; -- cyanobakterie..nn.1
  cyanos_1_N : N ; -- cyanos..nn.1
  cyanväte_1_N : N ; -- cyanväte..nn.1
  cyanvätesyra_1_N : N ; -- cyanvätesyra..nn.1
  cyberbrottslighet_1_N : N ; -- cyberbrottslighet..nn.1
  cybernetik_1_N : N ; -- cybernetik..nn.1
  cybernetisk_1_A : A ; -- cybernetisk..av.1
  cyberrymd_1_N : N ; -- cyberrymd..nn.1
  cybersex_1_N : N ; -- cybersex..nn.1
  cyberstrategi_1_N : N ; -- cyberstrategi..nn.1
  cybervärld_1_N : N ; -- cybervärld..nn.1
  cybervåld_1_N : N ; -- cybervåld..nn.1
  cyborg_1_N : N ; -- cyborg..nn.1
  cykel_1_N : N ; -- cykel..nn.1
  cykel_2_N : N ; -- cykel..nn.2
  cykelbana_1_N : N ; -- cykelbana..nn.1
  cykeldäck_1_N : N ; -- cykeldäck..nn.1
  cykelergometer_1_N : N ; -- cykelergometer..nn.1
  cykelhjälm_1_N : N ; -- cykelhjälm..nn.1
  cykelkedja_1_N : N ; -- cykelkedja..nn.1
  cykelklämma_1_N : N ; -- cykelklämma..nn.1
  cykelkrock_1_N : N ; -- cykelkrock..nn.1
  cykelkrok_1_N : N ; -- cykelkrok..nn.1
  cykellykta_1_N : N ; -- cykellykta..nn.1
  cykellås_1_N : N ; -- cykellås..nn.1
  cykelnyckel_1_N : N ; -- cykelnyckel..nn.1
  cykelpump_1_N : N ; -- cykelpump..nn.1
  cykelram_1_N : N ; -- cykelram..nn.1
  cykelsadel_1_N : N ; -- cykelsadel..nn.1
  cykelslang_1_N : N ; -- cykelslang..nn.1
  cykelstyre_1_N : N ; -- cykelstyre..nn.1
  cykelställ_1_N : N ; -- cykelställ..nn.1
  cykelstöld_1_N : N ; -- cykelstöld..nn.1
  cykeltrupp_1_N : N ; -- cykeltrupp..nn.1
  cykeltävling_1_N : N ; -- cykeltävling..nn.1
  cykelutflykt_1_N : N ; -- cykelutflykt..nn.1
  cykelventil_1_N : N ; -- cykelventil..nn.1
  cykelväg_1_N : N ; -- cykelväg..nn.1
  cykelåkning_1_N : N ; -- cykelåkning..nn.1
  cykla_1_V : V ; -- cykla..vb.1
  cyklamat_1_N : N ; -- cyklamat..nn.1
  cyklamen_1_N : N ; -- cyklamen..nn.1
  cyklande_1_N : N ; -- cyklande..nn.1
  cykling_1_N : N ; -- cykling..nn.1
  cyklisk_1_A : A ; -- cyklisk..av.1
  cyklism_1_N : N ; -- cyklism..nn.1
  cyklist_1_N : N ; -- cyklist..nn.1
  cykloid_1_N : N ; -- cykloid..nn.1
  cyklometer_1_N : N ; -- cyklometer..nn.1
  cyklon_1_N : N ; -- cyklon..nn.1
  cyklonartad_1_A : A ; -- cyklonartad..av.1
  cyklonfamilj_1_N : N ; -- cyklonfamilj..nn.1
  cyklop_1_N : N ; -- cyklop..nn.1
  cyklop_2_N : N ; -- cyklop..nn.2
  cyklopisk_1_A : A ; -- cyklopisk..av.1
  cyklopöga_1_N : N ; -- cyklopöga..nn.1
  cyklotron_1_N : N ; -- cyklotron..nn.1
  cyklotym_1_A : A ; -- cyklotym..av.1
  cylinder_1_N : N ; -- cylinder..nn.1
  cylinderblock_1_N : N ; -- cylinderblock..nn.1
  cylinderform_1_N : N ; -- cylinderform..nn.1
  cylinderformad_1_A : A ; -- cylinderformad..av.1
  cylinderglas_1_N : N ; -- cylinderglas..nn.1
  cylinderhatt_1_N : N ; -- cylinderhatt..nn.1
  cylinderlås_1_N : N ; -- cylinderlås..nn.1
  cylinderpress_1_N : N ; -- cylinderpress..nn.1
  cylinderur_1_N : N ; -- cylinderur..nn.1
  cylindrisk_1_A : A ; -- cylindrisk..av.1
  cymbal_1_N : N ; -- cymbal..nn.1
  cymbalklang_1_N : N ; -- cymbalklang..nn.1
  cyniker_1_N : N ; -- cyniker..nn.1
  cynisk_1_A : A ; -- cynisk..av.1
  cynism_1_N : N ; -- cynism..nn.1
  cypress_1_N : N ; -- cypress..nn.1
  cypresskrans_1_N : N ; -- cypresskrans..nn.1
  cypriot_1_N : N ; -- cypriot..nn.1
  cypriotisk_1_A : A ; -- cypriotisk..av.1
  cypriotiska_1_N : N ; -- cypriotiska..nn.1
  cysta_1_N : N ; -- cysta..nn.1
  cystoskop_1_N : N ; -- cystoskop..nn.1
  cystoskopi_1_N : N ; -- cystoskopi..nn.1
  cytologi_1_N : N ; -- cytologi..nn.1
  cytologisk_1_A : A ; -- cytologisk..av.1
  cytoplasma_1_N : N ; -- cytoplasma..nn.1
  dadaism_1_N : N ; -- dadaism..nn.1
  dadaist_1_N : N ; -- dadaist..nn.1
  dadaistisk_1_A : A ; -- dadaistisk..av.1
  dadda_1_N : N ; -- dadda..nn.1
  dadda_1_V : V ; -- dadda..vb.1
  daddande_1_N : N ; -- daddande..nn.1
  dadel_1_N : N ; -- dadel..nn.1
  dadelpalm_1_N : N ; -- dadelpalm..nn.1
  dag_1_N : N ; -- dag..nn.1
  dagakarl_1_N : N ; -- dagakarl..nn.1
  dagaktiv_1_A : A ; -- dagaktiv..av.1
  dagavdelning_1_N : N ; -- dagavdelning..nn.1
  dagbarn_1_N : N ; -- dagbarn..nn.1
  dagbarnvårdare_1_N : N ; -- dagbarnvårdare..nn.1
  dagbefäl_1_N : N ; -- dagbefäl..nn.1
  dagblad_1_N : N ; -- dagblad..nn.1
  dagblind_1_A : A ; -- dagblind..av.1
  dagblindhet_1_N : N ; -- dagblindhet..nn.1
  dagbok_1_N : N ; -- dagbok..nn.1
  dagboksanteckning_1_N : N ; -- dagboksanteckning..nn.1
  dagboksskrivande_1_A : A ; -- dagboksskrivande..av.1
  dagboksskrivande_1_N : N ; -- dagboksskrivande..nn.1
  dagbrott_1_N : N ; -- dagbrott..nn.1
  dagbrytning_1_N : N ; -- dagbrytning..nn.1
  dagbräckning_1_N : N ; -- dagbräckning..nn.1
  dagcentral_1_N : N ; -- dagcentral..nn.1
  dagcentrum_1_N : N ; -- dagcentrum..nn.1
  dagdjur_1_N : N ; -- dagdjur..nn.1
  dagdrivare_1_N : N ; -- dagdrivare..nn.1
  dagdrivarliv_1_N : N ; -- dagdrivarliv..nn.1
  dagdriveri_1_N : N ; -- dagdriveri..nn.1
  dagdröm_1_N : N ; -- dagdröm..nn.1
  dagdrömma_1_V : V ; -- dagdrömma..vb.1
  dagdrömmande_1_N : N ; -- dagdrömmande..nn.1
  dagdrömmare_1_N : N ; -- dagdrömmare..nn.1
  dagdrömmeri_1_N : N ; -- dagdrömmeri..nn.1
  dagenefterhuvudvärk_1_N : N ; -- dagenefterhuvudvärk..nn.1
  dagenefterpiller_1_N : N ; -- dagenefterpiller..nn.1
  dagenefterstämning_1_N : N ; -- dagenefterstämning..nn.1
  dagens_1_N : N ; -- dagens..nn.1
  dager_1_N : N ; -- dager..nn.1
  dagerrotyp_1_N : N ; -- dagerrotyp..nn.1
  dagerrotypi_1_N : N ; -- dagerrotypi..nn.1
  dagfjäril_1_N : N ; -- dagfjäril..nn.1
  dagg_1_N : N ; -- dagg..nn.1
  dagg_2_N : N ; -- dagg..nn.2
  dagga_1_V : V ; -- dagga..vb.1
  daggande_1_N : N ; -- daggande..nn.1
  daggdroppe_1_N : N ; -- daggdroppe..nn.1
  daggert_1_N : N ; -- daggert..nn.1
  daggfrisk_1_A : A ; -- daggfrisk..av.1
  daggig_1_A : A ; -- daggig..av.1
  daggighet_1_N : N ; -- daggighet..nn.1
  daggkåpa_1_N : N ; -- daggkåpa..nn.1
  daggmask_1_N : N ; -- daggmask..nn.1
  daggpunkt_1_N : N ; -- daggpunkt..nn.1
  daggryning_1_N : N ; -- daggryning..nn.1
  daggvåt_1_A : A ; -- daggvåt..av.1
  daghavande_1_A : A ; -- daghavande..av.1
  daghavande_1_N : N ; -- daghavande..nn.1
  daghem_1_N : N ; -- daghem..nn.1
  daghemsföreståndare_1_N : N ; -- daghemsföreståndare..nn.1
  daghemsplats_1_N : N ; -- daghemsplats..nn.1
  dagis_1_N : N ; -- dagis..nn.1
  dagisfröken_1_N : N ; -- dagisfröken..nn.1
  dagisplats_1_N : N ; -- dagisplats..nn.1
  dagjämning_1_N : N ; -- dagjämning..nn.1
  dagjämningspunkt_1_N : N ; -- dagjämningspunkt..nn.1
  dagkarl_1_N : N ; -- dagkarl..nn.1
  dagledig_1_A : A ; -- dagledig..av.1
  daglega_1_N : N ; -- daglega..nn.1
  daglig_1_A : A ; -- daglig..av.1
  dagligdags_1_Adv : Adv ; -- dagligdags..ab.1
  dagligen_1_Adv : Adv ; -- dagligen..ab.1
  daglighet_1_N : N ; -- daglighet..nn.1
  dagligstuga_1_N : N ; -- dagligstuga..nn.1
  dagligvara_1_N : N ; -- dagligvara..nn.1
  daglön_1_N : N ; -- daglön..nn.1
  daglönare_1_N : N ; -- daglönare..nn.1
  dagmamma_1_N : N ; -- dagmamma..nn.1
  dagning_1_N : N ; -- dagning..nn.1
  dago_1_N : N ; -- dago..nn.1
  dagofficer_1_N : N ; -- dagofficer..nn.1
  dagorder_1_N : N ; -- dagorder..nn.1
  dagordning_1_N : N ; -- dagordning..nn.1
  dagort_1_N : N ; -- dagort..nn.1
  dagpenning_1_N : N ; -- dagpenning..nn.1
  dagrum_1_N : N ; -- dagrum..nn.1
  dags_1_N : N ; -- dags..nn.1
  dagsaktuell_1_A : A ; -- dagsaktuell..av.1
  dagsbehov_1_N : N ; -- dagsbehov..nn.1
  dagsbot_1_N : N ; -- dagsbot..nn.1
  dagsedel_1_N : N ; -- dagsedel..nn.1
  dagsfärsk_1_A : A ; -- dagsfärsk..av.1
  dagshetta_1_N : N ; -- dagshetta..nn.1
  dagskassa_1_N : N ; -- dagskassa..nn.1
  dagskryssning_1_N : N ; -- dagskryssning..nn.1
  dagskrönika_1_N : N ; -- dagskrönika..nn.1
  dagsled_1_N : N ; -- dagsled..nn.1
  dagsljus_1_N : N ; -- dagsljus..nn.1
  dagsläge_1_N : N ; -- dagsläge..nn.1
  dagslända_1_N : N ; -- dagslända..nn.1
  dagsländeliv_1_N : N ; -- dagsländeliv..nn.1
  dagslång_1_A : A ; -- dagslång..av.1
  dagsmarsch_1_N : N ; -- dagsmarsch..nn.1
  dagsmeja_1_N : N ; -- dagsmeja..nn.1
  dagsnyhet_1_N : N ; -- dagsnyhet..nn.1
  dagspenning_1_N : N ; -- dagspenning..nn.1
  dagspolitisk_1_A : A ; -- dagspolitisk..av.1
  dagspress_1_N : N ; -- dagspress..nn.1
  dagsprogram_1_N : N ; -- dagsprogram..nn.1
  dagsranson_1_N : N ; -- dagsranson..nn.1
  dagsregn_1_N : N ; -- dagsregn..nn.1
  dagsresa_1_N : N ; -- dagsresa..nn.1
  dagstemperatur_1_N : N ; -- dagstemperatur..nn.1
  dagstidning_1_N : N ; -- dagstidning..nn.1
  dagstidningsredaktör_1_N : N ; -- dagstidningsredaktör..nn.1
  dagsverkare_1_N : N ; -- dagsverkare..nn.1
  dagsverke_1_N : N ; -- dagsverke..nn.1
  dagsvers_1_N : N ; -- dagsvers..nn.1
  dagsversskribent_1_N : N ; -- dagsversskribent..nn.1
  dagsvärde_1_N : N ; -- dagsvärde..nn.1
  dagteckna_1_V : V ; -- dagteckna..vb.1
  dagtecknande_1_N : N ; -- dagtecknande..nn.1
  dagteckning_1_N : N ; -- dagteckning..nn.1
  dagtid_1_N : N ; -- dagtid..nn.1
  dagtinga_1_V : V ; -- dagtinga..vb.1
  dagtingande_1_N : N ; -- dagtingande..nn.1
  dagtraktamente_1_N : N ; -- dagtraktamente..nn.1
  dagtåg_1_N : N ; -- dagtåg..nn.1
  dagvakt_1_N : N ; -- dagvakt..nn.1
  dagvatten_1_N : N ; -- dagvatten..nn.1
  dagvill_1_A : A ; -- dagvill..av.1
  dagvillhet_1_N : N ; -- dagvillhet..nn.1
  dagvård_1_N : N ; -- dagvård..nn.1
  dagöppning_1_N : N ; -- dagöppning..nn.1
  dahlia_1_N : N ; -- dahlia..nn.1
  dakapo_1_N : N ; -- dakapo..nn.1
  daktyl_1_N : N ; -- daktyl..nn.1
  daktylisk_1_A : A ; -- daktylisk..av.1
  dal_1_N : N ; -- dal..nn.1
  dala_1_V : V ; -- dala..vb.1
  dalahäst_1_N : N ; -- dalahäst..nn.1
  dalamässig_1_A : A ; -- dalamässig..av.1
  dalande_1_N : N ; -- dalande..nn.1
  dalbo_1_N : N ; -- dalbo..nn.1
  dalbotten_1_N : N ; -- dalbotten..nn.1
  daldans_1_N : N ; -- daldans..nn.1
  daler_1_N : N ; -- daler..nn.1
  dalgång_1_N : N ; -- dalgång..nn.1
  dalj_1_N : N ; -- dalj..nn.1
  dalkarl_1_N : N ; -- dalkarl..nn.1
  dalkjusa_1_N : N ; -- dalkjusa..nn.1
  dalkulla_1_N : N ; -- dalkulla..nn.1
  daller_1_N : N ; -- daller..nn.1
  dallergräs_1_N : N ; -- dallergräs..nn.1
  dallra_1_V : V ; -- dallra..vb.1
  dallrande_1_N : N ; -- dallrande..nn.1
  dallring_1_N : N ; -- dallring..nn.1
  dalmas_1_N : N ; -- dalmas..nn.1
  dalmatiner_1_N : N ; -- dalmatiner..nn.1
  dalmål_1_N : N ; -- dalmål..nn.1
  dalmålning_1_N : N ; -- dalmålning..nn.1
  dalning_1_N : N ; -- dalning..nn.1
  dalprofil_1_N : N ; -- dalprofil..nn.1
  dalripa_1_N : N ; -- dalripa..nn.1
  dalsk_1_A : A ; -- dalsk..av.1
  dalska_1_N : N ; -- dalska..nn.1
  dalskida_1_N : N ; -- dalskida..nn.1
  dalsluttning_1_N : N ; -- dalsluttning..nn.1
  dalsländsk_1_A : A ; -- dalsländsk..av.1
  dalsländska_1_N : N ; -- dalsländska..nn.1
  dalsländska_2_N : N ; -- dalsländska..nn.2
  dalslänning_1_N : N ; -- dalslänning..nn.1
  dalsänka_1_N : N ; -- dalsänka..nn.1
  dalt_1_N : N ; -- dalt..nn.1
  dalta_1_V : V ; -- dalta..vb.1
  daltande_1_N : N ; -- daltande..nn.1
  dalvind_1_N : N ; -- dalvind..nn.1
  dam_1_N : N ; -- dam..nn.1
  dam_2_N : N ; -- dam..nn.2
  damask_1_N : N ; -- damask..nn.1
  damaskenerklinga_1_N : N ; -- damaskenerklinga..nn.1
  damaskenerstål_1_N : N ; -- damaskenerstål..nn.1
  damaskering_1_N : N ; -- damaskering..nn.1
  damast_1_N : N ; -- damast..nn.1
  damastduk_1_N : N ; -- damastduk..nn.1
  damastservett_1_N : N ; -- damastservett..nn.1
  dambesök_1_N : N ; -- dambesök..nn.1
  dambinda_1_N : N ; -- dambinda..nn.1
  dambjudning_1_N : N ; -- dambjudning..nn.1
  dambricka_1_N : N ; -- dambricka..nn.1
  dambräde_1_N : N ; -- dambräde..nn.1
  damcykel_1_N : N ; -- damcykel..nn.1
  damejeanne_1_N : N ; -- damejeanne..nn.1
  damfotboll_1_N : N ; -- damfotboll..nn.1
  damfrisering_1_N : N ; -- damfrisering..nn.1
  damfrisör_1_N : N ; -- damfrisör..nn.1
  damfrisörska_1_N : N ; -- damfrisörska..nn.1
  damgambit_1_N : N ; -- damgambit..nn.1
  damhandske_1_N : N ; -- damhandske..nn.1
  damhatt_1_N : N ; -- damhatt..nn.1
  damig_1_A : A ; -- damig..av.1
  damkonfektion_1_N : N ; -- damkonfektion..nn.1
  damkör_1_N : N ; -- damkör..nn.1
  damlag_1_N : N ; -- damlag..nn.1
  damlandslag_1_N : N ; -- damlandslag..nn.1
  damm_1_N : N ; -- damm..nn.1
  damm_2_N : N ; -- damm..nn.2
  damma_1_V : V ; -- damma..vb.1
  damma_2_V : V ; -- damma..vb.2
  dammande_1_N : N ; -- dammande..nn.1
  dammanläggning_1_N : N ; -- dammanläggning..nn.1
  dammbindningsmedel_1_N : N ; -- dammbindningsmedel..nn.1
  dammbygge_1_N : N ; -- dammbygge..nn.1
  dammfri_1_A : A ; -- dammfri..av.1
  dammfäste_1_N : N ; -- dammfäste..nn.1
  dammförsök_1_N : N ; -- dammförsök..nn.1
  dammgömma_1_N : N ; -- dammgömma..nn.1
  dammig_1_A : A ; -- dammig..av.1
  dammighet_1_N : N ; -- dammighet..nn.1
  dammkorn_1_N : N ; -- dammkorn..nn.1
  dammkvalster_1_N : N ; -- dammkvalster..nn.1
  dammlager_1_N : N ; -- dammlager..nn.1
  dammlucka_1_N : N ; -- dammlucka..nn.1
  dammlunga_1_N : N ; -- dammlunga..nn.1
  dammode_1_N : N ; -- dammode..nn.1
  dammodell_1_N : N ; -- dammodell..nn.1
  dammoln_1_N : N ; -- dammoln..nn.1
  dammport_1_N : N ; -- dammport..nn.1
  dammpump_1_N : N ; -- dammpump..nn.1
  dammråtta_1_N : N ; -- dammråtta..nn.1
  dammspiral_1_N : N ; -- dammspiral..nn.1
  dammsuga_1_V : V ; -- dammsuga..vb.1
  dammsugande_1_N : N ; -- dammsugande..nn.1
  dammsugaragent_1_N : N ; -- dammsugaragent..nn.1
  dammsugare_1_N : N ; -- dammsugare..nn.1
  dammsugarförsäljning_1_N : N ; -- dammsugarförsäljning..nn.1
  dammsugarpåse_1_N : N ; -- dammsugarpåse..nn.1
  dammsugning_1_N : N ; -- dammsugning..nn.1
  dammsäkerhet_1_N : N ; -- dammsäkerhet..nn.1
  dammtorka_1_V : V ; -- dammtorka..vb.1
  dammtorkande_1_N : N ; -- dammtorkande..nn.1
  dammtrasa_1_N : N ; -- dammtrasa..nn.1
  dammussla_1_N : N ; -- dammussla..nn.1
  dammvippa_1_N : N ; -- dammvippa..nn.1
  dammvirvel_1_N : N ; -- dammvirvel..nn.1
  damning_1_N : N ; -- damning..nn.1
  damoklessvärd_1_N : N ; -- damoklessvärd..nn.1
  dampa_1_V : V ; -- dampa..vb.1
  dampa_2_V : V ; -- dampa..vb.2
  dampande_1_N : N ; -- dampande..nn.1
  dampjäs_1_N : N ; -- dampjäs..nn.1
  damrum_1_N : N ; -- damrum..nn.1
  damsida_1_N : N ; -- damsida..nn.1
  damsingel_1_N : N ; -- damsingel..nn.1
  damskjorta_1_N : N ; -- damskjorta..nn.1
  damsko_1_N : N ; -- damsko..nn.1
  damslalom_1_N : N ; -- damslalom..nn.1
  damspel_1_N : N ; -- damspel..nn.1
  damstrumpa_1_N : N ; -- damstrumpa..nn.1
  damsällskap_1_N : N ; -- damsällskap..nn.1
  damtidning_1_N : N ; -- damtidning..nn.1
  damtoalett_1_N : N ; -- damtoalett..nn.1
  damur_1_N : N ; -- damur..nn.1
  damväska_1_N : N ; -- damväska..nn.1
  dan_1_A : A ; -- dan..av.1
  dana_1_V : V ; -- dana..vb.1
  danaarv_1_N : N ; -- danaarv..nn.1
  danad_1_A : A ; -- danad..av.1
  danande_1_N : N ; -- danande..nn.1
  danare_1_N : N ; -- danare..nn.1
  dandy_1_N : N ; -- dandy..nn.1
  dangla_1_V : V ; -- dangla..vb.1
  danglande_1_N : N ; -- danglande..nn.1
  daning_1_N : N ; -- daning..nn.1
  danism_1_N : N ; -- danism..nn.1
  dank_1_N : N ; -- dank..nn.1
  dann_1_A : A ; -- dann..av.1
  danneman_1_N : N ; -- danneman..nn.1
  dans_1_N : N ; -- dans..nn.1
  dansa_1_V : V ; -- dansa..vb.1
  dansande_1_N : N ; -- dansande..nn.1
  dansant_1_A : A ; -- dansant..av.1
  dansare_1_N : N ; -- dansare..nn.1
  dansbana_1_N : N ; -- dansbana..nn.1
  dansband_1_N : N ; -- dansband..nn.1
  dansbandskultur_1_N : N ; -- dansbandskultur..nn.1
  dansbandsvecka_1_N : N ; -- dansbandsvecka..nn.1
  dansbaneelände_1_N : N ; -- dansbaneelände..nn.1
  danserska_1_N : N ; -- danserska..nn.1
  dansförbud_1_N : N ; -- dansförbud..nn.1
  dansgille_1_N : N ; -- dansgille..nn.1
  dansgolv_1_N : N ; -- dansgolv..nn.1
  dansgolvslejon_1_N : N ; -- dansgolvslejon..nn.1
  danshak_1_N : N ; -- danshak..nn.1
  dansk_1_A : A ; -- dansk..av.1
  dansk_1_N : N ; -- dansk..nn.1
  danska_1_N : N ; -- danska..nn.1
  danska_2_N : N ; -- danska..nn.2
  danskhat_1_N : N ; -- danskhat..nn.1
  danskhet_1_N : N ; -- danskhet..nn.1
  danskonst_1_N : N ; -- danskonst..nn.1
  dansktalande_1_A : A ; -- dansktalande..av.1
  danskägd_1_A : A ; -- danskägd..av.1
  dansledare_1_N : N ; -- dansledare..nn.1
  danslek_1_N : N ; -- danslek..nn.1
  danslektion_1_N : N ; -- danslektion..nn.1
  danslysten_1_A : A ; -- danslysten..av.1
  dansmusik_1_N : N ; -- dansmusik..nn.1
  dansmässig_1_A : A ; -- dansmässig..av.1
  dansmästare_1_N : N ; -- dansmästare..nn.1
  dansorkester_1_N : N ; -- dansorkester..nn.1
  dansrestaurang_1_N : N ; -- dansrestaurang..nn.1
  dansrytm_1_N : N ; -- dansrytm..nn.1
  danssalong_1_N : N ; -- danssalong..nn.1
  danssjuka_1_N : N ; -- danssjuka..nn.1
  danssko_1_N : N ; -- danssko..nn.1
  dansskola_1_N : N ; -- dansskola..nn.1
  danssteg_1_N : N ; -- danssteg..nn.1
  dansställe_1_N : N ; -- dansställe..nn.1
  danstakt_1_N : N ; -- danstakt..nn.1
  danstillställning_1_N : N ; -- danstillställning..nn.1
  dansundervisning_1_N : N ; -- dansundervisning..nn.1
  dansvimmel_1_N : N ; -- dansvimmel..nn.1
  dansvänlig_1_A : A ; -- dansvänlig..av.1
  dansör_1_N : N ; -- dansör..nn.1
  dansös_1_N : N ; -- dansös..nn.1
  darr_1_N : N ; -- darr..nn.1
  darra_1_V : V ; -- darra..vb.1
  darrande_1_A : A ; -- darrande..av.1
  darrande_1_N : N ; -- darrande..nn.1
  darrgräs_1_N : N ; -- darrgräs..nn.1
  darrhänt_1_A : A ; -- darrhänt..av.1
  darrhänthet_1_N : N ; -- darrhänthet..nn.1
  darrig_1_A : A ; -- darrig..av.1
  darrighet_1_N : N ; -- darrighet..nn.1
  darrning_1_N : N ; -- darrning..nn.1
  darrocka_1_N : N ; -- darrocka..nn.1
  darrål_1_N : N ; -- darrål..nn.1
  dart_1_N : N ; -- dart..nn.1
  dartpil_1_N : N ; -- dartpil..nn.1
  dartspel_1_N : N ; -- dartspel..nn.1
  darttavla_1_N : N ; -- darttavla..nn.1
  darwinfink_1_N : N ; -- darwinfink..nn.1
  darwinism_1_N : N ; -- darwinism..nn.1
  darwinist_1_N : N ; -- darwinist..nn.1
  darwinistisk_1_A : A ; -- darwinistisk..av.1
  dask_1_N : N ; -- dask..nn.1
  daska_1_V : V ; -- daska..vb.1
  daskande_1_N : N ; -- daskande..nn.1
  daskig_1_A : A ; -- daskig..av.1
  daskighet_1_N : N ; -- daskighet..nn.1
  dass_1_N : N ; -- dass..nn.1
  dassa_1_V : V ; -- dassa..vb.1
  dassande_1_N : N ; -- dassande..nn.1
  dassig_1_A : A ; -- dassig..av.1
  dassighet_1_N : N ; -- dassighet..nn.1
  dasspapper_1_N : N ; -- dasspapper..nn.1
  dat_1_N : N ; -- dat..nn.1
  data_1_N : N ; -- data..nn.1
  data_2_N : N ; -- data..nn.2
  dataanläggning_1_N : N ; -- dataanläggning..nn.1
  databank_1_N : N ; -- databank..nn.1
  databas_1_N : N ; -- databas..nn.1
  databearbetning_1_N : N ; -- databearbetning..nn.1
  databehandla_1_V : V ; -- databehandla..vb.1
  databehandlande_1_N : N ; -- databehandlande..nn.1
  databehandling_1_N : N ; -- databehandling..nn.1
  datacentral_1_N : N ; -- datacentral..nn.1
  datafil_1_N : N ; -- datafil..nn.1
  dataformat_1_N : N ; -- dataformat..nn.1
  datahackare_1_N : N ; -- datahackare..nn.1
  datahaveri_1_N : N ; -- datahaveri..nn.1
  datainsamling_1_N : N ; -- datainsamling..nn.1
  datainsamlingskampanj_1_N : N ; -- datainsamlingskampanj..nn.1
  dataintensiv_1_A : A ; -- dataintensiv..av.1
  dataintrång_1_N : N ; -- dataintrång..nn.1
  dataintrångsskandal_1_N : N ; -- dataintrångsskandal..nn.1
  datakommunikation_1_N : N ; -- datakommunikation..nn.1
  datakraft_1_N : N ; -- datakraft..nn.1
  datakrasch_1_N : N ; -- datakrasch..nn.1
  datakörning_1_N : N ; -- datakörning..nn.1
  datalagring_1_N : N ; -- datalagring..nn.1
  datalagringsdirektiv_1_N : N ; -- datalagringsdirektiv..nn.1
  datalagringsföretag_1_N : N ; -- datalagringsföretag..nn.1
  datalingvistik_1_N : N ; -- datalingvistik..nn.1
  datalogi_1_N : N ; -- datalogi..nn.1
  datamaskin_1_N : N ; -- datamaskin..nn.1
  datamaskinell_1_A : A ; -- datamaskinell..av.1
  datamaterial_1_N : N ; -- datamaterial..nn.1
  dataminne_1_N : N ; -- dataminne..nn.1
  datamängd_1_N : N ; -- datamängd..nn.1
  datanät_1_N : N ; -- datanät..nn.1
  datapolitik_1_N : N ; -- datapolitik..nn.1
  datapolitisk_1_A : A ; -- datapolitisk..av.1
  dataprogram_1_N : N ; -- dataprogram..nn.1
  dataregister_1_N : N ; -- dataregister..nn.1
  datasimulering_1_N : N ; -- datasimulering..nn.1
  dataskärm_1_N : N ; -- dataskärm..nn.1
  dataspel_1_N : N ; -- dataspel..nn.1
  datasystem_1_N : N ; -- datasystem..nn.1
  dataterminal_1_N : N ; -- dataterminal..nn.1
  datautbyte_1_N : N ; -- datautbyte..nn.1
  datautbytesöverenskommelse_1_N : N ; -- datautbytesöverenskommelse..nn.1
  datavirus_1_N : N ; -- datavirus..nn.1
  datavision_1_N : N ; -- datavision..nn.1
  date_1_N : N ; -- date..nn.1
  datera_1_V : V ; -- datera..vb.1
  daterande_1_N : N ; -- daterande..nn.1
  daterbar_1_A : A ; -- daterbar..av.1
  daterbarhet_1_N : N ; -- daterbarhet..nn.1
  datering_1_N : N ; -- datering..nn.1
  dateringsmetod_1_N : N ; -- dateringsmetod..nn.1
  dativ_1_N : N ; -- dativ..nn.1
  dativform_1_N : N ; -- dativform..nn.1
  dativobjekt_1_N : N ; -- dativobjekt..nn.1
  dato_1_N : N ; -- dato..nn.1
  dator_1_N : N ; -- dator..nn.1
  datoradress_1_N : N ; -- datoradress..nn.1
  datoranimera_1_V : V ; -- datoranimera..vb.1
  datoranimerad_1_A : A ; -- datoranimerad..av.1
  datoranimerande_1_N : N ; -- datoranimerande..nn.1
  datoranimering_1_N : N ; -- datoranimering..nn.1
  datoranläggning_1_N : N ; -- datoranläggning..nn.1
  datorbaserad_1_A : A ; -- datorbaserad..av.1
  datorbearbetning_1_N : N ; -- datorbearbetning..nn.1
  datorbehandling_1_N : N ; -- datorbehandling..nn.1
  datorberäkning_1_N : N ; -- datorberäkning..nn.1
  datordrift_1_N : N ; -- datordrift..nn.1
  datorfodral_1_N : N ; -- datorfodral..nn.1
  datorförsäljning_1_N : N ; -- datorförsäljning..nn.1
  datorhaveri_1_N : N ; -- datorhaveri..nn.1
  datorintrång_1_N : N ; -- datorintrång..nn.1
  datorisera_1_V : V ; -- datorisera..vb.1
  datoriserande_1_N : N ; -- datoriserande..nn.1
  datoriserbar_1_A : A ; -- datoriserbar..av.1
  datoriserbarhet_1_N : N ; -- datoriserbarhet..nn.1
  datorisering_1_N : N ; -- datorisering..nn.1
  datorkommunikation_1_N : N ; -- datorkommunikation..nn.1
  datorkraft_1_N : N ; -- datorkraft..nn.1
  datorlingvistik_1_N : N ; -- datorlingvistik..nn.1
  datorminne_1_N : N ; -- datorminne..nn.1
  datormodell_1_N : N ; -- datormodell..nn.1
  datormässa_1_N : N ; -- datormässa..nn.1
  datorprogram_1_N : N ; -- datorprogram..nn.1
  datorprogrammerare_1_N : N ; -- datorprogrammerare..nn.1
  datorrelaterad_1_A : A ; -- datorrelaterad..av.1
  datorsimulera_1_V : V ; -- datorsimulera..vb.1
  datorsimulerande_1_N : N ; -- datorsimulerande..nn.1
  datorsimulering_1_N : N ; -- datorsimulering..nn.1
  datorskärm_1_N : N ; -- datorskärm..nn.1
  datorsladd_1_N : N ; -- datorsladd..nn.1
  datorstöd_1_N : N ; -- datorstöd..nn.1
  datorsystem_1_N : N ; -- datorsystem..nn.1
  datortelefon_1_N : N ; -- datortelefon..nn.1
  datortomografi_1_N : N ; -- datortomografi..nn.1
  datorutrustning_1_N : N ; -- datorutrustning..nn.1
  datorvirus_1_N : N ; -- datorvirus..nn.1
  datorväxel_1_N : N ; -- datorväxel..nn.1
  datta_1_V : V ; -- datta..vb.1
  dattande_1_N : N ; -- dattande..nn.1
  datten_1_N : N ; -- datten..nn.1
  datum_1_N : N ; -- datum..nn.1
  datumgräns_1_N : N ; -- datumgräns..nn.1
  datummärka_1_V : V ; -- datummärka..vb.1
  datummärkande_1_N : N ; -- datummärkande..nn.1
  datummärkning_1_N : N ; -- datummärkning..nn.1
  datumparkera_1_V : V ; -- datumparkera..vb.1
  datumparkerande_1_N : N ; -- datumparkerande..nn.1
  datumparkerbar_1_A : A ; -- datumparkerbar..av.1
  datumparkerbarhet_1_N : N ; -- datumparkerbarhet..nn.1
  datumparkering_1_N : N ; -- datumparkering..nn.1
  datumstämpel_1_N : N ; -- datumstämpel..nn.1
  datumvisare_1_N : N ; -- datumvisare..nn.1
  davidsstjärna_1_N : N ; -- davidsstjärna..nn.1
  deadline_1_N : N ; -- deadline..nn.1
  deaktivera_1_V : V ; -- deaktivera..vb.1
  deaktiverande_1_N : N ; -- deaktiverande..nn.1
  deaktiverbar_1_A : A ; -- deaktiverbar..av.1
  deaktiverbarhet_1_N : N ; -- deaktiverbarhet..nn.1
  deaktivering_1_N : N ; -- deaktivering..nn.1
  debacle_1_N : N ; -- debacle..nn.1
  debarkera_1_V : V ; -- debarkera..vb.1
  debarkerande_1_N : N ; -- debarkerande..nn.1
  debarkerbar_1_A : A ; -- debarkerbar..av.1
  debarkerbarhet_1_N : N ; -- debarkerbarhet..nn.1
  debarkering_1_N : N ; -- debarkering..nn.1
  debatt_1_N : N ; -- debatt..nn.1
  debattartikel_1_N : N ; -- debattartikel..nn.1
  debattdeltagare_1_N : N ; -- debattdeltagare..nn.1
  debattera_1_V : V ; -- debattera..vb.1
  debatterande_1_N : N ; -- debatterande..nn.1
  debatterbar_1_A : A ; -- debatterbar..av.1
  debatterbarhet_1_N : N ; -- debatterbarhet..nn.1
  debattering_1_N : N ; -- debattering..nn.1
  debattforum_1_N : N ; -- debattforum..nn.1
  debattinlägg_1_N : N ; -- debattinlägg..nn.1
  debattknep_1_N : N ; -- debattknep..nn.1
  debattmässig_1_A : A ; -- debattmässig..av.1
  debattprogram_1_N : N ; -- debattprogram..nn.1
  debattsida_1_N : N ; -- debattsida..nn.1
  debattör_1_N : N ; -- debattör..nn.1
  debet_1_N : N ; -- debet..nn.1
  debetsedel_1_N : N ; -- debetsedel..nn.1
  debetsida_1_N : N ; -- debetsida..nn.1
  debetsumma_1_N : N ; -- debetsumma..nn.1
  debil_1_A : A ; -- debil..av.1
  debilitet_1_N : N ; -- debilitet..nn.1
  debit_1_N : N ; -- debit..nn.1
  debitera_1_V : V ; -- debitera..vb.1
  debiterande_1_N : N ; -- debiterande..nn.1
  debiterbar_1_A : A ; -- debiterbar..av.1
  debiterbarhet_1_N : N ; -- debiterbarhet..nn.1
  debitering_1_N : N ; -- debitering..nn.1
  debut_1_N : N ; -- debut..nn.1
  debutalbum_1_N : N ; -- debutalbum..nn.1
  debutant_1_N : N ; -- debutant..nn.1
  debutbok_1_N : N ; -- debutbok..nn.1
  debutera_1_V : V ; -- debutera..vb.1
  debuterande_1_N : N ; -- debuterande..nn.1
  debutering_1_N : N ; -- debutering..nn.1
  debutroman_1_N : N ; -- debutroman..nn.1
  december_1_N : N ; -- december..nn.1
  decemberkväll_1_N : N ; -- decemberkväll..nn.1
  decennium_1_N : N ; -- decennium..nn.1
  decentralisation_1_N : N ; -- decentralisation..nn.1
  decentralisera_1_V : V ; -- decentralisera..vb.1
  decentraliserande_1_N : N ; -- decentraliserande..nn.1
  decentraliserbar_1_A : A ; -- decentraliserbar..av.1
  decentraliserbarhet_1_N : N ; -- decentraliserbarhet..nn.1
  decentralisering_1_N : N ; -- decentralisering..nn.1
  decharge_1_N : N ; -- decharge..nn.1
  dechargedebatt_1_N : N ; -- dechargedebatt..nn.1
  dechiffrera_1_V : V ; -- dechiffrera..vb.1
  dechiffrerande_1_N : N ; -- dechiffrerande..nn.1
  dechiffrerbar_1_A : A ; -- dechiffrerbar..av.1
  dechiffrerbarhet_1_N : N ; -- dechiffrerbarhet..nn.1
  dechiffrering_1_N : N ; -- dechiffrering..nn.1
  decibel_1_N : N ; -- decibel..nn.1
  deciderad_1_A : A ; -- deciderad..av.1
  deciliter_1_N : N ; -- deciliter..nn.1
  decilitermått_1_N : N ; -- decilitermått..nn.1
  decimal_1_N : N ; -- decimal..nn.1
  decimalbråk_1_N : N ; -- decimalbråk..nn.1
  decimalkomma_1_N : N ; -- decimalkomma..nn.1
  decimalsystem_1_N : N ; -- decimalsystem..nn.1
  decimaltal_1_N : N ; -- decimaltal..nn.1
  decimaltecken_1_N : N ; -- decimaltecken..nn.1
  decimera_1_V : V ; -- decimera..vb.1
  decimerande_1_N : N ; -- decimerande..nn.1
  decimerbar_1_A : A ; -- decimerbar..av.1
  decimerbarhet_1_N : N ; -- decimerbarhet..nn.1
  decimering_1_N : N ; -- decimering..nn.1
  decimeter_1_N : N ; -- decimeter..nn.1
  decimeterlång_1_A : A ; -- decimeterlång..av.1
  decimeterstor_1_A : A ; -- decimeterstor..av.1
  deciton_1_N : N ; -- deciton..nn.1
  deckardrottning_1_N : N ; -- deckardrottning..nn.1
  deckare_1_N : N ; -- deckare..nn.1
  deckarförfattare_1_N : N ; -- deckarförfattare..nn.1
  deckarkung_1_N : N ; -- deckarkung..nn.1
  dedicera_1_V : V ; -- dedicera..vb.1
  dedicerande_1_N : N ; -- dedicerande..nn.1
  dedicerbar_1_A : A ; -- dedicerbar..av.1
  dedicerbarhet_1_N : N ; -- dedicerbarhet..nn.1
  dedicering_1_N : N ; -- dedicering..nn.1
  dedikation_1_N : N ; -- dedikation..nn.1
  dedikationsexemplar_1_N : N ; -- dedikationsexemplar..nn.1
  dedikera_1_V : V ; -- dedikera..vb.1
  dedikerande_1_N : N ; -- dedikerande..nn.1
  dedikerbar_1_A : A ; -- dedikerbar..av.1
  dedikerbarhet_1_N : N ; -- dedikerbarhet..nn.1
  dedikering_1_N : N ; -- dedikering..nn.1
  deducera_1_V : V ; -- deducera..vb.1
  deducerande_1_N : N ; -- deducerande..nn.1
  deducerbar_1_A : A ; -- deducerbar..av.1
  deducerbarhet_1_N : N ; -- deducerbarhet..nn.1
  deducering_1_N : N ; -- deducering..nn.1
  deduktion_1_N : N ; -- deduktion..nn.1
  deduktiv_1_A : A ; -- deduktiv..av.1
  defaitism_1_N : N ; -- defaitism..nn.1
  defaitist_1_N : N ; -- defaitist..nn.1
  defaitistisk_1_A : A ; -- defaitistisk..av.1
  defekt_1_A : A ; -- defekt..av.1
  defekt_1_N : N ; -- defekt..nn.1
  defenestrera_1_V : V ; -- defenestrera..vb.1
  defenestrerande_1_N : N ; -- defenestrerande..nn.1
  defenestrering_1_N : N ; -- defenestrering..nn.1
  defensiv_1_A : A ; -- defensiv..av.1
  defensiv_1_N : N ; -- defensiv..nn.1
  defibrillator_1_N : N ; -- defibrillator..nn.1
  deficit_1_N : N ; -- deficit..nn.1
  defilera_1_V : V ; -- defilera..vb.1
  defilerande_1_N : N ; -- defilerande..nn.1
  defilerbar_1_A : A ; -- defilerbar..av.1
  defilerbarhet_1_N : N ; -- defilerbarhet..nn.1
  defilering_1_N : N ; -- defilering..nn.1
  defilé_1_N : N ; -- defilé..nn.1
  definiera_1_V : V ; -- definiera..vb.1
  definierande_1_N : N ; -- definierande..nn.1
  definierbar_1_A : A ; -- definierbar..av.1
  definierbarhet_1_N : N ; -- definierbarhet..nn.1
  definiering_1_N : N ; -- definiering..nn.1
  definit_1_A : A ; -- definit..av.1
  definithet_1_N : N ; -- definithet..nn.1
  definition_1_N : N ; -- definition..nn.1
  definitionsmängd_1_N : N ; -- definitionsmängd..nn.1
  definitionsmässig_1_A : A ; -- definitionsmässig..av.1
  definitionsmässighet_1_N : N ; -- definitionsmässighet..nn.1
  definitiv_1_A : A ; -- definitiv..av.1
  deflagration_1_N : N ; -- deflagration..nn.1
  deflation_1_N : N ; -- deflation..nn.1
  defloration_1_N : N ; -- defloration..nn.1
  deflorera_1_V : V ; -- deflorera..vb.1
  deflorerande_1_N : N ; -- deflorerande..nn.1
  deflorerbar_1_A : A ; -- deflorerbar..av.1
  deflorerbarhet_1_N : N ; -- deflorerbarhet..nn.1
  deflorering_1_N : N ; -- deflorering..nn.1
  deformation_1_N : N ; -- deformation..nn.1
  deformera_1_V : V ; -- deformera..vb.1
  deformerande_1_N : N ; -- deformerande..nn.1
  deformerbar_1_A : A ; -- deformerbar..av.1
  deformerbarhet_1_N : N ; -- deformerbarhet..nn.1
  deformering_1_N : N ; -- deformering..nn.1
  deformitet_1_N : N ; -- deformitet..nn.1
  defroster_1_N : N ; -- defroster..nn.1
  deg_1_N : N ; -- deg..nn.1
  deg_2_N : N ; -- deg..nn.2
  dega_1_V : V ; -- dega..vb.1
  degande_1_N : N ; -- degande..nn.1
  degartad_1_A : A ; -- degartad..av.1
  degel_1_N : N ; -- degel..nn.1
  degeneration_1_N : N ; -- degeneration..nn.1
  degenerativ_1_A : A ; -- degenerativ..av.1
  degenerera_1_V : V ; -- degenerera..vb.1
  degenererande_1_N : N ; -- degenererande..nn.1
  degenererbar_1_A : A ; -- degenererbar..av.1
  degenererbarhet_1_N : N ; -- degenererbarhet..nn.1
  degenerering_1_N : N ; -- degenerering..nn.1
  degig_1_A : A ; -- degig..av.1
  deglaciation_1_N : N ; -- deglaciation..nn.1
  dego_1_N : N ; -- dego..nn.1
  degradation_1_N : N ; -- degradation..nn.1
  degradera_1_V : V ; -- degradera..vb.1
  degraderande_1_N : N ; -- degraderande..nn.1
  degraderbar_1_A : A ; -- degraderbar..av.1
  degraderbarhet_1_N : N ; -- degraderbarhet..nn.1
  degradering_1_N : N ; -- degradering..nn.1
  degrand_1_N : N ; -- degrand..nn.1
  degression_1_N : N ; -- degression..nn.1
  degspad_1_N : N ; -- degspad..nn.1
  degspade_1_N : N ; -- degspade..nn.1
  degustera_1_V : V ; -- degustera..vb.1
  degusterande_1_N : N ; -- degusterande..nn.1
  degustering_1_N : N ; -- degustering..nn.1
  deiktisk_1_A : A ; -- deiktisk..av.1
  deism_1_N : N ; -- deism..nn.1
  deist_1_N : N ; -- deist..nn.1
  deistisk_1_A : A ; -- deistisk..av.1
  deja_1_N : N ; -- deja..nn.1
  dejlig_1_A : A ; -- dejlig..av.1
  dejlighet_1_N : N ; -- dejlighet..nn.1
  dejsa_1_V : V ; -- dejsa..vb.1
  dejsande_1_N : N ; -- dejsande..nn.1
  dejt_1_N : N ; -- dejt..nn.1
  dejta_1_V : V ; -- dejta..vb.1
  dejtande_1_N : N ; -- dejtande..nn.1
  dejting_1_N : N ; -- dejting..nn.1
  dejtingsajt_1_N : N ; -- dejtingsajt..nn.1
  dejtingtips_1_N : N ; -- dejtingtips..nn.1
  dekad_1_N : N ; -- dekad..nn.1
  dekadans_1_N : N ; -- dekadans..nn.1
  dekadens_1_N : N ; -- dekadens..nn.1
  dekadent_1_A : A ; -- dekadent..av.1
  dekadisk_1_A : A ; -- dekadisk..av.1
  dekal_1_N : N ; -- dekal..nn.1
  dekalkomani_1_N : N ; -- dekalkomani..nn.1
  dekalog_1_N : N ; -- dekalog..nn.1
  dekan_1_N : N ; -- dekan..nn.1
  dekanat_1_N : N ; -- dekanat..nn.1
  dekantera_1_V : V ; -- dekantera..vb.1
  dekanterande_1_N : N ; -- dekanterande..nn.1
  dekanterbar_1_A : A ; -- dekanterbar..av.1
  dekanterbarhet_1_N : N ; -- dekanterbarhet..nn.1
  dekantering_1_N : N ; -- dekantering..nn.1
  dekanus_1_N : N ; -- dekanus..nn.1
  dekapitera_1_V : V ; -- dekapitera..vb.1
  dekapiterande_1_N : N ; -- dekapiterande..nn.1
  dekapiterbar_1_A : A ; -- dekapiterbar..av.1
  dekapiterbarhet_1_N : N ; -- dekapiterbarhet..nn.1
  dekapitering_1_N : N ; -- dekapitering..nn.1
  deklamation_1_N : N ; -- deklamation..nn.1
  deklamatorisk_1_A : A ; -- deklamatorisk..av.1
  deklamatör_1_N : N ; -- deklamatör..nn.1
  deklamera_1_V : V ; -- deklamera..vb.1
  deklamerande_1_N : N ; -- deklamerande..nn.1
  deklamerbar_1_A : A ; -- deklamerbar..av.1
  deklamerbarhet_1_N : N ; -- deklamerbarhet..nn.1
  deklamering_1_N : N ; -- deklamering..nn.1
  deklarant_1_N : N ; -- deklarant..nn.1
  deklaration_1_N : N ; -- deklaration..nn.1
  deklarationsblankett_1_N : N ; -- deklarationsblankett..nn.1
  deklarationsdags_1_N : N ; -- deklarationsdags..nn.1
  deklarera_1_V : V ; -- deklarera..vb.1
  deklarerande_1_N : N ; -- deklarerande..nn.1
  deklarerbar_1_A : A ; -- deklarerbar..av.1
  deklarerbarhet_1_N : N ; -- deklarerbarhet..nn.1
  deklarering_1_N : N ; -- deklarering..nn.1
  deklassera_1_V : V ; -- deklassera..vb.1
  deklasserande_1_N : N ; -- deklasserande..nn.1
  deklasserbar_1_A : A ; -- deklasserbar..av.1
  deklasserbarhet_1_N : N ; -- deklasserbarhet..nn.1
  deklassering_1_N : N ; -- deklassering..nn.1
  deklination_1_N : N ; -- deklination..nn.1
  deklinationsnål_1_N : N ; -- deklinationsnål..nn.1
  deklinera_1_V : V ; -- deklinera..vb.1
  deklinerande_1_N : N ; -- deklinerande..nn.1
  deklinerbar_1_A : A ; -- deklinerbar..av.1
  deklinerbarhet_1_N : N ; -- deklinerbarhet..nn.1
  deklinering_1_N : N ; -- deklinering..nn.1
  dekokt_1_N : N ; -- dekokt..nn.1
  dekolletage_1_N : N ; -- dekolletage..nn.1
  dekolleterad_1_A : A ; -- dekolleterad..av.1
  dekolletering_1_N : N ; -- dekolletering..nn.1
  dekomposition_1_N : N ; -- dekomposition..nn.1
  dekompression_1_N : N ; -- dekompression..nn.1
  dekor_1_N : N ; -- dekor..nn.1
  dekoration_1_N : N ; -- dekoration..nn.1
  dekorationsbrasa_1_N : N ; -- dekorationsbrasa..nn.1
  dekorationsgran_1_N : N ; -- dekorationsgran..nn.1
  dekorationslist_1_N : N ; -- dekorationslist..nn.1
  dekorationsmålare_1_N : N ; -- dekorationsmålare..nn.1
  dekorationsmålning_1_N : N ; -- dekorationsmålning..nn.1
  dekorativ_1_A : A ; -- dekorativ..av.1
  dekoratör_1_N : N ; -- dekoratör..nn.1
  dekorera_1_V : V ; -- dekorera..vb.1
  dekorerande_1_N : N ; -- dekorerande..nn.1
  dekorerbar_1_A : A ; -- dekorerbar..av.1
  dekorerbarhet_1_N : N ; -- dekorerbarhet..nn.1
  dekorering_1_N : N ; -- dekorering..nn.1
  dekorglans_1_N : N ; -- dekorglans..nn.1
  dekorputs_1_N : N ; -- dekorputs..nn.1
  dekorum_1_N : N ; -- dekorum..nn.1
  dekouragera_1_V : V ; -- dekouragera..vb.1
  dekouragerande_1_N : N ; -- dekouragerande..nn.1
  dekouragerbar_1_A : A ; -- dekouragerbar..av.1
  dekouragerbarhet_1_N : N ; -- dekouragerbarhet..nn.1
  dekouragering_1_N : N ; -- dekouragering..nn.1
  dekret_1_N : N ; -- dekret..nn.1
  dekretera_1_V : V ; -- dekretera..vb.1
  dekreterande_1_N : N ; -- dekreterande..nn.1
  dekreterbar_1_A : A ; -- dekreterbar..av.1
  dekreterbarhet_1_N : N ; -- dekreterbarhet..nn.1
  dekretering_1_N : N ; -- dekretering..nn.1
  del_1_N : N ; -- del..nn.1
  dela_1_V : V ; -- dela..vb.1
  delabialiserad_1_A : A ; -- delabialiserad..av.1
  delad_1_A : A ; -- delad..av.1
  delaktig_1_A : A ; -- delaktig..av.1
  delaktighet_1_N : N ; -- delaktighet..nn.1
  delande_1_N : N ; -- delande..nn.1
  delativ_1_N : N ; -- delativ..nn.1
  delbar_1_A : A ; -- delbar..av.1
  delbarhet_1_N : N ; -- delbarhet..nn.1
  delbetala_1_V : V ; -- delbetala..vb.1
  delbetalande_1_N : N ; -- delbetalande..nn.1
  delbetalning_1_N : N ; -- delbetalning..nn.1
  delegat_1_N : N ; -- delegat..nn.1
  delegation_1_N : N ; -- delegation..nn.1
  delegera_1_V : V ; -- delegera..vb.1
  delegerande_1_N : N ; -- delegerande..nn.1
  delegerbar_1_A : A ; -- delegerbar..av.1
  delegerbarhet_1_N : N ; -- delegerbarhet..nn.1
  delegering_1_N : N ; -- delegering..nn.1
  delfin_1_N : N ; -- delfin..nn.1
  delfinansiera_1_V : V ; -- delfinansiera..vb.1
  delfinansierande_1_N : N ; -- delfinansierande..nn.1
  delfinansiering_1_N : N ; -- delfinansiering..nn.1
  delfinsprång_1_N : N ; -- delfinsprång..nn.1
  delfående_1_N : N ; -- delfående..nn.1
  delge_1_V : V ; -- delge..vb.1
  delgivande_1_N : N ; -- delgivande..nn.1
  delgivning_1_N : N ; -- delgivning..nn.1
  delgivningsman_1_N : N ; -- delgivningsman..nn.1
  deliciös_1_A : A ; -- deliciös..av.1
  delikat_1_A : A ; -- delikat..av.1
  delikatess_1_N : N ; -- delikatess..nn.1
  delikatessdisk_1_N : N ; -- delikatessdisk..nn.1
  delikatessjäv_1_N : N ; -- delikatessjäv..nn.1
  delikt_1_N : N ; -- delikt..nn.1
  delinkvent_1_N : N ; -- delinkvent..nn.1
  delirant_1_N : N ; -- delirant..nn.1
  delkaskoförsäkring_1_N : N ; -- delkaskoförsäkring..nn.1
  delkategori_1_N : N ; -- delkategori..nn.1
  delkultur_1_N : N ; -- delkultur..nn.1
  dellikvid_1_N : N ; -- dellikvid..nn.1
  delmängd_1_N : N ; -- delmängd..nn.1
  delning_1_N : N ; -- delning..nn.1
  delningslinje_1_N : N ; -- delningslinje..nn.1
  delningspunkt_1_N : N ; -- delningspunkt..nn.1
  delningsstreck_1_N : N ; -- delningsstreck..nn.1
  delningssätt_1_N : N ; -- delningssätt..nn.1
  delperiod_1_N : N ; -- delperiod..nn.1
  delprojekt_1_N : N ; -- delprojekt..nn.1
  delrepublik_1_N : N ; -- delrepublik..nn.1
  dels_1_Adv : Adv ; -- dels..ab.1
  delstat_1_N : N ; -- delstat..nn.1
  delstatlig_1_A : A ; -- delstatlig..av.1
  delstatsregering_1_N : N ; -- delstatsregering..nn.1
  delstreck_1_N : N ; -- delstreck..nn.1
  delsträcka_1_N : N ; -- delsträcka..nn.1
  delta_1_N : N ; -- delta..nn.1
  delta_2_N : N ; -- delta..nn.2
  delta_1_V : V ; -- delta..vb.1
  deltaformad_1_A : A ; -- deltaformad..av.1
  deltagande_1_A : A ; -- deltagande..av.1
  deltagande_1_N : N ; -- deltagande..nn.1
  deltagare_1_N : N ; -- deltagare..nn.1
  deltakrokodil_1_N : N ; -- deltakrokodil..nn.1
  deltamuskel_1_N : N ; -- deltamuskel..nn.1
  deltavinge_1_N : N ; -- deltavinge..nn.1
  deltid_1_N : N ; -- deltid..nn.1
  deltidare_1_N : N ; -- deltidare..nn.1
  deltidsanställd_1_A : A ; -- deltidsanställd..av.1
  deltidsarbeta_1_V : V ; -- deltidsarbeta..vb.1
  deltidsarbetande_1_A : A ; -- deltidsarbetande..av.1
  deltidsarbete_1_N : N ; -- deltidsarbete..nn.1
  deltidsarbetslös_1_A : A ; -- deltidsarbetslös..av.1
  deltidsarbetslöshet_1_N : N ; -- deltidsarbetslöshet..nn.1
  deltidssjuk_1_A : A ; -- deltidssjuk..av.1
  deltidssjukskriven_1_A : A ; -- deltidssjukskriven..av.1
  deltävling_1_N : N ; -- deltävling..nn.1
  delvis_1_Adv : Adv ; -- delvis..ab.1
  delvis_1_A : A ; -- delvis..av.1
  delägare_1_N : N ; -- delägare..nn.1
  dema_1_V : V ; -- dema..vb.1
  demagog_1_N : N ; -- demagog..nn.1
  demagogi_1_N : N ; -- demagogi..nn.1
  demagogisk_1_A : A ; -- demagogisk..av.1
  demande_1_N : N ; -- demande..nn.1
  demarkationslinje_1_N : N ; -- demarkationslinje..nn.1
  demarsch_1_N : N ; -- demarsch..nn.1
  demaskera_1_V : V ; -- demaskera..vb.1
  demaskerande_1_N : N ; -- demaskerande..nn.1
  demaskerbar_1_A : A ; -- demaskerbar..av.1
  demaskerbarhet_1_N : N ; -- demaskerbarhet..nn.1
  demaskering_1_N : N ; -- demaskering..nn.1
  demens_1_N : N ; -- demens..nn.1
  demenshandikapp_1_N : N ; -- demenshandikapp..nn.1
  demenspatient_1_N : N ; -- demenspatient..nn.1
  demensrelaterad_1_A : A ; -- demensrelaterad..av.1
  demensrisk_1_N : N ; -- demensrisk..nn.1
  demenssjuk_1_A : A ; -- demenssjuk..av.1
  demenssjukdom_1_N : N ; -- demenssjukdom..nn.1
  demensutveckling_1_N : N ; -- demensutveckling..nn.1
  dement_1_A : A ; -- dement..av.1
  dementera_1_V : V ; -- dementera..vb.1
  dementerande_1_N : N ; -- dementerande..nn.1
  dementerbar_1_A : A ; -- dementerbar..av.1
  dementerbarhet_1_N : N ; -- dementerbarhet..nn.1
  dementering_1_N : N ; -- dementering..nn.1
  dementi_1_N : N ; -- dementi..nn.1
  demeriterande_1_A : A ; -- demeriterande..av.1
  demi_sec_1_N : N ; -- demi-sec..nn.1
  demilitarisera_1_V : V ; -- demilitarisera..vb.1
  demilitariserande_1_N : N ; -- demilitariserande..nn.1
  demilitariserbar_1_A : A ; -- demilitariserbar..av.1
  demilitariserbarhet_1_N : N ; -- demilitariserbarhet..nn.1
  demilitarisering_1_N : N ; -- demilitarisering..nn.1
  demimond_1_N : N ; -- demimond..nn.1
  demission_1_N : N ; -- demission..nn.1
  demissionera_1_V : V ; -- demissionera..vb.1
  demissionerande_1_N : N ; -- demissionerande..nn.1
  demissionering_1_N : N ; -- demissionering..nn.1
  demiurg_1_N : N ; -- demiurg..nn.1
  demo_1_N : N ; -- demo..nn.1
  demobilisera_1_V : V ; -- demobilisera..vb.1
  demobiliserande_1_N : N ; -- demobiliserande..nn.1
  demobiliserbar_1_A : A ; -- demobiliserbar..av.1
  demobiliserbarhet_1_N : N ; -- demobiliserbarhet..nn.1
  demobilisering_1_N : N ; -- demobilisering..nn.1
  demoeffekt_1_N : N ; -- demoeffekt..nn.1
  demografi_1_N : N ; -- demografi..nn.1
  demografisk_1_A : A ; -- demografisk..av.1
  demoinspelning_1_N : N ; -- demoinspelning..nn.1
  demokrat_1_N : N ; -- demokrat..nn.1
  demokrati_1_N : N ; -- demokrati..nn.1
  demokratibygge_1_N : N ; -- demokratibygge..nn.1
  demokratiförespråkare_1_N : N ; -- demokratiförespråkare..nn.1
  demokratiförkämpe_1_N : N ; -- demokratiförkämpe..nn.1
  demokratirörelse_1_N : N ; -- demokratirörelse..nn.1
  demokratisera_1_V : V ; -- demokratisera..vb.1
  demokratiserande_1_N : N ; -- demokratiserande..nn.1
  demokratiserbar_1_A : A ; -- demokratiserbar..av.1
  demokratiserbarhet_1_N : N ; -- demokratiserbarhet..nn.1
  demokratisering_1_N : N ; -- demokratisering..nn.1
  demokratiseringsprocess_1_N : N ; -- demokratiseringsprocess..nn.1
  demokratisk_1_A : A ; -- demokratisk..av.1
  demokratism_1_N : N ; -- demokratism..nn.1
  demokratisnack_1_N : N ; -- demokratisnack..nn.1
  demokratiutveckling_1_N : N ; -- demokratiutveckling..nn.1
  demolera_1_V : V ; -- demolera..vb.1
  demolerande_1_N : N ; -- demolerande..nn.1
  demolerbar_1_A : A ; -- demolerbar..av.1
  demolerbarhet_1_N : N ; -- demolerbarhet..nn.1
  demolering_1_N : N ; -- demolering..nn.1
  demon_1_N : N ; -- demon..nn.1
  demoni_1_N : N ; -- demoni..nn.1
  demonisera_1_V : V ; -- demonisera..vb.1
  demoniserande_1_N : N ; -- demoniserande..nn.1
  demoniserbar_1_A : A ; -- demoniserbar..av.1
  demoniserbarhet_1_N : N ; -- demoniserbarhet..nn.1
  demonisering_1_N : N ; -- demonisering..nn.1
  demonisk_1_A : A ; -- demonisk..av.1
  demonologi_1_N : N ; -- demonologi..nn.1
  demonologisk_1_A : A ; -- demonologisk..av.1
  demonregissör_1_N : N ; -- demonregissör..nn.1
  demonstrant_1_N : N ; -- demonstrant..nn.1
  demonstration_1_N : N ; -- demonstration..nn.1
  demonstrationsfrihet_1_N : N ; -- demonstrationsfrihet..nn.1
  demonstrationstillstånd_1_N : N ; -- demonstrationstillstånd..nn.1
  demonstrationståg_1_N : N ; -- demonstrationståg..nn.1
  demonstrativ_1_A : A ; -- demonstrativ..av.1
  demonstrativpronomen_1_N : N ; -- demonstrativpronomen..nn.1
  demonstratris_1_N : N ; -- demonstratris..nn.1
  demonstratör_1_N : N ; -- demonstratör..nn.1
  demonstrera_1_V : V ; -- demonstrera..vb.1
  demonstrera_2_V : V ; -- demonstrera..vb.2
  demonstrerande_1_N : N ; -- demonstrerande..nn.1
  demonstrerbar_1_A : A ; -- demonstrerbar..av.1
  demonstrerbarhet_1_N : N ; -- demonstrerbarhet..nn.1
  demonstrering_1_N : N ; -- demonstrering..nn.1
  demontera_1_V : V ; -- demontera..vb.1
  demonterande_1_N : N ; -- demonterande..nn.1
  demonterbar_1_A : A ; -- demonterbar..av.1
  demonterbarhet_1_N : N ; -- demonterbarhet..nn.1
  demontering_1_N : N ; -- demontering..nn.1
  demoralisation_1_N : N ; -- demoralisation..nn.1
  demoralisera_1_V : V ; -- demoralisera..vb.1
  demoraliserande_1_N : N ; -- demoraliserande..nn.1
  demoraliserbar_1_A : A ; -- demoraliserbar..av.1
  demoraliserbarhet_1_N : N ; -- demoraliserbarhet..nn.1
  demoralisering_1_N : N ; -- demoralisering..nn.1
  demotape_1_N : N ; -- demotape..nn.1
  denar_1_N : N ; -- denar..nn.1
  denaturalisation_1_N : N ; -- denaturalisation..nn.1
  denaturalisera_1_V : V ; -- denaturalisera..vb.1
  denaturaliserande_1_N : N ; -- denaturaliserande..nn.1
  denaturaliserbar_1_A : A ; -- denaturaliserbar..av.1
  denaturaliserbarhet_1_N : N ; -- denaturaliserbarhet..nn.1
  denaturalisering_1_N : N ; -- denaturalisering..nn.1
  denaturera_1_V : V ; -- denaturera..vb.1
  denaturerande_1_N : N ; -- denaturerande..nn.1
  denaturerbar_1_A : A ; -- denaturerbar..av.1
  denaturerbarhet_1_N : N ; -- denaturerbarhet..nn.1
  denaturering_1_N : N ; -- denaturering..nn.1
  dendrit_1_N : N ; -- dendrit..nn.1
  dendrokronologi_1_N : N ; -- dendrokronologi..nn.1
  dendrokronologisk_1_A : A ; -- dendrokronologisk..av.1
  dendrolog_1_N : N ; -- dendrolog..nn.1
  dendrologi_1_N : N ; -- dendrologi..nn.1
  denier_1_N : N ; -- denier..nn.1
  denim_1_N : N ; -- denim..nn.1
  denotation_1_N : N ; -- denotation..nn.1
  denotativ_1_A : A ; -- denotativ..av.1
  denotera_1_V : V ; -- denotera..vb.1
  denoterande_1_N : N ; -- denoterande..nn.1
  denoterbar_1_A : A ; -- denoterbar..av.1
  denoterbarhet_1_N : N ; -- denoterbarhet..nn.1
  denotering_1_N : N ; -- denotering..nn.1
  densitet_1_N : N ; -- densitet..nn.1
  densitometer_1_N : N ; -- densitometer..nn.1
  densometer_1_N : N ; -- densometer..nn.1
  dental_1_A : A ; -- dental..av.1
  dental_1_N : N ; -- dental..nn.1
  dentalljud_1_N : N ; -- dentalljud..nn.1
  dentist_1_N : N ; -- dentist..nn.1
  denudation_1_N : N ; -- denudation..nn.1
  denudera_1_V : V ; -- denudera..vb.1
  denuderande_1_N : N ; -- denuderande..nn.1
  denuderbar_1_A : A ; -- denuderbar..av.1
  denuderbarhet_1_N : N ; -- denuderbarhet..nn.1
  denudering_1_N : N ; -- denudering..nn.1
  denukleariserad_1_A : A ; -- denukleariserad..av.1
  denuklearisering_1_N : N ; -- denuklearisering..nn.1
  deodorant_1_N : N ; -- deodorant..nn.1
  deodorisera_1_V : V ; -- deodorisera..vb.1
  deodoriserande_1_N : N ; -- deodoriserande..nn.1
  deodoriserbar_1_A : A ; -- deodoriserbar..av.1
  deodoriserbarhet_1_N : N ; -- deodoriserbarhet..nn.1
  deodorisering_1_N : N ; -- deodorisering..nn.1
  departement_1_N : N ; -- departement..nn.1
  departemental_1_A : A ; -- departemental..av.1
  departementschef_1_N : N ; -- departementschef..nn.1
  departementsråd_1_N : N ; -- departementsråd..nn.1
  departementsärende_1_N : N ; -- departementsärende..nn.1
  depatriera_1_V : V ; -- depatriera..vb.1
  depatrierande_1_N : N ; -- depatrierande..nn.1
  depatrierbar_1_A : A ; -- depatrierbar..av.1
  depatrierbarhet_1_N : N ; -- depatrierbarhet..nn.1
  depatriering_1_N : N ; -- depatriering..nn.1
  dependens_1_N : N ; -- dependens..nn.1
  depens_1_N : N ; -- depens..nn.1
  depensera_1_V : V ; -- depensera..vb.1
  depenserande_1_N : N ; -- depenserande..nn.1
  depenserbar_1_A : A ; -- depenserbar..av.1
  depenserbarhet_1_N : N ; -- depenserbarhet..nn.1
  depensering_1_N : N ; -- depensering..nn.1
  depersonalisation_1_N : N ; -- depersonalisation..nn.1
  depesch_1_N : N ; -- depesch..nn.1
  depeschbyrå_1_N : N ; -- depeschbyrå..nn.1
  deplacement_1_N : N ; -- deplacement..nn.1
  deplacera_1_V : V ; -- deplacera..vb.1
  deplacerande_1_N : N ; -- deplacerande..nn.1
  deplacerbar_1_A : A ; -- deplacerbar..av.1
  deplacerbarhet_1_N : N ; -- deplacerbarhet..nn.1
  deplacering_1_N : N ; -- deplacering..nn.1
  depolarisator_1_N : N ; -- depolarisator..nn.1
  deponens_1_N : N ; -- deponens..nn.1
  deponent_1_N : N ; -- deponent..nn.1
  deponentiell_1_A : A ; -- deponentiell..av.1
  deponera_1_V : V ; -- deponera..vb.1
  deponerande_1_N : N ; -- deponerande..nn.1
  deponerbar_1_A : A ; -- deponerbar..av.1
  deponerbarhet_1_N : N ; -- deponerbarhet..nn.1
  deponering_1_N : N ; -- deponering..nn.1
  deponi_1_N : N ; -- deponi..nn.1
  deportation_1_N : N ; -- deportation..nn.1
  deportationsort_1_N : N ; -- deportationsort..nn.1
  deportera_1_V : V ; -- deportera..vb.1
  deporterande_1_N : N ; -- deporterande..nn.1
  deporterbar_1_A : A ; -- deporterbar..av.1
  deporterbarhet_1_N : N ; -- deporterbarhet..nn.1
  deportering_1_N : N ; -- deportering..nn.1
  deposition_1_N : N ; -- deposition..nn.1
  depositionsbevis_1_N : N ; -- depositionsbevis..nn.1
  depositum_1_N : N ; -- depositum..nn.1
  deppa_1_V : V ; -- deppa..vb.1
  deppad_1_A : A ; -- deppad..av.1
  deppande_1_N : N ; -- deppande..nn.1
  deppig_1_A : A ; -- deppig..av.1
  deppighet_1_N : N ; -- deppighet..nn.1
  depprock_1_N : N ; -- depprock..nn.1
  depprockare_1_N : N ; -- depprockare..nn.1
  depravation_1_N : N ; -- depravation..nn.1
  depraverad_1_A : A ; -- depraverad..av.1
  depreciera_1_V : V ; -- depreciera..vb.1
  deprecierande_1_N : N ; -- deprecierande..nn.1
  deprecierbar_1_A : A ; -- deprecierbar..av.1
  deprecierbarhet_1_N : N ; -- deprecierbarhet..nn.1
  depreciering_1_N : N ; -- depreciering..nn.1
  depression_1_N : N ; -- depression..nn.1
  depressionsdiagnos_1_N : N ; -- depressionsdiagnos..nn.1
  depressionssymtom_1_N : N ; -- depressionssymtom..nn.1
  depressiv_1_A : A ; -- depressiv..av.1
  deprimerad_1_A : A ; -- deprimerad..av.1
  deprimerande_1_A : A ; -- deprimerande..av.1
  deprivation_1_N : N ; -- deprivation..nn.1
  deputation_1_N : N ; -- deputation..nn.1
  deputerad_1_N : N ; -- deputerad..nn.1
  depå_1_N : N ; -- depå..nn.1
  depåfynd_1_N : N ; -- depåfynd..nn.1
  depåstöd_1_N : N ; -- depåstöd..nn.1
  derangera_1_V : V ; -- derangera..vb.1
  derangerande_1_N : N ; -- derangerande..nn.1
  derangerbar_1_A : A ; -- derangerbar..av.1
  derangerbarhet_1_N : N ; -- derangerbarhet..nn.1
  derangering_1_N : N ; -- derangering..nn.1
  derby_1_N : N ; -- derby..nn.1
  derivat_1_N : N ; -- derivat..nn.1
  derivata_1_N : N ; -- derivata..nn.1
  derivation_1_N : N ; -- derivation..nn.1
  derivera_1_V : V ; -- derivera..vb.1
  deriverande_1_N : N ; -- deriverande..nn.1
  deriverbar_1_A : A ; -- deriverbar..av.1
  deriverbarhet_1_N : N ; -- deriverbarhet..nn.1
  derivering_1_N : N ; -- derivering..nn.1
  dermatit_1_N : N ; -- dermatit..nn.1
  dermatolog_1_N : N ; -- dermatolog..nn.1
  dermatologi_1_N : N ; -- dermatologi..nn.1
  dermatologisk_1_A : A ; -- dermatologisk..av.1
  dermatos_1_N : N ; -- dermatos..nn.1
  dervisch_1_N : N ; -- dervisch..nn.1
  dervischdans_1_N : N ; -- dervischdans..nn.1
  desarmera_1_V : V ; -- desarmera..vb.1
  desarmerande_1_N : N ; -- desarmerande..nn.1
  desarmerbar_1_A : A ; -- desarmerbar..av.1
  desarmerbarhet_1_N : N ; -- desarmerbarhet..nn.1
  desarmering_1_N : N ; -- desarmering..nn.1
  desavouera_1_V : V ; -- desavouera..vb.1
  desavouerande_1_N : N ; -- desavouerande..nn.1
  desavouerbar_1_A : A ; -- desavouerbar..av.1
  desavouerbarhet_1_N : N ; -- desavouerbarhet..nn.1
  desavouering_1_N : N ; -- desavouering..nn.1
  descendens_1_N : N ; -- descendens..nn.1
  descendent_1_N : N ; -- descendent..nn.1
  desegregation_1_N : N ; -- desegregation..nn.1
  desengagemang_1_N : N ; -- desengagemang..nn.1
  desensibilisera_1_V : V ; -- desensibilisera..vb.1
  desensibiliserande_1_N : N ; -- desensibiliserande..nn.1
  desensibiliserbar_1_A : A ; -- desensibiliserbar..av.1
  desensibiliserbarhet_1_N : N ; -- desensibiliserbarhet..nn.1
  desensibilisering_1_N : N ; -- desensibilisering..nn.1
  desertera_1_V : V ; -- desertera..vb.1
  deserterande_1_N : N ; -- deserterande..nn.1
  desertering_1_N : N ; -- desertering..nn.1
  desertör_1_N : N ; -- desertör..nn.1
  deshabillé_1_N : N ; -- deshabillé..nn.1
  design_1_N : N ; -- design..nn.1
  designa_1_V : V ; -- designa..vb.1
  designande_1_N : N ; -- designande..nn.1
  designer_1_N : N ; -- designer..nn.1
  designera_1_V : V ; -- designera..vb.1
  designerande_1_N : N ; -- designerande..nn.1
  designerbar_1_A : A ; -- designerbar..av.1
  designerbarhet_1_N : N ; -- designerbarhet..nn.1
  designering_1_N : N ; -- designering..nn.1
  designmässig_1_A : A ; -- designmässig..av.1
  designskola_1_N : N ; -- designskola..nn.1
  designstudent_1_N : N ; -- designstudent..nn.1
  designtävling_1_N : N ; -- designtävling..nn.1
  desillusion_1_N : N ; -- desillusion..nn.1
  desillusionerad_1_A : A ; -- desillusionerad..av.1
  desinfektera_1_V : V ; -- desinfektera..vb.1
  desinfekterande_1_N : N ; -- desinfekterande..nn.1
  desinfekterbar_1_A : A ; -- desinfekterbar..av.1
  desinfekterbarhet_1_N : N ; -- desinfekterbarhet..nn.1
  desinfektering_1_N : N ; -- desinfektering..nn.1
  desinfektion_1_N : N ; -- desinfektion..nn.1
  desinfektionsmedel_1_N : N ; -- desinfektionsmedel..nn.1
  desinfektör_1_N : N ; -- desinfektör..nn.1
  desinficera_1_V : V ; -- desinficera..vb.1
  desinficerande_1_N : N ; -- desinficerande..nn.1
  desinficerbar_1_A : A ; -- desinficerbar..av.1
  desinficerbarhet_1_N : N ; -- desinficerbarhet..nn.1
  desinficering_1_N : N ; -- desinficering..nn.1
  desinficeringsmedel_1_N : N ; -- desinficeringsmedel..nn.1
  desinformation_1_N : N ; -- desinformation..nn.1
  desinformera_1_V : V ; -- desinformera..vb.1
  desinformerande_1_N : N ; -- desinformerande..nn.1
  desinformerbar_1_A : A ; -- desinformerbar..av.1
  desinformerbarhet_1_N : N ; -- desinformerbarhet..nn.1
  desinformering_1_N : N ; -- desinformering..nn.1
  desinsektion_1_N : N ; -- desinsektion..nn.1
  desintegration_1_N : N ; -- desintegration..nn.1
  desintresserad_1_A : A ; -- desintresserad..av.1
  deskription_1_N : N ; -- deskription..nn.1
  deskriptiv_1_A : A ; -- deskriptiv..av.1
  deskriptor_1_N : N ; -- deskriptor..nn.1
  desorganisation_1_N : N ; -- desorganisation..nn.1
  desorganisera_1_V : V ; -- desorganisera..vb.1
  desorganiserande_1_N : N ; -- desorganiserande..nn.1
  desorganiserbar_1_A : A ; -- desorganiserbar..av.1
  desorganiserbarhet_1_N : N ; -- desorganiserbarhet..nn.1
  desorganisering_1_N : N ; -- desorganisering..nn.1
  desorienterad_1_A : A ; -- desorienterad..av.1
  desorientering_1_N : N ; -- desorientering..nn.1
  desperado_1_N : N ; -- desperado..nn.1
  desperat_1_A : A ; -- desperat..av.1
  desperation_1_N : N ; -- desperation..nn.1
  despot_1_N : N ; -- despot..nn.1
  despoti_1_N : N ; -- despoti..nn.1
  despotisk_1_A : A ; -- despotisk..av.1
  despotism_1_N : N ; -- despotism..nn.1
  dessbättre_1_Adv : Adv ; -- dessbättre..ab.1
  dessemellan_1_Adv : Adv ; -- dessemellan..ab.1
  dessert_1_N : N ; -- dessert..nn.1
  dessertfrukt_1_N : N ; -- dessertfrukt..nn.1
  dessertgaffel_1_N : N ; -- dessertgaffel..nn.1
  dessertkniv_1_N : N ; -- dessertkniv..nn.1
  dessertost_1_N : N ; -- dessertost..nn.1
  dessertsked_1_N : N ; -- dessertsked..nn.1
  dessertskål_1_N : N ; -- dessertskål..nn.1
  dessertsås_1_N : N ; -- dessertsås..nn.1
  desserttallrik_1_N : N ; -- desserttallrik..nn.1
  dessertvin_1_N : N ; -- dessertvin..nn.1
  dessförinnan_1_Adv : Adv ; -- dessförinnan..ab.1
  dessförutan_1_Adv : Adv ; -- dessförutan..ab.1
  dessinatör_1_N : N ; -- dessinatör..nn.1
  desslikes_1_Adv : Adv ; -- desslikes..ab.1
  dessutom_1_Adv : Adv ; -- dessutom..ab.1
  dessvärre_1_Adv : Adv ; -- dessvärre..ab.1
  dessäng_1_N : N ; -- dessäng..nn.1
  destabilisera_1_V : V ; -- destabilisera..vb.1
  destabiliserande_1_A : A ; -- destabiliserande..av.1
  destabiliserande_1_N : N ; -- destabiliserande..nn.1
  destabiliserbar_1_A : A ; -- destabiliserbar..av.1
  destabiliserbarhet_1_N : N ; -- destabiliserbarhet..nn.1
  destillat_1_N : N ; -- destillat..nn.1
  destillation_1_N : N ; -- destillation..nn.1
  destillationsapparat_1_N : N ; -- destillationsapparat..nn.1
  destillera_1_V : V ; -- destillera..vb.1
  destillerande_1_N : N ; -- destillerande..nn.1
  destillerbar_1_A : A ; -- destillerbar..av.1
  destillerbarhet_1_N : N ; -- destillerbarhet..nn.1
  destillering_1_N : N ; -- destillering..nn.1
  destination_1_N : N ; -- destination..nn.1
  destinationshamn_1_N : N ; -- destinationshamn..nn.1
  destinationsort_1_N : N ; -- destinationsort..nn.1
  destinatär_1_N : N ; -- destinatär..nn.1
  destinatör_1_N : N ; -- destinatör..nn.1
  destinera_1_V : V ; -- destinera..vb.1
  destinerande_1_N : N ; -- destinerande..nn.1
  destinerbar_1_A : A ; -- destinerbar..av.1
  destinerbarhet_1_N : N ; -- destinerbarhet..nn.1
  destinering_1_N : N ; -- destinering..nn.1
  desto_1_Adv : Adv ; -- desto..ab.1
  destruent_1_N : N ; -- destruent..nn.1
  destruera_1_V : V ; -- destruera..vb.1
  destruerande_1_N : N ; -- destruerande..nn.1
  destruerbar_1_A : A ; -- destruerbar..av.1
  destruerbarhet_1_N : N ; -- destruerbarhet..nn.1
  destruering_1_N : N ; -- destruering..nn.1
  destruktion_1_N : N ; -- destruktion..nn.1
  destruktionsanläggning_1_N : N ; -- destruktionsanläggning..nn.1
  destruktiv_1_A : A ; -- destruktiv..av.1
  det_genus_1_N : N ; -- det-genus..nn.1
  detachement_1_N : N ; -- detachement..nn.1
  detachera_1_V : V ; -- detachera..vb.1
  detacherande_1_N : N ; -- detacherande..nn.1
  detacherbar_1_A : A ; -- detacherbar..av.1
  detacherbarhet_1_N : N ; -- detacherbarhet..nn.1
  detachering_1_N : N ; -- detachering..nn.1
  detachör_1_N : N ; -- detachör..nn.1
  detalj_1_N : N ; -- detalj..nn.1
  detaljanmärkning_1_N : N ; -- detaljanmärkning..nn.1
  detaljarbete_1_N : N ; -- detaljarbete..nn.1
  detaljbestämmelse_1_N : N ; -- detaljbestämmelse..nn.1
  detaljerad_1_A : A ; -- detaljerad..av.1
  detaljering_1_N : N ; -- detaljering..nn.1
  detaljfattig_1_A : A ; -- detaljfattig..av.1
  detaljfattigdom_1_N : N ; -- detaljfattigdom..nn.1
  detaljfixerad_1_A : A ; -- detaljfixerad..av.1
  detaljfråga_1_N : N ; -- detaljfråga..nn.1
  detaljgranska_1_V : V ; -- detaljgranska..vb.1
  detaljgranskande_1_N : N ; -- detaljgranskande..nn.1
  detaljhandel_1_N : N ; -- detaljhandel..nn.1
  detaljhandlare_1_N : N ; -- detaljhandlare..nn.1
  detaljist_1_N : N ; -- detaljist..nn.1
  detaljkarta_1_N : N ; -- detaljkarta..nn.1
  detaljkunskap_1_N : N ; -- detaljkunskap..nn.1
  detaljkännedom_1_N : N ; -- detaljkännedom..nn.1
  detaljplan_1_N : N ; -- detaljplan..nn.1
  detaljpris_1_N : N ; -- detaljpris..nn.1
  detaljreglera_1_V : V ; -- detaljreglera..vb.1
  detaljreglerande_1_N : N ; -- detaljreglerande..nn.1
  detaljreglerbar_1_A : A ; -- detaljreglerbar..av.1
  detaljreglerbarhet_1_N : N ; -- detaljreglerbarhet..nn.1
  detaljreglering_1_N : N ; -- detaljreglering..nn.1
  detaljrik_1_A : A ; -- detaljrik..av.1
  detaljrikedom_1_N : N ; -- detaljrikedom..nn.1
  detaljrikhet_1_N : N ; -- detaljrikhet..nn.1
  detaljritning_1_N : N ; -- detaljritning..nn.1
  detaljskärpa_1_N : N ; -- detaljskärpa..nn.1
  detaljstudium_1_N : N ; -- detaljstudium..nn.1
  detaljstyra_1_V : V ; -- detaljstyra..vb.1
  detaljstyrande_1_N : N ; -- detaljstyrande..nn.1
  detaljstyrning_1_N : N ; -- detaljstyrning..nn.1
  detaljuppgift_1_N : N ; -- detaljuppgift..nn.1
  detaljutförande_1_N : N ; -- detaljutförande..nn.1
  detektera_1_V : V ; -- detektera..vb.1
  detekterande_1_N : N ; -- detekterande..nn.1
  detekterbar_1_A : A ; -- detekterbar..av.1
  detekterbarhet_1_N : N ; -- detekterbarhet..nn.1
  detektering_1_N : N ; -- detektering..nn.1
  detektiv_1_A : A ; -- detektiv..av.1
  detektiv_1_N : N ; -- detektiv..nn.1
  detektivarbete_1_N : N ; -- detektivarbete..nn.1
  detektivberättelse_1_N : N ; -- detektivberättelse..nn.1
  detektivroman_1_N : N ; -- detektivroman..nn.1
  detektor_1_N : N ; -- detektor..nn.1
  detergent_1_N : N ; -- detergent..nn.1
  determination_1_N : N ; -- determination..nn.1
  determinativ_1_A : A ; -- determinativ..av.1
  determinativpronomen_1_N : N ; -- determinativpronomen..nn.1
  determinera_1_V : V ; -- determinera..vb.1
  determinerande_1_N : N ; -- determinerande..nn.1
  determinerbar_1_A : A ; -- determinerbar..av.1
  determinerbarhet_1_N : N ; -- determinerbarhet..nn.1
  determinering_1_N : N ; -- determinering..nn.1
  determinism_1_N : N ; -- determinism..nn.1
  determinist_1_N : N ; -- determinist..nn.1
  deterministisk_1_A : A ; -- deterministisk..av.1
  detgenus_1_N : N ; -- detgenus..nn.1
  detonation_1_N : N ; -- detonation..nn.1
  detonationshastighet_1_N : N ; -- detonationshastighet..nn.1
  detonationstryck_1_N : N ; -- detonationstryck..nn.1
  detonationszon_1_N : N ; -- detonationszon..nn.1
  detonator_1_N : N ; -- detonator..nn.1
  detonera_1_V : V ; -- detonera..vb.1
  detonerande_1_N : N ; -- detonerande..nn.1
  detonerbar_1_A : A ; -- detonerbar..av.1
  detonerbarhet_1_N : N ; -- detonerbarhet..nn.1
  detonering_1_N : N ; -- detonering..nn.1
  detronisera_1_V : V ; -- detronisera..vb.1
  detroniserande_1_N : N ; -- detroniserande..nn.1
  detroniserbar_1_A : A ; -- detroniserbar..av.1
  detroniserbarhet_1_N : N ; -- detroniserbarhet..nn.1
  detronisering_1_N : N ; -- detronisering..nn.1
  deuterium_1_N : N ; -- deuterium..nn.1
  deuteron_1_N : N ; -- deuteron..nn.1
  deutron_1_N : N ; -- deutron..nn.1
  devalvera_1_V : V ; -- devalvera..vb.1
  devalverande_1_N : N ; -- devalverande..nn.1
  devalverbar_1_A : A ; -- devalverbar..av.1
  devalverbarhet_1_N : N ; -- devalverbarhet..nn.1
  devalvering_1_N : N ; -- devalvering..nn.1
  deviation_1_N : N ; -- deviation..nn.1
  deviera_1_V : V ; -- deviera..vb.1
  devierande_1_N : N ; -- devierande..nn.1
  deviering_1_N : N ; -- deviering..nn.1
  devis_1_N : N ; -- devis..nn.1
  devon_1_N : N ; -- devon..nn.1
  devot_1_A : A ; -- devot..av.1
  dextran_1_N : N ; -- dextran..nn.1
  dextrin_1_N : N ; -- dextrin..nn.1
  dhivehi_1_N : N ; -- dhivehi..nn.1
  dia_1_N : N ; -- dia..nn.1
  dia_1_V : V ; -- dia..vb.1
  diabas_1_N : N ; -- diabas..nn.1
  diabetesmedicin_1_N : N ; -- diabetesmedicin..nn.1
  diabetiker_1_N : N ; -- diabetiker..nn.1
  diabetisk_1_A : A ; -- diabetisk..av.1
  diabild_1_N : N ; -- diabild..nn.1
  diabolisk_1_A : A ; -- diabolisk..av.1
  diadem_1_N : N ; -- diadem..nn.1
  diafilm_1_N : N ; -- diafilm..nn.1
  diafragma_1_N : N ; -- diafragma..nn.1
  diagnos_1_N : N ; -- diagnos..nn.1
  diagnosmetod_1_N : N ; -- diagnosmetod..nn.1
  diagnosticera_1_V : V ; -- diagnosticera..vb.1
  diagnosticerande_1_N : N ; -- diagnosticerande..nn.1
  diagnosticerbar_1_A : A ; -- diagnosticerbar..av.1
  diagnosticerbarhet_1_N : N ; -- diagnosticerbarhet..nn.1
  diagnosticering_1_N : N ; -- diagnosticering..nn.1
  diagnostik_1_N : N ; -- diagnostik..nn.1
  diagnostiker_1_N : N ; -- diagnostiker..nn.1
  diagnostisera_1_V : V ; -- diagnostisera..vb.1
  diagnostiserande_1_N : N ; -- diagnostiserande..nn.1
  diagnostiserbar_1_A : A ; -- diagnostiserbar..av.1
  diagnostiserbarhet_1_N : N ; -- diagnostiserbarhet..nn.1
  diagnostisering_1_N : N ; -- diagnostisering..nn.1
  diagnostisk_1_A : A ; -- diagnostisk..av.1
  diagonal_1_A : A ; -- diagonal..av.1
  diagonal_1_N : N ; -- diagonal..nn.1
  diagonala_1_V : V ; -- diagonala..vb.1
  diagonalande_1_N : N ; -- diagonalande..nn.1
  diagonalbyggnad_1_N : N ; -- diagonalbyggnad..nn.1
  diagonallinje_1_N : N ; -- diagonallinje..nn.1
  diagram_1_N : N ; -- diagram..nn.1
  diakon_1_N : N ; -- diakon..nn.1
  diakoni_1_N : N ; -- diakoni..nn.1
  diakonissa_1_N : N ; -- diakonissa..nn.1
  diakonissanstalt_1_N : N ; -- diakonissanstalt..nn.1
  diakonistyrelse_1_N : N ; -- diakonistyrelse..nn.1
  diakritisk_1_A : A ; -- diakritisk..av.1
  diakron_1_A : A ; -- diakron..av.1
  diakronisk_1_A : A ; -- diakronisk..av.1
  dialekt_1_N : N ; -- dialekt..nn.1
  dialektal_1_A : A ; -- dialektal..av.1
  dialektforskning_1_N : N ; -- dialektforskning..nn.1
  dialektgeografi_1_N : N ; -- dialektgeografi..nn.1
  dialektgeografisk_1_A : A ; -- dialektgeografisk..av.1
  dialektik_1_N : N ; -- dialektik..nn.1
  dialektiker_1_N : N ; -- dialektiker..nn.1
  dialektisk_1_A : A ; -- dialektisk..av.1
  dialektolog_1_N : N ; -- dialektolog..nn.1
  dialektologi_1_N : N ; -- dialektologi..nn.1
  dialektologisk_1_A : A ; -- dialektologisk..av.1
  dialektord_1_N : N ; -- dialektord..nn.1
  dialektordbok_1_N : N ; -- dialektordbok..nn.1
  dialektstudium_1_N : N ; -- dialektstudium..nn.1
  dialektuttal_1_N : N ; -- dialektuttal..nn.1
  dialog_1_N : N ; -- dialog..nn.1
  dialogform_1_N : N ; -- dialogform..nn.1
  dialogisk_1_A : A ; -- dialogisk..av.1
  dialogparti_1_N : N ; -- dialogparti..nn.1
  dialogpedagogik_1_N : N ; -- dialogpedagogik..nn.1
  dialys_1_N : N ; -- dialys..nn.1
  dialysera_1_V : V ; -- dialysera..vb.1
  dialyserande_1_N : N ; -- dialyserande..nn.1
  dialyserbar_1_A : A ; -- dialyserbar..av.1
  dialyserbarhet_1_N : N ; -- dialyserbarhet..nn.1
  dialysering_1_N : N ; -- dialysering..nn.1
  dialytisk_1_A : A ; -- dialytisk..av.1
  diamant_1_N : N ; -- diamant..nn.1
  diamantborr_1_N : N ; -- diamantborr..nn.1
  diamantbrynstål_1_N : N ; -- diamantbrynstål..nn.1
  diamantbröllop_1_N : N ; -- diamantbröllop..nn.1
  diamantprydd_1_A : A ; -- diamantprydd..av.1
  diamantring_1_N : N ; -- diamantring..nn.1
  diamantskärare_1_N : N ; -- diamantskärare..nn.1
  diamantsmycke_1_N : N ; -- diamantsmycke..nn.1
  diamanttjuv_1_N : N ; -- diamanttjuv..nn.1
  diameter_1_N : N ; -- diameter..nn.1
  diametral_1_A : A ; -- diametral..av.1
  diande_1_N : N ; -- diande..nn.1
  diapositiv_1_N : N ; -- diapositiv..nn.1
  diarieföra_1_V : V ; -- diarieföra..vb.1
  diarieförande_1_N : N ; -- diarieförande..nn.1
  diarienummer_1_N : N ; -- diarienummer..nn.1
  diarium_1_N : N ; -- diarium..nn.1
  diarré_1_N : N ; -- diarré..nn.1
  diaspora_1_N : N ; -- diaspora..nn.1
  diasporagrupp_1_N : N ; -- diasporagrupp..nn.1
  diastas_1_N : N ; -- diastas..nn.1
  diastole_1_N : N ; -- diastole..nn.1
  diastolisk_1_A : A ; -- diastolisk..av.1
  diatermi_1_N : N ; -- diatermi..nn.1
  diatonisk_1_A : A ; -- diatonisk..av.1
  diatrib_1_N : N ; -- diatrib..nn.1
  dibarn_1_N : N ; -- dibarn..nn.1
  dibbla_1_V : V ; -- dibbla..vb.1
  dibblande_1_N : N ; -- dibblande..nn.1
  didaktik_1_N : N ; -- didaktik..nn.1
  didaktiker_1_N : N ; -- didaktiker..nn.1
  didaktisk_1_A : A ; -- didaktisk..av.1
  diddling_1_N : N ; -- diddling..nn.1
  diesel_1_N : N ; -- diesel..nn.1
  dieseldriven_1_A : A ; -- dieseldriven..av.1
  dieselgenerator_1_N : N ; -- dieselgenerator..nn.1
  dieselhybrid_1_N : N ; -- dieselhybrid..nn.1
  dieselkraftverk_1_N : N ; -- dieselkraftverk..nn.1
  dieselmotor_1_N : N ; -- dieselmotor..nn.1
  dieselmotorrengöring_1_N : N ; -- dieselmotorrengöring..nn.1
  dieselolja_1_N : N ; -- dieselolja..nn.1
  dieselpump_1_N : N ; -- dieselpump..nn.1
  diet_1_N : N ; -- diet..nn.1
  dietetik_1_N : N ; -- dietetik..nn.1
  dietetisk_1_A : A ; -- dietetisk..av.1
  dietik_1_N : N ; -- dietik..nn.1
  dietisk_1_A : A ; -- dietisk..av.1
  dietist_1_N : N ; -- dietist..nn.1
  differens_1_N : N ; -- differens..nn.1
  different_1_A : A ; -- different..av.1
  differential_1_N : N ; -- differential..nn.1
  differentialekvation_1_N : N ; -- differentialekvation..nn.1
  differentialkalkyl_1_N : N ; -- differentialkalkyl..nn.1
  differentialräkning_1_N : N ; -- differentialräkning..nn.1
  differentialspärr_1_N : N ; -- differentialspärr..nn.1
  differentialväxel_1_N : N ; -- differentialväxel..nn.1
  differentiell_1_A : A ; -- differentiell..av.1
  differentiera_1_V : V ; -- differentiera..vb.1
  differentierande_1_N : N ; -- differentierande..nn.1
  differentierbar_1_A : A ; -- differentierbar..av.1
  differentierbarhet_1_N : N ; -- differentierbarhet..nn.1
  differentiering_1_N : N ; -- differentiering..nn.1
  diffraktion_1_N : N ; -- diffraktion..nn.1
  diffraktionsspektrum_1_N : N ; -- diffraktionsspektrum..nn.1
  diffundera_1_V : V ; -- diffundera..vb.1
  diffunderande_1_N : N ; -- diffunderande..nn.1
  diffunderbar_1_A : A ; -- diffunderbar..av.1
  diffunderbarhet_1_N : N ; -- diffunderbarhet..nn.1
  diffundering_1_N : N ; -- diffundering..nn.1
  diffus_1_A : A ; -- diffus..av.1
  diffusion_1_N : N ; -- diffusion..nn.1
  difteri_1_N : N ; -- difteri..nn.1
  diftong_1_N : N ; -- diftong..nn.1
  diftongera_1_V : V ; -- diftongera..vb.1
  diftongerande_1_N : N ; -- diftongerande..nn.1
  diftongerbar_1_A : A ; -- diftongerbar..av.1
  diftongerbarhet_1_N : N ; -- diftongerbarhet..nn.1
  diftongering_1_N : N ; -- diftongering..nn.1
  diftongisk_1_A : A ; -- diftongisk..av.1
  diftongljud_1_N : N ; -- diftongljud..nn.1
  digel_1_N : N ; -- digel..nn.1
  digelpress_1_N : N ; -- digelpress..nn.1
  diger_1_A : A ; -- diger..av.1
  digerdöd_1_N : N ; -- digerdöd..nn.1
  digerera_1_V : V ; -- digerera..vb.1
  digererande_1_N : N ; -- digererande..nn.1
  digererbar_1_A : A ; -- digererbar..av.1
  digererbarhet_1_N : N ; -- digererbarhet..nn.1
  digerering_1_N : N ; -- digerering..nn.1
  digestion_1_N : N ; -- digestion..nn.1
  digga_1_V : V ; -- digga..vb.1
  diggande_1_N : N ; -- diggande..nn.1
  digital_teve_1_N : N ; -- digital-teve..nn.1
  digital_1_A : A ; -- digital..av.1
  digitalbox_1_N : N ; -- digitalbox..nn.1
  digitalis_1_N : N ; -- digitalis..nn.1
  digitalisera_1_V : V ; -- digitalisera..vb.1
  digitaliserad_1_A : A ; -- digitaliserad..av.1
  digitaliserande_1_N : N ; -- digitaliserande..nn.1
  digitaliserbar_1_A : A ; -- digitaliserbar..av.1
  digitaliserbarhet_1_N : N ; -- digitaliserbarhet..nn.1
  digitalisering_1_N : N ; -- digitalisering..nn.1
  digitalkamera_1_N : N ; -- digitalkamera..nn.1
  digitallåda_1_N : N ; -- digitallåda..nn.1
  digitalteve_1_N : N ; -- digitalteve..nn.1
  digivning_1_N : N ; -- digivning..nn.1
  diglossi_1_N : N ; -- diglossi..nn.1
  digna_1_V : V ; -- digna..vb.1
  dignande_1_N : N ; -- dignande..nn.1
  dignitet_1_N : N ; -- dignitet..nn.1
  dignitär_1_N : N ; -- dignitär..nn.1
  digression_1_N : N ; -- digression..nn.1
  dika_1_V : V ; -- dika..vb.1
  dikande_1_N : N ; -- dikande..nn.1
  dikare_1_N : N ; -- dikare..nn.1
  dike_1_N : N ; -- dike..nn.1
  dikesgrävare_1_N : N ; -- dikesgrävare..nn.1
  dikeskörning_1_N : N ; -- dikeskörning..nn.1
  dikesren_1_N : N ; -- dikesren..nn.1
  diklin_1_A : A ; -- diklin..av.1
  diklin_1_N : N ; -- diklin..nn.1
  dikning_1_N : N ; -- dikning..nn.1
  dikotomi_1_N : N ; -- dikotomi..nn.1
  dikotyledon_1_A : A ; -- dikotyledon..av.1
  dikotyledon_1_N : N ; -- dikotyledon..nn.1
  dikt_1_Adv : Adv ; -- dikt..ab.1
  dikt_1_N : N ; -- dikt..nn.1
  dikta_1_V : V ; -- dikta..vb.1
  diktafon_1_N : N ; -- diktafon..nn.1
  diktamen_1_N : N ; -- diktamen..nn.1
  diktamensskrivning_1_N : N ; -- diktamensskrivning..nn.1
  diktan_1_N : N ; -- diktan..nn.1
  diktande_1_N : N ; -- diktande..nn.1
  diktarbegåvning_1_N : N ; -- diktarbegåvning..nn.1
  diktare_1_N : N ; -- diktare..nn.1
  diktarfurste_1_N : N ; -- diktarfurste..nn.1
  diktarfursteroll_1_N : N ; -- diktarfursteroll..nn.1
  diktargrupp_1_N : N ; -- diktargrupp..nn.1
  diktarskap_1_N : N ; -- diktarskap..nn.1
  diktart_1_N : N ; -- diktart..nn.1
  diktat_1_N : N ; -- diktat..nn.1
  diktator_1_N : N ; -- diktator..nn.1
  diktatorisk_1_A : A ; -- diktatorisk..av.1
  diktatorsmakt_1_N : N ; -- diktatorsmakt..nn.1
  diktatur_1_N : N ; -- diktatur..nn.1
  diktaturregim_1_N : N ; -- diktaturregim..nn.1
  diktcykel_1_N : N ; -- diktcykel..nn.1
  diktera_1_V : V ; -- diktera..vb.1
  dikterande_1_N : N ; -- dikterande..nn.1
  dikterbar_1_A : A ; -- dikterbar..av.1
  dikterbarhet_1_N : N ; -- dikterbarhet..nn.1
  diktering_1_N : N ; -- diktering..nn.1
  dikteringsmaskin_1_N : N ; -- dikteringsmaskin..nn.1
  diktfragment_1_N : N ; -- diktfragment..nn.1
  dikthäfte_1_N : N ; -- dikthäfte..nn.1
  diktion_1_N : N ; -- diktion..nn.1
  diktjag_1_N : N ; -- diktjag..nn.1
  diktkonst_1_N : N ; -- diktkonst..nn.1
  diktmässig_1_A : A ; -- diktmässig..av.1
  diktning_1_N : N ; -- diktning..nn.1
  diktsamling_1_N : N ; -- diktsamling..nn.1
  diktverk_1_N : N ; -- diktverk..nn.1
  dikväveoxid_1_N : N ; -- dikväveoxid..nn.1
  dila_1_V : V ; -- dila..vb.1
  dilamm_1_N : N ; -- dilamm..nn.1
  dilande_1_N : N ; -- dilande..nn.1
  dilatation_1_N : N ; -- dilatation..nn.1
  dilatationsfog_1_N : N ; -- dilatationsfog..nn.1
  dildo_1_N : N ; -- dildo..nn.1
  dilemma_1_N : N ; -- dilemma..nn.1
  dilettant_1_N : N ; -- dilettant..nn.1
  dilettanteri_1_N : N ; -- dilettanteri..nn.1
  dilettantisk_1_A : A ; -- dilettantisk..av.1
  dilettantism_1_N : N ; -- dilettantism..nn.1
  dilettantmässig_1_A : A ; -- dilettantmässig..av.1
  dilettantmässighet_1_N : N ; -- dilettantmässighet..nn.1
  diligens_1_N : N ; -- diligens..nn.1
  dill_1_N : N ; -- dill..nn.1
  dilla_1_V : V ; -- dilla..vb.1
  dillande_1_N : N ; -- dillande..nn.1
  dille_1_N : N ; -- dille..nn.1
  dilleri_1_N : N ; -- dilleri..nn.1
  dillkrona_1_N : N ; -- dillkrona..nn.1
  dillkvist_1_N : N ; -- dillkvist..nn.1
  dillkött_1_N : N ; -- dillkött..nn.1
  dillsås_1_N : N ; -- dillsås..nn.1
  dimbank_1_N : N ; -- dimbank..nn.1
  dimbildning_1_N : N ; -- dimbildning..nn.1
  dimblå_1_A : A ; -- dimblå..av.1
  dimbåge_1_N : N ; -- dimbåge..nn.1
  dimension_1_N : N ; -- dimension..nn.1
  dimensionera_1_V : V ; -- dimensionera..vb.1
  dimensionerande_1_N : N ; -- dimensionerande..nn.1
  dimensionerbar_1_A : A ; -- dimensionerbar..av.1
  dimensionerbarhet_1_N : N ; -- dimensionerbarhet..nn.1
  dimensionering_1_N : N ; -- dimensionering..nn.1
  dimensionsavverkning_1_N : N ; -- dimensionsavverkning..nn.1
  dimensionslös_1_A : A ; -- dimensionslös..av.1
  dimfri_1_A : A ; -- dimfri..av.1
  dimfrost_1_N : N ; -- dimfrost..nn.1
  dimgestalt_1_N : N ; -- dimgestalt..nn.1
  dimhöljd_1_A : A ; -- dimhöljd..av.1
  diminuendo_1_N : N ; -- diminuendo..nn.1
  diminutiv_1_A : A ; -- diminutiv..av.1
  diminutiv_1_N : N ; -- diminutiv..nn.1
  dimission_1_N : N ; -- dimission..nn.1
  dimkammare_1_N : N ; -- dimkammare..nn.1
  dimljus_1_N : N ; -- dimljus..nn.1
  dimma_1_N : N ; -- dimma..nn.1
  dimmig_1_A : A ; -- dimmig..av.1
  dimmighet_1_N : N ; -- dimmighet..nn.1
  dimmoln_1_N : N ; -- dimmoln..nn.1
  dimorf_1_A : A ; -- dimorf..av.1
  dimorfi_1_N : N ; -- dimorfi..nn.1
  dimorfism_1_N : N ; -- dimorfism..nn.1
  dimpa_1_V : V ; -- dimpa..vb.1
  dimpande_1_N : N ; -- dimpande..nn.1
  dimridå_1_N : N ; -- dimridå..nn.1
  dimslöja_1_N : N ; -- dimslöja..nn.1
  dinar_1_N : N ; -- dinar..nn.1
  dinatriumvätefosfat_1_N : N ; -- dinatriumvätefosfat..nn.1
  dinera_1_V : V ; -- dinera..vb.1
  dinerande_1_N : N ; -- dinerande..nn.1
  dinering_1_N : N ; -- dinering..nn.1
  ding_1_A : A ; -- ding..av.1
  dinge_1_N : N ; -- dinge..nn.1
  dingeldangel_1_N : N ; -- dingeldangel..nn.1
  dinghet_1_N : N ; -- dinghet..nn.1
  dingla_1_V : V ; -- dingla..vb.1
  dinglande_1_N : N ; -- dinglande..nn.1
  dingo_1_N : N ; -- dingo..nn.1
  dinkel_1_N : N ; -- dinkel..nn.1
  dinosaur_1_N : N ; -- dinosaur..nn.1
  dinosaurie_1_N : N ; -- dinosaurie..nn.1
  dinosaurieart_1_N : N ; -- dinosaurieart..nn.1
  diné_1_N : N ; -- diné..nn.1
  diod_1_N : N ; -- diod..nn.1
  dionysisk_1_A : A ; -- dionysisk..av.1
  diopter_1_N : N ; -- diopter..nn.1
  dioptri_1_N : N ; -- dioptri..nn.1
  dioptrik_1_N : N ; -- dioptrik..nn.1
  dioptrisk_1_A : A ; -- dioptrisk..av.1
  diorama_1_N : N ; -- diorama..nn.1
  diorit_1_N : N ; -- diorit..nn.1
  dioskur_1_N : N ; -- dioskur..nn.1
  dioxin_1_N : N ; -- dioxin..nn.1
  dip_1_N : N ; -- dip..nn.1
  diperiod_1_N : N ; -- diperiod..nn.1
  diploid_1_A : A ; -- diploid..av.1
  diplom_1_N : N ; -- diplom..nn.1
  diplomat_1_N : N ; -- diplomat..nn.1
  diplomatarisk_1_A : A ; -- diplomatarisk..av.1
  diplomatarium_1_N : N ; -- diplomatarium..nn.1
  diplomatbostad_1_N : N ; -- diplomatbostad..nn.1
  diplomatdotter_1_N : N ; -- diplomatdotter..nn.1
  diplomathustru_1_N : N ; -- diplomathustru..nn.1
  diplomati_1_N : N ; -- diplomati..nn.1
  diplomatik_1_N : N ; -- diplomatik..nn.1
  diplomatisk_1_A : A ; -- diplomatisk..av.1
  diplomatisk_2_A : A ; -- diplomatisk..av.2
  diplomatkrets_1_N : N ; -- diplomatkrets..nn.1
  diplomatkälla_1_N : N ; -- diplomatkälla..nn.1
  diplomatkår_1_N : N ; -- diplomatkår..nn.1
  diplomatpass_1_N : N ; -- diplomatpass..nn.1
  diplomatportfölj_1_N : N ; -- diplomatportfölj..nn.1
  diplomatpost_1_N : N ; -- diplomatpost..nn.1
  diplomera_1_V : V ; -- diplomera..vb.1
  diplomerande_1_N : N ; -- diplomerande..nn.1
  diplomerbar_1_A : A ; -- diplomerbar..av.1
  diplomerbarhet_1_N : N ; -- diplomerbarhet..nn.1
  diplomering_1_N : N ; -- diplomering..nn.1
  diplomingenjör_1_N : N ; -- diplomingenjör..nn.1
  dipmix_1_N : N ; -- dipmix..nn.1
  dipol_1_N : N ; -- dipol..nn.1
  dipp_1_N : N ; -- dipp..nn.1
  dippa_1_V : V ; -- dippa..vb.1
  dippa_2_V : V ; -- dippa..vb.2
  dippande_1_N : N ; -- dippande..nn.1
  dipsan_1_N : N ; -- dipsan..nn.1
  dipsoman_1_N : N ; -- dipsoman..nn.1
  dipsomani_1_N : N ; -- dipsomani..nn.1
  diptyk_1_N : N ; -- diptyk..nn.1
  direkt_1_A : A ; -- direkt..av.1
  direktdemokrati_1_N : N ; -- direktdemokrati..nn.1
  direktflyg_1_N : N ; -- direktflyg..nn.1
  direkthet_1_N : N ; -- direkthet..nn.1
  direktinflytande_1_N : N ; -- direktinflytande..nn.1
  direktinsprutning_1_N : N ; -- direktinsprutning..nn.1
  direktion_1_N : N ; -- direktion..nn.1
  direktionskraft_1_N : N ; -- direktionskraft..nn.1
  direktiv_1_N : N ; -- direktiv..nn.1
  direktkonfrontation_1_N : N ; -- direktkonfrontation..nn.1
  direktkontakt_1_N : N ; -- direktkontakt..nn.1
  direktlinje_1_N : N ; -- direktlinje..nn.1
  direktlyftande_1_A : A ; -- direktlyftande..av.1
  direktmetod_1_N : N ; -- direktmetod..nn.1
  direktor_1_N : N ; -- direktor..nn.1
  direktreferat_1_N : N ; -- direktreferat..nn.1
  direktreklam_1_N : N ; -- direktreklam..nn.1
  direktreklamsbolag_1_N : N ; -- direktreklamsbolag..nn.1
  direktremiss_1_N : N ; -- direktremiss..nn.1
  direktris_1_N : N ; -- direktris..nn.1
  direktskott_1_N : N ; -- direktskott..nn.1
  direktsända_1_V : V ; -- direktsända..vb.1
  direktsändande_1_N : N ; -- direktsändande..nn.1
  direktsändning_1_N : N ; -- direktsändning..nn.1
  direktträff_1_N : N ; -- direktträff..nn.1
  direktverkande_1_A : A ; -- direktverkande..av.1
  direktväxel_1_N : N ; -- direktväxel..nn.1
  direktör_1_N : N ; -- direktör..nn.1
  dirigent_1_N : N ; -- dirigent..nn.1
  dirigera_1_V : V ; -- dirigera..vb.1
  dirigerande_1_N : N ; -- dirigerande..nn.1
  dirigerbar_1_A : A ; -- dirigerbar..av.1
  dirigerbarhet_1_N : N ; -- dirigerbarhet..nn.1
  dirigering_1_N : N ; -- dirigering..nn.1
  dirigism_1_N : N ; -- dirigism..nn.1
  dirk_1_N : N ; -- dirk..nn.1
  dirka_1_V : V ; -- dirka..vb.1
  dirkande_1_N : N ; -- dirkande..nn.1
  dirra_1_V : V ; -- dirra..vb.1
  dirrande_1_N : N ; -- dirrande..nn.1
  dis_1_N : N ; -- dis..nn.1
  dis_2_N : N ; -- dis..nn.2
  disackarid_1_N : N ; -- disackarid..nn.1
  disambiguera_1_V : V ; -- disambiguera..vb.1
  disambiguerande_1_N : N ; -- disambiguerande..nn.1
  disambiguerbar_1_A : A ; -- disambiguerbar..av.1
  disambiguerbarhet_1_N : N ; -- disambiguerbarhet..nn.1
  discipel_1_N : N ; -- discipel..nn.1
  disciplin_1_N : N ; -- disciplin..nn.1
  disciplinbot_1_N : N ; -- disciplinbot..nn.1
  disciplinera_1_V : V ; -- disciplinera..vb.1
  disciplinerad_1_A : A ; -- disciplinerad..av.1
  disciplinerande_1_N : N ; -- disciplinerande..nn.1
  disciplinerbar_1_A : A ; -- disciplinerbar..av.1
  disciplinerbarhet_1_N : N ; -- disciplinerbarhet..nn.1
  disciplinering_1_N : N ; -- disciplinering..nn.1
  disciplingräns_1_N : N ; -- disciplingräns..nn.1
  disciplinmål_1_N : N ; -- disciplinmål..nn.1
  disciplinnämnd_1_N : N ; -- disciplinnämnd..nn.1
  disciplinpåföljd_1_N : N ; -- disciplinpåföljd..nn.1
  disciplinstraff_1_N : N ; -- disciplinstraff..nn.1
  disciplinstress_1_N : N ; -- disciplinstress..nn.1
  disciplinär_1_A : A ; -- disciplinär..av.1
  disciplinärende_1_N : N ; -- disciplinärende..nn.1
  discjockey_1_N : N ; -- discjockey..nn.1
  disco_1_N : N ; -- disco..nn.1
  disco_2_N : N ; -- disco..nn.2
  discokula_1_N : N ; -- discokula..nn.1
  discomusik_1_N : N ; -- discomusik..nn.1
  disharmoni_1_N : N ; -- disharmoni..nn.1
  disharmoniera_1_V : V ; -- disharmoniera..vb.1
  disharmonierande_1_N : N ; -- disharmonierande..nn.1
  disharmonierbar_1_A : A ; -- disharmonierbar..av.1
  disharmonierbarhet_1_N : N ; -- disharmonierbarhet..nn.1
  disharmoniering_1_N : N ; -- disharmoniering..nn.1
  disharmonisk_1_A : A ; -- disharmonisk..av.1
  disig_1_A : A ; -- disig..av.1
  disighet_1_N : N ; -- disighet..nn.1
  disjunkt_1_A : A ; -- disjunkt..av.1
  disjunktion_1_N : N ; -- disjunktion..nn.1
  disjunktiv_1_A : A ; -- disjunktiv..av.1
  disk_1_N : N ; -- disk..nn.1
  diska_1_V : V ; -- diska..vb.1
  diska_2_V : V ; -- diska..vb.2
  diskande_1_N : N ; -- diskande..nn.1
  diskant_1_N : N ; -- diskant..nn.1
  diskantklav_1_N : N ; -- diskantklav..nn.1
  diskare_1_N : N ; -- diskare..nn.1
  diskbalja_1_N : N ; -- diskbalja..nn.1
  diskblomma_1_N : N ; -- diskblomma..nn.1
  diskbrock_1_N : N ; -- diskbrock..nn.1
  diskbråck_1_N : N ; -- diskbråck..nn.1
  diskbänk_1_N : N ; -- diskbänk..nn.1
  diskett_1_N : N ; -- diskett..nn.1
  diskhandske_1_N : N ; -- diskhandske..nn.1
  diskho_1_N : N ; -- diskho..nn.1
  diskjockey_1_N : N ; -- diskjockey..nn.1
  diskmaskin_1_N : N ; -- diskmaskin..nn.1
  diskmedel_1_N : N ; -- diskmedel..nn.1
  diskning_1_N : N ; -- diskning..nn.1
  diskning_2_N : N ; -- diskning..nn.2
  disko_1_N : N ; -- disko..nn.1
  disko_2_N : N ; -- disko..nn.2
  diskofil_1_N : N ; -- diskofil..nn.1
  diskomusik_1_N : N ; -- diskomusik..nn.1
  diskontera_1_V : V ; -- diskontera..vb.1
  diskonterande_1_N : N ; -- diskonterande..nn.1
  diskonterbar_1_A : A ; -- diskonterbar..av.1
  diskonterbarhet_1_N : N ; -- diskonterbarhet..nn.1
  diskontering_1_N : N ; -- diskontering..nn.1
  diskontinuerlig_1_A : A ; -- diskontinuerlig..av.1
  diskontinuerlighet_1_N : N ; -- diskontinuerlighet..nn.1
  diskontinuitet_1_N : N ; -- diskontinuitet..nn.1
  diskontnota_1_N : N ; -- diskontnota..nn.1
  diskonto_1_N : N ; -- diskonto..nn.1
  diskontör_1_N : N ; -- diskontör..nn.1
  diskordans_1_N : N ; -- diskordans..nn.1
  diskordant_1_A : A ; -- diskordant..av.1
  diskotek_1_N : N ; -- diskotek..nn.1
  diskplockare_1_N : N ; -- diskplockare..nn.1
  diskreditera_1_V : V ; -- diskreditera..vb.1
  diskrediterande_1_N : N ; -- diskrediterande..nn.1
  diskrediterbar_1_A : A ; -- diskrediterbar..av.1
  diskrediterbarhet_1_N : N ; -- diskrediterbarhet..nn.1
  diskreditering_1_N : N ; -- diskreditering..nn.1
  diskrepans_1_N : N ; -- diskrepans..nn.1
  diskret_1_A : A ; -- diskret..av.1
  diskretion_1_N : N ; -- diskretion..nn.1
  diskriminera_1_V : V ; -- diskriminera..vb.1
  diskriminerande_1_N : N ; -- diskriminerande..nn.1
  diskriminerbar_1_A : A ; -- diskriminerbar..av.1
  diskriminerbarhet_1_N : N ; -- diskriminerbarhet..nn.1
  diskriminering_1_N : N ; -- diskriminering..nn.1
  diskrimineringsbekämpning_1_N : N ; -- diskrimineringsbekämpning..nn.1
  diskrimineringslagstiftning_1_N : N ; -- diskrimineringslagstiftning..nn.1
  diskrum_1_N : N ; -- diskrum..nn.1
  diskställ_1_N : N ; -- diskställ..nn.1
  disktorkning_1_N : N ; -- disktorkning..nn.1
  disktrasa_1_N : N ; -- disktrasa..nn.1
  diskurs_1_N : N ; -- diskurs..nn.1
  diskursiv_1_A : A ; -- diskursiv..av.1
  diskus_1_N : N ; -- diskus..nn.1
  diskuskastare_1_N : N ; -- diskuskastare..nn.1
  diskuskastning_1_N : N ; -- diskuskastning..nn.1
  diskussion_1_N : N ; -- diskussion..nn.1
  diskussionsforum_1_N : N ; -- diskussionsforum..nn.1
  diskussionsprotokoll_1_N : N ; -- diskussionsprotokoll..nn.1
  diskussionsunderlag_1_N : N ; -- diskussionsunderlag..nn.1
  diskussionsämne_1_N : N ; -- diskussionsämne..nn.1
  diskutabel_1_A : A ; -- diskutabel..av.1
  diskutera_1_V : V ; -- diskutera..vb.1
  diskuterande_1_N : N ; -- diskuterande..nn.1
  diskuterbar_1_A : A ; -- diskuterbar..av.1
  diskuterbarhet_1_N : N ; -- diskuterbarhet..nn.1
  diskutering_1_N : N ; -- diskutering..nn.1
  diskvalificera_1_V : V ; -- diskvalificera..vb.1
  diskvalificerande_1_N : N ; -- diskvalificerande..nn.1
  diskvalificerbar_1_A : A ; -- diskvalificerbar..av.1
  diskvalificerbarhet_1_N : N ; -- diskvalificerbarhet..nn.1
  diskvalificering_1_N : N ; -- diskvalificering..nn.1
  diskvalifikation_1_N : N ; -- diskvalifikation..nn.1
  diskvatten_1_N : N ; -- diskvatten..nn.1
  dislokation_1_N : N ; -- dislokation..nn.1
  disparat_1_A : A ; -- disparat..av.1
  dispasch_1_N : N ; -- dispasch..nn.1
  dispaschera_1_V : V ; -- dispaschera..vb.1
  dispascherande_1_N : N ; -- dispascherande..nn.1
  dispascherbar_1_A : A ; -- dispascherbar..av.1
  dispascherbarhet_1_N : N ; -- dispascherbarhet..nn.1
  dispaschering_1_N : N ; -- dispaschering..nn.1
  dispaschör_1_N : N ; -- dispaschör..nn.1
  dispens_1_N : N ; -- dispens..nn.1
  dispensera_1_V : V ; -- dispensera..vb.1
  dispenserande_1_N : N ; -- dispenserande..nn.1
  dispenserbar_1_A : A ; -- dispenserbar..av.1
  dispenserbarhet_1_N : N ; -- dispenserbarhet..nn.1
  dispensering_1_N : N ; -- dispensering..nn.1
  dispensär_1_N : N ; -- dispensär..nn.1
  dispergera_1_V : V ; -- dispergera..vb.1
  dispergerande_1_N : N ; -- dispergerande..nn.1
  dispergerbar_1_A : A ; -- dispergerbar..av.1
  dispergerbarhet_1_N : N ; -- dispergerbarhet..nn.1
  dispergering_1_N : N ; -- dispergering..nn.1
  dispers_1_A : A ; -- dispers..av.1
  dispersion_1_N : N ; -- dispersion..nn.1
  display_1_N : N ; -- display..nn.1
  disponent_1_N : N ; -- disponent..nn.1
  disponera_1_V : V ; -- disponera..vb.1
  disponerad_1_A : A ; -- disponerad..av.1
  disponerande_1_N : N ; -- disponerande..nn.1
  disponerbar_1_A : A ; -- disponerbar..av.1
  disponerbarhet_1_N : N ; -- disponerbarhet..nn.1
  disponering_1_N : N ; -- disponering..nn.1
  disponibel_1_A : A ; -- disponibel..av.1
  disponibilitet_1_N : N ; -- disponibilitet..nn.1
  disposition_1_N : N ; -- disposition..nn.1
  dispositionsfond_1_N : N ; -- dispositionsfond..nn.1
  dispositionsrätt_1_N : N ; -- dispositionsrätt..nn.1
  dispositiv_1_A : A ; -- dispositiv..av.1
  disproportion_1_N : N ; -- disproportion..nn.1
  disproportionerlig_1_A : A ; -- disproportionerlig..av.1
  disproportionerlighet_1_N : N ; -- disproportionerlighet..nn.1
  disputation_1_N : N ; -- disputation..nn.1
  disputationsakt_1_N : N ; -- disputationsakt..nn.1
  disputera_1_V : V ; -- disputera..vb.1
  disputerande_1_N : N ; -- disputerande..nn.1
  disputerbar_1_A : A ; -- disputerbar..av.1
  disputerbarhet_1_N : N ; -- disputerbarhet..nn.1
  disputering_1_N : N ; -- disputering..nn.1
  dispyt_1_N : N ; -- dispyt..nn.1
  diss_1_N : N ; -- diss..nn.1
  dissa_1_V : V ; -- dissa..vb.1
  dissande_1_N : N ; -- dissande..nn.1
  dissekera_1_V : V ; -- dissekera..vb.1
  dissekerande_1_N : N ; -- dissekerande..nn.1
  dissekerbar_1_A : A ; -- dissekerbar..av.1
  dissekerbarhet_1_N : N ; -- dissekerbarhet..nn.1
  dissekering_1_N : N ; -- dissekering..nn.1
  dissektion_1_N : N ; -- dissektion..nn.1
  dissenter_1_N : N ; -- dissenter..nn.1
  dissertation_1_N : N ; -- dissertation..nn.1
  dissident_1_N : N ; -- dissident..nn.1
  dissimilation_1_N : N ; -- dissimilation..nn.1
  dissimilera_1_V : V ; -- dissimilera..vb.1
  dissimilerande_1_N : N ; -- dissimilerande..nn.1
  dissimilerbar_1_A : A ; -- dissimilerbar..av.1
  dissimilerbarhet_1_N : N ; -- dissimilerbarhet..nn.1
  dissimilering_1_N : N ; -- dissimilering..nn.1
  dissociation_1_N : N ; -- dissociation..nn.1
  dissociera_1_V : V ; -- dissociera..vb.1
  dissocierande_1_N : N ; -- dissocierande..nn.1
  dissocierbar_1_A : A ; -- dissocierbar..av.1
  dissocierbarhet_1_N : N ; -- dissocierbarhet..nn.1
  dissociering_1_N : N ; -- dissociering..nn.1
  dissonans_1_N : N ; -- dissonans..nn.1
  dissonant_1_A : A ; -- dissonant..av.1
  dissonant_1_N : N ; -- dissonant..nn.1
  dissonera_1_V : V ; -- dissonera..vb.1
  dissonerande_1_N : N ; -- dissonerande..nn.1
  dissonering_1_N : N ; -- dissonering..nn.1
  distans_1_N : N ; -- distans..nn.1
  distansbygel_1_N : N ; -- distansbygel..nn.1
  distansera_1_V : V ; -- distansera..vb.1
  distanserande_1_N : N ; -- distanserande..nn.1
  distanserbar_1_A : A ; -- distanserbar..av.1
  distanserbarhet_1_N : N ; -- distanserbarhet..nn.1
  distansering_1_N : N ; -- distansering..nn.1
  distansflygning_1_N : N ; -- distansflygning..nn.1
  distanshögskola_1_N : N ; -- distanshögskola..nn.1
  distanslös_1_A : A ; -- distanslös..av.1
  distansminut_1_N : N ; -- distansminut..nn.1
  distansmätare_1_N : N ; -- distansmätare..nn.1
  distansmätning_1_N : N ; -- distansmätning..nn.1
  distansritt_1_N : N ; -- distansritt..nn.1
  distansundervisning_1_N : N ; -- distansundervisning..nn.1
  distikon_1_N : N ; -- distikon..nn.1
  disting_1_N : N ; -- disting..nn.1
  distingerad_1_A : A ; -- distingerad..av.1
  distinkt_1_A : A ; -- distinkt..av.1
  distinktion_1_N : N ; -- distinktion..nn.1
  distorsion_1_N : N ; -- distorsion..nn.1
  distrahera_1_V : V ; -- distrahera..vb.1
  distraherad_1_A : A ; -- distraherad..av.1
  distraherande_1_N : N ; -- distraherande..nn.1
  distraherbar_1_A : A ; -- distraherbar..av.1
  distraherbarhet_1_N : N ; -- distraherbarhet..nn.1
  distrahering_1_N : N ; -- distrahering..nn.1
  distraktion_1_N : N ; -- distraktion..nn.1
  distraktor_1_N : N ; -- distraktor..nn.1
  distribuent_1_N : N ; -- distribuent..nn.1
  distribuera_1_V : V ; -- distribuera..vb.1
  distribuerande_1_N : N ; -- distribuerande..nn.1
  distribuerbar_1_A : A ; -- distribuerbar..av.1
  distribuerbarhet_1_N : N ; -- distribuerbarhet..nn.1
  distribuering_1_N : N ; -- distribuering..nn.1
  distribunal_1_N : N ; -- distribunal..nn.1
  distribution_1_N : N ; -- distribution..nn.1
  distributionscentral_1_N : N ; -- distributionscentral..nn.1
  distributionsföretag_1_N : N ; -- distributionsföretag..nn.1
  distributiv_1_A : A ; -- distributiv..av.1
  distributör_1_N : N ; -- distributör..nn.1
  distrikt_1_N : N ; -- distrikt..nn.1
  distriktsläkare_1_N : N ; -- distriktsläkare..nn.1
  distriktsmästare_1_N : N ; -- distriktsmästare..nn.1
  distriktsmästerskap_1_N : N ; -- distriktsmästerskap..nn.1
  distriktsordförande_1_N : N ; -- distriktsordförande..nn.1
  disträ_1_A : A ; -- disträ..av.1
  disös_1_N : N ; -- disös..nn.1
  ditflugen_1_A : A ; -- ditflugen..av.1
  ditfärd_1_N : N ; -- ditfärd..nn.1
  dithörande_1_A : A ; -- dithörande..av.1
  ditin_1_Adv : Adv ; -- ditin..ab.1
  ditkomst_1_N : N ; -- ditkomst..nn.1
  dito_1_A : A ; -- dito..av.1
  ditresa_1_N : N ; -- ditresa..nn.1
  dittillsvarande_1_A : A ; -- dittillsvarande..av.1
  ditut_1_Adv : Adv ; -- ditut..ab.1
  dityramb_1_N : N ; -- dityramb..nn.1
  dityrambisk_1_A : A ; -- dityrambisk..av.1
  diva_1_N : N ; -- diva..nn.1
  divan_1_N : N ; -- divan..nn.1
  divergens_1_N : N ; -- divergens..nn.1
  divergent_1_A : A ; -- divergent..av.1
  divergera_1_V : V ; -- divergera..vb.1
  divergerande_1_N : N ; -- divergerande..nn.1
  divergerbar_1_A : A ; -- divergerbar..av.1
  divergerbarhet_1_N : N ; -- divergerbarhet..nn.1
  divergering_1_N : N ; -- divergering..nn.1
  diverse_1_A : A ; -- diverse..av.1
  diversearbetare_1_N : N ; -- diversearbetare..nn.1
  diversehandel_1_N : N ; -- diversehandel..nn.1
  diversifiera_1_V : V ; -- diversifiera..vb.1
  diversifierande_1_N : N ; -- diversifierande..nn.1
  diversifierbar_1_A : A ; -- diversifierbar..av.1
  diversifierbarhet_1_N : N ; -- diversifierbarhet..nn.1
  diversifiering_1_N : N ; -- diversifiering..nn.1
  diversion_1_N : N ; -- diversion..nn.1
  divertissemang_1_N : N ; -- divertissemang..nn.1
  dividend_1_N : N ; -- dividend..nn.1
  dividera_1_V : V ; -- dividera..vb.1
  dividerande_1_N : N ; -- dividerande..nn.1
  dividerbar_1_A : A ; -- dividerbar..av.1
  dividerbarhet_1_N : N ; -- dividerbarhet..nn.1
  dividering_1_N : N ; -- dividering..nn.1
  divig_1_A : A ; -- divig..av.1
  divinatorisk_1_A : A ; -- divinatorisk..av.1
  divis_1_N : N ; -- divis..nn.1
  division_1_N : N ; -- division..nn.1
  divisionschef_1_N : N ; -- divisionschef..nn.1
  divisionsfana_1_N : N ; -- divisionsfana..nn.1
  divisionsgeneral_1_N : N ; -- divisionsgeneral..nn.1
  divisor_1_N : N ; -- divisor..nn.1
  dixieland_1_N : N ; -- dixieland..nn.1
  djiboutier_1_N : N ; -- djiboutier..nn.1
  djiboutisk_1_A : A ; -- djiboutisk..av.1
  djiboutiska_1_N : N ; -- djiboutiska..nn.1
  djonk_1_N : N ; -- djonk..nn.1
  djungel_1_N : N ; -- djungel..nn.1
  djungelbryn_1_N : N ; -- djungelbryn..nn.1
  djungeltelegraf_1_N : N ; -- djungeltelegraf..nn.1
  djup_1_A : A ; -- djup..av.1
  djup_1_N : N ; -- djup..nn.1
  djupavslappning_1_N : N ; -- djupavslappning..nn.1
  djupbergart_1_N : N ; -- djupbergart..nn.1
  djupbild_1_N : N ; -- djupbild..nn.1
  djupblå_1_A : A ; -- djupblå..av.1
  djupborra_1_V : V ; -- djupborra..vb.1
  djupborrad_1_A : A ; -- djupborrad..av.1
  djupborrande_1_A : A ; -- djupborrande..av.1
  djupborrande_1_N : N ; -- djupborrande..nn.1
  djupborrning_1_N : N ; -- djupborrning..nn.1
  djupbrytning_1_N : N ; -- djupbrytning..nn.1
  djupdimension_1_N : N ; -- djupdimension..nn.1
  djupdykning_1_N : N ; -- djupdykning..nn.1
  djupfrysa_1_V : V ; -- djupfrysa..vb.1
  djupfrysande_1_N : N ; -- djupfrysande..nn.1
  djupfuktande_1_A : A ; -- djupfuktande..av.1
  djupgrön_1_A : A ; -- djupgrön..av.1
  djupgående_1_A : A ; -- djupgående..av.1
  djupgående_1_N : N ; -- djupgående..nn.1
  djuphav_1_N : N ; -- djuphav..nn.1
  djuphavsbotten_1_N : N ; -- djuphavsbotten..nn.1
  djuphavsfisk_1_N : N ; -- djuphavsfisk..nn.1
  djuphavsgrav_1_N : N ; -- djuphavsgrav..nn.1
  djuphavsvatten_1_N : N ; -- djuphavsvatten..nn.1
  djuphet_1_N : N ; -- djuphet..nn.1
  djuping_1_N : N ; -- djuping..nn.1
  djupintervju_1_N : N ; -- djupintervju..nn.1
  djupkultur_1_N : N ; -- djupkultur..nn.1
  djuplek_1_N : N ; -- djuplek..nn.1
  djuplod_1_N : N ; -- djuplod..nn.1
  djuploda_1_V : V ; -- djuploda..vb.1
  djuplodande_1_A : A ; -- djuplodande..av.1
  djuplodande_1_N : N ; -- djuplodande..nn.1
  djuplodning_1_N : N ; -- djuplodning..nn.1
  djupmask_1_N : N ; -- djupmask..nn.1
  djupna_1_V : V ; -- djupna..vb.1
  djupnande_1_N : N ; -- djupnande..nn.1
  djuppsykologi_1_N : N ; -- djuppsykologi..nn.1
  djuprengörande_1_A : A ; -- djuprengörande..av.1
  djuprotad_1_A : A ; -- djuprotad..av.1
  djupröd_1_A : A ; -- djupröd..av.1
  djupsinne_1_N : N ; -- djupsinne..nn.1
  djupsinnig_1_A : A ; -- djupsinnig..av.1
  djupsinnighet_1_N : N ; -- djupsinnighet..nn.1
  djupstruktur_1_N : N ; -- djupstruktur..nn.1
  djupsömn_1_N : N ; -- djupsömn..nn.1
  djuptallrik_1_N : N ; -- djuptallrik..nn.1
  djuptryck_1_N : N ; -- djuptryck..nn.1
  djuptänkt_1_A : A ; -- djuptänkt..av.1
  djuptänkthet_1_N : N ; -- djuptänkthet..nn.1
  djupurladdning_1_N : N ; -- djupurladdning..nn.1
  djupvatten_1_N : N ; -- djupvatten..nn.1
  djur_1_N : N ; -- djur..nn.1
  djuranatomi_1_N : N ; -- djuranatomi..nn.1
  djurangrepp_1_N : N ; -- djurangrepp..nn.1
  djurart_1_N : N ; -- djurart..nn.1
  djurben_1_N : N ; -- djurben..nn.1
  djurblod_1_N : N ; -- djurblod..nn.1
  djurbok_1_N : N ; -- djurbok..nn.1
  djurdel_1_N : N ; -- djurdel..nn.1
  djurfabel_1_N : N ; -- djurfabel..nn.1
  djurfoder_1_N : N ; -- djurfoder..nn.1
  djurfot_1_N : N ; -- djurfot..nn.1
  djurförbud_1_N : N ; -- djurförbud..nn.1
  djurförsök_1_N : N ; -- djurförsök..nn.1
  djurförädling_1_N : N ; -- djurförädling..nn.1
  djurgeografi_1_N : N ; -- djurgeografi..nn.1
  djurgrupp_1_N : N ; -- djurgrupp..nn.1
  djurgård_1_N : N ; -- djurgård..nn.1
  djurhamn_1_N : N ; -- djurhamn..nn.1
  djurhud_1_N : N ; -- djurhud..nn.1
  djurhuvud_1_N : N ; -- djurhuvud..nn.1
  djurhälsa_1_N : N ; -- djurhälsa..nn.1
  djurhållning_1_N : N ; -- djurhållning..nn.1
  djurhövdad_1_A : A ; -- djurhövdad..av.1
  djurisk_1_A : A ; -- djurisk..av.1
  djuriskhet_1_N : N ; -- djuriskhet..nn.1
  djurkadaver_1_N : N ; -- djurkadaver..nn.1
  djurkrets_1_N : N ; -- djurkrets..nn.1
  djurkropp_1_N : N ; -- djurkropp..nn.1
  djurliknande_1_A : A ; -- djurliknande..av.1
  djurliv_1_N : N ; -- djurliv..nn.1
  djurläkare_1_N : N ; -- djurläkare..nn.1
  djurläte_1_N : N ; -- djurläte..nn.1
  djurmat_1_N : N ; -- djurmat..nn.1
  djurmålning_1_N : N ; -- djurmålning..nn.1
  djurmålning_2_N : N ; -- djurmålning..nn.2
  djurornamentik_1_N : N ; -- djurornamentik..nn.1
  djurpark_1_N : N ; -- djurpark..nn.1
  djurparksvarg_1_N : N ; -- djurparksvarg..nn.1
  djurplankton_1_N : N ; -- djurplankton..nn.1
  djurplågare_1_N : N ; -- djurplågare..nn.1
  djurplågeri_1_N : N ; -- djurplågeri..nn.1
  djurpsykologi_1_N : N ; -- djurpsykologi..nn.1
  djurrike_1_N : N ; -- djurrike..nn.1
  djurrättsaktivist_1_N : N ; -- djurrättsaktivist..nn.1
  djurrättsfråga_1_N : N ; -- djurrättsfråga..nn.1
  djursjukhus_1_N : N ; -- djursjukhus..nn.1
  djurskinn_1_N : N ; -- djurskinn..nn.1
  djurskydd_1_N : N ; -- djurskydd..nn.1
  djurskyddsförening_1_N : N ; -- djurskyddsförening..nn.1
  djurskyddsinspektör_1_N : N ; -- djurskyddsinspektör..nn.1
  djurskyddslagstiftning_1_N : N ; -- djurskyddslagstiftning..nn.1
  djurskyddsmässig_1_A : A ; -- djurskyddsmässig..av.1
  djurskötare_1_N : N ; -- djurskötare..nn.1
  djurskötsel_1_N : N ; -- djurskötsel..nn.1
  djurslag_1_N : N ; -- djurslag..nn.1
  djurstig_1_N : N ; -- djurstig..nn.1
  djurtarm_1_N : N ; -- djurtarm..nn.1
  djurtillsyn_1_N : N ; -- djurtillsyn..nn.1
  djurtämjare_1_N : N ; -- djurtämjare..nn.1
  djuruppfödning_1_N : N ; -- djuruppfödning..nn.1
  djurutställning_1_N : N ; -- djurutställning..nn.1
  djurvän_1_N : N ; -- djurvän..nn.1
  djurvänlig_1_A : A ; -- djurvänlig..av.1
  djurvänlighet_1_N : N ; -- djurvänlighet..nn.1
  djurvärld_1_N : N ; -- djurvärld..nn.1
  djäklig_1_A : A ; -- djäklig..av.1
  djäklighet_1_N : N ; -- djäklighet..nn.1
  djäkne_1_N : N ; -- djäkne..nn.1
  djärv_1_A : A ; -- djärv..av.1
  djärvhet_1_N : N ; -- djärvhet..nn.1
  djävel_1_N : N ; -- djävel..nn.1
  djävelsk_1_A : A ; -- djävelsk..av.1
  djävelskap_1_N : N ; -- djävelskap..nn.1
  djävelstyg_1_N : N ; -- djävelstyg..nn.1
  djävla_1_A : A ; -- djävla..av.1
  djävlig_1_A : A ; -- djävlig..av.1
  djävlighet_1_N : N ; -- djävlighet..nn.1
  djävligt_1_Adv : Adv ; -- djävligt..ab.1
  djävul_1_N : N ; -- djävul..nn.1
  djävulsbesvärjare_1_N : N ; -- djävulsbesvärjare..nn.1
  djävulsbesvärjelse_1_N : N ; -- djävulsbesvärjelse..nn.1
  djävulsk_1_A : A ; -- djävulsk..av.1
  djävulskap_1_N : N ; -- djävulskap..nn.1
  djävulskonst_1_N : N ; -- djävulskonst..nn.1
  djävulsspiral_1_N : N ; -- djävulsspiral..nn.1
  djävulstro_1_N : N ; -- djävulstro..nn.1
  djävulstyg_1_N : N ; -- djävulstyg..nn.1
  djävulusisk_1_A : A ; -- djävulusisk..av.1
  dna_kedja_1_N : N ; -- dna-kedja..nn.1
  dna_molekyl_1_N : N ; -- dna-molekyl..nn.1
  dna_profil_1_N : N ; -- dna-profil..nn.1
  dna_sekvens_1_N : N ; -- dna-sekvens..nn.1
  dna_sekvensering_1_N : N ; -- dna-sekvensering..nn.1
  dna_spår_1_N : N ; -- dna-spår..nn.1
  dna_sträng_1_N : N ; -- dna-sträng..nn.1
  dna_test_1_N : N ; -- dna-test..nn.1
  dna_testa_1_V : V ; -- dna-testa..vb.1
  dna_testande_1_N : N ; -- dna-testande..nn.1
  dna_testning_1_N : N ; -- dna-testning..nn.1
  dna_uppsättning_1_N : N ; -- dna-uppsättning..nn.1
  doa_1_V : V ; -- doa..vb.1
  doakör_1_N : N ; -- doakör..nn.1
  doande_1_N : N ; -- doande..nn.1
  dobbel_1_N : N ; -- dobbel..nn.1
  dobbla_1_V : V ; -- dobbla..vb.1
  dobblande_1_N : N ; -- dobblande..nn.1
  dobblare_1_N : N ; -- dobblare..nn.1
  docent_1_N : N ; -- docent..nn.1
  docentur_1_N : N ; -- docentur..nn.1
  docera_1_V : V ; -- docera..vb.1
  docera_2_V : V ; -- docera..vb.2
  docerande_1_N : N ; -- docerande..nn.1
  docerbar_1_A : A ; -- docerbar..av.1
  docerbarhet_1_N : N ; -- docerbarhet..nn.1
  docering_1_N : N ; -- docering..nn.1
  docering_2_N : N ; -- docering..nn.2
  dock_1_Adv : Adv ; -- dock..ab.1
  docka_1_N : N ; -- docka..nn.1
  docka_1_V : V ; -- docka..vb.1
  dockaktig_1_A : A ; -- dockaktig..av.1
  dockaktighet_1_N : N ; -- dockaktighet..nn.1
  dockande_1_N : N ; -- dockande..nn.1
  dockansikte_1_N : N ; -- dockansikte..nn.1
  dockkudde_1_N : N ; -- dockkudde..nn.1
  dockperuk_1_N : N ; -- dockperuk..nn.1
  dockskåp_1_N : N ; -- dockskåp..nn.1
  docksöt_1_A : A ; -- docksöt..av.1
  dockteater_1_N : N ; -- dockteater..nn.1
  dodekaeder_1_N : N ; -- dodekaeder..nn.1
  doft_1_N : N ; -- doft..nn.1
  doft_2_N : N ; -- doft..nn.2
  dofta_1_V : V ; -- dofta..vb.1
  dofta_2_V : V ; -- dofta..vb.2
  doftande_1_N : N ; -- doftande..nn.1
  doftljus_1_N : N ; -- doftljus..nn.1
  doftlös_1_A : A ; -- doftlös..av.1
  doftlöshet_1_N : N ; -- doftlöshet..nn.1
  doftmarkera_1_V : V ; -- doftmarkera..vb.1
  doftmarkerande_1_N : N ; -- doftmarkerande..nn.1
  doftmarkerbar_1_A : A ; -- doftmarkerbar..av.1
  doftmarkerbarhet_1_N : N ; -- doftmarkerbarhet..nn.1
  doftmarkering_1_N : N ; -- doftmarkering..nn.1
  doftrik_1_A : A ; -- doftrik..av.1
  doftsinne_1_N : N ; -- doftsinne..nn.1
  doftsvag_1_A : A ; -- doftsvag..av.1
  doftsvaghet_1_N : N ; -- doftsvaghet..nn.1
  doftämne_1_N : N ; -- doftämne..nn.1
  dogcart_1_N : N ; -- dogcart..nn.1
  doge_1_N : N ; -- doge..nn.1
  dogg_1_N : N ; -- dogg..nn.1
  dogm_1_N : N ; -- dogm..nn.1
  dogmatik_1_N : N ; -- dogmatik..nn.1
  dogmatiker_1_N : N ; -- dogmatiker..nn.1
  dogmatisera_1_V : V ; -- dogmatisera..vb.1
  dogmatiserande_1_N : N ; -- dogmatiserande..nn.1
  dogmatiserbar_1_A : A ; -- dogmatiserbar..av.1
  dogmatiserbarhet_1_N : N ; -- dogmatiserbarhet..nn.1
  dogmatisering_1_N : N ; -- dogmatisering..nn.1
  dogmatisk_1_A : A ; -- dogmatisk..av.1
  dogmatism_1_N : N ; -- dogmatism..nn.1
  dogmsystem_1_N : N ; -- dogmsystem..nn.1
  doja_1_N : N ; -- doja..nn.1
  dok_1_N : N ; -- dok..nn.1
  doktor_1_N : N ; -- doktor..nn.1
  doktorand_1_N : N ; -- doktorand..nn.1
  doktorera_1_V : V ; -- doktorera..vb.1
  doktorerande_1_N : N ; -- doktorerande..nn.1
  doktorering_1_N : N ; -- doktorering..nn.1
  doktorsavhandling_1_N : N ; -- doktorsavhandling..nn.1
  doktorsdisputation_1_N : N ; -- doktorsdisputation..nn.1
  doktorsexamen_1_N : N ; -- doktorsexamen..nn.1
  doktorsfisk_1_N : N ; -- doktorsfisk..nn.1
  doktorsgrad_1_N : N ; -- doktorsgrad..nn.1
  doktorshatt_1_N : N ; -- doktorshatt..nn.1
  doktorska_1_N : N ; -- doktorska..nn.1
  doktorspromotion_1_N : N ; -- doktorspromotion..nn.1
  doktorsring_1_N : N ; -- doktorsring..nn.1
  doktrin_1_N : N ; -- doktrin..nn.1
  doktrinarism_1_N : N ; -- doktrinarism..nn.1
  doktrinär_1_A : A ; -- doktrinär..av.1
  dokument_1_N : N ; -- dokument..nn.1
  dokumentalist_1_N : N ; -- dokumentalist..nn.1
  dokumentarisk_1_A : A ; -- dokumentarisk..av.1
  dokumentation_1_N : N ; -- dokumentation..nn.1
  dokumentera_1_V : V ; -- dokumentera..vb.1
  dokumenterande_1_N : N ; -- dokumenterande..nn.1
  dokumenterbar_1_A : A ; -- dokumenterbar..av.1
  dokumenterbarhet_1_N : N ; -- dokumenterbarhet..nn.1
  dokumentering_1_N : N ; -- dokumentering..nn.1
  dokumentkreditiv_1_N : N ; -- dokumentkreditiv..nn.1
  dokumentpacke_1_N : N ; -- dokumentpacke..nn.1
  dokumentpapper_1_N : N ; -- dokumentpapper..nn.1
  dokumentportfölj_1_N : N ; -- dokumentportfölj..nn.1
  dokumentsamling_1_N : N ; -- dokumentsamling..nn.1
  dokumentskåp_1_N : N ; -- dokumentskåp..nn.1
  dokumentär_1_A : A ; -- dokumentär..av.1
  dokumentär_1_N : N ; -- dokumentär..nn.1
  dokumentärfilm_1_N : N ; -- dokumentärfilm..nn.1
  dokumentärprogram_1_N : N ; -- dokumentärprogram..nn.1
  dokumentärroman_1_N : N ; -- dokumentärroman..nn.1
  dokusåpa_1_N : N ; -- dokusåpa..nn.1
  dokusåpadeltagare_1_N : N ; -- dokusåpadeltagare..nn.1
  dokusåpakändis_1_N : N ; -- dokusåpakändis..nn.1
  dold_1_A : A ; -- dold..av.1
  doldhet_1_N : N ; -- doldhet..nn.1
  doldis_1_N : N ; -- doldis..nn.1
  dolikocefal_1_A : A ; -- dolikocefal..av.1
  dolikocefal_1_N : N ; -- dolikocefal..nn.1
  dolikocefali_1_N : N ; -- dolikocefali..nn.1
  dolk_1_N : N ; -- dolk..nn.1
  dolkstöt_1_N : N ; -- dolkstöt..nn.1
  dolkstötslegend_1_N : N ; -- dolkstötslegend..nn.1
  dollar_1_N : N ; -- dollar..nn.1
  dollardiplomati_1_N : N ; -- dollardiplomati..nn.1
  dollargrin_1_N : N ; -- dollargrin..nn.1
  dollarprinsessa_1_N : N ; -- dollarprinsessa..nn.1
  dollarsedel_1_N : N ; -- dollarsedel..nn.1
  dollarturist_1_N : N ; -- dollarturist..nn.1
  dolma_1_N : N ; -- dolma..nn.1
  dolma_2_N : N ; -- dolma..nn.2
  dolomit_1_N : N ; -- dolomit..nn.1
  dolsk_1_A : A ; -- dolsk..av.1
  dolskhet_1_N : N ; -- dolskhet..nn.1
  dom_1_N : N ; -- dom..nn.1
  dom_2_N : N ; -- dom..nn.2
  domare_1_N : N ; -- domare..nn.1
  domared_1_N : N ; -- domared..nn.1
  domaredans_1_N : N ; -- domaredans..nn.1
  domarkår_1_N : N ; -- domarkår..nn.1
  domarornat_1_N : N ; -- domarornat..nn.1
  domarpost_1_N : N ; -- domarpost..nn.1
  domarring_1_N : N ; -- domarring..nn.1
  domarsäte_1_N : N ; -- domarsäte..nn.1
  dombok_1_N : N ; -- dombok..nn.1
  domdera_1_V : V ; -- domdera..vb.1
  domderande_1_N : N ; -- domderande..nn.1
  domdering_1_N : N ; -- domdering..nn.1
  domedag_1_N : N ; -- domedag..nn.1
  domedagspredikant_1_N : N ; -- domedagspredikant..nn.1
  domedagspredikning_1_N : N ; -- domedagspredikning..nn.1
  domedagsprofet_1_N : N ; -- domedagsprofet..nn.1
  domedagsstämning_1_N : N ; -- domedagsstämning..nn.1
  domedagstänkande_1_N : N ; -- domedagstänkande..nn.1
  domedagsvapen_1_N : N ; -- domedagsvapen..nn.1
  domesticera_1_V : V ; -- domesticera..vb.1
  domesticerande_1_N : N ; -- domesticerande..nn.1
  domesticerbar_1_A : A ; -- domesticerbar..av.1
  domesticerbarhet_1_N : N ; -- domesticerbarhet..nn.1
  domesticering_1_N : N ; -- domesticering..nn.1
  domestik_1_N : N ; -- domestik..nn.1
  domfälla_1_V : V ; -- domfälla..vb.1
  domfällande_1_N : N ; -- domfällande..nn.1
  domför_1_A : A ; -- domför..av.1
  domhavande_1_A : A ; -- domhavande..av.1
  domherre_1_N : N ; -- domherre..nn.1
  domicil_1_N : N ; -- domicil..nn.1
  domiciliera_1_V : V ; -- domiciliera..vb.1
  domicilierande_1_N : N ; -- domicilierande..nn.1
  domicilierbar_1_A : A ; -- domicilierbar..av.1
  domicilierbarhet_1_N : N ; -- domicilierbarhet..nn.1
  domiciliering_1_N : N ; -- domiciliering..nn.1
  domina_1_N : N ; -- domina..nn.1
  dominans_1_N : N ; -- dominans..nn.1
  dominant_1_A : A ; -- dominant..av.1
  dominant_1_N : N ; -- dominant..nn.1
  dominatrix_1_N : N ; -- dominatrix..nn.1
  dominera_1_V : V ; -- dominera..vb.1
  dominerande_1_A : A ; -- dominerande..av.1
  dominerande_1_N : N ; -- dominerande..nn.1
  dominerbar_1_A : A ; -- dominerbar..av.1
  dominerbarhet_1_N : N ; -- dominerbarhet..nn.1
  dominering_1_N : N ; -- dominering..nn.1
  dominikan_1_N : N ; -- dominikan..nn.1
  dominikanerkloster_1_N : N ; -- dominikanerkloster..nn.1
  dominikanermunk_1_N : N ; -- dominikanermunk..nn.1
  dominikanerorden_1_N : N ; -- dominikanerorden..nn.1
  dominikankloster_1_N : N ; -- dominikankloster..nn.1
  dominikanmunk_1_N : N ; -- dominikanmunk..nn.1
  dominikanorden_1_N : N ; -- dominikanorden..nn.1
  dominikansk_1_A : A ; -- dominikansk..av.1
  dominikanska_1_N : N ; -- dominikanska..nn.1
  dominikansyster_1_N : N ; -- dominikansyster..nn.1
  dominiker_1_N : N ; -- dominiker..nn.1
  dominikisk_1_A : A ; -- dominikisk..av.1
  dominikiska_1_N : N ; -- dominikiska..nn.1
  dominion_1_N : N ; -- dominion..nn.1
  domino_1_N : N ; -- domino..nn.1
  dominobricka_1_N : N ; -- dominobricka..nn.1
  dominoeffekt_1_N : N ; -- dominoeffekt..nn.1
  dominohav_1_N : N ; -- dominohav..nn.1
  dominospel_1_N : N ; -- dominospel..nn.1
  dominoteori_1_N : N ; -- dominoteori..nn.1
  domkapitel_1_N : N ; -- domkapitel..nn.1
  domkraft_1_N : N ; -- domkraft..nn.1
  domkraftsolja_1_N : N ; -- domkraftsolja..nn.1
  domkrets_1_N : N ; -- domkrets..nn.1
  domkval_1_N : N ; -- domkval..nn.1
  domkyrka_1_N : N ; -- domkyrka..nn.1
  domkyrkoadjunkt_1_N : N ; -- domkyrkoadjunkt..nn.1
  domkyrkoförsamling_1_N : N ; -- domkyrkoförsamling..nn.1
  domna_1_V : V ; -- domna..vb.1
  domnande_1_N : N ; -- domnande..nn.1
  domning_1_N : N ; -- domning..nn.1
  domprost_1_N : N ; -- domprost..nn.1
  domptera_1_V : V ; -- domptera..vb.1
  dompterande_1_N : N ; -- dompterande..nn.1
  dompterbar_1_A : A ; -- dompterbar..av.1
  dompterbarhet_1_N : N ; -- dompterbarhet..nn.1
  domptering_1_N : N ; -- domptering..nn.1
  domptör_1_N : N ; -- domptör..nn.1
  domptörsfason_1_N : N ; -- domptörsfason..nn.1
  domsaga_1_N : N ; -- domsaga..nn.1
  domskäl_1_N : N ; -- domskäl..nn.1
  domslut_1_N : N ; -- domslut..nn.1
  domsrätt_1_N : N ; -- domsrätt..nn.1
  domssöndag_1_N : N ; -- domssöndag..nn.1
  domstol_1_N : N ; -- domstol..nn.1
  domstolsbeslut_1_N : N ; -- domstolsbeslut..nn.1
  domstolsbetjänt_1_N : N ; -- domstolsbetjänt..nn.1
  domstolsförhandling_1_N : N ; -- domstolsförhandling..nn.1
  domstolsledamot_1_N : N ; -- domstolsledamot..nn.1
  domstolsmässig_1_A : A ; -- domstolsmässig..av.1
  domstolsmål_1_N : N ; -- domstolsmål..nn.1
  domstolsprotokoll_1_N : N ; -- domstolsprotokoll..nn.1
  domstolssammanträde_1_N : N ; -- domstolssammanträde..nn.1
  domstolssession_1_N : N ; -- domstolssession..nn.1
  domstolsverk_1_N : N ; -- domstolsverk..nn.1
  domsöndag_1_N : N ; -- domsöndag..nn.1
  domvilla_1_N : N ; -- domvilla..nn.1
  domvärjo_1_N : N ; -- domvärjo..nn.1
  domän_1_N : N ; -- domän..nn.1
  domänförvaltning_1_N : N ; -- domänförvaltning..nn.1
  domänintendent_1_N : N ; -- domänintendent..nn.1
  domänstyrelse_1_N : N ; -- domänstyrelse..nn.1
  domänverk_1_N : N ; -- domänverk..nn.1
  don_1_N : N ; -- don..nn.1
  don_2_N : N ; -- don..nn.2
  dona_1_N : N ; -- dona..nn.1
  dona_1_V : V ; -- dona..vb.1
  donande_1_N : N ; -- donande..nn.1
  donation_1_N : N ; -- donation..nn.1
  donationsbrev_1_N : N ; -- donationsbrev..nn.1
  donationsjord_1_N : N ; -- donationsjord..nn.1
  donationsmedel_1_N : N ; -- donationsmedel..nn.1
  donator_1_N : N ; -- donator..nn.1
  donera_1_V : V ; -- donera..vb.1
  donerande_1_N : N ; -- donerande..nn.1
  donerbar_1_A : A ; -- donerbar..av.1
  donerbarhet_1_N : N ; -- donerbarhet..nn.1
  donering_1_N : N ; -- donering..nn.1
  doning_1_N : N ; -- doning..nn.1
  donjuan_1_N : N ; -- donjuan..nn.1
  donk_1_N : N ; -- donk..nn.1
  donka_1_V : V ; -- donka..vb.1
  donka_2_V : V ; -- donka..vb.2
  donkande_1_N : N ; -- donkande..nn.1
  donkeypanna_1_N : N ; -- donkeypanna..nn.1
  donläge_1_N : N ; -- donläge..nn.1
  donna_1_N : N ; -- donna..nn.1
  dop_1_N : N ; -- dop..nn.1
  dopa_1_V : V ; -- dopa..vb.1
  dopamin_1_N : N ; -- dopamin..nn.1
  dopaminblåsa_1_N : N ; -- dopaminblåsa..nn.1
  dopaminkänslig_1_A : A ; -- dopaminkänslig..av.1
  dopaminkänslighet_1_N : N ; -- dopaminkänslighet..nn.1
  dopande_1_N : N ; -- dopande..nn.1
  dopattest_1_N : N ; -- dopattest..nn.1
  dopbassäng_1_N : N ; -- dopbassäng..nn.1
  dopfunt_1_N : N ; -- dopfunt..nn.1
  doping_1_N : N ; -- doping..nn.1
  dopingbrott_1_N : N ; -- dopingbrott..nn.1
  dopinghärva_1_N : N ; -- dopinghärva..nn.1
  dopingpreparat_1_N : N ; -- dopingpreparat..nn.1
  dopnamn_1_N : N ; -- dopnamn..nn.1
  dopning_1_N : N ; -- dopning..nn.1
  dopningsbrott_1_N : N ; -- dopningsbrott..nn.1
  dopningshärva_1_N : N ; -- dopningshärva..nn.1
  dopningspreparat_1_N : N ; -- dopningspreparat..nn.1
  dopp_1_N : N ; -- dopp..nn.1
  dopp_2_N : N ; -- dopp..nn.2
  doppa_1_V : V ; -- doppa..vb.1
  doppande_1_N : N ; -- doppande..nn.1
  doppardag_1_N : N ; -- doppardag..nn.1
  dopparedag_1_N : N ; -- dopparedag..nn.1
  dopping_1_N : N ; -- dopping..nn.1
  dopplereffekt_1_N : N ; -- dopplereffekt..nn.1
  doppning_1_N : N ; -- doppning..nn.1
  doppsko_1_N : N ; -- doppsko..nn.1
  doppvärmare_1_N : N ; -- doppvärmare..nn.1
  dopskål_1_N : N ; -- dopskål..nn.1
  dopvittne_1_N : N ; -- dopvittne..nn.1
  dorer_1_N : N ; -- dorer..nn.1
  dorisk_1_A : A ; -- dorisk..av.1
  dormitorium_1_N : N ; -- dormitorium..nn.1
  dorn_1_N : N ; -- dorn..nn.1
  dorsal_1_A : A ; -- dorsal..av.1
  dorsal_1_N : N ; -- dorsal..nn.1
  dorsk_1_A : A ; -- dorsk..av.1
  dorskhet_1_N : N ; -- dorskhet..nn.1
  dos_1_N : N ; -- dos..nn.1
  dosa_1_N : N ; -- dosa..nn.1
  dosbarometer_1_N : N ; -- dosbarometer..nn.1
  dosekvivalent_1_N : N ; -- dosekvivalent..nn.1
  dosera_1_V : V ; -- dosera..vb.1
  doserande_1_N : N ; -- doserande..nn.1
  doserbar_1_A : A ; -- doserbar..av.1
  doserbarhet_1_N : N ; -- doserbarhet..nn.1
  dosering_1_N : N ; -- dosering..nn.1
  dosimeter_1_N : N ; -- dosimeter..nn.1
  dosimetri_1_N : N ; -- dosimetri..nn.1
  dosis_1_N : N ; -- dosis..nn.1
  doslibell_1_N : N ; -- doslibell..nn.1
  dosmätare_1_N : N ; -- dosmätare..nn.1
  dossera_1_V : V ; -- dossera..vb.1
  dosserande_1_N : N ; -- dosserande..nn.1
  dosserbar_1_A : A ; -- dosserbar..av.1
  dosserbarhet_1_N : N ; -- dosserbarhet..nn.1
  dossering_1_N : N ; -- dossering..nn.1
  dossier_1_N : N ; -- dossier..nn.1
  dossié_1_N : N ; -- dossié..nn.1
  dotation_1_N : N ; -- dotation..nn.1
  dotera_1_V : V ; -- dotera..vb.1
  doterande_1_N : N ; -- doterande..nn.1
  doterbar_1_A : A ; -- doterbar..av.1
  doterbarhet_1_N : N ; -- doterbarhet..nn.1
  dotering_1_N : N ; -- dotering..nn.1
  dotter_1_N : N ; -- dotter..nn.1
  dotterbarn_1_N : N ; -- dotterbarn..nn.1
  dotterbolag_1_N : N ; -- dotterbolag..nn.1
  dottercell_1_N : N ; -- dottercell..nn.1
  dotterdotter_1_N : N ; -- dotterdotter..nn.1
  dotterföretag_1_N : N ; -- dotterföretag..nn.1
  dotterförsamling_1_N : N ; -- dotterförsamling..nn.1
  dotterlig_1_A : A ; -- dotterlig..av.1
  dotterlighet_1_N : N ; -- dotterlighet..nn.1
  dotterskap_1_N : N ; -- dotterskap..nn.1
  dotterson_1_N : N ; -- dotterson..nn.1
  dotterspråk_1_N : N ; -- dotterspråk..nn.1
  dottersvulst_1_N : N ; -- dottersvulst..nn.1
  dottertumör_1_N : N ; -- dottertumör..nn.1
  doublé_2_N : N ; -- doublé..nn.2
  dov_1_A : A ; -- dov..av.1
  dovhet_1_N : N ; -- dovhet..nn.1
  dovhjort_1_N : N ; -- dovhjort..nn.1
  downperiod_1_N : N ; -- downperiod..nn.1
  doyen_1_N : N ; -- doyen..nn.1
  dra_1_V : V ; -- dra..vb.1
  drabant_1_N : N ; -- drabant..nn.1
  drabantstat_1_N : N ; -- drabantstat..nn.1
  drabba_1_V : V ; -- drabba..vb.1
  drabbande_1_N : N ; -- drabbande..nn.1
  drabbning_1_N : N ; -- drabbning..nn.1
  drachma_1_N : N ; -- drachma..nn.1
  drag_1_N : N ; -- drag..nn.1
  drag_2_N : N ; -- drag..nn.2
  dragande_1_N : N ; -- dragande..nn.1
  dragare_1_N : N ; -- dragare..nn.1
  dragband_1_N : N ; -- dragband..nn.1
  dragbasun_1_N : N ; -- dragbasun..nn.1
  dragbil_1_N : N ; -- dragbil..nn.1
  dragbänk_1_N : N ; -- dragbänk..nn.1
  dragdjur_1_N : N ; -- dragdjur..nn.1
  dragen_1_A : A ; -- dragen..av.1
  dragenhet_1_N : N ; -- dragenhet..nn.1
  dragenhet_2_N : N ; -- dragenhet..nn.2
  dragera_1_V : V ; -- dragera..vb.1
  dragerande_1_N : N ; -- dragerande..nn.1
  dragerbar_1_A : A ; -- dragerbar..av.1
  dragerbarhet_1_N : N ; -- dragerbarhet..nn.1
  dragering_1_N : N ; -- dragering..nn.1
  dragfri_1_A : A ; -- dragfri..av.1
  dragg_1_N : N ; -- dragg..nn.1
  dragga_1_V : V ; -- dragga..vb.1
  draggande_1_N : N ; -- draggande..nn.1
  dragglina_1_N : N ; -- dragglina..nn.1
  draggning_1_N : N ; -- draggning..nn.1
  dragharmonika_1_N : N ; -- dragharmonika..nn.1
  draghjälp_1_N : N ; -- draghjälp..nn.1
  draghäst_1_N : N ; -- draghäst..nn.1
  draghållfasthet_1_N : N ; -- draghållfasthet..nn.1
  dragig_1_A : A ; -- dragig..av.1
  dragkamp_1_N : N ; -- dragkamp..nn.1
  dragkedja_1_N : N ; -- dragkedja..nn.1
  dragkista_1_N : N ; -- dragkista..nn.1
  dragkraft_1_N : N ; -- dragkraft..nn.1
  dragkrok_1_N : N ; -- dragkrok..nn.1
  dragkärra_1_N : N ; -- dragkärra..nn.1
  draglapp_1_N : N ; -- draglapp..nn.1
  draglina_1_N : N ; -- draglina..nn.1
  draglucka_1_N : N ; -- draglucka..nn.1
  dragläge_1_N : N ; -- dragläge..nn.1
  dragnagel_1_N : N ; -- dragnagel..nn.1
  dragning_1_N : N ; -- dragning..nn.1
  dragningskraft_1_N : N ; -- dragningskraft..nn.1
  dragningslista_1_N : N ; -- dragningslista..nn.1
  dragnät_1_N : N ; -- dragnät..nn.1
  dragoman_1_N : N ; -- dragoman..nn.1
  dragon_1_N : N ; -- dragon..nn.1
  dragplåster_1_N : N ; -- dragplåster..nn.1
  dragpress_1_N : N ; -- dragpress..nn.1
  dragpressning_1_N : N ; -- dragpressning..nn.1
  dragprov_1_N : N ; -- dragprov..nn.1
  dragracing_1_N : N ; -- dragracing..nn.1
  dragrem_1_N : N ; -- dragrem..nn.1
  dragrep_1_N : N ; -- dragrep..nn.1
  dragshow_1_N : N ; -- dragshow..nn.1
  dragskiva_1_N : N ; -- dragskiva..nn.1
  dragsko_1_N : N ; -- dragsko..nn.1
  dragskåp_1_N : N ; -- dragskåp..nn.1
  dragsnöre_1_N : N ; -- dragsnöre..nn.1
  dragspel_1_N : N ; -- dragspel..nn.1
  dragspelsmusik_1_N : N ; -- dragspelsmusik..nn.1
  dragstift_1_N : N ; -- dragstift..nn.1
  dragstyrka_1_N : N ; -- dragstyrka..nn.1
  dragstång_1_N : N ; -- dragstång..nn.1
  dragupprepning_1_N : N ; -- dragupprepning..nn.1
  dragväg_1_N : N ; -- dragväg..nn.1
  dragé_1_N : N ; -- dragé..nn.1
  draja_1_N : N ; -- draja..nn.1
  drakblod_1_N : N ; -- drakblod..nn.1
  drakblodsträd_1_N : N ; -- drakblodsträd..nn.1
  drake_1_N : N ; -- drake..nn.1
  drakflygare_1_N : N ; -- drakflygare..nn.1
  drakhuvudfisk_1_N : N ; -- drakhuvudfisk..nn.1
  drakma_1_N : N ; -- drakma..nn.1
  drakonisk_1_A : A ; -- drakonisk..av.1
  drakskepp_1_N : N ; -- drakskepp..nn.1
  drakslinga_1_N : N ; -- drakslinga..nn.1
  drakstjärt_1_N : N ; -- drakstjärt..nn.1
  draksådd_1_N : N ; -- draksådd..nn.1
  draködla_1_N : N ; -- draködla..nn.1
  dram_1_N : N ; -- dram..nn.1
  drama_1_N : N ; -- drama..nn.1
  dramakonst_1_N : N ; -- dramakonst..nn.1
  dramaten_1_N : N ; -- dramaten..nn.1
  dramatik_1_N : N ; -- dramatik..nn.1
  dramatiker_1_N : N ; -- dramatiker..nn.1
  dramatisera_1_V : V ; -- dramatisera..vb.1
  dramatiserande_1_N : N ; -- dramatiserande..nn.1
  dramatiserbar_1_A : A ; -- dramatiserbar..av.1
  dramatiserbarhet_1_N : N ; -- dramatiserbarhet..nn.1
  dramatisering_1_N : N ; -- dramatisering..nn.1
  dramatisk_1_A : A ; -- dramatisk..av.1
  dramaturg_1_N : N ; -- dramaturg..nn.1
  dramaturgi_1_N : N ; -- dramaturgi..nn.1
  dramaturgisk_1_A : A ; -- dramaturgisk..av.1
  drank_1_N : N ; -- drank..nn.1
  drapa_1_N : N ; -- drapa..nn.1
  drapera_1_V : V ; -- drapera..vb.1
  draperande_1_N : N ; -- draperande..nn.1
  draperbar_1_A : A ; -- draperbar..av.1
  draperbarhet_1_N : N ; -- draperbarhet..nn.1
  draperi_1_N : N ; -- draperi..nn.1
  drapering_1_N : N ; -- drapering..nn.1
  drastisk_1_A : A ; -- drastisk..av.1
  drasut_1_N : N ; -- drasut..nn.1
  dratta_1_V : V ; -- dratta..vb.1
  drattande_1_N : N ; -- drattande..nn.1
  drav_1_N : N ; -- drav..nn.1
  dravel_1_N : N ; -- dravel..nn.1
  dravid_1_N : N ; -- dravid..nn.1
  dravidfolk_1_N : N ; -- dravidfolk..nn.1
  dravidisk_1_A : A ; -- dravidisk..av.1
  dravla_1_V : V ; -- dravla..vb.1
  dravlande_1_N : N ; -- dravlande..nn.1
  dregel_1_N : N ; -- dregel..nn.1
  dregla_1_V : V ; -- dregla..vb.1
  dreglande_1_N : N ; -- dreglande..nn.1
  dreja_1_V : V ; -- dreja..vb.1
  drejande_1_N : N ; -- drejande..nn.1
  drejskiva_1_N : N ; -- drejskiva..nn.1
  drejvända_1_V : V ; -- drejvända..vb.1
  drejvändande_1_N : N ; -- drejvändande..nn.1
  dress_1_N : N ; -- dress..nn.1
  dressera_1_V : V ; -- dressera..vb.1
  dresserande_1_N : N ; -- dresserande..nn.1
  dresserbar_1_A : A ; -- dresserbar..av.1
  dresserbarhet_1_N : N ; -- dresserbarhet..nn.1
  dressering_1_N : N ; -- dressering..nn.1
  dressin_1_N : N ; -- dressin..nn.1
  dressing_1_N : N ; -- dressing..nn.1
  dressyr_1_N : N ; -- dressyr..nn.1
  dressyrridning_1_N : N ; -- dressyrridning..nn.1
  dressör_1_N : N ; -- dressör..nn.1
  drev_1_N : N ; -- drev..nn.1
  drev_2_N : N ; -- drev..nn.2
  dreva_1_V : V ; -- dreva..vb.1
  drevande_1_N : N ; -- drevande..nn.1
  drever_1_N : N ; -- drever..nn.1
  drevhund_1_N : N ; -- drevhund..nn.1
  drevjakt_1_N : N ; -- drevjakt..nn.1
  drevkarl_1_N : N ; -- drevkarl..nn.1
  drevkedja_1_N : N ; -- drevkedja..nn.1
  drevning_1_N : N ; -- drevning..nn.1
  dribbla_1_V : V ; -- dribbla..vb.1
  dribblande_1_N : N ; -- dribblande..nn.1
  dribbler_1_N : N ; -- dribbler..nn.1
  dribbling_1_N : N ; -- dribbling..nn.1
  dricka_2_N : N ; -- dricka..nn.2
  dricka_1_V : V ; -- dricka..vb.1
  drickande_1_N : N ; -- drickande..nn.1
  drickankare_1_N : N ; -- drickankare..nn.1
  drickbar_1_A : A ; -- drickbar..av.1
  drickbarhet_1_N : N ; -- drickbarhet..nn.1
  drickning_1_N : N ; -- drickning..nn.1
  dricks_1_N : N ; -- dricks..nn.1
  dricksglas_1_N : N ; -- dricksglas..nn.1
  drickspeng_1_N : N ; -- drickspeng..nn.1
  dricksvatten_1_N : N ; -- dricksvatten..nn.1
  drift_1_N : N ; -- drift..nn.1
  drift_2_N : N ; -- drift..nn.2
  drifta_1_V : V ; -- drifta..vb.1
  driftande_1_N : N ; -- driftande..nn.1
  driftbudget_1_N : N ; -- driftbudget..nn.1
  driftfel_1_N : N ; -- driftfel..nn.1
  driftig_1_A : A ; -- driftig..av.1
  driftighet_1_N : N ; -- driftighet..nn.1
  driftkapital_1_N : N ; -- driftkapital..nn.1
  driftkostnad_1_N : N ; -- driftkostnad..nn.1
  driftkucku_1_N : N ; -- driftkucku..nn.1
  driftliv_1_N : N ; -- driftliv..nn.1
  driftmässig_1_A : A ; -- driftmässig..av.1
  driftning_1_N : N ; -- driftning..nn.1
  driftskostnad_1_N : N ; -- driftskostnad..nn.1
  driftsmässig_1_A : A ; -- driftsmässig..av.1
  driftsstöd_1_N : N ; -- driftsstöd..nn.1
  driftstillestånd_1_N : N ; -- driftstillestånd..nn.1
  driftstillstånd_1_N : N ; -- driftstillstånd..nn.1
  driftstopp_1_N : N ; -- driftstopp..nn.1
  driftsäker_1_A : A ; -- driftsäker..av.1
  driftsäkerhet_1_N : N ; -- driftsäkerhet..nn.1
  driftsäkerhetsmässig_1_A : A ; -- driftsäkerhetsmässig..av.1
  drifttid_1_N : N ; -- drifttid..nn.1
  drifttillgänglighet_1_N : N ; -- drifttillgänglighet..nn.1
  driftvärn_1_N : N ; -- driftvärn..nn.1
  drill_1_N : N ; -- drill..nn.1
  drilla_1_V : V ; -- drilla..vb.1
  drillande_1_N : N ; -- drillande..nn.1
  drillborr_1_N : N ; -- drillborr..nn.1
  drillflicka_1_N : N ; -- drillflicka..nn.1
  drilling_1_N : N ; -- drilling..nn.1
  drillprogram_1_N : N ; -- drillprogram..nn.1
  drillsnäppa_1_N : N ; -- drillsnäppa..nn.1
  drillstav_1_N : N ; -- drillstav..nn.1
  drink_1_N : N ; -- drink..nn.1
  drinkare_1_N : N ; -- drinkare..nn.1
  dristig_1_A : A ; -- dristig..av.1
  dristighet_1_N : N ; -- dristighet..nn.1
  drittel_1_N : N ; -- drittel..nn.1
  driv_1_N : N ; -- driv..nn.1
  driv_2_N : N ; -- driv..nn.2
  driva_1_N : N ; -- driva..nn.1
  driva_1_V : V ; -- driva..vb.1
  driva_2_V : V ; -- driva..vb.2
  drivande_1_A : A ; -- drivande..av.1
  drivande_1_N : N ; -- drivande..nn.1
  drivankare_1_N : N ; -- drivankare..nn.1
  drivaxel_1_N : N ; -- drivaxel..nn.1
  drivband_1_N : N ; -- drivband..nn.1
  drivbänk_1_N : N ; -- drivbänk..nn.1
  drive_1_N : N ; -- drive..nn.1
  driven_1_A : A ; -- driven..av.1
  drivenhet_1_N : N ; -- drivenhet..nn.1
  driveri_1_N : N ; -- driveri..nn.1
  drivfjäder_1_N : N ; -- drivfjäder..nn.1
  drivflykt_1_N : N ; -- drivflykt..nn.1
  drivgarn_1_N : N ; -- drivgarn..nn.1
  drivhjul_1_N : N ; -- drivhjul..nn.1
  drivhus_1_N : N ; -- drivhus..nn.1
  drivhuseffekt_1_N : N ; -- drivhuseffekt..nn.1
  drivhusklimat_1_N : N ; -- drivhusklimat..nn.1
  drivhusplanta_1_N : N ; -- drivhusplanta..nn.1
  drivis_1_N : N ; -- drivis..nn.1
  drivkedja_1_N : N ; -- drivkedja..nn.1
  drivkraft_1_N : N ; -- drivkraft..nn.1
  drivlina_1_N : N ; -- drivlina..nn.1
  drivmedel_1_N : N ; -- drivmedel..nn.1
  drivmedelsbehov_1_N : N ; -- drivmedelsbehov..nn.1
  drivning_1_N : N ; -- drivning..nn.1
  drivrem_1_N : N ; -- drivrem..nn.1
  drivsand_1_N : N ; -- drivsand..nn.1
  drivsnö_1_N : N ; -- drivsnö..nn.1
  drivved_1_N : N ; -- drivved..nn.1
  drivverk_1_N : N ; -- drivverk..nn.1
  drog_1_N : N ; -- drog..nn.1
  droga_1_V : V ; -- droga..vb.1
  drogande_1_N : N ; -- drogande..nn.1
  drogberoende_1_N : N ; -- drogberoende..nn.1
  drogeffekt_1_N : N ; -- drogeffekt..nn.1
  drogeri_1_N : N ; -- drogeri..nn.1
  drogfri_1_A : A ; -- drogfri..av.1
  droghandel_1_N : N ; -- droghandel..nn.1
  droghandlare_1_N : N ; -- droghandlare..nn.1
  drogliberal_1_A : A ; -- drogliberal..av.1
  drogliberal_1_N : N ; -- drogliberal..nn.1
  drogliberalism_1_N : N ; -- drogliberalism..nn.1
  drogmissbruk_1_N : N ; -- drogmissbruk..nn.1
  drogmissbrukande_1_A : A ; -- drogmissbrukande..av.1
  drogmissbrukare_1_N : N ; -- drogmissbrukare..nn.1
  drogmyt_1_N : N ; -- drogmyt..nn.1
  drogpolicy_1_N : N ; -- drogpolicy..nn.1
  drogpåverkad_1_A : A ; -- drogpåverkad..av.1
  drogrelaterad_1_A : A ; -- drogrelaterad..av.1
  drogsug_1_N : N ; -- drogsug..nn.1
  drogtest_1_N : N ; -- drogtest..nn.1
  drogtesta_1_V : V ; -- drogtesta..vb.1
  drogtestande_1_N : N ; -- drogtestande..nn.1
  drogtestning_1_N : N ; -- drogtestning..nn.1
  drogvana_1_N : N ; -- drogvana..nn.1
  dromedar_1_N : N ; -- dromedar..nn.1
  dront_1_N : N ; -- dront..nn.1
  drop_in_1_N : N ; -- drop-in..nn.1
  dropin_1_N : N ; -- dropin..nn.1
  dropp_1_N : N ; -- dropp..nn.1
  droppa_1_V : V ; -- droppa..vb.1
  droppa_2_V : V ; -- droppa..vb.2
  droppande_1_N : N ; -- droppande..nn.1
  droppe_1_N : N ; -- droppe..nn.1
  droppflaska_1_N : N ; -- droppflaska..nn.1
  droppfri_1_A : A ; -- droppfri..av.1
  droppglas_1_N : N ; -- droppglas..nn.1
  droppinfektion_1_N : N ; -- droppinfektion..nn.1
  droppkork_1_N : N ; -- droppkork..nn.1
  droppnäsa_1_N : N ; -- droppnäsa..nn.1
  droppspets_1_N : N ; -- droppspets..nn.1
  droppsten_1_N : N ; -- droppsten..nn.1
  droppstensgrotta_1_N : N ; -- droppstensgrotta..nn.1
  droppstilla_1_Adv : Adv ; -- droppstilla..ab.1
  droppvis_1_Adv : Adv ; -- droppvis..ab.1
  droska_1_N : N ; -- droska..nn.1
  droskbil_1_N : N ; -- droskbil..nn.1
  droskförare_1_N : N ; -- droskförare..nn.1
  drossel_1_N : N ; -- drossel..nn.1
  drots_1_N : N ; -- drots..nn.1
  drott_1_N : N ; -- drott..nn.1
  drottkväde_1_N : N ; -- drottkväde..nn.1
  drottning_1_N : N ; -- drottning..nn.1
  drottningbesatt_1_A : A ; -- drottningbesatt..av.1
  drottningkrona_1_N : N ; -- drottningkrona..nn.1
  drottninglik_1_A : A ; -- drottninglik..av.1
  drottningsylt_1_N : N ; -- drottningsylt..nn.1
  drucken_1_A : A ; -- drucken..av.1
  druckenhet_1_N : N ; -- druckenhet..nn.1
  drufs_1_N : N ; -- drufs..nn.1
  druid_1_N : N ; -- druid..nn.1
  druidisk_1_A : A ; -- druidisk..av.1
  druidkult_1_N : N ; -- druidkult..nn.1
  drul_1_N : N ; -- drul..nn.1
  drulig_1_A : A ; -- drulig..av.1
  drulla_1_V : V ; -- drulla..vb.1
  drullande_1_N : N ; -- drullande..nn.1
  drulle_1_N : N ; -- drulle..nn.1
  drulleförsäkring_1_N : N ; -- drulleförsäkring..nn.1
  drullig_1_A : A ; -- drullig..av.1
  drullighet_1_N : N ; -- drullighet..nn.1
  drullputt_1_N : N ; -- drullputt..nn.1
  drumla_1_V : V ; -- drumla..vb.1
  drumlande_1_N : N ; -- drumlande..nn.1
  drumlig_1_A : A ; -- drumlig..av.1
  drumlighet_1_N : N ; -- drumlighet..nn.1
  drummel_1_N : N ; -- drummel..nn.1
  drummelaktig_1_A : A ; -- drummelaktig..av.1
  drummelaktighet_1_N : N ; -- drummelaktighet..nn.1
  drunkna_1_V : V ; -- drunkna..vb.1
  drunknande_1_N : N ; -- drunknande..nn.1
  drunkning_1_N : N ; -- drunkning..nn.1
  drunkningsdöd_1_N : N ; -- drunkningsdöd..nn.1
  drunkningsmetafor_1_N : N ; -- drunkningsmetafor..nn.1
  drunkningsolycka_1_N : N ; -- drunkningsolycka..nn.1
  drunkningsår_1_N : N ; -- drunkningsår..nn.1
  drus_1_N : N ; -- drus..nn.1
  druva_1_N : N ; -- druva..nn.1
  druvblå_1_A : A ; -- druvblå..av.1
  druvbörd_1_N : N ; -- druvbörd..nn.1
  druvfläder_1_N : N ; -- druvfläder..nn.1
  druvgurka_1_N : N ; -- druvgurka..nn.1
  druvhagel_1_N : N ; -- druvhagel..nn.1
  druvklase_1_N : N ; -- druvklase..nn.1
  druvrussin_1_N : N ; -- druvrussin..nn.1
  druvsaft_1_N : N ; -- druvsaft..nn.1
  druvsocker_1_N : N ; -- druvsocker..nn.1
  dryad_1_N : N ; -- dryad..nn.1
  dryck_1_N : N ; -- dryck..nn.1
  dryck_2_N : N ; -- dryck..nn.2
  dryckenskap_1_N : N ; -- dryckenskap..nn.1
  dryckesbroder_1_N : N ; -- dryckesbroder..nn.1
  dryckesbägare_1_N : N ; -- dryckesbägare..nn.1
  dryckesfråga_1_N : N ; -- dryckesfråga..nn.1
  dryckesgille_1_N : N ; -- dryckesgille..nn.1
  dryckeshorn_1_N : N ; -- dryckeshorn..nn.1
  dryckeskärl_1_N : N ; -- dryckeskärl..nn.1
  dryckeslag_1_N : N ; -- dryckeslag..nn.1
  dryckesoffer_1_N : N ; -- dryckesoffer..nn.1
  dryckesorgie_1_N : N ; -- dryckesorgie..nn.1
  dryckesservis_1_N : N ; -- dryckesservis..nn.1
  dryckesvana_1_N : N ; -- dryckesvana..nn.1
  dryckesvisa_1_N : N ; -- dryckesvisa..nn.1
  dryckjom_1_N : N ; -- dryckjom..nn.1
  dryfta_1_V : V ; -- dryfta..vb.1
  dryftande_1_N : N ; -- dryftande..nn.1
  dryftning_1_N : N ; -- dryftning..nn.1
  dryg_1_A : A ; -- dryg..av.1
  dryghet_1_N : N ; -- dryghet..nn.1
  drygsel_1_N : N ; -- drygsel..nn.1
  drypa_1_V : V ; -- drypa..vb.1
  drypande_1_N : N ; -- drypande..nn.1
  drypning_1_N : N ; -- drypning..nn.1
  drägel_1_N : N ; -- drägel..nn.1
  drägg_1_N : N ; -- drägg..nn.1
  drägla_1_V : V ; -- drägla..vb.1
  dräglande_1_N : N ; -- dräglande..nn.1
  dräglig_1_A : A ; -- dräglig..av.1
  dräglighet_1_N : N ; -- dräglighet..nn.1
  dräkt_1_N : N ; -- dräkt..nn.1
  dräktig_1_A : A ; -- dräktig..av.1
  dräktighet_1_N : N ; -- dräktighet..nn.1
  dräktskick_1_N : N ; -- dräktskick..nn.1
  dräktspänne_1_N : N ; -- dräktspänne..nn.1
  dräll_1_N : N ; -- dräll..nn.1
  drälla_1_V : V ; -- drälla..vb.1
  drällande_1_N : N ; -- drällande..nn.1
  drämma_1_V : V ; -- drämma..vb.1
  drämmande_1_N : N ; -- drämmande..nn.1
  drän_1_N : N ; -- drän..nn.1
  dränage_1_N : N ; -- dränage..nn.1
  dränera_1_V : V ; -- dränera..vb.1
  dränerande_1_N : N ; -- dränerande..nn.1
  dränerbar_1_A : A ; -- dränerbar..av.1
  dränerbarhet_1_N : N ; -- dränerbarhet..nn.1
  dränering_1_N : N ; -- dränering..nn.1
  dräneringsdike_1_N : N ; -- dräneringsdike..nn.1
  dräneringsområde_1_N : N ; -- dräneringsområde..nn.1
  dräneringsrör_1_N : N ; -- dräneringsrör..nn.1
  dräng_1_N : N ; -- dräng..nn.1
  drängtjänst_1_N : N ; -- drängtjänst..nn.1
  dränka_1_V : V ; -- dränka..vb.1
  dränkande_1_N : N ; -- dränkande..nn.1
  dränkbar_1_A : A ; -- dränkbar..av.1
  dränkbarhet_1_N : N ; -- dränkbarhet..nn.1
  dränkning_1_N : N ; -- dränkning..nn.1
  dräpa_1_V : V ; -- dräpa..vb.1
  dräpande_1_A : A ; -- dräpande..av.1
  dräpande_1_N : N ; -- dräpande..nn.1
  drätsel_1_N : N ; -- drätsel..nn.1
  drätselkammare_1_N : N ; -- drätselkammare..nn.1
  drätselnämnd_1_N : N ; -- drätselnämnd..nn.1
  drätt_1_N : N ; -- drätt..nn.1
  dråp_1_N : N ; -- dråp..nn.1
  dråpare_1_N : N ; -- dråpare..nn.1
  dråplig_1_A : A ; -- dråplig..av.1
  dråplighet_1_N : N ; -- dråplighet..nn.1
  dråprättegång_1_N : N ; -- dråprättegång..nn.1
  dråpslag_1_N : N ; -- dråpslag..nn.1
  dråsa_1_V : V ; -- dråsa..vb.1
  dråsande_1_N : N ; -- dråsande..nn.1
  dråse_1_N : N ; -- dråse..nn.1
  drög_1_N : N ; -- drög..nn.1
  dröglapp_1_N : N ; -- dröglapp..nn.1
  dröja_1_V : V ; -- dröja..vb.1
  dröjande_1_N : N ; -- dröjande..nn.1
  dröjsmål_1_N : N ; -- dröjsmål..nn.1
  dröjsmålsränta_1_N : N ; -- dröjsmålsränta..nn.1
  dröm_1_N : N ; -- dröm..nn.1
  drömbild_1_N : N ; -- drömbild..nn.1
  drömbok_1_N : N ; -- drömbok..nn.1
  drömdejt_1_N : N ; -- drömdejt..nn.1
  drömgräns_1_N : N ; -- drömgräns..nn.1
  drömkandidat_1_N : N ; -- drömkandidat..nn.1
  drömlandskap_1_N : N ; -- drömlandskap..nn.1
  drömlik_1_A : A ; -- drömlik..av.1
  drömlikhet_1_N : N ; -- drömlikhet..nn.1
  drömliknande_1_A : A ; -- drömliknande..av.1
  drömliv_1_N : N ; -- drömliv..nn.1
  drömlön_1_N : N ; -- drömlön..nn.1
  drömma_1_V : V ; -- drömma..vb.1
  drömmande_1_N : N ; -- drömmande..nn.1
  drömmare_1_N : N ; -- drömmare..nn.1
  drömmeri_1_N : N ; -- drömmeri..nn.1
  drömmil_1_N : N ; -- drömmil..nn.1
  drömmål_1_N : N ; -- drömmål..nn.1
  drömresa_1_N : N ; -- drömresa..nn.1
  drömrumpa_1_N : N ; -- drömrumpa..nn.1
  drömsk_1_A : A ; -- drömsk..av.1
  drömskapelse_1_N : N ; -- drömskapelse..nn.1
  drömskhet_1_N : N ; -- drömskhet..nn.1
  drömslott_1_N : N ; -- drömslott..nn.1
  drömstart_1_N : N ; -- drömstart..nn.1
  drömsyn_1_N : N ; -- drömsyn..nn.1
  drömsällskap_1_N : N ; -- drömsällskap..nn.1
  drömsömn_1_N : N ; -- drömsömn..nn.1
  drömtydande_1_N : N ; -- drömtydande..nn.1
  drömtydare_1_N : N ; -- drömtydare..nn.1
  drömtydning_1_N : N ; -- drömtydning..nn.1
  drömtydningsbok_1_N : N ; -- drömtydningsbok..nn.1
  drömvärld_1_N : N ; -- drömvärld..nn.1
  dröna_1_V : V ; -- dröna..vb.1
  drönande_1_N : N ; -- drönande..nn.1
  drönarattack_1_N : N ; -- drönarattack..nn.1
  drönarbas_1_N : N ; -- drönarbas..nn.1
  drönare_1_N : N ; -- drönare..nn.1
  drönarförespråkare_1_N : N ; -- drönarförespråkare..nn.1
  drönarliv_1_N : N ; -- drönarliv..nn.1
  drönarräd_1_N : N ; -- drönarräd..nn.1
  dröppel_1_N : N ; -- dröppel..nn.1
  drösa_1_V : V ; -- drösa..vb.1
  drösande_1_N : N ; -- drösande..nn.1
  dröse_1_N : N ; -- dröse..nn.1
  drösvis_1_Adv : Adv ; -- drösvis..ab.1
  dua_1_V : V ; -- dua..vb.1
  dual_1_N : N ; -- dual..nn.1
  dualform_1_N : N ; -- dualform..nn.1
  dualis_1_N : N ; -- dualis..nn.1
  dualism_1_N : N ; -- dualism..nn.1
  dualist_1_N : N ; -- dualist..nn.1
  dualistisk_1_A : A ; -- dualistisk..av.1
  duande_1_N : N ; -- duande..nn.1
  dubb_1_N : N ; -- dubb..nn.1
  dubba_1_V : V ; -- dubba..vb.1
  dubbande_1_N : N ; -- dubbande..nn.1
  dubbdocka_1_N : N ; -- dubbdocka..nn.1
  dubbdäck_1_N : N ; -- dubbdäck..nn.1
  dubbdäcksförbud_1_N : N ; -- dubbdäcksförbud..nn.1
  dubbel_1_A : A ; -- dubbel..av.1
  dubbel_1_N : N ; -- dubbel..nn.1
  dubbelagent_1_N : N ; -- dubbelagent..nn.1
  dubbelansikte_1_N : N ; -- dubbelansikte..nn.1
  dubbelarbetande_1_A : A ; -- dubbelarbetande..av.1
  dubbelbeckasin_1_N : N ; -- dubbelbeckasin..nn.1
  dubbelbeskatta_1_V : V ; -- dubbelbeskatta..vb.1
  dubbelbeskattande_1_N : N ; -- dubbelbeskattande..nn.1
  dubbelbiff_1_N : N ; -- dubbelbiff..nn.1
  dubbelbindning_1_N : N ; -- dubbelbindning..nn.1
  dubbelbluff_1_N : N ; -- dubbelbluff..nn.1
  dubbelbotten_1_N : N ; -- dubbelbotten..nn.1
  dubbelbottnad_1_A : A ; -- dubbelbottnad..av.1
  dubbelbredd_1_N : N ; -- dubbelbredd..nn.1
  dubbelbrytning_1_N : N ; -- dubbelbrytning..nn.1
  dubbelbröllop_1_N : N ; -- dubbelbröllop..nn.1
  dubbelbössa_1_N : N ; -- dubbelbössa..nn.1
  dubbeldäckare_1_N : N ; -- dubbeldäckare..nn.1
  dubbeldörr_1_N : N ; -- dubbeldörr..nn.1
  dubbelexponera_1_V : V ; -- dubbelexponera..vb.1
  dubbelexponerande_1_N : N ; -- dubbelexponerande..nn.1
  dubbelexponerbar_1_A : A ; -- dubbelexponerbar..av.1
  dubbelexponerbarhet_1_N : N ; -- dubbelexponerbarhet..nn.1
  dubbelexponering_1_N : N ; -- dubbelexponering..nn.1
  dubbelfel_1_N : N ; -- dubbelfel..nn.1
  dubbelfönster_1_N : N ; -- dubbelfönster..nn.1
  dubbelgarage_1_N : N ; -- dubbelgarage..nn.1
  dubbelgrepp_1_N : N ; -- dubbelgrepp..nn.1
  dubbelgångare_1_N : N ; -- dubbelgångare..nn.1
  dubbelhaka_1_N : N ; -- dubbelhaka..nn.1
  dubbelhandsfattning_1_N : N ; -- dubbelhandsfattning..nn.1
  dubbelhet_1_N : N ; -- dubbelhet..nn.1
  dubbelhytt_1_N : N ; -- dubbelhytt..nn.1
  dubbelhäftande_1_A : A ; -- dubbelhäftande..av.1
  dubbelhölster_1_N : N ; -- dubbelhölster..nn.1
  dubbelklick_1_N : N ; -- dubbelklick..nn.1
  dubbelklicka_1_V : V ; -- dubbelklicka..vb.1
  dubbelklickande_1_N : N ; -- dubbelklickande..nn.1
  dubbelklickning_1_N : N ; -- dubbelklickning..nn.1
  dubbelknäppt_1_A : A ; -- dubbelknäppt..av.1
  dubbelkoll_1_N : N ; -- dubbelkoll..nn.1
  dubbelkolla_1_V : V ; -- dubbelkolla..vb.1
  dubbelkollande_1_N : N ; -- dubbelkollande..nn.1
  dubbelkollning_1_N : N ; -- dubbelkollning..nn.1
  dubbelkommando_1_N : N ; -- dubbelkommando..nn.1
  dubbelkontakt_1_N : N ; -- dubbelkontakt..nn.1
  dubbelkvartett_1_N : N ; -- dubbelkvartett..nn.1
  dubbelkör_1_N : N ; -- dubbelkör..nn.1
  dubbelliv_1_N : N ; -- dubbelliv..nn.1
  dubbelmadrass_1_N : N ; -- dubbelmadrass..nn.1
  dubbelmening_1_N : N ; -- dubbelmening..nn.1
  dubbelmoral_1_N : N ; -- dubbelmoral..nn.1
  dubbelmord_1_N : N ; -- dubbelmord..nn.1
  dubbelnamn_1_N : N ; -- dubbelnamn..nn.1
  dubbelnatur_1_N : N ; -- dubbelnatur..nn.1
  dubbelnelson_1_N : N ; -- dubbelnelson..nn.1
  dubbelnöt_1_N : N ; -- dubbelnöt..nn.1
  dubbelpanera_1_V : V ; -- dubbelpanera..vb.1
  dubbelpanerande_1_N : N ; -- dubbelpanerande..nn.1
  dubbelpanering_1_N : N ; -- dubbelpanering..nn.1
  dubbelpipig_1_A : A ; -- dubbelpipig..av.1
  dubbelrevolution_1_N : N ; -- dubbelrevolution..nn.1
  dubbelriktad_1_A : A ; -- dubbelriktad..av.1
  dubbelroll_1_N : N ; -- dubbelroll..nn.1
  dubbelrum_1_N : N ; -- dubbelrum..nn.1
  dubbelrör_1_N : N ; -- dubbelrör..nn.1
  dubbelsalt_1_N : N ; -- dubbelsalt..nn.1
  dubbelseende_1_N : N ; -- dubbelseende..nn.1
  dubbelsidig_1_A : A ; -- dubbelsidig..av.1
  dubbelspel_1_N : N ; -- dubbelspel..nn.1
  dubbelspår_1_N : N ; -- dubbelspår..nn.1
  dubbelspårig_1_A : A ; -- dubbelspårig..av.1
  dubbelspårsutbyggnad_1_N : N ; -- dubbelspårsutbyggnad..nn.1
  dubbelstjärna_1_N : N ; -- dubbelstjärna..nn.1
  dubbelstjärnsystem_1_N : N ; -- dubbelstjärnsystem..nn.1
  dubbelsträngad_1_A : A ; -- dubbelsträngad..av.1
  dubbelsyn_1_N : N ; -- dubbelsyn..nn.1
  dubbelsäkring_1_N : N ; -- dubbelsäkring..nn.1
  dubbelsäng_1_N : N ; -- dubbelsäng..nn.1
  dubbeltimma_1_N : N ; -- dubbeltimma..nn.1
  dubbeltimme_1_N : N ; -- dubbeltimme..nn.1
  dubbeltrast_1_N : N ; -- dubbeltrast..nn.1
  dubbelträff_1_N : N ; -- dubbelträff..nn.1
  dubbeltrådig_1_A : A ; -- dubbeltrådig..av.1
  dubbeltydig_1_A : A ; -- dubbeltydig..av.1
  dubbeltydighet_1_N : N ; -- dubbeltydighet..nn.1
  dubbelverkande_1_A : A ; -- dubbelverkande..av.1
  dubbelvikt_1_A : A ; -- dubbelvikt..av.1
  dubbelörn_1_N : N ; -- dubbelörn..nn.1
  dubbfri_1_A : A ; -- dubbfri..av.1
  dubbförbud_1_N : N ; -- dubbförbud..nn.1
  dubbhöjd_1_N : N ; -- dubbhöjd..nn.1
  dubbla_1_V : V ; -- dubbla..vb.1
  dubblande_1_N : N ; -- dubblande..nn.1
  dubblare_1_N : N ; -- dubblare..nn.1
  dubblera_1_V : V ; -- dubblera..vb.1
  dubblerande_1_N : N ; -- dubblerande..nn.1
  dubblerbar_1_A : A ; -- dubblerbar..av.1
  dubblerbarhet_1_N : N ; -- dubblerbarhet..nn.1
  dubblering_1_N : N ; -- dubblering..nn.1
  dubblett_1_N : N ; -- dubblett..nn.1
  dubblé_2_N : N ; -- dubblé..nn.2
  dubbning_1_N : N ; -- dubbning..nn.1
  dubbslitage_1_N : N ; -- dubbslitage..nn.1
  dubiös_1_A : A ; -- dubiös..av.1
  dublett_1_N : N ; -- dublett..nn.1
  dubror_1_N : N ; -- dubror..nn.1
  duchatel_1_N : N ; -- duchatel..nn.1
  duchesse_1_N : N ; -- duchesse..nn.1
  ducka_1_V : V ; -- ducka..vb.1
  duckande_1_N : N ; -- duckande..nn.1
  duell_1_N : N ; -- duell..nn.1
  duellant_1_N : N ; -- duellant..nn.1
  duellera_1_V : V ; -- duellera..vb.1
  duellerande_1_N : N ; -- duellerande..nn.1
  duellering_1_N : N ; -- duellering..nn.1
  duellväsen_1_N : N ; -- duellväsen..nn.1
  duenna_1_N : N ; -- duenna..nn.1
  duett_1_N : N ; -- duett..nn.1
  duettsång_1_N : N ; -- duettsång..nn.1
  duffel_1_N : N ; -- duffel..nn.1
  duga_1_V : V ; -- duga..vb.1
  dugande_1_A : A ; -- dugande..av.1
  dugande_1_N : N ; -- dugande..nn.1
  dugga_1_V : V ; -- dugga..vb.1
  duggande_1_N : N ; -- duggande..nn.1
  duggregn_1_N : N ; -- duggregn..nn.1
  duggregna_1_V : V ; -- duggregna..vb.1
  duggregnande_1_N : N ; -- duggregnande..nn.1
  duglig_1_A : A ; -- duglig..av.1
  duglighet_1_N : N ; -- duglighet..nn.1
  duk_1_N : N ; -- duk..nn.1
  duka_1_V : V ; -- duka..vb.1
  dukagång_1_N : N ; -- dukagång..nn.1
  dukande_1_N : N ; -- dukande..nn.1
  dukat_1_N : N ; -- dukat..nn.1
  dukning_1_N : N ; -- dukning..nn.1
  dukt_1_N : N ; -- dukt..nn.1
  duktig_1_A : A ; -- duktig..av.1
  duktighet_1_N : N ; -- duktighet..nn.1
  dulcian_1_N : N ; -- dulcian..nn.1
  dum_1_A : A ; -- dum..av.1
  duma_1_N : N ; -- duma..nn.1
  dumbom_1_N : N ; -- dumbom..nn.1
  dumburk_1_N : N ; -- dumburk..nn.1
  dumdristig_1_A : A ; -- dumdristig..av.1
  dumdristighet_1_N : N ; -- dumdristighet..nn.1
  dumdryg_1_A : A ; -- dumdryg..av.1
  dumdryghet_1_N : N ; -- dumdryghet..nn.1
  dumdumkula_1_N : N ; -- dumdumkula..nn.1
  dumhet_1_N : N ; -- dumhet..nn.1
  dumhuvud_1_N : N ; -- dumhuvud..nn.1
  dumkåt_1_A : A ; -- dumkåt..av.1
  dummer_1_N : N ; -- dummer..nn.1
  dummerjöns_1_N : N ; -- dummerjöns..nn.1
  dumming_1_N : N ; -- dumming..nn.1
  dummy_1_N : N ; -- dummy..nn.1
  dumpa_1_V : V ; -- dumpa..vb.1
  dumpande_1_N : N ; -- dumpande..nn.1
  dumper_1_N : N ; -- dumper..nn.1
  dumpning_1_N : N ; -- dumpning..nn.1
  dumskalle_1_N : N ; -- dumskalle..nn.1
  dumskallemajoritet_1_N : N ; -- dumskallemajoritet..nn.1
  dumsnut_1_N : N ; -- dumsnut..nn.1
  dumsnål_1_A : A ; -- dumsnål..av.1
  dumstrut_1_N : N ; -- dumstrut..nn.1
  dun_1_N : N ; -- dun..nn.1
  duna_1_V : V ; -- duna..vb.1
  dunande_1_N : N ; -- dunande..nn.1
  dunboll_1_N : N ; -- dunboll..nn.1
  dunbolster_1_N : N ; -- dunbolster..nn.1
  dunbädd_1_N : N ; -- dunbädd..nn.1
  dunder_1_N : N ; -- dunder..nn.1
  dundergud_1_N : N ; -- dundergud..nn.1
  dunderhonung_1_N : N ; -- dunderhonung..nn.1
  dunderkur_1_N : N ; -- dunderkur..nn.1
  dundermedicin_1_N : N ; -- dundermedicin..nn.1
  dundra_1_V : V ; -- dundra..vb.1
  dundrande_1_N : N ; -- dundrande..nn.1
  dunge_1_N : N ; -- dunge..nn.1
  dunig_1_A : A ; -- dunig..av.1
  dunk_1_N : N ; -- dunk..nn.1
  dunk_2_N : N ; -- dunk..nn.2
  dunka_1_V : V ; -- dunka..vb.1
  dunkande_1_N : N ; -- dunkande..nn.1
  dunkel_1_A : A ; -- dunkel..av.1
  dunkel_1_N : N ; -- dunkel..nn.1
  dunkelblå_1_A : A ; -- dunkelblå..av.1
  dunkelhet_1_N : N ; -- dunkelhet..nn.1
  dunkning_1_N : N ; -- dunkning..nn.1
  dunkudde_1_N : N ; -- dunkudde..nn.1
  dunlätt_1_A : A ; -- dunlätt..av.1
  dunmjuk_1_A : A ; -- dunmjuk..av.1
  duns_1_N : N ; -- duns..nn.1
  dunsa_1_V : V ; -- dunsa..vb.1
  dunsande_1_N : N ; -- dunsande..nn.1
  dunst_1_N : N ; -- dunst..nn.1
  dunsta_1_V : V ; -- dunsta..vb.1
  dunsta_2_V : V ; -- dunsta..vb.2
  dunstande_1_N : N ; -- dunstande..nn.1
  dunstig_1_A : A ; -- dunstig..av.1
  dunstighet_1_N : N ; -- dunstighet..nn.1
  duntäcke_1_N : N ; -- duntäcke..nn.1
  dununge_1_N : N ; -- dununge..nn.1
  duo_1_N : N ; -- duo..nn.1
  duodecimalsystem_1_N : N ; -- duodecimalsystem..nn.1
  duodes_1_N : N ; -- duodes..nn.1
  duodesformat_1_N : N ; -- duodesformat..nn.1
  dupera_1_V : V ; -- dupera..vb.1
  duperande_1_N : N ; -- duperande..nn.1
  duperbar_1_A : A ; -- duperbar..av.1
  duperbarhet_1_N : N ; -- duperbarhet..nn.1
  dupering_1_N : N ; -- dupering..nn.1
  duplett_1_N : N ; -- duplett..nn.1
  duplexfärg_1_N : N ; -- duplexfärg..nn.1
  duplicera_1_V : V ; -- duplicera..vb.1
  duplicerande_1_N : N ; -- duplicerande..nn.1
  duplicerbar_1_A : A ; -- duplicerbar..av.1
  duplicerbarhet_1_N : N ; -- duplicerbarhet..nn.1
  duplicering_1_N : N ; -- duplicering..nn.1
  duplik_1_N : N ; -- duplik..nn.1
  duplikat_1_N : N ; -- duplikat..nn.1
  duplikator_1_N : N ; -- duplikator..nn.1
  dur_1_N : N ; -- dur..nn.1
  durabel_1_A : A ; -- durabel..av.1
  durackord_1_N : N ; -- durackord..nn.1
  duralexglas_1_N : N ; -- duralexglas..nn.1
  duraluminium_1_N : N ; -- duraluminium..nn.1
  durativ_1_A : A ; -- durativ..av.1
  dureform_1_N : N ; -- dureform..nn.1
  durk_1_N : N ; -- durk..nn.1
  durka_1_V : V ; -- durka..vb.1
  durkande_1_N : N ; -- durkande..nn.1
  durkdriven_1_A : A ; -- durkdriven..av.1
  durkmönster_1_N : N ; -- durkmönster..nn.1
  durkslag_1_N : N ; -- durkslag..nn.1
  duroplast_1_N : N ; -- duroplast..nn.1
  durra_1_N : N ; -- durra..nn.1
  durskala_1_N : N ; -- durskala..nn.1
  durtonart_1_N : N ; -- durtonart..nn.1
  durumvete_1_N : N ; -- durumvete..nn.1
  dus_1_N : N ; -- dus..nn.1
  dusch_1_N : N ; -- dusch..nn.1
  duscha_1_V : V ; -- duscha..vb.1
  duschande_1_N : N ; -- duschande..nn.1
  duschbrunn_1_N : N ; -- duschbrunn..nn.1
  duschdraperi_1_N : N ; -- duschdraperi..nn.1
  duschhandduk_1_N : N ; -- duschhandduk..nn.1
  duschhandtag_1_N : N ; -- duschhandtag..nn.1
  duschkräm_1_N : N ; -- duschkräm..nn.1
  duschslang_1_N : N ; -- duschslang..nn.1
  duschvana_1_N : N ; -- duschvana..nn.1
  duschvägg_1_N : N ; -- duschvägg..nn.1
  dusk_1_N : N ; -- dusk..nn.1
  duska_1_V : V ; -- duska..vb.1
  duskande_1_N : N ; -- duskande..nn.1
  duskål_1_N : N ; -- duskål..nn.1
  dussin_1_N : N ; -- dussin..nn.1
  dussinarbete_1_N : N ; -- dussinarbete..nn.1
  dussinmänniska_1_N : N ; -- dussinmänniska..nn.1
  dussinroman_1_N : N ; -- dussinroman..nn.1
  dussintal_1_N : N ; -- dussintal..nn.1
  dussinvara_1_N : N ; -- dussinvara..nn.1
  dussinvis_1_Adv : Adv ; -- dussinvis..ab.1
  dust_1_N : N ; -- dust..nn.1
  dusör_1_N : N ; -- dusör..nn.1
  duva_1_N : N ; -- duva..nn.1
  duva_1_V : V ; -- duva..vb.1
  duvande_1_N : N ; -- duvande..nn.1
  duvblå_1_A : A ; -- duvblå..av.1
  duven_1_A : A ; -- duven..av.1
  duvenhet_1_N : N ; -- duvenhet..nn.1
  duvfågel_1_N : N ; -- duvfågel..nn.1
  duvhök_1_N : N ; -- duvhök..nn.1
  duvjävel_1_N : N ; -- duvjävel..nn.1
  duvkulla_1_N : N ; -- duvkulla..nn.1
  duvna_1_V : V ; -- duvna..vb.1
  duvnande_1_N : N ; -- duvnande..nn.1
  duvning_1_N : N ; -- duvning..nn.1
  duvpolitik_1_N : N ; -- duvpolitik..nn.1
  duvpost_1_N : N ; -- duvpost..nn.1
  duvslag_1_N : N ; -- duvslag..nn.1
  duvunge_1_N : N ; -- duvunge..nn.1
  dvala_1_N : N ; -- dvala..nn.1
  dvallik_1_A : A ; -- dvallik..av.1
  dvd_film_1_N : N ; -- dvd-film..nn.1
  dvd_rom_1_N : N ; -- dvd-rom..nn.1
  dvd_spelare_1_N : N ; -- dvd-spelare..nn.1
  dvärg_1_N : N ; -- dvärg..nn.1
  dvärgaktig_1_A : A ; -- dvärgaktig..av.1
  dvärgaktighet_1_N : N ; -- dvärgaktighet..nn.1
  dvärgalåt_1_N : N ; -- dvärgalåt..nn.1
  dvärgartad_1_A : A ; -- dvärgartad..av.1
  dvärgbeckasin_1_N : N ; -- dvärgbeckasin..nn.1
  dvärgbjörk_1_N : N ; -- dvärgbjörk..nn.1
  dvärgbrytare_1_N : N ; -- dvärgbrytare..nn.1
  dvärgbuske_1_N : N ; -- dvärgbuske..nn.1
  dvärggalax_1_N : N ; -- dvärggalax..nn.1
  dvärghamster_1_N : N ; -- dvärghamster..nn.1
  dvärghund_1_N : N ; -- dvärghund..nn.1
  dvärglik_1_A : A ; -- dvärglik..av.1
  dvärgmås_1_N : N ; -- dvärgmås..nn.1
  dvärgschimpans_1_N : N ; -- dvärgschimpans..nn.1
  dvärgtall_1_N : N ; -- dvärgtall..nn.1
  dvärgväxt_1_N : N ; -- dvärgväxt..nn.1
  dyblad_1_N : N ; -- dyblad..nn.1
  dyblöt_1_A : A ; -- dyblöt..av.1
  dyblöthet_1_N : N ; -- dyblöthet..nn.1
  dyborre_1_N : N ; -- dyborre..nn.1
  dybotten_1_N : N ; -- dybotten..nn.1
  dyckert_1_N : N ; -- dyckert..nn.1
  dygd_1_N : N ; -- dygd..nn.1
  dygdemönster_1_N : N ; -- dygdemönster..nn.1
  dygderik_1_A : A ; -- dygderik..av.1
  dygdig_1_A : A ; -- dygdig..av.1
  dygdighet_1_N : N ; -- dygdighet..nn.1
  dygn_1_N : N ; -- dygn..nn.1
  dygnetruntöppen_1_A : A ; -- dygnetruntöppen..av.1
  dygnslång_1_A : A ; -- dygnslång..av.1
  dygnsring_1_N : N ; -- dygnsring..nn.1
  dygnsrytm_1_N : N ; -- dygnsrytm..nn.1
  dygnsvila_1_N : N ; -- dygnsvila..nn.1
  dygnsvill_1_A : A ; -- dygnsvill..av.1
  dygnsvillhet_1_N : N ; -- dygnsvillhet..nn.1
  dygnsvis_1_Adv : Adv ; -- dygnsvis..ab.1
  dygnsvis_1_A : A ; -- dygnsvis..av.1
  dyig_1_A : A ; -- dyig..av.1
  dyighet_1_N : N ; -- dyighet..nn.1
  dyka_1_V : V ; -- dyka..vb.1
  dykand_1_N : N ; -- dykand..nn.1
  dykande_1_N : N ; -- dykande..nn.1
  dykarbagge_1_N : N ; -- dykarbagge..nn.1
  dykardräkt_1_N : N ; -- dykardräkt..nn.1
  dykare_1_N : N ; -- dykare..nn.1
  dykarklocka_1_N : N ; -- dykarklocka..nn.1
  dykarsjuka_1_N : N ; -- dykarsjuka..nn.1
  dykarutrustning_1_N : N ; -- dykarutrustning..nn.1
  dykdalb_1_N : N ; -- dykdalb..nn.1
  dykeri_1_N : N ; -- dykeri..nn.1
  dykning_1_N : N ; -- dykning..nn.1
  dykningsolycka_1_N : N ; -- dykningsolycka..nn.1
  dykolycka_1_N : N ; -- dykolycka..nn.1
  dymling_1_N : N ; -- dymling..nn.1
  dymlingförband_1_N : N ; -- dymlingförband..nn.1
  dymmelonsdag_1_N : N ; -- dymmelonsdag..nn.1
  dymmelvecka_1_N : N ; -- dymmelvecka..nn.1
  dyn_1_N : N ; -- dyn..nn.1
  dyn_2_N : N ; -- dyn..nn.2
  dyna_1_N : N ; -- dyna..nn.1
  dynamik_1_N : N ; -- dynamik..nn.1
  dynamisk_1_A : A ; -- dynamisk..av.1
  dynamism_1_N : N ; -- dynamism..nn.1
  dynamistisk_1_A : A ; -- dynamistisk..av.1
  dynamit_1_N : N ; -- dynamit..nn.1
  dynamitard_1_N : N ; -- dynamitard..nn.1
  dynamitgubbe_1_N : N ; -- dynamitgubbe..nn.1
  dynamo_1_N : N ; -- dynamo..nn.1
  dynamometer_1_N : N ; -- dynamometer..nn.1
  dynasti_1_N : N ; -- dynasti..nn.1
  dynastigrundare_1_N : N ; -- dynastigrundare..nn.1
  dynastisk_1_A : A ; -- dynastisk..av.1
  dynga_1_N : N ; -- dynga..nn.1
  dyngbagge_1_N : N ; -- dyngbagge..nn.1
  dyngfluga_1_N : N ; -- dyngfluga..nn.1
  dyngfull_1_A : A ; -- dyngfull..av.1
  dynggrep_1_N : N ; -- dynggrep..nn.1
  dyngig_1_A : A ; -- dyngig..av.1
  dyngrak_1_A : A ; -- dyngrak..av.1
  dyngspridare_1_N : N ; -- dyngspridare..nn.1
  dyngsur_1_A : A ; -- dyngsur..av.1
  dyngsurhet_1_N : N ; -- dyngsurhet..nn.1
  dyning_1_N : N ; -- dyning..nn.1
  dynlandskap_1_N : N ; -- dynlandskap..nn.1
  dynt_1_N : N ; -- dynt..nn.1
  dypöl_1_N : N ; -- dypöl..nn.1
  dyr_1_A : A ; -- dyr..av.1
  dyrbar_1_A : A ; -- dyrbar..av.1
  dyrbarhet_1_N : N ; -- dyrbarhet..nn.1
  dyrgrip_1_N : N ; -- dyrgrip..nn.1
  dyrhet_1_N : N ; -- dyrhet..nn.1
  dyrk_1_N : N ; -- dyrk..nn.1
  dyrka_1_V : V ; -- dyrka..vb.1
  dyrkande_1_N : N ; -- dyrkande..nn.1
  dyrkansvärd_1_A : A ; -- dyrkansvärd..av.1
  dyrkansvärdhet_1_N : N ; -- dyrkansvärdhet..nn.1
  dyrkare_1_N : N ; -- dyrkare..nn.1
  dyrkfri_1_A : A ; -- dyrkfri..av.1
  dyrköpt_1_A : A ; -- dyrköpt..av.1
  dyrköpthet_1_N : N ; -- dyrköpthet..nn.1
  dyrort_1_N : N ; -- dyrort..nn.1
  dyrortsgrupp_1_N : N ; -- dyrortsgrupp..nn.1
  dyrortsgruppering_1_N : N ; -- dyrortsgruppering..nn.1
  dyrtid_1_N : N ; -- dyrtid..nn.1
  dyrtidstillägg_1_N : N ; -- dyrtidstillägg..nn.1
  dys_1_N : N ; -- dys..nn.1
  dysa_1_N : N ; -- dysa..nn.1
  dyscha_1_N : N ; -- dyscha..nn.1
  dyschatell_1_N : N ; -- dyschatell..nn.1
  dysenteri_1_N : N ; -- dysenteri..nn.1
  dysergi_1_N : N ; -- dysergi..nn.1
  dysfori_1_N : N ; -- dysfori..nn.1
  dysfunktionell_1_A : A ; -- dysfunktionell..av.1
  dyslektiker_1_N : N ; -- dyslektiker..nn.1
  dyslektisk_1_A : A ; -- dyslektisk..av.1
  dyslexi_1_N : N ; -- dyslexi..nn.1
  dyslexiker_1_N : N ; -- dyslexiker..nn.1
  dyslexisk_1_A : A ; -- dyslexisk..av.1
  dyspepsi_1_N : N ; -- dyspepsi..nn.1
  dysprosium_1_N : N ; -- dysprosium..nn.1
  dyster_1_A : A ; -- dyster..av.1
  dysterhet_1_N : N ; -- dysterhet..nn.1
  dysterkvist_1_N : N ; -- dysterkvist..nn.1
  dystopi_1_N : N ; -- dystopi..nn.1
  dystopisk_1_A : A ; -- dystopisk..av.1
  dystopiskhet_1_N : N ; -- dystopiskhet..nn.1
  dystrof_1_A : A ; -- dystrof..av.1
  dystrofi_1_N : N ; -- dystrofi..nn.1
  dyvelsträck_1_N : N ; -- dyvelsträck..nn.1
  dyvik_1_N : N ; -- dyvik..nn.1
  dyvik_2_1_N : N ; -- dyvik_2..nn.1
  dyvika_1_N : N ; -- dyvika..nn.1
  dyvikare_1_N : N ; -- dyvikare..nn.1
  dyvåt_1_A : A ; -- dyvåt..av.1
  däck_1_N : N ; -- däck..nn.1
  däck_2_N : N ; -- däck..nn.2
  däcka_1_V : V ; -- däcka..vb.1
  däckad_1_A : A ; -- däckad..av.1
  däckande_1_N : N ; -- däckande..nn.1
  däckavtagning_1_N : N ; -- däckavtagning..nn.1
  däckbytarhelg_1_N : N ; -- däckbytarhelg..nn.1
  däckbyte_1_N : N ; -- däckbyte..nn.1
  däckdimension_1_N : N ; -- däckdimension..nn.1
  däckel_1_N : N ; -- däckel..nn.1
  däcker_1_N : N ; -- däcker..nn.1
  däckglans_1_N : N ; -- däckglans..nn.1
  däckhotell_1_N : N ; -- däckhotell..nn.1
  däckhållare_1_N : N ; -- däckhållare..nn.1
  däckjärn_1_N : N ; -- däckjärn..nn.1
  däckmärkning_1_N : N ; -- däckmärkning..nn.1
  däckmärkningsklämma_1_N : N ; -- däckmärkningsklämma..nn.1
  däckpåse_1_N : N ; -- däckpåse..nn.1
  däcksbalk_1_N : N ; -- däcksbalk..nn.1
  däckslast_1_N : N ; -- däckslast..nn.1
  däcksmanskap_1_N : N ; -- däcksmanskap..nn.1
  däckspassagerare_1_N : N ; -- däckspassagerare..nn.1
  däcksplanka_1_N : N ; -- däcksplanka..nn.1
  däckventil_1_N : N ; -- däckventil..nn.1
  däckverkstad_1_N : N ; -- däckverkstad..nn.1
  dägga_1_V : V ; -- dägga..vb.1
  däggande_1_N : N ; -- däggande..nn.1
  däggdjur_1_N : N ; -- däggdjur..nn.1
  däggdjursgrupp_1_N : N ; -- däggdjursgrupp..nn.1
  däggdjurstand_1_N : N ; -- däggdjurstand..nn.1
  däggdjurstyp_1_N : N ; -- däggdjurstyp..nn.1
  däggdjursunge_1_N : N ; -- däggdjursunge..nn.1
  däld_1_N : N ; -- däld..nn.1
  dämma_1_V : V ; -- dämma..vb.1
  dämmande_1_N : N ; -- dämmande..nn.1
  dämmare_1_N : N ; -- dämmare..nn.1
  dämme_1_N : N ; -- dämme..nn.1
  dämning_1_N : N ; -- dämning..nn.1
  dämpa_1_V : V ; -- dämpa..vb.1
  dämpad_1_A : A ; -- dämpad..av.1
  dämpande_1_N : N ; -- dämpande..nn.1
  dämpare_1_N : N ; -- dämpare..nn.1
  dämpbox_1_N : N ; -- dämpbox..nn.1
  dämpning_1_N : N ; -- dämpning..nn.1
  däng_1_N : N ; -- däng..nn.1
  dänga_1_V : V ; -- dänga..vb.1
  dängande_1_N : N ; -- dängande..nn.1
  dänka_1_V : V ; -- dänka..vb.1
  dänkande_1_N : N ; -- dänkande..nn.1
  därav_1_Adv : Adv ; -- därav..ab.1
  därbakom_1_Adv : Adv ; -- därbakom..ab.1
  därborta_1_Adv : Adv ; -- därborta..ab.1
  därbortom_1_Adv : Adv ; -- därbortom..ab.1
  därefter_1_Adv : Adv ; -- därefter..ab.1
  däremellan_1_Adv : Adv ; -- däremellan..ab.1
  däremot_1_Adv : Adv ; -- däremot..ab.1
  därframme_1_Adv : Adv ; -- därframme..ab.1
  därför_1_Adv : Adv ; -- därför..ab.1
  därföre_1_Adv : Adv ; -- därföre..ab.1
  därhän_1_Adv : Adv ; -- därhän..ab.1
  däri_1_Adv : Adv ; -- däri..ab.1
  däribland_1_Adv : Adv ; -- däribland..ab.1
  därifrån_1_Adv : Adv ; -- därifrån..ab.1
  därigenom_1_Adv : Adv ; -- därigenom..ab.1
  därinifrån_1_Adv : Adv ; -- därinifrån..ab.1
  därinnanför_1_Adv : Adv ; -- därinnanför..ab.1
  därinne_1_Adv : Adv ; -- därinne..ab.1
  därjämte_1_Adv : Adv ; -- därjämte..ab.1
  därmed_1_Adv : Adv ; -- därmed..ab.1
  därnedanför_1_Adv : Adv ; -- därnedanför..ab.1
  därnere_1_Adv : Adv ; -- därnere..ab.1
  därnäst_1_Adv : Adv ; -- därnäst..ab.1
  därom_1_Adv : Adv ; -- därom..ab.1
  däromkring_1_Adv : Adv ; -- däromkring..ab.1
  däroppe_1_Adv : Adv ; -- däroppe..ab.1
  därovanför_1_Adv : Adv ; -- därovanför..ab.1
  därproducerad_1_A : A ; -- därproducerad..av.1
  därpå_1_Adv : Adv ; -- därpå..ab.1
  därstädes_1_Adv : Adv ; -- därstädes..ab.1
  därtappad_1_A : A ; -- därtappad..av.1
  därtill_1_Adv : Adv ; -- därtill..ab.1
  därunder_1_Adv : Adv ; -- därunder..ab.1
  däruppe_1_Adv : Adv ; -- däruppe..ab.1
  däruppifrån_1_Adv : Adv ; -- däruppifrån..ab.1
  därur_1_Adv : Adv ; -- därur..ab.1
  därutanför_1_Adv : Adv ; -- därutanför..ab.1
  därutav_1_Adv : Adv ; -- därutav..ab.1
  därute_1_Adv : Adv ; -- därute..ab.1
  därutinnan_1_Adv : Adv ; -- därutinnan..ab.1
  därutur_1_Adv : Adv ; -- därutur..ab.1
  därutöver_1_Adv : Adv ; -- därutöver..ab.1
  därvarande_1_A : A ; -- därvarande..av.1
  därvid_1_Adv : Adv ; -- därvid..ab.1
  därvidlag_1_Adv : Adv ; -- därvidlag..ab.1
  däråt_1_Adv : Adv ; -- däråt..ab.1
  däröver_1_Adv : Adv ; -- däröver..ab.1
  däst_1_A : A ; -- däst..av.1
  dästhet_1_N : N ; -- dästhet..nn.1
  däven_1_A : A ; -- däven..av.1
  dävenhet_1_N : N ; -- dävenhet..nn.1
  dävert_1_N : N ; -- dävert..nn.1
  dävna_1_V : V ; -- dävna..vb.1
  dävnande_1_N : N ; -- dävnande..nn.1
  däxel_1_N : N ; -- däxel..nn.1
  då_2_Adv : Adv ; -- då..ab.2
  dåd_1_N : N ; -- dåd..nn.1
  dådkraft_1_N : N ; -- dådkraft..nn.1
  dådkraftig_1_A : A ; -- dådkraftig..av.1
  dådlös_1_A : A ; -- dådlös..av.1
  dådlöshet_1_N : N ; -- dådlöshet..nn.1
  dådra_1_N : N ; -- dådra..nn.1
  dådrafrö_1_N : N ; -- dådrafrö..nn.1
  dålig_1_A : A ; -- dålig..av.1
  dålighet_1_N : N ; -- dålighet..nn.1
  dån_1_N : N ; -- dån..nn.1
  dån_2_N : N ; -- dån..nn.2
  dåna_1_V : V ; -- dåna..vb.1
  dåna_2_V : V ; -- dåna..vb.2
  dånande_1_N : N ; -- dånande..nn.1
  dåning_1_N : N ; -- dåning..nn.1
  dåra_1_V : V ; -- dåra..vb.1
  dåraktig_1_A : A ; -- dåraktig..av.1
  dåraktighet_1_N : N ; -- dåraktighet..nn.1
  dårande_1_N : N ; -- dårande..nn.1
  dårdoktor_1_N : N ; -- dårdoktor..nn.1
  dåre_1_N : N ; -- dåre..nn.1
  dårfink_1_N : N ; -- dårfink..nn.1
  dårhus_1_N : N ; -- dårhus..nn.1
  dårhusmässig_1_A : A ; -- dårhusmässig..av.1
  dårskap_1_N : N ; -- dårskap..nn.1
  dås_1_N : N ; -- dås..nn.1
  dåsa_1_V : V ; -- dåsa..vb.1
  dåsande_1_N : N ; -- dåsande..nn.1
  dåsig_1_A : A ; -- dåsig..av.1
  dåsighet_1_N : N ; -- dåsighet..nn.1
  dåtid_1_N : N ; -- dåtid..nn.1
  dåtida_1_A : A ; -- dåtida..av.1
  dåvarande_1_A : A ; -- dåvarande..av.1
  détente_1_N : N ; -- détente..nn.1
  dö_1_V : V ; -- dö..vb.1
  döbattang_1_N : N ; -- döbattang..nn.1
  döblek_1_A : A ; -- döblek..av.1
  döblekhet_1_N : N ; -- döblekhet..nn.1
  död_1_A : A ; -- död..av.1
  död_1_N : N ; -- död..nn.1
  döda_1_V : V ; -- döda..vb.1
  dödande_1_A : A ; -- dödande..av.1
  dödande_1_N : N ; -- dödande..nn.1
  dödbakad_1_A : A ; -- dödbakad..av.1
  dödbränd_1_A : A ; -- dödbränd..av.1
  döddansare_1_N : N ; -- döddansare..nn.1
  dödfull_1_A : A ; -- dödfull..av.1
  dödfödd_1_A : A ; -- dödfödd..av.1
  dödförklara_1_V : V ; -- dödförklara..vb.1
  dödförklarande_1_N : N ; -- dödförklarande..nn.1
  dödgrävare_1_N : N ; -- dödgrävare..nn.1
  dödhet_1_N : N ; -- dödhet..nn.1
  döding_1_N : N ; -- döding..nn.1
  dödis_1_N : N ; -- dödis..nn.1
  dödkött_1_N : N ; -- dödkött..nn.1
  dödlig_1_A : A ; -- dödlig..av.1
  dödlighet_1_N : N ; -- dödlighet..nn.1
  dödlighet_2_N : N ; -- dödlighet..nn.2
  dödlighetsprocent_1_N : N ; -- dödlighetsprocent..nn.1
  dödläge_1_N : N ; -- dödläge..nn.1
  dödmansgrepp_1_N : N ; -- dödmansgrepp..nn.1
  dödperiod_1_N : N ; -- dödperiod..nn.1
  dödsannons_1_N : N ; -- dödsannons..nn.1
  dödsattest_1_N : N ; -- dödsattest..nn.1
  dödsbakterie_1_N : N ; -- dödsbakterie..nn.1
  dödsbevis_1_N : N ; -- dödsbevis..nn.1
  dödsblek_1_A : A ; -- dödsblek..av.1
  dödsblekhet_1_N : N ; -- dödsblekhet..nn.1
  dödsbo_1_N : N ; -- dödsbo..nn.1
  dödsbringande_1_A : A ; -- dödsbringande..av.1
  dödsbud_1_N : N ; -- dödsbud..nn.1
  dödsbädd_1_N : N ; -- dödsbädd..nn.1
  dödscell_1_N : N ; -- dödscell..nn.1
  dödsdag_1_N : N ; -- dödsdag..nn.1
  dödsdans_1_N : N ; -- dödsdans..nn.1
  dödsdom_1_N : N ; -- dödsdom..nn.1
  dödsdömd_1_A : A ; -- dödsdömd..av.1
  dödsfall_1_N : N ; -- dödsfall..nn.1
  dödsfara_1_N : N ; -- dödsfara..nn.1
  dödsfas_1_N : N ; -- dödsfas..nn.1
  dödsfiende_1_N : N ; -- dödsfiende..nn.1
  dödsflygning_1_N : N ; -- dödsflygning..nn.1
  dödsfälla_1_N : N ; -- dödsfälla..nn.1
  dödsförakt_1_N : N ; -- dödsförakt..nn.1
  dödsföraktande_1_A : A ; -- dödsföraktande..av.1
  dödsförbannad_1_A : A ; -- dödsförbannad..av.1
  dödsförskräckt_1_A : A ; -- dödsförskräckt..av.1
  dödshjälp_1_N : N ; -- dödshjälp..nn.1
  dödshjälpsdebatt_1_N : N ; -- dödshjälpsdebatt..nn.1
  dödshot_1_N : N ; -- dödshot..nn.1
  dödsjö_1_N : N ; -- dödsjö..nn.1
  dödskalle_1_N : N ; -- dödskalle..nn.1
  dödskallefjäril_1_N : N ; -- dödskallefjäril..nn.1
  dödskallefynd_1_N : N ; -- dödskallefynd..nn.1
  dödskamp_1_N : N ; -- dödskamp..nn.1
  dödsklinik_1_N : N ; -- dödsklinik..nn.1
  dödskrasch_1_N : N ; -- dödskrasch..nn.1
  dödskval_1_N : N ; -- dödskval..nn.1
  dödskyla_1_N : N ; -- dödskyla..nn.1
  dödslista_1_N : N ; -- dödslista..nn.1
  dödsmarsch_1_N : N ; -- dödsmarsch..nn.1
  dödsmask_1_N : N ; -- dödsmask..nn.1
  dödsmetal_1_N : N ; -- dödsmetal..nn.1
  dödsmetall_1_N : N ; -- dödsmetall..nn.1
  dödsminut_1_N : N ; -- dödsminut..nn.1
  dödsmisshandel_1_N : N ; -- dödsmisshandel..nn.1
  dödsmärkt_1_A : A ; -- dödsmärkt..av.1
  dödsoffer_1_N : N ; -- dödsoffer..nn.1
  dödsolycka_1_N : N ; -- dödsolycka..nn.1
  dödsorsak_1_N : N ; -- dödsorsak..nn.1
  dödsorsaksregister_1_N : N ; -- dödsorsaksregister..nn.1
  dödspatrull_1_N : N ; -- dödspatrull..nn.1
  dödsrike_1_N : N ; -- dödsrike..nn.1
  dödsringning_1_N : N ; -- dödsringning..nn.1
  dödsrossling_1_N : N ; -- dödsrossling..nn.1
  dödsruna_1_N : N ; -- dödsruna..nn.1
  dödsryckning_1_N : N ; -- dödsryckning..nn.1
  dödssiffra_1_N : N ; -- dödssiffra..nn.1
  dödssjuk_1_A : A ; -- dödssjuk..av.1
  dödssjukhet_1_N : N ; -- dödssjukhet..nn.1
  dödsskjuta_1_V : V ; -- dödsskjuta..vb.1
  dödsskjutande_1_N : N ; -- dödsskjutande..nn.1
  dödsskjuten_1_A : A ; -- dödsskjuten..av.1
  dödsskjutning_1_N : N ; -- dödsskjutning..nn.1
  dödsskott_1_N : N ; -- dödsskott..nn.1
  dödsskugga_1_N : N ; -- dödsskugga..nn.1
  dödsskvadron_1_N : N ; -- dödsskvadron..nn.1
  dödsstelhet_1_N : N ; -- dödsstelhet..nn.1
  dödsstilla_1_A : A ; -- dödsstilla..av.1
  dödsstillhet_1_N : N ; -- dödsstillhet..nn.1
  dödsstjärna_1_N : N ; -- dödsstjärna..nn.1
  dödsstraff_1_N : N ; -- dödsstraff..nn.1
  dödsstraffsanhängare_1_N : N ; -- dödsstraffsanhängare..nn.1
  dödsstund_1_N : N ; -- dödsstund..nn.1
  dödsstörta_1_V : V ; -- dödsstörta..vb.1
  dödsstörtande_1_N : N ; -- dödsstörtande..nn.1
  dödsstörtning_1_N : N ; -- dödsstörtning..nn.1
  dödsstöt_1_N : N ; -- dödsstöt..nn.1
  dödssynd_1_N : N ; -- dödssynd..nn.1
  dödssätt_1_N : N ; -- dödssätt..nn.1
  dödssömn_1_N : N ; -- dödssömn..nn.1
  dödstal_1_N : N ; -- dödstal..nn.1
  dödstillfälle_1_N : N ; -- dödstillfälle..nn.1
  dödstimme_1_N : N ; -- dödstimme..nn.1
  dödstråkig_1_A : A ; -- dödstråkig..av.1
  dödstråkighet_1_N : N ; -- dödstråkighet..nn.1
  dödstrött_1_A : A ; -- dödstrött..av.1
  dödströtthet_1_N : N ; -- dödströtthet..nn.1
  dödstyst_1_A : A ; -- dödstyst..av.1
  dödstystnad_1_N : N ; -- dödstystnad..nn.1
  dödsur_1_N : N ; -- dödsur..nn.1
  dödsvånda_1_N : N ; -- dödsvånda..nn.1
  dödsängel_1_N : N ; -- dödsängel..nn.1
  dödsångest_1_N : N ; -- dödsångest..nn.1
  dödsår_1_N : N ; -- dödsår..nn.1
  dödtid_1_N : N ; -- dödtid..nn.1
  dödvikt_1_N : N ; -- dödvikt..nn.1
  döende_1_A : A ; -- döende..av.1
  döende_1_N : N ; -- döende..nn.1
  döfull_1_A : A ; -- döfull..av.1
  döförbannad_1_A : A ; -- döförbannad..av.1
  döförskräckt_1_A : A ; -- döförskräckt..av.1
  dögling_1_N : N ; -- dögling..nn.1
  döing_1_N : N ; -- döing..nn.1
  dölja_1_V : V ; -- dölja..vb.1
  döljande_1_N : N ; -- döljande..nn.1
  döma_1_V : V ; -- döma..vb.1
  dömande_1_N : N ; -- dömande..nn.1
  dön_1_N : N ; -- dön..nn.1
  döna_1_V : V ; -- döna..vb.1
  dönande_1_N : N ; -- dönande..nn.1
  döpa_1_V : V ; -- döpa..vb.1
  döpande_1_N : N ; -- döpande..nn.1
  döpare_1_N : N ; -- döpare..nn.1
  döpelse_1_N : N ; -- döpelse..nn.1
  dörj_1_N : N ; -- dörj..nn.1
  dörja_1_V : V ; -- dörja..vb.1
  dörjande_1_N : N ; -- dörjande..nn.1
  dörr_1_N : N ; -- dörr..nn.1
  dörrblad_1_N : N ; -- dörrblad..nn.1
  dörrfärg_1_N : N ; -- dörrfärg..nn.1
  dörrförhänge_1_N : N ; -- dörrförhänge..nn.1
  dörrförsäljare_1_N : N ; -- dörrförsäljare..nn.1
  dörrhake_1_N : N ; -- dörrhake..nn.1
  dörrhandtag_1_N : N ; -- dörrhandtag..nn.1
  dörrkarm_1_N : N ; -- dörrkarm..nn.1
  dörrkedja_1_N : N ; -- dörrkedja..nn.1
  dörrklinka_1_N : N ; -- dörrklinka..nn.1
  dörrklocka_1_N : N ; -- dörrklocka..nn.1
  dörrknackare_1_N : N ; -- dörrknackare..nn.1
  dörrknackning_1_N : N ; -- dörrknackning..nn.1
  dörrknackningskampanj_1_N : N ; -- dörrknackningskampanj..nn.1
  dörrknackningsoperation_1_N : N ; -- dörrknackningsoperation..nn.1
  dörrkrans_1_N : N ; -- dörrkrans..nn.1
  dörrlås_1_N : N ; -- dörrlås..nn.1
  dörrmatta_1_N : N ; -- dörrmatta..nn.1
  dörrnyckel_1_N : N ; -- dörrnyckel..nn.1
  dörrpost_1_N : N ; -- dörrpost..nn.1
  dörrspegel_1_N : N ; -- dörrspegel..nn.1
  dörrstolpe_1_N : N ; -- dörrstolpe..nn.1
  dörrstängare_1_N : N ; -- dörrstängare..nn.1
  dörrvakt_1_N : N ; -- dörrvakt..nn.1
  dörrvaktare_1_N : N ; -- dörrvaktare..nn.1
  dörrvred_1_N : N ; -- dörrvred..nn.1
  dörröga_1_N : N ; -- dörröga..nn.1
  dörröppnare_1_N : N ; -- dörröppnare..nn.1
  dörröppning_1_N : N ; -- dörröppning..nn.1
  dös_1_N : N ; -- dös..nn.1
  dösjuk_1_A : A ; -- dösjuk..av.1
  döskraj_1_A : A ; -- döskraj..av.1
  dösnack_1_N : N ; -- dösnack..nn.1
  dötråkig_1_A : A ; -- dötråkig..av.1
  dötrött_1_A : A ; -- dötrött..av.1
  dötyst_1_A : A ; -- dötyst..av.1
  döv_1_A : A ; -- döv..av.1
  döva_1_V : V ; -- döva..vb.1
  dövande_1_N : N ; -- dövande..nn.1
  dövblind_1_A : A ; -- dövblind..av.1
  dövblindhet_1_N : N ; -- dövblindhet..nn.1
  dövhet_1_N : N ; -- dövhet..nn.1
  dövning_1_N : N ; -- dövning..nn.1
  dövstum_1_A : A ; -- dövstum..av.1
  dövstumhet_1_N : N ; -- dövstumhet..nn.1
  e_bok_1_N : N ; -- e-bok..nn.1
  e_bokläsare_1_N : N ; -- e-bokläsare..nn.1
  e_brev_1_N : N ; -- e-brev..nn.1
  e_brevledes_1_Adv : Adv ; -- e-brevledes..ab.1
  e_leg_1_N : N ; -- e-leg..nn.1
  e_legg_1_N : N ; -- e-legg..nn.1
  e_legitimation_1_N : N ; -- e-legitimation..nn.1
  e_mail_1_N : N ; -- e-mail..nn.1
  e_mail_2_N : N ; -- e-mail..nn.2
  e_maila_1_V : V ; -- e-maila..vb.1
  e_mailande_1_N : N ; -- e-mailande..nn.1
  e_post_1_N : N ; -- e-post..nn.1
  e_posta_1_V : V ; -- e-posta..vb.1
  e_postande_1_N : N ; -- e-postande..nn.1
  e_postare_1_N : N ; -- e-postare..nn.1
  e_postbrev_1_N : N ; -- e-postbrev..nn.1
  e_postledes_1_Adv : Adv ; -- e-postledes..ab.1
  e_postmeddelande_1_N : N ; -- e-postmeddelande..nn.1
  e_tidning_1_N : N ; -- e-tidning..nn.1
  e_tidskrift_1_N : N ; -- e-tidskrift..nn.1
  e_vetenskap_1_N : N ; -- e-vetenskap..nn.1
  eau_de_cologne_1_N : N ; -- eau-de-cologne..nn.1
  eau_de_toilette_1_N : N ; -- eau-de-toilette..nn.1
  eau_de_vie_1_N : N ; -- eau-de-vie..nn.1
  ebb_1_N : N ; -- ebb..nn.1
  ebba_1_V : V ; -- ebba..vb.1
  ebbande_1_N : N ; -- ebbande..nn.1
  ebenholts_1_N : N ; -- ebenholts..nn.1
  ebenholtsbetsad_1_A : A ; -- ebenholtsbetsad..av.1
  ebenist_1_N : N ; -- ebenist..nn.1
  ebolavirus_1_N : N ; -- ebolavirus..nn.1
  ebonit_1_N : N ; -- ebonit..nn.1
  ebonitstav_1_N : N ; -- ebonitstav..nn.1
  ebrev_1_N : N ; -- ebrev..nn.1
  ebrevledes_1_Adv : Adv ; -- ebrevledes..ab.1
  echaufferad_1_A : A ; -- echaufferad..av.1
  echelong_1_N : N ; -- echelong..nn.1
  ecklesiastik_1_A : A ; -- ecklesiastik..av.1
  ecklesiastikdepartement_1_N : N ; -- ecklesiastikdepartement..nn.1
  ecklesiastikminister_1_N : N ; -- ecklesiastikminister..nn.1
  ecklesiastisk_1_A : A ; -- ecklesiastisk..av.1
  ecuadorian_1_N : N ; -- ecuadorian..nn.1
  ecuadoriansk_1_A : A ; -- ecuadoriansk..av.1
  ecuadorianska_1_N : N ; -- ecuadorianska..nn.1
  ed_1_N : N ; -- ed..nn.1
  ed_2_N : N ; -- ed..nn.2
  eda_1_N : N ; -- eda..nn.1
  edamerost_1_N : N ; -- edamerost..nn.1
  edda_1_N : N ; -- edda..nn.1
  edelweiss_1_N : N ; -- edelweiss..nn.1
  edera_1_V : V ; -- edera..vb.1
  ederande_1_N : N ; -- ederande..nn.1
  ederbar_1_A : A ; -- ederbar..av.1
  ederbarhet_1_N : N ; -- ederbarhet..nn.1
  edering_1_N : N ; -- edering..nn.1
  edfäst_1_A : A ; -- edfäst..av.1
  edfästa_1_V : V ; -- edfästa..vb.1
  edfästande_1_N : N ; -- edfästande..nn.1
  edgång_1_N : N ; -- edgång..nn.1
  edikt_1_N : N ; -- edikt..nn.1
  edil_1_N : N ; -- edil..nn.1
  edition_1_N : N ; -- edition..nn.1
  edlig_1_A : A ; -- edlig..av.1
  edligen_1_Adv : Adv ; -- edligen..ab.1
  edlighet_1_N : N ; -- edlighet..nn.1
  edsansvar_1_N : N ; -- edsansvar..nn.1
  edsbrott_1_N : N ; -- edsbrott..nn.1
  edsförpliktelse_1_N : N ; -- edsförpliktelse..nn.1
  edsgång_1_N : N ; -- edsgång..nn.1
  edsvuren_1_A : A ; -- edsvuren..av.1
  edsöre_1_N : N ; -- edsöre..nn.1
  edsöresbrott_1_N : N ; -- edsöresbrott..nn.1
  efedrin_1_N : N ; -- efedrin..nn.1
  efemerid_1_N : N ; -- efemerid..nn.1
  efemeridtid_1_N : N ; -- efemeridtid..nn.1
  efemär_1_A : A ; -- efemär..av.1
  effacera_1_V : V ; -- effacera..vb.1
  effacerande_1_N : N ; -- effacerande..nn.1
  effacerbar_1_A : A ; -- effacerbar..av.1
  effacerbarhet_1_N : N ; -- effacerbarhet..nn.1
  effacering_1_N : N ; -- effacering..nn.1
  effekt_1_N : N ; -- effekt..nn.1
  effektfaktor_1_N : N ; -- effektfaktor..nn.1
  effektfrånskiljare_1_N : N ; -- effektfrånskiljare..nn.1
  effektfull_1_A : A ; -- effektfull..av.1
  effektfullhet_1_N : N ; -- effektfullhet..nn.1
  effektförstärkare_1_N : N ; -- effektförstärkare..nn.1
  effektgarn_1_N : N ; -- effektgarn..nn.1
  effektiv_1_A : A ; -- effektiv..av.1
  effektivera_1_V : V ; -- effektivera..vb.1
  effektiverande_1_N : N ; -- effektiverande..nn.1
  effektiverbar_1_A : A ; -- effektiverbar..av.1
  effektiverbarhet_1_N : N ; -- effektiverbarhet..nn.1
  effektivering_1_N : N ; -- effektivering..nn.1
  effektivisera_1_V : V ; -- effektivisera..vb.1
  effektiviserande_1_N : N ; -- effektiviserande..nn.1
  effektiviserbar_1_A : A ; -- effektiviserbar..av.1
  effektiviserbarhet_1_N : N ; -- effektiviserbarhet..nn.1
  effektivisering_1_N : N ; -- effektivisering..nn.1
  effektivitet_1_N : N ; -- effektivitet..nn.1
  effektivitetsargument_1_N : N ; -- effektivitetsargument..nn.1
  effektivitetsmässig_1_A : A ; -- effektivitetsmässig..av.1
  effektläge_1_N : N ; -- effektläge..nn.1
  effektlös_1_A : A ; -- effektlös..av.1
  effektlöshet_1_N : N ; -- effektlöshet..nn.1
  effektmässig_1_A : A ; -- effektmässig..av.1
  effektskapande_1_A : A ; -- effektskapande..av.1
  effektsökeri_1_N : N ; -- effektsökeri..nn.1
  effektuera_1_V : V ; -- effektuera..vb.1
  effektuerande_1_N : N ; -- effektuerande..nn.1
  effektuerbar_1_A : A ; -- effektuerbar..av.1
  effektuerbarhet_1_N : N ; -- effektuerbarhet..nn.1
  effektuering_1_N : N ; -- effektuering..nn.1
  effektökning_1_N : N ; -- effektökning..nn.1
  effeminerad_1_A : A ; -- effeminerad..av.1
  efor_1_N : N ; -- efor..nn.1
  eforus_1_N : N ; -- eforus..nn.1
  efter_1_A : A ; -- efter..av.1
  efteraccept_1_N : N ; -- efteraccept..nn.1
  efteranmäla_1_V : V ; -- efteranmäla..vb.1
  efterapa_1_V : V ; -- efterapa..vb.1
  efterapande_1_N : N ; -- efterapande..nn.1
  efterapare_1_N : N ; -- efterapare..nn.1
  efterapning_1_N : N ; -- efterapning..nn.1
  efterarbete_1_N : N ; -- efterarbete..nn.1
  efterbehandla_1_V : V ; -- efterbehandla..vb.1
  efterbehandlande_1_N : N ; -- efterbehandlande..nn.1
  efterbesiktning_1_N : N ; -- efterbesiktning..nn.1
  efterbeskattning_1_N : N ; -- efterbeskattning..nn.1
  efterbeställning_1_N : N ; -- efterbeställning..nn.1
  efterbetalning_1_N : N ; -- efterbetalning..nn.1
  efterbevakning_1_N : N ; -- efterbevakning..nn.1
  efterbild_1_N : N ; -- efterbild..nn.1
  efterbilda_1_V : V ; -- efterbilda..vb.1
  efterbildande_1_N : N ; -- efterbildande..nn.1
  efterbildare_1_N : N ; -- efterbildare..nn.1
  efterbildning_1_N : N ; -- efterbildning..nn.1
  efterbliven_1_A : A ; -- efterbliven..av.1
  efterblivenhet_1_N : N ; -- efterblivenhet..nn.1
  efterblomning_1_N : N ; -- efterblomning..nn.1
  efterblomstring_1_N : N ; -- efterblomstring..nn.1
  efterblödning_1_N : N ; -- efterblödning..nn.1
  efterbrännare_1_N : N ; -- efterbrännare..nn.1
  efterbrännkammare_1_N : N ; -- efterbrännkammare..nn.1
  efterbörd_1_N : N ; -- efterbörd..nn.1
  efterbörs_1_N : N ; -- efterbörs..nn.1
  efterdatera_1_V : V ; -- efterdatera..vb.1
  efterdaterande_1_N : N ; -- efterdaterande..nn.1
  efterdaterbar_1_A : A ; -- efterdaterbar..av.1
  efterdaterbarhet_1_N : N ; -- efterdaterbarhet..nn.1
  efterdatering_1_N : N ; -- efterdatering..nn.1
  efterdebitera_1_V : V ; -- efterdebitera..vb.1
  efterdebiterande_1_N : N ; -- efterdebiterande..nn.1
  efterdebiterbar_1_A : A ; -- efterdebiterbar..av.1
  efterdebiterbarhet_1_N : N ; -- efterdebiterbarhet..nn.1
  efterdebitering_1_N : N ; -- efterdebitering..nn.1
  efterdyning_1_N : N ; -- efterdyning..nn.1
  efterdöme_1_N : N ; -- efterdöme..nn.1
  efterdömlig_1_A : A ; -- efterdömlig..av.1
  efterdömlighet_1_N : N ; -- efterdömlighet..nn.1
  efterfest_1_N : N ; -- efterfest..nn.1
  efterforska_1_V : V ; -- efterforska..vb.1
  efterforskande_1_N : N ; -- efterforskande..nn.1
  efterforskning_1_N : N ; -- efterforskning..nn.1
  efterfråga_1_V : V ; -- efterfråga..vb.1
  efterfrågad_1_A : A ; -- efterfrågad..av.1
  efterfrågande_1_N : N ; -- efterfrågande..nn.1
  efterfrågning_1_N : N ; -- efterfrågning..nn.1
  efterfölja_1_V : V ; -- efterfölja..vb.1
  efterföljande_1_N : N ; -- efterföljande..nn.1
  efterföljansvärd_1_A : A ; -- efterföljansvärd..av.1
  efterföljare_1_N : N ; -- efterföljare..nn.1
  efterföljd_1_N : N ; -- efterföljd..nn.1
  efterföljelse_1_N : N ; -- efterföljelse..nn.1
  efterge_1_V : V ; -- efterge..vb.1
  eftergift_1_N : N ; -- eftergift..nn.1
  eftergivande_1_N : N ; -- eftergivande..nn.1
  eftergiven_1_A : A ; -- eftergiven..av.1
  eftergivenhet_1_N : N ; -- eftergivenhet..nn.1
  eftergivlig_1_A : A ; -- eftergivlig..av.1
  eftergivlighet_1_N : N ; -- eftergivlighet..nn.1
  eftergjord_1_A : A ; -- eftergjord..av.1
  efterglans_1_N : N ; -- efterglans..nn.1
  eftergranskning_1_N : N ; -- eftergranskning..nn.1
  eftergymnasial_1_A : A ; -- eftergymnasial..av.1
  eftergöra_1_V : V ; -- eftergöra..vb.1
  eftergörande_1_N : N ; -- eftergörande..nn.1
  efterhand_1_Adv : Adv ; -- efterhand..ab.1
  efterhand_1_N : N ; -- efterhand..nn.1
  efterhandskonstruktion_1_N : N ; -- efterhandskonstruktion..nn.1
  efterhängsen_1_A : A ; -- efterhängsen..av.1
  efterhängsenhet_1_N : N ; -- efterhängsenhet..nn.1
  efterhärma_1_V : V ; -- efterhärma..vb.1
  efterhärmande_1_N : N ; -- efterhärmande..nn.1
  efterhärmare_1_N : N ; -- efterhärmare..nn.1
  efterhärmning_1_N : N ; -- efterhärmning..nn.1
  efterhålla_1_V : V ; -- efterhålla..vb.1
  efterhållande_1_N : N ; -- efterhållande..nn.1
  efterhöra_1_V : V ; -- efterhöra..vb.1
  efterhörande_1_N : N ; -- efterhörande..nn.1
  efterhöst_1_N : N ; -- efterhöst..nn.1
  efterjäsning_1_N : N ; -- efterjäsning..nn.1
  efterklang_1_N : N ; -- efterklang..nn.1
  efterklok_1_A : A ; -- efterklok..av.1
  efterklokhet_1_N : N ; -- efterklokhet..nn.1
  efterkokning_1_N : N ; -- efterkokning..nn.1
  efterkomma_1_V : V ; -- efterkomma..vb.1
  efterkommande_1_N : N ; -- efterkommande..nn.1
  efterkommande_2_N : N ; -- efterkommande..nn.2
  efterkonstruktion_1_N : N ; -- efterkonstruktion..nn.1
  efterkontroll_1_N : N ; -- efterkontroll..nn.1
  efterkrav_1_N : N ; -- efterkrav..nn.1
  efterkrigsdecennium_1_N : N ; -- efterkrigsdecennium..nn.1
  efterkrigstid_1_N : N ; -- efterkrigstid..nn.1
  efterkultur_1_N : N ; -- efterkultur..nn.1
  efterkänning_1_N : N ; -- efterkänning..nn.1
  efterled_1_N : N ; -- efterled..nn.1
  efterleva_1_V : V ; -- efterleva..vb.1
  efterlevande_1_A : A ; -- efterlevande..av.1
  efterlevande_1_N : N ; -- efterlevande..nn.1
  efterlevandeskydd_1_N : N ; -- efterlevandeskydd..nn.1
  efterleverska_1_N : N ; -- efterleverska..nn.1
  efterlevnad_1_N : N ; -- efterlevnad..nn.1
  efterlevnadskontroll_1_N : N ; -- efterlevnadskontroll..nn.1
  efterliggande_1_A : A ; -- efterliggande..av.1
  efterlikna_1_V : V ; -- efterlikna..vb.1
  efterliknande_1_N : N ; -- efterliknande..nn.1
  efterlysa_1_V : V ; -- efterlysa..vb.1
  efterlysande_1_N : N ; -- efterlysande..nn.1
  efterlysning_1_N : N ; -- efterlysning..nn.1
  efterlämna_1_V : V ; -- efterlämna..vb.1
  efterlämnande_1_N : N ; -- efterlämnande..nn.1
  efterlämning_1_N : N ; -- efterlämning..nn.1
  efterlängtad_1_A : A ; -- efterlängtad..av.1
  efterlåta_1_V : V ; -- efterlåta..vb.1
  efterlåtande_1_N : N ; -- efterlåtande..nn.1
  efterlåten_1_A : A ; -- efterlåten..av.1
  efterlåtenhet_1_N : N ; -- efterlåtenhet..nn.1
  eftermassage_1_N : N ; -- eftermassage..nn.1
  eftermiddag_1_N : N ; -- eftermiddag..nn.1
  eftermiddagsbris_1_N : N ; -- eftermiddagsbris..nn.1
  eftermiddagsjobb_1_N : N ; -- eftermiddagsjobb..nn.1
  eftermiddagskaffe_1_N : N ; -- eftermiddagskaffe..nn.1
  eftermiddagslur_1_N : N ; -- eftermiddagslur..nn.1
  eftermiddagspass_1_N : N ; -- eftermiddagspass..nn.1
  eftermiddagsrusning_1_N : N ; -- eftermiddagsrusning..nn.1
  eftermiddagssejour_1_N : N ; -- eftermiddagssejour..nn.1
  eftermiddagsskymning_1_N : N ; -- eftermiddagsskymning..nn.1
  eftermiddagste_1_N : N ; -- eftermiddagste..nn.1
  eftermiddagstimme_1_N : N ; -- eftermiddagstimme..nn.1
  eftermiddagstrafik_1_N : N ; -- eftermiddagstrafik..nn.1
  eftermogna_1_V : V ; -- eftermogna..vb.1
  eftermognad_1_N : N ; -- eftermognad..nn.1
  eftermognande_1_N : N ; -- eftermognande..nn.1
  eftermäle_1_N : N ; -- eftermäle..nn.1
  efternamn_1_N : N ; -- efternamn..nn.1
  efternatt_1_N : N ; -- efternatt..nn.1
  efterord_1_N : N ; -- efterord..nn.1
  efterplock_1_N : N ; -- efterplock..nn.1
  efterplockning_1_N : N ; -- efterplockning..nn.1
  efterprövning_1_N : N ; -- efterprövning..nn.1
  efterputs_1_N : N ; -- efterputs..nn.1
  efterrationalisera_1_V : V ; -- efterrationalisera..vb.1
  efterrationaliserande_1_N : N ; -- efterrationaliserande..nn.1
  efterrationaliserbar_1_A : A ; -- efterrationaliserbar..av.1
  efterrationaliserbarhet_1_N : N ; -- efterrationaliserbarhet..nn.1
  efterrationalisering_1_N : N ; -- efterrationalisering..nn.1
  efterräkning_1_N : N ; -- efterräkning..nn.1
  efterrätt_1_N : N ; -- efterrätt..nn.1
  efterrättelse_1_N : N ; -- efterrättelse..nn.1
  efterrättssoppa_1_N : N ; -- efterrättssoppa..nn.1
  eftersaknad_1_A : A ; -- eftersaknad..av.1
  eftersaknad_1_N : N ; -- eftersaknad..nn.1
  eftersats_1_N : N ; -- eftersats..nn.1
  efterse_1_V : V ; -- efterse..vb.1
  efterseende_1_N : N ; -- efterseende..nn.1
  eftersinna_1_V : V ; -- eftersinna..vb.1
  eftersinnande_1_A : A ; -- eftersinnande..av.1
  eftersinnande_1_N : N ; -- eftersinnande..nn.1
  eftersits_1_N : N ; -- eftersits..nn.1
  efterskalv_1_N : N ; -- efterskalv..nn.1
  efterskickning_1_N : N ; -- efterskickning..nn.1
  efterskott_1_N : N ; -- efterskott..nn.1
  efterskrift_1_N : N ; -- efterskrift..nn.1
  efterskänka_1_V : V ; -- efterskänka..vb.1
  efterskänkande_1_N : N ; -- efterskänkande..nn.1
  efterskänkning_1_N : N ; -- efterskänkning..nn.1
  efterskörd_1_N : N ; -- efterskörd..nn.1
  efterslag_1_N : N ; -- efterslag..nn.1
  eftersläckning_1_N : N ; -- eftersläckning..nn.1
  eftersläng_1_N : N ; -- eftersläng..nn.1
  eftersläntrande_1_A : A ; -- eftersläntrande..av.1
  eftersläntrare_1_N : N ; -- eftersläntrare..nn.1
  eftersläpning_1_N : N ; -- eftersläpning..nn.1
  efterslåtter_1_N : N ; -- efterslåtter..nn.1
  eftersmak_1_N : N ; -- eftersmak..nn.1
  eftersnack_1_N : N ; -- eftersnack..nn.1
  eftersommar_1_N : N ; -- eftersommar..nn.1
  efterspana_1_V : V ; -- efterspana..vb.1
  efterspanad_1_A : A ; -- efterspanad..av.1
  efterspanande_1_N : N ; -- efterspanande..nn.1
  efterspaning_1_N : N ; -- efterspaning..nn.1
  efterspel_1_N : N ; -- efterspel..nn.1
  efterstava_1_V : V ; -- efterstava..vb.1
  efterstavande_1_N : N ; -- efterstavande..nn.1
  efterstavning_1_N : N ; -- efterstavning..nn.1
  eftersträva_1_V : V ; -- eftersträva..vb.1
  eftersträvande_1_N : N ; -- eftersträvande..nn.1
  eftersträvansvärd_1_A : A ; -- eftersträvansvärd..av.1
  eftersträvansvärdhet_1_N : N ; -- eftersträvansvärdhet..nn.1
  efterstygn_1_N : N ; -- efterstygn..nn.1
  efterställd_1_A : A ; -- efterställd..av.1
  eftersupning_1_N : N ; -- eftersupning..nn.1
  eftersyn_1_N : N ; -- eftersyn..nn.1
  eftersynkronisera_1_V : V ; -- eftersynkronisera..vb.1
  eftersynkroniserande_1_N : N ; -- eftersynkroniserande..nn.1
  eftersynkroniserbar_1_A : A ; -- eftersynkroniserbar..av.1
  eftersynkroniserbarhet_1_N : N ; -- eftersynkroniserbarhet..nn.1
  eftersynkronisering_1_N : N ; -- eftersynkronisering..nn.1
  eftersäga_1_V : V ; -- eftersäga..vb.1
  eftersägande_1_N : N ; -- eftersägande..nn.1
  eftersägare_1_N : N ; -- eftersägare..nn.1
  eftersägning_1_N : N ; -- eftersägning..nn.1
  eftersända_1_V : V ; -- eftersända..vb.1
  eftersändande_1_N : N ; -- eftersändande..nn.1
  eftersändning_1_N : N ; -- eftersändning..nn.1
  eftersätta_1_V : V ; -- eftersätta..vb.1
  eftersättande_1_N : N ; -- eftersättande..nn.1
  eftersättsblad_1_N : N ; -- eftersättsblad..nn.1
  eftersök_1_N : N ; -- eftersök..nn.1
  eftersöka_1_V : V ; -- eftersöka..vb.1
  eftersökande_1_N : N ; -- eftersökande..nn.1
  eftersökning_1_N : N ; -- eftersökning..nn.1
  eftersökt_1_A : A ; -- eftersökt..av.1
  eftersökthet_1_N : N ; -- eftersökthet..nn.1
  eftertanke_1_N : N ; -- eftertanke..nn.1
  eftertaxera_1_V : V ; -- eftertaxera..vb.1
  eftertaxerande_1_N : N ; -- eftertaxerande..nn.1
  eftertaxerbar_1_A : A ; -- eftertaxerbar..av.1
  eftertaxerbarhet_1_N : N ; -- eftertaxerbarhet..nn.1
  eftertaxering_1_N : N ; -- eftertaxering..nn.1
  eftertextnot_1_N : N ; -- eftertextnot..nn.1
  eftertorkning_1_N : N ; -- eftertorkning..nn.1
  eftertrakta_1_V : V ; -- eftertrakta..vb.1
  eftertraktande_1_N : N ; -- eftertraktande..nn.1
  eftertraktansvärd_1_A : A ; -- eftertraktansvärd..av.1
  eftertraktansvärdhet_1_N : N ; -- eftertraktansvärdhet..nn.1
  eftertrav_1_N : N ; -- eftertrav..nn.1
  eftertrupp_1_N : N ; -- eftertrupp..nn.1
  eftertryck_1_N : N ; -- eftertryck..nn.1
  eftertrycklig_1_A : A ; -- eftertrycklig..av.1
  eftertryckligen_1_Adv : Adv ; -- eftertryckligen..ab.1
  eftertrycklighet_1_N : N ; -- eftertrycklighet..nn.1
  efterträda_1_V : V ; -- efterträda..vb.1
  efterträdande_1_N : N ; -- efterträdande..nn.1
  efterträdare_1_N : N ; -- efterträdare..nn.1
  efterträdarkandidat_1_N : N ; -- efterträdarkandidat..nn.1
  eftertrå_1_V : V ; -- eftertrå..vb.1
  eftertrående_1_N : N ; -- eftertrående..nn.1
  eftertänksam_1_A : A ; -- eftertänksam..av.1
  eftertänksamhet_1_N : N ; -- eftertänksamhet..nn.1
  efterundersökning_1_N : N ; -- efterundersökning..nn.1
  efterutbildning_1_N : N ; -- efterutbildning..nn.1
  eftervalsanalys_1_N : N ; -- eftervalsanalys..nn.1
  eftervalsdebatt_1_N : N ; -- eftervalsdebatt..nn.1
  efterverkning_1_N : N ; -- efterverkning..nn.1
  eftervinter_1_N : N ; -- eftervinter..nn.1
  eftervis_1_A : A ; -- eftervis..av.1
  eftervishet_1_N : N ; -- eftervishet..nn.1
  eftervärk_1_N : N ; -- eftervärk..nn.1
  eftervärld_1_N : N ; -- eftervärld..nn.1
  eftervärme_1_N : N ; -- eftervärme..nn.1
  efterväxt_1_N : N ; -- efterväxt..nn.1
  eftervård_1_N : N ; -- eftervård..nn.1
  efteråt_1_Adv : Adv ; -- efteråt..ab.1
  egal_1_A : A ; -- egal..av.1
  egalisera_1_V : V ; -- egalisera..vb.1
  egaliserande_1_N : N ; -- egaliserande..nn.1
  egaliserbar_1_A : A ; -- egaliserbar..av.1
  egaliserbarhet_1_N : N ; -- egaliserbarhet..nn.1
  egalisering_1_N : N ; -- egalisering..nn.1
  egalitet_1_N : N ; -- egalitet..nn.1
  egalitär_1_A : A ; -- egalitär..av.1
  egard_1_N : N ; -- egard..nn.1
  egeisk_1_A : A ; -- egeisk..av.1
  egen_1_A : A ; -- egen..av.1
  egenart_1_N : N ; -- egenart..nn.1
  egenartad_1_A : A ; -- egenartad..av.1
  egendesignad_1_A : A ; -- egendesignad..av.1
  egendiagnos_1_N : N ; -- egendiagnos..nn.1
  egendiagnostik_1_N : N ; -- egendiagnostik..nn.1
  egendom_1_N : N ; -- egendom..nn.1
  egendomlig_1_A : A ; -- egendomlig..av.1
  egendomlighet_1_N : N ; -- egendomlighet..nn.1
  egendomsaffär_1_N : N ; -- egendomsaffär..nn.1
  egendomsbrott_1_N : N ; -- egendomsbrott..nn.1
  egendomsfolk_1_N : N ; -- egendomsfolk..nn.1
  egendomsförsäkring_1_N : N ; -- egendomsförsäkring..nn.1
  egendomsförsäljning_1_N : N ; -- egendomsförsäljning..nn.1
  egendomsgemenskap_1_N : N ; -- egendomsgemenskap..nn.1
  egendomsköp_1_N : N ; -- egendomsköp..nn.1
  egendomslös_1_A : A ; -- egendomslös..av.1
  egendomslöshet_1_N : N ; -- egendomslöshet..nn.1
  egenfrekvens_1_N : N ; -- egenfrekvens..nn.1
  egenhet_1_N : N ; -- egenhet..nn.1
  egenhändig_1_A : A ; -- egenhändig..av.1
  egenhändighet_1_N : N ; -- egenhändighet..nn.1
  egenintresse_1_N : N ; -- egenintresse..nn.1
  egenkomponerad_1_A : A ; -- egenkomponerad..av.1
  egenkonstruerad_1_A : A ; -- egenkonstruerad..av.1
  egenkär_1_A : A ; -- egenkär..av.1
  egenkärlek_1_N : N ; -- egenkärlek..nn.1
  egenmäktig_1_A : A ; -- egenmäktig..av.1
  egenmäktighet_1_N : N ; -- egenmäktighet..nn.1
  egennamn_1_N : N ; -- egennamn..nn.1
  egennytta_1_N : N ; -- egennytta..nn.1
  egennyttig_1_A : A ; -- egennyttig..av.1
  egennyttighet_1_N : N ; -- egennyttighet..nn.1
  egenodlad_1_A : A ; -- egenodlad..av.1
  egenproducerad_1_A : A ; -- egenproducerad..av.1
  egenremiss_1_N : N ; -- egenremiss..nn.1
  egenrättfärdig_1_A : A ; -- egenrättfärdig..av.1
  egenrättfärdighet_1_N : N ; -- egenrättfärdighet..nn.1
  egenrådig_1_A : A ; -- egenrådig..av.1
  egenrådighet_1_N : N ; -- egenrådighet..nn.1
  egenrörelse_1_N : N ; -- egenrörelse..nn.1
  egensinne_1_N : N ; -- egensinne..nn.1
  egensinnig_1_A : A ; -- egensinnig..av.1
  egensinnighet_1_N : N ; -- egensinnighet..nn.1
  egenskap_1_N : N ; -- egenskap..nn.1
  egenskapsgenitiv_1_N : N ; -- egenskapsgenitiv..nn.1
  egenskapsord_1_N : N ; -- egenskapsord..nn.1
  egensvänga_1_V : V ; -- egensvänga..vb.1
  egensvängande_1_N : N ; -- egensvängande..nn.1
  egensvängning_1_N : N ; -- egensvängning..nn.1
  egentid_1_N : N ; -- egentid..nn.1
  egentillverkad_1_A : A ; -- egentillverkad..av.1
  egentlig_1_A : A ; -- egentlig..av.1
  egentligen_1_Adv : Adv ; -- egentligen..ab.1
  egenvarm_1_A : A ; -- egenvarm..av.1
  egenvärde_1_N : N ; -- egenvärde..nn.1
  egg_1_N : N ; -- egg..nn.1
  egga_1_V : V ; -- egga..vb.1
  eggande_1_N : N ; -- eggande..nn.1
  eggelse_1_N : N ; -- eggelse..nn.1
  eggjärn_1_N : N ; -- eggjärn..nn.1
  eggvapen_1_N : N ; -- eggvapen..nn.1
  eggvass_1_A : A ; -- eggvass..av.1
  eggverktyg_1_N : N ; -- eggverktyg..nn.1
  egid_1_N : N ; -- egid..nn.1
  egnahem_1_N : N ; -- egnahem..nn.1
  egoboosta_1_V : V ; -- egoboosta..vb.1
  egoboostande_1_N : N ; -- egoboostande..nn.1
  egoboostning_1_N : N ; -- egoboostning..nn.1
  egocentricitet_1_N : N ; -- egocentricitet..nn.1
  egocentriker_1_N : N ; -- egocentriker..nn.1
  egocentrisk_1_A : A ; -- egocentrisk..av.1
  egoism_1_N : N ; -- egoism..nn.1
  egoist_1_N : N ; -- egoist..nn.1
  egoistisk_1_A : A ; -- egoistisk..av.1
  egotism_1_N : N ; -- egotism..nn.1
  egotripp_1_N : N ; -- egotripp..nn.1
  egotrippad_1_A : A ; -- egotrippad..av.1
  egotrippare_1_N : N ; -- egotrippare..nn.1
  egypter_1_N : N ; -- egypter..nn.1
  egyptienne_1_N : N ; -- egyptienne..nn.1
  egyptier_1_N : N ; -- egyptier..nn.1
  egyptisk_1_A : A ; -- egyptisk..av.1
  egyptiska_1_N : N ; -- egyptiska..nn.1
  egyptiska_2_N : N ; -- egyptiska..nn.2
  egyptolog_1_N : N ; -- egyptolog..nn.1
  egyptologi_1_N : N ; -- egyptologi..nn.1
  egyptomani_1_N : N ; -- egyptomani..nn.1
  ehec_smitta_1_N : N ; -- ehec-smitta..nn.1
  ehec_1_N : N ; -- ehec..nn.1
  eidetik_1_N : N ; -- eidetik..nn.1
  eidetisk_1_A : A ; -- eidetisk..av.1
  einsteinium_1_N : N ; -- einsteinium..nn.1
  einsteinsk_1_A : A ; -- einsteinsk..av.1
  ej_1_Adv : Adv ; -- ej..ab.1
  ejakulat_1_N : N ; -- ejakulat..nn.1
  ejakulation_1_N : N ; -- ejakulation..nn.1
  ejakulera_1_V : V ; -- ejakulera..vb.1
  ejakulerande_1_N : N ; -- ejakulerande..nn.1
  ejakulering_1_N : N ; -- ejakulering..nn.1
  ejder_1_N : N ; -- ejder..nn.1
  ejderdun_1_N : N ; -- ejderdun..nn.1
  ejderdunskudde_1_N : N ; -- ejderdunskudde..nn.1
  ejderhona_1_N : N ; -- ejderhona..nn.1
  ejderunge_1_N : N ; -- ejderunge..nn.1
  ejektor_1_N : N ; -- ejektor..nn.1
  ek_1_N : N ; -- ek..nn.1
  eka_1_N : N ; -- eka..nn.1
  eka_1_V : V ; -- eka..vb.1
  eka_2_V : V ; -- eka..vb.2
  ekande_1_N : N ; -- ekande..nn.1
  ekavverkning_1_N : N ; -- ekavverkning..nn.1
  ekavverkningsförbud_1_N : N ; -- ekavverkningsförbud..nn.1
  ekbacke_1_N : N ; -- ekbacke..nn.1
  ekbock_1_N : N ; -- ekbock..nn.1
  ekdörr_1_N : N ; -- ekdörr..nn.1
  eke_1_N : N ; -- eke..nn.1
  eker_1_N : N ; -- eker..nn.1
  ekfat_1_N : N ; -- ekfat..nn.1
  ekfatslagra_1_V : V ; -- ekfatslagra..vb.1
  ekfatslagrande_1_N : N ; -- ekfatslagrande..nn.1
  ekipage_1_N : N ; -- ekipage..nn.1
  ekipera_1_V : V ; -- ekipera..vb.1
  ekiperande_1_N : N ; -- ekiperande..nn.1
  ekiperbar_1_A : A ; -- ekiperbar..av.1
  ekiperbarhet_1_N : N ; -- ekiperbarhet..nn.1
  ekipering_1_N : N ; -- ekipering..nn.1
  ekiperingsaffär_1_N : N ; -- ekiperingsaffär..nn.1
  ekivok_1_A : A ; -- ekivok..av.1
  eklampsi_1_N : N ; -- eklampsi..nn.1
  eklatant_1_A : A ; -- eklatant..av.1
  eklatera_1_V : V ; -- eklatera..vb.1
  eklaterande_1_N : N ; -- eklaterande..nn.1
  eklaterbar_1_A : A ; -- eklaterbar..av.1
  eklaterbarhet_1_N : N ; -- eklaterbarhet..nn.1
  eklatering_1_N : N ; -- eklatering..nn.1
  eklatt_1_A : A ; -- eklatt..av.1
  eklekticism_1_N : N ; -- eklekticism..nn.1
  eklektiker_1_N : N ; -- eklektiker..nn.1
  eklektisk_1_A : A ; -- eklektisk..av.1
  eklips_1_N : N ; -- eklips..nn.1
  ekliptika_1_N : N ; -- ekliptika..nn.1
  eklog_1_N : N ; -- eklog..nn.1
  eklut_1_N : N ; -- eklut..nn.1
  eklärera_1_V : V ; -- eklärera..vb.1
  eklärerande_1_N : N ; -- eklärerande..nn.1
  eklärerbar_1_A : A ; -- eklärerbar..av.1
  eklärerbarhet_1_N : N ; -- eklärerbarhet..nn.1
  eklärering_1_N : N ; -- eklärering..nn.1
  eklöv_1_N : N ; -- eklöv..nn.1
  eko_porr_1_N : N ; -- eko-porr..nn.1
  eko_1_N : N ; -- eko..nn.1
  ekoaktivism_1_N : N ; -- ekoaktivism..nn.1
  ekoaktivist_1_N : N ; -- ekoaktivist..nn.1
  ekobrott_1_N : N ; -- ekobrott..nn.1
  ekofascistisk_1_A : A ; -- ekofascistisk..av.1
  ekokammare_1_N : N ; -- ekokammare..nn.1
  ekollon_1_N : N ; -- ekollon..nn.1
  ekolobby_1_N : N ; -- ekolobby..nn.1
  ekolod_1_N : N ; -- ekolod..nn.1
  ekoloda_1_V : V ; -- ekoloda..vb.1
  ekolodande_1_N : N ; -- ekolodande..nn.1
  ekolog_1_N : N ; -- ekolog..nn.1
  ekologi_1_N : N ; -- ekologi..nn.1
  ekologisk_1_A : A ; -- ekologisk..av.1
  ekonom_1_N : N ; -- ekonom..nn.1
  ekonometri_1_N : N ; -- ekonometri..nn.1
  ekonomexamen_1_N : N ; -- ekonomexamen..nn.1
  ekonomi_1_N : N ; -- ekonomi..nn.1
  ekonomiansvarig_1_A : A ; -- ekonomiansvarig..av.1
  ekonomiavdelning_1_N : N ; -- ekonomiavdelning..nn.1
  ekonomibiträde_1_N : N ; -- ekonomibiträde..nn.1
  ekonomibrev_1_N : N ; -- ekonomibrev..nn.1
  ekonomibyggnad_1_N : N ; -- ekonomibyggnad..nn.1
  ekonomichef_1_N : N ; -- ekonomichef..nn.1
  ekonomie_1_A : A ; -- ekonomie..av.1
  ekonomiföreståndare_1_N : N ; -- ekonomiföreståndare..nn.1
  ekonomiförpackning_1_N : N ; -- ekonomiförpackning..nn.1
  ekonomiförvaltare_1_N : N ; -- ekonomiförvaltare..nn.1
  ekonomiklass_1_N : N ; -- ekonomiklass..nn.1
  ekonomikrönikör_1_N : N ; -- ekonomikrönikör..nn.1
  ekonomilära_1_N : N ; -- ekonomilära..nn.1
  ekonomipaket_1_N : N ; -- ekonomipaket..nn.1
  ekonomipersonal_1_N : N ; -- ekonomipersonal..nn.1
  ekonomirätt_1_N : N ; -- ekonomirätt..nn.1
  ekonomisera_1_V : V ; -- ekonomisera..vb.1
  ekonomiserande_1_N : N ; -- ekonomiserande..nn.1
  ekonomiserbar_1_A : A ; -- ekonomiserbar..av.1
  ekonomiserbarhet_1_N : N ; -- ekonomiserbarhet..nn.1
  ekonomisering_1_N : N ; -- ekonomisering..nn.1
  ekonomisk_politisk_1_A : A ; -- ekonomisk-politisk..av.1
  ekonomisk_1_A : A ; -- ekonomisk..av.1
  ekonomisk_2_A : A ; -- ekonomisk..av.2
  ekonomiskpolitisk_1_A : A ; -- ekonomiskpolitisk..av.1
  ekonomiskt_politisk_1_A : A ; -- ekonomiskt-politisk..av.1
  ekonomisktpolitisk_1_A : A ; -- ekonomisktpolitisk..av.1
  ekonomiutbildning_1_N : N ; -- ekonomiutbildning..nn.1
  ekonomlinje_1_N : N ; -- ekonomlinje..nn.1
  ekonomutbildning_1_N : N ; -- ekonomutbildning..nn.1
  ekoodlad_1_A : A ; -- ekoodlad..av.1
  ekoporr_1_N : N ; -- ekoporr..nn.1
  ekoradio_1_N : N ; -- ekoradio..nn.1
  ekorrbär_1_N : N ; -- ekorrbär..nn.1
  ekorrdjur_1_N : N ; -- ekorrdjur..nn.1
  ekorre_1_N : N ; -- ekorre..nn.1
  ekorrhjul_1_N : N ; -- ekorrhjul..nn.1
  ekorrliknande_1_A : A ; -- ekorrliknande..av.1
  ekorröd_1_A : A ; -- ekorröd..av.1
  ekosystem_1_N : N ; -- ekosystem..nn.1
  ekoturist_1_N : N ; -- ekoturist..nn.1
  ekotyp_1_N : N ; -- ekotyp..nn.1
  ekovin_1_N : N ; -- ekovin..nn.1
  ekoxe_1_N : N ; -- ekoxe..nn.1
  ekrin_1_A : A ; -- ekrin..av.1
  eksem_1_N : N ; -- eksem..nn.1
  ekskog_1_N : N ; -- ekskog..nn.1
  ekspinnare_1_N : N ; -- ekspinnare..nn.1
  ekstock_1_N : N ; -- ekstock..nn.1
  ektoderm_1_N : N ; -- ektoderm..nn.1
  ektomi_1_N : N ; -- ektomi..nn.1
  ekumenik_1_N : N ; -- ekumenik..nn.1
  ekumenisk_1_A : A ; -- ekumenisk..av.1
  ekumenism_1_N : N ; -- ekumenism..nn.1
  ekvation_1_N : N ; -- ekvation..nn.1
  ekvatorial_1_A : A ; -- ekvatorial..av.1
  ekvatorialbälte_1_N : N ; -- ekvatorialbälte..nn.1
  ekvatorialguinean_1_N : N ; -- ekvatorialguinean..nn.1
  ekvatorialguineansk_1_A : A ; -- ekvatorialguineansk..av.1
  ekvatorialguineanska_1_N : N ; -- ekvatorialguineanska..nn.1
  ekvatorialström_1_N : N ; -- ekvatorialström..nn.1
  ekvatorialzon_1_N : N ; -- ekvatorialzon..nn.1
  ekvatoriell_1_A : A ; -- ekvatoriell..av.1
  ekvatorshöjd_1_N : N ; -- ekvatorshöjd..nn.1
  ekvatorsplan_1_N : N ; -- ekvatorsplan..nn.1
  ekvecklare_1_N : N ; -- ekvecklare..nn.1
  ekvidistans_1_N : N ; -- ekvidistans..nn.1
  ekvidistant_1_A : A ; -- ekvidistant..av.1
  ekvilibrera_1_V : V ; -- ekvilibrera..vb.1
  ekvilibrerande_1_N : N ; -- ekvilibrerande..nn.1
  ekvilibrist_1_N : N ; -- ekvilibrist..nn.1
  ekvilibristik_1_N : N ; -- ekvilibristik..nn.1
  ekvilibristisk_1_A : A ; -- ekvilibristisk..av.1
  ekvilibrium_1_N : N ; -- ekvilibrium..nn.1
  ekvipotentiallinje_1_N : N ; -- ekvipotentiallinje..nn.1
  ekvipotentialyta_1_N : N ; -- ekvipotentialyta..nn.1
  ekvirke_1_N : N ; -- ekvirke..nn.1
  ekvivalens_1_N : N ; -- ekvivalens..nn.1
  ekvivalent_1_A : A ; -- ekvivalent..av.1
  ekvivalent_1_N : N ; -- ekvivalent..nn.1
  ekvivalentvikt_1_N : N ; -- ekvivalentvikt..nn.1
  el_1_N : N ; -- el..nn.1
  elaborera_1_V : V ; -- elaborera..vb.1
  elaborerande_1_N : N ; -- elaborerande..nn.1
  elaborerbar_1_A : A ; -- elaborerbar..av.1
  elaborerbarhet_1_N : N ; -- elaborerbarhet..nn.1
  elaborering_1_N : N ; -- elaborering..nn.1
  elak_1_A : A ; -- elak..av.1
  elakartad_1_A : A ; -- elakartad..av.1
  elakhet_1_N : N ; -- elakhet..nn.1
  elaking_1_N : N ; -- elaking..nn.1
  elallergi_1_N : N ; -- elallergi..nn.1
  eland_1_N : N ; -- eland..nn.1
  elandantilop_1_N : N ; -- elandantilop..nn.1
  elapparat_1_N : N ; -- elapparat..nn.1
  elasticitet_1_N : N ; -- elasticitet..nn.1
  elasticitetsgräns_1_N : N ; -- elasticitetsgräns..nn.1
  elastisera_1_V : V ; -- elastisera..vb.1
  elastiserande_1_N : N ; -- elastiserande..nn.1
  elastiserbar_1_A : A ; -- elastiserbar..av.1
  elastiserbarhet_1_N : N ; -- elastiserbarhet..nn.1
  elastisering_1_N : N ; -- elastisering..nn.1
  elastisk_1_A : A ; -- elastisk..av.1
  elativ_1_N : N ; -- elativ..nn.1
  elavbrott_1_N : N ; -- elavbrott..nn.1
  elavläsning_1_N : N ; -- elavläsning..nn.1
  elbil_1_N : N ; -- elbil..nn.1
  elbilsförespråkare_1_N : N ; -- elbilsförespråkare..nn.1
  elbilspionjär_1_N : N ; -- elbilspionjär..nn.1
  elborste_1_N : N ; -- elborste..nn.1
  elbörs_1_N : N ; -- elbörs..nn.1
  elchock_1_N : N ; -- elchock..nn.1
  eld_1_N : N ; -- eld..nn.1
  eld_2_N : N ; -- eld..nn.2
  eld_3_N : N ; -- eld..nn.3
  elda_1_V : V ; -- elda..vb.1
  eldande_1_N : N ; -- eldande..nn.1
  eldare_1_N : N ; -- eldare..nn.1
  eldavstånd_1_N : N ; -- eldavstånd..nn.1
  eldbegängelse_1_N : N ; -- eldbegängelse..nn.1
  eldbrand_1_N : N ; -- eldbrand..nn.1
  elddisciplin_1_N : N ; -- elddisciplin..nn.1
  elddon_1_N : N ; -- elddon..nn.1
  elddop_1_N : N ; -- elddop..nn.1
  elddyrkare_1_N : N ; -- elddyrkare..nn.1
  eldfara_1_N : N ; -- eldfara..nn.1
  eldfarlig_1_A : A ; -- eldfarlig..av.1
  eldfarlighet_1_N : N ; -- eldfarlighet..nn.1
  eldfast_1_A : A ; -- eldfast..av.1
  eldfasthet_1_N : N ; -- eldfasthet..nn.1
  eldfluga_1_N : N ; -- eldfluga..nn.1
  eldfängd_1_A : A ; -- eldfängd..av.1
  eldfängdhet_1_N : N ; -- eldfängdhet..nn.1
  eldgaffel_1_N : N ; -- eldgaffel..nn.1
  eldgaffelsrak_1_A : A ; -- eldgaffelsrak..av.1
  eldgivning_1_N : N ; -- eldgivning..nn.1
  eldgnista_1_N : N ; -- eldgnista..nn.1
  eldhandvapen_1_N : N ; -- eldhandvapen..nn.1
  eldhastighet_1_N : N ; -- eldhastighet..nn.1
  eldhav_1_N : N ; -- eldhav..nn.1
  eldhund_1_N : N ; -- eldhund..nn.1
  eldhus_1_N : N ; -- eldhus..nn.1
  eldhärd_1_N : N ; -- eldhärd..nn.1
  eldhärdig_1_A : A ; -- eldhärdig..av.1
  eldhärdighet_1_N : N ; -- eldhärdighet..nn.1
  eldhärja_1_V : V ; -- eldhärja..vb.1
  eldhärjande_1_N : N ; -- eldhärjande..nn.1
  eldig_1_A : A ; -- eldig..av.1
  eldighet_1_N : N ; -- eldighet..nn.1
  eldkanal_1_N : N ; -- eldkanal..nn.1
  eldkastare_1_N : N ; -- eldkastare..nn.1
  eldkol_1_N : N ; -- eldkol..nn.1
  eldkommando_1_N : N ; -- eldkommando..nn.1
  eldkraft_1_N : N ; -- eldkraft..nn.1
  eldkula_1_N : N ; -- eldkula..nn.1
  eldkvast_1_N : N ; -- eldkvast..nn.1
  eldledare_1_N : N ; -- eldledare..nn.1
  eldledning_1_N : N ; -- eldledning..nn.1
  eldlinje_1_N : N ; -- eldlinje..nn.1
  eldning_1_N : N ; -- eldning..nn.1
  eldningsolja_1_N : N ; -- eldningsolja..nn.1
  eldorado_1_N : N ; -- eldorado..nn.1
  eldpelare_1_N : N ; -- eldpelare..nn.1
  eldprov_1_N : N ; -- eldprov..nn.1
  eldredskap_1_N : N ; -- eldredskap..nn.1
  eldregn_1_N : N ; -- eldregn..nn.1
  eldrift_1_N : N ; -- eldrift..nn.1
  eldriven_1_A : A ; -- eldriven..av.1
  eldrum_1_N : N ; -- eldrum..nn.1
  eldröd_1_A : A ; -- eldröd..av.1
  eldrör_1_N : N ; -- eldrör..nn.1
  eldsalamander_1_N : N ; -- eldsalamander..nn.1
  eldsats_1_N : N ; -- eldsats..nn.1
  eldsdyrkare_1_N : N ; -- eldsdyrkare..nn.1
  eldsignal_1_N : N ; -- eldsignal..nn.1
  eldsignalering_1_N : N ; -- eldsignalering..nn.1
  eldsjäl_1_N : N ; -- eldsjäl..nn.1
  eldsken_1_N : N ; -- eldsken..nn.1
  eldskrift_1_N : N ; -- eldskrift..nn.1
  eldskur_1_N : N ; -- eldskur..nn.1
  eldskydd_1_N : N ; -- eldskydd..nn.1
  eldsljus_1_N : N ; -- eldsljus..nn.1
  eldslukare_1_N : N ; -- eldslukare..nn.1
  eldsläckare_1_N : N ; -- eldsläckare..nn.1
  eldsläckning_1_N : N ; -- eldsläckning..nn.1
  eldsländare_1_N : N ; -- eldsländare..nn.1
  eldslåga_1_N : N ; -- eldslåga..nn.1
  eldsmärke_1_N : N ; -- eldsmärke..nn.1
  eldspruta_1_N : N ; -- eldspruta..nn.1
  eldsprutande_1_A : A ; -- eldsprutande..av.1
  eldstad_1_N : N ; -- eldstad..nn.1
  eldstod_1_N : N ; -- eldstod..nn.1
  eldstorm_1_N : N ; -- eldstorm..nn.1
  eldstrid_1_N : N ; -- eldstrid..nn.1
  eldstrimma_1_N : N ; -- eldstrimma..nn.1
  eldställning_1_N : N ; -- eldställning..nn.1
  eldstål_1_N : N ; -- eldstål..nn.1
  eldsvåda_1_N : N ; -- eldsvåda..nn.1
  eldsvådetillbud_1_N : N ; -- eldsvådetillbud..nn.1
  eldsvådeunge_1_N : N ; -- eldsvådeunge..nn.1
  eldsäker_1_A : A ; -- eldsäker..av.1
  eldsäkerhet_1_N : N ; -- eldsäkerhet..nn.1
  eldsäkra_1_V : V ; -- eldsäkra..vb.1
  eldsäkrande_1_N : N ; -- eldsäkrande..nn.1
  eldtång_1_N : N ; -- eldtång..nn.1
  eldunderstöd_1_N : N ; -- eldunderstöd..nn.1
  eldupphör_1_N : N ; -- eldupphör..nn.1
  eldupphörorder_1_N : N ; -- eldupphörorder..nn.1
  eldvakt_1_N : N ; -- eldvakt..nn.1
  eldvakta_1_V : V ; -- eldvakta..vb.1
  eldvaktande_1_N : N ; -- eldvaktande..nn.1
  eldvaktare_1_N : N ; -- eldvaktare..nn.1
  eldvapen_1_N : N ; -- eldvapen..nn.1
  eldyta_1_N : N ; -- eldyta..nn.1
  eldöverfall_1_N : N ; -- eldöverfall..nn.1
  elefant_1_N : N ; -- elefant..nn.1
  elefantbete_1_N : N ; -- elefantbete..nn.1
  elefantgräs_1_N : N ; -- elefantgräs..nn.1
  elefanthanne_1_N : N ; -- elefanthanne..nn.1
  elefanthud_1_N : N ; -- elefanthud..nn.1
  elefantinhopp_1_N : N ; -- elefantinhopp..nn.1
  elefantnäbbmus_1_N : N ; -- elefantnäbbmus..nn.1
  elefantsjuka_1_N : N ; -- elefantsjuka..nn.1
  elefantsköldpadda_1_N : N ; -- elefantsköldpadda..nn.1
  elefantupplopp_1_N : N ; -- elefantupplopp..nn.1
  elegans_1_N : N ; -- elegans..nn.1
  elegant_1_A : A ; -- elegant..av.1
  elegi_1_N : N ; -- elegi..nn.1
  elegisk_1_A : A ; -- elegisk..av.1
  elektor_1_N : N ; -- elektor..nn.1
  elektorsröst_1_N : N ; -- elektorsröst..nn.1
  elektorsval_1_N : N ; -- elektorsval..nn.1
  elektricitet_1_N : N ; -- elektricitet..nn.1
  elektricitetsmängd_1_N : N ; -- elektricitetsmängd..nn.1
  elektricitetsorsakad_1_A : A ; -- elektricitetsorsakad..av.1
  elektricitetsverk_1_N : N ; -- elektricitetsverk..nn.1
  elektrificera_1_V : V ; -- elektrificera..vb.1
  elektrificerande_1_N : N ; -- elektrificerande..nn.1
  elektrificerbar_1_A : A ; -- elektrificerbar..av.1
  elektrificerbarhet_1_N : N ; -- elektrificerbarhet..nn.1
  elektrificering_1_N : N ; -- elektrificering..nn.1
  elektrifiera_1_V : V ; -- elektrifiera..vb.1
  elektrifierande_1_N : N ; -- elektrifierande..nn.1
  elektrifierbar_1_A : A ; -- elektrifierbar..av.1
  elektrifierbarhet_1_N : N ; -- elektrifierbarhet..nn.1
  elektrifiering_1_N : N ; -- elektrifiering..nn.1
  elektriker_1_N : N ; -- elektriker..nn.1
  elektrikermejsel_1_N : N ; -- elektrikermejsel..nn.1
  elektrikermejselsats_1_N : N ; -- elektrikermejselsats..nn.1
  elektrisera_1_V : V ; -- elektrisera..vb.1
  elektriserande_1_N : N ; -- elektriserande..nn.1
  elektriserbar_1_A : A ; -- elektriserbar..av.1
  elektriserbarhet_1_N : N ; -- elektriserbarhet..nn.1
  elektrisering_1_N : N ; -- elektrisering..nn.1
  elektrisk_1_A : A ; -- elektrisk..av.1
  elektroakustik_1_N : N ; -- elektroakustik..nn.1
  elektroakustisk_1_A : A ; -- elektroakustisk..av.1
  elektrochock_1_N : N ; -- elektrochock..nn.1
  elektrod_1_N : N ; -- elektrod..nn.1
  elektrodynamik_1_N : N ; -- elektrodynamik..nn.1
  elektroencefalografi_1_N : N ; -- elektroencefalografi..nn.1
  elektroencefalogram_1_N : N ; -- elektroencefalogram..nn.1
  elektrofilter_1_N : N ; -- elektrofilter..nn.1
  elektrofor_1_N : N ; -- elektrofor..nn.1
  elektrofores_1_N : N ; -- elektrofores..nn.1
  elektrofysik_1_N : N ; -- elektrofysik..nn.1
  elektrofysiologi_1_N : N ; -- elektrofysiologi..nn.1
  elektroingenjör_1_N : N ; -- elektroingenjör..nn.1
  elektrokardiografi_1_N : N ; -- elektrokardiografi..nn.1
  elektrokardiogram_1_N : N ; -- elektrokardiogram..nn.1
  elektrokemi_1_N : N ; -- elektrokemi..nn.1
  elektrokemisk_1_A : A ; -- elektrokemisk..av.1
  elektrolys_1_N : N ; -- elektrolys..nn.1
  elektrolyt_1_N : N ; -- elektrolyt..nn.1
  elektrolytisk_1_A : A ; -- elektrolytisk..av.1
  elektromagnet_1_N : N ; -- elektromagnet..nn.1
  elektromagnetisk_1_A : A ; -- elektromagnetisk..av.1
  elektromagnetism_1_N : N ; -- elektromagnetism..nn.1
  elektromekanisk_1_A : A ; -- elektromekanisk..av.1
  elektrometallurgi_1_N : N ; -- elektrometallurgi..nn.1
  elektrometer_1_N : N ; -- elektrometer..nn.1
  elektromotor_1_N : N ; -- elektromotor..nn.1
  elektromotorisk_1_A : A ; -- elektromotorisk..av.1
  elektron_1_N : N ; -- elektron..nn.1
  elektron_2_N : N ; -- elektron..nn.2
  elektronbana_1_N : N ; -- elektronbana..nn.1
  elektronblixt_1_N : N ; -- elektronblixt..nn.1
  elektronegativitet_1_N : N ; -- elektronegativitet..nn.1
  elektronhölje_1_N : N ; -- elektronhölje..nn.1
  elektronik_1_N : N ; -- elektronik..nn.1
  elektronikkedja_1_N : N ; -- elektronikkedja..nn.1
  elektronikkomponent_1_N : N ; -- elektronikkomponent..nn.1
  elektronikmejsel_1_N : N ; -- elektronikmejsel..nn.1
  elektronisk_1_A : A ; -- elektronisk..av.1
  elektronkamera_1_N : N ; -- elektronkamera..nn.1
  elektronmikroskop_1_N : N ; -- elektronmikroskop..nn.1
  elektronmikroskopbild_1_N : N ; -- elektronmikroskopbild..nn.1
  elektronmikroskopi_1_N : N ; -- elektronmikroskopi..nn.1
  elektronmoln_1_N : N ; -- elektronmoln..nn.1
  elektronneutrino_1_N : N ; -- elektronneutrino..nn.1
  elektronpar_1_N : N ; -- elektronpar..nn.1
  elektronparbindning_1_N : N ; -- elektronparbindning..nn.1
  elektronrör_1_N : N ; -- elektronrör..nn.1
  elektronrörsdiod_1_N : N ; -- elektronrörsdiod..nn.1
  elektronskal_1_N : N ; -- elektronskal..nn.1
  elektronstråle_1_N : N ; -- elektronstråle..nn.1
  elektronugn_1_N : N ; -- elektronugn..nn.1
  elektronvolt_1_N : N ; -- elektronvolt..nn.1
  elektroskop_1_N : N ; -- elektroskop..nn.1
  elektrostatik_1_N : N ; -- elektrostatik..nn.1
  elektrostatisk_1_A : A ; -- elektrostatisk..av.1
  elektrostriktion_1_N : N ; -- elektrostriktion..nn.1
  elektrostål_1_N : N ; -- elektrostål..nn.1
  elektrosvag_1_A : A ; -- elektrosvag..av.1
  elektroteknik_1_N : N ; -- elektroteknik..nn.1
  elektrotekniker_1_N : N ; -- elektrotekniker..nn.1
  elektroteknisk_1_A : A ; -- elektroteknisk..av.1
  elektroterapi_1_N : N ; -- elektroterapi..nn.1
  elektrotyp_1_N : N ; -- elektrotyp..nn.1
  element_1_N : N ; -- element..nn.1
  elementa_1_N : N ; -- elementa..nn.1
  elementaranalys_1_N : N ; -- elementaranalys..nn.1
  elementarande_1_N : N ; -- elementarande..nn.1
  elementarbok_1_N : N ; -- elementarbok..nn.1
  elementarladdning_1_N : N ; -- elementarladdning..nn.1
  elementarläroverk_1_N : N ; -- elementarläroverk..nn.1
  elementarpartikel_1_N : N ; -- elementarpartikel..nn.1
  elementarskola_1_N : N ; -- elementarskola..nn.1
  elementfärg_1_N : N ; -- elementfärg..nn.1
  elementpensel_1_N : N ; -- elementpensel..nn.1
  elementär_1_A : A ; -- elementär..av.1
  elementärkraft_1_N : N ; -- elementärkraft..nn.1
  elenergi_1_N : N ; -- elenergi..nn.1
  elev_1_N : N ; -- elev..nn.1
  elevation_1_N : N ; -- elevation..nn.1
  elevator_1_N : N ; -- elevator..nn.1
  elevfartyg_1_N : N ; -- elevfartyg..nn.1
  elevhem_1_N : N ; -- elevhem..nn.1
  elevhälsovård_1_N : N ; -- elevhälsovård..nn.1
  elevlista_1_N : N ; -- elevlista..nn.1
  elevråd_1_N : N ; -- elevråd..nn.1
  elevskola_1_N : N ; -- elevskola..nn.1
  elevunderlag_1_N : N ; -- elevunderlag..nn.1
  elevvård_1_N : N ; -- elevvård..nn.1
  elfenben_1_N : N ; -- elfenben..nn.1
  elfenbensbit_1_N : N ; -- elfenbensbit..nn.1
  elfenbensfärgad_1_A : A ; -- elfenbensfärgad..av.1
  elfenbenspalm_1_N : N ; -- elfenbenspalm..nn.1
  elfenbenspapper_1_N : N ; -- elfenbenspapper..nn.1
  elfenbenssvärta_1_N : N ; -- elfenbenssvärta..nn.1
  elfenbenstorn_1_N : N ; -- elfenbenstorn..nn.1
  elfenbensvit_1_A : A ; -- elfenbensvit..av.1
  elfordon_1_N : N ; -- elfordon..nn.1
  elfte_1_A : A ; -- elfte..av.1
  elfteplats_1_N : N ; -- elfteplats..nn.1
  elförbrukning_1_N : N ; -- elförbrukning..nn.1
  elförsörjning_1_N : N ; -- elförsörjning..nn.1
  elförzinkad_1_A : A ; -- elförzinkad..av.1
  elgenerator_1_N : N ; -- elgenerator..nn.1
  elgitarr_1_N : N ; -- elgitarr..nn.1
  elgräsklippare_1_N : N ; -- elgräsklippare..nn.1
  elhybrid_1_N : N ; -- elhybrid..nn.1
  elhybridbil_1_N : N ; -- elhybridbil..nn.1
  elhyvel_1_N : N ; -- elhyvel..nn.1
  elidera_1_V : V ; -- elidera..vb.1
  eliderande_1_N : N ; -- eliderande..nn.1
  eliderbar_1_A : A ; -- eliderbar..av.1
  eliderbarhet_1_N : N ; -- eliderbarhet..nn.1
  elidering_1_N : N ; -- elidering..nn.1
  elimination_1_N : N ; -- elimination..nn.1
  eliminera_1_V : V ; -- eliminera..vb.1
  eliminerande_1_N : N ; -- eliminerande..nn.1
  eliminerbar_1_A : A ; -- eliminerbar..av.1
  eliminerbarhet_1_N : N ; -- eliminerbarhet..nn.1
  eliminering_1_N : N ; -- eliminering..nn.1
  elintensiv_1_A : A ; -- elintensiv..av.1
  elisabetansk_1_A : A ; -- elisabetansk..av.1
  elision_1_N : N ; -- elision..nn.1
  elit_1_N : N ; -- elit..nn.1
  elitförband_1_N : N ; -- elitförband..nn.1
  elitgymnastik_1_N : N ; -- elitgymnastik..nn.1
  elitidrott_1_N : N ; -- elitidrott..nn.1
  elitidrottsman_1_N : N ; -- elitidrottsman..nn.1
  elitisk_1_A : A ; -- elitisk..av.1
  elitism_1_N : N ; -- elitism..nn.1
  elitistisk_1_A : A ; -- elitistisk..av.1
  elitkår_1_N : N ; -- elitkår..nn.1
  elitlag_1_N : N ; -- elitlag..nn.1
  elitmässig_1_A : A ; -- elitmässig..av.1
  elitnivå_1_N : N ; -- elitnivå..nn.1
  elitserie_1_N : N ; -- elitserie..nn.1
  elitseriemässig_1_A : A ; -- elitseriemässig..av.1
  elitsoldat_1_N : N ; -- elitsoldat..nn.1
  elitteori_1_N : N ; -- elitteori..nn.1
  elittrupp_1_N : N ; -- elittrupp..nn.1
  elittänk_1_N : N ; -- elittänk..nn.1
  elittänkande_1_N : N ; -- elittänkande..nn.1
  elixir_1_N : N ; -- elixir..nn.1
  eljes_1_Adv : Adv ; -- eljes..ab.1
  eljest_1_Adv : Adv ; -- eljest..ab.1
  elkabel_1_N : N ; -- elkabel..nn.1
  elkedjesåg_1_N : N ; -- elkedjesåg..nn.1
  elkonsumtion_1_N : N ; -- elkonsumtion..nn.1
  elkoppling_1_N : N ; -- elkoppling..nn.1
  elkraft_1_N : N ; -- elkraft..nn.1
  elkraftsaggregat_1_N : N ; -- elkraftsaggregat..nn.1
  elledning_1_N : N ; -- elledning..nn.1
  ellips_1_N : N ; -- ellips..nn.1
  ellipsformad_1_A : A ; -- ellipsformad..av.1
  ellipsoid_1_N : N ; -- ellipsoid..nn.1
  elliptisk_1_A : A ; -- elliptisk..av.1
  elljus_1_N : N ; -- elljus..nn.1
  elljusslinga_1_N : N ; -- elljusslinga..nn.1
  elljusspår_1_N : N ; -- elljusspår..nn.1
  ellok_1_N : N ; -- ellok..nn.1
  elmanövrerad_1_A : A ; -- elmanövrerad..av.1
  elmarknad_1_N : N ; -- elmarknad..nn.1
  elmotor_1_N : N ; -- elmotor..nn.1
  elmotordrift_1_N : N ; -- elmotordrift..nn.1
  elmotordriven_1_A : A ; -- elmotordriven..av.1
  elmseld_1_N : N ; -- elmseld..nn.1
  elmutterdragare_1_N : N ; -- elmutterdragare..nn.1
  elmätare_1_N : N ; -- elmätare..nn.1
  elnät_1_N : N ; -- elnät..nn.1
  eloge_1_N : N ; -- eloge..nn.1
  elokvens_1_N : N ; -- elokvens..nn.1
  elokvent_1_A : A ; -- elokvent..av.1
  elongation_1_N : N ; -- elongation..nn.1
  eloquentia_1_N : N ; -- eloquentia..nn.1
  elorgel_1_N : N ; -- elorgel..nn.1
  eloxera_1_V : V ; -- eloxera..vb.1
  eloxerande_1_N : N ; -- eloxerande..nn.1
  eloxerbar_1_A : A ; -- eloxerbar..av.1
  eloxerbarhet_1_N : N ; -- eloxerbarhet..nn.1
  eloxering_1_N : N ; -- eloxering..nn.1
  elpistol_1_N : N ; -- elpistol..nn.1
  elplatta_1_N : N ; -- elplatta..nn.1
  elpris_1_N : N ; -- elpris..nn.1
  elpropp_1_N : N ; -- elpropp..nn.1
  elritsa_1_N : N ; -- elritsa..nn.1
  elsevir_1_N : N ; -- elsevir..nn.1
  elskandal_1_N : N ; -- elskandal..nn.1
  elskrot_1_N : N ; -- elskrot..nn.1
  elspis_1_N : N ; -- elspis..nn.1
  elstolpe_1_N : N ; -- elstolpe..nn.1
  elström_1_N : N ; -- elström..nn.1
  elstängsel_1_N : N ; -- elstängsel..nn.1
  elstöt_1_N : N ; -- elstöt..nn.1
  eltejp_1_N : N ; -- eltejp..nn.1
  eludera_1_V : V ; -- eludera..vb.1
  eluderande_1_N : N ; -- eluderande..nn.1
  eluderbar_1_A : A ; -- eluderbar..av.1
  eluderbarhet_1_N : N ; -- eluderbarhet..nn.1
  eludering_1_N : N ; -- eludering..nn.1
  eluera_1_V : V ; -- eluera..vb.1
  eluerande_1_N : N ; -- eluerande..nn.1
  eluerbar_1_A : A ; -- eluerbar..av.1
  eluerbarhet_1_N : N ; -- eluerbarhet..nn.1
  eluering_1_N : N ; -- eluering..nn.1
  elusion_1_N : N ; -- elusion..nn.1
  eluttag_1_N : N ; -- eluttag..nn.1
  eluvial_1_A : A ; -- eluvial..av.1
  eluvium_1_N : N ; -- eluvium..nn.1
  elva_1_N : N ; -- elva..nn.1
  elvadimensionell_1_A : A ; -- elvadimensionell..av.1
  elvahundratal_1_N : N ; -- elvahundratal..nn.1
  elvamannalag_1_N : N ; -- elvamannalag..nn.1
  elvaårig_1_A : A ; -- elvaårig..av.1
  elvaåring_1_N : N ; -- elvaåring..nn.1
  elvaårsgräns_1_N : N ; -- elvaårsgräns..nn.1
  elvaårsperiod_1_N : N ; -- elvaårsperiod..nn.1
  elverk_1_N : N ; -- elverk..nn.1
  elvisp_1_N : N ; -- elvisp..nn.1
  elvispfabrik_1_N : N ; -- elvispfabrik..nn.1
  elvärme_1_N : N ; -- elvärme..nn.1
  elyseisk_1_A : A ; -- elyseisk..av.1
  elzevier_1_N : N ; -- elzevier..nn.1
  elända_1_A : A ; -- elända..av.1
  elände_1_N : N ; -- elände..nn.1
  eländesförutsägelse_1_N : N ; -- eländesförutsägelse..nn.1
  eländesrapportering_1_N : N ; -- eländesrapportering..nn.1
  eländesskildring_1_N : N ; -- eländesskildring..nn.1
  eländig_1_A : A ; -- eländig..av.1
  eländighet_1_N : N ; -- eländighet..nn.1
  elöverkänslig_1_A : A ; -- elöverkänslig..av.1
  email_1_N : N ; -- email..nn.1
  email_2_N : N ; -- email..nn.2
  emalj_1_N : N ; -- emalj..nn.1
  emaljera_1_V : V ; -- emaljera..vb.1
  emaljerande_1_N : N ; -- emaljerande..nn.1
  emaljerbar_1_A : A ; -- emaljerbar..av.1
  emaljerbarhet_1_N : N ; -- emaljerbarhet..nn.1
  emaljering_1_N : N ; -- emaljering..nn.1
  emaljfyllning_1_N : N ; -- emaljfyllning..nn.1
  emaljfärg_1_N : N ; -- emaljfärg..nn.1
  emaljglas_1_N : N ; -- emaljglas..nn.1
  emaljinläggning_1_N : N ; -- emaljinläggning..nn.1
  emaljlack_1_N : N ; -- emaljlack..nn.1
  emaljmålning_1_N : N ; -- emaljmålning..nn.1
  emaljplomb_1_N : N ; -- emaljplomb..nn.1
  emaljöga_1_N : N ; -- emaljöga..nn.1
  emaljör_1_N : N ; -- emaljör..nn.1
  emanation_1_N : N ; -- emanation..nn.1
  emancipation_1_N : N ; -- emancipation..nn.1
  emancipera_1_V : V ; -- emancipera..vb.1
  emanciperande_1_N : N ; -- emanciperande..nn.1
  emanciperbar_1_A : A ; -- emanciperbar..av.1
  emanciperbarhet_1_N : N ; -- emanciperbarhet..nn.1
  emancipering_1_N : N ; -- emancipering..nn.1
  emanera_1_V : V ; -- emanera..vb.1
  emanerande_1_N : N ; -- emanerande..nn.1
  emanering_1_N : N ; -- emanering..nn.1
  emballage_1_N : N ; -- emballage..nn.1
  emballera_1_V : V ; -- emballera..vb.1
  emballerande_1_N : N ; -- emballerande..nn.1
  emballerbar_1_A : A ; -- emballerbar..av.1
  emballerbarhet_1_N : N ; -- emballerbarhet..nn.1
  emballering_1_N : N ; -- emballering..nn.1
  embargo_1_N : N ; -- embargo..nn.1
  embarkera_1_V : V ; -- embarkera..vb.1
  embarkerande_1_N : N ; -- embarkerande..nn.1
  embarkerbar_1_A : A ; -- embarkerbar..av.1
  embarkerbarhet_1_N : N ; -- embarkerbarhet..nn.1
  embarkering_1_N : N ; -- embarkering..nn.1
  embarras_1_N : N ; -- embarras..nn.1
  embellera_1_V : V ; -- embellera..vb.1
  embellerande_1_N : N ; -- embellerande..nn.1
  embellerbar_1_A : A ; -- embellerbar..av.1
  embellerbarhet_1_N : N ; -- embellerbarhet..nn.1
  embellering_1_N : N ; -- embellering..nn.1
  emblem_1_N : N ; -- emblem..nn.1
  emblematik_1_N : N ; -- emblematik..nn.1
  emblematisk_1_A : A ; -- emblematisk..av.1
  emblematiskhet_1_N : N ; -- emblematiskhet..nn.1
  emboli_1_N : N ; -- emboli..nn.1
  embonpoint_1_N : N ; -- embonpoint..nn.1
  embryo_1_N : N ; -- embryo..nn.1
  embryolog_1_N : N ; -- embryolog..nn.1
  embryologi_1_N : N ; -- embryologi..nn.1
  embryonal_1_A : A ; -- embryonal..av.1
  embryonisk_1_A : A ; -- embryonisk..av.1
  embryosäck_1_N : N ; -- embryosäck..nn.1
  emellanåt_1_Adv : Adv ; -- emellanåt..ab.1
  emellertid_1_Adv : Adv ; -- emellertid..ab.1
  emendation_1_N : N ; -- emendation..nn.1
  emendera_1_V : V ; -- emendera..vb.1
  emenderande_1_N : N ; -- emenderande..nn.1
  emenderbar_1_A : A ; -- emenderbar..av.1
  emenderbarhet_1_N : N ; -- emenderbarhet..nn.1
  emendering_1_N : N ; -- emendering..nn.1
  emergent_1_A : A ; -- emergent..av.1
  emeritus_1_N : N ; -- emeritus..nn.1
  emfas_1_N : N ; -- emfas..nn.1
  emfatisk_1_A : A ; -- emfatisk..av.1
  emfysem_1_N : N ; -- emfysem..nn.1
  emigrant_1_N : N ; -- emigrant..nn.1
  emigration_1_N : N ; -- emigration..nn.1
  emigrera_1_V : V ; -- emigrera..vb.1
  emigrerande_1_N : N ; -- emigrerande..nn.1
  emigrerbar_1_A : A ; -- emigrerbar..av.1
  emigrerbarhet_1_N : N ; -- emigrerbarhet..nn.1
  emigrering_1_N : N ; -- emigrering..nn.1
  eminens_1_N : N ; -- eminens..nn.1
  eminent_1_A : A ; -- eminent..av.1
  eminenthet_1_N : N ; -- eminenthet..nn.1
  emir_1_N : N ; -- emir..nn.1
  emiratier_1_N : N ; -- emiratier..nn.1
  emiratisk_1_A : A ; -- emiratisk..av.1
  emiratiska_1_N : N ; -- emiratiska..nn.1
  emissarie_1_N : N ; -- emissarie..nn.1
  emission_1_N : N ; -- emission..nn.1
  emissionskurs_1_N : N ; -- emissionskurs..nn.1
  emitter_1_N : N ; -- emitter..nn.1
  emittera_1_V : V ; -- emittera..vb.1
  emitterande_1_N : N ; -- emitterande..nn.1
  emitterbar_1_A : A ; -- emitterbar..av.1
  emitterbarhet_1_N : N ; -- emitterbarhet..nn.1
  emittering_1_N : N ; -- emittering..nn.1
  emma_1_N : N ; -- emma..nn.1
  emmentaler_1_N : N ; -- emmentaler..nn.1
  emmervete_1_N : N ; -- emmervete..nn.1
  emo_1_N : N ; -- emo..nn.1
  emollition_1_N : N ; -- emollition..nn.1
  emotion_1_N : N ; -- emotion..nn.1
  emotionalisera_1_V : V ; -- emotionalisera..vb.1
  emotionaliserande_1_N : N ; -- emotionaliserande..nn.1
  emotionalisering_1_N : N ; -- emotionalisering..nn.1
  emotionell_1_A : A ; -- emotionell..av.1
  emotiv_1_A : A ; -- emotiv..av.1
  emotse_1_V : V ; -- emotse..vb.1
  emotseende_1_N : N ; -- emotseende..nn.1
  emotstå_1_V : V ; -- emotstå..vb.1
  emotstående_1_N : N ; -- emotstående..nn.1
  emotta_1_V : V ; -- emotta..vb.1
  emottagande_1_N : N ; -- emottagande..nn.1
  empati_1_N : N ; -- empati..nn.1
  empatibefriad_1_A : A ; -- empatibefriad..av.1
  empatilös_1_A : A ; -- empatilös..av.1
  empatisk_1_A : A ; -- empatisk..av.1
  empatistörd_1_A : A ; -- empatistörd..av.1
  empir_1_N : N ; -- empir..nn.1
  empire_1_N : N ; -- empire..nn.1
  empirestil_1_N : N ; -- empirestil..nn.1
  empiri_1_N : N ; -- empiri..nn.1
  empiriker_1_N : N ; -- empiriker..nn.1
  empirisk_1_A : A ; -- empirisk..av.1
  empirism_1_N : N ; -- empirism..nn.1
  empirist_1_N : N ; -- empirist..nn.1
  empiristisk_1_A : A ; -- empiristisk..av.1
  empyem_1_N : N ; -- empyem..nn.1
  emsersalt_1_N : N ; -- emsersalt..nn.1
  emu_1_N : N ; -- emu..nn.1
  emulgera_1_V : V ; -- emulgera..vb.1
  emulgerande_1_N : N ; -- emulgerande..nn.1
  emulgerbar_1_A : A ; -- emulgerbar..av.1
  emulgerbarhet_1_N : N ; -- emulgerbarhet..nn.1
  emulgering_1_N : N ; -- emulgering..nn.1
  emulsion_1_N : N ; -- emulsion..nn.1
  emulsionsfärg_1_N : N ; -- emulsionsfärg..nn.1
  emulsionssprängämne_1_N : N ; -- emulsionssprängämne..nn.1
  en_tous_cas_1_N : N ; -- en-tous-cas..nn.1
  en_1_Adv : Adv ; -- en..ab.1
  en_1_N : N ; -- en..nn.1
  ena_1_V : V ; -- ena..vb.1
  enahanda_1_A : A ; -- enahanda..av.1
  enaktare_1_N : N ; -- enaktare..nn.1
  enande_1_N : N ; -- enande..nn.1
  enarmad_1_A : A ; -- enarmad..av.1
  enarmig_1_A : A ; -- enarmig..av.1
  enarådande_1_A : A ; -- enarådande..av.1
  enastående_1_A : A ; -- enastående..av.1
  enaxlad_1_A : A ; -- enaxlad..av.1
  enaxlig_1_A : A ; -- enaxlig..av.1
  enaxlighet_1_N : N ; -- enaxlighet..nn.1
  enbacke_1_N : N ; -- enbacke..nn.1
  enbart_1_Adv : Adv ; -- enbart..ab.1
  enbasisk_1_A : A ; -- enbasisk..av.1
  enbent_1_A : A ; -- enbent..av.1
  enbenthet_1_N : N ; -- enbenthet..nn.1
  enbet_1_N : N ; -- enbet..nn.1
  enbladig_1_A : A ; -- enbladig..av.1
  enblommig_1_A : A ; -- enblommig..av.1
  enbuske_1_N : N ; -- enbuske..nn.1
  enbyggare_1_N : N ; -- enbyggare..nn.1
  enbäddsrum_1_N : N ; -- enbäddsrum..nn.1
  enbär_1_N : N ; -- enbär..nn.1
  enbärsbrännvin_1_N : N ; -- enbärsbrännvin..nn.1
  encefalit_1_N : N ; -- encefalit..nn.1
  encefalografi_1_N : N ; -- encefalografi..nn.1
  encellig_1_A : A ; -- encellig..av.1
  encellighet_1_N : N ; -- encellighet..nn.1
  encyklika_1_N : N ; -- encyklika..nn.1
  encyklopedi_1_N : N ; -- encyklopedi..nn.1
  encyklopedisk_1_A : A ; -- encyklopedisk..av.1
  encyklopedist_1_N : N ; -- encyklopedist..nn.1
  endagsbesök_1_N : N ; -- endagsbesök..nn.1
  endast_1_Adv : Adv ; -- endast..ab.1
  endaste_1_A : A ; -- endaste..av.1
  endels_1_Adv : Adv ; -- endels..ab.1
  endemi_1_N : N ; -- endemi..nn.1
  endemisk_1_A : A ; -- endemisk..av.1
  endera_1_Adv : Adv ; -- endera..ab.1
  endimensionell_1_A : A ; -- endimensionell..av.1
  endiv_1_N : N ; -- endiv..nn.1
  endogen_1_A : A ; -- endogen..av.1
  endokrin_1_A : A ; -- endokrin..av.1
  endokrinolog_1_N : N ; -- endokrinolog..nn.1
  endokrinologi_1_N : N ; -- endokrinologi..nn.1
  endonym_1_N : N ; -- endonym..nn.1
  endorfin_1_N : N ; -- endorfin..nn.1
  endoskopi_1_N : N ; -- endoskopi..nn.1
  endoskopisk_1_A : A ; -- endoskopisk..av.1
  endossat_1_N : N ; -- endossat..nn.1
  endossemang_1_N : N ; -- endossemang..nn.1
  endossement_1_N : N ; -- endossement..nn.1
  endossent_1_N : N ; -- endossent..nn.1
  endossera_1_V : V ; -- endossera..vb.1
  endosserande_1_N : N ; -- endosserande..nn.1
  endosserbar_1_A : A ; -- endosserbar..av.1
  endosserbarhet_1_N : N ; -- endosserbarhet..nn.1
  endossering_1_N : N ; -- endossering..nn.1
  endotermisk_1_A : A ; -- endotermisk..av.1
  endräkt_1_N : N ; -- endräkt..nn.1
  endräktig_1_A : A ; -- endräktig..av.1
  ene_1_N : N ; -- ene..nn.1
  energi_1_N : N ; -- energi..nn.1
  energialternativ_1_N : N ; -- energialternativ..nn.1
  energibehov_1_N : N ; -- energibehov..nn.1
  energibesparande_1_A : A ; -- energibesparande..av.1
  energibrist_1_N : N ; -- energibrist..nn.1
  energidepartement_1_N : N ; -- energidepartement..nn.1
  energidryck_1_N : N ; -- energidryck..nn.1
  energieffektiv_1_A : A ; -- energieffektiv..av.1
  energieffektivisering_1_N : N ; -- energieffektivisering..nn.1
  energieffektivitet_1_N : N ; -- energieffektivitet..nn.1
  energiform_1_N : N ; -- energiform..nn.1
  energiförbrukande_1_A : A ; -- energiförbrukande..av.1
  energiförbrukare_1_N : N ; -- energiförbrukare..nn.1
  energiförbrukning_1_N : N ; -- energiförbrukning..nn.1
  energiförlust_1_N : N ; -- energiförlust..nn.1
  energiförsörjning_1_N : N ; -- energiförsörjning..nn.1
  energigivande_1_A : A ; -- energigivande..av.1
  energiinnehåll_1_N : N ; -- energiinnehåll..nn.1
  energiintag_1_N : N ; -- energiintag..nn.1
  energiintensiv_1_A : A ; -- energiintensiv..av.1
  energiknippe_1_N : N ; -- energiknippe..nn.1
  energikoncentration_1_N : N ; -- energikoncentration..nn.1
  energikrävande_1_A : A ; -- energikrävande..av.1
  energikälla_1_N : N ; -- energikälla..nn.1
  energilös_1_A : A ; -- energilös..av.1
  energimarknad_1_N : N ; -- energimarknad..nn.1
  energimix_1_N : N ; -- energimix..nn.1
  energimängd_1_N : N ; -- energimängd..nn.1
  energimässig_1_A : A ; -- energimässig..av.1
  energiomställning_1_N : N ; -- energiomställning..nn.1
  energiomsättning_1_N : N ; -- energiomsättning..nn.1
  energiomvandling_1_N : N ; -- energiomvandling..nn.1
  energiomvandlingscentrum_1_N : N ; -- energiomvandlingscentrum..nn.1
  energipolitik_1_N : N ; -- energipolitik..nn.1
  energipolitisk_1_A : A ; -- energipolitisk..av.1
  energiprincip_1_N : N ; -- energiprincip..nn.1
  energiproduktion_1_N : N ; -- energiproduktion..nn.1
  energirik_1_A : A ; -- energirik..av.1
  energirikhet_1_N : N ; -- energirikhet..nn.1
  energisk_1_A : A ; -- energisk..av.1
  energiskatt_1_N : N ; -- energiskatt..nn.1
  energiskog_1_N : N ; -- energiskog..nn.1
  energislukande_1_A : A ; -- energislukande..av.1
  energislöseri_1_N : N ; -- energislöseri..nn.1
  energisnål_1_A : A ; -- energisnål..av.1
  energisparande_1_A : A ; -- energisparande..av.1
  energisystem_1_N : N ; -- energisystem..nn.1
  energiteori_1_N : N ; -- energiteori..nn.1
  energitillstånd_1_N : N ; -- energitillstånd..nn.1
  energiuppgörelse_1_N : N ; -- energiuppgörelse..nn.1
  energiupptagande_1_A : A ; -- energiupptagande..av.1
  energiutstrålning_1_N : N ; -- energiutstrålning..nn.1
  energiutveckling_1_N : N ; -- energiutveckling..nn.1
  energiverk_1_N : N ; -- energiverk..nn.1
  energivinst_1_N : N ; -- energivinst..nn.1
  energiåtgång_1_N : N ; -- energiåtgång..nn.1
  enervera_1_V : V ; -- enervera..vb.1
  enerverande_1_N : N ; -- enerverande..nn.1
  enerverbar_1_A : A ; -- enerverbar..av.1
  enerverbarhet_1_N : N ; -- enerverbarhet..nn.1
  enervering_1_N : N ; -- enervering..nn.1
  enfald_1_N : N ; -- enfald..nn.1
  enfaldeligen_1_Adv : Adv ; -- enfaldeligen..ab.1
  enfaldig_1_A : A ; -- enfaldig..av.1
  enfaldighet_1_N : N ; -- enfaldighet..nn.1
  enfamiljshus_1_N : N ; -- enfamiljshus..nn.1
  enfas_1_A : A ; -- enfas..av.1
  enfasig_1_A : A ; -- enfasig..av.1
  enformig_1_A : A ; -- enformig..av.1
  enformighet_1_N : N ; -- enformighet..nn.1
  enfotad_1_A : A ; -- enfotad..av.1
  enfoting_1_N : N ; -- enfoting..nn.1
  enfrågeparti_1_N : N ; -- enfrågeparti..nn.1
  enfärgad_1_A : A ; -- enfärgad..av.1
  enfödd_1_A : A ; -- enfödd..av.1
  enföräldersfamilj_1_N : N ; -- enföräldersfamilj..nn.1
  engagemang_1_N : N ; -- engagemang..nn.1
  engagera_1_V : V ; -- engagera..vb.1
  engagerad_1_A : A ; -- engagerad..av.1
  engagerande_1_N : N ; -- engagerande..nn.1
  engagerbar_1_A : A ; -- engagerbar..av.1
  engagerbarhet_1_N : N ; -- engagerbarhet..nn.1
  engagering_1_N : N ; -- engagering..nn.1
  engelsk_1_A : A ; -- engelsk..av.1
  engelska_1_N : N ; -- engelska..nn.1
  engelska_2_N : N ; -- engelska..nn.2
  engelskakurs_1_N : N ; -- engelskakurs..nn.1
  engelskalektion_1_N : N ; -- engelskalektion..nn.1
  engelskalärare_1_N : N ; -- engelskalärare..nn.1
  engelskaundervisning_1_N : N ; -- engelskaundervisning..nn.1
  engelskkurs_1_N : N ; -- engelskkurs..nn.1
  engelsklektion_1_N : N ; -- engelsklektion..nn.1
  engelsklärare_1_N : N ; -- engelsklärare..nn.1
  engelskspråkig_1_A : A ; -- engelskspråkig..av.1
  engelskspråkighet_1_N : N ; -- engelskspråkighet..nn.1
  engelskspåkig_1_A : A ; -- engelskspåkig..av.1
  engelskspåkighet_1_N : N ; -- engelskspåkighet..nn.1
  engelsktalande_1_A : A ; -- engelsktalande..av.1
  engelskundervisning_1_N : N ; -- engelskundervisning..nn.1
  engelsman_1_N : N ; -- engelsman..nn.1
  engifte_1_N : N ; -- engifte..nn.1
  englergrad_1_N : N ; -- englergrad..nn.1
  engram_1_N : N ; -- engram..nn.1
  engrossist_1_N : N ; -- engrossist..nn.1
  engång_1_Adv : Adv ; -- engång..ab.1
  engångitiden_1_Adv : Adv ; -- engångitiden..ab.1
  engångs_1_A : A ; -- engångs..av.1
  engångsartikel_1_N : N ; -- engångsartikel..nn.1
  engångsdos_1_N : N ; -- engångsdos..nn.1
  engångsflaska_1_N : N ; -- engångsflaska..nn.1
  engångsföreteelse_1_N : N ; -- engångsföreteelse..nn.1
  engångshandduk_1_N : N ; -- engångshandduk..nn.1
  engångskaraktär_1_N : N ; -- engångskaraktär..nn.1
  engångskostnad_1_N : N ; -- engångskostnad..nn.1
  engångsligg_1_N : N ; -- engångsligg..nn.1
  engångsnatur_1_N : N ; -- engångsnatur..nn.1
  engångsnäsduk_1_N : N ; -- engångsnäsduk..nn.1
  engångsservett_1_N : N ; -- engångsservett..nn.1
  engångsskatt_1_N : N ; -- engångsskatt..nn.1
  engångstallrik_1_N : N ; -- engångstallrik..nn.1
  engångsvärde_1_N : N ; -- engångsvärde..nn.1
  enharmonisk_1_A : A ; -- enharmonisk..av.1
  enhet_1_N : N ; -- enhet..nn.1
  enhetlig_1_A : A ; -- enhetlig..av.1
  enhetlighet_1_N : N ; -- enhetlighet..nn.1
  enhetscirkel_1_N : N ; -- enhetscirkel..nn.1
  enhetsflygplan_1_N : N ; -- enhetsflygplan..nn.1
  enhetsfront_1_N : N ; -- enhetsfront..nn.1
  enhetsladdning_1_N : N ; -- enhetsladdning..nn.1
  enhetslast_1_N : N ; -- enhetslast..nn.1
  enhetsmått_1_N : N ; -- enhetsmått..nn.1
  enhetsparti_1_N : N ; -- enhetsparti..nn.1
  enhetspatron_1_N : N ; -- enhetspatron..nn.1
  enhetsporto_1_N : N ; -- enhetsporto..nn.1
  enhetspris_1_N : N ; -- enhetspris..nn.1
  enhetsskola_1_N : N ; -- enhetsskola..nn.1
  enhetssträvande_1_N : N ; -- enhetssträvande..nn.1
  enhetsvektor_1_N : N ; -- enhetsvektor..nn.1
  enhjulig_1_A : A ; -- enhjulig..av.1
  enhjulighet_1_N : N ; -- enhjulighet..nn.1
  enhjuling_1_N : N ; -- enhjuling..nn.1
  enhjärtbladig_1_A : A ; -- enhjärtbladig..av.1
  enhällig_1_A : A ; -- enhällig..av.1
  enhällighet_1_N : N ; -- enhällighet..nn.1
  enhänt_1_A : A ; -- enhänt..av.1
  enhörning_1_N : N ; -- enhörning..nn.1
  enig_1_A : A ; -- enig..av.1
  enighet_1_N : N ; -- enighet..nn.1
  enigmatisk_1_A : A ; -- enigmatisk..av.1
  enjambemang_1_N : N ; -- enjambemang..nn.1
  enkammarsystem_1_N : N ; -- enkammarsystem..nn.1
  enkannerligen_1_Adv : Adv ; -- enkannerligen..ab.1
  enkel_1_A : A ; -- enkel..av.1
  enkelbeckasin_1_N : N ; -- enkelbeckasin..nn.1
  enkelbiff_1_N : N ; -- enkelbiff..nn.1
  enkelbiljett_1_N : N ; -- enkelbiljett..nn.1
  enkelbredd_1_N : N ; -- enkelbredd..nn.1
  enkelhet_1_N : N ; -- enkelhet..nn.1
  enkelkikare_1_N : N ; -- enkelkikare..nn.1
  enkelknäppning_1_N : N ; -- enkelknäppning..nn.1
  enkelknäppt_1_A : A ; -- enkelknäppt..av.1
  enkelkvartett_1_N : N ; -- enkelkvartett..nn.1
  enkelladdare_1_N : N ; -- enkelladdare..nn.1
  enkelnervig_1_A : A ; -- enkelnervig..av.1
  enkelpipig_1_A : A ; -- enkelpipig..av.1
  enkelrad_1_N : N ; -- enkelrad..nn.1
  enkelrenad_1_A : A ; -- enkelrenad..av.1
  enkelrikta_1_V : V ; -- enkelrikta..vb.1
  enkelriktad_1_A : A ; -- enkelriktad..av.1
  enkelriktande_1_N : N ; -- enkelriktande..nn.1
  enkelrum_1_N : N ; -- enkelrum..nn.1
  enkelskriva_1_V : V ; -- enkelskriva..vb.1
  enkelskrivande_1_N : N ; -- enkelskrivande..nn.1
  enkelspel_1_N : N ; -- enkelspel..nn.1
  enkelspårig_1_A : A ; -- enkelspårig..av.1
  enkelspårighet_1_N : N ; -- enkelspårighet..nn.1
  enkelstjärna_1_N : N ; -- enkelstjärna..nn.1
  enkelsträngad_1_A : A ; -- enkelsträngad..av.1
  enkelsäng_1_N : N ; -- enkelsäng..nn.1
  enkelteckna_1_V : V ; -- enkelteckna..vb.1
  enkeltecknande_1_N : N ; -- enkeltecknande..nn.1
  enkeltimma_1_N : N ; -- enkeltimma..nn.1
  enkeltimme_1_N : N ; -- enkeltimme..nn.1
  enkla_1_V : V ; -- enkla..vb.1
  enklande_1_N : N ; -- enklande..nn.1
  enklang_1_N : N ; -- enklang..nn.1
  enklav_1_N : N ; -- enklav..nn.1
  enklavisering_1_N : N ; -- enklavisering..nn.1
  enklitisk_1_A : A ; -- enklitisk..av.1
  enkomponents_1_A : A ; -- enkomponents..av.1
  enkomponentskitt_1_N : N ; -- enkomponentskitt..nn.1
  enkorn_1_N : N ; -- enkorn..nn.1
  enkrona_1_N : N ; -- enkrona..nn.1
  enkät_1_N : N ; -- enkät..nn.1
  enkätsvar_1_N : N ; -- enkätsvar..nn.1
  enkätundersökning_1_N : N ; -- enkätundersökning..nn.1
  enkönad_1_A : A ; -- enkönad..av.1
  enkönsregel_1_N : N ; -- enkönsregel..nn.1
  enlevera_1_V : V ; -- enlevera..vb.1
  enleverande_1_N : N ; -- enleverande..nn.1
  enleverbar_1_A : A ; -- enleverbar..av.1
  enleverbarhet_1_N : N ; -- enleverbarhet..nn.1
  enlevering_1_N : N ; -- enlevering..nn.1
  enmansföreställning_1_N : N ; -- enmansföreställning..nn.1
  enmansgrav_1_N : N ; -- enmansgrav..nn.1
  enmanslivbåt_1_N : N ; -- enmanslivbåt..nn.1
  enmanspublik_1_N : N ; -- enmanspublik..nn.1
  enmansshow_1_N : N ; -- enmansshow..nn.1
  enmansteater_1_N : N ; -- enmansteater..nn.1
  enmansvalkrets_1_N : N ; -- enmansvalkrets..nn.1
  enmastad_1_A : A ; -- enmastad..av.1
  enmastare_1_N : N ; -- enmastare..nn.1
  enmotorig_1_A : A ; -- enmotorig..av.1
  enna_1_Adv : Adv ; -- enna..ab.1
  enorm_1_A : A ; -- enorm..av.1
  enormhet_1_N : N ; -- enormhet..nn.1
  enpartistat_1_N : N ; -- enpartistat..nn.1
  enpersonsfamilj_1_N : N ; -- enpersonsfamilj..nn.1
  enpersonshushåll_1_N : N ; -- enpersonshushåll..nn.1
  enplanshus_1_N : N ; -- enplanshus..nn.1
  enplansvilla_1_N : N ; -- enplansvilla..nn.1
  enpolig_1_A : A ; -- enpolig..av.1
  enpolighet_1_N : N ; -- enpolighet..nn.1
  enpucklig_1_A : A ; -- enpucklig..av.1
  enpucklighet_1_N : N ; -- enpucklighet..nn.1
  enris_1_N : N ; -- enris..nn.1
  enrisrökt_1_A : A ; -- enrisrökt..av.1
  enrollera_1_V : V ; -- enrollera..vb.1
  enrollerande_1_N : N ; -- enrollerande..nn.1
  enrollerbar_1_A : A ; -- enrollerbar..av.1
  enrollerbarhet_1_N : N ; -- enrollerbarhet..nn.1
  enrollering_1_N : N ; -- enrollering..nn.1
  enrummare_1_N : N ; -- enrummare..nn.1
  enrumslägenhet_1_N : N ; -- enrumslägenhet..nn.1
  enrådig_1_A : A ; -- enrådig..av.1
  ens_1_Adv : Adv ; -- ens..ab.1
  ens_1_A : A ; -- ens..av.1
  ensa_1_V : V ; -- ensa..vb.1
  ensak_1_N : N ; -- ensak..nn.1
  ensam_1_A : A ; -- ensam..av.1
  ensamagerande_1_A : A ; -- ensamagerande..av.1
  ensamanländande_1_A : A ; -- ensamanländande..av.1
  ensamflygning_1_N : N ; -- ensamflygning..nn.1
  ensamförälder_1_N : N ; -- ensamförälder..nn.1
  ensamgård_1_N : N ; -- ensamgård..nn.1
  ensamhet_1_N : N ; -- ensamhet..nn.1
  ensamhushåll_1_N : N ; -- ensamhushåll..nn.1
  ensamkommande_1_A : A ; -- ensamkommande..av.1
  ensamrätt_1_N : N ; -- ensamrätt..nn.1
  ensamseglare_1_N : N ; -- ensamseglare..nn.1
  ensamstående_1_A : A ; -- ensamstående..av.1
  ensamvarg_1_N : N ; -- ensamvarg..nn.1
  ensande_1_N : N ; -- ensande..nn.1
  ensartad_1_A : A ; -- ensartad..av.1
  ense_1_A : A ; -- ense..av.1
  ensemble_1_N : N ; -- ensemble..nn.1
  ensfyr_1_N : N ; -- ensfyr..nn.1
  ensidig_1_A : A ; -- ensidig..av.1
  ensidighet_1_N : N ; -- ensidighet..nn.1
  ensiffrig_1_A : A ; -- ensiffrig..av.1
  ensilage_1_N : N ; -- ensilage..nn.1
  ensilera_1_V : V ; -- ensilera..vb.1
  ensilerande_1_N : N ; -- ensilerande..nn.1
  ensilerbar_1_A : A ; -- ensilerbar..av.1
  ensilerbarhet_1_N : N ; -- ensilerbarhet..nn.1
  ensilering_1_N : N ; -- ensilering..nn.1
  ensitsig_1_A : A ; -- ensitsig..av.1
  ensittare_1_N : N ; -- ensittare..nn.1
  enskeppig_1_A : A ; -- enskeppig..av.1
  enskifte_1_N : N ; -- enskifte..nn.1
  enskild_1_A : A ; -- enskild..av.1
  enskildhet_1_N : N ; -- enskildhet..nn.1
  enslig_1_A : A ; -- enslig..av.1
  enslighet_1_N : N ; -- enslighet..nn.1
  ensling_1_N : N ; -- ensling..nn.1
  enslinje_1_N : N ; -- enslinje..nn.1
  enspann_1_N : N ; -- enspann..nn.1
  enspråkig_1_A : A ; -- enspråkig..av.1
  enspråkighet_1_N : N ; -- enspråkighet..nn.1
  enspänd_1_A : A ; -- enspänd..av.1
  enstaka_1_A : A ; -- enstaka..av.1
  enstavig_1_A : A ; -- enstavig..av.1
  enstavighet_1_N : N ; -- enstavighet..nn.1
  enstavighetsaccent_1_N : N ; -- enstavighetsaccent..nn.1
  enstegstätad_1_A : A ; -- enstegstätad..av.1
  enstensmur_1_N : N ; -- enstensmur..nn.1
  enstjärnig_1_A : A ; -- enstjärnig..av.1
  enstämmig_1_A : A ; -- enstämmig..av.1
  enstämmighet_1_N : N ; -- enstämmighet..nn.1
  enständig_1_A : A ; -- enständig..av.1
  enständighet_1_N : N ; -- enständighet..nn.1
  enstörig_1_A : A ; -- enstörig..av.1
  enstörighet_1_N : N ; -- enstörighet..nn.1
  enstöring_1_N : N ; -- enstöring..nn.1
  ental_1_N : N ; -- ental..nn.1
  entalpi_1_N : N ; -- entalpi..nn.1
  entalsform_1_N : N ; -- entalsform..nn.1
  entent_1_N : N ; -- entent..nn.1
  entente_1_N : N ; -- entente..nn.1
  enter_1_N : N ; -- enter..nn.1
  enterknapp_1_N : N ; -- enterknapp..nn.1
  entertainer_1_N : N ; -- entertainer..nn.1
  entertangent_1_N : N ; -- entertangent..nn.1
  entita_1_N : N ; -- entita..nn.1
  entitet_1_N : N ; -- entitet..nn.1
  entlediga_1_V : V ; -- entlediga..vb.1
  entledigande_1_N : N ; -- entledigande..nn.1
  entomolog_1_N : N ; -- entomolog..nn.1
  entomologi_1_N : N ; -- entomologi..nn.1
  entomologisk_1_A : A ; -- entomologisk..av.1
  entonig_1_A : A ; -- entonig..av.1
  entonighet_1_N : N ; -- entonighet..nn.1
  entrecote_1_N : N ; -- entrecote..nn.1
  entrecôte_1_N : N ; -- entrecôte..nn.1
  entreprenad_1_N : N ; -- entreprenad..nn.1
  entreprenadmaskin_1_N : N ; -- entreprenadmaskin..nn.1
  entreprenör_1_N : N ; -- entreprenör..nn.1
  entreprenörsanda_1_N : N ; -- entreprenörsanda..nn.1
  entreprenörskap_1_N : N ; -- entreprenörskap..nn.1
  entresol_1_N : N ; -- entresol..nn.1
  entresoll_1_N : N ; -- entresoll..nn.1
  entresolvåning_1_N : N ; -- entresolvåning..nn.1
  entropi_1_N : N ; -- entropi..nn.1
  enträgen_1_A : A ; -- enträgen..av.1
  enträgenhet_1_N : N ; -- enträgenhet..nn.1
  entré_1_N : N ; -- entré..nn.1
  entréavgift_1_N : N ; -- entréavgift..nn.1
  entrébiljett_1_N : N ; -- entrébiljett..nn.1
  entrédörr_1_N : N ; -- entrédörr..nn.1
  entrérätt_1_N : N ; -- entrérätt..nn.1
  entumsspik_1_N : N ; -- entumsspik..nn.1
  entusiasm_1_N : N ; -- entusiasm..nn.1
  entusiasmera_1_V : V ; -- entusiasmera..vb.1
  entusiasmerande_1_N : N ; -- entusiasmerande..nn.1
  entusiasmerbar_1_A : A ; -- entusiasmerbar..av.1
  entusiasmerbarhet_1_N : N ; -- entusiasmerbarhet..nn.1
  entusiasmering_1_N : N ; -- entusiasmering..nn.1
  entusiast_1_N : N ; -- entusiast..nn.1
  entusiastisk_1_A : A ; -- entusiastisk..av.1
  entusiastsajt_1_N : N ; -- entusiastsajt..nn.1
  entydig_1_A : A ; -- entydig..av.1
  entydighet_1_N : N ; -- entydighet..nn.1
  entypsbåt_1_N : N ; -- entypsbåt..nn.1
  enumeration_1_N : N ; -- enumeration..nn.1
  enveten_1_A : A ; -- enveten..av.1
  envetenhet_1_N : N ; -- envetenhet..nn.1
  envig_1_N : N ; -- envig..nn.1
  environg_1_N : N ; -- environg..nn.1
  envis_1_A : A ; -- envis..av.1
  envishet_1_N : N ; -- envishet..nn.1
  envoyé_1_N : N ; -- envoyé..nn.1
  envägskommunikation_1_N : N ; -- envägskommunikation..nn.1
  envälde_1_N : N ; -- envälde..nn.1
  enväldig_1_A : A ; -- enväldig..av.1
  enväldighet_1_N : N ; -- enväldighet..nn.1
  envärd_1_A : A ; -- envärd..av.1
  envåldshärskare_1_N : N ; -- envåldshärskare..nn.1
  envåldsmakt_1_N : N ; -- envåldsmakt..nn.1
  envåningsbarack_1_N : N ; -- envåningsbarack..nn.1
  envåningshus_1_N : N ; -- envåningshus..nn.1
  enzym_1_N : N ; -- enzym..nn.1
  enzymrubbning_1_N : N ; -- enzymrubbning..nn.1
  enzymsystem_1_N : N ; -- enzymsystem..nn.1
  enzymtvättmedel_1_N : N ; -- enzymtvättmedel..nn.1
  enäggstvilling_1_N : N ; -- enäggstvilling..nn.1
  enögd_1_A : A ; -- enögd..av.1
  enögdhet_1_N : N ; -- enögdhet..nn.1
  eoarkeikum_1_N : N ; -- eoarkeikum..nn.1
  eocen_1_N : N ; -- eocen..nn.1
  eoler_1_N : N ; -- eoler..nn.1
  eolier_1_N : N ; -- eolier..nn.1
  eolisk_1_A : A ; -- eolisk..av.1
  eolsharpa_1_N : N ; -- eolsharpa..nn.1
  eon_1_N : N ; -- eon..nn.1
  eosin_1_N : N ; -- eosin..nn.1
  epatraktor_1_N : N ; -- epatraktor..nn.1
  epicentrum_1_N : N ; -- epicentrum..nn.1
  epicykel_1_N : N ; -- epicykel..nn.1
  epidemi_1_N : N ; -- epidemi..nn.1
  epidemiologi_1_N : N ; -- epidemiologi..nn.1
  epidemiologisk_1_A : A ; -- epidemiologisk..av.1
  epidemisjukhus_1_N : N ; -- epidemisjukhus..nn.1
  epidemisk_1_A : A ; -- epidemisk..av.1
  epidemolog_1_N : N ; -- epidemolog..nn.1
  epiduralblockad_1_N : N ; -- epiduralblockad..nn.1
  epifani_1_N : N ; -- epifani..nn.1
  epifanisk_1_A : A ; -- epifanisk..av.1
  epifenomen_1_N : N ; -- epifenomen..nn.1
  epifys_1_N : N ; -- epifys..nn.1
  epifyt_1_N : N ; -- epifyt..nn.1
  epigenetisk_1_A : A ; -- epigenetisk..av.1
  epigon_1_N : N ; -- epigon..nn.1
  epigoneri_1_N : N ; -- epigoneri..nn.1
  epigrafik_1_N : N ; -- epigrafik..nn.1
  epigram_1_N : N ; -- epigram..nn.1
  epigrammatisk_1_A : A ; -- epigrammatisk..av.1
  epik_1_N : N ; -- epik..nn.1
  epiker_1_N : N ; -- epiker..nn.1
  epikureisk_1_A : A ; -- epikureisk..av.1
  epikurism_1_N : N ; -- epikurism..nn.1
  epikuré_1_N : N ; -- epikuré..nn.1
  epikuréism_1_N : N ; -- epikuréism..nn.1
  epilepsi_1_N : N ; -- epilepsi..nn.1
  epileptiker_1_N : N ; -- epileptiker..nn.1
  epileptisk_1_A : A ; -- epileptisk..av.1
  epilera_1_V : V ; -- epilera..vb.1
  epilerande_1_N : N ; -- epilerande..nn.1
  epilerbar_1_A : A ; -- epilerbar..av.1
  epilerbarhet_1_N : N ; -- epilerbarhet..nn.1
  epilering_1_N : N ; -- epilering..nn.1
  epilog_1_N : N ; -- epilog..nn.1
  epinefrin_1_N : N ; -- epinefrin..nn.1
  episk_1_A : A ; -- episk..av.1
  episkop_1_N : N ; -- episkop..nn.1
  episkopal_1_A : A ; -- episkopal..av.1
  episkopalkyrka_1_N : N ; -- episkopalkyrka..nn.1
  episkopat_1_N : N ; -- episkopat..nn.1
  episod_1_N : N ; -- episod..nn.1
  episodisk_1_A : A ; -- episodisk..av.1
  epistel_1_N : N ; -- epistel..nn.1
  epistemologi_1_N : N ; -- epistemologi..nn.1
  epistolär_1_A : A ; -- epistolär..av.1
  epistyl_1_N : N ; -- epistyl..nn.1
  epitaf_1_N : N ; -- epitaf..nn.1
  epitafium_1_N : N ; -- epitafium..nn.1
  epitel_1_N : N ; -- epitel..nn.1
  epitelcell_1_N : N ; -- epitelcell..nn.1
  epitet_1_N : N ; -- epitet..nn.1
  epizoisk_1_A : A ; -- epizoisk..av.1
  epizooti_1_N : N ; -- epizooti..nn.1
  epok_1_N : N ; -- epok..nn.1
  epokgörande_1_A : A ; -- epokgörande..av.1
  epos_1_N : N ; -- epos..nn.1
  epost_1_N : N ; -- epost..nn.1
  eposta_1_V : V ; -- eposta..vb.1
  epostande_1_N : N ; -- epostande..nn.1
  epostare_1_N : N ; -- epostare..nn.1
  epostbrev_1_N : N ; -- epostbrev..nn.1
  epostledes_1_Adv : Adv ; -- epostledes..ab.1
  epostmeddelande_1_N : N ; -- epostmeddelande..nn.1
  epoxylim_1_N : N ; -- epoxylim..nn.1
  epsilon_1_N : N ; -- epsilon..nn.1
  epålett_1_N : N ; -- epålett..nn.1
  era_1_N : N ; -- era..nn.1
  erbarmlig_1_A : A ; -- erbarmlig..av.1
  erbarmligen_1_Adv : Adv ; -- erbarmligen..ab.1
  erbarmlighet_1_N : N ; -- erbarmlighet..nn.1
  erbium_1_N : N ; -- erbium..nn.1
  erbjuda_1_V : V ; -- erbjuda..vb.1
  erbjudande_1_N : N ; -- erbjudande..nn.1
  erektion_1_N : N ; -- erektion..nn.1
  erektionsnöd_1_N : N ; -- erektionsnöd..nn.1
  eremit_1_N : N ; -- eremit..nn.1
  eremitage_1_N : N ; -- eremitage..nn.1
  eremitisk_1_A : A ; -- eremitisk..av.1
  eremitkräfta_1_N : N ; -- eremitkräfta..nn.1
  eremitliv_1_N : N ; -- eremitliv..nn.1
  erfara_1_V : V ; -- erfara..vb.1
  erfarande_1_N : N ; -- erfarande..nn.1
  erfaren_1_A : A ; -- erfaren..av.1
  erfarenhet_1_N : N ; -- erfarenhet..nn.1
  erfarenhetsbank_1_N : N ; -- erfarenhetsbank..nn.1
  erfarenhetsbaserad_1_A : A ; -- erfarenhetsbaserad..av.1
  erfarenhetsgrundad_1_A : A ; -- erfarenhetsgrundad..av.1
  erfarenhetsmässig_1_A : A ; -- erfarenhetsmässig..av.1
  erfarenhetsmässighet_1_N : N ; -- erfarenhetsmässighet..nn.1
  erfarenhetssfär_1_N : N ; -- erfarenhetssfär..nn.1
  erfarenhetsvärld_1_N : N ; -- erfarenhetsvärld..nn.1
  erforderlig_1_A : A ; -- erforderlig..av.1
  erforderlighet_1_N : N ; -- erforderlighet..nn.1
  erfordra_1_V : V ; -- erfordra..vb.1
  erfordrande_1_N : N ; -- erfordrande..nn.1
  ergativ_1_A : A ; -- ergativ..av.1
  ergativ_1_N : N ; -- ergativ..nn.1
  ergativsubjekt_1_N : N ; -- ergativsubjekt..nn.1
  ergometer_1_N : N ; -- ergometer..nn.1
  ergonom_1_N : N ; -- ergonom..nn.1
  ergonometrisk_1_A : A ; -- ergonometrisk..av.1
  ergonomi_1_N : N ; -- ergonomi..nn.1
  ergonomisk_1_A : A ; -- ergonomisk..av.1
  erhålla_1_V : V ; -- erhålla..vb.1
  erhållande_1_N : N ; -- erhållande..nn.1
  erigera_1_V : V ; -- erigera..vb.1
  erigerande_1_N : N ; -- erigerande..nn.1
  erigerbar_1_A : A ; -- erigerbar..av.1
  erigerbarhet_1_N : N ; -- erigerbarhet..nn.1
  erigering_1_N : N ; -- erigering..nn.1
  eriksgata_1_N : N ; -- eriksgata..nn.1
  erinnye_1_N : N ; -- erinnye..nn.1
  erinra_1_V : V ; -- erinra..vb.1
  erinran_1_N : N ; -- erinran..nn.1
  erinrande_1_N : N ; -- erinrande..nn.1
  erinring_1_N : N ; -- erinring..nn.1
  erisäpple_1_N : N ; -- erisäpple..nn.1
  eritrean_1_N : N ; -- eritrean..nn.1
  eritreansk_1_A : A ; -- eritreansk..av.1
  eritreanska_1_N : N ; -- eritreanska..nn.1
  eritreanska_2_N : N ; -- eritreanska..nn.2
  erkänd_1_A : A ; -- erkänd..av.1
  erkändhet_1_N : N ; -- erkändhet..nn.1
  erkänna_1_V : V ; -- erkänna..vb.1
  erkännande_1_N : N ; -- erkännande..nn.1
  erkännansvärd_1_A : A ; -- erkännansvärd..av.1
  erkännsam_1_A : A ; -- erkännsam..av.1
  erkännsamhet_1_N : N ; -- erkännsamhet..nn.1
  erkänsla_1_N : N ; -- erkänsla..nn.1
  erlägga_1_V : V ; -- erlägga..vb.1
  erläggande_1_N : N ; -- erläggande..nn.1
  ernå_1_V : V ; -- ernå..vb.1
  ernåelig_1_A : A ; -- ernåelig..av.1
  ernående_1_N : N ; -- ernående..nn.1
  erodera_1_V : V ; -- erodera..vb.1
  eroderande_1_N : N ; -- eroderande..nn.1
  eroderbar_1_A : A ; -- eroderbar..av.1
  eroderbarhet_1_N : N ; -- eroderbarhet..nn.1
  erodering_1_N : N ; -- erodering..nn.1
  erogen_1_A : A ; -- erogen..av.1
  erosion_1_N : N ; -- erosion..nn.1
  erosionsskada_1_N : N ; -- erosionsskada..nn.1
  erosionsstrand_1_N : N ; -- erosionsstrand..nn.1
  erotik_1_N : N ; -- erotik..nn.1
  erotiker_1_N : N ; -- erotiker..nn.1
  erotisera_1_V : V ; -- erotisera..vb.1
  erotiserande_1_N : N ; -- erotiserande..nn.1
  erotisering_1_N : N ; -- erotisering..nn.1
  erotisk_1_A : A ; -- erotisk..av.1
  erotogen_1_A : A ; -- erotogen..av.1
  erotoman_1_A : A ; -- erotoman..av.1
  erotoman_1_N : N ; -- erotoman..nn.1
  erotomani_1_N : N ; -- erotomani..nn.1
  errata_1_N : N ; -- errata..nn.1
  erratisk_1_A : A ; -- erratisk..av.1
  ersmässa_1_N : N ; -- ersmässa..nn.1
  ersätta_1_V : V ; -- ersätta..vb.1
  ersättande_1_N : N ; -- ersättande..nn.1
  ersättare_1_N : N ; -- ersättare..nn.1
  ersättlig_1_A : A ; -- ersättlig..av.1
  ersättlighet_1_N : N ; -- ersättlighet..nn.1
  ersättning_1_N : N ; -- ersättning..nn.1
  ersättningsanspråk_1_N : N ; -- ersättningsanspråk..nn.1
  ersättningsansvar_1_N : N ; -- ersättningsansvar..nn.1
  ersättningsbelopp_1_N : N ; -- ersättningsbelopp..nn.1
  ersättningsberättigad_1_A : A ; -- ersättningsberättigad..av.1
  ersättningsbuss_1_N : N ; -- ersättningsbuss..nn.1
  ersättningsnivå_1_N : N ; -- ersättningsnivå..nn.1
  ersättningsskyldig_1_A : A ; -- ersättningsskyldig..av.1
  ersättningsskyldighet_1_N : N ; -- ersättningsskyldighet..nn.1
  ertappa_1_V : V ; -- ertappa..vb.1
  ertappande_1_N : N ; -- ertappande..nn.1
  ertappning_1_N : N ; -- ertappning..nn.1
  eruption_1_N : N ; -- eruption..nn.1
  eruptiv_1_A : A ; -- eruptiv..av.1
  eruptivbergart_1_N : N ; -- eruptivbergart..nn.1
  erytropoitin_1_N : N ; -- erytropoitin..nn.1
  erövra_1_V : V ; -- erövra..vb.1
  erövrande_1_N : N ; -- erövrande..nn.1
  erövrare_1_N : N ; -- erövrare..nn.1
  erövring_1_N : N ; -- erövring..nn.1
  erövringslysten_1_A : A ; -- erövringslysten..av.1
  erövringståg_1_N : N ; -- erövringståg..nn.1
  escudo_1_N : N ; -- escudo..nn.1
  eselhuvud_1_N : N ; -- eselhuvud..nn.1
  eskader_1_N : N ; -- eskader..nn.1
  eskalation_1_N : N ; -- eskalation..nn.1
  eskalera_1_V : V ; -- eskalera..vb.1
  eskalerande_1_N : N ; -- eskalerande..nn.1
  eskalerbar_1_A : A ; -- eskalerbar..av.1
  eskalerbarhet_1_N : N ; -- eskalerbarhet..nn.1
  eskalering_1_N : N ; -- eskalering..nn.1
  eskapad_1_N : N ; -- eskapad..nn.1
  eskapism_1_N : N ; -- eskapism..nn.1
  eskapistisk_1_A : A ; -- eskapistisk..av.1
  eskarp_1_N : N ; -- eskarp..nn.1
  eskatolog_1_N : N ; -- eskatolog..nn.1
  eskatologi_1_N : N ; -- eskatologi..nn.1
  eskatologisk_1_A : A ; -- eskatologisk..av.1
  eskimå_1_N : N ; -- eskimå..nn.1
  eskimåhund_1_N : N ; -- eskimåhund..nn.1
  eskimåiska_1_N : N ; -- eskimåiska..nn.1
  eskort_1_N : N ; -- eskort..nn.1
  eskortbransch_1_N : N ; -- eskortbransch..nn.1
  eskortera_1_V : V ; -- eskortera..vb.1
  eskorterande_1_N : N ; -- eskorterande..nn.1
  eskorterbar_1_A : A ; -- eskorterbar..av.1
  eskorterbarhet_1_N : N ; -- eskorterbarhet..nn.1
  eskortering_1_N : N ; -- eskortering..nn.1
  eskortflicka_1_N : N ; -- eskortflicka..nn.1
  eskortkvinna_1_N : N ; -- eskortkvinna..nn.1
  eskulap_1_N : N ; -- eskulap..nn.1
  eskulapstav_1_N : N ; -- eskulapstav..nn.1
  esoterisk_1_A : A ; -- esoterisk..av.1
  espadrill_1_N : N ; -- espadrill..nn.1
  espagnolett_1_N : N ; -- espagnolett..nn.1
  esparto_1_N : N ; -- esparto..nn.1
  espartogräs_1_N : N ; -- espartogräs..nn.1
  esperantist_1_N : N ; -- esperantist..nn.1
  esperanto_1_N : N ; -- esperanto..nn.1
  esplanad_1_N : N ; -- esplanad..nn.1
  espresso_1_N : N ; -- espresso..nn.1
  espressobryggare_1_N : N ; -- espressobryggare..nn.1
  espri_1_N : N ; -- espri..nn.1
  espri_2_N : N ; -- espri..nn.2
  esprit_1_N : N ; -- esprit..nn.1
  esprit_2_N : N ; -- esprit..nn.2
  ess_1_N : N ; -- ess..nn.1
  essay_1_N : N ; -- essay..nn.1
  essayist_1_N : N ; -- essayist..nn.1
  essayistik_1_N : N ; -- essayistik..nn.1
  essayistisk_1_A : A ; -- essayistisk..av.1
  essaysamling_1_N : N ; -- essaysamling..nn.1
  essens_1_N : N ; -- essens..nn.1
  essens_2_N : N ; -- essens..nn.2
  essentiell_1_A : A ; -- essentiell..av.1
  essiv_1_N : N ; -- essiv..nn.1
  essä_1_N : N ; -- essä..nn.1
  essäbok_1_N : N ; -- essäbok..nn.1
  essäfråga_1_N : N ; -- essäfråga..nn.1
  essäist_1_N : N ; -- essäist..nn.1
  essäistik_1_N : N ; -- essäistik..nn.1
  essäistisk_1_A : A ; -- essäistisk..av.1
  essäsamling_1_N : N ; -- essäsamling..nn.1
  essäskrivande_1_A : A ; -- essäskrivande..av.1
  essäskrivande_1_N : N ; -- essäskrivande..nn.1
  essäuppgift_1_N : N ; -- essäuppgift..nn.1
  est_1_N : N ; -- est..nn.1
  ester_1_N : N ; -- ester..nn.1
  esterplast_1_N : N ; -- esterplast..nn.1
  estet_1_N : N ; -- estet..nn.1
  esteticera_1_V : V ; -- esteticera..vb.1
  esteticerande_1_N : N ; -- esteticerande..nn.1
  esteticerbar_1_A : A ; -- esteticerbar..av.1
  esteticerbarhet_1_N : N ; -- esteticerbarhet..nn.1
  esteticering_1_N : N ; -- esteticering..nn.1
  esteticism_1_N : N ; -- esteticism..nn.1
  estetik_1_N : N ; -- estetik..nn.1
  estetiker_1_N : N ; -- estetiker..nn.1
  estetisera_1_V : V ; -- estetisera..vb.1
  estetiserande_1_N : N ; -- estetiserande..nn.1
  estetiserbar_1_A : A ; -- estetiserbar..av.1
  estetiserbarhet_1_N : N ; -- estetiserbarhet..nn.1
  estetisering_1_N : N ; -- estetisering..nn.1
  estetisk_1_A : A ; -- estetisk..av.1
  estimera_1_V : V ; -- estimera..vb.1
  estimerande_1_N : N ; -- estimerande..nn.1
  estimerbar_1_A : A ; -- estimerbar..av.1
  estimerbarhet_1_N : N ; -- estimerbarhet..nn.1
  estimering_1_N : N ; -- estimering..nn.1
  estländare_1_N : N ; -- estländare..nn.1
  estländsk_1_A : A ; -- estländsk..av.1
  estländska_1_N : N ; -- estländska..nn.1
  estnisk_1_A : A ; -- estnisk..av.1
  estniska_1_N : N ; -- estniska..nn.1
  estniska_2_N : N ; -- estniska..nn.2
  estrad_1_N : N ; -- estrad..nn.1
  estradartist_1_N : N ; -- estradartist..nn.1
  estraddebatt_1_N : N ; -- estraddebatt..nn.1
  estradplats_1_N : N ; -- estradplats..nn.1
  estradsamtal_1_N : N ; -- estradsamtal..nn.1
  estradör_1_N : N ; -- estradör..nn.1
  eta_1_N : N ; -- eta..nn.1
  etablera_1_V : V ; -- etablera..vb.1
  etablerad_1_A : A ; -- etablerad..av.1
  etablerande_1_N : N ; -- etablerande..nn.1
  etablerbar_1_A : A ; -- etablerbar..av.1
  etablerbarhet_1_N : N ; -- etablerbarhet..nn.1
  etablering_1_N : N ; -- etablering..nn.1
  etablissemang_1_N : N ; -- etablissemang..nn.1
  etablissemangsföreträdare_1_N : N ; -- etablissemangsföreträdare..nn.1
  etablissement_1_N : N ; -- etablissement..nn.1
  etage_1_N : N ; -- etage..nn.1
  etagevåning_1_N : N ; -- etagevåning..nn.1
  etagär_1_N : N ; -- etagär..nn.1
  etalong_1_N : N ; -- etalong..nn.1
  etan_1_N : N ; -- etan..nn.1
  etanol_1_N : N ; -- etanol..nn.1
  etanolbil_1_N : N ; -- etanolbil..nn.1
  etanoldriven_1_A : A ; -- etanoldriven..av.1
  etapp_1_N : N ; -- etapp..nn.1
  etapplinje_1_N : N ; -- etapplinje..nn.1
  etappstation_1_N : N ; -- etappstation..nn.1
  etappvis_1_Adv : Adv ; -- etappvis..ab.1
  etappväsen_1_N : N ; -- etappväsen..nn.1
  eten_1_N : N ; -- eten..nn.1
  etenplast_1_N : N ; -- etenplast..nn.1
  eter_1_N : N ; -- eter..nn.1
  eter_2_N : N ; -- eter..nn.2
  eterflaska_1_N : N ; -- eterflaska..nn.1
  eterisation_1_N : N ; -- eterisation..nn.1
  eterisera_1_V : V ; -- eterisera..vb.1
  eteriserande_1_N : N ; -- eteriserande..nn.1
  eteriserbar_1_A : A ; -- eteriserbar..av.1
  eteriserbarhet_1_N : N ; -- eteriserbarhet..nn.1
  eterisering_1_N : N ; -- eterisering..nn.1
  eterisk_1_A : A ; -- eterisk..av.1
  etermediemonopol_1_N : N ; -- etermediemonopol..nn.1
  etermedium_1_N : N ; -- etermedium..nn.1
  eternell_1_N : N ; -- eternell..nn.1
  etik_1_N : N ; -- etik..nn.1
  etiker_1_N : N ; -- etiker..nn.1
  etikett_1_N : N ; -- etikett..nn.1
  etikettera_1_V : V ; -- etikettera..vb.1
  etiketterande_1_N : N ; -- etiketterande..nn.1
  etiketterbar_1_A : A ; -- etiketterbar..av.1
  etiketterbarhet_1_N : N ; -- etiketterbarhet..nn.1
  etikettering_1_N : N ; -- etikettering..nn.1
  etikettmoln_1_N : N ; -- etikettmoln..nn.1
  etikettråd_1_N : N ; -- etikettråd..nn.1
  etikettsfel_1_N : N ; -- etikettsfel..nn.1
  etikettsfråga_1_N : N ; -- etikettsfråga..nn.1
  etikettsmässig_1_A : A ; -- etikettsmässig..av.1
  etikpröva_1_V : V ; -- etikpröva..vb.1
  etikprövande_1_N : N ; -- etikprövande..nn.1
  etikprövning_1_N : N ; -- etikprövning..nn.1
  etikprövningslag_1_N : N ; -- etikprövningslag..nn.1
  etiolering_1_N : N ; -- etiolering..nn.1
  etiologi_1_N : N ; -- etiologi..nn.1
  etiologisk_1_A : A ; -- etiologisk..av.1
  etiop_1_N : N ; -- etiop..nn.1
  etiopier_1_N : N ; -- etiopier..nn.1
  etiopisk_1_A : A ; -- etiopisk..av.1
  etiopiska_1_N : N ; -- etiopiska..nn.1
  etiopiska_2_N : N ; -- etiopiska..nn.2
  etisk_1_A : A ; -- etisk..av.1
  etnicitet_1_N : N ; -- etnicitet..nn.1
  etnifiera_1_V : V ; -- etnifiera..vb.1
  etnifierande_1_N : N ; -- etnifierande..nn.1
  etnifierbar_1_A : A ; -- etnifierbar..av.1
  etnifierbarhet_1_N : N ; -- etnifierbarhet..nn.1
  etnifiering_1_N : N ; -- etnifiering..nn.1
  etnisk_1_A : A ; -- etnisk..av.1
  etnocentrisk_1_A : A ; -- etnocentrisk..av.1
  etnocentrism_1_N : N ; -- etnocentrism..nn.1
  etnograf_1_N : N ; -- etnograf..nn.1
  etnografi_1_N : N ; -- etnografi..nn.1
  etnografisk_1_A : A ; -- etnografisk..av.1
  etnolog_1_N : N ; -- etnolog..nn.1
  etnologi_1_N : N ; -- etnologi..nn.1
  etnologisk_1_A : A ; -- etnologisk..av.1
  etolog_1_N : N ; -- etolog..nn.1
  etologi_1_N : N ; -- etologi..nn.1
  etologisk_1_A : A ; -- etologisk..av.1
  etrusk_1_N : N ; -- etrusk..nn.1
  etrusker_1_N : N ; -- etrusker..nn.1
  etruskisk_1_A : A ; -- etruskisk..av.1
  etruskiska_1_N : N ; -- etruskiska..nn.1
  etruskiska_2_N : N ; -- etruskiska..nn.2
  etruskologi_1_N : N ; -- etruskologi..nn.1
  etsa_1_V : V ; -- etsa..vb.1
  etsande_1_N : N ; -- etsande..nn.1
  etsare_1_N : N ; -- etsare..nn.1
  etsmedel_1_N : N ; -- etsmedel..nn.1
  etsning_1_N : N ; -- etsning..nn.1
  etsnål_1_N : N ; -- etsnål..nn.1
  ett_tu_tre_1_Adv : Adv ; -- ett-tu-tre..ab.1
  ett_1_A : A ; -- ett..av.1
  etta_1_N : N ; -- etta..nn.1
  etter_1_N : N ; -- etter..nn.1
  ettermyra_1_N : N ; -- ettermyra..nn.1
  ettrig_1_A : A ; -- ettrig..av.1
  ettrighet_1_N : N ; -- ettrighet..nn.1
  ettrumslägenhet_1_N : N ; -- ettrumslägenhet..nn.1
  ettstruken_1_A : A ; -- ettstruken..av.1
  ettårig_1_A : A ; -- ettårig..av.1
  ettåring_1_N : N ; -- ettåring..nn.1
  ettöring_1_N : N ; -- ettöring..nn.1
  etui_1_N : N ; -- etui..nn.1
  etyd_1_N : N ; -- etyd..nn.1
  etyl_1_N : N ; -- etyl..nn.1
  etylalkohol_1_N : N ; -- etylalkohol..nn.1
  etylen_1_N : N ; -- etylen..nn.1
  etymolog_1_N : N ; -- etymolog..nn.1
  etymologi_1_N : N ; -- etymologi..nn.1
  etymologisera_1_V : V ; -- etymologisera..vb.1
  etymologiserande_1_N : N ; -- etymologiserande..nn.1
  etymologiserbar_1_A : A ; -- etymologiserbar..av.1
  etymologiserbarhet_1_N : N ; -- etymologiserbarhet..nn.1
  etymologisering_1_N : N ; -- etymologisering..nn.1
  etymologisk_1_A : A ; -- etymologisk..av.1
  etyn_1_N : N ; -- etyn..nn.1
  eudemonism_1_N : N ; -- eudemonism..nn.1
  eufemism_1_N : N ; -- eufemism..nn.1
  eufemistisk_1_A : A ; -- eufemistisk..av.1
  eufoni_1_N : N ; -- eufoni..nn.1
  euforbia_1_N : N ; -- euforbia..nn.1
  eufori_1_N : N ; -- eufori..nn.1
  euforisk_1_A : A ; -- euforisk..av.1
  eugenik_1_N : N ; -- eugenik..nn.1
  eukalyptus_1_N : N ; -- eukalyptus..nn.1
  eukalyptusdoftande_1_A : A ; -- eukalyptusdoftande..av.1
  eukalyptusolja_1_N : N ; -- eukalyptusolja..nn.1
  eukaryot_1_N : N ; -- eukaryot..nn.1
  euklidisk_1_A : A ; -- euklidisk..av.1
  eumenid_1_N : N ; -- eumenid..nn.1
  eunuck_1_N : N ; -- eunuck..nn.1
  eurasier_1_N : N ; -- eurasier..nn.1
  eurasisk_1_A : A ; -- eurasisk..av.1
  eurasiska_1_N : N ; -- eurasiska..nn.1
  euro_1_N : N ; -- euro..nn.1
  eurodollar_1_N : N ; -- eurodollar..nn.1
  euroislam_1_N : N ; -- euroislam..nn.1
  eurokalabalik_1_N : N ; -- eurokalabalik..nn.1
  eurokommunism_1_N : N ; -- eurokommunism..nn.1
  eurokommunistisk_1_A : A ; -- eurokommunistisk..av.1
  eurokris_1_N : N ; -- eurokris..nn.1
  euroland_1_N : N ; -- euroland..nn.1
  europabörs_1_N : N ; -- europabörs..nn.1
  europamästare_1_N : N ; -- europamästare..nn.1
  europamästerskap_1_N : N ; -- europamästerskap..nn.1
  europaparlamentsval_1_N : N ; -- europaparlamentsval..nn.1
  europaväg_1_N : N ; -- europaväg..nn.1
  europavänster_1_N : N ; -- europavänster..nn.1
  europeisera_1_V : V ; -- europeisera..vb.1
  europeiserande_1_N : N ; -- europeiserande..nn.1
  europeiserbar_1_A : A ; -- europeiserbar..av.1
  europeiserbarhet_1_N : N ; -- europeiserbarhet..nn.1
  europeisering_1_N : N ; -- europeisering..nn.1
  europeisk_1_A : A ; -- europeisk..av.1
  europeiska_1_N : N ; -- europeiska..nn.1
  europid_1_A : A ; -- europid..av.1
  europid_1_N : N ; -- europid..nn.1
  europium_1_N : N ; -- europium..nn.1
  europé_1_N : N ; -- europé..nn.1
  eurosamarbete_1_N : N ; -- eurosamarbete..nn.1
  euroskeptisk_1_A : A ; -- euroskeptisk..av.1
  eurovaluta_1_N : N ; -- eurovaluta..nn.1
  eurovision_1_N : N ; -- eurovision..nn.1
  eurytmi_1_N : N ; -- eurytmi..nn.1
  eusocialitet_1_N : N ; -- eusocialitet..nn.1
  eutanasi_1_N : N ; -- eutanasi..nn.1
  eutrof_1_A : A ; -- eutrof..av.1
  eva_1_N : N ; -- eva..nn.1
  evakostym_1_N : N ; -- evakostym..nn.1
  evakuera_1_V : V ; -- evakuera..vb.1
  evakuerande_1_N : N ; -- evakuerande..nn.1
  evakuerbar_1_A : A ; -- evakuerbar..av.1
  evakuerbarhet_1_N : N ; -- evakuerbarhet..nn.1
  evakuering_1_N : N ; -- evakuering..nn.1
  evaluera_1_V : V ; -- evaluera..vb.1
  evaluerande_1_N : N ; -- evaluerande..nn.1
  evaluerbar_1_A : A ; -- evaluerbar..av.1
  evaluerbarhet_1_N : N ; -- evaluerbarhet..nn.1
  evaluering_1_N : N ; -- evaluering..nn.1
  evalvera_1_V : V ; -- evalvera..vb.1
  evalverande_1_N : N ; -- evalverande..nn.1
  evalverbar_1_A : A ; -- evalverbar..av.1
  evalverbarhet_1_N : N ; -- evalverbarhet..nn.1
  evalvering_1_N : N ; -- evalvering..nn.1
  evangeliebok_1_N : N ; -- evangeliebok..nn.1
  evangelietext_1_N : N ; -- evangelietext..nn.1
  evangelisation_1_N : N ; -- evangelisation..nn.1
  evangelisera_1_V : V ; -- evangelisera..vb.1
  evangeliserande_1_N : N ; -- evangeliserande..nn.1
  evangelisering_1_N : N ; -- evangelisering..nn.1
  evangelisk_1_A : A ; -- evangelisk..av.1
  evangelist_1_N : N ; -- evangelist..nn.1
  evangelium_1_N : N ; -- evangelium..nn.1
  evaporation_1_N : N ; -- evaporation..nn.1
  evaporera_1_V : V ; -- evaporera..vb.1
  evaporerande_1_N : N ; -- evaporerande..nn.1
  evaporerbar_1_A : A ; -- evaporerbar..av.1
  evaporerbarhet_1_N : N ; -- evaporerbarhet..nn.1
  evaporering_1_N : N ; -- evaporering..nn.1
  evart_1_Adv : Adv ; -- evart..ab.1
  evenemang_1_N : N ; -- evenemang..nn.1
  eventualitet_1_N : N ; -- eventualitet..nn.1
  eventuell_1_A : A ; -- eventuell..av.1
  evergreen_1_N : N ; -- evergreen..nn.1
  evertebrat_1_N : N ; -- evertebrat..nn.1
  evidens_1_N : N ; -- evidens..nn.1
  evidensbaserad_1_A : A ; -- evidensbaserad..av.1
  evident_1_A : A ; -- evident..av.1
  evig_1_A : A ; -- evig..av.1
  evighet_1_N : N ; -- evighet..nn.1
  evighetsblomma_1_N : N ; -- evighetsblomma..nn.1
  evighetsfilter_1_N : N ; -- evighetsfilter..nn.1
  evighetsgäldenär_1_N : N ; -- evighetsgäldenär..nn.1
  evighetskalender_1_N : N ; -- evighetskalender..nn.1
  evighetslång_1_A : A ; -- evighetslång..av.1
  evighetsmaskin_1_N : N ; -- evighetsmaskin..nn.1
  evinnerlig_1_A : A ; -- evinnerlig..av.1
  evinnerligen_1_Adv : Adv ; -- evinnerligen..ab.1
  evinnerlighet_1_N : N ; -- evinnerlighet..nn.1
  evolution_1_N : N ; -- evolution..nn.1
  evolutionism_1_N : N ; -- evolutionism..nn.1
  evolutionist_1_N : N ; -- evolutionist..nn.1
  evolutionistisk_1_A : A ; -- evolutionistisk..av.1
  evolutionsbiolog_1_N : N ; -- evolutionsbiolog..nn.1
  evolutionsforskning_1_N : N ; -- evolutionsforskning..nn.1
  evolutionsmekanism_1_N : N ; -- evolutionsmekanism..nn.1
  evolutionsmässig_1_A : A ; -- evolutionsmässig..av.1
  evolutionsmässighet_1_N : N ; -- evolutionsmässighet..nn.1
  evolutionsteori_1_N : N ; -- evolutionsteori..nn.1
  evolutionär_1_A : A ; -- evolutionär..av.1
  evärdlig_1_A : A ; -- evärdlig..av.1
  evärdlighet_1_N : N ; -- evärdlighet..nn.1
  ex_1_N : N ; -- ex..nn.1
  exabyte_1_N : N ; -- exabyte..nn.1
  exakt_1_A : A ; -- exakt..av.1
  exakthet_1_N : N ; -- exakthet..nn.1
  exaltation_1_N : N ; -- exaltation..nn.1
  exalterad_1_A : A ; -- exalterad..av.1
  examen_1_N : N ; -- examen..nn.1
  examensarbete_1_N : N ; -- examensarbete..nn.1
  examensfråga_1_N : N ; -- examensfråga..nn.1
  examensuppgift_1_N : N ; -- examensuppgift..nn.1
  examinand_1_N : N ; -- examinand..nn.1
  examination_1_N : N ; -- examination..nn.1
  examinator_1_N : N ; -- examinator..nn.1
  examinatorium_1_N : N ; -- examinatorium..nn.1
  examinera_1_V : V ; -- examinera..vb.1
  examinerande_1_N : N ; -- examinerande..nn.1
  examinerbar_1_A : A ; -- examinerbar..av.1
  examinerbarhet_1_N : N ; -- examinerbarhet..nn.1
  examinering_1_N : N ; -- examinering..nn.1
  exantem_1_N : N ; -- exantem..nn.1
  excellens_1_N : N ; -- excellens..nn.1
  excellent_1_A : A ; -- excellent..av.1
  excellera_1_V : V ; -- excellera..vb.1
  excellerande_1_N : N ; -- excellerande..nn.1
  excellering_1_N : N ; -- excellering..nn.1
  excenter_1_N : N ; -- excenter..nn.1
  excenteraxel_1_N : N ; -- excenteraxel..nn.1
  excenterskiva_1_N : N ; -- excenterskiva..nn.1
  excenterstång_1_N : N ; -- excenterstång..nn.1
  excentricitet_1_N : N ; -- excentricitet..nn.1
  excentriker_1_N : N ; -- excentriker..nn.1
  excentrisk_1_A : A ; -- excentrisk..av.1
  exceptionell_1_A : A ; -- exceptionell..av.1
  excerpera_1_V : V ; -- excerpera..vb.1
  excerperande_1_N : N ; -- excerperande..nn.1
  excerperbar_1_A : A ; -- excerperbar..av.1
  excerperbarhet_1_N : N ; -- excerperbarhet..nn.1
  excerpering_1_N : N ; -- excerpering..nn.1
  excerpist_1_N : N ; -- excerpist..nn.1
  excerpt_1_N : N ; -- excerpt..nn.1
  excess_1_N : N ; -- excess..nn.1
  excessiv_1_A : A ; -- excessiv..av.1
  excision_1_N : N ; -- excision..nn.1
  excitation_1_N : N ; -- excitation..nn.1
  excitera_1_V : V ; -- excitera..vb.1
  exciterande_1_N : N ; -- exciterande..nn.1
  exciterbar_1_A : A ; -- exciterbar..av.1
  exciterbarhet_1_N : N ; -- exciterbarhet..nn.1
  excitering_1_N : N ; -- excitering..nn.1
  exeges_1_N : N ; -- exeges..nn.1
  exeget_1_N : N ; -- exeget..nn.1
  exegetik_1_N : N ; -- exegetik..nn.1
  exegetisk_1_A : A ; -- exegetisk..av.1
  exekution_1_N : N ; -- exekution..nn.1
  exekutionspluton_1_N : N ; -- exekutionspluton..nn.1
  exekutiv_1_A : A ; -- exekutiv..av.1
  exekutiv_1_N : N ; -- exekutiv..nn.1
  exekutor_1_N : N ; -- exekutor..nn.1
  exekutorisk_1_A : A ; -- exekutorisk..av.1
  exekutör_1_N : N ; -- exekutör..nn.1
  exekvera_1_V : V ; -- exekvera..vb.1
  exekverande_1_N : N ; -- exekverande..nn.1
  exekverbar_1_A : A ; -- exekverbar..av.1
  exekverbarhet_1_N : N ; -- exekverbarhet..nn.1
  exekvering_1_N : N ; -- exekvering..nn.1
  exempel_1_N : N ; -- exempel..nn.1
  exempellös_1_A : A ; -- exempellös..av.1
  exempellöshet_1_N : N ; -- exempellöshet..nn.1
  exempelsamling_1_N : N ; -- exempelsamling..nn.1
  exempelvis_1_Adv : Adv ; -- exempelvis..ab.1
  exemplar_1_N : N ; -- exemplar..nn.1
  exemplarisk_1_A : A ; -- exemplarisk..av.1
  exemplifiera_1_V : V ; -- exemplifiera..vb.1
  exemplifierande_1_N : N ; -- exemplifierande..nn.1
  exemplifierbar_1_A : A ; -- exemplifierbar..av.1
  exemplifierbarhet_1_N : N ; -- exemplifierbarhet..nn.1
  exemplifiering_1_N : N ; -- exemplifiering..nn.1
  exemplifikation_1_N : N ; -- exemplifikation..nn.1
  exercera_1_V : V ; -- exercera..vb.1
  exercerande_1_N : N ; -- exercerande..nn.1
  exercerbar_1_A : A ; -- exercerbar..av.1
  exercerbarhet_1_N : N ; -- exercerbarhet..nn.1
  exercering_1_N : N ; -- exercering..nn.1
  exercis_1_N : N ; -- exercis..nn.1
  exercisfält_1_N : N ; -- exercisfält..nn.1
  exflickvän_1_N : N ; -- exflickvän..nn.1
  exfru_1_N : N ; -- exfru..nn.1
  exhalterad_1_A : A ; -- exhalterad..av.1
  exhibitionism_1_N : N ; -- exhibitionism..nn.1
  exhibitionist_1_N : N ; -- exhibitionist..nn.1
  exhibitionistisk_1_A : A ; -- exhibitionistisk..av.1
  exhustru_1_N : N ; -- exhustru..nn.1
  exigibel_1_A : A ; -- exigibel..av.1
  exil_1_N : N ; -- exil..nn.1
  exilhuvudstad_1_N : N ; -- exilhuvudstad..nn.1
  exin_1_N : N ; -- exin..nn.1
  existens_1_N : N ; -- existens..nn.1
  existensberättigande_1_N : N ; -- existensberättigande..nn.1
  existensform_1_N : N ; -- existensform..nn.1
  existensmedel_1_N : N ; -- existensmedel..nn.1
  existensminimum_1_N : N ; -- existensminimum..nn.1
  existensvillkor_1_N : N ; -- existensvillkor..nn.1
  existentialism_1_N : N ; -- existentialism..nn.1
  existentialistisk_1_A : A ; -- existentialistisk..av.1
  existentiell_1_A : A ; -- existentiell..av.1
  existera_1_V : V ; -- existera..vb.1
  existerande_1_A : A ; -- existerande..av.1
  existerande_1_N : N ; -- existerande..nn.1
  exklamation_1_N : N ; -- exklamation..nn.1
  exklamatorisk_1_A : A ; -- exklamatorisk..av.1
  exklav_1_N : N ; -- exklav..nn.1
  exkludera_1_V : V ; -- exkludera..vb.1
  exkluderande_1_N : N ; -- exkluderande..nn.1
  exkluderbar_1_A : A ; -- exkluderbar..av.1
  exkluderbarhet_1_N : N ; -- exkluderbarhet..nn.1
  exkludering_1_N : N ; -- exkludering..nn.1
  exklusiv_1_A : A ; -- exklusiv..av.1
  exklusivitet_1_N : N ; -- exklusivitet..nn.1
  exkommunicera_1_V : V ; -- exkommunicera..vb.1
  exkommunicerande_1_N : N ; -- exkommunicerande..nn.1
  exkommunicerbar_1_A : A ; -- exkommunicerbar..av.1
  exkommunicerbarhet_1_N : N ; -- exkommunicerbarhet..nn.1
  exkommunicering_1_N : N ; -- exkommunicering..nn.1
  exkommunikation_1_N : N ; -- exkommunikation..nn.1
  exkommunistisk_1_A : A ; -- exkommunistisk..av.1
  exkonung_1_N : N ; -- exkonung..nn.1
  exkrement_1_N : N ; -- exkrement..nn.1
  exkremental_1_A : A ; -- exkremental..av.1
  exkret_1_N : N ; -- exkret..nn.1
  exkretion_1_N : N ; -- exkretion..nn.1
  exkung_1_N : N ; -- exkung..nn.1
  exkurs_1_N : N ; -- exkurs..nn.1
  exkursion_1_N : N ; -- exkursion..nn.1
  exlibris_1_N : N ; -- exlibris..nn.1
  exodus_1_N : N ; -- exodus..nn.1
  exoftalmometer_1_N : N ; -- exoftalmometer..nn.1
  exoftalmus_1_N : N ; -- exoftalmus..nn.1
  exogen_1_A : A ; -- exogen..av.1
  exonym_1_N : N ; -- exonym..nn.1
  exoplanet_1_N : N ; -- exoplanet..nn.1
  exorcism_1_N : N ; -- exorcism..nn.1
  exorcist_1_N : N ; -- exorcist..nn.1
  exorcistisk_1_A : A ; -- exorcistisk..av.1
  exoterisk_1_A : A ; -- exoterisk..av.1
  exotermisk_1_A : A ; -- exotermisk..av.1
  exotisk_1_A : A ; -- exotisk..av.1
  exotism_1_N : N ; -- exotism..nn.1
  exotistisk_1_A : A ; -- exotistisk..av.1
  expandera_1_V : V ; -- expandera..vb.1
  expanderande_1_N : N ; -- expanderande..nn.1
  expanderbar_1_A : A ; -- expanderbar..av.1
  expanderbarhet_1_N : N ; -- expanderbarhet..nn.1
  expandering_1_N : N ; -- expandering..nn.1
  expansibel_1_A : A ; -- expansibel..av.1
  expansion_1_N : N ; -- expansion..nn.1
  expansionism_1_N : N ; -- expansionism..nn.1
  expansionistisk_1_A : A ; -- expansionistisk..av.1
  expansionskraft_1_N : N ; -- expansionskraft..nn.1
  expansionskärl_1_N : N ; -- expansionskärl..nn.1
  expansionsplan_1_N : N ; -- expansionsplan..nn.1
  expansionstakt_1_N : N ; -- expansionstakt..nn.1
  expansionsvilja_1_N : N ; -- expansionsvilja..nn.1
  expansiv_1_A : A ; -- expansiv..av.1
  expatriera_1_V : V ; -- expatriera..vb.1
  expatrierande_1_N : N ; -- expatrierande..nn.1
  expatrierbar_1_A : A ; -- expatrierbar..av.1
  expatrierbarhet_1_N : N ; -- expatrierbarhet..nn.1
  expatriering_1_N : N ; -- expatriering..nn.1
  expediera_1_V : V ; -- expediera..vb.1
  expedierande_1_N : N ; -- expedierande..nn.1
  expedierbar_1_A : A ; -- expedierbar..av.1
  expedierbarhet_1_N : N ; -- expedierbarhet..nn.1
  expediering_1_N : N ; -- expediering..nn.1
  expedit_1_A : A ; -- expedit..av.1
  expedit_1_N : N ; -- expedit..nn.1
  expedition_1_N : N ; -- expedition..nn.1
  expeditionschef_1_N : N ; -- expeditionschef..nn.1
  expeditionskår_1_N : N ; -- expeditionskår..nn.1
  expeditionsledare_1_N : N ; -- expeditionsledare..nn.1
  expeditionsministär_1_N : N ; -- expeditionsministär..nn.1
  expeditionsregering_1_N : N ; -- expeditionsregering..nn.1
  expeditionsvakt_1_N : N ; -- expeditionsvakt..nn.1
  expeditör_1_N : N ; -- expeditör..nn.1
  expektoration_1_N : N ; -- expektoration..nn.1
  expektorera_1_V : V ; -- expektorera..vb.1
  expektorerande_1_N : N ; -- expektorerande..nn.1
  expektorerbar_1_A : A ; -- expektorerbar..av.1
  expektorerbarhet_1_N : N ; -- expektorerbarhet..nn.1
  expektorering_1_N : N ; -- expektorering..nn.1
  experiment_1_N : N ; -- experiment..nn.1
  experimentalfysiker_1_N : N ; -- experimentalfysiker..nn.1
  experimentalkirurgi_1_N : N ; -- experimentalkirurgi..nn.1
  experimentator_1_N : N ; -- experimentator..nn.1
  experimentell_1_A : A ; -- experimentell..av.1
  experimentera_1_V : V ; -- experimentera..vb.1
  experimenterande_1_N : N ; -- experimenterande..nn.1
  experimentering_1_N : N ; -- experimentering..nn.1
  experimentfält_1_N : N ; -- experimentfält..nn.1
  experimentgymnasium_1_N : N ; -- experimentgymnasium..nn.1
  experimentlusta_1_N : N ; -- experimentlusta..nn.1
  experimentstation_1_N : N ; -- experimentstation..nn.1
  expert_1_N : N ; -- expert..nn.1
  expertgrupp_1_N : N ; -- expertgrupp..nn.1
  expertis_1_N : N ; -- expertis..nn.1
  expertkommentator_1_N : N ; -- expertkommentator..nn.1
  expertkommitté_1_N : N ; -- expertkommitté..nn.1
  expertkrets_1_N : N ; -- expertkrets..nn.1
  expertspråk_1_N : N ; -- expertspråk..nn.1
  expertutlåtande_1_N : N ; -- expertutlåtande..nn.1
  expertutredare_1_N : N ; -- expertutredare..nn.1
  explanativ_1_A : A ; -- explanativ..av.1
  explicera_1_V : V ; -- explicera..vb.1
  explicerande_1_N : N ; -- explicerande..nn.1
  explicerbar_1_A : A ; -- explicerbar..av.1
  explicerbarhet_1_N : N ; -- explicerbarhet..nn.1
  explicering_1_N : N ; -- explicering..nn.1
  explicit_1_A : A ; -- explicit..av.1
  explicithet_1_N : N ; -- explicithet..nn.1
  explikation_1_N : N ; -- explikation..nn.1
  exploatera_1_V : V ; -- exploatera..vb.1
  exploaterande_1_N : N ; -- exploaterande..nn.1
  exploaterbar_1_A : A ; -- exploaterbar..av.1
  exploaterbarhet_1_N : N ; -- exploaterbarhet..nn.1
  exploatering_1_N : N ; -- exploatering..nn.1
  exploateringsyta_1_N : N ; -- exploateringsyta..nn.1
  exploatör_1_N : N ; -- exploatör..nn.1
  explodera_1_V : V ; -- explodera..vb.1
  exploderande_1_N : N ; -- exploderande..nn.1
  exploderbar_1_A : A ; -- exploderbar..av.1
  exploderbarhet_1_N : N ; -- exploderbarhet..nn.1
  explodering_1_N : N ; -- explodering..nn.1
  explosion_1_N : N ; -- explosion..nn.1
  explosionsartad_1_A : A ; -- explosionsartad..av.1
  explosionsförlopp_1_N : N ; -- explosionsförlopp..nn.1
  explosionshärd_1_N : N ; -- explosionshärd..nn.1
  explosionsmotor_1_N : N ; -- explosionsmotor..nn.1
  explosionsområde_1_N : N ; -- explosionsområde..nn.1
  explosionsrisk_1_N : N ; -- explosionsrisk..nn.1
  explosionssätt_1_N : N ; -- explosionssätt..nn.1
  explosionsögonblick_1_N : N ; -- explosionsögonblick..nn.1
  explosiv_1_A : A ; -- explosiv..av.1
  explosiva_1_N : N ; -- explosiva..nn.1
  expo_1_N : N ; -- expo..nn.1
  expojkvän_1_N : N ; -- expojkvän..nn.1
  exponent_1_N : N ; -- exponent..nn.1
  exponentialfunktion_1_N : N ; -- exponentialfunktion..nn.1
  exponentiell_1_A : A ; -- exponentiell..av.1
  exponera_1_V : V ; -- exponera..vb.1
  exponerande_1_N : N ; -- exponerande..nn.1
  exponerbar_1_A : A ; -- exponerbar..av.1
  exponerbarhet_1_N : N ; -- exponerbarhet..nn.1
  exponering_1_N : N ; -- exponering..nn.1
  exponeringsmätare_1_N : N ; -- exponeringsmätare..nn.1
  export_1_N : N ; -- export..nn.1
  exportartikel_1_N : N ; -- exportartikel..nn.1
  exportberoende_1_A : A ; -- exportberoende..av.1
  exportberoende_1_N : N ; -- exportberoende..nn.1
  exportbolag_1_N : N ; -- exportbolag..nn.1
  exportera_1_V : V ; -- exportera..vb.1
  exporterande_1_N : N ; -- exporterande..nn.1
  exporterbar_1_A : A ; -- exporterbar..av.1
  exporterbarhet_1_N : N ; -- exporterbarhet..nn.1
  exportering_1_N : N ; -- exportering..nn.1
  exportfrämjande_1_A : A ; -- exportfrämjande..av.1
  exportförbud_1_N : N ; -- exportförbud..nn.1
  exporthandel_1_N : N ; -- exporthandel..nn.1
  exportindustri_1_N : N ; -- exportindustri..nn.1
  exportinkomst_1_N : N ; -- exportinkomst..nn.1
  exportmarknad_1_N : N ; -- exportmarknad..nn.1
  exportsprit_1_N : N ; -- exportsprit..nn.1
  exportöl_1_N : N ; -- exportöl..nn.1
  exportör_1_N : N ; -- exportör..nn.1
  exposition_1_N : N ; -- exposition..nn.1
  exposé_1_N : N ; -- exposé..nn.1
  expresident_1_N : N ; -- expresident..nn.1
  express_1_N : N ; -- express..nn.1
  expressbrev_1_N : N ; -- expressbrev..nn.1
  expressbud_1_N : N ; -- expressbud..nn.1
  expressbyrå_1_N : N ; -- expressbyrå..nn.1
  expressförsändelse_1_N : N ; -- expressförsändelse..nn.1
  expressionism_1_N : N ; -- expressionism..nn.1
  expressionist_1_N : N ; -- expressionist..nn.1
  expressionistisk_1_A : A ; -- expressionistisk..av.1
  expressiv_1_A : A ; -- expressiv..av.1
  expressivitet_1_N : N ; -- expressivitet..nn.1
  expresståg_1_N : N ; -- expresståg..nn.1
  expropriation_1_N : N ; -- expropriation..nn.1
  expropriationslag_1_N : N ; -- expropriationslag..nn.1
  expropriera_1_V : V ; -- expropriera..vb.1
  exproprierande_1_N : N ; -- exproprierande..nn.1
  exproprierbar_1_A : A ; -- exproprierbar..av.1
  exproprierbarhet_1_N : N ; -- exproprierbarhet..nn.1
  expropriering_1_N : N ; -- expropriering..nn.1
  exregent_1_N : N ; -- exregent..nn.1
  exsickat_1_N : N ; -- exsickat..nn.1
  exsickator_1_N : N ; -- exsickator..nn.1
  exspektans_1_N : N ; -- exspektans..nn.1
  exspiration_1_N : N ; -- exspiration..nn.1
  exspiratorisk_1_A : A ; -- exspiratorisk..av.1
  exstirpera_1_V : V ; -- exstirpera..vb.1
  exstirperande_1_N : N ; -- exstirperande..nn.1
  exstirperbar_1_A : A ; -- exstirperbar..av.1
  exstirperbarhet_1_N : N ; -- exstirperbarhet..nn.1
  exstirpering_1_N : N ; -- exstirpering..nn.1
  exsudat_1_N : N ; -- exsudat..nn.1
  extas_1_N : N ; -- extas..nn.1
  extatisk_1_A : A ; -- extatisk..av.1
  extemporera_1_V : V ; -- extemporera..vb.1
  extemporerande_1_N : N ; -- extemporerande..nn.1
  extemporerbar_1_A : A ; -- extemporerbar..av.1
  extemporerbarhet_1_N : N ; -- extemporerbarhet..nn.1
  extemporering_1_N : N ; -- extemporering..nn.1
  extension_1_N : N ; -- extension..nn.1
  extensiv_1_A : A ; -- extensiv..av.1
  exteriör_1_A : A ; -- exteriör..av.1
  exteriör_1_N : N ; -- exteriör..nn.1
  exteriörbedömning_1_N : N ; -- exteriörbedömning..nn.1
  extern_1_A : A ; -- extern..av.1
  extern_1_N : N ; -- extern..nn.1
  externat_1_N : N ; -- externat..nn.1
  exterritorialrätt_1_N : N ; -- exterritorialrätt..nn.1
  exterritoriell_1_A : A ; -- exterritoriell..av.1
  extra_1_A : A ; -- extra..av.1
  extraarbete_1_N : N ; -- extraarbete..nn.1
  extrafilt_1_N : N ; -- extrafilt..nn.1
  extrafin_1_A : A ; -- extrafin..av.1
  extrahera_1_V : V ; -- extrahera..vb.1
  extraherande_1_N : N ; -- extraherande..nn.1
  extraherbar_1_A : A ; -- extraherbar..av.1
  extraherbarhet_1_N : N ; -- extraherbarhet..nn.1
  extrahering_1_N : N ; -- extrahering..nn.1
  extrahud_1_N : N ; -- extrahud..nn.1
  extrainkallad_1_A : A ; -- extrainkallad..av.1
  extrainkomst_1_N : N ; -- extrainkomst..nn.1
  extrajobb_1_N : N ; -- extrajobb..nn.1
  extrajudiciell_1_A : A ; -- extrajudiciell..av.1
  extraknäck_1_N : N ; -- extraknäck..nn.1
  extraknäcka_1_V : V ; -- extraknäcka..vb.1
  extraknäckande_1_N : N ; -- extraknäckande..nn.1
  extrakongress_1_N : N ; -- extrakongress..nn.1
  extrakontant_1_A : A ; -- extrakontant..av.1
  extrakt_1_N : N ; -- extrakt..nn.1
  extraktion_1_N : N ; -- extraktion..nn.1
  extraktivämne_1_N : N ; -- extraktivämne..nn.1
  extraktor_1_N : N ; -- extraktor..nn.1
  extralampa_1_N : N ; -- extralampa..nn.1
  extraljus_1_N : N ; -- extraljus..nn.1
  extralärare_1_N : N ; -- extralärare..nn.1
  extramural_1_A : A ; -- extramural..av.1
  extranummer_1_N : N ; -- extranummer..nn.1
  extraordinarie_1_A : A ; -- extraordinarie..av.1
  extraordinarie_1_N : N ; -- extraordinarie..nn.1
  extraordinär_1_A : A ; -- extraordinär..av.1
  extrapersonal_1_N : N ; -- extrapersonal..nn.1
  extrapolation_1_N : N ; -- extrapolation..nn.1
  extrapolera_1_V : V ; -- extrapolera..vb.1
  extrapolerande_1_N : N ; -- extrapolerande..nn.1
  extrapolerbar_1_A : A ; -- extrapolerbar..av.1
  extrapolerbarhet_1_N : N ; -- extrapolerbarhet..nn.1
  extrapolering_1_N : N ; -- extrapolering..nn.1
  extrapris_1_N : N ; -- extrapris..nn.1
  extraranson_1_N : N ; -- extraranson..nn.1
  extrasol_1_N : N ; -- extrasol..nn.1
  extrastämma_1_N : N ; -- extrastämma..nn.1
  extraterritoriell_1_A : A ; -- extraterritoriell..av.1
  extratur_1_N : N ; -- extratur..nn.1
  extratåg_1_N : N ; -- extratåg..nn.1
  extraupplaga_1_N : N ; -- extraupplaga..nn.1
  extrauterin_1_A : A ; -- extrauterin..av.1
  extravagans_1_N : N ; -- extravagans..nn.1
  extravagant_1_A : A ; -- extravagant..av.1
  extrem_1_A : A ; -- extrem..av.1
  extrem_1_N : N ; -- extrem..nn.1
  extremfall_1_N : N ; -- extremfall..nn.1
  extremhöger_1_N : N ; -- extremhöger..nn.1
  extremism_1_N : N ; -- extremism..nn.1
  extremist_1_N : N ; -- extremist..nn.1
  extremistisk_1_A : A ; -- extremistisk..av.1
  extremitet_1_N : N ; -- extremitet..nn.1
  extremkyla_1_N : N ; -- extremkyla..nn.1
  extremnationalist_1_N : N ; -- extremnationalist..nn.1
  extremskidåkare_1_N : N ; -- extremskidåkare..nn.1
  extremskidåkning_1_N : N ; -- extremskidåkning..nn.1
  extremväder_1_N : N ; -- extremväder..nn.1
  extremvänster_1_N : N ; -- extremvänster..nn.1
  extremvärde_1_N : N ; -- extremvärde..nn.1
  extrinsisk_1_A : A ; -- extrinsisk..av.1
  extrovert_1_A : A ; -- extrovert..av.1
  extroverthet_1_N : N ; -- extroverthet..nn.1
  eye_liner_1_N : N ; -- eye-liner..nn.1
  eyeliner_1_N : N ; -- eyeliner..nn.1
  f_1_N : N ; -- f..nn.1
  fabel_1_N : N ; -- fabel..nn.1
  fabelaktig_1_A : A ; -- fabelaktig..av.1
  fabelaktighet_1_N : N ; -- fabelaktighet..nn.1
  fabeldiktare_1_N : N ; -- fabeldiktare..nn.1
  fabeldjur_1_N : N ; -- fabeldjur..nn.1
  fabelhjälte_1_N : N ; -- fabelhjälte..nn.1
  fabla_1_V : V ; -- fabla..vb.1
  fablande_1_N : N ; -- fablande..nn.1
  fabricera_1_V : V ; -- fabricera..vb.1
  fabricerande_1_N : N ; -- fabricerande..nn.1
  fabricerbar_1_A : A ; -- fabricerbar..av.1
  fabricerbarhet_1_N : N ; -- fabricerbarhet..nn.1
  fabricering_1_N : N ; -- fabricering..nn.1
  fabrik_1_N : N ; -- fabrik..nn.1
  fabrikant_1_N : N ; -- fabrikant..nn.1
  fabrikat_1_N : N ; -- fabrikat..nn.1
  fabrikation_1_N : N ; -- fabrikation..nn.1
  fabriksanläggning_1_N : N ; -- fabriksanläggning..nn.1
  fabriksarbetande_1_A : A ; -- fabriksarbetande..av.1
  fabriksarbetare_1_N : N ; -- fabriksarbetare..nn.1
  fabriksbyggnad_1_N : N ; -- fabriksbyggnad..nn.1
  fabrikskomplex_1_N : N ; -- fabrikskomplex..nn.1
  fabrikskvarter_1_N : N ; -- fabrikskvarter..nn.1
  fabrikslänga_1_N : N ; -- fabrikslänga..nn.1
  fabriksmässig_1_A : A ; -- fabriksmässig..av.1
  fabriksmässighet_1_N : N ; -- fabriksmässighet..nn.1
  fabriksny_1_A : A ; -- fabriksny..av.1
  fabriksområde_1_N : N ; -- fabriksområde..nn.1
  fabrikspipa_1_N : N ; -- fabrikspipa..nn.1
  fabriksport_1_N : N ; -- fabriksport..nn.1
  fabrikspris_1_N : N ; -- fabrikspris..nn.1
  fabriksskorsten_1_N : N ; -- fabriksskorsten..nn.1
  fabrikstomt_1_N : N ; -- fabrikstomt..nn.1
  fabrikör_1_N : N ; -- fabrikör..nn.1
  fabulera_1_V : V ; -- fabulera..vb.1
  fabulerande_1_N : N ; -- fabulerande..nn.1
  fabulerbar_1_A : A ; -- fabulerbar..av.1
  fabulerbarhet_1_N : N ; -- fabulerbarhet..nn.1
  fabulering_1_N : N ; -- fabulering..nn.1
  fabulös_1_A : A ; -- fabulös..av.1
  facebooka_1_V : V ; -- facebooka..vb.1
  facebookande_1_N : N ; -- facebookande..nn.1
  facebookbild_1_N : N ; -- facebookbild..nn.1
  facebookgrupp_1_N : N ; -- facebookgrupp..nn.1
  facebooksida_1_N : N ; -- facebooksida..nn.1
  facett_1_N : N ; -- facett..nn.1
  facettera_1_V : V ; -- facettera..vb.1
  facetterad_1_A : A ; -- facetterad..av.1
  facetterande_1_N : N ; -- facetterande..nn.1
  facetterbar_1_A : A ; -- facetterbar..av.1
  facetterbarhet_1_N : N ; -- facetterbarhet..nn.1
  facettering_1_N : N ; -- facettering..nn.1
  facettöga_1_N : N ; -- facettöga..nn.1
  facil_1_A : A ; -- facil..av.1
  facilitet_1_N : N ; -- facilitet..nn.1
  fack_1_N : N ; -- fack..nn.1
  fackelblomster_1_N : N ; -- fackelblomster..nn.1
  fackelbärare_1_N : N ; -- fackelbärare..nn.1
  fackelsken_1_N : N ; -- fackelsken..nn.1
  fackeltåg_1_N : N ; -- fackeltåg..nn.1
  fackförbund_1_N : N ; -- fackförbund..nn.1
  fackförening_1_N : N ; -- fackförening..nn.1
  fackföreningsfientlig_1_A : A ; -- fackföreningsfientlig..av.1
  fackföreningsrörelse_1_N : N ; -- fackföreningsrörelse..nn.1
  fackhögskola_1_N : N ; -- fackhögskola..nn.1
  fackidiot_1_N : N ; -- fackidiot..nn.1
  fackklubb_1_N : N ; -- fackklubb..nn.1
  fackkunnig_1_A : A ; -- fackkunnig..av.1
  fackkunnighet_1_N : N ; -- fackkunnighet..nn.1
  fackkunskap_1_N : N ; -- fackkunskap..nn.1
  fackla_1_N : N ; -- fackla..nn.1
  facklig_politisk_1_A : A ; -- facklig-politisk..av.1
  facklig_1_A : A ; -- facklig..av.1
  facklighet_1_N : N ; -- facklighet..nn.1
  fackligpolitisk_1_A : A ; -- fackligpolitisk..av.1
  fackligt_politisk_1_A : A ; -- fackligt-politisk..av.1
  fackligtpolitisk_1_A : A ; -- fackligtpolitisk..av.1
  facklitteratur_1_N : N ; -- facklitteratur..nn.1
  facklärare_1_N : N ; -- facklärare..nn.1
  fackman_1_N : N ; -- fackman..nn.1
  fackmannamässig_1_A : A ; -- fackmannamässig..av.1
  fackminister_1_N : N ; -- fackminister..nn.1
  fackmässig_1_A : A ; -- fackmässig..av.1
  fackmässighet_1_N : N ; -- fackmässighet..nn.1
  fackordbok_1_N : N ; -- fackordbok..nn.1
  fackorgan_1_N : N ; -- fackorgan..nn.1
  fackpress_1_N : N ; -- fackpress..nn.1
  fackprosa_1_N : N ; -- fackprosa..nn.1
  fackskola_1_N : N ; -- fackskola..nn.1
  fackspråk_1_N : N ; -- fackspråk..nn.1
  fackstudium_1_N : N ; -- fackstudium..nn.1
  fackterm_1_N : N ; -- fackterm..nn.1
  facktidskrift_1_N : N ; -- facktidskrift..nn.1
  fackutskottsprincip_1_N : N ; -- fackutskottsprincip..nn.1
  fackverk_1_N : N ; -- fackverk..nn.1
  fackverksbom_1_N : N ; -- fackverksbom..nn.1
  fackverksmast_1_N : N ; -- fackverksmast..nn.1
  factoring_1_N : N ; -- factoring..nn.1
  fadd_1_A : A ; -- fadd..av.1
  fadder_1_N : N ; -- fadder..nn.1
  fadderbarn_1_N : N ; -- fadderbarn..nn.1
  faddergala_1_N : N ; -- faddergala..nn.1
  faddergåva_1_N : N ; -- faddergåva..nn.1
  fadderskap_1_N : N ; -- fadderskap..nn.1
  faddhet_1_N : N ; -- faddhet..nn.1
  fader_1_N : N ; -- fader..nn.1
  faderlig_1_A : A ; -- faderlig..av.1
  faderlighet_1_N : N ; -- faderlighet..nn.1
  faderlös_1_A : A ; -- faderlös..av.1
  fadermord_1_N : N ; -- fadermord..nn.1
  fadermördare_1_N : N ; -- fadermördare..nn.1
  fadersarv_1_N : N ; -- fadersarv..nn.1
  fadersfigur_1_N : N ; -- fadersfigur..nn.1
  fadersgestalt_1_N : N ; -- fadersgestalt..nn.1
  fadershjärta_1_N : N ; -- fadershjärta..nn.1
  fadershus_1_N : N ; -- fadershus..nn.1
  faderskap_1_N : N ; -- faderskap..nn.1
  faderskomplex_1_N : N ; -- faderskomplex..nn.1
  faderskärlek_1_N : N ; -- faderskärlek..nn.1
  fadersnamn_1_N : N ; -- fadersnamn..nn.1
  fadersuppror_1_N : N ; -- fadersuppror..nn.1
  fadersvälde_1_N : N ; -- fadersvälde..nn.1
  fadervår_1_N : N ; -- fadervår..nn.1
  fading_1_N : N ; -- fading..nn.1
  fadäs_1_N : N ; -- fadäs..nn.1
  faffa_1_N : N ; -- faffa..nn.1
  fager_1_A : A ; -- fager..av.1
  fagott_1_N : N ; -- fagott..nn.1
  fagottist_1_N : N ; -- fagottist..nn.1
  faiblesse_1_N : N ; -- faiblesse..nn.1
  fajans_1_N : N ; -- fajans..nn.1
  fajansfabrik_1_N : N ; -- fajansfabrik..nn.1
  fajansfat_1_N : N ; -- fajansfat..nn.1
  fajanskärl_1_N : N ; -- fajanskärl..nn.1
  fajansskål_1_N : N ; -- fajansskål..nn.1
  fajt_1_N : N ; -- fajt..nn.1
  fajter_1_N : N ; -- fajter..nn.1
  fakir_1_N : N ; -- fakir..nn.1
  faksimil_1_N : N ; -- faksimil..nn.1
  faksimile_1_N : N ; -- faksimile..nn.1
  faksimilera_1_V : V ; -- faksimilera..vb.1
  faksimiletryck_1_N : N ; -- faksimiletryck..nn.1
  faksimiltryck_1_N : N ; -- faksimiltryck..nn.1
  fakta_1_N : N ; -- fakta..nn.1
  faktabaserad_1_A : A ; -- faktabaserad..av.1
  faktafel_1_N : N ; -- faktafel..nn.1
  faktafolder_1_N : N ; -- faktafolder..nn.1
  faktagranskning_1_N : N ; -- faktagranskning..nn.1
  faktagroda_1_N : N ; -- faktagroda..nn.1
  faktakoll_1_N : N ; -- faktakoll..nn.1
  faktamässig_1_A : A ; -- faktamässig..av.1
  faktaspäckad_1_A : A ; -- faktaspäckad..av.1
  fakticitet_1_N : N ; -- fakticitet..nn.1
  faktisk_1_A : A ; -- faktisk..av.1
  faktiskhet_1_N : N ; -- faktiskhet..nn.1
  faktoid_1_N : N ; -- faktoid..nn.1
  faktor_1_N : N ; -- faktor..nn.1
  faktoranalys_1_N : N ; -- faktoranalys..nn.1
  faktori_1_N : N ; -- faktori..nn.1
  faktotum_1_N : N ; -- faktotum..nn.1
  faktum_1_N : N ; -- faktum..nn.1
  faktur_1_N : N ; -- faktur..nn.1
  faktura_1_N : N ; -- faktura..nn.1
  fakturera_1_V : V ; -- fakturera..vb.1
  fakturerande_1_N : N ; -- fakturerande..nn.1
  fakturerbar_1_A : A ; -- fakturerbar..av.1
  fakturerbarhet_1_N : N ; -- fakturerbarhet..nn.1
  fakturering_1_N : N ; -- fakturering..nn.1
  fakultativ_1_A : A ; -- fakultativ..av.1
  fakultet_1_N : N ; -- fakultet..nn.1
  fakultetsgräns_1_N : N ; -- fakultetsgräns..nn.1
  fakultetsopponent_1_N : N ; -- fakultetsopponent..nn.1
  fakultetssammanträde_1_N : N ; -- fakultetssammanträde..nn.1
  fal_1_A : A ; -- fal..av.1
  falafel_1_N : N ; -- falafel..nn.1
  falafelbulle_1_N : N ; -- falafelbulle..nn.1
  falang_1_N : N ; -- falang..nn.1
  falangist_1_N : N ; -- falangist..nn.1
  falangstrid_1_N : N ; -- falangstrid..nn.1
  falerner_1_N : N ; -- falerner..nn.1
  falhet_1_N : N ; -- falhet..nn.1
  falk_1_N : N ; -- falk..nn.1
  falka_1_V : V ; -- falka..vb.1
  falkande_1_N : N ; -- falkande..nn.1
  falkblick_1_N : N ; -- falkblick..nn.1
  falkenerare_1_N : N ; -- falkenerare..nn.1
  falkjakt_1_N : N ; -- falkjakt..nn.1
  falkonett_1_N : N ; -- falkonett..nn.1
  falköga_1_N : N ; -- falköga..nn.1
  fall_1_N : N ; -- fall..nn.1
  falla_1_V : V ; -- falla..vb.1
  fallande_1_N : N ; -- fallande..nn.1
  fallandesjuka_1_N : N ; -- fallandesjuka..nn.1
  fallandesot_1_N : N ; -- fallandesot..nn.1
  fallbeskrivning_1_N : N ; -- fallbeskrivning..nn.1
  fallbila_1_N : N ; -- fallbila..nn.1
  fallen_1_A : A ; -- fallen..av.1
  fallenhet_1_N : N ; -- fallenhet..nn.1
  fallera_1_V : V ; -- fallera..vb.1
  fallerande_1_N : N ; -- fallerande..nn.1
  fallering_1_N : N ; -- fallering..nn.1
  fallfara_1_N : N ; -- fallfara..nn.1
  fallfrukt_1_N : N ; -- fallfrukt..nn.1
  fallfärdig_1_A : A ; -- fallfärdig..av.1
  fallfärdighet_1_N : N ; -- fallfärdighet..nn.1
  fallgrop_1_N : N ; -- fallgrop..nn.1
  fallhammare_1_N : N ; -- fallhammare..nn.1
  fallhöjd_1_N : N ; -- fallhöjd..nn.1
  fallissemang_1_N : N ; -- fallissemang..nn.1
  fallmålstavla_1_N : N ; -- fallmålstavla..nn.1
  fallolycka_1_N : N ; -- fallolycka..nn.1
  fallos_1_N : N ; -- fallos..nn.1
  fallout_1_N : N ; -- fallout..nn.1
  fallrep_1_N : N ; -- fallrep..nn.1
  fallrepstrappa_1_N : N ; -- fallrepstrappa..nn.1
  fallseger_1_N : N ; -- fallseger..nn.1
  fallskada_1_N : N ; -- fallskada..nn.1
  fallskärm_1_N : N ; -- fallskärm..nn.1
  fallskärmsförbund_1_N : N ; -- fallskärmsförbund..nn.1
  fallskärmshopp_1_N : N ; -- fallskärmshopp..nn.1
  fallskärmshoppande_1_N : N ; -- fallskärmshoppande..nn.1
  fallskärmshoppare_1_N : N ; -- fallskärmshoppare..nn.1
  fallskärmshoppning_1_N : N ; -- fallskärmshoppning..nn.1
  fallskärmsjägare_1_N : N ; -- fallskärmsjägare..nn.1
  fallskärmsklubb_1_N : N ; -- fallskärmsklubb..nn.1
  fallskärmsliknande_1_A : A ; -- fallskärmsliknande..av.1
  fallskärmsolycka_1_N : N ; -- fallskärmsolycka..nn.1
  fallskärmstrick_1_N : N ; -- fallskärmstrick..nn.1
  fallskärmstrupp_1_N : N ; -- fallskärmstrupp..nn.1
  fallstudie_1_N : N ; -- fallstudie..nn.1
  falltavla_1_N : N ; -- falltavla..nn.1
  fallucka_1_N : N ; -- fallucka..nn.1
  fallverk_1_N : N ; -- fallverk..nn.1
  fallvind_1_N : N ; -- fallvind..nn.1
  falna_1_V : V ; -- falna..vb.1
  falnande_1_N : N ; -- falnande..nn.1
  fals_1_N : N ; -- fals..nn.1
  falsa_1_V : V ; -- falsa..vb.1
  falsande_1_N : N ; -- falsande..nn.1
  falsarium_1_N : N ; -- falsarium..nn.1
  falsett_1_N : N ; -- falsett..nn.1
  falsettilsken_1_A : A ; -- falsettilsken..av.1
  falsettröst_1_N : N ; -- falsettröst..nn.1
  falsettsång_1_N : N ; -- falsettsång..nn.1
  falsifiera_1_V : V ; -- falsifiera..vb.1
  falsifierande_1_N : N ; -- falsifierande..nn.1
  falsifierbar_1_A : A ; -- falsifierbar..av.1
  falsifierbarhet_1_N : N ; -- falsifierbarhet..nn.1
  falsifiering_1_N : N ; -- falsifiering..nn.1
  falsifikat_1_N : N ; -- falsifikat..nn.1
  falsk_1_A : A ; -- falsk..av.1
  falskalarm_1_N : N ; -- falskalarm..nn.1
  falskeligen_1_Adv : Adv ; -- falskeligen..ab.1
  falskhet_1_N : N ; -- falskhet..nn.1
  falsklarm_1_N : N ; -- falsklarm..nn.1
  falskmynta_1_V : V ; -- falskmynta..vb.1
  falskmyntande_1_N : N ; -- falskmyntande..nn.1
  falskmyntare_1_N : N ; -- falskmyntare..nn.1
  falskmyntning_1_N : N ; -- falskmyntning..nn.1
  falskskylta_1_V : V ; -- falskskylta..vb.1
  falskskyltande_1_N : N ; -- falskskyltande..nn.1
  falskskyltning_1_N : N ; -- falskskyltning..nn.1
  falskspel_1_N : N ; -- falskspel..nn.1
  falskspelare_1_N : N ; -- falskspelare..nn.1
  falubo_1_N : N ; -- falubo..nn.1
  falukorv_1_N : N ; -- falukorv..nn.1
  faluröd_1_A : A ; -- faluröd..av.1
  familj_1_N : N ; -- familj..nn.1
  familjaritet_1_N : N ; -- familjaritet..nn.1
  familjeangelägenhet_1_N : N ; -- familjeangelägenhet..nn.1
  familjearkiv_1_N : N ; -- familjearkiv..nn.1
  familjeband_1_N : N ; -- familjeband..nn.1
  familjebidrag_1_N : N ; -- familjebidrag..nn.1
  familjebild_1_N : N ; -- familjebild..nn.1
  familjebiljett_1_N : N ; -- familjebiljett..nn.1
  familjebolag_1_N : N ; -- familjebolag..nn.1
  familjedaghem_1_N : N ; -- familjedaghem..nn.1
  familjedrag_1_N : N ; -- familjedrag..nn.1
  familjedrama_1_N : N ; -- familjedrama..nn.1
  familjefar_1_N : N ; -- familjefar..nn.1
  familjefejd_1_N : N ; -- familjefejd..nn.1
  familjeflicka_1_N : N ; -- familjeflicka..nn.1
  familjefoto_1_N : N ; -- familjefoto..nn.1
  familjeföretag_1_N : N ; -- familjeföretag..nn.1
  familjeförsörjare_1_N : N ; -- familjeförsörjare..nn.1
  familjegods_1_N : N ; -- familjegods..nn.1
  familjegrav_1_N : N ; -- familjegrav..nn.1
  familjehem_1_N : N ; -- familjehem..nn.1
  familjehemlighet_1_N : N ; -- familjehemlighet..nn.1
  familjehotell_1_N : N ; -- familjehotell..nn.1
  familjeideal_1_N : N ; -- familjeideal..nn.1
  familjejordbruk_1_N : N ; -- familjejordbruk..nn.1
  familjekrets_1_N : N ; -- familjekrets..nn.1
  familjekänsla_1_N : N ; -- familjekänsla..nn.1
  familjeliv_1_N : N ; -- familjeliv..nn.1
  familjemedlem_1_N : N ; -- familjemedlem..nn.1
  familjemiddag_1_N : N ; -- familjemiddag..nn.1
  familjemys_1_N : N ; -- familjemys..nn.1
  familjemässig_1_A : A ; -- familjemässig..av.1
  familjenamn_1_N : N ; -- familjenamn..nn.1
  familjepenning_1_N : N ; -- familjepenning..nn.1
  familjepension_1_N : N ; -- familjepension..nn.1
  familjeplanering_1_N : N ; -- familjeplanering..nn.1
  familjeplaneringsregel_1_N : N ; -- familjeplaneringsregel..nn.1
  familjepolitik_1_N : N ; -- familjepolitik..nn.1
  familjepolitisk_1_A : A ; -- familjepolitisk..av.1
  familjeprogram_1_N : N ; -- familjeprogram..nn.1
  familjerabatt_1_N : N ; -- familjerabatt..nn.1
  familjerätt_1_N : N ; -- familjerätt..nn.1
  familjerättslig_1_A : A ; -- familjerättslig..av.1
  familjerådgivning_1_N : N ; -- familjerådgivning..nn.1
  familjestiftelse_1_N : N ; -- familjestiftelse..nn.1
  familjeterapi_1_N : N ; -- familjeterapi..nn.1
  familjetillhörighet_1_N : N ; -- familjetillhörighet..nn.1
  familjetradition_1_N : N ; -- familjetradition..nn.1
  familjeunderhållning_1_N : N ; -- familjeunderhållning..nn.1
  familjevåld_1_N : N ; -- familjevåld..nn.1
  familjevård_1_N : N ; -- familjevård..nn.1
  familjeöverhuvud_1_N : N ; -- familjeöverhuvud..nn.1
  familjär_1_A : A ; -- familjär..av.1
  famla_1_V : V ; -- famla..vb.1
  famlande_1_A : A ; -- famlande..av.1
  famlande_1_N : N ; -- famlande..nn.1
  fammo_1_N : N ; -- fammo..nn.1
  famn_1_N : N ; -- famn..nn.1
  famna_1_V : V ; -- famna..vb.1
  famnande_1_N : N ; -- famnande..nn.1
  famntag_1_N : N ; -- famntag..nn.1
  famös_1_A : A ; -- famös..av.1
  fan_2_N : N ; -- fan..nn.2
  fan_3_N : N ; -- fan..nn.3
  fana_1_N : N ; -- fana..nn.1
  fanatiker_1_N : N ; -- fanatiker..nn.1
  fanatisk_1_A : A ; -- fanatisk..av.1
  fanatism_1_N : N ; -- fanatism..nn.1
  fanborg_1_N : N ; -- fanborg..nn.1
  fanbärare_1_N : N ; -- fanbärare..nn.1
  fandango_1_N : N ; -- fandango..nn.1
  faned_1_N : N ; -- faned..nn.1
  faner_1_N : N ; -- faner..nn.1
  fanera_1_V : V ; -- fanera..vb.1
  fanerogam_1_A : A ; -- fanerogam..av.1
  fanerogam_1_N : N ; -- fanerogam..nn.1
  fanerozoikum_1_N : N ; -- fanerozoikum..nn.1
  fanfar_1_N : N ; -- fanfar..nn.1
  fanflykt_1_N : N ; -- fanflykt..nn.1
  fanjunkare_1_N : N ; -- fanjunkare..nn.1
  fanken_1_N : N ; -- fanken..nn.1
  fanskap_1_N : N ; -- fanskap..nn.1
  fanstyg_1_N : N ; -- fanstyg..nn.1
  fantasi_1_N : N ; -- fantasi..nn.1
  fantasialster_1_N : N ; -- fantasialster..nn.1
  fantasibild_1_N : N ; -- fantasibild..nn.1
  fantasidjur_1_N : N ; -- fantasidjur..nn.1
  fantasieggande_1_A : A ; -- fantasieggande..av.1
  fantasifigur_1_N : N ; -- fantasifigur..nn.1
  fantasifoster_1_N : N ; -- fantasifoster..nn.1
  fantasifull_1_A : A ; -- fantasifull..av.1
  fantasifullhet_1_N : N ; -- fantasifullhet..nn.1
  fantasigestalt_1_N : N ; -- fantasigestalt..nn.1
  fantasikraft_1_N : N ; -- fantasikraft..nn.1
  fantasiliv_1_N : N ; -- fantasiliv..nn.1
  fantasilös_1_A : A ; -- fantasilös..av.1
  fantasilöshet_1_N : N ; -- fantasilöshet..nn.1
  fantasiprodukt_1_N : N ; -- fantasiprodukt..nn.1
  fantasirik_1_A : A ; -- fantasirik..av.1
  fantasirikedom_1_N : N ; -- fantasirikedom..nn.1
  fantasirikhet_1_N : N ; -- fantasirikhet..nn.1
  fantasiskapelse_1_N : N ; -- fantasiskapelse..nn.1
  fantasispel_1_N : N ; -- fantasispel..nn.1
  fantasivarelse_1_N : N ; -- fantasivarelse..nn.1
  fantasivärld_1_N : N ; -- fantasivärld..nn.1
  fantast_1_N : N ; -- fantast..nn.1
  fantasteri_1_N : N ; -- fantasteri..nn.1
  fantastik_1_N : N ; -- fantastik..nn.1
  fantastisk_1_A : A ; -- fantastisk..av.1
  fantisera_1_V : V ; -- fantisera..vb.1
  fantiserande_1_N : N ; -- fantiserande..nn.1
  fantiserbar_1_A : A ; -- fantiserbar..av.1
  fantiserbarhet_1_N : N ; -- fantiserbarhet..nn.1
  fantisering_1_N : N ; -- fantisering..nn.1
  fantom_1_N : N ; -- fantom..nn.1
  fantom_2_N : N ; -- fantom..nn.2
  fantombild_1_N : N ; -- fantombild..nn.1
  fantomlik_1_A : A ; -- fantomlik..av.1
  fantomsmärta_1_N : N ; -- fantomsmärta..nn.1
  fantomsnygg_1_A : A ; -- fantomsnygg..av.1
  fantomsnygghet_1_N : N ; -- fantomsnygghet..nn.1
  fanvakt_1_N : N ; -- fanvakt..nn.1
  far_1_N : N ; -- far..nn.1
  fara_1_N : N ; -- fara..nn.1
  fara_1_V : V ; -- fara..vb.1
  farad_1_N : N ; -- farad..nn.1
  farande_1_N : N ; -- farande..nn.1
  farao_1_N : N ; -- farao..nn.1
  faraokatt_1_N : N ; -- faraokatt..nn.1
  faraonisk_1_A : A ; -- faraonisk..av.1
  farbar_1_A : A ; -- farbar..av.1
  farbarhet_1_N : N ; -- farbarhet..nn.1
  farbroderlig_1_A : A ; -- farbroderlig..av.1
  farbroderlighet_1_N : N ; -- farbroderlighet..nn.1
  farbror_1_N : N ; -- farbror..nn.1
  fardag_1_N : N ; -- fardag..nn.1
  farfar_1_N : N ; -- farfar..nn.1
  farfarsfar_1_N : N ; -- farfarsfar..nn.1
  farförälder_1_N : N ; -- farförälder..nn.1
  fargalt_1_N : N ; -- fargalt..nn.1
  farhåga_1_N : N ; -- farhåga..nn.1
  farin_1_N : N ; -- farin..nn.1
  farinsocker_1_N : N ; -- farinsocker..nn.1
  fariseisk_1_A : A ; -- fariseisk..av.1
  fariseism_1_N : N ; -- fariseism..nn.1
  farisé_1_N : N ; -- farisé..nn.1
  fariséism_1_N : N ; -- fariséism..nn.1
  farkost_1_N : N ; -- farkost..nn.1
  farled_1_N : N ; -- farled..nn.1
  farledsfyr_1_N : N ; -- farledsfyr..nn.1
  farlig_1_A : A ; -- farlig..av.1
  farlighet_1_N : N ; -- farlighet..nn.1
  farlighetsstämpel_1_N : N ; -- farlighetsstämpel..nn.1
  farm_1_N : N ; -- farm..nn.1
  farmaceut_1_N : N ; -- farmaceut..nn.1
  farmaceutisk_1_A : A ; -- farmaceutisk..av.1
  farmacevt_1_N : N ; -- farmacevt..nn.1
  farmacevtisk_1_A : A ; -- farmacevtisk..av.1
  farmaci_1_N : N ; -- farmaci..nn.1
  farmacie_1_A : A ; -- farmacie..av.1
  farmaka_1_N : N ; -- farmaka..nn.1
  farmakognosi_1_N : N ; -- farmakognosi..nn.1
  farmakolog_1_N : N ; -- farmakolog..nn.1
  farmakologi_1_N : N ; -- farmakologi..nn.1
  farmakologisk_1_A : A ; -- farmakologisk..av.1
  farmakopé_1_N : N ; -- farmakopé..nn.1
  farmardomkraft_1_N : N ; -- farmardomkraft..nn.1
  farmare_1_N : N ; -- farmare..nn.1
  farmor_1_N : N ; -- farmor..nn.1
  farofylld_1_A : A ; -- farofylld..av.1
  farofylldhet_1_N : N ; -- farofylldhet..nn.1
  farozon_1_N : N ; -- farozon..nn.1
  fars_1_N : N ; -- fars..nn.1
  farsa_1_N : N ; -- farsa..nn.1
  farsartad_1_A : A ; -- farsartad..av.1
  farsarv_1_N : N ; -- farsarv..nn.1
  farsgubbe_1_N : N ; -- farsgubbe..nn.1
  farsi_1_N : N ; -- farsi..nn.1
  farsot_1_N : N ; -- farsot..nn.1
  farsotsår_1_N : N ; -- farsotsår..nn.1
  farstu_1_N : N ; -- farstu..nn.1
  farstukvist_1_N : N ; -- farstukvist..nn.1
  farstutrappa_1_N : N ; -- farstutrappa..nn.1
  fart_1_N : N ; -- fart..nn.1
  fartblind_1_A : A ; -- fartblind..av.1
  fartblindhet_1_N : N ; -- fartblindhet..nn.1
  fartdåre_1_N : N ; -- fartdåre..nn.1
  fartfena_1_N : N ; -- fartfena..nn.1
  fartfylld_1_A : A ; -- fartfylld..av.1
  fartfylldhet_1_N : N ; -- fartfylldhet..nn.1
  farthinder_1_N : N ; -- farthinder..nn.1
  farthållare_1_N : N ; -- farthållare..nn.1
  fartkamera_1_N : N ; -- fartkamera..nn.1
  fartminskning_1_N : N ; -- fartminskning..nn.1
  fartrand_1_N : N ; -- fartrand..nn.1
  fartreglage_1_N : N ; -- fartreglage..nn.1
  fartspärr_1_N : N ; -- fartspärr..nn.1
  fartupplevelse_1_N : N ; -- fartupplevelse..nn.1
  fartvind_1_N : N ; -- fartvind..nn.1
  fartyg_1_N : N ; -- fartyg..nn.1
  fartygsanpassad_1_A : A ; -- fartygsanpassad..av.1
  fartygsbesättning_1_N : N ; -- fartygsbesättning..nn.1
  fartygsbotten_1_N : N ; -- fartygsbotten..nn.1
  fartygsbyggartradition_1_N : N ; -- fartygsbyggartradition..nn.1
  fartygsdäck_1_N : N ; -- fartygsdäck..nn.1
  fartygsflagg_1_N : N ; -- fartygsflagg..nn.1
  fartygsincident_1_N : N ; -- fartygsincident..nn.1
  fartygskapten_1_N : N ; -- fartygskapten..nn.1
  fartygskatastrof_1_N : N ; -- fartygskatastrof..nn.1
  fartygskollision_1_N : N ; -- fartygskollision..nn.1
  fartygskonvoj_1_N : N ; -- fartygskonvoj..nn.1
  fartygskurs_1_N : N ; -- fartygskurs..nn.1
  fartygslast_1_N : N ; -- fartygslast..nn.1
  fartygslucka_1_N : N ; -- fartygslucka..nn.1
  fartygsorkester_1_N : N ; -- fartygsorkester..nn.1
  fartygsproviant_1_N : N ; -- fartygsproviant..nn.1
  fartygssida_1_N : N ; -- fartygssida..nn.1
  fartygsskrov_1_N : N ; -- fartygsskrov..nn.1
  fartygsstormning_1_N : N ; -- fartygsstormning..nn.1
  fartygstjänstgöring_1_N : N ; -- fartygstjänstgöring..nn.1
  fartygstrafik_1_N : N ; -- fartygstrafik..nn.1
  fartygstyp_1_N : N ; -- fartygstyp..nn.1
  fartygsvrak_1_N : N ; -- fartygsvrak..nn.1
  farvatten_1_N : N ; -- farvatten..nn.1
  farväl_1_N : N ; -- farväl..nn.1
  faryngal_1_A : A ; -- faryngal..av.1
  fas_1_N : N ; -- fas..nn.1
  fasa_1_N : N ; -- fasa..nn.1
  fasa_1_V : V ; -- fasa..vb.1
  fasa_2_V : V ; -- fasa..vb.2
  fasad_1_N : N ; -- fasad..nn.1
  fasadpensel_1_N : N ; -- fasadpensel..nn.1
  fasadplatta_1_N : N ; -- fasadplatta..nn.1
  fasadtegel_1_N : N ; -- fasadtegel..nn.1
  fasan_1_N : N ; -- fasan..nn.1
  fasande_1_N : N ; -- fasande..nn.1
  fasansfull_1_A : A ; -- fasansfull..av.1
  fasansfullhet_1_N : N ; -- fasansfullhet..nn.1
  fasaväckande_1_A : A ; -- fasaväckande..av.1
  fascination_1_N : N ; -- fascination..nn.1
  fascinera_1_V : V ; -- fascinera..vb.1
  fascinerad_1_A : A ; -- fascinerad..av.1
  fascinerande_1_N : N ; -- fascinerande..nn.1
  fascinerbar_1_A : A ; -- fascinerbar..av.1
  fascinerbarhet_1_N : N ; -- fascinerbarhet..nn.1
  fascinering_1_N : N ; -- fascinering..nn.1
  fascism_1_N : N ; -- fascism..nn.1
  fascist_1_N : N ; -- fascist..nn.1
  fascistisk_1_A : A ; -- fascistisk..av.1
  fascistoid_1_A : A ; -- fascistoid..av.1
  fasen_1_N : N ; -- fasen..nn.1
  fasett_1_N : N ; -- fasett..nn.1
  fasettera_1_V : V ; -- fasettera..vb.1
  fasetterad_1_A : A ; -- fasetterad..av.1
  fasetterande_1_N : N ; -- fasetterande..nn.1
  fasetterbar_1_A : A ; -- fasetterbar..av.1
  fasetterbarhet_1_N : N ; -- fasetterbarhet..nn.1
  fasettering_1_N : N ; -- fasettering..nn.1
  fasettöga_1_N : N ; -- fasettöga..nn.1
  fasförskjutning_1_N : N ; -- fasförskjutning..nn.1
  fashionabel_1_A : A ; -- fashionabel..av.1
  fasingen_1_N : N ; -- fasingen..nn.1
  faskikel_1_N : N ; -- faskikel..nn.1
  faskin_1_N : N ; -- faskin..nn.1
  faskinkniv_1_N : N ; -- faskinkniv..nn.1
  faslig_1_A : A ; -- faslig..av.1
  faslighet_1_N : N ; -- faslighet..nn.1
  fason_1_N : N ; -- fason..nn.1
  fasonera_1_V : V ; -- fasonera..vb.1
  fasonerande_1_N : N ; -- fasonerande..nn.1
  fasonerbar_1_A : A ; -- fasonerbar..av.1
  fasonerbarhet_1_N : N ; -- fasonerbarhet..nn.1
  fasonering_1_N : N ; -- fasonering..nn.1
  fasonlig_1_A : A ; -- fasonlig..av.1
  fasspänning_1_N : N ; -- fasspänning..nn.1
  fast_1_A : A ; -- fast..av.1
  fasta_1_N : N ; -- fasta..nn.1
  fasta_1_V : V ; -- fasta..vb.1
  fastage_1_N : N ; -- fastage..nn.1
  fastande_1_N : N ; -- fastande..nn.1
  fastanställd_1_A : A ; -- fastanställd..av.1
  fastbindning_1_N : N ; -- fastbindning..nn.1
  fastboende_1_A : A ; -- fastboende..av.1
  fastebrev_1_N : N ; -- fastebrev..nn.1
  fastedag_1_N : N ; -- fastedag..nn.1
  fastemånad_1_N : N ; -- fastemånad..nn.1
  faster_1_N : N ; -- faster..nn.1
  fastetid_1_N : N ; -- fastetid..nn.1
  fastfrusen_1_A : A ; -- fastfrusen..av.1
  fastfrysning_1_N : N ; -- fastfrysning..nn.1
  fastgöra_1_V : V ; -- fastgöra..vb.1
  fastgörande_1_N : N ; -- fastgörande..nn.1
  fasthakning_1_N : N ; -- fasthakning..nn.1
  fasthet_1_N : N ; -- fasthet..nn.1
  fasthängande_1_A : A ; -- fasthängande..av.1
  fasthålla_1_V : V ; -- fasthålla..vb.1
  fasthållande_1_N : N ; -- fasthållande..nn.1
  fasthållning_1_N : N ; -- fasthållning..nn.1
  fastighet_1_N : N ; -- fastighet..nn.1
  fastighetsaffär_1_N : N ; -- fastighetsaffär..nn.1
  fastighetsbolag_1_N : N ; -- fastighetsbolag..nn.1
  fastighetsbransch_1_N : N ; -- fastighetsbransch..nn.1
  fastighetsbubbla_1_N : N ; -- fastighetsbubbla..nn.1
  fastighetsbyrå_1_N : N ; -- fastighetsbyrå..nn.1
  fastighetsförsäljning_1_N : N ; -- fastighetsförsäljning..nn.1
  fastighetsindex_1_N : N ; -- fastighetsindex..nn.1
  fastighetskontor_1_N : N ; -- fastighetskontor..nn.1
  fastighetskris_1_N : N ; -- fastighetskris..nn.1
  fastighetsköp_1_N : N ; -- fastighetsköp..nn.1
  fastighetslån_1_N : N ; -- fastighetslån..nn.1
  fastighetsmogul_1_N : N ; -- fastighetsmogul..nn.1
  fastighetsmäklare_1_N : N ; -- fastighetsmäklare..nn.1
  fastighetsnämnd_1_N : N ; -- fastighetsnämnd..nn.1
  fastighetspris_1_N : N ; -- fastighetspris..nn.1
  fastighetsskatt_1_N : N ; -- fastighetsskatt..nn.1
  fastighetsskötare_1_N : N ; -- fastighetsskötare..nn.1
  fastighetsspekulation_1_N : N ; -- fastighetsspekulation..nn.1
  fastighetstaxera_1_V : V ; -- fastighetstaxera..vb.1
  fastighetstaxerande_1_N : N ; -- fastighetstaxerande..nn.1
  fastighetstaxerbar_1_A : A ; -- fastighetstaxerbar..av.1
  fastighetstaxerbarhet_1_N : N ; -- fastighetstaxerbarhet..nn.1
  fastighetstaxering_1_N : N ; -- fastighetstaxering..nn.1
  fastighetsägare_1_N : N ; -- fastighetsägare..nn.1
  fastkedja_1_N : N ; -- fastkedja..nn.1
  fastkedja_1_V : V ; -- fastkedja..vb.1
  fastkedjande_1_N : N ; -- fastkedjande..nn.1
  fastklistra_1_V : V ; -- fastklistra..vb.1
  fastklistrande_1_N : N ; -- fastklistrande..nn.1
  fastklämning_1_N : N ; -- fastklämning..nn.1
  fastkoppling_1_N : N ; -- fastkoppling..nn.1
  fastlag_1_N : N ; -- fastlag..nn.1
  fastlagsbulla_1_N : N ; -- fastlagsbulla..nn.1
  fastlagsbulle_1_N : N ; -- fastlagsbulle..nn.1
  fastlagsris_1_N : N ; -- fastlagsris..nn.1
  fastlagssöndag_1_N : N ; -- fastlagssöndag..nn.1
  fastlagsvecka_1_N : N ; -- fastlagsvecka..nn.1
  fastland_1_N : N ; -- fastland..nn.1
  fastlandsbo_1_N : N ; -- fastlandsbo..nn.1
  fastlandsklimat_1_N : N ; -- fastlandsklimat..nn.1
  fastlimning_1_N : N ; -- fastlimning..nn.1
  fastlägga_1_V : V ; -- fastlägga..vb.1
  fastläggande_1_N : N ; -- fastläggande..nn.1
  fastlänning_1_N : N ; -- fastlänning..nn.1
  fastlåst_1_A : A ; -- fastlåst..av.1
  fastlödning_1_N : N ; -- fastlödning..nn.1
  fastna_1_V : V ; -- fastna..vb.1
  fastnaglad_1_A : A ; -- fastnaglad..av.1
  fastnagling_1_N : N ; -- fastnagling..nn.1
  fastnande_1_N : N ; -- fastnande..nn.1
  fastnitning_1_N : N ; -- fastnitning..nn.1
  fastskruvad_1_A : A ; -- fastskruvad..av.1
  fastskruvning_1_N : N ; -- fastskruvning..nn.1
  fastslagning_1_N : N ; -- fastslagning..nn.1
  fastslå_1_V : V ; -- fastslå..vb.1
  fastslående_1_N : N ; -- fastslående..nn.1
  fastspikad_1_A : A ; -- fastspikad..av.1
  fastspikning_1_N : N ; -- fastspikning..nn.1
  fastspänning_1_N : N ; -- fastspänning..nn.1
  fastställa_1_V : V ; -- fastställa..vb.1
  fastställande_1_N : N ; -- fastställande..nn.1
  fastställelse_1_N : N ; -- fastställelse..nn.1
  fastsurrad_1_A : A ; -- fastsurrad..av.1
  fastsurrning_1_N : N ; -- fastsurrning..nn.1
  fastsätta_1_V : V ; -- fastsätta..vb.1
  fastsättande_1_N : N ; -- fastsättande..nn.1
  fastsättning_1_N : N ; -- fastsättning..nn.1
  fastta_1_V : V ; -- fastta..vb.1
  fasttagande_1_N : N ; -- fasttagande..nn.1
  fasttagning_1_N : N ; -- fasttagning..nn.1
  fasttejpad_1_A : A ; -- fasttejpad..av.1
  fasttråckling_1_N : N ; -- fasttråckling..nn.1
  fastväxning_1_N : N ; -- fastväxning..nn.1
  fat_1_N : N ; -- fat..nn.1
  fatabur_1_N : N ; -- fatabur..nn.1
  fatal_1_A : A ; -- fatal..av.1
  fataliedag_1_N : N ; -- fataliedag..nn.1
  fatalietid_1_N : N ; -- fatalietid..nn.1
  fatalism_1_N : N ; -- fatalism..nn.1
  fatalist_1_N : N ; -- fatalist..nn.1
  fatalistisk_1_A : A ; -- fatalistisk..av.1
  fatalitet_1_N : N ; -- fatalitet..nn.1
  fatbur_1_N : N ; -- fatbur..nn.1
  fatt_1_A : A ; -- fatt..av.1
  fatta_1_V : V ; -- fatta..vb.1
  fatta_2_V : V ; -- fatta..vb.2
  fattad_1_A : A ; -- fattad..av.1
  fattande_1_N : N ; -- fattande..nn.1
  fattbar_1_A : A ; -- fattbar..av.1
  fattbarhet_1_N : N ; -- fattbarhet..nn.1
  fattig_1_A : A ; -- fattig..av.1
  fattigbarn_1_N : N ; -- fattigbarn..nn.1
  fattigdom_1_N : N ; -- fattigdom..nn.1
  fattigdom_2_N : N ; -- fattigdom..nn.2
  fattigdomsbevis_1_N : N ; -- fattigdomsbevis..nn.1
  fattigdomsfälla_1_N : N ; -- fattigdomsfälla..nn.1
  fattigdomslöfte_1_N : N ; -- fattigdomslöfte..nn.1
  fattigdomsminskning_1_N : N ; -- fattigdomsminskning..nn.1
  fattigdomsstreck_1_N : N ; -- fattigdomsstreck..nn.1
  fattighjon_1_N : N ; -- fattighjon..nn.1
  fattighjälp_1_N : N ; -- fattighjälp..nn.1
  fattighus_1_N : N ; -- fattighus..nn.1
  fattigkvarter_1_N : N ; -- fattigkvarter..nn.1
  fattiglapp_1_N : N ; -- fattiglapp..nn.1
  fattigstuga_1_N : N ; -- fattigstuga..nn.1
  fattigunderstöd_1_N : N ; -- fattigunderstöd..nn.1
  fattigvård_1_N : N ; -- fattigvård..nn.1
  fattlig_1_A : A ; -- fattlig..av.1
  fattlighet_1_N : N ; -- fattlighet..nn.1
  fattning_1_N : N ; -- fattning..nn.1
  fattningsförmåga_1_N : N ; -- fattningsförmåga..nn.1
  fattningsgåva_1_N : N ; -- fattningsgåva..nn.1
  fatwa_1_N : N ; -- fatwa..nn.1
  fatöl_1_N : N ; -- fatöl..nn.1
  faun_1_N : N ; -- faun..nn.1
  fauna_1_N : N ; -- fauna..nn.1
  faunist_1_N : N ; -- faunist..nn.1
  faunistik_1_N : N ; -- faunistik..nn.1
  faunistisk_1_A : A ; -- faunistisk..av.1
  faute_1_N : N ; -- faute..nn.1
  favo_1_N : N ; -- favo..nn.1
  favorisera_1_V : V ; -- favorisera..vb.1
  favoriserande_1_N : N ; -- favoriserande..nn.1
  favoriserbar_1_A : A ; -- favoriserbar..av.1
  favoriserbarhet_1_N : N ; -- favoriserbarhet..nn.1
  favorisering_1_N : N ; -- favorisering..nn.1
  favorit_1_N : N ; -- favorit..nn.1
  favoritaccessoar_1_N : N ; -- favoritaccessoar..nn.1
  favoritbild_1_N : N ; -- favoritbild..nn.1
  favoritfik_1_N : N ; -- favoritfik..nn.1
  favoritförfattare_1_N : N ; -- favoritförfattare..nn.1
  favorithak_1_N : N ; -- favorithak..nn.1
  favoritknep_1_N : N ; -- favoritknep..nn.1
  favoritmelodi_1_N : N ; -- favoritmelodi..nn.1
  favoritnöje_1_N : N ; -- favoritnöje..nn.1
  favoritplats_1_N : N ; -- favoritplats..nn.1
  favoritpsalm_1_N : N ; -- favoritpsalm..nn.1
  favoritrestaurang_1_N : N ; -- favoritrestaurang..nn.1
  favoriträtt_1_N : N ; -- favoriträtt..nn.1
  favoritskådespelerska_1_N : N ; -- favoritskådespelerska..nn.1
  favoritstrand_1_N : N ; -- favoritstrand..nn.1
  favoritsystem_1_N : N ; -- favoritsystem..nn.1
  favorittippad_1_A : A ; -- favorittippad..av.1
  favvo_1_N : N ; -- favvo..nn.1
  favör_1_N : N ; -- favör..nn.1
  fax_1_N : N ; -- fax..nn.1
  fax_2_N : N ; -- fax..nn.2
  faxa_1_V : V ; -- faxa..vb.1
  faxande_1_N : N ; -- faxande..nn.1
  fe_1_N : N ; -- fe..nn.1
  featureprogram_1_N : N ; -- featureprogram..nn.1
  feber_1_N : N ; -- feber..nn.1
  feberaktig_1_A : A ; -- feberaktig..av.1
  feberaktighet_1_N : N ; -- feberaktighet..nn.1
  feberanfall_1_N : N ; -- feberanfall..nn.1
  feberdröm_1_N : N ; -- feberdröm..nn.1
  feberdämpande_1_A : A ; -- feberdämpande..av.1
  feberepidemi_1_N : N ; -- feberepidemi..nn.1
  feberfantasi_1_N : N ; -- feberfantasi..nn.1
  feberfri_1_A : A ; -- feberfri..av.1
  feberhet_1_A : A ; -- feberhet..av.1
  feberhetta_1_N : N ; -- feberhetta..nn.1
  feberkurva_1_N : N ; -- feberkurva..nn.1
  febernedsättande_1_A : A ; -- febernedsättande..av.1
  febersjuk_1_A : A ; -- febersjuk..av.1
  febersjukdom_1_N : N ; -- febersjukdom..nn.1
  feberstillande_1_A : A ; -- feberstillande..av.1
  febertermometer_1_N : N ; -- febertermometer..nn.1
  febertopp_1_N : N ; -- febertopp..nn.1
  feberyra_1_N : N ; -- feberyra..nn.1
  febrig_1_A : A ; -- febrig..av.1
  febrighet_1_N : N ; -- febrighet..nn.1
  febril_1_A : A ; -- febril..av.1
  februari_1_N : N ; -- februari..nn.1
  februarilov_1_N : N ; -- februarilov..nn.1
  februarioffensiv_1_N : N ; -- februarioffensiv..nn.1
  februarisol_1_N : N ; -- februarisol..nn.1
  federal_1_A : A ; -- federal..av.1
  federalism_1_N : N ; -- federalism..nn.1
  federalist_1_N : N ; -- federalist..nn.1
  federalistisk_1_A : A ; -- federalistisk..av.1
  federation_1_N : N ; -- federation..nn.1
  federativ_1_A : A ; -- federativ..av.1
  federerad_1_A : A ; -- federerad..av.1
  fedrottning_1_N : N ; -- fedrottning..nn.1
  feedback_1_N : N ; -- feedback..nn.1
  feeri_1_N : N ; -- feeri..nn.1
  feg_1_A : A ; -- feg..av.1
  fega_1_V : V ; -- fega..vb.1
  feghet_1_N : N ; -- feghet..nn.1
  fegis_1_N : N ; -- fegis..nn.1
  fegspel_1_N : N ; -- fegspel..nn.1
  feja_1_V : V ; -- feja..vb.1
  fejande_1_N : N ; -- fejande..nn.1
  fejd_1_N : N ; -- fejd..nn.1
  fejda_1_V : V ; -- fejda..vb.1
  fejda_2_V : V ; -- fejda..vb.2
  fejka_1_V : V ; -- fejka..vb.1
  fejkande_1_N : N ; -- fejkande..nn.1
  fejning_1_N : N ; -- fejning..nn.1
  fekal_1_A : A ; -- fekal..av.1
  fel_1_A : A ; -- fel..av.1
  fel_1_N : N ; -- fel..nn.1
  fel_2_N : N ; -- fel..nn.2
  fela_1_N : N ; -- fela..nn.1
  fela_1_V : V ; -- fela..vb.1
  felaktig_1_A : A ; -- felaktig..av.1
  felaktighet_1_N : N ; -- felaktighet..nn.1
  felande_1_N : N ; -- felande..nn.1
  felbedöma_1_V : V ; -- felbedöma..vb.1
  felbedömande_1_N : N ; -- felbedömande..nn.1
  felbedömning_1_N : N ; -- felbedömning..nn.1
  felbehandlad_1_A : A ; -- felbehandlad..av.1
  felbehandling_1_N : N ; -- felbehandling..nn.1
  felberäkning_1_N : N ; -- felberäkning..nn.1
  felbeskuren_1_A : A ; -- felbeskuren..av.1
  felciterad_1_A : A ; -- felciterad..av.1
  feldaterad_1_A : A ; -- feldaterad..av.1
  feldatering_1_N : N ; -- feldatering..nn.1
  feldiagnos_1_N : N ; -- feldiagnos..nn.1
  feldosera_1_V : V ; -- feldosera..vb.1
  feldoserande_1_N : N ; -- feldoserande..nn.1
  feldosering_1_N : N ; -- feldosering..nn.1
  feldrag_1_N : N ; -- feldrag..nn.1
  felfinnare_1_N : N ; -- felfinnare..nn.1
  felfinneri_1_N : N ; -- felfinneri..nn.1
  felfri_1_A : A ; -- felfri..av.1
  felfrihet_1_N : N ; -- felfrihet..nn.1
  felgrepp_1_N : N ; -- felgrepp..nn.1
  felhandling_1_N : N ; -- felhandling..nn.1
  felinformerad_1_A : A ; -- felinformerad..av.1
  felinvestering_1_N : N ; -- felinvestering..nn.1
  felkokt_1_A : A ; -- felkokt..av.1
  felkonstruerad_1_A : A ; -- felkonstruerad..av.1
  felkälla_1_N : N ; -- felkälla..nn.1
  felköp_1_N : N ; -- felköp..nn.1
  felläsning_1_N : N ; -- felläsning..nn.1
  felmarginal_1_N : N ; -- felmarginal..nn.1
  felnavigera_1_V : V ; -- felnavigera..vb.1
  felnavigerande_1_N : N ; -- felnavigerande..nn.1
  felnavigering_1_N : N ; -- felnavigering..nn.1
  felparkera_1_V : V ; -- felparkera..vb.1
  felparkerande_1_N : N ; -- felparkerande..nn.1
  felparkerbar_1_A : A ; -- felparkerbar..av.1
  felparkerbarhet_1_N : N ; -- felparkerbarhet..nn.1
  felparkering_1_N : N ; -- felparkering..nn.1
  felplacerad_1_A : A ; -- felplacerad..av.1
  felprioritera_1_V : V ; -- felprioritera..vb.1
  felprioriterande_1_N : N ; -- felprioriterande..nn.1
  felprioritering_1_N : N ; -- felprioritering..nn.1
  felprocent_1_N : N ; -- felprocent..nn.1
  felriktad_1_A : A ; -- felriktad..av.1
  felräkning_1_N : N ; -- felräkning..nn.1
  felräkningspeng_1_N : N ; -- felräkningspeng..nn.1
  felsatsning_1_N : N ; -- felsatsning..nn.1
  felskriven_1_A : A ; -- felskriven..av.1
  felskrivning_1_N : N ; -- felskrivning..nn.1
  felslagen_1_A : A ; -- felslagen..av.1
  felslut_1_N : N ; -- felslut..nn.1
  felslående_1_N : N ; -- felslående..nn.1
  felstavad_1_A : A ; -- felstavad..av.1
  felsteg_1_N : N ; -- felsteg..nn.1
  felställd_1_A : A ; -- felställd..av.1
  felsyn_1_N : N ; -- felsyn..nn.1
  felsägning_1_N : N ; -- felsägning..nn.1
  felsökare_1_N : N ; -- felsökare..nn.1
  feltolka_1_V : V ; -- feltolka..vb.1
  feltolkande_1_N : N ; -- feltolkande..nn.1
  feltolkning_1_N : N ; -- feltolkning..nn.1
  feltryck_1_N : N ; -- feltryck..nn.1
  feltryckt_1_A : A ; -- feltryckt..av.1
  feltänk_1_N : N ; -- feltänk..nn.1
  felunderrättad_1_A : A ; -- felunderrättad..av.1
  felutveckling_1_N : N ; -- felutveckling..nn.1
  felval_1_N : N ; -- felval..nn.1
  femaktare_1_N : N ; -- femaktare..nn.1
  femarmad_1_A : A ; -- femarmad..av.1
  fembarnsmamma_1_N : N ; -- fembarnsmamma..nn.1
  femcylindrig_1_A : A ; -- femcylindrig..av.1
  femdagarsvecka_1_N : N ; -- femdagarsvecka..nn.1
  femdelning_1_N : N ; -- femdelning..nn.1
  femdubbel_1_A : A ; -- femdubbel..av.1
  femdubbla_1_V : V ; -- femdubbla..vb.1
  femdubblande_1_N : N ; -- femdubblande..nn.1
  femdubbling_1_N : N ; -- femdubbling..nn.1
  femdygnsprognos_1_N : N ; -- femdygnsprognos..nn.1
  femetta_1_N : N ; -- femetta..nn.1
  femfaldig_1_A : A ; -- femfaldig..av.1
  femfaldiga_1_V : V ; -- femfaldiga..vb.1
  femfaldigande_1_N : N ; -- femfaldigande..nn.1
  femfemma_1_N : N ; -- femfemma..nn.1
  femfilmskontrakt_1_N : N ; -- femfilmskontrakt..nn.1
  femflikig_1_A : A ; -- femflikig..av.1
  femgradig_1_A : A ; -- femgradig..av.1
  femhundrade_1_A : A ; -- femhundrade..av.1
  femhundrakronorssedel_1_N : N ; -- femhundrakronorssedel..nn.1
  femhörnig_1_A : A ; -- femhörnig..av.1
  femhörning_1_N : N ; -- femhörning..nn.1
  feminin_1_A : A ; -- feminin..av.1
  feminin_2_A : A ; -- feminin..av.2
  femininbildning_1_N : N ; -- femininbildning..nn.1
  femininform_1_N : N ; -- femininform..nn.1
  femininum_1_N : N ; -- femininum..nn.1
  femininändelse_1_N : N ; -- femininändelse..nn.1
  feminiserad_1_A : A ; -- feminiserad..av.1
  feminism_1_N : N ; -- feminism..nn.1
  feminist_1_N : N ; -- feminist..nn.1
  feministisk_1_A : A ; -- feministisk..av.1
  feministtjafs_1_N : N ; -- feministtjafs..nn.1
  femkamp_1_N : N ; -- femkamp..nn.1
  femkort_1_N : N ; -- femkort..nn.1
  femkrona_1_N : N ; -- femkrona..nn.1
  femkronorsmynt_1_N : N ; -- femkronorsmynt..nn.1
  femling_1_N : N ; -- femling..nn.1
  femma_1_N : N ; -- femma..nn.1
  femmarkerkorv_1_N : N ; -- femmarkerkorv..nn.1
  femmil_1_N : N ; -- femmil..nn.1
  femprocentig_1_A : A ; -- femprocentig..av.1
  fempunktslaser_1_N : N ; -- fempunktslaser..nn.1
  fempunktsplan_1_N : N ; -- fempunktsplan..nn.1
  femrummare_1_N : N ; -- femrummare..nn.1
  femrumslägenhet_1_N : N ; -- femrumslägenhet..nn.1
  femsidig_1_A : A ; -- femsidig..av.1
  femsiffrig_1_A : A ; -- femsiffrig..av.1
  femsitsig_1_A : A ; -- femsitsig..av.1
  femstjärnig_1_A : A ; -- femstjärnig..av.1
  femstämmig_1_A : A ; -- femstämmig..av.1
  femtal_1_N : N ; -- femtal..nn.1
  femte_1_A : A ; -- femte..av.1
  femtedel_1_N : N ; -- femtedel..nn.1
  femtekolonn_1_N : N ; -- femtekolonn..nn.1
  femtekolonnare_1_N : N ; -- femtekolonnare..nn.1
  femteplats_1_N : N ; -- femteplats..nn.1
  femtidollarsedel_1_N : N ; -- femtidollarsedel..nn.1
  femtielfte_1_A : A ; -- femtielfte..av.1
  femtikronorssedel_1_N : N ; -- femtikronorssedel..nn.1
  femtilapp_1_N : N ; -- femtilapp..nn.1
  femtiliters_1_A : A ; -- femtiliters..av.1
  femtiodollarsedel_1_N : N ; -- femtiodollarsedel..nn.1
  femtioelfte_1_A : A ; -- femtioelfte..av.1
  femtiokronorssedel_1_N : N ; -- femtiokronorssedel..nn.1
  femtiometerssträcka_1_N : N ; -- femtiometerssträcka..nn.1
  femtionde_1_A : A ; -- femtionde..av.1
  femtiotal_1_N : N ; -- femtiotal..nn.1
  femtiotalist_1_N : N ; -- femtiotalist..nn.1
  femtiotalsinspirerad_1_A : A ; -- femtiotalsinspirerad..av.1
  femtioårig_1_A : A ; -- femtioårig..av.1
  femtioårsdag_1_N : N ; -- femtioårsdag..nn.1
  femtioårsjubileum_1_N : N ; -- femtioårsjubileum..nn.1
  femtioöring_1_N : N ; -- femtioöring..nn.1
  femtital_1_N : N ; -- femtital..nn.1
  femtitalist_1_N : N ; -- femtitalist..nn.1
  femtiårsdag_1_N : N ; -- femtiårsdag..nn.1
  femtiöring_1_N : N ; -- femtiöring..nn.1
  femtocell_1_N : N ; -- femtocell..nn.1
  femtonbarnsmamma_1_N : N ; -- femtonbarnsmamma..nn.1
  femtonde_1_A : A ; -- femtonde..av.1
  femtondedel_1_N : N ; -- femtondedel..nn.1
  femtondel_1_N : N ; -- femtondel..nn.1
  femtonhundrameterslopp_1_N : N ; -- femtonhundrameterslopp..nn.1
  femtonhundratal_1_N : N ; -- femtonhundratal..nn.1
  femtontal_1_N : N ; -- femtontal..nn.1
  femtonårig_1_A : A ; -- femtonårig..av.1
  femtonåring_1_N : N ; -- femtonåring..nn.1
  femtonårsstraff_1_N : N ; -- femtonårsstraff..nn.1
  femtumsspik_1_N : N ; -- femtumsspik..nn.1
  femuddig_1_A : A ; -- femuddig..av.1
  femväxlad_1_A : A ; -- femväxlad..av.1
  femårig_1_A : A ; -- femårig..av.1
  femåring_1_N : N ; -- femåring..nn.1
  femårsperiod_1_N : N ; -- femårsperiod..nn.1
  femårsplan_1_N : N ; -- femårsplan..nn.1
  femöring_1_N : N ; -- femöring..nn.1
  fena_1_A : A ; -- fena..av.1
  fena_1_N : N ; -- fena..nn.1
  fender_1_N : N ; -- fender..nn.1
  fendert_1_N : N ; -- fendert..nn.1
  fenedrin_1_N : N ; -- fenedrin..nn.1
  fenicier_1_N : N ; -- fenicier..nn.1
  fenicisk_1_A : A ; -- fenicisk..av.1
  fenixbål_1_N : N ; -- fenixbål..nn.1
  fenköl_1_N : N ; -- fenköl..nn.1
  fenmetralin_1_N : N ; -- fenmetralin..nn.1
  fennicism_1_N : N ; -- fennicism..nn.1
  fennoman_1_N : N ; -- fennoman..nn.1
  fennomani_1_N : N ; -- fennomani..nn.1
  fenol_1_N : N ; -- fenol..nn.1
  fenolftalein_1_N : N ; -- fenolftalein..nn.1
  fenolisk_1_A : A ; -- fenolisk..av.1
  fenomen_1_N : N ; -- fenomen..nn.1
  fenomenal_1_A : A ; -- fenomenal..av.1
  fenomenalism_1_N : N ; -- fenomenalism..nn.1
  fenomenologi_1_N : N ; -- fenomenologi..nn.1
  fenomenologisk_1_A : A ; -- fenomenologisk..av.1
  fenomenvärld_1_N : N ; -- fenomenvärld..nn.1
  fenoplast_1_N : N ; -- fenoplast..nn.1
  fenotyp_1_N : N ; -- fenotyp..nn.1
  fenoxisyra_1_N : N ; -- fenoxisyra..nn.1
  fenval_1_N : N ; -- fenval..nn.1
  feodal_1_A : A ; -- feodal..av.1
  feodalherre_1_N : N ; -- feodalherre..nn.1
  feodalism_1_N : N ; -- feodalism..nn.1
  feodalistisk_1_A : A ; -- feodalistisk..av.1
  feodalväsen_1_N : N ; -- feodalväsen..nn.1
  ferie_1_N : N ; -- ferie..nn.1
  ferieskola_1_N : N ; -- ferieskola..nn.1
  ferietid_1_N : N ; -- ferietid..nn.1
  ferm_1_A : A ; -- ferm..av.1
  fermat_1_N : N ; -- fermat..nn.1
  ferment_1_N : N ; -- ferment..nn.1
  fermentera_1_V : V ; -- fermentera..vb.1
  fermenterande_1_N : N ; -- fermenterande..nn.1
  fermenterbar_1_A : A ; -- fermenterbar..av.1
  fermenterbarhet_1_N : N ; -- fermenterbarhet..nn.1
  fermentering_1_N : N ; -- fermentering..nn.1
  fermhet_1_N : N ; -- fermhet..nn.1
  fermitet_1_N : N ; -- fermitet..nn.1
  fermium_1_N : N ; -- fermium..nn.1
  fernissa_1_N : N ; -- fernissa..nn.1
  fernissa_1_V : V ; -- fernissa..vb.1
  fernissande_1_N : N ; -- fernissande..nn.1
  feromon_1_N : N ; -- feromon..nn.1
  ferrit_1_N : N ; -- ferrit..nn.1
  ferritkärna_1_N : N ; -- ferritkärna..nn.1
  ferrolegering_1_N : N ; -- ferrolegering..nn.1
  ferrum_1_N : N ; -- ferrum..nn.1
  fertil_1_A : A ; -- fertil..av.1
  fertilitet_1_N : N ; -- fertilitet..nn.1
  fest_1_N : N ; -- fest..nn.1
  festa_1_V : V ; -- festa..vb.1
  festande_1_N : N ; -- festande..nn.1
  festarrangör_1_N : N ; -- festarrangör..nn.1
  festbord_1_N : N ; -- festbord..nn.1
  festdag_1_N : N ; -- festdag..nn.1
  festdeltagare_1_N : N ; -- festdeltagare..nn.1
  festdräkt_1_N : N ; -- festdräkt..nn.1
  festfixare_1_N : N ; -- festfixare..nn.1
  festföremål_1_N : N ; -- festföremål..nn.1
  festgeneral_1_N : N ; -- festgeneral..nn.1
  festglädje_1_N : N ; -- festglädje..nn.1
  festival_1_N : N ; -- festival..nn.1
  festivalbiljett_1_N : N ; -- festivalbiljett..nn.1
  festivaljury_1_N : N ; -- festivaljury..nn.1
  festivalluff_1_N : N ; -- festivalluff..nn.1
  festivaltält_1_N : N ; -- festivaltält..nn.1
  festivitas_1_N : N ; -- festivitas..nn.1
  festivitet_1_N : N ; -- festivitet..nn.1
  festkamrat_1_N : N ; -- festkamrat..nn.1
  festklädd_1_A : A ; -- festklädd..av.1
  festklänning_1_N : N ; -- festklänning..nn.1
  festkompis_1_N : N ; -- festkompis..nn.1
  festkväll_1_N : N ; -- festkväll..nn.1
  festlig_1_A : A ; -- festlig..av.1
  festlighet_1_N : N ; -- festlighet..nn.1
  festlighet_2_N : N ; -- festlighet..nn.2
  festlokal_1_N : N ; -- festlokal..nn.1
  festmiddag_1_N : N ; -- festmiddag..nn.1
  festmåltid_1_N : N ; -- festmåltid..nn.1
  feston_1_N : N ; -- feston..nn.1
  festong_1_N : N ; -- festong..nn.1
  festplanering_1_N : N ; -- festplanering..nn.1
  festprisse_1_N : N ; -- festprisse..nn.1
  festprogram_1_N : N ; -- festprogram..nn.1
  festsal_1_N : N ; -- festsal..nn.1
  festskrift_1_N : N ; -- festskrift..nn.1
  festspel_1_N : N ; -- festspel..nn.1
  feststämning_1_N : N ; -- feststämning..nn.1
  festtal_1_N : N ; -- festtal..nn.1
  festtalare_1_N : N ; -- festtalare..nn.1
  festtåg_1_N : N ; -- festtåg..nn.1
  festutstyrsel_1_N : N ; -- festutstyrsel..nn.1
  festvärdinna_1_N : N ; -- festvärdinna..nn.1
  festvåning_1_N : N ; -- festvåning..nn.1
  fet_1_A : A ; -- fet..av.1
  fetaost_1_N : N ; -- fetaost..nn.1
  fetblad_1_N : N ; -- fetblad..nn.1
  fetera_1_V : V ; -- fetera..vb.1
  feterande_1_N : N ; -- feterande..nn.1
  feterbar_1_A : A ; -- feterbar..av.1
  feterbarhet_1_N : N ; -- feterbarhet..nn.1
  fetering_1_N : N ; -- fetering..nn.1
  fethet_1_N : N ; -- fethet..nn.1
  fetisch_1_N : N ; -- fetisch..nn.1
  fetischism_1_N : N ; -- fetischism..nn.1
  fetischist_1_N : N ; -- fetischist..nn.1
  fetischistisk_1_A : A ; -- fetischistisk..av.1
  fetknopp_1_N : N ; -- fetknopp..nn.1
  fetlagd_1_A : A ; -- fetlagd..av.1
  fetlagdhet_1_N : N ; -- fetlagdhet..nn.1
  fetma_1_N : N ; -- fetma..nn.1
  fetma_1_V : V ; -- fetma..vb.1
  fetmaepidemi_1_N : N ; -- fetmaepidemi..nn.1
  fetmande_1_N : N ; -- fetmande..nn.1
  fetna_1_V : V ; -- fetna..vb.1
  fetnande_1_N : N ; -- fetnande..nn.1
  fets_1_N : N ; -- fets..nn.1
  fetsill_1_N : N ; -- fetsill..nn.1
  fetstil_1_N : N ; -- fetstil..nn.1
  fett_1_N : N ; -- fett..nn.1
  fettförbränning_1_N : N ; -- fettförbränning..nn.1
  fettglänsande_1_A : A ; -- fettglänsande..av.1
  fetthalt_1_N : N ; -- fetthalt..nn.1
  fetthaltig_1_A : A ; -- fetthaltig..av.1
  fetthaltighet_1_N : N ; -- fetthaltighet..nn.1
  fetthjärta_1_N : N ; -- fetthjärta..nn.1
  fetthärdning_1_N : N ; -- fetthärdning..nn.1
  fettisdag_1_N : N ; -- fettisdag..nn.1
  fettisdagsbulla_1_N : N ; -- fettisdagsbulla..nn.1
  fettisdagsbulle_1_N : N ; -- fettisdagsbulle..nn.1
  fettklump_1_N : N ; -- fettklump..nn.1
  fettkörtel_1_N : N ; -- fettkörtel..nn.1
  fettlever_1_N : N ; -- fettlever..nn.1
  fettlösande_1_A : A ; -- fettlösande..av.1
  fettlöslig_1_A : A ; -- fettlöslig..av.1
  fettlöslighet_1_N : N ; -- fettlöslighet..nn.1
  fetto_1_N : N ; -- fetto..nn.1
  fettprocent_1_N : N ; -- fettprocent..nn.1
  fettpärla_1_N : N ; -- fettpärla..nn.1
  fettreserv_1_N : N ; -- fettreserv..nn.1
  fettrik_1_A : A ; -- fettrik..av.1
  fettrikhet_1_N : N ; -- fettrikhet..nn.1
  fettsnål_1_A : A ; -- fettsnål..av.1
  fettsot_1_N : N ; -- fettsot..nn.1
  fettspruta_1_N : N ; -- fettspruta..nn.1
  fettsvansfår_1_N : N ; -- fettsvansfår..nn.1
  fettsyra_1_N : N ; -- fettsyra..nn.1
  fettvalk_1_N : N ; -- fettvalk..nn.1
  fettväv_1_N : N ; -- fettväv..nn.1
  fettvävnad_1_N : N ; -- fettvävnad..nn.1
  fettämne_1_N : N ; -- fettämne..nn.1
  fetvadd_1_N : N ; -- fetvadd..nn.1
  fez_1_N : N ; -- fez..nn.1
  fi_1_N : N ; -- fi..nn.1
  fia_1_N : N ; -- fia..nn.1
  fial_1_N : N ; -- fial..nn.1
  fiasko_1_N : N ; -- fiasko..nn.1
  fiaskoartad_1_A : A ; -- fiaskoartad..av.1
  fiaskokonferens_1_N : N ; -- fiaskokonferens..nn.1
  fibbla_1_N : N ; -- fibbla..nn.1
  fiber_1_N : N ; -- fiber..nn.1
  fiberblandning_1_N : N ; -- fiberblandning..nn.1
  fiberkabel_1_N : N ; -- fiberkabel..nn.1
  fiberoptik_1_N : N ; -- fiberoptik..nn.1
  fiberoptisk_1_A : A ; -- fiberoptisk..av.1
  fiberplatta_1_N : N ; -- fiberplatta..nn.1
  fiberrik_1_A : A ; -- fiberrik..av.1
  fiberrikhet_1_N : N ; -- fiberrikhet..nn.1
  fiberspik_1_N : N ; -- fiberspik..nn.1
  fibertillsats_1_N : N ; -- fibertillsats..nn.1
  fiberväxt_1_N : N ; -- fiberväxt..nn.1
  fibrig_1_A : A ; -- fibrig..av.1
  fibrighet_1_N : N ; -- fibrighet..nn.1
  fibrill_1_N : N ; -- fibrill..nn.1
  fibrillin_1_N : N ; -- fibrillin..nn.1
  fibrin_1_N : N ; -- fibrin..nn.1
  fibrinogen_1_N : N ; -- fibrinogen..nn.1
  fibromyalgi_1_N : N ; -- fibromyalgi..nn.1
  fibrös_1_A : A ; -- fibrös..av.1
  fibula_1_N : N ; -- fibula..nn.1
  ficka_1_N : N ; -- ficka..nn.1
  fickformat_1_N : N ; -- fickformat..nn.1
  fickhandbok_1_N : N ; -- fickhandbok..nn.1
  fickkalkylator_1_N : N ; -- fickkalkylator..nn.1
  fickkniv_1_N : N ; -- fickkniv..nn.1
  ficklampa_1_N : N ; -- ficklampa..nn.1
  ficklock_1_N : N ; -- ficklock..nn.1
  fickparkera_1_V : V ; -- fickparkera..vb.1
  fickparkerande_1_N : N ; -- fickparkerande..nn.1
  fickparkerbar_1_A : A ; -- fickparkerbar..av.1
  fickparkerbarhet_1_N : N ; -- fickparkerbarhet..nn.1
  fickparkering_1_N : N ; -- fickparkering..nn.1
  fickpeng_1_N : N ; -- fickpeng..nn.1
  fickplunta_1_N : N ; -- fickplunta..nn.1
  fickspegel_1_N : N ; -- fickspegel..nn.1
  fickstöld_1_N : N ; -- fickstöld..nn.1
  ficktjuv_1_N : N ; -- ficktjuv..nn.1
  fickur_1_N : N ; -- fickur..nn.1
  fiction_novell_1_N : N ; -- fiction-novell..nn.1
  fiction_1_N : N ; -- fiction..nn.1
  fideikommiss_1_N : N ; -- fideikommiss..nn.1
  fidjian_1_N : N ; -- fidjian..nn.1
  fidus_1_N : N ; -- fidus..nn.1
  fiende_1_N : N ; -- fiende..nn.1
  fiendearmé_1_N : N ; -- fiendearmé..nn.1
  fiendeland_1_N : N ; -- fiendeland..nn.1
  fiendelinje_1_N : N ; -- fiendelinje..nn.1
  fiendesoldat_1_N : N ; -- fiendesoldat..nn.1
  fiendskap_1_N : N ; -- fiendskap..nn.1
  fientlig_1_A : A ; -- fientlig..av.1
  fientlighet_1_N : N ; -- fientlighet..nn.1
  fiffel_1_N : N ; -- fiffel..nn.1
  fiffig_1_A : A ; -- fiffig..av.1
  fiffighet_1_N : N ; -- fiffighet..nn.1
  fiffla_1_V : V ; -- fiffla..vb.1
  fifflande_1_N : N ; -- fifflande..nn.1
  fifflare_1_N : N ; -- fifflare..nn.1
  fight_1_N : N ; -- fight..nn.1
  fighter_1_N : N ; -- fighter..nn.1
  figur_1_N : N ; -- figur..nn.1
  figurant_1_N : N ; -- figurant..nn.1
  figuration_1_N : N ; -- figuration..nn.1
  figurativ_1_A : A ; -- figurativ..av.1
  figurera_1_V : V ; -- figurera..vb.1
  figurerande_1_N : N ; -- figurerande..nn.1
  figurering_1_N : N ; -- figurering..nn.1
  figurlig_1_A : A ; -- figurlig..av.1
  figurlighet_1_N : N ; -- figurlighet..nn.1
  figursydd_1_A : A ; -- figursydd..av.1
  figurteckning_1_N : N ; -- figurteckning..nn.1
  figuråkare_1_N : N ; -- figuråkare..nn.1
  figuråkning_1_N : N ; -- figuråkning..nn.1
  fijian_1_N : N ; -- fijian..nn.1
  fijiansk_1_A : A ; -- fijiansk..av.1
  fijianska_1_N : N ; -- fijianska..nn.1
  fijianska_2_N : N ; -- fijianska..nn.2
  fik_1_N : N ; -- fik..nn.1
  fika_1_N : N ; -- fika..nn.1
  fika_1_V : V ; -- fika..vb.1
  fikadags_1_N : N ; -- fikadags..nn.1
  fikahörna_1_N : N ; -- fikahörna..nn.1
  fikande_1_N : N ; -- fikande..nn.1
  fikapaus_1_N : N ; -- fikapaus..nn.1
  fikarum_1_N : N ; -- fikarum..nn.1
  fiken_1_A : A ; -- fiken..av.1
  fikenhet_1_N : N ; -- fikenhet..nn.1
  fikon_1_N : N ; -- fikon..nn.1
  fikonlöv_1_N : N ; -- fikonlöv..nn.1
  fikonspråk_1_N : N ; -- fikonspråk..nn.1
  fikonträd_1_N : N ; -- fikonträd..nn.1
  fiktion_1_N : N ; -- fiktion..nn.1
  fiktionalism_1_N : N ; -- fiktionalism..nn.1
  fiktionsprosa_1_N : N ; -- fiktionsprosa..nn.1
  fiktiv_1_A : A ; -- fiktiv..av.1
  fikus_1_N : N ; -- fikus..nn.1
  fil_1_N : N ; -- fil..nn.1
  fil_2_N : N ; -- fil..nn.2
  fil_3_N : N ; -- fil..nn.3
  fila_1_V : V ; -- fila..vb.1
  filande_1_N : N ; -- filande..nn.1
  filantrop_1_N : N ; -- filantrop..nn.1
  filantropi_1_N : N ; -- filantropi..nn.1
  filantropisk_1_A : A ; -- filantropisk..av.1
  filare_1_N : N ; -- filare..nn.1
  filateli_1_N : N ; -- filateli..nn.1
  filatelist_1_N : N ; -- filatelist..nn.1
  filatelistisk_1_A : A ; -- filatelistisk..av.1
  filatelistklubb_1_N : N ; -- filatelistklubb..nn.1
  filbunke_1_N : N ; -- filbunke..nn.1
  filbyte_1_N : N ; -- filbyte..nn.1
  fildelare_1_N : N ; -- fildelare..nn.1
  fildelning_1_N : N ; -- fildelning..nn.1
  file_1_N : N ; -- file..nn.1
  filea_1_V : V ; -- filea..vb.1
  fileande_1_N : N ; -- fileande..nn.1
  filera_1_V : V ; -- filera..vb.1
  filerande_1_N : N ; -- filerande..nn.1
  filerbar_1_A : A ; -- filerbar..av.1
  filerbarhet_1_N : N ; -- filerbarhet..nn.1
  filering_1_N : N ; -- filering..nn.1
  filering_2_N : N ; -- filering..nn.2
  filhandtag_1_N : N ; -- filhandtag..nn.1
  filharmoni_1_N : N ; -- filharmoni..nn.1
  filharmoniker_1_N : N ; -- filharmoniker..nn.1
  filharmonisk_1_A : A ; -- filharmonisk..av.1
  filial_1_N : N ; -- filial..nn.1
  filialavdelning_1_N : N ; -- filialavdelning..nn.1
  filialkontor_1_N : N ; -- filialkontor..nn.1
  filibuster_1_N : N ; -- filibuster..nn.1
  filibustring_1_N : N ; -- filibustring..nn.1
  filigram_1_N : N ; -- filigram..nn.1
  filigran_1_N : N ; -- filigran..nn.1
  filipin_1_N : N ; -- filipin..nn.1
  filippik_1_N : N ; -- filippik..nn.1
  filippinare_1_N : N ; -- filippinare..nn.1
  filippinsk_1_A : A ; -- filippinsk..av.1
  filippinska_1_N : N ; -- filippinska..nn.1
  filister_1_N : N ; -- filister..nn.1
  filiströs_1_A : A ; -- filiströs..av.1
  filisté_1_N : N ; -- filisté..nn.1
  filklove_1_N : N ; -- filklove..nn.1
  filkörning_1_N : N ; -- filkörning..nn.1
  filler_1_N : N ; -- filler..nn.1
  film_1_N : N ; -- film..nn.1
  filma_1_V : V ; -- filma..vb.1
  filmaffisch_1_N : N ; -- filmaffisch..nn.1
  filmande_1_N : N ; -- filmande..nn.1
  filmare_1_N : N ; -- filmare..nn.1
  filmaskin_1_N : N ; -- filmaskin..nn.1
  filmateljé_1_N : N ; -- filmateljé..nn.1
  filmatisera_1_V : V ; -- filmatisera..vb.1
  filmatiserande_1_N : N ; -- filmatiserande..nn.1
  filmatiserbar_1_A : A ; -- filmatiserbar..av.1
  filmatiserbarhet_1_N : N ; -- filmatiserbarhet..nn.1
  filmatisering_1_N : N ; -- filmatisering..nn.1
  filmatisk_1_A : A ; -- filmatisk..av.1
  filmavsnitt_1_N : N ; -- filmavsnitt..nn.1
  filmberättande_1_N : N ; -- filmberättande..nn.1
  filmbild_1_N : N ; -- filmbild..nn.1
  filmbolag_1_N : N ; -- filmbolag..nn.1
  filmbransch_1_N : N ; -- filmbransch..nn.1
  filmcensur_1_N : N ; -- filmcensur..nn.1
  filmdebut_1_N : N ; -- filmdebut..nn.1
  filmdebutera_1_V : V ; -- filmdebutera..vb.1
  filmdebuterande_1_N : N ; -- filmdebuterande..nn.1
  filmdebutering_1_N : N ; -- filmdebutering..nn.1
  filmexpert_1_N : N ; -- filmexpert..nn.1
  filmfars_1_N : N ; -- filmfars..nn.1
  filmfestival_1_N : N ; -- filmfestival..nn.1
  filmfotograf_1_N : N ; -- filmfotograf..nn.1
  filmframkallning_1_N : N ; -- filmframkallning..nn.1
  filmgestalt_1_N : N ; -- filmgestalt..nn.1
  filmgranskning_1_N : N ; -- filmgranskning..nn.1
  filmhistoria_1_N : N ; -- filmhistoria..nn.1
  filmhistorisk_1_A : A ; -- filmhistorisk..av.1
  filmindustri_1_N : N ; -- filmindustri..nn.1
  filminspelning_1_N : N ; -- filminspelning..nn.1
  filmintresserad_1_A : A ; -- filmintresserad..av.1
  filmisk_1_A : A ; -- filmisk..av.1
  filmjölk_1_N : N ; -- filmjölk..nn.1
  filmkamera_1_N : N ; -- filmkamera..nn.1
  filmklipp_1_N : N ; -- filmklipp..nn.1
  filmklippning_1_N : N ; -- filmklippning..nn.1
  filmkomedi_1_N : N ; -- filmkomedi..nn.1
  filmmanuskript_1_N : N ; -- filmmanuskript..nn.1
  filmmatiné_1_N : N ; -- filmmatiné..nn.1
  filmmusik_1_N : N ; -- filmmusik..nn.1
  filmmässig_1_A : A ; -- filmmässig..av.1
  filmning_1_N : N ; -- filmning..nn.1
  filmotek_1_N : N ; -- filmotek..nn.1
  filmpremiär_1_N : N ; -- filmpremiär..nn.1
  filmpris_1_N : N ; -- filmpris..nn.1
  filmproducent_1_N : N ; -- filmproducent..nn.1
  filmproduktion_1_N : N ; -- filmproduktion..nn.1
  filmprofessor_1_N : N ; -- filmprofessor..nn.1
  filmregissör_1_N : N ; -- filmregissör..nn.1
  filmroll_1_N : N ; -- filmroll..nn.1
  filmrulle_1_N : N ; -- filmrulle..nn.1
  filmscen_1_N : N ; -- filmscen..nn.1
  filmskapare_1_N : N ; -- filmskapare..nn.1
  filmskådespelare_1_N : N ; -- filmskådespelare..nn.1
  filmskådespelerska_1_N : N ; -- filmskådespelerska..nn.1
  filmsnutt_1_N : N ; -- filmsnutt..nn.1
  filmstjärna_1_N : N ; -- filmstjärna..nn.1
  filmstudio_1_N : N ; -- filmstudio..nn.1
  filmtecknare_1_N : N ; -- filmtecknare..nn.1
  filmtidskrift_1_N : N ; -- filmtidskrift..nn.1
  filmtittande_1_A : A ; -- filmtittande..av.1
  filmtittande_1_N : N ; -- filmtittande..nn.1
  filmtrave_1_N : N ; -- filmtrave..nn.1
  filmversion_1_N : N ; -- filmversion..nn.1
  filmvetenskap_1_N : N ; -- filmvetenskap..nn.1
  filmvisning_1_N : N ; -- filmvisning..nn.1
  filning_1_N : N ; -- filning..nn.1
  filolog_1_N : N ; -- filolog..nn.1
  filologi_1_N : N ; -- filologi..nn.1
  filologisk_1_A : A ; -- filologisk..av.1
  filosof_1_N : N ; -- filosof..nn.1
  filosofem_1_N : N ; -- filosofem..nn.1
  filosofera_1_V : V ; -- filosofera..vb.1
  filosoferande_1_N : N ; -- filosoferande..nn.1
  filosofering_1_N : N ; -- filosofering..nn.1
  filosofi_1_N : N ; -- filosofi..nn.1
  filosofie_1_A : A ; -- filosofie..av.1
  filosofilärare_1_N : N ; -- filosofilärare..nn.1
  filosofisk_1_A : A ; -- filosofisk..av.1
  filosofkollega_1_N : N ; -- filosofkollega..nn.1
  filspån_1_N : N ; -- filspån..nn.1
  filt_1_N : N ; -- filt..nn.1
  filta_1_V : V ; -- filta..vb.1
  filtande_1_N : N ; -- filtande..nn.1
  filter_1_N : N ; -- filter..nn.1
  filtercigarett_1_N : N ; -- filtercigarett..nn.1
  filterludd_1_N : N ; -- filterludd..nn.1
  filterpåse_1_N : N ; -- filterpåse..nn.1
  filthatt_1_N : N ; -- filthatt..nn.1
  filtrat_1_N : N ; -- filtrat..nn.1
  filtrera_1_V : V ; -- filtrera..vb.1
  filtrerande_1_N : N ; -- filtrerande..nn.1
  filtrerbar_1_A : A ; -- filtrerbar..av.1
  filtrerbarhet_1_N : N ; -- filtrerbarhet..nn.1
  filtrering_1_N : N ; -- filtrering..nn.1
  filtrerpapper_1_N : N ; -- filtrerpapper..nn.1
  filtspets_1_N : N ; -- filtspets..nn.1
  filttoffel_1_N : N ; -- filttoffel..nn.1
  filttomte_1_N : N ; -- filttomte..nn.1
  filttäckt_1_A : A ; -- filttäckt..av.1
  filtyta_1_N : N ; -- filtyta..nn.1
  filur_1_N : N ; -- filur..nn.1
  filé_1_N : N ; -- filé..nn.1
  fimbulvinter_1_N : N ; -- fimbulvinter..nn.1
  fimmelstång_1_N : N ; -- fimmelstång..nn.1
  fimmerstång_1_N : N ; -- fimmerstång..nn.1
  fimp_1_N : N ; -- fimp..nn.1
  fimpa_1_V : V ; -- fimpa..vb.1
  fimpande_1_N : N ; -- fimpande..nn.1
  fimpkastare_1_N : N ; -- fimpkastare..nn.1
  fimpsug_1_N : N ; -- fimpsug..nn.1
  fin_1_A : A ; -- fin..av.1
  final_1_A : A ; -- final..av.1
  final_1_N : N ; -- final..nn.1
  finaldags_1_N : N ; -- finaldags..nn.1
  finalist_1_N : N ; -- finalist..nn.1
  finalklar_1_A : A ; -- finalklar..av.1
  finalmiss_1_N : N ; -- finalmiss..nn.1
  finalplats_1_N : N ; -- finalplats..nn.1
  finalsats_1_N : N ; -- finalsats..nn.1
  finalseger_1_N : N ; -- finalseger..nn.1
  finans_1_N : N ; -- finans..nn.1
  finanschef_1_N : N ; -- finanschef..nn.1
  finansdebatt_1_N : N ; -- finansdebatt..nn.1
  finansdepartement_1_N : N ; -- finansdepartement..nn.1
  finansdistrikt_1_N : N ; -- finansdistrikt..nn.1
  finansförvaltning_1_N : N ; -- finansförvaltning..nn.1
  finanshaj_1_N : N ; -- finanshaj..nn.1
  finansiell_1_A : A ; -- finansiell..av.1
  finansiera_1_V : V ; -- finansiera..vb.1
  finansierande_1_N : N ; -- finansierande..nn.1
  finansierbar_1_A : A ; -- finansierbar..av.1
  finansierbarhet_1_N : N ; -- finansierbarhet..nn.1
  finansiering_1_N : N ; -- finansiering..nn.1
  finansinspektion_1_N : N ; -- finansinspektion..nn.1
  finansiär_1_N : N ; -- finansiär..nn.1
  finanskrasch_1_N : N ; -- finanskrasch..nn.1
  finanskris_1_N : N ; -- finanskris..nn.1
  finansman_1_N : N ; -- finansman..nn.1
  finansmarknad_1_N : N ; -- finansmarknad..nn.1
  finansminister_1_N : N ; -- finansminister..nn.1
  finansministerium_1_N : N ; -- finansministerium..nn.1
  finansnetto_1_N : N ; -- finansnetto..nn.1
  finansplan_1_N : N ; -- finansplan..nn.1
  finanspolitik_1_N : N ; -- finanspolitik..nn.1
  finanspolitisk_1_A : A ; -- finanspolitisk..av.1
  finansrätt_1_N : N ; -- finansrätt..nn.1
  finansrättslig_1_A : A ; -- finansrättslig..av.1
  finansskojare_1_N : N ; -- finansskojare..nn.1
  finansutskott_1_N : N ; -- finansutskott..nn.1
  finansvalp_1_N : N ; -- finansvalp..nn.1
  finbruk_1_N : N ; -- finbruk..nn.1
  finbränna_1_V : V ; -- finbränna..vb.1
  finbrännande_1_N : N ; -- finbrännande..nn.1
  finemang_1_Adv : Adv ; -- finemang..ab.1
  finess_1_N : N ; -- finess..nn.1
  finfin_1_A : A ; -- finfin..av.1
  finfördela_1_V : V ; -- finfördela..vb.1
  finfördelande_1_N : N ; -- finfördelande..nn.1
  finger_1_N : N ; -- finger..nn.1
  fingera_1_V : V ; -- fingera..vb.1
  fingerad_1_A : A ; -- fingerad..av.1
  fingerande_1_N : N ; -- fingerande..nn.1
  fingeravtryck_1_N : N ; -- fingeravtryck..nn.1
  fingeravtrycksaspekt_1_N : N ; -- fingeravtrycksaspekt..nn.1
  fingerbar_1_A : A ; -- fingerbar..av.1
  fingerbarhet_1_N : N ; -- fingerbarhet..nn.1
  fingerblomma_1_N : N ; -- fingerblomma..nn.1
  fingerbläck_1_N : N ; -- fingerbläck..nn.1
  fingerborg_1_N : N ; -- fingerborg..nn.1
  fingerborgsblomma_1_N : N ; -- fingerborgsblomma..nn.1
  fingerbred_1_A : A ; -- fingerbred..av.1
  fingerbredd_1_N : N ; -- fingerbredd..nn.1
  fingerböjarmuskel_1_N : N ; -- fingerböjarmuskel..nn.1
  fingerfärdig_1_A : A ; -- fingerfärdig..av.1
  fingerfärdighet_1_N : N ; -- fingerfärdighet..nn.1
  fingerfärg_1_N : N ; -- fingerfärg..nn.1
  fingerhandske_1_N : N ; -- fingerhandske..nn.1
  fingerhud_1_N : N ; -- fingerhud..nn.1
  fingering_1_N : N ; -- fingering..nn.1
  fingerknäppning_1_N : N ; -- fingerknäppning..nn.1
  fingerkrok_1_N : N ; -- fingerkrok..nn.1
  fingerled_1_N : N ; -- fingerled..nn.1
  fingernagel_1_N : N ; -- fingernagel..nn.1
  fingernerv_1_N : N ; -- fingernerv..nn.1
  fingerprov_1_N : N ; -- fingerprov..nn.1
  fingerring_1_N : N ; -- fingerring..nn.1
  fingerskiva_1_N : N ; -- fingerskiva..nn.1
  fingerspets_1_N : N ; -- fingerspets..nn.1
  fingersträckarmuskel_1_N : N ; -- fingersträckarmuskel..nn.1
  fingersvamp_1_N : N ; -- fingersvamp..nn.1
  fingersättning_1_N : N ; -- fingersättning..nn.1
  fingertopp_1_N : N ; -- fingertopp..nn.1
  fingertoppskänsla_1_N : N ; -- fingertoppskänsla..nn.1
  fingertoppsnyans_1_N : N ; -- fingertoppsnyans..nn.1
  fingertuta_1_N : N ; -- fingertuta..nn.1
  fingervante_1_N : N ; -- fingervante..nn.1
  fingervisning_1_N : N ; -- fingervisning..nn.1
  fingerört_1_N : N ; -- fingerört..nn.1
  fingerövning_1_N : N ; -- fingerövning..nn.1
  fingra_1_V : V ; -- fingra..vb.1
  fingrad_1_A : A ; -- fingrad..av.1
  fingraderad_1_A : A ; -- fingraderad..av.1
  fingrande_1_N : N ; -- fingrande..nn.1
  fingranska_1_V : V ; -- fingranska..vb.1
  fingranskande_1_N : N ; -- fingranskande..nn.1
  finhacka_1_V : V ; -- finhacka..vb.1
  finhackad_1_A : A ; -- finhackad..av.1
  finhet_1_N : N ; -- finhet..nn.1
  finhet_2_N : N ; -- finhet..nn.2
  finhyllt_1_A : A ; -- finhyllt..av.1
  finhyllthet_1_N : N ; -- finhyllthet..nn.1
  finingång_1_N : N ; -- finingång..nn.1
  fininställa_1_V : V ; -- fininställa..vb.1
  fininställande_1_N : N ; -- fininställande..nn.1
  finish_1_N : N ; -- finish..nn.1
  finit_1_A : A ; -- finit..av.1
  finjustera_1_V : V ; -- finjustera..vb.1
  finjusterande_1_N : N ; -- finjusterande..nn.1
  finjusterbar_1_A : A ; -- finjusterbar..av.1
  finjusterbarhet_1_N : N ; -- finjusterbarhet..nn.1
  finjustering_1_N : N ; -- finjustering..nn.1
  fink_1_N : N ; -- fink..nn.1
  finka_1_N : N ; -- finka..nn.1
  finka_1_V : V ; -- finka..vb.1
  finkalibrig_1_A : A ; -- finkalibrig..av.1
  finkalibrighet_1_N : N ; -- finkalibrighet..nn.1
  finkamma_1_V : V ; -- finkamma..vb.1
  finkammande_1_N : N ; -- finkammande..nn.1
  finkamning_1_N : N ; -- finkamning..nn.1
  finkande_1_N : N ; -- finkande..nn.1
  finkart_1_N : N ; -- finkart..nn.1
  finkel_1_N : N ; -- finkel..nn.1
  finkelolja_1_N : N ; -- finkelolja..nn.1
  finkfågel_1_N : N ; -- finkfågel..nn.1
  finklädd_1_A : A ; -- finklädd..av.1
  finkläddhet_1_N : N ; -- finkläddhet..nn.1
  finkornig_1_A : A ; -- finkornig..av.1
  finkornighet_1_N : N ; -- finkornighet..nn.1
  finkultur_1_N : N ; -- finkultur..nn.1
  finkulturell_1_A : A ; -- finkulturell..av.1
  finkunge_1_N : N ; -- finkunge..nn.1
  finkänsla_1_N : N ; -- finkänsla..nn.1
  finkänslig_1_A : A ; -- finkänslig..av.1
  finkänslighet_1_N : N ; -- finkänslighet..nn.1
  finlandisera_1_V : V ; -- finlandisera..vb.1
  finlandiserande_1_N : N ; -- finlandiserande..nn.1
  finlandiserbar_1_A : A ; -- finlandiserbar..av.1
  finlandiserbarhet_1_N : N ; -- finlandiserbarhet..nn.1
  finlandisering_1_N : N ; -- finlandisering..nn.1
  finlandism_1_N : N ; -- finlandism..nn.1
  finlandssvensk_1_A : A ; -- finlandssvensk..av.1
  finlandssvensk_1_N : N ; -- finlandssvensk..nn.1
  finlandssvenska_1_N : N ; -- finlandssvenska..nn.1
  finlandssvenska_2_N : N ; -- finlandssvenska..nn.2
  finlek_1_N : N ; -- finlek..nn.1
  finlemmad_1_A : A ; -- finlemmad..av.1
  finlir_1_N : N ; -- finlir..nn.1
  finländare_1_N : N ; -- finländare..nn.1
  finländsk_1_A : A ; -- finländsk..av.1
  finländska_1_N : N ; -- finländska..nn.1
  finmala_1_V : V ; -- finmala..vb.1
  finmalande_1_N : N ; -- finmalande..nn.1
  finmalning_1_N : N ; -- finmalning..nn.1
  finmaskig_1_A : A ; -- finmaskig..av.1
  finmaskighet_1_N : N ; -- finmaskighet..nn.1
  finmat_1_N : N ; -- finmat..nn.1
  finmekaniker_1_N : N ; -- finmekaniker..nn.1
  finmekanisk_1_A : A ; -- finmekanisk..av.1
  finmotorik_1_N : N ; -- finmotorik..nn.1
  finna_1_V : V ; -- finna..vb.1
  finnande_1_N : N ; -- finnande..nn.1
  finne_1_N : N ; -- finne..nn.1
  finnig_1_A : A ; -- finnig..av.1
  finnighet_1_N : N ; -- finnighet..nn.1
  finnjolle_1_N : N ; -- finnjolle..nn.1
  finnkamp_1_N : N ; -- finnkamp..nn.1
  finnmark_1_N : N ; -- finnmark..nn.1
  finpapper_1_N : N ; -- finpapper..nn.1
  finpappersbruk_1_N : N ; -- finpappersbruk..nn.1
  finputs_1_N : N ; -- finputs..nn.1
  finputsa_1_V : V ; -- finputsa..vb.1
  finputsande_1_N : N ; -- finputsande..nn.1
  finriven_1_A : A ; -- finriven..av.1
  finrum_1_N : N ; -- finrum..nn.1
  finsikta_1_V : V ; -- finsikta..vb.1
  finsiktande_1_N : N ; -- finsiktande..nn.1
  finsiktning_1_N : N ; -- finsiktning..nn.1
  finsilver_1_N : N ; -- finsilver..nn.1
  finsk_ugrisk_1_A : A ; -- finsk-ugrisk..av.1
  finsk_1_A : A ; -- finsk..av.1
  finska_1_N : N ; -- finska..nn.1
  finska_2_N : N ; -- finska..nn.2
  finskhet_1_N : N ; -- finskhet..nn.1
  finsko_1_N : N ; -- finsko..nn.1
  finskspråkig_1_A : A ; -- finskspråkig..av.1
  finsktalande_1_A : A ; -- finsktalande..av.1
  finskugrisk_1_A : A ; -- finskugrisk..av.1
  finskuren_1_A : A ; -- finskuren..av.1
  finskägd_1_A : A ; -- finskägd..av.1
  finskåp_1_N : N ; -- finskåp..nn.1
  finslipa_1_V : V ; -- finslipa..vb.1
  finslipande_1_N : N ; -- finslipande..nn.1
  finslipning_1_N : N ; -- finslipning..nn.1
  finsmakare_1_N : N ; -- finsmakare..nn.1
  finsmide_1_N : N ; -- finsmide..nn.1
  finsnickare_1_N : N ; -- finsnickare..nn.1
  finsnickeri_1_N : N ; -- finsnickeri..nn.1
  finspackel_1_N : N ; -- finspackel..nn.1
  finsprit_1_N : N ; -- finsprit..nn.1
  finspunnen_1_A : A ; -- finspunnen..av.1
  finspäntad_1_A : A ; -- finspäntad..av.1
  finstil_1_N : N ; -- finstil..nn.1
  finstilt_1_A : A ; -- finstilt..av.1
  finstrimlad_1_A : A ; -- finstrimlad..av.1
  finstruktur_1_N : N ; -- finstruktur..nn.1
  finstämd_1_A : A ; -- finstämd..av.1
  finstämdhet_1_N : N ; -- finstämdhet..nn.1
  fint_1_N : N ; -- fint..nn.1
  finta_1_V : V ; -- finta..vb.1
  fintande_1_N : N ; -- fintande..nn.1
  fintlig_1_A : A ; -- fintlig..av.1
  fintlighet_1_N : N ; -- fintlighet..nn.1
  fintrådig_1_A : A ; -- fintrådig..av.1
  fintvätt_1_N : N ; -- fintvätt..nn.1
  finurlig_1_A : A ; -- finurlig..av.1
  finurlighet_1_N : N ; -- finurlighet..nn.1
  fiol_1_N : N ; -- fiol..nn.1
  fiolblock_1_N : N ; -- fiolblock..nn.1
  fiolbyggare_1_N : N ; -- fiolbyggare..nn.1
  fiollåda_1_N : N ; -- fiollåda..nn.1
  fiolspelare_1_N : N ; -- fiolspelare..nn.1
  fiolsträng_1_N : N ; -- fiolsträng..nn.1
  fiolstråke_1_N : N ; -- fiolstråke..nn.1
  fiolvirtuos_1_N : N ; -- fiolvirtuos..nn.1
  fioritur_1_N : N ; -- fioritur..nn.1
  fippla_1_V : V ; -- fippla..vb.1
  fipplande_1_N : N ; -- fipplande..nn.1
  fipplig_1_A : A ; -- fipplig..av.1
  fipplighet_1_N : N ; -- fipplighet..nn.1
  fira_1_V : V ; -- fira..vb.1
  firande_1_N : N ; -- firande..nn.1
  firma_1_N : N ; -- firma..nn.1
  firmafest_1_N : N ; -- firmafest..nn.1
  firmament_1_N : N ; -- firmament..nn.1
  firmamärke_1_N : N ; -- firmamärke..nn.1
  firmanamn_1_N : N ; -- firmanamn..nn.1
  firmatecknare_1_N : N ; -- firmatecknare..nn.1
  firmateckning_1_N : N ; -- firmateckning..nn.1
  firn_1_N : N ; -- firn..nn.1
  firngräns_1_N : N ; -- firngräns..nn.1
  firning_1_N : N ; -- firning..nn.1
  firre_1_N : N ; -- firre..nn.1
  fis_1_N : N ; -- fis..nn.1
  fisande_1_N : N ; -- fisande..nn.1
  fischy_1_N : N ; -- fischy..nn.1
  fisförnäm_1_A : A ; -- fisförnäm..av.1
  fisförnämhet_1_N : N ; -- fisförnämhet..nn.1
  fisig_1_A : A ; -- fisig..av.1
  fisk_1_N : N ; -- fisk..nn.1
  fisk_2_N : N ; -- fisk..nn.2
  fiska_1_V : V ; -- fiska..vb.1
  fiskafänge_1_N : N ; -- fiskafänge..nn.1
  fiskal_1_A : A ; -- fiskal..av.1
  fiskal_1_N : N ; -- fiskal..nn.1
  fiskalisk_1_A : A ; -- fiskalisk..av.1
  fiskande_1_N : N ; -- fiskande..nn.1
  fiskare_1_N : N ; -- fiskare..nn.1
  fiskart_1_N : N ; -- fiskart..nn.1
  fiskben_1_N : N ; -- fiskben..nn.1
  fiskbensmönster_1_N : N ; -- fiskbensmönster..nn.1
  fiskbestick_1_N : N ; -- fiskbestick..nn.1
  fiskblåsa_1_N : N ; -- fiskblåsa..nn.1
  fiskbulle_1_N : N ; -- fiskbulle..nn.1
  fiskdamm_1_N : N ; -- fiskdamm..nn.1
  fiskdöd_1_N : N ; -- fiskdöd..nn.1
  fiske_1_N : N ; -- fiske..nn.1
  fiskeansvarig_1_A : A ; -- fiskeansvarig..av.1
  fiskebank_1_N : N ; -- fiskebank..nn.1
  fiskebåt_1_N : N ; -- fiskebåt..nn.1
  fiskebåtsbesättning_1_N : N ; -- fiskebåtsbesättning..nn.1
  fiskedon_1_N : N ; -- fiskedon..nn.1
  fiskedrag_1_N : N ; -- fiskedrag..nn.1
  fiskefartyg_1_N : N ; -- fiskefartyg..nn.1
  fiskegräns_1_N : N ; -- fiskegräns..nn.1
  fiskekniv_1_N : N ; -- fiskekniv..nn.1
  fiskekort_1_N : N ; -- fiskekort..nn.1
  fiskekrok_1_N : N ; -- fiskekrok..nn.1
  fiskelag_1_N : N ; -- fiskelag..nn.1
  fiskelina_1_N : N ; -- fiskelina..nn.1
  fiskelycka_1_N : N ; -- fiskelycka..nn.1
  fiskeläge_1_N : N ; -- fiskeläge..nn.1
  fiskenation_1_N : N ; -- fiskenation..nn.1
  fiskenät_1_N : N ; -- fiskenät..nn.1
  fiskeolycka_1_N : N ; -- fiskeolycka..nn.1
  fiskeredskap_1_N : N ; -- fiskeredskap..nn.1
  fiskeri_1_N : N ; -- fiskeri..nn.1
  fiskeristyrelse_1_N : N ; -- fiskeristyrelse..nn.1
  fiskestuga_1_N : N ; -- fiskestuga..nn.1
  fiskevatten_1_N : N ; -- fiskevatten..nn.1
  fiskevård_1_N : N ; -- fiskevård..nn.1
  fiskezon_1_N : N ; -- fiskezon..nn.1
  fiskfilé_1_N : N ; -- fiskfilé..nn.1
  fiskfärs_1_N : N ; -- fiskfärs..nn.1
  fiskfångst_1_N : N ; -- fiskfångst..nn.1
  fiskgjuse_1_N : N ; -- fiskgjuse..nn.1
  fiskguano_1_N : N ; -- fiskguano..nn.1
  fiskhalster_1_N : N ; -- fiskhalster..nn.1
  fiskhamn_1_N : N ; -- fiskhamn..nn.1
  fiskhuvud_1_N : N ; -- fiskhuvud..nn.1
  fiskkniv_1_N : N ; -- fiskkniv..nn.1
  fiskkrok_1_N : N ; -- fiskkrok..nn.1
  fiskleverolja_1_N : N ; -- fiskleverolja..nn.1
  fisklevertran_1_N : N ; -- fisklevertran..nn.1
  fisklik_1_A : A ; -- fisklik..av.1
  fisklikhet_1_N : N ; -- fisklikhet..nn.1
  fisklina_1_N : N ; -- fisklina..nn.1
  fisklir_1_N : N ; -- fisklir..nn.1
  fiskmjöl_1_N : N ; -- fiskmjöl..nn.1
  fiskmun_1_N : N ; -- fiskmun..nn.1
  fiskmåltid_1_N : N ; -- fiskmåltid..nn.1
  fiskmås_1_N : N ; -- fiskmås..nn.1
  fisknot_1_N : N ; -- fisknot..nn.1
  fisknät_1_N : N ; -- fisknät..nn.1
  fiskodling_1_N : N ; -- fiskodling..nn.1
  fiskolja_1_N : N ; -- fiskolja..nn.1
  fiskpedikyr_1_N : N ; -- fiskpedikyr..nn.1
  fiskpinne_1_N : N ; -- fiskpinne..nn.1
  fiskpudding_1_N : N ; -- fiskpudding..nn.1
  fiskredskap_1_N : N ; -- fiskredskap..nn.1
  fiskrens_1_N : N ; -- fiskrens..nn.1
  fiskrik_1_A : A ; -- fiskrik..av.1
  fiskrätt_1_N : N ; -- fiskrätt..nn.1
  fisksoppa_1_N : N ; -- fisksoppa..nn.1
  fiskspad_1_N : N ; -- fiskspad..nn.1
  fiskstim_1_N : N ; -- fiskstim..nn.1
  fiskstjärt_1_N : N ; -- fiskstjärt..nn.1
  fisksump_1_N : N ; -- fisksump..nn.1
  fisksås_1_N : N ; -- fisksås..nn.1
  fisktom_1_A : A ; -- fisktom..av.1
  fisktomhet_1_N : N ; -- fisktomhet..nn.1
  fisktrappa_1_N : N ; -- fisktrappa..nn.1
  fisktärna_1_N : N ; -- fisktärna..nn.1
  fiskvandring_1_N : N ; -- fiskvandring..nn.1
  fiskvin_1_N : N ; -- fiskvin..nn.1
  fiskyngel_1_N : N ; -- fiskyngel..nn.1
  fiskätande_1_N : N ; -- fiskätande..nn.1
  fiskådra_1_N : N ; -- fiskådra..nn.1
  fisködla_1_N : N ; -- fisködla..nn.1
  fisköga_1_N : N ; -- fisköga..nn.1
  fissil_1_A : A ; -- fissil..av.1
  fission_1_N : N ; -- fission..nn.1
  fissur_1_N : N ; -- fissur..nn.1
  fistel_1_N : N ; -- fistel..nn.1
  fistulös_1_A : A ; -- fistulös..av.1
  fitness_1_N : N ; -- fitness..nn.1
  fitta_1_N : N ; -- fitta..nn.1
  fittrakt_1_N : N ; -- fittrakt..nn.1
  fittsafari_1_N : N ; -- fittsafari..nn.1
  fittstim_1_N : N ; -- fittstim..nn.1
  fix_1_A : A ; -- fix..av.1
  fix_1_N : N ; -- fix..nn.1
  fix_2_N : N ; -- fix..nn.2
  fixa_1_V : V ; -- fixa..vb.1
  fixande_1_N : N ; -- fixande..nn.1
  fixare_1_N : N ; -- fixare..nn.1
  fixativ_1_N : N ; -- fixativ..nn.1
  fixera_1_V : V ; -- fixera..vb.1
  fixerad_1_A : A ; -- fixerad..av.1
  fixerande_1_N : N ; -- fixerande..nn.1
  fixerbad_1_N : N ; -- fixerbad..nn.1
  fixerbar_1_A : A ; -- fixerbar..av.1
  fixerbarhet_1_N : N ; -- fixerbarhet..nn.1
  fixering_1_N : N ; -- fixering..nn.1
  fixeringsbild_1_N : N ; -- fixeringsbild..nn.1
  fixhet_1_N : N ; -- fixhet..nn.1
  fixkam_1_N : N ; -- fixkam..nn.1
  fixpunkt_1_N : N ; -- fixpunkt..nn.1
  fixstjärna_1_N : N ; -- fixstjärna..nn.1
  fixtur_1_N : N ; -- fixtur..nn.1
  fjant_1_N : N ; -- fjant..nn.1
  fjant_2_N : N ; -- fjant..nn.2
  fjanta_1_V : V ; -- fjanta..vb.1
  fjantande_1_N : N ; -- fjantande..nn.1
  fjanteri_1_N : N ; -- fjanteri..nn.1
  fjantig_1_A : A ; -- fjantig..av.1
  fjantighet_1_N : N ; -- fjantighet..nn.1
  fjantstämpel_1_N : N ; -- fjantstämpel..nn.1
  fjolla_1_N : N ; -- fjolla..nn.1
  fjolleri_1_N : N ; -- fjolleri..nn.1
  fjollig_1_A : A ; -- fjollig..av.1
  fjollighet_1_N : N ; -- fjollighet..nn.1
  fjolår_1_N : N ; -- fjolår..nn.1
  fjolårsgräs_1_N : N ; -- fjolårsgräs..nn.1
  fjomperi_1_N : N ; -- fjomperi..nn.1
  fjompig_1_A : A ; -- fjompig..av.1
  fjompighet_1_N : N ; -- fjompighet..nn.1
  fjong_1_N : N ; -- fjong..nn.1
  fjord_1_N : N ; -- fjord..nn.1
  fjordhäst_1_N : N ; -- fjordhäst..nn.1
  fjording_1_N : N ; -- fjording..nn.1
  fjortis_1_N : N ; -- fjortis..nn.1
  fjortonde_1_A : A ; -- fjortonde..av.1
  fjortonhundratal_1_N : N ; -- fjortonhundratal..nn.1
  fjortonårig_1_A : A ; -- fjortonårig..av.1
  fjortonåring_1_N : N ; -- fjortonåring..nn.1
  fjun_1_N : N ; -- fjun..nn.1
  fjunig_1_A : A ; -- fjunig..av.1
  fjuttholme_1_N : N ; -- fjuttholme..nn.1
  fjuttig_1_A : A ; -- fjuttig..av.1
  fjuttighet_1_N : N ; -- fjuttighet..nn.1
  fjäder_1_N : N ; -- fjäder..nn.1
  fjäderbeklädnad_1_N : N ; -- fjäderbeklädnad..nn.1
  fjäderboll_1_N : N ; -- fjäderboll..nn.1
  fjäderbuske_1_N : N ; -- fjäderbuske..nn.1
  fjäderdosa_1_N : N ; -- fjäderdosa..nn.1
  fjäderdräkt_1_N : N ; -- fjäderdräkt..nn.1
  fjäderformad_1_A : A ; -- fjäderformad..av.1
  fjäderfä_1_N : N ; -- fjäderfä..nn.1
  fjädergräs_1_N : N ; -- fjädergräs..nn.1
  fjäderklädd_1_A : A ; -- fjäderklädd..av.1
  fjäderkudde_1_N : N ; -- fjäderkudde..nn.1
  fjäderliknande_1_A : A ; -- fjäderliknande..av.1
  fjäderluftgevär_1_N : N ; -- fjäderluftgevär..nn.1
  fjäderlätt_1_A : A ; -- fjäderlätt..av.1
  fjäderlätthet_1_N : N ; -- fjäderlätthet..nn.1
  fjädermoln_1_N : N ; -- fjädermoln..nn.1
  fjädermygga_1_N : N ; -- fjädermygga..nn.1
  fjäderpensel_1_N : N ; -- fjäderpensel..nn.1
  fjäderskrud_1_N : N ; -- fjäderskrud..nn.1
  fjäderstål_1_N : N ; -- fjäderstål..nn.1
  fjädertyp_1_N : N ; -- fjädertyp..nn.1
  fjädervikt_1_N : N ; -- fjädervikt..nn.1
  fjädervinge_1_N : N ; -- fjädervinge..nn.1
  fjädervåg_1_N : N ; -- fjädervåg..nn.1
  fjädra_1_V : V ; -- fjädra..vb.1
  fjädrande_1_N : N ; -- fjädrande..nn.1
  fjädring_1_N : N ; -- fjädring..nn.1
  fjädringskapacitet_1_N : N ; -- fjädringskapacitet..nn.1
  fjädringsmekanism_1_N : N ; -- fjädringsmekanism..nn.1
  fjäll_1_N : N ; -- fjäll..nn.1
  fjälla_1_N : N ; -- fjälla..nn.1
  fjälla_1_V : V ; -- fjälla..vb.1
  fjälla_2_V : V ; -- fjälla..vb.2
  fjällande_1_N : N ; -- fjällande..nn.1
  fjällandskap_1_N : N ; -- fjällandskap..nn.1
  fjällbilist_1_N : N ; -- fjällbilist..nn.1
  fjällbjörk_1_N : N ; -- fjällbjörk..nn.1
  fjällbrud_1_N : N ; -- fjällbrud..nn.1
  fjällbygd_1_N : N ; -- fjällbygd..nn.1
  fjällbäck_1_N : N ; -- fjällbäck..nn.1
  fjälldal_1_N : N ; -- fjälldal..nn.1
  fjällig_1_A : A ; -- fjällig..av.1
  fjällighet_1_N : N ; -- fjällighet..nn.1
  fjällik_1_A : A ; -- fjällik..av.1
  fjällikhet_1_N : N ; -- fjällikhet..nn.1
  fjällkedja_1_N : N ; -- fjällkedja..nn.1
  fjällnatur_1_N : N ; -- fjällnatur..nn.1
  fjällning_1_N : N ; -- fjällning..nn.1
  fjällnära_1_A : A ; -- fjällnära..av.1
  fjällpanelshus_1_N : N ; -- fjällpanelshus..nn.1
  fjällpansar_1_N : N ; -- fjällpansar..nn.1
  fjällparti_1_N : N ; -- fjällparti..nn.1
  fjällpipare_1_N : N ; -- fjällpipare..nn.1
  fjällplatå_1_N : N ; -- fjällplatå..nn.1
  fjällregion_1_N : N ; -- fjällregion..nn.1
  fjällripa_1_N : N ; -- fjällripa..nn.1
  fjällrygg_1_N : N ; -- fjällrygg..nn.1
  fjällräv_1_N : N ; -- fjällräv..nn.1
  fjällsemester_1_N : N ; -- fjällsemester..nn.1
  fjällsippa_1_N : N ; -- fjällsippa..nn.1
  fjällsjö_1_N : N ; -- fjällsjö..nn.1
  fjällskivling_1_N : N ; -- fjällskivling..nn.1
  fjällsluttning_1_N : N ; -- fjällsluttning..nn.1
  fjällspets_1_N : N ; -- fjällspets..nn.1
  fjällstation_1_N : N ; -- fjällstation..nn.1
  fjällstuga_1_N : N ; -- fjällstuga..nn.1
  fjällsyra_1_N : N ; -- fjällsyra..nn.1
  fjälltopp_1_N : N ; -- fjälltopp..nn.1
  fjälltrakt_1_N : N ; -- fjälltrakt..nn.1
  fjällturist_1_N : N ; -- fjällturist..nn.1
  fjälluft_1_N : N ; -- fjälluft..nn.1
  fjälluggla_1_N : N ; -- fjälluggla..nn.1
  fjällvandra_1_V : V ; -- fjällvandra..vb.1
  fjällvandrande_1_N : N ; -- fjällvandrande..nn.1
  fjällvandrare_1_N : N ; -- fjällvandrare..nn.1
  fjällvandring_1_N : N ; -- fjällvandring..nn.1
  fjällvråk_1_N : N ; -- fjällvråk..nn.1
  fjällvärld_1_N : N ; -- fjällvärld..nn.1
  fjällämmel_1_N : N ; -- fjällämmel..nn.1
  fjälster_1_N : N ; -- fjälster..nn.1
  fjär_1_A : A ; -- fjär..av.1
  fjärd_1_N : N ; -- fjärd..nn.1
  fjärde_1_A : A ; -- fjärde..av.1
  fjärdedel_1_N : N ; -- fjärdedel..nn.1
  fjärdegradsekvation_1_N : N ; -- fjärdegradsekvation..nn.1
  fjärdeplats_1_N : N ; -- fjärdeplats..nn.1
  fjärding_1_N : N ; -- fjärding..nn.1
  fjärdingsman_1_N : N ; -- fjärdingsman..nn.1
  fjärdingsväg_1_N : N ; -- fjärdingsväg..nn.1
  fjärhet_1_N : N ; -- fjärhet..nn.1
  fjäril_1_N : N ; -- fjäril..nn.1
  fjärilsart_1_N : N ; -- fjärilsart..nn.1
  fjärilsblomma_1_N : N ; -- fjärilsblomma..nn.1
  fjärilseffekt_1_N : N ; -- fjärilseffekt..nn.1
  fjärilslarv_1_N : N ; -- fjärilslarv..nn.1
  fjärilslätt_1_A : A ; -- fjärilslätt..av.1
  fjärilsvinge_1_N : N ; -- fjärilsvinge..nn.1
  fjärma_1_V : V ; -- fjärma..vb.1
  fjärmande_1_N : N ; -- fjärmande..nn.1
  fjärr_1_N : N ; -- fjärr..nn.1
  fjärran_1_Adv : Adv ; -- fjärran..ab.1
  fjärran_1_A : A ; -- fjärran..av.1
  fjärranblickande_1_A : A ; -- fjärranblickande..av.1
  fjärrblockera_1_V : V ; -- fjärrblockera..vb.1
  fjärrblockerande_1_N : N ; -- fjärrblockerande..nn.1
  fjärrblockerbar_1_A : A ; -- fjärrblockerbar..av.1
  fjärrblockerbarhet_1_N : N ; -- fjärrblockerbarhet..nn.1
  fjärrblockering_1_N : N ; -- fjärrblockering..nn.1
  fjärrhandel_1_N : N ; -- fjärrhandel..nn.1
  fjärris_1_N : N ; -- fjärris..nn.1
  fjärrkontroll_1_N : N ; -- fjärrkontroll..nn.1
  fjärrpunkt_1_N : N ; -- fjärrpunkt..nn.1
  fjärrseende_1_A : A ; -- fjärrseende..av.1
  fjärrskrivare_1_N : N ; -- fjärrskrivare..nn.1
  fjärrskrivmaskin_1_N : N ; -- fjärrskrivmaskin..nn.1
  fjärrskådande_1_A : A ; -- fjärrskådande..av.1
  fjärrskådare_1_N : N ; -- fjärrskådare..nn.1
  fjärrströmbrytare_1_N : N ; -- fjärrströmbrytare..nn.1
  fjärrstyrd_1_A : A ; -- fjärrstyrd..av.1
  fjärrtrafik_1_N : N ; -- fjärrtrafik..nn.1
  fjärrtåg_1_N : N ; -- fjärrtåg..nn.1
  fjärrvärme_1_N : N ; -- fjärrvärme..nn.1
  fjärrvärmegranskning_1_N : N ; -- fjärrvärmegranskning..nn.1
  fjärrvärmepris_1_N : N ; -- fjärrvärmepris..nn.1
  fjärsing_1_N : N ; -- fjärsing..nn.1
  fjärt_1_N : N ; -- fjärt..nn.1
  fjärta_1_V : V ; -- fjärta..vb.1
  fjärtande_1_N : N ; -- fjärtande..nn.1
  fjäsk_1_N : N ; -- fjäsk..nn.1
  fjäska_1_V : V ; -- fjäska..vb.1
  fjäskande_1_N : N ; -- fjäskande..nn.1
  fjäsker_1_N : N ; -- fjäsker..nn.1
  fjäskig_1_A : A ; -- fjäskig..av.1
  fjäskighet_1_N : N ; -- fjäskighet..nn.1
  fjät_1_N : N ; -- fjät..nn.1
  fjättra_1_V : V ; -- fjättra..vb.1
  fjättrande_1_N : N ; -- fjättrande..nn.1
  fjöl_1_N : N ; -- fjöl..nn.1
  fjöla_1_V : V ; -- fjöla..vb.1
  flabb_1_N : N ; -- flabb..nn.1
  flabb_2_N : N ; -- flabb..nn.2
  flabba_1_V : V ; -- flabba..vb.1
  flabbande_1_N : N ; -- flabbande..nn.1
  flabbig_1_A : A ; -- flabbig..av.1
  flabbighet_1_N : N ; -- flabbighet..nn.1
  flack_1_A : A ; -- flack..av.1
  flacka_1_V : V ; -- flacka..vb.1
  flackande_1_N : N ; -- flackande..nn.1
  flackbanepjäs_1_N : N ; -- flackbanepjäs..nn.1
  flackeld_1_N : N ; -- flackeld..nn.1
  flackhet_1_N : N ; -- flackhet..nn.1
  flackland_1_N : N ; -- flackland..nn.1
  fladder_1_N : N ; -- fladder..nn.1
  fladdermus_1_N : N ; -- fladdermus..nn.1
  fladdermusfåtölj_1_N : N ; -- fladdermusfåtölj..nn.1
  fladdermusliknande_1_A : A ; -- fladdermusliknande..av.1
  fladdra_1_V : V ; -- fladdra..vb.1
  fladdrande_1_N : N ; -- fladdrande..nn.1
  fladdrig_1_A : A ; -- fladdrig..av.1
  fladdrighet_1_N : N ; -- fladdrighet..nn.1
  flaga_1_N : N ; -- flaga..nn.1
  flaga_1_V : V ; -- flaga..vb.1
  flagande_1_N : N ; -- flagande..nn.1
  flagell_1_N : N ; -- flagell..nn.1
  flagellant_1_N : N ; -- flagellant..nn.1
  flagellantism_1_N : N ; -- flagellantism..nn.1
  flagellat_1_N : N ; -- flagellat..nn.1
  flageolett_1_N : N ; -- flageolett..nn.1
  flagg_1_N : N ; -- flagg..nn.1
  flagga_1_N : N ; -- flagga..nn.1
  flagga_1_V : V ; -- flagga..vb.1
  flaggande_1_N : N ; -- flaggande..nn.1
  flaggbränning_1_N : N ; -- flaggbränning..nn.1
  flaggdag_1_N : N ; -- flaggdag..nn.1
  flaggduk_1_N : N ; -- flaggduk..nn.1
  flaggkapten_1_N : N ; -- flaggkapten..nn.1
  flagglina_1_N : N ; -- flagglina..nn.1
  flaggman_1_N : N ; -- flaggman..nn.1
  flaggning_1_N : N ; -- flaggning..nn.1
  flaggprydd_1_A : A ; -- flaggprydd..av.1
  flaggsignal_1_N : N ; -- flaggsignal..nn.1
  flaggskepp_1_N : N ; -- flaggskepp..nn.1
  flaggskändning_1_N : N ; -- flaggskändning..nn.1
  flaggspel_1_N : N ; -- flaggspel..nn.1
  flaggstång_1_N : N ; -- flaggstång..nn.1
  flaggvakt_1_N : N ; -- flaggvakt..nn.1
  flaggviftande_1_A : A ; -- flaggviftande..av.1
  flaggviftande_1_N : N ; -- flaggviftande..nn.1
  flaggviftning_1_N : N ; -- flaggviftning..nn.1
  flagig_1_A : A ; -- flagig..av.1
  flagna_1_V : V ; -- flagna..vb.1
  flagnande_1_N : N ; -- flagnande..nn.1
  flagrant_1_A : A ; -- flagrant..av.1
  flak_1_N : N ; -- flak..nn.1
  flakmoppe_1_N : N ; -- flakmoppe..nn.1
  flakong_1_N : N ; -- flakong..nn.1
  flakvagn_1_N : N ; -- flakvagn..nn.1
  flambera_1_V : V ; -- flambera..vb.1
  flamberande_1_N : N ; -- flamberande..nn.1
  flamberbar_1_A : A ; -- flamberbar..av.1
  flamberbarhet_1_N : N ; -- flamberbarhet..nn.1
  flambering_1_N : N ; -- flambering..nn.1
  flamenco_1_N : N ; -- flamenco..nn.1
  flamencogitarrist_1_N : N ; -- flamencogitarrist..nn.1
  flamingo_1_N : N ; -- flamingo..nn.1
  flamländare_1_N : N ; -- flamländare..nn.1
  flamländsk_1_A : A ; -- flamländsk..av.1
  flamländska_1_N : N ; -- flamländska..nn.1
  flamländska_2_N : N ; -- flamländska..nn.2
  flamma_1_N : N ; -- flamma..nn.1
  flamma_1_V : V ; -- flamma..vb.1
  flammande_1_N : N ; -- flammande..nn.1
  flammig_1_A : A ; -- flammig..av.1
  flammighet_1_N : N ; -- flammighet..nn.1
  flampunkt_1_N : N ; -- flampunkt..nn.1
  flams_1_N : N ; -- flams..nn.1
  flamsa_1_N : N ; -- flamsa..nn.1
  flamsa_1_V : V ; -- flamsa..vb.1
  flamsande_1_N : N ; -- flamsande..nn.1
  flamsig_1_A : A ; -- flamsig..av.1
  flamsighet_1_N : N ; -- flamsighet..nn.1
  flamsk_1_A : A ; -- flamsk..av.1
  flamskhet_1_N : N ; -- flamskhet..nn.1
  flamskvävnad_1_N : N ; -- flamskvävnad..nn.1
  flamskyddsmedel_1_N : N ; -- flamskyddsmedel..nn.1
  flamugn_1_N : N ; -- flamugn..nn.1
  flandrisk_1_A : A ; -- flandrisk..av.1
  flanell_1_N : N ; -- flanell..nn.1
  flanellborste_1_N : N ; -- flanellborste..nn.1
  flanellkostym_1_N : N ; -- flanellkostym..nn.1
  flanellograf_1_N : N ; -- flanellograf..nn.1
  flanellpyjamas_1_N : N ; -- flanellpyjamas..nn.1
  flanera_1_V : V ; -- flanera..vb.1
  flanerande_1_N : N ; -- flanerande..nn.1
  flanering_1_N : N ; -- flanering..nn.1
  flank_1_N : N ; -- flank..nn.1
  flankanfall_1_N : N ; -- flankanfall..nn.1
  flankera_1_V : V ; -- flankera..vb.1
  flankerande_1_N : N ; -- flankerande..nn.1
  flankerbar_1_A : A ; -- flankerbar..av.1
  flankerbarhet_1_N : N ; -- flankerbarhet..nn.1
  flankering_1_N : N ; -- flankering..nn.1
  flanör_1_N : N ; -- flanör..nn.1
  flark_1_N : N ; -- flark..nn.1
  flarn_1_N : N ; -- flarn..nn.1
  flashig_1_A : A ; -- flashig..av.1
  flaska_1_N : N ; -- flaska..nn.1
  flaskbarn_1_N : N ; -- flaskbarn..nn.1
  flaskborste_1_N : N ; -- flaskborste..nn.1
  flaskbrist_1_N : N ; -- flaskbrist..nn.1
  flaskhals_1_N : N ; -- flaskhals..nn.1
  flaskhål_1_N : N ; -- flaskhål..nn.1
  flaskkastning_1_N : N ; -- flaskkastning..nn.1
  flaskkurbits_1_N : N ; -- flaskkurbits..nn.1
  flasklock_1_N : N ; -- flasklock..nn.1
  flasknosdelfin_1_N : N ; -- flasknosdelfin..nn.1
  flaskpost_1_N : N ; -- flaskpost..nn.1
  flasköppnare_1_N : N ; -- flasköppnare..nn.1
  flasköppning_1_N : N ; -- flasköppning..nn.1
  flat_1_A : A ; -- flat..av.1
  flata_1_N : N ; -- flata..nn.1
  flatbottnad_1_A : A ; -- flatbottnad..av.1
  flatbröd_1_N : N ; -- flatbröd..nn.1
  flateka_1_N : N ; -- flateka..nn.1
  flatfisk_1_N : N ; -- flatfisk..nn.1
  flatgarv_1_N : N ; -- flatgarv..nn.1
  flathet_1_N : N ; -- flathet..nn.1
  flatlus_1_N : N ; -- flatlus..nn.1
  flatsida_1_N : N ; -- flatsida..nn.1
  flatskratt_1_N : N ; -- flatskratt..nn.1
  flatskratta_1_V : V ; -- flatskratta..vb.1
  flatskrattande_1_N : N ; -- flatskrattande..nn.1
  flattera_1_V : V ; -- flattera..vb.1
  flatterande_1_N : N ; -- flatterande..nn.1
  flatterbar_1_A : A ; -- flatterbar..av.1
  flatterbarhet_1_N : N ; -- flatterbarhet..nn.1
  flattering_1_N : N ; -- flattering..nn.1
  flatulens_1_N : N ; -- flatulens..nn.1
  flau_1_A : A ; -- flau..av.1
  flax_1_N : N ; -- flax..nn.1
  flax_2_N : N ; -- flax..nn.2
  flaxa_1_V : V ; -- flaxa..vb.1
  flaxande_1_N : N ; -- flaxande..nn.1
  flaxig_1_A : A ; -- flaxig..av.1
  flaxighet_1_N : N ; -- flaxighet..nn.1
  flaxning_1_N : N ; -- flaxning..nn.1
  fleece_foder_1_N : N ; -- fleece-foder..nn.1
  fleece_1_N : N ; -- fleece..nn.1
  flegma_1_N : N ; -- flegma..nn.1
  flegmatiker_1_N : N ; -- flegmatiker..nn.1
  flegmatisk_1_A : A ; -- flegmatisk..av.1
  flektera_1_V : V ; -- flektera..vb.1
  flekterande_1_N : N ; -- flekterande..nn.1
  flekterbar_1_A : A ; -- flekterbar..av.1
  flekterbarhet_1_N : N ; -- flekterbarhet..nn.1
  flektering_1_N : N ; -- flektering..nn.1
  flektion_1_N : N ; -- flektion..nn.1
  flensost_1_N : N ; -- flensost..nn.1
  flerbarnsfamilj_1_N : N ; -- flerbarnsfamilj..nn.1
  flerbarnsmamma_1_N : N ; -- flerbarnsmamma..nn.1
  flerbarnsmor_1_N : N ; -- flerbarnsmor..nn.1
  flerbostadshus_1_N : N ; -- flerbostadshus..nn.1
  flercellig_1_A : A ; -- flercellig..av.1
  flercellighet_1_N : N ; -- flercellighet..nn.1
  flerdubbel_1_A : A ; -- flerdubbel..av.1
  flerdubbla_1_V : V ; -- flerdubbla..vb.1
  flerdubblande_1_N : N ; -- flerdubblande..nn.1
  flerfaldig_1_A : A ; -- flerfaldig..av.1
  flerfaldiga_1_V : V ; -- flerfaldiga..vb.1
  flerfaldigande_1_N : N ; -- flerfaldigande..nn.1
  flerfamiljshus_1_N : N ; -- flerfamiljshus..nn.1
  flerfärgad_1_A : A ; -- flerfärgad..av.1
  flerfärgstryck_1_N : N ; -- flerfärgstryck..nn.1
  flergångs_1_A : A ; -- flergångs..av.1
  flergångsförbrytare_1_N : N ; -- flergångsförbrytare..nn.1
  flerhandikapp_1_N : N ; -- flerhandikapp..nn.1
  flerhandikappad_1_A : A ; -- flerhandikappad..av.1
  flerhet_1_N : N ; -- flerhet..nn.1
  flermansvalkrets_1_N : N ; -- flermansvalkrets..nn.1
  fleromättad_1_A : A ; -- fleromättad..av.1
  flerording_1_N : N ; -- flerording..nn.1
  flerordsenhet_1_N : N ; -- flerordsenhet..nn.1
  flerpartisystem_1_N : N ; -- flerpartisystem..nn.1
  flersidig_1_A : A ; -- flersidig..av.1
  flersiffrig_1_A : A ; -- flersiffrig..av.1
  flerspråkig_1_A : A ; -- flerspråkig..av.1
  flerspråkighet_1_N : N ; -- flerspråkighet..nn.1
  flerstammig_1_A : A ; -- flerstammig..av.1
  flerstavig_1_A : A ; -- flerstavig..av.1
  flerstavighet_1_N : N ; -- flerstavighet..nn.1
  flerstämmig_1_A : A ; -- flerstämmig..av.1
  flerstämmighet_1_N : N ; -- flerstämmighet..nn.1
  flertal_1_N : N ; -- flertal..nn.1
  flertydig_1_A : A ; -- flertydig..av.1
  flertydighet_1_N : N ; -- flertydighet..nn.1
  flervalsfråga_1_N : N ; -- flervalsfråga..nn.1
  flervalstest_1_N : N ; -- flervalstest..nn.1
  flervalsuppgift_1_N : N ; -- flervalsuppgift..nn.1
  flervåningshus_1_N : N ; -- flervåningshus..nn.1
  flerårig_1_A : A ; -- flerårig..av.1
  fles_1_N : N ; -- fles..nn.1
  flexa_1_V : V ; -- flexa..vb.1
  flexande_1_N : N ; -- flexande..nn.1
  flexibel_1_A : A ; -- flexibel..av.1
  flexibilitet_1_N : N ; -- flexibilitet..nn.1
  flexion_1_N : N ; -- flexion..nn.1
  flexionsform_1_N : N ; -- flexionsform..nn.1
  flexionsändelse_1_N : N ; -- flexionsändelse..nn.1
  flexislang_1_N : N ; -- flexislang..nn.1
  flexivisk_1_A : A ; -- flexivisk..av.1
  flexklocka_1_N : N ; -- flexklocka..nn.1
  flextid_1_N : N ; -- flextid..nn.1
  flexur_1_N : N ; -- flexur..nn.1
  flicka_1_N : N ; -- flicka..nn.1
  flickaktig_1_A : A ; -- flickaktig..av.1
  flickaktighet_1_N : N ; -- flickaktighet..nn.1
  flickansikte_1_N : N ; -- flickansikte..nn.1
  flickbok_1_N : N ; -- flickbok..nn.1
  flickboksfantasi_1_N : N ; -- flickboksfantasi..nn.1
  flickbokshjältinna_1_N : N ; -- flickbokshjältinna..nn.1
  flickboksklassiker_1_N : N ; -- flickboksklassiker..nn.1
  flickbokstradition_1_N : N ; -- flickbokstradition..nn.1
  flickebarn_1_N : N ; -- flickebarn..nn.1
  flickfotograf_1_N : N ; -- flickfotograf..nn.1
  flickjägare_1_N : N ; -- flickjägare..nn.1
  flickkalv_1_N : N ; -- flickkalv..nn.1
  flickkör_1_N : N ; -- flickkör..nn.1
  flickmatch_1_N : N ; -- flickmatch..nn.1
  flicknamn_1_N : N ; -- flicknamn..nn.1
  flickpension_1_N : N ; -- flickpension..nn.1
  flickröst_1_N : N ; -- flickröst..nn.1
  flickscout_1_N : N ; -- flickscout..nn.1
  flickskola_1_N : N ; -- flickskola..nn.1
  flickslända_1_N : N ; -- flickslända..nn.1
  flicksnärta_1_N : N ; -- flicksnärta..nn.1
  flicktycke_1_N : N ; -- flicktycke..nn.1
  flickunge_1_N : N ; -- flickunge..nn.1
  flickvän_1_N : N ; -- flickvän..nn.1
  flight_1_N : N ; -- flight..nn.1
  flik_1_N : N ; -- flik..nn.1
  flikad_1_A : A ; -- flikad..av.1
  flikig_1_A : A ; -- flikig..av.1
  flikighet_1_N : N ; -- flikighet..nn.1
  flimmer_1_N : N ; -- flimmer..nn.1
  flimmercell_1_N : N ; -- flimmercell..nn.1
  flimmerhår_1_N : N ; -- flimmerhår..nn.1
  flimra_1_V : V ; -- flimra..vb.1
  flimrande_1_N : N ; -- flimrande..nn.1
  flimrig_1_A : A ; -- flimrig..av.1
  flimrighet_1_N : N ; -- flimrighet..nn.1
  flin_1_N : N ; -- flin..nn.1
  flina_1_V : V ; -- flina..vb.1
  flinande_1_N : N ; -- flinande..nn.1
  flinare_1_N : N ; -- flinare..nn.1
  flinga_1_N : N ; -- flinga..nn.1
  flingsalt_1_N : N ; -- flingsalt..nn.1
  flink_1_A : A ; -- flink..av.1
  flinkhet_1_N : N ; -- flinkhet..nn.1
  flint_1_N : N ; -- flint..nn.1
  flinta_1_N : N ; -- flinta..nn.1
  flintgods_1_N : N ; -- flintgods..nn.1
  flintlås_1_N : N ; -- flintlås..nn.1
  flintlåsgevär_1_N : N ; -- flintlåsgevär..nn.1
  flintskalle_1_N : N ; -- flintskalle..nn.1
  flintskallig_1_A : A ; -- flintskallig..av.1
  flintskallighet_1_N : N ; -- flintskallighet..nn.1
  flintyxa_1_N : N ; -- flintyxa..nn.1
  flipperkula_1_N : N ; -- flipperkula..nn.1
  flipperspel_1_N : N ; -- flipperspel..nn.1
  flipprig_1_A : A ; -- flipprig..av.1
  flirt_1_N : N ; -- flirt..nn.1
  flirta_1_V : V ; -- flirta..vb.1
  flirtande_1_N : N ; -- flirtande..nn.1
  flirtig_1_A : A ; -- flirtig..av.1
  flirtighet_1_N : N ; -- flirtighet..nn.1
  flis_1_N : N ; -- flis..nn.1
  flisa_1_N : N ; -- flisa..nn.1
  flisig_1_A : A ; -- flisig..av.1
  flisighet_1_N : N ; -- flisighet..nn.1
  flit_1_N : N ; -- flit..nn.1
  flitig_1_A : A ; -- flitig..av.1
  flo_1_N : N ; -- flo..nn.1
  floatglas_1_N : N ; -- floatglas..nn.1
  flock_1_N : N ; -- flock..nn.1
  flock_2_N : N ; -- flock..nn.2
  flockbeteende_1_N : N ; -- flockbeteende..nn.1
  flockblommig_1_A : A ; -- flockblommig..av.1
  flockdjur_1_N : N ; -- flockdjur..nn.1
  flockig_1_A : A ; -- flockig..av.1
  flockighet_1_N : N ; -- flockighet..nn.1
  flockinstinkt_1_N : N ; -- flockinstinkt..nn.1
  flockkamrat_1_N : N ; -- flockkamrat..nn.1
  flockvis_1_Adv : Adv ; -- flockvis..ab.1
  flod_1_N : N ; -- flod..nn.1
  flodarm_1_N : N ; -- flodarm..nn.1
  flodbrädd_1_N : N ; -- flodbrädd..nn.1
  flodbädd_1_N : N ; -- flodbädd..nn.1
  flodbåt_1_N : N ; -- flodbåt..nn.1
  floddal_1_N : N ; -- floddal..nn.1
  floddelta_1_N : N ; -- floddelta..nn.1
  flodfart_1_N : N ; -- flodfart..nn.1
  flodfåra_1_N : N ; -- flodfåra..nn.1
  flodgud_1_N : N ; -- flodgud..nn.1
  flodhäst_1_N : N ; -- flodhäst..nn.1
  flodhästunge_1_N : N ; -- flodhästunge..nn.1
  flodiller_1_N : N ; -- flodiller..nn.1
  flodkrabba_1_N : N ; -- flodkrabba..nn.1
  flodkrök_1_N : N ; -- flodkrök..nn.1
  flodmynning_1_N : N ; -- flodmynning..nn.1
  flodområde_1_N : N ; -- flodområde..nn.1
  flodprofil_1_N : N ; -- flodprofil..nn.1
  flodslätt_1_N : N ; -- flodslätt..nn.1
  flodstrand_1_N : N ; -- flodstrand..nn.1
  flodsvin_1_N : N ; -- flodsvin..nn.1
  flodsystem_1_N : N ; -- flodsystem..nn.1
  flodterrass_1_N : N ; -- flodterrass..nn.1
  flodvatten_1_N : N ; -- flodvatten..nn.1
  flodvåg_1_N : N ; -- flodvåg..nn.1
  flodångare_1_N : N ; -- flodångare..nn.1
  flodövergång_1_N : N ; -- flodövergång..nn.1
  flogrönn_1_N : N ; -- flogrönn..nn.1
  flop_1_N : N ; -- flop..nn.1
  flopp_1_N : N ; -- flopp..nn.1
  floppa_1_V : V ; -- floppa..vb.1
  floppande_1_N : N ; -- floppande..nn.1
  floppning_1_N : N ; -- floppning..nn.1
  floppsatsning_1_N : N ; -- floppsatsning..nn.1
  flor_1_N : N ; -- flor..nn.1
  flor_2_N : N ; -- flor..nn.2
  flora_1_N : N ; -- flora..nn.1
  florentinsk_1_A : A ; -- florentinsk..av.1
  florera_1_V : V ; -- florera..vb.1
  florerande_1_N : N ; -- florerande..nn.1
  florering_1_N : N ; -- florering..nn.1
  florett_1_N : N ; -- florett..nn.1
  florettfäktning_1_N : N ; -- florettfäktning..nn.1
  florettfäktningskurs_1_N : N ; -- florettfäktningskurs..nn.1
  florettstick_1_N : N ; -- florettstick..nn.1
  florilegium_1_N : N ; -- florilegium..nn.1
  florin_1_N : N ; -- florin..nn.1
  florist_1_N : N ; -- florist..nn.1
  floristik_1_N : N ; -- floristik..nn.1
  floristisk_1_A : A ; -- floristisk..av.1
  florsocker_1_N : N ; -- florsocker..nn.1
  floskel_1_N : N ; -- floskel..nn.1
  floskelpatriot_1_N : N ; -- floskelpatriot..nn.1
  floskulös_1_A : A ; -- floskulös..av.1
  flossa_1_N : N ; -- flossa..nn.1
  flossa_1_V : V ; -- flossa..vb.1
  flossad_1_A : A ; -- flossad..av.1
  flossande_1_N : N ; -- flossande..nn.1
  flossning_1_N : N ; -- flossning..nn.1
  flotation_1_N : N ; -- flotation..nn.1
  flott_1_A : A ; -- flott..av.1
  flott_1_N : N ; -- flott..nn.1
  flotta_1_N : N ; -- flotta..nn.1
  flotta_1_V : V ; -- flotta..vb.1
  flottande_1_N : N ; -- flottande..nn.1
  flottare_1_N : N ; -- flottare..nn.1
  flottbas_1_N : N ; -- flottbas..nn.1
  flottbesök_1_N : N ; -- flottbesök..nn.1
  flottbro_1_N : N ; -- flottbro..nn.1
  flotte_1_N : N ; -- flotte..nn.1
  flottenhet_1_N : N ; -- flottenhet..nn.1
  flottfläck_1_N : N ; -- flottfläck..nn.1
  flotthet_1_N : N ; -- flotthet..nn.1
  flottig_1_A : A ; -- flottig..av.1
  flottighet_1_N : N ; -- flottighet..nn.1
  flottilj_1_N : N ; -- flottilj..nn.1
  flottist_1_N : N ; -- flottist..nn.1
  flottled_1_N : N ; -- flottled..nn.1
  flottning_1_N : N ; -- flottning..nn.1
  flottningstimmer_1_N : N ; -- flottningstimmer..nn.1
  flottstrateg_1_N : N ; -- flottstrateg..nn.1
  flottstyrman_1_N : N ; -- flottstyrman..nn.1
  flottyr_1_N : N ; -- flottyr..nn.1
  flottyrkoka_1_V : V ; -- flottyrkoka..vb.1
  flottyrkokande_1_N : N ; -- flottyrkokande..nn.1
  flottör_1_N : N ; -- flottör..nn.1
  flottövning_1_N : N ; -- flottövning..nn.1
  flox_1_N : N ; -- flox..nn.1
  fluffig_1_A : A ; -- fluffig..av.1
  fluffighet_1_N : N ; -- fluffighet..nn.1
  fluga_1_N : N ; -- fluga..nn.1
  flugblomster_1_N : N ; -- flugblomster..nn.1
  flugfiske_1_N : N ; -- flugfiske..nn.1
  flugpapper_1_N : N ; -- flugpapper..nn.1
  flugsmuts_1_N : N ; -- flugsmuts..nn.1
  flugsmälla_1_N : N ; -- flugsmälla..nn.1
  flugsnappare_1_N : N ; -- flugsnappare..nn.1
  flugsvamp_1_N : N ; -- flugsvamp..nn.1
  flugvifta_1_N : N ; -- flugvifta..nn.1
  flugvikt_1_N : N ; -- flugvikt..nn.1
  fluid_1_N : N ; -- fluid..nn.1
  fluidisera_1_V : V ; -- fluidisera..vb.1
  fluidiserande_1_N : N ; -- fluidiserande..nn.1
  fluidiserbar_1_A : A ; -- fluidiserbar..av.1
  fluidiserbarhet_1_N : N ; -- fluidiserbarhet..nn.1
  fluidisering_1_N : N ; -- fluidisering..nn.1
  fluidum_1_N : N ; -- fluidum..nn.1
  flukt_1_N : N ; -- flukt..nn.1
  flukta_1_V : V ; -- flukta..vb.1
  fluktande_1_N : N ; -- fluktande..nn.1
  fluktuation_1_N : N ; -- fluktuation..nn.1
  fluktuera_1_V : V ; -- fluktuera..vb.1
  fluktuerande_1_N : N ; -- fluktuerande..nn.1
  fluktuering_1_N : N ; -- fluktuering..nn.1
  flumkurs_1_N : N ; -- flumkurs..nn.1
  flumma_1_V : V ; -- flumma..vb.1
  flummande_1_N : N ; -- flummande..nn.1
  flummig_1_A : A ; -- flummig..av.1
  flummighet_1_N : N ; -- flummighet..nn.1
  flumpedagogik_1_N : N ; -- flumpedagogik..nn.1
  flundra_1_N : N ; -- flundra..nn.1
  flunsa_1_N : N ; -- flunsa..nn.1
  fluor_1_N : N ; -- fluor..nn.1
  fluorbehandling_1_N : N ; -- fluorbehandling..nn.1
  fluorera_1_V : V ; -- fluorera..vb.1
  fluorerande_1_N : N ; -- fluorerande..nn.1
  fluorerbar_1_A : A ; -- fluorerbar..av.1
  fluorerbarhet_1_N : N ; -- fluorerbarhet..nn.1
  fluorering_1_N : N ; -- fluorering..nn.1
  fluorescens_1_N : N ; -- fluorescens..nn.1
  fluorescera_1_V : V ; -- fluorescera..vb.1
  fluorescerande_1_N : N ; -- fluorescerande..nn.1
  fluorescering_1_N : N ; -- fluorescering..nn.1
  fluorhalt_1_N : N ; -- fluorhalt..nn.1
  fluorhaltig_1_A : A ; -- fluorhaltig..av.1
  fluorid_1_N : N ; -- fluorid..nn.1
  fluoridera_1_V : V ; -- fluoridera..vb.1
  fluoriderande_1_N : N ; -- fluoriderande..nn.1
  fluoriderbar_1_A : A ; -- fluoriderbar..av.1
  fluoriderbarhet_1_N : N ; -- fluoriderbarhet..nn.1
  fluoridering_1_N : N ; -- fluoridering..nn.1
  fluss_1_N : N ; -- fluss..nn.1
  flussglas_1_N : N ; -- flussglas..nn.1
  flussmedel_1_N : N ; -- flussmedel..nn.1
  flusspat_1_N : N ; -- flusspat..nn.1
  fluster_1_N : N ; -- fluster..nn.1
  fluvial_1_A : A ; -- fluvial..av.1
  fly_1_N : N ; -- fly..nn.1
  fly_1_V : V ; -- fly..vb.1
  flyende_1_N : N ; -- flyende..nn.1
  flyfotad_1_A : A ; -- flyfotad..av.1
  flyfotadhet_1_N : N ; -- flyfotadhet..nn.1
  flyg_1_N : N ; -- flyg..nn.1
  flyg_2_N : N ; -- flyg..nn.2
  flyga_1_V : V ; -- flyga..vb.1
  flygande_1_N : N ; -- flygande..nn.1
  flyganfall_1_N : N ; -- flyganfall..nn.1
  flygankomst_1_N : N ; -- flygankomst..nn.1
  flygare_1_N : N ; -- flygare..nn.1
  flygattaché_1_N : N ; -- flygattaché..nn.1
  flygattack_1_N : N ; -- flygattack..nn.1
  flygavgång_1_N : N ; -- flygavgång..nn.1
  flygbas_1_N : N ; -- flygbas..nn.1
  flygbasbarack_1_N : N ; -- flygbasbarack..nn.1
  flygbensin_1_N : N ; -- flygbensin..nn.1
  flygbild_1_N : N ; -- flygbild..nn.1
  flygbiljett_1_N : N ; -- flygbiljett..nn.1
  flygblad_1_N : N ; -- flygblad..nn.1
  flygbolag_1_N : N ; -- flygbolag..nn.1
  flygbomb_1_N : N ; -- flygbomb..nn.1
  flygbomba_1_V : V ; -- flygbomba..vb.1
  flygbombande_1_N : N ; -- flygbombande..nn.1
  flygbro_1_N : N ; -- flygbro..nn.1
  flygbränsle_1_N : N ; -- flygbränsle..nn.1
  flygbuss_1_N : N ; -- flygbuss..nn.1
  flygbåt_1_N : N ; -- flygbåt..nn.1
  flygcertifikat_1_N : N ; -- flygcertifikat..nn.1
  flygdrama_1_N : N ; -- flygdrama..nn.1
  flygekorre_1_N : N ; -- flygekorre..nn.1
  flygel_1_N : N ; -- flygel..nn.1
  flygelbyggnad_1_N : N ; -- flygelbyggnad..nn.1
  flygfisk_1_N : N ; -- flygfisk..nn.1
  flygflotta_1_N : N ; -- flygflotta..nn.1
  flygfoto_1_N : N ; -- flygfoto..nn.1
  flygfotogen_1_N : N ; -- flygfotogen..nn.1
  flygfotografi_1_N : N ; -- flygfotografi..nn.1
  flygfrakt_1_N : N ; -- flygfrakt..nn.1
  flygfä_1_N : N ; -- flygfä..nn.1
  flygfält_1_N : N ; -- flygfält..nn.1
  flygfärd_1_N : N ; -- flygfärd..nn.1
  flygfärdig_1_A : A ; -- flygfärdig..av.1
  flygfärdighet_1_N : N ; -- flygfärdighet..nn.1
  flygförare_1_N : N ; -- flygförare..nn.1
  flygförband_1_N : N ; -- flygförband..nn.1
  flygförbud_1_N : N ; -- flygförbud..nn.1
  flygförbudszon_1_N : N ; -- flygförbudszon..nn.1
  flygg_1_A : A ; -- flygg..av.1
  flygghet_1_N : N ; -- flygghet..nn.1
  flyghastighet_1_N : N ; -- flyghastighet..nn.1
  flyghavre_1_N : N ; -- flyghavre..nn.1
  flyghund_1_N : N ; -- flyghund..nn.1
  flyghål_1_N : N ; -- flyghål..nn.1
  flygindustri_1_N : N ; -- flygindustri..nn.1
  flygkaos_1_N : N ; -- flygkaos..nn.1
  flygkapacitet_1_N : N ; -- flygkapacitet..nn.1
  flygkapning_1_N : N ; -- flygkapning..nn.1
  flygkapten_1_N : N ; -- flygkapten..nn.1
  flygkatastrof_1_N : N ; -- flygkatastrof..nn.1
  flygkonst_1_N : N ; -- flygkonst..nn.1
  flygkorridor_1_N : N ; -- flygkorridor..nn.1
  flygkropp_1_N : N ; -- flygkropp..nn.1
  flygkår_1_N : N ; -- flygkår..nn.1
  flyglarm_1_N : N ; -- flyglarm..nn.1
  flygledare_1_N : N ; -- flygledare..nn.1
  flygledarstrejk_1_N : N ; -- flygledarstrejk..nn.1
  flygledes_1_Adv : Adv ; -- flygledes..ab.1
  flygledning_1_N : N ; -- flygledning..nn.1
  flyglinje_1_N : N ; -- flyglinje..nn.1
  flyglägenhet_1_N : N ; -- flyglägenhet..nn.1
  flygmaskin_1_N : N ; -- flygmaskin..nn.1
  flygmyra_1_N : N ; -- flygmyra..nn.1
  flygning_1_N : N ; -- flygning..nn.1
  flygpassagerare_1_N : N ; -- flygpassagerare..nn.1
  flygpersonal_1_N : N ; -- flygpersonal..nn.1
  flygplan_1_N : N ; -- flygplan..nn.1
  flygplansbesättning_1_N : N ; -- flygplansbesättning..nn.1
  flygplanshangar_1_N : N ; -- flygplanshangar..nn.1
  flygplanskabin_1_N : N ; -- flygplanskabin..nn.1
  flygplansluft_1_N : N ; -- flygplansluft..nn.1
  flygplansmodell_1_N : N ; -- flygplansmodell..nn.1
  flygplansroder_1_N : N ; -- flygplansroder..nn.1
  flygplanstillverkare_1_N : N ; -- flygplanstillverkare..nn.1
  flygplanstoa_1_N : N ; -- flygplanstoa..nn.1
  flygplansvinge_1_N : N ; -- flygplansvinge..nn.1
  flygplats_1_N : N ; -- flygplats..nn.1
  flygplatsservering_1_N : N ; -- flygplatsservering..nn.1
  flygpost_1_N : N ; -- flygpost..nn.1
  flygresa_1_N : N ; -- flygresa..nn.1
  flygräd_1_N : N ; -- flygräd..nn.1
  flygrädd_1_A : A ; -- flygrädd..av.1
  flygrönn_1_N : N ; -- flygrönn..nn.1
  flygsand_1_N : N ; -- flygsand..nn.1
  flygsandsfält_1_N : N ; -- flygsandsfält..nn.1
  flygskrift_1_N : N ; -- flygskrift..nn.1
  flygstol_1_N : N ; -- flygstol..nn.1
  flygstopp_1_N : N ; -- flygstopp..nn.1
  flygstörning_1_N : N ; -- flygstörning..nn.1
  flygsäkerhet_1_N : N ; -- flygsäkerhet..nn.1
  flygsäkerhetsexpert_1_N : N ; -- flygsäkerhetsexpert..nn.1
  flygsäkerhetskonsult_1_N : N ; -- flygsäkerhetskonsult..nn.1
  flygtaxi_1_N : N ; -- flygtaxi..nn.1
  flygterminal_1_N : N ; -- flygterminal..nn.1
  flygtidtabell_1_N : N ; -- flygtidtabell..nn.1
  flygtrafik_1_N : N ; -- flygtrafik..nn.1
  flygtrafikledare_1_N : N ; -- flygtrafikledare..nn.1
  flygtrafikledning_1_N : N ; -- flygtrafikledning..nn.1
  flygtransport_1_N : N ; -- flygtransport..nn.1
  flygtur_1_N : N ; -- flygtur..nn.1
  flygutbildning_1_N : N ; -- flygutbildning..nn.1
  flygvapen_1_N : N ; -- flygvapen..nn.1
  flygvapenchef_1_N : N ; -- flygvapenchef..nn.1
  flygväg_1_N : N ; -- flygväg..nn.1
  flygvärdinna_1_N : N ; -- flygvärdinna..nn.1
  flygödla_1_N : N ; -- flygödla..nn.1
  flyhänt_1_A : A ; -- flyhänt..av.1
  flyhänthet_1_N : N ; -- flyhänthet..nn.1
  flykt_1_N : N ; -- flykt..nn.1
  flykt_2_N : N ; -- flykt..nn.2
  flykta_1_V : V ; -- flykta..vb.1
  flyktande_1_N : N ; -- flyktande..nn.1
  flyktfara_1_N : N ; -- flyktfara..nn.1
  flyktfordon_1_N : N ; -- flyktfordon..nn.1
  flyktförsök_1_N : N ; -- flyktförsök..nn.1
  flyktig_1_A : A ; -- flyktig..av.1
  flyktighet_1_N : N ; -- flyktighet..nn.1
  flyktighet_2_N : N ; -- flyktighet..nn.2
  flykting_1_N : N ; -- flykting..nn.1
  flyktingbarn_1_N : N ; -- flyktingbarn..nn.1
  flyktingfamilj_1_N : N ; -- flyktingfamilj..nn.1
  flyktinggömmare_1_N : N ; -- flyktinggömmare..nn.1
  flyktinglik_1_N : N ; -- flyktinglik..nn.1
  flyktingläger_1_N : N ; -- flyktingläger..nn.1
  flyktingmottagande_1_N : N ; -- flyktingmottagande..nn.1
  flyktingmottagning_1_N : N ; -- flyktingmottagning..nn.1
  flyktingpolitik_1_N : N ; -- flyktingpolitik..nn.1
  flyktingström_1_N : N ; -- flyktingström..nn.1
  flyktmekanism_1_N : N ; -- flyktmekanism..nn.1
  flyktmöjlighet_1_N : N ; -- flyktmöjlighet..nn.1
  flyktreaktion_1_N : N ; -- flyktreaktion..nn.1
  flyktrisk_1_N : N ; -- flyktrisk..nn.1
  flyktväg_1_N : N ; -- flyktväg..nn.1
  flyt_1_N : N ; -- flyt..nn.1
  flyta_1_V : V ; -- flyta..vb.1
  flytande_1_N : N ; -- flytande..nn.1
  flytdocka_1_N : N ; -- flytdocka..nn.1
  flytetyg_1_N : N ; -- flytetyg..nn.1
  flythjälp_1_N : N ; -- flythjälp..nn.1
  flytjord_1_N : N ; -- flytjord..nn.1
  flytning_1_N : N ; -- flytning..nn.1
  flytsand_1_N : N ; -- flytsand..nn.1
  flytspackel_1_N : N ; -- flytspackel..nn.1
  flytspackla_1_V : V ; -- flytspackla..vb.1
  flytspacklande_1_N : N ; -- flytspacklande..nn.1
  flytspackling_1_N : N ; -- flytspackling..nn.1
  flytt_1_N : N ; -- flytt..nn.1
  flytta_1_V : V ; -- flytta..vb.1
  flyttande_1_N : N ; -- flyttande..nn.1
  flyttbar_1_A : A ; -- flyttbar..av.1
  flyttbarhet_1_N : N ; -- flyttbarhet..nn.1
  flyttbestyr_1_N : N ; -- flyttbestyr..nn.1
  flyttblock_1_N : N ; -- flyttblock..nn.1
  flyttdag_1_N : N ; -- flyttdag..nn.1
  flyttfågel_1_N : N ; -- flyttfågel..nn.1
  flyttgröt_1_N : N ; -- flyttgröt..nn.1
  flyttid_1_N : N ; -- flyttid..nn.1
  flyttkarl_1_N : N ; -- flyttkarl..nn.1
  flyttkartong_1_N : N ; -- flyttkartong..nn.1
  flyttlass_1_N : N ; -- flyttlass..nn.1
  flyttlasspolitik_1_N : N ; -- flyttlasspolitik..nn.1
  flyttlåda_1_N : N ; -- flyttlåda..nn.1
  flyttning_1_N : N ; -- flyttning..nn.1
  flyttningsdag_1_N : N ; -- flyttningsdag..nn.1
  flyttningsförbud_1_N : N ; -- flyttningsförbud..nn.1
  flyttningstid_1_N : N ; -- flyttningstid..nn.1
  flytträtt_1_A : A ; -- flytträtt..av.1
  flyttsak_1_N : N ; -- flyttsak..nn.1
  flyttstök_1_N : N ; -- flyttstök..nn.1
  flytungad_1_A : A ; -- flytungad..av.1
  flytungadhet_1_N : N ; -- flytungadhet..nn.1
  flytväst_1_N : N ; -- flytväst..nn.1
  flytvästlag_1_N : N ; -- flytvästlag..nn.1
  fläck_1_N : N ; -- fläck..nn.1
  fläcka_1_V : V ; -- fläcka..vb.1
  fläckande_1_N : N ; -- fläckande..nn.1
  fläckborttagning_1_N : N ; -- fläckborttagning..nn.1
  fläckborttagningsmedel_1_N : N ; -- fläckborttagningsmedel..nn.1
  fläckfeber_1_N : N ; -- fläckfeber..nn.1
  fläckfri_1_A : A ; -- fläckfri..av.1
  fläckfrihet_1_N : N ; -- fläckfrihet..nn.1
  fläckig_1_A : A ; -- fläckig..av.1
  fläckighet_1_N : N ; -- fläckighet..nn.1
  fläcklös_1_A : A ; -- fläcklös..av.1
  fläcktyfus_1_N : N ; -- fläcktyfus..nn.1
  fläckvis_1_Adv : Adv ; -- fläckvis..ab.1
  fläder_1_N : N ; -- fläder..nn.1
  fläderbär_1_N : N ; -- fläderbär..nn.1
  flädermus_1_N : N ; -- flädermus..nn.1
  flädermärg_1_N : N ; -- flädermärg..nn.1
  flädermärgskula_1_N : N ; -- flädermärgskula..nn.1
  fläka_1_V : V ; -- fläka..vb.1
  fläkande_1_N : N ; -- fläkande..nn.1
  fläkning_1_N : N ; -- fläkning..nn.1
  fläkt_1_N : N ; -- fläkt..nn.1
  fläkta_1_V : V ; -- fläkta..vb.1
  fläktande_1_N : N ; -- fläktande..nn.1
  fläktning_1_N : N ; -- fläktning..nn.1
  flämta_1_V : V ; -- flämta..vb.1
  flämtande_1_N : N ; -- flämtande..nn.1
  flämtning_1_N : N ; -- flämtning..nn.1
  fläng_1_A : A ; -- fläng..av.1
  fläng_1_N : N ; -- fläng..nn.1
  flänga_1_V : V ; -- flänga..vb.1
  flänga_2_V : V ; -- flänga..vb.2
  flängande_1_N : N ; -- flängande..nn.1
  flänghet_1_N : N ; -- flänghet..nn.1
  flängig_1_A : A ; -- flängig..av.1
  flängighet_1_N : N ; -- flängighet..nn.1
  flängning_1_N : N ; -- flängning..nn.1
  fläns_1_N : N ; -- fläns..nn.1
  flänsa_1_V : V ; -- flänsa..vb.1
  flänsande_1_N : N ; -- flänsande..nn.1
  flänskniv_1_N : N ; -- flänskniv..nn.1
  flänsost_1_N : N ; -- flänsost..nn.1
  flärd_1_N : N ; -- flärd..nn.1
  flärdfri_1_A : A ; -- flärdfri..av.1
  flärdfrihet_1_N : N ; -- flärdfrihet..nn.1
  flärdfull_1_A : A ; -- flärdfull..av.1
  flärdfullhet_1_N : N ; -- flärdfullhet..nn.1
  flärdlös_1_A : A ; -- flärdlös..av.1
  flärdlöshet_1_N : N ; -- flärdlöshet..nn.1
  flärp_1_N : N ; -- flärp..nn.1
  flärpa_1_N : N ; -- flärpa..nn.1
  fläsk_1_N : N ; -- fläsk..nn.1
  fläskfilé_1_N : N ; -- fläskfilé..nn.1
  fläskfärs_1_N : N ; -- fläskfärs..nn.1
  fläskhare_1_N : N ; -- fläskhare..nn.1
  fläskig_1_A : A ; -- fläskig..av.1
  fläskighet_1_N : N ; -- fläskighet..nn.1
  fläskkarré_1_N : N ; -- fläskkarré..nn.1
  fläskkorv_1_N : N ; -- fläskkorv..nn.1
  fläskkotlett_1_N : N ; -- fläskkotlett..nn.1
  fläskkött_1_N : N ; -- fläskkött..nn.1
  fläsklägg_1_N : N ; -- fläsklägg..nn.1
  fläskläpp_1_N : N ; -- fläskläpp..nn.1
  fläskpannkaka_1_N : N ; -- fläskpannkaka..nn.1
  fläskstycke_1_N : N ; -- fläskstycke..nn.1
  fläsktärning_1_N : N ; -- fläsktärning..nn.1
  fläskänger_1_N : N ; -- fläskänger..nn.1
  fläta_1_N : N ; -- fläta..nn.1
  fläta_1_V : V ; -- fläta..vb.1
  flätande_1_N : N ; -- flätande..nn.1
  flätning_1_N : N ; -- flätning..nn.1
  flätverk_1_N : N ; -- flätverk..nn.1
  flå_1_V : V ; -- flå..vb.1
  flåbuse_1_N : N ; -- flåbuse..nn.1
  flådig_1_A : A ; -- flådig..av.1
  flående_1_N : N ; -- flående..nn.1
  flåhacka_1_N : N ; -- flåhacka..nn.1
  flåhacka_1_V : V ; -- flåhacka..vb.1
  flåhackande_1_N : N ; -- flåhackande..nn.1
  flåhackning_1_N : N ; -- flåhackning..nn.1
  flås_1_N : N ; -- flås..nn.1
  flåsa_1_V : V ; -- flåsa..vb.1
  flåsande_1_N : N ; -- flåsande..nn.1
  flåsig_1_A : A ; -- flåsig..av.1
  flåsning_1_N : N ; -- flåsning..nn.1
  flåspatos_1_N : N ; -- flåspatos..nn.1
  flöda_1_V : V ; -- flöda..vb.1
  flödande_1_N : N ; -- flödande..nn.1
  flöde_1_N : N ; -- flöde..nn.1
  flödesdiagram_1_N : N ; -- flödesdiagram..nn.1
  flödesschema_1_N : N ; -- flödesschema..nn.1
  flöj_1_N : N ; -- flöj..nn.1
  flöjel_1_N : N ; -- flöjel..nn.1
  flöjla_1_V : V ; -- flöjla..vb.1
  flöjlande_1_N : N ; -- flöjlande..nn.1
  flöjt_1_N : N ; -- flöjt..nn.1
  flöjta_1_V : V ; -- flöjta..vb.1
  flöjtande_1_N : N ; -- flöjtande..nn.1
  flöjtist_1_N : N ; -- flöjtist..nn.1
  flöjtton_1_N : N ; -- flöjtton..nn.1
  flöjttravär_1_N : N ; -- flöjttravär..nn.1
  flört_1_N : N ; -- flört..nn.1
  flörta_1_V : V ; -- flörta..vb.1
  flörtande_1_N : N ; -- flörtande..nn.1
  flörtig_1_A : A ; -- flörtig..av.1
  flörtighet_1_N : N ; -- flörtighet..nn.1
  flörtkula_1_N : N ; -- flörtkula..nn.1
  flörtlampa_1_N : N ; -- flörtlampa..nn.1
  flöte_1_N : N ; -- flöte..nn.1
  flöts_1_N : N ; -- flöts..nn.1
  fnas_1_N : N ; -- fnas..nn.1
  fnasig_1_A : A ; -- fnasig..av.1
  fnask_1_N : N ; -- fnask..nn.1
  fnaska_1_V : V ; -- fnaska..vb.1
  fnaskande_1_N : N ; -- fnaskande..nn.1
  fnasker_1_N : N ; -- fnasker..nn.1
  fnatt_1_N : N ; -- fnatt..nn.1
  fnatta_1_V : V ; -- fnatta..vb.1
  fnattande_1_N : N ; -- fnattande..nn.1
  fniss_1_N : N ; -- fniss..nn.1
  fnissa_1_V : V ; -- fnissa..vb.1
  fnissande_1_N : N ; -- fnissande..nn.1
  fnissig_1_A : A ; -- fnissig..av.1
  fnissighet_1_N : N ; -- fnissighet..nn.1
  fnissning_1_N : N ; -- fnissning..nn.1
  fnitter_1_N : N ; -- fnitter..nn.1
  fnittra_1_V : V ; -- fnittra..vb.1
  fnittrande_1_N : N ; -- fnittrande..nn.1
  fnittrig_1_A : A ; -- fnittrig..av.1
  fnittrighet_1_N : N ; -- fnittrighet..nn.1
  fnoskig_1_A : A ; -- fnoskig..av.1
  fnoskighet_1_N : N ; -- fnoskighet..nn.1
  fnysande_1_N : N ; -- fnysande..nn.1
  fnysning_1_N : N ; -- fnysning..nn.1
  fnöske_1_N : N ; -- fnöske..nn.1
  fnösksvamp_1_N : N ; -- fnösksvamp..nn.1
  fnöskticka_1_N : N ; -- fnö