-- This dictionary is derived from SALDO, see:
-- https://spraakbanken.gu.se/eng/resource/saldo
--
-- Original module by Malin Ahlberg has been moved to OldDictSwe.
-- Both are inherited by DictSwe, to guarantee backward compatibility.
-- This updated version with renamed identifiers is maintained by John J. Camilleri

concrete NewDictSwe of NewDictSweAbs = CatSwe ** open ParadigmsSwe in {

flags
  optimize=values ; coding=utf8 ;

lin
  A_bomb_1_N = mkN "A-bomb" "A-bomber" ; -- A-bomb..nn.1
  A_kassa_1_N = mkN "A-kassa" ; -- A-kassa..nn.1
  A_lag_1_N = mkN "A-lag" neutrum  ; -- A-lag..nn.1
  A_lagare_1_N = mkN "A-lagare" utrum  ; -- A-lagare..nn.1
  A_människa_1_N = mkN "A-människa" ; -- A-människa..nn.1
  A_vitamin_1_N = mkN "A-vitamin" "A-vitaminet" "A-vitaminer" "A-vitaminerna" ; -- A-vitamin..nn.1
  A_vitaminbrist_1_N = mkN "A-vitaminbrist" ; -- A-vitaminbrist..nn.1
  ABS_broms_1_N = mkN "ABS-broms" ; -- ABS-broms..nn.1
  ADHD_symtom_1_N = mkN "ADHD-symtom" neutrum  ; -- ADHD-symtom..nn.1
  AT_läkare_1_N = mkN "AT-läkare" utrum  ; -- AT-läkare..nn.1
  AV_block_1_N = mkN "AV-block" neutrum  ; -- AV-block..nn.1
  Administrator_1_N = mkN "Administrator" "Administratorer" ; -- Administrator..nn.1
  Afghanistaninsats_1_N = mkN "Afghanistaninsats" ; -- Afghanistaninsats..nn.1
  Afghanistantrupp_1_N = mkN "Afghanistantrupp" "Afghanistantrupper" ; -- Afghanistantrupp..nn.1
  Afrikatrad_1_N = mkN "Afrikatrad" "Afrikatrader" ; -- Afrikatrad..nn.1
  Alexanderhugg_1_N = mkN "Alexanderhugg" neutrum  ; -- Alexanderhugg..nn.1
  Alfapet_1_N = mkN "Alfapet" neutrum  ; -- Alfapet..nn.1
  Almedalental_1_N = mkN "Almedalental" neutrum  ; -- Almedalental..nn.1
  Almedalstal_1_N = mkN "Almedalstal" neutrum  ; -- Almedalstal..nn.1
  Almedalsvecka_1_N = mkN "Almedalsvecka" ; -- Almedalsvecka..nn.1
  Android_1_N = mkN "Android" "Androider" ; -- Android..nn.1
  Androidlur_1_N = mkN "Androidlur" ; -- Androidlur..nn.1
  Androidmobil_1_N = mkN "Androidmobil" "Androidmobiler" ; -- Androidmobil..nn.1
  Antarktisfördrag_1_N = mkN "Antarktisfördrag" neutrum  ; -- Antarktisfördrag..nn.1
  Antarktisprojekt_1_N = mkN "Antarktisprojekt" neutrum  ; -- Antarktisprojekt..nn.1
  Apolloprogram_1_N = mkN "Apolloprogram" "Apolloprogrammet" "Apolloprogram" "Apolloprogrammen" ; -- Apolloprogram..nn.1
  Arianeraket_1_N = mkN "Arianeraket" "Arianeraketer" ; -- Arianeraket..nn.1
  Asien_rundresa_1_N = mkN "Asien-rundresa" ; -- Asien-rundresa..nn.1
  B_lag_1_N = mkN "B-lag" neutrum  ; -- B-lag..nn.1
  B_människa_1_N = mkN "B-människa" ; -- B-människa..nn.1
  B_vitamin_1_N = mkN "B-vitamin" "B-vitaminet" "B-vitaminer" "B-vitaminerna" ; -- B-vitamin..nn.1
  B_vitaminbrist_1_N = mkN "B-vitaminbrist" "B-vitaminbrister" ; -- B-vitaminbrist..nn.1
  BLARK_1_N = mkN "BLARK" ; -- BLARK..nn.1
  BNP_tillväxt_1_N = mkN "BNP-tillväxt" ; -- BNP-tillväxt..nn.1
  Bachfuga_1_N = mkN "Bachfuga" ; -- Bachfuga..nn.1
  Ballograf_1_N = mkN "Ballograf" "Ballografer" ; -- Ballograf..nn.1
  Banverk_1_N = mkN "Banverk" neutrum  ; -- Banverk..nn.1
  Banverkspersonal_1_N = mkN "Banverkspersonal" ; -- Banverkspersonal..nn.1
  Bayeuxtapet_1_N = mkN "Bayeuxtapet" ; -- Bayeuxtapet..nn.1
  Beethovensonat_1_N = mkN "Beethovensonat" "Beethovensonater" ; -- Beethovensonat..nn.1
  Berlinmur_1_N = mkN "Berlinmur" ; -- Berlinmur..nn.1
  Bondbrud_1_N = mkN "Bondbrud" ; -- Bondbrud..nn.1
  Bondfilm_1_N = mkN "Bondfilm" "Bondfilmer" ; -- Bondfilm..nn.1
  Bonnierkoncern_1_N = mkN "Bonnierkoncern" ; -- Bonnierkoncern..nn.1
  Bristoltrakt_1_N = mkN "Bristoltrakt" ; -- Bristoltrakt..nn.1
  Bromelia_1_N = mkN "Bromelia" ; -- Bromelia..nn.1
  Brommamamma_1_N = mkN "Brommamamma" ; -- Brommamamma..nn.1
  C_dur_1_N = mkN "C-dur" ; -- C-dur..nn.1
  C_durskala_1_N = mkN "C-durskala" ; -- C-durskala..nn.1
  C_vitamin_1_N = mkN "C-vitamin" "C-vitaminet" "C-vitaminer" "C-vitaminerna" ; -- C-vitamin..nn.1
  C_vitaminbrist_1_N = mkN "C-vitaminbrist" ; -- C-vitaminbrist..nn.1
  C14_metod_1_N = mkN "C14-metod" ; -- C14-metod..nn.1
  CD_spelare_1_N = mkN "CD-spelare" utrum  ; -- CD-spelare..nn.1
  CP_skadad_1_A = mkA "CP-skadad" ; -- CP-skadad..av.1
  Calzone_1_N = mkN "Calzone" utrum  ; -- Calzone..nn.1
  Centauristjärna_1_N = mkN "Centauristjärna" ; -- Centauristjärna..nn.1
  Chicago_baserad_1_A = mkA "Chicago-baserad" ; -- Chicago-baserad..av.1
  Chicagobaserad_1_A = mkA "Chicagobaserad" ; -- Chicagobaserad..av.1
  Citroen_1_N = mkN "Citroen" "Citroener" ; -- Citroen..nn.1
  Cointreau_1_N = mkN "Cointreau" ; -- Cointreau..nn.1
  Cp_skadad_1_A = mkA "Cp-skadad" ; -- Cp-skadad..av.1
  D_vitamin_1_N = mkN "D-vitamin" "D-vitaminet" "D-vitaminer" "D-vitaminerna" ; -- D-vitamin..nn.1
  D_vitaminbrist_1_N = mkN "D-vitaminbrist" ; -- D-vitaminbrist..nn.1
  DNA_kedja_1_N = mkN "DNA-kedja" ; -- DNA-kedja..nn.1
  DNA_molekyl_1_N = mkN "DNA-molekyl" "DNA-molekyler" ; -- DNA-molekyl..nn.1
  DNA_profil_1_N = mkN "DNA-profil" "DNA-profiler" ; -- DNA-profil..nn.1
  DNA_sekvens_1_N = mkN "DNA-sekvens" "DNA-sekvenser" ; -- DNA-sekvens..nn.1
  DNA_sekvensering_1_N = mkN "DNA-sekvensering" ; -- DNA-sekvensering..nn.1
  DNA_sträng_1_N = mkN "DNA-sträng" ; -- DNA-sträng..nn.1
  DNA_test_1_N = mkN "DNA-test" neutrum  ; -- DNA-test..nn.1
  DNA_testa_1_V = mkV "DNA-testar" ; -- DNA-testa..vb.1
  DNA_testande_1_N = mkN "DNA-testande" ; -- DNA-testande..nn.1
  DNA_testning_1_N = mkN "DNA-testning" ; -- DNA-testning..nn.1
  DNA_uppsättning_1_N = mkN "DNA-uppsättning" ; -- DNA-uppsättning..nn.1
  DVD_film_1_N = mkN "DVD-film" "DVD-filmer" ; -- DVD-film..nn.1
  DVD_spelare_1_N = mkN "DVD-spelare" utrum  ; -- DVD-spelare..nn.1
  Delftporslin_1_N = mkN "Delftporslin" "Delftporslinet" "Delftporsliner" "Delftporslinerna" ; -- Delftporslin..nn.1
  DraMaten_1_N = mkN "DraMaten" ; -- DraMaten..nn.1
  Dramaten_1_N = mkN "Dramaten" ; -- Dramaten..nn.1
  Dramatenchef_1_N = mkN "Dramatenchef" "Dramatenchefer" ; -- Dramatenchef..nn.1
  Dubaifrossa_1_N = mkN "Dubaifrossa" ; -- Dubaifrossa..nn.1
  E_godkänd_1_A = mkA "E-godkänd" ; -- E-godkänd..av.1
  EHEC_smitta_1_N = mkN "EHEC-smitta" ; -- EHEC-smitta..nn.1
  EHEC_1_N = mkN "EHEC" ; -- EHEC..nn.1
  EU_intern_1_A = mkA "EU-intern" ; -- EU-intern..av.1
  EU_kommission_1_N = mkN "EU-kommission" ; -- EU-kommission..nn.1
  EU_korrespondent_1_N = mkN "EU-korrespondent" "EU-korrespondenter" ; -- EU-korrespondent..nn.1
  EU_land_1_N = mkN "EU-land" "EU-landet" "EU-länder" "EU-länderna" ; -- EU-land..nn.1
  EU_migrant_1_N = mkN "EU-migrant" "EU-migranter" ; -- EU-migrant..nn.1
  EU_minister_1_N = mkN "EU-minister" ; -- EU-minister..nn.1
  EU_parlament_1_N = mkN "EU-parlament" neutrum  ; -- EU-parlament..nn.1
  EU_parlamentariker_1_N = mkN "EU-parlamentariker" "EU-parlamentarikern" "EU-parlamentariker" "EU-parlamentarikerna" ; -- EU-parlamentariker..nn.1
  EU_skeptisk_1_A = mkA "EU-skeptisk" ; -- EU-skeptisk..av.1
  EU_utvidgning_1_N = mkN "EU-utvidgning" ; -- EU-utvidgning..nn.1
  EU_val_1_N = mkN "EU-val" neutrum  ; -- EU-val..nn.1
  Efta_land_1_N = mkN "Efta-land" "Efta-landet" "Efta-länder" "Efta-länderna" ; -- Efta-land..nn.1
  Eisenhowerepok_1_N = mkN "Eisenhowerepok" ; -- Eisenhowerepok..nn.1
  Europaparlament_1_N = mkN "Europaparlament" neutrum  ; -- Europaparlament..nn.1
  Europaråd_1_N = mkN "Europaråd" neutrum  ; -- Europaråd..nn.1
  Europarådsparlament_1_N = mkN "Europarådsparlament" neutrum  ; -- Europarådsparlament..nn.1
  Europarådsparlamentariker_1_N = mkN "Europarådsparlamentariker" "Europarådsparlamentarikern" "Europarådsparlamentariker" "Europarådsparlamentarikerna" ; -- Europarådsparlamentariker..nn.1
  Europaunion_1_N = mkN "Europaunion" ; -- Europaunion..nn.1
  FN_organ_1_N = mkN "FN-organ" neutrum  ; -- FN-organ..nn.1
  FN_tribunal_1_N = mkN "FN-tribunal" "FN-tribunaler" ; -- FN-tribunal..nn.1
  Facebookbild_1_N = mkN "Facebookbild" "Facebookbilder" ; -- Facebookbild..nn.1
  Facebookgrupp_1_N = mkN "Facebookgrupp" "Facebookgrupper" ; -- Facebookgrupp..nn.1
  Falubo_1_N = mkN "Falubo" "Falubor" ; -- Falubo..nn.1
  Fia_1_N = mkN "Fia" ; -- Fia..nn.1
  Finans_1_N = mkN "Finans" ; -- Finans..nn.1
  Fisk_1_N = mkN "Fisk" ; -- Fisk..nn.1
  Foppatoffel_1_N = mkN "Foppatoffla" ; -- Foppatoffel..nn.1
  Frankenstein_1_N = mkN "Frankenstein" ; -- Frankenstein..nn.1
  Frimurareorden_1_N = mkN "Frimurareorden" ; -- Frimurareorden..nn.1
  Frimurarorden_1_N = mkN "Frimurarorden" ; -- Frimurarorden..nn.1
  G_kraft_1_N = mkN "G-kraft" "G-krafter" ; -- G-kraft..nn.1
  G_punkt_1_N = mkN "G-punkt" "G-punkter" ; -- G-punkt..nn.1
  GPS_a_1_V = mkV "GPS-ar" ; -- GPS-a..vb.1
  GPSa_1_V = mkV "GPSar" ; -- GPSa..vb.1
  GPSa_2_V = mkV "GPS:ar" ; -- GPSa..vb.2
  Gadaffitrogen_1_A = mkA "Gadaffitrogen" ; -- Gadaffitrogen..av.1
  Gnosjöanda_1_N = mkN "Gnosjöanda" ; -- Gnosjöanda..nn.1
  Golgatavandring_1_N = mkN "Golgatavandring" ; -- Golgatavandring..nn.1
  Gotlandsfärja_1_N = mkN "Gotlandsfärja" ; -- Gotlandsfärja..nn.1
  Greenwichmeridian_1_N = mkN "Greenwichmeridian" ; -- Greenwichmeridian..nn.1
  Gripenplan_1_N = mkN "Gripenplan" neutrum  ; -- Gripenplan..nn.1
  Gävlebo_1_N = mkN "Gävlebo" "Gävlebor" ; -- Gävlebo..nn.1
  Göteborgsmålare_1_N = mkN "Göteborgsmålare" utrum  ; -- Göteborgsmålare..nn.1
  Hagasessa_1_N = mkN "Hagasessa" ; -- Hagasessa..nn.1
  Hausdorffdimension_1_N = mkN "Hausdorffdimension" ; -- Hausdorffdimension..nn.1
  Havanna_1_N = mkN "Havanna" ; -- Havanna..nn.1
  Havannacigarr_1_N = mkN "Havannacigarr" "Havannacigarrer" ; -- Havannacigarr..nn.1
  Helsingforsvän_1_N = mkN "Helsingforsvän" "Helsingforsvännen" "Helsingforsvänner" "Helsingforsvännerna" ; -- Helsingforsvän..nn.1
  Higgsboson_1_N = mkN "Higgsboson" "Higgsbosoner" ; -- Higgsboson..nn.1
  Higgspartikel_1_N = mkN "Higgspartikel" ; -- Higgspartikel..nn.1
  Hiroshimabomb_1_N = mkN "Hiroshimabomb" "Hiroshimabomber" ; -- Hiroshimabomb..nn.1
  Hitchcockfilm_1_N = mkN "Hitchcockfilm" "Hitchcockfilmer" ; -- Hitchcockfilm..nn.1
  Hollywoodfru_1_N = mkN "Hollywoodfru" ; -- Hollywoodfru..nn.1
  Hultsfredsfestival_1_N = mkN "Hultsfredsfestival" ; -- Hultsfredsfestival..nn.1
  Hårgalåt_1_N = mkN "Hårgalåt" ; -- Hårgalåt..nn.1
  I_land_1_N = mkN "I-land" "I-landet" "I-länder" "I-länderna" ; -- I-land..nn.1
  IB_avslöjande_1_N = mkN "IB-avslöjande" ; -- IB-avslöjande..nn.1
  IC_krets_1_N = mkN "IC-krets" ; -- IC-krets..nn.1
  ID_bricka_1_N = mkN "ID-bricka" ; -- ID-bricka..nn.1
  ID_kort_1_N = mkN "ID-kort" neutrum  ; -- ID-kort..nn.1
  IKEA_möbel_1_N = mkN "IKEA-möbel" "IKEA-möbeln" "IKEA-möbler" "IKEA-möblerna" ; -- IKEA-möbel..nn.1
  IP_nummer_1_N = mkN "IP-nummer" neutrum  ; -- IP-nummer..nn.1
  IT_företag_1_N = mkN "IT-företag" neutrum  ; -- IT-företag..nn.1
  IT_jätte_1_N = mkN "IT-jätte" utrum  ; -- IT-jätte..nn.1
  Ikeavaruhus_1_N = mkN "Ikeavaruhus" neutrum  ; -- Ikeavaruhus..nn.1
  Internet_1_N = mkN "Internet" ; -- Internet..nn.1
  Jacksoninspirerad_1_A = mkA "Jacksoninspirerad" ; -- Jacksoninspirerad..av.1
  Jantelag_1_N = mkN "Jantelag" ; -- Jantelag..nn.1
  Japanoro_1_N = mkN "Japanoro" ; -- Japanoro..nn.1
  Jungfru_1_N = mkN "Jungfru" "Jungfrun" "Jungfrur" "Jungfrurna" ; -- Jungfru..nn.1
  Jupitermåne_1_N = mkN "Jupitermåne" utrum  ; -- Jupitermåne..nn.1
  K_märka_1_V = mkV "K-märker" ; -- K-märka..vb.1
  K_märkande_1_N = mkN "K-märkande" ; -- K-märkande..nn.1
  KU_anmäla_1_V = mkV "KU-anmäler" ; -- KU-anmäla..vb.1
  Kafkaartad_1_A = mkA "Kafkaartad" ; -- Kafkaartad..av.1
  Kafkaesk_1_A = mkA "Kafkaesk" ; -- Kafkaesk..av.1
  Kafkalik_1_A = mkA "Kafkalik" ; -- Kafkalik..av.1
  Kafkastämning_1_N = mkN "Kafkastämning" ; -- Kafkastämning..nn.1
  Kairobesök_1_N = mkN "Kairobesök" neutrum  ; -- Kairobesök..nn.1
  Kalmarbo_1_N = mkN "Kalmarbo" "Kalmarbor" ; -- Kalmarbo..nn.1
  Karlstadsbo_1_N = mkN "Karlstadsbo" "Karlstadsbor" ; -- Karlstadsbo..nn.1
  Katynmassaker_1_N = mkN "Katynmassaker" "Katynmassakern" "Katynmassakrer" "Katynmassakrerna" ; -- Katynmassaker..nn.1
  Kevlar_1_N = mkN "Kevlar" ; -- Kevlar..nn.1
  Kinabesök_1_N = mkN "Kinabesök" neutrum  ; -- Kinabesök..nn.1
  Kirunatrakt_1_N = mkN "Kirunatrakt" ; -- Kirunatrakt..nn.1
  Kleopatragestalt_1_N = mkN "Kleopatragestalt" ; -- Kleopatragestalt..nn.1
  Koranbränning_1_N = mkN "Koranbränning" ; -- Koranbränning..nn.1
  Koranbål_1_N = mkN "Koranbål" neutrum  ; -- Koranbål..nn.1
  Koreakrig_1_N = mkN "Koreakrig" neutrum  ; -- Koreakrig..nn.1
  Kramforstrakt_1_N = mkN "Kramforstrakt" ; -- Kramforstrakt..nn.1
  Kremldirektiv_1_N = mkN "Kremldirektiv" neutrum  ; -- Kremldirektiv..nn.1
  Krimkrig_1_N = mkN "Krimkrig" neutrum  ; -- Krimkrig..nn.1
  Kräfta_2_N = mkN "Kräfta" ; -- Kräfta..nn.2
  Kubakris_1_N = mkN "Kubakris" "Kubakriser" ; -- Kubakris..nn.1
  Köchelnummer_1_N = mkN "Köchelnummer" neutrum  ; -- Köchelnummer..nn.1
  Köpenhamnsackord_1_N = mkN "Köpenhamnsackord" neutrum  ; -- Köpenhamnsackord..nn.1
  LCD_skärm_1_N = mkN "LCD-skärm" ; -- LCD-skärm..nn.1
  LCD_teve_1_N = mkN "LCD-teve" "LCD-teven" "LCD-tevear" "LCD-tevearna" ; -- LCD-teve..nn.1
  LED_belysning_1_N = mkN "LED-belysning" ; -- LED-belysning..nn.1
  LED_lampa_1_N = mkN "LED-lampa" ; -- LED-lampa..nn.1
  LKAB_konflikt_1_N = mkN "LKAB-konflikt" ; -- LKAB-konflikt..nn.1
  LO_chef_1_N = mkN "LO-chef" "LO-chefer" ; -- LO-chef..nn.1
  LO_ordförande_1_N = mkN "LO-ordförande" "LO-ordföranden" "LO-ordföranden" "LO-ordförandena" ; -- LO-ordförande..nn.1
  Lejon_1_N = mkN "Lejon" neutrum  ; -- Lejon..nn.1
  Linköpingsbo_1_N = mkN "Linköpingsbo" "Linköpingsbor" ; -- Linköpingsbo..nn.1
  Linnélärjunge_1_N = mkN "Linnélärjunge" utrum  ; -- Linnélärjunge..nn.1
  Lissabonfördrag_1_N = mkN "Lissabonfördrag" neutrum  ; -- Lissabonfördrag..nn.1
  Livsmedelsverk_1_N = mkN "Livsmedelsverk" neutrum  ; -- Livsmedelsverk..nn.1
  Ljubjankafängelse_1_N = mkN "Ljubjankafängelse" ; -- Ljubjankafängelse..nn.1
  Londonbaserad_1_A = mkA "Londonbaserad" ; -- Londonbaserad..av.1
  Lulebo_1_N = mkN "Lulebo" "Lulebor" ; -- Lulebo..nn.1
  Luleåbo_1_N = mkN "Luleåbo" "Luleåbor" ; -- Luleåbo..nn.1
  MAO_aktivitet_1_N = mkN "MAO-aktivitet" "MAO-aktiviteter" ; -- MAO-aktivitet..nn.1
  MAO_enzym_1_N = mkN "MAO-enzym" neutrum  ; -- MAO-enzym..nn.1
  MEFA_1_N = mkN "MEFA" "MEFAn" "MEFor" "MEForna" ; -- MEFA..nn.1
  MP3_bok_1_N = mkN "MP3-bok" "MP3-böcker" ; -- MP3-bok..nn.1
  MP3_spelare_1_N = mkN "MP3-spelare" utrum  ; -- MP3-spelare..nn.1
  Malmöbo_1_N = mkN "Malmöbo" "Malmöbor" ; -- Malmöbo..nn.1
  Malmökafé_1_N = mkN "Malmökafé" "Malmökaféet" "Malmökaféer" "Malmökaféerna" ; -- Malmökafé..nn.1
  Marseillebaserad_1_A = mkA "Marseillebaserad" ; -- Marseillebaserad..av.1
  Marsresa_1_N = mkN "Marsresa" ; -- Marsresa..nn.1
  Marylandaccent_1_N = mkN "Marylandaccent" "Marylandaccenter" ; -- Marylandaccent..nn.1
  Mecka_1_N = mkN "Mecka" "Meckat" "Meckan" "Meckana" ; -- Mecka..nn.1
  Medelhavsinspirerad_1_A = mkA "Medelhavsinspirerad" ; -- Medelhavsinspirerad..av.1
  Medelhavsland_1_N = mkN "Medelhavsland" "Medelhavslandet" "Medelhavsländer" "Medelhavsländerna" ; -- Medelhavsland..nn.1
  Medelshavskultur_1_N = mkN "Medelshavskultur" "Medelshavskulturer" ; -- Medelshavskultur..nn.1
  Mellanösternkonflikt_1_N = mkN "Mellanösternkonflikt" ; -- Mellanösternkonflikt..nn.1
  Mello_1_N = mkN "Mello" ; -- Mello..nn.1
  Melodifestival_1_N = mkN "Melodifestival" ; -- Melodifestival..nn.1
  Merca_1_N = mkN "Merca" ; -- Merca..nn.1
  Mercedes_1_N = mkN "Mercedes" ; -- Mercedes..nn.1
  Mersa_1_N = mkN "Mersa" ; -- Mersa..nn.1
  Metallordförande_1_N = mkN "Metallordförande" "Metallordföranden" "Metallordföranden" "Metallordförandena" ; -- Metallordförande..nn.1
  Migrationsverk_1_N = mkN "Migrationsverk" neutrum  ; -- Migrationsverk..nn.1
  Miljöförvaltning_1_N = mkN "Miljöförvaltning" ; -- Miljöförvaltning..nn.1
  Mississippiflod_1_N = mkN "Mississippiflod" ; -- Mississippiflod..nn.1
  Missouriflod_1_N = mkN "Missouriflod" ; -- Missouriflod..nn.1
  Monopol_1_N = mkN "Monopol" neutrum  ; -- Monopol..nn.1
  Montessoriskola_1_N = mkN "Montessoriskola" ; -- Montessoriskola..nn.1
  Mosebok_1_N = mkN "Mosebok" "Moseböcker" ; -- Mosebok..nn.1
  Moskvaborgmästare_1_N = mkN "Moskvaborgmästare" utrum  ; -- Moskvaborgmästare..nn.1
  Moskvatrogen_1_A = mkA "Moskvatrogen" ; -- Moskvatrogen..av.1
  Moskvatrogenhet_1_N = mkN "Moskvatrogenhet" ; -- Moskvatrogenhet..nn.1
  Moskvavänlig_1_A = mkA "Moskvavänlig" ; -- Moskvavänlig..av.1
  Moskvavänlighet_1_N = mkN "Moskvavänlighet" ; -- Moskvavänlighet..nn.1
  Moskvich_1_N = mkN "Moskvich" ; -- Moskvich..nn.1
  Moskvitj_1_N = mkN "Moskvitj" ; -- Moskvitj..nn.1
  Muhammedkarikatyr_1_N = mkN "Muhammedkarikatyr" "Muhammedkarikatyrer" ; -- Muhammedkarikatyr..nn.1
  Munchlitografi_1_N = mkN "Munchlitografi" "Munchlitografier" ; -- Munchlitografi..nn.1
  Mångfaldsbarometer_1_N = mkN "Mångfaldsbarometer" ; -- Mångfaldsbarometer..nn.1
  NSA_läcka_1_N = mkN "NSA-läcka" ; -- NSA-läcka..nn.1
  Nationalencyklopedi_1_N = mkN "Nationalencyklopedi" ; -- Nationalencyklopedi..nn.1
  Natohelikopter_1_N = mkN "Natohelikopter" ; -- Natohelikopter..nn.1
  Natoledd_1_A = mkA "Natoledd" ; -- Natoledd..av.1
  Natomedlemskap_1_N = mkN "Natomedlemskap" neutrum  ; -- Natomedlemskap..nn.1
  Natosoldat_1_N = mkN "Natosoldat" "Natosoldater" ; -- Natosoldat..nn.1
  Natotrupp_1_N = mkN "Natotrupp" "Natotrupper" ; -- Natotrupp..nn.1
  Naturvårdsverk_1_N = mkN "Naturvårdsverk" neutrum  ; -- Naturvårdsverk..nn.1
  Newcastlesjuka_1_N = mkN "Newcastlesjuka" ; -- Newcastlesjuka..nn.1
  Newcastlesmitta_1_N = mkN "Newcastlesmitta" ; -- Newcastlesmitta..nn.1
  Nobelpriskandidat_1_N = mkN "Nobelpriskandidat" "Nobelpriskandidater" ; -- Nobelpriskandidat..nn.1
  Nordpolsexpedition_1_N = mkN "Nordpolsexpedition" ; -- Nordpolsexpedition..nn.1
  Norrmalmstorgssyndrom_1_N = mkN "Norrmalmstorgssyndrom" neutrum  ; -- Norrmalmstorgssyndrom..nn.1
  OCR_a_1_V = mkV "OCR-ar" ; -- OCR-a..vb.1
  OCR_ande_1_N = mkN "OCR-ande" ; -- OCR-ande..nn.1
  OCRa_1_V = mkV "OCR:ar" ; -- OCRa..vb.1
  OCRande_1_N = mkN "OCR:ande" ; -- OCRande..nn.1
  OECD_land_1_N = mkN "OECD-land" "OECD-landet" "OECD-länder" "OECD-länderna" ; -- OECD-land..nn.1
  OK_1_A = mkA "OK" ; -- OK..av.1
  Oscarsbelönad_1_A = mkA "Oscarsbelönad" ; -- Oscarsbelönad..av.1
  Oscarsnominerad_1_A = mkA "Oscarsnominerad" ; -- Oscarsnominerad..av.1
  Osloavtal_1_N = mkN "Osloavtal" neutrum  ; -- Osloavtal..nn.1
  Othello_1_N = mkN "Othello" ; -- Othello..nn.1
  Oxe_1_N = mkN "Oxe" utrum  ; -- Oxe..nn.1
  Oxfordkommatering_1_N = mkN "Oxfordkommatering" ; -- Oxfordkommatering..nn.1
  Oxfordstudent_1_N = mkN "Oxfordstudent" "Oxfordstudenter" ; -- Oxfordstudent..nn.1
  PCB_förbud_1_N = mkN "PCB-förbud" neutrum  ; -- PCB-förbud..nn.1
  PCB_förening_1_N = mkN "PCB-förening" ; -- PCB-förening..nn.1
  PCB_förgiftning_1_N = mkN "PCB-förgiftning" ; -- PCB-förgiftning..nn.1
  PCB_halt_1_N = mkN "PCB-halt" "PCB-halter" ; -- PCB-halt..nn.1
  PCB_olja_1_N = mkN "PCB-olja" ; -- PCB-olja..nn.1
  PIN_kod_1_N = mkN "PIN-kod" "PIN-koder" ; -- PIN-kod..nn.1
  PR_kupp_1_N = mkN "PR-kupp" "PR-kupper" ; -- PR-kupp..nn.1
  PR_man_1_N = mkN "PR-man" "PR-mannen" "PR-män" "PR-männen" ; -- PR-man..nn.1
  PRkupp_1_N = mkN "PRkupp" "PRkupper" ; -- PRkupp..nn.1
  PVC_beläggning_1_N = mkN "PVC-beläggning" ; -- PVC-beläggning..nn.1
  Palestinafråga_1_N = mkN "Palestinafråga" ; -- Palestinafråga..nn.1
  Palmehat_1_N = mkN "Palmehat" neutrum  ; -- Palmehat..nn.1
  Papyrusaktie_1_N = mkN "Papyrusaktie" "Papyrusaktier" ; -- Papyrusaktie..nn.1
  Parisflygplats_1_N = mkN "Parisflygplats" "Parisflygplatser" ; -- Parisflygplats..nn.1
  Patentverk_1_N = mkN "Patentverk" neutrum  ; -- Patentverk..nn.1
  Pippiinspirerad_1_A = mkA "Pippiinspirerad" ; -- Pippiinspirerad..av.1
  PowerPoint_1_N = mkN "PowerPoint" ; -- PowerPoint..nn.1
  Powerpoint_1_N = mkN "Powerpoint" ; -- Powerpoint..nn.1
  QR_kod_1_N = mkN "QR-kod" "QR-koder" ; -- QR-kod..nn.1
  ROT_avdrag_1_N = mkN "ROT-avdrag" neutrum  ; -- ROT-avdrag..nn.1
  RUT_avdrag_1_N = mkN "RUT-avdrag" neutrum  ; -- RUT-avdrag..nn.1
  Rembrandt_1_N = mkN "Rembrandt" "Rembrandter" ; -- Rembrandt..nn.1
  Rikspolisstyrelse_1_N = mkN "Rikspolisstyrelse" utrum  ; -- Rikspolisstyrelse..nn.1
  Rioja_1_N = mkN "Rioja" ; -- Rioja..nn.1
  Risk_1_N = mkN "Risk" ; -- Risk..nn.1
  Rolls_1_N = mkN "Rolls" ; -- Rolls..nn.1
  Romeo_och_Julia_strategi_1_N = mkN "Romeo-och-Julia-strategi" "Romeo-och-Julia-strategier" ; -- Romeo-och-Julia-strategi..nn.1
  SAP_program_1_N = mkN "SAP-program" "SAP-programmet" "SAP-program" "SAP-programmen" ; -- SAP-program..nn.1
  SAS_chef_1_N = mkN "SAS-chef" "SAS-chefer" ; -- SAS-chef..nn.1
  SAS_flygvärdinna_1_N = mkN "SAS-flygvärdinna" ; -- SAS-flygvärdinna..nn.1
  SCOPE_rapport_1_N = mkN "SCOPE-rapport" "SCOPE-rapporter" ; -- SCOPE-rapport..nn.1
  SIFO_undersökning_1_N = mkN "SIFO-undersökning" ; -- SIFO-undersökning..nn.1
  SIM_kort_1_N = mkN "SIM-kort" neutrum  ; -- SIM-kort..nn.1
  SMSa_1_V = mkV "SMS:ar" ; -- SMSa..vb.1
  Saab_1_N = mkN "Saab" ; -- Saab..nn.1
  Salazar_regim_1_N = mkN "Salazar-regim" "Salazar-regimer" ; -- Salazar-regim..nn.1
  Shakespearedrama_1_N = mkN "Shakespearedrama" "Shakespearedramat" "Shakespearedramer" "Shakespearedramerna" ; -- Shakespearedrama..nn.1
  Sheratonstil_1_N = mkN "Sheratonstil" ; -- Sheratonstil..nn.1
  Sifoundersökning_1_N = mkN "Sifoundersökning" ; -- Sifoundersökning..nn.1
  Sir_1_N = mkN "Sir" ; -- Sir..nn.1
  Sjöfartsverk_1_N = mkN "Sjöfartsverk" neutrum  ; -- Sjöfartsverk..nn.1
  Skagenmålare_1_N = mkN "Skagenmålare" utrum  ; -- Skagenmålare..nn.1
  Skolinspektion_1_N = mkN "Skolinspektion" ; -- Skolinspektion..nn.1
  Skolverk_1_N = mkN "Skolverk" neutrum  ; -- Skolverk..nn.1
  Skorpion_1_N = mkN "Skorpion" ; -- Skorpion..nn.1
  Skytt_1_N = mkN "Skytt" ; -- Skytt..nn.1
  Sokratesdialog_1_N = mkN "Sokratesdialog" "Sokratesdialoger" ; -- Sokratesdialog..nn.1
  Sovjetsystem_1_N = mkN "Sovjetsystem" neutrum  ; -- Sovjetsystem..nn.1
  Stadsbyggnadskontor_1_N = mkN "Stadsbyggnadskontor" neutrum  ; -- Stadsbyggnadskontor..nn.1
  Stasiagent_1_N = mkN "Stasiagent" "Stasiagenter" ; -- Stasiagent..nn.1
  Stasianställd_1_A = mkA "Stasianställd" "Stasianställt" ; -- Stasianställd..av.1
  Statoilmack_1_N = mkN "Statoilmack" ; -- Statoilmack..nn.1
  Statskontor_1_N = mkN "Statskontor" neutrum  ; -- Statskontor..nn.1
  Stenbock_1_N = mkN "Stenbock" ; -- Stenbock..nn.1
  Stillahavsfiske_1_N = mkN "Stillahavsfiske" ; -- Stillahavsfiske..nn.1
  Stillahavsskvadron_1_N = mkN "Stillahavsskvadron" "Stillahavsskvadroner" ; -- Stillahavsskvadron..nn.1
  Stockholmsarena_1_N = mkN "Stockholmsarena" ; -- Stockholmsarena..nn.1
  Stockholmsbörs_1_N = mkN "Stockholmsbörs" ; -- Stockholmsbörs..nn.1
  Stockholmsfotograf_1_N = mkN "Stockholmsfotograf" "Stockholmsfotografer" ; -- Stockholmsfotograf..nn.1
  Stockholmsguide_1_N = mkN "Stockholmsguide" "Stockholmsguider" ; -- Stockholmsguide..nn.1
  Stockholmshelg_1_N = mkN "Stockholmshelg" "Stockholmshelger" ; -- Stockholmshelg..nn.1
  Stockholmsmässig_1_A = mkA "Stockholmsmässig" ; -- Stockholmsmässig..av.1
  Stockholmsområde_1_N = mkN "Stockholmsområde" ; -- Stockholmsområde..nn.1
  Stockholmsregion_1_N = mkN "Stockholmsregion" ; -- Stockholmsregion..nn.1
  Stockholmssyndrom_1_N = mkN "Stockholmssyndrom" neutrum  ; -- Stockholmssyndrom..nn.1
  Stockholmstrakt_1_N = mkN "Stockholmstrakt" ; -- Stockholmstrakt..nn.1
  Strindbergsutgåva_1_N = mkN "Strindbergsutgåva" ; -- Strindbergsutgåva..nn.1
  Strålsäkerhetsmyndighet_1_N = mkN "Strålsäkerhetsmyndighet" ; -- Strålsäkerhetsmyndighet..nn.1
  Sturemord_1_N = mkN "Sturemord" neutrum  ; -- Sturemord..nn.1
  Stureplansmördare_1_N = mkN "Stureplansmördare" utrum  ; -- Stureplansmördare..nn.1
  Stureplansprofil_1_N = mkN "Stureplansprofil" "Stureplansprofiler" ; -- Stureplansprofil..nn.1
  Sundsvallsbo_1_N = mkN "Sundsvallsbo" "Sundsvallsbor" ; -- Sundsvallsbo..nn.1
  Svensson_1_N = mkN "Svensson" "Svenssöner" ; -- Svensson..nn.1
  Sverigedemokrat_1_N = mkN "Sverigedemokrat" "Sverigedemokrater" ; -- Sverigedemokrat..nn.1
  Sverigemästerskap_1_N = mkN "Sverigemästerskap" neutrum  ; -- Sverigemästerskap..nn.1
  Södermalmsbo_1_N = mkN "Södermalmsbo" "Södermalmsbor" ; -- Södermalmsbo..nn.1
  Södermalmvåning_1_N = mkN "Södermalmvåning" ; -- Södermalmvåning..nn.1
  T_shirt_1_N = mkN "T-shirt" ; -- T-shirt..nn.1
  T_sprit_1_N = mkN "T-sprit" ; -- T-sprit..nn.1
  T_tröja_1_N = mkN "T-tröja" ; -- T-tröja..nn.1
  TV_abonnemang_1_N = mkN "TV-abonnemang" neutrum  ; -- TV-abonnemang..nn.1
  TV_antenn_1_N = mkN "TV-antenn" "TV-antenner" ; -- TV-antenn..nn.1
  TV_apparat_1_N = mkN "TV-apparat" "TV-apparater" ; -- TV-apparat..nn.1
  TV_bild_1_N = mkN "TV-bild" "TV-bilder" ; -- TV-bild..nn.1
  TV_chef_1_N = mkN "TV-chef" "TV-chefer" ; -- TV-chef..nn.1
  TV_evangelist_1_N = mkN "TV-evangelist" "TV-evangelister" ; -- TV-evangelist..nn.1
  TV_intervju_1_N = mkN "TV-intervju" "TV-intervjun" "TV-intervjuer" "TV-intervjuerna" ; -- TV-intervju..nn.1
  TV_kamera_1_N = mkN "TV-kamera" ; -- TV-kamera..nn.1
  TV_kanal_1_N = mkN "TV-kanal" "TV-kanaler" ; -- TV-kanal..nn.1
  TV_konferens_1_N = mkN "TV-konferens" "TV-konferenser" ; -- TV-konferens..nn.1
  TV_leverantör_1_N = mkN "TV-leverantör" "TV-leverantörer" ; -- TV-leverantör..nn.1
  TV_mast_1_N = mkN "TV-mast" "TV-master" ; -- TV-mast..nn.1
  TV_meteorolog_1_N = mkN "TV-meteorolog" "TV-meteorologer" ; -- TV-meteorolog..nn.1
  TV_mottagare_1_N = mkN "TV-mottagare" utrum  ; -- TV-mottagare..nn.1
  TV_nyhet_1_N = mkN "TV-nyhet" "TV-nyheter" ; -- TV-nyhet..nn.1
  TV_predikant_1_N = mkN "TV-predikant" "TV-predikanter" ; -- TV-predikant..nn.1
  TV_producent_1_N = mkN "TV-producent" "TV-producenter" ; -- TV-producent..nn.1
  TV_profil_1_N = mkN "TV-profil" "TV-profiler" ; -- TV-profil..nn.1
  TV_program_1_N = mkN "TV-program" "TV-programmet" "TV-program" "TV-programmen" ; -- TV-program..nn.1
  TV_reklam_1_N = mkN "TV-reklam" ; -- TV-reklam..nn.1
  TV_reparatör_1_N = mkN "TV-reparatör" "TV-reparatörer" ; -- TV-reparatör..nn.1
  TV_ruta_1_N = mkN "TV-ruta" ; -- TV-ruta..nn.1
  TV_serie_1_N = mkN "TV-serie" "TV-serier" ; -- TV-serie..nn.1
  TV_signal_1_N = mkN "TV-signal" "TV-signaler" ; -- TV-signal..nn.1
  TV_skärm_1_N = mkN "TV-skärm" ; -- TV-skärm..nn.1
  TV_soffa_1_N = mkN "TV-soffa" ; -- TV-soffa..nn.1
  TV_studio_1_N = mkN "TV-studio" "TV-studior" ; -- TV-studio..nn.1
  TV_sändare_1_N = mkN "TV-sändare" utrum  ; -- TV-sändare..nn.1
  TV_sändning_1_N = mkN "TV-sändning" ; -- TV-sändning..nn.1
  TV_såpa_1_N = mkN "TV-såpa" ; -- TV-såpa..nn.1
  TV_tittande_1_N = mkN "TV-tittande" ; -- TV-tittande..nn.1
  TV_tittare_1_N = mkN "TV-tittare" utrum  ; -- TV-tittare..nn.1
  TV_övervakning_1_N = mkN "TV-övervakning" ; -- TV-övervakning..nn.1
  Tarzanfilm_1_N = mkN "Tarzanfilm" "Tarzanfilmer" ; -- Tarzanfilm..nn.1
  Telialand_1_N = mkN "Telialand" neutrum  ; -- Telialand..nn.1
  Teutoburgerslag_1_N = mkN "Teutoburgerslag" neutrum  ; -- Teutoburgerslag..nn.1
  Tjernobylnedfall_1_N = mkN "Tjernobylnedfall" neutrum  ; -- Tjernobylnedfall..nn.1
  Tjernobylolycka_1_N = mkN "Tjernobylolycka" ; -- Tjernobylolycka..nn.1
  Tokyobörs_1_N = mkN "Tokyobörs" ; -- Tokyobörs..nn.1
  Trafikkontor_1_N = mkN "Trafikkontor" neutrum  ; -- Trafikkontor..nn.1
  Trafiksäkerhetsverk_1_N = mkN "Trafiksäkerhetsverk" neutrum  ; -- Trafiksäkerhetsverk..nn.1
  Tvilling_1_N = mkN "Tvilling" ; -- Tvilling..nn.1
  Törnrosasömn_1_N = mkN "Törnrosasömn" ; -- Törnrosasömn..nn.1
  U_land_1_N = mkN "U-land" "U-landet" "U-länder" "U-länderna" ; -- U-land..nn.1
  U_sväng_1_N = mkN "U-sväng" ; -- U-sväng..nn.1
  USA_vänlig_1_A = mkA "USA-vänlig" ; -- USA-vänlig..av.1
  USA_vänlighet_1_N = mkN "USA-vänlighet" ; -- USA-vänlighet..nn.1
  USB_minne_1_N = mkN "USB-minne" ; -- USB-minne..nn.1
  USB_sladd_1_N = mkN "USB-sladd" ; -- USB-sladd..nn.1
  Uno_1_N = mkN "Uno" ; -- Uno..nn.1
  Uppsalabo_1_N = mkN "Uppsalabo" "Uppsalabor" ; -- Uppsalabo..nn.1
  VAB_dag_1_N = mkN "VAB-dag" ; -- VAB-dag..nn.1
  VAB_1_N = mkN "VAB" ; -- VAB..nn.1
  VABB_dag_1_N = mkN "VABB-dag" ; -- VABB-dag..nn.1
  VABB_1_N = mkN "VABB" ; -- VABB..nn.1
  VVS_armatur_1_N = mkN "VVS-armatur" "VVS-armaturer" ; -- VVS-armatur..nn.1
  Vadstenadiarium_1_N = mkN "Vadstenadiarium" "Vadstenadiariet" "Vadstenadiarier" "Vadstenadiarierna" ; -- Vadstenadiarium..nn.1
  Vattuman_1_N = mkN "Vattuman" "Vattumannen" "Vattumän" "Vattumännen" ; -- Vattuman..nn.1
  Vaxholmskonflikt_1_N = mkN "Vaxholmskonflikt" ; -- Vaxholmskonflikt..nn.1
  Vellingemoderat_1_N = mkN "Vellingemoderat" "Vellingemoderater" ; -- Vellingemoderat..nn.1
  Viagra_1_N = mkN "Viagra" ; -- Viagra..nn.1
  Vietnamkrig_1_N = mkN "Vietnamkrig" neutrum  ; -- Vietnamkrig..nn.1
  Vietnampolitik_1_N = mkN "Vietnampolitik" ; -- Vietnampolitik..nn.1
  Vietnamveteran_1_N = mkN "Vietnamveteran" "Vietnamveteraner" ; -- Vietnamveteran..nn.1
  Visa_kort_1_N = mkN "Visa-kort" neutrum  ; -- Visa-kort..nn.1
  Visakort_1_N = mkN "Visakort" neutrum  ; -- Visakort..nn.1
  Visbyvecka_1_N = mkN "Visbyvecka" ; -- Visbyvecka..nn.1
  Volkswagenbuss_1_N = mkN "Volkswagenbuss" ; -- Volkswagenbuss..nn.1
  Volvo_1_N = mkN "Volvo" ; -- Volvo..nn.1
  Volvoanställd_1_A = mkA "Volvoanställd" "Volvoanställt" ; -- Volvoanställd..av.1
  Vädur_1_N = mkN "Vädur" ; -- Vädur..nn.1
  Vägverk_1_N = mkN "Vägverk" neutrum  ; -- Vägverk..nn.1
  Världsbank_1_N = mkN "Världsbank" ; -- Världsbank..nn.1
  Världsnaturfond_1_N = mkN "Världsnaturfond" ; -- Världsnaturfond..nn.1
  Vätternrunda_1_N = mkN "Vätternrunda" ; -- Vätternrunda..nn.1
  Växjötrakt_1_N = mkN "Växjötrakt" ; -- Växjötrakt..nn.1
  Våg_1_N = mkN "Våg" "Vågor" ; -- Våg..nn.1
  X_formad_1_A = mkA "X-formad" ; -- X-formad..av.1
  X_formig_1_A = mkA "X-formig" ; -- X-formig..av.1
  X_kromosom_1_N = mkN "X-kromosom" "X-kromosomer" ; -- X-kromosom..nn.1
  Xformad_1_A = mkA "Xformad" ; -- Xformad..av.1
  Xformig_1_A = mkA "Xformig" ; -- Xformig..av.1
  Y_kromosom_1_N = mkN "Y-kromosom" "Y-kromosomer" ; -- Y-kromosom..nn.1
  Yalelås_1_N = mkN "Yalelås" neutrum  ; -- Yalelås..nn.1
  Yatzy_1_N = mkN "Yatzy" ; -- Yatzy..nn.1
  Z_partikel_1_N = mkN "Z-partikel" ; -- Z-partikel..nn.1
  Zlatan_groda_1_N = mkN "Zlatan-groda" ; -- Zlatan-groda..nn.1
  _00_tal_1_N = mkN "00-tal" neutrum  ; -- _00-tal..nn.1
  _1100_tal_1_N = mkN "1100-tal" neutrum  ; -- _1100-tal..nn.1
  _12_kanthylsa_1_N = mkN "12-kanthylsa" ; -- _12-kanthylsa..nn.1
  _12_kantshylsa_1_N = mkN "12-kantshylsa" ; -- _12-kantshylsa..nn.1
  _1200_tal_1_N = mkN "1200-tal" neutrum  ; -- _1200-tal..nn.1
  _1300_tal_1_N = mkN "1300-tal" neutrum  ; -- _1300-tal..nn.1
  _1400_tal_1_N = mkN "1400-tal" neutrum  ; -- _1400-tal..nn.1
  _15_årsstraff_1_N = mkN "15-årsstraff" neutrum  ; -- _15-årsstraff..nn.1
  _1500_tal_1_N = mkN "1500-tal" neutrum  ; -- _1500-tal..nn.1
  _1600_tal_1_N = mkN "1600-tal" neutrum  ; -- _1600-tal..nn.1
  _1700_tal_1_N = mkN "1700-tal" neutrum  ; -- _1700-tal..nn.1
  _1800_tal_1_N = mkN "1800-tal" neutrum  ; -- _1800-tal..nn.1
  _1800_talsmode_1_N = mkN "1800-talsmode" ; -- _1800-talsmode..nn.1
  _1870_tal_1_N = mkN "1870-tal" neutrum  ; -- _1870-tal..nn.1
  _1880_tal_1_N = mkN "1880-tal" neutrum  ; -- _1880-tal..nn.1
  _1890_tal_1_N = mkN "1890-tal" neutrum  ; -- _1890-tal..nn.1
  _1900_tal_1_N = mkN "1900-tal" neutrum  ; -- _1900-tal..nn.1
  _1910_tal_1_N = mkN "1910-tal" neutrum  ; -- _1910-tal..nn.1
  _1920_tal_1_N = mkN "1920-tal" neutrum  ; -- _1920-tal..nn.1
  _1930_tal_1_N = mkN "1930-tal" neutrum  ; -- _1930-tal..nn.1
  _1940_tal_1_N = mkN "1940-tal" neutrum  ; -- _1940-tal..nn.1
  _1950_tal_1_N = mkN "1950-tal" neutrum  ; -- _1950-tal..nn.1
  _1960_tal_1_N = mkN "1960-tal" neutrum  ; -- _1960-tal..nn.1
  _1970_tal_1_N = mkN "1970-tal" neutrum  ; -- _1970-tal..nn.1
  _1980_tal_1_N = mkN "1980-tal" neutrum  ; -- _1980-tal..nn.1
  _1990_tal_1_N = mkN "1990-tal" neutrum  ; -- _1990-tal..nn.1
  _2_taktsolja_1_N = mkN "2-taktsolja" ; -- _2-taktsolja..nn.1
  _20_tal_1_N = mkN "20-tal" neutrum  ; -- _20-tal..nn.1
  _2000_tal_1_N = mkN "2000-tal" neutrum  ; -- _2000-tal..nn.1
  _3_fasström_1_N = mkN "3-fasström" "3-fasströmmen" "3-fasströmmar" "3-fasströmmarna" ; -- _3-fasström..nn.1
  _30_tal_1_N = mkN "30-tal" neutrum  ; -- _30-tal..nn.1
  _40_tal_1_N = mkN "40-tal" neutrum  ; -- _40-tal..nn.1
  _40_åring_1_N = mkN "40-åring" ; -- _40-åring..nn.1
  _5_armad_1_A = mkA "5-armad" ; -- _5-armad..av.1
  _5_punktslaser_1_N = mkN "5-punktslaser" ; -- _5-punktslaser..nn.1
  _50_tal_1_N = mkN "50-tal" neutrum  ; -- _50-tal..nn.1
  _50_talsinspirerad_1_A = mkA "50-talsinspirerad" ; -- _50-talsinspirerad..av.1
  _60_tal_1_N = mkN "60-tal" neutrum  ; -- _60-tal..nn.1
  _60_årsjubileum_1_N = mkN "60-årsjubileum" "60-årsjubileet" "60-årsjubileer" "60-årsjubileerna" ; -- _60-årsjubileum..nn.1
  _7_armad_1_A = mkA "7-armad" ; -- _7-armad..av.1
  _70_tal_1_N = mkN "70-tal" neutrum  ; -- _70-tal..nn.1
  _80_tal_1_N = mkN "80-tal" neutrum  ; -- _80-tal..nn.1
  _90_tal_1_N = mkN "90-tal" neutrum  ; -- _90-tal..nn.1
  _95_oktanig_1_A = mkA "95-oktanig" ; -- _95-oktanig..av.1
  a_bomb_1_N = mkN "a-bomb" "a-bomber" ; -- a-bomb..nn.1
  a_kassa_1_N = mkN "a-kassa" ; -- a-kassa..nn.1
  a_vitaminbrist_1_N = mkN "a-vitaminbrist" ; -- a-vitaminbrist..nn.1
  abakus_1_N = mkN "abakus" "abakuser" ; -- abakus..nn.1
  abalone_1_N = mkN "abalone" "abaloner" ; -- abalone..nn.1
  abandon_1_N = mkN "abandon" ; -- abandon..nn.1
  abbedissa_1_N = mkN "abbedissa" ; -- abbedissa..nn.1
  abborre_1_N = mkN "abborre" utrum  ; -- abborre..nn.1
  abborrfisk_1_N = mkN "abborrfisk" ; -- abborrfisk..nn.1
  abborrliknande_1_A = mkA "abborrliknande" ; -- abborrliknande..av.1
  abborrpinne_1_N = mkN "abborrpinne" utrum  ; -- abborrpinne..nn.1
  abbot_1_N = mkN "abbot" ; -- abbot..nn.1
  abbotlig_1_A = mkA "abbotlig" ; -- abbotlig..av.1
  abbotskap_1_N = mkN "abbotskap" neutrum  ; -- abbotskap..nn.1
  abbotskloster_1_N = mkN "abbotskloster" neutrum  ; -- abbotskloster..nn.1
  abbotsstav_1_N = mkN "abbotsstav" ; -- abbotsstav..nn.1
  abbotsstift_1_N = mkN "abbotsstift" neutrum  ; -- abbotsstift..nn.1
  abbotsvärdighet_1_N = mkN "abbotsvärdighet" ; -- abbotsvärdighet..nn.1
  abbreviation_1_N = mkN "abbreviation" ; -- abbreviation..nn.1
  abbreviatur_1_N = mkN "abbreviatur" "abbreviaturer" ; -- abbreviatur..nn.1
  abbreviera_1_V = mkV "abbrevierar" ; -- abbreviera..vb.1
  abbrevierande_1_N = mkN "abbrevierande" ; -- abbrevierande..nn.1
  abbrevierbar_1_A = mkA "abbrevierbar" ; -- abbrevierbar..av.1
  abbrevierbarhet_1_N = mkN "abbrevierbarhet" ; -- abbrevierbarhet..nn.1
  abbreviering_1_N = mkN "abbreviering" ; -- abbreviering..nn.1
  abbé_1_N = mkN "abbé" "abbéer" ; -- abbé..nn.1
  abc_bok_1_N = mkN "abc-bok" "abc-böcker" ; -- abc-bok..nn.1
  abchazisk_1_A = mkA "abchazisk" ; -- abchazisk..av.1
  abderitisk_1_A = mkA "abderitisk" ; -- abderitisk..av.1
  abdikation_1_N = mkN "abdikation" ; -- abdikation..nn.1
  abdikationsakt_1_N = mkN "abdikationsakt" "abdikationsakter" ; -- abdikationsakt..nn.1
  abdikationshot_1_N = mkN "abdikationshot" neutrum  ; -- abdikationshot..nn.1
  abdikera_1_V = mkV "abdikerar" ; -- abdikera..vb.1
  abdikerande_1_N = mkN "abdikerande" ; -- abdikerande..nn.1
  abdikerbar_1_A = mkA "abdikerbar" ; -- abdikerbar..av.1
  abdikerbarhet_1_N = mkN "abdikerbarhet" ; -- abdikerbarhet..nn.1
  abdikering_1_N = mkN "abdikering" ; -- abdikering..nn.1
  abdomen_1_N = mkN "abdomen" "abdomen" "abdomen" "abdomen" ; -- abdomen..nn.1
  abdominal_1_A = mkA "abdominal" ; -- abdominal..av.1
  abducensnervsjukdom_1_N = mkN "abducensnervsjukdom" ; -- abducensnervsjukdom..nn.1
  abducensnervskada_1_N = mkN "abducensnervskada" ; -- abducensnervskada..nn.1
  aber_1_N = mkN "aber" neutrum  ; -- aber..nn.1
  aberration_1_N = mkN "aberration" ; -- aberration..nn.1
  abessinier_1_N = mkN "abessinier" "abessiniern" "abessinier" "abessinierna" ; -- abessinier..nn.1
  abessinsk_1_A = mkA "abessinsk" ; -- abessinsk..av.1
  abessinska_1_N = mkN "abessinska" ; -- abessinska..nn.1
  abessiv_1_N = mkN "abessiv" "abessiver" ; -- abessiv..nn.1
  abetalipoproteinemi_1_N = mkN "abetalipoproteinemi" ; -- abetalipoproteinemi..nn.1
  abilitet_1_N = mkN "abilitet" "abiliteter" ; -- abilitet..nn.1
  abiturient_1_N = mkN "abiturient" "abiturienter" ; -- abiturient..nn.1
  abiturientexamen_1_N = mkN "abiturientexamen" "abiturientexamen" "abiturientexamina" "abiturientexamina" ; -- abiturientexamen..nn.1
  ablation_1_N = mkN "ablation" ; -- ablation..nn.1
  ablativ_1_N = mkN "ablativ" "ablativer" ; -- ablativ..nn.1
  ablativform_1_N = mkN "ablativform" "ablativformer" ; -- ablativform..nn.1
  abnorm_1_A = mkA "abnorm" ; -- abnorm..av.1
  abnormalitet_1_N = mkN "abnormalitet" "abnormaliteter" ; -- abnormalitet..nn.1
  abnormitet_1_N = mkN "abnormitet" "abnormiteter" ; -- abnormitet..nn.1
  abolition_1_N = mkN "abolition" ; -- abolition..nn.1
  abolitionist_1_N = mkN "abolitionist" "abolitionister" ; -- abolitionist..nn.1
  abolitionistisk_1_A = mkA "abolitionistisk" ; -- abolitionistisk..av.1
  abominabel_1_A = mkA "abominabel" ; -- abominabel..av.1
  abonnemang_1_N = mkN "abonnemang" neutrum  ; -- abonnemang..nn.1
  abonnemangspris_1_N = mkN "abonnemangspris" "abonnemangspriser" ; -- abonnemangspris..nn.1
  abonnent_1_N = mkN "abonnent" "abonnenter" ; -- abonnent..nn.1
  abonnera_1_V = mkV "abonnerar" ; -- abonnera..vb.1
  abonnerande_1_N = mkN "abonnerande" ; -- abonnerande..nn.1
  abonnerbar_1_A = mkA "abonnerbar" ; -- abonnerbar..av.1
  abonnerbarhet_1_N = mkN "abonnerbarhet" ; -- abonnerbarhet..nn.1
  abonnering_1_N = mkN "abonnering" ; -- abonnering..nn.1
  aborigin_1_N = mkN "aborigin" "aboriginer" ; -- aborigin..nn.1
  aboriginer_1_N = mkN "aboriginer" "aboriginern" "aboriginer" "aboriginerna" ; -- aboriginer..nn.1
  aboriginsk_1_A = mkA "aboriginsk" ; -- aboriginsk..av.1
  aborre_1_N = mkN "aborre" utrum  ; -- aborre..nn.1
  abort_1_N = mkN "abort" "aborter" ; -- abort..nn.1
  abortera_1_V = mkV "aborterar" ; -- abortera..vb.1
  aborterande_1_N = mkN "aborterande" ; -- aborterande..nn.1
  aborterbar_1_A = mkA "aborterbar" ; -- aborterbar..av.1
  aborterbarhet_1_N = mkN "aborterbarhet" ; -- aborterbarhet..nn.1
  abortering_1_N = mkN "abortering" ; -- abortering..nn.1
  abortfråga_1_N = mkN "abortfråga" ; -- abortfråga..nn.1
  abortiv_1_A = mkA "abortiv" ; -- abortiv..av.1
  abortmotstånd_1_N = mkN "abortmotstånd" neutrum  ; -- abortmotstånd..nn.1
  abortmotståndare_1_N = mkN "abortmotståndare" utrum  ; -- abortmotståndare..nn.1
  abortpiller_1_N = mkN "abortpiller" neutrum  ; -- abortpiller..nn.1
  aborträtt_1_N = mkN "aborträtt" "aborträtter" ; -- aborträtt..nn.1
  abortrådgivning_1_N = mkN "abortrådgivning" ; -- abortrådgivning..nn.1
  abortrådgivning_2_N = mkN "abortrådgivning" ; -- abortrådgivning..nn.2
  abortör_1_N = mkN "abortör" "abortörer" ; -- abortör..nn.1
  abradera_1_V = mkV "abraderar" ; -- abradera..vb.1
  abraderande_1_N = mkN "abraderande" ; -- abraderande..nn.1
  abraderbar_1_A = mkA "abraderbar" ; -- abraderbar..av.1
  abraderbarhet_1_N = mkN "abraderbarhet" ; -- abraderbarhet..nn.1
  abradering_1_N = mkN "abradering" ; -- abradering..nn.1
  abrasion_1_N = mkN "abrasion" ; -- abrasion..nn.1
  abrovink_1_N = mkN "abrovink" "abrovinker" ; -- abrovink..nn.1
  abrovinsch_1_N = mkN "abrovinsch" "abrovinscher" ; -- abrovinsch..nn.1
  abrupt_1_A = mkA "abrupt" "abrupt" ; -- abrupt..av.1
  abrupthet_1_N = mkN "abrupthet" ; -- abrupthet..nn.1
  abscess_1_N = mkN "abscess" "abscesser" ; -- abscess..nn.1
  abscessbildning_1_N = mkN "abscessbildning" ; -- abscessbildning..nn.1
  absens_1_N = mkN "absens" "absenser" ; -- absens..nn.1
  absensepilepsi_1_N = mkN "absensepilepsi" ; -- absensepilepsi..nn.1
  absid_1_N = mkN "absid" "absider" ; -- absid..nn.1
  absint_1_N = mkN "absint" "absinter" ; -- absint..nn.1
  abskissa_1_N = mkN "abskissa" ; -- abskissa..nn.1
  absolut_1_A = mkA "absolut" "absolut" ; -- absolut..av.1
  absolutbelopp_1_N = mkN "absolutbelopp" neutrum  ; -- absolutbelopp..nn.1
  absoluthet_1_N = mkN "absoluthet" ; -- absoluthet..nn.1
  absolution_1_N = mkN "absolution" ; -- absolution..nn.1
  absolutism_1_N = mkN "absolutism" "absolutismer" ; -- absolutism..nn.1
  absolutist_1_N = mkN "absolutist" "absolutister" ; -- absolutist..nn.1
  absolutistisk_1_A = mkA "absolutistisk" ; -- absolutistisk..av.1
  absolutiv_1_N = mkN "absolutiv" "absolutiver" ; -- absolutiv..nn.1
  absolutivobjekt_1_N = mkN "absolutivobjekt" neutrum  ; -- absolutivobjekt..nn.1
  absolutivsubjekt_1_N = mkN "absolutivsubjekt" neutrum  ; -- absolutivsubjekt..nn.1
  absolvera_1_V = mkV "absolverar" ; -- absolvera..vb.1
  absolverande_1_N = mkN "absolverande" ; -- absolverande..nn.1
  absolverbar_1_A = mkA "absolverbar" ; -- absolverbar..av.1
  absolverbarhet_1_N = mkN "absolverbarhet" ; -- absolverbarhet..nn.1
  absolvering_1_N = mkN "absolvering" ; -- absolvering..nn.1
  absorbator_1_N = mkN "absorbator" "absorbatorer" ; -- absorbator..nn.1
  absorber_1_N = mkN "absorber" ; -- absorber..nn.1
  absorbera_1_V = mkV "absorberar" ; -- absorbera..vb.1
  absorbera_2_V = mkV "absorberar" ; -- absorbera..vb.2
  absorberande_1_N = mkN "absorberande" ; -- absorberande..nn.1
  absorberbar_1_A = mkA "absorberbar" ; -- absorberbar..av.1
  absorberbarhet_1_N = mkN "absorberbarhet" ; -- absorberbarhet..nn.1
  absorbering_1_N = mkN "absorbering" ; -- absorbering..nn.1
  absorberingsförmåga_1_N = mkN "absorberingsförmåga" ; -- absorberingsförmåga..nn.1
  absorption_1_N = mkN "absorption" ; -- absorption..nn.1
  absorptionslinje_1_N = mkN "absorptionslinje" "absorptionslinjer" ; -- absorptionslinje..nn.1
  abstinens_1_N = mkN "abstinens" ; -- abstinens..nn.1
  abstinenssyndrom_1_N = mkN "abstinenssyndrom" neutrum  ; -- abstinenssyndrom..nn.1
  abstrahera_1_V = mkV "abstraherar" ; -- abstrahera..vb.1
  abstraherande_1_N = mkN "abstraherande" ; -- abstraherande..nn.1
  abstraherbar_1_A = mkA "abstraherbar" ; -- abstraherbar..av.1
  abstraherbarhet_1_N = mkN "abstraherbarhet" ; -- abstraherbarhet..nn.1
  abstrahering_1_N = mkN "abstrahering" ; -- abstrahering..nn.1
  abstrakt_1_A = mkA "abstrakt" "abstrakt" ; -- abstrakt..av.1
  abstrakt_1_N = mkN "abstrakt" "abstraktet" "abstrakter" "abstrakterna" ; -- abstrakt..nn.1
  abstrakthet_1_N = mkN "abstrakthet" ; -- abstrakthet..nn.1
  abstraktion_1_N = mkN "abstraktion" ; -- abstraktion..nn.1
  abstraktionsförmåga_1_N = mkN "abstraktionsförmåga" ; -- abstraktionsförmåga..nn.1
  abstraktändelse_1_N = mkN "abstraktändelse" "abstraktändelser" ; -- abstraktändelse..nn.1
  abstrus_1_A = mkA "abstrus" ; -- abstrus..av.1
  absurd_1_A = mkA "absurd" "absurt" ; -- absurd..av.1
  absurdhet_1_N = mkN "absurdhet" ; -- absurdhet..nn.1
  absurdism_1_N = mkN "absurdism" "absurdismer" ; -- absurdism..nn.1
  absurdistisk_1_A = mkA "absurdistisk" ; -- absurdistisk..av.1
  absurditet_1_N = mkN "absurditet" "absurditeter" ; -- absurditet..nn.1
  abundans_1_N = mkN "abundans" ; -- abundans..nn.1
  abundant_1_A = mkA "abundant" "abundant" ; -- abundant..av.1
  abyssal_1_A = mkA "abyssal" ; -- abyssal..av.1
  acanthamoebakeratit_1_N = mkN "acanthamoebakeratit" "acanthamoebakeratiter" ; -- acanthamoebakeratit..nn.1
  accedera_1_V = mkV "accederar" ; -- accedera..vb.1
  accederande_1_N = mkN "accederande" ; -- accederande..nn.1
  accederbar_1_A = mkA "accederbar" ; -- accederbar..av.1
  accederbarhet_1_N = mkN "accederbarhet" ; -- accederbarhet..nn.1
  accedering_1_N = mkN "accedering" ; -- accedering..nn.1
  acceleration_1_N = mkN "acceleration" ; -- acceleration..nn.1
  accelerationsfält_1_N = mkN "accelerationsfält" neutrum  ; -- accelerationsfält..nn.1
  accelerationslag_1_N = mkN "accelerationslag" ; -- accelerationslag..nn.1
  accelerator_1_N = mkN "accelerator" "acceleratorer" ; -- accelerator..nn.1
  acceleratormaskin_1_N = mkN "acceleratormaskin" "acceleratormaskiner" ; -- acceleratormaskin..nn.1
  acceleratorsystem_1_N = mkN "acceleratorsystem" neutrum  ; -- acceleratorsystem..nn.1
  accelerera_1_V = mkV "accelererar" ; -- accelerera..vb.1
  accelerera_2_V = mkV "accelererar" ; -- accelerera..vb.2
  accelererande_1_N = mkN "accelererande" ; -- accelererande..nn.1
  accelererbar_1_A = mkA "accelererbar" ; -- accelererbar..av.1
  accelererbarhet_1_N = mkN "accelererbarhet" ; -- accelererbarhet..nn.1
  accelerering_1_N = mkN "accelerering" ; -- accelerering..nn.1
  accent_1_N = mkN "accent" "accenter" ; -- accent..nn.1
  accentbeteckning_1_N = mkN "accentbeteckning" ; -- accentbeteckning..nn.1
  accentförskjutning_1_N = mkN "accentförskjutning" ; -- accentförskjutning..nn.1
  accenttecken_1_N = mkN "accenttecken" "accenttecknet" "accenttecken" "accenttecknen" ; -- accenttecken..nn.1
  accentuera_1_V = mkV "accentuerar" ; -- accentuera..vb.1
  accentuerande_1_N = mkN "accentuerande" ; -- accentuerande..nn.1
  accentuerbar_1_A = mkA "accentuerbar" ; -- accentuerbar..av.1
  accentuerbarhet_1_N = mkN "accentuerbarhet" ; -- accentuerbarhet..nn.1
  accentuering_1_N = mkN "accentuering" ; -- accentuering..nn.1
  accept_1_N = mkN "accept" neutrum  ; -- accept..nn.1
  accept_2_N = mkN "accept" "accepter" ; -- accept..nn.2
  acceptabel_1_A = mkA "acceptabel" ; -- acceptabel..av.1
  acceptans_1_N = mkN "acceptans" ; -- acceptans..nn.1
  acceptant_1_N = mkN "acceptant" "acceptanter" ; -- acceptant..nn.1
  acceptera_1_V = mkV "accepterar" ; -- acceptera..vb.1
  accepterande_1_N = mkN "accepterande" ; -- accepterande..nn.1
  accepterbar_1_A = mkA "accepterbar" ; -- accepterbar..av.1
  accepterbarhet_1_N = mkN "accepterbarhet" ; -- accepterbarhet..nn.1
  acceptering_1_N = mkN "acceptering" ; -- acceptering..nn.1
  acceptkredit_1_N = mkN "acceptkredit" "acceptkrediter" ; -- acceptkredit..nn.1
  acceptpris_1_N = mkN "acceptpris" neutrum  ; -- acceptpris..nn.1
  access_1_N = mkN "access" "accesser" ; -- access..nn.1
  accessa_1_V = mkV "accessar" ; -- accessa..vb.1
  accessande_1_N = mkN "accessande" ; -- accessande..nn.1
  accession_1_N = mkN "accession" ; -- accession..nn.1
  accessionskatalog_1_N = mkN "accessionskatalog" "accessionskataloger" ; -- accessionskatalog..nn.1
  accessoar_1_N = mkN "accessoar" "accessoarer" ; -- accessoar..nn.1
  accessorisk_1_A = mkA "accessorisk" ; -- accessorisk..av.1
  accesstid_1_N = mkN "accesstid" "accesstider" ; -- accesstid..nn.1
  accidens_1_N = mkN "accidens" "accidenser" ; -- accidens..nn.1
  accidenstryck_1_N = mkN "accidenstryck" neutrum  ; -- accidenstryck..nn.1
  accidentell_1_A = mkA "accidentell" ; -- accidentell..av.1
  accis_1_N = mkN "accis" "acciser" ; -- accis..nn.1
  accisfri_1_A = mkA "accisfri" "accisfritt" ; -- accisfri..av.1
  accispliktig_1_A = mkA "accispliktig" ; -- accispliktig..av.1
  acerolakörsbär_1_N = mkN "acerolakörsbär" neutrum  ; -- acerolakörsbär..nn.1
  acetaldehyd_1_N = mkN "acetaldehyd" "acetaldehyder" ; -- acetaldehyd..nn.1
  acetat_1_N = mkN "acetat" neutrum  ; -- acetat..nn.1
  aceton_1_N = mkN "aceton" ; -- aceton..nn.1
  acetylen_1_N = mkN "acetylen" neutrum  ; -- acetylen..nn.1
  acetylengas_1_N = mkN "acetylengas" ; -- acetylengas..nn.1
  acetylenlampa_1_N = mkN "acetylenlampa" ; -- acetylenlampa..nn.1
  acetylsalicylsyra_1_N = mkN "acetylsalicylsyra" ; -- acetylsalicylsyra..nn.1
  aciditet_1_N = mkN "aciditet" "aciditeter" ; -- aciditet..nn.1
  acidos_1_N = mkN "acidos" "acidoser" ; -- acidos..nn.1
  acinetobacterinfektion_1_N = mkN "acinetobacterinfektion" ; -- acinetobacterinfektion..nn.1
  acinärcellskarcinom_1_N = mkN "acinärcellskarcinom" neutrum  ; -- acinärcellskarcinom..nn.1
  ackja_1_N = mkN "ackja" ; -- ackja..nn.1
  acklamation_1_N = mkN "acklamation" ; -- acklamation..nn.1
  acklamationsval_1_N = mkN "acklamationsval" neutrum  ; -- acklamationsval..nn.1
  acklimatisation_1_N = mkN "acklimatisation" ; -- acklimatisation..nn.1
  acklimatisera_1_V = mkV "acklimatiserar" ; -- acklimatisera..vb.1
  acklimatiserande_1_N = mkN "acklimatiserande" ; -- acklimatiserande..nn.1
  acklimatiserbar_1_A = mkA "acklimatiserbar" ; -- acklimatiserbar..av.1
  acklimatiserbarhet_1_N = mkN "acklimatiserbarhet" ; -- acklimatiserbarhet..nn.1
  acklimatisering_1_N = mkN "acklimatisering" ; -- acklimatisering..nn.1
  ackommodation_1_N = mkN "ackommodation" ; -- ackommodation..nn.1
  ackommodationsförmåga_1_N = mkN "ackommodationsförmåga" ; -- ackommodationsförmåga..nn.1
  ackommodationsväxel_1_N = mkN "ackommodationsväxel" ; -- ackommodationsväxel..nn.1
  ackommodera_1_V = mkV "ackommoderar" ; -- ackommodera..vb.1
  ackommoderande_1_N = mkN "ackommoderande" ; -- ackommoderande..nn.1
  ackommoderbar_1_A = mkA "ackommoderbar" ; -- ackommoderbar..av.1
  ackommoderbarhet_1_N = mkN "ackommoderbarhet" ; -- ackommoderbarhet..nn.1
  ackommodering_1_N = mkN "ackommodering" ; -- ackommodering..nn.1
  ackompanjatör_1_N = mkN "ackompanjatör" "ackompanjatörer" ; -- ackompanjatör..nn.1
  ackompanjemang_1_N = mkN "ackompanjemang" neutrum  ; -- ackompanjemang..nn.1
  ackompanjera_1_V = mkV "ackompanjerar" ; -- ackompanjera..vb.1
  ackompanjerande_1_N = mkN "ackompanjerande" ; -- ackompanjerande..nn.1
  ackompanjerbar_1_A = mkA "ackompanjerbar" ; -- ackompanjerbar..av.1
  ackompanjerbarhet_1_N = mkN "ackompanjerbarhet" ; -- ackompanjerbarhet..nn.1
  ackompanjering_1_N = mkN "ackompanjering" ; -- ackompanjering..nn.1
  ackord_1_N = mkN "ackord" neutrum  ; -- ackord..nn.1
  ackord_2_N = mkN "ackord" neutrum  ; -- ackord..nn.2
  ackordera_1_V = mkV "ackorderar" ; -- ackordera..vb.1
  ackorderande_1_N = mkN "ackorderande" ; -- ackorderande..nn.1
  ackorderbar_1_A = mkA "ackorderbar" ; -- ackorderbar..av.1
  ackorderbarhet_1_N = mkN "ackorderbarhet" ; -- ackorderbarhet..nn.1
  ackordering_1_N = mkN "ackordering" ; -- ackordering..nn.1
  ackordgrepp_1_N = mkN "ackordgrepp" neutrum  ; -- ackordgrepp..nn.1
  ackordion_1_N = mkN "ackordion" "ackordiet" "ackordier" "ackordierna" ; -- ackordion..nn.1
  ackordlära_1_N = mkN "ackordlära" ; -- ackordlära..nn.1
  ackordsarbete_1_N = mkN "ackordsarbete" ; -- ackordsarbete..nn.1
  ackordshets_1_N = mkN "ackordshets" ; -- ackordshets..nn.1
  ackordslön_1_N = mkN "ackordslön" "ackordslöner" ; -- ackordslön..nn.1
  ackordssumma_1_N = mkN "ackordssumma" ; -- ackordssumma..nn.1
  ackordssättning_1_N = mkN "ackordssättning" ; -- ackordssättning..nn.1
  ackordsättning_1_N = mkN "ackordsättning" ; -- ackordsättning..nn.1
  ackreditera_1_V = mkV "ackrediterar" ; -- ackreditera..vb.1
  ackrediterande_1_N = mkN "ackrediterande" ; -- ackrediterande..nn.1
  ackrediterbar_1_A = mkA "ackrediterbar" ; -- ackrediterbar..av.1
  ackrediterbarhet_1_N = mkN "ackrediterbarhet" ; -- ackrediterbarhet..nn.1
  ackreditering_1_N = mkN "ackreditering" ; -- ackreditering..nn.1
  ackumulation_1_N = mkN "ackumulation" ; -- ackumulation..nn.1
  ackumulator_1_N = mkN "ackumulator" "ackumulatorer" ; -- ackumulator..nn.1
  ackumulera_1_V = mkV "ackumulerar" ; -- ackumulera..vb.1
  ackumulerande_1_N = mkN "ackumulerande" ; -- ackumulerande..nn.1
  ackumulerbar_1_A = mkA "ackumulerbar" ; -- ackumulerbar..av.1
  ackumulerbarhet_1_N = mkN "ackumulerbarhet" ; -- ackumulerbarhet..nn.1
  ackumulering_1_N = mkN "ackumulering" ; -- ackumulering..nn.1
  ackurat_1_A = mkA "ackurat" "ackurat" ; -- ackurat..av.1
  ackuratess_1_N = mkN "ackuratess" ; -- ackuratess..nn.1
  ackusativ_1_A = mkA "ackusativ" ; -- ackusativ..av.1
  ackusativ_1_N = mkN "ackusativ" "ackusativer" ; -- ackusativ..nn.1
  ackusativobjekt_1_N = mkN "ackusativobjekt" neutrum  ; -- ackusativobjekt..nn.1
  ackusativändelse_1_N = mkN "ackusativändelse" "ackusativändelser" ; -- ackusativändelse..nn.1
  ackusatorisk_1_A = mkA "ackusatorisk" ; -- ackusatorisk..av.1
  ackuschör_1_N = mkN "ackuschör" "ackuschörer" ; -- ackuschör..nn.1
  ackuschörska_1_N = mkN "ackuschörska" ; -- ackuschörska..nn.1
  ackvirera_1_V = mkV "ackvirerar" ; -- ackvirera..vb.1
  ackvirerande_1_N = mkN "ackvirerande" ; -- ackvirerande..nn.1
  ackvirerbar_1_A = mkA "ackvirerbar" ; -- ackvirerbar..av.1
  ackvirerbarhet_1_N = mkN "ackvirerbarhet" ; -- ackvirerbarhet..nn.1
  ackvirering_1_N = mkN "ackvirering" ; -- ackvirering..nn.1
  ackvisition_1_N = mkN "ackvisition" ; -- ackvisition..nn.1
  ackvisitionskatalog_1_N = mkN "ackvisitionskatalog" "ackvisitionskataloger" ; -- ackvisitionskatalog..nn.1
  ackvisitör_1_N = mkN "ackvisitör" "ackvisitörer" ; -- ackvisitör..nn.1
  acne_1_N = mkN "acne" utrum  ; -- acne..nn.1
  actinobacillusinfektion_1_N = mkN "actinobacillusinfektion" ; -- actinobacillusinfektion..nn.1
  actinomycetalesinfektion_1_N = mkN "actinomycetalesinfektion" ; -- actinomycetalesinfektion..nn.1
  action_1_N = mkN "action" ; -- action..nn.1
  actionfilm_1_N = mkN "actionfilm" "actionfilmer" ; -- actionfilm..nn.1
  actionrulle_1_N = mkN "actionrulle" utrum  ; -- actionrulle..nn.1
  actionstjärna_1_N = mkN "actionstjärna" ; -- actionstjärna..nn.1
  adagio_1_N = mkN "adagio" "adagiot" "adagion" "adagiona" ; -- adagio..nn.1
  adagiosats_1_N = mkN "adagiosats" "adagiosatser" ; -- adagiosats..nn.1
  adamantinom_1_N = mkN "adamantinom" neutrum  ; -- adamantinom..nn.1
  adamsdräkt_1_N = mkN "adamsdräkt" ; -- adamsdräkt..nn.1
  adamsäpple_1_N = mkN "adamsäpple" ; -- adamsäpple..nn.1
  adaptation_1_N = mkN "adaptation" ; -- adaptation..nn.1
  adapter_1_N = mkN "adapter" ; -- adapter..nn.1
  adaptera_1_V = mkV "adapterar" ; -- adaptera..vb.1
  adapterande_1_N = mkN "adapterande" ; -- adapterande..nn.1
  adapterbar_1_A = mkA "adapterbar" ; -- adapterbar..av.1
  adapterbarhet_1_N = mkN "adapterbarhet" ; -- adapterbarhet..nn.1
  adaptering_1_N = mkN "adaptering" ; -- adaptering..nn.1
  adaption_1_N = mkN "adaption" ; -- adaption..nn.1
  adaptiv_1_A = mkA "adaptiv" ; -- adaptiv..av.1
  addend_1_N = mkN "addend" "addender" ; -- addend..nn.1
  addenda_1_N = mkN "addenda" "addendan" "addenda" "addendana" ; -- addenda..nn.1
  addera_1_V = mkV "adderar" ; -- addera..vb.1
  adderande_1_N = mkN "adderande" ; -- adderande..nn.1
  adderbar_1_A = mkA "adderbar" ; -- adderbar..av.1
  adderbarhet_1_N = mkN "adderbarhet" ; -- adderbarhet..nn.1
  addering_1_N = mkN "addering" ; -- addering..nn.1
  addiktion_1_N = mkN "addiktion" ; -- addiktion..nn.1
  addiktolog_1_N = mkN "addiktolog" "addiktologer" ; -- addiktolog..nn.1
  additament_1_N = mkN "additament" neutrum  ; -- additament..nn.1
  addition_1_N = mkN "addition" ; -- addition..nn.1
  additionstecken_1_N = mkN "additionstecken" "additionstecknet" "additionstecken" "additionstecknen" ; -- additionstecken..nn.1
  additiv_1_A = mkA "additiv" ; -- additiv..av.1
  additiv_1_N = mkN "additiv" neutrum  ; -- additiv..nn.1
  adduktion_1_N = mkN "adduktion" ; -- adduktion..nn.1
  adekvat_1_A = mkA "adekvat" "adekvat" ; -- adekvat..av.1
  adel_1_N = mkN "adel" ; -- adel..nn.1
  adelsbrev_1_N = mkN "adelsbrev" neutrum  ; -- adelsbrev..nn.1
  adelsdam_1_N = mkN "adelsdam" "adelsdamer" ; -- adelsdam..nn.1
  adelsgods_1_N = mkN "adelsgods" neutrum  ; -- adelsgods..nn.1
  adelshem_1_N = mkN "adelshem" "adelshemmet" "adelshem" "adelshemmen" ; -- adelshem..nn.1
  adelshögfärd_1_N = mkN "adelshögfärd" ; -- adelshögfärd..nn.1
  adelskalender_1_N = mkN "adelskalender" ; -- adelskalender..nn.1
  adelskap_1_N = mkN "adelskap" neutrum  ; -- adelskap..nn.1
  adelskrets_1_N = mkN "adelskrets" ; -- adelskrets..nn.1
  adelskultur_1_N = mkN "adelskultur" ; -- adelskultur..nn.1
  adelsman_1_N = mkN "adelsman" "adelsmannen" "adelsmän" "adelsmännen" ; -- adelsman..nn.1
  adelsmatrikel_1_N = mkN "adelsmatrikel" ; -- adelsmatrikel..nn.1
  adelsmärke_1_N = mkN "adelsmärke" ; -- adelsmärke..nn.1
  adelsprivilegium_1_N = mkN "adelsprivilegium" "adelsprivilegiet" "adelsprivilegier" "adelsprivilegierna" ; -- adelsprivilegium..nn.1
  adelssläkt_1_N = mkN "adelssläkt" "adelssläkter" ; -- adelssläkt..nn.1
  adelsstånd_1_N = mkN "adelsstånd" neutrum  ; -- adelsstånd..nn.1
  adelsätt_1_N = mkN "adelsätt" "adelsätter" ; -- adelsätt..nn.1
  adenit_1_N = mkN "adenit" "adeniter" ; -- adenit..nn.1
  adenofibrom_1_N = mkN "adenofibrom" neutrum  ; -- adenofibrom..nn.1
  adenoid_1_A = mkA "adenoid" ; -- adenoid..av.1
  adenoid_1_N = mkN "adenoid" "adenoider" ; -- adenoid..nn.1
  adenokarcinom_1_N = mkN "adenokarcinom" neutrum  ; -- adenokarcinom..nn.1
  adenolymfom_1_N = mkN "adenolymfom" neutrum  ; -- adenolymfom..nn.1
  adenom_1_N = mkN "adenom" neutrum  ; -- adenom..nn.1
  adenomyoepiteliom_1_N = mkN "adenomyoepiteliom" neutrum  ; -- adenomyoepiteliom..nn.1
  adenomyom_1_N = mkN "adenomyom" neutrum  ; -- adenomyom..nn.1
  adenophoreainfektion_1_N = mkN "adenophoreainfektion" ; -- adenophoreainfektion..nn.1
  adenosarkom_1_N = mkN "adenosarkom" neutrum  ; -- adenosarkom..nn.1
  adenovirusinfektion_1_N = mkN "adenovirusinfektion" ; -- adenovirusinfektion..nn.1
  adept_1_N = mkN "adept" "adepter" ; -- adept..nn.1
  adertonde_1_A = mkA "adertonde" ; -- adertonde..av.1
  adertonhundratal_1_N = mkN "adertonhundratal" neutrum  ; -- adertonhundratal..nn.1
  adessiv_1_N = mkN "adessiv" "adessiver" ; -- adessiv..nn.1
  adhd_symtom_1_N = mkN "adhd-symtom" neutrum  ; -- adhd-symtom..nn.1
  adherens_1_N = mkN "adherens" ; -- adherens..nn.1
  adhesion_1_N = mkN "adhesion" ; -- adhesion..nn.1
  adhesionskraft_1_N = mkN "adhesionskraft" "adhesionskrafter" ; -- adhesionskraft..nn.1
  adhesiv_1_A = mkA "adhesiv" ; -- adhesiv..av.1
  adiabatisk_1_A = mkA "adiabatisk" ; -- adiabatisk..av.1
  adiafora_1_N = mkN "adiafora" "adiaforan" "adiafora" "adiaforana" ; -- adiafora..nn.1
  adiaforistisk_1_A = mkA "adiaforistisk" ; -- adiaforistisk..av.1
  adidasgympasko_1_N = mkN "adidasgympasko" "adidasgympaskor" ; -- adidasgympasko..nn.1
  adipositas_1_N = mkN "adipositas" ; -- adipositas..nn.1
  adjektiv_1_N = mkN "adjektiv" neutrum  ; -- adjektiv..nn.1
  adjektivattribut_1_N = mkN "adjektivattribut" neutrum  ; -- adjektivattribut..nn.1
  adjektivfras_1_N = mkN "adjektivfras" "adjektivfraser" ; -- adjektivfras..nn.1
  adjektivisk_1_A = mkA "adjektivisk" ; -- adjektivisk..av.1
  adjektivistisk_1_A = mkA "adjektivistisk" ; -- adjektivistisk..av.1
  adjektivändelse_1_N = mkN "adjektivändelse" "adjektivändelser" ; -- adjektivändelse..nn.1
  adjungera_1_V = mkV "adjungerar" ; -- adjungera..vb.1
  adjungerande_1_N = mkN "adjungerande" ; -- adjungerande..nn.1
  adjungerbar_1_A = mkA "adjungerbar" ; -- adjungerbar..av.1
  adjungerbarhet_1_N = mkN "adjungerbarhet" ; -- adjungerbarhet..nn.1
  adjungering_1_N = mkN "adjungering" ; -- adjungering..nn.1
  adjunkt_1_N = mkN "adjunkt" "adjunkter" ; -- adjunkt..nn.1
  adjunktion_1_N = mkN "adjunktion" ; -- adjunktion..nn.1
  adjunktur_1_N = mkN "adjunktur" "adjunkturer" ; -- adjunktur..nn.1
  adjutant_1_N = mkN "adjutant" "adjutanter" ; -- adjutant..nn.1
  adjö_1_N = mkN "adjö" "adjöt" "adjön" "adjöna" ; -- adjö..nn.1
  adla_1_V = mkV "adlar" ; -- adla..vb.1
  adlande_1_N = mkN "adlande" ; -- adlande..nn.1
  adlig_1_A = mkA "adlig" ; -- adlig..av.1
  adlighet_1_N = mkN "adlighet" ; -- adlighet..nn.1
  administration_1_N = mkN "administration" ; -- administration..nn.1
  administrativ_1_A = mkA "administrativ" ; -- administrativ..av.1
  administrator_1_N = mkN "administrator" "administratorer" ; -- administrator..nn.1
  administratör_1_N = mkN "administratör" "administratörer" ; -- administratör..nn.1
  administratörsstatus_1_N = mkN "administratörsstatus" ; -- administratörsstatus..nn.1
  administrera_1_V = mkV "administrerar" ; -- administrera..vb.1
  administrerande_1_N = mkN "administrerande" ; -- administrerande..nn.1
  administrerbar_1_A = mkA "administrerbar" ; -- administrerbar..av.1
  administrerbarhet_1_N = mkN "administrerbarhet" ; -- administrerbarhet..nn.1
  administrering_1_N = mkN "administrering" ; -- administrering..nn.1
  admonition_1_N = mkN "admonition" ; -- admonition..nn.1
  adnexasjukdom_1_N = mkN "adnexasjukdom" ; -- adnexasjukdom..nn.1
  adnexit_1_N = mkN "adnexit" "adnexiter" ; -- adnexit..nn.1
  adobe_1_N = mkN "adobe" utrum  ; -- adobe..nn.1
  adolescens_1_N = mkN "adolescens" ; -- adolescens..nn.1
  adonis_1_N = mkN "adonis" ; -- adonis..nn.1
  adonisgestalt_1_N = mkN "adonisgestalt" "adonisgestalter" ; -- adonisgestalt..nn.1
  adoptant_1_N = mkN "adoptant" "adoptanter" ; -- adoptant..nn.1
  adoptera_1_V = mkV "adopterar" ; -- adoptera..vb.1
  adopterande_1_N = mkN "adopterande" ; -- adopterande..nn.1
  adopterbar_1_A = mkA "adopterbar" ; -- adopterbar..av.1
  adopterbarhet_1_N = mkN "adopterbarhet" ; -- adopterbarhet..nn.1
  adoptering_1_N = mkN "adoptering" ; -- adoptering..nn.1
  adoption_1_N = mkN "adoption" ; -- adoption..nn.1
  adoptiv_1_A = mkA "adoptiv" ; -- adoptiv..av.1
  adoptivbarn_1_N = mkN "adoptivbarn" neutrum  ; -- adoptivbarn..nn.1
  adoptivförälder_1_N = mkN "adoptivförälder" ; -- adoptivförälder..nn.1
  adoptivson_1_N = mkN "adoptivson" "adoptivsöner" ; -- adoptivson..nn.1
  adoratör_1_N = mkN "adoratör" "adoratörer" ; -- adoratör..nn.1
  adrenalin_1_N = mkN "adrenalin" "adrenaliner" ; -- adrenalin..nn.1
  adrenalinkick_1_N = mkN "adrenalinkick" ; -- adrenalinkick..nn.1
  adrenalinstinn_1_A = mkA "adrenalinstinn" "adrenalinstint" ; -- adrenalinstinn..av.1
  adrenoleukodystrofi_1_N = mkN "adrenoleukodystrofi" ; -- adrenoleukodystrofi..nn.1
  adrenomyeloneuropati_1_N = mkN "adrenomyeloneuropati" ; -- adrenomyeloneuropati..nn.1
  adress_1_N = mkN "adress" "adresser" ; -- adress..nn.1
  adressat_1_N = mkN "adressat" "adressater" ; -- adressat..nn.1
  adressbuss_1_N = mkN "adressbuss" ; -- adressbuss..nn.1
  adressera_1_V = mkV "adresserar" ; -- adressera..vb.1
  adresserande_1_N = mkN "adresserande" ; -- adresserande..nn.1
  adresserbar_1_A = mkA "adresserbar" ; -- adresserbar..av.1
  adresserbarhet_1_N = mkN "adresserbarhet" ; -- adresserbarhet..nn.1
  adressering_1_N = mkN "adressering" ; -- adressering..nn.1
  adresskalender_1_N = mkN "adresskalender" ; -- adresskalender..nn.1
  adresskort_1_N = mkN "adresskort" neutrum  ; -- adresskort..nn.1
  adresskälla_1_N = mkN "adresskälla" ; -- adresskälla..nn.1
  adresslapp_1_N = mkN "adresslapp" ; -- adresslapp..nn.1
  adriatisk_1_A = mkA "adriatisk" ; -- adriatisk..av.1
  adsorbera_1_V = mkV "adsorberar" ; -- adsorbera..vb.1
  adsorberande_1_N = mkN "adsorberande" ; -- adsorberande..nn.1
  adsorberbar_1_A = mkA "adsorberbar" ; -- adsorberbar..av.1
  adsorberbarhet_1_N = mkN "adsorberbarhet" ; -- adsorberbarhet..nn.1
  adsorbering_1_N = mkN "adsorbering" ; -- adsorbering..nn.1
  adsorption_1_N = mkN "adsorption" ; -- adsorption..nn.1
  adstringerande_1_A = mkA "adstringerande" ; -- adstringerande..av.1
  aducera_1_V = mkV "aducerar" ; -- aducera..vb.1
  aducerande_1_N = mkN "aducerande" ; -- aducerande..nn.1
  aducerbar_1_A = mkA "aducerbar" ; -- aducerbar..av.1
  aducerbarhet_1_N = mkN "aducerbarhet" ; -- aducerbarhet..nn.1
  aducering_1_N = mkN "aducering" ; -- aducering..nn.1
  advent_1_N = mkN "advent" neutrum  ; -- advent..nn.1
  adventist_1_N = mkN "adventist" "adventister" ; -- adventist..nn.1
  adventistisk_1_A = mkA "adventistisk" ; -- adventistisk..av.1
  adventiv_1_A = mkA "adventiv" ; -- adventiv..av.1
  adventskalender_1_N = mkN "adventskalender" ; -- adventskalender..nn.1
  adventsljusstake_1_N = mkN "adventsljusstake" utrum  ; -- adventsljusstake..nn.1
  adventsmys_1_N = mkN "adventsmys" neutrum  ; -- adventsmys..nn.1
  adventsstake_1_N = mkN "adventsstake" utrum  ; -- adventsstake..nn.1
  adventsstjärna_1_N = mkN "adventsstjärna" ; -- adventsstjärna..nn.1
  adverb_1_N = mkN "adverb" neutrum  ; -- adverb..nn.1
  adverbial_1_N = mkN "adverbial" neutrum  ; -- adverbial..nn.1
  adverbialbestämning_1_N = mkN "adverbialbestämning" ; -- adverbialbestämning..nn.1
  adverbialsats_1_N = mkN "adverbialsats" "adverbialsatser" ; -- adverbialsats..nn.1
  adverbiell_1_A = mkA "adverbiell" ; -- adverbiell..av.1
  advers_1_N = mkN "advers" "adverser" ; -- advers..nn.1
  adversativ_1_A = mkA "adversativ" ; -- adversativ..av.1
  advocera_1_V = mkV "advocerar" ; -- advocera..vb.1
  advocerande_1_N = mkN "advocerande" ; -- advocerande..nn.1
  advocerbar_1_A = mkA "advocerbar" ; -- advocerbar..av.1
  advocerbarhet_1_N = mkN "advocerbarhet" ; -- advocerbarhet..nn.1
  advocering_1_N = mkN "advocering" ; -- advocering..nn.1
  advokat_1_N = mkN "advokat" "advokater" ; -- advokat..nn.1
  advokatbyrå_1_N = mkN "advokatbyrå" "advokatbyråer" ; -- advokatbyrå..nn.1
  advokatfiskal_1_N = mkN "advokatfiskal" "advokatfiskaler" ; -- advokatfiskal..nn.1
  advokathjälp_1_N = mkN "advokathjälp" ; -- advokathjälp..nn.1
  advokatknep_1_N = mkN "advokatknep" neutrum  ; -- advokatknep..nn.1
  advokatkontor_1_N = mkN "advokatkontor" neutrum  ; -- advokatkontor..nn.1
  advokatorisk_1_A = mkA "advokatorisk" ; -- advokatorisk..av.1
  advokatsamfund_1_N = mkN "advokatsamfund" neutrum  ; -- advokatsamfund..nn.1
  advokatstorm_1_N = mkN "advokatstorm" ; -- advokatstorm..nn.1
  advokatyr_1_N = mkN "advokatyr" "advokatyrer" ; -- advokatyr..nn.1
  adxukiböna_1_N = mkN "adxukiböna" ; -- adxukiböna..nn.1
  aerob_1_A = mkA "aerob" ; -- aerob..av.1
  aerobisk_1_A = mkA "aerobisk" ; -- aerobisk..av.1
  aerodrom_1_N = mkN "aerodrom" "aerodromer" ; -- aerodrom..nn.1
  aerodynamik_1_N = mkN "aerodynamik" ; -- aerodynamik..nn.1
  aerodynamisk_1_A = mkA "aerodynamisk" ; -- aerodynamisk..av.1
  aerofagi_1_N = mkN "aerofagi" ; -- aerofagi..nn.1
  aerogel_1_N = mkN "aerogel" "aerogeler" ; -- aerogel..nn.1
  aerogram_1_N = mkN "aerogram" "aerogrammet" "aerogram" "aerogrammen" ; -- aerogram..nn.1
  aerologi_1_N = mkN "aerologi" ; -- aerologi..nn.1
  aeromekanik_1_N = mkN "aeromekanik" ; -- aeromekanik..nn.1
  aeronaut_1_N = mkN "aeronaut" "aeronauter" ; -- aeronaut..nn.1
  aeronautik_1_N = mkN "aeronautik" ; -- aeronautik..nn.1
  aeronautisk_1_A = mkA "aeronautisk" ; -- aeronautisk..av.1
  aeroplan_1_N = mkN "aeroplan" neutrum  ; -- aeroplan..nn.1
  aerosol_1_N = mkN "aerosol" "aerosoler" ; -- aerosol..nn.1
  aerosolform_1_N = mkN "aerosolform" ; -- aerosolform..nn.1
  aerostat_1_N = mkN "aerostat" "aerostater" ; -- aerostat..nn.1
  aerostatik_1_N = mkN "aerostatik" ; -- aerostatik..nn.1
  aerostatisk_1_A = mkA "aerostatisk" ; -- aerostatisk..av.1
  afaki_1_N = mkN "afaki" ; -- afaki..nn.1
  afasi_1_N = mkN "afasi" "afasier" ; -- afasi..nn.1
  afasisk_1_A = mkA "afasisk" ; -- afasisk..av.1
  afatiker_1_N = mkN "afatiker" "afatikern" "afatiker" "afatikerna" ; -- afatiker..nn.1
  afatisk_1_A = mkA "afatisk" ; -- afatisk..av.1
  afelium_1_N = mkN "afelium" "afeliet" "afelier" "afelierna" ; -- afelium..nn.1
  affekt_1_N = mkN "affekt" "affekter" ; -- affekt..nn.1
  affektanfall_1_N = mkN "affektanfall" neutrum  ; -- affektanfall..nn.1
  affektation_1_N = mkN "affektation" ; -- affektation..nn.1
  affekterad_1_A = mkA "affekterad" ; -- affekterad..av.1
  affektfri_1_A = mkA "affektfri" "affektfritt" ; -- affektfri..av.1
  affektion_1_N = mkN "affektion" ; -- affektion..nn.1
  affektionsvärde_1_N = mkN "affektionsvärde" ; -- affektionsvärde..nn.1
  affektiv_1_A = mkA "affektiv" ; -- affektiv..av.1
  afficiera_1_V = mkV "afficierar" ; -- afficiera..vb.1
  afficierande_1_N = mkN "afficierande" ; -- afficierande..nn.1
  afficierbar_1_A = mkA "afficierbar" ; -- afficierbar..av.1
  afficierbarhet_1_N = mkN "afficierbarhet" ; -- afficierbarhet..nn.1
  afficiering_1_N = mkN "afficiering" ; -- afficiering..nn.1
  affidavit_1_N = mkN "affidavit" neutrum  ; -- affidavit..nn.1
  affin_1_A = mkA "affin" ; -- affin..av.1
  affinage_1_N = mkN "affinage" "affinaget" "affinage" "affinagen" ; -- affinage..nn.1
  affinera_1_V = mkV "affinerar" ; -- affinera..vb.1
  affinerande_1_N = mkN "affinerande" ; -- affinerande..nn.1
  affinerbar_1_A = mkA "affinerbar" ; -- affinerbar..av.1
  affinerbarhet_1_N = mkN "affinerbarhet" ; -- affinerbarhet..nn.1
  affinering_1_N = mkN "affinering" ; -- affinering..nn.1
  affinitet_1_N = mkN "affinitet" "affiniteter" ; -- affinitet..nn.1
  affirmativ_1_A = mkA "affirmativ" ; -- affirmativ..av.1
  affisch_1_N = mkN "affisch" "affischer" ; -- affisch..nn.1
  affischera_1_V = mkV "affischerar" ; -- affischera..vb.1
  affischerande_1_N = mkN "affischerande" ; -- affischerande..nn.1
  affischerbar_1_A = mkA "affischerbar" ; -- affischerbar..av.1
  affischerbarhet_1_N = mkN "affischerbarhet" ; -- affischerbarhet..nn.1
  affischering_1_N = mkN "affischering" ; -- affischering..nn.1
  affischkampanj_1_N = mkN "affischkampanj" "affischkampanjer" ; -- affischkampanj..nn.1
  affischmässig_1_A = mkA "affischmässig" ; -- affischmässig..av.1
  affischnamn_1_N = mkN "affischnamn" neutrum  ; -- affischnamn..nn.1
  affischpelare_1_N = mkN "affischpelare" utrum  ; -- affischpelare..nn.1
  affischstil_1_N = mkN "affischstil" ; -- affischstil..nn.1
  affischör_1_N = mkN "affischör" "affischörer" ; -- affischör..nn.1
  affix_1_N = mkN "affix" neutrum  ; -- affix..nn.1
  affrikata_1_N = mkN "affrikata" ; -- affrikata..nn.1
  affär_1_N = mkN "affär" "affärer" ; -- affär..nn.1
  affärsavtal_1_N = mkN "affärsavtal" neutrum  ; -- affärsavtal..nn.1
  affärsbank_1_N = mkN "affärsbank" "affärsbanker" ; -- affärsbank..nn.1
  affärsbegåvning_1_N = mkN "affärsbegåvning" ; -- affärsbegåvning..nn.1
  affärsbegåvning_2_N = mkN "affärsbegåvning" ; -- affärsbegåvning..nn.2
  affärsbekant_1_N = mkN "affärsbekant" "affärsbekanten" "affärsbekanta" "affärsbekanterna" ; -- affärsbekant..nn.1
  affärsbiträde_1_N = mkN "affärsbiträde" ; -- affärsbiträde..nn.1
  affärsbrev_1_N = mkN "affärsbrev" neutrum  ; -- affärsbrev..nn.1
  affärsbyrå_1_N = mkN "affärsbyrå" "affärsbyråer" ; -- affärsbyrå..nn.1
  affärscentrum_1_N = mkN "affärscentrum" neutrum  ; -- affärscentrum..nn.1
  affärsdistrikt_1_N = mkN "affärsdistrikt" neutrum  ; -- affärsdistrikt..nn.1
  affärsdrivande_1_A = mkA "affärsdrivande" ; -- affärsdrivande..av.1
  affärsfastighet_1_N = mkN "affärsfastighet" "affärsfastigheter" ; -- affärsfastighet..nn.1
  affärsförbindelse_1_N = mkN "affärsförbindelse" "affärsförbindelser" ; -- affärsförbindelse..nn.1
  affärsföretag_1_N = mkN "affärsföretag" neutrum  ; -- affärsföretag..nn.1
  affärsförslag_1_N = mkN "affärsförslag" neutrum  ; -- affärsförslag..nn.1
  affärsgata_1_N = mkN "affärsgata" ; -- affärsgata..nn.1
  affärsgeni_1_N = mkN "affärsgeni" "affärsgeniet" "affärsgenier" "affärsgenierna" ; -- affärsgeni..nn.1
  affärshandling_1_N = mkN "affärshandling" ; -- affärshandling..nn.1
  affärshuvud_1_N = mkN "affärshuvud" "affärshuvudet" "affärshuvud" "affärshuvudena" ; -- affärshuvud..nn.1
  affärsidé_1_N = mkN "affärsidé" "affärsidéer" ; -- affärsidé..nn.1
  affärskedja_1_N = mkN "affärskedja" ; -- affärskedja..nn.1
  affärskvarter_1_N = mkN "affärskvarter" "affärskvarteret" "affärskvarter" "affärskvarteren" ; -- affärskvarter..nn.1
  affärsliv_1_N = mkN "affärsliv" neutrum  ; -- affärsliv..nn.1
  affärslokal_1_N = mkN "affärslokal" "affärslokaler" ; -- affärslokal..nn.1
  affärsman_1_N = mkN "affärsman" "affärsmannen" "affärsmän" "affärsmännen" ; -- affärsman..nn.1
  affärsmannamässig_1_A = mkA "affärsmannamässig" ; -- affärsmannamässig..av.1
  affärsmoral_1_N = mkN "affärsmoral" ; -- affärsmoral..nn.1
  affärsmässig_1_A = mkA "affärsmässig" ; -- affärsmässig..av.1
  affärsmässig_2_A = mkA "affärsmässig" ; -- affärsmässig..av.2
  affärsmässighet_1_N = mkN "affärsmässighet" ; -- affärsmässighet..nn.1
  affärspapper_1_N = mkN "affärspapper" neutrum  ; -- affärspapper..nn.1
  affärsresa_1_N = mkN "affärsresa" ; -- affärsresa..nn.1
  affärsresenär_1_N = mkN "affärsresenär" "affärsresenärer" ; -- affärsresenär..nn.1
  affärsstil_1_N = mkN "affärsstil" ; -- affärsstil..nn.1
  affärsstråk_1_N = mkN "affärsstråk" neutrum  ; -- affärsstråk..nn.1
  affärsställning_1_N = mkN "affärsställning" ; -- affärsställning..nn.1
  affärstid_1_N = mkN "affärstid" "affärstider" ; -- affärstid..nn.1
  affärstransaktion_1_N = mkN "affärstransaktion" ; -- affärstransaktion..nn.1
  affärsuppgörelse_1_N = mkN "affärsuppgörelse" "affärsuppgörelser" ; -- affärsuppgörelse..nn.1
  affärsverk_1_N = mkN "affärsverk" neutrum  ; -- affärsverk..nn.1
  affärsverksamhet_1_N = mkN "affärsverksamhet" "affärsverksamheter" ; -- affärsverksamhet..nn.1
  affärsvärld_1_N = mkN "affärsvärld" ; -- affärsvärld..nn.1
  afghan_1_N = mkN "afghan" "afghaner" ; -- afghan..nn.1
  afghansk_1_A = mkA "afghansk" ; -- afghansk..av.1
  afghanska_1_N = mkN "afghanska" ; -- afghanska..nn.1
  afghanska_2_N = mkN "afghanska" ; -- afghanska..nn.2
  afibrinogenemi_1_N = mkN "afibrinogenemi" ; -- afibrinogenemi..nn.1
  afoni_1_N = mkN "afoni" ; -- afoni..nn.1
  aforism_1_N = mkN "aforism" "aforismer" ; -- aforism..nn.1
  aforistiker_1_N = mkN "aforistiker" "aforistikern" "aforistiker" "aforistikerna" ; -- aforistiker..nn.1
  aforistisk_1_A = mkA "aforistisk" ; -- aforistisk..av.1
  afrikaans_1_N = mkN "afrikaans" ; -- afrikaans..nn.1
  afrikainspirerad_1_A = mkA "afrikainspirerad" ; -- afrikainspirerad..av.1
  afrikan_1_N = mkN "afrikan" "afrikaner" ; -- afrikan..nn.1
  afrikanisera_1_V = mkV "afrikaniserar" ; -- afrikanisera..vb.1
  afrikaniserande_1_N = mkN "afrikaniserande" ; -- afrikaniserande..nn.1
  afrikaniserbar_1_A = mkA "afrikaniserbar" ; -- afrikaniserbar..av.1
  afrikaniserbarhet_1_N = mkN "afrikaniserbarhet" ; -- afrikaniserbarhet..nn.1
  afrikanisering_1_N = mkN "afrikanisering" ; -- afrikanisering..nn.1
  afrikansk_1_A = mkA "afrikansk" ; -- afrikansk..av.1
  afrikanska_1_N = mkN "afrikanska" ; -- afrikanska..nn.1
  afro_asiatisk_1_A = mkA "afro-asiatisk" ; -- afro-asiatisk..av.1
  afroamerikan_1_N = mkN "afroamerikan" "afroamerikaner" ; -- afroamerikan..nn.1
  afroamerikansk_1_A = mkA "afroamerikansk" ; -- afroamerikansk..av.1
  afroasiatisk_1_A = mkA "afroasiatisk" ; -- afroasiatisk..av.1
  afrodisiakum_1_N = mkN "afrodisiakum" "afrodisiakumet" "afrodisiaka" "afrodisiakana" ; -- afrodisiakum..nn.1
  afrofobi_1_N = mkN "afrofobi" ; -- afrofobi..nn.1
  afrofrisyr_1_N = mkN "afrofrisyr" "afrofrisyrer" ; -- afrofrisyr..nn.1
  afrokam_1_N = mkN "afrokam" "afrokammen" "afrokammar" "afrokammarna" ; -- afrokam..nn.1
  afrosvensk_1_N = mkN "afrosvensk" ; -- afrosvensk..nn.1
  afton_1_N = mkN "afton" "aftonen" "aftnar" "aftnarna" ; -- afton..nn.1
  aftonandakt_1_N = mkN "aftonandakt" "aftonandakter" ; -- aftonandakt..nn.1
  aftonbelysning_1_N = mkN "aftonbelysning" ; -- aftonbelysning..nn.1
  aftonbrasa_1_N = mkN "aftonbrasa" ; -- aftonbrasa..nn.1
  aftonbön_1_N = mkN "aftonbön" "aftonböner" ; -- aftonbön..nn.1
  aftondagg_1_N = mkN "aftondagg" ; -- aftondagg..nn.1
  aftondräkt_1_N = mkN "aftondräkt" "aftondräkter" ; -- aftondräkt..nn.1
  aftonfjäril_1_N = mkN "aftonfjäril" ; -- aftonfjäril..nn.1
  aftongudstjänst_1_N = mkN "aftongudstjänst" "aftongudstjänster" ; -- aftongudstjänst..nn.1
  aftonhandske_1_N = mkN "aftonhandske" utrum  ; -- aftonhandske..nn.1
  aftonhimmel_1_N = mkN "aftonhimmel" ; -- aftonhimmel..nn.1
  aftonklänning_1_N = mkN "aftonklänning" ; -- aftonklänning..nn.1
  aftonkvist_1_N = mkN "aftonkvist" ; -- aftonkvist..nn.1
  aftonkyla_1_N = mkN "aftonkyla" ; -- aftonkyla..nn.1
  aftonluft_1_N = mkN "aftonluft" ; -- aftonluft..nn.1
  aftonmål_1_N = mkN "aftonmål" neutrum  ; -- aftonmål..nn.1
  aftonmåltid_1_N = mkN "aftonmåltid" "aftonmåltider" ; -- aftonmåltid..nn.1
  aftonpipa_1_N = mkN "aftonpipa" ; -- aftonpipa..nn.1
  aftonplenum_1_N = mkN "aftonplenum" neutrum  ; -- aftonplenum..nn.1
  aftonpromenad_1_N = mkN "aftonpromenad" "aftonpromenader" ; -- aftonpromenad..nn.1
  aftonpsalm_1_N = mkN "aftonpsalm" "aftonpsalmer" ; -- aftonpsalm..nn.1
  aftonrodnad_1_N = mkN "aftonrodnad" "aftonrodnader" ; -- aftonrodnad..nn.1
  aftonsamkväm_1_N = mkN "aftonsamkväm" neutrum  ; -- aftonsamkväm..nn.1
  aftonskola_1_N = mkN "aftonskola" ; -- aftonskola..nn.1
  aftonskymning_1_N = mkN "aftonskymning" ; -- aftonskymning..nn.1
  aftonsol_1_N = mkN "aftonsol" ; -- aftonsol..nn.1
  aftonstjärna_1_N = mkN "aftonstjärna" ; -- aftonstjärna..nn.1
  aftonstund_1_N = mkN "aftonstund" "aftonstunder" ; -- aftonstund..nn.1
  aftonstämning_1_N = mkN "aftonstämning" ; -- aftonstämning..nn.1
  aftonsång_1_N = mkN "aftonsång" "aftonsånger" ; -- aftonsång..nn.1
  aftontidning_1_N = mkN "aftontidning" ; -- aftontidning..nn.1
  aftontoalett_1_N = mkN "aftontoalett" "aftontoaletter" ; -- aftontoalett..nn.1
  aftonunderhållning_1_N = mkN "aftonunderhållning" ; -- aftonunderhållning..nn.1
  aftonvard_1_N = mkN "aftonvard" "aftonvarder" ; -- aftonvard..nn.1
  aftonvind_1_N = mkN "aftonvind" ; -- aftonvind..nn.1
  aftonvisit_1_N = mkN "aftonvisit" "aftonvisiter" ; -- aftonvisit..nn.1
  ag_1_N = mkN "ag" ; -- ag..nn.1
  aga_1_N = mkN "aga" ; -- aga..nn.1
  aga_2_N = mkN "aga" ; -- aga..nn.2
  aga_1_V = mkV "agar" ; -- aga..vb.1
  agammaglobulinemi_1_N = mkN "agammaglobulinemi" ; -- agammaglobulinemi..nn.1
  agande_1_N = mkN "agande" ; -- agande..nn.1
  agar_1_N = mkN "agar" neutrum  ; -- agar..nn.1
  agat_1_N = mkN "agat" "agater" ; -- agat..nn.1
  agatglas_1_N = mkN "agatglas" neutrum  ; -- agatglas..nn.1
  agave_1_N = mkN "agave" "agaver" ; -- agave..nn.1
  agenda_1_N = mkN "agenda" ; -- agenda..nn.1
  agens_1_N = mkN "agens" "agenser" ; -- agens..nn.1
  agent_1_N = mkN "agent" "agenter" ; -- agent..nn.1
  agentfilm_1_N = mkN "agentfilm" "agentfilmer" ; -- agentfilm..nn.1
  agentkontor_1_N = mkN "agentkontor" neutrum  ; -- agentkontor..nn.1
  agentskap_1_N = mkN "agentskap" neutrum  ; -- agentskap..nn.1
  agentur_1_N = mkN "agentur" "agenturer" ; -- agentur..nn.1
  agera_1_V = mkV "agerar" ; -- agera..vb.1
  agera_2_V = mkV "agerar" ; -- agera..vb.2
  agerande_1_N = mkN "agerande" ; -- agerande..nn.1
  agerbar_1_A = mkA "agerbar" ; -- agerbar..av.1
  agerbarhet_1_N = mkN "agerbarhet" ; -- agerbarhet..nn.1
  ageusi_1_N = mkN "ageusi" ; -- ageusi..nn.1
  agg_1_N = mkN "agg" neutrum  ; -- agg..nn.1
  aggande_1_A = mkA "aggande" ; -- aggande..av.1
  aggfri_1_A = mkA "aggfri" "aggfritt" ; -- aggfri..av.1
  agglomerat_1_N = mkN "agglomerat" neutrum  ; -- agglomerat..nn.1
  agglomeration_1_N = mkN "agglomeration" ; -- agglomeration..nn.1
  agglomerera_1_V = mkV "agglomererar" ; -- agglomerera..vb.1
  agglomererande_1_N = mkN "agglomererande" ; -- agglomererande..nn.1
  agglomererbar_1_A = mkA "agglomererbar" ; -- agglomererbar..av.1
  agglomererbarhet_1_N = mkN "agglomererbarhet" ; -- agglomererbarhet..nn.1
  agglomerering_1_N = mkN "agglomerering" ; -- agglomerering..nn.1
  agglutination_1_N = mkN "agglutination" ; -- agglutination..nn.1
  agglutinera_1_V = mkV "agglutinerar" ; -- agglutinera..vb.1
  agglutinerande_1_N = mkN "agglutinerande" ; -- agglutinerande..nn.1
  agglutinerbar_1_A = mkA "agglutinerbar" ; -- agglutinerbar..av.1
  agglutinerbarhet_1_N = mkN "agglutinerbarhet" ; -- agglutinerbarhet..nn.1
  agglutinering_1_N = mkN "agglutinering" ; -- agglutinering..nn.1
  aggravera_1_V = mkV "aggraverar" ; -- aggravera..vb.1
  aggregat_1_N = mkN "aggregat" neutrum  ; -- aggregat..nn.1
  aggregation_1_N = mkN "aggregation" ; -- aggregation..nn.1
  aggregationsform_1_N = mkN "aggregationsform" "aggregationsformer" ; -- aggregationsform..nn.1
  aggregationstillstånd_1_N = mkN "aggregationstillstånd" neutrum  ; -- aggregationstillstånd..nn.1
  aggression_1_N = mkN "aggression" ; -- aggression..nn.1
  aggressionsbehov_1_N = mkN "aggressionsbehov" neutrum  ; -- aggressionsbehov..nn.1
  aggressionshämning_1_N = mkN "aggressionshämning" ; -- aggressionshämning..nn.1
  aggressiv_1_A = mkA "aggressiv" ; -- aggressiv..av.1
  aggressivitet_1_N = mkN "aggressivitet" "aggressiviteter" ; -- aggressivitet..nn.1
  agitation_1_N = mkN "agitation" ; -- agitation..nn.1
  agitationsresa_1_N = mkN "agitationsresa" ; -- agitationsresa..nn.1
  agitationsvisa_1_N = mkN "agitationsvisa" ; -- agitationsvisa..nn.1
  agitator_1_N = mkN "agitator" "agitatorer" ; -- agitator..nn.1
  agitatorisk_1_A = mkA "agitatorisk" ; -- agitatorisk..av.1
  agitera_1_V = mkV "agiterar" ; -- agitera..vb.1
  agiterande_1_N = mkN "agiterande" ; -- agiterande..nn.1
  agiterbar_1_A = mkA "agiterbar" ; -- agiterbar..av.1
  agiterbarhet_1_N = mkN "agiterbarhet" ; -- agiterbarhet..nn.1
  agitering_1_N = mkN "agitering" ; -- agitering..nn.1
  agn_1_N = mkN "agn" neutrum  ; -- agn..nn.1
  agna_1_V = mkV "agnar" ; -- agna..vb.1
  agnande_1_N = mkN "agnande" ; -- agnande..nn.1
  agnat_1_N = mkN "agnat" "agnater" ; -- agnat..nn.1
  agnatisk_1_A = mkA "agnatisk" ; -- agnatisk..av.1
  agnblommig_1_A = mkA "agnblommig" ; -- agnblommig..av.1
  agnborst_1_N = mkN "agnborst" neutrum  ; -- agnborst..nn.1
  agnosi_1_N = mkN "agnosi" "agnosier" ; -- agnosi..nn.1
  agnosticism_1_N = mkN "agnosticism" "agnosticismer" ; -- agnosticism..nn.1
  agnostiker_1_N = mkN "agnostiker" "agnostikern" "agnostiker" "agnostikerna" ; -- agnostiker..nn.1
  agnostisk_1_A = mkA "agnostisk" ; -- agnostisk..av.1
  agnrost_1_N = mkN "agnrost" ; -- agnrost..nn.1
  agogik_1_N = mkN "agogik" ; -- agogik..nn.1
  agoni_1_N = mkN "agoni" "agonier" ; -- agoni..nn.1
  agonistisk_1_A = mkA "agonistisk" ; -- agonistisk..av.1
  agorafobi_1_N = mkN "agorafobi" ; -- agorafobi..nn.1
  agraff_1_N = mkN "agraff" "agraffer" ; -- agraff..nn.1
  agrafi_1_N = mkN "agrafi" ; -- agrafi..nn.1
  agranulocytos_1_N = mkN "agranulocytos" ; -- agranulocytos..nn.1
  agrar_1_A = mkA "agrar" ; -- agrar..av.1
  agrar_1_N = mkN "agrar" "agrarer" ; -- agrar..nn.1
  agrarförbund_1_N = mkN "agrarförbund" neutrum  ; -- agrarförbund..nn.1
  agrarkommunistisk_1_A = mkA "agrarkommunistisk" ; -- agrarkommunistisk..av.1
  agrarpolitik_1_N = mkN "agrarpolitik" ; -- agrarpolitik..nn.1
  agreabel_1_A = mkA "agreabel" ; -- agreabel..av.1
  agremang_1_N = mkN "agremang" neutrum  ; -- agremang..nn.1
  agrikultur_1_N = mkN "agrikultur" ; -- agrikultur..nn.1
  agrikulturell_1_A = mkA "agrikulturell" ; -- agrikulturell..av.1
  agrikulturkemi_1_N = mkN "agrikulturkemi" ; -- agrikulturkemi..nn.1
  agronom_1_N = mkN "agronom" "agronomer" ; -- agronom..nn.1
  agronomi_1_N = mkN "agronomi" ; -- agronomi..nn.1
  agronomisk_1_A = mkA "agronomisk" ; -- agronomisk..av.1
  aguti_1_N = mkN "aguti" "agutin" "agutier" "agutierna" ; -- aguti..nn.1
  agyri_1_N = mkN "agyri" ; -- agyri..nn.1
  aha_upplevelse_1_N = mkN "aha-upplevelse" "aha-upplevelser" ; -- aha-upplevelse..nn.1
  ahaupplevelse_1_N = mkN "ahaupplevelse" "ahaupplevelser" ; -- ahaupplevelse..nn.1
  aids_demens_1_N = mkN "aids-demens" "aids-demenser" ; -- aids-demens..nn.1
  aids_1_N = mkN "aids" ; -- aids..nn.1
  aidsmedicin_1_N = mkN "aidsmedicin" "aidsmediciner" ; -- aidsmedicin..nn.1
  aidspanik_1_N = mkN "aidspanik" "aidspaniker" ; -- aidspanik..nn.1
  aidssjuk_1_A = mkA "aidssjuk" ; -- aidssjuk..av.1
  aikido_1_N = mkN "aikido" ; -- aikido..nn.1
  aikidotrick_1_N = mkN "aikidotrick" neutrum  ; -- aikidotrick..nn.1
  air_1_N = mkN "air" "airer" ; -- air..nn.1
  airbag_1_N = mkN "airbag" ; -- airbag..nn.1
  airbagsensor_1_N = mkN "airbagsensor" "airbagsensorer" ; -- airbagsensor..nn.1
  airdaleterrier_1_N = mkN "airdaleterrier" "airdaleterriern" "airdaleterrier" "airdaleterrierna" ; -- airdaleterrier..nn.1
  ajour_1_A = mkA "ajour" ; -- ajour..av.1
  ajournera_1_V = mkV "ajournerar" ; -- ajournera..vb.1
  ajournerande_1_N = mkN "ajournerande" ; -- ajournerande..nn.1
  ajournerbar_1_A = mkA "ajournerbar" ; -- ajournerbar..av.1
  ajournerbarhet_1_N = mkN "ajournerbarhet" ; -- ajournerbarhet..nn.1
  ajournering_1_N = mkN "ajournering" ; -- ajournering..nn.1
  ajowain_1_N = mkN "ajowain" ; -- ajowain..nn.1
  ajowan_1_N = mkN "ajowan" ; -- ajowan..nn.1
  ajwain_1_N = mkN "ajwain" ; -- ajwain..nn.1
  ajwan_1_N = mkN "ajwan" ; -- ajwan..nn.1
  akacia_1_N = mkN "akacia" ; -- akacia..nn.1
  akademi_1_N = mkN "akademi" "akademier" ; -- akademi..nn.1
  akademiker_1_N = mkN "akademiker" "akademikern" "akademiker" "akademikerna" ; -- akademiker..nn.1
  akademisk_1_A = mkA "akademisk" ; -- akademisk..av.1
  akademist_1_N = mkN "akademist" "akademister" ; -- akademist..nn.1
  akant_1_N = mkN "akant" "akanter" ; -- akant..nn.1
  akantolys_1_N = mkN "akantolys" "akantolyser" ; -- akantolys..nn.1
  akantom_1_N = mkN "akantom" neutrum  ; -- akantom..nn.1
  akantus_1_N = mkN "akantus" ; -- akantus..nn.1
  akantusblad_1_N = mkN "akantusblad" neutrum  ; -- akantusblad..nn.1
  akatalasemi_1_N = mkN "akatalasemi" ; -- akatalasemi..nn.1
  akatalektisk_1_A = mkA "akatalektisk" ; -- akatalektisk..av.1
  akilleshäl_1_N = mkN "akilleshäl" ; -- akilleshäl..nn.1
  akillessena_1_N = mkN "akillessena" ; -- akillessena..nn.1
  akleja_1_N = mkN "akleja" ; -- akleja..nn.1
  aklorhydri_1_N = mkN "aklorhydri" ; -- aklorhydri..nn.1
  akne_1_N = mkN "akne" utrum  ; -- akne..nn.1
  akneiformutslag_1_N = mkN "akneiformutslag" neutrum  ; -- akneiformutslag..nn.1
  akondroplasi_1_N = mkN "akondroplasi" ; -- akondroplasi..nn.1
  akribi_1_N = mkN "akribi" ; -- akribi..nn.1
  akro_osteolys_1_N = mkN "akro-osteolys" "akro-osteolyser" ; -- akro-osteolys..nn.1
  akrobat_1_N = mkN "akrobat" "akrobater" ; -- akrobat..nn.1
  akrobatik_1_N = mkN "akrobatik" ; -- akrobatik..nn.1
  akrobatisk_1_A = mkA "akrobatisk" ; -- akrobatisk..av.1
  akrobatisk_2_A = mkA "akrobatisk" ; -- akrobatisk..av.2
  akrocefali_1_N = mkN "akrocefali" ; -- akrocefali..nn.1
  akrocefalosyndaktyli_1_N = mkN "akrocefalosyndaktyli" ; -- akrocefalosyndaktyli..nn.1
  akrodermatit_1_N = mkN "akrodermatit" "akrodermatiter" ; -- akrodermatit..nn.1
  akrodyni_1_N = mkN "akrodyni" ; -- akrodyni..nn.1
  akromatisk_1_A = mkA "akromatisk" ; -- akromatisk..av.1
  akromegali_1_N = mkN "akromegali" "akromegalier" ; -- akromegali..nn.1
  akronym_1_N = mkN "akronym" "akronymer" ; -- akronym..nn.1
  akropol_1_N = mkN "akropol" "akropoler" ; -- akropol..nn.1
  akrospirom_1_N = mkN "akrospirom" neutrum  ; -- akrospirom..nn.1
  akrostikon_1_N = mkN "akrostikon" neutrum  ; -- akrostikon..nn.1
  akroterion_1_N = mkN "akroterion" "akroterion" "akroterier" "akroterierna" ; -- akroterion..nn.1
  akryl_1_N = mkN "akryl" ; -- akryl..nn.1
  akt_1_N = mkN "akt" "akter" ; -- akt..nn.1
  akta_1_V = mkV "aktar" ; -- akta..vb.1
  akta_2_V = mkV "aktar" ; -- akta..vb.2
  aktande_1_N = mkN "aktande" ; -- aktande..nn.1
  aktant_1_N = mkN "aktant" "aktanter" ; -- aktant..nn.1
  akter_1_N = mkN "akter" ; -- akter..nn.1
  akterdel_1_N = mkN "akterdel" "akterdelen" "akterdelar" "akterdelarna" ; -- akterdel..nn.1
  akterdäck_1_N = mkN "akterdäck" neutrum  ; -- akterdäck..nn.1
  akterhytt_1_N = mkN "akterhytt" "akterhytter" ; -- akterhytt..nn.1
  akterkastell_1_N = mkN "akterkastell" neutrum  ; -- akterkastell..nn.1
  akterlig_1_A = mkA "akterlig" ; -- akterlig..av.1
  akterlik_1_N = mkN "akterlik" neutrum  ; -- akterlik..nn.1
  aktersalong_1_N = mkN "aktersalong" "aktersalonger" ; -- aktersalong..nn.1
  aktersegel_1_N = mkN "aktersegel" neutrum  ; -- aktersegel..nn.1
  akterseglad_1_A = mkA "akterseglad" ; -- akterseglad..av.1
  akterskepp_1_N = mkN "akterskepp" neutrum  ; -- akterskepp..nn.1
  aktersnurra_1_N = mkN "aktersnurra" ; -- aktersnurra..nn.1
  akterspegel_1_N = mkN "akterspegel" ; -- akterspegel..nn.1
  akterst_1_Adv = mkAdv "akterst" ; -- akterst..ab.1
  akterstäv_1_N = mkN "akterstäv" ; -- akterstäv..nn.1
  akterut_1_Adv = mkAdv "akterut" ; -- akterut..ab.1
  akterända_1_N = mkN "akterända" ; -- akterända..nn.1
  akteröver_1_Adv = mkAdv "akteröver" ; -- akteröver..ab.1
  aktförklaring_1_N = mkN "aktförklaring" ; -- aktförklaring..nn.1
  aktgivning_1_N = mkN "aktgivning" ; -- aktgivning..nn.1
  aktie_1_N = mkN "aktie" "aktier" ; -- aktie..nn.1
  aktiebolag_1_N = mkN "aktiebolag" neutrum  ; -- aktiebolag..nn.1
  aktiebrev_1_N = mkN "aktiebrev" neutrum  ; -- aktiebrev..nn.1
  aktiebubbla_1_N = mkN "aktiebubbla" ; -- aktiebubbla..nn.1
  aktiebörs_1_N = mkN "aktiebörs" "aktiebörser" ; -- aktiebörs..nn.1
  aktieemission_1_N = mkN "aktieemission" ; -- aktieemission..nn.1
  aktiefond_1_N = mkN "aktiefond" "aktiefonder" ; -- aktiefond..nn.1
  aktiehandel_1_N = mkN "aktiehandel" ; -- aktiehandel..nn.1
  aktieinnehav_1_N = mkN "aktieinnehav" neutrum  ; -- aktieinnehav..nn.1
  aktiekapital_1_N = mkN "aktiekapital" neutrum  ; -- aktiekapital..nn.1
  aktiekupong_1_N = mkN "aktiekupong" "aktiekuponger" ; -- aktiekupong..nn.1
  aktiekurs_1_N = mkN "aktiekurs" "aktiekurser" ; -- aktiekurs..nn.1
  aktiemajoritet_1_N = mkN "aktiemajoritet" "aktiemajoriteter" ; -- aktiemajoritet..nn.1
  aktiemarknad_1_N = mkN "aktiemarknad" "aktiemarknader" ; -- aktiemarknad..nn.1
  aktieportfölj_1_N = mkN "aktieportfölj" "aktieportföljer" ; -- aktieportfölj..nn.1
  aktiepost_1_N = mkN "aktiepost" "aktieposter" ; -- aktiepost..nn.1
  aktiespara_1_V = mkV "aktiesparar" ; -- aktiespara..vb.1
  aktiesparande_1_N = mkN "aktiesparande" ; -- aktiesparande..nn.1
  aktiesparare_1_N = mkN "aktiesparare" utrum  ; -- aktiesparare..nn.1
  aktiesparklubb_1_N = mkN "aktiesparklubb" ; -- aktiesparklubb..nn.1
  aktiestock_1_N = mkN "aktiestock" ; -- aktiestock..nn.1
  aktieutdelning_1_N = mkN "aktieutdelning" ; -- aktieutdelning..nn.1
  aktievinst_1_N = mkN "aktievinst" "aktievinster" ; -- aktievinst..nn.1
  aktieägande_1_N = mkN "aktieägande" ; -- aktieägande..nn.1
  aktieägare_1_N = mkN "aktieägare" utrum  ; -- aktieägare..nn.1
  aktindelning_1_N = mkN "aktindelning" ; -- aktindelning..nn.1
  aktinium_1_N = mkN "aktinium" neutrum  ; -- aktinium..nn.1
  aktinobacillos_1_N = mkN "aktinobacillos" ; -- aktinobacillos..nn.1
  aktinomykos_1_N = mkN "aktinomykos" ; -- aktinomykos..nn.1
  aktion_1_N = mkN "aktion" ; -- aktion..nn.1
  aktionistisk_1_A = mkA "aktionistisk" ; -- aktionistisk..av.1
  aktionsart_1_N = mkN "aktionsart" "aktionsarter" ; -- aktionsart..nn.1
  aktionsgrupp_1_N = mkN "aktionsgrupp" "aktionsgrupper" ; -- aktionsgrupp..nn.1
  aktionsplan_1_N = mkN "aktionsplan" "aktionsplaner" ; -- aktionsplan..nn.1
  aktionsradie_1_N = mkN "aktionsradie" "aktionsradier" ; -- aktionsradie..nn.1
  aktionsström_1_N = mkN "aktionsström" "aktionsströmmen" "aktionsströmmar" "aktionsströmmarna" ; -- aktionsström..nn.1
  aktionssätt_1_N = mkN "aktionssätt" neutrum  ; -- aktionssätt..nn.1
  aktionsturbin_1_N = mkN "aktionsturbin" "aktionsturbiner" ; -- aktionsturbin..nn.1
  aktiv_1_A = mkA "aktiv" ; -- aktiv..av.1
  aktiva_1_N = mkN "aktiva" "aktivan" "aktiva" "aktivana" ; -- aktiva..nn.1
  aktivera_1_V = mkV "aktiverar" ; -- aktivera..vb.1
  aktiverande_1_N = mkN "aktiverande" ; -- aktiverande..nn.1
  aktiverbar_1_A = mkA "aktiverbar" ; -- aktiverbar..av.1
  aktiverbarhet_1_N = mkN "aktiverbarhet" ; -- aktiverbarhet..nn.1
  aktivering_1_N = mkN "aktivering" ; -- aktivering..nn.1
  aktiveringsmönster_1_N = mkN "aktiveringsmönster" neutrum  ; -- aktiveringsmönster..nn.1
  aktivism_1_N = mkN "aktivism" "aktivismer" ; -- aktivism..nn.1
  aktivist_1_N = mkN "aktivist" "aktivister" ; -- aktivist..nn.1
  aktivistisk_1_A = mkA "aktivistisk" ; -- aktivistisk..av.1
  aktivitet_1_N = mkN "aktivitet" "aktiviteter" ; -- aktivitet..nn.1
  aktivitetsersättning_1_N = mkN "aktivitetsersättning" ; -- aktivitetsersättning..nn.1
  aktivum_1_N = mkN "aktivum" "aktivum" "aktiver" "aktiverna" ; -- aktivum..nn.1
  aktning_1_N = mkN "aktning" ; -- aktning..nn.1
  aktningsbetygelse_1_N = mkN "aktningsbetygelse" "aktningsbetygelser" ; -- aktningsbetygelse..nn.1
  aktningsbevis_1_N = mkN "aktningsbevis" neutrum  ; -- aktningsbevis..nn.1
  aktningsfull_1_A = mkA "aktningsfull" ; -- aktningsfull..av.1
  aktningsfullhet_1_N = mkN "aktningsfullhet" ; -- aktningsfullhet..nn.1
  aktningsvärd_1_A = mkA "aktningsvärd" "aktningsvärt" ; -- aktningsvärd..av.1
  aktningsvärdhet_1_N = mkN "aktningsvärdhet" ; -- aktningsvärdhet..nn.1
  aktor_1_N = mkN "aktor" "aktorer" ; -- aktor..nn.1
  aktris_1_N = mkN "aktris" "aktriser" ; -- aktris..nn.1
  aktsam_1_A = mkA "aktsam" "aktsamt" "aktsamma" "aktsamma" "aktsammare" "aktsammast" "aktsammaste" ; -- aktsam..av.1
  aktsamhet_1_N = mkN "aktsamhet" "aktsamheter" ; -- aktsamhet..nn.1
  aktsamhetsplikt_1_N = mkN "aktsamhetsplikt" "aktsamhetsplikter" ; -- aktsamhetsplikt..nn.1
  aktslut_1_N = mkN "aktslut" neutrum  ; -- aktslut..nn.1
  aktstycke_1_N = mkN "aktstycke" ; -- aktstycke..nn.1
  aktualisation_1_N = mkN "aktualisation" ; -- aktualisation..nn.1
  aktualisera_1_V = mkV "aktualiserar" ; -- aktualisera..vb.1
  aktualiserande_1_N = mkN "aktualiserande" ; -- aktualiserande..nn.1
  aktualiserbar_1_A = mkA "aktualiserbar" ; -- aktualiserbar..av.1
  aktualiserbarhet_1_N = mkN "aktualiserbarhet" ; -- aktualiserbarhet..nn.1
  aktualisering_1_N = mkN "aktualisering" ; -- aktualisering..nn.1
  aktualism_1_N = mkN "aktualism" ; -- aktualism..nn.1
  aktualistisk_1_A = mkA "aktualistisk" ; -- aktualistisk..av.1
  aktualitet_1_N = mkN "aktualitet" "aktualiteter" ; -- aktualitet..nn.1
  aktualitetspress_1_N = mkN "aktualitetspress" ; -- aktualitetspress..nn.1
  aktuarie_1_N = mkN "aktuarie" "aktuarier" ; -- aktuarie..nn.1
  aktuell_1_A = mkA "aktuell" ; -- aktuell..av.1
  aktör_1_N = mkN "aktör" "aktörer" ; -- aktör..nn.1
  akupunktur_1_N = mkN "akupunktur" ; -- akupunktur..nn.1
  akupunktör_1_N = mkN "akupunktör" "akupunktörer" ; -- akupunktör..nn.1
  akustik_1_N = mkN "akustik" ; -- akustik..nn.1
  akustiker_1_N = mkN "akustiker" "akustikern" "akustiker" "akustikerna" ; -- akustiker..nn.1
  akustikplatta_1_N = mkN "akustikplatta" ; -- akustikplatta..nn.1
  akustikusneurinom_1_N = mkN "akustikusneurinom" neutrum  ; -- akustikusneurinom..nn.1
  akustisk_1_A = mkA "akustisk" ; -- akustisk..av.1
  akut_1_Adv = mkAdv "akut" ; -- akut..ab.1
  akut_1_A = mkA "akut" "akut" ; -- akut..av.1
  akut_1_N = mkN "akut" "akuter" ; -- akut..nn.1
  akutavdelning_1_N = mkN "akutavdelning" ; -- akutavdelning..nn.1
  akutfall_1_N = mkN "akutfall" neutrum  ; -- akutfall..nn.1
  akutfasreaktion_1_N = mkN "akutfasreaktion" ; -- akutfasreaktion..nn.1
  akuthjälp_1_N = mkN "akuthjälp" ; -- akuthjälp..nn.1
  akutmottagning_1_N = mkN "akutmottagning" ; -- akutmottagning..nn.1
  akutopererad_1_A = mkA "akutopererad" ; -- akutopererad..av.1
  akutvård_1_N = mkN "akutvård" ; -- akutvård..nn.1
  akutvårdsdata_1_N = mkN "akutvårdsdata" "akutvårdsdatat" "akutvårdsdata" "akutvårdsdatana" ; -- akutvårdsdata..nn.1
  akvakultur_1_N = mkN "akvakultur" "akvakulturer" ; -- akvakultur..nn.1
  akvamarin_1_N = mkN "akvamarin" "akvamariner" ; -- akvamarin..nn.1
  akvanaut_1_N = mkN "akvanaut" "akvanauter" ; -- akvanaut..nn.1
  akvaplaning_1_N = mkN "akvaplaning" ; -- akvaplaning..nn.1
  akvarell_1_N = mkN "akvarell" "akvareller" ; -- akvarell..nn.1
  akvarellfärg_1_N = mkN "akvarellfärg" "akvarellfärger" ; -- akvarellfärg..nn.1
  akvarellist_1_N = mkN "akvarellist" "akvarellister" ; -- akvarellist..nn.1
  akvarellmålare_1_N = mkN "akvarellmålare" utrum  ; -- akvarellmålare..nn.1
  akvarelltryck_1_N = mkN "akvarelltryck" neutrum  ; -- akvarelltryck..nn.1
  akvarellutställning_1_N = mkN "akvarellutställning" ; -- akvarellutställning..nn.1
  akvariefisk_1_N = mkN "akvariefisk" ; -- akvariefisk..nn.1
  akvaristik_1_N = mkN "akvaristik" ; -- akvaristik..nn.1
  akvaristisk_1_A = mkA "akvaristisk" ; -- akvaristisk..av.1
  akvarium_1_N = mkN "akvarium" "akvariet" "akvarier" "akvarierna" ; -- akvarium..nn.1
  akvatint_1_N = mkN "akvatint" "akvatinter" ; -- akvatint..nn.1
  akvatisk_1_A = mkA "akvatisk" ; -- akvatisk..av.1
  akvavit_1_N = mkN "akvavit" "akvaviter" ; -- akvavit..nn.1
  akvedukt_1_N = mkN "akvedukt" "akvedukter" ; -- akvedukt..nn.1
  al_1_N = mkN "al" ; -- al..nn.1
  alabaster_1_N = mkN "alabaster" ; -- alabaster..nn.1
  alabasterliknande_1_A = mkA "alabasterliknande" ; -- alabasterliknande..av.1
  alabastervit_1_A = mkA "alabastervit" ; -- alabastervit..av.1
  aladåb_1_N = mkN "aladåb" "aladåber" ; -- aladåb..nn.1
  alagreck_1_N = mkN "alagreck" "alagrecker" ; -- alagreck..nn.1
  alan_1_N = mkN "alan" "alaner" ; -- alan..nn.1
  alanin_1_N = mkN "alanin" neutrum  ; -- alanin..nn.1
  alant_1_N = mkN "alant" "alanter" ; -- alant..nn.1
  alarm_1_N = mkN "alarm" neutrum  ; -- alarm..nn.1
  alarm_2_N = mkN "alarm" neutrum  ; -- alarm..nn.2
  alarmanordning_1_N = mkN "alarmanordning" ; -- alarmanordning..nn.1
  alarmera_1_V = mkV "alarmerar" ; -- alarmera..vb.1
  alarmerande_1_A = mkA "alarmerande" ; -- alarmerande..av.1
  alarmerande_1_N = mkN "alarmerande" ; -- alarmerande..nn.1
  alarmerbar_1_A = mkA "alarmerbar" ; -- alarmerbar..av.1
  alarmerbarhet_1_N = mkN "alarmerbarhet" ; -- alarmerbarhet..nn.1
  alarmering_1_N = mkN "alarmering" ; -- alarmering..nn.1
  alarmism_1_N = mkN "alarmism" ; -- alarmism..nn.1
  alarmist_1_N = mkN "alarmist" "alarmister" ; -- alarmist..nn.1
  alarmistisk_1_A = mkA "alarmistisk" ; -- alarmistisk..av.1
  alarmklocka_1_N = mkN "alarmklocka" ; -- alarmklocka..nn.1
  alarmsignal_1_N = mkN "alarmsignal" "alarmsignaler" ; -- alarmsignal..nn.1
  alarmskott_1_N = mkN "alarmskott" neutrum  ; -- alarmskott..nn.1
  alarmtrumma_1_N = mkN "alarmtrumma" ; -- alarmtrumma..nn.1
  alba_1_N = mkN "alba" ; -- alba..nn.1
  alban_1_N = mkN "alban" "albaner" ; -- alban..nn.1
  albansk_1_A = mkA "albansk" ; -- albansk..av.1
  albanska_1_N = mkN "albanska" ; -- albanska..nn.1
  albanska_2_N = mkN "albanska" ; -- albanska..nn.2
  albatross_1_N = mkN "albatross" "albatrosser" ; -- albatross..nn.1
  albigens_1_N = mkN "albigens" "albigenser" ; -- albigens..nn.1
  albigenser_1_N = mkN "albigenser" "albigensern" "albigenser" "albigenserna" ; -- albigenser..nn.1
  albigensisk_1_A = mkA "albigensisk" ; -- albigensisk..av.1
  albinism_1_N = mkN "albinism" "albinismer" ; -- albinism..nn.1
  albinistisk_1_A = mkA "albinistisk" ; -- albinistisk..av.1
  albino_1_N = mkN "albino" "albinon" "albinos" "albinosarna" ; -- albino..nn.1
  album_1_N = mkN "album" neutrum  ; -- album..nn.1
  albumin_1_N = mkN "albumin" "albuminer" ; -- albumin..nn.1
  albuminuri_1_N = mkN "albuminuri" ; -- albuminuri..nn.1
  albuske_1_N = mkN "albuske" utrum  ; -- albuske..nn.1
  albyl_1_N = mkN "albyl" "albylen" "albyl" "albylen" ; -- albyl..nn.1
  alcantara_1_N = mkN "alcantara" ; -- alcantara..nn.1
  aldehyd_1_N = mkN "aldehyd" "aldehyder" ; -- aldehyd..nn.1
  aldrig_1_Adv = mkAdv "aldrig" ; -- aldrig..ab.1
  ale_1_N = mkN "ale" ; -- ale..nn.1
  alemann_1_N = mkN "alemann" "alemanner" ; -- alemann..nn.1
  alert_1_A = mkA "alert" "alert" ; -- alert..av.1
  alexanderhugg_1_N = mkN "alexanderhugg" neutrum  ; -- alexanderhugg..nn.1
  alexandrin_1_N = mkN "alexandrin" "alexandriner" ; -- alexandrin..nn.1
  alexandrinsk_1_A = mkA "alexandrinsk" ; -- alexandrinsk..av.1
  alexi_1_N = mkN "alexi" "alexier" ; -- alexi..nn.1
  alf_1_N = mkN "alf" "alfer" ; -- alf..nn.1
  alfa_1_N = mkN "alfa" "alfat" "alfan" "alfana" ; -- alfa..nn.1
  alfabet_1_N = mkN "alfabet" neutrum  ; -- alfabet..nn.1
  alfabetisera_1_V = mkV "alfabetiserar" ; -- alfabetisera..vb.1
  alfabetiserande_1_N = mkN "alfabetiserande" ; -- alfabetiserande..nn.1
  alfabetiserbar_1_A = mkA "alfabetiserbar" ; -- alfabetiserbar..av.1
  alfabetiserbarhet_1_N = mkN "alfabetiserbarhet" ; -- alfabetiserbarhet..nn.1
  alfabetisering_1_N = mkN "alfabetisering" ; -- alfabetisering..nn.1
  alfabetisk_1_A = mkA "alfabetisk" ; -- alfabetisk..av.1
  alfahanne_1_N = mkN "alfahanne" utrum  ; -- alfahanne..nn.1
  alfalfa_1_N = mkN "alfalfa" ; -- alfalfa..nn.1
  alfamannosidos_1_N = mkN "alfamannosidos" ; -- alfamannosidos..nn.1
  alfametyltyrosin_1_N = mkN "alfametyltyrosin" "alfametyltyrosiner" ; -- alfametyltyrosin..nn.1
  alfanumerisk_1_A = mkA "alfanumerisk" ; -- alfanumerisk..av.1
  alfapartikel_1_N = mkN "alfapartikel" ; -- alfapartikel..nn.1
  alfapet_1_N = mkN "alfapet" neutrum  ; -- alfapet..nn.1
  alfastrålning_1_N = mkN "alfastrålning" ; -- alfastrålning..nn.1
  alfasönderfall_1_N = mkN "alfasönderfall" neutrum  ; -- alfasönderfall..nn.1
  alfatalassemi_1_N = mkN "alfatalassemi" ; -- alfatalassemi..nn.1
  alfavirusinfektion_1_N = mkN "alfavirusinfektion" ; -- alfavirusinfektion..nn.1
  alfkors_1_N = mkN "alfkors" neutrum  ; -- alfkors..nn.1
  alfons_1_N = mkN "alfons" "alfonser" ; -- alfons..nn.1
  alfågel_1_N = mkN "alfågel" ; -- alfågel..nn.1
  alfågelskytte_1_N = mkN "alfågelskytte" ; -- alfågelskytte..nn.1
  alförrädare_1_N = mkN "alförrädare" utrum  ; -- alförrädare..nn.1
  alg_1_N = mkN "alg" "alger" ; -- alg..nn.1
  algblomning_1_N = mkN "algblomning" ; -- algblomning..nn.1
  algebra_1_N = mkN "algebra" ; -- algebra..nn.1
  algebraiker_1_N = mkN "algebraiker" "algebraikern" "algebraiker" "algebraikerna" ; -- algebraiker..nn.1
  algebraisk_1_A = mkA "algebraisk" ; -- algebraisk..av.1
  algerier_1_N = mkN "algerier" "algeriern" "algerier" "algerierna" ; -- algerier..nn.1
  algerisk_1_A = mkA "algerisk" ; -- algerisk..av.1
  algeriska_1_N = mkN "algeriska" ; -- algeriska..nn.1
  algmatta_1_N = mkN "algmatta" ; -- algmatta..nn.1
  algolog_1_N = mkN "algolog" "algologer" ; -- algolog..nn.1
  algologi_1_N = mkN "algologi" ; -- algologi..nn.1
  algologisk_1_A = mkA "algologisk" ; -- algologisk..av.1
  algonk_1_N = mkN "algonk" ; -- algonk..nn.1
  algoritm_1_N = mkN "algoritm" "algoritmer" ; -- algoritm..nn.1
  algren_1_N = mkN "algren" "algrenen" "algrenar" "algrenarna" ; -- algren..nn.1
  algtvätt_1_N = mkN "algtvätt" ; -- algtvätt..nn.1
  alibi_1_N = mkN "alibi" "alibit" "alibin" "alibina" ; -- alibi..nn.1
  alibibevis_1_N = mkN "alibibevis" neutrum  ; -- alibibevis..nn.1
  alibistisk_1_A = mkA "alibistisk" ; -- alibistisk..av.1
  alienation_1_N = mkN "alienation" ; -- alienation..nn.1
  alienationsupplevelse_1_N = mkN "alienationsupplevelse" "alienationsupplevelser" ; -- alienationsupplevelse..nn.1
  alienera_1_V = mkV "alienerar" ; -- alienera..vb.1
  alienerande_1_N = mkN "alienerande" ; -- alienerande..nn.1
  alienerbar_1_A = mkA "alienerbar" ; -- alienerbar..av.1
  alienerbarhet_1_N = mkN "alienerbarhet" ; -- alienerbarhet..nn.1
  alienering_1_N = mkN "alienering" ; -- alienering..nn.1
  alifatisk_1_A = mkA "alifatisk" ; -- alifatisk..av.1
  alika_1_N = mkN "alika" ; -- alika..nn.1
  alimentär_1_A = mkA "alimentär" ; -- alimentär..av.1
  alisarin_1_N = mkN "alisarin" ; -- alisarin..nn.1
  alka_1_N = mkN "alka" ; -- alka..nn.1
  alkaisk_1_A = mkA "alkaisk" ; -- alkaisk..av.1
  alkali_1_N = mkN "alkali" "alkalit" "alkalier" "alkalierna" ; -- alkali..nn.1
  alkaliblått_1_N = mkN "alkaliblått" ; -- alkaliblått..nn.1
  alkalilut_1_N = mkN "alkalilut" ; -- alkalilut..nn.1
  alkalimetall_1_N = mkN "alkalimetall" "alkalimetaller" ; -- alkalimetall..nn.1
  alkalisk_1_A = mkA "alkalisk" ; -- alkalisk..av.1
  alkaloid_1_N = mkN "alkaloid" "alkaloider" ; -- alkaloid..nn.1
  alkalos_1_N = mkN "alkalos" "alkaloser" ; -- alkalos..nn.1
  alkan_1_N = mkN "alkan" "alkaner" ; -- alkan..nn.1
  alkanna_1_N = mkN "alkanna" ; -- alkanna..nn.1
  alkanol_1_N = mkN "alkanol" "alkanoler" ; -- alkanol..nn.1
  alkaptonuri_1_N = mkN "alkaptonuri" ; -- alkaptonuri..nn.1
  alkekung_1_N = mkN "alkekung" ; -- alkekung..nn.1
  alkemi_1_N = mkN "alkemi" ; -- alkemi..nn.1
  alkemisk_1_A = mkA "alkemisk" ; -- alkemisk..av.1
  alkemist_1_N = mkN "alkemist" "alkemister" ; -- alkemist..nn.1
  alkemistisk_1_A = mkA "alkemistisk" ; -- alkemistisk..av.1
  alkfågel_1_N = mkN "alkfågel" ; -- alkfågel..nn.1
  alkis_1_N = mkN "alkis" ; -- alkis..nn.1
  alkohol_1_N = mkN "alkohol" "alkoholer" ; -- alkohol..nn.1
  alkoholabstinens_1_N = mkN "alkoholabstinens" ; -- alkoholabstinens..nn.1
  alkoholabstinensanfall_1_N = mkN "alkoholabstinensanfall" neutrum  ; -- alkoholabstinensanfall..nn.1
  alkoholberusning_1_N = mkN "alkoholberusning" ; -- alkoholberusning..nn.1
  alkoholcirrhos_1_N = mkN "alkoholcirrhos" "alkoholcirrhoser" ; -- alkoholcirrhos..nn.1
  alkoholcirros_1_N = mkN "alkoholcirros" "alkoholcirroser" ; -- alkoholcirros..nn.1
  alkoholfri_1_A = mkA "alkoholfri" "alkoholfritt" ; -- alkoholfri..av.1
  alkoholförbud_1_N = mkN "alkoholförbud" neutrum  ; -- alkoholförbud..nn.1
  alkoholförgiftning_1_N = mkN "alkoholförgiftning" ; -- alkoholförgiftning..nn.1
  alkoholförtäring_1_N = mkN "alkoholförtäring" ; -- alkoholförtäring..nn.1
  alkoholhalt_1_N = mkN "alkoholhalt" "alkoholhalter" ; -- alkoholhalt..nn.1
  alkoholhaltig_1_A = mkA "alkoholhaltig" ; -- alkoholhaltig..av.1
  alkoholinnehav_1_N = mkN "alkoholinnehav" neutrum  ; -- alkoholinnehav..nn.1
  alkoholintoxikation_1_N = mkN "alkoholintoxikation" ; -- alkoholintoxikation..nn.1
  alkoholiserad_1_A = mkA "alkoholiserad" ; -- alkoholiserad..av.1
  alkoholisk_1_A = mkA "alkoholisk" ; -- alkoholisk..av.1
  alkoholism_1_N = mkN "alkoholism" "alkoholismer" ; -- alkoholism..nn.1
  alkoholist_1_N = mkN "alkoholist" "alkoholister" ; -- alkoholist..nn.1
  alkoholistanstalt_1_N = mkN "alkoholistanstalt" "alkoholistanstalter" ; -- alkoholistanstalt..nn.1
  alkoholistisk_1_A = mkA "alkoholistisk" ; -- alkoholistisk..av.1
  alkoholkardiomyopati_1_N = mkN "alkoholkardiomyopati" "alkoholkardiomyopatier" ; -- alkoholkardiomyopati..nn.1
  alkoholkonsumtion_1_N = mkN "alkoholkonsumtion" ; -- alkoholkonsumtion..nn.1
  alkoholmissbruk_1_N = mkN "alkoholmissbruk" neutrum  ; -- alkoholmissbruk..nn.1
  alkoholmissbrukande_1_N = mkN "alkoholmissbrukande" ; -- alkoholmissbrukande..nn.1
  alkoholmissbrukare_1_N = mkN "alkoholmissbrukare" utrum  ; -- alkoholmissbrukare..nn.1
  alkoholneuropati_1_N = mkN "alkoholneuropati" "alkoholneuropatier" ; -- alkoholneuropati..nn.1
  alkoholometer_1_N = mkN "alkoholometer" ; -- alkoholometer..nn.1
  alkoholpolicy_1_N = mkN "alkoholpolicy" "alkoholpolicyn" "alkoholpolicysar" "alkoholpolicysarna" ; -- alkoholpolicy..nn.1
  alkoholpolitik_1_N = mkN "alkoholpolitik" ; -- alkoholpolitik..nn.1
  alkoholpolitisk_1_A = mkA "alkoholpolitisk" ; -- alkoholpolitisk..av.1
  alkoholpsykos_1_N = mkN "alkoholpsykos" "alkoholpsykoser" ; -- alkoholpsykos..nn.1
  alkoholpåverkad_1_A = mkA "alkoholpåverkad" ; -- alkoholpåverkad..av.1
  alkoholrelaterad_1_A = mkA "alkoholrelaterad" ; -- alkoholrelaterad..av.1
  alkoholskada_1_N = mkN "alkoholskada" ; -- alkoholskada..nn.1
  alkoholskatt_1_N = mkN "alkoholskatt" "alkoholskatter" ; -- alkoholskatt..nn.1
  alkoholstark_1_A = mkA "alkoholstark" ; -- alkoholstark..av.1
  alkoholstyrka_1_N = mkN "alkoholstyrka" ; -- alkoholstyrka..nn.1
  alkoholsvag_1_A = mkA "alkoholsvag" ; -- alkoholsvag..av.1
  alkoholsvaghet_1_N = mkN "alkoholsvaghet" ; -- alkoholsvaghet..nn.1
  alkoholtest_1_N = mkN "alkoholtest" neutrum  ; -- alkoholtest..nn.1
  alkoholvana_1_N = mkN "alkoholvana" ; -- alkoholvana..nn.1
  alkolås_1_N = mkN "alkolås" neutrum  ; -- alkolås..nn.1
  alkotest_1_N = mkN "alkotest" neutrum  ; -- alkotest..nn.1
  alkotte_1_N = mkN "alkotte" utrum  ; -- alkotte..nn.1
  alkov_1_N = mkN "alkov" "alkover" ; -- alkov..nn.1
  alkovsäng_1_N = mkN "alkovsäng" ; -- alkovsäng..nn.1
  alkyd_1_N = mkN "alkyd" "alkyder" ; -- alkyd..nn.1
  alkyl_1_N = mkN "alkyl" "alkyler" ; -- alkyl..nn.1
  alkyn_1_N = mkN "alkyn" "alkyner" ; -- alkyn..nn.1
  alla_1_N = mkN "alla" ; -- alla..nn.1
  allativ_1_N = mkN "allativ" "allativer" ; -- allativ..nn.1
  allbekant_1_A = mkA "allbekant" "allbekant" ; -- allbekant..av.1
  alldaglig_1_A = mkA "alldaglig" ; -- alldaglig..av.1
  alldaglighet_1_N = mkN "alldaglighet" ; -- alldaglighet..nn.1
  alldeles_1_Adv = mkAdv "alldeles" ; -- alldeles..ab.1
  allegat_1_N = mkN "allegat" neutrum  ; -- allegat..nn.1
  allegori_1_N = mkN "allegori" "allegorier" ; -- allegori..nn.1
  allegorisera_1_V = mkV "allegoriserar" ; -- allegorisera..vb.1
  allegoriserande_1_N = mkN "allegoriserande" ; -- allegoriserande..nn.1
  allegoriserbar_1_A = mkA "allegoriserbar" ; -- allegoriserbar..av.1
  allegoriserbarhet_1_N = mkN "allegoriserbarhet" ; -- allegoriserbarhet..nn.1
  allegorisering_1_N = mkN "allegorisering" ; -- allegorisering..nn.1
  allegorisk_1_A = mkA "allegorisk" ; -- allegorisk..av.1
  allegretto_1_N = mkN "allegretto" "allegrettot" "allegretton" "allegrettona" ; -- allegretto..nn.1
  allegro_1_N = mkN "allegro" "allegrot" "allegron" "allegrona" ; -- allegro..nn.1
  allegrosats_1_N = mkN "allegrosats" "allegrosatser" ; -- allegrosats..nn.1
  allehanda_1_A = mkA "allehanda" ; -- allehanda..av.1
  allel_1_N = mkN "allel" "alleler" ; -- allel..nn.1
  allemansfond_1_N = mkN "allemansfond" "allemansfonder" ; -- allemansfond..nn.1
  allemansrätt_1_N = mkN "allemansrätt" ; -- allemansrätt..nn.1
  allen_1_A = mkA "allen" ; -- allen..av.1
  allena_1_A = mkA "allena" ; -- allena..av.1
  allenarådande_1_A = mkA "allenarådande" ; -- allenarådande..av.1
  allenastyre_1_N = mkN "allenastyre" ; -- allenastyre..nn.1
  allergen_1_A = mkA "allergen" "allergent" ; -- allergen..av.1
  allergen_1_N = mkN "allergen" neutrum  ; -- allergen..nn.1
  allergi_1_N = mkN "allergi" "allergier" ; -- allergi..nn.1
  allergiframkallande_1_A = mkA "allergiframkallande" ; -- allergiframkallande..av.1
  allergiker_1_N = mkN "allergiker" "allergikern" "allergiker" "allergikerna" ; -- allergiker..nn.1
  allergimedicin_1_N = mkN "allergimedicin" "allergimediciner" ; -- allergimedicin..nn.1
  allergisk_1_A = mkA "allergisk" ; -- allergisk..av.1
  allergitablett_1_N = mkN "allergitablett" "allergitabletter" ; -- allergitablett..nn.1
  allergolog_1_N = mkN "allergolog" "allergologer" ; -- allergolog..nn.1
  allergologi_1_N = mkN "allergologi" ; -- allergologi..nn.1
  allestädesnärvarande_1_A = mkA "allestädesnärvarande" ; -- allestädesnärvarande..av.1
  alleuropeisk_1_A = mkA "alleuropeisk" ; -- alleuropeisk..av.1
  allfader_1_N = mkN "allfader" ; -- allfader..nn.1
  allfarväg_1_N = mkN "allfarväg" ; -- allfarväg..nn.1
  allgod_1_A = mkA "allgod" ; -- allgod..av.1
  allgodhet_1_N = mkN "allgodhet" ; -- allgodhet..nn.1
  allhelgonadag_1_N = mkN "allhelgonadag" ; -- allhelgonadag..nn.1
  allhelgonamässa_1_N = mkN "allhelgonamässa" ; -- allhelgonamässa..nn.1
  allhärskare_1_N = mkN "allhärskare" utrum  ; -- allhärskare..nn.1
  allians_1_N = mkN "allians" "allianser" ; -- allians..nn.1
  alliansfri_1_A = mkA "alliansfri" "alliansfritt" ; -- alliansfri..av.1
  allianskollega_1_N = mkN "allianskollega" ; -- allianskollega..nn.1
  alliansparti_1_N = mkN "alliansparti" "allianspartiet" "allianspartier" "allianspartierna" ; -- alliansparti..nn.1
  alliansregering_1_N = mkN "alliansregering" ; -- alliansregering..nn.1
  alliansring_1_N = mkN "alliansring" ; -- alliansring..nn.1
  alliera_1_V = mkV "allierar" ; -- alliera..vb.1
  allierad_1_A = mkA "allierad" ; -- allierad..av.1
  allierande_1_N = mkN "allierande" ; -- allierande..nn.1
  allierbar_1_A = mkA "allierbar" ; -- allierbar..av.1
  allierbarhet_1_N = mkN "allierbarhet" ; -- allierbarhet..nn.1
  alliering_1_N = mkN "alliering" ; -- alliering..nn.1
  alligator_1_N = mkN "alligator" "alligatorer" ; -- alligator..nn.1
  allitteration_1_N = mkN "allitteration" ; -- allitteration..nn.1
  allitterera_1_V = mkV "allittererar" ; -- allitterera..vb.1
  allittererande_1_N = mkN "allittererande" ; -- allittererande..nn.1
  allittererbar_1_A = mkA "allittererbar" ; -- allittererbar..av.1
  allittererbarhet_1_N = mkN "allittererbarhet" ; -- allittererbarhet..nn.1
  allitterering_1_N = mkN "allitterering" ; -- allitterering..nn.1
  allkonstnär_1_N = mkN "allkonstnär" "allkonstnärer" ; -- allkonstnär..nn.1
  allkonstverk_1_N = mkN "allkonstverk" neutrum  ; -- allkonstverk..nn.1
  allmakt_1_N = mkN "allmakt" ; -- allmakt..nn.1
  allmaktsord_1_N = mkN "allmaktsord" neutrum  ; -- allmaktsord..nn.1
  allmoge_1_N = mkN "allmoge" utrum  ; -- allmoge..nn.1
  allmogeblå_1_A = mkA "allmogeblå" "allmogeblått" ; -- allmogeblå..av.1
  allmogebroderi_1_N = mkN "allmogebroderi" "allmogebroderiet" "allmogebroderier" "allmogebroderierna" ; -- allmogebroderi..nn.1
  allmogedräkt_1_N = mkN "allmogedräkt" "allmogedräkter" ; -- allmogedräkt..nn.1
  allmogekultur_1_N = mkN "allmogekultur" "allmogekulturer" ; -- allmogekultur..nn.1
  allmogemål_1_N = mkN "allmogemål" neutrum  ; -- allmogemål..nn.1
  allmogesed_1_N = mkN "allmogesed" "allmogeseder" ; -- allmogesed..nn.1
  allmogesmycke_1_N = mkN "allmogesmycke" ; -- allmogesmycke..nn.1
  allmogespråk_1_N = mkN "allmogespråk" neutrum  ; -- allmogespråk..nn.1
  allmogevävnad_1_N = mkN "allmogevävnad" "allmogevävnader" ; -- allmogevävnad..nn.1
  allmosa_1_N = mkN "allmosa" ; -- allmosa..nn.1
  allmän_1_A = mkA "allmän" "allmänt" "allmänna" "allmänna" "allmännare" "allmännast" "allmännaste" ; -- allmän..av.1
  allmänanda_1_N = mkN "allmänanda" ; -- allmänanda..nn.1
  allmänbefinnande_1_N = mkN "allmänbefinnande" ; -- allmänbefinnande..nn.1
  allmänbegrepp_1_N = mkN "allmänbegrepp" neutrum  ; -- allmänbegrepp..nn.1
  allmänbegåvning_1_N = mkN "allmänbegåvning" ; -- allmänbegåvning..nn.1
  allmänbegåvning_2_N = mkN "allmänbegåvning" ; -- allmänbegåvning..nn.2
  allmänbilda_1_V = mkV "allmänbildar" ; -- allmänbilda..vb.1
  allmänbildad_1_A = mkA "allmänbildad" ; -- allmänbildad..av.1
  allmänbildande_1_N = mkN "allmänbildande" ; -- allmänbildande..nn.1
  allmänbildning_1_N = mkN "allmänbildning" ; -- allmänbildning..nn.1
  allmänborgerlig_1_A = mkA "allmänborgerlig" ; -- allmänborgerlig..av.1
  allmänfarlig_1_A = mkA "allmänfarlig" ; -- allmänfarlig..av.1
  allmänfarlighet_1_N = mkN "allmänfarlighet" ; -- allmänfarlighet..nn.1
  allmängiltig_1_A = mkA "allmängiltig" ; -- allmängiltig..av.1
  allmängiltighet_1_N = mkN "allmängiltighet" "allmängiltigheter" ; -- allmängiltighet..nn.1
  allmängods_1_N = mkN "allmängods" neutrum  ; -- allmängods..nn.1
  allmänhet_1_N = mkN "allmänhet" "allmänheter" ; -- allmänhet..nn.1
  allmänhumanistisk_1_A = mkA "allmänhumanistisk" ; -- allmänhumanistisk..av.1
  allmänintresse_1_N = mkN "allmänintresse" ; -- allmänintresse..nn.1
  allmänläkare_1_N = mkN "allmänläkare" utrum  ; -- allmänläkare..nn.1
  allmänmodernistisk_1_A = mkA "allmänmodernistisk" ; -- allmänmodernistisk..av.1
  allmänmänsklig_1_A = mkA "allmänmänsklig" ; -- allmänmänsklig..av.1
  allmänmänsklighet_1_N = mkN "allmänmänsklighet" ; -- allmänmänsklighet..nn.1
  allmännelig_1_A = mkA "allmännelig" ; -- allmännelig..av.1
  allmännelighet_1_N = mkN "allmännelighet" ; -- allmännelighet..nn.1
  allmänning_1_N = mkN "allmänning" ; -- allmänning..nn.1
  allmännytta_1_N = mkN "allmännytta" ; -- allmännytta..nn.1
  allmännyttig_1_A = mkA "allmännyttig" ; -- allmännyttig..av.1
  allmännyttighet_1_N = mkN "allmännyttighet" ; -- allmännyttighet..nn.1
  allmänpolitisk_1_A = mkA "allmänpolitisk" ; -- allmänpolitisk..av.1
  allmänpraktiker_1_N = mkN "allmänpraktiker" "allmänpraktikern" "allmänpraktiker" "allmänpraktikerna" ; -- allmänpraktiker..nn.1
  allmänpraktiserande_1_A = mkA "allmänpraktiserande" ; -- allmänpraktiserande..av.1
  allmänprevention_1_N = mkN "allmänprevention" ; -- allmänprevention..nn.1
  allmänpreventiv_1_A = mkA "allmänpreventiv" ; -- allmänpreventiv..av.1
  allmäntillstånd_1_N = mkN "allmäntillstånd" neutrum  ; -- allmäntillstånd..nn.1
  allmäntjänstgöring_1_N = mkN "allmäntjänstgöring" ; -- allmäntjänstgöring..nn.1
  allnationell_1_A = mkA "allnationell" ; -- allnationell..av.1
  allod_1_N = mkN "allod" "allodet" "alloder" "alloderna" ; -- allod..nn.1
  allodial_1_A = mkA "allodial" ; -- allodial..av.1
  allodium_1_N = mkN "allodium" "allodiet" "allodier" "allodierna" ; -- allodium..nn.1
  allofon_1_N = mkN "allofon" "allofoner" ; -- allofon..nn.1
  allograf_1_N = mkN "allograf" "allografer" ; -- allograf..nn.1
  allokera_1_V = mkV "allokerar" ; -- allokera..vb.1
  allokerande_1_N = mkN "allokerande" ; -- allokerande..nn.1
  allokerbar_1_A = mkA "allokerbar" ; -- allokerbar..av.1
  allokerbarhet_1_N = mkN "allokerbarhet" ; -- allokerbarhet..nn.1
  allokering_1_N = mkN "allokering" ; -- allokering..nn.1
  allokton_1_A = mkA "allokton" ; -- allokton..av.1
  allokution_1_N = mkN "allokution" ; -- allokution..nn.1
  allomfattande_1_A = mkA "allomfattande" ; -- allomfattande..av.1
  allomorf_1_A = mkA "allomorf" ; -- allomorf..av.1
  allomorf_1_N = mkN "allomorf" "allomorfer" ; -- allomorf..nn.1
  allongeperuk_1_N = mkN "allongeperuk" "allongeperuker" ; -- allongeperuk..nn.1
  allopat_1_N = mkN "allopat" "allopater" ; -- allopat..nn.1
  allopati_1_N = mkN "allopati" ; -- allopati..nn.1
  allopatisk_1_A = mkA "allopatisk" ; -- allopatisk..av.1
  allraheligaste_1_A = mkA "allraheligaste" ; -- allraheligaste..av.1
  allriskförsäkring_1_N = mkN "allriskförsäkring" ; -- allriskförsäkring..nn.1
  allround_1_A = mkA "allround" ; -- allround..av.1
  allroundsåg_1_N = mkN "allroundsåg" ; -- allroundsåg..nn.1
  allrum_1_N = mkN "allrum" "allrummet" "allrum" "allrummen" ; -- allrum..nn.1
  allrådande_1_A = mkA "allrådande" ; -- allrådande..av.1
  alls_1_Adv = mkAdv "alls" ; -- alls..ab.1
  allseende_1_A = mkA "allseende" ; -- allseende..av.1
  allshärjarting_1_N = mkN "allshärjarting" neutrum  ; -- allshärjarting..nn.1
  allsidig_1_A = mkA "allsidig" ; -- allsidig..av.1
  allsidighet_1_N = mkN "allsidighet" ; -- allsidighet..nn.1
  allsköns_1_A = mkA "allsköns" ; -- allsköns..av.1
  allsmäktig_1_A = mkA "allsmäktig" ; -- allsmäktig..av.1
  allsmäktighet_1_N = mkN "allsmäktighet" ; -- allsmäktighet..nn.1
  allströmsapparat_1_N = mkN "allströmsapparat" "allströmsapparater" ; -- allströmsapparat..nn.1
  allsvensk_1_A = mkA "allsvensk" ; -- allsvensk..av.1
  allsvenska_1_N = mkN "allsvenska" ; -- allsvenska..nn.1
  allsvåldig_1_A = mkA "allsvåldig" ; -- allsvåldig..av.1
  allsvåldighet_1_N = mkN "allsvåldighet" ; -- allsvåldighet..nn.1
  allsång_1_N = mkN "allsång" "allsånger" ; -- allsång..nn.1
  allsångsledare_1_N = mkN "allsångsledare" utrum  ; -- allsångsledare..nn.1
  allt_1_Adv = mkAdv "allt" ; -- allt..ab.1
  allt_1_N = mkN "allt" neutrum  ; -- allt..nn.1
  alltemellan_1_Adv = mkAdv "alltemellan" ; -- alltemellan..ab.1
  alltemellanåt_1_Adv = mkAdv "alltemellanåt" ; -- alltemellanåt..ab.1
  alltframgent_1_Adv = mkAdv "alltframgent" ; -- alltframgent..ab.1
  alltför_1_Adv = mkAdv "alltför" ; -- alltför..ab.1
  alltiallo_1_N = mkN "alltiallo" "alltiallot" "alltiallon" "alltiallona" ; -- alltiallo..nn.1
  alltigenom_1_Adv = mkAdv "alltigenom" ; -- alltigenom..ab.1
  allting_1_N = mkN "allting" neutrum  ; -- allting..nn.1
  alltmer_1_Adv = mkAdv "alltmer" ; -- alltmer..ab.1
  alltmera_1_Adv = mkAdv "alltmera" ; -- alltmera..ab.1
  alltmindre_1_Adv = mkAdv "alltmindre" ; -- alltmindre..ab.1
  alltnog_1_Adv = mkAdv "alltnog" ; -- alltnog..ab.1
  alltomfattande_1_A = mkA "alltomfattande" ; -- alltomfattande..av.1
  alltså_1_Adv = mkAdv "alltså" ; -- alltså..ab.1
  alludera_1_V = mkV "alluderar" ; -- alludera..vb.1
  alluderande_1_N = mkN "alluderande" ; -- alluderande..nn.1
  alluderbar_1_A = mkA "alluderbar" ; -- alluderbar..av.1
  alluderbarhet_1_N = mkN "alluderbarhet" ; -- alluderbarhet..nn.1
  alludering_1_N = mkN "alludering" ; -- alludering..nn.1
  allusion_1_N = mkN "allusion" ; -- allusion..nn.1
  allusionsvis_1_Adv = mkAdv "allusionsvis" ; -- allusionsvis..ab.1
  alluvial_1_A = mkA "alluvial" ; -- alluvial..av.1
  alluvialbildning_1_N = mkN "alluvialbildning" ; -- alluvialbildning..nn.1
  alluvialland_1_N = mkN "alluvialland" neutrum  ; -- alluvialland..nn.1
  alluvialperiod_1_N = mkN "alluvialperiod" "alluvialperioder" ; -- alluvialperiod..nn.1
  alluvium_1_N = mkN "alluvium" "alluviet" "alluvier" "alluvierna" ; -- alluvium..nn.1
  allvar_1_N = mkN "allvar" neutrum  ; -- allvar..nn.1
  allvarlig_1_A = mkA "allvarlig" ; -- allvarlig..av.1
  allvarligen_1_Adv = mkAdv "allvarligen" ; -- allvarligen..ab.1
  allvarlighet_1_N = mkN "allvarlighet" ; -- allvarlighet..nn.1
  allvarsam_1_A = mkA "allvarsam" "allvarsamt" "allvarsamma" "allvarsamma" "allvarsammare" "allvarsammast" "allvarsammaste" ; -- allvarsam..av.1
  allvarsamhet_1_N = mkN "allvarsamhet" "allvarsamheter" ; -- allvarsamhet..nn.1
  allvarsord_1_N = mkN "allvarsord" neutrum  ; -- allvarsord..nn.1
  allvarstyngd_1_A = mkA "allvarstyngd" "allvarstyngt" ; -- allvarstyngd..av.1
  allvarstyngdhet_1_N = mkN "allvarstyngdhet" ; -- allvarstyngdhet..nn.1
  allvetande_1_A = mkA "allvetande" ; -- allvetande..av.1
  allvetare_1_N = mkN "allvetare" utrum  ; -- allvetare..nn.1
  allvis_1_A = mkA "allvis" ; -- allvis..av.1
  allvishet_1_N = mkN "allvishet" ; -- allvishet..nn.1
  allväders_1_A = mkA "allväders" ; -- allväders..av.1
  allvädersskydd_1_N = mkN "allvädersskydd" neutrum  ; -- allvädersskydd..nn.1
  allvädersstövel_1_N = mkN "allvädersstövel" ; -- allvädersstövel..nn.1
  allätande_1_A = mkA "allätande" ; -- allätande..av.1
  allätare_1_N = mkN "allätare" utrum  ; -- allätare..nn.1
  allé_1_N = mkN "allé" "alléer" ; -- allé..nn.1
  alm_1_N = mkN "alm" ; -- alm..nn.1
  almanack_1_N = mkN "almanack" "almanacker" ; -- almanack..nn.1
  almanacka_1_N = mkN "almanacka" ; -- almanacka..nn.1
  almanacksblad_1_N = mkN "almanacksblad" neutrum  ; -- almanacksblad..nn.1
  alme_1_N = mkN "alme" ; -- alme..nn.1
  almfällning_1_N = mkN "almfällning" ; -- almfällning..nn.1
  almgren_1_N = mkN "almgren" "almgrenen" "almgrenar" "almgrenarna" ; -- almgren..nn.1
  almsav_1_N = mkN "almsav" ; -- almsav..nn.1
  almsjuka_1_N = mkN "almsjuka" ; -- almsjuka..nn.1
  almstrid_1_N = mkN "almstrid" "almstrider" ; -- almstrid..nn.1
  aln_1_N = mkN "aln" ; -- aln..nn.1
  alnmått_1_N = mkN "alnmått" neutrum  ; -- alnmått..nn.1
  alnsbred_1_A = mkA "alnsbred" "alnsbrett" ; -- alnsbred..av.1
  alnsdjup_1_A = mkA "alnsdjup" ; -- alnsdjup..av.1
  alnshög_1_A = mkA "alnshög" ; -- alnshög..av.1
  alnslång_1_A = mkA "alnslång" ; -- alnslång..av.1
  aloe_1_N = mkN "aloe" "aloer" ; -- aloe..nn.1
  aloebaserad_1_A = mkA "aloebaserad" ; -- aloebaserad..av.1
  alopecia_1_N = mkN "alopecia" ; -- alopecia..nn.1
  alp_1_N = mkN "alp" "alper" ; -- alp..nn.1
  alpacka_1_N = mkN "alpacka" ; -- alpacka..nn.1
  alpacka_2_N = mkN "alpacka" ; -- alpacka..nn.2
  alpackatyg_1_N = mkN "alpackatyg" neutrum  ; -- alpackatyg..nn.1
  alpackaull_1_N = mkN "alpackaull" ; -- alpackaull..nn.1
  alpbestigning_1_N = mkN "alpbestigning" ; -- alpbestigning..nn.1
  alpget_1_N = mkN "alpget" "alpgetter" ; -- alpget..nn.1
  alphorn_1_N = mkN "alphorn" neutrum  ; -- alphorn..nn.1
  alpidyll_1_N = mkN "alpidyll" "alpidyller" ; -- alpidyll..nn.1
  alpin_1_A = mkA "alpin" ; -- alpin..av.1
  alpinism_1_N = mkN "alpinism" "alpinismer" ; -- alpinism..nn.1
  alpinist_1_N = mkN "alpinist" "alpinister" ; -- alpinist..nn.1
  alpinsk_1_A = mkA "alpinsk" ; -- alpinsk..av.1
  alpjägare_1_N = mkN "alpjägare" utrum  ; -- alpjägare..nn.1
  alpkedja_1_N = mkN "alpkedja" ; -- alpkedja..nn.1
  alpland_1_N = mkN "alpland" "alplandet" "alpländer" "alpländerna" ; -- alpland..nn.1
  alpregion_1_N = mkN "alpregion" ; -- alpregion..nn.1
  alpros_1_N = mkN "alpros" "alprosor" ; -- alpros..nn.1
  alpspets_1_N = mkN "alpspets" ; -- alpspets..nn.1
  alpstav_1_N = mkN "alpstav" ; -- alpstav..nn.1
  alpstig_1_N = mkN "alpstig" ; -- alpstig..nn.1
  alptopp_1_N = mkN "alptopp" ; -- alptopp..nn.1
  alpvandring_1_N = mkN "alpvandring" ; -- alpvandring..nn.1
  alpviol_1_N = mkN "alpviol" "alpvioler" ; -- alpviol..nn.1
  alpväg_1_N = mkN "alpväg" ; -- alpväg..nn.1
  alruna_1_N = mkN "alruna" ; -- alruna..nn.1
  alsikeklöver_1_N = mkN "alsikeklöver" ; -- alsikeklöver..nn.1
  alspån_1_N = mkN "alspån" neutrum  ; -- alspån..nn.1
  alster_1_N = mkN "alster" neutrum  ; -- alster..nn.1
  alstra_1_V = mkV "alstrar" ; -- alstra..vb.1
  alstrande_1_N = mkN "alstrande" ; -- alstrande..nn.1
  alstrare_1_N = mkN "alstrare" utrum  ; -- alstrare..nn.1
  alstring_1_N = mkN "alstring" ; -- alstring..nn.1
  alt_1_N = mkN "alt" ; -- alt..nn.1
  altaisk_1_A = mkA "altaisk" ; -- altaisk..av.1
  altan_1_N = mkN "altan" "altaner" ; -- altan..nn.1
  altanbräda_1_N = mkN "altanbräda" ; -- altanbräda..nn.1
  altandörr_1_N = mkN "altandörr" ; -- altandörr..nn.1
  altanfäste_1_N = mkN "altanfäste" ; -- altanfäste..nn.1
  altarbild_1_N = mkN "altarbild" "altarbilder" ; -- altarbild..nn.1
  altarbord_1_N = mkN "altarbord" neutrum  ; -- altarbord..nn.1
  altarbrun_1_N = mkN "altarbrun" neutrum  ; -- altarbrun..nn.1
  altardisk_1_N = mkN "altardisk" ; -- altardisk..nn.1
  altarduk_1_N = mkN "altarduk" ; -- altarduk..nn.1
  altare_1_N = mkN "altare" "altaret" "altaren" "altarna" ; -- altare..nn.1
  altargång_1_N = mkN "altargång" ; -- altargång..nn.1
  altarkläde_1_N = mkN "altarkläde" ; -- altarkläde..nn.1
  altarkors_1_N = mkN "altarkors" neutrum  ; -- altarkors..nn.1
  altarkärl_1_N = mkN "altarkärl" neutrum  ; -- altarkärl..nn.1
  altarlykta_1_N = mkN "altarlykta" ; -- altarlykta..nn.1
  altarmålning_1_N = mkN "altarmålning" ; -- altarmålning..nn.1
  altarprydnad_1_N = mkN "altarprydnad" "altarprydnader" ; -- altarprydnad..nn.1
  altarring_1_N = mkN "altarring" ; -- altarring..nn.1
  altarrund_1_N = mkN "altarrund" "altarrunder" ; -- altarrund..nn.1
  altarskrud_1_N = mkN "altarskrud" ; -- altarskrud..nn.1
  altarskåp_1_N = mkN "altarskåp" neutrum  ; -- altarskåp..nn.1
  altartavla_1_N = mkN "altartavla" ; -- altartavla..nn.1
  altartjänst_1_N = mkN "altartjänst" "altartjänster" ; -- altartjänst..nn.1
  altaruppsats_1_N = mkN "altaruppsats" "altaruppsatser" ; -- altaruppsats..nn.1
  altbasun_1_N = mkN "altbasun" "altbasuner" ; -- altbasun..nn.1
  altea_1_N = mkN "altea" ; -- altea..nn.1
  alteasirap_1_N = mkN "alteasirap" ; -- alteasirap..nn.1
  alteration_1_N = mkN "alteration" ; -- alteration..nn.1
  altererad_1_A = mkA "altererad" ; -- altererad..av.1
  alternativ_1_A = mkA "alternativ" ; -- alternativ..av.1
  alternativ_1_N = mkN "alternativ" neutrum  ; -- alternativ..nn.1
  alternativfråga_1_N = mkN "alternativfråga" ; -- alternativfråga..nn.1
  alternativkurs_1_N = mkN "alternativkurs" "alternativkurser" ; -- alternativkurs..nn.1
  alternativt_1_Adv = mkAdv "alternativt" ; -- alternativt..ab.1
  alternatvinkel_1_N = mkN "alternatvinkel" ; -- alternatvinkel..nn.1
  alternera_1_V = mkV "alternerar" ; -- alternera..vb.1
  alternerande_1_N = mkN "alternerande" ; -- alternerande..nn.1
  alternerbar_1_A = mkA "alternerbar" ; -- alternerbar..av.1
  alternerbarhet_1_N = mkN "alternerbarhet" ; -- alternerbarhet..nn.1
  alternering_1_N = mkN "alternering" ; -- alternering..nn.1
  altfiol_1_N = mkN "altfiol" "altfioler" ; -- altfiol..nn.1
  altflöjt_1_N = mkN "altflöjt" "altflöjter" ; -- altflöjt..nn.1
  althorn_1_N = mkN "althorn" neutrum  ; -- althorn..nn.1
  altita_1_N = mkN "altita" ; -- altita..nn.1
  altitud_1_N = mkN "altitud" "altituder" ; -- altitud..nn.1
  altklarinett_1_N = mkN "altklarinett" "altklarinetter" ; -- altklarinett..nn.1
  altklav_1_N = mkN "altklav" "altklaver" ; -- altklav..nn.1
  altparti_1_N = mkN "altparti" "altpartiet" "altpartier" "altpartierna" ; -- altparti..nn.1
  altruism_1_N = mkN "altruism" "altruismer" ; -- altruism..nn.1
  altruist_1_N = mkN "altruist" "altruister" ; -- altruist..nn.1
  altruistisk_1_A = mkA "altruistisk" ; -- altruistisk..av.1
  altröst_1_N = mkN "altröst" "altröster" ; -- altröst..nn.1
  altsträng_1_N = mkN "altsträng" ; -- altsträng..nn.1
  altstämma_1_N = mkN "altstämma" ; -- altstämma..nn.1
  altsångare_1_N = mkN "altsångare" utrum  ; -- altsångare..nn.1
  altsångerska_1_N = mkN "altsångerska" ; -- altsångerska..nn.1
  altviolin_1_N = mkN "altviolin" "altvioliner" ; -- altviolin..nn.1
  aluminera_1_V = mkV "aluminerar" ; -- aluminera..vb.1
  aluminerande_1_N = mkN "aluminerande" ; -- aluminerande..nn.1
  aluminerbar_1_A = mkA "aluminerbar" ; -- aluminerbar..av.1
  aluminerbarhet_1_N = mkN "aluminerbarhet" ; -- aluminerbarhet..nn.1
  aluminering_1_N = mkN "aluminering" ; -- aluminering..nn.1
  aluminium_1_N = mkN "aluminium" neutrum  ; -- aluminium..nn.1
  aluminiumfabrik_1_N = mkN "aluminiumfabrik" "aluminiumfabriker" ; -- aluminiumfabrik..nn.1
  aluminiumfolie_1_N = mkN "aluminiumfolie" "aluminiumfolier" ; -- aluminiumfolie..nn.1
  aluminiumjon_1_N = mkN "aluminiumjon" "aluminiumjoner" ; -- aluminiumjon..nn.1
  aluminiumkärl_1_N = mkN "aluminiumkärl" neutrum  ; -- aluminiumkärl..nn.1
  aluminiumlinjal_1_N = mkN "aluminiumlinjal" "aluminiumlinjaler" ; -- aluminiumlinjal..nn.1
  aluminiumnät_1_N = mkN "aluminiumnät" neutrum  ; -- aluminiumnät..nn.1
  aluminiumpulver_1_N = mkN "aluminiumpulver" neutrum  ; -- aluminiumpulver..nn.1
  aluminiumsmältverk_1_N = mkN "aluminiumsmältverk" neutrum  ; -- aluminiumsmältverk..nn.1
  alumn_1_N = mkN "alumn" "alumner" ; -- alumn..nn.1
  alun_1_N = mkN "alun" ; -- alun..nn.1
  alunhaltig_1_A = mkA "alunhaltig" ; -- alunhaltig..av.1
  alunit_1_N = mkN "alunit" ; -- alunit..nn.1
  alunskiffer_1_N = mkN "alunskiffer" ; -- alunskiffer..nn.1
  alv_1_N = mkN "alv" ; -- alv..nn.1
  alv_2_N = mkN "alv" "alver" ; -- alv..nn.2
  alvar_1_N = mkN "alvar" ; -- alvar..nn.1
  alvarsmark_1_N = mkN "alvarsmark" "alvarsmarker" ; -- alvarsmark..nn.1
  alveol_1_N = mkN "alveol" "alveoler" ; -- alveol..nn.1
  alveolar_1_A = mkA "alveolar" ; -- alveolar..av.1
  alveolar_1_N = mkN "alveolar" "alveolarer" ; -- alveolar..nn.1
  alveolarben_1_N = mkN "alveolarben" neutrum  ; -- alveolarben..nn.1
  alveolarresorption_1_N = mkN "alveolarresorption" ; -- alveolarresorption..nn.1
  alvluckra_1_V = mkV "alvluckrar" ; -- alvluckra..vb.1
  alvluckrande_1_N = mkN "alvluckrande" ; -- alvluckrande..nn.1
  alvplog_1_N = mkN "alvplog" ; -- alvplog..nn.1
  alzheimer_1_N = mkN "alzheimer" ; -- alzheimer..nn.1
  alzheimers_1_N = mkN "alzheimers" ; -- alzheimers..nn.1
  amalgam_1_N = mkN "amalgam" neutrum  ; -- amalgam..nn.1
  amalgamera_1_V = mkV "amalgamerar" ; -- amalgamera..vb.1
  amalgamerande_1_N = mkN "amalgamerande" ; -- amalgamerande..nn.1
  amalgamerbar_1_A = mkA "amalgamerbar" ; -- amalgamerbar..av.1
  amalgamerbarhet_1_N = mkN "amalgamerbarhet" ; -- amalgamerbarhet..nn.1
  amalgamering_1_N = mkN "amalgamering" ; -- amalgamering..nn.1
  amanuens_1_N = mkN "amanuens" "amanuenser" ; -- amanuens..nn.1
  amarant_1_N = mkN "amarant" "amaranter" ; -- amarant..nn.1
  amaryllis_1_N = mkN "amaryllis" ; -- amaryllis..nn.1
  amason_1_N = mkN "amason" "amasoner" ; -- amason..nn.1
  amatör_1_N = mkN "amatör" "amatörer" ; -- amatör..nn.1
  amatörastronom_1_N = mkN "amatörastronom" "amatörastronomer" ; -- amatörastronom..nn.1
  amatörbestämmelse_1_N = mkN "amatörbestämmelse" "amatörbestämmelser" ; -- amatörbestämmelse..nn.1
  amatörbombtillverkning_1_N = mkN "amatörbombtillverkning" ; -- amatörbombtillverkning..nn.1
  amatörforskare_1_N = mkN "amatörforskare" utrum  ; -- amatörforskare..nn.1
  amatöridrott_1_N = mkN "amatöridrott" "amatöridrotter" ; -- amatöridrott..nn.1
  amatörism_1_N = mkN "amatörism" "amatörismer" ; -- amatörism..nn.1
  amatöristisk_1_A = mkA "amatöristisk" ; -- amatöristisk..av.1
  amatörmässig_1_A = mkA "amatörmässig" ; -- amatörmässig..av.1
  amatörmässighet_1_N = mkN "amatörmässighet" ; -- amatörmässighet..nn.1
  amatörmålare_1_N = mkN "amatörmålare" utrum  ; -- amatörmålare..nn.1
  amatörprojekt_1_N = mkN "amatörprojekt" neutrum  ; -- amatörprojekt..nn.1
  amatörregel_1_N = mkN "amatörregel" "amatörregeln" "amatörregler" "amatörreglerna" ; -- amatörregel..nn.1
  amatörsändare_1_N = mkN "amatörsändare" utrum  ; -- amatörsändare..nn.1
  amatörteater_1_N = mkN "amatörteater" ; -- amatörteater..nn.1
  amatörteleskop_1_N = mkN "amatörteleskop" neutrum  ; -- amatörteleskop..nn.1
  amatörvideo_1_N = mkN "amatörvideo" "amatörvideor" ; -- amatörvideo..nn.1
  amazon_1_N = mkN "amazon" "amazoner" ; -- amazon..nn.1
  ambassad_1_N = mkN "ambassad" "ambassader" ; -- ambassad..nn.1
  ambassadpersonal_1_N = mkN "ambassadpersonal" ; -- ambassadpersonal..nn.1
  ambassadris_1_N = mkN "ambassadris" "ambassadriser" ; -- ambassadris..nn.1
  ambassadråd_1_N = mkN "ambassadråd" neutrum  ; -- ambassadråd..nn.1
  ambassadsekreterare_1_N = mkN "ambassadsekreterare" utrum  ; -- ambassadsekreterare..nn.1
  ambassadör_1_N = mkN "ambassadör" "ambassadörer" ; -- ambassadör..nn.1
  ambassadörsmässig_1_A = mkA "ambassadörsmässig" ; -- ambassadörsmässig..av.1
  ambassadörspost_1_N = mkN "ambassadörspost" "ambassadörsposter" ; -- ambassadörspost..nn.1
  ambidexter_1_A = mkA "ambidexter" ; -- ambidexter..av.1
  ambidextri_1_N = mkN "ambidextri" ; -- ambidextri..nn.1
  ambiguitet_1_N = mkN "ambiguitet" "ambiguiteter" ; -- ambiguitet..nn.1
  ambiofoni_1_N = mkN "ambiofoni" ; -- ambiofoni..nn.1
  ambition_1_N = mkN "ambition" ; -- ambition..nn.1
  ambitionsnivå_1_N = mkN "ambitionsnivå" "ambitionsnivåer" ; -- ambitionsnivå..nn.1
  ambitionssak_1_N = mkN "ambitionssak" "ambitionssaker" ; -- ambitionssak..nn.1
  ambitiös_1_A = mkA "ambitiös" ; -- ambitiös..av.1
  ambivalens_1_N = mkN "ambivalens" ; -- ambivalens..nn.1
  ambivalent_1_A = mkA "ambivalent" "ambivalent" ; -- ambivalent..av.1
  amblyopi_1_N = mkN "amblyopi" ; -- amblyopi..nn.1
  ambra_1_N = mkN "ambra" ; -- ambra..nn.1
  ambradoft_1_N = mkN "ambradoft" ; -- ambradoft..nn.1
  ambrosia_1_N = mkN "ambrosia" ; -- ambrosia..nn.1
  ambrosisk_1_A = mkA "ambrosisk" ; -- ambrosisk..av.1
  ambulans_1_N = mkN "ambulans" "ambulanser" ; -- ambulans..nn.1
  ambulansflyg_1_N = mkN "ambulansflyg" neutrum  ; -- ambulansflyg..nn.1
  ambulansförare_1_N = mkN "ambulansförare" utrum  ; -- ambulansförare..nn.1
  ambulanshelikopter_1_N = mkN "ambulanshelikopter" ; -- ambulanshelikopter..nn.1
  ambulanskår_1_N = mkN "ambulanskår" "ambulanskårer" ; -- ambulanskår..nn.1
  ambulansman_1_N = mkN "ambulansman" "ambulansmannen" "ambulansmän" "ambulansmännen" ; -- ambulansman..nn.1
  ambulanspersonal_1_N = mkN "ambulanspersonal" ; -- ambulanspersonal..nn.1
  ambulanssjukskötare_1_N = mkN "ambulanssjukskötare" utrum  ; -- ambulanssjukskötare..nn.1
  ambulanssjuksköterska_1_N = mkN "ambulanssjuksköterska" ; -- ambulanssjuksköterska..nn.1
  ambulanssjukvårdare_1_N = mkN "ambulanssjukvårdare" utrum  ; -- ambulanssjukvårdare..nn.1
  ambulatorisk_1_A = mkA "ambulatorisk" ; -- ambulatorisk..av.1
  ambulera_1_V = mkV "ambulerar" ; -- ambulera..vb.1
  ambulerande_1_N = mkN "ambulerande" ; -- ambulerande..nn.1
  ambulerbar_1_A = mkA "ambulerbar" ; -- ambulerbar..av.1
  ambulerbarhet_1_N = mkN "ambulerbarhet" ; -- ambulerbarhet..nn.1
  ambulering_1_N = mkN "ambulering" ; -- ambulering..nn.1
  ameloblastom_1_N = mkN "ameloblastom" neutrum  ; -- ameloblastom..nn.1
  amendemang_1_N = mkN "amendemang" neutrum  ; -- amendemang..nn.1
  amenorre_1_N = mkN "amenorre" "amenorreen" "amenorreer" "amenorreerna" ; -- amenorre..nn.1
  americium_1_N = mkN "americium" neutrum  ; -- americium..nn.1
  amerikabiljett_1_N = mkN "amerikabiljett" "amerikabiljetter" ; -- amerikabiljett..nn.1
  amerikan_1_N = mkN "amerikan" "amerikaner" ; -- amerikan..nn.1
  amerikanare_1_N = mkN "amerikanare" utrum  ; -- amerikanare..nn.1
  amerikanisera_1_V = mkV "amerikaniserar" ; -- amerikanisera..vb.1
  amerikaniserande_1_N = mkN "amerikaniserande" ; -- amerikaniserande..nn.1
  amerikaniserbar_1_A = mkA "amerikaniserbar" ; -- amerikaniserbar..av.1
  amerikaniserbarhet_1_N = mkN "amerikaniserbarhet" ; -- amerikaniserbarhet..nn.1
  amerikanisering_1_N = mkN "amerikanisering" ; -- amerikanisering..nn.1
  amerikanism_1_N = mkN "amerikanism" "amerikanismer" ; -- amerikanism..nn.1
  amerikansk_1_A = mkA "amerikansk" ; -- amerikansk..av.1
  amerikanska_1_N = mkN "amerikanska" ; -- amerikanska..nn.1
  amerikanska_2_N = mkN "amerikanska" ; -- amerikanska..nn.2
  amerikansktillverkad_1_A = mkA "amerikansktillverkad" ; -- amerikansktillverkad..av.1
  ametist_1_N = mkN "ametist" "ametister" ; -- ametist..nn.1
  ametistblå_1_A = mkA "ametistblå" "ametistblått" ; -- ametistblå..av.1
  ametistsmycke_1_N = mkN "ametistsmycke" ; -- ametistsmycke..nn.1
  amfetamin_1_N = mkN "amfetamin" "amfetaminer" ; -- amfetamin..nn.1
  amfetaminbeslag_1_N = mkN "amfetaminbeslag" neutrum  ; -- amfetaminbeslag..nn.1
  amfetaminmissbruk_1_N = mkN "amfetaminmissbruk" neutrum  ; -- amfetaminmissbruk..nn.1
  amfibie_1_N = mkN "amfibie" "amfibier" ; -- amfibie..nn.1
  amfibieplan_1_N = mkN "amfibieplan" neutrum  ; -- amfibieplan..nn.1
  amfibisk_1_A = mkA "amfibisk" ; -- amfibisk..av.1
  amfibolit_1_N = mkN "amfibolit" "amfiboliter" ; -- amfibolit..nn.1
  amfiteater_1_N = mkN "amfiteater" ; -- amfiteater..nn.1
  amfiteatralisk_1_A = mkA "amfiteatralisk" ; -- amfiteatralisk..av.1
  amfora_1_N = mkN "amfora" ; -- amfora..nn.1
  ami_1_N = mkN "ami" "amier" ; -- ami..nn.1
  amid_1_N = mkN "amid" "amider" ; -- amid..nn.1
  amin_1_N = mkN "amin" "aminer" ; -- amin..nn.1
  aminosyra_1_N = mkN "aminosyra" ; -- aminosyra..nn.1
  amiral_1_N = mkN "amiral" "amiraler" ; -- amiral..nn.1
  amiralitet_1_N = mkN "amiralitet" neutrum  ; -- amiralitet..nn.1
  amiralsflagga_1_N = mkN "amiralsflagga" ; -- amiralsflagga..nn.1
  amiralsperson_1_N = mkN "amiralsperson" "amiralspersoner" ; -- amiralsperson..nn.1
  amiralstitel_1_N = mkN "amiralstitel" ; -- amiralstitel..nn.1
  amma_1_N = mkN "amma" ; -- amma..nn.1
  amma_1_V = mkV "ammar" ; -- amma..vb.1
  ammande_1_N = mkN "ammande" ; -- ammande..nn.1
  ammoniak_1_N = mkN "ammoniak" ; -- ammoniak..nn.1
  ammoniaklukt_1_N = mkN "ammoniaklukt" ; -- ammoniaklukt..nn.1
  ammoniaklösning_1_N = mkN "ammoniaklösning" ; -- ammoniaklösning..nn.1
  ammonit_1_N = mkN "ammonit" "ammoniter" ; -- ammonit..nn.1
  ammonium_1_N = mkN "ammonium" neutrum  ; -- ammonium..nn.1
  ammoniumklorid_1_N = mkN "ammoniumklorid" ; -- ammoniumklorid..nn.1
  ammoniumnitrat_1_N = mkN "ammoniumnitrat" "ammoniumnitrater" ; -- ammoniumnitrat..nn.1
  ammoniumnitratlösning_1_N = mkN "ammoniumnitratlösning" ; -- ammoniumnitratlösning..nn.1
  ammunition_1_N = mkN "ammunition" ; -- ammunition..nn.1
  ammunitionsväska_1_N = mkN "ammunitionsväska" ; -- ammunitionsväska..nn.1
  amnesi_1_N = mkN "amnesi" "amnesier" ; -- amnesi..nn.1
  amnesti_1_N = mkN "amnesti" "amnestier" ; -- amnesti..nn.1
  amnestidekret_1_N = mkN "amnestidekret" neutrum  ; -- amnestidekret..nn.1
  amnestilag_1_N = mkN "amnestilag" ; -- amnestilag..nn.1
  amning_1_N = mkN "amning" ; -- amning..nn.1
  amningsbehå_1_N = mkN "amningsbehå" ; -- amningsbehå..nn.1
  amningsdepression_1_N = mkN "amningsdepression" ; -- amningsdepression..nn.1
  amningsfanatiker_1_N = mkN "amningsfanatiker" "amningsfanatikern" "amningsfanatiker" "amningsfanatikerna" ; -- amningsfanatiker..nn.1
  amningsfanatism_1_N = mkN "amningsfanatism" ; -- amningsfanatism..nn.1
  amningsfascism_1_N = mkN "amningsfascism" ; -- amningsfascism..nn.1
  amningsfascist_1_N = mkN "amningsfascist" "amningsfascister" ; -- amningsfascist..nn.1
  amningsförakt_1_N = mkN "amningsförakt" neutrum  ; -- amningsförakt..nn.1
  amningsmobbare_1_N = mkN "amningsmobbare" utrum  ; -- amningsmobbare..nn.1
  amningssvårighet_1_N = mkN "amningssvårighet" "amningssvårigheter" ; -- amningssvårighet..nn.1
  amnionbandsyndrom_1_N = mkN "amnionbandsyndrom" neutrum  ; -- amnionbandsyndrom..nn.1
  amoebiasis_1_N = mkN "amoebiasis" ; -- amoebiasis..nn.1
  amoralisk_1_A = mkA "amoralisk" ; -- amoralisk..av.1
  amoralism_1_N = mkN "amoralism" "amoralismer" ; -- amoralism..nn.1
  amoralitet_1_N = mkN "amoralitet" "amoraliteter" ; -- amoralitet..nn.1
  amorbåge_1_N = mkN "amorbåge" utrum  ; -- amorbåge..nn.1
  amorf_1_A = mkA "amorf" ; -- amorf..av.1
  amorfism_1_N = mkN "amorfism" "amorfismer" ; -- amorfism..nn.1
  amorin_1_N = mkN "amorin" "amoriner" ; -- amorin..nn.1
  amortera_1_V = mkV "amorterar" ; -- amortera..vb.1
  amorterande_1_N = mkN "amorterande" ; -- amorterande..nn.1
  amorterbar_1_A = mkA "amorterbar" ; -- amorterbar..av.1
  amorterbarhet_1_N = mkN "amorterbarhet" ; -- amorterbarhet..nn.1
  amortering_1_N = mkN "amortering" ; -- amortering..nn.1
  amorteringsfond_1_N = mkN "amorteringsfond" "amorteringsfonder" ; -- amorteringsfond..nn.1
  amorteringsfri_1_A = mkA "amorteringsfri" "amorteringsfritt" ; -- amorteringsfri..av.1
  amorteringslån_1_N = mkN "amorteringslån" neutrum  ; -- amorteringslån..nn.1
  amorteringsplan_1_N = mkN "amorteringsplan" "amorteringsplaner" ; -- amorteringsplan..nn.1
  amorös_1_A = mkA "amorös" ; -- amorös..av.1
  ampel_1_A = mkA "ampel" ; -- ampel..av.1
  ampel_1_N = mkN "ampel" ; -- ampel..nn.1
  amper_1_A = mkA "amper" ; -- amper..av.1
  ampere_1_N = mkN "ampere" "amperen" "ampere" "amperena" ; -- ampere..nn.1
  amperemeter_1_N = mkN "amperemeter" ; -- amperemeter..nn.1
  amperesekund_1_N = mkN "amperesekund" "amperesekunder" ; -- amperesekund..nn.1
  amperevarv_1_N = mkN "amperevarv" neutrum  ; -- amperevarv..nn.1
  amperhet_1_N = mkN "amperhet" ; -- amperhet..nn.1
  amplifiera_1_V = mkV "amplifierar" ; -- amplifiera..vb.1
  amplifierande_1_N = mkN "amplifierande" ; -- amplifierande..nn.1
  amplifierbar_1_A = mkA "amplifierbar" ; -- amplifierbar..av.1
  amplifierbarhet_1_N = mkN "amplifierbarhet" ; -- amplifierbarhet..nn.1
  amplifiering_1_N = mkN "amplifiering" ; -- amplifiering..nn.1
  amplitud_1_N = mkN "amplitud" "amplituder" ; -- amplitud..nn.1
  amplitudmodulera_1_V = mkV "amplitudmodulerar" ; -- amplitudmodulera..vb.1
  amplitudmodulerande_1_N = mkN "amplitudmodulerande" ; -- amplitudmodulerande..nn.1
  amplitudmodulerbar_1_A = mkA "amplitudmodulerbar" ; -- amplitudmodulerbar..av.1
  amplitudmodulerbarhet_1_N = mkN "amplitudmodulerbarhet" ; -- amplitudmodulerbarhet..nn.1
  amplitudmodulering_1_N = mkN "amplitudmodulering" ; -- amplitudmodulering..nn.1
  ampull_1_N = mkN "ampull" "ampuller" ; -- ampull..nn.1
  amputation_1_N = mkN "amputation" ; -- amputation..nn.1
  amputera_1_V = mkV "amputerar" ; -- amputera..vb.1
  amputerande_1_N = mkN "amputerande" ; -- amputerande..nn.1
  amputerbar_1_A = mkA "amputerbar" ; -- amputerbar..av.1
  amputerbarhet_1_N = mkN "amputerbarhet" ; -- amputerbarhet..nn.1
  amputering_1_N = mkN "amputering" ; -- amputering..nn.1
  amsaga_1_N = mkN "amsaga" ; -- amsaga..nn.1
  amt_1_N = mkN "amt" neutrum  ; -- amt..nn.1
  amtman_1_N = mkN "amtman" "amtmannen" "amtmän" "amtmännen" ; -- amtman..nn.1
  amulett_1_N = mkN "amulett" "amuletter" ; -- amulett..nn.1
  amylas_1_N = mkN "amylas" "amylaser" ; -- amylas..nn.1
  amyloidneuropati_1_N = mkN "amyloidneuropati" "amyloidneuropatier" ; -- amyloidneuropati..nn.1
  amyloidos_1_N = mkN "amyloidos" "amyloidoser" ; -- amyloidos..nn.1
  amyloidplack_1_N = mkN "amyloidplack" ; -- amyloidplack..nn.1
  amyotrofi_1_N = mkN "amyotrofi" "amyotrofier" ; -- amyotrofi..nn.1
  amöba_1_N = mkN "amöba" ; -- amöba..nn.1
  amöbadysenteri_1_N = mkN "amöbadysenteri" ; -- amöbadysenteri..nn.1
  amöbainfektion_1_N = mkN "amöbainfektion" ; -- amöbainfektion..nn.1
  ana_1_V = mkV "anar" ; -- ana..vb.1
  anabaptism_1_N = mkN "anabaptism" "anabaptismer" ; -- anabaptism..nn.1
  anabaptist_1_N = mkN "anabaptist" "anabaptister" ; -- anabaptist..nn.1
  anabaptistisk_1_A = mkA "anabaptistisk" ; -- anabaptistisk..av.1
  anabatisk_1_A = mkA "anabatisk" ; -- anabatisk..av.1
  anabol_1_A = mkA "anabol" ; -- anabol..av.1
  anabol_1_N = mkN "anabol" "anaboler" ; -- anabol..nn.1
  anadrom_1_A = mkA "anadrom" ; -- anadrom..av.1
  anaerob_1_A = mkA "anaerob" ; -- anaerob..av.1
  anafor_1_N = mkN "anafor" "anaforen" "anaforer" "anaforerna" ; -- anafor..nn.1
  anaforisk_1_A = mkA "anaforisk" ; -- anaforisk..av.1
  anafylaxi_1_N = mkN "anafylaxi" "anafylaxier" ; -- anafylaxi..nn.1
  anagram_1_N = mkN "anagram" "anagrammet" "anagram" "anagrammen" ; -- anagram..nn.1
  anakolut_1_N = mkN "anakolut" "anakoluter" ; -- anakolut..nn.1
  anakolutisk_1_A = mkA "anakolutisk" ; -- anakolutisk..av.1
  anakonda_1_N = mkN "anakonda" ; -- anakonda..nn.1
  anakoret_1_N = mkN "anakoret" "anakoreter" ; -- anakoret..nn.1
  anakreontisk_1_A = mkA "anakreontisk" ; -- anakreontisk..av.1
  anakronism_1_N = mkN "anakronism" "anakronismer" ; -- anakronism..nn.1
  anakronistisk_1_A = mkA "anakronistisk" ; -- anakronistisk..av.1
  anal_1_A = mkA "anal" ; -- anal..av.1
  analatresi_1_N = mkN "analatresi" ; -- analatresi..nn.1
  analbuminemi_1_N = mkN "analbuminemi" ; -- analbuminemi..nn.1
  analcancer_1_N = mkN "analcancer" ; -- analcancer..nn.1
  analeptik_1_N = mkN "analeptik" ; -- analeptik..nn.1
  analfabet_1_N = mkN "analfabet" "analfabeter" ; -- analfabet..nn.1
  analfabetisk_1_A = mkA "analfabetisk" ; -- analfabetisk..av.1
  analfabetism_1_N = mkN "analfabetism" "analfabetismer" ; -- analfabetism..nn.1
  analfena_1_N = mkN "analfena" ; -- analfena..nn.1
  analfissur_1_N = mkN "analfissur" "analfissurer" ; -- analfissur..nn.1
  analgetika_1_N = mkN "analgetika" "analgetikat" "analgetika" "analgetikana" ; -- analgetika..nn.1
  analinkontinens_1_N = mkN "analinkontinens" "analinkontinenser" ; -- analinkontinens..nn.1
  analkörtel_1_N = mkN "analkörtel" ; -- analkörtel..nn.1
  analkörtelcancer_1_N = mkN "analkörtelcancer" ; -- analkörtelcancer..nn.1
  analkörteltumör_1_N = mkN "analkörteltumör" "analkörteltumörer" ; -- analkörteltumör..nn.1
  analog_1_A = mkA "analog" ; -- analog..av.1
  analogi_1_N = mkN "analogi" "analogier" ; -- analogi..nn.1
  analogibevis_1_N = mkN "analogibevis" neutrum  ; -- analogibevis..nn.1
  analogibildning_1_N = mkN "analogibildning" ; -- analogibildning..nn.1
  analogisk_1_A = mkA "analogisk" ; -- analogisk..av.1
  analogislut_1_N = mkN "analogislut" neutrum  ; -- analogislut..nn.1
  analsex_1_N = mkN "analsex" neutrum  ; -- analsex..nn.1
  analsfinkter_1_N = mkN "analsfinkter" ; -- analsfinkter..nn.1
  analsjukdom_1_N = mkN "analsjukdom" ; -- analsjukdom..nn.1
  analtumör_1_N = mkN "analtumör" "analtumörer" ; -- analtumör..nn.1
  analulcer_1_N = mkN "analulcer" "analulcerer" ; -- analulcer..nn.1
  analys_1_N = mkN "analys" "analyser" ; -- analys..nn.1
  analysera_1_V = mkV "analyserar" ; -- analysera..vb.1
  analyserande_1_N = mkN "analyserande" ; -- analyserande..nn.1
  analyserbar_1_A = mkA "analyserbar" ; -- analyserbar..av.1
  analyserbarhet_1_N = mkN "analyserbarhet" ; -- analyserbarhet..nn.1
  analysering_1_N = mkN "analysering" ; -- analysering..nn.1
  analysmetodik_1_N = mkN "analysmetodik" "analysmetodiker" ; -- analysmetodik..nn.1
  analytiker_1_N = mkN "analytiker" "analytikern" "analytiker" "analytikerna" ; -- analytiker..nn.1
  analytisk_1_A = mkA "analytisk" ; -- analytisk..av.1
  analöppning_1_N = mkN "analöppning" ; -- analöppning..nn.1
  anamma_1_V = mkV "anammar" ; -- anamma..vb.1
  anammande_1_N = mkN "anammande" ; -- anammande..nn.1
  anamnes_1_N = mkN "anamnes" "anamneser" ; -- anamnes..nn.1
  ananas_1_N = mkN "ananas" ; -- ananas..nn.1
  ananassallad_1_N = mkN "ananassallad" "ananassallader" ; -- ananassallad..nn.1
  anande_1_N = mkN "anande" ; -- anande..nn.1
  anapest_1_N = mkN "anapest" "anapester" ; -- anapest..nn.1
  anapestisk_1_A = mkA "anapestisk" ; -- anapestisk..av.1
  anaplasi_1_N = mkN "anaplasi" "anaplasier" ; -- anaplasi..nn.1
  anaplasmainfektion_1_N = mkN "anaplasmainfektion" ; -- anaplasmainfektion..nn.1
  anaplasmos_1_N = mkN "anaplasmos" ; -- anaplasmos..nn.1
  anarki_1_N = mkN "anarki" ; -- anarki..nn.1
  anarkisk_1_A = mkA "anarkisk" ; -- anarkisk..av.1
  anarkism_1_N = mkN "anarkism" "anarkismer" ; -- anarkism..nn.1
  anarkist_1_N = mkN "anarkist" "anarkister" ; -- anarkist..nn.1
  anarkistisk_1_A = mkA "anarkistisk" ; -- anarkistisk..av.1
  anarkokapitalistisk_1_A = mkA "anarkokapitalistisk" ; -- anarkokapitalistisk..av.1
  anarkokommunistisk_1_A = mkA "anarkokommunistisk" ; -- anarkokommunistisk..av.1
  anarkoprimitivistisk_1_A = mkA "anarkoprimitivistisk" ; -- anarkoprimitivistisk..av.1
  anarkosyndikalism_1_N = mkN "anarkosyndikalism" "anarkosyndikalismer" ; -- anarkosyndikalism..nn.1
  anarkosyndikalist_1_N = mkN "anarkosyndikalist" "anarkosyndikalister" ; -- anarkosyndikalist..nn.1
  anarkosyndikalistisk_1_A = mkA "anarkosyndikalistisk" ; -- anarkosyndikalistisk..av.1
  anastas_1_N = mkN "anastas" "anastaser" ; -- anastas..nn.1
  anastatisk_1_A = mkA "anastatisk" ; -- anastatisk..av.1
  anastigmatisk_1_A = mkA "anastigmatisk" ; -- anastigmatisk..av.1
  anastomos_1_N = mkN "anastomos" "anastomoser" ; -- anastomos..nn.1
  anastomosläckage_1_N = mkN "anastomosläckage" ; -- anastomosläckage..nn.1
  anatema_1_N = mkN "anatema" "anatemat" "anatemer" "anatemerna" ; -- anatema..nn.1
  anatolisk_1_A = mkA "anatolisk" ; -- anatolisk..av.1
  anatom_1_N = mkN "anatom" "anatomer" ; -- anatom..nn.1
  anatomi_1_N = mkN "anatomi" ; -- anatomi..nn.1
  anatomisal_1_N = mkN "anatomisal" ; -- anatomisal..nn.1
  anatomisk_1_A = mkA "anatomisk" ; -- anatomisk..av.1
  anbefalla_1_V = mkV "anbefaller" ; -- anbefalla..vb.1
  anbefallande_1_N = mkN "anbefallande" ; -- anbefallande..nn.1
  anbefallning_1_N = mkN "anbefallning" ; -- anbefallning..nn.1
  anbelanga_1_V = mkV "anbelangar" ; -- anbelanga..vb.1
  anbelangande_1_N = mkN "anbelangande" ; -- anbelangande..nn.1
  anblick_1_N = mkN "anblick" ; -- anblick..nn.1
  anblåspipa_1_N = mkN "anblåspipa" ; -- anblåspipa..nn.1
  anbringa_1_V = mkV "anbringar" ; -- anbringa..vb.1
  anbringande_1_N = mkN "anbringande" ; -- anbringande..nn.1
  anbringning_1_N = mkN "anbringning" ; -- anbringning..nn.1
  anbrott_1_N = mkN "anbrott" neutrum  ; -- anbrott..nn.1
  anbud_1_N = mkN "anbud" neutrum  ; -- anbud..nn.1
  anbudsgivare_1_N = mkN "anbudsgivare" utrum  ; -- anbudsgivare..nn.1
  ancestor_1_N = mkN "ancestor" "ancestorer" ; -- ancestor..nn.1
  anciennitet_1_N = mkN "anciennitet" "ancienniteter" ; -- anciennitet..nn.1
  and_1_N = mkN "and" "änder" ; -- and..nn.1
  and_2_N = mkN "and" ; -- and..nn.2
  anda_1_N = mkN "anda" ; -- anda..nn.1
  andakt_1_N = mkN "andakt" "andakter" ; -- andakt..nn.1
  andaktsbok_1_N = mkN "andaktsbok" "andaktsböcker" ; -- andaktsbok..nn.1
  andaktsfull_1_A = mkA "andaktsfull" ; -- andaktsfull..av.1
  andaktsfullhet_1_N = mkN "andaktsfullhet" ; -- andaktsfullhet..nn.1
  andaktslitteratur_1_N = mkN "andaktslitteratur" ; -- andaktslitteratur..nn.1
  andaktssal_1_N = mkN "andaktssal" ; -- andaktssal..nn.1
  andaktsstund_1_N = mkN "andaktsstund" "andaktsstunder" ; -- andaktsstund..nn.1
  andaktsutövning_1_N = mkN "andaktsutövning" ; -- andaktsutövning..nn.1
  andaktsövning_1_N = mkN "andaktsövning" ; -- andaktsövning..nn.1
  andalusisk_1_A = mkA "andalusisk" ; -- andalusisk..av.1
  andante_1_N = mkN "andante" ; -- andante..nn.1
  ande_1_N = mkN "ande" utrum  ; -- ande..nn.1
  andebesvärjare_1_N = mkN "andebesvärjare" utrum  ; -- andebesvärjare..nn.1
  andebesvärjelse_1_N = mkN "andebesvärjelse" "andebesvärjelser" ; -- andebesvärjelse..nn.1
  andedrag_1_N = mkN "andedrag" neutrum  ; -- andedrag..nn.1
  andedräkt_1_N = mkN "andedräkt" "andedräkter" ; -- andedräkt..nn.1
  andefattig_1_A = mkA "andefattig" ; -- andefattig..av.1
  andefattigdom_1_N = mkN "andefattigdom" ; -- andefattigdom..nn.1
  andefattighet_1_N = mkN "andefattighet" ; -- andefattighet..nn.1
  andekraft_1_N = mkN "andekraft" "andekrafter" ; -- andekraft..nn.1
  andel_1_N = mkN "andel" "andelen" "andelar" "andelarna" ; -- andel..nn.1
  andelsförening_1_N = mkN "andelsförening" ; -- andelsförening..nn.1
  andelös_1_A = mkA "andelös" ; -- andelös..av.1
  andelöshet_1_N = mkN "andelöshet" ; -- andelöshet..nn.1
  andemeddelande_1_N = mkN "andemeddelande" ; -- andemeddelande..nn.1
  andemening_1_N = mkN "andemening" ; -- andemening..nn.1
  anderike_1_N = mkN "anderike" ; -- anderike..nn.1
  anderöst_1_N = mkN "anderöst" "anderöster" ; -- anderöst..nn.1
  andeskådande_1_N = mkN "andeskådande" ; -- andeskådande..nn.1
  andeskådare_1_N = mkN "andeskådare" utrum  ; -- andeskådare..nn.1
  andeskåderi_1_N = mkN "andeskåderi" "andeskåderiet" "andeskåderier" "andeskåderierna" ; -- andeskåderi..nn.1
  andeskådning_1_N = mkN "andeskådning" ; -- andeskådning..nn.1
  andestämma_1_N = mkN "andestämma" ; -- andestämma..nn.1
  andesyn_1_N = mkN "andesyn" "andesyner" ; -- andesyn..nn.1
  andetag_1_N = mkN "andetag" neutrum  ; -- andetag..nn.1
  andeuppenbarelse_1_N = mkN "andeuppenbarelse" "andeuppenbarelser" ; -- andeuppenbarelse..nn.1
  andeutdrivare_1_N = mkN "andeutdrivare" utrum  ; -- andeutdrivare..nn.1
  andevärld_1_N = mkN "andevärld" ; -- andevärld..nn.1
  andeväsen_1_N = mkN "andeväsen" "andeväsendet" "andeväsen" "andeväsena" ; -- andeväsen..nn.1
  andfigur_1_N = mkN "andfigur" "andfigurer" ; -- andfigur..nn.1
  andfådd_1_A = mkA "andfådd" ; -- andfådd..av.1
  andfåddhet_1_N = mkN "andfåddhet" ; -- andfåddhet..nn.1
  andfågel_1_N = mkN "andfågel" ; -- andfågel..nn.1
  andhämtning_1_N = mkN "andhämtning" ; -- andhämtning..nn.1
  andhämtningspaus_1_N = mkN "andhämtningspaus" "andhämtningspauser" ; -- andhämtningspaus..nn.1
  andhål_1_N = mkN "andhål" neutrum  ; -- andhål..nn.1
  andjakt_1_N = mkN "andjakt" "andjakter" ; -- andjakt..nn.1
  andlig_1_A = mkA "andlig" ; -- andlig..av.1
  andligen_1_Adv = mkAdv "andligen" ; -- andligen..ab.1
  andlighet_1_N = mkN "andlighet" ; -- andlighet..nn.1
  andlös_1_A = mkA "andlös" ; -- andlös..av.1
  andlöshet_1_N = mkN "andlöshet" ; -- andlöshet..nn.1
  andmat_1_N = mkN "andmat" ; -- andmat..nn.1
  andning_1_N = mkN "andning" ; -- andning..nn.1
  andningsacidos_1_N = mkN "andningsacidos" ; -- andningsacidos..nn.1
  andningsalkalos_1_N = mkN "andningsalkalos" ; -- andningsalkalos..nn.1
  andningsapparat_1_N = mkN "andningsapparat" "andningsapparater" ; -- andningsapparat..nn.1
  andningsbesvär_1_N = mkN "andningsbesvär" neutrum  ; -- andningsbesvär..nn.1
  andningsenzym_1_N = mkN "andningsenzym" neutrum  ; -- andningsenzym..nn.1
  andningsförlamning_1_N = mkN "andningsförlamning" ; -- andningsförlamning..nn.1
  andningshjälp_1_N = mkN "andningshjälp" ; -- andningshjälp..nn.1
  andningshål_1_N = mkN "andningshål" neutrum  ; -- andningshål..nn.1
  andningsinsufficiens_1_N = mkN "andningsinsufficiens" "andningsinsufficienser" ; -- andningsinsufficiens..nn.1
  andningsljud_1_N = mkN "andningsljud" neutrum  ; -- andningsljud..nn.1
  andningsorgan_1_N = mkN "andningsorgan" neutrum  ; -- andningsorgan..nn.1
  andningsparalys_1_N = mkN "andningsparalys" "andningsparalyser" ; -- andningsparalys..nn.1
  andningspaus_1_N = mkN "andningspaus" "andningspauser" ; -- andningspaus..nn.1
  andningsreaktion_1_N = mkN "andningsreaktion" ; -- andningsreaktion..nn.1
  andningsrör_1_N = mkN "andningsrör" neutrum  ; -- andningsrör..nn.1
  andningsrörelse_1_N = mkN "andningsrörelse" "andningsrörelser" ; -- andningsrörelse..nn.1
  andningsskydd_1_N = mkN "andningsskydd" neutrum  ; -- andningsskydd..nn.1
  andningsstillestånd_1_N = mkN "andningsstillestånd" neutrum  ; -- andningsstillestånd..nn.1
  andningsstörning_1_N = mkN "andningsstörning" ; -- andningsstörning..nn.1
  andningssvikt_1_N = mkN "andningssvikt" "andningssvikter" ; -- andningssvikt..nn.1
  andningssvårighet_1_N = mkN "andningssvårighet" "andningssvårigheter" ; -- andningssvårighet..nn.1
  andningsuppehåll_1_N = mkN "andningsuppehåll" neutrum  ; -- andningsuppehåll..nn.1
  andningsväg_1_N = mkN "andningsväg" ; -- andningsväg..nn.1
  andnöd_1_N = mkN "andnöd" ; -- andnöd..nn.1
  andorran_1_N = mkN "andorran" "andorraner" ; -- andorran..nn.1
  andorransk_1_A = mkA "andorransk" ; -- andorransk..av.1
  andorranska_1_N = mkN "andorranska" ; -- andorranska..nn.1
  andouillette_1_N = mkN "andouillette" "andouilletter" ; -- andouillette..nn.1
  andra_1_V = mkV "andraga" "androg" "andragit" ; -- andra..vb.1
  andrabas_1_N = mkN "andrabas" ; -- andrabas..nn.1
  andrabil_1_N = mkN "andrabil" ; -- andrabil..nn.1
  andraderivata_1_N = mkN "andraderivata" ; -- andraderivata..nn.1
  andrag_1_N = mkN "andrag" neutrum  ; -- andrag..nn.1
  andragande_1_N = mkN "andragande" ; -- andragande..nn.1
  andragradsekvation_1_N = mkN "andragradsekvation" ; -- andragradsekvation..nn.1
  andrahandsbutik_1_N = mkN "andrahandsbutik" "andrahandsbutiker" ; -- andrahandsbutik..nn.1
  andrahandscitat_1_N = mkN "andrahandscitat" neutrum  ; -- andrahandscitat..nn.1
  andrahandsfaktorer_1_N = mkN "andrahandsfaktorer" "andrahandsfaktorerer" ; -- andrahandsfaktorer..nn.1
  andrahandsföremål_1_N = mkN "andrahandsföremål" neutrum  ; -- andrahandsföremål..nn.1
  andrahandsinformation_1_N = mkN "andrahandsinformation" ; -- andrahandsinformation..nn.1
  andrahandskälla_1_N = mkN "andrahandskälla" ; -- andrahandskälla..nn.1
  andrahandsuppgift_1_N = mkN "andrahandsuppgift" "andrahandsuppgifter" ; -- andrahandsuppgift..nn.1
  andrahandsval_1_N = mkN "andrahandsval" neutrum  ; -- andrahandsval..nn.1
  andrahandsvärde_1_N = mkN "andrahandsvärde" ; -- andrahandsvärde..nn.1
  andrake_1_N = mkN "andrake" utrum  ; -- andrake..nn.1
  andraklassbiljett_1_N = mkN "andraklassbiljett" "andraklassbiljetter" ; -- andraklassbiljett..nn.1
  andraklasspassagerare_1_N = mkN "andraklasspassagerare" utrum  ; -- andraklasspassagerare..nn.1
  andranamn_1_N = mkN "andranamn" neutrum  ; -- andranamn..nn.1
  andraopponent_1_N = mkN "andraopponent" "andraopponenter" ; -- andraopponent..nn.1
  andraplacering_1_N = mkN "andraplacering" ; -- andraplacering..nn.1
  andraplans_1_A = mkA "andraplans" ; -- andraplans..av.1
  andraplats_1_N = mkN "andraplats" "andraplatser" ; -- andraplats..nn.1
  andraslagsförmåga_1_N = mkN "andraslagsförmåga" ; -- andraslagsförmåga..nn.1
  andratenor_1_N = mkN "andratenor" "andratenoren" "andratenorer" "andratenorerna" ; -- andratenor..nn.1
  andratidning_1_N = mkN "andratidning" ; -- andratidning..nn.1
  andreaskors_1_N = mkN "andreaskors" neutrum  ; -- andreaskors..nn.1
  andrebas_1_N = mkN "andrebas" ; -- andrebas..nn.1
  andrechef_1_N = mkN "andrechef" "andrechefer" ; -- andrechef..nn.1
  andreopponent_1_N = mkN "andreopponent" "andreopponenter" ; -- andreopponent..nn.1
  andretenor_1_N = mkN "andretenor" "andretenoren" "andretenorer" "andretenorerna" ; -- andretenor..nn.1
  androblastom_1_N = mkN "androblastom" neutrum  ; -- androblastom..nn.1
  androfani_1_N = mkN "androfani" ; -- androfani..nn.1
  androfobi_1_N = mkN "androfobi" ; -- androfobi..nn.1
  androgenokänslighetssyndrom_1_N = mkN "androgenokänslighetssyndrom" neutrum  ; -- androgenokänslighetssyndrom..nn.1
  androgyn_1_A = mkA "androgyn" ; -- androgyn..av.1
  androgyn_1_N = mkN "androgyn" "androgyner" ; -- androgyn..nn.1
  androgynhet_1_N = mkN "androgynhet" ; -- androgynhet..nn.1
  android_1_N = mkN "android" "androider" ; -- android..nn.1
  androidlur_1_N = mkN "androidlur" ; -- androidlur..nn.1
  androidmobil_1_N = mkN "androidmobil" "androidmobiler" ; -- androidmobil..nn.1
  andryg_1_A = mkA "andryg" ; -- andryg..av.1
  andryghet_1_N = mkN "andryghet" ; -- andryghet..nn.1
  andsträck_1_N = mkN "andsträck" neutrum  ; -- andsträck..nn.1
  andtruten_1_A = mkA "andtruten" ; -- andtruten..av.1
  andtrutenhet_1_N = mkN "andtrutenhet" ; -- andtrutenhet..nn.1
  andtäppa_1_N = mkN "andtäppa" ; -- andtäppa..nn.1
  andtäppt_1_A = mkA "andtäppt" "andtäppt" ; -- andtäppt..av.1
  andur_1_N = mkN "andur" "andurn" "andrar" "andrarna" ; -- andur..nn.1
  andäktig_1_A = mkA "andäktig" ; -- andäktig..av.1
  andäktighet_1_N = mkN "andäktighet" ; -- andäktighet..nn.1
  anekdot_1_N = mkN "anekdot" "anekdoter" ; -- anekdot..nn.1
  anekdotartad_1_A = mkA "anekdotartad" ; -- anekdotartad..av.1
  anekdotberättare_1_N = mkN "anekdotberättare" utrum  ; -- anekdotberättare..nn.1
  anekdotflora_1_N = mkN "anekdotflora" ; -- anekdotflora..nn.1
  anekdotisk_1_A = mkA "anekdotisk" ; -- anekdotisk..av.1
  anekdotsamling_1_N = mkN "anekdotsamling" ; -- anekdotsamling..nn.1
  anemi_1_N = mkN "anemi" "anemier" ; -- anemi..nn.1
  anemisk_1_A = mkA "anemisk" ; -- anemisk..av.1
  anemometer_1_N = mkN "anemometer" ; -- anemometer..nn.1
  anemon_1_N = mkN "anemon" "anemoner" ; -- anemon..nn.1
  anencefali_1_N = mkN "anencefali" ; -- anencefali..nn.1
  aneroidbarometer_1_N = mkN "aneroidbarometer" ; -- aneroidbarometer..nn.1
  anestesi_1_N = mkN "anestesi" "anestesier" ; -- anestesi..nn.1
  anestesiolog_1_N = mkN "anestesiolog" "anestesiologer" ; -- anestesiolog..nn.1
  anestesiologi_1_N = mkN "anestesiologi" ; -- anestesiologi..nn.1
  anestesirum_1_N = mkN "anestesirum" "anestesirummet" "anestesirum" "anestesirummen" ; -- anestesirum..nn.1
  anestetika_1_N = mkN "anestetika" "anestetikat" "anestetika" "anestetikana" ; -- anestetika..nn.1
  anestetisk_1_A = mkA "anestetisk" ; -- anestetisk..av.1
  anetoderma_1_N = mkN "anetoderma" ; -- anetoderma..nn.1
  aneuploidi_1_N = mkN "aneuploidi" ; -- aneuploidi..nn.1
  aneurysm_1_N = mkN "aneurysm" "aneurysmer" ; -- aneurysm..nn.1
  anfader_1_N = mkN "anfader" "anfadern" "anfäder" "anfäderna" ; -- anfader..nn.1
  anfall_1_N = mkN "anfall" neutrum  ; -- anfall..nn.1
  anfalla_1_V = mkV "anfalla" "anföll" "anfallit" ; -- anfalla..vb.1
  anfallande_1_N = mkN "anfallande" ; -- anfallande..nn.1
  anfallare_1_N = mkN "anfallare" utrum  ; -- anfallare..nn.1
  anfallsbas_1_N = mkN "anfallsbas" "anfallsbaser" ; -- anfallsbas..nn.1
  anfallsfront_1_N = mkN "anfallsfront" "anfallsfronter" ; -- anfallsfront..nn.1
  anfallskrig_1_N = mkN "anfallskrig" neutrum  ; -- anfallskrig..nn.1
  anfallslinje_1_N = mkN "anfallslinje" "anfallslinjer" ; -- anfallslinje..nn.1
  anfallsmässig_1_A = mkA "anfallsmässig" ; -- anfallsmässig..av.1
  anfallsområde_1_N = mkN "anfallsområde" ; -- anfallsområde..nn.1
  anfallsrörelse_1_N = mkN "anfallsrörelse" "anfallsrörelser" ; -- anfallsrörelse..nn.1
  anfallssignal_1_N = mkN "anfallssignal" "anfallssignaler" ; -- anfallssignal..nn.1
  anfallsspel_1_N = mkN "anfallsspel" "anfallsspelet" "anfallsspel" "anfallsspelen" ; -- anfallsspel..nn.1
  anfallsspelare_1_N = mkN "anfallsspelare" utrum  ; -- anfallsspelare..nn.1
  anfallsvapen_1_N = mkN "anfallsvapen" "anfallsvapnet" "anfallsvapen" "anfallsvapnen" ; -- anfallsvapen..nn.1
  anfallsvinkel_1_N = mkN "anfallsvinkel" ; -- anfallsvinkel..nn.1
  anfallsvåg_1_N = mkN "anfallsvåg" "anfallsvågor" ; -- anfallsvåg..nn.1
  anfang_1_N = mkN "anfang" "anfanger" ; -- anfang..nn.1
  anfart_1_N = mkN "anfart" "anfarter" ; -- anfart..nn.1
  anflog_1_N = mkN "anflog" neutrum  ; -- anflog..nn.1
  anflygning_1_N = mkN "anflygning" ; -- anflygning..nn.1
  anfräta_1_V = mkV "anfräter" ; -- anfräta..vb.1
  anfrätande_1_N = mkN "anfrätande" ; -- anfrätande..nn.1
  anfrätning_1_N = mkN "anfrätning" ; -- anfrätning..nn.1
  anfrätt_1_A = mkA "anfrätt" ; -- anfrätt..av.1
  anfäkta_1_V = mkV "anfäktar" ; -- anfäkta..vb.1
  anfäktad_1_A = mkA "anfäktad" ; -- anfäktad..av.1
  anfäktande_1_N = mkN "anfäktande" ; -- anfäktande..nn.1
  anfäktelse_1_N = mkN "anfäktelse" "anfäktelser" ; -- anfäktelse..nn.1
  anfäktning_1_N = mkN "anfäktning" ; -- anfäktning..nn.1
  anföra_1_V = mkV "anföra" "anförde" "anfört" ; -- anföra..vb.1
  anförande_1_N = mkN "anförande" ; -- anförande..nn.1
  anförare_1_N = mkN "anförare" utrum  ; -- anförare..nn.1
  anförarförmåga_1_N = mkN "anförarförmåga" ; -- anförarförmåga..nn.1
  anförarskap_1_N = mkN "anförarskap" neutrum  ; -- anförarskap..nn.1
  anförarskicklighet_1_N = mkN "anförarskicklighet" "anförarskickligheter" ; -- anförarskicklighet..nn.1
  anföring_1_N = mkN "anföring" ; -- anföring..nn.1
  anföringssats_1_N = mkN "anföringssats" "anföringssatser" ; -- anföringssats..nn.1
  anföringstecken_1_N = mkN "anföringstecken" "anföringstecknet" "anföringstecken" "anföringstecknen" ; -- anföringstecken..nn.1
  anföringsverb_1_N = mkN "anföringsverb" neutrum  ; -- anföringsverb..nn.1
  anförtro_1_V = mkV "anförtror" ; -- anförtro..vb.1
  anförtroende_1_N = mkN "anförtroende" ; -- anförtroende..nn.1
  anförvant_1_N = mkN "anförvant" "anförvanter" ; -- anförvant..nn.1
  anförvantskap_1_N = mkN "anförvantskap" neutrum  ; -- anförvantskap..nn.1
  ange_1_V = mkV "angiva" "angav" "angivit" ; -- ange..vb.1
  angel_1_N = mkN "angel" ; -- angel..nn.1
  angelologi_1_N = mkN "angelologi" ; -- angelologi..nn.1
  angelsachsare_1_N = mkN "angelsachsare" utrum  ; -- angelsachsare..nn.1
  angelsachsisk_1_A = mkA "angelsachsisk" ; -- angelsachsisk..av.1
  angelsaxare_1_N = mkN "angelsaxare" utrum  ; -- angelsaxare..nn.1
  angelsaxisk_1_A = mkA "angelsaxisk" ; -- angelsaxisk..av.1
  angelägen_1_A = mkA "angelägen" ; -- angelägen..av.1
  angelägenhet_1_N = mkN "angelägenhet" "angelägenheter" ; -- angelägenhet..nn.1
  angenäm_1_A = mkA "angenäm" ; -- angenäm..av.1
  angenämhet_1_N = mkN "angenämhet" ; -- angenämhet..nn.1
  angina_1_N = mkN "angina" ; -- angina..nn.1
  angiodysplasi_1_N = mkN "angiodysplasi" "angiodysplasier" ; -- angiodysplasi..nn.1
  angiofibrom_1_N = mkN "angiofibrom" neutrum  ; -- angiofibrom..nn.1
  angiografi_1_N = mkN "angiografi" ; -- angiografi..nn.1
  angiokeratom_1_N = mkN "angiokeratom" neutrum  ; -- angiokeratom..nn.1
  angioleiomyom_1_N = mkN "angioleiomyom" neutrum  ; -- angioleiomyom..nn.1
  angiolipom_1_N = mkN "angiolipom" neutrum  ; -- angiolipom..nn.1
  angiologi_1_N = mkN "angiologi" ; -- angiologi..nn.1
  angiom_1_N = mkN "angiom" neutrum  ; -- angiom..nn.1
  angiomatos_1_N = mkN "angiomatos" ; -- angiomatos..nn.1
  angiomyolipom_1_N = mkN "angiomyolipom" neutrum  ; -- angiomyolipom..nn.1
  angiomyom_1_N = mkN "angiomyom" neutrum  ; -- angiomyom..nn.1
  angiosperm_1_N = mkN "angiosperm" "angiospermer" ; -- angiosperm..nn.1
  angioödem_1_N = mkN "angioödem" "angioödemer" ; -- angioödem..nn.1
  angit_1_N = mkN "angit" "angiter" ; -- angit..nn.1
  angivande_1_N = mkN "angivande" ; -- angivande..nn.1
  angivare_1_N = mkN "angivare" utrum  ; -- angivare..nn.1
  angivelse_1_N = mkN "angivelse" "angivelser" ; -- angivelse..nn.1
  angivelsebrott_1_N = mkN "angivelsebrott" neutrum  ; -- angivelsebrott..nn.1
  angiveri_1_N = mkN "angiveri" "angiveriet" "angiverier" "angiverierna" ; -- angiveri..nn.1
  angiverilag_1_N = mkN "angiverilag" ; -- angiverilag..nn.1
  angla_1_V = mkV "anglar" ; -- angla..vb.1
  anglande_1_N = mkN "anglande" ; -- anglande..nn.1
  anglicism_1_N = mkN "anglicism" "anglicismer" ; -- anglicism..nn.1
  anglicistisk_1_A = mkA "anglicistisk" ; -- anglicistisk..av.1
  anglifiera_1_V = mkV "anglifierar" ; -- anglifiera..vb.1
  anglifierande_1_N = mkN "anglifierande" ; -- anglifierande..nn.1
  anglifierbar_1_A = mkA "anglifierbar" ; -- anglifierbar..av.1
  anglifierbarhet_1_N = mkN "anglifierbarhet" ; -- anglifierbarhet..nn.1
  anglifiering_1_N = mkN "anglifiering" ; -- anglifiering..nn.1
  anglikansk_1_A = mkA "anglikansk" ; -- anglikansk..av.1
  anglisera_1_V = mkV "angliserar" ; -- anglisera..vb.1
  angliserande_1_N = mkN "angliserande" ; -- angliserande..nn.1
  angliserbar_1_A = mkA "angliserbar" ; -- angliserbar..av.1
  angliserbarhet_1_N = mkN "angliserbarhet" ; -- angliserbarhet..nn.1
  anglisering_1_N = mkN "anglisering" ; -- anglisering..nn.1
  anglist_1_N = mkN "anglist" "anglister" ; -- anglist..nn.1
  angloamerikansk_1_A = mkA "angloamerikansk" ; -- angloamerikansk..av.1
  anglosachsare_1_N = mkN "anglosachsare" utrum  ; -- anglosachsare..nn.1
  anglosachsisk_1_A = mkA "anglosachsisk" ; -- anglosachsisk..av.1
  anglosaxare_1_N = mkN "anglosaxare" utrum  ; -- anglosaxare..nn.1
  anglosaxisk_1_A = mkA "anglosaxisk" ; -- anglosaxisk..av.1
  angläs_1_N = mkN "angläs" "angläser" ; -- angläs..nn.1
  angolan_1_N = mkN "angolan" "angolaner" ; -- angolan..nn.1
  angolansk_1_A = mkA "angolansk" ; -- angolansk..av.1
  angolanska_1_N = mkN "angolanska" ; -- angolanska..nn.1
  angoragarn_1_N = mkN "angoragarn" neutrum  ; -- angoragarn..nn.1
  angoraget_1_N = mkN "angoraget" "angoragetter" ; -- angoraget..nn.1
  angorajumper_1_N = mkN "angorajumper" ; -- angorajumper..nn.1
  angorakatt_1_N = mkN "angorakatt" "angorakatter" ; -- angorakatt..nn.1
  angoraull_1_N = mkN "angoraull" ; -- angoraull..nn.1
  angostura_1_N = mkN "angostura" ; -- angostura..nn.1
  angrepp_1_N = mkN "angrepp" neutrum  ; -- angrepp..nn.1
  angreppsmål_1_N = mkN "angreppsmål" neutrum  ; -- angreppsmål..nn.1
  angreppspunkt_1_N = mkN "angreppspunkt" "angreppspunkter" ; -- angreppspunkt..nn.1
  angreppssätt_1_N = mkN "angreppssätt" neutrum  ; -- angreppssätt..nn.1
  angripa_1_V = mkV "angripa" "angrep" "angripit" ; -- angripa..vb.1
  angripande_1_N = mkN "angripande" ; -- angripande..nn.1
  angripare_1_N = mkN "angripare" utrum  ; -- angripare..nn.1
  angripbar_1_A = mkA "angripbar" ; -- angripbar..av.1
  angränsa_1_V = mkV "angränsar" ; -- angränsa..vb.1
  angränsande_1_A = mkA "angränsande" ; -- angränsande..av.1
  angränsande_1_N = mkN "angränsande" ; -- angränsande..nn.1
  angå_1_V = mkV "angå" "angick" "angått" ; -- angå..vb.1
  angöra_1_V = mkV "angöra" "angjorde" "angjort" ; -- angöra..vb.1
  angörande_1_N = mkN "angörande" ; -- angörande..nn.1
  anhalt_1_N = mkN "anhalt" "anhalter" ; -- anhalt..nn.1
  anhang_1_N = mkN "anhang" neutrum  ; -- anhang..nn.1
  anhopa_1_V = mkV "anhopar" ; -- anhopa..vb.1
  anhopande_1_N = mkN "anhopande" ; -- anhopande..nn.1
  anhopning_1_N = mkN "anhopning" ; -- anhopning..nn.1
  anhängare_1_N = mkN "anhängare" utrum  ; -- anhängare..nn.1
  anhängarskara_1_N = mkN "anhängarskara" ; -- anhängarskara..nn.1
  anhängig_1_A = mkA "anhängig" ; -- anhängig..av.1
  anhåll_1_N = mkN "anhåll" neutrum  ; -- anhåll..nn.1
  anhålla_1_V = mkV "anhålla" "anhöll" "anhållit" ; -- anhålla..vb.1
  anhållan_1_N = mkN "anhållan" "anhållan" "anhållanden" "anhållandena" ; -- anhållan..nn.1
  anhållande_1_N = mkN "anhållande" ; -- anhållande..nn.1
  anhållningsbeslut_1_N = mkN "anhållningsbeslut" neutrum  ; -- anhållningsbeslut..nn.1
  anhörig_1_A = mkA "anhörig" ; -- anhörig..av.1
  anhörigdag_1_N = mkN "anhörigdag" ; -- anhörigdag..nn.1
  anhörighet_1_N = mkN "anhörighet" ; -- anhörighet..nn.1
  anhöriginvandring_1_N = mkN "anhöriginvandring" ; -- anhöriginvandring..nn.1
  anhörigvård_1_N = mkN "anhörigvård" ; -- anhörigvård..nn.1
  anhörigvårdare_1_N = mkN "anhörigvårdare" utrum  ; -- anhörigvårdare..nn.1
  anilin_1_N = mkN "anilin" ; -- anilin..nn.1
  anilinfärg_1_N = mkN "anilinfärg" "anilinfärger" ; -- anilinfärg..nn.1
  anilinfärgad_1_A = mkA "anilinfärgad" ; -- anilinfärgad..av.1
  anilinolja_1_N = mkN "anilinolja" ; -- anilinolja..nn.1
  anilinröd_1_A = mkA "anilinröd" "anilinrött" ; -- anilinröd..av.1
  animal_1_A = mkA "animal" ; -- animal..av.1
  animalisk_1_A = mkA "animalisk" ; -- animalisk..av.1
  animation_1_N = mkN "animation" ; -- animation..nn.1
  animatör_1_N = mkN "animatör" "animatörer" ; -- animatör..nn.1
  animera_1_V = mkV "animerar" ; -- animera..vb.1
  animerad_1_A = mkA "animerad" ; -- animerad..av.1
  animerande_1_N = mkN "animerande" ; -- animerande..nn.1
  animerbar_1_A = mkA "animerbar" ; -- animerbar..av.1
  animerbarhet_1_N = mkN "animerbarhet" ; -- animerbarhet..nn.1
  animering_1_N = mkN "animering" ; -- animering..nn.1
  animism_1_N = mkN "animism" "animismer" ; -- animism..nn.1
  animistisk_1_A = mkA "animistisk" ; -- animistisk..av.1
  animositet_1_N = mkN "animositet" "animositeter" ; -- animositet..nn.1
  aning_1_N = mkN "aning" ; -- aning..nn.1
  aningen_1_Adv = mkAdv "aningen" ; -- aningen..ab.1
  aningens_1_Adv = mkAdv "aningens" ; -- aningens..ab.1
  aningsfull_1_A = mkA "aningsfull" ; -- aningsfull..av.1
  aningslös_1_A = mkA "aningslös" ; -- aningslös..av.1
  aningslöshet_1_N = mkN "aningslöshet" "aningslösheter" ; -- aningslöshet..nn.1
  aniridi_1_N = mkN "aniridi" ; -- aniridi..nn.1
  anis_1_N = mkN "anis" ; -- anis..nn.1
  anisakiasis_1_N = mkN "anisakiasis" "anisakiasiser" ; -- anisakiasis..nn.1
  anisbrännvin_1_N = mkN "anisbrännvin" "anisbrännvinet" "anisbrännviner" "anisbrännvinerna" ; -- anisbrännvin..nn.1
  anisbröd_1_N = mkN "anisbröd" neutrum  ; -- anisbröd..nn.1
  aniseikoni_1_N = mkN "aniseikoni" ; -- aniseikoni..nn.1
  anisett_1_N = mkN "anisett" "anisetter" ; -- anisett..nn.1
  anisettlikör_1_N = mkN "anisettlikör" "anisettlikörer" ; -- anisettlikör..nn.1
  anislikör_1_N = mkN "anislikör" "anislikörer" ; -- anislikör..nn.1
  anisokori_1_N = mkN "anisokori" ; -- anisokori..nn.1
  anisolja_1_N = mkN "anisolja" ; -- anisolja..nn.1
  anisometropi_1_N = mkN "anisometropi" ; -- anisometropi..nn.1
  anjon_1_N = mkN "anjon" "anjoner" ; -- anjon..nn.1
  anka_1_N = mkN "anka" ; -- anka..nn.1
  ankar_1_N = mkN "ankar" ; -- ankar..nn.1
  ankararm_1_N = mkN "ankararm" ; -- ankararm..nn.1
  ankarboj_1_N = mkN "ankarboj" ; -- ankarboj..nn.1
  ankarbult_1_N = mkN "ankarbult" ; -- ankarbult..nn.1
  ankare_1_N = mkN "ankare" "ankaret" "ankaren" "ankarna" ; -- ankare..nn.1
  ankarfly_1_N = mkN "ankarfly" "ankarflyet" "ankarflyn" "ankarflyna" ; -- ankarfly..nn.1
  ankarfäste_1_N = mkN "ankarfäste" ; -- ankarfäste..nn.1
  ankargrund_1_N = mkN "ankargrund" "ankargrunder" ; -- ankargrund..nn.1
  ankarjärn_1_N = mkN "ankarjärn" neutrum  ; -- ankarjärn..nn.1
  ankarkabel_1_N = mkN "ankarkabel" ; -- ankarkabel..nn.1
  ankarklys_1_N = mkN "ankarklys" neutrum  ; -- ankarklys..nn.1
  ankarkropp_1_N = mkN "ankarkropp" ; -- ankarkropp..nn.1
  ankarkätting_1_N = mkN "ankarkätting" ; -- ankarkätting..nn.1
  ankarlindning_1_N = mkN "ankarlindning" ; -- ankarlindning..nn.1
  ankarplats_1_N = mkN "ankarplats" "ankarplatser" ; -- ankarplats..nn.1
  ankarslut_1_N = mkN "ankarslut" neutrum  ; -- ankarslut..nn.1
  ankarspel_1_N = mkN "ankarspel" "ankarspelet" "ankarspel" "ankarspelen" ; -- ankarspel..nn.1
  ankarstock_1_N = mkN "ankarstock" ; -- ankarstock..nn.1
  ankartross_1_N = mkN "ankartross" ; -- ankartross..nn.1
  ankartåg_1_N = mkN "ankartåg" neutrum  ; -- ankartåg..nn.1
  ankarur_1_N = mkN "ankarur" neutrum  ; -- ankarur..nn.1
  ankbonde_1_N = mkN "ankbonde" "ankbönder" ; -- ankbonde..nn.1
  ankbröst_1_N = mkN "ankbröst" neutrum  ; -- ankbröst..nn.1
  ankdamm_1_N = mkN "ankdamm" ; -- ankdamm..nn.1
  ankel_1_N = mkN "ankel" ; -- ankel..nn.1
  ankelled_1_N = mkN "ankelled" "ankelleder" ; -- ankelled..nn.1
  ankellång_1_A = mkA "ankellång" ; -- ankellång..av.1
  ankelsocka_1_N = mkN "ankelsocka" ; -- ankelsocka..nn.1
  ankism_1_N = mkN "ankism" ; -- ankism..nn.1
  ankistisk_1_A = mkA "ankistisk" ; -- ankistisk..av.1
  anklaga_1_V = mkV "anklagar" ; -- anklaga..vb.1
  anklagande_1_N = mkN "anklagande" ; -- anklagande..nn.1
  anklagare_1_N = mkN "anklagare" utrum  ; -- anklagare..nn.1
  anklagelse_1_N = mkN "anklagelse" "anklagelser" ; -- anklagelse..nn.1
  anklagelseakt_1_N = mkN "anklagelseakt" "anklagelseakter" ; -- anklagelseakt..nn.1
  anklagelsepunkt_1_N = mkN "anklagelsepunkt" "anklagelsepunkter" ; -- anklagelsepunkt..nn.1
  anklagelseskrift_1_N = mkN "anklagelseskrift" "anklagelseskrifter" ; -- anklagelseskrift..nn.1
  anklang_1_N = mkN "anklang" "anklanger" ; -- anklang..nn.1
  ankläpp_1_N = mkN "ankläpp" ; -- ankläpp..nn.1
  anknyta_1_V = mkV "anknyta" "anknöt" "anknutit" ; -- anknyta..vb.1
  anknytande_1_N = mkN "anknytande" ; -- anknytande..nn.1
  anknytning_1_N = mkN "anknytning" ; -- anknytning..nn.1
  ankomma_1_V = mkV "ankomma" "ankom" "ankommit" ; -- ankomma..vb.1
  ankommande_1_N = mkN "ankommande" ; -- ankommande..nn.1
  ankommen_1_A = mkA "ankommen" "ankommet" "ankomna" "ankomna" "ankomnare" "ankomnast" "ankomnaste" ; -- ankommen..av.1
  ankommenhet_1_N = mkN "ankommenhet" ; -- ankommenhet..nn.1
  ankomst_1_N = mkN "ankomst" "ankomster" ; -- ankomst..nn.1
  ankomstdag_1_N = mkN "ankomstdag" ; -- ankomstdag..nn.1
  ankomsthall_1_N = mkN "ankomsthall" ; -- ankomsthall..nn.1
  ankomstkommun_1_N = mkN "ankomstkommun" "ankomstkommuner" ; -- ankomstkommun..nn.1
  ankomstort_1_N = mkN "ankomstort" "ankomstorter" ; -- ankomstort..nn.1
  ankomststation_1_N = mkN "ankomststation" ; -- ankomststation..nn.1
  ankomsttid_1_N = mkN "ankomsttid" "ankomsttider" ; -- ankomsttid..nn.1
  ankra_1_V = mkV "ankrar" ; -- ankra..vb.1
  ankrande_1_N = mkN "ankrande" ; -- ankrande..nn.1
  ankring_1_N = mkN "ankring" ; -- ankring..nn.1
  ankringsplats_1_N = mkN "ankringsplats" "ankringsplatser" ; -- ankringsplats..nn.1
  ankunge_1_N = mkN "ankunge" utrum  ; -- ankunge..nn.1
  ankylos_1_N = mkN "ankylos" ; -- ankylos..nn.1
  ankylostomiasis_1_N = mkN "ankylostomiasis" "ankylostomiasiser" ; -- ankylostomiasis..nn.1
  ankägg_1_N = mkN "ankägg" neutrum  ; -- ankägg..nn.1
  anlag_1_N = mkN "anlag" neutrum  ; -- anlag..nn.1
  anlagsbärare_1_N = mkN "anlagsbärare" utrum  ; -- anlagsbärare..nn.1
  anlagstest_1_N = mkN "anlagstest" neutrum  ; -- anlagstest..nn.1
  anlagstestning_1_N = mkN "anlagstestning" ; -- anlagstestning..nn.1
  anledning_1_N = mkN "anledning" ; -- anledning..nn.1
  anlete_1_N = mkN "anlete" ; -- anlete..nn.1
  anletsdrag_1_N = mkN "anletsdrag" neutrum  ; -- anletsdrag..nn.1
  anligga_1_V = mkV "anligga" "anlåg" "anlegat" ; -- anligga..vb.1
  anliggande_1_N = mkN "anliggande" ; -- anliggande..nn.1
  anliggning_1_N = mkN "anliggning" ; -- anliggning..nn.1
  anliggningspunkt_1_N = mkN "anliggningspunkt" "anliggningspunkter" ; -- anliggningspunkt..nn.1
  anliggningsyta_1_N = mkN "anliggningsyta" ; -- anliggningsyta..nn.1
  anlita_1_V = mkV "anlitar" ; -- anlita..vb.1
  anlitande_1_N = mkN "anlitande" ; -- anlitande..nn.1
  anlopp_1_N = mkN "anlopp" neutrum  ; -- anlopp..nn.1
  anloppshamn_1_N = mkN "anloppshamn" ; -- anloppshamn..nn.1
  anlupen_1_A = mkA "anlupen" ; -- anlupen..av.1
  anlupenhet_1_N = mkN "anlupenhet" ; -- anlupenhet..nn.1
  anlägga_1_V = mkV "anlägga" "anla" "anlagt" ; -- anlägga..vb.1
  anläggande_1_N = mkN "anläggande" ; -- anläggande..nn.1
  anläggare_1_N = mkN "anläggare" utrum  ; -- anläggare..nn.1
  anläggning_1_N = mkN "anläggning" ; -- anläggning..nn.1
  anläggning_2_N = mkN "anläggning" ; -- anläggning..nn.2
  anläggningsarbetare_1_N = mkN "anläggningsarbetare" utrum  ; -- anläggningsarbetare..nn.1
  anläggningskostnad_1_N = mkN "anläggningskostnad" "anläggningskostnader" ; -- anläggningskostnad..nn.1
  anläggningsplats_1_N = mkN "anläggningsplats" "anläggningsplatser" ; -- anläggningsplats..nn.1
  anläggningstillgång_1_N = mkN "anläggningstillgång" ; -- anläggningstillgång..nn.1
  anläggningsyta_1_N = mkN "anläggningsyta" ; -- anläggningsyta..nn.1
  anlända_1_V = mkV "anländer" ; -- anlända..vb.1
  anländande_1_N = mkN "anländande" ; -- anländande..nn.1
  anlöpa_1_V = mkV "anlöper" ; -- anlöpa..vb.1
  anlöpande_1_N = mkN "anlöpande" ; -- anlöpande..nn.1
  anlöpning_1_N = mkN "anlöpning" ; -- anlöpning..nn.1
  anlöpningshamn_1_N = mkN "anlöpningshamn" ; -- anlöpningshamn..nn.1
  anmana_1_V = mkV "anmanar" ; -- anmana..vb.1
  anmanande_1_N = mkN "anmanande" ; -- anmanande..nn.1
  anmaning_1_N = mkN "anmaning" ; -- anmaning..nn.1
  anmarsch_1_N = mkN "anmarsch" "anmarscher" ; -- anmarsch..nn.1
  anmarschering_1_N = mkN "anmarschering" ; -- anmarschering..nn.1
  anmoda_1_V = mkV "anmodar" ; -- anmoda..vb.1
  anmodande_1_N = mkN "anmodande" ; -- anmodande..nn.1
  anmoder_1_N = mkN "anmoder" "anmodern" "anmödrar" "anmödrarna" ; -- anmoder..nn.1
  anmäla_1_V = mkV "anmäler" ; -- anmäla..vb.1
  anmälan_2_N = mkN "anmälan" "anmälan" "anmälningar" "anmälningarna" ; -- anmälan..nn.2
  anmälande_1_N = mkN "anmälande" ; -- anmälande..nn.1
  anmälare_1_N = mkN "anmälare" utrum  ; -- anmälare..nn.1
  anmälning_1_N = mkN "anmälning" ; -- anmälning..nn.1
  anmälningsbenägenhet_1_N = mkN "anmälningsbenägenhet" "anmälningsbenägenheter" ; -- anmälningsbenägenhet..nn.1
  anmälningsplikt_1_N = mkN "anmälningsplikt" ; -- anmälningsplikt..nn.1
  anmälningspliktig_1_A = mkA "anmälningspliktig" ; -- anmälningspliktig..av.1
  anmälningsskyldig_1_A = mkA "anmälningsskyldig" ; -- anmälningsskyldig..av.1
  anmälningstid_1_N = mkN "anmälningstid" "anmälningstider" ; -- anmälningstid..nn.1
  anmärka_1_V = mkV "anmärker" ; -- anmärka..vb.1
  anmärkande_1_N = mkN "anmärkande" ; -- anmärkande..nn.1
  anmärkare_1_N = mkN "anmärkare" utrum  ; -- anmärkare..nn.1
  anmärkning_1_N = mkN "anmärkning" ; -- anmärkning..nn.1
  anmärkningsbok_1_N = mkN "anmärkningsbok" "anmärkningsböcker" ; -- anmärkningsbok..nn.1
  anmärkningsvärd_1_A = mkA "anmärkningsvärd" "anmärkningsvärt" ; -- anmärkningsvärd..av.1
  anmärkningsvärdhet_1_N = mkN "anmärkningsvärdhet" ; -- anmärkningsvärdhet..nn.1
  annalist_1_N = mkN "annalist" "annalister" ; -- annalist..nn.1
  annalkande_1_A = mkA "annalkande" ; -- annalkande..av.1
  annalkande_1_N = mkN "annalkande" ; -- annalkande..nn.1
  annalskrivning_1_N = mkN "annalskrivning" ; -- annalskrivning..nn.1
  annandag_1_N = mkN "annandag" ; -- annandag..nn.1
  annanstans_1_Adv = mkAdv "annanstans" ; -- annanstans..ab.1
  annars_1_Adv = mkAdv "annars" ; -- annars..ab.1
  annatto_1_N = mkN "annatto" ; -- annatto..nn.1
  annektera_1_V = mkV "annekterar" ; -- annektera..vb.1
  annekterande_1_N = mkN "annekterande" ; -- annekterande..nn.1
  annekterbar_1_A = mkA "annekterbar" ; -- annekterbar..av.1
  annekterbarhet_1_N = mkN "annekterbarhet" ; -- annekterbarhet..nn.1
  annektering_1_N = mkN "annektering" ; -- annektering..nn.1
  annektion_1_N = mkN "annektion" ; -- annektion..nn.1
  annex_1_N = mkN "annex" neutrum  ; -- annex..nn.1
  annexförsamling_1_N = mkN "annexförsamling" ; -- annexförsamling..nn.1
  annexion_1_N = mkN "annexion" ; -- annexion..nn.1
  annexionspolitik_1_N = mkN "annexionspolitik" ; -- annexionspolitik..nn.1
  annexkyrka_1_N = mkN "annexkyrka" ; -- annexkyrka..nn.1
  annihilation_1_N = mkN "annihilation" ; -- annihilation..nn.1
  annihilera_1_V = mkV "annihilerar" ; -- annihilera..vb.1
  annihilerande_1_N = mkN "annihilerande" ; -- annihilerande..nn.1
  annihilerbar_1_A = mkA "annihilerbar" ; -- annihilerbar..av.1
  annihilerbarhet_1_N = mkN "annihilerbarhet" ; -- annihilerbarhet..nn.1
  annihilering_1_N = mkN "annihilering" ; -- annihilering..nn.1
  anno_1_Adv = mkAdv "anno" ; -- anno..ab.1
  annons_1_N = mkN "annons" "annonser" ; -- annons..nn.1
  annonsblad_1_N = mkN "annonsblad" neutrum  ; -- annonsblad..nn.1
  annonsbojkott_1_N = mkN "annonsbojkott" "annonsbojkotter" ; -- annonsbojkott..nn.1
  annonsbyrå_1_N = mkN "annonsbyrå" "annonsbyråer" ; -- annonsbyrå..nn.1
  annonsera_1_V = mkV "annonserar" ; -- annonsera..vb.1
  annonserande_1_N = mkN "annonserande" ; -- annonserande..nn.1
  annonserbar_1_A = mkA "annonserbar" ; -- annonserbar..av.1
  annonserbarhet_1_N = mkN "annonserbarhet" ; -- annonserbarhet..nn.1
  annonsering_1_N = mkN "annonsering" ; -- annonsering..nn.1
  annonsinkomst_1_N = mkN "annonsinkomst" "annonsinkomster" ; -- annonsinkomst..nn.1
  annonskampanj_1_N = mkN "annonskampanj" "annonskampanjer" ; -- annonskampanj..nn.1
  annonspelare_1_N = mkN "annonspelare" utrum  ; -- annonspelare..nn.1
  annonsplats_1_N = mkN "annonsplats" "annonsplatser" ; -- annonsplats..nn.1
  annonssvar_1_N = mkN "annonssvar" neutrum  ; -- annonssvar..nn.1
  annonstavla_1_N = mkN "annonstavla" ; -- annonstavla..nn.1
  annonstidning_1_N = mkN "annonstidning" ; -- annonstidning..nn.1
  annonsör_1_N = mkN "annonsör" "annonsörer" ; -- annonsör..nn.1
  annorledes_1_Adv = mkAdv "annorledes" ; -- annorledes..ab.1
  annorlunda_1_Adv = mkAdv "annorlunda" ; -- annorlunda..ab.1
  annorlunda_1_A = mkA "annorlunda" ; -- annorlunda..av.1
  annorstädes_1_Adv = mkAdv "annorstädes" ; -- annorstädes..ab.1
  annotation_1_N = mkN "annotation" ; -- annotation..nn.1
  annotationsbok_1_N = mkN "annotationsbok" "annotationsböcker" ; -- annotationsbok..nn.1
  annotera_1_V = mkV "annoterar" ; -- annotera..vb.1
  annoterande_1_N = mkN "annoterande" ; -- annoterande..nn.1
  annoterbar_1_A = mkA "annoterbar" ; -- annoterbar..av.1
  annoterbarhet_1_N = mkN "annoterbarhet" ; -- annoterbarhet..nn.1
  annotering_1_N = mkN "annotering" ; -- annotering..nn.1
  annuell_1_A = mkA "annuell" ; -- annuell..av.1
  annuitet_1_N = mkN "annuitet" "annuiteter" ; -- annuitet..nn.1
  annuitetslån_1_N = mkN "annuitetslån" neutrum  ; -- annuitetslån..nn.1
  annullera_1_V = mkV "annullerar" ; -- annullera..vb.1
  annullerande_1_N = mkN "annullerande" ; -- annullerande..nn.1
  annullerbar_1_A = mkA "annullerbar" ; -- annullerbar..av.1
  annullerbarhet_1_N = mkN "annullerbarhet" ; -- annullerbarhet..nn.1
  annullering_1_N = mkN "annullering" ; -- annullering..nn.1
  anod_1_N = mkN "anod" "anoder" ; -- anod..nn.1
  anodisera_1_V = mkV "anodiserar" ; -- anodisera..vb.1
  anodiserande_1_N = mkN "anodiserande" ; -- anodiserande..nn.1
  anodiserbar_1_A = mkA "anodiserbar" ; -- anodiserbar..av.1
  anodiserbarhet_1_N = mkN "anodiserbarhet" ; -- anodiserbarhet..nn.1
  anodisering_1_N = mkN "anodisering" ; -- anodisering..nn.1
  anodonti_1_N = mkN "anodonti" ; -- anodonti..nn.1
  anoftalmi_1_N = mkN "anoftalmi" ; -- anoftalmi..nn.1
  anomal_1_A = mkA "anomal" ; -- anomal..av.1
  anomali_1_N = mkN "anomali" "anomalier" ; -- anomali..nn.1
  anomalisk_1_A = mkA "anomalisk" ; -- anomalisk..av.1
  anomalistisk_1_A = mkA "anomalistisk" ; -- anomalistisk..av.1
  anomi_1_N = mkN "anomi" "anomier" ; -- anomi..nn.1
  anonym_1_A = mkA "anonym" ; -- anonym..av.1
  anonymhet_1_N = mkN "anonymhet" ; -- anonymhet..nn.1
  anonymisera_1_V = mkV "anonymiserar" ; -- anonymisera..vb.1
  anonymiserande_1_N = mkN "anonymiserande" ; -- anonymiserande..nn.1
  anonymiserbar_1_A = mkA "anonymiserbar" ; -- anonymiserbar..av.1
  anonymiserbarhet_1_N = mkN "anonymiserbarhet" ; -- anonymiserbarhet..nn.1
  anonymisering_1_N = mkN "anonymisering" ; -- anonymisering..nn.1
  anonymiseringsverktyg_1_N = mkN "anonymiseringsverktyg" neutrum  ; -- anonymiseringsverktyg..nn.1
  anonymitet_1_N = mkN "anonymitet" "anonymiteter" ; -- anonymitet..nn.1
  anorak_1_N = mkN "anorak" "anoraker" ; -- anorak..nn.1
  anordna_1_V = mkV "anordnar" ; -- anordna..vb.1
  anordnande_1_N = mkN "anordnande" ; -- anordnande..nn.1
  anordnare_1_N = mkN "anordnare" utrum  ; -- anordnare..nn.1
  anordning_1_N = mkN "anordning" ; -- anordning..nn.1
  anorektiker_1_N = mkN "anorektiker" "anorektikern" "anorektiker" "anorektikerna" ; -- anorektiker..nn.1
  anorektisk_1_A = mkA "anorektisk" ; -- anorektisk..av.1
  anorektiskhet_1_N = mkN "anorektiskhet" ; -- anorektiskhet..nn.1
  anorexi_1_N = mkN "anorexi" "anorexier" ; -- anorexi..nn.1
  anorexihets_1_N = mkN "anorexihets" ; -- anorexihets..nn.1
  anormal_1_A = mkA "anormal" ; -- anormal..av.1
  anosmi_1_N = mkN "anosmi" ; -- anosmi..nn.1
  anoxemi_1_N = mkN "anoxemi" ; -- anoxemi..nn.1
  anoxi_1_N = mkN "anoxi" ; -- anoxi..nn.1
  anpart_1_N = mkN "anpart" ; -- anpart..nn.1
  anpassa_1_V = mkV "anpassar" ; -- anpassa..vb.1
  anpassande_1_N = mkN "anpassande" ; -- anpassande..nn.1
  anpassbar_1_A = mkA "anpassbar" ; -- anpassbar..av.1
  anpassbarhet_1_N = mkN "anpassbarhet" ; -- anpassbarhet..nn.1
  anpasslig_1_A = mkA "anpasslig" ; -- anpasslig..av.1
  anpasslighet_1_N = mkN "anpasslighet" ; -- anpasslighet..nn.1
  anpassling_1_N = mkN "anpassling" ; -- anpassling..nn.1
  anpassning_1_N = mkN "anpassning" ; -- anpassning..nn.1
  anpassningsbar_1_A = mkA "anpassningsbar" ; -- anpassningsbar..av.1
  anpassningsförmåga_1_N = mkN "anpassningsförmåga" ; -- anpassningsförmåga..nn.1
  anpassningsgrupp_1_N = mkN "anpassningsgrupp" "anpassningsgrupper" ; -- anpassningsgrupp..nn.1
  anpassningsklinik_1_N = mkN "anpassningsklinik" "anpassningskliniker" ; -- anpassningsklinik..nn.1
  anrik_1_A = mkA "anrik" ; -- anrik..av.1
  anrika_1_V = mkV "anrikar" ; -- anrika..vb.1
  anrikande_1_N = mkN "anrikande" ; -- anrikande..nn.1
  anrikhet_1_N = mkN "anrikhet" ; -- anrikhet..nn.1
  anrikning_1_N = mkN "anrikning" ; -- anrikning..nn.1
  anrikningsanläggning_1_N = mkN "anrikningsanläggning" ; -- anrikningsanläggning..nn.1
  anrop_1_N = mkN "anrop" neutrum  ; -- anrop..nn.1
  anropa_1_V = mkV "anropar" ; -- anropa..vb.1
  anropande_1_N = mkN "anropande" ; -- anropande..nn.1
  anropning_1_N = mkN "anropning" ; -- anropning..nn.1
  anropsknapp_1_N = mkN "anropsknapp" ; -- anropsknapp..nn.1
  anropsnummer_1_N = mkN "anropsnummer" neutrum  ; -- anropsnummer..nn.1
  anropssignal_1_N = mkN "anropssignal" "anropssignaler" ; -- anropssignal..nn.1
  anryckning_1_N = mkN "anryckning" ; -- anryckning..nn.1
  anrätta_1_V = mkV "anrättar" ; -- anrätta..vb.1
  anrättande_1_N = mkN "anrättande" ; -- anrättande..nn.1
  anrättning_1_N = mkN "anrättning" ; -- anrättning..nn.1
  ans_1_N = mkN "ans" ; -- ans..nn.1
  ansa_1_V = mkV "ansar" ; -- ansa..vb.1
  ansamla_1_V = mkV "ansamlar" ; -- ansamla..vb.1
  ansamlande_1_N = mkN "ansamlande" ; -- ansamlande..nn.1
  ansamling_1_N = mkN "ansamling" ; -- ansamling..nn.1
  ansande_1_N = mkN "ansande" ; -- ansande..nn.1
  ansats_1_N = mkN "ansats" "ansatser" ; -- ansats..nn.1
  ansatsbana_1_N = mkN "ansatsbana" ; -- ansatsbana..nn.1
  ansatsrör_1_N = mkN "ansatsrör" neutrum  ; -- ansatsrör..nn.1
  anse_1_V = mkV "anse" "ansåg" "ansett" ; -- anse..vb.1
  ansedd_1_A = mkA "ansedd" ; -- ansedd..av.1
  anseddhet_1_N = mkN "anseddhet" ; -- anseddhet..nn.1
  ansedel_1_N = mkN "ansedel" ; -- ansedel..nn.1
  anseende_1_N = mkN "anseende" ; -- anseende..nn.1
  ansenlig_1_A = mkA "ansenlig" ; -- ansenlig..av.1
  ansenlighet_1_N = mkN "ansenlighet" ; -- ansenlighet..nn.1
  ansikte_1_N = mkN "ansikte" ; -- ansikte..nn.1
  ansiktsasymmetri_1_N = mkN "ansiktsasymmetri" "ansiktsasymmetrier" ; -- ansiktsasymmetri..nn.1
  ansiktsbehandling_1_N = mkN "ansiktsbehandling" ; -- ansiktsbehandling..nn.1
  ansiktsbehåring_1_N = mkN "ansiktsbehåring" ; -- ansiktsbehåring..nn.1
  ansiktsbjudning_1_N = mkN "ansiktsbjudning" ; -- ansiktsbjudning..nn.1
  ansiktsblind_1_A = mkA "ansiktsblind" ; -- ansiktsblind..av.1
  ansiktsblindhet_1_N = mkN "ansiktsblindhet" "ansiktsblindheter" ; -- ansiktsblindhet..nn.1
  ansiktscancer_1_N = mkN "ansiktscancer" ; -- ansiktscancer..nn.1
  ansiktsdermatos_1_N = mkN "ansiktsdermatos" "ansiktsdermatoser" ; -- ansiktsdermatos..nn.1
  ansiktsdrag_1_N = mkN "ansiktsdrag" neutrum  ; -- ansiktsdrag..nn.1
  ansiktsform_1_N = mkN "ansiktsform" "ansiktsformer" ; -- ansiktsform..nn.1
  ansiktsfärg_1_N = mkN "ansiktsfärg" "ansiktsfärger" ; -- ansiktsfärg..nn.1
  ansiktsförlamning_1_N = mkN "ansiktsförlamning" ; -- ansiktsförlamning..nn.1
  ansiktsigenkänning_1_N = mkN "ansiktsigenkänning" ; -- ansiktsigenkänning..nn.1
  ansiktskräm_1_N = mkN "ansiktskräm" "ansiktskrämer" ; -- ansiktskräm..nn.1
  ansiktslyft_1_N = mkN "ansiktslyft" neutrum  ; -- ansiktslyft..nn.1
  ansiktslyftning_1_N = mkN "ansiktslyftning" ; -- ansiktslyftning..nn.1
  ansiktslös_1_A = mkA "ansiktslös" ; -- ansiktslös..av.1
  ansiktsmask_1_N = mkN "ansiktsmask" "ansiktsmasker" ; -- ansiktsmask..nn.1
  ansiktsmissbildning_1_N = mkN "ansiktsmissbildning" ; -- ansiktsmissbildning..nn.1
  ansiktsmuskel_1_N = mkN "ansiktsmuskel" "ansiktsmuskeln" "ansiktsmuskler" "ansiktsmusklerna" ; -- ansiktsmuskel..nn.1
  ansiktsmålning_1_N = mkN "ansiktsmålning" ; -- ansiktsmålning..nn.1
  ansiktsnerv_1_N = mkN "ansiktsnerv" "ansiktsnerver" ; -- ansiktsnerv..nn.1
  ansiktsnervssjukdom_1_N = mkN "ansiktsnervssjukdom" ; -- ansiktsnervssjukdom..nn.1
  ansiktsneuralgi_1_N = mkN "ansiktsneuralgi" "ansiktsneuralgier" ; -- ansiktsneuralgi..nn.1
  ansiktsoval_1_N = mkN "ansiktsoval" "ansiktsovaler" ; -- ansiktsoval..nn.1
  ansiktsskada_1_N = mkN "ansiktsskada" ; -- ansiktsskada..nn.1
  ansiktsskydd_1_N = mkN "ansiktsskydd" neutrum  ; -- ansiktsskydd..nn.1
  ansiktssmärta_1_N = mkN "ansiktssmärta" ; -- ansiktssmärta..nn.1
  ansiktstumör_1_N = mkN "ansiktstumör" "ansiktstumörer" ; -- ansiktstumör..nn.1
  ansiktsuttryck_1_N = mkN "ansiktsuttryck" neutrum  ; -- ansiktsuttryck..nn.1
  ansjovis_1_N = mkN "ansjovis" ; -- ansjovis..nn.1
  anskaffa_1_V = mkV "anskaffar" ; -- anskaffa..vb.1
  anskaffande_1_N = mkN "anskaffande" ; -- anskaffande..nn.1
  anskaffare_1_N = mkN "anskaffare" utrum  ; -- anskaffare..nn.1
  anskaffbar_1_A = mkA "anskaffbar" ; -- anskaffbar..av.1
  anskaffning_1_N = mkN "anskaffning" ; -- anskaffning..nn.1
  anskaffningsdag_1_N = mkN "anskaffningsdag" ; -- anskaffningsdag..nn.1
  anskaffningskostnad_1_N = mkN "anskaffningskostnad" "anskaffningskostnader" ; -- anskaffningskostnad..nn.1
  anskri_1_N = mkN "anskri" "anskriet" "anskrin" "anskrina" ; -- anskri..nn.1
  anskriven_1_A = mkA "anskriven" ; -- anskriven..av.1
  anskrämlig_1_A = mkA "anskrämlig" ; -- anskrämlig..av.1
  anskrämlighet_1_N = mkN "anskrämlighet" "anskrämligheter" ; -- anskrämlighet..nn.1
  anslag_1_N = mkN "anslag" neutrum  ; -- anslag..nn.1
  anslagsbeviljande_1_A = mkA "anslagsbeviljande" ; -- anslagsbeviljande..av.1
  anslagsbevillning_1_N = mkN "anslagsbevillning" ; -- anslagsbevillning..nn.1
  anslagsframställning_1_N = mkN "anslagsframställning" ; -- anslagsframställning..nn.1
  anslagsfråga_1_N = mkN "anslagsfråga" ; -- anslagsfråga..nn.1
  anslagsgivande_1_A = mkA "anslagsgivande" ; -- anslagsgivande..av.1
  anslagsmässig_1_A = mkA "anslagsmässig" ; -- anslagsmässig..av.1
  anslagssumma_1_N = mkN "anslagssumma" ; -- anslagssumma..nn.1
  anslagstavla_1_N = mkN "anslagstavla" ; -- anslagstavla..nn.1
  anslagstid_1_N = mkN "anslagstid" "anslagstider" ; -- anslagstid..nn.1
  anslagsäskande_1_N = mkN "anslagsäskande" ; -- anslagsäskande..nn.1
  ansluta_1_V = mkV "ansluta" "anslöt" "anslutit" ; -- ansluta..vb.1
  anslutande_1_N = mkN "anslutande" ; -- anslutande..nn.1
  anslutning_1_N = mkN "anslutning" ; -- anslutning..nn.1
  anslutningsavtal_1_N = mkN "anslutningsavtal" neutrum  ; -- anslutningsavtal..nn.1
  anslutningsbox_1_N = mkN "anslutningsbox" ; -- anslutningsbox..nn.1
  anslutningskabel_1_N = mkN "anslutningskabel" ; -- anslutningskabel..nn.1
  anslutningskontakt_1_N = mkN "anslutningskontakt" "anslutningskontakter" ; -- anslutningskontakt..nn.1
  anslutningspunkt_1_N = mkN "anslutningspunkt" "anslutningspunkter" ; -- anslutningspunkt..nn.1
  anslutningsserver_1_N = mkN "anslutningsserver" ; -- anslutningsserver..nn.1
  anslutningssladd_1_N = mkN "anslutningssladd" ; -- anslutningssladd..nn.1
  anslå_1_V = mkV "anslå" "anslog" "anslagit" ; -- anslå..vb.1
  anslående_1_A = mkA "anslående" ; -- anslående..av.1
  anslående_1_N = mkN "anslående" ; -- anslående..nn.1
  ansning_1_N = mkN "ansning" ; -- ansning..nn.1
  anspann_1_N = mkN "anspann" neutrum  ; -- anspann..nn.1
  anspela_1_V = mkV "anspelar" ; -- anspela..vb.1
  anspelande_1_N = mkN "anspelande" ; -- anspelande..nn.1
  anspelning_1_N = mkN "anspelning" ; -- anspelning..nn.1
  anspråk_1_N = mkN "anspråk" neutrum  ; -- anspråk..nn.1
  anspråklös_1_A = mkA "anspråklös" ; -- anspråklös..av.1
  anspråksfull_1_A = mkA "anspråksfull" ; -- anspråksfull..av.1
  anspråksfullhet_1_N = mkN "anspråksfullhet" ; -- anspråksfullhet..nn.1
  anspråkslös_1_A = mkA "anspråkslös" ; -- anspråkslös..av.1
  anspråkslöshet_1_N = mkN "anspråkslöshet" "anspråkslösheter" ; -- anspråkslöshet..nn.1
  anspänd_1_A = mkA "anspänd" ; -- anspänd..av.1
  anspändhet_1_N = mkN "anspändhet" ; -- anspändhet..nn.1
  anspänning_1_N = mkN "anspänning" ; -- anspänning..nn.1
  anstalt_1_N = mkN "anstalt" "anstalter" ; -- anstalt..nn.1
  anstalta_1_V = mkV "anstaltar" ; -- anstalta..vb.1
  anstaltande_1_N = mkN "anstaltande" ; -- anstaltande..nn.1
  anstaltspastor_1_N = mkN "anstaltspastor" "anstaltspastorer" ; -- anstaltspastor..nn.1
  anstaltsvistelse_1_N = mkN "anstaltsvistelse" "anstaltsvistelser" ; -- anstaltsvistelse..nn.1
  anstaltsvård_1_N = mkN "anstaltsvård" ; -- anstaltsvård..nn.1
  anstifta_1_V = mkV "anstiftar" ; -- anstifta..vb.1
  anstiftande_1_N = mkN "anstiftande" ; -- anstiftande..nn.1
  anstiftare_1_N = mkN "anstiftare" utrum  ; -- anstiftare..nn.1
  anstiftelse_1_N = mkN "anstiftelse" utrum  ; -- anstiftelse..nn.1
  anstorma_1_V = mkV "anstormar" ; -- anstorma..vb.1
  anstormande_1_N = mkN "anstormande" ; -- anstormande..nn.1
  anstormning_1_N = mkN "anstormning" ; -- anstormning..nn.1
  anstruken_1_A = mkA "anstruken" ; -- anstruken..av.1
  anstrukenhet_1_N = mkN "anstrukenhet" ; -- anstrukenhet..nn.1
  anstryka_1_V = mkV "anstryka" "anströk" "anstrukit" ; -- anstryka..vb.1
  anstrykande_1_N = mkN "anstrykande" ; -- anstrykande..nn.1
  anstrykare_1_N = mkN "anstrykare" utrum  ; -- anstrykare..nn.1
  anstrykning_1_N = mkN "anstrykning" ; -- anstrykning..nn.1
  anstränga_1_V = mkV "anstränger" ; -- anstränga..vb.1
  ansträngande_1_A = mkA "ansträngande" ; -- ansträngande..av.1
  ansträngande_1_N = mkN "ansträngande" ; -- ansträngande..nn.1
  ansträngd_1_A = mkA "ansträngd" "ansträngt" ; -- ansträngd..av.1
  ansträngdhet_1_N = mkN "ansträngdhet" ; -- ansträngdhet..nn.1
  ansträngning_1_N = mkN "ansträngning" ; -- ansträngning..nn.1
  ansträngningsinkontinens_1_N = mkN "ansträngningsinkontinens" ; -- ansträngningsinkontinens..nn.1
  anstucken_1_A = mkA "anstucken" ; -- anstucken..av.1
  anstuckenhet_1_N = mkN "anstuckenhet" ; -- anstuckenhet..nn.1
  anställa_1_V = mkV "anställer" ; -- anställa..vb.1
  anställande_1_N = mkN "anställande" ; -- anställande..nn.1
  anställare_1_N = mkN "anställare" utrum  ; -- anställare..nn.1
  anställbar_1_A = mkA "anställbar" ; -- anställbar..av.1
  anställd_1_A = mkA "anställd" "anställt" ; -- anställd..av.1
  anställning_1_N = mkN "anställning" ; -- anställning..nn.1
  anställningsavtal_1_N = mkN "anställningsavtal" neutrum  ; -- anställningsavtal..nn.1
  anställningsbar_1_A = mkA "anställningsbar" ; -- anställningsbar..av.1
  anställningsintervju_1_N = mkN "anställningsintervju" "anställningsintervjun" "anställningsintervjuer" "anställningsintervjuerna" ; -- anställningsintervju..nn.1
  anställningskommitté_1_N = mkN "anställningskommitté" "anställningskommittéer" ; -- anställningskommitté..nn.1
  anställningskontrakt_1_N = mkN "anställningskontrakt" neutrum  ; -- anställningskontrakt..nn.1
  anställningsrättighet_1_N = mkN "anställningsrättighet" "anställningsrättigheter" ; -- anställningsrättighet..nn.1
  anställningsskydd_1_N = mkN "anställningsskydd" neutrum  ; -- anställningsskydd..nn.1
  anställningsstopp_1_N = mkN "anställningsstopp" neutrum  ; -- anställningsstopp..nn.1
  anställningstid_1_N = mkN "anställningstid" "anställningstider" ; -- anställningstid..nn.1
  anställningstrygghet_1_N = mkN "anställningstrygghet" ; -- anställningstrygghet..nn.1
  anställningsvillkor_1_N = mkN "anställningsvillkor" neutrum  ; -- anställningsvillkor..nn.1
  anständig_1_A = mkA "anständig" ; -- anständig..av.1
  anständighet_1_N = mkN "anständighet" "anständigheter" ; -- anständighet..nn.1
  anständighetsbegrepp_1_N = mkN "anständighetsbegrepp" neutrum  ; -- anständighetsbegrepp..nn.1
  anständigtvis_1_Adv = mkAdv "anständigtvis" ; -- anständigtvis..ab.1
  anstå_1_V = mkV "anstå" "anstod" "anstått" ; -- anstå..vb.1
  anstående_1_N = mkN "anstående" ; -- anstående..nn.1
  anstånd_1_N = mkN "anstånd" neutrum  ; -- anstånd..nn.1
  anståndstid_1_N = mkN "anståndstid" "anståndstider" ; -- anståndstid..nn.1
  anstöt_1_N = mkN "anstöt" ; -- anstöt..nn.1
  anstötlig_1_A = mkA "anstötlig" ; -- anstötlig..av.1
  anstötlighet_1_N = mkN "anstötlighet" "anstötligheter" ; -- anstötlighet..nn.1
  ansvar_1_N = mkN "ansvar" neutrum  ; -- ansvar..nn.1
  ansvara_1_V = mkV "ansvarar" ; -- ansvara..vb.1
  ansvarande_1_N = mkN "ansvarande" ; -- ansvarande..nn.1
  ansvarig_1_A = mkA "ansvarig" ; -- ansvarig..av.1
  ansvarighet_1_N = mkN "ansvarighet" ; -- ansvarighet..nn.1
  ansvarighetsförsäkring_1_N = mkN "ansvarighetsförsäkring" ; -- ansvarighetsförsäkring..nn.1
  ansvaring_1_N = mkN "ansvaring" ; -- ansvaring..nn.1
  ansvarsbefrielse_1_N = mkN "ansvarsbefrielse" "ansvarsbefrielser" ; -- ansvarsbefrielse..nn.1
  ansvarsfri_1_A = mkA "ansvarsfri" "ansvarsfritt" ; -- ansvarsfri..av.1
  ansvarsfrihet_1_N = mkN "ansvarsfrihet" "ansvarsfriheter" ; -- ansvarsfrihet..nn.1
  ansvarsfull_1_A = mkA "ansvarsfull" ; -- ansvarsfull..av.1
  ansvarsfullhet_1_N = mkN "ansvarsfullhet" ; -- ansvarsfullhet..nn.1
  ansvarsförsäkring_1_N = mkN "ansvarsförsäkring" ; -- ansvarsförsäkring..nn.1
  ansvarskännande_1_A = mkA "ansvarskännande" ; -- ansvarskännande..av.1
  ansvarskännande_1_N = mkN "ansvarskännande" ; -- ansvarskännande..nn.1
  ansvarskänsla_1_N = mkN "ansvarskänsla" ; -- ansvarskänsla..nn.1
  ansvarslös_1_A = mkA "ansvarslös" ; -- ansvarslös..av.1
  ansvarslöshet_1_N = mkN "ansvarslöshet" ; -- ansvarslöshet..nn.1
  ansvarsnämnd_1_N = mkN "ansvarsnämnd" "ansvarsnämnder" ; -- ansvarsnämnd..nn.1
  ansvarsområde_1_N = mkN "ansvarsområde" ; -- ansvarsområde..nn.1
  ansvarspåföljd_1_N = mkN "ansvarspåföljd" "ansvarspåföljder" ; -- ansvarspåföljd..nn.1
  ansvarsskyldig_1_A = mkA "ansvarsskyldig" ; -- ansvarsskyldig..av.1
  ansvarsskyldighet_1_N = mkN "ansvarsskyldighet" "ansvarsskyldigheter" ; -- ansvarsskyldighet..nn.1
  ansvarstagande_1_A = mkA "ansvarstagande" ; -- ansvarstagande..av.1
  ansvarstagande_1_N = mkN "ansvarstagande" ; -- ansvarstagande..nn.1
  ansvarsutkrävande_1_N = mkN "ansvarsutkrävande" ; -- ansvarsutkrävande..nn.1
  ansvarsyrkande_1_N = mkN "ansvarsyrkande" ; -- ansvarsyrkande..nn.1
  ansvälla_1_V = mkV "ansväller" ; -- ansvälla..vb.1
  ansvällande_1_N = mkN "ansvällande" ; -- ansvällande..nn.1
  ansvälld_1_A = mkA "ansvälld" "ansvällt" ; -- ansvälld..av.1
  ansvälldhet_1_N = mkN "ansvälldhet" ; -- ansvälldhet..nn.1
  ansvällning_1_N = mkN "ansvällning" ; -- ansvällning..nn.1
  ansätta_1_V = mkV "ansätta" "ansätter" "ansätt" "ansatte" "ansatt" "ansatt" ; -- ansätta..vb.1
  ansättande_1_N = mkN "ansättande" ; -- ansättande..nn.1
  ansättning_1_N = mkN "ansättning" ; -- ansättning..nn.1
  ansättningsskruv_1_N = mkN "ansättningsskruv" ; -- ansättningsskruv..nn.1
  ansöka_1_V = mkV "ansöker" ; -- ansöka..vb.1
  ansökande_1_N = mkN "ansökande" ; -- ansökande..nn.1
  ansökarland_1_N = mkN "ansökarland" "ansökarlandet" "ansökarländer" "ansökarländerna" ; -- ansökarland..nn.1
  ansökning_1_N = mkN "ansökning" ; -- ansökning..nn.1
  ansökningshandling_1_N = mkN "ansökningshandling" ; -- ansökningshandling..nn.1
  ansökningspapper_1_N = mkN "ansökningspapper" neutrum  ; -- ansökningspapper..nn.1
  ansökningstid_1_N = mkN "ansökningstid" "ansökningstider" ; -- ansökningstid..nn.1
  ansökningstryck_1_N = mkN "ansökningstryck" neutrum  ; -- ansökningstryck..nn.1
  anta_1_V = mkV "antaga" "antog" "antagit" ; -- anta..vb.1
  antabus_1_N = mkN "antabus" ; -- antabus..nn.1
  antagande_1_N = mkN "antagande" ; -- antagande..nn.1
  antaglig_1_A = mkA "antaglig" ; -- antaglig..av.1
  antagligen_1_Adv = mkAdv "antagligen" ; -- antagligen..ab.1
  antaglighet_1_N = mkN "antaglighet" ; -- antaglighet..nn.1
  antagning_1_N = mkN "antagning" ; -- antagning..nn.1
  antagningsbevis_1_N = mkN "antagningsbevis" neutrum  ; -- antagningsbevis..nn.1
  antagonism_1_N = mkN "antagonism" "antagonismer" ; -- antagonism..nn.1
  antagonist_1_N = mkN "antagonist" "antagonister" ; -- antagonist..nn.1
  antagonistisk_1_A = mkA "antagonistisk" ; -- antagonistisk..av.1
  antal_1_N = mkN "antal" neutrum  ; -- antal..nn.1
  antalsberäkning_1_N = mkN "antalsberäkning" ; -- antalsberäkning..nn.1
  antalsmässig_1_A = mkA "antalsmässig" ; -- antalsmässig..av.1
  antarktisk_1_A = mkA "antarktisk" ; -- antarktisk..av.1
  antasta_1_V = mkV "antastar" ; -- antasta..vb.1
  antastande_1_N = mkN "antastande" ; -- antastande..nn.1
  antavla_1_N = mkN "antavla" ; -- antavla..nn.1
  antecedentia_1_N = mkN "antecedentia" "antecedentiat" "antecedentia" "antecedentiana" ; -- antecedentia..nn.1
  antecipation_1_N = mkN "antecipation" ; -- antecipation..nn.1
  antecipativ_1_A = mkA "antecipativ" ; -- antecipativ..av.1
  antecipera_1_V = mkV "anteciperar" ; -- antecipera..vb.1
  anteciperande_1_N = mkN "anteciperande" ; -- anteciperande..nn.1
  anteciperbar_1_A = mkA "anteciperbar" ; -- anteciperbar..av.1
  anteciperbarhet_1_N = mkN "anteciperbarhet" ; -- anteciperbarhet..nn.1
  antecipering_1_N = mkN "antecipering" ; -- antecipering..nn.1
  anteckna_1_V = mkV "antecknar" ; -- anteckna..vb.1
  antecknande_1_N = mkN "antecknande" ; -- antecknande..nn.1
  antecknare_1_N = mkN "antecknare" utrum  ; -- antecknare..nn.1
  anteckning_1_N = mkN "anteckning" ; -- anteckning..nn.1
  anteckningsblock_1_N = mkN "anteckningsblock" neutrum  ; -- anteckningsblock..nn.1
  anteckningsbok_1_N = mkN "anteckningsbok" "anteckningsböcker" ; -- anteckningsbok..nn.1
  antedatera_1_V = mkV "antedaterar" ; -- antedatera..vb.1
  antedaterande_1_N = mkN "antedaterande" ; -- antedaterande..nn.1
  antedaterbar_1_A = mkA "antedaterbar" ; -- antedaterbar..av.1
  antedaterbarhet_1_N = mkN "antedaterbarhet" ; -- antedaterbarhet..nn.1
  antedatering_1_N = mkN "antedatering" ; -- antedatering..nn.1
  antediluviansk_1_A = mkA "antediluviansk" ; -- antediluviansk..av.1
  antefix_1_N = mkN "antefix" "antefixer" ; -- antefix..nn.1
  antenn_1_N = mkN "antenn" "antenner" ; -- antenn..nn.1
  antennkabel_1_N = mkN "antennkabel" ; -- antennkabel..nn.1
  antennkörtel_1_N = mkN "antennkörtel" ; -- antennkörtel..nn.1
  antennuttag_1_N = mkN "antennuttag" neutrum  ; -- antennuttag..nn.1
  antependium_1_N = mkN "antependium" "antependiet" "antependier" "antependierna" ; -- antependium..nn.1
  antepenultima_1_N = mkN "antepenultima" ; -- antepenultima..nn.1
  anti_gbm_sjukdom_1_N = mkN "anti-gbm-sjukdom" ; -- anti-gbm-sjukdom..nn.1
  anti_1_A = mkA "anti" ; -- anti..av.1
  antiabortlag_1_N = mkN "antiabortlag" ; -- antiabortlag..nn.1
  antiamerikansk_1_A = mkA "antiamerikansk" ; -- antiamerikansk..av.1
  antibakteriell_1_A = mkA "antibakteriell" ; -- antibakteriell..av.1
  antibarbarus_1_N = mkN "antibarbarus" ; -- antibarbarus..nn.1
  antibiotika_1_N = mkN "antibiotika" ; -- antibiotika..nn.1
  antibiotikabehandling_1_N = mkN "antibiotikabehandling" ; -- antibiotikabehandling..nn.1
  antibiotikaresistens_1_N = mkN "antibiotikaresistens" ; -- antibiotikaresistens..nn.1
  antibiotikaresistent_1_A = mkA "antibiotikaresistent" "antibiotikaresistent" ; -- antibiotikaresistent..av.1
  antibiotikum_1_N = mkN "antibiotikum" "antibiotikumet" "antibiotika" "antibiotikana" ; -- antibiotikum..nn.1
  antibiotisk_1_A = mkA "antibiotisk" ; -- antibiotisk..av.1
  antichambrera_1_V = mkV "antichambrerar" ; -- antichambrera..vb.1
  antichambrerande_1_N = mkN "antichambrerande" ; -- antichambrerande..nn.1
  antichambrerbar_1_A = mkA "antichambrerbar" ; -- antichambrerbar..av.1
  antichambrerbarhet_1_N = mkN "antichambrerbarhet" ; -- antichambrerbarhet..nn.1
  antichambrering_1_N = mkN "antichambrering" ; -- antichambrering..nn.1
  anticyklon_1_N = mkN "anticyklon" "anticykloner" ; -- anticyklon..nn.1
  antidemokrat_1_N = mkN "antidemokrat" "antidemokrater" ; -- antidemokrat..nn.1
  antidemokratisk_1_A = mkA "antidemokratisk" ; -- antidemokratisk..av.1
  antidepressiv_1_A = mkA "antidepressiv" ; -- antidepressiv..av.1
  antidiskrimineringsbyrå_1_N = mkN "antidiskrimineringsbyrå" "antidiskrimineringsbyråer" ; -- antidiskrimineringsbyrå..nn.1
  antidot_1_N = mkN "antidot" "antidotet" "antidoter" "antidoterna" ; -- antidot..nn.1
  antielitistisk_1_A = mkA "antielitistisk" ; -- antielitistisk..av.1
  antietablissemangsretorik_1_N = mkN "antietablissemangsretorik" ; -- antietablissemangsretorik..nn.1
  antieuropeisk_1_A = mkA "antieuropeisk" ; -- antieuropeisk..av.1
  antiexpressionistisk_1_A = mkA "antiexpressionistisk" ; -- antiexpressionistisk..av.1
  antifascistisk_1_A = mkA "antifascistisk" ; -- antifascistisk..av.1
  antifoni_1_N = mkN "antifoni" "antifonier" ; -- antifoni..nn.1
  antifosfolipidsyndrom_1_N = mkN "antifosfolipidsyndrom" neutrum  ; -- antifosfolipidsyndrom..nn.1
  antifundamentalistisk_1_A = mkA "antifundamentalistisk" ; -- antifundamentalistisk..av.1
  antigen_1_N = mkN "antigen" "antigener" ; -- antigen..nn.1
  antiguan_1_N = mkN "antiguan" "antiguaner" ; -- antiguan..nn.1
  antiguansk_1_A = mkA "antiguansk" ; -- antiguansk..av.1
  antiguanska_1_N = mkN "antiguanska" ; -- antiguanska..nn.1
  antihelix_1_N = mkN "antihelix" ; -- antihelix..nn.1
  antihistamin_1_N = mkN "antihistamin" "antihistaminet" "antihistaminer" "antihistaminerna" ; -- antihistamin..nn.1
  antihjälte_1_N = mkN "antihjälte" utrum  ; -- antihjälte..nn.1
  antihumanistisk_1_A = mkA "antihumanistisk" ; -- antihumanistisk..av.1
  antiidealistisk_1_A = mkA "antiidealistisk" ; -- antiidealistisk..av.1
  antiimperialistisk_1_A = mkA "antiimperialistisk" ; -- antiimperialistisk..av.1
  antiindividualistisk_1_A = mkA "antiindividualistisk" ; -- antiindividualistisk..av.1
  antiinflammatorisk_1_A = mkA "antiinflammatorisk" ; -- antiinflammatorisk..av.1
  antiintellektualism_1_N = mkN "antiintellektualism" "antiintellektualismer" ; -- antiintellektualism..nn.1
  antiintellektualistisk_1_A = mkA "antiintellektualistisk" ; -- antiintellektualistisk..av.1
  antiintellektuell_1_A = mkA "antiintellektuell" ; -- antiintellektuell..av.1
  antiislamistisk_1_A = mkA "antiislamistisk" ; -- antiislamistisk..av.1
  antijudisk_1_A = mkA "antijudisk" ; -- antijudisk..av.1
  antik_1_A = mkA "antik" ; -- antik..av.1
  antik_1_N = mkN "antik" ; -- antik..nn.1
  antikbehandla_1_V = mkV "antikbehandlar" ; -- antikbehandla..vb.1
  antikbehandlande_1_N = mkN "antikbehandlande" ; -- antikbehandlande..nn.1
  antikfynda_1_V = mkV "antikfyndar" ; -- antikfynda..vb.1
  antikfyndande_1_N = mkN "antikfyndande" ; -- antikfyndande..nn.1
  antikisera_1_V = mkV "antikiserar" ; -- antikisera..vb.1
  antikiserande_1_N = mkN "antikiserande" ; -- antikiserande..nn.1
  antikiserbar_1_A = mkA "antikiserbar" ; -- antikiserbar..av.1
  antikiserbarhet_1_N = mkN "antikiserbarhet" ; -- antikiserbarhet..nn.1
  antikisering_1_N = mkN "antikisering" ; -- antikisering..nn.1
  antiklerikal_1_A = mkA "antiklerikal" ; -- antiklerikal..av.1
  antiklimax_1_N = mkN "antiklimax" ; -- antiklimax..nn.1
  antiklinal_1_N = mkN "antiklinal" "antiklinaler" ; -- antiklinal..nn.1
  antikljus_1_N = mkN "antikljus" neutrum  ; -- antikljus..nn.1
  antikommunism_1_N = mkN "antikommunism" "antikommunismer" ; -- antikommunism..nn.1
  antikommunistisk_1_A = mkA "antikommunistisk" ; -- antikommunistisk..av.1
  antikonceptionell_1_A = mkA "antikonceptionell" ; -- antikonceptionell..av.1
  antikorruptionsaktivist_1_N = mkN "antikorruptionsaktivist" "antikorruptionsaktivister" ; -- antikorruptionsaktivist..nn.1
  antikorruptionskonferens_1_N = mkN "antikorruptionskonferens" "antikorruptionskonferenser" ; -- antikorruptionskonferens..nn.1
  antikrist_1_N = mkN "antikrist" ; -- antikrist..nn.1
  antikristlig_1_A = mkA "antikristlig" ; -- antikristlig..av.1
  antikropp_1_N = mkN "antikropp" ; -- antikropp..nn.1
  antikroppsbrist_1_N = mkN "antikroppsbrist" ; -- antikroppsbrist..nn.1
  antiksamling_1_N = mkN "antiksamling" ; -- antiksamling..nn.1
  antikva_1_N = mkN "antikva" ; -- antikva..nn.1
  antikvariat_1_N = mkN "antikvariat" neutrum  ; -- antikvariat..nn.1
  antikvarie_1_N = mkN "antikvarie" "antikvarier" ; -- antikvarie..nn.1
  antikvarisk_1_A = mkA "antikvarisk" ; -- antikvarisk..av.1
  antikverad_1_A = mkA "antikverad" ; -- antikverad..av.1
  antikvitet_1_N = mkN "antikvitet" "antikviteter" ; -- antikvitet..nn.1
  antikvitetshandel_1_N = mkN "antikvitetshandel" ; -- antikvitetshandel..nn.1
  antikvitetshandlare_1_N = mkN "antikvitetshandlare" utrum  ; -- antikvitetshandlare..nn.1
  antikvitetsjägare_1_N = mkN "antikvitetsjägare" utrum  ; -- antikvitetsjägare..nn.1
  antikvitetssamling_1_N = mkN "antikvitetssamling" ; -- antikvitetssamling..nn.1
  antikvärde_1_N = mkN "antikvärde" ; -- antikvärde..nn.1
  antilop_1_N = mkN "antilop" "antiloper" ; -- antilop..nn.1
  antimakass_1_N = mkN "antimakass" "antimakasser" ; -- antimakass..nn.1
  antimateria_1_N = mkN "antimateria" ; -- antimateria..nn.1
  antimilitarism_1_N = mkN "antimilitarism" "antimilitarismer" ; -- antimilitarism..nn.1
  antimilitarist_1_N = mkN "antimilitarist" "antimilitarister" ; -- antimilitarist..nn.1
  antimilitaristisk_1_A = mkA "antimilitaristisk" ; -- antimilitaristisk..av.1
  antimon_1_N = mkN "antimon" ; -- antimon..nn.1
  antimonglans_1_N = mkN "antimonglans" ; -- antimonglans..nn.1
  antimögelbehandlad_1_A = mkA "antimögelbehandlad" ; -- antimögelbehandlad..av.1
  antinazistisk_1_A = mkA "antinazistisk" ; -- antinazistisk..av.1
  antingen_1_Adv = mkAdv "antingen" ; -- antingen..ab.1
  antinomi_1_N = mkN "antinomi" "antinomier" ; -- antinomi..nn.1
  antioxidant_1_N = mkN "antioxidant" "antioxidanter" ; -- antioxidant..nn.1
  antioxidationsmedel_1_N = mkN "antioxidationsmedel" neutrum  ; -- antioxidationsmedel..nn.1
  antipartikel_1_N = mkN "antipartikel" ; -- antipartikel..nn.1
  antipassad_1_N = mkN "antipassad" "antipassader" ; -- antipassad..nn.1
  antipati_1_N = mkN "antipati" "antipatier" ; -- antipati..nn.1
  antipatisk_1_A = mkA "antipatisk" ; -- antipatisk..av.1
  antipod_1_N = mkN "antipod" "antipoder" ; -- antipod..nn.1
  antipodisk_1_A = mkA "antipodisk" ; -- antipodisk..av.1
  antipolitisk_1_A = mkA "antipolitisk" ; -- antipolitisk..av.1
  antipsykiatri_1_N = mkN "antipsykiatri" ; -- antipsykiatri..nn.1
  antirasistisk_1_A = mkA "antirasistisk" ; -- antirasistisk..av.1
  antireflexbehandla_1_V = mkV "antireflexbehandlar" ; -- antireflexbehandla..vb.1
  antireligiös_1_A = mkA "antireligiös" ; -- antireligiös..av.1
  antirojalistisk_1_A = mkA "antirojalistisk" ; -- antirojalistisk..av.1
  antirullningsfena_1_N = mkN "antirullningsfena" ; -- antirullningsfena..nn.1
  antirynkkräm_1_N = mkN "antirynkkräm" "antirynkkrämer" ; -- antirynkkräm..nn.1
  antisemit_1_N = mkN "antisemit" "antisemiter" ; -- antisemit..nn.1
  antisemitisk_1_A = mkA "antisemitisk" ; -- antisemitisk..av.1
  antisemitism_1_N = mkN "antisemitism" "antisemitismer" ; -- antisemitism..nn.1
  antisemitledare_1_N = mkN "antisemitledare" utrum  ; -- antisemitledare..nn.1
  antiseptik_1_N = mkN "antiseptik" ; -- antiseptik..nn.1
  antiseptika_1_N = mkN "antiseptika" "antiseptikat" "antiseptika" "antiseptikana" ; -- antiseptika..nn.1
  antiseptisk_1_A = mkA "antiseptisk" ; -- antiseptisk..av.1
  antisionism_1_N = mkN "antisionism" "antisionismer" ; -- antisionism..nn.1
  antisionistisk_1_A = mkA "antisionistisk" ; -- antisionistisk..av.1
  antiskating_1_N = mkN "antiskating" ; -- antiskating..nn.1
  antisladdsystem_1_N = mkN "antisladdsystem" neutrum  ; -- antisladdsystem..nn.1
  antistatisk_1_A = mkA "antistatisk" ; -- antistatisk..av.1
  antistatmedel_1_N = mkN "antistatmedel" neutrum  ; -- antistatmedel..nn.1
  antisyrisk_1_A = mkA "antisyrisk" ; -- antisyrisk..av.1
  antites_1_N = mkN "antites" "antiteser" ; -- antites..nn.1
  antitetisk_1_A = mkA "antitetisk" ; -- antitetisk..av.1
  antitoxin_1_N = mkN "antitoxin" "antitoxiner" ; -- antitoxin..nn.1
  antitragus_1_N = mkN "antitragus" ; -- antitragus..nn.1
  antivibrationshandtag_1_N = mkN "antivibrationshandtag" neutrum  ; -- antivibrationshandtag..nn.1
  antiviral_1_A = mkA "antiviral" ; -- antiviral..av.1
  antivirusexpert_1_N = mkN "antivirusexpert" "antivirusexperter" ; -- antivirusexpert..nn.1
  antivirusprogram_1_N = mkN "antivirusprogram" "antivirusprogrammet" "antivirusprogram" "antivirusprogrammen" ; -- antivirusprogram..nn.1
  antiålderskräm_1_N = mkN "antiålderskräm" "antiålderskrämer" ; -- antiålderskräm..nn.1
  antologi_1_N = mkN "antologi" "antologier" ; -- antologi..nn.1
  antonym_1_A = mkA "antonym" ; -- antonym..av.1
  antonym_1_N = mkN "antonym" "antonymer" ; -- antonym..nn.1
  antracit_1_N = mkN "antracit" ; -- antracit..nn.1
  antracitkol_1_N = mkN "antracitkol" neutrum  ; -- antracitkol..nn.1
  antrakos_1_N = mkN "antrakos" ; -- antrakos..nn.1
  antrakosilikos_1_N = mkN "antrakosilikos" ; -- antrakosilikos..nn.1
  antrax_1_N = mkN "antrax" "antraxer" ; -- antrax..nn.1
  antropisk_1_A = mkA "antropisk" ; -- antropisk..av.1
  antropocentrisk_1_A = mkA "antropocentrisk" ; -- antropocentrisk..av.1
  antropofag_1_N = mkN "antropofag" "antropofager" ; -- antropofag..nn.1
  antropofagi_1_N = mkN "antropofagi" ; -- antropofagi..nn.1
  antropoid_1_N = mkN "antropoid" "antropoider" ; -- antropoid..nn.1
  antropolog_1_N = mkN "antropolog" "antropologer" ; -- antropolog..nn.1
  antropologi_1_N = mkN "antropologi" ; -- antropologi..nn.1
  antropologisk_1_A = mkA "antropologisk" ; -- antropologisk..av.1
  antropomorf_1_A = mkA "antropomorf" ; -- antropomorf..av.1
  antropomorfisk_1_A = mkA "antropomorfisk" ; -- antropomorfisk..av.1
  antropomorfism_1_N = mkN "antropomorfism" "antropomorfismer" ; -- antropomorfism..nn.1
  antropomorfistisk_1_A = mkA "antropomorfistisk" ; -- antropomorfistisk..av.1
  antroposof_1_N = mkN "antroposof" "antroposofer" ; -- antroposof..nn.1
  antroposofi_1_N = mkN "antroposofi" ; -- antroposofi..nn.1
  antroposofisk_1_A = mkA "antroposofisk" ; -- antroposofisk..av.1
  anträda_1_V = mkV "anträda" "anträdde" "anträtt" ; -- anträda..vb.1
  anträdande_1_N = mkN "anträdande" ; -- anträdande..nn.1
  anträde_1_N = mkN "anträde" ; -- anträde..nn.1
  anträffa_1_V = mkV "anträffar" ; -- anträffa..vb.1
  anträffande_1_N = mkN "anträffande" ; -- anträffande..nn.1
  anträffbar_1_A = mkA "anträffbar" ; -- anträffbar..av.1
  anträffbarhet_1_N = mkN "anträffbarhet" ; -- anträffbarhet..nn.1
  antvarda_1_V = mkV "antvardar" ; -- antvarda..vb.1
  antvardande_1_N = mkN "antvardande" ; -- antvardande..nn.1
  antyda_1_V = mkV "antyda" "antydde" "antytt" ; -- antyda..vb.1
  antydande_1_N = mkN "antydande" ; -- antydande..nn.1
  antydning_1_N = mkN "antydning" ; -- antydning..nn.1
  antydningsvis_1_Adv = mkAdv "antydningsvis" ; -- antydningsvis..ab.1
  antända_1_V = mkV "antänder" ; -- antända..vb.1
  antändande_1_N = mkN "antändande" ; -- antändande..nn.1
  antändbar_1_A = mkA "antändbar" ; -- antändbar..av.1
  antändbarhet_1_N = mkN "antändbarhet" ; -- antändbarhet..nn.1
  antändning_1_N = mkN "antändning" ; -- antändning..nn.1
  antåg_1_N = mkN "antåg" neutrum  ; -- antåg..nn.1
  antåga_1_V = mkV "antågar" ; -- antåga..vb.1
  antågande_1_N = mkN "antågande" ; -- antågande..nn.1
  anuri_1_N = mkN "anuri" ; -- anuri..nn.1
  anus_1_N = mkN "anus" ; -- anus..nn.1
  anvisa_1_V = mkV "anvisar" ; -- anvisa..vb.1
  anvisande_1_N = mkN "anvisande" ; -- anvisande..nn.1
  anvisning_1_N = mkN "anvisning" ; -- anvisning..nn.1
  anvisningskommun_1_N = mkN "anvisningskommun" "anvisningskommuner" ; -- anvisningskommun..nn.1
  anvisningsläkare_1_N = mkN "anvisningsläkare" utrum  ; -- anvisningsläkare..nn.1
  använda_1_V = mkV "använder" ; -- använda..vb.1
  användande_1_N = mkN "användande" ; -- användande..nn.1
  användare_1_N = mkN "användare" utrum  ; -- användare..nn.1
  användargrupp_1_N = mkN "användargrupp" "användargrupper" ; -- användargrupp..nn.1
  användarvänlig_1_A = mkA "användarvänlig" ; -- användarvänlig..av.1
  användarvänlighet_1_N = mkN "användarvänlighet" ; -- användarvänlighet..nn.1
  användbar_1_A = mkA "användbar" ; -- användbar..av.1
  användbarhet_1_N = mkN "användbarhet" "användbarheter" ; -- användbarhet..nn.1
  användbarhetsaspekt_1_N = mkN "användbarhetsaspekt" "användbarhetsaspekter" ; -- användbarhetsaspekt..nn.1
  användning_1_N = mkN "användning" ; -- användning..nn.1
  användningslösning_1_N = mkN "användningslösning" ; -- användningslösning..nn.1
  användningsmöjlighet_1_N = mkN "användningsmöjlighet" "användningsmöjligheter" ; -- användningsmöjlighet..nn.1
  användningsområde_1_N = mkN "användningsområde" ; -- användningsområde..nn.1
  användningssätt_1_N = mkN "användningssätt" neutrum  ; -- användningssätt..nn.1
  aorist_1_N = mkN "aorist" "aorister" ; -- aorist..nn.1
  aorta_1_N = mkN "aorta" ; -- aorta..nn.1
  aortaaneurysm_1_N = mkN "aortaaneurysm" neutrum  ; -- aortaaneurysm..nn.1
  aortabristning_1_N = mkN "aortabristning" ; -- aortabristning..nn.1
  aortabråck_1_N = mkN "aortabråck" neutrum  ; -- aortabråck..nn.1
  aortabåge_1_N = mkN "aortabåge" utrum  ; -- aortabåge..nn.1
  aortabågesyndrom_1_N = mkN "aortabågesyndrom" neutrum  ; -- aortabågesyndrom..nn.1
  aortadissektion_1_N = mkN "aortadissektion" ; -- aortadissektion..nn.1
  aortaförträngning_1_N = mkN "aortaförträngning" ; -- aortaförträngning..nn.1
  aortainflammation_1_N = mkN "aortainflammation" ; -- aortainflammation..nn.1
  aortainsufficiens_1_N = mkN "aortainsufficiens" "aortainsufficienser" ; -- aortainsufficiens..nn.1
  aortaklaff_1_N = mkN "aortaklaff" ; -- aortaklaff..nn.1
  aortaklaffinsufficiens_1_N = mkN "aortaklaffinsufficiens" "aortaklaffinsufficienser" ; -- aortaklaffinsufficiens..nn.1
  aortaklaffläckage_1_N = mkN "aortaklaffläckage" "aortaklaffläckageen" "aortaklaffläckageer" "aortaklaffläckageerna" ; -- aortaklaffläckage..nn.1
  aortaklaffprolaps_1_N = mkN "aortaklaffprolaps" "aortaklaffprolapser" ; -- aortaklaffprolaps..nn.1
  aortaklaffstenos_1_N = mkN "aortaklaffstenos" "aortaklaffstenoser" ; -- aortaklaffstenos..nn.1
  aortaklafförträngning_1_N = mkN "aortaklafförträngning" ; -- aortaklafförträngning..nn.1
  aortakoarktation_1_N = mkN "aortakoarktation" ; -- aortakoarktation..nn.1
  aortaruptur_1_N = mkN "aortaruptur" "aortarupturer" ; -- aortaruptur..nn.1
  aortasjukdom_1_N = mkN "aortasjukdom" ; -- aortasjukdom..nn.1
  aortastenos_1_N = mkN "aortastenos" "aortastenoser" ; -- aortastenos..nn.1
  aortit_syndrom_1_N = mkN "aortit-syndrom" neutrum  ; -- aortit-syndrom..nn.1
  aortit_1_N = mkN "aortit" "aortiter" ; -- aortit..nn.1
  apa_1_A = mkA "apa" ; -- apa..av.1
  apa_1_N = mkN "apa" ; -- apa..nn.1
  apache_1_N = mkN "apache" "apacher" ; -- apache..nn.1
  apanage_1_N = mkN "apanage" "apanaget" "apanage" "apanagen" ; -- apanage..nn.1
  apanagebelopp_1_N = mkN "apanagebelopp" neutrum  ; -- apanagebelopp..nn.1
  apart_1_A = mkA "apart" "apart" ; -- apart..av.1
  apart_1_N = mkN "apart" "aparter" ; -- apart..nn.1
  apartheid_1_N = mkN "apartheid" ; -- apartheid..nn.1
  apartheidlag_1_N = mkN "apartheidlag" ; -- apartheidlag..nn.1
  apartheidregim_1_N = mkN "apartheidregim" "apartheidregimer" ; -- apartheidregim..nn.1
  apati_1_N = mkN "apati" "apatier" ; -- apati..nn.1
  apatisk_1_A = mkA "apatisk" ; -- apatisk..av.1
  apatit_1_N = mkN "apatit" ; -- apatit..nn.1
  apbrödsträd_1_N = mkN "apbrödsträd" neutrum  ; -- apbrödsträd..nn.1
  apc_resistens_1_N = mkN "apc-resistens" ; -- apc-resistens..nn.1
  apekatt_1_N = mkN "apekatt" "apekatter" ; -- apekatt..nn.1
  apel_1_N = mkN "apel" ; -- apel..nn.1
  apelgrå_1_A = mkA "apelgrå" "apelgrått" ; -- apelgrå..av.1
  apelkastad_1_A = mkA "apelkastad" ; -- apelkastad..av.1
  apelsin_1_N = mkN "apelsin" "apelsiner" ; -- apelsin..nn.1
  apelsingelé_1_N = mkN "apelsingelé" "apelsingeléer" ; -- apelsingelé..nn.1
  apelsinglass_1_N = mkN "apelsinglass" ; -- apelsinglass..nn.1
  apelsinjuice_1_N = mkN "apelsinjuice" "apelsinjuicer" ; -- apelsinjuice..nn.1
  apelsinklyfta_1_N = mkN "apelsinklyfta" ; -- apelsinklyfta..nn.1
  apelsinmarmelad_1_N = mkN "apelsinmarmelad" "apelsinmarmelader" ; -- apelsinmarmelad..nn.1
  apelsinmousse_1_N = mkN "apelsinmousse" "apelsinmousser" ; -- apelsinmousse..nn.1
  apelsinmoussetårta_1_N = mkN "apelsinmoussetårta" ; -- apelsinmoussetårta..nn.1
  apelsinsaft_1_N = mkN "apelsinsaft" "apelsinsafter" ; -- apelsinsaft..nn.1
  apelsinskal_1_N = mkN "apelsinskal" neutrum  ; -- apelsinskal..nn.1
  apelsinträd_1_N = mkN "apelsinträd" neutrum  ; -- apelsinträd..nn.1
  aperi_1_N = mkN "aperi" "aperiet" "aperier" "aperierna" ; -- aperi..nn.1
  aperitif_1_N = mkN "aperitif" "aperitifer" ; -- aperitif..nn.1
  apermi_1_N = mkN "apermi" ; -- apermi..nn.1
  apertur_1_N = mkN "apertur" "aperturer" ; -- apertur..nn.1
  apetidin_1_N = mkN "apetidin" "apetidiner" ; -- apetidin..nn.1
  apex_1_N = mkN "apex" neutrum  ; -- apex..nn.1
  aphelium_1_N = mkN "aphelium" "apheliet" "aphelier" "aphelierna" ; -- aphelium..nn.1
  aphjärna_1_N = mkN "aphjärna" ; -- aphjärna..nn.1
  aphona_1_N = mkN "aphona" ; -- aphona..nn.1
  apkoppa_1_N = mkN "apkoppa" ; -- apkoppa..nn.1
  aplik_1_A = mkA "aplik" ; -- aplik..av.1
  aplik_1_N = mkN "aplik" neutrum  ; -- aplik..nn.1
  apliknande_1_A = mkA "apliknande" ; -- apliknande..av.1
  aplomb_1_N = mkN "aplomb" ; -- aplomb..nn.1
  apmänniska_1_N = mkN "apmänniska" ; -- apmänniska..nn.1
  apne_1_N = mkN "apne" "apneer" ; -- apne..nn.1
  apné_1_N = mkN "apné" "apnéer" ; -- apné..nn.1
  apodiktisk_1_A = mkA "apodiktisk" ; -- apodiktisk..av.1
  apogeum_1_N = mkN "apogeum" neutrum  ; -- apogeum..nn.1
  apokalyps_1_N = mkN "apokalyps" "apokalypser" ; -- apokalyps..nn.1
  apokalyptisk_1_A = mkA "apokalyptisk" ; -- apokalyptisk..av.1
  apokope_1_N = mkN "apokope" utrum  ; -- apokope..nn.1
  apokrin_1_A = mkA "apokrin" ; -- apokrin..av.1
  apokryfisk_1_A = mkA "apokryfisk" ; -- apokryfisk..av.1
  apolitisk_1_A = mkA "apolitisk" ; -- apolitisk..av.1
  apollinisk_1_A = mkA "apollinisk" ; -- apollinisk..av.1
  apollinsk_1_A = mkA "apollinsk" ; -- apollinsk..av.1
  apollofjäril_1_N = mkN "apollofjäril" ; -- apollofjäril..nn.1
  apologet_1_N = mkN "apologet" "apologeter" ; -- apologet..nn.1
  apologetik_1_N = mkN "apologetik" ; -- apologetik..nn.1
  apologetisk_1_A = mkA "apologetisk" ; -- apologetisk..av.1
  apologi_1_N = mkN "apologi" "apologier" ; -- apologi..nn.1
  apologist_1_N = mkN "apologist" "apologister" ; -- apologist..nn.1
  apomorfi_1_N = mkN "apomorfi" "apomorfier" ; -- apomorfi..nn.1
  apoplektisk_1_A = mkA "apoplektisk" ; -- apoplektisk..av.1
  apoplexi_1_N = mkN "apoplexi" "apoplexier" ; -- apoplexi..nn.1
  apostel_1_N = mkN "apostel" ; -- apostel..nn.1
  aposteriorisk_1_A = mkA "aposteriorisk" ; -- aposteriorisk..av.1
  apostolisk_1_A = mkA "apostolisk" ; -- apostolisk..av.1
  apostrof_1_N = mkN "apostrof" "apostrofer" ; -- apostrof..nn.1
  apostrofera_1_V = mkV "apostroferar" ; -- apostrofera..vb.1
  apostroferande_1_N = mkN "apostroferande" ; -- apostroferande..nn.1
  apostroferbar_1_A = mkA "apostroferbar" ; -- apostroferbar..av.1
  apostroferbarhet_1_N = mkN "apostroferbarhet" ; -- apostroferbarhet..nn.1
  apostrofering_1_N = mkN "apostrofering" ; -- apostrofering..nn.1
  apotek_1_N = mkN "apotek" neutrum  ; -- apotek..nn.1
  apotekare_1_N = mkN "apotekare" utrum  ; -- apotekare..nn.1
  apotekskedja_1_N = mkN "apotekskedja" ; -- apotekskedja..nn.1
  apotekskö_1_N = mkN "apotekskö" "apotekskön" "apoteksköer" "apoteksköerna" ; -- apotekskö..nn.1
  apoteksväxt_1_N = mkN "apoteksväxt" "apoteksväxter" ; -- apoteksväxt..nn.1
  apoteksvåg_1_N = mkN "apoteksvåg" ; -- apoteksvåg..nn.1
  apoteos_1_N = mkN "apoteos" "apoteoser" ; -- apoteos..nn.1
  apothesium_1_N = mkN "apothesium" "apothesiet" "apothesier" "apothesierna" ; -- apothesium..nn.1
  app_1_N = mkN "app" ; -- app..nn.1
  appa_1_V = mkV "appar" ; -- appa..vb.1
  apparans_1_N = mkN "apparans" "apparanser" ; -- apparans..nn.1
  apparat_1_N = mkN "apparat" "apparater" ; -- apparat..nn.1
  apparatrum_1_N = mkN "apparatrum" "apparatrummet" "apparatrum" "apparatrummen" ; -- apparatrum..nn.1
  apparatur_1_N = mkN "apparatur" "apparaturer" ; -- apparatur..nn.1
  apparition_1_N = mkN "apparition" ; -- apparition..nn.1
  appell_1_N = mkN "appell" "appeller" ; -- appell..nn.1
  appellant_1_N = mkN "appellant" "appellanter" ; -- appellant..nn.1
  appellationsdomstol_1_N = mkN "appellationsdomstol" ; -- appellationsdomstol..nn.1
  appellativ_1_N = mkN "appellativ" neutrum  ; -- appellativ..nn.1
  appellera_1_V = mkV "appellerar" ; -- appellera..vb.1
  appellerande_1_N = mkN "appellerande" ; -- appellerande..nn.1
  appellerbar_1_A = mkA "appellerbar" ; -- appellerbar..av.1
  appellerbarhet_1_N = mkN "appellerbarhet" ; -- appellerbarhet..nn.1
  appellering_1_N = mkN "appellering" ; -- appellering..nn.1
  appendicit_1_N = mkN "appendicit" "appendiciter" ; -- appendicit..nn.1
  appendix_1_N = mkN "appendix" neutrum  ; -- appendix..nn.1
  appendixcancer_1_N = mkN "appendixcancer" ; -- appendixcancer..nn.1
  appendixtumör_1_N = mkN "appendixtumör" "appendixtumörer" ; -- appendixtumör..nn.1
  apperception_1_N = mkN "apperception" ; -- apperception..nn.1
  applicera_1_V = mkV "applicerar" ; -- applicera..vb.1
  applicerande_1_N = mkN "applicerande" ; -- applicerande..nn.1
  applicerbar_1_A = mkA "applicerbar" ; -- applicerbar..av.1
  applicerbarhet_1_N = mkN "applicerbarhet" ; -- applicerbarhet..nn.1
  applicering_1_N = mkN "applicering" ; -- applicering..nn.1
  applikation_1_N = mkN "applikation" ; -- applikation..nn.1
  applikator_1_N = mkN "applikator" "applikatorer" ; -- applikator..nn.1
  applikatorisk_1_A = mkA "applikatorisk" ; -- applikatorisk..av.1
  applikatur_1_N = mkN "applikatur" "applikaturer" ; -- applikatur..nn.1
  applåd_1_N = mkN "applåd" "applåder" ; -- applåd..nn.1
  applådera_1_V = mkV "applåderar" ; -- applådera..vb.1
  applåderande_1_N = mkN "applåderande" ; -- applåderande..nn.1
  applåderbar_1_A = mkA "applåderbar" ; -- applåderbar..av.1
  applåderbarhet_1_N = mkN "applåderbarhet" ; -- applåderbarhet..nn.1
  applådering_1_N = mkN "applådering" ; -- applådering..nn.1
  applådsalva_1_N = mkN "applådsalva" ; -- applådsalva..nn.1
  applådåska_1_N = mkN "applådåska" ; -- applådåska..nn.1
  apport_1_N = mkN "apport" "apporter" ; -- apport..nn.1
  apportera_1_V = mkV "apporterar" ; -- apportera..vb.1
  apporterande_1_N = mkN "apporterande" ; -- apporterande..nn.1
  apporterbar_1_A = mkA "apporterbar" ; -- apporterbar..av.1
  apporterbarhet_1_N = mkN "apporterbarhet" ; -- apporterbarhet..nn.1
  apportering_1_N = mkN "apportering" ; -- apportering..nn.1
  apposition_1_N = mkN "apposition" ; -- apposition..nn.1
  appreciera_1_V = mkV "apprecierar" ; -- appreciera..vb.1
  apprecierande_1_N = mkN "apprecierande" ; -- apprecierande..nn.1
  apprecierbar_1_A = mkA "apprecierbar" ; -- apprecierbar..av.1
  apprecierbarhet_1_N = mkN "apprecierbarhet" ; -- apprecierbarhet..nn.1
  appreciering_1_N = mkN "appreciering" ; -- appreciering..nn.1
  appretera_1_V = mkV "appreterar" ; -- appretera..vb.1
  appreterande_1_N = mkN "appreterande" ; -- appreterande..nn.1
  appreterbar_1_A = mkA "appreterbar" ; -- appreterbar..av.1
  appreterbarhet_1_N = mkN "appreterbarhet" ; -- appreterbarhet..nn.1
  appretering_1_N = mkN "appretering" ; -- appretering..nn.1
  appretur_1_N = mkN "appretur" "appreturer" ; -- appretur..nn.1
  appretyr_1_N = mkN "appretyr" "appretyrer" ; -- appretyr..nn.1
  approach_1_N = mkN "approach" "approacher" ; -- approach..nn.1
  approbabel_1_A = mkA "approbabel" ; -- approbabel..av.1
  approbatur_1_N = mkN "approbatur" neutrum  ; -- approbatur..nn.1
  approchera_1_V = mkV "approcherar" ; -- approchera..vb.1
  approcherande_1_N = mkN "approcherande" ; -- approcherande..nn.1
  approcherbar_1_A = mkA "approcherbar" ; -- approcherbar..av.1
  approcherbarhet_1_N = mkN "approcherbarhet" ; -- approcherbarhet..nn.1
  approchering_1_N = mkN "approchering" ; -- approchering..nn.1
  approximation_1_N = mkN "approximation" ; -- approximation..nn.1
  approximationsteori_1_N = mkN "approximationsteori" "approximationsteorier" ; -- approximationsteori..nn.1
  approximationsvis_1_Adv = mkAdv "approximationsvis" ; -- approximationsvis..ab.1
  approximativ_1_A = mkA "approximativ" ; -- approximativ..av.1
  approximera_1_V = mkV "approximerar" ; -- approximera..vb.1
  approximerande_1_N = mkN "approximerande" ; -- approximerande..nn.1
  approximerbar_1_A = mkA "approximerbar" ; -- approximerbar..av.1
  approximerbarhet_1_N = mkN "approximerbarhet" ; -- approximerbarhet..nn.1
  approximering_1_N = mkN "approximering" ; -- approximering..nn.1
  aprak_1_A = mkA "aprak" ; -- aprak..av.1
  apraxi_1_N = mkN "apraxi" "apraxier" ; -- apraxi..nn.1
  aprikos_1_N = mkN "aprikos" "aprikoser" ; -- aprikos..nn.1
  april_1_N = mkN "april" ; -- april..nn.1
  aprildag_1_N = mkN "aprildag" ; -- aprildag..nn.1
  aprilskämt_1_N = mkN "aprilskämt" neutrum  ; -- aprilskämt..nn.1
  aprilsnö_1_N = mkN "aprilsnö" ; -- aprilsnö..nn.1
  aprilväder_1_N = mkN "aprilväder" neutrum  ; -- aprilväder..nn.1
  apriorisk_1_A = mkA "apriorisk" ; -- apriorisk..av.1
  apropå_1_Adv = mkAdv "apropå" ; -- apropå..ab.1
  apropå_1_N = mkN "apropå" "apropåt" "apropåer" "apropåerna" ; -- apropå..nn.1
  apsjukdom_1_N = mkN "apsjukdom" ; -- apsjukdom..nn.1
  apsort_1_N = mkN "apsort" "apsorter" ; -- apsort..nn.1
  apspel_1_N = mkN "apspel" "apspelet" "apspel" "apspelen" ; -- apspel..nn.1
  aptera_1_V = mkV "apterar" ; -- aptera..vb.1
  apterande_1_N = mkN "apterande" ; -- apterande..nn.1
  apterbar_1_A = mkA "apterbar" ; -- apterbar..av.1
  apterbarhet_1_N = mkN "apterbarhet" ; -- apterbarhet..nn.1
  aptering_1_N = mkN "aptering" ; -- aptering..nn.1
  aptit_1_N = mkN "aptit" ; -- aptit..nn.1
  aptitlig_1_A = mkA "aptitlig" ; -- aptitlig..av.1
  aptitlighet_1_N = mkN "aptitlighet" "aptitligheter" ; -- aptitlighet..nn.1
  aptitlöshet_1_N = mkN "aptitlöshet" "aptitlösheter" ; -- aptitlöshet..nn.1
  aptitretande_1_A = mkA "aptitretande" ; -- aptitretande..av.1
  aptitretare_1_N = mkN "aptitretare" utrum  ; -- aptitretare..nn.1
  apudom_1_N = mkN "apudom" neutrum  ; -- apudom..nn.1
  ar_1_N = mkN "ar" neutrum  ; -- ar..nn.1
  ara_1_N = mkN "ara" ; -- ara..nn.1
  arab_1_N = mkN "arab" "araber" ; -- arab..nn.1
  arabesk_1_N = mkN "arabesk" "arabesker" ; -- arabesk..nn.1
  arabeskmönster_1_N = mkN "arabeskmönster" neutrum  ; -- arabeskmönster..nn.1
  arabisk_1_A = mkA "arabisk" ; -- arabisk..av.1
  arabiska_1_N = mkN "arabiska" ; -- arabiska..nn.1
  arabiska_2_N = mkN "arabiska" ; -- arabiska..nn.2
  arabiskspråkig_1_A = mkA "arabiskspråkig" ; -- arabiskspråkig..av.1
  arabisktalande_1_A = mkA "arabisktalande" ; -- arabisktalande..av.1
  arabist_1_N = mkN "arabist" "arabister" ; -- arabist..nn.1
  arabland_1_N = mkN "arabland" "arablandet" "arabländer" "arabländerna" ; -- arabland..nn.1
  arabvärld_1_N = mkN "arabvärld" ; -- arabvärld..nn.1
  araknidism_1_N = mkN "araknidism" ; -- araknidism..nn.1
  araknodaktyli_1_N = mkN "araknodaktyli" ; -- araknodaktyli..nn.1
  araknoidalcysta_1_N = mkN "araknoidalcysta" ; -- araknoidalcysta..nn.1
  araknoidit_1_N = mkN "araknoidit" "araknoiditer" ; -- araknoidit..nn.1
  aralia_1_N = mkN "aralia" ; -- aralia..nn.1
  arameiska_1_N = mkN "arameiska" ; -- arameiska..nn.1
  aramid_1_N = mkN "aramid" "aramider" ; -- aramid..nn.1
  arbeta_1_V = mkV "arbetar" ; -- arbeta..vb.1
  arbetande_1_N = mkN "arbetande" ; -- arbetande..nn.1
  arbetarbostad_1_N = mkN "arbetarbostad" "arbetarbostäder" ; -- arbetarbostad..nn.1
  arbetare_1_N = mkN "arbetare" utrum  ; -- arbetare..nn.1
  arbetareparti_1_N = mkN "arbetareparti" "arbetarepartiet" "arbetarepartier" "arbetarepartierna" ; -- arbetareparti..nn.1
  arbetarförening_1_N = mkN "arbetarförening" ; -- arbetarförening..nn.1
  arbetargrupp_1_N = mkN "arbetargrupp" "arbetargrupper" ; -- arbetargrupp..nn.1
  arbetarinstitut_1_N = mkN "arbetarinstitut" neutrum  ; -- arbetarinstitut..nn.1
  arbetarklass_1_N = mkN "arbetarklass" "arbetarklasser" ; -- arbetarklass..nn.1
  arbetarkommun_1_N = mkN "arbetarkommun" "arbetarkommuner" ; -- arbetarkommun..nn.1
  arbetarkvarter_1_N = mkN "arbetarkvarter" "arbetarkvarteret" "arbetarkvarter" "arbetarkvarteren" ; -- arbetarkvarter..nn.1
  arbetarparti_1_N = mkN "arbetarparti" "arbetarpartiet" "arbetarpartier" "arbetarpartierna" ; -- arbetarparti..nn.1
  arbetarregering_1_N = mkN "arbetarregering" ; -- arbetarregering..nn.1
  arbetarråd_1_N = mkN "arbetarråd" neutrum  ; -- arbetarråd..nn.1
  arbetarrörelse_1_N = mkN "arbetarrörelse" "arbetarrörelser" ; -- arbetarrörelse..nn.1
  arbetarskydd_1_N = mkN "arbetarskydd" neutrum  ; -- arbetarskydd..nn.1
  arbetarskyddsstyrelse_1_N = mkN "arbetarskyddsstyrelse" utrum  ; -- arbetarskyddsstyrelse..nn.1
  arbetarstam_1_N = mkN "arbetarstam" "arbetarstammen" "arbetarstammar" "arbetarstammarna" ; -- arbetarstam..nn.1
  arbetarsång_1_N = mkN "arbetarsång" "arbetarsånger" ; -- arbetarsång..nn.1
  arbetaruppror_1_N = mkN "arbetaruppror" neutrum  ; -- arbetaruppror..nn.1
  arbetarväljare_1_N = mkN "arbetarväljare" utrum  ; -- arbetarväljare..nn.1
  arbete_1_N = mkN "arbete" ; -- arbete..nn.1
  arbetsam_1_A = mkA "arbetsam" "arbetsamt" "arbetsamma" "arbetsamma" "arbetsammare" "arbetsammast" "arbetsammaste" ; -- arbetsam..av.1
  arbetsamhet_1_N = mkN "arbetsamhet" ; -- arbetsamhet..nn.1
  arbetsanstalt_1_N = mkN "arbetsanstalt" "arbetsanstalter" ; -- arbetsanstalt..nn.1
  arbetsavtal_1_N = mkN "arbetsavtal" neutrum  ; -- arbetsavtal..nn.1
  arbetsbas_1_N = mkN "arbetsbas" ; -- arbetsbas..nn.1
  arbetsbelastning_1_N = mkN "arbetsbelastning" ; -- arbetsbelastning..nn.1
  arbetsbelysning_1_N = mkN "arbetsbelysning" ; -- arbetsbelysning..nn.1
  arbetsbeskrivning_1_N = mkN "arbetsbeskrivning" ; -- arbetsbeskrivning..nn.1
  arbetsbesparande_1_A = mkA "arbetsbesparande" ; -- arbetsbesparande..av.1
  arbetsbesparing_1_N = mkN "arbetsbesparing" ; -- arbetsbesparing..nn.1
  arbetsbetyg_1_N = mkN "arbetsbetyg" neutrum  ; -- arbetsbetyg..nn.1
  arbetsbi_1_N = mkN "arbetsbi" "arbetsbiet" "arbetsbin" "arbetsbina" ; -- arbetsbi..nn.1
  arbetsblus_1_N = mkN "arbetsblus" ; -- arbetsblus..nn.1
  arbetsbok_1_N = mkN "arbetsbok" "arbetsböcker" ; -- arbetsbok..nn.1
  arbetsbord_1_N = mkN "arbetsbord" neutrum  ; -- arbetsbord..nn.1
  arbetsbredd_1_N = mkN "arbetsbredd" "arbetsbredder" ; -- arbetsbredd..nn.1
  arbetsbrist_1_N = mkN "arbetsbrist" ; -- arbetsbrist..nn.1
  arbetsbyte_1_N = mkN "arbetsbyte" ; -- arbetsbyte..nn.1
  arbetsbänk_1_N = mkN "arbetsbänk" ; -- arbetsbänk..nn.1
  arbetsbås_1_N = mkN "arbetsbås" neutrum  ; -- arbetsbås..nn.1
  arbetsbörda_1_N = mkN "arbetsbörda" ; -- arbetsbörda..nn.1
  arbetschef_1_N = mkN "arbetschef" "arbetschefer" ; -- arbetschef..nn.1
  arbetsdag_1_N = mkN "arbetsdag" ; -- arbetsdag..nn.1
  arbetsdelning_1_N = mkN "arbetsdelning" ; -- arbetsdelning..nn.1
  arbetsdjur_1_N = mkN "arbetsdjur" neutrum  ; -- arbetsdjur..nn.1
  arbetsdomstol_1_N = mkN "arbetsdomstol" ; -- arbetsdomstol..nn.1
  arbetsdräkt_1_N = mkN "arbetsdräkt" "arbetsdräkter" ; -- arbetsdräkt..nn.1
  arbetsdräng_1_N = mkN "arbetsdräng" ; -- arbetsdräng..nn.1
  arbetsduglig_1_A = mkA "arbetsduglig" ; -- arbetsduglig..av.1
  arbetsduglighet_1_N = mkN "arbetsduglighet" ; -- arbetsduglighet..nn.1
  arbetsfolk_1_N = mkN "arbetsfolk" neutrum  ; -- arbetsfolk..nn.1
  arbetsform_1_N = mkN "arbetsform" "arbetsformer" ; -- arbetsform..nn.1
  arbetsfred_1_N = mkN "arbetsfred" ; -- arbetsfred..nn.1
  arbetsfri_1_A = mkA "arbetsfri" "arbetsfritt" ; -- arbetsfri..av.1
  arbetsfält_1_N = mkN "arbetsfält" neutrum  ; -- arbetsfält..nn.1
  arbetsfånge_1_N = mkN "arbetsfånge" utrum  ; -- arbetsfånge..nn.1
  arbetsför_1_A = mkA "arbetsför" ; -- arbetsför..av.1
  arbetsfördelning_1_N = mkN "arbetsfördelning" ; -- arbetsfördelning..nn.1
  arbetsförhet_1_N = mkN "arbetsförhet" ; -- arbetsförhet..nn.1
  arbetsförhållande_1_N = mkN "arbetsförhållande" ; -- arbetsförhållande..nn.1
  arbetsförman_1_N = mkN "arbetsförman" "arbetsförmannen" "arbetsförmän" "arbetsförmännen" ; -- arbetsförman..nn.1
  arbetsförmedlare_1_N = mkN "arbetsförmedlare" utrum  ; -- arbetsförmedlare..nn.1
  arbetsförmedling_1_N = mkN "arbetsförmedling" ; -- arbetsförmedling..nn.1
  arbetsförmåga_1_N = mkN "arbetsförmåga" ; -- arbetsförmåga..nn.1
  arbetsförmågeutredning_1_N = mkN "arbetsförmågeutredning" ; -- arbetsförmågeutredning..nn.1
  arbetsförtjänst_1_N = mkN "arbetsförtjänst" "arbetsförtjänster" ; -- arbetsförtjänst..nn.1
  arbetsgivaravgift_1_N = mkN "arbetsgivaravgift" "arbetsgivaravgifter" ; -- arbetsgivaravgift..nn.1
  arbetsgivare_1_N = mkN "arbetsgivare" utrum  ; -- arbetsgivare..nn.1
  arbetsgivareförening_1_N = mkN "arbetsgivareförening" ; -- arbetsgivareförening..nn.1
  arbetsgivarförening_1_N = mkN "arbetsgivarförening" ; -- arbetsgivarförening..nn.1
  arbetsgivarinträde_1_N = mkN "arbetsgivarinträde" ; -- arbetsgivarinträde..nn.1
  arbetsgivarorganisation_1_N = mkN "arbetsgivarorganisation" ; -- arbetsgivarorganisation..nn.1
  arbetsglädje_1_N = mkN "arbetsglädje" utrum  ; -- arbetsglädje..nn.1
  arbetsgrupp_1_N = mkN "arbetsgrupp" "arbetsgrupper" ; -- arbetsgrupp..nn.1
  arbetshandikapp_1_N = mkN "arbetshandikapp" neutrum  ; -- arbetshandikapp..nn.1
  arbetshandikappad_1_A = mkA "arbetshandikappad" ; -- arbetshandikappad..av.1
  arbetshandske_1_N = mkN "arbetshandske" utrum  ; -- arbetshandske..nn.1
  arbetshus_1_N = mkN "arbetshus" neutrum  ; -- arbetshus..nn.1
  arbetshypotes_1_N = mkN "arbetshypotes" "arbetshypoteser" ; -- arbetshypotes..nn.1
  arbetshäst_1_N = mkN "arbetshäst" ; -- arbetshäst..nn.1
  arbetsinkomst_1_N = mkN "arbetsinkomst" "arbetsinkomster" ; -- arbetsinkomst..nn.1
  arbetsinrättning_1_N = mkN "arbetsinrättning" ; -- arbetsinrättning..nn.1
  arbetsinsats_1_N = mkN "arbetsinsats" "arbetsinsatser" ; -- arbetsinsats..nn.1
  arbetsinställelse_1_N = mkN "arbetsinställelse" "arbetsinställelser" ; -- arbetsinställelse..nn.1
  arbetsintensitet_1_N = mkN "arbetsintensitet" ; -- arbetsintensitet..nn.1
  arbetsintensiv_1_A = mkA "arbetsintensiv" ; -- arbetsintensiv..av.1
  arbetsintervju_1_N = mkN "arbetsintervju" "arbetsintervjun" "arbetsintervjuer" "arbetsintervjuerna" ; -- arbetsintervju..nn.1
  arbetsiver_1_N = mkN "arbetsiver" ; -- arbetsiver..nn.1
  arbetsjacka_1_N = mkN "arbetsjacka" ; -- arbetsjacka..nn.1
  arbetskamrat_1_N = mkN "arbetskamrat" "arbetskamrater" ; -- arbetskamrat..nn.1
  arbetskarl_1_N = mkN "arbetskarl" ; -- arbetskarl..nn.1
  arbetsklimat_1_N = mkN "arbetsklimat" neutrum  ; -- arbetsklimat..nn.1
  arbetskommendering_1_N = mkN "arbetskommendering" ; -- arbetskommendering..nn.1
  arbetskonflikt_1_N = mkN "arbetskonflikt" "arbetskonflikter" ; -- arbetskonflikt..nn.1
  arbetskostnad_1_N = mkN "arbetskostnad" "arbetskostnader" ; -- arbetskostnad..nn.1
  arbetskraft_1_N = mkN "arbetskraft" ; -- arbetskraft..nn.1
  arbetskraftsintensiv_1_A = mkA "arbetskraftsintensiv" ; -- arbetskraftsintensiv..av.1
  arbetskraftsinvandrare_1_N = mkN "arbetskraftsinvandrare" utrum  ; -- arbetskraftsinvandrare..nn.1
  arbetskraftsinvandring_1_N = mkN "arbetskraftsinvandring" ; -- arbetskraftsinvandring..nn.1
  arbetskrävande_1_A = mkA "arbetskrävande" ; -- arbetskrävande..av.1
  arbetsköpare_1_N = mkN "arbetsköpare" utrum  ; -- arbetsköpare..nn.1
  arbetslag_1_N = mkN "arbetslag" neutrum  ; -- arbetslag..nn.1
  arbetsledande_1_A = mkA "arbetsledande" ; -- arbetsledande..av.1
  arbetsledare_1_N = mkN "arbetsledare" utrum  ; -- arbetsledare..nn.1
  arbetsliv_1_N = mkN "arbetsliv" neutrum  ; -- arbetsliv..nn.1
  arbetslivserfarenhet_1_N = mkN "arbetslivserfarenhet" "arbetslivserfarenheter" ; -- arbetslivserfarenhet..nn.1
  arbetslivsfond_1_N = mkN "arbetslivsfond" "arbetslivsfonder" ; -- arbetslivsfond..nn.1
  arbetslokal_1_N = mkN "arbetslokal" "arbetslokaler" ; -- arbetslokal..nn.1
  arbetslust_1_N = mkN "arbetslust" ; -- arbetslust..nn.1
  arbetsläger_1_N = mkN "arbetsläger" neutrum  ; -- arbetsläger..nn.1
  arbetslängd_1_N = mkN "arbetslängd" "arbetslängder" ; -- arbetslängd..nn.1
  arbetslön_1_N = mkN "arbetslön" "arbetslöner" ; -- arbetslön..nn.1
  arbetslös_1_A = mkA "arbetslös" ; -- arbetslös..av.1
  arbetslöshet_1_N = mkN "arbetslöshet" "arbetslösheter" ; -- arbetslöshet..nn.1
  arbetslöshetsförsäkring_1_N = mkN "arbetslöshetsförsäkring" ; -- arbetslöshetsförsäkring..nn.1
  arbetslöshetsperiod_1_N = mkN "arbetslöshetsperiod" "arbetslöshetsperioder" ; -- arbetslöshetsperiod..nn.1
  arbetslöshetsstatistik_1_N = mkN "arbetslöshetsstatistik" ; -- arbetslöshetsstatistik..nn.1
  arbetsmanskap_1_N = mkN "arbetsmanskap" neutrum  ; -- arbetsmanskap..nn.1
  arbetsmarknad_1_N = mkN "arbetsmarknad" "arbetsmarknader" ; -- arbetsmarknad..nn.1
  arbetsmarknadskonflikt_1_N = mkN "arbetsmarknadskonflikt" "arbetsmarknadskonflikter" ; -- arbetsmarknadskonflikt..nn.1
  arbetsmarknadsminister_1_N = mkN "arbetsmarknadsminister" ; -- arbetsmarknadsminister..nn.1
  arbetsmarknadsmässig_1_A = mkA "arbetsmarknadsmässig" ; -- arbetsmarknadsmässig..av.1
  arbetsmarknadspolitik_1_N = mkN "arbetsmarknadspolitik" ; -- arbetsmarknadspolitik..nn.1
  arbetsmarknadspolitisk_1_A = mkA "arbetsmarknadspolitisk" ; -- arbetsmarknadspolitisk..av.1
  arbetsmarknadsstatistik_1_N = mkN "arbetsmarknadsstatistik" ; -- arbetsmarknadsstatistik..nn.1
  arbetsmarknadsstyrelse_1_N = mkN "arbetsmarknadsstyrelse" utrum  ; -- arbetsmarknadsstyrelse..nn.1
  arbetsmarknadsutbildning_1_N = mkN "arbetsmarknadsutbildning" ; -- arbetsmarknadsutbildning..nn.1
  arbetsmarknadsåtgärd_1_N = mkN "arbetsmarknadsåtgärd" "arbetsmarknadsåtgärder" ; -- arbetsmarknadsåtgärd..nn.1
  arbetsmaskin_1_N = mkN "arbetsmaskin" "arbetsmaskiner" ; -- arbetsmaskin..nn.1
  arbetsmaterial_1_N = mkN "arbetsmaterial" neutrum  ; -- arbetsmaterial..nn.1
  arbetsmetod_1_N = mkN "arbetsmetod" "arbetsmetoder" ; -- arbetsmetod..nn.1
  arbetsmiljö_1_N = mkN "arbetsmiljö" "arbetsmiljön" "arbetsmiljöer" "arbetsmiljöerna" ; -- arbetsmiljö..nn.1
  arbetsmiljöbrott_1_N = mkN "arbetsmiljöbrott" neutrum  ; -- arbetsmiljöbrott..nn.1
  arbetsmiljömässig_1_A = mkA "arbetsmiljömässig" ; -- arbetsmiljömässig..av.1
  arbetsmiljömål_1_N = mkN "arbetsmiljömål" neutrum  ; -- arbetsmiljömål..nn.1
  arbetsminne_1_N = mkN "arbetsminne" ; -- arbetsminne..nn.1
  arbetsminnestest_1_N = mkN "arbetsminnestest" neutrum  ; -- arbetsminnestest..nn.1
  arbetsmoment_1_N = mkN "arbetsmoment" neutrum  ; -- arbetsmoment..nn.1
  arbetsmoral_1_N = mkN "arbetsmoral" "arbetsmoraler" ; -- arbetsmoral..nn.1
  arbetsmyra_1_N = mkN "arbetsmyra" ; -- arbetsmyra..nn.1
  arbetsmängd_1_N = mkN "arbetsmängd" "arbetsmängder" ; -- arbetsmängd..nn.1
  arbetsmänniska_1_N = mkN "arbetsmänniska" ; -- arbetsmänniska..nn.1
  arbetsmässig_1_A = mkA "arbetsmässig" ; -- arbetsmässig..av.1
  arbetsmätning_1_N = mkN "arbetsmätning" ; -- arbetsmätning..nn.1
  arbetsnamn_1_N = mkN "arbetsnamn" neutrum  ; -- arbetsnamn..nn.1
  arbetsnarkoman_1_N = mkN "arbetsnarkoman" "arbetsnarkomaner" ; -- arbetsnarkoman..nn.1
  arbetsnedläggelse_1_N = mkN "arbetsnedläggelse" "arbetsnedläggelser" ; -- arbetsnedläggelse..nn.1
  arbetsnämnd_1_N = mkN "arbetsnämnd" "arbetsnämnder" ; -- arbetsnämnd..nn.1
  arbetsoförmögen_1_A = mkA "arbetsoförmögen" ; -- arbetsoförmögen..av.1
  arbetsområde_1_N = mkN "arbetsområde" ; -- arbetsområde..nn.1
  arbetsordning_1_N = mkN "arbetsordning" ; -- arbetsordning..nn.1
  arbetsorganisation_1_N = mkN "arbetsorganisation" ; -- arbetsorganisation..nn.1
  arbetspass_1_N = mkN "arbetspass" neutrum  ; -- arbetspass..nn.1
  arbetspendla_1_V = mkV "arbetspendlar" ; -- arbetspendla..vb.1
  arbetspendlande_1_N = mkN "arbetspendlande" ; -- arbetspendlande..nn.1
  arbetspersonal_1_N = mkN "arbetspersonal" "arbetspersonaler" ; -- arbetspersonal..nn.1
  arbetsplan_1_N = mkN "arbetsplan" "arbetsplaner" ; -- arbetsplan..nn.1
  arbetsplats_1_N = mkN "arbetsplats" "arbetsplatser" ; -- arbetsplats..nn.1
  arbetsplatsolycka_1_N = mkN "arbetsplatsolycka" ; -- arbetsplatsolycka..nn.1
  arbetsplenum_1_N = mkN "arbetsplenum" neutrum  ; -- arbetsplenum..nn.1
  arbetspremiss_1_N = mkN "arbetspremiss" "arbetspremisser" ; -- arbetspremiss..nn.1
  arbetsprogram_1_N = mkN "arbetsprogram" "arbetsprogrammet" "arbetsprogram" "arbetsprogrammen" ; -- arbetsprogram..nn.1
  arbetsprov_1_N = mkN "arbetsprov" neutrum  ; -- arbetsprov..nn.1
  arbetsredskap_1_N = mkN "arbetsredskap" neutrum  ; -- arbetsredskap..nn.1
  arbetsrelaterad_1_A = mkA "arbetsrelaterad" ; -- arbetsrelaterad..av.1
  arbetsrelation_1_N = mkN "arbetsrelation" ; -- arbetsrelation..nn.1
  arbetsro_1_N = mkN "arbetsro" ; -- arbetsro..nn.1
  arbetsrum_1_N = mkN "arbetsrum" "arbetsrummet" "arbetsrum" "arbetsrummen" ; -- arbetsrum..nn.1
  arbetsrätt_1_N = mkN "arbetsrätt" ; -- arbetsrätt..nn.1
  arbetsrättslig_1_A = mkA "arbetsrättslig" ; -- arbetsrättslig..av.1
  arbetssal_1_N = mkN "arbetssal" ; -- arbetssal..nn.1
  arbetsschema_1_N = mkN "arbetsschema" "arbetsschemat" "arbetsscheman" "arbetsschemana" ; -- arbetsschema..nn.1
  arbetsseger_1_N = mkN "arbetsseger" ; -- arbetsseger..nn.1
  arbetssituation_1_N = mkN "arbetssituation" ; -- arbetssituation..nn.1
  arbetsskada_1_N = mkN "arbetsskada" ; -- arbetsskada..nn.1
  arbetsskadad_1_A = mkA "arbetsskadad" ; -- arbetsskadad..av.1
  arbetsskicklig_1_A = mkA "arbetsskicklig" ; -- arbetsskicklig..av.1
  arbetsskicklighet_1_N = mkN "arbetsskicklighet" ; -- arbetsskicklighet..nn.1
  arbetsskräck_1_N = mkN "arbetsskräck" ; -- arbetsskräck..nn.1
  arbetsskygg_1_A = mkA "arbetsskygg" ; -- arbetsskygg..av.1
  arbetsskygghet_1_N = mkN "arbetsskygghet" ; -- arbetsskygghet..nn.1
  arbetsstudieman_1_N = mkN "arbetsstudieman" "arbetsstudiemannen" "arbetsstudiemän" "arbetsstudiemännen" ; -- arbetsstudieman..nn.1
  arbetsstycke_1_N = mkN "arbetsstycke" ; -- arbetsstycke..nn.1
  arbetsstyrka_1_N = mkN "arbetsstyrka" ; -- arbetsstyrka..nn.1
  arbetssätt_1_N = mkN "arbetssätt" neutrum  ; -- arbetssätt..nn.1
  arbetssång_1_N = mkN "arbetssång" "arbetssånger" ; -- arbetssång..nn.1
  arbetssökande_1_A = mkA "arbetssökande" ; -- arbetssökande..av.1
  arbetssökande_1_N = mkN "arbetssökande" "arbetssökanden" "arbetssökanden" "arbetssökandena" ; -- arbetssökande..nn.1
  arbetssökande_2_N = mkN "arbetssökande" ; -- arbetssökande..nn.2
  arbetstagare_1_N = mkN "arbetstagare" utrum  ; -- arbetstagare..nn.1
  arbetstakt_1_N = mkN "arbetstakt" ; -- arbetstakt..nn.1
  arbetstemperatur_1_N = mkN "arbetstemperatur" "arbetstemperaturer" ; -- arbetstemperatur..nn.1
  arbetsterapeut_1_N = mkN "arbetsterapeut" "arbetsterapeuter" ; -- arbetsterapeut..nn.1
  arbetsterapi_1_N = mkN "arbetsterapi" ; -- arbetsterapi..nn.1
  arbetstid_1_N = mkN "arbetstid" "arbetstider" ; -- arbetstid..nn.1
  arbetstidsförkortning_1_N = mkN "arbetstidsförkortning" ; -- arbetstidsförkortning..nn.1
  arbetstidsregel_1_N = mkN "arbetstidsregel" "arbetstidsregeln" "arbetstidsregler" "arbetstidsreglerna" ; -- arbetstidsregel..nn.1
  arbetstidsreglering_1_N = mkN "arbetstidsreglering" ; -- arbetstidsreglering..nn.1
  arbetstillfälle_1_N = mkN "arbetstillfälle" ; -- arbetstillfälle..nn.1
  arbetstillstånd_1_N = mkN "arbetstillstånd" neutrum  ; -- arbetstillstånd..nn.1
  arbetstimme_1_N = mkN "arbetstimme" utrum  ; -- arbetstimme..nn.1
  arbetsträna_1_V = mkV "arbetstränar" ; -- arbetsträna..vb.1
  arbetstränande_1_N = mkN "arbetstränande" ; -- arbetstränande..nn.1
  arbetsträning_1_N = mkN "arbetsträning" ; -- arbetsträning..nn.1
  arbetstvist_1_N = mkN "arbetstvist" "arbetstvister" ; -- arbetstvist..nn.1
  arbetsuppgift_1_N = mkN "arbetsuppgift" "arbetsuppgifter" ; -- arbetsuppgift..nn.1
  arbetsutskott_1_N = mkN "arbetsutskott" neutrum  ; -- arbetsutskott..nn.1
  arbetsvan_1_A = mkA "arbetsvan" ; -- arbetsvan..av.1
  arbetsvana_1_N = mkN "arbetsvana" ; -- arbetsvana..nn.1
  arbetsvecka_1_N = mkN "arbetsvecka" ; -- arbetsvecka..nn.1
  arbetsverktyg_1_N = mkN "arbetsverktyg" neutrum  ; -- arbetsverktyg..nn.1
  arbetsvilja_1_N = mkN "arbetsvilja" ; -- arbetsvilja..nn.1
  arbetsvillig_1_A = mkA "arbetsvillig" ; -- arbetsvillig..av.1
  arbetsvillighet_1_N = mkN "arbetsvillighet" ; -- arbetsvillighet..nn.1
  arbetsvillkor_1_N = mkN "arbetsvillkor" neutrum  ; -- arbetsvillkor..nn.1
  arbetsvärdering_1_N = mkN "arbetsvärdering" ; -- arbetsvärdering..nn.1
  arbetsväska_1_N = mkN "arbetsväska" ; -- arbetsväska..nn.1
  arbetsvård_1_N = mkN "arbetsvård" ; -- arbetsvård..nn.1
  arbetsår_1_N = mkN "arbetsår" neutrum  ; -- arbetsår..nn.1
  arbitrage_1_N = mkN "arbitrage" ; -- arbitrage..nn.1
  arbiträr_1_A = mkA "arbiträr" ; -- arbiträr..av.1
  arboretum_1_N = mkN "arboretum" neutrum  ; -- arboretum..nn.1
  arborist_1_N = mkN "arborist" "arborister" ; -- arborist..nn.1
  arborr_1_N = mkN "arborr" ; -- arborr..nn.1
  arborra_1_V = mkV "arborrar" ; -- arborra..vb.1
  arborrande_1_N = mkN "arborrande" ; -- arborrande..nn.1
  arbovirusencefalit_1_N = mkN "arbovirusencefalit" "arbovirusencefaliter" ; -- arbovirusencefalit..nn.1
  arbovirusinfektion_1_N = mkN "arbovirusinfektion" ; -- arbovirusinfektion..nn.1
  arcusmoln_1_N = mkN "arcusmoln" neutrum  ; -- arcusmoln..nn.1
  ardenner_1_N = mkN "ardenner" "ardennern" "ardenner" "ardennerna" ; -- ardenner..nn.1
  area_1_N = mkN "area" ; -- area..nn.1
  areal_1_N = mkN "areal" "arealer" ; -- areal..nn.1
  arealmässig_1_A = mkA "arealmässig" ; -- arealmässig..av.1
  arena_1_N = mkN "arena" ; -- arena..nn.1
  arenabygge_1_N = mkN "arenabygge" ; -- arenabygge..nn.1
  arenateater_1_N = mkN "arenateater" ; -- arenateater..nn.1
  arenavirusinfektion_1_N = mkN "arenavirusinfektion" ; -- arenavirusinfektion..nn.1
  areometer_1_N = mkN "areometer" ; -- areometer..nn.1
  areopag_1_N = mkN "areopag" "areopager" ; -- areopag..nn.1
  arg_1_A = mkA "arg" ; -- arg..av.1
  argbigga_1_N = mkN "argbigga" ; -- argbigga..nn.1
  argentinare_1_N = mkN "argentinare" utrum  ; -- argentinare..nn.1
  argentinsk_1_A = mkA "argentinsk" ; -- argentinsk..av.1
  argentinska_1_N = mkN "argentinska" ; -- argentinska..nn.1
  arghet_1_N = mkN "arghet" ; -- arghet..nn.1
  argininbärnstensaciduri_1_N = mkN "argininbärnstensaciduri" ; -- argininbärnstensaciduri..nn.1
  argon_1_N = mkN "argon" ; -- argon..nn.1
  argot_1_N = mkN "argot" ; -- argot..nn.1
  argsint_1_A = mkA "argsint" "argsint" ; -- argsint..av.1
  argsinthet_1_N = mkN "argsinthet" ; -- argsinthet..nn.1
  argument_1_N = mkN "argument" neutrum  ; -- argument..nn.1
  argumentation_1_N = mkN "argumentation" ; -- argumentation..nn.1
  argumentationsanalys_1_N = mkN "argumentationsanalys" ; -- argumentationsanalys..nn.1
  argumentativ_1_A = mkA "argumentativ" ; -- argumentativ..av.1
  argumentera_1_V = mkV "argumenterar" ; -- argumentera..vb.1
  argumenterande_1_N = mkN "argumenterande" ; -- argumenterande..nn.1
  argumenterbar_1_A = mkA "argumenterbar" ; -- argumenterbar..av.1
  argumenterbarhet_1_N = mkN "argumenterbarhet" ; -- argumenterbarhet..nn.1
  argumentering_1_N = mkN "argumentering" ; -- argumentering..nn.1
  argumentrik_1_A = mkA "argumentrik" ; -- argumentrik..av.1
  argumentrikedom_1_N = mkN "argumentrikedom" ; -- argumentrikedom..nn.1
  argusöga_1_N = mkN "argusöga" "argusögat" "argusögon" "argusögonen" ; -- argusöga..nn.1
  argyri_1_N = mkN "argyri" ; -- argyri..nn.1
  arhinencefali_1_N = mkN "arhinencefali" ; -- arhinencefali..nn.1
  aria_1_N = mkN "aria" ; -- aria..nn.1
  ariadnetråd_1_N = mkN "ariadnetråd" ; -- ariadnetråd..nn.1
  arian_1_N = mkN "arian" "arianer" ; -- arian..nn.1
  arianism_1_N = mkN "arianism" "arianismer" ; -- arianism..nn.1
  ariansk_1_A = mkA "ariansk" ; -- ariansk..av.1
  arid_1_A = mkA "arid" ; -- arid..av.1
  arier_1_N = mkN "arier" "ariern" "arier" "arierna" ; -- arier..nn.1
  arioso_1_N = mkN "arioso" "ariosot" "arioson" "ariosona" ; -- arioso..nn.1
  arisk_1_A = mkA "arisk" ; -- arisk..av.1
  aristokrat_1_N = mkN "aristokrat" "aristokrater" ; -- aristokrat..nn.1
  aristokrati_1_N = mkN "aristokrati" "aristokratier" ; -- aristokrati..nn.1
  aristokratisk_1_A = mkA "aristokratisk" ; -- aristokratisk..av.1
  aristokratvälde_1_N = mkN "aristokratvälde" ; -- aristokratvälde..nn.1
  aritet_1_N = mkN "aritet" "ariteter" ; -- aritet..nn.1
  aritmetik_1_N = mkN "aritmetik" ; -- aritmetik..nn.1
  aritmetiker_1_N = mkN "aritmetiker" "aritmetikern" "aritmetiker" "aritmetikerna" ; -- aritmetiker..nn.1
  aritmetisk_1_A = mkA "aritmetisk" ; -- aritmetisk..av.1
  ark_1_N = mkN "ark" neutrum  ; -- ark..nn.1
  ark_2_N = mkN "ark" ; -- ark..nn.2
  arkad_1_N = mkN "arkad" "arkader" ; -- arkad..nn.1
  arkadgång_1_N = mkN "arkadgång" ; -- arkadgång..nn.1
  arkadisk_1_A = mkA "arkadisk" ; -- arkadisk..av.1
  arkadspel_1_N = mkN "arkadspel" "arkadspelet" "arkadspel" "arkadspelen" ; -- arkadspel..nn.1
  arkaisera_1_V = mkV "arkaiserar" ; -- arkaisera..vb.1
  arkaiserande_1_N = mkN "arkaiserande" ; -- arkaiserande..nn.1
  arkaiserbar_1_A = mkA "arkaiserbar" ; -- arkaiserbar..av.1
  arkaiserbarhet_1_N = mkN "arkaiserbarhet" ; -- arkaiserbarhet..nn.1
  arkaisering_1_N = mkN "arkaisering" ; -- arkaisering..nn.1
  arkaisk_1_A = mkA "arkaisk" ; -- arkaisk..av.1
  arkaism_1_N = mkN "arkaism" "arkaismer" ; -- arkaism..nn.1
  arkaistisk_1_A = mkA "arkaistisk" ; -- arkaistisk..av.1
  arkebusera_1_V = mkV "arkebuserar" ; -- arkebusera..vb.1
  arkebuserande_1_N = mkN "arkebuserande" ; -- arkebuserande..nn.1
  arkebuserbar_1_A = mkA "arkebuserbar" ; -- arkebuserbar..av.1
  arkebuserbarhet_1_N = mkN "arkebuserbarhet" ; -- arkebuserbarhet..nn.1
  arkebusering_1_N = mkN "arkebusering" ; -- arkebusering..nn.1
  arkeikum_1_N = mkN "arkeikum" ; -- arkeikum..nn.1
  arkeolog_1_N = mkN "arkeolog" "arkeologer" ; -- arkeolog..nn.1
  arkeologi_1_N = mkN "arkeologi" ; -- arkeologi..nn.1
  arkeologisk_1_A = mkA "arkeologisk" ; -- arkeologisk..av.1
  arkeologiämne_1_N = mkN "arkeologiämne" ; -- arkeologiämne..nn.1
  arkeologkongress_1_N = mkN "arkeologkongress" "arkeologkongresser" ; -- arkeologkongress..nn.1
  arketyp_1_N = mkN "arketyp" "arketyper" ; -- arketyp..nn.1
  arketypisk_1_A = mkA "arketypisk" ; -- arketypisk..av.1
  arkiater_1_N = mkN "arkiater" "arkiatern" "arkiatrer" "arkiatrerna" ; -- arkiater..nn.1
  arkipelag_1_N = mkN "arkipelag" "arkipelager" ; -- arkipelag..nn.1
  arkitekt_1_N = mkN "arkitekt" "arkitekter" ; -- arkitekt..nn.1
  arkitektonik_1_N = mkN "arkitektonik" ; -- arkitektonik..nn.1
  arkitektonisk_1_A = mkA "arkitektonisk" ; -- arkitektonisk..av.1
  arkitektur_1_N = mkN "arkitektur" "arkitekturer" ; -- arkitektur..nn.1
  arkitekturpolitik_1_N = mkN "arkitekturpolitik" ; -- arkitekturpolitik..nn.1
  arkitekturpolitisk_1_A = mkA "arkitekturpolitisk" ; -- arkitekturpolitisk..av.1
  arkitekturritning_1_N = mkN "arkitekturritning" ; -- arkitekturritning..nn.1
  arkitrav_1_N = mkN "arkitrav" "arkitraver" ; -- arkitrav..nn.1
  arkiv_1_N = mkN "arkiv" neutrum  ; -- arkiv..nn.1
  arkivalieskåp_1_N = mkN "arkivalieskåp" neutrum  ; -- arkivalieskåp..nn.1
  arkivalisk_1_A = mkA "arkivalisk" ; -- arkivalisk..av.1
  arkivarbetare_1_N = mkN "arkivarbetare" utrum  ; -- arkivarbetare..nn.1
  arkivarbete_1_N = mkN "arkivarbete" ; -- arkivarbete..nn.1
  arkivarie_1_N = mkN "arkivarie" "arkivarier" ; -- arkivarie..nn.1
  arkivera_1_V = mkV "arkiverar" ; -- arkivera..vb.1
  arkiverande_1_N = mkN "arkiverande" ; -- arkiverande..nn.1
  arkiverbar_1_A = mkA "arkiverbar" ; -- arkiverbar..av.1
  arkiverbarhet_1_N = mkN "arkiverbarhet" ; -- arkiverbarhet..nn.1
  arkivering_1_N = mkN "arkivering" ; -- arkivering..nn.1
  arkivexemplar_1_N = mkN "arkivexemplar" neutrum  ; -- arkivexemplar..nn.1
  arkivforskning_1_N = mkN "arkivforskning" ; -- arkivforskning..nn.1
  arkivmaterial_1_N = mkN "arkivmaterial" neutrum  ; -- arkivmaterial..nn.1
  arkivolt_1_N = mkN "arkivolt" "arkivolter" ; -- arkivolt..nn.1
  arkivsamling_1_N = mkN "arkivsamling" ; -- arkivsamling..nn.1
  arkivstudie_1_N = mkN "arkivstudie" "arkivstudier" ; -- arkivstudie..nn.1
  arksignatur_1_N = mkN "arksignatur" "arksignaturer" ; -- arksignatur..nn.1
  arktisk_1_A = mkA "arktisk" ; -- arktisk..av.1
  arkvis_1_Adv = mkAdv "arkvis" ; -- arkvis..ab.1
  arm_1_A = mkA "arm" ; -- arm..av.1
  arm_1_N = mkN "arm" ; -- arm..nn.1
  armada_1_N = mkN "armada" ; -- armada..nn.1
  armagnac_1_N = mkN "armagnac" ; -- armagnac..nn.1
  armatur_1_N = mkN "armatur" "armaturer" ; -- armatur..nn.1
  armband_1_N = mkN "armband" neutrum  ; -- armband..nn.1
  armbandslås_1_N = mkN "armbandslås" neutrum  ; -- armbandslås..nn.1
  armbandsur_1_N = mkN "armbandsur" neutrum  ; -- armbandsur..nn.1
  armbindel_1_N = mkN "armbindel" ; -- armbindel..nn.1
  armborst_1_N = mkN "armborst" neutrum  ; -- armborst..nn.1
  armborstpil_1_N = mkN "armborstpil" ; -- armborstpil..nn.1
  armborstskytt_1_N = mkN "armborstskytt" ; -- armborstskytt..nn.1
  armbrott_1_N = mkN "armbrott" neutrum  ; -- armbrott..nn.1
  armbrytning_1_N = mkN "armbrytning" ; -- armbrytning..nn.1
  armbågande_1_N = mkN "armbågande" ; -- armbågande..nn.1
  armbåge_1_N = mkN "armbåge" utrum  ; -- armbåge..nn.1
  armbågsben_1_N = mkN "armbågsben" neutrum  ; -- armbågsben..nn.1
  armbågsled_1_N = mkN "armbågsled" "armbågsleder" ; -- armbågsled..nn.1
  armbågsnerv_1_N = mkN "armbågsnerv" "armbågsnerver" ; -- armbågsnerv..nn.1
  armbågsskydd_1_N = mkN "armbågsskydd" neutrum  ; -- armbågsskydd..nn.1
  armbågssträckare_1_N = mkN "armbågssträckare" utrum  ; -- armbågssträckare..nn.1
  armbågsutskott_1_N = mkN "armbågsutskott" neutrum  ; -- armbågsutskott..nn.1
  armböjning_1_N = mkN "armböjning" ; -- armböjning..nn.1
  armcylinder_1_N = mkN "armcylinder" ; -- armcylinder..nn.1
  armdyna_1_N = mkN "armdyna" ; -- armdyna..nn.1
  armenier_1_N = mkN "armenier" "armeniern" "armenier" "armenierna" ; -- armenier..nn.1
  armenisk_1_A = mkA "armenisk" ; -- armenisk..av.1
  armeniska_1_N = mkN "armeniska" ; -- armeniska..nn.1
  armeniska_2_N = mkN "armeniska" ; -- armeniska..nn.2
  armera_1_V = mkV "armerar" ; -- armera..vb.1
  armerande_1_N = mkN "armerande" ; -- armerande..nn.1
  armerbar_1_A = mkA "armerbar" ; -- armerbar..av.1
  armerbarhet_1_N = mkN "armerbarhet" ; -- armerbarhet..nn.1
  armering_1_N = mkN "armering" ; -- armering..nn.1
  armeringsjärn_1_N = mkN "armeringsjärn" neutrum  ; -- armeringsjärn..nn.1
  armfläta_1_N = mkN "armfläta" ; -- armfläta..nn.1
  armfoting_1_N = mkN "armfoting" ; -- armfoting..nn.1
  armföring_1_N = mkN "armföring" ; -- armföring..nn.1
  armgång_1_N = mkN "armgång" ; -- armgång..nn.1
  armhet_1_N = mkN "armhet" ; -- armhet..nn.1
  armhävning_1_N = mkN "armhävning" ; -- armhävning..nn.1
  armhåla_1_N = mkN "armhåla" ; -- armhåla..nn.1
  armhålsstöd_1_N = mkN "armhålsstöd" neutrum  ; -- armhålsstöd..nn.1
  armkraft_1_N = mkN "armkraft" "armkrafter" ; -- armkraft..nn.1
  armkrok_1_N = mkN "armkrok" ; -- armkrok..nn.1
  armkrokskedja_1_N = mkN "armkrokskedja" ; -- armkrokskedja..nn.1
  armled_1_N = mkN "armled" "armleder" ; -- armled..nn.1
  armljusstake_1_N = mkN "armljusstake" utrum  ; -- armljusstake..nn.1
  armlängd_1_N = mkN "armlängd" "armlängder" ; -- armlängd..nn.1
  armlås_1_N = mkN "armlås" neutrum  ; -- armlås..nn.1
  armmudd_1_N = mkN "armmudd" ; -- armmudd..nn.1
  armmuskel_1_N = mkN "armmuskel" "armmuskeln" "armmuskler" "armmusklerna" ; -- armmuskel..nn.1
  armod_1_N = mkN "armod" neutrum  ; -- armod..nn.1
  armodslöfte_1_N = mkN "armodslöfte" ; -- armodslöfte..nn.1
  armpolyp_1_N = mkN "armpolyp" "armpolyper" ; -- armpolyp..nn.1
  armring_1_N = mkN "armring" ; -- armring..nn.1
  armrörelse_1_N = mkN "armrörelse" "armrörelser" ; -- armrörelse..nn.1
  armskada_1_N = mkN "armskada" ; -- armskada..nn.1
  armslängd_1_N = mkN "armslängd" "armslängder" ; -- armslängd..nn.1
  armslång_1_A = mkA "armslång" ; -- armslång..av.1
  armstark_1_A = mkA "armstark" ; -- armstark..av.1
  armstjock_1_A = mkA "armstjock" ; -- armstjock..av.1
  armstol_1_N = mkN "armstol" ; -- armstol..nn.1
  armsträckning_1_N = mkN "armsträckning" ; -- armsträckning..nn.1
  armstump_1_N = mkN "armstump" ; -- armstump..nn.1
  armstyrka_1_N = mkN "armstyrka" ; -- armstyrka..nn.1
  armstöd_1_N = mkN "armstöd" neutrum  ; -- armstöd..nn.1
  armsvag_1_A = mkA "armsvag" ; -- armsvag..av.1
  armsvett_1_N = mkN "armsvett" ; -- armsvett..nn.1
  armtag_1_N = mkN "armtag" neutrum  ; -- armtag..nn.1
  armtrakt_1_N = mkN "armtrakt" "armtrakter" ; -- armtrakt..nn.1
  armveck_1_N = mkN "armveck" neutrum  ; -- armveck..nn.1
  armé_1_N = mkN "armé" "arméer" ; -- armé..nn.1
  arméattaché_1_N = mkN "arméattaché" "arméattachéer" ; -- arméattaché..nn.1
  arméavdelning_1_N = mkN "arméavdelning" ; -- arméavdelning..nn.1
  arméchef_1_N = mkN "arméchef" "arméchefer" ; -- arméchef..nn.1
  arméförband_1_N = mkN "arméförband" neutrum  ; -- arméförband..nn.1
  arméfördelning_1_N = mkN "arméfördelning" ; -- arméfördelning..nn.1
  arméförvaltning_1_N = mkN "arméförvaltning" ; -- arméförvaltning..nn.1
  armégeneral_1_N = mkN "armégeneral" "armégeneraler" ; -- armégeneral..nn.1
  armégevär_1_N = mkN "armégevär" neutrum  ; -- armégevär..nn.1
  arméhelikopter_1_N = mkN "arméhelikopter" ; -- arméhelikopter..nn.1
  arméhäst_1_N = mkN "arméhäst" ; -- arméhäst..nn.1
  armékommuniké_1_N = mkN "armékommuniké" "armékommunikéer" ; -- armékommuniké..nn.1
  armékår_1_N = mkN "armékår" "armékårer" ; -- armékår..nn.1
  arméorganisation_1_N = mkN "arméorganisation" ; -- arméorganisation..nn.1
  arméstab_1_N = mkN "arméstab" "arméstaber" ; -- arméstab..nn.1
  arméunderstöd_1_N = mkN "arméunderstöd" neutrum  ; -- arméunderstöd..nn.1
  arom_1_N = mkN "arom" "aromer" ; -- arom..nn.1
  aromatisk_1_A = mkA "aromatisk" ; -- aromatisk..av.1
  aromglas_1_N = mkN "aromglas" neutrum  ; -- aromglas..nn.1
  aromkupa_1_N = mkN "aromkupa" ; -- aromkupa..nn.1
  arpeggio_1_N = mkN "arpeggio" "arpeggiot" "arpeggion" "arpeggiona" ; -- arpeggio..nn.1
  arr_1_N = mkN "arr" neutrum  ; -- arr..nn.1
  arra_1_V = mkV "arrar" ; -- arra..vb.1
  arrak_1_N = mkN "arrak" ; -- arrak..nn.1
  arrakpunch_1_N = mkN "arrakpunch" ; -- arrakpunch..nn.1
  arrakpunsch_1_N = mkN "arrakpunsch" ; -- arrakpunsch..nn.1
  arrakspunsch_1_N = mkN "arrakspunsch" ; -- arrakspunsch..nn.1
  arrakssmak_1_N = mkN "arrakssmak" "arrakssmaker" ; -- arrakssmak..nn.1
  arrakstoddy_1_N = mkN "arrakstoddy" "arrakstoddyn" "arrakstoddar" "arrakstoddarna" ; -- arrakstoddy..nn.1
  arrangemang_1_N = mkN "arrangemang" neutrum  ; -- arrangemang..nn.1
  arrangemangsmässig_1_A = mkA "arrangemangsmässig" ; -- arrangemangsmässig..av.1
  arrangera_1_V = mkV "arrangerar" ; -- arrangera..vb.1
  arrangerande_1_N = mkN "arrangerande" ; -- arrangerande..nn.1
  arrangerbar_1_A = mkA "arrangerbar" ; -- arrangerbar..av.1
  arrangerbarhet_1_N = mkN "arrangerbarhet" ; -- arrangerbarhet..nn.1
  arrangering_1_N = mkN "arrangering" ; -- arrangering..nn.1
  arrangör_1_N = mkN "arrangör" "arrangörer" ; -- arrangör..nn.1
  arrangörsmässig_1_A = mkA "arrangörsmässig" ; -- arrangörsmässig..av.1
  arrendator_1_N = mkN "arrendator" "arrendatorer" ; -- arrendator..nn.1
  arrende_1_N = mkN "arrende" ; -- arrende..nn.1
  arrendeavgift_1_N = mkN "arrendeavgift" "arrendeavgifter" ; -- arrendeavgift..nn.1
  arrendebelopp_1_N = mkN "arrendebelopp" neutrum  ; -- arrendebelopp..nn.1
  arrendekontrakt_1_N = mkN "arrendekontrakt" neutrum  ; -- arrendekontrakt..nn.1
  arrendera_1_V = mkV "arrenderar" ; -- arrendera..vb.1
  arrenderande_1_N = mkN "arrenderande" ; -- arrenderande..nn.1
  arrenderbar_1_A = mkA "arrenderbar" ; -- arrenderbar..av.1
  arrenderbarhet_1_N = mkN "arrenderbarhet" ; -- arrenderbarhet..nn.1
  arrendering_1_N = mkN "arrendering" ; -- arrendering..nn.1
  arrendevillkor_1_N = mkN "arrendevillkor" neutrum  ; -- arrendevillkor..nn.1
  arrest_1_N = mkN "arrest" "arrester" ; -- arrest..nn.1
  arrestant_1_N = mkN "arrestant" "arrestanter" ; -- arrestant..nn.1
  arrestavdelning_1_N = mkN "arrestavdelning" ; -- arrestavdelning..nn.1
  arrestera_1_V = mkV "arresterar" ; -- arrestera..vb.1
  arresterande_1_N = mkN "arresterande" ; -- arresterande..nn.1
  arresterbar_1_A = mkA "arresterbar" ; -- arresterbar..av.1
  arresterbarhet_1_N = mkN "arresterbarhet" ; -- arresterbarhet..nn.1
  arrestering_1_N = mkN "arrestering" ; -- arrestering..nn.1
  arresteringsorder_1_N = mkN "arresteringsorder" ; -- arresteringsorder..nn.1
  arrestlokal_1_N = mkN "arrestlokal" "arrestlokaler" ; -- arrestlokal..nn.1
  arrestrum_1_N = mkN "arrestrum" "arrestrummet" "arrestrum" "arrestrummen" ; -- arrestrum..nn.1
  arreststraff_1_N = mkN "arreststraff" neutrum  ; -- arreststraff..nn.1
  arresttid_1_N = mkN "arresttid" "arresttider" ; -- arresttid..nn.1
  arriverad_1_A = mkA "arriverad" ; -- arriverad..av.1
  arrivist_1_N = mkN "arrivist" "arrivister" ; -- arrivist..nn.1
  arriärgarde_1_N = mkN "arriärgarde" ; -- arriärgarde..nn.1
  arrogans_1_N = mkN "arrogans" ; -- arrogans..nn.1
  arrogant_1_A = mkA "arrogant" "arrogant" ; -- arrogant..av.1
  arrondera_1_V = mkV "arronderar" ; -- arrondera..vb.1
  arronderande_1_N = mkN "arronderande" ; -- arronderande..nn.1
  arronderbar_1_A = mkA "arronderbar" ; -- arronderbar..av.1
  arronderbarhet_1_N = mkN "arronderbarhet" ; -- arronderbarhet..nn.1
  arrondering_1_N = mkN "arrondering" ; -- arrondering..nn.1
  arrondissemang_1_N = mkN "arrondissemang" neutrum  ; -- arrondissemang..nn.1
  arrondissement_1_N = mkN "arrondissement" neutrum  ; -- arrondissement..nn.1
  arrowrot_1_N = mkN "arrowrot" "arrowrötter" ; -- arrowrot..nn.1
  arschel_1_N = mkN "arschel" ; -- arschel..nn.1
  arschle_1_N = mkN "arschle" ; -- arschle..nn.1
  arsel_1_N = mkN "arsel" ; -- arsel..nn.1
  arsenal_1_N = mkN "arsenal" "arsenaler" ; -- arsenal..nn.1
  arsenalsbyggnad_1_N = mkN "arsenalsbyggnad" "arsenalsbyggnader" ; -- arsenalsbyggnad..nn.1
  arsenik_1_N = mkN "arsenik" ; -- arsenik..nn.1
  arsenikdos_1_N = mkN "arsenikdos" "arsenikdoser" ; -- arsenikdos..nn.1
  arsenikfri_1_A = mkA "arsenikfri" "arsenikfritt" ; -- arsenikfri..av.1
  arsenikförgiftning_1_N = mkN "arsenikförgiftning" ; -- arsenikförgiftning..nn.1
  arsenikhalt_1_N = mkN "arsenikhalt" "arsenikhalter" ; -- arsenikhalt..nn.1
  arsenikhaltig_1_A = mkA "arsenikhaltig" ; -- arsenikhaltig..av.1
  arsenikkis_1_N = mkN "arsenikkis" "arsenikkiser" ; -- arsenikkis..nn.1
  arsenikmord_1_N = mkN "arsenikmord" neutrum  ; -- arsenikmord..nn.1
  arsenikväte_1_N = mkN "arsenikväte" ; -- arsenikväte..nn.1
  arsle_1_N = mkN "arsle" ; -- arsle..nn.1
  art_1_N = mkN "art" "arter" ; -- art..nn.1
  artbank_1_N = mkN "artbank" "artbanker" ; -- artbank..nn.1
  artbeskrivning_1_N = mkN "artbeskrivning" ; -- artbeskrivning..nn.1
  artbestämma_1_V = mkV "artbestämmer" ; -- artbestämma..vb.1
  artbestämmande_1_N = mkN "artbestämmande" ; -- artbestämmande..nn.1
  artbestämning_1_N = mkN "artbestämning" ; -- artbestämning..nn.1
  artbildning_1_N = mkN "artbildning" ; -- artbildning..nn.1
  artbildningsteori_1_N = mkN "artbildningsteori" "artbildningsteorier" ; -- artbildningsteori..nn.1
  artdatabank_1_N = mkN "artdatabank" "artdatabanker" ; -- artdatabank..nn.1
  artefakt_1_N = mkN "artefakt" "artefakter" ; -- artefakt..nn.1
  artegen_1_A = mkA "artegen" ; -- artegen..av.1
  artegenhet_1_N = mkN "artegenhet" ; -- artegenhet..nn.1
  arteriell_1_A = mkA "arteriell" ; -- arteriell..av.1
  arterioskleros_1_N = mkN "arterioskleros" "arterioskleroser" ; -- arterioskleros..nn.1
  arterit_1_N = mkN "arterit" "arteriter" ; -- arterit..nn.1
  arterivirusinfektion_1_N = mkN "arterivirusinfektion" ; -- arterivirusinfektion..nn.1
  artesisk_1_A = mkA "artesisk" ; -- artesisk..av.1
  artfrämmande_1_A = mkA "artfrämmande" ; -- artfrämmande..av.1
  artfrände_1_N = mkN "artfrände" "artfränder" ; -- artfrände..nn.1
  artförändring_1_N = mkN "artförändring" ; -- artförändring..nn.1
  artificiell_1_A = mkA "artificiell" ; -- artificiell..av.1
  artig_1_A = mkA "artig" ; -- artig..av.1
  artighet_1_N = mkN "artighet" "artigheter" ; -- artighet..nn.1
  artighetsbetygelse_1_N = mkN "artighetsbetygelse" "artighetsbetygelser" ; -- artighetsbetygelse..nn.1
  artighetsbevis_1_N = mkN "artighetsbevis" neutrum  ; -- artighetsbevis..nn.1
  artighetsfras_1_N = mkN "artighetsfras" "artighetsfraser" ; -- artighetsfras..nn.1
  artighetsvisit_1_N = mkN "artighetsvisit" "artighetsvisiter" ; -- artighetsvisit..nn.1
  artikel_1_N = mkN "artikel" ; -- artikel..nn.1
  artikelförfattare_1_N = mkN "artikelförfattare" utrum  ; -- artikelförfattare..nn.1
  artikelserie_1_N = mkN "artikelserie" "artikelserier" ; -- artikelserie..nn.1
  artikulation_1_N = mkN "artikulation" ; -- artikulation..nn.1
  artikulationsbas_1_N = mkN "artikulationsbas" "artikulationsbaser" ; -- artikulationsbas..nn.1
  artikulationsrubbning_1_N = mkN "artikulationsrubbning" ; -- artikulationsrubbning..nn.1
  artikulationsställe_1_N = mkN "artikulationsställe" ; -- artikulationsställe..nn.1
  artikulera_1_V = mkV "artikulerar" ; -- artikulera..vb.1
  artikulerande_1_N = mkN "artikulerande" ; -- artikulerande..nn.1
  artikulerbar_1_A = mkA "artikulerbar" ; -- artikulerbar..av.1
  artikulerbarhet_1_N = mkN "artikulerbarhet" ; -- artikulerbarhet..nn.1
  artikulering_1_N = mkN "artikulering" ; -- artikulering..nn.1
  artilleri_1_N = mkN "artilleri" neutrum  ; -- artilleri..nn.1
  artilleribatteri_1_N = mkN "artilleribatteri" "artilleribatteriet" "artilleribatterier" "artilleribatterierna" ; -- artilleribatteri..nn.1
  artilleribeskjutning_1_N = mkN "artilleribeskjutning" ; -- artilleribeskjutning..nn.1
  artilleriduell_1_N = mkN "artilleriduell" "artilleridueller" ; -- artilleriduell..nn.1
  artillerield_1_N = mkN "artillerield" ; -- artillerield..nn.1
  artilleriförband_1_N = mkN "artilleriförband" neutrum  ; -- artilleriförband..nn.1
  artillerigranat_1_N = mkN "artillerigranat" "artillerigranater" ; -- artillerigranat..nn.1
  artillerimanskap_1_N = mkN "artillerimanskap" neutrum  ; -- artillerimanskap..nn.1
  artilleripjäs_1_N = mkN "artilleripjäs" "artilleripjäser" ; -- artilleripjäs..nn.1
  artilleriregemente_1_N = mkN "artilleriregemente" ; -- artilleriregemente..nn.1
  artillerist_1_N = mkN "artillerist" "artillerister" ; -- artillerist..nn.1
  artillerivapen_1_N = mkN "artillerivapen" "artillerivapnet" "artillerivapen" "artillerivapnen" ; -- artillerivapen..nn.1
  artist_1_N = mkN "artist" "artister" ; -- artist..nn.1
  artistbana_1_N = mkN "artistbana" ; -- artistbana..nn.1
  artisteri_1_N = mkN "artisteri" neutrum  ; -- artisteri..nn.1
  artistframträdande_1_N = mkN "artistframträdande" ; -- artistframträdande..nn.1
  artistisk_1_A = mkA "artistisk" ; -- artistisk..av.1
  artistliv_1_N = mkN "artistliv" neutrum  ; -- artistliv..nn.1
  artistmässig_1_A = mkA "artistmässig" ; -- artistmässig..av.1
  artistnamn_1_N = mkN "artistnamn" neutrum  ; -- artistnamn..nn.1
  artnamn_1_N = mkN "artnamn" neutrum  ; -- artnamn..nn.1
  artonde_1_A = mkA "artonde" ; -- artonde..av.1
  artonhundranittiotal_1_N = mkN "artonhundranittiotal" neutrum  ; -- artonhundranittiotal..nn.1
  artonhundrasjuttiotal_1_N = mkN "artonhundrasjuttiotal" neutrum  ; -- artonhundrasjuttiotal..nn.1
  artonhundratal_1_N = mkN "artonhundratal" neutrum  ; -- artonhundratal..nn.1
  artonhundratalsmode_1_N = mkN "artonhundratalsmode" ; -- artonhundratalsmode..nn.1
  artonhundraåttiotal_1_N = mkN "artonhundraåttiotal" neutrum  ; -- artonhundraåttiotal..nn.1
  artonårig_1_A = mkA "artonårig" ; -- artonårig..av.1
  artonåring_1_N = mkN "artonåring" ; -- artonåring..nn.1
  artonårsdag_1_N = mkN "artonårsdag" ; -- artonårsdag..nn.1
  artonårsmyndighet_1_N = mkN "artonårsmyndighet" ; -- artonårsmyndighet..nn.1
  artotek_1_N = mkN "artotek" neutrum  ; -- artotek..nn.1
  artralgi_1_N = mkN "artralgi" ; -- artralgi..nn.1
  artrik_1_A = mkA "artrik" ; -- artrik..av.1
  artrikhet_1_N = mkN "artrikhet" ; -- artrikhet..nn.1
  artrit_1_N = mkN "artrit" "artriter" ; -- artrit..nn.1
  artrogrypos_1_N = mkN "artrogrypos" ; -- artrogrypos..nn.1
  artros_1_N = mkN "artros" "artroser" ; -- artros..nn.1
  artroskopi_1_N = mkN "artroskopi" "artroskopier" ; -- artroskopi..nn.1
  artskild_1_A = mkA "artskild" "artskilt" ; -- artskild..av.1
  artskildhet_1_N = mkN "artskildhet" ; -- artskildhet..nn.1
  artskillnad_1_N = mkN "artskillnad" "artskillnader" ; -- artskillnad..nn.1
  artär_1_N = mkN "artär" "artärer" ; -- artär..nn.1
  artärbråck_1_N = mkN "artärbråck" neutrum  ; -- artärbråck..nn.1
  artärinflammation_1_N = mkN "artärinflammation" ; -- artärinflammation..nn.1
  artärvägg_1_N = mkN "artärvägg" ; -- artärvägg..nn.1
  arv_1_N = mkN "arv" neutrum  ; -- arv..nn.1
  arve_1_N = mkN "arv" ; -- arve..nn.1
  arvedel_1_N = mkN "arvedel" "arvedelen" "arvedelar" "arvedelarna" ; -- arvedel..nn.1
  arvegods_1_N = mkN "arvegods" neutrum  ; -- arvegods..nn.1
  arvejord_1_N = mkN "arvejord" ; -- arvejord..nn.1
  arvfiende_1_N = mkN "arvfiende" "arvfiender" ; -- arvfiende..nn.1
  arvfurste_1_N = mkN "arvfurste" utrum  ; -- arvfurste..nn.1
  arvföljd_1_N = mkN "arvföljd" "arvföljder" ; -- arvföljd..nn.1
  arvföljdskrig_1_N = mkN "arvföljdskrig" neutrum  ; -- arvföljdskrig..nn.1
  arvförening_1_N = mkN "arvförening" ; -- arvförening..nn.1
  arvinge_1_N = mkN "arvinge" utrum  ; -- arvinge..nn.1
  arvkonung_1_N = mkN "arvkonung" ; -- arvkonung..nn.1
  arvland_1_N = mkN "arvland" "arvlandet" "arvländer" "arvländerna" ; -- arvland..nn.1
  arvlåtare_1_N = mkN "arvlåtare" utrum  ; -- arvlåtare..nn.1
  arvlös_1_A = mkA "arvlös" ; -- arvlös..av.1
  arvlöshet_1_N = mkN "arvlöshet" ; -- arvlöshet..nn.1
  arvode_1_N = mkN "arvode" ; -- arvode..nn.1
  arvodera_1_V = mkV "arvoderar" ; -- arvodera..vb.1
  arvoderande_1_N = mkN "arvoderande" ; -- arvoderande..nn.1
  arvoderbar_1_A = mkA "arvoderbar" ; -- arvoderbar..av.1
  arvoderbarhet_1_N = mkN "arvoderbarhet" ; -- arvoderbarhet..nn.1
  arvodering_1_N = mkN "arvodering" ; -- arvodering..nn.1
  arvodesbelopp_1_N = mkN "arvodesbelopp" neutrum  ; -- arvodesbelopp..nn.1
  arvord_1_N = mkN "arvord" neutrum  ; -- arvord..nn.1
  arvprins_1_N = mkN "arvprins" ; -- arvprins..nn.1
  arvrike_1_N = mkN "arvrike" ; -- arvrike..nn.1
  arvsanlag_1_N = mkN "arvsanlag" neutrum  ; -- arvsanlag..nn.1
  arvsanspråk_1_N = mkN "arvsanspråk" neutrum  ; -- arvsanspråk..nn.1
  arvsberättigad_1_A = mkA "arvsberättigad" ; -- arvsberättigad..av.1
  arvsfaktor_1_N = mkN "arvsfaktor" "arvsfaktorer" ; -- arvsfaktor..nn.1
  arvsfond_1_N = mkN "arvsfond" "arvsfonder" ; -- arvsfond..nn.1
  arvsfråga_1_N = mkN "arvsfråga" ; -- arvsfråga..nn.1
  arvsföljd_1_N = mkN "arvsföljd" "arvsföljder" ; -- arvsföljd..nn.1
  arvskatt_1_N = mkN "arvskatt" "arvskatter" ; -- arvskatt..nn.1
  arvskifte_1_N = mkN "arvskifte" ; -- arvskifte..nn.1
  arvslott_1_N = mkN "arvslott" "arvslotter" ; -- arvslott..nn.1
  arvsmassa_1_N = mkN "arvsmassa" ; -- arvsmassa..nn.1
  arvsmedel_1_N = mkN "arvsmedel" neutrum  ; -- arvsmedel..nn.1
  arvsmolekyl_1_N = mkN "arvsmolekyl" "arvsmolekyler" ; -- arvsmolekyl..nn.1
  arvsmässig_1_A = mkA "arvsmässig" ; -- arvsmässig..av.1
  arvsordning_1_N = mkN "arvsordning" ; -- arvsordning..nn.1
  arvsrätt_1_N = mkN "arvsrätt" "arvsrätter" ; -- arvsrätt..nn.1
  arvssak_1_N = mkN "arvssak" "arvssaker" ; -- arvssak..nn.1
  arvsskatt_1_N = mkN "arvsskatt" "arvsskatter" ; -- arvsskatt..nn.1
  arvstvist_1_N = mkN "arvstvist" "arvstvister" ; -- arvstvist..nn.1
  arvsynd_1_N = mkN "arvsynd" "arvsynder" ; -- arvsynd..nn.1
  arvtagare_1_N = mkN "arvtagare" utrum  ; -- arvtagare..nn.1
  arvtant_1_N = mkN "arvtant" "arvtanter" ; -- arvtant..nn.1
  arytmi_1_N = mkN "arytmi" "arytmier" ; -- arytmi..nn.1
  as_1_N = mkN "as" neutrum  ; -- as..nn.1
  as_2_N = mkN "as" ; -- as..nn.2
  asa_1_V = mkV "asar" ; -- asa..vb.1
  asagud_1_N = mkN "asagud" ; -- asagud..nn.1
  asalära_1_N = mkN "asalära" ; -- asalära..nn.1
  asande_1_N = mkN "asande" ; -- asande..nn.1
  asasläkt_1_N = mkN "asasläkt" ; -- asasläkt..nn.1
  asatid_1_N = mkN "asatid" ; -- asatid..nn.1
  asatro_1_N = mkN "asatro" ; -- asatro..nn.1
  asatroende_1_A = mkA "asatroende" ; -- asatroende..av.1
  asbagge_1_N = mkN "asbagge" utrum  ; -- asbagge..nn.1
  asberusad_1_A = mkA "asberusad" ; -- asberusad..av.1
  asbest_1_N = mkN "asbest" ; -- asbest..nn.1
  asbestarbetare_1_N = mkN "asbestarbetare" utrum  ; -- asbestarbetare..nn.1
  asbestartad_1_A = mkA "asbestartad" ; -- asbestartad..av.1
  asbestcement_1_N = mkN "asbestcement" ; -- asbestcement..nn.1
  asbestlunga_1_N = mkN "asbestlunga" ; -- asbestlunga..nn.1
  asbestos_1_N = mkN "asbestos" ; -- asbestos..nn.1
  asbestplatta_1_N = mkN "asbestplatta" ; -- asbestplatta..nn.1
  asbestsanering_1_N = mkN "asbestsanering" ; -- asbestsanering..nn.1
  asbesttråd_1_N = mkN "asbesttråd" ; -- asbesttråd..nn.1
  ascaridiasis_1_N = mkN "ascaridiasis" "ascaridiasiser" ; -- ascaridiasis..nn.1
  ascarididainfektion_1_N = mkN "ascarididainfektion" ; -- ascarididainfektion..nn.1
  ascendent_1_N = mkN "ascendent" "ascendenter" ; -- ascendent..nn.1
  aschel_1_N = mkN "aschel" ; -- aschel..nn.1
  aschle_1_N = mkN "aschle" ; -- aschle..nn.1
  ascites_1_N = mkN "ascites" ; -- ascites..nn.1
  asenkel_1_A = mkA "asenkel" ; -- asenkel..av.1
  aseptik_1_N = mkN "aseptik" ; -- aseptik..nn.1
  aseptisk_1_A = mkA "aseptisk" ; -- aseptisk..av.1
  asexuell_1_A = mkA "asexuell" ; -- asexuell..av.1
  asfalt_1_N = mkN "asfalt" "asfalter" ; -- asfalt..nn.1
  asfaltemulsion_1_N = mkN "asfaltemulsion" ; -- asfaltemulsion..nn.1
  asfaltera_1_V = mkV "asfalterar" ; -- asfaltera..vb.1
  asfalterande_1_N = mkN "asfalterande" ; -- asfalterande..nn.1
  asfalterbar_1_A = mkA "asfalterbar" ; -- asfalterbar..av.1
  asfalterbarhet_1_N = mkN "asfalterbarhet" ; -- asfalterbarhet..nn.1
  asfaltering_1_N = mkN "asfaltering" ; -- asfaltering..nn.1
  asfaltlack_1_N = mkN "asfaltlack" "asfaltlacker" ; -- asfaltlack..nn.1
  asfaltmoped_1_N = mkN "asfaltmoped" "asfaltmopeder" ; -- asfaltmoped..nn.1
  asfaltplatta_1_N = mkN "asfaltplatta" ; -- asfaltplatta..nn.1
  asfluga_1_N = mkN "asfluga" ; -- asfluga..nn.1
  asfull_1_A = mkA "asfull" ; -- asfull..av.1
  asfyxi_1_N = mkN "asfyxi" ; -- asfyxi..nn.1
  asfyxiskada_1_N = mkN "asfyxiskada" ; -- asfyxiskada..nn.1
  asfågel_1_N = mkN "asfågel" ; -- asfågel..nn.1
  asförbannad_1_A = mkA "asförbannad" ; -- asförbannad..av.1
  asgam_1_N = mkN "asgam" ; -- asgam..nn.1
  asgarva_1_V = mkV "asgarvar" ; -- asgarva..vb.1
  ashkenaz_1_N = mkN "ashkenaz" "ashkenazer" ; -- ashkenaz..nn.1
  ashkenazisk_1_A = mkA "ashkenazisk" ; -- ashkenazisk..av.1
  asiat_1_N = mkN "asiat" "asiater" ; -- asiat..nn.1
  asiatisk_1_A = mkA "asiatisk" ; -- asiatisk..av.1
  asiatiska_1_N = mkN "asiatiska" ; -- asiatiska..nn.1
  asimut_1_N = mkN "asimut" "asimuter" ; -- asimut..nn.1
  ask_1_N = mkN "ask" ; -- ask..nn.1
  aska_1_N = mkN "aska" ; -- aska..nn.1
  aska_1_V = mkV "askar" ; -- aska..vb.1
  askande_1_N = mkN "askande" ; -- askande..nn.1
  askblond_1_A = mkA "askblond" ; -- askblond..av.1
  aske_1_N = mkN "aske" ; -- aske..nn.1
  askenas_1_N = mkN "askenas" "askenaser" ; -- askenas..nn.1
  askeruption_1_N = mkN "askeruption" ; -- askeruption..nn.1
  askes_1_N = mkN "askes" ; -- askes..nn.1
  asket_1_N = mkN "asket" "asketer" ; -- asket..nn.1
  asketisk_1_A = mkA "asketisk" ; -- asketisk..av.1
  asketism_1_N = mkN "asketism" "asketismer" ; -- asketism..nn.1
  asketliv_1_N = mkN "asketliv" neutrum  ; -- asketliv..nn.1
  askexplosion_1_N = mkN "askexplosion" ; -- askexplosion..nn.1
  askfat_1_N = mkN "askfat" neutrum  ; -- askfat..nn.1
  askfri_1_A = mkA "askfri" "askfritt" ; -- askfri..av.1
  askfrihet_1_N = mkN "askfrihet" ; -- askfrihet..nn.1
  askgrå_1_A = mkA "askgrå" "askgrått" ; -- askgrå..av.1
  askhot_1_N = mkN "askhot" neutrum  ; -- askhot..nn.1
  askhög_1_N = mkN "askhög" ; -- askhög..nn.1
  askkoncentration_1_N = mkN "askkoncentration" ; -- askkoncentration..nn.1
  askkopp_1_N = mkN "askkopp" ; -- askkopp..nn.1
  askkris_1_N = mkN "askkris" "askkriser" ; -- askkris..nn.1
  asklock_1_N = mkN "asklock" neutrum  ; -- asklock..nn.1
  askmoln_1_N = mkN "askmoln" neutrum  ; -- askmoln..nn.1
  askonsdag_1_N = mkN "askonsdag" ; -- askonsdag..nn.1
  askorbinsyra_1_N = mkN "askorbinsyra" ; -- askorbinsyra..nn.1
  askorbinsyrabrist_1_N = mkN "askorbinsyrabrist" ; -- askorbinsyrabrist..nn.1
  askpartikel_1_N = mkN "askpartikel" ; -- askpartikel..nn.1
  askpuff_1_N = mkN "askpuff" ; -- askpuff..nn.1
  askregn_1_N = mkN "askregn" neutrum  ; -- askregn..nn.1
  askskott_1_N = mkN "askskott" neutrum  ; -- askskott..nn.1
  askskottssjuka_1_N = mkN "askskottssjuka" ; -- askskottssjuka..nn.1
  askspridning_1_N = mkN "askspridning" ; -- askspridning..nn.1
  asktipp_1_N = mkN "asktipp" ; -- asktipp..nn.1
  askträ_1_N = mkN "askträ" neutrum  ; -- askträ..nn.1
  askunge_1_N = mkN "askunge" utrum  ; -- askunge..nn.1
  askurna_1_N = mkN "askurna" ; -- askurna..nn.1
  asocial_1_A = mkA "asocial" ; -- asocial..av.1
  asocialitet_1_N = mkN "asocialitet" "asocialiteter" ; -- asocialitet..nn.1
  asp_1_N = mkN "asp" ; -- asp..nn.1
  aspackad_1_A = mkA "aspackad" ; -- aspackad..av.1
  aspartylglukosaminuri_1_N = mkN "aspartylglukosaminuri" ; -- aspartylglukosaminuri..nn.1
  aspbark_1_N = mkN "aspbark" ; -- aspbark..nn.1
  aspdunge_1_N = mkN "aspdunge" utrum  ; -- aspdunge..nn.1
  aspe_1_N = mkN "aspe" ; -- aspe..nn.1
  aspekt_1_N = mkN "aspekt" "aspekter" ; -- aspekt..nn.1
  aspergillos_1_N = mkN "aspergillos" ; -- aspergillos..nn.1
  aspgren_1_N = mkN "aspgren" "aspgrenen" "aspgrenar" "aspgrenarna" ; -- aspgren..nn.1
  asphänge_1_N = mkN "asphänge" ; -- asphänge..nn.1
  aspirant_1_N = mkN "aspirant" "aspiranter" ; -- aspirant..nn.1
  aspirata_1_N = mkN "aspirata" ; -- aspirata..nn.1
  aspiration_1_N = mkN "aspiration" ; -- aspiration..nn.1
  aspirationspneumoni_1_N = mkN "aspirationspneumoni" ; -- aspirationspneumoni..nn.1
  aspirera_1_V = mkV "aspirerar" ; -- aspirera..vb.1
  aspirerad_1_A = mkA "aspirerad" ; -- aspirerad..av.1
  aspirerande_1_N = mkN "aspirerande" ; -- aspirerande..nn.1
  aspirerbar_1_A = mkA "aspirerbar" ; -- aspirerbar..av.1
  aspirerbarhet_1_N = mkN "aspirerbarhet" ; -- aspirerbarhet..nn.1
  aspirering_1_N = mkN "aspirering" ; -- aspirering..nn.1
  aspirin_1_N = mkN "aspirin" "aspiriner" ; -- aspirin..nn.1
  asplöv_1_N = mkN "asplöv" neutrum  ; -- asplöv..nn.1
  aspsly_1_N = mkN "aspsly" neutrum  ; -- aspsly..nn.1
  ass_1_N = mkN "ass" neutrum  ; -- ass..nn.1
  assegaj_1_N = mkN "assegaj" "assegajer" ; -- assegaj..nn.1
  assessor_1_N = mkN "assessor" "assessorer" ; -- assessor..nn.1
  assiett_1_N = mkN "assiett" "assietter" ; -- assiett..nn.1
  assiettgaffel_1_N = mkN "assiettgaffel" ; -- assiettgaffel..nn.1
  assignant_1_N = mkN "assignant" "assignanter" ; -- assignant..nn.1
  assignation_1_N = mkN "assignation" ; -- assignation..nn.1
  assignera_1_V = mkV "assignerar" ; -- assignera..vb.1
  assignerande_1_N = mkN "assignerande" ; -- assignerande..nn.1
  assignerbar_1_A = mkA "assignerbar" ; -- assignerbar..av.1
  assignerbarhet_1_N = mkN "assignerbarhet" ; -- assignerbarhet..nn.1
  assignering_1_N = mkN "assignering" ; -- assignering..nn.1
  assimilation_1_N = mkN "assimilation" ; -- assimilation..nn.1
  assimilationsprocess_1_N = mkN "assimilationsprocess" "assimilationsprocesser" ; -- assimilationsprocess..nn.1
  assimilera_1_V = mkV "assimilerar" ; -- assimilera..vb.1
  assimilerande_1_N = mkN "assimilerande" ; -- assimilerande..nn.1
  assimilerbar_1_A = mkA "assimilerbar" ; -- assimilerbar..av.1
  assimilerbarhet_1_N = mkN "assimilerbarhet" ; -- assimilerbarhet..nn.1
  assimilering_1_N = mkN "assimilering" ; -- assimilering..nn.1
  assist_1_N = mkN "assist" "assisten" "assist" "assisten" ; -- assist..nn.1
  assistans_1_N = mkN "assistans" "assistanser" ; -- assistans..nn.1
  assistdrottning_1_N = mkN "assistdrottning" ; -- assistdrottning..nn.1
  assistent_1_N = mkN "assistent" "assistenter" ; -- assistent..nn.1
  assistera_1_V = mkV "assisterar" ; -- assistera..vb.1
  assisterande_1_N = mkN "assisterande" ; -- assisterande..nn.1
  assisterbar_1_A = mkA "assisterbar" ; -- assisterbar..av.1
  assisterbarhet_1_N = mkN "assisterbarhet" ; -- assisterbarhet..nn.1
  assistering_1_N = mkN "assistering" ; -- assistering..nn.1
  assistkung_1_N = mkN "assistkung" ; -- assistkung..nn.1
  association_1_N = mkN "association" ; -- association..nn.1
  associationsbana_1_N = mkN "associationsbana" ; -- associationsbana..nn.1
  associationskedja_1_N = mkN "associationskedja" ; -- associationskedja..nn.1
  associationslexikon_1_N = mkN "associationslexikon" neutrum  ; -- associationslexikon..nn.1
  associationspsykologi_1_N = mkN "associationspsykologi" ; -- associationspsykologi..nn.1
  associationsrik_1_A = mkA "associationsrik" ; -- associationsrik..av.1
  associationsrikedom_1_N = mkN "associationsrikedom" ; -- associationsrikedom..nn.1
  associativ_1_A = mkA "associativ" ; -- associativ..av.1
  associera_1_V = mkV "associerar" ; -- associera..vb.1
  associerande_1_N = mkN "associerande" ; -- associerande..nn.1
  associerbar_1_A = mkA "associerbar" ; -- associerbar..av.1
  associerbarhet_1_N = mkN "associerbarhet" ; -- associerbarhet..nn.1
  associering_1_N = mkN "associering" ; -- associering..nn.1
  assonans_1_N = mkN "assonans" "assonanser" ; -- assonans..nn.1
  assuradör_1_N = mkN "assuradör" "assuradörer" ; -- assuradör..nn.1
  assurans_1_N = mkN "assurans" "assuranser" ; -- assurans..nn.1
  assuransspruta_1_N = mkN "assuransspruta" ; -- assuransspruta..nn.1
  assurera_1_V = mkV "assurerar" ; -- assurera..vb.1
  assurerande_1_N = mkN "assurerande" ; -- assurerande..nn.1
  assurerbar_1_A = mkA "assurerbar" ; -- assurerbar..av.1
  assurerbarhet_1_N = mkN "assurerbarhet" ; -- assurerbarhet..nn.1
  assurering_1_N = mkN "assurering" ; -- assurering..nn.1
  assyrier_1_N = mkN "assyrier" "assyriern" "assyrier" "assyrierna" ; -- assyrier..nn.1
  assyrisk_1_A = mkA "assyrisk" ; -- assyrisk..av.1
  assyriska_1_N = mkN "assyriska" ; -- assyriska..nn.1
  assyriska_2_N = mkN "assyriska" ; -- assyriska..nn.2
  asså_1_Adv = mkAdv "asså" ; -- asså..ab.1
  astat_1_N = mkN "astat" ; -- astat..nn.1
  asteni_1_N = mkN "asteni" "astenier" ; -- asteni..nn.1
  asteniker_1_N = mkN "asteniker" "astenikern" "asteniker" "astenikerna" ; -- asteniker..nn.1
  astenisk_1_A = mkA "astenisk" ; -- astenisk..av.1
  astenopi_1_N = mkN "astenopi" ; -- astenopi..nn.1
  astenozoospermi_1_N = mkN "astenozoospermi" ; -- astenozoospermi..nn.1
  aster_1_N = mkN "aster" ; -- aster..nn.1
  asterisk_1_N = mkN "asterisk" "asterisker" ; -- asterisk..nn.1
  asteroid_1_N = mkN "asteroid" "asteroider" ; -- asteroid..nn.1
  asteroidnedfall_1_N = mkN "asteroidnedfall" neutrum  ; -- asteroidnedfall..nn.1
  asteroidnedslag_1_N = mkN "asteroidnedslag" neutrum  ; -- asteroidnedslag..nn.1
  astigmatiker_1_N = mkN "astigmatiker" "astigmatikern" "astigmatiker" "astigmatikerna" ; -- astigmatiker..nn.1
  astigmatisk_1_A = mkA "astigmatisk" ; -- astigmatisk..av.1
  astigmatism_1_N = mkN "astigmatism" "astigmatismer" ; -- astigmatism..nn.1
  astma_1_N = mkN "astma" ; -- astma..nn.1
  astmatiker_1_N = mkN "astmatiker" "astmatikern" "astmatiker" "astmatikerna" ; -- astmatiker..nn.1
  astmatisk_1_A = mkA "astmatisk" ; -- astmatisk..av.1
  astrakan_1_N = mkN "astrakan" "astrakaner" ; -- astrakan..nn.1
  astrakan_2_N = mkN "astrakan" "astrakaner" ; -- astrakan..nn.2
  astral_1_A = mkA "astral" ; -- astral..av.1
  astralkropp_1_N = mkN "astralkropp" ; -- astralkropp..nn.1
  astrocytom_1_N = mkN "astrocytom" neutrum  ; -- astrocytom..nn.1
  astrofotografi_1_N = mkN "astrofotografi" "astrofotografiet" "astrofotografier" "astrofotografierna" ; -- astrofotografi..nn.1
  astrofysik_1_N = mkN "astrofysik" ; -- astrofysik..nn.1
  astrofysiker_1_N = mkN "astrofysiker" "astrofysikern" "astrofysiker" "astrofysikerna" ; -- astrofysiker..nn.1
  astrolabium_1_N = mkN "astrolabium" "astrolabiet" "astrolabier" "astrolabierna" ; -- astrolabium..nn.1
  astrolog_1_N = mkN "astrolog" "astrologer" ; -- astrolog..nn.1
  astrologi_1_N = mkN "astrologi" ; -- astrologi..nn.1
  astrologisk_1_A = mkA "astrologisk" ; -- astrologisk..av.1
  astronaut_1_N = mkN "astronaut" "astronauter" ; -- astronaut..nn.1
  astronautik_1_N = mkN "astronautik" "astronautiker" ; -- astronautik..nn.1
  astronom_1_N = mkN "astronom" "astronomer" ; -- astronom..nn.1
  astronomi_1_N = mkN "astronomi" ; -- astronomi..nn.1
  astronomisk_1_A = mkA "astronomisk" ; -- astronomisk..av.1
  astronomisk_2_A = mkA "astronomisk" ; -- astronomisk..av.2
  astrovirusinfektion_1_N = mkN "astrovirusinfektion" ; -- astrovirusinfektion..nn.1
  asyl_1_N = mkN "asyl" "asyler" ; -- asyl..nn.1
  asylland_1_N = mkN "asylland" "asyllandet" "asylländer" "asylländerna" ; -- asylland..nn.1
  asylmottagning_1_N = mkN "asylmottagning" ; -- asylmottagning..nn.1
  asylpolitik_1_N = mkN "asylpolitik" ; -- asylpolitik..nn.1
  asylrätt_1_N = mkN "asylrätt" ; -- asylrätt..nn.1
  asylskäl_1_N = mkN "asylskäl" neutrum  ; -- asylskäl..nn.1
  asylsökande_1_A = mkA "asylsökande" ; -- asylsökande..av.1
  asylsökande_1_N = mkN "asylsökande" "asylsökanden" "asylsökanden" "asylsökandena" ; -- asylsökande..nn.1
  asymmetri_1_N = mkN "asymmetri" "asymmetrier" ; -- asymmetri..nn.1
  asymmetrisk_1_A = mkA "asymmetrisk" ; -- asymmetrisk..av.1
  asymptot_1_N = mkN "asymptot" "asymptoter" ; -- asymptot..nn.1
  asyndes_1_N = mkN "asyndes" "asyndeser" ; -- asyndes..nn.1
  asyndetisk_1_A = mkA "asyndetisk" ; -- asyndetisk..av.1
  asyndeton_1_N = mkN "asyndeton" "asyndeton" "asyndeton" "asyndetonen" ; -- asyndeton..nn.1
  asynja_1_N = mkN "asynja" ; -- asynja..nn.1
  asynkron_1_A = mkA "asynkron" ; -- asynkron..av.1
  asystoli_1_N = mkN "asystoli" "asystolier" ; -- asystoli..nn.1
  asätare_1_N = mkN "asätare" utrum  ; -- asätare..nn.1
  ataktisk_1_A = mkA "ataktisk" ; -- ataktisk..av.1
  ataraktika_1_N = mkN "ataraktika" "ataraktikat" "ataraktika" "ataraktikana" ; -- ataraktika..nn.1
  ataraxi_1_N = mkN "ataraxi" ; -- ataraxi..nn.1
  atavism_1_N = mkN "atavism" "atavismer" ; -- atavism..nn.1
  atavistisk_1_A = mkA "atavistisk" ; -- atavistisk..av.1
  ataxi_1_N = mkN "ataxi" "ataxier" ; -- ataxi..nn.1
  ateism_1_N = mkN "ateism" "ateismer" ; -- ateism..nn.1
  ateist_1_N = mkN "ateist" "ateister" ; -- ateist..nn.1
  ateistisk_1_A = mkA "ateistisk" ; -- ateistisk..av.1
  atelektas_1_N = mkN "atelektas" "atelektaser" ; -- atelektas..nn.1
  ateljé_1_N = mkN "ateljé" "ateljéer" ; -- ateljé..nn.1
  ateljébild_1_N = mkN "ateljébild" "ateljébilder" ; -- ateljébild..nn.1
  ateljéfönster_1_N = mkN "ateljéfönster" neutrum  ; -- ateljéfönster..nn.1
  ateljévåning_1_N = mkN "ateljévåning" ; -- ateljévåning..nn.1
  atenienn_1_N = mkN "atenienn" "atenienner" ; -- atenienn..nn.1
  atensk_1_A = mkA "atensk" ; -- atensk..av.1
  aterogenes_1_N = mkN "aterogenes" ; -- aterogenes..nn.1
  aterom_1_N = mkN "aterom" neutrum  ; -- aterom..nn.1
  ateroskleros_1_N = mkN "ateroskleros" "ateroskleroser" ; -- ateroskleros..nn.1
  atetos_1_N = mkN "atetos" ; -- atetos..nn.1
  atlantisk_1_A = mkA "atlantisk" ; -- atlantisk..av.1
  atlantångare_1_N = mkN "atlantångare" utrum  ; -- atlantångare..nn.1
  atlas_1_N = mkN "atlas" "atlaser" ; -- atlas..nn.1
  atlas_2_N = mkN "atlas" ; -- atlas..nn.2
  atlasbindning_1_N = mkN "atlasbindning" ; -- atlasbindning..nn.1
  atlaskota_1_N = mkN "atlaskota" ; -- atlaskota..nn.1
  atlasspinnare_1_N = mkN "atlasspinnare" utrum  ; -- atlasspinnare..nn.1
  atlet_1_N = mkN "atlet" "atleter" ; -- atlet..nn.1
  atletisk_1_A = mkA "atletisk" ; -- atletisk..av.1
  atletklubb_1_N = mkN "atletklubb" ; -- atletklubb..nn.1
  atmosfär_1_N = mkN "atmosfär" "atmosfärer" ; -- atmosfär..nn.1
  atmosfärforskare_1_N = mkN "atmosfärforskare" utrum  ; -- atmosfärforskare..nn.1
  atmosfärisk_1_A = mkA "atmosfärisk" ; -- atmosfärisk..av.1
  atmosfärkemist_1_N = mkN "atmosfärkemist" "atmosfärkemister" ; -- atmosfärkemist..nn.1
  atmosfärsförhållande_1_N = mkN "atmosfärsförhållande" ; -- atmosfärsförhållande..nn.1
  atmosfärslager_1_N = mkN "atmosfärslager" neutrum  ; -- atmosfärslager..nn.1
  atmosfärstryck_1_N = mkN "atmosfärstryck" neutrum  ; -- atmosfärstryck..nn.1
  atmosfärtryck_1_N = mkN "atmosfärtryck" neutrum  ; -- atmosfärtryck..nn.1
  atoll_1_N = mkN "atoll" "atoller" ; -- atoll..nn.1
  atom_1_N = mkN "atom" "atomer" ; -- atom..nn.1
  atombomb_1_N = mkN "atombomb" "atombomber" ; -- atombomb..nn.1
  atombomba_1_V = mkV "atombombar" ; -- atombomba..vb.1
  atombombande_1_N = mkN "atombombande" ; -- atombombande..nn.1
  atombombsfällning_1_N = mkN "atombombsfällning" ; -- atombombsfällning..nn.1
  atombombsöverlevande_1_A = mkA "atombombsöverlevande" ; -- atombombsöverlevande..av.1
  atombrygga_1_N = mkN "atombrygga" ; -- atombrygga..nn.1
  atomdriven_1_A = mkA "atomdriven" ; -- atomdriven..av.1
  atomenergi_1_N = mkN "atomenergi" ; -- atomenergi..nn.1
  atomenergiorgan_1_N = mkN "atomenergiorgan" neutrum  ; -- atomenergiorgan..nn.1
  atomenergiorganisation_1_N = mkN "atomenergiorganisation" ; -- atomenergiorganisation..nn.1
  atomfysik_1_N = mkN "atomfysik" ; -- atomfysik..nn.1
  atomgrupp_1_N = mkN "atomgrupp" "atomgrupper" ; -- atomgrupp..nn.1
  atomism_1_N = mkN "atomism" "atomismer" ; -- atomism..nn.1
  atomistisk_1_A = mkA "atomistisk" ; -- atomistisk..av.1
  atomjon_1_N = mkN "atomjon" "atomjoner" ; -- atomjon..nn.1
  atomklocka_1_N = mkN "atomklocka" ; -- atomklocka..nn.1
  atomkraft_1_N = mkN "atomkraft" ; -- atomkraft..nn.1
  atomkraftmikroskop_1_N = mkN "atomkraftmikroskop" neutrum  ; -- atomkraftmikroskop..nn.1
  atomkraftsutbyggnad_1_N = mkN "atomkraftsutbyggnad" "atomkraftsutbyggnader" ; -- atomkraftsutbyggnad..nn.1
  atomkärna_1_N = mkN "atomkärna" ; -- atomkärna..nn.1
  atomlära_1_N = mkN "atomlära" ; -- atomlära..nn.1
  atommassa_1_N = mkN "atommassa" ; -- atommassa..nn.1
  atommodell_1_N = mkN "atommodell" "atommodeller" ; -- atommodell..nn.1
  atomnummer_1_N = mkN "atomnummer" neutrum  ; -- atomnummer..nn.1
  atomreaktor_1_N = mkN "atomreaktor" "atomreaktorer" ; -- atomreaktor..nn.1
  atomspektrum_1_N = mkN "atomspektrum" neutrum  ; -- atomspektrum..nn.1
  atomteori_1_N = mkN "atomteori" "atomteorier" ; -- atomteori..nn.1
  atomubåt_1_N = mkN "atomubåt" ; -- atomubåt..nn.1
  atomur_1_N = mkN "atomur" neutrum  ; -- atomur..nn.1
  atomvapen_1_N = mkN "atomvapen" "atomvapnet" "atomvapen" "atomvapnen" ; -- atomvapen..nn.1
  atomvikt_1_N = mkN "atomvikt" "atomvikter" ; -- atomvikt..nn.1
  atomvinter_1_N = mkN "atomvinter" ; -- atomvinter..nn.1
  atomär_1_A = mkA "atomär" ; -- atomär..av.1
  atonal_1_A = mkA "atonal" ; -- atonal..av.1
  atoni_1_N = mkN "atoni" "atonier" ; -- atoni..nn.1
  atopi_1_N = mkN "atopi" "atopier" ; -- atopi..nn.1
  atrieflimmer_1_N = mkN "atrieflimmer" neutrum  ; -- atrieflimmer..nn.1
  atrium_1_N = mkN "atrium" "atriet" "atrier" "atrierna" ; -- atrium..nn.1
  atrofi_1_N = mkN "atrofi" "atrofier" ; -- atrofi..nn.1
  atrofiera_1_V = mkV "atrofierar" ; -- atrofiera..vb.1
  atrofierande_1_N = mkN "atrofierande" ; -- atrofierande..nn.1
  atrofierbar_1_A = mkA "atrofierbar" ; -- atrofierbar..av.1
  atrofierbarhet_1_N = mkN "atrofierbarhet" ; -- atrofierbarhet..nn.1
  atrofiering_1_N = mkN "atrofiering" ; -- atrofiering..nn.1
  atrofisk_1_A = mkA "atrofisk" ; -- atrofisk..av.1
  atropin_1_N = mkN "atropin" ; -- atropin..nn.1
  att_sats_1_N = mkN "att-sats" "att-satser" ; -- att-sats..nn.1
  attaché_1_N = mkN "attaché" "attachéer" ; -- attaché..nn.1
  attachéväska_1_N = mkN "attachéväska" ; -- attachéväska..nn.1
  attack_1_N = mkN "attack" "attacker" ; -- attack..nn.1
  attackdykare_1_N = mkN "attackdykare" utrum  ; -- attackdykare..nn.1
  attackera_1_V = mkV "attackerar" ; -- attackera..vb.1
  attackerande_1_N = mkN "attackerande" ; -- attackerande..nn.1
  attackerbar_1_A = mkA "attackerbar" ; -- attackerbar..av.1
  attackerbarhet_1_N = mkN "attackerbarhet" ; -- attackerbarhet..nn.1
  attackering_1_N = mkN "attackering" ; -- attackering..nn.1
  attackflyg_1_N = mkN "attackflyg" neutrum  ; -- attackflyg..nn.1
  attackflygplan_1_N = mkN "attackflygplan" neutrum  ; -- attackflygplan..nn.1
  attackförmåga_1_N = mkN "attackförmåga" ; -- attackförmåga..nn.1
  attackhelikopter_1_N = mkN "attackhelikopter" ; -- attackhelikopter..nn.1
  attackplan_1_N = mkN "attackplan" neutrum  ; -- attackplan..nn.1
  attacksignal_1_N = mkN "attacksignal" "attacksignaler" ; -- attacksignal..nn.1
  attan_1_N = mkN "attan" ; -- attan..nn.1
  attentat_1_N = mkN "attentat" neutrum  ; -- attentat..nn.1
  attentator_1_N = mkN "attentator" "attentatorer" ; -- attentator..nn.1
  attentatsman_1_N = mkN "attentatsman" "attentatsmannen" "attentatsmän" "attentatsmännen" ; -- attentatsman..nn.1
  attest_1_N = mkN "attest" "attester" ; -- attest..nn.1
  attestera_1_V = mkV "attesterar" ; -- attestera..vb.1
  attesterande_1_N = mkN "attesterande" ; -- attesterande..nn.1
  attesterbar_1_A = mkA "attesterbar" ; -- attesterbar..av.1
  attesterbarhet_1_N = mkN "attesterbarhet" ; -- attesterbarhet..nn.1
  attestering_1_N = mkN "attestering" ; -- attestering..nn.1
  attika_1_N = mkN "attika" ; -- attika..nn.1
  attila_1_N = mkN "attila" ; -- attila..nn.1
  attiralj_1_N = mkN "attiralj" "attiraljer" ; -- attiralj..nn.1
  attisk_1_A = mkA "attisk" ; -- attisk..av.1
  attityd_1_N = mkN "attityd" "attityder" ; -- attityd..nn.1
  attitydförändring_1_N = mkN "attitydförändring" ; -- attitydförändring..nn.1
  attitydmässig_1_A = mkA "attitydmässig" ; -- attitydmässig..av.1
  attitydundersökning_1_N = mkN "attitydundersökning" ; -- attitydundersökning..nn.1
  attrahera_1_V = mkV "attraherar" ; -- attrahera..vb.1
  attraherande_1_N = mkN "attraherande" ; -- attraherande..nn.1
  attraherbar_1_A = mkA "attraherbar" ; -- attraherbar..av.1
  attraherbarhet_1_N = mkN "attraherbarhet" ; -- attraherbarhet..nn.1
  attrahering_1_N = mkN "attrahering" ; -- attrahering..nn.1
  attraktion_1_N = mkN "attraktion" ; -- attraktion..nn.1
  attraktionskraft_1_N = mkN "attraktionskraft" "attraktionskrafter" ; -- attraktionskraft..nn.1
  attraktionslag_1_N = mkN "attraktionslag" ; -- attraktionslag..nn.1
  attraktiv_1_A = mkA "attraktiv" ; -- attraktiv..av.1
  attraktivitet_1_N = mkN "attraktivitet" ; -- attraktivitet..nn.1
  attrapp_1_N = mkN "attrapp" "attrapper" ; -- attrapp..nn.1
  attrappera_1_V = mkV "attrapperar" ; -- attrappera..vb.1
  attrapperande_1_N = mkN "attrapperande" ; -- attrapperande..nn.1
  attrapperbar_1_A = mkA "attrapperbar" ; -- attrapperbar..av.1
  attrapperbarhet_1_N = mkN "attrapperbarhet" ; -- attrapperbarhet..nn.1
  attrappering_1_N = mkN "attrappering" ; -- attrappering..nn.1
  attribuera_1_V = mkV "attribuerar" ; -- attribuera..vb.1
  attribuerande_1_N = mkN "attribuerande" ; -- attribuerande..nn.1
  attribuerbar_1_A = mkA "attribuerbar" ; -- attribuerbar..av.1
  attribuerbarhet_1_N = mkN "attribuerbarhet" ; -- attribuerbarhet..nn.1
  attribuering_1_N = mkN "attribuering" ; -- attribuering..nn.1
  attribut_1_N = mkN "attribut" neutrum  ; -- attribut..nn.1
  attribution_1_N = mkN "attribution" ; -- attribution..nn.1
  attributiv_1_A = mkA "attributiv" ; -- attributiv..av.1
  attributsamling_1_N = mkN "attributsamling" ; -- attributsamling..nn.1
  attributsats_1_N = mkN "attributsats" "attributsatser" ; -- attributsats..nn.1
  atypi_1_N = mkN "atypi" "atypier" ; -- atypi..nn.1
  atypisk_1_A = mkA "atypisk" ; -- atypisk..av.1
  au_pair_flicka_1_N = mkN "au-pair-flicka" ; -- au-pair-flicka..nn.1
  au_pair_1_N = mkN "au-pair" "au-pairer" ; -- au-pair..nn.1
  aubergin_1_N = mkN "aubergin" ; -- aubergin..nn.1
  aubergine_1_N = mkN "aubergine" "auberginer" ; -- aubergine..nn.1
  audiens_1_N = mkN "audiens" "audienser" ; -- audiens..nn.1
  audiensdag_1_N = mkN "audiensdag" ; -- audiensdag..nn.1
  audienssal_1_N = mkN "audienssal" ; -- audienssal..nn.1
  audienssökande_1_N = mkN "audienssökande" "audienssökanden" "audienssökanden" "audienssökandena" ; -- audienssökande..nn.1
  audiogram_1_N = mkN "audiogram" "audiogrammet" "audiogram" "audiogrammen" ; -- audiogram..nn.1
  audiologi_1_N = mkN "audiologi" ; -- audiologi..nn.1
  audiometer_1_N = mkN "audiometer" ; -- audiometer..nn.1
  audiovisuell_1_A = mkA "audiovisuell" ; -- audiovisuell..av.1
  audit_1_N = mkN "audit" ; -- audit..nn.1
  auditiv_1_A = mkA "auditiv" ; -- auditiv..av.1
  auditorium_1_N = mkN "auditorium" "auditoriet" "auditorier" "auditorierna" ; -- auditorium..nn.1
  auditör_1_N = mkN "auditör" "auditörer" ; -- auditör..nn.1
  audivisuell_1_A = mkA "audivisuell" ; -- audivisuell..av.1
  auerlampa_1_N = mkN "auerlampa" ; -- auerlampa..nn.1
  auerstrumpa_1_N = mkN "auerstrumpa" ; -- auerstrumpa..nn.1
  augiasstall_1_N = mkN "augiasstall" neutrum  ; -- augiasstall..nn.1
  augment_1_N = mkN "augment" neutrum  ; -- augment..nn.1
  augur_1_N = mkN "augur" "augurer" ; -- augur..nn.1
  augusti_1_N = mkN "augusti" ; -- augusti..nn.1
  augustidag_1_N = mkN "augustidag" ; -- augustidag..nn.1
  augustimånsken_1_N = mkN "augustimånsken" neutrum  ; -- augustimånsken..nn.1
  augustinatt_1_N = mkN "augustinatt" "augustinätter" ; -- augustinatt..nn.1
  augustipäron_1_N = mkN "augustipäron" neutrum  ; -- augustipäron..nn.1
  augustisol_1_N = mkN "augustisol" ; -- augustisol..nn.1
  augustnominerad_1_A = mkA "augustnominerad" ; -- augustnominerad..av.1
  auktion_1_N = mkN "auktion" ; -- auktion..nn.1
  auktionera_1_V = mkV "auktionerar" ; -- auktionera..vb.1
  auktionerande_1_N = mkN "auktionerande" ; -- auktionerande..nn.1
  auktionerare_1_N = mkN "auktionerare" utrum  ; -- auktionerare..nn.1
  auktionerbar_1_A = mkA "auktionerbar" ; -- auktionerbar..av.1
  auktionerbarhet_1_N = mkN "auktionerbarhet" ; -- auktionerbarhet..nn.1
  auktionering_1_N = mkN "auktionering" ; -- auktionering..nn.1
  auktionist_1_N = mkN "auktionist" "auktionister" ; -- auktionist..nn.1
  auktionsbridge_1_N = mkN "auktionsbridge" utrum  ; -- auktionsbridge..nn.1
  auktionsdag_1_N = mkN "auktionsdag" ; -- auktionsdag..nn.1
  auktionsförrättare_1_N = mkN "auktionsförrättare" utrum  ; -- auktionsförrättare..nn.1
  auktionsinrop_1_N = mkN "auktionsinrop" neutrum  ; -- auktionsinrop..nn.1
  auktionskammare_1_N = mkN "auktionskammare" "auktionskammaren" "auktionskammare" "auktionskamrarna" ; -- auktionskammare..nn.1
  auktionsklubba_1_N = mkN "auktionsklubba" ; -- auktionsklubba..nn.1
  auktionsprotokoll_1_N = mkN "auktionsprotokoll" neutrum  ; -- auktionsprotokoll..nn.1
  auktionsutropare_1_N = mkN "auktionsutropare" utrum  ; -- auktionsutropare..nn.1
  auktionsverk_1_N = mkN "auktionsverk" neutrum  ; -- auktionsverk..nn.1
  auktor_1_N = mkN "auktor" "auktorer" ; -- auktor..nn.1
  auktorisation_1_N = mkN "auktorisation" ; -- auktorisation..nn.1
  auktorisera_1_V = mkV "auktoriserar" ; -- auktorisera..vb.1
  auktoriserande_1_N = mkN "auktoriserande" ; -- auktoriserande..nn.1
  auktoriserbar_1_A = mkA "auktoriserbar" ; -- auktoriserbar..av.1
  auktoriserbarhet_1_N = mkN "auktoriserbarhet" ; -- auktoriserbarhet..nn.1
  auktorisering_1_N = mkN "auktorisering" ; -- auktorisering..nn.1
  auktoritativ_1_A = mkA "auktoritativ" ; -- auktoritativ..av.1
  auktoritet_1_N = mkN "auktoritet" "auktoriteter" ; -- auktoritet..nn.1
  auktoritetsbunden_1_A = mkA "auktoritetsbunden" ; -- auktoritetsbunden..av.1
  auktoritetsbundenhet_1_N = mkN "auktoritetsbundenhet" ; -- auktoritetsbundenhet..nn.1
  auktoritetstro_1_N = mkN "auktoritetstro" ; -- auktoritetstro..nn.1
  auktoritär_1_A = mkA "auktoritär" ; -- auktoritär..av.1
  auktorrätt_1_N = mkN "auktorrätt" ; -- auktorrätt..nn.1
  auktorskap_1_N = mkN "auktorskap" neutrum  ; -- auktorskap..nn.1
  auktorsrätt_1_N = mkN "auktorsrätt" ; -- auktorsrätt..nn.1
  aula_1_N = mkN "aula" ; -- aula..nn.1
  aura_1_N = mkN "aura" ; -- aura..nn.1
  auramigrän_1_N = mkN "auramigrän" "auramigräner" ; -- auramigrän..nn.1
  auskultant_1_N = mkN "auskultant" "auskultanter" ; -- auskultant..nn.1
  auskultation_1_N = mkN "auskultation" ; -- auskultation..nn.1
  auskultera_1_V = mkV "auskulterar" ; -- auskultera..vb.1
  auskulterande_1_N = mkN "auskulterande" ; -- auskulterande..nn.1
  auskulterbar_1_A = mkA "auskulterbar" ; -- auskulterbar..av.1
  auskulterbarhet_1_N = mkN "auskulterbarhet" ; -- auskulterbarhet..nn.1
  auskultering_1_N = mkN "auskultering" ; -- auskultering..nn.1
  australiensare_1_N = mkN "australiensare" utrum  ; -- australiensare..nn.1
  australiensisk_1_A = mkA "australiensisk" ; -- australiensisk..av.1
  australier_1_N = mkN "australier" "australiern" "australier" "australierna" ; -- australier..nn.1
  australisk_1_A = mkA "australisk" ; -- australisk..av.1
  australiska_1_N = mkN "australiska" ; -- australiska..nn.1
  autarki_1_N = mkN "autarki" "autarkier" ; -- autarki..nn.1
  autencitet_1_N = mkN "autencitet" "autenciteter" ; -- autencitet..nn.1
  autenticera_1_V = mkV "autenticerar" ; -- autenticera..vb.1
  autenticerande_1_N = mkN "autenticerande" ; -- autenticerande..nn.1
  autenticerbar_1_A = mkA "autenticerbar" ; -- autenticerbar..av.1
  autenticerbarhet_1_N = mkN "autenticerbarhet" ; -- autenticerbarhet..nn.1
  autenticering_1_N = mkN "autenticering" ; -- autenticering..nn.1
  autenticitet_1_N = mkN "autenticitet" "autenticiteter" ; -- autenticitet..nn.1
  autentifiera_1_V = mkV "autentifierar" ; -- autentifiera..vb.1
  autentifierande_1_N = mkN "autentifierande" ; -- autentifierande..nn.1
  autentifierbar_1_A = mkA "autentifierbar" ; -- autentifierbar..av.1
  autentifierbarhet_1_N = mkN "autentifierbarhet" ; -- autentifierbarhet..nn.1
  autentifiering_1_N = mkN "autentifiering" ; -- autentifiering..nn.1
  autentisera_1_V = mkV "autentiserar" ; -- autentisera..vb.1
  autentiserande_1_N = mkN "autentiserande" ; -- autentiserande..nn.1
  autentiserbar_1_A = mkA "autentiserbar" ; -- autentiserbar..av.1
  autentiserbarhet_1_N = mkN "autentiserbarhet" ; -- autentiserbarhet..nn.1
  autentisering_1_N = mkN "autentisering" ; -- autentisering..nn.1
  autentisk_1_A = mkA "autentisk" ; -- autentisk..av.1
  auteur_1_N = mkN "auteur" "auteurer" ; -- auteur..nn.1
  autism_1_N = mkN "autism" "autismer" ; -- autism..nn.1
  autist_1_N = mkN "autist" "autister" ; -- autist..nn.1
  autistisk_1_A = mkA "autistisk" ; -- autistisk..av.1
  auto_PEEP_1_N = mkN "auto-PEEP" ; -- auto-PEEP..nn.1
  autodafé_1_N = mkN "autodafé" "autodaféer" ; -- autodafé..nn.1
  autodidakt_1_N = mkN "autodidakt" "autodidakter" ; -- autodidakt..nn.1
  autodigestion_1_N = mkN "autodigestion" ; -- autodigestion..nn.1
  autodrom_1_N = mkN "autodrom" "autodromer" ; -- autodrom..nn.1
  autograf_1_N = mkN "autograf" "autografer" ; -- autograf..nn.1
  autografjägare_1_N = mkN "autografjägare" utrum  ; -- autografjägare..nn.1
  autografsamling_1_N = mkN "autografsamling" ; -- autografsamling..nn.1
  autoimmun_1_A = mkA "autoimmun" ; -- autoimmun..av.1
  autoklav_1_N = mkN "autoklav" "autoklaver" ; -- autoklav..nn.1
  autokrat_1_N = mkN "autokrat" "autokrater" ; -- autokrat..nn.1
  autokrati_1_N = mkN "autokrati" "autokratier" ; -- autokrati..nn.1
  autokratisk_1_A = mkA "autokratisk" ; -- autokratisk..av.1
  autokton_1_A = mkA "autokton" ; -- autokton..av.1
  autolys_1_N = mkN "autolys" "autolyser" ; -- autolys..nn.1
  automagisk_1_A = mkA "automagisk" ; -- automagisk..av.1
  automat_1_N = mkN "automat" "automater" ; -- automat..nn.1
  automatateori_1_N = mkN "automatateori" ; -- automatateori..nn.1
  automateld_1_N = mkN "automateld" ; -- automateld..nn.1
  automatgevär_1_N = mkN "automatgevär" neutrum  ; -- automatgevär..nn.1
  automatik_1_N = mkN "automatik" ; -- automatik..nn.1
  automation_1_N = mkN "automation" ; -- automation..nn.1
  automatisera_1_V = mkV "automatiserar" ; -- automatisera..vb.1
  automatiserande_1_N = mkN "automatiserande" ; -- automatiserande..nn.1
  automatiserbar_1_A = mkA "automatiserbar" ; -- automatiserbar..av.1
  automatiserbarhet_1_N = mkN "automatiserbarhet" ; -- automatiserbarhet..nn.1
  automatisering_1_N = mkN "automatisering" ; -- automatisering..nn.1
  automatisk_1_A = mkA "automatisk" ; -- automatisk..av.1
  automatkarbin_1_N = mkN "automatkarbin" "automatkarbiner" ; -- automatkarbin..nn.1
  automatsäkring_1_N = mkN "automatsäkring" ; -- automatsäkring..nn.1
  automatteori_1_N = mkN "automatteori" ; -- automatteori..nn.1
  automatuttag_1_N = mkN "automatuttag" neutrum  ; -- automatuttag..nn.1
  automatvapen_1_N = mkN "automatvapen" "automatvapnet" "automatvapen" "automatvapnen" ; -- automatvapen..nn.1
  automobil_1_N = mkN "automobil" "automobiler" ; -- automobil..nn.1
  autonom_1_A = mkA "autonom" ; -- autonom..av.1
  autonomi_1_N = mkN "autonomi" ; -- autonomi..nn.1
  autopilot_1_N = mkN "autopilot" "autopiloter" ; -- autopilot..nn.1
  autopsi_1_N = mkN "autopsi" "autopsier" ; -- autopsi..nn.1
  autostrada_1_N = mkN "autostrada" ; -- autostrada..nn.1
  autotypi_1_N = mkN "autotypi" "autotypier" ; -- autotypi..nn.1
  av_1_A = mkA "av" ; -- av..av.1
  ava_1_N = mkN "ava" ; -- ava..nn.1
  ava_1_V = mkV "avar" ; -- ava..vb.1
  avaktivera_1_V = mkV "avaktiverar" ; -- avaktivera..vb.1
  avaktiverande_1_N = mkN "avaktiverande" ; -- avaktiverande..nn.1
  avaktiverbar_1_A = mkA "avaktiverbar" ; -- avaktiverbar..av.1
  avaktiverbarhet_1_N = mkN "avaktiverbarhet" ; -- avaktiverbarhet..nn.1
  avaktivering_1_N = mkN "avaktivering" ; -- avaktivering..nn.1
  avancemang_1_N = mkN "avancemang" neutrum  ; -- avancemang..nn.1
  avancera_1_V = mkV "avancerar" ; -- avancera..vb.1
  avancerad_1_A = mkA "avancerad" ; -- avancerad..av.1
  avancerande_1_N = mkN "avancerande" ; -- avancerande..nn.1
  avancerbar_1_A = mkA "avancerbar" ; -- avancerbar..av.1
  avancerbarhet_1_N = mkN "avancerbarhet" ; -- avancerbarhet..nn.1
  avancering_1_N = mkN "avancering" ; -- avancering..nn.1
  avande_1_N = mkN "avande" ; -- avande..nn.1
  avannons_1_N = mkN "avannons" "avannonser" ; -- avannons..nn.1
  avannonsera_1_V = mkV "avannonserar" ; -- avannonsera..vb.1
  avannonserande_1_N = mkN "avannonserande" ; -- avannonserande..nn.1
  avannonserbar_1_A = mkA "avannonserbar" ; -- avannonserbar..av.1
  avannonserbarhet_1_N = mkN "avannonserbarhet" ; -- avannonserbarhet..nn.1
  avannonsering_1_N = mkN "avannonsering" ; -- avannonsering..nn.1
  avans_1_N = mkN "avans" "avanser" ; -- avans..nn.1
  avantgarde_1_N = mkN "avantgarde" ; -- avantgarde..nn.1
  avantgardism_1_N = mkN "avantgardism" "avantgardismer" ; -- avantgardism..nn.1
  avantgardist_1_N = mkN "avantgardist" "avantgardister" ; -- avantgardist..nn.1
  avantgardistisk_1_A = mkA "avantgardistisk" ; -- avantgardistisk..av.1
  avantloge_1_N = mkN "avantloge" "avantloger" ; -- avantloge..nn.1
  avantscen_1_N = mkN "avantscen" "avantscener" ; -- avantscen..nn.1
  avart_1_N = mkN "avart" "avarter" ; -- avart..nn.1
  avatar_1_N = mkN "avatar" "avatarer" ; -- avatar..nn.1
  avbalka_1_V = mkV "avbalkar" ; -- avbalka..vb.1
  avbalkande_1_N = mkN "avbalkande" ; -- avbalkande..nn.1
  avbalkning_1_N = mkN "avbalkning" ; -- avbalkning..nn.1
  avbarka_1_V = mkV "avbarkar" ; -- avbarka..vb.1
  avbarkning_1_N = mkN "avbarkning" ; -- avbarkning..nn.1
  avbasning_1_N = mkN "avbasning" ; -- avbasning..nn.1
  avbeställa_1_V = mkV "avbeställer" ; -- avbeställa..vb.1
  avbeställande_1_N = mkN "avbeställande" ; -- avbeställande..nn.1
  avbeställning_1_N = mkN "avbeställning" ; -- avbeställning..nn.1
  avbeta_1_V = mkV "avbetar" ; -- avbeta..vb.1
  avbetala_1_V = mkV "avbetalar" ; -- avbetala..vb.1
  avbetalande_1_N = mkN "avbetalande" ; -- avbetalande..nn.1
  avbetalning_1_N = mkN "avbetalning" ; -- avbetalning..nn.1
  avbetalningsaffär_1_N = mkN "avbetalningsaffär" "avbetalningsaffärer" ; -- avbetalningsaffär..nn.1
  avbetalningsarrangemang_1_N = mkN "avbetalningsarrangemang" neutrum  ; -- avbetalningsarrangemang..nn.1
  avbetalningsköp_1_N = mkN "avbetalningsköp" neutrum  ; -- avbetalningsköp..nn.1
  avbetalningslån_1_N = mkN "avbetalningslån" neutrum  ; -- avbetalningslån..nn.1
  avbetalningsplan_1_N = mkN "avbetalningsplan" "avbetalningsplaner" ; -- avbetalningsplan..nn.1
  avbetalningsvillkor_1_N = mkN "avbetalningsvillkor" neutrum  ; -- avbetalningsvillkor..nn.1
  avbetande_1_N = mkN "avbetande" ; -- avbetande..nn.1
  avbetingning_1_N = mkN "avbetingning" ; -- avbetingning..nn.1
  avbetning_1_N = mkN "avbetning" ; -- avbetning..nn.1
  avbetsling_1_N = mkN "avbetsling" ; -- avbetsling..nn.1
  avbild_1_N = mkN "avbild" "avbilder" ; -- avbild..nn.1
  avbilda_1_V = mkV "avbildar" ; -- avbilda..vb.1
  avbildande_1_N = mkN "avbildande" ; -- avbildande..nn.1
  avbildning_1_N = mkN "avbildning" ; -- avbildning..nn.1
  avbildningsfel_1_N = mkN "avbildningsfel" "avbildningsfelet" "avbildningsfel" "avbildningsfelen" ; -- avbildningsfel..nn.1
  avbinda_1_V = mkV "avbinda" "avband" "avbundit" ; -- avbinda..vb.1
  avbindande_1_N = mkN "avbindande" ; -- avbindande..nn.1
  avbindning_1_N = mkN "avbindning" ; -- avbindning..nn.1
  avbitare_1_N = mkN "avbitare" utrum  ; -- avbitare..nn.1
  avbitartång_1_N = mkN "avbitartång" "avbitartänger" ; -- avbitartång..nn.1
  avbiten_1_A = mkA "avbiten" ; -- avbiten..av.1
  avbitning_1_N = mkN "avbitning" ; -- avbitning..nn.1
  avbländning_1_N = mkN "avbländning" ; -- avbländning..nn.1
  avblåsa_1_V = mkV "avblåser" ; -- avblåsa..vb.1
  avblåsande_1_N = mkN "avblåsande" ; -- avblåsande..nn.1
  avblåsning_1_N = mkN "avblåsning" ; -- avblåsning..nn.1
  avboka_1_V = mkV "avbokar" ; -- avboka..vb.1
  avbokande_1_N = mkN "avbokande" ; -- avbokande..nn.1
  avbokning_1_N = mkN "avbokning" ; -- avbokning..nn.1
  avborstning_1_N = mkN "avborstning" ; -- avborstning..nn.1
  avbrott_1_N = mkN "avbrott" neutrum  ; -- avbrott..nn.1
  avbruten_1_A = mkA "avbruten" ; -- avbruten..av.1
  avbryta_1_V = mkV "avbryta" "avbröt" "avbrutit" ; -- avbryta..vb.1
  avbrytande_1_N = mkN "avbrytande" ; -- avbrytande..nn.1
  avbrytare_1_N = mkN "avbrytare" utrum  ; -- avbrytare..nn.1
  avbrytning_1_N = mkN "avbrytning" ; -- avbrytning..nn.1
  avbräck_1_N = mkN "avbräck" neutrum  ; -- avbräck..nn.1
  avbränning_1_N = mkN "avbränning" ; -- avbränning..nn.1
  avbröstning_1_N = mkN "avbröstning" ; -- avbröstning..nn.1
  avbytarbänk_1_N = mkN "avbytarbänk" ; -- avbytarbänk..nn.1
  avbytare_1_N = mkN "avbytare" utrum  ; -- avbytare..nn.1
  avbäring_1_N = mkN "avbäring" ; -- avbäring..nn.1
  avbärning_1_N = mkN "avbärning" ; -- avbärning..nn.1
  avböja_1_V = mkV "avböja" "avböjde" "avböjt" ; -- avböja..vb.1
  avböja_2_V = mkV "avböja" "avböjde" "avböjt" ; -- avböja..vb.2
  avböjande_1_N = mkN "avböjande" ; -- avböjande..nn.1
  avböjning_1_N = mkN "avböjning" ; -- avböjning..nn.1
  avbön_1_N = mkN "avbön" "avböner" ; -- avbön..nn.1
  avbörda_1_V = mkV "avbördar" ; -- avbörda..vb.1
  avbördande_1_N = mkN "avbördande" ; -- avbördande..nn.1
  avdagata_1_V = mkV "avdagataga" "avdagatog" "avdagatagit" ; -- avdagata..vb.1
  avdagatagande_1_N = mkN "avdagatagande" ; -- avdagatagande..nn.1
  avdamning_1_N = mkN "avdamning" ; -- avdamning..nn.1
  avdankad_1_A = mkA "avdankad" ; -- avdankad..av.1
  avdela_1_V = mkV "avdelar" ; -- avdela..vb.1
  avdelande_1_N = mkN "avdelande" ; -- avdelande..nn.1
  avdelning_1_N = mkN "avdelning" ; -- avdelning..nn.1
  avdelningschef_1_N = mkN "avdelningschef" "avdelningschefer" ; -- avdelningschef..nn.1
  avdelningsdirektör_1_N = mkN "avdelningsdirektör" "avdelningsdirektörer" ; -- avdelningsdirektör..nn.1
  avdelningskontor_1_N = mkN "avdelningskontor" neutrum  ; -- avdelningskontor..nn.1
  avdelningsläkare_1_N = mkN "avdelningsläkare" utrum  ; -- avdelningsläkare..nn.1
  avdelningssköterska_1_N = mkN "avdelningssköterska" ; -- avdelningssköterska..nn.1
  avdelningsvis_1_Adv = mkAdv "avdelningsvis" ; -- avdelningsvis..ab.1
  avdikning_1_N = mkN "avdikning" ; -- avdikning..nn.1
  avdiskning_1_N = mkN "avdiskning" ; -- avdiskning..nn.1
  avdomning_1_N = mkN "avdomning" ; -- avdomning..nn.1
  avdrag_1_N = mkN "avdrag" neutrum  ; -- avdrag..nn.1
  avdragsgill_1_A = mkA "avdragsgill" ; -- avdragsgill..av.1
  avdragsglad_1_A = mkA "avdragsglad" "avdragsglatt" ; -- avdragsglad..av.1
  avdragsmöjlighet_1_N = mkN "avdragsmöjlighet" "avdragsmöjligheter" ; -- avdragsmöjlighet..nn.1
  avdragsrätt_1_N = mkN "avdragsrätt" ; -- avdragsrätt..nn.1
  avdramatisera_1_V = mkV "avdramatiserar" ; -- avdramatisera..vb.1
  avdramatiserande_1_N = mkN "avdramatiserande" ; -- avdramatiserande..nn.1
  avdramatiserbar_1_A = mkA "avdramatiserbar" ; -- avdramatiserbar..av.1
  avdramatiserbarhet_1_N = mkN "avdramatiserbarhet" ; -- avdramatiserbarhet..nn.1
  avdramatisering_1_N = mkN "avdramatisering" ; -- avdramatisering..nn.1
  avdrift_1_N = mkN "avdrift" ; -- avdrift..nn.1
  avdriva_1_V = mkV "avdriva" "avdrev" "avdrivit" ; -- avdriva..vb.1
  avdrivande_1_N = mkN "avdrivande" ; -- avdrivande..nn.1
  avdukning_1_N = mkN "avdukning" ; -- avdukning..nn.1
  avdunsta_1_V = mkV "avdunstar" ; -- avdunsta..vb.1
  avdunstande_1_N = mkN "avdunstande" ; -- avdunstande..nn.1
  avdunstning_1_N = mkN "avdunstning" ; -- avdunstning..nn.1
  avdämma_1_V = mkV "avdämmer" ; -- avdämma..vb.1
  avdämmande_1_N = mkN "avdämmande" ; -- avdämmande..nn.1
  avdämning_1_N = mkN "avdämning" ; -- avdämning..nn.1
  avdöd_1_A = mkA "avdöd" "avdött" ; -- avdöd..av.1
  avdöma_1_V = mkV "avdömer" ; -- avdöma..vb.1
  avdömande_1_N = mkN "avdömande" ; -- avdömande..nn.1
  ave_1_N = mkN "ave" ; -- ave..nn.1
  avec_1_N = mkN "avec" "avecer" ; -- avec..nn.1
  avel_1_N = mkN "avel" ; -- avel..nn.1
  avelsdjur_1_N = mkN "avelsdjur" neutrum  ; -- avelsdjur..nn.1
  avelsduglig_1_A = mkA "avelsduglig" ; -- avelsduglig..av.1
  avelshingst_1_N = mkN "avelshingst" ; -- avelshingst..nn.1
  avelssto_1_N = mkN "avelssto" "avelsstot" "avelsston" "avelsstona" ; -- avelssto..nn.1
  avenbok_1_N = mkN "avenbok" ; -- avenbok..nn.1
  aveny_1_N = mkN "aveny" "avenyer" ; -- aveny..nn.1
  avers_1_N = mkN "avers" "averser" ; -- avers..nn.1
  aversion_1_N = mkN "aversion" ; -- aversion..nn.1
  aversionsterapi_1_N = mkN "aversionsterapi" ; -- aversionsterapi..nn.1
  avfall_1_N = mkN "avfall" neutrum  ; -- avfall..nn.1
  avfalla_1_V = mkV "avfalla" "avföll" "avfallit" ; -- avfalla..vb.1
  avfallande_1_N = mkN "avfallande" ; -- avfallande..nn.1
  avfallen_1_A = mkA "avfallen" ; -- avfallen..av.1
  avfallsbrunn_1_N = mkN "avfallsbrunn" ; -- avfallsbrunn..nn.1
  avfallsdike_1_N = mkN "avfallsdike" ; -- avfallsdike..nn.1
  avfallsfoder_1_N = mkN "avfallsfoder" neutrum  ; -- avfallsfoder..nn.1
  avfallshantering_1_N = mkN "avfallshantering" ; -- avfallshantering..nn.1
  avfallskvarn_1_N = mkN "avfallskvarn" ; -- avfallskvarn..nn.1
  avfallsråvara_1_N = mkN "avfallsråvara" ; -- avfallsråvara..nn.1
  avfallsupplag_1_N = mkN "avfallsupplag" neutrum  ; -- avfallsupplag..nn.1
  avfallsvatten_1_N = mkN "avfallsvatten" "avfallsvattnet" "avfallsvatten" "avfallsvattnen" ; -- avfallsvatten..nn.1
  avfallsvirke_1_N = mkN "avfallsvirke" ; -- avfallsvirke..nn.1
  avfalsning_1_N = mkN "avfalsning" ; -- avfalsning..nn.1
  avfart_1_N = mkN "avfart" "avfarter" ; -- avfart..nn.1
  avfasning_1_N = mkN "avfasning" ; -- avfasning..nn.1
  avfatta_1_V = mkV "avfattar" ; -- avfatta..vb.1
  avfattande_1_N = mkN "avfattande" ; -- avfattande..nn.1
  avfattning_1_N = mkN "avfattning" ; -- avfattning..nn.1
  avfejning_1_N = mkN "avfejning" ; -- avfejning..nn.1
  avfetta_1_V = mkV "avfettar" ; -- avfetta..vb.1
  avfettande_1_N = mkN "avfettande" ; -- avfettande..nn.1
  avfettning_1_N = mkN "avfettning" ; -- avfettning..nn.1
  avfettningsmedel_1_N = mkN "avfettningsmedel" neutrum  ; -- avfettningsmedel..nn.1
  avfilning_1_N = mkN "avfilning" ; -- avfilning..nn.1
  avfiltrering_1_N = mkN "avfiltrering" ; -- avfiltrering..nn.1
  avfjällning_1_N = mkN "avfjällning" ; -- avfjällning..nn.1
  avflagnad_1_A = mkA "avflagnad" ; -- avflagnad..av.1
  avflytta_1_V = mkV "avflyttar" ; -- avflytta..vb.1
  avflyttande_1_N = mkN "avflyttande" ; -- avflyttande..nn.1
  avflyttning_1_N = mkN "avflyttning" ; -- avflyttning..nn.1
  avflyttningsförbud_1_N = mkN "avflyttningsförbud" neutrum  ; -- avflyttningsförbud..nn.1
  avflöde_1_N = mkN "avflöde" ; -- avflöde..nn.1
  avfolka_1_V = mkV "avfolkar" ; -- avfolka..vb.1
  avfolkande_1_N = mkN "avfolkande" ; -- avfolkande..nn.1
  avfolkning_1_N = mkN "avfolkning" ; -- avfolkning..nn.1
  avfolkningsområde_1_N = mkN "avfolkningsområde" ; -- avfolkningsområde..nn.1
  avfordra_1_V = mkV "avfordrar" ; -- avfordra..vb.1
  avfordrande_1_N = mkN "avfordrande" ; -- avfordrande..nn.1
  avforsling_1_N = mkN "avforsling" ; -- avforsling..nn.1
  avfrosta_1_V = mkV "avfrostar" ; -- avfrosta..vb.1
  avfrostande_1_N = mkN "avfrostande" ; -- avfrostande..nn.1
  avfrostning_1_N = mkN "avfrostning" ; -- avfrostning..nn.1
  avfukta_1_V = mkV "avfuktar" ; -- avfukta..vb.1
  avfuktande_1_N = mkN "avfuktande" ; -- avfuktande..nn.1
  avfuktare_1_N = mkN "avfuktare" utrum  ; -- avfuktare..nn.1
  avfyra_1_V = mkV "avfyrar" ; -- avfyra..vb.1
  avfyrande_1_N = mkN "avfyrande" ; -- avfyrande..nn.1
  avfyrning_1_N = mkN "avfyrning" ; -- avfyrning..nn.1
  avfyrningskod_1_N = mkN "avfyrningskod" "avfyrningskoder" ; -- avfyrningskod..nn.1
  avfyrningsprocedur_1_N = mkN "avfyrningsprocedur" "avfyrningsprocedurer" ; -- avfyrningsprocedur..nn.1
  avfällig_1_A = mkA "avfällig" ; -- avfällig..av.1
  avfällighet_1_N = mkN "avfällighet" ; -- avfällighet..nn.1
  avfälling_1_N = mkN "avfälling" ; -- avfälling..nn.1
  avfärd_1_N = mkN "avfärd" "avfärder" ; -- avfärd..nn.1
  avfärda_1_V = mkV "avfärdar" ; -- avfärda..vb.1
  avfärdande_1_N = mkN "avfärdande" ; -- avfärdande..nn.1
  avfärgning_1_N = mkN "avfärgning" ; -- avfärgning..nn.1
  avföda_1_N = mkN "avföda" ; -- avföda..nn.1
  avföra_1_V = mkV "avföra" "avförde" "avfört" ; -- avföra..vb.1
  avförande_1_N = mkN "avförande" ; -- avförande..nn.1
  avföring_1_N = mkN "avföring" ; -- avföring..nn.1
  avföringsinkontinens_1_N = mkN "avföringsinkontinens" ; -- avföringsinkontinens..nn.1
  avföringsmedel_1_N = mkN "avföringsmedel" neutrum  ; -- avföringsmedel..nn.1
  avföringstransplantat_1_N = mkN "avföringstransplantat" neutrum  ; -- avföringstransplantat..nn.1
  avföringstransplantation_1_N = mkN "avföringstransplantation" ; -- avföringstransplantation..nn.1
  avgasförgiftning_1_N = mkN "avgasförgiftning" ; -- avgasförgiftning..nn.1
  avgasrening_1_N = mkN "avgasrening" ; -- avgasrening..nn.1
  avgasrör_1_N = mkN "avgasrör" neutrum  ; -- avgasrör..nn.1
  avge_1_V = mkV "avgiva" "avgav" "avgivit" ; -- avge..vb.1
  avgift_1_N = mkN "avgift" "avgifter" ; -- avgift..nn.1
  avgifta_1_V = mkV "avgiftar" ; -- avgifta..vb.1
  avgiftande_1_N = mkN "avgiftande" ; -- avgiftande..nn.1
  avgiftning_1_N = mkN "avgiftning" ; -- avgiftning..nn.1
  avgiftningsklinik_1_N = mkN "avgiftningsklinik" "avgiftningskliniker" ; -- avgiftningsklinik..nn.1
  avgiftsbelägga_1_V = mkV "avgiftsbelägga" "avgiftsbela" "avgiftsbelagt" ; -- avgiftsbelägga..vb.1
  avgiftsbeläggande_1_N = mkN "avgiftsbeläggande" ; -- avgiftsbeläggande..nn.1
  avgiftsfri_1_A = mkA "avgiftsfri" "avgiftsfritt" ; -- avgiftsfri..av.1
  avgiftsfrihet_1_N = mkN "avgiftsfrihet" ; -- avgiftsfrihet..nn.1
  avgivande_1_N = mkN "avgivande" ; -- avgivande..nn.1
  avgjord_1_A = mkA "avgjord" "avgjort" ; -- avgjord..av.1
  avgjutning_1_N = mkN "avgjutning" ; -- avgjutning..nn.1
  avglans_1_N = mkN "avglans" ; -- avglans..nn.1
  avgnagning_1_N = mkN "avgnagning" ; -- avgnagning..nn.1
  avgnuggning_1_N = mkN "avgnuggning" ; -- avgnuggning..nn.1
  avgrena_1_V = mkV "avgrenar" ; -- avgrena..vb.1
  avgrenande_1_N = mkN "avgrenande" ; -- avgrenande..nn.1
  avgrening_1_N = mkN "avgrening" ; -- avgrening..nn.1
  avgrund_1_N = mkN "avgrund" "avgrunder" ; -- avgrund..nn.1
  avgrundsande_1_N = mkN "avgrundsande" utrum  ; -- avgrundsande..nn.1
  avgrundsdjup_1_A = mkA "avgrundsdjup" ; -- avgrundsdjup..av.1
  avgrundsdjup_1_N = mkN "avgrundsdjup" neutrum  ; -- avgrundsdjup..nn.1
  avgrundseld_1_N = mkN "avgrundseld" ; -- avgrundseld..nn.1
  avgrundslik_1_A = mkA "avgrundslik" ; -- avgrundslik..av.1
  avgrundsrand_1_N = mkN "avgrundsrand" ; -- avgrundsrand..nn.1
  avgrundsskara_1_N = mkN "avgrundsskara" ; -- avgrundsskara..nn.1
  avgränsa_1_V = mkV "avgränsar" ; -- avgränsa..vb.1
  avgränsande_1_N = mkN "avgränsande" ; -- avgränsande..nn.1
  avgränsning_1_N = mkN "avgränsning" ; -- avgränsning..nn.1
  avgud_1_N = mkN "avgud" ; -- avgud..nn.1
  avguda_1_V = mkV "avgudar" ; -- avguda..vb.1
  avgudabild_1_N = mkN "avgudabild" "avgudabilder" ; -- avgudabild..nn.1
  avgudadyrkare_1_N = mkN "avgudadyrkare" utrum  ; -- avgudadyrkare..nn.1
  avgudande_1_N = mkN "avgudande" ; -- avgudande..nn.1
  avguderi_1_N = mkN "avguderi" neutrum  ; -- avguderi..nn.1
  avgäld_1_N = mkN "avgäld" "avgälder" ; -- avgäld..nn.1
  avgärda_1_V = mkV "avgärdar" ; -- avgärda..vb.1
  avgärdande_1_N = mkN "avgärdande" ; -- avgärdande..nn.1
  avgärdning_1_N = mkN "avgärdning" ; -- avgärdning..nn.1
  avgå_1_V = mkV "avgå" "avgår" "avgå" "avgick" "avgått" "avgången" ; -- avgå..vb.1
  avgående_1_N = mkN "avgående" ; -- avgående..nn.1
  avgång_1_N = mkN "avgång" ; -- avgång..nn.1
  avgångsbetyg_1_N = mkN "avgångsbetyg" neutrum  ; -- avgångsbetyg..nn.1
  avgångsbidrag_1_N = mkN "avgångsbidrag" neutrum  ; -- avgångsbidrag..nn.1
  avgångsersättning_1_N = mkN "avgångsersättning" ; -- avgångsersättning..nn.1
  avgångshall_1_N = mkN "avgångshall" ; -- avgångshall..nn.1
  avgångsklass_1_N = mkN "avgångsklass" "avgångsklasser" ; -- avgångsklass..nn.1
  avgångskrav_1_N = mkN "avgångskrav" neutrum  ; -- avgångskrav..nn.1
  avgångssignal_1_N = mkN "avgångssignal" "avgångssignaler" ; -- avgångssignal..nn.1
  avgångstid_1_N = mkN "avgångstid" "avgångstider" ; -- avgångstid..nn.1
  avgångsvederlag_1_N = mkN "avgångsvederlag" neutrum  ; -- avgångsvederlag..nn.1
  avgöra_1_V = mkV "avgöra" "avgjorde" "avgjort" ; -- avgöra..vb.1
  avgörande_1_A = mkA "avgörande" ; -- avgörande..av.1
  avgörande_1_N = mkN "avgörande" ; -- avgörande..nn.1
  avhackning_1_N = mkN "avhackning" ; -- avhackning..nn.1
  avhakning_1_N = mkN "avhakning" ; -- avhakning..nn.1
  avhandla_1_V = mkV "avhandlar" ; -- avhandla..vb.1
  avhandlande_1_N = mkN "avhandlande" ; -- avhandlande..nn.1
  avhandling_1_N = mkN "avhandling" ; -- avhandling..nn.1
  avhaspling_1_N = mkN "avhaspling" ; -- avhaspling..nn.1
  avhjälpa_1_V = mkV "avhjälper" ; -- avhjälpa..vb.1
  avhjälpande_1_N = mkN "avhjälpande" ; -- avhjälpande..nn.1
  avhopp_1_N = mkN "avhopp" neutrum  ; -- avhopp..nn.1
  avhoppad_1_A = mkA "avhoppad" ; -- avhoppad..av.1
  avhoppare_1_N = mkN "avhoppare" utrum  ; -- avhoppare..nn.1
  avhorna_1_V = mkV "avhornar" ; -- avhorna..vb.1
  avhornande_1_N = mkN "avhornande" ; -- avhornande..nn.1
  avhorning_1_N = mkN "avhorning" ; -- avhorning..nn.1
  avhuggning_1_N = mkN "avhuggning" ; -- avhuggning..nn.1
  avhumanisera_1_V = mkV "avhumaniserar" ; -- avhumanisera..vb.1
  avhumaniserande_1_N = mkN "avhumaniserande" ; -- avhumaniserande..nn.1
  avhumanisering_1_N = mkN "avhumanisering" ; -- avhumanisering..nn.1
  avhysa_1_V = mkV "avhyser" ; -- avhysa..vb.1
  avhysande_1_N = mkN "avhysande" ; -- avhysande..nn.1
  avhysning_1_N = mkN "avhysning" ; -- avhysning..nn.1
  avhyvling_1_N = mkN "avhyvling" ; -- avhyvling..nn.1
  avhäktning_1_N = mkN "avhäktning" ; -- avhäktning..nn.1
  avhällning_1_N = mkN "avhällning" ; -- avhällning..nn.1
  avhällningsöppning_1_N = mkN "avhällningsöppning" ; -- avhällningsöppning..nn.1
  avhämta_1_V = mkV "avhämtar" ; -- avhämta..vb.1
  avhämtande_1_N = mkN "avhämtande" ; -- avhämtande..nn.1
  avhämtning_1_N = mkN "avhämtning" ; -- avhämtning..nn.1
  avhända_1_V = mkV "avhänder" ; -- avhända..vb.1
  avhändande_1_N = mkN "avhändande" ; -- avhändande..nn.1
  avhändbar_1_A = mkA "avhändbar" ; -- avhändbar..av.1
  avhändbarhet_1_N = mkN "avhändbarhet" ; -- avhändbarhet..nn.1
  avhänga_1_V = mkV "avhänger" ; -- avhänga..vb.1
  avhängande_1_N = mkN "avhängande" ; -- avhängande..nn.1
  avhängd_1_A = mkA "avhängd" "avhängt" ; -- avhängd..av.1
  avhängig_1_A = mkA "avhängig" ; -- avhängig..av.1
  avhängighet_1_N = mkN "avhängighet" ; -- avhängighet..nn.1
  avhärda_1_V = mkV "avhärdar" ; -- avhärda..vb.1
  avhärdande_1_N = mkN "avhärdande" ; -- avhärdande..nn.1
  avhästning_1_N = mkN "avhästning" ; -- avhästning..nn.1
  avhåll_1_N = mkN "avhåll" neutrum  ; -- avhåll..nn.1
  avhålla_1_V = mkV "avhålla" "avhöll" "avhållit" ; -- avhålla..vb.1
  avhållande_1_N = mkN "avhållande" ; -- avhållande..nn.1
  avhållen_1_A = mkA "avhållen" ; -- avhållen..av.1
  avhållsam_1_A = mkA "avhållsam" "avhållsamt" "avhållsamma" "avhållsamma" "avhållsammare" "avhållsammast" "avhållsammaste" ; -- avhållsam..av.1
  avhållsamhet_1_N = mkN "avhållsamhet" ; -- avhållsamhet..nn.1
  avhöra_1_V = mkV "avhöra" "avhörde" "avhört" ; -- avhöra..vb.1
  avhörande_1_N = mkN "avhörande" ; -- avhörande..nn.1
  avhösta_1_V = mkV "avhöstar" ; -- avhösta..vb.1
  avhöstande_1_N = mkN "avhöstande" ; -- avhöstande..nn.1
  avi_1_N = mkN "avi" "avier" ; -- avi..nn.1
  aviarium_1_N = mkN "aviarium" "aviariet" "aviarier" "aviarierna" ; -- aviarium..nn.1
  aviatik_1_N = mkN "aviatik" ; -- aviatik..nn.1
  aviatiker_1_N = mkN "aviatiker" "aviatikern" "aviatiker" "aviatikerna" ; -- aviatiker..nn.1
  aviatisk_1_A = mkA "aviatisk" ; -- aviatisk..av.1
  aviatör_1_N = mkN "aviatör" "aviatörer" ; -- aviatör..nn.1
  avig_1_A = mkA "avig" ; -- avig..av.1
  aviga_1_N = mkN "aviga" ; -- aviga..nn.1
  avigsida_1_N = mkN "avigsida" ; -- avigsida..nn.1
  avindividualisera_1_V = mkV "avindividualiserar" ; -- avindividualisera..vb.1
  avindividualiserande_1_N = mkN "avindividualiserande" ; -- avindividualiserande..nn.1
  avindividualisering_1_N = mkN "avindividualisering" ; -- avindividualisering..nn.1
  avinstallera_1_V = mkV "avinstallerar" ; -- avinstallera..vb.1
  avinstallerande_1_N = mkN "avinstallerande" ; -- avinstallerande..nn.1
  avinstallerbar_1_A = mkA "avinstallerbar" ; -- avinstallerbar..av.1
  avinstallering_1_N = mkN "avinstallering" ; -- avinstallering..nn.1
  avintellektualisera_1_V = mkV "avintellektualiserar" ; -- avintellektualisera..vb.1
  avintellektualiserande_1_N = mkN "avintellektualiserande" ; -- avintellektualiserande..nn.1
  avintellektualiserbar_1_A = mkA "avintellektualiserbar" ; -- avintellektualiserbar..av.1
  avintellektualisering_1_N = mkN "avintellektualisering" ; -- avintellektualisering..nn.1
  avis_1_N = mkN "avis" "aviser" ; -- avis..nn.1
  avisa_1_N = mkN "avisa" ; -- avisa..nn.1
  avisa_1_V = mkV "avisar" ; -- avisa..vb.1
  avisande_1_N = mkN "avisande" ; -- avisande..nn.1
  avisera_1_V = mkV "aviserar" ; -- avisera..vb.1
  aviserande_1_N = mkN "aviserande" ; -- aviserande..nn.1
  aviserbar_1_A = mkA "aviserbar" ; -- aviserbar..av.1
  aviserbarhet_1_N = mkN "aviserbarhet" ; -- aviserbarhet..nn.1
  avisering_1_N = mkN "avisering" ; -- avisering..nn.1
  aviseringsperiod_1_N = mkN "aviseringsperiod" "aviseringsperioder" ; -- aviseringsperiod..nn.1
  avisning_1_N = mkN "avisning" ; -- avisning..nn.1
  avisningsanläggning_1_N = mkN "avisningsanläggning" ; -- avisningsanläggning..nn.1
  avisofartyg_1_N = mkN "avisofartyg" neutrum  ; -- avisofartyg..nn.1
  avitaminos_1_N = mkN "avitaminos" "avitaminoser" ; -- avitaminos..nn.1
  avjaga_1_V = mkV "avjagar" ; -- avjaga..vb.1
  avjagande_1_N = mkN "avjagande" ; -- avjagande..nn.1
  avjämna_1_V = mkV "avjämnar" ; -- avjämna..vb.1
  avjämnande_1_N = mkN "avjämnande" ; -- avjämnande..nn.1
  avjämning_1_N = mkN "avjämning" ; -- avjämning..nn.1
  avkalka_1_V = mkV "avkalkar" ; -- avkalka..vb.1
  avkalkande_1_N = mkN "avkalkande" ; -- avkalkande..nn.1
  avkapning_1_N = mkN "avkapning" ; -- avkapning..nn.1
  avkasta_1_V = mkV "avkastar" ; -- avkasta..vb.1
  avkastande_1_N = mkN "avkastande" ; -- avkastande..nn.1
  avkastning_1_N = mkN "avkastning" ; -- avkastning..nn.1
  avkastningskrav_1_N = mkN "avkastningskrav" neutrum  ; -- avkastningskrav..nn.1
  avklappning_1_N = mkN "avklappning" ; -- avklappning..nn.1
  avklara_1_V = mkV "avklarar" ; -- avklara..vb.1
  avklara_2_V = mkV "avklarar" ; -- avklara..vb.2
  avklarande_1_N = mkN "avklarande" ; -- avklarande..nn.1
  avklarnad_1_A = mkA "avklarnad" ; -- avklarnad..av.1
  avklinga_1_V = mkV "avklingar" ; -- avklinga..vb.1
  avklingande_1_N = mkN "avklingande" ; -- avklingande..nn.1
  avklippning_1_N = mkN "avklippning" ; -- avklippning..nn.1
  avklä_1_V = mkV "avklä" "avklädde" "avklätt" ; -- avklä..vb.1
  avklädande_1_N = mkN "avklädande" ; -- avklädande..nn.1
  avklädning_1_N = mkN "avklädning" ; -- avklädning..nn.1
  avknackning_1_N = mkN "avknackning" ; -- avknackning..nn.1
  avknipning_1_N = mkN "avknipning" ; -- avknipning..nn.1
  avknoppa_1_V = mkV "avknoppar" ; -- avknoppa..vb.1
  avknoppande_1_N = mkN "avknoppande" ; -- avknoppande..nn.1
  avknoppning_1_N = mkN "avknoppning" ; -- avknoppning..nn.1
  avknoppningsföretag_1_N = mkN "avknoppningsföretag" neutrum  ; -- avknoppningsföretag..nn.1
  avknäppning_1_N = mkN "avknäppning" ; -- avknäppning..nn.1
  avkoda_1_V = mkV "avkodar" ; -- avkoda..vb.1
  avkok_1_N = mkN "avkok" neutrum  ; -- avkok..nn.1
  avkokning_1_N = mkN "avkokning" ; -- avkokning..nn.1
  avkolonisera_1_V = mkV "avkoloniserar" ; -- avkolonisera..vb.1
  avkoloniserande_1_N = mkN "avkoloniserande" ; -- avkoloniserande..nn.1
  avkoloniserbar_1_A = mkA "avkoloniserbar" ; -- avkoloniserbar..av.1
  avkoloniserbarhet_1_N = mkN "avkoloniserbarhet" ; -- avkoloniserbarhet..nn.1
  avkolonisering_1_N = mkN "avkolonisering" ; -- avkolonisering..nn.1
  avkomling_1_N = mkN "avkomling" ; -- avkomling..nn.1
  avkomma_1_N = mkN "avkomma" ; -- avkomma..nn.1
  avkomst_1_N = mkN "avkomst" ; -- avkomst..nn.1
  avkomsträtt_1_N = mkN "avkomsträtt" ; -- avkomsträtt..nn.1
  avkoppla_1_V = mkV "avkopplar" ; -- avkoppla..vb.1
  avkopplande_1_N = mkN "avkopplande" ; -- avkopplande..nn.1
  avkoppling_1_N = mkN "avkoppling" ; -- avkoppling..nn.1
  avkorta_1_V = mkV "avkortar" ; -- avkorta..vb.1
  avkortande_1_N = mkN "avkortande" ; -- avkortande..nn.1
  avkortning_1_N = mkN "avkortning" ; -- avkortning..nn.1
  avkrattning_1_N = mkN "avkrattning" ; -- avkrattning..nn.1
  avkriminalisera_1_V = mkV "avkriminaliserar" ; -- avkriminalisera..vb.1
  avkriminaliserande_1_N = mkN "avkriminaliserande" ; -- avkriminaliserande..nn.1
  avkriminaliserbar_1_A = mkA "avkriminaliserbar" ; -- avkriminaliserbar..av.1
  avkriminaliserbarhet_1_N = mkN "avkriminaliserbarhet" ; -- avkriminaliserbarhet..nn.1
  avkriminalisering_1_N = mkN "avkriminalisering" ; -- avkriminalisering..nn.1
  avkristna_1_V = mkV "avkristnar" ; -- avkristna..vb.1
  avkristnande_1_N = mkN "avkristnande" ; -- avkristnande..nn.1
  avkristning_1_N = mkN "avkristning" ; -- avkristning..nn.1
  avkrok_1_N = mkN "avkrok" ; -- avkrok..nn.1
  avkrokning_1_N = mkN "avkrokning" ; -- avkrokning..nn.1
  avkrängning_1_N = mkN "avkrängning" ; -- avkrängning..nn.1
  avkräva_1_V = mkV "avkräver" ; -- avkräva..vb.1
  avkrävande_1_N = mkN "avkrävande" ; -- avkrävande..nn.1
  avkrävning_1_N = mkN "avkrävning" ; -- avkrävning..nn.1
  avkunna_1_V = mkV "avkunnar" ; -- avkunna..vb.1
  avkunnande_1_N = mkN "avkunnande" ; -- avkunnande..nn.1
  avkvistning_1_N = mkN "avkvistning" ; -- avkvistning..nn.1
  avkyla_1_V = mkV "avkyler" ; -- avkyla..vb.1
  avkylare_1_N = mkN "avkylare" utrum  ; -- avkylare..nn.1
  avkylning_1_N = mkN "avkylning" ; -- avkylning..nn.1
  avkänna_1_V = mkV "avkänna" "avkände" "avkänt" ; -- avkänna..vb.1
  avkännare_1_N = mkN "avkännare" utrum  ; -- avkännare..nn.1
  avkänning_1_N = mkN "avkänning" ; -- avkänning..nn.1
  avkänningssystem_1_N = mkN "avkänningssystem" neutrum  ; -- avkänningssystem..nn.1
  avköna_1_V = mkV "avkönar" ; -- avköna..vb.1
  avkönande_1_N = mkN "avkönande" ; -- avkönande..nn.1
  avkörningsramp_1_N = mkN "avkörningsramp" "avkörningsramper" ; -- avkörningsramp..nn.1
  avla_1_V = mkV "avlar" ; -- avla..vb.1
  avlagd_1_A = mkA "avlagd" "avlagt" ; -- avlagd..av.1
  avlagra_1_V = mkV "avlagrar" ; -- avlagra..vb.1
  avlagrande_1_N = mkN "avlagrande" ; -- avlagrande..nn.1
  avlagring_1_N = mkN "avlagring" ; -- avlagring..nn.1
  avlande_1_N = mkN "avlande" ; -- avlande..nn.1
  avlassning_1_N = mkN "avlassning" ; -- avlassning..nn.1
  avlasta_1_V = mkV "avlastar" ; -- avlasta..vb.1
  avlastande_1_N = mkN "avlastande" ; -- avlastande..nn.1
  avlastare_1_N = mkN "avlastare" utrum  ; -- avlastare..nn.1
  avlastning_1_N = mkN "avlastning" ; -- avlastning..nn.1
  avlastningsort_1_N = mkN "avlastningsort" "avlastningsorter" ; -- avlastningsort..nn.1
  avlastningsplats_1_N = mkN "avlastningsplats" "avlastningsplatser" ; -- avlastningsplats..nn.1
  avlat_1_N = mkN "avlat" ; -- avlat..nn.1
  avlatsbrev_1_N = mkN "avlatsbrev" neutrum  ; -- avlatsbrev..nn.1
  avleda_1_V = mkV "avleda" "avledde" "avlett" ; -- avleda..vb.1
  avledande_1_N = mkN "avledande" ; -- avledande..nn.1
  avledare_1_N = mkN "avledare" utrum  ; -- avledare..nn.1
  avledning_1_N = mkN "avledning" ; -- avledning..nn.1
  avledningsdike_1_N = mkN "avledningsdike" ; -- avledningsdike..nn.1
  avledningsrör_1_N = mkN "avledningsrör" neutrum  ; -- avledningsrör..nn.1
  avledningsändelse_1_N = mkN "avledningsändelse" "avledningsändelser" ; -- avledningsändelse..nn.1
  avlelse_1_N = mkN "avlelse" utrum  ; -- avlelse..nn.1
  avleverera_1_V = mkV "avlevererar" ; -- avleverera..vb.1
  avleverering_1_N = mkN "avleverering" ; -- avleverering..nn.1
  avlida_1_V = mkV "avlida" "avled" "avlidit" ; -- avlida..vb.1
  avlidande_1_N = mkN "avlidande" ; -- avlidande..nn.1
  avliden_1_A = mkA "avliden" ; -- avliden..av.1
  avlindning_1_N = mkN "avlindning" ; -- avlindning..nn.1
  avling_1_N = mkN "avling" ; -- avling..nn.1
  avlinge_1_N = mkN "avlinge" ; -- avlinge..nn.1
  avliva_1_V = mkV "avlivar" ; -- avliva..vb.1
  avlivande_1_N = mkN "avlivande" ; -- avlivande..nn.1
  avljud_1_N = mkN "avljud" neutrum  ; -- avljud..nn.1
  avljudsvokal_1_N = mkN "avljudsvokal" "avljudsvokaler" ; -- avljudsvokal..nn.1
  avlocka_1_V = mkV "avlockar" ; -- avlocka..vb.1
  avlockande_1_N = mkN "avlockande" ; -- avlockande..nn.1
  avlopp_1_N = mkN "avlopp" neutrum  ; -- avlopp..nn.1
  avloppsbrunn_1_N = mkN "avloppsbrunn" ; -- avloppsbrunn..nn.1
  avloppsdike_1_N = mkN "avloppsdike" ; -- avloppsdike..nn.1
  avloppskanal_1_N = mkN "avloppskanal" "avloppskanaler" ; -- avloppskanal..nn.1
  avloppsledning_1_N = mkN "avloppsledning" ; -- avloppsledning..nn.1
  avloppsledningsrör_1_N = mkN "avloppsledningsrör" neutrum  ; -- avloppsledningsrör..nn.1
  avloppsrensare_1_N = mkN "avloppsrensare" utrum  ; -- avloppsrensare..nn.1
  avloppsrensning_1_N = mkN "avloppsrensning" ; -- avloppsrensning..nn.1
  avloppsrensningsslang_1_N = mkN "avloppsrensningsslang" ; -- avloppsrensningsslang..nn.1
  avloppsränna_1_N = mkN "avloppsränna" ; -- avloppsränna..nn.1
  avloppsrör_1_N = mkN "avloppsrör" neutrum  ; -- avloppsrör..nn.1
  avloppssystem_1_N = mkN "avloppssystem" neutrum  ; -- avloppssystem..nn.1
  avloppstrumma_1_N = mkN "avloppstrumma" ; -- avloppstrumma..nn.1
  avloppsvatten_1_N = mkN "avloppsvatten" "avloppsvattnet" "avloppsvatten" "avloppsvattnen" ; -- avloppsvatten..nn.1
  avlossa_1_V = mkV "avlossar" ; -- avlossa..vb.1
  avlossande_1_N = mkN "avlossande" ; -- avlossande..nn.1
  avlusa_1_V = mkV "avlusar" ; -- avlusa..vb.1
  avlusande_1_N = mkN "avlusande" ; -- avlusande..nn.1
  avlusning_1_N = mkN "avlusning" ; -- avlusning..nn.1
  avlusningsmedel_1_N = mkN "avlusningsmedel" neutrum  ; -- avlusningsmedel..nn.1
  avluta_1_V = mkV "avlutar" ; -- avluta..vb.1
  avlutande_1_N = mkN "avlutande" ; -- avlutande..nn.1
  avlysa_1_V = mkV "avlyser" ; -- avlysa..vb.1
  avlysande_1_N = mkN "avlysande" ; -- avlysande..nn.1
  avlysning_1_N = mkN "avlysning" ; -- avlysning..nn.1
  avlyssna_1_V = mkV "avlyssnar" ; -- avlyssna..vb.1
  avlyssnande_1_N = mkN "avlyssnande" ; -- avlyssnande..nn.1
  avlyssning_1_N = mkN "avlyssning" ; -- avlyssning..nn.1
  avlyssningsapparatur_1_N = mkN "avlyssningsapparatur" "avlyssningsapparaturer" ; -- avlyssningsapparatur..nn.1
  avlyssningshärva_1_N = mkN "avlyssningshärva" ; -- avlyssningshärva..nn.1
  avlyssningsskandal_1_N = mkN "avlyssningsskandal" "avlyssningsskandaler" ; -- avlyssningsskandal..nn.1
  avlyssningsutrustning_1_N = mkN "avlyssningsutrustning" ; -- avlyssningsutrustning..nn.1
  avlägga_1_V = mkV "avlägga" "avla" "avlagt" ; -- avlägga..vb.1
  avläggande_1_N = mkN "avläggande" ; -- avläggande..nn.1
  avläggare_1_N = mkN "avläggare" utrum  ; -- avläggare..nn.1
  avläggning_1_N = mkN "avläggning" ; -- avläggning..nn.1
  avlägsen_1_A = mkA "avlägsen" ; -- avlägsen..av.1
  avlägsenhet_1_N = mkN "avlägsenhet" ; -- avlägsenhet..nn.1
  avlägsna_1_V = mkV "avlägsnar" ; -- avlägsna..vb.1
  avlägsnande_1_N = mkN "avlägsnande" ; -- avlägsnande..nn.1
  avlämna_1_V = mkV "avlämnar" ; -- avlämna..vb.1
  avlämnande_1_N = mkN "avlämnande" ; -- avlämnande..nn.1
  avlämning_1_N = mkN "avlämning" ; -- avlämning..nn.1
  avlänka_1_V = mkV "avlänkar" ; -- avlänka..vb.1
  avlänkande_1_N = mkN "avlänkande" ; -- avlänkande..nn.1
  avläsa_1_V = mkV "avläser" ; -- avläsa..vb.1
  avläsande_1_N = mkN "avläsande" ; -- avläsande..nn.1
  avläsare_1_N = mkN "avläsare" utrum  ; -- avläsare..nn.1
  avläsbar_1_A = mkA "avläsbar" ; -- avläsbar..av.1
  avläsbarhet_1_N = mkN "avläsbarhet" ; -- avläsbarhet..nn.1
  avläsning_1_N = mkN "avläsning" ; -- avläsning..nn.1
  avlång_1_A = mkA "avlång" ; -- avlång..av.1
  avlånghet_1_N = mkN "avlånghet" ; -- avlånghet..nn.1
  avlåta_1_V = mkV "avlåta" "avlät" "avlåtit" ; -- avlåta..vb.1
  avlåtande_1_N = mkN "avlåtande" ; -- avlåtande..nn.1
  avlöna_1_V = mkV "avlönar" ; -- avlöna..vb.1
  avlönande_1_N = mkN "avlönande" ; -- avlönande..nn.1
  avlöning_1_N = mkN "avlöning" ; -- avlöning..nn.1
  avlöpa_1_V = mkV "avlöper" ; -- avlöpa..vb.1
  avlöpande_1_N = mkN "avlöpande" ; -- avlöpande..nn.1
  avlöpning_1_N = mkN "avlöpning" ; -- avlöpning..nn.1
  avlösa_1_V = mkV "avlöser" ; -- avlösa..vb.1
  avlösande_1_N = mkN "avlösande" ; -- avlösande..nn.1
  avlösning_1_N = mkN "avlösning" ; -- avlösning..nn.1
  avlöva_1_V = mkV "avlövar" ; -- avlöva..vb.1
  avlövande_1_N = mkN "avlövande" ; -- avlövande..nn.1
  avlövning_1_N = mkN "avlövning" ; -- avlövning..nn.1
  avlövningsmedel_1_N = mkN "avlövningsmedel" neutrum  ; -- avlövningsmedel..nn.1
  avmagnetisera_1_V = mkV "avmagnetiserar" ; -- avmagnetisera..vb.1
  avmagnetiserande_1_N = mkN "avmagnetiserande" ; -- avmagnetiserande..nn.1
  avmagnetiserbar_1_A = mkA "avmagnetiserbar" ; -- avmagnetiserbar..av.1
  avmagnetiserbarhet_1_N = mkN "avmagnetiserbarhet" ; -- avmagnetiserbarhet..nn.1
  avmagnetisering_1_N = mkN "avmagnetisering" ; -- avmagnetisering..nn.1
  avmagnetiseringsprocess_1_N = mkN "avmagnetiseringsprocess" "avmagnetiseringsprocesser" ; -- avmagnetiseringsprocess..nn.1
  avmagrad_1_A = mkA "avmagrad" ; -- avmagrad..av.1
  avmagring_1_N = mkN "avmagring" ; -- avmagring..nn.1
  avmarsch_1_N = mkN "avmarsch" "avmarscher" ; -- avmarsch..nn.1
  avmaska_1_V = mkV "avmaskar" ; -- avmaska..vb.1
  avmaskande_1_N = mkN "avmaskande" ; -- avmaskande..nn.1
  avmaskning_1_N = mkN "avmaskning" ; -- avmaskning..nn.1
  avmaskningskur_1_N = mkN "avmaskningskur" "avmaskningskurer" ; -- avmaskningskur..nn.1
  avmasta_1_V = mkV "avmastar" ; -- avmasta..vb.1
  avmastande_1_N = mkN "avmastande" ; -- avmastande..nn.1
  avmatta_1_V = mkV "avmattar" ; -- avmatta..vb.1
  avmattande_1_N = mkN "avmattande" ; -- avmattande..nn.1
  avmattning_1_N = mkN "avmattning" ; -- avmattning..nn.1
  avmattningsperiod_1_N = mkN "avmattningsperiod" "avmattningsperioder" ; -- avmattningsperiod..nn.1
  avmejning_1_N = mkN "avmejning" ; -- avmejning..nn.1
  avmejsling_1_N = mkN "avmejsling" ; -- avmejsling..nn.1
  avmystifiera_1_V = mkV "avmystifierar" ; -- avmystifiera..vb.1
  avmystifierande_1_N = mkN "avmystifierande" ; -- avmystifierande..nn.1
  avmystifierbar_1_A = mkA "avmystifierbar" ; -- avmystifierbar..av.1
  avmystifierbarhet_1_N = mkN "avmystifierbarhet" ; -- avmystifierbarhet..nn.1
  avmystifiering_1_N = mkN "avmystifiering" ; -- avmystifiering..nn.1
  avmäta_1_V = mkV "avmäter" ; -- avmäta..vb.1
  avmätande_1_N = mkN "avmätande" ; -- avmätande..nn.1
  avmätning_1_N = mkN "avmätning" ; -- avmätning..nn.1
  avmätt_1_A = mkA "avmätt" ; -- avmätt..av.1
  avmätthet_1_N = mkN "avmätthet" ; -- avmätthet..nn.1
  avmålning_1_N = mkN "avmålning" ; -- avmålning..nn.1
  avmönstra_1_V = mkV "avmönstrar" ; -- avmönstra..vb.1
  avmönstring_1_N = mkN "avmönstring" ; -- avmönstring..nn.1
  avnavla_1_V = mkV "avnavlar" ; -- avnavla..vb.1
  avnavlande_1_N = mkN "avnavlande" ; -- avnavlande..nn.1
  avnazifiera_1_V = mkV "avnazifierar" ; -- avnazifiera..vb.1
  avnazifierande_1_N = mkN "avnazifierande" ; -- avnazifierande..nn.1
  avnazifierbar_1_A = mkA "avnazifierbar" ; -- avnazifierbar..av.1
  avnazifierbarhet_1_N = mkN "avnazifierbarhet" ; -- avnazifierbarhet..nn.1
  avnazifiering_1_N = mkN "avnazifiering" ; -- avnazifiering..nn.1
  avnjuta_1_V = mkV "avnjuta" "avnjöt" "avnjutit" ; -- avnjuta..vb.1
  avnjutande_1_N = mkN "avnjutande" ; -- avnjutande..nn.1
  avnypning_1_N = mkN "avnypning" ; -- avnypning..nn.1
  avnystning_1_N = mkN "avnystning" ; -- avnystning..nn.1
  avnämare_1_N = mkN "avnämare" utrum  ; -- avnämare..nn.1
  avnötning_1_N = mkN "avnötning" ; -- avnötning..nn.1
  avocado_1_N = mkN "avocado" "avocador" ; -- avocado..nn.1
  avocadosås_1_N = mkN "avocadosås" "avocadosåser" ; -- avocadosås..nn.1
  avog_1_A = mkA "avog" ; -- avog..av.1
  avoghet_1_N = mkN "avoghet" ; -- avoghet..nn.1
  avokado_1_N = mkN "avokado" "avokador" ; -- avokado..nn.1
  avokadosås_1_N = mkN "avokadosås" "avokadosåser" ; -- avokadosås..nn.1
  avpackning_1_N = mkN "avpackning" ; -- avpackning..nn.1
  avpassa_1_V = mkV "avpassar" ; -- avpassa..vb.1
  avpassande_1_N = mkN "avpassande" ; -- avpassande..nn.1
  avpassning_1_N = mkN "avpassning" ; -- avpassning..nn.1
  avpatrullera_1_V = mkV "avpatrullerar" ; -- avpatrullera..vb.1
  avpatrullerande_1_N = mkN "avpatrullerande" ; -- avpatrullerande..nn.1
  avpatrullerbar_1_A = mkA "avpatrullerbar" ; -- avpatrullerbar..av.1
  avpatrullerbarhet_1_N = mkN "avpatrullerbarhet" ; -- avpatrullerbarhet..nn.1
  avpatrullering_1_N = mkN "avpatrullering" ; -- avpatrullering..nn.1
  avpersonifiera_1_V = mkV "avpersonifierar" ; -- avpersonifiera..vb.1
  avpersonifierande_1_N = mkN "avpersonifierande" ; -- avpersonifierande..nn.1
  avpersonifiering_1_N = mkN "avpersonifiering" ; -- avpersonifiering..nn.1
  avplana_1_V = mkV "avplanar" ; -- avplana..vb.1
  avplanande_1_N = mkN "avplanande" ; -- avplanande..nn.1
  avplaning_1_N = mkN "avplaning" ; -- avplaning..nn.1
  avplockning_1_N = mkN "avplockning" ; -- avplockning..nn.1
  avpolering_1_N = mkN "avpolering" ; -- avpolering..nn.1
  avpolitisera_1_V = mkV "avpolitiserar" ; -- avpolitisera..vb.1
  avpolitiserande_1_N = mkN "avpolitiserande" ; -- avpolitiserande..nn.1
  avpolitiserbar_1_A = mkA "avpolitiserbar" ; -- avpolitiserbar..av.1
  avpolitiserbarhet_1_N = mkN "avpolitiserbarhet" ; -- avpolitiserbarhet..nn.1
  avpolitisering_1_N = mkN "avpolitisering" ; -- avpolitisering..nn.1
  avpollettera_1_V = mkV "avpolletterar" ; -- avpollettera..vb.1
  avpolletterande_1_N = mkN "avpolletterande" ; -- avpolletterande..nn.1
  avpolletterbar_1_A = mkA "avpolletterbar" ; -- avpolletterbar..av.1
  avpolletterbarhet_1_N = mkN "avpolletterbarhet" ; -- avpolletterbarhet..nn.1
  avpollettering_1_N = mkN "avpollettering" ; -- avpollettering..nn.1
  avporträttera_1_V = mkV "avporträtterar" ; -- avporträttera..vb.1
  avporträtterande_1_N = mkN "avporträtterande" ; -- avporträtterande..nn.1
  avporträtterbar_1_A = mkA "avporträtterbar" ; -- avporträtterbar..av.1
  avporträtterbarhet_1_N = mkN "avporträtterbarhet" ; -- avporträtterbarhet..nn.1
  avporträttering_1_N = mkN "avporträttering" ; -- avporträttering..nn.1
  avpressa_1_V = mkV "avpressar" ; -- avpressa..vb.1
  avpressande_1_N = mkN "avpressande" ; -- avpressande..nn.1
  avprickning_1_N = mkN "avprickning" ; -- avprickning..nn.1
  avputsning_1_N = mkN "avputsning" ; -- avputsning..nn.1
  avrad_1_N = mkN "avrad" ; -- avrad..nn.1
  avradikalisera_1_V = mkV "avradikaliserar" ; -- avradikalisera..vb.1
  avradikaliserande_1_N = mkN "avradikaliserande" ; -- avradikaliserande..nn.1
  avradikalisering_1_N = mkN "avradikalisering" ; -- avradikalisering..nn.1
  avrakad_1_A = mkA "avrakad" ; -- avrakad..av.1
  avreagera_1_V = mkV "avreagerar" ; -- avreagera..vb.1
  avreagerande_1_N = mkN "avreagerande" ; -- avreagerande..nn.1
  avreagerbar_1_A = mkA "avreagerbar" ; -- avreagerbar..av.1
  avreagerbarhet_1_N = mkN "avreagerbarhet" ; -- avreagerbarhet..nn.1
  avreagering_1_N = mkN "avreagering" ; -- avreagering..nn.1
  avreda_1_V = mkV "avreda" "avredde" "avrett" ; -- avreda..vb.1
  avredande_1_N = mkN "avredande" ; -- avredande..nn.1
  avredning_1_N = mkN "avredning" ; -- avredning..nn.1
  avregistrera_1_V = mkV "avregistrerar" ; -- avregistrera..vb.1
  avregistrerande_1_N = mkN "avregistrerande" ; -- avregistrerande..nn.1
  avregistrerbar_1_A = mkA "avregistrerbar" ; -- avregistrerbar..av.1
  avregistrerbarhet_1_N = mkN "avregistrerbarhet" ; -- avregistrerbarhet..nn.1
  avregistrering_1_N = mkN "avregistrering" ; -- avregistrering..nn.1
  avreglera_1_V = mkV "avreglerar" ; -- avreglera..vb.1
  avreglerande_1_N = mkN "avreglerande" ; -- avreglerande..nn.1
  avreglerbar_1_A = mkA "avreglerbar" ; -- avreglerbar..av.1
  avreglerbarhet_1_N = mkN "avreglerbarhet" ; -- avreglerbarhet..nn.1
  avreglering_1_N = mkN "avreglering" ; -- avreglering..nn.1
  avrens_1_N = mkN "avrens" neutrum  ; -- avrens..nn.1
  avrensning_1_N = mkN "avrensning" ; -- avrensning..nn.1
  avresa_1_N = mkN "avresa" ; -- avresa..nn.1
  avresa_1_V = mkV "avreser" ; -- avresa..vb.1
  avresande_1_N = mkN "avresande" ; -- avresande..nn.1
  avringning_1_N = mkN "avringning" ; -- avringning..nn.1
  avrinna_1_V = mkV "avrinna" "avrann" "avrunnit" ; -- avrinna..vb.1
  avrinnande_1_N = mkN "avrinnande" ; -- avrinnande..nn.1
  avrinning_1_N = mkN "avrinning" ; -- avrinning..nn.1
  avritning_1_N = mkN "avritning" ; -- avritning..nn.1
  avrivning_1_N = mkN "avrivning" ; -- avrivning..nn.1
  avromantisera_1_V = mkV "avromantiserar" ; -- avromantisera..vb.1
  avromantiserande_1_N = mkN "avromantiserande" ; -- avromantiserande..nn.1
  avromantiserbar_1_A = mkA "avromantiserbar" ; -- avromantiserbar..av.1
  avromantiserbarhet_1_N = mkN "avromantiserbarhet" ; -- avromantiserbarhet..nn.1
  avromantisering_1_N = mkN "avromantisering" ; -- avromantisering..nn.1
  avrop_1_N = mkN "avrop" neutrum  ; -- avrop..nn.1
  avrullning_1_N = mkN "avrullning" ; -- avrullning..nn.1
  avrunda_1_V = mkV "avrundar" ; -- avrunda..vb.1
  avrundande_1_N = mkN "avrundande" ; -- avrundande..nn.1
  avrundning_1_N = mkN "avrundning" ; -- avrundning..nn.1
  avrusta_1_V = mkV "avrustar" ; -- avrusta..vb.1
  avrustande_1_N = mkN "avrustande" ; -- avrustande..nn.1
  avrustning_1_N = mkN "avrustning" ; -- avrustning..nn.1
  avräkna_1_V = mkV "avräknar" ; -- avräkna..vb.1
  avräknande_1_N = mkN "avräknande" ; -- avräknande..nn.1
  avräkning_1_N = mkN "avräkning" ; -- avräkning..nn.1
  avräkningsnota_1_N = mkN "avräkningsnota" ; -- avräkningsnota..nn.1
  avrätta_1_V = mkV "avrättar" ; -- avrätta..vb.1
  avrättande_1_N = mkN "avrättande" ; -- avrättande..nn.1
  avrättning_1_N = mkN "avrättning" ; -- avrättning..nn.1
  avrättningsdag_1_N = mkN "avrättningsdag" ; -- avrättningsdag..nn.1
  avrättningslista_1_N = mkN "avrättningslista" ; -- avrättningslista..nn.1
  avrättningsplats_1_N = mkN "avrättningsplats" "avrättningsplatser" ; -- avrättningsplats..nn.1
  avråda_1_V = mkV "avråda" "avrådde" "avrått" ; -- avråda..vb.1
  avrådande_1_N = mkN "avrådande" ; -- avrådande..nn.1
  avröjning_1_N = mkN "avröjning" ; -- avröjning..nn.1
  avsadling_1_N = mkN "avsadling" ; -- avsadling..nn.1
  avsaknad_1_N = mkN "avsaknad" "avsaknader" ; -- avsaknad..nn.1
  avsaktning_1_N = mkN "avsaktning" ; -- avsaktning..nn.1
  avsalta_1_V = mkV "avsaltar" ; -- avsalta..vb.1
  avsaltande_1_N = mkN "avsaltande" ; -- avsaltande..nn.1
  avsalu_1_N = mkN "avsalu" ; -- avsalu..nn.1
  avsats_1_N = mkN "avsats" "avsatser" ; -- avsats..nn.1
  avse_1_V = mkV "avse" "avsåg" "avsett" ; -- avse..vb.1
  avsedd_1_A = mkA "avsedd" ; -- avsedd..av.1
  avseende_1_N = mkN "avseende" ; -- avseende..nn.1
  avsegla_1_V = mkV "avseglar" ; -- avsegla..vb.1
  avseglande_1_N = mkN "avseglande" ; -- avseglande..nn.1
  avsegling_1_N = mkN "avsegling" ; -- avsegling..nn.1
  avseglingsdag_1_N = mkN "avseglingsdag" ; -- avseglingsdag..nn.1
  avseglingsort_1_N = mkN "avseglingsort" "avseglingsorter" ; -- avseglingsort..nn.1
  avselning_1_N = mkN "avselning" ; -- avselning..nn.1
  avsevärd_1_A = mkA "avsevärd" "avsevärt" ; -- avsevärd..av.1
  avsides_1_A = mkA "avsides" ; -- avsides..av.1
  avsidesliv_1_N = mkN "avsidesliv" neutrum  ; -- avsidesliv..nn.1
  avsigkommen_1_A = mkA "avsigkommen" "avsigkommet" "avsigkomna" "avsigkomna" "avsigkomnare" "avsigkomnast" "avsigkomnaste" ; -- avsigkommen..av.1
  avsigkommenhet_1_N = mkN "avsigkommenhet" ; -- avsigkommenhet..nn.1
  avsikt_1_N = mkN "avsikt" "avsikter" ; -- avsikt..nn.1
  avsiktlig_1_A = mkA "avsiktlig" ; -- avsiktlig..av.1
  avsiktligen_1_Adv = mkAdv "avsiktligen" ; -- avsiktligen..ab.1
  avsiktlighet_1_N = mkN "avsiktlighet" ; -- avsiktlighet..nn.1
  avsiktsbisats_1_N = mkN "avsiktsbisats" "avsiktsbisatser" ; -- avsiktsbisats..nn.1
  avsiktsförklaring_1_N = mkN "avsiktsförklaring" ; -- avsiktsförklaring..nn.1
  avsiktslös_1_A = mkA "avsiktslös" ; -- avsiktslös..av.1
  avsiktssats_1_N = mkN "avsiktssats" "avsiktssatser" ; -- avsiktssats..nn.1
  avsilning_1_N = mkN "avsilning" ; -- avsilning..nn.1
  avsittning_1_N = mkN "avsittning" ; -- avsittning..nn.1
  avsjunga_1_V = mkV "avsjunga" "avsjöng" "avsjungit" ; -- avsjunga..vb.1
  avsjungande_1_N = mkN "avsjungande" ; -- avsjungande..nn.1
  avskaffa_1_V = mkV "avskaffar" ; -- avskaffa..vb.1
  avskaffande_1_N = mkN "avskaffande" ; -- avskaffande..nn.1
  avskaffning_1_N = mkN "avskaffning" ; -- avskaffning..nn.1
  avskakning_1_N = mkN "avskakning" ; -- avskakning..nn.1
  avskalning_1_N = mkN "avskalning" ; -- avskalning..nn.1
  avskava_1_V = mkV "avskaver" ; -- avskava..vb.1
  avskavande_1_N = mkN "avskavande" ; -- avskavande..nn.1
  avskavning_1_N = mkN "avskavning" ; -- avskavning..nn.1
  avsked_1_N = mkN "avsked" neutrum  ; -- avsked..nn.1
  avskeda_1_V = mkV "avskedar" ; -- avskeda..vb.1
  avskedande_1_N = mkN "avskedande" ; -- avskedande..nn.1
  avskedsbrev_1_N = mkN "avskedsbrev" neutrum  ; -- avskedsbrev..nn.1
  avskedsbägare_1_N = mkN "avskedsbägare" utrum  ; -- avskedsbägare..nn.1
  avskedsdikt_1_N = mkN "avskedsdikt" "avskedsdikter" ; -- avskedsdikt..nn.1
  avskedsfest_1_N = mkN "avskedsfest" "avskedsfester" ; -- avskedsfest..nn.1
  avskedsföreställning_1_N = mkN "avskedsföreställning" ; -- avskedsföreställning..nn.1
  avskedshälsning_1_N = mkN "avskedshälsning" ; -- avskedshälsning..nn.1
  avskedskalas_1_N = mkN "avskedskalas" neutrum  ; -- avskedskalas..nn.1
  avskedsknull_1_N = mkN "avskedsknull" neutrum  ; -- avskedsknull..nn.1
  avskedskyss_1_N = mkN "avskedskyss" ; -- avskedskyss..nn.1
  avskedsmiddag_1_N = mkN "avskedsmiddag" ; -- avskedsmiddag..nn.1
  avskedsord_1_N = mkN "avskedsord" neutrum  ; -- avskedsord..nn.1
  avskedsskål_1_N = mkN "avskedsskål" ; -- avskedsskål..nn.1
  avskedssång_1_N = mkN "avskedssång" "avskedssånger" ; -- avskedssång..nn.1
  avskedstagande_1_N = mkN "avskedstagande" ; -- avskedstagande..nn.1
  avskedstal_1_N = mkN "avskedstal" neutrum  ; -- avskedstal..nn.1
  avskedsturné_1_N = mkN "avskedsturné" "avskedsturnéer" ; -- avskedsturné..nn.1
  avskedsuppvaktning_1_N = mkN "avskedsuppvaktning" ; -- avskedsuppvaktning..nn.1
  avskedsvisit_1_N = mkN "avskedsvisit" "avskedsvisiter" ; -- avskedsvisit..nn.1
  avskeppa_1_V = mkV "avskeppar" ; -- avskeppa..vb.1
  avskeppning_1_N = mkN "avskeppning" ; -- avskeppning..nn.1
  avskeppningshamn_1_N = mkN "avskeppningshamn" ; -- avskeppningshamn..nn.1
  avskeppningsort_1_N = mkN "avskeppningsort" "avskeppningsorter" ; -- avskeppningsort..nn.1
  avskild_1_A = mkA "avskild" "avskilt" ; -- avskild..av.1
  avskildhet_1_N = mkN "avskildhet" "avskildheter" ; -- avskildhet..nn.1
  avskilja_1_V = mkV "avskilja" "avskilde" "avskilt" ; -- avskilja..vb.1
  avskiljande_1_N = mkN "avskiljande" ; -- avskiljande..nn.1
  avskiljbar_1_A = mkA "avskiljbar" ; -- avskiljbar..av.1
  avskiljbarhet_1_N = mkN "avskiljbarhet" ; -- avskiljbarhet..nn.1
  avskiljning_1_N = mkN "avskiljning" ; -- avskiljning..nn.1
  avskjuta_1_V = mkV "avskjuta" "avsköt" "avskjutit" ; -- avskjuta..vb.1
  avskjutande_1_N = mkN "avskjutande" ; -- avskjutande..nn.1
  avskjutning_1_N = mkN "avskjutning" ; -- avskjutning..nn.1
  avskogning_1_N = mkN "avskogning" ; -- avskogning..nn.1
  avskottning_1_N = mkN "avskottning" ; -- avskottning..nn.1
  avskrap_1_N = mkN "avskrap" neutrum  ; -- avskrap..nn.1
  avskrapning_1_N = mkN "avskrapning" ; -- avskrapning..nn.1
  avskrift_1_N = mkN "avskrift" "avskrifter" ; -- avskrift..nn.1
  avskriva_1_V = mkV "avskriva" "avskrev" "avskrivit" ; -- avskriva..vb.1
  avskrivande_1_N = mkN "avskrivande" ; -- avskrivande..nn.1
  avskrivare_1_N = mkN "avskrivare" utrum  ; -- avskrivare..nn.1
  avskrivning_1_N = mkN "avskrivning" ; -- avskrivning..nn.1
  avskrivningsobjekt_1_N = mkN "avskrivningsobjekt" neutrum  ; -- avskrivningsobjekt..nn.1
  avskrot_1_N = mkN "avskrot" ; -- avskrot..nn.1
  avskrubbning_1_N = mkN "avskrubbning" ; -- avskrubbning..nn.1
  avskruvning_1_N = mkN "avskruvning" ; -- avskruvning..nn.1
  avskräcka_1_V = mkV "avskräcker" ; -- avskräcka..vb.1
  avskräckande_1_N = mkN "avskräckande" ; -- avskräckande..nn.1
  avskräckning_1_N = mkN "avskräckning" ; -- avskräckning..nn.1
  avskräckningsmedel_1_N = mkN "avskräckningsmedel" neutrum  ; -- avskräckningsmedel..nn.1
  avskräckningspolitik_1_N = mkN "avskräckningspolitik" ; -- avskräckningspolitik..nn.1
  avskräda_1_V = mkV "avskräda" "avskrädde" "avskrätt" ; -- avskräda..vb.1
  avskrädande_1_N = mkN "avskrädande" ; -- avskrädande..nn.1
  avskräde_1_N = mkN "avskräde" ; -- avskräde..nn.1
  avskrädeshög_1_N = mkN "avskrädeshög" ; -- avskrädeshög..nn.1
  avskrädning_1_N = mkN "avskrädning" ; -- avskrädning..nn.1
  avskuddning_1_N = mkN "avskuddning" ; -- avskuddning..nn.1
  avskumning_1_N = mkN "avskumning" ; -- avskumning..nn.1
  avskurning_1_N = mkN "avskurning" ; -- avskurning..nn.1
  avsky_1_V = mkV "avskyr" ; -- avsky..vb.1
  avskydd_1_A = mkA "avskydd" ; -- avskydd..av.1
  avskyende_1_N = mkN "avskyende" ; -- avskyende..nn.1
  avskyffling_1_N = mkN "avskyffling" ; -- avskyffling..nn.1
  avskyväckande_1_A = mkA "avskyväckande" ; -- avskyväckande..av.1
  avskyvärd_1_A = mkA "avskyvärd" "avskyvärt" ; -- avskyvärd..av.1
  avskyvärdhet_1_N = mkN "avskyvärdhet" ; -- avskyvärdhet..nn.1
  avskära_1_V = mkV "avskära" "avskar" "avskurit" ; -- avskära..vb.1
  avskärande_1_N = mkN "avskärande" ; -- avskärande..nn.1
  avskärare_1_N = mkN "avskärare" utrum  ; -- avskärare..nn.1
  avskärma_1_V = mkV "avskärmar" ; -- avskärma..vb.1
  avskärmande_1_N = mkN "avskärmande" ; -- avskärmande..nn.1
  avskärmning_1_N = mkN "avskärmning" ; -- avskärmning..nn.1
  avskärning_1_N = mkN "avskärning" ; -- avskärning..nn.1
  avsköljning_1_N = mkN "avsköljning" ; -- avsköljning..nn.1
  avslag_1_N = mkN "avslag" neutrum  ; -- avslag..nn.1
  avslagen_1_A = mkA "avslagen" ; -- avslagen..av.1
  avslagenhet_1_N = mkN "avslagenhet" ; -- avslagenhet..nn.1
  avslappnad_1_A = mkA "avslappnad" ; -- avslappnad..av.1
  avslappning_1_N = mkN "avslappning" ; -- avslappning..nn.1
  avslappningsskiva_1_N = mkN "avslappningsskiva" ; -- avslappningsskiva..nn.1
  avslappningsövning_1_N = mkN "avslappningsövning" ; -- avslappningsövning..nn.1
  avslickning_1_N = mkN "avslickning" ; -- avslickning..nn.1
  avslipa_1_V = mkV "avslipar" ; -- avslipa..vb.1
  avslipande_1_N = mkN "avslipande" ; -- avslipande..nn.1
  avslipning_1_N = mkN "avslipning" ; -- avslipning..nn.1
  avslita_1_V = mkV "avslita" "avslet" "avslitit" ; -- avslita..vb.1
  avslitande_1_N = mkN "avslitande" ; -- avslitande..nn.1
  avslut_1_N = mkN "avslut" neutrum  ; -- avslut..nn.1
  avsluta_1_V = mkV "avslutar" ; -- avsluta..vb.1
  avslutande_1_N = mkN "avslutande" ; -- avslutande..nn.1
  avslutning_1_N = mkN "avslutning" ; -- avslutning..nn.1
  avslutningsfest_1_N = mkN "avslutningsfest" "avslutningsfester" ; -- avslutningsfest..nn.1
  avslutningsvis_1_Adv = mkAdv "avslutningsvis" ; -- avslutningsvis..ab.1
  avslängning_1_N = mkN "avslängning" ; -- avslängning..nn.1
  avsläppning_1_N = mkN "avsläppning" ; -- avsläppning..nn.1
  avslå_1_V = mkV "avslå" "avslog" "avslagit" ; -- avslå..vb.1
  avslående_1_N = mkN "avslående" ; -- avslående..nn.1
  avslöja_1_V = mkV "avslöjar" ; -- avslöja..vb.1
  avslöjande_1_N = mkN "avslöjande" ; -- avslöjande..nn.1
  avslöjning_1_N = mkN "avslöjning" ; -- avslöjning..nn.1
  avsmak_1_N = mkN "avsmak" ; -- avsmak..nn.1
  avsmaka_1_V = mkV "avsmakar" ; -- avsmaka..vb.1
  avsmakande_1_N = mkN "avsmakande" ; -- avsmakande..nn.1
  avsmakning_1_N = mkN "avsmakning" ; -- avsmakning..nn.1
  avsmalna_1_V = mkV "avsmalnar" ; -- avsmalna..vb.1
  avsmalnande_1_N = mkN "avsmalnande" ; -- avsmalnande..nn.1
  avsmalning_1_N = mkN "avsmalning" ; -- avsmalning..nn.1
  avsmältning_1_N = mkN "avsmältning" ; -- avsmältning..nn.1
  avsnitt_1_N = mkN "avsnitt" neutrum  ; -- avsnitt..nn.1
  avsnoppa_1_V = mkV "avsnoppar" ; -- avsnoppa..vb.1
  avsnoppad_1_A = mkA "avsnoppad" ; -- avsnoppad..av.1
  avsnoppande_1_N = mkN "avsnoppande" ; -- avsnoppande..nn.1
  avsnäsning_1_N = mkN "avsnäsning" ; -- avsnäsning..nn.1
  avsnöra_1_V = mkV "avsnöra" "avsnörde" "avsnört" ; -- avsnöra..vb.1
  avsnörande_1_N = mkN "avsnörande" ; -- avsnörande..nn.1
  avsnörning_1_N = mkN "avsnörning" ; -- avsnörning..nn.1
  avsnörningsteori_1_N = mkN "avsnörningsteori" "avsnörningsteorier" ; -- avsnörningsteori..nn.1
  avsocialisera_1_V = mkV "avsocialiserar" ; -- avsocialisera..vb.1
  avsocialiserande_1_N = mkN "avsocialiserande" ; -- avsocialiserande..nn.1
  avsocialiserbar_1_A = mkA "avsocialiserbar" ; -- avsocialiserbar..av.1
  avsocialiserbarhet_1_N = mkN "avsocialiserbarhet" ; -- avsocialiserbarhet..nn.1
  avsocialisering_1_N = mkN "avsocialisering" ; -- avsocialisering..nn.1
  avsomna_1_V = mkV "avsomnar" ; -- avsomna..vb.1
  avsomnande_1_N = mkN "avsomnande" ; -- avsomnande..nn.1
  avsopning_1_N = mkN "avsopning" ; -- avsopning..nn.1
  avspark_1_N = mkN "avspark" ; -- avspark..nn.1
  avsparkning_1_N = mkN "avsparkning" ; -- avsparkning..nn.1
  avspegla_1_V = mkV "avspeglar" ; -- avspegla..vb.1
  avspeglande_1_N = mkN "avspeglande" ; -- avspeglande..nn.1
  avspegling_1_N = mkN "avspegling" ; -- avspegling..nn.1
  avspela_1_V = mkV "avspelar" ; -- avspela..vb.1
  avspelande_1_N = mkN "avspelande" ; -- avspelande..nn.1
  avspelning_1_N = mkN "avspelning" ; -- avspelning..nn.1
  avspisa_1_V = mkV "avspisar" ; -- avspisa..vb.1
  avspisande_1_N = mkN "avspisande" ; -- avspisande..nn.1
  avspisning_1_N = mkN "avspisning" ; -- avspisning..nn.1
  avspolning_1_N = mkN "avspolning" ; -- avspolning..nn.1
  avsprång_1_N = mkN "avsprång" neutrum  ; -- avsprång..nn.1
  avspänd_1_A = mkA "avspänd" ; -- avspänd..av.1
  avspändhet_1_N = mkN "avspändhet" ; -- avspändhet..nn.1
  avspänning_1_N = mkN "avspänning" ; -- avspänning..nn.1
  avspänningspedagog_1_N = mkN "avspänningspedagog" "avspänningspedagoger" ; -- avspänningspedagog..nn.1
  avspärra_1_V = mkV "avspärrar" ; -- avspärra..vb.1
  avspärrande_1_N = mkN "avspärrande" ; -- avspärrande..nn.1
  avspärrning_1_N = mkN "avspärrning" ; -- avspärrning..nn.1
  avspärrningsband_1_N = mkN "avspärrningsband" neutrum  ; -- avspärrningsband..nn.1
  avstalinisera_1_V = mkV "avstaliniserar" ; -- avstalinisera..vb.1
  avstaliniserande_1_N = mkN "avstaliniserande" ; -- avstaliniserande..nn.1
  avstaliniserbar_1_A = mkA "avstaliniserbar" ; -- avstaliniserbar..av.1
  avstaliniserbarhet_1_N = mkN "avstaliniserbarhet" ; -- avstaliniserbarhet..nn.1
  avstalinisering_1_N = mkN "avstalinisering" ; -- avstalinisering..nn.1
  avstamp_1_N = mkN "avstamp" neutrum  ; -- avstamp..nn.1
  avstanna_1_V = mkV "avstannar" ; -- avstanna..vb.1
  avstannande_1_N = mkN "avstannande" ; -- avstannande..nn.1
  avstava_1_V = mkV "avstavar" ; -- avstava..vb.1
  avstavande_1_N = mkN "avstavande" ; -- avstavande..nn.1
  avstavning_1_N = mkN "avstavning" ; -- avstavning..nn.1
  avstavningsregel_1_N = mkN "avstavningsregel" "avstavningsregeln" "avstavningsregler" "avstavningsreglerna" ; -- avstavningsregel..nn.1
  avstavningssätt_1_N = mkN "avstavningssätt" neutrum  ; -- avstavningssätt..nn.1
  avsteg_1_N = mkN "avsteg" neutrum  ; -- avsteg..nn.1
  avstickare_1_N = mkN "avstickare" utrum  ; -- avstickare..nn.1
  avstickning_1_N = mkN "avstickning" ; -- avstickning..nn.1
  avstigning_1_N = mkN "avstigning" ; -- avstigning..nn.1
  avstigningsplats_1_N = mkN "avstigningsplats" "avstigningsplatser" ; -- avstigningsplats..nn.1
  avstjälpning_1_N = mkN "avstjälpning" ; -- avstjälpning..nn.1
  avstjälpningscentral_1_N = mkN "avstjälpningscentral" "avstjälpningscentraler" ; -- avstjälpningscentral..nn.1
  avstjälpningsplats_1_N = mkN "avstjälpningsplats" "avstjälpningsplatser" ; -- avstjälpningsplats..nn.1
  avstressa_1_V = mkV "avstressar" ; -- avstressa..vb.1
  avstressad_1_A = mkA "avstressad" ; -- avstressad..av.1
  avstressande_1_N = mkN "avstressande" ; -- avstressande..nn.1
  avstycka_1_V = mkV "avstyckar" ; -- avstycka..vb.1
  avstyckande_1_N = mkN "avstyckande" ; -- avstyckande..nn.1
  avstyckning_1_N = mkN "avstyckning" ; -- avstyckning..nn.1
  avstyra_1_V = mkV "avstyra" "avstyrde" "avstyrt" ; -- avstyra..vb.1
  avstyrande_1_N = mkN "avstyrande" ; -- avstyrande..nn.1
  avstyrka_1_V = mkV "avstyrker" ; -- avstyrka..vb.1
  avstyrkande_1_N = mkN "avstyrkande" ; -- avstyrkande..nn.1
  avställa_1_V = mkV "avställer" ; -- avställa..vb.1
  avställande_1_N = mkN "avställande" ; -- avställande..nn.1
  avställning_1_N = mkN "avställning" ; -- avställning..nn.1
  avställningsyta_1_N = mkN "avställningsyta" ; -- avställningsyta..nn.1
  avstämma_1_V = mkV "avstämmer" ; -- avstämma..vb.1
  avstämmande_1_N = mkN "avstämmande" ; -- avstämmande..nn.1
  avstämning_1_N = mkN "avstämning" ; -- avstämning..nn.1
  avstämpling_1_N = mkN "avstämpling" ; -- avstämpling..nn.1
  avstänga_1_V = mkV "avstänger" ; -- avstänga..vb.1
  avstängande_1_N = mkN "avstängande" ; -- avstängande..nn.1
  avstängare_1_N = mkN "avstängare" utrum  ; -- avstängare..nn.1
  avstängning_1_N = mkN "avstängning" ; -- avstängning..nn.1
  avstå_1_V = mkV "avstå" "avstod" "avstått" ; -- avstå..vb.1
  avstående_1_N = mkN "avstående" ; -- avstående..nn.1
  avstånd_1_N = mkN "avstånd" neutrum  ; -- avstånd..nn.1
  avståndsbedömning_1_N = mkN "avståndsbedömning" ; -- avståndsbedömning..nn.1
  avståndsinformation_1_N = mkN "avståndsinformation" ; -- avståndsinformation..nn.1
  avståndskraft_1_N = mkN "avståndskraft" "avståndskrafter" ; -- avståndskraft..nn.1
  avståndsmätare_1_N = mkN "avståndsmätare" utrum  ; -- avståndsmätare..nn.1
  avståndsmätning_1_N = mkN "avståndsmätning" ; -- avståndsmätning..nn.1
  avståndstagande_1_N = mkN "avståndstagande" ; -- avståndstagande..nn.1
  avstöra_1_V = mkV "avstöra" "avstörde" "avstört" ; -- avstöra..vb.1
  avstörande_1_N = mkN "avstörande" ; -- avstörande..nn.1
  avstöta_1_V = mkV "avstöter" ; -- avstöta..vb.1
  avstötande_1_N = mkN "avstötande" ; -- avstötande..nn.1
  avstötning_1_N = mkN "avstötning" ; -- avstötning..nn.1
  avsugning_1_N = mkN "avsugning" ; -- avsugning..nn.1
  avsutten_1_A = mkA "avsutten" ; -- avsutten..av.1
  avsvalkning_1_N = mkN "avsvalkning" ; -- avsvalkning..nn.1
  avsvalna_1_V = mkV "avsvalnar" ; -- avsvalna..vb.1
  avsvalnande_1_N = mkN "avsvalnande" ; -- avsvalnande..nn.1
  avsvalning_1_N = mkN "avsvalning" ; -- avsvalning..nn.1
  avsvalningshastighet_1_N = mkN "avsvalningshastighet" ; -- avsvalningshastighet..nn.1
  avsvavla_1_V = mkV "avsvavlar" ; -- avsvavla..vb.1
  avsvavlande_1_N = mkN "avsvavlande" ; -- avsvavlande..nn.1
  avsvimma_1_V = mkV "avsvimmar" ; -- avsvimma..vb.1
  avsvimmande_1_N = mkN "avsvimmande" ; -- avsvimmande..nn.1
  avsvimning_1_N = mkN "avsvimning" ; -- avsvimning..nn.1
  avsvuren_1_A = mkA "avsvuren" ; -- avsvuren..av.1
  avsvärja_1_V = mkV "avsvära" "avsvär" "avsvärj" "avsvärjde" "avsvärjt" "avsvuren" ; -- avsvärja..vb.1
  avsvärjande_1_N = mkN "avsvärjande" ; -- avsvärjande..nn.1
  avsvärjning_1_N = mkN "avsvärjning" ; -- avsvärjning..nn.1
  avsyna_1_V = mkV "avsynar" ; -- avsyna..vb.1
  avsynande_1_N = mkN "avsynande" ; -- avsynande..nn.1
  avsynare_1_N = mkN "avsynare" utrum  ; -- avsynare..nn.1
  avsyning_1_N = mkN "avsyning" ; -- avsyning..nn.1
  avsäga_1_V = mkV "avsäja" "avsa" "avsagt" ; -- avsäga..vb.1
  avsägande_1_N = mkN "avsägande" ; -- avsägande..nn.1
  avsägelse_1_N = mkN "avsägelse" "avsägelser" ; -- avsägelse..nn.1
  avsända_1_V = mkV "avsänder" ; -- avsända..vb.1
  avsändande_1_N = mkN "avsändande" ; -- avsändande..nn.1
  avsändare_1_N = mkN "avsändare" utrum  ; -- avsändare..nn.1
  avsändarnummer_1_N = mkN "avsändarnummer" neutrum  ; -- avsändarnummer..nn.1
  avsändning_1_N = mkN "avsändning" ; -- avsändning..nn.1
  avsätta_1_V = mkV "avsätta" "avsätter" "avsätt" "avsatte" "avsatt" "avsatt" ; -- avsätta..vb.1
  avsättande_1_N = mkN "avsättande" ; -- avsättande..nn.1
  avsättlig_1_A = mkA "avsättlig" ; -- avsättlig..av.1
  avsättlighet_1_N = mkN "avsättlighet" ; -- avsättlighet..nn.1
  avsättning_1_N = mkN "avsättning" ; -- avsättning..nn.1
  avsättningsbassäng_1_N = mkN "avsättningsbassäng" "avsättningsbassänger" ; -- avsättningsbassäng..nn.1
  avsåga_1_V = mkV "avsågar" ; -- avsåga..vb.1
  avsågande_1_N = mkN "avsågande" ; -- avsågande..nn.1
  avsågning_1_N = mkN "avsågning" ; -- avsågning..nn.1
  avsöka_1_V = mkV "avsöker" ; -- avsöka..vb.1
  avsökande_1_N = mkN "avsökande" ; -- avsökande..nn.1
  avsökare_1_N = mkN "avsökare" utrum  ; -- avsökare..nn.1
  avsöndra_1_V = mkV "avsöndrar" ; -- avsöndra..vb.1
  avsöndrande_1_N = mkN "avsöndrande" ; -- avsöndrande..nn.1
  avsöndring_1_N = mkN "avsöndring" ; -- avsöndring..nn.1
  avta_1_V = mkV "avtaga" "avtog" "avtagit" ; -- avta..vb.1
  avtacka_1_V = mkV "avtackar" ; -- avtacka..vb.1
  avtackande_1_N = mkN "avtackande" ; -- avtackande..nn.1
  avtacklad_1_A = mkA "avtacklad" ; -- avtacklad..av.1
  avtackling_1_N = mkN "avtackling" ; -- avtackling..nn.1
  avtackning_1_N = mkN "avtackning" ; -- avtackning..nn.1
  avtagande_1_A = mkA "avtagande" ; -- avtagande..av.1
  avtagande_1_N = mkN "avtagande" ; -- avtagande..nn.1
  avtagbar_1_A = mkA "avtagbar" ; -- avtagbar..av.1
  avtagbarhet_1_N = mkN "avtagbarhet" ; -- avtagbarhet..nn.1
  avtagning_1_N = mkN "avtagning" ; -- avtagning..nn.1
  avtagsväg_1_N = mkN "avtagsväg" ; -- avtagsväg..nn.1
  avtal_1_N = mkN "avtal" neutrum  ; -- avtal..nn.1
  avtala_1_V = mkV "avtalar" ; -- avtala..vb.1
  avtalande_1_N = mkN "avtalande" ; -- avtalande..nn.1
  avtalsbrott_1_N = mkN "avtalsbrott" neutrum  ; -- avtalsbrott..nn.1
  avtalsenlig_1_A = mkA "avtalsenlig" ; -- avtalsenlig..av.1
  avtalsenlighet_1_N = mkN "avtalsenlighet" ; -- avtalsenlighet..nn.1
  avtalsfrihet_1_N = mkN "avtalsfrihet" "avtalsfriheter" ; -- avtalsfrihet..nn.1
  avtalsförhandling_1_N = mkN "avtalsförhandling" ; -- avtalsförhandling..nn.1
  avtalsmässig_1_A = mkA "avtalsmässig" ; -- avtalsmässig..av.1
  avtalspension_1_N = mkN "avtalspension" ; -- avtalspension..nn.1
  avtalspensionär_1_N = mkN "avtalspensionär" "avtalspensionärer" ; -- avtalspensionär..nn.1
  avtalsperiod_1_N = mkN "avtalsperiod" "avtalsperioder" ; -- avtalsperiod..nn.1
  avtalsrätt_1_N = mkN "avtalsrätt" ; -- avtalsrätt..nn.1
  avtalsrörelse_1_N = mkN "avtalsrörelse" "avtalsrörelser" ; -- avtalsrörelse..nn.1
  avtalssekreterare_1_N = mkN "avtalssekreterare" utrum  ; -- avtalssekreterare..nn.1
  avtalsslutande_1_A = mkA "avtalsslutande" ; -- avtalsslutande..av.1
  avtalsstridig_1_A = mkA "avtalsstridig" ; -- avtalsstridig..av.1
  avtappa_1_V = mkV "avtappar" ; -- avtappa..vb.1
  avtappande_1_N = mkN "avtappande" ; -- avtappande..nn.1
  avtappning_1_N = mkN "avtappning" ; -- avtappning..nn.1
  avteckna_1_V = mkV "avtecknar" ; -- avteckna..vb.1
  avtecknande_1_N = mkN "avtecknande" ; -- avtecknande..nn.1
  avteckning_1_N = mkN "avteckning" ; -- avteckning..nn.1
  avtjäna_1_V = mkV "avtjänar" ; -- avtjäna..vb.1
  avtjänande_1_N = mkN "avtjänande" ; -- avtjänande..nn.1
  avtona_1_V = mkV "avtonar" ; -- avtona..vb.1
  avtonande_1_N = mkN "avtonande" ; -- avtonande..nn.1
  avtoning_1_N = mkN "avtoning" ; -- avtoning..nn.1
  avtorka_1_V = mkV "avtorkar" ; -- avtorka..vb.1
  avtorkning_1_N = mkN "avtorkning" ; -- avtorkning..nn.1
  avtrappa_1_V = mkV "avtrappar" ; -- avtrappa..vb.1
  avtrappande_1_N = mkN "avtrappande" ; -- avtrappande..nn.1
  avtroppning_1_N = mkN "avtroppning" ; -- avtroppning..nn.1
  avtrubba_1_V = mkV "avtrubbar" ; -- avtrubba..vb.1
  avtrubbande_1_N = mkN "avtrubbande" ; -- avtrubbande..nn.1
  avtrubbning_1_N = mkN "avtrubbning" ; -- avtrubbning..nn.1
  avtryck_1_N = mkN "avtryck" neutrum  ; -- avtryck..nn.1
  avtryckare_1_N = mkN "avtryckare" utrum  ; -- avtryckare..nn.1
  avtryckning_1_N = mkN "avtryckning" ; -- avtryckning..nn.1
  avträda_1_V = mkV "avträda" "avträdde" "avträtt" ; -- avträda..vb.1
  avträdande_1_N = mkN "avträdande" ; -- avträdande..nn.1
  avträdare_1_N = mkN "avträdare" utrum  ; -- avträdare..nn.1
  avträde_1_N = mkN "avträde" ; -- avträde..nn.1
  avträdelse_1_N = mkN "avträdelse" "avträdelser" ; -- avträdelse..nn.1
  avtunna_1_V = mkV "avtunnar" ; -- avtunna..vb.1
  avtunnande_1_N = mkN "avtunnande" ; -- avtunnande..nn.1
  avtunning_1_N = mkN "avtunning" ; -- avtunning..nn.1
  avtvagning_1_N = mkN "avtvagning" ; -- avtvagning..nn.1
  avtvinga_1_V = mkV "avtvingar" ; -- avtvinga..vb.1
  avtvingande_1_N = mkN "avtvingande" ; -- avtvingande..nn.1
  avtvättning_1_N = mkN "avtvättning" ; -- avtvättning..nn.1
  avtvå_1_V = mkV "avtvår" ; -- avtvå..vb.1
  avtvående_1_N = mkN "avtvående" ; -- avtvående..nn.1
  avtyning_1_N = mkN "avtyning" ; -- avtyning..nn.1
  avtäcka_1_V = mkV "avtäcker" ; -- avtäcka..vb.1
  avtäckande_1_N = mkN "avtäckande" ; -- avtäckande..nn.1
  avtäckning_1_N = mkN "avtäckning" ; -- avtäckning..nn.1
  avtäckningsceremoni_1_N = mkN "avtäckningsceremoni" "avtäckningsceremonier" ; -- avtäckningsceremoni..nn.1
  avtändande_1_A = mkA "avtändande" ; -- avtändande..av.1
  avtärd_1_A = mkA "avtärd" "avtärt" ; -- avtärd..av.1
  avtärdhet_1_N = mkN "avtärdhet" ; -- avtärdhet..nn.1
  avtåg_1_N = mkN "avtåg" neutrum  ; -- avtåg..nn.1
  avtåga_1_V = mkV "avtågar" ; -- avtåga..vb.1
  avtågande_1_N = mkN "avtågande" ; -- avtågande..nn.1
  avulavirusinfektion_1_N = mkN "avulavirusinfektion" ; -- avulavirusinfektion..nn.1
  avund_1_N = mkN "avund" ; -- avund..nn.1
  avundsam_1_A = mkA "avundsam" "avundsamt" "avundsamma" "avundsamma" "avundsammare" "avundsammast" "avundsammaste" ; -- avundsam..av.1
  avundsamhet_1_N = mkN "avundsamhet" ; -- avundsamhet..nn.1
  avundsfri_1_A = mkA "avundsfri" "avundsfritt" ; -- avundsfri..av.1
  avundsfull_1_A = mkA "avundsfull" ; -- avundsfull..av.1
  avundsjuk_1_A = mkA "avundsjuk" ; -- avundsjuk..av.1
  avundsjuka_1_N = mkN "avundsjuka" ; -- avundsjuka..nn.1
  avundsjukhet_1_N = mkN "avundsjukhet" ; -- avundsjukhet..nn.1
  avundsman_1_N = mkN "avundsman" "avundsmannen" "avundsmän" "avundsmännen" ; -- avundsman..nn.1
  avundsvärd_1_A = mkA "avundsvärd" "avundsvärt" ; -- avundsvärd..av.1
  avundsvärdhet_1_N = mkN "avundsvärdhet" ; -- avundsvärdhet..nn.1
  avvakta_1_V = mkV "avvaktar" ; -- avvakta..vb.1
  avvaktande_1_N = mkN "avvaktande" ; -- avvaktande..nn.1
  avvara_1_V = mkV "avvarar" ; -- avvara..vb.1
  avvarad_1_A = mkA "avvarad" ; -- avvarad..av.1
  avvarande_1_N = mkN "avvarande" ; -- avvarande..nn.1
  avvattna_1_V = mkV "avvattnar" ; -- avvattna..vb.1
  avvattnande_1_N = mkN "avvattnande" ; -- avvattnande..nn.1
  avvattning_1_N = mkN "avvattning" ; -- avvattning..nn.1
  avveckla_1_V = mkV "avvecklar" ; -- avveckla..vb.1
  avvecklande_1_N = mkN "avvecklande" ; -- avvecklande..nn.1
  avveckling_1_N = mkN "avveckling" ; -- avveckling..nn.1
  avvecklingsbeslut_1_N = mkN "avvecklingsbeslut" neutrum  ; -- avvecklingsbeslut..nn.1
  avverka_1_V = mkV "avverkar" ; -- avverka..vb.1
  avverkande_1_N = mkN "avverkande" ; -- avverkande..nn.1
  avverkning_1_N = mkN "avverkning" ; -- avverkning..nn.1
  avverkningsarbete_1_N = mkN "avverkningsarbete" ; -- avverkningsarbete..nn.1
  avverkningsrätt_1_N = mkN "avverkningsrätt" "avverkningsrätter" ; -- avverkningsrätt..nn.1
  avvika_1_V = mkV "avvika" "avviker" "avvik" "avvek" "avvikt" "avviken" ; -- avvika..vb.1
  avvikande_1_A = mkA "avvikande" ; -- avvikande..av.1
  avvikande_1_N = mkN "avvikande" ; -- avvikande..nn.1
  avvikare_1_N = mkN "avvikare" utrum  ; -- avvikare..nn.1
  avvikelse_1_N = mkN "avvikelse" "avvikelser" ; -- avvikelse..nn.1
  avvikelseprocent_1_N = mkN "avvikelseprocent" "avvikelseprocenten" "avvikelseprocent" "avvikelseprocenten" ; -- avvikelseprocent..nn.1
  avviken_1_A = mkA "avviken" ; -- avviken..av.1
  avvindning_1_N = mkN "avvindning" ; -- avvindning..nn.1
  avvinna_1_V = mkV "avvinna" "avvann" "avvunnit" ; -- avvinna..vb.1
  avvinnande_1_N = mkN "avvinnande" ; -- avvinnande..nn.1
  avvisa_1_V = mkV "avvisar" ; -- avvisa..vb.1
  avvisande_1_N = mkN "avvisande" ; -- avvisande..nn.1
  avvisare_1_N = mkN "avvisare" utrum  ; -- avvisare..nn.1
  avvisning_1_N = mkN "avvisning" ; -- avvisning..nn.1
  avvisningsbeslut_1_N = mkN "avvisningsbeslut" neutrum  ; -- avvisningsbeslut..nn.1
  avvita_1_V = mkV "avvitar" ; -- avvita..vb.1
  avvitande_1_N = mkN "avvitande" ; -- avvitande..nn.1
  avvittra_1_V = mkV "avvittrar" ; -- avvittra..vb.1
  avvittrande_1_N = mkN "avvittrande" ; -- avvittrande..nn.1
  avväg_1_N = mkN "avväg" ; -- avväg..nn.1
  avväga_1_V = mkV "avväger" ; -- avväga..vb.1
  avvägande_1_N = mkN "avvägande" ; -- avvägande..nn.1
  avvägning_1_N = mkN "avvägning" ; -- avvägning..nn.1
  avvägningsinstrument_1_N = mkN "avvägningsinstrument" neutrum  ; -- avvägningsinstrument..nn.1
  avvältring_1_N = mkN "avvältring" ; -- avvältring..nn.1
  avvända_1_V = mkV "avvänder" ; -- avvända..vb.1
  avvändande_1_N = mkN "avvändande" ; -- avvändande..nn.1
  avvändning_1_N = mkN "avvändning" ; -- avvändning..nn.1
  avvänja_1_V = mkV "avvänja" "avvande" "avvant" ; -- avvänja..vb.1
  avvänjande_1_N = mkN "avvänjande" ; -- avvänjande..nn.1
  avvänjning_1_N = mkN "avvänjning" ; -- avvänjning..nn.1
  avvänjningstid_1_N = mkN "avvänjningstid" "avvänjningstider" ; -- avvänjningstid..nn.1
  avväpna_1_V = mkV "avväpnar" ; -- avväpna..vb.1
  avväpnande_1_A = mkA "avväpnande" ; -- avväpnande..av.1
  avväpnande_1_N = mkN "avväpnande" ; -- avväpnande..nn.1
  avvärja_1_V = mkV "avvärja" "avvärjde" "avvärjt" ; -- avvärja..vb.1
  avvärjande_1_N = mkN "avvärjande" ; -- avvärjande..nn.1
  avvärjning_1_N = mkN "avvärjning" ; -- avvärjning..nn.1
  avväxling_1_N = mkN "avväxling" ; -- avväxling..nn.1
  avytterlig_1_A = mkA "avytterlig" ; -- avytterlig..av.1
  avytterlighet_1_N = mkN "avytterlighet" ; -- avytterlighet..nn.1
  avyttra_1_V = mkV "avyttrar" ; -- avyttra..vb.1
  avyttrande_1_N = mkN "avyttrande" ; -- avyttrande..nn.1
  aväta_1_V = mkV "aväta" "avåt" "avätit" ; -- aväta..vb.1
  avätande_1_N = mkN "avätande" ; -- avätande..nn.1
  avåkning_1_N = mkN "avåkning" ; -- avåkning..nn.1
  ax_1_N = mkN "ax" neutrum  ; -- ax..nn.1
  ax_2_N = mkN "ax" neutrum  ; -- ax..nn.2
  axa_1_V = mkV "axar" ; -- axa..vb.1
  axande_1_N = mkN "axande" ; -- axande..nn.1
  axblommig_1_A = mkA "axblommig" ; -- axblommig..av.1
  axel_1_N = mkN "axel" ; -- axel..nn.1
  axelband_1_N = mkN "axelband" neutrum  ; -- axelband..nn.1
  axelbred_1_A = mkA "axelbred" "axelbrett" ; -- axelbred..av.1
  axelbössa_1_N = mkN "axelbössa" ; -- axelbössa..nn.1
  axeldiameter_1_N = mkN "axeldiameter" ; -- axeldiameter..nn.1
  axelfraktur_1_N = mkN "axelfraktur" "axelfrakturer" ; -- axelfraktur..nn.1
  axelgehäng_1_N = mkN "axelgehäng" neutrum  ; -- axelgehäng..nn.1
  axelhål_1_N = mkN "axelhål" neutrum  ; -- axelhål..nn.1
  axelhölster_1_N = mkN "axelhölster" neutrum  ; -- axelhölster..nn.1
  axelinflammation_1_N = mkN "axelinflammation" ; -- axelinflammation..nn.1
  axelklaff_1_N = mkN "axelklaff" ; -- axelklaff..nn.1
  axelkoppling_1_N = mkN "axelkoppling" ; -- axelkoppling..nn.1
  axellager_1_N = mkN "axellager" neutrum  ; -- axellager..nn.1
  axelled_1_N = mkN "axelled" "axelleder" ; -- axelled..nn.1
  axelledsdislokation_1_N = mkN "axelledsdislokation" ; -- axelledsdislokation..nn.1
  axelledsluxation_1_N = mkN "axelledsluxation" ; -- axelledsluxation..nn.1
  axellång_1_A = mkA "axellång" ; -- axellång..av.1
  axelmuff_1_N = mkN "axelmuff" ; -- axelmuff..nn.1
  axelrem_1_N = mkN "axelrem" "axelremmen" "axelremmar" "axelremmarna" ; -- axelrem..nn.1
  axelremsväska_1_N = mkN "axelremsväska" ; -- axelremsväska..nn.1
  axelriktning_1_N = mkN "axelriktning" ; -- axelriktning..nn.1
  axelring_1_N = mkN "axelring" ; -- axelring..nn.1
  axelryckning_1_N = mkN "axelryckning" ; -- axelryckning..nn.1
  axelset_1_N = mkN "axelset" neutrum  ; -- axelset..nn.1
  axelsmärta_1_N = mkN "axelsmärta" ; -- axelsmärta..nn.1
  axelsprint_1_N = mkN "axelsprint" ; -- axelsprint..nn.1
  axelvadd_1_N = mkN "axelvadd" ; -- axelvadd..nn.1
  axformig_1_A = mkA "axformig" ; -- axformig..av.1
  axial_1_A = mkA "axial" ; -- axial..av.1
  axillarkrycka_1_N = mkN "axillarkrycka" ; -- axillarkrycka..nn.1
  axiom_1_N = mkN "axiom" neutrum  ; -- axiom..nn.1
  axiomatisera_1_V = mkV "axiomatiserar" ; -- axiomatisera..vb.1
  axiomatiserande_1_N = mkN "axiomatiserande" ; -- axiomatiserande..nn.1
  axiomatiserbar_1_A = mkA "axiomatiserbar" ; -- axiomatiserbar..av.1
  axiomatiserbarhet_1_N = mkN "axiomatiserbarhet" ; -- axiomatiserbarhet..nn.1
  axiomatisering_1_N = mkN "axiomatisering" ; -- axiomatisering..nn.1
  axiomatisk_1_A = mkA "axiomatisk" ; -- axiomatisk..av.1
  axion_1_N = mkN "axion" ; -- axion..nn.1
  axionförtätning_1_N = mkN "axionförtätning" ; -- axionförtätning..nn.1
  axla_1_V = mkV "axlar" ; -- axla..vb.1
  axlande_1_N = mkN "axlande" ; -- axlande..nn.1
  axplock_1_N = mkN "axplock" neutrum  ; -- axplock..nn.1
  axsvingel_1_N = mkN "axsvingel" ; -- axsvingel..nn.1
  ayahuasca_1_N = mkN "ayahuasca" ; -- ayahuasca..nn.1
  ayatolla_1_N = mkN "ayatolla" ; -- ayatolla..nn.1
  ayatollah_1_N = mkN "ayatollah" ; -- ayatollah..nn.1
  ayrshireboskap_1_N = mkN "ayrshireboskap" ; -- ayrshireboskap..nn.1
  azalea_1_N = mkN "azalea" ; -- azalea..nn.1
  azerbajdzjan_1_N = mkN "azerbajdzjan" "azerbajdzjaner" ; -- azerbajdzjan..nn.1
  azerbajdzjansk_1_A = mkA "azerbajdzjansk" ; -- azerbajdzjansk..av.1
  azerbajdzjanska_1_N = mkN "azerbajdzjanska" ; -- azerbajdzjanska..nn.1
  azerbajdzjanska_2_N = mkN "azerbajdzjanska" ; -- azerbajdzjanska..nn.2
  azimut_1_N = mkN "azimut" ; -- azimut..nn.1
  azoospermi_1_N = mkN "azoospermi" ; -- azoospermi..nn.1
  azotemi_1_N = mkN "azotemi" ; -- azotemi..nn.1
  aztek_1_N = mkN "aztek" "azteker" ; -- aztek..nn.1
  aztekisk_1_A = mkA "aztekisk" ; -- aztekisk..av.1
  azur_1_N = mkN "azur" ; -- azur..nn.1
  azurblå_1_A = mkA "azurblå" "azurblått" ; -- azurblå..av.1
  azurfärg_1_N = mkN "azurfärg" ; -- azurfärg..nn.1
  ba_1_Adv = mkAdv "ba" ; -- ba..ab.1
  babbel_1_N = mkN "babbel" neutrum  ; -- babbel..nn.1
  babbla_1_V = mkV "babblar" ; -- babbla..vb.1
  babblande_1_N = mkN "babblande" ; -- babblande..nn.1
  babblare_1_N = mkN "babblare" utrum  ; -- babblare..nn.1
  babian_1_N = mkN "babian" "babianer" ; -- babian..nn.1
  babianröv_1_N = mkN "babianröv" ; -- babianröv..nn.1
  babord_1_Adv = mkAdv "babord" ; -- babord..ab.1
  babord_1_N = mkN "babord" ; -- babord..nn.1
  babordsida_1_N = mkN "babordsida" ; -- babordsida..nn.1
  babordsvakt_1_N = mkN "babordsvakt" "babordsvakter" ; -- babordsvakt..nn.1
  babordsåra_1_N = mkN "babordsåra" ; -- babordsåra..nn.1
  babusjka_1_N = mkN "babusjka" ; -- babusjka..nn.1
  baby_1_N = mkN "baby" "babyn" "babies" "babiesarna" ; -- baby..nn.1
  babyboom_1_N = mkN "babyboom" "babyboomer" ; -- babyboom..nn.1
  babybyxa_1_N = mkN "babybyxa" ; -- babybyxa..nn.1
  babydräkt_1_N = mkN "babydräkt" "babydräkter" ; -- babydräkt..nn.1
  babylonier_1_N = mkN "babylonier" "babyloniern" "babylonier" "babylonierna" ; -- babylonier..nn.1
  babylonisk_1_A = mkA "babylonisk" ; -- babylonisk..av.1
  babylycka_1_N = mkN "babylycka" ; -- babylycka..nn.1
  babysitter_1_N = mkN "babysitter" ; -- babysitter..nn.1
  babysketch_1_N = mkN "babysketch" "babysketcher" ; -- babysketch..nn.1
  baccarat_1_N = mkN "baccarat" ; -- baccarat..nn.1
  bacill_1_N = mkN "bacill" "baciller" ; -- bacill..nn.1
  bacillbärare_1_N = mkN "bacillbärare" utrum  ; -- bacillbärare..nn.1
  bacillfri_1_A = mkA "bacillfri" "bacillfritt" ; -- bacillfri..av.1
  bacillskräck_1_N = mkN "bacillskräck" ; -- bacillskräck..nn.1
  back_1_N = mkN "back" ; -- back..nn.1
  backa_1_N = mkN "backa" ; -- backa..nn.1
  backa_1_V = mkV "backar" ; -- backa..vb.1
  backa_2_V = mkV "backar" ; -- backa..vb.2
  backanal_1_N = mkN "backanal" "backanaler" ; -- backanal..nn.1
  backanalant_1_N = mkN "backanalant" "backanalanter" ; -- backanalant..nn.1
  backanalisk_1_A = mkA "backanalisk" ; -- backanalisk..av.1
  backande_1_N = mkN "backande" ; -- backande..nn.1
  backanis_1_N = mkN "backanis" ; -- backanis..nn.1
  backant_1_N = mkN "backant" "backanter" ; -- backant..nn.1
  backe_1_N = mkN "backe" utrum  ; -- backe..nn.1
  backfisch_1_N = mkN "backfisch" ; -- backfisch..nn.1
  backgammon_1_N = mkN "backgammon" ; -- backgammon..nn.1
  backhammer_1_N = mkN "backhammer" "backhammern" "backhamrar" "backhamrarna" ; -- backhammer..nn.1
  backhand_1_N = mkN "backhand" ; -- backhand..nn.1
  backhoppare_1_N = mkN "backhoppare" utrum  ; -- backhoppare..nn.1
  backhoppning_1_N = mkN "backhoppning" ; -- backhoppning..nn.1
  backig_1_A = mkA "backig" ; -- backig..av.1
  backighet_1_N = mkN "backighet" ; -- backighet..nn.1
  backkrön_1_N = mkN "backkrön" neutrum  ; -- backkrön..nn.1
  backlandskap_1_N = mkN "backlandskap" neutrum  ; -- backlandskap..nn.1
  backning_1_N = mkN "backning" ; -- backning..nn.1
  backpacker_1_N = mkN "backpacker" "backpackern" "backpackers" "backpackersarna" ; -- backpacker..nn.1
  backpacking_1_N = mkN "backpacking" ; -- backpacking..nn.1
  backsignal_1_N = mkN "backsignal" "backsignaler" ; -- backsignal..nn.1
  backsippa_1_N = mkN "backsippa" ; -- backsippa..nn.1
  backslag_1_N = mkN "backslag" neutrum  ; -- backslag..nn.1
  backspegel_1_N = mkN "backspegel" ; -- backspegel..nn.1
  backstag_1_N = mkN "backstag" neutrum  ; -- backstag..nn.1
  backström_1_N = mkN "backström" "backströmmen" "backströmmar" "backströmmarna" ; -- backström..nn.1
  backstuga_1_N = mkN "backstuga" ; -- backstuga..nn.1
  backstugusittare_1_N = mkN "backstugusittare" utrum  ; -- backstugusittare..nn.1
  backsvala_1_N = mkN "backsvala" ; -- backsvala..nn.1
  backsöta_1_N = mkN "backsöta" ; -- backsöta..nn.1
  backtimjan_1_N = mkN "backtimjan" ; -- backtimjan..nn.1
  backup_1_N = mkN "backup" "backupen" "backups" "backuperna" ; -- backup..nn.1
  backupa_1_V = mkV "backupar" ; -- backupa..vb.1
  backupande_1_N = mkN "backupande" ; -- backupande..nn.1
  backupp_1_N = mkN "backupp" "backuppen" "backupps" "backupperna" ; -- backupp..nn.1
  backuppa_1_V = mkV "backuppar" ; -- backuppa..vb.1
  backuppande_1_N = mkN "backuppande" ; -- backuppande..nn.1
  backvial_1_N = mkN "backvial" "backvialer" ; -- backvial..nn.1
  backväxel_1_N = mkN "backväxel" ; -- backväxel..nn.1
  bacon_1_N = mkN "bacon" ; -- bacon..nn.1
  bad_1_N = mkN "bad" neutrum  ; -- bad..nn.1
  bada_1_V = mkV "badar" ; -- bada..vb.1
  badande_1_N = mkN "badande" ; -- badande..nn.1
  badanka_1_N = mkN "badanka" ; -- badanka..nn.1
  badanläggning_1_N = mkN "badanläggning" ; -- badanläggning..nn.1
  badanstalt_1_N = mkN "badanstalt" "badanstalter" ; -- badanstalt..nn.1
  badare_1_N = mkN "badare" utrum  ; -- badare..nn.1
  badbassäng_1_N = mkN "badbassäng" "badbassänger" ; -- badbassäng..nn.1
  badbild_1_N = mkN "badbild" "badbilder" ; -- badbild..nn.1
  badborste_1_N = mkN "badborste" utrum  ; -- badborste..nn.1
  badbyxa_1_N = mkN "badbyxa" ; -- badbyxa..nn.1
  badda_1_V = mkV "baddar" ; -- badda..vb.1
  baddande_1_N = mkN "baddande" ; -- baddande..nn.1
  baddare_1_N = mkN "baddare" utrum  ; -- baddare..nn.1
  baddjävel_1_N = mkN "baddjävel" ; -- baddjävel..nn.1
  baddning_1_N = mkN "baddning" ; -- baddning..nn.1
  baddräkt_1_N = mkN "baddräkt" "baddräkter" ; -- baddräkt..nn.1
  badensare_1_N = mkN "badensare" utrum  ; -- badensare..nn.1
  badensisk_1_A = mkA "badensisk" ; -- badensisk..av.1
  badflicka_1_N = mkN "badflicka" ; -- badflicka..nn.1
  badförbud_1_N = mkN "badförbud" neutrum  ; -- badförbud..nn.1
  badgäst_1_N = mkN "badgäst" "badgäster" ; -- badgäst..nn.1
  badhandduk_1_N = mkN "badhandduk" ; -- badhandduk..nn.1
  badhus_1_N = mkN "badhus" neutrum  ; -- badhus..nn.1
  badhytt_1_N = mkN "badhytt" "badhytter" ; -- badhytt..nn.1
  badinrättning_1_N = mkN "badinrättning" ; -- badinrättning..nn.1
  badkappa_1_N = mkN "badkappa" ; -- badkappa..nn.1
  badkar_1_N = mkN "badkar" neutrum  ; -- badkar..nn.1
  badkarseffekt_1_N = mkN "badkarseffekt" "badkarseffekter" ; -- badkarseffekt..nn.1
  badkarskant_1_N = mkN "badkarskant" "badkarskanter" ; -- badkarskant..nn.1
  badklippa_1_N = mkN "badklippa" ; -- badklippa..nn.1
  badlakan_1_N = mkN "badlakan" neutrum  ; -- badlakan..nn.1
  badläkare_1_N = mkN "badläkare" utrum  ; -- badläkare..nn.1
  badminton_1_N = mkN "badminton" ; -- badminton..nn.1
  badmintonboll_1_N = mkN "badmintonboll" ; -- badmintonboll..nn.1
  badmintonrack_1_N = mkN "badmintonrack" ; -- badmintonrack..nn.1
  badmintonracket_1_N = mkN "badmintonracket" ; -- badmintonracket..nn.1
  badmössa_1_N = mkN "badmössa" ; -- badmössa..nn.1
  badning_1_N = mkN "badning" ; -- badning..nn.1
  badort_1_N = mkN "badort" "badorter" ; -- badort..nn.1
  badortsliv_1_N = mkN "badortsliv" neutrum  ; -- badortsliv..nn.1
  badortsstad_1_N = mkN "badortsstad" "badortsstäder" ; -- badortsstad..nn.1
  badplats_1_N = mkN "badplats" "badplatser" ; -- badplats..nn.1
  badresa_1_N = mkN "badresa" ; -- badresa..nn.1
  badrum_1_N = mkN "badrum" "badrummet" "badrum" "badrummen" ; -- badrum..nn.1
  badrumsdörr_1_N = mkN "badrumsdörr" ; -- badrumsdörr..nn.1
  badrumsfläkt_1_N = mkN "badrumsfläkt" ; -- badrumsfläkt..nn.1
  badrumsfärg_1_N = mkN "badrumsfärg" "badrumsfärger" ; -- badrumsfärg..nn.1
  badrumsgolv_1_N = mkN "badrumsgolv" neutrum  ; -- badrumsgolv..nn.1
  badrumskakel_1_N = mkN "badrumskakel" neutrum  ; -- badrumskakel..nn.1
  badrumsmöbel_1_N = mkN "badrumsmöbel" "badrumsmöbeln" "badrumsmöbler" "badrumsmöblerna" ; -- badrumsmöbel..nn.1
  badrumsskåp_1_N = mkN "badrumsskåp" neutrum  ; -- badrumsskåp..nn.1
  badrumsspegel_1_N = mkN "badrumsspegel" ; -- badrumsspegel..nn.1
  badsalt_1_N = mkN "badsalt" "badsaltet" "badsalter" "badsalterna" ; -- badsalt..nn.1
  badsemester_1_N = mkN "badsemester" ; -- badsemester..nn.1
  badsjö_1_N = mkN "badsjö" ; -- badsjö..nn.1
  badsko_1_N = mkN "badsko" "badskor" ; -- badsko..nn.1
  badstrand_1_N = mkN "badstrand" "badstränder" ; -- badstrand..nn.1
  badstuga_1_N = mkN "badstuga" ; -- badstuga..nn.1
  badställe_1_N = mkN "badställe" ; -- badställe..nn.1
  badtoffel_1_N = mkN "badtoffla" ; -- badtoffel..nn.1
  badtunna_1_N = mkN "badtunna" ; -- badtunna..nn.1
  badturist_1_N = mkN "badturist" "badturister" ; -- badturist..nn.1
  badvakt_1_N = mkN "badvakt" "badvakter" ; -- badvakt..nn.1
  badvatten_1_N = mkN "badvatten" "badvattnet" "badvatten" "badvattnen" ; -- badvatten..nn.1
  bag_in_box_1_N = mkN "bag-in-box" ; -- bag-in-box..nn.1
  bag_1_N = mkN "bag" ; -- bag..nn.1
  bagage_1_N = mkN "bagage" ; -- bagage..nn.1
  bagage_2_N = mkN "bagage" ; -- bagage..nn.2
  bagagehylla_1_N = mkN "bagagehylla" ; -- bagagehylla..nn.1
  bagageinlämning_1_N = mkN "bagageinlämning" ; -- bagageinlämning..nn.1
  bagagekärra_1_N = mkN "bagagekärra" ; -- bagagekärra..nn.1
  bagagelucka_1_N = mkN "bagagelucka" ; -- bagagelucka..nn.1
  bagagerum_1_N = mkN "bagagerum" "bagagerummet" "bagagerum" "bagagerummen" ; -- bagagerum..nn.1
  bagagestropp_1_N = mkN "bagagestropp" ; -- bagagestropp..nn.1
  bagageutrymme_1_N = mkN "bagageutrymme" ; -- bagageutrymme..nn.1
  bagagevagn_1_N = mkN "bagagevagn" ; -- bagagevagn..nn.1
  bagarbod_1_N = mkN "bagarbod" ; -- bagarbod..nn.1
  bagare_1_N = mkN "bagare" utrum  ; -- bagare..nn.1
  bagarmössa_1_N = mkN "bagarmössa" ; -- bagarmössa..nn.1
  bagarstuga_1_N = mkN "bagarstuga" ; -- bagarstuga..nn.1
  bagatell_1_N = mkN "bagatell" "bagateller" ; -- bagatell..nn.1
  bagatellartad_1_A = mkA "bagatellartad" ; -- bagatellartad..av.1
  bagatellisera_1_V = mkV "bagatelliserar" ; -- bagatellisera..vb.1
  bagatelliserande_1_N = mkN "bagatelliserande" ; -- bagatelliserande..nn.1
  bagatelliserbar_1_A = mkA "bagatelliserbar" ; -- bagatelliserbar..av.1
  bagatelliserbarhet_1_N = mkN "bagatelliserbarhet" ; -- bagatelliserbarhet..nn.1
  bagatellisering_1_N = mkN "bagatellisering" ; -- bagatellisering..nn.1
  bagatellmål_1_N = mkN "bagatellmål" neutrum  ; -- bagatellmål..nn.1
  bagel_1_N = mkN "bagel" "bageln" "bagels" "bagelsarna" ; -- bagel..nn.1
  bageri_1_N = mkN "bageri" "bageriet" "bagerier" "bagerierna" ; -- bageri..nn.1
  bagerimargarin_1_N = mkN "bagerimargarin" "bagerimargarinet" "bagerimargariner" "bagerimargarinerna" ; -- bagerimargarin..nn.1
  bagerirörelse_1_N = mkN "bagerirörelse" "bagerirörelser" ; -- bagerirörelse..nn.1
  bagg_1_N = mkN "bagg" ; -- bagg..nn.1
  baggböla_1_V = mkV "baggbölar" ; -- baggböla..vb.1
  baggbölande_1_N = mkN "baggbölande" ; -- baggbölande..nn.1
  baggbölare_1_N = mkN "baggbölare" utrum  ; -- baggbölare..nn.1
  baggböleri_1_N = mkN "baggböleri" neutrum  ; -- baggböleri..nn.1
  bagge_1_N = mkN "bagge" utrum  ; -- bagge..nn.1
  bagis_1_N = mkN "bagis" ; -- bagis..nn.1
  baguette_1_N = mkN "baguette" "baguetter" ; -- baguette..nn.1
  bahaman_1_N = mkN "bahaman" "bahamaner" ; -- bahaman..nn.1
  bahamansk_1_A = mkA "bahamansk" ; -- bahamansk..av.1
  bahamanska_1_N = mkN "bahamanska" ; -- bahamanska..nn.1
  bahrainare_1_N = mkN "bahrainare" utrum  ; -- bahrainare..nn.1
  bahrainsk_1_A = mkA "bahrainsk" ; -- bahrainsk..av.1
  bahrainska_1_N = mkN "bahrainska" ; -- bahrainska..nn.1
  bahytt_1_N = mkN "bahytt" "bahytter" ; -- bahytt..nn.1
  baissa_1_V = mkV "baissar" ; -- baissa..vb.1
  baissande_1_N = mkN "baissande" ; -- baissande..nn.1
  baisse_1_N = mkN "baisse" "baisser" ; -- baisse..nn.1
  baissespekulation_1_N = mkN "baissespekulation" ; -- baissespekulation..nn.1
  baja_maja_1_N = mkN "baja-maja" ; -- baja-maja..nn.1
  baja_1_V = mkV "bajar" ; -- baja..vb.1
  bajadär_1_N = mkN "bajadär" "bajadärer" ; -- bajadär..nn.1
  bajamaja_1_N = mkN "bajamaja" ; -- bajamaja..nn.1
  bajande_1_N = mkN "bajande" ; -- bajande..nn.1
  bajersk_1_A = mkA "bajersk" ; -- bajersk..av.1
  bajonett_1_N = mkN "bajonett" "bajonetter" ; -- bajonett..nn.1
  bajonettanfall_1_N = mkN "bajonettanfall" neutrum  ; -- bajonettanfall..nn.1
  bajonettbalja_1_N = mkN "bajonettbalja" ; -- bajonettbalja..nn.1
  bajonettfattning_1_N = mkN "bajonettfattning" ; -- bajonettfattning..nn.1
  bajonettförsedd_1_A = mkA "bajonettförsedd" ; -- bajonettförsedd..av.1
  bajonettspets_1_N = mkN "bajonettspets" ; -- bajonettspets..nn.1
  bajrare_1_N = mkN "bajrare" utrum  ; -- bajrare..nn.1
  bajs_1_N = mkN "bajs" neutrum  ; -- bajs..nn.1
  bajsa_1_V = mkV "bajsar" ; -- bajsa..vb.1
  bajsande_1_N = mkN "bajsande" ; -- bajsande..nn.1
  bajsbrun_1_A = mkA "bajsbrun" ; -- bajsbrun..av.1
  bajshög_1_N = mkN "bajshög" ; -- bajshög..nn.1
  bajsig_1_A = mkA "bajsig" ; -- bajsig..av.1
  bajskorv_1_N = mkN "bajskorv" ; -- bajskorv..nn.1
  bajsnödig_1_A = mkA "bajsnödig" ; -- bajsnödig..av.1
  bajstransplantat_1_N = mkN "bajstransplantat" neutrum  ; -- bajstransplantat..nn.1
  bajstransplantation_1_N = mkN "bajstransplantation" ; -- bajstransplantation..nn.1
  bak_1_N = mkN "bak" ; -- bak..nn.1
  bak_2_N = mkN "bak" neutrum  ; -- bak..nn.2
  baka_1_V = mkV "bakar" ; -- baka..vb.1
  bakande_1_N = mkN "bakande" ; -- bakande..nn.1
  bakarv_1_N = mkN "bakarv" neutrum  ; -- bakarv..nn.1
  bakarvinge_1_N = mkN "bakarvinge" utrum  ; -- bakarvinge..nn.1
  bakaxel_1_N = mkN "bakaxel" ; -- bakaxel..nn.1
  bakaxelväxel_1_N = mkN "bakaxelväxel" ; -- bakaxelväxel..nn.1
  bakben_1_N = mkN "bakben" neutrum  ; -- bakben..nn.1
  bakbinda_1_V = mkV "bakbinda" "bakband" "bakbundit" ; -- bakbinda..vb.1
  bakbindande_1_N = mkN "bakbindande" ; -- bakbindande..nn.1
  bakbindning_1_N = mkN "bakbindning" ; -- bakbindning..nn.1
  bakblåsare_1_N = mkN "bakblåsare" utrum  ; -- bakblåsare..nn.1
  bakdanta_1_V = mkV "bakdantar" ; -- bakdanta..vb.1
  bakdantande_1_N = mkN "bakdantande" ; -- bakdantande..nn.1
  bakdantare_1_N = mkN "bakdantare" utrum  ; -- bakdantare..nn.1
  bakdanteri_1_N = mkN "bakdanteri" neutrum  ; -- bakdanteri..nn.1
  bakdel_1_N = mkN "bakdel" "bakdelen" "bakdelar" "bakdelarna" ; -- bakdel..nn.1
  bakdäck_1_N = mkN "bakdäck" neutrum  ; -- bakdäck..nn.1
  bakdörr_1_N = mkN "bakdörr" ; -- bakdörr..nn.1
  bakelit_1_N = mkN "bakelit" ; -- bakelit..nn.1
  bakelse_1_N = mkN "bakelse" "bakelser" ; -- bakelse..nn.1
  bakerst_1_Adv = mkAdv "bakerst" ; -- bakerst..ab.1
  bakersta_1_A = mkA "bakersta" ; -- bakersta..av.1
  bakficka_1_N = mkN "bakficka" ; -- bakficka..nn.1
  bakflygel_1_N = mkN "bakflygel" ; -- bakflygel..nn.1
  bakfot_1_N = mkN "bakfot" "bakfötter" ; -- bakfot..nn.1
  bakfull_1_A = mkA "bakfull" ; -- bakfull..av.1
  bakfullhet_1_N = mkN "bakfullhet" ; -- bakfullhet..nn.1
  bakfylla_1_N = mkN "bakfylla" ; -- bakfylla..nn.1
  bakgata_1_N = mkN "bakgata" ; -- bakgata..nn.1
  bakgrund_1_N = mkN "bakgrund" "bakgrunder" ; -- bakgrund..nn.1
  bakgrundsfigur_1_N = mkN "bakgrundsfigur" "bakgrundsfigurer" ; -- bakgrundsfigur..nn.1
  bakgrundsljud_1_N = mkN "bakgrundsljud" neutrum  ; -- bakgrundsljud..nn.1
  bakgrundsmusik_1_N = mkN "bakgrundsmusik" ; -- bakgrundsmusik..nn.1
  bakgrundsreportage_1_N = mkN "bakgrundsreportage" "bakgrundsreportaget" "bakgrundsreportage" "bakgrundsreportagen" ; -- bakgrundsreportage..nn.1
  bakgrundsskildring_1_N = mkN "bakgrundsskildring" ; -- bakgrundsskildring..nn.1
  bakgrundssorl_1_N = mkN "bakgrundssorl" neutrum  ; -- bakgrundssorl..nn.1
  bakgrundsstrålning_1_N = mkN "bakgrundsstrålning" ; -- bakgrundsstrålning..nn.1
  bakgrundstal_1_N = mkN "bakgrundstal" neutrum  ; -- bakgrundstal..nn.1
  bakgrundston_1_N = mkN "bakgrundston" "bakgrundstoner" ; -- bakgrundston..nn.1
  bakgrundsvariabel_1_N = mkN "bakgrundsvariabel" "bakgrundsvariabeln" "bakgrundsvariabler" "bakgrundsvariablerna" ; -- bakgrundsvariabel..nn.1
  bakgård_1_N = mkN "bakgård" ; -- bakgård..nn.1
  bakhal_1_A = mkA "bakhal" ; -- bakhal..av.1
  bakhas_1_N = mkN "bakhas" ; -- bakhas..nn.1
  bakhjul_1_N = mkN "bakhjul" neutrum  ; -- bakhjul..nn.1
  bakhjulsdriven_1_A = mkA "bakhjulsdriven" ; -- bakhjulsdriven..av.1
  bakhov_1_N = mkN "bakhov" ; -- bakhov..nn.1
  bakhuvud_1_N = mkN "bakhuvud" "bakhuvudet" "bakhuvud" "bakhuvudena" ; -- bakhuvud..nn.1
  bakhåll_1_N = mkN "bakhåll" neutrum  ; -- bakhåll..nn.1
  baki_1_Adv = mkAdv "baki" ; -- baki..ab.1
  bakifrån_1_Adv = mkAdv "bakifrån" ; -- bakifrån..ab.1
  bakis_1_A = mkA "bakis" ; -- bakis..av.1
  bakjour_1_N = mkN "bakjour" "bakjourer" ; -- bakjour..nn.1
  bakkant_1_N = mkN "bakkant" "bakkanter" ; -- bakkant..nn.1
  bakkappa_1_N = mkN "bakkappa" ; -- bakkappa..nn.1
  bakkropp_1_N = mkN "bakkropp" ; -- bakkropp..nn.1
  bakladdare_1_N = mkN "bakladdare" utrum  ; -- bakladdare..nn.1
  bakladdning_1_N = mkN "bakladdning" ; -- bakladdning..nn.1
  baklampa_1_N = mkN "baklampa" ; -- baklampa..nn.1
  bakland_1_N = mkN "bakland" neutrum  ; -- bakland..nn.1
  bakljus_1_N = mkN "bakljus" neutrum  ; -- bakljus..nn.1
  bakljusramp_1_N = mkN "bakljusramp" "bakljusramper" ; -- bakljusramp..nn.1
  baklucka_1_N = mkN "baklucka" ; -- baklucka..nn.1
  baklukt_1_N = mkN "baklukt" ; -- baklukt..nn.1
  baklängesordbok_1_N = mkN "baklängesordbok" "baklängesordböcker" ; -- baklängesordbok..nn.1
  baklängesvandring_1_N = mkN "baklängesvandring" ; -- baklängesvandring..nn.1
  bakläxa_1_N = mkN "bakläxa" ; -- bakläxa..nn.1
  bakning_1_N = mkN "bakning" ; -- bakning..nn.1
  bakom_1_A = mkA "bakom" ; -- bakom..av.1
  bakomliggande_1_A = mkA "bakomliggande" ; -- bakomliggande..av.1
  bakomsittande_1_A = mkA "bakomsittande" ; -- bakomsittande..av.1
  bakomvarande_1_A = mkA "bakomvarande" ; -- bakomvarande..av.1
  bakplåt_1_N = mkN "bakplåt" ; -- bakplåt..nn.1
  bakplåtspapper_1_N = mkN "bakplåtspapper" neutrum  ; -- bakplåtspapper..nn.1
  bakport_1_N = mkN "bakport" ; -- bakport..nn.1
  bakprojektion_1_N = mkN "bakprojektion" ; -- bakprojektion..nn.1
  bakpulver_1_N = mkN "bakpulver" neutrum  ; -- bakpulver..nn.1
  bakpå_1_Adv = mkAdv "bakpå" ; -- bakpå..ab.1
  bakrus_1_N = mkN "bakrus" neutrum  ; -- bakrus..nn.1
  bakruta_1_N = mkN "bakruta" ; -- bakruta..nn.1
  baksida_1_N = mkN "baksida" ; -- baksida..nn.1
  baksidesreklam_1_N = mkN "baksidesreklam" ; -- baksidesreklam..nn.1
  baksidestext_1_N = mkN "baksidestext" "baksidestexter" ; -- baksidestext..nn.1
  bakslag_1_N = mkN "bakslag" neutrum  ; -- bakslag..nn.1
  bakslagsventil_1_N = mkN "bakslagsventil" "bakslagsventiler" ; -- bakslagsventil..nn.1
  bakslug_1_A = mkA "bakslug" ; -- bakslug..av.1
  bakslughet_1_N = mkN "bakslughet" ; -- bakslughet..nn.1
  baksmälla_1_N = mkN "baksmälla" ; -- baksmälla..nn.1
  bakspår_1_N = mkN "bakspår" neutrum  ; -- bakspår..nn.1
  baksteg_1_N = mkN "baksteg" neutrum  ; -- baksteg..nn.1
  bakstreck_1_N = mkN "bakstreck" neutrum  ; -- bakstreck..nn.1
  baksträvare_1_N = mkN "baksträvare" utrum  ; -- baksträvare..nn.1
  bakström_1_N = mkN "bakström" "bakströmmen" "bakströmmar" "bakströmmarna" ; -- bakström..nn.1
  bakstycke_1_N = mkN "bakstycke" ; -- bakstycke..nn.1
  baksäte_1_N = mkN "baksäte" ; -- baksäte..nn.1
  baktal_1_N = mkN "baktal" neutrum  ; -- baktal..nn.1
  baktala_1_V = mkV "baktalar" ; -- baktala..vb.1
  baktalande_1_N = mkN "baktalande" ; -- baktalande..nn.1
  baktalare_1_N = mkN "baktalare" utrum  ; -- baktalare..nn.1
  baktanke_1_N = mkN "baktanke" utrum  ; -- baktanke..nn.1
  baktass_1_N = mkN "baktass" ; -- baktass..nn.1
  baktericid_1_A = mkA "baktericid" ; -- baktericid..av.1
  baktericid_1_N = mkN "baktericid" "baktericider" ; -- baktericid..nn.1
  bakterie_1_N = mkN "bakterie" "bakterier" ; -- bakterie..nn.1
  bakterieart_1_N = mkN "bakterieart" "bakteriearter" ; -- bakterieart..nn.1
  bakteriedödande_1_A = mkA "bakteriedödande" ; -- bakteriedödande..av.1
  bakterieflora_1_N = mkN "bakterieflora" ; -- bakterieflora..nn.1
  bakteriefri_1_A = mkA "bakteriefri" "bakteriefritt" ; -- bakteriefri..av.1
  bakteriehärd_1_N = mkN "bakteriehärd" ; -- bakteriehärd..nn.1
  bakterieinfektion_1_N = mkN "bakterieinfektion" ; -- bakterieinfektion..nn.1
  bakteriekultur_1_N = mkN "bakteriekultur" "bakteriekulturer" ; -- bakteriekultur..nn.1
  bakteriell_1_A = mkA "bakteriell" ; -- bakteriell..av.1
  bakteriesmittad_1_A = mkA "bakteriesmittad" ; -- bakteriesmittad..av.1
  bakteriofag_1_N = mkN "bakteriofag" "bakteriofager" ; -- bakteriofag..nn.1
  bakteriolog_1_N = mkN "bakteriolog" "bakteriologer" ; -- bakteriolog..nn.1
  bakteriologi_1_N = mkN "bakteriologi" ; -- bakteriologi..nn.1
  bakteriologisk_1_A = mkA "bakteriologisk" ; -- bakteriologisk..av.1
  baktill_1_Adv = mkAdv "baktill" ; -- baktill..ab.1
  baktrappa_1_N = mkN "baktrappa" ; -- baktrappa..nn.1
  baktung_1_A = mkA "baktung" ; -- baktung..av.1
  baktunghet_1_N = mkN "baktunghet" ; -- baktunghet..nn.1
  bakugn_1_N = mkN "bakugn" ; -- bakugn..nn.1
  bakut_1_Adv = mkAdv "bakut" ; -- bakut..ab.1
  bakvagn_1_N = mkN "bakvagn" ; -- bakvagn..nn.1
  bakvatten_1_N = mkN "bakvatten" "bakvattnet" "bakvatten" "bakvattnen" ; -- bakvatten..nn.1
  bakverk_1_N = mkN "bakverk" neutrum  ; -- bakverk..nn.1
  bakvid_1_Adv = mkAdv "bakvid" ; -- bakvid..ab.1
  bakvikt_1_N = mkN "bakvikt" "bakvikter" ; -- bakvikt..nn.1
  bakvinge_1_N = mkN "bakvinge" utrum  ; -- bakvinge..nn.1
  bakväg_1_N = mkN "bakväg" ; -- bakväg..nn.1
  bakvägg_1_N = mkN "bakvägg" ; -- bakvägg..nn.1
  bakvänd_1_A = mkA "bakvänd" ; -- bakvänd..av.1
  bakvändhet_1_N = mkN "bakvändhet" ; -- bakvändhet..nn.1
  bakända_1_N = mkN "bakända" ; -- bakända..nn.1
  bakände_1_N = mkN "bakände" utrum  ; -- bakände..nn.1
  bakåtblickande_1_A = mkA "bakåtblickande" ; -- bakåtblickande..av.1
  bakåtkammad_1_A = mkA "bakåtkammad" ; -- bakåtkammad..av.1
  bakåtlutad_1_A = mkA "bakåtlutad" ; -- bakåtlutad..av.1
  bakåtriktad_1_A = mkA "bakåtriktad" ; -- bakåtriktad..av.1
  bakåträknande_1_A = mkA "bakåträknande" ; -- bakåträknande..av.1
  bakåtsteg_1_N = mkN "bakåtsteg" neutrum  ; -- bakåtsteg..nn.1
  bakåtsträvande_1_A = mkA "bakåtsträvande" ; -- bakåtsträvande..av.1
  bakåtsträvare_1_N = mkN "bakåtsträvare" utrum  ; -- bakåtsträvare..nn.1
  baköver_1_Adv = mkAdv "baköver" ; -- baköver..ab.1
  bal_1_N = mkN "bal" ; -- bal..nn.1
  bal_2_N = mkN "bal" "baler" ; -- bal..nn.2
  bala_1_V = mkV "balar" ; -- bala..vb.1
  balaclava_1_N = mkN "balaclava" ; -- balaclava..nn.1
  balaklava_1_N = mkN "balaklava" ; -- balaklava..nn.1
  balalajka_1_N = mkN "balalajka" ; -- balalajka..nn.1
  balalajkaspelare_1_N = mkN "balalajkaspelare" utrum  ; -- balalajkaspelare..nn.1
  balande_1_N = mkN "balande" ; -- balande..nn.1
  balans_1_N = mkN "balans" "balanser" ; -- balans..nn.1
  balans_2_N = mkN "balans" ; -- balans..nn.2
  balansakt_1_N = mkN "balansakt" "balansakter" ; -- balansakt..nn.1
  balansera_1_V = mkV "balanserar" ; -- balansera..vb.1
  balansera_2_V = mkV "balanserar" ; -- balansera..vb.2
  balanserad_1_A = mkA "balanserad" ; -- balanserad..av.1
  balanserande_1_N = mkN "balanserande" ; -- balanserande..nn.1
  balanserbar_1_A = mkA "balanserbar" ; -- balanserbar..av.1
  balanserbarhet_1_N = mkN "balanserbarhet" ; -- balanserbarhet..nn.1
  balansering_1_N = mkN "balansering" ; -- balansering..nn.1
  balanserstång_1_N = mkN "balanserstång" "balanserstänger" ; -- balanserstång..nn.1
  balansgång_1_N = mkN "balansgång" ; -- balansgång..nn.1
  balanshjul_1_N = mkN "balanshjul" neutrum  ; -- balanshjul..nn.1
  balanskonstnär_1_N = mkN "balanskonstnär" "balanskonstnärer" ; -- balanskonstnär..nn.1
  balanskonto_1_N = mkN "balanskonto" "balanskontot" "balanskonton" "balanskontona" ; -- balanskonto..nn.1
  balansnummer_1_N = mkN "balansnummer" neutrum  ; -- balansnummer..nn.1
  balansorgan_1_N = mkN "balansorgan" neutrum  ; -- balansorgan..nn.1
  balansplog_1_N = mkN "balansplog" ; -- balansplog..nn.1
  balansroder_1_N = mkN "balansroder" neutrum  ; -- balansroder..nn.1
  balansrubbning_1_N = mkN "balansrubbning" ; -- balansrubbning..nn.1
  balansräkning_1_N = mkN "balansräkning" ; -- balansräkning..nn.1
  balanssinne_1_N = mkN "balanssinne" ; -- balanssinne..nn.1
  balansvåg_1_N = mkN "balansvåg" ; -- balansvåg..nn.1
  balata_1_N = mkN "balata" ; -- balata..nn.1
  baldakin_1_N = mkN "baldakin" "baldakiner" ; -- baldakin..nn.1
  baldersbrå_1_N = mkN "baldersbrå" "baldersbråt" "baldersbrån" "baldersbråna" ; -- baldersbrå..nn.1
  baldrottning_1_N = mkN "baldrottning" ; -- baldrottning..nn.1
  bale_1_N = mkN "bale" utrum  ; -- bale..nn.1
  balett_1_N = mkN "balett" "baletter" ; -- balett..nn.1
  balettdans_1_N = mkN "balettdans" "balettdanser" ; -- balettdans..nn.1
  balettdansör_1_N = mkN "balettdansör" "balettdansörer" ; -- balettdansör..nn.1
  balettdansös_1_N = mkN "balettdansös" "balettdansöser" ; -- balettdansös..nn.1
  balettflicka_1_N = mkN "balettflicka" ; -- balettflicka..nn.1
  balettmästare_1_N = mkN "balettmästare" utrum  ; -- balettmästare..nn.1
  balgäst_1_N = mkN "balgäst" "balgäster" ; -- balgäst..nn.1
  balinesisk_1_A = mkA "balinesisk" ; -- balinesisk..av.1
  balja_1_N = mkN "balja" ; -- balja..nn.1
  baljväxt_1_N = mkN "baljväxt" "baljväxter" ; -- baljväxt..nn.1
  balk_1_N = mkN "balk" ; -- balk..nn.1
  balkanfolk_1_N = mkN "balkanfolk" neutrum  ; -- balkanfolk..nn.1
  balkaniserad_1_A = mkA "balkaniserad" ; -- balkaniserad..av.1
  balkanisering_1_N = mkN "balkanisering" ; -- balkanisering..nn.1
  balkansk_1_A = mkA "balkansk" ; -- balkansk..av.1
  balkknä_1_N = mkN "balkknä" "balkknät" "balkknän" "balkknäna" ; -- balkknä..nn.1
  balklänning_1_N = mkN "balklänning" ; -- balklänning..nn.1
  balkmått_1_N = mkN "balkmått" neutrum  ; -- balkmått..nn.1
  balkong_1_N = mkN "balkong" "balkonger" ; -- balkong..nn.1
  balkongdörr_1_N = mkN "balkongdörr" ; -- balkongdörr..nn.1
  balkonglåda_1_N = mkN "balkonglåda" ; -- balkonglåda..nn.1
  balkongräcke_1_N = mkN "balkongräcke" ; -- balkongräcke..nn.1
  balksko_1_N = mkN "balksko" "balkskor" ; -- balksko..nn.1
  balkverk_1_N = mkN "balkverk" neutrum  ; -- balkverk..nn.1
  balkvägare_1_N = mkN "balkvägare" utrum  ; -- balkvägare..nn.1
  ball_1_A = mkA "ball" ; -- ball..av.1
  ballad_1_N = mkN "ballad" "ballader" ; -- ballad..nn.1
  balladdiktning_1_N = mkN "balladdiktning" ; -- balladdiktning..nn.1
  ballast_1_N = mkN "ballast" "ballaster" ; -- ballast..nn.1
  balle_1_N = mkN "balle" utrum  ; -- balle..nn.1
  ballerina_1_N = mkN "ballerina" ; -- ballerina..nn.1
  ballhet_1_N = mkN "ballhet" ; -- ballhet..nn.1
  ballistik_1_N = mkN "ballistik" ; -- ballistik..nn.1
  ballistisk_1_A = mkA "ballistisk" ; -- ballistisk..av.1
  ballograf_1_N = mkN "ballograf" "ballografer" ; -- ballograf..nn.1
  ballong_1_N = mkN "ballong" "ballonger" ; -- ballong..nn.1
  ballongbluff_1_N = mkN "ballongbluff" ; -- ballongbluff..nn.1
  ballongboll_1_N = mkN "ballongboll" ; -- ballongboll..nn.1
  ballongburen_1_A = mkA "ballongburen" ; -- ballongburen..av.1
  ballongdäck_1_N = mkN "ballongdäck" neutrum  ; -- ballongdäck..nn.1
  ballongfamilj_1_N = mkN "ballongfamilj" "ballongfamiljer" ; -- ballongfamilj..nn.1
  ballongfärd_1_N = mkN "ballongfärd" "ballongfärder" ; -- ballongfärd..nn.1
  ballonggas_1_N = mkN "ballonggas" "ballonggaser" ; -- ballonggas..nn.1
  ballonggondol_1_N = mkN "ballonggondol" "ballonggondoler" ; -- ballonggondol..nn.1
  ballongmage_1_N = mkN "ballongmage" utrum  ; -- ballongmage..nn.1
  ballongpojke_1_N = mkN "ballongpojke" utrum  ; -- ballongpojke..nn.1
  ballongprick_1_N = mkN "ballongprick" ; -- ballongprick..nn.1
  ballongsegel_1_N = mkN "ballongsegel" neutrum  ; -- ballongsegel..nn.1
  ballongvisp_1_N = mkN "ballongvisp" ; -- ballongvisp..nn.1
  balloptikon_1_N = mkN "balloptikon" neutrum  ; -- balloptikon..nn.1
  ballotera_1_V = mkV "balloterar" ; -- ballotera..vb.1
  balloterande_1_N = mkN "balloterande" ; -- balloterande..nn.1
  balloterbar_1_A = mkA "balloterbar" ; -- balloterbar..av.1
  balloterbarhet_1_N = mkN "balloterbarhet" ; -- balloterbarhet..nn.1
  ballotering_1_N = mkN "ballotering" ; -- ballotering..nn.1
  balneolog_1_N = mkN "balneolog" "balneologer" ; -- balneolog..nn.1
  balneologi_1_N = mkN "balneologi" ; -- balneologi..nn.1
  balneologisk_1_A = mkA "balneologisk" ; -- balneologisk..av.1
  balsa_1_N = mkN "balsa" ; -- balsa..nn.1
  balsal_1_N = mkN "balsal" ; -- balsal..nn.1
  balsam_1_N = mkN "balsam" "balsamer" ; -- balsam..nn.1
  balsamdoftande_1_A = mkA "balsamdoftande" ; -- balsamdoftande..av.1
  balsamera_1_V = mkV "balsamerar" ; -- balsamera..vb.1
  balsamerande_1_N = mkN "balsamerande" ; -- balsamerande..nn.1
  balsamerbar_1_A = mkA "balsamerbar" ; -- balsamerbar..av.1
  balsamerbarhet_1_N = mkN "balsamerbarhet" ; -- balsamerbarhet..nn.1
  balsamering_1_N = mkN "balsamering" ; -- balsamering..nn.1
  balsamin_1_N = mkN "balsamin" "balsaminer" ; -- balsamin..nn.1
  balsamisk_1_A = mkA "balsamisk" ; -- balsamisk..av.1
  balsamterpentin_1_N = mkN "balsamterpentin" "balsamterpentiner" ; -- balsamterpentin..nn.1
  balsaträ_1_N = mkN "balsaträ" neutrum  ; -- balsaträ..nn.1
  balt_1_N = mkN "balt" "balter" ; -- balt..nn.1
  baltisk_1_A = mkA "baltisk" ; -- baltisk..av.1
  baltiska_1_N = mkN "baltiska" ; -- baltiska..nn.1
  baltutlämning_1_N = mkN "baltutlämning" ; -- baltutlämning..nn.1
  baluns_1_N = mkN "baluns" "balunser" ; -- baluns..nn.1
  baluster_1_N = mkN "baluster" ; -- baluster..nn.1
  balustrad_1_N = mkN "balustrad" "balustrader" ; -- balustrad..nn.1
  bamba_1_N = mkN "bamba" ; -- bamba..nn.1
  bambu_1_N = mkN "bambu" ; -- bambu..nn.1
  bamburör_1_N = mkN "bamburör" neutrum  ; -- bamburör..nn.1
  bambusoffa_1_N = mkN "bambusoffa" ; -- bambusoffa..nn.1
  ban_1_N = mkN "ban" ; -- ban..nn.1
  ban_2_N = mkN "ban" "baner" ; -- ban..nn.2
  bana_1_N = mkN "bana" ; -- bana..nn.1
  banal_1_A = mkA "banal" ; -- banal..av.1
  banalisera_1_V = mkV "banaliserar" ; -- banalisera..vb.1
  banaliserande_1_N = mkN "banaliserande" ; -- banaliserande..nn.1
  banaliserbar_1_A = mkA "banaliserbar" ; -- banaliserbar..av.1
  banaliserbarhet_1_N = mkN "banaliserbarhet" ; -- banaliserbarhet..nn.1
  banalisering_1_N = mkN "banalisering" ; -- banalisering..nn.1
  banalitet_1_N = mkN "banalitet" "banaliteter" ; -- banalitet..nn.1
  banan_1_N = mkN "banan" "bananer" ; -- banan..nn.1
  bananbana_1_N = mkN "bananbana" ; -- bananbana..nn.1
  bananfluga_1_N = mkN "bananfluga" ; -- bananfluga..nn.1
  bananformad_1_A = mkA "bananformad" ; -- bananformad..av.1
  banankontakt_1_N = mkN "banankontakt" "banankontakter" ; -- banankontakt..nn.1
  bananrepublik_1_N = mkN "bananrepublik" "bananrepubliker" ; -- bananrepublik..nn.1
  bananstock_1_N = mkN "bananstock" ; -- bananstock..nn.1
  bananträd_1_N = mkN "bananträd" neutrum  ; -- bananträd..nn.1
  banarbete_1_N = mkN "banarbete" ; -- banarbete..nn.1
  banbrytande_1_A = mkA "banbrytande" ; -- banbrytande..av.1
  banbrytare_1_N = mkN "banbrytare" utrum  ; -- banbrytare..nn.1
  banco_1_N = mkN "banco" ; -- banco..nn.1
  band_1_N = mkN "band" neutrum  ; -- band..nn.1
  banda_1_V = mkV "bandar" ; -- banda..vb.1
  bandage_1_N = mkN "bandage" "bandaget" "bandage" "bandagen" ; -- bandage..nn.1
  bandande_1_N = mkN "bandande" ; -- bandande..nn.1
  bandel_1_N = mkN "bandel" "bandelen" "bandelar" "bandelarna" ; -- bandel..nn.1
  banderol_1_N = mkN "banderol" "banderoler" ; -- banderol..nn.1
  banderoll_1_N = mkN "banderoll" "banderoller" ; -- banderoll..nn.1
  bandfordon_1_N = mkN "bandfordon" neutrum  ; -- bandfordon..nn.1
  bandformig_1_A = mkA "bandformig" ; -- bandformig..av.1
  bandgenerator_1_N = mkN "bandgenerator" "bandgeneratorer" ; -- bandgenerator..nn.1
  bandhund_1_N = mkN "bandhund" ; -- bandhund..nn.1
  bandit_1_N = mkN "bandit" "banditer" ; -- bandit..nn.1
  banditaktig_1_A = mkA "banditaktig" ; -- banditaktig..av.1
  banditgäng_1_N = mkN "banditgäng" neutrum  ; -- banditgäng..nn.1
  bandjärn_1_N = mkN "bandjärn" neutrum  ; -- bandjärn..nn.1
  bandkantning_1_N = mkN "bandkantning" ; -- bandkantning..nn.1
  bandkniv_1_N = mkN "bandkniv" ; -- bandkniv..nn.1
  bandmedlem_1_N = mkN "bandmedlem" "bandmedlemmen" "bandmedlemmar" "bandmedlemmarna" ; -- bandmedlem..nn.1
  bandolär_1_N = mkN "bandolär" neutrum  ; -- bandolär..nn.1
  bandotek_1_N = mkN "bandotek" neutrum  ; -- bandotek..nn.1
  bandspektrum_1_N = mkN "bandspektrum" neutrum  ; -- bandspektrum..nn.1
  bandspelare_1_N = mkN "bandspelare" utrum  ; -- bandspelare..nn.1
  bandstation_1_N = mkN "bandstation" ; -- bandstation..nn.1
  bandstump_1_N = mkN "bandstump" ; -- bandstump..nn.1
  bandsåg_1_N = mkN "bandsåg" ; -- bandsåg..nn.1
  bandtraktor_1_N = mkN "bandtraktor" "bandtraktorer" ; -- bandtraktor..nn.1
  bandupptagning_1_N = mkN "bandupptagning" ; -- bandupptagning..nn.1
  bandvimpel_1_N = mkN "bandvimpel" ; -- bandvimpel..nn.1
  bandyboll_1_N = mkN "bandyboll" ; -- bandyboll..nn.1
  bandyfanatiker_1_N = mkN "bandyfanatiker" "bandyfanatikern" "bandyfanatiker" "bandyfanatikerna" ; -- bandyfanatiker..nn.1
  bandyklubba_1_N = mkN "bandyklubba" ; -- bandyklubba..nn.1
  bandyrör_1_N = mkN "bandyrör" neutrum  ; -- bandyrör..nn.1
  bandyslag_1_N = mkN "bandyslag" neutrum  ; -- bandyslag..nn.1
  bane_1_N = mkN "bane" ; -- bane..nn.1
  banehugg_1_N = mkN "banehugg" neutrum  ; -- banehugg..nn.1
  baneman_1_N = mkN "baneman" "banemannen" "banemän" "banemännen" ; -- baneman..nn.1
  baner_1_N = mkN "baner" "baneret" "baner" "baneren" ; -- baner..nn.1
  banerförare_1_N = mkN "banerförare" utrum  ; -- banerförare..nn.1
  banesår_1_N = mkN "banesår" neutrum  ; -- banesår..nn.1
  bang_1_A = mkA "bang" ; -- bang..av.1
  bang_1_N = mkN "bang" ; -- bang..nn.1
  banghet_1_N = mkN "banghet" ; -- banghet..nn.1
  bangladeshare_1_N = mkN "bangladeshare" utrum  ; -- bangladeshare..nn.1
  bangladeshier_1_N = mkN "bangladeshier" "bangladeshiern" "bangladeshier" "bangladeshierna" ; -- bangladeshier..nn.1
  bangladeshisk_1_A = mkA "bangladeshisk" ; -- bangladeshisk..av.1
  bangladeshiska_1_N = mkN "bangladeshiska" ; -- bangladeshiska..nn.1
  bangolf_1_N = mkN "bangolf" ; -- bangolf..nn.1
  bangård_1_N = mkN "bangård" ; -- bangård..nn.1
  banhall_1_N = mkN "banhall" ; -- banhall..nn.1
  baning_1_N = mkN "baning" ; -- baning..nn.1
  banjo_1_N = mkN "banjo" "banjor" ; -- banjo..nn.1
  banjoinstrument_1_N = mkN "banjoinstrument" neutrum  ; -- banjoinstrument..nn.1
  bank_1_N = mkN "bank" ; -- bank..nn.1
  bank_2_N = mkN "bank" "banker" ; -- bank..nn.2
  banka_1_V = mkV "bankar" ; -- banka..vb.1
  bankande_1_N = mkN "bankande" ; -- bankande..nn.1
  bankanställd_1_A = mkA "bankanställd" "bankanställt" ; -- bankanställd..av.1
  bankbok_1_N = mkN "bankbok" "bankböcker" ; -- bankbok..nn.1
  bankdirektion_1_N = mkN "bankdirektion" ; -- bankdirektion..nn.1
  bankdirektör_1_N = mkN "bankdirektör" "bankdirektörer" ; -- bankdirektör..nn.1
  bankett_1_N = mkN "bankett" "banketter" ; -- bankett..nn.1
  bankfack_1_N = mkN "bankfack" neutrum  ; -- bankfack..nn.1
  bankföretag_1_N = mkN "bankföretag" neutrum  ; -- bankföretag..nn.1
  bankgiro_1_N = mkN "bankgiro" "bankgirot" "bankgiron" "bankgirona" ; -- bankgiro..nn.1
  bankhus_1_N = mkN "bankhus" neutrum  ; -- bankhus..nn.1
  bankinrättning_1_N = mkN "bankinrättning" ; -- bankinrättning..nn.1
  bankinspektion_1_N = mkN "bankinspektion" ; -- bankinspektion..nn.1
  bankir_1_N = mkN "bankir" "bankirer" ; -- bankir..nn.1
  bankirfirma_1_N = mkN "bankirfirma" ; -- bankirfirma..nn.1
  bankirhustru_1_N = mkN "bankirhustru" "bankirhustrun" "bankirhustrur" "bankirhustrurna" ; -- bankirhustru..nn.1
  bankkamrer_1_N = mkN "bankkamrer" "bankkamrerer" ; -- bankkamrer..nn.1
  bankkapital_1_N = mkN "bankkapital" neutrum  ; -- bankkapital..nn.1
  bankkassör_1_N = mkN "bankkassör" "bankkassörer" ; -- bankkassör..nn.1
  bankkollaps_1_N = mkN "bankkollaps" "bankkollapser" ; -- bankkollaps..nn.1
  bankkonto_1_N = mkN "bankkonto" "bankkontot" "bankkonton" "bankkontona" ; -- bankkonto..nn.1
  bankkontor_1_N = mkN "bankkontor" neutrum  ; -- bankkontor..nn.1
  bankkort_1_N = mkN "bankkort" neutrum  ; -- bankkort..nn.1
  bankkund_1_N = mkN "bankkund" "bankkunder" ; -- bankkund..nn.1
  banklag_1_N = mkN "banklag" ; -- banklag..nn.1
  banklån_1_N = mkN "banklån" neutrum  ; -- banklån..nn.1
  bankman_1_N = mkN "bankman" "bankmannen" "bankmän" "bankmännen" ; -- bankman..nn.1
  bankmässig_1_A = mkA "bankmässig" ; -- bankmässig..av.1
  banknisse_1_N = mkN "banknisse" utrum  ; -- banknisse..nn.1
  banko_1_N = mkN "banko" ; -- banko..nn.1
  bankofullmäktig_1_N = mkN "bankofullmäktig" "bankofullmäktigen" "bankofullmäktige" "bankofullmäktigena" ; -- bankofullmäktig..nn.1
  bankomat_1_N = mkN "bankomat" "bankomater" ; -- bankomat..nn.1
  bankomatkort_1_N = mkN "bankomatkort" neutrum  ; -- bankomatkort..nn.1
  bankomatkupp_1_N = mkN "bankomatkupp" "bankomatkupper" ; -- bankomatkupp..nn.1
  bankomatrånare_1_N = mkN "bankomatrånare" utrum  ; -- bankomatrånare..nn.1
  bankpalats_1_N = mkN "bankpalats" neutrum  ; -- bankpalats..nn.1
  bankpanik_1_N = mkN "bankpanik" ; -- bankpanik..nn.1
  bankreglering_1_N = mkN "bankreglering" ; -- bankreglering..nn.1
  bankrutt_1_A = mkA "bankrutt" ; -- bankrutt..av.1
  bankrutt_1_N = mkN "bankrutt" "bankrutter" ; -- bankrutt..nn.1
  bankruttera_1_V = mkV "bankrutterar" ; -- bankruttera..vb.1
  bankrutterande_1_N = mkN "bankrutterande" ; -- bankrutterande..nn.1
  bankrutterbar_1_A = mkA "bankrutterbar" ; -- bankrutterbar..av.1
  bankrutterbarhet_1_N = mkN "bankrutterbarhet" ; -- bankrutterbarhet..nn.1
  bankruttering_1_N = mkN "bankruttering" ; -- bankruttering..nn.1
  bankruttförklaring_1_N = mkN "bankruttförklaring" ; -- bankruttförklaring..nn.1
  bankruttmässig_1_A = mkA "bankruttmässig" ; -- bankruttmässig..av.1
  bankruttör_1_N = mkN "bankruttör" "bankruttörer" ; -- bankruttör..nn.1
  bankränta_1_N = mkN "bankränta" ; -- bankränta..nn.1
  bankrån_1_N = mkN "bankrån" neutrum  ; -- bankrån..nn.1
  bankrånare_1_N = mkN "bankrånare" utrum  ; -- bankrånare..nn.1
  bankrörelse_1_N = mkN "bankrörelse" "bankrörelser" ; -- bankrörelse..nn.1
  banksektor_1_N = mkN "banksektor" "banksektorer" ; -- banksektor..nn.1
  banksparande_1_N = mkN "banksparande" ; -- banksparande..nn.1
  bankstyrelse_1_N = mkN "bankstyrelse" "bankstyrelser" ; -- bankstyrelse..nn.1
  banktjänsteman_1_N = mkN "banktjänsteman" "banktjänstemannen" "banktjänstemän" "banktjänstemännen" ; -- banktjänsteman..nn.1
  bankväsen_1_N = mkN "bankväsen" neutrum  ; -- bankväsen..nn.1
  bankväxel_1_N = mkN "bankväxel" ; -- bankväxel..nn.1
  banlöpning_1_N = mkN "banlöpning" ; -- banlöpning..nn.1
  bann_1_N = mkN "bann" neutrum  ; -- bann..nn.1
  banna_1_V = mkV "bannar" ; -- banna..vb.1
  bannande_1_N = mkN "bannande" ; -- bannande..nn.1
  bannbulla_1_N = mkN "bannbulla" ; -- bannbulla..nn.1
  bannlysa_1_V = mkV "bannlyser" ; -- bannlysa..vb.1
  bannlysande_1_N = mkN "bannlysande" ; -- bannlysande..nn.1
  bannlysning_1_N = mkN "bannlysning" ; -- bannlysning..nn.1
  bannstråle_1_N = mkN "bannstråle" utrum  ; -- bannstråle..nn.1
  bannät_1_N = mkN "bannät" neutrum  ; -- bannät..nn.1
  banrekord_1_N = mkN "banrekord" neutrum  ; -- banrekord..nn.1
  banrörelse_1_N = mkN "banrörelse" "banrörelser" ; -- banrörelse..nn.1
  banskjutning_1_N = mkN "banskjutning" ; -- banskjutning..nn.1
  banskytte_1_N = mkN "banskytte" ; -- banskytte..nn.1
  banta_1_V = mkV "bantar" ; -- banta..vb.1
  banta_2_V = mkV "bantar" ; -- banta..vb.2
  bantamvikt_1_N = mkN "bantamvikt" ; -- bantamvikt..nn.1
  bantamviktare_1_N = mkN "bantamviktare" utrum  ; -- bantamviktare..nn.1
  bantande_1_N = mkN "bantande" ; -- bantande..nn.1
  bantlär_1_N = mkN "bantlär" neutrum  ; -- bantlär..nn.1
  bantning_1_N = mkN "bantning" ; -- bantning..nn.1
  bantningshysteri_1_N = mkN "bantningshysteri" ; -- bantningshysteri..nn.1
  bantningskur_1_N = mkN "bantningskur" "bantningskurer" ; -- bantningskur..nn.1
  bantningsmedel_1_N = mkN "bantningsmedel" neutrum  ; -- bantningsmedel..nn.1
  bantningspiller_1_N = mkN "bantningspiller" neutrum  ; -- bantningspiller..nn.1
  bantufolk_1_N = mkN "bantufolk" neutrum  ; -- bantufolk..nn.1
  bantuspråk_1_N = mkN "bantuspråk" neutrum  ; -- bantuspråk..nn.1
  banunderhåll_1_N = mkN "banunderhåll" neutrum  ; -- banunderhåll..nn.1
  banvagn_1_N = mkN "banvagn" ; -- banvagn..nn.1
  banvakt_1_N = mkN "banvakt" "banvakter" ; -- banvakt..nn.1
  banvall_1_N = mkN "banvall" ; -- banvall..nn.1
  banverk_1_N = mkN "banverk" neutrum  ; -- banverk..nn.1
  banverkspersonal_1_N = mkN "banverkspersonal" ; -- banverkspersonal..nn.1
  baptism_1_N = mkN "baptism" "baptismer" ; -- baptism..nn.1
  baptist_1_N = mkN "baptist" "baptister" ; -- baptist..nn.1
  baptistdop_1_N = mkN "baptistdop" neutrum  ; -- baptistdop..nn.1
  baptisterium_1_N = mkN "baptisterium" "baptisteriet" "baptisterier" "baptisterierna" ; -- baptisterium..nn.1
  baptistisk_1_A = mkA "baptistisk" ; -- baptistisk..av.1
  baptistpastor_1_N = mkN "baptistpastor" "baptistpastorer" ; -- baptistpastor..nn.1
  baptistpredikant_1_N = mkN "baptistpredikant" "baptistpredikanter" ; -- baptistpredikant..nn.1
  bar_1_A = mkA "bar" ; -- bar..av.1
  bar_1_N = mkN "bar" "barer" ; -- bar..nn.1
  bar_2_N = mkN "bar" "baren" "bar" "baren" ; -- bar..nn.2
  bara_1_Adv = mkAdv "bara" ; -- bara..ab.1
  barack_1_N = mkN "barack" "baracker" ; -- barack..nn.1
  barackläger_1_N = mkN "barackläger" neutrum  ; -- barackläger..nn.1
  bararmad_1_A = mkA "bararmad" ; -- bararmad..av.1
  baraxlad_1_A = mkA "baraxlad" ; -- baraxlad..av.1
  barbadier_1_N = mkN "barbadier" "barbadiern" "barbadier" "barbadierna" ; -- barbadier..nn.1
  barbadisk_1_A = mkA "barbadisk" ; -- barbadisk..av.1
  barbadiska_1_N = mkN "barbadiska" ; -- barbadiska..nn.1
  barbar_1_N = mkN "barbar" "barbarer" ; -- barbar..nn.1
  barbarhövding_1_N = mkN "barbarhövding" ; -- barbarhövding..nn.1
  barbari_1_N = mkN "barbari" neutrum  ; -- barbari..nn.1
  barbarisk_1_A = mkA "barbarisk" ; -- barbarisk..av.1
  barbarism_1_N = mkN "barbarism" "barbarismer" ; -- barbarism..nn.1
  barbent_1_A = mkA "barbent" "barbent" ; -- barbent..av.1
  barberare_1_N = mkN "barberare" utrum  ; -- barberare..nn.1
  barberarstol_1_N = mkN "barberarstol" ; -- barberarstol..nn.1
  barbiturat_1_N = mkN "barbiturat" neutrum  ; -- barbiturat..nn.1
  barbröstad_1_A = mkA "barbröstad" ; -- barbröstad..av.1
  bard_1_N = mkN "bard" "barder" ; -- bard..nn.1
  bardisan_1_N = mkN "bardisan" "bardisaner" ; -- bardisan..nn.1
  bardisk_1_N = mkN "bardisk" ; -- bardisk..nn.1
  bardun_1_N = mkN "bardun" "barduner" ; -- bardun..nn.1
  bardval_1_N = mkN "bardval" ; -- bardval..nn.1
  barett_1_N = mkN "barett" "baretter" ; -- barett..nn.1
  barfota_1_A = mkA "barfota" ; -- barfota..av.1
  barfotad_1_A = mkA "barfotad" ; -- barfotad..av.1
  barfotalasse_1_N = mkN "barfotalasse" utrum  ; -- barfotalasse..nn.1
  barfotaläkare_1_N = mkN "barfotaläkare" utrum  ; -- barfotaläkare..nn.1
  barfotalöpning_1_N = mkN "barfotalöpning" ; -- barfotalöpning..nn.1
  barfotamunk_1_N = mkN "barfotamunk" ; -- barfotamunk..nn.1
  barfrost_1_N = mkN "barfrost" ; -- barfrost..nn.1
  barhet_1_N = mkN "barhet" ; -- barhet..nn.1
  barhuvad_1_A = mkA "barhuvad" ; -- barhuvad..av.1
  barhänt_1_A = mkA "barhänt" "barhänt" ; -- barhänt..av.1
  bariton_1_N = mkN "bariton" "baritoner" ; -- bariton..nn.1
  barium_1_N = mkN "barium" neutrum  ; -- barium..nn.1
  bariumförening_1_N = mkN "bariumförening" ; -- bariumförening..nn.1
  bariumsalt_1_N = mkN "bariumsalt" "bariumsaltet" "bariumsalter" "bariumsalterna" ; -- bariumsalt..nn.1
  bariumsulfat_1_N = mkN "bariumsulfat" neutrum  ; -- bariumsulfat..nn.1
  bark_1_N = mkN "bark" "barker" ; -- bark..nn.1
  bark_2_N = mkN "bark" ; -- bark..nn.2
  barka_1_V = mkV "barkar" ; -- barka..vb.1
  barka_2_V = mkV "barkar" ; -- barka..vb.2
  barkande_1_N = mkN "barkande" ; -- barkande..nn.1
  barkaroll_1_N = mkN "barkaroll" "barkaroller" ; -- barkaroll..nn.1
  barkass_1_N = mkN "barkass" "barkasser" ; -- barkass..nn.1
  barkborre_1_N = mkN "barkborre" utrum  ; -- barkborre..nn.1
  barkbröd_1_N = mkN "barkbröd" neutrum  ; -- barkbröd..nn.1
  barkbåt_1_N = mkN "barkbåt" ; -- barkbåt..nn.1
  barkis_1_N = mkN "barkis" ; -- barkis..nn.1
  barklag_1_N = mkN "barklag" ; -- barklag..nn.1
  barkskepp_1_N = mkN "barkskepp" neutrum  ; -- barkskepp..nn.1
  barkspade_1_N = mkN "barkspade" utrum  ; -- barkspade..nn.1
  barktäkt_1_N = mkN "barktäkt" "barktäkter" ; -- barktäkt..nn.1
  barkund_1_N = mkN "barkund" "barkunder" ; -- barkund..nn.1
  barkympa_1_V = mkV "barkympar" ; -- barkympa..vb.1
  barkympande_1_N = mkN "barkympande" ; -- barkympande..nn.1
  barlast_1_N = mkN "barlast" "barlaster" ; -- barlast..nn.1
  barlasta_1_V = mkV "barlastar" ; -- barlasta..vb.1
  barlastande_1_N = mkN "barlastande" ; -- barlastande..nn.1
  barlastköl_1_N = mkN "barlastköl" ; -- barlastköl..nn.1
  barlastning_1_N = mkN "barlastning" ; -- barlastning..nn.1
  barm_1_N = mkN "barm" ; -- barm..nn.1
  barmark_1_N = mkN "barmark" "barmarker" ; -- barmark..nn.1
  barmhärtig_1_A = mkA "barmhärtig" ; -- barmhärtig..av.1
  barmhärtighet_1_N = mkN "barmhärtighet" "barmhärtigheter" ; -- barmhärtighet..nn.1
  barmhärtighetsgärning_1_N = mkN "barmhärtighetsgärning" ; -- barmhärtighetsgärning..nn.1
  barmhärtighetsmord_1_N = mkN "barmhärtighetsmord" neutrum  ; -- barmhärtighetsmord..nn.1
  barmhärtighetsverk_1_N = mkN "barmhärtighetsverk" neutrum  ; -- barmhärtighetsverk..nn.1
  barn_1_N = mkN "barn" neutrum  ; -- barn..nn.1
  barnadödlighet_1_N = mkN "barnadödlighet" "barnadödligheter" ; -- barnadödlighet..nn.1
  barnafar_1_N = mkN "barnafader" "barnafadern" "barnafäder" "barnafäderna" ; -- barnafar..nn.1
  barnafödande_1_N = mkN "barnafödande" ; -- barnafödande..nn.1
  barnaföderska_1_N = mkN "barnaföderska" ; -- barnaföderska..nn.1
  barnaga_1_N = mkN "barnaga" ; -- barnaga..nn.1
  barnahjärta_1_N = mkN "barnahjärta" "barnahjärtat" "barnahjärtan" "barnahjärtana" ; -- barnahjärta..nn.1
  barnalstrande_1_N = mkN "barnalstrande" ; -- barnalstrande..nn.1
  barnamord_1_N = mkN "barnamord" neutrum  ; -- barnamord..nn.1
  barnamördare_1_N = mkN "barnamördare" utrum  ; -- barnamördare..nn.1
  barnansikte_1_N = mkN "barnansikte" ; -- barnansikte..nn.1
  barnarbete_1_N = mkN "barnarbete" ; -- barnarbete..nn.1
  barnarbetskraft_1_N = mkN "barnarbetskraft" ; -- barnarbetskraft..nn.1
  barnarov_1_N = mkN "barnarov" neutrum  ; -- barnarov..nn.1
  barnasinne_1_N = mkN "barnasinne" ; -- barnasinne..nn.1
  barnasjäl_1_N = mkN "barnasjäl" ; -- barnasjäl..nn.1
  barnaskara_1_N = mkN "barnaskara" ; -- barnaskara..nn.1
  barnatro_1_N = mkN "barnatro" ; -- barnatro..nn.1
  barnavård_1_N = mkN "barnavård" ; -- barnavård..nn.1
  barnavårdscentral_1_N = mkN "barnavårdscentral" "barnavårdscentraler" ; -- barnavårdscentral..nn.1
  barnavårdsman_1_N = mkN "barnavårdsman" "barnavårdsmannen" "barnavårdsmän" "barnavårdsmännen" ; -- barnavårdsman..nn.1
  barnavårdsnämnd_1_N = mkN "barnavårdsnämnd" "barnavårdsnämnder" ; -- barnavårdsnämnd..nn.1
  barnbarn_1_N = mkN "barnbarn" neutrum  ; -- barnbarn..nn.1
  barnbarnsbarn_1_N = mkN "barnbarnsbarn" neutrum  ; -- barnbarnsbarn..nn.1
  barnbeck_1_N = mkN "barnbeck" neutrum  ; -- barnbeck..nn.1
  barnbegränsning_1_N = mkN "barnbegränsning" ; -- barnbegränsning..nn.1
  barnbespisning_1_N = mkN "barnbespisning" ; -- barnbespisning..nn.1
  barnbesök_1_N = mkN "barnbesök" neutrum  ; -- barnbesök..nn.1
  barnbidrag_1_N = mkN "barnbidrag" neutrum  ; -- barnbidrag..nn.1
  barnbok_1_N = mkN "barnbok" "barnböcker" ; -- barnbok..nn.1
  barnboksfigur_1_N = mkN "barnboksfigur" "barnboksfigurer" ; -- barnboksfigur..nn.1
  barnby_1_N = mkN "barnby" "barnbyn" "barnbyar" "barnbyarna" ; -- barnby..nn.1
  barnbördshus_1_N = mkN "barnbördshus" neutrum  ; -- barnbördshus..nn.1
  barncrosshjälm_1_N = mkN "barncrosshjälm" ; -- barncrosshjälm..nn.1
  barncykel_1_N = mkN "barncykel" ; -- barncykel..nn.1
  barndaghem_1_N = mkN "barndaghem" "barndaghemmet" "barndaghem" "barndaghemmen" ; -- barndaghem..nn.1
  barndom_1_N = mkN "barndom" ; -- barndom..nn.1
  barndomsforskning_1_N = mkN "barndomsforskning" ; -- barndomsforskning..nn.1
  barndomshem_1_N = mkN "barndomshem" "barndomshemmet" "barndomshem" "barndomshemmen" ; -- barndomshem..nn.1
  barndomskompis_1_N = mkN "barndomskompis" ; -- barndomskompis..nn.1
  barndomsminne_1_N = mkN "barndomsminne" ; -- barndomsminne..nn.1
  barndomsparadis_1_N = mkN "barndomsparadis" neutrum  ; -- barndomsparadis..nn.1
  barndomsstad_1_N = mkN "barndomsstad" "barndomsstäder" ; -- barndomsstad..nn.1
  barndomstillstånd_1_N = mkN "barndomstillstånd" neutrum  ; -- barndomstillstånd..nn.1
  barndomsupplevelse_1_N = mkN "barndomsupplevelse" "barndomsupplevelser" ; -- barndomsupplevelse..nn.1
  barndomsvän_1_N = mkN "barndomsvän" "barndomsvännen" "barndomsvänner" "barndomsvännerna" ; -- barndomsvän..nn.1
  barndop_1_N = mkN "barndop" neutrum  ; -- barndop..nn.1
  barndos_1_N = mkN "barndos" "barndoser" ; -- barndos..nn.1
  barnfamilj_1_N = mkN "barnfamilj" "barnfamiljer" ; -- barnfamilj..nn.1
  barnfattigdom_1_N = mkN "barnfattigdom" ; -- barnfattigdom..nn.1
  barnfetma_1_N = mkN "barnfetma" ; -- barnfetma..nn.1
  barnflicka_1_N = mkN "barnflicka" ; -- barnflicka..nn.1
  barnfotomodell_1_N = mkN "barnfotomodell" "barnfotomodeller" ; -- barnfotomodell..nn.1
  barnfödd_1_A = mkA "barnfödd" ; -- barnfödd..av.1
  barnförbjuden_1_A = mkA "barnförbjuden" ; -- barnförbjuden..av.1
  barnförbjudenhet_1_N = mkN "barnförbjudenhet" ; -- barnförbjudenhet..nn.1
  barnförlamning_1_N = mkN "barnförlamning" ; -- barnförlamning..nn.1
  barngrupp_1_N = mkN "barngrupp" "barngrupper" ; -- barngrupp..nn.1
  barnhem_1_N = mkN "barnhem" "barnhemmet" "barnhem" "barnhemmen" ; -- barnhem..nn.1
  barnhemsbarn_1_N = mkN "barnhemsbarn" neutrum  ; -- barnhemsbarn..nn.1
  barnhemsplacering_1_N = mkN "barnhemsplacering" ; -- barnhemsplacering..nn.1
  barnhus_1_N = mkN "barnhus" neutrum  ; -- barnhus..nn.1
  barnhusbarn_1_N = mkN "barnhusbarn" neutrum  ; -- barnhusbarn..nn.1
  barnhuvud_1_N = mkN "barnhuvud" "barnhuvudet" "barnhuvud" "barnhuvudena" ; -- barnhuvud..nn.1
  barnjungfru_1_N = mkN "barnjungfru" "barnjungfrun" "barnjungfrur" "barnjungfrurna" ; -- barnjungfru..nn.1
  barnkalas_1_N = mkN "barnkalas" neutrum  ; -- barnkalas..nn.1
  barnkammare_1_N = mkN "barnkammare" "barnkammaren" "barnkammare" "barnkamrarna" ; -- barnkammare..nn.1
  barnkammarfönster_1_N = mkN "barnkammarfönster" neutrum  ; -- barnkammarfönster..nn.1
  barnkammarsaga_1_N = mkN "barnkammarsaga" ; -- barnkammarsaga..nn.1
  barnklinik_1_N = mkN "barnklinik" "barnkliniker" ; -- barnklinik..nn.1
  barnknullare_1_N = mkN "barnknullare" utrum  ; -- barnknullare..nn.1
  barnkoloni_1_N = mkN "barnkoloni" "barnkolonier" ; -- barnkoloni..nn.1
  barnkonvention_1_N = mkN "barnkonvention" ; -- barnkonvention..nn.1
  barnkorståg_1_N = mkN "barnkorståg" neutrum  ; -- barnkorståg..nn.1
  barnkropp_1_N = mkN "barnkropp" ; -- barnkropp..nn.1
  barnkär_1_A = mkA "barnkär" ; -- barnkär..av.1
  barnkör_1_N = mkN "barnkör" "barnkörer" ; -- barnkör..nn.1
  barnledig_1_A = mkA "barnledig" ; -- barnledig..av.1
  barnledighet_1_N = mkN "barnledighet" ; -- barnledighet..nn.1
  barnlek_1_N = mkN "barnlek" ; -- barnlek..nn.1
  barnläkare_1_N = mkN "barnläkare" utrum  ; -- barnläkare..nn.1
  barnläkarskrå_1_N = mkN "barnläkarskrå" "barnläkarskrået" "barnläkarskrån" "barnläkarskråna" ; -- barnläkarskrå..nn.1
  barnlös_1_A = mkA "barnlös" ; -- barnlös..av.1
  barnlöshet_1_N = mkN "barnlöshet" ; -- barnlöshet..nn.1
  barnmat_1_N = mkN "barnmat" ; -- barnmat..nn.1
  barnmedicin_1_N = mkN "barnmedicin" ; -- barnmedicin..nn.1
  barnmedicin_2_N = mkN "barnmedicin" "barnmediciner" ; -- barnmedicin..nn.2
  barnmedicinsk_1_A = mkA "barnmedicinsk" ; -- barnmedicinsk..av.1
  barnmisshandel_1_N = mkN "barnmisshandel" ; -- barnmisshandel..nn.1
  barnmorska_1_N = mkN "barnmorska" ; -- barnmorska..nn.1
  barnneurolog_1_N = mkN "barnneurolog" "barnneurologer" ; -- barnneurolog..nn.1
  barnomsorg_1_N = mkN "barnomsorg" ; -- barnomsorg..nn.1
  barnomsorgsavgift_1_N = mkN "barnomsorgsavgift" "barnomsorgsavgifter" ; -- barnomsorgsavgift..nn.1
  barnomsorgskostnad_1_N = mkN "barnomsorgskostnad" "barnomsorgskostnader" ; -- barnomsorgskostnad..nn.1
  barnparkering_1_N = mkN "barnparkering" ; -- barnparkering..nn.1
  barnpassning_1_N = mkN "barnpassning" ; -- barnpassning..nn.1
  barnpiga_1_N = mkN "barnpiga" ; -- barnpiga..nn.1
  barnplågeri_1_N = mkN "barnplågeri" neutrum  ; -- barnplågeri..nn.1
  barnpornografi_1_N = mkN "barnpornografi" ; -- barnpornografi..nn.1
  barnpornografisk_1_A = mkA "barnpornografisk" ; -- barnpornografisk..av.1
  barnporr_1_N = mkN "barnporr" ; -- barnporr..nn.1
  barnporranklagad_1_A = mkA "barnporranklagad" ; -- barnporranklagad..av.1
  barnporrhärva_1_N = mkN "barnporrhärva" ; -- barnporrhärva..nn.1
  barnporrmål_1_N = mkN "barnporrmål" neutrum  ; -- barnporrmål..nn.1
  barnprogram_1_N = mkN "barnprogram" "barnprogrammet" "barnprogram" "barnprogrammen" ; -- barnprogram..nn.1
  barnpsykiatri_1_N = mkN "barnpsykiatri" ; -- barnpsykiatri..nn.1
  barnpsykiatrisk_1_A = mkA "barnpsykiatrisk" ; -- barnpsykiatrisk..av.1
  barnrik_1_A = mkA "barnrik" ; -- barnrik..av.1
  barnrov_1_N = mkN "barnrov" neutrum  ; -- barnrov..nn.1
  barnrättskämpe_1_N = mkN "barnrättskämpe" utrum  ; -- barnrättskämpe..nn.1
  barnröst_1_N = mkN "barnröst" "barnröster" ; -- barnröst..nn.1
  barnsaga_1_N = mkN "barnsaga" ; -- barnsaga..nn.1
  barnsak_1_N = mkN "barnsak" "barnsaker" ; -- barnsak..nn.1
  barnsbörd_1_N = mkN "barnsbörd" "barnsbörder" ; -- barnsbörd..nn.1
  barnsjukdom_1_N = mkN "barnsjukdom" ; -- barnsjukdom..nn.1
  barnsjukhus_1_N = mkN "barnsjukhus" neutrum  ; -- barnsjukhus..nn.1
  barnsko_1_N = mkN "barnsko" "barnskor" ; -- barnsko..nn.1
  barnskottkärra_1_N = mkN "barnskottkärra" ; -- barnskottkärra..nn.1
  barnskratt_1_N = mkN "barnskratt" neutrum  ; -- barnskratt..nn.1
  barnskrik_1_N = mkN "barnskrik" neutrum  ; -- barnskrik..nn.1
  barnskötare_1_N = mkN "barnskötare" utrum  ; -- barnskötare..nn.1
  barnskötarlinje_1_N = mkN "barnskötarlinje" "barnskötarlinjer" ; -- barnskötarlinje..nn.1
  barnsköterska_1_N = mkN "barnsköterska" ; -- barnsköterska..nn.1
  barnslig_1_A = mkA "barnslig" ; -- barnslig..av.1
  barnslighet_1_N = mkN "barnslighet" "barnsligheter" ; -- barnslighet..nn.1
  barnsmugglare_1_N = mkN "barnsmugglare" utrum  ; -- barnsmugglare..nn.1
  barnsmugglarliga_1_N = mkN "barnsmugglarliga" ; -- barnsmugglarliga..nn.1
  barnsmuggling_1_N = mkN "barnsmuggling" ; -- barnsmuggling..nn.1
  barnsnor_1_N = mkN "barnsnor" ; -- barnsnor..nn.1
  barnsnöd_1_N = mkN "barnsnöd" ; -- barnsnöd..nn.1
  barnsoldat_1_N = mkN "barnsoldat" "barnsoldater" ; -- barnsoldat..nn.1
  barnspråk_1_N = mkN "barnspråk" neutrum  ; -- barnspråk..nn.1
  barnstuga_1_N = mkN "barnstuga" ; -- barnstuga..nn.1
  barnsäker_1_A = mkA "barnsäker" ; -- barnsäker..av.1
  barnsäkerhet_1_N = mkN "barnsäkerhet" ; -- barnsäkerhet..nn.1
  barnsäng_1_N = mkN "barnsäng" ; -- barnsäng..nn.1
  barnsängsfeber_1_N = mkN "barnsängsfeber" ; -- barnsängsfeber..nn.1
  barnsängskvinna_1_N = mkN "barnsängskvinna" ; -- barnsängskvinna..nn.1
  barnteckning_1_N = mkN "barnteckning" ; -- barnteckning..nn.1
  barntillsyn_1_N = mkN "barntillsyn" ; -- barntillsyn..nn.1
  barntillåten_1_A = mkA "barntillåten" ; -- barntillåten..av.1
  barntillåtenhet_1_N = mkN "barntillåtenhet" ; -- barntillåtenhet..nn.1
  barntoalett_1_N = mkN "barntoalett" "barntoaletter" ; -- barntoalett..nn.1
  barnunge_1_N = mkN "barnunge" utrum  ; -- barnunge..nn.1
  barnvagn_1_N = mkN "barnvagn" ; -- barnvagn..nn.1
  barnvakt_1_N = mkN "barnvakt" "barnvakter" ; -- barnvakt..nn.1
  barnvattenkanna_1_N = mkN "barnvattenkanna" ; -- barnvattenkanna..nn.1
  barnvisa_1_N = mkN "barnvisa" ; -- barnvisa..nn.1
  barnvälgörenhetsorganisation_1_N = mkN "barnvälgörenhetsorganisation" ; -- barnvälgörenhetsorganisation..nn.1
  barnvänlig_1_A = mkA "barnvänlig" ; -- barnvänlig..av.1
  barock_1_A = mkA "barock" ; -- barock..av.1
  barock_1_N = mkN "barock" ; -- barock..nn.1
  barockkonst_1_N = mkN "barockkonst" "barockkonster" ; -- barockkonst..nn.1
  barocklyrik_1_N = mkN "barocklyrik" ; -- barocklyrik..nn.1
  barockmusik_1_N = mkN "barockmusik" ; -- barockmusik..nn.1
  barockmässig_1_A = mkA "barockmässig" ; -- barockmässig..av.1
  barockmålare_1_N = mkN "barockmålare" utrum  ; -- barockmålare..nn.1
  barockpalats_1_N = mkN "barockpalats" neutrum  ; -- barockpalats..nn.1
  barockpärla_1_N = mkN "barockpärla" ; -- barockpärla..nn.1
  barockstil_1_N = mkN "barockstil" ; -- barockstil..nn.1
  barograf_1_N = mkN "barograf" "barografer" ; -- barograf..nn.1
  barogram_1_N = mkN "barogram" "barogrammet" "barogram" "barogrammen" ; -- barogram..nn.1
  barometer_1_N = mkN "barometer" ; -- barometer..nn.1
  barometerfall_1_N = mkN "barometerfall" neutrum  ; -- barometerfall..nn.1
  barometerstånd_1_N = mkN "barometerstånd" neutrum  ; -- barometerstånd..nn.1
  barometrisk_1_A = mkA "barometrisk" ; -- barometrisk..av.1
  baron_1_N = mkN "baron" "baroner" ; -- baron..nn.1
  baronessa_1_N = mkN "baronessa" ; -- baronessa..nn.1
  barospirator_1_N = mkN "barospirator" "barospiratorer" ; -- barospirator..nn.1
  barr_1_N = mkN "barr" neutrum  ; -- barr..nn.1
  barr_2_N = mkN "barr" "barrer" ; -- barr..nn.2
  barra_1_V = mkV "barrar" ; -- barra..vb.1
  barrande_1_N = mkN "barrande" ; -- barrande..nn.1
  barrdoft_1_N = mkN "barrdoft" "barrdofter" ; -- barrdoft..nn.1
  barre_1_N = mkN "barre" utrum  ; -- barre..nn.1
  barrig_1_A = mkA "barrig" ; -- barrig..av.1
  barrikad_1_N = mkN "barrikad" "barrikader" ; -- barrikad..nn.1
  barrikadera_1_V = mkV "barrikaderar" ; -- barrikadera..vb.1
  barrikaderande_1_N = mkN "barrikaderande" ; -- barrikaderande..nn.1
  barrikaderbar_1_A = mkA "barrikaderbar" ; -- barrikaderbar..av.1
  barrikaderbarhet_1_N = mkN "barrikaderbarhet" ; -- barrikaderbarhet..nn.1
  barrikadering_1_N = mkN "barrikadering" ; -- barrikadering..nn.1
  barrikadkämpe_1_N = mkN "barrikadkämpe" utrum  ; -- barrikadkämpe..nn.1
  barrikadstrid_1_N = mkN "barrikadstrid" "barrikadstrider" ; -- barrikadstrid..nn.1
  barriär_1_N = mkN "barriär" "barriärer" ; -- barriär..nn.1
  barriärrev_1_N = mkN "barriärrev" neutrum  ; -- barriärrev..nn.1
  barrskog_1_N = mkN "barrskog" ; -- barrskog..nn.1
  barrskogsgräns_1_N = mkN "barrskogsgräns" "barrskogsgränser" ; -- barrskogsgräns..nn.1
  barrskogsnunna_1_N = mkN "barrskogsnunna" ; -- barrskogsnunna..nn.1
  barrskogsregion_1_N = mkN "barrskogsregion" ; -- barrskogsregion..nn.1
  barrskogstäckt_1_A = mkA "barrskogstäckt" "barrskogstäckt" ; -- barrskogstäckt..av.1
  barrträd_1_N = mkN "barrträd" neutrum  ; -- barrträd..nn.1
  barrträdskotte_1_N = mkN "barrträdskotte" utrum  ; -- barrträdskotte..nn.1
  barrträdsplanta_1_N = mkN "barrträdsplanta" ; -- barrträdsplanta..nn.1
  barrträdssort_1_N = mkN "barrträdssort" "barrträdssorter" ; -- barrträdssort..nn.1
  barrved_1_N = mkN "barrved" ; -- barrved..nn.1
  barservering_1_N = mkN "barservering" ; -- barservering..nn.1
  barsk_1_A = mkA "barsk" ; -- barsk..av.1
  barskhet_1_N = mkN "barskhet" ; -- barskhet..nn.1
  barskrapad_1_A = mkA "barskrapad" ; -- barskrapad..av.1
  barskåp_1_N = mkN "barskåp" neutrum  ; -- barskåp..nn.1
  barstol_1_N = mkN "barstol" ; -- barstol..nn.1
  bartender_1_N = mkN "bartender" ; -- bartender..nn.1
  barvinter_1_N = mkN "barvinter" ; -- barvinter..nn.1
  barysfär_1_N = mkN "barysfär" "barysfärer" ; -- barysfär..nn.1
  baryt_1_N = mkN "baryt" ; -- baryt..nn.1
  baryton_1_N = mkN "baryton" "barytoner" ; -- baryton..nn.1
  bas_1_N = mkN "bas" ; -- bas..nn.1
  bas_2_N = mkN "bas" "baser" ; -- bas..nn.2
  bas_3_N = mkN "bas" ; -- bas..nn.3
  bas_4_N = mkN "bas" ; -- bas..nn.4
  basa_1_V = mkV "basar" ; -- basa..vb.1
  basal_1_A = mkA "basal" ; -- basal..av.1
  basalt_1_N = mkN "basalt" ; -- basalt..nn.1
  basande_1_N = mkN "basande" ; -- basande..nn.1
  basar_1_N = mkN "basar" "basarer" ; -- basar..nn.1
  basbelopp_1_N = mkN "basbelopp" neutrum  ; -- basbelopp..nn.1
  baseball_1_N = mkN "baseball" ; -- baseball..nn.1
  baseballsträ_1_N = mkN "baseballsträ" "baseballsträt" "baseballsträn" "baseballsträna" ; -- baseballsträ..nn.1
  baseballträ_1_N = mkN "baseballträ" "baseballträt" "baseballträn" "baseballträna" ; -- baseballträ..nn.1
  baseboll_1_N = mkN "baseboll" ; -- baseboll..nn.1
  baseboll_2_N = mkN "baseboll" ; -- baseboll..nn.2
  basebollsträ_1_N = mkN "basebollsträ" "basebollsträt" "basebollsträn" "basebollsträna" ; -- basebollsträ..nn.1
  basebollträ_1_N = mkN "basebollträ" "basebollträt" "basebollträn" "basebollträna" ; -- basebollträ..nn.1
  basedow_1_N = mkN "basedow" ; -- basedow..nn.1
  basenhet_1_N = mkN "basenhet" "basenheter" ; -- basenhet..nn.1
  basera_1_V = mkV "baserar" ; -- basera..vb.1
  baserande_1_N = mkN "baserande" ; -- baserande..nn.1
  baserbar_1_A = mkA "baserbar" ; -- baserbar..av.1
  baserbarhet_1_N = mkN "baserbarhet" ; -- baserbarhet..nn.1
  basering_1_N = mkN "basering" ; -- basering..nn.1
  basfiol_1_N = mkN "basfiol" "basfioler" ; -- basfiol..nn.1
  basfiolsfodral_1_N = mkN "basfiolsfodral" neutrum  ; -- basfiolsfodral..nn.1
  basfiolsfodralsmakare_1_N = mkN "basfiolsfodralsmakare" utrum  ; -- basfiolsfodralsmakare..nn.1
  basfiolsfodralsmakaregesäll_1_N = mkN "basfiolsfodralsmakaregesäll" "basfiolsfodralsmakaregesäller" ; -- basfiolsfodralsmakaregesäll..nn.1
  basfärdighet_1_N = mkN "basfärdighet" "basfärdigheter" ; -- basfärdighet..nn.1
  basföda_1_N = mkN "basföda" ; -- basföda..nn.1
  basgitarr_1_N = mkN "basgitarr" "basgitarrer" ; -- basgitarr..nn.1
  basilika_1_N = mkN "basilika" ; -- basilika..nn.1
  basilisk_1_N = mkN "basilisk" "basilisker" ; -- basilisk..nn.1
  basis_1_N = mkN "basis" ; -- basis..nn.1
  basisk_1_A = mkA "basisk" ; -- basisk..av.1
  basist_1_N = mkN "basist" "basister" ; -- basist..nn.1
  bask_1_N = mkN "bask" "basker" ; -- bask..nn.1
  basker_1_N = mkN "basker" ; -- basker..nn.1
  basket_1_N = mkN "basket" ; -- basket..nn.1
  basketboll_1_N = mkN "basketboll" ; -- basketboll..nn.1
  basketboll_2_N = mkN "basketboll" ; -- basketboll..nn.2
  basketproffs_1_N = mkN "basketproffs" neutrum  ; -- basketproffs..nn.1
  baskisk_1_A = mkA "baskisk" ; -- baskisk..av.1
  baskiska_1_N = mkN "baskiska" ; -- baskiska..nn.1
  baskiska_2_N = mkN "baskiska" ; -- baskiska..nn.2
  basklarinett_1_N = mkN "basklarinett" "basklarinetter" ; -- basklarinett..nn.1
  basklav_1_N = mkN "basklav" ; -- basklav..nn.1
  baslinje_1_N = mkN "baslinje" "baslinjer" ; -- baslinje..nn.1
  basläger_1_N = mkN "basläger" neutrum  ; -- basläger..nn.1
  basning_1_N = mkN "basning" ; -- basning..nn.1
  basnot_1_N = mkN "basnot" "basnoter" ; -- basnot..nn.1
  basorganisation_1_N = mkN "basorganisation" ; -- basorganisation..nn.1
  baspar_1_N = mkN "baspar" neutrum  ; -- baspar..nn.1
  basparti_1_N = mkN "basparti" "baspartiet" "baspartier" "baspartierna" ; -- basparti..nn.1
  basplatta_1_N = mkN "basplatta" ; -- basplatta..nn.1
  basrelief_1_N = mkN "basrelief" "basreliefer" ; -- basrelief..nn.1
  basrelieftavla_1_N = mkN "basrelieftavla" ; -- basrelieftavla..nn.1
  basröst_1_N = mkN "basröst" "basröster" ; -- basröst..nn.1
  basse_1_N = mkN "basse" utrum  ; -- basse..nn.1
  basset_1_N = mkN "basset" ; -- basset..nn.1
  bassetthorn_1_N = mkN "bassetthorn" neutrum  ; -- bassetthorn..nn.1
  bassning_1_N = mkN "bassning" ; -- bassning..nn.1
  basstation_1_N = mkN "basstation" ; -- basstation..nn.1
  bassträcka_1_N = mkN "bassträcka" ; -- bassträcka..nn.1
  bassträng_1_N = mkN "bassträng" ; -- bassträng..nn.1
  basstämma_1_N = mkN "basstämma" ; -- basstämma..nn.1
  bassäng_1_N = mkN "bassäng" "bassänger" ; -- bassäng..nn.1
  bassångare_1_N = mkN "bassångare" utrum  ; -- bassångare..nn.1
  bast_1_N = mkN "bast" neutrum  ; -- bast..nn.1
  bast_2_N = mkN "bast" neutrum  ; -- bast..nn.2
  basta_1_V = mkV "bastar" ; -- basta..vb.1
  bastande_1_N = mkN "bastande" ; -- bastande..nn.1
  bastant_1_A = mkA "bastant" "bastant" ; -- bastant..av.1
  bastanthet_1_N = mkN "bastanthet" ; -- bastanthet..nn.1
  bastard_1_N = mkN "bastard" "bastarder" ; -- bastard..nn.1
  bastardform_1_N = mkN "bastardform" "bastardformer" ; -- bastardform..nn.1
  bastardnäktergal_1_N = mkN "bastardnäktergal" ; -- bastardnäktergal..nn.1
  bastcell_1_N = mkN "bastcell" "bastceller" ; -- bastcell..nn.1
  bastfiber_1_N = mkN "bastfiber" "bastfibern" "bastfibrer" "bastfibrerna" ; -- bastfiber..nn.1
  bastingering_1_N = mkN "bastingering" ; -- bastingering..nn.1
  bastion_1_N = mkN "bastion" ; -- bastion..nn.1
  bastkjol_1_N = mkN "bastkjol" ; -- bastkjol..nn.1
  bastmatta_1_N = mkN "bastmatta" ; -- bastmatta..nn.1
  baston_1_N = mkN "baston" "bastoner" ; -- baston..nn.1
  bastonad_1_N = mkN "bastonad" "bastonader" ; -- bastonad..nn.1
  bastrep_1_N = mkN "bastrep" neutrum  ; -- bastrep..nn.1
  bastrumma_1_N = mkN "bastrumma" ; -- bastrumma..nn.1
  bastu_1_N = mkN "bastu" "bastun" "bastur" "basturna" ; -- bastu..nn.1
  bastuaggregat_1_N = mkN "bastuaggregat" neutrum  ; -- bastuaggregat..nn.1
  bastuba_1_N = mkN "bastuba" ; -- bastuba..nn.1
  bastubad_1_N = mkN "bastubad" neutrum  ; -- bastubad..nn.1
  bastuförening_1_N = mkN "bastuförening" ; -- bastuförening..nn.1
  bastuklubb_1_N = mkN "bastuklubb" ; -- bastuklubb..nn.1
  bastuugn_1_N = mkN "bastuugn" ; -- bastuugn..nn.1
  bastuvärme_1_N = mkN "bastuvärme" utrum  ; -- bastuvärme..nn.1
  basun_1_N = mkN "basun" "basuner" ; -- basun..nn.1
  basunblåsande_1_N = mkN "basunblåsande" ; -- basunblåsande..nn.1
  basunist_1_N = mkN "basunist" "basunister" ; -- basunist..nn.1
  basunklang_1_N = mkN "basunklang" "basunklanger" ; -- basunklang..nn.1
  basunregister_1_N = mkN "basunregister" neutrum  ; -- basunregister..nn.1
  basunstöt_1_N = mkN "basunstöt" ; -- basunstöt..nn.1
  basvara_1_N = mkN "basvara" ; -- basvara..nn.1
  basvinkel_1_N = mkN "basvinkel" ; -- basvinkel..nn.1
  basväg_1_N = mkN "basväg" ; -- basväg..nn.1
  basyta_1_N = mkN "basyta" ; -- basyta..nn.1
  basår_1_N = mkN "basår" neutrum  ; -- basår..nn.1
  batalj_1_N = mkN "batalj" "bataljer" ; -- batalj..nn.1
  bataljmålare_1_N = mkN "bataljmålare" utrum  ; -- bataljmålare..nn.1
  bataljmålning_1_N = mkN "bataljmålning" ; -- bataljmålning..nn.1
  bataljon_1_N = mkN "bataljon" "bataljoner" ; -- bataljon..nn.1
  bataljonsadjutant_1_N = mkN "bataljonsadjutant" "bataljonsadjutanter" ; -- bataljonsadjutant..nn.1
  bataljonschef_1_N = mkN "bataljonschef" "bataljonschefer" ; -- bataljonschef..nn.1
  bataljonsvis_1_Adv = mkAdv "bataljonsvis" ; -- bataljonsvis..ab.1
  batat_1_N = mkN "batat" "batater" ; -- batat..nn.1
  batik_1_N = mkN "batik" ; -- batik..nn.1
  batist_1_N = mkN "batist" "batister" ; -- batist..nn.1
  batong_1_N = mkN "batong" "batonger" ; -- batong..nn.1
  batongslag_1_N = mkN "batongslag" neutrum  ; -- batongslag..nn.1
  batongstånd_1_N = mkN "batongstånd" neutrum  ; -- batongstånd..nn.1
  batongsvingande_1_A = mkA "batongsvingande" ; -- batongsvingande..av.1
  batongsvingande_1_N = mkN "batongsvingande" ; -- batongsvingande..nn.1
  batteri_1_N = mkN "batteri" "batteriet" "batterier" "batterierna" ; -- batteri..nn.1
  batteridrift_1_N = mkN "batteridrift" ; -- batteridrift..nn.1
  batteridriven_1_A = mkA "batteridriven" ; -- batteridriven..av.1
  batterield_1_N = mkN "batterield" ; -- batterield..nn.1
  batteriklämma_1_N = mkN "batteriklämma" ; -- batteriklämma..nn.1
  batteriladdare_1_N = mkN "batteriladdare" utrum  ; -- batteriladdare..nn.1
  batteriladdning_1_N = mkN "batteriladdning" ; -- batteriladdning..nn.1
  batteriprovare_1_N = mkN "batteriprovare" utrum  ; -- batteriprovare..nn.1
  batteriradio_1_N = mkN "batteriradio" ; -- batteriradio..nn.1
  batterisekatör_1_N = mkN "batterisekatör" "batterisekatörer" ; -- batterisekatör..nn.1
  batterist_1_N = mkN "batterist" "batterister" ; -- batterist..nn.1
  batteritändning_1_N = mkN "batteritändning" ; -- batteritändning..nn.1
  batting_1_N = mkN "batting" ; -- batting..nn.1
  batysfär_1_N = mkN "batysfär" "batysfärer" ; -- batysfär..nn.1
  baud_1_N = mkN "baud" "bauden" "baud" "bauden" ; -- baud..nn.1
  bautasten_1_N = mkN "bautasten" "bautastenen" "bautastenar" "bautastenarna" ; -- bautasten..nn.1
  bauxit_1_N = mkN "bauxit" ; -- bauxit..nn.1
  baxa_1_V = mkV "baxar" ; -- baxa..vb.1
  baxande_1_N = mkN "baxande" ; -- baxande..nn.1
  baxna_1_V = mkV "baxnar" ; -- baxna..vb.1
  baxnande_1_N = mkN "baxnande" ; -- baxnande..nn.1
  bayersk_1_A = mkA "bayersk" ; -- bayersk..av.1
  bazooka_1_N = mkN "bazooka" ; -- bazooka..nn.1
  be_1_V = mkV "beda" "bad" "bett" ; -- be..vb.1
  bea_1_N = mkN "bea" ; -- bea..nn.1
  beagle_1_N = mkN "beagle" utrum  ; -- beagle..nn.1
  beakta_1_V = mkV "beaktar" ; -- beakta..vb.1
  beaktande_1_N = mkN "beaktande" ; -- beaktande..nn.1
  beaktansvärd_1_A = mkA "beaktansvärd" "beaktansvärt" ; -- beaktansvärd..av.1
  bearbeta_1_V = mkV "bearbetar" ; -- bearbeta..vb.1
  bearbetande_1_N = mkN "bearbetande" ; -- bearbetande..nn.1
  bearbetare_1_N = mkN "bearbetare" utrum  ; -- bearbetare..nn.1
  bearbetning_1_N = mkN "bearbetning" ; -- bearbetning..nn.1
  bearnaise_1_N = mkN "bearnaise" "bearnaiser" ; -- bearnaise..nn.1
  bearnaisesås_1_N = mkN "bearnaisesås" "bearnaisesåser" ; -- bearnaisesås..nn.1
  bearnäs_1_N = mkN "bearnäs" "bearnäser" ; -- bearnäs..nn.1
  bearnässås_1_N = mkN "bearnässås" "bearnässåser" ; -- bearnässås..nn.1
  beatifiera_1_V = mkV "beatifierar" ; -- beatifiera..vb.1
  beatifierande_1_N = mkN "beatifierande" ; -- beatifierande..nn.1
  beatifierbar_1_A = mkA "beatifierbar" ; -- beatifierbar..av.1
  beatifierbarhet_1_N = mkN "beatifierbarhet" ; -- beatifierbarhet..nn.1
  beatifiering_1_N = mkN "beatifiering" ; -- beatifiering..nn.1
  beatnik_1_N = mkN "beatnik" ; -- beatnik..nn.1
  bebis_1_N = mkN "bebis" ; -- bebis..nn.1
  beblandande_1_N = mkN "beblandande" ; -- beblandande..nn.1
  beblandelse_1_N = mkN "beblandelse" utrum  ; -- beblandelse..nn.1
  bebo_1_V = mkV "bebor" ; -- bebo..vb.1
  bebodd_1_A = mkA "bebodd" ; -- bebodd..av.1
  beboelig_1_A = mkA "beboelig" ; -- beboelig..av.1
  beboelighet_1_N = mkN "beboelighet" ; -- beboelighet..nn.1
  beboende_1_N = mkN "beboende" ; -- beboende..nn.1
  bebolig_1_A = mkA "bebolig" ; -- bebolig..av.1
  bebolighet_1_N = mkN "bebolighet" ; -- bebolighet..nn.1
  bebop_1_N = mkN "bebop" ; -- bebop..nn.1
  bebygga_1_V = mkV "bebygger" ; -- bebygga..vb.1
  bebyggande_1_N = mkN "bebyggande" ; -- bebyggande..nn.1
  bebyggare_1_N = mkN "bebyggare" utrum  ; -- bebyggare..nn.1
  bebyggelse_1_N = mkN "bebyggelse" "bebyggelser" ; -- bebyggelse..nn.1
  bebyggelsenamn_1_N = mkN "bebyggelsenamn" neutrum  ; -- bebyggelsenamn..nn.1
  bebåda_1_V = mkV "bebådar" ; -- bebåda..vb.1
  bebådande_1_N = mkN "bebådande" ; -- bebådande..nn.1
  bebådelse_1_N = mkN "bebådelse" "bebådelser" ; -- bebådelse..nn.1
  bebådelsedag_1_N = mkN "bebådelsedag" ; -- bebådelsedag..nn.1
  bebådning_1_N = mkN "bebådning" ; -- bebådning..nn.1
  becherovka_1_N = mkN "becherovka" ; -- becherovka..nn.1
  beck_1_N = mkN "beck" neutrum  ; -- beck..nn.1
  becka_1_V = mkV "beckar" ; -- becka..vb.1
  beckande_1_N = mkN "beckande" ; -- beckande..nn.1
  beckasin_1_N = mkN "beckasin" "beckasiner" ; -- beckasin..nn.1
  beckig_1_A = mkA "beckig" ; -- beckig..av.1
  beckighet_1_N = mkN "beckighet" ; -- beckighet..nn.1
  beckmörk_1_A = mkA "beckmörk" ; -- beckmörk..av.1
  beckmörker_1_N = mkN "beckmörker" neutrum  ; -- beckmörker..nn.1
  beckpärla_1_N = mkN "beckpärla" ; -- beckpärla..nn.1
  becksvart_1_A = mkA "becksvart" "becksvart" ; -- becksvart..av.1
  becquerel_1_N = mkN "becquerel" "becquerelen" "becquerel" "becquerelen" ; -- becquerel..nn.1
  bedagad_1_A = mkA "bedagad" ; -- bedagad..av.1
  bedarra_1_V = mkV "bedarrar" ; -- bedarra..vb.1
  bedarrande_1_N = mkN "bedarrande" ; -- bedarrande..nn.1
  bedarrning_1_N = mkN "bedarrning" ; -- bedarrning..nn.1
  bedjande_1_A = mkA "bedjande" ; -- bedjande..av.1
  bedjande_1_N = mkN "bedjande" ; -- bedjande..nn.1
  bedra_1_V = mkV "bedraga" "bedrog" "bedragit" ; -- bedra..vb.1
  bedragande_1_N = mkN "bedragande" ; -- bedragande..nn.1
  bedragare_1_N = mkN "bedragare" utrum  ; -- bedragare..nn.1
  bedragerska_1_N = mkN "bedragerska" ; -- bedragerska..nn.1
  bedrift_1_N = mkN "bedrift" "bedrifter" ; -- bedrift..nn.1
  bedriva_1_V = mkV "bedriva" "bedrev" "bedrivit" ; -- bedriva..vb.1
  bedrivande_1_N = mkN "bedrivande" ; -- bedrivande..nn.1
  bedrägeri_1_N = mkN "bedrägeri" "bedrägeriet" "bedrägerier" "bedrägerierna" ; -- bedrägeri..nn.1
  bedrägeribrott_1_N = mkN "bedrägeribrott" neutrum  ; -- bedrägeribrott..nn.1
  bedrägerirotel_1_N = mkN "bedrägerirotel" ; -- bedrägerirotel..nn.1
  bedräglig_1_A = mkA "bedräglig" ; -- bedräglig..av.1
  bedräglighet_1_N = mkN "bedräglighet" "bedrägligheter" ; -- bedräglighet..nn.1
  bedröva_1_V = mkV "bedrövar" ; -- bedröva..vb.1
  bedrövad_1_A = mkA "bedrövad" ; -- bedrövad..av.1
  bedrövande_1_N = mkN "bedrövande" ; -- bedrövande..nn.1
  bedrövelse_1_N = mkN "bedrövelse" "bedrövelser" ; -- bedrövelse..nn.1
  bedrövlig_1_A = mkA "bedrövlig" ; -- bedrövlig..av.1
  bedrövlighet_1_N = mkN "bedrövlighet" "bedrövligheter" ; -- bedrövlighet..nn.1
  beduin_1_N = mkN "beduin" "beduiner" ; -- beduin..nn.1
  bedyra_1_V = mkV "bedyrar" ; -- bedyra..vb.1
  bedyrande_1_N = mkN "bedyrande" ; -- bedyrande..nn.1
  bedåra_1_V = mkV "bedårar" ; -- bedåra..vb.1
  bedårande_1_A = mkA "bedårande" ; -- bedårande..av.1
  bedårande_1_N = mkN "bedårande" ; -- bedårande..nn.1
  bedöma_1_V = mkV "bedömer" ; -- bedöma..vb.1
  bedömande_1_N = mkN "bedömande" ; -- bedömande..nn.1
  bedömare_1_N = mkN "bedömare" utrum  ; -- bedömare..nn.1
  bedömning_1_N = mkN "bedömning" ; -- bedömning..nn.1
  bedöva_1_V = mkV "bedövar" ; -- bedöva..vb.1
  bedövande_1_N = mkN "bedövande" ; -- bedövande..nn.1
  bedövning_1_N = mkN "bedövning" ; -- bedövning..nn.1
  bedövningsmedel_1_N = mkN "bedövningsmedel" neutrum  ; -- bedövningsmedel..nn.1
  beediga_1_V = mkV "beedigar" ; -- beediga..vb.1
  beedigande_1_N = mkN "beedigande" ; -- beedigande..nn.1
  beende_1_A = mkA "beende" ; -- beende..av.1
  beende_1_N = mkN "beende" ; -- beende..nn.1
  befalla_1_V = mkV "befaller" ; -- befalla..vb.1
  befallande_1_A = mkA "befallande" ; -- befallande..av.1
  befallande_1_N = mkN "befallande" ; -- befallande..nn.1
  befallning_1_N = mkN "befallning" ; -- befallning..nn.1
  befallningshavande_1_N = mkN "befallningshavande" "befallningshavanden" "befallningshavanden" "befallningshavandena" ; -- befallningshavande..nn.1
  befallningsman_1_N = mkN "befallningsman" "befallningsmannen" "befallningsmän" "befallningsmännen" ; -- befallningsman..nn.1
  befara_1_V = mkV "befarar" ; -- befara..vb.1
  befara_2_V = mkV "befara" "befor" "befarit" ; -- befara..vb.2
  befarande_1_N = mkN "befarande" ; -- befarande..nn.1
  befaren_1_A = mkA "befaren" ; -- befaren..av.1
  befattning_1_N = mkN "befattning" ; -- befattning..nn.1
  befattningshavare_1_N = mkN "befattningshavare" utrum  ; -- befattningshavare..nn.1
  befattningsmässig_1_A = mkA "befattningsmässig" ; -- befattningsmässig..av.1
  befinna_1_V = mkV "befinna" "befann" "befunnit" ; -- befinna..vb.1
  befinnande_1_N = mkN "befinnande" ; -- befinnande..nn.1
  befintlig_1_A = mkA "befintlig" ; -- befintlig..av.1
  befintlighet_1_N = mkN "befintlighet" "befintligheter" ; -- befintlighet..nn.1
  befjädrad_1_A = mkA "befjädrad" ; -- befjädrad..av.1
  befjädring_1_N = mkN "befjädring" ; -- befjädring..nn.1
  befläcka_1_V = mkV "befläckar" ; -- befläcka..vb.1
  befläckande_1_N = mkN "befläckande" ; -- befläckande..nn.1
  befläckelse_1_N = mkN "befläckelse" "befläckelser" ; -- befläckelse..nn.1
  befogad_1_A = mkA "befogad" ; -- befogad..av.1
  befogenhet_1_N = mkN "befogenhet" "befogenheter" ; -- befogenhet..nn.1
  befogenhetsförskjutning_1_N = mkN "befogenhetsförskjutning" ; -- befogenhetsförskjutning..nn.1
  befolka_1_V = mkV "befolkar" ; -- befolka..vb.1
  befolkande_1_N = mkN "befolkande" ; -- befolkande..nn.1
  befolkning_1_N = mkN "befolkning" ; -- befolkning..nn.1
  befolkningsexplosion_1_N = mkN "befolkningsexplosion" ; -- befolkningsexplosion..nn.1
  befolkningsgrupp_1_N = mkN "befolkningsgrupp" "befolkningsgrupper" ; -- befolkningsgrupp..nn.1
  befolkningsmässig_1_A = mkA "befolkningsmässig" ; -- befolkningsmässig..av.1
  befolkningspolitik_1_N = mkN "befolkningspolitik" ; -- befolkningspolitik..nn.1
  befolkningspolitisk_1_A = mkA "befolkningspolitisk" ; -- befolkningspolitisk..av.1
  befolkningspyramid_1_N = mkN "befolkningspyramid" "befolkningspyramider" ; -- befolkningspyramid..nn.1
  befolkningsstatistik_1_N = mkN "befolkningsstatistik" "befolkningsstatistiker" ; -- befolkningsstatistik..nn.1
  befolkningstillväxt_1_N = mkN "befolkningstillväxt" ; -- befolkningstillväxt..nn.1
  befolkningsundersökning_1_N = mkN "befolkningsundersökning" ; -- befolkningsundersökning..nn.1
  befolkningsökning_1_N = mkN "befolkningsökning" ; -- befolkningsökning..nn.1
  befordra_1_V = mkV "befordrar" ; -- befordra..vb.1
  befordran_1_N = mkN "befordran" "befordran" "befordringar" "befordringarna" ; -- befordran..nn.1
  befordrande_1_N = mkN "befordrande" ; -- befordrande..nn.1
  befordrare_1_N = mkN "befordrare" utrum  ; -- befordrare..nn.1
  befordring_1_N = mkN "befordring" ; -- befordring..nn.1
  befordringsgrund_1_N = mkN "befordringsgrund" "befordringsgrunder" ; -- befordringsgrund..nn.1
  befordringsgång_1_N = mkN "befordringsgång" ; -- befordringsgång..nn.1
  befrakta_1_V = mkV "befraktar" ; -- befrakta..vb.1
  befraktande_1_N = mkN "befraktande" ; -- befraktande..nn.1
  befraktare_1_N = mkN "befraktare" utrum  ; -- befraktare..nn.1
  befraktning_1_N = mkN "befraktning" ; -- befraktning..nn.1
  befransad_1_A = mkA "befransad" ; -- befransad..av.1
  befria_1_V = mkV "befriar" ; -- befria..vb.1
  befriande_1_A = mkA "befriande" ; -- befriande..av.1
  befriande_1_N = mkN "befriande" ; -- befriande..nn.1
  befriare_1_N = mkN "befriare" utrum  ; -- befriare..nn.1
  befrielse_1_N = mkN "befrielse" "befrielser" ; -- befrielse..nn.1
  befrielseakt_1_N = mkN "befrielseakt" "befrielseakter" ; -- befrielseakt..nn.1
  befrielsearmé_1_N = mkN "befrielsearmé" "befrielsearméer" ; -- befrielsearmé..nn.1
  befrielsefront_1_N = mkN "befrielsefront" "befrielsefronter" ; -- befrielsefront..nn.1
  befrielsekamp_1_N = mkN "befrielsekamp" "befrielsekamper" ; -- befrielsekamp..nn.1
  befrielsekrig_1_N = mkN "befrielsekrig" neutrum  ; -- befrielsekrig..nn.1
  befrielserörelse_1_N = mkN "befrielserörelse" "befrielserörelser" ; -- befrielserörelse..nn.1
  befrukta_1_V = mkV "befruktar" ; -- befrukta..vb.1
  befruktande_1_N = mkN "befruktande" ; -- befruktande..nn.1
  befruktning_1_N = mkN "befruktning" ; -- befruktning..nn.1
  befruktningsorgan_1_N = mkN "befruktningsorgan" neutrum  ; -- befruktningsorgan..nn.1
  befruktningsögonblick_1_N = mkN "befruktningsögonblick" neutrum  ; -- befruktningsögonblick..nn.1
  befrynda_1_V = mkV "befryndar" ; -- befrynda..vb.1
  befryndad_1_A = mkA "befryndad" ; -- befryndad..av.1
  befryndande_1_N = mkN "befryndande" ; -- befryndande..nn.1
  befrämja_1_V = mkV "befrämjar" ; -- befrämja..vb.1
  befrämjande_1_N = mkN "befrämjande" ; -- befrämjande..nn.1
  befrämjare_1_N = mkN "befrämjare" utrum  ; -- befrämjare..nn.1
  befullmäktiga_1_V = mkV "befullmäktigar" ; -- befullmäktiga..vb.1
  befullmäktigande_1_N = mkN "befullmäktigande" ; -- befullmäktigande..nn.1
  befäl_1_N = mkN "befäl" neutrum  ; -- befäl..nn.1
  befäl_2_N = mkN "befäl" neutrum  ; -- befäl..nn.2
  befälhavande_1_A = mkA "befälhavande" ; -- befälhavande..av.1
  befälhavare_1_N = mkN "befälhavare" utrum  ; -- befälhavare..nn.1
  befälselev_1_N = mkN "befälselev" "befälselever" ; -- befälselev..nn.1
  befälsföring_1_N = mkN "befälsföring" ; -- befälsföring..nn.1
  befälsgrad_1_N = mkN "befälsgrad" "befälsgrader" ; -- befälsgrad..nn.1
  befälsordning_1_N = mkN "befälsordning" ; -- befälsordning..nn.1
  befälsperson_1_N = mkN "befälsperson" "befälspersoner" ; -- befälsperson..nn.1
  befälsställning_1_N = mkN "befälsställning" ; -- befälsställning..nn.1
  befälstalang_1_N = mkN "befälstalang" "befälstalanger" ; -- befälstalang..nn.1
  befälstecken_1_N = mkN "befälstecken" "befälstecknet" "befälstecken" "befälstecknen" ; -- befälstecken..nn.1
  befälsuppdrag_1_N = mkN "befälsuppdrag" neutrum  ; -- befälsuppdrag..nn.1
  befängd_1_A = mkA "befängd" "befängt" ; -- befängd..av.1
  befängdhet_1_N = mkN "befängdhet" "befängdheter" ; -- befängdhet..nn.1
  befästa_1_V = mkV "befästa" "befäster" "befäst" "befäste" "befäst" "befäst" ; -- befästa..vb.1
  befästande_1_N = mkN "befästande" ; -- befästande..nn.1
  befästning_1_N = mkN "befästning" ; -- befästning..nn.1
  befästningsgrav_1_N = mkN "befästningsgrav" ; -- befästningsgrav..nn.1
  befästningskonst_1_N = mkN "befästningskonst" ; -- befästningskonst..nn.1
  befästningslinje_1_N = mkN "befästningslinje" "befästningslinjer" ; -- befästningslinje..nn.1
  befästningsskydd_1_N = mkN "befästningsskydd" neutrum  ; -- befästningsskydd..nn.1
  befästningsverk_1_N = mkN "befästningsverk" neutrum  ; -- befästningsverk..nn.1
  begabba_1_V = mkV "begabbar" ; -- begabba..vb.1
  begabbande_1_N = mkN "begabbande" ; -- begabbande..nn.1
  begabbare_1_N = mkN "begabbare" utrum  ; -- begabbare..nn.1
  begabberi_1_N = mkN "begabberi" neutrum  ; -- begabberi..nn.1
  begagna_1_V = mkV "begagnar" ; -- begagna..vb.1
  begagnad_1_A = mkA "begagnad" ; -- begagnad..av.1
  begagnande_1_N = mkN "begagnande" ; -- begagnande..nn.1
  begagnatköp_1_N = mkN "begagnatköp" neutrum  ; -- begagnatköp..nn.1
  begapa_1_V = mkV "begapar" ; -- begapa..vb.1
  begapande_1_N = mkN "begapande" ; -- begapande..nn.1
  begapning_1_N = mkN "begapning" ; -- begapning..nn.1
  begeistrad_1_A = mkA "begeistrad" ; -- begeistrad..av.1
  begeistring_1_N = mkN "begeistring" ; -- begeistring..nn.1
  beginerå_1_N = mkN "beginerå" "beginerån" "beginerår" "beginerårna" ; -- beginerå..nn.1
  begivande_1_N = mkN "begivande" ; -- begivande..nn.1
  begiven_1_A = mkA "begiven" ; -- begiven..av.1
  begivenhet_1_N = mkN "begivenhet" "begivenheter" ; -- begivenhet..nn.1
  begivenhet_2_N = mkN "begivenhet" ; -- begivenhet..nn.2
  begjuta_1_V = mkV "begjuta" "begöt" "begjutit" ; -- begjuta..vb.1
  begjutande_1_N = mkN "begjutande" ; -- begjutande..nn.1
  begjutning_1_N = mkN "begjutning" ; -- begjutning..nn.1
  beglänsa_1_V = mkV "beglänser" ; -- beglänsa..vb.1
  beglänsande_1_N = mkN "beglänsande" ; -- beglänsande..nn.1
  beglänsning_1_N = mkN "beglänsning" ; -- beglänsning..nn.1
  begonia_1_N = mkN "begonia" ; -- begonia..nn.1
  begrava_1_V = mkV "begraver" ; -- begrava..vb.1
  begravande_1_N = mkN "begravande" ; -- begravande..nn.1
  begravning_1_N = mkN "begravning" ; -- begravning..nn.1
  begravningsakt_1_N = mkN "begravningsakt" "begravningsakter" ; -- begravningsakt..nn.1
  begravningsbok_1_N = mkN "begravningsbok" "begravningsböcker" ; -- begravningsbok..nn.1
  begravningsbyrå_1_N = mkN "begravningsbyrå" "begravningsbyråer" ; -- begravningsbyrå..nn.1
  begravningsceremoni_1_N = mkN "begravningsceremoni" "begravningsceremonier" ; -- begravningsceremoni..nn.1
  begravningsdag_1_N = mkN "begravningsdag" ; -- begravningsdag..nn.1
  begravningsentreprenör_1_N = mkN "begravningsentreprenör" "begravningsentreprenörer" ; -- begravningsentreprenör..nn.1
  begravningsgäst_1_N = mkN "begravningsgäst" "begravningsgäster" ; -- begravningsgäst..nn.1
  begravningshjälp_1_N = mkN "begravningshjälp" ; -- begravningshjälp..nn.1
  begravningshögtidlighet_1_N = mkN "begravningshögtidlighet" "begravningshögtidligheter" ; -- begravningshögtidlighet..nn.1
  begravningskalas_1_N = mkN "begravningskalas" neutrum  ; -- begravningskalas..nn.1
  begravningskassa_1_N = mkN "begravningskassa" ; -- begravningskassa..nn.1
  begravningskrans_1_N = mkN "begravningskrans" ; -- begravningskrans..nn.1
  begravningsmarsch_1_N = mkN "begravningsmarsch" "begravningsmarscher" ; -- begravningsmarsch..nn.1
  begravningsmin_1_N = mkN "begravningsmin" "begravningsminer" ; -- begravningsmin..nn.1
  begravningsplats_1_N = mkN "begravningsplats" "begravningsplatser" ; -- begravningsplats..nn.1
  begravningspoesi_1_N = mkN "begravningspoesi" ; -- begravningspoesi..nn.1
  begravningsprocession_1_N = mkN "begravningsprocession" ; -- begravningsprocession..nn.1
  begravningspsalm_1_N = mkN "begravningspsalm" "begravningspsalmer" ; -- begravningspsalm..nn.1
  begravningsringning_1_N = mkN "begravningsringning" ; -- begravningsringning..nn.1
  begravningsspel_1_N = mkN "begravningsspel" "begravningsspelet" "begravningsspel" "begravningsspelen" ; -- begravningsspel..nn.1
  begravningståg_1_N = mkN "begravningståg" neutrum  ; -- begravningståg..nn.1
  begrepp_1_N = mkN "begrepp" neutrum  ; -- begrepp..nn.1
  begreppsanalys_1_N = mkN "begreppsanalys" "begreppsanalyser" ; -- begreppsanalys..nn.1
  begreppsanalytisk_1_A = mkA "begreppsanalytisk" ; -- begreppsanalytisk..av.1
  begreppsapparat_1_N = mkN "begreppsapparat" "begreppsapparater" ; -- begreppsapparat..nn.1
  begreppsbestämning_1_N = mkN "begreppsbestämning" ; -- begreppsbestämning..nn.1
  begreppsbildning_1_N = mkN "begreppsbildning" ; -- begreppsbildning..nn.1
  begreppsexercis_1_N = mkN "begreppsexercis" "begreppsexerciser" ; -- begreppsexercis..nn.1
  begreppsförvirring_1_N = mkN "begreppsförvirring" ; -- begreppsförvirring..nn.1
  begreppsindelning_1_N = mkN "begreppsindelning" ; -- begreppsindelning..nn.1
  begreppsinnehåll_1_N = mkN "begreppsinnehåll" neutrum  ; -- begreppsinnehåll..nn.1
  begreppslig_1_A = mkA "begreppslig" ; -- begreppslig..av.1
  begreppslighet_1_N = mkN "begreppslighet" ; -- begreppslighet..nn.1
  begreppsmässig_1_A = mkA "begreppsmässig" ; -- begreppsmässig..av.1
  begreppsmässighet_1_N = mkN "begreppsmässighet" ; -- begreppsmässighet..nn.1
  begreppsnivå_1_N = mkN "begreppsnivå" "begreppsnivåer" ; -- begreppsnivå..nn.1
  begreppssystem_1_N = mkN "begreppssystem" neutrum  ; -- begreppssystem..nn.1
  begripa_1_V = mkV "begripa" "begrep" "begripit" ; -- begripa..vb.1
  begripande_1_N = mkN "begripande" ; -- begripande..nn.1
  begriplig_1_A = mkA "begriplig" ; -- begriplig..av.1
  begriplighet_1_N = mkN "begriplighet" "begripligheter" ; -- begriplighet..nn.1
  begrunda_1_V = mkV "begrundar" ; -- begrunda..vb.1
  begrundande_1_N = mkN "begrundande" ; -- begrundande..nn.1
  begränsa_1_V = mkV "begränsar" ; -- begränsa..vb.1
  begränsad_1_A = mkA "begränsad" ; -- begränsad..av.1
  begränsande_1_N = mkN "begränsande" ; -- begränsande..nn.1
  begränsning_1_N = mkN "begränsning" ; -- begränsning..nn.1
  begränsningslinje_1_N = mkN "begränsningslinje" "begränsningslinjer" ; -- begränsningslinje..nn.1
  begränsningsyta_1_N = mkN "begränsningsyta" ; -- begränsningsyta..nn.1
  begråta_1_V = mkV "begråta" "begrät" "begråtit" ; -- begråta..vb.1
  begråtande_1_N = mkN "begråtande" ; -- begråtande..nn.1
  begynna_1_V = mkV "begynna" "begynte" "begynt" ; -- begynna..vb.1
  begynnande_1_N = mkN "begynnande" ; -- begynnande..nn.1
  begynnelse_1_N = mkN "begynnelse" "begynnelser" ; -- begynnelse..nn.1
  begynnelsebokstav_1_N = mkN "begynnelsebokstav" "begynnelsebokstäver" ; -- begynnelsebokstav..nn.1
  begynnelsehastighet_1_N = mkN "begynnelsehastighet" "begynnelsehastigheter" ; -- begynnelsehastighet..nn.1
  begynnelselön_1_N = mkN "begynnelselön" "begynnelselöner" ; -- begynnelselön..nn.1
  begynnelserim_1_N = mkN "begynnelserim" "begynnelserimmet" "begynnelserim" "begynnelserimmen" ; -- begynnelserim..nn.1
  begynnelseskede_1_N = mkN "begynnelseskede" ; -- begynnelseskede..nn.1
  begynnelsespråk_1_N = mkN "begynnelsespråk" neutrum  ; -- begynnelsespråk..nn.1
  begynnelsestadium_1_N = mkN "begynnelsestadium" "begynnelsestadiet" "begynnelsestadier" "begynnelsestadierna" ; -- begynnelsestadium..nn.1
  begynnelsevärde_1_N = mkN "begynnelsevärde" ; -- begynnelsevärde..nn.1
  begär_1_N = mkN "begär" neutrum  ; -- begär..nn.1
  begära_1_V = mkV "begära" "begärde" "begärt" ; -- begära..vb.1
  begärande_1_N = mkN "begärande" ; -- begärande..nn.1
  begärelse_1_N = mkN "begärelse" "begärelser" ; -- begärelse..nn.1
  begärlig_1_A = mkA "begärlig" ; -- begärlig..av.1
  begärlighet_1_N = mkN "begärlighet" "begärligheter" ; -- begärlighet..nn.1
  begärsliv_1_N = mkN "begärsliv" neutrum  ; -- begärsliv..nn.1
  begå_1_V = mkV "begå" "begår" "begå" "begick" "begått" "begången" ; -- begå..vb.1
  begående_1_N = mkN "begående" ; -- begående..nn.1
  begåva_1_V = mkV "begåvar" ; -- begåva..vb.1
  begåvad_1_A = mkA "begåvad" ; -- begåvad..av.1
  begåvande_1_N = mkN "begåvande" ; -- begåvande..nn.1
  begåvning_1_N = mkN "begåvning" ; -- begåvning..nn.1
  begåvning_2_N = mkN "begåvning" ; -- begåvning..nn.2
  begåvningsmässig_1_A = mkA "begåvningsmässig" ; -- begåvningsmässig..av.1
  begåvningsreserv_1_N = mkN "begåvningsreserv" "begåvningsreserver" ; -- begåvningsreserv..nn.1
  behag_1_N = mkN "behag" neutrum  ; -- behag..nn.1
  behaga_1_V = mkV "behagar" ; -- behaga..vb.1
  behagande_1_N = mkN "behagande" ; -- behagande..nn.1
  behagfull_1_A = mkA "behagfull" ; -- behagfull..av.1
  behagfullhet_1_N = mkN "behagfullhet" "behagfullheter" ; -- behagfullhet..nn.1
  behaglig_1_A = mkA "behaglig" ; -- behaglig..av.1
  behaglighet_1_N = mkN "behaglighet" "behagligheter" ; -- behaglighet..nn.1
  behagsjuk_1_A = mkA "behagsjuk" ; -- behagsjuk..av.1
  behagsjuka_1_N = mkN "behagsjuka" ; -- behagsjuka..nn.1
  behagsjukhet_1_N = mkN "behagsjukhet" ; -- behagsjukhet..nn.1
  behandla_1_V = mkV "behandlar" ; -- behandla..vb.1
  behandlande_1_N = mkN "behandlande" ; -- behandlande..nn.1
  behandling_1_N = mkN "behandling" ; -- behandling..nn.1
  behandlingsalternativ_1_N = mkN "behandlingsalternativ" neutrum  ; -- behandlingsalternativ..nn.1
  behandlingsbar_1_A = mkA "behandlingsbar" ; -- behandlingsbar..av.1
  behandlingsbarhet_1_N = mkN "behandlingsbarhet" ; -- behandlingsbarhet..nn.1
  behandlingsenhet_1_N = mkN "behandlingsenhet" "behandlingsenheter" ; -- behandlingsenhet..nn.1
  behandlingshem_1_N = mkN "behandlingshem" "behandlingshemmet" "behandlingshem" "behandlingshemmen" ; -- behandlingshem..nn.1
  behandlingsmetod_1_N = mkN "behandlingsmetod" "behandlingsmetoder" ; -- behandlingsmetod..nn.1
  behandlingsmässig_1_A = mkA "behandlingsmässig" ; -- behandlingsmässig..av.1
  behandlingsprogram_1_N = mkN "behandlingsprogram" "behandlingsprogrammet" "behandlingsprogram" "behandlingsprogrammen" ; -- behandlingsprogram..nn.1
  behandlingsrum_1_N = mkN "behandlingsrum" "behandlingsrummet" "behandlingsrum" "behandlingsrummen" ; -- behandlingsrum..nn.1
  behandlingssätt_1_N = mkN "behandlingssätt" neutrum  ; -- behandlingssätt..nn.1
  behandskad_1_A = mkA "behandskad" ; -- behandskad..av.1
  behaviorism_1_N = mkN "behaviorism" "behaviorismer" ; -- behaviorism..nn.1
  behaviorist_1_N = mkN "behaviorist" "behaviorister" ; -- behaviorist..nn.1
  behavioristisk_1_A = mkA "behavioristisk" ; -- behavioristisk..av.1
  behjälplig_1_A = mkA "behjälplig" ; -- behjälplig..av.1
  behjälplighet_1_N = mkN "behjälplighet" ; -- behjälplighet..nn.1
  behjärtad_1_A = mkA "behjärtad" ; -- behjärtad..av.1
  behjärtansvärd_1_A = mkA "behjärtansvärd" "behjärtansvärt" ; -- behjärtansvärd..av.1
  behjärtenhet_1_N = mkN "behjärtenhet" "behjärtenheter" ; -- behjärtenhet..nn.1
  behornad_1_A = mkA "behornad" ; -- behornad..av.1
  behov_1_N = mkN "behov" neutrum  ; -- behov..nn.1
  behovlös_1_A = mkA "behovlös" ; -- behovlös..av.1
  behovlöshet_1_N = mkN "behovlöshet" "behovlösheter" ; -- behovlöshet..nn.1
  behovsprincip_1_N = mkN "behovsprincip" "behovsprinciper" ; -- behovsprincip..nn.1
  behovsprövad_1_A = mkA "behovsprövad" ; -- behovsprövad..av.1
  behovsprövning_1_N = mkN "behovsprövning" ; -- behovsprövning..nn.1
  behovstillfredsställelse_1_N = mkN "behovstillfredsställelse" "behovstillfredsställelser" ; -- behovstillfredsställelse..nn.1
  behovstryck_1_N = mkN "behovstryck" neutrum  ; -- behovstryck..nn.1
  behäftad_1_A = mkA "behäftad" ; -- behäftad..av.1
  behändig_1_A = mkA "behändig" ; -- behändig..av.1
  behändighet_1_N = mkN "behändighet" ; -- behändighet..nn.1
  behänga_1_V = mkV "behänger" ; -- behänga..vb.1
  behängande_1_N = mkN "behängande" ; -- behängande..nn.1
  behängning_1_N = mkN "behängning" ; -- behängning..nn.1
  behärska_1_V = mkV "behärskar" ; -- behärska..vb.1
  behärskad_1_A = mkA "behärskad" ; -- behärskad..av.1
  behärskande_1_N = mkN "behärskande" ; -- behärskande..nn.1
  behärskning_1_N = mkN "behärskning" ; -- behärskning..nn.1
  behå_1_N = mkN "behå" ; -- behå..nn.1
  behålla_1_V = mkV "behålla" "behöll" "behållit" ; -- behålla..vb.1
  behållande_1_N = mkN "behållande" ; -- behållande..nn.1
  behållare_1_N = mkN "behållare" utrum  ; -- behållare..nn.1
  behållen_1_A = mkA "behållen" ; -- behållen..av.1
  behållning_1_N = mkN "behållning" ; -- behållning..nn.1
  behårad_1_A = mkA "behårad" ; -- behårad..av.1
  behåring_1_N = mkN "behåring" ; -- behåring..nn.1
  behörig_1_A = mkA "behörig" ; -- behörig..av.1
  behörighet_1_N = mkN "behörighet" "behörigheter" ; -- behörighet..nn.1
  behörighetsbevis_1_N = mkN "behörighetsbevis" neutrum  ; -- behörighetsbevis..nn.1
  behöva_1_V = mkV "behöver" ; -- behöva..vb.1
  behövande_1_A = mkA "behövande" ; -- behövande..av.1
  behövande_1_N = mkN "behövande" ; -- behövande..nn.1
  behövlig_1_A = mkA "behövlig" ; -- behövlig..av.1
  behövlighet_1_N = mkN "behövlighet" ; -- behövlighet..nn.1
  beige_1_A = mkA "beige" "beiget" ; -- beige..av.1
  beige_1_N = mkN "beige" ; -- beige..nn.1
  beivra_1_V = mkV "beivrar" ; -- beivra..vb.1
  beivrande_1_N = mkN "beivrande" ; -- beivrande..nn.1
  beivrare_1_N = mkN "beivrare" utrum  ; -- beivrare..nn.1
  bej_1_N = mkN "bej" "bejer" ; -- bej..nn.1
  bejaka_1_V = mkV "bejakar" ; -- bejaka..vb.1
  bejakande_1_N = mkN "bejakande" ; -- bejakande..nn.1
  bejakning_1_N = mkN "bejakning" ; -- bejakning..nn.1
  bejubla_1_V = mkV "bejublar" ; -- bejubla..vb.1
  bejublande_1_N = mkN "bejublande" ; -- bejublande..nn.1
  bekaja_1_V = mkV "bekajar" ; -- bekaja..vb.1
  bekajande_1_N = mkN "bekajande" ; -- bekajande..nn.1
  bekant_1_A = mkA "bekant" "bekant" ; -- bekant..av.1
  bekant_1_N = mkN "bekant" "bekanten" "bekanta" "bekanterna" ; -- bekant..nn.1
  bekanta_1_V = mkV "bekantar" ; -- bekanta..vb.1
  bekantande_1_N = mkN "bekantande" ; -- bekantande..nn.1
  bekantgöra_1_V = mkV "bekantgöra" "bekantgjorde" "bekantgjort" ; -- bekantgöra..vb.1
  bekantgörande_1_N = mkN "bekantgörande" ; -- bekantgörande..nn.1
  bekanting_1_N = mkN "bekanting" ; -- bekanting..nn.1
  bekantskap_1_N = mkN "bekantskap" "bekantskaper" ; -- bekantskap..nn.1
  bekantskapskrets_1_N = mkN "bekantskapskrets" ; -- bekantskapskrets..nn.1
  bekika_1_V = mkV "bekikar" ; -- bekika..vb.1
  bekikande_1_N = mkN "bekikande" ; -- bekikande..nn.1
  beklaga_1_V = mkV "beklagar" ; -- beklaga..vb.1
  beklagande_1_N = mkN "beklagande" ; -- beklagande..nn.1
  beklagansvärd_1_A = mkA "beklagansvärd" "beklagansvärt" ; -- beklagansvärd..av.1
  beklaglig_1_A = mkA "beklaglig" ; -- beklaglig..av.1
  beklagligen_1_Adv = mkAdv "beklagligen" ; -- beklagligen..ab.1
  beklaglighet_1_N = mkN "beklaglighet" ; -- beklaglighet..nn.1
  beklagligtvis_1_Adv = mkAdv "beklagligtvis" ; -- beklagligtvis..ab.1
  beklä_1_V = mkV "beklä" "beklädde" "beklätt" ; -- beklä..vb.1
  beklädande_1_N = mkN "beklädande" ; -- beklädande..nn.1
  beklädnad_1_N = mkN "beklädnad" "beklädnader" ; -- beklädnad..nn.1
  beklädning_1_N = mkN "beklädning" ; -- beklädning..nn.1
  beklämd_1_A = mkA "beklämd" "beklämt" ; -- beklämd..av.1
  beklämdhet_1_N = mkN "beklämdhet" ; -- beklämdhet..nn.1
  beklämmande_1_A = mkA "beklämmande" ; -- beklämmande..av.1
  beklämning_1_N = mkN "beklämning" ; -- beklämning..nn.1
  beknip_1_N = mkN "beknip" neutrum  ; -- beknip..nn.1
  beknipa_1_V = mkV "beknipa" "beknep" "beknipit" ; -- beknipa..vb.1
  beknipande_1_N = mkN "beknipande" ; -- beknipande..nn.1
  bekomma_1_V = mkV "bekomma" "bekom" "bekommit" ; -- bekomma..vb.1
  bekommande_1_N = mkN "bekommande" ; -- bekommande..nn.1
  bekosta_1_V = mkV "bekostar" ; -- bekosta..vb.1
  bekostande_1_N = mkN "bekostande" ; -- bekostande..nn.1
  bekostnad_1_N = mkN "bekostnad" "bekostnader" ; -- bekostnad..nn.1
  bekransa_1_V = mkV "bekransar" ; -- bekransa..vb.1
  bekransande_1_N = mkN "bekransande" ; -- bekransande..nn.1
  bekransning_1_N = mkN "bekransning" ; -- bekransning..nn.1
  bekriga_1_V = mkV "bekrigar" ; -- bekriga..vb.1
  bekrigande_1_N = mkN "bekrigande" ; -- bekrigande..nn.1
  bekräfta_1_V = mkV "bekräftar" ; -- bekräfta..vb.1
  bekräftande_1_N = mkN "bekräftande" ; -- bekräftande..nn.1
  bekräftelse_1_N = mkN "bekräftelse" "bekräftelser" ; -- bekräftelse..nn.1
  bekräftelsebehov_1_N = mkN "bekräftelsebehov" neutrum  ; -- bekräftelsebehov..nn.1
  bekräftelsesökande_1_A = mkA "bekräftelsesökande" ; -- bekräftelsesökande..av.1
  bekröna_1_V = mkV "bekröna" "bekröner" "bekrön" "bekrönte" "bekrönt" "bekrönt" ; -- bekröna..vb.1
  bekrönande_1_N = mkN "bekrönande" ; -- bekrönande..nn.1
  bekröning_1_N = mkN "bekröning" ; -- bekröning..nn.1
  bekväm_1_A = mkA "bekväm" ; -- bekväm..av.1
  bekvämhet_1_N = mkN "bekvämhet" ; -- bekvämhet..nn.1
  bekvämlighet_1_N = mkN "bekvämlighet" "bekvämligheter" ; -- bekvämlighet..nn.1
  bekvämlighetsflagg_1_N = mkN "bekvämlighetsflagg" ; -- bekvämlighetsflagg..nn.1
  bekvämlighetshänsyn_1_N = mkN "bekvämlighetshänsyn" "bekvämlighetshänsynen" "bekvämlighetshänsyn" "bekvämlighetshänsynen" ; -- bekvämlighetshänsyn..nn.1
  bekvämlighetsinrättning_1_N = mkN "bekvämlighetsinrättning" ; -- bekvämlighetsinrättning..nn.1
  bekymmer_1_N = mkN "bekymmer" neutrum  ; -- bekymmer..nn.1
  bekymmerfri_1_A = mkA "bekymmerfri" "bekymmerfritt" ; -- bekymmerfri..av.1
  bekymmersam_1_A = mkA "bekymmersam" "bekymmersamt" "bekymmersamma" "bekymmersamma" "bekymmersammare" "bekymmersammast" "bekymmersammaste" ; -- bekymmersam..av.1
  bekymmersamhet_1_N = mkN "bekymmersamhet" ; -- bekymmersamhet..nn.1
  bekymmersfri_1_A = mkA "bekymmersfri" "bekymmersfritt" ; -- bekymmersfri..av.1
  bekymmersfull_1_A = mkA "bekymmersfull" ; -- bekymmersfull..av.1
  bekymmerslös_1_A = mkA "bekymmerslös" ; -- bekymmerslös..av.1
  bekymmerslöshet_1_N = mkN "bekymmerslöshet" ; -- bekymmerslöshet..nn.1
  bekymmersrynka_1_N = mkN "bekymmersrynka" ; -- bekymmersrynka..nn.1
  bekymra_1_V = mkV "bekymrar" ; -- bekymra..vb.1
  bekymrad_1_A = mkA "bekymrad" ; -- bekymrad..av.1
  bekymrande_1_N = mkN "bekymrande" ; -- bekymrande..nn.1
  bekyttad_1_A = mkA "bekyttad" ; -- bekyttad..av.1
  bekämpa_1_V = mkV "bekämpar" ; -- bekämpa..vb.1
  bekämpande_1_N = mkN "bekämpande" ; -- bekämpande..nn.1
  bekämpare_1_N = mkN "bekämpare" utrum  ; -- bekämpare..nn.1
  bekämpning_1_N = mkN "bekämpning" ; -- bekämpning..nn.1
  bekämpningsmedel_1_N = mkN "bekämpningsmedel" neutrum  ; -- bekämpningsmedel..nn.1
  bekänna_1_V = mkV "bekänna" "bekände" "bekänt" ; -- bekänna..vb.1
  bekännande_1_N = mkN "bekännande" ; -- bekännande..nn.1
  bekännare_1_N = mkN "bekännare" utrum  ; -- bekännare..nn.1
  bekännelse_1_N = mkN "bekännelse" "bekännelser" ; -- bekännelse..nn.1
  bekännelsefrihet_1_N = mkN "bekännelsefrihet" "bekännelsefriheter" ; -- bekännelsefrihet..nn.1
  bekännelseroman_1_N = mkN "bekännelseroman" "bekännelseromaner" ; -- bekännelseroman..nn.1
  bekännelseskrift_1_N = mkN "bekännelseskrift" "bekännelseskrifter" ; -- bekännelseskrift..nn.1
  belacka_1_V = mkV "belackar" ; -- belacka..vb.1
  belackande_1_N = mkN "belackande" ; -- belackande..nn.1
  belackare_1_N = mkN "belackare" utrum  ; -- belackare..nn.1
  belag_1_N = mkN "belag" neutrum  ; -- belag..nn.1
  belamra_1_V = mkV "belamrar" ; -- belamra..vb.1
  belamrande_1_N = mkN "belamrande" ; -- belamrande..nn.1
  belanga_1_V = mkV "belangar" ; -- belanga..vb.1
  belangande_1_N = mkN "belangande" ; -- belangande..nn.1
  belasta_1_V = mkV "belastar" ; -- belasta..vb.1
  belastande_1_N = mkN "belastande" ; -- belastande..nn.1
  belastning_1_N = mkN "belastning" ; -- belastning..nn.1
  belastningsregister_1_N = mkN "belastningsregister" neutrum  ; -- belastningsregister..nn.1
  belastningsskada_1_N = mkN "belastningsskada" ; -- belastningsskada..nn.1
  belastningsuppgift_1_N = mkN "belastningsuppgift" "belastningsuppgifter" ; -- belastningsuppgift..nn.1
  belcanto_1_N = mkN "belcanto" ; -- belcanto..nn.1
  bele_1_V = mkV "bele" "belog" "belett" ; -- bele..vb.1
  beledsaga_1_V = mkV "beledsagar" ; -- beledsaga..vb.1
  beledsagande_1_N = mkN "beledsagande" ; -- beledsagande..nn.1
  beledsagare_1_N = mkN "beledsagare" utrum  ; -- beledsagare..nn.1
  beledsagning_1_N = mkN "beledsagning" ; -- beledsagning..nn.1
  beleende_1_N = mkN "beleende" ; -- beleende..nn.1
  belemnit_1_N = mkN "belemnit" "belemniter" ; -- belemnit..nn.1
  belevad_1_A = mkA "belevad" ; -- belevad..av.1
  belevenhet_1_N = mkN "belevenhet" "belevenheter" ; -- belevenhet..nn.1
  belgare_1_N = mkN "belgare" utrum  ; -- belgare..nn.1
  belgier_1_N = mkN "belgier" "belgiern" "belgier" "belgierna" ; -- belgier..nn.1
  belgisk_1_A = mkA "belgisk" ; -- belgisk..av.1
  belgiska_1_N = mkN "belgiska" ; -- belgiska..nn.1
  belizier_1_N = mkN "belizier" "beliziern" "belizier" "belizierna" ; -- belizier..nn.1
  belizisk_1_A = mkA "belizisk" ; -- belizisk..av.1
  beliziska_1_N = mkN "beliziska" ; -- beliziska..nn.1
  beljuga_1_V = mkV "beljuga" "beljög" "beljugit" ; -- beljuga..vb.1
  beljugande_1_N = mkN "beljugande" ; -- beljugande..nn.1
  belladonna_1_N = mkN "belladonna" ; -- belladonna..nn.1
  belletrist_1_N = mkN "belletrist" "belletrister" ; -- belletrist..nn.1
  belletristik_1_N = mkN "belletristik" ; -- belletristik..nn.1
  belletristisk_1_A = mkA "belletristisk" ; -- belletristisk..av.1
  bellis_1_N = mkN "bellis" ; -- bellis..nn.1
  bellit_1_N = mkN "bellit" ; -- bellit..nn.1
  belopp_1_N = mkN "belopp" neutrum  ; -- belopp..nn.1
  belysa_1_V = mkV "belyser" ; -- belysa..vb.1
  belysande_1_A = mkA "belysande" ; -- belysande..av.1
  belysande_1_N = mkN "belysande" ; -- belysande..nn.1
  belysning_1_N = mkN "belysning" ; -- belysning..nn.1
  belysningsarmatur_1_N = mkN "belysningsarmatur" "belysningsarmaturer" ; -- belysningsarmatur..nn.1
  belysningsmässa_1_N = mkN "belysningsmässa" ; -- belysningsmässa..nn.1
  belysningsström_1_N = mkN "belysningsström" "belysningsströmmen" "belysningsströmmar" "belysningsströmmarna" ; -- belysningsström..nn.1
  belysningsstyrka_1_N = mkN "belysningsstyrka" ; -- belysningsstyrka..nn.1
  belägen_1_A = mkA "belägen" ; -- belägen..av.1
  belägenhet_1_N = mkN "belägenhet" "belägenheter" ; -- belägenhet..nn.1
  belägg_1_N = mkN "belägg" neutrum  ; -- belägg..nn.1
  belägga_1_V = mkV "belägga" "bela" "belagt" ; -- belägga..vb.1
  beläggande_1_N = mkN "beläggande" ; -- beläggande..nn.1
  beläggning_1_N = mkN "beläggning" ; -- beläggning..nn.1
  beläggningsgrad_1_N = mkN "beläggningsgrad" "beläggningsgrader" ; -- beläggningsgrad..nn.1
  beläggningsring_1_N = mkN "beläggningsring" ; -- beläggningsring..nn.1
  beläggningssnöre_1_N = mkN "beläggningssnöre" ; -- beläggningssnöre..nn.1
  beläggningsstämpel_1_N = mkN "beläggningsstämpel" ; -- beläggningsstämpel..nn.1
  beläggställe_1_N = mkN "beläggställe" ; -- beläggställe..nn.1
  belägra_1_V = mkV "belägrar" ; -- belägra..vb.1
  belägrande_1_N = mkN "belägrande" ; -- belägrande..nn.1
  belägring_1_N = mkN "belägring" ; -- belägring..nn.1
  belägringsartilleri_1_N = mkN "belägringsartilleri" neutrum  ; -- belägringsartilleri..nn.1
  belägringskonst_1_N = mkN "belägringskonst" ; -- belägringskonst..nn.1
  belägringstillstånd_1_N = mkN "belägringstillstånd" neutrum  ; -- belägringstillstånd..nn.1
  belägringstorn_1_N = mkN "belägringstorn" neutrum  ; -- belägringstorn..nn.1
  beläsenhet_1_N = mkN "beläsenhet" "beläsenheter" ; -- beläsenhet..nn.1
  beläst_1_A = mkA "beläst" "beläst" ; -- beläst..av.1
  belästhet_1_N = mkN "belästhet" "belästheter" ; -- belästhet..nn.1
  beläte_1_N = mkN "beläte" ; -- beläte..nn.1
  belåna_1_V = mkV "belånar" ; -- belåna..vb.1
  belånande_1_N = mkN "belånande" ; -- belånande..nn.1
  belåning_1_N = mkN "belåning" ; -- belåning..nn.1
  belåningsgrad_1_N = mkN "belåningsgrad" "belåningsgrader" ; -- belåningsgrad..nn.1
  belåten_1_A = mkA "belåten" ; -- belåten..av.1
  belåtenhet_1_N = mkN "belåtenhet" "belåtenheter" ; -- belåtenhet..nn.1
  belöna_1_V = mkV "belönar" ; -- belöna..vb.1
  belönande_1_N = mkN "belönande" ; -- belönande..nn.1
  belöning_1_N = mkN "belöning" ; -- belöning..nn.1
  belöningsmedalj_1_N = mkN "belöningsmedalj" "belöningsmedaljer" ; -- belöningsmedalj..nn.1
  belöningssystem_1_N = mkN "belöningssystem" neutrum  ; -- belöningssystem..nn.1
  bemanna_1_V = mkV "bemannar" ; -- bemanna..vb.1
  bemannad_1_A = mkA "bemannad" ; -- bemannad..av.1
  bemannande_1_N = mkN "bemannande" ; -- bemannande..nn.1
  bemanning_1_N = mkN "bemanning" ; -- bemanning..nn.1
  bemanningsföretag_1_N = mkN "bemanningsföretag" neutrum  ; -- bemanningsföretag..nn.1
  bemanningsverksamhet_1_N = mkN "bemanningsverksamhet" "bemanningsverksamheter" ; -- bemanningsverksamhet..nn.1
  bemantla_1_V = mkV "bemantlar" ; -- bemantla..vb.1
  bemantlande_1_N = mkN "bemantlande" ; -- bemantlande..nn.1
  bemedla_1_V = mkV "bemedlar" ; -- bemedla..vb.1
  bemedlad_1_A = mkA "bemedlad" ; -- bemedlad..av.1
  bemedlande_1_N = mkN "bemedlande" ; -- bemedlande..nn.1
  bemedling_1_N = mkN "bemedling" ; -- bemedling..nn.1
  bemyndiga_1_V = mkV "bemyndigar" ; -- bemyndiga..vb.1
  bemyndigande_1_N = mkN "bemyndigande" ; -- bemyndigande..nn.1
  bemälde_1_A = mkA "bemälde" ; -- bemälde..av.1
  bemänga_1_V = mkV "bemänger" ; -- bemänga..vb.1
  bemängande_1_N = mkN "bemängande" ; -- bemängande..nn.1
  bemärka_1_V = mkV "bemärker" ; -- bemärka..vb.1
  bemärkande_1_N = mkN "bemärkande" ; -- bemärkande..nn.1
  bemärkelse_1_N = mkN "bemärkelse" "bemärkelser" ; -- bemärkelse..nn.1
  bemärkelsedag_1_N = mkN "bemärkelsedag" ; -- bemärkelsedag..nn.1
  bemärkt_1_A = mkA "bemärkt" "bemärkt" ; -- bemärkt..av.1
  bemärkthet_1_N = mkN "bemärkthet" ; -- bemärkthet..nn.1
  bemästra_1_V = mkV "bemästrar" ; -- bemästra..vb.1
  bemästrande_1_N = mkN "bemästrande" ; -- bemästrande..nn.1
  bemåla_1_V = mkV "bemålar" ; -- bemåla..vb.1
  bemålande_1_N = mkN "bemålande" ; -- bemålande..nn.1
  bemålning_1_N = mkN "bemålning" ; -- bemålning..nn.1
  bemödande_1_N = mkN "bemödande" ; -- bemödande..nn.1
  bemöta_1_V = mkV "bemöter" ; -- bemöta..vb.1
  bemötande_1_N = mkN "bemötande" ; -- bemötande..nn.1
  ben_1_N = mkN "ben" neutrum  ; -- ben..nn.1
  bena_1_N = mkN "bena" ; -- bena..nn.1
  bena_1_V = mkV "benar" ; -- bena..vb.1
  benande_1_N = mkN "benande" ; -- benande..nn.1
  benaska_1_N = mkN "benaska" ; -- benaska..nn.1
  benbildning_1_N = mkN "benbildning" ; -- benbildning..nn.1
  benbrosk_1_N = mkN "benbrosk" neutrum  ; -- benbrosk..nn.1
  benbrott_1_N = mkN "benbrott" neutrum  ; -- benbrott..nn.1
  benediktin_1_N = mkN "benediktin" "benediktiner" ; -- benediktin..nn.1
  benediktinerkloster_1_N = mkN "benediktinerkloster" neutrum  ; -- benediktinerkloster..nn.1
  benediktinermunk_1_N = mkN "benediktinermunk" ; -- benediktinermunk..nn.1
  benediktinerorden_1_N = mkN "benediktinerorden" ; -- benediktinerorden..nn.1
  benediktinkloster_1_N = mkN "benediktinkloster" neutrum  ; -- benediktinkloster..nn.1
  benediktinorden_1_N = mkN "benediktinorden" ; -- benediktinorden..nn.1
  beneficium_1_N = mkN "beneficium" "beneficiet" "beneficier" "beneficierna" ; -- beneficium..nn.1
  benefik_1_A = mkA "benefik" ; -- benefik..av.1
  benfisk_1_N = mkN "benfisk" ; -- benfisk..nn.1
  benfragment_1_N = mkN "benfragment" neutrum  ; -- benfragment..nn.1
  benfri_1_A = mkA "benfri" "benfritt" ; -- benfri..av.1
  benfärgad_1_A = mkA "benfärgad" ; -- benfärgad..av.1
  bengalisk_1_A = mkA "bengalisk" ; -- bengalisk..av.1
  benget_1_N = mkN "benget" "bengetter" ; -- benget..nn.1
  bengädda_1_N = mkN "bengädda" ; -- bengädda..nn.1
  benhinna_1_N = mkN "benhinna" ; -- benhinna..nn.1
  benhinneinflammation_1_N = mkN "benhinneinflammation" ; -- benhinneinflammation..nn.1
  benhus_1_N = mkN "benhus" neutrum  ; -- benhus..nn.1
  benhård_1_A = mkA "benhård" "benhårt" ; -- benhård..av.1
  benhårdhet_1_N = mkN "benhårdhet" ; -- benhårdhet..nn.1
  benig_1_A = mkA "benig" ; -- benig..av.1
  benign_1_A = mkA "benign" ; -- benign..av.1
  beninier_1_N = mkN "beninier" "beniniern" "beninier" "beninierna" ; -- beninier..nn.1
  beninsk_1_A = mkA "beninsk" ; -- beninsk..av.1
  beninska_1_N = mkN "beninska" ; -- beninska..nn.1
  benjamin_1_N = mkN "benjamin" ; -- benjamin..nn.1
  benjaminfikus_1_N = mkN "benjaminfikus" ; -- benjaminfikus..nn.1
  benkirurg_1_N = mkN "benkirurg" "benkirurger" ; -- benkirurg..nn.1
  benknota_1_N = mkN "benknota" ; -- benknota..nn.1
  benknäckare_1_N = mkN "benknäckare" utrum  ; -- benknäckare..nn.1
  benling_1_N = mkN "benling" ; -- benling..nn.1
  benlås_1_N = mkN "benlås" neutrum  ; -- benlås..nn.1
  benmjöl_1_N = mkN "benmjöl" neutrum  ; -- benmjöl..nn.1
  benmuskel_1_N = mkN "benmuskel" "benmuskeln" "benmuskler" "benmusklerna" ; -- benmuskel..nn.1
  benmärg_1_N = mkN "benmärg" ; -- benmärg..nn.1
  benmärgscancer_1_N = mkN "benmärgscancer" ; -- benmärgscancer..nn.1
  benpipa_1_N = mkN "benpipa" ; -- benpipa..nn.1
  benporslin_1_N = mkN "benporslin" "benporslinet" "benporsliner" "benporslinerna" ; -- benporslin..nn.1
  benprotes_1_N = mkN "benprotes" "benproteser" ; -- benprotes..nn.1
  benrangel_1_N = mkN "benrangel" neutrum  ; -- benrangel..nn.1
  benrangelsman_1_N = mkN "benrangelsman" "benrangelsmannen" "benrangelsmän" "benrangelsmännen" ; -- benrangelsman..nn.1
  benrest_1_N = mkN "benrest" "benrester" ; -- benrest..nn.1
  benröta_1_N = mkN "benröta" ; -- benröta..nn.1
  bensen_1_N = mkN "bensen" neutrum  ; -- bensen..nn.1
  bensin_1_N = mkN "bensin" ; -- bensin..nn.1
  bensinautomat_1_N = mkN "bensinautomat" "bensinautomater" ; -- bensinautomat..nn.1
  bensinbolag_1_N = mkN "bensinbolag" neutrum  ; -- bensinbolag..nn.1
  bensinbomb_1_N = mkN "bensinbomb" "bensinbomber" ; -- bensinbomb..nn.1
  bensinbrist_1_N = mkN "bensinbrist" ; -- bensinbrist..nn.1
  bensindriven_1_A = mkA "bensindriven" ; -- bensindriven..av.1
  bensindunk_1_N = mkN "bensindunk" ; -- bensindunk..nn.1
  bensinförbrukning_1_N = mkN "bensinförbrukning" ; -- bensinförbrukning..nn.1
  bensinförsäljning_1_N = mkN "bensinförsäljning" ; -- bensinförsäljning..nn.1
  bensinmack_1_N = mkN "bensinmack" ; -- bensinmack..nn.1
  bensinmotor_1_N = mkN "bensinmotor" "bensinmotorer" ; -- bensinmotor..nn.1
  bensinpris_1_N = mkN "bensinpris" neutrum  ; -- bensinpris..nn.1
  bensinpump_1_N = mkN "bensinpump" ; -- bensinpump..nn.1
  bensinskatt_1_N = mkN "bensinskatt" "bensinskatter" ; -- bensinskatt..nn.1
  bensinskattehöjning_1_N = mkN "bensinskattehöjning" ; -- bensinskattehöjning..nn.1
  bensinslukande_1_A = mkA "bensinslukande" ; -- bensinslukande..av.1
  bensinsnål_1_A = mkA "bensinsnål" ; -- bensinsnål..av.1
  bensinsnålhet_1_N = mkN "bensinsnålhet" ; -- bensinsnålhet..nn.1
  bensinstation_1_N = mkN "bensinstation" ; -- bensinstation..nn.1
  bensinstopp_1_N = mkN "bensinstopp" neutrum  ; -- bensinstopp..nn.1
  bensintank_1_N = mkN "bensintank" ; -- bensintank..nn.1
  bensintillsats_1_N = mkN "bensintillsats" "bensintillsatser" ; -- bensintillsats..nn.1
  benskada_1_N = mkN "benskada" ; -- benskada..nn.1
  benskena_1_N = mkN "benskena" ; -- benskena..nn.1
  benskydd_1_N = mkN "benskydd" neutrum  ; -- benskydd..nn.1
  benskör_1_A = mkA "benskör" ; -- benskör..av.1
  benskörhet_1_N = mkN "benskörhet" "benskörheter" ; -- benskörhet..nn.1
  bensoe_1_N = mkN "bensoe" utrum  ; -- bensoe..nn.1
  bensoesyra_1_N = mkN "bensoesyra" ; -- bensoesyra..nn.1
  bensol_1_N = mkN "bensol" ; -- bensol..nn.1
  benspets_1_N = mkN "benspets" ; -- benspets..nn.1
  benstamp_1_N = mkN "benstamp" ; -- benstamp..nn.1
  benstomme_1_N = mkN "benstomme" utrum  ; -- benstomme..nn.1
  bensträckare_1_N = mkN "bensträckare" utrum  ; -- bensträckare..nn.1
  benstråle_1_N = mkN "benstråle" utrum  ; -- benstråle..nn.1
  bensubstans_1_N = mkN "bensubstans" "bensubstanser" ; -- bensubstans..nn.1
  bensvulst_1_N = mkN "bensvulst" "bensvulster" ; -- bensvulst..nn.1
  bensår_1_N = mkN "bensår" neutrum  ; -- bensår..nn.1
  bentonit_1_N = mkN "bentonit" "bentoniter" ; -- bentonit..nn.1
  bentonitlager_1_N = mkN "bentonitlager" neutrum  ; -- bentonitlager..nn.1
  bentrakt_1_N = mkN "bentrakt" "bentrakter" ; -- bentrakt..nn.1
  bentuberkulos_1_N = mkN "bentuberkulos" ; -- bentuberkulos..nn.1
  bentyl_1_N = mkN "bentyl" ; -- bentyl..nn.1
  benutskott_1_N = mkN "benutskott" neutrum  ; -- benutskott..nn.1
  benved_1_N = mkN "benved" ; -- benved..nn.1
  benvit_1_A = mkA "benvit" ; -- benvit..av.1
  benvävnad_1_N = mkN "benvävnad" "benvävnader" ; -- benvävnad..nn.1
  benägen_1_A = mkA "benägen" ; -- benägen..av.1
  benägenhet_1_N = mkN "benägenhet" "benägenheter" ; -- benägenhet..nn.1
  benämna_1_V = mkV "benämner" ; -- benämna..vb.1
  benämnande_1_N = mkN "benämnande" ; -- benämnande..nn.1
  benämning_1_N = mkN "benämning" ; -- benämning..nn.1
  benåda_1_V = mkV "benådar" ; -- benåda..vb.1
  benådande_1_N = mkN "benådande" ; -- benådande..nn.1
  benådning_1_N = mkN "benådning" ; -- benådning..nn.1
  beordra_1_V = mkV "beordrar" ; -- beordra..vb.1
  beordrande_1_N = mkN "beordrande" ; -- beordrande..nn.1
  beostare_1_N = mkN "beostare" "beostarar" ; -- beostare..nn.1
  bepansra_1_V = mkV "bepansrar" ; -- bepansra..vb.1
  bepansrande_1_N = mkN "bepansrande" ; -- bepansrande..nn.1
  bepansring_1_N = mkN "bepansring" ; -- bepansring..nn.1
  beprisa_1_V = mkV "beprisar" ; -- beprisa..vb.1
  beprisande_1_N = mkN "beprisande" ; -- beprisande..nn.1
  beprisning_1_N = mkN "beprisning" ; -- beprisning..nn.1
  bepryda_1_V = mkV "bepryda" "beprydde" "beprytt" ; -- bepryda..vb.1
  beprydande_1_N = mkN "beprydande" ; -- beprydande..nn.1
  beprövad_1_A = mkA "beprövad" ; -- beprövad..av.1
  bepudra_1_V = mkV "bepudrar" ; -- bepudra..vb.1
  bepudrande_1_N = mkN "bepudrande" ; -- bepudrande..nn.1
  beramad_1_A = mkA "beramad" ; -- beramad..av.1
  berber_1_N = mkN "berber" "berbern" "berber" "berberna" ; -- berber..nn.1
  berberis_1_N = mkN "berberis" ; -- berberis..nn.1
  berceuse_1_N = mkN "berceuse" "berceuser" ; -- berceuse..nn.1
  bereda_1_V = mkV "bereda" "beredde" "berett" ; -- bereda..vb.1
  beredande_1_N = mkN "beredande" ; -- beredande..nn.1
  beredare_1_N = mkN "beredare" utrum  ; -- beredare..nn.1
  beredd_1_A = mkA "beredd" ; -- beredd..av.1
  beredelse_1_N = mkN "beredelse" "beredelser" ; -- beredelse..nn.1
  beredning_1_N = mkN "beredning" ; -- beredning..nn.1
  beredning_2_N = mkN "beredning" ; -- beredning..nn.2
  beredningsnämnd_1_N = mkN "beredningsnämnd" "beredningsnämnder" ; -- beredningsnämnd..nn.1
  beredningssätt_1_N = mkN "beredningssätt" neutrum  ; -- beredningssätt..nn.1
  beredningsutskott_1_N = mkN "beredningsutskott" neutrum  ; -- beredningsutskott..nn.1
  beredskap_1_N = mkN "beredskap" "beredskaper" ; -- beredskap..nn.1
  beredskapsarbete_1_N = mkN "beredskapsarbete" ; -- beredskapsarbete..nn.1
  beredskapskommissarie_1_N = mkN "beredskapskommissarie" "beredskapskommissarier" ; -- beredskapskommissarie..nn.1
  beredskapslager_1_N = mkN "beredskapslager" neutrum  ; -- beredskapslager..nn.1
  beredskapslagring_1_N = mkN "beredskapslagring" ; -- beredskapslagring..nn.1
  beredskapsmässig_1_A = mkA "beredskapsmässig" ; -- beredskapsmässig..av.1
  beredskapsplan_1_N = mkN "beredskapsplan" neutrum  ; -- beredskapsplan..nn.1
  beredskapsstat_1_N = mkN "beredskapsstat" "beredskapsstater" ; -- beredskapsstat..nn.1
  beredskapstid_1_N = mkN "beredskapstid" "beredskapstider" ; -- beredskapstid..nn.1
  beredskapstjänst_1_N = mkN "beredskapstjänst" "beredskapstjänster" ; -- beredskapstjänst..nn.1
  beredvillig_1_A = mkA "beredvillig" ; -- beredvillig..av.1
  beredvillighet_1_N = mkN "beredvillighet" "beredvilligheter" ; -- beredvillighet..nn.1
  berest_1_A = mkA "berest" "berest" ; -- berest..av.1
  beresthet_1_N = mkN "beresthet" ; -- beresthet..nn.1
  berg_och_dalbana_1_N = mkN "berg-och-dalbana" ; -- berg-och-dalbana..nn.1
  berg_1_N = mkN "berg" neutrum  ; -- berg..nn.1
  bergakung_1_N = mkN "bergakung" ; -- bergakung..nn.1
  bergamott_1_N = mkN "bergamott" "bergamotter" ; -- bergamott..nn.1
  bergand_1_N = mkN "bergand" "bergänder" ; -- bergand..nn.1
  bergart_1_N = mkN "bergart" "bergarter" ; -- bergart..nn.1
  bergartslager_1_N = mkN "bergartslager" neutrum  ; -- bergartslager..nn.1
  bergbana_1_N = mkN "bergbana" ; -- bergbana..nn.1
  bergbestigare_1_N = mkN "bergbestigare" utrum  ; -- bergbestigare..nn.1
  bergbestigning_1_N = mkN "bergbestigning" ; -- bergbestigning..nn.1
  bergborr_1_N = mkN "bergborr" ; -- bergborr..nn.1
  bergborrning_1_N = mkN "bergborrning" ; -- bergborrning..nn.1
  bergbäck_1_N = mkN "bergbäck" ; -- bergbäck..nn.1
  bergfast_1_A = mkA "bergfast" "bergfast" ; -- bergfast..av.1
  bergfin_1_A = mkA "bergfin" ; -- bergfin..av.1
  bergfink_1_N = mkN "bergfink" ; -- bergfink..nn.1
  berggrund_1_N = mkN "berggrund" "berggrunder" ; -- berggrund..nn.1
  berggylta_1_N = mkN "berggylta" ; -- berggylta..nn.1
  berghäll_1_N = mkN "berghäll" ; -- berghäll..nn.1
  bergig_1_A = mkA "bergig" ; -- bergig..av.1
  bergighet_1_N = mkN "bergighet" ; -- bergighet..nn.1
  bergis_1_A = mkA "bergis" ; -- bergis..av.1
  bergis_1_N = mkN "bergis" ; -- bergis..nn.1
  bergkam_1_N = mkN "bergkam" "bergkammen" "bergkammar" "bergkammarna" ; -- bergkam..nn.1
  bergklack_1_N = mkN "bergklack" ; -- bergklack..nn.1
  bergknalle_1_N = mkN "bergknalle" utrum  ; -- bergknalle..nn.1
  bergkristall_1_N = mkN "bergkristall" "bergkristaller" ; -- bergkristall..nn.1
  bergkrön_1_N = mkN "bergkrön" neutrum  ; -- bergkrön..nn.1
  bergkulle_1_N = mkN "bergkulle" utrum  ; -- bergkulle..nn.1
  bergland_1_N = mkN "bergland" neutrum  ; -- bergland..nn.1
  berglandskap_1_N = mkN "berglandskap" neutrum  ; -- berglandskap..nn.1
  bergnymf_1_N = mkN "bergnymf" "bergnymfer" ; -- bergnymf..nn.1
  bergolja_1_N = mkN "bergolja" ; -- bergolja..nn.1
  bergpass_1_N = mkN "bergpass" neutrum  ; -- bergpass..nn.1
  bergras_1_N = mkN "bergras" neutrum  ; -- bergras..nn.1
  bergrum_1_N = mkN "bergrum" "bergrummet" "bergrum" "bergrummen" ; -- bergrum..nn.1
  bergrygg_1_N = mkN "bergrygg" ; -- bergrygg..nn.1
  bergsartilleri_1_N = mkN "bergsartilleri" neutrum  ; -- bergsartilleri..nn.1
  bergsbestigare_1_N = mkN "bergsbestigare" utrum  ; -- bergsbestigare..nn.1
  bergsbestigning_1_N = mkN "bergsbestigning" ; -- bergsbestigning..nn.1
  bergsbestigningsexpedition_1_N = mkN "bergsbestigningsexpedition" ; -- bergsbestigningsexpedition..nn.1
  bergsbestigningsolycka_1_N = mkN "bergsbestigningsolycka" ; -- bergsbestigningsolycka..nn.1
  bergsbrant_1_N = mkN "bergsbrant" "bergsbranter" ; -- bergsbrant..nn.1
  bergsbruk_1_N = mkN "bergsbruk" neutrum  ; -- bergsbruk..nn.1
  bergsbygd_1_N = mkN "bergsbygd" "bergsbygder" ; -- bergsbygd..nn.1
  bergsdrift_1_N = mkN "bergsdrift" ; -- bergsdrift..nn.1
  bergsformation_1_N = mkN "bergsformation" ; -- bergsformation..nn.1
  bergsget_1_N = mkN "bergsget" "bergsgetter" ; -- bergsget..nn.1
  bergsglaciär_1_N = mkN "bergsglaciär" "bergsglaciärer" ; -- bergsglaciär..nn.1
  bergsgorilla_1_N = mkN "bergsgorilla" ; -- bergsgorilla..nn.1
  bergshantering_1_N = mkN "bergshantering" ; -- bergshantering..nn.1
  bergsingenjör_1_N = mkN "bergsingenjör" "bergsingenjörer" ; -- bergsingenjör..nn.1
  bergsjägare_1_N = mkN "bergsjägare" utrum  ; -- bergsjägare..nn.1
  bergskam_1_N = mkN "bergskam" "bergskammen" "bergskammar" "bergskammarna" ; -- bergskam..nn.1
  bergskedja_1_N = mkN "bergskedja" ; -- bergskedja..nn.1
  bergskedjebildning_1_N = mkN "bergskedjebildning" ; -- bergskedjebildning..nn.1
  bergsklack_1_N = mkN "bergsklack" ; -- bergsklack..nn.1
  bergsklimat_1_N = mkN "bergsklimat" neutrum  ; -- bergsklimat..nn.1
  bergsklyfta_1_N = mkN "bergsklyfta" ; -- bergsklyfta..nn.1
  bergsklättrare_1_N = mkN "bergsklättrare" utrum  ; -- bergsklättrare..nn.1
  bergsklättring_1_N = mkN "bergsklättring" ; -- bergsklättring..nn.1
  bergskred_1_N = mkN "bergskred" neutrum  ; -- bergskred..nn.1
  bergskreva_1_N = mkN "bergskreva" ; -- bergskreva..nn.1
  bergskrön_1_N = mkN "bergskrön" neutrum  ; -- bergskrön..nn.1
  bergslag_1_N = mkN "bergslag" "bergslager" ; -- bergslag..nn.1
  bergslager_1_N = mkN "bergslager" neutrum  ; -- bergslager..nn.1
  bergslandskap_1_N = mkN "bergslandskap" neutrum  ; -- bergslandskap..nn.1
  bergsluft_1_N = mkN "bergsluft" ; -- bergsluft..nn.1
  bergsman_1_N = mkN "bergsman" "bergsmannen" "bergsmän" "bergsmännen" ; -- bergsman..nn.1
  bergsmassiv_1_N = mkN "bergsmassiv" neutrum  ; -- bergsmassiv..nn.1
  bergsområde_1_N = mkN "bergsområde" ; -- bergsområde..nn.1
  bergspets_1_N = mkN "bergspets" ; -- bergspets..nn.1
  bergsplatå_1_N = mkN "bergsplatå" "bergsplatåer" ; -- bergsplatå..nn.1
  bergsrygg_1_N = mkN "bergsrygg" ; -- bergsrygg..nn.1
  bergssida_1_N = mkN "bergssida" ; -- bergssida..nn.1
  bergsskola_1_N = mkN "bergsskola" ; -- bergsskola..nn.1
  bergssluttning_1_N = mkN "bergssluttning" ; -- bergssluttning..nn.1
  bergsstam_1_N = mkN "bergsstam" "bergsstammen" "bergsstammar" "bergsstammarna" ; -- bergsstam..nn.1
  bergsstup_1_N = mkN "bergsstup" neutrum  ; -- bergsstup..nn.1
  bergstopp_1_N = mkN "bergstopp" ; -- bergstopp..nn.1
  bergstrakt_1_N = mkN "bergstrakt" "bergstrakter" ; -- bergstrakt..nn.1
  bergstup_1_N = mkN "bergstup" neutrum  ; -- bergstup..nn.1
  bergsyra_1_N = mkN "bergsyra" ; -- bergsyra..nn.1
  bergszebra_1_N = mkN "bergszebra" ; -- bergszebra..nn.1
  bergsäker_1_A = mkA "bergsäker" ; -- bergsäker..av.1
  bergsäkerhet_1_N = mkN "bergsäkerhet" ; -- bergsäkerhet..nn.1
  bergtagen_1_A = mkA "bergtagen" ; -- bergtagen..av.1
  bergtall_1_N = mkN "bergtall" ; -- bergtall..nn.1
  bergtopp_1_N = mkN "bergtopp" ; -- bergtopp..nn.1
  bergtroll_1_N = mkN "bergtroll" neutrum  ; -- bergtroll..nn.1
  berguv_1_N = mkN "berguv" ; -- berguv..nn.1
  bergvandrare_1_N = mkN "bergvandrare" utrum  ; -- bergvandrare..nn.1
  bergvandring_1_N = mkN "bergvandring" ; -- bergvandring..nn.1
  bergvind_1_N = mkN "bergvind" ; -- bergvind..nn.1
  bergvägg_1_N = mkN "bergvägg" ; -- bergvägg..nn.1
  bergvärme_1_N = mkN "bergvärme" ; -- bergvärme..nn.1
  bergås_1_N = mkN "bergås" ; -- bergås..nn.1
  beridare_1_N = mkN "beridare" utrum  ; -- beridare..nn.1
  beriden_1_A = mkA "beriden" ; -- beriden..av.1
  berika_1_V = mkV "berikar" ; -- berika..vb.1
  berikande_1_N = mkN "berikande" ; -- berikande..nn.1
  beriktiga_1_V = mkV "beriktigar" ; -- beriktiga..vb.1
  beriktigande_1_N = mkN "beriktigande" ; -- beriktigande..nn.1
  berkelium_1_N = mkN "berkelium" neutrum  ; -- berkelium..nn.1
  berkis_1_N = mkN "berkis" ; -- berkis..nn.1
  berlinerblå_1_A = mkA "berlinerblå" "berlinerblått" ; -- berlinerblå..av.1
  berlinerblått_1_N = mkN "berlinerblått" ; -- berlinerblått..nn.1
  berlock_1_N = mkN "berlock" "berlocker" ; -- berlock..nn.1
  bermudarigg_1_N = mkN "bermudarigg" ; -- bermudarigg..nn.1
  bernäs_1_N = mkN "bernäs" "bernäser" ; -- bernäs..nn.1
  bernässås_1_N = mkN "bernässås" "bernässåser" ; -- bernässås..nn.1
  bero_1_V = mkV "beror" ; -- bero..vb.1
  beroende_1_A = mkA "beroende" ; -- beroende..av.1
  beroende_1_N = mkN "beroende" ; -- beroende..nn.1
  beroende_2_N = mkN "beroende" ; -- beroende..nn.2
  beroendeframkallande_1_A = mkA "beroendeframkallande" ; -- beroendeframkallande..av.1
  beroendeförhållande_1_N = mkN "beroendeförhållande" ; -- beroendeförhållande..nn.1
  beroendeproblem_1_N = mkN "beroendeproblem" neutrum  ; -- beroendeproblem..nn.1
  beroendeställning_1_N = mkN "beroendeställning" ; -- beroendeställning..nn.1
  berså_1_N = mkN "berså" "bersåer" ; -- berså..nn.1
  bertel_1_N = mkN "bertel" ; -- bertel..nn.1
  berusa_1_V = mkV "berusar" ; -- berusa..vb.1
  berusad_1_A = mkA "berusad" ; -- berusad..av.1
  berusande_1_A = mkA "berusande" ; -- berusande..av.1
  berusande_1_N = mkN "berusande" ; -- berusande..nn.1
  berusning_1_N = mkN "berusning" ; -- berusning..nn.1
  berusningsgrad_1_N = mkN "berusningsgrad" "berusningsgrader" ; -- berusningsgrad..nn.1
  beryktad_1_A = mkA "beryktad" ; -- beryktad..av.1
  beryll_1_N = mkN "beryll" "beryller" ; -- beryll..nn.1
  beryllgrön_1_A = mkA "beryllgrön" ; -- beryllgrön..av.1
  beryllium_1_N = mkN "beryllium" neutrum  ; -- beryllium..nn.1
  beräkna_1_V = mkV "beräknar" ; -- beräkna..vb.1
  beräknad_1_A = mkA "beräknad" ; -- beräknad..av.1
  beräknande_1_A = mkA "beräknande" ; -- beräknande..av.1
  beräknande_1_N = mkN "beräknande" ; -- beräknande..nn.1
  beräknelig_1_A = mkA "beräknelig" ; -- beräknelig..av.1
  beräknelighet_1_N = mkN "beräknelighet" ; -- beräknelighet..nn.1
  beräkning_1_N = mkN "beräkning" ; -- beräkning..nn.1
  beräkningsgrund_1_N = mkN "beräkningsgrund" "beräkningsgrunder" ; -- beräkningsgrund..nn.1
  beräkningsmetod_1_N = mkN "beräkningsmetod" "beräkningsmetoder" ; -- beräkningsmetod..nn.1
  beräkningsmässig_1_A = mkA "beräkningsmässig" ; -- beräkningsmässig..av.1
  beräkningssätt_1_N = mkN "beräkningssätt" neutrum  ; -- beräkningssätt..nn.1
  berätta_1_V = mkV "berättar" ; -- berätta..vb.1
  berättande_1_A = mkA "berättande" ; -- berättande..av.1
  berättande_1_N = mkN "berättande" ; -- berättande..nn.1
  berättarbegåvning_1_N = mkN "berättarbegåvning" ; -- berättarbegåvning..nn.1
  berättare_1_N = mkN "berättare" utrum  ; -- berättare..nn.1
  berättarförmåga_1_N = mkN "berättarförmåga" ; -- berättarförmåga..nn.1
  berättarglädje_1_N = mkN "berättarglädje" utrum  ; -- berättarglädje..nn.1
  berättarjag_1_N = mkN "berättarjag" neutrum  ; -- berättarjag..nn.1
  berättarkonst_1_N = mkN "berättarkonst" "berättarkonster" ; -- berättarkonst..nn.1
  berättarmässig_1_A = mkA "berättarmässig" ; -- berättarmässig..av.1
  berättarperspektiv_1_N = mkN "berättarperspektiv" neutrum  ; -- berättarperspektiv..nn.1
  berättarröst_1_N = mkN "berättarröst" "berättarröster" ; -- berättarröst..nn.1
  berättarstil_1_N = mkN "berättarstil" ; -- berättarstil..nn.1
  berättartalang_1_N = mkN "berättartalang" "berättartalanger" ; -- berättartalang..nn.1
  berättarteknik_1_N = mkN "berättarteknik" "berättartekniker" ; -- berättarteknik..nn.1
  berättarteknisk_1_A = mkA "berättarteknisk" ; -- berättarteknisk..av.1
  berättelse_1_N = mkN "berättelse" "berättelser" ; -- berättelse..nn.1
  berättiga_1_V = mkV "berättigar" ; -- berättiga..vb.1
  berättigad_1_A = mkA "berättigad" ; -- berättigad..av.1
  berättigande_1_N = mkN "berättigande" ; -- berättigande..nn.1
  berömd_1_A = mkA "berömd" "berömt" ; -- berömd..av.1
  berömdhet_1_N = mkN "berömdhet" "berömdheter" ; -- berömdhet..nn.1
  berömlig_1_A = mkA "berömlig" ; -- berömlig..av.1
  berömlighet_1_N = mkN "berömlighet" "berömligheter" ; -- berömlighet..nn.1
  berömma_1_V = mkV "berömmer" ; -- berömma..vb.1
  berömmande_1_N = mkN "berömmande" ; -- berömmande..nn.1
  berömmelse_1_N = mkN "berömmelse" utrum  ; -- berömmelse..nn.1
  berömvärd_1_A = mkA "berömvärd" "berömvärt" ; -- berömvärd..av.1
  berömvärdhet_1_N = mkN "berömvärdhet" ; -- berömvärdhet..nn.1
  beröra_1_V = mkV "beröra" "berörde" "berört" ; -- beröra..vb.1
  berörande_1_N = mkN "berörande" ; -- berörande..nn.1
  berörd_1_A = mkA "berörd" "berört" ; -- berörd..av.1
  beröring_1_N = mkN "beröring" ; -- beröring..nn.1
  beröringsassociation_1_N = mkN "beröringsassociation" ; -- beröringsassociation..nn.1
  beröringselektricitet_1_N = mkN "beröringselektricitet" "beröringselektriciteter" ; -- beröringselektricitet..nn.1
  beröringsfri_1_A = mkA "beröringsfri" "beröringsfritt" ; -- beröringsfri..av.1
  beröringspunkt_1_N = mkN "beröringspunkt" "beröringspunkter" ; -- beröringspunkt..nn.1
  beröringsskräck_1_N = mkN "beröringsskräck" ; -- beröringsskräck..nn.1
  beröringsångest_1_N = mkN "beröringsångest" ; -- beröringsångest..nn.1
  beröva_1_V = mkV "berövar" ; -- beröva..vb.1
  berövande_1_N = mkN "berövande" ; -- berövande..nn.1
  besanna_1_V = mkV "besannar" ; -- besanna..vb.1
  besannande_1_N = mkN "besannande" ; -- besannande..nn.1
  besatt_1_A = mkA "besatt" ; -- besatt..av.1
  besatthet_1_N = mkN "besatthet" "besattheter" ; -- besatthet..nn.1
  bese_1_V = mkV "bese" "besåg" "besett" ; -- bese..vb.1
  beseende_1_N = mkN "beseende" ; -- beseende..nn.1
  besegla_1_V = mkV "beseglar" ; -- besegla..vb.1
  beseglande_1_N = mkN "beseglande" ; -- beseglande..nn.1
  besegling_1_N = mkN "besegling" ; -- besegling..nn.1
  besegra_1_V = mkV "besegrar" ; -- besegra..vb.1
  besegrande_1_N = mkN "besegrande" ; -- besegrande..nn.1
  besegrare_1_N = mkN "besegrare" utrum  ; -- besegrare..nn.1
  besick_1_N = mkN "besick" ; -- besick..nn.1
  besiffrad_1_A = mkA "besiffrad" ; -- besiffrad..av.1
  besiffring_1_N = mkN "besiffring" ; -- besiffring..nn.1
  besiktiga_1_V = mkV "besiktigar" ; -- besiktiga..vb.1
  besiktigande_1_N = mkN "besiktigande" ; -- besiktigande..nn.1
  besiktning_1_N = mkN "besiktning" ; -- besiktning..nn.1
  besiktningsinstrument_1_N = mkN "besiktningsinstrument" neutrum  ; -- besiktningsinstrument..nn.1
  besiktningsman_1_N = mkN "besiktningsman" "besiktningsmannen" "besiktningsmän" "besiktningsmännen" ; -- besiktningsman..nn.1
  besiktningsprotokoll_1_N = mkN "besiktningsprotokoll" neutrum  ; -- besiktningsprotokoll..nn.1
  besinna_1_V = mkV "besinnar" ; -- besinna..vb.1
  besinnad_1_A = mkA "besinnad" ; -- besinnad..av.1
  besinnande_1_N = mkN "besinnande" ; -- besinnande..nn.1
  besinning_1_N = mkN "besinning" ; -- besinning..nn.1
  besinningsfull_1_A = mkA "besinningsfull" ; -- besinningsfull..av.1
  besinningsfullhet_1_N = mkN "besinningsfullhet" ; -- besinningsfullhet..nn.1
  besinningslös_1_A = mkA "besinningslös" ; -- besinningslös..av.1
  besinningslöshet_1_N = mkN "besinningslöshet" "besinningslösheter" ; -- besinningslöshet..nn.1
  besique_1_N = mkN "besique" utrum  ; -- besique..nn.1
  besitta_1_V = mkV "besitta" "besatt" "besuttit" ; -- besitta..vb.1
  besittande_1_N = mkN "besittande" ; -- besittande..nn.1
  besittning_1_N = mkN "besittning" ; -- besittning..nn.1
  besittningshavare_1_N = mkN "besittningshavare" utrum  ; -- besittningshavare..nn.1
  besittningsrätt_1_N = mkN "besittningsrätt" "besittningsrätter" ; -- besittningsrätt..nn.1
  besittningsskydd_1_N = mkN "besittningsskydd" neutrum  ; -- besittningsskydd..nn.1
  besittningstagande_1_N = mkN "besittningstagande" ; -- besittningstagande..nn.1
  besittningstid_1_N = mkN "besittningstid" "besittningstider" ; -- besittningstid..nn.1
  besjunga_1_V = mkV "besjunga" "besjöng" "besjungit" ; -- besjunga..vb.1
  besjungande_1_N = mkN "besjungande" ; -- besjungande..nn.1
  besjungen_1_A = mkA "besjungen" ; -- besjungen..av.1
  besjäla_1_V = mkV "besjälar" ; -- besjäla..vb.1
  besjälad_1_A = mkA "besjälad" ; -- besjälad..av.1
  besjälande_1_N = mkN "besjälande" ; -- besjälande..nn.1
  besk_1_A = mkA "besk" ; -- besk..av.1
  besk_1_N = mkN "besk" ; -- besk..nn.1
  beska_1_N = mkN "beska" ; -- beska..nn.1
  beskaffad_1_A = mkA "beskaffad" ; -- beskaffad..av.1
  beskaffenhet_1_N = mkN "beskaffenhet" "beskaffenheter" ; -- beskaffenhet..nn.1
  beskatta_1_V = mkV "beskattar" ; -- beskatta..vb.1
  beskattande_1_N = mkN "beskattande" ; -- beskattande..nn.1
  beskattning_1_N = mkN "beskattning" ; -- beskattning..nn.1
  beskattningsbar_1_A = mkA "beskattningsbar" ; -- beskattningsbar..av.1
  beskattningsbarhet_1_N = mkN "beskattningsbarhet" ; -- beskattningsbarhet..nn.1
  beskattningsgrund_1_N = mkN "beskattningsgrund" "beskattningsgrunder" ; -- beskattningsgrund..nn.1
  beskattningsgrundande_1_A = mkA "beskattningsgrundande" ; -- beskattningsgrundande..av.1
  beskattningsmakt_1_N = mkN "beskattningsmakt" ; -- beskattningsmakt..nn.1
  beskattningsnämnd_1_N = mkN "beskattningsnämnd" "beskattningsnämnder" ; -- beskattningsnämnd..nn.1
  beskattningsprincip_1_N = mkN "beskattningsprincip" "beskattningsprinciper" ; -- beskattningsprincip..nn.1
  beskattningsrätt_1_N = mkN "beskattningsrätt" ; -- beskattningsrätt..nn.1
  beskattningssätt_1_N = mkN "beskattningssätt" neutrum  ; -- beskattningssätt..nn.1
  beskattningsår_1_N = mkN "beskattningsår" neutrum  ; -- beskattningsår..nn.1
  besked_1_N = mkN "besked" neutrum  ; -- besked..nn.1
  beskedlig_1_A = mkA "beskedlig" ; -- beskedlig..av.1
  beskedlighet_1_N = mkN "beskedlighet" ; -- beskedlighet..nn.1
  beskhet_1_N = mkN "beskhet" "beskheter" ; -- beskhet..nn.1
  beskicka_1_V = mkV "beskickar" ; -- beskicka..vb.1
  beskickande_1_N = mkN "beskickande" ; -- beskickande..nn.1
  beskickning_1_N = mkN "beskickning" ; -- beskickning..nn.1
  beskickningschef_1_N = mkN "beskickningschef" "beskickningschefer" ; -- beskickningschef..nn.1
  beskjuta_1_V = mkV "beskjuta" "besköt" "beskjutit" ; -- beskjuta..vb.1
  beskjutande_1_N = mkN "beskjutande" ; -- beskjutande..nn.1
  beskjutning_1_N = mkN "beskjutning" ; -- beskjutning..nn.1
  beskriva_1_V = mkV "beskriva" "beskrev" "beskrivit" ; -- beskriva..vb.1
  beskrivande_1_A = mkA "beskrivande" ; -- beskrivande..av.1
  beskrivande_1_N = mkN "beskrivande" ; -- beskrivande..nn.1
  beskrivbar_1_A = mkA "beskrivbar" ; -- beskrivbar..av.1
  beskrivbarhet_1_N = mkN "beskrivbarhet" ; -- beskrivbarhet..nn.1
  beskrivning_1_N = mkN "beskrivning" ; -- beskrivning..nn.1
  besksöta_1_N = mkN "besksöta" ; -- besksöta..nn.1
  beskugga_1_V = mkV "beskuggar" ; -- beskugga..vb.1
  beskuggande_1_N = mkN "beskuggande" ; -- beskuggande..nn.1
  beskuggning_1_N = mkN "beskuggning" ; -- beskuggning..nn.1
  beskydd_1_N = mkN "beskydd" neutrum  ; -- beskydd..nn.1
  beskydda_1_V = mkV "beskyddar" ; -- beskydda..vb.1
  beskyddande_1_N = mkN "beskyddande" ; -- beskyddande..nn.1
  beskyddare_1_N = mkN "beskyddare" utrum  ; -- beskyddare..nn.1
  beskyddarverksamhet_1_N = mkN "beskyddarverksamhet" "beskyddarverksamheter" ; -- beskyddarverksamhet..nn.1
  beskylla_1_V = mkV "beskyller" ; -- beskylla..vb.1
  beskyllande_1_N = mkN "beskyllande" ; -- beskyllande..nn.1
  beskyllning_1_N = mkN "beskyllning" ; -- beskyllning..nn.1
  beskäftig_1_A = mkA "beskäftig" ; -- beskäftig..av.1
  beskäftighet_1_N = mkN "beskäftighet" "beskäftigheter" ; -- beskäftighet..nn.1
  beskällare_1_N = mkN "beskällare" utrum  ; -- beskällare..nn.1
  beskällaresjuka_1_N = mkN "beskällaresjuka" ; -- beskällaresjuka..nn.1
  beskällarsjuka_1_N = mkN "beskällarsjuka" ; -- beskällarsjuka..nn.1
  beskänkt_1_A = mkA "beskänkt" "beskänkt" ; -- beskänkt..av.1
  beskära_1_V = mkV "beskära" "beskärde" "beskärt" ; -- beskära..vb.1
  beskära_2_V = mkV "beskära" "beskar" "beskurit" ; -- beskära..vb.2
  beskärande_1_N = mkN "beskärande" ; -- beskärande..nn.1
  beskärd_1_A = mkA "beskärd" "beskärt" ; -- beskärd..av.1
  beskärm_1_N = mkN "beskärm" neutrum  ; -- beskärm..nn.1
  beskärma_1_V = mkV "beskärmar" ; -- beskärma..vb.1
  beskärmande_1_N = mkN "beskärmande" ; -- beskärmande..nn.1
  beskärmare_1_N = mkN "beskärmare" utrum  ; -- beskärmare..nn.1
  beskärmelse_1_N = mkN "beskärmelse" "beskärmelser" ; -- beskärmelse..nn.1
  beskärning_1_N = mkN "beskärning" ; -- beskärning..nn.1
  beskåda_1_V = mkV "beskådar" ; -- beskåda..vb.1
  beskådande_1_N = mkN "beskådande" ; -- beskådande..nn.1
  beskådning_1_N = mkN "beskådning" ; -- beskådning..nn.1
  beslag_1_N = mkN "beslag" neutrum  ; -- beslag..nn.1
  beslagare_1_N = mkN "beslagare" utrum  ; -- beslagare..nn.1
  beslaglägga_1_V = mkV "beslaglägga" "beslagla" "beslaglagt" ; -- beslaglägga..vb.1
  beslagläggande_1_N = mkN "beslagläggande" ; -- beslagläggande..nn.1
  beslagsband_1_N = mkN "beslagsband" neutrum  ; -- beslagsband..nn.1
  beslagsrätt_1_N = mkN "beslagsrätt" ; -- beslagsrätt..nn.1
  beslagssmed_1_N = mkN "beslagssmed" "beslagssmeder" ; -- beslagssmed..nn.1
  beslagssmide_1_N = mkN "beslagssmide" ; -- beslagssmide..nn.1
  beslagta_1_V = mkV "beslagtaga" "beslagtog" "beslagtagit" ; -- beslagta..vb.1
  beslagtagande_1_N = mkN "beslagtagande" ; -- beslagtagande..nn.1
  beslut_1_N = mkN "beslut" neutrum  ; -- beslut..nn.1
  besluta_1_V = mkV "beslutar" ; -- besluta..vb.1
  beslutande_1_N = mkN "beslutande" ; -- beslutande..nn.1
  beslutanderätt_1_N = mkN "beslutanderätt" ; -- beslutanderätt..nn.1
  besluten_1_A = mkA "besluten" ; -- besluten..av.1
  beslutenhet_1_N = mkN "beslutenhet" ; -- beslutenhet..nn.1
  beslutenlig_1_A = mkA "beslutenlig" ; -- beslutenlig..av.1
  beslutenlighet_1_N = mkN "beslutenlighet" ; -- beslutenlighet..nn.1
  beslutfattande_1_A = mkA "beslutfattande" ; -- beslutfattande..av.1
  beslutfattande_1_N = mkN "beslutfattande" ; -- beslutfattande..nn.1
  beslutfattare_1_N = mkN "beslutfattare" utrum  ; -- beslutfattare..nn.1
  beslutför_1_A = mkA "beslutför" ; -- beslutför..av.1
  beslutförhet_1_N = mkN "beslutförhet" ; -- beslutförhet..nn.1
  beslutmässig_1_A = mkA "beslutmässig" ; -- beslutmässig..av.1
  beslutmässighet_1_N = mkN "beslutmässighet" ; -- beslutmässighet..nn.1
  beslutnivå_1_N = mkN "beslutnivå" "beslutnivåer" ; -- beslutnivå..nn.1
  beslutsam_1_A = mkA "beslutsam" "beslutsamt" "beslutsamma" "beslutsamma" "beslutsammare" "beslutsammast" "beslutsammaste" ; -- beslutsam..av.1
  beslutsamhet_1_N = mkN "beslutsamhet" "beslutsamheter" ; -- beslutsamhet..nn.1
  beslutsenlig_1_A = mkA "beslutsenlig" ; -- beslutsenlig..av.1
  beslutsenlighet_1_N = mkN "beslutsenlighet" ; -- beslutsenlighet..nn.1
  beslutsfattande_1_A = mkA "beslutsfattande" ; -- beslutsfattande..av.1
  beslutsfattande_1_N = mkN "beslutsfattande" ; -- beslutsfattande..nn.1
  beslutsfattare_1_N = mkN "beslutsfattare" utrum  ; -- beslutsfattare..nn.1
  beslutsför_1_A = mkA "beslutsför" ; -- beslutsför..av.1
  beslutsförhet_1_N = mkN "beslutsförhet" ; -- beslutsförhet..nn.1
  beslutsförmåga_1_N = mkN "beslutsförmåga" ; -- beslutsförmåga..nn.1
  beslutshierarki_1_N = mkN "beslutshierarki" "beslutshierarkier" ; -- beslutshierarki..nn.1
  beslutskaos_1_N = mkN "beslutskaos" neutrum  ; -- beslutskaos..nn.1
  beslutskapabel_1_A = mkA "beslutskapabel" ; -- beslutskapabel..av.1
  beslutskorridor_1_N = mkN "beslutskorridor" "beslutskorridoren" "beslutskorridorer" "beslutskorridorerna" ; -- beslutskorridor..nn.1
  beslutsmässig_1_A = mkA "beslutsmässig" ; -- beslutsmässig..av.1
  beslutsmässighet_1_N = mkN "beslutsmässighet" ; -- beslutsmässighet..nn.1
  beslutsnivå_1_N = mkN "beslutsnivå" "beslutsnivåer" ; -- beslutsnivå..nn.1
  beslutsprocess_1_N = mkN "beslutsprocess" "beslutsprocesser" ; -- beslutsprocess..nn.1
  beslutsrum_1_N = mkN "beslutsrum" "beslutsrummet" "beslutsrum" "beslutsrummen" ; -- beslutsrum..nn.1
  beslutsrymd_1_N = mkN "beslutsrymd" "beslutsrymder" ; -- beslutsrymd..nn.1
  beslutsrätt_1_N = mkN "beslutsrätt" ; -- beslutsrätt..nn.1
  beslutsunderlag_1_N = mkN "beslutsunderlag" neutrum  ; -- beslutsunderlag..nn.1
  beslutsångest_1_N = mkN "beslutsångest" ; -- beslutsångest..nn.1
  besläktad_1_A = mkA "besläktad" ; -- besläktad..av.1
  beslå_1_V = mkV "beslå" "beslog" "beslagit" ; -- beslå..vb.1
  beslående_1_N = mkN "beslående" ; -- beslående..nn.1
  beslöja_1_V = mkV "beslöjar" ; -- beslöja..vb.1
  beslöjad_1_A = mkA "beslöjad" ; -- beslöjad..av.1
  beslöjande_1_N = mkN "beslöjande" ; -- beslöjande..nn.1
  beslöjning_1_N = mkN "beslöjning" ; -- beslöjning..nn.1
  besman_1_N = mkN "besman" neutrum  ; -- besman..nn.1
  besmanskrok_1_N = mkN "besmanskrok" ; -- besmanskrok..nn.1
  besmitta_1_V = mkV "besmittar" ; -- besmitta..vb.1
  besmittande_1_N = mkN "besmittande" ; -- besmittande..nn.1
  besmittelse_1_N = mkN "besmittelse" "besmittelser" ; -- besmittelse..nn.1
  besmörja_1_V = mkV "besmörja" "besmorde" "besmort" ; -- besmörja..vb.1
  besmörjande_1_N = mkN "besmörjande" ; -- besmörjande..nn.1
  besockra_1_V = mkV "besockrar" ; -- besockra..vb.1
  besockrande_1_N = mkN "besockrande" ; -- besockrande..nn.1
  besolda_1_V = mkV "besoldar" ; -- besolda..vb.1
  besoldande_1_N = mkN "besoldande" ; -- besoldande..nn.1
  besoldning_1_N = mkN "besoldning" ; -- besoldning..nn.1
  bespara_1_V = mkV "bespara" "besparade" "besparat" ; -- bespara..vb.1
  besparande_1_N = mkN "besparande" ; -- besparande..nn.1
  besparing_1_N = mkN "besparing" ; -- besparing..nn.1
  besparingskrav_1_N = mkN "besparingskrav" neutrum  ; -- besparingskrav..nn.1
  besparingsskog_1_N = mkN "besparingsskog" ; -- besparingsskog..nn.1
  besparingstorped_1_N = mkN "besparingstorped" "besparingstorpeder" ; -- besparingstorped..nn.1
  bespeja_1_V = mkV "bespejar" ; -- bespeja..vb.1
  bespejande_1_N = mkN "bespejande" ; -- bespejande..nn.1
  bespejning_1_N = mkN "bespejning" ; -- bespejning..nn.1
  bespisa_1_V = mkV "bespisar" ; -- bespisa..vb.1
  bespisande_1_N = mkN "bespisande" ; -- bespisande..nn.1
  bespisning_1_N = mkN "bespisning" ; -- bespisning..nn.1
  bespola_1_V = mkV "bespolar" ; -- bespola..vb.1
  bespolande_1_N = mkN "bespolande" ; -- bespolande..nn.1
  bespotta_1_V = mkV "bespottar" ; -- bespotta..vb.1
  bespottande_1_N = mkN "bespottande" ; -- bespottande..nn.1
  bespottare_1_N = mkN "bespottare" utrum  ; -- bespottare..nn.1
  bespottelse_1_N = mkN "bespottelse" "bespottelser" ; -- bespottelse..nn.1
  bespruta_1_V = mkV "besprutar" ; -- bespruta..vb.1
  besprutande_1_N = mkN "besprutande" ; -- besprutande..nn.1
  besprutning_1_N = mkN "besprutning" ; -- besprutning..nn.1
  besprutningsmedel_1_N = mkN "besprutningsmedel" neutrum  ; -- besprutningsmedel..nn.1
  besprutningsvätska_1_N = mkN "besprutningsvätska" ; -- besprutningsvätska..nn.1
  bessemerblåsning_1_N = mkN "bessemerblåsning" ; -- bessemerblåsning..nn.1
  bessemerstål_1_N = mkN "bessemerstål" neutrum  ; -- bessemerstål..nn.1
  bessemerugn_1_N = mkN "bessemerugn" ; -- bessemerugn..nn.1
  besservisser_1_N = mkN "besservisser" ; -- besservisser..nn.1
  besserwisser_1_N = mkN "besserwisser" ; -- besserwisser..nn.1
  besserwisserattityd_1_N = mkN "besserwisserattityd" "besserwisserattityder" ; -- besserwisserattityd..nn.1
  besserwissra_1_V = mkV "besserwissrar" ; -- besserwissra..vb.1
  besserwissrande_1_N = mkN "besserwissrande" ; -- besserwissrande..nn.1
  best_1_N = mkN "best" ; -- best..nn.1
  bestialisk_1_A = mkA "bestialisk" ; -- bestialisk..av.1
  bestialitet_1_N = mkN "bestialitet" "bestialiteter" ; -- bestialitet..nn.1
  bestick_1_N = mkN "bestick" neutrum  ; -- bestick..nn.1
  besticka_1_V = mkV "besticka" "bestack" "bestuckit" ; -- besticka..vb.1
  bestickande_1_A = mkA "bestickande" ; -- bestickande..av.1
  bestickande_1_N = mkN "bestickande" ; -- bestickande..nn.1
  bestickföring_1_N = mkN "bestickföring" ; -- bestickföring..nn.1
  besticklig_1_A = mkA "besticklig" ; -- besticklig..av.1
  besticklighet_1_N = mkN "besticklighet" ; -- besticklighet..nn.1
  bestickning_1_N = mkN "bestickning" ; -- bestickning..nn.1
  bestiga_1_V = mkV "bestiga" "besteg" "bestigit" ; -- bestiga..vb.1
  bestigande_1_N = mkN "bestigande" ; -- bestigande..nn.1
  bestigning_1_N = mkN "bestigning" ; -- bestigning..nn.1
  bestjäla_1_V = mkV "bestjäla" "bestjäl" "bestjäl" "bestal" "bestulit" "bestulen" ; -- bestjäla..vb.1
  bestjälande_1_N = mkN "bestjälande" ; -- bestjälande..nn.1
  bestorma_1_V = mkV "bestormar" ; -- bestorma..vb.1
  bestormande_1_N = mkN "bestormande" ; -- bestormande..nn.1
  bestormning_1_N = mkN "bestormning" ; -- bestormning..nn.1
  bestraffa_1_V = mkV "bestraffar" ; -- bestraffa..vb.1
  bestraffande_1_N = mkN "bestraffande" ; -- bestraffande..nn.1
  bestraffning_1_N = mkN "bestraffning" ; -- bestraffning..nn.1
  bestraffningskrig_1_N = mkN "bestraffningskrig" neutrum  ; -- bestraffningskrig..nn.1
  bestraffningsmedel_1_N = mkN "bestraffningsmedel" neutrum  ; -- bestraffningsmedel..nn.1
  bestraffningssätt_1_N = mkN "bestraffningssätt" neutrum  ; -- bestraffningssätt..nn.1
  bestrida_1_V = mkV "bestrida" "bestridde" "bestridit" ; -- bestrida..vb.1
  bestridande_1_N = mkN "bestridande" ; -- bestridande..nn.1
  bestryka_1_V = mkV "bestryka" "beströk" "bestrukit" ; -- bestryka..vb.1
  bestrykande_1_N = mkN "bestrykande" ; -- bestrykande..nn.1
  bestrykning_1_N = mkN "bestrykning" ; -- bestrykning..nn.1
  bestråla_1_V = mkV "bestrålar" ; -- bestråla..vb.1
  bestrålande_1_N = mkN "bestrålande" ; -- bestrålande..nn.1
  bestrålning_1_N = mkN "bestrålning" ; -- bestrålning..nn.1
  beströ_1_V = mkV "beströr" ; -- beströ..vb.1
  beströende_1_N = mkN "beströende" ; -- beströende..nn.1
  bestseller_1_N = mkN "bestseller" ; -- bestseller..nn.1
  bestsellerförfattare_1_N = mkN "bestsellerförfattare" utrum  ; -- bestsellerförfattare..nn.1
  bestycka_1_V = mkV "bestyckar" ; -- bestycka..vb.1
  bestyckande_1_N = mkN "bestyckande" ; -- bestyckande..nn.1
  bestyckning_1_N = mkN "bestyckning" ; -- bestyckning..nn.1
  bestyr_1_N = mkN "bestyr" neutrum  ; -- bestyr..nn.1
  bestyra_1_V = mkV "bestyra" "bestyrde" "bestyrt" ; -- bestyra..vb.1
  bestyrande_1_N = mkN "bestyrande" ; -- bestyrande..nn.1
  bestyrka_1_V = mkV "bestyrker" ; -- bestyrka..vb.1
  bestyrkande_1_N = mkN "bestyrkande" ; -- bestyrkande..nn.1
  beställa_1_V = mkV "beställer" ; -- beställa..vb.1
  beställa_2_V = mkV "beställer" ; -- beställa..vb.2
  beställande_1_N = mkN "beställande" ; -- beställande..nn.1
  beställare_1_N = mkN "beställare" utrum  ; -- beställare..nn.1
  beställning_1_N = mkN "beställning" ; -- beställning..nn.1
  beställningsarbete_1_N = mkN "beställningsarbete" ; -- beställningsarbete..nn.1
  beställningsavgift_1_N = mkN "beställningsavgift" "beställningsavgifter" ; -- beställningsavgift..nn.1
  beställningsmord_1_N = mkN "beställningsmord" neutrum  ; -- beställningsmord..nn.1
  beställningsverk_1_N = mkN "beställningsverk" neutrum  ; -- beställningsverk..nn.1
  beställsam_1_A = mkA "beställsam" "beställsamt" "beställsamma" "beställsamma" "beställsammare" "beställsammast" "beställsammaste" ; -- beställsam..av.1
  beställsamhet_1_N = mkN "beställsamhet" ; -- beställsamhet..nn.1
  beställt_1_A = mkA "beställt" ; -- beställt..av.1
  bestämbar_1_A = mkA "bestämbar" ; -- bestämbar..av.1
  bestämbarhet_1_N = mkN "bestämbarhet" ; -- bestämbarhet..nn.1
  bestämd_1_A = mkA "bestämd" "bestämt" ; -- bestämd..av.1
  bestämdhet_1_N = mkN "bestämdhet" ; -- bestämdhet..nn.1
  bestämma_1_V = mkV "bestämmer" ; -- bestämma..vb.1
  bestämmande_1_N = mkN "bestämmande" ; -- bestämmande..nn.1
  bestämmanderätt_1_N = mkN "bestämmanderätt" ; -- bestämmanderätt..nn.1
  bestämmelse_1_N = mkN "bestämmelse" "bestämmelser" ; -- bestämmelse..nn.1
  bestämmelseort_1_N = mkN "bestämmelseort" "bestämmelseorter" ; -- bestämmelseort..nn.1
  bestämning_1_N = mkN "bestämning" ; -- bestämning..nn.1
  bestämningsord_1_N = mkN "bestämningsord" neutrum  ; -- bestämningsord..nn.1
  beständig_1_A = mkA "beständig" ; -- beständig..av.1
  beständighet_1_N = mkN "beständighet" "beständigheter" ; -- beständighet..nn.1
  bestänka_1_V = mkV "bestänker" ; -- bestänka..vb.1
  bestänkande_1_N = mkN "bestänkande" ; -- bestänkande..nn.1
  bestänkning_1_N = mkN "bestänkning" ; -- bestänkning..nn.1
  bestå_1_V = mkV "bestå" "bestod" "bestått" ; -- bestå..vb.1
  bestå_2_V = mkV "bestå" "bestod" "bestådd" ; -- bestå..vb.2
  bestående_1_A = mkA "bestående" ; -- bestående..av.1
  bestående_1_N = mkN "bestående" ; -- bestående..nn.1
  bestånd_1_N = mkN "bestånd" neutrum  ; -- bestånd..nn.1
  beståndande_1_A = mkA "beståndande" ; -- beståndande..av.1
  beståndsbildande_1_A = mkA "beståndsbildande" ; -- beståndsbildande..av.1
  beståndsdel_1_N = mkN "beståndsdel" "beståndsdelen" "beståndsdelar" "beståndsdelarna" ; -- beståndsdel..nn.1
  beståndsmässig_1_A = mkA "beståndsmässig" ; -- beståndsmässig..av.1
  bestört_1_A = mkA "bestört" "bestört" ; -- bestört..av.1
  bestörthet_1_N = mkN "bestörthet" ; -- bestörthet..nn.1
  bestörtning_1_N = mkN "bestörtning" ; -- bestörtning..nn.1
  besudla_1_V = mkV "besudlar" ; -- besudla..vb.1
  besudlande_1_N = mkN "besudlande" ; -- besudlande..nn.1
  besudling_1_N = mkN "besudling" ; -- besudling..nn.1
  besutten_1_A = mkA "besutten" ; -- besutten..av.1
  besuttenhet_1_N = mkN "besuttenhet" ; -- besuttenhet..nn.1
  besvara_1_V = mkV "besvarar" ; -- besvara..vb.1
  besvarande_1_N = mkN "besvarande" ; -- besvarande..nn.1
  besvikelse_1_N = mkN "besvikelse" "besvikelser" ; -- besvikelse..nn.1
  besviken_1_A = mkA "besviken" ; -- besviken..av.1
  besvikenhet_1_N = mkN "besvikenhet" ; -- besvikenhet..nn.1
  besvär_1_N = mkN "besvär" neutrum  ; -- besvär..nn.1
  besvära_1_V = mkV "besvärar" ; -- besvära..vb.1
  besvärad_1_A = mkA "besvärad" ; -- besvärad..av.1
  besvärande_1_A = mkA "besvärande" ; -- besvärande..av.1
  besvärande_1_N = mkN "besvärande" ; -- besvärande..nn.1
  besvärja_1_V = mkV "besvära" "besvär" "besvärj" "besvärjde" "besvärjt" "besvuren" ; -- besvärja..vb.1
  besvärjande_1_N = mkN "besvärjande" ; -- besvärjande..nn.1
  besvärjare_1_N = mkN "besvärjare" utrum  ; -- besvärjare..nn.1
  besvärjelse_1_N = mkN "besvärjelse" "besvärjelser" ; -- besvärjelse..nn.1
  besvärjelseformel_1_N = mkN "besvärjelseformel" "besvärjelseformeln" "besvärjelseformler" "besvärjelseformlerna" ; -- besvärjelseformel..nn.1
  besvärjning_1_N = mkN "besvärjning" ; -- besvärjning..nn.1
  besvärlig_1_A = mkA "besvärlig" ; -- besvärlig..av.1
  besvärlighet_1_N = mkN "besvärlighet" "besvärligheter" ; -- besvärlighet..nn.1
  besvärsfri_1_A = mkA "besvärsfri" "besvärsfritt" ; -- besvärsfri..av.1
  besvärsgrund_1_N = mkN "besvärsgrund" "besvärsgrunder" ; -- besvärsgrund..nn.1
  besvärshandling_1_N = mkN "besvärshandling" ; -- besvärshandling..nn.1
  besvärshänvisning_1_N = mkN "besvärshänvisning" ; -- besvärshänvisning..nn.1
  besvärsinlaga_1_N = mkN "besvärsinlaga" ; -- besvärsinlaga..nn.1
  besvärsinstans_1_N = mkN "besvärsinstans" "besvärsinstanser" ; -- besvärsinstans..nn.1
  besvärsmyndighet_1_N = mkN "besvärsmyndighet" "besvärsmyndigheter" ; -- besvärsmyndighet..nn.1
  besvärsmål_1_N = mkN "besvärsmål" neutrum  ; -- besvärsmål..nn.1
  besvärsrätt_1_N = mkN "besvärsrätt" ; -- besvärsrätt..nn.1
  besvärsskrift_1_N = mkN "besvärsskrift" "besvärsskrifter" ; -- besvärsskrift..nn.1
  besvärssubjekt_1_N = mkN "besvärssubjekt" neutrum  ; -- besvärssubjekt..nn.1
  besvärstid_1_N = mkN "besvärstid" "besvärstider" ; -- besvärstid..nn.1
  besvärsväg_1_N = mkN "besvärsväg" ; -- besvärsväg..nn.1
  besvågrad_1_A = mkA "besvågrad" ; -- besvågrad..av.1
  besynnerlig_1_A = mkA "besynnerlig" ; -- besynnerlig..av.1
  besynnerlighet_1_N = mkN "besynnerlighet" "besynnerligheter" ; -- besynnerlighet..nn.1
  besätta_1_V = mkV "besätta" "besätter" "besätt" "besatte" "besatt" "besatt" ; -- besätta..vb.1
  besättande_1_N = mkN "besättande" ; -- besättande..nn.1
  besättning_1_N = mkN "besättning" ; -- besättning..nn.1
  besättningsband_1_N = mkN "besättningsband" neutrum  ; -- besättningsband..nn.1
  besättningsman_1_N = mkN "besättningsman" "besättningsmannen" "besättningsmän" "besättningsmännen" ; -- besättningsman..nn.1
  besättningsmedlem_1_N = mkN "besättningsmedlem" "besättningsmedlemmen" "besättningsmedlemmar" "besättningsmedlemmarna" ; -- besättningsmedlem..nn.1
  beså_1_V = mkV "besår" ; -- beså..vb.1
  besående_1_N = mkN "besående" ; -- besående..nn.1
  besök_1_N = mkN "besök" neutrum  ; -- besök..nn.1
  besöka_1_V = mkV "besöker" ; -- besöka..vb.1
  besökande_1_N = mkN "besökande" "besökanden" "besökanden" "besökandena" ; -- besökande..nn.1
  besökande_2_N = mkN "besökande" ; -- besökande..nn.2
  besökare_1_N = mkN "besökare" utrum  ; -- besökare..nn.1
  besöksadress_1_N = mkN "besöksadress" "besöksadresser" ; -- besöksadress..nn.1
  besöksbok_1_N = mkN "besöksbok" "besöksböcker" ; -- besöksbok..nn.1
  besöksdag_1_N = mkN "besöksdag" ; -- besöksdag..nn.1
  besöksfåtölj_1_N = mkN "besöksfåtölj" "besöksfåtöljer" ; -- besöksfåtölj..nn.1
  besöksförbud_1_N = mkN "besöksförbud" neutrum  ; -- besöksförbud..nn.1
  besöksnäring_1_N = mkN "besöksnäring" ; -- besöksnäring..nn.1
  besöksrekord_1_N = mkN "besöksrekord" neutrum  ; -- besöksrekord..nn.1
  besöksrestriktion_1_N = mkN "besöksrestriktion" ; -- besöksrestriktion..nn.1
  besöksrum_1_N = mkN "besöksrum" "besöksrummet" "besöksrum" "besöksrummen" ; -- besöksrum..nn.1
  besöksstol_1_N = mkN "besöksstol" ; -- besöksstol..nn.1
  besökstid_1_N = mkN "besökstid" "besökstider" ; -- besökstid..nn.1
  besökstopp_1_N = mkN "besökstopp" neutrum  ; -- besökstopp..nn.1
  besörja_1_V = mkV "besörja" "besörjde" "besörjt" ; -- besörja..vb.1
  besörjande_1_N = mkN "besörjande" ; -- besörjande..nn.1
  bet_1_N = mkN "bet" ; -- bet..nn.1
  beta_1_N = mkN "beta" ; -- beta..nn.1
  beta_2_N = mkN "beta" "betat" "betan" "betana" ; -- beta..nn.2
  beta_1_V = mkV "betar" ; -- beta..vb.1
  beta_2_V = mkV "betaga" "betog" "betagit" ; -- beta..vb.2
  betablockerare_1_N = mkN "betablockerare" utrum  ; -- betablockerare..nn.1
  betagande_1_A = mkA "betagande" ; -- betagande..av.1
  betagande_1_N = mkN "betagande" ; -- betagande..nn.1
  betagen_1_A = mkA "betagen" ; -- betagen..av.1
  betagenhet_1_N = mkN "betagenhet" ; -- betagenhet..nn.1
  betala_1_V = mkV "betalar" ; -- betala..vb.1
  betalande_1_N = mkN "betalande" ; -- betalande..nn.1
  betalare_1_N = mkN "betalare" utrum  ; -- betalare..nn.1
  betalartikel_1_N = mkN "betalartikel" ; -- betalartikel..nn.1
  betalbar_1_A = mkA "betalbar" ; -- betalbar..av.1
  betalbarhet_1_N = mkN "betalbarhet" ; -- betalbarhet..nn.1
  betalkort_1_N = mkN "betalkort" neutrum  ; -- betalkort..nn.1
  betalkurs_1_N = mkN "betalkurs" "betalkurser" ; -- betalkurs..nn.1
  betalning_1_N = mkN "betalning" ; -- betalning..nn.1
  betalningsanmärkning_1_N = mkN "betalningsanmärkning" ; -- betalningsanmärkning..nn.1
  betalningsanstånd_1_N = mkN "betalningsanstånd" neutrum  ; -- betalningsanstånd..nn.1
  betalningsavtal_1_N = mkN "betalningsavtal" neutrum  ; -- betalningsavtal..nn.1
  betalningsbalans_1_N = mkN "betalningsbalans" "betalningsbalanser" ; -- betalningsbalans..nn.1
  betalningsbevis_1_N = mkN "betalningsbevis" neutrum  ; -- betalningsbevis..nn.1
  betalningsdag_1_N = mkN "betalningsdag" ; -- betalningsdag..nn.1
  betalningsfri_1_A = mkA "betalningsfri" "betalningsfritt" ; -- betalningsfri..av.1
  betalningsfrist_1_N = mkN "betalningsfrist" "betalningsfrister" ; -- betalningsfrist..nn.1
  betalningsföreläggande_1_N = mkN "betalningsföreläggande" ; -- betalningsföreläggande..nn.1
  betalningsförmåga_1_N = mkN "betalningsförmåga" ; -- betalningsförmåga..nn.1
  betalningsgill_1_A = mkA "betalningsgill" ; -- betalningsgill..av.1
  betalningsinställelse_1_N = mkN "betalningsinställelse" "betalningsinställelser" ; -- betalningsinställelse..nn.1
  betalningsmedel_1_N = mkN "betalningsmedel" neutrum  ; -- betalningsmedel..nn.1
  betalningsskyldig_1_A = mkA "betalningsskyldig" ; -- betalningsskyldig..av.1
  betalningsskyldighet_1_N = mkN "betalningsskyldighet" ; -- betalningsskyldighet..nn.1
  betalningssäkra_1_V = mkV "betalningssäkrar" ; -- betalningssäkra..vb.1
  betalningstermin_1_N = mkN "betalningstermin" "betalningsterminer" ; -- betalningstermin..nn.1
  betalningstid_1_N = mkN "betalningstid" "betalningstider" ; -- betalningstid..nn.1
  betalningsvilja_1_N = mkN "betalningsvilja" ; -- betalningsvilja..nn.1
  betalningsvillkor_1_N = mkN "betalningsvillkor" neutrum  ; -- betalningsvillkor..nn.1
  betalsex_1_N = mkN "betalsex" neutrum  ; -- betalsex..nn.1
  betaltjänst_1_N = mkN "betaltjänst" "betaltjänster" ; -- betaltjänst..nn.1
  betande_1_N = mkN "betande" ; -- betande..nn.1
  betapartikel_1_N = mkN "betapartikel" ; -- betapartikel..nn.1
  betastrålande_1_A = mkA "betastrålande" ; -- betastrålande..av.1
  betastrålning_1_N = mkN "betastrålning" ; -- betastrålning..nn.1
  betasönderfall_1_N = mkN "betasönderfall" neutrum  ; -- betasönderfall..nn.1
  betatron_1_N = mkN "betatron" "betatroner" ; -- betatron..nn.1
  bete_1_N = mkN "bete" ; -- bete..nn.1
  bete_2_N = mkN "bete" utrum  ; -- bete..nn.2
  beteckna_1_V = mkV "betecknar" ; -- beteckna..vb.1
  betecknande_1_A = mkA "betecknande" ; -- betecknande..av.1
  betecknande_1_N = mkN "betecknande" ; -- betecknande..nn.1
  beteckning_1_N = mkN "beteckning" ; -- beteckning..nn.1
  beteckningssätt_1_N = mkN "beteckningssätt" neutrum  ; -- beteckningssätt..nn.1
  beteende_1_N = mkN "beteende" ; -- beteende..nn.1
  beteendebehandling_1_N = mkN "beteendebehandling" ; -- beteendebehandling..nn.1
  beteendeforskning_1_N = mkN "beteendeforskning" ; -- beteendeforskning..nn.1
  beteendemässig_1_A = mkA "beteendemässig" ; -- beteendemässig..av.1
  beteendemönster_1_N = mkN "beteendemönster" neutrum  ; -- beteendemönster..nn.1
  beteendepsykologi_1_N = mkN "beteendepsykologi" ; -- beteendepsykologi..nn.1
  beteenderubbning_1_N = mkN "beteenderubbning" ; -- beteenderubbning..nn.1
  beteendeterapeut_1_N = mkN "beteendeterapeut" "beteendeterapeuter" ; -- beteendeterapeut..nn.1
  beteendeterapi_1_N = mkN "beteendeterapi" ; -- beteendeterapi..nn.1
  beteendevetare_1_N = mkN "beteendevetare" utrum  ; -- beteendevetare..nn.1
  beteendevetenskap_1_N = mkN "beteendevetenskap" "beteendevetenskaper" ; -- beteendevetenskap..nn.1
  beteendevetenskaplig_1_A = mkA "beteendevetenskaplig" ; -- beteendevetenskaplig..av.1
  betel_1_N = mkN "betel" ; -- betel..nn.1
  betelblad_1_N = mkN "betelblad" neutrum  ; -- betelblad..nn.1
  betelnöt_1_N = mkN "betelnöt" "betelnötter" ; -- betelnöt..nn.1
  betelpalm_1_N = mkN "betelpalm" "betelpalmer" ; -- betelpalm..nn.1
  beteltuggare_1_N = mkN "beteltuggare" utrum  ; -- beteltuggare..nn.1
  beteltuggning_1_N = mkN "beteltuggning" ; -- beteltuggning..nn.1
  betesgång_1_N = mkN "betesgång" ; -- betesgång..nn.1
  beteshage_1_N = mkN "beteshage" utrum  ; -- beteshage..nn.1
  betesland_1_N = mkN "betesland" neutrum  ; -- betesland..nn.1
  betesmark_1_N = mkN "betesmark" "betesmarker" ; -- betesmark..nn.1
  betesområde_1_N = mkN "betesområde" ; -- betesområde..nn.1
  betesplats_1_N = mkN "betesplats" "betesplatser" ; -- betesplats..nn.1
  betessläpp_1_N = mkN "betessläpp" ; -- betessläpp..nn.1
  betesutsläpp_1_N = mkN "betesutsläpp" ; -- betesutsläpp..nn.1
  beting_1_N = mkN "beting" neutrum  ; -- beting..nn.1
  beting_2_N = mkN "beting" ; -- beting..nn.2
  betinga_1_V = mkV "betingar" ; -- betinga..vb.1
  betingad_1_A = mkA "betingad" ; -- betingad..av.1
  betingande_1_N = mkN "betingande" ; -- betingande..nn.1
  betingelse_1_N = mkN "betingelse" "betingelser" ; -- betingelse..nn.1
  betingning_1_N = mkN "betingning" ; -- betingning..nn.1
  betingsarbete_1_N = mkN "betingsarbete" ; -- betingsarbete..nn.1
  betingsläsning_1_N = mkN "betingsläsning" ; -- betingsläsning..nn.1
  betitla_1_V = mkV "betitlar" ; -- betitla..vb.1
  betitlande_1_N = mkN "betitlande" ; -- betitlande..nn.1
  betitta_1_V = mkV "betittar" ; -- betitta..vb.1
  betittande_1_N = mkN "betittande" ; -- betittande..nn.1
  betjäna_1_V = mkV "betjänar" ; -- betjäna..vb.1
  betjänande_1_N = mkN "betjänande" ; -- betjänande..nn.1
  betjäning_1_N = mkN "betjäning" ; -- betjäning..nn.1
  betjäningsavgift_1_N = mkN "betjäningsavgift" "betjäningsavgifter" ; -- betjäningsavgift..nn.1
  betjänt_1_A = mkA "betjänt" "betjänt" ; -- betjänt..av.1
  betjänt_1_N = mkN "betjänt" "betjänter" ; -- betjänt..nn.1
  betkampanj_1_N = mkN "betkampanj" "betkampanjer" ; -- betkampanj..nn.1
  betmedel_1_N = mkN "betmedel" neutrum  ; -- betmedel..nn.1
  betning_1_N = mkN "betning" ; -- betning..nn.1
  betodling_1_N = mkN "betodling" ; -- betodling..nn.1
  betona_1_V = mkV "betonar" ; -- betona..vb.1
  betonad_1_A = mkA "betonad" ; -- betonad..av.1
  betonande_1_N = mkN "betonande" ; -- betonande..nn.1
  betong_1_N = mkN "betong" "betonger" ; -- betong..nn.1
  betongbjälklag_1_N = mkN "betongbjälklag" neutrum  ; -- betongbjälklag..nn.1
  betongblandare_1_N = mkN "betongblandare" utrum  ; -- betongblandare..nn.1
  betongblock_1_N = mkN "betongblock" neutrum  ; -- betongblock..nn.1
  betongbädd_1_N = mkN "betongbädd" ; -- betongbädd..nn.1
  betongera_1_V = mkV "betongerar" ; -- betongera..vb.1
  betongerande_1_N = mkN "betongerande" ; -- betongerande..nn.1
  betongerbar_1_A = mkA "betongerbar" ; -- betongerbar..av.1
  betongerbarhet_1_N = mkN "betongerbarhet" ; -- betongerbarhet..nn.1
  betongering_1_N = mkN "betongering" ; -- betongering..nn.1
  betongfärg_1_N = mkN "betongfärg" "betongfärger" ; -- betongfärg..nn.1
  betonggolv_1_N = mkN "betonggolv" neutrum  ; -- betonggolv..nn.1
  betonghinder_1_N = mkN "betonghinder" neutrum  ; -- betonghinder..nn.1
  betonghäck_1_N = mkN "betonghäck" ; -- betonghäck..nn.1
  betongmaskin_1_N = mkN "betongmaskin" "betongmaskiner" ; -- betongmaskin..nn.1
  betongparti_1_N = mkN "betongparti" "betongpartiet" "betongpartier" "betongpartierna" ; -- betongparti..nn.1
  betongpåle_1_N = mkN "betongpåle" utrum  ; -- betongpåle..nn.1
  betongsugga_1_N = mkN "betongsugga" ; -- betongsugga..nn.1
  betongvalv_1_N = mkN "betongvalv" neutrum  ; -- betongvalv..nn.1
  betongvibrator_1_N = mkN "betongvibrator" "betongvibratorer" ; -- betongvibrator..nn.1
  betoning_1_N = mkN "betoning" ; -- betoning..nn.1
  betrakta_1_V = mkV "betraktar" ; -- betrakta..vb.1
  betraktande_1_N = mkN "betraktande" ; -- betraktande..nn.1
  betraktare_1_N = mkN "betraktare" utrum  ; -- betraktare..nn.1
  betraktelse_1_N = mkN "betraktelse" "betraktelser" ; -- betraktelse..nn.1
  betraktelsesätt_1_N = mkN "betraktelsesätt" neutrum  ; -- betraktelsesätt..nn.1
  betro_1_V = mkV "betror" ; -- betro..vb.1
  betrodd_1_A = mkA "betrodd" ; -- betrodd..av.1
  betroddhet_1_N = mkN "betroddhet" ; -- betroddhet..nn.1
  betroende_1_N = mkN "betroende" ; -- betroende..nn.1
  betryck_1_N = mkN "betryck" neutrum  ; -- betryck..nn.1
  betrycka_1_V = mkV "betrycker" ; -- betrycka..vb.1
  betryckande_1_N = mkN "betryckande" ; -- betryckande..nn.1
  betryckt_1_A = mkA "betryckt" "betryckt" ; -- betryckt..av.1
  betryckthet_1_N = mkN "betryckthet" ; -- betryckthet..nn.1
  betrygga_1_V = mkV "betryggar" ; -- betrygga..vb.1
  betryggande_1_A = mkA "betryggande" ; -- betryggande..av.1
  betryggande_1_N = mkN "betryggande" ; -- betryggande..nn.1
  beträda_1_V = mkV "beträda" "beträdde" "beträtt" ; -- beträda..vb.1
  beträdande_1_N = mkN "beträdande" ; -- beträdande..nn.1
  beträffa_1_V = mkV "beträffar" ; -- beträffa..vb.1
  beträffande_1_N = mkN "beträffande" ; -- beträffande..nn.1
  beträngd_1_A = mkA "beträngd" "beträngt" ; -- beträngd..av.1
  beträngdhet_1_N = mkN "beträngdhet" ; -- beträngdhet..nn.1
  bets_1_N = mkN "bets" "betser" ; -- bets..nn.1
  betsa_1_V = mkV "betsar" ; -- betsa..vb.1
  betsande_1_N = mkN "betsande" ; -- betsande..nn.1
  betsel_1_N = mkN "betsel" neutrum  ; -- betsel..nn.1
  betsla_1_V = mkV "betslar" ; -- betsla..vb.1
  betslande_1_N = mkN "betslande" ; -- betslande..nn.1
  betsling_1_N = mkN "betsling" ; -- betsling..nn.1
  betsmedel_1_N = mkN "betsmedel" neutrum  ; -- betsmedel..nn.1
  betsning_1_N = mkN "betsning" ; -- betsning..nn.1
  betsocker_1_N = mkN "betsocker" neutrum  ; -- betsocker..nn.1
  betsockerindustri_1_N = mkN "betsockerindustri" "betsockerindustrier" ; -- betsockerindustri..nn.1
  bett_1_N = mkN "bett" neutrum  ; -- bett..nn.1
  bettel_1_N = mkN "bettel" ; -- bettel..nn.1
  bettla_1_V = mkV "bettlar" ; -- bettla..vb.1
  bettlande_1_N = mkN "bettlande" ; -- bettlande..nn.1
  bettlare_1_N = mkN "bettlare" utrum  ; -- bettlare..nn.1
  bettleri_1_N = mkN "bettleri" neutrum  ; -- bettleri..nn.1
  bettskena_1_N = mkN "bettskena" ; -- bettskena..nn.1
  betunga_1_V = mkV "betungar" ; -- betunga..vb.1
  betungande_1_A = mkA "betungande" ; -- betungande..av.1
  betungande_1_N = mkN "betungande" ; -- betungande..nn.1
  betuttad_1_A = mkA "betuttad" ; -- betuttad..av.1
  betvinga_1_V = mkV "betvingar" ; -- betvinga..vb.1
  betvingande_1_A = mkA "betvingande" ; -- betvingande..av.1
  betvingande_1_N = mkN "betvingande" ; -- betvingande..nn.1
  betvingare_1_N = mkN "betvingare" utrum  ; -- betvingare..nn.1
  betvivla_1_V = mkV "betvivlar" ; -- betvivla..vb.1
  betvivlande_1_N = mkN "betvivlande" ; -- betvivlande..nn.1
  betyda_1_V = mkV "betyda" "betydde" "betytt" ; -- betyda..vb.1
  betydande_1_A = mkA "betydande" ; -- betydande..av.1
  betydande_1_N = mkN "betydande" ; -- betydande..nn.1
  betydelse_1_N = mkN "betydelse" "betydelser" ; -- betydelse..nn.1
  betydelsebärande_1_A = mkA "betydelsebärande" ; -- betydelsebärande..av.1
  betydelsefattig_1_A = mkA "betydelsefattig" ; -- betydelsefattig..av.1
  betydelsefull_1_A = mkA "betydelsefull" ; -- betydelsefull..av.1
  betydelsefullhet_1_N = mkN "betydelsefullhet" ; -- betydelsefullhet..nn.1
  betydelseförskjutning_1_N = mkN "betydelseförskjutning" ; -- betydelseförskjutning..nn.1
  betydelseförändring_1_N = mkN "betydelseförändring" ; -- betydelseförändring..nn.1
  betydelseglidning_1_N = mkN "betydelseglidning" ; -- betydelseglidning..nn.1
  betydelselager_1_N = mkN "betydelselager" neutrum  ; -- betydelselager..nn.1
  betydelselära_1_N = mkN "betydelselära" ; -- betydelselära..nn.1
  betydelselös_1_A = mkA "betydelselös" ; -- betydelselös..av.1
  betydelselöshet_1_N = mkN "betydelselöshet" ; -- betydelselöshet..nn.1
  betydelsemässig_1_A = mkA "betydelsemässig" ; -- betydelsemässig..av.1
  betydelsenyans_1_N = mkN "betydelsenyans" "betydelsenyanser" ; -- betydelsenyans..nn.1
  betydelseskikt_1_N = mkN "betydelseskikt" neutrum  ; -- betydelseskikt..nn.1
  betydelseutveckling_1_N = mkN "betydelseutveckling" ; -- betydelseutveckling..nn.1
  betydenhet_1_N = mkN "betydenhet" "betydenheter" ; -- betydenhet..nn.1
  betydlig_1_A = mkA "betydlig" ; -- betydlig..av.1
  betydlighet_1_N = mkN "betydlighet" ; -- betydlighet..nn.1
  betyg_1_N = mkN "betyg" neutrum  ; -- betyg..nn.1
  betyga_1_V = mkV "betygar" ; -- betyga..vb.1
  betygande_1_N = mkN "betygande" ; -- betygande..nn.1
  betygelse_1_N = mkN "betygelse" "betygelser" ; -- betygelse..nn.1
  betyghöjning_1_N = mkN "betyghöjning" ; -- betyghöjning..nn.1
  betygkramare_1_N = mkN "betygkramare" utrum  ; -- betygkramare..nn.1
  betygsavskrift_1_N = mkN "betygsavskrift" "betygsavskrifter" ; -- betygsavskrift..nn.1
  betygsfri_1_A = mkA "betygsfri" "betygsfritt" ; -- betygsfri..av.1
  betygsgrad_1_N = mkN "betygsgrad" "betygsgrader" ; -- betygsgrad..nn.1
  betygshets_1_N = mkN "betygshets" ; -- betygshets..nn.1
  betygshöjning_1_N = mkN "betygshöjning" ; -- betygshöjning..nn.1
  betygsjäkt_1_N = mkN "betygsjäkt" ; -- betygsjäkt..nn.1
  betygskatalog_1_N = mkN "betygskatalog" "betygskataloger" ; -- betygskatalog..nn.1
  betygsnämnd_1_N = mkN "betygsnämnd" "betygsnämnder" ; -- betygsnämnd..nn.1
  betygsskala_1_N = mkN "betygsskala" ; -- betygsskala..nn.1
  betygsstress_1_N = mkN "betygsstress" ; -- betygsstress..nn.1
  betygssänkning_1_N = mkN "betygssänkning" ; -- betygssänkning..nn.1
  betygssätta_1_V = mkV "betygssätta" "betygssätter" "betygssätt" "betygssatte" "betygssatt" "betygssatt" ; -- betygssätta..vb.1
  betygssättande_1_N = mkN "betygssättande" ; -- betygssättande..nn.1
  betygssättning_1_N = mkN "betygssättning" ; -- betygssättning..nn.1
  betygsänkning_1_N = mkN "betygsänkning" ; -- betygsänkning..nn.1
  betygsätta_1_V = mkV "betygsätta" "betygsätter" "betygsätt" "betygsatte" "betygsatt" "betygsatt" ; -- betygsätta..vb.1
  betygsättande_1_N = mkN "betygsättande" ; -- betygsättande..nn.1
  betygsättning_1_N = mkN "betygsättning" ; -- betygsättning..nn.1
  betäcka_1_V = mkV "betäcker" ; -- betäcka..vb.1
  betäckande_1_N = mkN "betäckande" ; -- betäckande..nn.1
  betäckning_1_N = mkN "betäckning" ; -- betäckning..nn.1
  betäckningsavgift_1_N = mkN "betäckningsavgift" "betäckningsavgifter" ; -- betäckningsavgift..nn.1
  betänka_1_V = mkV "betänker" ; -- betänka..vb.1
  betänkande_1_N = mkN "betänkande" ; -- betänkande..nn.1
  betänketid_1_N = mkN "betänketid" "betänketider" ; -- betänketid..nn.1
  betänklig_1_A = mkA "betänklig" ; -- betänklig..av.1
  betänklighet_1_N = mkN "betänklighet" "betänkligheter" ; -- betänklighet..nn.1
  betänksam_1_A = mkA "betänksam" "betänksamt" "betänksamma" "betänksamma" "betänksammare" "betänksammast" "betänksammaste" ; -- betänksam..av.1
  betänksamhet_1_N = mkN "betänksamhet" ; -- betänksamhet..nn.1
  betänkt_1_A = mkA "betänkt" "betänkt" ; -- betänkt..av.1
  beundra_1_V = mkV "beundrar" ; -- beundra..vb.1
  beundrande_1_N = mkN "beundrande" ; -- beundrande..nn.1
  beundransvärd_1_A = mkA "beundransvärd" "beundransvärt" ; -- beundransvärd..av.1
  beundransvärdhet_1_N = mkN "beundransvärdhet" ; -- beundransvärdhet..nn.1
  beundrare_1_N = mkN "beundrare" utrum  ; -- beundrare..nn.1
  beundrarinna_1_N = mkN "beundrarinna" ; -- beundrarinna..nn.1
  bevaka_1_V = mkV "bevakar" ; -- bevaka..vb.1
  bevakande_1_N = mkN "bevakande" ; -- bevakande..nn.1
  bevakning_1_N = mkN "bevakning" ; -- bevakning..nn.1
  bevakningsinlaga_1_N = mkN "bevakningsinlaga" ; -- bevakningsinlaga..nn.1
  bevakningsinsats_1_N = mkN "bevakningsinsats" "bevakningsinsatser" ; -- bevakningsinsats..nn.1
  bevakningskedja_1_N = mkN "bevakningskedja" ; -- bevakningskedja..nn.1
  bevakningsområde_1_N = mkN "bevakningsområde" ; -- bevakningsområde..nn.1
  bevakningsuppdrag_1_N = mkN "bevakningsuppdrag" neutrum  ; -- bevakningsuppdrag..nn.1
  bevandrad_1_A = mkA "bevandrad" ; -- bevandrad..av.1
  bevara_1_V = mkV "bevarar" ; -- bevara..vb.1
  bevarande_1_N = mkN "bevarande" ; -- bevarande..nn.1
  bevarandeomständighet_1_N = mkN "bevarandeomständighet" "bevarandeomständigheter" ; -- bevarandeomständighet..nn.1
  bevare_1_V = mkV "bevare" ; -- bevare..vb.1
  bevattna_1_V = mkV "bevattnar" ; -- bevattna..vb.1
  bevattnande_1_N = mkN "bevattnande" ; -- bevattnande..nn.1
  bevattning_1_N = mkN "bevattning" ; -- bevattning..nn.1
  bevattningsanläggning_1_N = mkN "bevattningsanläggning" ; -- bevattningsanläggning..nn.1
  bevattningsförbud_1_N = mkN "bevattningsförbud" neutrum  ; -- bevattningsförbud..nn.1
  bevattningskanal_1_N = mkN "bevattningskanal" "bevattningskanaler" ; -- bevattningskanal..nn.1
  bevattningsregel_1_N = mkN "bevattningsregel" "bevattningsregeln" "bevattningsregler" "bevattningsreglerna" ; -- bevattningsregel..nn.1
  bevattningssystem_1_N = mkN "bevattningssystem" neutrum  ; -- bevattningssystem..nn.1
  beveka_1_V = mkV "beveker" ; -- beveka..vb.1
  bevekande_1_A = mkA "bevekande" ; -- bevekande..av.1
  bevekande_1_N = mkN "bevekande" ; -- bevekande..nn.1
  bevekelse_1_N = mkN "bevekelse" "bevekelser" ; -- bevekelse..nn.1
  bevekelsegrund_1_N = mkN "bevekelsegrund" "bevekelsegrunder" ; -- bevekelsegrund..nn.1
  bevilja_1_V = mkV "beviljar" ; -- bevilja..vb.1
  beviljande_1_N = mkN "beviljande" ; -- beviljande..nn.1
  bevillning_1_N = mkN "bevillning" ; -- bevillning..nn.1
  bevillningsavgift_1_N = mkN "bevillningsavgift" "bevillningsavgifter" ; -- bevillningsavgift..nn.1
  bevillningsutskott_1_N = mkN "bevillningsutskott" neutrum  ; -- bevillningsutskott..nn.1
  bevingad_1_A = mkA "bevingad" ; -- bevingad..av.1
  bevis_1_N = mkN "bevis" neutrum  ; -- bevis..nn.1
  bevisa_1_V = mkV "bevisar" ; -- bevisa..vb.1
  bevisande_1_N = mkN "bevisande" ; -- bevisande..nn.1
  bevisbar_1_A = mkA "bevisbar" ; -- bevisbar..av.1
  bevisbarhet_1_N = mkN "bevisbarhet" ; -- bevisbarhet..nn.1
  bevisbörda_1_N = mkN "bevisbörda" ; -- bevisbörda..nn.1
  bevisföring_1_N = mkN "bevisföring" ; -- bevisföring..nn.1
  bevisförvanskning_1_N = mkN "bevisförvanskning" ; -- bevisförvanskning..nn.1
  beviskedja_1_N = mkN "beviskedja" ; -- beviskedja..nn.1
  beviskraft_1_N = mkN "beviskraft" "beviskrafter" ; -- beviskraft..nn.1
  beviskraftig_1_A = mkA "beviskraftig" ; -- beviskraftig..av.1
  beviskraftighet_1_N = mkN "beviskraftighet" ; -- beviskraftighet..nn.1
  beviskrav_1_N = mkN "beviskrav" neutrum  ; -- beviskrav..nn.1
  bevislig_1_A = mkA "bevislig" ; -- bevislig..av.1
  bevisligen_1_Adv = mkAdv "bevisligen" ; -- bevisligen..ab.1
  bevislighet_1_N = mkN "bevislighet" ; -- bevislighet..nn.1
  bevismaterial_1_N = mkN "bevismaterial" neutrum  ; -- bevismaterial..nn.1
  bevismedel_1_N = mkN "bevismedel" neutrum  ; -- bevismedel..nn.1
  bevismässig_1_A = mkA "bevismässig" ; -- bevismässig..av.1
  bevisning_1_N = mkN "bevisning" ; -- bevisning..nn.1
  bevisprövning_1_N = mkN "bevisprövning" ; -- bevisprövning..nn.1
  bevisskyldig_1_A = mkA "bevisskyldig" ; -- bevisskyldig..av.1
  bevisskyldighet_1_N = mkN "bevisskyldighet" ; -- bevisskyldighet..nn.1
  bevissvårighet_1_N = mkN "bevissvårighet" "bevissvårigheter" ; -- bevissvårighet..nn.1
  bevissäkring_1_N = mkN "bevissäkring" ; -- bevissäkring..nn.1
  bevista_1_V = mkV "bevistar" ; -- bevista..vb.1
  bevistande_1_N = mkN "bevistande" ; -- bevistande..nn.1
  bevisvärde_1_N = mkN "bevisvärde" ; -- bevisvärde..nn.1
  bevisvärdering_1_N = mkN "bevisvärdering" ; -- bevisvärdering..nn.1
  bevittna_1_V = mkV "bevittnar" ; -- bevittna..vb.1
  bevittnande_1_N = mkN "bevittnande" ; -- bevittnande..nn.1
  bevuxen_1_A = mkA "bevuxen" ; -- bevuxen..av.1
  bevänt_1_A = mkA "bevänt" ; -- bevänt..av.1
  beväpna_1_V = mkV "beväpnar" ; -- beväpna..vb.1
  beväpnad_1_A = mkA "beväpnad" ; -- beväpnad..av.1
  beväpnande_1_N = mkN "beväpnande" ; -- beväpnande..nn.1
  beväpning_1_N = mkN "beväpning" ; -- beväpning..nn.1
  bevära_1_V = mkV "bevärar" ; -- bevära..vb.1
  bevärande_1_N = mkN "bevärande" ; -- bevärande..nn.1
  bevärdiga_1_V = mkV "bevärdigar" ; -- bevärdiga..vb.1
  bevärdigande_1_N = mkN "bevärdigande" ; -- bevärdigande..nn.1
  beväring_1_N = mkN "beväring" ; -- beväring..nn.1
  beväxt_1_A = mkA "beväxt" "beväxt" ; -- beväxt..av.1
  bevågen_1_A = mkA "bevågen" ; -- bevågen..av.1
  bevågenhet_1_N = mkN "bevågenhet" "bevågenheter" ; -- bevågenhet..nn.1
  bezique_1_N = mkN "bezique" utrum  ; -- bezique..nn.1
  bhutanes_1_N = mkN "bhutanes" "bhutaneser" ; -- bhutanes..nn.1
  bhutanesisk_1_A = mkA "bhutanesisk" ; -- bhutanesisk..av.1
  bhutanesiska_1_N = mkN "bhutanesiska" ; -- bhutanesiska..nn.1
  bi_1_A = mkA "bi" ; -- bi..av.1
  bi_1_N = mkN "bi" "biet" "bin" "bina" ; -- bi..nn.1
  biaccent_1_N = mkN "biaccent" "biaccenter" ; -- biaccent..nn.1
  bias_1_N = mkN "bias" "biaser" ; -- bias..nn.1
  biavel_1_N = mkN "biavel" ; -- biavel..nn.1
  biavsikt_1_N = mkN "biavsikt" "biavsikter" ; -- biavsikt..nn.1
  bibana_1_N = mkN "bibana" ; -- bibana..nn.1
  bibehålla_1_V = mkV "bibehålla" "bibehöll" "bibehållit" ; -- bibehålla..vb.1
  bibehållande_1_N = mkN "bibehållande" ; -- bibehållande..nn.1
  bibehållen_1_A = mkA "bibehållen" ; -- bibehållen..av.1
  bibel_1_N = mkN "bibel" ; -- bibel..nn.1
  bibelcitat_1_N = mkN "bibelcitat" neutrum  ; -- bibelcitat..nn.1
  bibelexeget_1_N = mkN "bibelexeget" "bibelexegeter" ; -- bibelexeget..nn.1
  bibelforskning_1_N = mkN "bibelforskning" ; -- bibelforskning..nn.1
  bibelförklaring_1_N = mkN "bibelförklaring" ; -- bibelförklaring..nn.1
  bibelhandskrift_1_N = mkN "bibelhandskrift" "bibelhandskrifter" ; -- bibelhandskrift..nn.1
  bibelkanon_1_N = mkN "bibelkanon" "bibelkanon" "bibelkanoner" "bibelkanonerna" ; -- bibelkanon..nn.1
  bibelkommission_1_N = mkN "bibelkommission" ; -- bibelkommission..nn.1
  bibelkonkordans_1_N = mkN "bibelkonkordans" "bibelkonkordanser" ; -- bibelkonkordans..nn.1
  bibelkristen_1_A = mkA "bibelkristen" ; -- bibelkristen..av.1
  bibelkristenhet_1_N = mkN "bibelkristenhet" ; -- bibelkristenhet..nn.1
  bibelkritik_1_N = mkN "bibelkritik" ; -- bibelkritik..nn.1
  bibelkunnig_1_A = mkA "bibelkunnig" ; -- bibelkunnig..av.1
  bibelkunnighet_1_N = mkN "bibelkunnighet" ; -- bibelkunnighet..nn.1
  bibelord_1_N = mkN "bibelord" neutrum  ; -- bibelord..nn.1
  bibelsamtal_1_N = mkN "bibelsamtal" neutrum  ; -- bibelsamtal..nn.1
  bibelsprängd_1_A = mkA "bibelsprängd" "bibelsprängt" ; -- bibelsprängd..av.1
  bibelsprängdhet_1_N = mkN "bibelsprängdhet" ; -- bibelsprängdhet..nn.1
  bibelspråk_1_N = mkN "bibelspråk" neutrum  ; -- bibelspråk..nn.1
  bibelställe_1_N = mkN "bibelställe" ; -- bibelställe..nn.1
  bibelsällskap_1_N = mkN "bibelsällskap" neutrum  ; -- bibelsällskap..nn.1
  bibeltext_1_N = mkN "bibeltext" "bibeltexter" ; -- bibeltext..nn.1
  bibeltolkning_1_N = mkN "bibeltolkning" ; -- bibeltolkning..nn.1
  bibeltroende_1_A = mkA "bibeltroende" ; -- bibeltroende..av.1
  bibeltrogen_1_A = mkA "bibeltrogen" ; -- bibeltrogen..av.1
  bibeltrogenhet_1_N = mkN "bibeltrogenhet" ; -- bibeltrogenhet..nn.1
  bibelvers_1_N = mkN "bibelvers" ; -- bibelvers..nn.1
  bibelöversättning_1_N = mkN "bibelöversättning" ; -- bibelöversättning..nn.1
  bibestämning_1_N = mkN "bibestämning" ; -- bibestämning..nn.1
  bibetydelse_1_N = mkN "bibetydelse" "bibetydelser" ; -- bibetydelse..nn.1
  biblicism_1_N = mkN "biblicism" "biblicismer" ; -- biblicism..nn.1
  biblicistisk_1_A = mkA "biblicistisk" ; -- biblicistisk..av.1
  bibliofil_1_N = mkN "bibliofil" "bibliofiler" ; -- bibliofil..nn.1
  bibliofilupplaga_1_N = mkN "bibliofilupplaga" ; -- bibliofilupplaga..nn.1
  bibliograf_1_N = mkN "bibliograf" "bibliografer" ; -- bibliograf..nn.1
  bibliografi_1_N = mkN "bibliografi" "bibliografier" ; -- bibliografi..nn.1
  bibliografisk_1_A = mkA "bibliografisk" ; -- bibliografisk..av.1
  biblioman_1_N = mkN "biblioman" "bibliomaner" ; -- biblioman..nn.1
  bibliomani_1_N = mkN "bibliomani" ; -- bibliomani..nn.1
  bibliometri_1_N = mkN "bibliometri" ; -- bibliometri..nn.1
  bibliotek_1_N = mkN "bibliotek" neutrum  ; -- bibliotek..nn.1
  bibliotekarie_1_N = mkN "bibliotekarie" "bibliotekarier" ; -- bibliotekarie..nn.1
  biblioteksavgift_1_N = mkN "biblioteksavgift" "biblioteksavgifter" ; -- biblioteksavgift..nn.1
  biblioteksband_1_N = mkN "biblioteksband" neutrum  ; -- biblioteksband..nn.1
  biblioteksbelysning_1_N = mkN "biblioteksbelysning" ; -- biblioteksbelysning..nn.1
  biblioteksbord_1_N = mkN "biblioteksbord" neutrum  ; -- biblioteksbord..nn.1
  biblioteksbrand_1_N = mkN "biblioteksbrand" "biblioteksbränder" ; -- biblioteksbrand..nn.1
  bibliotekshögskola_1_N = mkN "bibliotekshögskola" ; -- bibliotekshögskola..nn.1
  bibliotekskatalog_1_N = mkN "bibliotekskatalog" "bibliotekskataloger" ; -- bibliotekskatalog..nn.1
  bibliotekslån_1_N = mkN "bibliotekslån" neutrum  ; -- bibliotekslån..nn.1
  biblisk_1_A = mkA "biblisk" ; -- biblisk..av.1
  biblomma_1_N = mkN "biblomma" ; -- biblomma..nn.1
  bibringa_1_V = mkV "bibringar" ; -- bibringa..vb.1
  bibringande_1_N = mkN "bibringande" ; -- bibringande..nn.1
  bibröd_1_N = mkN "bibröd" neutrum  ; -- bibröd..nn.1
  biceps_1_N = mkN "biceps" ; -- biceps..nn.1
  bicepsmuskel_1_N = mkN "bicepsmuskel" "bicepsmuskeln" "bicepsmuskler" "bicepsmusklerna" ; -- bicepsmuskel..nn.1
  bicepssena_1_N = mkN "bicepssena" ; -- bicepssena..nn.1
  bida_1_V = mkV "bidar" ; -- bida..vb.1
  bidande_1_N = mkN "bidande" ; -- bidande..nn.1
  bidevindare_1_N = mkN "bidevindare" utrum  ; -- bidevindare..nn.1
  bidevindsegel_1_N = mkN "bidevindsegel" neutrum  ; -- bidevindsegel..nn.1
  bidevindseglare_1_N = mkN "bidevindseglare" utrum  ; -- bidevindseglare..nn.1
  bidra_1_V = mkV "bidraga" "bidrog" "bidragit" ; -- bidra..vb.1
  bidrag_1_N = mkN "bidrag" neutrum  ; -- bidrag..nn.1
  bidragande_1_A = mkA "bidragande" ; -- bidragande..av.1
  bidragande_1_N = mkN "bidragande" ; -- bidragande..nn.1
  bidragsberoende_1_N = mkN "bidragsberoende" ; -- bidragsberoende..nn.1
  bidragsdel_1_N = mkN "bidragsdel" "bidragsdelen" "bidragsdelar" "bidragsdelarna" ; -- bidragsdel..nn.1
  bidragsfusk_1_N = mkN "bidragsfusk" neutrum  ; -- bidragsfusk..nn.1
  bidragsfuskare_1_N = mkN "bidragsfuskare" utrum  ; -- bidragsfuskare..nn.1
  bidragsförskott_1_N = mkN "bidragsförskott" neutrum  ; -- bidragsförskott..nn.1
  bidragsgivare_1_N = mkN "bidragsgivare" utrum  ; -- bidragsgivare..nn.1
  bidragsgrundande_1_A = mkA "bidragsgrundande" ; -- bidragsgrundande..av.1
  bidragsmiljon_1_N = mkN "bidragsmiljon" "bidragsmiljoner" ; -- bidragsmiljon..nn.1
  bidragsskyldighet_1_N = mkN "bidragsskyldighet" "bidragsskyldigheter" ; -- bidragsskyldighet..nn.1
  bidrottning_1_N = mkN "bidrottning" ; -- bidrottning..nn.1
  bidé_1_N = mkN "bidé" "bidéer" ; -- bidé..nn.1
  biedermeierstil_1_N = mkN "biedermeierstil" ; -- biedermeierstil..nn.1
  bieffekt_1_N = mkN "bieffekt" "bieffekter" ; -- bieffekt..nn.1
  bienn_1_A = mkA "bienn" "bient" ; -- bienn..av.1
  biennal_1_N = mkN "biennal" "biennaler" ; -- biennal..nn.1
  bifall_1_N = mkN "bifall" neutrum  ; -- bifall..nn.1
  bifalla_1_V = mkV "bifalla" "biföll" "bifallit" ; -- bifalla..vb.1
  bifallande_1_N = mkN "bifallande" ; -- bifallande..nn.1
  bifallsnick_1_N = mkN "bifallsnick" ; -- bifallsnick..nn.1
  bifallsrop_1_N = mkN "bifallsrop" neutrum  ; -- bifallsrop..nn.1
  bifallsstorm_1_N = mkN "bifallsstorm" ; -- bifallsstorm..nn.1
  bifallsyttring_1_N = mkN "bifallsyttring" ; -- bifallsyttring..nn.1
  bifenyl_1_N = mkN "bifenyl" "bifenyler" ; -- bifenyl..nn.1
  biff_1_A = mkA "biff" ; -- biff..av.1
  biff_1_N = mkN "biff" ; -- biff..nn.1
  biffdjur_1_N = mkN "biffdjur" neutrum  ; -- biffdjur..nn.1
  biffig_1_A = mkA "biffig" ; -- biffig..av.1
  biffighet_1_N = mkN "biffighet" ; -- biffighet..nn.1
  biffko_1_N = mkN "biffko" "biffkor" ; -- biffko..nn.1
  biffrad_1_N = mkN "biffrad" "biffrader" ; -- biffrad..nn.1
  biffstek_1_N = mkN "biffstek" ; -- biffstek..nn.1
  biffyxa_1_N = mkN "biffyxa" ; -- biffyxa..nn.1
  bifigur_1_N = mkN "bifigur" "bifigurer" ; -- bifigur..nn.1
  bifilar_1_A = mkA "bifilar" ; -- bifilar..av.1
  bifilär_1_A = mkA "bifilär" ; -- bifilär..av.1
  biflod_1_N = mkN "biflod" "bifloder" ; -- biflod..nn.1
  biflöde_1_N = mkN "biflöde" ; -- biflöde..nn.1
  bifoga_1_V = mkV "bifogar" ; -- bifoga..vb.1
  bifogande_1_N = mkN "bifogande" ; -- bifogande..nn.1
  bifokalglas_1_N = mkN "bifokalglas" neutrum  ; -- bifokalglas..nn.1
  biform_1_N = mkN "biform" "biformer" ; -- biform..nn.1
  bifurkation_1_N = mkN "bifurkation" ; -- bifurkation..nn.1
  biförtjänst_1_N = mkN "biförtjänst" "biförtjänster" ; -- biförtjänst..nn.1
  bigami_1_N = mkN "bigami" ; -- bigami..nn.1
  bigamist_1_N = mkN "bigamist" "bigamister" ; -- bigamist..nn.1
  bigarrå_1_N = mkN "bigarrå" "bigarråer" ; -- bigarrå..nn.1
  bigata_1_N = mkN "bigata" ; -- bigata..nn.1
  bigift_1_N = mkN "bigift" "bigiftet" "bigifter" "bigifterna" ; -- bigift..nn.1
  bigott_1_A = mkA "bigott" ; -- bigott..av.1
  bigotteri_1_N = mkN "bigotteri" "bigotteriet" "bigotterier" "bigotterierna" ; -- bigotteri..nn.1
  bigram_1_N = mkN "bigram" "bigrammet" "bigram" "bigrammen" ; -- bigram..nn.1
  bigård_1_N = mkN "bigård" ; -- bigård..nn.1
  bihandling_1_N = mkN "bihandling" ; -- bihandling..nn.1
  bihang_1_N = mkN "bihang" neutrum  ; -- bihang..nn.1
  bihav_1_N = mkN "bihav" neutrum  ; -- bihav..nn.1
  bihus_1_N = mkN "bihus" neutrum  ; -- bihus..nn.1
  bihustru_1_N = mkN "bihustru" "bihustrun" "bihustrur" "bihustrurna" ; -- bihustru..nn.1
  bihuva_1_N = mkN "bihuva" ; -- bihuva..nn.1
  bihåla_1_N = mkN "bihåla" ; -- bihåla..nn.1
  bihåleinflammation_1_N = mkN "bihåleinflammation" ; -- bihåleinflammation..nn.1
  biinkomst_1_N = mkN "biinkomst" "biinkomster" ; -- biinkomst..nn.1
  bikarbonat_1_N = mkN "bikarbonat" ; -- bikarbonat..nn.1
  bikini_1_N = mkN "bikini" "bikinin" "bikinis" "bikinisen" ; -- bikini..nn.1
  bikiniprydd_1_A = mkA "bikiniprydd" ; -- bikiniprydd..av.1
  biklöv_1_N = mkN "biklöv" ; -- biklöv..nn.1
  bikonkav_1_A = mkA "bikonkav" ; -- bikonkav..av.1
  bikonvex_1_A = mkA "bikonvex" ; -- bikonvex..av.1
  bikrona_1_N = mkN "bikrona" ; -- bikrona..nn.1
  bikt_1_N = mkN "bikt" "bikter" ; -- bikt..nn.1
  bikta_1_V = mkV "biktar" ; -- bikta..vb.1
  biktande_1_N = mkN "biktande" ; -- biktande..nn.1
  biktbarn_1_N = mkN "biktbarn" neutrum  ; -- biktbarn..nn.1
  biktfar_1_N = mkN "biktfader" "biktfadern" "biktfäder" "biktfäderna" ; -- biktfar..nn.1
  biktstol_1_N = mkN "biktstol" ; -- biktstol..nn.1
  bikupa_1_N = mkN "bikupa" ; -- bikupa..nn.1
  bikvadrat_1_N = mkN "bikvadrat" "bikvadrater" ; -- bikvadrat..nn.1
  bikvadratisk_1_A = mkA "bikvadratisk" ; -- bikvadratisk..av.1
  bil_1_N = mkN "bil" ; -- bil..nn.1
  bila_1_N = mkN "bila" ; -- bila..nn.1
  bila_1_V = mkV "bilar" ; -- bila..vb.1
  bila_2_V = mkV "bilar" ; -- bila..vb.2
  bilabial_1_A = mkA "bilabial" ; -- bilabial..av.1
  bilaccis_1_N = mkN "bilaccis" "bilacciser" ; -- bilaccis..nn.1
  bilaffär_1_N = mkN "bilaffär" "bilaffärer" ; -- bilaffär..nn.1
  bilaga_1_N = mkN "bilaga" ; -- bilaga..nn.1
  biland_1_N = mkN "biland" "bilandet" "biländer" "biländerna" ; -- biland..nn.1
  bilande_1_N = mkN "bilande" ; -- bilande..nn.1
  bilantenn_1_N = mkN "bilantenn" "bilantenner" ; -- bilantenn..nn.1
  bilateral_1_A = mkA "bilateral" ; -- bilateral..av.1
  bilbana_1_N = mkN "bilbana" ; -- bilbana..nn.1
  bilbatteri_1_N = mkN "bilbatteri" "bilbatteriet" "bilbatterier" "bilbatterierna" ; -- bilbatteri..nn.1
  bilbesiktning_1_N = mkN "bilbesiktning" ; -- bilbesiktning..nn.1
  bilbingo_1_N = mkN "bilbingo" ; -- bilbingo..nn.1
  bilboké_1_N = mkN "bilboké" "bilbokéer" ; -- bilboké..nn.1
  bilbrand_1_N = mkN "bilbrand" "bilbränder" ; -- bilbrand..nn.1
  bilbransch_1_N = mkN "bilbransch" ; -- bilbransch..nn.1
  bilbroms_1_N = mkN "bilbroms" ; -- bilbroms..nn.1
  bilburen_1_A = mkA "bilburen" ; -- bilburen..av.1
  bilbyggeri_1_N = mkN "bilbyggeri" "bilbyggeriet" "bilbyggerier" "bilbyggerierna" ; -- bilbyggeri..nn.1
  bilbälte_1_N = mkN "bilbälte" ; -- bilbälte..nn.1
  bild_1_N = mkN "bild" "bilder" ; -- bild..nn.1
  bilda_1_V = mkV "bildar" ; -- bilda..vb.1
  bildad_1_A = mkA "bildad" ; -- bildad..av.1
  bildammsugare_1_N = mkN "bildammsugare" utrum  ; -- bildammsugare..nn.1
  bildande_1_A = mkA "bildande" ; -- bildande..av.1
  bildande_1_N = mkN "bildande" ; -- bildande..nn.1
  bildband_1_N = mkN "bildband" neutrum  ; -- bildband..nn.1
  bildbar_1_A = mkA "bildbar" ; -- bildbar..av.1
  bildbarhet_1_N = mkN "bildbarhet" ; -- bildbarhet..nn.1
  bildberättelse_1_N = mkN "bildberättelse" "bildberättelser" ; -- bildberättelse..nn.1
  bildbevis_1_N = mkN "bildbevis" neutrum  ; -- bildbevis..nn.1
  bilderbok_1_N = mkN "bilderbok" "bilderböcker" ; -- bilderbok..nn.1
  bildflöde_1_N = mkN "bildflöde" ; -- bildflöde..nn.1
  bildgalleri_1_N = mkN "bildgalleri" "bildgalleriet" "bildgallerier" "bildgallerierna" ; -- bildgalleri..nn.1
  bildgåta_1_N = mkN "bildgåta" ; -- bildgåta..nn.1
  bildhuggare_1_N = mkN "bildhuggare" utrum  ; -- bildhuggare..nn.1
  bildhuggarkonst_1_N = mkN "bildhuggarkonst" ; -- bildhuggarkonst..nn.1
  bildhuggarmejsel_1_N = mkN "bildhuggarmejsel" ; -- bildhuggarmejsel..nn.1
  bildhuggeri_1_N = mkN "bildhuggeri" "bildhuggeriet" "bildhuggerier" "bildhuggerierna" ; -- bildhuggeri..nn.1
  bildhållning_1_N = mkN "bildhållning" ; -- bildhållning..nn.1
  bildinnehav_1_N = mkN "bildinnehav" neutrum  ; -- bildinnehav..nn.1
  bildkarta_1_N = mkN "bildkarta" ; -- bildkarta..nn.1
  bildkonst_1_N = mkN "bildkonst" "bildkonster" ; -- bildkonst..nn.1
  bildkryss_1_N = mkN "bildkryss" neutrum  ; -- bildkryss..nn.1
  bildlig_1_A = mkA "bildlig" ; -- bildlig..av.1
  bildlighet_1_N = mkN "bildlighet" ; -- bildlighet..nn.1
  bildlik_1_A = mkA "bildlik" ; -- bildlik..av.1
  bildlikhet_1_N = mkN "bildlikhet" ; -- bildlikhet..nn.1
  bildmanipulation_1_N = mkN "bildmanipulation" ; -- bildmanipulation..nn.1
  bildmaterial_1_N = mkN "bildmaterial" neutrum  ; -- bildmaterial..nn.1
  bildminne_1_N = mkN "bildminne" ; -- bildminne..nn.1
  bildmonitor_1_N = mkN "bildmonitor" "bildmonitorer" ; -- bildmonitor..nn.1
  bildmässig_1_A = mkA "bildmässig" ; -- bildmässig..av.1
  bildmässighet_1_N = mkN "bildmässighet" ; -- bildmässighet..nn.1
  bildning_1_N = mkN "bildning" ; -- bildning..nn.1
  bildningsanstalt_1_N = mkN "bildningsanstalt" "bildningsanstalter" ; -- bildningsanstalt..nn.1
  bildningsaristokrat_1_N = mkN "bildningsaristokrat" "bildningsaristokrater" ; -- bildningsaristokrat..nn.1
  bildningsfel_1_N = mkN "bildningsfel" "bildningsfelet" "bildningsfel" "bildningsfelen" ; -- bildningsfel..nn.1
  bildningsföraktare_1_N = mkN "bildningsföraktare" utrum  ; -- bildningsföraktare..nn.1
  bildningsförbund_1_N = mkN "bildningsförbund" neutrum  ; -- bildningsförbund..nn.1
  bildningsgrad_1_N = mkN "bildningsgrad" "bildningsgrader" ; -- bildningsgrad..nn.1
  bildningsgång_1_N = mkN "bildningsgång" ; -- bildningsgång..nn.1
  bildningshögfärd_1_N = mkN "bildningshögfärd" ; -- bildningshögfärd..nn.1
  bildningsmässig_1_A = mkA "bildningsmässig" ; -- bildningsmässig..av.1
  bildningsnivå_1_N = mkN "bildningsnivå" "bildningsnivåer" ; -- bildningsnivå..nn.1
  bildningsorganisation_1_N = mkN "bildningsorganisation" ; -- bildningsorganisation..nn.1
  bildningsroman_1_N = mkN "bildningsroman" "bildningsromaner" ; -- bildningsroman..nn.1
  bildningstörst_1_N = mkN "bildningstörst" ; -- bildningstörst..nn.1
  bildningsverksamhet_1_N = mkN "bildningsverksamhet" "bildningsverksamheter" ; -- bildningsverksamhet..nn.1
  bildningsvärme_1_N = mkN "bildningsvärme" ; -- bildningsvärme..nn.1
  bildprakt_1_N = mkN "bildprakt" ; -- bildprakt..nn.1
  bildradio_1_N = mkN "bildradio" ; -- bildradio..nn.1
  bildredaktör_1_N = mkN "bildredaktör" "bildredaktörer" ; -- bildredaktör..nn.1
  bildreportage_1_N = mkN "bildreportage" "bildreportaget" "bildreportage" "bildreportagen" ; -- bildreportage..nn.1
  bildrik_1_A = mkA "bildrik" ; -- bildrik..av.1
  bildrikedom_1_N = mkN "bildrikedom" ; -- bildrikedom..nn.1
  bildrulle_1_N = mkN "bildrulle" utrum  ; -- bildrulle..nn.1
  bildrulle_2_1_N = mkN "bildrulle" utrum  ; -- bildrulle_2..nn.1
  bildruta_1_N = mkN "bildruta" ; -- bildruta..nn.1
  bildrör_1_N = mkN "bildrör" neutrum  ; -- bildrör..nn.1
  bildsida_1_N = mkN "bildsida" ; -- bildsida..nn.1
  bildsignal_1_N = mkN "bildsignal" "bildsignaler" ; -- bildsignal..nn.1
  bildskrift_1_N = mkN "bildskrift" "bildskrifter" ; -- bildskrift..nn.1
  bildskärm_1_N = mkN "bildskärm" ; -- bildskärm..nn.1
  bildskärpa_1_N = mkN "bildskärpa" ; -- bildskärpa..nn.1
  bildskön_1_A = mkA "bildskön" ; -- bildskön..av.1
  bildskönhet_1_N = mkN "bildskönhet" ; -- bildskönhet..nn.1
  bildsnidare_1_N = mkN "bildsnidare" utrum  ; -- bildsnidare..nn.1
  bildsnideri_1_N = mkN "bildsnideri" "bildsnideriet" "bildsniderier" "bildsniderierna" ; -- bildsnideri..nn.1
  bildspel_1_N = mkN "bildspel" "bildspelet" "bildspel" "bildspelen" ; -- bildspel..nn.1
  bildspråk_1_N = mkN "bildspråk" neutrum  ; -- bildspråk..nn.1
  bildsten_1_N = mkN "bildsten" "bildstenen" "bildstenar" "bildstenarna" ; -- bildsten..nn.1
  bildstod_1_N = mkN "bildstod" "bildstoder" ; -- bildstod..nn.1
  bildstormare_1_N = mkN "bildstormare" utrum  ; -- bildstormare..nn.1
  bildstrid_1_N = mkN "bildstrid" "bildstrider" ; -- bildstrid..nn.1
  bildsvit_1_N = mkN "bildsvit" "bildsviter" ; -- bildsvit..nn.1
  bildtelefon_1_N = mkN "bildtelefon" "bildtelefoner" ; -- bildtelefon..nn.1
  bildtelegrafi_1_N = mkN "bildtelegrafi" ; -- bildtelegrafi..nn.1
  bildtext_1_N = mkN "bildtext" "bildtexter" ; -- bildtext..nn.1
  bildtolkning_1_N = mkN "bildtolkning" ; -- bildtolkning..nn.1
  bildverk_1_N = mkN "bildverk" neutrum  ; -- bildverk..nn.1
  bildvävnad_1_N = mkN "bildvävnad" "bildvävnader" ; -- bildvävnad..nn.1
  bildäck_1_N = mkN "bildäck" neutrum  ; -- bildäck..nn.1
  bildöverföring_1_N = mkN "bildöverföring" ; -- bildöverföring..nn.1
  bilfabrik_1_N = mkN "bilfabrik" "bilfabriker" ; -- bilfabrik..nn.1
  bilfabrikör_1_N = mkN "bilfabrikör" "bilfabrikörer" ; -- bilfabrikör..nn.1
  bilfri_1_A = mkA "bilfri" "bilfritt" ; -- bilfri..av.1
  bilfärd_1_N = mkN "bilfärd" "bilfärder" ; -- bilfärd..nn.1
  bilfärja_1_N = mkN "bilfärja" ; -- bilfärja..nn.1
  bilfönster_1_N = mkN "bilfönster" neutrum  ; -- bilfönster..nn.1
  bilförare_1_N = mkN "bilförare" utrum  ; -- bilförare..nn.1
  bilförsäkring_1_N = mkN "bilförsäkring" ; -- bilförsäkring..nn.1
  bilförsäljare_1_N = mkN "bilförsäljare" utrum  ; -- bilförsäljare..nn.1
  bilgolv_1_N = mkN "bilgolv" neutrum  ; -- bilgolv..nn.1
  bilhammare_1_N = mkN "bilhammare" "bilhammaren" "bilhammare" "bilhamrarna" ; -- bilhammare..nn.1
  bilhjul_1_N = mkN "bilhjul" neutrum  ; -- bilhjul..nn.1
  bilhögtalare_1_N = mkN "bilhögtalare" utrum  ; -- bilhögtalare..nn.1
  bilindustri_1_N = mkN "bilindustri" "bilindustrier" ; -- bilindustri..nn.1
  bilingual_1_A = mkA "bilingual" ; -- bilingual..av.1
  bilingualism_1_N = mkN "bilingualism" "bilingualismer" ; -- bilingualism..nn.1
  bilism_1_N = mkN "bilism" "bilismer" ; -- bilism..nn.1
  bilist_1_N = mkN "bilist" "bilister" ; -- bilist..nn.1
  bilistisk_1_A = mkA "bilistisk" ; -- bilistisk..av.1
  biljard_1_N = mkN "biljard" "biljarder" ; -- biljard..nn.1
  biljardboll_1_N = mkN "biljardboll" ; -- biljardboll..nn.1
  biljardbollsuniversum_1_N = mkN "biljardbollsuniversum" neutrum  ; -- biljardbollsuniversum..nn.1
  biljardbord_1_N = mkN "biljardbord" neutrum  ; -- biljardbord..nn.1
  biljardkäpp_1_N = mkN "biljardkäpp" ; -- biljardkäpp..nn.1
  biljardkö_1_N = mkN "biljardkö" "biljardkön" "biljardköer" "biljardköerna" ; -- biljardkö..nn.1
  biljardsalong_1_N = mkN "biljardsalong" "biljardsalonger" ; -- biljardsalong..nn.1
  biljardspel_1_N = mkN "biljardspel" "biljardspelet" "biljardspel" "biljardspelen" ; -- biljardspel..nn.1
  biljett_1_N = mkN "biljett" "biljetter" ; -- biljett..nn.1
  biljettautomat_1_N = mkN "biljettautomat" "biljettautomater" ; -- biljettautomat..nn.1
  biljettbok_1_N = mkN "biljettbok" "biljettböcker" ; -- biljettbok..nn.1
  biljettbokning_1_N = mkN "biljettbokning" ; -- biljettbokning..nn.1
  biljettbråk_1_N = mkN "biljettbråk" neutrum  ; -- biljettbråk..nn.1
  biljettexpedition_1_N = mkN "biljettexpedition" ; -- biljettexpedition..nn.1
  biljettficka_1_N = mkN "biljettficka" ; -- biljettficka..nn.1
  biljettförsäljare_1_N = mkN "biljettförsäljare" utrum  ; -- biljettförsäljare..nn.1
  biljettförsäljning_1_N = mkN "biljettförsäljning" ; -- biljettförsäljning..nn.1
  biljetthäfte_1_N = mkN "biljetthäfte" ; -- biljetthäfte..nn.1
  biljetthärva_1_N = mkN "biljetthärva" ; -- biljetthärva..nn.1
  biljettinkomst_1_N = mkN "biljettinkomst" "biljettinkomster" ; -- biljettinkomst..nn.1
  biljettkontor_1_N = mkN "biljettkontor" neutrum  ; -- biljettkontor..nn.1
  biljettkontroll_1_N = mkN "biljettkontroll" "biljettkontroller" ; -- biljettkontroll..nn.1
  biljettköp_1_N = mkN "biljettköp" neutrum  ; -- biljettköp..nn.1
  biljettlucka_1_N = mkN "biljettlucka" ; -- biljettlucka..nn.1
  biljettlös_1_A = mkA "biljettlös" ; -- biljettlös..av.1
  biljettmaskin_1_N = mkN "biljettmaskin" "biljettmaskiner" ; -- biljettmaskin..nn.1
  biljettpris_1_N = mkN "biljettpris" neutrum  ; -- biljettpris..nn.1
  biljettsläpp_1_N = mkN "biljettsläpp" neutrum  ; -- biljettsläpp..nn.1
  biljettvisering_1_N = mkN "biljettvisering" ; -- biljettvisering..nn.1
  biljettång_1_N = mkN "biljettång" "biljettänger" ; -- biljettång..nn.1
  biljon_1_N = mkN "biljon" "biljoner" ; -- biljon..nn.1
  biljonte_1_A = mkA "biljonte" ; -- biljonte..av.1
  biljud_1_N = mkN "biljud" neutrum  ; -- biljud..nn.1
  bilkaross_1_N = mkN "bilkaross" "bilkarosser" ; -- bilkaross..nn.1
  bilkarta_1_N = mkN "bilkarta" ; -- bilkarta..nn.1
  bilklädsel_1_N = mkN "bilklädsel" ; -- bilklädsel..nn.1
  bilkonstruktör_1_N = mkN "bilkonstruktör" "bilkonstruktörer" ; -- bilkonstruktör..nn.1
  bilkrasch_1_N = mkN "bilkrasch" "bilkrascher" ; -- bilkrasch..nn.1
  bilkrock_1_N = mkN "bilkrock" ; -- bilkrock..nn.1
  bilkupé_1_N = mkN "bilkupé" "bilkupéer" ; -- bilkupé..nn.1
  bilkyrkogård_1_N = mkN "bilkyrkogård" ; -- bilkyrkogård..nn.1
  bilkår_1_N = mkN "bilkår" "bilkårer" ; -- bilkår..nn.1
  bilkårist_1_N = mkN "bilkårist" "bilkårister" ; -- bilkårist..nn.1
  bilkö_1_N = mkN "bilkö" "bilkön" "bilköer" "bilköerna" ; -- bilkö..nn.1
  bilköp_1_N = mkN "bilköp" neutrum  ; -- bilköp..nn.1
  bilkörning_1_N = mkN "bilkörning" ; -- bilkörning..nn.1
  bill_1_N = mkN "bill" ; -- bill..nn.1
  bill_2_N = mkN "bill" ; -- bill..nn.2
  billa_1_N = mkN "billa" ; -- billa..nn.1
  billampa_1_N = mkN "billampa" ; -- billampa..nn.1
  billast_1_N = mkN "billast" "billaster" ; -- billast..nn.1
  billiard_1_N = mkN "billiard" "billiarder" ; -- billiard..nn.1
  billig_1_A = mkA "billig" ; -- billig..av.1
  billighet_1_N = mkN "billighet" "billigheter" ; -- billighet..nn.1
  billighet_2_N = mkN "billighet" ; -- billighet..nn.2
  billighetsupplaga_1_N = mkN "billighetsupplaga" ; -- billighetsupplaga..nn.1
  billion_1_N = mkN "billion" ; -- billion..nn.1
  billionte_1_A = mkA "billionte" ; -- billionte..av.1
  billjus_1_N = mkN "billjus" neutrum  ; -- billjus..nn.1
  billots_1_N = mkN "billots" ; -- billots..nn.1
  billykta_1_N = mkN "billykta" ; -- billykta..nn.1
  billån_1_N = mkN "billån" neutrum  ; -- billån..nn.1
  billås_1_N = mkN "billås" neutrum  ; -- billås..nn.1
  bilmaskin_1_N = mkN "bilmaskin" "bilmaskiner" ; -- bilmaskin..nn.1
  bilmekaniker_1_N = mkN "bilmekaniker" "bilmekanikern" "bilmekaniker" "bilmekanikerna" ; -- bilmekaniker..nn.1
  bilmotor_1_N = mkN "bilmotor" "bilmotorer" ; -- bilmotor..nn.1
  bilmärke_1_N = mkN "bilmärke" ; -- bilmärke..nn.1
  bilmålvakt_1_N = mkN "bilmålvakt" "bilmålvakter" ; -- bilmålvakt..nn.1
  bilnavigator_1_N = mkN "bilnavigator" "bilnavigatorer" ; -- bilnavigator..nn.1
  bilning_1_N = mkN "bilning" ; -- bilning..nn.1
  bilnummer_1_N = mkN "bilnummer" neutrum  ; -- bilnummer..nn.1
  bilnyckel_1_N = mkN "bilnyckel" ; -- bilnyckel..nn.1
  bilolycka_1_N = mkN "bilolycka" ; -- bilolycka..nn.1
  bilpark_1_N = mkN "bilpark" "bilparker" ; -- bilpark..nn.1
  bilparkering_1_N = mkN "bilparkering" ; -- bilparkering..nn.1
  bilplåt_1_N = mkN "bilplåt" ; -- bilplåt..nn.1
  bilpool_1_N = mkN "bilpool" "bilpooler" ; -- bilpool..nn.1
  bilprovning_1_N = mkN "bilprovning" ; -- bilprovning..nn.1
  bilradio_1_N = mkN "bilradio" "bilradior" ; -- bilradio..nn.1
  bilradioapparat_1_N = mkN "bilradioapparat" "bilradioapparater" ; -- bilradioapparat..nn.1
  bilrally_1_N = mkN "bilrally" "bilrallyt" "bilrallyn" "bilrallyna" ; -- bilrally..nn.1
  bilratt_1_N = mkN "bilratt" ; -- bilratt..nn.1
  bilregister_1_N = mkN "bilregister" neutrum  ; -- bilregister..nn.1
  bilrengöring_1_N = mkN "bilrengöring" ; -- bilrengöring..nn.1
  bilresa_1_N = mkN "bilresa" ; -- bilresa..nn.1
  bilring_1_N = mkN "bilring" ; -- bilring..nn.1
  bilrock_1_N = mkN "bilrock" ; -- bilrock..nn.1
  bilruta_1_N = mkN "bilruta" ; -- bilruta..nn.1
  bilschampo_1_N = mkN "bilschampo" "bilschampot" "bilschampon" "bilschampona" ; -- bilschampo..nn.1
  bilschamposvamp_1_N = mkN "bilschamposvamp" ; -- bilschamposvamp..nn.1
  bilsjuk_1_A = mkA "bilsjuk" ; -- bilsjuk..av.1
  bilsjuka_1_N = mkN "bilsjuka" ; -- bilsjuka..nn.1
  bilsjukhet_1_N = mkN "bilsjukhet" ; -- bilsjukhet..nn.1
  bilskatt_1_N = mkN "bilskatt" "bilskatter" ; -- bilskatt..nn.1
  bilskojare_1_N = mkN "bilskojare" utrum  ; -- bilskojare..nn.1
  bilskola_1_N = mkN "bilskola" ; -- bilskola..nn.1
  bilskrot_1_N = mkN "bilskrot" ; -- bilskrot..nn.1
  bilskrotning_1_N = mkN "bilskrotning" ; -- bilskrotning..nn.1
  bilskrotningspremie_1_N = mkN "bilskrotningspremie" "bilskrotningspremier" ; -- bilskrotningspremie..nn.1
  bilsläpkärra_1_N = mkN "bilsläpkärra" ; -- bilsläpkärra..nn.1
  bilspackel_1_N = mkN "bilspackel" neutrum  ; -- bilspackel..nn.1
  bilstol_1_N = mkN "bilstol" ; -- bilstol..nn.1
  bilstöld_1_N = mkN "bilstöld" "bilstölder" ; -- bilstöld..nn.1
  bilsäte_1_N = mkN "bilsäte" ; -- bilsäte..nn.1
  biltak_1_N = mkN "biltak" neutrum  ; -- biltak..nn.1
  biltelefon_1_N = mkN "biltelefon" "biltelefoner" ; -- biltelefon..nn.1
  biltillverkare_1_N = mkN "biltillverkare" utrum  ; -- biltillverkare..nn.1
  biltillverkning_1_N = mkN "biltillverkning" ; -- biltillverkning..nn.1
  biltjuv_1_N = mkN "biltjuv" ; -- biltjuv..nn.1
  biltog_1_A = mkA "biltog" ; -- biltog..av.1
  biltoghet_1_N = mkN "biltoghet" ; -- biltoghet..nn.1
  biltrafik_1_N = mkN "biltrafik" ; -- biltrafik..nn.1
  biltull_1_N = mkN "biltull" ; -- biltull..nn.1
  biltunnel_1_N = mkN "biltunnel" ; -- biltunnel..nn.1
  biltur_1_N = mkN "biltur" "bilturer" ; -- biltur..nn.1
  biltvätt_1_N = mkN "biltvätt" ; -- biltvätt..nn.1
  biltvättborste_1_N = mkN "biltvättborste" utrum  ; -- biltvättborste..nn.1
  biltävling_1_N = mkN "biltävling" ; -- biltävling..nn.1
  bilvax_1_N = mkN "bilvax" "bilvaxet" "bilvaxer" "bilvaxerna" ; -- bilvax..nn.1
  bilverkstad_1_N = mkN "bilverkstad" "bilverkstäder" ; -- bilverkstad..nn.1
  bilvrak_1_N = mkN "bilvrak" neutrum  ; -- bilvrak..nn.1
  bilväg_1_N = mkN "bilväg" ; -- bilväg..nn.1
  bilyxa_1_N = mkN "bilyxa" ; -- bilyxa..nn.1
  bilägare_1_N = mkN "bilägare" utrum  ; -- bilägare..nn.1
  biläger_1_N = mkN "biläger" neutrum  ; -- biläger..nn.1
  bilägga_1_V = mkV "bilägga" "bila" "bilagt" ; -- bilägga..vb.1
  biläggande_1_N = mkN "biläggande" ; -- biläggande..nn.1
  biläggning_1_N = mkN "biläggning" ; -- biläggning..nn.1
  bilåkning_1_N = mkN "bilåkning" ; -- bilåkning..nn.1
  bimbo_1_N = mkN "bimbo" "bimbot" "bimbo" "bimbon" ; -- bimbo..nn.1
  bimbofilm_1_N = mkN "bimbofilm" "bimbofilmer" ; -- bimbofilm..nn.1
  bimetall_1_N = mkN "bimetall" "bimetaller" ; -- bimetall..nn.1
  bimetallism_1_N = mkN "bimetallism" "bimetallismer" ; -- bimetallism..nn.1
  bimåne_1_N = mkN "bimåne" utrum  ; -- bimåne..nn.1
  binamn_1_N = mkN "binamn" neutrum  ; -- binamn..nn.1
  bind_1_N = mkN "bind" neutrum  ; -- bind..nn.1
  binda_1_N = mkN "binda" ; -- binda..nn.1
  binda_1_V = mkV "binda" "band" "bundit" ; -- binda..vb.1
  bindande_1_A = mkA "bindande" ; -- bindande..av.1
  bindande_1_N = mkN "bindande" ; -- bindande..nn.1
  bindare_1_N = mkN "bindare" utrum  ; -- bindare..nn.1
  bindbjälke_1_N = mkN "bindbjälke" utrum  ; -- bindbjälke..nn.1
  bindehinna_1_N = mkN "bindehinna" ; -- bindehinna..nn.1
  bindehinneinflammation_1_N = mkN "bindehinneinflammation" ; -- bindehinneinflammation..nn.1
  bindel_1_N = mkN "bindel" ; -- bindel..nn.1
  bindemedel_1_N = mkN "bindemedel" neutrum  ; -- bindemedel..nn.1
  bindenyckel_1_N = mkN "bindenyckel" ; -- bindenyckel..nn.1
  bindeord_1_N = mkN "bindeord" neutrum  ; -- bindeord..nn.1
  binderi_1_N = mkN "binderi" "binderiet" "binderier" "binderierna" ; -- binderi..nn.1
  bindestreck_1_N = mkN "bindestreck" neutrum  ; -- bindestreck..nn.1
  bindesubstans_1_N = mkN "bindesubstans" "bindesubstanser" ; -- bindesubstans..nn.1
  bindesäck_1_N = mkN "bindesäck" ; -- bindesäck..nn.1
  bindevokal_1_N = mkN "bindevokal" "bindevokaler" ; -- bindevokal..nn.1
  bindgalen_1_A = mkA "bindgalen" ; -- bindgalen..av.1
  bindgalenhet_1_N = mkN "bindgalenhet" ; -- bindgalenhet..nn.1
  bindgarn_1_N = mkN "bindgarn" neutrum  ; -- bindgarn..nn.1
  bindning_1_N = mkN "bindning" ; -- bindning..nn.1
  bindningstid_1_N = mkN "bindningstid" "bindningstider" ; -- bindningstid..nn.1
  bindnål_1_N = mkN "bindnål" ; -- bindnål..nn.1
  bindsel_1_N = mkN "bindsel" neutrum  ; -- bindsel..nn.1
  bindsle_1_N = mkN "bindsle" ; -- bindsle..nn.1
  bindsten_1_N = mkN "bindsten" "bindstenen" "bindstenar" "bindstenarna" ; -- bindsten..nn.1
  bindsula_1_N = mkN "bindsula" ; -- bindsula..nn.1
  bindtråd_1_N = mkN "bindtråd" ; -- bindtråd..nn.1
  bindväv_1_N = mkN "bindväv" ; -- bindväv..nn.1
  bindvävsfiber_1_N = mkN "bindvävsfiber" "bindvävsfibern" "bindvävsfibrer" "bindvävsfibrerna" ; -- bindvävsfiber..nn.1
  bindvävshinna_1_N = mkN "bindvävshinna" ; -- bindvävshinna..nn.1
  bindvävskapsel_1_N = mkN "bindvävskapsel" ; -- bindvävskapsel..nn.1
  bindvävssjukdom_1_N = mkN "bindvävssjukdom" ; -- bindvävssjukdom..nn.1
  bindvävssäck_1_N = mkN "bindvävssäck" ; -- bindvävssäck..nn.1
  bindvävstråd_1_N = mkN "bindvävstråd" ; -- bindvävstråd..nn.1
  bindämne_1_N = mkN "bindämne" ; -- bindämne..nn.1
  binga_1_N = mkN "binga" ; -- binga..nn.1
  binge_1_N = mkN "binge" utrum  ; -- binge..nn.1
  bingel_1_N = mkN "bingel" ; -- bingel..nn.1
  bingo_1_N = mkN "bingo" ; -- bingo..nn.1
  bingobricka_1_N = mkN "bingobricka" ; -- bingobricka..nn.1
  bingosugen_1_A = mkA "bingosugen" ; -- bingosugen..av.1
  bingosugenhet_1_N = mkN "bingosugenhet" ; -- bingosugenhet..nn.1
  binjure_1_N = mkN "binjure" utrum  ; -- binjure..nn.1
  binjurebark_1_N = mkN "binjurebark" ; -- binjurebark..nn.1
  binka_1_N = mkN "binka" ; -- binka..nn.1
  binnikemask_1_N = mkN "binnikemask" ; -- binnikemask..nn.1
  binokel_1_N = mkN "binokel" ; -- binokel..nn.1
  binokulär_1_A = mkA "binokulär" ; -- binokulär..av.1
  binom_1_N = mkN "binom" neutrum  ; -- binom..nn.1
  binomial_1_A = mkA "binomial" ; -- binomial..av.1
  binär_1_A = mkA "binär" ; -- binär..av.1
  binäring_1_N = mkN "binäring" ; -- binäring..nn.1
  bio_1_N = mkN "bio" ; -- bio..nn.1
  bioaktuell_1_A = mkA "bioaktuell" ; -- bioaktuell..av.1
  biobank_1_N = mkN "biobank" "biobanker" ; -- biobank..nn.1
  biobankning_1_N = mkN "biobankning" ; -- biobankning..nn.1
  biobesök_1_N = mkN "biobesök" neutrum  ; -- biobesök..nn.1
  biobiljett_1_N = mkN "biobiljett" "biobiljetter" ; -- biobiljett..nn.1
  biobränsle_1_N = mkN "biobränsle" ; -- biobränsle..nn.1
  biocid_1_N = mkN "biocid" "biocider" ; -- biocid..nn.1
  biodlare_1_N = mkN "biodlare" utrum  ; -- biodlare..nn.1
  biodling_1_N = mkN "biodling" ; -- biodling..nn.1
  biodrivmedel_1_N = mkN "biodrivmedel" neutrum  ; -- biodrivmedel..nn.1
  bioduk_1_N = mkN "bioduk" ; -- bioduk..nn.1
  biodynamik_1_N = mkN "biodynamik" ; -- biodynamik..nn.1
  biodynamisk_1_A = mkA "biodynamisk" ; -- biodynamisk..av.1
  biofilm_1_N = mkN "biofilm" "biofilmer" ; -- biofilm..nn.1
  biofysik_1_N = mkN "biofysik" ; -- biofysik..nn.1
  biofysisk_1_A = mkA "biofysisk" ; -- biofysisk..av.1
  bioföreställning_1_N = mkN "bioföreställning" ; -- bioföreställning..nn.1
  biogas_1_N = mkN "biogas" "biogaser" ; -- biogas..nn.1
  biogasanläggning_1_N = mkN "biogasanläggning" ; -- biogasanläggning..nn.1
  biogasdriven_1_A = mkA "biogasdriven" ; -- biogasdriven..av.1
  biogasproduktion_1_N = mkN "biogasproduktion" ; -- biogasproduktion..nn.1
  biogasrening_1_N = mkN "biogasrening" ; -- biogasrening..nn.1
  biogen_1_A = mkA "biogen" "biogent" ; -- biogen..av.1
  biogenes_1_N = mkN "biogenes" ; -- biogenes..nn.1
  biogenetisk_1_A = mkA "biogenetisk" ; -- biogenetisk..av.1
  biogeografi_1_N = mkN "biogeografi" ; -- biogeografi..nn.1
  biograf_1_N = mkN "biograf" "biografer" ; -- biograf..nn.1
  biografbyrå_1_N = mkN "biografbyrå" "biografbyråer" ; -- biografbyrå..nn.1
  biografera_1_V = mkV "biograferar" ; -- biografera..vb.1
  biograferande_1_N = mkN "biograferande" ; -- biograferande..nn.1
  biograferbar_1_A = mkA "biograferbar" ; -- biograferbar..av.1
  biograferbarhet_1_N = mkN "biograferbarhet" ; -- biograferbarhet..nn.1
  biografering_1_N = mkN "biografering" ; -- biografering..nn.1
  biografföreståndare_1_N = mkN "biografföreståndare" utrum  ; -- biografföreståndare..nn.1
  biografi_1_N = mkN "biografi" "biografier" ; -- biografi..nn.1
  biografisk_1_A = mkA "biografisk" ; -- biografisk..av.1
  biografmässig_1_A = mkA "biografmässig" ; -- biografmässig..av.1
  biograforgel_1_N = mkN "biograforgel" ; -- biograforgel..nn.1
  biografpublik_1_N = mkN "biografpublik" ; -- biografpublik..nn.1
  biografteater_1_N = mkN "biografteater" ; -- biografteater..nn.1
  biokemi_1_N = mkN "biokemi" ; -- biokemi..nn.1
  biokemisk_1_A = mkA "biokemisk" ; -- biokemisk..av.1
  biokemist_1_N = mkN "biokemist" "biokemister" ; -- biokemist..nn.1
  bioklimatologi_1_N = mkN "bioklimatologi" ; -- bioklimatologi..nn.1
  biokronologi_1_N = mkN "biokronologi" ; -- biokronologi..nn.1
  biolog_1_N = mkN "biolog" "biologer" ; -- biolog..nn.1
  biologi_1_N = mkN "biologi" ; -- biologi..nn.1
  biologibok_1_N = mkN "biologibok" "biologiböcker" ; -- biologibok..nn.1
  biologisk_1_A = mkA "biologisk" ; -- biologisk..av.1
  biomassa_1_N = mkN "biomassa" ; -- biomassa..nn.1
  biomedicin_1_N = mkN "biomedicin" ; -- biomedicin..nn.1
  biomedicinsk_1_A = mkA "biomedicinsk" ; -- biomedicinsk..av.1
  biometri_1_N = mkN "biometri" ; -- biometri..nn.1
  biometrisk_1_A = mkA "biometrisk" ; -- biometrisk..av.1
  biomständighet_1_N = mkN "biomständighet" "biomständigheter" ; -- biomständighet..nn.1
  biopremiär_1_N = mkN "biopremiär" "biopremiärer" ; -- biopremiär..nn.1
  bioreaktor_1_N = mkN "bioreaktor" "bioreaktorer" ; -- bioreaktor..nn.1
  biorytm_1_N = mkN "biorytm" ; -- biorytm..nn.1
  biosalong_1_N = mkN "biosalong" "biosalonger" ; -- biosalong..nn.1
  biosfär_1_N = mkN "biosfär" "biosfärer" ; -- biosfär..nn.1
  bioteknik_1_N = mkN "bioteknik" "biotekniker" ; -- bioteknik..nn.1
  bioteknisk_1_A = mkA "bioteknisk" ; -- bioteknisk..av.1
  bioteknologisk_1_A = mkA "bioteknologisk" ; -- bioteknologisk..av.1
  biotisk_1_A = mkA "biotisk" ; -- biotisk..av.1
  biotop_1_N = mkN "biotop" "biotoper" ; -- biotop..nn.1
  biotyp_1_N = mkN "biotyp" "biotyper" ; -- biotyp..nn.1
  biperson_1_N = mkN "biperson" "bipersoner" ; -- biperson..nn.1
  biplan_1_N = mkN "biplan" neutrum  ; -- biplan..nn.1
  biplanet_1_N = mkN "biplanet" "biplaneter" ; -- biplanet..nn.1
  bipolaritet_1_N = mkN "bipolaritet" "bipolariteter" ; -- bipolaritet..nn.1
  bipolär_1_A = mkA "bipolär" ; -- bipolär..av.1
  biprodukt_1_N = mkN "biprodukt" "biprodukter" ; -- biprodukt..nn.1
  bir_1_N = mkN "bir" neutrum  ; -- bir..nn.1
  bira_1_N = mkN "bira" ; -- bira..nn.1
  birdie_1_N = mkN "birdie" "birdien" "birdies" "birdiesarna" ; -- birdie..nn.1
  birem_1_N = mkN "birem" "biremer" ; -- birem..nn.1
  birfilare_1_N = mkN "birfilare" utrum  ; -- birfilare..nn.1
  biroll_1_N = mkN "biroll" "biroller" ; -- biroll..nn.1
  birot_1_N = mkN "birot" "birötter" ; -- birot..nn.1
  bisak_1_N = mkN "bisak" "bisaker" ; -- bisak..nn.1
  bisam_1_N = mkN "bisam" ; -- bisam..nn.1
  bisamhälle_1_N = mkN "bisamhälle" ; -- bisamhälle..nn.1
  bisamoxe_1_N = mkN "bisamoxe" utrum  ; -- bisamoxe..nn.1
  bisamråtta_1_N = mkN "bisamråtta" ; -- bisamråtta..nn.1
  bisamsvin_1_N = mkN "bisamsvin" neutrum  ; -- bisamsvin..nn.1
  bisarr_1_A = mkA "bisarr" ; -- bisarr..av.1
  bisarreri_1_N = mkN "bisarreri" "bisarreriet" "bisarrerier" "bisarrerierna" ; -- bisarreri..nn.1
  bisarrhet_1_N = mkN "bisarrhet" ; -- bisarrhet..nn.1
  bisats_1_N = mkN "bisats" "bisatser" ; -- bisats..nn.1
  bisatsordföljd_1_N = mkN "bisatsordföljd" "bisatsordföljder" ; -- bisatsordföljd..nn.1
  bischoff_1_N = mkN "bischoff" ; -- bischoff..nn.1
  bisektris_1_N = mkN "bisektris" "bisektriser" ; -- bisektris..nn.1
  bisexualitet_1_N = mkN "bisexualitet" "bisexualiteter" ; -- bisexualitet..nn.1
  bisexuell_1_A = mkA "bisexuell" ; -- bisexuell..av.1
  bisfenol_1_N = mkN "bisfenol" "bisfenoler" ; -- bisfenol..nn.1
  bisittare_1_N = mkN "bisittare" utrum  ; -- bisittare..nn.1
  biskop_1_N = mkN "biskop" ; -- biskop..nn.1
  biskoplig_1_A = mkA "biskoplig" ; -- biskoplig..av.1
  biskoplighet_1_N = mkN "biskoplighet" ; -- biskoplighet..nn.1
  biskopsdöme_1_N = mkN "biskopsdöme" ; -- biskopsdöme..nn.1
  biskopskors_1_N = mkN "biskopskors" neutrum  ; -- biskopskors..nn.1
  biskopskräckla_1_N = mkN "biskopskräckla" ; -- biskopskräckla..nn.1
  biskopskräkla_1_N = mkN "biskopskräkla" ; -- biskopskräkla..nn.1
  biskopsmössa_1_N = mkN "biskopsmössa" ; -- biskopsmössa..nn.1
  biskopsmöte_1_N = mkN "biskopsmöte" ; -- biskopsmöte..nn.1
  biskopsskrud_1_N = mkN "biskopsskrud" ; -- biskopsskrud..nn.1
  biskopsstav_1_N = mkN "biskopsstav" ; -- biskopsstav..nn.1
  biskopsstift_1_N = mkN "biskopsstift" neutrum  ; -- biskopsstift..nn.1
  biskopsstol_1_N = mkN "biskopsstol" ; -- biskopsstol..nn.1
  biskopssäte_1_N = mkN "biskopssäte" ; -- biskopssäte..nn.1
  biskopsval_1_N = mkN "biskopsval" neutrum  ; -- biskopsval..nn.1
  biskopsvisitation_1_N = mkN "biskopsvisitation" ; -- biskopsvisitation..nn.1
  biskvi_1_N = mkN "biskvi" "biskvier" ; -- biskvi..nn.1
  bisköldkörtel_1_N = mkN "bisköldkörtel" ; -- bisköldkörtel..nn.1
  biskötsel_1_N = mkN "biskötsel" ; -- biskötsel..nn.1
  bismak_1_N = mkN "bismak" "bismaker" ; -- bismak..nn.1
  bisol_1_N = mkN "bisol" ; -- bisol..nn.1
  bison_1_N = mkN "bison" ; -- bison..nn.1
  bisonoxe_1_N = mkN "bisonoxe" utrum  ; -- bisonoxe..nn.1
  bisp_1_N = mkN "bisp" ; -- bisp..nn.1
  bispringa_1_V = mkV "bispringa" "bisprang" "bisprungit" ; -- bispringa..vb.1
  bispringande_1_N = mkN "bispringande" ; -- bispringande..nn.1
  bissauguinean_1_N = mkN "bissauguinean" "bissauguineaner" ; -- bissauguinean..nn.1
  bissauguineansk_1_A = mkA "bissauguineansk" ; -- bissauguineansk..av.1
  bissauguineanska_1_N = mkN "bissauguineanska" ; -- bissauguineanska..nn.1
  bissera_1_V = mkV "bisserar" ; -- bissera..vb.1
  bisserande_1_N = mkN "bisserande" ; -- bisserande..nn.1
  bisserbar_1_A = mkA "bisserbar" ; -- bisserbar..av.1
  bisserbarhet_1_N = mkN "bisserbarhet" ; -- bisserbarhet..nn.1
  bissering_1_N = mkN "bissering" ; -- bissering..nn.1
  bister_1_A = mkA "bister" ; -- bister..av.1
  bister_1_N = mkN "bister" neutrum  ; -- bister..nn.1
  bisterhet_1_N = mkN "bisterhet" ; -- bisterhet..nn.1
  bistick_1_N = mkN "bistick" neutrum  ; -- bistick..nn.1
  bisting_1_N = mkN "bisting" neutrum  ; -- bisting..nn.1
  bistock_1_N = mkN "bistock" ; -- bistock..nn.1
  bistro_1_N = mkN "bistro" "bistron" "bistroer" "bistroerna" ; -- bistro..nn.1
  bisträcka_1_V = mkV "bisträcker" ; -- bisträcka..vb.1
  bisträckande_1_N = mkN "bisträckande" ; -- bisträckande..nn.1
  bisturi_1_N = mkN "bisturi" "bisturier" ; -- bisturi..nn.1
  bistyng_1_N = mkN "bistyng" neutrum  ; -- bistyng..nn.1
  bistå_1_V = mkV "bistå" "bistod" "bistått" ; -- bistå..vb.1
  bistående_1_N = mkN "bistående" ; -- bistående..nn.1
  bistånd_1_N = mkN "bistånd" neutrum  ; -- bistånd..nn.1
  biståndsförvaltning_1_N = mkN "biståndsförvaltning" ; -- biståndsförvaltning..nn.1
  biståndsland_1_N = mkN "biståndsland" "biståndslandet" "biståndsländer" "biståndsländerna" ; -- biståndsland..nn.1
  biståndsminister_1_N = mkN "biståndsminister" ; -- biståndsminister..nn.1
  biståndsmål_1_N = mkN "biståndsmål" neutrum  ; -- biståndsmål..nn.1
  biståndsorgan_1_N = mkN "biståndsorgan" neutrum  ; -- biståndsorgan..nn.1
  biståndspolitik_1_N = mkN "biståndspolitik" ; -- biståndspolitik..nn.1
  biståndspolitisk_1_A = mkA "biståndspolitisk" ; -- biståndspolitisk..av.1
  biståndsprogram_1_N = mkN "biståndsprogram" "biståndsprogrammet" "biståndsprogram" "biståndsprogrammen" ; -- biståndsprogram..nn.1
  biståndsprojekt_1_N = mkN "biståndsprojekt" neutrum  ; -- biståndsprojekt..nn.1
  biståndsskepp_1_N = mkN "biståndsskepp" neutrum  ; -- biståndsskepp..nn.1
  bisvärm_1_N = mkN "bisvärm" ; -- bisvärm..nn.1
  bisyssla_1_N = mkN "bisyssla" ; -- bisyssla..nn.1
  bisätta_1_V = mkV "bisätta" "bisätter" "bisätt" "bisatte" "bisatt" "bisatt" ; -- bisätta..vb.1
  bisättande_1_N = mkN "bisättande" ; -- bisättande..nn.1
  bisättning_1_N = mkN "bisättning" ; -- bisättning..nn.1
  bit_1_N = mkN "bit" ; -- bit..nn.1
  bit_2_N = mkN "bit" ; -- bit..nn.2
  bita_1_V = mkV "bita" "bet" "bitit" ; -- bita..vb.1
  bita_2_V = mkV "bitar" ; -- bita..vb.2
  bitande_1_A = mkA "bitande" ; -- bitande..av.1
  bitande_1_N = mkN "bitande" ; -- bitande..nn.1
  bitanke_1_N = mkN "bitanke" utrum  ; -- bitanke..nn.1
  bitch_1_N = mkN "bitch" ; -- bitch..nn.1
  bitchig_1_A = mkA "bitchig" ; -- bitchig..av.1
  bitecken_1_N = mkN "bitecken" "bitecknet" "bitecken" "bitecknen" ; -- bitecken..nn.1
  biten_1_A = mkA "biten" ; -- biten..av.1
  bitestikel_1_N = mkN "bitestikel" ; -- bitestikel..nn.1
  bitmärke_1_N = mkN "bitmärke" ; -- bitmärke..nn.1
  biton_1_N = mkN "biton" "bitoner" ; -- biton..nn.1
  bitryck_1_N = mkN "bitryck" neutrum  ; -- bitryck..nn.1
  biträda_1_V = mkV "biträda" "biträdde" "biträtt" ; -- biträda..vb.1
  biträdande_1_A = mkA "biträdande" ; -- biträdande..av.1
  biträdande_1_N = mkN "biträdande" ; -- biträdande..nn.1
  biträde_1_N = mkN "biträde" ; -- biträde..nn.1
  bits_1_N = mkN "bits" neutrum  ; -- bits..nn.1
  bitshållare_1_N = mkN "bitshållare" utrum  ; -- bitshållare..nn.1
  bitsk_1_A = mkA "bitsk" ; -- bitsk..av.1
  bitskhet_1_N = mkN "bitskhet" ; -- bitskhet..nn.1
  bitsocker_1_N = mkN "bitsocker" neutrum  ; -- bitsocker..nn.1
  bitsår_1_N = mkN "bitsår" neutrum  ; -- bitsår..nn.1
  bittelitenhet_1_N = mkN "bittelitenhet" ; -- bittelitenhet..nn.1
  bitter_1_A = mkA "bitter" ; -- bitter..av.1
  bitterhet_1_N = mkN "bitterhet" "bitterheter" ; -- bitterhet..nn.1
  bitterkall_1_A = mkA "bitterkall" ; -- bitterkall..av.1
  bitterligen_1_Adv = mkAdv "bitterligen" ; -- bitterligen..ab.1
  bitterljuv_1_A = mkA "bitterljuv" ; -- bitterljuv..av.1
  bitterljuvhet_1_N = mkN "bitterljuvhet" ; -- bitterljuvhet..nn.1
  bittermandel_1_N = mkN "bittermandel" ; -- bittermandel..nn.1
  bittermandelolja_1_N = mkN "bittermandelolja" ; -- bittermandelolja..nn.1
  bittersalt_1_A = mkA "bittersalt" "bittersalt" ; -- bittersalt..av.1
  bittersalt_1_N = mkN "bittersalt" neutrum  ; -- bittersalt..nn.1
  bittersta_1_A = mkA "bittersta" ; -- bittersta..av.1
  bittersöt_1_A = mkA "bittersöt" ; -- bittersöt..av.1
  bittersöta_1_N = mkN "bittersöta" ; -- bittersöta..nn.1
  bituminös_1_A = mkA "bituminös" ; -- bituminös..av.1
  bitvarg_1_N = mkN "bitvarg" ; -- bitvarg..nn.1
  bitvis_1_Adv = mkAdv "bitvis" ; -- bitvis..ab.1
  bivack_1_N = mkN "bivack" "bivacker" ; -- bivack..nn.1
  bivackera_1_V = mkV "bivackerar" ; -- bivackera..vb.1
  bivackerande_1_N = mkN "bivackerande" ; -- bivackerande..nn.1
  bivackerbar_1_A = mkA "bivackerbar" ; -- bivackerbar..av.1
  bivackerbarhet_1_N = mkN "bivackerbarhet" ; -- bivackerbarhet..nn.1
  bivackering_1_N = mkN "bivackering" ; -- bivackering..nn.1
  bivax_1_N = mkN "bivax" neutrum  ; -- bivax..nn.1
  biverkning_1_N = mkN "biverkning" ; -- biverkning..nn.1
  biverkningsfall_1_N = mkN "biverkningsfall" neutrum  ; -- biverkningsfall..nn.1
  biverkningsrapport_1_N = mkN "biverkningsrapport" "biverkningsrapporter" ; -- biverkningsrapport..nn.1
  bivråk_1_N = mkN "bivråk" ; -- bivråk..nn.1
  biväg_1_N = mkN "biväg" ; -- biväg..nn.1
  biyngel_1_N = mkN "biyngel" neutrum  ; -- biyngel..nn.1
  biämne_1_N = mkN "biämne" ; -- biämne..nn.1
  biätare_1_N = mkN "biätare" utrum  ; -- biätare..nn.1
  bjuda_1_V = mkV "bjuda" "bjöd" "bjudit" ; -- bjuda..vb.1
  bjudande_1_N = mkN "bjudande" ; -- bjudande..nn.1
  bjudcigarr_1_N = mkN "bjudcigarr" "bjudcigarrer" ; -- bjudcigarr..nn.1
  bjudning_1_N = mkN "bjudning" ; -- bjudning..nn.1
  bjugg_1_N = mkN "bjugg" ; -- bjugg..nn.1
  bjussa_1_V = mkV "bjussar" ; -- bjussa..vb.1
  bjussande_1_N = mkN "bjussande" ; -- bjussande..nn.1
  bjäbb_1_N = mkN "bjäbb" neutrum  ; -- bjäbb..nn.1
  bjäbba_1_V = mkV "bjäbbar" ; -- bjäbba..vb.1
  bjäbbande_1_N = mkN "bjäbbande" ; -- bjäbbande..nn.1
  bjäbbig_1_A = mkA "bjäbbig" ; -- bjäbbig..av.1
  bjäbbighet_1_N = mkN "bjäbbighet" "bjäbbigheter" ; -- bjäbbighet..nn.1
  bjäfs_1_N = mkN "bjäfs" neutrum  ; -- bjäfs..nn.1
  bjälke_1_N = mkN "bjälke" utrum  ; -- bjälke..nn.1
  bjälkhuvud_1_N = mkN "bjälkhuvud" "bjälkhuvudet" "bjälkhuvud" "bjälkhuvudena" ; -- bjälkhuvud..nn.1
  bjälklag_1_N = mkN "bjälklag" neutrum  ; -- bjälklag..nn.1
  bjälkverk_1_N = mkN "bjälkverk" neutrum  ; -- bjälkverk..nn.1
  bjällerklang_1_N = mkN "bjällerklang" ; -- bjällerklang..nn.1
  bjällko_1_N = mkN "bjällko" "bjällkor" ; -- bjällko..nn.1
  bjällra_1_N = mkN "bjällra" ; -- bjällra..nn.1
  bjärt_1_A = mkA "bjärt" "bjärt" ; -- bjärt..av.1
  bjärtgrön_1_A = mkA "bjärtgrön" ; -- bjärtgrön..av.1
  bjärthet_1_N = mkN "bjärthet" ; -- bjärthet..nn.1
  bjässe_1_N = mkN "bjässe" utrum  ; -- bjässe..nn.1
  björk_1_N = mkN "björk" ; -- björk..nn.1
  björkblad_1_N = mkN "björkblad" neutrum  ; -- björkblad..nn.1
  björke_1_N = mkN "björke" ; -- björke..nn.1
  björkgren_1_N = mkN "björkgren" "björkgrenen" "björkgrenar" "björkgrenarna" ; -- björkgren..nn.1
  björkgräns_1_N = mkN "björkgräns" ; -- björkgräns..nn.1
  björkhage_1_N = mkN "björkhage" utrum  ; -- björkhage..nn.1
  björklag_1_N = mkN "björklag" ; -- björklag..nn.1
  björklöv_1_N = mkN "björklöv" neutrum  ; -- björklöv..nn.1
  björkna_1_N = mkN "björkna" ; -- björkna..nn.1
  björknäver_1_N = mkN "björknäver" ; -- björknäver..nn.1
  björkpollen_1_N = mkN "björkpollen" neutrum  ; -- björkpollen..nn.1
  björkregion_1_N = mkN "björkregion" ; -- björkregion..nn.1
  björkris_1_N = mkN "björkris" neutrum  ; -- björkris..nn.1
  björksav_1_N = mkN "björksav" ; -- björksav..nn.1
  björkskog_1_N = mkN "björkskog" ; -- björkskog..nn.1
  björksly_1_N = mkN "björksly" neutrum  ; -- björksly..nn.1
  björksopp_1_N = mkN "björksopp" ; -- björksopp..nn.1
  björktrast_1_N = mkN "björktrast" ; -- björktrast..nn.1
  björkved_1_N = mkN "björkved" ; -- björkved..nn.1
  björn_1_N = mkN "björn" ; -- björn..nn.1
  björna_1_V = mkV "björnar" ; -- björna..vb.1
  björnande_1_N = mkN "björnande" ; -- björnande..nn.1
  björnbindsel_1_N = mkN "björnbindsel" neutrum  ; -- björnbindsel..nn.1
  björnbindsle_1_N = mkN "björnbindsle" ; -- björnbindsle..nn.1
  björnbär_1_N = mkN "björnbär" neutrum  ; -- björnbär..nn.1
  björnbärsbuske_1_N = mkN "björnbärsbuske" utrum  ; -- björnbärsbuske..nn.1
  björnfloka_1_N = mkN "björnfloka" ; -- björnfloka..nn.1
  björngrop_1_N = mkN "björngrop" ; -- björngrop..nn.1
  björnhallon_1_N = mkN "björnhallon" neutrum  ; -- björnhallon..nn.1
  björnhona_1_N = mkN "björnhona" ; -- björnhona..nn.1
  björnhund_1_N = mkN "björnhund" ; -- björnhund..nn.1
  björnide_1_N = mkN "björnide" ; -- björnide..nn.1
  björninna_1_N = mkN "björninna" ; -- björninna..nn.1
  björnjakt_1_N = mkN "björnjakt" "björnjakter" ; -- björnjakt..nn.1
  björnliknande_1_A = mkA "björnliknande" ; -- björnliknande..av.1
  björnloka_1_N = mkN "björnloka" ; -- björnloka..nn.1
  björnmossa_1_N = mkN "björnmossa" ; -- björnmossa..nn.1
  björnram_1_N = mkN "björnram" ; -- björnram..nn.1
  björnsax_1_N = mkN "björnsax" ; -- björnsax..nn.1
  björnskall_1_N = mkN "björnskall" neutrum  ; -- björnskall..nn.1
  björnskinn_1_N = mkN "björnskinn" neutrum  ; -- björnskinn..nn.1
  björnskinnsmössa_1_N = mkN "björnskinnsmössa" ; -- björnskinnsmössa..nn.1
  björnskådning_1_N = mkN "björnskådning" ; -- björnskådning..nn.1
  björntjänst_1_N = mkN "björntjänst" "björntjänster" ; -- björntjänst..nn.1
  björntråd_1_N = mkN "björntråd" ; -- björntråd..nn.1
  black_1_A = mkA "black" ; -- black..av.1
  black_1_N = mkN "black" ; -- black..nn.1
  blackhet_1_N = mkN "blackhet" ; -- blackhet..nn.1
  blackig_1_A = mkA "blackig" ; -- blackig..av.1
  blackighet_1_N = mkN "blackighet" ; -- blackighet..nn.1
  blackout_1_N = mkN "blackout" "blackouter" ; -- blackout..nn.1
  blad_1_N = mkN "blad" neutrum  ; -- blad..nn.1
  blada_1_V = mkV "bladar" ; -- blada..vb.1
  bladande_1_N = mkN "bladande" ; -- bladande..nn.1
  bladbagge_1_N = mkN "bladbagge" utrum  ; -- bladbagge..nn.1
  bladbildning_1_N = mkN "bladbildning" ; -- bladbildning..nn.1
  bladbyte_1_N = mkN "bladbyte" ; -- bladbyte..nn.1
  bladder_1_N = mkN "bladder" neutrum  ; -- bladder..nn.1
  bladdra_1_V = mkV "bladdrar" ; -- bladdra..vb.1
  bladdrande_1_N = mkN "bladdrande" ; -- bladdrande..nn.1
  bladfot_1_N = mkN "bladfot" "bladfötter" ; -- bladfot..nn.1
  bladfoting_1_N = mkN "bladfoting" ; -- bladfoting..nn.1
  bladguld_1_N = mkN "bladguld" neutrum  ; -- bladguld..nn.1
  bladig_1_A = mkA "bladig" ; -- bladig..av.1
  bladknopp_1_N = mkN "bladknopp" ; -- bladknopp..nn.1
  bladkrans_1_N = mkN "bladkrans" ; -- bladkrans..nn.1
  bladkål_1_N = mkN "bladkål" ; -- bladkål..nn.1
  bladloppa_1_N = mkN "bladloppa" ; -- bladloppa..nn.1
  bladlus_1_N = mkN "bladlus" "bladlusen" "bladlöss" "bladlössen" ; -- bladlus..nn.1
  bladlängd_1_N = mkN "bladlängd" "bladlängder" ; -- bladlängd..nn.1
  bladmage_1_N = mkN "bladmage" utrum  ; -- bladmage..nn.1
  bladmetall_1_N = mkN "bladmetall" ; -- bladmetall..nn.1
  bladminerare_1_N = mkN "bladminerare" utrum  ; -- bladminerare..nn.1
  bladmossa_1_N = mkN "bladmossa" ; -- bladmossa..nn.1
  bladmögel_1_N = mkN "bladmögel" neutrum  ; -- bladmögel..nn.1
  bladnerv_1_N = mkN "bladnerv" "bladnerver" ; -- bladnerv..nn.1
  bladning_1_N = mkN "bladning" ; -- bladning..nn.1
  bladrik_1_A = mkA "bladrik" ; -- bladrik..av.1
  bladrullsjuka_1_N = mkN "bladrullsjuka" ; -- bladrullsjuka..nn.1
  bladrött_1_N = mkN "bladrött" ; -- bladrött..nn.1
  bladsilver_1_N = mkN "bladsilver" neutrum  ; -- bladsilver..nn.1
  bladskaft_1_N = mkN "bladskaft" neutrum  ; -- bladskaft..nn.1
  bladskärarmyra_1_N = mkN "bladskärarmyra" ; -- bladskärarmyra..nn.1
  bladspänning_1_N = mkN "bladspänning" ; -- bladspänning..nn.1
  bladstekel_1_N = mkN "bladstekel" ; -- bladstekel..nn.1
  bladställning_1_N = mkN "bladställning" ; -- bladställning..nn.1
  bladverk_1_N = mkN "bladverk" neutrum  ; -- bladverk..nn.1
  bladväxt_1_N = mkN "bladväxt" "bladväxter" ; -- bladväxt..nn.1
  blaffa_1_N = mkN "blaffa" ; -- blaffa..nn.1
  blaggarn_1_N = mkN "blaggarn" neutrum  ; -- blaggarn..nn.1
  blaj_1_N = mkN "blaj" neutrum  ; -- blaj..nn.1
  blaja_1_V = mkV "blajar" ; -- blaja..vb.1
  blajande_1_N = mkN "blajande" ; -- blajande..nn.1
  blam_1_N = mkN "blam" "blamer" ; -- blam..nn.1
  blamage_1_N = mkN "blamage" "blamager" ; -- blamage..nn.1
  blamant_1_A = mkA "blamant" "blamant" ; -- blamant..av.1
  blanchera_1_V = mkV "blancherar" ; -- blanchera..vb.1
  blancherande_1_N = mkN "blancherande" ; -- blancherande..nn.1
  blancherbar_1_A = mkA "blancherbar" ; -- blancherbar..av.1
  blancherbarhet_1_N = mkN "blancherbarhet" ; -- blancherbarhet..nn.1
  blanchering_1_N = mkN "blanchering" ; -- blanchering..nn.1
  blancmangé_1_N = mkN "blancmangé" "blancmangéer" ; -- blancmangé..nn.1
  blanda_1_V = mkV "blandar" ; -- blanda..vb.1
  blandad_1_A = mkA "blandad" ; -- blandad..av.1
  blandande_1_N = mkN "blandande" ; -- blandande..nn.1
  blandare_1_N = mkN "blandare" utrum  ; -- blandare..nn.1
  blanddricka_1_N = mkN "blanddricka" ; -- blanddricka..nn.1
  blanddryck_1_N = mkN "blanddryck" ; -- blanddryck..nn.1
  blandekonomi_1_N = mkN "blandekonomi" "blandekonomier" ; -- blandekonomi..nn.1
  blandfoder_1_N = mkN "blandfoder" neutrum  ; -- blandfoder..nn.1
  blandfolk_1_N = mkN "blandfolk" neutrum  ; -- blandfolk..nn.1
  blandform_1_N = mkN "blandform" "blandformer" ; -- blandform..nn.1
  blandfärg_1_N = mkN "blandfärg" "blandfärger" ; -- blandfärg..nn.1
  blandkultur_1_N = mkN "blandkultur" "blandkulturer" ; -- blandkultur..nn.1
  blandning_1_N = mkN "blandning" ; -- blandning..nn.1
  blandningsförhållande_1_N = mkN "blandningsförhållande" ; -- blandningsförhållande..nn.1
  blandningskran_1_N = mkN "blandningskran" ; -- blandningskran..nn.1
  blandras_1_N = mkN "blandras" "blandraser" ; -- blandras..nn.1
  blandrashund_1_N = mkN "blandrashund" ; -- blandrashund..nn.1
  blandskog_1_N = mkN "blandskog" ; -- blandskog..nn.1
  blandspråk_1_N = mkN "blandspråk" neutrum  ; -- blandspråk..nn.1
  blandsäd_1_N = mkN "blandsäd" ; -- blandsäd..nn.1
  blandtyp_1_N = mkN "blandtyp" "blandtyper" ; -- blandtyp..nn.1
  blandvatten_1_N = mkN "blandvatten" "blandvattnet" "blandvatten" "blandvattnen" ; -- blandvatten..nn.1
  blandäktenskap_1_N = mkN "blandäktenskap" neutrum  ; -- blandäktenskap..nn.1
  blank_1_A = mkA "blank" ; -- blank..av.1
  blanka_1_N = mkN "blanka" ; -- blanka..nn.1
  blanka_1_V = mkV "blankar" ; -- blanka..vb.1
  blankande_1_N = mkN "blankande" ; -- blankande..nn.1
  blankborste_1_N = mkN "blankborste" utrum  ; -- blankborste..nn.1
  blankett_1_N = mkN "blankett" "blanketter" ; -- blankett..nn.1
  blankettraseri_1_N = mkN "blankettraseri" neutrum  ; -- blankettraseri..nn.1
  blankettskåp_1_N = mkN "blankettskåp" neutrum  ; -- blankettskåp..nn.1
  blankgalvad_1_A = mkA "blankgalvad" ; -- blankgalvad..av.1
  blankhet_1_N = mkN "blankhet" ; -- blankhet..nn.1
  blankis_1_N = mkN "blankis" ; -- blankis..nn.1
  blanklax_1_N = mkN "blanklax" ; -- blanklax..nn.1
  blankläder_1_N = mkN "blankläder" neutrum  ; -- blankläder..nn.1
  blankning_1_N = mkN "blankning" ; -- blankning..nn.1
  blankningsaffär_1_N = mkN "blankningsaffär" "blankningsaffärer" ; -- blankningsaffär..nn.1
  blankningsförbud_1_N = mkN "blankningsförbud" neutrum  ; -- blankningsförbud..nn.1
  blankoaccept_1_N = mkN "blankoaccept" "blankoaccepter" ; -- blankoaccept..nn.1
  blankocheck_1_N = mkN "blankocheck" ; -- blankocheck..nn.1
  blankofullmakt_1_N = mkN "blankofullmakt" "blankofullmakter" ; -- blankofullmakt..nn.1
  blankoförsäljning_1_N = mkN "blankoförsäljning" ; -- blankoförsäljning..nn.1
  blankokredit_1_N = mkN "blankokredit" "blankokrediter" ; -- blankokredit..nn.1
  blankotransport_1_N = mkN "blankotransport" "blankotransporter" ; -- blankotransport..nn.1
  blankoväxel_1_N = mkN "blankoväxel" ; -- blankoväxel..nn.1
  blankoöverlåtelse_1_N = mkN "blankoöverlåtelse" utrum  ; -- blankoöverlåtelse..nn.1
  blankpolera_1_V = mkV "blankpolerar" ; -- blankpolera..vb.1
  blankpolerande_1_N = mkN "blankpolerande" ; -- blankpolerande..nn.1
  blankpolerbar_1_A = mkA "blankpolerbar" ; -- blankpolerbar..av.1
  blankpolerbarhet_1_N = mkN "blankpolerbarhet" ; -- blankpolerbarhet..nn.1
  blankpolering_1_N = mkN "blankpolering" ; -- blankpolering..nn.1
  blankputsad_1_A = mkA "blankputsad" ; -- blankputsad..av.1
  blankröstare_1_N = mkN "blankröstare" utrum  ; -- blankröstare..nn.1
  blanksej_1_N = mkN "blanksej" ; -- blanksej..nn.1
  blankskinn_1_N = mkN "blankskinn" neutrum  ; -- blankskinn..nn.1
  blankslipa_1_V = mkV "blankslipar" ; -- blankslipa..vb.1
  blankslipande_1_N = mkN "blankslipande" ; -- blankslipande..nn.1
  blankslipning_1_N = mkN "blankslipning" ; -- blankslipning..nn.1
  blanksliten_1_A = mkA "blanksliten" ; -- blanksliten..av.1
  blanksmörja_1_N = mkN "blanksmörja" ; -- blanksmörja..nn.1
  blanksvärta_1_N = mkN "blanksvärta" ; -- blanksvärta..nn.1
  blankvatten_1_N = mkN "blankvatten" "blankvattnet" "blankvatten" "blankvattnen" ; -- blankvatten..nn.1
  blankvers_1_N = mkN "blankvers" ; -- blankvers..nn.1
  blankål_1_N = mkN "blankål" ; -- blankål..nn.1
  blark_1_N = mkN "blark" ; -- blark..nn.1
  blarr_1_N = mkN "blarr" neutrum  ; -- blarr..nn.1
  blarra_1_V = mkV "blarrar" ; -- blarra..vb.1
  blarrande_1_N = mkN "blarrande" ; -- blarrande..nn.1
  blaserad_1_A = mkA "blaserad" ; -- blaserad..av.1
  blasfemi_1_N = mkN "blasfemi" "blasfemier" ; -- blasfemi..nn.1
  blasfemisk_1_A = mkA "blasfemisk" ; -- blasfemisk..av.1
  blask_1_N = mkN "blask" neutrum  ; -- blask..nn.1
  blaska_1_N = mkN "blaska" ; -- blaska..nn.1
  blaska_1_V = mkV "blaskar" ; -- blaska..vb.1
  blaskande_1_N = mkN "blaskande" ; -- blaskande..nn.1
  blaskig_1_A = mkA "blaskig" ; -- blaskig..av.1
  blaskighet_1_N = mkN "blaskighet" ; -- blaskighet..nn.1
  blasonering_1_N = mkN "blasonering" ; -- blasonering..nn.1
  blast_1_N = mkN "blast" ; -- blast..nn.1
  blastula_1_N = mkN "blastula" ; -- blastula..nn.1
  blasé_1_A = mkA "blasé" ; -- blasé..av.1
  blatte_1_N = mkN "blatte" utrum  ; -- blatte..nn.1
  blazer_1_N = mkN "blazer" ; -- blazer..nn.1
  blazerklädd_1_A = mkA "blazerklädd" ; -- blazerklädd..av.1
  bleck_1_N = mkN "bleck" neutrum  ; -- bleck..nn.1
  bleckblåsinstrument_1_N = mkN "bleckblåsinstrument" neutrum  ; -- bleckblåsinstrument..nn.1
  bleckburk_1_N = mkN "bleckburk" ; -- bleckburk..nn.1
  bleckinstrument_1_N = mkN "bleckinstrument" neutrum  ; -- bleckinstrument..nn.1
  bleckmusik_1_N = mkN "bleckmusik" ; -- bleckmusik..nn.1
  bleckplåt_1_N = mkN "bleckplåt" ; -- bleckplåt..nn.1
  bleckslagare_1_N = mkN "bleckslagare" utrum  ; -- bleckslagare..nn.1
  bleckslageri_1_N = mkN "bleckslageri" "bleckslageriet" "bleckslagerier" "bleckslagerierna" ; -- bleckslageri..nn.1
  blecksmak_1_N = mkN "blecksmak" ; -- blecksmak..nn.1
  blek_1_A = mkA "blek" ; -- blek..av.1
  bleka_1_V = mkV "bleker" ; -- bleka..vb.1
  blekande_1_N = mkN "blekande" ; -- blekande..nn.1
  blekansikte_1_N = mkN "blekansikte" ; -- blekansikte..nn.1
  blekblå_1_A = mkA "blekblå" "blekblått" ; -- blekblå..av.1
  bleke_1_N = mkN "bleke" ; -- bleke..nn.1
  blekeri_1_N = mkN "blekeri" "blekeriet" "blekerier" "blekerierna" ; -- blekeri..nn.1
  blekfet_1_A = mkA "blekfet" ; -- blekfet..av.1
  blekfethet_1_N = mkN "blekfethet" ; -- blekfethet..nn.1
  blekfis_1_N = mkN "blekfis" ; -- blekfis..nn.1
  blekglaserad_1_A = mkA "blekglaserad" ; -- blekglaserad..av.1
  blekgul_1_A = mkA "blekgul" ; -- blekgul..av.1
  blekhet_1_N = mkN "blekhet" "blekheter" ; -- blekhet..nn.1
  bleking_1_N = mkN "bleking" ; -- bleking..nn.1
  blekingseka_1_N = mkN "blekingseka" ; -- blekingseka..nn.1
  blekingsk_1_A = mkA "blekingsk" ; -- blekingsk..av.1
  blekingska_1_N = mkN "blekingska" ; -- blekingska..nn.1
  blekingska_2_N = mkN "blekingska" ; -- blekingska..nn.2
  blekjord_1_N = mkN "blekjord" ; -- blekjord..nn.1
  bleklagd_1_A = mkA "bleklagd" "bleklagt" ; -- bleklagd..av.1
  bleklagdhet_1_N = mkN "bleklagdhet" ; -- bleklagdhet..nn.1
  blekmedel_1_N = mkN "blekmedel" neutrum  ; -- blekmedel..nn.1
  blekna_1_V = mkV "bleknar" ; -- blekna..vb.1
  bleknande_1_N = mkN "bleknande" ; -- bleknande..nn.1
  blekning_1_N = mkN "blekning" ; -- blekning..nn.1
  bleknos_1_N = mkN "bleknos" ; -- bleknos..nn.1
  blekröd_1_A = mkA "blekröd" "blekrött" ; -- blekröd..av.1
  bleksiktig_1_A = mkA "bleksiktig" ; -- bleksiktig..av.1
  bleksiktighet_1_N = mkN "bleksiktighet" ; -- bleksiktighet..nn.1
  bleksot_1_N = mkN "bleksot" ; -- bleksot..nn.1
  blekvätska_1_N = mkN "blekvätska" ; -- blekvätska..nn.1
  blemma_1_N = mkN "blemma" ; -- blemma..nn.1
  blemmig_1_A = mkA "blemmig" ; -- blemmig..av.1
  blessera_1_V = mkV "blesserar" ; -- blessera..vb.1
  blesserande_1_N = mkN "blesserande" ; -- blesserande..nn.1
  blesserbar_1_A = mkA "blesserbar" ; -- blesserbar..av.1
  blesserbarhet_1_N = mkN "blesserbarhet" ; -- blesserbarhet..nn.1
  blessering_1_N = mkN "blessering" ; -- blessering..nn.1
  blessyr_1_N = mkN "blessyr" "blessyrer" ; -- blessyr..nn.1
  bli_1_V = mkV "bliva" "blev" "blivit" ; -- bli..vb.1
  blick_1_N = mkN "blick" ; -- blick..nn.1
  blicka_1_V = mkV "blickar" ; -- blicka..vb.1
  blickande_1_N = mkN "blickande" ; -- blickande..nn.1
  blickfält_1_N = mkN "blickfält" neutrum  ; -- blickfält..nn.1
  blickfång_1_N = mkN "blickfång" neutrum  ; -- blickfång..nn.1
  blickpunkt_1_N = mkN "blickpunkt" ; -- blickpunkt..nn.1
  blickstilla_1_A = mkA "blickstilla" ; -- blickstilla..av.1
  blid_1_A = mkA "blid" "blitt" ; -- blid..av.1
  blida_1_N = mkN "blida" ; -- blida..nn.1
  blidgrad_1_N = mkN "blidgrad" "blidgrader" ; -- blidgrad..nn.1
  blidhet_1_N = mkN "blidhet" ; -- blidhet..nn.1
  blidka_1_V = mkV "blidkar" ; -- blidka..vb.1
  blidkande_1_N = mkN "blidkande" ; -- blidkande..nn.1
  blidvinter_1_N = mkN "blidvinter" ; -- blidvinter..nn.1
  blidväder_1_N = mkN "blidväder" neutrum  ; -- blidväder..nn.1
  bliende_1_N = mkN "bliende" ; -- bliende..nn.1
  blig_1_N = mkN "blig" neutrum  ; -- blig..nn.1
  bliga_1_V = mkV "bligar" ; -- bliga..vb.1
  bligande_1_N = mkN "bligande" ; -- bligande..nn.1
  blind_1_A = mkA "blind" ; -- blind..av.1
  blinda_1_N = mkN "blinda" ; -- blinda..nn.1
  blindalfabet_1_N = mkN "blindalfabet" neutrum  ; -- blindalfabet..nn.1
  blindbock_1_N = mkN "blindbock" ; -- blindbock..nn.1
  blindbotten_1_N = mkN "blindbotten" ; -- blindbotten..nn.1
  blindbroms_1_N = mkN "blindbroms" ; -- blindbroms..nn.1
  blinddörr_1_N = mkN "blinddörr" ; -- blinddörr..nn.1
  blindera_1_V = mkV "blinderar" ; -- blindera..vb.1
  blinderande_1_N = mkN "blinderande" ; -- blinderande..nn.1
  blinderbar_1_A = mkA "blinderbar" ; -- blinderbar..av.1
  blinderbarhet_1_N = mkN "blinderbarhet" ; -- blinderbarhet..nn.1
  blindering_1_N = mkN "blindering" ; -- blindering..nn.1
  blindflygning_1_N = mkN "blindflygning" ; -- blindflygning..nn.1
  blindfönster_1_N = mkN "blindfönster" neutrum  ; -- blindfönster..nn.1
  blindgata_1_N = mkN "blindgata" ; -- blindgata..nn.1
  blindgångare_1_N = mkN "blindgångare" utrum  ; -- blindgångare..nn.1
  blindhet_1_N = mkN "blindhet" ; -- blindhet..nn.1
  blindhund_1_N = mkN "blindhund" ; -- blindhund..nn.1
  blindinstitut_1_N = mkN "blindinstitut" neutrum  ; -- blindinstitut..nn.1
  blindkarta_1_N = mkN "blindkarta" ; -- blindkarta..nn.1
  blindlandning_1_N = mkN "blindlandning" ; -- blindlandning..nn.1
  blindlykta_1_N = mkN "blindlykta" ; -- blindlykta..nn.1
  blindnässla_1_N = mkN "blindnässla" ; -- blindnässla..nn.1
  blindparti_1_N = mkN "blindparti" "blindpartiet" "blindpartier" "blindpartierna" ; -- blindparti..nn.1
  blindpassagerare_1_N = mkN "blindpassagerare" utrum  ; -- blindpassagerare..nn.1
  blindpatron_1_N = mkN "blindpatron" "blindpatroner" ; -- blindpatron..nn.1
  blindpipa_1_N = mkN "blindpipa" ; -- blindpipa..nn.1
  blindpressa_1_V = mkV "blindpressar" ; -- blindpressa..vb.1
  blindpressande_1_N = mkN "blindpressande" ; -- blindpressande..nn.1
  blindpressning_1_N = mkN "blindpressning" ; -- blindpressning..nn.1
  blindrote_1_N = mkN "blindrote" utrum  ; -- blindrote..nn.1
  blindrå_1_N = mkN "blindrå" "blindrån" "blindrår" "blindrårna" ; -- blindrå..nn.1
  blindschack_1_N = mkN "blindschack" neutrum  ; -- blindschack..nn.1
  blindskola_1_N = mkN "blindskola" ; -- blindskola..nn.1
  blindskrift_1_N = mkN "blindskrift" ; -- blindskrift..nn.1
  blindskär_1_N = mkN "blindskär" neutrum  ; -- blindskär..nn.1
  blindspår_1_N = mkN "blindspår" neutrum  ; -- blindspår..nn.1
  blindstyre_1_N = mkN "blindstyre" ; -- blindstyre..nn.1
  blindtarm_1_N = mkN "blindtarm" ; -- blindtarm..nn.1
  blindtarmsinflammation_1_N = mkN "blindtarmsinflammation" ; -- blindtarmsinflammation..nn.1
  blindtarmsoperation_1_N = mkN "blindtarmsoperation" ; -- blindtarmsoperation..nn.1
  blindtryck_1_N = mkN "blindtryck" neutrum  ; -- blindtryck..nn.1
  bling_bling_1_N = mkN "bling-bling" neutrum  ; -- bling-bling..nn.1
  bling_1_N = mkN "bling" neutrum  ; -- bling..nn.1
  blinga_1_V = mkV "blingar" ; -- blinga..vb.1
  blingande_1_N = mkN "blingande" ; -- blingande..nn.1
  blingning_1_N = mkN "blingning" ; -- blingning..nn.1
  blini_1_N = mkN "blini" "blinier" ; -- blini..nn.1
  blink_1_N = mkN "blink" neutrum  ; -- blink..nn.1
  blink_2_N = mkN "blink" ; -- blink..nn.2
  blinka_1_V = mkV "blinkar" ; -- blinka..vb.1
  blinkande_1_N = mkN "blinkande" ; -- blinkande..nn.1
  blinker_1_N = mkN "blinker" ; -- blinker..nn.1
  blinkfyr_1_N = mkN "blinkfyr" ; -- blinkfyr..nn.1
  blinkhinna_1_N = mkN "blinkhinna" ; -- blinkhinna..nn.1
  blinkljus_1_N = mkN "blinkljus" neutrum  ; -- blinkljus..nn.1
  blinkning_1_N = mkN "blinkning" ; -- blinkning..nn.1
  blinning_1_N = mkN "blinning" ; -- blinning..nn.1
  blip_1_N = mkN "blip" ; -- blip..nn.1
  blipp_1_N = mkN "blipp" ; -- blipp..nn.1
  blippa_1_V = mkV "blippar" ; -- blippa..vb.1
  blippande_1_N = mkN "blippande" ; -- blippande..nn.1
  blippning_1_N = mkN "blippning" ; -- blippning..nn.1
  blivande_1_A = mkA "blivande" ; -- blivande..av.1
  blivande_1_N = mkN "blivande" ; -- blivande..nn.1
  blixt_1_N = mkN "blixt" ; -- blixt..nn.1
  blixtanfall_1_N = mkN "blixtanfall" neutrum  ; -- blixtanfall..nn.1
  blixtbelysning_1_N = mkN "blixtbelysning" ; -- blixtbelysning..nn.1
  blixtbesök_1_N = mkN "blixtbesök" neutrum  ; -- blixtbesök..nn.1
  blixtfoto_1_N = mkN "blixtfoto" "blixtfotot" "blixtfoton" "blixtfotona" ; -- blixtfoto..nn.1
  blixtfotografera_1_V = mkV "blixtfotograferar" ; -- blixtfotografera..vb.1
  blixtfotograferande_1_N = mkN "blixtfotograferande" ; -- blixtfotograferande..nn.1
  blixtfotograferbar_1_A = mkA "blixtfotograferbar" ; -- blixtfotograferbar..av.1
  blixtfotograferbarhet_1_N = mkN "blixtfotograferbarhet" ; -- blixtfotograferbarhet..nn.1
  blixtfotografering_1_N = mkN "blixtfotografering" ; -- blixtfotografering..nn.1
  blixtfyr_1_N = mkN "blixtfyr" ; -- blixtfyr..nn.1
  blixtförälskad_1_A = mkA "blixtförälskad" ; -- blixtförälskad..av.1
  blixthalka_1_N = mkN "blixthalka" ; -- blixthalka..nn.1
  blixtinkalla_1_V = mkV "blixtinkallar" ; -- blixtinkalla..vb.1
  blixtinkallad_1_A = mkA "blixtinkallad" ; -- blixtinkallad..av.1
  blixtinkallande_1_N = mkN "blixtinkallande" ; -- blixtinkallande..nn.1
  blixtinkallelse_1_N = mkN "blixtinkallelse" "blixtinkallelser" ; -- blixtinkallelse..nn.1
  blixtinvasion_1_N = mkN "blixtinvasion" ; -- blixtinvasion..nn.1
  blixtkrig_1_N = mkN "blixtkrig" neutrum  ; -- blixtkrig..nn.1
  blixtlampa_1_N = mkN "blixtlampa" ; -- blixtlampa..nn.1
  blixtljus_1_N = mkN "blixtljus" neutrum  ; -- blixtljus..nn.1
  blixtlås_1_N = mkN "blixtlås" neutrum  ; -- blixtlås..nn.1
  blixtnedslag_1_N = mkN "blixtnedslag" neutrum  ; -- blixtnedslag..nn.1
  blixtpatron_1_N = mkN "blixtpatron" "blixtpatroner" ; -- blixtpatron..nn.1
  blixtpulver_1_N = mkN "blixtpulver" neutrum  ; -- blixtpulver..nn.1
  blixtra_1_V = mkV "blixtrar" ; -- blixtra..vb.1
  blixtrande_1_A = mkA "blixtrande" ; -- blixtrande..av.1
  blixtrande_1_N = mkN "blixtrande" ; -- blixtrande..nn.1
  blixtsamtal_1_N = mkN "blixtsamtal" neutrum  ; -- blixtsamtal..nn.1
  blixtsnabb_1_A = mkA "blixtsnabb" ; -- blixtsnabb..av.1
  blixtsnabbhet_1_N = mkN "blixtsnabbhet" ; -- blixtsnabbhet..nn.1
  blixtutryckning_1_N = mkN "blixtutryckning" ; -- blixtutryckning..nn.1
  blixtvisit_1_N = mkN "blixtvisit" "blixtvisiter" ; -- blixtvisit..nn.1
  block_1_N = mkN "block" neutrum  ; -- block..nn.1
  blocka_1_V = mkV "blockar" ; -- blocka..vb.1
  blockad_1_N = mkN "blockad" "blockader" ; -- blockad..nn.1
  blockadbrott_1_N = mkN "blockadbrott" neutrum  ; -- blockadbrott..nn.1
  blockadbrytare_1_N = mkN "blockadbrytare" utrum  ; -- blockadbrytare..nn.1
  blockalmanack_1_N = mkN "blockalmanack" "blockalmanacker" ; -- blockalmanack..nn.1
  blockalmanacka_1_N = mkN "blockalmanacka" ; -- blockalmanacka..nn.1
  blockande_1_N = mkN "blockande" ; -- blockande..nn.1
  blockbildning_1_N = mkN "blockbildning" ; -- blockbildning..nn.1
  blockchoklad_1_N = mkN "blockchoklad" ; -- blockchoklad..nn.1
  blockdiagram_1_N = mkN "blockdiagram" "blockdiagrammet" "blockdiagram" "blockdiagrammen" ; -- blockdiagram..nn.1
  blockera_1_V = mkV "blockerar" ; -- blockera..vb.1
  blockerande_1_N = mkN "blockerande" ; -- blockerande..nn.1
  blockerbar_1_A = mkA "blockerbar" ; -- blockerbar..av.1
  blockerbarhet_1_N = mkN "blockerbarhet" ; -- blockerbarhet..nn.1
  blockering_1_N = mkN "blockering" ; -- blockering..nn.1
  blockflöjt_1_N = mkN "blockflöjt" "blockflöjter" ; -- blockflöjt..nn.1
  blockgräns_1_N = mkN "blockgräns" "blockgränser" ; -- blockgräns..nn.1
  blockhus_1_N = mkN "blockhus" neutrum  ; -- blockhus..nn.1
  blockig_1_A = mkA "blockig" ; -- blockig..av.1
  blockighet_1_N = mkN "blockighet" ; -- blockighet..nn.1
  blockmark_1_N = mkN "blockmark" ; -- blockmark..nn.1
  blockpolitik_1_N = mkN "blockpolitik" ; -- blockpolitik..nn.1
  blockpolitisk_1_A = mkA "blockpolitisk" ; -- blockpolitisk..av.1
  blocksignal_1_N = mkN "blocksignal" "blocksignaler" ; -- blocksignal..nn.1
  blockskiva_1_N = mkN "blockskiva" ; -- blockskiva..nn.1
  blocksystem_1_N = mkN "blocksystem" neutrum  ; -- blocksystem..nn.1
  blocktalja_1_N = mkN "blocktalja" ; -- blocktalja..nn.1
  blocktrissa_1_N = mkN "blocktrissa" ; -- blocktrissa..nn.1
  blocktyg_1_N = mkN "blocktyg" neutrum  ; -- blocktyg..nn.1
  blocktänkande_1_N = mkN "blocktänkande" ; -- blocktänkande..nn.1
  blockvagn_1_N = mkN "blockvagn" ; -- blockvagn..nn.1
  blockämne_1_N = mkN "blockämne" ; -- blockämne..nn.1
  blocköverskridande_1_A = mkA "blocköverskridande" ; -- blocköverskridande..av.1
  blod_hjärnbarriär_1_N = mkN "blod-hjärnbarriär" "blod-hjärnbarriärer" ; -- blod-hjärnbarriär..nn.1
  blod_1_N = mkN "blod" ; -- blod..nn.1
  bloda_1_V = mkV "blodar" ; -- bloda..vb.1
  blodande_1_N = mkN "blodande" ; -- blodande..nn.1
  blodapelsin_1_N = mkN "blodapelsin" "blodapelsiner" ; -- blodapelsin..nn.1
  blodbad_1_N = mkN "blodbad" neutrum  ; -- blodbad..nn.1
  blodbank_1_N = mkN "blodbank" "blodbanker" ; -- blodbank..nn.1
  blodbefläckad_1_A = mkA "blodbefläckad" ; -- blodbefläckad..av.1
  blodbestänkt_1_A = mkA "blodbestänkt" "blodbestänkt" ; -- blodbestänkt..av.1
  blodbesudlad_1_A = mkA "blodbesudlad" ; -- blodbesudlad..av.1
  blodblåsa_1_N = mkN "blodblåsa" ; -- blodblåsa..nn.1
  blodbok_1_N = mkN "blodbok" ; -- blodbok..nn.1
  blodbrist_1_N = mkN "blodbrist" ; -- blodbrist..nn.1
  blodcancer_1_N = mkN "blodcancer" ; -- blodcancer..nn.1
  blodcell_1_N = mkN "blodcell" "blodceller" ; -- blodcell..nn.1
  blodcirkulation_1_N = mkN "blodcirkulation" ; -- blodcirkulation..nn.1
  bloddoping_1_N = mkN "bloddoping" ; -- bloddoping..nn.1
  bloddrypande_1_A = mkA "bloddrypande" ; -- bloddrypande..av.1
  bloddränkt_1_A = mkA "bloddränkt" "bloddränkt" ; -- bloddränkt..av.1
  blodfattig_1_A = mkA "blodfattig" ; -- blodfattig..av.1
  blodfattighet_1_N = mkN "blodfattighet" ; -- blodfattighet..nn.1
  blodfläck_1_N = mkN "blodfläck" ; -- blodfläck..nn.1
  blodflöde_1_N = mkN "blodflöde" ; -- blodflöde..nn.1
  blodfull_1_A = mkA "blodfull" ; -- blodfull..av.1
  blodfullhet_1_N = mkN "blodfullhet" ; -- blodfullhet..nn.1
  blodfyllning_1_N = mkN "blodfyllning" ; -- blodfyllning..nn.1
  blodfärgämne_1_N = mkN "blodfärgämne" ; -- blodfärgämne..nn.1
  blodförgiftning_1_N = mkN "blodförgiftning" ; -- blodförgiftning..nn.1
  blodförlust_1_N = mkN "blodförlust" ; -- blodförlust..nn.1
  blodförtunnande_1_A = mkA "blodförtunnande" ; -- blodförtunnande..av.1
  blodgenomströmning_1_N = mkN "blodgenomströmning" ; -- blodgenomströmning..nn.1
  blodgivarcentral_1_N = mkN "blodgivarcentral" "blodgivarcentraler" ; -- blodgivarcentral..nn.1
  blodgivare_1_N = mkN "blodgivare" utrum  ; -- blodgivare..nn.1
  blodgivning_1_N = mkN "blodgivning" ; -- blodgivning..nn.1
  blodgrape_1_N = mkN "blodgrape" utrum  ; -- blodgrape..nn.1
  blodgrupp_1_N = mkN "blodgrupp" "blodgrupper" ; -- blodgrupp..nn.1
  blodgång_1_N = mkN "blodgång" ; -- blodgång..nn.1
  blodhosta_1_N = mkN "blodhosta" ; -- blodhosta..nn.1
  blodhostning_1_N = mkN "blodhostning" ; -- blodhostning..nn.1
  blodhund_1_N = mkN "blodhund" ; -- blodhund..nn.1
  blodig_1_A = mkA "blodig" ; -- blodig..av.1
  blodigel_1_N = mkN "blodigel" ; -- blodigel..nn.1
  blodighet_1_N = mkN "blodighet" "blodigheter" ; -- blodighet..nn.1
  blodisande_1_A = mkA "blodisande" ; -- blodisande..av.1
  blodkorv_1_N = mkN "blodkorv" ; -- blodkorv..nn.1
  blodkropp_1_N = mkN "blodkropp" ; -- blodkropp..nn.1
  blodkräfta_1_N = mkN "blodkräfta" ; -- blodkräfta..nn.1
  blodkräkning_1_N = mkN "blodkräkning" ; -- blodkräkning..nn.1
  blodkärl_1_N = mkN "blodkärl" neutrum  ; -- blodkärl..nn.1
  blodkärlsbråck_1_N = mkN "blodkärlsbråck" neutrum  ; -- blodkärlsbråck..nn.1
  blodledare_1_N = mkN "blodledare" utrum  ; -- blodledare..nn.1
  blodlever_1_N = mkN "blodlever" ; -- blodlever..nn.1
  blodlutsalt_1_N = mkN "blodlutsalt" neutrum  ; -- blodlutsalt..nn.1
  blodlutssalt_1_N = mkN "blodlutssalt" neutrum  ; -- blodlutssalt..nn.1
  blodlönn_1_N = mkN "blodlönn" ; -- blodlönn..nn.1
  blodlös_1_A = mkA "blodlös" ; -- blodlös..av.1
  blodlöshet_1_N = mkN "blodlöshet" ; -- blodlöshet..nn.1
  blodmat_1_N = mkN "blodmat" ; -- blodmat..nn.1
  blodnäva_1_N = mkN "blodnäva" ; -- blodnäva..nn.1
  blodomlopp_1_N = mkN "blodomlopp" neutrum  ; -- blodomlopp..nn.1
  blodpalt_1_N = mkN "blodpalt" ; -- blodpalt..nn.1
  blodplasma_1_N = mkN "blodplasma" ; -- blodplasma..nn.1
  blodplätt_1_N = mkN "blodplätt" ; -- blodplätt..nn.1
  blodpropp_1_N = mkN "blodpropp" ; -- blodpropp..nn.1
  blodprotein_1_N = mkN "blodprotein" "blodproteinet" "blodproteiner" "blodproteinerna" ; -- blodprotein..nn.1
  blodprov_1_N = mkN "blodprov" neutrum  ; -- blodprov..nn.1
  blodprovstagning_1_N = mkN "blodprovstagning" ; -- blodprovstagning..nn.1
  blodpudding_1_N = mkN "blodpudding" ; -- blodpudding..nn.1
  blodpuddingsbit_1_N = mkN "blodpuddingsbit" ; -- blodpuddingsbit..nn.1
  blodpump_1_N = mkN "blodpump" ; -- blodpump..nn.1
  blodpöl_1_N = mkN "blodpöl" ; -- blodpöl..nn.1
  blodrand_1_N = mkN "blodrand" "blodränder" ; -- blodrand..nn.1
  blodregn_1_N = mkN "blodregn" neutrum  ; -- blodregn..nn.1
  blodriska_1_N = mkN "blodriska" ; -- blodriska..nn.1
  blodrot_1_N = mkN "blodrot" ; -- blodrot..nn.1
  blodröd_1_A = mkA "blodröd" "blodrött" ; -- blodröd..av.1
  blodsband_1_N = mkN "blodsband" neutrum  ; -- blodsband..nn.1
  blodsdiamant_1_N = mkN "blodsdiamant" "blodsdiamanter" ; -- blodsdiamant..nn.1
  blodsdrama_1_N = mkN "blodsdrama" "blodsdramat" "blodsdramer" "blodsdramerna" ; -- blodsdrama..nn.1
  blodsdroppe_1_N = mkN "blodsdroppe" utrum  ; -- blodsdroppe..nn.1
  blodsdåd_1_N = mkN "blodsdåd" neutrum  ; -- blodsdåd..nn.1
  blodserum_1_N = mkN "blodserum" neutrum  ; -- blodserum..nn.1
  blodshämnare_1_N = mkN "blodshämnare" utrum  ; -- blodshämnare..nn.1
  blodshämnd_1_N = mkN "blodshämnd" ; -- blodshämnd..nn.1
  blodsjukdom_1_N = mkN "blodsjukdom" ; -- blodsjukdom..nn.1
  blodsmak_1_N = mkN "blodsmak" ; -- blodsmak..nn.1
  blodsmystik_1_N = mkN "blodsmystik" ; -- blodsmystik..nn.1
  blodsocker_1_N = mkN "blodsocker" neutrum  ; -- blodsocker..nn.1
  blodsockersvacka_1_N = mkN "blodsockersvacka" ; -- blodsockersvacka..nn.1
  blodspenning_1_N = mkN "blodspenning" ; -- blodspenning..nn.1
  blodspottning_1_N = mkN "blodspottning" ; -- blodspottning..nn.1
  blodsprängd_1_A = mkA "blodsprängd" "blodsprängt" ; -- blodsprängd..av.1
  blodsprängdhet_1_N = mkN "blodsprängdhet" ; -- blodsprängdhet..nn.1
  blodspår_1_N = mkN "blodspår" neutrum  ; -- blodspår..nn.1
  blodstallning_1_N = mkN "blodstallning" ; -- blodstallning..nn.1
  blodstensmalm_1_N = mkN "blodstensmalm" ; -- blodstensmalm..nn.1
  blodstillande_1_A = mkA "blodstillande" ; -- blodstillande..av.1
  blodstillning_1_N = mkN "blodstillning" ; -- blodstillning..nn.1
  blodstinn_1_A = mkA "blodstinn" "blodstint" ; -- blodstinn..av.1
  blodstinnhet_1_N = mkN "blodstinnhet" ; -- blodstinnhet..nn.1
  blodstockning_1_N = mkN "blodstockning" ; -- blodstockning..nn.1
  blodstänkt_1_A = mkA "blodstänkt" "blodstänkt" ; -- blodstänkt..av.1
  blodstörtning_1_N = mkN "blodstörtning" ; -- blodstörtning..nn.1
  blodsugande_1_A = mkA "blodsugande" ; -- blodsugande..av.1
  blodsugare_1_N = mkN "blodsugare" utrum  ; -- blodsugare..nn.1
  blodsugeri_1_N = mkN "blodsugeri" neutrum  ; -- blodsugeri..nn.1
  blodsutgjutelse_1_N = mkN "blodsutgjutelse" "blodsutgjutelser" ; -- blodsutgjutelse..nn.1
  blodsvettning_1_N = mkN "blodsvettning" ; -- blodsvettning..nn.1
  blodsvulst_1_N = mkN "blodsvulst" "blodsvulster" ; -- blodsvulst..nn.1
  blodsystem_1_N = mkN "blodsystem" neutrum  ; -- blodsystem..nn.1
  blodsänka_1_N = mkN "blodsänka" ; -- blodsänka..nn.1
  blodtappning_1_N = mkN "blodtappning" ; -- blodtappning..nn.1
  blodtransfusion_1_N = mkN "blodtransfusion" ; -- blodtransfusion..nn.1
  blodtryck_1_N = mkN "blodtryck" neutrum  ; -- blodtryck..nn.1
  blodtryckshöjande_1_A = mkA "blodtryckshöjande" ; -- blodtryckshöjande..av.1
  blodtryckshöjning_1_N = mkN "blodtryckshöjning" ; -- blodtryckshöjning..nn.1
  blodtryckssänkande_1_A = mkA "blodtryckssänkande" ; -- blodtryckssänkande..av.1
  blodtryckssänkning_1_N = mkN "blodtryckssänkning" ; -- blodtryckssänkning..nn.1
  blodtyp_1_N = mkN "blodtyp" "blodtyper" ; -- blodtyp..nn.1
  blodtörst_1_N = mkN "blodtörst" ; -- blodtörst..nn.1
  blodtörstig_1_A = mkA "blodtörstig" ; -- blodtörstig..av.1
  blodtörstighet_1_N = mkN "blodtörstighet" ; -- blodtörstighet..nn.1
  blodutgjutning_1_N = mkN "blodutgjutning" ; -- blodutgjutning..nn.1
  blodvallning_1_N = mkN "blodvallning" ; -- blodvallning..nn.1
  blodvite_1_N = mkN "blodvite" ; -- blodvite..nn.1
  blodvittring_1_N = mkN "blodvittring" ; -- blodvittring..nn.1
  blodvärde_1_N = mkN "blodvärde" ; -- blodvärde..nn.1
  blodvätska_1_N = mkN "blodvätska" ; -- blodvätska..nn.1
  blodvåg_1_N = mkN "blodvåg" "blodvågor" ; -- blodvåg..nn.1
  blodåder_1_N = mkN "blodådra" ; -- blodåder..nn.1
  blodöverfyllnad_1_N = mkN "blodöverfyllnad" "blodöverfyllnader" ; -- blodöverfyllnad..nn.1
  blodöverföring_1_N = mkN "blodöverföring" ; -- blodöverföring..nn.1
  blog_1_N = mkN "blog" ; -- blog..nn.1
  bloga_1_V = mkV "blogar" ; -- bloga..vb.1
  blogande_1_N = mkN "blogande" ; -- blogande..nn.1
  blogare_1_N = mkN "blogare" utrum  ; -- blogare..nn.1
  blogg_1_N = mkN "blogg" ; -- blogg..nn.1
  blogga_1_V = mkV "bloggar" ; -- blogga..vb.1
  bloggande_1_N = mkN "bloggande" ; -- bloggande..nn.1
  bloggare_1_N = mkN "bloggare" utrum  ; -- bloggare..nn.1
  bloggerska_1_N = mkN "bloggerska" ; -- bloggerska..nn.1
  blogginlägg_1_N = mkN "blogginlägg" neutrum  ; -- blogginlägg..nn.1
  bloggosfär_1_N = mkN "bloggosfär" "bloggosfärer" ; -- bloggosfär..nn.1
  bloginlägg_1_N = mkN "bloginlägg" neutrum  ; -- bloginlägg..nn.1
  blogosfär_1_N = mkN "blogosfär" "blogosfärer" ; -- blogosfär..nn.1
  blomaxel_1_N = mkN "blomaxel" ; -- blomaxel..nn.1
  blombefruktning_1_N = mkN "blombefruktning" ; -- blombefruktning..nn.1
  blomblad_1_N = mkN "blomblad" neutrum  ; -- blomblad..nn.1
  blombord_1_N = mkN "blombord" neutrum  ; -- blombord..nn.1
  blombotten_1_N = mkN "blombotten" ; -- blombotten..nn.1
  blombukett_1_N = mkN "blombukett" "blombuketter" ; -- blombukett..nn.1
  blomdoft_1_N = mkN "blomdoft" "blomdofter" ; -- blomdoft..nn.1
  blomfat_1_N = mkN "blomfat" neutrum  ; -- blomfat..nn.1
  blomfjäll_1_N = mkN "blomfjäll" neutrum  ; -- blomfjäll..nn.1
  blomflock_1_N = mkN "blomflock" ; -- blomflock..nn.1
  blomfoder_1_N = mkN "blomfoder" neutrum  ; -- blomfoder..nn.1
  blomform_1_N = mkN "blomform" "blomformer" ; -- blomform..nn.1
  blomfäste_1_N = mkN "blomfäste" ; -- blomfäste..nn.1
  blomholk_1_N = mkN "blomholk" ; -- blomholk..nn.1
  blomhuvud_1_N = mkN "blomhuvud" "blomhuvudet" "blomhuvud" "blomhuvudena" ; -- blomhuvud..nn.1
  blomhylle_1_N = mkN "blomhylle" ; -- blomhylle..nn.1
  blomhänge_1_N = mkN "blomhänge" ; -- blomhänge..nn.1
  blomhölster_1_N = mkN "blomhölster" neutrum  ; -- blomhölster..nn.1
  blomjord_1_N = mkN "blomjord" ; -- blomjord..nn.1
  blomkalk_1_N = mkN "blomkalk" ; -- blomkalk..nn.1
  blomklase_1_N = mkN "blomklase" utrum  ; -- blomklase..nn.1
  blomklädd_1_A = mkA "blomklädd" ; -- blomklädd..av.1
  blomknippe_1_N = mkN "blomknippe" ; -- blomknippe..nn.1
  blomknopp_1_N = mkN "blomknopp" ; -- blomknopp..nn.1
  blomkolv_1_N = mkN "blomkolv" ; -- blomkolv..nn.1
  blomkorg_1_N = mkN "blomkorg" ; -- blomkorg..nn.1
  blomkrans_1_N = mkN "blomkrans" ; -- blomkrans..nn.1
  blomkrona_1_N = mkN "blomkrona" ; -- blomkrona..nn.1
  blomkruka_1_N = mkN "blomkruka" ; -- blomkruka..nn.1
  blomkvast_1_N = mkN "blomkvast" ; -- blomkvast..nn.1
  blomkäpp_1_N = mkN "blomkäpp" ; -- blomkäpp..nn.1
  blomkål_1_N = mkN "blomkål" ; -- blomkål..nn.1
  blomkålshuvud_1_N = mkN "blomkålshuvud" "blomkålshuvudet" "blomkålshuvud" "blomkålshuvudena" ; -- blomkålshuvud..nn.1
  blomkålssvamp_1_N = mkN "blomkålssvamp" ; -- blomkålssvamp..nn.1
  blomkålsöra_1_N = mkN "blomkålsöra" "blomkålsörat" "blomkålsöron" "blomkålsöronen" ; -- blomkålsöra..nn.1
  blomlåda_1_N = mkN "blomlåda" ; -- blomlåda..nn.1
  blomma_1_N = mkN "blomma" ; -- blomma..nn.1
  blomma_1_V = mkV "blommar" ; -- blomma..vb.1
  blommande_1_N = mkN "blommande" ; -- blommande..nn.1
  blommerad_1_A = mkA "blommerad" ; -- blommerad..av.1
  blommig_1_A = mkA "blommig" ; -- blommig..av.1
  blommighet_1_N = mkN "blommighet" "blommigheter" ; -- blommighet..nn.1
  blommografera_1_V = mkV "blommograferar" ; -- blommografera..vb.1
  blommograferande_1_N = mkN "blommograferande" ; -- blommograferande..nn.1
  blommograferbar_1_A = mkA "blommograferbar" ; -- blommograferbar..av.1
  blommograferbarhet_1_N = mkN "blommograferbarhet" ; -- blommograferbarhet..nn.1
  blommografering_1_N = mkN "blommografering" ; -- blommografering..nn.1
  blommogram_1_N = mkN "blommogram" "blommogrammet" "blommogram" "blommogrammen" ; -- blommogram..nn.1
  blommönster_1_N = mkN "blommönster" neutrum  ; -- blommönster..nn.1
  blomning_1_N = mkN "blomning" ; -- blomning..nn.1
  blomningstid_1_N = mkN "blomningstid" "blomningstider" ; -- blomningstid..nn.1
  blomplanta_1_N = mkN "blomplanta" ; -- blomplanta..nn.1
  blomskaft_1_N = mkN "blomskaft" neutrum  ; -- blomskaft..nn.1
  blomst_1_N = mkN "blomst" ; -- blomst..nn.1
  blomster_1_N = mkN "blomster" neutrum  ; -- blomster..nn.1
  blomsteraffär_1_N = mkN "blomsteraffär" "blomsteraffärer" ; -- blomsteraffär..nn.1
  blomsterbord_1_N = mkN "blomsterbord" neutrum  ; -- blomsterbord..nn.1
  blomsterbädd_1_N = mkN "blomsterbädd" ; -- blomsterbädd..nn.1
  blomsterdoft_1_N = mkN "blomsterdoft" "blomsterdofter" ; -- blomsterdoft..nn.1
  blomsterdoftande_1_A = mkA "blomsterdoftande" ; -- blomsterdoftande..av.1
  blomsterflicka_1_N = mkN "blomsterflicka" ; -- blomsterflicka..nn.1
  blomsterförmedling_1_N = mkN "blomsterförmedling" ; -- blomsterförmedling..nn.1
  blomsterförsäljerska_1_N = mkN "blomsterförsäljerska" ; -- blomsterförsäljerska..nn.1
  blomstergirland_1_N = mkN "blomstergirland" "blomstergirlander" ; -- blomstergirland..nn.1
  blomstergård_1_N = mkN "blomstergård" ; -- blomstergård..nn.1
  blomsterhandel_1_N = mkN "blomsterhandel" ; -- blomsterhandel..nn.1
  blomsterhandlare_1_N = mkN "blomsterhandlare" utrum  ; -- blomsterhandlare..nn.1
  blomsterhonung_1_N = mkN "blomsterhonung" ; -- blomsterhonung..nn.1
  blomsterklädd_1_A = mkA "blomsterklädd" ; -- blomsterklädd..av.1
  blomsterkrans_1_N = mkN "blomsterkrans" ; -- blomsterkrans..nn.1
  blomsterkransa_1_V = mkV "blomsterkransar" ; -- blomsterkransa..vb.1
  blomsterkvast_1_N = mkN "blomsterkvast" ; -- blomsterkvast..nn.1
  blomsterlåda_1_N = mkN "blomsterlåda" ; -- blomsterlåda..nn.1
  blomsterlök_1_N = mkN "blomsterlök" ; -- blomsterlök..nn.1
  blomstermålare_1_N = mkN "blomstermålare" utrum  ; -- blomstermålare..nn.1
  blomstermånad_1_N = mkN "blomstermånad" "blomstermånader" ; -- blomstermånad..nn.1
  blomsterodling_1_N = mkN "blomsterodling" ; -- blomsterodling..nn.1
  blomsterprakt_1_N = mkN "blomsterprakt" ; -- blomsterprakt..nn.1
  blomsterrabatt_1_N = mkN "blomsterrabatt" "blomsterrabatter" ; -- blomsterrabatt..nn.1
  blomstersmycka_1_V = mkV "blomstersmyckar" ; -- blomstersmycka..vb.1
  blomsterspruta_1_N = mkN "blomsterspruta" ; -- blomsterspruta..nn.1
  blomsterspråk_1_N = mkN "blomsterspråk" neutrum  ; -- blomsterspråk..nn.1
  blomstertid_1_N = mkN "blomstertid" "blomstertider" ; -- blomstertid..nn.1
  blomsterträdgård_1_N = mkN "blomsterträdgård" ; -- blomsterträdgård..nn.1
  blomsteruppsats_1_N = mkN "blomsteruppsats" "blomsteruppsatser" ; -- blomsteruppsats..nn.1
  blomstervas_1_N = mkN "blomstervas" "blomstervaser" ; -- blomstervas..nn.1
  blomsteräng_1_N = mkN "blomsteräng" ; -- blomsteräng..nn.1
  blomstjälk_1_N = mkN "blomstjälk" ; -- blomstjälk..nn.1
  blomstoft_1_N = mkN "blomstoft" neutrum  ; -- blomstoft..nn.1
  blomstra_1_V = mkV "blomstrar" ; -- blomstra..vb.1
  blomstrande_1_N = mkN "blomstrande" ; -- blomstrande..nn.1
  blomstring_1_N = mkN "blomstring" ; -- blomstring..nn.1
  blomstringsperiod_1_N = mkN "blomstringsperiod" "blomstringsperioder" ; -- blomstringsperiod..nn.1
  blomstringstid_1_N = mkN "blomstringstid" "blomstringstider" ; -- blomstringstid..nn.1
  blomställ_1_N = mkN "blomställ" neutrum  ; -- blomställ..nn.1
  blomställning_1_N = mkN "blomställning" ; -- blomställning..nn.1
  blomtjuv_1_N = mkN "blomtjuv" ; -- blomtjuv..nn.1
  blomvas_1_N = mkN "blomvas" "blomvaser" ; -- blomvas..nn.1
  blomvass_1_N = mkN "blomvass" ; -- blomvass..nn.1
  blomväxt_1_N = mkN "blomväxt" "blomväxter" ; -- blomväxt..nn.1
  blond_1_A = mkA "blond" ; -- blond..av.1
  blond_1_N = mkN "blond" "blonder" ; -- blond..nn.1
  blondera_1_V = mkV "blonderar" ; -- blondera..vb.1
  blonderande_1_N = mkN "blonderande" ; -- blonderande..nn.1
  blonderbar_1_A = mkA "blonderbar" ; -- blonderbar..av.1
  blonderbarhet_1_N = mkN "blonderbarhet" ; -- blonderbarhet..nn.1
  blondering_1_N = mkN "blondering" ; -- blondering..nn.1
  blondhet_1_N = mkN "blondhet" ; -- blondhet..nn.1
  blondin_1_N = mkN "blondin" "blondiner" ; -- blondin..nn.1
  bloss_1_N = mkN "bloss" neutrum  ; -- bloss..nn.1
  blossa_1_V = mkV "blossar" ; -- blossa..vb.1
  blossande_1_N = mkN "blossande" ; -- blossande..nn.1
  blot_1_N = mkN "blot" neutrum  ; -- blot..nn.1
  blota_1_V = mkV "blotar" ; -- blota..vb.1
  blotande_1_N = mkN "blotande" ; -- blotande..nn.1
  blott_1_A = mkA "blott" ; -- blott..av.1
  blotta_1_N = mkN "blotta" ; -- blotta..nn.1
  blotta_1_V = mkV "blottar" ; -- blotta..vb.1
  blottande_1_N = mkN "blottande" ; -- blottande..nn.1
  blottare_1_N = mkN "blottare" utrum  ; -- blottare..nn.1
  blottlägga_1_V = mkV "blottlägga" "blottla" "blottlagt" ; -- blottlägga..vb.1
  blottläggande_1_N = mkN "blottläggande" ; -- blottläggande..nn.1
  blottläggning_1_N = mkN "blottläggning" ; -- blottläggning..nn.1
  blottställa_1_V = mkV "blottställer" ; -- blottställa..vb.1
  blottställande_1_N = mkN "blottställande" ; -- blottställande..nn.1
  blottställd_1_A = mkA "blottställd" "blottställt" ; -- blottställd..av.1
  blottställdhet_1_N = mkN "blottställdhet" ; -- blottställdhet..nn.1
  blottställning_1_N = mkN "blottställning" ; -- blottställning..nn.1
  blowout_1_N = mkN "blowout" "blowouter" ; -- blowout..nn.1
  bludder_1_N = mkN "bludder" neutrum  ; -- bludder..nn.1
  bluddra_1_V = mkV "bluddrar" ; -- bluddra..vb.1
  bluddrande_1_N = mkN "bluddrande" ; -- bluddrande..nn.1
  blues_1_N = mkN "blues" ; -- blues..nn.1
  bluff_1_N = mkN "bluff" ; -- bluff..nn.1
  bluffa_1_V = mkV "bluffar" ; -- bluffa..vb.1
  bluffaktura_1_N = mkN "bluffaktura" ; -- bluffaktura..nn.1
  bluffande_1_N = mkN "bluffande" ; -- bluffande..nn.1
  bluffbygge_1_N = mkN "bluffbygge" ; -- bluffbygge..nn.1
  bluffmakare_1_N = mkN "bluffmakare" utrum  ; -- bluffmakare..nn.1
  bluffpiller_1_N = mkN "bluffpiller" neutrum  ; -- bluffpiller..nn.1
  bluffprojekt_1_N = mkN "bluffprojekt" neutrum  ; -- bluffprojekt..nn.1
  blund_1_N = mkN "blund" ; -- blund..nn.1
  blunda_1_V = mkV "blundar" ; -- blunda..vb.1
  blundande_1_N = mkN "blundande" ; -- blundande..nn.1
  blunddocka_1_N = mkN "blunddocka" ; -- blunddocka..nn.1
  blunder_1_N = mkN "blunder" ; -- blunder..nn.1
  blus_1_N = mkN "blus" ; -- blus..nn.1
  blusliv_1_N = mkN "blusliv" neutrum  ; -- blusliv..nn.1
  bly_1_N = mkN "bly" neutrum  ; -- bly..nn.1
  blya_1_V = mkV "blyar" ; -- blya..vb.1
  blyacetat_1_N = mkN "blyacetat" neutrum  ; -- blyacetat..nn.1
  blyackumulator_1_N = mkN "blyackumulator" "blyackumulatorer" ; -- blyackumulator..nn.1
  blyaktig_1_A = mkA "blyaktig" ; -- blyaktig..av.1
  blyande_1_N = mkN "blyande" ; -- blyande..nn.1
  blyaska_1_N = mkN "blyaska" ; -- blyaska..nn.1
  blyazid_1_N = mkN "blyazid" "blyazider" ; -- blyazid..nn.1
  blybatteri_1_N = mkN "blybatteri" "blybatteriet" "blybatterier" "blybatterierna" ; -- blybatteri..nn.1
  blyblomma_1_N = mkN "blyblomma" ; -- blyblomma..nn.1
  blydagg_1_N = mkN "blydagg" ; -- blydagg..nn.1
  blyerts_1_N = mkN "blyerts" ; -- blyerts..nn.1
  blyertsgrå_1_A = mkA "blyertsgrå" "blyertsgrått" ; -- blyertsgrå..av.1
  blyertspenna_1_N = mkN "blyertspenna" ; -- blyertspenna..nn.1
  blyfolie_1_N = mkN "blyfolie" "blyfolier" ; -- blyfolie..nn.1
  blyfri_1_A = mkA "blyfri" "blyfritt" ; -- blyfri..av.1
  blyfärg_1_N = mkN "blyfärg" "blyfärger" ; -- blyfärg..nn.1
  blyfärgad_1_A = mkA "blyfärgad" ; -- blyfärgad..av.1
  blyförening_1_N = mkN "blyförening" ; -- blyförening..nn.1
  blyförgiftad_1_A = mkA "blyförgiftad" ; -- blyförgiftad..av.1
  blyförgiftning_1_N = mkN "blyförgiftning" ; -- blyförgiftning..nn.1
  blyg_1_A = mkA "blyg" ; -- blyg..av.1
  blygd_1_N = mkN "blygd" ; -- blygd..nn.1
  blygdben_1_N = mkN "blygdben" neutrum  ; -- blygdben..nn.1
  blygdhår_1_N = mkN "blygdhår" neutrum  ; -- blygdhår..nn.1
  blygdhår_2_N = mkN "blygdhår" neutrum  ; -- blygdhår..nn.2
  blygdläpp_1_N = mkN "blygdläpp" ; -- blygdläpp..nn.1
  blyghet_1_N = mkN "blyghet" "blygheter" ; -- blyghet..nn.1
  blyglans_1_N = mkN "blyglans" ; -- blyglans..nn.1
  blyglas_1_N = mkN "blyglas" neutrum  ; -- blyglas..nn.1
  blyglete_1_N = mkN "blyglete" ; -- blyglete..nn.1
  blygrå_1_A = mkA "blygrå" "blygrått" ; -- blygrå..av.1
  blygsam_1_A = mkA "blygsam" "blygsamt" "blygsamma" "blygsamma" "blygsammare" "blygsammast" "blygsammaste" ; -- blygsam..av.1
  blygsamhet_1_N = mkN "blygsamhet" "blygsamheter" ; -- blygsamhet..nn.1
  blygsel_1_N = mkN "blygsel" ; -- blygsel..nn.1
  blygult_1_N = mkN "blygult" ; -- blygult..nn.1
  blyhagel_1_N = mkN "blyhagel" neutrum  ; -- blyhagel..nn.1
  blyhalt_1_N = mkN "blyhalt" "blyhalter" ; -- blyhalt..nn.1
  blyhaltig_1_A = mkA "blyhaltig" ; -- blyhaltig..av.1
  blykula_1_N = mkN "blykula" ; -- blykula..nn.1
  blykyld_1_A = mkA "blykyld" "blykylt" ; -- blykyld..av.1
  blyköl_1_N = mkN "blyköl" ; -- blyköl..nn.1
  blylod_1_N = mkN "blylod" neutrum  ; -- blylod..nn.1
  blymantel_1_N = mkN "blymantel" ; -- blymantel..nn.1
  blymönja_1_N = mkN "blymönja" ; -- blymönja..nn.1
  blyoxid_1_N = mkN "blyoxid" "blyoxider" ; -- blyoxid..nn.1
  blyplåt_1_N = mkN "blyplåt" ; -- blyplåt..nn.1
  blysalva_1_N = mkN "blysalva" ; -- blysalva..nn.1
  blysocker_1_N = mkN "blysocker" neutrum  ; -- blysocker..nn.1
  blytetraetyl_1_N = mkN "blytetraetyl" ; -- blytetraetyl..nn.1
  blytung_1_A = mkA "blytung" ; -- blytung..av.1
  blytunghet_1_N = mkN "blytunghet" ; -- blytunghet..nn.1
  blytyngd_1_N = mkN "blytyngd" "blytyngder" ; -- blytyngd..nn.1
  blyvitt_1_N = mkN "blyvitt" ; -- blyvitt..nn.1
  blyättika_1_N = mkN "blyättika" ; -- blyättika..nn.1
  bläck_1_N = mkN "bläck" neutrum  ; -- bläck..nn.1
  bläcka_1_N = mkN "bläcka" ; -- bläcka..nn.1
  bläcka_1_V = mkV "bläckar" ; -- bläcka..vb.1
  bläckande_1_N = mkN "bläckande" ; -- bläckande..nn.1
  bläckblåsa_1_N = mkN "bläckblåsa" ; -- bläckblåsa..nn.1
  bläckfisk_1_N = mkN "bläckfisk" ; -- bläckfisk..nn.1
  bläckfläck_1_N = mkN "bläckfläck" ; -- bläckfläck..nn.1
  bläckhorn_1_N = mkN "bläckhorn" neutrum  ; -- bläckhorn..nn.1
  bläckig_1_A = mkA "bläckig" ; -- bläckig..av.1
  bläckkörtel_1_N = mkN "bläckkörtel" ; -- bläckkörtel..nn.1
  bläckpenna_1_N = mkN "bläckpenna" ; -- bläckpenna..nn.1
  bläckplump_1_N = mkN "bläckplump" ; -- bläckplump..nn.1
  bläckpulver_1_N = mkN "bläckpulver" neutrum  ; -- bläckpulver..nn.1
  bläcksuddare_1_N = mkN "bläcksuddare" utrum  ; -- bläcksuddare..nn.1
  bläcksvamp_1_N = mkN "bläcksvamp" ; -- bläcksvamp..nn.1
  bläcksvart_1_A = mkA "bläcksvart" "bläcksvart" ; -- bläcksvart..av.1
  bläcksäck_1_N = mkN "bläcksäck" ; -- bläcksäck..nn.1
  bläckteckning_1_N = mkN "bläckteckning" ; -- bläckteckning..nn.1
  bläda_1_V = mkV "blädar" ; -- bläda..vb.1
  blädande_1_N = mkN "blädande" ; -- blädande..nn.1
  blädderblock_1_N = mkN "blädderblock" neutrum  ; -- blädderblock..nn.1
  blädderbok_1_N = mkN "blädderbok" "blädderböcker" ; -- blädderbok..nn.1
  bläddra_1_N = mkN "bläddra" ; -- bläddra..nn.1
  bläddra_1_V = mkV "bläddrar" ; -- bläddra..vb.1
  bläddrande_1_N = mkN "bläddrande" ; -- bläddrande..nn.1
  blädning_1_N = mkN "blädning" ; -- blädning..nn.1
  blända_1_V = mkV "bländar" ; -- blända..vb.1
  bländande_1_A = mkA "bländande" ; -- bländande..av.1
  bländande_1_N = mkN "bländande" ; -- bländande..nn.1
  bländare_1_N = mkN "bländare" utrum  ; -- bländare..nn.1
  blände_1_N = mkN "blände" ; -- blände..nn.1
  bländfri_1_A = mkA "bländfri" "bländfritt" ; -- bländfri..av.1
  bländning_1_N = mkN "bländning" ; -- bländning..nn.1
  bländrisk_1_N = mkN "bländrisk" "bländrisker" ; -- bländrisk..nn.1
  bländskiva_1_N = mkN "bländskiva" ; -- bländskiva..nn.1
  bländskydd_1_N = mkN "bländskydd" neutrum  ; -- bländskydd..nn.1
  bländverk_1_N = mkN "bländverk" neutrum  ; -- bländverk..nn.1
  bländvit_1_A = mkA "bländvit" ; -- bländvit..av.1
  bläng_1_N = mkN "bläng" ; -- bläng..nn.1
  blänga_1_V = mkV "blänger" ; -- blänga..vb.1
  blängande_1_N = mkN "blängande" ; -- blängande..nn.1
  blängning_1_N = mkN "blängning" ; -- blängning..nn.1
  blänk_1_N = mkN "blänk" ; -- blänk..nn.1
  blänka_1_V = mkV "blänker" ; -- blänka..vb.1
  blänkande_1_N = mkN "blänkande" ; -- blänkande..nn.1
  blänkare_1_N = mkN "blänkare" utrum  ; -- blänkare..nn.1
  blänke_1_N = mkN "blänke" ; -- blänke..nn.1
  blänkfyr_1_N = mkN "blänkfyr" ; -- blänkfyr..nn.1
  blänkning_1_N = mkN "blänkning" ; -- blänkning..nn.1
  bläs_1_N = mkN "bläs" ; -- bläs..nn.1
  bläsand_1_N = mkN "bläsand" "bläsänder" ; -- bläsand..nn.1
  bläsbock_1_N = mkN "bläsbock" ; -- bläsbock..nn.1
  bläsgås_1_N = mkN "bläsgås" "bläsgåsen" "bläsgäss" "bläsgässen" ; -- bläsgås..nn.1
  blästa_1_V = mkV "blästar" ; -- blästa..vb.1
  blästande_1_N = mkN "blästande" ; -- blästande..nn.1
  bläster_1_N = mkN "bläster" ; -- bläster..nn.1
  blästerrör_1_N = mkN "blästerrör" neutrum  ; -- blästerrör..nn.1
  blästerugn_1_N = mkN "blästerugn" ; -- blästerugn..nn.1
  blästra_1_V = mkV "blästrar" ; -- blästra..vb.1
  blästrande_1_N = mkN "blästrande" ; -- blästrande..nn.1
  blå_1_A = mkA "blå" "blått" ; -- blå..av.1
  blåaktig_1_A = mkA "blåaktig" ; -- blåaktig..av.1
  blåaktighet_1_N = mkN "blåaktighet" ; -- blåaktighet..nn.1
  blåanlupen_1_A = mkA "blåanlupen" ; -- blåanlupen..av.1
  blåblodig_1_A = mkA "blåblodig" ; -- blåblodig..av.1
  blåblodighet_1_N = mkN "blåblodighet" ; -- blåblodighet..nn.1
  blåbyxa_1_N = mkN "blåbyxa" ; -- blåbyxa..nn.1
  blåbär_1_N = mkN "blåbär" neutrum  ; -- blåbär..nn.1
  blåbärsbuske_1_N = mkN "blåbärsbuske" utrum  ; -- blåbärsbuske..nn.1
  blåbärspannkaka_1_N = mkN "blåbärspannkaka" ; -- blåbärspannkaka..nn.1
  blåbärsplockare_1_N = mkN "blåbärsplockare" utrum  ; -- blåbärsplockare..nn.1
  blåbärsris_1_N = mkN "blåbärsris" neutrum  ; -- blåbärsris..nn.1
  blåbärssaft_1_N = mkN "blåbärssaft" "blåbärssafter" ; -- blåbärssaft..nn.1
  blåbärssoppa_1_N = mkN "blåbärssoppa" ; -- blåbärssoppa..nn.1
  blåbärssylt_1_N = mkN "blåbärssylt" "blåbärssylter" ; -- blåbärssylt..nn.1
  blåduva_1_N = mkN "blåduva" ; -- blåduva..nn.1
  blådåre_1_N = mkN "blådåre" utrum  ; -- blådåre..nn.1
  blåeld_1_N = mkN "blåeld" ; -- blåeld..nn.1
  blåelse_1_N = mkN "blåelse" utrum  ; -- blåelse..nn.1
  blåfrusen_1_A = mkA "blåfrusen" ; -- blåfrusen..av.1
  blåförskjutning_1_N = mkN "blåförskjutning" ; -- blåförskjutning..nn.1
  blågrå_1_A = mkA "blågrå" "blågrått" ; -- blågrå..av.1
  blågrön_1_A = mkA "blågrön" ; -- blågrön..av.1
  blågrönalg_1_N = mkN "blågrönalg" "blågrönalger" ; -- blågrönalg..nn.1
  blågul_1_A = mkA "blågul" ; -- blågul..av.1
  blåhaj_1_N = mkN "blåhaj" ; -- blåhaj..nn.1
  blåhake_1_N = mkN "blåhake" utrum  ; -- blåhake..nn.1
  blåhallon_1_N = mkN "blåhallon" neutrum  ; -- blåhallon..nn.1
  blåhet_1_N = mkN "blåhet" ; -- blåhet..nn.1
  blåhjon_1_N = mkN "blåhjon" neutrum  ; -- blåhjon..nn.1
  blåholts_1_N = mkN "blåholts" ; -- blåholts..nn.1
  blåis_1_N = mkN "blåis" ; -- blåis..nn.1
  blåjacka_1_N = mkN "blåjacka" ; -- blåjacka..nn.1
  blåjord_1_N = mkN "blåjord" ; -- blåjord..nn.1
  blåklint_1_N = mkN "blåklint" ; -- blåklint..nn.1
  blåklocka_1_N = mkN "blåklocka" ; -- blåklocka..nn.1
  blåklädd_1_A = mkA "blåklädd" ; -- blåklädd..av.1
  blåkopia_1_N = mkN "blåkopia" ; -- blåkopia..nn.1
  blåkopiera_1_V = mkV "blåkopierar" ; -- blåkopiera..vb.1
  blåkopierande_1_N = mkN "blåkopierande" ; -- blåkopierande..nn.1
  blåkopierbar_1_A = mkA "blåkopierbar" ; -- blåkopierbar..av.1
  blåkopierbarhet_1_N = mkN "blåkopierbarhet" ; -- blåkopierbarhet..nn.1
  blåkopiering_1_N = mkN "blåkopiering" ; -- blåkopiering..nn.1
  blåkråka_1_N = mkN "blåkråka" ; -- blåkråka..nn.1
  blåkullafärd_1_N = mkN "blåkullafärd" "blåkullafärder" ; -- blåkullafärd..nn.1
  blåkål_1_N = mkN "blåkål" ; -- blåkål..nn.1
  blåköra_1_V = mkV "blåköra" "blåkörde" "blåkört" ; -- blåköra..vb.1
  blåkörande_1_N = mkN "blåkörande" ; -- blåkörande..nn.1
  blålera_1_N = mkN "blålera" ; -- blålera..nn.1
  blålila_1_A = mkA "blålila" ; -- blålila..av.1
  blåljuga_1_V = mkV "blåljuga" "blåljög" "blåljugit" ; -- blåljuga..vb.1
  blåljus_1_N = mkN "blåljus" neutrum  ; -- blåljus..nn.1
  blålusern_1_N = mkN "blålusern" ; -- blålusern..nn.1
  blåmes_1_N = mkN "blåmes" ; -- blåmes..nn.1
  blåmusseron_1_N = mkN "blåmusseron" "blåmusseroner" ; -- blåmusseron..nn.1
  blåmussla_1_N = mkN "blåmussla" ; -- blåmussla..nn.1
  blåmärke_1_N = mkN "blåmärke" ; -- blåmärke..nn.1
  blåmålad_1_A = mkA "blåmålad" ; -- blåmålad..av.1
  blåmålning_1_N = mkN "blåmålning" ; -- blåmålning..nn.1
  blåna_1_V = mkV "blånar" ; -- blåna..vb.1
  blånad_1_N = mkN "blånad" "blånader" ; -- blånad..nn.1
  blånande_1_N = mkN "blånande" ; -- blånande..nn.1
  blåneka_1_V = mkV "blånekar" ; -- blåneka..vb.1
  blånekande_1_N = mkN "blånekande" ; -- blånekande..nn.1
  blåpenna_1_N = mkN "blåpenna" ; -- blåpenna..nn.1
  blåprickig_1_A = mkA "blåprickig" ; -- blåprickig..av.1
  blårandig_1_A = mkA "blårandig" ; -- blårandig..av.1
  blåregn_1_N = mkN "blåregn" neutrum  ; -- blåregn..nn.1
  blårutig_1_A = mkA "blårutig" ; -- blårutig..av.1
  blåräv_1_N = mkN "blåräv" ; -- blåräv..nn.1
  blåröd_1_A = mkA "blåröd" "blårött" ; -- blåröd..av.1
  blåsa_1_N = mkN "blåsa" ; -- blåsa..nn.1
  blåsa_1_V = mkV "blåser" ; -- blåsa..vb.1
  blåsa_2_V = mkV "blåser" ; -- blåsa..vb.2
  blåsande_1_N = mkN "blåsande" ; -- blåsande..nn.1
  blåsare_1_N = mkN "blåsare" utrum  ; -- blåsare..nn.1
  blåsbälg_1_N = mkN "blåsbälg" ; -- blåsbälg..nn.1
  blåsfoting_1_N = mkN "blåsfoting" ; -- blåsfoting..nn.1
  blåshals_1_N = mkN "blåshals" ; -- blåshals..nn.1
  blåshalskörtel_1_N = mkN "blåshalskörtel" ; -- blåshalskörtel..nn.1
  blåshål_1_N = mkN "blåshål" neutrum  ; -- blåshål..nn.1
  blåsig_1_A = mkA "blåsig" ; -- blåsig..av.1
  blåsinstrument_1_N = mkN "blåsinstrument" neutrum  ; -- blåsinstrument..nn.1
  blåsippa_1_N = mkN "blåsippa" ; -- blåsippa..nn.1
  blåsjuka_1_N = mkN "blåsjuka" ; -- blåsjuka..nn.1
  blåskatarr_1_N = mkN "blåskatarr" "blåskatarrer" ; -- blåskatarr..nn.1
  blåskimrande_1_A = mkA "blåskimrande" ; -- blåskimrande..av.1
  blåslagen_1_A = mkA "blåslagen" ; -- blåslagen..av.1
  blåslampa_1_N = mkN "blåslampa" ; -- blåslampa..nn.1
  blåsljud_1_N = mkN "blåsljud" neutrum  ; -- blåsljud..nn.1
  blåsmask_1_N = mkN "blåsmask" ; -- blåsmask..nn.1
  blåsning_1_N = mkN "blåsning" ; -- blåsning..nn.1
  blåsorkester_1_N = mkN "blåsorkester" ; -- blåsorkester..nn.1
  blåspistol_1_N = mkN "blåspistol" "blåspistoler" ; -- blåspistol..nn.1
  blåsprit_1_N = mkN "blåsprit" ; -- blåsprit..nn.1
  blåsrör_1_N = mkN "blåsrör" neutrum  ; -- blåsrör..nn.1
  blåssten_1_N = mkN "blåssten" "blåsstenen" "blåsstenar" "blåsstenarna" ; -- blåssten..nn.1
  blåst_1_A = mkA "blåst" "blåst" ; -- blåst..av.1
  blåst_1_N = mkN "blåst" ; -- blåst..nn.1
  blåsthet_1_N = mkN "blåsthet" ; -- blåsthet..nn.1
  blåstrumpa_1_N = mkN "blåstrumpa" ; -- blåstrumpa..nn.1
  blåställ_1_N = mkN "blåställ" neutrum  ; -- blåställ..nn.1
  blåstång_1_N = mkN "blåstång" ; -- blåstång..nn.1
  blåsur_1_A = mkA "blåsur" ; -- blåsur..av.1
  blåsurhet_1_N = mkN "blåsurhet" ; -- blåsurhet..nn.1
  blåsvart_1_A = mkA "blåsvart" "blåsvart" ; -- blåsvart..av.1
  blåsväder_1_N = mkN "blåsväder" neutrum  ; -- blåsväder..nn.1
  blåsyra_1_N = mkN "blåsyra" ; -- blåsyra..nn.1
  blåsört_1_N = mkN "blåsört" ; -- blåsört..nn.1
  blåtira_1_N = mkN "blåtira" ; -- blåtira..nn.1
  blåtonad_1_A = mkA "blåtonad" ; -- blåtonad..av.1
  blåträ_1_N = mkN "blåträ" neutrum  ; -- blåträ..nn.1
  blåtunga_1_N = mkN "blåtunga" ; -- blåtunga..nn.1
  blåtåtel_1_N = mkN "blåtåtel" ; -- blåtåtel..nn.1
  blåval_1_N = mkN "blåval" ; -- blåval..nn.1
  blåvarm_1_A = mkA "blåvarm" ; -- blåvarm..av.1
  blåved_1_N = mkN "blåved" ; -- blåved..nn.1
  blåvinge_1_N = mkN "blåvinge" utrum  ; -- blåvinge..nn.1
  blåviolett_1_A = mkA "blåviolett" ; -- blåviolett..av.1
  blåvit_1_A = mkA "blåvit" ; -- blåvit..av.1
  blåvitling_1_N = mkN "blåvitling" ; -- blåvitling..nn.1
  blåvärme_1_N = mkN "blåvärme" utrum  ; -- blåvärme..nn.1
  blåögd_1_A = mkA "blåögd" "blåögt" ; -- blåögd..av.1
  blåögdhet_1_N = mkN "blåögdhet" ; -- blåögdhet..nn.1
  blöda_1_V = mkV "blöda" "blödde" "blött" ; -- blöda..vb.1
  blödande_1_N = mkN "blödande" ; -- blödande..nn.1
  blödare_1_N = mkN "blödare" utrum  ; -- blödare..nn.1
  blödarsjuka_1_N = mkN "blödarsjuka" ; -- blödarsjuka..nn.1
  blödig_1_A = mkA "blödig" ; -- blödig..av.1
  blödighet_1_N = mkN "blödighet" "blödigheter" ; -- blödighet..nn.1
  blödning_1_N = mkN "blödning" ; -- blödning..nn.1
  blöja_1_N = mkN "blöja" ; -- blöja..nn.1
  blöjbyte_1_N = mkN "blöjbyte" ; -- blöjbyte..nn.1
  blöjålder_1_N = mkN "blöjålder" ; -- blöjålder..nn.1
  blöt_1_A = mkA "blöt" ; -- blöt..av.1
  blöta_1_N = mkN "blöta" ; -- blöta..nn.1
  blöta_1_V = mkV "blöter" ; -- blöta..vb.1
  blötande_1_N = mkN "blötande" ; -- blötande..nn.1
  blötdjur_1_N = mkN "blötdjur" neutrum  ; -- blötdjur..nn.1
  blötfoder_1_N = mkN "blötfoder" neutrum  ; -- blötfoder..nn.1
  blöthet_1_N = mkN "blöthet" ; -- blöthet..nn.1
  blötlägga_1_V = mkV "blötlägga" "blötla" "blötlagt" ; -- blötlägga..vb.1
  blötläggande_1_N = mkN "blötläggande" ; -- blötläggande..nn.1
  blötläggning_1_N = mkN "blötläggning" ; -- blötläggning..nn.1
  blötläggningsmedel_1_N = mkN "blötläggningsmedel" neutrum  ; -- blötläggningsmedel..nn.1
  blötna_1_V = mkV "blötnar" ; -- blötna..vb.1
  blötnande_1_N = mkN "blötnande" ; -- blötnande..nn.1
  blötning_1_N = mkN "blötning" ; -- blötning..nn.1
  blötröta_1_N = mkN "blötröta" ; -- blötröta..nn.1
  blötsnö_1_N = mkN "blötsnö" ; -- blötsnö..nn.1
  blötsvart_1_A = mkA "blötsvart" "blötsvart" ; -- blötsvart..av.1
  bo_1_N = mkN "bo" "boet" "bon" "bona" ; -- bo..nn.1
  bo_1_V = mkV "bor" ; -- bo..vb.1
  boa_1_N = mkN "boa" ; -- boa..nn.1
  boaorm_1_N = mkN "boaorm" ; -- boaorm..nn.1
  board_1_N = mkN "board" ; -- board..nn.1
  boardingcard_1_N = mkN "boardingcard" neutrum  ; -- boardingcard..nn.1
  boardingkort_1_N = mkN "boardingkort" neutrum  ; -- boardingkort..nn.1
  boasera_1_V = mkV "boaserar" ; -- boasera..vb.1
  boaserande_1_N = mkN "boaserande" ; -- boaserande..nn.1
  boaserbar_1_A = mkA "boaserbar" ; -- boaserbar..av.1
  boaserbarhet_1_N = mkN "boaserbarhet" ; -- boaserbarhet..nn.1
  boasering_1_N = mkN "boasering" ; -- boasering..nn.1
  bob_1_N = mkN "bob" ; -- bob..nn.1
  bobb_1_N = mkN "bobb" ; -- bobb..nn.1
  bobba_1_N = mkN "bobba" ; -- bobba..nn.1
  bobba_1_V = mkV "bobbar" ; -- bobba..vb.1
  bobbande_1_N = mkN "bobbande" ; -- bobbande..nn.1
  bobin_1_N = mkN "bobin" "bobiner" ; -- bobin..nn.1
  boboll_1_N = mkN "boboll" ; -- boboll..nn.1
  boboll_2_N = mkN "boboll" ; -- boboll..nn.2
  bobsleigh_1_N = mkN "bobsleigh" ; -- bobsleigh..nn.1
  boccia_1_N = mkN "boccia" ; -- boccia..nn.1
  bock_1_N = mkN "bock" ; -- bock..nn.1
  bocka_1_V = mkV "bockar" ; -- bocka..vb.1
  bockande_1_N = mkN "bockande" ; -- bockande..nn.1
  bockbent_1_A = mkA "bockbent" "bockbent" ; -- bockbent..av.1
  bockbenthet_1_N = mkN "bockbenthet" ; -- bockbenthet..nn.1
  bockblad_1_N = mkN "bockblad" neutrum  ; -- bockblad..nn.1
  bockbro_1_N = mkN "bockbro" ; -- bockbro..nn.1
  bockbränning_1_N = mkN "bockbränning" ; -- bockbränning..nn.1
  bockfot_1_N = mkN "bockfot" "bockfötter" ; -- bockfot..nn.1
  bockhorn_1_N = mkN "bockhorn" neutrum  ; -- bockhorn..nn.1
  bockhornsklöver_1_N = mkN "bockhornsklöver" ; -- bockhornsklöver..nn.1
  bockhornsklöverfrö_1_N = mkN "bockhornsklöverfrö" "bockhornsklöverfröet" "bockhornsklöverfrön" "bockhornsklöverfröna" ; -- bockhornsklöverfrö..nn.1
  bockning_1_N = mkN "bockning" ; -- bockning..nn.1
  bockprov_1_N = mkN "bockprov" neutrum  ; -- bockprov..nn.1
  bockskägg_1_N = mkN "bockskägg" neutrum  ; -- bockskägg..nn.1
  bocksprång_1_N = mkN "bocksprång" neutrum  ; -- bocksprång..nn.1
  bocktörne_1_N = mkN "bocktörne" ; -- bocktörne..nn.1
  bockverktyg_1_N = mkN "bockverktyg" neutrum  ; -- bockverktyg..nn.1
  bockvinkel_1_N = mkN "bockvinkel" ; -- bockvinkel..nn.1
  bocköl_1_N = mkN "bocköl" neutrum  ; -- bocköl..nn.1
  bod_1_N = mkN "bod" ; -- bod..nn.1
  bodbetjänt_1_N = mkN "bodbetjänt" "bodbetjänter" ; -- bodbetjänt..nn.1
  bodega_1_N = mkN "bodega" ; -- bodega..nn.1
  bodelning_1_N = mkN "bodelning" ; -- bodelning..nn.1
  bodknodd_1_N = mkN "bodknodd" ; -- bodknodd..nn.1
  bodlänga_1_N = mkN "bodlänga" ; -- bodlänga..nn.1
  bodmeri_1_N = mkN "bodmeri" "bodmeriet" "bodmerier" "bodmerierna" ; -- bodmeri..nn.1
  bodräkt_1_N = mkN "bodräkt" ; -- bodräkt..nn.1
  bodybuilding_1_N = mkN "bodybuilding" ; -- bodybuilding..nn.1
  boende_1_N = mkN "boende" ; -- boende..nn.1
  boende_2_N = mkN "boende" "boenden" "boende" "boendena" ; -- boende..nn.2
  boendeform_1_N = mkN "boendeform" "boendeformer" ; -- boendeform..nn.1
  boendekostnad_1_N = mkN "boendekostnad" "boendekostnader" ; -- boendekostnad..nn.1
  boendesegregering_1_N = mkN "boendesegregering" ; -- boendesegregering..nn.1
  boer_1_N = mkN "boer" "boern" "boer" "boerna" ; -- boer..nn.1
  boett_1_N = mkN "boett" "boetter" ; -- boett..nn.1
  boettlås_1_N = mkN "boettlås" ; -- boettlås..nn.1
  bofast_1_A = mkA "bofast" "bofast" ; -- bofast..av.1
  bofasthet_1_N = mkN "bofasthet" ; -- bofasthet..nn.1
  bofink_1_N = mkN "bofink" ; -- bofink..nn.1
  bofinksdrill_1_N = mkN "bofinksdrill" ; -- bofinksdrill..nn.1
  bofinkssång_1_N = mkN "bofinkssång" "bofinkssånger" ; -- bofinkssång..nn.1
  bofällig_1_A = mkA "bofällig" ; -- bofällig..av.1
  bofällighet_1_N = mkN "bofällighet" ; -- bofällighet..nn.1
  bog_1_N = mkN "bog" ; -- bog..nn.1
  bogankare_1_N = mkN "bogankare" "bogankaret" "bogankaren" "bogankarna" ; -- bogankare..nn.1
  bogblad_1_N = mkN "bogblad" neutrum  ; -- bogblad..nn.1
  bogbruten_1_A = mkA "bogbruten" ; -- bogbruten..av.1
  boggi_1_N = mkN "boggi" "boggin" "boggier" "boggierna" ; -- boggi..nn.1
  boggitryck_1_N = mkN "boggitryck" neutrum  ; -- boggitryck..nn.1
  boghalt_1_A = mkA "boghalt" "boghalt" ; -- boghalt..av.1
  boghöjd_1_N = mkN "boghöjd" "boghöjder" ; -- boghöjd..nn.1
  bogpropeller_1_N = mkN "bogpropeller" ; -- bogpropeller..nn.1
  bogsera_1_V = mkV "bogserar" ; -- bogsera..vb.1
  bogserande_1_N = mkN "bogserande" ; -- bogserande..nn.1
  bogserare_1_N = mkN "bogserare" utrum  ; -- bogserare..nn.1
  bogserbar_1_A = mkA "bogserbar" ; -- bogserbar..av.1
  bogserbarhet_1_N = mkN "bogserbarhet" ; -- bogserbarhet..nn.1
  bogserbåt_1_N = mkN "bogserbåt" ; -- bogserbåt..nn.1
  bogsergalge_1_N = mkN "bogsergalge" utrum  ; -- bogsergalge..nn.1
  bogsering_1_N = mkN "bogsering" ; -- bogsering..nn.1
  bogserlina_1_N = mkN "bogserlina" ; -- bogserlina..nn.1
  bogsersläp_1_N = mkN "bogsersläp" neutrum  ; -- bogsersläp..nn.1
  bogsertross_1_N = mkN "bogsertross" ; -- bogsertross..nn.1
  bogspröt_1_N = mkN "bogspröt" neutrum  ; -- bogspröt..nn.1
  bogvisir_1_N = mkN "bogvisir" neutrum  ; -- bogvisir..nn.1
  bogvåg_1_N = mkN "bogvåg" "bogvågor" ; -- bogvåg..nn.1
  bogvågsknall_1_N = mkN "bogvågsknall" ; -- bogvågsknall..nn.1
  bohag_1_N = mkN "bohag" neutrum  ; -- bohag..nn.1
  bohagsförteckning_1_N = mkN "bohagsförteckning" ; -- bohagsförteckning..nn.1
  bohem_1_N = mkN "bohem" "bohemer" ; -- bohem..nn.1
  bohemartad_1_A = mkA "bohemartad" ; -- bohemartad..av.1
  bohemisk_1_A = mkA "bohemisk" ; -- bohemisk..av.1
  bohemliv_1_N = mkN "bohemliv" neutrum  ; -- bohemliv..nn.1
  bohuseka_1_N = mkN "bohuseka" ; -- bohuseka..nn.1
  bohusläning_1_N = mkN "bohusläning" ; -- bohusläning..nn.1
  bohuslänning_1_N = mkN "bohuslänning" ; -- bohuslänning..nn.1
  bohuslänsk_1_A = mkA "bohuslänsk" ; -- bohuslänsk..av.1
  bohuslänska_1_N = mkN "bohuslänska" ; -- bohuslänska..nn.1
  bohuslänska_2_N = mkN "bohuslänska" ; -- bohuslänska..nn.2
  boj_1_N = mkN "boj" ; -- boj..nn.1
  boj_2_N = mkN "boj" "bojer" ; -- boj..nn.2
  boja_1_N = mkN "boja" ; -- boja..nn.1
  bojar_1_N = mkN "bojar" "bojarer" ; -- bojar..nn.1
  bojkott_1_N = mkN "bojkott" "bojkotter" ; -- bojkott..nn.1
  bojkotta_1_V = mkV "bojkottar" ; -- bojkotta..vb.1
  bojkottande_1_N = mkN "bojkottande" ; -- bojkottande..nn.1
  bojkottning_1_N = mkN "bojkottning" ; -- bojkottning..nn.1
  bok_1_N = mkN "bok" "böcker" ; -- bok..nn.1
  bok_2_N = mkN "bok" ; -- bok..nn.2
  boka_1_V = mkV "bokar" ; -- boka..vb.1
  bokande_1_N = mkN "bokande" ; -- bokande..nn.1
  bokanmälan_1_N = mkN "bokanmälan" "bokanmälan" "bokanmälningar" "bokanmälningarna" ; -- bokanmälan..nn.1
  bokauktion_1_N = mkN "bokauktion" ; -- bokauktion..nn.1
  bokband_1_N = mkN "bokband" neutrum  ; -- bokband..nn.1
  bokbindare_1_N = mkN "bokbindare" utrum  ; -- bokbindare..nn.1
  bokbinderi_1_N = mkN "bokbinderi" "bokbinderiet" "bokbinderier" "bokbinderierna" ; -- bokbinderi..nn.1
  bokbindning_1_N = mkN "bokbindning" ; -- bokbindning..nn.1
  bokbränning_1_N = mkN "bokbränning" ; -- bokbränning..nn.1
  bokbuss_1_N = mkN "bokbuss" ; -- bokbuss..nn.1
  bokcirkel_1_N = mkN "bokcirkel" ; -- bokcirkel..nn.1
  bokdamm_1_N = mkN "bokdamm" ; -- bokdamm..nn.1
  boke_1_N = mkN "boke" ; -- boke..nn.1
  boken_1_A = mkA "boken" ; -- boken..av.1
  bokenhet_1_N = mkN "bokenhet" ; -- bokenhet..nn.1
  bokfilm_1_N = mkN "bokfilm" "bokfilmer" ; -- bokfilm..nn.1
  bokflod_1_N = mkN "bokflod" "bokfloder" ; -- bokflod..nn.1
  bokform_1_N = mkN "bokform" ; -- bokform..nn.1
  bokformat_1_N = mkN "bokformat" neutrum  ; -- bokformat..nn.1
  bokföra_1_V = mkV "bokföra" "bokförde" "bokfört" ; -- bokföra..vb.1
  bokförande_1_N = mkN "bokförande" ; -- bokförande..nn.1
  bokförare_1_N = mkN "bokförare" utrum  ; -- bokförare..nn.1
  bokföring_1_N = mkN "bokföring" ; -- bokföring..nn.1
  bokföringsbrott_1_N = mkN "bokföringsbrott" neutrum  ; -- bokföringsbrott..nn.1
  bokföringsmässig_1_A = mkA "bokföringsmässig" ; -- bokföringsmässig..av.1
  bokföringsmässighet_1_N = mkN "bokföringsmässighet" ; -- bokföringsmässighet..nn.1
  bokföringsplikt_1_N = mkN "bokföringsplikt" ; -- bokföringsplikt..nn.1
  bokföringsskyldig_1_A = mkA "bokföringsskyldig" ; -- bokföringsskyldig..av.1
  bokföringsskyldighet_1_N = mkN "bokföringsskyldighet" "bokföringsskyldigheter" ; -- bokföringsskyldighet..nn.1
  bokföringsår_1_N = mkN "bokföringsår" neutrum  ; -- bokföringsår..nn.1
  bokförlag_1_N = mkN "bokförlag" neutrum  ; -- bokförlag..nn.1
  bokförläggare_1_N = mkN "bokförläggare" utrum  ; -- bokförläggare..nn.1
  bokförråd_1_N = mkN "bokförråd" neutrum  ; -- bokförråd..nn.1
  bokhandel_1_N = mkN "bokhandel" ; -- bokhandel..nn.1
  bokhandelsdisk_1_N = mkN "bokhandelsdisk" ; -- bokhandelsdisk..nn.1
  bokhandlare_1_N = mkN "bokhandlare" utrum  ; -- bokhandlare..nn.1
  bokhantverk_1_N = mkN "bokhantverk" neutrum  ; -- bokhantverk..nn.1
  bokhylla_1_N = mkN "bokhylla" ; -- bokhylla..nn.1
  bokhållare_1_N = mkN "bokhållare" utrum  ; -- bokhållare..nn.1
  bokhålleri_1_N = mkN "bokhålleri" neutrum  ; -- bokhålleri..nn.1
  bokkasse_1_N = mkN "bokkasse" utrum  ; -- bokkasse..nn.1
  bokkatalog_1_N = mkN "bokkatalog" "bokkataloger" ; -- bokkatalog..nn.1
  bokklubb_1_N = mkN "bokklubb" ; -- bokklubb..nn.1
  bokkännare_1_N = mkN "bokkännare" utrum  ; -- bokkännare..nn.1
  boklig_1_A = mkA "boklig" ; -- boklig..av.1
  boklighet_1_N = mkN "boklighet" ; -- boklighet..nn.1
  boklärd_1_A = mkA "boklärd" "boklärt" ; -- boklärd..av.1
  boklärdhet_1_N = mkN "boklärdhet" ; -- boklärdhet..nn.1
  boklärdom_1_N = mkN "boklärdom" ; -- boklärdom..nn.1
  bokläsande_1_A = mkA "bokläsande" ; -- bokläsande..av.1
  bokläsande_1_N = mkN "bokläsande" ; -- bokläsande..nn.1
  boklåda_1_N = mkN "boklåda" ; -- boklåda..nn.1
  boklån_1_N = mkN "boklån" neutrum  ; -- boklån..nn.1
  bokmagasin_1_N = mkN "bokmagasin" neutrum  ; -- bokmagasin..nn.1
  bokmakulatur_1_N = mkN "bokmakulatur" ; -- bokmakulatur..nn.1
  bokmal_1_N = mkN "bokmal" ; -- bokmal..nn.1
  bokmarknad_1_N = mkN "bokmarknad" "bokmarknader" ; -- bokmarknad..nn.1
  bokmärke_1_N = mkN "bokmärke" ; -- bokmärke..nn.1
  bokmässa_1_N = mkN "bokmässa" ; -- bokmässa..nn.1
  bokmål_1_N = mkN "bokmål" neutrum  ; -- bokmål..nn.1
  bokna_1_V = mkV "boknar" ; -- bokna..vb.1
  boknande_1_N = mkN "boknande" ; -- boknande..nn.1
  bokning_1_N = mkN "bokning" ; -- bokning..nn.1
  bokollon_1_N = mkN "bokollon" neutrum  ; -- bokollon..nn.1
  bokomslag_1_N = mkN "bokomslag" neutrum  ; -- bokomslag..nn.1
  bokpärm_1_N = mkN "bokpärm" ; -- bokpärm..nn.1
  bokrad_1_N = mkN "bokrad" "bokrader" ; -- bokrad..nn.1
  bokrea_1_N = mkN "bokrea" ; -- bokrea..nn.1
  bokrulle_1_N = mkN "bokrulle" utrum  ; -- bokrulle..nn.1
  bokrygg_1_N = mkN "bokrygg" ; -- bokrygg..nn.1
  boksamlare_1_N = mkN "boksamlare" utrum  ; -- boksamlare..nn.1
  boksamling_1_N = mkN "boksamling" ; -- boksamling..nn.1
  boksida_1_N = mkN "boksida" ; -- boksida..nn.1
  bokskatt_1_N = mkN "bokskatt" "bokskatter" ; -- bokskatt..nn.1
  bokskog_1_N = mkN "bokskog" ; -- bokskog..nn.1
  bokskrivande_1_A = mkA "bokskrivande" ; -- bokskrivande..av.1
  bokskrivande_1_N = mkN "bokskrivande" ; -- bokskrivande..nn.1
  bokskåp_1_N = mkN "bokskåp" neutrum  ; -- bokskåp..nn.1
  bokslukare_1_N = mkN "bokslukare" utrum  ; -- bokslukare..nn.1
  bokslut_1_N = mkN "bokslut" neutrum  ; -- bokslut..nn.1
  bokspråk_1_N = mkN "bokspråk" neutrum  ; -- bokspråk..nn.1
  bokstav_1_N = mkN "bokstav" "bokstäver" ; -- bokstav..nn.1
  bokstavera_1_V = mkV "bokstaverar" ; -- bokstavera..vb.1
  bokstaverande_1_N = mkN "bokstaverande" ; -- bokstaverande..nn.1
  bokstaverbar_1_A = mkA "bokstaverbar" ; -- bokstaverbar..av.1
  bokstaverbarhet_1_N = mkN "bokstaverbarhet" ; -- bokstaverbarhet..nn.1
  bokstavering_1_N = mkN "bokstavering" ; -- bokstavering..nn.1
  bokstavlig_1_A = mkA "bokstavlig" ; -- bokstavlig..av.1
  bokstavligen_1_Adv = mkAdv "bokstavligen" ; -- bokstavligen..ab.1
  bokstavlighet_1_N = mkN "bokstavlighet" "bokstavligheter" ; -- bokstavlighet..nn.1
  bokstavsbarn_1_N = mkN "bokstavsbarn" neutrum  ; -- bokstavsbarn..nn.1
  bokstavsbeteckning_1_N = mkN "bokstavsbeteckning" ; -- bokstavsbeteckning..nn.1
  bokstavsdiagnos_1_N = mkN "bokstavsdiagnos" "bokstavsdiagnoser" ; -- bokstavsdiagnos..nn.1
  bokstavsföljd_1_N = mkN "bokstavsföljd" "bokstavsföljder" ; -- bokstavsföljd..nn.1
  bokstavsinspiration_1_N = mkN "bokstavsinspiration" ; -- bokstavsinspiration..nn.1
  bokstavsmystik_1_N = mkN "bokstavsmystik" ; -- bokstavsmystik..nn.1
  bokstavsordning_1_N = mkN "bokstavsordning" ; -- bokstavsordning..nn.1
  bokstavsrim_1_N = mkN "bokstavsrim" "bokstavsrimmet" "bokstavsrim" "bokstavsrimmen" ; -- bokstavsrim..nn.1
  bokstavssallad_1_N = mkN "bokstavssallad" ; -- bokstavssallad..nn.1
  bokstavsskrift_1_N = mkN "bokstavsskrift" ; -- bokstavsskrift..nn.1
  bokstavsstans_1_N = mkN "bokstavsstans" ; -- bokstavsstans..nn.1
  bokstavstecken_1_N = mkN "bokstavstecken" "bokstavstecknet" "bokstavstecken" "bokstavstecknen" ; -- bokstavstecken..nn.1
  bokstavstro_1_N = mkN "bokstavstro" ; -- bokstavstro..nn.1
  bokstavstrogen_1_A = mkA "bokstavstrogen" ; -- bokstavstrogen..av.1
  bokstavstrogenhet_1_N = mkN "bokstavstrogenhet" ; -- bokstavstrogenhet..nn.1
  bokstavsträl_1_N = mkN "bokstavsträl" ; -- bokstavsträl..nn.1
  bokstavsvuxen_1_A = mkA "bokstavsvuxen" ; -- bokstavsvuxen..av.1
  bokstipendium_1_N = mkN "bokstipendium" "bokstipendiet" "bokstipendier" "bokstipendierna" ; -- bokstipendium..nn.1
  bokställ_1_N = mkN "bokställ" neutrum  ; -- bokställ..nn.1
  bokstöd_1_N = mkN "bokstöd" neutrum  ; -- bokstöd..nn.1
  boksynt_1_A = mkA "boksynt" "boksynt" ; -- boksynt..av.1
  boksynthet_1_N = mkN "boksynthet" ; -- boksynthet..nn.1
  boktitel_1_N = mkN "boktitel" ; -- boktitel..nn.1
  boktorn_1_N = mkN "boktorn" neutrum  ; -- boktorn..nn.1
  boktrave_1_N = mkN "boktrave" utrum  ; -- boktrave..nn.1
  boktryck_1_N = mkN "boktryck" neutrum  ; -- boktryck..nn.1
  boktryckare_1_N = mkN "boktryckare" utrum  ; -- boktryckare..nn.1
  boktryckarkonst_1_N = mkN "boktryckarkonst" ; -- boktryckarkonst..nn.1
  boktryckeri_1_N = mkN "boktryckeri" "boktryckeriet" "boktryckerier" "boktryckerierna" ; -- boktryckeri..nn.1
  boktrycksstil_1_N = mkN "boktrycksstil" ; -- boktrycksstil..nn.1
  bokuppslag_1_N = mkN "bokuppslag" neutrum  ; -- bokuppslag..nn.1
  bokval_1_N = mkN "bokval" neutrum  ; -- bokval..nn.1
  bokverk_1_N = mkN "bokverk" neutrum  ; -- bokverk..nn.1
  bokversion_1_N = mkN "bokversion" ; -- bokversion..nn.1
  bokvurm_1_N = mkN "bokvurm" ; -- bokvurm..nn.1
  bokvän_1_N = mkN "bokvän" "bokvännen" "bokvänner" "bokvännerna" ; -- bokvän..nn.1
  bokälskare_1_N = mkN "bokälskare" utrum  ; -- bokälskare..nn.1
  bol_1_N = mkN "bol" neutrum  ; -- bol..nn.1
  bola_1_V = mkV "bolar" ; -- bola..vb.1
  bolag_1_N = mkN "bolag" neutrum  ; -- bolag..nn.1
  bolagisera_1_V = mkV "bolagiserar" ; -- bolagisera..vb.1
  bolagiserande_1_N = mkN "bolagiserande" ; -- bolagiserande..nn.1
  bolagiserbar_1_A = mkA "bolagiserbar" ; -- bolagiserbar..av.1
  bolagisering_1_N = mkN "bolagisering" ; -- bolagisering..nn.1
  bolagsman_1_N = mkN "bolagsman" "bolagsmannen" "bolagsmän" "bolagsmännen" ; -- bolagsman..nn.1
  bolagsordning_1_N = mkN "bolagsordning" ; -- bolagsordning..nn.1
  bolagsskog_1_N = mkN "bolagsskog" ; -- bolagsskog..nn.1
  bolagsstyrelse_1_N = mkN "bolagsstyrelse" "bolagsstyrelser" ; -- bolagsstyrelse..nn.1
  bolagsstämma_1_N = mkN "bolagsstämma" ; -- bolagsstämma..nn.1
  bolagsägare_1_N = mkN "bolagsägare" utrum  ; -- bolagsägare..nn.1
  bolande_1_N = mkN "bolande" ; -- bolande..nn.1
  bolare_1_N = mkN "bolare" utrum  ; -- bolare..nn.1
  boleri_1_N = mkN "boleri" neutrum  ; -- boleri..nn.1
  bolero_1_N = mkN "bolero" "boleron" "boleroer" "boleroerna" ; -- bolero..nn.1
  bolid_1_N = mkN "bolid" "bolider" ; -- bolid..nn.1
  bolin_1_N = mkN "bolin" "boliner" ; -- bolin..nn.1
  bolivian_1_N = mkN "bolivian" "bolivianer" ; -- bolivian..nn.1
  boliviansk_1_A = mkA "boliviansk" ; -- boliviansk..av.1
  bolivianska_1_N = mkN "bolivianska" ; -- bolivianska..nn.1
  boll_1_N = mkN "boll" ; -- boll..nn.1
  bolla_1_V = mkV "bollar" ; -- bolla..vb.1
  bollande_1_N = mkN "bollande" ; -- bollande..nn.1
  bollbehandling_1_N = mkN "bollbehandling" ; -- bollbehandling..nn.1
  bollhav_1_N = mkN "bollhav" neutrum  ; -- bollhav..nn.1
  bollhus_1_N = mkN "bollhus" neutrum  ; -- bollhus..nn.1
  bollkalle_1_N = mkN "bollkalle" utrum  ; -- bollkalle..nn.1
  bollkastning_1_N = mkN "bollkastning" ; -- bollkastning..nn.1
  bollning_1_N = mkN "bollning" ; -- bollning..nn.1
  bollplan_1_N = mkN "bollplan" "bollplaner" ; -- bollplan..nn.1
  bollplank_1_N = mkN "bollplank" neutrum  ; -- bollplank..nn.1
  bollpojke_1_N = mkN "bollpojke" utrum  ; -- bollpojke..nn.1
  bollsinne_1_N = mkN "bollsinne" ; -- bollsinne..nn.1
  bollspel_1_N = mkN "bollspel" "bollspelet" "bollspel" "bollspelen" ; -- bollspel..nn.1
  bollspelare_1_N = mkN "bollspelare" utrum  ; -- bollspelare..nn.1
  bollträ_1_N = mkN "bollträ" "bollträt" "bollträn" "bollträna" ; -- bollträ..nn.1
  bolma_1_V = mkV "bolmar" ; -- bolma..vb.1
  bolmande_1_N = mkN "bolmande" ; -- bolmande..nn.1
  bolmört_1_N = mkN "bolmört" ; -- bolmört..nn.1
  bolmörtsgift_1_N = mkN "bolmörtsgift" neutrum  ; -- bolmörtsgift..nn.1
  bolmörtsskivling_1_N = mkN "bolmörtsskivling" ; -- bolmörtsskivling..nn.1
  bolsjevik_1_N = mkN "bolsjevik" "bolsjeviker" ; -- bolsjevik..nn.1
  bolsjevikisk_1_A = mkA "bolsjevikisk" ; -- bolsjevikisk..av.1
  bolsjevism_1_N = mkN "bolsjevism" "bolsjevismer" ; -- bolsjevism..nn.1
  bolsjevistisk_1_A = mkA "bolsjevistisk" ; -- bolsjevistisk..av.1
  bolster_1_N = mkN "bolster" ; -- bolster..nn.1
  bolsterstock_1_N = mkN "bolsterstock" ; -- bolsterstock..nn.1
  bolstervagn_1_N = mkN "bolstervagn" ; -- bolstervagn..nn.1
  bolstervar_1_N = mkN "bolstervar" neutrum  ; -- bolstervar..nn.1
  bolån_1_N = mkN "bolån" neutrum  ; -- bolån..nn.1
  bolånekris_1_N = mkN "bolånekris" "bolånekriser" ; -- bolånekris..nn.1
  bolånekund_1_N = mkN "bolånekund" "bolånekunder" ; -- bolånekund..nn.1
  bolåneränta_1_N = mkN "bolåneränta" ; -- bolåneränta..nn.1
  bom_1_N = mkN "bom" "bommen" "bommar" "bommarna" ; -- bom..nn.1
  bomaterial_1_N = mkN "bomaterial" neutrum  ; -- bomaterial..nn.1
  bomb_1_N = mkN "bomb" "bomber" ; -- bomb..nn.1
  bomba_1_V = mkV "bombar" ; -- bomba..vb.1
  bombad_1_A = mkA "bombad" ; -- bombad..av.1
  bombande_1_N = mkN "bombande" ; -- bombande..nn.1
  bombanfall_1_N = mkN "bombanfall" neutrum  ; -- bombanfall..nn.1
  bombardemang_1_N = mkN "bombardemang" neutrum  ; -- bombardemang..nn.1
  bombardera_1_V = mkV "bombarderar" ; -- bombardera..vb.1
  bombarderande_1_N = mkN "bombarderande" ; -- bombarderande..nn.1
  bombarderbar_1_A = mkA "bombarderbar" ; -- bombarderbar..av.1
  bombarderbarhet_1_N = mkN "bombarderbarhet" ; -- bombarderbarhet..nn.1
  bombardering_1_N = mkN "bombardering" ; -- bombardering..nn.1
  bombare_1_N = mkN "bombare" utrum  ; -- bombare..nn.1
  bombasm_1_N = mkN "bombasm" "bombasmer" ; -- bombasm..nn.1
  bombastisk_1_A = mkA "bombastisk" ; -- bombastisk..av.1
  bombattack_1_N = mkN "bombattack" "bombattacker" ; -- bombattack..nn.1
  bombattentat_1_N = mkN "bombattentat" neutrum  ; -- bombattentat..nn.1
  bombdåd_1_N = mkN "bombdåd" neutrum  ; -- bombdåd..nn.1
  bombering_1_N = mkN "bombering" ; -- bombering..nn.1
  bombfast_1_A = mkA "bombfast" "bombfast" ; -- bombfast..av.1
  bombfasthet_1_N = mkN "bombfasthet" ; -- bombfasthet..nn.1
  bombflyg_1_N = mkN "bombflyg" neutrum  ; -- bombflyg..nn.1
  bombfri_1_A = mkA "bombfri" "bombfritt" ; -- bombfri..av.1
  bombfällning_1_N = mkN "bombfällning" ; -- bombfällning..nn.1
  bombhot_1_N = mkN "bombhot" neutrum  ; -- bombhot..nn.1
  bombkrater_1_N = mkN "bombkrater" ; -- bombkrater..nn.1
  bombkrig_1_N = mkN "bombkrig" neutrum  ; -- bombkrig..nn.1
  bomblarm_1_N = mkN "bomblarm" neutrum  ; -- bomblarm..nn.1
  bombman_1_N = mkN "bombman" "bombmannen" "bombmän" "bombmännen" ; -- bombman..nn.1
  bombmatta_1_N = mkN "bombmatta" ; -- bombmatta..nn.1
  bombnedslag_1_N = mkN "bombnedslag" neutrum  ; -- bombnedslag..nn.1
  bombning_1_N = mkN "bombning" ; -- bombning..nn.1
  bomboffer_1_N = mkN "bomboffer" neutrum  ; -- bomboffer..nn.1
  bombplan_1_N = mkN "bombplan" neutrum  ; -- bombplan..nn.1
  bombraid_1_N = mkN "bombraid" "bombraider" ; -- bombraid..nn.1
  bombräd_1_N = mkN "bombräd" "bombräder" ; -- bombräd..nn.1
  bombsikte_1_N = mkN "bombsikte" ; -- bombsikte..nn.1
  bombskydd_1_N = mkN "bombskydd" neutrum  ; -- bombskydd..nn.1
  bombskyddssektion_1_N = mkN "bombskyddssektion" ; -- bombskyddssektion..nn.1
  bombsplitter_1_N = mkN "bombsplitter" neutrum  ; -- bombsplitter..nn.1
  bombsäker_1_A = mkA "bombsäker" ; -- bombsäker..av.1
  bombsäkerhet_1_N = mkN "bombsäkerhet" ; -- bombsäkerhet..nn.1
  bombtillverkning_1_N = mkN "bombtillverkning" ; -- bombtillverkning..nn.1
  bomcylinder_1_N = mkN "bomcylinder" ; -- bomcylinder..nn.1
  bomma_1_V = mkV "bommar" ; -- bomma..vb.1
  bommande_1_N = mkN "bommande" ; -- bommande..nn.1
  bomolja_1_N = mkN "bomolja" ; -- bomolja..nn.1
  bomsadel_1_N = mkN "bomsadel" ; -- bomsadel..nn.1
  bomsegel_1_N = mkN "bomsegel" neutrum  ; -- bomsegel..nn.1
  bomskott_1_N = mkN "bomskott" neutrum  ; -- bomskott..nn.1
  bomull_1_N = mkN "bomull" ; -- bomull..nn.1
  bomullsbal_1_N = mkN "bomullsbal" ; -- bomullsbal..nn.1
  bomullsband_1_N = mkN "bomullsband" neutrum  ; -- bomullsband..nn.1
  bomullsbuske_1_N = mkN "bomullsbuske" utrum  ; -- bomullsbuske..nn.1
  bomullsflanell_1_N = mkN "bomullsflanell" "bomullsflaneller" ; -- bomullsflanell..nn.1
  bomullsfrö_1_N = mkN "bomullsfrö" "bomullsfröet" "bomullsfrön" "bomullsfröna" ; -- bomullsfrö..nn.1
  bomullsfrökaka_1_N = mkN "bomullsfrökaka" ; -- bomullsfrökaka..nn.1
  bomullsfröolja_1_N = mkN "bomullsfröolja" ; -- bomullsfröolja..nn.1
  bomullsgarn_1_N = mkN "bomullsgarn" neutrum  ; -- bomullsgarn..nn.1
  bomullsklänning_1_N = mkN "bomullsklänning" ; -- bomullsklänning..nn.1
  bomullskrut_1_N = mkN "bomullskrut" neutrum  ; -- bomullskrut..nn.1
  bomullspinne_1_N = mkN "bomullspinne" utrum  ; -- bomullspinne..nn.1
  bomullsplantage_1_N = mkN "bomullsplantage" "bomullsplantager" ; -- bomullsplantage..nn.1
  bomullsplockare_1_N = mkN "bomullsplockare" utrum  ; -- bomullsplockare..nn.1
  bomullsservett_1_N = mkN "bomullsservett" "bomullsservetter" ; -- bomullsservett..nn.1
  bomullsskjorta_1_N = mkN "bomullsskjorta" ; -- bomullsskjorta..nn.1
  bomullsspinneri_1_N = mkN "bomullsspinneri" "bomullsspinneriet" "bomullsspinnerier" "bomullsspinnerierna" ; -- bomullsspinneri..nn.1
  bomullsstrumpa_1_N = mkN "bomullsstrumpa" ; -- bomullsstrumpa..nn.1
  bomullstops_1_N = mkN "bomullstops" ; -- bomullstops..nn.1
  bomullstrassel_1_N = mkN "bomullstrassel" neutrum  ; -- bomullstrassel..nn.1
  bomullstrikå_1_N = mkN "bomullstrikå" ; -- bomullstrikå..nn.1
  bomullstråd_1_N = mkN "bomullstråd" ; -- bomullstråd..nn.1
  bomullstuss_1_N = mkN "bomullstuss" ; -- bomullstuss..nn.1
  bomullstyg_1_N = mkN "bomullstyg" neutrum  ; -- bomullstyg..nn.1
  bomullsväv_1_N = mkN "bomullsväv" ; -- bomullsväv..nn.1
  bomullsvävnad_1_N = mkN "bomullsvävnad" "bomullsvävnader" ; -- bomullsvävnad..nn.1
  bomullsväxt_1_N = mkN "bomullsväxt" "bomullsväxter" ; -- bomullsväxt..nn.1
  bomärke_1_N = mkN "bomärke" ; -- bomärke..nn.1
  bona_1_V = mkV "bonar" ; -- bona..vb.1
  bonad_1_N = mkN "bonad" "bonader" ; -- bonad..nn.1
  bonande_1_N = mkN "bonande" ; -- bonande..nn.1
  bonbonjär_1_N = mkN "bonbonjär" "bonbonjärer" ; -- bonbonjär..nn.1
  bondage_1_N = mkN "bondage" ; -- bondage..nn.1
  bondaktig_1_A = mkA "bondaktig" ; -- bondaktig..av.1
  bondaktighet_1_N = mkN "bondaktighet" ; -- bondaktighet..nn.1
  bondbrud_1_N = mkN "bondbrud" ; -- bondbrud..nn.1
  bondböna_1_N = mkN "bondböna" ; -- bondböna..nn.1
  bonddryg_1_A = mkA "bonddryg" ; -- bonddryg..av.1
  bonddryghet_1_N = mkN "bonddryghet" ; -- bonddryghet..nn.1
  bonddräng_1_N = mkN "bonddräng" ; -- bonddräng..nn.1
  bonde_1_N = mkN "bonde" "bönder" ; -- bonde..nn.1
  bondearmé_1_N = mkN "bondearmé" "bondearméer" ; -- bondearmé..nn.1
  bondebefolkning_1_N = mkN "bondebefolkning" ; -- bondebefolkning..nn.1
  bondefred_1_N = mkN "bondefred" "bondefreder" ; -- bondefred..nn.1
  bondegeneration_1_N = mkN "bondegeneration" ; -- bondegeneration..nn.1
  bondehemman_1_N = mkN "bondehemman" neutrum  ; -- bondehemman..nn.1
  bondehär_1_N = mkN "bondehär" ; -- bondehär..nn.1
  bondekultur_1_N = mkN "bondekultur" "bondekulturer" ; -- bondekultur..nn.1
  bondenostalgi_1_N = mkN "bondenostalgi" "bondenostalgier" ; -- bondenostalgi..nn.1
  bondenostalgisk_1_A = mkA "bondenostalgisk" ; -- bondenostalgisk..av.1
  bondepraktika_1_N = mkN "bondepraktika" ; -- bondepraktika..nn.1
  bondeprotest_1_N = mkN "bondeprotest" "bondeprotester" ; -- bondeprotest..nn.1
  bondesamhälle_1_N = mkN "bondesamhälle" ; -- bondesamhälle..nn.1
  bondesjäl_1_N = mkN "bondesjäl" ; -- bondesjäl..nn.1
  bondeskog_1_N = mkN "bondeskog" ; -- bondeskog..nn.1
  bondesläkt_1_N = mkN "bondesläkt" "bondesläkter" ; -- bondesläkt..nn.1
  bondestånd_1_N = mkN "bondestånd" neutrum  ; -- bondestånd..nn.1
  bondetåg_1_N = mkN "bondetåg" neutrum  ; -- bondetåg..nn.1
  bondeuppbåd_1_N = mkN "bondeuppbåd" neutrum  ; -- bondeuppbåd..nn.1
  bondeuppror_1_N = mkN "bondeuppror" neutrum  ; -- bondeuppror..nn.1
  bondfamilj_1_N = mkN "bondfamilj" "bondfamiljer" ; -- bondfamilj..nn.1
  bondflicka_1_N = mkN "bondflicka" ; -- bondflicka..nn.1
  bondfolk_1_N = mkN "bondfolk" neutrum  ; -- bondfolk..nn.1
  bondfångare_1_N = mkN "bondfångare" utrum  ; -- bondfångare..nn.1
  bondförnuft_1_N = mkN "bondförnuft" neutrum  ; -- bondförnuft..nn.1
  bondförstånd_1_N = mkN "bondförstånd" neutrum  ; -- bondförstånd..nn.1
  bondförsök_1_N = mkN "bondförsök" neutrum  ; -- bondförsök..nn.1
  bondgumma_1_N = mkN "bondgumma" ; -- bondgumma..nn.1
  bondgård_1_N = mkN "bondgård" ; -- bondgård..nn.1
  bondhustru_1_N = mkN "bondhustru" "bondhustrun" "bondhustrur" "bondhustrurna" ; -- bondhustru..nn.1
  bondkalas_1_N = mkN "bondkalas" neutrum  ; -- bondkalas..nn.1
  bondkatt_1_N = mkN "bondkatt" "bondkatter" ; -- bondkatt..nn.1
  bondkomik_1_N = mkN "bondkomik" ; -- bondkomik..nn.1
  bondkomiker_1_N = mkN "bondkomiker" "bondkomikern" "bondkomiker" "bondkomikerna" ; -- bondkomiker..nn.1
  bondland_1_N = mkN "bondland" neutrum  ; -- bondland..nn.1
  bondlurk_1_N = mkN "bondlurk" ; -- bondlurk..nn.1
  bondläpp_1_N = mkN "bondläpp" ; -- bondläpp..nn.1
  bondmora_1_N = mkN "bondmora" ; -- bondmora..nn.1
  bondneka_1_V = mkV "bondnekar" ; -- bondneka..vb.1
  bondnekande_1_N = mkN "bondnekande" ; -- bondnekande..nn.1
  bondpermis_1_N = mkN "bondpermis" ; -- bondpermis..nn.1
  bondpermission_1_N = mkN "bondpermission" ; -- bondpermission..nn.1
  bondpolska_1_N = mkN "bondpolska" ; -- bondpolska..nn.1
  bondsk_1_A = mkA "bondsk" ; -- bondsk..av.1
  bondska_1_N = mkN "bondska" ; -- bondska..nn.1
  bondskhet_1_N = mkN "bondskhet" ; -- bondskhet..nn.1
  bondslug_1_A = mkA "bondslug" ; -- bondslug..av.1
  bondslughet_1_N = mkN "bondslughet" ; -- bondslughet..nn.1
  bondspelman_1_N = mkN "bondspelman" "bondspelmannen" "bondspelmän" "bondspelmännen" ; -- bondspelman..nn.1
  bondstuga_1_N = mkN "bondstuga" ; -- bondstuga..nn.1
  bondtolva_1_N = mkN "bondtolva" ; -- bondtolva..nn.1
  bondtur_1_N = mkN "bondtur" ; -- bondtur..nn.1
  bondtölp_1_N = mkN "bondtölp" ; -- bondtölp..nn.1
  bondvischa_1_N = mkN "bondvischa" ; -- bondvischa..nn.1
  bondånger_1_N = mkN "bondånger" ; -- bondånger..nn.1
  bong_1_N = mkN "bong" ; -- bong..nn.1
  bonga_1_V = mkV "bongar" ; -- bonga..vb.1
  bongande_1_N = mkN "bongande" ; -- bongande..nn.1
  bongotrumma_1_N = mkN "bongotrumma" ; -- bongotrumma..nn.1
  boning_1_N = mkN "boning" ; -- boning..nn.1
  boningshus_1_N = mkN "boningshus" neutrum  ; -- boningshus..nn.1
  boningsort_1_N = mkN "boningsort" "boningsorter" ; -- boningsort..nn.1
  boningsplats_1_N = mkN "boningsplats" "boningsplatser" ; -- boningsplats..nn.1
  boningsrum_1_N = mkN "boningsrum" "boningsrummet" "boningsrum" "boningsrummen" ; -- boningsrum..nn.1
  bonitera_1_V = mkV "boniterar" ; -- bonitera..vb.1
  boniterande_1_N = mkN "boniterande" ; -- boniterande..nn.1
  boniterbar_1_A = mkA "boniterbar" ; -- boniterbar..av.1
  boniterbarhet_1_N = mkN "boniterbarhet" ; -- boniterbarhet..nn.1
  bonitering_1_N = mkN "bonitering" ; -- bonitering..nn.1
  bonitet_1_N = mkN "bonitet" "boniteter" ; -- bonitet..nn.1
  bonjour_1_N = mkN "bonjour" "bonjourer" ; -- bonjour..nn.1
  bonmot_1_N = mkN "bonmot" neutrum  ; -- bonmot..nn.1
  bonnett_1_N = mkN "bonnett" "bonnetter" ; -- bonnett..nn.1
  bonnig_1_A = mkA "bonnig" ; -- bonnig..av.1
  bonnläpp_1_N = mkN "bonnläpp" ; -- bonnläpp..nn.1
  bonobo_1_N = mkN "bonobo" "bonobor" ; -- bonobo..nn.1
  bonus_1_N = mkN "bonus" ; -- bonus..nn.1
  bonusbarn_1_N = mkN "bonusbarn" neutrum  ; -- bonusbarn..nn.1
  bonusklass_1_N = mkN "bonusklass" "bonusklasser" ; -- bonusklass..nn.1
  bonusregel_1_N = mkN "bonusregel" "bonusregeln" "bonusregler" "bonusreglerna" ; -- bonusregel..nn.1
  bonussystem_1_N = mkN "bonussystem" neutrum  ; -- bonussystem..nn.1
  bonvax_1_N = mkN "bonvax" "bonvaxet" "bonvaxer" "bonvaxerna" ; -- bonvax..nn.1
  bookmaker_1_N = mkN "bookmaker" "bookmakern" "bookmakers" "bookmakersen" ; -- bookmaker..nn.1
  boom_1_N = mkN "boom" ; -- boom..nn.1
  booma_1_V = mkV "boomar" ; -- booma..vb.1
  boomande_1_N = mkN "boomande" ; -- boomande..nn.1
  boomår_1_N = mkN "boomår" neutrum  ; -- boomår..nn.1
  boosta_1_V = mkV "boostar" ; -- boosta..vb.1
  boostande_1_N = mkN "boostande" ; -- boostande..nn.1
  boostning_1_N = mkN "boostning" ; -- boostning..nn.1
  boota_1_V = mkV "bootar" ; -- boota..vb.1
  boparasit_1_N = mkN "boparasit" "boparasiter" ; -- boparasit..nn.1
  boplats_1_N = mkN "boplats" "boplatser" ; -- boplats..nn.1
  boplatsgrävning_1_N = mkN "boplatsgrävning" ; -- boplatsgrävning..nn.1
  bopris_1_N = mkN "bopris" neutrum  ; -- bopris..nn.1
  boprisbubbla_1_N = mkN "boprisbubbla" ; -- boprisbubbla..nn.1
  bor_1_N = mkN "bor" ; -- bor..nn.1
  borax_1_N = mkN "borax" ; -- borax..nn.1
  bord_1_N = mkN "bord" neutrum  ; -- bord..nn.1
  borda_1_V = mkV "bordar" ; -- borda..vb.1
  bordande_1_N = mkN "bordande" ; -- bordande..nn.1
  borddans_1_N = mkN "borddans" "borddanser" ; -- borddans..nn.1
  bordduk_1_N = mkN "bordduk" ; -- bordduk..nn.1
  bordeaux_1_N = mkN "bordeaux" "bordeauxer" ; -- bordeaux..nn.1
  bordeauxvin_1_N = mkN "bordeauxvin" "bordeauxvinet" "bordeauxviner" "bordeauxvinerna" ; -- bordeauxvin..nn.1
  bordeauxvätska_1_N = mkN "bordeauxvätska" ; -- bordeauxvätska..nn.1
  bordell_1_N = mkN "bordell" "bordeller" ; -- bordell..nn.1
  bordellverksamhet_1_N = mkN "bordellverksamhet" "bordellverksamheter" ; -- bordellverksamhet..nn.1
  bordellvärd_1_N = mkN "bordellvärd" ; -- bordellvärd..nn.1
  bordgång_1_N = mkN "bordgång" ; -- bordgång..nn.1
  bordhyvel_1_N = mkN "bordhyvel" ; -- bordhyvel..nn.1
  bordlägga_1_V = mkV "bordlägga" "bordla" "bordlagt" ; -- bordlägga..vb.1
  bordläggande_1_N = mkN "bordläggande" ; -- bordläggande..nn.1
  bordläggning_1_N = mkN "bordläggning" ; -- bordläggning..nn.1
  bordläggningsplenum_1_N = mkN "bordläggningsplenum" neutrum  ; -- bordläggningsplenum..nn.1
  bordlöpare_1_N = mkN "bordlöpare" utrum  ; -- bordlöpare..nn.1
  bordning_1_N = mkN "bordning" ; -- bordning..nn.1
  bordplanka_1_N = mkN "bordplanka" ; -- bordplanka..nn.1
  bordsamtal_1_N = mkN "bordsamtal" neutrum  ; -- bordsamtal..nn.1
  bordsben_1_N = mkN "bordsben" neutrum  ; -- bordsben..nn.1
  bordsbeställning_1_N = mkN "bordsbeställning" ; -- bordsbeställning..nn.1
  bordsbön_1_N = mkN "bordsbön" "bordsböner" ; -- bordsbön..nn.1
  bordsdam_1_N = mkN "bordsdam" "bordsdamer" ; -- bordsdam..nn.1
  bordsdryck_1_N = mkN "bordsdryck" "bordsdrycker" ; -- bordsdryck..nn.1
  bordservis_1_N = mkN "bordservis" "bordserviser" ; -- bordservis..nn.1
  bordsfilt_1_N = mkN "bordsfilt" ; -- bordsfilt..nn.1
  bordsgranne_1_N = mkN "bordsgranne" utrum  ; -- bordsgranne..nn.1
  bordsgäst_1_N = mkN "bordsgäst" "bordsgäster" ; -- bordsgäst..nn.1
  bordsilver_1_N = mkN "bordsilver" neutrum  ; -- bordsilver..nn.1
  bordskamrat_1_N = mkN "bordskamrat" "bordskamrater" ; -- bordskamrat..nn.1
  bordskant_1_N = mkN "bordskant" "bordskanter" ; -- bordskant..nn.1
  bordskavaljer_1_N = mkN "bordskavaljer" "bordskavaljerer" ; -- bordskavaljer..nn.1
  bordskick_1_N = mkN "bordskick" neutrum  ; -- bordskick..nn.1
  bordskiva_1_N = mkN "bordskiva" ; -- bordskiva..nn.1
  bordskniv_1_N = mkN "bordskniv" ; -- bordskniv..nn.1
  bordskrydda_1_N = mkN "bordskrydda" ; -- bordskrydda..nn.1
  bordslampa_1_N = mkN "bordslampa" ; -- bordslampa..nn.1
  bordslinne_1_N = mkN "bordslinne" ; -- bordslinne..nn.1
  bordsmargarin_1_N = mkN "bordsmargarin" "bordsmargarinet" "bordsmargariner" "bordsmargarinerna" ; -- bordsmargarin..nn.1
  bordssalt_1_N = mkN "bordssalt" neutrum  ; -- bordssalt..nn.1
  bordssamtal_1_N = mkN "bordssamtal" neutrum  ; -- bordssamtal..nn.1
  bordsservis_1_N = mkN "bordsservis" "bordsserviser" ; -- bordsservis..nn.1
  bordssilver_1_N = mkN "bordssilver" neutrum  ; -- bordssilver..nn.1
  bordsskick_1_N = mkN "bordsskick" neutrum  ; -- bordsskick..nn.1
  bordsskiva_1_N = mkN "bordsskiva" ; -- bordsskiva..nn.1
  bordsspegel_1_N = mkN "bordsspegel" ; -- bordsspegel..nn.1
  bordsstudsare_1_N = mkN "bordsstudsare" utrum  ; -- bordsstudsare..nn.1
  bordsställ_1_N = mkN "bordsställ" neutrum  ; -- bordsställ..nn.1
  bordssällskap_1_N = mkN "bordssällskap" neutrum  ; -- bordssällskap..nn.1
  bordstudsare_1_N = mkN "bordstudsare" utrum  ; -- bordstudsare..nn.1
  bordsuppsats_1_N = mkN "bordsuppsats" "bordsuppsatser" ; -- bordsuppsats..nn.1
  bordsvatten_1_N = mkN "bordsvatten" "bordsvattnet" "bordsvatten" "bordsvattnen" ; -- bordsvatten..nn.1
  bordsvin_1_N = mkN "bordsvin" "bordsvinet" "bordsviner" "bordsvinerna" ; -- bordsvin..nn.1
  bordsvisa_1_N = mkN "bordsvisa" ; -- bordsvisa..nn.1
  bordtennis_1_N = mkN "bordtennis" ; -- bordtennis..nn.1
  bordtennisbord_1_N = mkN "bordtennisbord" neutrum  ; -- bordtennisbord..nn.1
  bordtennisrack_1_N = mkN "bordtennisrack" ; -- bordtennisrack..nn.1
  bordtennisracket_1_N = mkN "bordtennisracket" ; -- bordtennisracket..nn.1
  bordvisa_1_N = mkN "bordvisa" ; -- bordvisa..nn.1
  boreal_1_A = mkA "boreal" ; -- boreal..av.1
  boren_1_A = mkA "boren" ; -- boren..av.1
  borg_1_N = mkN "borg" ; -- borg..nn.1
  borga_1_V = mkV "borgar" ; -- borga..vb.1
  borgande_1_N = mkN "borgande" ; -- borgande..nn.1
  borgaras_1_N = mkN "borgaras" neutrum  ; -- borgaras..nn.1
  borgarbeväpning_1_N = mkN "borgarbeväpning" ; -- borgarbeväpning..nn.1
  borgarbrev_1_N = mkN "borgarbrev" neutrum  ; -- borgarbrev..nn.1
  borgardöme_1_N = mkN "borgardöme" ; -- borgardöme..nn.1
  borgare_1_N = mkN "borgare" utrum  ; -- borgare..nn.1
  borgarfamilj_1_N = mkN "borgarfamilj" "borgarfamiljer" ; -- borgarfamilj..nn.1
  borgargarde_1_N = mkN "borgargarde" ; -- borgargarde..nn.1
  borgarhus_1_N = mkN "borgarhus" neutrum  ; -- borgarhus..nn.1
  borgarklass_1_N = mkN "borgarklass" "borgarklasser" ; -- borgarklass..nn.1
  borgarpress_1_N = mkN "borgarpress" ; -- borgarpress..nn.1
  borgarråd_1_N = mkN "borgarråd" neutrum  ; -- borgarråd..nn.1
  borgarskola_1_N = mkN "borgarskola" ; -- borgarskola..nn.1
  borgarsläkt_1_N = mkN "borgarsläkt" "borgarsläkter" ; -- borgarsläkt..nn.1
  borgarstånd_1_N = mkN "borgarstånd" neutrum  ; -- borgarstånd..nn.1
  borgensförbindelse_1_N = mkN "borgensförbindelse" "borgensförbindelser" ; -- borgensförbindelse..nn.1
  borgenslån_1_N = mkN "borgenslån" neutrum  ; -- borgenslån..nn.1
  borgensman_1_N = mkN "borgensman" "borgensmannen" "borgensmän" "borgensmännen" ; -- borgensman..nn.1
  borgenssumma_1_N = mkN "borgenssumma" ; -- borgenssumma..nn.1
  borgensåtagande_1_N = mkN "borgensåtagande" ; -- borgensåtagande..nn.1
  borgenär_1_N = mkN "borgenär" "borgenärer" ; -- borgenär..nn.1
  borgenärsed_1_N = mkN "borgenärsed" "borgenärseder" ; -- borgenärsed..nn.1
  borgerlig_1_A = mkA "borgerlig" ; -- borgerlig..av.1
  borgerlighet_1_N = mkN "borgerlighet" "borgerligheter" ; -- borgerlighet..nn.1
  borgerlighet_2_N = mkN "borgerlighet" ; -- borgerlighet..nn.2
  borgerskap_1_N = mkN "borgerskap" neutrum  ; -- borgerskap..nn.1
  borgfred_1_N = mkN "borgfred" "borgfreder" ; -- borgfred..nn.1
  borggård_1_N = mkN "borggård" ; -- borggård..nn.1
  borgis_1_N = mkN "borgis" ; -- borgis..nn.1
  borgmästare_1_N = mkN "borgmästare" utrum  ; -- borgmästare..nn.1
  borgruin_1_N = mkN "borgruin" "borgruiner" ; -- borgruin..nn.1
  borgtorn_1_N = mkN "borgtorn" neutrum  ; -- borgtorn..nn.1
  boricka_1_N = mkN "boricka" ; -- boricka..nn.1
  borkarbid_1_N = mkN "borkarbid" "borkarbider" ; -- borkarbid..nn.1
  bornera_1_V = mkV "bornerar" ; -- bornera..vb.1
  bornerad_1_A = mkA "bornerad" ; -- bornerad..av.1
  bornerande_1_N = mkN "bornerande" ; -- bornerande..nn.1
  bornering_1_N = mkN "bornering" ; -- bornering..nn.1
  bornyr_1_N = mkN "bornyr" ; -- bornyr..nn.1
  borr_1_N = mkN "borr" ; -- borr..nn.1
  borr_2_N = mkN "borr" ; -- borr..nn.2
  borra_1_V = mkV "borrar" ; -- borra..vb.1
  borrande_1_N = mkN "borrande" ; -- borrande..nn.1
  borrchuck_1_N = mkN "borrchuck" ; -- borrchuck..nn.1
  borrdiameter_1_N = mkN "borrdiameter" ; -- borrdiameter..nn.1
  borrelia_1_N = mkN "borrelia" ; -- borrelia..nn.1
  borreliavaccin_1_N = mkN "borreliavaccin" neutrum  ; -- borreliavaccin..nn.1
  borrhammare_1_N = mkN "borrhammare" "borrhammaren" "borrhammare" "borrhamrarna" ; -- borrhammare..nn.1
  borrhål_1_N = mkN "borrhål" neutrum  ; -- borrhål..nn.1
  borrhålsvägg_1_N = mkN "borrhålsvägg" ; -- borrhålsvägg..nn.1
  borrigg_1_N = mkN "borrigg" ; -- borrigg..nn.1
  borrjigg_1_N = mkN "borrjigg" ; -- borrjigg..nn.1
  borrklinka_1_N = mkN "borrklinka" ; -- borrklinka..nn.1
  borrkrona_1_N = mkN "borrkrona" ; -- borrkrona..nn.1
  borrkärna_1_N = mkN "borrkärna" ; -- borrkärna..nn.1
  borrlängd_1_N = mkN "borrlängd" "borrlängder" ; -- borrlängd..nn.1
  borrmaskin_1_N = mkN "borrmaskin" "borrmaskiner" ; -- borrmaskin..nn.1
  borrmussla_1_N = mkN "borrmussla" ; -- borrmussla..nn.1
  borrning_1_N = mkN "borrning" ; -- borrning..nn.1
  borrningsolycka_1_N = mkN "borrningsolycka" ; -- borrningsolycka..nn.1
  borrplattform_1_N = mkN "borrplattform" ; -- borrplattform..nn.1
  borrspindel_1_N = mkN "borrspindel" ; -- borrspindel..nn.1
  borrspån_1_N = mkN "borrspån" neutrum  ; -- borrspån..nn.1
  borrstål_1_N = mkN "borrstål" neutrum  ; -- borrstål..nn.1
  borrsväng_1_N = mkN "borrsväng" ; -- borrsväng..nn.1
  borrtorn_1_N = mkN "borrtorn" neutrum  ; -- borrtorn..nn.1
  borrutrustning_1_N = mkN "borrutrustning" ; -- borrutrustning..nn.1
  borsjtj_1_N = mkN "borsjtj" ; -- borsjtj..nn.1
  borst_1_N = mkN "borst" neutrum  ; -- borst..nn.1
  borsta_1_V = mkV "borstar" ; -- borsta..vb.1
  borstande_1_N = mkN "borstande" ; -- borstande..nn.1
  borstbindare_1_N = mkN "borstbindare" utrum  ; -- borstbindare..nn.1
  borstbinderi_1_N = mkN "borstbinderi" "borstbinderiet" "borstbinderier" "borstbinderierna" ; -- borstbinderi..nn.1
  borste_1_N = mkN "borste" utrum  ; -- borste..nn.1
  borstgarnityr_1_N = mkN "borstgarnityr" neutrum  ; -- borstgarnityr..nn.1
  borstgräs_1_N = mkN "borstgräs" neutrum  ; -- borstgräs..nn.1
  borstig_1_A = mkA "borstig" ; -- borstig..av.1
  borstighet_1_N = mkN "borstighet" ; -- borstighet..nn.1
  borstlös_1_A = mkA "borstlös" ; -- borstlös..av.1
  borstlöshet_1_N = mkN "borstlöshet" ; -- borstlöshet..nn.1
  borstmask_1_N = mkN "borstmask" ; -- borstmask..nn.1
  borstnate_1_N = mkN "borstnate" utrum  ; -- borstnate..nn.1
  borstnejlika_1_N = mkN "borstnejlika" ; -- borstnejlika..nn.1
  borstning_1_N = mkN "borstning" ; -- borstning..nn.1
  borstsvans_1_N = mkN "borstsvans" ; -- borstsvans..nn.1
  borstviskare_1_N = mkN "borstviskare" utrum  ; -- borstviskare..nn.1
  borsyra_1_N = mkN "borsyra" ; -- borsyra..nn.1
  bortadopterad_1_A = mkA "bortadopterad" ; -- bortadopterad..av.1
  bortafiasko_1_N = mkN "bortafiasko" "bortafiaskot" "bortafiaskon" "bortafiaskona" ; -- bortafiasko..nn.1
  bortaförlora_1_V = mkV "bortaförlorar" ; -- bortaförlora..vb.1
  bortaförlust_1_N = mkN "bortaförlust" "bortaförluster" ; -- bortaförlust..nn.1
  bortaförsäkring_1_N = mkN "bortaförsäkring" ; -- bortaförsäkring..nn.1
  bortalag_1_N = mkN "bortalag" neutrum  ; -- bortalag..nn.1
  bortalagad_1_A = mkA "bortalagad" ; -- bortalagad..av.1
  bortamatch_1_N = mkN "bortamatch" "bortamatcher" ; -- bortamatch..nn.1
  bortaplan_1_N = mkN "bortaplan" "bortaplaner" ; -- bortaplan..nn.1
  bortarbeta_1_V = mkV "bortarbetar" ; -- bortarbeta..vb.1
  bortarbetande_1_N = mkN "bortarbetande" ; -- bortarbetande..nn.1
  bortarbetning_1_N = mkN "bortarbetning" ; -- bortarbetning..nn.1
  bortarrendering_1_N = mkN "bortarrendering" ; -- bortarrendering..nn.1
  bortaseger_1_N = mkN "bortaseger" ; -- bortaseger..nn.1
  bortasegra_1_V = mkV "bortasegrar" ; -- bortasegra..vb.1
  bortaspelare_1_N = mkN "bortaspelare" utrum  ; -- bortaspelare..nn.1
  bortauktionering_1_N = mkN "bortauktionering" ; -- bortauktionering..nn.1
  bortavaro_1_N = mkN "bortavaro" ; -- bortavaro..nn.1
  bortavinna_1_V = mkV "bortavinna" "bortavann" "bortavunnit" ; -- bortavinna..vb.1
  bortavinst_1_N = mkN "bortavinst" "bortavinster" ; -- bortavinst..nn.1
  bortbjuden_1_A = mkA "bortbjuden" ; -- bortbjuden..av.1
  bortbjudning_1_N = mkN "bortbjudning" ; -- bortbjudning..nn.1
  bortblandning_1_N = mkN "bortblandning" ; -- bortblandning..nn.1
  bortblåsning_1_N = mkN "bortblåsning" ; -- bortblåsning..nn.1
  bortblåst_1_A = mkA "bortblåst" "bortblåst" ; -- bortblåst..av.1
  bortbyting_1_N = mkN "bortbyting" ; -- bortbyting..nn.1
  bortdomna_1_V = mkV "bortdomnar" ; -- bortdomna..vb.1
  bortdomnande_1_N = mkN "bortdomnande" ; -- bortdomnande..nn.1
  bortdomning_1_N = mkN "bortdomning" ; -- bortdomning..nn.1
  bortdriva_1_V = mkV "bortdriva" "bortdrev" "bortdrivit" ; -- bortdriva..vb.1
  bortdrivande_1_N = mkN "bortdrivande" ; -- bortdrivande..nn.1
  bortdrivning_1_N = mkN "bortdrivning" ; -- bortdrivning..nn.1
  bortdunstning_1_N = mkN "bortdunstning" ; -- bortdunstning..nn.1
  bortdöende_1_A = mkA "bortdöende" ; -- bortdöende..av.1
  bortdömning_1_N = mkN "bortdömning" ; -- bortdömning..nn.1
  borterst_1_Adv = mkAdv "borterst" ; -- borterst..ab.1
  bortfall_1_N = mkN "bortfall" neutrum  ; -- bortfall..nn.1
  bortfalla_1_V = mkV "bortfalla" "bortföll" "bortfallit" ; -- bortfalla..vb.1
  bortfallande_1_N = mkN "bortfallande" ; -- bortfallande..nn.1
  bortflugen_1_A = mkA "bortflugen" ; -- bortflugen..av.1
  bortflyttning_1_N = mkN "bortflyttning" ; -- bortflyttning..nn.1
  bortforsla_1_V = mkV "bortforslar" ; -- bortforsla..vb.1
  bortforslande_1_N = mkN "bortforslande" ; -- bortforslande..nn.1
  bortforsling_1_N = mkN "bortforsling" ; -- bortforsling..nn.1
  bortfärd_1_N = mkN "bortfärd" ; -- bortfärd..nn.1
  bortföra_1_V = mkV "bortföra" "bortförde" "bortfört" ; -- bortföra..vb.1
  bortförande_1_N = mkN "bortförande" ; -- bortförande..nn.1
  bortförklara_1_V = mkV "bortförklarar" ; -- bortförklara..vb.1
  bortförklarande_1_N = mkN "bortförklarande" ; -- bortförklarande..nn.1
  bortförklaring_1_N = mkN "bortförklaring" ; -- bortförklaring..nn.1
  bortförklaringsteologi_1_N = mkN "bortförklaringsteologi" ; -- bortförklaringsteologi..nn.1
  bortgivande_1_N = mkN "bortgivande" ; -- bortgivande..nn.1
  bortglömd_1_A = mkA "bortglömd" "bortglömt" ; -- bortglömd..av.1
  bortglömdhet_1_N = mkN "bortglömdhet" ; -- bortglömdhet..nn.1
  bortgå_1_V = mkV "bortgå" "bortgick" "bortgått" ; -- bortgå..vb.1
  bortgående_1_N = mkN "bortgående" ; -- bortgående..nn.1
  bortgång_1_N = mkN "bortgång" ; -- bortgång..nn.1
  bortgången_1_A = mkA "bortgången" ; -- bortgången..av.1
  bortifrån_1_Adv = mkAdv "bortifrån" ; -- bortifrån..ab.1
  bortkastad_1_A = mkA "bortkastad" ; -- bortkastad..av.1
  bortklippning_1_N = mkN "bortklippning" ; -- bortklippning..nn.1
  bortkollring_1_N = mkN "bortkollring" ; -- bortkollring..nn.1
  bortkommen_1_A = mkA "bortkommen" "bortkommet" "bortkomna" "bortkomna" "bortkomnare" "bortkomnast" "bortkomnaste" ; -- bortkommen..av.1
  bortkommenhet_1_N = mkN "bortkommenhet" ; -- bortkommenhet..nn.1
  bortkörd_1_A = mkA "bortkörd" "bortkört" ; -- bortkörd..av.1
  bortlottning_1_N = mkN "bortlottning" ; -- bortlottning..nn.1
  bortlova_1_V = mkV "bortlovar" ; -- bortlova..vb.1
  bortlovande_1_N = mkN "bortlovande" ; -- bortlovande..nn.1
  bortläggning_1_N = mkN "bortläggning" ; -- bortläggning..nn.1
  bortlåning_1_N = mkN "bortlåning" ; -- bortlåning..nn.1
  bortmarsch_1_N = mkN "bortmarsch" ; -- bortmarsch..nn.1
  bortmontera_1_V = mkV "bortmonterar" ; -- bortmontera..vb.1
  bortmota_1_V = mkV "bortmotar" ; -- bortmota..vb.1
  bortmotande_1_N = mkN "bortmotande" ; -- bortmotande..nn.1
  bortmotning_1_N = mkN "bortmotning" ; -- bortmotning..nn.1
  bortnötning_1_N = mkN "bortnötning" ; -- bortnötning..nn.1
  bortodling_1_N = mkN "bortodling" ; -- bortodling..nn.1
  bortoperera_1_V = mkV "bortopererar" ; -- bortoperera..vb.1
  bortopererande_1_N = mkN "bortopererande" ; -- bortopererande..nn.1
  bortovaro_1_N = mkN "bortovaro" ; -- bortovaro..nn.1
  bortplockning_1_N = mkN "bortplockning" ; -- bortplockning..nn.1
  bortplottrande_1_N = mkN "bortplottrande" ; -- bortplottrande..nn.1
  bortrakning_1_N = mkN "bortrakning" ; -- bortrakning..nn.1
  bortrationalisera_1_V = mkV "bortrationaliserar" ; -- bortrationalisera..vb.1
  bortrationaliserande_1_N = mkN "bortrationaliserande" ; -- bortrationaliserande..nn.1
  bortrationalisering_1_N = mkN "bortrationalisering" ; -- bortrationalisering..nn.1
  bortrensning_1_N = mkN "bortrensning" ; -- bortrensning..nn.1
  bortresa_1_N = mkN "bortresa" ; -- bortresa..nn.1
  bortresonera_1_V = mkV "bortresonerar" ; -- bortresonera..vb.1
  bortresonerande_1_N = mkN "bortresonerande" ; -- bortresonerande..nn.1
  bortresonerbar_1_A = mkA "bortresonerbar" ; -- bortresonerbar..av.1
  bortresonerbarhet_1_N = mkN "bortresonerbarhet" ; -- bortresonerbarhet..nn.1
  bortresonering_1_N = mkN "bortresonering" ; -- bortresonering..nn.1
  bortrest_1_A = mkA "bortrest" "bortrest" ; -- bortrest..av.1
  bortresthet_1_N = mkN "bortresthet" ; -- bortresthet..nn.1
  bortrinna_1_V = mkV "bortrinna" "bortrann" "bortrunnit" ; -- bortrinna..vb.1
  bortrinnande_1_N = mkN "bortrinnande" ; -- bortrinnande..nn.1
  bortrivning_1_N = mkN "bortrivning" ; -- bortrivning..nn.1
  bortryckning_1_N = mkN "bortryckning" ; -- bortryckning..nn.1
  bortryckt_1_A = mkA "bortryckt" "bortryckt" ; -- bortryckt..av.1
  borträkna_1_V = mkV "borträknar" ; -- borträkna..vb.1
  borträknande_1_N = mkN "borträknande" ; -- borträknande..nn.1
  bortröjning_1_N = mkN "bortröjning" ; -- bortröjning..nn.1
  bortröva_1_V = mkV "bortrövar" ; -- bortröva..vb.1
  bortrövande_1_N = mkN "bortrövande" ; -- bortrövande..nn.1
  bortschabblad_1_A = mkA "bortschabblad" ; -- bortschabblad..av.1
  bortschackring_1_N = mkN "bortschackring" ; -- bortschackring..nn.1
  bortse_1_V = mkV "bortse" "bortsåg" "bortsett" ; -- bortse..vb.1
  bortseende_1_N = mkN "bortseende" ; -- bortseende..nn.1
  bortsida_1_N = mkN "bortsida" ; -- bortsida..nn.1
  bortskaffa_1_V = mkV "bortskaffar" ; -- bortskaffa..vb.1
  bortskaffande_1_N = mkN "bortskaffande" ; -- bortskaffande..nn.1
  bortskaffning_1_N = mkN "bortskaffning" ; -- bortskaffning..nn.1
  bortskjuten_1_A = mkA "bortskjuten" ; -- bortskjuten..av.1
  bortskrapning_1_N = mkN "bortskrapning" ; -- bortskrapning..nn.1
  bortskrivning_1_N = mkN "bortskrivning" ; -- bortskrivning..nn.1
  bortskrämma_1_V = mkV "bortskrämma" "bortskrämme" "bortskrämt" ; -- bortskrämma..vb.1
  bortskrämmande_1_N = mkN "bortskrämmande" ; -- bortskrämmande..nn.1
  bortskrämning_1_N = mkN "bortskrämning" ; -- bortskrämning..nn.1
  bortskämd_1_A = mkA "bortskämd" "bortskämt" ; -- bortskämd..av.1
  bortskämdhet_1_N = mkN "bortskämdhet" "bortskämdheter" ; -- bortskämdhet..nn.1
  bortskänka_1_V = mkV "bortskänker" ; -- bortskänka..vb.1
  bortskänkande_1_N = mkN "bortskänkande" ; -- bortskänkande..nn.1
  bortskänkning_1_N = mkN "bortskänkning" ; -- bortskänkning..nn.1
  bortskärning_1_N = mkN "bortskärning" ; -- bortskärning..nn.1
  bortsköljning_1_N = mkN "bortsköljning" ; -- bortsköljning..nn.1
  bortslumpa_1_V = mkV "bortslumpar" ; -- bortslumpa..vb.1
  bortslumpande_1_N = mkN "bortslumpande" ; -- bortslumpande..nn.1
  bortslumpning_1_N = mkN "bortslumpning" ; -- bortslumpning..nn.1
  bortsluta_1_V = mkV "bortsluta" "bortslöt" "bortslutit" ; -- bortsluta..vb.1
  bortslutande_1_N = mkN "bortslutande" ; -- bortslutande..nn.1
  bortspolning_1_N = mkN "bortspolning" ; -- bortspolning..nn.1
  bortsprängning_1_N = mkN "bortsprängning" ; -- bortsprängning..nn.1
  bortstötning_1_N = mkN "bortstötning" ; -- bortstötning..nn.1
  bortsättning_1_N = mkN "bortsättning" ; -- bortsättning..nn.1
  bortta_1_V = mkV "borttaga" "borttog" "borttagit" ; -- bortta..vb.1
  borttagande_1_N = mkN "borttagande" ; -- borttagande..nn.1
  borttagning_1_N = mkN "borttagning" ; -- borttagning..nn.1
  borttappa_1_V = mkV "borttappar" ; -- borttappa..vb.1
  borttappad_1_A = mkA "borttappad" ; -- borttappad..av.1
  borttappande_1_N = mkN "borttappande" ; -- borttappande..nn.1
  borttorka_1_V = mkV "borttorkar" ; -- borttorka..vb.1
  borttorkande_1_N = mkN "borttorkande" ; -- borttorkande..nn.1
  borttränga_1_V = mkV "borttränger" ; -- borttränga..vb.1
  bortträngande_1_N = mkN "bortträngande" ; -- bortträngande..nn.1
  bortträngning_1_N = mkN "bortträngning" ; -- bortträngning..nn.1
  borttvagning_1_N = mkN "borttvagning" ; -- borttvagning..nn.1
  borttvättning_1_N = mkN "borttvättning" ; -- borttvättning..nn.1
  bortvikt_1_N = mkN "bortvikt" ; -- bortvikt..nn.1
  bortvräka_1_V = mkV "bortvräker" ; -- bortvräka..vb.1
  bortvräkande_1_N = mkN "bortvräkande" ; -- bortvräkande..nn.1
  bortväg_1_N = mkN "bortväg" ; -- bortväg..nn.1
  bortvältning_1_N = mkN "bortvältning" ; -- bortvältning..nn.1
  bortvältring_1_N = mkN "bortvältring" ; -- bortvältring..nn.1
  bortvänd_1_A = mkA "bortvänd" ; -- bortvänd..av.1
  bortända_1_N = mkN "bortända" ; -- bortända..nn.1
  bortände_1_N = mkN "bortände" utrum  ; -- bortände..nn.1
  bortödsling_1_N = mkN "bortödsling" ; -- bortödsling..nn.1
  bortöver_1_Adv = mkAdv "bortöver" ; -- bortöver..ab.1
  bosatt_1_A = mkA "bosatt" ; -- bosatt..av.1
  bosch_1_N = mkN "bosch" neutrum  ; -- bosch..nn.1
  boskap_1_N = mkN "boskap" ; -- boskap..nn.1
  boskapsavel_1_N = mkN "boskapsavel" ; -- boskapsavel..nn.1
  boskapsdrift_1_N = mkN "boskapsdrift" ; -- boskapsdrift..nn.1
  boskapsfoder_1_N = mkN "boskapsfoder" neutrum  ; -- boskapsfoder..nn.1
  boskapshjord_1_N = mkN "boskapshjord" ; -- boskapshjord..nn.1
  boskapsmarknad_1_N = mkN "boskapsmarknad" "boskapsmarknader" ; -- boskapsmarknad..nn.1
  boskapspest_1_N = mkN "boskapspest" ; -- boskapspest..nn.1
  boskapsras_1_N = mkN "boskapsras" "boskapsraser" ; -- boskapsras..nn.1
  boskapsskötande_1_A = mkA "boskapsskötande" ; -- boskapsskötande..av.1
  boskapsskötare_1_N = mkN "boskapsskötare" utrum  ; -- boskapsskötare..nn.1
  boskapsskötsel_1_N = mkN "boskapsskötsel" ; -- boskapsskötsel..nn.1
  boskapsstock_1_N = mkN "boskapsstock" ; -- boskapsstock..nn.1
  boskapsstängsel_1_N = mkN "boskapsstängsel" neutrum  ; -- boskapsstängsel..nn.1
  boskapstjuv_1_N = mkN "boskapstjuv" ; -- boskapstjuv..nn.1
  boskapsuppfödning_1_N = mkN "boskapsuppfödning" ; -- boskapsuppfödning..nn.1
  boskifte_1_N = mkN "boskifte" ; -- boskifte..nn.1
  boskillnad_1_N = mkN "boskillnad" "boskillnader" ; -- boskillnad..nn.1
  bosniak_1_N = mkN "bosniak" "bosniaker" ; -- bosniak..nn.1
  bosnienkroatisk_1_A = mkA "bosnienkroatisk" ; -- bosnienkroatisk..av.1
  bosnienserbisk_1_A = mkA "bosnienserbisk" ; -- bosnienserbisk..av.1
  bosnier_1_N = mkN "bosnier" "bosniern" "bosnier" "bosnierna" ; -- bosnier..nn.1
  bosnisk_1_A = mkA "bosnisk" ; -- bosnisk..av.1
  bosniska_1_N = mkN "bosniska" ; -- bosniska..nn.1
  boson_1_N = mkN "boson" "bosoner" ; -- boson..nn.1
  boss_1_N = mkN "boss" ; -- boss..nn.1
  boss_2_N = mkN "boss" neutrum  ; -- boss..nn.2
  bossig_1_A = mkA "bossig" ; -- bossig..av.1
  bossighet_1_N = mkN "bossighet" ; -- bossighet..nn.1
  bossvälde_1_N = mkN "bossvälde" ; -- bossvälde..nn.1
  bostad_1_N = mkN "bostad" "bostäder" ; -- bostad..nn.1
  bostadsadress_1_N = mkN "bostadsadress" "bostadsadresser" ; -- bostadsadress..nn.1
  bostadsband_1_N = mkN "bostadsband" neutrum  ; -- bostadsband..nn.1
  bostadsbestånd_1_N = mkN "bostadsbestånd" neutrum  ; -- bostadsbestånd..nn.1
  bostadsbidrag_1_N = mkN "bostadsbidrag" neutrum  ; -- bostadsbidrag..nn.1
  bostadsbolag_1_N = mkN "bostadsbolag" neutrum  ; -- bostadsbolag..nn.1
  bostadsbrist_1_N = mkN "bostadsbrist" ; -- bostadsbrist..nn.1
  bostadsbubbla_1_N = mkN "bostadsbubbla" ; -- bostadsbubbla..nn.1
  bostadsbyggande_1_N = mkN "bostadsbyggande" ; -- bostadsbyggande..nn.1
  bostadsexpert_1_N = mkN "bostadsexpert" "bostadsexperter" ; -- bostadsexpert..nn.1
  bostadsförbättringslån_1_N = mkN "bostadsförbättringslån" neutrum  ; -- bostadsförbättringslån..nn.1
  bostadsföretag_1_N = mkN "bostadsföretag" neutrum  ; -- bostadsföretag..nn.1
  bostadsförmedling_1_N = mkN "bostadsförmedling" ; -- bostadsförmedling..nn.1
  bostadshus_1_N = mkN "bostadshus" neutrum  ; -- bostadshus..nn.1
  bostadsinspektion_1_N = mkN "bostadsinspektion" ; -- bostadsinspektion..nn.1
  bostadsklipp_1_N = mkN "bostadsklipp" neutrum  ; -- bostadsklipp..nn.1
  bostadskooperation_1_N = mkN "bostadskooperation" ; -- bostadskooperation..nn.1
  bostadskredit_1_N = mkN "bostadskredit" "bostadskrediter" ; -- bostadskredit..nn.1
  bostadskvarter_1_N = mkN "bostadskvarter" "bostadskvarteret" "bostadskvarter" "bostadskvarteren" ; -- bostadskvarter..nn.1
  bostadskö_1_N = mkN "bostadskö" "bostadskön" "bostadsköer" "bostadsköerna" ; -- bostadskö..nn.1
  bostadsköp_1_N = mkN "bostadsköp" neutrum  ; -- bostadsköp..nn.1
  bostadslägenhet_1_N = mkN "bostadslägenhet" "bostadslägenheter" ; -- bostadslägenhet..nn.1
  bostadslänga_1_N = mkN "bostadslänga" ; -- bostadslänga..nn.1
  bostadslån_1_N = mkN "bostadslån" neutrum  ; -- bostadslån..nn.1
  bostadslös_1_A = mkA "bostadslös" ; -- bostadslös..av.1
  bostadslöshet_1_N = mkN "bostadslöshet" ; -- bostadslöshet..nn.1
  bostadsmarknad_1_N = mkN "bostadsmarknad" "bostadsmarknader" ; -- bostadsmarknad..nn.1
  bostadsmiljö_1_N = mkN "bostadsmiljö" "bostadsmiljön" "bostadsmiljöer" "bostadsmiljöerna" ; -- bostadsmiljö..nn.1
  bostadsmässig_1_A = mkA "bostadsmässig" ; -- bostadsmässig..av.1
  bostadsnämnd_1_N = mkN "bostadsnämnd" "bostadsnämnder" ; -- bostadsnämnd..nn.1
  bostadsområde_1_N = mkN "bostadsområde" ; -- bostadsområde..nn.1
  bostadspolitik_1_N = mkN "bostadspolitik" ; -- bostadspolitik..nn.1
  bostadspolitisk_1_A = mkA "bostadspolitisk" ; -- bostadspolitisk..av.1
  bostadspris_1_N = mkN "bostadspris" neutrum  ; -- bostadspris..nn.1
  bostadsproduktion_1_N = mkN "bostadsproduktion" ; -- bostadsproduktion..nn.1
  bostadsrätt_1_N = mkN "bostadsrätt" "bostadsrätter" ; -- bostadsrätt..nn.1
  bostadsrättsförening_1_N = mkN "bostadsrättsförening" ; -- bostadsrättsförening..nn.1
  bostadsrättsinnehavare_1_N = mkN "bostadsrättsinnehavare" utrum  ; -- bostadsrättsinnehavare..nn.1
  bostadsrättspris_1_N = mkN "bostadsrättspris" neutrum  ; -- bostadsrättspris..nn.1
  bostadssocial_1_A = mkA "bostadssocial" ; -- bostadssocial..av.1
  bostadssparande_1_N = mkN "bostadssparande" ; -- bostadssparande..nn.1
  bostadsstyrelse_1_N = mkN "bostadsstyrelse" "bostadsstyrelser" ; -- bostadsstyrelse..nn.1
  bostadssökande_1_N = mkN "bostadssökande" "bostadssökanden" "bostadssökanden" "bostadssökandena" ; -- bostadssökande..nn.1
  bostadstillägg_1_N = mkN "bostadstillägg" neutrum  ; -- bostadstillägg..nn.1
  boston_1_N = mkN "boston" ; -- boston..nn.1
  bostongurka_1_N = mkN "bostongurka" ; -- bostongurka..nn.1
  bostonvals_1_N = mkN "bostonvals" "bostonvalser" ; -- bostonvals..nn.1
  boställe_1_N = mkN "boställe" ; -- boställe..nn.1
  bosättare_1_N = mkN "bosättare" utrum  ; -- bosättare..nn.1
  bosättning_1_N = mkN "bosättning" ; -- bosättning..nn.1
  bosättningsaffär_1_N = mkN "bosättningsaffär" "bosättningsaffärer" ; -- bosättningsaffär..nn.1
  bosättningslån_1_N = mkN "bosättningslån" neutrum  ; -- bosättningslån..nn.1
  bosättningsort_1_N = mkN "bosättningsort" "bosättningsorter" ; -- bosättningsort..nn.1
  bosättningsstopp_1_N = mkN "bosättningsstopp" neutrum  ; -- bosättningsstopp..nn.1
  bot_1_N = mkN "bot" ; -- bot..nn.1
  bot_2_N = mkN "bot" ; -- bot..nn.2
  bot_3_N = mkN "bot" ; -- bot..nn.3
  bota_1_V = mkV "botar" ; -- bota..vb.1
  botande_1_N = mkN "botande" ; -- botande..nn.1
  botanik_1_N = mkN "botanik" ; -- botanik..nn.1
  botaniker_1_N = mkN "botaniker" "botanikern" "botaniker" "botanikerna" ; -- botaniker..nn.1
  botanikspade_1_N = mkN "botanikspade" utrum  ; -- botanikspade..nn.1
  botanisera_1_V = mkV "botaniserar" ; -- botanisera..vb.1
  botaniserande_1_N = mkN "botaniserande" ; -- botaniserande..nn.1
  botanisering_1_N = mkN "botanisering" ; -- botanisering..nn.1
  botanisk_1_A = mkA "botanisk" ; -- botanisk..av.1
  botanist_1_N = mkN "botanist" "botanister" ; -- botanist..nn.1
  botanistspade_1_N = mkN "botanistspade" utrum  ; -- botanistspade..nn.1
  botbar_1_A = mkA "botbar" ; -- botbar..av.1
  botbarhet_1_N = mkN "botbarhet" ; -- botbarhet..nn.1
  botdag_1_N = mkN "botdag" ; -- botdag..nn.1
  botemedel_1_N = mkN "botemedel" neutrum  ; -- botemedel..nn.1
  botfärdig_1_A = mkA "botfärdig" ; -- botfärdig..av.1
  botfärdighet_1_N = mkN "botfärdighet" ; -- botfärdighet..nn.1
  botgörare_1_N = mkN "botgörare" utrum  ; -- botgörare..nn.1
  botgörartåg_1_N = mkN "botgörartåg" neutrum  ; -- botgörartåg..nn.1
  botgörelse_1_N = mkN "botgörelse" "botgörelser" ; -- botgörelse..nn.1
  botgöring_1_N = mkN "botgöring" ; -- botgöring..nn.1
  botlig_1_A = mkA "botlig" ; -- botlig..av.1
  botlighet_1_N = mkN "botlighet" ; -- botlighet..nn.1
  botox_1_N = mkN "botox" ; -- botox..nn.1
  botoxförlamning_1_N = mkN "botoxförlamning" ; -- botoxförlamning..nn.1
  botswanier_1_N = mkN "botswanier" "botswaniern" "botswanier" "botswanierna" ; -- botswanier..nn.1
  botswansk_1_A = mkA "botswansk" ; -- botswansk..av.1
  botswanska_1_N = mkN "botswanska" ; -- botswanska..nn.1
  botten_1_A = mkA "botten" ; -- botten..av.1
  botten_1_N = mkN "botten" ; -- botten..nn.1
  bottenavlagring_1_N = mkN "bottenavlagring" ; -- bottenavlagring..nn.1
  bottenbjälke_1_N = mkN "bottenbjälke" utrum  ; -- bottenbjälke..nn.1
  bottendjur_1_N = mkN "bottendjur" neutrum  ; -- bottendjur..nn.1
  bottendålig_1_A = mkA "bottendålig" ; -- bottendålig..av.1
  bottendålighet_1_N = mkN "bottendålighet" ; -- bottendålighet..nn.1
  bottendöd_1_N = mkN "bottendöd" ; -- bottendöd..nn.1
  bottenfast_1_A = mkA "bottenfast" "bottenfast" ; -- bottenfast..av.1
  bottenformation_1_N = mkN "bottenformation" ; -- bottenformation..nn.1
  bottenfrysa_1_V = mkV "bottenfryser" ; -- bottenfrysa..vb.1
  bottenfrysande_1_N = mkN "bottenfrysande" ; -- bottenfrysande..nn.1
  bottenfällning_1_N = mkN "bottenfällning" ; -- bottenfällning..nn.1
  bottenfärg_1_N = mkN "bottenfärg" "bottenfärger" ; -- bottenfärg..nn.1
  bottengarn_1_N = mkN "bottengarn" neutrum  ; -- bottengarn..nn.1
  bottenhederlig_1_A = mkA "bottenhederlig" ; -- bottenhederlig..av.1
  bottenhederlighet_1_N = mkN "bottenhederlighet" ; -- bottenhederlighet..nn.1
  bottenis_1_N = mkN "bottenis" ; -- bottenis..nn.1
  bottenkran_1_N = mkN "bottenkran" ; -- bottenkran..nn.1
  bottenkurs_1_N = mkN "bottenkurs" "bottenkurser" ; -- bottenkurs..nn.1
  bottenkvark_1_N = mkN "bottenkvark" ; -- bottenkvark..nn.1
  bottenkänning_1_N = mkN "bottenkänning" ; -- bottenkänning..nn.1
  bottenlag_1_N = mkN "bottenlag" neutrum  ; -- bottenlag..nn.1
  bottenlevande_1_A = mkA "bottenlevande" ; -- bottenlevande..av.1
  bottenläge_1_N = mkN "bottenläge" ; -- bottenläge..nn.1
  bottenlån_1_N = mkN "bottenlån" neutrum  ; -- bottenlån..nn.1
  bottenlös_1_A = mkA "bottenlös" ; -- bottenlös..av.1
  bottenlöshet_1_N = mkN "bottenlöshet" "bottenlösheter" ; -- bottenlöshet..nn.1
  bottenmagnet_1_N = mkN "bottenmagnet" "bottenmagneter" ; -- bottenmagnet..nn.1
  bottenmorän_1_N = mkN "bottenmorän" ; -- bottenmorän..nn.1
  bottennapp_1_N = mkN "bottennapp" neutrum  ; -- bottennapp..nn.1
  bottenplan_1_N = mkN "bottenplan" neutrum  ; -- bottenplan..nn.1
  bottenplatta_1_N = mkN "bottenplatta" ; -- bottenplatta..nn.1
  bottenrekord_1_N = mkN "bottenrekord" neutrum  ; -- bottenrekord..nn.1
  bottenrev_1_N = mkN "bottenrev" neutrum  ; -- bottenrev..nn.1
  bottenreva_1_V = mkV "bottenrevar" ; -- bottenreva..vb.1
  bottenrevande_1_N = mkN "bottenrevande" ; -- bottenrevande..nn.1
  bottensats_1_N = mkN "bottensats" "bottensatser" ; -- bottensats..nn.1
  bottensediment_1_N = mkN "bottensediment" neutrum  ; -- bottensediment..nn.1
  bottenskikt_1_N = mkN "bottenskikt" neutrum  ; -- bottenskikt..nn.1
  bottenskola_1_N = mkN "bottenskola" ; -- bottenskola..nn.1
  bottenskrap_1_N = mkN "bottenskrap" neutrum  ; -- bottenskrap..nn.1
  bottenskrapa_1_N = mkN "bottenskrapa" ; -- bottenskrapa..nn.1
  bottenskrapa_1_V = mkV "bottenskrapar" ; -- bottenskrapa..vb.1
  bottenskrapande_1_N = mkN "bottenskrapande" ; -- bottenskrapande..nn.1
  bottenskvätt_1_N = mkN "bottenskvätt" ; -- bottenskvätt..nn.1
  bottenskyla_1_N = mkN "bottenskyla" ; -- bottenskyla..nn.1
  bottenstock_1_N = mkN "bottenstock" ; -- bottenstock..nn.1
  bottentryck_1_N = mkN "bottentryck" neutrum  ; -- bottentryck..nn.1
  bottenvatten_1_N = mkN "bottenvatten" "bottenvattnet" "bottenvatten" "bottenvattnen" ; -- bottenvatten..nn.1
  bottenventil_1_N = mkN "bottenventil" "bottenventiler" ; -- bottenventil..nn.1
  bottenvåning_1_N = mkN "bottenvåning" ; -- bottenvåning..nn.1
  bottenyta_1_N = mkN "bottenyta" ; -- bottenyta..nn.1
  bottin_1_N = mkN "bottin" "bottiner" ; -- bottin..nn.1
  bottna_1_V = mkV "bottnar" ; -- bottna..vb.1
  bottnande_1_N = mkN "bottnande" ; -- bottnande..nn.1
  bottning_1_N = mkN "bottning" ; -- bottning..nn.1
  bottnisk_1_A = mkA "bottnisk" ; -- bottnisk..av.1
  botulin_1_N = mkN "botulin" neutrum  ; -- botulin..nn.1
  botulism_1_N = mkN "botulism" "botulismer" ; -- botulism..nn.1
  boudoir_1_N = mkN "boudoir" "boudoirer" ; -- boudoir..nn.1
  bouillabaisse_1_N = mkN "bouillabaisse" utrum  ; -- bouillabaisse..nn.1
  boule_1_N = mkN "boule" utrum  ; -- boule..nn.1
  boulevard_1_N = mkN "boulevard" "boulevarder" ; -- boulevard..nn.1
  boulevardpress_1_N = mkN "boulevardpress" ; -- boulevardpress..nn.1
  bouppteckning_1_N = mkN "bouppteckning" ; -- bouppteckning..nn.1
  bouquet_1_N = mkN "bouquet" "bouqueter" ; -- bouquet..nn.1
  bourbon_1_N = mkN "bourbon" ; -- bourbon..nn.1
  bourgeoisie_1_N = mkN "bourgeoisie" utrum  ; -- bourgeoisie..nn.1
  bourgogne_1_N = mkN "bourgogne" "bourgogner" ; -- bourgogne..nn.1
  bourgognevin_1_N = mkN "bourgognevin" "bourgognevinet" "bourgogneviner" "bourgognevinerna" ; -- bourgognevin..nn.1
  boutique_1_N = mkN "boutique" "boutiquer" ; -- boutique..nn.1
  boutredare_1_N = mkN "boutredare" "boutredareen" "boutredarear" "boutredarearna" ; -- boutredare..nn.1
  boutredning_1_N = mkN "boutredning" ; -- boutredning..nn.1
  boutredningsman_1_N = mkN "boutredningsman" "boutredningsmannen" "boutredningsmän" "boutredningsmännen" ; -- boutredningsman..nn.1
  bouzouki_1_N = mkN "bouzouki" "bouzoukin" "bouzoukis" "bouzoukisen" ; -- bouzouki..nn.1
  bov_1_N = mkN "bov" ; -- bov..nn.1
  bovaktig_1_A = mkA "bovaktig" ; -- bovaktig..av.1
  bovaktighet_1_N = mkN "bovaktighet" ; -- bovaktighet..nn.1
  bovete_1_N = mkN "bovete" ; -- bovete..nn.1
  boveteplätt_1_N = mkN "boveteplätt" ; -- boveteplätt..nn.1
  bovfysionomi_1_N = mkN "bovfysionomi" "bovfysionomier" ; -- bovfysionomi..nn.1
  bovstreck_1_N = mkN "bovstreck" neutrum  ; -- bovstreck..nn.1
  bowla_1_V = mkV "bowlar" ; -- bowla..vb.1
  bowlande_1_N = mkN "bowlande" ; -- bowlande..nn.1
  bowlare_1_N = mkN "bowlare" utrum  ; -- bowlare..nn.1
  bowling_1_N = mkN "bowling" ; -- bowling..nn.1
  bowlingbana_1_N = mkN "bowlingbana" ; -- bowlingbana..nn.1
  bowlinghall_1_N = mkN "bowlinghall" ; -- bowlinghall..nn.1
  bowlingklot_1_N = mkN "bowlingklot" neutrum  ; -- bowlingklot..nn.1
  box_1_N = mkN "box" ; -- box..nn.1
  box_2_N = mkN "box" neutrum  ; -- box..nn.2
  boxa_1_V = mkV "boxar" ; -- boxa..vb.1
  boxande_1_N = mkN "boxande" ; -- boxande..nn.1
  boxare_1_N = mkN "boxare" utrum  ; -- boxare..nn.1
  boxboll_1_N = mkN "boxboll" ; -- boxboll..nn.1
  boxer_1_N = mkN "boxer" ; -- boxer..nn.1
  boxervalp_1_N = mkN "boxervalp" ; -- boxervalp..nn.1
  boxhandske_1_N = mkN "boxhandske" utrum  ; -- boxhandske..nn.1
  boxkalv_1_N = mkN "boxkalv" ; -- boxkalv..nn.1
  boxning_1_N = mkN "boxning" ; -- boxning..nn.1
  boxningslokal_1_N = mkN "boxningslokal" "boxningslokaler" ; -- boxningslokal..nn.1
  boxningsmatch_1_N = mkN "boxningsmatch" "boxningsmatcher" ; -- boxningsmatch..nn.1
  boxningsring_1_N = mkN "boxningsring" ; -- boxningsring..nn.1
  boxningstränad_1_A = mkA "boxningstränad" ; -- boxningstränad..av.1
  boxningsträning_1_N = mkN "boxningsträning" ; -- boxningsträning..nn.1
  boxnummer_1_N = mkN "boxnummer" neutrum  ; -- boxnummer..nn.1
  boyscout_1_N = mkN "boyscout" "boyscouter" ; -- boyscout..nn.1
  boägg_1_N = mkN "boägg" neutrum  ; -- boägg..nn.1
  bra_1_Adv = mkAdv "bra" ; -- bra..ab.1
  bra_2_Adv = mkAdv "bra" ; -- bra..ab.2
  bra_1_A = mkA "bra" "bra" "bra" "bättre" "bäst" ; -- bra..av.1
  bra_2_A = mkA "bra" ; -- bra..av.2
  bracka_1_N = mkN "bracka" ; -- bracka..nn.1
  brackig_1_A = mkA "brackig" ; -- brackig..av.1
  brackighet_1_N = mkN "brackighet" ; -- brackighet..nn.1
  brackvattenlevande_1_A = mkA "brackvattenlevande" ; -- brackvattenlevande..av.1
  bragd_1_N = mkN "bragd" "bragder" ; -- bragd..nn.1
  bragdguld_1_N = mkN "bragdguld" neutrum  ; -- bragdguld..nn.1
  bragdlopp_1_N = mkN "bragdlopp" neutrum  ; -- bragdlopp..nn.1
  bragdmässig_1_A = mkA "bragdmässig" ; -- bragdmässig..av.1
  bragelöfte_1_N = mkN "bragelöfte" ; -- bragelöfte..nn.1
  brailleskrift_1_N = mkN "brailleskrift" ; -- brailleskrift..nn.1
  brainstorming_1_N = mkN "brainstorming" ; -- brainstorming..nn.1
  brak_1_N = mkN "brak" neutrum  ; -- brak..nn.1
  braka_1_V = mkV "brakar" ; -- braka..vb.1
  brakande_1_N = mkN "brakande" ; -- brakande..nn.1
  brakfest_1_N = mkN "brakfest" "brakfester" ; -- brakfest..nn.1
  brakfiasko_1_N = mkN "brakfiasko" "brakfiaskot" "brakfiaskon" "brakfiaskona" ; -- brakfiasko..nn.1
  brakmiddag_1_N = mkN "brakmiddag" ; -- brakmiddag..nn.1
  brakskit_1_N = mkN "brakskit" ; -- brakskit..nn.1
  brakskiva_1_N = mkN "brakskiva" ; -- brakskiva..nn.1
  braksuccé_1_N = mkN "braksuccé" "braksuccéer" ; -- braksuccé..nn.1
  brakteat_1_N = mkN "brakteat" "brakteater" ; -- brakteat..nn.1
  brakved_1_N = mkN "brakved" ; -- brakved..nn.1
  brakycefal_1_A = mkA "brakycefal" ; -- brakycefal..av.1
  brakycefali_1_N = mkN "brakycefali" ; -- brakycefali..nn.1
  bralla_1_N = mkN "bralla" ; -- bralla..nn.1
  brallis_1_N = mkN "brallis" ; -- brallis..nn.1
  braman_1_N = mkN "braman" "bramaner" ; -- braman..nn.1
  bramanism_1_N = mkN "bramanism" "bramanismer" ; -- bramanism..nn.1
  bramansk_1_A = mkA "bramansk" ; -- bramansk..av.1
  bramin_1_N = mkN "bramin" "braminer" ; -- bramin..nn.1
  bramsegel_1_N = mkN "bramsegel" neutrum  ; -- bramsegel..nn.1
  bramstång_1_N = mkN "bramstång" "bramstänger" ; -- bramstång..nn.1
  brand_1_N = mkN "brand" "bränder" ; -- brand..nn.1
  brandalarm_1_N = mkN "brandalarm" neutrum  ; -- brandalarm..nn.1
  brandartikel_1_N = mkN "brandartikel" ; -- brandartikel..nn.1
  brandattentat_1_N = mkN "brandattentat" neutrum  ; -- brandattentat..nn.1
  brandbefäl_1_N = mkN "brandbefäl" neutrum  ; -- brandbefäl..nn.1
  brandbil_1_N = mkN "brandbil" ; -- brandbil..nn.1
  brandbomb_1_N = mkN "brandbomb" "brandbomber" ; -- brandbomb..nn.1
  brandbotten_1_N = mkN "brandbotten" ; -- brandbotten..nn.1
  brandchef_1_N = mkN "brandchef" "brandchefer" ; -- brandchef..nn.1
  branddike_1_N = mkN "branddike" ; -- branddike..nn.1
  branddörr_1_N = mkN "branddörr" ; -- branddörr..nn.1
  brandfackla_1_N = mkN "brandfackla" ; -- brandfackla..nn.1
  brandfara_1_N = mkN "brandfara" ; -- brandfara..nn.1
  brandfarlig_1_A = mkA "brandfarlig" ; -- brandfarlig..av.1
  brandfarlighet_1_N = mkN "brandfarlighet" ; -- brandfarlighet..nn.1
  brandfri_1_A = mkA "brandfri" "brandfritt" ; -- brandfri..av.1
  brandförsvar_1_N = mkN "brandförsvar" neutrum  ; -- brandförsvar..nn.1
  brandförsäkra_1_V = mkV "brandförsäkrar" ; -- brandförsäkra..vb.1
  brandförsäkring_1_N = mkN "brandförsäkring" ; -- brandförsäkring..nn.1
  brandförsäkringsavtal_1_N = mkN "brandförsäkringsavtal" neutrum  ; -- brandförsäkringsavtal..nn.1
  brandförsäkringsbelopp_1_N = mkN "brandförsäkringsbelopp" neutrum  ; -- brandförsäkringsbelopp..nn.1
  brandförsäkringsbolag_1_N = mkN "brandförsäkringsbolag" neutrum  ; -- brandförsäkringsbolag..nn.1
  brandförsäkringsvärde_1_N = mkN "brandförsäkringsvärde" ; -- brandförsäkringsvärde..nn.1
  brandgata_1_N = mkN "brandgata" ; -- brandgata..nn.1
  brandgavel_1_N = mkN "brandgavel" ; -- brandgavel..nn.1
  brandgranat_1_N = mkN "brandgranat" "brandgranater" ; -- brandgranat..nn.1
  brandgrav_1_N = mkN "brandgrav" ; -- brandgrav..nn.1
  brandgul_1_A = mkA "brandgul" ; -- brandgul..av.1
  brandhärd_1_N = mkN "brandhärd" ; -- brandhärd..nn.1
  brandhärdig_1_A = mkA "brandhärdig" ; -- brandhärdig..av.1
  brandhärdighet_1_N = mkN "brandhärdighet" ; -- brandhärdighet..nn.1
  brandhärja_1_V = mkV "brandhärjar" ; -- brandhärja..vb.1
  brandhärjande_1_N = mkN "brandhärjande" ; -- brandhärjande..nn.1
  brandingenjör_1_N = mkN "brandingenjör" "brandingenjörer" ; -- brandingenjör..nn.1
  brandinspektion_1_N = mkN "brandinspektion" ; -- brandinspektion..nn.1
  brandinspektör_1_N = mkN "brandinspektör" "brandinspektörer" ; -- brandinspektör..nn.1
  brandkapten_1_N = mkN "brandkapten" "brandkaptener" ; -- brandkapten..nn.1
  brandkatastrof_1_N = mkN "brandkatastrof" "brandkatastrofer" ; -- brandkatastrof..nn.1
  brandkår_1_N = mkN "brandkår" "brandkårer" ; -- brandkår..nn.1
  brandkårsfrivillig_1_A = mkA "brandkårsfrivillig" ; -- brandkårsfrivillig..av.1
  brandkårsutryckning_1_N = mkN "brandkårsutryckning" ; -- brandkårsutryckning..nn.1
  brandlager_1_N = mkN "brandlager" neutrum  ; -- brandlager..nn.1
  brandlarm_1_N = mkN "brandlarm" neutrum  ; -- brandlarm..nn.1
  brandlukt_1_N = mkN "brandlukt" ; -- brandlukt..nn.1
  brandman_1_N = mkN "brandman" "brandmannen" "brandmän" "brandmännen" ; -- brandman..nn.1
  brandmansgrepp_1_N = mkN "brandmansgrepp" neutrum  ; -- brandmansgrepp..nn.1
  brandmur_1_N = mkN "brandmur" ; -- brandmur..nn.1
  brandoffer_1_N = mkN "brandoffer" neutrum  ; -- brandoffer..nn.1
  brandorsak_1_N = mkN "brandorsak" "brandorsaker" ; -- brandorsak..nn.1
  brandpost_1_N = mkN "brandpost" "brandposter" ; -- brandpost..nn.1
  brandredskap_1_N = mkN "brandredskap" neutrum  ; -- brandredskap..nn.1
  brandrest_1_N = mkN "brandrest" "brandrester" ; -- brandrest..nn.1
  brandrök_1_N = mkN "brandrök" ; -- brandrök..nn.1
  brandrör_1_N = mkN "brandrör" neutrum  ; -- brandrör..nn.1
  brandschaktare_1_N = mkN "brandschaktare" utrum  ; -- brandschaktare..nn.1
  brandsegel_1_N = mkN "brandsegel" neutrum  ; -- brandsegel..nn.1
  brandskada_1_N = mkN "brandskada" ; -- brandskada..nn.1
  brandskadad_1_A = mkA "brandskadad" ; -- brandskadad..av.1
  brandskatt_1_N = mkN "brandskatt" "brandskatter" ; -- brandskatt..nn.1
  brandskatta_1_V = mkV "brandskattar" ; -- brandskatta..vb.1
  brandskattande_1_N = mkN "brandskattande" ; -- brandskattande..nn.1
  brandskattning_1_N = mkN "brandskattning" ; -- brandskattning..nn.1
  brandskydd_1_N = mkN "brandskydd" neutrum  ; -- brandskydd..nn.1
  brandskyddslagstiftning_1_N = mkN "brandskyddslagstiftning" ; -- brandskyddslagstiftning..nn.1
  brandskåp_1_N = mkN "brandskåp" neutrum  ; -- brandskåp..nn.1
  brandslang_1_N = mkN "brandslang" ; -- brandslang..nn.1
  brandsläckarattrapp_1_N = mkN "brandsläckarattrapp" "brandsläckarattrapper" ; -- brandsläckarattrapp..nn.1
  brandsläckare_1_N = mkN "brandsläckare" utrum  ; -- brandsläckare..nn.1
  brandsoldat_1_N = mkN "brandsoldat" "brandsoldater" ; -- brandsoldat..nn.1
  brandspruta_1_N = mkN "brandspruta" ; -- brandspruta..nn.1
  brandstation_1_N = mkN "brandstation" ; -- brandstation..nn.1
  brandstege_1_N = mkN "brandstege" utrum  ; -- brandstege..nn.1
  brandstod_1_N = mkN "brandstod" ; -- brandstod..nn.1
  brandstodsbolag_1_N = mkN "brandstodsbolag" neutrum  ; -- brandstodsbolag..nn.1
  brandstyrka_1_N = mkN "brandstyrka" ; -- brandstyrka..nn.1
  brandsvamp_1_N = mkN "brandsvamp" ; -- brandsvamp..nn.1
  brandsyn_1_N = mkN "brandsyn" "brandsyner" ; -- brandsyn..nn.1
  brandsäker_1_A = mkA "brandsäker" ; -- brandsäker..av.1
  brandsäkerhet_1_N = mkN "brandsäkerhet" ; -- brandsäkerhet..nn.1
  brandtal_1_N = mkN "brandtal" neutrum  ; -- brandtal..nn.1
  brandtorn_1_N = mkN "brandtorn" neutrum  ; -- brandtorn..nn.1
  brandvakt_1_N = mkN "brandvakt" "brandvakter" ; -- brandvakt..nn.1
  brandvarnare_1_N = mkN "brandvarnare" utrum  ; -- brandvarnare..nn.1
  brandväsen_1_N = mkN "brandväsen" neutrum  ; -- brandväsen..nn.1
  brandövning_1_N = mkN "brandövning" ; -- brandövning..nn.1
  bransch_1_N = mkN "bransch" "branscher" ; -- bransch..nn.1
  branschförening_1_N = mkN "branschförening" ; -- branschförening..nn.1
  branschledande_1_A = mkA "branschledande" ; -- branschledande..av.1
  branschmässig_1_A = mkA "branschmässig" ; -- branschmässig..av.1
  branschorganisation_1_N = mkN "branschorganisation" ; -- branschorganisation..nn.1
  branschråd_1_N = mkN "branschråd" neutrum  ; -- branschråd..nn.1
  branschtidning_1_N = mkN "branschtidning" ; -- branschtidning..nn.1
  branschvana_1_N = mkN "branschvana" ; -- branschvana..nn.1
  brant_1_A = mkA "brant" "brant" ; -- brant..av.1
  brant_1_N = mkN "brant" "branter" ; -- brant..nn.1
  branthet_1_N = mkN "branthet" ; -- branthet..nn.1
  brasa_1_N = mkN "brasa" ; -- brasa..nn.1
  brasilian_1_N = mkN "brasilian" "brasilianer" ; -- brasilian..nn.1
  brasilianare_1_N = mkN "brasilianare" utrum  ; -- brasilianare..nn.1
  brasiliansk_1_A = mkA "brasiliansk" ; -- brasiliansk..av.1
  brasilianska_1_N = mkN "brasilianska" ; -- brasilianska..nn.1
  brasilier_1_N = mkN "brasilier" "brasiliern" "brasilier" "brasilierna" ; -- brasilier..nn.1
  braska_1_V = mkV "braskar" ; -- braska..vb.1
  braskande_1_A = mkA "braskande" ; -- braskande..av.1
  braskande_1_N = mkN "braskande" ; -- braskande..nn.1
  brasklapp_1_N = mkN "brasklapp" ; -- brasklapp..nn.1
  brass_1_N = mkN "brass" neutrum  ; -- brass..nn.1
  brassa_1_V = mkV "brassar" ; -- brassa..vb.1
  brassande_1_N = mkN "brassande" ; -- brassande..nn.1
  brasse_1_N = mkN "brasse" utrum  ; -- brasse..nn.1
  braständare_1_N = mkN "braständare" utrum  ; -- braständare..nn.1
  brasved_1_N = mkN "brasved" ; -- brasved..nn.1
  brat_1_N = mkN "brat" ; -- brat..nn.1
  brats_1_N = mkN "brats" ; -- brats..nn.1
  bravad_1_N = mkN "bravad" "bravader" ; -- bravad..nn.1
  bravera_1_V = mkV "braverar" ; -- bravera..vb.1
  braverande_1_N = mkN "braverande" ; -- braverande..nn.1
  bravorop_1_N = mkN "bravorop" neutrum  ; -- bravorop..nn.1
  bravur_1_N = mkN "bravur" ; -- bravur..nn.1
  bravuraria_1_N = mkN "bravuraria" ; -- bravuraria..nn.1
  bravurnummer_1_N = mkN "bravurnummer" neutrum  ; -- bravurnummer..nn.1
  bravurroll_1_N = mkN "bravurroll" "bravurroller" ; -- bravurroll..nn.1
  braxen_1_N = mkN "braxen" ; -- braxen..nn.1
  braxengräs_1_N = mkN "braxengräs" neutrum  ; -- braxengräs..nn.1
  braxenmygga_1_N = mkN "braxenmygga" ; -- braxenmygga..nn.1
  braxenpanka_1_N = mkN "braxenpanka" ; -- braxenpanka..nn.1
  bre_1_V = mkV "bre" "bredde" "brett" ; -- bre..vb.1
  break_1_N = mkN "break" neutrum  ; -- break..nn.1
  breakdance_1_N = mkN "breakdance" utrum  ; -- breakdance..nn.1
  breccia_1_N = mkN "breccia" ; -- breccia..nn.1
  bred_1_A = mkA "bred" "brett" ; -- bred..av.1
  bredande_1_N = mkN "bredande" ; -- bredande..nn.1
  bredaxlad_1_A = mkA "bredaxlad" ; -- bredaxlad..av.1
  bredband_1_N = mkN "bredband" neutrum  ; -- bredband..nn.1
  bredbandsföretag_1_N = mkN "bredbandsföretag" neutrum  ; -- bredbandsföretag..nn.1
  bredbar_1_A = mkA "bredbar" ; -- bredbar..av.1
  bredbarhet_1_N = mkN "bredbarhet" ; -- bredbarhet..nn.1
  bredbent_1_A = mkA "bredbent" "bredbent" ; -- bredbent..av.1
  bredbenthet_1_N = mkN "bredbenthet" ; -- bredbenthet..nn.1
  bredbladig_1_A = mkA "bredbladig" ; -- bredbladig..av.1
  bredbladighet_1_N = mkN "bredbladighet" ; -- bredbladighet..nn.1
  bredbrättad_1_A = mkA "bredbrättad" ; -- bredbrättad..av.1
  bredbrättig_1_A = mkA "bredbrättig" ; -- bredbrättig..av.1
  bredbrättighet_1_N = mkN "bredbrättighet" ; -- bredbrättighet..nn.1
  bredd_1_N = mkN "bredd" "bredder" ; -- bredd..nn.1
  bredda_1_V = mkV "breddar" ; -- bredda..vb.1
  breddande_1_N = mkN "breddande" ; -- breddande..nn.1
  breddgrad_1_N = mkN "breddgrad" "breddgrader" ; -- breddgrad..nn.1
  breddidrott_1_N = mkN "breddidrott" "breddidrotter" ; -- breddidrott..nn.1
  breddmässig_1_A = mkA "breddmässig" ; -- breddmässig..av.1
  breddning_1_N = mkN "breddning" ; -- breddning..nn.1
  bredhet_1_N = mkN "bredhet" ; -- bredhet..nn.1
  bredkäftad_1_A = mkA "bredkäftad" ; -- bredkäftad..av.1
  bredmun_1_N = mkN "bredmun" "bredmunnen" "bredmunnar" "bredmunnarna" ; -- bredmun..nn.1
  bredmynt_1_A = mkA "bredmynt" "bredmynt" ; -- bredmynt..av.1
  bredmynthet_1_N = mkN "bredmynthet" ; -- bredmynthet..nn.1
  bredrandig_1_A = mkA "bredrandig" ; -- bredrandig..av.1
  bredrandighet_1_N = mkN "bredrandighet" ; -- bredrandighet..nn.1
  bredsida_1_N = mkN "bredsida" ; -- bredsida..nn.1
  bredskyggig_1_A = mkA "bredskyggig" ; -- bredskyggig..av.1
  bredskyggighet_1_N = mkN "bredskyggighet" ; -- bredskyggighet..nn.1
  bredspackel_1_N = mkN "bredspackel" ; -- bredspackel..nn.1
  bredspektrumantiviral_1_A = mkA "bredspektrumantiviral" ; -- bredspektrumantiviral..av.1
  bredspårig_1_A = mkA "bredspårig" ; -- bredspårig..av.1
  bredspårighet_1_N = mkN "bredspårighet" ; -- bredspårighet..nn.1
  bredså_1_V = mkV "bredsår" ; -- bredså..vb.1
  bredsådd_1_N = mkN "bredsådd" ; -- bredsådd..nn.1
  bredsående_1_N = mkN "bredsående" ; -- bredsående..nn.1
  bredvidläsning_1_N = mkN "bredvidläsning" ; -- bredvidläsning..nn.1
  breende_1_N = mkN "breende" ; -- breende..nn.1
  brems_1_N = mkN "brems" ; -- brems..nn.1
  bremsa_1_V = mkV "bremsar" ; -- bremsa..vb.1
  bremsande_1_N = mkN "bremsande" ; -- bremsande..nn.1
  bremsning_1_N = mkN "bremsning" ; -- bremsning..nn.1
  bresilja_1_N = mkN "bresilja" ; -- bresilja..nn.1
  bretagnare_1_N = mkN "bretagnare" utrum  ; -- bretagnare..nn.1
  bretagnisk_1_A = mkA "bretagnisk" ; -- bretagnisk..av.1
  bretagniska_1_N = mkN "bretagniska" ; -- bretagniska..nn.1
  bretagniska_2_N = mkN "bretagniska" ; -- bretagniska..nn.2
  breton_1_N = mkN "breton" "bretoner" ; -- breton..nn.1
  bretonsk_1_A = mkA "bretonsk" ; -- bretonsk..av.1
  bretonska_1_N = mkN "bretonska" ; -- bretonska..nn.1
  bretonska_2_N = mkN "bretonska" ; -- bretonska..nn.2
  brev_1_N = mkN "brev" neutrum  ; -- brev..nn.1
  brevbomb_1_N = mkN "brevbomb" "brevbomber" ; -- brevbomb..nn.1
  brevbärare_1_N = mkN "brevbärare" utrum  ; -- brevbärare..nn.1
  brevbäring_1_N = mkN "brevbäring" ; -- brevbäring..nn.1
  brevcensur_1_N = mkN "brevcensur" ; -- brevcensur..nn.1
  brevdialog_1_N = mkN "brevdialog" "brevdialoger" ; -- brevdialog..nn.1
  brevduva_1_N = mkN "brevduva" ; -- brevduva..nn.1
  brevenkät_1_N = mkN "brevenkät" "brevenkäter" ; -- brevenkät..nn.1
  brevfack_1_N = mkN "brevfack" neutrum  ; -- brevfack..nn.1
  brevfråga_1_N = mkN "brevfråga" ; -- brevfråga..nn.1
  brevförsändelse_1_N = mkN "brevförsändelse" "brevförsändelser" ; -- brevförsändelse..nn.1
  brevhemlighet_1_N = mkN "brevhemlighet" "brevhemligheter" ; -- brevhemlighet..nn.1
  brevhuvud_1_N = mkN "brevhuvud" "brevhuvudet" "brevhuvud" "brevhuvudena" ; -- brevhuvud..nn.1
  breviarium_1_N = mkN "breviarium" "breviariet" "breviarier" "breviarierna" ; -- breviarium..nn.1
  brevinkast_1_N = mkN "brevinkast" neutrum  ; -- brevinkast..nn.1
  brevkort_1_N = mkN "brevkort" neutrum  ; -- brevkort..nn.1
  brevlapp_1_N = mkN "brevlapp" ; -- brevlapp..nn.1
  brevledes_1_Adv = mkAdv "brevledes" ; -- brevledes..ab.1
  brevlåda_1_N = mkN "brevlåda" ; -- brevlåda..nn.1
  brevlådeföretag_1_N = mkN "brevlådeföretag" neutrum  ; -- brevlådeföretag..nn.1
  brevlådeliknande_1_A = mkA "brevlådeliknande" ; -- brevlådeliknande..av.1
  brevlådetömning_1_N = mkN "brevlådetömning" ; -- brevlådetömning..nn.1
  brevpapper_1_N = mkN "brevpapper" neutrum  ; -- brevpapper..nn.1
  brevporto_1_N = mkN "brevporto" "brevportot" "brevporton" "brevportona" ; -- brevporto..nn.1
  brevpress_1_N = mkN "brevpress" ; -- brevpress..nn.1
  brevroman_1_N = mkN "brevroman" "brevromaner" ; -- brevroman..nn.1
  brevsamling_1_N = mkN "brevsamling" ; -- brevsamling..nn.1
  brevskola_1_N = mkN "brevskola" ; -- brevskola..nn.1
  brevskrivande_1_A = mkA "brevskrivande" ; -- brevskrivande..av.1
  brevskrivande_1_N = mkN "brevskrivande" ; -- brevskrivande..nn.1
  brevskrivare_1_N = mkN "brevskrivare" utrum  ; -- brevskrivare..nn.1
  brevskörd_1_N = mkN "brevskörd" ; -- brevskörd..nn.1
  brevstil_1_N = mkN "brevstil" ; -- brevstil..nn.1
  brevställ_1_N = mkN "brevställ" neutrum  ; -- brevställ..nn.1
  brevställare_1_N = mkN "brevställare" utrum  ; -- brevställare..nn.1
  brevsvar_1_N = mkN "brevsvar" neutrum  ; -- brevsvar..nn.1
  brevtelegram_1_N = mkN "brevtelegram" "brevtelegrammet" "brevtelegram" "brevtelegrammen" ; -- brevtelegram..nn.1
  brevvän_1_N = mkN "brevvän" "brevvännen" "brevvänner" "brevvännerna" ; -- brevvän..nn.1
  brevväxla_1_V = mkV "brevväxlar" ; -- brevväxla..vb.1
  brevväxlande_1_N = mkN "brevväxlande" ; -- brevväxlande..nn.1
  brevväxling_1_N = mkN "brevväxling" ; -- brevväxling..nn.1
  brevvåg_1_N = mkN "brevvåg" ; -- brevvåg..nn.1
  brevöppnare_1_N = mkN "brevöppnare" utrum  ; -- brevöppnare..nn.1
  bricka_1_N = mkN "bricka" ; -- bricka..nn.1
  brickband_1_N = mkN "brickband" neutrum  ; -- brickband..nn.1
  brickbord_1_N = mkN "brickbord" neutrum  ; -- brickbord..nn.1
  brickduk_1_N = mkN "brickduk" ; -- brickduk..nn.1
  bricklunch_1_N = mkN "bricklunch" "brickluncher" ; -- bricklunch..nn.1
  brickplockare_1_N = mkN "brickplockare" utrum  ; -- brickplockare..nn.1
  brickunderlägg_1_N = mkN "brickunderlägg" neutrum  ; -- brickunderlägg..nn.1
  brickvävd_1_A = mkA "brickvävd" "brickvävt" ; -- brickvävd..av.1
  brickvävning_1_N = mkN "brickvävning" ; -- brickvävning..nn.1
  bridge_1_N = mkN "bridge" utrum  ; -- bridge..nn.1
  bridgebord_1_N = mkN "bridgebord" neutrum  ; -- bridgebord..nn.1
  bridgejunta_1_N = mkN "bridgejunta" ; -- bridgejunta..nn.1
  bridong_1_N = mkN "bridong" "bridonger" ; -- bridong..nn.1
  bridreaktor_1_N = mkN "bridreaktor" "bridreaktorer" ; -- bridreaktor..nn.1
  briefa_1_V = mkV "briefar" ; -- briefa..vb.1
  briefande_1_N = mkN "briefande" ; -- briefande..nn.1
  brigad_1_N = mkN "brigad" "brigader" ; -- brigad..nn.1
  brigadchef_1_N = mkN "brigadchef" "brigadchefer" ; -- brigadchef..nn.1
  brigadgeneral_1_N = mkN "brigadgeneral" "brigadgeneraler" ; -- brigadgeneral..nn.1
  brigadstab_1_N = mkN "brigadstab" "brigadstaber" ; -- brigadstab..nn.1
  brigadvis_1_Adv = mkAdv "brigadvis" ; -- brigadvis..ab.1
  brigadvis_1_A = mkA "brigadvis" ; -- brigadvis..av.1
  brigadör_1_N = mkN "brigadör" "brigadörer" ; -- brigadör..nn.1
  brigantin_1_N = mkN "brigantin" "brigantiner" ; -- brigantin..nn.1
  brigg_1_N = mkN "brigg" ; -- brigg..nn.1
  briggsegel_1_N = mkN "briggsegel" neutrum  ; -- briggsegel..nn.1
  brikett_1_N = mkN "brikett" "briketter" ; -- brikett..nn.1
  brikettera_1_V = mkV "briketterar" ; -- brikettera..vb.1
  briketterande_1_N = mkN "briketterande" ; -- briketterande..nn.1
  briketterbar_1_A = mkA "briketterbar" ; -- briketterbar..av.1
  briketterbarhet_1_N = mkN "briketterbarhet" ; -- briketterbarhet..nn.1
  brikettering_1_N = mkN "brikettering" ; -- brikettering..nn.1
  brikettpress_1_N = mkN "brikettpress" ; -- brikettpress..nn.1
  brikollstöt_1_N = mkN "brikollstöt" ; -- brikollstöt..nn.1
  briljans_1_N = mkN "briljans" ; -- briljans..nn.1
  briljant_1_A = mkA "briljant" "briljant" ; -- briljant..av.1
  briljant_1_N = mkN "briljant" "briljanter" ; -- briljant..nn.1
  briljanterad_1_A = mkA "briljanterad" ; -- briljanterad..av.1
  briljantglas_1_N = mkN "briljantglas" neutrum  ; -- briljantglas..nn.1
  briljantin_1_N = mkN "briljantin" ; -- briljantin..nn.1
  briljantring_1_N = mkN "briljantring" ; -- briljantring..nn.1
  briljantsmyckad_1_A = mkA "briljantsmyckad" ; -- briljantsmyckad..av.1
  briljantsmycke_1_N = mkN "briljantsmycke" ; -- briljantsmycke..nn.1
  briljera_1_V = mkV "briljerar" ; -- briljera..vb.1
  briljerande_1_N = mkN "briljerande" ; -- briljerande..nn.1
  briljering_1_N = mkN "briljering" ; -- briljering..nn.1
  brilliant_1_N = mkN "brilliant" ; -- brilliant..nn.1
  bringa_1_N = mkN "bringa" ; -- bringa..nn.1
  bringa_1_V = mkV "bringar" ; -- bringa..vb.1
  bringande_1_N = mkN "bringande" ; -- bringande..nn.1
  brink_1_N = mkN "brink" ; -- brink..nn.1
  brinna_1_V = mkV "brinna" "brann" "brunnit" ; -- brinna..vb.1
  brinna_2_V = mkV "brinna" "brann" "brunnit" ; -- brinna..vb.2
  brinnande_1_A = mkA "brinnande" ; -- brinnande..av.1
  brinnande_1_N = mkN "brinnande" ; -- brinnande..nn.1
  brinnsträcka_1_N = mkN "brinnsträcka" ; -- brinnsträcka..nn.1
  brio_1_N = mkN "brio" ; -- brio..nn.1
  bris_1_N = mkN "bris" ; -- bris..nn.1
  brisad_1_N = mkN "brisad" "brisader" ; -- brisad..nn.1
  brisans_1_N = mkN "brisans" "brisanser" ; -- brisans..nn.1
  brisansgranat_1_N = mkN "brisansgranat" "brisansgranater" ; -- brisansgranat..nn.1
  brisant_1_A = mkA "brisant" "brisant" ; -- brisant..av.1
  brisant_1_N = mkN "brisant" "brisanter" ; -- brisant..nn.1
  brisera_1_V = mkV "briserar" ; -- brisera..vb.1
  briserande_1_N = mkN "briserande" ; -- briserande..nn.1
  briserbar_1_A = mkA "briserbar" ; -- briserbar..av.1
  briserbarhet_1_N = mkN "briserbarhet" ; -- briserbarhet..nn.1
  brisering_1_N = mkN "brisering" ; -- brisering..nn.1
  brisken_1_A = mkA "brisken" ; -- brisken..av.1
  briskenhet_1_N = mkN "briskenhet" ; -- briskenhet..nn.1
  brissling_1_N = mkN "brissling" ; -- brissling..nn.1
  brist_1_N = mkN "brist" "brister" ; -- brist..nn.1
  brista_1_V = mkV "brista" "brast" "brustit" ; -- brista..vb.1
  brista_2_V = mkV "brista" "brast" "brustit" ; -- brista..vb.2
  bristande_1_A = mkA "bristande" ; -- bristande..av.1
  bristande_1_N = mkN "bristande" ; -- bristande..nn.1
  bristfällig_1_A = mkA "bristfällig" ; -- bristfällig..av.1
  bristfällighet_1_N = mkN "bristfällighet" "bristfälligheter" ; -- bristfällighet..nn.1
  bristläge_1_N = mkN "bristläge" ; -- bristläge..nn.1
  bristning_1_N = mkN "bristning" ; -- bristning..nn.1
  bristningsgräns_1_N = mkN "bristningsgräns" ; -- bristningsgräns..nn.1
  bristsituation_1_N = mkN "bristsituation" ; -- bristsituation..nn.1
  bristsjukdom_1_N = mkN "bristsjukdom" ; -- bristsjukdom..nn.1
  bristvara_1_N = mkN "bristvara" ; -- bristvara..nn.1
  bristyrke_1_N = mkN "bristyrke" ; -- bristyrke..nn.1
  britanniametall_1_N = mkN "britanniametall" ; -- britanniametall..nn.1
  britannisk_1_A = mkA "britannisk" ; -- britannisk..av.1
  brits_1_N = mkN "brits" ; -- brits..nn.1
  britt_1_N = mkN "britt" "britter" ; -- britt..nn.1
  brittisk_1_A = mkA "brittisk" ; -- brittisk..av.1
  brittiska_1_N = mkN "brittiska" ; -- brittiska..nn.1
  brittmässa_1_N = mkN "brittmässa" ; -- brittmässa..nn.1
  brittsommar_1_N = mkN "brittsommar" "brittsommaren" "brittsomrar" "brittsomrarna" ; -- brittsommar..nn.1
  brittsommarväder_1_N = mkN "brittsommarväder" neutrum  ; -- brittsommarväder..nn.1
  bro_1_N = mkN "bro" ; -- bro..nn.1
  broa_1_V = mkV "broar" ; -- broa..vb.1
  broande_1_N = mkN "broande" ; -- broande..nn.1
  broavgift_1_N = mkN "broavgift" "broavgifter" ; -- broavgift..nn.1
  brobana_1_N = mkN "brobana" ; -- brobana..nn.1
  brobelastning_1_N = mkN "brobelastning" ; -- brobelastning..nn.1
  brobygge_1_N = mkN "brobygge" ; -- brobygge..nn.1
  brobyggnad_1_N = mkN "brobyggnad" ; -- brobyggnad..nn.1
  brobänk_1_N = mkN "brobänk" ; -- brobänk..nn.1
  brochette_1_N = mkN "brochette" "brochetter" ; -- brochette..nn.1
  brock_1_N = mkN "brock" ; -- brock..nn.1
  brock_2_N = mkN "brock" neutrum  ; -- brock..nn.2
  brockband_1_N = mkN "brockband" neutrum  ; -- brockband..nn.1
  brockfågel_1_N = mkN "brockfågel" ; -- brockfågel..nn.1
  brodd_1_N = mkN "brodd" ; -- brodd..nn.1
  brodda_1_V = mkV "broddar" ; -- brodda..vb.1
  broddande_1_N = mkN "broddande" ; -- broddande..nn.1
  broder_1_N = mkN "broder" "brodern" "bröder" "bröderna" ; -- broder..nn.1
  brodera_1_V = mkV "broderar" ; -- brodera..vb.1
  broderande_1_N = mkN "broderande" ; -- broderande..nn.1
  broderbar_1_A = mkA "broderbar" ; -- broderbar..av.1
  broderbarhet_1_N = mkN "broderbarhet" ; -- broderbarhet..nn.1
  broderbok_1_N = mkN "broderbok" "broderböcker" ; -- broderbok..nn.1
  broderbåge_1_N = mkN "broderbåge" utrum  ; -- broderbåge..nn.1
  broderfolk_1_N = mkN "broderfolk" neutrum  ; -- broderfolk..nn.1
  brodergarn_1_N = mkN "brodergarn" neutrum  ; -- brodergarn..nn.1
  broderi_1_N = mkN "broderi" "broderiet" "broderier" "broderierna" ; -- broderi..nn.1
  brodering_1_N = mkN "brodering" ; -- brodering..nn.1
  broderland_1_N = mkN "broderland" "broderlandet" "broderländer" "broderländerna" ; -- broderland..nn.1
  broderlig_1_A = mkA "broderlig" ; -- broderlig..av.1
  broderlighet_1_N = mkN "broderlighet" ; -- broderlighet..nn.1
  brodermord_1_N = mkN "brodermord" neutrum  ; -- brodermord..nn.1
  brodermördare_1_N = mkN "brodermördare" utrum  ; -- brodermördare..nn.1
  brodernål_1_N = mkN "brodernål" ; -- brodernål..nn.1
  brodersax_1_N = mkN "brodersax" ; -- brodersax..nn.1
  brodersilke_1_N = mkN "brodersilke" ; -- brodersilke..nn.1
  broderskap_1_N = mkN "broderskap" neutrum  ; -- broderskap..nn.1
  broderskärlek_1_N = mkN "broderskärlek" ; -- broderskärlek..nn.1
  brodersöm_1_N = mkN "brodersöm" "brodersömmen" "brodersömmar" "brodersömmarna" ; -- brodersöm..nn.1
  brodyr_1_N = mkN "brodyr" "brodyrer" ; -- brodyr..nn.1
  brodös_1_N = mkN "brodös" "brodöser" ; -- brodös..nn.1
  brofäste_1_N = mkN "brofäste" ; -- brofäste..nn.1
  brohus_1_N = mkN "brohus" neutrum  ; -- brohus..nn.1
  brohuvud_1_N = mkN "brohuvud" "brohuvudet" "brohuvud" "brohuvudena" ; -- brohuvud..nn.1
  broiler_1_N = mkN "broiler" ; -- broiler..nn.1
  brok_1_N = mkN "brok" ; -- brok..nn.1
  brokad_1_N = mkN "brokad" "brokader" ; -- brokad..nn.1
  brokanal_1_N = mkN "brokanal" "brokanaler" ; -- brokanal..nn.1
  brokar_1_N = mkN "brokar" neutrum  ; -- brokar..nn.1
  brokbladig_1_A = mkA "brokbladig" ; -- brokbladig..av.1
  brokbladighet_1_N = mkN "brokbladighet" ; -- brokbladighet..nn.1
  brokblommig_1_A = mkA "brokblommig" ; -- brokblommig..av.1
  brokblommighet_1_N = mkN "brokblommighet" ; -- brokblommighet..nn.1
  brokig_1_A = mkA "brokig" ; -- brokig..av.1
  brokighet_1_N = mkN "brokighet" "brokigheter" ; -- brokighet..nn.1
  brokista_1_N = mkN "brokista" ; -- brokista..nn.1
  brokspett_1_N = mkN "brokspett" ; -- brokspett..nn.1
  brolla_1_N = mkN "brolla" ; -- brolla..nn.1
  brolopp_1_N = mkN "brolopp" neutrum  ; -- brolopp..nn.1
  brolägga_1_V = mkV "brolägga" "brola" "brolagt" ; -- brolägga..vb.1
  broläggande_1_N = mkN "broläggande" ; -- broläggande..nn.1
  brom_1_N = mkN "brom" ; -- brom..nn.1
  bromelia_1_N = mkN "bromelia" ; -- bromelia..nn.1
  bromera_1_V = mkV "bromerar" ; -- bromera..vb.1
  bromerande_1_N = mkN "bromerande" ; -- bromerande..nn.1
  bromerbar_1_A = mkA "bromerbar" ; -- bromerbar..av.1
  bromerbarhet_1_N = mkN "bromerbarhet" ; -- bromerbarhet..nn.1
  bromering_1_N = mkN "bromering" ; -- bromering..nn.1
  bromförgiftning_1_N = mkN "bromförgiftning" ; -- bromförgiftning..nn.1
  bromid_1_N = mkN "bromid" "bromider" ; -- bromid..nn.1
  bromism_1_N = mkN "bromism" "bromismer" ; -- bromism..nn.1
  bromläcka_1_N = mkN "bromläcka" ; -- bromläcka..nn.1
  broms_1_N = mkN "broms" ; -- broms..nn.1
  bromsa_1_V = mkV "bromsar" ; -- bromsa..vb.1
  bromsande_1_N = mkN "bromsande" ; -- bromsande..nn.1
  bromsare_1_N = mkN "bromsare" utrum  ; -- bromsare..nn.1
  bromsback_1_N = mkN "bromsback" ; -- bromsback..nn.1
  bromsband_1_N = mkN "bromsband" neutrum  ; -- bromsband..nn.1
  bromsbelägg_1_N = mkN "bromsbelägg" neutrum  ; -- bromsbelägg..nn.1
  bromsblock_1_N = mkN "bromsblock" neutrum  ; -- bromsblock..nn.1
  bromscylinder_1_N = mkN "bromscylinder" ; -- bromscylinder..nn.1
  bromsfading_1_N = mkN "bromsfading" ; -- bromsfading..nn.1
  bromsfel_1_N = mkN "bromsfel" "bromsfelet" "bromsfel" "bromsfelen" ; -- bromsfel..nn.1
  bromsgaller_1_N = mkN "bromsgaller" neutrum  ; -- bromsgaller..nn.1
  bromshandtag_1_N = mkN "bromshandtag" neutrum  ; -- bromshandtag..nn.1
  bromsilverpapper_1_N = mkN "bromsilverpapper" neutrum  ; -- bromsilverpapper..nn.1
  bromsklaff_1_N = mkN "bromsklaff" ; -- bromsklaff..nn.1
  bromskloss_1_N = mkN "bromskloss" ; -- bromskloss..nn.1
  bromskraft_1_N = mkN "bromskraft" ; -- bromskraft..nn.1
  bromsljus_1_N = mkN "bromsljus" neutrum  ; -- bromsljus..nn.1
  bromsmedicin_1_N = mkN "bromsmedicin" "bromsmediciner" ; -- bromsmedicin..nn.1
  bromsning_1_N = mkN "bromsning" ; -- bromsning..nn.1
  bromsolja_1_N = mkN "bromsolja" ; -- bromsolja..nn.1
  bromspedal_1_N = mkN "bromspedal" "bromspedaler" ; -- bromspedal..nn.1
  bromsraket_1_N = mkN "bromsraket" "bromsraketer" ; -- bromsraket..nn.1
  bromsservo_1_N = mkN "bromsservo" ; -- bromsservo..nn.1
  bromsskiva_1_N = mkN "bromsskiva" ; -- bromsskiva..nn.1
  bromssko_1_N = mkN "bromssko" "bromsskor" ; -- bromssko..nn.1
  bromsskärm_1_N = mkN "bromsskärm" ; -- bromsskärm..nn.1
  bromsspår_1_N = mkN "bromsspår" neutrum  ; -- bromsspår..nn.1
  bromssträcka_1_N = mkN "bromssträcka" ; -- bromssträcka..nn.1
  bromsstrålning_1_N = mkN "bromsstrålning" ; -- bromsstrålning..nn.1
  bromssystem_1_N = mkN "bromssystem" neutrum  ; -- bromssystem..nn.1
  bromstrumma_1_N = mkN "bromstrumma" ; -- bromstrumma..nn.1
  bromsvagn_1_N = mkN "bromsvagn" ; -- bromsvagn..nn.1
  bromsvätska_1_N = mkN "bromsvätska" ; -- bromsvätska..nn.1
  bromtymolblått_1_N = mkN "bromtymolblått" ; -- bromtymolblått..nn.1
  bromural_1_N = mkN "bromural" neutrum  ; -- bromural..nn.1
  bromväte_1_N = mkN "bromväte" ; -- bromväte..nn.1
  bromvätesyra_1_N = mkN "bromvätesyra" ; -- bromvätesyra..nn.1
  bromyl_1_N = mkN "bromyl" ; -- bromyl..nn.1
  bronkialastma_1_N = mkN "bronkialastma" ; -- bronkialastma..nn.1
  bronkit_1_N = mkN "bronkit" "bronkiter" ; -- bronkit..nn.1
  bronkografi_1_N = mkN "bronkografi" "bronkografier" ; -- bronkografi..nn.1
  bronkoskop_1_N = mkN "bronkoskop" neutrum  ; -- bronkoskop..nn.1
  bronkoskopi_1_N = mkN "bronkoskopi" "bronkoskopier" ; -- bronkoskopi..nn.1
  brons_1_N = mkN "brons" neutrum  ; -- brons..nn.1
  brons_2_N = mkN "brons" "bronser" ; -- brons..nn.2
  brons_3_N = mkN "brons" "bronser" ; -- brons..nn.3
  bronsborste_1_N = mkN "bronsborste" utrum  ; -- bronsborste..nn.1
  bronsera_1_V = mkV "bronserar" ; -- bronsera..vb.1
  bronserande_1_N = mkN "bronserande" ; -- bronserande..nn.1
  bronserbar_1_A = mkA "bronserbar" ; -- bronserbar..av.1
  bronserbarhet_1_N = mkN "bronserbarhet" ; -- bronserbarhet..nn.1
  bronsering_1_N = mkN "bronsering" ; -- bronsering..nn.1
  bronsfärg_1_N = mkN "bronsfärg" ; -- bronsfärg..nn.1
  bronsfärgad_1_A = mkA "bronsfärgad" ; -- bronsfärgad..av.1
  bronsförgylla_1_V = mkV "bronsförgyller" ; -- bronsförgylla..vb.1
  bronsförgyllande_1_N = mkN "bronsförgyllande" ; -- bronsförgyllande..nn.1
  bronsinfattad_1_A = mkA "bronsinfattad" ; -- bronsinfattad..av.1
  bronskanna_1_N = mkN "bronskanna" ; -- bronskanna..nn.1
  bronsknapp_1_N = mkN "bronsknapp" ; -- bronsknapp..nn.1
  bronskärl_1_N = mkN "bronskärl" neutrum  ; -- bronskärl..nn.1
  bronsmedalj_1_N = mkN "bronsmedalj" "bronsmedaljer" ; -- bronsmedalj..nn.1
  bronsmedaljör_1_N = mkN "bronsmedaljör" "bronsmedaljörer" ; -- bronsmedaljör..nn.1
  bronsmynt_1_N = mkN "bronsmynt" neutrum  ; -- bronsmynt..nn.1
  bronsmärke_1_N = mkN "bronsmärke" ; -- bronsmärke..nn.1
  bronssmycke_1_N = mkN "bronssmycke" ; -- bronssmycke..nn.1
  bronsspänne_1_N = mkN "bronsspänne" ; -- bronsspänne..nn.1
  bronsstaty_1_N = mkN "bronsstaty" "bronsstatyer" ; -- bronsstaty..nn.1
  bronsstatyett_1_N = mkN "bronsstatyett" "bronsstatyetter" ; -- bronsstatyett..nn.1
  bronssvärd_1_N = mkN "bronssvärd" neutrum  ; -- bronssvärd..nn.1
  bronstavla_1_N = mkN "bronstavla" ; -- bronstavla..nn.1
  bronsyxa_1_N = mkN "bronsyxa" ; -- bronsyxa..nn.1
  bronsålder_1_N = mkN "bronsålder" ; -- bronsålder..nn.1
  bronsåldersfynd_1_N = mkN "bronsåldersfynd" neutrum  ; -- bronsåldersfynd..nn.1
  bronsåldersgrav_1_N = mkN "bronsåldersgrav" ; -- bronsåldersgrav..nn.1
  bronsåldersmänniska_1_N = mkN "bronsåldersmänniska" ; -- bronsåldersmänniska..nn.1
  broolycka_1_N = mkN "broolycka" ; -- broolycka..nn.1
  bropelare_1_N = mkN "bropelare" utrum  ; -- bropelare..nn.1
  bropeng_1_N = mkN "bropeng" ; -- bropeng..nn.1
  bropenning_1_N = mkN "bropenning" ; -- bropenning..nn.1
  broplanka_1_N = mkN "broplanka" ; -- broplanka..nn.1
  bror_1_N = mkN "bror" "bröder" ; -- bror..nn.1
  brorsa_1_N = mkN "brorsa" ; -- brorsa..nn.1
  brorsarv_1_N = mkN "brorsarv" neutrum  ; -- brorsarv..nn.1
  brorsbarn_1_N = mkN "brorsbarn" neutrum  ; -- brorsbarn..nn.1
  brorsdotter_1_N = mkN "brorsdotter" "brorsdottern" "brorsdöttrar" "brorsdöttrarna" ; -- brorsdotter..nn.1
  brorskål_1_N = mkN "brorskål" ; -- brorskål..nn.1
  brorslott_1_N = mkN "brorslott" "brorslotter" ; -- brorslott..nn.1
  brorson_1_N = mkN "brorson" "brorsöner" ; -- brorson..nn.1
  brorsskål_1_N = mkN "brorsskål" ; -- brorsskål..nn.1
  brosch_1_N = mkN "brosch" "broscher" ; -- brosch..nn.1
  broschera_1_V = mkV "broscherar" ; -- broschera..vb.1
  broscherad_1_A = mkA "broscherad" ; -- broscherad..av.1
  broscherande_1_N = mkN "broscherande" ; -- broscherande..nn.1
  broscherbar_1_A = mkA "broscherbar" ; -- broscherbar..av.1
  broscherbarhet_1_N = mkN "broscherbarhet" ; -- broscherbarhet..nn.1
  broschering_1_N = mkN "broschering" ; -- broschering..nn.1
  broschyr_1_N = mkN "broschyr" "broschyrer" ; -- broschyr..nn.1
  brosk_1_N = mkN "brosk" neutrum  ; -- brosk..nn.1
  broskartad_1_A = mkA "broskartad" ; -- broskartad..av.1
  broskfisk_1_N = mkN "broskfisk" ; -- broskfisk..nn.1
  broskhinna_1_N = mkN "broskhinna" ; -- broskhinna..nn.1
  broskskiva_1_N = mkN "broskskiva" ; -- broskskiva..nn.1
  broskskivling_1_N = mkN "broskskivling" ; -- broskskivling..nn.1
  brosksvamp_1_N = mkN "brosksvamp" ; -- brosksvamp..nn.1
  broskverk_1_N = mkN "broskverk" neutrum  ; -- broskverk..nn.1
  broskvävnad_1_N = mkN "broskvävnad" "broskvävnader" ; -- broskvävnad..nn.1
  broslagning_1_N = mkN "broslagning" ; -- broslagning..nn.1
  brosme_1_N = mkN "brosme" utrum  ; -- brosme..nn.1
  brospann_1_N = mkN "brospann" neutrum  ; -- brospann..nn.1
  brossla_1_V = mkV "brosslar" ; -- brossla..vb.1
  brosslande_1_N = mkN "brosslande" ; -- brosslande..nn.1
  brotsch_1_N = mkN "brotsch" ; -- brotsch..nn.1
  brotscha_1_V = mkV "brotschar" ; -- brotscha..vb.1
  brotschande_1_N = mkN "brotschande" ; -- brotschande..nn.1
  brott_1_N = mkN "brott" neutrum  ; -- brott..nn.1
  brott_2_N = mkN "brott" neutrum  ; -- brott..nn.2
  brottare_1_N = mkN "brottare" utrum  ; -- brottare..nn.1
  brottarlegendar_1_N = mkN "brottarlegendar" "brottarlegendarer" ; -- brottarlegendar..nn.1
  brottmål_1_N = mkN "brottmål" neutrum  ; -- brottmål..nn.1
  brottmålsdomare_1_N = mkN "brottmålsdomare" utrum  ; -- brottmålsdomare..nn.1
  brottmålsdomstol_1_N = mkN "brottmålsdomstol" ; -- brottmålsdomstol..nn.1
  brottmålsprocess_1_N = mkN "brottmålsprocess" "brottmålsprocesser" ; -- brottmålsprocess..nn.1
  brottning_1_N = mkN "brottning" ; -- brottning..nn.1
  brottningsgrepp_1_N = mkN "brottningsgrepp" neutrum  ; -- brottningsgrepp..nn.1
  brottningskamp_1_N = mkN "brottningskamp" "brottningskamper" ; -- brottningskamp..nn.1
  brottningsmatch_1_N = mkN "brottningsmatch" "brottningsmatcher" ; -- brottningsmatch..nn.1
  brottningsring_1_N = mkN "brottningsring" ; -- brottningsring..nn.1
  brottsbalk_1_N = mkN "brottsbalk" ; -- brottsbalk..nn.1
  brottsbekämpande_1_N = mkN "brottsbekämpande" ; -- brottsbekämpande..nn.1
  brottsbekämpning_1_N = mkN "brottsbekämpning" ; -- brottsbekämpning..nn.1
  brottsbevakning_1_N = mkN "brottsbevakning" ; -- brottsbevakning..nn.1
  brottsförebyggande_1_A = mkA "brottsförebyggande" ; -- brottsförebyggande..av.1
  brottshistoria_1_N = mkN "brottshistoria" ; -- brottshistoria..nn.1
  brottsjournalistik_1_N = mkN "brottsjournalistik" ; -- brottsjournalistik..nn.1
  brottsjö_1_N = mkN "brottsjö" ; -- brottsjö..nn.1
  brottskonkurrens_1_N = mkN "brottskonkurrens" ; -- brottskonkurrens..nn.1
  brottslig_1_A = mkA "brottslig" ; -- brottslig..av.1
  brottslighet_1_N = mkN "brottslighet" "brottsligheter" ; -- brottslighet..nn.1
  brottsling_1_N = mkN "brottsling" ; -- brottsling..nn.1
  brottsmisstanke_1_N = mkN "brottsmisstanke" utrum  ; -- brottsmisstanke..nn.1
  brottsmisstänkt_1_A = mkA "brottsmisstänkt" "brottsmisstänkt" ; -- brottsmisstänkt..av.1
  brottsmål_1_N = mkN "brottsmål" neutrum  ; -- brottsmål..nn.1
  brottsoffer_1_N = mkN "brottsoffer" neutrum  ; -- brottsoffer..nn.1
  brottsplats_1_N = mkN "brottsplats" "brottsplatser" ; -- brottsplats..nn.1
  brottsplatsexpert_1_N = mkN "brottsplatsexpert" "brottsplatsexperter" ; -- brottsplatsexpert..nn.1
  brottsplatstekniker_1_N = mkN "brottsplatstekniker" "brottsplatsteknikern" "brottsplatstekniker" "brottsplatsteknikerna" ; -- brottsplatstekniker..nn.1
  brottsplatsundersökning_1_N = mkN "brottsplatsundersökning" ; -- brottsplatsundersökning..nn.1
  brottsprovokation_1_N = mkN "brottsprovokation" ; -- brottsprovokation..nn.1
  brottsregister_1_N = mkN "brottsregister" neutrum  ; -- brottsregister..nn.1
  brottsrekvisit_1_N = mkN "brottsrekvisit" neutrum  ; -- brottsrekvisit..nn.1
  brottsrubricering_1_N = mkN "brottsrubricering" ; -- brottsrubricering..nn.1
  brottstillfälle_1_N = mkN "brottstillfälle" ; -- brottstillfälle..nn.1
  brottstycke_1_N = mkN "brottstycke" ; -- brottstycke..nn.1
  brottställe_1_N = mkN "brottställe" ; -- brottställe..nn.1
  brottsutreda_1_V = mkV "brottsutredar" ; -- brottsutreda..vb.1
  brottsutredande_1_N = mkN "brottsutredande" ; -- brottsutredande..nn.1
  brottsutredning_1_N = mkN "brottsutredning" ; -- brottsutredning..nn.1
  brottyta_1_N = mkN "brottyta" ; -- brottyta..nn.1
  brovalv_1_N = mkN "brovalv" neutrum  ; -- brovalv..nn.1
  browning_1_N = mkN "browning" ; -- browning..nn.1
  broöppning_1_N = mkN "broöppning" ; -- broöppning..nn.1
  bruckel_1_N = mkN "bruckel" neutrum  ; -- bruckel..nn.1
  bruckla_1_V = mkV "brucklar" ; -- bruckla..vb.1
  brucklande_1_N = mkN "brucklande" ; -- brucklande..nn.1
  brud_1_N = mkN "brud" ; -- brud..nn.1
  brudand_1_N = mkN "brudand" "brudänder" ; -- brudand..nn.1
  brudborste_1_N = mkN "brudborste" utrum  ; -- brudborste..nn.1
  brudbröd_1_N = mkN "brudbröd" neutrum  ; -- brudbröd..nn.1
  brudbukett_1_N = mkN "brudbukett" "brudbuketter" ; -- brudbukett..nn.1
  brudfoto_1_N = mkN "brudfoto" "brudfotot" "brudfoton" "brudfotona" ; -- brudfoto..nn.1
  brudfrämma_1_N = mkN "brudfrämma" ; -- brudfrämma..nn.1
  brudfölje_1_N = mkN "brudfölje" ; -- brudfölje..nn.1
  brudgum_1_N = mkN "brudgum" "brudgummen" "brudgummar" "brudgummarna" ; -- brudgum..nn.1
  brudgåva_1_N = mkN "brudgåva" ; -- brudgåva..nn.1
  brudklänning_1_N = mkN "brudklänning" ; -- brudklänning..nn.1
  brudkrona_1_N = mkN "brudkrona" ; -- brudkrona..nn.1
  brudköp_1_N = mkN "brudköp" neutrum  ; -- brudköp..nn.1
  brudmystik_1_N = mkN "brudmystik" ; -- brudmystik..nn.1
  brudnäbb_1_N = mkN "brudnäbb" ; -- brudnäbb..nn.1
  brudpall_1_N = mkN "brudpall" ; -- brudpall..nn.1
  brudpar_1_N = mkN "brudpar" neutrum  ; -- brudpar..nn.1
  brudpäll_1_N = mkN "brudpäll" ; -- brudpäll..nn.1
  brudrov_1_N = mkN "brudrov" neutrum  ; -- brudrov..nn.1
  brudslöja_1_N = mkN "brudslöja" ; -- brudslöja..nn.1
  brudsporre_1_N = mkN "brudsporre" utrum  ; -- brudsporre..nn.1
  brudstol_1_N = mkN "brudstol" ; -- brudstol..nn.1
  brudsäng_1_N = mkN "brudsäng" ; -- brudsäng..nn.1
  brudtärna_1_N = mkN "brudtärna" ; -- brudtärna..nn.1
  brudöverlämning_1_N = mkN "brudöverlämning" ; -- brudöverlämning..nn.1
  brugd_1_N = mkN "brugd" "brugder" ; -- brugd..nn.1
  bruk_1_N = mkN "bruk" neutrum  ; -- bruk..nn.1
  bruk_2_N = mkN "bruk" neutrum  ; -- bruk..nn.2
  bruka_1_V = mkV "brukar" ; -- bruka..vb.1
  brukande_1_N = mkN "brukande" ; -- brukande..nn.1
  brukare_1_N = mkN "brukare" utrum  ; -- brukare..nn.1
  brukbar_1_A = mkA "brukbar" ; -- brukbar..av.1
  brukbarhet_1_N = mkN "brukbarhet" ; -- brukbarhet..nn.1
  bruklig_1_A = mkA "bruklig" ; -- bruklig..av.1
  bruklighet_1_N = mkN "bruklighet" "brukligheter" ; -- bruklighet..nn.1
  brukning_1_N = mkN "brukning" ; -- brukning..nn.1
  brukningsenhet_1_N = mkN "brukningsenhet" "brukningsenheter" ; -- brukningsenhet..nn.1
  bruksanvisning_1_N = mkN "bruksanvisning" ; -- bruksanvisning..nn.1
  bruksarbetare_1_N = mkN "bruksarbetare" utrum  ; -- bruksarbetare..nn.1
  bruksartikel_1_N = mkN "bruksartikel" ; -- bruksartikel..nn.1
  bruksdisponent_1_N = mkN "bruksdisponent" "bruksdisponenter" ; -- bruksdisponent..nn.1
  bruksdjur_1_N = mkN "bruksdjur" neutrum  ; -- bruksdjur..nn.1
  bruksdrift_1_N = mkN "bruksdrift" ; -- bruksdrift..nn.1
  bruksföremål_1_N = mkN "bruksföremål" neutrum  ; -- bruksföremål..nn.1
  brukshund_1_N = mkN "brukshund" ; -- brukshund..nn.1
  brukskonst_1_N = mkN "brukskonst" ; -- brukskonst..nn.1
  brukslagare_1_N = mkN "brukslagare" utrum  ; -- brukslagare..nn.1
  brukslev_1_N = mkN "brukslev" ; -- brukslev..nn.1
  brukslå_1_V = mkV "brukslå" "brukslog" "brukslagit" ; -- brukslå..vb.1
  brukslående_1_N = mkN "brukslående" ; -- brukslående..nn.1
  bruksort_1_N = mkN "bruksort" "bruksorter" ; -- bruksort..nn.1
  brukspatron_1_N = mkN "brukspatron" "brukspatroner" ; -- brukspatron..nn.1
  bruksrörelse_1_N = mkN "bruksrörelse" "bruksrörelser" ; -- bruksrörelse..nn.1
  brukssamhälle_1_N = mkN "brukssamhälle" ; -- brukssamhälle..nn.1
  bruksvärde_1_N = mkN "bruksvärde" ; -- bruksvärde..nn.1
  bruksvärdeshyra_1_N = mkN "bruksvärdeshyra" ; -- bruksvärdeshyra..nn.1
  brulépudding_1_N = mkN "brulépudding" ; -- brulépudding..nn.1
  brumbas_1_N = mkN "brumbas" ; -- brumbas..nn.1
  brumbjörn_1_N = mkN "brumbjörn" ; -- brumbjörn..nn.1
  brumkör_1_N = mkN "brumkör" "brumkörer" ; -- brumkör..nn.1
  brumma_1_V = mkV "brummar" ; -- brumma..vb.1
  brummande_1_N = mkN "brummande" ; -- brummande..nn.1
  brummare_1_N = mkN "brummare" utrum  ; -- brummare..nn.1
  brumning_1_N = mkN "brumning" ; -- brumning..nn.1
  brun_1_A = mkA "brun" ; -- brun..av.1
  brunaktig_1_A = mkA "brunaktig" ; -- brunaktig..av.1
  brunaktighet_1_N = mkN "brunaktighet" ; -- brunaktighet..nn.1
  brunalg_1_N = mkN "brunalg" "brunalger" ; -- brunalg..nn.1
  brunand_1_N = mkN "brunand" "brunänder" ; -- brunand..nn.1
  brunbetsa_1_V = mkV "brunbetsar" ; -- brunbetsa..vb.1
  brunbetsande_1_N = mkN "brunbetsande" ; -- brunbetsande..nn.1
  brunbetsning_1_N = mkN "brunbetsning" ; -- brunbetsning..nn.1
  brunbränd_1_A = mkA "brunbränd" ; -- brunbränd..av.1
  brunbär_1_N = mkN "brunbär" neutrum  ; -- brunbär..nn.1
  brunch_1_N = mkN "brunch" "bruncher" ; -- brunch..nn.1
  brunchtest_1_N = mkN "brunchtest" neutrum  ; -- brunchtest..nn.1
  bruneier_1_N = mkN "bruneier" "bruneiern" "bruneier" "bruneierna" ; -- bruneier..nn.1
  bruneisk_1_A = mkA "bruneisk" ; -- bruneisk..av.1
  bruneiska_1_N = mkN "bruneiska" ; -- bruneiska..nn.1
  brunera_1_V = mkV "brunerar" ; -- brunera..vb.1
  brunerande_1_N = mkN "brunerande" ; -- brunerande..nn.1
  brunerbar_1_A = mkA "brunerbar" ; -- brunerbar..av.1
  brunerbarhet_1_N = mkN "brunerbarhet" ; -- brunerbarhet..nn.1
  brunering_1_N = mkN "brunering" ; -- brunering..nn.1
  brunett_1_A = mkA "brunett" ; -- brunett..av.1
  brunett_1_N = mkN "brunett" "brunetter" ; -- brunett..nn.1
  brunfärga_1_V = mkV "brunfärgar" ; -- brunfärga..vb.1
  brunfärgad_1_A = mkA "brunfärgad" ; -- brunfärgad..av.1
  brunfärgande_1_N = mkN "brunfärgande" ; -- brunfärgande..nn.1
  brunglänsande_1_A = mkA "brunglänsande" ; -- brunglänsande..av.1
  brungrå_1_A = mkA "brungrå" "brungrått" ; -- brungrå..av.1
  brungul_1_A = mkA "brungul" ; -- brungul..av.1
  brunhet_1_N = mkN "brunhet" ; -- brunhet..nn.1
  brunhyad_1_A = mkA "brunhyad" ; -- brunhyad..av.1
  brunhårig_1_A = mkA "brunhårig" ; -- brunhårig..av.1
  brunhårighet_1_N = mkN "brunhårighet" ; -- brunhårighet..nn.1
  brunjord_1_N = mkN "brunjord" ; -- brunjord..nn.1
  brunkol_1_N = mkN "brunkol" neutrum  ; -- brunkol..nn.1
  brunkolsdoft_1_N = mkN "brunkolsdoft" ; -- brunkolsdoft..nn.1
  brunkulla_1_N = mkN "brunkulla" ; -- brunkulla..nn.1
  brunkål_1_N = mkN "brunkål" ; -- brunkål..nn.1
  brunlackerad_1_A = mkA "brunlackerad" ; -- brunlackerad..av.1
  brunmurrig_1_A = mkA "brunmurrig" ; -- brunmurrig..av.1
  brunmurrighet_1_N = mkN "brunmurrighet" ; -- brunmurrighet..nn.1
  brunmålad_1_A = mkA "brunmålad" ; -- brunmålad..av.1
  brunn_1_N = mkN "brunn" ; -- brunn..nn.1
  brunnsdrickning_1_N = mkN "brunnsdrickning" ; -- brunnsdrickning..nn.1
  brunnshus_1_N = mkN "brunnshus" neutrum  ; -- brunnshus..nn.1
  brunnskall_1_A = mkA "brunnskall" ; -- brunnskall..av.1
  brunnskar_1_N = mkN "brunnskar" neutrum  ; -- brunnskar..nn.1
  brunnskur_1_N = mkN "brunnskur" "brunnskurer" ; -- brunnskur..nn.1
  brunnsläkare_1_N = mkN "brunnsläkare" utrum  ; -- brunnsläkare..nn.1
  brunnsort_1_N = mkN "brunnsort" "brunnsorter" ; -- brunnsort..nn.1
  brunnspark_1_N = mkN "brunnspark" ; -- brunnspark..nn.1
  brunnssvängel_1_N = mkN "brunnssvängel" ; -- brunnssvängel..nn.1
  brunnsvatten_1_N = mkN "brunnsvatten" "brunnsvattnet" "brunnsvatten" "brunnsvattnen" ; -- brunnsvatten..nn.1
  brunnsöppning_1_N = mkN "brunnsöppning" ; -- brunnsöppning..nn.1
  brunockra_1_N = mkN "brunockra" ; -- brunockra..nn.1
  brunrost_1_N = mkN "brunrost" ; -- brunrost..nn.1
  brunrutig_1_A = mkA "brunrutig" ; -- brunrutig..av.1
  brunrutighet_1_N = mkN "brunrutighet" ; -- brunrutighet..nn.1
  brunråtta_1_N = mkN "brunråtta" ; -- brunråtta..nn.1
  brunröd_1_A = mkA "brunröd" "brunrött" ; -- brunröd..av.1
  brunröta_1_N = mkN "brunröta" ; -- brunröta..nn.1
  brunskjorta_1_N = mkN "brunskjorta" ; -- brunskjorta..nn.1
  brunskära_1_N = mkN "brunskära" ; -- brunskära..nn.1
  brunsmutsig_1_A = mkA "brunsmutsig" ; -- brunsmutsig..av.1
  brunst_1_N = mkN "brunst" ; -- brunst..nn.1
  brunstig_1_A = mkA "brunstig" ; -- brunstig..av.1
  brunstighet_1_N = mkN "brunstighet" ; -- brunstighet..nn.1
  brunsttid_1_N = mkN "brunsttid" "brunsttider" ; -- brunsttid..nn.1
  brunsvart_1_A = mkA "brunsvart" "brunsvart" ; -- brunsvart..av.1
  brunte_1_N = mkN "brunte" utrum  ; -- brunte..nn.1
  brunögd_1_A = mkA "brunögd" "brunögt" ; -- brunögd..av.1
  brunögdhet_1_N = mkN "brunögdhet" ; -- brunögdhet..nn.1
  brunört_1_N = mkN "brunört" "brunörter" ; -- brunört..nn.1
  brus_1_N = mkN "brus" neutrum  ; -- brus..nn.1
  brusa_1_V = mkV "brusar" ; -- brusa..vb.1
  brusande_1_N = mkN "brusande" ; -- brusande..nn.1
  brusdryck_1_N = mkN "brusdryck" "brusdrycker" ; -- brusdryck..nn.1
  brushane_1_N = mkN "brushane" utrum  ; -- brushane..nn.1
  brushuvud_1_N = mkN "brushuvud" "brushuvudet" "brushuvud" "brushuvudena" ; -- brushuvud..nn.1
  brusig_1_A = mkA "brusig" ; -- brusig..av.1
  brusighet_1_N = mkN "brusighet" "brusigheter" ; -- brusighet..nn.1
  brustablett_1_N = mkN "brustablett" "brustabletter" ; -- brustablett..nn.1
  brusten_1_A = mkA "brusten" ; -- brusten..av.1
  brustenhet_1_N = mkN "brustenhet" ; -- brustenhet..nn.1
  brutal_1_A = mkA "brutal" ; -- brutal..av.1
  brutalisera_1_V = mkV "brutaliserar" ; -- brutalisera..vb.1
  brutaliserande_1_N = mkN "brutaliserande" ; -- brutaliserande..nn.1
  brutaliserbar_1_A = mkA "brutaliserbar" ; -- brutaliserbar..av.1
  brutaliserbarhet_1_N = mkN "brutaliserbarhet" ; -- brutaliserbarhet..nn.1
  brutalisering_1_N = mkN "brutalisering" ; -- brutalisering..nn.1
  brutalitet_1_N = mkN "brutalitet" "brutaliteter" ; -- brutalitet..nn.1
  bruten_1_A = mkA "bruten" ; -- bruten..av.1
  brutta_1_N = mkN "brutta" ; -- brutta..nn.1
  brutto_1_N = mkN "brutto" "bruttot" "brutton" "bruttona" ; -- brutto..nn.1
  bruttoavkastning_1_N = mkN "bruttoavkastning" ; -- bruttoavkastning..nn.1
  bruttobehållning_1_N = mkN "bruttobehållning" ; -- bruttobehållning..nn.1
  bruttobelopp_1_N = mkN "bruttobelopp" neutrum  ; -- bruttobelopp..nn.1
  bruttodräktighet_1_N = mkN "bruttodräktighet" "bruttodräktigheter" ; -- bruttodräktighet..nn.1
  bruttoformel_1_N = mkN "bruttoformel" "bruttoformeln" "bruttoformler" "bruttoformlerna" ; -- bruttoformel..nn.1
  bruttoinkomst_1_N = mkN "bruttoinkomst" "bruttoinkomster" ; -- bruttoinkomst..nn.1
  bruttolön_1_N = mkN "bruttolön" "bruttolöner" ; -- bruttolön..nn.1
  bruttonationalprodukt_1_N = mkN "bruttonationalprodukt" "bruttonationalprodukter" ; -- bruttonationalprodukt..nn.1
  bruttopris_1_N = mkN "bruttopris" neutrum  ; -- bruttopris..nn.1
  bruttoregisterton_1_N = mkN "bruttoregisterton" "bruttoregistertonnet" "bruttoregisterton" "bruttoregistertonnen" ; -- bruttoregisterton..nn.1
  bruttovikt_1_N = mkN "bruttovikt" ; -- bruttovikt..nn.1
  bruttovinst_1_N = mkN "bruttovinst" "bruttovinster" ; -- bruttovinst..nn.1
  bruttovärde_1_N = mkN "bruttovärde" ; -- bruttovärde..nn.1
  bry_1_N = mkN "bry" neutrum  ; -- bry..nn.1
  bry_1_V = mkV "bryr" ; -- bry..vb.1
  brydd_1_A = mkA "brydd" ; -- brydd..av.1
  bryddhet_1_N = mkN "bryddhet" ; -- bryddhet..nn.1
  bryderi_1_N = mkN "bryderi" "bryderiet" "bryderier" "bryderierna" ; -- bryderi..nn.1
  brydsam_1_A = mkA "brydsam" "brydsamt" "brydsamma" "brydsamma" "brydsammare" "brydsammast" "brydsammaste" ; -- brydsam..av.1
  brydsamhet_1_N = mkN "brydsamhet" ; -- brydsamhet..nn.1
  bryende_1_N = mkN "bryende" ; -- bryende..nn.1
  brygd_1_N = mkN "brygd" "brygder" ; -- brygd..nn.1
  brygga_1_N = mkN "brygga" ; -- brygga..nn.1
  brygga_1_V = mkV "brygger" ; -- brygga..vb.1
  brygga_2_V = mkV "bryggar" ; -- brygga..vb.2
  bryggande_1_N = mkN "bryggande" ; -- bryggande..nn.1
  bryggarbil_1_N = mkN "bryggarbil" ; -- bryggarbil..nn.1
  bryggare_1_N = mkN "bryggare" utrum  ; -- bryggare..nn.1
  bryggdans_1_N = mkN "bryggdans" ; -- bryggdans..nn.1
  bryggeri_1_N = mkN "bryggeri" "bryggeriet" "bryggerier" "bryggerierna" ; -- bryggeri..nn.1
  bryggerijäst_1_N = mkN "bryggerijäst" ; -- bryggerijäst..nn.1
  bryggerijätte_1_N = mkN "bryggerijätte" utrum  ; -- bryggerijätte..nn.1
  brygghus_1_N = mkN "brygghus" neutrum  ; -- brygghus..nn.1
  bryggjäst_1_N = mkN "bryggjäst" ; -- bryggjäst..nn.1
  bryggkaffe_1_N = mkN "bryggkaffe" ; -- bryggkaffe..nn.1
  bryggkant_1_N = mkN "bryggkant" "bryggkanter" ; -- bryggkant..nn.1
  bryggmald_1_A = mkA "bryggmald" "bryggmalt" ; -- bryggmald..av.1
  bryggmalen_1_A = mkA "bryggmalen" ; -- bryggmalen..av.1
  bryggplats_1_N = mkN "bryggplats" "bryggplatser" ; -- bryggplats..nn.1
  bryggvåg_1_N = mkN "bryggvåg" ; -- bryggvåg..nn.1
  brylling_1_N = mkN "brylling" ; -- brylling..nn.1
  brylå_1_N = mkN "brylå" "brylåer" ; -- brylå..nn.1
  brylépudding_1_N = mkN "brylépudding" ; -- brylépudding..nn.1
  bryn_1_N = mkN "bryn" neutrum  ; -- bryn..nn.1
  bryna_1_V = mkV "bryna" "bryner" "bryn" "brynte" "brynt" "brynt" ; -- bryna..vb.1
  bryna_2_V = mkV "brynar" ; -- bryna..vb.2
  brynande_1_N = mkN "brynande" ; -- brynande..nn.1
  bryne_1_N = mkN "bryne" ; -- bryne..nn.1
  brynja_1_N = mkN "brynja" ; -- brynja..nn.1
  brynset_1_N = mkN "brynset" neutrum  ; -- brynset..nn.1
  brynsten_1_N = mkN "brynsten" "brynstenen" "brynstenar" "brynstenarna" ; -- brynsten..nn.1
  brynstål_1_N = mkN "brynstål" neutrum  ; -- brynstål..nn.1
  bryolog_1_N = mkN "bryolog" "bryologer" ; -- bryolog..nn.1
  bryologi_1_N = mkN "bryologi" ; -- bryologi..nn.1
  brysk_1_A = mkA "brysk" ; -- brysk..av.1
  bryskhet_1_N = mkN "bryskhet" ; -- bryskhet..nn.1
  brysselkål_1_N = mkN "brysselkål" ; -- brysselkål..nn.1
  brysselmatta_1_N = mkN "brysselmatta" ; -- brysselmatta..nn.1
  brysselspets_1_N = mkN "brysselspets" ; -- brysselspets..nn.1
  bryta_1_V = mkV "bryta" "bröt" "brutit" ; -- bryta..vb.1
  brytande_1_N = mkN "brytande" ; -- brytande..nn.1
  brytare_1_N = mkN "brytare" utrum  ; -- brytare..nn.1
  brytarfel_1_N = mkN "brytarfel" "brytarfelet" "brytarfel" "brytarfelen" ; -- brytarfel..nn.1
  brytbar_1_A = mkA "brytbar" ; -- brytbar..av.1
  brytbarhet_1_N = mkN "brytbarhet" ; -- brytbarhet..nn.1
  brytblad_1_N = mkN "brytblad" neutrum  ; -- brytblad..nn.1
  brytbladskniv_1_N = mkN "brytbladskniv" ; -- brytbladskniv..nn.1
  brytböna_1_N = mkN "brytböna" ; -- brytböna..nn.1
  bryte_1_N = mkN "bryte" utrum  ; -- bryte..nn.1
  brytning_1_N = mkN "brytning" ; -- brytning..nn.1
  brytningsexponent_1_N = mkN "brytningsexponent" "brytningsexponenter" ; -- brytningsexponent..nn.1
  brytningsfel_1_N = mkN "brytningsfel" "brytningsfelet" "brytningsfel" "brytningsfelen" ; -- brytningsfel..nn.1
  brytningsförmåga_1_N = mkN "brytningsförmåga" ; -- brytningsförmåga..nn.1
  brytningsgräns_1_N = mkN "brytningsgräns" ; -- brytningsgräns..nn.1
  brytningsindex_1_N = mkN "brytningsindex" neutrum  ; -- brytningsindex..nn.1
  brytningsperiod_1_N = mkN "brytningsperiod" "brytningsperioder" ; -- brytningsperiod..nn.1
  brytningspunkt_1_N = mkN "brytningspunkt" "brytningspunkter" ; -- brytningspunkt..nn.1
  brytningstid_1_N = mkN "brytningstid" "brytningstider" ; -- brytningstid..nn.1
  brytningsvinkel_1_N = mkN "brytningsvinkel" ; -- brytningsvinkel..nn.1
  brytningsår_1_N = mkN "brytningsår" neutrum  ; -- brytningsår..nn.1
  brytpunkt_1_N = mkN "brytpunkt" "brytpunkter" ; -- brytpunkt..nn.1
  brytvapen_1_N = mkN "brytvapen" "brytvapnet" "brytvapen" "brytvapnen" ; -- brytvapen..nn.1
  bräck_1_N = mkN "bräck" neutrum  ; -- bräck..nn.1
  bräcka_1_V = mkV "bräcker" ; -- bräcka..vb.1
  bräckage_1_N = mkN "bräckage" ; -- bräckage..nn.1
  bräckande_1_N = mkN "bräckande" ; -- bräckande..nn.1
  bräckhammare_1_N = mkN "bräckhammare" "bräckhammaren" "bräckhammare" "bräckhamrarna" ; -- bräckhammare..nn.1
  bräckjärn_1_N = mkN "bräckjärn" neutrum  ; -- bräckjärn..nn.1
  bräckkorv_1_N = mkN "bräckkorv" ; -- bräckkorv..nn.1
  bräcklig_1_A = mkA "bräcklig" ; -- bräcklig..av.1
  bräcklighet_1_N = mkN "bräcklighet" ; -- bräcklighet..nn.1
  bräckning_1_N = mkN "bräckning" ; -- bräckning..nn.1
  bräckt_1_A = mkA "bräckt" "bräckt" ; -- bräckt..av.1
  bräckthet_1_N = mkN "bräckthet" ; -- bräckthet..nn.1
  bräckvatten_1_N = mkN "bräckvatten" "bräckvattnet" "bräckvatten" "bräckvattnen" ; -- bräckvatten..nn.1
  bräda_1_N = mkN "bräda" ; -- bräda..nn.1
  bräda_1_V = mkV "brädar" ; -- bräda..vb.1
  brädande_1_N = mkN "brädande" ; -- brädande..nn.1
  brädbeklä_1_V = mkV "brädbeklä" "brädbeklädde" "brädbeklätt" ; -- brädbeklä..vb.1
  brädbeklädande_1_N = mkN "brädbeklädande" ; -- brädbeklädande..nn.1
  brädbeklädd_1_A = mkA "brädbeklädd" ; -- brädbeklädd..av.1
  brädbeklädnad_1_N = mkN "brädbeklädnad" "brädbeklädnader" ; -- brädbeklädnad..nn.1
  brädbeslå_1_V = mkV "brädbeslå" "brädbeslog" "brädbeslagit" ; -- brädbeslå..vb.1
  brädbeslående_1_N = mkN "brädbeslående" ; -- brädbeslående..nn.1
  brädd_1_N = mkN "brädd" ; -- brädd..nn.1
  brädda_1_V = mkV "bräddar" ; -- brädda..vb.1
  bräddande_1_N = mkN "bräddande" ; -- bräddande..nn.1
  bräddavlopp_1_N = mkN "bräddavlopp" neutrum  ; -- bräddavlopp..nn.1
  bräddfull_1_A = mkA "bräddfull" ; -- bräddfull..av.1
  bräddfullhet_1_N = mkN "bräddfullhet" ; -- bräddfullhet..nn.1
  bräddfylld_1_A = mkA "bräddfylld" "bräddfyllt" ; -- bräddfylld..av.1
  bräddfylldhet_1_N = mkN "bräddfylldhet" ; -- bräddfylldhet..nn.1
  bräde_1_N = mkN "bräde" ; -- bräde..nn.1
  brädfodra_1_V = mkV "brädfodrar" ; -- brädfodra..vb.1
  brädfodrande_1_N = mkN "brädfodrande" ; -- brädfodrande..nn.1
  brädgång_1_N = mkN "brädgång" ; -- brädgång..nn.1
  brädgård_1_N = mkN "brädgård" ; -- brädgård..nn.1
  brädplank_1_N = mkN "brädplank" neutrum  ; -- brädplank..nn.1
  brädsegla_1_V = mkV "brädseglar" ; -- brädsegla..vb.1
  brädseglande_1_N = mkN "brädseglande" ; -- brädseglande..nn.1
  brädslå_1_V = mkV "brädslå" "brädslog" "brädslagit" ; -- brädslå..vb.1
  brädslående_1_N = mkN "brädslående" ; -- brädslående..nn.1
  brädspel_1_N = mkN "brädspel" "brädspelet" "brädspel" "brädspelen" ; -- brädspel..nn.1
  brädvägg_1_N = mkN "brädvägg" ; -- brädvägg..nn.1
  bräka_1_V = mkV "bräker" ; -- bräka..vb.1
  bräkande_1_N = mkN "bräkande" ; -- bräkande..nn.1
  bräken_1_N = mkN "bräken" ; -- bräken..nn.1
  bräkning_1_N = mkN "bräkning" ; -- bräkning..nn.1
  bräm_1_N = mkN "bräm" neutrum  ; -- bräm..nn.1
  bräma_1_V = mkV "brämar" ; -- bräma..vb.1
  brämande_1_N = mkN "brämande" ; -- brämande..nn.1
  bränna_1_V = mkV "bränna" "brände" "bränt" ; -- bränna..vb.1
  brännande_1_A = mkA "brännande" ; -- brännande..av.1
  brännande_1_N = mkN "brännande" ; -- brännande..nn.1
  brännare_1_N = mkN "brännare" utrum  ; -- brännare..nn.1
  brännbar_1_A = mkA "brännbar" ; -- brännbar..av.1
  brännbarhet_1_N = mkN "brännbarhet" ; -- brännbarhet..nn.1
  brännblåsa_1_N = mkN "brännblåsa" ; -- brännblåsa..nn.1
  brännboll_1_N = mkN "brännboll" ; -- brännboll..nn.1
  brännboll_2_N = mkN "brännboll" ; -- brännboll..nn.2
  brännbollskast_1_N = mkN "brännbollskast" neutrum  ; -- brännbollskast..nn.1
  brännbollsträ_1_N = mkN "brännbollsträ" "brännbollsträt" "brännbollsträn" "brännbollsträna" ; -- brännbollsträ..nn.1
  bränne_1_N = mkN "bränne" ; -- bränne..nn.1
  bränneri_1_N = mkN "bränneri" "bränneriet" "brännerier" "brännerierna" ; -- bränneri..nn.1
  brännglas_1_N = mkN "brännglas" neutrum  ; -- brännglas..nn.1
  brännhet_1_A = mkA "brännhet" ; -- brännhet..av.1
  brännhår_1_N = mkN "brännhår" neutrum  ; -- brännhår..nn.1
  bränning_1_N = mkN "bränning" ; -- bränning..nn.1
  brännjärn_1_N = mkN "brännjärn" neutrum  ; -- brännjärn..nn.1
  brännkammare_1_N = mkN "brännkammare" utrum  ; -- brännkammare..nn.1
  brännlack_1_N = mkN "brännlack" ; -- brännlack..nn.1
  brännlackera_1_V = mkV "brännlackerar" ; -- brännlackera..vb.1
  brännlackerande_1_N = mkN "brännlackerande" ; -- brännlackerande..nn.1
  brännlackerbar_1_A = mkA "brännlackerbar" ; -- brännlackerbar..av.1
  brännlackerbarhet_1_N = mkN "brännlackerbarhet" ; -- brännlackerbarhet..nn.1
  brännlackering_1_N = mkN "brännlackering" ; -- brännlackering..nn.1
  brännmanet_1_N = mkN "brännmanet" "brännmaneter" ; -- brännmanet..nn.1
  brännmaterial_1_N = mkN "brännmaterial" neutrum  ; -- brännmaterial..nn.1
  brännmärka_1_V = mkV "brännmärker" ; -- brännmärka..vb.1
  brännmärkande_1_N = mkN "brännmärkande" ; -- brännmärkande..nn.1
  brännmärke_1_N = mkN "brännmärke" ; -- brännmärke..nn.1
  brännmärkning_1_N = mkN "brännmärkning" ; -- brännmärkning..nn.1
  brännoffer_1_N = mkN "brännoffer" neutrum  ; -- brännoffer..nn.1
  brännolja_1_N = mkN "brännolja" ; -- brännolja..nn.1
  brännpunkt_1_N = mkN "brännpunkt" "brännpunkter" ; -- brännpunkt..nn.1
  brännskada_1_N = mkN "brännskada" ; -- brännskada..nn.1
  brännskada_1_V = mkV "brännskadar" ; -- brännskada..vb.1
  brännskadad_1_A = mkA "brännskadad" ; -- brännskadad..av.1
  brännskadande_1_N = mkN "brännskadande" ; -- brännskadande..nn.1
  brännstål_1_N = mkN "brännstål" neutrum  ; -- brännstål..nn.1
  brännsår_1_N = mkN "brännsår" neutrum  ; -- brännsår..nn.1
  bränntorv_1_N = mkN "bränntorv" ; -- bränntorv..nn.1
  brännugn_1_N = mkN "brännugn" ; -- brännugn..nn.1
  brännved_1_N = mkN "brännved" ; -- brännved..nn.1
  brännvidd_1_N = mkN "brännvidd" "brännvidder" ; -- brännvidd..nn.1
  brännvin_1_N = mkN "brännvin" "brännvinet" "brännviner" "brännvinerna" ; -- brännvin..nn.1
  brännvinsadvokat_1_N = mkN "brännvinsadvokat" "brännvinsadvokater" ; -- brännvinsadvokat..nn.1
  brännvinsbas_1_N = mkN "brännvinsbas" ; -- brännvinsbas..nn.1
  brännvinsbord_1_N = mkN "brännvinsbord" neutrum  ; -- brännvinsbord..nn.1
  brännvinsbränneri_1_N = mkN "brännvinsbränneri" "brännvinsbränneriet" "brännvinsbrännerier" "brännvinsbrännerierna" ; -- brännvinsbränneri..nn.1
  brännvinsbränning_1_N = mkN "brännvinsbränning" ; -- brännvinsbränning..nn.1
  brännvinsdestilleri_1_N = mkN "brännvinsdestilleri" "brännvinsdestilleriet" "brännvinsdestillerier" "brännvinsdestillerierna" ; -- brännvinsdestilleri..nn.1
  brännvinsdestillering_1_N = mkN "brännvinsdestillering" ; -- brännvinsdestillering..nn.1
  brännvinsglas_1_N = mkN "brännvinsglas" neutrum  ; -- brännvinsglas..nn.1
  brännvinsnäsa_1_N = mkN "brännvinsnäsa" ; -- brännvinsnäsa..nn.1
  brännvinsprovare_1_N = mkN "brännvinsprovare" utrum  ; -- brännvinsprovare..nn.1
  brännyta_1_N = mkN "brännyta" ; -- brännyta..nn.1
  brännässla_1_N = mkN "brännässla" ; -- brännässla..nn.1
  bränsle_1_N = mkN "bränsle" ; -- bränsle..nn.1
  bränslebesparande_1_A = mkA "bränslebesparande" ; -- bränslebesparande..av.1
  bränslebesparing_1_N = mkN "bränslebesparing" ; -- bränslebesparing..nn.1
  bränslebrist_1_N = mkN "bränslebrist" ; -- bränslebrist..nn.1
  bränslecell_1_N = mkN "bränslecell" "bränsleceller" ; -- bränslecell..nn.1
  bränslecellsdriven_1_A = mkA "bränslecellsdriven" ; -- bränslecellsdriven..av.1
  bränslecellskonstruktion_1_N = mkN "bränslecellskonstruktion" ; -- bränslecellskonstruktion..nn.1
  bränslecellskraftverk_1_N = mkN "bränslecellskraftverk" neutrum  ; -- bränslecellskraftverk..nn.1
  bränslecellstyp_1_N = mkN "bränslecellstyp" "bränslecellstyper" ; -- bränslecellstyp..nn.1
  bränsledepå_1_N = mkN "bränsledepå" "bränsledepåer" ; -- bränsledepå..nn.1
  bränsleelement_1_N = mkN "bränsleelement" neutrum  ; -- bränsleelement..nn.1
  bränslefilter_1_N = mkN "bränslefilter" neutrum  ; -- bränslefilter..nn.1
  bränslefält_1_N = mkN "bränslefält" neutrum  ; -- bränslefält..nn.1
  bränsleförbrukning_1_N = mkN "bränsleförbrukning" ; -- bränsleförbrukning..nn.1
  bränsleförråd_1_N = mkN "bränsleförråd" neutrum  ; -- bränsleförråd..nn.1
  bränslegas_1_N = mkN "bränslegas" "bränslegaser" ; -- bränslegas..nn.1
  bränslekanal_1_N = mkN "bränslekanal" "bränslekanaler" ; -- bränslekanal..nn.1
  bränslekris_1_N = mkN "bränslekris" "bränslekriser" ; -- bränslekris..nn.1
  bränslemätare_1_N = mkN "bränslemätare" utrum  ; -- bränslemätare..nn.1
  bränsleomvandlare_1_N = mkN "bränsleomvandlare" utrum  ; -- bränsleomvandlare..nn.1
  bränsleransonering_1_N = mkN "bränsleransonering" ; -- bränsleransonering..nn.1
  bränsleslukande_1_A = mkA "bränsleslukande" ; -- bränsleslukande..av.1
  bränslesnål_1_A = mkA "bränslesnål" ; -- bränslesnål..av.1
  bränslesnålhet_1_N = mkN "bränslesnålhet" ; -- bränslesnålhet..nn.1
  bränslestav_1_N = mkN "bränslestav" ; -- bränslestav..nn.1
  bränsletank_1_N = mkN "bränsletank" ; -- bränsletank..nn.1
  bränsletillägg_1_N = mkN "bränsletillägg" neutrum  ; -- bränsletillägg..nn.1
  bränsletyp_1_N = mkN "bränsletyp" "bränsletyper" ; -- bränsletyp..nn.1
  bränsleåtgång_1_N = mkN "bränsleåtgång" ; -- bränsleåtgång..nn.1
  bräsch_1_N = mkN "bräsch" "bräscher" ; -- bräsch..nn.1
  bräsera_1_V = mkV "bräserar" ; -- bräsera..vb.1
  bräserande_1_N = mkN "bräserande" ; -- bräserande..nn.1
  bräserbar_1_A = mkA "bräserbar" ; -- bräserbar..av.1
  bräserbarhet_1_N = mkN "bräserbarhet" ; -- bräserbarhet..nn.1
  bräsering_1_N = mkN "bräsering" ; -- bräsering..nn.1
  bräsma_1_N = mkN "bräsma" ; -- bräsma..nn.1
  bräss_1_N = mkN "bräss" ; -- bräss..nn.1
  brätte_1_N = mkN "brätte" ; -- brätte..nn.1
  bråck_1_N = mkN "bråck" neutrum  ; -- bråck..nn.1
  bråckband_1_N = mkN "bråckband" neutrum  ; -- bråckband..nn.1
  bråd_1_A = mkA "bråd" "brått" ; -- bråd..av.1
  bråddjup_1_A = mkA "bråddjup" ; -- bråddjup..av.1
  bråddjup_1_N = mkN "bråddjup" neutrum  ; -- bråddjup..nn.1
  bråddjuphet_1_N = mkN "bråddjuphet" ; -- bråddjuphet..nn.1
  brådhet_1_N = mkN "brådhet" ; -- brådhet..nn.1
  brådmogen_1_A = mkA "brådmogen" ; -- brådmogen..av.1
  brådmogenhet_1_N = mkN "brådmogenhet" ; -- brådmogenhet..nn.1
  brådmognad_1_N = mkN "brådmognad" ; -- brådmognad..nn.1
  brådska_1_N = mkN "brådska" ; -- brådska..nn.1
  brådska_1_V = mkV "brådskar" ; -- brådska..vb.1
  brådskande_1_A = mkA "brådskande" ; -- brådskande..av.1
  brådskande_1_N = mkN "brådskande" ; -- brådskande..nn.1
  brådstörtad_1_A = mkA "brådstörtad" ; -- brådstörtad..av.1
  bråk_1_N = mkN "bråk" neutrum  ; -- bråk..nn.1
  bråka_1_N = mkN "bråka" ; -- bråka..nn.1
  bråka_1_V = mkV "bråkar" ; -- bråka..vb.1
  bråka_2_V = mkV "bråkar" ; -- bråka..vb.2
  bråkande_1_N = mkN "bråkande" ; -- bråkande..nn.1
  bråkdel_1_N = mkN "bråkdel" "bråkdelen" "bråkdelar" "bråkdelarna" ; -- bråkdel..nn.1
  bråkig_1_A = mkA "bråkig" ; -- bråkig..av.1
  bråkighet_1_N = mkN "bråkighet" ; -- bråkighet..nn.1
  bråkmakare_1_N = mkN "bråkmakare" utrum  ; -- bråkmakare..nn.1
  bråkräkning_1_N = mkN "bråkräkning" ; -- bråkräkning..nn.1
  bråkstake_1_N = mkN "bråkstake" utrum  ; -- bråkstake..nn.1
  bråkstreck_1_N = mkN "bråkstreck" neutrum  ; -- bråkstreck..nn.1
  bråktal_1_N = mkN "bråktal" neutrum  ; -- bråktal..nn.1
  brånad_1_N = mkN "brånad" "brånader" ; -- brånad..nn.1
  bråte_1_N = mkN "bråte" ; -- bråte..nn.1
  bråttom_1_A = mkA "bråttom" ; -- bråttom..av.1
  bröa_1_V = mkV "bröar" ; -- bröa..vb.1
  bröande_1_N = mkN "bröande" ; -- bröande..nn.1
  bröd_1_N = mkN "bröd" neutrum  ; -- bröd..nn.1
  bröda_1_V = mkV "brödar" ; -- bröda..vb.1
  brödande_1_N = mkN "brödande" ; -- brödande..nn.1
  brödbagge_1_N = mkN "brödbagge" utrum  ; -- brödbagge..nn.1
  brödbak_1_N = mkN "brödbak" neutrum  ; -- brödbak..nn.1
  brödbit_1_N = mkN "brödbit" ; -- brödbit..nn.1
  brödbrist_1_N = mkN "brödbrist" ; -- brödbrist..nn.1
  brödburk_1_N = mkN "brödburk" ; -- brödburk..nn.1
  brödfat_1_N = mkN "brödfat" neutrum  ; -- brödfat..nn.1
  brödfrukt_1_N = mkN "brödfrukt" "brödfrukter" ; -- brödfrukt..nn.1
  brödföda_1_N = mkN "brödföda" ; -- brödföda..nn.1
  bröding_1_N = mkN "bröding" ; -- bröding..nn.1
  brödkaka_1_N = mkN "brödkaka" ; -- brödkaka..nn.1
  brödkant_1_N = mkN "brödkant" "brödkanter" ; -- brödkant..nn.1
  brödkavel_1_N = mkN "brödkavel" ; -- brödkavel..nn.1
  brödkavle_1_N = mkN "brödkavle" utrum  ; -- brödkavle..nn.1
  brödkniv_1_N = mkN "brödkniv" ; -- brödkniv..nn.1
  brödkorg_1_N = mkN "brödkorg" ; -- brödkorg..nn.1
  brödkö_1_N = mkN "brödkö" "brödkön" "brödköer" "brödköerna" ; -- brödkö..nn.1
  brödlös_1_A = mkA "brödlös" ; -- brödlös..av.1
  brödlöshet_1_N = mkN "brödlöshet" ; -- brödlöshet..nn.1
  brödnagg_1_N = mkN "brödnagg" ; -- brödnagg..nn.1
  brödpris_1_N = mkN "brödpris" neutrum  ; -- brödpris..nn.1
  brödpudding_1_N = mkN "brödpudding" ; -- brödpudding..nn.1
  brödrafolk_1_N = mkN "brödrafolk" neutrum  ; -- brödrafolk..nn.1
  brödralag_1_N = mkN "brödralag" neutrum  ; -- brödralag..nn.1
  brödrapar_1_N = mkN "brödrapar" neutrum  ; -- brödrapar..nn.1
  brödrasinne_1_N = mkN "brödrasinne" ; -- brödrasinne..nn.1
  brödraskap_1_N = mkN "brödraskap" neutrum  ; -- brödraskap..nn.1
  brödrost_1_N = mkN "brödrost" ; -- brödrost..nn.1
  brödsbrytelse_1_N = mkN "brödsbrytelse" "brödsbrytelser" ; -- brödsbrytelse..nn.1
  brödskiva_1_N = mkN "brödskiva" ; -- brödskiva..nn.1
  brödskriveri_1_N = mkN "brödskriveri" "brödskriveriet" "brödskriverier" "brödskriverierna" ; -- brödskriveri..nn.1
  brödsmula_1_N = mkN "brödsmula" ; -- brödsmula..nn.1
  brödspade_1_N = mkN "brödspade" utrum  ; -- brödspade..nn.1
  brödstil_1_N = mkN "brödstil" ; -- brödstil..nn.1
  brödstycke_1_N = mkN "brödstycke" ; -- brödstycke..nn.1
  brödsäd_1_N = mkN "brödsäd" ; -- brödsäd..nn.1
  brödtext_1_N = mkN "brödtext" ; -- brödtext..nn.1
  bröl_1_N = mkN "bröl" neutrum  ; -- bröl..nn.1
  bröla_1_V = mkV "brölar" ; -- bröla..vb.1
  brölande_1_N = mkN "brölande" ; -- brölande..nn.1
  bröllop_1_N = mkN "bröllop" neutrum  ; -- bröllop..nn.1
  bröllopsbuss_1_N = mkN "bröllopsbuss" ; -- bröllopsbuss..nn.1
  bröllopsdag_1_N = mkN "bröllopsdag" ; -- bröllopsdag..nn.1
  bröllopsdikt_1_N = mkN "bröllopsdikt" "bröllopsdikter" ; -- bröllopsdikt..nn.1
  bröllopsfest_1_N = mkN "bröllopsfest" "bröllopsfester" ; -- bröllopsfest..nn.1
  bröllopsfoto_1_N = mkN "bröllopsfoto" "bröllopsfotot" "bröllopsfoton" "bröllopsfotona" ; -- bröllopsfoto..nn.1
  bröllopsgäst_1_N = mkN "bröllopsgäst" "bröllopsgäster" ; -- bröllopsgäst..nn.1
  bröllopsgåva_1_N = mkN "bröllopsgåva" ; -- bröllopsgåva..nn.1
  bröllopsinspirerad_1_A = mkA "bröllopsinspirerad" ; -- bröllopsinspirerad..av.1
  bröllopsklänning_1_N = mkN "bröllopsklänning" ; -- bröllopsklänning..nn.1
  bröllopsmarsch_1_N = mkN "bröllopsmarsch" "bröllopsmarscher" ; -- bröllopsmarsch..nn.1
  bröllopsmåltid_1_N = mkN "bröllopsmåltid" "bröllopsmåltider" ; -- bröllopsmåltid..nn.1
  bröllopsnatt_1_N = mkN "bröllopsnatt" "bröllopsnätter" ; -- bröllopsnatt..nn.1
  bröllopspar_1_N = mkN "bröllopspar" neutrum  ; -- bröllopspar..nn.1
  bröllopsplan_1_N = mkN "bröllopsplan" "bröllopsplaner" ; -- bröllopsplan..nn.1
  bröllopspoet_1_N = mkN "bröllopspoet" "bröllopspoeter" ; -- bröllopspoet..nn.1
  bröllopspresent_1_N = mkN "bröllopspresent" "bröllopspresenter" ; -- bröllopspresent..nn.1
  bröllopsresa_1_N = mkN "bröllopsresa" ; -- bröllopsresa..nn.1
  bröllopsresmål_1_N = mkN "bröllopsresmål" neutrum  ; -- bröllopsresmål..nn.1
  bröllopssed_1_N = mkN "bröllopssed" "bröllopsseder" ; -- bröllopssed..nn.1
  bröllopssällskap_1_N = mkN "bröllopssällskap" neutrum  ; -- bröllopssällskap..nn.1
  bröllopstårta_1_N = mkN "bröllopstårta" ; -- bröllopstårta..nn.1
  bröllopsvideo_1_N = mkN "bröllopsvideo" "bröllopsvideor" ; -- bröllopsvideo..nn.1
  bröllopsvittne_1_N = mkN "bröllopsvittne" ; -- bröllopsvittne..nn.1
  bröllopsyra_1_N = mkN "bröllopsyra" ; -- bröllopsyra..nn.1
  bröst_1_N = mkN "bröst" neutrum  ; -- bröst..nn.1
  brösta_1_N = mkN "brösta" ; -- brösta..nn.1
  bröstarv_1_N = mkN "bröstarv" neutrum  ; -- bröstarv..nn.1
  bröstarvinge_1_N = mkN "bröstarvinge" utrum  ; -- bröstarvinge..nn.1
  bröstbarn_1_N = mkN "bröstbarn" neutrum  ; -- bröstbarn..nn.1
  bröstben_1_N = mkN "bröstben" neutrum  ; -- bröstben..nn.1
  bröstbild_1_N = mkN "bröstbild" "bröstbilder" ; -- bröstbild..nn.1
  bröstböld_1_N = mkN "bröstböld" "bröstbölder" ; -- bröstböld..nn.1
  bröstcancer_1_N = mkN "bröstcancer" ; -- bröstcancer..nn.1
  bröstcancerdiagnos_1_N = mkN "bröstcancerdiagnos" "bröstcancerdiagnoser" ; -- bröstcancerdiagnos..nn.1
  bröstcancerkirurgi_1_N = mkN "bröstcancerkirurgi" ; -- bröstcancerkirurgi..nn.1
  bröstfena_1_N = mkN "bröstfena" ; -- bröstfena..nn.1
  bröstficka_1_N = mkN "bröstficka" ; -- bröstficka..nn.1
  bröstförstoring_1_N = mkN "bröstförstoring" ; -- bröstförstoring..nn.1
  bröstgång_1_N = mkN "bröstgång" ; -- bröstgång..nn.1
  brösthåla_1_N = mkN "brösthåla" ; -- brösthåla..nn.1
  brösthöjd_1_N = mkN "brösthöjd" ; -- brösthöjd..nn.1
  bröstimplantat_1_N = mkN "bröstimplantat" neutrum  ; -- bröstimplantat..nn.1
  bröstingrepp_1_N = mkN "bröstingrepp" neutrum  ; -- bröstingrepp..nn.1
  bröstkaramell_1_N = mkN "bröstkaramell" "bröstkarameller" ; -- bröstkaramell..nn.1
  bröstkatarr_1_N = mkN "bröstkatarr" "bröstkatarrer" ; -- bröstkatarr..nn.1
  bröstklang_1_N = mkN "bröstklang" ; -- bröstklang..nn.1
  bröstknöl_1_N = mkN "bröstknöl" ; -- bröstknöl..nn.1
  bröstkompression_1_N = mkN "bröstkompression" ; -- bröstkompression..nn.1
  bröstkorg_1_N = mkN "bröstkorg" ; -- bröstkorg..nn.1
  bröstkota_1_N = mkN "bröstkota" ; -- bröstkota..nn.1
  bröstkramp_1_N = mkN "bröstkramp" "bröstkramper" ; -- bröstkramp..nn.1
  bröstkörtel_1_N = mkN "bröstkörtel" ; -- bröstkörtel..nn.1
  bröstlapp_1_N = mkN "bröstlapp" ; -- bröstlapp..nn.1
  bröstlidande_1_N = mkN "bröstlidande" ; -- bröstlidande..nn.1
  bröstmjölk_1_N = mkN "bröstmjölk" ; -- bröstmjölk..nn.1
  bröstmjölkspumpsutspel_1_N = mkN "bröstmjölkspumpsutspel" "bröstmjölkspumpsutspelet" "bröstmjölkspumpsutspel" "bröstmjölkspumpsutspelen" ; -- bröstmjölkspumpsutspel..nn.1
  bröstmur_1_N = mkN "bröstmur" ; -- bröstmur..nn.1
  bröstmuskel_1_N = mkN "bröstmuskel" "bröstmuskeln" "bröstmuskler" "bröstmusklerna" ; -- bröstmuskel..nn.1
  bröstmått_1_N = mkN "bröstmått" neutrum  ; -- bröstmått..nn.1
  bröstning_1_N = mkN "bröstning" ; -- bröstning..nn.1
  bröstoperation_1_N = mkN "bröstoperation" ; -- bröstoperation..nn.1
  bröstparti_1_N = mkN "bröstparti" "bröstpartiet" "bröstpartier" "bröstpartierna" ; -- bröstparti..nn.1
  bröstpatient_1_N = mkN "bröstpatient" "bröstpatienter" ; -- bröstpatient..nn.1
  bröstpump_1_N = mkN "bröstpump" ; -- bröstpump..nn.1
  bröstpumpsutspel_1_N = mkN "bröstpumpsutspel" "bröstpumpsutspelet" "bröstpumpsutspel" "bröstpumpsutspelen" ; -- bröstpumpsutspel..nn.1
  bröstregister_1_N = mkN "bröstregister" neutrum  ; -- bröstregister..nn.1
  bröstsimmare_1_N = mkN "bröstsimmare" utrum  ; -- bröstsimmare..nn.1
  bröstsimtag_1_N = mkN "bröstsimtag" neutrum  ; -- bröstsimtag..nn.1
  bröstsjuk_1_A = mkA "bröstsjuk" ; -- bröstsjuk..av.1
  bröstskydd_1_N = mkN "bröstskydd" neutrum  ; -- bröstskydd..nn.1
  bröstsocker_1_N = mkN "bröstsocker" neutrum  ; -- bröstsocker..nn.1
  bröstsugande_1_A = mkA "bröstsugande" ; -- bröstsugande..av.1
  bröstton_1_N = mkN "bröstton" "brösttoner" ; -- bröstton..nn.1
  bröstvidd_1_N = mkN "bröstvidd" "bröstvidder" ; -- bröstvidd..nn.1
  bröstvärk_1_N = mkN "bröstvärk" ; -- bröstvärk..nn.1
  bröstvärn_1_N = mkN "bröstvärn" neutrum  ; -- bröstvärn..nn.1
  bröstvårta_1_N = mkN "bröstvårta" ; -- bröstvårta..nn.1
  bröt_1_N = mkN "bröt" ; -- bröt..nn.1
  bröthake_1_N = mkN "bröthake" utrum  ; -- bröthake..nn.1
  brötling_1_N = mkN "brötling" ; -- brötling..nn.1
  bua_1_V = mkV "buar" ; -- bua..vb.1
  buande_1_N = mkN "buande" ; -- buande..nn.1
  bubba_1_V = mkV "bubbar" ; -- bubba..vb.1
  bubbande_1_N = mkN "bubbande" ; -- bubbande..nn.1
  bubbel_1_N = mkN "bubbel" neutrum  ; -- bubbel..nn.1
  bubbelbad_1_N = mkN "bubbelbad" neutrum  ; -- bubbelbad..nn.1
  bubbelbadkar_1_N = mkN "bubbelbadkar" neutrum  ; -- bubbelbadkar..nn.1
  bubbelgum_1_N = mkN "bubbelgum" "bubbelgummet" "bubbelgum" "bubbelgummen" ; -- bubbelgum..nn.1
  bubbelkammare_1_N = mkN "bubbelkammare" "bubbelkammaren" "bubbelkammare" "bubbelkamrarna" ; -- bubbelkammare..nn.1
  bubbelpool_1_N = mkN "bubbelpool" "bubbelpooler" ; -- bubbelpool..nn.1
  bubbla_1_N = mkN "bubbla" ; -- bubbla..nn.1
  bubbla_1_V = mkV "bubblar" ; -- bubbla..vb.1
  bubblande_1_N = mkN "bubblande" ; -- bubblande..nn.1
  bubblare_1_N = mkN "bubblare" utrum  ; -- bubblare..nn.1
  bubblig_1_A = mkA "bubblig" ; -- bubblig..av.1
  bubblighet_1_N = mkN "bubblighet" ; -- bubblighet..nn.1
  bubon_1_N = mkN "bubon" "buboner" ; -- bubon..nn.1
  buckla_1_N = mkN "buckla" ; -- buckla..nn.1
  bucklig_1_A = mkA "bucklig" ; -- bucklig..av.1
  bucklighet_1_N = mkN "bucklighet" ; -- bucklighet..nn.1
  buckram_1_N = mkN "buckram" ; -- buckram..nn.1
  bud_1_N = mkN "bud" neutrum  ; -- bud..nn.1
  buda_1_V = mkV "budar" ; -- buda..vb.1
  budande_1_N = mkN "budande" ; -- budande..nn.1
  budbyrå_1_N = mkN "budbyrå" "budbyråer" ; -- budbyrå..nn.1
  budbärare_1_N = mkN "budbärare" utrum  ; -- budbärare..nn.1
  buddha_1_N = mkN "buddha" ; -- buddha..nn.1
  buddhism_1_N = mkN "buddhism" "buddhismer" ; -- buddhism..nn.1
  buddhist_1_N = mkN "buddhist" "buddhister" ; -- buddhist..nn.1
  buddhistisk_1_A = mkA "buddhistisk" ; -- buddhistisk..av.1
  buddism_1_N = mkN "buddism" "buddismer" ; -- buddism..nn.1
  buddist_1_N = mkN "buddist" "buddister" ; -- buddist..nn.1
  buddistisk_1_A = mkA "buddistisk" ; -- buddistisk..av.1
  budget_1_N = mkN "budget" ; -- budget..nn.1
  budgetalternativ_1_N = mkN "budgetalternativ" neutrum  ; -- budgetalternativ..nn.1
  budgetansvarig_1_A = mkA "budgetansvarig" ; -- budgetansvarig..av.1
  budgetarbete_1_N = mkN "budgetarbete" ; -- budgetarbete..nn.1
  budgetdisciplin_1_N = mkN "budgetdisciplin" ; -- budgetdisciplin..nn.1
  budgetera_1_V = mkV "budgeterar" ; -- budgetera..vb.1
  budgeterande_1_N = mkN "budgeterande" ; -- budgeterande..nn.1
  budgeterare_1_N = mkN "budgeterare" utrum  ; -- budgeterare..nn.1
  budgeterbar_1_A = mkA "budgeterbar" ; -- budgeterbar..av.1
  budgeterbarhet_1_N = mkN "budgeterbarhet" ; -- budgeterbarhet..nn.1
  budgetering_1_N = mkN "budgetering" ; -- budgetering..nn.1
  budgetflyg_1_N = mkN "budgetflyg" neutrum  ; -- budgetflyg..nn.1
  budgetförordning_1_N = mkN "budgetförordning" ; -- budgetförordning..nn.1
  budgetförslag_1_N = mkN "budgetförslag" neutrum  ; -- budgetförslag..nn.1
  budgetmotion_1_N = mkN "budgetmotion" ; -- budgetmotion..nn.1
  budgetmässig_1_A = mkA "budgetmässig" ; -- budgetmässig..av.1
  budgetpolitik_1_N = mkN "budgetpolitik" ; -- budgetpolitik..nn.1
  budgetpolitisk_1_A = mkA "budgetpolitisk" ; -- budgetpolitisk..av.1
  budgetproposition_1_N = mkN "budgetproposition" ; -- budgetproposition..nn.1
  budgetresa_1_N = mkN "budgetresa" ; -- budgetresa..nn.1
  budgetsanering_1_N = mkN "budgetsanering" ; -- budgetsanering..nn.1
  budgetspa_1_N = mkN "budgetspa" "budgetspat" "budgetspan" "budgetspana" ; -- budgetspa..nn.1
  budgetstup_1_N = mkN "budgetstup" ; -- budgetstup..nn.1
  budgetunderskott_1_N = mkN "budgetunderskott" neutrum  ; -- budgetunderskott..nn.1
  budgetvariant_1_N = mkN "budgetvariant" "budgetvarianter" ; -- budgetvariant..nn.1
  budgetär_1_A = mkA "budgetär" ; -- budgetär..av.1
  budgetår_1_N = mkN "budgetår" neutrum  ; -- budgetår..nn.1
  budgetöverskott_1_N = mkN "budgetöverskott" neutrum  ; -- budgetöverskott..nn.1
  budgivning_1_N = mkN "budgivning" ; -- budgivning..nn.1
  budkavel_1_N = mkN "budkavel" ; -- budkavel..nn.1
  budkavle_1_N = mkN "budkavle" utrum  ; -- budkavle..nn.1
  budkavlelöpning_1_N = mkN "budkavlelöpning" ; -- budkavlelöpning..nn.1
  budning_1_N = mkN "budning" ; -- budning..nn.1
  budo_1_N = mkN "budo" ; -- budo..nn.1
  budoar_1_N = mkN "budoar" "budoarer" ; -- budoar..nn.1
  budoarmässig_1_A = mkA "budoarmässig" ; -- budoarmässig..av.1
  budord_1_N = mkN "budord" neutrum  ; -- budord..nn.1
  budskap_1_N = mkN "budskap" neutrum  ; -- budskap..nn.1
  buff_1_N = mkN "buff" ; -- buff..nn.1
  buffa_1_N = mkN "buffa" ; -- buffa..nn.1
  buffa_1_V = mkV "buffar" ; -- buffa..vb.1
  buffande_1_N = mkN "buffande" ; -- buffande..nn.1
  buffaopera_1_N = mkN "buffaopera" ; -- buffaopera..nn.1
  buffel_1_N = mkN "buffel" ; -- buffel..nn.1
  buffelaktig_1_A = mkA "buffelaktig" ; -- buffelaktig..av.1
  buffelaktighet_1_N = mkN "buffelaktighet" ; -- buffelaktighet..nn.1
  buffelhjord_1_N = mkN "buffelhjord" ; -- buffelhjord..nn.1
  buffert_1_N = mkN "buffert" ; -- buffert..nn.1
  buffertkapacitet_1_N = mkN "buffertkapacitet" "buffertkapaciteter" ; -- buffertkapacitet..nn.1
  buffertlager_1_N = mkN "buffertlager" neutrum  ; -- buffertlager..nn.1
  buffertlösning_1_N = mkN "buffertlösning" ; -- buffertlösning..nn.1
  buffertstat_1_N = mkN "buffertstat" "buffertstater" ; -- buffertstat..nn.1
  bufflig_1_A = mkA "bufflig" ; -- bufflig..av.1
  bufflighet_1_N = mkN "bufflighet" "buffligheter" ; -- bufflighet..nn.1
  buffra_1_V = mkV "buffrar" ; -- buffra..vb.1
  buffrande_1_N = mkN "buffrande" ; -- buffrande..nn.1
  buffringsförmåga_1_N = mkN "buffringsförmåga" ; -- buffringsförmåga..nn.1
  buffé_1_N = mkN "buffé" "bufféer" ; -- buffé..nn.1
  bug_1_N = mkN "bug" ; -- bug..nn.1
  buga_1_V = mkV "bugar" ; -- buga..vb.1
  bugande_1_N = mkN "bugande" ; -- bugande..nn.1
  bugg_1_N = mkN "bugg" ; -- bugg..nn.1
  bugg_2_N = mkN "bugg" ; -- bugg..nn.2
  bugga_1_V = mkV "buggar" ; -- bugga..vb.1
  buggande_1_N = mkN "buggande" ; -- buggande..nn.1
  buggfix_1_N = mkN "buggfix" ; -- buggfix..nn.1
  buggning_1_N = mkN "buggning" ; -- buggning..nn.1
  bugning_1_N = mkN "bugning" ; -- bugning..nn.1
  buk_1_N = mkN "buk" ; -- buk..nn.1
  bukett_1_N = mkN "bukett" "buketter" ; -- bukett..nn.1
  bukettgrönt_1_N = mkN "bukettgrönt" ; -- bukettgrönt..nn.1
  bukfetma_1_N = mkN "bukfetma" ; -- bukfetma..nn.1
  bukfett_1_N = mkN "bukfett" neutrum  ; -- bukfett..nn.1
  bukfettslager_1_N = mkN "bukfettslager" neutrum  ; -- bukfettslager..nn.1
  bukformig_1_A = mkA "bukformig" ; -- bukformig..av.1
  bukfylla_1_N = mkN "bukfylla" ; -- bukfylla..nn.1
  bukfyllnad_1_N = mkN "bukfyllnad" ; -- bukfyllnad..nn.1
  bukgjord_1_N = mkN "bukgjord" ; -- bukgjord..nn.1
  bukhinna_1_N = mkN "bukhinna" ; -- bukhinna..nn.1
  bukhinneinflammation_1_N = mkN "bukhinneinflammation" ; -- bukhinneinflammation..nn.1
  bukhåla_1_N = mkN "bukhåla" ; -- bukhåla..nn.1
  bukig_1_A = mkA "bukig" ; -- bukig..av.1
  bukighet_1_N = mkN "bukighet" ; -- bukighet..nn.1
  buklanda_1_V = mkV "buklandar" ; -- buklanda..vb.1
  buklandande_1_N = mkN "buklandande" ; -- buklandande..nn.1
  bukmuskel_1_N = mkN "bukmuskel" "bukmuskeln" "bukmuskler" "bukmusklerna" ; -- bukmuskel..nn.1
  bukolisk_1_A = mkA "bukolisk" ; -- bukolisk..av.1
  bukskott_1_N = mkN "bukskott" neutrum  ; -- bukskott..nn.1
  bukspott_1_N = mkN "bukspott" ; -- bukspott..nn.1
  bukspottkörtel_1_N = mkN "bukspottkörtel" ; -- bukspottkörtel..nn.1
  bukstinn_1_A = mkA "bukstinn" "bukstint" ; -- bukstinn..av.1
  bukstinnhet_1_N = mkN "bukstinnhet" ; -- bukstinnhet..nn.1
  buksvåger_1_N = mkN "buksvåger" ; -- buksvåger..nn.1
  bukt_1_N = mkN "bukt" "bukter" ; -- bukt..nn.1
  bukta_1_V = mkV "buktar" ; -- bukta..vb.1
  buktala_1_V = mkV "buktalar" ; -- buktala..vb.1
  buktalande_1_N = mkN "buktalande" ; -- buktalande..nn.1
  buktalare_1_N = mkN "buktalare" utrum  ; -- buktalare..nn.1
  buktaleri_1_N = mkN "buktaleri" neutrum  ; -- buktaleri..nn.1
  buktande_1_N = mkN "buktande" ; -- buktande..nn.1
  buktig_1_A = mkA "buktig" ; -- buktig..av.1
  buktighet_1_N = mkN "buktighet" ; -- buktighet..nn.1
  buktning_1_N = mkN "buktning" ; -- buktning..nn.1
  bukvägg_1_N = mkN "bukvägg" ; -- bukvägg..nn.1
  bukvätska_1_N = mkN "bukvätska" ; -- bukvätska..nn.1
  bula_1_N = mkN "bula" ; -- bula..nn.1
  bulb_1_N = mkN "bulb" "bulber" ; -- bulb..nn.1
  bulbjärn_1_N = mkN "bulbjärn" neutrum  ; -- bulbjärn..nn.1
  buldan_1_N = mkN "buldan" ; -- buldan..nn.1
  bulemi_1_N = mkN "bulemi" ; -- bulemi..nn.1
  bulemiker_1_N = mkN "bulemiker" "bulemikern" "bulemiker" "bulemikerna" ; -- bulemiker..nn.1
  bulevard_1_N = mkN "bulevard" "bulevarder" ; -- bulevard..nn.1
  bulgar_1_N = mkN "bulgar" "bulgarer" ; -- bulgar..nn.1
  bulgarisk_1_A = mkA "bulgarisk" ; -- bulgarisk..av.1
  bulgariska_1_N = mkN "bulgariska" ; -- bulgariska..nn.1
  bulgariska_2_N = mkN "bulgariska" ; -- bulgariska..nn.2
  bulgur_1_N = mkN "bulgur" ; -- bulgur..nn.1
  bulimi_1_N = mkN "bulimi" ; -- bulimi..nn.1
  bulimiker_1_N = mkN "bulimiker" "bulimikern" "bulimiker" "bulimikerna" ; -- bulimiker..nn.1
  buljong_1_N = mkN "buljong" "buljonger" ; -- buljong..nn.1
  buljongben_1_N = mkN "buljongben" neutrum  ; -- buljongben..nn.1
  buljongkött_1_N = mkN "buljongkött" neutrum  ; -- buljongkött..nn.1
  buljongtärning_1_N = mkN "buljongtärning" ; -- buljongtärning..nn.1
  bulk_1_N = mkN "bulk" ; -- bulk..nn.1
  bulkfartyg_1_N = mkN "bulkfartyg" neutrum  ; -- bulkfartyg..nn.1
  bulklast_1_N = mkN "bulklast" "bulklaster" ; -- bulklast..nn.1
  bulklastare_1_N = mkN "bulklastare" utrum  ; -- bulklastare..nn.1
  bulkmedel_1_N = mkN "bulkmedel" neutrum  ; -- bulkmedel..nn.1
  bulla_1_N = mkN "bulla" ; -- bulla..nn.1
  bullbak_1_N = mkN "bullbak" neutrum  ; -- bullbak..nn.1
  bulldogg_1_N = mkN "bulldogg" ; -- bulldogg..nn.1
  bulldozer_1_N = mkN "bulldozer" ; -- bulldozer..nn.1
  bulle_1_N = mkN "bulle" utrum  ; -- bulle..nn.1
  buller_1_N = mkN "buller" neutrum  ; -- buller..nn.1
  bullerbas_1_N = mkN "bullerbas" ; -- bullerbas..nn.1
  bullerblomster_1_N = mkN "bullerblomster" neutrum  ; -- bullerblomster..nn.1
  bullerdämpande_1_A = mkA "bullerdämpande" ; -- bullerdämpande..av.1
  bullerdämpning_1_N = mkN "bullerdämpning" ; -- bullerdämpning..nn.1
  bullerförminskande_1_A = mkA "bullerförminskande" ; -- bullerförminskande..av.1
  bullerkrav_1_N = mkN "bullerkrav" neutrum  ; -- bullerkrav..nn.1
  bullermatta_1_N = mkN "bullermatta" ; -- bullermatta..nn.1
  bullersam_1_A = mkA "bullersam" "bullersamt" "bullersamma" "bullersamma" "bullersammare" "bullersammast" "bullersammaste" ; -- bullersam..av.1
  bullersamhet_1_N = mkN "bullersamhet" ; -- bullersamhet..nn.1
  bullerskada_1_N = mkN "bullerskada" ; -- bullerskada..nn.1
  bullerskärm_1_N = mkN "bullerskärm" ; -- bullerskärm..nn.1
  bullersten_1_N = mkN "bullersten" "bullerstenen" "bullerstenar" "bullerstenarna" ; -- bullersten..nn.1
  bullerutsatt_1_A = mkA "bullerutsatt" ; -- bullerutsatt..av.1
  bullervall_1_N = mkN "bullervall" ; -- bullervall..nn.1
  bullervägg_1_N = mkN "bullervägg" ; -- bullervägg..nn.1
  bulletin_1_N = mkN "bulletin" "bulletiner" ; -- bulletin..nn.1
  bullig_1_A = mkA "bullig" ; -- bullig..av.1
  bullighet_1_N = mkN "bullighet" ; -- bullighet..nn.1
  bullra_1_V = mkV "bullrar" ; -- bullra..vb.1
  bullrande_1_N = mkN "bullrande" ; -- bullrande..nn.1
  bullrig_1_A = mkA "bullrig" ; -- bullrig..av.1
  bullrighet_1_N = mkN "bullrighet" ; -- bullrighet..nn.1
  bullshit_1_N = mkN "bullshit" ; -- bullshit..nn.1
  bulna_1_V = mkV "bulnar" ; -- bulna..vb.1
  bulnad_1_N = mkN "bulnad" "bulnader" ; -- bulnad..nn.1
  bulnande_1_N = mkN "bulnande" ; -- bulnande..nn.1
  bulsig_1_A = mkA "bulsig" ; -- bulsig..av.1
  bulsighet_1_N = mkN "bulsighet" ; -- bulsighet..nn.1
  bult_1_N = mkN "bult" ; -- bult..nn.1
  bulta_1_V = mkV "bultar" ; -- bulta..vb.1
  bultande_1_N = mkN "bultande" ; -- bultande..nn.1
  bulthuvud_1_N = mkN "bulthuvud" "bulthuvudet" "bulthuvud" "bulthuvudena" ; -- bulthuvud..nn.1
  bulthål_1_N = mkN "bulthål" neutrum  ; -- bulthål..nn.1
  bultning_1_N = mkN "bultning" ; -- bultning..nn.1
  bultpistol_1_N = mkN "bultpistol" "bultpistoler" ; -- bultpistol..nn.1
  bultsax_1_N = mkN "bultsax" ; -- bultsax..nn.1
  bultskalle_1_N = mkN "bultskalle" utrum  ; -- bultskalle..nn.1
  bulvan_1_N = mkN "bulvan" "bulvaner" ; -- bulvan..nn.1
  bulvanverksamhet_1_N = mkN "bulvanverksamhet" "bulvanverksamheter" ; -- bulvanverksamhet..nn.1
  bumerang_1_N = mkN "bumerang" "bumeranger" ; -- bumerang..nn.1
  bumling_1_N = mkN "bumling" ; -- bumling..nn.1
  bums_1_Adv = mkAdv "bums" ; -- bums..ab.1
  bunden_1_A = mkA "bunden" ; -- bunden..av.1
  bundenhet_1_N = mkN "bundenhet" ; -- bundenhet..nn.1
  bundis_1_A = mkA "bundis" ; -- bundis..av.1
  bundsförvant_1_N = mkN "bundsförvant" "bundsförvanter" ; -- bundsförvant..nn.1
  bundsförvantskap_1_N = mkN "bundsförvantskap" neutrum  ; -- bundsförvantskap..nn.1
  bungalow_1_N = mkN "bungalow" "bungalowen" "bungalows" "bungalowerna" ; -- bungalow..nn.1
  bunke_1_N = mkN "bunke" utrum  ; -- bunke..nn.1
  bunker_1_N = mkN "bunker" ; -- bunker..nn.1
  bunkra_1_V = mkV "bunkrar" ; -- bunkra..vb.1
  bunkrande_1_N = mkN "bunkrande" ; -- bunkrande..nn.1
  bunkring_1_N = mkN "bunkring" ; -- bunkring..nn.1
  bunkringsolja_1_N = mkN "bunkringsolja" ; -- bunkringsolja..nn.1
  bunkringsplats_1_N = mkN "bunkringsplats" "bunkringsplatser" ; -- bunkringsplats..nn.1
  bunkringsstation_1_N = mkN "bunkringsstation" ; -- bunkringsstation..nn.1
  bunkstål_1_N = mkN "bunkstål" neutrum  ; -- bunkstål..nn.1
  bunsenbrännare_1_N = mkN "bunsenbrännare" utrum  ; -- bunsenbrännare..nn.1
  bunt_1_N = mkN "bunt" ; -- bunt..nn.1
  bunta_1_V = mkV "buntar" ; -- bunta..vb.1
  buntande_1_N = mkN "buntande" ; -- buntande..nn.1
  buntband_1_N = mkN "buntband" neutrum  ; -- buntband..nn.1
  buntmakare_1_N = mkN "buntmakare" utrum  ; -- buntmakare..nn.1
  buntning_1_N = mkN "buntning" ; -- buntning..nn.1
  buntvis_1_Adv = mkAdv "buntvis" ; -- buntvis..ab.1
  bur_1_N = mkN "bur" ; -- bur..nn.1
  burbrev_1_N = mkN "burbrev" neutrum  ; -- burbrev..nn.1
  burdus_1_A = mkA "burdus" ; -- burdus..av.1
  burfågel_1_N = mkN "burfågel" ; -- burfågel..nn.1
  burgarbar_1_N = mkN "burgarbar" "burgarbarer" ; -- burgarbar..nn.1
  burgare_1_N = mkN "burgare" utrum  ; -- burgare..nn.1
  burgarrestaurang_1_N = mkN "burgarrestaurang" "burgarrestauranger" ; -- burgarrestaurang..nn.1
  burgarställe_1_N = mkN "burgarställe" ; -- burgarställe..nn.1
  burgen_1_A = mkA "burgen" ; -- burgen..av.1
  burgenhet_1_N = mkN "burgenhet" ; -- burgenhet..nn.1
  burgerbar_1_N = mkN "burgerbar" "burgerbarer" ; -- burgerbar..nn.1
  burgerrestaurang_1_N = mkN "burgerrestaurang" "burgerrestauranger" ; -- burgerrestaurang..nn.1
  burgerställe_1_N = mkN "burgerställe" ; -- burgerställe..nn.1
  burgund_1_N = mkN "burgund" "burgunder" ; -- burgund..nn.1
  burgunder_1_N = mkN "burgunder" "burgundern" "burgunder" "burgunderna" ; -- burgunder..nn.1
  burhöns_1_N = mkN "burhöns" neutrum  ; -- burhöns..nn.1
  burk_1_N = mkN "burk" ; -- burk..nn.1
  burka_1_N = mkN "burka" ; -- burka..nn.1
  burka_1_V = mkV "burkar" ; -- burka..vb.1
  burkaförbud_1_N = mkN "burkaförbud" neutrum  ; -- burkaförbud..nn.1
  burkande_1_N = mkN "burkande" ; -- burkande..nn.1
  burkhållare_1_N = mkN "burkhållare" utrum  ; -- burkhållare..nn.1
  burkinier_1_N = mkN "burkinier" "burkiniern" "burkinier" "burkinierna" ; -- burkinier..nn.1
  burkinsk_1_A = mkA "burkinsk" ; -- burkinsk..av.1
  burkinska_1_N = mkN "burkinska" ; -- burkinska..nn.1
  burkmat_1_N = mkN "burkmat" ; -- burkmat..nn.1
  burkslav_1_N = mkN "burkslav" ; -- burkslav..nn.1
  burköl_1_N = mkN "burköl" neutrum  ; -- burköl..nn.1
  burköppnare_1_N = mkN "burköppnare" utrum  ; -- burköppnare..nn.1
  burlesk_1_A = mkA "burlesk" ; -- burlesk..av.1
  burlesk_1_N = mkN "burlesk" "burlesker" ; -- burlesk..nn.1
  burleskeri_1_N = mkN "burleskeri" "burleskeriet" "burleskerier" "burleskerierna" ; -- burleskeri..nn.1
  burman_1_N = mkN "burman" "burmaner" ; -- burman..nn.1
  burmansk_1_A = mkA "burmansk" ; -- burmansk..av.1
  burmanska_1_N = mkN "burmanska" ; -- burmanska..nn.1
  burmanska_2_N = mkN "burmanska" ; -- burmanska..nn.2
  burmes_1_N = mkN "burmes" "burmeser" ; -- burmes..nn.1
  burmesisk_1_A = mkA "burmesisk" ; -- burmesisk..av.1
  burmesiska_1_N = mkN "burmesiska" ; -- burmesiska..nn.1
  burmesiska_2_N = mkN "burmesiska" ; -- burmesiska..nn.2
  burnus_1_N = mkN "burnus" ; -- burnus..nn.1
  burr_1_N = mkN "burr" neutrum  ; -- burr..nn.1
  burrig_1_A = mkA "burrig" ; -- burrig..av.1
  burrighet_1_N = mkN "burrighet" ; -- burrighet..nn.1
  burschikos_1_A = mkA "burschikos" ; -- burschikos..av.1
  burskap_1_N = mkN "burskap" neutrum  ; -- burskap..nn.1
  burspråk_1_N = mkN "burspråk" neutrum  ; -- burspråk..nn.1
  burspråksfönster_1_N = mkN "burspråksfönster" neutrum  ; -- burspråksfönster..nn.1
  burundier_1_N = mkN "burundier" "burundiern" "burundier" "burundierna" ; -- burundier..nn.1
  burundisk_1_A = mkA "burundisk" ; -- burundisk..av.1
  burundiska_1_N = mkN "burundiska" ; -- burundiska..nn.1
  bus_1_N = mkN "bus" neutrum  ; -- bus..nn.1
  busa_1_V = mkV "busar" ; -- busa..vb.1
  busande_1_N = mkN "busande" ; -- busande..nn.1
  buse_1_N = mkN "buse" utrum  ; -- buse..nn.1
  busenkel_1_A = mkA "busenkel" ; -- busenkel..av.1
  busfason_1_N = mkN "busfason" "busfasoner" ; -- busfason..nn.1
  busfrö_1_N = mkN "busfrö" "busfröet" "busfrön" "busfröna" ; -- busfrö..nn.1
  bush_1_N = mkN "bush" ; -- bush..nn.1
  bushman_1_N = mkN "bushman" "bushmannen" "bushmän" "bushmännen" ; -- bushman..nn.1
  busig_1_A = mkA "busig" ; -- busig..av.1
  busighet_1_N = mkN "busighet" ; -- busighet..nn.1
  business_1_N = mkN "business" ; -- business..nn.1
  buska_1_V = mkV "buskar" ; -- buska..vb.1
  buska_2_V = mkV "buskar" ; -- buska..vb.2
  buskablyg_1_A = mkA "buskablyg" ; -- buskablyg..av.1
  buskablyghet_1_N = mkN "buskablyghet" ; -- buskablyghet..nn.1
  buskage_1_N = mkN "buskage" "buskaget" "buskage" "buskagen" ; -- buskage..nn.1
  buskagitation_1_N = mkN "buskagitation" ; -- buskagitation..nn.1
  buskande_1_N = mkN "buskande" ; -- buskande..nn.1
  buskartad_1_A = mkA "buskartad" ; -- buskartad..av.1
  buskbevuxen_1_A = mkA "buskbevuxen" ; -- buskbevuxen..av.1
  buske_1_N = mkN "buske" utrum  ; -- buske..nn.1
  buskig_1_A = mkA "buskig" ; -- buskig..av.1
  buskighet_1_N = mkN "buskighet" ; -- buskighet..nn.1
  buskis_1_N = mkN "buskis" ; -- buskis..nn.1
  buskliknande_1_A = mkA "buskliknande" ; -- buskliknande..av.1
  buskskvätta_1_N = mkN "buskskvätta" ; -- buskskvätta..nn.1
  busksly_1_N = mkN "busksly" "buskslyt" "buskslyn" "buskslyna" ; -- busksly..nn.1
  busksnår_1_N = mkN "busksnår" neutrum  ; -- busksnår..nn.1
  buskteater_1_N = mkN "buskteater" ; -- buskteater..nn.1
  buskväxt_1_N = mkN "buskväxt" "buskväxter" ; -- buskväxt..nn.1
  buskörare_1_N = mkN "buskörare" utrum  ; -- buskörare..nn.1
  buskörning_1_N = mkN "buskörning" ; -- buskörning..nn.1
  busliv_1_N = mkN "busliv" neutrum  ; -- busliv..nn.1
  busringa_1_V = mkV "busringer" ; -- busringa..vb.1
  busringande_1_N = mkN "busringande" ; -- busringande..nn.1
  busringare_1_N = mkN "busringare" utrum  ; -- busringare..nn.1
  busringning_1_N = mkN "busringning" ; -- busringning..nn.1
  buss_1_A = mkA "buss" ; -- buss..av.1
  buss_1_N = mkN "buss" ; -- buss..nn.1
  bussa_1_V = mkV "bussar" ; -- bussa..vb.1
  bussande_1_N = mkN "bussande" ; -- bussande..nn.1
  bussankomst_1_N = mkN "bussankomst" "bussankomster" ; -- bussankomst..nn.1
  bussarong_1_N = mkN "bussarong" "bussaronger" ; -- bussarong..nn.1
  bussavgång_1_N = mkN "bussavgång" ; -- bussavgång..nn.1
  busschaufför_1_N = mkN "busschaufför" "busschaufförer" ; -- busschaufför..nn.1
  bussförare_1_N = mkN "bussförare" utrum  ; -- bussförare..nn.1
  bussförbindelse_1_N = mkN "bussförbindelse" "bussförbindelser" ; -- bussförbindelse..nn.1
  busshållplats_1_N = mkN "busshållplats" "busshållplatser" ; -- busshållplats..nn.1
  bussig_1_A = mkA "bussig" ; -- bussig..av.1
  bussighet_1_N = mkN "bussighet" ; -- bussighet..nn.1
  busskort_1_N = mkN "busskort" neutrum  ; -- busskort..nn.1
  busskrock_1_N = mkN "busskrock" ; -- busskrock..nn.1
  busskur_1_N = mkN "busskur" ; -- busskur..nn.1
  busslast_1_N = mkN "busslast" "busslaster" ; -- busslast..nn.1
  busslinje_1_N = mkN "busslinje" "busslinjer" ; -- busslinje..nn.1
  bussning_1_N = mkN "bussning" ; -- bussning..nn.1
  busspassagerare_1_N = mkN "busspassagerare" utrum  ; -- busspassagerare..nn.1
  bussresa_1_N = mkN "bussresa" ; -- bussresa..nn.1
  busstation_1_N = mkN "busstation" ; -- busstation..nn.1
  busstaxa_1_N = mkN "busstaxa" ; -- busstaxa..nn.1
  bussterminal_1_N = mkN "bussterminal" "bussterminaler" ; -- bussterminal..nn.1
  busstidtabell_1_N = mkN "busstidtabell" "busstidtabeller" ; -- busstidtabell..nn.1
  busstrafik_1_N = mkN "busstrafik" ; -- busstrafik..nn.1
  busstransport_1_N = mkN "busstransport" "busstransporter" ; -- busstransport..nn.1
  busstur_1_N = mkN "busstur" "bussturer" ; -- busstur..nn.1
  busunge_1_N = mkN "busunge" utrum  ; -- busunge..nn.1
  busvissla_1_V = mkV "busvisslar" ; -- busvissla..vb.1
  busvisslande_1_N = mkN "busvisslande" ; -- busvisslande..nn.1
  busvissling_1_N = mkN "busvissling" ; -- busvissling..nn.1
  busväder_1_N = mkN "busväder" neutrum  ; -- busväder..nn.1
  butadien_1_N = mkN "butadien" neutrum  ; -- butadien..nn.1
  butan_1_N = mkN "butan" "butaner" ; -- butan..nn.1
  butanol_1_N = mkN "butanol" ; -- butanol..nn.1
  butelj_1_N = mkN "butelj" "buteljer" ; -- butelj..nn.1
  buteljborste_1_N = mkN "buteljborste" utrum  ; -- buteljborste..nn.1
  buteljbotten_1_N = mkN "buteljbotten" ; -- buteljbotten..nn.1
  buteljera_1_V = mkV "buteljerar" ; -- buteljera..vb.1
  buteljerande_1_N = mkN "buteljerande" ; -- buteljerande..nn.1
  buteljerbar_1_A = mkA "buteljerbar" ; -- buteljerbar..av.1
  buteljerbarhet_1_N = mkN "buteljerbarhet" ; -- buteljerbarhet..nn.1
  buteljering_1_N = mkN "buteljering" ; -- buteljering..nn.1
  buteljglas_1_N = mkN "buteljglas" neutrum  ; -- buteljglas..nn.1
  buteljgrön_1_A = mkA "buteljgrön" ; -- buteljgrön..av.1
  buteljlack_1_N = mkN "buteljlack" neutrum  ; -- buteljlack..nn.1
  butik_1_N = mkN "butik" "butiker" ; -- butik..nn.1
  butiksanställd_1_A = mkA "butiksanställd" "butiksanställt" ; -- butiksanställd..av.1
  butiksbaka_1_V = mkV "butiksbakar" ; -- butiksbaka..vb.1
  butiksbakad_1_A = mkA "butiksbakad" ; -- butiksbakad..av.1
  butiksbiträde_1_N = mkN "butiksbiträde" ; -- butiksbiträde..nn.1
  butiksdörr_1_N = mkN "butiksdörr" ; -- butiksdörr..nn.1
  butiksfönster_1_N = mkN "butiksfönster" neutrum  ; -- butiksfönster..nn.1
  butiksinnehavare_1_N = mkN "butiksinnehavare" utrum  ; -- butiksinnehavare..nn.1
  butikskedja_1_N = mkN "butikskedja" ; -- butikskedja..nn.1
  butiksrån_1_N = mkN "butiksrån" neutrum  ; -- butiksrån..nn.1
  butiksstängningslag_1_N = mkN "butiksstängningslag" ; -- butiksstängningslag..nn.1
  butikstjuv_1_N = mkN "butikstjuv" ; -- butikstjuv..nn.1
  butiksägare_1_N = mkN "butiksägare" utrum  ; -- butiksägare..nn.1
  butler_1_N = mkN "butler" "butlern" "butlers" "butlersarna" ; -- butler..nn.1
  butter_1_A = mkA "butter" ; -- butter..av.1
  butterhet_1_N = mkN "butterhet" ; -- butterhet..nn.1
  butterkaka_1_N = mkN "butterkaka" ; -- butterkaka..nn.1
  butyl_1_N = mkN "butyl" "butyler" ; -- butyl..nn.1
  butylalkohol_1_N = mkN "butylalkohol" ; -- butylalkohol..nn.1
  buxbom_1_N = mkN "buxbom" ; -- buxbom..nn.1
  by_1_N = mkN "by" "byn" "byar" "byarna" ; -- by..nn.1
  byalag_1_N = mkN "byalag" neutrum  ; -- byalag..nn.1
  byamål_1_N = mkN "byamål" neutrum  ; -- byamål..nn.1
  bybo_1_N = mkN "bybo" "bybor" ; -- bybo..nn.1
  byffé_1_N = mkN "byffé" "byfféer" ; -- byffé..nn.1
  byfogde_1_N = mkN "byfogde" utrum  ; -- byfogde..nn.1
  byfåne_1_N = mkN "byfåne" utrum  ; -- byfåne..nn.1
  bygata_1_N = mkN "bygata" ; -- bygata..nn.1
  bygd_1_N = mkN "bygd" "bygder" ; -- bygd..nn.1
  bygdeborg_1_N = mkN "bygdeborg" ; -- bygdeborg..nn.1
  bygdegård_1_N = mkN "bygdegård" ; -- bygdegård..nn.1
  bygdemål_1_N = mkN "bygdemål" neutrum  ; -- bygdemål..nn.1
  bygdepatriotism_1_N = mkN "bygdepatriotism" ; -- bygdepatriotism..nn.1
  bygel_1_N = mkN "bygel" ; -- bygel..nn.1
  bygelhorn_1_N = mkN "bygelhorn" neutrum  ; -- bygelhorn..nn.1
  bygelhäst_1_N = mkN "bygelhäst" ; -- bygelhäst..nn.1
  bygellås_1_N = mkN "bygellås" neutrum  ; -- bygellås..nn.1
  bygelrem_1_N = mkN "bygelrem" "bygelremmen" "bygelremmar" "bygelremmarna" ; -- bygelrem..nn.1
  bygga_1_V = mkV "bygger" ; -- bygga..vb.1
  byggande_1_N = mkN "byggande" ; -- byggande..nn.1
  byggarbetare_1_N = mkN "byggarbetare" utrum  ; -- byggarbetare..nn.1
  byggarbetskran_1_N = mkN "byggarbetskran" ; -- byggarbetskran..nn.1
  byggarbetsplats_1_N = mkN "byggarbetsplats" "byggarbetsplatser" ; -- byggarbetsplats..nn.1
  byggare_1_N = mkN "byggare" utrum  ; -- byggare..nn.1
  byggbeslag_1_N = mkN "byggbeslag" neutrum  ; -- byggbeslag..nn.1
  byggcontainer_1_N = mkN "byggcontainer" ; -- byggcontainer..nn.1
  byggdamm_1_N = mkN "byggdamm" neutrum  ; -- byggdamm..nn.1
  byggdispens_1_N = mkN "byggdispens" "byggdispenser" ; -- byggdispens..nn.1
  bygge_1_N = mkN "bygge" ; -- bygge..nn.1
  byggelement_1_N = mkN "byggelement" neutrum  ; -- byggelement..nn.1
  byggenskap_1_N = mkN "byggenskap" ; -- byggenskap..nn.1
  byggfirma_1_N = mkN "byggfirma" ; -- byggfirma..nn.1
  byggflopp_1_N = mkN "byggflopp" ; -- byggflopp..nn.1
  byggföretag_1_N = mkN "byggföretag" neutrum  ; -- byggföretag..nn.1
  byggherre_1_N = mkN "byggherre" utrum  ; -- byggherre..nn.1
  byggjätte_1_N = mkN "byggjätte" utrum  ; -- byggjätte..nn.1
  byggkloss_1_N = mkN "byggkloss" ; -- byggkloss..nn.1
  byggkostnad_1_N = mkN "byggkostnad" "byggkostnader" ; -- byggkostnad..nn.1
  bygglag_1_N = mkN "bygglag" ; -- bygglag..nn.1
  bygglekplats_1_N = mkN "bygglekplats" "bygglekplatser" ; -- bygglekplats..nn.1
  bygglov_1_N = mkN "bygglov" neutrum  ; -- bygglov..nn.1
  bygglåda_1_N = mkN "bygglåda" ; -- bygglåda..nn.1
  byggmaterial_1_N = mkN "byggmaterial" neutrum  ; -- byggmaterial..nn.1
  byggmiss_1_N = mkN "byggmiss" ; -- byggmiss..nn.1
  byggmästardotter_1_N = mkN "byggmästardotter" "byggmästardottern" "byggmästardöttrar" "byggmästardöttrarna" ; -- byggmästardotter..nn.1
  byggmästare_1_N = mkN "byggmästare" utrum  ; -- byggmästare..nn.1
  byggnad_1_N = mkN "byggnad" "byggnader" ; -- byggnad..nn.1
  byggnadsarbetare_1_N = mkN "byggnadsarbetare" utrum  ; -- byggnadsarbetare..nn.1
  byggnadsbråte_1_N = mkN "byggnadsbråte" ; -- byggnadsbråte..nn.1
  byggnadsfirma_1_N = mkN "byggnadsfirma" ; -- byggnadsfirma..nn.1
  byggnadsföretag_1_N = mkN "byggnadsföretag" neutrum  ; -- byggnadsföretag..nn.1
  byggnadsindustri_1_N = mkN "byggnadsindustri" "byggnadsindustrier" ; -- byggnadsindustri..nn.1
  byggnadskomplex_1_N = mkN "byggnadskomplex" neutrum  ; -- byggnadskomplex..nn.1
  byggnadskonst_1_N = mkN "byggnadskonst" ; -- byggnadskonst..nn.1
  byggnadskonstruktion_1_N = mkN "byggnadskonstruktion" ; -- byggnadskonstruktion..nn.1
  byggnadskontor_1_N = mkN "byggnadskontor" neutrum  ; -- byggnadskontor..nn.1
  byggnadskredit_1_N = mkN "byggnadskredit" "byggnadskrediter" ; -- byggnadskredit..nn.1
  byggnadskreditiv_1_N = mkN "byggnadskreditiv" neutrum  ; -- byggnadskreditiv..nn.1
  byggnadslov_1_N = mkN "byggnadslov" neutrum  ; -- byggnadslov..nn.1
  byggnadslån_1_N = mkN "byggnadslån" neutrum  ; -- byggnadslån..nn.1
  byggnadsmaterial_1_N = mkN "byggnadsmaterial" neutrum  ; -- byggnadsmaterial..nn.1
  byggnadsminne_1_N = mkN "byggnadsminne" ; -- byggnadsminne..nn.1
  byggnadsmässig_1_A = mkA "byggnadsmässig" ; -- byggnadsmässig..av.1
  byggnadsnämnd_1_N = mkN "byggnadsnämnd" "byggnadsnämnder" ; -- byggnadsnämnd..nn.1
  byggnadsplan_1_N = mkN "byggnadsplan" "byggnadsplaner" ; -- byggnadsplan..nn.1
  byggnadsplats_1_N = mkN "byggnadsplats" "byggnadsplatser" ; -- byggnadsplats..nn.1
  byggnadssnickare_1_N = mkN "byggnadssnickare" utrum  ; -- byggnadssnickare..nn.1
  byggnadssockel_1_N = mkN "byggnadssockel" ; -- byggnadssockel..nn.1
  byggnadssten_1_N = mkN "byggnadssten" "byggnadsstenen" "byggnadsstenar" "byggnadsstenarna" ; -- byggnadssten..nn.1
  byggnadsstil_1_N = mkN "byggnadsstil" ; -- byggnadsstil..nn.1
  byggnadsstomme_1_N = mkN "byggnadsstomme" utrum  ; -- byggnadsstomme..nn.1
  byggnadsstyrelse_1_N = mkN "byggnadsstyrelse" "byggnadsstyrelser" ; -- byggnadsstyrelse..nn.1
  byggnadsställning_1_N = mkN "byggnadsställning" ; -- byggnadsställning..nn.1
  byggnadssätt_1_N = mkN "byggnadssätt" neutrum  ; -- byggnadssätt..nn.1
  byggnadsteknik_1_N = mkN "byggnadsteknik" "byggnadstekniker" ; -- byggnadsteknik..nn.1
  byggnadsteknisk_1_A = mkA "byggnadsteknisk" ; -- byggnadsteknisk..av.1
  byggnadstillstånd_1_N = mkN "byggnadstillstånd" neutrum  ; -- byggnadstillstånd..nn.1
  byggnadstimmer_1_N = mkN "byggnadstimmer" neutrum  ; -- byggnadstimmer..nn.1
  byggnadsverk_1_N = mkN "byggnadsverk" neutrum  ; -- byggnadsverk..nn.1
  byggnadsvirke_1_N = mkN "byggnadsvirke" ; -- byggnadsvirke..nn.1
  byggnation_1_N = mkN "byggnation" ; -- byggnation..nn.1
  byggning_1_N = mkN "byggning" ; -- byggning..nn.1
  byggnorm_1_N = mkN "byggnorm" "byggnormer" ; -- byggnorm..nn.1
  byggpass_1_N = mkN "byggpass" neutrum  ; -- byggpass..nn.1
  byggplan_1_N = mkN "byggplan" "byggplaner" ; -- byggplan..nn.1
  byggprojekt_1_N = mkN "byggprojekt" neutrum  ; -- byggprojekt..nn.1
  byggsats_1_N = mkN "byggsats" "byggsatser" ; -- byggsats..nn.1
  byggsektor_1_N = mkN "byggsektor" "byggsektorer" ; -- byggsektor..nn.1
  byggstart_1_N = mkN "byggstart" "byggstarter" ; -- byggstart..nn.1
  byggsten_1_N = mkN "byggsten" "byggstenen" "byggstenar" "byggstenarna" ; -- byggsten..nn.1
  byggstopp_1_N = mkN "byggstopp" neutrum  ; -- byggstopp..nn.1
  byggställning_1_N = mkN "byggställning" ; -- byggställning..nn.1
  byggtid_1_N = mkN "byggtid" "byggtider" ; -- byggtid..nn.1
  byggtork_1_N = mkN "byggtork" ; -- byggtork..nn.1
  byggvara_1_N = mkN "byggvara" ; -- byggvara..nn.1
  byggvaruhus_1_N = mkN "byggvaruhus" neutrum  ; -- byggvaruhus..nn.1
  byggvarukedja_1_N = mkN "byggvarukedja" ; -- byggvarukedja..nn.1
  byhus_1_N = mkN "byhus" neutrum  ; -- byhus..nn.1
  byig_1_A = mkA "byig" ; -- byig..av.1
  byk_1_N = mkN "byk" ; -- byk..nn.1
  byka_1_V = mkV "byker" ; -- byka..vb.1
  bykande_1_N = mkN "bykande" ; -- bykande..nn.1
  byke_1_N = mkN "byke" ; -- byke..nn.1
  bykgryta_1_N = mkN "bykgryta" ; -- bykgryta..nn.1
  byling_1_N = mkN "byling" ; -- byling..nn.1
  bylsig_1_A = mkA "bylsig" ; -- bylsig..av.1
  bylsighet_1_N = mkN "bylsighet" ; -- bylsighet..nn.1
  bylte_1_N = mkN "bylte" ; -- bylte..nn.1
  bymoln_1_N = mkN "bymoln" neutrum  ; -- bymoln..nn.1
  bymoské_1_N = mkN "bymoské" "bymoskéer" ; -- bymoské..nn.1
  byområde_1_N = mkN "byområde" ; -- byområde..nn.1
  byordning_1_N = mkN "byordning" ; -- byordning..nn.1
  byracka_1_N = mkN "byracka" ; -- byracka..nn.1
  byrett_1_N = mkN "byrett" "byretter" ; -- byrett..nn.1
  byrå_1_N = mkN "byrå" ; -- byrå..nn.1
  byrå_2_N = mkN "byrå" "byråer" ; -- byrå..nn.2
  byråassistent_1_N = mkN "byråassistent" "byråassistenter" ; -- byråassistent..nn.1
  byråchef_1_N = mkN "byråchef" "byråchefer" ; -- byråchef..nn.1
  byrådirektör_1_N = mkN "byrådirektör" "byrådirektörer" ; -- byrådirektör..nn.1
  byråkrat_1_N = mkN "byråkrat" "byråkrater" ; -- byråkrat..nn.1
  byråkrati_1_N = mkN "byråkrati" "byråkratier" ; -- byråkrati..nn.1
  byråkratisera_1_V = mkV "byråkratiserar" ; -- byråkratisera..vb.1
  byråkratiserande_1_N = mkN "byråkratiserande" ; -- byråkratiserande..nn.1
  byråkratiserbar_1_A = mkA "byråkratiserbar" ; -- byråkratiserbar..av.1
  byråkratiserbarhet_1_N = mkN "byråkratiserbarhet" ; -- byråkratiserbarhet..nn.1
  byråkratisering_1_N = mkN "byråkratisering" ; -- byråkratisering..nn.1
  byråkratisk_1_A = mkA "byråkratisk" ; -- byråkratisk..av.1
  byråkratism_1_N = mkN "byråkratism" "byråkratismer" ; -- byråkratism..nn.1
  byrålåda_1_N = mkN "byrålåda" ; -- byrålåda..nn.1
  byråsekreterare_1_N = mkN "byråsekreterare" utrum  ; -- byråsekreterare..nn.1
  bysamfällighet_1_N = mkN "bysamfällighet" "bysamfälligheter" ; -- bysamfällighet..nn.1
  bysantin_1_N = mkN "bysantin" "bysantiner" ; -- bysantin..nn.1
  bysantinism_1_N = mkN "bysantinism" "bysantinismer" ; -- bysantinism..nn.1
  bysantinsk_1_A = mkA "bysantinsk" ; -- bysantinsk..av.1
  byskola_1_N = mkN "byskola" ; -- byskola..nn.1
  bysnille_1_N = mkN "bysnille" ; -- bysnille..nn.1
  byssja_1_N = mkN "byssja" ; -- byssja..nn.1
  byst_1_N = mkN "byst" "byster" ; -- byst..nn.1
  bystdrottning_1_N = mkN "bystdrottning" ; -- bystdrottning..nn.1
  bysthållare_1_N = mkN "bysthållare" utrum  ; -- bysthållare..nn.1
  bystmått_1_N = mkN "bystmått" neutrum  ; -- bystmått..nn.1
  bystämma_1_N = mkN "bystämma" ; -- bystämma..nn.1
  bysätta_1_V = mkV "bysätta" "bysätter" "bysätt" "bysatte" "bysatt" "bysatt" ; -- bysätta..vb.1
  bysättande_1_N = mkN "bysättande" ; -- bysättande..nn.1
  bysättning_1_N = mkN "bysättning" ; -- bysättning..nn.1
  byta_1_V = mkV "byter" ; -- byta..vb.1
  bytande_1_N = mkN "bytande" ; -- bytande..nn.1
  byte_1_N = mkN "byte" ; -- byte..nn.1
  byte_2_N = mkN "byte" "byten" "byte" "bytena" ; -- byte..nn.2
  bytesaffär_1_N = mkN "bytesaffär" "bytesaffärer" ; -- bytesaffär..nn.1
  bytesartikel_1_N = mkN "bytesartikel" ; -- bytesartikel..nn.1
  bytesbalans_1_N = mkN "bytesbalans" ; -- bytesbalans..nn.1
  bytesbalansunderskott_1_N = mkN "bytesbalansunderskott" neutrum  ; -- bytesbalansunderskott..nn.1
  bytesbalansöverskott_1_N = mkN "bytesbalansöverskott" neutrum  ; -- bytesbalansöverskott..nn.1
  bytesbrev_1_N = mkN "bytesbrev" neutrum  ; -- bytesbrev..nn.1
  bytesdjur_1_N = mkN "bytesdjur" neutrum  ; -- bytesdjur..nn.1
  byteshandel_1_N = mkN "byteshandel" ; -- byteshandel..nn.1
  byteshushållning_1_N = mkN "byteshushållning" ; -- byteshushållning..nn.1
  byteslägenhet_1_N = mkN "byteslägenhet" "byteslägenheter" ; -- byteslägenhet..nn.1
  bytesmedel_1_N = mkN "bytesmedel" neutrum  ; -- bytesmedel..nn.1
  bytesobjekt_1_N = mkN "bytesobjekt" neutrum  ; -- bytesobjekt..nn.1
  bytesvara_1_N = mkN "bytesvara" ; -- bytesvara..nn.1
  bytesvärde_1_N = mkN "bytesvärde" ; -- bytesvärde..nn.1
  byting_1_N = mkN "byting" ; -- byting..nn.1
  bytta_1_N = mkN "bytta" ; -- bytta..nn.1
  byväg_1_N = mkN "byväg" ; -- byväg..nn.1
  byx_1_N = mkN "byx" ; -- byx..nn.1
  byxa_1_N = mkN "byxa" ; -- byxa..nn.1
  byxbak_1_N = mkN "byxbak" ; -- byxbak..nn.1
  byxben_1_N = mkN "byxben" neutrum  ; -- byxben..nn.1
  byxdress_1_N = mkN "byxdress" ; -- byxdress..nn.1
  byxdräkt_1_N = mkN "byxdräkt" "byxdräkter" ; -- byxdräkt..nn.1
  byxficka_1_N = mkN "byxficka" ; -- byxficka..nn.1
  byxholk_1_N = mkN "byxholk" ; -- byxholk..nn.1
  byxhälla_1_N = mkN "byxhälla" ; -- byxhälla..nn.1
  byxis_1_A = mkA "byxis" ; -- byxis..av.1
  byxkjol_1_N = mkN "byxkjol" ; -- byxkjol..nn.1
  byxklämma_1_N = mkN "byxklämma" ; -- byxklämma..nn.1
  byxklåda_1_N = mkN "byxklåda" ; -- byxklåda..nn.1
  byxknä_1_N = mkN "byxknä" "byxknät" "byxknän" "byxknäna" ; -- byxknä..nn.1
  byxlös_1_A = mkA "byxlös" ; -- byxlös..av.1
  byxlöshet_1_N = mkN "byxlöshet" ; -- byxlöshet..nn.1
  byxslag_1_N = mkN "byxslag" neutrum  ; -- byxslag..nn.1
  byxångest_1_N = mkN "byxångest" ; -- byxångest..nn.1
  byäldste_1_N = mkN "byäldste" utrum  ; -- byäldste..nn.1
  bäbis_1_N = mkN "bäbis" ; -- bäbis..nn.1
  bäck_1_N = mkN "bäck" ; -- bäck..nn.1
  bäckahäst_1_N = mkN "bäckahäst" ; -- bäckahäst..nn.1
  bäcken_1_N = mkN "bäcken" neutrum  ; -- bäcken..nn.1
  bäckenben_1_N = mkN "bäckenben" neutrum  ; -- bäckenben..nn.1
  bäckenförträngning_1_N = mkN "bäckenförträngning" ; -- bäckenförträngning..nn.1
  bäckenhåla_1_N = mkN "bäckenhåla" ; -- bäckenhåla..nn.1
  bäckenuppluckring_1_N = mkN "bäckenuppluckring" ; -- bäckenuppluckring..nn.1
  bäckforell_1_N = mkN "bäckforell" "bäckforeller" ; -- bäckforell..nn.1
  bäckmynning_1_N = mkN "bäckmynning" ; -- bäckmynning..nn.1
  bäckravin_1_N = mkN "bäckravin" "bäckraviner" ; -- bäckravin..nn.1
  bäckröding_1_N = mkN "bäckröding" ; -- bäckröding..nn.1
  bäckvatten_1_N = mkN "bäckvatten" "bäckvattnet" "bäckvatten" "bäckvattnen" ; -- bäckvatten..nn.1
  bäcköring_1_N = mkN "bäcköring" ; -- bäcköring..nn.1
  bädd_1_N = mkN "bädd" ; -- bädd..nn.1
  bädda_1_V = mkV "bäddar" ; -- bädda..vb.1
  bädda_2_V = mkV "bäddar" ; -- bädda..vb.2
  bäddande_1_N = mkN "bäddande" ; -- bäddande..nn.1
  bäddjacka_1_N = mkN "bäddjacka" ; -- bäddjacka..nn.1
  bäddning_1_N = mkN "bäddning" ; -- bäddning..nn.1
  bäddsoffa_1_N = mkN "bäddsoffa" ; -- bäddsoffa..nn.1
  bäddutrustning_1_N = mkN "bäddutrustning" ; -- bäddutrustning..nn.1
  bägare_1_N = mkN "bägare" utrum  ; -- bägare..nn.1
  bägarkorall_1_N = mkN "bägarkorall" "bägarkoraller" ; -- bägarkorall..nn.1
  bägarmanet_1_N = mkN "bägarmanet" "bägarmaneter" ; -- bägarmanet..nn.1
  bägarsvamp_1_N = mkN "bägarsvamp" ; -- bägarsvamp..nn.1
  bälg_1_N = mkN "bälg" ; -- bälg..nn.1
  bälga_1_V = mkV "bälgar" ; -- bälga..vb.1
  bälgande_1_N = mkN "bälgande" ; -- bälgande..nn.1
  bälgformad_1_A = mkA "bälgformad" ; -- bälgformad..av.1
  bälgkamera_1_N = mkN "bälgkamera" ; -- bälgkamera..nn.1
  bälgliknande_1_A = mkA "bälgliknande" ; -- bälgliknande..av.1
  bälgvante_1_N = mkN "bälgvante" utrum  ; -- bälgvante..nn.1
  bälta_1_N = mkN "bälta" ; -- bälta..nn.1
  bälta_1_V = mkV "bältar" ; -- bälta..vb.1
  bältande_1_N = mkN "bältande" ; -- bältande..nn.1
  bältdjur_1_N = mkN "bältdjur" neutrum  ; -- bältdjur..nn.1
  bälte_1_N = mkN "bälte" ; -- bälte..nn.1
  bältesläggning_1_N = mkN "bältesläggning" ; -- bältesläggning..nn.1
  bältespännare_1_N = mkN "bältespännare" utrum  ; -- bältespännare..nn.1
  bältestvång_1_N = mkN "bältestvång" neutrum  ; -- bältestvång..nn.1
  bältning_1_N = mkN "bältning" ; -- bältning..nn.1
  bältros_1_N = mkN "bältros" ; -- bältros..nn.1
  bända_1_V = mkV "bänder" ; -- bända..vb.1
  bändande_1_N = mkN "bändande" ; -- bändande..nn.1
  bändelband_1_N = mkN "bändelband" neutrum  ; -- bändelband..nn.1
  bändjärn_1_N = mkN "bändjärn" neutrum  ; -- bändjärn..nn.1
  bändning_1_N = mkN "bändning" ; -- bändning..nn.1
  bändsel_1_N = mkN "bändsel" ; -- bändsel..nn.1
  bändsla_1_V = mkV "bändslar" ; -- bändsla..vb.1
  bändslande_1_N = mkN "bändslande" ; -- bändslande..nn.1
  bäng_1_A = mkA "bäng" ; -- bäng..av.1
  bängel_1_N = mkN "bängel" ; -- bängel..nn.1
  bänghet_1_N = mkN "bänghet" ; -- bänghet..nn.1
  bänk_1_N = mkN "bänk" ; -- bänk..nn.1
  bänka_1_V = mkV "bänkar" ; -- bänka..vb.1
  bänka_2_V = mkV "bänkar" ; -- bänka..vb.2
  bänkad_1_A = mkA "bänkad" ; -- bänkad..av.1
  bänkgranne_1_N = mkN "bänkgranne" utrum  ; -- bänkgranne..nn.1
  bänkkamrat_1_N = mkN "bänkkamrat" "bänkkamrater" ; -- bänkkamrat..nn.1
  bänknummer_1_N = mkN "bänknummer" neutrum  ; -- bänknummer..nn.1
  bänkplats_1_N = mkN "bänkplats" "bänkplatser" ; -- bänkplats..nn.1
  bänkpress_1_N = mkN "bänkpress" ; -- bänkpress..nn.1
  bänkrad_1_N = mkN "bänkrad" "bänkrader" ; -- bänkrad..nn.1
  bänkskåp_1_N = mkN "bänkskåp" neutrum  ; -- bänkskåp..nn.1
  bänkslipmaskin_1_N = mkN "bänkslipmaskin" "bänkslipmaskiner" ; -- bänkslipmaskin..nn.1
  bänkspis_1_N = mkN "bänkspis" ; -- bänkspis..nn.1
  bänsel_1_N = mkN "bänsel" ; -- bänsel..nn.1
  bänsla_1_V = mkV "bänslar" ; -- bänsla..vb.1
  bänslande_1_N = mkN "bänslande" ; -- bänslande..nn.1
  bär_1_N = mkN "bär" neutrum  ; -- bär..nn.1
  bära_1_V = mkV "bära" "bar" "burit" ; -- bära..vb.1
  bärande_1_A = mkA "bärande" ; -- bärande..av.1
  bärande_1_N = mkN "bärande" ; -- bärande..nn.1
  bärare_1_N = mkN "bärare" utrum  ; -- bärare..nn.1
  bärarlag_1_N = mkN "bärarlag" neutrum  ; -- bärarlag..nn.1
  bärbar_1_A = mkA "bärbar" ; -- bärbar..av.1
  bärbarhet_1_N = mkN "bärbarhet" ; -- bärbarhet..nn.1
  bärbjälke_1_N = mkN "bärbjälke" utrum  ; -- bärbjälke..nn.1
  bärbuske_1_N = mkN "bärbuske" utrum  ; -- bärbuske..nn.1
  bärfis_1_N = mkN "bärfis" ; -- bärfis..nn.1
  bärfrekvens_1_N = mkN "bärfrekvens" "bärfrekvenser" ; -- bärfrekvens..nn.1
  bärga_1_V = mkV "bärgar" ; -- bärga..vb.1
  bärgande_1_N = mkN "bärgande" ; -- bärgande..nn.1
  bärgare_1_N = mkN "bärgare" utrum  ; -- bärgare..nn.1
  bärgarlön_1_N = mkN "bärgarlön" "bärgarlöner" ; -- bärgarlön..nn.1
  bärgning_1_N = mkN "bärgning" ; -- bärgning..nn.1
  bärgningsbil_1_N = mkN "bärgningsbil" ; -- bärgningsbil..nn.1
  bärgningsföretag_1_N = mkN "bärgningsföretag" neutrum  ; -- bärgningsföretag..nn.1
  bärgningsledare_1_N = mkN "bärgningsledare" utrum  ; -- bärgningsledare..nn.1
  bärgningspersonal_1_N = mkN "bärgningspersonal" ; -- bärgningspersonal..nn.1
  bärgningsväder_1_N = mkN "bärgningsväder" neutrum  ; -- bärgningsväder..nn.1
  bärhandtag_1_N = mkN "bärhandtag" neutrum  ; -- bärhandtag..nn.1
  bärhjälp_1_N = mkN "bärhjälp" ; -- bärhjälp..nn.1
  bärig_1_A = mkA "bärig" ; -- bärig..av.1
  bärighet_1_N = mkN "bärighet" ; -- bärighet..nn.1
  bäring_1_N = mkN "bäring" ; -- bäring..nn.1
  bärkasse_1_N = mkN "bärkasse" utrum  ; -- bärkasse..nn.1
  bärkotte_1_N = mkN "bärkotte" utrum  ; -- bärkotte..nn.1
  bärkraft_1_N = mkN "bärkraft" ; -- bärkraft..nn.1
  bärkraftig_1_A = mkA "bärkraftig" ; -- bärkraftig..av.1
  bärkraftighet_1_N = mkN "bärkraftighet" ; -- bärkraftighet..nn.1
  bärlager_1_N = mkN "bärlager" neutrum  ; -- bärlager..nn.1
  bärm_1_N = mkN "bärm" "bärmer" ; -- bärm..nn.1
  bärmark_1_N = mkN "bärmark" "bärmarker" ; -- bärmark..nn.1
  bärnstensfärgad_1_A = mkA "bärnstensfärgad" ; -- bärnstensfärgad..av.1
  bärnstenssmycke_1_N = mkN "bärnstenssmycke" ; -- bärnstenssmycke..nn.1
  bärnstenssyra_1_N = mkN "bärnstenssyra" ; -- bärnstenssyra..nn.1
  bärnäs_1_N = mkN "bärnäs" "bärnäser" ; -- bärnäs..nn.1
  bärnässås_1_N = mkN "bärnässås" "bärnässåser" ; -- bärnässås..nn.1
  bärpelare_1_N = mkN "bärpelare" utrum  ; -- bärpelare..nn.1
  bärplan_1_N = mkN "bärplan" neutrum  ; -- bärplan..nn.1
  bärplansbåt_1_N = mkN "bärplansbåt" ; -- bärplansbåt..nn.1
  bärplockare_1_N = mkN "bärplockare" utrum  ; -- bärplockare..nn.1
  bärplockning_1_N = mkN "bärplockning" ; -- bärplockning..nn.1
  bärpåse_1_N = mkN "bärpåse" utrum  ; -- bärpåse..nn.1
  bärraket_1_N = mkN "bärraket" "bärraketer" ; -- bärraket..nn.1
  bärrem_1_N = mkN "bärrem" "bärremmen" "bärremmar" "bärremmarna" ; -- bärrem..nn.1
  bärs_1_N = mkN "bärs" ; -- bärs..nn.1
  bärs_2_N = mkN "bärs" ; -- bärs..nn.2
  bärsa_1_N = mkN "bärsa" ; -- bärsa..nn.1
  bärsa_2_N = mkN "bärsa" ; -- bärsa..nn.2
  bärsa_1_V = mkV "bärsar" ; -- bärsa..vb.1
  bärsande_1_N = mkN "bärsande" ; -- bärsande..nn.1
  bärsele_1_N = mkN "bärsele" utrum  ; -- bärsele..nn.1
  bärstol_1_N = mkN "bärstol" ; -- bärstol..nn.1
  bärsärk_1_N = mkN "bärsärk" ; -- bärsärk..nn.1
  bärsärkagång_1_N = mkN "bärsärkagång" ; -- bärsärkagång..nn.1
  bärsärkaraseri_1_N = mkN "bärsärkaraseri" neutrum  ; -- bärsärkaraseri..nn.1
  bärvidd_1_N = mkN "bärvidd" "bärvidder" ; -- bärvidd..nn.1
  bärvin_1_N = mkN "bärvin" "bärvinet" "bärviner" "bärvinerna" ; -- bärvin..nn.1
  bärvåg_1_N = mkN "bärvåg" "bärvågor" ; -- bärvåg..nn.1
  bäst_före_dag_1_N = mkN "bäst-före-dag" ; -- bäst-före-dag..nn.1
  bäst_före_datum_1_N = mkN "bäst-före-datum" ; -- bäst-före-datum..nn.1
  bästeman_1_N = mkN "bästeman" "bästemannen" "bästemän" "bästemännen" ; -- bästeman..nn.1
  bästföre_dag_1_N = mkN "bästföre-dag" ; -- bästföre-dag..nn.1
  bästföre_datum_1_N = mkN "bästföre-datum" ; -- bästföre-datum..nn.1
  bästföredag_1_N = mkN "bästföredag" ; -- bästföredag..nn.1
  bästföredatum_1_N = mkN "bästföredatum" ; -- bästföredatum..nn.1
  bästis_1_N = mkN "bästis" ; -- bästis..nn.1
  bästsäljande_1_A = mkA "bästsäljande" ; -- bästsäljande..av.1
  bästsäljare_1_N = mkN "bästsäljare" utrum  ; -- bästsäljare..nn.1
  bästsäljarism_1_N = mkN "bästsäljarism" ; -- bästsäljarism..nn.1
  bästsäljarlista_1_N = mkN "bästsäljarlista" ; -- bästsäljarlista..nn.1
  bättra_1_V = mkV "bättrar" ; -- bättra..vb.1
  bättrande_1_N = mkN "bättrande" ; -- bättrande..nn.1
  bättring_1_N = mkN "bättring" ; -- bättring..nn.1
  bäva_1_V = mkV "bävar" ; -- bäva..vb.1
  bävande_1_N = mkN "bävande" ; -- bävande..nn.1
  bäver_1_N = mkN "bäver" ; -- bäver..nn.1
  bävergäll_1_N = mkN "bävergäll" ; -- bävergäll..nn.1
  bävernylon_1_N = mkN "bävernylon" ; -- bävernylon..nn.1
  bävernylonoverall_1_N = mkN "bävernylonoverall" "bävernylonoveraller" ; -- bävernylonoverall..nn.1
  bäverpäls_1_N = mkN "bäverpäls" ; -- bäverpäls..nn.1
  bäverråtta_1_N = mkN "bäverråtta" ; -- bäverråtta..nn.1
  bävning_1_N = mkN "bävning" ; -- bävning..nn.1
  båda_1_N = mkN "båda" ; -- båda..nn.1
  båda_1_V = mkV "bådar" ; -- båda..vb.1
  bådande_1_N = mkN "bådande" ; -- bådande..nn.1
  både_1_N = mkN "både" utrum  ; -- både..nn.1
  båg_1_N = mkN "båg" neutrum  ; -- båg..nn.1
  båga_1_V = mkV "bågar" ; -- båga..vb.1
  bågande_1_N = mkN "bågande" ; -- bågande..nn.1
  bågbro_1_N = mkN "bågbro" ; -- bågbro..nn.1
  båge_1_N = mkN "båge" utrum  ; -- båge..nn.1
  bågfil_1_N = mkN "bågfil" ; -- bågfil..nn.1
  bågform_1_N = mkN "bågform" "bågformer" ; -- bågform..nn.1
  bågformad_1_A = mkA "bågformad" ; -- bågformad..av.1
  bågformig_1_A = mkA "bågformig" ; -- bågformig..av.1
  bågformighet_1_N = mkN "bågformighet" ; -- bågformighet..nn.1
  bågfris_1_N = mkN "bågfris" "bågfriser" ; -- bågfris..nn.1
  bågfält_1_N = mkN "bågfält" neutrum  ; -- bågfält..nn.1
  bågfönster_1_N = mkN "bågfönster" neutrum  ; -- bågfönster..nn.1
  båggång_1_N = mkN "båggång" ; -- båggång..nn.1
  bågig_1_A = mkA "bågig" ; -- bågig..av.1
  båglampa_1_N = mkN "båglampa" ; -- båglampa..nn.1
  båglinje_1_N = mkN "båglinje" "båglinjer" ; -- båglinje..nn.1
  bågljus_1_N = mkN "bågljus" neutrum  ; -- bågljus..nn.1
  bågminut_1_N = mkN "bågminut" "bågminuter" ; -- bågminut..nn.1
  bågna_1_V = mkV "bågnar" ; -- bågna..vb.1
  bågnande_1_N = mkN "bågnande" ; -- bågnande..nn.1
  bågsekund_1_N = mkN "bågsekund" "bågsekunder" ; -- bågsekund..nn.1
  bågskytt_1_N = mkN "bågskytt" ; -- bågskytt..nn.1
  bågskytte_1_N = mkN "bågskytte" ; -- bågskytte..nn.1
  bågskyttefält_1_N = mkN "bågskyttefält" neutrum  ; -- bågskyttefält..nn.1
  bågsträng_1_N = mkN "bågsträng" ; -- bågsträng..nn.1
  bågsvetsning_1_N = mkN "bågsvetsning" ; -- bågsvetsning..nn.1
  bågsåg_1_N = mkN "bågsåg" ; -- bågsåg..nn.1
  bågvalv_1_N = mkN "bågvalv" neutrum  ; -- bågvalv..nn.1
  båk_1_N = mkN "båk" ; -- båk..nn.1
  bål_1_N = mkN "bål" ; -- bål..nn.1
  bål_2_N = mkN "bål" neutrum  ; -- bål..nn.2
  båld_1_A = mkA "båld" "bålt" ; -- båld..av.1
  båldhet_1_N = mkN "båldhet" ; -- båldhet..nn.1
  bålgeting_1_N = mkN "bålgeting" ; -- bålgeting..nn.1
  bålrullning_1_N = mkN "bålrullning" ; -- bålrullning..nn.1
  bålrörelse_1_N = mkN "bålrörelse" "bålrörelser" ; -- bålrörelse..nn.1
  bålverk_1_N = mkN "bålverk" neutrum  ; -- bålverk..nn.1
  bålväxt_1_N = mkN "bålväxt" "bålväxter" ; -- bålväxt..nn.1
  bångstyrig_1_A = mkA "bångstyrig" ; -- bångstyrig..av.1
  bångstyrighet_1_N = mkN "bångstyrighet" ; -- bångstyrighet..nn.1
  bår_1_N = mkN "bår" ; -- bår..nn.1
  bårbärare_1_N = mkN "bårbärare" utrum  ; -- bårbärare..nn.1
  bårbärning_1_N = mkN "bårbärning" ; -- bårbärning..nn.1
  bård_1_N = mkN "bård" "bårder" ; -- bård..nn.1
  bårdmönster_1_N = mkN "bårdmönster" neutrum  ; -- bårdmönster..nn.1
  bårhus_1_N = mkN "bårhus" neutrum  ; -- bårhus..nn.1
  bårlärka_1_N = mkN "bårlärka" ; -- bårlärka..nn.1
  bås_1_N = mkN "bås" neutrum  ; -- bås..nn.1
  båt_1_N = mkN "båt" ; -- båt..nn.1
  båta_1_V = mkV "båtar" ; -- båta..vb.1
  båtande_1_N = mkN "båtande" ; -- båtande..nn.1
  båtankomst_1_N = mkN "båtankomst" "båtankomster" ; -- båtankomst..nn.1
  båtavgång_1_N = mkN "båtavgång" ; -- båtavgång..nn.1
  båtben_1_N = mkN "båtben" neutrum  ; -- båtben..nn.1
  båtbotten_1_N = mkN "båtbotten" ; -- båtbotten..nn.1
  båtbrygga_1_N = mkN "båtbrygga" ; -- båtbrygga..nn.1
  båtbyggare_1_N = mkN "båtbyggare" utrum  ; -- båtbyggare..nn.1
  båtbygge_1_N = mkN "båtbygge" ; -- båtbygge..nn.1
  båtbyggeri_1_N = mkN "båtbyggeri" "båtbyggeriet" "båtbyggerier" "båtbyggerierna" ; -- båtbyggeri..nn.1
  båtdäck_1_N = mkN "båtdäck" neutrum  ; -- båtdäck..nn.1
  båtfart_1_N = mkN "båtfart" ; -- båtfart..nn.1
  båtformig_1_A = mkA "båtformig" ; -- båtformig..av.1
  båtfärd_1_N = mkN "båtfärd" "båtfärder" ; -- båtfärd..nn.1
  båtgrav_1_N = mkN "båtgrav" ; -- båtgrav..nn.1
  båthall_1_N = mkN "båthall" ; -- båthall..nn.1
  båthus_1_N = mkN "båthus" neutrum  ; -- båthus..nn.1
  båtklubb_1_N = mkN "båtklubb" ; -- båtklubb..nn.1
  båtliknande_1_A = mkA "båtliknande" ; -- båtliknande..av.1
  båtlägenhet_1_N = mkN "båtlägenhet" "båtlägenheter" ; -- båtlägenhet..nn.1
  båtmotor_1_N = mkN "båtmotor" "båtmotorer" ; -- båtmotor..nn.1
  båtmässa_1_N = mkN "båtmässa" ; -- båtmässa..nn.1
  båtmössa_1_N = mkN "båtmössa" ; -- båtmössa..nn.1
  båtnad_1_N = mkN "båtnad" "båtnader" ; -- båtnad..nn.1
  båtpendla_1_V = mkV "båtpendlar" ; -- båtpendla..vb.1
  båtpendlande_1_N = mkN "båtpendlande" ; -- båtpendlande..nn.1
  båtpendling_1_N = mkN "båtpendling" ; -- båtpendling..nn.1
  båtplats_1_N = mkN "båtplats" "båtplatser" ; -- båtplats..nn.1
  båtresa_1_N = mkN "båtresa" ; -- båtresa..nn.1
  båtshake_1_N = mkN "båtshake" utrum  ; -- båtshake..nn.1
  båtskjul_1_N = mkN "båtskjul" neutrum  ; -- båtskjul..nn.1
  båtskrå_1_N = mkN "båtskrå" "båtskrået" "båtskrån" "båtskråna" ; -- båtskrå..nn.1
  båtsman_1_N = mkN "båtsman" "båtsmannen" "båtsmän" "båtsmännen" ; -- båtsman..nn.1
  båtsmansstol_1_N = mkN "båtsmansstol" ; -- båtsmansstol..nn.1
  båtspant_1_N = mkN "båtspant" neutrum  ; -- båtspant..nn.1
  båtterminal_1_N = mkN "båtterminal" "båtterminaler" ; -- båtterminal..nn.1
  båttidtabell_1_N = mkN "båttidtabell" "båttidtabeller" ; -- båttidtabell..nn.1
  båttrafik_1_N = mkN "båttrafik" ; -- båttrafik..nn.1
  båttransport_1_N = mkN "båttransport" "båttransporter" ; -- båttransport..nn.1
  båttur_1_N = mkN "båttur" "båtturer" ; -- båttur..nn.1
  båttävling_1_N = mkN "båttävling" ; -- båttävling..nn.1
  båtutflykt_1_N = mkN "båtutflykt" "båtutflykter" ; -- båtutflykt..nn.1
  båtvagga_1_N = mkN "båtvagga" ; -- båtvagga..nn.1
  båtvård_1_N = mkN "båtvård" ; -- båtvård..nn.1
  båtvårdsmedel_1_N = mkN "båtvårdsmedel" neutrum  ; -- båtvårdsmedel..nn.1
  båtyxa_1_N = mkN "båtyxa" ; -- båtyxa..nn.1
  béarnaise_1_N = mkN "béarnaise" "béarnaiser" ; -- béarnaise..nn.1
  béarnaisesås_1_N = mkN "béarnaisesås" "béarnaisesåser" ; -- béarnaisesås..nn.1
  böckling_1_N = mkN "böckling" ; -- böckling..nn.1
  bödel_1_N = mkN "bödel" ; -- bödel..nn.1
  bödelsdräng_1_N = mkN "bödelsdräng" ; -- bödelsdräng..nn.1
  bödelssvärd_1_N = mkN "bödelssvärd" neutrum  ; -- bödelssvärd..nn.1
  bödelsyxa_1_N = mkN "bödelsyxa" ; -- bödelsyxa..nn.1
  bög_1_N = mkN "bög" ; -- bög..nn.1
  bögdöd_1_N = mkN "bögdöd" ; -- bögdöd..nn.1
  bögporr_1_N = mkN "bögporr" ; -- bögporr..nn.1
  böhmare_1_N = mkN "böhmare" utrum  ; -- böhmare..nn.1
  böhmisk_1_A = mkA "böhmisk" ; -- böhmisk..av.1
  böj_1_N = mkN "böj" ; -- böj..nn.1
  böja_1_V = mkV "böja" "böjde" "böjt" ; -- böja..vb.1
  böjande_1_N = mkN "böjande" ; -- böjande..nn.1
  böjare_1_N = mkN "böjare" utrum  ; -- böjare..nn.1
  böjarmuskel_1_N = mkN "böjarmuskel" "böjarmuskeln" "böjarmuskler" "böjarmusklerna" ; -- böjarmuskel..nn.1
  böjbar_1_A = mkA "böjbar" ; -- böjbar..av.1
  böjbarhet_1_N = mkN "böjbarhet" ; -- böjbarhet..nn.1
  böjd_1_A = mkA "böjd" "böjt" ; -- böjd..av.1
  böjdhet_1_N = mkN "böjdhet" ; -- böjdhet..nn.1
  böjelse_1_N = mkN "böjelse" "böjelser" ; -- böjelse..nn.1
  böjhållfasthet_1_N = mkN "böjhållfasthet" "böjhållfastheter" ; -- böjhållfasthet..nn.1
  böjlig_1_A = mkA "böjlig" ; -- böjlig..av.1
  böjlighet_1_N = mkN "böjlighet" ; -- böjlighet..nn.1
  böjmuskel_1_N = mkN "böjmuskel" "böjmuskeln" "böjmuskler" "böjmusklerna" ; -- böjmuskel..nn.1
  böjning_1_N = mkN "böjning" ; -- böjning..nn.1
  böjningsexempel_1_N = mkN "böjningsexempel" neutrum  ; -- böjningsexempel..nn.1
  böjningsform_1_N = mkN "böjningsform" "böjningsformer" ; -- böjningsform..nn.1
  böjningsmönster_1_N = mkN "böjningsmönster" neutrum  ; -- böjningsmönster..nn.1
  böjningssätt_1_N = mkN "böjningssätt" neutrum  ; -- böjningssätt..nn.1
  böjningsändelse_1_N = mkN "böjningsändelse" "böjningsändelser" ; -- böjningsändelse..nn.1
  böjprov_1_N = mkN "böjprov" neutrum  ; -- böjprov..nn.1
  böjträ_1_N = mkN "böjträ" neutrum  ; -- böjträ..nn.1
  bök_1_N = mkN "bök" neutrum  ; -- bök..nn.1
  böka_1_V = mkV "bökar" ; -- böka..vb.1
  bökande_1_N = mkN "bökande" ; -- bökande..nn.1
  bökig_1_A = mkA "bökig" ; -- bökig..av.1
  bökning_1_N = mkN "bökning" ; -- bökning..nn.1
  böl_1_N = mkN "böl" neutrum  ; -- böl..nn.1
  böla_1_V = mkV "bölar" ; -- böla..vb.1
  bölande_1_N = mkN "bölande" ; -- bölande..nn.1
  böld_1_N = mkN "böld" "bölder" ; -- böld..nn.1
  böldpest_1_N = mkN "böldpest" ; -- böldpest..nn.1
  bölja_1_N = mkN "bölja" ; -- bölja..nn.1
  bölja_1_V = mkV "böljar" ; -- bölja..vb.1
  böljande_1_N = mkN "böljande" ; -- böljande..nn.1
  böljegång_1_N = mkN "böljegång" ; -- böljegång..nn.1
  böljeslag_1_N = mkN "böljeslag" neutrum  ; -- böljeslag..nn.1
  böljeslagsmärke_1_N = mkN "böljeslagsmärke" ; -- böljeslagsmärke..nn.1
  bölning_1_N = mkN "bölning" ; -- bölning..nn.1
  bön_1_N = mkN "bön" "böner" ; -- bön..nn.1
  böna_1_N = mkN "böna" ; -- böna..nn.1
  böna_1_V = mkV "bönar" ; -- böna..vb.1
  bönande_1_N = mkN "bönande" ; -- bönande..nn.1
  bönbok_1_N = mkN "bönbok" "bönböcker" ; -- bönbok..nn.1
  böndag_1_N = mkN "böndag" ; -- böndag..nn.1
  böneanrop_1_N = mkN "böneanrop" neutrum  ; -- böneanrop..nn.1
  bönegudstjänst_1_N = mkN "bönegudstjänst" "bönegudstjänster" ; -- bönegudstjänst..nn.1
  bönehus_1_N = mkN "bönehus" neutrum  ; -- bönehus..nn.1
  böneman_1_N = mkN "böneman" "bönemannen" "bönemän" "bönemännen" ; -- böneman..nn.1
  bönematta_1_N = mkN "bönematta" ; -- bönematta..nn.1
  bönemöte_1_N = mkN "bönemöte" ; -- bönemöte..nn.1
  böneramp_1_N = mkN "böneramp" "böneramper" ; -- böneramp..nn.1
  bönerum_1_N = mkN "bönerum" "bönerummet" "bönerum" "bönerummen" ; -- bönerum..nn.1
  bönesal_1_N = mkN "bönesal" ; -- bönesal..nn.1
  böneskrift_1_N = mkN "böneskrift" "böneskrifter" ; -- böneskrift..nn.1
  bönestund_1_N = mkN "bönestund" "bönestunder" ; -- bönestund..nn.1
  böneutropare_1_N = mkN "böneutropare" utrum  ; -- böneutropare..nn.1
  bönfalla_1_V = mkV "bönfalla" "bönföll" "bönfallit" ; -- bönfalla..vb.1
  bönfallande_1_N = mkN "bönfallande" ; -- bönfallande..nn.1
  bönformig_1_A = mkA "bönformig" ; -- bönformig..av.1
  böngrodd_1_N = mkN "böngrodd" ; -- böngrodd..nn.1
  bönhas_1_N = mkN "bönhas" ; -- bönhas..nn.1
  bönhus_1_N = mkN "bönhus" neutrum  ; -- bönhus..nn.1
  bönhöra_1_V = mkV "bönhöra" "bönhörde" "bönhört" ; -- bönhöra..vb.1
  bönhörande_1_N = mkN "bönhörande" ; -- bönhörande..nn.1
  bönhörelse_1_N = mkN "bönhörelse" "bönhörelser" ; -- bönhörelse..nn.1
  bönkaffe_1_N = mkN "bönkaffe" ; -- bönkaffe..nn.1
  bönlig_1_A = mkA "bönlig" ; -- bönlig..av.1
  bönpall_1_N = mkN "bönpall" ; -- bönpall..nn.1
  bönskida_1_N = mkN "bönskida" ; -- bönskida..nn.1
  bönväxt_1_N = mkN "bönväxt" "bönväxter" ; -- bönväxt..nn.1
  böra_1_V = mkV "böra" "borde" "bort" ; -- böra..vb.1
  börande_1_N = mkN "börande" ; -- börande..nn.1
  börd_1_N = mkN "börd" ; -- börd..nn.1
  börda_1_N = mkN "börda" ; -- börda..nn.1
  bördig_1_A = mkA "bördig" ; -- bördig..av.1
  bördig_2_A = mkA "bördig" ; -- bördig..av.2
  bördighet_1_N = mkN "bördighet" ; -- bördighet..nn.1
  bördsadel_1_N = mkN "bördsadel" ; -- bördsadel..nn.1
  bördsaristokrati_1_N = mkN "bördsaristokrati" "bördsaristokratier" ; -- bördsaristokrati..nn.1
  bördshögfärd_1_N = mkN "bördshögfärd" ; -- bördshögfärd..nn.1
  bördsrätt_1_N = mkN "bördsrätt" ; -- bördsrätt..nn.1
  bördsstolt_1_A = mkA "bördsstolt" "bördsstolt" ; -- bördsstolt..av.1
  bördsstolthet_1_N = mkN "bördsstolthet" ; -- bördsstolthet..nn.1
  börja_1_V = mkV "börjar" ; -- börja..vb.1
  börja_2_V = mkV "börjar" ; -- börja..vb.2
  börjande_1_N = mkN "börjande" ; -- börjande..nn.1
  börs_1_N = mkN "börs" ; -- börs..nn.1
  börs_2_N = mkN "börs" "börser" ; -- börs..nn.2
  börsanalys_1_N = mkN "börsanalys" "börsanalyser" ; -- börsanalys..nn.1
  börsanalytiker_1_N = mkN "börsanalytiker" "börsanalytikern" "börsanalytiker" "börsanalytikerna" ; -- börsanalytiker..nn.1
  börsbolag_1_N = mkN "börsbolag" neutrum  ; -- börsbolag..nn.1
  börsjobbare_1_N = mkN "börsjobbare" utrum  ; -- börsjobbare..nn.1
  börskaos_1_N = mkN "börskaos" neutrum  ; -- börskaos..nn.1
  börskrasch_1_N = mkN "börskrasch" "börskrascher" ; -- börskrasch..nn.1
  börskurs_1_N = mkN "börskurs" "börskurser" ; -- börskurs..nn.1
  börsmäklare_1_N = mkN "börsmäklare" utrum  ; -- börsmäklare..nn.1
  börsmässig_1_A = mkA "börsmässig" ; -- börsmässig..av.1
  börsnotera_1_V = mkV "börsnoterar" ; -- börsnotera..vb.1
  börsnoterande_1_N = mkN "börsnoterande" ; -- börsnoterande..nn.1
  börsnoterbar_1_A = mkA "börsnoterbar" ; -- börsnoterbar..av.1
  börsnoterbarhet_1_N = mkN "börsnoterbarhet" ; -- börsnoterbarhet..nn.1
  börsnotering_1_N = mkN "börsnotering" ; -- börsnotering..nn.1
  börsoro_1_N = mkN "börsoro" ; -- börsoro..nn.1
  börsras_1_N = mkN "börsras" neutrum  ; -- börsras..nn.1
  börssal_1_N = mkN "börssal" ; -- börssal..nn.1
  börsspekulant_1_N = mkN "börsspekulant" "börsspekulanter" ; -- börsspekulant..nn.1
  börsspekulation_1_N = mkN "börsspekulation" ; -- börsspekulation..nn.1
  börsstyrelse_1_N = mkN "börsstyrelse" "börsstyrelser" ; -- börsstyrelse..nn.1
  börstelegraf_1_N = mkN "börstelegraf" "börstelegrafer" ; -- börstelegraf..nn.1
  börsuppgång_1_N = mkN "börsuppgång" ; -- börsuppgång..nn.1
  börsutveckling_1_N = mkN "börsutveckling" ; -- börsutveckling..nn.1
  börsyra_1_N = mkN "börsyra" ; -- börsyra..nn.1
  börting_1_N = mkN "börting" ; -- börting..nn.1
  bössa_1_N = mkN "bössa" ; -- bössa..nn.1
  bösshåll_1_N = mkN "bösshåll" neutrum  ; -- bösshåll..nn.1
  bössinsamling_1_N = mkN "bössinsamling" ; -- bössinsamling..nn.1
  bösta_1_V = mkV "böstar" ; -- bösta..vb.1
  böstande_1_N = mkN "böstande" ; -- böstande..nn.1
  böta_1_V = mkV "bötar" ; -- böta..vb.1
  bötande_1_N = mkN "bötande" ; -- bötande..nn.1
  bötesbelopp_1_N = mkN "bötesbelopp" neutrum  ; -- bötesbelopp..nn.1
  bötesstraff_1_N = mkN "bötesstraff" neutrum  ; -- bötesstraff..nn.1
  bötessumma_1_N = mkN "bötessumma" ; -- bötessumma..nn.1
  bötfälla_1_V = mkV "bötfäller" ; -- bötfälla..vb.1
  bötfällande_1_N = mkN "bötfällande" ; -- bötfällande..nn.1
  bövel_1_N = mkN "bövel" ; -- bövel..nn.1
  cab_1_N = mkN "cab" ; -- cab..nn.1
  cabb_1_N = mkN "cabb" ; -- cabb..nn.1
  cabotage_1_N = mkN "cabotage" ; -- cabotage..nn.1
  cabriolet_1_N = mkN "cabriolet" "cabrioleter" ; -- cabriolet..nn.1
  caddie_1_N = mkN "caddie" "caddier" ; -- caddie..nn.1
  cafe_1_N = mkN "cafe" "cafeet" "cafeer" "cafeerna" ; -- cafe..nn.1
  cafeteria_1_N = mkN "cafeteria" ; -- cafeteria..nn.1
  café_1_N = mkN "café" "caféet" "caféer" "caféerna" ; -- café..nn.1
  cafébord_1_N = mkN "cafébord" neutrum  ; -- cafébord..nn.1
  caldera_1_N = mkN "caldera" ; -- caldera..nn.1
  californium_1_N = mkN "californium" neutrum  ; -- californium..nn.1
  callcenter_1_N = mkN "callcenter" neutrum  ; -- callcenter..nn.1
  callgirl_1_N = mkN "callgirl" "callgirlen" "callgirls" "callgirlsarna" ; -- callgirl..nn.1
  calmettevaccinering_1_N = mkN "calmettevaccinering" ; -- calmettevaccinering..nn.1
  calvados_1_N = mkN "calvados" "calvadoser" ; -- calvados..nn.1
  calypso_1_N = mkN "calypso" ; -- calypso..nn.1
  calzone_1_N = mkN "calzone" utrum  ; -- calzone..nn.1
  camembert_1_N = mkN "camembert" ; -- camembert..nn.1
  camorra_1_N = mkN "camorra" ; -- camorra..nn.1
  camouflage_1_N = mkN "camouflage" "camouflaget" "camouflage" "camouflagen" ; -- camouflage..nn.1
  camouflera_1_V = mkV "camouflerar" ; -- camouflera..vb.1
  camouflerande_1_N = mkN "camouflerande" ; -- camouflerande..nn.1
  camouflerbar_1_A = mkA "camouflerbar" ; -- camouflerbar..av.1
  camouflerbarhet_1_N = mkN "camouflerbarhet" ; -- camouflerbarhet..nn.1
  camouflering_1_N = mkN "camouflering" ; -- camouflering..nn.1
  camp_1_A = mkA "camp" "camp" ; -- camp..av.1
  campa_1_V = mkV "campar" ; -- campa..vb.1
  campande_1_N = mkN "campande" ; -- campande..nn.1
  campare_1_N = mkN "campare" utrum  ; -- campare..nn.1
  camphet_1_N = mkN "camphet" ; -- camphet..nn.1
  camping_1_N = mkN "camping" ; -- camping..nn.1
  campingkök_1_N = mkN "campingkök" neutrum  ; -- campingkök..nn.1
  campinglampa_1_N = mkN "campinglampa" ; -- campinglampa..nn.1
  campingplats_1_N = mkN "campingplats" "campingplatser" ; -- campingplats..nn.1
  campingstuga_1_N = mkN "campingstuga" ; -- campingstuga..nn.1
  campus_1_N = mkN "campus" neutrum  ; -- campus..nn.1
  canasta_1_N = mkN "canasta" ; -- canasta..nn.1
  cancan_1_N = mkN "cancan" ; -- cancan..nn.1
  cancer_1_N = mkN "cancer" ; -- cancer..nn.1
  cancerbehandling_1_N = mkN "cancerbehandling" ; -- cancerbehandling..nn.1
  cancerbekämpning_1_N = mkN "cancerbekämpning" ; -- cancerbekämpning..nn.1
  cancerfall_1_N = mkN "cancerfall" neutrum  ; -- cancerfall..nn.1
  cancerfara_1_N = mkN "cancerfara" ; -- cancerfara..nn.1
  cancerform_1_N = mkN "cancerform" "cancerformer" ; -- cancerform..nn.1
  cancerforskare_1_N = mkN "cancerforskare" utrum  ; -- cancerforskare..nn.1
  cancerforskning_1_N = mkN "cancerforskning" ; -- cancerforskning..nn.1
  cancerframkallande_1_A = mkA "cancerframkallande" ; -- cancerframkallande..av.1
  cancerogen_1_A = mkA "cancerogen" "cancerogent" ; -- cancerogen..av.1
  cancerogen_1_N = mkN "cancerogen" "cancerogener" ; -- cancerogen..nn.1
  cancerrisk_1_N = mkN "cancerrisk" "cancerrisker" ; -- cancerrisk..nn.1
  cancersjuk_1_A = mkA "cancersjuk" ; -- cancersjuk..av.1
  cancerspridning_1_N = mkN "cancerspridning" ; -- cancerspridning..nn.1
  cancersvulst_1_N = mkN "cancersvulst" "cancersvulster" ; -- cancersvulst..nn.1
  cancertumör_1_N = mkN "cancertumör" "cancertumörer" ; -- cancertumör..nn.1
  canceruppföljning_1_N = mkN "canceruppföljning" ; -- canceruppföljning..nn.1
  candela_1_N = mkN "candela" "candelan" "candela" "candelana" ; -- candela..nn.1
  cannabis_1_N = mkN "cannabis" ; -- cannabis..nn.1
  cannabisodling_1_N = mkN "cannabisodling" ; -- cannabisodling..nn.1
  cannabisplanta_1_N = mkN "cannabisplanta" ; -- cannabisplanta..nn.1
  canossavandring_1_N = mkN "canossavandring" ; -- canossavandring..nn.1
  cantilena_1_N = mkN "cantilena" ; -- cantilena..nn.1
  cape_1_N = mkN "cape" "caper" ; -- cape..nn.1
  cappuccino_1_N = mkN "cappuccino" "cappuccinon" "cappuccino" "cappuccinona" ; -- cappuccino..nn.1
  cappuccinokopp_1_N = mkN "cappuccinokopp" ; -- cappuccinokopp..nn.1
  carambole_1_N = mkN "carambole" utrum  ; -- carambole..nn.1
  carcinogen_1_A = mkA "carcinogen" "carcinogent" ; -- carcinogen..av.1
  carcinogen_1_N = mkN "carcinogen" "carcinogener" ; -- carcinogen..nn.1
  cardigan_1_N = mkN "cardigan" "cardiganen" "cardigans" "cardigansarna" ; -- cardigan..nn.1
  carpa_1_V = mkV "carpar" ; -- carpa..vb.1
  cartesiansk_1_A = mkA "cartesiansk" ; -- cartesiansk..av.1
  casanova_1_N = mkN "casanova" ; -- casanova..nn.1
  cash_1_N = mkN "cash" neutrum  ; -- cash..nn.1
  cashew_1_N = mkN "cashew" "cashewn" "cashews" "cashewsen" ; -- cashew..nn.1
  cashewnöt_1_N = mkN "cashewnöt" "cashewnötter" ; -- cashewnöt..nn.1
  casino_1_N = mkN "casino" "casinot" "casinon" "casinona" ; -- casino..nn.1
  casting_1_N = mkN "casting" ; -- casting..nn.1
  catch_as_catch_can_1_N = mkN "catch-as-catch-can" ; -- catch-as-catch-can..nn.1
  catera_1_V = mkV "caterar" ; -- catera..vb.1
  caterande_1_N = mkN "caterande" ; -- caterande..nn.1
  catering_1_N = mkN "catering" ; -- catering..nn.1
  cateringbransch_1_N = mkN "cateringbransch" ; -- cateringbransch..nn.1
  caterpillar_1_N = mkN "caterpillar" "caterpillarn" "caterpillrar" "caterpillrarna" ; -- caterpillar..nn.1
  catgut_1_N = mkN "catgut" ; -- catgut..nn.1
  catwalk_1_N = mkN "catwalk" "catwalker" ; -- catwalk..nn.1
  catwalka_1_V = mkV "catwalkar" ; -- catwalka..vb.1
  catwalkande_1_N = mkN "catwalkande" ; -- catwalkande..nn.1
  cavatina_1_N = mkN "cavatina" ; -- cavatina..nn.1
  cd_rom_1_N = mkN "cd-rom" "cd-rommen" "cd-rom" "cd-rommen" ; -- cd-rom..nn.1
  cd_spelare_1_N = mkN "cd-spelare" utrum  ; -- cd-spelare..nn.1
  ceder_1_N = mkN "ceder" ; -- ceder..nn.1
  cedera_1_V = mkV "cederar" ; -- cedera..vb.1
  cederande_1_N = mkN "cederande" ; -- cederande..nn.1
  cederbar_1_A = mkA "cederbar" ; -- cederbar..av.1
  cederbarhet_1_N = mkN "cederbarhet" ; -- cederbarhet..nn.1
  cedering_1_N = mkN "cedering" ; -- cedering..nn.1
  cederskog_1_N = mkN "cederskog" ; -- cederskog..nn.1
  cedilj_1_N = mkN "cedilj" "cediljer" ; -- cedilj..nn.1
  cediljtecken_1_N = mkN "cediljtecken" "cediljtecknet" "cediljtecken" "cediljtecknen" ; -- cediljtecken..nn.1
  cedrat_1_N = mkN "cedrat" neutrum  ; -- cedrat..nn.1
  cedroolja_1_N = mkN "cedroolja" ; -- cedroolja..nn.1
  celeber_1_A = mkA "celeber" ; -- celeber..av.1
  celebrera_1_V = mkV "celebrerar" ; -- celebrera..vb.1
  celebrerande_1_N = mkN "celebrerande" ; -- celebrerande..nn.1
  celebrerbar_1_A = mkA "celebrerbar" ; -- celebrerbar..av.1
  celebrerbarhet_1_N = mkN "celebrerbarhet" ; -- celebrerbarhet..nn.1
  celebrering_1_N = mkN "celebrering" ; -- celebrering..nn.1
  celebritet_1_N = mkN "celebritet" "celebriteter" ; -- celebritet..nn.1
  celebritetsjournalistik_1_N = mkN "celebritetsjournalistik" ; -- celebritetsjournalistik..nn.1
  celest_1_A = mkA "celest" "celest" ; -- celest..av.1
  celesta_1_N = mkN "celesta" ; -- celesta..nn.1
  celibat_1_N = mkN "celibat" neutrum  ; -- celibat..nn.1
  celibatliv_1_N = mkN "celibatliv" neutrum  ; -- celibatliv..nn.1
  celibatlöfte_1_N = mkN "celibatlöfte" ; -- celibatlöfte..nn.1
  cell_1_N = mkN "cell" "celler" ; -- cell..nn.1
  cella_1_N = mkN "cella" ; -- cella..nn.1
  cellandning_1_N = mkN "cellandning" ; -- cellandning..nn.1
  cellbildning_1_N = mkN "cellbildning" ; -- cellbildning..nn.1
  cellbiologi_1_N = mkN "cellbiologi" ; -- cellbiologi..nn.1
  celldelning_1_N = mkN "celldelning" ; -- celldelning..nn.1
  cellfängelse_1_N = mkN "cellfängelse" "cellfängelset" "cellfängelser" "cellfängelserna" ; -- cellfängelse..nn.1
  cellgift_1_N = mkN "cellgift" "cellgiftet" "cellgifter" "cellgifterna" ; -- cellgift..nn.1
  cellgiftsbehandling_1_N = mkN "cellgiftsbehandling" ; -- cellgiftsbehandling..nn.1
  cellgranne_1_N = mkN "cellgranne" utrum  ; -- cellgranne..nn.1
  cellini_1_N = mkN "cellini" ; -- cellini..nn.1
  cellist_1_N = mkN "cellist" "cellister" ; -- cellist..nn.1
  cellkamrat_1_N = mkN "cellkamrat" "cellkamrater" ; -- cellkamrat..nn.1
  cellkärna_1_N = mkN "cellkärna" ; -- cellkärna..nn.1
  cellmembran_1_N = mkN "cellmembran" neutrum  ; -- cellmembran..nn.1
  cello_1_N = mkN "cello" "cellon" "celli" "cellorna" ; -- cello..nn.1
  cellodling_1_N = mkN "cellodling" ; -- cellodling..nn.1
  cellofan_1_N = mkN "cellofan" ; -- cellofan..nn.1
  cellplasma_1_N = mkN "cellplasma" "cellplasman" "cellplasmer" "cellplasmerna" ; -- cellplasma..nn.1
  cellprov_1_N = mkN "cellprov" neutrum  ; -- cellprov..nn.1
  cellsjok_1_N = mkN "cellsjok" neutrum  ; -- cellsjok..nn.1
  cellskikt_1_N = mkN "cellskikt" neutrum  ; -- cellskikt..nn.1
  cellskräck_1_N = mkN "cellskräck" ; -- cellskräck..nn.1
  cellspänning_1_N = mkN "cellspänning" ; -- cellspänning..nn.1
  cellstoff_1_N = mkN "cellstoff" ; -- cellstoff..nn.1
  cellstraff_1_N = mkN "cellstraff" neutrum  ; -- cellstraff..nn.1
  cellstruktur_1_N = mkN "cellstruktur" "cellstrukturer" ; -- cellstruktur..nn.1
  cellsubstans_1_N = mkN "cellsubstans" "cellsubstanser" ; -- cellsubstans..nn.1
  cellterapi_1_N = mkN "cellterapi" ; -- cellterapi..nn.1
  celltråd_1_N = mkN "celltråd" ; -- celltråd..nn.1
  celltyp_1_N = mkN "celltyp" "celltyper" ; -- celltyp..nn.1
  cellulas_1_N = mkN "cellulas" ; -- cellulas..nn.1
  celluloid_1_N = mkN "celluloid" ; -- celluloid..nn.1
  cellulosa_1_N = mkN "cellulosa" ; -- cellulosa..nn.1
  cellulosaetanol_1_N = mkN "cellulosaetanol" "cellulosaetanoler" ; -- cellulosaetanol..nn.1
  cellulosafabrik_1_N = mkN "cellulosafabrik" "cellulosafabriker" ; -- cellulosafabrik..nn.1
  cellulosaförtunning_1_N = mkN "cellulosaförtunning" ; -- cellulosaförtunning..nn.1
  cellulosaindustri_1_N = mkN "cellulosaindustri" "cellulosaindustrier" ; -- cellulosaindustri..nn.1
  cellulosalack_1_N = mkN "cellulosalack" neutrum  ; -- cellulosalack..nn.1
  cellulosamolekyl_1_N = mkN "cellulosamolekyl" "cellulosamolekyler" ; -- cellulosamolekyl..nn.1
  cellulosanitrat_1_N = mkN "cellulosanitrat" neutrum  ; -- cellulosanitrat..nn.1
  cellulosaplast_1_N = mkN "cellulosaplast" "cellulosaplaster" ; -- cellulosaplast..nn.1
  cellulosavadd_1_N = mkN "cellulosavadd" ; -- cellulosavadd..nn.1
  cellulär_1_A = mkA "cellulär" ; -- cellulär..av.1
  cellvägg_1_N = mkN "cellvägg" ; -- cellvägg..nn.1
  cellvävnad_1_N = mkN "cellvävnad" "cellvävnader" ; -- cellvävnad..nn.1
  celsiusgrad_1_N = mkN "celsiusgrad" "celsiusgrader" ; -- celsiusgrad..nn.1
  celsiusskala_1_N = mkN "celsiusskala" ; -- celsiusskala..nn.1
  celsiustermometer_1_N = mkN "celsiustermometer" ; -- celsiustermometer..nn.1
  celt_1_N = mkN "celt" "celter" ; -- celt..nn.1
  cembalist_1_N = mkN "cembalist" "cembalister" ; -- cembalist..nn.1
  cembalo_1_N = mkN "cembalo" "cembalon" "cembali" "cembalorna" ; -- cembalo..nn.1
  cembalobyggare_1_N = mkN "cembalobyggare" utrum  ; -- cembalobyggare..nn.1
  cembalobygge_1_N = mkN "cembalobygge" ; -- cembalobygge..nn.1
  cembalotillverkning_1_N = mkN "cembalotillverkning" ; -- cembalotillverkning..nn.1
  cement_1_N = mkN "cement" ; -- cement..nn.1
  cementa_1_V = mkV "cementar" ; -- cementa..vb.1
  cementande_1_N = mkN "cementande" ; -- cementande..nn.1
  cementblandare_1_N = mkN "cementblandare" utrum  ; -- cementblandare..nn.1
  cementera_1_V = mkV "cementerar" ; -- cementera..vb.1
  cementerande_1_N = mkN "cementerande" ; -- cementerande..nn.1
  cementerbar_1_A = mkA "cementerbar" ; -- cementerbar..av.1
  cementerbarhet_1_N = mkN "cementerbarhet" ; -- cementerbarhet..nn.1
  cementering_1_N = mkN "cementering" ; -- cementering..nn.1
  cementfärg_1_N = mkN "cementfärg" "cementfärger" ; -- cementfärg..nn.1
  cementrör_1_N = mkN "cementrör" neutrum  ; -- cementrör..nn.1
  cenakel_1_N = mkN "cenakel" neutrum  ; -- cenakel..nn.1
  cendré_1_A = mkA "cendré" ; -- cendré..av.1
  cendréfärgad_1_A = mkA "cendréfärgad" ; -- cendréfärgad..av.1
  censor_1_N = mkN "censor" "censorer" ; -- censor..nn.1
  censur_1_N = mkN "censur" ; -- censur..nn.1
  censurera_1_V = mkV "censurerar" ; -- censurera..vb.1
  censurerande_1_N = mkN "censurerande" ; -- censurerande..nn.1
  censurerbar_1_A = mkA "censurerbar" ; -- censurerbar..av.1
  censurerbarhet_1_N = mkN "censurerbarhet" ; -- censurerbarhet..nn.1
  censurering_1_N = mkN "censurering" ; -- censurering..nn.1
  censurfrihet_1_N = mkN "censurfrihet" ; -- censurfrihet..nn.1
  censurförordning_1_N = mkN "censurförordning" ; -- censurförordning..nn.1
  censurhinder_1_N = mkN "censurhinder" neutrum  ; -- censurhinder..nn.1
  censurtvång_1_N = mkN "censurtvång" neutrum  ; -- censurtvång..nn.1
  census_1_N = mkN "census" ; -- census..nn.1
  cent_1_N = mkN "cent" "centen" "cent" "centen" ; -- cent..nn.1
  centaur_1_N = mkN "centaur" "centaurer" ; -- centaur..nn.1
  centaurgestalt_1_N = mkN "centaurgestalt" "centaurgestalter" ; -- centaurgestalt..nn.1
  center_1_N = mkN "center" ; -- center..nn.1
  center_2_N = mkN "center" "centret" "centrer" "centrerna" ; -- center..nn.2
  centerback_1_N = mkN "centerback" ; -- centerback..nn.1
  centerbord_1_N = mkN "centerbord" neutrum  ; -- centerbord..nn.1
  centercourt_1_N = mkN "centercourt" ; -- centercourt..nn.1
  centerforward_1_N = mkN "centerforward" ; -- centerforward..nn.1
  centerhalv_1_N = mkN "centerhalv" ; -- centerhalv..nn.1
  centerism_1_N = mkN "centerism" "centerismer" ; -- centerism..nn.1
  centerledare_1_N = mkN "centerledare" utrum  ; -- centerledare..nn.1
  centerparti_1_N = mkN "centerparti" "centerpartiet" "centerpartier" "centerpartierna" ; -- centerparti..nn.1
  centerpartist_1_N = mkN "centerpartist" "centerpartister" ; -- centerpartist..nn.1
  centerpartistisk_1_A = mkA "centerpartistisk" ; -- centerpartistisk..av.1
  centerprofil_1_N = mkN "centerprofil" "centerprofiler" ; -- centerprofil..nn.1
  centigram_1_N = mkN "centigram" "centigrammet" "centigram" "centigrammen" ; -- centigram..nn.1
  centiliter_1_N = mkN "centiliter" "centilitern" "centiliter" "centiliterna" ; -- centiliter..nn.1
  centilong_1_N = mkN "centilong" "centilongen" "centilong" "centilongen" ; -- centilong..nn.1
  centimeter_1_N = mkN "centimeter" ; -- centimeter..nn.1
  centimeterlång_1_A = mkA "centimeterlång" ; -- centimeterlång..av.1
  centimeterskala_1_N = mkN "centimeterskala" ; -- centimeterskala..nn.1
  centimeterstor_1_A = mkA "centimeterstor" ; -- centimeterstor..av.1
  centimetertjock_1_A = mkA "centimetertjock" ; -- centimetertjock..av.1
  centner_1_N = mkN "centner" "centnern" "centner" "centnerna" ; -- centner..nn.1
  centra_1_V = mkV "centrar" ; -- centra..vb.1
  central_1_A = mkA "central" ; -- central..av.1
  central_1_N = mkN "central" "centraler" ; -- central..nn.1
  centralafrikan_1_N = mkN "centralafrikan" "centralafrikaner" ; -- centralafrikan..nn.1
  centralafrikansk_1_A = mkA "centralafrikansk" ; -- centralafrikansk..av.1
  centralafrikanska_1_N = mkN "centralafrikanska" ; -- centralafrikanska..nn.1
  centralamerikan_1_N = mkN "centralamerikan" "centralamerikaner" ; -- centralamerikan..nn.1
  centralamerikanare_1_N = mkN "centralamerikanare" utrum  ; -- centralamerikanare..nn.1
  centralamerikansk_1_A = mkA "centralamerikansk" ; -- centralamerikansk..av.1
  centralanstalt_1_N = mkN "centralanstalt" "centralanstalter" ; -- centralanstalt..nn.1
  centralantenn_1_N = mkN "centralantenn" "centralantenner" ; -- centralantenn..nn.1
  centralasiatisk_1_A = mkA "centralasiatisk" ; -- centralasiatisk..av.1
  centralbank_1_N = mkN "centralbank" "centralbanker" ; -- centralbank..nn.1
  centralbankschef_1_N = mkN "centralbankschef" "centralbankschefer" ; -- centralbankschef..nn.1
  centralbyggnad_1_N = mkN "centralbyggnad" "centralbyggnader" ; -- centralbyggnad..nn.1
  centralbyrå_1_N = mkN "centralbyrå" "centralbyråer" ; -- centralbyrå..nn.1
  centraldirigerad_1_A = mkA "centraldirigerad" ; -- centraldirigerad..av.1
  centralenhet_1_N = mkN "centralenhet" "centralenheter" ; -- centralenhet..nn.1
  centraleuropeisk_1_A = mkA "centraleuropeisk" ; -- centraleuropeisk..av.1
  centralfigur_1_N = mkN "centralfigur" "centralfigurer" ; -- centralfigur..nn.1
  centralförbund_1_N = mkN "centralförbund" neutrum  ; -- centralförbund..nn.1
  centralförsvar_1_N = mkN "centralförsvar" neutrum  ; -- centralförsvar..nn.1
  centralförvaltning_1_N = mkN "centralförvaltning" ; -- centralförvaltning..nn.1
  centralgestalt_1_N = mkN "centralgestalt" "centralgestalter" ; -- centralgestalt..nn.1
  centralisation_1_N = mkN "centralisation" ; -- centralisation..nn.1
  centralisera_1_V = mkV "centraliserar" ; -- centralisera..vb.1
  centraliserande_1_N = mkN "centraliserande" ; -- centraliserande..nn.1
  centraliserbar_1_A = mkA "centraliserbar" ; -- centraliserbar..av.1
  centraliserbarhet_1_N = mkN "centraliserbarhet" ; -- centraliserbarhet..nn.1
  centralisering_1_N = mkN "centralisering" ; -- centralisering..nn.1
  centralism_1_N = mkN "centralism" "centralismer" ; -- centralism..nn.1
  centralistisk_1_A = mkA "centralistisk" ; -- centralistisk..av.1
  centralkommitté_1_N = mkN "centralkommitté" "centralkommittéer" ; -- centralkommitté..nn.1
  centralkontor_1_N = mkN "centralkontor" neutrum  ; -- centralkontor..nn.1
  centralkyrka_1_N = mkN "centralkyrka" ; -- centralkyrka..nn.1
  centrallasarett_1_N = mkN "centrallasarett" neutrum  ; -- centrallasarett..nn.1
  centrallyrik_1_N = mkN "centrallyrik" ; -- centrallyrik..nn.1
  centrallyrisk_1_A = mkA "centrallyrisk" ; -- centrallyrisk..av.1
  centralmakt_1_N = mkN "centralmakt" "centralmakter" ; -- centralmakt..nn.1
  centralmått_1_N = mkN "centralmått" neutrum  ; -- centralmått..nn.1
  centralnämnd_1_N = mkN "centralnämnd" "centralnämnder" ; -- centralnämnd..nn.1
  centralorganisation_1_N = mkN "centralorganisation" ; -- centralorganisation..nn.1
  centralort_1_N = mkN "centralort" "centralorter" ; -- centralort..nn.1
  centralpunkt_1_N = mkN "centralpunkt" "centralpunkter" ; -- centralpunkt..nn.1
  centralradio_1_N = mkN "centralradio" ; -- centralradio..nn.1
  centralregering_1_N = mkN "centralregering" ; -- centralregering..nn.1
  centralrörelse_1_N = mkN "centralrörelse" "centralrörelser" ; -- centralrörelse..nn.1
  centralskola_1_N = mkN "centralskola" ; -- centralskola..nn.1
  centralstation_1_N = mkN "centralstation" ; -- centralstation..nn.1
  centralstimulantia_1_N = mkN "centralstimulantia" "centralstimulantian" "centralstimulantia" "centralstimulantiana" ; -- centralstimulantia..nn.1
  centralstimulerande_1_A = mkA "centralstimulerande" ; -- centralstimulerande..av.1
  centralstyrd_1_A = mkA "centralstyrd" "centralstyrt" ; -- centralstyrd..av.1
  centralstyrelse_1_N = mkN "centralstyrelse" "centralstyrelser" ; -- centralstyrelse..nn.1
  centralvärme_1_N = mkN "centralvärme" utrum  ; -- centralvärme..nn.1
  centrande_1_N = mkN "centrande" ; -- centrande..nn.1
  centrecourt_1_N = mkN "centrecourt" ; -- centrecourt..nn.1
  centrera_1_V = mkV "centrerar" ; -- centrera..vb.1
  centrerande_1_N = mkN "centrerande" ; -- centrerande..nn.1
  centrerbar_1_A = mkA "centrerbar" ; -- centrerbar..av.1
  centrerbarhet_1_N = mkN "centrerbarhet" ; -- centrerbarhet..nn.1
  centrering_1_N = mkN "centrering" ; -- centrering..nn.1
  centrifug_1_N = mkN "centrifug" "centrifuger" ; -- centrifug..nn.1
  centrifugal_1_A = mkA "centrifugal" ; -- centrifugal..av.1
  centrifugalkraft_1_N = mkN "centrifugalkraft" ; -- centrifugalkraft..nn.1
  centrifugalpump_1_N = mkN "centrifugalpump" ; -- centrifugalpump..nn.1
  centrifugera_1_V = mkV "centrifugerar" ; -- centrifugera..vb.1
  centrifugerande_1_N = mkN "centrifugerande" ; -- centrifugerande..nn.1
  centrifugerbar_1_A = mkA "centrifugerbar" ; -- centrifugerbar..av.1
  centrifugerbarhet_1_N = mkN "centrifugerbarhet" ; -- centrifugerbarhet..nn.1
  centrifugering_1_N = mkN "centrifugering" ; -- centrifugering..nn.1
  centripetal_1_A = mkA "centripetal" ; -- centripetal..av.1
  centripetalkraft_1_N = mkN "centripetalkraft" ; -- centripetalkraft..nn.1
  centrisk_1_A = mkA "centrisk" ; -- centrisk..av.1
  centrum_1_N = mkN "centrum" neutrum  ; -- centrum..nn.1
  centumspråk_1_N = mkN "centumspråk" neutrum  ; -- centumspråk..nn.1
  centurion_1_N = mkN "centurion" ; -- centurion..nn.1
  cepe_1_A = mkA "cepe" ; -- cepe..av.1
  cerat_1_N = mkN "cerat" neutrum  ; -- cerat..nn.1
  cerebral_1_A = mkA "cerebral" ; -- cerebral..av.1
  cerebrospinal_1_A = mkA "cerebrospinal" ; -- cerebrospinal..av.1
  cerebrospinalvätska_1_N = mkN "cerebrospinalvätska" ; -- cerebrospinalvätska..nn.1
  ceremoni_1_N = mkN "ceremoni" "ceremonier" ; -- ceremoni..nn.1
  ceremoniel_1_N = mkN "ceremoniel" "ceremonielet" "ceremoniel" "ceremonielen" ; -- ceremoniel..nn.1
  ceremoniell_1_A = mkA "ceremoniell" ; -- ceremoniell..av.1
  ceremonimästare_1_N = mkN "ceremonimästare" utrum  ; -- ceremonimästare..nn.1
  ceremoniös_1_A = mkA "ceremoniös" ; -- ceremoniös..av.1
  cerise_1_A = mkA "cerise" ; -- cerise..av.1
  cerise_1_N = mkN "cerise" "ceriser" ; -- cerise..nn.1
  cerisefärgad_1_A = mkA "cerisefärgad" ; -- cerisefärgad..av.1
  cerium_1_N = mkN "cerium" neutrum  ; -- cerium..nn.1
  cernera_1_V = mkV "cernerar" ; -- cernera..vb.1
  cernerande_1_N = mkN "cernerande" ; -- cernerande..nn.1
  cernerbar_1_A = mkA "cernerbar" ; -- cernerbar..av.1
  cernerbarhet_1_N = mkN "cernerbarhet" ; -- cernerbarhet..nn.1
  cernering_1_N = mkN "cernering" ; -- cernering..nn.1
  cert_1_N = mkN "cert" "certer" ; -- cert..nn.1
  certeparti_1_N = mkN "certeparti" "certepartiet" "certepartier" "certepartierna" ; -- certeparti..nn.1
  certifiera_1_V = mkV "certifierar" ; -- certifiera..vb.1
  certifierande_1_N = mkN "certifierande" ; -- certifierande..nn.1
  certifiering_1_N = mkN "certifiering" ; -- certifiering..nn.1
  certifikat_1_N = mkN "certifikat" neutrum  ; -- certifikat..nn.1
  cervelatkorv_1_N = mkN "cervelatkorv" ; -- cervelatkorv..nn.1
  cesarisk_1_A = mkA "cesarisk" ; -- cesarisk..av.1
  cesarism_1_N = mkN "cesarism" "cesarismer" ; -- cesarism..nn.1
  cesium_1_N = mkN "cesium" neutrum  ; -- cesium..nn.1
  cession_1_N = mkN "cession" ; -- cession..nn.1
  cesur_1_N = mkN "cesur" "cesurer" ; -- cesur..nn.1
  cha_cha_1_N = mkN "cha-cha" ; -- cha-cha..nn.1
  chagrin_1_N = mkN "chagrin" ; -- chagrin..nn.1
  chagräng_1_N = mkN "chagräng" ; -- chagräng..nn.1
  chalmersk_1_A = mkA "chalmersk" ; -- chalmersk..av.1
  chamotte_1_N = mkN "chamotte" utrum  ; -- chamotte..nn.1
  champagne_1_N = mkN "champagne" "champagner" ; -- champagne..nn.1
  champagnebaksmälla_1_N = mkN "champagnebaksmälla" ; -- champagnebaksmälla..nn.1
  champagnebärgning_1_N = mkN "champagnebärgning" ; -- champagnebärgning..nn.1
  champagneflaska_1_N = mkN "champagneflaska" ; -- champagneflaska..nn.1
  champagneglas_1_N = mkN "champagneglas" neutrum  ; -- champagneglas..nn.1
  champagnekork_1_N = mkN "champagnekork" ; -- champagnekork..nn.1
  champagnesabel_1_N = mkN "champagnesabel" ; -- champagnesabel..nn.1
  champagnesprutande_1_A = mkA "champagnesprutande" ; -- champagnesprutande..av.1
  champagnesprutande_1_N = mkN "champagnesprutande" ; -- champagnesprutande..nn.1
  champagnevaskare_1_N = mkN "champagnevaskare" utrum  ; -- champagnevaskare..nn.1
  champagnevisp_1_N = mkN "champagnevisp" ; -- champagnevisp..nn.1
  champinjon_1_N = mkN "champinjon" "champinjoner" ; -- champinjon..nn.1
  champinjonbädd_1_N = mkN "champinjonbädd" ; -- champinjonbädd..nn.1
  champion_1_N = mkN "champion" "championen" "champions" "championsarna" ; -- champion..nn.1
  championat_1_N = mkN "championat" neutrum  ; -- championat..nn.1
  changemang_1_N = mkN "changemang" neutrum  ; -- changemang..nn.1
  changera_1_V = mkV "changerar" ; -- changera..vb.1
  changerande_1_N = mkN "changerande" ; -- changerande..nn.1
  changering_1_N = mkN "changering" ; -- changering..nn.1
  changsera_1_V = mkV "changserar" ; -- changsera..vb.1
  changserande_1_N = mkN "changserande" ; -- changserande..nn.1
  changsering_1_N = mkN "changsering" ; -- changsering..nn.1
  chans_1_N = mkN "chans" "chanser" ; -- chans..nn.1
  chansa_1_V = mkV "chansar" ; -- chansa..vb.1
  chansande_1_N = mkN "chansande" ; -- chansande..nn.1
  chansartad_1_A = mkA "chansartad" ; -- chansartad..av.1
  chansera_1_V = mkV "chanserar" ; -- chansera..vb.1
  chanserande_1_N = mkN "chanserande" ; -- chanserande..nn.1
  chansering_1_N = mkN "chansering" ; -- chansering..nn.1
  chanslös_1_A = mkA "chanslös" ; -- chanslös..av.1
  chanslöshet_1_N = mkN "chanslöshet" ; -- chanslöshet..nn.1
  chansmässig_1_A = mkA "chansmässig" ; -- chansmässig..av.1
  chansning_1_N = mkN "chansning" ; -- chansning..nn.1
  chanson_1_N = mkN "chanson" "chansoner" ; -- chanson..nn.1
  chansonett_1_N = mkN "chansonett" "chansonetter" ; -- chansonett..nn.1
  chansonettsångerska_1_N = mkN "chansonettsångerska" ; -- chansonettsångerska..nn.1
  chanstagare_1_N = mkN "chanstagare" utrum  ; -- chanstagare..nn.1
  chanstagning_1_N = mkN "chanstagning" ; -- chanstagning..nn.1
  chapeau_claque_1_N = mkN "chapeau-claque" "chapeau-claquer" ; -- chapeau-claque..nn.1
  char_1_N = mkN "char" "charer" ; -- char..nn.1
  charabang_1_N = mkN "charabang" "charabanger" ; -- charabang..nn.1
  charad_1_N = mkN "charad" "charader" ; -- charad..nn.1
  charge_1_N = mkN "charge" "charger" ; -- charge..nn.1
  chargera_1_V = mkV "chargerar" ; -- chargera..vb.1
  chargerande_1_N = mkN "chargerande" ; -- chargerande..nn.1
  chargerbar_1_A = mkA "chargerbar" ; -- chargerbar..av.1
  chargerbarhet_1_N = mkN "chargerbarhet" ; -- chargerbarhet..nn.1
  chargering_1_N = mkN "chargering" ; -- chargering..nn.1
  chargé_d_affaires_1_N = mkN "chargé-d'affaires" "chargé-d'affaireser" ; -- chargé-d-affaires..nn.1
  chark_1_N = mkN "chark" ; -- chark..nn.1
  charkuteri_1_N = mkN "charkuteri" "charkuteriet" "charkuterier" "charkuterierna" ; -- charkuteri..nn.1
  charkuterist_1_N = mkN "charkuterist" "charkuterister" ; -- charkuterist..nn.1
  charkuterivara_1_N = mkN "charkuterivara" ; -- charkuterivara..nn.1
  charkvara_1_N = mkN "charkvara" ; -- charkvara..nn.1
  charlatan_1_N = mkN "charlatan" "charlataner" ; -- charlatan..nn.1
  charlataneri_1_N = mkN "charlataneri" "charlataneriet" "charlatanerier" "charlatanerierna" ; -- charlataneri..nn.1
  charlatanmässig_1_A = mkA "charlatanmässig" ; -- charlatanmässig..av.1
  charleston_1_N = mkN "charleston" ; -- charleston..nn.1
  charm_1_N = mkN "charm" ; -- charm..nn.1
  charma_1_V = mkV "charmar" ; -- charma..vb.1
  charmande_1_N = mkN "charmande" ; -- charmande..nn.1
  charmant_1_A = mkA "charmant" "charmant" ; -- charmant..av.1
  charmera_1_V = mkV "charmerar" ; -- charmera..vb.1
  charmerande_1_N = mkN "charmerande" ; -- charmerande..nn.1
  charmerbar_1_A = mkA "charmerbar" ; -- charmerbar..av.1
  charmerbarhet_1_N = mkN "charmerbarhet" ; -- charmerbarhet..nn.1
  charmering_1_N = mkN "charmering" ; -- charmering..nn.1
  charmeuse_1_N = mkN "charmeuse" utrum  ; -- charmeuse..nn.1
  charmfull_1_A = mkA "charmfull" ; -- charmfull..av.1
  charmfullhet_1_N = mkN "charmfullhet" ; -- charmfullhet..nn.1
  charmig_1_A = mkA "charmig" ; -- charmig..av.1
  charmighet_1_N = mkN "charmighet" ; -- charmighet..nn.1
  charmkurs_1_N = mkN "charmkurs" "charmkurser" ; -- charmkurs..nn.1
  charmkvark_1_N = mkN "charmkvark" ; -- charmkvark..nn.1
  charmlös_1_A = mkA "charmlös" ; -- charmlös..av.1
  charmlöshet_1_N = mkN "charmlöshet" "charmlösheter" ; -- charmlöshet..nn.1
  charmoffensiv_1_N = mkN "charmoffensiv" "charmoffensiver" ; -- charmoffensiv..nn.1
  charmtroll_1_N = mkN "charmtroll" neutrum  ; -- charmtroll..nn.1
  charmör_1_N = mkN "charmör" "charmörer" ; -- charmör..nn.1
  charner_1_N = mkN "charner" "charneret" "charner" "charneren" ; -- charner..nn.1
  charpi_1_N = mkN "charpi" neutrum  ; -- charpi..nn.1
  charta_1_N = mkN "charta" ; -- charta..nn.1
  charter_1_N = mkN "charter" ; -- charter..nn.1
  charterresa_1_N = mkN "charterresa" ; -- charterresa..nn.1
  charterturist_1_N = mkN "charterturist" "charterturister" ; -- charterturist..nn.1
  chartra_1_V = mkV "chartrar" ; -- chartra..vb.1
  chartrande_1_N = mkN "chartrande" ; -- chartrande..nn.1
  chartreuse_1_N = mkN "chartreuse" "chartreuser" ; -- chartreuse..nn.1
  chassi_1_N = mkN "chassi" "chassiet" "chassier" "chassierna" ; -- chassi..nn.1
  chassidism_1_N = mkN "chassidism" "chassidismer" ; -- chassidism..nn.1
  chassidistisk_1_A = mkA "chassidistisk" ; -- chassidistisk..av.1
  chat_1_N = mkN "chat" ; -- chat..nn.1
  chateaubriand_1_N = mkN "chateaubriand" "chateaubriander" ; -- chateaubriand..nn.1
  chatt_1_N = mkN "chatt" ; -- chatt..nn.1
  chatta_1_V = mkV "chattar" ; -- chatta..vb.1
  chattande_1_N = mkN "chattande" ; -- chattande..nn.1
  chattkonversation_1_N = mkN "chattkonversation" ; -- chattkonversation..nn.1
  chaufför_1_N = mkN "chaufför" "chaufförer" ; -- chaufför..nn.1
  chausserad_1_A = mkA "chausserad" ; -- chausserad..av.1
  chaussé_1_N = mkN "chaussé" "chausséer" ; -- chaussé..nn.1
  chauvinism_1_N = mkN "chauvinism" "chauvinismer" ; -- chauvinism..nn.1
  chauvinist_1_N = mkN "chauvinist" "chauvinister" ; -- chauvinist..nn.1
  chauvinistisk_1_A = mkA "chauvinistisk" ; -- chauvinistisk..av.1
  check_1_N = mkN "check" ; -- check..nn.1
  checka_1_V = mkV "checkar" ; -- checka..vb.1
  checkande_1_N = mkN "checkande" ; -- checkande..nn.1
  checkbok_1_N = mkN "checkbok" "checkböcker" ; -- checkbok..nn.1
  checkhäfte_1_N = mkN "checkhäfte" ; -- checkhäfte..nn.1
  checkkonto_1_N = mkN "checkkonto" "checkkontot" "checkkonton" "checkkontona" ; -- checkkonto..nn.1
  checkkredit_1_N = mkN "checkkredit" "checkkrediter" ; -- checkkredit..nn.1
  checklista_1_N = mkN "checklista" ; -- checklista..nn.1
  checklön_1_N = mkN "checklön" "checklöner" ; -- checklön..nn.1
  checkräkning_1_N = mkN "checkräkning" ; -- checkräkning..nn.1
  checksumma_1_N = mkN "checksumma" ; -- checksumma..nn.1
  cheddarost_1_N = mkN "cheddarost" ; -- cheddarost..nn.1
  chef_d_oeuvre_1_N = mkN "chef-d'oeuvre" ; -- chef-d-oeuvre..nn.1
  chef_1_N = mkN "chef" "chefer" ; -- chef..nn.1
  chefa_1_V = mkV "chefar" ; -- chefa..vb.1
  chefande_1_N = mkN "chefande" ; -- chefande..nn.1
  chefredaktör_1_N = mkN "chefredaktör" "chefredaktörer" ; -- chefredaktör..nn.1
  chefsegenskap_1_N = mkN "chefsegenskap" "chefsegenskaper" ; -- chefsegenskap..nn.1
  chefsekonom_1_N = mkN "chefsekonom" "chefsekonomer" ; -- chefsekonom..nn.1
  chefsfartyg_1_N = mkN "chefsfartyg" neutrum  ; -- chefsfartyg..nn.1
  chefsflytt_1_N = mkN "chefsflytt" ; -- chefsflytt..nn.1
  chefsideolog_1_N = mkN "chefsideolog" "chefsideologer" ; -- chefsideolog..nn.1
  chefsjobb_1_N = mkN "chefsjobb" neutrum  ; -- chefsjobb..nn.1
  chefskap_1_N = mkN "chefskap" neutrum  ; -- chefskap..nn.1
  chefskirurg_1_N = mkN "chefskirurg" "chefskirurger" ; -- chefskirurg..nn.1
  chefsmikrobiolog_1_N = mkN "chefsmikrobiolog" "chefsmikrobiologer" ; -- chefsmikrobiolog..nn.1
  chefsplats_1_N = mkN "chefsplats" "chefsplatser" ; -- chefsplats..nn.1
  chefsskap_1_N = mkN "chefsskap" neutrum  ; -- chefsskap..nn.1
  chefsställning_1_N = mkN "chefsställning" ; -- chefsställning..nn.1
  chefstjänsteman_1_N = mkN "chefstjänsteman" "chefstjänstemannen" "chefstjänstemän" "chefstjänstemännen" ; -- chefstjänsteman..nn.1
  chefsåklagare_1_N = mkN "chefsåklagare" utrum  ; -- chefsåklagare..nn.1
  chemis_1_N = mkN "chemis" "chemiser" ; -- chemis..nn.1
  chemisett_1_N = mkN "chemisett" "chemisetter" ; -- chemisett..nn.1
  cherimoya_1_N = mkN "cherimoya" ; -- cherimoya..nn.1
  chevaleresk_1_A = mkA "chevaleresk" ; -- chevaleresk..av.1
  chevelyr_1_N = mkN "chevelyr" "chevelyrer" ; -- chevelyr..nn.1
  cheviot_1_N = mkN "cheviot" "chevioter" ; -- cheviot..nn.1
  chevreau_1_N = mkN "chevreau" ; -- chevreau..nn.1
  chevrotera_1_V = mkV "chevroterar" ; -- chevrotera..vb.1
  chevroterande_1_N = mkN "chevroterande" ; -- chevroterande..nn.1
  chevroterbar_1_A = mkA "chevroterbar" ; -- chevroterbar..av.1
  chevroterbarhet_1_N = mkN "chevroterbarhet" ; -- chevroterbarhet..nn.1
  chevrotering_1_N = mkN "chevrotering" ; -- chevrotering..nn.1
  cheyenne_1_N = mkN "cheyenne" "cheyenner" ; -- cheyenne..nn.1
  chi_1_N = mkN "chi" neutrum  ; -- chi..nn.1
  chibbe_1_N = mkN "chibbe" utrum  ; -- chibbe..nn.1
  chic_1_A = mkA "chic" ; -- chic..av.1
  chichet_1_N = mkN "chichet" ; -- chichet..nn.1
  chiffer_1_N = mkN "chiffer" neutrum  ; -- chiffer..nn.1
  chiffernyckel_1_N = mkN "chiffernyckel" ; -- chiffernyckel..nn.1
  chifferskrift_1_N = mkN "chifferskrift" "chifferskrifter" ; -- chifferskrift..nn.1
  chiffong_1_N = mkN "chiffong" "chiffonger" ; -- chiffong..nn.1
  chiffonggarnering_1_N = mkN "chiffonggarnering" ; -- chiffonggarnering..nn.1
  chiffongklänning_1_N = mkN "chiffongklänning" ; -- chiffongklänning..nn.1
  chiffonjé_1_N = mkN "chiffonjé" "chiffonjéer" ; -- chiffonjé..nn.1
  chiffrera_1_V = mkV "chiffrerar" ; -- chiffrera..vb.1
  chiffrerande_1_N = mkN "chiffrerande" ; -- chiffrerande..nn.1
  chiffrerbar_1_A = mkA "chiffrerbar" ; -- chiffrerbar..av.1
  chiffrerbarhet_1_N = mkN "chiffrerbarhet" ; -- chiffrerbarhet..nn.1
  chiffrering_1_N = mkN "chiffrering" ; -- chiffrering..nn.1
  chikan_1_N = mkN "chikan" "chikaner" ; -- chikan..nn.1
  chikanera_1_V = mkV "chikanerar" ; -- chikanera..vb.1
  chikanerande_1_N = mkN "chikanerande" ; -- chikanerande..nn.1
  chikanerbar_1_A = mkA "chikanerbar" ; -- chikanerbar..av.1
  chikanerbarhet_1_N = mkN "chikanerbarhet" ; -- chikanerbarhet..nn.1
  chikanering_1_N = mkN "chikanering" ; -- chikanering..nn.1
  chilen_1_N = mkN "chilen" "chilener" ; -- chilen..nn.1
  chilenare_1_N = mkN "chilenare" utrum  ; -- chilenare..nn.1
  chilensk_1_A = mkA "chilensk" ; -- chilensk..av.1
  chilenska_1_N = mkN "chilenska" ; -- chilenska..nn.1
  chilesalpeter_1_N = mkN "chilesalpeter" ; -- chilesalpeter..nn.1
  chilisås_1_N = mkN "chilisås" ; -- chilisås..nn.1
  chilla_1_V = mkV "chillar" ; -- chilla..vb.1
  chillande_1_N = mkN "chillande" ; -- chillande..nn.1
  chimpa_1_V = mkV "chimpar" ; -- chimpa..vb.1
  chimpande_1_N = mkN "chimpande" ; -- chimpande..nn.1
  chimpans_1_N = mkN "chimpans" "chimpanser" ; -- chimpans..nn.1
  chimping_1_N = mkN "chimping" ; -- chimping..nn.1
  chimpning_1_N = mkN "chimpning" ; -- chimpning..nn.1
  chimär_1_N = mkN "chimär" "chimärer" ; -- chimär..nn.1
  chimärisk_1_A = mkA "chimärisk" ; -- chimärisk..av.1
  chinchilla_1_N = mkN "chinchilla" ; -- chinchilla..nn.1
  chinjong_1_N = mkN "chinjong" "chinjonger" ; -- chinjong..nn.1
  chintz_1_N = mkN "chintz" ; -- chintz..nn.1
  chip_1_N = mkN "chip" neutrum  ; -- chip..nn.1
  chips_1_N = mkN "chips" neutrum  ; -- chips..nn.1
  chipssug_1_N = mkN "chipssug" neutrum  ; -- chipssug..nn.1
  chirre_1_N = mkN "chirre" utrum  ; -- chirre..nn.1
  chock_1_N = mkN "chock" "chocker" ; -- chock..nn.1
  chocka_1_V = mkV "chockar" ; -- chocka..vb.1
  chockande_1_N = mkN "chockande" ; -- chockande..nn.1
  chockartad_1_A = mkA "chockartad" ; -- chockartad..av.1
  chockbehandla_1_V = mkV "chockbehandlar" ; -- chockbehandla..vb.1
  chockbehandlande_1_N = mkN "chockbehandlande" ; -- chockbehandlande..nn.1
  chockbehandling_1_N = mkN "chockbehandling" ; -- chockbehandling..nn.1
  chockbeskatta_1_V = mkV "chockbeskattar" ; -- chockbeskatta..vb.1
  chockbeskattande_1_N = mkN "chockbeskattande" ; -- chockbeskattande..nn.1
  chockbeskattning_1_N = mkN "chockbeskattning" ; -- chockbeskattning..nn.1
  chockbesked_1_N = mkN "chockbesked" neutrum  ; -- chockbesked..nn.1
  chockbild_1_N = mkN "chockbild" "chockbilder" ; -- chockbild..nn.1
  chockera_1_V = mkV "chockerar" ; -- chockera..vb.1
  chockerande_1_N = mkN "chockerande" ; -- chockerande..nn.1
  chockerbar_1_A = mkA "chockerbar" ; -- chockerbar..av.1
  chockerbarhet_1_N = mkN "chockerbarhet" ; -- chockerbarhet..nn.1
  chockering_1_N = mkN "chockering" ; -- chockering..nn.1
  chockfas_1_N = mkN "chockfas" "chockfaser" ; -- chockfas..nn.1
  chockhöja_1_V = mkV "chockhöja" "chockhöjde" "chockhöjt" ; -- chockhöja..vb.1
  chockhöjande_1_N = mkN "chockhöjande" ; -- chockhöjande..nn.1
  chockhöjning_1_N = mkN "chockhöjning" ; -- chockhöjning..nn.1
  chockreaktion_1_N = mkN "chockreaktion" ; -- chockreaktion..nn.1
  chockrosa_1_A = mkA "chockrosa" ; -- chockrosa..av.1
  chockterapi_1_N = mkN "chockterapi" "chockterapier" ; -- chockterapi..nn.1
  chocktillstånd_1_N = mkN "chocktillstånd" neutrum  ; -- chocktillstånd..nn.1
  chockvåg_1_N = mkN "chockvåg" "chockvågor" ; -- chockvåg..nn.1
  choka_1_V = mkV "chokar" ; -- choka..vb.1
  chokande_1_N = mkN "chokande" ; -- chokande..nn.1
  choke_1_N = mkN "choke" utrum  ; -- choke..nn.1
  choklad_1_N = mkN "choklad" "choklader" ; -- choklad..nn.1
  choklad_2_N = mkN "choklad" neutrum  ; -- choklad..nn.2
  chokladbit_1_N = mkN "chokladbit" ; -- chokladbit..nn.1
  chokladboll_1_N = mkN "chokladboll" ; -- chokladboll..nn.1
  chokladbrun_1_A = mkA "chokladbrun" ; -- chokladbrun..av.1
  chokladglass_1_N = mkN "chokladglass" ; -- chokladglass..nn.1
  chokladgodis_1_N = mkN "chokladgodis" neutrum  ; -- chokladgodis..nn.1
  chokladgodis_2_N = mkN "chokladgodis" ; -- chokladgodis..nn.2
  chokladkaka_1_N = mkN "chokladkaka" ; -- chokladkaka..nn.1
  chokladlins_1_N = mkN "chokladlins" "chokladlinser" ; -- chokladlins..nn.1
  chokladlycka_1_N = mkN "chokladlycka" ; -- chokladlycka..nn.1
  chokladpudding_1_N = mkN "chokladpudding" ; -- chokladpudding..nn.1
  chokladtårta_1_N = mkN "chokladtårta" ; -- chokladtårta..nn.1
  chorizo_stoppning_1_N = mkN "chorizo-stoppning" ; -- chorizo-stoppning..nn.1
  chorizo_1_N = mkN "chorizo" "chorizor" ; -- chorizo..nn.1
  chosefri_1_A = mkA "chosefri" "chosefritt" ; -- chosefri..av.1
  chosig_1_A = mkA "chosig" ; -- chosig..av.1
  chuck_1_N = mkN "chuck" ; -- chuck..nn.1
  cicero_1_N = mkN "cicero" ; -- cicero..nn.1
  ciceron_1_N = mkN "ciceron" "ciceroner" ; -- ciceron..nn.1
  cider_1_N = mkN "cider" ; -- cider..nn.1
  cig_1_N = mkN "cig" ; -- cig..nn.1
  cigarett_1_N = mkN "cigarett" "cigaretter" ; -- cigarett..nn.1
  cigarettautomat_1_N = mkN "cigarettautomat" "cigarettautomater" ; -- cigarettautomat..nn.1
  cigarettetui_1_N = mkN "cigarettetui" "cigarettetuit" "cigarettetuin" "cigarettetuien" ; -- cigarettetui..nn.1
  cigarettfimp_1_N = mkN "cigarettfimp" ; -- cigarettfimp..nn.1
  cigarettförsäljning_1_N = mkN "cigarettförsäljning" ; -- cigarettförsäljning..nn.1
  cigarettlimpa_1_N = mkN "cigarettlimpa" ; -- cigarettlimpa..nn.1
  cigarettpaket_1_N = mkN "cigarettpaket" neutrum  ; -- cigarettpaket..nn.1
  cigarettrök_1_N = mkN "cigarettrök" ; -- cigarettrök..nn.1
  cigarettrökning_1_N = mkN "cigarettrökning" ; -- cigarettrökning..nn.1
  cigarettuttag_1_N = mkN "cigarettuttag" neutrum  ; -- cigarettuttag..nn.1
  cigarettändare_1_N = mkN "cigarettändare" utrum  ; -- cigarettändare..nn.1
  cigarettändarkontakt_1_N = mkN "cigarettändarkontakt" "cigarettändarkontakter" ; -- cigarettändarkontakt..nn.1
  cigarettändaruttag_1_N = mkN "cigarettändaruttag" neutrum  ; -- cigarettändaruttag..nn.1
  cigarill_1_N = mkN "cigarill" "cigariller" ; -- cigarill..nn.1
  cigarr_1_N = mkN "cigarr" "cigarrer" ; -- cigarr..nn.1
  cigarrcigarett_1_N = mkN "cigarrcigarett" "cigarrcigaretter" ; -- cigarrcigarett..nn.1
  cigarrcigarrett_1_N = mkN "cigarrcigarrett" "cigarrcigarretter" ; -- cigarrcigarrett..nn.1
  cigarrett_1_N = mkN "cigarrett" "cigarretter" ; -- cigarrett..nn.1
  cigarrettfimp_1_N = mkN "cigarrettfimp" ; -- cigarrettfimp..nn.1
  cigarrettlimpa_1_N = mkN "cigarrettlimpa" ; -- cigarrettlimpa..nn.1
  cigarrettobak_1_N = mkN "cigarrettobak" ; -- cigarrettobak..nn.1
  cigarrettpaket_1_N = mkN "cigarrettpaket" neutrum  ; -- cigarrettpaket..nn.1
  cigarrettrök_1_N = mkN "cigarrettrök" ; -- cigarrettrök..nn.1
  cigarrettuttag_1_N = mkN "cigarrettuttag" neutrum  ; -- cigarrettuttag..nn.1
  cigarrettändare_1_N = mkN "cigarrettändare" utrum  ; -- cigarrettändare..nn.1
  cigarrettändarkontakt_1_N = mkN "cigarrettändarkontakt" "cigarrettändarkontakter" ; -- cigarrettändarkontakt..nn.1
  cigarrettändaruttag_1_N = mkN "cigarrettändaruttag" neutrum  ; -- cigarrettändaruttag..nn.1
  cigarrill_1_N = mkN "cigarrill" "cigarriller" ; -- cigarrill..nn.1
  cigarrlåda_1_N = mkN "cigarrlåda" ; -- cigarrlåda..nn.1
  cigarrsnopp_1_N = mkN "cigarrsnopp" ; -- cigarrsnopp..nn.1
  cigarrsnoppare_1_N = mkN "cigarrsnoppare" utrum  ; -- cigarrsnoppare..nn.1
  cigarrtändare_1_N = mkN "cigarrtändare" utrum  ; -- cigarrtändare..nn.1
  cigg_1_N = mkN "cigg" ; -- cigg..nn.1
  cikada_1_N = mkN "cikada" ; -- cikada..nn.1
  ciklid_1_N = mkN "ciklid" "ciklider" ; -- ciklid..nn.1
  ciklidfisk_1_N = mkN "ciklidfisk" ; -- ciklidfisk..nn.1
  ciklidfiskfauna_1_N = mkN "ciklidfiskfauna" ; -- ciklidfiskfauna..nn.1
  cikoria_1_N = mkN "cikoria" ; -- cikoria..nn.1
  ciliarkropp_1_N = mkN "ciliarkropp" ; -- ciliarkropp..nn.1
  ciliarmuskel_1_N = mkN "ciliarmuskel" "ciliarmuskeln" "ciliarmuskler" "ciliarmusklerna" ; -- ciliarmuskel..nn.1
  cilie_1_N = mkN "cilie" "cilier" ; -- cilie..nn.1
  cineast_1_N = mkN "cineast" "cineaster" ; -- cineast..nn.1
  cinematek_1_N = mkN "cinematek" neutrum  ; -- cinematek..nn.1
  cineraria_1_N = mkN "cineraria" ; -- cineraria..nn.1
  cinnober_1_N = mkN "cinnober" ; -- cinnober..nn.1
  cinnoberfärg_1_N = mkN "cinnoberfärg" "cinnoberfärger" ; -- cinnoberfärg..nn.1
  cinnoberröd_1_A = mkA "cinnoberröd" "cinnoberrött" ; -- cinnoberröd..av.1
  cirkapris_1_N = mkN "cirkapris" neutrum  ; -- cirkapris..nn.1
  cirkel_1_N = mkN "cirkel" ; -- cirkel..nn.1
  cirkelbana_1_N = mkN "cirkelbana" ; -- cirkelbana..nn.1
  cirkelben_1_N = mkN "cirkelben" neutrum  ; -- cirkelben..nn.1
  cirkelbevis_1_N = mkN "cirkelbevis" neutrum  ; -- cirkelbevis..nn.1
  cirkelbåge_1_N = mkN "cirkelbåge" utrum  ; -- cirkelbåge..nn.1
  cirkeldefinition_1_N = mkN "cirkeldefinition" ; -- cirkeldefinition..nn.1
  cirkelform_1_N = mkN "cirkelform" ; -- cirkelform..nn.1
  cirkelformad_1_A = mkA "cirkelformad" "cirkelformadt" ; -- cirkelformad..av.1
  cirkelgång_1_N = mkN "cirkelgång" ; -- cirkelgång..nn.1
  cirkelledare_1_N = mkN "cirkelledare" utrum  ; -- cirkelledare..nn.1
  cirkelperiferi_1_N = mkN "cirkelperiferi" "cirkelperiferier" ; -- cirkelperiferi..nn.1
  cirkelprocess_1_N = mkN "cirkelprocess" "cirkelprocesser" ; -- cirkelprocess..nn.1
  cirkelrund_1_A = mkA "cirkelrund" ; -- cirkelrund..av.1
  cirkelrundhet_1_N = mkN "cirkelrundhet" ; -- cirkelrundhet..nn.1
  cirkelrörelse_1_N = mkN "cirkelrörelse" "cirkelrörelser" ; -- cirkelrörelse..nn.1
  cirkelsegment_1_N = mkN "cirkelsegment" neutrum  ; -- cirkelsegment..nn.1
  cirkelsektor_1_N = mkN "cirkelsektor" "cirkelsektorer" ; -- cirkelsektor..nn.1
  cirkelslut_1_N = mkN "cirkelslut" neutrum  ; -- cirkelslut..nn.1
  cirkelsåg_1_N = mkN "cirkelsåg" ; -- cirkelsåg..nn.1
  cirkla_1_V = mkV "cirklar" ; -- cirkla..vb.1
  cirklande_1_N = mkN "cirklande" ; -- cirklande..nn.1
  cirkulation_1_N = mkN "cirkulation" ; -- cirkulation..nn.1
  cirkulationsplats_1_N = mkN "cirkulationsplats" "cirkulationsplatser" ; -- cirkulationsplats..nn.1
  cirkulationspump_1_N = mkN "cirkulationspump" ; -- cirkulationspump..nn.1
  cirkulationsrubbning_1_N = mkN "cirkulationsrubbning" ; -- cirkulationsrubbning..nn.1
  cirkulera_1_V = mkV "cirkulerar" ; -- cirkulera..vb.1
  cirkulerande_1_N = mkN "cirkulerande" ; -- cirkulerande..nn.1
  cirkulerbar_1_A = mkA "cirkulerbar" ; -- cirkulerbar..av.1
  cirkulerbarhet_1_N = mkN "cirkulerbarhet" ; -- cirkulerbarhet..nn.1
  cirkulering_1_N = mkN "cirkulering" ; -- cirkulering..nn.1
  cirkulär_1_A = mkA "cirkulär" ; -- cirkulär..av.1
  cirkulär_1_N = mkN "cirkulär" neutrum  ; -- cirkulär..nn.1
  cirkulärbrev_1_N = mkN "cirkulärbrev" neutrum  ; -- cirkulärbrev..nn.1
  cirkulärledare_1_N = mkN "cirkulärledare" utrum  ; -- cirkulärledare..nn.1
  cirkumflex_1_N = mkN "cirkumflex" "cirkumflexer" ; -- cirkumflex..nn.1
  cirkumpolar_1_A = mkA "cirkumpolar" ; -- cirkumpolar..av.1
  cirkumpolär_1_A = mkA "cirkumpolär" ; -- cirkumpolär..av.1
  cirkus_1_N = mkN "cirkus" ; -- cirkus..nn.1
  cirkusarena_1_N = mkN "cirkusarena" ; -- cirkusarena..nn.1
  cirkusartist_1_N = mkN "cirkusartist" "cirkusartister" ; -- cirkusartist..nn.1
  cirkusbyggnad_1_N = mkN "cirkusbyggnad" "cirkusbyggnader" ; -- cirkusbyggnad..nn.1
  cirkusdjur_1_N = mkN "cirkusdjur" neutrum  ; -- cirkusdjur..nn.1
  cirkuselefant_1_N = mkN "cirkuselefant" "cirkuselefanter" ; -- cirkuselefant..nn.1
  cirkusföreställning_1_N = mkN "cirkusföreställning" ; -- cirkusföreställning..nn.1
  cirkusmanege_1_N = mkN "cirkusmanege" "cirkusmaneger" ; -- cirkusmanege..nn.1
  cirkusmässig_1_A = mkA "cirkusmässig" ; -- cirkusmässig..av.1
  cirkusnummer_1_N = mkN "cirkusnummer" neutrum  ; -- cirkusnummer..nn.1
  cirkustält_1_N = mkN "cirkustält" neutrum  ; -- cirkustält..nn.1
  cirkusvagn_1_N = mkN "cirkusvagn" ; -- cirkusvagn..nn.1
  cirrhos_1_N = mkN "cirrhos" "cirrhoser" ; -- cirrhos..nn.1
  cirros_1_N = mkN "cirros" "cirroser" ; -- cirros..nn.1
  cirrus_1_N = mkN "cirrus" ; -- cirrus..nn.1
  cirrusmoln_1_N = mkN "cirrusmoln" neutrum  ; -- cirrusmoln..nn.1
  cisalpinsk_1_A = mkA "cisalpinsk" ; -- cisalpinsk..av.1
  ciselera_1_V = mkV "ciselerar" ; -- ciselera..vb.1
  ciselerande_1_N = mkN "ciselerande" ; -- ciselerande..nn.1
  ciselerbar_1_A = mkA "ciselerbar" ; -- ciselerbar..av.1
  ciselerbarhet_1_N = mkN "ciselerbarhet" ; -- ciselerbarhet..nn.1
  ciselering_1_N = mkN "ciselering" ; -- ciselering..nn.1
  ciselör_1_N = mkN "ciselör" "ciselörer" ; -- ciselör..nn.1
  cisperson_1_N = mkN "cisperson" "cispersoner" ; -- cisperson..nn.1
  ciss_1_N = mkN "ciss" neutrum  ; -- ciss..nn.1
  cissexualitet_1_N = mkN "cissexualitet" ; -- cissexualitet..nn.1
  cissexuell_1_A = mkA "cissexuell" ; -- cissexuell..av.1
  cissus_1_N = mkN "cissus" ; -- cissus..nn.1
  cisterciens_1_N = mkN "cisterciens" "cistercienser" ; -- cisterciens..nn.1
  cistercienserkloster_1_N = mkN "cistercienserkloster" neutrum  ; -- cistercienserkloster..nn.1
  cisterciensermunk_1_N = mkN "cisterciensermunk" ; -- cisterciensermunk..nn.1
  cistercienserorden_1_N = mkN "cistercienserorden" ; -- cistercienserorden..nn.1
  cisterciensorden_1_N = mkN "cisterciensorden" ; -- cisterciensorden..nn.1
  cistern_1_N = mkN "cistern" "cisterner" ; -- cistern..nn.1
  cisulal_1_N = mkN "cisulal" ; -- cisulal..nn.1
  citadell_1_N = mkN "citadell" neutrum  ; -- citadell..nn.1
  citat_1_N = mkN "citat" neutrum  ; -- citat..nn.1
  citation_1_N = mkN "citation" ; -- citation..nn.1
  citationstecken_1_N = mkN "citationstecken" "citationstecknet" "citationstecken" "citationstecknen" ; -- citationstecken..nn.1
  citatord_1_N = mkN "citatord" neutrum  ; -- citatord..nn.1
  citattecken_1_N = mkN "citattecken" "citattecknet" "citattecken" "citattecknen" ; -- citattecken..nn.1
  citera_1_V = mkV "citerar" ; -- citera..vb.1
  citerande_1_N = mkN "citerande" ; -- citerande..nn.1
  citerbar_1_A = mkA "citerbar" ; -- citerbar..av.1
  citerbarhet_1_N = mkN "citerbarhet" ; -- citerbarhet..nn.1
  citering_1_N = mkN "citering" ; -- citering..nn.1
  citrat_1_N = mkN "citrat" neutrum  ; -- citrat..nn.1
  citrin_1_N = mkN "citrin" "citriner" ; -- citrin..nn.1
  citroen_1_N = mkN "citroen" "citroener" ; -- citroen..nn.1
  citron_1_N = mkN "citron" "citroner" ; -- citron..nn.1
  citronbakelse_1_N = mkN "citronbakelse" "citronbakelser" ; -- citronbakelse..nn.1
  citrondoft_1_N = mkN "citrondoft" "citrondofter" ; -- citrondoft..nn.1
  citronfjäril_1_N = mkN "citronfjäril" ; -- citronfjäril..nn.1
  citrongräsolja_1_N = mkN "citrongräsolja" ; -- citrongräsolja..nn.1
  citrongul_1_A = mkA "citrongul" ; -- citrongul..av.1
  citronläsk_1_N = mkN "citronläsk" "citronläsken" "citronläsk" "citronläsken" ; -- citronläsk..nn.1
  citronmarinerad_1_A = mkA "citronmarinerad" ; -- citronmarinerad..av.1
  citronmeliss_1_N = mkN "citronmeliss" ; -- citronmeliss..nn.1
  citronmousse_1_N = mkN "citronmousse" "citronmousser" ; -- citronmousse..nn.1
  citronolja_1_N = mkN "citronolja" ; -- citronolja..nn.1
  citronsaft_1_N = mkN "citronsaft" "citronsafter" ; -- citronsaft..nn.1
  citronskal_1_N = mkN "citronskal" neutrum  ; -- citronskal..nn.1
  citronsorbet_1_N = mkN "citronsorbet" ; -- citronsorbet..nn.1
  citronsyra_1_N = mkN "citronsyra" ; -- citronsyra..nn.1
  citronträd_1_N = mkN "citronträd" neutrum  ; -- citronträd..nn.1
  citrus_1_N = mkN "citrus" ; -- citrus..nn.1
  citrusfrukt_1_N = mkN "citrusfrukt" "citrusfrukter" ; -- citrusfrukt..nn.1
  citrussmak_1_N = mkN "citrussmak" ; -- citrussmak..nn.1
  citterspel_1_N = mkN "citterspel" "citterspelet" "citterspel" "citterspelen" ; -- citterspel..nn.1
  citterspelare_1_N = mkN "citterspelare" utrum  ; -- citterspelare..nn.1
  cittra_1_N = mkN "cittra" ; -- cittra..nn.1
  cittra_2_N = mkN "cittra" ; -- cittra..nn.2
  city_1_N = mkN "city" "cityt" "cityn" "cityna" ; -- city..nn.1
  citydress_1_N = mkN "citydress" ; -- citydress..nn.1
  citykärna_1_N = mkN "citykärna" ; -- citykärna..nn.1
  cityliv_1_N = mkN "cityliv" neutrum  ; -- cityliv..nn.1
  cityljus_1_N = mkN "cityljus" neutrum  ; -- cityljus..nn.1
  civil_1_A = mkA "civil" ; -- civil..av.1
  civilanställd_1_A = mkA "civilanställd" "civilanställt" ; -- civilanställd..av.1
  civilbefolkning_1_N = mkN "civilbefolkning" ; -- civilbefolkning..nn.1
  civilbegravning_1_N = mkN "civilbegravning" ; -- civilbegravning..nn.1
  civildepartement_1_N = mkN "civildepartement" neutrum  ; -- civildepartement..nn.1
  civilekonom_1_N = mkN "civilekonom" "civilekonomer" ; -- civilekonom..nn.1
  civilflyg_1_N = mkN "civilflyg" neutrum  ; -- civilflyg..nn.1
  civilförsvar_1_N = mkN "civilförsvar" neutrum  ; -- civilförsvar..nn.1
  civilförsvarspersonal_1_N = mkN "civilförsvarspersonal" ; -- civilförsvarspersonal..nn.1
  civilingenjör_1_N = mkN "civilingenjör" "civilingenjörer" ; -- civilingenjör..nn.1
  civilisation_1_N = mkN "civilisation" ; -- civilisation..nn.1
  civilisationsprocess_1_N = mkN "civilisationsprocess" "civilisationsprocesser" ; -- civilisationsprocess..nn.1
  civilisatorisk_1_A = mkA "civilisatorisk" ; -- civilisatorisk..av.1
  civilisera_1_V = mkV "civiliserar" ; -- civilisera..vb.1
  civiliserad_1_A = mkA "civiliserad" ; -- civiliserad..av.1
  civiliserande_1_N = mkN "civiliserande" ; -- civiliserande..nn.1
  civiliserbar_1_A = mkA "civiliserbar" ; -- civiliserbar..av.1
  civiliserbarhet_1_N = mkN "civiliserbarhet" ; -- civiliserbarhet..nn.1
  civilisering_1_N = mkN "civilisering" ; -- civilisering..nn.1
  civilist_1_N = mkN "civilist" "civilister" ; -- civilist..nn.1
  civilklädd_1_A = mkA "civilklädd" ; -- civilklädd..av.1
  civilkurage_1_N = mkN "civilkurage" ; -- civilkurage..nn.1
  civillag_1_N = mkN "civillag" ; -- civillag..nn.1
  civilmilitär_1_A = mkA "civilmilitär" ; -- civilmilitär..av.1
  civilmilitär_1_N = mkN "civilmilitär" "civilmilitärer" ; -- civilmilitär..nn.1
  civilminister_1_N = mkN "civilminister" ; -- civilminister..nn.1
  civilmotstånd_1_N = mkN "civilmotstånd" neutrum  ; -- civilmotstånd..nn.1
  civilmål_1_N = mkN "civilmål" neutrum  ; -- civilmål..nn.1
  civilprocess_1_N = mkN "civilprocess" "civilprocesser" ; -- civilprocess..nn.1
  civilrätt_1_N = mkN "civilrätt" ; -- civilrätt..nn.1
  civilrättslig_1_A = mkA "civilrättslig" ; -- civilrättslig..av.1
  civilstat_1_N = mkN "civilstat" "civilstater" ; -- civilstat..nn.1
  civilstånd_1_N = mkN "civilstånd" neutrum  ; -- civilstånd..nn.1
  civiläktenskap_1_N = mkN "civiläktenskap" neutrum  ; -- civiläktenskap..nn.1
  clairobscur_1_N = mkN "clairobscur" "clairobscurer" ; -- clairobscur..nn.1
  clairvoyance_1_N = mkN "clairvoyance" utrum  ; -- clairvoyance..nn.1
  clairvoyant_1_A = mkA "clairvoyant" "clairvoyant" ; -- clairvoyant..av.1
  cleara_1_V = mkV "clearar" ; -- cleara..vb.1
  clearande_1_N = mkN "clearande" ; -- clearande..nn.1
  clearing_1_N = mkN "clearing" ; -- clearing..nn.1
  clematis_1_N = mkN "clematis" ; -- clematis..nn.1
  clementin_1_N = mkN "clementin" "clementiner" ; -- clementin..nn.1
  clinch_1_N = mkN "clinch" ; -- clinch..nn.1
  clips_1_N = mkN "clips" neutrum  ; -- clips..nn.1
  clitoris_1_N = mkN "clitoris" ; -- clitoris..nn.1
  cloisonvägg_1_N = mkN "cloisonvägg" ; -- cloisonvägg..nn.1
  cloqué_1_N = mkN "cloqué" "cloquéer" ; -- cloqué..nn.1
  clou_1_N = mkN "clou" ; -- clou..nn.1
  clown_1_N = mkN "clown" "clowner" ; -- clown..nn.1
  clowneri_1_N = mkN "clowneri" "clowneriet" "clownerier" "clownerierna" ; -- clowneri..nn.1
  clownupptåg_1_N = mkN "clownupptåg" neutrum  ; -- clownupptåg..nn.1
  club_blazer_1_N = mkN "club-blazer" ; -- club-blazer..nn.1
  clubstek_1_N = mkN "clubstek" ; -- clubstek..nn.1
  coach_1_N = mkN "coach" ; -- coach..nn.1
  coca_1_N = mkN "coca" ; -- coca..nn.1
  cocacola_1_N = mkN "cocacola" ; -- cocacola..nn.1
  cochleaimplantat_1_N = mkN "cochleaimplantat" neutrum  ; -- cochleaimplantat..nn.1
  cochlearimplantat_1_N = mkN "cochlearimplantat" neutrum  ; -- cochlearimplantat..nn.1
  cockerspaniel_1_N = mkN "cockerspaniel" "cockerspanieln" "cockerspaniels" "cockerspanielarna" ; -- cockerspaniel..nn.1
  cockpit_1_N = mkN "cockpit" ; -- cockpit..nn.1
  cocktail_1_N = mkN "cocktail" ; -- cocktail..nn.1
  cocktailbjudning_1_N = mkN "cocktailbjudning" ; -- cocktailbjudning..nn.1
  cocktailbord_1_N = mkN "cocktailbord" neutrum  ; -- cocktailbord..nn.1
  cocktailbär_1_N = mkN "cocktailbär" neutrum  ; -- cocktailbär..nn.1
  cocktailglas_1_N = mkN "cocktailglas" neutrum  ; -- cocktailglas..nn.1
  cocktailmusik_1_N = mkN "cocktailmusik" ; -- cocktailmusik..nn.1
  cocktailparty_1_N = mkN "cocktailparty" "cocktailpartyt" "cocktailpartyn" "cocktailpartyna" ; -- cocktailparty..nn.1
  coda_1_N = mkN "coda" ; -- coda..nn.1
  codex_1_N = mkN "codex" ; -- codex..nn.1
  cointreau_1_N = mkN "cointreau" ; -- cointreau..nn.1
  coitus_1_N = mkN "coitus" ; -- coitus..nn.1
  cokacola_1_N = mkN "cokacola" ; -- cokacola..nn.1
  cokakola_1_N = mkN "cokakola" ; -- cokakola..nn.1
  cola_1_N = mkN "cola" ; -- cola..nn.1
  colibakterie_1_N = mkN "colibakterie" "colibakterier" ; -- colibakterie..nn.1
  collage_1_N = mkN "collage" "collaget" "collage" "collagen" ; -- collage..nn.1
  college_1_N = mkN "college" "colleget" "college" "collegen" ; -- college..nn.1
  collegeflicka_1_N = mkN "collegeflicka" ; -- collegeflicka..nn.1
  collegepojke_1_N = mkN "collegepojke" utrum  ; -- collegepojke..nn.1
  collegetröja_1_N = mkN "collegetröja" ; -- collegetröja..nn.1
  collie_1_N = mkN "collie" "collier" ; -- collie..nn.1
  collier_1_N = mkN "collier" "collierer" ; -- collier..nn.1
  cologne_1_N = mkN "cologne" "cologner" ; -- cologne..nn.1
  colombian_1_N = mkN "colombian" "colombianer" ; -- colombian..nn.1
  colombiansk_1_A = mkA "colombiansk" ; -- colombiansk..av.1
  colombianska_1_N = mkN "colombianska" ; -- colombianska..nn.1
  coltan_1_N = mkN "coltan" neutrum  ; -- coltan..nn.1
  come_back_1_N = mkN "come-back" "come-backer" ; -- come-back..nn.1
  comeback_1_N = mkN "comeback" "comebacker" ; -- comeback..nn.1
  commando_1_N = mkN "commando" "commandon" "commandos" "commandosarna" ; -- commando..nn.1
  commandotrupp_1_N = mkN "commandotrupp" "commandotrupper" ; -- commandotrupp..nn.1
  comorier_1_N = mkN "comorier" "comoriern" "comorier" "comorierna" ; -- comorier..nn.1
  comorisk_1_A = mkA "comorisk" ; -- comorisk..av.1
  comoriska_1_N = mkN "comoriska" ; -- comoriska..nn.1
  complet_1_N = mkN "complet" ; -- complet..nn.1
  conferencier_1_N = mkN "conferencier" "conferencierer" ; -- conferencier..nn.1
  conférencier_1_N = mkN "conférencier" "conférencierer" ; -- conférencier..nn.1
  consensus_1_N = mkN "consensus" ; -- consensus..nn.1
  consensuskultur_1_N = mkN "consensuskultur" "consensuskulturer" ; -- consensuskultur..nn.1
  consommé_1_N = mkN "consommé" "consomméer" ; -- consommé..nn.1
  container_1_N = mkN "container" ; -- container..nn.1
  containerfartyg_1_N = mkN "containerfartyg" neutrum  ; -- containerfartyg..nn.1
  contortatall_1_N = mkN "contortatall" ; -- contortatall..nn.1
  cool_1_A = mkA "cool" ; -- cool..av.1
  coolhet_1_N = mkN "coolhet" ; -- coolhet..nn.1
  copy_cat_1_N = mkN "copy-cat" "copy-caten" "copy-cats" "copy-catsarna" ; -- copy-cat..nn.1
  copycat_1_N = mkN "copycat" "copycaten" "copycats" "copycatsarna" ; -- copycat..nn.1
  copyright_1_N = mkN "copyright" ; -- copyright..nn.1
  copywriter_1_N = mkN "copywriter" "copywritern" "copywriters" "copywritersarna" ; -- copywriter..nn.1
  corioliskraft_1_N = mkN "corioliskraft" ; -- corioliskraft..nn.1
  cornichon_1_N = mkN "cornichon" "cornichonen" "cornichons" "cornichonerna" ; -- cornichon..nn.1
  coronacell_1_N = mkN "coronacell" "coronaceller" ; -- coronacell..nn.1
  corps_de_logi_1_N = mkN "corps-de-logi" "corps-de-logiet" "corps-de-logier" "corps-de-logierna" ; -- corps-de-logi..nn.1
  corpus_1_N = mkN "corpus" ; -- corpus..nn.1
  cortege_1_N = mkN "cortege" "corteger" ; -- cortege..nn.1
  cortex_1_N = mkN "cortex" ; -- cortex..nn.1
  cortical_1_A = mkA "cortical" ; -- cortical..av.1
  cortison_1_N = mkN "cortison" "cortisoner" ; -- cortison..nn.1
  cortisonbehandling_1_N = mkN "cortisonbehandling" ; -- cortisonbehandling..nn.1
  cortège_1_N = mkN "cortège" "cortèger" ; -- cortège..nn.1
  cosinus_1_N = mkN "cosinus" ; -- cosinus..nn.1
  costarican_1_N = mkN "costarican" "costaricaner" ; -- costarican..nn.1
  costaricansk_1_A = mkA "costaricansk" ; -- costaricansk..av.1
  costaricanska_1_N = mkN "costaricanska" ; -- costaricanska..nn.1
  cotangens_1_N = mkN "cotangens" ; -- cotangens..nn.1
  cotangent_1_N = mkN "cotangent" "cotangenter" ; -- cotangent..nn.1
  coulomb_1_N = mkN "coulomb" "coulomben" "coulomb" "coulomben" ; -- coulomb..nn.1
  countrymusik_1_N = mkN "countrymusik" ; -- countrymusik..nn.1
  countrysång_1_N = mkN "countrysång" "countrysånger" ; -- countrysång..nn.1
  coupe_1_N = mkN "coupe" "couper" ; -- coupe..nn.1
  couronne_1_N = mkN "couronne" ; -- couronne..nn.1
  courtage_1_N = mkN "courtage" ; -- courtage..nn.1
  cous_cous_1_N = mkN "cous-cous" ; -- cous-cous..nn.1
  couscous_1_N = mkN "couscous" ; -- couscous..nn.1
  cover_1_N = mkN "cover" "covern" "covers" "coversarna" ; -- cover..nn.1
  coverlåt_1_N = mkN "coverlåt" ; -- coverlåt..nn.1
  coverversion_1_N = mkN "coverversion" ; -- coverversion..nn.1
  covra_1_V = mkV "covrar" ; -- covra..vb.1
  cowboy_1_N = mkN "cowboy" "cowboyen" "cowboys" "cowboyerna" ; -- cowboy..nn.1
  cowboyhatt_1_N = mkN "cowboyhatt" ; -- cowboyhatt..nn.1
  coyote_1_N = mkN "coyote" "coyoter" ; -- coyote..nn.1
  cp_skadad_1_A = mkA "cp-skadad" ; -- cp-skadad..av.1
  crawl_1_N = mkN "crawl" ; -- crawl..nn.1
  crawla_1_V = mkV "crawlar" ; -- crawla..vb.1
  crawlande_1_N = mkN "crawlande" ; -- crawlande..nn.1
  crazy_1_A = mkA "crazy" ; -- crazy..av.1
  cred_1_N = mkN "cred" ; -- cred..nn.1
  credd_1_N = mkN "credd" ; -- credd..nn.1
  credo_1_N = mkN "credo" "credot" "credon" "credona" ; -- credo..nn.1
  creme_1_N = mkN "creme" "cremer" ; -- creme..nn.1
  creme_2_N = mkN "creme" ; -- creme..nn.2
  crepe_1_N = mkN "crepe" "creper" ; -- crepe..nn.1
  crescendo_1_N = mkN "crescendo" "crescendot" "crescendon" "crescendona" ; -- crescendo..nn.1
  cricket_1_N = mkN "cricket" ; -- cricket..nn.1
  cricketklubba_1_N = mkN "cricketklubba" ; -- cricketklubba..nn.1
  croissant_1_N = mkN "croissant" "croissanter" ; -- croissant..nn.1
  croquis_1_N = mkN "croquis" "croquiser" ; -- croquis..nn.1
  crosschecking_1_N = mkN "crosschecking" ; -- crosschecking..nn.1
  crosshandske_1_N = mkN "crosshandske" utrum  ; -- crosshandske..nn.1
  crosshjälm_1_N = mkN "crosshjälm" ; -- crosshjälm..nn.1
  croupier_1_N = mkN "croupier" "croupierer" ; -- croupier..nn.1
  crust_1_N = mkN "crust" ; -- crust..nn.1
  crème_de_la_crème_1_N = mkN "crème-de-la-crème" utrum  ; -- crème-de-la-crème..nn.1
  crème_1_N = mkN "crème" "crèmer" ; -- crème..nn.1
  crème_2_N = mkN "crème" ; -- crème..nn.2
  crèpe_1_N = mkN "crèpe" "crèper" ; -- crèpe..nn.1
  crêpe_1_N = mkN "crêpe" "crêper" ; -- crêpe..nn.1
  crêpegarn_1_N = mkN "crêpegarn" neutrum  ; -- crêpegarn..nn.1
  csardas_1_N = mkN "csardas" ; -- csardas..nn.1
  cuban_1_N = mkN "cuban" "cubaner" ; -- cuban..nn.1
  cubansk_1_A = mkA "cubansk" ; -- cubansk..av.1
  cumulus_1_N = mkN "cumulus" ; -- cumulus..nn.1
  cumuluscell_1_N = mkN "cumuluscell" "cumulusceller" ; -- cumuluscell..nn.1
  cumulusmoln_1_N = mkN "cumulusmoln" neutrum  ; -- cumulusmoln..nn.1
  cup_1_N = mkN "cup" "cuper" ; -- cup..nn.1
  curare_1_N = mkN "curare" ; -- curare..nn.1
  curatera_1_V = mkV "curaterar" ; -- curatera..vb.1
  curaterande_1_N = mkN "curaterande" ; -- curaterande..nn.1
  curaterbar_1_A = mkA "curaterbar" ; -- curaterbar..av.1
  curaterbarhet_1_N = mkN "curaterbarhet" ; -- curaterbarhet..nn.1
  curator_1_N = mkN "curator" "curatorer" ; -- curator..nn.1
  curaçao_1_N = mkN "curaçao" ; -- curaçao..nn.1
  curera_1_V = mkV "curerar" ; -- curera..vb.1
  curerande_1_N = mkN "curerande" ; -- curerande..nn.1
  curerbar_1_A = mkA "curerbar" ; -- curerbar..av.1
  curerbarhet_1_N = mkN "curerbarhet" ; -- curerbarhet..nn.1
  curia_1_N = mkN "curia" ; -- curia..nn.1
  curie_1_N = mkN "curie" "curien" "curie" "curiena" ; -- curie..nn.1
  curium_1_N = mkN "curium" neutrum  ; -- curium..nn.1
  curla_1_V = mkV "curlar" ; -- curla..vb.1
  curla_2_V = mkV "curlar" ; -- curla..vb.2
  curlande_1_N = mkN "curlande" ; -- curlande..nn.1
  curling_1_N = mkN "curling" ; -- curling..nn.1
  curlingbarn_1_N = mkN "curlingbarn" neutrum  ; -- curlingbarn..nn.1
  curlingfinal_1_N = mkN "curlingfinal" "curlingfinaler" ; -- curlingfinal..nn.1
  curlingförälder_1_N = mkN "curlingförälder" ; -- curlingförälder..nn.1
  curlingtävling_1_N = mkN "curlingtävling" ; -- curlingtävling..nn.1
  currygryta_1_N = mkN "currygryta" ; -- currygryta..nn.1
  cyan_1_N = mkN "cyan" ; -- cyan..nn.1
  cyanblå_1_A = mkA "cyanblå" "cyanblått" ; -- cyanblå..av.1
  cyanid_1_N = mkN "cyanid" "cyanider" ; -- cyanid..nn.1
  cyankalium_1_N = mkN "cyankalium" neutrum  ; -- cyankalium..nn.1
  cyanobakterie_1_N = mkN "cyanobakterie" "cyanobakterier" ; -- cyanobakterie..nn.1
  cyanos_1_N = mkN "cyanos" ; -- cyanos..nn.1
  cyanväte_1_N = mkN "cyanväte" ; -- cyanväte..nn.1
  cyanvätesyra_1_N = mkN "cyanvätesyra" ; -- cyanvätesyra..nn.1
  cyberbrottslighet_1_N = mkN "cyberbrottslighet" "cyberbrottsligheter" ; -- cyberbrottslighet..nn.1
  cybernetik_1_N = mkN "cybernetik" ; -- cybernetik..nn.1
  cybernetisk_1_A = mkA "cybernetisk" ; -- cybernetisk..av.1
  cyberrymd_1_N = mkN "cyberrymd" ; -- cyberrymd..nn.1
  cybersex_1_N = mkN "cybersex" neutrum  ; -- cybersex..nn.1
  cyberstrategi_1_N = mkN "cyberstrategi" "cyberstrategier" ; -- cyberstrategi..nn.1
  cybervärld_1_N = mkN "cybervärld" ; -- cybervärld..nn.1
  cybervåld_1_N = mkN "cybervåld" neutrum  ; -- cybervåld..nn.1
  cyborg_1_N = mkN "cyborg" "cyborger" ; -- cyborg..nn.1
  cykel_1_N = mkN "cykel" ; -- cykel..nn.1
  cykel_2_N = mkN "cykel" ; -- cykel..nn.2
  cykelbana_1_N = mkN "cykelbana" ; -- cykelbana..nn.1
  cykeldäck_1_N = mkN "cykeldäck" neutrum  ; -- cykeldäck..nn.1
  cykelergometer_1_N = mkN "cykelergometer" ; -- cykelergometer..nn.1
  cykelhjälm_1_N = mkN "cykelhjälm" ; -- cykelhjälm..nn.1
  cykelkedja_1_N = mkN "cykelkedja" ; -- cykelkedja..nn.1
  cykelklämma_1_N = mkN "cykelklämma" ; -- cykelklämma..nn.1
  cykelkrock_1_N = mkN "cykelkrock" ; -- cykelkrock..nn.1
  cykelkrok_1_N = mkN "cykelkrok" ; -- cykelkrok..nn.1
  cykellykta_1_N = mkN "cykellykta" ; -- cykellykta..nn.1
  cykellås_1_N = mkN "cykellås" neutrum  ; -- cykellås..nn.1
  cykelnyckel_1_N = mkN "cykelnyckel" ; -- cykelnyckel..nn.1
  cykelpump_1_N = mkN "cykelpump" ; -- cykelpump..nn.1
  cykelram_1_N = mkN "cykelram" ; -- cykelram..nn.1
  cykelsadel_1_N = mkN "cykelsadel" ; -- cykelsadel..nn.1
  cykelslang_1_N = mkN "cykelslang" ; -- cykelslang..nn.1
  cykelstyre_1_N = mkN "cykelstyre" ; -- cykelstyre..nn.1
  cykelställ_1_N = mkN "cykelställ" neutrum  ; -- cykelställ..nn.1
  cykelstöld_1_N = mkN "cykelstöld" "cykelstölder" ; -- cykelstöld..nn.1
  cykeltrupp_1_N = mkN "cykeltrupp" "cykeltrupper" ; -- cykeltrupp..nn.1
  cykeltävling_1_N = mkN "cykeltävling" ; -- cykeltävling..nn.1
  cykelutflykt_1_N = mkN "cykelutflykt" "cykelutflykter" ; -- cykelutflykt..nn.1
  cykelventil_1_N = mkN "cykelventil" "cykelventiler" ; -- cykelventil..nn.1
  cykelväg_1_N = mkN "cykelväg" ; -- cykelväg..nn.1
  cykelåkning_1_N = mkN "cykelåkning" ; -- cykelåkning..nn.1
  cykla_1_V = mkV "cyklar" ; -- cykla..vb.1
  cyklamat_1_N = mkN "cyklamat" ; -- cyklamat..nn.1
  cyklamen_1_N = mkN "cyklamen" "cyklamen" "cyklamer" "cyklamerna" ; -- cyklamen..nn.1
  cyklande_1_N = mkN "cyklande" ; -- cyklande..nn.1
  cykling_1_N = mkN "cykling" ; -- cykling..nn.1
  cyklisk_1_A = mkA "cyklisk" ; -- cyklisk..av.1
  cyklism_1_N = mkN "cyklism" "cyklismer" ; -- cyklism..nn.1
  cyklist_1_N = mkN "cyklist" "cyklister" ; -- cyklist..nn.1
  cykloid_1_N = mkN "cykloid" "cykloider" ; -- cykloid..nn.1
  cyklometer_1_N = mkN "cyklometer" ; -- cyklometer..nn.1
  cyklon_1_N = mkN "cyklon" "cykloner" ; -- cyklon..nn.1
  cyklonartad_1_A = mkA "cyklonartad" ; -- cyklonartad..av.1
  cyklonfamilj_1_N = mkN "cyklonfamilj" "cyklonfamiljer" ; -- cyklonfamilj..nn.1
  cyklop_1_N = mkN "cyklop" "cykloper" ; -- cyklop..nn.1
  cyklop_2_N = mkN "cyklop" neutrum  ; -- cyklop..nn.2
  cyklopisk_1_A = mkA "cyklopisk" ; -- cyklopisk..av.1
  cyklopöga_1_N = mkN "cyklopöga" "cyklopögat" "cyklopögon" "cyklopögonen" ; -- cyklopöga..nn.1
  cyklotron_1_N = mkN "cyklotron" "cyklotroner" ; -- cyklotron..nn.1
  cyklotym_1_A = mkA "cyklotym" ; -- cyklotym..av.1
  cylinder_1_N = mkN "cylinder" ; -- cylinder..nn.1
  cylinderblock_1_N = mkN "cylinderblock" neutrum  ; -- cylinderblock..nn.1
  cylinderform_1_N = mkN "cylinderform" "cylinderformer" ; -- cylinderform..nn.1
  cylinderformad_1_A = mkA "cylinderformad" ; -- cylinderformad..av.1
  cylinderglas_1_N = mkN "cylinderglas" neutrum  ; -- cylinderglas..nn.1
  cylinderhatt_1_N = mkN "cylinderhatt" ; -- cylinderhatt..nn.1
  cylinderlås_1_N = mkN "cylinderlås" neutrum  ; -- cylinderlås..nn.1
  cylinderpress_1_N = mkN "cylinderpress" ; -- cylinderpress..nn.1
  cylinderur_1_N = mkN "cylinderur" neutrum  ; -- cylinderur..nn.1
  cylindrisk_1_A = mkA "cylindrisk" ; -- cylindrisk..av.1
  cymbal_1_N = mkN "cymbal" "cymbaler" ; -- cymbal..nn.1
  cymbalklang_1_N = mkN "cymbalklang" "cymbalklanger" ; -- cymbalklang..nn.1
  cyniker_1_N = mkN "cyniker" "cynikern" "cyniker" "cynikerna" ; -- cyniker..nn.1
  cynisk_1_A = mkA "cynisk" ; -- cynisk..av.1
  cynism_1_N = mkN "cynism" "cynismer" ; -- cynism..nn.1
  cypress_1_N = mkN "cypress" "cypresser" ; -- cypress..nn.1
  cypresskrans_1_N = mkN "cypresskrans" ; -- cypresskrans..nn.1
  cypriot_1_N = mkN "cypriot" "cyprioter" ; -- cypriot..nn.1
  cypriotisk_1_A = mkA "cypriotisk" ; -- cypriotisk..av.1
  cypriotiska_1_N = mkN "cypriotiska" ; -- cypriotiska..nn.1
  cysta_1_N = mkN "cysta" ; -- cysta..nn.1
  cystoskop_1_N = mkN "cystoskop" neutrum  ; -- cystoskop..nn.1
  cystoskopi_1_N = mkN "cystoskopi" "cystoskopier" ; -- cystoskopi..nn.1
  cytologi_1_N = mkN "cytologi" ; -- cytologi..nn.1
  cytologisk_1_A = mkA "cytologisk" ; -- cytologisk..av.1
  cytoplasma_1_N = mkN "cytoplasma" ; -- cytoplasma..nn.1
  dadaism_1_N = mkN "dadaism" "dadaismer" ; -- dadaism..nn.1
  dadaist_1_N = mkN "dadaist" "dadaister" ; -- dadaist..nn.1
  dadaistisk_1_A = mkA "dadaistisk" ; -- dadaistisk..av.1
  dadda_1_N = mkN "dadda" ; -- dadda..nn.1
  dadda_1_V = mkV "daddar" ; -- dadda..vb.1
  daddande_1_N = mkN "daddande" ; -- daddande..nn.1
  dadel_1_N = mkN "dadel" ; -- dadel..nn.1
  dadelpalm_1_N = mkN "dadelpalm" "dadelpalmer" ; -- dadelpalm..nn.1
  dag_1_N = mkN "dag" ; -- dag..nn.1
  dagakarl_1_N = mkN "dagakarl" ; -- dagakarl..nn.1
  dagaktiv_1_A = mkA "dagaktiv" ; -- dagaktiv..av.1
  dagavdelning_1_N = mkN "dagavdelning" ; -- dagavdelning..nn.1
  dagbarn_1_N = mkN "dagbarn" neutrum  ; -- dagbarn..nn.1
  dagbarnvårdare_1_N = mkN "dagbarnvårdare" utrum  ; -- dagbarnvårdare..nn.1
  dagbefäl_1_N = mkN "dagbefäl" neutrum  ; -- dagbefäl..nn.1
  dagblad_1_N = mkN "dagblad" neutrum  ; -- dagblad..nn.1
  dagblind_1_A = mkA "dagblind" ; -- dagblind..av.1
  dagblindhet_1_N = mkN "dagblindhet" ; -- dagblindhet..nn.1
  dagbok_1_N = mkN "dagbok" "dagböcker" ; -- dagbok..nn.1
  dagboksanteckning_1_N = mkN "dagboksanteckning" ; -- dagboksanteckning..nn.1
  dagboksskrivande_1_A = mkA "dagboksskrivande" ; -- dagboksskrivande..av.1
  dagboksskrivande_1_N = mkN "dagboksskrivande" ; -- dagboksskrivande..nn.1
  dagbrott_1_N = mkN "dagbrott" neutrum  ; -- dagbrott..nn.1
  dagbrytning_1_N = mkN "dagbrytning" ; -- dagbrytning..nn.1
  dagbräckning_1_N = mkN "dagbräckning" ; -- dagbräckning..nn.1
  dagcentral_1_N = mkN "dagcentral" "dagcentraler" ; -- dagcentral..nn.1
  dagcentrum_1_N = mkN "dagcentrum" neutrum  ; -- dagcentrum..nn.1
  dagdjur_1_N = mkN "dagdjur" neutrum  ; -- dagdjur..nn.1
  dagdrivare_1_N = mkN "dagdrivare" utrum  ; -- dagdrivare..nn.1
  dagdrivarliv_1_N = mkN "dagdrivarliv" neutrum  ; -- dagdrivarliv..nn.1
  dagdriveri_1_N = mkN "dagdriveri" neutrum  ; -- dagdriveri..nn.1
  dagdröm_1_N = mkN "dagdröm" "dagdrömmen" "dagdrömmar" "dagdrömmarna" ; -- dagdröm..nn.1
  dagdrömma_1_V = mkV "dagdrömmer" ; -- dagdrömma..vb.1
  dagdrömmande_1_N = mkN "dagdrömmande" ; -- dagdrömmande..nn.1
  dagdrömmare_1_N = mkN "dagdrömmare" utrum  ; -- dagdrömmare..nn.1
  dagdrömmeri_1_N = mkN "dagdrömmeri" "dagdrömmeriet" "dagdrömmerier" "dagdrömmerierna" ; -- dagdrömmeri..nn.1
  dagenefterhuvudvärk_1_N = mkN "dagenefterhuvudvärk" ; -- dagenefterhuvudvärk..nn.1
  dagenefterpiller_1_N = mkN "dagenefterpiller" neutrum  ; -- dagenefterpiller..nn.1
  dagenefterstämning_1_N = mkN "dagenefterstämning" ; -- dagenefterstämning..nn.1
  dagens_1_N = mkN "dagens" ; -- dagens..nn.1
  dager_1_N = mkN "dager" ; -- dager..nn.1
  dagerrotyp_1_N = mkN "dagerrotyp" "dagerrotyper" ; -- dagerrotyp..nn.1
  dagerrotypi_1_N = mkN "dagerrotypi" "dagerrotypier" ; -- dagerrotypi..nn.1
  dagfjäril_1_N = mkN "dagfjäril" ; -- dagfjäril..nn.1
  dagg_1_N = mkN "dagg" ; -- dagg..nn.1
  dagg_2_N = mkN "dagg" ; -- dagg..nn.2
  dagga_1_V = mkV "daggar" ; -- dagga..vb.1
  daggande_1_N = mkN "daggande" ; -- daggande..nn.1
  daggdroppe_1_N = mkN "daggdroppe" utrum  ; -- daggdroppe..nn.1
  daggert_1_N = mkN "daggert" ; -- daggert..nn.1
  daggfrisk_1_A = mkA "daggfrisk" ; -- daggfrisk..av.1
  daggig_1_A = mkA "daggig" ; -- daggig..av.1
  daggighet_1_N = mkN "daggighet" ; -- daggighet..nn.1
  daggkåpa_1_N = mkN "daggkåpa" ; -- daggkåpa..nn.1
  daggmask_1_N = mkN "daggmask" ; -- daggmask..nn.1
  daggpunkt_1_N = mkN "daggpunkt" "daggpunkter" ; -- daggpunkt..nn.1
  daggryning_1_N = mkN "daggryning" ; -- daggryning..nn.1
  daggvåt_1_A = mkA "daggvåt" ; -- daggvåt..av.1
  daghavande_1_A = mkA "daghavande" ; -- daghavande..av.1
  daghavande_1_N = mkN "daghavande" "daghavanden" "daghavanden" "daghavandena" ; -- daghavande..nn.1
  daghem_1_N = mkN "daghem" "daghemmet" "daghem" "daghemmen" ; -- daghem..nn.1
  daghemsföreståndare_1_N = mkN "daghemsföreståndare" utrum  ; -- daghemsföreståndare..nn.1
  daghemsplats_1_N = mkN "daghemsplats" "daghemsplatser" ; -- daghemsplats..nn.1
  dagis_1_N = mkN "dagis" neutrum  ; -- dagis..nn.1
  dagisfröken_1_N = mkN "dagisfröken" ; -- dagisfröken..nn.1
  dagisplats_1_N = mkN "dagisplats" "dagisplatser" ; -- dagisplats..nn.1
  dagjämning_1_N = mkN "dagjämning" ; -- dagjämning..nn.1
  dagjämningspunkt_1_N = mkN "dagjämningspunkt" ; -- dagjämningspunkt..nn.1
  dagkarl_1_N = mkN "dagkarl" ; -- dagkarl..nn.1
  dagledig_1_A = mkA "dagledig" ; -- dagledig..av.1
  daglega_1_N = mkN "daglega" ; -- daglega..nn.1
  daglig_1_A = mkA "daglig" ; -- daglig..av.1
  dagligdags_1_Adv = mkAdv "dagligdags" ; -- dagligdags..ab.1
  dagligen_1_Adv = mkAdv "dagligen" ; -- dagligen..ab.1
  daglighet_1_N = mkN "daglighet" ; -- daglighet..nn.1
  dagligstuga_1_N = mkN "dagligstuga" ; -- dagligstuga..nn.1
  dagligvara_1_N = mkN "dagligvara" ; -- dagligvara..nn.1
  daglön_1_N = mkN "daglön" "daglöner" ; -- daglön..nn.1
  daglönare_1_N = mkN "daglönare" utrum  ; -- daglönare..nn.1
  dagmamma_1_N = mkN "dagmamma" ; -- dagmamma..nn.1
  dagning_1_N = mkN "dagning" ; -- dagning..nn.1
  dago_1_N = mkN "dago" "dagon" "dagos" "dagosarna" ; -- dago..nn.1
  dagofficer_1_N = mkN "dagofficer" "dagofficeren" "dagofficerare" "dagofficerarna" ; -- dagofficer..nn.1
  dagorder_1_N = mkN "dagorder" ; -- dagorder..nn.1
  dagordning_1_N = mkN "dagordning" ; -- dagordning..nn.1
  dagort_1_N = mkN "dagort" "dagorter" ; -- dagort..nn.1
  dagpenning_1_N = mkN "dagpenning" ; -- dagpenning..nn.1
  dagrum_1_N = mkN "dagrum" "dagrummet" "dagrum" "dagrummen" ; -- dagrum..nn.1
  dags_1_N = mkN "dags" ; -- dags..nn.1
  dagsaktuell_1_A = mkA "dagsaktuell" ; -- dagsaktuell..av.1
  dagsbehov_1_N = mkN "dagsbehov" neutrum  ; -- dagsbehov..nn.1
  dagsbot_1_N = mkN "dagsbot" "dagsböter" ; -- dagsbot..nn.1
  dagsedel_1_N = mkN "dagsedel" ; -- dagsedel..nn.1
  dagsfärsk_1_A = mkA "dagsfärsk" ; -- dagsfärsk..av.1
  dagshetta_1_N = mkN "dagshetta" ; -- dagshetta..nn.1
  dagskassa_1_N = mkN "dagskassa" ; -- dagskassa..nn.1
  dagskryssning_1_N = mkN "dagskryssning" ; -- dagskryssning..nn.1
  dagskrönika_1_N = mkN "dagskrönika" ; -- dagskrönika..nn.1
  dagsled_1_N = mkN "dagsled" "dagsleder" ; -- dagsled..nn.1
  dagsljus_1_N = mkN "dagsljus" neutrum  ; -- dagsljus..nn.1
  dagsläge_1_N = mkN "dagsläge" ; -- dagsläge..nn.1
  dagslända_1_N = mkN "dagslända" ; -- dagslända..nn.1
  dagsländeliv_1_N = mkN "dagsländeliv" neutrum  ; -- dagsländeliv..nn.1
  dagslång_1_A = mkA "dagslång" ; -- dagslång..av.1
  dagsmarsch_1_N = mkN "dagsmarsch" "dagsmarscher" ; -- dagsmarsch..nn.1
  dagsmeja_1_N = mkN "dagsmeja" ; -- dagsmeja..nn.1
  dagsnyhet_1_N = mkN "dagsnyhet" "dagsnyheter" ; -- dagsnyhet..nn.1
  dagspenning_1_N = mkN "dagspenning" ; -- dagspenning..nn.1
  dagspolitisk_1_A = mkA "dagspolitisk" ; -- dagspolitisk..av.1
  dagspress_1_N = mkN "dagspress" ; -- dagspress..nn.1
  dagsprogram_1_N = mkN "dagsprogram" "dagsprogrammet" "dagsprogram" "dagsprogrammen" ; -- dagsprogram..nn.1
  dagsranson_1_N = mkN "dagsranson" "dagsransoner" ; -- dagsranson..nn.1
  dagsregn_1_N = mkN "dagsregn" neutrum  ; -- dagsregn..nn.1
  dagsresa_1_N = mkN "dagsresa" ; -- dagsresa..nn.1
  dagstemperatur_1_N = mkN "dagstemperatur" "dagstemperaturer" ; -- dagstemperatur..nn.1
  dagstidning_1_N = mkN "dagstidning" ; -- dagstidning..nn.1
  dagstidningsredaktör_1_N = mkN "dagstidningsredaktör" "dagstidningsredaktörer" ; -- dagstidningsredaktör..nn.1
  dagsverkare_1_N = mkN "dagsverkare" utrum  ; -- dagsverkare..nn.1
  dagsverke_1_N = mkN "dagsverke" ; -- dagsverke..nn.1
  dagsvers_1_N = mkN "dagsvers" "dagsverser" ; -- dagsvers..nn.1
  dagsversskribent_1_N = mkN "dagsversskribent" "dagsversskribenter" ; -- dagsversskribent..nn.1
  dagsvärde_1_N = mkN "dagsvärde" ; -- dagsvärde..nn.1
  dagteckna_1_V = mkV "dagtecknar" ; -- dagteckna..vb.1
  dagtecknande_1_N = mkN "dagtecknande" ; -- dagtecknande..nn.1
  dagteckning_1_N = mkN "dagteckning" ; -- dagteckning..nn.1
  dagtid_1_N = mkN "dagtid" "dagtider" ; -- dagtid..nn.1
  dagtinga_1_V = mkV "dagtingar" ; -- dagtinga..vb.1
  dagtingande_1_N = mkN "dagtingande" ; -- dagtingande..nn.1
  dagtraktamente_1_N = mkN "dagtraktamente" ; -- dagtraktamente..nn.1
  dagtåg_1_N = mkN "dagtåg" neutrum  ; -- dagtåg..nn.1
  dagvakt_1_N = mkN "dagvakt" "dagvakter" ; -- dagvakt..nn.1
  dagvatten_1_N = mkN "dagvatten" "dagvattnet" "dagvatten" "dagvattnen" ; -- dagvatten..nn.1
  dagvill_1_A = mkA "dagvill" ; -- dagvill..av.1
  dagvillhet_1_N = mkN "dagvillhet" ; -- dagvillhet..nn.1
  dagvård_1_N = mkN "dagvård" ; -- dagvård..nn.1
  dagöppning_1_N = mkN "dagöppning" ; -- dagöppning..nn.1
  dahlia_1_N = mkN "dahlia" ; -- dahlia..nn.1
  dakapo_1_N = mkN "dakapo" "dakapot" "dakapon" "dakapona" ; -- dakapo..nn.1
  daktyl_1_N = mkN "daktyl" "daktyler" ; -- daktyl..nn.1
  daktylisk_1_A = mkA "daktylisk" ; -- daktylisk..av.1
  dal_1_N = mkN "dal" ; -- dal..nn.1
  dala_1_V = mkV "dalar" ; -- dala..vb.1
  dalahäst_1_N = mkN "dalahäst" ; -- dalahäst..nn.1
  dalamässig_1_A = mkA "dalamässig" ; -- dalamässig..av.1
  dalande_1_N = mkN "dalande" ; -- dalande..nn.1
  dalbo_1_N = mkN "dalbo" "dalbor" ; -- dalbo..nn.1
  dalbotten_1_N = mkN "dalbotten" ; -- dalbotten..nn.1
  daldans_1_N = mkN "daldans" "daldanser" ; -- daldans..nn.1
  daler_1_N = mkN "daler" "dalern" "daler" "dalerna" ; -- daler..nn.1
  dalgång_1_N = mkN "dalgång" ; -- dalgång..nn.1
  dalj_1_N = mkN "dalj" neutrum  ; -- dalj..nn.1
  dalkarl_1_N = mkN "dalkarl" ; -- dalkarl..nn.1
  dalkjusa_1_N = mkN "dalkjusa" ; -- dalkjusa..nn.1
  dalkulla_1_N = mkN "dalkulla" ; -- dalkulla..nn.1
  daller_1_N = mkN "daller" neutrum  ; -- daller..nn.1
  dallergräs_1_N = mkN "dallergräs" neutrum  ; -- dallergräs..nn.1
  dallra_1_V = mkV "dallrar" ; -- dallra..vb.1
  dallrande_1_N = mkN "dallrande" ; -- dallrande..nn.1
  dallring_1_N = mkN "dallring" ; -- dallring..nn.1
  dalmas_1_N = mkN "dalmas" ; -- dalmas..nn.1
  dalmatiner_1_N = mkN "dalmatiner" "dalmatinern" "dalmatiner" "dalmatinerna" ; -- dalmatiner..nn.1
  dalmål_1_N = mkN "dalmål" neutrum  ; -- dalmål..nn.1
  dalmålning_1_N = mkN "dalmålning" ; -- dalmålning..nn.1
  dalning_1_N = mkN "dalning" ; -- dalning..nn.1
  dalprofil_1_N = mkN "dalprofil" "dalprofiler" ; -- dalprofil..nn.1
  dalripa_1_N = mkN "dalripa" ; -- dalripa..nn.1
  dalsk_1_A = mkA "dalsk" ; -- dalsk..av.1
  dalska_1_N = mkN "dalska" ; -- dalska..nn.1
  dalskida_1_N = mkN "dalskida" ; -- dalskida..nn.1
  dalsluttning_1_N = mkN "dalsluttning" ; -- dalsluttning..nn.1
  dalsländsk_1_A = mkA "dalsländsk" ; -- dalsländsk..av.1
  dalsländska_1_N = mkN "dalsländska" ; -- dalsländska..nn.1
  dalsländska_2_N = mkN "dalsländska" ; -- dalsländska..nn.2
  dalslänning_1_N = mkN "dalslänning" ; -- dalslänning..nn.1
  dalsänka_1_N = mkN "dalsänka" ; -- dalsänka..nn.1
  dalt_1_N = mkN "dalt" neutrum  ; -- dalt..nn.1
  dalta_1_V = mkV "daltar" ; -- dalta..vb.1
  daltande_1_N = mkN "daltande" ; -- daltande..nn.1
  dalvind_1_N = mkN "dalvind" ; -- dalvind..nn.1
  dam_1_N = mkN "dam" "damer" ; -- dam..nn.1
  dam_2_N = mkN "dam" ; -- dam..nn.2
  damask_1_N = mkN "damask" "damasker" ; -- damask..nn.1
  damaskenerklinga_1_N = mkN "damaskenerklinga" ; -- damaskenerklinga..nn.1
  damaskenerstål_1_N = mkN "damaskenerstål" neutrum  ; -- damaskenerstål..nn.1
  damaskering_1_N = mkN "damaskering" ; -- damaskering..nn.1
  damast_1_N = mkN "damast" "damaster" ; -- damast..nn.1
  damastduk_1_N = mkN "damastduk" ; -- damastduk..nn.1
  damastservett_1_N = mkN "damastservett" "damastservetter" ; -- damastservett..nn.1
  dambesök_1_N = mkN "dambesök" neutrum  ; -- dambesök..nn.1
  dambinda_1_N = mkN "dambinda" ; -- dambinda..nn.1
  dambjudning_1_N = mkN "dambjudning" ; -- dambjudning..nn.1
  dambricka_1_N = mkN "dambricka" ; -- dambricka..nn.1
  dambräde_1_N = mkN "dambräde" ; -- dambräde..nn.1
  damcykel_1_N = mkN "damcykel" ; -- damcykel..nn.1
  damejeanne_1_N = mkN "damejeanne" "damejeanner" ; -- damejeanne..nn.1
  damfotboll_1_N = mkN "damfotboll" ; -- damfotboll..nn.1
  damfrisering_1_N = mkN "damfrisering" ; -- damfrisering..nn.1
  damfrisör_1_N = mkN "damfrisör" "damfrisörer" ; -- damfrisör..nn.1
  damfrisörska_1_N = mkN "damfrisörska" ; -- damfrisörska..nn.1
  damgambit_1_N = mkN "damgambit" ; -- damgambit..nn.1
  damhandske_1_N = mkN "damhandske" utrum  ; -- damhandske..nn.1
  damhatt_1_N = mkN "damhatt" ; -- damhatt..nn.1
  damig_1_A = mkA "damig" ; -- damig..av.1
  damkonfektion_1_N = mkN "damkonfektion" ; -- damkonfektion..nn.1
  damkör_1_N = mkN "damkör" "damkörer" ; -- damkör..nn.1
  damlag_1_N = mkN "damlag" neutrum  ; -- damlag..nn.1
  damlandslag_1_N = mkN "damlandslag" neutrum  ; -- damlandslag..nn.1
  damm_1_N = mkN "damm" ; -- damm..nn.1
  damm_2_N = mkN "damm" neutrum  ; -- damm..nn.2
  damma_1_V = mkV "dammar" ; -- damma..vb.1
  damma_2_V = mkV "dammar" ; -- damma..vb.2
  dammande_1_N = mkN "dammande" ; -- dammande..nn.1
  dammanläggning_1_N = mkN "dammanläggning" ; -- dammanläggning..nn.1
  dammbindningsmedel_1_N = mkN "dammbindningsmedel" neutrum  ; -- dammbindningsmedel..nn.1
  dammbygge_1_N = mkN "dammbygge" ; -- dammbygge..nn.1
  dammfri_1_A = mkA "dammfri" "dammfritt" ; -- dammfri..av.1
  dammfäste_1_N = mkN "dammfäste" ; -- dammfäste..nn.1
  dammförsök_1_N = mkN "dammförsök" neutrum  ; -- dammförsök..nn.1
  dammgömma_1_N = mkN "dammgömma" ; -- dammgömma..nn.1
  dammig_1_A = mkA "dammig" ; -- dammig..av.1
  dammighet_1_N = mkN "dammighet" ; -- dammighet..nn.1
  dammkorn_1_N = mkN "dammkorn" neutrum  ; -- dammkorn..nn.1
  dammkvalster_1_N = mkN "dammkvalster" neutrum  ; -- dammkvalster..nn.1
  dammlager_1_N = mkN "dammlager" neutrum  ; -- dammlager..nn.1
  dammlucka_1_N = mkN "dammlucka" ; -- dammlucka..nn.1
  dammlunga_1_N = mkN "dammlunga" ; -- dammlunga..nn.1
  dammode_1_N = mkN "dammode" ; -- dammode..nn.1
  dammodell_1_N = mkN "dammodell" "dammodeller" ; -- dammodell..nn.1
  dammoln_1_N = mkN "dammoln" neutrum  ; -- dammoln..nn.1
  dammport_1_N = mkN "dammport" ; -- dammport..nn.1
  dammpump_1_N = mkN "dammpump" ; -- dammpump..nn.1
  dammråtta_1_N = mkN "dammråtta" ; -- dammråtta..nn.1
  dammspiral_1_N = mkN "dammspiral" "dammspiraler" ; -- dammspiral..nn.1
  dammsuga_1_V = mkV "dammsuga" "dammsög" "dammsugit" ; -- dammsuga..vb.1
  dammsugande_1_N = mkN "dammsugande" ; -- dammsugande..nn.1
  dammsugaragent_1_N = mkN "dammsugaragent" "dammsugaragenter" ; -- dammsugaragent..nn.1
  dammsugare_1_N = mkN "dammsugare" utrum  ; -- dammsugare..nn.1
  dammsugarförsäljning_1_N = mkN "dammsugarförsäljning" ; -- dammsugarförsäljning..nn.1
  dammsugarpåse_1_N = mkN "dammsugarpåse" utrum  ; -- dammsugarpåse..nn.1
  dammsugning_1_N = mkN "dammsugning" ; -- dammsugning..nn.1
  dammsäkerhet_1_N = mkN "dammsäkerhet" ; -- dammsäkerhet..nn.1
  dammtorka_1_V = mkV "dammtorkar" ; -- dammtorka..vb.1
  dammtorkande_1_N = mkN "dammtorkande" ; -- dammtorkande..nn.1
  dammtrasa_1_N = mkN "dammtrasa" ; -- dammtrasa..nn.1
  dammussla_1_N = mkN "dammussla" ; -- dammussla..nn.1
  dammvippa_1_N = mkN "dammvippa" ; -- dammvippa..nn.1
  dammvirvel_1_N = mkN "dammvirvel" ; -- dammvirvel..nn.1
  damning_1_N = mkN "damning" ; -- damning..nn.1
  damoklessvärd_1_N = mkN "damoklessvärd" neutrum  ; -- damoklessvärd..nn.1
  dampa_1_V = mkV "dampar" ; -- dampa..vb.1
  dampa_2_V = mkV "dampar" ; -- dampa..vb.2
  dampande_1_N = mkN "dampande" ; -- dampande..nn.1
  dampjäs_1_N = mkN "dampjäs" "dampjäser" ; -- dampjäs..nn.1
  damrum_1_N = mkN "damrum" "damrummet" "damrum" "damrummen" ; -- damrum..nn.1
  damsida_1_N = mkN "damsida" ; -- damsida..nn.1
  damsingel_1_N = mkN "damsingel" ; -- damsingel..nn.1
  damskjorta_1_N = mkN "damskjorta" ; -- damskjorta..nn.1
  damsko_1_N = mkN "damsko" "damskor" ; -- damsko..nn.1
  damslalom_1_N = mkN "damslalom" ; -- damslalom..nn.1
  damspel_1_N = mkN "damspel" "damspelet" "damspel" "damspelen" ; -- damspel..nn.1
  damstrumpa_1_N = mkN "damstrumpa" ; -- damstrumpa..nn.1
  damsällskap_1_N = mkN "damsällskap" neutrum  ; -- damsällskap..nn.1
  damtidning_1_N = mkN "damtidning" ; -- damtidning..nn.1
  damtoalett_1_N = mkN "damtoalett" "damtoaletter" ; -- damtoalett..nn.1
  damur_1_N = mkN "damur" neutrum  ; -- damur..nn.1
  damväska_1_N = mkN "damväska" ; -- damväska..nn.1
  dan_1_A = mkA "dan" ; -- dan..av.1
  dana_1_V = mkV "danar" ; -- dana..vb.1
  danaarv_1_N = mkN "danaarv" neutrum  ; -- danaarv..nn.1
  danad_1_A = mkA "danad" ; -- danad..av.1
  danande_1_N = mkN "danande" ; -- danande..nn.1
  danare_1_N = mkN "danare" utrum  ; -- danare..nn.1
  dandy_1_N = mkN "dandy" "dandyn" "dandysar" "dandysarna" ; -- dandy..nn.1
  dangla_1_V = mkV "danglar" ; -- dangla..vb.1
  danglande_1_N = mkN "danglande" ; -- danglande..nn.1
  daning_1_N = mkN "daning" ; -- daning..nn.1
  danism_1_N = mkN "danism" "danismer" ; -- danism..nn.1
  dank_1_N = mkN "dank" ; -- dank..nn.1
  dann_1_A = mkA "dann" ; -- dann..av.1
  danneman_1_N = mkN "danneman" "dannemannen" "dannemän" "dannemännen" ; -- danneman..nn.1
  dans_1_N = mkN "dans" "danser" ; -- dans..nn.1
  dansa_1_V = mkV "dansar" ; -- dansa..vb.1
  dansande_1_N = mkN "dansande" ; -- dansande..nn.1
  dansant_1_A = mkA "dansant" "dansant" ; -- dansant..av.1
  dansare_1_N = mkN "dansare" utrum  ; -- dansare..nn.1
  dansbana_1_N = mkN "dansbana" ; -- dansbana..nn.1
  dansband_1_N = mkN "dansband" neutrum  ; -- dansband..nn.1
  dansbandskultur_1_N = mkN "dansbandskultur" "dansbandskulturer" ; -- dansbandskultur..nn.1
  dansbandsvecka_1_N = mkN "dansbandsvecka" ; -- dansbandsvecka..nn.1
  dansbaneelände_1_N = mkN "dansbaneelände" ; -- dansbaneelände..nn.1
  danserska_1_N = mkN "danserska" ; -- danserska..nn.1
  dansförbud_1_N = mkN "dansförbud" neutrum  ; -- dansförbud..nn.1
  dansgille_1_N = mkN "dansgille" ; -- dansgille..nn.1
  dansgolv_1_N = mkN "dansgolv" neutrum  ; -- dansgolv..nn.1
  dansgolvslejon_1_N = mkN "dansgolvslejon" neutrum  ; -- dansgolvslejon..nn.1
  danshak_1_N = mkN "danshak" neutrum  ; -- danshak..nn.1
  dansk_1_A = mkA "dansk" ; -- dansk..av.1
  dansk_1_N = mkN "dansk" ; -- dansk..nn.1
  danska_1_N = mkN "danska" ; -- danska..nn.1
  danska_2_N = mkN "danska" ; -- danska..nn.2
  danskhat_1_N = mkN "danskhat" neutrum  ; -- danskhat..nn.1
  danskhet_1_N = mkN "danskhet" ; -- danskhet..nn.1
  danskonst_1_N = mkN "danskonst" "danskonster" ; -- danskonst..nn.1
  dansktalande_1_A = mkA "dansktalande" ; -- dansktalande..av.1
  danskägd_1_A = mkA "danskägd" "danskägt" ; -- danskägd..av.1
  dansledare_1_N = mkN "dansledare" utrum  ; -- dansledare..nn.1
  danslek_1_N = mkN "danslek" ; -- danslek..nn.1
  danslektion_1_N = mkN "danslektion" ; -- danslektion..nn.1
  danslysten_1_A = mkA "danslysten" ; -- danslysten..av.1
  dansmusik_1_N = mkN "dansmusik" ; -- dansmusik..nn.1
  dansmässig_1_A = mkA "dansmässig" ; -- dansmässig..av.1
  dansmästare_1_N = mkN "dansmästare" utrum  ; -- dansmästare..nn.1
  dansorkester_1_N = mkN "dansorkester" ; -- dansorkester..nn.1
  dansrestaurang_1_N = mkN "dansrestaurang" "dansrestauranger" ; -- dansrestaurang..nn.1
  dansrytm_1_N = mkN "dansrytm" "dansrytmer" ; -- dansrytm..nn.1
  danssalong_1_N = mkN "danssalong" "danssalonger" ; -- danssalong..nn.1
  danssjuka_1_N = mkN "danssjuka" ; -- danssjuka..nn.1
  danssko_1_N = mkN "danssko" "dansskor" ; -- danssko..nn.1
  dansskola_1_N = mkN "dansskola" ; -- dansskola..nn.1
  danssteg_1_N = mkN "danssteg" neutrum  ; -- danssteg..nn.1
  dansställe_1_N = mkN "dansställe" ; -- dansställe..nn.1
  danstakt_1_N = mkN "danstakt" "danstakter" ; -- danstakt..nn.1
  danstillställning_1_N = mkN "danstillställning" ; -- danstillställning..nn.1
  dansundervisning_1_N = mkN "dansundervisning" ; -- dansundervisning..nn.1
  dansvimmel_1_N = mkN "dansvimmel" neutrum  ; -- dansvimmel..nn.1
  dansvänlig_1_A = mkA "dansvänlig" ; -- dansvänlig..av.1
  dansör_1_N = mkN "dansör" "dansörer" ; -- dansör..nn.1
  dansös_1_N = mkN "dansös" "dansöser" ; -- dansös..nn.1
  darr_1_N = mkN "darr" neutrum  ; -- darr..nn.1
  darra_1_V = mkV "darrar" ; -- darra..vb.1
  darrande_1_A = mkA "darrande" ; -- darrande..av.1
  darrande_1_N = mkN "darrande" ; -- darrande..nn.1
  darrgräs_1_N = mkN "darrgräs" neutrum  ; -- darrgräs..nn.1
  darrhänt_1_A = mkA "darrhänt" "darrhänt" ; -- darrhänt..av.1
  darrhänthet_1_N = mkN "darrhänthet" ; -- darrhänthet..nn.1
  darrig_1_A = mkA "darrig" ; -- darrig..av.1
  darrighet_1_N = mkN "darrighet" ; -- darrighet..nn.1
  darrning_1_N = mkN "darrning" ; -- darrning..nn.1
  darrocka_1_N = mkN "darrocka" ; -- darrocka..nn.1
  darrål_1_N = mkN "darrål" ; -- darrål..nn.1
  dart_1_N = mkN "dart" ; -- dart..nn.1
  dartpil_1_N = mkN "dartpil" ; -- dartpil..nn.1
  dartspel_1_N = mkN "dartspel" "dartspelet" "dartspel" "dartspelen" ; -- dartspel..nn.1
  darttavla_1_N = mkN "darttavla" ; -- darttavla..nn.1
  darwinfink_1_N = mkN "darwinfink" ; -- darwinfink..nn.1
  darwinism_1_N = mkN "darwinism" "darwinismer" ; -- darwinism..nn.1
  darwinist_1_N = mkN "darwinist" "darwinister" ; -- darwinist..nn.1
  darwinistisk_1_A = mkA "darwinistisk" ; -- darwinistisk..av.1
  dask_1_N = mkN "dask" neutrum  ; -- dask..nn.1
  daska_1_V = mkV "daskar" ; -- daska..vb.1
  daskande_1_N = mkN "daskande" ; -- daskande..nn.1
  daskig_1_A = mkA "daskig" ; -- daskig..av.1
  daskighet_1_N = mkN "daskighet" ; -- daskighet..nn.1
  dass_1_N = mkN "dass" neutrum  ; -- dass..nn.1
  dassa_1_V = mkV "dassar" ; -- dassa..vb.1
  dassande_1_N = mkN "dassande" ; -- dassande..nn.1
  dassig_1_A = mkA "dassig" ; -- dassig..av.1
  dassighet_1_N = mkN "dassighet" ; -- dassighet..nn.1
  dasspapper_1_N = mkN "dasspapper" neutrum  ; -- dasspapper..nn.1
  dat_1_N = mkN "dat" "dater" ; -- dat..nn.1
  data_1_N = mkN "data" "datat" "data" "datana" ; -- data..nn.1
  data_2_N = mkN "data" ; -- data..nn.2
  dataanläggning_1_N = mkN "dataanläggning" ; -- dataanläggning..nn.1
  databank_1_N = mkN "databank" "databanker" ; -- databank..nn.1
  databas_1_N = mkN "databas" "databaser" ; -- databas..nn.1
  databearbetning_1_N = mkN "databearbetning" ; -- databearbetning..nn.1
  databehandla_1_V = mkV "databehandlar" ; -- databehandla..vb.1
  databehandlande_1_N = mkN "databehandlande" ; -- databehandlande..nn.1
  databehandling_1_N = mkN "databehandling" ; -- databehandling..nn.1
  datacentral_1_N = mkN "datacentral" "datacentraler" ; -- datacentral..nn.1
  datafil_1_N = mkN "datafil" "datafiler" ; -- datafil..nn.1
  dataformat_1_N = mkN "dataformat" neutrum  ; -- dataformat..nn.1
  datahackare_1_N = mkN "datahackare" utrum  ; -- datahackare..nn.1
  datahaveri_1_N = mkN "datahaveri" "datahaveriet" "datahaverier" "datahaverierna" ; -- datahaveri..nn.1
  datainsamling_1_N = mkN "datainsamling" ; -- datainsamling..nn.1
  datainsamlingskampanj_1_N = mkN "datainsamlingskampanj" "datainsamlingskampanjer" ; -- datainsamlingskampanj..nn.1
  dataintensiv_1_A = mkA "dataintensiv" ; -- dataintensiv..av.1
  dataintrång_1_N = mkN "dataintrång" neutrum  ; -- dataintrång..nn.1
  dataintrångsskandal_1_N = mkN "dataintrångsskandal" "dataintrångsskandaler" ; -- dataintrångsskandal..nn.1
  datakommunikation_1_N = mkN "datakommunikation" ; -- datakommunikation..nn.1
  datakraft_1_N = mkN "datakraft" ; -- datakraft..nn.1
  datakrasch_1_N = mkN "datakrasch" "datakrascher" ; -- datakrasch..nn.1
  datakörning_1_N = mkN "datakörning" ; -- datakörning..nn.1
  datalagring_1_N = mkN "datalagring" ; -- datalagring..nn.1
  datalagringsdirektiv_1_N = mkN "datalagringsdirektiv" neutrum  ; -- datalagringsdirektiv..nn.1
  datalagringsföretag_1_N = mkN "datalagringsföretag" neutrum  ; -- datalagringsföretag..nn.1
  datalingvistik_1_N = mkN "datalingvistik" ; -- datalingvistik..nn.1
  datalogi_1_N = mkN "datalogi" ; -- datalogi..nn.1
  datamaskin_1_N = mkN "datamaskin" "datamaskiner" ; -- datamaskin..nn.1
  datamaskinell_1_A = mkA "datamaskinell" ; -- datamaskinell..av.1
  datamaterial_1_N = mkN "datamaterial" neutrum  ; -- datamaterial..nn.1
  dataminne_1_N = mkN "dataminne" ; -- dataminne..nn.1
  datamängd_1_N = mkN "datamängd" "datamängder" ; -- datamängd..nn.1
  datanät_1_N = mkN "datanät" neutrum  ; -- datanät..nn.1
  datapolitik_1_N = mkN "datapolitik" ; -- datapolitik..nn.1
  datapolitisk_1_A = mkA "datapolitisk" ; -- datapolitisk..av.1
  dataprogram_1_N = mkN "dataprogram" "dataprogrammet" "dataprogram" "dataprogrammen" ; -- dataprogram..nn.1
  dataregister_1_N = mkN "dataregister" neutrum  ; -- dataregister..nn.1
  datasimulering_1_N = mkN "datasimulering" ; -- datasimulering..nn.1
  dataskärm_1_N = mkN "dataskärm" ; -- dataskärm..nn.1
  dataspel_1_N = mkN "dataspel" "dataspelet" "dataspel" "dataspelen" ; -- dataspel..nn.1
  datasystem_1_N = mkN "datasystem" neutrum  ; -- datasystem..nn.1
  dataterminal_1_N = mkN "dataterminal" "dataterminaler" ; -- dataterminal..nn.1
  datautbyte_1_N = mkN "datautbyte" ; -- datautbyte..nn.1
  datautbytesöverenskommelse_1_N = mkN "datautbytesöverenskommelse" "datautbytesöverenskommelser" ; -- datautbytesöverenskommelse..nn.1
  datavirus_1_N = mkN "datavirus" neutrum  ; -- datavirus..nn.1
  datavision_1_N = mkN "datavision" ; -- datavision..nn.1
  date_1_N = mkN "date" "dater" ; -- date..nn.1
  datera_1_V = mkV "daterar" ; -- datera..vb.1
  daterande_1_N = mkN "daterande" ; -- daterande..nn.1
  daterbar_1_A = mkA "daterbar" ; -- daterbar..av.1
  daterbarhet_1_N = mkN "daterbarhet" ; -- daterbarhet..nn.1
  datering_1_N = mkN "datering" ; -- datering..nn.1
  dateringsmetod_1_N = mkN "dateringsmetod" "dateringsmetoder" ; -- dateringsmetod..nn.1
  dativ_1_N = mkN "dativ" "dativer" ; -- dativ..nn.1
  dativform_1_N = mkN "dativform" "dativformer" ; -- dativform..nn.1
  dativobjekt_1_N = mkN "dativobjekt" neutrum  ; -- dativobjekt..nn.1
  dato_1_N = mkN "dato" ; -- dato..nn.1
  dator_1_N = mkN "dator" "datorer" ; -- dator..nn.1
  datoradress_1_N = mkN "datoradress" "datoradresser" ; -- datoradress..nn.1
  datoranimera_1_V = mkV "datoranimerar" ; -- datoranimera..vb.1
  datoranimerad_1_A = mkA "datoranimerad" ; -- datoranimerad..av.1
  datoranimerande_1_N = mkN "datoranimerande" ; -- datoranimerande..nn.1
  datoranimering_1_N = mkN "datoranimering" ; -- datoranimering..nn.1
  datoranläggning_1_N = mkN "datoranläggning" ; -- datoranläggning..nn.1
  datorbaserad_1_A = mkA "datorbaserad" ; -- datorbaserad..av.1
  datorbearbetning_1_N = mkN "datorbearbetning" ; -- datorbearbetning..nn.1
  datorbehandling_1_N = mkN "datorbehandling" ; -- datorbehandling..nn.1
  datorberäkning_1_N = mkN "datorberäkning" ; -- datorberäkning..nn.1
  datordrift_1_N = mkN "datordrift" ; -- datordrift..nn.1
  datorfodral_1_N = mkN "datorfodral" neutrum  ; -- datorfodral..nn.1
  datorförsäljning_1_N = mkN "datorförsäljning" ; -- datorförsäljning..nn.1
  datorhaveri_1_N = mkN "datorhaveri" "datorhaveriet" "datorhaverier" "datorhaverierna" ; -- datorhaveri..nn.1
  datorintrång_1_N = mkN "datorintrång" neutrum  ; -- datorintrång..nn.1
  datorisera_1_V = mkV "datoriserar" ; -- datorisera..vb.1
  datoriserande_1_N = mkN "datoriserande" ; -- datoriserande..nn.1
  datoriserbar_1_A = mkA "datoriserbar" ; -- datoriserbar..av.1
  datoriserbarhet_1_N = mkN "datoriserbarhet" ; -- datoriserbarhet..nn.1
  datorisering_1_N = mkN "datorisering" ; -- datorisering..nn.1
  datorkommunikation_1_N = mkN "datorkommunikation" ; -- datorkommunikation..nn.1
  datorkraft_1_N = mkN "datorkraft" ; -- datorkraft..nn.1
  datorlingvistik_1_N = mkN "datorlingvistik" ; -- datorlingvistik..nn.1
  datorminne_1_N = mkN "datorminne" ; -- datorminne..nn.1
  datormodell_1_N = mkN "datormodell" "datormodeller" ; -- datormodell..nn.1
  datormässa_1_N = mkN "datormässa" ; -- datormässa..nn.1
  datorprogram_1_N = mkN "datorprogram" "datorprogrammet" "datorprogram" "datorprogrammen" ; -- datorprogram..nn.1
  datorprogrammerare_1_N = mkN "datorprogrammerare" utrum  ; -- datorprogrammerare..nn.1
  datorrelaterad_1_A = mkA "datorrelaterad" ; -- datorrelaterad..av.1
  datorsimulera_1_V = mkV "datorsimulerar" ; -- datorsimulera..vb.1
  datorsimulerande_1_N = mkN "datorsimulerande" ; -- datorsimulerande..nn.1
  datorsimulering_1_N = mkN "datorsimulering" ; -- datorsimulering..nn.1
  datorskärm_1_N = mkN "datorskärm" ; -- datorskärm..nn.1
  datorsladd_1_N = mkN "datorsladd" ; -- datorsladd..nn.1
  datorstöd_1_N = mkN "datorstöd" neutrum  ; -- datorstöd..nn.1
  datorsystem_1_N = mkN "datorsystem" neutrum  ; -- datorsystem..nn.1
  datortelefon_1_N = mkN "datortelefon" "datortelefoner" ; -- datortelefon..nn.1
  datortomografi_1_N = mkN "datortomografi" "datortomografier" ; -- datortomografi..nn.1
  datorutrustning_1_N = mkN "datorutrustning" ; -- datorutrustning..nn.1
  datorvirus_1_N = mkN "datorvirus" neutrum  ; -- datorvirus..nn.1
  datorväxel_1_N = mkN "datorväxel" ; -- datorväxel..nn.1
  datta_1_V = mkV "dattar" ; -- datta..vb.1
  dattande_1_N = mkN "dattande" ; -- dattande..nn.1
  datten_1_N = mkN "datten" ; -- datten..nn.1
  datum_1_N = mkN "datum" ; -- datum..nn.1
  datumgräns_1_N = mkN "datumgräns" "datumgränser" ; -- datumgräns..nn.1
  datummärka_1_V = mkV "datummärker" ; -- datummärka..vb.1
  datummärkande_1_N = mkN "datummärkande" ; -- datummärkande..nn.1
  datummärkning_1_N = mkN "datummärkning" ; -- datummärkning..nn.1
  datumparkera_1_V = mkV "datumparkerar" ; -- datumparkera..vb.1
  datumparkerande_1_N = mkN "datumparkerande" ; -- datumparkerande..nn.1
  datumparkerbar_1_A = mkA "datumparkerbar" ; -- datumparkerbar..av.1
  datumparkerbarhet_1_N = mkN "datumparkerbarhet" ; -- datumparkerbarhet..nn.1
  datumparkering_1_N = mkN "datumparkering" ; -- datumparkering..nn.1
  datumstämpel_1_N = mkN "datumstämpel" ; -- datumstämpel..nn.1
  datumvisare_1_N = mkN "datumvisare" utrum  ; -- datumvisare..nn.1
  davidsstjärna_1_N = mkN "davidsstjärna" ; -- davidsstjärna..nn.1
  deadline_1_N = mkN "deadline" utrum  ; -- deadline..nn.1
  deaktivera_1_V = mkV "deaktiverar" ; -- deaktivera..vb.1
  deaktiverande_1_N = mkN "deaktiverande" ; -- deaktiverande..nn.1
  deaktiverbar_1_A = mkA "deaktiverbar" ; -- deaktiverbar..av.1
  deaktiverbarhet_1_N = mkN "deaktiverbarhet" ; -- deaktiverbarhet..nn.1
  deaktivering_1_N = mkN "deaktivering" ; -- deaktivering..nn.1
  debacle_1_N = mkN "debacle" "debaclet" "debacle" "debaclen" ; -- debacle..nn.1
  debarkera_1_V = mkV "debarkerar" ; -- debarkera..vb.1
  debarkerande_1_N = mkN "debarkerande" ; -- debarkerande..nn.1
  debarkerbar_1_A = mkA "debarkerbar" ; -- debarkerbar..av.1
  debarkerbarhet_1_N = mkN "debarkerbarhet" ; -- debarkerbarhet..nn.1
  debarkering_1_N = mkN "debarkering" ; -- debarkering..nn.1
  debatt_1_N = mkN "debatt" "debatter" ; -- debatt..nn.1
  debattartikel_1_N = mkN "debattartikel" ; -- debattartikel..nn.1
  debattdeltagare_1_N = mkN "debattdeltagare" utrum  ; -- debattdeltagare..nn.1
  debattera_1_V = mkV "debatterar" ; -- debattera..vb.1
  debatterande_1_N = mkN "debatterande" ; -- debatterande..nn.1
  debatterbar_1_A = mkA "debatterbar" ; -- debatterbar..av.1
  debatterbarhet_1_N = mkN "debatterbarhet" ; -- debatterbarhet..nn.1
  debattering_1_N = mkN "debattering" ; -- debattering..nn.1
  debattforum_1_N = mkN "debattforum" neutrum  ; -- debattforum..nn.1
  debattinlägg_1_N = mkN "debattinlägg" neutrum  ; -- debattinlägg..nn.1
  debattknep_1_N = mkN "debattknep" neutrum  ; -- debattknep..nn.1
  debattmässig_1_A = mkA "debattmässig" ; -- debattmässig..av.1
  debattprogram_1_N = mkN "debattprogram" "debattprogrammet" "debattprogram" "debattprogrammen" ; -- debattprogram..nn.1
  debattsida_1_N = mkN "debattsida" ; -- debattsida..nn.1
  debattör_1_N = mkN "debattör" "debattörer" ; -- debattör..nn.1
  debet_1_N = mkN "debet" ; -- debet..nn.1
  debetsedel_1_N = mkN "debetsedel" ; -- debetsedel..nn.1
  debetsida_1_N = mkN "debetsida" ; -- debetsida..nn.1
  debetsumma_1_N = mkN "debetsumma" ; -- debetsumma..nn.1
  debil_1_A = mkA "debil" ; -- debil..av.1
  debilitet_1_N = mkN "debilitet" "debiliteter" ; -- debilitet..nn.1
  debit_1_N = mkN "debit" "debiter" ; -- debit..nn.1
  debitera_1_V = mkV "debiterar" ; -- debitera..vb.1
  debiterande_1_N = mkN "debiterande" ; -- debiterande..nn.1
  debiterbar_1_A = mkA "debiterbar" ; -- debiterbar..av.1
  debiterbarhet_1_N = mkN "debiterbarhet" ; -- debiterbarhet..nn.1
  debitering_1_N = mkN "debitering" ; -- debitering..nn.1
  debut_1_N = mkN "debut" "debuter" ; -- debut..nn.1
  debutalbum_1_N = mkN "debutalbum" neutrum  ; -- debutalbum..nn.1
  debutant_1_N = mkN "debutant" "debutanter" ; -- debutant..nn.1
  debutbok_1_N = mkN "debutbok" "debutböcker" ; -- debutbok..nn.1
  debutera_1_V = mkV "debuterar" ; -- debutera..vb.1
  debuterande_1_N = mkN "debuterande" ; -- debuterande..nn.1
  debutering_1_N = mkN "debutering" ; -- debutering..nn.1
  debutroman_1_N = mkN "debutroman" "debutromaner" ; -- debutroman..nn.1
  december_1_N = mkN "december" ; -- december..nn.1
  decemberkväll_1_N = mkN "decemberkväll" ; -- decemberkväll..nn.1
  decennium_1_N = mkN "decennium" "decenniet" "decennier" "decennierna" ; -- decennium..nn.1
  decentralisation_1_N = mkN "decentralisation" ; -- decentralisation..nn.1
  decentralisera_1_V = mkV "decentraliserar" ; -- decentralisera..vb.1
  decentraliserande_1_N = mkN "decentraliserande" ; -- decentraliserande..nn.1
  decentraliserbar_1_A = mkA "decentraliserbar" ; -- decentraliserbar..av.1
  decentraliserbarhet_1_N = mkN "decentraliserbarhet" ; -- decentraliserbarhet..nn.1
  decentralisering_1_N = mkN "decentralisering" ; -- decentralisering..nn.1
  decharge_1_N = mkN "decharge" "decharger" ; -- decharge..nn.1
  dechargedebatt_1_N = mkN "dechargedebatt" "dechargedebatter" ; -- dechargedebatt..nn.1
  dechiffrera_1_V = mkV "dechiffrerar" ; -- dechiffrera..vb.1
  dechiffrerande_1_N = mkN "dechiffrerande" ; -- dechiffrerande..nn.1
  dechiffrerbar_1_A = mkA "dechiffrerbar" ; -- dechiffrerbar..av.1
  dechiffrerbarhet_1_N = mkN "dechiffrerbarhet" ; -- dechiffrerbarhet..nn.1
  dechiffrering_1_N = mkN "dechiffrering" ; -- dechiffrering..nn.1
  decibel_1_N = mkN "decibel" "decibelen" "decibel" "decibelen" ; -- decibel..nn.1
  deciderad_1_A = mkA "deciderad" ; -- deciderad..av.1
  deciliter_1_N = mkN "deciliter" "decilitern" "deciliter" "deciliterna" ; -- deciliter..nn.1
  decilitermått_1_N = mkN "decilitermått" neutrum  ; -- decilitermått..nn.1
  decimal_1_N = mkN "decimal" "decimaler" ; -- decimal..nn.1
  decimalbråk_1_N = mkN "decimalbråk" neutrum  ; -- decimalbråk..nn.1
  decimalkomma_1_N = mkN "decimalkomma" "decimalkommat" "decimalkomman" "decimalkommana" ; -- decimalkomma..nn.1
  decimalsystem_1_N = mkN "decimalsystem" neutrum  ; -- decimalsystem..nn.1
  decimaltal_1_N = mkN "decimaltal" neutrum  ; -- decimaltal..nn.1
  decimaltecken_1_N = mkN "decimaltecken" "decimaltecknet" "decimaltecken" "decimaltecknen" ; -- decimaltecken..nn.1
  decimera_1_V = mkV "decimerar" ; -- decimera..vb.1
  decimerande_1_N = mkN "decimerande" ; -- decimerande..nn.1
  decimerbar_1_A = mkA "decimerbar" ; -- decimerbar..av.1
  decimerbarhet_1_N = mkN "decimerbarhet" ; -- decimerbarhet..nn.1
  decimering_1_N = mkN "decimering" ; -- decimering..nn.1
  decimeter_1_N = mkN "decimeter" ; -- decimeter..nn.1
  decimeterlång_1_A = mkA "decimeterlång" ; -- decimeterlång..av.1
  decimeterstor_1_A = mkA "decimeterstor" ; -- decimeterstor..av.1
  deciton_1_N = mkN "deciton" "decitonnet" "deciton" "decitonnen" ; -- deciton..nn.1
  deckardrottning_1_N = mkN "deckardrottning" ; -- deckardrottning..nn.1
  deckare_1_N = mkN "deckare" utrum  ; -- deckare..nn.1
  deckarförfattare_1_N = mkN "deckarförfattare" utrum  ; -- deckarförfattare..nn.1
  deckarkung_1_N = mkN "deckarkung" ; -- deckarkung..nn.1
  dedicera_1_V = mkV "dedicerar" ; -- dedicera..vb.1
  dedicerande_1_N = mkN "dedicerande" ; -- dedicerande..nn.1
  dedicerbar_1_A = mkA "dedicerbar" ; -- dedicerbar..av.1
  dedicerbarhet_1_N = mkN "dedicerbarhet" ; -- dedicerbarhet..nn.1
  dedicering_1_N = mkN "dedicering" ; -- dedicering..nn.1
  dedikation_1_N = mkN "dedikation" ; -- dedikation..nn.1
  dedikationsexemplar_1_N = mkN "dedikationsexemplar" neutrum  ; -- dedikationsexemplar..nn.1
  dedikera_1_V = mkV "dedikerar" ; -- dedikera..vb.1
  dedikerande_1_N = mkN "dedikerande" ; -- dedikerande..nn.1
  dedikerbar_1_A = mkA "dedikerbar" ; -- dedikerbar..av.1
  dedikerbarhet_1_N = mkN "dedikerbarhet" ; -- dedikerbarhet..nn.1
  dedikering_1_N = mkN "dedikering" ; -- dedikering..nn.1
  deducera_1_V = mkV "deducerar" ; -- deducera..vb.1
  deducerande_1_N = mkN "deducerande" ; -- deducerande..nn.1
  deducerbar_1_A = mkA "deducerbar" ; -- deducerbar..av.1
  deducerbarhet_1_N = mkN "deducerbarhet" ; -- deducerbarhet..nn.1
  deducering_1_N = mkN "deducering" ; -- deducering..nn.1
  deduktion_1_N = mkN "deduktion" ; -- deduktion..nn.1
  deduktiv_1_A = mkA "deduktiv" ; -- deduktiv..av.1
  defaitism_1_N = mkN "defaitism" "defaitismer" ; -- defaitism..nn.1
  defaitist_1_N = mkN "defaitist" "defaitister" ; -- defaitist..nn.1
  defaitistisk_1_A = mkA "defaitistisk" ; -- defaitistisk..av.1
  defekt_1_A = mkA "defekt" "defekt" ; -- defekt..av.1
  defekt_1_N = mkN "defekt" "defekter" ; -- defekt..nn.1
  defenestrera_1_V = mkV "defenestrerar" ; -- defenestrera..vb.1
  defenestrerande_1_N = mkN "defenestrerande" ; -- defenestrerande..nn.1
  defenestrering_1_N = mkN "defenestrering" ; -- defenestrering..nn.1
  defensiv_1_A = mkA "defensiv" ; -- defensiv..av.1
  defensiv_1_N = mkN "defensiv" ; -- defensiv..nn.1
  defibrillator_1_N = mkN "defibrillator" "defibrillatorer" ; -- defibrillator..nn.1
  deficit_1_N = mkN "deficit" neutrum  ; -- deficit..nn.1
  defilera_1_V = mkV "defilerar" ; -- defilera..vb.1
  defilerande_1_N = mkN "defilerande" ; -- defilerande..nn.1
  defilerbar_1_A = mkA "defilerbar" ; -- defilerbar..av.1
  defilerbarhet_1_N = mkN "defilerbarhet" ; -- defilerbarhet..nn.1
  defilering_1_N = mkN "defilering" ; -- defilering..nn.1
  defilé_1_N = mkN "defilé" "defiléer" ; -- defilé..nn.1
  definiera_1_V = mkV "definierar" ; -- definiera..vb.1
  definierande_1_N = mkN "definierande" ; -- definierande..nn.1
  definierbar_1_A = mkA "definierbar" ; -- definierbar..av.1
  definierbarhet_1_N = mkN "definierbarhet" ; -- definierbarhet..nn.1
  definiering_1_N = mkN "definiering" ; -- definiering..nn.1
  definit_1_A = mkA "definit" "definit" ; -- definit..av.1
  definithet_1_N = mkN "definithet" ; -- definithet..nn.1
  definition_1_N = mkN "definition" ; -- definition..nn.1
  definitionsmängd_1_N = mkN "definitionsmängd" "definitionsmängder" ; -- definitionsmängd..nn.1
  definitionsmässig_1_A = mkA "definitionsmässig" ; -- definitionsmässig..av.1
  definitionsmässighet_1_N = mkN "definitionsmässighet" ; -- definitionsmässighet..nn.1
  definitiv_1_A = mkA "definitiv" ; -- definitiv..av.1
  deflagration_1_N = mkN "deflagration" ; -- deflagration..nn.1
  deflation_1_N = mkN "deflation" ; -- deflation..nn.1
  defloration_1_N = mkN "defloration" ; -- defloration..nn.1
  deflorera_1_V = mkV "deflorerar" ; -- deflorera..vb.1
  deflorerande_1_N = mkN "deflorerande" ; -- deflorerande..nn.1
  deflorerbar_1_A = mkA "deflorerbar" ; -- deflorerbar..av.1
  deflorerbarhet_1_N = mkN "deflorerbarhet" ; -- deflorerbarhet..nn.1
  deflorering_1_N = mkN "deflorering" ; -- deflorering..nn.1
  deformation_1_N = mkN "deformation" ; -- deformation..nn.1
  deformera_1_V = mkV "deformerar" ; -- deformera..vb.1
  deformerande_1_N = mkN "deformerande" ; -- deformerande..nn.1
  deformerbar_1_A = mkA "deformerbar" ; -- deformerbar..av.1
  deformerbarhet_1_N = mkN "deformerbarhet" ; -- deformerbarhet..nn.1
  deformering_1_N = mkN "deformering" ; -- deformering..nn.1
  deformitet_1_N = mkN "deformitet" "deformiteter" ; -- deformitet..nn.1
  defroster_1_N = mkN "defroster" ; -- defroster..nn.1
  deg_1_N = mkN "deg" ; -- deg..nn.1
  deg_2_N = mkN "deg" ; -- deg..nn.2
  dega_1_V = mkV "degar" ; -- dega..vb.1
  degande_1_N = mkN "degande" ; -- degande..nn.1
  degartad_1_A = mkA "degartad" ; -- degartad..av.1
  degel_1_N = mkN "degel" ; -- degel..nn.1
  degeneration_1_N = mkN "degeneration" ; -- degeneration..nn.1
  degenerativ_1_A = mkA "degenerativ" ; -- degenerativ..av.1
  degenerera_1_V = mkV "degenererar" ; -- degenerera..vb.1
  degenererande_1_N = mkN "degenererande" ; -- degenererande..nn.1
  degenererbar_1_A = mkA "degenererbar" ; -- degenererbar..av.1
  degenererbarhet_1_N = mkN "degenererbarhet" ; -- degenererbarhet..nn.1
  degenerering_1_N = mkN "degenerering" ; -- degenerering..nn.1
  degig_1_A = mkA "degig" ; -- degig..av.1
  deglaciation_1_N = mkN "deglaciation" ; -- deglaciation..nn.1
  dego_1_N = mkN "dego" "degon" "degos" "degosarna" ; -- dego..nn.1
  degradation_1_N = mkN "degradation" ; -- degradation..nn.1
  degradera_1_V = mkV "degraderar" ; -- degradera..vb.1
  degraderande_1_N = mkN "degraderande" ; -- degraderande..nn.1
  degraderbar_1_A = mkA "degraderbar" ; -- degraderbar..av.1
  degraderbarhet_1_N = mkN "degraderbarhet" ; -- degraderbarhet..nn.1
  degradering_1_N = mkN "degradering" ; -- degradering..nn.1
  degrand_1_N = mkN "degrand" "degränder" ; -- degrand..nn.1
  degression_1_N = mkN "degression" ; -- degression..nn.1
  degspad_1_N = mkN "degspad" neutrum  ; -- degspad..nn.1
  degspade_1_N = mkN "degspade" utrum  ; -- degspade..nn.1
  degustera_1_V = mkV "degusterar" ; -- degustera..vb.1
  degusterande_1_N = mkN "degusterande" ; -- degusterande..nn.1
  degustering_1_N = mkN "degustering" ; -- degustering..nn.1
  deiktisk_1_A = mkA "deiktisk" ; -- deiktisk..av.1
  deism_1_N = mkN "deism" "deismer" ; -- deism..nn.1
  deist_1_N = mkN "deist" "deister" ; -- deist..nn.1
  deistisk_1_A = mkA "deistisk" ; -- deistisk..av.1
  deja_1_N = mkN "deja" ; -- deja..nn.1
  dejlig_1_A = mkA "dejlig" ; -- dejlig..av.1
  dejlighet_1_N = mkN "dejlighet" ; -- dejlighet..nn.1
  dejsa_1_V = mkV "dejsar" ; -- dejsa..vb.1
  dejsande_1_N = mkN "dejsande" ; -- dejsande..nn.1
  dejt_1_N = mkN "dejt" ; -- dejt..nn.1
  dejta_1_V = mkV "dejtar" ; -- dejta..vb.1
  dejtande_1_N = mkN "dejtande" ; -- dejtande..nn.1
  dejting_1_N = mkN "dejting" ; -- dejting..nn.1
  dejtingsajt_1_N = mkN "dejtingsajt" "dejtingsajter" ; -- dejtingsajt..nn.1
  dejtingtips_1_N = mkN "dejtingtips" neutrum  ; -- dejtingtips..nn.1
  dekad_1_N = mkN "dekad" "dekader" ; -- dekad..nn.1
  dekadans_1_N = mkN "dekadans" ; -- dekadans..nn.1
  dekadens_1_N = mkN "dekadens" ; -- dekadens..nn.1
  dekadent_1_A = mkA "dekadent" "dekadent" ; -- dekadent..av.1
  dekadisk_1_A = mkA "dekadisk" ; -- dekadisk..av.1
  dekal_1_N = mkN "dekal" "dekaler" ; -- dekal..nn.1
  dekalkomani_1_N = mkN "dekalkomani" ; -- dekalkomani..nn.1
  dekalog_1_N = mkN "dekalog" ; -- dekalog..nn.1
  dekan_1_N = mkN "dekan" "dekaner" ; -- dekan..nn.1
  dekanat_1_N = mkN "dekanat" neutrum  ; -- dekanat..nn.1
  dekantera_1_V = mkV "dekanterar" ; -- dekantera..vb.1
  dekanterande_1_N = mkN "dekanterande" ; -- dekanterande..nn.1
  dekanterbar_1_A = mkA "dekanterbar" ; -- dekanterbar..av.1
  dekanterbarhet_1_N = mkN "dekanterbarhet" ; -- dekanterbarhet..nn.1
  dekantering_1_N = mkN "dekantering" ; -- dekantering..nn.1
  dekanus_1_N = mkN "dekanus" ; -- dekanus..nn.1
  dekapitera_1_V = mkV "dekapiterar" ; -- dekapitera..vb.1
  dekapiterande_1_N = mkN "dekapiterande" ; -- dekapiterande..nn.1
  dekapiterbar_1_A = mkA "dekapiterbar" ; -- dekapiterbar..av.1
  dekapiterbarhet_1_N = mkN "dekapiterbarhet" ; -- dekapiterbarhet..nn.1
  dekapitering_1_N = mkN "dekapitering" ; -- dekapitering..nn.1
  deklamation_1_N = mkN "deklamation" ; -- deklamation..nn.1
  deklamatorisk_1_A = mkA "deklamatorisk" ; -- deklamatorisk..av.1
  deklamatör_1_N = mkN "deklamatör" "deklamatörer" ; -- deklamatör..nn.1
  deklamera_1_V = mkV "deklamerar" ; -- deklamera..vb.1
  deklamerande_1_N = mkN "deklamerande" ; -- deklamerande..nn.1
  deklamerbar_1_A = mkA "deklamerbar" ; -- deklamerbar..av.1
  deklamerbarhet_1_N = mkN "deklamerbarhet" ; -- deklamerbarhet..nn.1
  deklamering_1_N = mkN "deklamering" ; -- deklamering..nn.1
  deklarant_1_N = mkN "deklarant" "deklaranter" ; -- deklarant..nn.1
  deklaration_1_N = mkN "deklaration" ; -- deklaration..nn.1
  deklarationsblankett_1_N = mkN "deklarationsblankett" "deklarationsblanketter" ; -- deklarationsblankett..nn.1
  deklarationsdags_1_N = mkN "deklarationsdags" ; -- deklarationsdags..nn.1
  deklarera_1_V = mkV "deklarerar" ; -- deklarera..vb.1
  deklarerande_1_N = mkN "deklarerande" ; -- deklarerande..nn.1
  deklarerbar_1_A = mkA "deklarerbar" ; -- deklarerbar..av.1
  deklarerbarhet_1_N = mkN "deklarerbarhet" ; -- deklarerbarhet..nn.1
  deklarering_1_N = mkN "deklarering" ; -- deklarering..nn.1
  deklassera_1_V = mkV "deklasserar" ; -- deklassera..vb.1
  deklasserande_1_N = mkN "deklasserande" ; -- deklasserande..nn.1
  deklasserbar_1_A = mkA "deklasserbar" ; -- deklasserbar..av.1
  deklasserbarhet_1_N = mkN "deklasserbarhet" ; -- deklasserbarhet..nn.1
  deklassering_1_N = mkN "deklassering" ; -- deklassering..nn.1
  deklination_1_N = mkN "deklination" ; -- deklination..nn.1
  deklinationsnål_1_N = mkN "deklinationsnål" ; -- deklinationsnål..nn.1
  deklinera_1_V = mkV "deklinerar" ; -- deklinera..vb.1
  deklinerande_1_N = mkN "deklinerande" ; -- deklinerande..nn.1
  deklinerbar_1_A = mkA "deklinerbar" ; -- deklinerbar..av.1
  deklinerbarhet_1_N = mkN "deklinerbarhet" ; -- deklinerbarhet..nn.1
  deklinering_1_N = mkN "deklinering" ; -- deklinering..nn.1
  dekokt_1_N = mkN "dekokt" "dekokter" ; -- dekokt..nn.1
  dekolletage_1_N = mkN "dekolletage" "dekolletaget" "dekolletage" "dekolletagen" ; -- dekolletage..nn.1
  dekolleterad_1_A = mkA "dekolleterad" ; -- dekolleterad..av.1
  dekolletering_1_N = mkN "dekolletering" ; -- dekolletering..nn.1
  dekomposition_1_N = mkN "dekomposition" ; -- dekomposition..nn.1
  dekompression_1_N = mkN "dekompression" ; -- dekompression..nn.1
  dekor_1_N = mkN "dekor" "dekoren" "dekorer" "dekorerna" ; -- dekor..nn.1
  dekoration_1_N = mkN "dekoration" ; -- dekoration..nn.1
  dekorationsbrasa_1_N = mkN "dekorationsbrasa" ; -- dekorationsbrasa..nn.1
  dekorationsgran_1_N = mkN "dekorationsgran" ; -- dekorationsgran..nn.1
  dekorationslist_1_N = mkN "dekorationslist" "dekorationslister" ; -- dekorationslist..nn.1
  dekorationsmålare_1_N = mkN "dekorationsmålare" utrum  ; -- dekorationsmålare..nn.1
  dekorationsmålning_1_N = mkN "dekorationsmålning" ; -- dekorationsmålning..nn.1
  dekorativ_1_A = mkA "dekorativ" ; -- dekorativ..av.1
  dekoratör_1_N = mkN "dekoratör" "dekoratörer" ; -- dekoratör..nn.1
  dekorera_1_V = mkV "dekorerar" ; -- dekorera..vb.1
  dekorerande_1_N = mkN "dekorerande" ; -- dekorerande..nn.1
  dekorerbar_1_A = mkA "dekorerbar" ; -- dekorerbar..av.1
  dekorerbarhet_1_N = mkN "dekorerbarhet" ; -- dekorerbarhet..nn.1
  dekorering_1_N = mkN "dekorering" ; -- dekorering..nn.1
  dekorglans_1_N = mkN "dekorglans" ; -- dekorglans..nn.1
  dekorputs_1_N = mkN "dekorputs" ; -- dekorputs..nn.1
  dekorum_1_N = mkN "dekorum" neutrum  ; -- dekorum..nn.1
  dekouragera_1_V = mkV "dekouragerar" ; -- dekouragera..vb.1
  dekouragerande_1_N = mkN "dekouragerande" ; -- dekouragerande..nn.1
  dekouragerbar_1_A = mkA "dekouragerbar" ; -- dekouragerbar..av.1
  dekouragerbarhet_1_N = mkN "dekouragerbarhet" ; -- dekouragerbarhet..nn.1
  dekouragering_1_N = mkN "dekouragering" ; -- dekouragering..nn.1
  dekret_1_N = mkN "dekret" neutrum  ; -- dekret..nn.1
  dekretera_1_V = mkV "dekreterar" ; -- dekretera..vb.1
  dekreterande_1_N = mkN "dekreterande" ; -- dekreterande..nn.1
  dekreterbar_1_A = mkA "dekreterbar" ; -- dekreterbar..av.1
  dekreterbarhet_1_N = mkN "dekreterbarhet" ; -- dekreterbarhet..nn.1
  dekretering_1_N = mkN "dekretering" ; -- dekretering..nn.1
  del_1_N = mkN "del" ; -- del..nn.1
  dela_1_V = mkV "delar" ; -- dela..vb.1
  delabialiserad_1_A = mkA "delabialiserad" ; -- delabialiserad..av.1
  delad_1_A = mkA "delad" ; -- delad..av.1
  delaktig_1_A = mkA "delaktig" ; -- delaktig..av.1
  delaktighet_1_N = mkN "delaktighet" "delaktigheter" ; -- delaktighet..nn.1
  delande_1_N = mkN "delande" ; -- delande..nn.1
  delativ_1_N = mkN "delativ" "delativer" ; -- delativ..nn.1
  delbar_1_A = mkA "delbar" ; -- delbar..av.1
  delbarhet_1_N = mkN "delbarhet" ; -- delbarhet..nn.1
  delbetala_1_V = mkV "delbetalar" ; -- delbetala..vb.1
  delbetalande_1_N = mkN "delbetalande" ; -- delbetalande..nn.1
  delbetalning_1_N = mkN "delbetalning" ; -- delbetalning..nn.1
  delegat_1_N = mkN "delegat" "delegater" ; -- delegat..nn.1
  delegation_1_N = mkN "delegation" ; -- delegation..nn.1
  delegera_1_V = mkV "delegerar" ; -- delegera..vb.1
  delegerande_1_N = mkN "delegerande" ; -- delegerande..nn.1
  delegerbar_1_A = mkA "delegerbar" ; -- delegerbar..av.1
  delegerbarhet_1_N = mkN "delegerbarhet" ; -- delegerbarhet..nn.1
  delegering_1_N = mkN "delegering" ; -- delegering..nn.1
  delfin_1_N = mkN "delfin" "delfiner" ; -- delfin..nn.1
  delfinansiera_1_V = mkV "delfinansierar" ; -- delfinansiera..vb.1
  delfinansierande_1_N = mkN "delfinansierande" ; -- delfinansierande..nn.1
  delfinansiering_1_N = mkN "delfinansiering" ; -- delfinansiering..nn.1
  delfinsprång_1_N = mkN "delfinsprång" neutrum  ; -- delfinsprång..nn.1
  delfående_1_N = mkN "delfående" ; -- delfående..nn.1
  delge_1_V = mkV "delgiva" "delgav" "delgivit" ; -- delge..vb.1
  delgivande_1_N = mkN "delgivande" ; -- delgivande..nn.1
  delgivning_1_N = mkN "delgivning" ; -- delgivning..nn.1
  delgivningsman_1_N = mkN "delgivningsman" "delgivningsmannen" "delgivningsmän" "delgivningsmännen" ; -- delgivningsman..nn.1
  deliciös_1_A = mkA "deliciös" ; -- deliciös..av.1
  delikat_1_A = mkA "delikat" "delikat" ; -- delikat..av.1
  delikatess_1_N = mkN "delikatess" "delikatesser" ; -- delikatess..nn.1
  delikatessdisk_1_N = mkN "delikatessdisk" ; -- delikatessdisk..nn.1
  delikatessjäv_1_N = mkN "delikatessjäv" neutrum  ; -- delikatessjäv..nn.1
  delikt_1_N = mkN "delikt" neutrum  ; -- delikt..nn.1
  delinkvent_1_N = mkN "delinkvent" "delinkventer" ; -- delinkvent..nn.1
  delirant_1_N = mkN "delirant" "deliranter" ; -- delirant..nn.1
  delkaskoförsäkring_1_N = mkN "delkaskoförsäkring" ; -- delkaskoförsäkring..nn.1
  delkategori_1_N = mkN "delkategori" "delkategorier" ; -- delkategori..nn.1
  delkultur_1_N = mkN "delkultur" "delkulturer" ; -- delkultur..nn.1
  dellikvid_1_N = mkN "dellikvid" "dellikvider" ; -- dellikvid..nn.1
  delmängd_1_N = mkN "delmängd" "delmängder" ; -- delmängd..nn.1
  delning_1_N = mkN "delning" ; -- delning..nn.1
  delningslinje_1_N = mkN "delningslinje" "delningslinjer" ; -- delningslinje..nn.1
  delningspunkt_1_N = mkN "delningspunkt" "delningspunkter" ; -- delningspunkt..nn.1
  delningsstreck_1_N = mkN "delningsstreck" neutrum  ; -- delningsstreck..nn.1
  delningssätt_1_N = mkN "delningssätt" neutrum  ; -- delningssätt..nn.1
  delperiod_1_N = mkN "delperiod" "delperioder" ; -- delperiod..nn.1
  delprojekt_1_N = mkN "delprojekt" neutrum  ; -- delprojekt..nn.1
  delrepublik_1_N = mkN "delrepublik" "delrepubliker" ; -- delrepublik..nn.1
  dels_1_Adv = mkAdv "dels" ; -- dels..ab.1
  delstat_1_N = mkN "delstat" "delstater" ; -- delstat..nn.1
  delstatlig_1_A = mkA "delstatlig" ; -- delstatlig..av.1
  delstatsregering_1_N = mkN "delstatsregering" ; -- delstatsregering..nn.1
  delstreck_1_N = mkN "delstreck" neutrum  ; -- delstreck..nn.1
  delsträcka_1_N = mkN "delsträcka" ; -- delsträcka..nn.1
  delta_1_N = mkN "delta" "deltat" "deltan" "deltana" ; -- delta..nn.1
  delta_2_N = mkN "delta" "deltat" "deltan" "deltana" ; -- delta..nn.2
  delta_1_V = mkV "deltaga" "deltog" "deltagit" ; -- delta..vb.1
  deltaformad_1_A = mkA "deltaformad" ; -- deltaformad..av.1
  deltagande_1_A = mkA "deltagande" ; -- deltagande..av.1
  deltagande_1_N = mkN "deltagande" ; -- deltagande..nn.1
  deltagare_1_N = mkN "deltagare" utrum  ; -- deltagare..nn.1
  deltakrokodil_1_N = mkN "deltakrokodil" "deltakrokodiler" ; -- deltakrokodil..nn.1
  deltamuskel_1_N = mkN "deltamuskel" "deltamuskeln" "deltamuskler" "deltamusklerna" ; -- deltamuskel..nn.1
  deltavinge_1_N = mkN "deltavinge" utrum  ; -- deltavinge..nn.1
  deltid_1_N = mkN "deltid" "deltider" ; -- deltid..nn.1
  deltidare_1_N = mkN "deltidare" utrum  ; -- deltidare..nn.1
  deltidsanställd_1_A = mkA "deltidsanställd" "deltidsanställt" ; -- deltidsanställd..av.1
  deltidsarbeta_1_V = mkV "deltidsarbetar" ; -- deltidsarbeta..vb.1
  deltidsarbetande_1_A = mkA "deltidsarbetande" ; -- deltidsarbetande..av.1
  deltidsarbete_1_N = mkN "deltidsarbete" ; -- deltidsarbete..nn.1
  deltidsarbetslös_1_A = mkA "deltidsarbetslös" ; -- deltidsarbetslös..av.1
  deltidsarbetslöshet_1_N = mkN "deltidsarbetslöshet" ; -- deltidsarbetslöshet..nn.1
  deltidssjuk_1_A = mkA "deltidssjuk" ; -- deltidssjuk..av.1
  deltidssjukskriven_1_A = mkA "deltidssjukskriven" ; -- deltidssjukskriven..av.1
  deltävling_1_N = mkN "deltävling" ; -- deltävling..nn.1
  delvis_1_Adv = mkAdv "delvis" ; -- delvis..ab.1
  delvis_1_A = mkA "delvis" ; -- delvis..av.1
  delägare_1_N = mkN "delägare" utrum  ; -- delägare..nn.1
  dema_1_V = mkV "demar" ; -- dema..vb.1
  demagog_1_N = mkN "demagog" "demagoger" ; -- demagog..nn.1
  demagogi_1_N = mkN "demagogi" ; -- demagogi..nn.1
  demagogisk_1_A = mkA "demagogisk" ; -- demagogisk..av.1
  demande_1_N = mkN "demande" ; -- demande..nn.1
  demarkationslinje_1_N = mkN "demarkationslinje" "demarkationslinjer" ; -- demarkationslinje..nn.1
  demarsch_1_N = mkN "demarsch" "demarscher" ; -- demarsch..nn.1
  demaskera_1_V = mkV "demaskerar" ; -- demaskera..vb.1
  demaskerande_1_N = mkN "demaskerande" ; -- demaskerande..nn.1
  demaskerbar_1_A = mkA "demaskerbar" ; -- demaskerbar..av.1
  demaskerbarhet_1_N = mkN "demaskerbarhet" ; -- demaskerbarhet..nn.1
  demaskering_1_N = mkN "demaskering" ; -- demaskering..nn.1
  demens_1_N = mkN "demens" ; -- demens..nn.1
  demenshandikapp_1_N = mkN "demenshandikapp" neutrum  ; -- demenshandikapp..nn.1
  demenspatient_1_N = mkN "demenspatient" "demenspatienter" ; -- demenspatient..nn.1
  demensrelaterad_1_A = mkA "demensrelaterad" ; -- demensrelaterad..av.1
  demensrisk_1_N = mkN "demensrisk" "demensrisker" ; -- demensrisk..nn.1
  demenssjuk_1_A = mkA "demenssjuk" ; -- demenssjuk..av.1
  demenssjukdom_1_N = mkN "demenssjukdom" ; -- demenssjukdom..nn.1
  demensutveckling_1_N = mkN "demensutveckling" ; -- demensutveckling..nn.1
  dement_1_A = mkA "dement" ; -- dement..av.1
  dementera_1_V = mkV "dementerar" ; -- dementera..vb.1
  dementerande_1_N = mkN "dementerande" ; -- dementerande..nn.1
  dementerbar_1_A = mkA "dementerbar" ; -- dementerbar..av.1
  dementerbarhet_1_N = mkN "dementerbarhet" ; -- dementerbarhet..nn.1
  dementering_1_N = mkN "dementering" ; -- dementering..nn.1
  dementi_1_N = mkN "dementi" "dementier" ; -- dementi..nn.1
  demeriterande_1_A = mkA "demeriterande" ; -- demeriterande..av.1
  demi_sec_1_N = mkN "demi-sec" ; -- demi-sec..nn.1
  demilitarisera_1_V = mkV "demilitariserar" ; -- demilitarisera..vb.1
  demilitariserande_1_N = mkN "demilitariserande" ; -- demilitariserande..nn.1
  demilitariserbar_1_A = mkA "demilitariserbar" ; -- demilitariserbar..av.1
  demilitariserbarhet_1_N = mkN "demilitariserbarhet" ; -- demilitariserbarhet..nn.1
  demilitarisering_1_N = mkN "demilitarisering" ; -- demilitarisering..nn.1
  demimond_1_N = mkN "demimond" "demimonder" ; -- demimond..nn.1
  demission_1_N = mkN "demission" ; -- demission..nn.1
  demissionera_1_V = mkV "demissionerar" ; -- demissionera..vb.1
  demissionerande_1_N = mkN "demissionerande" ; -- demissionerande..nn.1
  demissionering_1_N = mkN "demissionering" ; -- demissionering..nn.1
  demiurg_1_N = mkN "demiurg" "demiurger" ; -- demiurg..nn.1
  demo_1_N = mkN "demo" "demot" "demo" "demon" ; -- demo..nn.1
  demobilisera_1_V = mkV "demobiliserar" ; -- demobilisera..vb.1
  demobiliserande_1_N = mkN "demobiliserande" ; -- demobiliserande..nn.1
  demobiliserbar_1_A = mkA "demobiliserbar" ; -- demobiliserbar..av.1
  demobiliserbarhet_1_N = mkN "demobiliserbarhet" ; -- demobiliserbarhet..nn.1
  demobilisering_1_N = mkN "demobilisering" ; -- demobilisering..nn.1
  demoeffekt_1_N = mkN "demoeffekt" "demoeffekter" ; -- demoeffekt..nn.1
  demografi_1_N = mkN "demografi" ; -- demografi..nn.1
  demografisk_1_A = mkA "demografisk" ; -- demografisk..av.1
  demoinspelning_1_N = mkN "demoinspelning" ; -- demoinspelning..nn.1
  demokrat_1_N = mkN "demokrat" "demokrater" ; -- demokrat..nn.1
  demokrati_1_N = mkN "demokrati" "demokratier" ; -- demokrati..nn.1
  demokratibygge_1_N = mkN "demokratibygge" ; -- demokratibygge..nn.1
  demokratiförespråkare_1_N = mkN "demokratiförespråkare" utrum  ; -- demokratiförespråkare..nn.1
  demokratiförkämpe_1_N = mkN "demokratiförkämpe" utrum  ; -- demokratiförkämpe..nn.1
  demokratirörelse_1_N = mkN "demokratirörelse" "demokratirörelser" ; -- demokratirörelse..nn.1
  demokratisera_1_V = mkV "demokratiserar" ; -- demokratisera..vb.1
  demokratiserande_1_N = mkN "demokratiserande" ; -- demokratiserande..nn.1
  demokratiserbar_1_A = mkA "demokratiserbar" ; -- demokratiserbar..av.1
  demokratiserbarhet_1_N = mkN "demokratiserbarhet" ; -- demokratiserbarhet..nn.1
  demokratisering_1_N = mkN "demokratisering" ; -- demokratisering..nn.1
  demokratiseringsprocess_1_N = mkN "demokratiseringsprocess" "demokratiseringsprocesser" ; -- demokratiseringsprocess..nn.1
  demokratisk_1_A = mkA "demokratisk" ; -- demokratisk..av.1
  demokratism_1_N = mkN "demokratism" "demokratismer" ; -- demokratism..nn.1
  demokratisnack_1_N = mkN "demokratisnack" neutrum  ; -- demokratisnack..nn.1
  demokratiutveckling_1_N = mkN "demokratiutveckling" ; -- demokratiutveckling..nn.1
  demolera_1_V = mkV "demolerar" ; -- demolera..vb.1
  demolerande_1_N = mkN "demolerande" ; -- demolerande..nn.1
  demolerbar_1_A = mkA "demolerbar" ; -- demolerbar..av.1
  demolerbarhet_1_N = mkN "demolerbarhet" ; -- demolerbarhet..nn.1
  demolering_1_N = mkN "demolering" ; -- demolering..nn.1
  demon_1_N = mkN "demon" "demoner" ; -- demon..nn.1
  demoni_1_N = mkN "demoni" ; -- demoni..nn.1
  demonisera_1_V = mkV "demoniserar" ; -- demonisera..vb.1
  demoniserande_1_N = mkN "demoniserande" ; -- demoniserande..nn.1
  demoniserbar_1_A = mkA "demoniserbar" ; -- demoniserbar..av.1
  demoniserbarhet_1_N = mkN "demoniserbarhet" ; -- demoniserbarhet..nn.1
  demonisering_1_N = mkN "demonisering" ; -- demonisering..nn.1
  demonisk_1_A = mkA "demonisk" ; -- demonisk..av.1
  demonologi_1_N = mkN "demonologi" ; -- demonologi..nn.1
  demonologisk_1_A = mkA "demonologisk" ; -- demonologisk..av.1
  demonregissör_1_N = mkN "demonregissör" "demonregissörer" ; -- demonregissör..nn.1
  demonstrant_1_N = mkN "demonstrant" "demonstranter" ; -- demonstrant..nn.1
  demonstration_1_N = mkN "demonstration" ; -- demonstration..nn.1
  demonstrationsfrihet_1_N = mkN "demonstrationsfrihet" "demonstrationsfriheter" ; -- demonstrationsfrihet..nn.1
  demonstrationstillstånd_1_N = mkN "demonstrationstillstånd" neutrum  ; -- demonstrationstillstånd..nn.1
  demonstrationståg_1_N = mkN "demonstrationståg" neutrum  ; -- demonstrationståg..nn.1
  demonstrativ_1_A = mkA "demonstrativ" ; -- demonstrativ..av.1
  demonstrativpronomen_1_N = mkN "demonstrativpronomen" neutrum  ; -- demonstrativpronomen..nn.1
  demonstratris_1_N = mkN "demonstratris" "demonstratriser" ; -- demonstratris..nn.1
  demonstratör_1_N = mkN "demonstratör" "demonstratörer" ; -- demonstratör..nn.1
  demonstrera_1_V = mkV "demonstrerar" ; -- demonstrera..vb.1
  demonstrera_2_V = mkV "demonstrerar" ; -- demonstrera..vb.2
  demonstrerande_1_N = mkN "demonstrerande" ; -- demonstrerande..nn.1
  demonstrerbar_1_A = mkA "demonstrerbar" ; -- demonstrerbar..av.1
  demonstrerbarhet_1_N = mkN "demonstrerbarhet" ; -- demonstrerbarhet..nn.1
  demonstrering_1_N = mkN "demonstrering" ; -- demonstrering..nn.1
  demontera_1_V = mkV "demonterar" ; -- demontera..vb.1
  demonterande_1_N = mkN "demonterande" ; -- demonterande..nn.1
  demonterbar_1_A = mkA "demonterbar" ; -- demonterbar..av.1
  demonterbarhet_1_N = mkN "demonterbarhet" ; -- demonterbarhet..nn.1
  demontering_1_N = mkN "demontering" ; -- demontering..nn.1
  demoralisation_1_N = mkN "demoralisation" ; -- demoralisation..nn.1
  demoralisera_1_V = mkV "demoraliserar" ; -- demoralisera..vb.1
  demoraliserande_1_N = mkN "demoraliserande" ; -- demoraliserande..nn.1
  demoraliserbar_1_A = mkA "demoraliserbar" ; -- demoraliserbar..av.1
  demoraliserbarhet_1_N = mkN "demoraliserbarhet" ; -- demoraliserbarhet..nn.1
  demoralisering_1_N = mkN "demoralisering" ; -- demoralisering..nn.1
  demotape_1_N = mkN "demotape" "demotaper" ; -- demotape..nn.1
  denar_1_N = mkN "denar" "denarer" ; -- denar..nn.1
  denaturalisation_1_N = mkN "denaturalisation" ; -- denaturalisation..nn.1
  denaturalisera_1_V = mkV "denaturaliserar" ; -- denaturalisera..vb.1
  denaturaliserande_1_N = mkN "denaturaliserande" ; -- denaturaliserande..nn.1
  denaturaliserbar_1_A = mkA "denaturaliserbar" ; -- denaturaliserbar..av.1
  denaturaliserbarhet_1_N = mkN "denaturaliserbarhet" ; -- denaturaliserbarhet..nn.1
  denaturalisering_1_N = mkN "denaturalisering" ; -- denaturalisering..nn.1
  denaturera_1_V = mkV "denaturerar" ; -- denaturera..vb.1
  denaturerande_1_N = mkN "denaturerande" ; -- denaturerande..nn.1
  denaturerbar_1_A = mkA "denaturerbar" ; -- denaturerbar..av.1
  denaturerbarhet_1_N = mkN "denaturerbarhet" ; -- denaturerbarhet..nn.1
  denaturering_1_N = mkN "denaturering" ; -- denaturering..nn.1
  dendrit_1_N = mkN "dendrit" "dendriter" ; -- dendrit..nn.1
  dendrokronologi_1_N = mkN "dendrokronologi" ; -- dendrokronologi..nn.1
  dendrokronologisk_1_A = mkA "dendrokronologisk" ; -- dendrokronologisk..av.1
  dendrolog_1_N = mkN "dendrolog" "dendrologer" ; -- dendrolog..nn.1
  dendrologi_1_N = mkN "dendrologi" ; -- dendrologi..nn.1
  denier_1_N = mkN "denier" "denieren" "denier" "denieren" ; -- denier..nn.1
  denim_1_N = mkN "denim" ; -- denim..nn.1
  denotation_1_N = mkN "denotation" ; -- denotation..nn.1
  denotativ_1_A = mkA "denotativ" ; -- denotativ..av.1
  denotera_1_V = mkV "denoterar" ; -- denotera..vb.1
  denoterande_1_N = mkN "denoterande" ; -- denoterande..nn.1
  denoterbar_1_A = mkA "denoterbar" ; -- denoterbar..av.1
  denoterbarhet_1_N = mkN "denoterbarhet" ; -- denoterbarhet..nn.1
  denotering_1_N = mkN "denotering" ; -- denotering..nn.1
  densitet_1_N = mkN "densitet" "densiteter" ; -- densitet..nn.1
  densitometer_1_N = mkN "densitometer" ; -- densitometer..nn.1
  densometer_1_N = mkN "densometer" ; -- densometer..nn.1
  dental_1_A = mkA "dental" ; -- dental..av.1
  dental_1_N = mkN "dental" "dentaler" ; -- dental..nn.1
  dentalljud_1_N = mkN "dentalljud" neutrum  ; -- dentalljud..nn.1
  dentist_1_N = mkN "dentist" "dentister" ; -- dentist..nn.1
  denudation_1_N = mkN "denudation" ; -- denudation..nn.1
  denudera_1_V = mkV "denuderar" ; -- denudera..vb.1
  denuderande_1_N = mkN "denuderande" ; -- denuderande..nn.1
  denuderbar_1_A = mkA "denuderbar" ; -- denuderbar..av.1
  denuderbarhet_1_N = mkN "denuderbarhet" ; -- denuderbarhet..nn.1
  denudering_1_N = mkN "denudering" ; -- denudering..nn.1
  denukleariserad_1_A = mkA "denukleariserad" ; -- denukleariserad..av.1
  denuklearisering_1_N = mkN "denuklearisering" ; -- denuklearisering..nn.1
  deodorant_1_N = mkN "deodorant" "deodoranter" ; -- deodorant..nn.1
  deodorisera_1_V = mkV "deodoriserar" ; -- deodorisera..vb.1
  deodoriserande_1_N = mkN "deodoriserande" ; -- deodoriserande..nn.1
  deodoriserbar_1_A = mkA "deodoriserbar" ; -- deodoriserbar..av.1
  deodoriserbarhet_1_N = mkN "deodoriserbarhet" ; -- deodoriserbarhet..nn.1
  deodorisering_1_N = mkN "deodorisering" ; -- deodorisering..nn.1
  departement_1_N = mkN "departement" neutrum  ; -- departement..nn.1
  departemental_1_A = mkA "departemental" ; -- departemental..av.1
  departementschef_1_N = mkN "departementschef" "departementschefer" ; -- departementschef..nn.1
  departementsråd_1_N = mkN "departementsråd" neutrum  ; -- departementsråd..nn.1
  departementsärende_1_N = mkN "departementsärende" ; -- departementsärende..nn.1
  depatriera_1_V = mkV "depatrierar" ; -- depatriera..vb.1
  depatrierande_1_N = mkN "depatrierande" ; -- depatrierande..nn.1
  depatrierbar_1_A = mkA "depatrierbar" ; -- depatrierbar..av.1
  depatrierbarhet_1_N = mkN "depatrierbarhet" ; -- depatrierbarhet..nn.1
  depatriering_1_N = mkN "depatriering" ; -- depatriering..nn.1
  dependens_1_N = mkN "dependens" "dependenser" ; -- dependens..nn.1
  depens_1_N = mkN "depens" "depenser" ; -- depens..nn.1
  depensera_1_V = mkV "depenserar" ; -- depensera..vb.1
  depenserande_1_N = mkN "depenserande" ; -- depenserande..nn.1
  depenserbar_1_A = mkA "depenserbar" ; -- depenserbar..av.1
  depenserbarhet_1_N = mkN "depenserbarhet" ; -- depenserbarhet..nn.1
  depensering_1_N = mkN "depensering" ; -- depensering..nn.1
  depersonalisation_1_N = mkN "depersonalisation" ; -- depersonalisation..nn.1
  depesch_1_N = mkN "depesch" "depescher" ; -- depesch..nn.1
  depeschbyrå_1_N = mkN "depeschbyrå" "depeschbyråer" ; -- depeschbyrå..nn.1
  deplacement_1_N = mkN "deplacement" neutrum  ; -- deplacement..nn.1
  deplacera_1_V = mkV "deplacerar" ; -- deplacera..vb.1
  deplacerande_1_N = mkN "deplacerande" ; -- deplacerande..nn.1
  deplacerbar_1_A = mkA "deplacerbar" ; -- deplacerbar..av.1
  deplacerbarhet_1_N = mkN "deplacerbarhet" ; -- deplacerbarhet..nn.1
  deplacering_1_N = mkN "deplacering" ; -- deplacering..nn.1
  depolarisator_1_N = mkN "depolarisator" "depolarisatorer" ; -- depolarisator..nn.1
  deponens_1_N = mkN "deponens" "deponens" "deponens" "deponensen" ; -- deponens..nn.1
  deponent_1_N = mkN "deponent" "deponenter" ; -- deponent..nn.1
  deponentiell_1_A = mkA "deponentiell" ; -- deponentiell..av.1
  deponera_1_V = mkV "deponerar" ; -- deponera..vb.1
  deponerande_1_N = mkN "deponerande" ; -- deponerande..nn.1
  deponerbar_1_A = mkA "deponerbar" ; -- deponerbar..av.1
  deponerbarhet_1_N = mkN "deponerbarhet" ; -- deponerbarhet..nn.1
  deponering_1_N = mkN "deponering" ; -- deponering..nn.1
  deponi_1_N = mkN "deponi" "deponier" ; -- deponi..nn.1
  deportation_1_N = mkN "deportation" ; -- deportation..nn.1
  deportationsort_1_N = mkN "deportationsort" "deportationsorter" ; -- deportationsort..nn.1
  deportera_1_V = mkV "deporterar" ; -- deportera..vb.1
  deporterande_1_N = mkN "deporterande" ; -- deporterande..nn.1
  deporterbar_1_A = mkA "deporterbar" ; -- deporterbar..av.1
  deporterbarhet_1_N = mkN "deporterbarhet" ; -- deporterbarhet..nn.1
  deportering_1_N = mkN "deportering" ; -- deportering..nn.1
  deposition_1_N = mkN "deposition" ; -- deposition..nn.1
  depositionsbevis_1_N = mkN "depositionsbevis" neutrum  ; -- depositionsbevis..nn.1
  depositum_1_N = mkN "depositum" "depositumet" "deposita" "depositana" ; -- depositum..nn.1
  deppa_1_V = mkV "deppar" ; -- deppa..vb.1
  deppad_1_A = mkA "deppad" ; -- deppad..av.1
  deppande_1_N = mkN "deppande" ; -- deppande..nn.1
  deppig_1_A = mkA "deppig" ; -- deppig..av.1
  deppighet_1_N = mkN "deppighet" ; -- deppighet..nn.1
  depprock_1_N = mkN "depprock" neutrum  ; -- depprock..nn.1
  depprockare_1_N = mkN "depprockare" utrum  ; -- depprockare..nn.1
  depravation_1_N = mkN "depravation" ; -- depravation..nn.1
  depraverad_1_A = mkA "depraverad" ; -- depraverad..av.1
  depreciera_1_V = mkV "deprecierar" ; -- depreciera..vb.1
  deprecierande_1_N = mkN "deprecierande" ; -- deprecierande..nn.1
  deprecierbar_1_A = mkA "deprecierbar" ; -- deprecierbar..av.1
  deprecierbarhet_1_N = mkN "deprecierbarhet" ; -- deprecierbarhet..nn.1
  depreciering_1_N = mkN "depreciering" ; -- depreciering..nn.1
  depression_1_N = mkN "depression" ; -- depression..nn.1
  depressionsdiagnos_1_N = mkN "depressionsdiagnos" "depressionsdiagnoser" ; -- depressionsdiagnos..nn.1
  depressionssymtom_1_N = mkN "depressionssymtom" neutrum  ; -- depressionssymtom..nn.1
  depressiv_1_A = mkA "depressiv" ; -- depressiv..av.1
  deprimerad_1_A = mkA "deprimerad" ; -- deprimerad..av.1
  deprimerande_1_A = mkA "deprimerande" ; -- deprimerande..av.1
  deprivation_1_N = mkN "deprivation" ; -- deprivation..nn.1
  deputation_1_N = mkN "deputation" ; -- deputation..nn.1
  deputerad_1_N = mkN "deputerad" "deputeraden" "deputerade" "deputeradena" ; -- deputerad..nn.1
  depå_1_N = mkN "depå" "depåer" ; -- depå..nn.1
  depåfynd_1_N = mkN "depåfynd" neutrum  ; -- depåfynd..nn.1
  depåstöd_1_N = mkN "depåstöd" neutrum  ; -- depåstöd..nn.1
  derangera_1_V = mkV "derangerar" ; -- derangera..vb.1
  derangerande_1_N = mkN "derangerande" ; -- derangerande..nn.1
  derangerbar_1_A = mkA "derangerbar" ; -- derangerbar..av.1
  derangerbarhet_1_N = mkN "derangerbarhet" ; -- derangerbarhet..nn.1
  derangering_1_N = mkN "derangering" ; -- derangering..nn.1
  derby_1_N = mkN "derby" "derbyt" "derbyn" "derbyna" ; -- derby..nn.1
  derivat_1_N = mkN "derivat" neutrum  ; -- derivat..nn.1
  derivata_1_N = mkN "derivata" ; -- derivata..nn.1
  derivation_1_N = mkN "derivation" ; -- derivation..nn.1
  derivera_1_V = mkV "deriverar" ; -- derivera..vb.1
  deriverande_1_N = mkN "deriverande" ; -- deriverande..nn.1
  deriverbar_1_A = mkA "deriverbar" ; -- deriverbar..av.1
  deriverbarhet_1_N = mkN "deriverbarhet" ; -- deriverbarhet..nn.1
  derivering_1_N = mkN "derivering" ; -- derivering..nn.1
  dermatit_1_N = mkN "dermatit" "dermatiter" ; -- dermatit..nn.1
  dermatolog_1_N = mkN "dermatolog" "dermatologer" ; -- dermatolog..nn.1
  dermatologi_1_N = mkN "dermatologi" ; -- dermatologi..nn.1
  dermatologisk_1_A = mkA "dermatologisk" ; -- dermatologisk..av.1
  dermatos_1_N = mkN "dermatos" "dermatoser" ; -- dermatos..nn.1
  dervisch_1_N = mkN "dervisch" "dervischer" ; -- dervisch..nn.1
  dervischdans_1_N = mkN "dervischdans" "dervischdanser" ; -- dervischdans..nn.1
  desarmera_1_V = mkV "desarmerar" ; -- desarmera..vb.1
  desarmerande_1_N = mkN "desarmerande" ; -- desarmerande..nn.1
  desarmerbar_1_A = mkA "desarmerbar" ; -- desarmerbar..av.1
  desarmerbarhet_1_N = mkN "desarmerbarhet" ; -- desarmerbarhet..nn.1
  desarmering_1_N = mkN "desarmering" ; -- desarmering..nn.1
  desavouera_1_V = mkV "desavouerar" ; -- desavouera..vb.1
  desavouerande_1_N = mkN "desavouerande" ; -- desavouerande..nn.1
  desavouerbar_1_A = mkA "desavouerbar" ; -- desavouerbar..av.1
  desavouerbarhet_1_N = mkN "desavouerbarhet" ; -- desavouerbarhet..nn.1
  desavouering_1_N = mkN "desavouering" ; -- desavouering..nn.1
  descendens_1_N = mkN "descendens" ; -- descendens..nn.1
  descendent_1_N = mkN "descendent" "descendenter" ; -- descendent..nn.1
  desegregation_1_N = mkN "desegregation" ; -- desegregation..nn.1
  desengagemang_1_N = mkN "desengagemang" neutrum  ; -- desengagemang..nn.1
  desensibilisera_1_V = mkV "desensibiliserar" ; -- desensibilisera..vb.1
  desensibiliserande_1_N = mkN "desensibiliserande" ; -- desensibiliserande..nn.1
  desensibiliserbar_1_A = mkA "desensibiliserbar" ; -- desensibiliserbar..av.1
  desensibiliserbarhet_1_N = mkN "desensibiliserbarhet" ; -- desensibiliserbarhet..nn.1
  desensibilisering_1_N = mkN "desensibilisering" ; -- desensibilisering..nn.1
  desertera_1_V = mkV "deserterar" ; -- desertera..vb.1
  deserterande_1_N = mkN "deserterande" ; -- deserterande..nn.1
  desertering_1_N = mkN "desertering" ; -- desertering..nn.1
  desertör_1_N = mkN "desertör" "desertörer" ; -- desertör..nn.1
  deshabillé_1_N = mkN "deshabillé" "deshabilléer" ; -- deshabillé..nn.1
  design_1_N = mkN "design" ; -- design..nn.1
  designa_1_V = mkV "designar" ; -- designa..vb.1
  designande_1_N = mkN "designande" ; -- designande..nn.1
  designer_1_N = mkN "designer" "designern" "designers" "designersen" ; -- designer..nn.1
  designera_1_V = mkV "designerar" ; -- designera..vb.1
  designerande_1_N = mkN "designerande" ; -- designerande..nn.1
  designerbar_1_A = mkA "designerbar" ; -- designerbar..av.1
  designerbarhet_1_N = mkN "designerbarhet" ; -- designerbarhet..nn.1
  designering_1_N = mkN "designering" ; -- designering..nn.1
  designmässig_1_A = mkA "designmässig" ; -- designmässig..av.1
  designskola_1_N = mkN "designskola" ; -- designskola..nn.1
  designstudent_1_N = mkN "designstudent" "designstudenter" ; -- designstudent..nn.1
  designtävling_1_N = mkN "designtävling" ; -- designtävling..nn.1
  desillusion_1_N = mkN "desillusion" ; -- desillusion..nn.1
  desillusionerad_1_A = mkA "desillusionerad" ; -- desillusionerad..av.1
  desinfektera_1_V = mkV "desinfekterar" ; -- desinfektera..vb.1
  desinfekterande_1_N = mkN "desinfekterande" ; -- desinfekterande..nn.1
  desinfekterbar_1_A = mkA "desinfekterbar" ; -- desinfekterbar..av.1
  desinfekterbarhet_1_N = mkN "desinfekterbarhet" ; -- desinfekterbarhet..nn.1
  desinfektering_1_N = mkN "desinfektering" ; -- desinfektering..nn.1
  desinfektion_1_N = mkN "desinfektion" ; -- desinfektion..nn.1
  desinfektionsmedel_1_N = mkN "desinfektionsmedel" neutrum  ; -- desinfektionsmedel..nn.1
  desinfektör_1_N = mkN "desinfektör" "desinfektörer" ; -- desinfektör..nn.1
  desinficera_1_V = mkV "desinficerar" ; -- desinficera..vb.1
  desinficerande_1_N = mkN "desinficerande" ; -- desinficerande..nn.1
  desinficerbar_1_A = mkA "desinficerbar" ; -- desinficerbar..av.1
  desinficerbarhet_1_N = mkN "desinficerbarhet" ; -- desinficerbarhet..nn.1
  desinficering_1_N = mkN "desinficering" ; -- desinficering..nn.1
  desinficeringsmedel_1_N = mkN "desinficeringsmedel" neutrum  ; -- desinficeringsmedel..nn.1
  desinformation_1_N = mkN "desinformation" ; -- desinformation..nn.1
  desinformera_1_V = mkV "desinformerar" ; -- desinformera..vb.1
  desinformerande_1_N = mkN "desinformerande" ; -- desinformerande..nn.1
  desinformerbar_1_A = mkA "desinformerbar" ; -- desinformerbar..av.1
  desinformerbarhet_1_N = mkN "desinformerbarhet" ; -- desinformerbarhet..nn.1
  desinformering_1_N = mkN "desinformering" ; -- desinformering..nn.1
  desinsektion_1_N = mkN "desinsektion" ; -- desinsektion..nn.1
  desintegration_1_N = mkN "desintegration" ; -- desintegration..nn.1
  desintresserad_1_A = mkA "desintresserad" ; -- desintresserad..av.1
  deskription_1_N = mkN "deskription" ; -- deskription..nn.1
  deskriptiv_1_A = mkA "deskriptiv" ; -- deskriptiv..av.1
  deskriptor_1_N = mkN "deskriptor" "deskriptorer" ; -- deskriptor..nn.1
  desorganisation_1_N = mkN "desorganisation" ; -- desorganisation..nn.1
  desorganisera_1_V = mkV "desorganiserar" ; -- desorganisera..vb.1
  desorganiserande_1_N = mkN "desorganiserande" ; -- desorganiserande..nn.1
  desorganiserbar_1_A = mkA "desorganiserbar" ; -- desorganiserbar..av.1
  desorganiserbarhet_1_N = mkN "desorganiserbarhet" ; -- desorganiserbarhet..nn.1
  desorganisering_1_N = mkN "desorganisering" ; -- desorganisering..nn.1
  desorienterad_1_A = mkA "desorienterad" ; -- desorienterad..av.1
  desorientering_1_N = mkN "desorientering" ; -- desorientering..nn.1
  desperado_1_N = mkN "desperado" "desperador" ; -- desperado..nn.1
  desperat_1_A = mkA "desperat" "desperat" ; -- desperat..av.1
  desperation_1_N = mkN "desperation" ; -- desperation..nn.1
  despot_1_N = mkN "despot" "despoter" ; -- despot..nn.1
  despoti_1_N = mkN "despoti" "despotier" ; -- despoti..nn.1
  despotisk_1_A = mkA "despotisk" ; -- despotisk..av.1
  despotism_1_N = mkN "despotism" "despotismer" ; -- despotism..nn.1
  dessbättre_1_Adv = mkAdv "dessbättre" ; -- dessbättre..ab.1
  dessemellan_1_Adv = mkAdv "dessemellan" ; -- dessemellan..ab.1
  dessert_1_N = mkN "dessert" "desserter" ; -- dessert..nn.1
  dessertfrukt_1_N = mkN "dessertfrukt" "dessertfrukter" ; -- dessertfrukt..nn.1
  dessertgaffel_1_N = mkN "dessertgaffel" ; -- dessertgaffel..nn.1
  dessertkniv_1_N = mkN "dessertkniv" ; -- dessertkniv..nn.1
  dessertost_1_N = mkN "dessertost" ; -- dessertost..nn.1
  dessertsked_1_N = mkN "dessertsked" ; -- dessertsked..nn.1
  dessertskål_1_N = mkN "dessertskål" ; -- dessertskål..nn.1
  dessertsås_1_N = mkN "dessertsås" "dessertsåser" ; -- dessertsås..nn.1
  desserttallrik_1_N = mkN "desserttallrik" ; -- desserttallrik..nn.1
  dessertvin_1_N = mkN "dessertvin" "dessertvinet" "dessertviner" "dessertvinerna" ; -- dessertvin..nn.1
  dessförinnan_1_Adv = mkAdv "dessförinnan" ; -- dessförinnan..ab.1
  dessförutan_1_Adv = mkAdv "dessförutan" ; -- dessförutan..ab.1
  dessinatör_1_N = mkN "dessinatör" "dessinatörer" ; -- dessinatör..nn.1
  desslikes_1_Adv = mkAdv "desslikes" ; -- desslikes..ab.1
  dessutom_1_Adv = mkAdv "dessutom" ; -- dessutom..ab.1
  dessvärre_1_Adv = mkAdv "dessvärre" ; -- dessvärre..ab.1
  dessäng_1_N = mkN "dessäng" "dessänger" ; -- dessäng..nn.1
  destabilisera_1_V = mkV "destabiliserar" ; -- destabilisera..vb.1
  destabiliserande_1_A = mkA "destabiliserande" ; -- destabiliserande..av.1
  destabiliserande_1_N = mkN "destabiliserande" ; -- destabiliserande..nn.1
  destabiliserbar_1_A = mkA "destabiliserbar" ; -- destabiliserbar..av.1
  destabiliserbarhet_1_N = mkN "destabiliserbarhet" ; -- destabiliserbarhet..nn.1
  destillat_1_N = mkN "destillat" neutrum  ; -- destillat..nn.1
  destillation_1_N = mkN "destillation" ; -- destillation..nn.1
  destillationsapparat_1_N = mkN "destillationsapparat" "destillationsapparater" ; -- destillationsapparat..nn.1
  destillera_1_V = mkV "destillerar" ; -- destillera..vb.1
  destillerande_1_N = mkN "destillerande" ; -- destillerande..nn.1
  destillerbar_1_A = mkA "destillerbar" ; -- destillerbar..av.1
  destillerbarhet_1_N = mkN "destillerbarhet" ; -- destillerbarhet..nn.1
  destillering_1_N = mkN "destillering" ; -- destillering..nn.1
  destination_1_N = mkN "destination" ; -- destination..nn.1
  destinationshamn_1_N = mkN "destinationshamn" ; -- destinationshamn..nn.1
  destinationsort_1_N = mkN "destinationsort" "destinationsorter" ; -- destinationsort..nn.1
  destinatär_1_N = mkN "destinatär" "destinatärer" ; -- destinatär..nn.1
  destinatör_1_N = mkN "destinatör" "destinatörer" ; -- destinatör..nn.1
  destinera_1_V = mkV "destinerar" ; -- destinera..vb.1
  destinerande_1_N = mkN "destinerande" ; -- destinerande..nn.1
  destinerbar_1_A = mkA "destinerbar" ; -- destinerbar..av.1
  destinerbarhet_1_N = mkN "destinerbarhet" ; -- destinerbarhet..nn.1
  destinering_1_N = mkN "destinering" ; -- destinering..nn.1
  desto_1_Adv = mkAdv "desto" ; -- desto..ab.1
  destruent_1_N = mkN "destruent" "destruenter" ; -- destruent..nn.1
  destruera_1_V = mkV "destruerar" ; -- destruera..vb.1
  destruerande_1_N = mkN "destruerande" ; -- destruerande..nn.1
  destruerbar_1_A = mkA "destruerbar" ; -- destruerbar..av.1
  destruerbarhet_1_N = mkN "destruerbarhet" ; -- destruerbarhet..nn.1
  destruering_1_N = mkN "destruering" ; -- destruering..nn.1
  destruktion_1_N = mkN "destruktion" ; -- destruktion..nn.1
  destruktionsanläggning_1_N = mkN "destruktionsanläggning" ; -- destruktionsanläggning..nn.1
  destruktiv_1_A = mkA "destruktiv" ; -- destruktiv..av.1
  det_genus_1_N = mkN "det-genus" neutrum  ; -- det-genus..nn.1
  detachement_1_N = mkN "detachement" neutrum  ; -- detachement..nn.1
  detachera_1_V = mkV "detacherar" ; -- detachera..vb.1
  detacherande_1_N = mkN "detacherande" ; -- detacherande..nn.1
  detacherbar_1_A = mkA "detacherbar" ; -- detacherbar..av.1
  detacherbarhet_1_N = mkN "detacherbarhet" ; -- detacherbarhet..nn.1
  detachering_1_N = mkN "detachering" ; -- detachering..nn.1
  detachör_1_N = mkN "detachör" "detachörer" ; -- detachör..nn.1
  detalj_1_N = mkN "detalj" "detaljer" ; -- detalj..nn.1
  detaljanmärkning_1_N = mkN "detaljanmärkning" ; -- detaljanmärkning..nn.1
  detaljarbete_1_N = mkN "detaljarbete" ; -- detaljarbete..nn.1
  detaljbestämmelse_1_N = mkN "detaljbestämmelse" "detaljbestämmelser" ; -- detaljbestämmelse..nn.1
  detaljerad_1_A = mkA "detaljerad" ; -- detaljerad..av.1
  detaljering_1_N = mkN "detaljering" ; -- detaljering..nn.1
  detaljfattig_1_A = mkA "detaljfattig" ; -- detaljfattig..av.1
  detaljfattigdom_1_N = mkN "detaljfattigdom" ; -- detaljfattigdom..nn.1
  detaljfixerad_1_A = mkA "detaljfixerad" ; -- detaljfixerad..av.1
  detaljfråga_1_N = mkN "detaljfråga" ; -- detaljfråga..nn.1
  detaljgranska_1_V = mkV "detaljgranskar" ; -- detaljgranska..vb.1
  detaljgranskande_1_N = mkN "detaljgranskande" ; -- detaljgranskande..nn.1
  detaljhandel_1_N = mkN "detaljhandel" ; -- detaljhandel..nn.1
  detaljhandlare_1_N 