--# -path=.:../romance:../common:../abstract:../prelude

resource BeschPor = open Prelude, Predef, CommonRomance in {

flags optimize=noexpand ; -- faster than values
      coding=utf8 ;

-- machine-generated file: do not edit directly!

oper
  Verbum = {s : VFB => Str} ;

  -- The full conjunction is a table on $VForm$:
 param
    VImpers =
        Infn -- garantir
      | Ger  -- garantindo
      | Part -- garantido
      ;

    Mode = Ind | Sub ;

    VPers =
        Pres   Mode Number Person
      | PretI  Mode Number Person    --# notpresent --# notpresent
      | MQPerf      Number Person    --# notpresent --# notpresent
      | PretP       Number Person    --# notpresent --# notpresent
      | Fut    Mode Number Person    --# notpresent --# notpresent
      | Cond        Number Person    --# notpresent --# notpresent
      | Imper       Number Person
      ;

    VFB =
        VI VImpers
      | VPB VPers
      ;

oper
  -- hack to get the same behaviour as from variants. parses both,
  -- linearizes the first.
  vars : Str -> Str -> Str = \x,y -> pre { "" => x ; _ => y } ;

  verbBesch : {s : VFB => Str} -> {s : CommonRomance.VF => Str} = \amar ->
  -- conversion from Portuguese forms to romance forms
    {s = table {
       VInfin _ => amar.s ! VI Infn ;
       VFin (VPres Indic) n p => amar.s ! VPB (Pres Ind n p) ;
       VFin (VPres Conjunct) n p => amar.s ! VPB (Pres Sub n p) ;
       VFin (VImperf Indic) n p => amar.s ! VPB (PretI Ind n p) ;  --# notpresent --# notpresent
       VFin (VImperf Conjunct) n p => amar.s ! VPB (PretI Sub n p) ; --# notpresent --# notpresent
       VFin VPasse n p        => amar.s ! VPB (PretP n p) ; --# notpresent --# notpresent
       VFin VFut n p          => amar.s ! VPB (Fut Ind n p) ; --# notpresent --# notpresent
       VFin VCondit n p       => amar.s ! VPB (Cond n p) ; --# notpresent --# notpresent
       VImper SgP2            => amar.s ! VPB (Imper  Sg P2) ;
       VImper PlP1            => amar.s ! VPB (Imper  Pl P1) ;
       VImper PlP2            => amar.s ! VPB (Imper  Pl P2) ;
       VPart g n              => mkPass (amar.s ! VI Part) ! g ! n ;
       VGer | VPresPart       => amar.s ! VI Ger
       }
    } ;

  mkPass : Str -> Gender => Number => Str ;
  -- passive form is highly predictable from singular masculine
  mkPass p' = let p = p' + [] in case p of {
    amad + "o" => genNumForms p (amad + "a") (amad + "os") (amad + "as") ;
    entregu + "e" => \\g => numForms p (p + "s") ;
    _ => error "unknown ending" -- nothing should reach here
    } ;

    -- you can look up verb paradigms in the Portuguese Bescherelle,
    -- or in =Ryan, M. A. Conjugação dos Verbos em Português. ática,
    -- 1991.=

    -- the numbers in the comments below the oper declaration are the
    -- verb's paradigm numbers in bescherelle and in Ryan

oper ter_Besch : Str -> Verbum = \ter ->
-- 1 | r3
  let x_ = Predef.tk 3 ter in
 {s = table {
    VI Infn => x_ + "ter" ;
    VI Ger => x_ + "tendo" ;
    VI Part => x_ + "tido" ;
    VPB (Pres Ind Sg P1) => x_ + "tenho" ;
    VPB (Pres Ind Sg P2) => x_ + "tens" ;
    VPB (Pres Ind Sg P3) => x_ + "tem" ;
    VPB (Pres Ind Pl P1) => x_ + "temos" ;
    VPB (Pres Ind Pl P2) => x_ + "tendes" ;
    VPB (Pres Ind Pl P3) => x_ + "têm" ;
    VPB (Pres Sub Sg P1) => x_ + "tenha" ;
    VPB (Pres Sub Sg P2) => x_ + "tenhas" ;
    VPB (Pres Sub Sg P3) => x_ + "tenha" ;
    VPB (Pres Sub Pl P1) => x_ + "tenhamos" ;
    VPB (Pres Sub Pl P2) => x_ + "tenhais" ;
    VPB (Pres Sub Pl P3) => x_ + "tenham" ;
    VPB (PretI Ind Sg P1) => x_ + "tinha" ; --# notpresent
    VPB (PretI Ind Sg P2) => x_ + "tinhas" ; --# notpresent
    VPB (PretI Ind Sg P3) => x_ + "tinha" ; --# notpresent
    VPB (PretI Ind Pl P1) => x_ + "tínhamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => x_ + "tínheis" ; --# notpresent
    VPB (PretI Ind Pl P3) => x_ + "tinham" ; --# notpresent
    VPB (PretI Sub Sg P1) => x_ + "tivesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => x_ + "tivesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => x_ + "tivesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => x_ + "tivéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => x_ + "tivésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => x_ + "tivessem" ; --# notpresent
    VPB (MQPerf Sg P1) => x_ + "tivera" ; --# notpresent
    VPB (MQPerf Sg P2) => x_ + "tiveras" ; --# notpresent
    VPB (MQPerf Sg P3) => x_ + "tivera" ; --# notpresent
    VPB (MQPerf Pl P1) => x_ + "tivéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => x_ + "tivéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => x_ + "tiveram" ; --# notpresent
    VPB (PretP Sg P1) => x_ + "tive" ; --# notpresent
    VPB (PretP Sg P2) => x_ + "tiveste" ; --# notpresent
    VPB (PretP Sg P3) => x_ + "teve" ; --# notpresent
    VPB (PretP Pl P1) => x_ + "tivemos" ; --# notpresent
    VPB (PretP Pl P2) => x_ + "tivestes" ; --# notpresent
    VPB (PretP Pl P3) => x_ + "tiveram" ; --# notpresent
    VPB (Fut Ind Sg P1) => x_ + "terei" ; --# notpresent
    VPB (Fut Ind Sg P2) => x_ + "terás" ; --# notpresent
    VPB (Fut Ind Sg P3) => x_ + "terá" ; --# notpresent
    VPB (Fut Ind Pl P1) => x_ + "teremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => x_ + "tereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => x_ + "terão" ; --# notpresent
    VPB (Fut Sub Sg P1) => x_ + "tiver" ; --# notpresent
    VPB (Fut Sub Sg P2) => x_ + "tiveres" ; --# notpresent
    VPB (Fut Sub Sg P3) => x_ + "tiver" ; --# notpresent
    VPB (Fut Sub Pl P1) => x_ + "tivermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => x_ + "tiverdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => x_ + "tiverem" ; --# notpresent
    VPB (Cond Sg P1) => x_ + "teria" ; --# notpresent
    VPB (Cond Sg P2) => x_ + "terias" ; --# notpresent
    VPB (Cond Sg P3) => x_ + "teria" ; --# notpresent
    VPB (Cond Pl P1) => x_ + "teríamos" ; --# notpresent
    VPB (Cond Pl P2) => x_ + "teríeis" ; --# notpresent
    VPB (Cond Pl P3) => x_ + "teriam" ; --# notpresent
    VPB (Imper Sg P2) => x_ + "tem" ;
    VPB (Imper Sg P3) => x_ + "tenha" ;
    VPB (Imper Pl P1) => x_ + "tenhamos" ;
    VPB (Imper Pl P2) => x_ + "tende" ;
    VPB (Imper Pl P3) => x_ + "tenham" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper haver_Besch : Str -> Verbum = \haver ->
-- 2 | r4
  let x_ = Predef.tk 5 haver in
 {s = table {
    VI Infn => x_ + "haver" ;
    VI Ger => x_ + "havendo" ;
    VI Part => x_ + "havido" ;
    VPB (Pres Ind Sg P1) => x_ + "hei" ;
    VPB (Pres Ind Sg P2) => x_ + "hás" ;
    VPB (Pres Ind Sg P3) => x_ + "há" ;
    VPB (Pres Ind Pl P1) => x_ + vars "havemos" "hemos" ;
    VPB (Pres Ind Pl P2) => x_ + vars "haveis" "heis" ;
    VPB (Pres Ind Pl P3) => x_ + "hão" ;
    VPB (Pres Sub Sg P1) => x_ + "haja" ;
    VPB (Pres Sub Sg P2) => x_ + "hajas" ;
    VPB (Pres Sub Sg P3) => x_ + "haja" ;
    VPB (Pres Sub Pl P1) => x_ + "hajamos" ;
    VPB (Pres Sub Pl P2) => x_ + "hajais" ;
    VPB (Pres Sub Pl P3) => x_ + "hajam" ;
    VPB (PretI Ind Sg P1) => x_ + "havia" ; --# notpresent
    VPB (PretI Ind Sg P2) => x_ + "havias" ; --# notpresent
    VPB (PretI Ind Sg P3) => x_ + "havia" ; --# notpresent
    VPB (PretI Ind Pl P1) => x_ + "havíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => x_ + "havíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => x_ + "haviam" ; --# notpresent
    VPB (PretI Sub Sg P1) => x_ + "houvesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => x_ + "houvesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => x_ + "houvesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => x_ + "houvéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => x_ + "houvésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => x_ + "houvessem" ; --# notpresent
    VPB (MQPerf Sg P1) => x_ + "houvera" ; --# notpresent
    VPB (MQPerf Sg P2) => x_ + "houveras" ; --# notpresent
    VPB (MQPerf Sg P3) => x_ + "houvera" ; --# notpresent
    VPB (MQPerf Pl P1) => x_ + "houvéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => x_ + "houvéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => x_ + "houveram" ; --# notpresent
    VPB (PretP Sg P1) => x_ + "houve" ; --# notpresent
    VPB (PretP Sg P2) => x_ + "houveste" ; --# notpresent
    VPB (PretP Sg P3) => x_ + "houve" ; --# notpresent
    VPB (PretP Pl P1) => x_ + "houvemos" ; --# notpresent
    VPB (PretP Pl P2) => x_ + "houvestes" ; --# notpresent
    VPB (PretP Pl P3) => x_ + "houveram" ; --# notpresent
    VPB (Fut Ind Sg P1) => x_ + "haverei" ; --# notpresent
    VPB (Fut Ind Sg P2) => x_ + "haverás" ; --# notpresent
    VPB (Fut Ind Sg P3) => x_ + "haverá" ; --# notpresent
    VPB (Fut Ind Pl P1) => x_ + "haveremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => x_ + "havereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => x_ + "haverão" ; --# notpresent
    VPB (Fut Sub Sg P1) => x_ + "houver" ; --# notpresent
    VPB (Fut Sub Sg P2) => x_ + "houveres" ; --# notpresent
    VPB (Fut Sub Sg P3) => x_ + "houver" ; --# notpresent
    VPB (Fut Sub Pl P1) => x_ + "houvermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => x_ + "houverdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => x_ + "houveram" ; --# notpresent
    VPB (Cond Sg P1) => x_ + "haveria" ; --# notpresent
    VPB (Cond Sg P2) => x_ + "haverias" ; --# notpresent
    VPB (Cond Sg P3) => x_ + "haveria" ; --# notpresent
    VPB (Cond Pl P1) => x_ + "haveríamos" ; --# notpresent
    VPB (Cond Pl P2) => x_ + "haveríeis" ; --# notpresent
    VPB (Cond Pl P3) => x_ + "haveriam" ; --# notpresent
    VPB (Imper Sg P2) => x_ + "há" ;
    VPB (Imper Sg P3) => x_ + "haja" ;
    VPB (Imper Pl P1) => x_ + "hajamos" ;
    VPB (Imper Pl P2) => x_ + "havei" ;
    VPB (Imper Pl P3) => x_ + "hajam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper ser_Besch : Str -> Verbum = \ser ->
-- 3 | r1
  let x_ = Predef.tk 3 ser in
 {s = table {
    VI Infn => x_ + "ser" ;
    VI Ger => x_ + "sendo" ;
    VI Part => x_ + "sido" ;
    VPB (Pres Ind Sg P1) => x_ + "sou" ;
    VPB (Pres Ind Sg P2) => x_ + "és" ;
    VPB (Pres Ind Sg P3) => x_ + "é" ;
    VPB (Pres Ind Pl P1) => x_ + "somos" ;
    VPB (Pres Ind Pl P2) => x_ + "sois" ;
    VPB (Pres Ind Pl P3) => x_ + "são" ;
    VPB (Pres Sub Sg P1) => x_ + "seja" ;
    VPB (Pres Sub Sg P2) => x_ + "sejas" ;
    VPB (Pres Sub Sg P3) => x_ + "seja" ;
    VPB (Pres Sub Pl P1) => x_ + "sejamos" ;
    VPB (Pres Sub Pl P2) => x_ + "sejais" ;
    VPB (Pres Sub Pl P3) => x_ + "sejam" ;
    VPB (PretI Ind Sg P1) => x_ + "era" ; --# notpresent
    VPB (PretI Ind Sg P2) => x_ + "eras" ; --# notpresent
    VPB (PretI Ind Sg P3) => x_ + "era" ; --# notpresent
    VPB (PretI Ind Pl P1) => x_ + "éramos" ; --# notpresent
    VPB (PretI Ind Pl P2) => x_ + "éreis" ; --# notpresent
    VPB (PretI Ind Pl P3) => x_ + "eram" ; --# notpresent
    VPB (PretI Sub Sg P1) => x_ + "fosse" ; --# notpresent
    VPB (PretI Sub Sg P2) => x_ + "fosses" ; --# notpresent
    VPB (PretI Sub Sg P3) => x_ + "fosse" ; --# notpresent
    VPB (PretI Sub Pl P1) => x_ + "fôssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => x_ + "fôsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => x_ + "fossem" ; --# notpresent
    VPB (MQPerf Sg P1) => x_ + "fora" ; --# notpresent
    VPB (MQPerf Sg P2) => x_ + "foras" ; --# notpresent
    VPB (MQPerf Sg P3) => x_ + "fora" ; --# notpresent
    VPB (MQPerf Pl P1) => x_ + "fôramos" ; --# notpresent
    VPB (MQPerf Pl P2) => x_ + "fôreis" ; --# notpresent
    VPB (MQPerf Pl P3) => x_ + "foram" ; --# notpresent
    VPB (PretP Sg P1) => x_ + "fui" ; --# notpresent
    VPB (PretP Sg P2) => x_ + "foste" ; --# notpresent
    VPB (PretP Sg P3) => x_ + "foi" ; --# notpresent
    VPB (PretP Pl P1) => x_ + "fomos" ; --# notpresent
    VPB (PretP Pl P2) => x_ + "fostes" ; --# notpresent
    VPB (PretP Pl P3) => x_ + "foram" ; --# notpresent
    VPB (Fut Ind Sg P1) => x_ + "serei" ; --# notpresent
    VPB (Fut Ind Sg P2) => x_ + "serás" ; --# notpresent
    VPB (Fut Ind Sg P3) => x_ + "será" ; --# notpresent
    VPB (Fut Ind Pl P1) => x_ + "seremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => x_ + "sereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => x_ + "serão" ; --# notpresent
    VPB (Fut Sub Sg P1) => x_ + "for" ; --# notpresent
    VPB (Fut Sub Sg P2) => x_ + "fores" ; --# notpresent
    VPB (Fut Sub Sg P3) => x_ + "for" ; --# notpresent
    VPB (Fut Sub Pl P1) => x_ + "formos" ; --# notpresent
    VPB (Fut Sub Pl P2) => x_ + "fordes" ; --# notpresent
    VPB (Fut Sub Pl P3) => x_ + "forem" ; --# notpresent
    VPB (Cond Sg P1) => x_ + "seria" ; --# notpresent
    VPB (Cond Sg P2) => x_ + "serias" ; --# notpresent
    VPB (Cond Sg P3) => x_ + "seria" ; --# notpresent
    VPB (Cond Pl P1) => x_ + "seríamos" ; --# notpresent
    VPB (Cond Pl P2) => x_ + "seríeis" ; --# notpresent
    VPB (Cond Pl P3) => x_ + "seriam" ; --# notpresent
    VPB (Imper Sg P2) => x_ + "sê" ;
    VPB (Imper Sg P3) => x_ + "seja" ;
    VPB (Imper Pl P1) => x_ + "sejamos" ;
    VPB (Imper Pl P2) => x_ + "sede" ;
    VPB (Imper Pl P3) => x_ + "sejam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper comprar_Besch : Str -> Verbum = \comprar ->
-- 4 | r5
  let compr_ = Predef.tk 2 comprar in
 {s = table {
    VI Infn => compr_ + "ar" ;
    VI Ger => compr_ + "ando" ;
    VI Part => compr_ + "ado" ;
    VPB (Pres Ind Sg P1) => compr_ + "o" ;
    VPB (Pres Ind Sg P2) => compr_ + "as" ;
    VPB (Pres Ind Sg P3) => compr_ + "a" ;
    VPB (Pres Ind Pl P1) => compr_ + "amos" ;
    VPB (Pres Ind Pl P2) => compr_ + "ais" ;
    VPB (Pres Ind Pl P3) => compr_ + "am" ;
    VPB (Pres Sub Sg P1) => compr_ + "e" ;
    VPB (Pres Sub Sg P2) => compr_ + "es" ;
    VPB (Pres Sub Sg P3) => compr_ + "e" ;
    VPB (Pres Sub Pl P1) => compr_ + "emos" ;
    VPB (Pres Sub Pl P2) => compr_ + "eis" ;
    VPB (Pres Sub Pl P3) => compr_ + "em" ;
    VPB (PretI Ind Sg P1) => compr_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => compr_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => compr_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => compr_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => compr_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => compr_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => compr_ + "asse" ; --# notpresent
    VPB (PretI Sub Sg P2) => compr_ + "asses" ; --# notpresent
    VPB (PretI Sub Sg P3) => compr_ + "asse" ; --# notpresent
    VPB (PretI Sub Pl P1) => compr_ + "ássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => compr_ + "ásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => compr_ + "assem" ; --# notpresent
    VPB (MQPerf Sg P1) => compr_ + "ara" ; --# notpresent
    VPB (MQPerf Sg P2) => compr_ + "aras" ; --# notpresent
    VPB (MQPerf Sg P3) => compr_ + "ara" ; --# notpresent
    VPB (MQPerf Pl P1) => compr_ + "arámos" ; --# notpresent
    VPB (MQPerf Pl P2) => compr_ + "áreis" ; --# notpresent
    VPB (MQPerf Pl P3) => compr_ + "aram" ; --# notpresent
    VPB (PretP Sg P1) => compr_ + "ei" ; --# notpresent
    VPB (PretP Sg P2) => compr_ + "aste" ; --# notpresent
    VPB (PretP Sg P3) => compr_ + "ou" ; --# notpresent
    VPB (PretP Pl P1) => compr_ + vars "amos" "ámos" ; --# notpresent
    VPB (PretP Pl P2) => compr_ + "astes" ; --# notpresent
    VPB (PretP Pl P3) => compr_ + "aram" ; --# notpresent
    VPB (Fut Ind Sg P1) => compr_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => compr_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => compr_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => compr_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => compr_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => compr_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => compr_ + "ar" ; --# notpresent
    VPB (Fut Sub Sg P2) => compr_ + "ares" ; --# notpresent
    VPB (Fut Sub Sg P3) => compr_ + "ar" ; --# notpresent
    VPB (Fut Sub Pl P1) => compr_ + "armos" ; --# notpresent
    VPB (Fut Sub Pl P2) => compr_ + "ardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => compr_ + "arem" ; --# notpresent
    VPB (Cond Sg P1) => compr_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => compr_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => compr_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => compr_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => compr_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => compr_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => compr_ + "a" ;
    VPB (Imper Sg P3) => compr_ + "e" ;
    VPB (Imper Pl P1) => compr_ + "emos" ;
    VPB (Imper Pl P2) => compr_ + "ai" ;
    VPB (Imper Pl P3) => compr_ + "em" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper vender_Besch : Str -> Verbum = \vender ->
-- 5 | r6
  let vend_ = Predef.tk 2 vender in
 {s = table {
    VI Infn => vend_ + "er" ;
    VI Ger => vend_ + "endo" ;
    VI Part => vend_ + "ido" ;
    VPB (Pres Ind Sg P1) => vend_ + "o" ;
    VPB (Pres Ind Sg P2) => vend_ + "es" ;
    VPB (Pres Ind Sg P3) => vend_ + "e" ;
    VPB (Pres Ind Pl P1) => vend_ + "emos" ;
    VPB (Pres Ind Pl P2) => vend_ + "eis" ;
    VPB (Pres Ind Pl P3) => vend_ + "em" ;
    VPB (Pres Sub Sg P1) => vend_ + "a" ;
    VPB (Pres Sub Sg P2) => vend_ + "as" ;
    VPB (Pres Sub Sg P3) => vend_ + "a" ;
    VPB (Pres Sub Pl P1) => vend_ + "amos" ;
    VPB (Pres Sub Pl P2) => vend_ + "ais" ;
    VPB (Pres Sub Pl P3) => vend_ + "am" ;
    VPB (PretI Ind Sg P1) => vend_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => vend_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => vend_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => vend_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => vend_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => vend_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => vend_ + "esse" ; --# notpresent
    VPB (PretI Sub Sg P2) => vend_ + "esses" ; --# notpresent
    VPB (PretI Sub Sg P3) => vend_ + "esse" ; --# notpresent
    VPB (PretI Sub Pl P1) => vend_ + "êssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => vend_ + "êsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => vend_ + "essem" ; --# notpresent
    VPB (MQPerf Sg P1) => vend_ + "era" ; --# notpresent
    VPB (MQPerf Sg P2) => vend_ + "eras" ; --# notpresent
    VPB (MQPerf Sg P3) => vend_ + "era" ; --# notpresent
    VPB (MQPerf Pl P1) => vend_ + "êramos" ; --# notpresent
    VPB (MQPerf Pl P2) => vend_ + "êreis" ; --# notpresent
    VPB (MQPerf Pl P3) => vend_ + "eram" ; --# notpresent
    VPB (PretP Sg P1) => vend_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => vend_ + "este" ; --# notpresent
    VPB (PretP Sg P3) => vend_ + "eu" ; --# notpresent
    VPB (PretP Pl P1) => vend_ + "emos" ; --# notpresent
    VPB (PretP Pl P2) => vend_ + "estes" ; --# notpresent
    VPB (PretP Pl P3) => vend_ + "eram" ; --# notpresent
    VPB (Fut Ind Sg P1) => vend_ + "erei" ; --# notpresent
    VPB (Fut Ind Sg P2) => vend_ + "erás" ; --# notpresent
    VPB (Fut Ind Sg P3) => vend_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => vend_ + "eremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => vend_ + "ereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => vend_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => vend_ + "er" ; --# notpresent
    VPB (Fut Sub Sg P2) => vend_ + "ereis" ; --# notpresent
    VPB (Fut Sub Sg P3) => vend_ + "er" ; --# notpresent
    VPB (Fut Sub Pl P1) => vend_ + "ermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => vend_ + "erdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => vend_ + "erem" ; --# notpresent
    VPB (Cond Sg P1) => vend_ + "eria" ; --# notpresent
    VPB (Cond Sg P2) => vend_ + "erias" ; --# notpresent
    VPB (Cond Sg P3) => vend_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => vend_ + "eríamos" ; --# notpresent
    VPB (Cond Pl P2) => vend_ + "eríeis" ; --# notpresent
    VPB (Cond Pl P3) => vend_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => vend_ + "e" ;
    VPB (Imper Sg P3) => vend_ + "a" ;
    VPB (Imper Pl P1) => vend_ + "amos" ;
    VPB (Imper Pl P2) => vend_ + "ei" ;
    VPB (Imper Pl P3) => vend_ + "am" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper garantir_Besch : Str -> Verbum = \garantir ->
-- 6 | r7
  let garant_ = Predef.tk 2 garantir in
 {s = table {
    VI Infn => garant_ + "ir" ;
    VI Ger => garant_ + "indo" ;
    VI Part => garant_ + "ido" ;
    VPB (Pres Ind Sg P1) => garant_ + "o" ;
    VPB (Pres Ind Sg P2) => garant_ + "es" ;
    VPB (Pres Ind Sg P3) => garant_ + "e" ;
    VPB (Pres Ind Pl P1) => garant_ + "imos" ;
    VPB (Pres Ind Pl P2) => garant_ + "is" ;
    VPB (Pres Ind Pl P3) => garant_ + "em" ;
    VPB (Pres Sub Sg P1) => garant_ + "a" ;
    VPB (Pres Sub Sg P2) => garant_ + "as" ;
    VPB (Pres Sub Sg P3) => garant_ + "a" ;
    VPB (Pres Sub Pl P1) => garant_ + "amos" ;
    VPB (Pres Sub Pl P2) => garant_ + "ais" ;
    VPB (Pres Sub Pl P3) => garant_ + "am" ;
    VPB (PretI Ind Sg P1) => garant_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => garant_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => garant_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => garant_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => garant_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => garant_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => garant_ + "isse" ; --# notpresent
    VPB (PretI Sub Sg P2) => garant_ + "isses" ; --# notpresent
    VPB (PretI Sub Sg P3) => garant_ + "isse" ; --# notpresent
    VPB (PretI Sub Pl P1) => garant_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => garant_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => garant_ + "issem" ; --# notpresent
    VPB (MQPerf Sg P1) => garant_ + "ira" ; --# notpresent
    VPB (MQPerf Sg P2) => garant_ + "iras" ; --# notpresent
    VPB (MQPerf Sg P3) => garant_ + "ira" ; --# notpresent
    VPB (MQPerf Pl P1) => garant_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => garant_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => garant_ + "iram" ; --# notpresent
    VPB (PretP Sg P1) => garant_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => garant_ + "iste" ; --# notpresent
    VPB (PretP Sg P3) => garant_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => garant_ + "imos" ; --# notpresent
    VPB (PretP Pl P2) => garant_ + "istes" ; --# notpresent
    VPB (PretP Pl P3) => garant_ + "iram" ; --# notpresent
    VPB (Fut Ind Sg P1) => garant_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => garant_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => garant_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => garant_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => garant_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => garant_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => garant_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => garant_ + "ires" ; --# notpresent
    VPB (Fut Sub Sg P3) => garant_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => garant_ + "irmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => garant_ + "irdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => garant_ + "irem" ; --# notpresent
    VPB (Cond Sg P1) => garant_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => garant_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => garant_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => garant_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => garant_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => garant_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => garant_ + "e" ;
    VPB (Imper Sg P3) => garant_ + "a" ;
    VPB (Imper Pl P1) => garant_ + "amos" ;
    VPB (Imper Pl P2) => garant_ + "i" ;
    VPB (Imper Pl P3) => garant_ + "am" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper estar_Besch : Str -> Verbum = \estar ->
-- 10 | r2
  let est_ = Predef.tk 2 estar in
 {s = table {
    VI Infn => est_ + "ar" ;
    VI Ger => est_ + "ando" ;
    VI Part => est_ + "ado" ;
    VPB (Pres Ind Sg P1) => est_ + "ou" ;
    VPB (Pres Ind Sg P2) => est_ + "ás" ;
    VPB (Pres Ind Sg P3) => est_ + "á" ;
    VPB (Pres Ind Pl P1) => est_ + "amos" ;
    VPB (Pres Ind Pl P2) => est_ + "ais" ;
    VPB (Pres Ind Pl P3) => est_ + "ão" ;
    VPB (Pres Sub Sg P1) => est_ + "eja" ;
    VPB (Pres Sub Sg P2) => est_ + "ejas" ;
    VPB (Pres Sub Sg P3) => est_ + "eja" ;
    VPB (Pres Sub Pl P1) => est_ + "ejamos" ;
    VPB (Pres Sub Pl P2) => est_ + "ejais" ;
    VPB (Pres Sub Pl P3) => est_ + "ejam" ;
    VPB (PretI Ind Sg P1) => est_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => est_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => est_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => est_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => est_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => est_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => est_ + "ivesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => est_ + "ivesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => est_ + "ivesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => est_ + "ivéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => est_ + "ivésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => est_ + "ivessem" ; --# notpresent
    VPB (MQPerf Sg P1) => est_ + "ivera" ; --# notpresent
    VPB (MQPerf Sg P2) => est_ + "iveras" ; --# notpresent
    VPB (MQPerf Sg P3) => est_ + "ivera" ; --# notpresent
    VPB (MQPerf Pl P1) => est_ + "ivéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => est_ + "ivéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => est_ + "iveram" ; --# notpresent
    VPB (PretP Sg P1) => est_ + "ive" ; --# notpresent
    VPB (PretP Sg P2) => est_ + "iveste" ; --# notpresent
    VPB (PretP Sg P3) => est_ + "eve" ; --# notpresent
    VPB (PretP Pl P1) => est_ + "ivemos" ; --# notpresent
    VPB (PretP Pl P2) => est_ + "ivestes" ; --# notpresent
    VPB (PretP Pl P3) => est_ + "iveram" ; --# notpresent
    VPB (Fut Ind Sg P1) => est_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => est_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => est_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => est_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => est_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => est_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => est_ + "iver" ; --# notpresent
    VPB (Fut Sub Sg P2) => est_ + "iverese" ; --# notpresent
    VPB (Fut Sub Sg P3) => est_ + "iver" ; --# notpresent
    VPB (Fut Sub Pl P1) => est_ + "ivermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => est_ + "iverdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => est_ + "iverem" ; --# notpresent
    VPB (Cond Sg P1) => est_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => est_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => est_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => est_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => est_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => est_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => est_ + "á" ;
    VPB (Imper Sg P3) => est_ + "eja" ;
    VPB (Imper Pl P1) => est_ + "ejamos" ;
    VPB (Imper Pl P2) => est_ + "ai" ;
    VPB (Imper Pl P3) => est_ + "ejam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper dar_Besch : Str -> Verbum = \dar ->
-- 11 | r59
  let x_ = Predef.tk 3 dar in
 {s = table {
    VI Infn => x_ + "dar" ;
    VI Ger => x_ + "dando" ;
    VI Part => x_ + "dado" ;
    VPB (Pres Ind Sg P1) => x_ + "dou" ;
    VPB (Pres Ind Sg P2) => x_ + "dás" ;
    VPB (Pres Ind Sg P3) => x_ + "dá" ;
    VPB (Pres Ind Pl P1) => x_ + "damos" ;
    VPB (Pres Ind Pl P2) => x_ + "dais" ;
    VPB (Pres Ind Pl P3) => x_ + "dão" ;
    VPB (Pres Sub Sg P1) => x_ + "dê" ;
    VPB (Pres Sub Sg P2) => x_ + "dês" ;
    VPB (Pres Sub Sg P3) => x_ + "dê" ;
    VPB (Pres Sub Pl P1) => x_ + "demos" ;
    VPB (Pres Sub Pl P2) => x_ + "deis" ;
    VPB (Pres Sub Pl P3) => x_ + vars "deem" "dêem" ;
    VPB (PretI Ind Sg P1) => x_ + "dava" ; --# notpresent
    VPB (PretI Ind Sg P2) => x_ + "davas" ; --# notpresent
    VPB (PretI Ind Sg P3) => x_ + "dava" ; --# notpresent
    VPB (PretI Ind Pl P1) => x_ + "dávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => x_ + "dáveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => x_ + "davam" ; --# notpresent
    VPB (PretI Sub Sg P1) => x_ + "desse" ; --# notpresent
    VPB (PretI Sub Sg P2) => x_ + "desses" ; --# notpresent
    VPB (PretI Sub Sg P3) => x_ + "desse" ; --# notpresent
    VPB (PretI Sub Pl P1) => x_ + "déssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => x_ + "désseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => x_ + "dessem" ; --# notpresent
    VPB (MQPerf Sg P1) => x_ + "dera" ; --# notpresent
    VPB (MQPerf Sg P2) => x_ + "deras" ; --# notpresent
    VPB (MQPerf Sg P3) => x_ + "dera" ; --# notpresent
    VPB (MQPerf Pl P1) => x_ + "déramos" ; --# notpresent
    VPB (MQPerf Pl P2) => x_ + "déreis" ; --# notpresent
    VPB (MQPerf Pl P3) => x_ + "deram" ; --# notpresent
    VPB (PretP Sg P1) => x_ + "dei" ; --# notpresent
    VPB (PretP Sg P2) => x_ + "deste" ; --# notpresent
    VPB (PretP Sg P3) => x_ + "deu" ; --# notpresent
    VPB (PretP Pl P1) => x_ + "demos" ; --# notpresent
    VPB (PretP Pl P2) => x_ + "destes" ; --# notpresent
    VPB (PretP Pl P3) => x_ + "deram" ; --# notpresent
    VPB (Fut Ind Sg P1) => x_ + "darei" ; --# notpresent
    VPB (Fut Ind Sg P2) => x_ + "darás" ; --# notpresent
    VPB (Fut Ind Sg P3) => x_ + "dará" ; --# notpresent
    VPB (Fut Ind Pl P1) => x_ + "daremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => x_ + "dareis" ; --# notpresent
    VPB (Fut Ind Pl P3) => x_ + "darão" ; --# notpresent
    VPB (Fut Sub Sg P1) => x_ + "der" ; --# notpresent
    VPB (Fut Sub Sg P2) => x_ + "deres" ; --# notpresent
    VPB (Fut Sub Sg P3) => x_ + "der" ; --# notpresent
    VPB (Fut Sub Pl P1) => x_ + "dermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => x_ + "derdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => x_ + "derem" ; --# notpresent
    VPB (Cond Sg P1) => x_ + "daria" ; --# notpresent
    VPB (Cond Sg P2) => x_ + "darias" ; --# notpresent
    VPB (Cond Sg P3) => x_ + "daria" ; --# notpresent
    VPB (Cond Pl P1) => x_ + "daríamos" ; --# notpresent
    VPB (Cond Pl P2) => x_ + "daríeis" ; --# notpresent
    VPB (Cond Pl P3) => x_ + "dariam" ; --# notpresent
    VPB (Imper Sg P2) => x_ + "dá" ;
    VPB (Imper Sg P3) => x_ + "dê" ;
    VPB (Imper Pl P1) => x_ + "demos" ;
    VPB (Imper Pl P2) => x_ + "dai" ;
    VPB (Imper Pl P3) => x_ + vars "deem" "dêem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper ficar_Besch : Str -> Verbum = \ficar ->
-- 12 | r23
  let x_ = Predef.tk 5 ficar in
 {s = table {
    VI Infn => x_ + "ficar" ;
    VI Ger => x_ + "ficando" ;
    VI Part => x_ + "ficado" ;
    VPB (Pres Ind Sg P1) => x_ + "fico" ;
    VPB (Pres Ind Sg P2) => x_ + "ficas" ;
    VPB (Pres Ind Sg P3) => x_ + "fica" ;
    VPB (Pres Ind Pl P1) => x_ + "ficamos" ;
    VPB (Pres Ind Pl P2) => x_ + "ficais" ;
    VPB (Pres Ind Pl P3) => x_ + "ficam" ;
    VPB (Pres Sub Sg P1) => x_ + "fique" ;
    VPB (Pres Sub Sg P2) => x_ + "fiques" ;
    VPB (Pres Sub Sg P3) => x_ + "fique" ;
    VPB (Pres Sub Pl P1) => x_ + "fiquemos" ;
    VPB (Pres Sub Pl P2) => x_ + "fiqueis" ;
    VPB (Pres Sub Pl P3) => x_ + "fiquem" ;
    VPB (PretI Ind Sg P1) => x_ + "ficava" ; --# notpresent
    VPB (PretI Ind Sg P2) => x_ + "ficavas" ; --# notpresent
    VPB (PretI Ind Sg P3) => x_ + "ficava" ; --# notpresent
    VPB (PretI Ind Pl P1) => x_ + "ficávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => x_ + "ficáveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => x_ + "ficavam" ; --# notpresent
    VPB (PretI Sub Sg P1) => x_ + "ficasse" ; --# notpresent
    VPB (PretI Sub Sg P2) => x_ + "ficasses" ; --# notpresent
    VPB (PretI Sub Sg P3) => x_ + "ficasse" ; --# notpresent
    VPB (PretI Sub Pl P1) => x_ + "ficássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => x_ + "ficásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => x_ + "ficassem" ; --# notpresent
    VPB (MQPerf Sg P1) => x_ + "ficara" ; --# notpresent
    VPB (MQPerf Sg P2) => x_ + "ficaras" ; --# notpresent
    VPB (MQPerf Sg P3) => x_ + "ficara" ; --# notpresent
    VPB (MQPerf Pl P1) => x_ + "ficáramos" ; --# notpresent
    VPB (MQPerf Pl P2) => x_ + "ficáreis" ; --# notpresent
    VPB (MQPerf Pl P3) => x_ + "ficaram" ; --# notpresent
    VPB (PretP Sg P1) => x_ + "fiquei" ; --# notpresent
    VPB (PretP Sg P2) => x_ + "ficaste" ; --# notpresent
    VPB (PretP Sg P3) => x_ + "ficou" ; --# notpresent
    VPB (PretP Pl P1) => x_ + vars "ficamos" "ficámos" ; --# notpresent
    VPB (PretP Pl P2) => x_ + "ficastes" ; --# notpresent
    VPB (PretP Pl P3) => x_ + "ficaram" ; --# notpresent
    VPB (Fut Ind Sg P1) => x_ + "ficarei" ; --# notpresent
    VPB (Fut Ind Sg P2) => x_ + "ficarás" ; --# notpresent
    VPB (Fut Ind Sg P3) => x_ + "ficará" ; --# notpresent
    VPB (Fut Ind Pl P1) => x_ + "ficaremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => x_ + "ficareis" ; --# notpresent
    VPB (Fut Ind Pl P3) => x_ + "ficarão" ; --# notpresent
    VPB (Fut Sub Sg P1) => x_ + "ficar" ; --# notpresent
    VPB (Fut Sub Sg P2) => x_ + "ficares" ; --# notpresent
    VPB (Fut Sub Sg P3) => x_ + "ficar" ; --# notpresent
    VPB (Fut Sub Pl P1) => x_ + "ficarmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => x_ + "ficardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => x_ + "ficarem" ; --# notpresent
    VPB (Cond Sg P1) => x_ + "ficaria" ; --# notpresent
    VPB (Cond Sg P2) => x_ + "ficarias" ; --# notpresent
    VPB (Cond Sg P3) => x_ + "ficaria" ; --# notpresent
    VPB (Cond Pl P1) => x_ + "ficaríamos" ; --# notpresent
    VPB (Cond Pl P2) => x_ + "ficaríeis" ; --# notpresent
    VPB (Cond Pl P3) => x_ + "ficariam" ; --# notpresent
    VPB (Imper Sg P2) => x_ + "fica" ;
    VPB (Imper Sg P3) => x_ + "fique" ;
    VPB (Imper Pl P1) => x_ + "fiquemos" ;
    VPB (Imper Pl P2) => x_ + "ficai" ;
    VPB (Imper Pl P3) => x_ + "fiquem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper começar_Besch : Str -> Verbum = \começar ->
-- 13 | r24
  let come_ = Predef.tk 3 começar in
 {s = table {
    VI Infn => come_ + "çar" ;
    VI Ger => come_ + "çando" ;
    VI Part => come_ + "çado" ;
    VPB (Pres Ind Sg P1) => come_ + "ço" ;
    VPB (Pres Ind Sg P2) => come_ + "ças" ;
    VPB (Pres Ind Sg P3) => come_ + "ça" ;
    VPB (Pres Ind Pl P1) => come_ + "çamos" ;
    VPB (Pres Ind Pl P2) => come_ + "çais" ;
    VPB (Pres Ind Pl P3) => come_ + "çam" ;
    VPB (Pres Sub Sg P1) => come_ + "ce" ;
    VPB (Pres Sub Sg P2) => come_ + "ces" ;
    VPB (Pres Sub Sg P3) => come_ + "ce" ;
    VPB (Pres Sub Pl P1) => come_ + "cemos" ;
    VPB (Pres Sub Pl P2) => come_ + "ceis" ;
    VPB (Pres Sub Pl P3) => come_ + "cem" ;
    VPB (PretI Ind Sg P1) => come_ + "çava" ; --# notpresent
    VPB (PretI Ind Sg P2) => come_ + "çavas" ; --# notpresent
    VPB (PretI Ind Sg P3) => come_ + "çava" ; --# notpresent
    VPB (PretI Ind Pl P1) => come_ + "çávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => come_ + "çáveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => come_ + "çavam" ; --# notpresent
    VPB (PretI Sub Sg P1) => come_ + "çasse" ; --# notpresent
    VPB (PretI Sub Sg P2) => come_ + "çasses" ; --# notpresent
    VPB (PretI Sub Sg P3) => come_ + "çasse" ; --# notpresent
    VPB (PretI Sub Pl P1) => come_ + "çássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => come_ + "çasseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => come_ + "çassem" ; --# notpresent
    VPB (MQPerf Sg P1) => come_ + "çara" ; --# notpresent
    VPB (MQPerf Sg P2) => come_ + "çaras" ; --# notpresent
    VPB (MQPerf Sg P3) => come_ + "çara" ; --# notpresent
    VPB (MQPerf Pl P1) => come_ + "çáramos" ; --# notpresent
    VPB (MQPerf Pl P2) => come_ + "çáreis" ; --# notpresent
    VPB (MQPerf Pl P3) => come_ + "çaram" ; --# notpresent
    VPB (PretP Sg P1) => come_ + "cei" ; --# notpresent
    VPB (PretP Sg P2) => come_ + "çaste" ; --# notpresent
    VPB (PretP Sg P3) => come_ + "çou" ; --# notpresent
    VPB (PretP Pl P1) => come_ + vars "çamos" "çámos" ; --# notpresent
    VPB (PretP Pl P2) => come_ + "çastes" ; --# notpresent
    VPB (PretP Pl P3) => come_ + "çaram" ; --# notpresent
    VPB (Fut Ind Sg P1) => come_ + "çarei" ; --# notpresent
    VPB (Fut Ind Sg P2) => come_ + "çarás" ; --# notpresent
    VPB (Fut Ind Sg P3) => come_ + "çará" ; --# notpresent
    VPB (Fut Ind Pl P1) => come_ + "çaremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => come_ + "çareis" ; --# notpresent
    VPB (Fut Ind Pl P3) => come_ + "çarão" ; --# notpresent
    VPB (Fut Sub Sg P1) => come_ + "çar" ; --# notpresent
    VPB (Fut Sub Sg P2) => come_ + "çares" ; --# notpresent
    VPB (Fut Sub Sg P3) => come_ + "çar" ; --# notpresent
    VPB (Fut Sub Pl P1) => come_ + "çarmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => come_ + "çardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => come_ + "çarem" ; --# notpresent
    VPB (Cond Sg P1) => come_ + "çaria" ; --# notpresent
    VPB (Cond Sg P2) => come_ + "çarias" ; --# notpresent
    VPB (Cond Sg P3) => come_ + "çaria" ; --# notpresent
    VPB (Cond Pl P1) => come_ + "çaríamos" ; --# notpresent
    VPB (Cond Pl P2) => come_ + "çarieis" ; --# notpresent
    VPB (Cond Pl P3) => come_ + "çariam" ; --# notpresent
    VPB (Imper Sg P2) => come_ + "ça" ;
    VPB (Imper Sg P3) => come_ + "ce" ;
    VPB (Imper Pl P1) => come_ + "cemos" ;
    VPB (Imper Pl P2) => come_ + "çai" ;
    VPB (Imper Pl P3) => come_ + "cem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper chegar_Besch : Str -> Verbum = \chegar ->
-- 14 | r26
  let cheg_ = Predef.tk 2 chegar in
 {s = table {
    VI Infn => cheg_ + "ar" ;
    VI Ger => cheg_ + "ando" ;
    VI Part => cheg_ + "ado" ;
    VPB (Pres Ind Sg P1) => cheg_ + "o" ;
    VPB (Pres Ind Sg P2) => cheg_ + "as" ;
    VPB (Pres Ind Sg P3) => cheg_ + "a" ;
    VPB (Pres Ind Pl P1) => cheg_ + "amos" ;
    VPB (Pres Ind Pl P2) => cheg_ + "ais" ;
    VPB (Pres Ind Pl P3) => cheg_ + "am" ;
    VPB (Pres Sub Sg P1) => cheg_ + "ue" ;
    VPB (Pres Sub Sg P2) => cheg_ + "ues" ;
    VPB (Pres Sub Sg P3) => cheg_ + "ue" ;
    VPB (Pres Sub Pl P1) => cheg_ + "uemos" ;
    VPB (Pres Sub Pl P2) => cheg_ + "ueis" ;
    VPB (Pres Sub Pl P3) => cheg_ + "uem" ;
    VPB (PretI Ind Sg P1) => cheg_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => cheg_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => cheg_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => cheg_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => cheg_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => cheg_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => cheg_ + "asse" ; --# notpresent
    VPB (PretI Sub Sg P2) => cheg_ + "asses" ; --# notpresent
    VPB (PretI Sub Sg P3) => cheg_ + "asse" ; --# notpresent
    VPB (PretI Sub Pl P1) => cheg_ + "ássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => cheg_ + "ásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => cheg_ + "assem" ; --# notpresent
    VPB (MQPerf Sg P1) => cheg_ + "ara" ; --# notpresent
    VPB (MQPerf Sg P2) => cheg_ + "aras" ; --# notpresent
    VPB (MQPerf Sg P3) => cheg_ + "ara" ; --# notpresent
    VPB (MQPerf Pl P1) => cheg_ + "áramos" ; --# notpresent
    VPB (MQPerf Pl P2) => cheg_ + "áreis" ; --# notpresent
    VPB (MQPerf Pl P3) => cheg_ + "aram" ; --# notpresent
    VPB (PretP Sg P1) => cheg_ + "uei" ; --# notpresent
    VPB (PretP Sg P2) => cheg_ + "aste" ; --# notpresent
    VPB (PretP Sg P3) => cheg_ + "ou" ; --# notpresent
    VPB (PretP Pl P1) => cheg_ + vars "amos" "ámos" ; --# notpresent
    VPB (PretP Pl P2) => cheg_ + "astes" ; --# notpresent
    VPB (PretP Pl P3) => cheg_ + "aram" ; --# notpresent
    VPB (Fut Ind Sg P1) => cheg_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => cheg_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => cheg_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => cheg_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => cheg_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => cheg_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => cheg_ + "ar" ; --# notpresent
    VPB (Fut Sub Sg P2) => cheg_ + "ares" ; --# notpresent
    VPB (Fut Sub Sg P3) => cheg_ + "ar" ; --# notpresent
    VPB (Fut Sub Pl P1) => cheg_ + "armos" ; --# notpresent
    VPB (Fut Sub Pl P2) => cheg_ + "ardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => cheg_ + "arem" ; --# notpresent
    VPB (Cond Sg P1) => cheg_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => cheg_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => cheg_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => cheg_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => cheg_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => cheg_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => cheg_ + "a" ;
    VPB (Imper Sg P3) => cheg_ + "ue" ;
    VPB (Imper Pl P1) => cheg_ + "uemos" ;
    VPB (Imper Pl P2) => cheg_ + "ai" ;
    VPB (Imper Pl P3) => cheg_ + "uem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper recear_Besch : Str -> Verbum = \recear ->
-- 15 | r46
  let rec_ = Predef.tk 3 recear in
 {s = table {
    VI Infn => rec_ + "ear" ;
    VI Ger => rec_ + "eando" ;
    VI Part => rec_ + "eado" ;
    VPB (Pres Ind Sg P1) => rec_ + "eio" ;
    VPB (Pres Ind Sg P2) => rec_ + "eias" ;
    VPB (Pres Ind Sg P3) => rec_ + "eia" ;
    VPB (Pres Ind Pl P1) => rec_ + "eamos" ;
    VPB (Pres Ind Pl P2) => rec_ + "eais" ;
    VPB (Pres Ind Pl P3) => rec_ + "eiam" ;
    VPB (Pres Sub Sg P1) => rec_ + "eie" ;
    VPB (Pres Sub Sg P2) => rec_ + "eies" ;
    VPB (Pres Sub Sg P3) => rec_ + "eie" ;
    VPB (Pres Sub Pl P1) => rec_ + "eemos" ;
    VPB (Pres Sub Pl P2) => rec_ + "eeis" ;
    VPB (Pres Sub Pl P3) => rec_ + "eiem" ;
    VPB (PretI Ind Sg P1) => rec_ + "eava" ; --# notpresent
    VPB (PretI Ind Sg P2) => rec_ + "eavas" ; --# notpresent
    VPB (PretI Ind Sg P3) => rec_ + "eava" ; --# notpresent
    VPB (PretI Ind Pl P1) => rec_ + "eávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => rec_ + "eáveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => rec_ + "eavam" ; --# notpresent
    VPB (PretI Sub Sg P1) => rec_ + "easse" ; --# notpresent
    VPB (PretI Sub Sg P2) => rec_ + "easses" ; --# notpresent
    VPB (PretI Sub Sg P3) => rec_ + "easse" ; --# notpresent
    VPB (PretI Sub Pl P1) => rec_ + "eássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => rec_ + "eásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => rec_ + "eassem" ; --# notpresent
    VPB (MQPerf Sg P1) => rec_ + "eara" ; --# notpresent
    VPB (MQPerf Sg P2) => rec_ + "earas" ; --# notpresent
    VPB (MQPerf Sg P3) => rec_ + "eara" ; --# notpresent
    VPB (MQPerf Pl P1) => rec_ + "eáramos" ; --# notpresent
    VPB (MQPerf Pl P2) => rec_ + "eáreis" ; --# notpresent
    VPB (MQPerf Pl P3) => rec_ + "earam" ; --# notpresent
    VPB (PretP Sg P1) => rec_ + "eei" ; --# notpresent
    VPB (PretP Sg P2) => rec_ + "easte" ; --# notpresent
    VPB (PretP Sg P3) => rec_ + "eou" ; --# notpresent
    VPB (PretP Pl P1) => rec_ + vars "eamos" "eámos" ; --# notpresent
    VPB (PretP Pl P2) => rec_ + "eastes" ; --# notpresent
    VPB (PretP Pl P3) => rec_ + "earam" ; --# notpresent
    VPB (Fut Ind Sg P1) => rec_ + "earei" ; --# notpresent
    VPB (Fut Ind Sg P2) => rec_ + "earás" ; --# notpresent
    VPB (Fut Ind Sg P3) => rec_ + "eará" ; --# notpresent
    VPB (Fut Ind Pl P1) => rec_ + "earemos" ; --# notpresent
    VPB (Fut Ind Pl P2) => rec_ + "eareis" ; --# notpresent
    VPB (Fut Ind Pl P3) => rec_ + "earão" ; --# notpresent
    VPB (Fut Sub Sg P1) => rec_ + "ear" ; --# notpresent
    VPB (Fut Sub Sg P2) => rec_ + "eares" ; --# notpresent
    VPB (Fut Sub Sg P3) => rec_ + "ear" ; --# notpresent
    VPB (Fut Sub Pl P1) => rec_ + "earmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => rec_ + "eardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => rec_ + "earem" ; --# notpresent
    VPB (Cond Sg P1) => rec_ + "earia" ; --# notpresent
    VPB (Cond Sg P2) => rec_ + "earias" ; --# notpresent
    VPB (Cond Sg P3) => rec_ + "earia" ; --# notpresent
    VPB (Cond Pl P1) => rec_ + "earíamos" ; --# notpresent
    VPB (Cond Pl P2) => rec_ + "earíeis" ; --# notpresent
    VPB (Cond Pl P3) => rec_ + "eariam" ; --# notpresent
    VPB (Imper Sg P2) => rec_ + "eia" ;
    VPB (Imper Sg P3) => rec_ + "eie" ;
    VPB (Imper Pl P1) => rec_ + "eemos" ;
    VPB (Imper Pl P2) => rec_ + "eai" ;
    VPB (Imper Pl P3) => rec_ + "eiem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper anunciar_Besch : Str -> Verbum = \anunciar ->
-- 16 | r46
  let anunci_ = Predef.tk 2 anunciar in
 {s = table {
    VI Infn => anunci_ + "ar" ;
    VI Ger => anunci_ + "ando" ;
    VI Part => anunci_ + "ado" ;
    VPB (Pres Ind Sg P1) => anunci_ + "o" ;
    VPB (Pres Ind Sg P2) => anunci_ + "as" ;
    VPB (Pres Ind Sg P3) => anunci_ + "a" ;
    VPB (Pres Ind Pl P1) => anunci_ + "amos" ;
    VPB (Pres Ind Pl P2) => anunci_ + "ais" ;
    VPB (Pres Ind Pl P3) => anunci_ + "am" ;
    VPB (Pres Sub Sg P1) => anunci_ + "e" ;
    VPB (Pres Sub Sg P2) => anunci_ + "es" ;
    VPB (Pres Sub Sg P3) => anunci_ + "e" ;
    VPB (Pres Sub Pl P1) => anunci_ + "emos" ;
    VPB (Pres Sub Pl P2) => anunci_ + "eis" ;
    VPB (Pres Sub Pl P3) => anunci_ + "em" ;
    VPB (PretI Ind Sg P1) => anunci_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => anunci_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => anunci_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => anunci_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => anunci_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => anunci_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => anunci_ + "asse" ; --# notpresent
    VPB (PretI Sub Sg P2) => anunci_ + "asses" ; --# notpresent
    VPB (PretI Sub Sg P3) => anunci_ + "asse" ; --# notpresent
    VPB (PretI Sub Pl P1) => anunci_ + "ássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => anunci_ + "ásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => anunci_ + "assem" ; --# notpresent
    VPB (MQPerf Sg P1) => anunci_ + "ara" ; --# notpresent
    VPB (MQPerf Sg P2) => anunci_ + "aras" ; --# notpresent
    VPB (MQPerf Sg P3) => anunci_ + "ara" ; --# notpresent
    VPB (MQPerf Pl P1) => anunci_ + "áramos" ; --# notpresent
    VPB (MQPerf Pl P2) => anunci_ + "áreis" ; --# notpresent
    VPB (MQPerf Pl P3) => anunci_ + "aram" ; --# notpresent
    VPB (PretP Sg P1) => anunci_ + "ei" ; --# notpresent
    VPB (PretP Sg P2) => anunci_ + "aste" ; --# notpresent
    VPB (PretP Sg P3) => anunci_ + "ou" ; --# notpresent
    VPB (PretP Pl P1) => anunci_ + vars "amos" "ámos" ; --# notpresent
    VPB (PretP Pl P2) => anunci_ + "astes" ; --# notpresent
    VPB (PretP Pl P3) => anunci_ + "aram" ; --# notpresent
    VPB (Fut Ind Sg P1) => anunci_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => anunci_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => anunci_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => anunci_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => anunci_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => anunci_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => anunci_ + "ar" ; --# notpresent
    VPB (Fut Sub Sg P2) => anunci_ + "ares" ; --# notpresent
    VPB (Fut Sub Sg P3) => anunci_ + "ar" ; --# notpresent
    VPB (Fut Sub Pl P1) => anunci_ + "armos" ; --# notpresent
    VPB (Fut Sub Pl P2) => anunci_ + "ardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => anunci_ + "arem" ; --# notpresent
    VPB (Cond Sg P1) => anunci_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => anunci_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => anunci_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => anunci_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => anunci_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => anunci_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => anunci_ + "a" ;
    VPB (Imper Sg P3) => anunci_ + "e" ;
    VPB (Imper Pl P1) => anunci_ + "emos" ;
    VPB (Imper Pl P2) => anunci_ + "ai" ;
    VPB (Imper Pl P3) => anunci_ + "em" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper odiar_Besch : Str -> Verbum = \odiar ->
-- 17 | r46
  let od_ = Predef.tk 3 odiar in
 {s = table {
    VI Infn => od_ + "iar" ;
    VI Ger => od_ + "iando" ;
    VI Part => od_ + "iado" ;
    VPB (Pres Ind Sg P1) => od_ + "eio" ;
    VPB (Pres Ind Sg P2) => od_ + "eias" ;
    VPB (Pres Ind Sg P3) => od_ + "eia" ;
    VPB (Pres Ind Pl P1) => od_ + "iamos" ;
    VPB (Pres Ind Pl P2) => od_ + "iais" ;
    VPB (Pres Ind Pl P3) => od_ + "eiam" ;
    VPB (Pres Sub Sg P1) => od_ + "eie" ;
    VPB (Pres Sub Sg P2) => od_ + "eies" ;
    VPB (Pres Sub Sg P3) => od_ + "eie" ;
    VPB (Pres Sub Pl P1) => od_ + "iemos" ;
    VPB (Pres Sub Pl P2) => od_ + "ieis" ;
    VPB (Pres Sub Pl P3) => od_ + "eiem" ;
    VPB (PretI Ind Sg P1) => od_ + "iava" ; --# notpresent
    VPB (PretI Ind Sg P2) => od_ + "iavas" ; --# notpresent
    VPB (PretI Ind Sg P3) => od_ + "iava" ; --# notpresent
    VPB (PretI Ind Pl P1) => od_ + "iávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => od_ + "iáveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => od_ + "iavam" ; --# notpresent
    VPB (PretI Sub Sg P1) => od_ + "iasse" ; --# notpresent
    VPB (PretI Sub Sg P2) => od_ + "iasses" ; --# notpresent
    VPB (PretI Sub Sg P3) => od_ + "iasse" ; --# notpresent
    VPB (PretI Sub Pl P1) => od_ + "iássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => od_ + "iásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => od_ + "iassem" ; --# notpresent
    VPB (MQPerf Sg P1) => od_ + "iara" ; --# notpresent
    VPB (MQPerf Sg P2) => od_ + "iaras" ; --# notpresent
    VPB (MQPerf Sg P3) => od_ + "iara" ; --# notpresent
    VPB (MQPerf Pl P1) => od_ + "iáramos" ; --# notpresent
    VPB (MQPerf Pl P2) => od_ + "ipareis" ; --# notpresent
    VPB (MQPerf Pl P3) => od_ + "iaram" ; --# notpresent
    VPB (PretP Sg P1) => od_ + "iei" ; --# notpresent
    VPB (PretP Sg P2) => od_ + "iaste" ; --# notpresent
    VPB (PretP Sg P3) => od_ + "iou" ; --# notpresent
    VPB (PretP Pl P1) => od_ + "iámos" ; --# notpresent
    VPB (PretP Pl P2) => od_ + "iastes" ; --# notpresent
    VPB (PretP Pl P3) => od_ + "iaram" ; --# notpresent
    VPB (Fut Ind Sg P1) => od_ + "iarei" ; --# notpresent
    VPB (Fut Ind Sg P2) => od_ + "iarás" ; --# notpresent
    VPB (Fut Ind Sg P3) => od_ + "iará" ; --# notpresent
    VPB (Fut Ind Pl P1) => od_ + "iaremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => od_ + "iareis" ; --# notpresent
    VPB (Fut Ind Pl P3) => od_ + "iarão" ; --# notpresent
    VPB (Fut Sub Sg P1) => od_ + "iar" ; --# notpresent
    VPB (Fut Sub Sg P2) => od_ + "iares" ; --# notpresent
    VPB (Fut Sub Sg P3) => od_ + "iar" ; --# notpresent
    VPB (Fut Sub Pl P1) => od_ + "iarmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => od_ + "iardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => od_ + "iarem" ; --# notpresent
    VPB (Cond Sg P1) => od_ + "iaria" ; --# notpresent
    VPB (Cond Sg P2) => od_ + "iarias" ; --# notpresent
    VPB (Cond Sg P3) => od_ + "iaria" ; --# notpresent
    VPB (Cond Pl P1) => od_ + "iaríamos" ; --# notpresent
    VPB (Cond Pl P2) => od_ + "iaríeis" ; --# notpresent
    VPB (Cond Pl P3) => od_ + "iariam" ; --# notpresent
    VPB (Imper Sg P2) => od_ + "eia" ;
    VPB (Imper Sg P3) => od_ + "eie" ;
    VPB (Imper Pl P1) => od_ + "iemos" ;
    VPB (Imper Pl P2) => od_ + "iai" ;
    VPB (Imper Pl P3) => od_ + "eiem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper comerciar_Besch : Str -> Verbum = \comerciar ->
-- 18 | r36
  let comerc_ = Predef.tk 3 comerciar in
 {s = table {
    VI Infn => comerc_ + "iar" ;
    VI Ger => comerc_ + "iando" ;
    VI Part => comerc_ + "iado" ;
    VPB (Pres Ind Sg P1) => comerc_ + vars "eio" "io" ;
    VPB (Pres Ind Sg P2) => comerc_ + vars "eias" "ias" ;
    VPB (Pres Ind Sg P3) => comerc_ + vars "eia" "ia" ;
    VPB (Pres Ind Pl P1) => comerc_ + "iamos" ;
    VPB (Pres Ind Pl P2) => comerc_ + "iais" ;
    VPB (Pres Ind Pl P3) => comerc_ + vars "eiam" "iam" ;
    VPB (Pres Sub Sg P1) => comerc_ + vars "eie" "ie" ;
    VPB (Pres Sub Sg P2) => comerc_ + vars "eies" "ies" ;
    VPB (Pres Sub Sg P3) => comerc_ + vars "eie" "ie" ;
    VPB (Pres Sub Pl P1) => comerc_ + "iemos" ;
    VPB (Pres Sub Pl P2) => comerc_ + "ieis" ;
    VPB (Pres Sub Pl P3) => comerc_ + vars "eiem" "iem" ;
    VPB (PretI Ind Sg P1) => comerc_ + "iava" ; --# notpresent
    VPB (PretI Ind Sg P2) => comerc_ + "iavas" ; --# notpresent
    VPB (PretI Ind Sg P3) => comerc_ + "iava" ; --# notpresent
    VPB (PretI Ind Pl P1) => comerc_ + "iávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => comerc_ + "iáveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => comerc_ + "iavam" ; --# notpresent
    VPB (PretI Sub Sg P1) => comerc_ + "iasse" ; --# notpresent
    VPB (PretI Sub Sg P2) => comerc_ + "iasses" ; --# notpresent
    VPB (PretI Sub Sg P3) => comerc_ + "iasse" ; --# notpresent
    VPB (PretI Sub Pl P1) => comerc_ + "iássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => comerc_ + "iásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => comerc_ + "iassem" ; --# notpresent
    VPB (MQPerf Sg P1) => comerc_ + "iara" ; --# notpresent
    VPB (MQPerf Sg P2) => comerc_ + "iaras" ; --# notpresent
    VPB (MQPerf Sg P3) => comerc_ + "iara" ; --# notpresent
    VPB (MQPerf Pl P1) => comerc_ + "iáramos" ; --# notpresent
    VPB (MQPerf Pl P2) => comerc_ + "iáreis" ; --# notpresent
    VPB (MQPerf Pl P3) => comerc_ + "iaram" ; --# notpresent
    VPB (PretP Sg P1) => comerc_ + "iei" ; --# notpresent
    VPB (PretP Sg P2) => comerc_ + "iaste" ; --# notpresent
    VPB (PretP Sg P3) => comerc_ + "iou" ; --# notpresent
    VPB (PretP Pl P1) => comerc_ + vars "iamos" "iámos" ; --# notpresent
    VPB (PretP Pl P2) => comerc_ + "iastes" ; --# notpresent
    VPB (PretP Pl P3) => comerc_ + "iaram" ; --# notpresent
    VPB (Fut Ind Sg P1) => comerc_ + "iarei" ; --# notpresent
    VPB (Fut Ind Sg P2) => comerc_ + "iarás" ; --# notpresent
    VPB (Fut Ind Sg P3) => comerc_ + "iará" ; --# notpresent
    VPB (Fut Ind Pl P1) => comerc_ + "iaremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => comerc_ + "iareis" ; --# notpresent
    VPB (Fut Ind Pl P3) => comerc_ + "iarão" ; --# notpresent
    VPB (Fut Sub Sg P1) => comerc_ + "iar" ; --# notpresent
    VPB (Fut Sub Sg P2) => comerc_ + "iares" ; --# notpresent
    VPB (Fut Sub Sg P3) => comerc_ + "iar" ; --# notpresent
    VPB (Fut Sub Pl P1) => comerc_ + "iarmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => comerc_ + "iardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => comerc_ + "iarem" ; --# notpresent
    VPB (Cond Sg P1) => comerc_ + "iaria" ; --# notpresent
    VPB (Cond Sg P2) => comerc_ + "iarias" ; --# notpresent
    VPB (Cond Sg P3) => comerc_ + "iaria" ; --# notpresent
    VPB (Cond Pl P1) => comerc_ + "iaríamos" ; --# notpresent
    VPB (Cond Pl P2) => comerc_ + "iaríeis" ; --# notpresent
    VPB (Cond Pl P3) => comerc_ + "iariam" ; --# notpresent
    VPB (Imper Sg P2) => comerc_ + vars "eia" "ia" ;
    VPB (Imper Sg P3) => comerc_ + vars "eie" "ie" ;
    VPB (Imper Pl P1) => comerc_ + "iemos" ;
    VPB (Imper Pl P2) => comerc_ + "iai" ;
    VPB (Imper Pl P3) => comerc_ + vars "eiem" "iem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper saudar_Besch : Str -> Verbum = \saudar ->
-- 19 | r16
  let sa_ = Predef.tk 4 saudar in
 {s = table {
    VI Infn => sa_ + "udar" ;
    VI Ger => sa_ + "udando" ;
    VI Part => sa_ + "udado" ;
    VPB (Pres Ind Sg P1) => sa_ + "údo" ;
    VPB (Pres Ind Sg P2) => sa_ + "údas" ;
    VPB (Pres Ind Sg P3) => sa_ + "úda" ;
    VPB (Pres Ind Pl P1) => sa_ + "udamos" ;
    VPB (Pres Ind Pl P2) => sa_ + "udais" ;
    VPB (Pres Ind Pl P3) => sa_ + "údam" ;
    VPB (Pres Sub Sg P1) => sa_ + "úde" ;
    VPB (Pres Sub Sg P2) => sa_ + "údes" ;
    VPB (Pres Sub Sg P3) => sa_ + "úde" ;
    VPB (Pres Sub Pl P1) => sa_ + "udemos" ;
    VPB (Pres Sub Pl P2) => sa_ + "udeis" ;
    VPB (Pres Sub Pl P3) => sa_ + "údem" ;
    VPB (PretI Ind Sg P1) => sa_ + "udava" ; --# notpresent
    VPB (PretI Ind Sg P2) => sa_ + "udavas" ; --# notpresent
    VPB (PretI Ind Sg P3) => sa_ + "udava" ; --# notpresent
    VPB (PretI Ind Pl P1) => sa_ + "udávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => sa_ + "udáveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => sa_ + "udavam" ; --# notpresent
    VPB (PretI Sub Sg P1) => sa_ + "udasse" ; --# notpresent
    VPB (PretI Sub Sg P2) => sa_ + "udasses" ; --# notpresent
    VPB (PretI Sub Sg P3) => sa_ + "udasse" ; --# notpresent
    VPB (PretI Sub Pl P1) => sa_ + "udássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => sa_ + "udásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => sa_ + "udassem" ; --# notpresent
    VPB (MQPerf Sg P1) => sa_ + "udara" ; --# notpresent
    VPB (MQPerf Sg P2) => sa_ + "udaras" ; --# notpresent
    VPB (MQPerf Sg P3) => sa_ + "udara" ; --# notpresent
    VPB (MQPerf Pl P1) => sa_ + "udáramos" ; --# notpresent
    VPB (MQPerf Pl P2) => sa_ + "udáreis" ; --# notpresent
    VPB (MQPerf Pl P3) => sa_ + "udaram" ; --# notpresent
    VPB (PretP Sg P1) => sa_ + "udei" ; --# notpresent
    VPB (PretP Sg P2) => sa_ + "udaste" ; --# notpresent
    VPB (PretP Sg P3) => sa_ + "udou" ; --# notpresent
    VPB (PretP Pl P1) => sa_ + vars "udamos" "udámos" ; --# notpresent
    VPB (PretP Pl P2) => sa_ + "udastes" ; --# notpresent
    VPB (PretP Pl P3) => sa_ + "udaram" ; --# notpresent
    VPB (Fut Ind Sg P1) => sa_ + "udarei" ; --# notpresent
    VPB (Fut Ind Sg P2) => sa_ + "udarás" ; --# notpresent
    VPB (Fut Ind Sg P3) => sa_ + "udará" ; --# notpresent
    VPB (Fut Ind Pl P1) => sa_ + "udaremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => sa_ + "udareis" ; --# notpresent
    VPB (Fut Ind Pl P3) => sa_ + "udarão" ; --# notpresent
    VPB (Fut Sub Sg P1) => sa_ + "udar" ; --# notpresent
    VPB (Fut Sub Sg P2) => sa_ + "udares" ; --# notpresent
    VPB (Fut Sub Sg P3) => sa_ + "udar" ; --# notpresent
    VPB (Fut Sub Pl P1) => sa_ + "udarmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => sa_ + "udardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => sa_ + "udarem" ; --# notpresent
    VPB (Cond Sg P1) => sa_ + "udaria" ; --# notpresent
    VPB (Cond Sg P2) => sa_ + "udarias" ; --# notpresent
    VPB (Cond Sg P3) => sa_ + "udaria" ; --# notpresent
    VPB (Cond Pl P1) => sa_ + "udaríamos" ; --# notpresent
    VPB (Cond Pl P2) => sa_ + "udaríeis" ; --# notpresent
    VPB (Cond Pl P3) => sa_ + "udariam" ; --# notpresent
    VPB (Imper Sg P2) => sa_ + "úda" ;
    VPB (Imper Sg P3) => sa_ + "úde" ;
    VPB (Imper Pl P1) => sa_ + "udemos" ;
    VPB (Imper Pl P2) => sa_ + "udai" ;
    VPB (Imper Pl P3) => sa_ + "údem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper perdoar_Besch : Str -> Verbum = \perdoar ->
-- 20 | r38
  let perd_ = Predef.tk 3 perdoar in
 {s = table {
    VI Infn => perd_ + "oar" ;
    VI Ger => perd_ + "oando" ;
    VI Part => perd_ + "oado" ;
    VPB (Pres Ind Sg P1) => perd_ + vars "ôo" "oo" ;
    VPB (Pres Ind Sg P2) => perd_ + "oas" ;
    VPB (Pres Ind Sg P3) => perd_ + "oa" ;
    VPB (Pres Ind Pl P1) => perd_ + "oamos" ;
    VPB (Pres Ind Pl P2) => perd_ + "oais" ;
    VPB (Pres Ind Pl P3) => perd_ + "oam" ;
    VPB (Pres Sub Sg P1) => perd_ + "oe" ;
    VPB (Pres Sub Sg P2) => perd_ + "oes" ;
    VPB (Pres Sub Sg P3) => perd_ + "oe" ;
    VPB (Pres Sub Pl P1) => perd_ + "oemos" ;
    VPB (Pres Sub Pl P2) => perd_ + "oeis" ;
    VPB (Pres Sub Pl P3) => perd_ + "oem" ;
    VPB (PretI Ind Sg P1) => perd_ + "oava" ; --# notpresent
    VPB (PretI Ind Sg P2) => perd_ + "oavas" ; --# notpresent
    VPB (PretI Ind Sg P3) => perd_ + "oava" ; --# notpresent
    VPB (PretI Ind Pl P1) => perd_ + "oávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => perd_ + "oáveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => perd_ + "oavam" ; --# notpresent
    VPB (PretI Sub Sg P1) => perd_ + "oasse" ; --# notpresent
    VPB (PretI Sub Sg P2) => perd_ + "oasses" ; --# notpresent
    VPB (PretI Sub Sg P3) => perd_ + "oasse" ; --# notpresent
    VPB (PretI Sub Pl P1) => perd_ + "oássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => perd_ + "oásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => perd_ + "oassem" ; --# notpresent
    VPB (MQPerf Sg P1) => perd_ + "oara" ; --# notpresent
    VPB (MQPerf Sg P2) => perd_ + "oaras" ; --# notpresent
    VPB (MQPerf Sg P3) => perd_ + "oara" ; --# notpresent
    VPB (MQPerf Pl P1) => perd_ + "oáramos" ; --# notpresent
    VPB (MQPerf Pl P2) => perd_ + "oáreis" ; --# notpresent
    VPB (MQPerf Pl P3) => perd_ + "oaram" ; --# notpresent
    VPB (PretP Sg P1) => perd_ + "oei" ; --# notpresent
    VPB (PretP Sg P2) => perd_ + "oaste" ; --# notpresent
    VPB (PretP Sg P3) => perd_ + "oou" ; --# notpresent
    VPB (PretP Pl P1) => perd_ + "oamos" ; --# notpresent
    VPB (PretP Pl P2) => perd_ + "oastes" ; --# notpresent
    VPB (PretP Pl P3) => perd_ + "oaram" ; --# notpresent
    VPB (Fut Ind Sg P1) => perd_ + "oarei" ; --# notpresent
    VPB (Fut Ind Sg P2) => perd_ + "oarás" ; --# notpresent
    VPB (Fut Ind Sg P3) => perd_ + "oará" ; --# notpresent
    VPB (Fut Ind Pl P1) => perd_ + "oaremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => perd_ + "oareis" ; --# notpresent
    VPB (Fut Ind Pl P3) => perd_ + "oarão" ; --# notpresent
    VPB (Fut Sub Sg P1) => perd_ + "oar" ; --# notpresent
    VPB (Fut Sub Sg P2) => perd_ + "oares" ; --# notpresent
    VPB (Fut Sub Sg P3) => perd_ + "oar" ; --# notpresent
    VPB (Fut Sub Pl P1) => perd_ + "oarmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => perd_ + "oardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => perd_ + "oarem" ; --# notpresent
    VPB (Cond Sg P1) => perd_ + "oaria" ; --# notpresent
    VPB (Cond Sg P2) => perd_ + "oarias" ; --# notpresent
    VPB (Cond Sg P3) => perd_ + "oaria" ; --# notpresent
    VPB (Cond Pl P1) => perd_ + "oaríamos" ; --# notpresent
    VPB (Cond Pl P2) => perd_ + "oaríeis" ; --# notpresent
    VPB (Cond Pl P3) => perd_ + "oariam" ; --# notpresent
    VPB (Imper Sg P2) => perd_ + "oa" ;
    VPB (Imper Sg P3) => perd_ + "oe" ;
    VPB (Imper Pl P1) => perd_ + "oemos" ;
    VPB (Imper Pl P2) => perd_ + "oai" ;
    VPB (Imper Pl P3) => perd_ + "oem" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper averiguar_Besch : Str -> Verbum = \averiguar ->
-- 21 | r30
  let averigu_ = Predef.tk 2 averiguar in
 {s = table {
    VI Infn => averigu_ + "ar" ;
    VI Ger => averigu_ + "ando" ;
    VI Part => averigu_ + "ado" ;
    VPB (Pres Ind Sg P1) => averigu_ + "o" ;
    VPB (Pres Ind Sg P2) => averigu_ + "as" ;
    VPB (Pres Ind Sg P3) => averigu_ + "a" ;
    VPB (Pres Ind Pl P1) => averigu_ + "amos" ;
    VPB (Pres Ind Pl P2) => averigu_ + "ais" ;
    VPB (Pres Ind Pl P3) => averigu_ + "am" ;
    VPB (Pres Sub Sg P1) => averigu_ + "e" ;
    VPB (Pres Sub Sg P2) => averigu_ + "es" ;
    VPB (Pres Sub Sg P3) => averigu_ + "e" ;
    VPB (Pres Sub Pl P1) => averigu_ + "emos" ;
    VPB (Pres Sub Pl P2) => averigu_ + "eis" ;
    VPB (Pres Sub Pl P3) => averigu_ + "em" ;
    VPB (PretI Ind Sg P1) => averigu_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => averigu_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => averigu_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => averigu_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => averigu_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => averigu_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => averigu_ + "asse" ; --# notpresent
    VPB (PretI Sub Sg P2) => averigu_ + "asses" ; --# notpresent
    VPB (PretI Sub Sg P3) => averigu_ + "asse" ; --# notpresent
    VPB (PretI Sub Pl P1) => averigu_ + "ássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => averigu_ + "ásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => averigu_ + "assem" ; --# notpresent
    VPB (MQPerf Sg P1) => averigu_ + "ara" ; --# notpresent
    VPB (MQPerf Sg P2) => averigu_ + "aras" ; --# notpresent
    VPB (MQPerf Sg P3) => averigu_ + "ara" ; --# notpresent
    VPB (MQPerf Pl P1) => averigu_ + "áramos" ; --# notpresent
    VPB (MQPerf Pl P2) => averigu_ + "áreis" ; --# notpresent
    VPB (MQPerf Pl P3) => averigu_ + "aram" ; --# notpresent
    VPB (PretP Sg P1) => averigu_ + "ei" ; --# notpresent
    VPB (PretP Sg P2) => averigu_ + "aste" ; --# notpresent
    VPB (PretP Sg P3) => averigu_ + "ou" ; --# notpresent
    VPB (PretP Pl P1) => averigu_ + "amos" ; --# notpresent
    VPB (PretP Pl P2) => averigu_ + "astes" ; --# notpresent
    VPB (PretP Pl P3) => averigu_ + "aram" ; --# notpresent
    VPB (Fut Ind Sg P1) => averigu_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => averigu_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => averigu_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => averigu_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => averigu_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => averigu_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => averigu_ + "ar" ; --# notpresent
    VPB (Fut Sub Sg P2) => averigu_ + "ares" ; --# notpresent
    VPB (Fut Sub Sg P3) => averigu_ + "ar" ; --# notpresent
    VPB (Fut Sub Pl P1) => averigu_ + "armos" ; --# notpresent
    VPB (Fut Sub Pl P2) => averigu_ + "ardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => averigu_ + "arem" ; --# notpresent
    VPB (Cond Sg P1) => averigu_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => averigu_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => averigu_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => averigu_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => averigu_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => averigu_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => averigu_ + "a" ;
    VPB (Imper Sg P3) => averigu_ + "e" ;
    VPB (Imper Pl P1) => averigu_ + "emos" ;
    VPB (Imper Pl P2) => averigu_ + "ai" ;
    VPB (Imper Pl P3) => averigu_ + "em" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper neviscar_Besch : Str -> Verbum = \neviscar ->
-- 22 | r23
  let n_ = Predef.tk 7 neviscar in
 {s = table {
    VI Infn => n_ + "eviscar" ;
    VI Ger => n_ + "eviscando" ;
    VI Part => n_ + "eviscado" ;
    VPB (Pres Ind Sg P1) => n_ + nonExist ;
    VPB (Pres Ind Sg P2) => n_ + nonExist ;
    VPB (Pres Ind Sg P3) => n_ + "evisca" ;
    VPB (Pres Ind Pl P1) => n_ + nonExist ;
    VPB (Pres Ind Pl P2) => n_ + nonExist ;
    VPB (Pres Ind Pl P3) => n_ + nonExist ;
    VPB (Pres Sub Sg P1) => n_ + nonExist ;
    VPB (Pres Sub Sg P2) => n_ + nonExist ;
    VPB (Pres Sub Sg P3) => n_ + "evisque" ;
    VPB (Pres Sub Pl P1) => n_ + nonExist ;
    VPB (Pres Sub Pl P2) => n_ + nonExist ;
    VPB (Pres Sub Pl P3) => n_ + nonExist ;
    VPB (PretI Ind Sg P1) => n_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P2) => n_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P3) => n_ + "eviscava" ; --# notpresent
    VPB (PretI Ind Pl P1) => n_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P2) => n_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P3) => n_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P1) => n_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P2) => n_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P3) => n_ + "eviscasse" ; --# notpresent
    VPB (PretI Sub Pl P1) => n_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P2) => n_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P3) => n_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P1) => n_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P2) => n_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P3) => n_ + "eviscara" ; --# notpresent
    VPB (MQPerf Pl P1) => n_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P2) => n_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P3) => n_ + nonExist ; --# notpresent
    VPB (PretP Sg P1) => n_ + nonExist ; --# notpresent
    VPB (PretP Sg P2) => n_ + nonExist ; --# notpresent
    VPB (PretP Sg P3) => n_ + "eviscou" ; --# notpresent
    VPB (PretP Pl P1) => n_ + nonExist ; --# notpresent
    VPB (PretP Pl P2) => n_ + nonExist ; --# notpresent
    VPB (PretP Pl P3) => n_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P1) => n_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P2) => n_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P3) => n_ + "eviscará" ; --# notpresent
    VPB (Fut Ind Pl P1) => n_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P2) => n_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P3) => n_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P1) => n_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P2) => n_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P3) => n_ + "eviscar" ; --# notpresent
    VPB (Fut Sub Pl P1) => n_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P2) => n_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P3) => n_ + nonExist ; --# notpresent
    VPB (Cond Sg P1) => n_ + nonExist ; --# notpresent
    VPB (Cond Sg P2) => n_ + nonExist ; --# notpresent
    VPB (Cond Sg P3) => n_ + "eviscaria" ; --# notpresent
    VPB (Cond Pl P1) => n_ + nonExist ; --# notpresent
    VPB (Cond Pl P2) => n_ + nonExist ; --# notpresent
    VPB (Cond Pl P3) => n_ + nonExist ; --# notpresent
    VPB (Imper Sg P2) => n_ + nonExist ;
    VPB (Imper Sg P3) => n_ + nonExist ;
    VPB (Imper Pl P1) => n_ + nonExist ;
    VPB (Imper Pl P2) => n_ + nonExist ;
    VPB (Imper Pl P3) => n_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper adequar_Besch : Str -> Verbum = \adequar ->
-- 23 | r82
  let adequ_ = Predef.tk 2 adequar in
 {s = table {
    VI Infn => adequ_ + "ar" ;
    VI Ger => adequ_ + "ando" ;
    VI Part => adequ_ + "ado" ;
    VPB (Pres Ind Sg P1) => adequ_ + nonExist ;
    VPB (Pres Ind Sg P2) => adequ_ + nonExist ;
    VPB (Pres Ind Sg P3) => adequ_ + nonExist ;
    VPB (Pres Ind Pl P1) => adequ_ + "amos" ;
    VPB (Pres Ind Pl P2) => adequ_ + "ais" ;
    VPB (Pres Ind Pl P3) => adequ_ + nonExist ;
    VPB (Pres Sub Sg P1) => adequ_ + nonExist ;
    VPB (Pres Sub Sg P2) => adequ_ + nonExist ;
    VPB (Pres Sub Sg P3) => adequ_ + nonExist ;
    VPB (Pres Sub Pl P1) => adequ_ + "emos" ;
    VPB (Pres Sub Pl P2) => adequ_ + "eis" ;
    VPB (Pres Sub Pl P3) => adequ_ + nonExist ;
    VPB (PretI Ind Sg P1) => adequ_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => adequ_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => adequ_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => adequ_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => adequ_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => adequ_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => adequ_ + "asse" ; --# notpresent
    VPB (PretI Sub Sg P2) => adequ_ + "asses" ; --# notpresent
    VPB (PretI Sub Sg P3) => adequ_ + "asse" ; --# notpresent
    VPB (PretI Sub Pl P1) => adequ_ + "ássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => adequ_ + "ásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => adequ_ + "assem" ; --# notpresent
    VPB (MQPerf Sg P1) => adequ_ + "ara" ; --# notpresent
    VPB (MQPerf Sg P2) => adequ_ + "aras" ; --# notpresent
    VPB (MQPerf Sg P3) => adequ_ + "ara" ; --# notpresent
    VPB (MQPerf Pl P1) => adequ_ + "áramos" ; --# notpresent
    VPB (MQPerf Pl P2) => adequ_ + "áreis" ; --# notpresent
    VPB (MQPerf Pl P3) => adequ_ + "aram" ; --# notpresent
    VPB (PretP Sg P1) => adequ_ + "ei" ; --# notpresent
    VPB (PretP Sg P2) => adequ_ + "aste" ; --# notpresent
    VPB (PretP Sg P3) => adequ_ + "ou" ; --# notpresent
    VPB (PretP Pl P1) => adequ_ + vars "amos" "ámos" ; --# notpresent
    VPB (PretP Pl P2) => adequ_ + "astes" ; --# notpresent
    VPB (PretP Pl P3) => adequ_ + "aram" ; --# notpresent
    VPB (Fut Ind Sg P1) => adequ_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => adequ_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => adequ_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => adequ_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => adequ_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => adequ_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => adequ_ + "ar" ; --# notpresent
    VPB (Fut Sub Sg P2) => adequ_ + "ares" ; --# notpresent
    VPB (Fut Sub Sg P3) => adequ_ + "ar" ; --# notpresent
    VPB (Fut Sub Pl P1) => adequ_ + "armos" ; --# notpresent
    VPB (Fut Sub Pl P2) => adequ_ + "ardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => adequ_ + "arem" ; --# notpresent
    VPB (Cond Sg P1) => adequ_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => adequ_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => adequ_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => adequ_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => adequ_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => adequ_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => adequ_ + nonExist ;
    VPB (Imper Sg P3) => adequ_ + nonExist ;
    VPB (Imper Pl P1) => adequ_ + "emos" ;
    VPB (Imper Pl P2) => adequ_ + "ai" ;
    VPB (Imper Pl P3) => adequ_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper relampaguear_Besch : Str -> Verbum = \relampaguear ->
-- 24
  let relamp_ = Predef.tk 6 relampaguear in
 {s = table {
    VI Infn => relamp_ + "aguear" ;
    VI Ger => relamp_ + "agueando" ;
    VI Part => relamp_ + "agueado" ;
    VPB (Pres Ind Sg P1) => relamp_ + nonExist ;
    VPB (Pres Ind Sg P2) => relamp_ + nonExist ;
    VPB (Pres Ind Sg P3) => relamp_ + "agueia" ;
    VPB (Pres Ind Pl P1) => relamp_ + nonExist ;
    VPB (Pres Ind Pl P2) => relamp_ + nonExist ;
    VPB (Pres Ind Pl P3) => relamp_ + "agueiam" ;
    VPB (Pres Sub Sg P1) => relamp_ + nonExist ;
    VPB (Pres Sub Sg P2) => relamp_ + nonExist ;
    VPB (Pres Sub Sg P3) => relamp_ + "agueie" ;
    VPB (Pres Sub Pl P1) => relamp_ + nonExist ;
    VPB (Pres Sub Pl P2) => relamp_ + nonExist ;
    VPB (Pres Sub Pl P3) => relamp_ + "agueiem" ;
    VPB (PretI Ind Sg P1) => relamp_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P2) => relamp_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P3) => relamp_ + "agueava" ; --# notpresent
    VPB (PretI Ind Pl P1) => relamp_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P2) => relamp_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P3) => relamp_ + "agueavam" ; --# notpresent
    VPB (PretI Sub Sg P1) => relamp_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P2) => relamp_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P3) => relamp_ + "agueasse" ; --# notpresent
    VPB (PretI Sub Pl P1) => relamp_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P2) => relamp_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P3) => relamp_ + "agueassem" ; --# notpresent
    VPB (MQPerf Sg P1) => relamp_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P2) => relamp_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P3) => relamp_ + "agueara" ; --# notpresent
    VPB (MQPerf Pl P1) => relamp_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P2) => relamp_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P3) => relamp_ + "aguearam" ; --# notpresent
    VPB (PretP Sg P1) => relamp_ + nonExist ; --# notpresent
    VPB (PretP Sg P2) => relamp_ + nonExist ; --# notpresent
    VPB (PretP Sg P3) => relamp_ + "agueou" ; --# notpresent
    VPB (PretP Pl P1) => relamp_ + nonExist ; --# notpresent
    VPB (PretP Pl P2) => relamp_ + nonExist ; --# notpresent
    VPB (PretP Pl P3) => relamp_ + "aguearam" ; --# notpresent
    VPB (Fut Ind Sg P1) => relamp_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P2) => relamp_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P3) => relamp_ + "agueará" ; --# notpresent
    VPB (Fut Ind Pl P1) => relamp_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P2) => relamp_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P3) => relamp_ + "aguearão" ; --# notpresent
    VPB (Fut Sub Sg P1) => relamp_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P2) => relamp_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P3) => relamp_ + "aguear" ; --# notpresent
    VPB (Fut Sub Pl P1) => relamp_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P2) => relamp_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P3) => relamp_ + "aguearem" ; --# notpresent
    VPB (Cond Sg P1) => relamp_ + nonExist ; --# notpresent
    VPB (Cond Sg P2) => relamp_ + nonExist ; --# notpresent
    VPB (Cond Sg P3) => relamp_ + "eguearia" ; --# notpresent
    VPB (Cond Pl P1) => relamp_ + nonExist ; --# notpresent
    VPB (Cond Pl P2) => relamp_ + nonExist ; --# notpresent
    VPB (Cond Pl P3) => relamp_ + "agueariam" ; --# notpresent
    VPB (Imper Sg P2) => relamp_ + nonExist ;
    VPB (Imper Sg P3) => relamp_ + nonExist ;
    VPB (Imper Pl P1) => relamp_ + nonExist ;
    VPB (Imper Pl P2) => relamp_ + nonExist ;
    VPB (Imper Pl P3) => relamp_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper aquecer_Besch : Str -> Verbum = \aquecer ->
-- 25 | r25
  let aque_ = Predef.tk 3 aquecer in
 {s = table {
    VI Infn => aque_ + "cer" ;
    VI Ger => aque_ + "cendo" ;
    VI Part => aque_ + "cido" ;
    VPB (Pres Ind Sg P1) => aque_ + "ço" ;
    VPB (Pres Ind Sg P2) => aque_ + "ces" ;
    VPB (Pres Ind Sg P3) => aque_ + "ce" ;
    VPB (Pres Ind Pl P1) => aque_ + "cemos" ;
    VPB (Pres Ind Pl P2) => aque_ + "ceis" ;
    VPB (Pres Ind Pl P3) => aque_ + "cem" ;
    VPB (Pres Sub Sg P1) => aque_ + "ça" ;
    VPB (Pres Sub Sg P2) => aque_ + "ças" ;
    VPB (Pres Sub Sg P3) => aque_ + "ça" ;
    VPB (Pres Sub Pl P1) => aque_ + "çamos" ;
    VPB (Pres Sub Pl P2) => aque_ + "çais" ;
    VPB (Pres Sub Pl P3) => aque_ + "çam" ;
    VPB (PretI Ind Sg P1) => aque_ + "cia" ; --# notpresent
    VPB (PretI Ind Sg P2) => aque_ + "cias" ; --# notpresent
    VPB (PretI Ind Sg P3) => aque_ + "cia" ; --# notpresent
    VPB (PretI Ind Pl P1) => aque_ + "ciamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => aque_ + "cíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => aque_ + "ciam" ; --# notpresent
    VPB (PretI Sub Sg P1) => aque_ + "cesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => aque_ + "cesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => aque_ + "cesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => aque_ + "cêssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => aque_ + "cêsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => aque_ + "cessem" ; --# notpresent
    VPB (MQPerf Sg P1) => aque_ + "cera" ; --# notpresent
    VPB (MQPerf Sg P2) => aque_ + "ceras" ; --# notpresent
    VPB (MQPerf Sg P3) => aque_ + "cera" ; --# notpresent
    VPB (MQPerf Pl P1) => aque_ + "cêramos" ; --# notpresent
    VPB (MQPerf Pl P2) => aque_ + "cêreis" ; --# notpresent
    VPB (MQPerf Pl P3) => aque_ + "ceram" ; --# notpresent
    VPB (PretP Sg P1) => aque_ + "ci" ; --# notpresent
    VPB (PretP Sg P2) => aque_ + "ceste" ; --# notpresent
    VPB (PretP Sg P3) => aque_ + "ceu" ; --# notpresent
    VPB (PretP Pl P1) => aque_ + "cemos" ; --# notpresent
    VPB (PretP Pl P2) => aque_ + "cestes" ; --# notpresent
    VPB (PretP Pl P3) => aque_ + "ceram" ; --# notpresent
    VPB (Fut Ind Sg P1) => aque_ + "cerei" ; --# notpresent
    VPB (Fut Ind Sg P2) => aque_ + "cerás" ; --# notpresent
    VPB (Fut Ind Sg P3) => aque_ + "cerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => aque_ + "ceremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => aque_ + "cereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => aque_ + "cerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => aque_ + "cer" ; --# notpresent
    VPB (Fut Sub Sg P2) => aque_ + "ceres" ; --# notpresent
    VPB (Fut Sub Sg P3) => aque_ + "cer" ; --# notpresent
    VPB (Fut Sub Pl P1) => aque_ + "cermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => aque_ + "cerdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => aque_ + "cerem" ; --# notpresent
    VPB (Cond Sg P1) => aque_ + "ceria" ; --# notpresent
    VPB (Cond Sg P2) => aque_ + "cerias" ; --# notpresent
    VPB (Cond Sg P3) => aque_ + "ceria" ; --# notpresent
    VPB (Cond Pl P1) => aque_ + "ceríamos" ; --# notpresent
    VPB (Cond Pl P2) => aque_ + "ceríeis" ; --# notpresent
    VPB (Cond Pl P3) => aque_ + "ceriam" ; --# notpresent
    VPB (Imper Sg P2) => aque_ + "ce" ;
    VPB (Imper Sg P3) => aque_ + "ça" ;
    VPB (Imper Pl P1) => aque_ + "çamos" ;
    VPB (Imper Pl P2) => aque_ + "cei" ;
    VPB (Imper Pl P3) => aque_ + "çam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper proteger_Besch : Str -> Verbum = \proteger ->
-- 26 | r27
  let prote_ = Predef.tk 3 proteger in
 {s = table {
    VI Infn => prote_ + "ger" ;
    VI Ger => prote_ + "gendo" ;
    VI Part => prote_ + "gido" ;
    VPB (Pres Ind Sg P1) => prote_ + "jo" ;
    VPB (Pres Ind Sg P2) => prote_ + "ges" ;
    VPB (Pres Ind Sg P3) => prote_ + "ge" ;
    VPB (Pres Ind Pl P1) => prote_ + "gemos" ;
    VPB (Pres Ind Pl P2) => prote_ + "geis" ;
    VPB (Pres Ind Pl P3) => prote_ + "gem" ;
    VPB (Pres Sub Sg P1) => prote_ + "ja" ;
    VPB (Pres Sub Sg P2) => prote_ + "jas" ;
    VPB (Pres Sub Sg P3) => prote_ + "ja" ;
    VPB (Pres Sub Pl P1) => prote_ + "jamos" ;
    VPB (Pres Sub Pl P2) => prote_ + "jais" ;
    VPB (Pres Sub Pl P3) => prote_ + "jam" ;
    VPB (PretI Ind Sg P1) => prote_ + "gia" ; --# notpresent
    VPB (PretI Ind Sg P2) => prote_ + "gias" ; --# notpresent
    VPB (PretI Ind Sg P3) => prote_ + "gia" ; --# notpresent
    VPB (PretI Ind Pl P1) => prote_ + "gíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => prote_ + "gíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => prote_ + "giam" ; --# notpresent
    VPB (PretI Sub Sg P1) => prote_ + "gesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => prote_ + "gesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => prote_ + "gesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => prote_ + "gêssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => prote_ + "gêsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => prote_ + "gessem" ; --# notpresent
    VPB (MQPerf Sg P1) => prote_ + "gera" ; --# notpresent
    VPB (MQPerf Sg P2) => prote_ + "geras" ; --# notpresent
    VPB (MQPerf Sg P3) => prote_ + "gera" ; --# notpresent
    VPB (MQPerf Pl P1) => prote_ + "gêramos" ; --# notpresent
    VPB (MQPerf Pl P2) => prote_ + "gêreis" ; --# notpresent
    VPB (MQPerf Pl P3) => prote_ + "geram" ; --# notpresent
    VPB (PretP Sg P1) => prote_ + "gi" ; --# notpresent
    VPB (PretP Sg P2) => prote_ + "geste" ; --# notpresent
    VPB (PretP Sg P3) => prote_ + "geu" ; --# notpresent
    VPB (PretP Pl P1) => prote_ + "gemos" ; --# notpresent
    VPB (PretP Pl P2) => prote_ + "gestes" ; --# notpresent
    VPB (PretP Pl P3) => prote_ + "geram" ; --# notpresent
    VPB (Fut Ind Sg P1) => prote_ + "gerei" ; --# notpresent
    VPB (Fut Ind Sg P2) => prote_ + "gerás" ; --# notpresent
    VPB (Fut Ind Sg P3) => prote_ + "gerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => prote_ + "geremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => prote_ + "gereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => prote_ + "gerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => prote_ + "ger" ; --# notpresent
    VPB (Fut Sub Sg P2) => prote_ + "geres" ; --# notpresent
    VPB (Fut Sub Sg P3) => prote_ + "ger" ; --# notpresent
    VPB (Fut Sub Pl P1) => prote_ + "germos" ; --# notpresent
    VPB (Fut Sub Pl P2) => prote_ + "gerdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => prote_ + "gerem" ; --# notpresent
    VPB (Cond Sg P1) => prote_ + "geria" ; --# notpresent
    VPB (Cond Sg P2) => prote_ + "gerias" ; --# notpresent
    VPB (Cond Sg P3) => prote_ + "geria" ; --# notpresent
    VPB (Cond Pl P1) => prote_ + "geríamos" ; --# notpresent
    VPB (Cond Pl P2) => prote_ + "geríeis" ; --# notpresent
    VPB (Cond Pl P3) => prote_ + "geriam" ; --# notpresent
    VPB (Imper Sg P2) => prote_ + "ge" ;
    VPB (Imper Sg P3) => prote_ + "ja" ;
    VPB (Imper Pl P1) => prote_ + "jamos" ;
    VPB (Imper Pl P2) => prote_ + "gei" ;
    VPB (Imper Pl P3) => prote_ + "jam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper erguer_Besch : Str -> Verbum = \erguer ->
-- 27 | r32
  let erg_ = Predef.tk 3 erguer in
 {s = table {
    VI Infn => erg_ + "uer" ;
    VI Ger => erg_ + "uendo" ;
    VI Part => erg_ + "uido" ;
    VPB (Pres Ind Sg P1) => erg_ + "o" ;
    VPB (Pres Ind Sg P2) => erg_ + "ues" ;
    VPB (Pres Ind Sg P3) => erg_ + "ue" ;
    VPB (Pres Ind Pl P1) => erg_ + "uemos" ;
    VPB (Pres Ind Pl P2) => erg_ + "ueis" ;
    VPB (Pres Ind Pl P3) => erg_ + "uem" ;
    VPB (Pres Sub Sg P1) => erg_ + "a" ;
    VPB (Pres Sub Sg P2) => erg_ + "as" ;
    VPB (Pres Sub Sg P3) => erg_ + "a" ;
    VPB (Pres Sub Pl P1) => erg_ + "amos" ;
    VPB (Pres Sub Pl P2) => erg_ + "ais" ;
    VPB (Pres Sub Pl P3) => erg_ + "am" ;
    VPB (PretI Ind Sg P1) => erg_ + "uia" ; --# notpresent
    VPB (PretI Ind Sg P2) => erg_ + "uias" ; --# notpresent
    VPB (PretI Ind Sg P3) => erg_ + "uia" ; --# notpresent
    VPB (PretI Ind Pl P1) => erg_ + "uíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => erg_ + "uíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => erg_ + "uiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => erg_ + "uesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => erg_ + "uesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => erg_ + "uesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => erg_ + "uêssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => erg_ + "uêsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => erg_ + "uessem" ; --# notpresent
    VPB (MQPerf Sg P1) => erg_ + "uera" ; --# notpresent
    VPB (MQPerf Sg P2) => erg_ + "ueras" ; --# notpresent
    VPB (MQPerf Sg P3) => erg_ + "uera" ; --# notpresent
    VPB (MQPerf Pl P1) => erg_ + "uêramos" ; --# notpresent
    VPB (MQPerf Pl P2) => erg_ + "uêreis" ; --# notpresent
    VPB (MQPerf Pl P3) => erg_ + "ueram" ; --# notpresent
    VPB (PretP Sg P1) => erg_ + "ui" ; --# notpresent
    VPB (PretP Sg P2) => erg_ + "ueste" ; --# notpresent
    VPB (PretP Sg P3) => erg_ + "ueu" ; --# notpresent
    VPB (PretP Pl P1) => erg_ + "uemos" ; --# notpresent
    VPB (PretP Pl P2) => erg_ + "uestes" ; --# notpresent
    VPB (PretP Pl P3) => erg_ + "ueram" ; --# notpresent
    VPB (Fut Ind Sg P1) => erg_ + "uerei" ; --# notpresent
    VPB (Fut Ind Sg P2) => erg_ + "uerás" ; --# notpresent
    VPB (Fut Ind Sg P3) => erg_ + "uerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => erg_ + "ueremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => erg_ + "uereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => erg_ + "uerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => erg_ + "uer" ; --# notpresent
    VPB (Fut Sub Sg P2) => erg_ + "ueres" ; --# notpresent
    VPB (Fut Sub Sg P3) => erg_ + "uer" ; --# notpresent
    VPB (Fut Sub Pl P1) => erg_ + "uermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => erg_ + "uerdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => erg_ + "uerem" ; --# notpresent
    VPB (Cond Sg P1) => erg_ + "ueria" ; --# notpresent
    VPB (Cond Sg P2) => erg_ + "uerias" ; --# notpresent
    VPB (Cond Sg P3) => erg_ + "ueria" ; --# notpresent
    VPB (Cond Pl P1) => erg_ + "ueríamos" ; --# notpresent
    VPB (Cond Pl P2) => erg_ + "ueríeis" ; --# notpresent
    VPB (Cond Pl P3) => erg_ + "ueriam" ; --# notpresent
    VPB (Imper Sg P2) => erg_ + "ue" ;
    VPB (Imper Sg P3) => erg_ + "a" ;
    VPB (Imper Pl P1) => erg_ + "amos" ;
    VPB (Imper Pl P2) => erg_ + "uei" ;
    VPB (Imper Pl P3) => erg_ + "am" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper moer_Besch : Str -> Verbum = \moer ->
-- 28 | r39
  let m_ = Predef.tk 3 moer in
 {s = table {
    VI Infn => m_ + "oer" ;
    VI Ger => m_ + "oendo" ;
    VI Part => m_ + "oído" ;
    VPB (Pres Ind Sg P1) => m_ + "oo" ;
    VPB (Pres Ind Sg P2) => m_ + "óis" ;
    VPB (Pres Ind Sg P3) => m_ + "ói" ;
    VPB (Pres Ind Pl P1) => m_ + "oemos" ;
    VPB (Pres Ind Pl P2) => m_ + "oeis" ;
    VPB (Pres Ind Pl P3) => m_ + "oem" ;
    VPB (Pres Sub Sg P1) => m_ + "oa" ;
    VPB (Pres Sub Sg P2) => m_ + "oas" ;
    VPB (Pres Sub Sg P3) => m_ + "oa" ;
    VPB (Pres Sub Pl P1) => m_ + "oamos" ;
    VPB (Pres Sub Pl P2) => m_ + "oais" ;
    VPB (Pres Sub Pl P3) => m_ + "oam" ;
    VPB (PretI Ind Sg P1) => m_ + "oía" ; --# notpresent
    VPB (PretI Ind Sg P2) => m_ + "oías" ; --# notpresent
    VPB (PretI Ind Sg P3) => m_ + "oía" ; --# notpresent
    VPB (PretI Ind Pl P1) => m_ + "oíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => m_ + "oíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => m_ + "oíam" ; --# notpresent
    VPB (PretI Sub Sg P1) => m_ + "oesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => m_ + "oesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => m_ + "oesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => m_ + "oêssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => m_ + "oêsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => m_ + "oessem" ; --# notpresent
    VPB (MQPerf Sg P1) => m_ + "oera" ; --# notpresent
    VPB (MQPerf Sg P2) => m_ + "oeras" ; --# notpresent
    VPB (MQPerf Sg P3) => m_ + "oera" ; --# notpresent
    VPB (MQPerf Pl P1) => m_ + "oêramos" ; --# notpresent
    VPB (MQPerf Pl P2) => m_ + "oêreis" ; --# notpresent
    VPB (MQPerf Pl P3) => m_ + "oeram" ; --# notpresent
    VPB (PretP Sg P1) => m_ + "oí" ; --# notpresent
    VPB (PretP Sg P2) => m_ + "oeste" ; --# notpresent
    VPB (PretP Sg P3) => m_ + "oeu" ; --# notpresent
    VPB (PretP Pl P1) => m_ + "oemos" ; --# notpresent
    VPB (PretP Pl P2) => m_ + "oestes" ; --# notpresent
    VPB (PretP Pl P3) => m_ + "oeram" ; --# notpresent
    VPB (Fut Ind Sg P1) => m_ + "oerei" ; --# notpresent
    VPB (Fut Ind Sg P2) => m_ + "oerás" ; --# notpresent
    VPB (Fut Ind Sg P3) => m_ + "oerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => m_ + "oeremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => m_ + "oereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => m_ + "oerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => m_ + "oer" ; --# notpresent
    VPB (Fut Sub Sg P2) => m_ + "oeres" ; --# notpresent
    VPB (Fut Sub Sg P3) => m_ + "oer" ; --# notpresent
    VPB (Fut Sub Pl P1) => m_ + "oermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => m_ + "oerdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => m_ + "oerem" ; --# notpresent
    VPB (Cond Sg P1) => m_ + "oeria" ; --# notpresent
    VPB (Cond Sg P2) => m_ + "oerias" ; --# notpresent
    VPB (Cond Sg P3) => m_ + "oeria" ; --# notpresent
    VPB (Cond Pl P1) => m_ + "oeríamos" ; --# notpresent
    VPB (Cond Pl P2) => m_ + "oeríeis" ; --# notpresent
    VPB (Cond Pl P3) => m_ + "oeriam" ; --# notpresent
    VPB (Imper Sg P2) => m_ + "ói" ;
    VPB (Imper Sg P3) => m_ + "oa" ;
    VPB (Imper Pl P1) => m_ + "oamos" ;
    VPB (Imper Pl P2) => m_ + "oei" ;
    VPB (Imper Pl P3) => m_ + "oam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper dizer_Besch : Str -> Verbum = \dizer ->
-- 29 | r60
  let di_ = Predef.tk 3 dizer in
 {s = table {
    VI Infn => di_ + "zer" ;
    VI Ger => di_ + "zendo" ;
    VI Part => di_ + "to" ;
    VPB (Pres Ind Sg P1) => di_ + "go" ;
    VPB (Pres Ind Sg P2) => di_ + "zes" ;
    VPB (Pres Ind Sg P3) => di_ + "z" ;
    VPB (Pres Ind Pl P1) => di_ + "zemos" ;
    VPB (Pres Ind Pl P2) => di_ + "zeis" ;
    VPB (Pres Ind Pl P3) => di_ + "zem" ;
    VPB (Pres Sub Sg P1) => di_ + "ga" ;
    VPB (Pres Sub Sg P2) => di_ + "gas" ;
    VPB (Pres Sub Sg P3) => di_ + "ga" ;
    VPB (Pres Sub Pl P1) => di_ + "gamos" ;
    VPB (Pres Sub Pl P2) => di_ + "gais" ;
    VPB (Pres Sub Pl P3) => di_ + "gam" ;
    VPB (PretI Ind Sg P1) => di_ + "zia" ; --# notpresent
    VPB (PretI Ind Sg P2) => di_ + "zias" ; --# notpresent
    VPB (PretI Ind Sg P3) => di_ + "zia" ; --# notpresent
    VPB (PretI Ind Pl P1) => di_ + "zíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => di_ + "zíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => di_ + "ziam" ; --# notpresent
    VPB (PretI Sub Sg P1) => di_ + "ssesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => di_ + "ssesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => di_ + "ssesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => di_ + "sséssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => di_ + "ssésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => di_ + "ssessem" ; --# notpresent
    VPB (MQPerf Sg P1) => di_ + "ssera" ; --# notpresent
    VPB (MQPerf Sg P2) => di_ + "sseras" ; --# notpresent
    VPB (MQPerf Sg P3) => di_ + "ssera" ; --# notpresent
    VPB (MQPerf Pl P1) => di_ + "sséramos" ; --# notpresent
    VPB (MQPerf Pl P2) => di_ + "sséreis" ; --# notpresent
    VPB (MQPerf Pl P3) => di_ + "sseram" ; --# notpresent
    VPB (PretP Sg P1) => di_ + "sse" ; --# notpresent
    VPB (PretP Sg P2) => di_ + "sseste" ; --# notpresent
    VPB (PretP Sg P3) => di_ + "sse" ; --# notpresent
    VPB (PretP Pl P1) => di_ + "ssemos" ; --# notpresent
    VPB (PretP Pl P2) => di_ + "ssestes" ; --# notpresent
    VPB (PretP Pl P3) => di_ + "sseram" ; --# notpresent
    VPB (Fut Ind Sg P1) => di_ + "rei" ; --# notpresent
    VPB (Fut Ind Sg P2) => di_ + "rás" ; --# notpresent
    VPB (Fut Ind Sg P3) => di_ + "rá" ; --# notpresent
    VPB (Fut Ind Pl P1) => di_ + "remos" ; --# notpresent
    VPB (Fut Ind Pl P2) => di_ + "reis" ; --# notpresent
    VPB (Fut Ind Pl P3) => di_ + "rão" ; --# notpresent
    VPB (Fut Sub Sg P1) => di_ + "sser" ; --# notpresent
    VPB (Fut Sub Sg P2) => di_ + "sseres" ; --# notpresent
    VPB (Fut Sub Sg P3) => di_ + "sser" ; --# notpresent
    VPB (Fut Sub Pl P1) => di_ + "ssermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => di_ + "sserdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => di_ + "sserem" ; --# notpresent
    VPB (Cond Sg P1) => di_ + "ria" ; --# notpresent
    VPB (Cond Sg P2) => di_ + "rias" ; --# notpresent
    VPB (Cond Sg P3) => di_ + "ria" ; --# notpresent
    VPB (Cond Pl P1) => di_ + "ríamos" ; --# notpresent
    VPB (Cond Pl P2) => di_ + "ríeis" ; --# notpresent
    VPB (Cond Pl P3) => di_ + "riam" ; --# notpresent
    VPB (Imper Sg P2) => di_ + vars "z" "ze" ;
    VPB (Imper Sg P3) => di_ + "ga" ;
    VPB (Imper Pl P1) => di_ + "gamos" ;
    VPB (Imper Pl P2) => di_ + "zei" ;
    VPB (Imper Pl P3) => di_ + "gam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper trazer_Besch : Str -> Verbum = \trazer ->
-- 30 | r73
  let tr_ = Predef.tk 4 trazer in
 {s = table {
    VI Infn => tr_ + "azer" ;
    VI Ger => tr_ + "azendo" ;
    VI Part => tr_ + "azido" ;
    VPB (Pres Ind Sg P1) => tr_ + "ago" ;
    VPB (Pres Ind Sg P2) => tr_ + "azes" ;
    VPB (Pres Ind Sg P3) => tr_ + "az" ;
    VPB (Pres Ind Pl P1) => tr_ + "azemos" ;
    VPB (Pres Ind Pl P2) => tr_ + "azeis" ;
    VPB (Pres Ind Pl P3) => tr_ + "azem" ;
    VPB (Pres Sub Sg P1) => tr_ + "aga" ;
    VPB (Pres Sub Sg P2) => tr_ + "agas" ;
    VPB (Pres Sub Sg P3) => tr_ + "aga" ;
    VPB (Pres Sub Pl P1) => tr_ + "agamos" ;
    VPB (Pres Sub Pl P2) => tr_ + "agais" ;
    VPB (Pres Sub Pl P3) => tr_ + "agam" ;
    VPB (PretI Ind Sg P1) => tr_ + "azia" ; --# notpresent
    VPB (PretI Ind Sg P2) => tr_ + "azias" ; --# notpresent
    VPB (PretI Ind Sg P3) => tr_ + "azia" ; --# notpresent
    VPB (PretI Ind Pl P1) => tr_ + "azíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => tr_ + "azíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => tr_ + "aziam" ; --# notpresent
    VPB (PretI Sub Sg P1) => tr_ + "ouxesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => tr_ + "ouxesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => tr_ + "ouxesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => tr_ + "ouxéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => tr_ + "ouxésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => tr_ + "ouxessem" ; --# notpresent
    VPB (MQPerf Sg P1) => tr_ + "ouxera" ; --# notpresent
    VPB (MQPerf Sg P2) => tr_ + "ouxeras" ; --# notpresent
    VPB (MQPerf Sg P3) => tr_ + "ouxera" ; --# notpresent
    VPB (MQPerf Pl P1) => tr_ + "ouxéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => tr_ + "ouxéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => tr_ + "ouxeram" ; --# notpresent
    VPB (PretP Sg P1) => tr_ + "ouxe" ; --# notpresent
    VPB (PretP Sg P2) => tr_ + "ouxeste" ; --# notpresent
    VPB (PretP Sg P3) => tr_ + "ouxe" ; --# notpresent
    VPB (PretP Pl P1) => tr_ + "ouxemos" ; --# notpresent
    VPB (PretP Pl P2) => tr_ + "ouxestes" ; --# notpresent
    VPB (PretP Pl P3) => tr_ + "ouxeram" ; --# notpresent
    VPB (Fut Ind Sg P1) => tr_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => tr_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => tr_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => tr_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => tr_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => tr_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => tr_ + "ouxer" ; --# notpresent
    VPB (Fut Sub Sg P2) => tr_ + "ouxeres" ; --# notpresent
    VPB (Fut Sub Sg P3) => tr_ + "ouxer" ; --# notpresent
    VPB (Fut Sub Pl P1) => tr_ + "ouxermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => tr_ + "ouxerdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => tr_ + "ouxerem" ; --# notpresent
    VPB (Cond Sg P1) => tr_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => tr_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => tr_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => tr_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => tr_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => tr_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => tr_ + vars "az" "aze" ;
    VPB (Imper Sg P3) => tr_ + "aga" ;
    VPB (Imper Pl P1) => tr_ + "agamos" ;
    VPB (Imper Pl P2) => tr_ + "azei" ;
    VPB (Imper Pl P3) => tr_ + "agam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper fazer_Besch : Str -> Verbum = \fazer ->
-- 31 | r61
  let f_ = Predef.tk 4 fazer in
 {s = table {
    VI Infn => f_ + "azer" ;
    VI Ger => f_ + "azendo" ;
    VI Part => f_ + "eito" ;
    VPB (Pres Ind Sg P1) => f_ + "aço" ;
    VPB (Pres Ind Sg P2) => f_ + "azes" ;
    VPB (Pres Ind Sg P3) => f_ + "az" ;
    VPB (Pres Ind Pl P1) => f_ + "azemos" ;
    VPB (Pres Ind Pl P2) => f_ + "azeis" ;
    VPB (Pres Ind Pl P3) => f_ + "azem" ;
    VPB (Pres Sub Sg P1) => f_ + "aça" ;
    VPB (Pres Sub Sg P2) => f_ + "aças" ;
    VPB (Pres Sub Sg P3) => f_ + "aça" ;
    VPB (Pres Sub Pl P1) => f_ + "açamos" ;
    VPB (Pres Sub Pl P2) => f_ + "açais" ;
    VPB (Pres Sub Pl P3) => f_ + "açam" ;
    VPB (PretI Ind Sg P1) => f_ + "azia" ; --# notpresent
    VPB (PretI Ind Sg P2) => f_ + "azias" ; --# notpresent
    VPB (PretI Ind Sg P3) => f_ + "azia" ; --# notpresent
    VPB (PretI Ind Pl P1) => f_ + "azíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => f_ + "azíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => f_ + "aziam" ; --# notpresent
    VPB (PretI Sub Sg P1) => f_ + "izesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => f_ + "izesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => f_ + "izesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => f_ + "izéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => f_ + "izésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => f_ + "izessem" ; --# notpresent
    VPB (MQPerf Sg P1) => f_ + "izera" ; --# notpresent
    VPB (MQPerf Sg P2) => f_ + "izeras" ; --# notpresent
    VPB (MQPerf Sg P3) => f_ + "izera" ; --# notpresent
    VPB (MQPerf Pl P1) => f_ + "izéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => f_ + "izéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => f_ + "izeram" ; --# notpresent
    VPB (PretP Sg P1) => f_ + "iz" ; --# notpresent
    VPB (PretP Sg P2) => f_ + "izeste" ; --# notpresent
    VPB (PretP Sg P3) => f_ + "ez" ; --# notpresent
    VPB (PretP Pl P1) => f_ + "izemos" ; --# notpresent
    VPB (PretP Pl P2) => f_ + "izestes" ; --# notpresent
    VPB (PretP Pl P3) => f_ + "izeram" ; --# notpresent
    VPB (Fut Ind Sg P1) => f_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => f_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => f_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => f_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => f_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => f_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => f_ + "izer" ; --# notpresent
    VPB (Fut Sub Sg P2) => f_ + "izeres" ; --# notpresent
    VPB (Fut Sub Sg P3) => f_ + "izer" ; --# notpresent
    VPB (Fut Sub Pl P1) => f_ + "izermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => f_ + "izerdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => f_ + "izerem" ; --# notpresent
    VPB (Cond Sg P1) => f_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => f_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => f_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => f_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => f_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => f_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => f_ + vars "az" "aze" ;
    VPB (Imper Sg P3) => f_ + "aça" ;
    VPB (Imper Pl P1) => f_ + "açamos" ;
    VPB (Imper Pl P2) => f_ + "azei" ;
    VPB (Imper Pl P3) => f_ + "açam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper aprazer_Besch : Str -> Verbum = \aprazer ->
-- 32 | r55
  let apr_ = Predef.tk 4 aprazer in
 {s = table {
    VI Infn => apr_ + "azer" ;
    VI Ger => apr_ + "azendo" ;
    VI Part => apr_ + "azido" ;
    VPB (Pres Ind Sg P1) => apr_ + "azo" ;
    VPB (Pres Ind Sg P2) => apr_ + "azes" ;
    VPB (Pres Ind Sg P3) => apr_ + "az" ;
    VPB (Pres Ind Pl P1) => apr_ + "azemos" ;
    VPB (Pres Ind Pl P2) => apr_ + "azeis" ;
    VPB (Pres Ind Pl P3) => apr_ + "azem" ;
    VPB (Pres Sub Sg P1) => apr_ + "aza" ;
    VPB (Pres Sub Sg P2) => apr_ + "azas" ;
    VPB (Pres Sub Sg P3) => apr_ + "aza" ;
    VPB (Pres Sub Pl P1) => apr_ + "azarmos" ;
    VPB (Pres Sub Pl P2) => apr_ + "azais" ;
    VPB (Pres Sub Pl P3) => apr_ + "azam" ;
    VPB (PretI Ind Sg P1) => apr_ + "azia" ; --# notpresent
    VPB (PretI Ind Sg P2) => apr_ + "azias" ; --# notpresent
    VPB (PretI Ind Sg P3) => apr_ + "azia" ; --# notpresent
    VPB (PretI Ind Pl P1) => apr_ + "azíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => apr_ + "azíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => apr_ + "aziam" ; --# notpresent
    VPB (PretI Sub Sg P1) => apr_ + "ouvesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => apr_ + "ouvesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => apr_ + "ouvesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => apr_ + "ouvéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => apr_ + "ouvésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => apr_ + "ouvessem" ; --# notpresent
    VPB (MQPerf Sg P1) => apr_ + "ouvera" ; --# notpresent
    VPB (MQPerf Sg P2) => apr_ + "ouveras" ; --# notpresent
    VPB (MQPerf Sg P3) => apr_ + "ouvera" ; --# notpresent
    VPB (MQPerf Pl P1) => apr_ + "ouvéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => apr_ + "ouvéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => apr_ + "ouveram" ; --# notpresent
    VPB (PretP Sg P1) => apr_ + "ouve" ; --# notpresent
    VPB (PretP Sg P2) => apr_ + "ouveste" ; --# notpresent
    VPB (PretP Sg P3) => apr_ + "ouve" ; --# notpresent
    VPB (PretP Pl P1) => apr_ + "ouvemos" ; --# notpresent
    VPB (PretP Pl P2) => apr_ + "ouvéreis" ; --# notpresent
    VPB (PretP Pl P3) => apr_ + "ouveram" ; --# notpresent
    VPB (Fut Ind Sg P1) => apr_ + "azerei" ; --# notpresent
    VPB (Fut Ind Sg P2) => apr_ + "azerás" ; --# notpresent
    VPB (Fut Ind Sg P3) => apr_ + "azerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => apr_ + "azeremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => apr_ + "azereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => apr_ + "azerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => apr_ + "ouver" ; --# notpresent
    VPB (Fut Sub Sg P2) => apr_ + "ouveres" ; --# notpresent
    VPB (Fut Sub Sg P3) => apr_ + "ouver" ; --# notpresent
    VPB (Fut Sub Pl P1) => apr_ + "ouvermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => apr_ + "ouverdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => apr_ + "ouverem" ; --# notpresent
    VPB (Cond Sg P1) => apr_ + "azeria" ; --# notpresent
    VPB (Cond Sg P2) => apr_ + "ezerias" ; --# notpresent
    VPB (Cond Sg P3) => apr_ + "azeria" ; --# notpresent
    VPB (Cond Pl P1) => apr_ + "azeríamos" ; --# notpresent
    VPB (Cond Pl P2) => apr_ + "azeríeis" ; --# notpresent
    VPB (Cond Pl P3) => apr_ + "azeriam" ; --# notpresent
    VPB (Imper Sg P2) => apr_ + vars "az" "aze" ;
    VPB (Imper Sg P3) => apr_ + "aza" ;
    VPB (Imper Pl P1) => apr_ + "azamos" ;
    VPB (Imper Pl P2) => apr_ + "azei" ;
    VPB (Imper Pl P3) => apr_ + "azam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper jazer_Besch : Str -> Verbum = \jazer ->
-- 33 | r43
  let jaz_ = Predef.tk 2 jazer in
 {s = table {
    VI Infn => jaz_ + "er" ;
    VI Ger => jaz_ + "endo" ;
    VI Part => jaz_ + "ido" ;
    VPB (Pres Ind Sg P1) => jaz_ + "o" ;
    VPB (Pres Ind Sg P2) => jaz_ + "es" ;
    VPB (Pres Ind Sg P3) => jaz_ + "" ;
    VPB (Pres Ind Pl P1) => jaz_ + "emos" ;
    VPB (Pres Ind Pl P2) => jaz_ + "eis" ;
    VPB (Pres Ind Pl P3) => jaz_ + "em" ;
    VPB (Pres Sub Sg P1) => jaz_ + "a" ;
    VPB (Pres Sub Sg P2) => jaz_ + "as" ;
    VPB (Pres Sub Sg P3) => jaz_ + "a" ;
    VPB (Pres Sub Pl P1) => jaz_ + "amos" ;
    VPB (Pres Sub Pl P2) => jaz_ + "ais" ;
    VPB (Pres Sub Pl P3) => jaz_ + "am" ;
    VPB (PretI Ind Sg P1) => jaz_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => jaz_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => jaz_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => jaz_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => jaz_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => jaz_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => jaz_ + "esse" ; --# notpresent
    VPB (PretI Sub Sg P2) => jaz_ + "esses" ; --# notpresent
    VPB (PretI Sub Sg P3) => jaz_ + "esses" ; --# notpresent
    VPB (PretI Sub Pl P1) => jaz_ + "êssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => jaz_ + "êsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => jaz_ + "essem" ; --# notpresent
    VPB (MQPerf Sg P1) => jaz_ + "era" ; --# notpresent
    VPB (MQPerf Sg P2) => jaz_ + "eras" ; --# notpresent
    VPB (MQPerf Sg P3) => jaz_ + "era" ; --# notpresent
    VPB (MQPerf Pl P1) => jaz_ + "êramos" ; --# notpresent
    VPB (MQPerf Pl P2) => jaz_ + "êreis" ; --# notpresent
    VPB (MQPerf Pl P3) => jaz_ + "eram" ; --# notpresent
    VPB (PretP Sg P1) => jaz_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => jaz_ + "este" ; --# notpresent
    VPB (PretP Sg P3) => jaz_ + "eu" ; --# notpresent
    VPB (PretP Pl P1) => jaz_ + "emos" ; --# notpresent
    VPB (PretP Pl P2) => jaz_ + "estes" ; --# notpresent
    VPB (PretP Pl P3) => jaz_ + "eram" ; --# notpresent
    VPB (Fut Ind Sg P1) => jaz_ + "erei" ; --# notpresent
    VPB (Fut Ind Sg P2) => jaz_ + "erás" ; --# notpresent
    VPB (Fut Ind Sg P3) => jaz_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => jaz_ + "eremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => jaz_ + "ereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => jaz_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => jaz_ + "er" ; --# notpresent
    VPB (Fut Sub Sg P2) => jaz_ + "eres" ; --# notpresent
    VPB (Fut Sub Sg P3) => jaz_ + "er" ; --# notpresent
    VPB (Fut Sub Pl P1) => jaz_ + "ermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => jaz_ + "erdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => jaz_ + "erem" ; --# notpresent
    VPB (Cond Sg P1) => jaz_ + "eria" ; --# notpresent
    VPB (Cond Sg P2) => jaz_ + "erias" ; --# notpresent
    VPB (Cond Sg P3) => jaz_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => jaz_ + "eríamos" ; --# notpresent
    VPB (Cond Pl P2) => jaz_ + "eríeis" ; --# notpresent
    VPB (Cond Pl P3) => jaz_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => jaz_ + vars "" "e" ;
    VPB (Imper Sg P3) => jaz_ + "a" ;
    VPB (Imper Pl P1) => jaz_ + "amos" ;
    VPB (Imper Pl P2) => jaz_ + "ei" ;
    VPB (Imper Pl P3) => jaz_ + "am" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper caber_Besch : Str -> Verbum = \caber ->
-- 34 | r56
  let c_ = Predef.tk 4 caber in
 {s = table {
    VI Infn => c_ + "aber" ;
    VI Ger => c_ + "abendo" ;
    VI Part => c_ + "abido" ;
    VPB (Pres Ind Sg P1) => c_ + "aibo" ;
    VPB (Pres Ind Sg P2) => c_ + "abes" ;
    VPB (Pres Ind Sg P3) => c_ + "abe" ;
    VPB (Pres Ind Pl P1) => c_ + "abemos" ;
    VPB (Pres Ind Pl P2) => c_ + "abeis" ;
    VPB (Pres Ind Pl P3) => c_ + "abem" ;
    VPB (Pres Sub Sg P1) => c_ + "aiba" ;
    VPB (Pres Sub Sg P2) => c_ + "aibas" ;
    VPB (Pres Sub Sg P3) => c_ + "aiba" ;
    VPB (Pres Sub Pl P1) => c_ + "aibamos" ;
    VPB (Pres Sub Pl P2) => c_ + "aibais" ;
    VPB (Pres Sub Pl P3) => c_ + "aibam" ;
    VPB (PretI Ind Sg P1) => c_ + "abia" ; --# notpresent
    VPB (PretI Ind Sg P2) => c_ + "abias" ; --# notpresent
    VPB (PretI Ind Sg P3) => c_ + "abia" ; --# notpresent
    VPB (PretI Ind Pl P1) => c_ + "abíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => c_ + "abíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => c_ + "abiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => c_ + "oubesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => c_ + "oubesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => c_ + "oubesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => c_ + "oubéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => c_ + "oubésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => c_ + "oubessem" ; --# notpresent
    VPB (MQPerf Sg P1) => c_ + "oubera" ; --# notpresent
    VPB (MQPerf Sg P2) => c_ + "ouberas" ; --# notpresent
    VPB (MQPerf Sg P3) => c_ + "oubera" ; --# notpresent
    VPB (MQPerf Pl P1) => c_ + "oubéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => c_ + "oubéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => c_ + "ouberam" ; --# notpresent
    VPB (PretP Sg P1) => c_ + "oube" ; --# notpresent
    VPB (PretP Sg P2) => c_ + "oubeste" ; --# notpresent
    VPB (PretP Sg P3) => c_ + "oube" ; --# notpresent
    VPB (PretP Pl P1) => c_ + "oubemos" ; --# notpresent
    VPB (PretP Pl P2) => c_ + "oubestes" ; --# notpresent
    VPB (PretP Pl P3) => c_ + "ouberam" ; --# notpresent
    VPB (Fut Ind Sg P1) => c_ + "aberei" ; --# notpresent
    VPB (Fut Ind Sg P2) => c_ + "aberás" ; --# notpresent
    VPB (Fut Ind Sg P3) => c_ + "aberá" ; --# notpresent
    VPB (Fut Ind Pl P1) => c_ + "aberemos" ; --# notpresent
    VPB (Fut Ind Pl P2) => c_ + "abereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => c_ + "aberão" ; --# notpresent
    VPB (Fut Sub Sg P1) => c_ + "ouber" ; --# notpresent
    VPB (Fut Sub Sg P2) => c_ + "ouberes" ; --# notpresent
    VPB (Fut Sub Sg P3) => c_ + "ouber" ; --# notpresent
    VPB (Fut Sub Pl P1) => c_ + "oubermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => c_ + "ouberdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => c_ + "ouberem" ; --# notpresent
    VPB (Cond Sg P1) => c_ + "aberia" ; --# notpresent
    VPB (Cond Sg P2) => c_ + "aberias" ; --# notpresent
    VPB (Cond Sg P3) => c_ + "aberia" ; --# notpresent
    VPB (Cond Pl P1) => c_ + "aberíamos" ; --# notpresent
    VPB (Cond Pl P2) => c_ + "aberíeis" ; --# notpresent
    VPB (Cond Pl P3) => c_ + "aberiam" ; --# notpresent
    VPB (Imper Sg P2) => c_ + nonExist ;
    VPB (Imper Sg P3) => c_ + nonExist ;
    VPB (Imper Pl P1) => c_ + nonExist ;
    VPB (Imper Pl P2) => c_ + nonExist ;
    VPB (Imper Pl P3) => c_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper saber_Besch : Str -> Verbum = \saber ->
-- 35 | r72
  let s_ = Predef.tk 4 saber in
 {s = table {
    VI Infn => s_ + "aber" ;
    VI Ger => s_ + "abendo" ;
    VI Part => s_ + "abido" ;
    VPB (Pres Ind Sg P1) => s_ + "ei" ;
    VPB (Pres Ind Sg P2) => s_ + "abes" ;
    VPB (Pres Ind Sg P3) => s_ + "abe" ;
    VPB (Pres Ind Pl P1) => s_ + "abemos" ;
    VPB (Pres Ind Pl P2) => s_ + "abeis" ;
    VPB (Pres Ind Pl P3) => s_ + "abem" ;
    VPB (Pres Sub Sg P1) => s_ + "aiba" ;
    VPB (Pres Sub Sg P2) => s_ + "aibas" ;
    VPB (Pres Sub Sg P3) => s_ + "aiba" ;
    VPB (Pres Sub Pl P1) => s_ + "aibamos" ;
    VPB (Pres Sub Pl P2) => s_ + "aibais" ;
    VPB (Pres Sub Pl P3) => s_ + "aibam" ;
    VPB (PretI Ind Sg P1) => s_ + "abia" ; --# notpresent
    VPB (PretI Ind Sg P2) => s_ + "abias" ; --# notpresent
    VPB (PretI Ind Sg P3) => s_ + "abia" ; --# notpresent
    VPB (PretI Ind Pl P1) => s_ + "abíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => s_ + "abíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => s_ + "abiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => s_ + "oubesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => s_ + "oubesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => s_ + "oubesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => s_ + "oubéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => s_ + "oubésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => s_ + "oubessem" ; --# notpresent
    VPB (MQPerf Sg P1) => s_ + "oubera" ; --# notpresent
    VPB (MQPerf Sg P2) => s_ + "ouberas" ; --# notpresent
    VPB (MQPerf Sg P3) => s_ + "oubera" ; --# notpresent
    VPB (MQPerf Pl P1) => s_ + "oubéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => s_ + "oubéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => s_ + "ouberam" ; --# notpresent
    VPB (PretP Sg P1) => s_ + "oube" ; --# notpresent
    VPB (PretP Sg P2) => s_ + "oubeste" ; --# notpresent
    VPB (PretP Sg P3) => s_ + "oube" ; --# notpresent
    VPB (PretP Pl P1) => s_ + "oubemos" ; --# notpresent
    VPB (PretP Pl P2) => s_ + "oubestes" ; --# notpresent
    VPB (PretP Pl P3) => s_ + "ouberam" ; --# notpresent
    VPB (Fut Ind Sg P1) => s_ + "aberei" ; --# notpresent
    VPB (Fut Ind Sg P2) => s_ + "aberás" ; --# notpresent
    VPB (Fut Ind Sg P3) => s_ + "aberá" ; --# notpresent
    VPB (Fut Ind Pl P1) => s_ + "aberemos" ; --# notpresent
    VPB (Fut Ind Pl P2) => s_ + "abereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => s_ + "aberão" ; --# notpresent
    VPB (Fut Sub Sg P1) => s_ + "ouber" ; --# notpresent
    VPB (Fut Sub Sg P2) => s_ + "ouberes" ; --# notpresent
    VPB (Fut Sub Sg P3) => s_ + "ouber" ; --# notpresent
    VPB (Fut Sub Pl P1) => s_ + "oubermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => s_ + "ouberdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => s_ + "ouberem" ; --# notpresent
    VPB (Cond Sg P1) => s_ + "aberia" ; --# notpresent
    VPB (Cond Sg P2) => s_ + "aberias" ; --# notpresent
    VPB (Cond Sg P3) => s_ + "aberia" ; --# notpresent
    VPB (Cond Pl P1) => s_ + "aberiamos" ; --# notpresent
    VPB (Cond Pl P2) => s_ + "aberieis" ; --# notpresent
    VPB (Cond Pl P3) => s_ + "aberiam" ; --# notpresent
    VPB (Imper Sg P2) => s_ + "abe" ;
    VPB (Imper Sg P3) => s_ + "aiba" ;
    VPB (Imper Pl P1) => s_ + "aibamos" ;
    VPB (Imper Pl P2) => s_ + "abei" ;
    VPB (Imper Pl P3) => s_ + "aibam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper poder_Besch : Str -> Verbum = \poder ->
-- 36 | r66
  let p_ = Predef.tk 4 poder in
 {s = table {
    VI Infn => p_ + "oder" ;
    VI Ger => p_ + "odendo" ;
    VI Part => p_ + "odido" ;
    VPB (Pres Ind Sg P1) => p_ + "osso" ;
    VPB (Pres Ind Sg P2) => p_ + "odes" ;
    VPB (Pres Ind Sg P3) => p_ + "ode" ;
    VPB (Pres Ind Pl P1) => p_ + "odemos" ;
    VPB (Pres Ind Pl P2) => p_ + "odeis" ;
    VPB (Pres Ind Pl P3) => p_ + "odem" ;
    VPB (Pres Sub Sg P1) => p_ + "ossa" ;
    VPB (Pres Sub Sg P2) => p_ + "ossas" ;
    VPB (Pres Sub Sg P3) => p_ + "ossa" ;
    VPB (Pres Sub Pl P1) => p_ + "ossamos" ;
    VPB (Pres Sub Pl P2) => p_ + "ossais" ;
    VPB (Pres Sub Pl P3) => p_ + "ossam" ;
    VPB (PretI Ind Sg P1) => p_ + "odia" ; --# notpresent
    VPB (PretI Ind Sg P2) => p_ + "odias" ; --# notpresent
    VPB (PretI Ind Sg P3) => p_ + "odia" ; --# notpresent
    VPB (PretI Ind Pl P1) => p_ + "odiamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => p_ + "odieis" ; --# notpresent
    VPB (PretI Ind Pl P3) => p_ + "odiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => p_ + "udesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => p_ + "udesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => p_ + "udesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => p_ + "udéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => p_ + "udésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => p_ + "udessem" ; --# notpresent
    VPB (MQPerf Sg P1) => p_ + "udera" ; --# notpresent
    VPB (MQPerf Sg P2) => p_ + "uderas" ; --# notpresent
    VPB (MQPerf Sg P3) => p_ + "udera" ; --# notpresent
    VPB (MQPerf Pl P1) => p_ + "udéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => p_ + "udéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => p_ + "uderam" ; --# notpresent
    VPB (PretP Sg P1) => p_ + "ude" ; --# notpresent
    VPB (PretP Sg P2) => p_ + "udeste" ; --# notpresent
    VPB (PretP Sg P3) => p_ + "ôde" ; --# notpresent
    VPB (PretP Pl P1) => p_ + "udemos" ; --# notpresent
    VPB (PretP Pl P2) => p_ + "udestes" ; --# notpresent
    VPB (PretP Pl P3) => p_ + "uderam" ; --# notpresent
    VPB (Fut Ind Sg P1) => p_ + "oderei" ; --# notpresent
    VPB (Fut Ind Sg P2) => p_ + "oderás" ; --# notpresent
    VPB (Fut Ind Sg P3) => p_ + "oderá" ; --# notpresent
    VPB (Fut Ind Pl P1) => p_ + "oderemos" ; --# notpresent
    VPB (Fut Ind Pl P2) => p_ + "odereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => p_ + "oderão" ; --# notpresent
    VPB (Fut Sub Sg P1) => p_ + "uder" ; --# notpresent
    VPB (Fut Sub Sg P2) => p_ + "uderes" ; --# notpresent
    VPB (Fut Sub Sg P3) => p_ + "uder" ; --# notpresent
    VPB (Fut Sub Pl P1) => p_ + "udermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => p_ + "uderdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => p_ + "uderem" ; --# notpresent
    VPB (Cond Sg P1) => p_ + "oderia" ; --# notpresent
    VPB (Cond Sg P2) => p_ + "oderias" ; --# notpresent
    VPB (Cond Sg P3) => p_ + "oderia" ; --# notpresent
    VPB (Cond Pl P1) => p_ + "oderíamos" ; --# notpresent
    VPB (Cond Pl P2) => p_ + "oderíeis" ; --# notpresent
    VPB (Cond Pl P3) => p_ + "oderiam" ; --# notpresent
    VPB (Imper Sg P2) => p_ + nonExist ;
    VPB (Imper Sg P3) => p_ + nonExist ;
    VPB (Imper Pl P1) => p_ + nonExist ;
    VPB (Imper Pl P2) => p_ + nonExist ;
    VPB (Imper Pl P3) => p_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper crer_Besch : Str -> Verbum = \crer ->
-- 37 | r58
  let cr_ = Predef.tk 2 crer in
 {s = table {
    VI Infn => cr_ + "er" ;
    VI Ger => cr_ + "endo" ;
    VI Part => cr_ + "ido" ;
    VPB (Pres Ind Sg P1) => cr_ + "eio" ;
    VPB (Pres Ind Sg P2) => cr_ + "ês" ;
    VPB (Pres Ind Sg P3) => cr_ + "ê" ;
    VPB (Pres Ind Pl P1) => cr_ + "emos" ;
    VPB (Pres Ind Pl P2) => cr_ + "edes" ;
    VPB (Pres Ind Pl P3) => cr_ + vars "eem" "êem" ;
    VPB (Pres Sub Sg P1) => cr_ + "eia" ;
    VPB (Pres Sub Sg P2) => cr_ + "eais" ;
    VPB (Pres Sub Sg P3) => cr_ + "eia" ;
    VPB (Pres Sub Pl P1) => cr_ + "eiamos" ;
    VPB (Pres Sub Pl P2) => cr_ + "eiais" ;
    VPB (Pres Sub Pl P3) => cr_ + "eiam" ;
    VPB (PretI Ind Sg P1) => cr_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => cr_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => cr_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => cr_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => cr_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => cr_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => cr_ + "esse" ; --# notpresent
    VPB (PretI Sub Sg P2) => cr_ + "esses" ; --# notpresent
    VPB (PretI Sub Sg P3) => cr_ + "esse" ; --# notpresent
    VPB (PretI Sub Pl P1) => cr_ + "êssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => cr_ + "êsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => cr_ + "essem" ; --# notpresent
    VPB (MQPerf Sg P1) => cr_ + "era" ; --# notpresent
    VPB (MQPerf Sg P2) => cr_ + "eras" ; --# notpresent
    VPB (MQPerf Sg P3) => cr_ + "era" ; --# notpresent
    VPB (MQPerf Pl P1) => cr_ + "êramos" ; --# notpresent
    VPB (MQPerf Pl P2) => cr_ + "êreis" ; --# notpresent
    VPB (MQPerf Pl P3) => cr_ + "eram" ; --# notpresent
    VPB (PretP Sg P1) => cr_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => cr_ + "este" ; --# notpresent
    VPB (PretP Sg P3) => cr_ + "eu" ; --# notpresent
    VPB (PretP Pl P1) => cr_ + "emos" ; --# notpresent
    VPB (PretP Pl P2) => cr_ + "estes" ; --# notpresent
    VPB (PretP Pl P3) => cr_ + "eram" ; --# notpresent
    VPB (Fut Ind Sg P1) => cr_ + "erei" ; --# notpresent
    VPB (Fut Ind Sg P2) => cr_ + "erás" ; --# notpresent
    VPB (Fut Ind Sg P3) => cr_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => cr_ + "eremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => cr_ + "ereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => cr_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => cr_ + "er" ; --# notpresent
    VPB (Fut Sub Sg P2) => cr_ + "eres" ; --# notpresent
    VPB (Fut Sub Sg P3) => cr_ + "er" ; --# notpresent
    VPB (Fut Sub Pl P1) => cr_ + "ermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => cr_ + "erdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => cr_ + "erem" ; --# notpresent
    VPB (Cond Sg P1) => cr_ + "eria" ; --# notpresent
    VPB (Cond Sg P2) => cr_ + "erias" ; --# notpresent
    VPB (Cond Sg P3) => cr_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => cr_ + "eríamos" ; --# notpresent
    VPB (Cond Pl P2) => cr_ + "eríeis" ; --# notpresent
    VPB (Cond Pl P3) => cr_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => cr_ + "ê" ;
    VPB (Imper Sg P3) => cr_ + "eia" ;
    VPB (Imper Pl P1) => cr_ + "eiamos" ;
    VPB (Imper Pl P2) => cr_ + "ede" ;
    VPB (Imper Pl P3) => cr_ + "eiam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper querer_Besch : Str -> Verbum = \querer ->
-- 38 | r69
  let qu_ = Predef.tk 4 querer in
 {s = table {
    VI Infn => qu_ + "erer" ;
    VI Ger => qu_ + "erendo" ;
    VI Part => qu_ + "erido" ;
    VPB (Pres Ind Sg P1) => qu_ + "ero" ;
    VPB (Pres Ind Sg P2) => qu_ + "eres" ;
    VPB (Pres Ind Sg P3) => qu_ + "er" ;
    VPB (Pres Ind Pl P1) => qu_ + "eremos" ;
    VPB (Pres Ind Pl P2) => qu_ + "ereis" ;
    VPB (Pres Ind Pl P3) => qu_ + "erem" ;
    VPB (Pres Sub Sg P1) => qu_ + "eira" ;
    VPB (Pres Sub Sg P2) => qu_ + "eiras" ;
    VPB (Pres Sub Sg P3) => qu_ + "eira" ;
    VPB (Pres Sub Pl P1) => qu_ + "eiramos" ;
    VPB (Pres Sub Pl P2) => qu_ + "eirais" ;
    VPB (Pres Sub Pl P3) => qu_ + "eiram" ;
    VPB (PretI Ind Sg P1) => qu_ + "eria" ; --# notpresent
    VPB (PretI Ind Sg P2) => qu_ + "erias" ; --# notpresent
    VPB (PretI Ind Sg P3) => qu_ + "eria" ; --# notpresent
    VPB (PretI Ind Pl P1) => qu_ + "eríamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => qu_ + "eríeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => qu_ + "eriam" ; --# notpresent
    VPB (PretI Sub Sg P1) => qu_ + "isesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => qu_ + "isesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => qu_ + "isesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => qu_ + "iséssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => qu_ + "isésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => qu_ + "isessem" ; --# notpresent
    VPB (MQPerf Sg P1) => qu_ + "isera" ; --# notpresent
    VPB (MQPerf Sg P2) => qu_ + "iseras" ; --# notpresent
    VPB (MQPerf Sg P3) => qu_ + "isera" ; --# notpresent
    VPB (MQPerf Pl P1) => qu_ + "iséramos" ; --# notpresent
    VPB (MQPerf Pl P2) => qu_ + "iséreis" ; --# notpresent
    VPB (MQPerf Pl P3) => qu_ + "iseram" ; --# notpresent
    VPB (PretP Sg P1) => qu_ + "is" ; --# notpresent
    VPB (PretP Sg P2) => qu_ + "iseste" ; --# notpresent
    VPB (PretP Sg P3) => qu_ + "is" ; --# notpresent
    VPB (PretP Pl P1) => qu_ + "isemos" ; --# notpresent
    VPB (PretP Pl P2) => qu_ + "isestes" ; --# notpresent
    VPB (PretP Pl P3) => qu_ + "iseram" ; --# notpresent
    VPB (Fut Ind Sg P1) => qu_ + "ererei" ; --# notpresent
    VPB (Fut Ind Sg P2) => qu_ + "ererás" ; --# notpresent
    VPB (Fut Ind Sg P3) => qu_ + "ererá" ; --# notpresent
    VPB (Fut Ind Pl P1) => qu_ + "ereremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => qu_ + "erereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => qu_ + "ererão" ; --# notpresent
    VPB (Fut Sub Sg P1) => qu_ + "iser" ; --# notpresent
    VPB (Fut Sub Sg P2) => qu_ + "iseres" ; --# notpresent
    VPB (Fut Sub Sg P3) => qu_ + "iser" ; --# notpresent
    VPB (Fut Sub Pl P1) => qu_ + "isermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => qu_ + "iserdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => qu_ + "iserem" ; --# notpresent
    VPB (Cond Sg P1) => qu_ + "ereria" ; --# notpresent
    VPB (Cond Sg P2) => qu_ + "ererias" ; --# notpresent
    VPB (Cond Sg P3) => qu_ + "ereria" ; --# notpresent
    VPB (Cond Pl P1) => qu_ + "ereríamos" ; --# notpresent
    VPB (Cond Pl P2) => qu_ + "ereríeis" ; --# notpresent
    VPB (Cond Pl P3) => qu_ + "ereriam" ; --# notpresent
    VPB (Imper Sg P2) => qu_ + "er" ;
    VPB (Imper Sg P3) => qu_ + "eira" ;
    VPB (Imper Pl P1) => qu_ + "eiramos" ;
    VPB (Imper Pl P2) => qu_ + "erei" ;
    VPB (Imper Pl P3) => qu_ + "eiram" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper requerer_Besch : Str -> Verbum = \requerer ->
-- 39 | r70
  let reque_ = Predef.tk 3 requerer in
 {s = table {
    VI Infn => reque_ + "rer" ;
    VI Ger => reque_ + "rendo" ;
    VI Part => reque_ + "rido" ;
    VPB (Pres Ind Sg P1) => reque_ + "iro" ;
    VPB (Pres Ind Sg P2) => reque_ + "res" ;
    VPB (Pres Ind Sg P3) => reque_ + "r" ;
    VPB (Pres Ind Pl P1) => reque_ + "remos" ;
    VPB (Pres Ind Pl P2) => reque_ + "reis" ;
    VPB (Pres Ind Pl P3) => reque_ + "rem" ;
    VPB (Pres Sub Sg P1) => reque_ + "ira" ;
    VPB (Pres Sub Sg P2) => reque_ + "iras" ;
    VPB (Pres Sub Sg P3) => reque_ + "ira" ;
    VPB (Pres Sub Pl P1) => reque_ + "iramos" ;
    VPB (Pres Sub Pl P2) => reque_ + "irais" ;
    VPB (Pres Sub Pl P3) => reque_ + "iram" ;
    VPB (PretI Ind Sg P1) => reque_ + "ria" ; --# notpresent
    VPB (PretI Ind Sg P2) => reque_ + "rias" ; --# notpresent
    VPB (PretI Ind Sg P3) => reque_ + "ria" ; --# notpresent
    VPB (PretI Ind Pl P1) => reque_ + "ríamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => reque_ + "ríeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => reque_ + "riam" ; --# notpresent
    VPB (PretI Sub Sg P1) => reque_ + "resse" ; --# notpresent
    VPB (PretI Sub Sg P2) => reque_ + "resses" ; --# notpresent
    VPB (PretI Sub Sg P3) => reque_ + "resse" ; --# notpresent
    VPB (PretI Sub Pl P1) => reque_ + "rêssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => reque_ + "rêsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => reque_ + "ressem" ; --# notpresent
    VPB (MQPerf Sg P1) => reque_ + "rera" ; --# notpresent
    VPB (MQPerf Sg P2) => reque_ + "reras" ; --# notpresent
    VPB (MQPerf Sg P3) => reque_ + "rera" ; --# notpresent
    VPB (MQPerf Pl P1) => reque_ + "rêramos" ; --# notpresent
    VPB (MQPerf Pl P2) => reque_ + "rêreis" ; --# notpresent
    VPB (MQPerf Pl P3) => reque_ + "reram" ; --# notpresent
    VPB (PretP Sg P1) => reque_ + "ri" ; --# notpresent
    VPB (PretP Sg P2) => reque_ + "reste" ; --# notpresent
    VPB (PretP Sg P3) => reque_ + "reu" ; --# notpresent
    VPB (PretP Pl P1) => reque_ + "remos" ; --# notpresent
    VPB (PretP Pl P2) => reque_ + "restes" ; --# notpresent
    VPB (PretP Pl P3) => reque_ + "reram" ; --# notpresent
    VPB (Fut Ind Sg P1) => reque_ + "rerei" ; --# notpresent
    VPB (Fut Ind Sg P2) => reque_ + "rerás" ; --# notpresent
    VPB (Fut Ind Sg P3) => reque_ + "rerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => reque_ + "reremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => reque_ + "rereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => reque_ + "rerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => reque_ + "rer" ; --# notpresent
    VPB (Fut Sub Sg P2) => reque_ + "reres" ; --# notpresent
    VPB (Fut Sub Sg P3) => reque_ + "rer" ; --# notpresent
    VPB (Fut Sub Pl P1) => reque_ + "rermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => reque_ + "rerdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => reque_ + "rerem" ; --# notpresent
    VPB (Cond Sg P1) => reque_ + "reria" ; --# notpresent
    VPB (Cond Sg P2) => reque_ + "rerias" ; --# notpresent
    VPB (Cond Sg P3) => reque_ + "reria" ; --# notpresent
    VPB (Cond Pl P1) => reque_ + "reríamos" ; --# notpresent
    VPB (Cond Pl P2) => reque_ + "reríeis" ; --# notpresent
    VPB (Cond Pl P3) => reque_ + "reriam" ; --# notpresent
    VPB (Imper Sg P2) => reque_ + "r" ;
    VPB (Imper Sg P3) => reque_ + "ira" ;
    VPB (Imper Pl P1) => reque_ + "iramos" ;
    VPB (Imper Pl P2) => reque_ + "rei" ;
    VPB (Imper Pl P3) => reque_ + "iram" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper ver_Besch : Str -> Verbum = \ver ->
-- 40 | r25
  let v_ = Predef.tk 2 ver in
 {s = table {
    VI Infn => v_ + "er" ;
    VI Ger => v_ + "endo" ;
    VI Part => v_ + "isto" ;
    VPB (Pres Ind Sg P1) => v_ + "ejo" ;
    VPB (Pres Ind Sg P2) => v_ + "ês" ;
    VPB (Pres Ind Sg P3) => v_ + "ê" ;
    VPB (Pres Ind Pl P1) => v_ + "emos" ;
    VPB (Pres Ind Pl P2) => v_ + "edes" ;
    VPB (Pres Ind Pl P3) => v_ + vars "eem" "êem" ;
    VPB (Pres Sub Sg P1) => v_ + "eja" ;
    VPB (Pres Sub Sg P2) => v_ + "ejas" ;
    VPB (Pres Sub Sg P3) => v_ + "eja" ;
    VPB (Pres Sub Pl P1) => v_ + "ejamos" ;
    VPB (Pres Sub Pl P2) => v_ + "ejais" ;
    VPB (Pres Sub Pl P3) => v_ + "ejam" ;
    VPB (PretI Ind Sg P1) => v_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => v_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => v_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => v_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => v_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => v_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => v_ + "isse" ; --# notpresent
    VPB (PretI Sub Sg P2) => v_ + "isses" ; --# notpresent
    VPB (PretI Sub Sg P3) => v_ + "isse" ; --# notpresent
    VPB (PretI Sub Pl P1) => v_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => v_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => v_ + "issem" ; --# notpresent
    VPB (MQPerf Sg P1) => v_ + "ira" ; --# notpresent
    VPB (MQPerf Sg P2) => v_ + "iras" ; --# notpresent
    VPB (MQPerf Sg P3) => v_ + "ira" ; --# notpresent
    VPB (MQPerf Pl P1) => v_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => v_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => v_ + "iram" ; --# notpresent
    VPB (PretP Sg P1) => v_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => v_ + "iste" ; --# notpresent
    VPB (PretP Sg P3) => v_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => v_ + "imos" ; --# notpresent
    VPB (PretP Pl P2) => v_ + "istes" ; --# notpresent
    VPB (PretP Pl P3) => v_ + "iram" ; --# notpresent
    VPB (Fut Ind Sg P1) => v_ + "erei" ; --# notpresent
    VPB (Fut Ind Sg P2) => v_ + "erás" ; --# notpresent
    VPB (Fut Ind Sg P3) => v_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => v_ + "eremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => v_ + "ereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => v_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => v_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => v_ + "ires" ; --# notpresent
    VPB (Fut Sub Sg P3) => v_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => v_ + "irmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => v_ + "irdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => v_ + "irem" ; --# notpresent
    VPB (Cond Sg P1) => v_ + "eria" ; --# notpresent
    VPB (Cond Sg P2) => v_ + "erias" ; --# notpresent
    VPB (Cond Sg P3) => v_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => v_ + "eríamos" ; --# notpresent
    VPB (Cond Pl P2) => v_ + "eríeis" ; --# notpresent
    VPB (Cond Pl P3) => v_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => v_ + "ê" ;
    VPB (Imper Sg P3) => v_ + "eja" ;
    VPB (Imper Pl P1) => v_ + "ejamos" ;
    VPB (Imper Pl P2) => v_ + "ede" ;
    VPB (Imper Pl P3) => v_ + "ejam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper prover_Besch : Str -> Verbum = \prover ->
-- 41 | r68
  let prov_ = Predef.tk 2 prover in
 {s = table {
    VI Infn => prov_ + "er" ;
    VI Ger => prov_ + "endo" ;
    VI Part => prov_ + "ido" ;
    VPB (Pres Ind Sg P1) => prov_ + "ejo" ;
    VPB (Pres Ind Sg P2) => prov_ + "ês" ;
    VPB (Pres Ind Sg P3) => prov_ + "ê" ;
    VPB (Pres Ind Pl P1) => prov_ + "emos" ;
    VPB (Pres Ind Pl P2) => prov_ + "edes" ;
    VPB (Pres Ind Pl P3) => prov_ + vars "eem" "êem" ;
    VPB (Pres Sub Sg P1) => prov_ + "eja" ;
    VPB (Pres Sub Sg P2) => prov_ + "ejas" ;
    VPB (Pres Sub Sg P3) => prov_ + "eja" ;
    VPB (Pres Sub Pl P1) => prov_ + "ejamos" ;
    VPB (Pres Sub Pl P2) => prov_ + "ejais" ;
    VPB (Pres Sub Pl P3) => prov_ + "ejam" ;
    VPB (PretI Ind Sg P1) => prov_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => prov_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => prov_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => prov_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => prov_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => prov_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => prov_ + "esse" ; --# notpresent
    VPB (PretI Sub Sg P2) => prov_ + "esses" ; --# notpresent
    VPB (PretI Sub Sg P3) => prov_ + "esse" ; --# notpresent
    VPB (PretI Sub Pl P1) => prov_ + "êssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => prov_ + "êsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => prov_ + "essem" ; --# notpresent
    VPB (MQPerf Sg P1) => prov_ + "era" ; --# notpresent
    VPB (MQPerf Sg P2) => prov_ + "eras" ; --# notpresent
    VPB (MQPerf Sg P3) => prov_ + "era" ; --# notpresent
    VPB (MQPerf Pl P1) => prov_ + "êramos" ; --# notpresent
    VPB (MQPerf Pl P2) => prov_ + "êreis" ; --# notpresent
    VPB (MQPerf Pl P3) => prov_ + "eram" ; --# notpresent
    VPB (PretP Sg P1) => prov_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => prov_ + "este" ; --# notpresent
    VPB (PretP Sg P3) => prov_ + "eu" ; --# notpresent
    VPB (PretP Pl P1) => prov_ + "emos" ; --# notpresent
    VPB (PretP Pl P2) => prov_ + "estes" ; --# notpresent
    VPB (PretP Pl P3) => prov_ + "eram" ; --# notpresent
    VPB (Fut Ind Sg P1) => prov_ + "erei" ; --# notpresent
    VPB (Fut Ind Sg P2) => prov_ + "erás" ; --# notpresent
    VPB (Fut Ind Sg P3) => prov_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => prov_ + "eremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => prov_ + "ereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => prov_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => prov_ + "er" ; --# notpresent
    VPB (Fut Sub Sg P2) => prov_ + "eres" ; --# notpresent
    VPB (Fut Sub Sg P3) => prov_ + "er" ; --# notpresent
    VPB (Fut Sub Pl P1) => prov_ + "ermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => prov_ + "erdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => prov_ + "erem" ; --# notpresent
    VPB (Cond Sg P1) => prov_ + "eria" ; --# notpresent
    VPB (Cond Sg P2) => prov_ + "erias" ; --# notpresent
    VPB (Cond Sg P3) => prov_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => prov_ + "eríamos" ; --# notpresent
    VPB (Cond Pl P2) => prov_ + "eríeis" ; --# notpresent
    VPB (Cond Pl P3) => prov_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => prov_ + "ê" ;
    VPB (Imper Sg P3) => prov_ + "eja" ;
    VPB (Imper Pl P1) => prov_ + "ejamos" ;
    VPB (Imper Pl P2) => prov_ + "ede" ;
    VPB (Imper Pl P3) => prov_ + "ejam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper ler_Besch : Str -> Verbum = \ler ->
-- 42 | r58
  let l_ = Predef.tk 2 ler in
 {s = table {
    VI Infn => l_ + "er" ;
    VI Ger => l_ + "endo" ;
    VI Part => l_ + "ido" ;
    VPB (Pres Ind Sg P1) => l_ + "eio" ;
    VPB (Pres Ind Sg P2) => l_ + "ês" ;
    VPB (Pres Ind Sg P3) => l_ + "ê" ;
    VPB (Pres Ind Pl P1) => l_ + "emos" ;
    VPB (Pres Ind Pl P2) => l_ + "edes" ;
    VPB (Pres Ind Pl P3) => l_ + vars "eem" "êem" ;
    VPB (Pres Sub Sg P1) => l_ + "eia" ;
    VPB (Pres Sub Sg P2) => l_ + "eias" ;
    VPB (Pres Sub Sg P3) => l_ + "eia" ;
    VPB (Pres Sub Pl P1) => l_ + "eiamos" ;
    VPB (Pres Sub Pl P2) => l_ + "eiais" ;
    VPB (Pres Sub Pl P3) => l_ + "eiam" ;
    VPB (PretI Ind Sg P1) => l_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => l_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => l_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => l_ + "iamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => l_ + "ieis" ; --# notpresent
    VPB (PretI Ind Pl P3) => l_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => l_ + "esse" ; --# notpresent
    VPB (PretI Sub Sg P2) => l_ + "esses" ; --# notpresent
    VPB (PretI Sub Sg P3) => l_ + "esse" ; --# notpresent
    VPB (PretI Sub Pl P1) => l_ + "êssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => l_ + "êsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => l_ + "essem" ; --# notpresent
    VPB (MQPerf Sg P1) => l_ + "era" ; --# notpresent
    VPB (MQPerf Sg P2) => l_ + "eras" ; --# notpresent
    VPB (MQPerf Sg P3) => l_ + "era" ; --# notpresent
    VPB (MQPerf Pl P1) => l_ + "êramos" ; --# notpresent
    VPB (MQPerf Pl P2) => l_ + "êreis" ; --# notpresent
    VPB (MQPerf Pl P3) => l_ + "eram" ; --# notpresent
    VPB (PretP Sg P1) => l_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => l_ + "este" ; --# notpresent
    VPB (PretP Sg P3) => l_ + "eu" ; --# notpresent
    VPB (PretP Pl P1) => l_ + "emos" ; --# notpresent
    VPB (PretP Pl P2) => l_ + "estes" ; --# notpresent
    VPB (PretP Pl P3) => l_ + "eram" ; --# notpresent
    VPB (Fut Ind Sg P1) => l_ + "erei" ; --# notpresent
    VPB (Fut Ind Sg P2) => l_ + "erás" ; --# notpresent
    VPB (Fut Ind Sg P3) => l_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => l_ + "eremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => l_ + "ereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => l_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => l_ + "er" ; --# notpresent
    VPB (Fut Sub Sg P2) => l_ + "eres" ; --# notpresent
    VPB (Fut Sub Sg P3) => l_ + "er" ; --# notpresent
    VPB (Fut Sub Pl P1) => l_ + "ermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => l_ + "erdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => l_ + "erem" ; --# notpresent
    VPB (Cond Sg P1) => l_ + "eria" ; --# notpresent
    VPB (Cond Sg P2) => l_ + "erias" ; --# notpresent
    VPB (Cond Sg P3) => l_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => l_ + "eríamos" ; --# notpresent
    VPB (Cond Pl P2) => l_ + "eríeis" ; --# notpresent
    VPB (Cond Pl P3) => l_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => l_ + "ê" ;
    VPB (Imper Sg P3) => l_ + "eia" ;
    VPB (Imper Pl P1) => l_ + "eiamos" ;
    VPB (Imper Pl P2) => l_ + "ede" ;
    VPB (Imper Pl P3) => l_ + "eiam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper valer_Besch : Str -> Verbum = \valer ->
-- 43 | r74
  let val_ = Predef.tk 2 valer in
 {s = table {
    VI Infn => val_ + "er" ;
    VI Ger => val_ + "endo" ;
    VI Part => val_ + "ido" ;
    VPB (Pres Ind Sg P1) => val_ + "ho" ;
    VPB (Pres Ind Sg P2) => val_ + "es" ;
    VPB (Pres Ind Sg P3) => val_ + "e" ;
    VPB (Pres Ind Pl P1) => val_ + "emos" ;
    VPB (Pres Ind Pl P2) => val_ + "eis" ;
    VPB (Pres Ind Pl P3) => val_ + "em" ;
    VPB (Pres Sub Sg P1) => val_ + "ha" ;
    VPB (Pres Sub Sg P2) => val_ + "has" ;
    VPB (Pres Sub Sg P3) => val_ + "ha" ;
    VPB (Pres Sub Pl P1) => val_ + "hamos" ;
    VPB (Pres Sub Pl P2) => val_ + "hais" ;
    VPB (Pres Sub Pl P3) => val_ + "ham" ;
    VPB (PretI Ind Sg P1) => val_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => val_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => val_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => val_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => val_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => val_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => val_ + "esse" ; --# notpresent
    VPB (PretI Sub Sg P2) => val_ + "esses" ; --# notpresent
    VPB (PretI Sub Sg P3) => val_ + "esse" ; --# notpresent
    VPB (PretI Sub Pl P1) => val_ + "êssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => val_ + "êsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => val_ + "essem" ; --# notpresent
    VPB (MQPerf Sg P1) => val_ + "era" ; --# notpresent
    VPB (MQPerf Sg P2) => val_ + "eras" ; --# notpresent
    VPB (MQPerf Sg P3) => val_ + "era" ; --# notpresent
    VPB (MQPerf Pl P1) => val_ + "êramos" ; --# notpresent
    VPB (MQPerf Pl P2) => val_ + "êreis" ; --# notpresent
    VPB (MQPerf Pl P3) => val_ + "eram" ; --# notpresent
    VPB (PretP Sg P1) => val_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => val_ + "este" ; --# notpresent
    VPB (PretP Sg P3) => val_ + "eu" ; --# notpresent
    VPB (PretP Pl P1) => val_ + "emos" ; --# notpresent
    VPB (PretP Pl P2) => val_ + "estes" ; --# notpresent
    VPB (PretP Pl P3) => val_ + "eram" ; --# notpresent
    VPB (Fut Ind Sg P1) => val_ + "erei" ; --# notpresent
    VPB (Fut Ind Sg P2) => val_ + "erás" ; --# notpresent
    VPB (Fut Ind Sg P3) => val_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => val_ + "eremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => val_ + "ereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => val_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => val_ + "er" ; --# notpresent
    VPB (Fut Sub Sg P2) => val_ + "eres" ; --# notpresent
    VPB (Fut Sub Sg P3) => val_ + "er" ; --# notpresent
    VPB (Fut Sub Pl P1) => val_ + "ermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => val_ + "erdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => val_ + "erem" ; --# notpresent
    VPB (Cond Sg P1) => val_ + "eria" ; --# notpresent
    VPB (Cond Sg P2) => val_ + "erias" ; --# notpresent
    VPB (Cond Sg P3) => val_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => val_ + "eríamos" ; --# notpresent
    VPB (Cond Pl P2) => val_ + "eríeis" ; --# notpresent
    VPB (Cond Pl P3) => val_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => val_ + "e" ;
    VPB (Imper Sg P3) => val_ + "ha" ;
    VPB (Imper Pl P1) => val_ + "hamos" ;
    VPB (Imper Pl P2) => val_ + "ei" ;
    VPB (Imper Pl P3) => val_ + "ham" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper perder_Besch : Str -> Verbum = \perder ->
-- 44 | r65
  let per_ = Predef.tk 3 perder in
 {s = table {
    VI Infn => per_ + "der" ;
    VI Ger => per_ + "dendo" ;
    VI Part => per_ + "dido" ;
    VPB (Pres Ind Sg P1) => per_ + "co" ;
    VPB (Pres Ind Sg P2) => per_ + "des" ;
    VPB (Pres Ind Sg P3) => per_ + "de" ;
    VPB (Pres Ind Pl P1) => per_ + "demos" ;
    VPB (Pres Ind Pl P2) => per_ + "deis" ;
    VPB (Pres Ind Pl P3) => per_ + "dem" ;
    VPB (Pres Sub Sg P1) => per_ + "ca" ;
    VPB (Pres Sub Sg P2) => per_ + "cas" ;
    VPB (Pres Sub Sg P3) => per_ + "ca" ;
    VPB (Pres Sub Pl P1) => per_ + "camos" ;
    VPB (Pres Sub Pl P2) => per_ + "cais" ;
    VPB (Pres Sub Pl P3) => per_ + "cam" ;
    VPB (PretI Ind Sg P1) => per_ + "dia" ; --# notpresent
    VPB (PretI Ind Sg P2) => per_ + "dias" ; --# notpresent
    VPB (PretI Ind Sg P3) => per_ + "dia" ; --# notpresent
    VPB (PretI Ind Pl P1) => per_ + "díamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => per_ + "díeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => per_ + "diam" ; --# notpresent
    VPB (PretI Sub Sg P1) => per_ + "desse" ; --# notpresent
    VPB (PretI Sub Sg P2) => per_ + "desses" ; --# notpresent
    VPB (PretI Sub Sg P3) => per_ + "desse" ; --# notpresent
    VPB (PretI Sub Pl P1) => per_ + "dêssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => per_ + "dêsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => per_ + "dessem" ; --# notpresent
    VPB (MQPerf Sg P1) => per_ + "dera" ; --# notpresent
    VPB (MQPerf Sg P2) => per_ + "deras" ; --# notpresent
    VPB (MQPerf Sg P3) => per_ + "dera" ; --# notpresent
    VPB (MQPerf Pl P1) => per_ + "dêramos" ; --# notpresent
    VPB (MQPerf Pl P2) => per_ + "dêreis" ; --# notpresent
    VPB (MQPerf Pl P3) => per_ + "deram" ; --# notpresent
    VPB (PretP Sg P1) => per_ + "di" ; --# notpresent
    VPB (PretP Sg P2) => per_ + "deste" ; --# notpresent
    VPB (PretP Sg P3) => per_ + "deu" ; --# notpresent
    VPB (PretP Pl P1) => per_ + "demos" ; --# notpresent
    VPB (PretP Pl P2) => per_ + "destes" ; --# notpresent
    VPB (PretP Pl P3) => per_ + "deram" ; --# notpresent
    VPB (Fut Ind Sg P1) => per_ + "derei" ; --# notpresent
    VPB (Fut Ind Sg P2) => per_ + "derás" ; --# notpresent
    VPB (Fut Ind Sg P3) => per_ + "derá" ; --# notpresent
    VPB (Fut Ind Pl P1) => per_ + "deremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => per_ + "dereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => per_ + "derão" ; --# notpresent
    VPB (Fut Sub Sg P1) => per_ + "der" ; --# notpresent
    VPB (Fut Sub Sg P2) => per_ + "deres" ; --# notpresent
    VPB (Fut Sub Sg P3) => per_ + "der" ; --# notpresent
    VPB (Fut Sub Pl P1) => per_ + "dermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => per_ + "derdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => per_ + "derem" ; --# notpresent
    VPB (Cond Sg P1) => per_ + "deria" ; --# notpresent
    VPB (Cond Sg P2) => per_ + "derias" ; --# notpresent
    VPB (Cond Sg P3) => per_ + "deria" ; --# notpresent
    VPB (Cond Pl P1) => per_ + "deríamos" ; --# notpresent
    VPB (Cond Pl P2) => per_ + "deríeis" ; --# notpresent
    VPB (Cond Pl P3) => per_ + "deriam" ; --# notpresent
    VPB (Imper Sg P2) => per_ + "de" ;
    VPB (Imper Sg P3) => per_ + "ca" ;
    VPB (Imper Pl P1) => per_ + "camos" ;
    VPB (Imper Pl P2) => per_ + "dei" ;
    VPB (Imper Pl P3) => per_ + "cam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper pôr_Besch : Str -> Verbum = \pôr ->
-- 45 | r67
  let p_ = Predef.tk 2 pôr in
 {s = table {
    VI Infn => p_ + "ôr" ;
    VI Ger => p_ + "ondo" ;
    VI Part => p_ + "osto" ;
    VPB (Pres Ind Sg P1) => p_ + "onho" ;
    VPB (Pres Ind Sg P2) => p_ + "ões" ;
    VPB (Pres Ind Sg P3) => p_ + "õe" ;
    VPB (Pres Ind Pl P1) => p_ + "omos" ;
    VPB (Pres Ind Pl P2) => p_ + "ondes" ;
    VPB (Pres Ind Pl P3) => p_ + "õem" ;
    VPB (Pres Sub Sg P1) => p_ + "onha" ;
    VPB (Pres Sub Sg P2) => p_ + "onhas" ;
    VPB (Pres Sub Sg P3) => p_ + "onha" ;
    VPB (Pres Sub Pl P1) => p_ + "onhamos" ;
    VPB (Pres Sub Pl P2) => p_ + "onhais" ;
    VPB (Pres Sub Pl P3) => p_ + "onham" ;
    VPB (PretI Ind Sg P1) => p_ + "unha" ; --# notpresent
    VPB (PretI Ind Sg P2) => p_ + "unhas" ; --# notpresent
    VPB (PretI Ind Sg P3) => p_ + "unha" ; --# notpresent
    VPB (PretI Ind Pl P1) => p_ + "únhamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => p_ + "únheis" ; --# notpresent
    VPB (PretI Ind Pl P3) => p_ + "unham" ; --# notpresent
    VPB (PretI Sub Sg P1) => p_ + "usesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => p_ + "usesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => p_ + "usesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => p_ + "uséssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => p_ + "usésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => p_ + "usessem" ; --# notpresent
    VPB (MQPerf Sg P1) => p_ + "usera" ; --# notpresent
    VPB (MQPerf Sg P2) => p_ + "useras" ; --# notpresent
    VPB (MQPerf Sg P3) => p_ + "usera" ; --# notpresent
    VPB (MQPerf Pl P1) => p_ + "uséramos" ; --# notpresent
    VPB (MQPerf Pl P2) => p_ + "uséreis" ; --# notpresent
    VPB (MQPerf Pl P3) => p_ + "useram" ; --# notpresent
    VPB (PretP Sg P1) => p_ + "us" ; --# notpresent
    VPB (PretP Sg P2) => p_ + "useste" ; --# notpresent
    VPB (PretP Sg P3) => p_ + "ôs" ; --# notpresent
    VPB (PretP Pl P1) => p_ + "usemos" ; --# notpresent
    VPB (PretP Pl P2) => p_ + "usestes" ; --# notpresent
    VPB (PretP Pl P3) => p_ + "useram" ; --# notpresent
    VPB (Fut Ind Sg P1) => p_ + "orei" ; --# notpresent
    VPB (Fut Ind Sg P2) => p_ + "orás" ; --# notpresent
    VPB (Fut Ind Sg P3) => p_ + "orá" ; --# notpresent
    VPB (Fut Ind Pl P1) => p_ + "oremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => p_ + "oreis" ; --# notpresent
    VPB (Fut Ind Pl P3) => p_ + "orão" ; --# notpresent
    VPB (Fut Sub Sg P1) => p_ + "user" ; --# notpresent
    VPB (Fut Sub Sg P2) => p_ + "useres" ; --# notpresent
    VPB (Fut Sub Sg P3) => p_ + "user" ; --# notpresent
    VPB (Fut Sub Pl P1) => p_ + "usermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => p_ + "userdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => p_ + "userem" ; --# notpresent
    VPB (Cond Sg P1) => p_ + "oria" ; --# notpresent
    VPB (Cond Sg P2) => p_ + "orias" ; --# notpresent
    VPB (Cond Sg P3) => p_ + "oria" ; --# notpresent
    VPB (Cond Pl P1) => p_ + "oríamos" ; --# notpresent
    VPB (Cond Pl P2) => p_ + "oríeis" ; --# notpresent
    VPB (Cond Pl P3) => p_ + "oriam" ; --# notpresent
    VPB (Imper Sg P2) => p_ + "õe" ;
    VPB (Imper Sg P3) => p_ + "onha" ;
    VPB (Imper Pl P1) => p_ + "onhamos" ;
    VPB (Imper Pl P2) => p_ + "onde" ;
    VPB (Imper Pl P3) => p_ + "onham" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper acontecer_Besch : Str -> Verbum = \acontecer ->
-- 46 | r25
  let aconte_ = Predef.tk 3 acontecer in
 {s = table {
    VI Infn => aconte_ + "cer" ;
    VI Ger => aconte_ + "cendo" ;
    VI Part => aconte_ + "cido" ;
    VPB (Pres Ind Sg P1) => aconte_ + nonExist ;
    VPB (Pres Ind Sg P2) => aconte_ + nonExist ;
    VPB (Pres Ind Sg P3) => aconte_ + "ce" ;
    VPB (Pres Ind Pl P1) => aconte_ + nonExist ;
    VPB (Pres Ind Pl P2) => aconte_ + nonExist ;
    VPB (Pres Ind Pl P3) => aconte_ + "cem" ;
    VPB (Pres Sub Sg P1) => aconte_ + nonExist ;
    VPB (Pres Sub Sg P2) => aconte_ + nonExist ;
    VPB (Pres Sub Sg P3) => aconte_ + "ça" ;
    VPB (Pres Sub Pl P1) => aconte_ + nonExist ;
    VPB (Pres Sub Pl P2) => aconte_ + nonExist ;
    VPB (Pres Sub Pl P3) => aconte_ + "çam" ;
    VPB (PretI Ind Sg P1) => aconte_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P2) => aconte_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P3) => aconte_ + "cia" ; --# notpresent
    VPB (PretI Ind Pl P1) => aconte_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P2) => aconte_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P3) => aconte_ + "ciam" ; --# notpresent
    VPB (PretI Sub Sg P1) => aconte_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P2) => aconte_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P3) => aconte_ + "cesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => aconte_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P2) => aconte_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P3) => aconte_ + "cessem" ; --# notpresent
    VPB (MQPerf Sg P1) => aconte_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P2) => aconte_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P3) => aconte_ + "cera" ; --# notpresent
    VPB (MQPerf Pl P1) => aconte_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P2) => aconte_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P3) => aconte_ + "ceram" ; --# notpresent
    VPB (PretP Sg P1) => aconte_ + nonExist ; --# notpresent
    VPB (PretP Sg P2) => aconte_ + nonExist ; --# notpresent
    VPB (PretP Sg P3) => aconte_ + "ceu" ; --# notpresent
    VPB (PretP Pl P1) => aconte_ + nonExist ; --# notpresent
    VPB (PretP Pl P2) => aconte_ + nonExist ; --# notpresent
    VPB (PretP Pl P3) => aconte_ + "ceram" ; --# notpresent
    VPB (Fut Ind Sg P1) => aconte_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P2) => aconte_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P3) => aconte_ + "cerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => aconte_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P2) => aconte_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P3) => aconte_ + "cerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => aconte_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P2) => aconte_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P3) => aconte_ + "cer" ; --# notpresent
    VPB (Fut Sub Pl P1) => aconte_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P2) => aconte_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P3) => aconte_ + "cerem" ; --# notpresent
    VPB (Cond Sg P1) => aconte_ + nonExist ; --# notpresent
    VPB (Cond Sg P2) => aconte_ + nonExist ; --# notpresent
    VPB (Cond Sg P3) => aconte_ + "ceria" ; --# notpresent
    VPB (Cond Pl P1) => aconte_ + nonExist ; --# notpresent
    VPB (Cond Pl P2) => aconte_ + nonExist ; --# notpresent
    VPB (Cond Pl P3) => aconte_ + "ceriam" ; --# notpresent
    VPB (Imper Sg P2) => aconte_ + nonExist ;
    VPB (Imper Sg P3) => aconte_ + nonExist ;
    VPB (Imper Pl P1) => aconte_ + nonExist ;
    VPB (Imper Pl P2) => aconte_ + nonExist ;
    VPB (Imper Pl P3) => aconte_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper chover_Besch : Str -> Verbum = \chover ->
-- 47 | r6
  let chov_ = Predef.tk 2 chover in
 {s = table {
    VI Infn => chov_ + "er" ;
    VI Ger => chov_ + "endo" ;
    VI Part => chov_ + "ido" ;
    VPB (Pres Ind Sg P1) => chov_ + nonExist ;
    VPB (Pres Ind Sg P2) => chov_ + nonExist ;
    VPB (Pres Ind Sg P3) => chov_ + "e" ;
    VPB (Pres Ind Pl P1) => chov_ + nonExist ;
    VPB (Pres Ind Pl P2) => chov_ + nonExist ;
    VPB (Pres Ind Pl P3) => chov_ + "em" ;
    VPB (Pres Sub Sg P1) => chov_ + nonExist ;
    VPB (Pres Sub Sg P2) => chov_ + nonExist ;
    VPB (Pres Sub Sg P3) => chov_ + "a" ;
    VPB (Pres Sub Pl P1) => chov_ + nonExist ;
    VPB (Pres Sub Pl P2) => chov_ + nonExist ;
    VPB (Pres Sub Pl P3) => chov_ + "am" ;
    VPB (PretI Ind Sg P1) => chov_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P2) => chov_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P3) => chov_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => chov_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P2) => chov_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P3) => chov_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => chov_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P2) => chov_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P3) => chov_ + "esse" ; --# notpresent
    VPB (PretI Sub Pl P1) => chov_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P2) => chov_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P3) => chov_ + "essem" ; --# notpresent
    VPB (MQPerf Sg P1) => chov_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P2) => chov_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P3) => chov_ + "era" ; --# notpresent
    VPB (MQPerf Pl P1) => chov_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P2) => chov_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P3) => chov_ + "eram" ; --# notpresent
    VPB (PretP Sg P1) => chov_ + nonExist ; --# notpresent
    VPB (PretP Sg P2) => chov_ + nonExist ; --# notpresent
    VPB (PretP Sg P3) => chov_ + "eu" ; --# notpresent
    VPB (PretP Pl P1) => chov_ + nonExist ; --# notpresent
    VPB (PretP Pl P2) => chov_ + nonExist ; --# notpresent
    VPB (PretP Pl P3) => chov_ + "eram" ; --# notpresent
    VPB (Fut Ind Sg P1) => chov_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P2) => chov_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P3) => chov_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => chov_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P2) => chov_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P3) => chov_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => chov_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P2) => chov_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P3) => chov_ + "er" ; --# notpresent
    VPB (Fut Sub Pl P1) => chov_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P2) => chov_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P3) => chov_ + "erem" ; --# notpresent
    VPB (Cond Sg P1) => chov_ + nonExist ; --# notpresent
    VPB (Cond Sg P2) => chov_ + nonExist ; --# notpresent
    VPB (Cond Sg P3) => chov_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => chov_ + nonExist ; --# notpresent
    VPB (Cond Pl P2) => chov_ + nonExist ; --# notpresent
    VPB (Cond Pl P3) => chov_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => chov_ + nonExist ;
    VPB (Imper Sg P3) => chov_ + nonExist ;
    VPB (Imper Pl P1) => chov_ + nonExist ;
    VPB (Imper Pl P2) => chov_ + nonExist ;
    VPB (Imper Pl P3) => chov_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper doer_Besch : Str -> Verbum = \doer ->
-- 48 | r83
  let d_ = Predef.tk 3 doer in
 {s = table {
    VI Infn => d_ + "oer" ;
    VI Ger => d_ + "oendo" ;
    VI Part => d_ + "oído" ;
    VPB (Pres Ind Sg P1) => d_ + nonExist ;
    VPB (Pres Ind Sg P2) => d_ + nonExist ;
    VPB (Pres Ind Sg P3) => d_ + "ói" ;
    VPB (Pres Ind Pl P1) => d_ + nonExist ;
    VPB (Pres Ind Pl P2) => d_ + nonExist ;
    VPB (Pres Ind Pl P3) => d_ + "oem" ;
    VPB (Pres Sub Sg P1) => d_ + nonExist ;
    VPB (Pres Sub Sg P2) => d_ + nonExist ;
    VPB (Pres Sub Sg P3) => d_ + "oa" ;
    VPB (Pres Sub Pl P1) => d_ + nonExist ;
    VPB (Pres Sub Pl P2) => d_ + nonExist ;
    VPB (Pres Sub Pl P3) => d_ + "oam" ;
    VPB (PretI Ind Sg P1) => d_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P2) => d_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P3) => d_ + "oía" ; --# notpresent
    VPB (PretI Ind Pl P1) => d_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P2) => d_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P3) => d_ + "oíam" ; --# notpresent
    VPB (PretI Sub Sg P1) => d_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P2) => d_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P3) => d_ + "oesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => d_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P2) => d_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P3) => d_ + "oessem" ; --# notpresent
    VPB (MQPerf Sg P1) => d_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P2) => d_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P3) => d_ + "oera" ; --# notpresent
    VPB (MQPerf Pl P1) => d_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P2) => d_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P3) => d_ + "oeram" ; --# notpresent
    VPB (PretP Sg P1) => d_ + nonExist ; --# notpresent
    VPB (PretP Sg P2) => d_ + nonExist ; --# notpresent
    VPB (PretP Sg P3) => d_ + "oeu" ; --# notpresent
    VPB (PretP Pl P1) => d_ + nonExist ; --# notpresent
    VPB (PretP Pl P2) => d_ + nonExist ; --# notpresent
    VPB (PretP Pl P3) => d_ + "oeram" ; --# notpresent
    VPB (Fut Ind Sg P1) => d_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P2) => d_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P3) => d_ + "oerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => d_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P2) => d_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P3) => d_ + "oerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => d_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P2) => d_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P3) => d_ + "oer" ; --# notpresent
    VPB (Fut Sub Pl P1) => d_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P2) => d_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P3) => d_ + "oerem" ; --# notpresent
    VPB (Cond Sg P1) => d_ + nonExist ; --# notpresent
    VPB (Cond Sg P2) => d_ + nonExist ; --# notpresent
    VPB (Cond Sg P3) => d_ + "oeria" ; --# notpresent
    VPB (Cond Pl P1) => d_ + nonExist ; --# notpresent
    VPB (Cond Pl P2) => d_ + nonExist ; --# notpresent
    VPB (Cond Pl P3) => d_ + "oeriam" ; --# notpresent
    VPB (Imper Sg P2) => d_ + nonExist ;
    VPB (Imper Sg P3) => d_ + nonExist ;
    VPB (Imper Pl P1) => d_ + nonExist ;
    VPB (Imper Pl P2) => d_ + nonExist ;
    VPB (Imper Pl P3) => d_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper prazer_Besch : Str -> Verbum = \prazer ->
-- 49 | r55
  let pr_ = Predef.tk 4 prazer in
 {s = table {
    VI Infn => pr_ + "azer" ;
    VI Ger => pr_ + "azendo" ;
    VI Part => pr_ + "azido" ;
    VPB (Pres Ind Sg P1) => pr_ + nonExist ;
    VPB (Pres Ind Sg P2) => pr_ + nonExist ;
    VPB (Pres Ind Sg P3) => pr_ + "az" ;
    VPB (Pres Ind Pl P1) => pr_ + nonExist ;
    VPB (Pres Ind Pl P2) => pr_ + nonExist ;
    VPB (Pres Ind Pl P3) => pr_ + "azem" ;
    VPB (Pres Sub Sg P1) => pr_ + nonExist ;
    VPB (Pres Sub Sg P2) => pr_ + nonExist ;
    VPB (Pres Sub Sg P3) => pr_ + "aza" ;
    VPB (Pres Sub Pl P1) => pr_ + nonExist ;
    VPB (Pres Sub Pl P2) => pr_ + nonExist ;
    VPB (Pres Sub Pl P3) => pr_ + "azam" ;
    VPB (PretI Ind Sg P1) => pr_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P2) => pr_ + nonExist ; --# notpresent
    VPB (PretI Ind Sg P3) => pr_ + "azia" ; --# notpresent
    VPB (PretI Ind Pl P1) => pr_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P2) => pr_ + nonExist ; --# notpresent
    VPB (PretI Ind Pl P3) => pr_ + "aziam" ; --# notpresent
    VPB (PretI Sub Sg P1) => pr_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P2) => pr_ + nonExist ; --# notpresent
    VPB (PretI Sub Sg P3) => pr_ + "ouvesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => pr_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P2) => pr_ + nonExist ; --# notpresent
    VPB (PretI Sub Pl P3) => pr_ + "ouvessem" ; --# notpresent
    VPB (MQPerf Sg P1) => pr_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P2) => pr_ + nonExist ; --# notpresent
    VPB (MQPerf Sg P3) => pr_ + "ouvera" ; --# notpresent
    VPB (MQPerf Pl P1) => pr_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P2) => pr_ + nonExist ; --# notpresent
    VPB (MQPerf Pl P3) => pr_ + "ouveram" ; --# notpresent
    VPB (PretP Sg P1) => pr_ + nonExist ; --# notpresent
    VPB (PretP Sg P2) => pr_ + nonExist ; --# notpresent
    VPB (PretP Sg P3) => pr_ + "ouve" ; --# notpresent
    VPB (PretP Pl P1) => pr_ + nonExist ; --# notpresent
    VPB (PretP Pl P2) => pr_ + nonExist ; --# notpresent
    VPB (PretP Pl P3) => pr_ + "ouveram" ; --# notpresent
    VPB (Fut Ind Sg P1) => pr_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P2) => pr_ + nonExist ; --# notpresent
    VPB (Fut Ind Sg P3) => pr_ + "azerá" ; --# notpresent
    VPB (Fut Ind Pl P1) => pr_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P2) => pr_ + nonExist ; --# notpresent
    VPB (Fut Ind Pl P3) => pr_ + "azerão" ; --# notpresent
    VPB (Fut Sub Sg P1) => pr_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P2) => pr_ + nonExist ; --# notpresent
    VPB (Fut Sub Sg P3) => pr_ + "ouver" ; --# notpresent
    VPB (Fut Sub Pl P1) => pr_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P2) => pr_ + nonExist ; --# notpresent
    VPB (Fut Sub Pl P3) => pr_ + "ouverem" ; --# notpresent
    VPB (Cond Sg P1) => pr_ + nonExist ; --# notpresent
    VPB (Cond Sg P2) => pr_ + nonExist ; --# notpresent
    VPB (Cond Sg P3) => pr_ + "azeria" ; --# notpresent
    VPB (Cond Pl P1) => pr_ + nonExist ; --# notpresent
    VPB (Cond Pl P2) => pr_ + nonExist ; --# notpresent
    VPB (Cond Pl P3) => pr_ + "azeriam" ; --# notpresent
    VPB (Imper Sg P2) => pr_ + nonExist ;
    VPB (Imper Sg P3) => pr_ + nonExist ;
    VPB (Imper Pl P1) => pr_ + nonExist ;
    VPB (Imper Pl P2) => pr_ + nonExist ;
    VPB (Imper Pl P3) => pr_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper precaver_Besch : Str -> Verbum = \precaver ->
-- 50 | r85
  let precav_ = Predef.tk 2 precaver in
 {s = table {
    VI Infn => precav_ + "er" ;
    VI Ger => precav_ + "endo" ;
    VI Part => precav_ + "ido" ;
    VPB (Pres Ind Sg P1) => precav_ + nonExist ;
    VPB (Pres Ind Sg P2) => precav_ + nonExist ;
    VPB (Pres Ind Sg P3) => precav_ + nonExist ;
    VPB (Pres Ind Pl P1) => precav_ + "emos" ;
    VPB (Pres Ind Pl P2) => precav_ + "eis" ;
    VPB (Pres Ind Pl P3) => precav_ + nonExist ;
    VPB (Pres Sub Sg P1) => precav_ + nonExist ;
    VPB (Pres Sub Sg P2) => precav_ + nonExist ;
    VPB (Pres Sub Sg P3) => precav_ + nonExist ;
    VPB (Pres Sub Pl P1) => precav_ + nonExist ;
    VPB (Pres Sub Pl P2) => precav_ + nonExist ;
    VPB (Pres Sub Pl P3) => precav_ + nonExist ;
    VPB (PretI Ind Sg P1) => precav_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => precav_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => precav_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => precav_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => precav_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => precav_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => precav_ + "esse" ; --# notpresent
    VPB (PretI Sub Sg P2) => precav_ + "esses" ; --# notpresent
    VPB (PretI Sub Sg P3) => precav_ + "esse" ; --# notpresent
    VPB (PretI Sub Pl P1) => precav_ + "êssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => precav_ + "êsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => precav_ + "essem" ; --# notpresent
    VPB (MQPerf Sg P1) => precav_ + "era" ; --# notpresent
    VPB (MQPerf Sg P2) => precav_ + "eras" ; --# notpresent
    VPB (MQPerf Sg P3) => precav_ + "era" ; --# notpresent
    VPB (MQPerf Pl P1) => precav_ + "êramos" ; --# notpresent
    VPB (MQPerf Pl P2) => precav_ + "êreis" ; --# notpresent
    VPB (MQPerf Pl P3) => precav_ + "eram" ; --# notpresent
    VPB (PretP Sg P1) => precav_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => precav_ + "este" ; --# notpresent
    VPB (PretP Sg P3) => precav_ + "eu" ; --# notpresent
    VPB (PretP Pl P1) => precav_ + "emos" ; --# notpresent
    VPB (PretP Pl P2) => precav_ + "estes" ; --# notpresent
    VPB (PretP Pl P3) => precav_ + "eram" ; --# notpresent
    VPB (Fut Ind Sg P1) => precav_ + "erei" ; --# notpresent
    VPB (Fut Ind Sg P2) => precav_ + "erás" ; --# notpresent
    VPB (Fut Ind Sg P3) => precav_ + "erá" ; --# notpresent
    VPB (Fut Ind Pl P1) => precav_ + "eremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => precav_ + "ereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => precav_ + "erão" ; --# notpresent
    VPB (Fut Sub Sg P1) => precav_ + "er" ; --# notpresent
    VPB (Fut Sub Sg P2) => precav_ + "eres" ; --# notpresent
    VPB (Fut Sub Sg P3) => precav_ + "er" ; --# notpresent
    VPB (Fut Sub Pl P1) => precav_ + "ermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => precav_ + "erdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => precav_ + "erem" ; --# notpresent
    VPB (Cond Sg P1) => precav_ + "eria" ; --# notpresent
    VPB (Cond Sg P2) => precav_ + "erias" ; --# notpresent
    VPB (Cond Sg P3) => precav_ + "eria" ; --# notpresent
    VPB (Cond Pl P1) => precav_ + "eríamos" ; --# notpresent
    VPB (Cond Pl P2) => precav_ + "eríeis" ; --# notpresent
    VPB (Cond Pl P3) => precav_ + "eriam" ; --# notpresent
    VPB (Imper Sg P2) => precav_ + nonExist ;
    VPB (Imper Sg P3) => precav_ + nonExist ;
    VPB (Imper Pl P1) => precav_ + nonExist ;
    VPB (Imper Pl P2) => precav_ + "ei" ;
    VPB (Imper Pl P3) => precav_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper reaver_Besch : Str -> Verbum = \reaver ->
-- 51 | r86
  let re_ = Predef.tk 4 reaver in
 {s = table {
    VI Infn => re_ + "aver" ;
    VI Ger => re_ + "avendo" ;
    VI Part => re_ + "avido" ;
    VPB (Pres Ind Sg P1) => re_ + nonExist ;
    VPB (Pres Ind Sg P2) => re_ + nonExist ;
    VPB (Pres Ind Sg P3) => re_ + nonExist ;
    VPB (Pres Ind Pl P1) => re_ + "avemos" ;
    VPB (Pres Ind Pl P2) => re_ + "aveis" ;
    VPB (Pres Ind Pl P3) => re_ + nonExist ;
    VPB (Pres Sub Sg P1) => re_ + nonExist ;
    VPB (Pres Sub Sg P2) => re_ + nonExist ;
    VPB (Pres Sub Sg P3) => re_ + nonExist ;
    VPB (Pres Sub Pl P1) => re_ + nonExist ;
    VPB (Pres Sub Pl P2) => re_ + nonExist ;
    VPB (Pres Sub Pl P3) => re_ + nonExist ;
    VPB (PretI Ind Sg P1) => re_ + "avia" ; --# notpresent
    VPB (PretI Ind Sg P2) => re_ + "avias" ; --# notpresent
    VPB (PretI Ind Sg P3) => re_ + "avia" ; --# notpresent
    VPB (PretI Ind Pl P1) => re_ + "avíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => re_ + "avíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => re_ + "aviam" ; --# notpresent
    VPB (PretI Sub Sg P1) => re_ + "ouvesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => re_ + "ouvesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => re_ + "ouvesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => re_ + "ouvéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => re_ + "ouvésseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => re_ + "ouvessem" ; --# notpresent
    VPB (MQPerf Sg P1) => re_ + "ouvera" ; --# notpresent
    VPB (MQPerf Sg P2) => re_ + "ouveras" ; --# notpresent
    VPB (MQPerf Sg P3) => re_ + "ouvera" ; --# notpresent
    VPB (MQPerf Pl P1) => re_ + "ouvéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => re_ + "ouvéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => re_ + "ouveram" ; --# notpresent
    VPB (PretP Sg P1) => re_ + "ouve" ; --# notpresent
    VPB (PretP Sg P2) => re_ + "ouveste" ; --# notpresent
    VPB (PretP Sg P3) => re_ + "ouve" ; --# notpresent
    VPB (PretP Pl P1) => re_ + "ouvemos" ; --# notpresent
    VPB (PretP Pl P2) => re_ + "ouvestes" ; --# notpresent
    VPB (PretP Pl P3) => re_ + "ouveram" ; --# notpresent
    VPB (Fut Ind Sg P1) => re_ + "averei" ; --# notpresent
    VPB (Fut Ind Sg P2) => re_ + "averás" ; --# notpresent
    VPB (Fut Ind Sg P3) => re_ + "averá" ; --# notpresent
    VPB (Fut Ind Pl P1) => re_ + "averemos" ; --# notpresent
    VPB (Fut Ind Pl P2) => re_ + "avereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => re_ + "averão" ; --# notpresent
    VPB (Fut Sub Sg P1) => re_ + "ouver" ; --# notpresent
    VPB (Fut Sub Sg P2) => re_ + "ouveres" ; --# notpresent
    VPB (Fut Sub Sg P3) => re_ + "ouver" ; --# notpresent
    VPB (Fut Sub Pl P1) => re_ + "ouvermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => re_ + "ouverdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => re_ + "ouverem" ; --# notpresent
    VPB (Cond Sg P1) => re_ + "averia" ; --# notpresent
    VPB (Cond Sg P2) => re_ + "averias" ; --# notpresent
    VPB (Cond Sg P3) => re_ + "averia" ; --# notpresent
    VPB (Cond Pl P1) => re_ + "averíamos" ; --# notpresent
    VPB (Cond Pl P2) => re_ + "averíeis" ; --# notpresent
    VPB (Cond Pl P3) => re_ + "averiam" ; --# notpresent
    VPB (Imper Sg P2) => re_ + nonExist ;
    VPB (Imper Sg P3) => re_ + nonExist ;
    VPB (Imper Pl P1) => re_ + nonExist ;
    VPB (Imper Pl P2) => re_ + "avei" ;
    VPB (Imper Pl P3) => re_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper redigir_Besch : Str -> Verbum = \redigir ->
-- 52 | r28
  let red_ = Predef.tk 4 redigir in
 {s = table {
    VI Infn => red_ + "igir" ;
    VI Ger => red_ + "igindo" ;
    VI Part => red_ + "igido" ;
    VPB (Pres Ind Sg P1) => red_ + "ijo" ;
    VPB (Pres Ind Sg P2) => red_ + "iges" ;
    VPB (Pres Ind Sg P3) => red_ + "ige" ;
    VPB (Pres Ind Pl P1) => red_ + "igimos" ;
    VPB (Pres Ind Pl P2) => red_ + "igis" ;
    VPB (Pres Ind Pl P3) => red_ + "igem" ;
    VPB (Pres Sub Sg P1) => red_ + "ija" ;
    VPB (Pres Sub Sg P2) => red_ + "ijas" ;
    VPB (Pres Sub Sg P3) => red_ + "ija" ;
    VPB (Pres Sub Pl P1) => red_ + "ijamos" ;
    VPB (Pres Sub Pl P2) => red_ + "ijais" ;
    VPB (Pres Sub Pl P3) => red_ + "ijam" ;
    VPB (PretI Ind Sg P1) => red_ + "igia" ; --# notpresent
    VPB (PretI Ind Sg P2) => red_ + "igias" ; --# notpresent
    VPB (PretI Ind Sg P3) => red_ + "igia" ; --# notpresent
    VPB (PretI Ind Pl P1) => red_ + "igíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => red_ + "ígieis" ; --# notpresent
    VPB (PretI Ind Pl P3) => red_ + "igiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => red_ + "igisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => red_ + "igisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => red_ + "igisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => red_ + "igíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => red_ + "igísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => red_ + "igissem" ; --# notpresent
    VPB (MQPerf Sg P1) => red_ + "igira" ; --# notpresent
    VPB (MQPerf Sg P2) => red_ + "igiras" ; --# notpresent
    VPB (MQPerf Sg P3) => red_ + "igira" ; --# notpresent
    VPB (MQPerf Pl P1) => red_ + "igíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => red_ + "igíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => red_ + "igiram" ; --# notpresent
    VPB (PretP Sg P1) => red_ + "igi" ; --# notpresent
    VPB (PretP Sg P2) => red_ + "igiste" ; --# notpresent
    VPB (PretP Sg P3) => red_ + "igiu" ; --# notpresent
    VPB (PretP Pl P1) => red_ + "igimos" ; --# notpresent
    VPB (PretP Pl P2) => red_ + "igistes" ; --# notpresent
    VPB (PretP Pl P3) => red_ + "igiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => red_ + "igirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => red_ + "igirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => red_ + "igirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => red_ + "igiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => red_ + "igireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => red_ + "igirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => red_ + "igir" ; --# notpresent
    VPB (Fut Sub Sg P2) => red_ + "igires" ; --# notpresent
    VPB (Fut Sub Sg P3) => red_ + "igir" ; --# notpresent
    VPB (Fut Sub Pl P1) => red_ + "igirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => red_ + "igirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => red_ + "igirem" ; --# notpresent
    VPB (Cond Sg P1) => red_ + "igiria" ; --# notpresent
    VPB (Cond Sg P2) => red_ + "igirias" ; --# notpresent
    VPB (Cond Sg P3) => red_ + "igiria" ; --# notpresent
    VPB (Cond Pl P1) => red_ + "igiríamos" ; --# notpresent
    VPB (Cond Pl P2) => red_ + "igiríeis" ; --# notpresent
    VPB (Cond Pl P3) => red_ + "igiriam" ; --# notpresent
    VPB (Imper Sg P2) => red_ + "ige" ;
    VPB (Imper Sg P3) => red_ + "ija" ;
    VPB (Imper Pl P1) => red_ + "ijamos" ;
    VPB (Imper Pl P2) => red_ + "igi" ;
    VPB (Imper Pl P3) => red_ + "ijam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper extinguir_Besch : Str -> Verbum = \extinguir ->
-- 53 | r33
  let extin_ = Predef.tk 4 extinguir in
 {s = table {
    VI Infn => extin_ + "guir" ;
    VI Ger => extin_ + "guindo" ;
    VI Part => extin_ + vars "to" "guido" ;
    VPB (Pres Ind Sg P1) => extin_ + "go" ;
    VPB (Pres Ind Sg P2) => extin_ + "gues" ;
    VPB (Pres Ind Sg P3) => extin_ + "gue" ;
    VPB (Pres Ind Pl P1) => extin_ + "guimos" ;
    VPB (Pres Ind Pl P2) => extin_ + "guis" ;
    VPB (Pres Ind Pl P3) => extin_ + "guem" ;
    VPB (Pres Sub Sg P1) => extin_ + "ga" ;
    VPB (Pres Sub Sg P2) => extin_ + "gas" ;
    VPB (Pres Sub Sg P3) => extin_ + "ga" ;
    VPB (Pres Sub Pl P1) => extin_ + "gamos" ;
    VPB (Pres Sub Pl P2) => extin_ + "gais" ;
    VPB (Pres Sub Pl P3) => extin_ + "gam" ;
    VPB (PretI Ind Sg P1) => extin_ + "guia" ; --# notpresent
    VPB (PretI Ind Sg P2) => extin_ + "guias" ; --# notpresent
    VPB (PretI Ind Sg P3) => extin_ + "guia" ; --# notpresent
    VPB (PretI Ind Pl P1) => extin_ + "guíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => extin_ + "guíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => extin_ + "guiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => extin_ + "guisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => extin_ + "guisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => extin_ + "guisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => extin_ + "guíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => extin_ + "guísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => extin_ + "guissem" ; --# notpresent
    VPB (MQPerf Sg P1) => extin_ + "guira" ; --# notpresent
    VPB (MQPerf Sg P2) => extin_ + "guiras" ; --# notpresent
    VPB (MQPerf Sg P3) => extin_ + "guira" ; --# notpresent
    VPB (MQPerf Pl P1) => extin_ + "guíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => extin_ + "guíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => extin_ + "guiram" ; --# notpresent
    VPB (PretP Sg P1) => extin_ + "gui" ; --# notpresent
    VPB (PretP Sg P2) => extin_ + "guiste" ; --# notpresent
    VPB (PretP Sg P3) => extin_ + "guiu" ; --# notpresent
    VPB (PretP Pl P1) => extin_ + "guímos" ; --# notpresent
    VPB (PretP Pl P2) => extin_ + "guistes" ; --# notpresent
    VPB (PretP Pl P3) => extin_ + "guiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => extin_ + "guirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => extin_ + "guirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => extin_ + "guirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => extin_ + "guiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => extin_ + "guireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => extin_ + "guirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => extin_ + "guir" ; --# notpresent
    VPB (Fut Sub Sg P2) => extin_ + "guires" ; --# notpresent
    VPB (Fut Sub Sg P3) => extin_ + "guir" ; --# notpresent
    VPB (Fut Sub Pl P1) => extin_ + "guirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => extin_ + "guirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => extin_ + "guirem" ; --# notpresent
    VPB (Cond Sg P1) => extin_ + "guiria" ; --# notpresent
    VPB (Cond Sg P2) => extin_ + "guirias" ; --# notpresent
    VPB (Cond Sg P3) => extin_ + "guiria" ; --# notpresent
    VPB (Cond Pl P1) => extin_ + "guiríamos" ; --# notpresent
    VPB (Cond Pl P2) => extin_ + "guiríeis" ; --# notpresent
    VPB (Cond Pl P3) => extin_ + "guiriam" ; --# notpresent
    VPB (Imper Sg P2) => extin_ + "gue" ;
    VPB (Imper Sg P3) => extin_ + "ga" ;
    VPB (Imper Pl P1) => extin_ + "gamos" ;
    VPB (Imper Pl P2) => extin_ + "gui" ;
    VPB (Imper Pl P3) => extin_ + "gam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper servir_Besch : Str -> Verbum = \servir ->
-- 54 | r47
  let s_ = Predef.tk 5 servir in
 {s = table {
    VI Infn => s_ + "ervir" ;
    VI Ger => s_ + "ervindo" ;
    VI Part => s_ + "ervido" ;
    VPB (Pres Ind Sg P1) => s_ + "irvo" ;
    VPB (Pres Ind Sg P2) => s_ + "erves" ;
    VPB (Pres Ind Sg P3) => s_ + "erve" ;
    VPB (Pres Ind Pl P1) => s_ + "ervimos" ;
    VPB (Pres Ind Pl P2) => s_ + "ervis" ;
    VPB (Pres Ind Pl P3) => s_ + "ervem" ;
    VPB (Pres Sub Sg P1) => s_ + "irva" ;
    VPB (Pres Sub Sg P2) => s_ + "irvas" ;
    VPB (Pres Sub Sg P3) => s_ + "irva" ;
    VPB (Pres Sub Pl P1) => s_ + "irvamos" ;
    VPB (Pres Sub Pl P2) => s_ + "irvais" ;
    VPB (Pres Sub Pl P3) => s_ + "irvam" ;
    VPB (PretI Ind Sg P1) => s_ + "ervia" ; --# notpresent
    VPB (PretI Ind Sg P2) => s_ + "ervias" ; --# notpresent
    VPB (PretI Ind Sg P3) => s_ + "ervia" ; --# notpresent
    VPB (PretI Ind Pl P1) => s_ + "ervíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => s_ + "ervíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => s_ + "erviam" ; --# notpresent
    VPB (PretI Sub Sg P1) => s_ + "ervisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => s_ + "ervisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => s_ + "ervisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => s_ + "ervíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => s_ + "ervísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => s_ + "ervissem" ; --# notpresent
    VPB (MQPerf Sg P1) => s_ + "ervira" ; --# notpresent
    VPB (MQPerf Sg P2) => s_ + "erviras" ; --# notpresent
    VPB (MQPerf Sg P3) => s_ + "ervira" ; --# notpresent
    VPB (MQPerf Pl P1) => s_ + "ervíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => s_ + "ervíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => s_ + "erviram" ; --# notpresent
    VPB (PretP Sg P1) => s_ + "ervi" ; --# notpresent
    VPB (PretP Sg P2) => s_ + "erviste" ; --# notpresent
    VPB (PretP Sg P3) => s_ + "erviu" ; --# notpresent
    VPB (PretP Pl P1) => s_ + "ervimos" ; --# notpresent
    VPB (PretP Pl P2) => s_ + "ervistes" ; --# notpresent
    VPB (PretP Pl P3) => s_ + "erviram" ; --# notpresent
    VPB (Fut Ind Sg P1) => s_ + "ervirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => s_ + "ervirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => s_ + "ervirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => s_ + "erviremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => s_ + "ervireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => s_ + "ervirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => s_ + "ervir" ; --# notpresent
    VPB (Fut Sub Sg P2) => s_ + "ervires" ; --# notpresent
    VPB (Fut Sub Sg P3) => s_ + "ervir" ; --# notpresent
    VPB (Fut Sub Pl P1) => s_ + "ervirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => s_ + "ervirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => s_ + "ervirem" ; --# notpresent
    VPB (Cond Sg P1) => s_ + "erviria" ; --# notpresent
    VPB (Cond Sg P2) => s_ + "ervirias" ; --# notpresent
    VPB (Cond Sg P3) => s_ + "erviria" ; --# notpresent
    VPB (Cond Pl P1) => s_ + "erviríamos" ; --# notpresent
    VPB (Cond Pl P2) => s_ + "erviríeis" ; --# notpresent
    VPB (Cond Pl P3) => s_ + "erviriam" ; --# notpresent
    VPB (Imper Sg P2) => s_ + "erve" ;
    VPB (Imper Sg P3) => s_ + "irva" ;
    VPB (Imper Pl P1) => s_ + "irvamos" ;
    VPB (Imper Pl P2) => s_ + "ervi" ;
    VPB (Imper Pl P3) => s_ + "irvam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper seguir_Besch : Str -> Verbum = \seguir ->
-- 55 | r50
  let s_ = Predef.tk 5 seguir in
 {s = table {
    VI Infn => s_ + "eguir" ;
    VI Ger => s_ + "eguindo" ;
    VI Part => s_ + "eguido" ;
    VPB (Pres Ind Sg P1) => s_ + "igo" ;
    VPB (Pres Ind Sg P2) => s_ + "egues" ;
    VPB (Pres Ind Sg P3) => s_ + "egue" ;
    VPB (Pres Ind Pl P1) => s_ + "eguimos" ;
    VPB (Pres Ind Pl P2) => s_ + "eguis" ;
    VPB (Pres Ind Pl P3) => s_ + "eguem" ;
    VPB (Pres Sub Sg P1) => s_ + "iga" ;
    VPB (Pres Sub Sg P2) => s_ + "igas" ;
    VPB (Pres Sub Sg P3) => s_ + "iga" ;
    VPB (Pres Sub Pl P1) => s_ + "igamos" ;
    VPB (Pres Sub Pl P2) => s_ + "igais" ;
    VPB (Pres Sub Pl P3) => s_ + "igam" ;
    VPB (PretI Ind Sg P1) => s_ + "eguia" ; --# notpresent
    VPB (PretI Ind Sg P2) => s_ + "eguias" ; --# notpresent
    VPB (PretI Ind Sg P3) => s_ + "eguia" ; --# notpresent
    VPB (PretI Ind Pl P1) => s_ + "eguíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => s_ + "eguíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => s_ + "eguiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => s_ + "eguisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => s_ + "eguisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => s_ + "eguisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => s_ + "eguíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => s_ + "eguísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => s_ + "eguissem" ; --# notpresent
    VPB (MQPerf Sg P1) => s_ + "eguira" ; --# notpresent
    VPB (MQPerf Sg P2) => s_ + "eguiras" ; --# notpresent
    VPB (MQPerf Sg P3) => s_ + "eguira" ; --# notpresent
    VPB (MQPerf Pl P1) => s_ + "eguíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => s_ + "eguíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => s_ + "eguiram" ; --# notpresent
    VPB (PretP Sg P1) => s_ + "egui" ; --# notpresent
    VPB (PretP Sg P2) => s_ + "eguiste" ; --# notpresent
    VPB (PretP Sg P3) => s_ + "eguiu" ; --# notpresent
    VPB (PretP Pl P1) => s_ + "eguimos" ; --# notpresent
    VPB (PretP Pl P2) => s_ + "eguistes" ; --# notpresent
    VPB (PretP Pl P3) => s_ + "eguiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => s_ + "eguirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => s_ + "eguirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => s_ + "eguirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => s_ + "eguiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => s_ + "eguireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => s_ + "eguirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => s_ + "eguir" ; --# notpresent
    VPB (Fut Sub Sg P2) => s_ + "eguires" ; --# notpresent
    VPB (Fut Sub Sg P3) => s_ + "eguir" ; --# notpresent
    VPB (Fut Sub Pl P1) => s_ + "eguirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => s_ + "eguirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => s_ + "eguirem" ; --# notpresent
    VPB (Cond Sg P1) => s_ + "eguiria" ; --# notpresent
    VPB (Cond Sg P2) => s_ + "eguirias" ; --# notpresent
    VPB (Cond Sg P3) => s_ + "eguiria" ; --# notpresent
    VPB (Cond Pl P1) => s_ + "eguiríamos" ; --# notpresent
    VPB (Cond Pl P2) => s_ + "eguiríeis" ; --# notpresent
    VPB (Cond Pl P3) => s_ + "eguiriam" ; --# notpresent
    VPB (Imper Sg P2) => s_ + "egue" ;
    VPB (Imper Sg P3) => s_ + "iga" ;
    VPB (Imper Pl P1) => s_ + "igamos" ;
    VPB (Imper Pl P2) => s_ + "egui" ;
    VPB (Imper Pl P3) => s_ + "igam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper sentir_Besch : Str -> Verbum = \sentir ->
-- 56 | r47
  let s_ = Predef.tk 5 sentir in
 {s = table {
    VI Infn => s_ + "entir" ;
    VI Ger => s_ + "entindo" ;
    VI Part => s_ + "entido" ;
    VPB (Pres Ind Sg P1) => s_ + "into" ;
    VPB (Pres Ind Sg P2) => s_ + "entes" ;
    VPB (Pres Ind Sg P3) => s_ + "ente" ;
    VPB (Pres Ind Pl P1) => s_ + "entimos" ;
    VPB (Pres Ind Pl P2) => s_ + "entis" ;
    VPB (Pres Ind Pl P3) => s_ + "entem" ;
    VPB (Pres Sub Sg P1) => s_ + "inta" ;
    VPB (Pres Sub Sg P2) => s_ + "intas" ;
    VPB (Pres Sub Sg P3) => s_ + "inta" ;
    VPB (Pres Sub Pl P1) => s_ + "intamos" ;
    VPB (Pres Sub Pl P2) => s_ + "intais" ;
    VPB (Pres Sub Pl P3) => s_ + "intam" ;
    VPB (PretI Ind Sg P1) => s_ + "entia" ; --# notpresent
    VPB (PretI Ind Sg P2) => s_ + "entias" ; --# notpresent
    VPB (PretI Ind Sg P3) => s_ + "entia" ; --# notpresent
    VPB (PretI Ind Pl P1) => s_ + "entíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => s_ + "entíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => s_ + "entiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => s_ + "entisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => s_ + "entisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => s_ + "entisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => s_ + "entíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => s_ + "entísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => s_ + "entissem" ; --# notpresent
    VPB (MQPerf Sg P1) => s_ + "entira" ; --# notpresent
    VPB (MQPerf Sg P2) => s_ + "entiras" ; --# notpresent
    VPB (MQPerf Sg P3) => s_ + "entira" ; --# notpresent
    VPB (MQPerf Pl P1) => s_ + "entíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => s_ + "entíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => s_ + "entiram" ; --# notpresent
    VPB (PretP Sg P1) => s_ + "enti" ; --# notpresent
    VPB (PretP Sg P2) => s_ + "entiste" ; --# notpresent
    VPB (PretP Sg P3) => s_ + "entiu" ; --# notpresent
    VPB (PretP Pl P1) => s_ + "entimos" ; --# notpresent
    VPB (PretP Pl P2) => s_ + "entistes" ; --# notpresent
    VPB (PretP Pl P3) => s_ + "entiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => s_ + "entirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => s_ + "entirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => s_ + "entirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => s_ + "entiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => s_ + "entireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => s_ + "entirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => s_ + "entir" ; --# notpresent
    VPB (Fut Sub Sg P2) => s_ + "entires" ; --# notpresent
    VPB (Fut Sub Sg P3) => s_ + "entir" ; --# notpresent
    VPB (Fut Sub Pl P1) => s_ + "entirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => s_ + "entirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => s_ + "entirem" ; --# notpresent
    VPB (Cond Sg P1) => s_ + "entiria" ; --# notpresent
    VPB (Cond Sg P2) => s_ + "entirias" ; --# notpresent
    VPB (Cond Sg P3) => s_ + "entiria" ; --# notpresent
    VPB (Cond Pl P1) => s_ + "entiríamos" ; --# notpresent
    VPB (Cond Pl P2) => s_ + "entiríeis" ; --# notpresent
    VPB (Cond Pl P3) => s_ + "entiriam" ; --# notpresent
    VPB (Imper Sg P2) => s_ + "ente" ;
    VPB (Imper Sg P3) => s_ + "inta" ;
    VPB (Imper Pl P1) => s_ + "intamos" ;
    VPB (Imper Pl P2) => s_ + "enti" ;
    VPB (Imper Pl P3) => s_ + "intam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper preferir_Besch : Str -> Verbum = \preferir ->
-- 57 | r47
  let pref_ = Predef.tk 4 preferir in
 {s = table {
    VI Infn => pref_ + "erir" ;
    VI Ger => pref_ + "erindo" ;
    VI Part => pref_ + "erido" ;
    VPB (Pres Ind Sg P1) => pref_ + "iro" ;
    VPB (Pres Ind Sg P2) => pref_ + "eres" ;
    VPB (Pres Ind Sg P3) => pref_ + "ere" ;
    VPB (Pres Ind Pl P1) => pref_ + "erimos" ;
    VPB (Pres Ind Pl P2) => pref_ + "eris" ;
    VPB (Pres Ind Pl P3) => pref_ + "erem" ;
    VPB (Pres Sub Sg P1) => pref_ + "ira" ;
    VPB (Pres Sub Sg P2) => pref_ + "iras" ;
    VPB (Pres Sub Sg P3) => pref_ + "ira" ;
    VPB (Pres Sub Pl P1) => pref_ + "iramos" ;
    VPB (Pres Sub Pl P2) => pref_ + "irais" ;
    VPB (Pres Sub Pl P3) => pref_ + "iram" ;
    VPB (PretI Ind Sg P1) => pref_ + "eria" ; --# notpresent
    VPB (PretI Ind Sg P2) => pref_ + "erias" ; --# notpresent
    VPB (PretI Ind Sg P3) => pref_ + "eria" ; --# notpresent
    VPB (PretI Ind Pl P1) => pref_ + "eríamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => pref_ + "eríeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => pref_ + "eriam" ; --# notpresent
    VPB (PretI Sub Sg P1) => pref_ + "erisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => pref_ + "erisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => pref_ + "erisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => pref_ + "eríssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => pref_ + "erísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => pref_ + "erissem" ; --# notpresent
    VPB (MQPerf Sg P1) => pref_ + "erira" ; --# notpresent
    VPB (MQPerf Sg P2) => pref_ + "eriras" ; --# notpresent
    VPB (MQPerf Sg P3) => pref_ + "erira" ; --# notpresent
    VPB (MQPerf Pl P1) => pref_ + "eríramos" ; --# notpresent
    VPB (MQPerf Pl P2) => pref_ + "eríreis" ; --# notpresent
    VPB (MQPerf Pl P3) => pref_ + "eriram" ; --# notpresent
    VPB (PretP Sg P1) => pref_ + "eri" ; --# notpresent
    VPB (PretP Sg P2) => pref_ + "eriste" ; --# notpresent
    VPB (PretP Sg P3) => pref_ + "eriu" ; --# notpresent
    VPB (PretP Pl P1) => pref_ + "erimos" ; --# notpresent
    VPB (PretP Pl P2) => pref_ + "eristes" ; --# notpresent
    VPB (PretP Pl P3) => pref_ + "eriram" ; --# notpresent
    VPB (Fut Ind Sg P1) => pref_ + "erirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => pref_ + "erirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => pref_ + "erirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => pref_ + "eriremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => pref_ + "erireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => pref_ + "erirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => pref_ + "erir" ; --# notpresent
    VPB (Fut Sub Sg P2) => pref_ + "erires" ; --# notpresent
    VPB (Fut Sub Sg P3) => pref_ + "erir" ; --# notpresent
    VPB (Fut Sub Pl P1) => pref_ + "erirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => pref_ + "erirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => pref_ + "erirem" ; --# notpresent
    VPB (Cond Sg P1) => pref_ + "eriria" ; --# notpresent
    VPB (Cond Sg P2) => pref_ + "eririas" ; --# notpresent
    VPB (Cond Sg P3) => pref_ + "eriria" ; --# notpresent
    VPB (Cond Pl P1) => pref_ + "eriríamos" ; --# notpresent
    VPB (Cond Pl P2) => pref_ + "eriríeis" ; --# notpresent
    VPB (Cond Pl P3) => pref_ + "eririam" ; --# notpresent
    VPB (Imper Sg P2) => pref_ + "ere" ;
    VPB (Imper Sg P3) => pref_ + "ira" ;
    VPB (Imper Pl P1) => pref_ + "iramos" ;
    VPB (Imper Pl P2) => pref_ + "eri" ;
    VPB (Imper Pl P3) => pref_ + "iram" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper agredir_Besch : Str -> Verbum = \agredir ->
-- 58 | r48
  let agr_ = Predef.tk 4 agredir in
 {s = table {
    VI Infn => agr_ + "edir" ;
    VI Ger => agr_ + "edindo" ;
    VI Part => agr_ + "edido" ;
    VPB (Pres Ind Sg P1) => agr_ + "ido" ;
    VPB (Pres Ind Sg P2) => agr_ + "ides" ;
    VPB (Pres Ind Sg P3) => agr_ + "ide" ;
    VPB (Pres Ind Pl P1) => agr_ + "edimos" ;
    VPB (Pres Ind Pl P2) => agr_ + "edis" ;
    VPB (Pres Ind Pl P3) => agr_ + "idem" ;
    VPB (Pres Sub Sg P1) => agr_ + "ida" ;
    VPB (Pres Sub Sg P2) => agr_ + "idas" ;
    VPB (Pres Sub Sg P3) => agr_ + "ida" ;
    VPB (Pres Sub Pl P1) => agr_ + "idamos" ;
    VPB (Pres Sub Pl P2) => agr_ + "idais" ;
    VPB (Pres Sub Pl P3) => agr_ + "idam" ;
    VPB (PretI Ind Sg P1) => agr_ + "edia" ; --# notpresent
    VPB (PretI Ind Sg P2) => agr_ + "edias" ; --# notpresent
    VPB (PretI Ind Sg P3) => agr_ + "edia" ; --# notpresent
    VPB (PretI Ind Pl P1) => agr_ + "edíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => agr_ + "edíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => agr_ + "ediam" ; --# notpresent
    VPB (PretI Sub Sg P1) => agr_ + "edisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => agr_ + "edisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => agr_ + "edisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => agr_ + "edíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => agr_ + "edísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => agr_ + "edissem" ; --# notpresent
    VPB (MQPerf Sg P1) => agr_ + "edira" ; --# notpresent
    VPB (MQPerf Sg P2) => agr_ + "ediras" ; --# notpresent
    VPB (MQPerf Sg P3) => agr_ + "edira" ; --# notpresent
    VPB (MQPerf Pl P1) => agr_ + "edíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => agr_ + "edíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => agr_ + "ediram" ; --# notpresent
    VPB (PretP Sg P1) => agr_ + "edi" ; --# notpresent
    VPB (PretP Sg P2) => agr_ + "ediste" ; --# notpresent
    VPB (PretP Sg P3) => agr_ + "ediu" ; --# notpresent
    VPB (PretP Pl P1) => agr_ + "edimos" ; --# notpresent
    VPB (PretP Pl P2) => agr_ + "edistes" ; --# notpresent
    VPB (PretP Pl P3) => agr_ + "ediram" ; --# notpresent
    VPB (Fut Ind Sg P1) => agr_ + "edirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => agr_ + "edirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => agr_ + "edirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => agr_ + "ediremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => agr_ + "edireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => agr_ + "edirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => agr_ + "edir" ; --# notpresent
    VPB (Fut Sub Sg P2) => agr_ + "edires" ; --# notpresent
    VPB (Fut Sub Sg P3) => agr_ + "edir" ; --# notpresent
    VPB (Fut Sub Pl P1) => agr_ + "edirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => agr_ + "edirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => agr_ + "edirem" ; --# notpresent
    VPB (Cond Sg P1) => agr_ + "ediria" ; --# notpresent
    VPB (Cond Sg P2) => agr_ + "edirias" ; --# notpresent
    VPB (Cond Sg P3) => agr_ + "ediria" ; --# notpresent
    VPB (Cond Pl P1) => agr_ + "ediríamos" ; --# notpresent
    VPB (Cond Pl P2) => agr_ + "ediríeis" ; --# notpresent
    VPB (Cond Pl P3) => agr_ + "ediriam" ; --# notpresent
    VPB (Imper Sg P2) => agr_ + "ide" ;
    VPB (Imper Sg P3) => agr_ + "ida" ;
    VPB (Imper Pl P1) => agr_ + "idamos" ;
    VPB (Imper Pl P2) => agr_ + "edi" ;
    VPB (Imper Pl P3) => agr_ + "idam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper dormir_Besch : Str -> Verbum = \dormir ->
-- 59 | r51
  let d_ = Predef.tk 5 dormir in
 {s = table {
    VI Infn => d_ + "ormir" ;
    VI Ger => d_ + "ormindo" ;
    VI Part => d_ + "ormido" ;
    VPB (Pres Ind Sg P1) => d_ + "urmo" ;
    VPB (Pres Ind Sg P2) => d_ + "ormes" ;
    VPB (Pres Ind Sg P3) => d_ + "orme" ;
    VPB (Pres Ind Pl P1) => d_ + "ormimos" ;
    VPB (Pres Ind Pl P2) => d_ + "ormis" ;
    VPB (Pres Ind Pl P3) => d_ + "ormem" ;
    VPB (Pres Sub Sg P1) => d_ + "urma" ;
    VPB (Pres Sub Sg P2) => d_ + "urmas" ;
    VPB (Pres Sub Sg P3) => d_ + "urma" ;
    VPB (Pres Sub Pl P1) => d_ + "urmamos" ;
    VPB (Pres Sub Pl P2) => d_ + "urmais" ;
    VPB (Pres Sub Pl P3) => d_ + "urmam" ;
    VPB (PretI Ind Sg P1) => d_ + "ormia" ; --# notpresent
    VPB (PretI Ind Sg P2) => d_ + "ormias" ; --# notpresent
    VPB (PretI Ind Sg P3) => d_ + "ormia" ; --# notpresent
    VPB (PretI Ind Pl P1) => d_ + "ormíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => d_ + "ormíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => d_ + "ormiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => d_ + "ormisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => d_ + "ormisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => d_ + "ormisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => d_ + "ormíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => d_ + "ormísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => d_ + "ormissem" ; --# notpresent
    VPB (MQPerf Sg P1) => d_ + "ormira" ; --# notpresent
    VPB (MQPerf Sg P2) => d_ + "ormiras" ; --# notpresent
    VPB (MQPerf Sg P3) => d_ + "ormira" ; --# notpresent
    VPB (MQPerf Pl P1) => d_ + "ormíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => d_ + "ormíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => d_ + "ormiram" ; --# notpresent
    VPB (PretP Sg P1) => d_ + "ormi" ; --# notpresent
    VPB (PretP Sg P2) => d_ + "ormiste" ; --# notpresent
    VPB (PretP Sg P3) => d_ + "ormiu" ; --# notpresent
    VPB (PretP Pl P1) => d_ + "ormimos" ; --# notpresent
    VPB (PretP Pl P2) => d_ + "ormistes" ; --# notpresent
    VPB (PretP Pl P3) => d_ + "ormiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => d_ + "ormirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => d_ + "ormirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => d_ + "ormirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => d_ + "ormiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => d_ + "ormireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => d_ + "ormirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => d_ + "ormir" ; --# notpresent
    VPB (Fut Sub Sg P2) => d_ + "ormires" ; --# notpresent
    VPB (Fut Sub Sg P3) => d_ + "ormir" ; --# notpresent
    VPB (Fut Sub Pl P1) => d_ + "ormirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => d_ + "ormirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => d_ + "ormirem" ; --# notpresent
    VPB (Cond Sg P1) => d_ + "ormiria" ; --# notpresent
    VPB (Cond Sg P2) => d_ + "ormirias" ; --# notpresent
    VPB (Cond Sg P3) => d_ + "ormiria" ; --# notpresent
    VPB (Cond Pl P1) => d_ + "ormiríamos" ; --# notpresent
    VPB (Cond Pl P2) => d_ + "ormiríeis" ; --# notpresent
    VPB (Cond Pl P3) => d_ + "ormiriam" ; --# notpresent
    VPB (Imper Sg P2) => d_ + "orme" ;
    VPB (Imper Sg P3) => d_ + "urma" ;
    VPB (Imper Pl P1) => d_ + "urmamos" ;
    VPB (Imper Pl P2) => d_ + "ormi" ;
    VPB (Imper Pl P3) => d_ + "urmam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper polir_Besch : Str -> Verbum = \polir ->
-- 60 | r81
  let p_ = Predef.tk 4 polir in
 {s = table {
    VI Infn => p_ + "olir" ;
    VI Ger => p_ + "olindo" ;
    VI Part => p_ + "olido" ;
    VPB (Pres Ind Sg P1) => p_ + "ulo" ;
    VPB (Pres Ind Sg P2) => p_ + "ules" ;
    VPB (Pres Ind Sg P3) => p_ + "ule" ;
    VPB (Pres Ind Pl P1) => p_ + "olimos" ;
    VPB (Pres Ind Pl P2) => p_ + "olis" ;
    VPB (Pres Ind Pl P3) => p_ + "ulem" ;
    VPB (Pres Sub Sg P1) => p_ + "ula" ;
    VPB (Pres Sub Sg P2) => p_ + "ulas" ;
    VPB (Pres Sub Sg P3) => p_ + "ula" ;
    VPB (Pres Sub Pl P1) => p_ + "ulamos" ;
    VPB (Pres Sub Pl P2) => p_ + "ulais" ;
    VPB (Pres Sub Pl P3) => p_ + "ulam" ;
    VPB (PretI Ind Sg P1) => p_ + "olia" ; --# notpresent
    VPB (PretI Ind Sg P2) => p_ + "olias" ; --# notpresent
    VPB (PretI Ind Sg P3) => p_ + "olia" ; --# notpresent
    VPB (PretI Ind Pl P1) => p_ + "olíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => p_ + "olíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => p_ + "oliam" ; --# notpresent
    VPB (PretI Sub Sg P1) => p_ + "olisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => p_ + "olisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => p_ + "olisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => p_ + "olíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => p_ + "olísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => p_ + "olissem" ; --# notpresent
    VPB (MQPerf Sg P1) => p_ + "olira" ; --# notpresent
    VPB (MQPerf Sg P2) => p_ + "oliras" ; --# notpresent
    VPB (MQPerf Sg P3) => p_ + "olira" ; --# notpresent
    VPB (MQPerf Pl P1) => p_ + "olíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => p_ + "olíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => p_ + "oliram" ; --# notpresent
    VPB (PretP Sg P1) => p_ + "oli" ; --# notpresent
    VPB (PretP Sg P2) => p_ + "oliste" ; --# notpresent
    VPB (PretP Sg P3) => p_ + "oliu" ; --# notpresent
    VPB (PretP Pl P1) => p_ + "olimos" ; --# notpresent
    VPB (PretP Pl P2) => p_ + "olistes" ; --# notpresent
    VPB (PretP Pl P3) => p_ + "oliram" ; --# notpresent
    VPB (Fut Ind Sg P1) => p_ + "olirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => p_ + "olirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => p_ + "olirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => p_ + "oliremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => p_ + "olireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => p_ + "olirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => p_ + "olir" ; --# notpresent
    VPB (Fut Sub Sg P2) => p_ + "olires" ; --# notpresent
    VPB (Fut Sub Sg P3) => p_ + "olir" ; --# notpresent
    VPB (Fut Sub Pl P1) => p_ + "olirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => p_ + "olirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => p_ + "olirem" ; --# notpresent
    VPB (Cond Sg P1) => p_ + "oliria" ; --# notpresent
    VPB (Cond Sg P2) => p_ + "olirias" ; --# notpresent
    VPB (Cond Sg P3) => p_ + "oliria" ; --# notpresent
    VPB (Cond Pl P1) => p_ + "oliríamos" ; --# notpresent
    VPB (Cond Pl P2) => p_ + "oliríeis" ; --# notpresent
    VPB (Cond Pl P3) => p_ + "oliriam" ; --# notpresent
    VPB (Imper Sg P2) => p_ + "ule" ;
    VPB (Imper Sg P3) => p_ + "ula" ;
    VPB (Imper Pl P1) => p_ + "ulamos" ;
    VPB (Imper Pl P2) => p_ + "oli" ;
    VPB (Imper Pl P3) => p_ + "ulam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper acudir_Besch : Str -> Verbum = \acudir ->
-- 61 | r53
  let ac_ = Predef.tk 4 acudir in
 {s = table {
    VI Infn => ac_ + "udir" ;
    VI Ger => ac_ + "udindo" ;
    VI Part => ac_ + "udido" ;
    VPB (Pres Ind Sg P1) => ac_ + "udo" ;
    VPB (Pres Ind Sg P2) => ac_ + "odes" ;
    VPB (Pres Ind Sg P3) => ac_ + "ode" ;
    VPB (Pres Ind Pl P1) => ac_ + "udimos" ;
    VPB (Pres Ind Pl P2) => ac_ + "udis" ;
    VPB (Pres Ind Pl P3) => ac_ + "odem" ;
    VPB (Pres Sub Sg P1) => ac_ + "uda" ;
    VPB (Pres Sub Sg P2) => ac_ + "udas" ;
    VPB (Pres Sub Sg P3) => ac_ + "uda" ;
    VPB (Pres Sub Pl P1) => ac_ + "udamos" ;
    VPB (Pres Sub Pl P2) => ac_ + "udais" ;
    VPB (Pres Sub Pl P3) => ac_ + "udam" ;
    VPB (PretI Ind Sg P1) => ac_ + "udia" ; --# notpresent
    VPB (PretI Ind Sg P2) => ac_ + "udias" ; --# notpresent
    VPB (PretI Ind Sg P3) => ac_ + "udia" ; --# notpresent
    VPB (PretI Ind Pl P1) => ac_ + "udíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => ac_ + "udíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => ac_ + "udiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => ac_ + "udisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => ac_ + "udisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => ac_ + "udisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => ac_ + "udíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => ac_ + "udísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => ac_ + "udissem" ; --# notpresent
    VPB (MQPerf Sg P1) => ac_ + "udira" ; --# notpresent
    VPB (MQPerf Sg P2) => ac_ + "udiras" ; --# notpresent
    VPB (MQPerf Sg P3) => ac_ + "udira" ; --# notpresent
    VPB (MQPerf Pl P1) => ac_ + "udíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => ac_ + "udíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => ac_ + "udiram" ; --# notpresent
    VPB (PretP Sg P1) => ac_ + "udi" ; --# notpresent
    VPB (PretP Sg P2) => ac_ + "udiste" ; --# notpresent
    VPB (PretP Sg P3) => ac_ + "udiu" ; --# notpresent
    VPB (PretP Pl P1) => ac_ + "udimos" ; --# notpresent
    VPB (PretP Pl P2) => ac_ + "udistes" ; --# notpresent
    VPB (PretP Pl P3) => ac_ + "udiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => ac_ + "udirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => ac_ + "udirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => ac_ + "udirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => ac_ + "udiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => ac_ + "udireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => ac_ + "udirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => ac_ + "udir" ; --# notpresent
    VPB (Fut Sub Sg P2) => ac_ + "udires" ; --# notpresent
    VPB (Fut Sub Sg P3) => ac_ + "udir" ; --# notpresent
    VPB (Fut Sub Pl P1) => ac_ + "udirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => ac_ + "udirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => ac_ + "udirem" ; --# notpresent
    VPB (Cond Sg P1) => ac_ + "udiria" ; --# notpresent
    VPB (Cond Sg P2) => ac_ + "udirias" ; --# notpresent
    VPB (Cond Sg P3) => ac_ + "udiria" ; --# notpresent
    VPB (Cond Pl P1) => ac_ + "udiríamos" ; --# notpresent
    VPB (Cond Pl P2) => ac_ + "udiríeis" ; --# notpresent
    VPB (Cond Pl P3) => ac_ + "udiriam" ; --# notpresent
    VPB (Imper Sg P2) => ac_ + "ode" ;
    VPB (Imper Sg P3) => ac_ + "uda" ;
    VPB (Imper Pl P1) => ac_ + "udamos" ;
    VPB (Imper Pl P2) => ac_ + "udi" ;
    VPB (Imper Pl P3) => ac_ + "udam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper fugir_Besch : Str -> Verbum = \fugir ->
-- 62 | r54
  let f_ = Predef.tk 4 fugir in
 {s = table {
    VI Infn => f_ + "ugir" ;
    VI Ger => f_ + "ugindo" ;
    VI Part => f_ + "ugido" ;
    VPB (Pres Ind Sg P1) => f_ + "ujo" ;
    VPB (Pres Ind Sg P2) => f_ + "oges" ;
    VPB (Pres Ind Sg P3) => f_ + "oge" ;
    VPB (Pres Ind Pl P1) => f_ + "ugimos" ;
    VPB (Pres Ind Pl P2) => f_ + "ugis" ;
    VPB (Pres Ind Pl P3) => f_ + "ogem" ;
    VPB (Pres Sub Sg P1) => f_ + "uja" ;
    VPB (Pres Sub Sg P2) => f_ + "ujas" ;
    VPB (Pres Sub Sg P3) => f_ + "uja" ;
    VPB (Pres Sub Pl P1) => f_ + "ujamos" ;
    VPB (Pres Sub Pl P2) => f_ + "ujais" ;
    VPB (Pres Sub Pl P3) => f_ + "ujam" ;
    VPB (PretI Ind Sg P1) => f_ + "ugia" ; --# notpresent
    VPB (PretI Ind Sg P2) => f_ + "ugias" ; --# notpresent
    VPB (PretI Ind Sg P3) => f_ + "ugia" ; --# notpresent
    VPB (PretI Ind Pl P1) => f_ + "ugíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => f_ + "ugíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => f_ + "ugiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => f_ + "ugisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => f_ + "ugisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => f_ + "ugisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => f_ + "ugíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => f_ + "ugísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => f_ + "ugissem" ; --# notpresent
    VPB (MQPerf Sg P1) => f_ + "ugira" ; --# notpresent
    VPB (MQPerf Sg P2) => f_ + "ugiras" ; --# notpresent
    VPB (MQPerf Sg P3) => f_ + "ugira" ; --# notpresent
    VPB (MQPerf Pl P1) => f_ + "ugíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => f_ + "ugíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => f_ + "ugiram" ; --# notpresent
    VPB (PretP Sg P1) => f_ + "ugi" ; --# notpresent
    VPB (PretP Sg P2) => f_ + "ugiste" ; --# notpresent
    VPB (PretP Sg P3) => f_ + "ugiu" ; --# notpresent
    VPB (PretP Pl P1) => f_ + "ugimos" ; --# notpresent
    VPB (PretP Pl P2) => f_ + "ugistes" ; --# notpresent
    VPB (PretP Pl P3) => f_ + "ugiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => f_ + "ugirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => f_ + "ugirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => f_ + "ugirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => f_ + "ugiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => f_ + "ugereis" ; --# notpresent
    VPB (Fut Ind Pl P3) => f_ + "ugirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => f_ + "ugir" ; --# notpresent
    VPB (Fut Sub Sg P2) => f_ + "ugires" ; --# notpresent
    VPB (Fut Sub Sg P3) => f_ + "ugir" ; --# notpresent
    VPB (Fut Sub Pl P1) => f_ + "ugirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => f_ + "ugirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => f_ + "ugirem" ; --# notpresent
    VPB (Cond Sg P1) => f_ + "ugiria" ; --# notpresent
    VPB (Cond Sg P2) => f_ + "ugirias" ; --# notpresent
    VPB (Cond Sg P3) => f_ + "ugiria" ; --# notpresent
    VPB (Cond Pl P1) => f_ + "ugiríamos" ; --# notpresent
    VPB (Cond Pl P2) => f_ + "ugiríeis" ; --# notpresent
    VPB (Cond Pl P3) => f_ + "ugiriam" ; --# notpresent
    VPB (Imper Sg P2) => f_ + "oge" ;
    VPB (Imper Sg P3) => f_ + "uja" ;
    VPB (Imper Pl P1) => f_ + "ujamos" ;
    VPB (Imper Pl P2) => f_ + "ugi" ;
    VPB (Imper Pl P3) => f_ + "ujam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper frigir_Besch : Str -> Verbum = \frigir ->
-- 63 | r28
  let fr_ = Predef.tk 4 frigir in
 {s = table {
    VI Infn => fr_ + "igir" ;
    VI Ger => fr_ + "igindo" ;
    VI Part => fr_ + "igido" ;
    VPB (Pres Ind Sg P1) => fr_ + "ijo" ;
    VPB (Pres Ind Sg P2) => fr_ + "eges" ;
    VPB (Pres Ind Sg P3) => fr_ + "ege" ;
    VPB (Pres Ind Pl P1) => fr_ + "igimos" ;
    VPB (Pres Ind Pl P2) => fr_ + "igis" ;
    VPB (Pres Ind Pl P3) => fr_ + "egem" ;
    VPB (Pres Sub Sg P1) => fr_ + "ija" ;
    VPB (Pres Sub Sg P2) => fr_ + "ijas" ;
    VPB (Pres Sub Sg P3) => fr_ + "ija" ;
    VPB (Pres Sub Pl P1) => fr_ + "ijamos" ;
    VPB (Pres Sub Pl P2) => fr_ + "ijais" ;
    VPB (Pres Sub Pl P3) => fr_ + "ijam" ;
    VPB (PretI Ind Sg P1) => fr_ + "igia" ; --# notpresent
    VPB (PretI Ind Sg P2) => fr_ + "igias" ; --# notpresent
    VPB (PretI Ind Sg P3) => fr_ + "igia" ; --# notpresent
    VPB (PretI Ind Pl P1) => fr_ + "igíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => fr_ + "igíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => fr_ + "igiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => fr_ + "igisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => fr_ + "igisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => fr_ + "igisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => fr_ + "igíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => fr_ + "igísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => fr_ + "igissem" ; --# notpresent
    VPB (MQPerf Sg P1) => fr_ + "igira" ; --# notpresent
    VPB (MQPerf Sg P2) => fr_ + "igiras" ; --# notpresent
    VPB (MQPerf Sg P3) => fr_ + "igira" ; --# notpresent
    VPB (MQPerf Pl P1) => fr_ + "igíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => fr_ + "igíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => fr_ + "igiram" ; --# notpresent
    VPB (PretP Sg P1) => fr_ + "igi" ; --# notpresent
    VPB (PretP Sg P2) => fr_ + "igiste" ; --# notpresent
    VPB (PretP Sg P3) => fr_ + "igiu" ; --# notpresent
    VPB (PretP Pl P1) => fr_ + "igimos" ; --# notpresent
    VPB (PretP Pl P2) => fr_ + "igistes" ; --# notpresent
    VPB (PretP Pl P3) => fr_ + "igiam" ; --# notpresent
    VPB (Fut Ind Sg P1) => fr_ + "igirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => fr_ + "igirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => fr_ + "igirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => fr_ + "igiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => fr_ + "igireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => fr_ + "igirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => fr_ + "igir" ; --# notpresent
    VPB (Fut Sub Sg P2) => fr_ + "igires" ; --# notpresent
    VPB (Fut Sub Sg P3) => fr_ + "igir" ; --# notpresent
    VPB (Fut Sub Pl P1) => fr_ + "igirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => fr_ + "igirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => fr_ + "igirem" ; --# notpresent
    VPB (Cond Sg P1) => fr_ + "igiria" ; --# notpresent
    VPB (Cond Sg P2) => fr_ + "igirias" ; --# notpresent
    VPB (Cond Sg P3) => fr_ + "igiria" ; --# notpresent
    VPB (Cond Pl P1) => fr_ + "igiríamos" ; --# notpresent
    VPB (Cond Pl P2) => fr_ + "igiríeis" ; --# notpresent
    VPB (Cond Pl P3) => fr_ + "igiriam" ; --# notpresent
    VPB (Imper Sg P2) => fr_ + "ege" ;
    VPB (Imper Sg P3) => fr_ + "ija" ;
    VPB (Imper Pl P1) => fr_ + "ijamos" ;
    VPB (Imper Pl P2) => fr_ + "igi" ;
    VPB (Imper Pl P3) => fr_ + "ijam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper divergir_Besch : Str -> Verbum = \divergir ->
-- 64 | r49
  let div_ = Predef.tk 5 divergir in
 {s = table {
    VI Infn => div_ + "ergir" ;
    VI Ger => div_ + "ergindo" ;
    VI Part => div_ + "ergido" ;
    VPB (Pres Ind Sg P1) => div_ + "irjo" ;
    VPB (Pres Ind Sg P2) => div_ + "erges" ;
    VPB (Pres Ind Sg P3) => div_ + "erge" ;
    VPB (Pres Ind Pl P1) => div_ + "ergimos" ;
    VPB (Pres Ind Pl P2) => div_ + "ergis" ;
    VPB (Pres Ind Pl P3) => div_ + "ergem" ;
    VPB (Pres Sub Sg P1) => div_ + "irja" ;
    VPB (Pres Sub Sg P2) => div_ + "irjas" ;
    VPB (Pres Sub Sg P3) => div_ + "irja" ;
    VPB (Pres Sub Pl P1) => div_ + "irjamos" ;
    VPB (Pres Sub Pl P2) => div_ + "irjais" ;
    VPB (Pres Sub Pl P3) => div_ + "irjam" ;
    VPB (PretI Ind Sg P1) => div_ + "ergia" ; --# notpresent
    VPB (PretI Ind Sg P2) => div_ + "ergias" ; --# notpresent
    VPB (PretI Ind Sg P3) => div_ + "ergia" ; --# notpresent
    VPB (PretI Ind Pl P1) => div_ + "ergíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => div_ + "ergíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => div_ + "ergiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => div_ + "ergisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => div_ + "ergisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => div_ + "ergisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => div_ + "ergíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => div_ + "ergísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => div_ + "ergissem" ; --# notpresent
    VPB (MQPerf Sg P1) => div_ + "ergira" ; --# notpresent
    VPB (MQPerf Sg P2) => div_ + "ergiras" ; --# notpresent
    VPB (MQPerf Sg P3) => div_ + "ergira" ; --# notpresent
    VPB (MQPerf Pl P1) => div_ + "ergíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => div_ + "ergíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => div_ + "ergiram" ; --# notpresent
    VPB (PretP Sg P1) => div_ + "ergi" ; --# notpresent
    VPB (PretP Sg P2) => div_ + "ergiste" ; --# notpresent
    VPB (PretP Sg P3) => div_ + "ergiu" ; --# notpresent
    VPB (PretP Pl P1) => div_ + "ergimos" ; --# notpresent
    VPB (PretP Pl P2) => div_ + "ergistes" ; --# notpresent
    VPB (PretP Pl P3) => div_ + "ergiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => div_ + "ergirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => div_ + "ergirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => div_ + "ergirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => div_ + "ergiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => div_ + "ergireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => div_ + "ergirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => div_ + "ergir" ; --# notpresent
    VPB (Fut Sub Sg P2) => div_ + "ergires" ; --# notpresent
    VPB (Fut Sub Sg P3) => div_ + "ergir" ; --# notpresent
    VPB (Fut Sub Pl P1) => div_ + "ergirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => div_ + "ergirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => div_ + "ergirem" ; --# notpresent
    VPB (Cond Sg P1) => div_ + "ergiria" ; --# notpresent
    VPB (Cond Sg P2) => div_ + "ergirias" ; --# notpresent
    VPB (Cond Sg P3) => div_ + "ergiria" ; --# notpresent
    VPB (Cond Pl P1) => div_ + "ergiríamos" ; --# notpresent
    VPB (Cond Pl P2) => div_ + "ergiríeis" ; --# notpresent
    VPB (Cond Pl P3) => div_ + "ergiriam" ; --# notpresent
    VPB (Imper Sg P2) => div_ + "erge" ;
    VPB (Imper Sg P3) => div_ + "irja" ;
    VPB (Imper Pl P1) => div_ + "irjamos" ;
    VPB (Imper Pl P2) => div_ + "ergi" ;
    VPB (Imper Pl P3) => div_ + "irjam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper refletir_Besch : Str -> Verbum = \refletir ->
-- 65 | r47
  let refl_ = Predef.tk 4 refletir in
 {s = table {
    VI Infn => refl_ + vars "etir" "ectir" ;
    VI Ger => refl_ + vars "etindo" "ectindo" ;
    VI Part => refl_ + vars "etido" "ectido" ;
    VPB (Pres Ind Sg P1) => refl_ + "ito" ;
    VPB (Pres Ind Sg P2) => refl_ + vars "etes" "ectes" ;
    VPB (Pres Ind Sg P3) => refl_ + vars "ete" "ecte" ;
    VPB (Pres Ind Pl P1) => refl_ + vars "etimos" "ectimos" ;
    VPB (Pres Ind Pl P2) => refl_ + vars "etis" "ectis" ;
    VPB (Pres Ind Pl P3) => refl_ + vars "etem" "ectem" ;
    VPB (Pres Sub Sg P1) => refl_ + "ita" ;
    VPB (Pres Sub Sg P2) => refl_ + "itas" ;
    VPB (Pres Sub Sg P3) => refl_ + "ita" ;
    VPB (Pres Sub Pl P1) => refl_ + "itamos" ;
    VPB (Pres Sub Pl P2) => refl_ + "itais" ;
    VPB (Pres Sub Pl P3) => refl_ + "itam" ;
    VPB (PretI Ind Sg P1) => refl_ + vars "etia" "ectia" ; --# notpresent
    VPB (PretI Ind Sg P2) => refl_ + vars "etias" "ectias" ; --# notpresent
    VPB (PretI Ind Sg P3) => refl_ + vars "etia" "ectia" ; --# notpresent
    VPB (PretI Ind Pl P1) => refl_ + vars "etíamos" "ectíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => refl_ + vars "etíeis" "ectíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => refl_ + vars "etiam" "ectiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => refl_ + vars "etisse" "ectisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => refl_ + vars "etisses" "ectisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => refl_ + vars "etisse" "ectisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => refl_ + vars "etíssemos" "ectíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => refl_ + vars "etísseis" "ectísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => refl_ + vars "etissem" "ectissem" ; --# notpresent
    VPB (MQPerf Sg P1) => refl_ + vars "etira" "ectira" ; --# notpresent
    VPB (MQPerf Sg P2) => refl_ + vars "etiras" "ectiras" ; --# notpresent
    VPB (MQPerf Sg P3) => refl_ + vars "etira" "ectira" ; --# notpresent
    VPB (MQPerf Pl P1) => refl_ + vars "etíramos" "ectíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => refl_ + vars "etíreis" "ectíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => refl_ + vars "etiram" "ectiram" ; --# notpresent
    VPB (PretP Sg P1) => refl_ + vars "eti" "ecti" ; --# notpresent
    VPB (PretP Sg P2) => refl_ + vars "etiste" "ectiste" ; --# notpresent
    VPB (PretP Sg P3) => refl_ + vars "etiu" "ectiu" ; --# notpresent
    VPB (PretP Pl P1) => refl_ + vars "etimos" "ectimos" ; --# notpresent
    VPB (PretP Pl P2) => refl_ + vars "etistes" "ectistes" ; --# notpresent
    VPB (PretP Pl P3) => refl_ + vars "etiram" "ectiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => refl_ + vars "etirei" "ectirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => refl_ + vars "etirás" "ectirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => refl_ + vars "etirá" "ectirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => refl_ + vars "etiremos" "ectiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => refl_ + vars "etireis" "ectireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => refl_ + vars "etirão" "ectirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => refl_ + vars "etir" "ectir" ; --# notpresent
    VPB (Fut Sub Sg P2) => refl_ + vars "etires" "ectires" ; --# notpresent
    VPB (Fut Sub Sg P3) => refl_ + vars "etir" "ectir" ; --# notpresent
    VPB (Fut Sub Pl P1) => refl_ + vars "etirmos" "ectirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => refl_ + vars "etirdes" "ectirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => refl_ + vars "etirem" "ectirem" ; --# notpresent
    VPB (Cond Sg P1) => refl_ + vars "etiria" "ectiria" ; --# notpresent
    VPB (Cond Sg P2) => refl_ + vars "etirias" "ectirias" ; --# notpresent
    VPB (Cond Sg P3) => refl_ + vars "etiria" "ectiria" ; --# notpresent
    VPB (Cond Pl P1) => refl_ + vars "etiríamos" "ectiríamos" ; --# notpresent
    VPB (Cond Pl P2) => refl_ + vars "etiríeis" "ectiríeis" ; --# notpresent
    VPB (Cond Pl P3) => refl_ + vars "etiriam" "ectiriam" ; --# notpresent
    VPB (Imper Sg P2) => refl_ + vars "ete" "ecte" ;
    VPB (Imper Sg P3) => refl_ + "ita" ;
    VPB (Imper Pl P1) => refl_ + "itamos" ;
    VPB (Imper Pl P2) => refl_ + vars "eti" "ecti" ;
    VPB (Imper Pl P3) => refl_ + "itram" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper ir_Besch : Str -> Verbum = \ir ->
-- 66 | r53
  let x_ = Predef.tk 2 ir in
 {s = table {
    VI Infn => x_ + "ir" ;
    VI Ger => x_ + "indo" ;
    VI Part => x_ + "ido" ;
    VPB (Pres Ind Sg P1) => x_ + "vou" ;
    VPB (Pres Ind Sg P2) => x_ + "vais" ;
    VPB (Pres Ind Sg P3) => x_ + "vai" ;
    VPB (Pres Ind Pl P1) => x_ + vars "vamos" "imos" ;
    VPB (Pres Ind Pl P2) => x_ + vars "ides" "vades" ;
    VPB (Pres Ind Pl P3) => x_ + "vão" ;
    VPB (Pres Sub Sg P1) => x_ + "vá" ;
    VPB (Pres Sub Sg P2) => x_ + "vás" ;
    VPB (Pres Sub Sg P3) => x_ + "vá" ;
    VPB (Pres Sub Pl P1) => x_ + "vamos" ;
    VPB (Pres Sub Pl P2) => x_ + "vades" ;
    VPB (Pres Sub Pl P3) => x_ + "vão" ;
    VPB (PretI Ind Sg P1) => x_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => x_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => x_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => x_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => x_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => x_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => x_ + "fosse" ; --# notpresent
    VPB (PretI Sub Sg P2) => x_ + "fosses" ; --# notpresent
    VPB (PretI Sub Sg P3) => x_ + "fosse" ; --# notpresent
    VPB (PretI Sub Pl P1) => x_ + "fôssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => x_ + "fôsseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => x_ + "fossem" ; --# notpresent
    VPB (MQPerf Sg P1) => x_ + "foram" ; --# notpresent
    VPB (MQPerf Sg P2) => x_ + "foras" ; --# notpresent
    VPB (MQPerf Sg P3) => x_ + "fora" ; --# notpresent
    VPB (MQPerf Pl P1) => x_ + "fôramos" ; --# notpresent
    VPB (MQPerf Pl P2) => x_ + "fôreis" ; --# notpresent
    VPB (MQPerf Pl P3) => x_ + "foram" ; --# notpresent
    VPB (PretP Sg P1) => x_ + "fui" ; --# notpresent
    VPB (PretP Sg P2) => x_ + "foste" ; --# notpresent
    VPB (PretP Sg P3) => x_ + "foi" ; --# notpresent
    VPB (PretP Pl P1) => x_ + "fomos" ; --# notpresent
    VPB (PretP Pl P2) => x_ + "fostes" ; --# notpresent
    VPB (PretP Pl P3) => x_ + "foram" ; --# notpresent
    VPB (Fut Ind Sg P1) => x_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => x_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => x_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => x_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => x_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => x_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => x_ + "for" ; --# notpresent
    VPB (Fut Sub Sg P2) => x_ + "fores" ; --# notpresent
    VPB (Fut Sub Sg P3) => x_ + "for" ; --# notpresent
    VPB (Fut Sub Pl P1) => x_ + "formos" ; --# notpresent
    VPB (Fut Sub Pl P2) => x_ + "fordes" ; --# notpresent
    VPB (Fut Sub Pl P3) => x_ + "forem" ; --# notpresent
    VPB (Cond Sg P1) => x_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => x_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => x_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => x_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => x_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => x_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => x_ + "vai" ;
    VPB (Imper Sg P3) => x_ + "vá" ;
    VPB (Imper Pl P1) => x_ + "vamos" ;
    VPB (Imper Pl P2) => x_ + "ide" ;
    VPB (Imper Pl P3) => x_ + "vão" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper vir_Besch : Str -> Verbum = \vir ->
-- 67 | r63
  let v_ = Predef.tk 2 vir in
 {s = table {
    VI Infn => v_ + "ir" ;
    VI Ger => v_ + "indo" ;
    VI Part => v_ + "indo" ;
    VPB (Pres Ind Sg P1) => v_ + "enho" ;
    VPB (Pres Ind Sg P2) => v_ + "ens" ;
    VPB (Pres Ind Sg P3) => v_ + "em" ;
    VPB (Pres Ind Pl P1) => v_ + "imos" ;
    VPB (Pres Ind Pl P2) => v_ + "indes" ;
    VPB (Pres Ind Pl P3) => v_ + "êm" ;
    VPB (Pres Sub Sg P1) => v_ + "enha" ;
    VPB (Pres Sub Sg P2) => v_ + "enhas" ;
    VPB (Pres Sub Sg P3) => v_ + "enha" ;
    VPB (Pres Sub Pl P1) => v_ + "enhamos" ;
    VPB (Pres Sub Pl P2) => v_ + "enhais" ;
    VPB (Pres Sub Pl P3) => v_ + "enham" ;
    VPB (PretI Ind Sg P1) => v_ + "inha" ; --# notpresent
    VPB (PretI Ind Sg P2) => v_ + "inhas" ; --# notpresent
    VPB (PretI Ind Sg P3) => v_ + "inha" ; --# notpresent
    VPB (PretI Ind Pl P1) => v_ + "ínhamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => v_ + "ínheis" ; --# notpresent
    VPB (PretI Ind Pl P3) => v_ + "inham" ; --# notpresent
    VPB (PretI Sub Sg P1) => v_ + "iesse" ; --# notpresent
    VPB (PretI Sub Sg P2) => v_ + "iesses" ; --# notpresent
    VPB (PretI Sub Sg P3) => v_ + "iesse" ; --# notpresent
    VPB (PretI Sub Pl P1) => v_ + "iéssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => v_ + "iésseos" ; --# notpresent
    VPB (PretI Sub Pl P3) => v_ + "iessem" ; --# notpresent
    VPB (MQPerf Sg P1) => v_ + "iera" ; --# notpresent
    VPB (MQPerf Sg P2) => v_ + "ieras" ; --# notpresent
    VPB (MQPerf Sg P3) => v_ + "iera" ; --# notpresent
    VPB (MQPerf Pl P1) => v_ + "iéramos" ; --# notpresent
    VPB (MQPerf Pl P2) => v_ + "iéreis" ; --# notpresent
    VPB (MQPerf Pl P3) => v_ + "ieram" ; --# notpresent
    VPB (PretP Sg P1) => v_ + "im" ; --# notpresent
    VPB (PretP Sg P2) => v_ + "ieste" ; --# notpresent
    VPB (PretP Sg P3) => v_ + "eio" ; --# notpresent
    VPB (PretP Pl P1) => v_ + "iemos" ; --# notpresent
    VPB (PretP Pl P2) => v_ + "iestes" ; --# notpresent
    VPB (PretP Pl P3) => v_ + "ieram" ; --# notpresent
    VPB (Fut Ind Sg P1) => v_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => v_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => v_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => v_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => v_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => v_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => v_ + "ier" ; --# notpresent
    VPB (Fut Sub Sg P2) => v_ + "ieres" ; --# notpresent
    VPB (Fut Sub Sg P3) => v_ + "ier" ; --# notpresent
    VPB (Fut Sub Pl P1) => v_ + "iermos" ; --# notpresent
    VPB (Fut Sub Pl P2) => v_ + "ierdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => v_ + "ierem" ; --# notpresent
    VPB (Cond Sg P1) => v_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => v_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => v_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => v_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => v_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => v_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => v_ + "em" ;
    VPB (Imper Sg P3) => v_ + "enha" ;
    VPB (Imper Pl P1) => v_ + "enhamos" ;
    VPB (Imper Pl P2) => v_ + "inde" ;
    VPB (Imper Pl P3) => v_ + "enham" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper sair_Besch : Str -> Verbum = \sair ->
-- 68 | r42
  let sa_ = Predef.tk 2 sair in
 {s = table {
    VI Infn => sa_ + "ir" ;
    VI Ger => sa_ + "indo" ;
    VI Part => sa_ + "ído" ;
    VPB (Pres Ind Sg P1) => sa_ + "io" ;
    VPB (Pres Ind Sg P2) => sa_ + "is" ;
    VPB (Pres Ind Sg P3) => sa_ + "i" ;
    VPB (Pres Ind Pl P1) => sa_ + "ímos" ;
    VPB (Pres Ind Pl P2) => sa_ + "ís" ;
    VPB (Pres Ind Pl P3) => sa_ + "em" ;
    VPB (Pres Sub Sg P1) => sa_ + "ia" ;
    VPB (Pres Sub Sg P2) => sa_ + "ias" ;
    VPB (Pres Sub Sg P3) => sa_ + "ia" ;
    VPB (Pres Sub Pl P1) => sa_ + "iamos" ;
    VPB (Pres Sub Pl P2) => sa_ + "iais" ;
    VPB (Pres Sub Pl P3) => sa_ + "iam" ;
    VPB (PretI Ind Sg P1) => sa_ + "ía" ; --# notpresent
    VPB (PretI Ind Sg P2) => sa_ + "ías" ; --# notpresent
    VPB (PretI Ind Sg P3) => sa_ + "ía" ; --# notpresent
    VPB (PretI Ind Pl P1) => sa_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => sa_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => sa_ + "íam" ; --# notpresent
    VPB (PretI Sub Sg P1) => sa_ + "ísse" ; --# notpresent
    VPB (PretI Sub Sg P2) => sa_ + "ísses" ; --# notpresent
    VPB (PretI Sub Sg P3) => sa_ + "ísse" ; --# notpresent
    VPB (PretI Sub Pl P1) => sa_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => sa_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => sa_ + "íssem" ; --# notpresent
    VPB (MQPerf Sg P1) => sa_ + "íra" ; --# notpresent
    VPB (MQPerf Sg P2) => sa_ + "íras" ; --# notpresent
    VPB (MQPerf Sg P3) => sa_ + "íra" ; --# notpresent
    VPB (MQPerf Pl P1) => sa_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => sa_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => sa_ + "íram" ; --# notpresent
    VPB (PretP Sg P1) => sa_ + "í" ; --# notpresent
    VPB (PretP Sg P2) => sa_ + "íste" ; --# notpresent
    VPB (PretP Sg P3) => sa_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => sa_ + "ímos" ; --# notpresent
    VPB (PretP Pl P2) => sa_ + "ístes" ; --# notpresent
    VPB (PretP Pl P3) => sa_ + "íram" ; --# notpresent
    VPB (Fut Ind Sg P1) => sa_ + "irirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => sa_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => sa_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => sa_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => sa_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => sa_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => sa_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => sa_ + "íres" ; --# notpresent
    VPB (Fut Sub Sg P3) => sa_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => sa_ + "írmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => sa_ + "irdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => sa_ + nonExist ; --# notpresent
    VPB (Cond Sg P1) => sa_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => sa_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => sa_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => sa_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => sa_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => sa_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => sa_ + "i" ;
    VPB (Imper Sg P3) => sa_ + "ia" ;
    VPB (Imper Pl P1) => sa_ + "iamos" ;
    VPB (Imper Pl P2) => sa_ + "i" ;
    VPB (Imper Pl P3) => sa_ + "iam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper rir_Besch : Str -> Verbum = \rir ->
-- 69 | r48
  let r_ = Predef.tk 2 rir in
 {s = table {
    VI Infn => r_ + "ir" ;
    VI Ger => r_ + "indo" ;
    VI Part => r_ + "ido" ;
    VPB (Pres Ind Sg P1) => r_ + "io" ;
    VPB (Pres Ind Sg P2) => r_ + "is" ;
    VPB (Pres Ind Sg P3) => r_ + "i" ;
    VPB (Pres Ind Pl P1) => r_ + "imos" ;
    VPB (Pres Ind Pl P2) => r_ + "ides" ;
    VPB (Pres Ind Pl P3) => r_ + "iem" ;
    VPB (Pres Sub Sg P1) => r_ + "ia" ;
    VPB (Pres Sub Sg P2) => r_ + "ias" ;
    VPB (Pres Sub Sg P3) => r_ + "ia" ;
    VPB (Pres Sub Pl P1) => r_ + "iamos" ;
    VPB (Pres Sub Pl P2) => r_ + "iais" ;
    VPB (Pres Sub Pl P3) => r_ + "iam" ;
    VPB (PretI Ind Sg P1) => r_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => r_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => r_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => r_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => r_ + "ieis" ; --# notpresent
    VPB (PretI Ind Pl P3) => r_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => r_ + "isse" ; --# notpresent
    VPB (PretI Sub Sg P2) => r_ + "isses" ; --# notpresent
    VPB (PretI Sub Sg P3) => r_ + "isse" ; --# notpresent
    VPB (PretI Sub Pl P1) => r_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => r_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => r_ + "issem" ; --# notpresent
    VPB (MQPerf Sg P1) => r_ + "ira" ; --# notpresent
    VPB (MQPerf Sg P2) => r_ + "iras" ; --# notpresent
    VPB (MQPerf Sg P3) => r_ + "ira" ; --# notpresent
    VPB (MQPerf Pl P1) => r_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => r_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => r_ + "iram" ; --# notpresent
    VPB (PretP Sg P1) => r_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => r_ + "iste" ; --# notpresent
    VPB (PretP Sg P3) => r_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => r_ + "imos" ; --# notpresent
    VPB (PretP Pl P2) => r_ + "istes" ; --# notpresent
    VPB (PretP Pl P3) => r_ + "iram" ; --# notpresent
    VPB (Fut Ind Sg P1) => r_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => r_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => r_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => r_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => r_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => r_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => r_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => r_ + "ires" ; --# notpresent
    VPB (Fut Sub Sg P3) => r_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => r_ + "irmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => r_ + "irdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => r_ + "irem" ; --# notpresent
    VPB (Cond Sg P1) => r_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => r_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => r_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => r_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => r_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => r_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => r_ + "i" ;
    VPB (Imper Sg P3) => r_ + "ia" ;
    VPB (Imper Pl P1) => r_ + "íamos" ;
    VPB (Imper Pl P2) => r_ + "ide" ;
    VPB (Imper Pl P3) => r_ + "iam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper pedir_Besch : Str -> Verbum = \pedir ->
-- 70 | r63
  let pe_ = Predef.tk 3 pedir in
 {s = table {
    VI Infn => pe_ + "dir" ;
    VI Ger => pe_ + "dindo" ;
    VI Part => pe_ + "dido" ;
    VPB (Pres Ind Sg P1) => pe_ + "ço" ;
    VPB (Pres Ind Sg P2) => pe_ + "des" ;
    VPB (Pres Ind Sg P3) => pe_ + "de" ;
    VPB (Pres Ind Pl P1) => pe_ + "dimos" ;
    VPB (Pres Ind Pl P2) => pe_ + "dis" ;
    VPB (Pres Ind Pl P3) => pe_ + "dem" ;
    VPB (Pres Sub Sg P1) => pe_ + "ça" ;
    VPB (Pres Sub Sg P2) => pe_ + "ças" ;
    VPB (Pres Sub Sg P3) => pe_ + "ça" ;
    VPB (Pres Sub Pl P1) => pe_ + "çamos" ;
    VPB (Pres Sub Pl P2) => pe_ + "çais" ;
    VPB (Pres Sub Pl P3) => pe_ + "çam" ;
    VPB (PretI Ind Sg P1) => pe_ + "dia" ; --# notpresent
    VPB (PretI Ind Sg P2) => pe_ + "dias" ; --# notpresent
    VPB (PretI Ind Sg P3) => pe_ + "dia" ; --# notpresent
    VPB (PretI Ind Pl P1) => pe_ + "díamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => pe_ + "díeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => pe_ + "diam" ; --# notpresent
    VPB (PretI Sub Sg P1) => pe_ + "disse" ; --# notpresent
    VPB (PretI Sub Sg P2) => pe_ + "disses" ; --# notpresent
    VPB (PretI Sub Sg P3) => pe_ + "disse" ; --# notpresent
    VPB (PretI Sub Pl P1) => pe_ + "díssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => pe_ + "dísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => pe_ + "dissem" ; --# notpresent
    VPB (MQPerf Sg P1) => pe_ + "dira" ; --# notpresent
    VPB (MQPerf Sg P2) => pe_ + "diras" ; --# notpresent
    VPB (MQPerf Sg P3) => pe_ + "dira" ; --# notpresent
    VPB (MQPerf Pl P1) => pe_ + "díramos" ; --# notpresent
    VPB (MQPerf Pl P2) => pe_ + "díreis" ; --# notpresent
    VPB (MQPerf Pl P3) => pe_ + "diram" ; --# notpresent
    VPB (PretP Sg P1) => pe_ + "di" ; --# notpresent
    VPB (PretP Sg P2) => pe_ + "diste" ; --# notpresent
    VPB (PretP Sg P3) => pe_ + "diu" ; --# notpresent
    VPB (PretP Pl P1) => pe_ + "dimos" ; --# notpresent
    VPB (PretP Pl P2) => pe_ + "distes" ; --# notpresent
    VPB (PretP Pl P3) => pe_ + "diram" ; --# notpresent
    VPB (Fut Ind Sg P1) => pe_ + "direi" ; --# notpresent
    VPB (Fut Ind Sg P2) => pe_ + "dirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => pe_ + "dirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => pe_ + "diremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => pe_ + "direis" ; --# notpresent
    VPB (Fut Ind Pl P3) => pe_ + "dirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => pe_ + "dir" ; --# notpresent
    VPB (Fut Sub Sg P2) => pe_ + "dires" ; --# notpresent
    VPB (Fut Sub Sg P3) => pe_ + "dir" ; --# notpresent
    VPB (Fut Sub Pl P1) => pe_ + "dirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => pe_ + "dirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => pe_ + "direm" ; --# notpresent
    VPB (Cond Sg P1) => pe_ + "diria" ; --# notpresent
    VPB (Cond Sg P2) => pe_ + "dirias" ; --# notpresent
    VPB (Cond Sg P3) => pe_ + "diria" ; --# notpresent
    VPB (Cond Pl P1) => pe_ + "diríamos" ; --# notpresent
    VPB (Cond Pl P2) => pe_ + "diríeis" ; --# notpresent
    VPB (Cond Pl P3) => pe_ + "diriam" ; --# notpresent
    VPB (Imper Sg P2) => pe_ + "de" ;
    VPB (Imper Sg P3) => pe_ + "ça" ;
    VPB (Imper Pl P1) => pe_ + "çamos" ;
    VPB (Imper Pl P2) => pe_ + "di" ;
    VPB (Imper Pl P3) => pe_ + "çam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper ouvir_Besch : Str -> Verbum = \ouvir ->
-- 71 | r63
  let ou_ = Predef.tk 3 ouvir in
 {s = table {
    VI Infn => ou_ + "vir" ;
    VI Ger => ou_ + "vindo" ;
    VI Part => ou_ + "vido" ;
    VPB (Pres Ind Sg P1) => ou_ + "ço" ;
    VPB (Pres Ind Sg P2) => ou_ + "ves" ;
    VPB (Pres Ind Sg P3) => ou_ + "ve" ;
    VPB (Pres Ind Pl P1) => ou_ + "vimos" ;
    VPB (Pres Ind Pl P2) => ou_ + "vis" ;
    VPB (Pres Ind Pl P3) => ou_ + "vem" ;
    VPB (Pres Sub Sg P1) => ou_ + "ça" ;
    VPB (Pres Sub Sg P2) => ou_ + "ças" ;
    VPB (Pres Sub Sg P3) => ou_ + "ça" ;
    VPB (Pres Sub Pl P1) => ou_ + "çamos" ;
    VPB (Pres Sub Pl P2) => ou_ + "çais" ;
    VPB (Pres Sub Pl P3) => ou_ + "çam" ;
    VPB (PretI Ind Sg P1) => ou_ + "via" ; --# notpresent
    VPB (PretI Ind Sg P2) => ou_ + "vias" ; --# notpresent
    VPB (PretI Ind Sg P3) => ou_ + "via" ; --# notpresent
    VPB (PretI Ind Pl P1) => ou_ + "víamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => ou_ + "víeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => ou_ + "viam" ; --# notpresent
    VPB (PretI Sub Sg P1) => ou_ + "visse" ; --# notpresent
    VPB (PretI Sub Sg P2) => ou_ + "visses" ; --# notpresent
    VPB (PretI Sub Sg P3) => ou_ + "visse" ; --# notpresent
    VPB (PretI Sub Pl P1) => ou_ + "víssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => ou_ + "vísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => ou_ + "vissem" ; --# notpresent
    VPB (MQPerf Sg P1) => ou_ + "vira" ; --# notpresent
    VPB (MQPerf Sg P2) => ou_ + "viras" ; --# notpresent
    VPB (MQPerf Sg P3) => ou_ + "vira" ; --# notpresent
    VPB (MQPerf Pl P1) => ou_ + "viríamos" ; --# notpresent
    VPB (MQPerf Pl P2) => ou_ + "viríeis" ; --# notpresent
    VPB (MQPerf Pl P3) => ou_ + "viram" ; --# notpresent
    VPB (PretP Sg P1) => ou_ + "vi" ; --# notpresent
    VPB (PretP Sg P2) => ou_ + "viste" ; --# notpresent
    VPB (PretP Sg P3) => ou_ + "viu" ; --# notpresent
    VPB (PretP Pl P1) => ou_ + "vimos" ; --# notpresent
    VPB (PretP Pl P2) => ou_ + "vistes" ; --# notpresent
    VPB (PretP Pl P3) => ou_ + "viram" ; --# notpresent
    VPB (Fut Ind Sg P1) => ou_ + "virei" ; --# notpresent
    VPB (Fut Ind Sg P2) => ou_ + "virás" ; --# notpresent
    VPB (Fut Ind Sg P3) => ou_ + "virá" ; --# notpresent
    VPB (Fut Ind Pl P1) => ou_ + "viremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => ou_ + "vireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => ou_ + "virão" ; --# notpresent
    VPB (Fut Sub Sg P1) => ou_ + "vir" ; --# notpresent
    VPB (Fut Sub Sg P2) => ou_ + "vires" ; --# notpresent
    VPB (Fut Sub Sg P3) => ou_ + "vir" ; --# notpresent
    VPB (Fut Sub Pl P1) => ou_ + "virmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => ou_ + "virdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => ou_ + "virem" ; --# notpresent
    VPB (Cond Sg P1) => ou_ + "viria" ; --# notpresent
    VPB (Cond Sg P2) => ou_ + "virias" ; --# notpresent
    VPB (Cond Sg P3) => ou_ + "viria" ; --# notpresent
    VPB (Cond Pl P1) => ou_ + "viríamos" ; --# notpresent
    VPB (Cond Pl P2) => ou_ + "viríeis" ; --# notpresent
    VPB (Cond Pl P3) => ou_ + "viriam" ; --# notpresent
    VPB (Imper Sg P2) => ou_ + "ve" ;
    VPB (Imper Sg P3) => ou_ + "ça" ;
    VPB (Imper Pl P1) => ou_ + "çamos" ;
    VPB (Imper Pl P2) => ou_ + "vi" ;
    VPB (Imper Pl P3) => ou_ + "çam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper traduzir_Besch : Str -> Verbum = \traduzir ->
-- 72 | r44
  let traduz_ = Predef.tk 2 traduzir in
 {s = table {
    VI Infn => traduz_ + "ir" ;
    VI Ger => traduz_ + "indo" ;
    VI Part => traduz_ + "ido" ;
    VPB (Pres Ind Sg P1) => traduz_ + "o" ;
    VPB (Pres Ind Sg P2) => traduz_ + "es" ;
    VPB (Pres Ind Sg P3) => traduz_ + "" ;
    VPB (Pres Ind Pl P1) => traduz_ + "imos" ;
    VPB (Pres Ind Pl P2) => traduz_ + "is" ;
    VPB (Pres Ind Pl P3) => traduz_ + "em" ;
    VPB (Pres Sub Sg P1) => traduz_ + "a" ;
    VPB (Pres Sub Sg P2) => traduz_ + "as" ;
    VPB (Pres Sub Sg P3) => traduz_ + "a" ;
    VPB (Pres Sub Pl P1) => traduz_ + "amos" ;
    VPB (Pres Sub Pl P2) => traduz_ + "ais" ;
    VPB (Pres Sub Pl P3) => traduz_ + "am" ;
    VPB (PretI Ind Sg P1) => traduz_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => traduz_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => traduz_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => traduz_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => traduz_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => traduz_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => traduz_ + "isse" ; --# notpresent
    VPB (PretI Sub Sg P2) => traduz_ + "isses" ; --# notpresent
    VPB (PretI Sub Sg P3) => traduz_ + "isse" ; --# notpresent
    VPB (PretI Sub Pl P1) => traduz_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => traduz_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => traduz_ + "issem" ; --# notpresent
    VPB (MQPerf Sg P1) => traduz_ + "ira" ; --# notpresent
    VPB (MQPerf Sg P2) => traduz_ + "iras" ; --# notpresent
    VPB (MQPerf Sg P3) => traduz_ + "ira" ; --# notpresent
    VPB (MQPerf Pl P1) => traduz_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => traduz_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => traduz_ + "iram" ; --# notpresent
    VPB (PretP Sg P1) => traduz_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => traduz_ + "iste" ; --# notpresent
    VPB (PretP Sg P3) => traduz_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => traduz_ + "imos" ; --# notpresent
    VPB (PretP Pl P2) => traduz_ + "istes" ; --# notpresent
    VPB (PretP Pl P3) => traduz_ + "iram" ; --# notpresent
    VPB (Fut Ind Sg P1) => traduz_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => traduz_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => traduz_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => traduz_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => traduz_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => traduz_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => traduz_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => traduz_ + "ires" ; --# notpresent
    VPB (Fut Sub Sg P3) => traduz_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => traduz_ + "irmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => traduz_ + "irdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => traduz_ + "irem" ; --# notpresent
    VPB (Cond Sg P1) => traduz_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => traduz_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => traduz_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => traduz_ + "íriamos" ; --# notpresent
    VPB (Cond Pl P2) => traduz_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => traduz_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => traduz_ + vars "" "e" ;
    VPB (Imper Sg P3) => traduz_ + "a" ;
    VPB (Imper Pl P1) => traduz_ + "amos" ;
    VPB (Imper Pl P2) => traduz_ + "i" ;
    VPB (Imper Pl P3) => traduz_ + "am" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper distribuir_Besch : Str -> Verbum = \distribuir ->
-- 73 | r40
  let distribu_ = Predef.tk 2 distribuir in
 {s = table {
    VI Infn => distribu_ + "ir" ;
    VI Ger => distribu_ + "indo" ;
    VI Part => distribu_ + "ído" ;
    VPB (Pres Ind Sg P1) => distribu_ + "o" ;
    VPB (Pres Ind Sg P2) => distribu_ + "is" ;
    VPB (Pres Ind Sg P3) => distribu_ + "i" ;
    VPB (Pres Ind Pl P1) => distribu_ + "ímos" ;
    VPB (Pres Ind Pl P2) => distribu_ + "ís" ;
    VPB (Pres Ind Pl P3) => distribu_ + "em" ;
    VPB (Pres Sub Sg P1) => distribu_ + "a" ;
    VPB (Pres Sub Sg P2) => distribu_ + "as" ;
    VPB (Pres Sub Sg P3) => distribu_ + "a" ;
    VPB (Pres Sub Pl P1) => distribu_ + "amos" ;
    VPB (Pres Sub Pl P2) => distribu_ + "ais" ;
    VPB (Pres Sub Pl P3) => distribu_ + "am" ;
    VPB (PretI Ind Sg P1) => distribu_ + "ía" ; --# notpresent
    VPB (PretI Ind Sg P2) => distribu_ + "ías" ; --# notpresent
    VPB (PretI Ind Sg P3) => distribu_ + "ía" ; --# notpresent
    VPB (PretI Ind Pl P1) => distribu_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => distribu_ + "íais" ; --# notpresent
    VPB (PretI Ind Pl P3) => distribu_ + "íam" ; --# notpresent
    VPB (PretI Sub Sg P1) => distribu_ + "ísse" ; --# notpresent
    VPB (PretI Sub Sg P2) => distribu_ + "ísses" ; --# notpresent
    VPB (PretI Sub Sg P3) => distribu_ + "ísse" ; --# notpresent
    VPB (PretI Sub Pl P1) => distribu_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => distribu_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => distribu_ + "íssem" ; --# notpresent
    VPB (MQPerf Sg P1) => distribu_ + "íra" ; --# notpresent
    VPB (MQPerf Sg P2) => distribu_ + "íras" ; --# notpresent
    VPB (MQPerf Sg P3) => distribu_ + "íra" ; --# notpresent
    VPB (MQPerf Pl P1) => distribu_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => distribu_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => distribu_ + "íram" ; --# notpresent
    VPB (PretP Sg P1) => distribu_ + "í" ; --# notpresent
    VPB (PretP Sg P2) => distribu_ + "íste" ; --# notpresent
    VPB (PretP Sg P3) => distribu_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => distribu_ + "ímos" ; --# notpresent
    VPB (PretP Pl P2) => distribu_ + "istes" ; --# notpresent
    VPB (PretP Pl P3) => distribu_ + "iram" ; --# notpresent
    VPB (Fut Ind Sg P1) => distribu_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => distribu_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => distribu_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => distribu_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => distribu_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => distribu_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => distribu_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => distribu_ + "íres" ; --# notpresent
    VPB (Fut Sub Sg P3) => distribu_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => distribu_ + "irmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => distribu_ + "irdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => distribu_ + "irem" ; --# notpresent
    VPB (Cond Sg P1) => distribu_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => distribu_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => distribu_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => distribu_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => distribu_ + "irieis" ; --# notpresent
    VPB (Cond Pl P3) => distribu_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => distribu_ + "i" ;
    VPB (Imper Sg P3) => distribu_ + "a" ;
    VPB (Imper Pl P1) => distribu_ + "amos" ;
    VPB (Imper Pl P2) => distribu_ + "í" ;
    VPB (Imper Pl P3) => distribu_ + "am" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper destruir_Besch : Str -> Verbum = \destruir ->
-- 74 | r57
  let destr_ = Predef.tk 3 destruir in
 {s = table {
    VI Infn => destr_ + "uir" ;
    VI Ger => destr_ + "uindo" ;
    VI Part => destr_ + "uído" ;
    VPB (Pres Ind Sg P1) => destr_ + "uo" ;
    VPB (Pres Ind Sg P2) => destr_ + vars "óis" "uis" ;
    VPB (Pres Ind Sg P3) => destr_ + vars "ói" "ui" ;
    VPB (Pres Ind Pl P1) => destr_ + "uímos" ;
    VPB (Pres Ind Pl P2) => destr_ + "uís" ;
    VPB (Pres Ind Pl P3) => destr_ + vars "oem" "uem" ;
    VPB (Pres Sub Sg P1) => destr_ + "ua" ;
    VPB (Pres Sub Sg P2) => destr_ + "uas" ;
    VPB (Pres Sub Sg P3) => destr_ + "ua" ;
    VPB (Pres Sub Pl P1) => destr_ + "uamos" ;
    VPB (Pres Sub Pl P2) => destr_ + "uais" ;
    VPB (Pres Sub Pl P3) => destr_ + "uam" ;
    VPB (PretI Ind Sg P1) => destr_ + "uía" ; --# notpresent
    VPB (PretI Ind Sg P2) => destr_ + "uías" ; --# notpresent
    VPB (PretI Ind Sg P3) => destr_ + "uía" ; --# notpresent
    VPB (PretI Ind Pl P1) => destr_ + "uíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => destr_ + "uíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => destr_ + "uíam" ; --# notpresent
    VPB (PretI Sub Sg P1) => destr_ + "uísse" ; --# notpresent
    VPB (PretI Sub Sg P2) => destr_ + "uísses" ; --# notpresent
    VPB (PretI Sub Sg P3) => destr_ + "uísse" ; --# notpresent
    VPB (PretI Sub Pl P1) => destr_ + "uíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => destr_ + "uísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => destr_ + "uíssem" ; --# notpresent
    VPB (MQPerf Sg P1) => destr_ + "uíra" ; --# notpresent
    VPB (MQPerf Sg P2) => destr_ + "uíras" ; --# notpresent
    VPB (MQPerf Sg P3) => destr_ + "uíra" ; --# notpresent
    VPB (MQPerf Pl P1) => destr_ + "uíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => destr_ + "uíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => destr_ + "uíram" ; --# notpresent
    VPB (PretP Sg P1) => destr_ + "uí" ; --# notpresent
    VPB (PretP Sg P2) => destr_ + "uíste" ; --# notpresent
    VPB (PretP Sg P3) => destr_ + "uiu" ; --# notpresent
    VPB (PretP Pl P1) => destr_ + "uímos" ; --# notpresent
    VPB (PretP Pl P2) => destr_ + "uístes" ; --# notpresent
    VPB (PretP Pl P3) => destr_ + "uíram" ; --# notpresent
    VPB (Fut Ind Sg P1) => destr_ + "uirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => destr_ + "uirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => destr_ + "uirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => destr_ + "uiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => destr_ + "uireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => destr_ + "uirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => destr_ + "uir" ; --# notpresent
    VPB (Fut Sub Sg P2) => destr_ + "uíres" ; --# notpresent
    VPB (Fut Sub Sg P3) => destr_ + "uir" ; --# notpresent
    VPB (Fut Sub Pl P1) => destr_ + "uírmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => destr_ + "uírdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => destr_ + "uírem" ; --# notpresent
    VPB (Cond Sg P1) => destr_ + "uiria" ; --# notpresent
    VPB (Cond Sg P2) => destr_ + "uirias" ; --# notpresent
    VPB (Cond Sg P3) => destr_ + "uiria" ; --# notpresent
    VPB (Cond Pl P1) => destr_ + "uiríamos" ; --# notpresent
    VPB (Cond Pl P2) => destr_ + "uiríeis" ; --# notpresent
    VPB (Cond Pl P3) => destr_ + "uiriam" ; --# notpresent
    VPB (Imper Sg P2) => destr_ + vars "ói" "ui" ;
    VPB (Imper Sg P3) => destr_ + "ua" ;
    VPB (Imper Pl P1) => destr_ + "uamos" ;
    VPB (Imper Pl P2) => destr_ + "ui" ;
    VPB (Imper Pl P3) => destr_ + "uam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper arguir_Besch : Str -> Verbum = \arguir ->
-- 75 | r31
  let arg_ = Predef.tk 3 arguir in
 {s = table {
    VI Infn => arg_ + "uir" ;
    VI Ger => arg_ + "uindo" ;
    VI Part => arg_ + "uido" ;
    VPB (Pres Ind Sg P1) => arg_ + "uo" ;
    VPB (Pres Ind Sg P2) => arg_ + "úis" ;
    VPB (Pres Ind Sg P3) => arg_ + "úi" ;
    VPB (Pres Ind Pl P1) => arg_ + "uimos" ;
    VPB (Pres Ind Pl P2) => arg_ + "uis" ;
    VPB (Pres Ind Pl P3) => arg_ + "úem" ;
    VPB (Pres Sub Sg P1) => arg_ + "ua" ;
    VPB (Pres Sub Sg P2) => arg_ + "uas" ;
    VPB (Pres Sub Sg P3) => arg_ + "ua" ;
    VPB (Pres Sub Pl P1) => arg_ + "uamos" ;
    VPB (Pres Sub Pl P2) => arg_ + "uais" ;
    VPB (Pres Sub Pl P3) => arg_ + "uam" ;
    VPB (PretI Ind Sg P1) => arg_ + "uia" ; --# notpresent
    VPB (PretI Ind Sg P2) => arg_ + "uias" ; --# notpresent
    VPB (PretI Ind Sg P3) => arg_ + "uia" ; --# notpresent
    VPB (PretI Ind Pl P1) => arg_ + "uíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => arg_ + "uíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => arg_ + "uiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => arg_ + "uísse" ; --# notpresent
    VPB (PretI Sub Sg P2) => arg_ + "uísses" ; --# notpresent
    VPB (PretI Sub Sg P3) => arg_ + "uísse" ; --# notpresent
    VPB (PretI Sub Pl P1) => arg_ + "uíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => arg_ + "uísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => arg_ + "uíssem" ; --# notpresent
    VPB (MQPerf Sg P1) => arg_ + "uíra" ; --# notpresent
    VPB (MQPerf Sg P2) => arg_ + "uíras" ; --# notpresent
    VPB (MQPerf Sg P3) => arg_ + "uíra" ; --# notpresent
    VPB (MQPerf Pl P1) => arg_ + "uíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => arg_ + "uíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => arg_ + "uíram" ; --# notpresent
    VPB (PretP Sg P1) => arg_ + "uí" ; --# notpresent
    VPB (PretP Sg P2) => arg_ + "uiste" ; --# notpresent
    VPB (PretP Sg P3) => arg_ + "uiu" ; --# notpresent
    VPB (PretP Pl P1) => arg_ + "uímos" ; --# notpresent
    VPB (PretP Pl P2) => arg_ + "uístes" ; --# notpresent
    VPB (PretP Pl P3) => arg_ + "uíram" ; --# notpresent
    VPB (Fut Ind Sg P1) => arg_ + "uirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => arg_ + "uirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => arg_ + "uirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => arg_ + "uiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => arg_ + "uireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => arg_ + "uirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => arg_ + "uir" ; --# notpresent
    VPB (Fut Sub Sg P2) => arg_ + "uíres" ; --# notpresent
    VPB (Fut Sub Sg P3) => arg_ + "uir" ; --# notpresent
    VPB (Fut Sub Pl P1) => arg_ + "uirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => arg_ + "uirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => arg_ + "uirem" ; --# notpresent
    VPB (Cond Sg P1) => arg_ + "uiria" ; --# notpresent
    VPB (Cond Sg P2) => arg_ + "uirias" ; --# notpresent
    VPB (Cond Sg P3) => arg_ + "uiria" ; --# notpresent
    VPB (Cond Pl P1) => arg_ + "uiríamos" ; --# notpresent
    VPB (Cond Pl P2) => arg_ + "uiríeis" ; --# notpresent
    VPB (Cond Pl P3) => arg_ + "uiriam" ; --# notpresent
    VPB (Imper Sg P2) => arg_ + "úi" ;
    VPB (Imper Sg P3) => arg_ + "ua" ;
    VPB (Imper Pl P1) => arg_ + "uamos" ;
    VPB (Imper Pl P2) => arg_ + "ui" ;
    VPB (Imper Pl P3) => arg_ + "uam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper reunir_Besch : Str -> Verbum = \reunir ->
-- 76 | r18
  let re_ = Predef.tk 4 reunir in
 {s = table {
    VI Infn => re_ + "unir" ;
    VI Ger => re_ + "unindo" ;
    VI Part => re_ + "unido" ;
    VPB (Pres Ind Sg P1) => re_ + "úno" ;
    VPB (Pres Ind Sg P2) => re_ + "únes" ;
    VPB (Pres Ind Sg P3) => re_ + "úne" ;
    VPB (Pres Ind Pl P1) => re_ + "unimos" ;
    VPB (Pres Ind Pl P2) => re_ + "unis" ;
    VPB (Pres Ind Pl P3) => re_ + "únem" ;
    VPB (Pres Sub Sg P1) => re_ + "úna" ;
    VPB (Pres Sub Sg P2) => re_ + "únas" ;
    VPB (Pres Sub Sg P3) => re_ + "úna" ;
    VPB (Pres Sub Pl P1) => re_ + "unamos" ;
    VPB (Pres Sub Pl P2) => re_ + "unais" ;
    VPB (Pres Sub Pl P3) => re_ + "únam" ;
    VPB (PretI Ind Sg P1) => re_ + "unia" ; --# notpresent
    VPB (PretI Ind Sg P2) => re_ + "unias" ; --# notpresent
    VPB (PretI Ind Sg P3) => re_ + "unia" ; --# notpresent
    VPB (PretI Ind Pl P1) => re_ + "uníamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => re_ + "uníeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => re_ + "uniam" ; --# notpresent
    VPB (PretI Sub Sg P1) => re_ + "unisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => re_ + "unisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => re_ + "unisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => re_ + "uníssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => re_ + "unísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => re_ + "unissem" ; --# notpresent
    VPB (MQPerf Sg P1) => re_ + "unira" ; --# notpresent
    VPB (MQPerf Sg P2) => re_ + "uniras" ; --# notpresent
    VPB (MQPerf Sg P3) => re_ + "unira" ; --# notpresent
    VPB (MQPerf Pl P1) => re_ + "uníramos" ; --# notpresent
    VPB (MQPerf Pl P2) => re_ + "uníreis" ; --# notpresent
    VPB (MQPerf Pl P3) => re_ + "uniram" ; --# notpresent
    VPB (PretP Sg P1) => re_ + "uni" ; --# notpresent
    VPB (PretP Sg P2) => re_ + "uniste" ; --# notpresent
    VPB (PretP Sg P3) => re_ + "uniu" ; --# notpresent
    VPB (PretP Pl P1) => re_ + "unimos" ; --# notpresent
    VPB (PretP Pl P2) => re_ + "unistes" ; --# notpresent
    VPB (PretP Pl P3) => re_ + "uniram" ; --# notpresent
    VPB (Fut Ind Sg P1) => re_ + "unirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => re_ + "unirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => re_ + "unirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => re_ + "uniremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => re_ + "unireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => re_ + "unirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => re_ + "unir" ; --# notpresent
    VPB (Fut Sub Sg P2) => re_ + "unires" ; --# notpresent
    VPB (Fut Sub Sg P3) => re_ + "unir" ; --# notpresent
    VPB (Fut Sub Pl P1) => re_ + "unirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => re_ + "unirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => re_ + "unirem" ; --# notpresent
    VPB (Cond Sg P1) => re_ + "uniria" ; --# notpresent
    VPB (Cond Sg P2) => re_ + "unirias" ; --# notpresent
    VPB (Cond Sg P3) => re_ + "uniria" ; --# notpresent
    VPB (Cond Pl P1) => re_ + "uniríamos" ; --# notpresent
    VPB (Cond Pl P2) => re_ + "uniríeis" ; --# notpresent
    VPB (Cond Pl P3) => re_ + "uniriam" ; --# notpresent
    VPB (Imper Sg P2) => re_ + "úne" ;
    VPB (Imper Sg P3) => re_ + "úna" ;
    VPB (Imper Pl P1) => re_ + "unamos" ;
    VPB (Imper Pl P2) => re_ + "uni" ;
    VPB (Imper Pl P3) => re_ + "únam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper proibir_Besch : Str -> Verbum = \proibir ->
-- 77 | r20
  let pro_ = Predef.tk 4 proibir in
 {s = table {
    VI Infn => pro_ + "ibir" ;
    VI Ger => pro_ + "ibindo" ;
    VI Part => pro_ + "ibido" ;
    VPB (Pres Ind Sg P1) => pro_ + "íbo" ;
    VPB (Pres Ind Sg P2) => pro_ + "íbes" ;
    VPB (Pres Ind Sg P3) => pro_ + "íbe" ;
    VPB (Pres Ind Pl P1) => pro_ + "ibimos" ;
    VPB (Pres Ind Pl P2) => pro_ + "ibis" ;
    VPB (Pres Ind Pl P3) => pro_ + "íbem" ;
    VPB (Pres Sub Sg P1) => pro_ + "íba" ;
    VPB (Pres Sub Sg P2) => pro_ + "íbas" ;
    VPB (Pres Sub Sg P3) => pro_ + "íba" ;
    VPB (Pres Sub Pl P1) => pro_ + "ibamos" ;
    VPB (Pres Sub Pl P2) => pro_ + "ibais" ;
    VPB (Pres Sub Pl P3) => pro_ + "íbam" ;
    VPB (PretI Ind Sg P1) => pro_ + "ibia" ; --# notpresent
    VPB (PretI Ind Sg P2) => pro_ + "ibias" ; --# notpresent
    VPB (PretI Ind Sg P3) => pro_ + "ibia" ; --# notpresent
    VPB (PretI Ind Pl P1) => pro_ + "ibíamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => pro_ + "ibíeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => pro_ + "ibiam" ; --# notpresent
    VPB (PretI Sub Sg P1) => pro_ + "ibisse" ; --# notpresent
    VPB (PretI Sub Sg P2) => pro_ + "ibisses" ; --# notpresent
    VPB (PretI Sub Sg P3) => pro_ + "ibisse" ; --# notpresent
    VPB (PretI Sub Pl P1) => pro_ + "ibíssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => pro_ + "ibísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => pro_ + "ibíssem" ; --# notpresent
    VPB (MQPerf Sg P1) => pro_ + "ibira" ; --# notpresent
    VPB (MQPerf Sg P2) => pro_ + "ibiras" ; --# notpresent
    VPB (MQPerf Sg P3) => pro_ + "ibira" ; --# notpresent
    VPB (MQPerf Pl P1) => pro_ + "ibíramos" ; --# notpresent
    VPB (MQPerf Pl P2) => pro_ + "ibíreis" ; --# notpresent
    VPB (MQPerf Pl P3) => pro_ + "ibiram" ; --# notpresent
    VPB (PretP Sg P1) => pro_ + "ibi" ; --# notpresent
    VPB (PretP Sg P2) => pro_ + "ibiste" ; --# notpresent
    VPB (PretP Sg P3) => pro_ + "ibiu" ; --# notpresent
    VPB (PretP Pl P1) => pro_ + "ibimos" ; --# notpresent
    VPB (PretP Pl P2) => pro_ + "ibistes" ; --# notpresent
    VPB (PretP Pl P3) => pro_ + "ibiram" ; --# notpresent
    VPB (Fut Ind Sg P1) => pro_ + "ibirei" ; --# notpresent
    VPB (Fut Ind Sg P2) => pro_ + "ibirás" ; --# notpresent
    VPB (Fut Ind Sg P3) => pro_ + "ibirá" ; --# notpresent
    VPB (Fut Ind Pl P1) => pro_ + "ibiremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => pro_ + "ibireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => pro_ + "ibirão" ; --# notpresent
    VPB (Fut Sub Sg P1) => pro_ + "ibir" ; --# notpresent
    VPB (Fut Sub Sg P2) => pro_ + "ibires" ; --# notpresent
    VPB (Fut Sub Sg P3) => pro_ + "ibir" ; --# notpresent
    VPB (Fut Sub Pl P1) => pro_ + "ibirmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => pro_ + "ibirdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => pro_ + "ibirem" ; --# notpresent
    VPB (Cond Sg P1) => pro_ + "ibiria" ; --# notpresent
    VPB (Cond Sg P2) => pro_ + "ibirias" ; --# notpresent
    VPB (Cond Sg P3) => pro_ + "ibiria" ; --# notpresent
    VPB (Cond Pl P1) => pro_ + "ibiríamos" ; --# notpresent
    VPB (Cond Pl P2) => pro_ + "ibiríeis" ; --# notpresent
    VPB (Cond Pl P3) => pro_ + "ibiriam" ; --# notpresent
    VPB (Imper Sg P2) => pro_ + "íbe" ;
    VPB (Imper Sg P3) => pro_ + "íba" ;
    VPB (Imper Pl P1) => pro_ + "ibamos" ;
    VPB (Imper Pl P2) => pro_ + "ibi" ;
    VPB (Imper Pl P3) => pro_ + "íbam" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper imergir_Besch : Str -> Verbum = \imergir ->
-- 78 | r49
  let imerg_ = Predef.tk 2 imergir in
 {s = table {
    VI Infn => imerg_ + "ir" ;
    VI Ger => imerg_ + "indo" ;
    VI Part => imerg_ + "ido" ;
    VPB (Pres Ind Sg P1) => imerg_ + nonExist ;
    VPB (Pres Ind Sg P2) => imerg_ + "es" ;
    VPB (Pres Ind Sg P3) => imerg_ + "e" ;
    VPB (Pres Ind Pl P1) => imerg_ + "imos" ;
    VPB (Pres Ind Pl P2) => imerg_ + "is" ;
    VPB (Pres Ind Pl P3) => imerg_ + "em" ;
    VPB (Pres Sub Sg P1) => imerg_ + nonExist ;
    VPB (Pres Sub Sg P2) => imerg_ + nonExist ;
    VPB (Pres Sub Sg P3) => imerg_ + nonExist ;
    VPB (Pres Sub Pl P1) => imerg_ + nonExist ;
    VPB (Pres Sub Pl P2) => imerg_ + nonExist ;
    VPB (Pres Sub Pl P3) => imerg_ + nonExist ;
    VPB (PretI Ind Sg P1) => imerg_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => imerg_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => imerg_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => imerg_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => imerg_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => imerg_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => imerg_ + "isse" ; --# notpresent
    VPB (PretI Sub Sg P2) => imerg_ + "isses" ; --# notpresent
    VPB (PretI Sub Sg P3) => imerg_ + "isse" ; --# notpresent
    VPB (PretI Sub Pl P1) => imerg_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => imerg_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => imerg_ + "íssem" ; --# notpresent
    VPB (MQPerf Sg P1) => imerg_ + "ira" ; --# notpresent
    VPB (MQPerf Sg P2) => imerg_ + "iras" ; --# notpresent
    VPB (MQPerf Sg P3) => imerg_ + "ira" ; --# notpresent
    VPB (MQPerf Pl P1) => imerg_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => imerg_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => imerg_ + "iram" ; --# notpresent
    VPB (PretP Sg P1) => imerg_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => imerg_ + "iste" ; --# notpresent
    VPB (PretP Sg P3) => imerg_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => imerg_ + "imos" ; --# notpresent
    VPB (PretP Pl P2) => imerg_ + "istes" ; --# notpresent
    VPB (PretP Pl P3) => imerg_ + "iram" ; --# notpresent
    VPB (Fut Ind Sg P1) => imerg_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => imerg_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => imerg_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => imerg_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => imerg_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => imerg_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => imerg_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => imerg_ + "ires" ; --# notpresent
    VPB (Fut Sub Sg P3) => imerg_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => imerg_ + "írmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => imerg_ + "írdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => imerg_ + "irem" ; --# notpresent
    VPB (Cond Sg P1) => imerg_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => imerg_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => imerg_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => imerg_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => imerg_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => imerg_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => imerg_ + "e" ;
    VPB (Imper Sg P3) => imerg_ + nonExist ;
    VPB (Imper Pl P1) => imerg_ + nonExist ;
    VPB (Imper Pl P2) => imerg_ + "i" ;
    VPB (Imper Pl P3) => imerg_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper falir_Besch : Str -> Verbum = \falir ->
-- 79 | r81
  let fal_ = Predef.tk 2 falir in
 {s = table {
    VI Infn => fal_ + "ir" ;
    VI Ger => fal_ + "indo" ;
    VI Part => fal_ + "ido" ;
    VPB (Pres Ind Sg P1) => fal_ + nonExist ;
    VPB (Pres Ind Sg P2) => fal_ + nonExist ;
    VPB (Pres Ind Sg P3) => fal_ + nonExist ;
    VPB (Pres Ind Pl P1) => fal_ + "imos" ;
    VPB (Pres Ind Pl P2) => fal_ + "is" ;
    VPB (Pres Ind Pl P3) => fal_ + nonExist ;
    VPB (Pres Sub Sg P1) => fal_ + nonExist ;
    VPB (Pres Sub Sg P2) => fal_ + nonExist ;
    VPB (Pres Sub Sg P3) => fal_ + nonExist ;
    VPB (Pres Sub Pl P1) => fal_ + nonExist ;
    VPB (Pres Sub Pl P2) => fal_ + nonExist ;
    VPB (Pres Sub Pl P3) => fal_ + nonExist ;
    VPB (PretI Ind Sg P1) => fal_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => fal_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => fal_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => fal_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => fal_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => fal_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => fal_ + "isse" ; --# notpresent
    VPB (PretI Sub Sg P2) => fal_ + "isses" ; --# notpresent
    VPB (PretI Sub Sg P3) => fal_ + "isse" ; --# notpresent
    VPB (PretI Sub Pl P1) => fal_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => fal_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => fal_ + "issem" ; --# notpresent
    VPB (MQPerf Sg P1) => fal_ + "ira" ; --# notpresent
    VPB (MQPerf Sg P2) => fal_ + "iras" ; --# notpresent
    VPB (MQPerf Sg P3) => fal_ + "ira" ; --# notpresent
    VPB (MQPerf Pl P1) => fal_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => fal_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => fal_ + "iram" ; --# notpresent
    VPB (PretP Sg P1) => fal_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => fal_ + "iste" ; --# notpresent
    VPB (PretP Sg P3) => fal_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => fal_ + "imos" ; --# notpresent
    VPB (PretP Pl P2) => fal_ + "istes" ; --# notpresent
    VPB (PretP Pl P3) => fal_ + "iram" ; --# notpresent
    VPB (Fut Ind Sg P1) => fal_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => fal_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => fal_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => fal_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => fal_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => fal_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => fal_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => fal_ + "ires" ; --# notpresent
    VPB (Fut Sub Sg P3) => fal_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => fal_ + "irmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => fal_ + "irdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => fal_ + "irem" ; --# notpresent
    VPB (Cond Sg P1) => fal_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => fal_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => fal_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => fal_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => fal_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => fal_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => fal_ + nonExist ;
    VPB (Imper Sg P3) => fal_ + nonExist ;
    VPB (Imper Pl P1) => fal_ + nonExist ;
    VPB (Imper Pl P2) => fal_ + "i" ;
    VPB (Imper Pl P3) => fal_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper remir_Besch : Str -> Verbum = \remir ->
-- 80 | r49
  let rem_ = Predef.tk 2 remir in
 {s = table {
    VI Infn => rem_ + "ir" ;
    VI Ger => rem_ + "indo" ;
    VI Part => rem_ + "ido" ;
    VPB (Pres Ind Sg P1) => rem_ + nonExist ;
    VPB (Pres Ind Sg P2) => rem_ + nonExist ;
    VPB (Pres Ind Sg P3) => rem_ + nonExist ;
    VPB (Pres Ind Pl P1) => rem_ + "imos" ;
    VPB (Pres Ind Pl P2) => rem_ + "is" ;
    VPB (Pres Ind Pl P3) => rem_ + nonExist ;
    VPB (Pres Sub Sg P1) => rem_ + nonExist ;
    VPB (Pres Sub Sg P2) => rem_ + nonExist ;
    VPB (Pres Sub Sg P3) => rem_ + nonExist ;
    VPB (Pres Sub Pl P1) => rem_ + nonExist ;
    VPB (Pres Sub Pl P2) => rem_ + nonExist ;
    VPB (Pres Sub Pl P3) => rem_ + nonExist ;
    VPB (PretI Ind Sg P1) => rem_ + "ia" ; --# notpresent
    VPB (PretI Ind Sg P2) => rem_ + "ias" ; --# notpresent
    VPB (PretI Ind Sg P3) => rem_ + "ia" ; --# notpresent
    VPB (PretI Ind Pl P1) => rem_ + "íamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => rem_ + "íeis" ; --# notpresent
    VPB (PretI Ind Pl P3) => rem_ + "iam" ; --# notpresent
    VPB (PretI Sub Sg P1) => rem_ + "isse" ; --# notpresent
    VPB (PretI Sub Sg P2) => rem_ + "isses" ; --# notpresent
    VPB (PretI Sub Sg P3) => rem_ + "isse" ; --# notpresent
    VPB (PretI Sub Pl P1) => rem_ + "íssemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => rem_ + "ísseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => rem_ + "issem" ; --# notpresent
    VPB (MQPerf Sg P1) => rem_ + "ira" ; --# notpresent
    VPB (MQPerf Sg P2) => rem_ + "iras" ; --# notpresent
    VPB (MQPerf Sg P3) => rem_ + "ira" ; --# notpresent
    VPB (MQPerf Pl P1) => rem_ + "íramos" ; --# notpresent
    VPB (MQPerf Pl P2) => rem_ + "íreis" ; --# notpresent
    VPB (MQPerf Pl P3) => rem_ + "iram" ; --# notpresent
    VPB (PretP Sg P1) => rem_ + "i" ; --# notpresent
    VPB (PretP Sg P2) => rem_ + "iste" ; --# notpresent
    VPB (PretP Sg P3) => rem_ + "iu" ; --# notpresent
    VPB (PretP Pl P1) => rem_ + "imos" ; --# notpresent
    VPB (PretP Pl P2) => rem_ + "istes" ; --# notpresent
    VPB (PretP Pl P3) => rem_ + "iram" ; --# notpresent
    VPB (Fut Ind Sg P1) => rem_ + "irei" ; --# notpresent
    VPB (Fut Ind Sg P2) => rem_ + "irás" ; --# notpresent
    VPB (Fut Ind Sg P3) => rem_ + "irá" ; --# notpresent
    VPB (Fut Ind Pl P1) => rem_ + "iremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => rem_ + "ireis" ; --# notpresent
    VPB (Fut Ind Pl P3) => rem_ + "irão" ; --# notpresent
    VPB (Fut Sub Sg P1) => rem_ + "ir" ; --# notpresent
    VPB (Fut Sub Sg P2) => rem_ + "ires" ; --# notpresent
    VPB (Fut Sub Sg P3) => rem_ + "ir" ; --# notpresent
    VPB (Fut Sub Pl P1) => rem_ + "irmos" ; --# notpresent
    VPB (Fut Sub Pl P2) => rem_ + "irdes" ; --# notpresent
    VPB (Fut Sub Pl P3) => rem_ + "irem" ; --# notpresent
    VPB (Cond Sg P1) => rem_ + "iria" ; --# notpresent
    VPB (Cond Sg P2) => rem_ + "irias" ; --# notpresent
    VPB (Cond Sg P3) => rem_ + "iria" ; --# notpresent
    VPB (Cond Pl P1) => rem_ + "iríamos" ; --# notpresent
    VPB (Cond Pl P2) => rem_ + "iríeis" ; --# notpresent
    VPB (Cond Pl P3) => rem_ + "iriam" ; --# notpresent
    VPB (Imper Sg P2) => rem_ + nonExist ;
    VPB (Imper Sg P3) => rem_ + nonExist ;
    VPB (Imper Pl P1) => rem_ + nonExist ;
    VPB (Imper Pl P2) => rem_ + "i" ;
    VPB (Imper Pl P3) => rem_ + nonExist ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper viajar_Besch : Str -> Verbum = \viajar ->
-- r22
  let viaj_ = Predef.tk 2 viajar in
 {s = table {
    VI Infn => viaj_ + "ar" ;
    VI Ger => viaj_ + "ando" ;
    VI Part => viaj_ + "ado" ;
    VPB (Pres Ind Sg P1) => viaj_ + "o" ;
    VPB (Pres Ind Sg P2) => viaj_ + "as" ;
    VPB (Pres Ind Sg P3) => viaj_ + "a" ;
    VPB (Pres Ind Pl P1) => viaj_ + "amos" ;
    VPB (Pres Ind Pl P2) => viaj_ + "ais" ;
    VPB (Pres Ind Pl P3) => viaj_ + "am" ;
    VPB (Pres Sub Sg P1) => viaj_ + "e" ;
    VPB (Pres Sub Sg P2) => viaj_ + "es" ;
    VPB (Pres Sub Sg P3) => viaj_ + "e" ;
    VPB (Pres Sub Pl P1) => viaj_ + "emos" ;
    VPB (Pres Sub Pl P2) => viaj_ + "eis" ;
    VPB (Pres Sub Pl P3) => viaj_ + "em" ;
    VPB (PretI Ind Sg P1) => viaj_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => viaj_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => viaj_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => viaj_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => viaj_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => viaj_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => viaj_ + "asse" ; --# notpresent
    VPB (PretI Sub Sg P2) => viaj_ + "asses" ; --# notpresent
    VPB (PretI Sub Sg P3) => viaj_ + "asse" ; --# notpresent
    VPB (PretI Sub Pl P1) => viaj_ + "ássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => viaj_ + "ásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => viaj_ + "assem" ; --# notpresent
    VPB (MQPerf Sg P1) => viaj_ + "ara" ; --# notpresent
    VPB (MQPerf Sg P2) => viaj_ + "aras" ; --# notpresent
    VPB (MQPerf Sg P3) => viaj_ + "ara" ; --# notpresent
    VPB (MQPerf Pl P1) => viaj_ + "áramos" ; --# notpresent
    VPB (MQPerf Pl P2) => viaj_ + "áreis" ; --# notpresent
    VPB (MQPerf Pl P3) => viaj_ + "aram" ; --# notpresent
    VPB (PretP Sg P1) => viaj_ + "ei" ; --# notpresent
    VPB (PretP Sg P2) => viaj_ + "aste" ; --# notpresent
    VPB (PretP Sg P3) => viaj_ + "ou" ; --# notpresent
    VPB (PretP Pl P1) => viaj_ + "amos" ; --# notpresent
    VPB (PretP Pl P2) => viaj_ + "astes" ; --# notpresent
    VPB (PretP Pl P3) => viaj_ + "aram" ; --# notpresent
    VPB (Fut Ind Sg P1) => viaj_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => viaj_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => viaj_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => viaj_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => viaj_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => viaj_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => viaj_ + "ar" ; --# notpresent
    VPB (Fut Sub Sg P2) => viaj_ + "ares" ; --# notpresent
    VPB (Fut Sub Sg P3) => viaj_ + "ar" ; --# notpresent
    VPB (Fut Sub Pl P1) => viaj_ + "armos" ; --# notpresent
    VPB (Fut Sub Pl P2) => viaj_ + "ardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => viaj_ + "arem" ; --# notpresent
    VPB (Cond Sg P1) => viaj_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => viaj_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => viaj_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => viaj_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => viaj_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => viaj_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => viaj_ + "a" ;
    VPB (Imper Sg P3) => viaj_ + "e" ;
    VPB (Imper Pl P1) => viaj_ + "emos" ;
    VPB (Imper Pl P2) => viaj_ + "ai" ;
    VPB (Imper Pl P3) => viaj_ + "em" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper suar_Besch : Str -> Verbum = \suar ->
-- r37
  let su_ = Predef.tk 2 suar in
 {s = table {
    VI Infn => su_ + "ar" ;
    VI Ger => su_ + "ando" ;
    VI Part => su_ + "ado" ;
    VPB (Pres Ind Sg P1) => su_ + "o" ;
    VPB (Pres Ind Sg P2) => su_ + "as" ;
    VPB (Pres Ind Sg P3) => su_ + "a" ;
    VPB (Pres Ind Pl P1) => su_ + "amos" ;
    VPB (Pres Ind Pl P2) => su_ + "ais" ;
    VPB (Pres Ind Pl P3) => su_ + "am" ;
    VPB (Pres Sub Sg P1) => su_ + "e" ;
    VPB (Pres Sub Sg P2) => su_ + "es" ;
    VPB (Pres Sub Sg P3) => su_ + "e" ;
    VPB (Pres Sub Pl P1) => su_ + "emos" ;
    VPB (Pres Sub Pl P2) => su_ + "eis" ;
    VPB (Pres Sub Pl P3) => su_ + "em" ;
    VPB (PretI Ind Sg P1) => su_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => su_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => su_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => su_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => su_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => su_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => su_ + "asse" ; --# notpresent
    VPB (PretI Sub Sg P2) => su_ + "asses" ; --# notpresent
    VPB (PretI Sub Sg P3) => su_ + "asse" ; --# notpresent
    VPB (PretI Sub Pl P1) => su_ + "ássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => su_ + "ásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => su_ + "assem" ; --# notpresent
    VPB (MQPerf Sg P1) => su_ + "ara" ; --# notpresent
    VPB (MQPerf Sg P2) => su_ + "aras" ; --# notpresent
    VPB (MQPerf Sg P3) => su_ + "ara" ; --# notpresent
    VPB (MQPerf Pl P1) => su_ + "áramos" ; --# notpresent
    VPB (MQPerf Pl P2) => su_ + "áreis" ; --# notpresent
    VPB (MQPerf Pl P3) => su_ + "aram" ; --# notpresent
    VPB (PretP Sg P1) => su_ + "ei" ; --# notpresent
    VPB (PretP Sg P2) => su_ + "aste" ; --# notpresent
    VPB (PretP Sg P3) => su_ + "ou" ; --# notpresent
    VPB (PretP Pl P1) => su_ + "amos" ; --# notpresent
    VPB (PretP Pl P2) => su_ + "astes" ; --# notpresent
    VPB (PretP Pl P3) => su_ + "aram" ; --# notpresent
    VPB (Fut Ind Sg P1) => su_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => su_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => su_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => su_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => su_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => su_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => su_ + "ar" ; --# notpresent
    VPB (Fut Sub Sg P2) => su_ + "ares" ; --# notpresent
    VPB (Fut Sub Sg P3) => su_ + "ar" ; --# notpresent
    VPB (Fut Sub Pl P1) => su_ + "armos" ; --# notpresent
    VPB (Fut Sub Pl P2) => su_ + "ardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => su_ + "arem" ; --# notpresent
    VPB (Cond Sg P1) => su_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => su_ + "arias" ; --# notpresent
    VPB (Cond Sg P3) => su_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => su_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => su_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => su_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => su_ + "a" ;
    VPB (Imper Sg P3) => su_ + "e" ;
    VPB (Imper Pl P1) => su_ + "emos" ;
    VPB (Imper Pl P2) => su_ + "ai" ;
    VPB (Imper Pl P3) => su_ + "em" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

oper peneirar_Besch : Str -> Verbum = \peneirar ->
-- r10
  let peneir_ = Predef.tk 2 peneirar in
 {s = table {
    VI Infn => peneir_ + "ar" ;
    VI Ger => peneir_ + "ando" ;
    VI Part => peneir_ + "ado" ;
    VPB (Pres Ind Sg P1) => peneir_ + "o" ;
    VPB (Pres Ind Sg P2) => peneir_ + "as" ;
    VPB (Pres Ind Sg P3) => peneir_ + "a" ;
    VPB (Pres Ind Pl P1) => peneir_ + "amos" ;
    VPB (Pres Ind Pl P2) => peneir_ + "ais" ;
    VPB (Pres Ind Pl P3) => peneir_ + "am" ;
    VPB (Pres Sub Sg P1) => peneir_ + "e" ;
    VPB (Pres Sub Sg P2) => peneir_ + "es" ;
    VPB (Pres Sub Sg P3) => peneir_ + "e" ;
    VPB (Pres Sub Pl P1) => peneir_ + "emos" ;
    VPB (Pres Sub Pl P2) => peneir_ + "eis" ;
    VPB (Pres Sub Pl P3) => peneir_ + "em" ;
    VPB (PretI Ind Sg P1) => peneir_ + "ava" ; --# notpresent
    VPB (PretI Ind Sg P2) => peneir_ + "avas" ; --# notpresent
    VPB (PretI Ind Sg P3) => peneir_ + "ava" ; --# notpresent
    VPB (PretI Ind Pl P1) => peneir_ + "ávamos" ; --# notpresent
    VPB (PretI Ind Pl P2) => peneir_ + "áveis" ; --# notpresent
    VPB (PretI Ind Pl P3) => peneir_ + "avam" ; --# notpresent
    VPB (PretI Sub Sg P1) => peneir_ + "asse" ; --# notpresent
    VPB (PretI Sub Sg P2) => peneir_ + "asses" ; --# notpresent
    VPB (PretI Sub Sg P3) => peneir_ + "asse" ; --# notpresent
    VPB (PretI Sub Pl P1) => peneir_ + "ássemos" ; --# notpresent
    VPB (PretI Sub Pl P2) => peneir_ + "ásseis" ; --# notpresent
    VPB (PretI Sub Pl P3) => peneir_ + "assem" ; --# notpresent
    VPB (MQPerf Sg P1) => peneir_ + "ara" ; --# notpresent
    VPB (MQPerf Sg P2) => peneir_ + "aras" ; --# notpresent
    VPB (MQPerf Sg P3) => peneir_ + "ara" ; --# notpresent
    VPB (MQPerf Pl P1) => peneir_ + "áramos" ; --# notpresent
    VPB (MQPerf Pl P2) => peneir_ + "áreis" ; --# notpresent
    VPB (MQPerf Pl P3) => peneir_ + "aram" ; --# notpresent
    VPB (PretP Sg P1) => peneir_ + "ei" ; --# notpresent
    VPB (PretP Sg P2) => peneir_ + "aste" ; --# notpresent
    VPB (PretP Sg P3) => peneir_ + "ou" ; --# notpresent
    VPB (PretP Pl P1) => peneir_ + "amos" ; --# notpresent
    VPB (PretP Pl P2) => peneir_ + "astes" ; --# notpresent
    VPB (PretP Pl P3) => peneir_ + "aram" ; --# notpresent
    VPB (Fut Ind Sg P1) => peneir_ + "arei" ; --# notpresent
    VPB (Fut Ind Sg P2) => peneir_ + "arás" ; --# notpresent
    VPB (Fut Ind Sg P3) => peneir_ + "ará" ; --# notpresent
    VPB (Fut Ind Pl P1) => peneir_ + "aremos" ; --# notpresent
    VPB (Fut Ind Pl P2) => peneir_ + "areis" ; --# notpresent
    VPB (Fut Ind Pl P3) => peneir_ + "arão" ; --# notpresent
    VPB (Fut Sub Sg P1) => peneir_ + "ar" ; --# notpresent
    VPB (Fut Sub Sg P2) => peneir_ + "ares" ; --# notpresent
    VPB (Fut Sub Sg P3) => peneir_ + "ar" ; --# notpresent
    VPB (Fut Sub Pl P1) => peneir_ + "armos" ; --# notpresent
    VPB (Fut Sub Pl P2) => peneir_ + "ardes" ; --# notpresent
    VPB (Fut Sub Pl P3) => peneir_ + "arem" ; --# notpresent
    VPB (Cond Sg P1) => peneir_ + "aria" ; --# notpresent
    VPB (Cond Sg P2) => peneir_ + "aries" ; --# notpresent
    VPB (Cond Sg P3) => peneir_ + "aria" ; --# notpresent
    VPB (Cond Pl P1) => peneir_ + "aríamos" ; --# notpresent
    VPB (Cond Pl P2) => peneir_ + "aríeis" ; --# notpresent
    VPB (Cond Pl P3) => peneir_ + "ariam" ; --# notpresent
    VPB (Imper Sg P2) => peneir_ + "a" ;
    VPB (Imper Sg P3) => peneir_ + "e" ;
    VPB (Imper Pl P1) => peneir_ + "emos" ;
    VPB (Imper Pl P2) => peneir_ + "ai" ;
    VPB (Imper Pl P3) => peneir_ + "em" ;
    VPB (Imper Sg P1) => nonExist
    }
  } ;

} ;
