--# -path=.:../romance:../common:../abstract:../../prelude
--
-- Verbs trets de "Xurriguera".
--

resource BeschCat = open Prelude, CommonRomance in {

--flags optimize=noexpand ; -- faster than values
  flags coding=utf8 ;
--
oper Verbum = {s : VFB => Str} ;
--
-- 
oper absoldre_1 : Str -> Verbum = \absoldre ->
let absol_ = Predef.tk 3 absoldre in
{s = table { 
 VI Infn => absol_ + "dre" ;
 VI Ger => absol_ + "ent" ;
 VI Part =>  absol_ + "t" ;
 VP (Pres Ind Pl  P1) => absol_ + "em" ;
 VP (Pres Ind Sg  P1) => absol_ + "c" ;
 VP (Pres Ind Pl  P2) => absol_ + "eu" ;
 VP (Pres Ind Sg  P2) => absol_ + "s" ;
 VP (Pres Ind Pl  P3) => absol_ + "en" ;
 VP (Pres Ind Sg  P3) => absol_ + "" ;
 VP (Pres Sub Pl  P1) => absol_ + "guem" ;
 VP (Pres Sub Sg  P1) => absol_ + "gui" ;
 VP (Pres Sub Pl  P2) => absol_ + "gueu" ;
 VP (Pres Sub Sg  P2) => absol_ + "guis" ;
 VP (Pres Sub Pl  P3) => absol_ + "guin" ;
 VP (Pres Sub Sg  P3) => absol_ + "gui" ;
 VP (Impf Ind Pl  P1) => absol_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => absol_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => absol_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => absol_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => absol_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => absol_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => absol_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => absol_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => absol_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => absol_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => absol_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => absol_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => absol_ + "drem" ;--# notpresent
 VP (Fut Sg  P1)  => absol_ + "dré" ;--# notpresent
 VP (Fut Pl  P2) => absol_ + "dreu" ;--# notpresent
 VP (Fut Sg  P2) => absol_ + "dràs" ;--# notpresent
 VP (Fut Pl  P3) => absol_ + "dran" ;--# notpresent
 VP (Fut Sg  P3) => absol_ + "drà" ;--# notpresent
 VP (Pret Pl  P1)  => absol_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => absol_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => absol_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => absol_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => absol_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => absol_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => absol_ + "dríem" ;--# notpresent
 VP (Cond Sg  P1)  => absol_ + "dria" ;--# notpresent
 VP (Cond Pl  P2) => absol_ + "dríeu" ;--# notpresent
 VP (Cond Sg  P2) => absol_ + "dries" ;--# notpresent
 VP (Cond Pl  P3) => absol_ + "drien" ;--# notpresent
 VP (Cond Sg  P3) => absol_ + "dria" ;--# notpresent
 VP (Imp Pl  P1)  => absol_ + "guem" ;
 VP (Imp Pl  P2) => absol_ + "eu" ;
 VP (Imp Sg  P2) => absol_ + "" ;
 VP (Imp Pl  P3) => absol_ + "guin" ;
 VP (Imp Sg  P3) => absol_ + "gui" ;
 VP (Pass Pl  Fem) => absol_ + "tes" ;
 VP (Pass Sg  Fem) => absol_ + "ta" ;
 VP (Pass Pl  Masc) => absol_ + "ts" ;
 VP (Pass Sg  Masc) => absol_ + "t" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper admetre_2 : Str -> Verbum = \admetre ->
let adm_ = Predef.tk 4 admetre in
{s = table { 
 VI Infn => adm_ + "etre" ;
 VI Ger => adm_ + "etent" ;
 VP (Pres Ind Pl  P1) => adm_ + "etem" ;
 VP (Pres Ind Sg  P1) => adm_ + "eto" ;
 VP (Pres Ind Pl  P2) => adm_ + "eteu" ;
 VP (Pres Ind Sg  P2) => adm_ + "ets" ;
 VP (Pres Ind Pl  P3) => adm_ + "eten" ;
 VP (Pres Ind Sg  P3) => adm_ + "et" ;
 VP (Pres Sub Pl  P1) => adm_ + "etem" ;
 VP (Pres Sub Sg  P1) => adm_ + "eti" ;
 VP (Pres Sub Pl  P2) => adm_ + "eteu" ;
 VP (Pres Sub Sg  P2) => adm_ + "etis" ;
 VP (Pres Sub Pl  P3) => adm_ + "etin" ;
 VP (Pres Sub Sg  P3) => adm_ + "eti" ;
 VP (Impf Ind Pl  P1) => adm_ + "etíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => adm_ + "etia" ;--# notpresent
 VP (Impf Ind Pl  P2) => adm_ + "etíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => adm_ + "eties" ;--# notpresent
 VP (Impf Ind Pl  P3) => adm_ + "etien" ;--# notpresent
 VP (Impf Ind Sg  P3) => adm_ + "etia" ;--# notpresent
 VP (Impf Sub Pl  P1) => adm_ + "etéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => adm_ + "etés" ;--# notpresent
 VP (Impf Sub Pl  P2) => adm_ + "etéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => adm_ + "etessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => adm_ + "etessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => adm_ + "etés" ;--# notpresent
 VP (Fut Pl  P1)  => adm_ + "etrem" ;--# notpresent
 VP (Fut Sg  P1)  => adm_ + "etré" ;--# notpresent
 VP (Fut Pl  P2) => adm_ + "etreu" ;--# notpresent
 VP (Fut Sg  P2) => adm_ + "etràs" ;--# notpresent
 VP (Fut Pl  P3) => adm_ + "etran" ;--# notpresent
 VP (Fut Sg  P3) => adm_ + "etrà" ;--# notpresent
 VP (Pret Pl  P1)  => adm_ + "etéssim" ;--# notpresent
 VP (Pret Sg  P1)  => adm_ + "etés" ;--# notpresent
 VP (Pret Pl  P2) => adm_ + "etéssiu" ;--# notpresent
 VP (Pret Sg  P2) => adm_ + "etessis" ;--# notpresent
 VP (Pret Pl  P3) => adm_ + "etessin" ;--# notpresent
 VP (Pret Sg  P3) => adm_ + "etés" ;--# notpresent
 VP (Cond Pl  P1)  => adm_ + "etríem" ;--# notpresent
 VP (Cond Sg  P1)  => adm_ + "etria" ;--# notpresent
 VP (Cond Pl  P2) => adm_ + "etríeu" ;--# notpresent
 VP (Cond Sg  P2) => adm_ + "etries" ;--# notpresent
 VP (Cond Pl  P3) => adm_ + "etrien" ;--# notpresent
 VP (Cond Sg  P3) => adm_ + "etria" ;--# notpresent
 VP (Imp Pl  P1)  => adm_ + "etem" ;
 VP (Imp Pl  P2) => adm_ + "eteu" ;
 VP (Imp Sg  P2) => adm_ + "et" ;
 VP (Imp Pl  P3) => adm_ + "etin" ;
 VP (Imp Sg  P3) => adm_ + "eti" ;
 VP (Pass Pl  Fem) => adm_ + "eses" ;
 VP (Pass Sg  Fem) => adm_ + "esa" ;
 VP (Pass Pl  Masc) => adm_ + "esos" ;
 VI Part =>  adm_ + "ès" ;
 VP (Pass Sg  Masc) => adm_ + "ès" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper ajupir_3 : Str -> Verbum = \ajupir ->
let ajup_ = Predef.tk 2 ajupir in
{s = table { 
 VI Infn => ajup_ + "ir" ;
 VI Ger => ajup_ + "int" ;
 VI Part =>  ajup_ + "it" ;
 VP (Pres Ind Pl  P1) => ajup_ + "im" ;
 VP (Pres Ind Sg  P1) => ajup_ + "o" ;
 VP (Pres Ind Pl  P2) => ajup_ + "iu" ;
 VP (Pres Ind Sg  P2) => ajup_ + "s" ;
 VP (Pres Ind Pl  P3) => ajup_ + "en" ;
 VP (Pres Ind Sg  P3) => ajup_ + "" ;
 VP (Pres Sub Pl  P1) => ajup_ + "im" ;
 VP (Pres Sub Sg  P1) => ajup_ + "i" ;
 VP (Pres Sub Pl  P2) => ajup_ + "iu" ;
 VP (Pres Sub Sg  P2) => ajup_ + "is" ;
 VP (Pres Sub Pl  P3) => ajup_ + "in" ;
 VP (Pres Sub Sg  P3) => ajup_ + "i" ;
 VP (Impf Ind Pl  P1) => ajup_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => ajup_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => ajup_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => ajup_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => ajup_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => ajup_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => ajup_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => ajup_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => ajup_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => ajup_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => ajup_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => ajup_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => ajup_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => ajup_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => ajup_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => ajup_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => ajup_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => ajup_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => ajup_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => ajup_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => ajup_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => ajup_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => ajup_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => ajup_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => ajup_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => ajup_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => ajup_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => ajup_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => ajup_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => ajup_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => ajup_ + "im" ;
 VP (Imp Pl  P2) => ajup_ + "iu" ;
 VP (Imp Sg  P2) => ajup_ + "" ;
 VP (Imp Pl  P3) => ajup_ + "in" ;
 VP (Imp Sg  P3) => ajup_ + "i" ;
 VP (Pass Pl  Fem) => ajup_ + "ides" ;
 VP (Pass Sg  Fem) => ajup_ + "ida" ;
 VP (Pass Pl  Masc) => ajup_ + "its" ;
 VP (Pass Sg  Masc) => ajup_ + "it" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper anar_4 : Str -> Verbum = \anar ->
let x_ = Predef.tk 4 anar in
{s = table { 
 VI Infn => x_ + "anar" ;
 VI Ger => x_ + "anant" ;
 VI Part =>  x_ + "anat" ;
 VP (Pres Ind Pl  P1) => x_ + "anem" ;
 VP (Pres Ind Sg  P1) => x_ + "vaig" ;
 VP (Pres Ind Pl  P2) => x_ + "aneu" ;
 VP (Pres Ind Sg  P2) => x_ + "vas" ;
 VP (Pres Ind Pl  P3) => x_ + "van" ;
 VP (Pres Ind Sg  P3) => x_ + "va" ;
 VP (Pres Sub Pl  P1) => x_ + "anem" ;
 VP (Pres Sub Sg  P1) => x_ + "vagi" ;
 VP (Pres Sub Pl  P2) => x_ + "aneu" ;
 VP (Pres Sub Sg  P2) => x_ + "vagis" ;
 VP (Pres Sub Pl  P3) => x_ + "vagin" ;
 VP (Pres Sub Sg  P3) => x_ + "vagi" ;
 VP (Impf Ind Pl  P1) => x_ + "anàvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "anava" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "anàveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "anaves" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "anaven" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "anava" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "anéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "anés" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "anéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "anessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "anessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "anés" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "anirem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "aniré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "anireu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "aniràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "aniran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "anirà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "anàssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "anàs" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "anàssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "anassis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "anassin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "anàs" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "aniríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "aniria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "aniríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "aniries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "anirien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "aniria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "anem" ;
 VP (Imp Pl  P2) => x_ + "aneu" ;
 VP (Imp Sg  P2) => x_ + "vés" ;
 VP (Imp Pl  P3) => x_ + "vagin" ;
 VP (Imp Sg  P3) => x_ + "vagi" ;
 VP (Pass Pl  Fem) => x_ + "anades" ;
 VP (Pass Sg  Fem) => x_ + "anada" ;
 VP (Pass Pl  Masc) => x_ + "anats" ;
 VP (Pass Sg  Masc) => x_ + "anat" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper aparèixer_5 : Str -> Verbum = \aparèixer ->
let apar_ = Predef.tk 5 aparèixer in
{s = table { 
 VI Ger => apar_ + "eixent" ;
 VI Part =>  apar_ + "egut" ;
 VP (Pres Ind Pl  P1) => apar_ + "eixem" ;
 VP (Pres Ind Sg  P1) => apar_ + "ec" ;
 VP (Pres Ind Pl  P2) => apar_ + "eixeu" ;
 VP (Pres Ind Sg  P2) => apar_ + "eixes" ;
 VP (Pres Ind Pl  P3) => apar_ + "eixen" ;
 VP (Pres Ind Sg  P3) => apar_ + "eix" ;
 VP (Pres Sub Pl  P1) => apar_ + "eguem" ;
 VP (Pres Sub Sg  P1) => apar_ + "egui" ;
 VP (Pres Sub Pl  P2) => apar_ + "egueu" ;
 VP (Pres Sub Sg  P2) => apar_ + "eguis" ;
 VP (Pres Sub Pl  P3) => apar_ + "eguin" ;
 VP (Pres Sub Sg  P3) => apar_ + "egui" ;
 VP (Impf Ind Pl  P1) => apar_ + "eixíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => apar_ + "eixia" ;--# notpresent
 VP (Impf Ind Pl  P2) => apar_ + "eixíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => apar_ + "eixies" ;--# notpresent
 VP (Impf Ind Pl  P3) => apar_ + "eixien" ;--# notpresent
 VP (Impf Ind Sg  P3) => apar_ + "eixia" ;--# notpresent
 VP (Impf Sub Pl  P1) => apar_ + "eguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => apar_ + "egués" ;--# notpresent
 VP (Impf Sub Pl  P2) => apar_ + "eguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => apar_ + "eguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => apar_ + "eguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => apar_ + "egués" ;--# notpresent
 VP (Fut Pl  P1)  => apar_ + "eixerem" ;--# notpresent
 VP (Fut Sg  P1)  => apar_ + "eixeré" ;--# notpresent
 VP (Fut Pl  P2) => apar_ + "eixereu" ;--# notpresent
 VP (Fut Sg  P2) => apar_ + "eixeràs" ;--# notpresent
 VP (Fut Pl  P3) => apar_ + "eixeran" ;--# notpresent
 VP (Fut Sg  P3) => apar_ + "eixerà" ;--# notpresent
 VP (Pret Pl  P1)  => apar_ + "eguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => apar_ + "egués" ;--# notpresent
 VP (Pret Pl  P2) => apar_ + "eguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => apar_ + "eguessis" ;--# notpresent
 VP (Pret Pl  P3) => apar_ + "eguessin" ;--# notpresent
 VP (Pret Sg  P3) => apar_ + "egués" ;--# notpresent
 VP (Cond Pl  P1)  => apar_ + "eixeríem" ;--# notpresent
 VP (Cond Sg  P1)  => apar_ + "eixeria" ;--# notpresent
 VP (Cond Pl  P2) => apar_ + "eixeríeu" ;--# notpresent
 VP (Cond Sg  P2) => apar_ + "eixeries" ;--# notpresent
 VP (Cond Pl  P3) => apar_ + "eixerien" ;--# notpresent
 VP (Cond Sg  P3) => apar_ + "eixeria" ;--# notpresent
 VP (Imp Pl  P1)  => apar_ + "eguem" ;
 VP (Imp Pl  P2) => apar_ + "eixeu" ;
 VP (Imp Sg  P2) => apar_ + "eix" ;
 VP (Imp Pl  P3) => apar_ + "eguin" ;
 VP (Imp Sg  P3) => apar_ + "egui" ;
 VP (Pass Pl  Fem) => apar_ + "egudes" ;
 VP (Pass Sg  Fem) => apar_ + "eguda" ;
 VP (Pass Pl  Masc) => apar_ + "eguts" ;
 VP (Pass Sg  Masc) => apar_ + "egut" ;
 VI Infn => apar_ + "èixer" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper aprendre_6 : Str -> Verbum = \aprendre ->
let a_ = Predef.tk 7 aprendre in
{s = table { 
 VI Infn => a_ + "prendre" ;
 VI Ger => a_ + "prenent" ;
 VI Part =>  a_ + "près" ;
 VP (Pres Ind Pl  P1) => a_ + "prenem" ;
 VP (Pres Ind Sg  P1) => a_ + "prenc" ;
 VP (Pres Ind Pl  P2) => a_ + "preneu" ;
 VP (Pres Ind Sg  P2) => a_ + "prens" ;
 VP (Pres Ind Pl  P3) => a_ + "prenen" ;
 VP (Pres Ind Sg  P3) => a_ + "prèn" ;
 VP (Pres Sub Pl  P1) => a_ + "prenguem" ;
 VP (Pres Sub Sg  P1) => a_ + "prengui" ;
 VP (Pres Sub Pl  P2) => a_ + "prengueu" ;
 VP (Pres Sub Sg  P2) => a_ + "prenguis" ;
 VP (Pres Sub Pl  P3) => a_ + "prenguin" ;
 VP (Pres Sub Sg  P3) => a_ + "prengui" ;
 VP (Impf Ind Pl  P1)  => a_ + "preníem" ;--# notpresent
 VP (Impf Ind Sg  P1)  => a_ + "prenia" ;--# notpresent
 VP (Impf Ind Pl  P2) => a_ + "preníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => a_ + "prenies" ;--# notpresent
 VP (Impf Ind Pl  P3) => a_ + "prenien" ;--# notpresent
 VP (Impf Ind Sg  P3) => a_ + "prenia" ;--# notpresent
 VP (Impf Sub Pl  P1) => a_ + "prenguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => a_ + "prengués" ;--# notpresent
 VP (Impf Sub Pl  P2) => a_ + "prenguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => a_ + "prenguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => a_ + "prenguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => a_ + "prengués" ;--# notpresent
 VP (Fut Pl  P1)  => a_ + "prendrem" ;--# notpresent
 VP (Fut Sg  P1)  => a_ + "prendré" ;--# notpresent
 VP (Fut Pl  P2) => a_ + "prendreu" ;--# notpresent
 VP (Fut Sg  P2) => a_ + "prendràs" ;--# notpresent
 VP (Fut Pl  P3) => a_ + "prendran" ;--# notpresent
 VP (Fut Sg  P3) => a_ + "prendrà" ;--# notpresent
 VP (Pret Pl  P1)  => a_ + "prenguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => a_ + "prengués" ;--# notpresent
 VP (Pret Pl  P2) => a_ + "prenguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => a_ + "prenguessis" ;--# notpresent
 VP (Pret Pl  P3) => a_ + "prenguessin" ;--# notpresent
 VP (Pret Sg  P3) => a_ + "prengués" ;--# notpresent
 VP (Cond Pl  P1)  => a_ + "prendríem" ;--# notpresent
 VP (Cond Sg  P1)  => a_ + "prendria" ;--# notpresent
 VP (Cond Pl  P2) => a_ + "prendríeu" ;--# notpresent
 VP (Cond Sg  P2) => a_ + "prendries" ;--# notpresent
 VP (Cond Pl  P3) => a_ + "prendrien" ;--# notpresent
 VP (Cond Sg  P3) => a_ + "prendria" ;--# notpresent
 VP (Imp Pl  P1)  => a_ + "prenguem" ;
 VP (Imp Pl  P2) => a_ + "preneu" ;
 VP (Imp Sg  P2) => a_ + "prèn" ;
 VP (Imp Pl  P3) => a_ + "prenguin" ;
 VP (Imp Sg  P3) => a_ + "prengui" ;
 VP (Pass Pl  Fem) => a_ + "preses" ;
 VP (Pass Sg  Fem) => a_ + "presa" ;
 VP (Pass Pl  Masc) => a_ + "presos" ;
 VP (Pass Sg  Masc) => a_ + "près" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- argüir-- is not in the used source .

oper atendre_8 : Str -> Verbum = \atendre ->
let at_ = Predef.tk 5 atendre in
{s = table { 
 VI Infn => at_ + "endre" ;
 VI Ger => at_ + "enent" ;
 VP (Pres Ind Pl  P1) => at_ + "enem" ;
 VP (Pres Ind Sg  P1) => at_ + "enc" ;
 VP (Pres Ind Pl  P2) => at_ + "eneu" ;
 VP (Pres Ind Sg  P2) => at_ + "ens" ;
 VP (Pres Ind Pl  P3) => at_ + "enen" ;
 VP (Pres Sub Pl  P1) => at_ + "enguem" ;
 VP (Pres Sub Sg  P1) => at_ + "engui" ;
 VP (Pres Sub Pl  P2) => at_ + "engueu" ;
 VP (Pres Sub Sg  P2) => at_ + "enguis" ;
 VP (Pres Sub Pl  P3) => at_ + "enguin" ;
 VP (Pres Sub Sg  P3) => at_ + "engui" ;
 VP (Impf Ind Pl  P1) => at_ + "eníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => at_ + "enia" ;--# notpresent
 VP (Impf Ind Pl  P2) => at_ + "eníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => at_ + "enies" ;--# notpresent
 VP (Impf Ind Pl  P3) => at_ + "enien" ;--# notpresent
 VP (Impf Ind Sg  P3) => at_ + "enia" ;--# notpresent
 VP (Impf Sub Pl  P1) => at_ + "enguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => at_ + "engués" ;--# notpresent
 VP (Impf Sub Pl  P2) => at_ + "enguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => at_ + "enguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => at_ + "enguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => at_ + "engués" ;--# notpresent
 VP (Fut Pl  P1)  => at_ + "endrem" ;--# notpresent
 VP (Fut Sg  P1)  => at_ + "endré" ;--# notpresent
 VP (Fut Pl  P2) => at_ + "endreu" ;--# notpresent
 VP (Fut Sg  P2) => at_ + "endràs" ;--# notpresent
 VP (Fut Pl  P3) => at_ + "endran" ;--# notpresent
 VP (Fut Sg  P3) => at_ + "endrà" ;--# notpresent
 VP (Pret Pl  P1)  => at_ + "enguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => at_ + "engués" ;--# notpresent
 VP (Pret Pl  P2) => at_ + "enguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => at_ + "enguessis" ;--# notpresent
 VP (Pret Pl  P3) => at_ + "enguessin" ;--# notpresent
 VP (Pret Sg  P3) => at_ + "engués" ;--# notpresent
 VP (Cond Pl  P1)  => at_ + "endríem" ;--# notpresent
 VP (Cond Sg  P1)  => at_ + "endria" ;--# notpresent
 VP (Cond Pl  P2) => at_ + "endríeu" ;--# notpresent
 VP (Cond Sg  P2) => at_ + "endries" ;--# notpresent
 VP (Cond Pl  P3) => at_ + "endrien" ;--# notpresent
 VP (Cond Sg  P3) => at_ + "endria" ;--# notpresent
 VP (Imp Pl  P1)  => at_ + "enguem" ;
 VP (Imp Pl  P2) => at_ + "eneu" ;
 VP (Imp Pl  P3) => at_ + "enguin" ;
 VP (Imp Sg  P3) => at_ + "engui" ;
 VP (Pass Pl  Fem) => at_ + "eses" ;
 VP (Pass Sg  Fem) => at_ + "esa" ;
 VP (Pass Pl  Masc) => at_ + "esos" ;
 VI Part =>  at_ + "ès" ;
 VP (Pass Sg  Masc) => at_ + "ès" ;
 VP (Pres Ind Sg  P3) => at_ + "én" ;
 VP (Imp Sg  P2) => at_ + "én" ;
VP (Imp Sg P1) => variants {} 
}
} ;
oper atènyer_59  : Str -> Verbum = \atènyer -> 
      let at_ = Predef.tk 5 atènyer in
     {s = table {
        VI Infn=> at_ + "ènyer" ;
        VI Ger => at_ + "enyent" ;
        VI Part => at_ + "ès" ;
        VP (Pres Ind Sg P1) => at_ + "enyo" ;
        VP (Pres Ind Sg P2) => at_ + "enys" ;
        VP (Pres Ind Sg P3) => at_ + "eny" ; 
        VP (Pres Ind Pl P1) => at_ + "enyem" ;
        VP (Pres Ind Pl P2) => at_ + "enyeu" ;
        VP (Pres Ind Pl P3) => at_ + "enyen" ;
        VP (Pres Sub Sg P1) => at_ + "enyi" ;
        VP (Pres Sub Sg P2) => at_ + "enyis" ;
        VP (Pres Sub Sg P3) => at_ + "enyi" ;
        VP (Pres Sub Pl P1) => at_ + "enyem" ;
        VP (Pres Sub Pl P2) => at_ + "enyeu" ;
        VP (Pres Sub Pl P3) => at_ + "enyin" ;
        VP (Impf Ind Sg P1) => at_ + "enyia" ; --# notpresent
        VP (Impf Ind Sg P2) => at_ + "enyies" ; --# notpresent
        VP (Impf Ind Sg P3) => at_ + "enyia" ; --# notpresent
        VP (Impf Ind Pl P1) => at_ + "enyíem" ; --# notpresent
        VP (Impf Ind Pl P2) => at_ + "enyíeu" ; --# notpresent
        VP (Impf Ind Pl P3) => at_ + "enyien" ; --# notpresent
        VP (Impf Sub Sg P1) => at_ + "enyés" ; --# notpresent
        VP (Impf Sub Sg P2) =>  at_ + "enyéssis" ; --# notpresent
        VP (Impf Sub Sg P3) => at_ + "enyés" ; --# notpresent
        VP (Impf Sub Pl P1) => at_ + "enyéssim" ; --# notpresent
        VP (Impf Sub Pl P2) => at_ + "enyéssiu" ; --# notpresent
        VP (Impf Sub Pl P3) =>  at_ + "enyéssin" ; --# notpresent
        VP (Pret Sg P1) => at_ + "enyí" ; --# notpresent
        VP (Pret Sg P2) => at_ + "enyeres" ; --# notpresent
        VP (Pret Sg P3) => at_ + "enyé" ; --# notpresent
        VP (Pret Pl P1) => at_ + "enyérem" ; --# notpresent
        VP (Pret Pl P2) => at_ + "enyéreu" ; --# notpresent
        VP (Pret Pl P3) => at_ + "enyéren" ; --# notpresent
        VP (Fut Sg P1) => at_ + "enyeré" ; --# notpresent
        VP (Fut Sg P2) => at_ + "enyeràs" ; --# notpresent
        VP (Fut Sg P3) => at_ + "enyerà" ; --# notpresent
        VP (Fut Pl P1) => at_ + "enyerem" ; --# notpresent
        VP (Fut Pl P2) => at_ + "enyereu" ; --# notpresent
        VP (Fut Pl P3) => at_ + "enyeran" ; --# notpresent
        VP (Cond Sg P1) => at_ + "enyeria" ; --# notpresent
        VP (Cond Sg P2) => at_ + "enyeries" ; --# notpresent
        VP (Cond Sg P3) => at_ + "enyeria" ; --# notpresent
        VP (Cond Pl P1) => at_ + "enyeríem" ; --# notpresent
        VP (Cond Pl P2) => at_ + "enyeríeu" ; --# notpresent
        VP (Cond Pl P3) => at_ + "enyerien" ; --# notpresent
        VP (Imp Sg P2) => at_ + "eny" ; 
        VP (Imp Sg P3) => at_ + "enyi" ; 
        VP (Imp Pl P1) => at_ + "enyem" ; 
        VP (Imp Pl P2) => at_ + "enyeu" ; 
        VP (Imp Pl P3) => at_ + "enyin" ; 
        VP (Pass Sg Masc) => at_ + "ès" ;
        VP (Pass Sg Fem) => at_ + "esa" ;
        VP (Pass Pl Masc) => at_ + "esos" ;
        VP (Pass Pl Fem) => at_ + "eses";
        VP (Imp Sg P1) => variants {} 
        }
      } ;
oper batre_10 : Str -> Verbum = \batre ->
let bat_ = Predef.tk 2 batre in
{s = table { 
 VI Infn => bat_ + "re" ;
 VI Ger => bat_ + "ent" ;
 VI Part =>  bat_ + "ut" ;
 VP (Pres Ind Pl  P1) => bat_ + "em" ;
 VP (Pres Ind Sg  P1) => bat_ + "o" ;
 VP (Pres Ind Pl  P2) => bat_ + "eu" ;
 VP (Pres Ind Sg  P2) => bat_ + "s" ;
 VP (Pres Ind Pl  P3) => bat_ + "en" ;
 VP (Pres Ind Sg  P3) => bat_ + "" ;
 VP (Pres Sub Pl  P1) => bat_ + "em" ;
 VP (Pres Sub Sg  P1) => bat_ + "i" ;
 VP (Pres Sub Pl  P2) => bat_ + "eu" ;
 VP (Pres Sub Sg  P2) => bat_ + "is" ;
 VP (Pres Sub Pl  P3) => bat_ + "in" ;
 VP (Pres Sub Sg  P3) => bat_ + "i" ;
 VP (Impf Ind Pl  P1) => bat_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => bat_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => bat_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => bat_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => bat_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => bat_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => bat_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => bat_ + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => bat_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => bat_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => bat_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => bat_ + "és" ;--# notpresent
 VP (Fut Pl  P1)  => bat_ + "rem" ;--# notpresent
 VP (Fut Sg  P1)  => bat_ + "ré" ;--# notpresent
 VP (Fut Pl  P2) => bat_ + "reu" ;--# notpresent
 VP (Fut Sg  P2) => bat_ + "ràs" ;--# notpresent
 VP (Fut Pl  P3) => bat_ + "ran" ;--# notpresent
 VP (Fut Sg  P3) => bat_ + "rà" ;--# notpresent
 VP (Pret Pl  P1)  => bat_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => bat_ + "és" ;--# notpresent
 VP (Pret Pl  P2) => bat_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => bat_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => bat_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => bat_ + "és" ;--# notpresent
 VP (Cond Pl  P1)  => bat_ + "ríem" ;--# notpresent
 VP (Cond Sg  P1)  => bat_ + "ria" ;--# notpresent
 VP (Cond Pl  P2) => bat_ + "ríeu" ;--# notpresent
 VP (Cond Sg  P2) => bat_ + "ries" ;--# notpresent
 VP (Cond Pl  P3) => bat_ + "rien" ;--# notpresent
 VP (Cond Sg  P3) => bat_ + "ria" ;--# notpresent
 VP (Imp Pl  P1)  => bat_ + "em" ;
 VP (Imp Pl  P2) => bat_ + "eu" ;
 VP (Imp Sg  P2) => bat_ + "" ;
 VP (Imp Pl  P3) => bat_ + "in" ;
 VP (Imp Sg  P3) => bat_ + "i" ;
 VP (Pass Pl  Fem) => bat_ + "udes" ;
 VP (Pass Sg  Fem) => bat_ + "uda" ;
 VP (Pass Pl  Masc) => bat_ + "uts" ;
 VP (Pass Sg  Masc) => bat_ + "ut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper beure_11 : Str -> Verbum = \beure ->
let be_ = Predef.tk 3 beure in
{s = table { 
 VI Infn => be_ + "ure" ;
 VI Ger => be_ + "vent" ;
 VI Part =>  be_ + "gut" ;
 VP (Pres Ind Pl  P1) => be_ + "vem" ;
 VP (Pres Ind Sg  P1) => be_ + "c" ;
 VP (Pres Ind Pl  P2) => be_ + "veu" ;
 VP (Pres Ind Sg  P2) => be_ + "us" ;
 VP (Pres Ind Pl  P3) => be_ + "uen" ;
 VP (Pres Ind Sg  P3) => be_ + "u" ;
 VP (Pres Sub Pl  P1) => be_ + "guem" ;
 VP (Pres Sub Sg  P1) => be_ + "gui" ;
 VP (Pres Sub Pl  P2) => be_ + "gueu" ;
 VP (Pres Sub Sg  P2) => be_ + "guis" ;
 VP (Pres Sub Pl  P3) => be_ + "guin" ;
 VP (Pres Sub Sg  P3) => be_ + "gui" ;
 VP (Impf Ind Pl  P1)  => be_ + "víem" ;--# notpresent
 VP (Impf Ind Sg  P1)  => be_ + "via" ;--# notpresent
 VP (Impf Ind Pl  P2) => be_ + "víeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => be_ + "vies" ;--# notpresent
 VP (Impf Ind Pl  P3) => be_ + "vien" ;--# notpresent
 VP (Impf Ind Sg  P3) => be_ + "via" ;--# notpresent
 VP (Impf Sub Pl  P1) => be_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => be_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => be_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => be_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => be_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => be_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => be_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => be_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => be_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => be_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => be_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => be_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => be_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => be_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => be_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => be_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => be_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => be_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => be_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => be_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => be_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => be_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => be_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => be_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => be_ + "guem" ;
 VP (Imp Pl  P2) => be_ + "veu" ;
 VP (Imp Sg  P2) => be_ + "u" ;
 VP (Imp Pl  P3) => be_ + "guin" ;
 VP (Imp Sg  P3) => be_ + "gui" ;
 VP (Pass Pl  Fem) => be_ + "gudes" ;
 VP (Pass Sg  Fem) => be_ + "guda" ;
 VP (Pass Pl  Masc) => be_ + "guts" ;
 VP (Pass Sg  Masc) => be_ + "gut" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- bullir-- is not in the used source .

oper cabre_13 : Str -> Verbum = \cabre ->
let ca_ = Predef.tk 3 cabre in
{s = table { 
 VI Infn => ca_ + "bre" ;
 VI Ger => ca_ + "bent" ;
 VI Part =>  ca_ + "but" ;
 VP (Pres Ind Pl  P1) => ca_ + "bem" ;
 VP (Pres Ind Sg  P1) => ca_ + "bo" ;
 VP (Pres Ind Pl  P2) => ca_ + "beu" ;
 VP (Pres Ind Sg  P2) => ca_ + "ps" ;
 VP (Pres Ind Pl  P3) => ca_ + "ben" ;
 VP (Pres Ind Sg  P3) => ca_ + "p" ;
 VP (Pres Sub Pl  P1) => ca_ + "bem" ;
 VP (Pres Sub Sg  P1) => ca_ + "bi" ;
 VP (Pres Sub Pl  P2) => ca_ + "beu" ;
 VP (Pres Sub Sg  P2) => ca_ + "bis" ;
 VP (Pres Sub Pl  P3) => ca_ + "bin" ;
 VP (Pres Sub Sg  P3) => ca_ + "bi" ;
 VP (Impf Ind Pl  P1) => ca_ + "bíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => ca_ + "bia" ;--# notpresent
 VP (Impf Ind Pl  P2) => ca_ + "bíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => ca_ + "bies" ;--# notpresent
 VP (Impf Ind Pl  P3) => ca_ + "bien" ;--# notpresent
 VP (Impf Ind Sg  P3) => ca_ + "bia" ;--# notpresent
 VP (Impf Sub Pl  P1) => ca_ + "béssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => ca_ + "bés" ;--# notpresent
 VP (Impf Sub Pl  P2) => ca_ + "béssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => ca_ + "bessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => ca_ + "bessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => ca_ + "bés" ;--# notpresent
 VP (Fut Pl  P1)  => ca_ + "brem" ;--# notpresent
 VP (Fut Sg  P1)  => ca_ + "bré" ;--# notpresent
 VP (Fut Pl  P2) => ca_ + "breu" ;--# notpresent
 VP (Fut Sg  P2) => ca_ + "bràs" ;--# notpresent
 VP (Fut Pl  P3) => ca_ + "bran" ;--# notpresent
 VP (Fut Sg  P3) => ca_ + "brà" ;--# notpresent
 VP (Pret Pl  P1)  => ca_ + "béssim" ;--# notpresent
 VP (Pret Sg  P1)  => ca_ + "bés" ;--# notpresent
 VP (Pret Pl  P2) => ca_ + "béssiu" ;--# notpresent
 VP (Pret Sg  P2) => ca_ + "bessis" ;--# notpresent
 VP (Pret Pl  P3) => ca_ + "bessin" ;--# notpresent
 VP (Pret Sg  P3) => ca_ + "bés" ;--# notpresent
 VP (Cond Pl  P1)  => ca_ + "bríem" ;--# notpresent
 VP (Cond Sg  P1)  => ca_ + "bria" ;--# notpresent
 VP (Cond Pl  P2) => ca_ + "bríeu" ;--# notpresent
 VP (Cond Sg  P2) => ca_ + "bries" ;--# notpresent
 VP (Cond Pl  P3) => ca_ + "brien" ;--# notpresent
 VP (Cond Sg  P3) => ca_ + "bria" ;--# notpresent
 VP (Imp Pl  P1)  => ca_ + "bem" ;
 VP (Imp Pl  P2) => ca_ + "beu" ;
 VP (Imp Sg  P2) => ca_ + "p" ;
 VP (Imp Pl  P3) => ca_ + "bin" ;
 VP (Imp Sg  P3) => ca_ + "bi" ;
 VP (Pass Pl  Fem) => ca_ + "budes" ;
 VP (Pass Sg  Fem) => ca_ + "buda" ;
 VP (Pass Pl  Masc) => ca_ + "buts" ;
 VP (Pass Sg  Masc) => ca_ + "but" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- caldre-- is not in the used source .

oper cantar_15 : Str -> Verbum = \cantar ->
let cant_ = Predef.tk 2 cantar in
{s = table { 
 VI Infn => cant_ + "ar" ;
 VI Ger => cant_ + "ant" ;
 VI Part =>  cant_ + "at" ;
 VP (Pres Ind Pl  P1) => cant_ + "em" ;
 VP (Pres Ind Sg  P1) => cant_ + "o" ;
 VP (Pres Ind Pl  P2) => cant_ + "eu" ;
 VP (Pres Ind Sg  P2) => cant_ + "es" ;
 VP (Pres Ind Pl  P3) => cant_ + "en" ;
 VP (Pres Ind Sg  P3) => cant_ + "a" ;
 VP (Pres Sub Pl  P1) => cant_ + "em" ;
 VP (Pres Sub Sg  P1) => cant_ + "i" ;
 VP (Pres Sub Pl  P2) => cant_ + "eu" ;
 VP (Pres Sub Sg  P2) => cant_ + "is" ;
 VP (Pres Sub Pl  P3) => cant_ + "in" ;
 VP (Pres Sub Sg  P3) => cant_ + "i" ;
 VP (Impf Ind Pl  P1) => cant_ + "àvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => cant_ + "ava" ;--# notpresent
 VP (Impf Ind Pl  P2) => cant_ + "àveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => cant_ + "aves" ;--# notpresent
 VP (Impf Ind Pl  P3) => cant_ + "aven" ;--# notpresent
 VP (Impf Ind Sg  P3) => cant_ + "ava" ;--# notpresent
 VP (Impf Sub Pl  P1) => cant_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => cant_ + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => cant_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => cant_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => cant_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => cant_ + "és" ;--# notpresent
 VP (Fut Pl  P1)  => cant_ + "arem" ;--# notpresent
 VP (Fut Sg  P1)  => cant_ + "aré" ;--# notpresent
 VP (Fut Pl  P2) => cant_ + "areu" ;--# notpresent
 VP (Fut Sg  P2) => cant_ + "aràs" ;--# notpresent
 VP (Fut Pl  P3) => cant_ + "aran" ;--# notpresent
 VP (Fut Sg  P3) => cant_ + "arà" ;--# notpresent
 VP (Pret Pl  P1)  => cant_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => cant_ + "és" ;--# notpresent
 VP (Pret Pl  P2) => cant_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => cant_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => cant_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => cant_ + "és" ;--# notpresent
 VP (Cond Pl  P1)  => cant_ + "aríem" ;--# notpresent
 VP (Cond Sg  P1)  => cant_ + "aria" ;--# notpresent
 VP (Cond Pl  P2) => cant_ + "aríeu" ;--# notpresent
 VP (Cond Sg  P2) => cant_ + "aries" ;--# notpresent
 VP (Cond Pl  P3) => cant_ + "arien" ;--# notpresent
 VP (Cond Sg  P3) => cant_ + "aria" ;--# notpresent
 VP (Imp Pl  P1)  => cant_ + "em" ;
 VP (Imp Pl  P2) => cant_ + "eu" ;
 VP (Imp Sg  P2) => cant_ + "a" ;
 VP (Imp Pl  P3) => cant_ + "in" ;
 VP (Imp Sg  P3) => cant_ + "i" ;
 VP (Pass Pl  Fem) => cant_ + "ades" ;
 VP (Pass Sg  Fem) => cant_ + "ada" ;
 VP (Pass Pl  Masc) => cant_ + "ats" ;
 VP (Pass Sg  Masc) => cant_ + "at" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper canviar_16 : Str -> Verbum = \canviar ->
let canvi_ = Predef.tk 2 canviar in
{s = table { 
 VI Infn => canvi_ + "ar" ;
 VI Ger => canvi_ + "ant" ;
 VI Part =>  canvi_ + "at" ;
 VP (Pres Ind Pl  P1) => canvi_ + "em" ;
 VP (Pres Ind Sg  P1) => canvi_ + "o" ;
 VP (Pres Ind Pl  P2) => canvi_ + "eu" ;
 VP (Pres Ind Sg  P2) => canvi_ + "es" ;
 VP (Pres Ind Pl  P3) => canvi_ + "en" ;
 VP (Pres Ind Sg  P3) => canvi_ + "a" ;
 VP (Pres Sub Pl  P1) => canvi_ + "em" ;
 VP (Pres Sub Sg  P1) => canvi_ + "ï" ;
 VP (Pres Sub Pl  P2) => canvi_ + "eu" ;
 VP (Pres Sub Sg  P2) => canvi_ + "ïs" ;
 VP (Pres Sub Pl  P3) => canvi_ + "ïn" ;
 VP (Pres Sub Sg  P3) => canvi_ + "ï" ;
 VP (Impf Ind Pl  P1) => canvi_ + "àvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => canvi_ + "ava" ;--# notpresent
 VP (Impf Ind Pl  P2) => canvi_ + "àveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => canvi_ + "aves" ;--# notpresent
 VP (Impf Ind Pl  P3) => canvi_ + "aven" ;--# notpresent
 VP (Impf Ind Sg  P3) => canvi_ + "ava" ;--# notpresent
 VP (Impf Sub Pl  P1) => canvi_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => canvi_ + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => canvi_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => canvi_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => canvi_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => canvi_ + "és" ;--# notpresent
 VP (Fut Pl  P1)  => canvi_ + "arem" ;--# notpresent
 VP (Fut Sg  P1)  => canvi_ + "aré" ;--# notpresent
 VP (Fut Pl  P2) => canvi_ + "areu" ;--# notpresent
 VP (Fut Sg  P2) => canvi_ + "aràs" ;--# notpresent
 VP (Fut Pl  P3) => canvi_ + "aran" ;--# notpresent
 VP (Fut Sg  P3) => canvi_ + "arà" ;--# notpresent
 VP (Pret Pl  P1)  => canvi_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => canvi_ + "és" ;--# notpresent
 VP (Pret Pl  P2) => canvi_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => canvi_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => canvi_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => canvi_ + "és" ;--# notpresent
 VP (Cond Pl  P1)  => canvi_ + "aríem" ;--# notpresent
 VP (Cond Sg  P1)  => canvi_ + "aria" ;--# notpresent
 VP (Cond Pl  P2) => canvi_ + "aríeu" ;--# notpresent
 VP (Cond Sg  P2) => canvi_ + "aries" ;--# notpresent
 VP (Cond Pl  P3) => canvi_ + "arien" ;--# notpresent
 VP (Cond Sg  P3) => canvi_ + "aria" ;--# notpresent
 VP (Imp Pl  P1)  => canvi_ + "em" ;
 VP (Imp Pl  P2) => canvi_ + "eu" ;
 VP (Imp Sg  P2) => canvi_ + "a" ;
 VP (Imp Pl  P3) => canvi_ + "ïn" ;
 VP (Imp Sg  P3) => canvi_ + "ï" ;
 VP (Pass Pl  Fem) => canvi_ + "ades" ;
 VP (Pass Sg  Fem) => canvi_ + "ada" ;
 VP (Pass Pl  Masc) => canvi_ + "ats" ;
 VP (Pass Sg  Masc) => canvi_ + "at" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- carvendre-- is not in the used source .

oper caure_18 : Str -> Verbum = \caure ->
let x_ = Predef.tk 5 caure in
{s = table { 
 VI Infn => x_ + "caure" ;
 VI Ger => x_ + "caient" ;
 VI Part =>  x_ + "caigut" ;
 VP (Pres Ind Pl  P1) => x_ + "caiem" ;
 VP (Pres Ind Sg  P1) => x_ + "caic" ;
 VP (Pres Ind Pl  P2) => x_ + "caieu" ;
 VP (Pres Ind Sg  P2) => x_ + "caus" ;
 VP (Pres Ind Pl  P3) => x_ + "cauen" ;
 VP (Pres Ind Sg  P3) => x_ + "cau" ;
 VP (Pres Sub Pl  P1) => x_ + "caiguem" ;
 VP (Pres Sub Sg  P1) => x_ + "caigui" ;
 VP (Pres Sub Pl  P2) => x_ + "caigueu" ;
 VP (Pres Sub Sg  P2) => x_ + "caiguis" ;
 VP (Pres Sub Pl  P3) => x_ + "caiguin" ;
 VP (Pres Sub Sg  P3) => x_ + "caigui" ;
 VP (Impf Ind Pl  P1) => x_ + "quèiem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "queia" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "quèieu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "queies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "queien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "queia" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "caiguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "caigués" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "caiguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "caiguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "caiguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "caigués" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "caurem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "cauré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "caureu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "cauràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "cauran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "caurà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "caiguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "caigués" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "caiguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "caiguessis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "caiguessin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "caigués" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "cauríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "cauria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "cauríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "cauries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "caurien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "cauria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "caiguem" ;
 VP (Imp Pl  P2) => x_ + "caieu" ;
 VP (Imp Sg  P2) => x_ + "cau" ;
 VP (Imp Pl  P3) => x_ + "caiguin" ;
 VP (Imp Sg  P3) => x_ + "caigui" ;
 VP (Pass Pl  Fem) => x_ + "caigudes" ;
 VP (Pass Sg  Fem) => x_ + "caiguda" ;
 VP (Pass Pl  Masc) => x_ + "caiguts" ;
 VP (Pass Sg  Masc) => x_ + "caigut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper cloure_19 : Str -> Verbum = \cloure ->
let clo_ = Predef.tk 3 cloure in
{s = table { 
 VI Infn => clo_ + "ure" ;
 VI Ger => clo_ + "ent" ;
 VI Part =>  clo_ + "s" ;
 VP (Pres Ind Pl  P1) => clo_ + "em" ;
 VP (Pres Ind Sg  P1) => clo_ + "c" ;
 VP (Pres Ind Pl  P2) => clo_ + "eu" ;
 VP (Pres Ind Sg  P2) => clo_ + "us" ;
 VP (Pres Ind Pl  P3) => clo_ + "uen" ;
 VP (Pres Ind Sg  P3) => clo_ + "u" ;
 VP (Pres Sub Pl  P1) => clo_ + "guem" ;
 VP (Pres Sub Sg  P1) => clo_ + "gui" ;
 VP (Pres Sub Pl  P2) => clo_ + "gueu" ;
 VP (Pres Sub Sg  P2) => clo_ + "guis" ;
 VP (Pres Sub Pl  P3) => clo_ + "guin" ;
 VP (Pres Sub Sg  P3) => clo_ + "gui" ;
 VP (Impf Ind Pl  P1) => clo_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => clo_ + "ïa" ;--# notpresent
 VP (Impf Ind Pl  P2) => clo_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => clo_ + "ïes" ;--# notpresent
 VP (Impf Ind Pl  P3) => clo_ + "ïen" ;--# notpresent
 VP (Impf Ind Sg  P3) => clo_ + "ïa" ;--# notpresent
 VP (Impf Sub Pl  P1) => clo_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => clo_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => clo_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => clo_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => clo_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => clo_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => clo_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => clo_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => clo_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => clo_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => clo_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => clo_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => clo_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => clo_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => clo_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => clo_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => clo_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => clo_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => clo_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => clo_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => clo_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => clo_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => clo_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => clo_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => clo_ + "guem" ;
 VP (Imp Pl  P2) => clo_ + "eu" ;
 VP (Imp Sg  P2) => clo_ + "u" ;
 VP (Imp Pl  P3) => clo_ + "guin" ;
 VP (Imp Sg  P3) => clo_ + "gui" ;
 VP (Pass Pl  Fem) => clo_ + "ses" ;
 VP (Pass Sg  Fem) => clo_ + "sa" ;
 VP (Pass Pl  Masc) => clo_ + "sos" ;
 VP (Pass Sg  Masc) => clo_ + "s" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper cobrir_20 : Str -> Verbum = \cobrir ->
let cob_ = Predef.tk 3 cobrir in
{s = table { 
 VI Infn => cob_ + "rir" ;
 VI Ger => cob_ + "rint" ;
 VI Part =>  cob_ + "ert" ;
 VP (Pres Ind Pl  P1) => cob_ + "rim" ;
 VP (Pres Ind Sg  P1) => cob_ + "reixo" ;
 VP (Pres Ind Pl  P2) => cob_ + "riu" ;
 VP (Pres Ind Sg  P2) => cob_ + "reixes" ;
 VP (Pres Ind Pl  P3) => cob_ + "reixen" ;
 VP (Pres Ind Sg  P3) => cob_ + "reix" ;
 VP (Pres Sub Pl  P1) => cob_ + "rim" ;
 VP (Pres Sub Sg  P1) => cob_ + "reixi" ;
 VP (Pres Sub Pl  P2) => cob_ + "riu" ;
 VP (Pres Sub Sg  P2) => cob_ + "reixis" ;
 VP (Pres Sub Pl  P3) => cob_ + "reixin" ;
 VP (Pres Sub Sg  P3) => cob_ + "reixi" ;
 VP (Impf Ind Pl  P1) => cob_ + "ríem" ;--# notpresent
 VP (Impf Ind Sg  P1) => cob_ + "ria" ;--# notpresent
 VP (Impf Ind Pl  P2) => cob_ + "ríeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => cob_ + "ries" ;--# notpresent
 VP (Impf Ind Pl  P3) => cob_ + "rien" ;--# notpresent
 VP (Impf Ind Sg  P3) => cob_ + "ria" ;--# notpresent
 VP (Impf Sub Pl  P1) => cob_ + "ríssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => cob_ + "rís" ;--# notpresent
 VP (Impf Sub Pl  P2) => cob_ + "ríssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => cob_ + "rissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => cob_ + "rissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => cob_ + "rís" ;--# notpresent
 VP (Fut Pl  P1)  => cob_ + "rirem" ;--# notpresent
 VP (Fut Sg  P1)  => cob_ + "riré" ;--# notpresent
 VP (Fut Pl  P2) => cob_ + "rireu" ;--# notpresent
 VP (Fut Sg  P2) => cob_ + "riràs" ;--# notpresent
 VP (Fut Pl  P3) => cob_ + "riran" ;--# notpresent
 VP (Fut Sg  P3) => cob_ + "rirà" ;--# notpresent
 VP (Pret Pl  P1)  => cob_ + "ríssim" ;--# notpresent
 VP (Pret Sg  P1)  => cob_ + "rís" ;--# notpresent
 VP (Pret Pl  P2) => cob_ + "ríssiu" ;--# notpresent
 VP (Pret Sg  P2) => cob_ + "rissis" ;--# notpresent
 VP (Pret Pl  P3) => cob_ + "rissin" ;--# notpresent
 VP (Pret Sg  P3) => cob_ + "rís" ;--# notpresent
 VP (Cond Pl  P1)  => cob_ + "riríem" ;--# notpresent
 VP (Cond Sg  P1)  => cob_ + "riria" ;--# notpresent
 VP (Cond Pl  P2) => cob_ + "riríeu" ;--# notpresent
 VP (Cond Sg  P2) => cob_ + "riries" ;--# notpresent
 VP (Cond Pl  P3) => cob_ + "ririen" ;--# notpresent
 VP (Cond Sg  P3) => cob_ + "riria" ;--# notpresent
 VP (Imp Pl  P1)  => cob_ + "rim" ;
 VP (Imp Pl  P2) => cob_ + "riu" ;
 VP (Imp Sg  P2) => cob_ + "reix" ;
 VP (Imp Pl  P3) => cob_ + "reixin" ;
 VP (Imp Sg  P3) => cob_ + "reixi" ;
 VP (Pass Pl  Fem) => cob_ + "ertes" ;
 VP (Pass Sg  Fem) => cob_ + "erta" ;
 VP (Pass Pl  Masc) => cob_ + "erts" ;
 VP (Pass Sg  Masc) => cob_ + "ert" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper collir_21 : Str -> Verbum = \collir ->
let c_ = Predef.tk 5 collir in
{s = table { 
 VI Infn => c_ + "ollir" ;
 VI Ger => c_ + "ollint" ;
 VI Part =>  c_ + "ollit" ;
 VP (Pres Ind Pl  P1) => c_ + "ollim" ;
 VP (Pres Ind Sg  P1) => c_ + "ullo" ;
 VP (Pres Ind Pl  P2) => c_ + "olliu" ;
 VP (Pres Ind Sg  P2) => c_ + "ulls" ;
 VP (Pres Ind Pl  P3) => c_ + "ullen" ;
 VP (Pres Ind Sg  P3) => c_ + "ull" ;
 VP (Pres Sub Pl  P1) => c_ + "ollim" ;
 VP (Pres Sub Sg  P1) => c_ + "ulli" ;
 VP (Pres Sub Pl  P2) => c_ + "olliu" ;
 VP (Pres Sub Sg  P2) => c_ + "ullis" ;
 VP (Pres Sub Pl  P3) => c_ + "ullin" ;
 VP (Pres Sub Sg  P3) => c_ + "ulli" ;
 VP (Impf Ind Pl  P1) => c_ + "ollíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => c_ + "ollia" ;--# notpresent
 VP (Impf Ind Pl  P2) => c_ + "ollíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => c_ + "ollies" ;--# notpresent
 VP (Impf Ind Pl  P3) => c_ + "ollien" ;--# notpresent
 VP (Impf Ind Sg  P3) => c_ + "ollia" ;--# notpresent
 VP (Impf Sub Pl  P1) => c_ + "ollíssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => c_ + "ollís" ;--# notpresent
 VP (Impf Sub Pl  P2) => c_ + "ollíssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => c_ + "ollissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => c_ + "ollissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => c_ + "ollís" ;--# notpresent
 VP (Fut Pl  P1)  => c_ + "ollirem" ;--# notpresent
 VP (Fut Sg  P1)  => c_ + "olliré" ;--# notpresent
 VP (Fut Pl  P2) => c_ + "ollireu" ;--# notpresent
 VP (Fut Sg  P2) => c_ + "olliràs" ;--# notpresent
 VP (Fut Pl  P3) => c_ + "olliran" ;--# notpresent
 VP (Fut Sg  P3) => c_ + "ollirà" ;--# notpresent
 VP (Pret Pl  P1)  => c_ + "ollíssim" ;--# notpresent
 VP (Pret Sg  P1)  => c_ + "ollís" ;--# notpresent
 VP (Pret Pl  P2) => c_ + "ollíssiu" ;--# notpresent
 VP (Pret Sg  P2) => c_ + "ollissis" ;--# notpresent
 VP (Pret Pl  P3) => c_ + "ollissin" ;--# notpresent
 VP (Pret Sg  P3) => c_ + "ollís" ;--# notpresent
 VP (Cond Pl  P1)  => c_ + "olliríem" ;--# notpresent
 VP (Cond Sg  P1)  => c_ + "olliria" ;--# notpresent
 VP (Cond Pl  P2) => c_ + "olliríeu" ;--# notpresent
 VP (Cond Sg  P2) => c_ + "olliries" ;--# notpresent
 VP (Cond Pl  P3) => c_ + "ollirien" ;--# notpresent
 VP (Cond Sg  P3) => c_ + "olliria" ;--# notpresent
 VP (Imp Pl  P1)  => c_ + "ollim" ;
 VP (Imp Pl  P2) => c_ + "olliu" ;
 VP (Imp Sg  P2) => c_ + "ull" ;
 VP (Imp Pl  P3) => c_ + "ullin" ;
 VP (Imp Sg  P3) => c_ + "ulli" ;
 VP (Pass Pl  Fem) => c_ + "ollides" ;
 VP (Pass Sg  Fem) => c_ + "ollida" ;
 VP (Pass Pl  Masc) => c_ + "ollits" ;
 VP (Pass Sg  Masc) => c_ + "ollit" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper començar_22 : Str -> Verbum = \començar ->
let comen_ = Predef.tk 3 començar in
{s = table { 
 VI Infn => comen_ + "çar" ;
 VI Ger => comen_ + "çant" ;
 VI Part =>  comen_ + "çat" ;
 VP (Pres Ind Pl  P1) => comen_ + "cem" ;
 VP (Pres Ind Sg  P1) => comen_ + "ço" ;
 VP (Pres Ind Pl  P2) => comen_ + "ceu" ;
 VP (Pres Ind Sg  P2) => comen_ + "ces" ;
 VP (Pres Ind Pl  P3) => comen_ + "cen" ;
 VP (Pres Ind Sg  P3) => comen_ + "ça" ;
 VP (Pres Sub Pl  P1) => comen_ + "cem" ;
 VP (Pres Sub Sg  P1) => comen_ + "ci" ;
 VP (Pres Sub Pl  P2) => comen_ + "ceu" ;
 VP (Pres Sub Sg  P2) => comen_ + "cis" ;
 VP (Pres Sub Pl  P3) => comen_ + "cin" ;
 VP (Pres Sub Sg  P3) => comen_ + "ci" ;
 VP (Impf Ind Pl  P1) => comen_ + "çàvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => comen_ + "çava" ;--# notpresent
 VP (Impf Ind Pl  P2) => comen_ + "çàveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => comen_ + "çaves" ;--# notpresent
 VP (Impf Ind Pl  P3) => comen_ + "çaven" ;--# notpresent
 VP (Impf Ind Sg  P3) => comen_ + "çava" ;--# notpresent
 VP (Impf Sub Pl  P1) => comen_ + "céssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => comen_ + "cés" ;--# notpresent
 VP (Impf Sub Pl  P2) => comen_ + "céssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => comen_ + "cessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => comen_ + "cessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => comen_ + "cés" ;--# notpresent
 VP (Fut Pl  P1)  => comen_ + "çarem" ;--# notpresent
 VP (Fut Sg  P1)  => comen_ + "çaré" ;--# notpresent
 VP (Fut Pl  P2) => comen_ + "çareu" ;--# notpresent
 VP (Fut Sg  P2) => comen_ + "çaràs" ;--# notpresent
 VP (Fut Pl  P3) => comen_ + "çaran" ;--# notpresent
 VP (Fut Sg  P3) => comen_ + "çarà" ;--# notpresent
 VP (Pret Pl  P1)  => comen_ + "céssim" ;--# notpresent
 VP (Pret Sg  P1)  => comen_ + "cés" ;--# notpresent
 VP (Pret Pl  P2) => comen_ + "céssiu" ;--# notpresent
 VP (Pret Sg  P2) => comen_ + "cessis" ;--# notpresent
 VP (Pret Pl  P3) => comen_ + "cessin" ;--# notpresent
 VP (Pret Sg  P3) => comen_ + "cés" ;--# notpresent
 VP (Cond Pl  P1)  => comen_ + "çaríem" ;--# notpresent
 VP (Cond Sg  P1)  => comen_ + "çaria" ;--# notpresent
 VP (Cond Pl  P2) => comen_ + "çaríeu" ;--# notpresent
 VP (Cond Sg  P2) => comen_ + "çaries" ;--# notpresent
 VP (Cond Pl  P3) => comen_ + "çarien" ;--# notpresent
 VP (Cond Sg  P3) => comen_ + "çaria" ;--# notpresent
 VP (Imp Pl  P1)  => comen_ + "cem" ;
 VP (Imp Pl  P2) => comen_ + "ceu" ;
 VP (Imp Sg  P2) => comen_ + "ça" ;
 VP (Imp Pl  P3) => comen_ + "cin" ;
 VP (Imp Sg  P3) => comen_ + "ci" ;
 VP (Pass Pl  Fem) => comen_ + "çades" ;
 VP (Pass Sg  Fem) => comen_ + "çada" ;
 VP (Pass Pl  Masc) => comen_ + "çats" ;
 VP (Pass Sg  Masc) => comen_ + "çat" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper commoure_23 : Str -> Verbum = \commoure ->
let commo_ = Predef.tk 3 commoure in
{s = table { 
 VI Infn => commo_ + "ure" ;
 VI Ger => commo_ + "vent" ;
 VI Part =>  commo_ + "gut" ;
 VP (Pres Ind Pl  P1) => commo_ + "vem" ;
 VP (Pres Ind Sg  P1) => commo_ + "c" ;
 VP (Pres Ind Pl  P2) => commo_ + "veu" ;
 VP (Pres Ind Sg  P2) => commo_ + "us" ;
 VP (Pres Ind Pl  P3) => commo_ + "uen" ;
 VP (Pres Ind Sg  P3) => commo_ + "u" ;
 VP (Pres Sub Pl  P1) => commo_ + "guem" ;
 VP (Pres Sub Sg  P1) => commo_ + "gui" ;
 VP (Pres Sub Pl  P2) => commo_ + "gueu" ;
 VP (Pres Sub Sg  P2) => commo_ + "guis" ;
 VP (Pres Sub Pl  P3) => commo_ + "guin" ;
 VP (Pres Sub Sg  P3) => commo_ + "gui" ;
 VP (Impf Ind Pl  P1) => commo_ + "víem" ;--# notpresent
 VP (Impf Ind Sg  P1) => commo_ + "via" ;--# notpresent
 VP (Impf Ind Pl  P2) => commo_ + "víeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => commo_ + "vies" ;--# notpresent
 VP (Impf Ind Pl  P3) => commo_ + "vien" ;--# notpresent
 VP (Impf Ind Sg  P3) => commo_ + "via" ;--# notpresent
 VP (Impf Sub Pl  P1) => commo_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => commo_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => commo_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => commo_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => commo_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => commo_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => commo_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => commo_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => commo_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => commo_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => commo_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => commo_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => commo_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => commo_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => commo_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => commo_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => commo_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => commo_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => commo_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => commo_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => commo_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => commo_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => commo_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => commo_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => commo_ + "guem" ;
 VP (Imp Pl  P2) => commo_ + "veu" ;
 VP (Imp Sg  P2) => commo_ + "u" ;
 VP (Imp Pl  P3) => commo_ + "guin" ;
 VP (Imp Sg  P3) => commo_ + "gui" ;
 VP (Pass Pl  Fem) => commo_ + "gudes" ;
 VP (Pass Sg  Fem) => commo_ + "guda" ;
 VP (Pass Pl  Masc) => commo_ + "guts" ;
 VP (Pass Sg  Masc) => commo_ + "gut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper complaure_24 : Str -> Verbum = \complaure ->
let compla_ = Predef.tk 3 complaure in
{s = table { 
 VI Infn => compla_ + "ure" ;
 VI Ger => compla_ + "ent" ;
 VI Part =>  compla_ + "gut" ;
 VP (Pres Ind Pl  P1) => compla_ + "em" ;
 VP (Pres Ind Sg  P1) => compla_ + "c" ;
 VP (Pres Ind Pl  P2) => compla_ + "eu" ;
 VP (Pres Ind Sg  P2) => compla_ + "us" ;
 VP (Pres Ind Pl  P3) => compla_ + "uen" ;
 VP (Pres Ind Sg  P3) => compla_ + "u" ;
 VP (Pres Sub Pl  P1) => compla_ + "guem" ;
 VP (Pres Sub Sg  P1) => compla_ + "gui" ;
 VP (Pres Sub Pl  P2) => compla_ + "gueu" ;
 VP (Pres Sub Sg  P2) => compla_ + "guis" ;
 VP (Pres Sub Pl  P3) => compla_ + "guin" ;
 VP (Pres Sub Sg  P3) => compla_ + "gui" ;
 VP (Impf Ind Pl  P1) => compla_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => compla_ + "ïa" ;--# notpresent
 VP (Impf Ind Pl  P2) => compla_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => compla_ + "ïes" ;--# notpresent
 VP (Impf Ind Pl  P3) => compla_ + "ïen" ;--# notpresent
 VP (Impf Ind Sg  P3) => compla_ + "ïa" ;--# notpresent
 VP (Impf Sub Pl  P1) => compla_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => compla_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => compla_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => compla_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => compla_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => compla_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => compla_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => compla_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => compla_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => compla_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => compla_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => compla_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => compla_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => compla_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => compla_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => compla_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => compla_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => compla_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => compla_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => compla_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => compla_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => compla_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => compla_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => compla_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => compla_ + "guem" ;
 VP (Imp Pl  P2) => compla_ + "eu" ;
 VP (Imp Sg  P2) => compla_ + "u" ;
 VP (Imp Pl  P3) => compla_ + "guin" ;
 VP (Imp Sg  P3) => compla_ + "gui" ;
 VP (Pass Pl  Fem) => compla_ + "gudes" ;
 VP (Pass Sg  Fem) => compla_ + "guda" ;
 VP (Pass Pl  Masc) => compla_ + "guts" ;
 VP (Pass Sg  Masc) => compla_ + "gut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper complir_25 : Str -> Verbum = \complir ->
let compl_ = Predef.tk 2 complir in
{s = table { 
 VI Infn => compl_ + "ir" ;
 VI Ger => compl_ + "int" ;
 VI Part =>  compl_ + "ert" ;
 VP (Pres Ind Pl  P1) => compl_ + "im" ;
 VP (Pres Ind Sg  P1) => compl_ + "eixo" ;
 VP (Pres Ind Pl  P2) => compl_ + "iu" ;
 VP (Pres Ind Sg  P2) => compl_ + "eixes" ;
 VP (Pres Ind Pl  P3) => compl_ + "eixen" ;
 VP (Pres Ind Sg  P3) => compl_ + "eix" ;
 VP (Pres Sub Pl  P1) => compl_ + "im" ;
 VP (Pres Sub Sg  P1) => compl_ + "eixi" ;
 VP (Pres Sub Pl  P2) => compl_ + "iu" ;
 VP (Pres Sub Sg  P2) => compl_ + "eixis" ;
 VP (Pres Sub Pl  P3) => compl_ + "eixin" ;
 VP (Pres Sub Sg  P3) => compl_ + "eixi" ;
 VP (Impf Ind Pl  P1) => compl_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => compl_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => compl_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => compl_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => compl_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => compl_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => compl_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => compl_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => compl_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => compl_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => compl_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => compl_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => compl_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => compl_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => compl_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => compl_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => compl_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => compl_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => compl_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => compl_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => compl_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => compl_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => compl_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => compl_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => compl_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => compl_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => compl_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => compl_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => compl_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => compl_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => compl_ + "im" ;
 VP (Imp Pl  P2) => compl_ + "iu" ;
 VP (Imp Sg  P2) => compl_ + "eix" ;
 VP (Imp Pl  P3) => compl_ + "eixin" ;
 VP (Imp Sg  P3) => compl_ + "eixi" ;
 VP (Pass Pl  Fem) => compl_ + "ertes" ;
 VP (Pass Sg  Fem) => compl_ + "erta" ;
 VP (Pass Pl  Masc) => compl_ + "erts" ;
 VP (Pass Sg  Masc) => compl_ + "ert" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper compondre_26 : Str -> Verbum = \compondre ->
let compo_ = Predef.tk 4 compondre in
{s = table { 
 VI Infn => compo_ + "ndre" ;
 VI Ger => compo_ + "nent" ;
 VI Part =>  compo_ + "st" ;
 VP (Pres Ind Pl  P1) => compo_ + "nem" ;
 VP (Pres Ind Sg  P1) => compo_ + "nc" ;
 VP (Pres Ind Pl  P2) => compo_ + "neu" ;
 VP (Pres Ind Sg  P2) => compo_ + "ns" ;
 VP (Pres Ind Pl  P3) => compo_ + "nen" ;
 VP (Pres Ind Sg  P3) => compo_ + "n" ;
 VP (Pres Sub Pl  P1) => compo_ + "nguem" ;
 VP (Pres Sub Sg  P1) => compo_ + "ngui" ;
 VP (Pres Sub Pl  P2) => compo_ + "ngueu" ;
 VP (Pres Sub Sg  P2) => compo_ + "nguis" ;
 VP (Pres Sub Pl  P3) => compo_ + "nguin" ;
 VP (Pres Sub Sg  P3) => compo_ + "ngui" ;
 VP (Impf Ind Pl  P1) => compo_ + "níem" ;--# notpresent
 VP (Impf Ind Sg  P1) => compo_ + "nia" ;--# notpresent
 VP (Impf Ind Pl  P2) => compo_ + "níeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => compo_ + "nies" ;--# notpresent
 VP (Impf Ind Pl  P3) => compo_ + "nien" ;--# notpresent
 VP (Impf Ind Sg  P3) => compo_ + "nia" ;--# notpresent
 VP (Impf Sub Pl  P1) => compo_ + "nguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => compo_ + "ngués" ;--# notpresent
 VP (Impf Sub Pl  P2) => compo_ + "nguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => compo_ + "nguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => compo_ + "nguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => compo_ + "ngués" ;--# notpresent
 VP (Fut Pl  P1)  => compo_ + "ndrem" ;--# notpresent
 VP (Fut Sg  P1)  => compo_ + "ndré" ;--# notpresent
 VP (Fut Pl  P2) => compo_ + "ndreu" ;--# notpresent
 VP (Fut Sg  P2) => compo_ + "ndràs" ;--# notpresent
 VP (Fut Pl  P3) => compo_ + "ndran" ;--# notpresent
 VP (Fut Sg  P3) => compo_ + "ndrà" ;--# notpresent
 VP (Pret Pl  P1)  => compo_ + "nguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => compo_ + "ngués" ;--# notpresent
 VP (Pret Pl  P2) => compo_ + "nguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => compo_ + "nguessis" ;--# notpresent
 VP (Pret Pl  P3) => compo_ + "nguessin" ;--# notpresent
 VP (Pret Sg  P3) => compo_ + "ngués" ;--# notpresent
 VP (Cond Pl  P1)  => compo_ + "ndríem" ;--# notpresent
 VP (Cond Sg  P1)  => compo_ + "ndria" ;--# notpresent
 VP (Cond Pl  P2) => compo_ + "ndríeu" ;--# notpresent
 VP (Cond Sg  P2) => compo_ + "ndries" ;--# notpresent
 VP (Cond Pl  P3) => compo_ + "ndrien" ;--# notpresent
 VP (Cond Sg  P3) => compo_ + "ndria" ;--# notpresent
 VP (Imp Pl  P1)  => compo_ + "nguem" ;
 VP (Imp Pl  P2) => compo_ + "neu" ;
 VP (Imp Sg  P2) => compo_ + "n" ;
 VP (Imp Pl  P3) => compo_ + "nguin" ;
 VP (Imp Sg  P3) => compo_ + "ngui" ;
 VP (Pass Pl  Fem) => compo_ + "stes" ;
 VP (Pass Sg  Fem) => compo_ + "sta" ;
 VP (Pass Pl  Masc) => compo_ + "sts" ;
 VP (Pass Sg  Masc) => compo_ + "st" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper conèixer_27 : Str -> Verbum = \conèixer ->
let con_ = Predef.tk 5 conèixer in
{s = table { 
 VI Ger => con_ + "eixent" ;
 VI Part =>  con_ + "egut" ;
 VP (Pres Ind Pl  P1) => con_ + "eixem" ;
 VP (Pres Ind Sg  P1) => con_ + "ec" ;
 VP (Pres Ind Pl  P2) => con_ + "eixeu" ;
 VP (Pres Ind Sg  P2) => con_ + "eixes" ;
 VP (Pres Ind Pl  P3) => con_ + "eixen" ;
 VP (Pres Ind Sg  P3) => con_ + "eix" ;
 VP (Pres Sub Pl  P1) => con_ + "eguem" ;
 VP (Pres Sub Sg  P1) => con_ + "egui" ;
 VP (Pres Sub Pl  P2) => con_ + "egueu" ;
 VP (Pres Sub Sg  P2) => con_ + "eguis" ;
 VP (Pres Sub Pl  P3) => con_ + "eguin" ;
 VP (Pres Sub Sg  P3) => con_ + "egui" ;
 VP (Impf Ind Pl  P1) => con_ + "eixíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => con_ + "eixia" ;--# notpresent
 VP (Impf Ind Pl  P2) => con_ + "eixíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => con_ + "eixies" ;--# notpresent
 VP (Impf Ind Pl  P3) => con_ + "eixien" ;--# notpresent
 VP (Impf Ind Sg  P3) => con_ + "eixia" ;--# notpresent
 VP (Impf Sub Pl  P1) => con_ + "eguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => con_ + "egués" ;--# notpresent
 VP (Impf Sub Pl  P2) => con_ + "eguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => con_ + "eguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => con_ + "eguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => con_ + "egués" ;--# notpresent
 VP (Fut Pl  P1)  => con_ + "eixerem" ;--# notpresent
 VP (Fut Sg  P1)  => con_ + "eixeré" ;--# notpresent
 VP (Fut Pl  P2) => con_ + "eixereu" ;--# notpresent
 VP (Fut Sg  P2) => con_ + "eixeràs" ;--# notpresent
 VP (Fut Pl  P3) => con_ + "eixeran" ;--# notpresent
 VP (Fut Sg  P3) => con_ + "eixerà" ;--# notpresent
 VP (Pret Pl  P1)  => con_ + "eguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => con_ + "egués" ;--# notpresent
 VP (Pret Pl  P2) => con_ + "eguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => con_ + "eguessis" ;--# notpresent
 VP (Pret Pl  P3) => con_ + "eguessin" ;--# notpresent
 VP (Pret Sg  P3) => con_ + "egués" ;--# notpresent
 VP (Cond Pl  P1)  => con_ + "eixeríem" ;--# notpresent
 VP (Cond Sg  P1)  => con_ + "eixeria" ;--# notpresent
 VP (Cond Pl  P2) => con_ + "eixeríeu" ;--# notpresent
 VP (Cond Sg  P2) => con_ + "eixeries" ;--# notpresent
 VP (Cond Pl  P3) => con_ + "eixerien" ;--# notpresent
 VP (Cond Sg  P3) => con_ + "eixeria" ;--# notpresent
 VP (Imp Pl  P1)  => con_ + "eguem" ;
 VP (Imp Pl  P2) => con_ + "eixeu" ;
 VP (Imp Sg  P2) => con_ + "eix" ;
 VP (Imp Pl  P3) => con_ + "eguin" ;
 VP (Imp Sg  P3) => con_ + "egui" ;
 VP (Pass Pl  Fem) => con_ + "egudes" ;
 VP (Pass Sg  Fem) => con_ + "eguda" ;
 VP (Pass Pl  Masc) => con_ + "eguts" ;
 VP (Pass Sg  Masc) => con_ + "egut" ;
 VI Infn => con_ + "èixer" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper confondre_28 : Str -> Verbum = \confondre ->
let conf_ = Predef.tk 5 confondre in
{s = table { 
 VI Infn => conf_ + "ondre" ;
 VI Ger => conf_ + "onent" ;
 VP (Pres Ind Pl  P1) => conf_ + "onem" ;
 VP (Pres Ind Sg  P1) => conf_ + "onc" ;
 VP (Pres Ind Pl  P2) => conf_ + "oneu" ;
 VP (Pres Ind Sg  P2) => conf_ + "ons" ;
 VP (Pres Ind Pl  P3) => conf_ + "onen" ;
 VP (Pres Ind Sg  P3) => conf_ + "on" ;
 VP (Pres Sub Pl  P1) => conf_ + "onguem" ;
 VP (Pres Sub Sg  P1) => conf_ + "ongui" ;
 VP (Pres Sub Pl  P2) => conf_ + "ongueu" ;
 VP (Pres Sub Sg  P2) => conf_ + "onguis" ;
 VP (Pres Sub Pl  P3) => conf_ + "onguin" ;
 VP (Pres Sub Sg  P3) => conf_ + "ongui" ;
 VP (Impf Ind Pl  P1) => conf_ + "oníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => conf_ + "onia" ;--# notpresent
 VP (Impf Ind Pl  P2) => conf_ + "oníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => conf_ + "onies" ;--# notpresent
 VP (Impf Ind Pl  P3) => conf_ + "onien" ;--# notpresent
 VP (Impf Ind Sg  P3) => conf_ + "onia" ;--# notpresent
 VP (Impf Sub Pl  P1) => conf_ + "onguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => conf_ + "ongués" ;--# notpresent
 VP (Impf Sub Pl  P2) => conf_ + "onguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => conf_ + "onguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => conf_ + "onguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => conf_ + "ongués" ;--# notpresent
 VP (Fut Pl  P1)  => conf_ + "ondrem" ;--# notpresent
 VP (Fut Sg  P1)  => conf_ + "ondré" ;--# notpresent
 VP (Fut Pl  P2) => conf_ + "ondreu" ;--# notpresent
 VP (Fut Sg  P2) => conf_ + "ondràs" ;--# notpresent
 VP (Fut Pl  P3) => conf_ + "ondran" ;--# notpresent
 VP (Fut Sg  P3) => conf_ + "ondrà" ;--# notpresent
 VP (Pret Pl  P1)  => conf_ + "onguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => conf_ + "ongués" ;--# notpresent
 VP (Pret Pl  P2) => conf_ + "onguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => conf_ + "onguessis" ;--# notpresent
 VP (Pret Pl  P3) => conf_ + "onguessin" ;--# notpresent
 VP (Pret Sg  P3) => conf_ + "ongués" ;--# notpresent
 VP (Cond Pl  P1)  => conf_ + "ondríem" ;--# notpresent
 VP (Cond Sg  P1)  => conf_ + "ondria" ;--# notpresent
 VP (Cond Pl  P2) => conf_ + "ondríeu" ;--# notpresent
 VP (Cond Sg  P2) => conf_ + "ondries" ;--# notpresent
 VP (Cond Pl  P3) => conf_ + "ondrien" ;--# notpresent
 VP (Cond Sg  P3) => conf_ + "ondria" ;--# notpresent
 VP (Imp Pl  P1)  => conf_ + "onguem" ;
 VP (Imp Pl  P2) => conf_ + "oneu" ;
 VP (Imp Sg  P2) => conf_ + "on" ;
 VP (Imp Pl  P3) => conf_ + "onguin" ;
 VP (Imp Sg  P3) => conf_ + "ongui" ;
 VP (Pass Pl  Fem) => conf_ + "oses" ;
 VP (Pass Sg  Fem) => conf_ + "osa" ;
 VP (Pass Pl  Masc) => conf_ + "osos" ;
 VI Part =>  conf_ + "ós" ;
 VP (Pass Sg  Masc) => conf_ + "ós" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper constrènyer_29 : Str -> Verbum = \constrènyer ->
let constr_ = Predef.tk 5 constrènyer in
{s = table { 
 VI Ger => constr_ + "enyent" ;
 VI Part =>  constr_ + "et" ;
 VP (Pres Ind Pl  P1) => constr_ + "enyem" ;
 VP (Pres Ind Sg  P1) => constr_ + "enyo" ;
 VP (Pres Ind Pl  P2) => constr_ + "enyeu" ;
 VP (Pres Ind Sg  P2) => constr_ + "enys" ;
 VP (Pres Ind Pl  P3) => constr_ + "enyen" ;
 VP (Pres Ind Sg  P3) => constr_ + "eny" ;
 VP (Pres Sub Pl  P1) => constr_ + "enyem" ;
 VP (Pres Sub Sg  P1) => constr_ + "enyi" ;
 VP (Pres Sub Pl  P2) => constr_ + "enyeu" ;
 VP (Pres Sub Sg  P2) => constr_ + "enyis" ;
 VP (Pres Sub Pl  P3) => constr_ + "enyin" ;
 VP (Pres Sub Sg  P3) => constr_ + "enyi" ;
 VP (Impf Ind Pl  P1) => constr_ + "enyíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => constr_ + "enyia" ;--# notpresent
 VP (Impf Ind Pl  P2) => constr_ + "enyíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => constr_ + "enyies" ;--# notpresent
 VP (Impf Ind Pl  P3) => constr_ + "enyien" ;--# notpresent
 VP (Impf Ind Sg  P3) => constr_ + "enyia" ;--# notpresent
 VP (Impf Sub Pl  P1) => constr_ + "enyéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => constr_ + "enyés" ;--# notpresent
 VP (Impf Sub Pl  P2) => constr_ + "enyéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => constr_ + "enyessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => constr_ + "enyessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => constr_ + "enyés" ;--# notpresent
 VP (Fut Pl  P1)  => constr_ + "enyerem" ;--# notpresent
 VP (Fut Sg  P1)  => constr_ + "enyeré" ;--# notpresent
 VP (Fut Pl  P2) => constr_ + "enyereu" ;--# notpresent
 VP (Fut Sg  P2) => constr_ + "enyeràs" ;--# notpresent
 VP (Fut Pl  P3) => constr_ + "enyeran" ;--# notpresent
 VP (Fut Sg  P3) => constr_ + "enyerà" ;--# notpresent
 VP (Pret Pl  P1)  => constr_ + "enyéssim" ;--# notpresent
 VP (Pret Sg  P1)  => constr_ + "enyés" ;--# notpresent
 VP (Pret Pl  P2) => constr_ + "enyéssiu" ;--# notpresent
 VP (Pret Sg  P2) => constr_ + "enyessis" ;--# notpresent
 VP (Pret Pl  P3) => constr_ + "enyessin" ;--# notpresent
 VP (Pret Sg  P3) => constr_ + "enyés" ;--# notpresent
 VP (Cond Pl  P1)  => constr_ + "enyeríem" ;--# notpresent
 VP (Cond Sg  P1)  => constr_ + "enyeria" ;--# notpresent
 VP (Cond Pl  P2) => constr_ + "enyeríeu" ;--# notpresent
 VP (Cond Sg  P2) => constr_ + "enyeries" ;--# notpresent
 VP (Cond Pl  P3) => constr_ + "enyerien" ;--# notpresent
 VP (Cond Sg  P3) => constr_ + "enyeria" ;--# notpresent
 VP (Imp Pl  P1)  => constr_ + "enyem" ;
 VP (Imp Pl  P2) => constr_ + "enyeu" ;
 VP (Imp Sg  P2) => constr_ + "eny" ;
 VP (Imp Pl  P3) => constr_ + "enyin" ;
 VP (Imp Sg  P3) => constr_ + "enyi" ;
 VP (Pass Pl  Fem) => constr_ + "etes" ;
 VP (Pass Sg  Fem) => constr_ + "eta" ;
 VP (Pass Pl  Masc) => constr_ + "ets" ;
 VP (Pass Sg  Masc) => constr_ + "et" ;
 VI Infn => constr_ + "ènyer" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper córrer_30 : Str -> Verbum = \córrer ->
let c_ = Predef.tk 5 córrer in
{s = table { 
 VI Ger => c_ + "orrent" ;
 VI Part =>  c_ + "orregut" ;
 VP (Pres Ind Pl  P1) => c_ + "orrem" ;
 VP (Pres Ind Sg  P1) => c_ + "orro" ;
 VP (Pres Ind Pl  P2) => c_ + "orreu" ;
 VP (Pres Ind Sg  P2) => c_ + "orres" ;
 VP (Pres Ind Pl  P3) => c_ + "orren" ;
 VP (Pres Ind Sg  P3) => c_ + "orre" ;
 VP (Pres Sub Pl  P1) => c_ + "orrem" ;
 VP (Pres Sub Sg  P1) => c_ + "orri" ;
 VP (Pres Sub Pl  P2) => c_ + "orreu" ;
 VP (Pres Sub Sg  P2) => c_ + "orris" ;
 VP (Pres Sub Pl  P3) => c_ + "orrin" ;
 VP (Pres Sub Sg  P3) => c_ + "orri" ;
 VP (Impf Ind Pl  P1) => c_ + "orríem" ;--# notpresent
 VP (Impf Ind Sg  P1) => c_ + "orria" ;--# notpresent
 VP (Impf Ind Pl  P2) => c_ + "orríeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => c_ + "orries" ;--# notpresent
 VP (Impf Ind Pl  P3) => c_ + "orrien" ;--# notpresent
 VP (Impf Ind Sg  P3) => c_ + "orria" ;--# notpresent
 VP (Impf Sub Pl  P1) => c_ + "orreguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => c_ + "orregués" ;--# notpresent
 VP (Impf Sub Pl  P2) => c_ + "orreguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => c_ + "orreguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => c_ + "orreguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => c_ + "orregués" ;--# notpresent
 VP (Fut Pl  P1)  => c_ + "orrerem" ;--# notpresent
 VP (Fut Sg  P1)  => c_ + "orreré" ;--# notpresent
 VP (Fut Pl  P2) => c_ + "orrereu" ;--# notpresent
 VP (Fut Sg  P2) => c_ + "orreràs" ;--# notpresent
 VP (Fut Pl  P3) => c_ + "orreran" ;--# notpresent
 VP (Fut Sg  P3) => c_ + "orrerà" ;--# notpresent
 VP (Pret Pl  P1)  => c_ + "orreguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => c_ + "orregués" ;--# notpresent
 VP (Pret Pl  P2) => c_ + "orreguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => c_ + "orreguessis" ;--# notpresent
 VP (Pret Pl  P3) => c_ + "orreguessin" ;--# notpresent
 VP (Pret Sg  P3) => c_ + "orregués" ;--# notpresent
 VP (Cond Pl  P1)  => c_ + "orreríem" ;--# notpresent
 VP (Cond Sg  P1)  => c_ + "orreria" ;--# notpresent
 VP (Cond Pl  P2) => c_ + "orreríeu" ;--# notpresent
 VP (Cond Sg  P2) => c_ + "orreries" ;--# notpresent
 VP (Cond Pl  P3) => c_ + "orrerien" ;--# notpresent
 VP (Cond Sg  P3) => c_ + "orreria" ;--# notpresent
 VP (Imp Pl  P1)  => c_ + "orrem" ;
 VP (Imp Pl  P2) => c_ + "orreu" ;
 VP (Imp Sg  P2) => c_ + "orre" ;
 VP (Imp Pl  P3) => c_ + "orrin" ;
 VP (Imp Sg  P3) => c_ + "orri" ;
 VP (Pass Pl  Fem) => c_ + "orregudes" ;
 VP (Pass Sg  Fem) => c_ + "orreguda" ;
 VP (Pass Pl  Masc) => c_ + "orreguts" ;
 VP (Pass Sg  Masc) => c_ + "orregut" ;
 VI Infn => c_ + "órrer" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper cosir_31 : Str -> Verbum = \cosir ->
let c_ = Predef.tk 4 cosir in
{s = table { 
 VI Infn => c_ + "osir" ;
 VI Ger => c_ + "osint" ;
 VI Part =>  c_ + "osit" ;
 VP (Pres Ind Pl  P1) => c_ + "osim" ;
 VP (Pres Ind Sg  P1) => c_ + "uso" ;
 VP (Pres Ind Pl  P2) => c_ + "osiu" ;
 VP (Pres Ind Sg  P2) => c_ + "uses" ;
 VP (Pres Ind Pl  P3) => c_ + "usen" ;
 VP (Pres Ind Sg  P3) => c_ + "us" ;
 VP (Pres Sub Pl  P1) => c_ + "osim" ;
 VP (Pres Sub Sg  P1) => c_ + "usi" ;
 VP (Pres Sub Pl  P2) => c_ + "osiu" ;
 VP (Pres Sub Sg  P2) => c_ + "usis" ;
 VP (Pres Sub Pl  P3) => c_ + "usin" ;
 VP (Pres Sub Sg  P3) => c_ + "usi" ;
 VP (Impf Ind Pl  P1) => c_ + "osíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => c_ + "osia" ;--# notpresent
 VP (Impf Ind Pl  P2) => c_ + "osíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => c_ + "osies" ;--# notpresent
 VP (Impf Ind Pl  P3) => c_ + "osien" ;--# notpresent
 VP (Impf Ind Sg  P3) => c_ + "osia" ;--# notpresent
 VP (Impf Sub Pl  P1) => c_ + "osíssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => c_ + "osís" ;--# notpresent
 VP (Impf Sub Pl  P2) => c_ + "osíssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => c_ + "osissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => c_ + "osissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => c_ + "osís" ;--# notpresent
 VP (Fut Pl  P1)  => c_ + "osirem" ;--# notpresent
 VP (Fut Sg  P1)  => c_ + "osiré" ;--# notpresent
 VP (Fut Pl  P2) => c_ + "osireu" ;--# notpresent
 VP (Fut Sg  P2) => c_ + "osiràs" ;--# notpresent
 VP (Fut Pl  P3) => c_ + "osiran" ;--# notpresent
 VP (Fut Sg  P3) => c_ + "osirà" ;--# notpresent
 VP (Pret Pl  P1)  => c_ + "osíssim" ;--# notpresent
 VP (Pret Sg  P1)  => c_ + "osís" ;--# notpresent
 VP (Pret Pl  P2) => c_ + "osíssiu" ;--# notpresent
 VP (Pret Sg  P2) => c_ + "osissis" ;--# notpresent
 VP (Pret Pl  P3) => c_ + "osissin" ;--# notpresent
 VP (Pret Sg  P3) => c_ + "osís" ;--# notpresent
 VP (Cond Pl  P1)  => c_ + "osiríem" ;--# notpresent
 VP (Cond Sg  P1)  => c_ + "osiria" ;--# notpresent
 VP (Cond Pl  P2) => c_ + "osiríeu" ;--# notpresent
 VP (Cond Sg  P2) => c_ + "osiries" ;--# notpresent
 VP (Cond Pl  P3) => c_ + "osirien" ;--# notpresent
 VP (Cond Sg  P3) => c_ + "osiria" ;--# notpresent
 VP (Imp Pl  P1)  => c_ + "osim" ;
 VP (Imp Pl  P2) => c_ + "osiu" ;
 VP (Imp Sg  P2) => c_ + "us" ;
 VP (Imp Pl  P3) => c_ + "usin" ;
 VP (Imp Sg  P3) => c_ + "usi" ;
 VP (Pass Pl  Fem) => c_ + "osides" ;
 VP (Pass Sg  Fem) => c_ + "osida" ;
 VP (Pass Pl  Masc) => c_ + "osits" ;
 VP (Pass Sg  Masc) => c_ + "osit" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper coure_32 : Str -> Verbum = \coure ->
let c_ = Predef.tk 4 coure in
{s = table { 
 VI Infn => c_ + "oure" ;
 VI Ger => c_ + "oent" ;
 VI Part =>  c_ + "uit" ;
 VP (Pres Ind Pl  P1) => c_ + "oem" ;
 VP (Pres Ind Sg  P1) => c_ + "oc" ;
 VP (Pres Ind Pl  P2) => c_ + "oeu" ;
 VP (Pres Ind Sg  P2) => c_ + "ous" ;
 VP (Pres Ind Pl  P3) => c_ + "ouen" ;
 VP (Pres Ind Sg  P3) => c_ + "ou" ;
 VP (Pres Sub Pl  P1) => c_ + "oguem" ;
 VP (Pres Sub Sg  P1) => c_ + "ogui" ;
 VP (Pres Sub Pl  P2) => c_ + "ogueu" ;
 VP (Pres Sub Sg  P2) => c_ + "oguis" ;
 VP (Pres Sub Pl  P3) => c_ + "oguin" ;
 VP (Pres Sub Sg  P3) => c_ + "ogui" ;
 VP (Impf Ind Pl  P1) => c_ + "oíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => c_ + "oïa" ;--# notpresent
 VP (Impf Ind Pl  P2) => c_ + "oíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => c_ + "oïes" ;--# notpresent
 VP (Impf Ind Pl  P3) => c_ + "oïen" ;--# notpresent
 VP (Impf Ind Sg  P3) => c_ + "oïa" ;--# notpresent
 VP (Impf Sub Pl  P1) => c_ + "oguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => c_ + "ogués" ;--# notpresent
 VP (Impf Sub Pl  P2) => c_ + "oguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => c_ + "oguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => c_ + "oguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => c_ + "ogués" ;--# notpresent
 VP (Fut Pl  P1)  => c_ + "ourem" ;--# notpresent
 VP (Fut Sg  P1)  => c_ + "ouré" ;--# notpresent
 VP (Fut Pl  P2) => c_ + "oureu" ;--# notpresent
 VP (Fut Sg  P2) => c_ + "ouràs" ;--# notpresent
 VP (Fut Pl  P3) => c_ + "ouran" ;--# notpresent
 VP (Fut Sg  P3) => c_ + "ourà" ;--# notpresent
 VP (Pret Pl  P1)  => c_ + "oguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => c_ + "ogués" ;--# notpresent
 VP (Pret Pl  P2) => c_ + "oguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => c_ + "oguessis" ;--# notpresent
 VP (Pret Pl  P3) => c_ + "oguessin" ;--# notpresent
 VP (Pret Sg  P3) => c_ + "ogués" ;--# notpresent
 VP (Cond Pl  P1)  => c_ + "ouríem" ;--# notpresent
 VP (Cond Sg  P1)  => c_ + "ouria" ;--# notpresent
 VP (Cond Pl  P2) => c_ + "ouríeu" ;--# notpresent
 VP (Cond Sg  P2) => c_ + "ouries" ;--# notpresent
 VP (Cond Pl  P3) => c_ + "ourien" ;--# notpresent
 VP (Cond Sg  P3) => c_ + "ouria" ;--# notpresent
 VP (Imp Pl  P1)  => c_ + "oguem" ;
 VP (Imp Pl  P2) => c_ + "oeu" ;
 VP (Imp Sg  P2) => c_ + "ou" ;
 VP (Imp Pl  P3) => c_ + "oguin" ;
 VP (Imp Sg  P3) => c_ + "ogui" ;
 VP (Pass Pl  Fem) => c_ + "uites" ;
 VP (Pass Sg  Fem) => c_ + "uita" ;
 VP (Pass Pl  Masc) => c_ + "uits" ;
 VP (Pass Sg  Masc) => c_ + "uit" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper créixer_33 : Str -> Verbum = \créixer ->
let cr_ = Predef.tk 5 créixer in
{s = table { 
 VI Ger => cr_ + "eixent" ;
 VI Part =>  cr_ + "escut" ;
 VP (Pres Ind Pl  P1) => cr_ + "eixem" ;
 VP (Pres Ind Sg  P1) => cr_ + "eixo" ;
 VP (Pres Ind Pl  P2) => cr_ + "eixeu" ;
 VP (Pres Ind Sg  P2) => cr_ + "eixes" ;
 VP (Pres Ind Pl  P3) => cr_ + "eixen" ;
 VP (Pres Ind Sg  P3) => cr_ + "eix" ;
 VP (Pres Sub Pl  P1) => cr_ + "eixem" ;
 VP (Pres Sub Sg  P1) => cr_ + "eixi" ;
 VP (Pres Sub Pl  P2) => cr_ + "eixeu" ;
 VP (Pres Sub Sg  P2) => cr_ + "eixis" ;
 VP (Pres Sub Pl  P3) => cr_ + "eixin" ;
 VP (Pres Sub Sg  P3) => cr_ + "eixi" ;
 VP (Impf Ind Pl  P1) => cr_ + "eixíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => cr_ + "eixia" ;--# notpresent
 VP (Impf Ind Pl  P2) => cr_ + "eixíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => cr_ + "eixies" ;--# notpresent
 VP (Impf Ind Pl  P3) => cr_ + "eixien" ;--# notpresent
 VP (Impf Ind Sg  P3) => cr_ + "eixia" ;--# notpresent
 VP (Impf Sub Pl  P1) => cr_ + "eixéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => cr_ + "eixés" ;--# notpresent
 VP (Impf Sub Pl  P2) => cr_ + "eixéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => cr_ + "eixessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => cr_ + "eixessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => cr_ + "eixés" ;--# notpresent
 VP (Fut Pl  P1)  => cr_ + "eixerem" ;--# notpresent
 VP (Fut Sg  P1)  => cr_ + "eixeré" ;--# notpresent
 VP (Fut Pl  P2) => cr_ + "eixereu" ;--# notpresent
 VP (Fut Sg  P2) => cr_ + "eixeràs" ;--# notpresent
 VP (Fut Pl  P3) => cr_ + "eixeran" ;--# notpresent
 VP (Fut Sg  P3) => cr_ + "eixerà" ;--# notpresent
 VP (Pret Pl  P1)  => cr_ + "eixéssim" ;--# notpresent
 VP (Pret Sg  P1)  => cr_ + "eixés" ;--# notpresent
 VP (Pret Pl  P2) => cr_ + "eixéssiu" ;--# notpresent
 VP (Pret Sg  P2) => cr_ + "eixessis" ;--# notpresent
 VP (Pret Pl  P3) => cr_ + "eixessin" ;--# notpresent
 VP (Pret Sg  P3) => cr_ + "eixés" ;--# notpresent
 VP (Cond Pl  P1)  => cr_ + "eixeríem" ;--# notpresent
 VP (Cond Sg  P1)  => cr_ + "eixeria" ;--# notpresent
 VP (Cond Pl  P2) => cr_ + "eixeríeu" ;--# notpresent
 VP (Cond Sg  P2) => cr_ + "eixeries" ;--# notpresent
 VP (Cond Pl  P3) => cr_ + "eixerien" ;--# notpresent
 VP (Cond Sg  P3) => cr_ + "eixeria" ;--# notpresent
 VP (Imp Pl  P1)  => cr_ + "eixem" ;
 VP (Imp Pl  P2) => cr_ + "eixeu" ;
 VP (Imp Sg  P2) => cr_ + "eix" ;
 VP (Imp Pl  P3) => cr_ + "eixin" ;
 VP (Imp Sg  P3) => cr_ + "eixi" ;
 VP (Pass Pl  Fem) => cr_ + "escudes" ;
 VP (Pass Sg  Fem) => cr_ + "escuda" ;
 VP (Pass Pl  Masc) => cr_ + "escuts" ;
 VP (Pass Sg  Masc) => cr_ + "escut" ;
 VI Infn => cr_ + "éixer" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper creure_34 : Str -> Verbum = \creure ->
let cr_ = Predef.tk 4 creure in
{s = table { 
 VI Infn => cr_ + "eure" ;
 VI Ger => cr_ + "eient" ;
 VI Part =>  cr_ + "egut" ;
 VP (Pres Ind Pl  P1) => cr_ + "eiem" ;
 VP (Pres Ind Sg  P1) => cr_ + "ec" ;
 VP (Pres Ind Pl  P2) => cr_ + "eieu" ;
 VP (Pres Ind Sg  P2) => cr_ + "eus" ;
 VP (Pres Ind Pl  P3) => cr_ + "euen" ;
 VP (Pres Ind Sg  P3) => cr_ + "eu" ;
 VP (Pres Sub Pl  P1) => cr_ + "eguem" ;
 VP (Pres Sub Sg  P1) => cr_ + "egui" ;
 VP (Pres Sub Pl  P2) => cr_ + "egueu" ;
 VP (Pres Sub Sg  P2) => cr_ + "eguis" ;
 VP (Pres Sub Pl  P3) => cr_ + "eguin" ;
 VP (Pres Sub Sg  P3) => cr_ + "egui" ;
 VP (Impf Ind Sg  P1) => cr_ + "eia" ;--# notpresent
 VP (Impf Ind Sg  P2) => cr_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => cr_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => cr_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => cr_ + "eguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => cr_ + "egués" ;--# notpresent
 VP (Impf Sub Pl  P2) => cr_ + "eguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => cr_ + "eguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => cr_ + "eguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => cr_ + "egués" ;--# notpresent
 VP (Fut Pl  P1)  => cr_ + "eurem" ;--# notpresent
 VP (Fut Sg  P1)  => cr_ + "euré" ;--# notpresent
 VP (Fut Pl  P2) => cr_ + "eureu" ;--# notpresent
 VP (Fut Sg  P2) => cr_ + "euràs" ;--# notpresent
 VP (Fut Pl  P3) => cr_ + "euran" ;--# notpresent
 VP (Fut Sg  P3) => cr_ + "eurà" ;--# notpresent
 VP (Pret Pl  P1)  => cr_ + "eguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => cr_ + "egués" ;--# notpresent
 VP (Pret Pl  P2) => cr_ + "eguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => cr_ + "eguessis" ;--# notpresent
 VP (Pret Pl  P3) => cr_ + "eguessin" ;--# notpresent
 VP (Pret Sg  P3) => cr_ + "egués" ;--# notpresent
 VP (Cond Pl  P1)  => cr_ + "euríem" ;--# notpresent
 VP (Cond Sg  P1)  => cr_ + "euria" ;--# notpresent
 VP (Cond Pl  P2) => cr_ + "euríeu" ;--# notpresent
 VP (Cond Sg  P2) => cr_ + "euries" ;--# notpresent
 VP (Cond Pl  P3) => cr_ + "eurien" ;--# notpresent
 VP (Cond Sg  P3) => cr_ + "euria" ;--# notpresent
 VP (Imp Pl  P1)  => cr_ + "eguem" ;
 VP (Imp Pl  P2) => cr_ + "eieu" ;
 VP (Imp Sg  P2) => cr_ + "eu" ;
 VP (Imp Pl  P3) => cr_ + "eguin" ;
 VP (Imp Sg  P3) => cr_ + "egui" ;
 VP (Pass Pl  Fem) => cr_ + "egudes" ;
 VP (Pass Sg  Fem) => cr_ + "eguda" ;
 VP (Pass Pl  Masc) => cr_ + "eguts" ;
 VP (Pass Sg  Masc) => cr_ + "egut" ;
 VP (Impf Ind Pl  P1)  => cr_ + "èiem" ;--# notpresent
 VP (Impf Ind Pl  P2) => cr_ + "èieu" ;--# notpresent
VP (Imp Sg P1) => variants {} 
}
} ;
-- cruixir-- is not in the used source .

oper dependre_36 : Str -> Verbum = \dependre ->
let dep_ = Predef.tk 5 dependre in
{s = table { 
 VI Infn => dep_ + "endre" ;
 VI Ger => dep_ + "enent" ;
 VP (Pres Ind Pl  P1) => dep_ + "enem" ;
 VP (Pres Ind Sg  P1) => dep_ + "enc" ;
 VP (Pres Ind Pl  P2) => dep_ + "eneu" ;
 VP (Pres Ind Sg  P2) => dep_ + "ens" ;
 VP (Pres Ind Pl  P3) => dep_ + "enen" ;
 VP (Pres Sub Pl  P1) => dep_ + "enguem" ;
 VP (Pres Sub Sg  P1) => dep_ + "engui" ;
 VP (Pres Sub Pl  P2) => dep_ + "engueu" ;
 VP (Pres Sub Sg  P2) => dep_ + "enguis" ;
 VP (Pres Sub Pl  P3) => dep_ + "enguin" ;
 VP (Pres Sub Sg  P3) => dep_ + "engui" ;
 VP (Impf Ind Pl  P1) => dep_ + "eníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => dep_ + "enia" ;--# notpresent
 VP (Impf Ind Pl  P2) => dep_ + "eníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => dep_ + "enies" ;--# notpresent
 VP (Impf Ind Pl  P3) => dep_ + "enien" ;--# notpresent
 VP (Impf Ind Sg  P3) => dep_ + "enia" ;--# notpresent
 VP (Impf Sub Pl  P1) => dep_ + "enguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => dep_ + "engués" ;--# notpresent
 VP (Impf Sub Pl  P2) => dep_ + "enguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => dep_ + "enguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => dep_ + "enguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => dep_ + "engués" ;--# notpresent
 VP (Fut Pl  P1)  => dep_ + "endrem" ;--# notpresent
 VP (Fut Sg  P1)  => dep_ + "endré" ;--# notpresent
 VP (Fut Pl  P2) => dep_ + "endreu" ;--# notpresent
 VP (Fut Sg  P2) => dep_ + "endràs" ;--# notpresent
 VP (Fut Pl  P3) => dep_ + "endran" ;--# notpresent
 VP (Fut Sg  P3) => dep_ + "endrà" ;--# notpresent
 VP (Pret Pl  P1)  => dep_ + "enguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => dep_ + "engués" ;--# notpresent
 VP (Pret Pl  P2) => dep_ + "enguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => dep_ + "enguessis" ;--# notpresent
 VP (Pret Pl  P3) => dep_ + "enguessin" ;--# notpresent
 VP (Pret Sg  P3) => dep_ + "engués" ;--# notpresent
 VP (Cond Pl  P1)  => dep_ + "endríem" ;--# notpresent
 VP (Cond Sg  P1)  => dep_ + "endria" ;--# notpresent
 VP (Cond Pl  P2) => dep_ + "endríeu" ;--# notpresent
 VP (Cond Sg  P2) => dep_ + "endries" ;--# notpresent
 VP (Cond Pl  P3) => dep_ + "endrien" ;--# notpresent
 VP (Cond Sg  P3) => dep_ + "endria" ;--# notpresent
 VP (Imp Pl  P1)  => dep_ + "enguem" ;
 VP (Imp Pl  P2) => dep_ + "eneu" ;
 VP (Imp Pl  P3) => dep_ + "enguin" ;
 VP (Imp Sg  P3) => dep_ + "engui" ;
 VP (Pass Pl  Fem) => dep_ + "eses" ;
 VP (Pass Sg  Fem) => dep_ + "esa" ;
 VP (Pass Pl  Masc) => dep_ + "esos" ;
 VI Part =>  dep_ + "ès" ;
 VP (Pres Ind Sg  P3) => dep_ + "èn" ;
 VP (Pass Sg  Masc) => dep_ + "ès" ;
 VP (Imp Sg  P2) => dep_ + "én" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- descloure-- is not in the used source .
-- descosir-- is not in the used source .

oper desfer_39 : Str -> Verbum = \desfer ->
let desf_ = Predef.tk 2 desfer in
{s = table { 
 VI Infn => desf_ + "er" ;
 VI Ger => desf_ + "ent" ;
 VI Part =>  desf_ + "et" ;
 VP (Pres Ind Pl  P1) => desf_ + "em" ;
 VP (Pres Ind Sg  P1) => desf_ + "aig" ;
 VP (Pres Ind Pl  P2) => desf_ + "eu" ;
 VP (Pres Ind Sg  P2) => desf_ + "às" ;
 VP (Pres Ind Pl  P3) => desf_ + "an" ;
 VP (Pres Ind Sg  P3) => desf_ + "à" ;
 VP (Pres Sub Pl  P1) => desf_ + "em" ;
 VP (Pres Sub Sg  P1) => desf_ + "aci" ;
 VP (Pres Sub Pl  P2) => desf_ + "eu" ;
 VP (Pres Sub Sg  P2) => desf_ + "acis" ;
 VP (Pres Sub Pl  P3) => desf_ + "acin" ;
 VP (Pres Sub Sg  P3) => desf_ + "aci" ;
 VP (Impf Ind Pl  P1) => desf_ + "èiem" ;--# notpresent
 VP (Impf Ind Sg  P1) => desf_ + "eia" ;--# notpresent
 VP (Impf Ind Pl  P2) => desf_ + "èieu" ;--# notpresent
 VP (Impf Ind Sg  P2) => desf_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => desf_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => desf_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => desf_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => desf_ + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => desf_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => desf_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => desf_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => desf_ + "és" ;--# notpresent
 VP (Fut Pl  P1)  => desf_ + "arem" ;--# notpresent
 VP (Fut Sg  P1)  => desf_ + "aré" ;--# notpresent
 VP (Fut Pl  P2) => desf_ + "areu" ;--# notpresent
 VP (Fut Sg  P2) => desf_ + "aràs" ;--# notpresent
 VP (Fut Pl  P3) => desf_ + "aran" ;--# notpresent
 VP (Fut Sg  P3) => desf_ + "arà" ;--# notpresent
 VP (Pret Pl  P1)  => desf_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => desf_ + "és" ;--# notpresent
 VP (Pret Pl  P2) => desf_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => desf_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => desf_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => desf_ + "és" ;--# notpresent
 VP (Cond Pl  P1)  => desf_ + "aríem" ;--# notpresent
 VP (Cond Sg  P1)  => desf_ + "aria" ;--# notpresent
 VP (Cond Pl  P2) => desf_ + "aríeu" ;--# notpresent
 VP (Cond Sg  P2) => desf_ + "aries" ;--# notpresent
 VP (Cond Pl  P3) => desf_ + "arien" ;--# notpresent
 VP (Cond Sg  P3) => desf_ + "aria" ;--# notpresent
 VP (Imp Pl  P1)  => desf_ + "em" ;
 VP (Imp Pl  P2) => desf_ + "eu" ;
 VP (Imp Sg  P2) => desf_ + "és" ;
 VP (Imp Pl  P3) => desf_ + "acin" ;
 VP (Imp Sg  P3) => desf_ + "aci" ;
 VP (Pass Pl  Fem) => desf_ + "etes" ;
 VP (Pass Sg  Fem) => desf_ + "eta" ;
 VP (Pass Pl  Masc) => desf_ + "ets" ;
 VP (Pass Sg  Masc) => desf_ + "et" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper deure_40 : Str -> Verbum = \deure ->
let x_ = Predef.tk 5 deure in
{s = table { 
 VI Infn => x_ + "ure" ;
 VI Ger => x_ + "vent" ;
 VI Part =>  x_ + "gut" ;
 VP (Pres Ind Pl  P1) => x_ + "vem" ;
 VP (Pres Ind Sg  P1) => x_ + "c" ;
 VP (Pres Ind Pl  P2) => x_ + "veu" ;
 VP (Pres Ind Sg  P2) => x_ + "us" ;
 VP (Pres Ind Pl  P3) => x_ + "uen" ;
 VP (Pres Ind Sg  P3) => x_ + "u" ;
 VP (Pres Sub Pl  P1) => x_ + "guem" ;
 VP (Pres Sub Sg  P1) => x_ + "gui" ;
 VP (Pres Sub Pl  P2) => x_ + "gueu" ;
 VP (Pres Sub Sg  P2) => x_ + "guis" ;
 VP (Pres Sub Pl  P3) => x_ + "guin" ;
 VP (Pres Sub Sg  P3) => x_ + "gui" ;
 VP (Impf Ind Pl  P1) => x_ + "víem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "via" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "víeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "vies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "vien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "via" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "guem" ;
 VP (Imp Pl  P2) => x_ + "veu" ;
 VP (Imp Sg  P2) => x_ + "u" ;
 VP (Imp Pl  P3) => x_ + "guin" ;
 VP (Imp Sg  P3) => x_ + "gui" ;
 VP (Pass Pl  Fem) => x_ + "gudes" ;
 VP (Pass Sg  Fem) => x_ + "guda" ;
 VP (Pass Pl  Masc) => x_ + "guts" ;
 VP (Pass Sg  Masc) => x_ + "gut" ;


{- -- AR removed these duplicates
 VI Infn => x_ + "ure" ;
 VI Ger => x_ + "vent" ;
 VI Part =>  x_ + "gut" ;
 VP (Pres Ind Pl  P1)  => x_ + "vem" ;
 VP (Pres Ind Sg  P1)  => x_ + "c" ;
 VP (Pres Ind Pl  P2) => x_ + "veu" ;
 VP (Pres Ind Sg  P2) => x_ + "us" ;
 VP (Pres Ind Pl  P3) => x_ + "uen" ;
 VP (Pres Ind Sg  P3) => x_ + "u" ;
 VP (Pres Sub Pl  P1)  => x_ + "guem" ;
 VP (Pres Sub Sg  P1)  => x_ + "gui" ;
 VP (Pres Sub Pl  P2) => x_ + "gueu" ;
 VP (Pres Sub Sg  P2) => x_ + "guis" ;
 VP (Pres Sub Pl  P3) => x_ + "guin" ;
 VP (Pres Sub Sg  P3) => x_ + "gui" ;
 VP (Impf Ind Pl  P1)  => x_ + "víem" ;--# notpresent
 VP (Impf Ind Sg  P1)  => x_ + "via" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "víeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "vies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "vien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "via" ;--# notpresent
 VP (Impf Sub Pl  P1)  => x_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1)  => x_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "uria" ;--# notpresent
 VP (Pass Pl  Fem) => x_ + "gudes" ;
 VP (Pass Sg  Fem) => x_ + "guda" ;
 VP (Pass Pl  Masc) => x_ + "guts" ;
 VP (Pass Sg  Masc) => x_ + "gut" ;
-}
VP (Imp Sg P1) => variants {} 
}
} ;

oper dir_41 : Str -> Verbum = \dir ->
let d_ = Predef.tk 2 dir in
{s = table { 
 VI Infn => d_ + "ir" ;
 VI Ger => d_ + "ient" ;
 VI Part =>  d_ + "it" ;
 VP (Pres Ind Pl  P1) => d_ + "iem" ;
 VP (Pres Ind Sg  P1) => d_ + "ic" ;
 VP (Pres Ind Pl  P2) => d_ + "ieu" ;
 VP (Pres Ind Sg  P2) => d_ + "ius" ;
 VP (Pres Ind Pl  P3) => d_ + "iuen" ;
 VP (Pres Ind Sg  P3) => d_ + "iu" ;
 VP (Pres Sub Pl  P1) => d_ + "iguem" ;
 VP (Pres Sub Sg  P1) => d_ + "igui" ;
 VP (Pres Sub Pl  P2) => d_ + "igueu" ;
 VP (Pres Sub Sg  P2) => d_ + "iguis" ;
 VP (Pres Sub Pl  P3) => d_ + "iguin" ;
 VP (Pres Sub Sg  P3) => d_ + "igui" ;
 VP (Impf Ind Pl  P1) => d_ + "èiem" ;--# notpresent
 VP (Impf Ind Sg  P1) => d_ + "eia" ;--# notpresent
 VP (Impf Ind Pl  P2) => d_ + "èieu" ;--# notpresent
 VP (Impf Ind Sg  P2) => d_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => d_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => d_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => d_ + "iguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => d_ + "igués" ;--# notpresent
 VP (Impf Sub Pl  P2) => d_ + "iguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => d_ + "iguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => d_ + "iguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => d_ + "igués" ;--# notpresent
 VP (Fut Pl  P1)  => d_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => d_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => d_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => d_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => d_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => d_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => d_ + "iguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => d_ + "igués" ;--# notpresent
 VP (Pret Pl  P2) => d_ + "iguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => d_ + "iguessis" ;--# notpresent
 VP (Pret Pl  P3) => d_ + "iguessin" ;--# notpresent
 VP (Pret Sg  P3) => d_ + "igués" ;--# notpresent
 VP (Cond Pl  P1)  => d_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => d_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => d_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => d_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => d_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => d_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => d_ + "iguem" ;
 VP (Imp Pl  P2) => d_ + "igueu" ;
 VP (Imp Sg  P2) => d_ + "igues" ;
 VP (Imp Pl  P3) => d_ + "iguin" ;
 VP (Imp Sg  P3) => d_ + "igui" ;
 VP (Pass Pl  Fem) => d_ + "ites" ;
 VP (Pass Sg  Fem) => d_ + "ita" ;
 VP (Pass Pl  Masc) => d_ + "its" ;
 VP (Pass Sg  Masc) => d_ + "it" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper doldre_42 : Str -> Verbum = \doldre ->
let dol_ = Predef.tk 3 doldre in
{s = table { 
 VI Infn => dol_ + "dre" ;
 VI Ger => dol_ + "ent" ;
 VI Part =>  dol_ + "gut" ;
 VP (Pres Ind Pl  P1) => dol_ + "em" ;
 VP (Pres Ind Sg  P1) => dol_ + "c" ;
 VP (Pres Ind Pl  P2) => dol_ + "eu" ;
 VP (Pres Ind Sg  P2) => dol_ + "s" ;
 VP (Pres Ind Pl  P3) => dol_ + "en" ;
 VP (Pres Ind Sg  P3) => dol_ + "" ;
 VP (Pres Sub Pl  P1) => dol_ + "guem" ;
 VP (Pres Sub Sg  P1) => dol_ + "gui" ;
 VP (Pres Sub Pl  P2) => dol_ + "gueu" ;
 VP (Pres Sub Sg  P2) => dol_ + "guis" ;
 VP (Pres Sub Pl  P3) => dol_ + "guin" ;
 VP (Pres Sub Sg  P3) => dol_ + "gui" ;
 VP (Impf Ind Pl  P1) => dol_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => dol_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => dol_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => dol_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => dol_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => dol_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => dol_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => dol_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => dol_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => dol_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => dol_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => dol_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => dol_ + "drem" ;--# notpresent
 VP (Fut Sg  P1)  => dol_ + "dré" ;--# notpresent
 VP (Fut Pl  P2) => dol_ + "dreu" ;--# notpresent
 VP (Fut Sg  P2) => dol_ + "dràs" ;--# notpresent
 VP (Fut Pl  P3) => dol_ + "dran" ;--# notpresent
 VP (Fut Sg  P3) => dol_ + "drà" ;--# notpresent
 VP (Pret Pl  P1)  => dol_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => dol_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => dol_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => dol_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => dol_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => dol_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => dol_ + "dríem" ;--# notpresent
 VP (Cond Sg  P1)  => dol_ + "dria" ;--# notpresent
 VP (Cond Pl  P2) => dol_ + "dríeu" ;--# notpresent
 VP (Cond Sg  P2) => dol_ + "dries" ;--# notpresent
 VP (Cond Pl  P3) => dol_ + "drien" ;--# notpresent
 VP (Cond Sg  P3) => dol_ + "dria" ;--# notpresent
 VP (Imp Pl  P1)  => dol_ + "guem" ;
 VP (Imp Pl  P2) => dol_ + "eu" ;
 VP (Imp Sg  P2) => dol_ + "" ;
 VP (Imp Pl  P3) => dol_ + "guin" ;
 VP (Imp Sg  P3) => dol_ + "gui" ;
 VP (Pass Pl  Fem) => dol_ + "gudes" ;
 VP (Pass Sg  Fem) => dol_ + "guda" ;
 VP (Pass Pl  Masc) => dol_ + "guts" ;
 VP (Pass Sg  Masc) => dol_ + "gut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper donar_43 : Str -> Verbum = \donar ->
let d_ = Predef.tk 4 donar in
{s = table { 
 VI Infn => d_ + "onar" ;
 VI Ger => d_ + "onant" ;
 VI Part =>  d_ + "onat" ;
 VP (Pres Ind Pl  P1) => d_ + "onem" ;
 VP (Pres Ind Sg  P1) => d_ + "ono" ;
 VP (Pres Ind Pl  P2) => d_ + "oneu" ;
 VP (Pres Ind Pl  P3) => d_ + "onen" ;
 VP (Pres Sub Pl  P1) => d_ + "onem" ;
 VP (Pres Sub Sg  P1) => d_ + "oni" ;
 VP (Pres Sub Pl  P2) => d_ + "oneu" ;
 VP (Pres Sub Sg  P2) => d_ + "onis" ;
 VP (Pres Sub Pl  P3) => d_ + "onin" ;
 VP (Pres Sub Sg  P3) => d_ + "oni" ;
 VP (Impf Ind Pl  P1) => d_ + "onàvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => d_ + "onava" ;--# notpresent
 VP (Impf Ind Pl  P2) => d_ + "onàveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => d_ + "onaves" ;--# notpresent
 VP (Impf Ind Pl  P3) => d_ + "onaven" ;--# notpresent
 VP (Impf Ind Sg  P3) => d_ + "onava" ;--# notpresent
 VP (Impf Sub Pl  P1) => d_ + "onéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => d_ + "onés" ;--# notpresent
 VP (Impf Sub Pl  P2) => d_ + "onéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => d_ + "onessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => d_ + "onessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => d_ + "onés" ;--# notpresent
 VP (Fut Pl  P1)  => d_ + "onarem" ;--# notpresent
 VP (Fut Sg  P1)  => d_ + "onaré" ;--# notpresent
 VP (Fut Pl  P2) => d_ + "onareu" ;--# notpresent
 VP (Fut Sg  P2) => d_ + "onaràs" ;--# notpresent
 VP (Fut Pl  P3) => d_ + "onaran" ;--# notpresent
 VP (Fut Sg  P3) => d_ + "onarà" ;--# notpresent
 VP (Pret Pl  P1)  => d_ + "onéssim" ;--# notpresent
 VP (Pret Sg  P1)  => d_ + "onés" ;--# notpresent
 VP (Pret Pl  P2) => d_ + "onéssiu" ;--# notpresent
 VP (Pret Sg  P2) => d_ + "onessis" ;--# notpresent
 VP (Pret Pl  P3) => d_ + "onessin" ;--# notpresent
 VP (Pret Sg  P3) => d_ + "onés" ;--# notpresent
 VP (Cond Pl  P1)  => d_ + "onaríem" ;--# notpresent
 VP (Cond Sg  P1)  => d_ + "onaria" ;--# notpresent
 VP (Cond Pl  P2) => d_ + "onaríeu" ;--# notpresent
 VP (Cond Sg  P2) => d_ + "onaries" ;--# notpresent
 VP (Cond Pl  P3) => d_ + "onarien" ;--# notpresent
 VP (Cond Sg  P3) => d_ + "onaria" ;--# notpresent
 VP (Imp Pl  P1)  => d_ + "onem" ;
 VP (Imp Pl  P2) => d_ + "oneu" ;
 VP (Imp Pl  P3) => d_ + "onin" ;
 VP (Imp Sg  P3) => d_ + "oni" ;
 VP (Pass Pl  Fem) => d_ + "onades" ;
 VP (Pass Sg  Fem) => d_ + "onada" ;
 VP (Pass Pl  Masc) => d_ + "onats" ;
 VP (Pass Sg  Masc) => d_ + "onat" ;
 VP (Pres Ind Sg  P2) => d_ + "ónes" ;
 VP (Pres Ind Sg  P3) => d_ + "óna" ;
 VP (Imp Sg  P2) => d_ + "óna" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper dormir_44 : Str -> Verbum = \dormir ->
let dorm_ = Predef.tk 2 dormir in
{s = table { 
 VI Infn => dorm_ + "ir" ;
 VI Ger => dorm_ + "int" ;
 VI Part =>  dorm_ + "it" ;
 VP (Pres Ind Pl  P1) => dorm_ + "im" ;
 VP (Pres Ind Sg  P1) => dorm_ + "o" ;
 VP (Pres Ind Pl  P2) => dorm_ + "iu" ;
 VP (Pres Ind Sg  P2) => dorm_ + "s" ;
 VP (Pres Ind Pl  P3) => dorm_ + "en" ;
 VP (Pres Ind Sg  P3) => dorm_ + "" ;
 VP (Pres Sub Pl  P1) => dorm_ + "im" ;
 VP (Pres Sub Sg  P1) => dorm_ + "i" ;
 VP (Pres Sub Pl  P2) => dorm_ + "iu" ;
 VP (Pres Sub Sg  P2) => dorm_ + "is" ;
 VP (Pres Sub Pl  P3) => dorm_ + "in" ;
 VP (Pres Sub Sg  P3) => dorm_ + "i" ;
 VP (Impf Ind Pl  P1) => dorm_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => dorm_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => dorm_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => dorm_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => dorm_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => dorm_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => dorm_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => dorm_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => dorm_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => dorm_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => dorm_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => dorm_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => dorm_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => dorm_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => dorm_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => dorm_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => dorm_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => dorm_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => dorm_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => dorm_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => dorm_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => dorm_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => dorm_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => dorm_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => dorm_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => dorm_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => dorm_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => dorm_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => dorm_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => dorm_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => dorm_ + "im" ;
 VP (Imp Pl  P2) => dorm_ + "iu" ;
 VP (Imp Sg  P2) => dorm_ + "" ;
 VP (Imp Pl  P3) => dorm_ + "in" ;
 VP (Imp Sg  P3) => dorm_ + "i" ;
 VP (Pass Pl  Fem) => dorm_ + "ides" ;
 VP (Pass Sg  Fem) => dorm_ + "ida" ;
 VP (Pass Pl  Masc) => dorm_ + "its" ;
 VP (Pass Sg  Masc) => dorm_ + "it" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper dur_45 : Str -> Verbum = \dur ->
let d_ = Predef.tk 2 dur in
{s = table { 
 VI Infn => d_ + "ur" ;
 VI Ger => d_ + "uent" ;
 VI Part =>  d_ + "ut" ;
 VP (Pres Ind Pl  P1) => d_ + "uem" ;
 VP (Pres Ind Sg  P1) => d_ + "uc" ;
 VP (Pres Ind Pl  P2) => d_ + "ueu" ;
 VP (Pres Ind Sg  P2) => d_ + "uus" ;
 VP (Pres Ind Pl  P3) => d_ + "uen" ;
 VP (Pres Ind Sg  P3) => d_ + "uu" ;
 VP (Pres Sub Pl  P1) => d_ + "uguem" ;
 VP (Pres Sub Sg  P1) => d_ + "ugui" ;
 VP (Pres Sub Pl  P2) => d_ + "ugueu" ;
 VP (Pres Sub Sg  P2) => d_ + "uguis" ;
 VP (Pres Sub Pl  P3) => d_ + "uguin" ;
 VP (Pres Sub Sg  P3) => d_ + "ugui" ;
 VP (Impf Ind Sg  P1) => d_ + "uia" ;--# notpresent
 VP (Impf Ind Sg  P2) => d_ + "uies" ;--# notpresent
 VP (Impf Ind Pl  P3) => d_ + "uien" ;--# notpresent
 VP (Impf Ind Sg  P3) => d_ + "uia" ;--# notpresent
 VP (Impf Ind Pl  P1) => d_ + "úiem" ;--# notpresent
 VP (Impf Ind Pl  P2) => d_ + "úieu" ;--# notpresent
 VP (Impf Sub Pl  P1) => d_ + "uguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => d_ + "ugués" ;--# notpresent
 VP (Impf Sub Pl  P2) => d_ + "uguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => d_ + "uguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => d_ + "uguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => d_ + "ugués" ;--# notpresent
 VP (Fut Pl  P1)  => d_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => d_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => d_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => d_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => d_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => d_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => d_ + "uguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => d_ + "ugués" ;--# notpresent
 VP (Pret Pl  P2) => d_ + "uguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => d_ + "uguessis" ;--# notpresent
 VP (Pret Pl  P3) => d_ + "uguessin" ;--# notpresent
 VP (Pret Sg  P3) => d_ + "ugués" ;--# notpresent
 VP (Cond Pl  P1)  => d_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => d_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => d_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => d_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => d_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => d_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => d_ + "uguem" ;
 VP (Imp Pl  P2) => d_ + "ueu" ;
 VP (Imp Sg  P2) => d_ + "uu" ;
 VP (Imp Pl  P3) => d_ + "uguin" ;
 VP (Imp Sg  P3) => d_ + "ugui" ;
 VP (Pass Pl  Fem) => d_ + "utes" ;
 VP (Pass Sg  Fem) => d_ + "uta" ;
 VP (Pass Pl  Masc) => d_ + "uts" ;
 VP (Pass Sg  Masc) => d_ + "ut" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- eixir-- is not in the used source .
-- enaiguar-- is not in the used source .

oper envejar_48 : Str -> Verbum = \envejar ->
let enve_ = Predef.tk 3 envejar in
{s = table { 
 VI Infn => enve_ + "jar" ;
 VI Ger => enve_ + "jant" ;
 VI Part =>  enve_ + "jat" ;
 VP (Pres Ind Pl  P1) => enve_ + "gem" ;
 VP (Pres Ind Sg  P1) => enve_ + "jo" ;
 VP (Pres Ind Pl  P2) => enve_ + "geu" ;
 VP (Pres Ind Sg  P2) => enve_ + "ges" ;
 VP (Pres Ind Pl  P3) => enve_ + "gen" ;
 VP (Pres Ind Sg  P3) => enve_ + "ja" ;
 VP (Pres Sub Pl  P1) => enve_ + "gem" ;
 VP (Pres Sub Sg  P1) => enve_ + "gi" ;
 VP (Pres Sub Pl  P2) => enve_ + "geu" ;
 VP (Pres Sub Sg  P2) => enve_ + "gis" ;
 VP (Pres Sub Pl  P3) => enve_ + "gin" ;
 VP (Pres Sub Sg  P3) => enve_ + "gi" ;
 VP (Impf Ind Pl  P1) => enve_ + "jàvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => enve_ + "java" ;--# notpresent
 VP (Impf Ind Pl  P2) => enve_ + "jàveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => enve_ + "javes" ;--# notpresent
 VP (Impf Ind Pl  P3) => enve_ + "javen" ;--# notpresent
 VP (Impf Ind Sg  P3) => enve_ + "java" ;--# notpresent
 VP (Impf Sub Pl  P1) => enve_ + "géssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => enve_ + "gés" ;--# notpresent
 VP (Impf Sub Pl  P2) => enve_ + "géssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => enve_ + "gessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => enve_ + "gessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => enve_ + "gés" ;--# notpresent
 VP (Fut Pl  P1)  => enve_ + "jarem" ;--# notpresent
 VP (Fut Sg  P1)  => enve_ + "jaré" ;--# notpresent
 VP (Fut Pl  P2) => enve_ + "jareu" ;--# notpresent
 VP (Fut Sg  P2) => enve_ + "jaràs" ;--# notpresent
 VP (Fut Pl  P3) => enve_ + "jaran" ;--# notpresent
 VP (Fut Sg  P3) => enve_ + "jarà" ;--# notpresent
 VP (Pret Pl  P1)  => enve_ + "géssim" ;--# notpresent
 VP (Pret Sg  P1)  => enve_ + "gés" ;--# notpresent
 VP (Pret Pl  P2) => enve_ + "géssiu" ;--# notpresent
 VP (Pret Sg  P2) => enve_ + "gessis" ;--# notpresent
 VP (Pret Pl  P3) => enve_ + "gessin" ;--# notpresent
 VP (Pret Sg  P3) => enve_ + "gés" ;--# notpresent
 VP (Cond Pl  P1)  => enve_ + "jaríem" ;--# notpresent
 VP (Cond Sg  P1)  => enve_ + "jaria" ;--# notpresent
 VP (Cond Pl  P2) => enve_ + "jaríeu" ;--# notpresent
 VP (Cond Sg  P2) => enve_ + "jaries" ;--# notpresent
 VP (Cond Pl  P3) => enve_ + "jarien" ;--# notpresent
 VP (Cond Sg  P3) => enve_ + "jaria" ;--# notpresent
 VP (Imp Pl  P1)  => enve_ + "gem" ;
 VP (Imp Pl  P2) => enve_ + "geu" ;
 VP (Imp Sg  P2) => enve_ + "ja" ;
 VP (Imp Pl  P3) => enve_ + "gin" ;
 VP (Imp Sg  P3) => enve_ + "gi" ;
 VP (Pass Pl  Fem) => enve_ + "jades" ;
 VP (Pass Sg  Fem) => enve_ + "jada" ;
 VP (Pass Pl  Masc) => enve_ + "jats" ;
 VP (Pass Sg  Masc) => enve_ + "jat" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper escopir_49 : Str -> Verbum = \escopir ->
let esc_ = Predef.tk 4 escopir in
{s = table { 
 VI Infn => esc_ + "opir" ;
 VI Ger => esc_ + "opint" ;
 VI Part =>  esc_ + "opit" ;
 VP (Pres Ind Pl  P1) => esc_ + "opim" ;
 VP (Pres Ind Sg  P1) => esc_ + "upo" ;
 VP (Pres Ind Pl  P2) => esc_ + "opiu" ;
 VP (Pres Ind Sg  P2) => esc_ + "ups" ;
 VP (Pres Ind Pl  P3) => esc_ + "upen" ;
 VP (Pres Ind Sg  P3) => esc_ + "up" ;
 VP (Pres Sub Pl  P1) => esc_ + "opim" ;
 VP (Pres Sub Sg  P1) => esc_ + "upi" ;
 VP (Pres Sub Pl  P2) => esc_ + "opiu" ;
 VP (Pres Sub Sg  P2) => esc_ + "upis" ;
 VP (Pres Sub Pl  P3) => esc_ + "upin" ;
 VP (Pres Sub Sg  P3) => esc_ + "upi" ;
 VP (Impf Ind Pl  P1) => esc_ + "opíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => esc_ + "opia" ;--# notpresent
 VP (Impf Ind Pl  P2) => esc_ + "opíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => esc_ + "opies" ;--# notpresent
 VP (Impf Ind Pl  P3) => esc_ + "opien" ;--# notpresent
 VP (Impf Ind Sg  P3) => esc_ + "opia" ;--# notpresent
 VP (Impf Sub Pl  P1) => esc_ + "opíssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => esc_ + "opís" ;--# notpresent
 VP (Impf Sub Pl  P2) => esc_ + "opíssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => esc_ + "opissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => esc_ + "opissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => esc_ + "opís" ;--# notpresent
 VP (Fut Pl  P1)  => esc_ + "opirem" ;--# notpresent
 VP (Fut Sg  P1)  => esc_ + "opiré" ;--# notpresent
 VP (Fut Pl  P2) => esc_ + "opireu" ;--# notpresent
 VP (Fut Sg  P2) => esc_ + "opiràs" ;--# notpresent
 VP (Fut Pl  P3) => esc_ + "opiran" ;--# notpresent
 VP (Fut Sg  P3) => esc_ + "opirà" ;--# notpresent
 VP (Pret Pl  P1)  => esc_ + "opíssim" ;--# notpresent
 VP (Pret Sg  P1)  => esc_ + "opís" ;--# notpresent
 VP (Pret Pl  P2) => esc_ + "opíssiu" ;--# notpresent
 VP (Pret Sg  P2) => esc_ + "opissis" ;--# notpresent
 VP (Pret Pl  P3) => esc_ + "opissin" ;--# notpresent
 VP (Pret Sg  P3) => esc_ + "opís" ;--# notpresent
 VP (Cond Pl  P1)  => esc_ + "opiríem" ;--# notpresent
 VP (Cond Sg  P1)  => esc_ + "opiria" ;--# notpresent
 VP (Cond Pl  P2) => esc_ + "opiríeu" ;--# notpresent
 VP (Cond Sg  P2) => esc_ + "opiries" ;--# notpresent
 VP (Cond Pl  P3) => esc_ + "opirien" ;--# notpresent
 VP (Cond Sg  P3) => esc_ + "opiria" ;--# notpresent
 VP (Imp Pl  P1)  => esc_ + "opim" ;
 VP (Imp Pl  P2) => esc_ + "opiu" ;
 VP (Imp Sg  P2) => esc_ + "up" ;
 VP (Imp Pl  P3) => esc_ + "upin" ;
 VP (Imp Sg  P3) => esc_ + "upi" ;
 VP (Pass Pl  Fem) => esc_ + "opides" ;
 VP (Pass Sg  Fem) => esc_ + "opida" ;
 VP (Pass Pl  Masc) => esc_ + "opits" ;
 VP (Pass Sg  Masc) => esc_ + "opit" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper escriure_50 : Str -> Verbum = \escriure ->
let escri_ = Predef.tk 3 escriure in
{s = table { 
 VI Infn => escri_ + "ure" ;
 VI Ger => escri_ + "vint" ;
 VI Part =>  escri_ + "t" ;
 VP (Pres Ind Pl  P1) => escri_ + "vim" ;
 VP (Pres Ind Sg  P1) => escri_ + "c" ;
 VP (Pres Ind Pl  P2) => escri_ + "viu" ;
 VP (Pres Ind Sg  P2) => escri_ + "us" ;
 VP (Pres Ind Pl  P3) => escri_ + "uen" ;
 VP (Pres Ind Sg  P3) => escri_ + "u" ;
 VP (Pres Sub Pl  P1) => escri_ + "guem" ;
 VP (Pres Sub Sg  P1) => escri_ + "gui" ;
 VP (Pres Sub Pl  P2) => escri_ + "gueu" ;
 VP (Pres Sub Sg  P2) => escri_ + "guis" ;
 VP (Pres Sub Pl  P3) => escri_ + "guin" ;
 VP (Pres Sub Sg  P3) => escri_ + "gui" ;
 VP (Impf Ind Pl  P1) => escri_ + "víem" ;--# notpresent
 VP (Impf Ind Sg  P1) => escri_ + "via" ;--# notpresent
 VP (Impf Ind Pl  P2) => escri_ + "víeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => escri_ + "vies" ;--# notpresent
 VP (Impf Ind Pl  P3) => escri_ + "vien" ;--# notpresent
 VP (Impf Ind Sg  P3) => escri_ + "via" ;--# notpresent
 VP (Impf Sub Pl  P1) => escri_ + "víssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => escri_ + "vís" ;--# notpresent
 VP (Impf Sub Pl  P2) => escri_ + "víssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => escri_ + "vissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => escri_ + "vissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => escri_ + "vís" ;--# notpresent
 VP (Fut Pl  P1)  => escri_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => escri_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => escri_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => escri_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => escri_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => escri_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => escri_ + "víssim" ;--# notpresent
 VP (Pret Sg  P1)  => escri_ + "vís" ;--# notpresent
 VP (Pret Pl  P2) => escri_ + "víssiu" ;--# notpresent
 VP (Pret Sg  P2) => escri_ + "vissis" ;--# notpresent
 VP (Pret Pl  P3) => escri_ + "vissin" ;--# notpresent
 VP (Pret Sg  P3) => escri_ + "vís" ;--# notpresent
 VP (Cond Pl  P1)  => escri_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => escri_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => escri_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => escri_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => escri_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => escri_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => escri_ + "guem" ;
 VP (Imp Pl  P2) => escri_ + "viu" ;
 VP (Imp Sg  P2) => escri_ + "u" ;
 VP (Imp Pl  P3) => escri_ + "guin" ;
 VP (Imp Sg  P3) => escri_ + "gui" ;
 VP (Pass Pl  Fem) => escri_ + "tes" ;
 VP (Pass Sg  Fem) => escri_ + "ta" ;
 VP (Pass Pl  Masc) => escri_ + "ts" ;
 VP (Pass Sg  Masc) => escri_ + "t" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper esglaiar_51 : Str -> Verbum = \esglaiar ->
let esgla_ = Predef.tk 3 esglaiar in
{s = table { 
 VI Infn => esgla_ + "iar" ;
 VI Ger => esgla_ + "iant" ;
 VI Part =>  esgla_ + "iat" ;
 VP (Pres Ind Pl  P1) => esgla_ + "iem" ;
 VP (Pres Ind Sg  P1) => esgla_ + "io" ;
 VP (Pres Ind Pl  P2) => esgla_ + "ieu" ;
 VP (Pres Ind Sg  P2) => esgla_ + "ies" ;
 VP (Pres Ind Pl  P3) => esgla_ + "ien" ;
 VP (Pres Ind Sg  P3) => esgla_ + "ia" ;
 VP (Pres Sub Pl  P1) => esgla_ + "iem" ;
 VP (Pres Sub Pl  P2) => esgla_ + "ieu" ;
 VP (Impf Ind Pl  P1) => esgla_ + "iàvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => esgla_ + "iava" ;--# notpresent
 VP (Impf Ind Pl  P2) => esgla_ + "iàveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => esgla_ + "iaves" ;--# notpresent
 VP (Impf Ind Pl  P3) => esgla_ + "iaven" ;--# notpresent
 VP (Impf Ind Sg  P3) => esgla_ + "iava" ;--# notpresent
 VP (Impf Sub Pl  P1) => esgla_ + "iéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => esgla_ + "iés" ;--# notpresent
 VP (Impf Sub Pl  P2) => esgla_ + "iéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => esgla_ + "iessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => esgla_ + "iessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => esgla_ + "iés" ;--# notpresent
 VP (Fut Pl  P1)  => esgla_ + "iarem" ;--# notpresent
 VP (Fut Sg  P1)  => esgla_ + "iaré" ;--# notpresent
 VP (Fut Pl  P2) => esgla_ + "iareu" ;--# notpresent
 VP (Fut Sg  P2) => esgla_ + "iaràs" ;--# notpresent
 VP (Fut Pl  P3) => esgla_ + "iaran" ;--# notpresent
 VP (Fut Sg  P3) => esgla_ + "iarà" ;--# notpresent
 VP (Pret Pl  P1)  => esgla_ + "iéssim" ;--# notpresent
 VP (Pret Sg  P1)  => esgla_ + "iés" ;--# notpresent
 VP (Pret Pl  P2) => esgla_ + "iéssiu" ;--# notpresent
 VP (Pret Sg  P2) => esgla_ + "iessis" ;--# notpresent
 VP (Pret Pl  P3) => esgla_ + "iessin" ;--# notpresent
 VP (Pret Sg  P3) => esgla_ + "iés" ;--# notpresent
 VP (Cond Pl  P1)  => esgla_ + "iaríem" ;--# notpresent
 VP (Cond Sg  P1)  => esgla_ + "iaria" ;--# notpresent
 VP (Cond Pl  P2) => esgla_ + "iaríeu" ;--# notpresent
 VP (Cond Sg  P2) => esgla_ + "iaries" ;--# notpresent
 VP (Cond Pl  P3) => esgla_ + "iarien" ;--# notpresent
 VP (Cond Sg  P3) => esgla_ + "iaria" ;--# notpresent
 VP (Imp Pl  P1)  => esgla_ + "iem" ;
 VP (Imp Pl  P2) => esgla_ + "ieu" ;
 VP (Imp Sg  P2) => esgla_ + "ia" ;
 VP (Pass Pl  Fem) => esgla_ + "iades" ;
 VP (Pass Sg  Fem) => esgla_ + "iada" ;
 VP (Pass Pl  Masc) => esgla_ + "iats" ;
 VP (Pass Sg  Masc) => esgla_ + "iat" ;
 VP (Pres Sub Sg  P1)  => esgla_ + "ï" ;
 VP (Pres Sub Sg  P2) => esgla_ + "ïs" ;
 VP (Pres Sub Pl  P3) => esgla_ + "ïn" ;
 VP (Pres Sub Sg  P3) => esgla_ + "ï" ;
 VP (Imp Pl  P3) => esgla_ + "ïn" ;
 VP (Imp Sg  P3) => esgla_ + "ï" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper ser_52 : Str -> Verbum = \ser ->
let x_ = Predef.tk 3 ser in
{s = table { 
 VI Infn => x_ + "ser" ;
 VI Ger => x_ + "sent" ;
 VI Part =>  x_ + "estat" ;
 VP (Pres Ind Pl  P1) => x_ + "som" ;
 VP (Pres Ind Sg  P1) => x_ + "sóc" ;
 VP (Pres Ind Pl  P2) => x_ + "sou" ;
 VP (Pres Ind Sg  P2) => x_ + "ets" ;
 VP (Pres Ind Pl  P3) => x_ + "són" ;
 VP (Pres Ind Sg  P3) => x_ + "és" ;
 VP (Pres Sub Pl  P1) => x_ + "siguem" ;
 VP (Pres Sub Sg  P1) => x_ + "sigui" ;
 VP (Pres Sub Pl  P2) => x_ + "sigueu" ;
 VP (Pres Sub Sg  P2) => x_ + "siguis" ;
 VP (Pres Sub Pl  P3) => x_ + "siguin" ;
 VP (Pres Sub Sg  P3) => x_ + "sigui" ;
 VP (Impf Ind Pl  P1) => x_ + "érem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "era" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "éreu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "eres" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "eren" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "era" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "fóssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "fos" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "fóssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "fossis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "fossin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "fos" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "serem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "seré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "sereu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "seràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "seran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "serà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "fórem" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "fui" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "fóreu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "fores" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "foren" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "fou" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "seríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "seria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "seríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "series" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "serien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "seria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "siguem" ;
 VP (Imp Pl  P2) => x_ + "sigueu" ;
 VP (Imp Sg  P2) => x_ + "sigues" ;
 VP (Imp Pl  P3) => x_ + "siguin" ;
 VP (Imp Sg  P3) => x_ + "sigui" ;
 VP (Pass Sg  Masc) => x_ + "estat" ;
 VP (Pass Sg  Fem) => x_ + "estada" ;
 VP (Pass Pl  Masc) => x_ + "estats" ;
 VP (Pass Pl  Fem) => x_ + "estades" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper establir_53 : Str -> Verbum = \establir ->
let establ_ = Predef.tk 2 establir in
{s = table { 
 VI Infn => establ_ + "ir" ;
 VI Ger => establ_ + "int" ;
 VI Part =>  establ_ + "ert" ;
 VP (Pres Ind Pl  P1) => establ_ + "im" ;
 VP (Pres Ind Sg  P1) => establ_ + "eixo" ;
 VP (Pres Ind Pl  P2) => establ_ + "iu" ;
 VP (Pres Ind Sg  P2) => establ_ + "eixes" ;
 VP (Pres Ind Pl  P3) => establ_ + "eixen" ;
 VP (Pres Ind Sg  P3) => establ_ + "eix" ;
 VP (Pres Sub Pl  P1) => establ_ + "im" ;
 VP (Pres Sub Sg  P1) => establ_ + "eixi" ;
 VP (Pres Sub Pl  P2) => establ_ + "iu" ;
 VP (Pres Sub Sg  P2) => establ_ + "eixis" ;
 VP (Pres Sub Pl  P3) => establ_ + "eixin" ;
 VP (Pres Sub Sg  P3) => establ_ + "eixi" ;
 VP (Impf Ind Pl  P1) => establ_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => establ_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => establ_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => establ_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => establ_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => establ_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => establ_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => establ_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => establ_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => establ_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => establ_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => establ_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => establ_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => establ_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => establ_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => establ_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => establ_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => establ_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => establ_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => establ_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => establ_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => establ_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => establ_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => establ_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => establ_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => establ_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => establ_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => establ_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => establ_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => establ_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => establ_ + "im" ;
 VP (Imp Pl  P2) => establ_ + "iu" ;
 VP (Imp Sg  P2) => establ_ + "eix" ;
 VP (Imp Pl  P3) => establ_ + "eixin" ;
 VP (Imp Sg  P3) => establ_ + "eixi" ;
 VP (Pass Pl  Fem) => establ_ + "ertes" ;
 VP (Pass Sg  Fem) => establ_ + "erta" ;
 VP (Pass Pl  Masc) => establ_ + "erts" ;
 VP (Pass Sg  Masc) => establ_ + "ert" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper estar_54 : Str -> Verbum = \estar ->
let es_ = Predef.tk 3 estar in
{s = table { 
 VI Infn => es_ + "tar" ;
 VI Ger => es_ + "tant" ;
 VI Part =>  es_ + "tat" ;
 VP (Pres Ind Pl  P1) => es_ + "tem" ;
 VP (Pres Ind Sg  P1) => es_ + "tic" ;
 VP (Pres Ind Pl  P2) => es_ + "teu" ;
 VP (Pres Ind Sg  P2) => es_ + "tàs" ;
 VP (Pres Ind Pl  P3) => es_ + "tan" ;
 VP (Pres Ind Sg  P3) => es_ + "tà" ;
 VP (Pres Sub Pl  P1) => es_ + "tiguem" ;
 VP (Pres Sub Sg  P1) => es_ + "tigui" ;
 VP (Pres Sub Pl  P2) => es_ + "tigueu" ;
 VP (Pres Sub Sg  P2) => es_ + "tiguis" ;
 VP (Pres Sub Pl  P3) => es_ + "tiguin" ;
 VP (Pres Sub Sg  P3) => es_ + "tigui" ;
 VP (Impf Ind Pl  P1) => es_ + "tàvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => es_ + "tava" ;--# notpresent
 VP (Impf Ind Pl  P2) => es_ + "tàveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => es_ + "taves" ;--# notpresent
 VP (Impf Ind Pl  P3) => es_ + "taven" ;--# notpresent
 VP (Impf Ind Sg  P3) => es_ + "tava" ;--# notpresent
 VP (Impf Sub Pl  P1) => es_ + "tiguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => es_ + "tigués" ;--# notpresent
 VP (Impf Sub Pl  P2) => es_ + "tiguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => es_ + "tiguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => es_ + "tiguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => es_ + "tigués" ;--# notpresent
 VP (Fut Pl  P1)  => es_ + "tarem" ;--# notpresent
 VP (Fut Sg  P1)  => es_ + "taré" ;--# notpresent
 VP (Fut Pl  P2) => es_ + "tareu" ;--# notpresent
 VP (Fut Sg  P2) => es_ + "taràs" ;--# notpresent
 VP (Fut Pl  P3) => es_ + "taran" ;--# notpresent
 VP (Fut Sg  P3) => es_ + "tarà" ;--# notpresent
 VP (Pret Pl  P1)  => es_ + "tiguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => es_ + "tigués" ;--# notpresent
 VP (Pret Pl  P2) => es_ + "tiguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => es_ + "tiguessis" ;--# notpresent
 VP (Pret Pl  P3) => es_ + "tiguessin" ;--# notpresent
 VP (Pret Sg  P3) => es_ + "tigués" ;--# notpresent
 VP (Cond Pl  P1)  => es_ + "taríem" ;--# notpresent
 VP (Cond Sg  P1)  => es_ + "taria" ;--# notpresent
 VP (Cond Pl  P2) => es_ + "taríeu" ;--# notpresent
 VP (Cond Sg  P2) => es_ + "taries" ;--# notpresent
 VP (Cond Pl  P3) => es_ + "tarien" ;--# notpresent
 VP (Cond Sg  P3) => es_ + "taria" ;--# notpresent
 VP (Imp Pl  P1)  => es_ + "tiguem" ;
 VP (Imp Pl  P2) => es_ + "tigueu" ;
 VP (Imp Sg  P2) => es_ + "tigues" ;
 VP (Imp Pl  P3) => es_ + "tiguin" ;
 VP (Imp Sg  P3) => es_ + "tigui" ;
 VP (Pass Sg  Masc) => es_ + "tat" ;
 VP (Pass Sg  Fem) => es_ + "tada" ;
 VP (Pass Pl  Masc) => es_ + "tats" ;
 VP (Pass Pl  Fem) => es_ + "tades" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper evacuar_55 : Str -> Verbum = \evacuar ->
let evacu_ = Predef.tk 2 evacuar in
{s = table { 
 VI Infn => evacu_ + "ar" ;
 VI Ger => evacu_ + "ant" ;
 VI Part =>  evacu_ + "at" ;
 VP (Pres Ind Pl  P1) => evacu_ + "em" ;
 VP (Pres Ind Sg  P1) => evacu_ + "o" ;
 VP (Pres Ind Pl  P2) => evacu_ + "eu" ;
 VP (Pres Ind Sg  P2) => evacu_ + "es" ;
 VP (Pres Ind Pl  P3) => evacu_ + "en" ;
 VP (Pres Ind Sg  P3) => evacu_ + "a" ;
 VP (Pres Sub Pl  P1) => evacu_ + "em" ;
 VP (Pres Sub Sg  P1) => evacu_ + "ï" ;
 VP (Pres Sub Pl  P2) => evacu_ + "eu" ;
 VP (Pres Sub Sg  P2) => evacu_ + "ïs" ;
 VP (Pres Sub Pl  P3) => evacu_ + "ïn" ;
 VP (Pres Sub Sg  P3) => evacu_ + "ï" ;
 VP (Impf Ind Pl  P1) => evacu_ + "àvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => evacu_ + "ava" ;--# notpresent
 VP (Impf Ind Pl  P2) => evacu_ + "àveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => evacu_ + "aves" ;--# notpresent
 VP (Impf Ind Pl  P3) => evacu_ + "aven" ;--# notpresent
 VP (Impf Ind Sg  P3) => evacu_ + "ava" ;--# notpresent
 VP (Impf Sub Pl  P1) => evacu_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => evacu_ + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => evacu_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => evacu_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => evacu_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => evacu_ + "és" ;--# notpresent
 VP (Fut Pl  P1)  => evacu_ + "arem" ;--# notpresent
 VP (Fut Sg  P1)  => evacu_ + "aré" ;--# notpresent
 VP (Fut Pl  P2) => evacu_ + "areu" ;--# notpresent
 VP (Fut Sg  P2) => evacu_ + "aràs" ;--# notpresent
 VP (Fut Pl  P3) => evacu_ + "aran" ;--# notpresent
 VP (Fut Sg  P3) => evacu_ + "arà" ;--# notpresent
 VP (Pret Pl  P1)  => evacu_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => evacu_ + "és" ;--# notpresent
 VP (Pret Pl  P2) => evacu_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => evacu_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => evacu_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => evacu_ + "és" ;--# notpresent
 VP (Cond Pl  P1)  => evacu_ + "aríem" ;--# notpresent
 VP (Cond Sg  P1)  => evacu_ + "aria" ;--# notpresent
 VP (Cond Pl  P2) => evacu_ + "aríeu" ;--# notpresent
 VP (Cond Sg  P2) => evacu_ + "aries" ;--# notpresent
 VP (Cond Pl  P3) => evacu_ + "arien" ;--# notpresent
 VP (Cond Sg  P3) => evacu_ + "aria" ;--# notpresent
 VP (Imp Pl  P1)  => evacu_ + "em" ;
 VP (Imp Pl  P2) => evacu_ + "eu" ;
 VP (Imp Sg  P2) => evacu_ + "a" ;
 VP (Imp Pl  P3) => evacu_ + "ïn" ;
 VP (Imp Sg  P3) => evacu_ + "ï" ;
 VP (Pass Pl  Fem) => evacu_ + "ades" ;
 VP (Pass Sg  Fem) => evacu_ + "ada" ;
 VP (Pass Pl  Masc) => evacu_ + "ats" ;
 VP (Pass Sg  Masc) => evacu_ + "at" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper fer_56 : Str -> Verbum = \fer ->
let f_ = Predef.tk 2 fer in
{s = table { 
 VI Infn => f_ + "er" ;
 VI Ger => f_ + "ent" ;
 VI Part =>  f_ + "et" ;
 VP (Pres Ind Pl  P1) => f_ + "em" ;
 VP (Pres Ind Sg  P1) => f_ + "aig" ;
 VP (Pres Ind Pl  P2) => f_ + "eu" ;
 VP (Pres Ind Sg  P2) => f_ + "as" ;
 VP (Pres Ind Pl  P3) => f_ + "an" ;
 VP (Pres Ind Sg  P3) => f_ + "a" ;
 VP (Pres Sub Pl  P1) => f_ + "em" ;
 VP (Pres Sub Sg  P1) => f_ + "aci" ;
 VP (Pres Sub Pl  P2) => f_ + "eu" ;
 VP (Pres Sub Sg  P2) => f_ + "acis" ;
 VP (Pres Sub Pl  P3) => f_ + "acin" ;
 VP (Pres Sub Sg  P3) => f_ + "aci" ;
 VP (Impf Ind Pl  P1) => f_ + "èiem" ;--# notpresent
 VP (Impf Ind Sg  P1) => f_ + "eia" ;--# notpresent
 VP (Impf Ind Pl  P2) => f_ + "èieu" ;--# notpresent
 VP (Impf Ind Sg  P2) => f_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => f_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => f_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => f_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => f_ + "es" ;--# notpresent
 VP (Impf Sub Pl  P2) => f_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => f_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => f_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => f_ + "es" ;--# notpresent
 VP (Fut Pl  P1)  => f_ + "arem" ;--# notpresent
 VP (Fut Sg  P1)  => f_ + "aré" ;--# notpresent
 VP (Fut Pl  P2) => f_ + "areu" ;--# notpresent
 VP (Fut Sg  P2) => f_ + "aràs" ;--# notpresent
 VP (Fut Pl  P3) => f_ + "aran" ;--# notpresent
 VP (Fut Sg  P3) => f_ + "arà" ;--# notpresent
 VP (Pret Pl  P1)  => f_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => f_ + "es" ;--# notpresent
 VP (Pret Pl  P2) => f_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => f_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => f_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => f_ + "es" ;--# notpresent
 VP (Cond Pl  P1)  => f_ + "aríem" ;--# notpresent
 VP (Cond Sg  P1)  => f_ + "aria" ;--# notpresent
 VP (Cond Pl  P2) => f_ + "aríeu" ;--# notpresent
 VP (Cond Sg  P2) => f_ + "aries" ;--# notpresent
 VP (Cond Pl  P3) => f_ + "arien" ;--# notpresent
 VP (Cond Sg  P3) => f_ + "aria" ;--# notpresent
 VP (Imp Pl  P1)  => f_ + "em" ;
 VP (Imp Pl  P2) => f_ + "eu" ;
 VP (Imp Sg  P2) => f_ + "es" ;
 VP (Imp Pl  P3) => f_ + "acin" ;
 VP (Imp Sg  P3) => f_ + "aci" ;
 VP (Pass Pl  Fem) => f_ + "etes" ;
 VP (Pass Sg  Fem) => f_ + "eta" ;
 VP (Pass Pl  Masc) => f_ + "ets" ;
 VP (Pass Sg  Masc) => f_ + "et" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper fondre_57 : Str -> Verbum = \fondre ->
let fo_ = Predef.tk 4 fondre in
{s = table { 
 VI Infn => fo_ + "ndre" ;
 VI Ger => fo_ + "nent" ;
 VI Part =>  fo_ + "s" ;
 VP (Pres Ind Pl  P1) => fo_ + "nem" ;
 VP (Pres Ind Sg  P1) => fo_ + "nc" ;
 VP (Pres Ind Pl  P2) => fo_ + "neu" ;
 VP (Pres Ind Sg  P2) => fo_ + "ns" ;
 VP (Pres Ind Pl  P3) => fo_ + "nen" ;
 VP (Pres Ind Sg  P3) => fo_ + "n" ;
 VP (Pres Sub Pl  P1) => fo_ + "nguem" ;
 VP (Pres Sub Sg  P1) => fo_ + "ngui" ;
 VP (Pres Sub Pl  P2) => fo_ + "ngueu" ;
 VP (Pres Sub Sg  P2) => fo_ + "nguis" ;
 VP (Pres Sub Pl  P3) => fo_ + "nguin" ;
 VP (Pres Sub Sg  P3) => fo_ + "ngui" ;
 VP (Impf Ind Pl  P1) => fo_ + "níem" ;--# notpresent
 VP (Impf Ind Sg  P1) => fo_ + "nia" ;--# notpresent
 VP (Impf Ind Pl  P2) => fo_ + "níeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => fo_ + "nies" ;--# notpresent
 VP (Impf Ind Pl  P3) => fo_ + "nien" ;--# notpresent
 VP (Impf Ind Sg  P3) => fo_ + "nia" ;--# notpresent
 VP (Impf Sub Pl  P1) => fo_ + "nguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => fo_ + "ngués" ;--# notpresent
 VP (Impf Sub Pl  P2) => fo_ + "nguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => fo_ + "nguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => fo_ + "nguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => fo_ + "ngués" ;--# notpresent
 VP (Fut Pl  P1)  => fo_ + "ndrem" ;--# notpresent
 VP (Fut Sg  P1)  => fo_ + "ndré" ;--# notpresent
 VP (Fut Pl  P2) => fo_ + "ndreu" ;--# notpresent
 VP (Fut Sg  P2) => fo_ + "ndràs" ;--# notpresent
 VP (Fut Pl  P3) => fo_ + "ndran" ;--# notpresent
 VP (Fut Sg  P3) => fo_ + "ndrà" ;--# notpresent
 VP (Pret Pl  P1)  => fo_ + "nguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => fo_ + "ngués" ;--# notpresent
 VP (Pret Pl  P2) => fo_ + "nguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => fo_ + "nguessis" ;--# notpresent
 VP (Pret Pl  P3) => fo_ + "nguessin" ;--# notpresent
 VP (Pret Sg  P3) => fo_ + "ngués" ;--# notpresent
 VP (Cond Pl  P1)  => fo_ + "ndríem" ;--# notpresent
 VP (Cond Sg  P1)  => fo_ + "ndria" ;--# notpresent
 VP (Cond Pl  P2) => fo_ + "ndríeu" ;--# notpresent
 VP (Cond Sg  P2) => fo_ + "ndries" ;--# notpresent
 VP (Cond Pl  P3) => fo_ + "ndrien" ;--# notpresent
 VP (Cond Sg  P3) => fo_ + "ndria" ;--# notpresent
 VP (Imp Pl  P1)  => fo_ + "nguem" ;
 VP (Imp Pl  P2) => fo_ + "neu" ;
 VP (Imp Sg  P2) => fo_ + "n" ;
 VP (Imp Pl  P3) => fo_ + "nguin" ;
 VP (Imp Sg  P3) => fo_ + "ngui" ;
 VP (Pass Pl  Fem) => fo_ + "ses" ;
 VP (Pass Sg  Fem) => fo_ + "sa" ;
 VP (Pass Pl  Masc) => fo_ + "sos" ;
 VP (Pass Sg  Masc) => fo_ + "s" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper fugir_58 : Str -> Verbum = \fugir ->
let fu_ = Predef.tk 3 fugir in
{s = table { 
 VI Infn => fu_ + "gir" ;
 VI Ger => fu_ + "gint" ;
 VI Part =>  fu_ + "git" ;
 VP (Pres Ind Pl  P1) => fu_ + "gim" ;
 VP (Pres Ind Sg  P1) => fu_ + "jo" ;
 VP (Pres Ind Pl  P2) => fu_ + "giu" ;
 VP (Pres Ind Sg  P2) => fu_ + "ges" ;
 VP (Pres Ind Pl  P3) => fu_ + "gen" ;
 VP (Pres Ind Sg  P3) => fu_ + "ig" ;
 VP (Pres Sub Pl  P1) => fu_ + "gim" ;
 VP (Pres Sub Sg  P1) => fu_ + "gi" ;
 VP (Pres Sub Pl  P2) => fu_ + "giu" ;
 VP (Pres Sub Sg  P2) => fu_ + "gis" ;
 VP (Pres Sub Pl  P3) => fu_ + "gin" ;
 VP (Pres Sub Sg  P3) => fu_ + "gi" ;
 VP (Impf Ind Pl  P1) => fu_ + "gíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => fu_ + "gia" ;--# notpresent
 VP (Impf Ind Pl  P2) => fu_ + "gíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => fu_ + "gies" ;--# notpresent
 VP (Impf Ind Pl  P3) => fu_ + "gien" ;--# notpresent
 VP (Impf Ind Sg  P3) => fu_ + "gia" ;--# notpresent
 VP (Impf Sub Pl  P1) => fu_ + "gíssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => fu_ + "gís" ;--# notpresent
 VP (Impf Sub Pl  P2) => fu_ + "gíssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => fu_ + "gissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => fu_ + "gissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => fu_ + "gís" ;--# notpresent
 VP (Fut Pl  P1)  => fu_ + "girem" ;--# notpresent
 VP (Fut Sg  P1)  => fu_ + "giré" ;--# notpresent
 VP (Fut Pl  P2) => fu_ + "gireu" ;--# notpresent
 VP (Fut Sg  P2) => fu_ + "giràs" ;--# notpresent
 VP (Fut Pl  P3) => fu_ + "giran" ;--# notpresent
 VP (Fut Sg  P3) => fu_ + "girà" ;--# notpresent
 VP (Pret Pl  P1)  => fu_ + "gíssim" ;--# notpresent
 VP (Pret Sg  P1)  => fu_ + "gís" ;--# notpresent
 VP (Pret Pl  P2) => fu_ + "gíssiu" ;--# notpresent
 VP (Pret Sg  P2) => fu_ + "gissis" ;--# notpresent
 VP (Pret Pl  P3) => fu_ + "gissin" ;--# notpresent
 VP (Pret Sg  P3) => fu_ + "gís" ;--# notpresent
 VP (Cond Pl  P1)  => fu_ + "giríem" ;--# notpresent
 VP (Cond Sg  P1)  => fu_ + "giria" ;--# notpresent
 VP (Cond Pl  P2) => fu_ + "giríeu" ;--# notpresent
 VP (Cond Sg  P2) => fu_ + "giries" ;--# notpresent
 VP (Cond Pl  P3) => fu_ + "girien" ;--# notpresent
 VP (Cond Sg  P3) => fu_ + "giria" ;--# notpresent
 VP (Imp Pl  P1)  => fu_ + "gim" ;
 VP (Imp Pl  P2) => fu_ + "giu" ;
 VP (Imp Sg  P2) => fu_ + "ig" ;
 VP (Imp Pl  P3) => fu_ + "gin" ;
 VP (Imp Sg  P3) => fu_ + "gi" ;
 VP (Pass Pl  Fem) => fu_ + "gides" ;
 VP (Pass Sg  Fem) => fu_ + "gida" ;
 VP (Pass Pl  Masc) => fu_ + "gits" ;
 VP (Pass Sg  Masc) => fu_ + "git" ;
VP (Imp Sg P1) => variants {} 
}
} ;
oper haver_59  : Str -> Bool -> Verbum = \haver,flag -> 
      let h_ = Predef.tk 4 haver in
     {s = table {
        VI Infn=> h_ + "aver" ;
        VI Ger => h_ + "avent" ;
        VI Part => h_ + "agut" ;
        VP (Pres Ind Sg P1) => case flag of {True => h_ + "e" ; False => h_ + "aig"} ;
        VP (Pres Ind Sg P2) => h_ + "as" ;
        VP (Pres Ind Sg P3) => h_ + "a" ; 
        VP (Pres Ind Pl P1) => case flag of {True => h_ + "em" ; False => h_ + "avem"} ;
        VP (Pres Ind Pl P2) => case flag of {True => h_ + "eu" ; False => h_ + "aveu"} ;
        VP (Pres Ind Pl P3) => h_ + "an" ;
        VP (Pres Sub Sg P1) => h_ + "agi" ;
        VP (Pres Sub Sg P2) => h_ + "agis" ;
        VP (Pres Sub Sg P3) => h_ + "agi" ;
        VP (Pres Sub Pl P1) => h_ + "àgim" ;
        VP (Pres Sub Pl P2) => h_ + "àgiu" ;
        VP (Pres Sub Pl P3) => h_ + "agin" ;
        VP (Impf Ind Sg P1) => h_ + "avia" ; --# notpresent
        VP (Impf Ind Sg P2) => h_ + "avies" ; --# notpresent
        VP (Impf Ind Sg P3) => h_ + "avia" ; --# notpresent
        VP (Impf Ind Pl P1) => h_ + "avíem" ; --# notpresent
        VP (Impf Ind Pl P2) => h_ + "avíeu" ; --# notpresent
        VP (Impf Ind Pl P3) => h_ + "avien" ; --# notpresent
        VP (Impf Sub Sg P1) => h_ + "agués" ; --# notpresent
        VP (Impf Sub Sg P2) => h_ + "aguessis" ; --# notpresent
        VP (Impf Sub Sg P3) => h_ + "agués" ; --# notpresent
        VP (Impf Sub Pl P1) => h_ + "aguéssim" ; --# notpresent
        VP (Impf Sub Pl P2) => h_ + "aguéssiu" ; --# notpresent
        VP (Impf Sub Pl P3) =>  h_ + "aguessin" ; --# notpresent
        VP (Pret Sg P1) => h_ + "aguí" ; --# notpresent
        VP (Pret Sg P2) => h_ + "agueres" ; --# notpresent
        VP (Pret Sg P3) => h_ + "agué" ; --# notpresent
        VP (Pret Pl P1) => h_ + "aguérem" ; --# notpresent
        VP (Pret Pl P2) => h_ + "aguéreu" ; --# notpresent
        VP (Pret Pl P3) => h_ + "agueren" ; --# notpresent
        VP (Fut Sg P1) => h_ + "auré" ; --# notpresent
        VP (Fut Sg P2) => h_ + "auràs" ; --# notpresent
        VP (Fut Sg P3) => h_ + "aurà" ; --# notpresent
        VP (Fut Pl P1) => h_ + "aurem" ; --# notpresent
        VP (Fut Pl P2) => h_ + "aureu" ; --# notpresent
        VP (Fut Pl P3) => h_ + "auran" ; --# notpresent
        VP (Cond Sg P1) => h_ + "auria" ; --# notpresent
        VP (Cond Sg P2) => h_ + "auries" ; --# notpresent
        VP (Cond Sg P3) => h_ + "auria" ; --# notpresent
        VP (Cond Pl P1) => h_ + "auríem" ; --# notpresent
        VP (Cond Pl P2) => h_ + "auríeu" ; --# notpresent
        VP (Cond Pl P3) => h_ + "aurien" ; --# notpresent

        VP (Imp _ _) => h_ + "aver" ; ---- variants {} ;
{-
        VP (Imp Sg P1) => variants {} ;
        VP (Imp Sg P2) => variants {} ;
        VP (Imp Sg P3) => variants {} ;
        VP (Imp Pl P1) => variants {} ;
        VP (Imp Pl P2) => variants {} ;
        VP (Imp Pl P3) => variants {} ;
-}
        VP (Pass Sg Masc) => h_ + "agut" ;
        VP (Pass Sg Fem) => h_ + "aguda" ;
        VP (Pass Pl Masc) => h_ + "aguts" ;
        VP (Pass Pl Fem) => h_ + "agudes"
        }
      } ;-- heure-- is not in the used source .

oper imprimir_61 : Str -> Verbum = \imprimir ->
let impr_ = Predef.tk 4 imprimir in
{s = table { 
 VI Infn => impr_ + "imir" ;
 VI Ger => impr_ + "imint" ;
 VI Part =>  impr_ + "ès" ;
 VP (Pres Ind Pl  P1) => impr_ + "imim" ;
 VP (Pres Ind Sg  P1) => impr_ + "imeixo" ;
 VP (Pres Ind Pl  P2) => impr_ + "imiu" ;
 VP (Pres Ind Sg  P2) => impr_ + "imeixes" ;
 VP (Pres Ind Pl  P3) => impr_ + "imeixen" ;
 VP (Pres Ind Sg  P3) => impr_ + "imeix" ;
 VP (Pres Sub Pl  P1) => impr_ + "imim" ;
 VP (Pres Sub Sg  P1) => impr_ + "imeixi" ;
 VP (Pres Sub Pl  P2) => impr_ + "imiu" ;
 VP (Pres Sub Sg  P2) => impr_ + "imeixis" ;
 VP (Pres Sub Pl  P3) => impr_ + "imeixin" ;
 VP (Pres Sub Sg  P3) => impr_ + "imeixi" ;
 VP (Impf Ind Pl  P1) => impr_ + "imíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => impr_ + "imia" ;--# notpresent
 VP (Impf Ind Pl  P2) => impr_ + "imíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => impr_ + "imies" ;--# notpresent
 VP (Impf Ind Pl  P3) => impr_ + "imien" ;--# notpresent
 VP (Impf Ind Sg  P3) => impr_ + "imia" ;--# notpresent
 VP (Impf Sub Pl  P1) => impr_ + "imíssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => impr_ + "imís" ;--# notpresent
 VP (Impf Sub Pl  P2) => impr_ + "imíssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => impr_ + "imissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => impr_ + "imissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => impr_ + "imís" ;--# notpresent
 VP (Fut Pl  P1)  => impr_ + "imirem" ;--# notpresent
 VP (Fut Sg  P1)  => impr_ + "imiré" ;--# notpresent
 VP (Fut Pl  P2) => impr_ + "imireu" ;--# notpresent
 VP (Fut Sg  P2) => impr_ + "imiràs" ;--# notpresent
 VP (Fut Pl  P3) => impr_ + "imiran" ;--# notpresent
 VP (Fut Sg  P3) => impr_ + "imirà" ;--# notpresent
 VP (Pret Pl  P1)  => impr_ + "imíssim" ;--# notpresent
 VP (Pret Sg  P1)  => impr_ + "imís" ;--# notpresent
 VP (Pret Pl  P2) => impr_ + "imíssiu" ;--# notpresent
 VP (Pret Sg  P2) => impr_ + "imissis" ;--# notpresent
 VP (Pret Pl  P3) => impr_ + "imissin" ;--# notpresent
 VP (Pret Sg  P3) => impr_ + "imís" ;--# notpresent
 VP (Cond Pl  P1)  => impr_ + "imiríem" ;--# notpresent
 VP (Cond Sg  P1)  => impr_ + "imiria" ;--# notpresent
 VP (Cond Pl  P2) => impr_ + "imiríeu" ;--# notpresent
 VP (Cond Sg  P2) => impr_ + "imiries" ;--# notpresent
 VP (Cond Pl  P3) => impr_ + "imirien" ;--# notpresent
 VP (Cond Sg  P3) => impr_ + "imiria" ;--# notpresent
 VP (Imp Pl  P1)  => impr_ + "imim" ;
 VP (Imp Pl  P2) => impr_ + "imiu" ;
 VP (Imp Sg  P2) => impr_ + "imeix" ;
 VP (Imp Pl  P3) => impr_ + "imeixin" ;
 VP (Imp Sg  P3) => impr_ + "imeixi" ;
 VP (Pass Pl  Fem) => impr_ + "eses" ;
 VP (Pass Sg  Fem) => impr_ + "esa" ;
 VP (Pass Pl  Masc) => impr_ + "esos" ;
 VP (Pass Sg  Masc) => impr_ + "ès" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper jeure_62 : Str -> Verbum = \jeure ->
let j_ = Predef.tk 4 jeure in
{s = table { 
 VI Infn => j_ + "eure" ;
 VI Ger => j_ + "aient" ;
 VI Part =>  j_ + "agut" ;
 VP (Pres Ind Pl  P1) => j_ + "aiem" ;
 VP (Pres Ind Sg  P1) => j_ + "ec" ;
 VP (Pres Ind Pl  P2) => j_ + "aieu" ;
 VP (Pres Ind Sg  P2) => j_ + "eus" ;
 VP (Pres Ind Pl  P3) => j_ + "euen" ;
 VP (Pres Ind Sg  P3) => j_ + "eu" ;
 VP (Pres Sub Pl  P1) => j_ + "aguem" ;
 VP (Pres Sub Sg  P1) => j_ + "egui" ;
 VP (Pres Sub Pl  P2) => j_ + "agueu" ;
 VP (Pres Sub Sg  P2) => j_ + "eguis" ;
 VP (Pres Sub Pl  P3) => j_ + "eguin" ;
 VP (Pres Sub Sg  P3) => j_ + "egui" ;
 VP (Impf Ind Pl  P1) => j_ + "èiem" ;--# notpresent
 VP (Impf Ind Sg  P1) => j_ + "eia" ;--# notpresent
 VP (Impf Ind Pl  P2) => j_ + "èieu" ;--# notpresent
 VP (Impf Ind Sg  P2) => j_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => j_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => j_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => j_ + "aguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => j_ + "agués" ;--# notpresent
 VP (Impf Sub Pl  P2) => j_ + "aguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => j_ + "aguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => j_ + "aguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => j_ + "agués" ;--# notpresent
 VP (Fut Pl  P1)  => j_ + "aurem" ;--# notpresent
 VP (Fut Sg  P1)  => j_ + "auré" ;--# notpresent
 VP (Fut Pl  P2) => j_ + "aureu" ;--# notpresent
 VP (Fut Sg  P2) => j_ + "auràs" ;--# notpresent
 VP (Fut Pl  P3) => j_ + "auran" ;--# notpresent
 VP (Fut Sg  P3) => j_ + "aurà" ;--# notpresent
 VP (Pret Pl  P1)  => j_ + "aguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => j_ + "agués" ;--# notpresent
 VP (Pret Pl  P2) => j_ + "aguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => j_ + "aguessis" ;--# notpresent
 VP (Pret Pl  P3) => j_ + "aguessin" ;--# notpresent
 VP (Pret Sg  P3) => j_ + "agués" ;--# notpresent
 VP (Cond Pl  P1)  => j_ + "auríem" ;--# notpresent
 VP (Cond Sg  P1)  => j_ + "auria" ;--# notpresent
 VP (Cond Pl  P2) => j_ + "auríeu" ;--# notpresent
 VP (Cond Sg  P2) => j_ + "auries" ;--# notpresent
 VP (Cond Pl  P3) => j_ + "aurien" ;--# notpresent
 VP (Cond Sg  P3) => j_ + "auria" ;--# notpresent
 VP (Imp Pl  P1)  => j_ + "aguem" ;
 VP (Imp Pl  P2) => j_ + "aieu" ;
 VP (Imp Sg  P2) => j_ + "eu" ;
 VP (Imp Pl  P3) => j_ + "eguin" ;
 VP (Imp Sg  P3) => j_ + "egui" ;
 VP (Pass Pl  Fem) => j_ + "agudes" ;
 VP (Pass Sg  Fem) => j_ + "aguda" ;
 VP (Pass Pl  Masc) => j_ + "aguts" ;
 VP (Pass Sg  Masc) => j_ + "agut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper lloar_63 : Str -> Verbum = \lloar ->
let llo_ = Predef.tk 2 lloar in
{s = table { 
 VI Infn => llo_ + "ar" ;
 VI Ger => llo_ + "ant" ;
 VI Part =>  llo_ + "at" ;
 VP (Pres Ind Pl  P1) => llo_ + "em" ;
 VP (Pres Ind Sg  P1) => llo_ + "o" ;
 VP (Pres Ind Pl  P2) => llo_ + "eu" ;
 VP (Pres Ind Sg  P2) => llo_ + "es" ;
 VP (Pres Ind Pl  P3) => llo_ + "en" ;
 VP (Pres Ind Sg  P3) => llo_ + "a" ;
 VP (Pres Sub Pl  P1) => llo_ + "em" ;
 VP (Pres Sub Sg  P1) => llo_ + "i" ;
 VP (Pres Sub Pl  P2) => llo_ + "eu" ;
 VP (Pres Sub Sg  P2) => llo_ + "is" ;
 VP (Pres Sub Pl  P3) => llo_ + "in" ;
 VP (Pres Sub Sg  P3) => llo_ + "i" ;
 VP (Impf Ind Pl  P1) => llo_ + "àvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => llo_ + "ava" ;--# notpresent
 VP (Impf Ind Pl  P2) => llo_ + "àveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => llo_ + "aves" ;--# notpresent
 VP (Impf Ind Pl  P3) => llo_ + "aven" ;--# notpresent
 VP (Impf Ind Sg  P3) => llo_ + "ava" ;--# notpresent
 VP (Impf Sub Pl  P1) => llo_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => llo_ + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => llo_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => llo_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => llo_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => llo_ + "és" ;--# notpresent
 VP (Fut Pl  P1)  => llo_ + "arem" ;--# notpresent
 VP (Fut Sg  P1)  => llo_ + "aré" ;--# notpresent
 VP (Fut Pl  P2) => llo_ + "areu" ;--# notpresent
 VP (Fut Sg  P2) => llo_ + "aràs" ;--# notpresent
 VP (Fut Pl  P3) => llo_ + "aran" ;--# notpresent
 VP (Fut Sg  P3) => llo_ + "arà" ;--# notpresent
 VP (Pret Pl  P1)  => llo_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => llo_ + "és" ;--# notpresent
 VP (Pret Pl  P2) => llo_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => llo_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => llo_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => llo_ + "és" ;--# notpresent
 VP (Cond Pl  P1)  => llo_ + "aríem" ;--# notpresent
 VP (Cond Sg  P1)  => llo_ + "aria" ;--# notpresent
 VP (Cond Pl  P2) => llo_ + "aríeu" ;--# notpresent
 VP (Cond Sg  P2) => llo_ + "aries" ;--# notpresent
 VP (Cond Pl  P3) => llo_ + "arien" ;--# notpresent
 VP (Cond Sg  P3) => llo_ + "aria" ;--# notpresent
 VP (Imp Pl  P1)  => llo_ + "em" ;
 VP (Imp Pl  P2) => llo_ + "eu" ;
 VP (Imp Sg  P2) => llo_ + "a" ;
 VP (Imp Pl  P3) => llo_ + "in" ;
 VP (Imp Sg  P3) => llo_ + "i" ;
 VP (Pass Pl  Fem) => llo_ + "ades" ;
 VP (Pass Sg  Fem) => llo_ + "ada" ;
 VP (Pass Pl  Masc) => llo_ + "ats" ;
 VP (Pass Sg  Masc) => llo_ + "at" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper lluir_64 : Str -> Verbum = \lluir ->
let llu_ = Predef.tk 2 lluir in
{s = table { 
 VI Infn => llu_ + "ir" ;
 VI Ger => llu_ + "int" ;
 VI Part =>  llu_ + "ït" ;
 VP (Pres Ind Pl  P1) => llu_ + "ïm" ;
 VP (Pres Ind Sg  P1) => llu_ + "eixo" ;
 VP (Pres Ind Pl  P2) => llu_ + "ïu" ;
 VP (Pres Ind Sg  P2) => llu_ + "eixes" ;
 VP (Pres Ind Pl  P3) => llu_ + "eixen" ;
 VP (Pres Ind Sg  P3) => llu_ + "eix" ;
 VP (Pres Sub Pl  P1) => llu_ + "ïm" ;
 VP (Pres Sub Sg  P1) => llu_ + "eixi" ;
 VP (Pres Sub Pl  P2) => llu_ + "ïu" ;
 VP (Pres Sub Sg  P2) => llu_ + "eixis" ;
 VP (Pres Sub Pl  P3) => llu_ + "eixin" ;
 VP (Pres Sub Sg  P3) => llu_ + "eixi" ;
 VP (Impf Ind Pl  P1) => llu_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => llu_ + "ïa" ;--# notpresent
 VP (Impf Ind Pl  P2) => llu_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => llu_ + "ïes" ;--# notpresent
 VP (Impf Ind Pl  P3) => llu_ + "ïen" ;--# notpresent
 VP (Impf Ind Sg  P3) => llu_ + "ïa" ;--# notpresent
 VP (Impf Sub Pl  P1) => llu_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => llu_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => llu_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => llu_ + "ïssis" ;--# notpresent
 VP (Impf Sub Pl  P3) => llu_ + "ïssin" ;--# notpresent
 VP (Impf Sub Sg  P3) => llu_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => llu_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => llu_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => llu_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => llu_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => llu_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => llu_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => llu_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => llu_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => llu_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => llu_ + "ïssis" ;--# notpresent
 VP (Pret Pl  P3) => llu_ + "ïssin" ;--# notpresent
 VP (Pret Sg  P3) => llu_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => llu_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => llu_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => llu_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => llu_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => llu_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => llu_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => llu_ + "ïm" ;
 VP (Imp Pl  P2) => llu_ + "ïu" ;
 VP (Imp Sg  P2) => llu_ + "eix" ;
 VP (Imp Pl  P3) => llu_ + "eixin" ;
 VP (Imp Sg  P3) => llu_ + "eixi" ;
 VP (Pass Pl  Fem) => llu_ + "ïdes" ;
 VP (Pass Sg  Fem) => llu_ + "ïda" ;
 VP (Pass Pl  Masc) => llu_ + "ïts" ;
 VP (Pass Sg  Masc) => llu_ + "ït" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- malvendre-- is not in the used source .

oper mentir_66 : Str -> Verbum = \mentir ->
let ment_ = Predef.tk 2 mentir in
{s = table { 
 VI Infn => ment_ + "ir" ;
 VI Ger => ment_ + "int" ;
 VI Part =>  ment_ + "it" ;
 VP (Pres Ind Pl  P1) => ment_ + "im" ;
 VP (Pres Ind Sg  P1) => ment_ + "eixo" ;
 VP (Pres Ind Pl  P2) => ment_ + "iu" ;
 VP (Pres Ind Sg  P2) => ment_ + "eixes" ;
 VP (Pres Ind Pl  P3) => ment_ + "eixen" ;
 VP (Pres Ind Sg  P3) => ment_ + "eix" ;
 VP (Pres Sub Pl  P1) => ment_ + "im" ;
 VP (Pres Sub Sg  P1) => ment_ + "eixi" ;
 VP (Pres Sub Pl  P2) => ment_ + "iu" ;
 VP (Pres Sub Sg  P2) => ment_ + "eixis" ;
 VP (Pres Sub Pl  P3) => ment_ + "eixin" ;
 VP (Pres Sub Sg  P3) => ment_ + "eixi" ;
 VP (Impf Ind Pl  P1) => ment_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => ment_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => ment_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => ment_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => ment_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => ment_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => ment_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => ment_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => ment_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => ment_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => ment_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => ment_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => ment_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => ment_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => ment_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => ment_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => ment_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => ment_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => ment_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => ment_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => ment_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => ment_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => ment_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => ment_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => ment_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => ment_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => ment_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => ment_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => ment_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => ment_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => ment_ + "im" ;
 VP (Imp Pl  P2) => ment_ + "iu" ;
 VP (Imp Sg  P2) => ment_ + "eix" ;
 VP (Imp Pl  P3) => ment_ + "eixin" ;
 VP (Imp Sg  P3) => ment_ + "eixi" ;
 VP (Pass Pl  Fem) => ment_ + "ides" ;
 VP (Pass Sg  Fem) => ment_ + "ida" ;
 VP (Pass Pl  Masc) => ment_ + "its" ;
 VP (Pass Sg  Masc) => ment_ + "it" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper menysprear_67 : Str -> Verbum = \menysprear ->
let menyspre_ = Predef.tk 2 menysprear in
{s = table { 
 VI Infn => menyspre_ + "ar" ;
 VI Ger => menyspre_ + "ant" ;
 VI Part =>  menyspre_ + "at" ;
 VP (Pres Ind Pl  P1) => menyspre_ + "em" ;
 VP (Pres Ind Sg  P1) => menyspre_ + "o" ;
 VP (Pres Ind Pl  P2) => menyspre_ + "eu" ;
 VP (Pres Ind Sg  P2) => menyspre_ + "es" ;
 VP (Pres Ind Pl  P3) => menyspre_ + "en" ;
 VP (Pres Ind Sg  P3) => menyspre_ + "a" ;
 VP (Pres Sub Pl  P1) => menyspre_ + "em" ;
 VP (Pres Sub Sg  P1) => menyspre_ + "ï" ;
 VP (Pres Sub Pl  P2) => menyspre_ + "eu" ;
 VP (Pres Sub Sg  P2) => menyspre_ + "ïs" ;
 VP (Pres Sub Pl  P3) => menyspre_ + "ïn" ;
 VP (Pres Sub Sg  P3) => menyspre_ + "ï" ;
 VP (Impf Ind Pl  P1) => menyspre_ + "àvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => menyspre_ + "ava" ;--# notpresent
 VP (Impf Ind Pl  P2) => menyspre_ + "àveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => menyspre_ + "aves" ;--# notpresent
 VP (Impf Ind Pl  P3) => menyspre_ + "aven" ;--# notpresent
 VP (Impf Ind Sg  P3) => menyspre_ + "ava" ;--# notpresent
 VP (Impf Sub Pl  P1) => menyspre_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => menyspre_ + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => menyspre_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => menyspre_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => menyspre_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => menyspre_ + "és" ;--# notpresent
 VP (Fut Pl  P1)  => menyspre_ + "arem" ;--# notpresent
 VP (Fut Sg  P1)  => menyspre_ + "aré" ;--# notpresent
 VP (Fut Pl  P2) => menyspre_ + "areu" ;--# notpresent
 VP (Fut Sg  P2) => menyspre_ + "aràs" ;--# notpresent
 VP (Fut Pl  P3) => menyspre_ + "aran" ;--# notpresent
 VP (Fut Sg  P3) => menyspre_ + "arà" ;--# notpresent
 VP (Pret Pl  P1)  => menyspre_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => menyspre_ + "és" ;--# notpresent
 VP (Pret Pl  P2) => menyspre_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => menyspre_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => menyspre_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => menyspre_ + "és" ;--# notpresent
 VP (Cond Pl  P1)  => menyspre_ + "aríem" ;--# notpresent
 VP (Cond Sg  P1)  => menyspre_ + "aria" ;--# notpresent
 VP (Cond Pl  P2) => menyspre_ + "aríeu" ;--# notpresent
 VP (Cond Sg  P2) => menyspre_ + "aries" ;--# notpresent
 VP (Cond Pl  P3) => menyspre_ + "arien" ;--# notpresent
 VP (Cond Sg  P3) => menyspre_ + "aria" ;--# notpresent
 VP (Imp Pl  P1)  => menyspre_ + "em" ;
 VP (Imp Pl  P2) => menyspre_ + "eu" ;
 VP (Imp Sg  P2) => menyspre_ + "a" ;
 VP (Imp Pl  P3) => menyspre_ + "ïn" ;
 VP (Imp Sg  P3) => menyspre_ + "ï" ;
 VP (Pass Pl  Fem) => menyspre_ + "ades" ;
 VP (Pass Sg  Fem) => menyspre_ + "ada" ;
 VP (Pass Pl  Masc) => menyspre_ + "ats" ;
 VP (Pass Sg  Masc) => menyspre_ + "at" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper merèixer_68 : Str -> Verbum = \merèixer ->
let mer_ = Predef.tk 5 merèixer in
{s = table { 
 VI Ger => mer_ + "eixent" ;
 VI Part =>  mer_ + "escut" ;
 VP (Pres Ind Pl  P1) => mer_ + "eixem" ;
 VP (Pres Ind Sg  P1) => mer_ + "eixo" ;
 VP (Pres Ind Pl  P2) => mer_ + "eixeu" ;
 VP (Pres Ind Sg  P2) => mer_ + "eixes" ;
 VP (Pres Ind Pl  P3) => mer_ + "eixen" ;
 VP (Pres Ind Sg  P3) => mer_ + "eix" ;
 VP (Pres Sub Pl  P1) => mer_ + "eixem" ;
 VP (Pres Sub Sg  P1) => mer_ + "eixi" ;
 VP (Pres Sub Pl  P2) => mer_ + "eixeu" ;
 VP (Pres Sub Sg  P2) => mer_ + "eixis" ;
 VP (Pres Sub Pl  P3) => mer_ + "eixin" ;
 VP (Pres Sub Sg  P3) => mer_ + "eixi" ;
 VP (Impf Ind Pl  P1) => mer_ + "eixíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => mer_ + "eixia" ;--# notpresent
 VP (Impf Ind Pl  P2) => mer_ + "eixíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => mer_ + "eixies" ;--# notpresent
 VP (Impf Ind Pl  P3) => mer_ + "eixien" ;--# notpresent
 VP (Impf Ind Sg  P3) => mer_ + "eixia" ;--# notpresent
 VP (Impf Sub Pl  P1) => mer_ + "eixéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => mer_ + "eixés" ;--# notpresent
 VP (Impf Sub Pl  P2) => mer_ + "eixéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => mer_ + "eixessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => mer_ + "eixessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => mer_ + "eixés" ;--# notpresent
 VP (Fut Pl  P1)  => mer_ + "eixerem" ;--# notpresent
 VP (Fut Sg  P1)  => mer_ + "eixeré" ;--# notpresent
 VP (Fut Pl  P2) => mer_ + "eixereu" ;--# notpresent
 VP (Fut Sg  P2) => mer_ + "eixeràs" ;--# notpresent
 VP (Fut Pl  P3) => mer_ + "eixeran" ;--# notpresent
 VP (Fut Sg  P3) => mer_ + "eixerà" ;--# notpresent
 VP (Pret Pl  P1)  => mer_ + "eixéssim" ;--# notpresent
 VP (Pret Sg  P1)  => mer_ + "eixés" ;--# notpresent
 VP (Pret Pl  P2) => mer_ + "eixéssiu" ;--# notpresent
 VP (Pret Sg  P2) => mer_ + "eixessis" ;--# notpresent
 VP (Pret Pl  P3) => mer_ + "eixessin" ;--# notpresent
 VP (Pret Sg  P3) => mer_ + "eixés" ;--# notpresent
 VP (Cond Pl  P1)  => mer_ + "eixeríem" ;--# notpresent
 VP (Cond Sg  P1)  => mer_ + "eixeria" ;--# notpresent
 VP (Cond Pl  P2) => mer_ + "eixeríeu" ;--# notpresent
 VP (Cond Sg  P2) => mer_ + "eixeries" ;--# notpresent
 VP (Cond Pl  P3) => mer_ + "eixerien" ;--# notpresent
 VP (Cond Sg  P3) => mer_ + "eixeria" ;--# notpresent
 VP (Imp Pl  P1)  => mer_ + "eixem" ;
 VP (Imp Pl  P2) => mer_ + "eixeu" ;
 VP (Imp Sg  P2) => mer_ + "eix" ;
 VP (Imp Pl  P3) => mer_ + "eixin" ;
 VP (Imp Sg  P3) => mer_ + "eixi" ;
 VP (Pass Pl  Fem) => mer_ + "escudes" ;
 VP (Pass Sg  Fem) => mer_ + "escuda" ;
 VP (Pass Pl  Masc) => mer_ + "escuts" ;
 VP (Pass Sg  Masc) => mer_ + "escut" ;
 VI Infn => mer_ + "èixer" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- metre-- is not in the used source .
-- moldre-- is not in the used source .

oper morir_71 : Str -> Verbum = \morir ->
let m_ = Predef.tk 4 morir in
{s = table { 
 VI Infn => m_ + "orir" ;
 VI Ger => m_ + "orint" ;
 VI Part =>  m_ + "ort" ;
 VP (Pres Ind Pl  P1) => m_ + "orim" ;
 VP (Pres Ind Sg  P1) => m_ + "oro" ;
 VP (Pres Ind Pl  P2) => m_ + "oriu" ;
 VP (Pres Ind Sg  P2) => m_ + "ors" ;
 VP (Pres Ind Pl  P3) => m_ + "oren" ;
 VP (Pres Ind Sg  P3) => m_ + "or" ;
 VP (Pres Sub Pl  P1) => m_ + "orim" ;
 VP (Pres Sub Sg  P1) => m_ + "ori" ;
 VP (Pres Sub Pl  P2) => m_ + "oriu" ;
 VP (Pres Sub Sg  P2) => m_ + "oris" ;
 VP (Pres Sub Pl  P3) => m_ + "orin" ;
 VP (Pres Sub Sg  P3) => m_ + "ori" ;
 VP (Impf Ind Pl  P1) => m_ + "oríem" ;--# notpresent
 VP (Impf Ind Sg  P1) => m_ + "oria" ;--# notpresent
 VP (Impf Ind Pl  P2) => m_ + "oríeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => m_ + "ories" ;--# notpresent
 VP (Impf Ind Pl  P3) => m_ + "orien" ;--# notpresent
 VP (Impf Ind Sg  P3) => m_ + "oria" ;--# notpresent
 VP (Impf Sub Pl  P1) => m_ + "oríssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => m_ + "orís" ;--# notpresent
 VP (Impf Sub Pl  P2) => m_ + "oríssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => m_ + "orissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => m_ + "orissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => m_ + "orís" ;--# notpresent
 VP (Fut Pl  P1)  => m_ + "orirem" ;--# notpresent
 VP (Fut Sg  P1)  => m_ + "oriré" ;--# notpresent
 VP (Fut Pl  P2) => m_ + "orireu" ;--# notpresent
 VP (Fut Sg  P2) => m_ + "oriràs" ;--# notpresent
 VP (Fut Pl  P3) => m_ + "oriran" ;--# notpresent
 VP (Fut Sg  P3) => m_ + "orirà" ;--# notpresent
 VP (Pret Pl  P1)  => m_ + "oríssim" ;--# notpresent
 VP (Pret Sg  P1)  => m_ + "orís" ;--# notpresent
 VP (Pret Pl  P2) => m_ + "oríssiu" ;--# notpresent
 VP (Pret Sg  P2) => m_ + "orissis" ;--# notpresent
 VP (Pret Pl  P3) => m_ + "orissin" ;--# notpresent
 VP (Pret Sg  P3) => m_ + "orís" ;--# notpresent
 VP (Cond Pl  P1)  => m_ + "oriríem" ;--# notpresent
 VP (Cond Sg  P1)  => m_ + "oriria" ;--# notpresent
 VP (Cond Pl  P2) => m_ + "oriríeu" ;--# notpresent
 VP (Cond Sg  P2) => m_ + "oriries" ;--# notpresent
 VP (Cond Pl  P3) => m_ + "oririen" ;--# notpresent
 VP (Cond Sg  P3) => m_ + "oriria" ;--# notpresent
 VP (Imp Pl  P1)  => m_ + "orim" ;
 VP (Imp Pl  P2) => m_ + "oriu" ;
 VP (Imp Sg  P2) => m_ + "or" ;
 VP (Imp Pl  P3) => m_ + "orin" ;
 VP (Imp Sg  P3) => m_ + "ori" ;
 VP (Pass Pl  Fem) => m_ + "ortes" ;
 VP (Pass Sg  Fem) => m_ + "orta" ;
 VP (Pass Pl  Masc) => m_ + "orts" ;
 VP (Pass Sg  Masc) => m_ + "ort" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper moure_72 : Str -> Verbum = \moure ->
let mo_ = Predef.tk 3 moure in
{s = table { 
 VI Infn => mo_ + "ure" ;
 VI Ger => mo_ + "vent" ;
 VI Part =>  mo_ + "gut" ;
 VP (Pres Ind Pl  P1) => mo_ + "vem" ;
 VP (Pres Ind Sg  P1) => mo_ + "c" ;
 VP (Pres Ind Pl  P2) => mo_ + "veu" ;
 VP (Pres Ind Sg  P2) => mo_ + "us" ;
 VP (Pres Ind Pl  P3) => mo_ + "uen" ;
 VP (Pres Ind Sg  P3) => mo_ + "u" ;
 VP (Pres Sub Pl  P1) => mo_ + "guem" ;
 VP (Pres Sub Sg  P1) => mo_ + "gui" ;
 VP (Pres Sub Pl  P2) => mo_ + "gueu" ;
 VP (Pres Sub Sg  P2) => mo_ + "guis" ;
 VP (Pres Sub Pl  P3) => mo_ + "guin" ;
 VP (Pres Sub Sg  P3) => mo_ + "gui" ;
 VP (Impf Ind Pl  P1) => mo_ + "víem" ;--# notpresent
 VP (Impf Ind Sg  P1) => mo_ + "via" ;--# notpresent
 VP (Impf Ind Pl  P2) => mo_ + "víeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => mo_ + "vies" ;--# notpresent
 VP (Impf Ind Pl  P3) => mo_ + "vien" ;--# notpresent
 VP (Impf Ind Sg  P3) => mo_ + "via" ;--# notpresent
 VP (Impf Sub Pl  P1) => mo_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => mo_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => mo_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => mo_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => mo_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => mo_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => mo_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => mo_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => mo_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => mo_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => mo_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => mo_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => mo_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => mo_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => mo_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => mo_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => mo_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => mo_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => mo_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => mo_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => mo_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => mo_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => mo_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => mo_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => mo_ + "guem" ;
 VP (Imp Pl  P2) => mo_ + "veu" ;
 VP (Imp Sg  P2) => mo_ + "u" ;
 VP (Imp Pl  P3) => mo_ + "guin" ;
 VP (Imp Sg  P3) => mo_ + "gui" ;
 VP (Pass Pl  Fem) => mo_ + "gudes" ;
 VP (Pass Sg  Fem) => mo_ + "guda" ;
 VP (Pass Pl  Masc) => mo_ + "guts" ;
 VP (Pass Sg  Masc) => mo_ + "gut" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- munyir-- is not in the used source .

oper néixer_74 : Str -> Verbum = \néixer ->
let n_ = Predef.tk 5 néixer in
{s = table { 
 VI Infn => n_ + "éixer" ;
 VI Ger => n_ + "aixent" ;
 VI Part =>  n_ + "ascut" ;
 VP (Pres Ind Pl  P1) => n_ + "aixem" ;
 VP (Pres Ind Sg  P1) => n_ + "eixo" ;
 VP (Pres Ind Pl  P2) => n_ + "aixeu" ;
 VP (Pres Ind Sg  P2) => n_ + "eixes" ;
 VP (Pres Ind Pl  P3) => n_ + "eixen" ;
 VP (Pres Ind Sg  P3) => n_ + "eix" ;
 VP (Pres Sub Pl  P1) => n_ + "aixem" ;
 VP (Pres Sub Sg  P1) => n_ + "eixi" ;
 VP (Pres Sub Pl  P2) => n_ + "aixeu" ;
 VP (Pres Sub Sg  P2) => n_ + "eixis" ;
 VP (Pres Sub Pl  P3) => n_ + "eixin" ;
 VP (Pres Sub Sg  P3) => n_ + "eixi" ;
 VP (Impf Ind Pl  P1) => n_ + "aixíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => n_ + "aixia" ;--# notpresent
 VP (Impf Ind Pl  P2) => n_ + "aixíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => n_ + "aixies" ;--# notpresent
 VP (Impf Ind Pl  P3) => n_ + "aixien" ;--# notpresent
 VP (Impf Ind Sg  P3) => n_ + "aixia" ;--# notpresent
 VP (Impf Sub Pl  P1) => n_ + "aixéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => n_ + "aixés" ;--# notpresent
 VP (Impf Sub Pl  P2) => n_ + "aixéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => n_ + "aixessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => n_ + "aixessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => n_ + "aixés" ;--# notpresent
 VP (Fut Pl  P1)  => n_ + "aixerem" ;--# notpresent
 VP (Fut Sg  P1)  => n_ + "aixeré" ;--# notpresent
 VP (Fut Pl  P2) => n_ + "aixereu" ;--# notpresent
 VP (Fut Sg  P2) => n_ + "aixeràs" ;--# notpresent
 VP (Fut Pl  P3) => n_ + "aixeran" ;--# notpresent
 VP (Fut Sg  P3) => n_ + "aixerà" ;--# notpresent
 VP (Pret Pl  P1)  => n_ + "aixéssim" ;--# notpresent
 VP (Pret Sg  P1)  => n_ + "aixés" ;--# notpresent
 VP (Pret Pl  P2) => n_ + "aixéssiu" ;--# notpresent
 VP (Pret Sg  P2) => n_ + "aixessis" ;--# notpresent
 VP (Pret Pl  P3) => n_ + "aixessin" ;--# notpresent
 VP (Pret Sg  P3) => n_ + "aixés" ;--# notpresent
 VP (Cond Pl  P1)  => n_ + "aixeríem" ;--# notpresent
 VP (Cond Sg  P1)  => n_ + "aixeria" ;--# notpresent
 VP (Cond Pl  P2) => n_ + "aixeríeu" ;--# notpresent
 VP (Cond Sg  P2) => n_ + "aixeries" ;--# notpresent
 VP (Cond Pl  P3) => n_ + "aixerien" ;--# notpresent
 VP (Cond Sg  P3) => n_ + "aixeria" ;--# notpresent
 VP (Imp Pl  P1)  => n_ + "aixem" ;
 VP (Imp Pl  P2) => n_ + "aixeu" ;
 VP (Imp Sg  P2) => n_ + "eix" ;
 VP (Imp Pl  P3) => n_ + "eixin" ;
 VP (Imp Sg  P3) => n_ + "eixi" ;
 VP (Pass Pl  Fem) => n_ + "ascudes" ;
 VP (Pass Sg  Fem) => n_ + "ascuda" ;
 VP (Pass Pl  Masc) => n_ + "ascuts" ;
 VP (Pass Sg  Masc) => n_ + "ascut" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- noure-- is not in the used source .
-- obliquar-- is not in the used source .

oper obrir_77 : Str -> Verbum = \obrir ->
let x_ = Predef.tk 5 obrir in
{s = table { 
 VI Infn => x_ + "rir" ;
 VI Ger => x_ + "rint" ;
 VI Part =>  x_ + "ert" ;
 VP (Pres Ind Pl  P1) => x_ + "rim" ;
 VP (Pres Ind Sg  P1) => x_ + "ro" ;
 VP (Pres Ind Pl  P2) => x_ + "riu" ;
 VP (Pres Ind Sg  P2) => x_ + "res" ;
 VP (Pres Ind Pl  P3) => x_ + "ren" ;
 VP (Pres Ind Sg  P3) => x_ + "re" ;
 VP (Pres Sub Pl  P1) => x_ + "rim" ;
 VP (Pres Sub Sg  P1) => x_ + "ri" ;
 VP (Pres Sub Pl  P2) => x_ + "riu" ;
 VP (Pres Sub Sg  P2) => x_ + "ris" ;
 VP (Pres Sub Pl  P3) => x_ + "rin" ;
 VP (Pres Sub Sg  P3) => x_ + "ri" ;
 VP (Impf Ind Pl  P1) => x_ + "ríem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "ria" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "ríeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "ries" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "rien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "ria" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "ríssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "rís" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "ríssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "rissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "rissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "rís" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "rirem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "riré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "rireu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "riràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "riran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "rirà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "ríssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "rís" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "ríssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "rissis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "rissin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "rís" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "riríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "riria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "riríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "riries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "ririen" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "riria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "rim" ;
 VP (Imp Pl  P2) => x_ + "riu" ;
 VP (Imp Sg  P2) => x_ + "re" ;
 VP (Imp Pl  P3) => x_ + "rin" ;
 VP (Imp Sg  P3) => x_ + "ri" ;
 VP (Pass Pl  Fem) => x_ + "ertes" ;
 VP (Pass Sg  Fem) => x_ + "erta" ;
 VP (Pass Pl  Masc) => x_ + "erts" ;
 VP (Pass Sg  Masc) => x_ + "ert" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper obtenir_78 : Str -> Verbum = \obtenir ->
let ob_ = Predef.tk 5 obtenir in
{s = table { 
 VI Infn => ob_ + "tenir" ;
 VI Ger => ob_ + "tenint" ;
 VI Part =>  ob_ + "tingut" ;
 VP (Pres Ind Pl  P1) => ob_ + "tenim" ;
 VP (Pres Ind Sg  P1) => ob_ + "tinc" ;
 VP (Pres Ind Pl  P2) => ob_ + "teniu" ;
 VP (Pres Ind Sg  P2) => ob_ + "tens" ;
 VP (Pres Ind Pl  P3) => ob_ + "tenen" ;
 VP (Pres Ind Sg  P3) => ob_ + "té" ;
 VP (Pres Sub Pl  P1) => ob_ + "tinguem" ;
 VP (Pres Sub Sg  P1) => ob_ + "tingui" ;
 VP (Pres Sub Pl  P2) => ob_ + "tingueu" ;
 VP (Pres Sub Sg  P2) => ob_ + "tinguis" ;
 VP (Pres Sub Pl  P3) => ob_ + "tinguin" ;
 VP (Pres Sub Sg  P3) => ob_ + "tingui" ;
 VP (Impf Ind Pl  P1) => ob_ + "teníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => ob_ + "tenia" ;--# notpresent
 VP (Impf Ind Pl  P2) => ob_ + "teníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => ob_ + "tenies" ;--# notpresent
 VP (Impf Ind Pl  P3) => ob_ + "tenien" ;--# notpresent
 VP (Impf Ind Sg  P3) => ob_ + "tenia" ;--# notpresent
 VP (Impf Sub Pl  P1) => ob_ + "tinguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => ob_ + "tingués" ;--# notpresent
 VP (Impf Sub Pl  P2) => ob_ + "tinguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => ob_ + "tinguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => ob_ + "tinguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => ob_ + "tingués" ;--# notpresent
 VP (Fut Pl  P1)  => ob_ + "tindrem" ;--# notpresent
 VP (Fut Sg  P1)  => ob_ + "tindré" ;--# notpresent
 VP (Fut Pl  P2) => ob_ + "tindreu" ;--# notpresent
 VP (Fut Sg  P2) => ob_ + "tindràs" ;--# notpresent
 VP (Fut Pl  P3) => ob_ + "tindran" ;--# notpresent
 VP (Fut Sg  P3) => ob_ + "tindrà" ;--# notpresent
 VP (Pret Pl  P1)  => ob_ + "tinguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => ob_ + "tingués" ;--# notpresent
 VP (Pret Pl  P2) => ob_ + "tinguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => ob_ + "tinguessis" ;--# notpresent
 VP (Pret Pl  P3) => ob_ + "tinguessin" ;--# notpresent
 VP (Pret Sg  P3) => ob_ + "tingués" ;--# notpresent
 VP (Cond Pl  P1)  => ob_ + "tindríem" ;--# notpresent
 VP (Cond Sg  P1)  => ob_ + "tindria" ;--# notpresent
 VP (Cond Pl  P2) => ob_ + "tindríeu" ;--# notpresent
 VP (Cond Sg  P2) => ob_ + "tindries" ;--# notpresent
 VP (Cond Pl  P3) => ob_ + "tindrien" ;--# notpresent
 VP (Cond Sg  P3) => ob_ + "tindria" ;--# notpresent
 VP (Imp Pl  P1)  => ob_ + "tinguem" ;
 VP (Imp Pl  P2) => ob_ + "tingueu" ;
 VP (Imp Sg  P2) => ob_ + "tingues" ;
 VP (Imp Pl  P3) => ob_ + "tinguin" ;
 VP (Imp Sg  P3) => ob_ + "tingui" ;
 VP (Pass Pl  Fem) => ob_ + "tingudes" ;
 VP (Pass Sg  Fem) => ob_ + "tinguda" ;
 VP (Pass Pl  Masc) => ob_ + "tinguts" ;
 VP (Pass Sg  Masc) => ob_ + "tingut" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- oir-- is not in the used source .

oper omplir_80 : Str -> Verbum = \omplir ->
let x_ = Predef.tk 6 omplir in
{s = table { 
 VI Infn => x_ + "ir" ;
 VI Ger => x_ + "int" ;
 VI Part =>  x_ + "ert" ;
 VP (Pres Ind Pl  P1) => x_ + "im" ;
 VP (Pres Ind Sg  P1) => x_ + "o" ;
 VP (Pres Ind Pl  P2) => x_ + "iu" ;
 VP (Pres Ind Sg  P2) => x_ + "es" ;
 VP (Pres Ind Pl  P3) => x_ + "en" ;
 VP (Pres Ind Sg  P3) => x_ + "e" ;
 VP (Pres Sub Pl  P1) => x_ + "im" ;
 VP (Pres Sub Sg  P1) => x_ + "i" ;
 VP (Pres Sub Pl  P2) => x_ + "iu" ;
 VP (Pres Sub Sg  P2) => x_ + "is" ;
 VP (Pres Sub Pl  P3) => x_ + "in" ;
 VP (Pres Sub Sg  P3) => x_ + "i" ;
 VP (Impf Ind Pl  P1) => x_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "im" ;
 VP (Imp Pl  P2) => x_ + "iu" ;
 VP (Imp Sg  P2) => x_ + "e" ;
 VP (Imp Pl  P3) => x_ + "in" ;
 VP (Imp Sg  P3) => x_ + "i" ;
 VP (Pass Pl  Fem) => x_ + "ertes" ;
 VP (Pass Sg  Fem) => x_ + "erta" ;
 VP (Pass Pl  Masc) => x_ + "erts" ;
 VP (Pass Sg  Masc) => x_ + "ert" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper patir_81 : Str -> Verbum = \patir ->
let pat_ = Predef.tk 2 patir in
{s = table { 
 VI Infn => pat_ + "ir" ;
 VI Ger => pat_ + "int" ;
 VI Part =>  pat_ + "it" ;
 VP (Pres Ind Pl  P1) => pat_ + "im" ;
 VP (Pres Ind Sg  P1) => pat_ + "eixo" ;
 VP (Pres Ind Pl  P2) => pat_ + "iu" ;
 VP (Pres Ind Sg  P2) => pat_ + "eixes" ;
 VP (Pres Ind Pl  P3) => pat_ + "eixen" ;
 VP (Pres Ind Sg  P3) => pat_ + "eix" ;
 VP (Pres Sub Pl  P1) => pat_ + "im" ;
 VP (Pres Sub Sg  P1) => pat_ + "eixi" ;
 VP (Pres Sub Pl  P2) => pat_ + "iu" ;
 VP (Pres Sub Sg  P2) => pat_ + "eixis" ;
 VP (Pres Sub Pl  P3) => pat_ + "eixin" ;
 VP (Pres Sub Sg  P3) => pat_ + "eixi" ;
 VP (Impf Ind Pl  P1) => pat_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => pat_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => pat_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => pat_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => pat_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => pat_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => pat_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => pat_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => pat_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => pat_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => pat_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => pat_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => pat_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => pat_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => pat_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => pat_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => pat_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => pat_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => pat_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => pat_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => pat_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => pat_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => pat_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => pat_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => pat_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => pat_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => pat_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => pat_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => pat_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => pat_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => pat_ + "im" ;
 VP (Imp Pl  P2) => pat_ + "iu" ;
 VP (Imp Sg  P2) => pat_ + "eix" ;
 VP (Imp Pl  P3) => pat_ + "eixin" ;
 VP (Imp Sg  P3) => pat_ + "eixi" ;
 VP (Pass Pl  Fem) => pat_ + "ides" ;
 VP (Pass Sg  Fem) => pat_ + "ida" ;
 VP (Pass Pl  Masc) => pat_ + "its" ;
 VP (Pass Sg  Masc) => pat_ + "it" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- péixer-- is not in the used source .

oper perdre_83 : Str -> Verbum = \perdre ->
let perd_ = Predef.tk 2 perdre in
{s = table { 
 VI Infn => perd_ + "re" ;
 VI Ger => perd_ + "ent" ;
 VI Part =>  perd_ + "ut" ;
 VP (Pres Ind Pl  P1) => perd_ + "em" ;
 VP (Pres Ind Sg  P1) => perd_ + "o" ;
 VP (Pres Ind Pl  P2) => perd_ + "eu" ;
 VP (Pres Ind Sg  P2) => perd_ + "s" ;
 VP (Pres Ind Pl  P3) => perd_ + "en" ;
 VP (Pres Ind Sg  P3) => perd_ + "" ;
 VP (Pres Sub Pl  P1) => perd_ + "em" ;
 VP (Pres Sub Sg  P1) => perd_ + "i" ;
 VP (Pres Sub Pl  P2) => perd_ + "eu" ;
 VP (Pres Sub Sg  P2) => perd_ + "is" ;
 VP (Pres Sub Pl  P3) => perd_ + "in" ;
 VP (Pres Sub Sg  P3) => perd_ + "i" ;
 VP (Impf Ind Pl  P1) => perd_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => perd_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => perd_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => perd_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => perd_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => perd_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => perd_ + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => perd_ + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => perd_ + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => perd_ + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => perd_ + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => perd_ + "és" ;--# notpresent
 VP (Fut Pl  P1)  => perd_ + "rem" ;--# notpresent
 VP (Fut Sg  P1)  => perd_ + "ré" ;--# notpresent
 VP (Fut Pl  P2) => perd_ + "reu" ;--# notpresent
 VP (Fut Sg  P2) => perd_ + "ràs" ;--# notpresent
 VP (Fut Pl  P3) => perd_ + "ran" ;--# notpresent
 VP (Fut Sg  P3) => perd_ + "rà" ;--# notpresent
 VP (Pret Pl  P1)  => perd_ + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => perd_ + "és" ;--# notpresent
 VP (Pret Pl  P2) => perd_ + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => perd_ + "essis" ;--# notpresent
 VP (Pret Pl  P3) => perd_ + "essin" ;--# notpresent
 VP (Pret Sg  P3) => perd_ + "és" ;--# notpresent
 VP (Cond Pl  P1)  => perd_ + "ríem" ;--# notpresent
 VP (Cond Sg  P1)  => perd_ + "ria" ;--# notpresent
 VP (Cond Pl  P2) => perd_ + "ríeu" ;--# notpresent
 VP (Cond Sg  P2) => perd_ + "ries" ;--# notpresent
 VP (Cond Pl  P3) => perd_ + "rien" ;--# notpresent
 VP (Cond Sg  P3) => perd_ + "ria" ;--# notpresent
 VP (Imp Pl  P1)  => perd_ + "em" ;
 VP (Imp Pl  P2) => perd_ + "eu" ;
 VP (Imp Sg  P2) => perd_ + "" ;
 VP (Imp Pl  P3) => perd_ + "in" ;
 VP (Imp Sg  P3) => perd_ + "i" ;
 VP (Pass Pl  Fem) => perd_ + "udes" ;
 VP (Pass Sg  Fem) => perd_ + "uda" ;
 VP (Pass Pl  Masc) => perd_ + "uts" ;
 VP (Pass Sg  Masc) => perd_ + "ut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper pertànyer_84 : Str -> Verbum = \pertànyer ->
let pert_ = Predef.tk 5 pertànyer in
{s = table { 
 VI Ger => pert_ + "anyent" ;
 VI Part =>  pert_ + "angut" ;
 VP (Pres Ind Pl  P1) => pert_ + "anyem" ;
 VP (Pres Ind Sg  P1) => pert_ + "anyo" ;
 VP (Pres Ind Pl  P2) => pert_ + "anyeu" ;
 VP (Pres Ind Sg  P2) => pert_ + "anys" ;
 VP (Pres Ind Pl  P3) => pert_ + "anyen" ;
 VP (Pres Ind Sg  P3) => pert_ + "any" ;
 VP (Pres Sub Pl  P1) => pert_ + "anyem" ;
 VP (Pres Sub Sg  P1) => pert_ + "anyi" ;
 VP (Pres Sub Pl  P2) => pert_ + "anyeu" ;
 VP (Pres Sub Sg  P2) => pert_ + "anyis" ;
 VP (Pres Sub Pl  P3) => pert_ + "anyin" ;
 VP (Pres Sub Sg  P3) => pert_ + "anyi" ;
 VP (Impf Ind Pl  P1) => pert_ + "anyíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => pert_ + "anyia" ;--# notpresent
 VP (Impf Ind Pl  P2) => pert_ + "anyíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => pert_ + "anyies" ;--# notpresent
 VP (Impf Ind Pl  P3) => pert_ + "anyien" ;--# notpresent
 VP (Impf Ind Sg  P3) => pert_ + "anyia" ;--# notpresent
 VP (Impf Sub Pl  P1) => pert_ + "anyéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => pert_ + "anyés" ;--# notpresent
 VP (Impf Sub Pl  P2) => pert_ + "anyéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => pert_ + "anyessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => pert_ + "anyessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => pert_ + "anyés" ;--# notpresent
 VP (Fut Pl  P1)  => pert_ + "anyerem" ;--# notpresent
 VP (Fut Sg  P1)  => pert_ + "anyeré" ;--# notpresent
 VP (Fut Pl  P2) => pert_ + "anyereu" ;--# notpresent
 VP (Fut Sg  P2) => pert_ + "anyeràs" ;--# notpresent
 VP (Fut Pl  P3) => pert_ + "anyeran" ;--# notpresent
 VP (Fut Sg  P3) => pert_ + "anyerà" ;--# notpresent
 VP (Pret Pl  P1)  => pert_ + "anyéssim" ;--# notpresent
 VP (Pret Sg  P1)  => pert_ + "anyés" ;--# notpresent
 VP (Pret Pl  P2) => pert_ + "anyéssiu" ;--# notpresent
 VP (Pret Sg  P2) => pert_ + "anyessis" ;--# notpresent
 VP (Pret Pl  P3) => pert_ + "anyessin" ;--# notpresent
 VP (Pret Sg  P3) => pert_ + "anyés" ;--# notpresent
 VP (Cond Pl  P1)  => pert_ + "anyeríem" ;--# notpresent
 VP (Cond Sg  P1)  => pert_ + "anyeria" ;--# notpresent
 VP (Cond Pl  P2) => pert_ + "anyeríeu" ;--# notpresent
 VP (Cond Sg  P2) => pert_ + "anyeries" ;--# notpresent
 VP (Cond Pl  P3) => pert_ + "anyerien" ;--# notpresent
 VP (Cond Sg  P3) => pert_ + "anyeria" ;--# notpresent
 VP (Imp Pl  P1)  => pert_ + "anyem" ;
 VP (Imp Pl  P2) => pert_ + "anyeu" ;
 VP (Imp Sg  P2) => pert_ + "any" ;
 VP (Imp Pl  P3) => pert_ + "anyin" ;
 VP (Imp Sg  P3) => pert_ + "anyi" ;
 VP (Pass Pl  Fem) => pert_ + "angudes" ;
 VP (Pass Sg  Fem) => pert_ + "anguda" ;
 VP (Pass Pl  Masc) => pert_ + "anguts" ;
 VP (Pass Sg  Masc) => pert_ + "angut" ;
 VI Infn => pert_ + "ànyer" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper poder_85 : Str -> Verbum = \poder ->
let p_ = Predef.tk 4 poder in
{s = table { 
 VI Infn => p_ + "oder" ;
 VI Ger => p_ + "odent" ;
 VI Part =>  p_ + "ogut" ;
 VP (Pres Ind Pl  P1) => p_ + "odem" ;
 VP (Pres Ind Sg  P1) => p_ + "uc" ;
 VP (Pres Ind Pl  P2) => p_ + "odeu" ;
 VP (Pres Ind Sg  P2) => p_ + "ots" ;
 VP (Pres Ind Pl  P3) => p_ + "oden" ;
 VP (Pres Ind Sg  P3) => p_ + "ot" ;
 VP (Pres Sub Pl  P1) => p_ + "uguem" ;
 VP (Pres Sub Sg  P1) => p_ + "ugui" ;
 VP (Pres Sub Pl  P2) => p_ + "ugueu" ;
 VP (Pres Sub Sg  P2) => p_ + "uguis" ;
 VP (Pres Sub Pl  P3) => p_ + "uguin" ;
 VP (Pres Sub Sg  P3) => p_ + "ugui" ;
 VP (Impf Ind Pl  P1) => p_ + "odíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => p_ + "odia" ;--# notpresent
 VP (Impf Ind Pl  P2) => p_ + "odíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => p_ + "odies" ;--# notpresent
 VP (Impf Ind Pl  P3) => p_ + "odien" ;--# notpresent
 VP (Impf Ind Sg  P3) => p_ + "odia" ;--# notpresent
 VP (Impf Sub Pl  P1) => p_ + "oguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => p_ + "ogués" ;--# notpresent
 VP (Impf Sub Pl  P2) => p_ + "oguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => p_ + "oguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => p_ + "oguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => p_ + "ogués" ;--# notpresent
 VP (Fut Pl  P1)  => p_ + "odrem" ;--# notpresent
 VP (Fut Sg  P1)  => p_ + "odré" ;--# notpresent
 VP (Fut Pl  P2) => p_ + "odreu" ;--# notpresent
 VP (Fut Sg  P2) => p_ + "odràs" ;--# notpresent
 VP (Fut Pl  P3) => p_ + "odran" ;--# notpresent
 VP (Fut Sg  P3) => p_ + "odrà" ;--# notpresent
 VP (Pret Pl  P1)  => p_ + "oguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => p_ + "ogués" ;--# notpresent
 VP (Pret Pl  P2) => p_ + "oguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => p_ + "oguessis" ;--# notpresent
 VP (Pret Pl  P3) => p_ + "oguessin" ;--# notpresent
 VP (Pret Sg  P3) => p_ + "ogués" ;--# notpresent
 VP (Cond Pl  P1)  => p_ + "odríem" ;--# notpresent
 VP (Cond Sg  P1)  => p_ + "odria" ;--# notpresent
 VP (Cond Pl  P2) => p_ + "odríeu" ;--# notpresent
 VP (Cond Sg  P2) => p_ + "odries" ;--# notpresent
 VP (Cond Pl  P3) => p_ + "odrien" ;--# notpresent
 VP (Cond Sg  P3) => p_ + "odria" ;--# notpresent
 VP (Imp Pl  P1)  => p_ + "uguem" ;
 VP (Imp Pl  P2) => p_ + "ugueu" ;
 VP (Imp Sg  P2) => p_ + "ugues" ;
 VP (Imp Pl  P3) => p_ + "uguin" ;
 VP (Imp Sg  P3) => p_ + "ugui" ;
 VP (Pass Pl  Fem) => p_ + "ogudes" ;
 VP (Pass Sg  Fem) => p_ + "oguda" ;
 VP (Pass Pl  Masc) => p_ + "oguts" ;
 VP (Pass Sg  Masc) => p_ + "ogut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper pregar_86 : Str -> Verbum = \pregar ->
let preg_ = Predef.tk 2 pregar in
{s = table { 
 VI Infn => preg_ + "ar" ;
 VI Ger => preg_ + "ant" ;
 VI Part =>  preg_ + "at" ;
 VP (Pres Ind Pl  P1) => preg_ + "uem" ;
 VP (Pres Ind Sg  P1) => preg_ + "o" ;
 VP (Pres Ind Pl  P2) => preg_ + "ueu" ;
 VP (Pres Ind Sg  P2) => preg_ + "ues" ;
 VP (Pres Ind Pl  P3) => preg_ + "uen" ;
 VP (Pres Ind Sg  P3) => preg_ + "a" ;
 VP (Pres Sub Pl  P1) => preg_ + "uem" ;
 VP (Pres Sub Sg  P1) => preg_ + "ui" ;
 VP (Pres Sub Pl  P2) => preg_ + "ueu" ;
 VP (Pres Sub Sg  P2) => preg_ + "uis" ;
 VP (Pres Sub Pl  P3) => preg_ + "uin" ;
 VP (Pres Sub Sg  P3) => preg_ + "ui" ;
 VP (Impf Ind Pl  P1) => preg_ + "àvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => preg_ + "ava" ;--# notpresent
 VP (Impf Ind Pl  P2) => preg_ + "àveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => preg_ + "aves" ;--# notpresent
 VP (Impf Ind Pl  P3) => preg_ + "aven" ;--# notpresent
 VP (Impf Ind Sg  P3) => preg_ + "ava" ;--# notpresent
 VP (Impf Sub Pl  P1) => preg_ + "uéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => preg_ + "ués" ;--# notpresent
 VP (Impf Sub Pl  P2) => preg_ + "uéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => preg_ + "uessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => preg_ + "uessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => preg_ + "ués" ;--# notpresent
 VP (Fut Pl  P1)  => preg_ + "arem" ;--# notpresent
 VP (Fut Sg  P1)  => preg_ + "aré" ;--# notpresent
 VP (Fut Pl  P2) => preg_ + "areu" ;--# notpresent
 VP (Fut Sg  P2) => preg_ + "aràs" ;--# notpresent
 VP (Fut Pl  P3) => preg_ + "aran" ;--# notpresent
 VP (Fut Sg  P3) => preg_ + "arà" ;--# notpresent
 VP (Pret Pl  P1)  => preg_ + "uéssim" ;--# notpresent
 VP (Pret Sg  P1)  => preg_ + "ués" ;--# notpresent
 VP (Pret Pl  P2) => preg_ + "uéssiu" ;--# notpresent
 VP (Pret Sg  P2) => preg_ + "uessis" ;--# notpresent
 VP (Pret Pl  P3) => preg_ + "uessin" ;--# notpresent
 VP (Pret Sg  P3) => preg_ + "ués" ;--# notpresent
 VP (Cond Pl  P1)  => preg_ + "aríem" ;--# notpresent
 VP (Cond Sg  P1)  => preg_ + "aria" ;--# notpresent
 VP (Cond Pl  P2) => preg_ + "aríeu" ;--# notpresent
 VP (Cond Sg  P2) => preg_ + "aries" ;--# notpresent
 VP (Cond Pl  P3) => preg_ + "arien" ;--# notpresent
 VP (Cond Sg  P3) => preg_ + "aria" ;--# notpresent
 VP (Imp Pl  P1)  => preg_ + "uem" ;
 VP (Imp Pl  P2) => preg_ + "ueu" ;
 VP (Imp Sg  P2) => preg_ + "a" ;
 VP (Imp Pl  P3) => preg_ + "uin" ;
 VP (Imp Sg  P3) => preg_ + "ui" ;
 VP (Pass Pl  Fem) => preg_ + "ades" ;
 VP (Pass Sg  Fem) => preg_ + "ada" ;
 VP (Pass Pl  Masc) => preg_ + "ats" ;
 VP (Pass Sg  Masc) => preg_ + "at" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper prendre_87 : Str -> Verbum = \prendre ->
let x_ = Predef.tk 7 prendre in
{s = table { 
 VI Infn => x_ + "prendre" ;
 VI Ger => x_ + "prenent" ;
 VI Part =>  x_ + "pres" ;
 VP (Pres Ind Pl  P1) => x_ + "prenem" ;
 VP (Pres Ind Sg  P1) => x_ + "prenc" ;
 VP (Pres Ind Pl  P2) => x_ + "preneu" ;
 VP (Pres Ind Sg  P2) => x_ + "prens" ;
 VP (Pres Ind Pl  P3) => x_ + "prenen" ;
 VP (Pres Ind Sg  P3) => x_ + "pren" ;
 VP (Pres Sub Pl  P1) => x_ + "prenguem" ;
 VP (Pres Sub Sg  P1) => x_ + "prengui" ;
 VP (Pres Sub Pl  P2) => x_ + "prengueu" ;
 VP (Pres Sub Sg  P2) => x_ + "prenguis" ;
 VP (Pres Sub Pl  P3) => x_ + "prenguin" ;
 VP (Pres Sub Sg  P3) => x_ + "prengui" ;
 VP (Impf Ind Pl  P1) => x_ + "preníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "prenia" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "preníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "prenies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "prenien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "prenia" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "prenguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "prengués" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "prenguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "prenguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "prenguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "prengués" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "prendrem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "prendré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "prendreu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "prendràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "prendran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "prendrà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "prenguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "prengués" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "prenguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "prenguessis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "prenguessin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "prengués" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "prendríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "prendria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "prendríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "prendries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "prendrien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "prendria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "prenguem" ;
 VP (Imp Pl  P2) => x_ + "preneu" ;
 VP (Imp Sg  P2) => x_ + "pren" ;
 VP (Imp Pl  P3) => x_ + "prenguin" ;
 VP (Imp Sg  P3) => x_ + "prengui" ;
 VP (Pass Pl  Fem) => x_ + "preses" ;
 VP (Pass Sg  Fem) => x_ + "presa" ;
 VP (Pass Pl  Masc) => x_ + "presos" ;
 VP (Pass Sg  Masc) => x_ + "pres" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper prevenir_88 : Str -> Verbum = \prevenir ->
let prev_ = Predef.tk 4 prevenir in
{s = table { 
 VI Infn => prev_ + "enir" ;
 VI Ger => prev_ + "enint" ;
 VI Part =>  prev_ + "ingut" ;
 VP (Pres Ind Pl  P1) => prev_ + "enim" ;
 VP (Pres Ind Sg  P1) => prev_ + "inc" ;
 VP (Pres Ind Pl  P2) => prev_ + "eniu" ;
 VP (Pres Ind Sg  P2) => prev_ + "ens" ;
 VP (Pres Ind Pl  P3) => prev_ + "enen" ;
 VP (Pres Ind Sg  P3) => prev_ + "é" ;
 VP (Pres Sub Pl  P1) => prev_ + "inguem" ;
 VP (Pres Sub Sg  P1) => prev_ + "ingui" ;
 VP (Pres Sub Pl  P2) => prev_ + "ingueu" ;
 VP (Pres Sub Sg  P2) => prev_ + "inguis" ;
 VP (Pres Sub Pl  P3) => prev_ + "inguin" ;
 VP (Pres Sub Sg  P3) => prev_ + "ingui" ;
 VP (Impf Ind Pl  P1) => prev_ + "eníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => prev_ + "enia" ;--# notpresent
 VP (Impf Ind Pl  P2) => prev_ + "eníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => prev_ + "enies" ;--# notpresent
 VP (Impf Ind Pl  P3) => prev_ + "enien" ;--# notpresent
 VP (Impf Ind Sg  P3) => prev_ + "enia" ;--# notpresent
 VP (Impf Sub Pl  P1) => prev_ + "inguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => prev_ + "ingués" ;--# notpresent
 VP (Impf Sub Pl  P2) => prev_ + "inguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => prev_ + "inguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => prev_ + "inguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => prev_ + "ingués" ;--# notpresent
 VP (Fut Pl  P1)  => prev_ + "indrem" ;--# notpresent
 VP (Fut Sg  P1)  => prev_ + "indré" ;--# notpresent
 VP (Fut Pl  P2) => prev_ + "indreu" ;--# notpresent
 VP (Fut Sg  P2) => prev_ + "indràs" ;--# notpresent
 VP (Fut Pl  P3) => prev_ + "indran" ;--# notpresent
 VP (Fut Sg  P3) => prev_ + "indrà" ;--# notpresent
 VP (Pret Pl  P1)  => prev_ + "inguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => prev_ + "ingués" ;--# notpresent
 VP (Pret Pl  P2) => prev_ + "inguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => prev_ + "inguessis" ;--# notpresent
 VP (Pret Pl  P3) => prev_ + "inguessin" ;--# notpresent
 VP (Pret Sg  P3) => prev_ + "ingués" ;--# notpresent
 VP (Cond Pl  P1)  => prev_ + "indríem" ;--# notpresent
 VP (Cond Sg  P1)  => prev_ + "indria" ;--# notpresent
 VP (Cond Pl  P2) => prev_ + "indríeu" ;--# notpresent
 VP (Cond Sg  P2) => prev_ + "indries" ;--# notpresent
 VP (Cond Pl  P3) => prev_ + "indrien" ;--# notpresent
 VP (Cond Sg  P3) => prev_ + "indria" ;--# notpresent
 VP (Imp Pl  P1)  => prev_ + "inguem" ;
 VP (Imp Pl  P2) => prev_ + "eniu" ;
 VP (Imp Sg  P2) => prev_ + "ine" ;
 VP (Imp Pl  P3) => prev_ + "inguin" ;
 VP (Imp Sg  P3) => prev_ + "ingui" ;
 VP (Pass Pl  Fem) => prev_ + "ingudes" ;
 VP (Pass Sg  Fem) => prev_ + "inguda" ;
 VP (Pass Pl  Masc) => prev_ + "inguts" ;
 VP (Pass Sg  Masc) => prev_ + "ingut" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- pruir-- is not in the used source .
-- pudir-- is not in the used source .

oper raure_91 : Str -> Verbum = \raure ->
let ra_ = Predef.tk 3 raure in
{s = table { 
 VI Infn => ra_ + "ure" ;
 VI Ger => ra_ + "ent" ;
 VI Part =>  ra_ + "s" ;
 VP (Pres Ind Pl  P1) => ra_ + "em" ;
 VP (Pres Ind Sg  P1) => ra_ + "c" ;
 VP (Pres Ind Pl  P2) => ra_ + "eu" ;
 VP (Pres Ind Sg  P2) => ra_ + "us" ;
 VP (Pres Ind Pl  P3) => ra_ + "uen" ;
 VP (Pres Ind Sg  P3) => ra_ + "u" ;
 VP (Pres Sub Pl  P1) => ra_ + "guem" ;
 VP (Pres Sub Sg  P1) => ra_ + "gui" ;
 VP (Pres Sub Pl  P2) => ra_ + "gueu" ;
 VP (Pres Sub Sg  P2) => ra_ + "guis" ;
 VP (Pres Sub Pl  P3) => ra_ + "guin" ;
 VP (Pres Sub Sg  P3) => ra_ + "gui" ;
 VP (Impf Ind Pl  P1) => ra_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => ra_ + "ïa" ;--# notpresent
 VP (Impf Ind Pl  P2) => ra_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => ra_ + "ïes" ;--# notpresent
 VP (Impf Ind Pl  P3) => ra_ + "ïen" ;--# notpresent
 VP (Impf Ind Sg  P3) => ra_ + "ïa" ;--# notpresent
 VP (Impf Sub Pl  P1) => ra_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => ra_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => ra_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => ra_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => ra_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => ra_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => ra_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => ra_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => ra_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => ra_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => ra_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => ra_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => ra_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => ra_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => ra_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => ra_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => ra_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => ra_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => ra_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => ra_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => ra_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => ra_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => ra_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => ra_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => ra_ + "guem" ;
 VP (Imp Pl  P2) => ra_ + "eu" ;
 VP (Imp Sg  P2) => ra_ + "u" ;
 VP (Imp Pl  P3) => ra_ + "guin" ;
 VP (Imp Sg  P3) => ra_ + "gui" ;
 VP (Pass Pl  Fem) => ra_ + "ses" ;
 VP (Pass Sg  Fem) => ra_ + "sa" ;
 VP (Pass Pl  Masc) => ra_ + "sos" ;
 VP (Pass Sg  Masc) => ra_ + "s" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper rebre_92 : Str -> Verbum = \rebre ->
let re_ = Predef.tk 3 rebre in
{s = table { 
 VI Infn => re_ + "bre" ;
 VI Ger => re_ + "bent" ;
 VI Part =>  re_ + "but" ;
 VP (Pres Ind Pl  P1) => re_ + "bem" ;
 VP (Pres Ind Sg  P1) => re_ + "bo" ;
 VP (Pres Ind Pl  P2) => re_ + "beu" ;
 VP (Pres Ind Sg  P2) => re_ + "ps" ;
 VP (Pres Ind Pl  P3) => re_ + "ben" ;
 VP (Pres Ind Sg  P3) => re_ + "p" ;
 VP (Pres Sub Pl  P1) => re_ + "bem" ;
 VP (Pres Sub Sg  P1) => re_ + "bi" ;
 VP (Pres Sub Pl  P2) => re_ + "beu" ;
 VP (Pres Sub Sg  P2) => re_ + "bis" ;
 VP (Pres Sub Pl  P3) => re_ + "bin" ;
 VP (Pres Sub Sg  P3) => re_ + "bi" ;
 VP (Impf Ind Pl  P1) => re_ + "bíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => re_ + "bia" ;--# notpresent
 VP (Impf Ind Pl  P2) => re_ + "bíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => re_ + "bies" ;--# notpresent
 VP (Impf Ind Pl  P3) => re_ + "bien" ;--# notpresent
 VP (Impf Ind Sg  P3) => re_ + "bia" ;--# notpresent
 VP (Impf Sub Pl  P1) => re_ + "béssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => re_ + "bés" ;--# notpresent
 VP (Impf Sub Pl  P2) => re_ + "béssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => re_ + "bessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => re_ + "bessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => re_ + "bés" ;--# notpresent
 VP (Fut Pl  P1)  => re_ + "brem" ;--# notpresent
 VP (Fut Sg  P1)  => re_ + "bré" ;--# notpresent
 VP (Fut Pl  P2) => re_ + "breu" ;--# notpresent
 VP (Fut Sg  P2) => re_ + "bràs" ;--# notpresent
 VP (Fut Pl  P3) => re_ + "bran" ;--# notpresent
 VP (Fut Sg  P3) => re_ + "brà" ;--# notpresent
 VP (Pret Pl  P1)  => re_ + "béssim" ;--# notpresent
 VP (Pret Sg  P1)  => re_ + "bés" ;--# notpresent
 VP (Pret Pl  P2) => re_ + "béssiu" ;--# notpresent
 VP (Pret Sg  P2) => re_ + "bessis" ;--# notpresent
 VP (Pret Pl  P3) => re_ + "bessin" ;--# notpresent
 VP (Pret Sg  P3) => re_ + "bés" ;--# notpresent
 VP (Cond Pl  P1)  => re_ + "bríem" ;--# notpresent
 VP (Cond Sg  P1)  => re_ + "bria" ;--# notpresent
 VP (Cond Pl  P2) => re_ + "bríeu" ;--# notpresent
 VP (Cond Sg  P2) => re_ + "bries" ;--# notpresent
 VP (Cond Pl  P3) => re_ + "brien" ;--# notpresent
 VP (Cond Sg  P3) => re_ + "bria" ;--# notpresent
 VP (Imp Pl  P1)  => re_ + "bem" ;
 VP (Imp Pl  P2) => re_ + "beu" ;
 VP (Imp Sg  P2) => re_ + "p" ;
 VP (Imp Pl  P3) => re_ + "bin" ;
 VP (Imp Sg  P3) => re_ + "bi" ;
 VP (Pass Pl  Fem) => re_ + "budes" ;
 VP (Pass Sg  Fem) => re_ + "buda" ;
 VP (Pass Pl  Masc) => re_ + "buts" ;
 VP (Pass Sg  Masc) => re_ + "but" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper recloure_93 : Str -> Verbum = \recloure ->
let recl_ = Predef.tk 4 recloure in
{s = table { 
 VI Infn => recl_ + "oure" ;
 VI Ger => recl_ + "oent" ;
 VP (Pres Ind Pl  P1) => recl_ + "oem" ;
 VP (Pres Ind Sg  P1) => recl_ + "oc" ;
 VP (Pres Ind Pl  P2) => recl_ + "oeu" ;
 VP (Pres Ind Sg  P2) => recl_ + "ous" ;
 VP (Pres Ind Pl  P3) => recl_ + "ouen" ;
 VP (Pres Ind Sg  P3) => recl_ + "ou" ;
 VP (Pres Sub Pl  P1) => recl_ + "oguem" ;
 VP (Pres Sub Sg  P1) => recl_ + "ogui" ;
 VP (Pres Sub Pl  P2) => recl_ + "ogueu" ;
 VP (Pres Sub Sg  P2) => recl_ + "oguis" ;
 VP (Pres Sub Pl  P3) => recl_ + "oguin" ;
 VP (Pres Sub Sg  P3) => recl_ + "ogui" ;
 VP (Impf Ind Pl  P1) => recl_ + "oíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => recl_ + "oïa" ;--# notpresent
 VP (Impf Ind Pl  P2) => recl_ + "oíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => recl_ + "oïes" ;--# notpresent
 VP (Impf Ind Pl  P3) => recl_ + "oïen" ;--# notpresent
 VP (Impf Ind Sg  P3) => recl_ + "oïa" ;--# notpresent
 VP (Impf Sub Pl  P1) => recl_ + "oguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => recl_ + "ogués" ;--# notpresent
 VP (Impf Sub Pl  P2) => recl_ + "oguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => recl_ + "oguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => recl_ + "oguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => recl_ + "ogués" ;--# notpresent
 VP (Fut Pl  P1)  => recl_ + "ourem" ;--# notpresent
 VP (Fut Sg  P1)  => recl_ + "ouré" ;--# notpresent
 VP (Fut Pl  P2) => recl_ + "oureu" ;--# notpresent
 VP (Fut Sg  P2) => recl_ + "ouràs" ;--# notpresent
 VP (Fut Pl  P3) => recl_ + "ouran" ;--# notpresent
 VP (Fut Sg  P3) => recl_ + "ourà" ;--# notpresent
 VP (Pret Pl  P1)  => recl_ + "oguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => recl_ + "ogués" ;--# notpresent
 VP (Pret Pl  P2) => recl_ + "oguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => recl_ + "oguessis" ;--# notpresent
 VP (Pret Pl  P3) => recl_ + "oguessin" ;--# notpresent
 VP (Pret Sg  P3) => recl_ + "ogués" ;--# notpresent
 VP (Cond Pl  P1)  => recl_ + "ouríem" ;--# notpresent
 VP (Cond Sg  P1)  => recl_ + "ouria" ;--# notpresent
 VP (Cond Pl  P2) => recl_ + "ouríeu" ;--# notpresent
 VP (Cond Sg  P2) => recl_ + "ouries" ;--# notpresent
 VP (Cond Pl  P3) => recl_ + "ourien" ;--# notpresent
 VP (Cond Sg  P3) => recl_ + "ouria" ;--# notpresent
 VP (Imp Pl  P1)  => recl_ + "oguem" ;
 VP (Imp Pl  P2) => recl_ + "oeu" ;
 VP (Imp Sg  P2) => recl_ + "ou" ;
 VP (Imp Pl  P3) => recl_ + "oguin" ;
 VP (Imp Sg  P3) => recl_ + "ogui" ;
 VP (Pass Pl  Fem) => recl_ + "oses" ;
 VP (Pass Sg  Fem) => recl_ + "osa" ;
 VP (Pass Pl  Masc) => recl_ + "osos" ;
 VI Part =>  recl_ + "òs" ;
 VP (Pass Sg  Masc) => recl_ + "òs" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper reduir_94 : Str -> Verbum = \reduir ->
let redu_ = Predef.tk 2 reduir in
{s = table { 
 VI Infn => redu_ + "ir" ;
 VI Ger => redu_ + "int" ;
 VI Part =>  redu_ + "ït" ;
 VP (Pres Ind Pl  P1) => redu_ + "ïm" ;
 VP (Pres Ind Sg  P1) => redu_ + "eixo" ;
 VP (Pres Ind Pl  P2) => redu_ + "ïu" ;
 VP (Pres Ind Sg  P2) => redu_ + "eixes" ;
 VP (Pres Ind Pl  P3) => redu_ + "eixen" ;
 VP (Pres Ind Sg  P3) => redu_ + "eix" ;
 VP (Pres Sub Pl  P1) => redu_ + "ïm" ;
 VP (Pres Sub Sg  P1) => redu_ + "eixi" ;
 VP (Pres Sub Pl  P2) => redu_ + "ïu" ;
 VP (Pres Sub Sg  P2) => redu_ + "eixis" ;
 VP (Pres Sub Pl  P3) => redu_ + "eixin" ;
 VP (Pres Sub Sg  P3) => redu_ + "eixi" ;
 VP (Impf Ind Pl  P1) => redu_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => redu_ + "ïa" ;--# notpresent
 VP (Impf Ind Pl  P2) => redu_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => redu_ + "ïes" ;--# notpresent
 VP (Impf Ind Pl  P3) => redu_ + "ïen" ;--# notpresent
 VP (Impf Ind Sg  P3) => redu_ + "ïa" ;--# notpresent
 VP (Impf Sub Pl  P1) => redu_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => redu_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => redu_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => redu_ + "ïssis" ;--# notpresent
 VP (Impf Sub Pl  P3) => redu_ + "ïssin" ;--# notpresent
 VP (Impf Sub Sg  P3) => redu_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => redu_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => redu_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => redu_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => redu_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => redu_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => redu_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => redu_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => redu_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => redu_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => redu_ + "ïssis" ;--# notpresent
 VP (Pret Pl  P3) => redu_ + "ïssin" ;--# notpresent
 VP (Pret Sg  P3) => redu_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => redu_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => redu_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => redu_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => redu_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => redu_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => redu_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => redu_ + "ïm" ;
 VP (Imp Pl  P2) => redu_ + "ïu" ;
 VP (Imp Sg  P2) => redu_ + "eix" ;
 VP (Imp Pl  P3) => redu_ + "eixin" ;
 VP (Imp Sg  P3) => redu_ + "eixi" ;
 VP (Pass Pl  Fem) => redu_ + "ïdes" ;
 VP (Pass Sg  Fem) => redu_ + "ïda" ;
 VP (Pass Pl  Masc) => redu_ + "ïts" ;
 VP (Pass Sg  Masc) => redu_ + "ït" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- reeixir-- is not in the used source .

oper riure_96 : Str -> Verbum = \riure ->
let r_ = Predef.tk 4 riure in
{s = table { 
 VI Infn => r_ + "iure" ;
 VI Ger => r_ + "ient" ;
 VI Part =>  r_ + "igut" ;
 VP (Pres Ind Pl  P1) => r_ + "iem" ;
 VP (Pres Ind Sg  P1) => r_ + "ic" ;
 VP (Pres Ind Pl  P2) => r_ + "ieu" ;
 VP (Pres Ind Sg  P2) => r_ + "ius" ;
 VP (Pres Ind Pl  P3) => r_ + "iuen" ;
 VP (Pres Ind Sg  P3) => r_ + "iu" ;
 VP (Pres Sub Pl  P1) => r_ + "iguem" ;
 VP (Pres Sub Sg  P1) => r_ + "igui" ;
 VP (Pres Sub Pl  P2) => r_ + "igueu" ;
 VP (Pres Sub Sg  P2) => r_ + "iguis" ;
 VP (Pres Sub Pl  P3) => r_ + "iguin" ;
 VP (Pres Sub Sg  P3) => r_ + "igui" ;
 VP (Impf Ind Pl  P1) => r_ + "èiem" ;--# notpresent
 VP (Impf Ind Sg  P1) => r_ + "eia" ;--# notpresent
 VP (Impf Ind Pl  P2) => r_ + "èieu" ;--# notpresent
 VP (Impf Ind Sg  P2) => r_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => r_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => r_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => r_ + "iguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => r_ + "igués" ;--# notpresent
 VP (Impf Sub Pl  P2) => r_ + "iguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => r_ + "iguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => r_ + "iguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => r_ + "igués" ;--# notpresent
 VP (Fut Pl  P1)  => r_ + "iurem" ;--# notpresent
 VP (Fut Sg  P1)  => r_ + "iuré" ;--# notpresent
 VP (Fut Pl  P2) => r_ + "iureu" ;--# notpresent
 VP (Fut Sg  P2) => r_ + "iuràs" ;--# notpresent
 VP (Fut Pl  P3) => r_ + "iuran" ;--# notpresent
 VP (Fut Sg  P3) => r_ + "iurà" ;--# notpresent
 VP (Pret Pl  P1)  => r_ + "iguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => r_ + "igués" ;--# notpresent
 VP (Pret Pl  P2) => r_ + "iguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => r_ + "iguessis" ;--# notpresent
 VP (Pret Pl  P3) => r_ + "iguessin" ;--# notpresent
 VP (Pret Sg  P3) => r_ + "igués" ;--# notpresent
 VP (Cond Pl  P1)  => r_ + "iuríem" ;--# notpresent
 VP (Cond Sg  P1)  => r_ + "iuria" ;--# notpresent
 VP (Cond Pl  P2) => r_ + "iuríeu" ;--# notpresent
 VP (Cond Sg  P2) => r_ + "iuries" ;--# notpresent
 VP (Cond Pl  P3) => r_ + "iurien" ;--# notpresent
 VP (Cond Sg  P3) => r_ + "iuria" ;--# notpresent
 VP (Imp Pl  P1)  => r_ + "iguem" ;
 VP (Imp Pl  P2) => r_ + "ieu" ;
 VP (Imp Sg  P2) => r_ + "iu" ;
 VP (Imp Pl  P3) => r_ + "iguin" ;
 VP (Imp Sg  P3) => r_ + "igui" ;
 VP (Pass Pl  Fem) => r_ + "igudes" ;
 VP (Pass Sg  Fem) => r_ + "iguda" ;
 VP (Pass Pl  Masc) => r_ + "iguts" ;
 VP (Pass Sg  Masc) => r_ + "igut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper romandre_97 : Str -> Verbum = \romandre ->
let rom_ = Predef.tk 5 romandre in
{s = table { 
 VI Infn => rom_ + "andre" ;
 VI Ger => rom_ + "anent" ;
 VP (Pres Ind Pl  P1) => rom_ + "anem" ;
 VP (Pres Ind Sg  P1) => rom_ + "anc" ;
 VP (Pres Ind Pl  P2) => rom_ + "aneu" ;
 VP (Pres Ind Sg  P2) => rom_ + "ans" ;
 VP (Pres Ind Pl  P3) => rom_ + "anen" ;
 VP (Pres Ind Sg  P3) => rom_ + "an" ;
 VP (Pres Sub Pl  P1) => rom_ + "anguem" ;
 VP (Pres Sub Sg  P1) => rom_ + "angui" ;
 VP (Pres Sub Pl  P2) => rom_ + "angueu" ;
 VP (Pres Sub Sg  P2) => rom_ + "anguis" ;
 VP (Pres Sub Pl  P3) => rom_ + "anguin" ;
 VP (Pres Sub Sg  P3) => rom_ + "angui" ;
 VP (Impf Ind Pl  P1) => rom_ + "aníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => rom_ + "ania" ;--# notpresent
 VP (Impf Ind Pl  P2) => rom_ + "aníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => rom_ + "anies" ;--# notpresent
 VP (Impf Ind Pl  P3) => rom_ + "anien" ;--# notpresent
 VP (Impf Ind Sg  P3) => rom_ + "ania" ;--# notpresent
 VP (Impf Sub Pl  P1) => rom_ + "anguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => rom_ + "angués" ;--# notpresent
 VP (Impf Sub Pl  P2) => rom_ + "anguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => rom_ + "anguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => rom_ + "anguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => rom_ + "angués" ;--# notpresent
 VP (Fut Pl  P1)  => rom_ + "andrem" ;--# notpresent
 VP (Fut Sg  P1)  => rom_ + "andré" ;--# notpresent
 VP (Fut Pl  P2) => rom_ + "andreu" ;--# notpresent
 VP (Fut Sg  P2) => rom_ + "andràs" ;--# notpresent
 VP (Fut Pl  P3) => rom_ + "andran" ;--# notpresent
 VP (Fut Sg  P3) => rom_ + "andrà" ;--# notpresent
 VP (Pret Pl  P1)  => rom_ + "anguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => rom_ + "angués" ;--# notpresent
 VP (Pret Pl  P2) => rom_ + "anguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => rom_ + "anguessis" ;--# notpresent
 VP (Pret Pl  P3) => rom_ + "anguessin" ;--# notpresent
 VP (Pret Sg  P3) => rom_ + "angués" ;--# notpresent
 VP (Cond Pl  P1)  => rom_ + "andríem" ;--# notpresent
 VP (Cond Sg  P1)  => rom_ + "andria" ;--# notpresent
 VP (Cond Pl  P2) => rom_ + "andríeu" ;--# notpresent
 VP (Cond Sg  P2) => rom_ + "andries" ;--# notpresent
 VP (Cond Pl  P3) => rom_ + "andrien" ;--# notpresent
 VP (Cond Sg  P3) => rom_ + "andria" ;--# notpresent
 VP (Imp Pl  P1)  => rom_ + "anguem" ;
 VP (Imp Pl  P2) => rom_ + "aneu" ;
 VP (Imp Sg  P2) => rom_ + "an" ;
 VP (Imp Pl  P3) => rom_ + "anguin" ;
 VP (Imp Sg  P3) => rom_ + "angui" ;
 VP (Pass Pl  Fem) => rom_ + "ases" ;
 VP (Pass Sg  Fem) => rom_ + "asa" ;
 VP (Pass Pl  Masc) => rom_ + "asos" ;
 VI Part =>  rom_ + "às" ;
 VP (Pass Sg  Masc) => rom_ + "às" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- rompre-- is not in the used source .

oper saber_99 : Str -> Verbum = \saber ->
let x_ = Predef.tk 5 saber in
{s = table { 
 VI Infn => x_ + "saber" ;
 VI Ger => x_ + "sabent" ;
 VI Part =>  x_ + "sabut" ;
 VP (Pres Ind Pl  P1) => x_ + "sabem" ;
 VP (Pres Ind Sg  P1) => x_ + "sé" ;
 VP (Pres Ind Pl  P2) => x_ + "sabeu" ;
 VP (Pres Ind Sg  P2) => x_ + "saps" ;
 VP (Pres Ind Pl  P3) => x_ + "saben" ;
 VP (Pres Ind Sg  P3) => x_ + "sap" ;
 VP (Pres Sub Pl  P1) => x_ + "sapiguem" ;
 VP (Pres Sub Sg  P1) => x_ + "sàpiga" ;
 VP (Pres Sub Pl  P2) => x_ + "sapigueu" ;
 VP (Pres Sub Sg  P2) => x_ + "sàpigues" ;
 VP (Pres Sub Pl  P3) => x_ + "sàpiguen" ;
 VP (Pres Sub Sg  P3) => x_ + "sàpiga" ;
 VP (Impf Ind Pl  P1) => x_ + "sabíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "sabia" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "sabíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "sabies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "sabien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "sabia" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "sabéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "sabés" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "sabéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "sabessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "sabessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "sabés" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "sabrem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "sabré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "sabreu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "sabràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "sabran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "sabrà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "sabéssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "sabés" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "sabéssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "sabessis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "sabessin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "sabés" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "sabríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "sabria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "sabríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "sabries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "sabrien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "sabria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "sapiguem" ;
 VP (Imp Pl  P2) => x_ + "sapigueu" ;
 VP (Imp Sg  P2) => x_ + "sàpigues" ;
 VP (Imp Pl  P3) => x_ + "sàpiguen" ;
 VP (Imp Sg  P3) => x_ + "sàpiga" ;
 VP (Pass Pl  Fem) => x_ + "sabudes" ;
 VP (Pass Sg  Fem) => x_ + "sabuda" ;
 VP (Pass Pl  Masc) => x_ + "sabuts" ;
 VP (Pass Sg  Masc) => x_ + "sabut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper sentir_100 : Str -> Verbum = \sentir ->
let sent_ = Predef.tk 2 sentir in
{s = table { 
 VI Infn => sent_ + "ir" ;
 VI Ger => sent_ + "int" ;
 VI Part =>  sent_ + "it" ;
 VP (Pres Ind Pl  P1) => sent_ + "im" ;
 VP (Pres Ind Sg  P1) => sent_ + "o" ;
 VP (Pres Ind Pl  P2) => sent_ + "iu" ;
 VP (Pres Ind Sg  P2) => sent_ + "s" ;
 VP (Pres Ind Pl  P3) => sent_ + "en" ;
 VP (Pres Ind Sg  P3) => sent_ + "" ;
 VP (Pres Sub Pl  P1) => sent_ + "im" ;
 VP (Pres Sub Sg  P1) => sent_ + "i" ;
 VP (Pres Sub Pl  P2) => sent_ + "iu" ;
 VP (Pres Sub Sg  P2) => sent_ + "is" ;
 VP (Pres Sub Pl  P3) => sent_ + "in" ;
 VP (Pres Sub Sg  P3) => sent_ + "i" ;
 VP (Impf Ind Pl  P1) => sent_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => sent_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => sent_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => sent_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => sent_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => sent_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => sent_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => sent_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => sent_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => sent_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => sent_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => sent_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => sent_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => sent_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => sent_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => sent_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => sent_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => sent_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => sent_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => sent_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => sent_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => sent_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => sent_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => sent_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => sent_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => sent_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => sent_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => sent_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => sent_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => sent_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => sent_ + "im" ;
 VP (Imp Pl  P2) => sent_ + "iu" ;
 VP (Imp Sg  P2) => sent_ + "" ;
 VP (Imp Pl  P3) => sent_ + "in" ;
 VP (Imp Sg  P3) => sent_ + "i" ;
 VP (Pass Pl  Fem) => sent_ + "ides" ;
 VP (Pass Sg  Fem) => sent_ + "ida" ;
 VP (Pass Pl  Masc) => sent_ + "its" ;
 VP (Pass Sg  Masc) => sent_ + "it" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper servir_101 : Str -> Verbum = \servir ->
let serv_ = Predef.tk 2 servir in
{s = table { 
 VI Infn => serv_ + "ir" ;
 VI Ger => serv_ + "int" ;
 VI Part =>  serv_ + "it" ;
 VP (Pres Ind Pl  P1) => serv_ + "im" ;
 VP (Pres Ind Sg  P1) => serv_ + "eixo" ;
 VP (Pres Ind Pl  P2) => serv_ + "iu" ;
 VP (Pres Ind Sg  P2) => serv_ + "eixes" ;
 VP (Pres Ind Pl  P3) => serv_ + "eixen" ;
 VP (Pres Ind Sg  P3) => serv_ + "eix" ;
 VP (Pres Sub Pl  P1) => serv_ + "im" ;
 VP (Pres Sub Sg  P1) => serv_ + "eixi" ;
 VP (Pres Sub Pl  P2) => serv_ + "iu" ;
 VP (Pres Sub Sg  P2) => serv_ + "eixis" ;
 VP (Pres Sub Pl  P3) => serv_ + "eixin" ;
 VP (Pres Sub Sg  P3) => serv_ + "eixi" ;
 VP (Impf Ind Pl  P1) => serv_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => serv_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => serv_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => serv_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => serv_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => serv_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => serv_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => serv_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => serv_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => serv_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => serv_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => serv_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => serv_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => serv_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => serv_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => serv_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => serv_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => serv_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => serv_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => serv_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => serv_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => serv_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => serv_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => serv_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => serv_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => serv_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => serv_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => serv_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => serv_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => serv_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => serv_ + "im" ;
 VP (Imp Pl  P2) => serv_ + "iu" ;
 VP (Imp Sg  P2) => serv_ + "eix" ;
 VP (Imp Pl  P3) => serv_ + "eixin" ;
 VP (Imp Sg  P3) => serv_ + "eixi" ;
 VP (Pass Pl  Fem) => serv_ + "ides" ;
 VP (Pass Sg  Fem) => serv_ + "ida" ;
 VP (Pass Pl  Masc) => serv_ + "its" ;
 VP (Pass Sg  Masc) => serv_ + "it" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper seure_102 : Str -> Verbum = \seure ->
let s_ = Predef.tk 4 seure in
{s = table { 
 VI Infn => s_ + "eure" ;
 VI Ger => s_ + "eient" ;
 VI Part =>  s_ + "egut" ;
 VP (Pres Ind Pl  P1) => s_ + "eiem" ;
 VP (Pres Ind Sg  P1) => s_ + "ec" ;
 VP (Pres Ind Pl  P2) => s_ + "eieu" ;
 VP (Pres Ind Sg  P2) => s_ + "eus" ;
 VP (Pres Ind Pl  P3) => s_ + "euen" ;
 VP (Pres Ind Sg  P3) => s_ + "eu" ;
 VP (Pres Sub Pl  P1) => s_ + "eguem" ;
 VP (Pres Sub Sg  P1) => s_ + "ega" ;
-- VP (Pres Sub Sg  P1) => s_ + "egui" ;
 VP (Pres Sub Pl  P2) => s_ + "egueu" ;
 VP (Pres Sub Sg  P2) => s_ + "egues" ;
-- VP (Pres Sub Sg  P2) => s_ + "eguis" ;
 VP (Pres Sub Pl  P3) => s_ + "eguen" ;
-- VP (Pres Sub Pl  P3) => s_ + "eguin" ;
 VP (Pres Sub Sg  P3) => s_ + "ega" ;
-- VP (Pres Sub Sg  P3) => s_ + "egui" ;  -- AR: why duplicated forms?
 VP (Impf Ind Sg  P1) => s_ + "eia" ;--# notpresent
 VP (Impf Ind Sg  P2) => s_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => s_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => s_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => s_ + "eguérem" ;--# notpresent
-- VP (Impf Sub Pl  P1) => s_ + "eguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => s_ + "eguera" ;--# notpresent
-- VP (Impf Sub Sg  P1) => s_ + "egués" ;--# notpresent
 VP (Impf Sub Pl  P2) => s_ + "eguéreu" ;--# notpresent
-- VP (Impf Sub Pl  P2) => s_ + "eguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => s_ + "egueres" ;--# notpresent
-- VP (Impf Sub Sg  P2) => s_ + "eguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => s_ + "egueren" ;--# notpresent
-- VP (Impf Sub Pl  P3) => s_ + "eguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => s_ + "eguera" ;--# notpresent
-- VP (Impf Sub Sg  P3) => s_ + "egués" ;--# notpresent
 VP (Pret Pl  P1)  => s_ + "eguérem" ;--# notpresent
 VP (Pret Sg  P1)  => s_ + "eguí" ;--# notpresent
 VP (Pret Pl  P2) => s_ + "eguéreu" ;--# notpresent
 VP (Pret Sg  P2) => s_ + "egueres" ;--# notpresent
 VP (Pret Pl  P3) => s_ + "egueren" ;--# notpresent
 VP (Pret Sg  P3) => s_ + "egué" ;--# notpresent
 VP (Fut Pl  P1)  => s_ + "eurem" ;--# notpresent
 VP (Fut Sg  P1)  => s_ + "euré" ;--# notpresent
 VP (Fut Pl  P2) => s_ + "eureu" ;--# notpresent
 VP (Fut Sg  P2) => s_ + "euràs" ;--# notpresent
 VP (Fut Pl  P3) => s_ + "euran" ;--# notpresent
 VP (Fut Sg  P3) => s_ + "eurà" ;--# notpresent
 VP (Cond Pl  P1)  => s_ + "euríem" ;--# notpresent
 VP (Cond Sg  P1)  => s_ + "euria" ;--# notpresent
 VP (Cond Pl  P2) => s_ + "euríeu" ;--# notpresent
 VP (Cond Sg  P2) => s_ + "euries" ;--# notpresent
 VP (Cond Pl  P3) => s_ + "eurien" ;--# notpresent
 VP (Cond Sg  P3) => s_ + "euria" ;--# notpresent
 VP (Imp Pl  P1)  => s_ + "eguem" ;
 VP (Imp Pl  P2) => s_ + "eieu" ;
 VP (Imp Sg  P2) => s_ + "eu" ;
 VP (Imp Pl  P3) => s_ + "eguen" ;
-- VP (Imp Pl  P3) => s_ + "eguin" ;
 VP (Imp Sg  P3) => s_ + "ega" ;
-- VP (Imp Sg  P3) => s_ + "egui" ;
 VP (Pass Pl  Fem) => s_ + "egudes" ;
 VP (Pass Sg  Fem) => s_ + "eguda" ;
 VP (Pass Pl  Masc) => s_ + "eguts" ;
 VP (Pass Sg  Masc) => s_ + "egut" ;
 VP (Impf Ind Pl  P1)  => s_ + "èiem" ;--# notpresent
 VP (Impf Ind Pl  P2) => s_ + "èieu" ;--# notpresent
-- VP (Impf Ind Pl  P1)  => s_ + "éiem" ;--# notpresent
-- VP (Impf Ind Pl  P2) => s_ + "éieu" ;--# notpresent
VP (Imp Sg P1) => variants {} 
}
} ;

oper sofrir_103 : Str -> Verbum = \sofrir ->
let sof_ = Predef.tk 3 sofrir in
{s = table { 
 VI Infn => sof_ + "rir" ;
 VI Ger => sof_ + "rint" ;
 VI Part =>  sof_ + "ert" ;
 VP (Pres Ind Pl  P1) => sof_ + "rim" ;
 VP (Pres Ind Sg  P1) => sof_ + "reixo" ;
 VP (Pres Ind Pl  P2) => sof_ + "riu" ;
 VP (Pres Ind Sg  P2) => sof_ + "reixes" ;
 VP (Pres Ind Pl  P3) => sof_ + "reixen" ;
 VP (Pres Ind Sg  P3) => sof_ + "reix" ;
 VP (Pres Sub Pl  P1) => sof_ + "rim" ;
 VP (Pres Sub Sg  P1) => sof_ + "reixi" ;
 VP (Pres Sub Pl  P2) => sof_ + "riu" ;
 VP (Pres Sub Sg  P2) => sof_ + "reixis" ;
 VP (Pres Sub Pl  P3) => sof_ + "reixin" ;
 VP (Pres Sub Sg  P3) => sof_ + "reixi" ;
 VP (Impf Ind Pl  P1) => sof_ + "ríem" ;--# notpresent
 VP (Impf Ind Sg  P1) => sof_ + "ria" ;--# notpresent
 VP (Impf Ind Pl  P2) => sof_ + "ríeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => sof_ + "ries" ;--# notpresent
 VP (Impf Ind Pl  P3) => sof_ + "rien" ;--# notpresent
 VP (Impf Ind Sg  P3) => sof_ + "ria" ;--# notpresent
 VP (Impf Sub Pl  P1) => sof_ + "ríssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => sof_ + "rís" ;--# notpresent
 VP (Impf Sub Pl  P2) => sof_ + "ríssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => sof_ + "rissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => sof_ + "rissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => sof_ + "rís" ;--# notpresent
 VP (Fut Pl  P1)  => sof_ + "rirem" ;--# notpresent
 VP (Fut Sg  P1)  => sof_ + "riré" ;--# notpresent
 VP (Fut Pl  P2) => sof_ + "rireu" ;--# notpresent
 VP (Fut Sg  P2) => sof_ + "riràs" ;--# notpresent
 VP (Fut Pl  P3) => sof_ + "riran" ;--# notpresent
 VP (Fut Sg  P3) => sof_ + "rirà" ;--# notpresent
 VP (Pret Pl  P1)  => sof_ + "ríssim" ;--# notpresent
 VP (Pret Sg  P1)  => sof_ + "rís" ;--# notpresent
 VP (Pret Pl  P2) => sof_ + "ríssiu" ;--# notpresent
 VP (Pret Sg  P2) => sof_ + "rissis" ;--# notpresent
 VP (Pret Pl  P3) => sof_ + "rissin" ;--# notpresent
 VP (Pret Sg  P3) => sof_ + "rís" ;--# notpresent
 VP (Cond Pl  P1)  => sof_ + "riríem" ;--# notpresent
 VP (Cond Sg  P1)  => sof_ + "riria" ;--# notpresent
 VP (Cond Pl  P2) => sof_ + "riríeu" ;--# notpresent
 VP (Cond Sg  P2) => sof_ + "riries" ;--# notpresent
 VP (Cond Pl  P3) => sof_ + "ririen" ;--# notpresent
 VP (Cond Sg  P3) => sof_ + "riria" ;--# notpresent
 VP (Imp Pl  P1)  => sof_ + "rim" ;
 VP (Imp Pl  P2) => sof_ + "riu" ;
 VP (Imp Sg  P2) => sof_ + "reix" ;
 VP (Imp Pl  P3) => sof_ + "reixin" ;
 VP (Imp Sg  P3) => sof_ + "reixi" ;
 VP (Pass Pl  Fem) => sof_ + "ertes" ;
 VP (Pass Sg  Fem) => sof_ + "erta" ;
 VP (Pass Pl  Masc) => sof_ + "erts" ;
 VP (Pass Sg  Masc) => sof_ + "ert" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- soler-- is not in the used source .

oper sortir_105 : Str -> Verbum = \sortir ->
let s_ = Predef.tk 5 sortir in
{s = table { 
 VI Infn => s_ + "ortir" ;
 VI Ger => s_ + "ortint" ;
 VI Part =>  s_ + "ortit" ;
 VP (Pres Ind Pl  P1) => s_ + "ortim" ;
 VP (Pres Ind Sg  P1) => s_ + "urto" ;
 VP (Pres Ind Pl  P2) => s_ + "ortiu" ;
 VP (Pres Ind Sg  P2) => s_ + "urts" ;
 VP (Pres Ind Pl  P3) => s_ + "urten" ;
 VP (Pres Ind Sg  P3) => s_ + "urt" ;
 VP (Pres Sub Pl  P1) => s_ + "ortim" ;
 VP (Pres Sub Sg  P1) => s_ + "urti" ;
 VP (Pres Sub Pl  P2) => s_ + "ortiu" ;
 VP (Pres Sub Sg  P2) => s_ + "urtis" ;
 VP (Pres Sub Pl  P3) => s_ + "urtin" ;
 VP (Pres Sub Sg  P3) => s_ + "urti" ;
 VP (Impf Ind Pl  P1) => s_ + "ortíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => s_ + "ortia" ;--# notpresent
 VP (Impf Ind Pl  P2) => s_ + "ortíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => s_ + "orties" ;--# notpresent
 VP (Impf Ind Pl  P3) => s_ + "ortien" ;--# notpresent
 VP (Impf Ind Sg  P3) => s_ + "ortia" ;--# notpresent
 VP (Impf Sub Pl  P1) => s_ + "ortíssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => s_ + "ortís" ;--# notpresent
 VP (Impf Sub Pl  P2) => s_ + "ortíssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => s_ + "ortissis" ;--# notpresent
 VP (Impf Sub Pl  P3) => s_ + "ortissin" ;--# notpresent
 VP (Impf Sub Sg  P3) => s_ + "ortís" ;--# notpresent
 VP (Fut Pl  P1)  => s_ + "ortirem" ;--# notpresent
 VP (Fut Sg  P1)  => s_ + "ortiré" ;--# notpresent
 VP (Fut Pl  P2) => s_ + "ortireu" ;--# notpresent
 VP (Fut Sg  P2) => s_ + "ortiràs" ;--# notpresent
 VP (Fut Pl  P3) => s_ + "ortiran" ;--# notpresent
 VP (Fut Sg  P3) => s_ + "ortirà" ;--# notpresent
 VP (Pret Pl  P1)  => s_ + "ortíssim" ;--# notpresent
 VP (Pret Sg  P1)  => s_ + "ortís" ;--# notpresent
 VP (Pret Pl  P2) => s_ + "ortíssiu" ;--# notpresent
 VP (Pret Sg  P2) => s_ + "ortissis" ;--# notpresent
 VP (Pret Pl  P3) => s_ + "ortissin" ;--# notpresent
 VP (Pret Sg  P3) => s_ + "ortís" ;--# notpresent
 VP (Cond Pl  P1)  => s_ + "ortiríem" ;--# notpresent
 VP (Cond Sg  P1)  => s_ + "ortiria" ;--# notpresent
 VP (Cond Pl  P2) => s_ + "ortiríeu" ;--# notpresent
 VP (Cond Sg  P2) => s_ + "ortiries" ;--# notpresent
 VP (Cond Pl  P3) => s_ + "ortirien" ;--# notpresent
 VP (Cond Sg  P3) => s_ + "ortiria" ;--# notpresent
 VP (Imp Pl  P1)  => s_ + "ortim" ;
 VP (Imp Pl  P2) => s_ + "ortiu" ;
 VP (Imp Sg  P2) => s_ + "urt" ;
 VP (Imp Pl  P3) => s_ + "urtin" ;
 VP (Imp Sg  P3) => s_ + "urti" ;
 VP (Pass Pl  Fem) => s_ + "ortides" ;
 VP (Pass Sg  Fem) => s_ + "ortida" ;
 VP (Pass Pl  Masc) => s_ + "ortits" ;
 VP (Pass Sg  Masc) => s_ + "ortit" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper suplir_106 : Str -> Verbum = \suplir ->
let supl_ = Predef.tk 2 suplir in
{s = table { 
 VI Infn => supl_ + "ir" ;
 VI Ger => supl_ + "int" ;
 VI Part =>  supl_ + "ert" ;
 VP (Pres Ind Pl  P1) => supl_ + "im" ;
 VP (Pres Ind Sg  P1) => supl_ + "eixo" ;
 VP (Pres Ind Pl  P2) => supl_ + "iu" ;
 VP (Pres Ind Sg  P2) => supl_ + "eixes" ;
 VP (Pres Ind Pl  P3) => supl_ + "eixen" ;
 VP (Pres Ind Sg  P3) => supl_ + "eix" ;
 VP (Pres Sub Pl  P1) => supl_ + "im" ;
 VP (Pres Sub Sg  P1) => supl_ + "eixi" ;
 VP (Pres Sub Pl  P2) => supl_ + "iu" ;
 VP (Pres Sub Sg  P2) => supl_ + "eixis" ;
 VP (Pres Sub Pl  P3) => supl_ + "eixin" ;
 VP (Pres Sub Sg  P3) => supl_ + "eixi" ;
 VP (Impf Ind Pl  P1) => supl_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => supl_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => supl_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => supl_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => supl_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => supl_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => supl_ + "íssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => supl_ + "ís" ;--# notpresent
 VP (Impf Sub Pl  P2) => supl_ + "íssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => supl_ + "issis" ;--# notpresent
 VP (Impf Sub Pl  P3) => supl_ + "issin" ;--# notpresent
 VP (Impf Sub Sg  P3) => supl_ + "ís" ;--# notpresent
 VP (Fut Pl  P1)  => supl_ + "irem" ;--# notpresent
 VP (Fut Sg  P1)  => supl_ + "iré" ;--# notpresent
 VP (Fut Pl  P2) => supl_ + "ireu" ;--# notpresent
 VP (Fut Sg  P2) => supl_ + "iràs" ;--# notpresent
 VP (Fut Pl  P3) => supl_ + "iran" ;--# notpresent
 VP (Fut Sg  P3) => supl_ + "irà" ;--# notpresent
 VP (Pret Pl  P1)  => supl_ + "íssim" ;--# notpresent
 VP (Pret Sg  P1)  => supl_ + "ís" ;--# notpresent
 VP (Pret Pl  P2) => supl_ + "íssiu" ;--# notpresent
 VP (Pret Sg  P2) => supl_ + "issis" ;--# notpresent
 VP (Pret Pl  P3) => supl_ + "issin" ;--# notpresent
 VP (Pret Sg  P3) => supl_ + "ís" ;--# notpresent
 VP (Cond Pl  P1)  => supl_ + "iríem" ;--# notpresent
 VP (Cond Sg  P1)  => supl_ + "iria" ;--# notpresent
 VP (Cond Pl  P2) => supl_ + "iríeu" ;--# notpresent
 VP (Cond Sg  P2) => supl_ + "iries" ;--# notpresent
 VP (Cond Pl  P3) => supl_ + "irien" ;--# notpresent
 VP (Cond Sg  P3) => supl_ + "iria" ;--# notpresent
 VP (Imp Pl  P1)  => supl_ + "im" ;
 VP (Imp Pl  P2) => supl_ + "iu" ;
 VP (Imp Sg  P2) => supl_ + "eix" ;
 VP (Imp Pl  P3) => supl_ + "eixin" ;
 VP (Imp Sg  P3) => supl_ + "eixi" ;
 VP (Pass Pl  Fem) => supl_ + "ertes" ;
 VP (Pass Sg  Fem) => supl_ + "erta" ;
 VP (Pass Pl  Masc) => supl_ + "erts" ;
 VP (Pass Sg  Masc) => supl_ + "ert" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper témer_107 : Str -> Verbum = \témer ->
let t_ = Predef.tk 4 témer in
{s = table { 
 VI Ger => t_ + "ement" ;
 VI Part =>  t_ + "emut" ;
 VP (Pres Ind Pl  P1) => t_ + "emem" ;
 VP (Pres Ind Sg  P1) => t_ + "emo" ;
 VP (Pres Ind Pl  P2) => t_ + "emeu" ;
 VP (Pres Ind Sg  P2) => t_ + "ems" ;
 VP (Pres Ind Pl  P3) => t_ + "emen" ;
 VP (Pres Ind Sg  P3) => t_ + "em" ;
 VP (Pres Sub Pl  P1) => t_ + "emem" ;
 VP (Pres Sub Sg  P1) => t_ + "emi" ;
 VP (Pres Sub Pl  P2) => t_ + "emeu" ;
 VP (Pres Sub Sg  P2) => t_ + "emis" ;
 VP (Pres Sub Pl  P3) => t_ + "emin" ;
 VP (Pres Sub Sg  P3) => t_ + "emi" ;
 VP (Impf Ind Pl  P1) => t_ + "emíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => t_ + "emia" ;--# notpresent
 VP (Impf Ind Pl  P2) => t_ + "emíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => t_ + "emies" ;--# notpresent
 VP (Impf Ind Pl  P3) => t_ + "emien" ;--# notpresent
 VP (Impf Ind Sg  P3) => t_ + "emia" ;--# notpresent
 VP (Impf Sub Pl  P1) => t_ + "eméssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => t_ + "emés" ;--# notpresent
 VP (Impf Sub Pl  P2) => t_ + "eméssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => t_ + "emessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => t_ + "emessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => t_ + "emés" ;--# notpresent
 VP (Fut Pl  P1)  => t_ + "emerem" ;--# notpresent
 VP (Fut Sg  P1)  => t_ + "emeré" ;--# notpresent
 VP (Fut Pl  P2) => t_ + "emereu" ;--# notpresent
 VP (Fut Sg  P2) => t_ + "emeràs" ;--# notpresent
 VP (Fut Pl  P3) => t_ + "emeran" ;--# notpresent
 VP (Fut Sg  P3) => t_ + "emerà" ;--# notpresent
 VP (Pret Pl  P1)  => t_ + "eméssim" ;--# notpresent
 VP (Pret Sg  P1)  => t_ + "emés" ;--# notpresent
 VP (Pret Pl  P2) => t_ + "eméssiu" ;--# notpresent
 VP (Pret Sg  P2) => t_ + "emessis" ;--# notpresent
 VP (Pret Pl  P3) => t_ + "emessin" ;--# notpresent
 VP (Pret Sg  P3) => t_ + "emés" ;--# notpresent
 VP (Cond Pl  P1)  => t_ + "emeríem" ;--# notpresent
 VP (Cond Sg  P1)  => t_ + "emeria" ;--# notpresent
 VP (Cond Pl  P2) => t_ + "emeríeu" ;--# notpresent
 VP (Cond Sg  P2) => t_ + "emeries" ;--# notpresent
 VP (Cond Pl  P3) => t_ + "emerien" ;--# notpresent
 VP (Cond Sg  P3) => t_ + "emeria" ;--# notpresent
 VP (Imp Pl  P1)  => t_ + "emem" ;
 VP (Imp Pl  P2) => t_ + "emeu" ;
 VP (Imp Sg  P2) => t_ + "em" ;
 VP (Imp Pl  P3) => t_ + "emin" ;
 VP (Imp Sg  P3) => t_ + "emi" ;
 VP (Pass Pl  Fem) => t_ + "emudes" ;
 VP (Pass Sg  Fem) => t_ + "emuda" ;
 VP (Pass Pl  Masc) => t_ + "emuts" ;
 VP (Pass Sg  Masc) => t_ + "emut" ;
 VI Infn => t_ + "émer" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper tenir_108 : Str -> Verbum = \tenir ->
let x_ = Predef.tk 5 tenir in
{s = table { 
 VI Infn => x_ + "tenir" ;
 VI Ger => x_ + "tenint" ;
 VI Part =>  x_ + "tingut" ;
 VP (Pres Ind Pl  P1) => x_ + "tenim" ;
 VP (Pres Ind Sg  P1) => x_ + "tinc" ;
 VP (Pres Ind Pl  P2) => x_ + "teniu" ;
 VP (Pres Ind Sg  P2) => x_ + "tens" ;
 VP (Pres Ind Pl  P3) => x_ + "tenen" ;
 VP (Pres Ind Sg  P3) => x_ + "té" ;
 VP (Pres Sub Pl  P1) => x_ + "tinguem" ;
 VP (Pres Sub Sg  P1) => x_ + "tingui" ;
 VP (Pres Sub Pl  P2) => x_ + "tingueu" ;
 VP (Pres Sub Sg  P2) => x_ + "tinguis" ;
 VP (Pres Sub Pl  P3) => x_ + "tinguin" ;
 VP (Pres Sub Sg  P3) => x_ + "tingui" ;
 VP (Impf Ind Pl  P1) => x_ + "teníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "tenia" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "teníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "tenies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "tenien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "tenia" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "tinguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "tingués" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "tinguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "tinguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "tinguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "tingués" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "tindrem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "tindré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "tindreu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "tindràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "tindran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "tindrà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "tinguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "tingués" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "tinguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "tinguessis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "tinguessin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "tingués" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "tindríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "tindria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "tindríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "tindries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "tindrien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "tindria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "tinguem" ;
 VP (Imp Pl  P2) => x_ + "tingueu" ;
 VP (Imp Sg  P2) => x_ + "tingues" ;
 VP (Imp Pl  P3) => x_ + "tinguin" ;
 VP (Imp Sg  P3) => x_ + "tingui" ;
 VP (Pass Pl  Fem) => x_ + "tingudes" ;
 VP (Pass Sg  Fem) => x_ + "tinguda" ;
 VP (Pass Pl  Masc) => x_ + "tinguts" ;
 VP (Pass Sg  Masc) => x_ + "tingut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper torçar_109 : Str -> Verbum = \torçar ->
let tor_ = Predef.tk 3 torçar in
{s = table { 
 VI Infn => tor_ + "çar" ;
 VI Ger => tor_ + "çant" ;
 VI Part =>  tor_ + "çat" ;
 VP (Pres Ind Pl  P1) => tor_ + "cem" ;
 VP (Pres Ind Sg  P1) => tor_ + "ço" ;
 VP (Pres Ind Pl  P2) => tor_ + "ceu" ;
 VP (Pres Ind Sg  P2) => tor_ + "ces" ;
 VP (Pres Ind Pl  P3) => tor_ + "cen" ;
 VP (Pres Ind Sg  P3) => tor_ + "ça" ;
 VP (Pres Sub Pl  P1) => tor_ + "cem" ;
 VP (Pres Sub Sg  P1) => tor_ + "ci" ;
 VP (Pres Sub Pl  P2) => tor_ + "ceu" ;
 VP (Pres Sub Sg  P2) => tor_ + "cis" ;
 VP (Pres Sub Pl  P3) => tor_ + "cin" ;
 VP (Pres Sub Sg  P3) => tor_ + "ci" ;
 VP (Impf Ind Pl  P1) => tor_ + "çàvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => tor_ + "çava" ;--# notpresent
 VP (Impf Ind Pl  P2) => tor_ + "çàveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => tor_ + "çaves" ;--# notpresent
 VP (Impf Ind Pl  P3) => tor_ + "çaven" ;--# notpresent
 VP (Impf Ind Sg  P3) => tor_ + "çava" ;--# notpresent
 VP (Impf Sub Pl  P1) => tor_ + "céssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => tor_ + "cés" ;--# notpresent
 VP (Impf Sub Pl  P2) => tor_ + "céssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => tor_ + "cessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => tor_ + "cessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => tor_ + "cés" ;--# notpresent
 VP (Fut Pl  P1)  => tor_ + "çarem" ;--# notpresent
 VP (Fut Sg  P1)  => tor_ + "çaré" ;--# notpresent
 VP (Fut Pl  P2) => tor_ + "çareu" ;--# notpresent
 VP (Fut Sg  P2) => tor_ + "çaràs" ;--# notpresent
 VP (Fut Pl  P3) => tor_ + "çaran" ;--# notpresent
 VP (Fut Sg  P3) => tor_ + "çarà" ;--# notpresent
 VP (Pret Pl  P1)  => tor_ + "céssim" ;--# notpresent
 VP (Pret Sg  P1)  => tor_ + "cés" ;--# notpresent
 VP (Pret Pl  P2) => tor_ + "céssiu" ;--# notpresent
 VP (Pret Sg  P2) => tor_ + "cessis" ;--# notpresent
 VP (Pret Pl  P3) => tor_ + "cessin" ;--# notpresent
 VP (Pret Sg  P3) => tor_ + "cés" ;--# notpresent
 VP (Cond Pl  P1)  => tor_ + "çaríem" ;--# notpresent
 VP (Cond Sg  P1)  => tor_ + "çaria" ;--# notpresent
 VP (Cond Pl  P2) => tor_ + "çaríeu" ;--# notpresent
 VP (Cond Sg  P2) => tor_ + "çaries" ;--# notpresent
 VP (Cond Pl  P3) => tor_ + "çarien" ;--# notpresent
 VP (Cond Sg  P3) => tor_ + "çaria" ;--# notpresent
 VP (Imp Pl  P1)  => tor_ + "cem" ;
 VP (Imp Pl  P2) => tor_ + "ceu" ;
 VP (Imp Sg  P2) => tor_ + "ça" ;
 VP (Imp Pl  P3) => tor_ + "cin" ;
 VP (Imp Sg  P3) => tor_ + "ci" ;
 VP (Pass Pl  Fem) => tor_ + "çades" ;
 VP (Pass Sg  Fem) => tor_ + "çada" ;
 VP (Pass Pl  Masc) => tor_ + "çats" ;
 VP (Pass Sg  Masc) => tor_ + "çat" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper tòrcer_110 : Str -> Verbum = \tòrcer ->
let t_ = Predef.tk 5 tòrcer in
{s = table { 
 VI Ger => t_ + "orcent" ;
 VI Part =>  t_ + "ort" ;
-- VI Part =>  t_ + "orçut" ;  -- AR why duplicate?
 VP (Pres Ind Pl  P1) => t_ + "orcem" ;
 VP (Pres Ind Sg  P1) => t_ + "orço" ;
 VP (Pres Ind Pl  P2) => t_ + "orceu" ;
 VP (Pres Ind Sg  P2) => t_ + "orces" ;
 VP (Pres Ind Pl  P3) => t_ + "orcen" ;
 VP (Pres Ind Sg  P3) => t_ + "orç" ;
 VP (Pres Sub Pl  P1) => t_ + "orcem" ;
 VP (Pres Sub Sg  P1) => t_ + "orça" ;
 VP (Pres Sub Pl  P2) => t_ + "orceu" ;
 VP (Pres Sub Sg  P2) => t_ + "orces" ;
 VP (Pres Sub Pl  P3) => t_ + "orcen" ;
 VP (Pres Sub Sg  P3) => t_ + "orça" ;
 VP (Impf Ind Pl  P1) => t_ + "orcíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => t_ + "orcia" ;--# notpresent
 VP (Impf Ind Pl  P2) => t_ + "orcíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => t_ + "orcies" ;--# notpresent
 VP (Impf Ind Pl  P3) => t_ + "orcien" ;--# notpresent
 VP (Impf Ind Sg  P3) => t_ + "orcia" ;--# notpresent
 VP (Impf Sub Pl  P1) => t_ + "orcérem" ;--# notpresent
-- VP (Impf Sub Pl  P1) => t_ + "orcéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => t_ + "orcera" ;--# notpresent
-- VP (Impf Sub Sg  P1) => t_ + "orcés" ;--# notpresent
 VP (Impf Sub Pl  P2) => t_ + "orcéreu" ;--# notpresent
-- VP (Impf Sub Pl  P2) => t_ + "orcéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => t_ + "orceres" ;--# notpresent
-- VP (Impf Sub Sg  P2) => t_ + "orcessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => t_ + "orceren" ;--# notpresent
-- VP (Impf Sub Pl  P3) => t_ + "orcessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => t_ + "orcera" ;--# notpresent
-- VP (Impf Sub Sg  P3) => t_ + "orcés" ;--# notpresent
 VP (Pret Pl  P1)  => t_ + "orcérem" ;--# notpresent
 VP (Pret Sg  P1)  => t_ + "orcí" ;--# notpresent
 VP (Pret Pl  P2) => t_ + "orcéreu" ;--# notpresent
 VP (Pret Sg  P2) => t_ + "orceres" ;--# notpresent
 VP (Pret Pl  P3) => t_ + "orceren" ;--# notpresent
 VP (Pret Sg  P3) => t_ + "orcé" ;--# notpresent
 VP (Fut Pl  P1)  => t_ + "orcerem" ;--# notpresent
 VP (Fut Sg  P1)  => t_ + "orceré" ;--# notpresent
 VP (Fut Pl  P2) => t_ + "orcereu" ;--# notpresent
 VP (Fut Sg  P2) => t_ + "orceràs" ;--# notpresent
 VP (Fut Pl  P3) => t_ + "orceran" ;--# notpresent
 VP (Fut Sg  P3) => t_ + "orcerà" ;--# notpresent
 VP (Cond Pl  P1)  => t_ + "orceríem" ;--# notpresent
 VP (Cond Sg  P1)  => t_ + "orceria" ;--# notpresent
 VP (Cond Pl  P2) => t_ + "orceríeu" ;--# notpresent
 VP (Cond Sg  P2) => t_ + "orceries" ;--# notpresent
 VP (Cond Pl  P3) => t_ + "orcerien" ;--# notpresent
 VP (Cond Sg  P3) => t_ + "orceria" ;--# notpresent
 VP (Imp Pl  P1)  => t_ + "orcem" ;
 VP (Imp Pl  P2) => t_ + "orceu" ;
 VP (Imp Sg  P2) => t_ + "orç" ;
 VP (Imp Pl  P3) => t_ + "orcen" ;
-- VP (Imp Pl  P3) => t_ + "orcin" ;
 VP (Imp Sg  P3) => t_ + "orci" ;
-- VP (Imp Sg  P3) => t_ + "orça" ;
 VP (Pass Pl  Fem) => t_ + "ortes" ;
-- VP (Pass Pl  Fem) => t_ + "orçudes" ;
 VP (Pass Sg  Fem) => t_ + "orta" ;
-- VP (Pass Sg  Fem) => t_ + "orçuda" ;
 VP (Pass Pl  Masc) => t_ + "orts" ;
-- VP (Pass Pl  Masc) => t_ + "orçuts" ;
 VP (Pass Sg  Masc) => t_ + "ort" ;
-- VP (Pass Sg  Masc) => t_ + "orçut" ;
 VI Infn => t_ + "òrcer" ;
VP (Imp Sg P1) => variants {} 
}
} ;
-- tossir-- is not in the used source .

oper trencar_112 : Str -> Verbum = \trencar ->
let tren_ = Predef.tk 3 trencar in
{s = table { 
 VI Infn => tren_ + "car" ;
 VI Ger => tren_ + "cant" ;
 VI Part =>  tren_ + "cat" ;
 VP (Pres Ind Pl  P1) => tren_ + "quem" ;
 VP (Pres Ind Sg  P1) => tren_ + "co" ;
 VP (Pres Ind Pl  P2) => tren_ + "queu" ;
 VP (Pres Ind Sg  P2) => tren_ + "ques" ;
 VP (Pres Ind Pl  P3) => tren_ + "quen" ;
 VP (Pres Ind Sg  P3) => tren_ + "ca" ;
 VP (Pres Sub Pl  P1) => tren_ + "quem" ;
 VP (Pres Sub Sg  P1) => tren_ + "qui" ;
 VP (Pres Sub Pl  P2) => tren_ + "queu" ;
 VP (Pres Sub Sg  P2) => tren_ + "quis" ;
 VP (Pres Sub Pl  P3) => tren_ + "quin" ;
 VP (Pres Sub Sg  P3) => tren_ + "qui" ;
 VP (Impf Ind Pl  P1) => tren_ + "càvem" ;--# notpresent
 VP (Impf Ind Sg  P1) => tren_ + "cava" ;--# notpresent
 VP (Impf Ind Pl  P2) => tren_ + "càveu" ;--# notpresent
 VP (Impf Ind Sg  P2) => tren_ + "caves" ;--# notpresent
 VP (Impf Ind Pl  P3) => tren_ + "caven" ;--# notpresent
 VP (Impf Ind Sg  P3) => tren_ + "cava" ;--# notpresent
 VP (Impf Sub Pl  P1) => tren_ + "quéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => tren_ + "qués" ;--# notpresent
 VP (Impf Sub Pl  P2) => tren_ + "quéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => tren_ + "quessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => tren_ + "quessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => tren_ + "qués" ;--# notpresent
 VP (Fut Pl  P1)  => tren_ + "carem" ;--# notpresent
 VP (Fut Sg  P1)  => tren_ + "caré" ;--# notpresent
 VP (Fut Pl  P2) => tren_ + "careu" ;--# notpresent
 VP (Fut Sg  P2) => tren_ + "caràs" ;--# notpresent
 VP (Fut Pl  P3) => tren_ + "caran" ;--# notpresent
 VP (Fut Sg  P3) => tren_ + "carà" ;--# notpresent
 VP (Pret Pl  P1)  => tren_ + "quéssim" ;--# notpresent
 VP (Pret Sg  P1)  => tren_ + "qués" ;--# notpresent
 VP (Pret Pl  P2) => tren_ + "quéssiu" ;--# notpresent
 VP (Pret Sg  P2) => tren_ + "quessis" ;--# notpresent
 VP (Pret Pl  P3) => tren_ + "quessin" ;--# notpresent
 VP (Pret Sg  P3) => tren_ + "qués" ;--# notpresent
 VP (Cond Pl  P1)  => tren_ + "caríem" ;--# notpresent
 VP (Cond Sg  P1)  => tren_ + "caria" ;--# notpresent
 VP (Cond Pl  P2) => tren_ + "caríeu" ;--# notpresent
 VP (Cond Sg  P2) => tren_ + "caries" ;--# notpresent
 VP (Cond Pl  P3) => tren_ + "carien" ;--# notpresent
 VP (Cond Sg  P3) => tren_ + "caria" ;--# notpresent
 VP (Imp Pl  P1)  => tren_ + "quem" ;
 VP (Imp Pl  P2) => tren_ + "queu" ;
 VP (Imp Sg  P2) => tren_ + "ca" ;
 VP (Imp Pl  P3) => tren_ + "quin" ;
 VP (Imp Sg  P3) => tren_ + "qui" ;
 VP (Pass Pl  Fem) => tren_ + "cades" ;
 VP (Pass Sg  Fem) => tren_ + "cada" ;
 VP (Pass Pl  Masc) => tren_ + "cats" ;
 VP (Pass Sg  Masc) => tren_ + "cat" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper treure_113 : Str -> Verbum = \treure ->
let tr_ = Predef.tk 4 treure in
{s = table { 
 VI Infn => tr_ + "eure" ;
 VI Ger => tr_ + "aient" ;
 VI Part =>  tr_ + "et" ;
 VP (Pres Ind Pl  P1) => tr_ + "aiem" ;
 VP (Pres Ind Sg  P1) => tr_ + "ec" ;
 VP (Pres Ind Pl  P2) => tr_ + "aieu" ;
 VP (Pres Ind Sg  P2) => tr_ + "eus" ;
 VP (Pres Ind Pl  P3) => tr_ + "euen" ;
 VP (Pres Ind Sg  P3) => tr_ + "eu" ;
 VP (Pres Sub Pl  P1) => tr_ + "aguem" ;
 VP (Pres Sub Sg  P1) => tr_ + "egui" ;
 VP (Pres Sub Pl  P2) => tr_ + "agueu" ;
 VP (Pres Sub Sg  P2) => tr_ + "eguis" ;
 VP (Pres Sub Pl  P3) => tr_ + "eguin" ;
 VP (Pres Sub Sg  P3) => tr_ + "egui" ;
 VP (Impf Ind Pl  P1) => tr_ + "èiem" ;--# notpresent
 VP (Impf Ind Sg  P1) => tr_ + "eia" ;--# notpresent
 VP (Impf Ind Pl  P2) => tr_ + "èieu" ;--# notpresent
 VP (Impf Ind Sg  P2) => tr_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => tr_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => tr_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => tr_ + "aguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => tr_ + "agués" ;--# notpresent
 VP (Impf Sub Pl  P2) => tr_ + "aguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => tr_ + "aguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => tr_ + "aguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => tr_ + "agués" ;--# notpresent
 VP (Fut Pl  P1)  => tr_ + "aurem" ;--# notpresent
 VP (Fut Sg  P1)  => tr_ + "auré" ;--# notpresent
 VP (Fut Pl  P2) => tr_ + "aureu" ;--# notpresent
 VP (Fut Sg  P2) => tr_ + "auràs" ;--# notpresent
 VP (Fut Pl  P3) => tr_ + "auran" ;--# notpresent
 VP (Fut Sg  P3) => tr_ + "aurà" ;--# notpresent
 VP (Pret Pl  P1)  => tr_ + "aguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => tr_ + "agués" ;--# notpresent
 VP (Pret Pl  P2) => tr_ + "aguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => tr_ + "aguessis" ;--# notpresent
 VP (Pret Pl  P3) => tr_ + "aguessin" ;--# notpresent
 VP (Pret Sg  P3) => tr_ + "agués" ;--# notpresent
 VP (Cond Pl  P1)  => tr_ + "auríem" ;--# notpresent
 VP (Cond Sg  P1)  => tr_ + "auria" ;--# notpresent
 VP (Cond Pl  P2) => tr_ + "auríeu" ;--# notpresent
 VP (Cond Sg  P2) => tr_ + "auries" ;--# notpresent
 VP (Cond Pl  P3) => tr_ + "aurien" ;--# notpresent
 VP (Cond Sg  P3) => tr_ + "auria" ;--# notpresent
 VP (Imp Pl  P1)  => tr_ + "aguem" ;
 VP (Imp Pl  P2) => tr_ + "aieu" ;
 VP (Imp Sg  P2) => tr_ + "eu" ;
 VP (Imp Pl  P3) => tr_ + "eguin" ;
 VP (Imp Sg  P3) => tr_ + "egui" ;
 VP (Pass Pl  Fem) => tr_ + "etes" ;
 VP (Pass Sg  Fem) => tr_ + "eta" ;
 VP (Pass Pl  Masc) => tr_ + "ets" ;
 VP (Pass Sg  Masc) => tr_ + "et" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper valer_114 : Str -> Verbum = \valer ->
let val_ = Predef.tk 2 valer in
{s = table { 
 VI Infn => val_ + "er" ;
 VI Ger => val_ + "ent" ;
 VI Part =>  val_ + "gut" ;
 VP (Pres Ind Pl  P1) => val_ + "em" ;
 VP (Pres Ind Sg  P1) => val_ + "c" ;
 VP (Pres Ind Pl  P2) => val_ + "eu" ;
 VP (Pres Ind Sg  P2) => val_ + "s" ;
 VP (Pres Ind Pl  P3) => val_ + "en" ;
 VP (Pres Ind Sg  P3) => val_ + "" ;
 VP (Pres Sub Pl  P1) => val_ + "guem" ;
 VP (Pres Sub Sg  P1) => val_ + "gui" ;
 VP (Pres Sub Pl  P2) => val_ + "gueu" ;
 VP (Pres Sub Sg  P2) => val_ + "guis" ;
 VP (Pres Sub Pl  P3) => val_ + "guin" ;
 VP (Pres Sub Sg  P3) => val_ + "gui" ;
 VP (Impf Ind Pl  P1) => val_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => val_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => val_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => val_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => val_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => val_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => val_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => val_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => val_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => val_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => val_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => val_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => val_ + "drem" ;--# notpresent
 VP (Fut Sg  P1)  => val_ + "dré" ;--# notpresent
 VP (Fut Pl  P2) => val_ + "dreu" ;--# notpresent
 VP (Fut Sg  P2) => val_ + "dràs" ;--# notpresent
 VP (Fut Pl  P3) => val_ + "dran" ;--# notpresent
 VP (Fut Sg  P3) => val_ + "drà" ;--# notpresent
 VP (Pret Pl  P1)  => val_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => val_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => val_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => val_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => val_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => val_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => val_ + "dríem" ;--# notpresent
 VP (Cond Sg  P1)  => val_ + "dria" ;--# notpresent
 VP (Cond Pl  P2) => val_ + "dríeu" ;--# notpresent
 VP (Cond Sg  P2) => val_ + "dries" ;--# notpresent
 VP (Cond Pl  P3) => val_ + "drien" ;--# notpresent
 VP (Cond Sg  P3) => val_ + "dria" ;--# notpresent
 VP (Imp Pl  P1)  => val_ + "guem" ;
 VP (Imp Pl  P2) => val_ + "eu" ;
 VP (Imp Sg  P2) => val_ + "" ;
 VP (Imp Pl  P3) => val_ + "guin" ;
 VP (Imp Sg  P3) => val_ + "gui" ;
 VP (Pass Pl  Fem) => val_ + "gudes" ;
 VP (Pass Sg  Fem) => val_ + "guda" ;
 VP (Pass Pl  Masc) => val_ + "guts" ;
 VP (Pass Sg  Masc) => val_ + "gut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper vèncer_115 : Str -> Verbum = \vèncer ->
let v_ = Predef.tk 5 vèncer in
{s = table { 
 VI Ger => v_ + "encent" ;
 VI Part =>  v_ + "ençut" ;
 VP (Pres Ind Pl  P1) => v_ + "encem" ;
 VP (Pres Ind Sg  P1) => v_ + "enço" ;
 VP (Pres Ind Pl  P2) => v_ + "enceu" ;
 VP (Pres Ind Sg  P2) => v_ + "ences" ;
 VP (Pres Ind Pl  P3) => v_ + "encen" ;
 VP (Pres Ind Sg  P3) => v_ + "enç" ;
 VP (Pres Sub Pl  P1) => v_ + "encem" ;
 VP (Pres Sub Sg  P1) => v_ + "enci" ;
 VP (Pres Sub Pl  P2) => v_ + "enceu" ;
 VP (Pres Sub Sg  P2) => v_ + "encis" ;
 VP (Pres Sub Pl  P3) => v_ + "encin" ;
 VP (Pres Sub Sg  P3) => v_ + "enci" ;
 VP (Impf Ind Pl  P1) => v_ + "encíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => v_ + "encia" ;--# notpresent
 VP (Impf Ind Pl  P2) => v_ + "encíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => v_ + "encies" ;--# notpresent
 VP (Impf Ind Pl  P3) => v_ + "encien" ;--# notpresent
 VP (Impf Ind Sg  P3) => v_ + "encia" ;--# notpresent
 VP (Impf Sub Pl  P1) => v_ + "encéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => v_ + "encés" ;--# notpresent
 VP (Impf Sub Pl  P2) => v_ + "encéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => v_ + "encessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => v_ + "encessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => v_ + "encés" ;--# notpresent
 VP (Fut Pl  P1)  => v_ + "encerem" ;--# notpresent
 VP (Fut Sg  P1)  => v_ + "enceré" ;--# notpresent
 VP (Fut Pl  P2) => v_ + "encereu" ;--# notpresent
 VP (Fut Sg  P2) => v_ + "enceràs" ;--# notpresent
 VP (Fut Pl  P3) => v_ + "enceran" ;--# notpresent
 VP (Fut Sg  P3) => v_ + "encerà" ;--# notpresent
 VP (Pret Pl  P1)  => v_ + "encéssim" ;--# notpresent
 VP (Pret Sg  P1)  => v_ + "encés" ;--# notpresent
 VP (Pret Pl  P2) => v_ + "encéssiu" ;--# notpresent
 VP (Pret Sg  P2) => v_ + "encessis" ;--# notpresent
 VP (Pret Pl  P3) => v_ + "encessin" ;--# notpresent
 VP (Pret Sg  P3) => v_ + "encés" ;--# notpresent
 VP (Cond Pl  P1)  => v_ + "enceríem" ;--# notpresent
 VP (Cond Sg  P1)  => v_ + "enceria" ;--# notpresent
 VP (Cond Pl  P2) => v_ + "enceríeu" ;--# notpresent
 VP (Cond Sg  P2) => v_ + "enceries" ;--# notpresent
 VP (Cond Pl  P3) => v_ + "encerien" ;--# notpresent
 VP (Cond Sg  P3) => v_ + "enceria" ;--# notpresent
 VP (Imp Pl  P1)  => v_ + "encem" ;
 VP (Imp Pl  P2) => v_ + "enceu" ;
 VP (Imp Sg  P2) => v_ + "enç" ;
 VP (Imp Pl  P3) => v_ + "encin" ;
 VP (Imp Sg  P3) => v_ + "enci" ;
 VP (Pass Pl  Fem) => v_ + "ençudes" ;
 VP (Pass Sg  Fem) => v_ + "ençuda" ;
 VP (Pass Pl  Masc) => v_ + "ençuts" ;
 VP (Pass Sg  Masc) => v_ + "ençut" ;
 VI Infn => v_ + "èncer" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper vendre_116 : Str -> Verbum = \vendre ->
let ven_ = Predef.tk 3 vendre in
{s = table { 
 VI Infn => ven_ + "dre" ;
 VI Ger => ven_ + "ent" ;
 VI Part =>  ven_ + "ut" ;
 VP (Pres Ind Pl  P1) => ven_ + "em" ;
 VP (Pres Ind Sg  P1) => ven_ + "c" ;
 VP (Pres Ind Pl  P2) => ven_ + "eu" ;
 VP (Pres Ind Sg  P2) => ven_ + "s" ;
 VP (Pres Ind Pl  P3) => ven_ + "en" ;
 VP (Pres Ind Sg  P3) => ven_ + "" ;
 VP (Pres Sub Pl  P1) => ven_ + "guem" ;
 VP (Pres Sub Sg  P1) => ven_ + "gui" ;
 VP (Pres Sub Pl  P2) => ven_ + "gueu" ;
 VP (Pres Sub Sg  P2) => ven_ + "guis" ;
 VP (Pres Sub Pl  P3) => ven_ + "guin" ;
 VP (Pres Sub Sg  P3) => ven_ + "gui" ;
 VP (Impf Ind Pl  P1) => ven_ + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => ven_ + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => ven_ + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => ven_ + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => ven_ + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => ven_ + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => ven_ + "guéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => ven_ + "gués" ;--# notpresent
 VP (Impf Sub Pl  P2) => ven_ + "guéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => ven_ + "guessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => ven_ + "guessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => ven_ + "gués" ;--# notpresent
 VP (Fut Pl  P1)  => ven_ + "drem" ;--# notpresent
 VP (Fut Sg  P1)  => ven_ + "dré" ;--# notpresent
 VP (Fut Pl  P2) => ven_ + "dreu" ;--# notpresent
 VP (Fut Sg  P2) => ven_ + "dràs" ;--# notpresent
 VP (Fut Pl  P3) => ven_ + "dran" ;--# notpresent
 VP (Fut Sg  P3) => ven_ + "drà" ;--# notpresent
 VP (Pret Pl  P1)  => ven_ + "guéssim" ;--# notpresent
 VP (Pret Sg  P1)  => ven_ + "gués" ;--# notpresent
 VP (Pret Pl  P2) => ven_ + "guéssiu" ;--# notpresent
 VP (Pret Sg  P2) => ven_ + "guessis" ;--# notpresent
 VP (Pret Pl  P3) => ven_ + "guessin" ;--# notpresent
 VP (Pret Sg  P3) => ven_ + "gués" ;--# notpresent
 VP (Cond Pl  P1)  => ven_ + "dríem" ;--# notpresent
 VP (Cond Sg  P1)  => ven_ + "dria" ;--# notpresent
 VP (Cond Pl  P2) => ven_ + "dríeu" ;--# notpresent
 VP (Cond Sg  P2) => ven_ + "dries" ;--# notpresent
 VP (Cond Pl  P3) => ven_ + "drien" ;--# notpresent
 VP (Cond Sg  P3) => ven_ + "dria" ;--# notpresent
 VP (Imp Pl  P1)  => ven_ + "guem" ;
 VP (Imp Pl  P2) => ven_ + "eu" ;
 VP (Imp Sg  P2) => ven_ + "" ;
 VP (Imp Pl  P3) => ven_ + "guin" ;
 VP (Imp Sg  P3) => ven_ + "gui" ;
 VP (Pass Pl  Fem) => ven_ + "udes" ;
 VP (Pass Sg  Fem) => ven_ + "uda" ;
 VP (Pass Pl  Masc) => ven_ + "uts" ;
 VP (Pass Sg  Masc) => ven_ + "ut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper venir_117 : Str -> Verbum = \venir ->
let v_ = Predef.tk 4 venir in
{s = table { 
 VI Infn => v_ + "enir" ;
 VI Ger => v_ + "enint" ;
 VI Part =>  v_ + "ingut" ;
 VP (Pres Ind Pl  P1) => v_ + "enim" ;
 VP (Pres Ind Sg  P1) => v_ + "inc" ;
 VP (Pres Ind Pl  P2) => v_ + "eniu" ;
 VP (Pres Ind Sg  P2) => v_ + "éns" ;
 VP (Pres Ind Pl  P3) => v_ + "énen" ;
 VP (Pres Ind Sg  P3) => v_ + "e" ;
 VP (Pres Sub Pl  P1) => v_ + "inguem" ;
 VP (Pres Sub Sg  P1) => v_ + "ingui" ;
 VP (Pres Sub Pl  P2) => v_ + "ingueu" ;
 VP (Pres Sub Sg  P2) => v_ + "inguis" ;
 VP (Pres Sub Pl  P3) => v_ + "inguin" ;
 VP (Pres Sub Sg  P3) => v_ + "ingui" ;
 VP (Impf Ind Pl  P1) => v_ + "eníem" ;--# notpresent
 VP (Impf Ind Sg  P1) => v_ + "enia" ;--# notpresent
 VP (Impf Ind Pl  P2) => v_ + "eníeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => v_ + "enies" ;--# notpresent
 VP (Impf Ind Pl  P3) => v_ + "enien" ;--# notpresent
 VP (Impf Ind Sg  P3) => v_ + "enia" ;--# notpresent
 VP (Impf Sub Pl  P1) => v_ + "inguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => v_ + "ingués" ;--# notpresent
 VP (Impf Sub Pl  P2) => v_ + "inguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => v_ + "inguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => v_ + "inguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => v_ + "ingués" ;--# notpresent
 VP (Fut Pl  P1)  => v_ + "indrem" ;--# notpresent
 VP (Fut Sg  P1)  => v_ + "indré" ;--# notpresent
 VP (Fut Pl  P2) => v_ + "indreu" ;--# notpresent
 VP (Fut Sg  P2) => v_ + "indràs" ;--# notpresent
 VP (Fut Pl  P3) => v_ + "indran" ;--# notpresent
 VP (Fut Sg  P3) => v_ + "indrà" ;--# notpresent
 VP (Pret Pl  P1)  => v_ + "inguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => v_ + "ingués" ;--# notpresent
 VP (Pret Pl  P2) => v_ + "inguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => v_ + "inguessis" ;--# notpresent
 VP (Pret Pl  P3) => v_ + "inguessin" ;--# notpresent
 VP (Pret Sg  P3) => v_ + "ingués" ;--# notpresent
 VP (Cond Pl  P1)  => v_ + "indríem" ;--# notpresent
 VP (Cond Sg  P1)  => v_ + "indria" ;--# notpresent
 VP (Cond Pl  P2) => v_ + "indríeu" ;--# notpresent
 VP (Cond Sg  P2) => v_ + "indries" ;--# notpresent
 VP (Cond Pl  P3) => v_ + "indrien" ;--# notpresent
 VP (Cond Sg  P3) => v_ + "indria" ;--# notpresent
 VP (Imp Pl  P1)  => v_ + "inguem" ;
 VP (Imp Pl  P2) => v_ + "eniu" ;
 VP (Imp Sg  P2) => v_ + "ine" ;
 VP (Imp Pl  P3) => v_ + "inguin" ;
 VP (Imp Sg  P3) => v_ + "ingui" ;
 VP (Pass Pl  Fem) => v_ + "ingudes" ;
 VP (Pass Sg  Fem) => v_ + "inguda" ;
 VP (Pass Pl  Masc) => v_ + "inguts" ;
 VP (Pass Sg  Masc) => v_ + "ingut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper veure_118 : Str -> Verbum = \veure ->
let v_ = Predef.tk 4 veure in
{s = table { 
 VI Infn => v_ + "eure" ;
 VI Ger => v_ + "eient" ;
 VI Part =>  v_ + "ist" ;
 VP (Pres Ind Pl  P1) => v_ + "eiem" ;
 VP (Pres Ind Sg  P1) => v_ + "eig" ;
 VP (Pres Ind Pl  P2) => v_ + "eieu" ;
 VP (Pres Ind Sg  P2) => v_ + "eus" ;
 VP (Pres Ind Pl  P3) => v_ + "euen" ;
 VP (Pres Ind Sg  P3) => v_ + "eu" ;
 VP (Pres Sub Pl  P1) => v_ + "egem" ;
 VP (Pres Sub Sg  P1) => v_ + "egi" ;
 VP (Pres Sub Pl  P2) => v_ + "egeu" ;
 VP (Pres Sub Sg  P2) => v_ + "egis" ;
 VP (Pres Sub Pl  P3) => v_ + "egin" ;
 VP (Pres Sub Sg  P3) => v_ + "egi" ;
 VP (Impf Ind Pl  P1) => v_ + "èiem" ;--# notpresent
 VP (Impf Ind Sg  P1) => v_ + "eia" ;--# notpresent
 VP (Impf Ind Pl  P2) => v_ + "èieu" ;--# notpresent
 VP (Impf Ind Sg  P2) => v_ + "eies" ;--# notpresent
 VP (Impf Ind Pl  P3) => v_ + "eien" ;--# notpresent
 VP (Impf Ind Sg  P3) => v_ + "eia" ;--# notpresent
 VP (Impf Sub Pl  P1) => v_ + "eiéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => v_ + "eiés" ;--# notpresent
 VP (Impf Sub Pl  P2) => v_ + "eiéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => v_ + "eiessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => v_ + "eiessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => v_ + "eiés" ;--# notpresent
 VP (Fut Pl  P1)  => v_ + "eurem" ;--# notpresent
 VP (Fut Sg  P1)  => v_ + "euré" ;--# notpresent
 VP (Fut Pl  P2) => v_ + "eureu" ;--# notpresent
 VP (Fut Sg  P2) => v_ + "euràs" ;--# notpresent
 VP (Fut Pl  P3) => v_ + "euran" ;--# notpresent
 VP (Fut Sg  P3) => v_ + "eurà" ;--# notpresent
 VP (Pret Pl  P1)  => v_ + "eiéssim" ;--# notpresent
 VP (Pret Sg  P1)  => v_ + "eiés" ;--# notpresent
 VP (Pret Pl  P2) => v_ + "eiéssiu" ;--# notpresent
 VP (Pret Sg  P2) => v_ + "eiessis" ;--# notpresent
 VP (Pret Pl  P3) => v_ + "eiessin" ;--# notpresent
 VP (Pret Sg  P3) => v_ + "eiés" ;--# notpresent
 VP (Cond Pl  P1)  => v_ + "euríem" ;--# notpresent
 VP (Cond Sg  P1)  => v_ + "euria" ;--# notpresent
 VP (Cond Pl  P2) => v_ + "euríeu" ;--# notpresent
 VP (Cond Sg  P2) => v_ + "euries" ;--# notpresent
 VP (Cond Pl  P3) => v_ + "eurien" ;--# notpresent
 VP (Cond Sg  P3) => v_ + "euria" ;--# notpresent
 VP (Imp Pl  P1)  => v_ + "egem" ;
 VP (Imp Pl  P2) => v_ + "egeu" ;
 VP (Imp Sg  P2) => v_ + "eges" ;
 VP (Imp Pl  P3) => v_ + "egin" ;
 VP (Imp Sg  P3) => v_ + "egi" ;
 VP (Pass Pl  Fem) => v_ + "istes" ;
 VP (Pass Sg  Fem) => v_ + "ista" ;
 VP (Pass Pl  Masc) => v_ + "ists" ;
 VP (Pass Sg  Masc) => v_ + "ist" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper viure_119 : Str -> Verbum = \viure ->
let vi_ = Predef.tk 3 viure in
{s = table { 
 VI Infn => vi_ + "ure" ;
 VI Ger => vi_ + "vint" ;
 VI Part =>  vi_ + "scut" ;
 VP (Pres Ind Pl  P1) => vi_ + "vim" ;
 VP (Pres Ind Sg  P1) => vi_ + "sc" ;
 VP (Pres Ind Pl  P2) => vi_ + "viu" ;
 VP (Pres Ind Sg  P2) => vi_ + "us" ;
 VP (Pres Ind Pl  P3) => vi_ + "uen" ;
 VP (Pres Ind Sg  P3) => vi_ + "u" ;
 VP (Pres Sub Pl  P1) => vi_ + "squem" ;
 VP (Pres Sub Sg  P1) => vi_ + "squi" ;
 VP (Pres Sub Pl  P2) => vi_ + "squeu" ;
 VP (Pres Sub Sg  P2) => vi_ + "squis" ;
 VP (Pres Sub Pl  P3) => vi_ + "squin" ;
 VP (Pres Sub Sg  P3) => vi_ + "squi" ;
 VP (Impf Ind Pl  P1) => vi_ + "víem" ;--# notpresent
 VP (Impf Ind Sg  P1) => vi_ + "via" ;--# notpresent
 VP (Impf Ind Pl  P2) => vi_ + "víeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => vi_ + "vies" ;--# notpresent
 VP (Impf Ind Pl  P3) => vi_ + "vien" ;--# notpresent
 VP (Impf Ind Sg  P3) => vi_ + "via" ;--# notpresent
 VP (Impf Sub Pl  P1) => vi_ + "squéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => vi_ + "squés" ;--# notpresent
 VP (Impf Sub Pl  P2) => vi_ + "squéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => vi_ + "squessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => vi_ + "squessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => vi_ + "squés" ;--# notpresent
 VP (Fut Pl  P1)  => vi_ + "urem" ;--# notpresent
 VP (Fut Sg  P1)  => vi_ + "uré" ;--# notpresent
 VP (Fut Pl  P2) => vi_ + "ureu" ;--# notpresent
 VP (Fut Sg  P2) => vi_ + "uràs" ;--# notpresent
 VP (Fut Pl  P3) => vi_ + "uran" ;--# notpresent
 VP (Fut Sg  P3) => vi_ + "urà" ;--# notpresent
 VP (Pret Pl  P1)  => vi_ + "squéssim" ;--# notpresent
 VP (Pret Sg  P1)  => vi_ + "squés" ;--# notpresent
 VP (Pret Pl  P2) => vi_ + "squéssiu" ;--# notpresent
 VP (Pret Sg  P2) => vi_ + "squessis" ;--# notpresent
 VP (Pret Pl  P3) => vi_ + "squessin" ;--# notpresent
 VP (Pret Sg  P3) => vi_ + "squés" ;--# notpresent
 VP (Cond Pl  P1)  => vi_ + "uríem" ;--# notpresent
 VP (Cond Sg  P1)  => vi_ + "uria" ;--# notpresent
 VP (Cond Pl  P2) => vi_ + "uríeu" ;--# notpresent
 VP (Cond Sg  P2) => vi_ + "uries" ;--# notpresent
 VP (Cond Pl  P3) => vi_ + "urien" ;--# notpresent
 VP (Cond Sg  P3) => vi_ + "uria" ;--# notpresent
 VP (Imp Pl  P1)  => vi_ + "squem" ;
 VP (Imp Pl  P2) => vi_ + "viu" ;
 VP (Imp Sg  P2) => vi_ + "u" ;
 VP (Imp Pl  P3) => vi_ + "squin" ;
 VP (Imp Sg  P3) => vi_ + "squi" ;
 VP (Pass Pl  Fem) => vi_ + "scudes" ;
 VP (Pass Sg  Fem) => vi_ + "scuda" ;
 VP (Pass Pl  Masc) => vi_ + "scuts" ;
 VP (Pass Sg  Masc) => vi_ + "scut" ;
VP (Imp Sg P1) => variants {} 
}
} ;

oper voler_120 : Str -> Verbum = \voler ->
let x_ = Predef.tk 4 voler in
{s = table { 
 VI Infn => x_ + "oler" ;
 VI Ger => x_ + "olent" ;
 VI Part =>  x_ + "olgut" ;
 VP (Pres Ind Pl  P1) => x_ + "olem" ;
 VP (Pres Ind Sg  P1) => x_ + "ull" ;
 VP (Pres Ind Pl  P2) => x_ + "oleu" ;
 VP (Pres Ind Sg  P2) => x_ + "ols" ;
 VP (Pres Ind Pl  P3) => x_ + "olen" ;
 VP (Pres Ind Sg  P3) => x_ + "ol" ;
 VP (Pres Sub Pl  P1) => x_ + "ulguem" ;
 VP (Pres Sub Sg  P1) => x_ + "ulgui" ;
 VP (Pres Sub Pl  P2) => x_ + "ulgueu" ;
 VP (Pres Sub Sg  P2) => x_ + "ulguis" ;
 VP (Pres Sub Pl  P3) => x_ + "ulguin" ;
 VP (Pres Sub Sg  P3) => x_ + "ulgui" ;
 VP (Impf Ind Pl  P1) => x_ + "olíem" ;--# notpresent
 VP (Impf Ind Sg  P1) => x_ + "olia" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "olíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "olies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "olien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "olia" ;--# notpresent
 VP (Impf Sub Pl  P1) => x_ + "olguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => x_ + "olgués" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "olguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "olguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "olguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "olgués" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "oldrem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "oldré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "oldreu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "oldràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "oldran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "oldrà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "olguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "olgués" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "olguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "olguessis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "olguessin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "olgués" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "oldríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "oldria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "oldríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "oldries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "oldrien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "oldria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "ulguem" ;
 VP (Imp Pl  P2) => x_ + "ulgueu" ;
 VP (Imp Sg  P2) => x_ + "ulgues" ;
 VP (Imp Pl  P3) => x_ + "ulguin" ;
 VP (Imp Sg  P3) => x_ + "ulgui" ;
 VP (Pass Pl  Fem) => x_ + "olgudes" ;
 VP (Pass Sg  Fem) => x_ + "olguda" ;
 VP (Pass Pl  Masc) => x_ + "olguts" ;
 VP (Pass Sg  Masc) => x_ + "olgut" ;
{- AR commented out duplicates 22/6/2009
 VI Infn => x_ + "oler" ;
 VI Ger => x_ + "olent" ;
 VI Part =>  x_ + "olgut" ;
 VP (Pres Ind Pl  P1)  => x_ + "olem" ;
 VP (Pres Ind Sg  P1)  => x_ + "ull" ;
 VP (Pres Ind Pl  P2) => x_ + "oleu" ;
 VP (Pres Ind Sg  P2) => x_ + "ols" ;
 VP (Pres Ind Pl  P3) => x_ + "olen" ;
 VP (Pres Ind Sg  P3) => x_ + "ol" ;
 VP (Pres Sub Pl  P1)  => x_ + "ulguem" ;
 VP (Pres Sub Sg  P1)  => x_ + "ulgui" ;
 VP (Pres Sub Pl  P2) => x_ + "ulgueu" ;
 VP (Pres Sub Sg  P2) => x_ + "ulguis" ;
 VP (Pres Sub Pl  P3) => x_ + "ulguin" ;
 VP (Pres Sub Sg  P3) => x_ + "ulgui" ;
 VP (Impf Ind Pl  P1)  => x_ + "olíem" ;--# notpresent
 VP (Impf Ind Sg  P1)  => x_ + "olia" ;--# notpresent
 VP (Impf Ind Pl  P2) => x_ + "olíeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => x_ + "olies" ;--# notpresent
 VP (Impf Ind Pl  P3) => x_ + "olien" ;--# notpresent
 VP (Impf Ind Sg  P3) => x_ + "olia" ;--# notpresent
 VP (Impf Sub Pl  P1)  => x_ + "olguéssim" ;--# notpresent
 VP (Impf Sub Sg  P1)  => x_ + "olgués" ;--# notpresent
 VP (Impf Sub Pl  P2) => x_ + "olguéssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => x_ + "olguessis" ;--# notpresent
 VP (Impf Sub Pl  P3) => x_ + "olguessin" ;--# notpresent
 VP (Impf Sub Sg  P3) => x_ + "olgués" ;--# notpresent
 VP (Fut Pl  P1)  => x_ + "oldrem" ;--# notpresent
 VP (Fut Sg  P1)  => x_ + "oldré" ;--# notpresent
 VP (Fut Pl  P2) => x_ + "oldreu" ;--# notpresent
 VP (Fut Sg  P2) => x_ + "oldràs" ;--# notpresent
 VP (Fut Pl  P3) => x_ + "oldran" ;--# notpresent
 VP (Fut Sg  P3) => x_ + "oldrà" ;--# notpresent
 VP (Pret Pl  P1)  => x_ + "olguéssim" ;--# notpresent
 VP (Pret Sg  P1)  => x_ + "olgués" ;--# notpresent
 VP (Pret Pl  P2) => x_ + "olguéssiu" ;--# notpresent
 VP (Pret Sg  P2) => x_ + "olguessis" ;--# notpresent
 VP (Pret Pl  P3) => x_ + "olguessin" ;--# notpresent
 VP (Pret Sg  P3) => x_ + "olgués" ;--# notpresent
 VP (Cond Pl  P1)  => x_ + "oldríem" ;--# notpresent
 VP (Cond Sg  P1)  => x_ + "oldria" ;--# notpresent
 VP (Cond Pl  P2) => x_ + "oldríeu" ;--# notpresent
 VP (Cond Sg  P2) => x_ + "oldries" ;--# notpresent
 VP (Cond Pl  P3) => x_ + "oldrien" ;--# notpresent
 VP (Cond Sg  P3) => x_ + "oldria" ;--# notpresent
 VP (Imp Pl  P1)  => x_ + "ulguem" ;
 VP (Imp Pl  P2) => x_ + "ulgueu" ;
 VP (Imp Sg  P2) => x_ + "ulgues" ;
 VP (Imp Pl  P3) => x_ + "ulguin" ;
 VP (Imp Sg  P3) => x_ + "ulgui" ;
 VP (Pass Pl  Fem) => x_ + "olgudes" ;
 VP (Pass Sg  Fem) => x_ + "olguda" ;
 VP (Pass Pl  Masc) => x_ + "olguts" ;
 VP (Pass Sg  Masc) => x_ + "olgut" ;
-}
VP (Imp Sg P1) => variants {} 
}
} ;
-- Verbs: conversion from full verbs to present-tense verbs.

  verbBesch : {s : VFB => Str} -> {s : CommonRomance.VF => Str} = \amar -> {s = table { 
    VInfin _                => amar.s ! VI Infn ;
    VFin (VPres   Indic) n p => amar.s ! VP (Pres Ind  n p) ; 
    VFin (VPres   Conjunct) n p => amar.s ! VP (Pres Sub n p) ;
    VFin (VImperf Indic) n p => amar.s ! VP (Impf Ind  n p) ;  --# notpresent --# notpresent
    VFin (VImperf Conjunct) n p => amar.s ! VP (Impf Sub n p) ; --# notpresent --# notpresent
    VFin VPasse n p        => amar.s ! VP (Pret n p) ; --# notpresent --# notpresent
    VFin VFut n p          => amar.s ! VP (Fut n p) ; --# notpresent --# notpresent
    VFin VCondit n p       => amar.s ! VP (Cond n p) ; --# notpresent --# notpresent
    VImper SgP2            => amar.s ! VP (Imp  Sg P2) ;
    VImper PlP1            => amar.s ! VP (Imp  Pl P1) ;
    VImper PlP2            => amar.s ! VP (Imp  Pl P2) ;
    VPart g n              => amar.s ! VP (Pass n g) ;
    VGer | VPresPart       => amar.s ! VI Ger
    }
  } ;


--Meta paradigms for verbs that end in -er. 
--Handles accents in infinitive and changes for j/g, ç/c.
oper verbEr : Str -> Verbum = \vèncer ->
let vènc = Predef.tk 2 vèncer ; 
    venc = deaccent vènc ;
    venç = soften venc ;
in {s = table { 
 VI Ger => venc + "ent" ;
 VI Part =>  venç + "ut" ;
 VP (Pres Ind Pl  P1) => venc + "em" ;
 VP (Pres Ind Sg  P1) => venç + "o" ;
 VP (Pres Ind Pl  P2) => venc + "eu" ;
 VP (Pres Ind Sg  P2) => venc + "es" ;
 VP (Pres Ind Pl  P3) => venc + "en" ;
 VP (Pres Ind Sg  P3) => venç ;
 VP (Pres Sub Pl  P1) => venc + "em" ;
 VP (Pres Sub Sg  P1) => venc + "i" ;
 VP (Pres Sub Pl  P2) => venc + "eu" ;
 VP (Pres Sub Sg  P2) => venc + "is" ;
 VP (Pres Sub Pl  P3) => venc + "in" ;
 VP (Pres Sub Sg  P3) => venc + "i" ;
 VP (Impf Ind Pl  P1) => venc + "íem" ;--# notpresent
 VP (Impf Ind Sg  P1) => venc + "ia" ;--# notpresent
 VP (Impf Ind Pl  P2) => venc + "íeu" ;--# notpresent
 VP (Impf Ind Sg  P2) => venc + "ies" ;--# notpresent
 VP (Impf Ind Pl  P3) => venc + "ien" ;--# notpresent
 VP (Impf Ind Sg  P3) => venc + "ia" ;--# notpresent
 VP (Impf Sub Pl  P1) => venc + "éssim" ;--# notpresent
 VP (Impf Sub Sg  P1) => venc + "és" ;--# notpresent
 VP (Impf Sub Pl  P2) => venc + "éssiu" ;--# notpresent
 VP (Impf Sub Sg  P2) => venc + "essis" ;--# notpresent
 VP (Impf Sub Pl  P3) => venc + "essin" ;--# notpresent
 VP (Impf Sub Sg  P3) => venc + "és" ;--# notpresent
 VP (Fut Pl  P1)  => venc + "erem" ;--# notpresent
 VP (Fut Sg  P1)  => venc + "eré" ;--# notpresent
 VP (Fut Pl  P2) => venc + "ereu" ;--# notpresent
 VP (Fut Sg  P2) => venc + "eràs" ;--# notpresent
 VP (Fut Pl  P3) => venc + "eran" ;--# notpresent
 VP (Fut Sg  P3) => venc + "erà" ;--# notpresent
 VP (Pret Pl  P1)  => venc + "éssim" ;--# notpresent
 VP (Pret Sg  P1)  => venc + "és" ;--# notpresent
 VP (Pret Pl  P2) => venc + "éssiu" ;--# notpresent
 VP (Pret Sg  P2) => venc + "essis" ;--# notpresent
 VP (Pret Pl  P3) => venc + "essin" ;--# notpresent
 VP (Pret Sg  P3) => venc + "és" ;--# notpresent
 VP (Cond Pl  P1)  => venc + "eríem" ;--# notpresent
 VP (Cond Sg  P1)  => venc + "eria" ;--# notpresent
 VP (Cond Pl  P2) => venc + "eríeu" ;--# notpresent
 VP (Cond Sg  P2) => venc + "eries" ;--# notpresent
 VP (Cond Pl  P3) => venc + "erien" ;--# notpresent
 VP (Cond Sg  P3) => venc + "eria" ;--# notpresent
 VP (Imp Pl  P1)  => venc + "em" ;
 VP (Imp Pl  P2) => venc + "eu" ;
 VP (Imp Sg  P2) => venç ;
 VP (Imp Pl  P3) => venc + "in" ;
 VP (Imp Sg  P3) => venc + "i" ;
 VP (Pass Pl  Fem) => venç + "udes" ;
 VP (Pass Sg  Fem) => venç + "uda" ;
 VP (Pass Pl  Masc) => venç + "uts" ;
 VP (Pass Sg  Masc) => venç + "ut" ;
 VI Infn => vèncer ;
VP (Imp Sg P1) => variants {} 
}
} ;


oper deaccent : Str -> Str = \témer ->
  case témer of {
    t@_ + "à" + mer@_ => t + "a" + mer ;
    t@_ + "é" + mer@_ => t + "e" + mer ;
    t@_ + "è" + mer@_ => t + "e" + mer ;
    t@_ + "í" + mer@_ => t + "i" + mer ;
    t@_ + "ó" + mer@_ => t + "o" + mer ;
    t@_ + "ò" + mer@_ => t + "o" + mer ;
    t@_ + "ú" + mer@_ => t + "u" + mer ;
    _                 => témer 
  } ;

oper soften : Str -> Str = \venc ->
  case venc of {
    ven + "c" => ven + "ç" ;
    men + "g" => men + "j" ;
    _         => venc  
  } ;
---- The full conjunction is a table on $VForm$:
--
param
  VImpers =   
     Infn   
   | Ger   
   | Part
   ;
   
  Mode = Ind | Sub ;

  VPers =   
      Pres Mode Number Person   
   | Impf Mode Number Person    --# notpresent --# notpresent
   | Pret      Number Person    --# notpresent --# notpresent
   | Fut Number Person          --# notpresent --# notpresent
   | Cond      Number Person    --# notpresent --# notpresent
   | Imp       Number Person
   | Pass      Number Gender   
   ;
   
  VFB =   
     VI VImpers   
   | VP VPers   
   ;
--
--
}
