module MorphFormat where

import CfFormat

-- morphological parametres in a functional grammar format. AR 1998

type MPar     = String
type MTag     = String
type MTags    = [MTag]
type MLinType = [(MTags,String)]

type MParam   = [(MPar, Either Int MTag)]
type MArgs    = [Either (Int,MPar) MTag]
type MString  = (Str,MParam)
type Str      = [(MTags,([([String],String)],String))]
type MPattern = [Either (Int,MArgs) (Str,MArgs)]
type MEntry   = ([(MTags,MPattern)],MParam)
type MRule    = (Function,MEntry)
type MGrammar = [(String,MRule)]

MLookup :: MGrammar -> Fun -> MRule
MLin    :: MGrammar -> Tree -> MTags -> String
MInh    :: MGrammar -> Tree -> [(MPar,MTag)]

MLookup G (Fun F) = case lookup F G of Just c -> c
                                       _  -> error ("unknown item " ++ F)

MLin G (VarL X) m = "$"++ foldl (\x y -> x ++ "," ++ y) "" [x | Var x <- X] ++ "$"
MLin G (Place (Var x)) m = x 
MLin G (Apply F X) m = 
 AX (Pt G F m)
  where
   Pt G F m = case lookup m (fst (snd (MLookup G F))) of
                   Just P -> P
                   _      -> error ("undefined form of " ++ (show F))
   AX (Left  (n,p) : P)   = MLin G (X !! n) (mor p) ++ sp (AX P)
   AX (Right (t,p) : P)   = ccat (choose t (mor p)) (AX P)
   AX _                   = ""
   mor (Left (i,c) : p)   = inh (MInh G (X !! i)) c : mor p
   mor (Right t : p)      = t : mor p
   mor _                  = []
   inh M c = case lookup c M of { Just s -> s ; _ -> error "undefined parametre" }
   sp s         = if s=="" then s else " " ++ s
   choose t m = case lookup m t of { Just s -> s ; _ -> error "undefined word" } 
   ccat (S,d) c = case match c [(y,s) | (l,s) <- S, y <-l] of Just s -> s ++ sp c
                                                              _      -> d ++ sp c
   match c L    = case L of (y,s) : K -> if prefix y c then Just s else match c K
                            _         -> Nothing
   prefix y c   = length y <= length c && take (length y) c == y

MInh G (VarL X) = []
MInh G (Place (Var x)) = [] 
MInh G (Apply F X) =
 MX I
  where
   I                    = snd (snd (MLookup G F))
   MX ((c,Left i) : p)  = inh (MInh G (X !! i)) c : MX p
   MX ((c,Right t) : p) = (c,t) : MX p
   inh M c = case lookup c M of Just s -> (c,s) 
                                _ -> error "undefined parametre"

StripMGrammar :: MGrammar -> Grammar
StripMGrammar G = 
 foldl (++) [] (map OpenEntry G)
  where 
   OpenEntry (F,(A,(M,I)))  = [(F,(A, P')) | (m,P) <- M, P' <- OpenPatt P]
   OpenPatt (Left (n,m):P)  = [Left n : p  | p <- OpenPatt P]
   OpenPatt (Right (t,m):P) = [map Right s ++ p | s <- OpenStr t, p <- OpenPatt P]
   OpenPatt _               = [[]]
   OpenStr t                = [words s | (m,(L,d)) <- t, s <- d : map snd L]
