module GF.JavaScript.AbsJS where

-- Haskell module generated by the BNF converter

newtype Ident = Ident String deriving (Eq,Ord,Show)
data Program =
   Program [Element]
  deriving (Eq,Ord,Show)

data Element =
   FunDef Ident [Ident] [Stmt]
 | ElStmt Stmt
  deriving (Eq,Ord,Show)

data Stmt =
   SCompound [Stmt]
 | SReturnVoid
 | SReturn Expr
 | SDeclOrExpr DeclOrExpr
  deriving (Eq,Ord,Show)

data DeclOrExpr =
   Decl [DeclVar]
 | DExpr Expr
  deriving (Eq,Ord,Show)

data DeclVar =
   DVar Ident
 | DInit Ident Expr
  deriving (Eq,Ord,Show)

data Expr =
   EAssign Expr Expr
 | ENew Ident [Expr]
 | EMember Expr Ident
 | EIndex Expr Expr
 | ECall Expr [Expr]
 | EVar Ident
 | EInt Int
 | EDbl Double
 | EStr String
 | ETrue
 | EFalse
 | ENull
 | EThis
 | EFun [Ident] [Stmt]
 | EArray [Expr]
 | EObj [Property]
 | ESeq [Expr]
  deriving (Eq,Ord,Show)

data Property =
   Prop PropertyName Expr
  deriving (Eq,Ord,Show)

data PropertyName =
   IdentPropName Ident
 | StringPropName String
 | IntPropName Int
  deriving (Eq,Ord,Show)

