concrete TopDictionaryTha of TopDictionary = CatTha **
open ParadigmsTha, ResTha, Prelude in {


-- (c) AR 2011-2015 in collaboration with Chotiros Kairoje, under LGPL

flags coding = utf8 ;


oper poss = "ของ" ;
oper mkInterj : Str -> Interj = \s -> lin Interj (ss s) ;
oper mkVV : Str -> VV = \s -> lin VV {s = s ; typ = VVPost} ;
oper mmkVS : Str -> VS = \s -> mkVS (mkV s) ;
oper mmkVA : Str -> VA = \s -> mkVA (mkV s) ;
oper mmkVQ : Str -> VQ = \s -> mkVQ (mkV s) ;
oper mmkV2V : Str -> V2V = \s -> mkV2V (mkV s) [] [] ;
oper mmkV2A : Str -> V2A = \s -> mkV2A (mkV s) [] [] ;
oper mmkV2S : Str -> V2S = \s -> mkV2S (mkV s) [] ;

lin of_Prep = mkPrep "ของ" | mkPrep "ถึง" | mkPrep "โดย" | mkPrep "ด้วย" | mkPrep "แห่ง" | mkPrep "ที่จะ" | mkPrep "ที่มี" | mkPrep "ในฐานะ" | mkPrep "ในจํานวน" | mkPrep "ในจําพวก" | mkPrep "ในปริมาณ" | mkPrep "ในเรื่อง" | mkPrep "เกี่ยวกับ" ; -- src=panlex
lin and_Conj = {s1 = [] ; s2 = "และ"} ;
lin in_Prep = ss (thword "ใน") | {-pan-} mkPrep "ใน" | mkPrep "ภายใน" | mkPrep "ข้างใน" | mkPrep "ในภาวะ" | mkPrep "ในสภาพ" | mkPrep "อยู่ภายใน" | mkPrep "ในระหว่าง" | mkPrep "อยู่ด้านใน" | mkPrep "ในข้อที่ว่า" ; -- src=panlex
lin have_VV = mkVV "มี" ; ---- | mkV "จัด" | mkV "รับ" | mkV "ได้" | mkV "คลอด" | mkV "เกิด" | mkV "ทำให้" | mkV "เหลือ" | mkV "บริโภค" | mkV "มีอะไร" | mkV "ยอมรับ" | mkV "รู้สึก" | mkV "ได้รับ" | mkV "คลอดลูก" | mkV "มีอาการ" | mkV "มีเหลือ" | mkV "เกิดลูก" | mkV "มีลักษณะ" | mkV "ให้กำเนิด" | mkV "อยู่ในช่วง" | mkV "เป็นเจ้าของ" | mkV "เป็นเหตุให้" | mkV "มีเพศสัมพันธ์" | mkV "มีพระประสูติการ" | mkV "มี" | mkV "กิน" | mkV "จัด" | mkV "ทาน" | mkV "ได้" | mkV "คลอด" | mkV "มีแขก" | mkV "ได้รับ" | mkV "เป็นโรค" | mkV "รับประทาน" | mkV "เตรียมการ" | mkV "ประกอบด้วย" | mkV "ให้กําเนิด" | mkV "ป่วยเป็นโรค" | mkV "เป็นเจ้าของ" | mkV "ให้การต้อนรับแขก" ; -- src=panlex
lin have_V2 = mkV2 "มี" ;
lin have_V = mkV "มี" | mkV "จัด" | mkV "รับ" | mkV "ได้" | mkV "คลอด" | mkV "เกิด" | mkV "ทำให้" | mkV "เหลือ" | mkV "บริโภค" | mkV "มีอะไร" | mkV "ยอมรับ" | mkV "รู้สึก" | mkV "ได้รับ" | mkV "คลอดลูก" | mkV "มีอาการ" | mkV "มีเหลือ" | mkV "เกิดลูก" | mkV "มีลักษณะ" | mkV "ให้กำเนิด" | mkV "อยู่ในช่วง" | mkV "เป็นเจ้าของ" | mkV "เป็นเหตุให้" | mkV "มีเพศสัมพันธ์" | mkV "มีพระประสูติการ" | mkV "มี" | mkV "กิน" | mkV "จัด" | mkV "ทาน" | mkV "ได้" | mkV "คลอด" | mkV "มีแขก" | mkV "ได้รับ" | mkV "เป็นโรค" | mkV "รับประทาน" | mkV "เตรียมการ" | mkV "ประกอบด้วย" | mkV "ให้กําเนิด" | mkV "ป่วยเป็นโรค" | mkV "เป็นเจ้าของ" | mkV "ให้การต้อนรับแขก" ; -- src=panlex
lin it_Pron = ss "มัน" ;
lin to_Prep = ss "ถืง" | {-pan-} mkPrep "ตาม" | mkPrep "ถึง" | mkPrep "ให้" | mkPrep "จนถึง" | mkPrep "เพื่อ" | mkPrep "ไปถึง" | mkPrep "ไปทาง" | mkPrep "ไปยัง" | mkPrep "ไปสู่" | mkPrep "ตรงกัน" | mkPrep "ติดตาม" | mkPrep "เข้ากับ" | mkPrep "เพื่อจะ" | mkPrep "บรรลุถึง" | mkPrep "ตรงกันกับ" | mkPrep "สนองตอบกัน" | mkPrep "ในอันที่จะ" | mkPrep "จนกระทั่งถึง" | mkPrep "มีความโน้มน้าว" ; -- src=panlex
lin for_Prep = ss "ให้" | {-pan-} mkPrep "แก่" | mkPrep "แทน" | mkPrep "เพื่อ" | mkPrep "ไปยัง" | mkPrep "แลกกับ" | mkPrep "ในส่วน" | mkPrep "ให้กับ" | mkPrep "ให้แก่" | mkPrep "สําหรับ" | mkPrep "สนับสนุน" | mkPrep "เป็นระยะ" | mkPrep "เป็นเวลา" | mkPrep "เพราะว่า" | mkPrep "เห็นด้วย" | mkPrep "ในฐานะของ" | mkPrep "เป็นจํานวนเงิน" ; -- src=panlex
lin i_Pron = ss "ผม" ;
lin iFem_Pron = ss chan_s ;
lin that_Subj = ss conjThat ;
lin he_Pron = ss khaw_s ;
lin on_Prep = ss "บน" | {-pan-} mkPrep "ณ" | mkPrep "บน" | mkPrep "ตาม" | mkPrep "ที่" | mkPrep "โดย" | mkPrep "ด้วย" | mkPrep "ใกล้" | mkPrep "อาศัย" | mkPrep "ไปทาง" | mkPrep "ไปสู่" | mkPrep "ตามแผน" | mkPrep "ติดกัน" | mkPrep "ประชิด" | mkPrep "ในสภาพ" | mkPrep "อยู่ติด" | mkPrep "ใช้อยู่" | mkPrep "ในขณะที่" | mkPrep "ในลักษณะ" | mkPrep "ในวันที่" | mkPrep "ในเรื่อง" | mkPrep "สถานการณ์" | mkPrep "เกี่ยวกับ" | mkPrep "ในเวลาที่" | mkPrep "ในอาการที่" | mkPrep "ทันทีหลังจาก" | mkPrep "อยู่ในระหว่าง" | mkPrep "อยู่ในสถานการณ์" | mkPrep "ซึ่งกําลังเกิดขึ้น" ; -- src=panlex
lin with_Prep = ss "กับ" | {-pan-} mkPrep "กับ" | mkPrep "ร่วมกับ" | mkPrep "พร้อมด้วย" | mkPrep "เกี่ยวกับ" | mkPrep "ประกอบด้วย" ; -- src=panlex
lin do_V2 = mkV2 (mkV "ทำ") ; ----?lin "ทำ" "ทำ" "ทำ" "กำลังทำ") ;
lin at_Prep = mkPrep "ที่" | {-pan-} mkPrep "ณ เวลา" | mkPrep "จาก" | mkPrep "ไปยัง" | mkPrep "เข้าร่วม" | mkPrep "ในลักษณะ" | mkPrep "ในช่วงเวลา" ; -- src=panlex
lin by_Prep = mkPrep "ของ" | mkPrep "จาก" | mkPrep "ตาม" | mkPrep "ต่อ" | mkPrep "ทาง" | mkPrep "ที่" | mkPrep "ทุก" | mkPrep "โดย" | mkPrep "ใช้" | mkPrep "ข้าง" | mkPrep "ช่วง" | mkPrep "ด้วย" | mkPrep "ทีละ" | mkPrep "ผ่าน" | mkPrep "ใกล้" | mkPrep "อาศัย" | mkPrep "ไปทาง" | mkPrep "ไปยัง" | mkPrep "ติดตัว" | mkPrep "ผ่านไป" | mkPrep "ระหว่าง" | mkPrep "ผ่านข้าง" | mkPrep "หันไปทาง" | mkPrep "อยู่ข้าง" | mkPrep "เป็นไปตาม" | mkPrep "โดยประมาณ" | mkPrep "เป็นผลเนื่องจาก" ; -- src=panlex
lin but_Conj = variants{} ; -- 
lin from_Prep = ss "จาก" | {-pan-} mkPrep "จาก" | mkPrep "มาจาก" | mkPrep "นับจาก" | mkPrep "ตั้งแต่" | mkPrep "ห่างจาก" | mkPrep "โดยอาศัย" | mkPrep "เนื่องจาก" | mkPrep "เนื่องแต่" | mkPrep "เนื่องด้วย" ; -- src=panlex
lin they_Pron = mkNP (thword "พวก" khaw_s) ; --- mkNP (thword "เขา" "ทั้ง" "หลาย") ;
lin theyFem_Pron = mkNP (thword "พวก" khaw_s) ; --- mkNP (thword "เขา" "ทั้ง" "หลาย") ;
lin she_Pron = ss "หล่อน" ;
lin or_Conj = {s1 = [] ; s2 = "หริอ"} ;
lin as_Subj = variants{} ; -- 
lin we_Pron = ss raw_s ;
lin weFem_Pron = ss raw_s ;
lin say_VS = mkVS (regV "พูด") ;
lin say_V2 = mkV2 "บอก" ; ---- | mkV "พูด" | mkV "ท่อง" | mkV "สั่ง" | mkV "เสนอ" | mkV "แจ้ง" | mkV "กล่าว" | mkV "ยืนยัน" | mkV "บอกเวลา" | mkV "ออกเสียง" | mkV "แสดงข้อเท็จจริง" | mkV "บอก" | mkV "พูด" | mkV "เล่า" | mkV "เอ่ย" | mkV "แจ้ง" | mkV "กล่าว" | mkV "คาดเดา" | mkV "ประมาณ" | mkV "ยกตัวอย่าง" | mkV "แสดงความคิดเห็น" ; -- src=panlex
lin say_V = mkV "บอก" | mkV "พูด" | mkV "ท่อง" | mkV "สั่ง" | mkV "เสนอ" | mkV "แจ้ง" | mkV "กล่าว" | mkV "ยืนยัน" | mkV "บอกเวลา" | mkV "ออกเสียง" | mkV "แสดงข้อเท็จจริง" | mkV "บอก" | mkV "พูด" | mkV "เล่า" | mkV "เอ่ย" | mkV "แจ้ง" | mkV "กล่าว" | mkV "คาดเดา" | mkV "ประมาณ" | mkV "ยกตัวอย่าง" | mkV "แสดงความคิดเห็น" ; -- src=panlex
lin if_Subj = ss (thword "ถ้า") ; ---- ... ko
lin go_VV = mkVV pay_s ; ---- | {-pan-} mkV "ไป" | mkV "ซี้" | mkV "ดัง" | mkV "ดับ" | mkV "ตาย" | mkV "ล้ม" | mkV "ผ่าน" | mkV "เสีย" | mkV "จากไป" | mkV "ทำงาน" | mkV "มาจาก" | mkV "ยังคง" | mkV "ไปไกล" | mkV "ดำเนิน" | mkV "ทิวงคต" | mkV "มรณภาพ" | mkV "มอบให้" | mkV "รอดตาย" | mkV "รู้สึก" | mkV "ลงสนาม" | mkV "สวรรคต" | mkV "สิ้นลม" | mkV "สิ้นใจ" | mkV "จบชีวิต" | mkV "นำไปสู่" | mkV "รื้อค้น" | mkV "ลงคะแนน" | mkV "สิ้นชีพ" | mkV "เข้าโลง" | mkV "เดินทาง" | mkV "โละทิ้ง" | mkV "ไปจนถึง" | mkV "รอดชีวิต" | mkV "ส่งเสียง" | mkV "หมดไปกับ" | mkV "ดำเนินการ" | mkV "เสียชีวิต" | mkV "ถึงแก่กรรม" | mkV "ผสมกลมกลืน" | mkV "มีชีวิตรอด" | mkV "ใส่ได้พอดี" | mkV "สิ้นพระชนม์" | mkV "เปรียบเทียบ" | mkV "เสด็จสวรรคต" | mkV "ถึงชีพิตักษัย" | mkV "ถึงแก่พิราลัย" | mkV "ใช้จนเกือบหมด" | mkV "ถึงแก่อนิจกรรม" | mkV "ถึงแก่อสัญกรรม" | mkV "ทำให้เกิดเสียง" | mkV "สิ้นชีพิตักษัย" | mkV "ไป" | mkV "หมด" | mkV "ทิ้ง" | mkV "เลิก" | mkV "บรรลุ" | mkV "มาถึง" | mkV "ลาออก" | mkV "กําจัด" | mkV "จบสิ้น" | mkV "หมดอายุ" | mkV "ส่งเสียง" | mkV "ออกไปถึง" | mkV "ถูกใช้หมด" | mkV "ล่วงเลยไป" | mkV "เคลื่อนไป" ; -- src=panlex
lin go_VA = mmkVA pay_s ; ---- | {-pan-} mkV "ไป" | mkV "ซี้" | mkV "ดัง" | mkV "ดับ" | mkV "ตาย" | mkV "ล้ม" | mkV "ผ่าน" | mkV "เสีย" | mkV "จากไป" | mkV "ทำงาน" | mkV "มาจาก" | mkV "ยังคง" | mkV "ไปไกล" | mkV "ดำเนิน" | mkV "ทิวงคต" | mkV "มรณภาพ" | mkV "มอบให้" | mkV "รอดตาย" | mkV "รู้สึก" | mkV "ลงสนาม" | mkV "สวรรคต" | mkV "สิ้นลม" | mkV "สิ้นใจ" | mkV "จบชีวิต" | mkV "นำไปสู่" | mkV "รื้อค้น" | mkV "ลงคะแนน" | mkV "สิ้นชีพ" | mkV "เข้าโลง" | mkV "เดินทาง" | mkV "โละทิ้ง" | mkV "ไปจนถึง" | mkV "รอดชีวิต" | mkV "ส่งเสียง" | mkV "หมดไปกับ" | mkV "ดำเนินการ" | mkV "เสียชีวิต" | mkV "ถึงแก่กรรม" | mkV "ผสมกลมกลืน" | mkV "มีชีวิตรอด" | mkV "ใส่ได้พอดี" | mkV "สิ้นพระชนม์" | mkV "เปรียบเทียบ" | mkV "เสด็จสวรรคต" | mkV "ถึงชีพิตักษัย" | mkV "ถึงแก่พิราลัย" | mkV "ใช้จนเกือบหมด" | mkV "ถึงแก่อนิจกรรม" | mkV "ถึงแก่อสัญกรรม" | mkV "ทำให้เกิดเสียง" | mkV "สิ้นชีพิตักษัย" | mkV "ไป" | mkV "หมด" | mkV "ทิ้ง" | mkV "เลิก" | mkV "บรรลุ" | mkV "มาถึง" | mkV "ลาออก" | mkV "กําจัด" | mkV "จบสิ้น" | mkV "หมดอายุ" | mkV "ส่งเสียง" | mkV "ออกไปถึง" | mkV "ถูกใช้หมด" | mkV "ล่วงเลยไป" | mkV "เคลื่อนไป" ; -- src=panlex
lin go_V = mkV pay_s | {-pan-} mkV "ไป" | mkV "ซี้" | mkV "ดัง" | mkV "ดับ" | mkV "ตาย" | mkV "ล้ม" | mkV "ผ่าน" | mkV "เสีย" | mkV "จากไป" | mkV "ทำงาน" | mkV "มาจาก" | mkV "ยังคง" | mkV "ไปไกล" | mkV "ดำเนิน" | mkV "ทิวงคต" | mkV "มรณภาพ" | mkV "มอบให้" | mkV "รอดตาย" | mkV "รู้สึก" | mkV "ลงสนาม" | mkV "สวรรคต" | mkV "สิ้นลม" | mkV "สิ้นใจ" | mkV "จบชีวิต" | mkV "นำไปสู่" | mkV "รื้อค้น" | mkV "ลงคะแนน" | mkV "สิ้นชีพ" | mkV "เข้าโลง" | mkV "เดินทาง" | mkV "โละทิ้ง" | mkV "ไปจนถึง" | mkV "รอดชีวิต" | mkV "ส่งเสียง" | mkV "หมดไปกับ" | mkV "ดำเนินการ" | mkV "เสียชีวิต" | mkV "ถึงแก่กรรม" | mkV "ผสมกลมกลืน" | mkV "มีชีวิตรอด" | mkV "ใส่ได้พอดี" | mkV "สิ้นพระชนม์" | mkV "เปรียบเทียบ" | mkV "เสด็จสวรรคต" | mkV "ถึงชีพิตักษัย" | mkV "ถึงแก่พิราลัย" | mkV "ใช้จนเกือบหมด" | mkV "ถึงแก่อนิจกรรม" | mkV "ถึงแก่อสัญกรรม" | mkV "ทำให้เกิดเสียง" | mkV "สิ้นชีพิตักษัย" | mkV "ไป" | mkV "หมด" | mkV "ทิ้ง" | mkV "เลิก" | mkV "บรรลุ" | mkV "มาถึง" | mkV "ลาออก" | mkV "กําจัด" | mkV "จบสิ้น" | mkV "หมดอายุ" | mkV "ส่งเสียง" | mkV "ออกไปถึง" | mkV "ถูกใช้หมด" | mkV "ล่วงเลยไป" | mkV "เคลื่อนไป" ; -- src=panlex
lin get_VV = variants{} ; -- 
lin get_V2V = variants{} ; -- 
lin make_V2V = mmkV2V "ทำ" ; ---- | mkV "อึ" | mkV "ก่อ" | mkV "ขีด" | mkV "ขี้" | mkV "จัด" | mkV "ฉี่" | mkV "ถึง" | mkV "บวก" | mkV "ออก" | mkV "ได้" | mkV "ถ่าย" | mkV "ผลิต" | mkV "หลอก" | mkV "เป็น" | mkV "กระทำ" | mkV "คำนวน" | mkV "ทำท่า" | mkV "ทำให้" | mkV "มาถึง" | mkV "สร้าง" | mkV "ใช้ทำ" | mkV "ไปถึง" | mkV "ครีเอท" | mkV "ล่อลวง" | mkV "เยี่ยว" | mkV "ได้รับ" | mkV "ก่อขึ้น" | mkV "ขับถ่าย" | mkV "ถ่ายเบา" | mkV "ทำอาหาร" | mkV "ปัสสาวะ" | mkV "มีนิสัย" | mkV "อุจจาระ" | mkV "เปลี่ยน" | mkV "เปิดทาง" | mkV "ก่อสร้าง" | mkV "ถ่ายท้อง" | mkV "ถ่ายหนัก" | mkV "ทำเหมือน" | mkV "ปลดทุกข์" | mkV "มักกระทำ" | mkV "เหมาะกับ" | mkV "ถ่ายทุกข์" | mkV "ทำกับข้าว" | mkV "ทำให้พอใจ" | mkV "มาทันเวลา" | mkV "ก่อให้เกิด" | mkV "ประกอบด้วย" | mkV "ยิงกระต่าย" | mkV "รวมกันเป็น" | mkV "รวมตัวเป็น" | mkV "รับหน้าที่" | mkV "สรรค์สร้าง" | mkV "สร้างสรรค์" | mkV "เด็ดดอกไม้" | mkV "ถ่ายปัสสาวะ" | mkV "ถ่ายอุจจาระ" | mkV "ประกอบอาหาร" | mkV "มุ่งหน้าสู่" | mkV "เตรียมอาหาร" | mkV "มาถึงทันเวลา" | mkV "ไปถึงทันเวลา" | mkV "ไปถึงเป้าหมาย" | mkV "ทำให้เชื่อมั่น" | mkV "เป็นสิ่งจำเป็นของ" | mkV "เปลี่ยนแปลงตัวเองเป็น" | mkV "กะ" | mkV "ทำ" | mkV "ถึง" | mkV "ทัน" | mkV "ทํา" | mkV "ผลิต" | mkV "แต่ง" | mkV "จัดหา" | mkV "มาถึง" | mkV "สร้าง" | mkV "หาได้" | mkV "เขียน" | mkV "ไปถึง" | mkV "จัดทํา" | mkV "ทําให้" | mkV "บังคับ" | mkV "ประมาณ" | mkV "เข้าใจ" | mkV "เตรียม" | mkV "กระตุ้น" | mkV "คาดคะเน" | mkV "จัดเวลา" | mkV "จัดแต่ง" | mkV "ทันเวลา" | mkV "ทําเงิน" | mkV "ประเมิน" | mkV "รวมเป็น" | mkV "เท่ากับ" | mkV "กลายเป็น" | mkV "ทํากําไร" | mkV "ทําเตียง" | mkV "ประพันธ์" | mkV "มีรายได้" | mkV "หารายได้" | mkV "แต่งตั้ง" | mkV "ก่อให้เกิด" | mkV "ทําให้เป็น" | mkV "สร้างกําไร" | mkV "สร้างรายได้" | mkV "เป็นเหตุให้" | mkV "จัดตารางเวลา" | mkV "บังคับให้ทํา" | mkV "มีจํานวนเป็น" | mkV "บรรลุเป้าหมาย" | mkV "เปลี่ยนสภาพเป็น" ; -- src=panlex
lin make_V2A = mmkV2A "ทำ" ; ---- | mkV "อึ" | mkV "ก่อ" | mkV "ขีด" | mkV "ขี้" | mkV "จัด" | mkV "ฉี่" | mkV "ถึง" | mkV "บวก" | mkV "ออก" | mkV "ได้" | mkV "ถ่าย" | mkV "ผลิต" | mkV "หลอก" | mkV "เป็น" | mkV "กระทำ" | mkV "คำนวน" | mkV "ทำท่า" | mkV "ทำให้" | mkV "มาถึง" | mkV "สร้าง" | mkV "ใช้ทำ" | mkV "ไปถึง" | mkV "ครีเอท" | mkV "ล่อลวง" | mkV "เยี่ยว" | mkV "ได้รับ" | mkV "ก่อขึ้น" | mkV "ขับถ่าย" | mkV "ถ่ายเบา" | mkV "ทำอาหาร" | mkV "ปัสสาวะ" | mkV "มีนิสัย" | mkV "อุจจาระ" | mkV "เปลี่ยน" | mkV "เปิดทาง" | mkV "ก่อสร้าง" | mkV "ถ่ายท้อง" | mkV "ถ่ายหนัก" | mkV "ทำเหมือน" | mkV "ปลดทุกข์" | mkV "มักกระทำ" | mkV "เหมาะกับ" | mkV "ถ่ายทุกข์" | mkV "ทำกับข้าว" | mkV "ทำให้พอใจ" | mkV "มาทันเวลา" | mkV "ก่อให้เกิด" | mkV "ประกอบด้วย" | mkV "ยิงกระต่าย" | mkV "รวมกันเป็น" | mkV "รวมตัวเป็น" | mkV "รับหน้าที่" | mkV "สรรค์สร้าง" | mkV "สร้างสรรค์" | mkV "เด็ดดอกไม้" | mkV "ถ่ายปัสสาวะ" | mkV "ถ่ายอุจจาระ" | mkV "ประกอบอาหาร" | mkV "มุ่งหน้าสู่" | mkV "เตรียมอาหาร" | mkV "มาถึงทันเวลา" | mkV "ไปถึงทันเวลา" | mkV "ไปถึงเป้าหมาย" | mkV "ทำให้เชื่อมั่น" | mkV "เป็นสิ่งจำเป็นของ" | mkV "เปลี่ยนแปลงตัวเองเป็น" | mkV "กะ" | mkV "ทำ" | mkV "ถึง" | mkV "ทัน" | mkV "ทํา" | mkV "ผลิต" | mkV "แต่ง" | mkV "จัดหา" | mkV "มาถึง" | mkV "สร้าง" | mkV "หาได้" | mkV "เขียน" | mkV "ไปถึง" | mkV "จัดทํา" | mkV "ทําให้" | mkV "บังคับ" | mkV "ประมาณ" | mkV "เข้าใจ" | mkV "เตรียม" | mkV "กระตุ้น" | mkV "คาดคะเน" | mkV "จัดเวลา" | mkV "จัดแต่ง" | mkV "ทันเวลา" | mkV "ทําเงิน" | mkV "ประเมิน" | mkV "รวมเป็น" | mkV "เท่ากับ" | mkV "กลายเป็น" | mkV "ทํากําไร" | mkV "ทําเตียง" | mkV "ประพันธ์" | mkV "มีรายได้" | mkV "หารายได้" | mkV "แต่งตั้ง" | mkV "ก่อให้เกิด" | mkV "ทําให้เป็น" | mkV "สร้างกําไร" | mkV "สร้างรายได้" | mkV "เป็นเหตุให้" | mkV "จัดตารางเวลา" | mkV "บังคับให้ทํา" | mkV "มีจํานวนเป็น" | mkV "บรรลุเป้าหมาย" | mkV "เปลี่ยนสภาพเป็น" ; -- src=panlex
lin make_V2 = mkV2 "ทำ" ; ---- | mkV "อึ" | mkV "ก่อ" | mkV "ขีด" | mkV "ขี้" | mkV "จัด" | mkV "ฉี่" | mkV "ถึง" | mkV "บวก" | mkV "ออก" | mkV "ได้" | mkV "ถ่าย" | mkV "ผลิต" | mkV "หลอก" | mkV "เป็น" | mkV "กระทำ" | mkV "คำนวน" | mkV "ทำท่า" | mkV "ทำให้" | mkV "มาถึง" | mkV "สร้าง" | mkV "ใช้ทำ" | mkV "ไปถึง" | mkV "ครีเอท" | mkV "ล่อลวง" | mkV "เยี่ยว" | mkV "ได้รับ" | mkV "ก่อขึ้น" | mkV "ขับถ่าย" | mkV "ถ่ายเบา" | mkV "ทำอาหาร" | mkV "ปัสสาวะ" | mkV "มีนิสัย" | mkV "อุจจาระ" | mkV "เปลี่ยน" | mkV "เปิดทาง" | mkV "ก่อสร้าง" | mkV "ถ่ายท้อง" | mkV "ถ่ายหนัก" | mkV "ทำเหมือน" | mkV "ปลดทุกข์" | mkV "มักกระทำ" | mkV "เหมาะกับ" | mkV "ถ่ายทุกข์" | mkV "ทำกับข้าว" | mkV "ทำให้พอใจ" | mkV "มาทันเวลา" | mkV "ก่อให้เกิด" | mkV "ประกอบด้วย" | mkV "ยิงกระต่าย" | mkV "รวมกันเป็น" | mkV "รวมตัวเป็น" | mkV "รับหน้าที่" | mkV "สรรค์สร้าง" | mkV "สร้างสรรค์" | mkV "เด็ดดอกไม้" | mkV "ถ่ายปัสสาวะ" | mkV "ถ่ายอุจจาระ" | mkV "ประกอบอาหาร" | mkV "มุ่งหน้าสู่" | mkV "เตรียมอาหาร" | mkV "มาถึงทันเวลา" | mkV "ไปถึงทันเวลา" | mkV "ไปถึงเป้าหมาย" | mkV "ทำให้เชื่อมั่น" | mkV "เป็นสิ่งจำเป็นของ" | mkV "เปลี่ยนแปลงตัวเองเป็น" | mkV "กะ" | mkV "ทำ" | mkV "ถึง" | mkV "ทัน" | mkV "ทํา" | mkV "ผลิต" | mkV "แต่ง" | mkV "จัดหา" | mkV "มาถึง" | mkV "สร้าง" | mkV "หาได้" | mkV "เขียน" | mkV "ไปถึง" | mkV "จัดทํา" | mkV "ทําให้" | mkV "บังคับ" | mkV "ประมาณ" | mkV "เข้าใจ" | mkV "เตรียม" | mkV "กระตุ้น" | mkV "คาดคะเน" | mkV "จัดเวลา" | mkV "จัดแต่ง" | mkV "ทันเวลา" | mkV "ทําเงิน" | mkV "ประเมิน" | mkV "รวมเป็น" | mkV "เท่ากับ" | mkV "กลายเป็น" | mkV "ทํากําไร" | mkV "ทําเตียง" | mkV "ประพันธ์" | mkV "มีรายได้" | mkV "หารายได้" | mkV "แต่งตั้ง" | mkV "ก่อให้เกิด" | mkV "ทําให้เป็น" | mkV "สร้างกําไร" | mkV "สร้างรายได้" | mkV "เป็นเหตุให้" | mkV "จัดตารางเวลา" | mkV "บังคับให้ทํา" | mkV "มีจํานวนเป็น" | mkV "บรรลุเป้าหมาย" | mkV "เปลี่ยนสภาพเป็น" ; -- src=panlex
lin make_V = mkV "ทำ" | mkV "อึ" | mkV "ก่อ" | mkV "ขีด" | mkV "ขี้" | mkV "จัด" | mkV "ฉี่" | mkV "ถึง" | mkV "บวก" | mkV "ออก" | mkV "ได้" | mkV "ถ่าย" | mkV "ผลิต" | mkV "หลอก" | mkV "เป็น" | mkV "กระทำ" | mkV "คำนวน" | mkV "ทำท่า" | mkV "ทำให้" | mkV "มาถึง" | mkV "สร้าง" | mkV "ใช้ทำ" | mkV "ไปถึง" | mkV "ครีเอท" | mkV "ล่อลวง" | mkV "เยี่ยว" | mkV "ได้รับ" | mkV "ก่อขึ้น" | mkV "ขับถ่าย" | mkV "ถ่ายเบา" | mkV "ทำอาหาร" | mkV "ปัสสาวะ" | mkV "มีนิสัย" | mkV "อุจจาระ" | mkV "เปลี่ยน" | mkV "เปิดทาง" | mkV "ก่อสร้าง" | mkV "ถ่ายท้อง" | mkV "ถ่ายหนัก" | mkV "ทำเหมือน" | mkV "ปลดทุกข์" | mkV "มักกระทำ" | mkV "เหมาะกับ" | mkV "ถ่ายทุกข์" | mkV "ทำกับข้าว" | mkV "ทำให้พอใจ" | mkV "มาทันเวลา" | mkV "ก่อให้เกิด" | mkV "ประกอบด้วย" | mkV "ยิงกระต่าย" | mkV "รวมกันเป็น" | mkV "รวมตัวเป็น" | mkV "รับหน้าที่" | mkV "สรรค์สร้าง" | mkV "สร้างสรรค์" | mkV "เด็ดดอกไม้" | mkV "ถ่ายปัสสาวะ" | mkV "ถ่ายอุจจาระ" | mkV "ประกอบอาหาร" | mkV "มุ่งหน้าสู่" | mkV "เตรียมอาหาร" | mkV "มาถึงทันเวลา" | mkV "ไปถึงทันเวลา" | mkV "ไปถึงเป้าหมาย" | mkV "ทำให้เชื่อมั่น" | mkV "เป็นสิ่งจำเป็นของ" | mkV "เปลี่ยนแปลงตัวเองเป็น" | mkV "กะ" | mkV "ทำ" | mkV "ถึง" | mkV "ทัน" | mkV "ทํา" | mkV "ผลิต" | mkV "แต่ง" | mkV "จัดหา" | mkV "มาถึง" | mkV "สร้าง" | mkV "หาได้" | mkV "เขียน" | mkV "ไปถึง" | mkV "จัดทํา" | mkV "ทําให้" | mkV "บังคับ" | mkV "ประมาณ" | mkV "เข้าใจ" | mkV "เตรียม" | mkV "กระตุ้น" | mkV "คาดคะเน" | mkV "จัดเวลา" | mkV "จัดแต่ง" | mkV "ทันเวลา" | mkV "ทําเงิน" | mkV "ประเมิน" | mkV "รวมเป็น" | mkV "เท่ากับ" | mkV "กลายเป็น" | mkV "ทํากําไร" | mkV "ทําเตียง" | mkV "ประพันธ์" | mkV "มีรายได้" | mkV "หารายได้" | mkV "แต่งตั้ง" | mkV "ก่อให้เกิด" | mkV "ทําให้เป็น" | mkV "สร้างกําไร" | mkV "สร้างรายได้" | mkV "เป็นเหตุให้" | mkV "จัดตารางเวลา" | mkV "บังคับให้ทํา" | mkV "มีจํานวนเป็น" | mkV "บรรลุเป้าหมาย" | mkV "เปลี่ยนสภาพเป็น" ; -- src=panlex
lin as_Prep = mkPrep "ตาม" | mkPrep "เช่น" | mkPrep "ฉันใด" | mkPrep "อย่าง" | mkPrep "ดังที่" | mkPrep "ดุจดัง" | mkPrep "ตามที่" | mkPrep "เหมือน" | mkPrep "ในฐานะ" | mkPrep "ในบทบาท" | mkPrep "ในข้อนี้" | mkPrep "ในฐานะที่" | mkPrep "ดูประหนึ่ง" | mkPrep "ในตําแหน่ง" | mkPrep "เช่นเดียวกับ" ; -- src=panlex
lin out_Adv = mkAdv "ไป" | mkAdv "ออก" | mkAdv "ตก" | mkAdv "ขาด" | mkAdv "ผิด" | mkAdv "พ้น" | mkAdv "หมด" | mkAdv "ออก" | mkAdv "สลบไป" | mkAdv "ออกไป" | mkAdv "ภายนอก" | mkAdv "ออกหมด" | mkAdv "ข้างนอก" | mkAdv "พ้นสมัย" | mkAdv "หมดสิ้น" | mkAdv "ห่างไกลกัน" ; -- src=panlex
lin up_Adv = mkAdv "ตั้งตรง" | mkAdv "ในแนวขึ้น" | mkAdv "ในทิศทางขึ้น" ; -- src=panlex
lin see_VS = mmkVS "ชม" ; ---- | mkV "ดู" | mkV "พบ" | mkV "รู้" | mkV "ตรวจ" | mkV "ผ่าน" | mkV "เช็ก" | mkV "เห็น" | mkV "ไปพบ" | mkV "ไปหา" | mkV "นัดพบ" | mkV "ลงขัน" | mkV "จัดการ" | mkV "จับภาพ" | mkV "ตรวจดู" | mkV "ตีความ" | mkV "นึกภาพ" | mkV "มองออก" | mkV "รับรู้" | mkV "แลเห็น" | mkV "ค้นคว้า" | mkV "ตระหนัก" | mkV "เห็นภาพ" | mkV "ตรวจเช็ก" | mkV "ตัดสินใจ" | mkV "เยี่ยมชม" | mkV "เล็งเห็น" | mkV "ใช้สายตา" | mkV "ไปเป็นเพื่อน" | mkV "ผ่านประสบการณ์" | mkV "คบ" | mkV "ดู" | mkV "พบ" | mkV "แล" | mkV "คิด" | mkV "นึก" | mkV "มอง" | mkV "เจอ" | mkV "คบหา" | mkV "พบปะ" | mkV "เห็น" | mkV "ไปหา" | mkV "คบค้า" | mkV "ประสบ" | mkV "พบพาน" | mkV "เชื่อ" | mkV "ตรวจดู" | mkV "ติดตาม" | mkV "ติดต่อ" | mkV "ปรึกษา" | mkV "พูดคุย" | mkV "รับรู้" | mkV "วาดภาพ" | mkV "เข้าใจ" | mkV "เยี่ยม" | mkV "จ้องมอง" | mkV "ตรวจสอบ" | mkV "ตระหนัก" | mkV "พิจารณา" | mkV "มองเห็น" | mkV "เจอหน้า" | mkV "ไปสนทนา" | mkV "สัมภาษณ์" | mkV "เข้าไปพบ" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "คิดคํานึง" | mkV "จินตนาการ" | mkV "รู้ด้วยตา" | mkV "ไปมาหาสู่" | mkV "มีความเห็น" | mkV "เห็นด้วยตา" | mkV "ประจักษ์แจ้ง" | mkV "ตรวจให้มั่นใจ" | mkV "มีสัมพันธ์กับ" ; -- src=panlex
lin see_VQ = mmkVQ "ชม" ; ---- | mkV "ดู" | mkV "พบ" | mkV "รู้" | mkV "ตรวจ" | mkV "ผ่าน" | mkV "เช็ก" | mkV "เห็น" | mkV "ไปพบ" | mkV "ไปหา" | mkV "นัดพบ" | mkV "ลงขัน" | mkV "จัดการ" | mkV "จับภาพ" | mkV "ตรวจดู" | mkV "ตีความ" | mkV "นึกภาพ" | mkV "มองออก" | mkV "รับรู้" | mkV "แลเห็น" | mkV "ค้นคว้า" | mkV "ตระหนัก" | mkV "เห็นภาพ" | mkV "ตรวจเช็ก" | mkV "ตัดสินใจ" | mkV "เยี่ยมชม" | mkV "เล็งเห็น" | mkV "ใช้สายตา" | mkV "ไปเป็นเพื่อน" | mkV "ผ่านประสบการณ์" | mkV "คบ" | mkV "ดู" | mkV "พบ" | mkV "แล" | mkV "คิด" | mkV "นึก" | mkV "มอง" | mkV "เจอ" | mkV "คบหา" | mkV "พบปะ" | mkV "เห็น" | mkV "ไปหา" | mkV "คบค้า" | mkV "ประสบ" | mkV "พบพาน" | mkV "เชื่อ" | mkV "ตรวจดู" | mkV "ติดตาม" | mkV "ติดต่อ" | mkV "ปรึกษา" | mkV "พูดคุย" | mkV "รับรู้" | mkV "วาดภาพ" | mkV "เข้าใจ" | mkV "เยี่ยม" | mkV "จ้องมอง" | mkV "ตรวจสอบ" | mkV "ตระหนัก" | mkV "พิจารณา" | mkV "มองเห็น" | mkV "เจอหน้า" | mkV "ไปสนทนา" | mkV "สัมภาษณ์" | mkV "เข้าไปพบ" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "คิดคํานึง" | mkV "จินตนาการ" | mkV "รู้ด้วยตา" | mkV "ไปมาหาสู่" | mkV "มีความเห็น" | mkV "เห็นด้วยตา" | mkV "ประจักษ์แจ้ง" | mkV "ตรวจให้มั่นใจ" | mkV "มีสัมพันธ์กับ" ; -- src=panlex
lin see_V2V = mmkV2V "ชม" ; ---- | mkV "ดู" | mkV "พบ" | mkV "รู้" | mkV "ตรวจ" | mkV "ผ่าน" | mkV "เช็ก" | mkV "เห็น" | mkV "ไปพบ" | mkV "ไปหา" | mkV "นัดพบ" | mkV "ลงขัน" | mkV "จัดการ" | mkV "จับภาพ" | mkV "ตรวจดู" | mkV "ตีความ" | mkV "นึกภาพ" | mkV "มองออก" | mkV "รับรู้" | mkV "แลเห็น" | mkV "ค้นคว้า" | mkV "ตระหนัก" | mkV "เห็นภาพ" | mkV "ตรวจเช็ก" | mkV "ตัดสินใจ" | mkV "เยี่ยมชม" | mkV "เล็งเห็น" | mkV "ใช้สายตา" | mkV "ไปเป็นเพื่อน" | mkV "ผ่านประสบการณ์" | mkV "คบ" | mkV "ดู" | mkV "พบ" | mkV "แล" | mkV "คิด" | mkV "นึก" | mkV "มอง" | mkV "เจอ" | mkV "คบหา" | mkV "พบปะ" | mkV "เห็น" | mkV "ไปหา" | mkV "คบค้า" | mkV "ประสบ" | mkV "พบพาน" | mkV "เชื่อ" | mkV "ตรวจดู" | mkV "ติดตาม" | mkV "ติดต่อ" | mkV "ปรึกษา" | mkV "พูดคุย" | mkV "รับรู้" | mkV "วาดภาพ" | mkV "เข้าใจ" | mkV "เยี่ยม" | mkV "จ้องมอง" | mkV "ตรวจสอบ" | mkV "ตระหนัก" | mkV "พิจารณา" | mkV "มองเห็น" | mkV "เจอหน้า" | mkV "ไปสนทนา" | mkV "สัมภาษณ์" | mkV "เข้าไปพบ" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "คิดคํานึง" | mkV "จินตนาการ" | mkV "รู้ด้วยตา" | mkV "ไปมาหาสู่" | mkV "มีความเห็น" | mkV "เห็นด้วยตา" | mkV "ประจักษ์แจ้ง" | mkV "ตรวจให้มั่นใจ" | mkV "มีสัมพันธ์กับ" ; -- src=panlex
lin see_V2 = mkV2 (thword "เห็น") ;
lin see_V = mkV "ชม" | mkV "ดู" | mkV "พบ" | mkV "รู้" | mkV "ตรวจ" | mkV "ผ่าน" | mkV "เช็ก" | mkV "เห็น" | mkV "ไปพบ" | mkV "ไปหา" | mkV "นัดพบ" | mkV "ลงขัน" | mkV "จัดการ" | mkV "จับภาพ" | mkV "ตรวจดู" | mkV "ตีความ" | mkV "นึกภาพ" | mkV "มองออก" | mkV "รับรู้" | mkV "แลเห็น" | mkV "ค้นคว้า" | mkV "ตระหนัก" | mkV "เห็นภาพ" | mkV "ตรวจเช็ก" | mkV "ตัดสินใจ" | mkV "เยี่ยมชม" | mkV "เล็งเห็น" | mkV "ใช้สายตา" | mkV "ไปเป็นเพื่อน" | mkV "ผ่านประสบการณ์" | mkV "คบ" | mkV "ดู" | mkV "พบ" | mkV "แล" | mkV "คิด" | mkV "นึก" | mkV "มอง" | mkV "เจอ" | mkV "คบหา" | mkV "พบปะ" | mkV "เห็น" | mkV "ไปหา" | mkV "คบค้า" | mkV "ประสบ" | mkV "พบพาน" | mkV "เชื่อ" | mkV "ตรวจดู" | mkV "ติดตาม" | mkV "ติดต่อ" | mkV "ปรึกษา" | mkV "พูดคุย" | mkV "รับรู้" | mkV "วาดภาพ" | mkV "เข้าใจ" | mkV "เยี่ยม" | mkV "จ้องมอง" | mkV "ตรวจสอบ" | mkV "ตระหนัก" | mkV "พิจารณา" | mkV "มองเห็น" | mkV "เจอหน้า" | mkV "ไปสนทนา" | mkV "สัมภาษณ์" | mkV "เข้าไปพบ" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "คิดคํานึง" | mkV "จินตนาการ" | mkV "รู้ด้วยตา" | mkV "ไปมาหาสู่" | mkV "มีความเห็น" | mkV "เห็นด้วยตา" | mkV "ประจักษ์แจ้ง" | mkV "ตรวจให้มั่นใจ" | mkV "มีสัมพันธ์กับ" ; -- src=panlex
lin know_VS = lin VS (regV "รู้") ;
lin know_VQ = lin VQ (regV "รู้") ;
lin know_V2 = mkV2 "รู้" ; ----?
lin know_V = mkV "นอน" | mkV "ปี้" | mkV "รู้" | mkV "ล่อ" | mkV "เอา" | mkV "เย็ด" | mkV "ตีหม้อ" | mkV "รู้ถึง" | mkV "เข้าใจ" | mkV "เสพกาม" | mkV "ร่วมรัก" | mkV "ร่วมสุข" | mkV "ร่วมเพศ" | mkV "หลับนอน" | mkV "มีเซ็กส์" | mkV "เสพเมถุน" | mkV "รับรู้เอง" | mkV "ร่วมประเวณี" | mkV "มีเพศสัมพันธ์" | mkV "รู้" | mkV "ทราบ" | mkV "ดูออก" | mkV "รู้ดี" | mkV "จําได้" | mkV "มองออก" | mkV "รับรู้" | mkV "รู้จัก" | mkV "เข้าใจ" | mkV "คุ้นเคย" | mkV "ตระหนัก" | mkV "รับทราบ" | mkV "ประจักษ์" | mkV "เรียนรู้" | mkV "รู้เรื่อง" | mkV "มีประสบการณ์" ; -- src=panlex
lin time_N = variants{} ; -- 
lin time_2_N = variants{} ; -- 
lin time_1_N = variants{} ; -- 
lin take_V2 = variants{} ; -- 
lin so_Adv = mkAdv "แล้วก็" | mkAdv "ดังนั้น" | mkAdv "หลังจากนั้น" | mkAdv "ถ้า" | mkAdv "มาก" | mkAdv "ราว ๆ นั้น" | mkAdv "ด้วย" | mkAdv "จริง ๆ" | mkAdv "ในราว" | mkAdv "ฉะนั้น" | mkAdv "ฉันนั้น" | mkAdv "ดังนั้น" | mkAdv "มากยิ่ง" | mkAdv "เช่นกัน" | mkAdv "เช่นนี้" | mkAdv "เต็มที่" | mkAdv "เมินเฉย" | mkAdv "จนถึงกับ" | mkAdv "เช่นนั้น" | mkAdv "เพียงแต่" | mkAdv "จนกระทั่ง" | mkAdv "อย่างนั้น" | mkAdv "อย่างยิ่ง" | mkAdv "เหตุฉะนี้" | mkAdv "โดยแน่แท้" | mkAdv "เหตุฉะนั้น" | mkAdv "ด้วยเหตุนี้" | mkAdv "ถ้าเช่นนั้น" | mkAdv "เพราะเหตุนี้" | mkAdv "โดยมีเงื่อนไขว่า" ; -- src=panlex
lin year_N = mkN (thword "ปี") | {-pan-} mkN "ปี" | mkN "ขวบ" | mkN "ชั้น" | mkN "พรรษา" | mkN "12 เดือน" | mkN "ปี" | mkN "ขวบ" | mkN "อายุ" | mkN "รอบปี" | mkN "ปีงบประมาณ" | mkN "ระยะเวลาหนึ่งปี" | mkN "ระยะเวลาของกิจกรรมในหนึ่งปีเช่น ปีการศึกษา" | mkN "เวลาที่โลกหมุนรอบดวงอาทิตย์ 365.5 วัน" ; -- src=panlex
lin into_Prep = mkPrep "ไปยัง" | mkPrep "เข้าไป" | mkPrep "กลายเป็น" | mkPrep "ตรงไปที่" | mkPrep "ตรงไปยัง" | mkPrep "เข้าไปใน" | mkPrep "เกี่ยวกับ" | mkPrep "เข้ามาข้างใน" | mkPrep "เข้าไปข้างใน" ; -- src=panlex
lin then_Adv = mkAdv "แล้วก็" | mkAdv "หลังจากนั้น" | mkAdv "ถ้าอย่างนั้น" | mkAdv "แล้ว" | mkAdv "ฉะนั้น" | mkAdv "จากนั้น" | mkAdv "ดังนั้น" | mkAdv "นอกจากนี้" | mkAdv "ในขณะนั้น" | mkAdv "ต่อจากนั้น" | mkAdv "นอกจากนั้น" | mkAdv "ในกรณีนั้น" | mkAdv "ในเวลานั้น" | mkAdv "ถ้าเช่นนั้น" | mkAdv "ยิ่งกว่านี้" | mkAdv "หลังจากนั้น" | mkAdv "เพราะฉะนั้น" | mkAdv "อีกประการหนึ่ง" | mkAdv "ถ้าเป็นเช่นนั้น" | mkAdv "โดยเฉพาะอย่างยิ่ง" ; -- src=panlex
lin think_VS = mmkVS (thword "คิด") ; ---- | {-pan-} mkV "จำ" | mkV "คาด" | mkV "คิด" | mkV "คิดว่า" | mkV "ตั้งใจ" | mkV "นึกออก" | mkV "ใช้หัว" | mkV "เห็นว่า" | mkV "ใช้สมอง" | mkV "ครุ่นคิด" | mkV "เชื่อว่า" | mkV "ใช้ความคิด" | mkV "ตั้งความคิด" | mkV "คิด" | mkV "เห็น" | mkV "เลือก" | mkV "คาดเดา" | mkV "คิดได้" | mkV "ตั้งใจ" | mkV "นึกออก" | mkV "เข้าใจ" | mkV "คาดหมาย" | mkV "คิดอ่าน" | mkV "ครุ่นคิด" | mkV "คาดการณ์" | mkV "มุ่งหมาย" | mkV "คิดเชื่อมโยง" | mkV "นึกขึ้นมาได้" | mkV "มีความคิดเห็น" | mkV "คาดคะเนล่วงหน้า" | mkV "มุ่งความสนใจไปยัง" ; -- src=panlex
lin think_V2 = mkV2 (thword "คิด") ; ---- | {-pan-} mkV "จำ" | mkV "คาด" | mkV "คิด" | mkV "คิดว่า" | mkV "ตั้งใจ" | mkV "นึกออก" | mkV "ใช้หัว" | mkV "เห็นว่า" | mkV "ใช้สมอง" | mkV "ครุ่นคิด" | mkV "เชื่อว่า" | mkV "ใช้ความคิด" | mkV "ตั้งความคิด" | mkV "คิด" | mkV "เห็น" | mkV "เลือก" | mkV "คาดเดา" | mkV "คิดได้" | mkV "ตั้งใจ" | mkV "นึกออก" | mkV "เข้าใจ" | mkV "คาดหมาย" | mkV "คิดอ่าน" | mkV "ครุ่นคิด" | mkV "คาดการณ์" | mkV "มุ่งหมาย" | mkV "คิดเชื่อมโยง" | mkV "นึกขึ้นมาได้" | mkV "มีความคิดเห็น" | mkV "คาดคะเนล่วงหน้า" | mkV "มุ่งความสนใจไปยัง" ; -- src=panlex
lin think_V = mkV (thword "คิด") | {-pan-} mkV "จำ" | mkV "คาด" | mkV "คิด" | mkV "คิดว่า" | mkV "ตั้งใจ" | mkV "นึกออก" | mkV "ใช้หัว" | mkV "เห็นว่า" | mkV "ใช้สมอง" | mkV "ครุ่นคิด" | mkV "เชื่อว่า" | mkV "ใช้ความคิด" | mkV "ตั้งความคิด" | mkV "คิด" | mkV "เห็น" | mkV "เลือก" | mkV "คาดเดา" | mkV "คิดได้" | mkV "ตั้งใจ" | mkV "นึกออก" | mkV "เข้าใจ" | mkV "คาดหมาย" | mkV "คิดอ่าน" | mkV "ครุ่นคิด" | mkV "คาดการณ์" | mkV "มุ่งหมาย" | mkV "คิดเชื่อมโยง" | mkV "นึกขึ้นมาได้" | mkV "มีความคิดเห็น" | mkV "คาดคะเนล่วงหน้า" | mkV "มุ่งความสนใจไปยัง" ; -- src=panlex
lin come_V = mkV (thword "มา") | {-pan-} mkV "มา" | mkV "ถึง" | mkV "รวม" | mkV "แวบ" | mkV "พัฒนา" | mkV "มาจาก" | mkV "มาถึง" | mkV "ออกมา" | mkV "เสร็จ" | mkV "คิดเป็น" | mkV "มีผลรวม" | mkV "เข้าสู่" | mkV "เกิดขึ้น" | mkV "ถัดมาเป็น" | mkV "ต้องมาก่อน" | mkV "อยู่ภายใต้" | mkV "ดำเนินต่อไป" | mkV "สืบเชื้อสาย" | mkV "ถึงจุดสุดยอด" | mkV "เป็นชาวพื้นเมือง" | mkV "มา" | mkV "เป็น" | mkV "ปรากฏ" | mkV "มาถึง" | mkV "มาแล้ว" | mkV "เกิดใน" | mkV "กลายเป็น" | mkV "เกิดขึ้น" ; -- src=panlex
lin than_Subj = variants{} ; -- 
lin more_Adv = mkAdv "กว่า" | mkAdv "นานกว่า" | mkAdv "นานขึ้น" | mkAdv "มากกว่า" | mkAdv "บ่อยขึ้น" ; -- src=panlex
lin about_Prep = mkPrep "รอบ" | mkPrep "ราว" | mkPrep "ราวๆ" | mkPrep "ทั่วๆ" | mkPrep "ประมาณ" | mkPrep "ใกล้กับ" | mkPrep "เกี่ยวกับ" | mkPrep "ในที่ต่างๆ" ; -- src=panlex
lin now_Adv = mkAdv (thword "เดี๋ยว" "นี้") | {-pan-} mkAdv "ทันที" | mkAdv "ตอนนี้" | mkAdv "ในทันที" | mkAdv "ปัจจุบัน" | mkAdv "เดี๋ยวนี้" | mkAdv "ทันทีทันใด" | mkAdv "เดี๋ยวก่อน" | mkAdv "ขณะนี้" | mkAdv "ตอนนี้" | mkAdv "บัดนี้" | mkAdv "ในขณะนี้" | mkAdv "เดี๋ยวนี้" | mkAdv "ปัจจุบันนี้" ; -- src=panlex
lin last_A = variants{} ; -- 
lin last_1_A = variants{} ; -- 
lin last_2_A = variants{} ; -- 
lin other_A = mkA "อื่น" | {-pan-} mkA "ก่อน" | mkA "อีก" | mkA "อื่นๆ" | mkA "มากกว่า" | mkA "อะไรอีก" | mkA "อันก่อน" | mkA "อื่นอีก" | mkA "ต่างไปกว่า" | mkA "แตกต่างกัน" | mkA "จํานวนพิเศษ" | mkA "ไม่เหมือนกัน" | mkA "เมื่อวานซืนนี้)" ; -- src=panlex
lin give_V3 = mkV3 "ให้" ;
lin give_V2 = mkV2 "ชน" ; ---- | mkV "จัด" | mkV "บอก" | mkV "ฝาก" | mkV "มอบ" | mkV "ยอม" | mkV "ส่ง" | mkV "ให้" | mkV "ถล่ม" | mkV "ทรุด" | mkV "ทลาย" | mkV "ทิ้ง" | mkV "ยื่น" | mkV "แสดง" | mkV "ทำให้" | mkV "ลงโทษ" | mkV "อุทิศ" | mkV "แนะนำ" | mkV "ชนแก้ว" | mkV "พลีกาย" | mkV "มอบกาย" | mkV "มอบให้" | mkV "ยุบตัว" | mkV "ให้ทาง" | mkV "ทำเสียง" | mkV "นำไปแลก" | mkV "พังทลาย" | mkV "หลีกทาง" | mkV "เปิดทาง" | mkV "ยืดหยุ่น" | mkV "ส่งผลให้" | mkV "ส่งไปแลก" | mkV "เกิดขึ้น" | mkV "ให้อาหาร" | mkV "ทำให้เกิด" | mkV "อนุญาตให้" | mkV "เข้าไปยัง" | mkV "ให้ผลผลิต" | mkV "ให้สัญญาณ" | mkV "มอบของขวัญ" | mkV "ให้ของขวัญ" | mkV "เป็นต้นเหตุ" | mkV "ให้คำตัดสิน" | mkV "มอบเรือนร่าง" | mkV "จัดการแก้ปัญหา" | mkV "สามารถเข้าไปยัง" | mkV "ให้ด้วยความศรัทธา" | mkV "ให้" | mkV "แสดง" | mkV "มอบให้" | mkV "ส่งให้" | mkV "ยอมยกให้" ; -- src=panlex
lin give_V = mkV "ชน" | mkV "จัด" | mkV "บอก" | mkV "ฝาก" | mkV "มอบ" | mkV "ยอม" | mkV "ส่ง" | mkV "ให้" | mkV "ถล่ม" | mkV "ทรุด" | mkV "ทลาย" | mkV "ทิ้ง" | mkV "ยื่น" | mkV "แสดง" | mkV "ทำให้" | mkV "ลงโทษ" | mkV "อุทิศ" | mkV "แนะนำ" | mkV "ชนแก้ว" | mkV "พลีกาย" | mkV "มอบกาย" | mkV "มอบให้" | mkV "ยุบตัว" | mkV "ให้ทาง" | mkV "ทำเสียง" | mkV "นำไปแลก" | mkV "พังทลาย" | mkV "หลีกทาง" | mkV "เปิดทาง" | mkV "ยืดหยุ่น" | mkV "ส่งผลให้" | mkV "ส่งไปแลก" | mkV "เกิดขึ้น" | mkV "ให้อาหาร" | mkV "ทำให้เกิด" | mkV "อนุญาตให้" | mkV "เข้าไปยัง" | mkV "ให้ผลผลิต" | mkV "ให้สัญญาณ" | mkV "มอบของขวัญ" | mkV "ให้ของขวัญ" | mkV "เป็นต้นเหตุ" | mkV "ให้คำตัดสิน" | mkV "มอบเรือนร่าง" | mkV "จัดการแก้ปัญหา" | mkV "สามารถเข้าไปยัง" | mkV "ให้ด้วยความศรัทธา" | mkV "ให้" | mkV "แสดง" | mkV "มอบให้" | mkV "ส่งให้" | mkV "ยอมยกให้" ; -- src=panlex
lin just_Adv = mkAdv "เพิ่ง" | mkAdv "เพียง" | mkAdv "เท่านั้น" | mkAdv "เพียงแค่" | mkAdv "แทบจะไม่" | mkAdv "อย่างแน่นอน" | mkAdv "แค่" | mkAdv "พอดี" | mkAdv "เพิ่ง" | mkAdv "เพียง" | mkAdv "ขณะนี้" | mkAdv "ตอนนี้" | mkAdv "ทีเดียว" | mkAdv "เพิ่งจะ" | mkAdv "เพียงแค่" | mkAdv "เดี๋ยวนี้" | mkAdv "เมื่อกี้นี้" | mkAdv "เมื่อครู่นี้" | mkAdv "อย่างจวนเจียน" | mkAdv "อย่างหวุดหวิด" | mkAdv "อย่างเฉียดฉิว" | mkAdv "เมื่อสักครู่นี้" ; -- src=panlex
lin people_N = mkN "ปชช." | mkN "ปวงชน" | mkN "ผู้คน" | mkN "มวลชน" | mkN "มหาชน" | mkN "กลุ่มคน" | mkN "คนสามัญ" | mkN "ประชาชน" | mkN "ประชาชี" | mkN "พลเมือง" | mkN "พี่น้อง" | mkN "สามัญชน" | mkN "คนทั่วไป" | mkN "ญาติพี่น้อง" | mkN "กลุ่มพลเมือง" | mkN "คนธรรมดาทั่วไป" | mkN "คน" | mkN "ราษฎร" | mkN "มนุษย์" | mkN "ประชากร" | mkN "ประชาชน" | mkN "พลเมือง" | mkN "คนในปกครอง" | mkN "คนในครอบครัว" | mkN "สมาชิกในครอบครัว" ; -- src=panlex
lin also_Adv = mkAdv "เช่นกัน" | mkAdv "ด้วย" | mkAdv "อีกด้วย" | mkAdv "เช่นกัน" | mkAdv "โดยเฉพาะ" | mkAdv "เหมือนกัน" | mkAdv "ยิ่งกว่านั้น" | mkAdv "เช่นเดียวกัน" | mkAdv "ยิ่งไปกว่านั้น" ; -- src=panlex
lin well_Adv = variants{} ; -- 
lin only_Adv = mkAdv "เพียง" | mkAdv "หากว่า" | mkAdv "สุดท้าย" | mkAdv "เท่านั้น" | mkAdv "เพียงแค่" | mkAdv "โดยลำพัง" | mkAdv "แต่สุดท้ายก็" | mkAdv "เพิ่งจะ" | mkAdv "เท่านั้น" | mkAdv "เพียงแค่" | mkAdv "เพียงแต่" | mkAdv "เพียงแต่ ... เท่านั้น" | mkAdv "ยกเว้นว่า" | mkAdv "ไม่มากไม่น้อยไปกว่านี้" | mkAdv "ที่เกิดขึ้นเมื่อเร็วๆนี้" ; -- src=panlex
lin new_A = mkA (thword "ใหม่") | {-pan-} mkA "อ่อน" | mkA "ใหม่" | mkA "มือใหม่" | mkA "ซึ่งไม่เคยเกิดขึ้นมาก่อน" | mkA "ใหม่" | mkA "แบบใหม่" | mkA "ร่วมสมัย" ; -- src=panlex
lin when_Subj = ss "ที" ;
lin way_N = variants{} ; -- 
lin way_2_N = variants{} ; -- 
lin way_1_N = variants{} ; -- 
lin look_VA = mmkVA "ดู" ; ---- | mkV "หา" | mkV "คอย" | mkV "ค้นหา" | mkV "มองหา" | mkV "รอคอย" | mkV "จัดการ" | mkV "พึ่งพา" | mkV "เสาะหา" | mkV "ดูเหมือนว่า" | mkV "หันหน้าไปทาง" | mkV "ดู" | mkV "แล" | mkV "มอง" | mkV "เพ่ง" | mkV "ค้นหา" | mkV "ปรากฏ" | mkV "มองดู" | mkV "มองหา" | mkV "ตัดสิน" | mkV "พิจารณา" | mkV "แสดงออก" | mkV "ดูเหมือน" | mkV "มีท่าทาง" | mkV "เอาใจใส่" | mkV "มีแนวโน้ม" | mkV "เผชิญหน้า" | mkV "โน้มเอียง" | mkV "แสดงท่าทาง" | mkV "ดูราวกับว่า" | mkV "ให้ความสนใจ" ; -- src=panlex
lin look_V2 = mkV2 "ดู" ; ---- | mkV "หา" | mkV "คอย" | mkV "ค้นหา" | mkV "มองหา" | mkV "รอคอย" | mkV "จัดการ" | mkV "พึ่งพา" | mkV "เสาะหา" | mkV "ดูเหมือนว่า" | mkV "หันหน้าไปทาง" | mkV "ดู" | mkV "แล" | mkV "มอง" | mkV "เพ่ง" | mkV "ค้นหา" | mkV "ปรากฏ" | mkV "มองดู" | mkV "มองหา" | mkV "ตัดสิน" | mkV "พิจารณา" | mkV "แสดงออก" | mkV "ดูเหมือน" | mkV "มีท่าทาง" | mkV "เอาใจใส่" | mkV "มีแนวโน้ม" | mkV "เผชิญหน้า" | mkV "โน้มเอียง" | mkV "แสดงท่าทาง" | mkV "ดูราวกับว่า" | mkV "ให้ความสนใจ" ; -- src=panlex
lin look_V = mkV "ดู" | mkV "หา" | mkV "คอย" | mkV "ค้นหา" | mkV "มองหา" | mkV "รอคอย" | mkV "จัดการ" | mkV "พึ่งพา" | mkV "เสาะหา" | mkV "ดูเหมือนว่า" | mkV "หันหน้าไปทาง" | mkV "ดู" | mkV "แล" | mkV "มอง" | mkV "เพ่ง" | mkV "ค้นหา" | mkV "ปรากฏ" | mkV "มองดู" | mkV "มองหา" | mkV "ตัดสิน" | mkV "พิจารณา" | mkV "แสดงออก" | mkV "ดูเหมือน" | mkV "มีท่าทาง" | mkV "เอาใจใส่" | mkV "มีแนวโน้ม" | mkV "เผชิญหน้า" | mkV "โน้มเอียง" | mkV "แสดงท่าทาง" | mkV "ดูราวกับว่า" | mkV "ให้ความสนใจ" ; -- src=panlex
lin like_Prep = mkPrep "เช่น" | mkPrep "ดังเช่น" | mkPrep "เหมือนกับ" | mkPrep "คล้ายกันกับ" | mkPrep "ลักษณะพิเศษ" | mkPrep "ตัวอย่างเช่น" | mkPrep "เหมือนกันกับ" | mkPrep "เป็นลักษณะเฉพาะ" ; -- src=panlex
lin use_VV = mkVV "เคย" ; ---- | mkV "ใช้" | mkV "ใช้อย่างเต็มที่" | mkV "ใช้เป็นเครื่องมือ" | mkV "ใช้" | mkV "หลอกใช้" | mkV "แสดงออก" | mkV "ปฏิบัติต่อ" | mkV "ใช้ประโยชน์" | mkV "ใช้เป็นประจํา" | mkV "ได้ประโยชน์จาก" | mkV "ทําให้เป็นประโยชน์" | mkV "ใช้ในทางไม่เหมาะสม" ; -- src=panlex
lin use_V2 = mkV2 "เคย" ; ---- | mkV "ใช้" | mkV "ใช้อย่างเต็มที่" | mkV "ใช้เป็นเครื่องมือ" | mkV "ใช้" | mkV "หลอกใช้" | mkV "แสดงออก" | mkV "ปฏิบัติต่อ" | mkV "ใช้ประโยชน์" | mkV "ใช้เป็นประจํา" | mkV "ได้ประโยชน์จาก" | mkV "ทําให้เป็นประโยชน์" | mkV "ใช้ในทางไม่เหมาะสม" ; -- src=panlex
lin use_V = mkV "เคย" | mkV "ใช้" | mkV "ใช้อย่างเต็มที่" | mkV "ใช้เป็นเครื่องมือ" | mkV "ใช้" | mkV "หลอกใช้" | mkV "แสดงออก" | mkV "ปฏิบัติต่อ" | mkV "ใช้ประโยชน์" | mkV "ใช้เป็นประจํา" | mkV "ได้ประโยชน์จาก" | mkV "ทําให้เป็นประโยชน์" | mkV "ใช้ในทางไม่เหมาะสม" ; -- src=panlex
lin because_Subj = ss (thword "เพ" "ราะ") ;
lin good_A = mkA "ดี" | {-pan-} mkA "แท้" | mkA "จริง" | mkA "ที่ดี" | mkA "ช่ำชอง" | mkA "เชี่ยวชาญ" | mkA "ที่มีสภาพดี" | mkA "ซึ่งไม่มีความเสี่ยง" | mkA "มาก" | mkA "ฉลาด" | mkA "เก่ง" | mkA "ใจดี" | mkA "ถูกต้อง" | mkA "น่าพอใจ" | mkA "เต็มที่" | mkA "เหมาะสม" | mkA "มีน้ําใจ" | mkA "ไว้ใจได้" | mkA "ความกรุณา" | mkA "มีเกียรติ" | mkA "ความดีเลิศ" | mkA "ซึ่งชํานาญ" | mkA "ผลประโยชน์" | mkA "น่าเชื่อถือ" | mkA "มีชื่อเสียง" | mkA "มีความสามารถ" | mkA "ซึ่งเชี่ยวชาญ" ; -- src=panlex
lin find_VS = mmkVS "พบ" ; ---- | mkV "หา" | mkV "ค้นพบ" | mkV "กอบกู้" | mkV "รับรู้" | mkV "รู้สึก" | mkV "ได้รับ" | mkV "ค้นหาตัวเอง" | mkV "ปะ" | mkV "พบ" | mkV "หา" | mkV "เจอ" | mkV "พบปะ" | mkV "เห็น" | mkV "ค้นพบ" | mkV "ค้นหา" | mkV "ตามหา" | mkV "ประสบ" | mkV "สํานึก" | mkV "ดํารงอยู่" | mkV "สัมผัสรู้" | mkV "ลงความเห็น" | mkV "ตัดสินชี้ขาด" ; -- src=panlex
lin find_V2A = mmkV2A "พบ" ; ---- | mkV "หา" | mkV "ค้นพบ" | mkV "กอบกู้" | mkV "รับรู้" | mkV "รู้สึก" | mkV "ได้รับ" | mkV "ค้นหาตัวเอง" | mkV "ปะ" | mkV "พบ" | mkV "หา" | mkV "เจอ" | mkV "พบปะ" | mkV "เห็น" | mkV "ค้นพบ" | mkV "ค้นหา" | mkV "ตามหา" | mkV "ประสบ" | mkV "สํานึก" | mkV "ดํารงอยู่" | mkV "สัมผัสรู้" | mkV "ลงความเห็น" | mkV "ตัดสินชี้ขาด" ; -- src=panlex
lin find_V2 = mkV2 "หา" ;
lin find_V = mkV "พบ" | mkV "หา" | mkV "ค้นพบ" | mkV "กอบกู้" | mkV "รับรู้" | mkV "รู้สึก" | mkV "ได้รับ" | mkV "ค้นหาตัวเอง" | mkV "ปะ" | mkV "พบ" | mkV "หา" | mkV "เจอ" | mkV "พบปะ" | mkV "เห็น" | mkV "ค้นพบ" | mkV "ค้นหา" | mkV "ตามหา" | mkV "ประสบ" | mkV "สํานึก" | mkV "ดํารงอยู่" | mkV "สัมผัสรู้" | mkV "ลงความเห็น" | mkV "ตัดสินชี้ขาด" ; -- src=panlex
lin man_N = personN (thword "ชาย") | {-pan-} mkN "คน" | mkN "ชาย" | mkN "ทหาร" | mkN "บุรุษ" | mkN "ผู้ชาย" | mkN "มนุษย์" | mkN "ตัวหมาก" | mkN "ทหารชาย" | mkN "ชายชาตรี" | mkN "มนุษยชาติ" | mkN "ลูกผู้ชาย" | mkN "ลูกน้องผู้ชาย" | mkN "ทหารกองประจำการ" | mkN "ทหารประจำกองทัพ" | mkN "คน" | mkN "ชาย" | mkN "ผัว" | mkN "ผู้" | mkN "สามี" | mkN "คนเรา" | mkN "บุคคล" | mkN "บุรุษ" | mkN "ผู้ชาย" | mkN "มนุษย์" | mkN "เพศชาย" | mkN "ทหารชาย" | mkN "คนงานชาย" | mkN "คนผู้ชาย" | mkN "ชายคนรัก" | mkN "คู่นอนชาย" | mkN "มนุษยชาติ" | mkN "ตัวหมากรุก" | mkN "ลูกจ้างชาย" | mkN "สุภาพบุรุษ" | mkN "คนรับใช้ชาย" | mkN "คนใช้ผู้ชาย" | mkN "คนงานที่เป็นผู้ชาย" | mkN "ลูกน้องที่เป็นผู้ชาย" | mkN "คําเรียกผู้หญิงหรือผู้ชาย" ; -- src=panlex
lin want_VV = {s = yaak_s ; typ = VVMid} ;
lin want_V2V = mmkV2V "อยาก" ; ---- | mkV "จำเป็น" | mkV "ต้องการ" | mkV "ประสงค์" | mkV "ปรารถนา" | mkV "ต้องการพบ" | mkV "อยาก" | mkV "ใคร่" | mkV "ขาดไป" | mkV "ต้องการ" | mkV "ปรารถนา" | mkV "อยากได้" | mkV "ปรารถนาที่จะได้" | mkV "ต้องการมีความสัมพันธ์ทางเพศกับ" ; -- src=panlex
lin want_V2 = mkV2 "อยาก" ; ---- | mkV "จำเป็น" | mkV "ต้องการ" | mkV "ประสงค์" | mkV "ปรารถนา" | mkV "ต้องการพบ" | mkV "อยาก" | mkV "ใคร่" | mkV "ขาดไป" | mkV "ต้องการ" | mkV "ปรารถนา" | mkV "อยากได้" | mkV "ปรารถนาที่จะได้" | mkV "ต้องการมีความสัมพันธ์ทางเพศกับ" ; -- src=panlex
lin want_V = mkV "อยาก" | mkV "จำเป็น" | mkV "ต้องการ" | mkV "ประสงค์" | mkV "ปรารถนา" | mkV "ต้องการพบ" | mkV "อยาก" | mkV "ใคร่" | mkV "ขาดไป" | mkV "ต้องการ" | mkV "ปรารถนา" | mkV "อยากได้" | mkV "ปรารถนาที่จะได้" | mkV "ต้องการมีความสัมพันธ์ทางเพศกับ" ; -- src=panlex
lin day_N = mkN (thword "กลาง" "วัน") | {-pan-} mkN "ยุค" | mkN "วัน" | mkN "กลางวัน" | mkN "ช่วงวัน" | mkN "ยี่สิบสี่ชั่วโมง" | mkN "ระยะเวลาหนึ่งวัน" | mkN "24 ชั่วโมง" | mkN "วัน" | mkN "สมัย" | mkN "เวลา" | mkN "กลางวัน" | mkN "ช่วงเวลา" | mkN "เวลากลางวัน" | mkN "เวลาหนึ่งวัน" | mkN "24 ชั่วโมง" ; -- src=panlex
lin between_Prep = ss (thword "ระ" "หว่าง") | {-pan-} mkPrep "ระคน" | mkPrep "เชื่อม" | mkPrep "ระหว่าง" | mkPrep "คั่นกลาง" | mkPrep "อยู่กลาง" | mkPrep "ในระหว่าง" | mkPrep "ระหว่างระยะ" | mkPrep "สัมพันธ์กับ" | mkPrep "สิ่งที่รวมกัน" | mkPrep "อยู่ในระหว่าง" | mkPrep "อยู่ระหว่างสิ่งสองสิ่ง" | mkPrep "กําหนดตัวเลือกระหว่างสิ่งสองสิ่ง" | mkPrep "เปรียบเทียบระหว่างสิ่งหนึ่งกับอีกสิ่งหนึ่ง" ; -- src=panlex
lin even_Adv = mkAdv "ยังคง" | mkAdv "แม้แต่" | mkAdv "แม้กระทั่ง" | mkAdv "ยิ่งไปกว่านั้น" ; -- src=panlex
lin there_Adv = ss (thword "ที่" "นั่น") | {-pan-} mkAdv "ที่นั่น" | mkAdv "ในเรื่องนั้น" | mkAdv "ไปยังที่นั่น" | mkAdv "ตรงนั้น" | mkAdv "ที่นั่น" | mkAdv "ที่โน่น" | mkAdv "ด้านนั้น" | mkAdv "สภาพนั้น" | mkAdv "ในข้อนั้น" | mkAdv "ในจุดนั้น" | mkAdv "สถานที่นั้น" | mkAdv "เงื่อนไขนั้น" | mkAdv "ในผลสําเร็จนั้น" | mkAdv "เกี่ยวกับข้อนั้น" | mkAdv "เกี่ยวกับเรื่องนั้น" ; -- src=panlex
lin many_Det = quantDet "หลาย" ; ---- | {-pan-} mkDet "มาก" | mkDet "หลาย" | mkDet "มากมาย" | mkDet "เยอะแยะ" | mkDet "เป็นจํานวนมาก" ; -- src=panlex
lin after_Prep = ss (thword "หลัง" "จาก") | {-pan-} mkPrep "หลัง" | mkPrep "ตามหา" | mkPrep "ต่อมา" | mkPrep "ติดตาม" | mkPrep "ทีหลัง" | mkPrep "แสวงหา" | mkPrep "ภายหลัง" | mkPrep "หลังจาก" | mkPrep "ข้างหลัง" | mkPrep "เอาอย่าง" | mkPrep "ภายหลังที่" | mkPrep "หลังจากที่" ; -- src=panlex
lin down_Adv = mkAdv "ลดต่ำลง" | mkAdv "ลดลง" | mkAdv "ลงใต้" | mkAdv "ต่ําลง" | mkAdv "น้อยลง" | mkAdv "ข้างล่าง" | mkAdv "ด้านล่าง" | mkAdv "ไปทางใต้" | mkAdv "ลงข้างล่าง" ; -- src=panlex
lin yeah_Interj = variants{} ; -- 
lin so_Subj = variants{} ; -- 
lin thing_N = mkN "ของ" | mkN "สิ่ง" | mkN "เรื่อง" | mkN "เรื่องอื้อฉาว" | mkN "ของ" | mkN "กรณี" | mkN "ธุระ" | mkN "ภาระ" | mkN "วัตถุ" | mkN "การงาน" | mkN "ข้อความ" | mkN "ความคิด" | mkN "สิ่งของ" | mkN "หน้าที่" | mkN "สรรพสิ่ง" | mkN "เป้าหมาย" | mkN "การกระทํา" | mkN "เรื่องราว" | mkN "เหตุการณ์" | mkN "จุดประสงค์" | mkN "รายละเอียด" | mkN "สิ่งสําคัญ" | mkN "เครื่องใช้" | mkN "คนหรือสัตว์" | mkN "สิ่งมีชีวิต" | mkN "กิจกรรมที่ชอบ" | mkN "งานที่ต้องทํา" | mkN "เสื้อผ้าอาภรณ์" | mkN "สิ่งที่เกิดขึ้น" | mkN "จุดประสงค์สําคัญ" | mkN "ความคิดหรือคําพูด" | mkN "สิ่งที่ปรารถนาจะได้มา" | mkN "สิ่งที่เป็นทรัพย์สินได้" | mkN "ความชอบหรือเกลียดอย่างมาก" ; -- src=panlex
lin tell_VS = mmkVS "บอก" ; ---- | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "จำแนก" | mkV "เล่าเรื่อง" | mkV "บอกให้มั่นใจ" | mkV "บอก" | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "แจ้ง" | mkV "ทํานาย" | mkV "บรรยาย" | mkV "รับรอง" | mkV "สาธยาย" | mkV "แยกแยะ" | mkV "เปิดเผย" | mkV "บอกให้ทํา" | mkV "มีผลกระทบ" | mkV "เล่าเรื่อง" | mkV "ขอร้องให้ทํา" | mkV "ทําให้มั่นใจ" | mkV "กระทบกระเทือน" | mkV "บอกความแตกต่าง" | mkV "เปิดเผยความลับ" | mkV "จําแนกความแตกต่าง" ; -- src=panlex
lin tell_V3 = mkV3 "บอก" ; ---- | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "จำแนก" | mkV "เล่าเรื่อง" | mkV "บอกให้มั่นใจ" | mkV "บอก" | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "แจ้ง" | mkV "ทํานาย" | mkV "บรรยาย" | mkV "รับรอง" | mkV "สาธยาย" | mkV "แยกแยะ" | mkV "เปิดเผย" | mkV "บอกให้ทํา" | mkV "มีผลกระทบ" | mkV "เล่าเรื่อง" | mkV "ขอร้องให้ทํา" | mkV "ทําให้มั่นใจ" | mkV "กระทบกระเทือน" | mkV "บอกความแตกต่าง" | mkV "เปิดเผยความลับ" | mkV "จําแนกความแตกต่าง" ; -- src=panlex
lin tell_1_V3 = variants{} ; -- 
lin tell_2_V3 = variants{} ; -- 
lin tell_V2V = mmkV2V "บอก" ; ---- | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "จำแนก" | mkV "เล่าเรื่อง" | mkV "บอกให้มั่นใจ" | mkV "บอก" | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "แจ้ง" | mkV "ทํานาย" | mkV "บรรยาย" | mkV "รับรอง" | mkV "สาธยาย" | mkV "แยกแยะ" | mkV "เปิดเผย" | mkV "บอกให้ทํา" | mkV "มีผลกระทบ" | mkV "เล่าเรื่อง" | mkV "ขอร้องให้ทํา" | mkV "ทําให้มั่นใจ" | mkV "กระทบกระเทือน" | mkV "บอกความแตกต่าง" | mkV "เปิดเผยความลับ" | mkV "จําแนกความแตกต่าง" ; -- src=panlex
lin tell_V2S = mmkV2S "บอก" ; ---- | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "จำแนก" | mkV "เล่าเรื่อง" | mkV "บอกให้มั่นใจ" | mkV "บอก" | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "แจ้ง" | mkV "ทํานาย" | mkV "บรรยาย" | mkV "รับรอง" | mkV "สาธยาย" | mkV "แยกแยะ" | mkV "เปิดเผย" | mkV "บอกให้ทํา" | mkV "มีผลกระทบ" | mkV "เล่าเรื่อง" | mkV "ขอร้องให้ทํา" | mkV "ทําให้มั่นใจ" | mkV "กระทบกระเทือน" | mkV "บอกความแตกต่าง" | mkV "เปิดเผยความลับ" | mkV "จําแนกความแตกต่าง" ; -- src=panlex
lin tell_V2 = mkV2 "บอก" ; ---- | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "จำแนก" | mkV "เล่าเรื่อง" | mkV "บอกให้มั่นใจ" | mkV "บอก" | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "แจ้ง" | mkV "ทํานาย" | mkV "บรรยาย" | mkV "รับรอง" | mkV "สาธยาย" | mkV "แยกแยะ" | mkV "เปิดเผย" | mkV "บอกให้ทํา" | mkV "มีผลกระทบ" | mkV "เล่าเรื่อง" | mkV "ขอร้องให้ทํา" | mkV "ทําให้มั่นใจ" | mkV "กระทบกระเทือน" | mkV "บอกความแตกต่าง" | mkV "เปิดเผยความลับ" | mkV "จําแนกความแตกต่าง" ; -- src=panlex
lin tell_V = mkV "บอก" | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "จำแนก" | mkV "เล่าเรื่อง" | mkV "บอกให้มั่นใจ" | mkV "บอก" | mkV "พูด" | mkV "รู้" | mkV "สั่ง" | mkV "เล่า" | mkV "แจ้ง" | mkV "ทํานาย" | mkV "บรรยาย" | mkV "รับรอง" | mkV "สาธยาย" | mkV "แยกแยะ" | mkV "เปิดเผย" | mkV "บอกให้ทํา" | mkV "มีผลกระทบ" | mkV "เล่าเรื่อง" | mkV "ขอร้องให้ทํา" | mkV "ทําให้มั่นใจ" | mkV "กระทบกระเทือน" | mkV "บอกความแตกต่าง" | mkV "เปิดเผยความลับ" | mkV "จําแนกความแตกต่าง" ; -- src=panlex
lin through_Prep = ss "ผ่าน" | {-pan-} mkPrep "โดย" | mkPrep "ด้วย" | mkPrep "ตลอด" | mkPrep "ทะลุ" | mkPrep "ผ่าน" | mkPrep "เพราะ" | mkPrep "เสร็จ" | mkPrep "ผ่านไป" | mkPrep "ผ่านพ้น" | mkPrep "รวมทั้ง" | mkPrep "สมบูรณ์" | mkPrep "โดยตลอด" | mkPrep "โดยวิธี" | mkPrep "ด้วยวิธี" | mkPrep "ท่ามกลาง" | mkPrep "ผ่านตลอด" | mkPrep "ถึงที่สุด" | mkPrep "เนื่องจาก" | mkPrep "โดยเหตุผล" | mkPrep "ไปตรงตลอด" | mkPrep "ตลอดทั้งหมด" | mkPrep "ตลอดทุกหน่วย" | mkPrep "ตลอดทุกจํานวน" | mkPrep "ตั้งแต่ต้นจนจบ" | mkPrep "ปราศจากการหยุด" | mkPrep "ประสบความสําเร็จ" | mkPrep "ตั้งแต่เริ่มจนกระทั่งถึง" | mkPrep "จากด้านหนึ่งไปสู่อีกด้านหนึ่งของ" ; -- src=panlex
lin back_Adv = mkAdv "ตอบกลับ" | mkAdv "ถอยหลัง" | mkAdv "ให้ถอยมา" | mkAdv "ตอบรับ" | mkAdv "ตอบโต้" | mkAdv "ผ่านมา" | mkAdv "ในอดีต" | mkAdv "ตอบกลับ" | mkAdv "ย้อนกลับ" | mkAdv "ผ่านมาแล้ว" | mkAdv "หวนกลับคืนมา" | mkAdv "หันไปข้างหลัง" ; -- src=panlex
lin still_Adv = mkAdv "ยังคง" | mkAdv "อย่างไรก็ตาม" | mkAdv "ยิ่งไปกว่านั้น" | mkAdv "ยังคง" | mkAdv "เช่นเดิม" | mkAdv "แม้บัดนี้" | mkAdv "แม้กระนั้น" | mkAdv "แม้ในขณะนี้" ; -- src=panlex
lin child_N = personN (thword "ลูก") | {-pan-} mkN "ลูก" | mkN "บุตร" | mkN "เด็ก" | mkN "พยานรัก" | mkN "บุตรธิดา" | mkN "ผู้เยาว์" | mkN "เลือดในอก" | mkN "สมาชิกกลุ่ม" | mkN "โซ่ทองคล้องใจ" | mkN "เลือดเนื้อเชื้อไข" | mkN "ลูก" | mkN "ศิศุ" | mkN "เด็ก" | mkN "ทายาท" | mkN "ผลิตผล" | mkN "คนที่มีพฤติกรรมเหมือนเด็ก" ; -- src=panlex --- personN (thword "เด็ก") ;
lin here_Adv = ss (thword "ที่" "นี่") | {-pan-} mkAdv "ณ ที่นี้" | mkAdv "ขณะนี้" | mkAdv "ตรงนี้" | mkAdv "ที่นี่" | mkAdv "ในที่นี้" | mkAdv "ที่ตรงนี้" | mkAdv "ซึ่งกําลังพิจารณาอยู่" ; -- src=panlex
lin over_Prep = mkPrep "บน" | mkPrep "หมด" | mkPrep "เลย" | mkPrep "ข้าม" | mkPrep "ตลอด" | mkPrep "ถ้วน" | mkPrep "ทั่ว" | mkPrep "พลิก" | mkPrep "เกิน" | mkPrep "เหนือ" | mkPrep "ในช่วง" | mkPrep "ทั่วตัว" | mkPrep "มากกว่า" | mkPrep "ระหว่าง" | mkPrep "สูงกว่า" | mkPrep "ให้ตลอด" | mkPrep "อีกครั้ง" | mkPrep "เกินกว่า" | mkPrep "ในเรื่อง" | mkPrep "ต่อเนื่อง" | mkPrep "เกี่ยวกับ" | mkPrep "เหนือกว่า" | mkPrep "เปลี่ยนข้าง" ; -- src=panlex
lin too_Adv = mkAdv "เกิน" | mkAdv "เกินไป" | mkAdv "เช่นกัน" | mkAdv "อย่างมากเกินไป" | mkAdv "ก็" | mkAdv "ยัง" | mkAdv "อีก" | mkAdv "ด้วย" | mkAdv "เกินไป" | mkAdv "มากกว่า" | mkAdv "อีกด้วย" | mkAdv "อย่างมาก" | mkAdv "มากเกินไป" | mkAdv "อย่างยิ่ง" | mkAdv "เพิ่มเติม" | mkAdv "เหมือนกัน" ; -- src=panlex
lin put_V2 = mkV2 "ใส่" ;
lin on_Adv = mkAdv "ไป" | mkAdv "อยู่" | mkAdv "ไปยัง" | mkAdv "ณ" | mkAdv "บน" | mkAdv "ตาม" | mkAdv "ที่" | mkAdv "โดย" | mkAdv "อาศัย" | mkAdv "ไปทาง" | mkAdv "ไปสู่" | mkAdv "ตามแผน" | mkAdv "ติดกัน" | mkAdv "ประชิด" | mkAdv "ใช้อยู่" | mkAdv "ในขณะที่" | mkAdv "ในวันที่" | mkAdv "ในเรื่อง" | mkAdv "สถานการณ์" | mkAdv "เกี่ยวกับ" | mkAdv "ในเวลาที่" | mkAdv "อย่างต่อไป" | mkAdv "ทันทีหลังจาก" | mkAdv "อย่างเรื่อยๆ" | mkAdv "อย่างใช้อยู่" | mkAdv "อย่างไม่หยุด" | mkAdv "อยู่ในสถานการณ์" | mkAdv "อย่างทํางานอยู่" | mkAdv "ซึ่งกําลังเกิดขึ้น" | mkAdv "อย่างกําลังดําเนินอยู่" ; -- src=panlex
lin no_Interj = mkInterj "มิได้" | mkInterj "ไม่ได้" ; -- src=panlex
lin work_V2 = variants{} ; -- 
lin work_V = variants{} ; -- 
lin work_2_V = variants{} ; -- 
lin work_1_V = variants{} ; -- 
lin become_VA = mkV (thword "กลาย" "เป็น") ; -- pen
lin become_V2 = mkV2 "รู้สึก" ; ---- | mkV "กลายเป็น" | mkV "เหมาะกับ" | mkV "งดงาม" | mkV "เข้ากับ" | mkV "เหมาะสม" | mkV "กลายเป็น" | mkV "ดูสวยงาม" | mkV "เหมาะสมกับ" | mkV "เปลี่ยนเป็น" ; -- src=panlex
lin become_V = mkV "รู้สึก" | mkV "กลายเป็น" | mkV "เหมาะกับ" | mkV "งดงาม" | mkV "เข้ากับ" | mkV "เหมาะสม" | mkV "กลายเป็น" | mkV "ดูสวยงาม" | mkV "เหมาะสมกับ" | mkV "เปลี่ยนเป็น" ; -- src=panlex
lin old_A = mkA (thword "แก่") | {-pan-} mkA "แก่" | mkA "ก่อน" | mkA "เก่า" | mkA "ชรา" | mkA "แก่" | mkA "อดีต" | mkA "เฒ่า" | mkA "เดิม" | mkA "คร่ํา" | mkA "โบราณ" | mkA "อายุมาก" | mkA "เก่าแก่" | mkA "ที่ชํานาญ" | mkA "แต่หนหลัง" | mkA "ที่ช่ําชอง" | mkA "ที่สูงอายุ" | mkA "ที่มีอายุมาก" | mkA "ที่อยู่ในอดีต" | mkA "ที่มีประสบการณ์" | mkA "ที่อยู่ในช่วงแรก" | mkA "ที่อยู่ในช่วงก่อน" ; -- src=panlex
lin government_N = mkN "รบ." | mkN "รัฐบาล" | mkN "รัฐศาสตร์" | mkN "การบริหารรัฐกิจ" | mkN "รัฐบาล" | mkN "การปกครอง" | mkN "ฝ่ายบริหาร" | mkN "ฝ่ายปกครอง" | mkN "คณะผู้ปกครอง" ; -- src=panlex
lin mean_VV = variants{} ; -- 
lin mean_VS = variants{} ; -- 
lin mean_V2V = variants{} ; -- 
lin mean_V2 = variants{} ; -- 
lin part_N = mkN "บท" | mkN "ส่วน" | mkN "หุ้น" | mkN "บทบาท" | mkN "พาร์ต" | mkN "แสกผม" | mkN "ส่วนประกอบ" | mkN "องค์ประกอบ" | mkN "บทบาทการแสดง" | mkN "ส่วน" | mkN "บทบาท" | mkN "บทพูด" | mkN "บทละคร" | mkN "บริเวณ" | mkN "ชิ้นส่วน" | mkN "ส่วนแบ่ง" | mkN "ส่วนหนึ่ง" | mkN "อัตราส่วน" | mkN "ส่วนประกอบ" | mkN "เสียงดนตรี" | mkN "บทบาทในการแสดง" ; -- src=panlex
lin leave_V2V = mmkV2V "บอก" ; ---- | mkV "ฝาก" | mkV "ออก" | mkV "ทิ้ง" | mkV "ปล่อย" | mkV "ออกจาก" | mkV "ทิ้งไว้" | mkV "มีโอกาส" | mkV "ลืมทิ้งไว้" | mkV "ทำพินัยกรรม" | mkV "มีความเป็นไปได้" | mkV "จาก" | mkV "ฝาก" | mkV "มอบ" | mkV "ทิ้ง" | mkV "เหลือ" | mkV "ฝากไว้" | mkV "มอบไว้" | mkV "ออกจาก" | mkV "ให้ไว้" | mkV "ทอดทิ้ง" | mkV "ทิ้งไว้" | mkV "มอบหมาย" | mkV "ปล่อยไว้" | mkV "เหลือไว้" | mkV "เหลืออยู่" | mkV "แตกใบอ่อน" | mkV "ออกเดินทาง" ; -- src=panlex
lin leave_V2 = mkV2 "จาก" ;
lin leave_V = mkV "บอก" | mkV "ฝาก" | mkV "ออก" | mkV "ทิ้ง" | mkV "ปล่อย" | mkV "ออกจาก" | mkV "ทิ้งไว้" | mkV "มีโอกาส" | mkV "ลืมทิ้งไว้" | mkV "ทำพินัยกรรม" | mkV "มีความเป็นไปได้" | mkV "จาก" | mkV "ฝาก" | mkV "มอบ" | mkV "ทิ้ง" | mkV "เหลือ" | mkV "ฝากไว้" | mkV "มอบไว้" | mkV "ออกจาก" | mkV "ให้ไว้" | mkV "ทอดทิ้ง" | mkV "ทิ้งไว้" | mkV "มอบหมาย" | mkV "ปล่อยไว้" | mkV "เหลือไว้" | mkV "เหลืออยู่" | mkV "แตกใบอ่อน" | mkV "ออกเดินทาง" ; -- src=panlex
lin life_N = mkN "ชีวิต" | mkN "ประวัติ" | mkN "ช่วงอายุ" | mkN "ชีวประวัติ" | mkN "สิ่งมีชีวิต" | mkN "ประวัติชีวิต" | mkN "ความมีชีวิตชีวา" | mkN "คำพิพากษาจำคุกตลอดชีวิต" | mkN "ชีพ" | mkN "ฟอง" | mkN "ชีวะ" | mkN "ชีวา" | mkN "ชีวิต" | mkN "ชั่วอายุ" | mkN "ชั่วชีวิต" | mkN "ตลอดชีวิต" | mkN "วิถีชีวิต" | mkN "ชีวประวัติ" | mkN "ความร่าเริง" | mkN "สิ่งมีชีวิต" | mkN "ความยืดหยุ่น" | mkN "ความสนุกสนาน" | mkN "การดํารงชีวิต" | mkN "ความกลับได้ง่าย" | mkN "ความมีชีวิตชีวา" | mkN "วิธีการดํารงชีวิต" | mkN "สิ่งมีค่าของชีวิต" | mkN "โทษจําคุกตลอดชีวิต" | mkN "บุคคลที่มีค่าของชีวิต" | mkN "รูปแบบการดําเนินชีวิต" | mkN "ความรุ่งเรืองหรืออื่น ๆ" | mkN "ช่วงระยะเวลาที่มีชีวิต" | mkN "ช่วงระยะเวลาแห่งอํานาจ" | mkN "อายุการใช้งานของสิ่งของ" | mkN "ช่วงชีวิตของสิ่งมีชีวิตตั้งแต่เกิดจนตาย" ; -- src=panlex
lin great_A = mkA "นาน" | mkA "ใหญ่" | mkA "ดีมาก" | mkA "ดีเลิศ" | mkA "ยาวนาน" | mkA "สําคัญ" | mkA "โดดเด่น" | mkA "ยิ่งใหญ่" | mkA "ยอดเยี่ยม" | mkA "คนที่มีชื่อเสียง" ; -- src=panlex
lin case_N = mkN "กาบ" | mkN "คดี" | mkN "หีบ" | mkN "เคส" | mkN "กรณี" | mkN "กรอบ" | mkN "การก" | mkN "ปลอก" | mkN "ฟอนต์" | mkN "อักษร" | mkN "ลักษณะ" | mkN "อักขระ" | mkN "เปลือก" | mkN "กระเป๋า" | mkN "คดีความ" | mkN "ตู้โชว์" | mkN "กรณศึกษา" | mkN "ตัวอย่าง" | mkN "ตัวอักษร" | mkN "ปลอกหมอน" | mkN "แบบอักษร" | mkN "กรณีศึกษา" | mkN "เหตุการณ์" | mkN "แบบอักขระ" | mkN "ข้อเท็จจริง" | mkN "ภาชนะแก้วใส" | mkN "กรอบหน้าต่าง" | mkN "การดำเนินคดี" | mkN "ปริมาณหนึ่งหีบ" | mkN "คดี" | mkN "กรอบ" | mkN "ปัญหา" | mkN "ข้อคดี" | mkN "คดีความ" | mkN "ปลอกหมอน" | mkN "สถานการณ์" | mkN "เรื่องราว" | mkN "เหตุการณ์" | mkN "กล่องเล็กๆ" | mkN "ข้อสนับสนุน" | mkN "คนที่ไม่ปกติ" | mkN "จํานวนคู่หนึ่ง" | mkN "เหตุผลสนับสนุน" | mkN "คนหรือสิ่งที่เป็นกรณีศึกษา" ; -- src=panlex
lin woman_N = personN (thword "หญิง") | {-pan-} mkN "เมต" | mkN "นารี" | mkN "สตรี" | mkN "อิตถี" | mkN "อิสตรี" | mkN "ผู้หญิง" | mkN "สตรีเพศ" | mkN "แม่บ้าน" | mkN "หญิงทำความสะอาด" | mkN "สตรี" | mkN "หญิง" | mkN "คนรัก" | mkN "อิตถี" | mkN "อิสตรี" | mkN "ผู้หญิง" | mkN "หญิงสาว" | mkN "เกี่ยวกับเพศหญิง" | mkN "คุณสมบัติหรือความรู้สึกของผู้หญิง" ; -- src=panlex
lin over_Adv = mkAdv "ตลอด" | mkAdv "ทั่ว" | mkAdv "เหนือ" | mkAdv "อยู่เหนือ" | mkAdv "ทั่วบริเวณ" | mkAdv "บน" | mkAdv "ข้าม" | mkAdv "ตลอด" | mkAdv "เกิน" | mkAdv "เหนือ" | mkAdv "ทั่วไป" | mkAdv "ผ่านไป" | mkAdv "มากกว่า" | mkAdv "อีกครั้ง" | mkAdv "เกินกว่า" | mkAdv "ตลอดทั้งหมด" ; -- src=panlex
lin seem_VV = variants{} ; -- 
lin seem_VS = variants{} ; -- 
lin seem_VA = variants{} ; -- 
lin work_N = mkN "งาน" | mkN "ผลงาน" | mkN "การงาน" | mkN "งานการ" | mkN "ชิ้นงาน" | mkN "ที่ทำงาน" | mkN "ผลงานทั้งหมด" | mkN "สถานที่ทำงาน" | mkN "งานที่ได้รับค่าจ้าง" | mkN "ผล" | mkN "งาน" | mkN "มีผล" | mkN "ทำงาน" | mkN "ผลงาน" | mkN "ได้ผล" | mkN "การงาน" | mkN "ควบคุม" | mkN "ใช้งาน" | mkN "ใช้สอย" | mkN "ชิ้นงาน" | mkN "เวลางาน" | mkN "งานฝีมือ" | mkN "การทํางาน" | mkN "ที่ทํางาน" | mkN "พฤติการณ์" | mkN "ดําเนินงาน" | mkN "ทําด้วยมือ" | mkN "ทําให้ได้ผ" | mkN "สิ่งที่ทํา" | mkN "เดินเครื่อง" | mkN "สิ่งก่อสร้าง" | mkN "รับจ้างทํางาน" | mkN "ผลิตผลจากการทํางาน" | mkN "ความพยายามที่ใช้ไปในการทํางาน" ; -- src=panlex
lin need_VV = mkVV "จำเป็น" ; ---- | mkV "ต้องการ" | mkV "ควรทํา" | mkV "จําเป็น" | mkV "ต้องการ" | mkV "จําเป็นต้องมี" ; -- src=panlex
lin need_VV = mkVV "จำเป็น" ; ---- | mkV "ต้องการ" | mkV "ควรทํา" | mkV "จําเป็น" | mkV "ต้องการ" | mkV "จําเป็นต้องมี" ; -- src=panlex
lin need_V2 = mkV2 "จำเป็น" ; ---- | mkV "ต้องการ" | mkV "ควรทํา" | mkV "จําเป็น" | mkV "ต้องการ" | mkV "จําเป็นต้องมี" ; -- src=panlex
lin need_V = mkV "จำเป็น" | mkV "ต้องการ" | mkV "ควรทํา" | mkV "จําเป็น" | mkV "ต้องการ" | mkV "จําเป็นต้องมี" ; -- src=panlex
lin feel_VS = mmkVS "ลูบ" ; ---- | mkV "คลำหา" | mkV "รู้สึก" | mkV "ลูบคลำ" | mkV "สัมผัส" | mkV "คลำตรวจ" | mkV "มีความรู้สึก" | mkV "ยังพอมองเห็น" | mkV "ให้ความรู้สึก" | mkV "จับ" | mkV "รู้" | mkV "นึกถึง" | mkV "รับรู้" | mkV "รู้สึก" | mkV "เข้าใจ" | mkV "ตระหนัก" | mkV "รู้สึกถึง" | mkV "สังหรณ์ใจ" | mkV "สัมผัสได้" ; -- src=panlex
lin feel_VA = mmkVA "ลูบ" ; ---- | mkV "คลำหา" | mkV "รู้สึก" | mkV "ลูบคลำ" | mkV "สัมผัส" | mkV "คลำตรวจ" | mkV "มีความรู้สึก" | mkV "ยังพอมองเห็น" | mkV "ให้ความรู้สึก" | mkV "จับ" | mkV "รู้" | mkV "นึกถึง" | mkV "รับรู้" | mkV "รู้สึก" | mkV "เข้าใจ" | mkV "ตระหนัก" | mkV "รู้สึกถึง" | mkV "สังหรณ์ใจ" | mkV "สัมผัสได้" ; -- src=panlex
lin feel_V2 = mkV2 "ลูบ" ; ---- | mkV "คลำหา" | mkV "รู้สึก" | mkV "ลูบคลำ" | mkV "สัมผัส" | mkV "คลำตรวจ" | mkV "มีความรู้สึก" | mkV "ยังพอมองเห็น" | mkV "ให้ความรู้สึก" | mkV "จับ" | mkV "รู้" | mkV "นึกถึง" | mkV "รับรู้" | mkV "รู้สึก" | mkV "เข้าใจ" | mkV "ตระหนัก" | mkV "รู้สึกถึง" | mkV "สังหรณ์ใจ" | mkV "สัมผัสได้" ; -- src=panlex
lin feel_V = mkV "ลูบ" | mkV "คลำหา" | mkV "รู้สึก" | mkV "ลูบคลำ" | mkV "สัมผัส" | mkV "คลำตรวจ" | mkV "มีความรู้สึก" | mkV "ยังพอมองเห็น" | mkV "ให้ความรู้สึก" | mkV "จับ" | mkV "รู้" | mkV "นึกถึง" | mkV "รับรู้" | mkV "รู้สึก" | mkV "เข้าใจ" | mkV "ตระหนัก" | mkV "รู้สึกถึง" | mkV "สังหรณ์ใจ" | mkV "สัมผัสได้" ; -- src=panlex
lin system_N = mkN "ระบบ" | mkN "ซิสเต็ม" | mkN "ระบบในร่างกาย" | mkN "ตัวอย่างของสสาร" | mkN "ระบบ" | mkN "" | mkN "หลักการ" ; -- src=panlex
lin each_Det = variants{} ; -- 
lin may_2_VV = variants{} ; -- 
lin may_1_VV = variants{} ; -- 
lin much_Adv = mkAdv "มาก" | mkAdv "มากมาย" | mkAdv "เยอะแยะ" | mkAdv "อย่างใช้ได้จริง" | mkAdv "ถี่" | mkAdv "บ่อย" | mkAdv "เกือบจะ" | mkAdv "อย่างมาก" | mkAdv "โดยประมาณ" | mkAdv "อย่างมากมาย" | mkAdv "อย่างใหญ่หลวง" ; -- src=panlex
lin ask_VQ = mmkVQ "ถาม" ; ---- | mkV "ซักถาม" | mkV "ต้องการ" | mkV "เรียกราคา" | mkV "เรียกร้อง" | mkV "เรียกเงิน" | mkV "ขอ" | mkV "ถาม" | mkV "เชิญ" | mkV "ขอราคา" | mkV "ขอร้อง" | mkV "ต้องการ" | mkV "บอกราคา" | mkV "ประสงค์" | mkV "เชื้อเชิญ" | mkV "เสนอราคาที่ต้องการ" ; -- src=panlex
lin ask_V2V = mmkV2V "ถาม" ; ---- | mkV "ซักถาม" | mkV "ต้องการ" | mkV "เรียกราคา" | mkV "เรียกร้อง" | mkV "เรียกเงิน" | mkV "ขอ" | mkV "ถาม" | mkV "เชิญ" | mkV "ขอราคา" | mkV "ขอร้อง" | mkV "ต้องการ" | mkV "บอกราคา" | mkV "ประสงค์" | mkV "เชื้อเชิญ" | mkV "เสนอราคาที่ต้องการ" ; -- src=panlex
lin ask_V2 = mkV2 "ถาม" ; ---- | mkV "ซักถาม" | mkV "ต้องการ" | mkV "เรียกราคา" | mkV "เรียกร้อง" | mkV "เรียกเงิน" | mkV "ขอ" | mkV "ถาม" | mkV "เชิญ" | mkV "ขอราคา" | mkV "ขอร้อง" | mkV "ต้องการ" | mkV "บอกราคา" | mkV "ประสงค์" | mkV "เชื้อเชิญ" | mkV "เสนอราคาที่ต้องการ" ; -- src=panlex
lin ask_V = mkV "ถาม" | mkV "ซักถาม" | mkV "ต้องการ" | mkV "เรียกราคา" | mkV "เรียกร้อง" | mkV "เรียกเงิน" | mkV "ขอ" | mkV "ถาม" | mkV "เชิญ" | mkV "ขอราคา" | mkV "ขอร้อง" | mkV "ต้องการ" | mkV "บอกราคา" | mkV "ประสงค์" | mkV "เชื้อเชิญ" | mkV "เสนอราคาที่ต้องการ" ; -- src=panlex
lin group_N = mkN "พวก" | mkN "กรุป" | mkN "หมู่" | mkN "กลุ่ม" | mkN "เหล่า" | mkN "กลุ่มเคมี" | mkN "คณะ" | mkN "พวก" | mkN "ฝ่าย" | mkN "หมู่" | mkN "กลุ่ม" | mkN "เหล่า" ; -- src=panlex
lin number_N = mkN (thword "หมาย" "เลข") ; ----?
lin number_3_N = variants{} ; -- 
lin number_2_N = variants{} ; -- 
lin number_1_N = variants{} ; -- 
lin yes_Interj = variants{} ; -- 
lin however_Adv = mkAdv "อย่างไรก็ตาม" | mkAdv "ยิ่งไปกว่านั้น" | mkAdv "ยังคง" | mkAdv "แม้จะ ... เพียงใดก็ตาม" | mkAdv "แม้ว่า" | mkAdv "ไม่ว่าจะ ... ขนาดไหน" | mkAdv "อย่างไรก็ตาม" | mkAdv "แต่กระนั้นก็ดี" ; -- src=panlex
lin another_Det = variants{} ; -- 
lin again_Adv = mkAdv "อีกครั้ง" | mkAdv "อีก" | mkAdv "ใหม่" | mkAdv "อนึ่ง" | mkAdv "อีกที" | mkAdv "ซ้ําสอง" | mkAdv "อีกแล้ว" | mkAdv "เช่นเคย" | mkAdv "อีกครั้ง" | mkAdv "เช่นเดิม" | mkAdv "นอกจากนี้" | mkAdv "ในอีกด้านหนึ่ง" | mkAdv "เพิ่มจากที่กล่าวไปแล้ว" ; -- src=panlex
lin world_N = mkN "โลก" | mkN "คนในวง" | mkN "จักรวาล" | mkN "สรรพสิ่ง" | mkN "สาธารณชน" | mkN "มนุษยชาติ" | mkN "สิ่งมีชีวิต" | mkN "เรื่องทางโลก" | mkN "ภพ" | mkN "โลก" | mkN "พิภพ" | mkN "พื้น" | mkN "สากล" | mkN "หล้า" | mkN "วงการ" | mkN "ชาวโลก" | mkN "เขตโลก" | mkN "จุกรวาล" | mkN "วงสังคม" | mkN "ชีวิตโลก" | mkN "สรรพสิ่ง" | mkN "สาธารณชน" | mkN "อาณาจักร" | mkN "ทางโลกีย์" | mkN "มนุษยชาติ" | mkN "มนุษย์โลก" | mkN "มวลมนุษย์" | mkN "โลกมนุษย์" | mkN "สังคมมนุษย์" | mkN "จํานวนมหาศาล" | mkN "ชนชั้นเฉพาะของมนุษย์" | mkN "ทุกสิ่งทุกอย่างที่มีอยู่" | mkN "ทุกสิ่งทุกอย่างในชีวิตของคนคนหนึ่ง" ; -- src=panlex
lin area_N = variants{} ; -- 
lin area_6_N = variants{} ; -- 
lin area_5_N = variants{} ; -- 
lin area_4_N = variants{} ; -- 
lin area_3_N = variants{} ; -- 
lin area_2_N = variants{} ; -- 
lin area_1_N = variants{} ; -- 
lin show_VS = mmkVS "แสดง" ; ---- | mkV "โชว์" | mkV "สาธิต" | mkV "ชี้บอก" | mkV "ยืนยัน" | mkV "พิสูจน์" | mkV "อ่านค่า" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "ปรากฎให้เห็น" | mkV "แสดงความรู้สึก" | mkV "นำไปยัุงที่นั่ง" | mkV "เข้าเป็นอันดับสาม" | mkV "ชิ้" | mkV "บอก" | mkV "แสดง" | mkV "สาธิต" | mkV "ให้ดู" | mkV "ยืนยัน" | mkV "อธิบาย" | mkV "เผยตัว" | mkV "นําไปดู" | mkV "พาไปยัง" | mkV "พิสูจน์" | mkV "เห็นชัด" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "นําออกฉาย" | mkV "บอกข้อมูล" | mkV "แสดงท่าที" | mkV "ให้ข้อมูล" | mkV "ชี้ให้เห็น" | mkV "ทําให้เห็น" | mkV "นําออกแสดง" | mkV "มองเห็นได้" | mkV "เห็นได้ชัด" | mkV "แสดงทัศนคติ" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "แสดงความรู้สึก" ; -- src=panlex
lin show_VQ = mmkVQ "แสดง" ; ---- | mkV "โชว์" | mkV "สาธิต" | mkV "ชี้บอก" | mkV "ยืนยัน" | mkV "พิสูจน์" | mkV "อ่านค่า" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "ปรากฎให้เห็น" | mkV "แสดงความรู้สึก" | mkV "นำไปยัุงที่นั่ง" | mkV "เข้าเป็นอันดับสาม" | mkV "ชิ้" | mkV "บอก" | mkV "แสดง" | mkV "สาธิต" | mkV "ให้ดู" | mkV "ยืนยัน" | mkV "อธิบาย" | mkV "เผยตัว" | mkV "นําไปดู" | mkV "พาไปยัง" | mkV "พิสูจน์" | mkV "เห็นชัด" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "นําออกฉาย" | mkV "บอกข้อมูล" | mkV "แสดงท่าที" | mkV "ให้ข้อมูล" | mkV "ชี้ให้เห็น" | mkV "ทําให้เห็น" | mkV "นําออกแสดง" | mkV "มองเห็นได้" | mkV "เห็นได้ชัด" | mkV "แสดงทัศนคติ" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "แสดงความรู้สึก" ; -- src=panlex
lin show_V2 = mkV2 "แสดง" ; ---- | mkV "โชว์" | mkV "สาธิต" | mkV "ชี้บอก" | mkV "ยืนยัน" | mkV "พิสูจน์" | mkV "อ่านค่า" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "ปรากฎให้เห็น" | mkV "แสดงความรู้สึก" | mkV "นำไปยัุงที่นั่ง" | mkV "เข้าเป็นอันดับสาม" | mkV "ชิ้" | mkV "บอก" | mkV "แสดง" | mkV "สาธิต" | mkV "ให้ดู" | mkV "ยืนยัน" | mkV "อธิบาย" | mkV "เผยตัว" | mkV "นําไปดู" | mkV "พาไปยัง" | mkV "พิสูจน์" | mkV "เห็นชัด" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "นําออกฉาย" | mkV "บอกข้อมูล" | mkV "แสดงท่าที" | mkV "ให้ข้อมูล" | mkV "ชี้ให้เห็น" | mkV "ทําให้เห็น" | mkV "นําออกแสดง" | mkV "มองเห็นได้" | mkV "เห็นได้ชัด" | mkV "แสดงทัศนคติ" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "แสดงความรู้สึก" ; -- src=panlex
lin show_V = mkV "แสดง" | mkV "โชว์" | mkV "สาธิต" | mkV "ชี้บอก" | mkV "ยืนยัน" | mkV "พิสูจน์" | mkV "อ่านค่า" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "ปรากฎให้เห็น" | mkV "แสดงความรู้สึก" | mkV "นำไปยัุงที่นั่ง" | mkV "เข้าเป็นอันดับสาม" | mkV "ชิ้" | mkV "บอก" | mkV "แสดง" | mkV "สาธิต" | mkV "ให้ดู" | mkV "ยืนยัน" | mkV "อธิบาย" | mkV "เผยตัว" | mkV "นําไปดู" | mkV "พาไปยัง" | mkV "พิสูจน์" | mkV "เห็นชัด" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "นําออกฉาย" | mkV "บอกข้อมูล" | mkV "แสดงท่าที" | mkV "ให้ข้อมูล" | mkV "ชี้ให้เห็น" | mkV "ทําให้เห็น" | mkV "นําออกแสดง" | mkV "มองเห็นได้" | mkV "เห็นได้ชัด" | mkV "แสดงทัศนคติ" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "แสดงความรู้สึก" ; -- src=panlex
lin course_N = mkN "ชุด" | mkN "แถว" | mkN "แนว" | mkN "ชั้น" | mkN "สนาม" | mkN "คอร์ส" | mkN "เส้นทาง" | mkN "ชุดอาหาร" | mkN "หลักสูตร" | mkN "หลักสูตรการศึกษา" | mkN "หลักสูตรการเรียน" | mkN "แนวทางการปฏิบัติ" | mkN "วิชา" | mkN "แนวคิด" | mkN "แนวทาง" | mkN "วิถีทาง" | mkN "เส้นทาง" | mkN "จานหนึ่ง" | mkN "ช่วงเวลา" | mkN "หลักสูตร" | mkN "กระบวนวิชา" | mkN "แนวความคิด" | mkN "อาหารจานหนึ่ง" | mkN "แนวทางปฏิบัติ" | mkN "ลําดับของเหตุการณ์" ; -- src=panlex
lin company_2_N = variants{} ; -- 
lin company_1_N = variants{} ; -- 
lin under_Prep = ss "ใต้" | {-pan-} mkPrep "รอง" | mkPrep "ใต้" | mkPrep "ล่าง" | mkPrep "ตามที่" | mkPrep "ภายใต้" | mkPrep "ข้างใต้" | mkPrep "ข้างล่าง" | mkPrep "ต่ํากว่า" | mkPrep "น้อยกว่า" | mkPrep "ในสังกัด" | mkPrep "ระดับต่ํากว่า" ; -- src=panlex
lin problem_N = mkN "ปัญหา" | mkN "โจทย์" | mkN "ปัญหา" | mkN "คําถาม" | mkN "หมากกล" | mkN "ข้อปัญหา" | mkN "เป็นปัญหา" | mkN "ปัญหายุ่งยาก" | mkN "เรื่องลําบาก" | mkN "เรื่องยุ่งยาก" | mkN "โจทย์เรขาคณิต" | mkN "โจทย์คณิตศาสตร์" ; -- src=panlex
lin against_Prep = mkPrep "ขัด" | mkPrep "ทวน" | mkPrep "ทาบ" | mkPrep "ฝืน" | mkPrep "พาด" | mkPrep "พิง" | mkPrep "สู้" | mkPrep "แนบ" | mkPrep "ต้าน" | mkPrep "ย้อน" | mkPrep "ฝ่าฝืน" | mkPrep "สู้กับ" | mkPrep "ต่อต้าน" | mkPrep "ทวนน้ํา" | mkPrep "ปะทะกับ" | mkPrep "ป้องกัน" | mkPrep "กระทบกับ" | mkPrep "ดูขัดกับ" | mkPrep "เทียบกับ" | mkPrep "แนบเนื้อ" | mkPrep "ปกป้องจาก" | mkPrep "ประชิดกับ" | mkPrep "ผิดกฎหมาย" | mkPrep "ตรงกันข้าม" | mkPrep "ไม่เห็นด้วย" | mkPrep "ดูขัดแย้งกับ" | mkPrep "อยู่ข้างหน้า" | mkPrep "ตรงกันข้ามกับ" | mkPrep "เปรียบเทียบกับ" | mkPrep "เป็นข้อเสียของ" | mkPrep "เพื่อใช้คืนให้กับ" | mkPrep "เกี่ยวข้องกับเหตุการณ์" ; -- src=panlex
lin never_Adv = mkAdv "ไม่เคย" | mkAdv "ไม่เคย" | mkAdv "ไม่เลย" | mkAdv "ไม่มีทาง" | mkAdv "ไม่อย่างแน่นอน" | mkAdv "ไม่อย่างเด็ดขาด" ; -- src=panlex
lin most_Adv = mkAdv "เกือบ" | mkAdv "ที่สุด" | mkAdv "จวนเจียน" | mkAdv "มาก" | mkAdv "ที่สุด" | mkAdv "มากที่สุด" ; -- src=panlex
lin service_N = mkN "กองทัพ" | mkN "บริการ" | mkN "เซอร์วิส" | mkN "เหล่าทัพ" | mkN "การบริการ" | mkN "การเสิร์ฟ" | mkN "งานบริการ" | mkN "งานรับใช้" | mkN "การให้บริการ" | mkN "ลักษ" | mkN "ทหารบก" | mkN "การบริการ" | mkN "การรับใช้" | mkN "การส่งลูก" | mkN "การออกลูก" | mkN "การต้อนรับ" | mkN "การช่วยเหลือ" | mkN "การปรนนิบัติ" | mkN "การเสิร์ฟลูก" | mkN "การให้บริการ" | mkN "การต้อนรับแขก" | mkN "การส่งหมายศาล" | mkN "เป็นการบริการ" | mkN "การบริการอาหาร" | mkN "การบํารุงรักษา" | mkN "การยื่นหมายศาล" | mkN "การอํานวยประโยชน์" | mkN "การให้ความช่วยเหลือ" | mkN "ชุดเครื่องมือรับประทานอาหาร" | mkN "การบํารุงรักษาเครื่องจักรหรือเครื่องยนตร์" ; -- src=panlex
lin try_VV = mkVV "ชิม" ; ---- | mkV "ทดสอบ" | mkV "พยายาม" | mkV "ลองชุด" | mkV "พิพากษา" | mkV "ลองเสื้อ" | mkV "เพียรพยายาม" | mkV "ทดสอบขีดจำกัด" | mkV "ตรวจสอบหลักฐาน" | mkV "ดู" | mkV "ลอง" | mkV "ตรวจ" | mkV "ทดลอง" | mkV "ทดสอบ" | mkV "พยายาม" | mkV "ตรวจสอบ" | mkV "พิจารณา" | mkV "พิสูจน์" | mkV "สอบสวนในศาล" | mkV "ทําให้เหลืออด" ; -- src=panlex
lin try_V2 = mkV2 "ชิม" ; ---- | mkV "ทดสอบ" | mkV "พยายาม" | mkV "ลองชุด" | mkV "พิพากษา" | mkV "ลองเสื้อ" | mkV "เพียรพยายาม" | mkV "ทดสอบขีดจำกัด" | mkV "ตรวจสอบหลักฐาน" | mkV "ดู" | mkV "ลอง" | mkV "ตรวจ" | mkV "ทดลอง" | mkV "ทดสอบ" | mkV "พยายาม" | mkV "ตรวจสอบ" | mkV "พิจารณา" | mkV "พิสูจน์" | mkV "สอบสวนในศาล" | mkV "ทําให้เหลืออด" ; -- src=panlex
lin try_V = mkV "ชิม" | mkV "ทดสอบ" | mkV "พยายาม" | mkV "ลองชุด" | mkV "พิพากษา" | mkV "ลองเสื้อ" | mkV "เพียรพยายาม" | mkV "ทดสอบขีดจำกัด" | mkV "ตรวจสอบหลักฐาน" | mkV "ดู" | mkV "ลอง" | mkV "ตรวจ" | mkV "ทดลอง" | mkV "ทดสอบ" | mkV "พยายาม" | mkV "ตรวจสอบ" | mkV "พิจารณา" | mkV "พิสูจน์" | mkV "สอบสวนในศาล" | mkV "ทําให้เหลืออด" ; -- src=panlex
lin call_V2 = mkV2 "ทาย" ; ---- | mkV "นัด" | mkV "โทร" | mkV "เห็น" | mkV "ตะโกน" | mkV "ทำนาย" | mkV "เรียก" | mkV "โทรหา" | mkV "เยี่ยม" | mkV "เลื่อน" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "ตั้งชื่อ" | mkV "ร้องลั่น" | mkV "เช็คชื่อ" | mkV "เรียกตัว" | mkV "เรียกไพ่" | mkV "โทรศัพท์" | mkV "บอกจังหวะ" | mkV "ร้องตะโกน" | mkV "ร้องเรียก" | mkV "สังหรณ์ใจ" | mkV "เรียกชื่อ" | mkV "เรียกร้อง" | mkV "ให้จังหวะ" | mkV "โทรศัพท์หา" | mkV "จอดเทียบท่า" | mkV "เรียกประชุม" | mkV "แจ้งให้ชำระ" | mkV "ทำเสียงเรียก" | mkV "เรียกให้ตื่น" | mkV "ประกาศผลการตัดสิน" | mkV "เรียกร้องความซื่อสัตย์" | mkV "เรียก" | mkV "เรียกว่า" | mkV "ร้องเรียก" | mkV "ตะโกนเรียก" | mkV "โทรศัพท์ไปหา" ; -- src=panlex
lin call_V = mkV "ทาย" | mkV "นัด" | mkV "โทร" | mkV "เห็น" | mkV "ตะโกน" | mkV "ทำนาย" | mkV "เรียก" | mkV "โทรหา" | mkV "เยี่ยม" | mkV "เลื่อน" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "ตั้งชื่อ" | mkV "ร้องลั่น" | mkV "เช็คชื่อ" | mkV "เรียกตัว" | mkV "เรียกไพ่" | mkV "โทรศัพท์" | mkV "บอกจังหวะ" | mkV "ร้องตะโกน" | mkV "ร้องเรียก" | mkV "สังหรณ์ใจ" | mkV "เรียกชื่อ" | mkV "เรียกร้อง" | mkV "ให้จังหวะ" | mkV "โทรศัพท์หา" | mkV "จอดเทียบท่า" | mkV "เรียกประชุม" | mkV "แจ้งให้ชำระ" | mkV "ทำเสียงเรียก" | mkV "เรียกให้ตื่น" | mkV "ประกาศผลการตัดสิน" | mkV "เรียกร้องความซื่อสัตย์" | mkV "เรียก" | mkV "เรียกว่า" | mkV "ร้องเรียก" | mkV "ตะโกนเรียก" | mkV "โทรศัพท์ไปหา" ; -- src=panlex
lin hand_N = mkN (thword "มือ") | {-pan-} mkN "กร" | mkN "มือ" | mkN "ไพ่" | mkN "เข็ม" | mkN "หัตถา" | mkN "หัตถ์" | mkN "แฮนด์" | mkN "ฝ่ามือ" | mkN "ลายมือ" | mkN "พระหัตถ์" | mkN "เข็มนาฬิกา" | mkN "ลายมือเขียน" | mkN "คนงานรับจ้าง" | mkN "ผู้เล่นไพ่บริดจ์" | mkN "การยื่นมือเข้าช่วย" | mkN "ลายมือเขียนหนังสือ" | mkN "กร" | mkN "ได" | mkN "มือ" | mkN "ฝ่าย" | mkN "ขาไพ่" | mkN "คนงาน" | mkN "หัตถ์" | mkN "อํานาจ" | mkN "ลูกเรือ" | mkN "อิทธิพล" | mkN "การควบคุม" | mkN "การปรบมือ" | mkN "ความชํานาญ" | mkN "ความสามารถ" | mkN "เข็มนาฬิกา" | mkN "ผู้เชี่ยวชาญ" | mkN "ความช่วยเหลือ" | mkN "ความมีส่วนร่วม" | mkN "ไพ่ที่ถืออยู่บนมือ" ; -- src=panlex
lin party_N = variants{} ; -- 
lin party_2_N = variants{} ; -- 
lin party_1_N = variants{} ; -- 
lin high_A = mkA "สูง" | mkA "ระดับสูง" | mkA "ซึ่งมีกลิ่นฉุน" | mkA "ดี" | mkA "จัด" | mkA "รวย" | mkA "สูง" | mkA "แพง" | mkA "ไกล" | mkA "ใหญ่" | mkA "หยิ่ง" | mkA "โอหัง" | mkA "รุนแรง" | mkA "หรูหรา" | mkA "จริงจัง" | mkA "ร่าเริง" | mkA "เบิกบาน" | mkA "เมาแล้ว" | mkA "ก้าวหน้า" | mkA "ฟุ่มเฟือย" | mkA "เบิกบานใจ" | mkA "ซึ่งอยู่สูง" ; -- src=panlex
lin about_Adv = mkAdv "หัน" | mkAdv "ทั่ว" | mkAdv "รอบๆ" | mkAdv "เกือบ" | mkAdv "ประมาณ" | mkAdv "จวนเจียน" | mkAdv "ทั่วๆ" | mkAdv "แพร่หลาย" | mkAdv "ในที่ต่างๆ" | mkAdv "ในทิศทางตรงข้าม" ; -- src=panlex
lin something_NP = mkNP (thword "บาง" "สิ่ง") ;
lin school_N = placeN (thword "โรง" "เรียน") | {-pan-} mkN "ร.ร." | mkN "รร." | mkN "สคูล" | mkN "สำนัก" | mkN "ฝูงปลา" | mkN "โรงเรียน" | mkN "เวลาเรียน" | mkN "อาคารเรียน" | mkN "การสอน" | mkN "ฝูงปลา" | mkN "การอบรม" | mkN "การศึกษา" | mkN "ภาคเรียน" | mkN "โรงเรียน" | mkN "การฝึกหัด" | mkN "สถานศึกษา" | mkN "เวลาเรียน" | mkN "ไปเป็นฝูง" | mkN "ระบบการศึกษา" | mkN "สถานที่เรียน" | mkN "กลุ่มนักเรียน" | mkN "สถาบันการศึกษา" | mkN "ฝูงปลาหรือสัตว์ทะเลอื่น" ; -- src=panlex
lin in_Adv = variants{}; -- ss (thword "ใน") | {-pan-} mkPrep "ใน" | mkPrep "ภายใน" | mkPrep "ข้างใน" | mkPrep "ในภาวะ" | mkPrep "ในสภาพ" | mkPrep "อยู่ภายใน" | mkPrep "ในระหว่าง" | mkPrep "อยู่ด้านใน" | mkPrep "ในข้อที่ว่า" ; -- src=panlex
lin in_1_Adv = variants{} ; -- 
lin in_2_Adv = variants{} ; -- 
lin small_A = mkA (thword "เล็ก") | {-pan-} mkA "เล็ก" | mkA "เล็กๆ" | mkA "ตัวน้อย" | mkA "ตัวเล็ก" | mkA "ที่มีขนาดเล็ก" | mkA "นิด" | mkA "จ้อย" | mkA "น้อย" | mkA "เล็ก" | mkA "บอบบาง" | mkA "ไม่มาก" | mkA "ตัวเล็ก" | mkA "ถ่อมตัว" | mkA "ยังเด็ก" | mkA "ยังเล็ก" | mkA "อ่อนแรง" | mkA "เล็กน้อย" | mkA "ไม่สําคัญ" | mkA "อ่อนกําลัง" | mkA "ไม่พอเพียง" | mkA "เป็นชิ้นเล็กชิ้นน้อย" ; -- src=panlex
lin place_N = mkN "จุด" | mkN "ที่" | mkN "แถว" | mkN "บ้าน" | mkN "สภาพ" | mkN "พลาซ่า" | mkN "สถาที่" | mkN "ตำแหน่ง" | mkN "ที่นั่ง" | mkN "สถานที่" | mkN "หน้าที่" | mkN "ช่องว่าง" | mkN "สถานการณ์" | mkN "ตำแหน่งหน้าที่" | mkN "จุด" | mkN "ที่" | mkN "เขต" | mkN "ฐานะ" | mkN "สภาพ" | mkN "เทศะ" | mkN "ทําเล" | mkN "บทบาท" | mkN "การงาน" | mkN "ที่พัก" | mkN "บริเวณ" | mkN "จุดหมาย" | mkN "ถิ่นฐาน" | mkN "ที่ตั้ง" | mkN "ที่นั่ง" | mkN "ประเด็น" | mkN "สถานที่" | mkN "หน้าที่" | mkN "ตําแหน่ง" | mkN "สถานการณ์" | mkN "สถานที่พัก" | mkN "ถิ่นที่อยู่" | mkN "เก้าอี้นั่ง" | mkN "ที่อยู่อาศัย" | mkN "ตําแหน่งในทีม" | mkN "โอกาสในการเรียน" | mkN "อันดับในการแข่งขัน" ; -- src=panlex
lin before_Prep = ss "ก่อน" | {-pan-} mkPrep "กว่า" | mkPrep "ก่อน" | mkPrep "หน้า" | mkPrep "คอยอยู่" | mkPrep "ตรงหน้า" | mkPrep "ในอนาคต" | mkPrep "ก่อนหน้า" | mkPrep "อยู่หน้า" | mkPrep "ภายใต้อิทธิพลของ" ; -- src=panlex
lin while_Subj = variants{} ; -- 
lin away_Adv = variants{} ; -- 
lin away_2_Adv = variants{} ; -- 
lin away_1_Adv = variants{} ; -- 
lin keep_VV = mkVV "คง" ; ---- | mkV "จอง" | mkV "ตุน" | mkV "จ้าง" | mkV "ดูแล" | mkV "เก็บ" | mkV "เฝ้า" | mkV "คงไว้" | mkV "ยังคง" | mkV "รักษา" | mkV "เลี้ยง" | mkV "ป้องกัน" | mkV "เก็บไว้" | mkV "คงความสด" | mkV "รักษาไว้" | mkV "สนับสนุน" | mkV "ส่งเสริม" | mkV "ให้ทำงาน" | mkV "กักบริเวณ" | mkV "จัดที่พัก" | mkV "ถนอมอาหาร" | mkV "บันทึกไว้" | mkV "เก็บอาหาร" | mkV "ซื้อทิ้งไว้" | mkV "ซื้อเก็บไว้" | mkV "ให้การสนับสนุน" | mkV "รักษาความปลอดภัย" | mkV "คุม" | mkV "ดูแล" | mkV "พยุง" | mkV "เก็บ" | mkV "รักษา" | mkV "ควบคุม" | mkV "ประคอง" | mkV "เลี้ยง" | mkV "ป้องกัน" | mkV "สงวนไว้" | mkV "เก็บไว้" | mkV "เลี้ยงดู" | mkV "เก็บรักษา" | mkV "ทําเรื่อยไป" | mkV "ดําเนินต่อไป" | mkV "ดําเนินเรื่อยไป" ; -- src=panlex
lin keep_V2A = mmkV2A "คง" ; ---- | mkV "จอง" | mkV "ตุน" | mkV "จ้าง" | mkV "ดูแล" | mkV "เก็บ" | mkV "เฝ้า" | mkV "คงไว้" | mkV "ยังคง" | mkV "รักษา" | mkV "เลี้ยง" | mkV "ป้องกัน" | mkV "เก็บไว้" | mkV "คงความสด" | mkV "รักษาไว้" | mkV "สนับสนุน" | mkV "ส่งเสริม" | mkV "ให้ทำงาน" | mkV "กักบริเวณ" | mkV "จัดที่พัก" | mkV "ถนอมอาหาร" | mkV "บันทึกไว้" | mkV "เก็บอาหาร" | mkV "ซื้อทิ้งไว้" | mkV "ซื้อเก็บไว้" | mkV "ให้การสนับสนุน" | mkV "รักษาความปลอดภัย" | mkV "คุม" | mkV "ดูแล" | mkV "พยุง" | mkV "เก็บ" | mkV "รักษา" | mkV "ควบคุม" | mkV "ประคอง" | mkV "เลี้ยง" | mkV "ป้องกัน" | mkV "สงวนไว้" | mkV "เก็บไว้" | mkV "เลี้ยงดู" | mkV "เก็บรักษา" | mkV "ทําเรื่อยไป" | mkV "ดําเนินต่อไป" | mkV "ดําเนินเรื่อยไป" ; -- src=panlex
lin keep_V2 = mkV2 "คง" ; ---- | mkV "จอง" | mkV "ตุน" | mkV "จ้าง" | mkV "ดูแล" | mkV "เก็บ" | mkV "เฝ้า" | mkV "คงไว้" | mkV "ยังคง" | mkV "รักษา" | mkV "เลี้ยง" | mkV "ป้องกัน" | mkV "เก็บไว้" | mkV "คงความสด" | mkV "รักษาไว้" | mkV "สนับสนุน" | mkV "ส่งเสริม" | mkV "ให้ทำงาน" | mkV "กักบริเวณ" | mkV "จัดที่พัก" | mkV "ถนอมอาหาร" | mkV "บันทึกไว้" | mkV "เก็บอาหาร" | mkV "ซื้อทิ้งไว้" | mkV "ซื้อเก็บไว้" | mkV "ให้การสนับสนุน" | mkV "รักษาความปลอดภัย" | mkV "คุม" | mkV "ดูแล" | mkV "พยุง" | mkV "เก็บ" | mkV "รักษา" | mkV "ควบคุม" | mkV "ประคอง" | mkV "เลี้ยง" | mkV "ป้องกัน" | mkV "สงวนไว้" | mkV "เก็บไว้" | mkV "เลี้ยงดู" | mkV "เก็บรักษา" | mkV "ทําเรื่อยไป" | mkV "ดําเนินต่อไป" | mkV "ดําเนินเรื่อยไป" ; -- src=panlex
lin keep_V = mkV "คง" | mkV "จอง" | mkV "ตุน" | mkV "จ้าง" | mkV "ดูแล" | mkV "เก็บ" | mkV "เฝ้า" | mkV "คงไว้" | mkV "ยังคง" | mkV "รักษา" | mkV "เลี้ยง" | mkV "ป้องกัน" | mkV "เก็บไว้" | mkV "คงความสด" | mkV "รักษาไว้" | mkV "สนับสนุน" | mkV "ส่งเสริม" | mkV "ให้ทำงาน" | mkV "กักบริเวณ" | mkV "จัดที่พัก" | mkV "ถนอมอาหาร" | mkV "บันทึกไว้" | mkV "เก็บอาหาร" | mkV "ซื้อทิ้งไว้" | mkV "ซื้อเก็บไว้" | mkV "ให้การสนับสนุน" | mkV "รักษาความปลอดภัย" | mkV "คุม" | mkV "ดูแล" | mkV "พยุง" | mkV "เก็บ" | mkV "รักษา" | mkV "ควบคุม" | mkV "ประคอง" | mkV "เลี้ยง" | mkV "ป้องกัน" | mkV "สงวนไว้" | mkV "เก็บไว้" | mkV "เลี้ยงดู" | mkV "เก็บรักษา" | mkV "ทําเรื่อยไป" | mkV "ดําเนินต่อไป" | mkV "ดําเนินเรื่อยไป" ; -- src=panlex
lin point_N = variants{} ; -- 
lin point_2_N = variants{} ; -- 
lin point_1_N = variants{} ; -- 
lin house_N = mkN baan_s lag_s | {-pan-} mkN "โรง" | mkN "บ้าน" | mkN "ราศี" | mkN "เรือน" | mkN "บริษัท" | mkN "ที่บ้าน" | mkN "ราชสกุล" | mkN "โรงละคร" | mkN "ครอบครัว" | mkN "โรงมหรสพ" | mkN "โรงเรือน" | mkN "ราชตระกูล" | mkN "เธียเตอร์" | mkN "สมาชิกชุมชน" | mkN "ผู้ชมในโรงละคร" | mkN "สถานที่แสดงละคร" | mkN "ห้างหุ้นส่วนจำกัด" | mkN "การเล่นเป็นพ่อแม่ลูก" | mkN "มี" | mkN "สภา" | mkN "โรง" | mkN "บ้าน" | mkN "เรือน" | mkN "เหย้า" | mkN "ตระกูล" | mkN "รัฐสภา" | mkN "สถาบัน" | mkN "ที่อยู่" | mkN "หลบซ่อน" | mkN "ห้องโถง" | mkN "ครอบครัว" | mkN "โรงเรือน" | mkN "วงศ์ตระกูล" | mkN "คนดูในโรงภาพยนตร์" ; -- src=panlex
lin different_A = mkA "ต่าง" | mkA "แตกต่าง" | mkA "ผิดกัน" | mkA "ต่างกัน" | mkA "ผิดปกติ" | mkA "ผิดแปลก" | mkA "ไม่ปกติ" | mkA "ผิดปกติ’" | mkA "หลากหลาย" | mkA "ผิดธรรมดา" | mkA "ไม่ธรรมดา" | mkA "แตกต่างกัน" | mkA "ไม่เหมือนกัน" ; -- src=panlex
lin country_N = placeN (thword "ประ" "เทศ") | {-pan-} mkN "ปท." | mkN "พท." | mkN "รัฐ" | mkN "เขต" | mkN "ชนบท" | mkN "ชาติ" | mkN "ถิ่น" | mkN "ประเทศ" | mkN "ท้องที่" | mkN "บ้านนอก" | mkN "พลเมือง" | mkN "พื้นที่" | mkN "รัฐชาติ" | mkN "คนในชาติ" | mkN "เนื้อที่" | mkN "คนในประเทศ" | mkN "ประเทศชาติ" | mkN "เขตพื้นที่" | mkN "ต่างจังหวัด" | mkN "ประชาชนพลเมือง" | mkN "ประชาชนในประเทศ" | mkN "รัฐ" | mkN "ชนบท" | mkN "เมือง" | mkN "ประเทศ" | mkN "บ้านนอก" | mkN "ภูมิลําเนา" | mkN "ถิ่นที่อยู่" | mkN "ถิ่นบ้านนอก" | mkN "รัฐหรือชาติ" | mkN "ประชาชนในประเทศ" | mkN "เกี่ยวกับประเทศ" | mkN "แผ่นดินของประเทศ" | mkN "ประชากรของท้องถิ่น" | mkN "พื้นที่ทําการเกษตร" ; -- src=panlex
lin really_Adv = variants{} ; -- 
lin provide_V2 = mkV2 "จัดให้" ; ---- | mkV "มีโอกาส" | mkV "จัดเตรียม" | mkV "ทำงานหาเงิน" | mkV "ให้สิ่งจำเป็น" | mkV "มีความเป็นไปได้" | mkV "จัดหาให้" | mkV "จัดเตรียมไว้ให้" ; -- src=panlex
lin provide_V = mkV "จัดให้" | mkV "มีโอกาส" | mkV "จัดเตรียม" | mkV "ทำงานหาเงิน" | mkV "ให้สิ่งจำเป็น" | mkV "มีความเป็นไปได้" | mkV "จัดหาให้" | mkV "จัดเตรียมไว้ให้" ; -- src=panlex
lin week_N = mkN "วีก" | mkN "วีค" | mkN "สัปดาห์" | mkN "อาทิตย์" | mkN "สัปดาห์" | mkN "อาทิตย์" | mkN "หนึ่งสัปดาห์" | mkN "หนึ่งอาทิตย์" | mkN "ช่วงระยะเวลา 7 วันติดต่อกัน" ; -- src=panlex
lin hold_VS = mmkVS "จุ" ; ---- | mkV "มี" | mkV "ยก" | mkV "ค้ำ" | mkV "จอง" | mkV "จัด" | mkV "ถือ" | mkV "ยึด" | mkV "ยืด" | mkV "รอง" | mkV "ดื่ม" | mkV "ตรึง" | mkV "หนุน" | mkV "หยุด" | mkV "เชิด" | mkV "เล็ง" | mkV "เห็น" | mkV "บรรจุ" | mkV "รักษา" | mkV "ควบคุม" | mkV "ตัดสิน" | mkV "ผูกมัด" | mkV "ยืนยัน" | mkV "รองรับ" | mkV "วางสาย" | mkV "นำมาใช้" | mkV "ยังคงทำ" | mkV "ยับยั้ง" | mkV "ถอนหายใจ" | mkV "เป็นจริง" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "ยังคงอยู่" | mkV "ใช้สิทธิ์" | mkV "รับน้ำหนัก" | mkV "เบียดเสียด" | mkV "เก็บไว้ในใจ" | mkV "ได้รับสิทธิ์" | mkV "ป้องกันการโจมตี" | mkV "กอด" | mkV "อุ้ม" | mkV "กลั้น" | mkV "บรรจุ" | mkV "กําไว้" | mkV "จัดแจง" | mkV "จับไว้" | mkV "บรรทุก" | mkV "ยึดติด" | mkV "ใส่ได้" | mkV "คว้าไว้" | mkV "สงวนไว้" | mkV "อดกลั้น" | mkV "เกาะติด" | mkV "ครอบครอง" | mkV "รักษาไว้" | mkV "เชื่อว่า" | mkV "จัดเตรียม" | mkV "เข้าใจว่า" | mkV "เตรียมการ" | mkV "เก็บเอาไว้" | mkV "เป็นเจ้าของ" | mkV "ทําให้ล่าช้า" | mkV "ทําให้หยุดชะงัก" ; -- src=panlex
lin hold_V2 = mkV2 (thword "รั้ง") ;
lin hold_V = mkV "จุ" | mkV "มี" | mkV "ยก" | mkV "ค้ำ" | mkV "จอง" | mkV "จัด" | mkV "ถือ" | mkV "ยึด" | mkV "ยืด" | mkV "รอง" | mkV "ดื่ม" | mkV "ตรึง" | mkV "หนุน" | mkV "หยุด" | mkV "เชิด" | mkV "เล็ง" | mkV "เห็น" | mkV "บรรจุ" | mkV "รักษา" | mkV "ควบคุม" | mkV "ตัดสิน" | mkV "ผูกมัด" | mkV "ยืนยัน" | mkV "รองรับ" | mkV "วางสาย" | mkV "นำมาใช้" | mkV "ยังคงทำ" | mkV "ยับยั้ง" | mkV "ถอนหายใจ" | mkV "เป็นจริง" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "ยังคงอยู่" | mkV "ใช้สิทธิ์" | mkV "รับน้ำหนัก" | mkV "เบียดเสียด" | mkV "เก็บไว้ในใจ" | mkV "ได้รับสิทธิ์" | mkV "ป้องกันการโจมตี" | mkV "กอด" | mkV "อุ้ม" | mkV "กลั้น" | mkV "บรรจุ" | mkV "กําไว้" | mkV "จัดแจง" | mkV "จับไว้" | mkV "บรรทุก" | mkV "ยึดติด" | mkV "ใส่ได้" | mkV "คว้าไว้" | mkV "สงวนไว้" | mkV "อดกลั้น" | mkV "เกาะติด" | mkV "ครอบครอง" | mkV "รักษาไว้" | mkV "เชื่อว่า" | mkV "จัดเตรียม" | mkV "เข้าใจว่า" | mkV "เตรียมการ" | mkV "เก็บเอาไว้" | mkV "เป็นเจ้าของ" | mkV "ทําให้ล่าช้า" | mkV "ทําให้หยุดชะงัก" ; -- src=panlex
lin large_A = mkA "ใหญ่" | mkA "ที่คุยโว" | mkA "ใหญ่" | mkA "กว้าง" | mkA "ใหญ่โต" | mkA "ส่วนมาก" | mkA "กว้างขวาง" | mkA "อย่างคุยโว" | mkA "อย่างมากมาย" | mkA "ใหญ่โตมหึมา" ; -- src=panlex
lin member_N = mkN "ลึงค์" | mkN "สมาชิก" | mkN "องคชาต" | mkN "เมมเบอร์" | mkN "พระคุยหฐาน" | mkN "องค์กรสมาชิก" | mkN "พระคุยหประเทศ" | mkN "ส่วนที่ยื่นออกจากร่างกาย" | mkN "องค์" | mkN "" | mkN "หน่วย" | mkN "ชาวคณะ" | mkN "สมาชิก" | mkN "ส่วนประกอบ" | mkN "องค์ประกอบ" | mkN "พวกองค์ประกอบ" | mkN "ส่วนของร่างกาย" | mkN "ผู้เป็นส่วนหนึ่งของกลุ่ม" ; -- src=panlex
lin off_Adv = mkAdv "ห่าง" | mkAdv "ไปที่อื่น" | mkAdv "ไป" | mkAdv "ขาด" | mkAdv "พัก" | mkAdv "พ้น" | mkAdv "ออก" | mkAdv "ว่าง" | mkAdv "หลุด" | mkAdv "ห่าง" | mkAdv "จากไป" | mkAdv "พ้นไป" | mkAdv "อิสระ" | mkAdv "ขาดออก" | mkAdv "หักออก" | mkAdv "ออกจาก" | mkAdv "เอาออก" | mkAdv "ไปเสีย" | mkAdv "ผิดปกติ" | mkAdv "ลดลงจาก" | mkAdv "หยุดงาน" | mkAdv "หยุดพัก" | mkAdv "สิ้นเชิง" | mkAdv "ไกลออกไป" | mkAdv "ห่างออกไป" | mkAdv "แยกออกจาก" | mkAdv "ไม่ทํางาน" | mkAdv "ไม่เป็นผล" | mkAdv "ผิดมาตรฐาน" | mkAdv "หยุดทํางาน" | mkAdv "แยกออกมาจาก" | mkAdv "ไม่เป็นที่พอใจ" ; -- src=panlex
lin always_Adv = mkAdv "ตลอดเวลา" | mkAdv "อย่างสม่ำเสมอ" | mkAdv "อย่างไม่มีหยุด" | mkAdv "อย่างไม่เปลี่ยนแปลง" | mkAdv "เสมอ" | mkAdv "ทุกที" | mkAdv "บ่อยๆ" | mkAdv "เสมอๆ" | mkAdv "ตลอดไป" | mkAdv "ตายตัว" | mkAdv "ทุกคราว" | mkAdv "เด็ดขาด" | mkAdv "ตลอดเวลา" | mkAdv "ทุกครั้ง" | mkAdv "เป็นประจํา" | mkAdv "โดยไม่มีเงื่อนไข" | mkAdv "โดยไม่มีการยกเว้น" ; -- src=panlex
lin follow_VS = mmkVS "ตาม" ; ---- | mkV "เป็น" | mkV "ทำตาม" | mkV "มาจาก" | mkV "ตามทัน" | mkV "ติดตาม" | mkV "ต่อจาก" | mkV "ยึดตาม" | mkV "ไล่ตาม" | mkV "จับตาดู" | mkV "ตามด้วย" | mkV "นำมาใช้" | mkV "คลอเสียง" | mkV "ตามลำดับ" | mkV "เอาอย่าง" | mkV "ไปตามทาง" | mkV "เป็นผลจาก" | mkV "ตามรอยเท้า" | mkV "ปฏิบัติตาม" | mkV "รับช่วงต่อ" | mkV "เฝ้าติดตาม" | mkV "ดำเนินต่อไป" | mkV "ตาม" | mkV "ติดตาม" | mkV "ทําตาม" | mkV "ไล่ตาม" | mkV "ตามหลัง" | mkV "เดินตาม" | mkV "ตามอย่าง" | mkV "เชื่อฟัง" | mkV "เลียนแบบ" | mkV "เอาอย่าง" | mkV "ปฏิบัติตาม" | mkV "เจริญรอยตาม" | mkV "เป็นผลมาจาก" | mkV "พยายามทําให้เหมือน" ; -- src=panlex
lin follow_V2 = mkV2 "ตาม" ; ---- | mkV "เป็น" | mkV "ทำตาม" | mkV "มาจาก" | mkV "ตามทัน" | mkV "ติดตาม" | mkV "ต่อจาก" | mkV "ยึดตาม" | mkV "ไล่ตาม" | mkV "จับตาดู" | mkV "ตามด้วย" | mkV "นำมาใช้" | mkV "คลอเสียง" | mkV "ตามลำดับ" | mkV "เอาอย่าง" | mkV "ไปตามทาง" | mkV "เป็นผลจาก" | mkV "ตามรอยเท้า" | mkV "ปฏิบัติตาม" | mkV "รับช่วงต่อ" | mkV "เฝ้าติดตาม" | mkV "ดำเนินต่อไป" | mkV "ตาม" | mkV "ติดตาม" | mkV "ทําตาม" | mkV "ไล่ตาม" | mkV "ตามหลัง" | mkV "เดินตาม" | mkV "ตามอย่าง" | mkV "เชื่อฟัง" | mkV "เลียนแบบ" | mkV "เอาอย่าง" | mkV "ปฏิบัติตาม" | mkV "เจริญรอยตาม" | mkV "เป็นผลมาจาก" | mkV "พยายามทําให้เหมือน" ; -- src=panlex
lin follow_V = mkV "ตาม" | mkV "เป็น" | mkV "ทำตาม" | mkV "มาจาก" | mkV "ตามทัน" | mkV "ติดตาม" | mkV "ต่อจาก" | mkV "ยึดตาม" | mkV "ไล่ตาม" | mkV "จับตาดู" | mkV "ตามด้วย" | mkV "นำมาใช้" | mkV "คลอเสียง" | mkV "ตามลำดับ" | mkV "เอาอย่าง" | mkV "ไปตามทาง" | mkV "เป็นผลจาก" | mkV "ตามรอยเท้า" | mkV "ปฏิบัติตาม" | mkV "รับช่วงต่อ" | mkV "เฝ้าติดตาม" | mkV "ดำเนินต่อไป" | mkV "ตาม" | mkV "ติดตาม" | mkV "ทําตาม" | mkV "ไล่ตาม" | mkV "ตามหลัง" | mkV "เดินตาม" | mkV "ตามอย่าง" | mkV "เชื่อฟัง" | mkV "เลียนแบบ" | mkV "เอาอย่าง" | mkV "ปฏิบัติตาม" | mkV "เจริญรอยตาม" | mkV "เป็นผลมาจาก" | mkV "พยายามทําให้เหมือน" ; -- src=panlex
lin without_Prep = ss (thword "ไม่" "มี") | {-pan-} mkPrep "นอก" | mkPrep "พ้น" | mkPrep "ไม่มี" | mkPrep "ภายนอก" | mkPrep "ข้างนอก" | mkPrep "ปราศจาก" | mkPrep "โดยไม่มี" | mkPrep "โดยปราศจาก" ; -- src=panlex
lin turn_VA = mmkVA (thword "หัน") ; ---- | {-pan-} mkV "งอ" | mkV "บิด" | mkV "บูด" | mkV "หัก" | mkV "หัน" | mkV "ได้" | mkV "กลึง" | mkV "พลิก" | mkV "หมุน" | mkV "แพลง" | mkV "ไถดิน" | mkV "ได้รับ" | mkV "ทำให้งอ" | mkV "หันไปหา" | mkV "เข้าสู่" | mkV "เปลี่ยน" | mkV "กลายเป็น" | mkV "เปลี่ยนสี" | mkV "ปล่อยให้ไป" | mkV "กลับตาลปัตร" | mkV "เคลื่อนผ่าน" | mkV "เปลี่ยนสภาพ" | mkV "ทำให้เปลี่ยนสภาพ" | mkV "บูด" | mkV "หัน" | mkV "เบน" | mkV "ยุยง" | mkV "ย้อน" | mkV "เสีย" | mkV "แปลง" | mkV "ปล่อย" | mkV "เบี่ยง" | mkV "เลี้ยว" | mkV "ถอยหลัง" | mkV "เปลี่ยน" | mkV "กลายเป็น" | mkV "ย้อนกลับ" | mkV "ทําให้เชื่อ" | mkV "เปลี่ยนถ่าย" | mkV "เปลี่ยนเป็น" | mkV "เปลี่ยนแปลง" ; -- src=panlex
lin turn_V2 = mkV2 (thword "หัน") ; ---- | {-pan-} mkV "งอ" | mkV "บิด" | mkV "บูด" | mkV "หัก" | mkV "หัน" | mkV "ได้" | mkV "กลึง" | mkV "พลิก" | mkV "หมุน" | mkV "แพลง" | mkV "ไถดิน" | mkV "ได้รับ" | mkV "ทำให้งอ" | mkV "หันไปหา" | mkV "เข้าสู่" | mkV "เปลี่ยน" | mkV "กลายเป็น" | mkV "เปลี่ยนสี" | mkV "ปล่อยให้ไป" | mkV "กลับตาลปัตร" | mkV "เคลื่อนผ่าน" | mkV "เปลี่ยนสภาพ" | mkV "ทำให้เปลี่ยนสภาพ" | mkV "บูด" | mkV "หัน" | mkV "เบน" | mkV "ยุยง" | mkV "ย้อน" | mkV "เสีย" | mkV "แปลง" | mkV "ปล่อย" | mkV "เบี่ยง" | mkV "เลี้ยว" | mkV "ถอยหลัง" | mkV "เปลี่ยน" | mkV "กลายเป็น" | mkV "ย้อนกลับ" | mkV "ทําให้เชื่อ" | mkV "เปลี่ยนถ่าย" | mkV "เปลี่ยนเป็น" | mkV "เปลี่ยนแปลง" ; -- src=panlex
lin turn_V = mkV (thword "หัน") | {-pan-} mkV "งอ" | mkV "บิด" | mkV "บูด" | mkV "หัก" | mkV "หัน" | mkV "ได้" | mkV "กลึง" | mkV "พลิก" | mkV "หมุน" | mkV "แพลง" | mkV "ไถดิน" | mkV "ได้รับ" | mkV "ทำให้งอ" | mkV "หันไปหา" | mkV "เข้าสู่" | mkV "เปลี่ยน" | mkV "กลายเป็น" | mkV "เปลี่ยนสี" | mkV "ปล่อยให้ไป" | mkV "กลับตาลปัตร" | mkV "เคลื่อนผ่าน" | mkV "เปลี่ยนสภาพ" | mkV "ทำให้เปลี่ยนสภาพ" | mkV "บูด" | mkV "หัน" | mkV "เบน" | mkV "ยุยง" | mkV "ย้อน" | mkV "เสีย" | mkV "แปลง" | mkV "ปล่อย" | mkV "เบี่ยง" | mkV "เลี้ยว" | mkV "ถอยหลัง" | mkV "เปลี่ยน" | mkV "กลายเป็น" | mkV "ย้อนกลับ" | mkV "ทําให้เชื่อ" | mkV "เปลี่ยนถ่าย" | mkV "เปลี่ยนเป็น" | mkV "เปลี่ยนแปลง" ; -- src=panlex
lin end_N = variants{} ; -- 
lin end_2_N = variants{} ; -- 
lin end_1_N = variants{} ; -- 
lin within_Prep = mkPrep "ภายใน" | mkPrep "ข้างใน" | mkPrep "ส่วนใน" | mkPrep "อยู่ภายใน" | mkPrep "ภายในขอบเขตของ" | mkPrep "ภายในร่างกายหรือจิตใจ" ; -- src=panlex
lin local_A = mkA "ท้องถิ่น" | mkA "ภายในท้องถิ่น" | mkA "เฉพาะที่" | mkA "เฉพาะแห่ง" | mkA "คนท้องถิ่น" | mkA "ของพื้นเมือง" | mkA "ส่วนท้องถิ่น" | mkA "แห่งท้องถิ่น" | mkA "สาขาของสมาคม สโมสร สหภาพหรือองค์การ" | mkA "มีผลเฉพาะแห่ง" | mkA "เฉพาะท้องถิ่น" | mkA "ประจําท้องถิ่น" | mkA "ของชาวพื้นเมือง" | mkA "มีผลเฉพาะที่ในร่างกาย" | mkA "ร้านเหล้าประจําท้องถิ่น" ; -- src=panlex
lin where_Subj = variants{} ; -- 
lin during_Prep = ss (thword "ระ" "หว่าง") | {-pan-} mkPrep "ในระหว่าง" | mkPrep "ระหว่างเวลา" ; -- src=panlex
lin bring_V3 = variants{} ; -- 
lin bring_V2 = variants{} ; -- 
lin most_Det = variants{} ; -- 
lin word_N = mkN "คำ" | mkN "ข่าว" | mkN "คำสั่ง" | mkN "เวิร์ด" | mkN "ข่าวสาร" | mkN "รหัสผ่าน" | mkN "การรับปาก" | mkN "พาสเวิร์ด" | mkN "การอภิปราย" | mkN "การตกปากรับคำ" | mkN "ข้อมูลข่าวสาร" | mkN "คำ" | mkN "คํา" | mkN "ข่าว" | mkN "ภาษา" | mkN "รหัส" | mkN "ศัพท์" | mkN "ข้อมูล" | mkN "คําพูด" | mkN "ข่าวลือ" | mkN "ข่าวสาร" | mkN "คติพจน์" | mkN "คําผ่าน" | mkN "คํามั่น" | mkN "คําสั่ง" | mkN "ถ้อยคํา" | mkN "คํานินทา" | mkN "คําบัญชา" | mkN "คําศัพท์" | mkN "คําสนทนา" | mkN "คําสัญญา" | mkN "ศัพท์โดด ๆ" | mkN "คําซุบซิบ" | mkN "คํารับรอง" | mkN "เนื้อร้อง" | mkN "เนื้อเพลง" | mkN "คําบอกรหัส" | mkN "คําโต้แย้ง" | mkN "การออกเสียง" | mkN "คํารับประกัน" | mkN "คําพูดแบบฉุนๆ" | mkN "คําพูดโต้เถียง" | mkN "คํายินยอมให้ผ่าน" ; -- src=panlex
lin begin_V2 = mkV2 "เริ่ม" ; ---- | mkV "เริ่มต้น" | mkV "เริ่มที่" | mkV "เริ่มขึ้น" | mkV "เริ่มด้วย" | mkV "เริ่ม" | mkV "ก่อตั้ง" | mkV "ขึ้นต้น" | mkV "ตั้งต้น" | mkV "เกิดขึ้น" | mkV "เริ่มต้น" ; -- src=panlex
lin begin_V = mkV "เริ่ม" | mkV "เริ่มต้น" | mkV "เริ่มที่" | mkV "เริ่มขึ้น" | mkV "เริ่มด้วย" | mkV "เริ่ม" | mkV "ก่อตั้ง" | mkV "ขึ้นต้น" | mkV "ตั้งต้น" | mkV "เกิดขึ้น" | mkV "เริ่มต้น" ; -- src=panlex
lin although_Subj = ss "ถืง" ;
lin example_N = mkN "เคส" | mkN "กรณี" | mkN "ตัวอย่าง" | mkN "แบบอย่าง" | mkN "แบบฝึกหัด" | mkN "การลงโทษเป็นเยี่ยงอย่าง" | mkN "ตัวอย่าง" | mkN "แบบอย่าง" ; -- src=panlex
lin next_Adv = variants{} ; -- 
lin family_N = mkN "คลาส" | mkN "ญาติ" | mkN "บ้าน" | mkN "วงศ์" | mkN "สมาคม" | mkN "ตระกูล" | mkN "ประเภท" | mkN "ที่บ้าน" | mkN "วงศ์วาน" | mkN "ครอบครัว" | mkN "วงศ์ตระกูล" | mkN "วงศ์วานว่านเครือ" | mkN "ลูก" | mkN "ครัว" | mkN "สกุล" | mkN "พันธ์" | mkN "ตระกูล" | mkN "ลูกหลาน" | mkN "ครอบครัว" | mkN "วงศ์ญาติ" | mkN "สายเลือด" | mkN "เครือญาติ" | mkN "วงศ์ตระกูล" | mkN "สมาชิกในครอบครัว" ; -- src=panlex
lin rather_Adv = mkAdv "แทน" | mkAdv "อยาก" | mkAdv "ออกจะ" | mkAdv "อยากจะ" | mkAdv "พอสมควร" | mkAdv "มากกว่า" | mkAdv "ค่อนข้าง" | mkAdv "ค่อนข้างจะ" | mkAdv "ตรงกันข้าม" | mkAdv "ถ้าจะพูดให้ถูก" | mkAdv "ในทางตรงกันข้าม" ; -- src=panlex
lin fact_N = mkN "แฟ็กต์" | mkN "ความจริง" | mkN "ข้อเท็จจริง" | mkN "ความจริง" | mkN "ข้อเท็จจริง" | mkN "ความเป็นจริง" | mkN "ส่วนของข้อมูล" ; -- src=panlex
lin like_VV = variants{}; -- mkV2 (mkV "ชอบ") ;
lin like_VS = variants{}; -- mkV2 (mkV "ชอบ") ;
lin like_V2 = mkV2 (mkV "ชอบ") ;
lin social_A = mkA "ของสังคม" | mkA "เกี่ยวกับสังคม" | mkA "เกี่ยวกับสังคมนิยม" | mkA "เกี่ยวกับการอยู่ร่วมกัน" | mkA "เกี่ยวกับการอยู่เป็นหมู่" ; -- src=panlex
lin write_VS = mmkVS "เซฟ" ; ---- | mkV "รจนา" | mkV "สะกด" | mkV "แต่ง" | mkV "เขียน" | mkV "เซฟงาน" | mkV "ตีพิมพ์" | mkV "เซฟไฟล์" | mkV "เขียนจม." | mkV "ขีดเขียน" | mkV "ประพันธ์" | mkV "แต่งเพลง" | mkV "เขียนเพลง" | mkV "เขียนจดหมาย" | mkV "บันทึกข้อมูล" | mkV "ประพันธ์เพลง" | mkV "เขียนหนังสือ" | mkV "บันทึกข้อมูลลงคอมพิวเตอร์" | mkV "จด" | mkV "แต้ม" | mkV "จารึก" | mkV "เขียน" | mkV "เขียนหนังสือ" ; -- src=panlex
lin write_V2 = mkV2 "เขียน" ;
lin write_V = mkV "เซฟ" | mkV "รจนา" | mkV "สะกด" | mkV "แต่ง" | mkV "เขียน" | mkV "เซฟงาน" | mkV "ตีพิมพ์" | mkV "เซฟไฟล์" | mkV "เขียนจม." | mkV "ขีดเขียน" | mkV "ประพันธ์" | mkV "แต่งเพลง" | mkV "เขียนเพลง" | mkV "เขียนจดหมาย" | mkV "บันทึกข้อมูล" | mkV "ประพันธ์เพลง" | mkV "เขียนหนังสือ" | mkV "บันทึกข้อมูลลงคอมพิวเตอร์" | mkV "จด" | mkV "แต้ม" | mkV "จารึก" | mkV "เขียน" | mkV "เขียนหนังสือ" ; -- src=panlex
lin state_N = variants{} ; -- 
lin state_2_N = variants{} ; -- 
lin state_1_N = variants{} ; -- 
lin percent_N = mkN "ร้อยละ" | mkN "เปอร์เซนต์" | mkN "เปอร์-เซ็นต์" | mkN "ร้อยละ" | mkN "ส่วนร้อย" | mkN "เป็นร้อยละ" | mkN "เปอร์เซ็นต์" ; -- src=panlex
lin quite_Adv = ss (thword "ค่อน" "ข้าง") | {-pan-} mkAdv "จริง ๆ" | mkAdv "มากมาย" | mkAdv "ทั้งหมด" | mkAdv "ทีเดียว" | mkAdv "ค่อนข้างจะ" | mkAdv "โดยสมบูรณ์" | mkAdv "โดยแท้จริง" | mkAdv "อย่างแท้จริง" ; -- src=panlex
lin both_Det = variants{} ; -- 
lin start_V2 = mkV2 "ไป" ; ---- | mkV "นูน" | mkV "ถลึง" | mkV "เริ่ม" | mkV "สะดุ้ง" | mkV "ริเริ่ม" | mkV "เริ่มงาน" | mkV "เริ่มต้น" | mkV "เริ่มที่" | mkV "เริ่มด้วย" | mkV "สะดุ้งโหยง" | mkV "ออกเดินทาง" | mkV "เดินเครื่อง" | mkV "เล่นเป็นตัวจริง" | mkV "ลงมือ" | mkV "เริ่ม" | mkV "เริ่มต้น" | mkV "เริ่มทํา" | mkV "ทําให้เกิด" ; -- src=panlex
lin start_V = mkV "ไป" | mkV "นูน" | mkV "ถลึง" | mkV "เริ่ม" | mkV "สะดุ้ง" | mkV "ริเริ่ม" | mkV "เริ่มงาน" | mkV "เริ่มต้น" | mkV "เริ่มที่" | mkV "เริ่มด้วย" | mkV "สะดุ้งโหยง" | mkV "ออกเดินทาง" | mkV "เดินเครื่อง" | mkV "เล่นเป็นตัวจริง" | mkV "ลงมือ" | mkV "เริ่ม" | mkV "เริ่มต้น" | mkV "เริ่มทํา" | mkV "ทําให้เกิด" ; -- src=panlex
lin run_V2 = mkV2 "วิ่ง" ; ---- | {-pan-} mkV "รัน" | mkV "ล่า" | mkV "ไหล" | mkV "กวาด" | mkV "ผ่าน" | mkV "พุ่ง" | mkV "เล่น" | mkV "ทำงาน" | mkV "ละลาย" | mkV "ไปไกล" | mkV "ดำเนิน" | mkV "คลายออก" | mkV "วิ่งหนี" | mkV "เผ่นหนี" | mkV "ล่าสัตว์" | mkV "วิ่งแข่ง" | mkV "ออกอากาศ" | mkV "มีความยาว" | mkV "มีแนวโน้ม" | mkV "ยังคงอยู่" | mkV "ลากเลื้อย" | mkV "เลี้ยงลูก" | mkV "ติดเครื่อง" | mkV "ทำไม่เสร็จ" | mkV "รีบเดินทาง" | mkV "เดินทางไปมา" | mkV "ลงชิงตำแหน่ง" | mkV "แล่นเรือตามลม" | mkV "ค้าของผิดกฎหมาย" | mkV "เกิดขึ้นอย่างติดต่อกัน" | mkV "ริน" | mkV "หนี" | mkV "ไหล" | mkV "แพร่" | mkV "แล่น" | mkV "กลิ้ง" | mkV "รีบไป" | mkV "กระจาย" | mkV "กินเวลา" | mkV "พาไปส่ง" | mkV "รีบเร่ง" | mkV "วิ่งควบ" | mkV "วิ่งหนี" | mkV "เล่าลือ" | mkV "ใช้เวลา" | mkV "วิ่งแข่ง" | mkV "เข้าร่วม" | mkV "ดําเนินการ" | mkV "ปฎิบัติการ" | mkV "เดินเครื่อง" | mkV "เปิดเครื่อง" | mkV "เยี่ยมเยียน" | mkV "มีผลตามกฎหมาย" | mkV "เคลื่อนผ่านไป" | mkV "ทําให้แพร่กระจาย" | mkV "ไปขอความช่วยเหลือ" | mkV "ผ่านไปอย่างรวดเร็ว" | mkV "ว่ายทวนน้ําไปวางไข่" | mkV "ลักลอบขนส่งผิดกฎหมาย" | mkV "เข้าสมัครรับเลือกตั้ง" ; -- src=panlex
lin run_V = mkV "วิ่ง" | {-pan-} mkV "รัน" | mkV "ล่า" | mkV "ไหล" | mkV "กวาด" | mkV "ผ่าน" | mkV "พุ่ง" | mkV "เล่น" | mkV "ทำงาน" | mkV "ละลาย" | mkV "ไปไกล" | mkV "ดำเนิน" | mkV "คลายออก" | mkV "วิ่งหนี" | mkV "เผ่นหนี" | mkV "ล่าสัตว์" | mkV "วิ่งแข่ง" | mkV "ออกอากาศ" | mkV "มีความยาว" | mkV "มีแนวโน้ม" | mkV "ยังคงอยู่" | mkV "ลากเลื้อย" | mkV "เลี้ยงลูก" | mkV "ติดเครื่อง" | mkV "ทำไม่เสร็จ" | mkV "รีบเดินทาง" | mkV "เดินทางไปมา" | mkV "ลงชิงตำแหน่ง" | mkV "แล่นเรือตามลม" | mkV "ค้าของผิดกฎหมาย" | mkV "เกิดขึ้นอย่างติดต่อกัน" | mkV "ริน" | mkV "หนี" | mkV "ไหล" | mkV "แพร่" | mkV "แล่น" | mkV "กลิ้ง" | mkV "รีบไป" | mkV "กระจาย" | mkV "กินเวลา" | mkV "พาไปส่ง" | mkV "รีบเร่ง" | mkV "วิ่งควบ" | mkV "วิ่งหนี" | mkV "เล่าลือ" | mkV "ใช้เวลา" | mkV "วิ่งแข่ง" | mkV "เข้าร่วม" | mkV "ดําเนินการ" | mkV "ปฎิบัติการ" | mkV "เดินเครื่อง" | mkV "เปิดเครื่อง" | mkV "เยี่ยมเยียน" | mkV "มีผลตามกฎหมาย" | mkV "เคลื่อนผ่านไป" | mkV "ทําให้แพร่กระจาย" | mkV "ไปขอความช่วยเหลือ" | mkV "ผ่านไปอย่างรวดเร็ว" | mkV "ว่ายทวนน้ําไปวางไข่" | mkV "ลักลอบขนส่งผิดกฎหมาย" | mkV "เข้าสมัครรับเลือกตั้ง" ; -- src=panlex
lin long_A = mkA (thword "ยาว") | {-pan-} mkA "นาน" | mkA "ยาว" | mkA "มากเกิน" | mkA "นาน" | mkA "ยาว" ; -- src=panlex
lin right_Adv = variants{} ; -- 
lin right_2_Adv = variants{} ; -- 
lin right_1_Adv = variants{} ; -- 
lin set_V2 = variants{} ; -- 
lin help_V2V = mmkV2V "ช่วย" ; ---- | mkV "ช่วยเหลือ" | mkV "ให้ความช่วยเหลือด้านอาหาร" | mkV "ช่วย" | mkV "บริการ" | mkV "จุนเจือ" | mkV "ส่งเสริม" | mkV "เกื้อกูล" | mkV "ช่วยเหลือ" | mkV "สงเคราะห์" | mkV "ให้ความช่วยเหลือ" ; -- src=panlex
lin help_V2 = mkV2 "ช่วย" ; ---- | mkV "ช่วยเหลือ" | mkV "ให้ความช่วยเหลือด้านอาหาร" | mkV "ช่วย" | mkV "บริการ" | mkV "จุนเจือ" | mkV "ส่งเสริม" | mkV "เกื้อกูล" | mkV "ช่วยเหลือ" | mkV "สงเคราะห์" | mkV "ให้ความช่วยเหลือ" ; -- src=panlex
lin help_V = mkV "ช่วย" | mkV "ช่วยเหลือ" | mkV "ให้ความช่วยเหลือด้านอาหาร" | mkV "ช่วย" | mkV "บริการ" | mkV "จุนเจือ" | mkV "ส่งเสริม" | mkV "เกื้อกูล" | mkV "ช่วยเหลือ" | mkV "สงเคราะห์" | mkV "ให้ความช่วยเหลือ" ; -- src=panlex
lin every_Det = quantDet "ทุก" ;
lin home_N = mkN "บ้าน" | mkN "เรือน" | mkN "ที่บ้าน" | mkN "โฮมเพลท" | mkN "ครอบครัว" | mkN "นิวาสถาน" | mkN "บ้านช่อง" | mkN "บ้านเกิด" | mkN "ต้นกำเนิด" | mkN "ถิ่นกำเนิด" | mkN "แหล่งกำเนิด" | mkN "บ้านพักคนชรา" | mkN "บ้านพักฟื้นคนชรา" | mkN "สถานพักฟื้นคนชรา" | mkN "สถานพักฟื้นผู้สูงอายุ" | mkN "บ้าน" | mkN "ที่อยู่" | mkN "บ้านพัก" | mkN "บ้านเรือน" | mkN "อาคารที่พัก" ; -- src=panlex
lin month_N = mkN "ด." | mkN "เดือน" | mkN "เดือนตามปฏิทิน" | mkN "งวด" | mkN "มาส" | mkN "เดือน" ; -- src=panlex
lin side_N = mkN "ด้าน" | mkN "ฝ่าย" | mkN "ด้านข้าง" | mkN "การตีให้ลูกหมุน" | mkN "การตีลูกปั่นไซด์" | mkN "เนื้อชำแหละครึ่งซีก" | mkN "ขอบ" | mkN "ทีม" | mkN "พวก" | mkN "รอง" | mkN "ริม" | mkN "แง่" | mkN "กรณี" | mkN "ข้าง" | mkN "ด้าน" | mkN "ฝ่าย" | mkN "พรรค" | mkN "หน้า" | mkN "เก็บ" | mkN "แขนง" | mkN "กลุ่ม" | mkN "สีข้าง" | mkN "แง่มุม" | mkN "ด้านข้าง" | mkN "สนับสนุน" | mkN "ข้างเคียง" | mkN "ด้านสีข้าง" | mkN "เก็บเอาไว้" | mkN "ด้านซี่โครง" | mkN "ยืนอยู่ข้าง" | mkN "จากด้านหนึ่ง" | mkN "ส่วนบนหรือล่าง" | mkN "กลุ่มที่แข่งขัน" | mkN "ส่วนหน้าหรือหลัง" | mkN "เนื้อบริเวณสีข้าง" | mkN "ส่วนที่ไม่ใช่ตรงกลาง" ; -- src=panlex
lin night_N = mkN (thword "กลาง" "คืน") | {-pan-} mkN "คืน" | mkN "ค่ำ" | mkN "ค่ำคืน" | mkN "ค่ำมืด" | mkN "กลางคืน" | mkN "ความมืด" | mkN "ยามวิกาล" | mkN "รัตติกาล" | mkN "ตอนกลางคืน" | mkN "ช่วเวลาที่มืดมน" | mkN "โชค ไม่ดี" | mkN "ราตรี" | mkN "กลางคืน" | mkN "ความมืด" | mkN "ค่ําคืน" | mkN "รัตติกาล" | mkN "การไม่รู้" | mkN "ความคลุมเครือ" ; -- src=panlex
lin important_A = mkA (thword "สำ" "คัญ") | {-pan-} mkA "สำคัญ" | mkA "สลักสำคัญ" | mkA "ยะโส" | mkA "เด่น" | mkA "โอหัง" | mkA "มากมาย" | mkA "สําคัญ" | mkA "ใหญ่โต" | mkA "มีฐานะสูง" | mkA "มีความหมาย" | mkA "มีอํานาจมาก" | mkA "มีอิทธิพลมาก" ; -- src=panlex
lin eye_N = mkN (thword "ตา") | {-pan-} mkN "ตา" | mkN "เนตร" | mkN "จักษุ" | mkN "ดวงตา" | mkN "สายตา" | mkN "รูเข็ม" | mkN "ใจกลาง" | mkN "ดวงเนตร" | mkN "พระเนตร" | mkN "ศูนย์กลาง" | mkN "วิสัยทัศน์" | mkN "ตา" | mkN "รู" | mkN "ช่อง" | mkN "เนตร" | mkN "การดู" | mkN "จักษุ" | mkN "ดวงตา" | mkN "ทัศนะ" | mkN "ลูกตา" | mkN "สายตา" | mkN "ข้อคิด" | mkN "รูเข็ม" | mkN "การจ้อง" | mkN "ความคิด" | mkN "นัยน์ตา" | mkN "ความสนใจ" | mkN "ทิศทางลม" | mkN "ความใส่ใจ" | mkN "จุดของแสง" | mkN "การมองเห็น" | mkN "ความตั้งใจ" | mkN "ความคิดเห็น" | mkN "ตาของหน่อพืช" | mkN "หลอดไฟที่มีแสง" | mkN "การแสดงความรู้สึก" ; -- src=panlex
lin head_N = mkN (thword "หัว") | {-pan-} mkN "ห.น." | mkN "หน." | mkN "ตัว" | mkN "หัว" | mkN "เฮด" | mkN "ปลาย" | mkN "สมอง" | mkN "คำถาม" | mkN "ศีรษะ" | mkN "เศียร" | mkN "คำหลัก" | mkN "ต้นธาร" | mkN "ต้นน้ำ" | mkN "ลูกพี่" | mkN "หัวคิด" | mkN "กองหน้า" | mkN "ครูใหญ่" | mkN "ความคิด" | mkN "หัวหน้า" | mkN "หัวอ่าน" | mkN "แถวหน้า" | mkN "แนวหน้า" | mkN "โอษฐกาม" | mkN "พระเศียร" | mkN "หนังกลอง" | mkN "หน้ากลอง" | mkN "ข้อซักถาม" | mkN "ช่วงศีรษะ" | mkN "ฟองด้านบน" | mkN "หัวบันทึก" | mkN "หัวเรื่อง" | mkN "ต้นน้ำลำธาร" | mkN "ห้องน้ำเรือ" | mkN "ออรัลเซ็กส์" | mkN "อาจารย์ใหญ่" | mkN "ช่อกระจุกแน่น" | mkN "การทำรักด้วยปาก" | mkN "ผู้อำนวยการโรงเรียน" | mkN "การมีเพศสัมพันธ์ทางปาก" | mkN "ผู้เสพยาเสพติดอย่างอ่อน" | mkN "หัว" | mkN "ศิระ" | mkN "สมอง" | mkN "กะบาล" | mkN "ศีรษะ" | mkN "ศึรษะ" | mkN "ผู้นํา" | mkN "ส่วนบน" | mkN "ความคิด" | mkN "ส่วนยอด" | mkN "ส่วนหัว" | mkN "หัวหน้า" | mkN "จุดวิกฤต" | mkN "ตําแหน่งผู้นํา" | mkN "ตําแหน่งสูงสุด" ; -- src=panlex
lin information_N = mkN "ข้อมูล" | mkN "ชุดข้อมูล" | mkN "กลุ่มข้อมูล" | mkN "อินฟอร์เมชั่น" | mkN "ข่าว" | mkN "ข้อมูล" | mkN "ข่าวสาร" | mkN "ความรู้" | mkN "การบอกข่าว" | mkN "การให้ความรู้" | mkN "สํานักงานสนเทศ" ; -- src=panlex
lin question_N = mkN "คำถาม" | mkN "กระทู้ถาม" | mkN "การซักถาม" | mkN "การสอบถาม" | mkN "การไต่ถาม" | mkN "ข้อซักถาม" | mkN "ความสงสัย" | mkN "คำขอแต่งงาน" | mkN "ประโยคคำถาม" | mkN "ปัญหา" | mkN "กระทู้" | mkN "การถาม" | mkN "คําถาม" | mkN "สอบถาม" | mkN "หัวข้อ" | mkN "ข้อสงสัย" | mkN "การสอบถาม" | mkN "ประโยคคําถาม" | mkN "เรื่องที่นํามาพิจารณา" | mkN "ประเด็นที่นําขึ้นมาพูด" ; -- src=panlex
lin business_N = mkN "งาน" | mkN "อาชีพ" | mkN "การงาน" | mkN "กิจการ" | mkN "ธุรกิจ" | mkN "สายงาน" | mkN "ภาคธุรกิจ" | mkN "กลุ่มลูกค้า" | mkN "องค์กรธุรกิจ" | mkN "ลูกค้าทั้งหมด" | mkN "หน้าที่การงาน" | mkN "เป้าหมายโดยตรง" | mkN "กิจ" | mkN "งาน" | mkN "ธุระ" | mkN "การค้า" | mkN "ธุรกิจ" | mkN "ภารกิจ" | mkN "กิจธุระ" | mkN "หน้าที่" | mkN "สถานการณ์" | mkN "ผู้สนับสนุน" | mkN "ภาระหน้าที่" | mkN "หน้าที่การงาน" | mkN "เรื่องที่ยากลําบาก" | mkN "เรื่องที่ถือว่าสําคัญและเอาจริงเอาจัง" ; -- src=panlex
lin play_V2 = mkV2 (mkV "เล่น") ;
lin play_V = mkV (thword "เล่น") ;
lin play_3_V2 = variants{} ; -- 
lin play_3_V = variants{} ; -- 
lin play_2_V2 = variants{} ; -- 
lin play_2_V = variants{} ; -- 
lin play_1_V2 = variants{} ; -- 
lin play_1_V = variants{} ; -- 
lin power_N = mkN "พลัง" | mkN "กำลัง" | mkN "อำนาจ" | mkN "มหาอำนาจ" | mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "ตัวยกกำลัง" | mkN "ผู้นำธุรกิจ" | mkN "เลขชี้กำลัง" | mkN "ชาติมหาอำนาจ" | mkN "ความมีพละกำลัง" | mkN "ประเทศมหาอำนาจ" | mkN "นักธุรกิจชั้นนำ" | mkN "บุคคลผู้มีอำนาจ" | mkN "แรง" | mkN "พลัง" | mkN "กําลัง" | mkN "อํานาจ" | mkN "พลังงาน" | mkN "สมรรถนะ" | mkN "อานุภาพ" | mkN "อิทธิพล" | mkN "สมรรถภาพ" | mkN "พลังงานกล" | mkN "ความสามารถ" | mkN "ประสิทธิภาพ" | mkN "ผู้มีอํานาจ" | mkN "เลขยกกําลัง" | mkN "ผู้ทรงอํานาจ" | mkN "ผู้มีอิทธิพล" | mkN "เลขชี้กําลัง" | mkN "ประเทศมหาอํานาจ" ; -- src=panlex
lin money_N = mkN "เงิน" | mkN "ตัวเงิน" | mkN "เงิน" | mkN "ธนบัตร" | mkN "ตัวเงิน" | mkN "เงินตรา" | mkN "เงินทอง" | mkN "ทรัพย์สิน" | mkN "ทรัพย์สมบัติ" | mkN "สิ่งที่ใช้แลกเปลี่ยน" ; -- src=panlex
lin change_N = mkN "เงินทอน" | mkN "เศษเหรียญ" | mkN "การแลกเงิน" | mkN "ชุดเปลี่ยน" | mkN "ของแปลกใหม่" | mkN "ความแตกต่าง" | mkN "การเปลี่ยนแปลง" | mkN "การเปลี่ยนเสื้อ" | mkN "ชุดที่ใช้เปลี่ยน" | mkN "การทำให้เปลี่ยนแปลง" | mkN "เงินทอน" | mkN "การแทนที่" | mkN "สิ่งทดแทน" | mkN "เศษสตางค์" | mkN "ความผันแปร" | mkN "ของแปลกใหม่" | mkN "ความเปลี่ยนแปลง" ; -- src=panlex
lin move_V2 = variants{} ; -- 
lin move_V = variants{} ; -- 
lin move_2_V = variants{} ; -- 
lin move_1_V = variants{} ; -- 
lin interest_N = variants{} ; -- 
lin interest_4_N = variants{} ; -- 
lin interest_2_N = variants{} ; -- 
lin interest_1_N = variants{} ; -- 
lin order_N = mkN "คลับ" | mkN "ชมรม" | mkN "กลุ่ม" | mkN "สโมสร" | mkN "ชุมนุม" | mkN "อันดับ" | mkN "คำพิพากษา" | mkN "การพิพากษา" | mkN "การสั่งสินค้า" | mkN "พระราชกฤษฎีกา" | mkN "กฎข้อบังคับของรัฐสภา" | mkN "คำสั่งอย่างเป็นทางการ" | mkN "ขั้น" | mkN "ชนิด" | mkN "นิกาย" | mkN "ระดับ" | mkN "ลําดับ" | mkN "อนุกรม" | mkN "แบบแผน" | mkN "ใบสั่ง" | mkN "คณะสงฆ์" | mkN "คําสั่ง" | mkN "ธนาณัติ" | mkN "ระเบียบ" | mkN "คําบัญชา" | mkN "สมณศักดิ์" | mkN "ตั๋วแลกเงิน" | mkN "หนังสือมอบอํานาจ" | mkN "ใบสั่งซื้อสินค้า" | mkN "คําสั่งซื้อสินค้า" | mkN "เครื่องอิสริยาภรณ์" | mkN "ความเป็นระเบียบเรียบร้อย" ; -- src=panlex
lin book_N = mkN (thword nag_s svv_s) lem_s | {-pan-} mkN "สมุด" | mkN "เล่ม" | mkN "บัญชี" | mkN "บันทึก" | mkN "สคริปต์" | mkN "หนังสือ" | mkN "การบันทึก" | mkN "สมุดบัญชี" | mkN "สมุดบันทึก" | mkN "ประมวลกฏเกณฑ์" | mkN "หนังสือหนังหา" | mkN "หนังสือกฏระเบียบ" | mkN "การจอง" | mkN "หนังสือ" ; -- src=panlex
lin often_Adv = mkAdv "เยอะแยะ" | mkAdv "บ่อยครั้ง" | mkAdv "บ่อย ๆ" | mkAdv "บ่อยๆ" | mkAdv "บ่อยครั้ง" | mkAdv "เป็นประจํา" ; -- src=panlex
lin development_N = mkN "การพัฒนา" | mkN "ตอนพัฒนา" | mkN "พัฒนาการ" | mkN "การล้างรูป" | mkN "ท้องที่พัฒนา" | mkN "การเจริญเติบโต" | mkN "การพัฒนา" | mkN "พัฒนาการ" | mkN "วิวัฒนาการ" | mkN "ภาวะที่ค่อย ๆ ปรากฎชัดขึ้น" | mkN "ความก้าวหน้า" | mkN "การเจริญเติบโต" ; -- src=panlex
lin young_A = mkA "รุ่น" | {-pan-} mkA "สาว" | mkA "อ่อน" | mkA "หนุ่ม" | mkA "อ่อนวัย" | mkA "หนุ่มสาว" | mkA "ซึ่งไม่พยายาม" | mkA "ที่หนุ่มยังแน่น" | mkA "ที่เป็นสาวเป็นแส้" | mkA "ที่เป็นหนุ่มเป็นสาว" | mkA "ลูก" | mkA "สาว" | mkA "อ่อน" | mkA "เด็ก" | mkA "หนุ่ม" | mkA "เยาว์" | mkA "อ่อนวัย" | mkA "อ่อนหัด" | mkA "อายุน้อย" | mkA "เยาว์วัย" | mkA "อายุยังน้อย" | mkA "ระยะแรกเริ่ม" | mkA "ยังไม่สมบูรณ์" | mkA "เพิ่งเริ่มต้น" | mkA "ด้อยประสบการณ์" | mkA "ยังไม่โตเต็มที่" | mkA "เกี่ยวกับผู้เยาว์" ; -- src=panlex
lin national_A = mkA "ในบ้าน" | mkA "แห่งชาติ" | mkA "ภายในชาติ" | mkA "ภายในประเทศ" | mkA "ในบ้านเมือง" | mkA "ของชาติ" | mkA "ชาตินิยม" | mkA "แห่งชาติ" | mkA "ระดับชาติ" | mkA "ประจําชาติ" ; -- src=panlex
lin pay_V3 = mkV3 "ปลด" ; ---- | mkV "รับ" | mkV "ให้" | mkV "จ่าย" | mkV "ชำระ" | mkV "เสีย" | mkV "ชดใช้" | mkV "อุทิศ" | mkV "ออกเงิน" | mkV "ให้ผลตอบแทน" | mkV "จ่ายเต็มจำนวน" | mkV "จ่าย" | mkV "สนใจ" | mkV "ชดใช้" | mkV "ทดแทน" | mkV "ตอบแทน" | mkV "แก้แค้น" | mkV "เอาใจใส่" | mkV "จ่ายค่าแรง" | mkV "จ่ายค่าจ้าง" | mkV "จ่ายค่าตอบแทน" | mkV "ให้ความคิดเห็น" ; -- src=panlex
lin pay_V2V = mmkV2V "ปลด" ; ---- | mkV "รับ" | mkV "ให้" | mkV "จ่าย" | mkV "ชำระ" | mkV "เสีย" | mkV "ชดใช้" | mkV "อุทิศ" | mkV "ออกเงิน" | mkV "ให้ผลตอบแทน" | mkV "จ่ายเต็มจำนวน" | mkV "จ่าย" | mkV "สนใจ" | mkV "ชดใช้" | mkV "ทดแทน" | mkV "ตอบแทน" | mkV "แก้แค้น" | mkV "เอาใจใส่" | mkV "จ่ายค่าแรง" | mkV "จ่ายค่าจ้าง" | mkV "จ่ายค่าตอบแทน" | mkV "ให้ความคิดเห็น" ; -- src=panlex
lin pay_V2 = mkV2 "ปลด" ; ---- | mkV "รับ" | mkV "ให้" | mkV "จ่าย" | mkV "ชำระ" | mkV "เสีย" | mkV "ชดใช้" | mkV "อุทิศ" | mkV "ออกเงิน" | mkV "ให้ผลตอบแทน" | mkV "จ่ายเต็มจำนวน" | mkV "จ่าย" | mkV "สนใจ" | mkV "ชดใช้" | mkV "ทดแทน" | mkV "ตอบแทน" | mkV "แก้แค้น" | mkV "เอาใจใส่" | mkV "จ่ายค่าแรง" | mkV "จ่ายค่าจ้าง" | mkV "จ่ายค่าตอบแทน" | mkV "ให้ความคิดเห็น" ; -- src=panlex
lin pay_V = mkV "ปลด" | mkV "รับ" | mkV "ให้" | mkV "จ่าย" | mkV "ชำระ" | mkV "เสีย" | mkV "ชดใช้" | mkV "อุทิศ" | mkV "ออกเงิน" | mkV "ให้ผลตอบแทน" | mkV "จ่ายเต็มจำนวน" | mkV "จ่าย" | mkV "สนใจ" | mkV "ชดใช้" | mkV "ทดแทน" | mkV "ตอบแทน" | mkV "แก้แค้น" | mkV "เอาใจใส่" | mkV "จ่ายค่าแรง" | mkV "จ่ายค่าจ้าง" | mkV "จ่ายค่าตอบแทน" | mkV "ให้ความคิดเห็น" ; -- src=panlex
lin hear_VS = mmkVS "ฟัง" ; ---- | mkV "รู้" | mkV "สดับ" | mkV "ได้ยิน" | mkV "ได้ข่าว" | mkV "ตั้งใจฟัง" | mkV "สดับตรับฟัง" | mkV "ได้ข่าวคราว" | mkV "ได้ยินได้ฟัง" | mkV "ตรวจสอบหลักฐาน" | mkV "ฟังอย่างตั้งใจ" | mkV "ฟัง" | mkV "ยิน" | mkV "สดับ" | mkV "ได้ยิน" | mkV "ได้ยินเสียง" ; -- src=panlex
lin hear_V2V = mmkV2V "ฟัง" ; ---- | mkV "รู้" | mkV "สดับ" | mkV "ได้ยิน" | mkV "ได้ข่าว" | mkV "ตั้งใจฟัง" | mkV "สดับตรับฟัง" | mkV "ได้ข่าวคราว" | mkV "ได้ยินได้ฟัง" | mkV "ตรวจสอบหลักฐาน" | mkV "ฟังอย่างตั้งใจ" | mkV "ฟัง" | mkV "ยิน" | mkV "สดับ" | mkV "ได้ยิน" | mkV "ได้ยินเสียง" ; -- src=panlex
lin hear_V2 = mkV2 (thword "ได้" "ยิน") ;
lin hear_V = mkV "ฟัง" | mkV "รู้" | mkV "สดับ" | mkV "ได้ยิน" | mkV "ได้ข่าว" | mkV "ตั้งใจฟัง" | mkV "สดับตรับฟัง" | mkV "ได้ข่าวคราว" | mkV "ได้ยินได้ฟัง" | mkV "ตรวจสอบหลักฐาน" | mkV "ฟังอย่างตั้งใจ" | mkV "ฟัง" | mkV "ยิน" | mkV "สดับ" | mkV "ได้ยิน" | mkV "ได้ยินเสียง" ; -- src=panlex
lin room_N = variants{} ; -- 
lin room_1_N = variants{} ; -- 
lin room_2_N = variants{} ; -- 
lin whether_Subj = variants{} ; -- 
lin water_N = mkN (thword "น้ำ") | {-pan-} mkN "ฉี่" | mkN "น้ำ" | mkN "เยี่ยว" | mkN "ธาตุน้ำ" | mkN "ปัสสาวะ" | mkN "ระบบน้ำ" | mkN "น้ำเยี่ยว" | mkN "น้ำปัสสาวะ" | mkN "พระบังคนเบา" | mkN "ส่วนที่เป็นน้ำ" | mkN "ชล" | mkN "นำ้" | mkN "น้ำ" | mkN "ธารา" | mkN "น้ํา" | mkN "อุทก" | mkN "น้ําจืด" | mkN "น้ําแร่" | mkN "ธาตุน้ํา" | mkN "น้ําคร่ํา" | mkN "น้ําเปล่า" | mkN "แหล่งน้ํา" | mkN "พาหนะทางน้ํา โดยเฉพาะเรือ" | mkN "ความส่องสว่างของเพชรพลอย" ; -- src=panlex ----?
lin form_N = mkN "กาย" | mkN "ทรง" | mkN "รูป" | mkN "แบบ" | mkN "ชนิด" | mkN "ชั้น" | mkN "ฟอร์ม" | mkN "รูปคำ" | mkN "ประเภท" | mkN "รูปทรง" | mkN "รูปแบบ" | mkN "สังขาร" | mkN "รูปร่าง" | mkN "ร่างกาย" | mkN "พระวรกาย" | mkN "แบบฟอร์ม" | mkN "ร่างกายมนุษย์" | mkN "หุ่นโชว์เสื้อ" | mkN "ร่างกายของมนุษย์" | mkN "ฝีมือ" | mkN "รูปทรง" | mkN "รูปแบบ" | mkN "สัณฐาน" | mkN "แบบแผน" | mkN "รูปร่าง" | mkN "ความเก่ง" | mkN "พฤติกรรม" | mkN "แบบพิมพ์" | mkN "แบบฟอร์ม" | mkN "แม่พิมพ์" | mkN "แบบคําพูด" | mkN "ความสามารถ" | mkN "ความประพฤติ" | mkN "ระดับความสามารถ" ; -- src=panlex
lin car_N = mkN "รถ" "คัน" | {-pan-} mkN "รถ" | mkN "รถราง" | mkN "ลิฟต์" | mkN "รถยนต์" | mkN "เคเบิลคาร์" | mkN "รถ" | mkN "ตู้รถ" | mkN "พาหนะ" | mkN "รถยนต์" ; -- src=panlex
lin other_N = variants{} ; -- 
lin yet_Adv = variants{} ; -- 
lin yet_2_Adv = variants{} ; -- 
lin yet_1_Adv = variants{} ; -- 
lin perhaps_Adv = mkAdv "บางที" | mkAdv "อาจจะ" | mkAdv "บางที" | mkAdv "กระมัง" | mkAdv "อาจเป็นได้" | mkAdv "อย่างเป็นไปได้" ; -- src=panlex
lin meet_V2 = mkV2 "พบ" ; ---- | mkV "ชิด" | mkV "ติด" | mkV "เจอ" | mkV "พบปะ" | mkV "บรรจบ" | mkV "ประสบ" | mkV "ชุมนุม" | mkV "ได้เห็น" | mkV "เติมเต็ม" | mkV "ประจันหน้า" | mkV "สอดคล้องกับ" | mkV "ตรงกับที่ต้องการ" | mkV "ปะ" | mkV "พบ" | mkV "หา" | mkV "เจอ" | mkV "สนอง" | mkV "จัดการ" | mkV "ชุมนุม" | mkV "ทําตาม" | mkV "ประชุม" | mkV "ยอมตาม" | mkV "รับมือ" | mkV "ต้อนรับ" | mkV "จ่ายเงิน" | mkV "บรรจบกับ" | mkV "สัมผัสกับ" | mkV "จัดให้พบกัน" | mkV "พบโดยบังเอิญ" | mkV "เชื่อมต่อกับ" | mkV "พบกันครั้งแรก" | mkV "รู้จักเป็นครั้งแรก" | mkV "พบกันอย่างเป็นทางการ" | mkV "ได้รับการแนะนําให้รู้จัก" ; -- src=panlex
lin meet_V = mkV "พบ" | mkV "ชิด" | mkV "ติด" | mkV "เจอ" | mkV "พบปะ" | mkV "บรรจบ" | mkV "ประสบ" | mkV "ชุมนุม" | mkV "ได้เห็น" | mkV "เติมเต็ม" | mkV "ประจันหน้า" | mkV "สอดคล้องกับ" | mkV "ตรงกับที่ต้องการ" | mkV "ปะ" | mkV "พบ" | mkV "หา" | mkV "เจอ" | mkV "สนอง" | mkV "จัดการ" | mkV "ชุมนุม" | mkV "ทําตาม" | mkV "ประชุม" | mkV "ยอมตาม" | mkV "รับมือ" | mkV "ต้อนรับ" | mkV "จ่ายเงิน" | mkV "บรรจบกับ" | mkV "สัมผัสกับ" | mkV "จัดให้พบกัน" | mkV "พบโดยบังเอิญ" | mkV "เชื่อมต่อกับ" | mkV "พบกันครั้งแรก" | mkV "รู้จักเป็นครั้งแรก" | mkV "พบกันอย่างเป็นทางการ" | mkV "ได้รับการแนะนําให้รู้จัก" ; -- src=panlex
lin level_N = variants{} ; -- 
lin level_2_N = variants{} ; -- 
lin level_1_N = variants{} ; -- 
lin until_Subj = variants{} ; -- 
lin though_Subj = variants{} ; -- 
lin policy_N = mkN "นโยบาย" | mkN "กรมธรรม์ประกันภัย" | mkN "อุบาย" | mkN "นโยบาย" | mkN "แผนการ" | mkN "วิถีทาง" | mkN "หลักการ" | mkN "ความฉลาด" | mkN "ยุทธวิธี" | mkN "ลอตเตอรี" | mkN "ความสุขุม" | mkN "วิธีการอันแยบยล" | mkN "วิธีการอันแยบคาย" | mkN "กรมธรรม์ประกันภัย" ; -- src=panlex
lin include_V2 = mkV2 "ประกอบด้วย" ; ---- | mkV "ให้เข้าร่วม" | mkV "อนุญาตให้ร่วม" | mkV "เป็นส่วนหนึ่ง" | mkV "รวม" | mkV "รวมถึง" | mkV "รวมทั้ง" | mkV "รวมเข้า" | mkV "ประกอบด้วย" | mkV "รวมเข้าไว้" ; -- src=panlex
lin include_V = mkV "ประกอบด้วย" | mkV "ให้เข้าร่วม" | mkV "อนุญาตให้ร่วม" | mkV "เป็นส่วนหนึ่ง" | mkV "รวม" | mkV "รวมถึง" | mkV "รวมทั้ง" | mkV "รวมเข้า" | mkV "ประกอบด้วย" | mkV "รวมเข้าไว้" ; -- src=panlex
lin believe_VS = mmkVS "เชื่อ" ; ---- | mkV "คิดว่า" | mkV "เห็นว่า" | mkV "เชื่อถือ" | mkV "เชื่อว่า" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อ" | mkV "ถือว่า" | mkV "มั่นใจ" | mkV "ศรัทธา" | mkV "เชื่อถือ" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อว่าพูดจริง" ; -- src=panlex
lin believe_V2 = mkV2 "เชื่อ" ; ---- | mkV "คิดว่า" | mkV "เห็นว่า" | mkV "เชื่อถือ" | mkV "เชื่อว่า" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อ" | mkV "ถือว่า" | mkV "มั่นใจ" | mkV "ศรัทธา" | mkV "เชื่อถือ" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อว่าพูดจริง" ; -- src=panlex
lin believe_V = mkV "เชื่อ" | mkV "คิดว่า" | mkV "เห็นว่า" | mkV "เชื่อถือ" | mkV "เชื่อว่า" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อ" | mkV "ถือว่า" | mkV "มั่นใจ" | mkV "ศรัทธา" | mkV "เชื่อถือ" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อว่าพูดจริง" ; -- src=panlex
lin council_N = mkN "คณะมนตรี" | mkN "สภาคณะบิชอป" | mkN "สภา" | mkN "การประชุม" | mkN "สภาเทศบาล" | mkN "คณะกรรมการ" | mkN "องค์กรร่วม" | mkN "สภาท้องถิ่น" | mkN "คณะกรรมาธิการ" | mkN "กลุ่มคณะที่ปรึกษา" | mkN "กลุ่มคณะนิติบัญญัติ" | mkN "การประชุมเพื่อปรึกษาหารือ" ; -- src=panlex
lin already_Adv = mkAdv (thword "เรียบ" "ร้อย") | {-pan-} mkAdv "แล้ว" | mkAdv "แล้ว" | mkAdv "เรียบร้อย" | mkAdv "เรียบร้อยแล้ว" | mkAdv "ที่เกิดแล้วก่อนหน้านี้" ; -- src=panlex
lin possible_A = mkA "เป็นไปได้" | mkA "ที่เป็นไปได้" | mkA "ที่มีทางเป็นไปได้" | mkA "บางที" | mkA "พอทนได้" | mkA "เป็นไปได้" | mkA "ซึ่งอาจเกิดขึ้นได้" ; -- src=panlex
lin nothing_NP = mkNP "เปล่า" ;
lin line_N = mkN "งาน" | mkN "ชุด" | mkN "ท่อ" | mkN "รอย" | mkN "สาย" | mkN "แถว" | mkN "เส้น" | mkN "กำพืด" | mkN "อาชีพ" | mkN "การงาน" | mkN "สายงาน" | mkN "สายส่ง" | mkN "ทางรถไฟ" | mkN "แนวเส้น" | mkN "โน้ตย่อ" | mkN "สายเลือด" | mkN "เชื้อสาย" | mkN "สายตระกูล" | mkN "สายเคเบิล" | mkN "อะเกตไลน์" | mkN "ผู้สืบสกุล" | mkN "สายการผลิต" | mkN "จดหมายสั้นๆ" | mkN "สายโทรศัพท์" | mkN "หน้าที่การงาน" | mkN "ช่องทางสื่อสาร" | mkN "สิ่งที่เป็นเส้น" | mkN "เทือกเถาเหล่ากอ" | mkN "สินเชื่อรายบุคคล" | mkN "บริษัทเส้นทางขนส่ง" | mkN "การกำหนดกรอบความคิด" | mkN "บริษัทเส้นทางคมนาคม" | mkN "การบวนการผลิตผ่านสายพาน" | mkN "คิว" | mkN "สาย" | mkN "แถว" | mkN "แนว" | mkN "เส้น" | mkN "สายไฟ" | mkN "อาชีพ" | mkN "เชือก" | mkN "แวดวง" | mkN "ขอบเขต" | mkN "ตระกูล" | mkN "นโยบาย" | mkN "บรรทัด" | mkN "รอยย่น" | mkN "สายงาน" | mkN "เขตแดน" | mkN "แนวทาง" | mkN "ข้อความ" | mkN "ทางรถไฟ" | mkN "ริ้วรอย" | mkN "รูปร่าง" | mkN "วิถีทาง" | mkN "เส้นเขต" | mkN "รอยตีนกา" | mkN "เชื้อสาย" | mkN "เดินเรือ" | mkN "โครงร่าง" | mkN "สายโทรเลข" | mkN "วงศ์ตระกูล" | mkN "เส้นบรรทัด" | mkN "จดหมายสั้นๆ" | mkN "สายโทรศัพท์" | mkN "เส้นแบ่งเขต" | mkN "เส้นทางคมนาคม" | mkN "เส้นทางเดินรถ" | mkN "เส้นศูนย์สูตร" | mkN "ธุรกิจการขนส่ง" | mkN "บาทหนึ่งของโคลง" | mkN "โคลงบรรทัดหนึ่ง" | mkN "การผลิตทีละมากๆ ในโรงงานอุตสาหกรรม" | mkN "ทิศทางในการเคลื่อนไหว" | mkN "ความสนใจในงานหรือกิจกรรม" | mkN "สินค้าที่ผลิตจากเครื่องจักร" ; -- src=panlex
lin allow_V2V = variants{} ; -- 
lin allow_V2 = variants{} ; -- 
lin need_N = mkN "ความยากจน" | mkN "สิ่งจำเป็น" | mkN "ความต้องการ" | mkN "ความปรารถนา" | mkN "ความอดอยากยากจน" | mkN "ความสิ้นเนื้อประดาตัว" | mkN "ความขาดแคลน" | mkN "ความจําเป็น" | mkN "ความต้องการ" ; -- src=panlex
lin effect_N = mkN "เอฟเฟกต์" | mkN "ผลที่ตามมา" | mkN "แก่นเรื่อง" | mkN "ใจความสำคัญ" | mkN "มีผลบังคับใช้" | mkN "ผล" | mkN "ผลกระทบ" | mkN "ความตั้งใจ" | mkN "ความรู้สึกที่เกิดขึ้น" | mkN "ความรู้สึกจากสิ่งที่เห็นหรือได้ยิน" ; -- src=panlex
lin big_A = mkA (thword "ใหญ่") | {-pan-} mkA "ใหญ่" | mkA "ซึ่งโตเต็มวัย" | mkA "โต" | mkA "มาก" | mkA "ใจดี" | mkA "ใหญ่" | mkA "ขี้คุย" | mkA "ขี้โม้" | mkA "มีชื่อ" | mkA "ทรงพลัง" | mkA "ใจกว้าง" | mkA "ขึ้นชื่อ" | mkA "ยิ่งใหญ่" | mkA "ร่างใหญ่" | mkA "มีพลังมาก" | mkA "เติบโตแล้ว" | mkA "มีอํานาจสูง" | mkA "เป็นผู้ใหญ่" | mkA "มีความสําคัญหรือมีอิทธิพล" ; -- src=panlex
lin use_N = mkN "การใช้" | mkN "กิจวัตร" | mkN "การบริโภค" | mkN "ความเคยชิน" | mkN "การใช้เล่ห์เหลี่ยม" | mkN "กา่รบริโภคสินค้าและบริการ" | mkN "การใช้" | mkN "วิธีใช้" | mkN "ประโยชน์" | mkN "การทํางาน" | mkN "ความเคยชิน" | mkN "วิธีการใช้" | mkN "ความคุ้นเคย" | mkN "การใช้ประโยชน์" | mkN "ประโยชน์ใช้สอย" ; -- src=panlex
lin lead_V2V = mmkV2V "นำ" ; ---- | mkV "ไปไกล" | mkV "นำหน้า" | mkV "ให้การ" | mkV "นำไปสู่" | mkV "อำนวยเพลง" | mkV "เป็นผู้นำ" | mkV "เป็นประธาน" | mkV "ไปล่วงหน้า" | mkV "มีส่วนทำให้" | mkV "ทำให้บังเกิด" | mkV "อยู่อันดับท็อป" | mkV "เป็นผู้รับผิดชอบ" | mkV "นำ" | mkV "นํา" | mkV "พาไป" | mkV "ควบคุม" | mkV "นําทาง" | mkV "ครอบงํา" | mkV "นําหน้า" | mkV "สั่งการ" | mkV "ขึ้นหน้า" | mkV "นําทางไป" | mkV "อยู่หน้า" | mkV "ใช้ชีวิต" | mkV "อํานวยการ" | mkV "ก่อให้เกิด" | mkV "เป็นผู้นํา" | mkV "ทางนําไปสู่" | mkV "เป็นหัวหน้า" | mkV "เป็นคนสําคัญ" | mkV "เป็นหัวเรี่ยวหัวแรง" | mkV "มีอิทธิพลต่อความคิดหรือการกระทํา" ; -- src=panlex
lin lead_V2 = mkV2 "นำ" ; ---- | mkV "ไปไกล" | mkV "นำหน้า" | mkV "ให้การ" | mkV "นำไปสู่" | mkV "อำนวยเพลง" | mkV "เป็นผู้นำ" | mkV "เป็นประธาน" | mkV "ไปล่วงหน้า" | mkV "มีส่วนทำให้" | mkV "ทำให้บังเกิด" | mkV "อยู่อันดับท็อป" | mkV "เป็นผู้รับผิดชอบ" | mkV "นำ" | mkV "นํา" | mkV "พาไป" | mkV "ควบคุม" | mkV "นําทาง" | mkV "ครอบงํา" | mkV "นําหน้า" | mkV "สั่งการ" | mkV "ขึ้นหน้า" | mkV "นําทางไป" | mkV "อยู่หน้า" | mkV "ใช้ชีวิต" | mkV "อํานวยการ" | mkV "ก่อให้เกิด" | mkV "เป็นผู้นํา" | mkV "ทางนําไปสู่" | mkV "เป็นหัวหน้า" | mkV "เป็นคนสําคัญ" | mkV "เป็นหัวเรี่ยวหัวแรง" | mkV "มีอิทธิพลต่อความคิดหรือการกระทํา" ; -- src=panlex
lin lead_V = mkV "นำ" | mkV "ไปไกล" | mkV "นำหน้า" | mkV "ให้การ" | mkV "นำไปสู่" | mkV "อำนวยเพลง" | mkV "เป็นผู้นำ" | mkV "เป็นประธาน" | mkV "ไปล่วงหน้า" | mkV "มีส่วนทำให้" | mkV "ทำให้บังเกิด" | mkV "อยู่อันดับท็อป" | mkV "เป็นผู้รับผิดชอบ" | mkV "นำ" | mkV "นํา" | mkV "พาไป" | mkV "ควบคุม" | mkV "นําทาง" | mkV "ครอบงํา" | mkV "นําหน้า" | mkV "สั่งการ" | mkV "ขึ้นหน้า" | mkV "นําทางไป" | mkV "อยู่หน้า" | mkV "ใช้ชีวิต" | mkV "อํานวยการ" | mkV "ก่อให้เกิด" | mkV "เป็นผู้นํา" | mkV "ทางนําไปสู่" | mkV "เป็นหัวหน้า" | mkV "เป็นคนสําคัญ" | mkV "เป็นหัวเรี่ยวหัวแรง" | mkV "มีอิทธิพลต่อความคิดหรือการกระทํา" ; -- src=panlex
lin stand_V2 = mkV2 (thword "ยืน") ; ---- | {-pan-} mkV "ทน" | mkV "ยืน" | mkV "สูง" | mkV "อดทน" | mkV "ยอมทน" | mkV "อดกลั้น" | mkV "มีความสูง" | mkV "ท้ากาลเวลา" | mkV "วางแนวตั้ง" | mkV "ยืนอยู่ข้าง" | mkV "วางให้ตั้งทรง" | mkV "วางให้ตั้งขึ้น" | mkV "ยืน" | mkV "ยืนขึ้น" | mkV "ตั้งอยู่" | mkV "ทําให้ยืนขึ้น" | mkV "ทําให้ตั้งอยู่" ; -- src=panlex
lin stand_V = mkV (thword "ยืน") | {-pan-} mkV "ทน" | mkV "ยืน" | mkV "สูง" | mkV "อดทน" | mkV "ยอมทน" | mkV "อดกลั้น" | mkV "มีความสูง" | mkV "ท้ากาลเวลา" | mkV "วางแนวตั้ง" | mkV "ยืนอยู่ข้าง" | mkV "วางให้ตั้งทรง" | mkV "วางให้ตั้งขึ้น" | mkV "ยืน" | mkV "ยืนขึ้น" | mkV "ตั้งอยู่" | mkV "ทําให้ยืนขึ้น" | mkV "ทําให้ตั้งอยู่" ; -- src=panlex
lin idea_N = mkN "ไอเดีย" | mkN "ความคิด" | mkN "การประมาณ" | mkN "มุมมอง" | mkN "มโนคติ" | mkN "แง่คิด" | mkN "แผนการ" | mkN "ไอเดีย" | mkN "ความคิด" | mkN "โครงการ" | mkN "ความเชื่อ" | mkN "ความนึกคิด" | mkN "ความคิดเห็น" ; -- src=panlex
lin study_N = mkN "วิชา" | mkN "สาขา" | mkN "รายงาน" | mkN "ศาสตร์" | mkN "ภาพร่าง" | mkN "รีพอร์ต" | mkN "การศึกษา" | mkN "คนความจำดี" | mkN "ภาพสเก็ตช์" | mkN "ห้องค้นคว้า" | mkN "การวิจัย" | mkN "การศึกษา" | mkN "การเรียน" | mkN "สาขาวิชา" | mkN "การค้นคว้า" | mkN "การตรวจสอบ" | mkN "ห้องค้นคว้า" | mkN "เพลงฝึกซ้อม" | mkN "การดูหนังสือ" | mkN "การวิเคราะห์" | mkN "การเล่าเรียน" | mkN "สิ่งที่ศึกษา" | mkN "รายงานการศึกษา" | mkN "สิ่งที่ค้นคว้า" | mkN "การสืบสวนสอบสวน" | mkN "ความมานะบากบั่น" | mkN "รายงานการค้นคว้า" | mkN "ห้องเขียนหนังสือ" | mkN "ห้องศึกษาเล่าเรียน" | mkN "การพิเคราะห์พิจารณา" | mkN "การทดลองวาดหรือประพันธ์" ; -- src=panlex
lin lot_N = mkN "วง" | mkN "พวง" | mkN "กลุ่ม" | mkN "มากมาย" | mkN "กลุ่มคน" | mkN "จำนวนมาก" | mkN "ชะตากรรม" | mkN "การจับฉลาก" | mkN "จำนวนมากมายก่ายกอง" | mkN "สลาก" | mkN "วาสนา" | mkN "ที่ดิน" | mkN "ผืนดิน" | mkN "โชคชะตา" | mkN "ชะตากรรม" | mkN "ส่วนแบ่ง" | mkN "พรหมลิขิต" | mkN "การจับสลาก" | mkN "แปลงที่ดิน" | mkN "เคราะห์กรรม" | mkN "ส่วนที่กําหนดให้" | mkN "สิ่งของในการประมูล" | mkN "โรงถ่ายทําภาพยนตร์" | mkN "สถานที่ถ่ายทําภาพยนตร์" | mkN "สิ่งของในการขายทอดตลาด" | mkN "พื้นที่ที่ใช้ประโยชน์โดยเฉพาะ" | mkN "กลุ่มคนหรือสิ่งของชนิดเดียวกัน" | mkN "สิ่งของหรือคนที่อยู่รวมกันเป็นกลุ่มเป็นก้อน" ; -- src=panlex
lin live_V = mkV (thword "อยู่") | {-pan-} mkV "อยู่" | mkV "อาศัย" | mkV "รอดตาย" | mkV "รู้ถึง" | mkV "มีชีวิต" | mkV "รอดชีวิต" | mkV "ใช้ชีวิต" | mkV "ดำรงชีวิต" | mkV "รับรู้เอง" | mkV "มีชีวิตรอด" | mkV "อยู่อย่างมีความสุข" | mkV "พัก" | mkV "อยู่" | mkV "ประสบ" | mkV "อาศัย" | mkV "ใช้ชีวิต" | mkV "ยังชีพด้วย" | mkV "มีชีวิตอยู่" | mkV "ดําเนินชีวิต" | mkV "ประทังชีวิตด้วย" | mkV "ยังคงมีชีวิตอยู่" | mkV "ใช้ชีวิตอย่างสนุกสนาน" | mkV "สนุกกับชีวิตอย่างเต็มที่" ; -- src=panlex
lin job_N = mkN "งาน" | mkN "ปัญหา" | mkN "ผลงาน" | mkN "อาชีพ" | mkN "การงาน" | mkN "สายงาน" | mkN "หน้าที่การงาน" | mkN "งาน" | mkN "อาชีพ" | mkN "ชิ้นงาน" | mkN "หน้าที่" | mkN "การทํามาหากิน" | mkN "ความรับผิดชอบ" ; -- src=panlex
lin since_Subj = variants{} ; -- 
lin name_N = mkN (thword "ชื่อ") | {-pan-} mkN "นาม" | mkN "ชื่อ" | mkN "สกุล" | mkN "นามสกุล" | mkN "บุคคลสาธารณะ" | mkN "ชื่อเสียงเรียงนาม" | mkN "ชื่อ" | mkN "เรียก" | mkN "ฉายานาม" | mkN "ระบุชื่อ" | mkN "ชื่อเรียก" ; -- src=panlex
lin result_N = mkN "ผล" | mkN "เฉลย" | mkN "คำตอบ" | mkN "ผลที่ตามมา" | mkN "วิธีแก้ปัญหา" | mkN "ผลตอบ" | mkN "ผลลัพธ์" | mkN "ผลที่ตามมา" ; -- src=panlex
lin body_N = mkN "ศพ" | mkN "กาย" | mkN "ซาก" | mkN "ตัว" | mkN "ร่าง" | mkN "หมู่" | mkN "กลุ่ม" | mkN "บอดี้" | mkN "ลำตัว" | mkN "เหล่า" | mkN "ร่างกาย" | mkN "องค์รวม" | mkN "เรือนกาย" | mkN "เนื้อความ" | mkN "เรือนร่าง" | mkN "กล่องเสียง" | mkN "ความเหนียวข้น" | mkN "ร่างไร้วิญญาณ" | mkN "ส่วนประกอบหลัก" | mkN "โครงสร้างของรถ" | mkN "ร่างที่ปราศจากลมหายใจ" | mkN "ศพ" | mkN "ตัว" | mkN "มวล" | mkN "ร่าง" | mkN "ซากศพ" | mkN "วัตถุ" | mkN "สรีระ" | mkN "ลําตัว" | mkN "ลําต้น" | mkN "กลุ่มคน" | mkN "ข้อสรุป" | mkN "ทั้งตัว" | mkN "ร่างกาย" | mkN "ส่วนใหญ่" | mkN "เนื้อแท้" | mkN "เนื้อเรื่อง" | mkN "ทําให้เป็นรูปร่าง" | mkN "ใจความสําคัญของงานเขียน" | mkN "ส่วนประกอบหลักของยานพาหนะ" | mkN "ส่วนประกอบหลักของสิ่งต่าง ๆ" ; -- src=panlex
lin happen_VV = mkVV "พบ" ; ---- | mkV "อุบัติ" | mkV "เกิดขึ้น" | mkV "ปรากฏ" | mkV "อุบัติ" | mkV "เกิดขึ้น" | mkV "อุบัติขึ้น" | mkV "พบโดยบังเอิญ" | mkV "บังเอิญเกิดขึ้น" | mkV "เกิดขึ้นโดยบังเอิญ" ; -- src=panlex
lin happen_V = mkV "พบ" | mkV "อุบัติ" | mkV "เกิดขึ้น" | mkV "ปรากฏ" | mkV "อุบัติ" | mkV "เกิดขึ้น" | mkV "อุบัติขึ้น" | mkV "พบโดยบังเอิญ" | mkV "บังเอิญเกิดขึ้น" | mkV "เกิดขึ้นโดยบังเอิญ" ; -- src=panlex
lin friend_N = personN "เพี่อน" | {-pan-} mkN "พวก" | mkN "มิตร" | mkN "สหาย" | mkN "เพื่อน" | mkN "พรรคพวก" | mkN "พวกพ้อง" | mkN "พันธมิตร" | mkN "มิตรสหาย" | mkN "ผู้สนับสนุน" | mkN "ผู้หนุนหลัง" | mkN "พรรคพวกเพื่อนฝูง" | mkN "ผู้ให้การสนับสนุน" | mkN "มิตร" | mkN "สหาย" | mkN "เกลอ" | mkN "เพื่อน" | mkN "พวกพ้อง" | mkN "มิตรสหาย" | mkN "คนคุ้นเคย" | mkN "ผู้สนับสนุน" | mkN "ผู้ช่วยเหลือ" ; -- src=panlex
lin right_N = mkN "สิทธิ" | mkN "ทางขวา" | mkN "มือขวา" | mkN "ด้านขวา" | mkN "ฝ่ายขวา" | mkN "ทางขวามือ" | mkN "ไรท์ฟีลด์" | mkN "มือข้างขวา" | mkN "ความถูกต้อง" | mkN "การหันทางขวา" | mkN "ขวา" | mkN "สิทธิ" | mkN "ด้านขวา" | mkN "ความถูกต้อง" | mkN "พรรคฝ่ายขวา" | mkN "สิทธิตามกฎหมาย" | mkN "สิทธิมนุษยธรรม" | mkN "พรรคอนุรักษ์นิยม" ; -- src=panlex
lin least_Adv = mkAdv "อย่างน้อยที่สุด" | mkAdv "อย่างต่ําที่สุด" | mkAdv "อย่างน้อยที่สุด" ; -- src=panlex
lin right_A = variants{} ; -- 
lin right_2_A = variants{} ; -- 
lin right_1_A = variants{} ; -- 
lin almost_Adv = mkAdv "เกือบ" | mkAdv "จวนเจียน" | mkAdv "จวน" | mkAdv "จวนจะ" | mkAdv "เกือบ" | mkAdv "แทบจะ" | mkAdv "เกือบจะ" | mkAdv "จวนเจียน" | mkAdv "เกือบถึง" ; -- src=panlex
lin much_Det = quantDet "หลาย" ; ---- always?
lin carry_V2 = mkV2 "นำ" ; ---- | mkV "พก" | mkV "มี" | mkV "ยก" | mkV "กุม" | mkV "ถือ" | mkV "ยืด" | mkV "แฝง" | mkV "ดื่ม" | mkV "ท้อง" | mkV "ป่อง" | mkV "เชิด" | mkV "ขนส่ง" | mkV "ชดเชย" | mkV "ชนะใจ" | mkV "บรรจุ" | mkV "มีรอย" | mkV "บรรทุก" | mkV "มีท้อง" | mkV "เลี้ยง" | mkV "แบกรับ" | mkV "ถ่ายโอน" | mkV "มีครรภ์" | mkV "รับภาระ" | mkV "เข้ายึด" | mkV "แสดงถึง" | mkV "ให้เงิน" | mkV "ออกอากาศ" | mkV "อุ้มท้อง" | mkV "ขยายไปสู่" | mkV "ตั้งครรภ์" | mkV "ประพฤติตน" | mkV "เป็นตัวนำ" | mkV "เอามาก่อน" | mkV "ประพฤติตัว" | mkV "รับน้ำหนัก" | mkV "มีอยู่ในมือ" | mkV "เก็บไว้ในใจ" | mkV "ชนะการเลือกตั้ง" | mkV "ให้เงินสนับสนุน" | mkV "สนับสนุนทางการเงิน" | mkV "พก" | mkV "รับ" | mkV "แบก" | mkV "ใส่" | mkV "ท้อง" | mkV "อุ้ม" | mkV "ขนส่ง" | mkV "บรรจุ" | mkV "ถือไว้" | mkV "บรรทุก" | mkV "หอบไว้" | mkV "แบกรับ" | mkV "ค้ําจุน" | mkV "นําพาไป" | mkV "บอกข่าว" | mkV "ประพฤติ" | mkV "เดินทาง" | mkV "สนับสนุน" | mkV "อุ้มท้อง" | mkV "แจ้งข่าว" | mkV "ขยายไปสู่" | mkV "จดทะเบียน" | mkV "ตั้งครรภ์" | mkV "ลงทะเบียน" | mkV "ปฎิบัติตัว" | mkV "แจ้งข้อมูล" | mkV "เป็นสื่อนํา" | mkV "ชักนําทางความรู้สึก" ; -- src=panlex
lin carry_V = mkV "นำ" | mkV "พก" | mkV "มี" | mkV "ยก" | mkV "กุม" | mkV "ถือ" | mkV "ยืด" | mkV "แฝง" | mkV "ดื่ม" | mkV "ท้อง" | mkV "ป่อง" | mkV "เชิด" | mkV "ขนส่ง" | mkV "ชดเชย" | mkV "ชนะใจ" | mkV "บรรจุ" | mkV "มีรอย" | mkV "บรรทุก" | mkV "มีท้อง" | mkV "เลี้ยง" | mkV "แบกรับ" | mkV "ถ่ายโอน" | mkV "มีครรภ์" | mkV "รับภาระ" | mkV "เข้ายึด" | mkV "แสดงถึง" | mkV "ให้เงิน" | mkV "ออกอากาศ" | mkV "อุ้มท้อง" | mkV "ขยายไปสู่" | mkV "ตั้งครรภ์" | mkV "ประพฤติตน" | mkV "เป็นตัวนำ" | mkV "เอามาก่อน" | mkV "ประพฤติตัว" | mkV "รับน้ำหนัก" | mkV "มีอยู่ในมือ" | mkV "เก็บไว้ในใจ" | mkV "ชนะการเลือกตั้ง" | mkV "ให้เงินสนับสนุน" | mkV "สนับสนุนทางการเงิน" | mkV "พก" | mkV "รับ" | mkV "แบก" | mkV "ใส่" | mkV "ท้อง" | mkV "อุ้ม" | mkV "ขนส่ง" | mkV "บรรจุ" | mkV "ถือไว้" | mkV "บรรทุก" | mkV "หอบไว้" | mkV "แบกรับ" | mkV "ค้ําจุน" | mkV "นําพาไป" | mkV "บอกข่าว" | mkV "ประพฤติ" | mkV "เดินทาง" | mkV "สนับสนุน" | mkV "อุ้มท้อง" | mkV "แจ้งข่าว" | mkV "ขยายไปสู่" | mkV "จดทะเบียน" | mkV "ตั้งครรภ์" | mkV "ลงทะเบียน" | mkV "ปฎิบัติตัว" | mkV "แจ้งข้อมูล" | mkV "เป็นสื่อนํา" | mkV "ชักนําทางความรู้สึก" ; -- src=panlex
lin authority_N = variants{} ; -- 
lin authority_2_N = variants{} ; -- 
lin authority_1_N = variants{} ; -- 
lin long_Adv = variants{} ; -- 
lin early_A = mkA "ต้น" | mkA "แรก" | mkA "ก่อน" | mkA "แรกรุ่น" | mkA "ครั้งแรก" ; -- src=panlex
lin view_N = variants{} ; -- 
lin view_2_N = variants{} ; -- 
lin view_1_N = variants{} ; -- 
lin public_A = mkA "สาธารณะ" | mkA "ที่เป็นของสาธารณะ" | mkA "ที่รู้กันโดยทั่วไป" | mkA "ที่เกี่ยวข้องกับส่วนรวม" ; -- src=panlex
lin together_Adv = mkAdv "ด้วยกัน" | mkAdv "พร้อมกัน" | mkAdv "ด้วยส่วนรวม" | mkAdv "ด้วยแผนส่วนรวม" | mkAdv "รวม" | mkAdv "รวมกัน" | mkAdv "ด้วยกัน" | mkAdv "ปะทะกัน" | mkAdv "ร่วมกัน" | mkAdv "พร้อมกัน" | mkAdv "แต่งงานกัน" | mkAdv "สัมพันธ์กัน" | mkAdv "เข้าด้วยกัน" | mkAdv "เวลาเดียวกัน" | mkAdv "เกี่ยวข้องกัน" | mkAdv "พร้อมกับคนอื่น" | mkAdv "โดยไม่หยุดยั้ง" | mkAdv "อย่างสัมพันธ์กัน" | mkAdv "อย่างต่อเนื่องกัน" | mkAdv "อย่างเชื่อมโยงกัน" | mkAdv "อย่างเห็นพ้องร่วมกัน" | mkAdv "อย่างไม่ถูกขัดจังหวะ" ; -- src=panlex
lin talk_V2 = mkV2 "คุย" ; ---- | mkV "พูด" | mkV "กล่าว" | mkV "พูดจา" | mkV "สนทนา" | mkV "บรรยาย" | mkV "พูดคุย" | mkV "เผยไต๋" | mkV "เปิดเผย" | mkV "เล็คเชอร์" | mkV "เผยเคล็ดลับ" | mkV "แลกเปลี่ยนความคิดเห็น" | mkV "คุย" | mkV "พูด" | mkV "ว่า" | mkV "นินทา" | mkV "สนทนา" | mkV "เจรจา" | mkV "บรรยาย" | mkV "พูดคุย" | mkV "กล่าวคํา" | mkV "ถกเรื่อง" | mkV "แสดงปาฐกถา" | mkV "พูดถึงเรื่อง" | mkV "พิจารณากันในเรื่อง" | mkV "อภิปรายกันในเรื่อง" ; -- src=panlex
lin talk_V = mkV "คุย" | mkV "พูด" | mkV "กล่าว" | mkV "พูดจา" | mkV "สนทนา" | mkV "บรรยาย" | mkV "พูดคุย" | mkV "เผยไต๋" | mkV "เปิดเผย" | mkV "เล็คเชอร์" | mkV "เผยเคล็ดลับ" | mkV "แลกเปลี่ยนความคิดเห็น" | mkV "คุย" | mkV "พูด" | mkV "ว่า" | mkV "นินทา" | mkV "สนทนา" | mkV "เจรจา" | mkV "บรรยาย" | mkV "พูดคุย" | mkV "กล่าวคํา" | mkV "ถกเรื่อง" | mkV "แสดงปาฐกถา" | mkV "พูดถึงเรื่อง" | mkV "พิจารณากันในเรื่อง" | mkV "อภิปรายกันในเรื่อง" ; -- src=panlex
lin report_N = mkN "บทความ" | mkN "รายงาน" | mkN "สมุดพก" | mkN "รีพอร์ต" | mkN "เปเปอร์" | mkN "การรายงาน" | mkN "รายงานข่าว" | mkN "เสียงยิงปืน" | mkN "บอก" | mkN "ข่าว" | mkN "เล่า" | mkN "บันทึก" | mkN "รายงาน" | mkN "ข่าวลือ" | mkN "คําแถลง" | mkN "ฟ้องร้อง" | mkN "คําประกาศ" | mkN "ชื่อเสียง" | mkN "ทําบันทึก" | mkN "ทํารายงาน" | mkN "เขียนข่าว" | mkN "กิตติศัพท์" | mkN "ความโด่งดัง" | mkN "จดคําบรรยาย" | mkN "เขียนรายงาน" | mkN "เรื่องซุบซิบ" | mkN "ความเลื่องลือ" | mkN "บันทึกการบรรยาย" ; -- src=panlex
lin after_Subj = variants{} ; -- 
lin only_Predet = {s1 = [] ; s2 = thword "เท่า" "นั้น"} ;
lin before_Subj = variants{} ; -- 
lin bit_N = mkN "บิต" | mkN "เศษ" | mkN "ชั่วครู่" | mkN "ดอกสว่าน" | mkN "ฟันกุญแจ" | mkN "เข็มเจาะ" | mkN "ชิ้นเล็กๆ" | mkN "การแกะสลัก" | mkN "เล็กๆน้อยๆ" | mkN "อาหารคำหนึ่ง" | mkN "อาหารหนึ่งคำ" | mkN "ชิ้นส่วนเล็กๆ" | mkN "บิต" | mkN "ดอกสว่าน" | mkN "ชิ้นส่วนเล็กๆน้อยๆ" | mkN "หน่วยวัดความจุข้อมูล" | mkN "เหล็กที่ขวางปากม้าสําหรับดึงบังเหียน" ; -- src=panlex
lin face_N = mkN "ด้าน" | mkN "หน้า" | mkN "ฟอนต์" | mkN "อักษร" | mkN "สีหน้า" | mkN "หน้าตา" | mkN "อักขระ" | mkN "ใบหน้า" | mkN "ดวงหน้า" | mkN "ความกล้า" | mkN "ด้านหน้า" | mkN "ตัวอักษร" | mkN "พระพักต์" | mkN "แบบอักษร" | mkN "แบบอักขระ" | mkN "การแสดงสีหน้า" | mkN "มุข" | mkN "หน้า" | mkN "พักตร์" | mkN "สีหน้า" | mkN "หน้าตา" | mkN "ใบหน้า" | mkN "พื้นผิว" | mkN "ด้านหน้า" | mkN "ชื่อเสียง" | mkN "ผิวสัมผัส" | mkN "รูปลักษณ์" | mkN "ลักษณะภายนอก" ; -- src=panlex
lin sit_V2 = mkV2 (thword "นั่ง") ; ---- | {-pan-} mkV "ขี่" | mkV "นั่ง" | mkV "โพสท่า" | mkV "คอยดูแล" | mkV "เป็นแบบ" | mkV "ให้นั่ง" | mkV "ดูแลเด็ก" | mkV "ตั้งอยู่" | mkV "จัดให้นั่ง" | mkV "นั่งประชุม" | mkV "เป็นสมาชิก" | mkV "เลี้ยงน้อง" | mkV "เลี้ยงเด็ก" | mkV "นั่งเก้าอี้" | mkV "นั่ง" | mkV "กกไข่" | mkV "จอดอยู่" | mkV "ตั้งอยู่" | mkV "หาที่นั่งให้" | mkV "วางอยู่ตรงนั้น" ; -- src=panlex
lin sit_V = mkV (thword "นั่ง") | {-pan-} mkV "ขี่" | mkV "นั่ง" | mkV "โพสท่า" | mkV "คอยดูแล" | mkV "เป็นแบบ" | mkV "ให้นั่ง" | mkV "ดูแลเด็ก" | mkV "ตั้งอยู่" | mkV "จัดให้นั่ง" | mkV "นั่งประชุม" | mkV "เป็นสมาชิก" | mkV "เลี้ยงน้อง" | mkV "เลี้ยงเด็ก" | mkV "นั่งเก้าอี้" | mkV "นั่ง" | mkV "กกไข่" | mkV "จอดอยู่" | mkV "ตั้งอยู่" | mkV "หาที่นั่งให้" | mkV "วางอยู่ตรงนั้น" ; -- src=panlex
lin market_N = variants{} ; -- 
lin market_1_N = variants{} ; -- 
lin market_2_N = variants{} ; -- 
lin appear_VV = mkVV "ออก" ; ---- | mkV "ปรากฏ" | mkV "ตีพิมพ์" | mkV "ดูเหมือน" | mkV "ปรากฏตัว" | mkV "ดูเหมือนว่า" | mkV "ปรากฏ" | mkV "ออกมา" | mkV "มีขึ้น" | mkV "แสดงตน" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "ดูเหมือนจะ" | mkV "ดูเหมือนว่า" | mkV "พิมพ์จําหน่าย" | mkV "ปรากฏตัวต่อสาธารณะ" | mkV "ปรากฏตัวอย่างเป็นทางการในศาล" ; -- src=panlex
lin appear_VS = mmkVS "ออก" ; ---- | mkV "ปรากฏ" | mkV "ตีพิมพ์" | mkV "ดูเหมือน" | mkV "ปรากฏตัว" | mkV "ดูเหมือนว่า" | mkV "ปรากฏ" | mkV "ออกมา" | mkV "มีขึ้น" | mkV "แสดงตน" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "ดูเหมือนจะ" | mkV "ดูเหมือนว่า" | mkV "พิมพ์จําหน่าย" | mkV "ปรากฏตัวต่อสาธารณะ" | mkV "ปรากฏตัวอย่างเป็นทางการในศาล" ; -- src=panlex
lin appear_VA = mmkVA "ออก" ; ---- | mkV "ปรากฏ" | mkV "ตีพิมพ์" | mkV "ดูเหมือน" | mkV "ปรากฏตัว" | mkV "ดูเหมือนว่า" | mkV "ปรากฏ" | mkV "ออกมา" | mkV "มีขึ้น" | mkV "แสดงตน" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "ดูเหมือนจะ" | mkV "ดูเหมือนว่า" | mkV "พิมพ์จําหน่าย" | mkV "ปรากฏตัวต่อสาธารณะ" | mkV "ปรากฏตัวอย่างเป็นทางการในศาล" ; -- src=panlex
lin appear_V = mkV "ออก" | mkV "ปรากฏ" | mkV "ตีพิมพ์" | mkV "ดูเหมือน" | mkV "ปรากฏตัว" | mkV "ดูเหมือนว่า" | mkV "ปรากฏ" | mkV "ออกมา" | mkV "มีขึ้น" | mkV "แสดงตน" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "ดูเหมือนจะ" | mkV "ดูเหมือนว่า" | mkV "พิมพ์จําหน่าย" | mkV "ปรากฏตัวต่อสาธารณะ" | mkV "ปรากฏตัวอย่างเป็นทางการในศาล" ; -- src=panlex
lin continue_VV = mkVV "กิน" ; ---- | mkV "จ้าง" | mkV "อยู่" | mkV "คงไว้" | mkV "ยังคง" | mkV "จรรโลง" | mkV "ให้ทำงาน" | mkV "ไปข้างหน้า" | mkV "ดำเนินต่อไป" | mkV "ดำเนินการสนทนา" | mkV "ทำอย่างต่อเนื่อง" | mkV "ยังคงดำเนินต่อไป" | mkV "ดําเนินต่อไป" | mkV "เริ่มอีกครั้ง" ; -- src=panlex
lin continue_V2 = mkV2 "กิน" ; ---- | mkV "จ้าง" | mkV "อยู่" | mkV "คงไว้" | mkV "ยังคง" | mkV "จรรโลง" | mkV "ให้ทำงาน" | mkV "ไปข้างหน้า" | mkV "ดำเนินต่อไป" | mkV "ดำเนินการสนทนา" | mkV "ทำอย่างต่อเนื่อง" | mkV "ยังคงดำเนินต่อไป" | mkV "ดําเนินต่อไป" | mkV "เริ่มอีกครั้ง" ; -- src=panlex
lin continue_V = mkV "กิน" | mkV "จ้าง" | mkV "อยู่" | mkV "คงไว้" | mkV "ยังคง" | mkV "จรรโลง" | mkV "ให้ทำงาน" | mkV "ไปข้างหน้า" | mkV "ดำเนินต่อไป" | mkV "ดำเนินการสนทนา" | mkV "ทำอย่างต่อเนื่อง" | mkV "ยังคงดำเนินต่อไป" | mkV "ดําเนินต่อไป" | mkV "เริ่มอีกครั้ง" ; -- src=panlex
lin able_A = mkA "สามารถ" | mkA "เก่ง" | mkA "สามารถ" | mkA "มีฝีมือ" | mkA "สมบูรณ์" | mkA "หลักแหลม" | mkA "ที่มีทักษะดี" | mkA "มีคุณสมบัติตามกฎเกณฑ์" | mkA "ที่มีความสามารถที่จะทําได้" ; -- src=panlex
lin political_A = mkA "ทางการเมือง" | mkA "เกี่ยวกับรัฐ" | mkA "เกี่ยวกับรัฐบาล" | mkA "เกี่ยวกับพลเมือง" | mkA "เกี่ยวกับการเมือง" | mkA "เกี่ยวกับการปกครอง" | mkA "เกี่ยวกับพรรคการเมือง" ; -- src=panlex
lin later_Adv = mkAdv "ตอนหลัง" | mkAdv "ในภายหลัง" | mkAdv "สักวันหนึ่ง" | mkAdv "ต่อมา" | mkAdv "ภายหลัง" | mkAdv "ในไม่ช้า" | mkAdv "ในภายหลัง" ; -- src=panlex
lin hour_N = mkN "ชม." | mkN "นาที" | mkN "ชั่วโมง" | mkN "เวลาในหนึ่งวัน" | mkN "60 นาที" | mkN "เวลา" | mkN "ชั่วโมง" | mkN "ปัจจุบัน" | mkN "เวลาทํางาน" | mkN "ช่วงเวลาสั้นๆ" | mkN "เวลาหนึ่งเวลาใด" | mkN "ช่วงเวลาใดเวลาหนึ่ง" | mkN "60นาที" ; -- src=panlex
lin rate_N = mkN "เรต" | mkN "อัตรา" | mkN "อัตราเร็ว" | mkN "ราคาต่อหน่วย" | mkN "ทุน" | mkN "ขนาด" | mkN "ขั้น" | mkN "ราคา" | mkN "ระดับ" | mkN "อัตรา" | mkN "ความเร็ว" | mkN "ค่าบรรทุก" | mkN "อัตราเร็ว" | mkN "ค่าใช้จ่าย" | mkN "ค่าประกันภัย" | mkN "อัตราความเร็ว" | mkN "อัตราต่อหน่วย" | mkN "อัตราภาษีอากร" | mkN "อัตราค่าโดยสาร" | mkN "อัตราเปรียบเทียบ" ; -- src=panlex
lin law_N = variants{} ; -- 
lin law_2_N = variants{} ; -- 
lin law_1_N = variants{} ; -- 
lin door_N = mkN "ประตู" "บาน" | {-pan-} mkN "ตึก" | mkN "ประตู" | mkN "พระทวาร" | mkN "บานประตู" | mkN "ช่องประตู" | mkN "ประตูทางเข้า" | mkN "ประตูเข้าออก" | mkN "ห้องที่มีประตู" | mkN "ประตู" | mkN "ช่องทาง" | mkN "ทางผ่าน" | mkN "ทางเข้า" | mkN "ทางเข้าออก" | mkN "บ้านที่มีประตูริมทาง" ; -- src=panlex
lin court_N = variants{} ; -- 
lin court_2_N = variants{} ; -- 
lin court_1_N = variants{} ; -- 
lin office_N = mkN "กรม" | mkN "สนง." | mkN "ทบวง" | mkN "บทบาท" | mkN "อำนาจ" | mkN "ออฟฟิส" | mkN "ตำแหน่ง" | mkN "หน้าที่" | mkN "สำนักงาน" | mkN "หน่วยงาน" | mkN "พนักงานออฟฟิส" | mkN "ตำแหน่งหน้าที่" | mkN "หน่วยงานราชการ" | mkN "พนักงานประจำสำนักงาน" | mkN "เจ้าหน้าที่ประจำสำนักงาน" | mkN "กรม" | mkN "กอง" | mkN "งาน" | mkN "สถาบัน" | mkN "กระทรวง" | mkN "ร้านค้า" | mkN "สมรรถนะ" | mkN "หน้าที่" | mkN "ตําแหน่ง" | mkN "หน่วยงาน" | mkN "การทํางาน" | mkN "การบริการ" | mkN "ที่ทําการ" | mkN "ที่ทํางาน" | mkN "สํานักงาน" | mkN "ภาระหน้าที่" | mkN "สถานที่ทํางาน" | mkN "หน่วยงานของรัฐ" ; -- src=panlex
lin let_V2V = variants{} ; -- 
lin war_N = mkN (thword "สง" "คราม") | {-pan-} mkN "ศึก" | mkN "การศึก" | mkN "สงคราม" | mkN "การทำศึก" | mkN "การสงคราม" | mkN "ศึกสงคราม" | mkN "ภาวะสงคราม" | mkN "การทำสงคราม" | mkN "การศึกสงคราม" | mkN "ต่อสู้" | mkN "สงคราม" | mkN "ขัดแย้ง" | mkN "ภาวะสงคราม" | mkN "ระยะเวลาที่ทําสงคราม" | mkN "ช่วงเวลาระหว่างสงคราม" | mkN "สถานการณ์ต่อสู้กันด้วยอาวุธร้ายแรง" | mkN "ความพยายามที่จะกําจัดสิ่งที่เป็นอันตรายให้หมดไป" ; -- src=panlex ----?
lin produce_V2 = mkV2 "ทำ" ; ---- | mkV "งอก" | mkV "ขึ้น" | mkV "ปลูก" | mkV "ผลิต" | mkV "ออกลูก" | mkV "นำมาแสดง" | mkV "ทำไร่ทำนา" | mkV "ก่อให้เกิด" | mkV "ออกวางตลาด" | mkV "ก่อ" | mkV "ลูก" | mkV "ผลิต" | mkV "แสดง" | mkV "จัดหา" | mkV "สร้าง" | mkV "ผลิตขึ้น" | mkV "ผลิตภัณฑ์" | mkV "สร้างขึ้น" | mkV "ก่อให้เกิด" | mkV "ให้กําเนิด" | mkV "ทําให้มีขึ้น" | mkV "ทําให้เกิดขึ้น" ; -- src=panlex
lin produce_V = mkV "ทำ" | mkV "งอก" | mkV "ขึ้น" | mkV "ปลูก" | mkV "ผลิต" | mkV "ออกลูก" | mkV "นำมาแสดง" | mkV "ทำไร่ทำนา" | mkV "ก่อให้เกิด" | mkV "ออกวางตลาด" | mkV "ก่อ" | mkV "ลูก" | mkV "ผลิต" | mkV "แสดง" | mkV "จัดหา" | mkV "สร้าง" | mkV "ผลิตขึ้น" | mkV "ผลิตภัณฑ์" | mkV "สร้างขึ้น" | mkV "ก่อให้เกิด" | mkV "ให้กําเนิด" | mkV "ทําให้มีขึ้น" | mkV "ทําให้เกิดขึ้น" ; -- src=panlex
lin reason_N = verbalN "เหตู" | {-pan-} mkN "ปัญญา" | mkN "เหตุผล" | mkN "มูลเหตุ" | mkN "ความเข้าใจ" | mkN "สติ" | mkN "สรุป" | mkN "เหตุผล" | mkN "จิตปกติ" | mkN "มูลเหตุ" | mkN "ความพอควร" | mkN "ความสํานึก" | mkN "การใช้เหตุผล" | mkN "การให้เหตุผล" | mkN "ความมีเหตุผล" | mkN "สติสัมปชัญญะ" | mkN "คิดคํานวณในใจ" | mkN "การพิจารณาที่ดี" ; -- src=panlex
lin less_Adv = mkAdv "ไม่ค่อย" | mkAdv "ปราศจาก" | mkAdv "น้อยกว่า" | mkAdv "เล็กน้อย" | mkAdv "ไม่ใหญ่นัก" ; -- src=panlex
lin minister_N = variants{} ; -- 
lin minister_2_N = variants{} ; -- 
lin minister_1_N = variants{} ; -- 
lin subject_N = variants{} ; -- 
lin subject_2_N = variants{} ; -- 
lin subject_1_N = variants{} ; -- 
lin person_N = personN (thword "บุค" "คล") | {-pan-} mkN "คน" | mkN "ตัว" | mkN "บุคคล" | mkN "บุรุษ" | mkN "ร่างกาย" | mkN "ปัจเจกชน" | mkN "ปัจเจกบุคคล" | mkN "คน" | mkN "ตัว" | mkN "ผู้" | mkN "ร่าง" | mkN "องค์" | mkN "บุคคล" | mkN "" | mkN "ตัวเอง" | mkN "มนุษย์" | mkN "ร่างกาย" | mkN "นิติบุคคล" | mkN "บุคลิกลักษณะ" ; -- src=panlex ----?
lin term_N = mkN "เทอม" | mkN "ภาคเรียน" | mkN "รูปปั้นหัวเสา" | mkN "คราว" | mkN "ฐานะ" | mkN "พจน์" | mkN "วาระ" | mkN "สมัย" | mkN "ครั้ง" | mkN "เกณฑ์" | mkN "ขอบเขต" | mkN "ภาคศาล" | mkN "ข้อสรุป" | mkN "ข้อสัญญา" | mkN "คําศัพท์" | mkN "ตั้งชื่อ" | mkN "ภาคเรียน" | mkN "ระยะเวลา" | mkN "ความสัมพันธ์" | mkN "ระยะเวลาหนึ่ง" | mkN "เวลาที่กําหนด" | mkN "ระยะเวลาที่กําหนด" | mkN "จํานวนในคณิตศาสตร์" | mkN "ระยะเวลาการตั้งครรภ์" | mkN "ระยะเวลาการดํารงตําแหน่ง" ; -- src=panlex
lin particular_A = mkA "พิเศษ" | mkA "จู้จี้" | mkA "จําเพาะ" | mkA "โดยเฉพาะ" | mkA "ช่างเลือก" | mkA "ผิดธรรมดา" | mkA "พิถีพิถัน" | mkA "ซึ่งไม่ธรรมดา" | mkA "ซึ่งจําเพาะเจาะจง" ; -- src=panlex
lin full_A = mkA (thword "เต็ม") | {-pan-} mkA "เต็ม" | mkA "หนักแน่น" | mkA "อิ่ม" | mkA "เต็ม" | mkA "แน่นอน" | mkA "เต็มที่" | mkA "เต็มไปด้วย" | mkA "ซึ่งครบถ้วน" | mkA "ซึ่งสมบูรณ์" ; -- src=panlex
lin involve_VS = mmkVS "ต้องการ" ; ---- | mkV "เกี่ยวพัน" | mkV "เกี่ยวข้อง" | mkV "ดึงเข้าไปเกี่ยว" | mkV "พาเข้าไปยุ่งเกี่ยว" | mkV "พัวพัน" | mkV "โยงใยถึง" | mkV "พาดพิงถึง" | mkV "เกี่ยวพัน" | mkV "ข้องเกี่ยว" | mkV "มีส่วนร่วม" | mkV "เกี่ยวข้อง" | mkV "ทําให้พัวพัน" ; -- src=panlex
lin involve_V2 = mkV2 "ต้องการ" ; ---- | mkV "เกี่ยวพัน" | mkV "เกี่ยวข้อง" | mkV "ดึงเข้าไปเกี่ยว" | mkV "พาเข้าไปยุ่งเกี่ยว" | mkV "พัวพัน" | mkV "โยงใยถึง" | mkV "พาดพิงถึง" | mkV "เกี่ยวพัน" | mkV "ข้องเกี่ยว" | mkV "มีส่วนร่วม" | mkV "เกี่ยวข้อง" | mkV "ทําให้พัวพัน" ; -- src=panlex
lin involve_V = mkV "ต้องการ" | mkV "เกี่ยวพัน" | mkV "เกี่ยวข้อง" | mkV "ดึงเข้าไปเกี่ยว" | mkV "พาเข้าไปยุ่งเกี่ยว" | mkV "พัวพัน" | mkV "โยงใยถึง" | mkV "พาดพิงถึง" | mkV "เกี่ยวพัน" | mkV "ข้องเกี่ยว" | mkV "มีส่วนร่วม" | mkV "เกี่ยวข้อง" | mkV "ทําให้พัวพัน" ; -- src=panlex
lin sort_N = mkN "แบบ" | mkN "ชนิด" | mkN "ฟอร์ม" | mkN "ประเภท" | mkN "รูปแบบ" | mkN "แบบ" | mkN "ชนิด" | mkN "จําพวก" | mkN "ท่าทาง" | mkN "ประเภท" | mkN "ลักษณะ" | mkN "ผสมผสาน" | mkN "ตัวอย่าง" | mkN "เหมาะกับ" | mkN "ผูกมิตรกับ" | mkN "การแบ่งชนิด" | mkN "การจัดประเภท" ; -- src=panlex
lin require_VS = mmkVS "สั่ง" ; ---- | mkV "จำเป็น" | mkV "ต้องการ" | mkV "สั่งการ" | mkV "เรียกร้อง" | mkV "กําหนด" | mkV "ต้องการ" | mkV "ประสงค์" | mkV "ปรารถนา" | mkV "เรียกร้อง" ; -- src=panlex
lin require_V2V = mmkV2V "สั่ง" ; ---- | mkV "จำเป็น" | mkV "ต้องการ" | mkV "สั่งการ" | mkV "เรียกร้อง" | mkV "กําหนด" | mkV "ต้องการ" | mkV "ประสงค์" | mkV "ปรารถนา" | mkV "เรียกร้อง" ; -- src=panlex
lin require_V2 = mkV2 "สั่ง" ; ---- | mkV "จำเป็น" | mkV "ต้องการ" | mkV "สั่งการ" | mkV "เรียกร้อง" | mkV "กําหนด" | mkV "ต้องการ" | mkV "ประสงค์" | mkV "ปรารถนา" | mkV "เรียกร้อง" ; -- src=panlex
lin require_V = mkV "สั่ง" | mkV "จำเป็น" | mkV "ต้องการ" | mkV "สั่งการ" | mkV "เรียกร้อง" | mkV "กําหนด" | mkV "ต้องการ" | mkV "ประสงค์" | mkV "ปรารถนา" | mkV "เรียกร้อง" ; -- src=panlex
lin suggest_VS = mmkVS "เสนอ" ; ---- | mkV "แนะนำ" | mkV "เกริ่น" | mkV "แสดงนัย" | mkV "ทำให้ระลึกถึง" | mkV "เตือน" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "เสนอแนะ" | mkV "บอกเป็นนัย" | mkV "ทําให้นึกถึง" ; -- src=panlex
lin suggest_V2 = mkV2 "เสนอ" ; ---- | mkV "แนะนำ" | mkV "เกริ่น" | mkV "แสดงนัย" | mkV "ทำให้ระลึกถึง" | mkV "เตือน" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "เสนอแนะ" | mkV "บอกเป็นนัย" | mkV "ทําให้นึกถึง" ; -- src=panlex
lin suggest_V = mkV "เสนอ" | mkV "แนะนำ" | mkV "เกริ่น" | mkV "แสดงนัย" | mkV "ทำให้ระลึกถึง" | mkV "เตือน" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "เสนอแนะ" | mkV "บอกเป็นนัย" | mkV "ทําให้นึกถึง" ; -- src=panlex
lin far_A = mkA "ไกล" | mkA "ห่างไกล" | mkA "ไกล" | mkA "ห่าง" | mkA "ยาวนาน" | mkA "ห่างไกล" | mkA "กว้างไกล" ; -- src=panlex
lin towards_Prep = variants{} ; -- 
lin anything_NP = variants{} ; -- 
lin period_N = variants{} ; -- 
lin period_3_N = variants{} ; -- 
lin period_2_N = variants{} ; -- 
lin period_1_N = variants{} ; -- 
lin consider_VV = mkVV "เห็น" ; ---- | mkV "ศึกษา" | mkV "คิดว่า" | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "พิจารณา" | mkV "เห็นว่า" | mkV "คำนึงถึง" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "ใคร่ครวญ" | mkV "นำมาพิจารณา" | mkV "พิจารณา" | mkV "คิดอย่างละเอียด" ; -- src=panlex
lin consider_VS = mmkVS "เห็น" ; ---- | mkV "ศึกษา" | mkV "คิดว่า" | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "พิจารณา" | mkV "เห็นว่า" | mkV "คำนึงถึง" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "ใคร่ครวญ" | mkV "นำมาพิจารณา" | mkV "พิจารณา" | mkV "คิดอย่างละเอียด" ; -- src=panlex
lin consider_V3 = mkV3 "เห็น" ; ---- | mkV "ศึกษา" | mkV "คิดว่า" | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "พิจารณา" | mkV "เห็นว่า" | mkV "คำนึงถึง" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "ใคร่ครวญ" | mkV "นำมาพิจารณา" | mkV "พิจารณา" | mkV "คิดอย่างละเอียด" ; -- src=panlex
lin consider_V2V = mmkV2V "เห็น" ; ---- | mkV "ศึกษา" | mkV "คิดว่า" | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "พิจารณา" | mkV "เห็นว่า" | mkV "คำนึงถึง" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "ใคร่ครวญ" | mkV "นำมาพิจารณา" | mkV "พิจารณา" | mkV "คิดอย่างละเอียด" ; -- src=panlex
lin consider_V2A = mmkV2A "เห็น" ; ---- | mkV "ศึกษา" | mkV "คิดว่า" | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "พิจารณา" | mkV "เห็นว่า" | mkV "คำนึงถึง" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "ใคร่ครวญ" | mkV "นำมาพิจารณา" | mkV "พิจารณา" | mkV "คิดอย่างละเอียด" ; -- src=panlex
lin consider_V2 = mkV2 "เห็น" ; ---- | mkV "ศึกษา" | mkV "คิดว่า" | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "พิจารณา" | mkV "เห็นว่า" | mkV "คำนึงถึง" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "ใคร่ครวญ" | mkV "นำมาพิจารณา" | mkV "พิจารณา" | mkV "คิดอย่างละเอียด" ; -- src=panlex
lin consider_V = mkV "เห็น" | mkV "ศึกษา" | mkV "คิดว่า" | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "พิจารณา" | mkV "เห็นว่า" | mkV "คำนึงถึง" | mkV "เชื่อว่า" | mkV "เล็งเห็น" | mkV "ใคร่ครวญ" | mkV "นำมาพิจารณา" | mkV "พิจารณา" | mkV "คิดอย่างละเอียด" ; -- src=panlex
lin read_VS = mmkVS "รู้" ; ---- | mkV "อ่าน" | mkV "กล่าว" | mkV "เรียน" | mkV "เข้าใจ" | mkV "อ่านค่า" | mkV "อ่านข้อมูล" | mkV "แปล" | mkV "อ่าน" | mkV "เรียน" | mkV "คาดเดา" | mkV "ตีความ" | mkV "ทํานาย" | mkV "ได้ยิน" | mkV "คาดหมาย" | mkV "ตรวจสอบ" | mkV "คาดการณ์" | mkV "เรียนรู้" | mkV "ตรวจปรู๊ฟ" | mkV "อ่านข้อมูล" | mkV "อ่านเข้าใจ" | mkV "อ่านออกเสียง" | mkV "เข้าใจความหมาย" ; -- src=panlex
lin read_V2 = mkV2 "อ่าน" ;
lin read_V = mkV "รู้" | mkV "อ่าน" | mkV "กล่าว" | mkV "เรียน" | mkV "เข้าใจ" | mkV "อ่านค่า" | mkV "อ่านข้อมูล" | mkV "แปล" | mkV "อ่าน" | mkV "เรียน" | mkV "คาดเดา" | mkV "ตีความ" | mkV "ทํานาย" | mkV "ได้ยิน" | mkV "คาดหมาย" | mkV "ตรวจสอบ" | mkV "คาดการณ์" | mkV "เรียนรู้" | mkV "ตรวจปรู๊ฟ" | mkV "อ่านข้อมูล" | mkV "อ่านเข้าใจ" | mkV "อ่านออกเสียง" | mkV "เข้าใจความหมาย" ; -- src=panlex
lin change_V2 = mkV2 "เปลี่ยน" ; ---- | mkV "กลายสภาพ" | mkV "เปลี่ยนชุด" | mkV "แลกเปลี่ยน" | mkV "เปลี่ยนแปลง" | mkV "ทำให้เปลี่ยน" | mkV "เปลี่ยนผ้าอ้อม" | mkV "เปลี่ยนเส้นทาง" | mkV "เปลี่ยนเสื้อผ้า" | mkV "ทำให้เปลี่ยนแปลง" | mkV "เปลี่ยนเป็นเสียงทุ้ม" | mkV "แลก" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "แลกเงินย่อย" | mkV "เปลี่ยนเสื้อ" | mkV "ทําให้แตกต่าง" | mkV "เปลี่ยนความเร็ว" | mkV "แลกเปลี่ยนเงินตรา" ; -- src=panlex
lin change_V = mkV "เปลี่ยน" | mkV "กลายสภาพ" | mkV "เปลี่ยนชุด" | mkV "แลกเปลี่ยน" | mkV "เปลี่ยนแปลง" | mkV "ทำให้เปลี่ยน" | mkV "เปลี่ยนผ้าอ้อม" | mkV "เปลี่ยนเส้นทาง" | mkV "เปลี่ยนเสื้อผ้า" | mkV "ทำให้เปลี่ยนแปลง" | mkV "เปลี่ยนเป็นเสียงทุ้ม" | mkV "แลก" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "แลกเงินย่อย" | mkV "เปลี่ยนเสื้อ" | mkV "ทําให้แตกต่าง" | mkV "เปลี่ยนความเร็ว" | mkV "แลกเปลี่ยนเงินตรา" ; -- src=panlex
lin society_N = mkN "คลับ" | mkN "ชมรม" | mkN "กลุ่ม" | mkN "สังคม" | mkN "สโมสร" | mkN "ชุมนุม" | mkN "สังคมชั้นสูง" | mkN "ความเป็นเพื่อน" | mkN "ชุมชน" | mkN "สมาคม" | mkN "สังคม" | mkN "หมู่ชน" | mkN "ชนชั้นสูง" | mkN "มิตรไม่ตรีจิต" ; -- src=panlex
lin process_N = mkN "โพรเซส" | mkN "กรรมวิธี" | mkN "ส่วนยื่น" | mkN "กระบวนการ" | mkN "กระบวนการคิด" | mkN "กระบวนการทางกายภาพ" | mkN "กระบวนการของสภาวะจิตไร้สำนึก" | mkN "ปุ่ม" | mkN "ระบบ" | mkN "กระบวน" | mkN "จัดการ" | mkN "แนวทาง" | mkN "ขบวนการ" | mkN "ขั้นตอน" | mkN "วิธีการ" | mkN "สิ่งงอก" | mkN "หมายศาล" | mkN "" | mkN "กรรมวิธี" | mkN "ส่วนยื่น" | mkN "เนื้องอก" | mkN "ปฏิบัติการ" | mkN "วิธีปฏิบัติ" | mkN "การดําเนินการ" | mkN "แนวทางปฏิบัติ" | mkN "การทําแม่พิมพ์" | mkN "การเปลี่ยนแปลง" | mkN "ขบวนแห่กระบวนการ" | mkN "ทําแม่พิมพ์สอดสี" | mkN "การพัฒนาต่อเนื่อง" | mkN "ขั้นตอนการปฏิบัติ" | mkN "การเปลี่ยนแปลงที่ดีขึ้น" ; -- src=panlex
lin mother_N = mkN "แม่" | mkN "เเม่" | mkN "มารดา" | mkN "คุณแม่" | mkN "มาเธอร์" | mkN "แม่อุ๊ย" | mkN "แม่เฒ่า" | mkN "แม่" | mkN "ชนนี" | mkN "มารดา" | mkN "คุณแม่" | mkN "แม่ยาย" | mkN "บ่อเกิด" | mkN "แม่เลี้ยง" | mkN "ต้นกําเนิด" | mkN "แม่บุญธรรม" | mkN "แหล่งที่มา" | mkN "ดูแลเหมือนแม่" ; -- src=panlex
lin offer_VV = variants{} ; -- 
lin offer_V2 = variants{} ; -- 
lin late_A = mkA "อดีต" | mkA "ช้า" | mkA "ดึก" | mkA "มืด" | mkA "ล่า" | mkA "สาย" | mkA "ค่ํา" | mkA "อดีต" | mkA "เร็ว ๆ นี้" | mkA "ล่าช้า" | mkA "ล่าสุด" | mkA "ภายหลัง" | mkA "อันก่อน" | mkA "เพิ่งตาย" | mkA "ที่ผ่านมา" | mkA "ช้ากว่าปกติ" | mkA "ไม่นานมานี้" | mkA "ล่วงเลยมานาน" | mkA "ที่เพิ่งเสียชีวิต" ; -- src=panlex
lin voice_N = mkN "วาจก" | mkN "โฆษก" | mkN "เสียง" | mkN "น้ำเสียง" | mkN "โฆษก" | mkN "เสียง" | mkN "การพูด" | mkN "นักร้อง" | mkN "ปากเสียง" | mkN "เสียงพูด" | mkN "เสียงร้อง" | mkN "ความรู้สึก" | mkN "เสียงเปล่ง" | mkN "การออกเสียง" | mkN "ความคิดเห็น" | mkN "ความต้องการ" | mkN "ความปรารถนา" | mkN "เสียงร้องเพลง" | mkN "วาจกในไวยากรณ์" | mkN "เสียงร้องของคน" | mkN "สิทธิในการออกเสียง" | mkN "เสียงที่เปล่งจากปาก" | mkN "ความสามารถในการขับร้อง" | mkN "ส่วนที่ขับร้องของบทดนตรี" | mkN "สิทธิในการแสดงความคิดเห็น" | mkN "ความสามารถในการพูดหรือร้อง" ; -- src=panlex
lin both_Adv = mkAdv "คล้ายกัน" ; -- src=panlex
lin once_Adv = mkAdv "เมื่อก่อน" | mkAdv "หนึ่งครั้ง" | mkAdv "ณ เวลาหนึ่งในอดีต" | mkAdv "เมื่อไร...ก็" | mkAdv "ครั้งหนึ่ง" | mkAdv "ครั้งเดียว" | mkAdv "โอกาสเดียว" ; -- src=panlex
lin police_N = mkN "กำลังตำรวจ" | mkN "กองกำลังตำรวจ" | mkN "ตำรวจ" | mkN "โปลิศ" | mkN "ี่ตํารวจ" | mkN "เจ้าหน้าที่ตํารวจ" | mkN "ผู้พิทักษ์สันติราษฎร์" | mkN "ี่การดูแลรักษาความสงบเรียบร้อยของชุมชน" ; -- src=panlex
lin kind_N = mkN "แบบ" | mkN "ชนิด" | mkN "ฟอร์ม" | mkN "ประเภท" | mkN "รูปแบบ" | mkN "พวก" | mkN "แบบ" | mkN "ชนิด" | mkN "พรรณ" | mkN "กลุ่ม" | mkN "จําพวก" | mkN "ประการ" | mkN "ประเภท" | mkN "พันธุ์" | mkN "ลักษณะ" | mkN "พรรคพวก" | mkN "คุณสมบัติ" ; -- src=panlex
lin lose_V2 = mkV2 "หาย" ;
lin lose_V = mkV "ถอย" | mkV "แพ้" | mkV "พลาด" | mkV "พ่าย" | mkV "เสีย" | mkV "ทำหาย" | mkV "ขาดทุน" | mkV "ปราชัย" | mkV "พ่ายแพ้" | mkV "สูญเสีย" | mkV "คลาดสายตา" | mkV "วางผิดที่" | mkV "เสียประโยชน์" | mkV "วางผิดตำแหน่ง" | mkV "หนี" | mkV "หลง" | mkV "แพ้" | mkV "พ่าย" | mkV "เสีย" | mkV "ตกหาย" | mkV "ทำหาย" | mkV "เพลิน" | mkV "กําจัด" | mkV "ตกหล่น" | mkV "ทําหาย" | mkV "ยอมแพ้" | mkV "ลืมตัว" | mkV "หลงทาง" | mkV "หลบหนี" | mkV "เสียไป" | mkV "พ่ายแพ้" | mkV "สูญเสีย" | mkV "หมกมุ่น" | mkV "ยอมจํานน" | mkV "ตามไม่ทัน" | mkV "ไม่สามารถควบคุมได้" | mkV "ไม่สามารถยับยั้งได้" | mkV "ไม่ทันได้ยินหรือเห็น" ; -- src=panlex
lin add_VS = mmkVS "บวก" ; ---- | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "รวมยอด" | mkV "ทำให้เพิ่ม" | mkV "เพิ่มระดับ" | mkV "เพิ่มคุณภาพ" | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "พูดต่อ" | mkV "เชื่อม" | mkV "นําเข้า" | mkV "พูดเติม" | mkV "เผยแพร่" | mkV "คิดผลรวม" | mkV "พูดเพิ่ม" | mkV "คิดยอดรวม" | mkV "เติมส่วนผสม" | mkV "เพิ่มส่วนผสม" | mkV "ทําให้รุนแรงขึ้น" ; -- src=panlex
lin add_V2 = mkV2 "บวก" ; ---- | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "รวมยอด" | mkV "ทำให้เพิ่ม" | mkV "เพิ่มระดับ" | mkV "เพิ่มคุณภาพ" | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "พูดต่อ" | mkV "เชื่อม" | mkV "นําเข้า" | mkV "พูดเติม" | mkV "เผยแพร่" | mkV "คิดผลรวม" | mkV "พูดเพิ่ม" | mkV "คิดยอดรวม" | mkV "เติมส่วนผสม" | mkV "เพิ่มส่วนผสม" | mkV "ทําให้รุนแรงขึ้น" ; -- src=panlex
lin add_V = mkV "บวก" | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "รวมยอด" | mkV "ทำให้เพิ่ม" | mkV "เพิ่มระดับ" | mkV "เพิ่มคุณภาพ" | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "พูดต่อ" | mkV "เชื่อม" | mkV "นําเข้า" | mkV "พูดเติม" | mkV "เผยแพร่" | mkV "คิดผลรวม" | mkV "พูดเพิ่ม" | mkV "คิดยอดรวม" | mkV "เติมส่วนผสม" | mkV "เพิ่มส่วนผสม" | mkV "ทําให้รุนแรงขึ้น" ; -- src=panlex
lin probably_Adv = variants{} ; -- 
lin expect_VV = mkVV "คอย" ; ---- | mkV "ท้อง" | mkV "ป่อง" | mkV "รอคอย" | mkV "มีท้อง" | mkV "คาดหวัง" | mkV "ต้องการ" | mkV "มีครรภ์" | mkV "คาดการณ์" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "เรียกร้อง" | mkV "ท้อง" | mkV "คาดว่า" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "หวังว่า" | mkV "คาดการณ์" | mkV "ตั้งท้อง" | mkV "คาดหมายว่า" | mkV "ปรารถนาว่า" ; -- src=panlex
lin expect_VS = mmkVS "คอย" ; ---- | mkV "ท้อง" | mkV "ป่อง" | mkV "รอคอย" | mkV "มีท้อง" | mkV "คาดหวัง" | mkV "ต้องการ" | mkV "มีครรภ์" | mkV "คาดการณ์" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "เรียกร้อง" | mkV "ท้อง" | mkV "คาดว่า" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "หวังว่า" | mkV "คาดการณ์" | mkV "ตั้งท้อง" | mkV "คาดหมายว่า" | mkV "ปรารถนาว่า" ; -- src=panlex
lin expect_V2V = mmkV2V "คอย" ; ---- | mkV "ท้อง" | mkV "ป่อง" | mkV "รอคอย" | mkV "มีท้อง" | mkV "คาดหวัง" | mkV "ต้องการ" | mkV "มีครรภ์" | mkV "คาดการณ์" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "เรียกร้อง" | mkV "ท้อง" | mkV "คาดว่า" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "หวังว่า" | mkV "คาดการณ์" | mkV "ตั้งท้อง" | mkV "คาดหมายว่า" | mkV "ปรารถนาว่า" ; -- src=panlex
lin expect_V2 = mkV2 "คอย" ; ---- | mkV "ท้อง" | mkV "ป่อง" | mkV "รอคอย" | mkV "มีท้อง" | mkV "คาดหวัง" | mkV "ต้องการ" | mkV "มีครรภ์" | mkV "คาดการณ์" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "เรียกร้อง" | mkV "ท้อง" | mkV "คาดว่า" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "หวังว่า" | mkV "คาดการณ์" | mkV "ตั้งท้อง" | mkV "คาดหมายว่า" | mkV "ปรารถนาว่า" ; -- src=panlex
lin expect_V = mkV "คอย" | mkV "ท้อง" | mkV "ป่อง" | mkV "รอคอย" | mkV "มีท้อง" | mkV "คาดหวัง" | mkV "ต้องการ" | mkV "มีครรภ์" | mkV "คาดการณ์" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "เรียกร้อง" | mkV "ท้อง" | mkV "คาดว่า" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "หวังว่า" | mkV "คาดการณ์" | mkV "ตั้งท้อง" | mkV "คาดหมายว่า" | mkV "ปรารถนาว่า" ; -- src=panlex
lin ever_Adv = mkAdv "ทุกเวลา" | mkAdv "ตลอดเวลา" | mkAdv "อย่างมาก" | mkAdv "ในเวลาใดก็ตาม" | mkAdv "เคย" | mkAdv "ตลอด" | mkAdv "เสมอๆ" | mkAdv "ตลอดไป" | mkAdv "เรื่อยไป" | mkAdv "เท่าที่เคยมา" | mkAdv "ไม่มีที่สิ้นสุด" ; -- src=panlex
lin available_A = mkA "มี" | mkA "หาได้" | mkA "มีอยู่" | mkA "หาง่าย" | mkA "ที่หาง่าย" | mkA "เหมาะที่ใช้" | mkA "เท่าที่จะหาได้" | mkA "ใช้ประโยชน์ได้" | mkA "ที่สามารถใช้ประโยชน์ได้" ; -- src=panlex
lin price_N = mkN "ค่า" | mkN "ราคา" | mkN "ค่าตัว" | mkN "มูลค่า" | mkN "เงินนำจับ" | mkN "ค่าใช้จ่าย" | mkN "รางวัลนำจับ" | mkN "ค่า" | mkN "ราคา" | mkN "สินบน" | mkN "คุณค่า" | mkN "มูลค่า" | mkN "รางวัล" | mkN "ผลตอบแทน" | mkN "เงินรางวัล" | mkN "รางวัลนําจับ" | mkN "สิ่งที่แลกมา" ; -- src=panlex
lin little_A = mkA "น้อย" | mkA "เล็ก" | mkA "แคระ" | mkA "เตี้ย" | mkA "ตัวน้อย" | mkA "ตัวเล็ก" | mkA "เล็กน้อย" | mkA "แคบ" | mkA "จ้อย" | mkA "น้อย" | mkA "เล็ก" | mkA "หน่อย" | mkA "ใจแคบ" | mkA "คับแคบ" | mkA "ไม่มาก" | mkA "สักครู่" | mkA "ปลีกย่อย" | mkA "ระยะสั้น" | mkA "สักหน่อย" | mkA "หยุมหยิม" | mkA "อายุน้อย" | mkA "อ่อนกว่า" | mkA "เล็กน้อย" | mkA "แทบจะไม่" | mkA "ไม่สําคัญ" | mkA "สักประเดี๋ยว" | mkA "อายุน้อยกว่า" ; -- src=panlex
lin action_N = mkN "การรบ" | mkN "กิจกรรม" | mkN "แอคชั่น" | mkN "การกระทำ" | mkN "กระฉับกระเฉง" | mkN "การใช้กำลังรบ" | mkN "การใช้กำลังทหาร" | mkN "กระบวนการตามธรรมชาติ" | mkN "การดำเนินคดีตามกฏหมาย" | mkN "การปฏิบัติงานของคณะรัฐบาล" | mkN "กลไกที่ทำให้เครื่องจักรทำงาน" | mkN "การรบ" | mkN "ฤทธิ์" | mkN "ท่าทาง" | mkN "อํานาจ" | mkN "การพนัน" | mkN "การเดิน" | mkN "ขั้นตอน" | mkN "อิทธิพล" | mkN "การกระทํา" | mkN "เหตุการณ์" | mkN "การปฏิบัติ" | mkN "ปฏิบัติการ" | mkN "การฟ้องร้อง" | mkN "อากัปกิริยา" | mkN "การใช้กําลัง" | mkN "การดําเนินการ" | mkN "การดําเนินคดี" | mkN "การเคลื่อนไหว" | mkN "ความกระฉับกระเฉง" | mkN "ความกระตือรือร้น" | mkN "ฉากในนิยายหรือภาพยนตร์" | mkN "การทํางานของเครื่องจักร" | mkN "เหตุการณ์ในนิยายหรือภาพยนตร์" ; -- src=panlex
lin issue_N = variants{} ; -- 
lin issue_2_N = variants{} ; -- 
lin issue_1_N = variants{} ; -- 
lin far_Adv = ss (thword "ไกล") ;
lin remember_VS = mmkVS "จำ" ; ---- | mkV "จำได้" | mkV "นึกออก" | mkV "รำลึกถึง" | mkV "จำ" | mkV "จดจํา" | mkV "จําได้" | mkV "ระลึกได้" | mkV "ฝากความคิดถึง" | mkV "ส่งความคิดถึง" | mkV "เก็บในความทรงจํา" ; -- src=panlex
lin remember_V2 = mkV2 "จำ" ; ---- | mkV "จำได้" | mkV "นึกออก" | mkV "รำลึกถึง" | mkV "จำ" | mkV "จดจํา" | mkV "จําได้" | mkV "ระลึกได้" | mkV "ฝากความคิดถึง" | mkV "ส่งความคิดถึง" | mkV "เก็บในความทรงจํา" ; -- src=panlex
lin remember_V = mkV "จำ" | mkV "จำได้" | mkV "นึกออก" | mkV "รำลึกถึง" | mkV "จำ" | mkV "จดจํา" | mkV "จําได้" | mkV "ระลึกได้" | mkV "ฝากความคิดถึง" | mkV "ส่งความคิดถึง" | mkV "เก็บในความทรงจํา" ; -- src=panlex
lin position_N = mkN "ท่า" | mkN "ฐานะ" | mkN "สถานะ" | mkN "ท่าทาง" | mkN "ตำแหน่ง" | mkN "ท่วงท่า" | mkN "สถานภาพ" | mkN "หน้าที่" | mkN "สถานการณ์" | mkN "ตำแหน่งผู้เล่น" | mkN "ตำแหน่งหน้าที่" | mkN "งาน" | mkN "ชั้น" | mkN "ฐานะ" | mkN "สภาพ" | mkN "สถานะ" | mkN "ท่าทาง" | mkN "มุมมอง" | mkN "ที่ตั้ง" | mkN "ที่มั่น" | mkN "สถานภาพ" | mkN "ตําแหน่ง" | mkN "การจัดวาง" | mkN "การวางตัว" | mkN "หาตําแหน่ง" | mkN "การวางเข้าที่" | mkN "ระดับทางสังคม" | mkN "ฐานะสังคมที่สูง" | mkN "การวางตามตําแหน่ง" ; -- src=panlex
lin low_A = mkA "ต่ำ" | mkA "ทุ้ม" | mkA "เสียงต่ำ" | mkA "ซึ่งตกต่ำ" | mkA "ซึ่งมีไม่พอ" | mkA "ต่ำกว่าปรกติ" | mkA "ต่ำ" | mkA "เลว" | mkA "งอลง" | mkA "ชั่ว" | mkA "ต่ํา" | mkA "น้อย" | mkA "หดหู่" | mkA "หย่อน" | mkA "เตี้ย" | mkA "ความเลว" | mkA "ค่าต่ํา" | mkA "หดหู่ใจ" | mkA "หยาบคาย" | mkA "หยาบช้า" | mkA "อ่อนแรง" | mkA "เศร้าใจ" | mkA "ชั้นต่ํา" | mkA "ต่ําต้อย" | mkA "ต้อยต่ํา" | mkA "ราคาต่ํา" | mkA "อ่อนเพลีย" | mkA "เกียร์แรก" | mkA "เสียงต่ํา" | mkA "คุณภาพต่ํา" | mkA "เกียร์ต่ํา" | mkA "ไร้พละกําลัง" | mkA "รู้สึกไม่สบาย" | mkA "ไม่มีเรี่ยวแรง" | mkA "ต่ํากว่าระดับปกติ" | mkA "มีคุณค่าอาหารต่ํา" ; -- src=panlex
lin cost_N = mkN "ค่า" | mkN "ราคา" | mkN "คอสต์" | mkN "ต้นทุน" | mkN "มูลค่า" | mkN "ต้นทุน" | mkN "ค่าใช้จ่าย" | mkN "ความเสียหาย" | mkN "จํานวนเงินที่ต้องใช้" ; -- src=panlex
lin little_Det = variants{} ; -- 
lin matter_N = variants{} ; -- 
lin matter_1_N = variants{} ; -- 
lin matter_2_N = variants{} ; -- 
lin community_N = mkN "ชุมชน" | mkN "สังคม" | mkN "ชุมชีวิน" | mkN "ย่านอยู่อาศัย" | mkN "เขตที่อยู่อาศัย" | mkN "ความเป็นเจ้าของร่วม" | mkN "คณะ" | mkN "กลุ่ม" | mkN "ชุมชน" | mkN "สหคาม" | mkN "สังคม" | mkN "ลักษณะร่วม" | mkN "ลักษณะที่เหมือนกัน" ; -- src=panlex
lin remain_VV = mkVV "อยู่" ; ---- | mkV "ยังคง" | mkV "หลงเหลือ" | mkV "ยง" | mkV "อยู่" | mkV "คงอยู่" | mkV "รออยู่" | mkV "พักอยู่" | mkV "เหลืออยู่" | mkV "ยังเป็นอยู่" | mkV "ยังเหลืออยู่" | mkV "ยังเหมือนเดิม" ; -- src=panlex
lin remain_VA = mmkVA "อยู่" ; ---- | mkV "ยังคง" | mkV "หลงเหลือ" | mkV "ยง" | mkV "อยู่" | mkV "คงอยู่" | mkV "รออยู่" | mkV "พักอยู่" | mkV "เหลืออยู่" | mkV "ยังเป็นอยู่" | mkV "ยังเหลืออยู่" | mkV "ยังเหมือนเดิม" ; -- src=panlex
lin remain_V2 = mkV2 "อยู่" ; ---- | mkV "ยังคง" | mkV "หลงเหลือ" | mkV "ยง" | mkV "อยู่" | mkV "คงอยู่" | mkV "รออยู่" | mkV "พักอยู่" | mkV "เหลืออยู่" | mkV "ยังเป็นอยู่" | mkV "ยังเหลืออยู่" | mkV "ยังเหมือนเดิม" ; -- src=panlex
lin remain_V = mkV "อยู่" | mkV "ยังคง" | mkV "หลงเหลือ" | mkV "ยง" | mkV "อยู่" | mkV "คงอยู่" | mkV "รออยู่" | mkV "พักอยู่" | mkV "เหลืออยู่" | mkV "ยังเป็นอยู่" | mkV "ยังเหลืออยู่" | mkV "ยังเหมือนเดิม" ; -- src=panlex
lin figure_N = variants{} ; -- 
lin figure_2_N = variants{} ; -- 
lin figure_1_N = variants{} ; -- 
lin type_N = mkN "ชนิด" | mkN "ประเภท" | mkN "ลักษณะ" | mkN "ตัวพิมพ์" | mkN "อักษรที่ใช้พิมพ์" | mkN "ตรา" | mkN "แบบ" | mkN "ชนิด" | mkN "พิมพ์" | mkN "จําพวก" | mkN "ประเภท" | mkN "รูปแบบ" | mkN "ตัวอย่าง" | mkN "สัญลักษณ์" | mkN "เอกลักษณ์" | mkN "เครื่องหมาย" | mkN "หากลุ่มเลือด" | mkN "เป็นแบบอย่าง" | mkN "เป็นสัญลักษณ์" | mkN "ลักษณะที่เป็นแบบอย่าง" ; -- src=panlex
lin research_N = mkN "วิจัย" | mkN "งานวาด" | mkN "การวิจัย" | mkN "การค้นคว้า" | mkN "ค้นคว้า" | mkN "การวิจัย" | mkN "การศึกษา" | mkN "การค้นคว้า" | mkN "การสืบเสาะ" | mkN "การวินิจฉัย" ; -- src=panlex
lin actually_Adv = mkAdv "ที่จริง" | mkAdv "อันที่จริง" | mkAdv "ตามความเป็นจริง" | mkAdv "อย่างที่เกิดขึ้นตามจริง" ; -- src=panlex
lin education_N = mkN "การสอน" | mkN "การอบรม" | mkN "ความรู้" | mkN "การศึกษา" | mkN "การเรียน" | mkN "การเรียนการสอน" | mkN "การให้การศึกษา" | mkN "ความรู้จากการศึกษา" | mkN "การฝึกฝน" | mkN "การศึกษา" | mkN "การเรียน" | mkN "การสั่งสอน" | mkN "คุรุศาสตร์" | mkN "ศึกษาศาสตร์" | mkN "การให้ความรู้" ; -- src=panlex
lin fall_V = mkV (thword "ตก") | {-pan-} mkV "ตก" | mkV "หก" | mkV "พาด" | mkV "ฟุบ" | mkV "ล้ม" | mkV "ลดลง" | mkV "กระทบ" | mkV "ตกลงมา" | mkV "ตกตะลึง" | mkV "มาเยือน" | mkV "หมดวาระ" | mkV "กระทำบาป" | mkV "ถึงกำหนด" | mkV "ลดน้อยลง" | mkV "ลาดเอียง" | mkV "หมดอำนาจ" | mkV "ออกมาจาก" | mkV "คลอดออกมา" | mkV "ตกอยู่กับ" | mkV "ตกเป็นของ" | mkV "ตกเป็นภาระ" | mkV "ตกเป็นมรดก" | mkV "อยู่ภายใต้" | mkV "ตกอยู่ในมือ" | mkV "เป็นมรดกถึง" | mkV "สูญเสียอำนาจ" | mkV "ตกเป็นหน้าที่" | mkV "แสดงความผิดหวัง" | mkV "เสียความบริสุทธิ์" | mkV "ตกอยู่เป็นเมืองขึ้น" | mkV "ล้มตายเป็นใบไม้ร่วง" | mkV "ตกอยู่ภายใต้การครอบครอง" | mkV "เริ่มต้นอย่างคล่องแคล่ว" | mkV "ตก" | mkV "ตาย" | mkV "ล้ม" | mkV "แพ้" | mkV "ตกลง" | mkV "ร่วง" | mkV "ลดลง" | mkV "หล่น" | mkV "ต่ําลง" | mkV "น้อยลง" | mkV "มีขึ้น" | mkV "โดนยิง" | mkV "จัดขึ้น" | mkV "สะดุดล้ม" | mkV "ถูกโค่นล้ม" | mkV "โดนยึดอํานาจ" | mkV "เดินโซเซจนล้ม" ; -- src=panlex
lin speak_V2 = mkV2 "พูด" ;
lin speak_V = mkV "คุย" | mkV "พูด" | mkV "กล่าว" | mkV "พูดจา" | mkV "สนทนา" | mkV "พูดคุย" | mkV "กล่าวสุนทรพจน์" | mkV "แลกเปลี่ยนความคิดเห็น" | mkV "พูด" | mkV "สนทนา" | mkV "บรรยาย" ; -- src=panlex
lin few_N = mkN "จํานวนน้อย" | mkN "จํานวนไม่มาก" ; -- src=panlex
lin today_Adv = ss (thword "วัน" "นี้") | {-pan-} mkAdv "วันนี้" | mkAdv "เดี๋ยวนี้" | mkAdv "ในขณะนี้" | mkAdv "ในวันนี้" | mkAdv "เดี๋ยวนี้" | mkAdv "ในสมัยนี้" | mkAdv "ในปัจจุบันนี้" | mkAdv "ในยุคปัจจุบัน" ; -- src=panlex
lin enough_Adv = variants{} ; -- 
lin open_V2 = mkV2 (mkV "เปิด") ;
lin open_V = mkV "กาง" | mkV "เปิด" | mkV "เปิดงาน" | mkV "เปิดเกม" | mkV "เปิดอยู่" | mkV "เข้าไปยัง" | mkV "เปิดกว้าง" | mkV "สามารถเข้าไปยัง" | mkV "กาง" | mkV "อ้า" | mkV "คลี่" | mkV "เบิก" | mkV "เปิด" | mkV "เผยอ" | mkV "แง้ม" | mkV "เริ่ม" | mkV "เปิดออก" | mkV "เริ่มต้น" | mkV "เริ่มเดิน" | mkV "เริ่มปฏิบัติงาน" | mkV "เปิดหรือเริ่มพิธีอย่างเป็นทางการ" ; -- src=panlex
lin bad_A = mkA (thword "เลว") | {-pan-} mkA "เลว" | mkA "แย่" | mkA "เสีย" | mkA "ไม่ดี" | mkA "ยอดแย่" | mkA "แสดงความเสียใจ" | mkA "เลว" | mkA "แย่" | mkA "ชั่ว" | mkA "ร้าย" | mkA "ร้้าย" | mkA "ไม่ดี" | mkA "ชั่วช้า" | mkA "ผิดหวัง" | mkA "เลวทราม" | mkA "เลวร้าย" | mkA "ไม่พอใจ" | mkA "เป็นอันตราย" | mkA "ไม่มีความสุข" | mkA "ต่ํากว่ามาตรฐาน" | mkA "ีไม่เป็นที่ยอมรับบ" ; -- src=panlex
lin buy_V2 = mkV2 "ซื้อ" ;
lin buy_V = mkV "รับ" | mkV "ซื้อ" | mkV "ติดสินบน" | mkV "จ่ายใต้โต๊ะ" | mkV "ซื้อ" ; -- src=panlex
lin programme_N = mkN "แผน" | mkN "รายการ" | mkN "แผนการ" | mkN "โครงการ" | mkN "โปรแกรม" | mkN "หลักสูตร" | mkN "รายการออกอากาศ" | mkN "โปรแกรมการแสดง" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "รายการ" | mkN "แผนงาน" | mkN "ชุดคําสั่งที่ใช้ควบคุมเครื่องอิเล็กทรอนิค" ; -- src=panlex
lin minute_N = mkN "นท." | mkN "นาที" | mkN "ชั่วครู่" | mkN "อาร์กมินิต" | mkN "นาที" | mkN "การสรุป" | mkN "ชั่วขณะ" | mkN "เล็กมาก" | mkN "ไม่สําคัญ" | mkN "เล็กน้อยมาก" | mkN "ช่วงเวลาสั้นๆ" | mkN "บันทึกความจํา" | mkN "บันทึกเป็นนาที" | mkN "สําคัญเล็กน้อย" | mkN "ระยะเวลาอันสั้น" | mkN "ซึ่งใช้เวลาเล็กน้อยในการทํา" ; -- src=panlex
lin moment_N = mkN "ขณะนี้" | mkN "ตอนนี้" | mkN "โมเมนต์" | mkN "ชั่วครู่" | mkN "มีผลกระทบต่อ" | mkN "ขณะ" | mkN "โอกาส" | mkN "ขณะนั้น" | mkN "ชั่วขณะ" | mkN "ชั่วครู่" | mkN "ความสําคัญ" | mkN "ผลที่ตามมา" | mkN "เวลาสําคัญ" | mkN "โอกาสสําคัญ" | mkN "ลักษณะของสิ่งของ" | mkN "ความสําคัญของขณะนั้น" ; -- src=panlex
lin girl_N = mkN (thword "เด็ก" "ผู้" "หญิง") "คน" | {-pan-} mkN "สาว" | mkN "ธิดา" | mkN "หญิง" | mkN "บุตรี" | mkN "ลูกสาว" | mkN "แฟนสาว" | mkN "กุลธิดา" | mkN "ทรามวัย" | mkN "บุตรสาว" | mkN "พระธิดา" | mkN "ลูกหญิง" | mkN "หญิงสาว" | mkN "เด็กสาว" | mkN "บุตรหญิง" | mkN "เด็กหญิง" | mkN "หญิงคนรัก" | mkN "เพื่อนหญิง" | mkN "เด็กผู้หญิง" | mkN "คนรัก" | mkN "หญิงสาว" | mkN "เด็กสาว" | mkN "เพื่อนหญิง" | mkN "เด็กผู้หญิง" ; -- src=panlex
lin age_N = mkN "ยุค" | mkN "วัย" | mkN "อายุ" | mkN "ชันษา" | mkN "พรรษา" | mkN "วัยชรา" | mkN "อายุขัย" | mkN "พระชันษา" | mkN "พระชนมายุ" | mkN "วัยแก่ชรา" | mkN "วัยแก่เฒ่า" | mkN "พระชนมพรรษา" | mkN "เวลาอันยาวนาน" | mkN "ยุค" | mkN "วัย" | mkN "ช่วง" | mkN "รุ่น" | mkN "สมัย" | mkN "อายุ" | mkN "ความแก่" | mkN "ช่วงวัย" | mkN "ยุคสมัย" | mkN "นิติภาวะ" | mkN "ช่วงชีวิต" | mkN "ระดับการพัฒนา" | mkN "การเป็นผู้ใหญ่ตามกฎหมาย" ; -- src=panlex
lin centre_N = mkN "ไส้" | mkN "สาระ" | mkN "แก่น" | mkN "ศูนย์" | mkN "เนื้อๆ" | mkN "ใจกลาง" | mkN "ไส้ขนม" | mkN "จุดสนใจ" | mkN "ตรงกลาง" | mkN "เนื้อหา" | mkN "ศูนย์กลาง" | mkN "เซ็นเตอร์" | mkN "จุดกึ่งกลาง" | mkN "แก่นความคิด" | mkN "ศูนย์รวมเซลล์ประสาท" | mkN "ที่มา" | mkN "หัวใจ" | mkN "จุดรวม" | mkN "ที่รวม" | mkN "ใจกลาง" | mkN "จุดสนใจ" | mkN "ต้นเหตุ" | mkN "แกนกลาง" | mkN "ศูนย์รวม" | mkN "จุดสําคัญ" | mkN "ศูนย์กลาง" | mkN "จุดศูนย์รวม" | mkN "ศูนย์การค้า" | mkN "" | mkN "ศูนย์เฉพาะกิจ เช่น ศูนย์ช่วยเหลือผู้ประสบภัยน้ําท่วม" | mkN "ผู้เล่นในแดนกลาง" | mkN "ศูนย์รวมความสนใจ" | mkN "ศูนย์รวมเซลล์ประสาท" | mkN "สถานที่ที่เป็นศูนย์รวม" | mkN "คนหรือกลุ่มที่อยู่ในตําแหน่งตรงกลาง" ; -- src=panlex
lin stop_VV = mkVV "หยุด" ; ---- | {-pan-} mkV "จบ" | mkV "คอย" | mkV "ปิด" | mkV "ยุติ" | mkV "อวสาน" | mkV "ดักจับ" | mkV "ปิดถนน" | mkV "ขัดขวาง" | mkV "สิ้นสุด" | mkV "สกัดกั้น" | mkV "ยกเลิกแผนการเดินทาง" | mkV "จุก" | mkV "ปิด" | mkV "อุด" | mkV "ยั้ง" | mkV "ยุติ" | mkV "เลิก" | mkV "ระงับ" | mkV "ปิดกั้น" | mkV "ป้องกัน" | mkV "ยับยั้ง" ; -- src=panlex
lin stop_V2 = mkV2 "หยุด" ; ---- | {-pan-} mkV "จบ" | mkV "คอย" | mkV "ปิด" | mkV "ยุติ" | mkV "อวสาน" | mkV "ดักจับ" | mkV "ปิดถนน" | mkV "ขัดขวาง" | mkV "สิ้นสุด" | mkV "สกัดกั้น" | mkV "ยกเลิกแผนการเดินทาง" | mkV "จุก" | mkV "ปิด" | mkV "อุด" | mkV "ยั้ง" | mkV "ยุติ" | mkV "เลิก" | mkV "ระงับ" | mkV "ปิดกั้น" | mkV "ป้องกัน" | mkV "ยับยั้ง" ; -- src=panlex
lin stop_V = mkV "หยุด" | {-pan-} mkV "จบ" | mkV "คอย" | mkV "ปิด" | mkV "ยุติ" | mkV "อวสาน" | mkV "ดักจับ" | mkV "ปิดถนน" | mkV "ขัดขวาง" | mkV "สิ้นสุด" | mkV "สกัดกั้น" | mkV "ยกเลิกแผนการเดินทาง" | mkV "จุก" | mkV "ปิด" | mkV "อุด" | mkV "ยั้ง" | mkV "ยุติ" | mkV "เลิก" | mkV "ระงับ" | mkV "ปิดกั้น" | mkV "ป้องกัน" | mkV "ยับยั้ง" ; -- src=panlex
lin control_N = mkN "ความรู้" | mkN "การควบคุม" | mkN "ความชำนาญ" | mkN "ตัวควบคุม" | mkN "การคอนโทรล" | mkN "การมีอำนาจ" | mkN "ตัวคอนโทรล" | mkN "อำนาจควบคุม" | mkN "คอนโทรลเลอร์" | mkN "การควบคุมราคา" | mkN "เงื่อนไขควบคุม" | mkN "การควบคุมทางสังคม" | mkN "มาตรฐานเปรียบเทียบ" | mkN "ทักษะ" | mkN "การจํากัด" | mkN "ผู้ควบคุม" | mkN "เครื่องควบคุม" | mkN "อํานาจในการควบคุม" | mkN "สถานที่ที่ใช้ในการควบคุม" | mkN "มาตรฐานเปรียบเทียบในการทดลอง" ; -- src=panlex
lin value_N = mkN "ค่า" | mkN "มูลค่า" | mkN "ค่าของโน้ต" | mkN "ค่าความสว่างของสี" | mkN "มูลค่าทางเศรษฐกิจ" | mkN "ค่า" | mkN "ขนาด" | mkN "ราคา" | mkN "ระดับ" | mkN "คุณค่า" | mkN "ปริมาณ" | mkN "มูลค่า" | mkN "ความนิยม" | mkN "ความพอใจ" | mkN "ความหมาย" | mkN "ค่าตอบแทน" | mkN "ประมาณค่า" | mkN "ความสําคัญ" | mkN "ให้เกียรติ" | mkN "คุณประโยชน์" | mkN "ค่าเป็นเงิน" | mkN "หน่วยเงินตรา" | mkN "ให้ความสําคัญ" | mkN "นับถืออย่างสูง" | mkN "คํานวณค่าเป็นเงิน" ; -- src=panlex
lin send_V2V = mmkV2V "ส่ง" ; ---- | mkV "ขนส่ง" | mkV "ถ่ายทอด" | mkV "ออกอากาศ" | mkV "ส่งสินค้า" | mkV "กระจายเสียง" | mkV "ขนส่งสินค้า" | mkV "ส่ง" | mkV "ขับออก" | mkV "จัดส่ง" | mkV "นําส่ง" | mkV "ส่งข่าว" | mkV "ปล่อยออก" | mkV "ส่งสัญญาณ" | mkV "ให้ข้อมูล" | mkV "เปล่งออกมา" | mkV "กระจายเสียง" | mkV "ทําให้ตื่นเต้น" | mkV "ทําให้ปิติยินดี" ; -- src=panlex
lin send_V2 = mkV2 "ส่ง" ; ---- | mkV "ขนส่ง" | mkV "ถ่ายทอด" | mkV "ออกอากาศ" | mkV "ส่งสินค้า" | mkV "กระจายเสียง" | mkV "ขนส่งสินค้า" | mkV "ส่ง" | mkV "ขับออก" | mkV "จัดส่ง" | mkV "นําส่ง" | mkV "ส่งข่าว" | mkV "ปล่อยออก" | mkV "ส่งสัญญาณ" | mkV "ให้ข้อมูล" | mkV "เปล่งออกมา" | mkV "กระจายเสียง" | mkV "ทําให้ตื่นเต้น" | mkV "ทําให้ปิติยินดี" ; -- src=panlex
lin send_V = mkV "ส่ง" | mkV "ขนส่ง" | mkV "ถ่ายทอด" | mkV "ออกอากาศ" | mkV "ส่งสินค้า" | mkV "กระจายเสียง" | mkV "ขนส่งสินค้า" | mkV "ส่ง" | mkV "ขับออก" | mkV "จัดส่ง" | mkV "นําส่ง" | mkV "ส่งข่าว" | mkV "ปล่อยออก" | mkV "ส่งสัญญาณ" | mkV "ให้ข้อมูล" | mkV "เปล่งออกมา" | mkV "กระจายเสียง" | mkV "ทําให้ตื่นเต้น" | mkV "ทําให้ปิติยินดี" ; -- src=panlex
lin health_N = mkN "สุขภาพ" | mkN "สุขภาพ" | mkN "กําลังวังชา" | mkN "ความแข็งแรง" | mkN "สภาพร่างกาย" | mkN "การอวยพรให้สุขสบาย" ; -- src=panlex
lin decide_VV = mkVV "ตัดสิน" ; ---- | mkV "ตัดสินใจ" | mkV "ทำให้ตัดสินใจ" | mkV "ชี้ขาด" | mkV "ตกลงใจ" | mkV "ตัดสินใจ" ; -- src=panlex
lin decide_VS = mmkVS "ตัดสิน" ; ---- | mkV "ตัดสินใจ" | mkV "ทำให้ตัดสินใจ" | mkV "ชี้ขาด" | mkV "ตกลงใจ" | mkV "ตัดสินใจ" ; -- src=panlex
lin decide_V2 = mkV2 "ตัดสิน" ; ---- | mkV "ตัดสินใจ" | mkV "ทำให้ตัดสินใจ" | mkV "ชี้ขาด" | mkV "ตกลงใจ" | mkV "ตัดสินใจ" ; -- src=panlex
lin decide_V = mkV "ตัดสิน" | mkV "ตัดสินใจ" | mkV "ทำให้ตัดสินใจ" | mkV "ชี้ขาด" | mkV "ตกลงใจ" | mkV "ตัดสินใจ" ; -- src=panlex
lin main_A = mkA "หลัก" | mkA "กําลัง" | mkA "ที่สุด" | mkA "สําคัญ" | mkA "ชั้นนํา" | mkA "ท่อหลัก" | mkA "ทะเลหลวง" | mkA "มหาสมุทร" | mkA "ส่วนใหญ่" | mkA "มากที่สุด" | mkA "ใหญ่ที่สุด" | mkA "สําคัญที่สุด" | mkA "ความพยายามที่รุนแรง" ; -- src=panlex
lin win_V2 = mkV2 "ชนะ" ;
lin win_V = mkV "ชนะ" | mkV "ขึ้นนำ" | mkV "ขึ้นแท่น" | mkV "ได้เปรียบ" | mkV "ประสบผลสำเร็จ" | mkV "ประสบความสำเร็จ" | mkV "ชนะ" | mkV "มีชัย" | mkV "ชนะเลิศ" ; -- src=panlex
lin understand_VS = mmkVS "รู้" ; ---- | mkV "เข้าใจ" | mkV "ตระหนัก" | mkV "เห็นอกเห็นใจ" | mkV "เข้าใจ" | mkV "รู้เรื่อง" ; -- src=panlex
lin understand_V2 = mkV2 (mkV (thword "เข้า" "ใจ")) ;
lin understand_V = mkV "รู้" | mkV "เข้าใจ" | mkV "ตระหนัก" | mkV "เห็นอกเห็นใจ" | mkV "เข้าใจ" | mkV "รู้เรื่อง" ; -- src=panlex
lin decision_N = mkN "คำตัดสิน" | mkN "การตัดสิน" | mkN "การตัดสินใจ" | mkN "ความเด็ดขาด" | mkN "ผลการตัดสิน" | mkN "ความเห็นต่อท้าย" | mkN "ญัตติ" | mkN "การสรุป" | mkN "การกําหนด" | mkN "การตกลงใจ" | mkN "ข้อตกลงใจ" | mkN "คําตัดสิน" | mkN "การพิพากษา" | mkN "คําพิพากษา" | mkN "การตัดสินใจ" | mkN "ความแน่วแน่" | mkN "สิ่งที่ได้ตัดสินใจ" ; -- src=panlex
lin develop_V2 = mkV2 "งอก" ; ---- | mkV "ฉาย" | mkV "ฝึก" | mkV "ขึ้น" | mkV "เทรน" | mkV "พัฒนา" | mkV "สร้าง" | mkV "วางซ้อน" | mkV "ก้าวหน้า" | mkV "คลี่คลาย" | mkV "ปรับปรุง" | mkV "เกิดขึ้น" | mkV "เริ่มต้น" | mkV "ทำให้กว้าง" | mkV "เดินให้ได้เปรียบ" | mkV "เร่งให้เจริญเติบโต" | mkV "มีพัฒนาการทางร่างกาย" | mkV "เปลี่ยนเป็นสังคมสมัยใหม่" | mkV "พัฒนา" | mkV "เจริญ" | mkV "เติบโต" | mkV "บุกเบิก" | mkV "ริเริ่ม" | mkV "ขยายความ" | mkV "เริ่มต้น" | mkV "วิวัฒนาการ" | mkV "ทําให้เจริญ" | mkV "ทําให้ดีขึ้น" | mkV "ทําให้เติบโต" | mkV "ให้รายละเอียด" ; -- src=panlex
lin develop_V = mkV "งอก" | mkV "ฉาย" | mkV "ฝึก" | mkV "ขึ้น" | mkV "เทรน" | mkV "พัฒนา" | mkV "สร้าง" | mkV "วางซ้อน" | mkV "ก้าวหน้า" | mkV "คลี่คลาย" | mkV "ปรับปรุง" | mkV "เกิดขึ้น" | mkV "เริ่มต้น" | mkV "ทำให้กว้าง" | mkV "เดินให้ได้เปรียบ" | mkV "เร่งให้เจริญเติบโต" | mkV "มีพัฒนาการทางร่างกาย" | mkV "เปลี่ยนเป็นสังคมสมัยใหม่" | mkV "พัฒนา" | mkV "เจริญ" | mkV "เติบโต" | mkV "บุกเบิก" | mkV "ริเริ่ม" | mkV "ขยายความ" | mkV "เริ่มต้น" | mkV "วิวัฒนาการ" | mkV "ทําให้เจริญ" | mkV "ทําให้ดีขึ้น" | mkV "ทําให้เติบโต" | mkV "ให้รายละเอียด" ; -- src=panlex
lin class_N = mkN "ปี" | mkN "คลาส" | mkN "ชั้น" | mkN "คอร์ส" | mkN "ชนชั้น" | mkN "ประเภท" | mkN "ดิวิชัน" | mkN "หลักสูตร" | mkN "ระดับชั้น" | mkN "ความสวยหรู" | mkN "ชนชั้นทางสังคม" | mkN "หลักสูตรการศึกษา" | mkN "หลักสูตรการเรียน" | mkN "ชนชั้นทางเศรษฐกิจและสังคม" | mkN "ชนชั้น" | mkN "ชั้นเรียน" | mkN "ประเภทหรือชนิด" ; -- src=panlex
lin industry_N = mkN (thword "อุต" "สาห" "กรรม") | {-pan-} mkN "อุตสาหกรรม" | mkN "ธุรกิจอุตสาหกรรม" | mkN "บริษัทอุตสาหกรรม" | mkN "การค้า" | mkN "ธุรกิจ" | mkN "ความมานะ" | mkN "การพาณิชย์" | mkN "ความพยายาม" | mkN "อุตสาหกรรม" | mkN "ความอุตสาหะ" | mkN "ภาคอุตสาหกรรม" | mkN "การทํางานที่มีระบบ" | mkN "ความขยันหมั่นเพียร" | mkN "ธุรกิจการค้าทั่วไป" | mkN "เจ้าของกิจการและผู้จัดการทั่วไป" ; -- src=panlex ----?
lin receive_V2 = mkV2 "รับ" ; ---- | mkV "ได้" | mkV "เกิด" | mkV "ประสบ" | mkV "รับศีล" | mkV "รับโทษ" | mkV "รู้สึก" | mkV "ได้รับ" | mkV "ต้อนรับ" | mkV "รับสัญญาณ" | mkV "รับ" | mkV "ยอมรับ" | mkV "ได้รับ" | mkV "ต้อนรับ" | mkV "ให้การต้อนรับ" | mkV "รับและแปลงสัญญาณไฟฟ้า" ; -- src=panlex
lin receive_V = mkV "รับ" | mkV "ได้" | mkV "เกิด" | mkV "ประสบ" | mkV "รับศีล" | mkV "รับโทษ" | mkV "รู้สึก" | mkV "ได้รับ" | mkV "ต้อนรับ" | mkV "รับสัญญาณ" | mkV "รับ" | mkV "ยอมรับ" | mkV "ได้รับ" | mkV "ต้อนรับ" | mkV "ให้การต้อนรับ" | mkV "รับและแปลงสัญญาณไฟฟ้า" ; -- src=panlex
lin back_N = mkN (thword "หลัง") | {-pan-} mkN "ปก" | mkN "หลัง" | mkN "แบ็ก" | mkN "ที่พิง" | mkN "กองหลัง" | mkN "พนักพิง" | mkN "ด้านหลัง" | mkN "พนักพิงหลัง" | mkN "กระดูกสันหลัง" | mkN "ตำแหน่งกองหลัง" | mkN "ผู้เล่นกองหลัง" | mkN "การเข้าปกหนังสือ" | mkN "หลัง" | mkN "ที่พิง" | mkN "กองหลัง" | mkN "พนักพิง" | mkN "ด้านท้าย" | mkN "ด้านหลัง" | mkN "ส่วนท้าย" | mkN "ส่วนหลัง" | mkN "แผ่นหลัง" | mkN "พนักเก้าอี้" | mkN "กระดูกสันหลัง" ; -- src=panlex
lin several_Det = variants{} ; -- 
lin return_V2 = mkV2 "คืน" ; ---- | mkV "ส่ง" | mkV "กลับ" | mkV "โต้ตอบ" | mkV "ให้คืน" | mkV "จ่ายคืน" | mkV "ตกตะลึง" | mkV "โต้แย้ง" | mkV "กลับไปสู่" | mkV "ให้ผลผลิต" | mkV "ตกเป็นมรดก" | mkV "เดินทางกลับ" | mkV "เป็นมรดกถึง" | mkV "ถอยกลับไปสู่" | mkV "เลือกตั้งซ่อม" | mkV "ทำให้หวนนึกถึง" | mkV "กลับสู่สภาพเดิม" | mkV "ได้รับการฟื้นฟู" | mkV "กลับสู่ตำแหน่งแรก" | mkV "ตอบ" | mkV "ชดเชย" | mkV "ชดใช้" | mkV "ให้ผล" | mkV "กลับมา" | mkV "โต้ตอบ" | mkV "กลับคืน" | mkV "คืนกลับ" | mkV "หวนกลับ" | mkV "เตะกลับ" | mkV "เตะลูกกลับ" | mkV "ได้ผลกําไร" | mkV "เลือกกลับเข้าไปอีก" ; -- src=panlex
lin return_V = mkV "คืน" | mkV "ส่ง" | mkV "กลับ" | mkV "โต้ตอบ" | mkV "ให้คืน" | mkV "จ่ายคืน" | mkV "ตกตะลึง" | mkV "โต้แย้ง" | mkV "กลับไปสู่" | mkV "ให้ผลผลิต" | mkV "ตกเป็นมรดก" | mkV "เดินทางกลับ" | mkV "เป็นมรดกถึง" | mkV "ถอยกลับไปสู่" | mkV "เลือกตั้งซ่อม" | mkV "ทำให้หวนนึกถึง" | mkV "กลับสู่สภาพเดิม" | mkV "ได้รับการฟื้นฟู" | mkV "กลับสู่ตำแหน่งแรก" | mkV "ตอบ" | mkV "ชดเชย" | mkV "ชดใช้" | mkV "ให้ผล" | mkV "กลับมา" | mkV "โต้ตอบ" | mkV "กลับคืน" | mkV "คืนกลับ" | mkV "หวนกลับ" | mkV "เตะกลับ" | mkV "เตะลูกกลับ" | mkV "ได้ผลกําไร" | mkV "เลือกกลับเข้าไปอีก" ; -- src=panlex
lin build_V2 = mkV2 "สะสม" ; ---- | mkV "สร้าง" | mkV "เสริม" | mkV "ก่อสร้าง" | mkV "ก่อ" | mkV "รัง" | mkV "ตั้ง" | mkV "ปลูก" | mkV "สร้าง" | mkV "สถาปนา" ; -- src=panlex
lin build_V = mkV "สะสม" | mkV "สร้าง" | mkV "เสริม" | mkV "ก่อสร้าง" | mkV "ก่อ" | mkV "รัง" | mkV "ตั้ง" | mkV "ปลูก" | mkV "สร้าง" | mkV "สถาปนา" ; -- src=panlex
lin spend_V2 = mkV2 "ใช้" ; ---- | mkV "จ่าย" | mkV "ใช้เงิน" | mkV "ใช้เวลา" | mkV "ใช้จ่ายเงิน" | mkV "ใช้เงินเกลี้ยง" | mkV "ใช้จ่าย" | mkV "ใช้เงิน" | mkV "ให้เงิน" | mkV "จ่ายเงิน" ; -- src=panlex
lin spend_V = mkV "ใช้" | mkV "จ่าย" | mkV "ใช้เงิน" | mkV "ใช้เวลา" | mkV "ใช้จ่ายเงิน" | mkV "ใช้เงินเกลี้ยง" | mkV "ใช้จ่าย" | mkV "ใช้เงิน" | mkV "ให้เงิน" | mkV "จ่ายเงิน" ; -- src=panlex
lin force_N = mkN "แรง" | mkN "พลัง" | mkN "กองทัพ" | mkN "กองกำลัง" | mkN "ฟอร์ซเอาต์" | mkN "กองกำลังทหาร" | mkN "มีผลบังคับใช้" | mkN "การใช้ความรุนแรง" | mkN "กลุ่มผู้ปฏิบัติงาน" | mkN "กลุ่มผู้ปฏิบัติหน้าที่" | mkN "แรง" | mkN "พลัง" | mkN "กลุ่ม" | mkN "กองทัพ" | mkN "กําลัง" | mkN "อํานาจ" | mkN "กองทหาร" | mkN "พลังจิต" | mkN "อิทธิพล" | mkN "ยัดเยียด" | mkN "กองกําลัง" | mkN "การบังคับ" | mkN "กําลังแรง" | mkN "ความรุนแรง" | mkN "บังคับให้รับ" | mkN "การข่มขู่บังคับ" | mkN "ผลบังคับทางกฎหมาย" | mkN "อํานาจในการชักจูง" | mkN "อํานาจในการโน้มน้าว" | mkN "หน่วยวัดความแรงของลม" | mkN "คนหรือสิ่งที่มีอํานาจหรืออิทธิพล" ; -- src=panlex
lin condition_N = variants{} ; -- 
lin condition_1_N = variants{} ; -- 
lin condition_2_N = variants{} ; -- 
lin paper_N = mkN (thword "กระ" "ดาษ") | {-pan-} mkN "น.ส.พ." | mkN "นสพ." | mkN "กระดาษ" | mkN "บทความ" | mkN "รายงาน" | mkN "เปเปอร์" | mkN "กระดาษจด" | mkN "หนังสือพิมพ์" | mkN "บทความวิชาการ" | mkN "บทความทางวิชาการ" | mkN "กระดาษหนังสือพิมพ์" | mkN "บริษัทหนังสือพิมพ์" | mkN "กระดาษ" | mkN "ข้อสอบ" | mkN "รายงาน" | mkN "เอกสาร" | mkN "สิ่งพิมพ์" | mkN "วอลเปเปอร์" | mkN "แผ่นกระดาษ" | mkN "หนังสือพิมพ์" | mkN "กระดาษบุฝาผนัง" ; -- src=panlex ----?
lin off_Prep = mkPrep "ออกจาก" | mkPrep "ลดลงจาก" | mkPrep "หยุดงาน" | mkPrep "ไม่ทํางาน" ; -- src=panlex
lin major_A = mkA "ส่วนมาก" | mkA "ส่วนใหญ่" | mkA "สําคัญมาก" ; -- src=panlex
lin describe_VS = variants{} ; -- 
lin describe_V2 = variants{} ; -- 
lin agree_VV = mkVV "เหมาะ" ; ---- | mkV "ตรงกัน" | mkV "ยอมรับ" | mkV "กลมกลืน" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เหมือนกัน" | mkV "ตกลง" | mkV "ตัดสิน" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "เข้ากัน" | mkV "ลงรอยกัน" | mkV "เหมาะกับ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "สอดคล้องกัน" | mkV "ไปด้วยกันได้" | mkV "ยอมรับความจริง" ; -- src=panlex
lin agree_VS = mmkVS "เหมาะ" ; ---- | mkV "ตรงกัน" | mkV "ยอมรับ" | mkV "กลมกลืน" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เหมือนกัน" | mkV "ตกลง" | mkV "ตัดสิน" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "เข้ากัน" | mkV "ลงรอยกัน" | mkV "เหมาะกับ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "สอดคล้องกัน" | mkV "ไปด้วยกันได้" | mkV "ยอมรับความจริง" ; -- src=panlex
lin agree_V = mkV "เหมาะ" | mkV "ตรงกัน" | mkV "ยอมรับ" | mkV "กลมกลืน" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เหมือนกัน" | mkV "ตกลง" | mkV "ตัดสิน" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "เข้ากัน" | mkV "ลงรอยกัน" | mkV "เหมาะกับ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "สอดคล้องกัน" | mkV "ไปด้วยกันได้" | mkV "ยอมรับความจริง" ; -- src=panlex
lin economic_A = mkA "ทางเศรษฐกิจ" | mkA "ในทางเศรษฐศาสตร์" | mkA "เกี่ยวกับเศรษฐกิจ" | mkA "เกี่ยวกับเศรษฐศาสตร์" | mkA "เกี่ยวกับภาวะทางเศรษฐกิจ" ; -- src=panlex
lin increase_V2 = mkV2 "เพิ่ม" ; ---- | mkV "เพิ่มขึ้น" | mkV "ทำให้เพิ่ม" | mkV "เพิ่ม" | mkV "เพิ่มขึ้น" | mkV "เพิ่มมากขึ้น" ; -- src=panlex
lin increase_V = mkV "เพิ่ม" | mkV "เพิ่มขึ้น" | mkV "ทำให้เพิ่ม" | mkV "เพิ่ม" | mkV "เพิ่มขึ้น" | mkV "เพิ่มมากขึ้น" ; -- src=panlex
lin upon_Prep = mkPrep "บน" | mkPrep "เหนือ" ; -- src=panlex
lin learn_VV = mkVV "จำ" ; ---- | mkV "รู้" | mkV "สอน" | mkV "จดจำ" | mkV "ศึกษา" | mkV "สิกขา" | mkV "เรียน" | mkV "ชี้แนะ" | mkV "ค้นคว้า" | mkV "จำใส่ใจ" | mkV "เรียนรู้" | mkV "จดจำใส่ใจ" | mkV "ถ่ายทอดความรู้" | mkV "รู้" | mkV "ทราบ" | mkV "ท่อง" | mkV "ฝึกฝน" | mkV "ศึกษา" | mkV "สิกขา" | mkV "เรียน" | mkV "ฝึกหัด" | mkV "รับรู้" | mkV "ได้ยิน" | mkV "ท่องจํา" | mkV "ฝึกปรือ" | mkV "เรียนรู้" | mkV "เข้าเรียน" | mkV "เล่าเรียน" ; -- src=panlex
lin learn_VS = mmkVS "จำ" ; ---- | mkV "รู้" | mkV "สอน" | mkV "จดจำ" | mkV "ศึกษา" | mkV "สิกขา" | mkV "เรียน" | mkV "ชี้แนะ" | mkV "ค้นคว้า" | mkV "จำใส่ใจ" | mkV "เรียนรู้" | mkV "จดจำใส่ใจ" | mkV "ถ่ายทอดความรู้" | mkV "รู้" | mkV "ทราบ" | mkV "ท่อง" | mkV "ฝึกฝน" | mkV "ศึกษา" | mkV "สิกขา" | mkV "เรียน" | mkV "ฝึกหัด" | mkV "รับรู้" | mkV "ได้ยิน" | mkV "ท่องจํา" | mkV "ฝึกปรือ" | mkV "เรียนรู้" | mkV "เข้าเรียน" | mkV "เล่าเรียน" ; -- src=panlex
lin learn_V2 = mkV2 (mkV "เรียน") ;
lin learn_V = mkV "จำ" | mkV "รู้" | mkV "สอน" | mkV "จดจำ" | mkV "ศึกษา" | mkV "สิกขา" | mkV "เรียน" | mkV "ชี้แนะ" | mkV "ค้นคว้า" | mkV "จำใส่ใจ" | mkV "เรียนรู้" | mkV "จดจำใส่ใจ" | mkV "ถ่ายทอดความรู้" | mkV "รู้" | mkV "ทราบ" | mkV "ท่อง" | mkV "ฝึกฝน" | mkV "ศึกษา" | mkV "สิกขา" | mkV "เรียน" | mkV "ฝึกหัด" | mkV "รับรู้" | mkV "ได้ยิน" | mkV "ท่องจํา" | mkV "ฝึกปรือ" | mkV "เรียนรู้" | mkV "เข้าเรียน" | mkV "เล่าเรียน" ; -- src=panlex
lin general_A = mkA "สากล" | mkA "ทั่วไป" | mkA "นายพล" | mkA "ทั่วไป" | mkA "ไม่จํากัด" | mkA "ไม่เฉพาะเจาะจง" ; -- src=panlex
lin century_N = mkN "๑๐๐" | mkN "ร้อย" | mkN "ร้อยปี" | mkN "หนึ่งร้อย" | mkN "100" | mkN "ศตวรรษ" | mkN "" | mkN "หนึ่งร้อยปี" | mkN "หนึ่งร้อยชิ้น" | mkN "จํานวนหนึ่งร้อย" | mkN "กองร้อยทหารโรมัน" ; -- src=panlex
lin therefore_Adv = mkAdv "ดังนั้น" | mkAdv "ดังนั้น" | mkAdv "เพราะฉะนั้น" ; -- src=panlex
lin father_N = mkN "ดอน" | mkN "พ่อ" | mkN "บิดา" | mkN "ต้นสกุล" | mkN "ฟาเตอร์" | mkN "หัวหน้า" | mkN "ต้นตระกูล" | mkN "ผู้ก่อตั้ง" | mkN "หัวหน้ามาเฟีย" | mkN "ผู้ก่อตั้งตระกูล" | mkN "ชนก" | mkN "พ่อ" | mkN "บิดร" | mkN "บิดา" | mkN "คุณพ่อ" | mkN "บาทหลวง" | mkN "หลวงพ่อ" | mkN "พ่อเลี้ยง" | mkN "ผู้ก่อตั้ง" | mkN "ผู้ริเริ่ม" | mkN "พ่อบุญธรรม" | mkN "ผู้ให้กําเนิด" | mkN "พระในศาสนาคริสต์" ; -- src=panlex
lin section_N = mkN "ตอน" | mkN "ภาค" | mkN "กลีบ" | mkN "ฝ่าย" | mkN "ส่วน" | mkN "แผนก" | mkN "พาร์ต" | mkN "เซคชั่น" | mkN "การผ่าตัด" | mkN "ภาคตัดบนระนาบ" | mkN "ข้อ" | mkN "คณะ" | mkN "ตอน" | mkN "ผ่า" | mkN "เขต" | mkN "แยก" | mkN "ชิ้น" | mkN "ช่วง" | mkN "ท่อน" | mkN "วรรค" | mkN "ส่วน" | mkN "หมวด" | mkN "หมู่" | mkN "แบ่ง" | mkN "แผนก" | mkN "กลุ่ม" | mkN "มาตรา" | mkN "วงการ" | mkN "หน่วย" | mkN "เหล่า" | mkN "การตัด" | mkN "ผ่าตัด" | mkN "ส่วนตัด" | mkN "ส่วนย่อย" | mkN "การตัดออก" | mkN "เขตพื้นที่" | mkN "ส่วนที่ตัดออก" | mkN "ส่วนที่แยกออก" ; -- src=panlex
lin patient_N = mkN "คนป่วย" | mkN "ผู้ป่วย" | mkN "หน้าที่ผู้ทรงสภาพ" | mkN "คนไข้" | mkN "คนป่วย" | mkN "คนเจ็บ" | mkN "ผู้ป่วย" ; -- src=panlex
lin around_Adv = mkAdv "หัน" | mkAdv "ทั่ว" | mkAdv "รอบๆ" | mkAdv "ประมาณ" | mkAdv "รอบ" | mkAdv "ราว" | mkAdv "กลับ" | mkAdv "ผ่าน" | mkAdv "รอบๆ" | mkAdv "ราวๆ" | mkAdv "ใกล้ๆ" | mkAdv "ไปยัง" | mkAdv "วกกลับ" | mkAdv "โดยรอบ" | mkAdv "อ้อมรอบ" | mkAdv "อยู่รอบ ๆ" | mkAdv "อ้อมผ่าน" | mkAdv "โดยประมาณ" | mkAdv "ไม่ไกลนัก" ; -- src=panlex
lin activity_N = mkN "กิจกรรม" | mkN "กระฉับกระเฉง" | mkN "กระบวนการตามธรรมชาติ" | mkN "กิจกรรม" | mkN "การกระทํา" | mkN "การเคลื่อนไหว" | mkN "การกระตือรือร้น" | mkN "ลักษณะการดําเนินการ" | mkN "ลักษณะการเคลื่อนไหว" | mkN "ระดับความมีชีวิตชีวา" | mkN "เรื่องราวที่ดําเนินการ" | mkN "การกระทําอย่างมีชีวิตชีวา" | mkN "การวัดความสามารถในการเกิดปฏิกริยาเคมี" ; -- src=panlex
lin road_N = mkN (thword "ถนน") | {-pan-} mkN "ถ." | mkN "ถนน" | mkN "ทาง" | mkN "วิถี" | mkN "เส้นทาง" | mkN "ถนนรนแคม" | mkN "ถนนหนทาง" | mkN "หน" | mkN "ถนน" | mkN "ทาง" | mkN "วิถี" | mkN "ทางรถไฟ" | mkN "วิถีทาง" | mkN "เส้นทาง" | mkN "ที่ทอดสมอ" | mkN "อุโมงค์เหมือง" ; -- src=panlex
lin table_N = mkN "โต๊ะ" "ตัว" | {-pan-} mkN "โต๊ะ" | mkN "ตาราง" | mkN "อาหาร" | mkN "เนินเมซา" | mkN "เนินยอดราบ" | mkN "ผู้ร่วมโต๊ะ" | mkN "ผู้ร่วมรับประทานอาหาร" | mkN "แผ่น" | mkN "โต๊ะ" | mkN "ตาราง" | mkN "บัญชี" | mkN "บัวเสา" | mkN "รายการ" | mkN "แผ่นหิน" | mkN "แผ่นไม้" | mkN "คําจารึก" | mkN "ที่ราบสูง" | mkN "แผ่นจารึก" | mkN "โต๊ะอาหาร" | mkN "ตารางรายการ" | mkN "ผิวหน้าเรียบ" | mkN "กระดานหมากรุก" | mkN "อาหารที่จัดเตรียมไว้อย่างดีในภัตตาคารหรือราชสํานัก" ; -- src=panlex ----?
lin including_Prep = mkPrep "รวมถึง" | mkPrep "รวมทั้ง" | mkPrep "รวมเข้าด้วย" ; -- src=panlex
lin church_N = placeN "โบสถ์" | {-pan-} mkN "วัด" | mkN "โบสถ์" | mkN "กรรมการวัด" | mkN "ชาวโบสถ์คริสต์" | mkN "โบสถ์" ; -- src=panlex
lin reach_V2 = mkV2 "ถึง" ; ---- | mkV "ส่ง" | mkV "บรรลุ" | mkV "มาถึง" | mkV "ไปถึง" | mkV "ติดต่อ" | mkV "ได้ถึง" | mkV "ไปถึงเป้าหมาย" | mkV "ออกแรงมากเกินไป" | mkV "มาถึง" | mkV "ไปถึง" | mkV "เอื้อม" | mkV "ครอบงํา" | mkV "ยื่นถึง" | mkV "เข้าถึง" | mkV "เอื้อมถึง" | mkV "ติดต่อสื่อสาร" | mkV "บรรลุผลสําเร็จ" | mkV "ประสบความสําเร็จ" | mkV "มีอิทธิพลหรือผลกระทบต่อ" ; -- src=panlex
lin reach_V = mkV "ถึง" | mkV "ส่ง" | mkV "บรรลุ" | mkV "มาถึง" | mkV "ไปถึง" | mkV "ติดต่อ" | mkV "ได้ถึง" | mkV "ไปถึงเป้าหมาย" | mkV "ออกแรงมากเกินไป" | mkV "มาถึง" | mkV "ไปถึง" | mkV "เอื้อม" | mkV "ครอบงํา" | mkV "ยื่นถึง" | mkV "เข้าถึง" | mkV "เอื้อมถึง" | mkV "ติดต่อสื่อสาร" | mkV "บรรลุผลสําเร็จ" | mkV "ประสบความสําเร็จ" | mkV "มีอิทธิพลหรือผลกระทบต่อ" ; -- src=panlex
lin real_A = mkA "จริง" | mkA "ที่แท้จริง" | mkA "ที่เป็นจริง" | mkA "ที่จับต้องได้" | mkA "แท้" | mkA "จริง" | mkA "จริงใจ" | mkA "โดยแท้" | mkA "มีตัวตน" | mkA "แท้จริง" | mkA "ไม่ปลอม" | mkA "ซื่อสัตย์" | mkA "เกี่ยวกับตัวเลขจริง" ; -- src=panlex
lin lie_VS = mmkVS (thword "นอน") ;
lin lie_2_V = variants{} ; -- 
lin lie_1_V = variants{} ; -- 
lin mind_N = mkN "หัว" | mkN "สมอง" | mkN "ปัญญา" | mkN "นักคิด" | mkN "หัวคิด" | mkN "ความคิด" | mkN "ใจ" | mkN "จิต" | mkN "จริต" | mkN "จิตใจ" | mkN "ปัญญา" | mkN "คนฉลาด" | mkN "เหตุผล" | mkN "ความคิด" | mkN "ความจํา" | mkN "ความเห็น" | mkN "สติปัญญา" | mkN "ข้อคิดเห็น" | mkN "ความตั้งใจ" | mkN "ความทรงจํา" | mkN "ความประสงค์" | mkN "ความมุ่งหมาย" | mkN "สติสัมปชัญญะ" | mkN "ความรู้สึกนึกคิด" | mkN "ความสามารถในการเข้าใจ" ; -- src=panlex
lin likely_A = mkA "สมควร" | mkA "มีหวัง" | mkA "เหมาะสม" | mkA "มีแนวโน้ม" | mkA "เป็นไปได้" | mkA "ท่าทางดูดี" | mkA "น่าเชื่อถือ" | mkA "น่าเป็นจริง" | mkA "มีท่าทางว่า" | mkA "น่าจะเป็นไปได้" ; -- src=panlex
lin among_Prep = mkPrep "ในพวก" | mkPrep "ในหมู่" | mkPrep "ระหว่าง" | mkPrep "ท่ามกลาง" | mkPrep "ในจํานวน" | mkPrep "ในจําพวก" | mkPrep "ในระหว่าง" ; -- src=panlex
lin team_N = mkN "ทีม" | mkN "หน่วย" | mkN "กลุ่มสัตว์ชักลาก" | mkN "กอง" | mkN "คณะ" | mkN "หน่วย" | mkN "กลุ่มคน" | mkN "คณะทํางาน" | mkN "ชุดนักกีฬา" | mkN "ขนส่งเป็นกลุ่ม" | mkN "รวมเงินให้เหมาทํา" | mkN "กลุ่มสัตว์ที่ใช้เทียมรถ" | mkN "ใช้สัตว์เลี้ยงเป็นกลุ่มลาก" | mkN "กลุ่มคนทํางานหรือเล่นกีฬาในกลุ่มเดียวกัน" | mkN "สัตว์ตั้งแต่สองตัวขึ้นไปที่ใช้ในการลากยานพาหนะ" ; -- src=panlex
lin experience_N = mkN "ประสบการณ์" | mkN "ประสบประการณ์" | mkN "ประสบการณ์ชีวิต" | mkN "พบ" | mkN "รู้สึก" | mkN "ความชัดเจน" | mkN "ความชํานาญ" | mkN "ประสบการณ์" | mkN "ความเชี่ยวชาญ" | mkN "ความรู้จากประสบการณ์" ; -- src=panlex
lin death_N = mkN "การตาย" | mkN "ความตาย" | mkN "มรณกรรม" | mkN "การสิ้นสุด" | mkN "จุดสุดท้าย" | mkN "การฆ่าให้ตาย" | mkN "วาระสุดท้ายของชีวิต" | mkN "การดับ" | mkN "การตาย" | mkN "การยุติ" | mkN "ความตาย" | mkN "มรณกรรม" | mkN "การจบสิ้น" | mkN "การทําลาย" | mkN "การสาบสูญ" | mkN "การสิ้นใจ" | mkN "การสิ้นสุด" | mkN "ภาวะที่ตาย" | mkN "การถูกทําลาย" | mkN "การสิ้นชีวิต" | mkN "การเสียชีวิต" | mkN "การถึงแก่กรรม" ; -- src=panlex
lin soon_Adv = mkAdv "ในไม่ช้า" | mkAdv "เร็ว" | mkAdv "ทันที" | mkAdv "เร็วๆ นี้" | mkAdv "ไม่นาน" | mkAdv "ฉับพลัน" | mkAdv "รวดเร็ว" | mkAdv "ในไม่ช้า" | mkAdv "โดยเต็มใจ" | mkAdv "มิช้ามินาน" | mkAdv "ก่อนกําเนิด" | mkAdv "พร้อมเพรียง" | mkAdv "ในอนาคตอันใกล้" ; -- src=panlex
lin act_N = mkN "แอ็ก" | mkN "กฎหมาย" | mkN "การแสร้งทำ" | mkN "การกระทำของคน" | mkN "การกระทำของมนุษย์" | mkN "มารยา" | mkN "กฎหมาย" | mkN "ผู้แสดง" | mkN "พฤติกรรม" | mkN "การกระทํา" | mkN "การแสร้งทํา" | mkN "ลักษณะนิสัย" | mkN "การทําหน้าที่" | mkN "เหตุการณ์ในละคร" | mkN "การปฏิบัติหน้าที่" | mkN "บันทึกที่เป็นทางการ" | mkN "สิ่งที่กระทําด้วยความตั้งใจ" ; -- src=panlex
lin sense_N = mkN "เซนส์" | mkN "สามัญสำนึก" | mkN "คอมมอนเซนส์" | mkN "นัย" | mkN "อารมณ์" | mkN "เข้าใจ" | mkN "เหตุผล" | mkN "แนวทาง" | mkN "การเห็น" | mkN "ตระหนัก" | mkN "ไหวพริบ" | mkN "การรับรส" | mkN "ความฉลาด" | mkN "ความหมาย" | mkN "ฟื้นขึ้น" | mkN "การรู้สึก" | mkN "การได้ยิน" | mkN "ความรู้สึก" | mkN "เชาว์ปัญญา" | mkN "การได้กลิ่น" | mkN "ความสังหรณ์" | mkN "ประสาทสัมผัส" | mkN "สติสัมปชัญญะ" | mkN "ประสาททั้งห้า" | mkN "ความหมายของคํา" | mkN "อินทรีย์สัมผัส" | mkN "เข้าใจความหมาย" | mkN "ความสามารถในการพินิจพิเคราะห์" ; -- src=panlex
lin staff_N = variants{} ; -- 
lin staff_2_N = variants{} ; -- 
lin staff_1_N = variants{} ; -- 
lin certain_A = variants{} ; -- 
lin certain_2_A = variants{} ; -- 
lin certain_1_A = variants{} ; -- 
lin studentMasc_N = variants{} ; -- 
lin half_Predet = variants{} ; -- 
lin half_Predet = variants{} ; -- 
lin around_Prep = mkPrep "รอบ" | mkPrep "ราว" | mkPrep "กลับ" | mkPrep "ผ่าน" | mkPrep "รอบๆ" | mkPrep "ราวๆ" | mkPrep "ประมาณ" | mkPrep "วกกลับ" | mkPrep "โดยรอบ" | mkPrep "อ้อมรอบ" | mkPrep "อยู่รอบ ๆ" | mkPrep "อ้อมผ่าน" ; -- src=panlex
lin language_N = mkN (thword "ภา" "ษา") | {-pan-} mkN "ภาษา" | mkN "ภาษาพูด" | mkN "เนื้อร้อง" | mkN "เนื้อเพลง" | mkN "กระบวนการทางภาษา" | mkN "การสื่อสารด้วยภาษา" | mkN "การตั้งชื่อสิ่งมีชีวิต" | mkN "ภาษา" | mkN "พากษ์" | mkN "คําพูด" | mkN "ภาษาพูด" | mkN "วิธีการสื่อสาร" ; -- src=panlex ----?
lin walk_V2 = mkV2 (thword "เดิน") ; ---- | {-pan-} mkV "เดิน" | mkV "พาเดิน" | mkV "เดินเล่น" | mkV "เดินไปส่ง" | mkV "เหยาะย่าง" | mkV "เดินร่วมทาง" | mkV "เดินไปด้วยกัน" | mkV "เดิน" | mkV "ก้าวเดิน" | mkV "ถูกขโมยไป" | mkV "ช่วยให้เดิน" | mkV "พยุงให้เดิน" | mkV "เดินทางด้วยเท้า" | mkV "วัดความยาวด้วยจํานวนก้าว" | mkV "ท่องเที่ยวไปด้วยการเดินเท้า" | mkV "ได้รับการพิจารณาว่าบริสุทธิ์" | mkV "พาสัตว์เลี้ยงไปออกกําลังด้วยการเดิน" | mkV "เคลื่อนย้ายวัตถุขนาดใหญ่ในลักษณะคล้ายการเดิน" ; -- src=panlex
lin walk_V = mkV (thword "เดิน") | {-pan-} mkV "เดิน" | mkV "พาเดิน" | mkV "เดินเล่น" | mkV "เดินไปส่ง" | mkV "เหยาะย่าง" | mkV "เดินร่วมทาง" | mkV "เดินไปด้วยกัน" | mkV "เดิน" | mkV "ก้าวเดิน" | mkV "ถูกขโมยไป" | mkV "ช่วยให้เดิน" | mkV "พยุงให้เดิน" | mkV "เดินทางด้วยเท้า" | mkV "วัดความยาวด้วยจํานวนก้าว" | mkV "ท่องเที่ยวไปด้วยการเดินเท้า" | mkV "ได้รับการพิจารณาว่าบริสุทธิ์" | mkV "พาสัตว์เลี้ยงไปออกกําลังด้วยการเดิน" | mkV "เคลื่อนย้ายวัตถุขนาดใหญ่ในลักษณะคล้ายการเดิน" ; -- src=panlex
lin die_V = mkV (thword "ตาย") | {-pan-} mkV "ซี้" | mkV "ดับ" | mkV "ตาย" | mkV "ล้ม" | mkV "เสีย" | mkV "จากไป" | mkV "ทิวงคต" | mkV "มรณภาพ" | mkV "สวรรคต" | mkV "สิ้นลม" | mkV "สิ้นใจ" | mkV "จบชีวิต" | mkV "สิ้นชีพ" | mkV "หมดเวลา" | mkV "เข้าโลง" | mkV "เสียชีวิต" | mkV "ถึงแก่กรรม" | mkV "สิ้นพระชนม์" | mkV "เสด็จสวรรคต" | mkV "ถึงชีพิตักษัย" | mkV "ถึงแก่พิราลัย" | mkV "ตัดเป็นลูกเต๋า" | mkV "ถึงแก่อนิจกรรม" | mkV "ถึงแก่อสัญกรรม" | mkV "สิ้นชีพิตักษัย" | mkV "ตาย" | mkV "วาย" | mkV "มรณะ" | mkV "หยุด" | mkV "เสีย" | mkV "พินาศ" | mkV "ล่มจม" | mkV "หายนะ" | mkV "อาสัญ" | mkV "ตักษัย" | mkV "บรรลัย" | mkV "ย่อยยับ" | mkV "หมดอายุ" | mkV "อนิจกรรม" | mkV "หยุดทํางาน" | mkV "สิ้นอายุขัย" ; -- src=panlex
lin special_A = mkA "เฉพาะ" | mkA "เจาะจง" ; -- src=panlex
lin difficult_A = mkA "ยาก" | mkA "ยาก" | mkA "ขัดสน" | mkA "ลําบาก" | mkA "ยุ่งยาก" | mkA "ลําเค็ญ" | mkA "ดื้อรั้น" | mkA "ทุกข์ยาก" | mkA "มีอุปสรรค" ; -- src=panlex
lin international_A = mkA "สากล" | mkA "นานาชาติ" | mkA "นานาประเทศ" | mkA "ระดับอินเตอร์" | mkA "ในระดับนานาชาติ" | mkA "สากล" | mkA "นานาชาติ" | mkA "ระหว่างประเทศ" | mkA "เกี่ยวกับประชากรหลายประเทศ" | mkA "เกี่ยวกับความสัมพันธ์ระหว่างประเทศ" ; -- src=panlex
lin particularly_Adv = variants{} ; -- 
lin department_N = mkN "ภาค" | mkN "ฝ่าย" | mkN "แผนก" | mkN "ภาควิชา" | mkN "เขตปกครอง" | mkN "กรม" | mkN "กอง" | mkN "คณะ" | mkN "ภาค" | mkN "เขต" | mkN "ทบวง" | mkN "แผนก" | mkN "กระทรวง" | mkN "จังหวัด" ; -- src=panlex
lin management_N = mkN "การจัดการ" | mkN "การดำเนินการ" | mkN "การควบคุม" | mkN "การจัดการ" | mkN "การบริหาร" | mkN "การปกครอง" | mkN "ผู้จัดการ" | mkN "คณะที่ปรึกษา" | mkN "คณะผู้จัดการ" | mkN "คณะผู้บริหาร" | mkN "ความสามารถในการจัดการ" ; -- src=panlex
lin morning_N = mkN "ตอนเช้า" | mkN "ยามเช้า" | mkN "เช้ามืด" | mkN "รุ่งอรุณ" | mkN "รุ่งเช้า" | mkN "รุ่งแจ้ง" | mkN "เช้าตรู่" | mkN "เวลาเช้า" | mkN "งาย" | mkN "เช้า" | mkN "ตอนเช้า" | mkN "รุ่งเช้า" | mkN "เวลาเช้า" | mkN "ระยะแรกเริ่ม" | mkN "ส่วนเริ่มต้น" ; -- src=panlex
lin draw_V2 = variants{}; -- mkV "เท" | mkV "ขีด" | mkV "ดึง" | mkV "ดูด" | mkV "ตัก" | mkV "ถอน" | mkV "ยืด" | mkV "ลาก" | mkV "วาด" | mkV "ได้" | mkV "กวาด" | mkV "ร้อย" | mkV "เจ๊า" | mkV "เบิก" | mkV "เสมอ" | mkV "ได้ผล" | mkV "ดึงดูด" | mkV "ดูดซับ" | mkV "ดูดซึม" | mkV "พรรณนา" | mkV "จำกัดวง" | mkV "วาดเส้น" | mkV "เลือกสุ่ม" | mkV "ใช้ม้าดึง" | mkV "เป็นแรงส่ง" | mkV "คว้านไส้พุง" | mkV "ปล่อยให้ไหล" | mkV "จำกัดพื้นที่" | mkV "ควักเครื่องใน" | mkV "ต้องการความลึก" | mkV "ชัก" | mkV "ดึง" | mkV "ดูด" | mkV "ถอน" | mkV "ลาก" | mkV "วาดภาพ" | mkV "วาดรูป" | mkV "ได้รับ" | mkV "ถอนเงิน" | mkV "ร่างภาพ" | mkV "ร่างเอกสาร" | mkV "สูดลมเข้าปอด" | mkV "ดึงดูดความสนใจ" | mkV "สูดควันเข้าปอด" ; -- src=panlex
lin draw_1_V2 = variants{} ; -- 
lin draw_2_V2 = variants{} ; -- 
lin draw_V = mkV "เท" | mkV "ขีด" | mkV "ดึง" | mkV "ดูด" | mkV "ตัก" | mkV "ถอน" | mkV "ยืด" | mkV "ลาก" | mkV "วาด" | mkV "ได้" | mkV "กวาด" | mkV "ร้อย" | mkV "เจ๊า" | mkV "เบิก" | mkV "เสมอ" | mkV "ได้ผล" | mkV "ดึงดูด" | mkV "ดูดซับ" | mkV "ดูดซึม" | mkV "พรรณนา" | mkV "จำกัดวง" | mkV "วาดเส้น" | mkV "เลือกสุ่ม" | mkV "ใช้ม้าดึง" | mkV "เป็นแรงส่ง" | mkV "คว้านไส้พุง" | mkV "ปล่อยให้ไหล" | mkV "จำกัดพื้นที่" | mkV "ควักเครื่องใน" | mkV "ต้องการความลึก" | mkV "ชัก" | mkV "ดึง" | mkV "ดูด" | mkV "ถอน" | mkV "ลาก" | mkV "วาดภาพ" | mkV "วาดรูป" | mkV "ได้รับ" | mkV "ถอนเงิน" | mkV "ร่างภาพ" | mkV "ร่างเอกสาร" | mkV "สูดลมเข้าปอด" | mkV "ดึงดูดความสนใจ" | mkV "สูดควันเข้าปอด" ; -- src=panlex
lin hope_VV = mkVV "หวัง" ; ---- | mkV "มีความหวัง" | mkV "คาด" | mkV "หวัง" | mkV "คาดหวัง" | mkV "ปรารถนา" | mkV "มีความหวัง" ; -- src=panlex
lin hope_VS = mkVS (regV "หวัง") ;
lin hope_V = mkV "หวัง" | mkV "มีความหวัง" | mkV "คาด" | mkV "หวัง" | mkV "คาดหวัง" | mkV "ปรารถนา" | mkV "มีความหวัง" ; -- src=panlex
lin across_Prep = mkPrep "ผ่า" | mkPrep "พาด" | mkPrep "ขวาง" | mkPrep "ข้าม" | mkPrep "ทะลุ" | mkPrep "ไขว้" | mkPrep "ก่ายกัน" | mkPrep "ตามขวาง" | mkPrep "ประสานกัน" | mkPrep "สะพายแล่ง" | mkPrep "ข้ามพรมแดน" | mkPrep "ตัดผ่านกัน" | mkPrep "อยู่อีกข้างหนึ่ง" | mkPrep "จากข้างหนึ่งไปยังอีกข้างหนึ่ง" ; -- src=panlex
lin plan_N = mkN "แผน" | mkN "แปลน" | mkN "แผนการ" | mkN "แบบ" | mkN "แผน" | mkN "แผนการ" | mkN "แผนงาน" | mkN "แผนผัง" | mkN "แบบแปลน" | mkN "โครงการ" ; -- src=panlex
lin product_N = mkN "ผล" | mkN "ผลคูณ" | mkN "ผลผลิต" | mkN "สินค้า" | mkN "ผลลัพธ์" | mkN "ผลที่ได้" | mkN "โปรดักต์" | mkN "โปรดักท์" | mkN "ผลที่เกิด" | mkN "ผลิตภัณฑ์" | mkN "ผลคูณคาร์ทีเซียน" | mkN "ผลคูณ" | mkN "ผลิตผล" | mkN "สินค้า" | mkN "ผลิตภัณฑ์" | mkN "ผลของการคูณ" | mkN "ผลที่เกิดขึ้น" | mkN "ของที่ประกอบขึ้น" | mkN "สารที่เกิดจากปฎิกิริยาทางเคมี" | mkN "สารที่ได้จากสารอื่นหลังจากการเปลี่ยนแปลงทางเคมี" ; -- src=panlex
lin city_N = mkN "เมือง" "เมือง" | {-pan-} mkN "เมือง" | mkN "มหานคร" | mkN "เมือง" | mkN "นครรัฐ" | mkN "กรุงนคร" | mkN "หัวเมือง" | mkN "เมืองใหญ่" | mkN "พลเมืองทั้งหมด" ; -- src=panlex
lin early_Adv = mkAdv "แต่แรก" | mkAdv "ก่อนเวลาที่กำหนด" | mkAdv "เป็นช่วงเวลาที่ดี" | mkAdv "แรก" | mkAdv "เช้า" | mkAdv "เร็ว" | mkAdv "ตอนต้น" | mkAdv "ยุคแรก" | mkAdv "แต่ต้น" | mkAdv "แต่แรก" | mkAdv "แต่เช้า" | mkAdv "สมัยก่อน" | mkAdv "แต่กาลก่อน" | mkAdv "แต่หัวค่ํา" | mkAdv "ก่อนเวลาที่กําหนดไว้" ; -- src=panlex
lin committee_N = mkN "คณะกรรมการ" | mkN "ผู้ปกครอง" | mkN "ผู้อนุบาล" | mkN "คณะกรรมการ" ; -- src=panlex
lin ground_N = variants{} ; -- 
lin ground_2_N = variants{} ; -- 
lin ground_1_N = variants{} ; -- 
lin letter_N = variants{} ; -- 
lin letter_2_N = variants{} ; -- 
lin letter_1_N = variants{} ; -- 
lin create_V2 = mkV2 "ทำ" ; ---- | mkV "ผลิต" | mkV "สร้าง" | mkV "ครีเอท" | mkV "รังสรรค์" | mkV "สรรค์สร้าง" | mkV "สร้างสรรค์" | mkV "สร้าง" | mkV "ประดิษฐ์" | mkV "แต่งตั้ง" | mkV "สร้างสรรค์" ; -- src=panlex
lin create_V = mkV "ทำ" | mkV "ผลิต" | mkV "สร้าง" | mkV "ครีเอท" | mkV "รังสรรค์" | mkV "สรรค์สร้าง" | mkV "สร้างสรรค์" | mkV "สร้าง" | mkV "ประดิษฐ์" | mkV "แต่งตั้ง" | mkV "สร้างสรรค์" ; -- src=panlex
lin evidence_N = variants{} ; -- 
lin evidence_2_N = variants{} ; -- 
lin evidence_1_N = variants{} ; -- 
lin foot_N = mkN (thword "เท้า") " ข้าง" | {-pan-} mkN "ฟ." | mkN "ขา" | mkN "ฐาน" | mkN "ตีน" | mkN "บาท" | mkN "ฟุต" | mkN "บาทา" | mkN "เชิง" | mkN "เท้า" | mkN "ฐานราก" | mkN "พระบาท" | mkN "รากฐาน" | mkN "เท้าสัตว์" | mkN "กองทหารราบ" | mkN "พลเดินเท้า" | mkN "การเดินเท้า" | mkN "ฐาน" | mkN "ตีน" | mkN "บาท" | mkN "โคน" | mkN "บาทา" | mkN "เชิง" | mkN "เท้า" | mkN "ฝีเท้า" | mkN "ส่วนล่าง" | mkN "หน่วยความยาวเป็นฟุต" | mkN "หน่วยวัดความยาวเป็นฟุต" | mkN "หน่วยวัดความยาวเท่ากับ 12 นิ้ว" ; -- src=panlex
lin clear_A = mkA "ใส" | mkA "ซึ่งอ่านง่าย" | mkA "ชัด" | mkA "ชัดเจน" | mkA "ที่เข้าใจง่าย" | mkA "ที่รับรู้ได้ดี" | mkA "ที่ไม่มีเมฆหรือหมอก" ; -- src=panlex
lin boy_N = mkN (thword "เด็ก" "ผู้" "ชาย")" คน" | {-pan-} mkN "โอรส" | mkN "ลูกชาย" | mkN "ไอ้หนู" | mkN "กุลบุตร" | mkN "บุตรชาย" | mkN "พระโอรส" | mkN "ราชบุตร" | mkN "ราชโอรส" | mkN "เด็กชาย" | mkN "หนุ่มน้อย" | mkN "เด็กผู้ชาย" | mkN "บ๋อย" | mkN "เด็ก" | mkN "บริกร" | mkN "พ่อหนู" | mkN "น้องชาย" | mkN "เด็กชาย" | mkN "พ่อหนุ่ม" | mkN "เด็กผู้ชาย" | mkN "เด็กฝึกงาน" | mkN "กะลาสีเรือฝึกใหม่" ; -- src=panlex
lin game_N = variants{} ; -- 
lin game_3_N = variants{} ; -- 
lin game_2_N = variants{} ; -- 
lin game_1_N = variants{} ; -- 
lin food_N = mkN "อาหาร" | mkN "ของกิน" | mkN "กระยาหาร" | mkN "ภักษาหาร" | mkN "ภัตตาหาร" | mkN "สารอาหาร" | mkN "อาหารสมอง" | mkN "เครื่องเสวย" | mkN "อาหาร" | mkN "ของกิน" | mkN "อาหารใจ" | mkN "โภชนาการ" | mkN "สิ่งบริโภค" | mkN "อาหารการกิน" ; -- src=panlex
lin role_N = variants{} ; -- 
lin role_2_N = variants{} ; -- 
lin role_1_N = variants{} ; -- 
lin practice_N = mkN "แบบอย่าง" | mkN "การปฏิบัติ" | mkN "การฝึกซ้อม" | mkN "การฝึกปฏิบัติ" | mkN "นิสัย" | mkN "กิจการ" | mkN "ฝึกหัด" | mkN "ภารกิจ" | mkN "กิจวัตร" | mkN "พิธีการ" | mkN "การฝึกฝน" | mkN "ฟ้องร้อง" | mkN "การฝึกหัด" | mkN "การวางแผน" | mkN "การดําเนิน" | mkN "การปฏิบัติ" | mkN "การฝึกซ้อม" | mkN "ประกอบพิธี" | mkN "การฟ้องร้อง" | mkN "วิธีปฏิบัติ" | mkN "ความเป็นจริง" | mkN "ธรรมเนียมปฏิบัติ" | mkN "การกระทําตามหลักศาสนา" ; -- src=panlex
lin bank_N = placeN (thword "ธนา" "คาร") | {-pan-} mkN "ธ." | mkN "ฝั่ง" | mkN "แบงค์" | mkN "ธนาคาร" | mkN "ความลาด" | mkN "คลังสำรอง" | mkN "ตึกธนาคาร" | mkN "การลาดเอียง" | mkN "กล่องใส่เงิน" | mkN "สถาบันการเงิน" | mkN "เงินบ่อนคาสิโน" | mkN "เงินบ่อนการพนัน" | mkN "ของที่วางเป็นแถวเดียวกัน" | mkN "แถว" | mkN "แนว" | mkN "ฝั่ง" | mkN "ตลิ่ง" | mkN "เทือก" | mkN "แบงค์" | mkN "ทิวยาว" | mkN "ธนาคาร" | mkN "มูลดิน" | mkN "เขื่อน" | mkN "ชายฝั่ง" | mkN "เงินพนัน" | mkN "ที่ลาดชัน" | mkN "เอียงข้าง" | mkN "การลาดเอียง" | mkN "ที่ตื้นเขิน" | mkN "ฝากเงินธนาคาร" | mkN "ที่เก็บข้อมูล อาหารหรือเลือดเพื่อใช้ตอนฉุกเฉิน" | mkN "สิ่งที่สํารองเอาไว้" | mkN "เงินที่ได้จากการเล่นการพนัน" ; -- src=panlex
lin else_Adv = mkAdv "อื่น" | mkAdv "อื่นๆ" | mkAdv "อื่นอีก" | mkAdv "มิฉะนั้น" | mkAdv "อื่นๆอีก" | mkAdv "อย่างอื่น" | mkAdv "อย่างแตกต่าง" ; -- src=panlex
lin support_N = mkN "เงินทุน" | mkN "ตัวค้ำจุน" | mkN "พยานเอกสาร" | mkN "สิ่งค้ำจุน" | mkN "การสนับสนุน" | mkN "การรับน้ำหนัก" | mkN "ที่รับน้ำหนัก" | mkN "เอกสารหลักฐาน" | mkN "กองทุนสนับสนุน" | mkN "ที่รองรับน้ำหนัก" | mkN "อุปกรณ์รับน้ำหนัก" | mkN "อุปกรณ์รองรับน้ำหนัก" | mkN "สิ่งค้ํา" | mkN "การสนับสนุน" | mkN "การช่วยเหลือ" | mkN "การสงเคราะห์" | mkN "การอนุเคราะห์" | mkN "สิ่งที่หนุนอยู่" ; -- src=panlex
lin sell_V2 = mkV2 "ขาย" ; ---- | mkV "ทรยศ" | mkV "ค้าขาย" | mkV "จำหน่าย" | mkV "หักหลัง" | mkV "ทำธุรกิจ" | mkV "ขาย" | mkV "ค้า" | mkV "เสนอขาย" | mkV "จําหน่าย" | mkV "ประกาศขาย" | mkV "แลกกับเงิน" | mkV "ชวนให้เลือก" | mkV "โฆษณาให้ซื้อ" | mkV "ชักชวนให้ซื้อ" | mkV "เป็นที่ต้องการ" | mkV "ขายได้ปริมาณมาก" | mkV "ยอมทําเพื่อเงิน" ; -- src=panlex
lin sell_V = mkV "ขาย" | mkV "ทรยศ" | mkV "ค้าขาย" | mkV "จำหน่าย" | mkV "หักหลัง" | mkV "ทำธุรกิจ" | mkV "ขาย" | mkV "ค้า" | mkV "เสนอขาย" | mkV "จําหน่าย" | mkV "ประกาศขาย" | mkV "แลกกับเงิน" | mkV "ชวนให้เลือก" | mkV "โฆษณาให้ซื้อ" | mkV "ชักชวนให้ซื้อ" | mkV "เป็นที่ต้องการ" | mkV "ขายได้ปริมาณมาก" | mkV "ยอมทําเพื่อเงิน" ; -- src=panlex
lin event_N = mkN "เรื่อง" | mkN "เหตุการณ์" | mkN "ผลที่ตามมา" | mkN "ผล" | mkN "กรณี" | mkN "ผลที่ได้" | mkN "เหตุการณ์" | mkN "ผลที่ตามมา" | mkN "ผลที่เกิดขึ้น" | mkN "การแข่งขันกีฬา" | mkN "เหตุการณ์สําคัญ" ; -- src=panlex
lin building_N = mkN "ตึก" | mkN "อาคาร" | mkN "การสร้าง" | mkN "การก่อสร้าง" | mkN "สิ่งปลูกสร้าง" | mkN "ธุรกิจรับเหมาก่อสร้าง" | mkN "กลุ่มผู้อยู่อาศัยในอาคาร" | mkN "กลุ่มผู้อยู่อาศัยในตึกที่พัก" | mkN "ตึก" | mkN "โรง" | mkN "อาคาร" | mkN "เรือน" | mkN "สํานักงาน" | mkN "การก่อสร้าง" | mkN "สิ่งก่อสร้าง" | mkN "สิ่งปลูกสร้าง" | mkN "ธุรกิจก่อสร้าง" | mkN "การก่อสร้างอาคาร" ; -- src=panlex
lin range_N = mkN "เตา" | mkN "เทือก" | mkN "ขอบเขต" | mkN "เทือกเขา" | mkN "เตาหุงต้ม" | mkN "เตาประกอบอาหาร" | mkN "แถว" | mkN "ทิวเขา" | mkN "ลําดับ" | mkN "แนวเขา" | mkN "วิถียิง" | mkN "เทือกเขา" | mkN "วิถีกระสุน" | mkN "สถานฝึกยิง" | mkN "ขอบเขตหรือแนว" | mkN "สถานที่ฝึกซ้อม" | mkN "ทุ่งเลี้ยงสัตว์" | mkN "เตาหุงต้มชนิดหนึ่ง" | mkN "ระยะทางจากอาวุธถึงเป้า" | mkN "บริเวณกว้างใหญ่สําหรับเลี้ยงสัตว์" | mkN "ค่าแตกต่างระหว่างตัวแปรที่น้อยที่สุดกับมากที่สุด" ; -- src=panlex
lin behind_Prep = ss "หลัง" | {-pan-} mkPrep "ก้น" | mkPrep "แฝง" | mkPrep "หลัง" | mkPrep "ช้ากว่า" | mkPrep "ตามหลัง" | mkPrep "ข้างหลัง" | mkPrep "สนับสนุน" | mkPrep "ไม่เปิดเผย" | mkPrep "ล้าหลังกว่า" | mkPrep "อยู่เบื้องหลัง" | mkPrep "ซ่อนเร้นอยู่ภายใน" ; -- src=panlex
lin sure_A = mkA "มั่นใจ" | mkA "แน่นอน" | mkA "แน่ๆ" | mkA "แน่ใจ" | mkA "มั่นคง" | mkA "มั่นใจ" | mkA "ยืนยัน" | mkA "แน่นอน" | mkA "" | mkA "ปลอดภัย" | mkA "วางใจได้" | mkA "ไว้ใจได้" | mkA "เชื่อมั่น" | mkA "เชื่อใจได้" | mkA "ไม่มีปัญหา" | mkA "ไม่ต้องสงสัย" | mkA "ไม่เปลี่ยนแปลง" ; -- src=panlex
lin report_VS = mmkVS "แจ้ง" ; ---- | mkV "รายงาน" | mkV "อธิบาย" | mkV "เสนอ" | mkV "บันทึก" | mkV "ประกาศ" | mkV "รายงาน" | mkV "ทําบันทึก" | mkV "รายงานตัว" ; -- src=panlex
lin report_V2 = mkV2 "แจ้ง" ; ---- | mkV "รายงาน" | mkV "อธิบาย" | mkV "เสนอ" | mkV "บันทึก" | mkV "ประกาศ" | mkV "รายงาน" | mkV "ทําบันทึก" | mkV "รายงานตัว" ; -- src=panlex
lin report_V = mkV "แจ้ง" | mkV "รายงาน" | mkV "อธิบาย" | mkV "เสนอ" | mkV "บันทึก" | mkV "ประกาศ" | mkV "รายงาน" | mkV "ทําบันทึก" | mkV "รายงานตัว" ; -- src=panlex
lin pass_V = mkV "ขับ" | mkV "ซี้" | mkV "ดับ" | mkV "ตาย" | mkV "ล้ม" | mkV "ส่ง" | mkV "แซง" | mkV "โอน" | mkV "กวาด" | mkV "ผ่าน" | mkV "จากไป" | mkV "ไปไกล" | mkV "ดำดิ่ง" | mkV "ดีกว่า" | mkV "ทิวงคต" | mkV "ผ่านไป" | mkV "มรณภาพ" | mkV "สวนทาง" | mkV "สวรรคต" | mkV "สิ้นลม" | mkV "สิ้นใจ" | mkV "ส่งบอล" | mkV "อนุญาต" | mkV "ขับถ่าย" | mkV "จบชีวิต" | mkV "ตกตะลึง" | mkV "ผ่านบอล" | mkV "ล่วงเลย" | mkV "สอบผ่าน" | mkV "สิ้นชีพ" | mkV "เข้าโลง" | mkV "ใช้เวลา" | mkV "ให้ผ่าน" | mkV "เกิดขึ้น" | mkV "ให้อำนาจ" | mkV "หลุดออกมา" | mkV "เสียชีวิต" | mkV "เหนือกว่า" | mkV "ขับของเสีย" | mkV "ค่อยๆทุเลา" | mkV "ตกเป็นมรดก" | mkV "ถึงแก่กรรม" | mkV "ผ่านกฎหมาย" | mkV "สิ้นพระชนม์" | mkV "เป็นมรดกถึง" | mkV "เสด็จสวรรคต" | mkV "ทำให้สิ้นสุด" | mkV "ถึงชีพิตักษัย" | mkV "ถึงแก่พิราลัย" | mkV "ถึงแก่อนิจกรรม" | mkV "ถึงแก่อสัญกรรม" | mkV "ผ่านการเห็นชอบ" | mkV "สิ้นชีพิตักษัย" | mkV "ตาย" | mkV "พูด" | mkV "ยติ" | mkV "แซง" | mkV "ผ่าน" | mkV "ยุติ" | mkV "กล่าว" | mkV "พูดจา" | mkV "พ้นไป" | mkV "หนทาง" | mkV "จบสิ้น" | mkV "ตัดสิน" | mkV "นําส่ง" | mkV "บอกต่อ" | mkV "ผ่านไป" | mkV "ยอมรับ" | mkV "ส่งให้" | mkV "อธิบาย" | mkV "อนุญาต" | mkV "ถ่ายทอด" | mkV "พิพากษา" | mkV "ยื่นให้" | mkV "สอบผ่าน" | mkV "สิ้นสุด" | mkV "ส่งผ่าน" | mkV "หมดเวลา" | mkV "อนุมัติ" | mkV "ใช้เวลา" | mkV "กลายเป็น" | mkV "ส่งต่อไป" | mkV "ออกเสียง" | mkV "เดินผ่าน" | mkV "บัตรผ่าน การส่งลูก" | mkV "ท่าส่งลูก" | mkV "สอบไล่ได้" | mkV "สิทธิผ่าน" | mkV "สิ้นชีวิต" | mkV "เสียชีวิต" | mkV "การบินผ่าน" | mkV "การสอบผ่าน" | mkV "การเปลี่ยน" | mkV "ถึงแก่กรรม" | mkV "เปลี่ยนจาก" | mkV "เปลี่ยนเป็น" | mkV "การล่วงของเวลา" | mkV "เปลี่ยนแปลงจาก" ; -- src=panlex
lin black_A = mkA (thword "ดำ") | {-pan-} mkA "สีดำ" | mkA "ผิวดำ" | mkA "ซึ่งมืดมน" | mkA "ดำ" | mkA "ดํา" | mkA "มืด" | mkA "มืดมน" | mkA "สีดํา" | mkA "ผิวดํา" | mkA "มืดมัว" | mkA "ชั่วร้าย" | mkA "สิ้นหวัง" | mkA "ไม่สว่าง" | mkA "ไร้ความหวัง" ; -- src=panlex
lin stage_N = mkN "เฟส" | mkN "ขั้น" | mkN "ระยะ" | mkN "เวที" | mkN "เลเวล" | mkN "แท่นวางวัตถุ" | mkN "รถม้าโดยสารขนาดใหญ่" | mkN "ฉาก" | mkN "ตอน" | mkN "ขั้น" | mkN "ชั้น" | mkN "ช่วง" | mkN "ระยะ" | mkN "ร้าน" | mkN "สมัย" | mkN "เวที" | mkN "แท่น" | mkN "โป๊ะ" | mkN "ฉากละคร" | mkN "ระยะเวลา" | mkN "เวทีละคร" | mkN "ศิลปะละคร" | mkN "รถม้าโดยสาร" | mkN "ท่าเรือพื้นราบ" | mkN "ระยะการเจริญเติบโต" ; -- src=panlex
lin meeting_N = mkN "มิตติ้ง" | mkN "การประชุม" | mkN "จุดที่บรรจบกัน" | mkN "การพบปะสังสรรค์" | mkN "การพบปะโดยบังเอิญ" | mkN "การพบกัน" | mkN "การชุมนุม" | mkN "การประชุม" | mkN "การเจอกัน" | mkN "การรวมกลุ่ม" | mkN "สถานที่ชุมนุม" | mkN "กลุ่มคนที่ชุมนุมกัน" ; -- src=panlex
lin meeting_N = mkN "มิตติ้ง" | mkN "การประชุม" | mkN "จุดที่บรรจบกัน" | mkN "การพบปะสังสรรค์" | mkN "การพบปะโดยบังเอิญ" | mkN "การพบกัน" | mkN "การชุมนุม" | mkN "การประชุม" | mkN "การเจอกัน" | mkN "การรวมกลุ่ม" | mkN "สถานที่ชุมนุม" | mkN "กลุ่มคนที่ชุมนุมกัน" ; -- src=panlex
lin sometimes_Adv = mkAdv "บางท’" | mkAdv "บางที" | mkAdv "บางคราว" | mkAdv "บางครั้ง" | mkAdv "บางโอกาส" | mkAdv "บางครั้งบางคราว" ; -- src=panlex
lin thus_Adv = mkAdv "ดังนั้น" | mkAdv "ดังนี้" | mkAdv "ดังนั้น" | mkAdv "ดังเช่น" | mkAdv "เช่นนี้" | mkAdv "ด้วยเหตุนี้" ; -- src=panlex
lin accept_VS = mmkVS "รับ" ; ---- | mkV "ตอบรับ" | mkV "ยอมรับ" | mkV "เปิดรับ" | mkV "กล้ำกลืน" | mkV "ทำให้ติด" | mkV "มีหนี้สิน" | mkV "กล้ำกลืนฝืนทน" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "ออกแบบให้รับได้" | mkV "รับ" | mkV "ยอมทน" | mkV "เชื่อ" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "รับเอา" | mkV "ต้อนรับ" | mkV "รับช่วง" | mkV "รับภาระ" | mkV "รับเอามา" | mkV "เห็นด้วย" | mkV "รับผิดชอบ" | mkV "รับคําเชิญ" | mkV "เห็นด้วยกับ" | mkV "ยอมรับว่าจริง" | mkV "ยอมรับการตําหนิ" | mkV "ยอมรับเข้ากลุ่ม" | mkV "ทําให้ผ่านกระบวนการ" ; -- src=panlex
lin accept_V2 = mkV2 "รับ" ; ---- | mkV "ตอบรับ" | mkV "ยอมรับ" | mkV "เปิดรับ" | mkV "กล้ำกลืน" | mkV "ทำให้ติด" | mkV "มีหนี้สิน" | mkV "กล้ำกลืนฝืนทน" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "ออกแบบให้รับได้" | mkV "รับ" | mkV "ยอมทน" | mkV "เชื่อ" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "รับเอา" | mkV "ต้อนรับ" | mkV "รับช่วง" | mkV "รับภาระ" | mkV "รับเอามา" | mkV "เห็นด้วย" | mkV "รับผิดชอบ" | mkV "รับคําเชิญ" | mkV "เห็นด้วยกับ" | mkV "ยอมรับว่าจริง" | mkV "ยอมรับการตําหนิ" | mkV "ยอมรับเข้ากลุ่ม" | mkV "ทําให้ผ่านกระบวนการ" ; -- src=panlex
lin accept_V = mkV "รับ" | mkV "ตอบรับ" | mkV "ยอมรับ" | mkV "เปิดรับ" | mkV "กล้ำกลืน" | mkV "ทำให้ติด" | mkV "มีหนี้สิน" | mkV "กล้ำกลืนฝืนทน" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "ออกแบบให้รับได้" | mkV "รับ" | mkV "ยอมทน" | mkV "เชื่อ" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "รับเอา" | mkV "ต้อนรับ" | mkV "รับช่วง" | mkV "รับภาระ" | mkV "รับเอามา" | mkV "เห็นด้วย" | mkV "รับผิดชอบ" | mkV "รับคําเชิญ" | mkV "เห็นด้วยกับ" | mkV "ยอมรับว่าจริง" | mkV "ยอมรับการตําหนิ" | mkV "ยอมรับเข้ากลุ่ม" | mkV "ทําให้ผ่านกระบวนการ" ; -- src=panlex
lin town_N = mkN "เมือง" | mkN "นคร" | mkN "บุรี" | mkN "เมือง" | mkN "ประชาชน" | mkN "ชาวเมือง" | mkN "เขตชุมชน" | mkN "เขตเมือง" | mkN "เทศบาลเมือง" | mkN "ไปหาความสําราญ)" | mkN "ประชาชนทั้งเมือง" | mkN "เขตศูนย์การค้าของเมือง" ; -- src=panlex
lin art_N = mkN (thword "ศิล" "ปะ") | {-pan-} mkN "ศิลปะ" | mkN "งานศิลปะ" | mkN "งานศิลป์" | mkN "ภาพประกอบ" | mkN "ไฟน์อาร์ท" | mkN "ผลงานศิลปะ" | mkN "การสร้างงานศิลปะ" | mkN "ศิลป" | mkN "ทักษะ" | mkN "ศิลป์" | mkN "งานศิลปะ" | mkN "งานศิลป์" | mkN "ศิลปกรรม" | mkN "ความสามารถ" | mkN "ทักษะทางศิลปะ" | mkN "ผลงานทางศิลปะ" ; -- src=panlex
lin further_Adv = mkAdv "ไกลออกไป" | mkAdv "กว้างขวางออกไป" | mkAdv "ต่อไป" | mkAdv "ผลักดัน" | mkAdv "มากขึ้น" | mkAdv "ก้าวหน้า" | mkAdv "นานออกไป" | mkAdv "ส่งเสริม" | mkAdv "ไกลออกไป" | mkAdv "เพิ่มขึ้น" | mkAdv "เพิ่มเติม" | mkAdv "ขยายออกไปอีก" ; -- src=panlex
lin club_N = variants{} ; -- 
lin club_2_N = variants{} ; -- 
lin club_1_N = variants{} ; -- 
lin cause_V2V = variants{} ; -- 
lin cause_V2 = variants{} ; -- 
lin arm_N = variants{} ; -- 
lin arm_1_N = variants{} ; -- 
lin arm_2_N = variants{} ; -- 
lin history_N = mkN "ประวัติศาสตร์" | mkN "ยุคสมัยประวัติศาสตร์" | mkN "พงศาวดาร" | mkN "ความเป็นมา" | mkN "ประวัติศาสตร์" ; -- src=panlex
lin parent_N = mkN "พ่อแม่" | mkN "บุพการี" | mkN "บิดรมารดา" | mkN "บิดามารดา" | mkN "ผู้ปกครอง" | mkN "ผู้บังเกิดเกล้า" | mkN "แหล่ง" | mkN "พ่อแม่" | mkN "ผู้ดูแล" | mkN "บรรพบุรุษ" | mkN "ผู้ปกครอง" | mkN "พ่อหรือแม่" ; -- src=panlex
lin land_N = mkN "ปท." | mkN "ดิน" | mkN "ที่" | mkN "รัฐ" | mkN "ชาติ" | mkN "พื้น" | mkN "ดินแดน" | mkN "ที่ดิน" | mkN "ประเทศ" | mkN "ผืนดิน" | mkN "พลเมือง" | mkN "พื้นดิน" | mkN "รัฐชาติ" | mkN "อาณาเขต" | mkN "แผ่นดิน" | mkN "คนในชาติ" | mkN "เกษตรกรรม" | mkN "คนในประเทศ" | mkN "ประเทศชาติ" | mkN "ประชาชนพลเมือง" | mkN "ประชาชนในประเทศ" | mkN "อสังหาริมทรัพย์" | mkN "บก" | mkN "เขต" | mkN "ดินแดน" | mkN "ที่ดิน" | mkN "ผืนดิน" | mkN "พื้นดิน" | mkN "แผ่นดิน" | mkN "อาณาจักร" | mkN "อาณาบริเวณ" | mkN "พื้นที่ชนบท" | mkN "ขอบเขตปกครอง" | mkN "อสังหาริมทรัพย์" | mkN "พื้นที่ที่มีขอบเขต" | mkN "พื้นที่ทําการเกษตร" | mkN "พื้นที่ทํานาหรือไร่" ; -- src=panlex
lin trade_N = mkN "ช่าง" | mkN "งานฝีมือ" | mkN "ลมสินค้า" | mkN "การค้าขาย" | mkN "การแลกเปลี่ยนสินค้า" | mkN "ช่าง" | mkN "อาชีพ" | mkN "การขาย" | mkN "การค้า" | mkN "ลมตะเภา" | mkN "ลมมรสุม" | mkN "การค้าขาย" | mkN "ช่างฝีมือ" | mkN "แลกเปลี่ยน" | mkN "การแลกเปลี่ยน" | mkN "สิ่งแลกเปลี่ยน" | mkN "แลกเปลี่ยนสินค้า" ; -- src=panlex
lin watch_VS = mmkVS "ชม" ; ---- | mkV "ดู" | mkV "เฝ้าดู" | mkV "ค้นคว้า" | mkV "จับตาดู" | mkV "ดู" | mkV "คอยดู" | mkV "เฝ้าดู" ; -- src=panlex
lin watch_V2V = mmkV2V "ชม" ; ---- | mkV "ดู" | mkV "เฝ้าดู" | mkV "ค้นคว้า" | mkV "จับตาดู" | mkV "ดู" | mkV "คอยดู" | mkV "เฝ้าดู" ; -- src=panlex
lin watch_V2 = mkV2 "ดู" ;
lin watch_1_V2 = variants{} ; -- 
lin watch_2_V2 = variants{} ; -- 
lin watch_V = mkV "ชม" | mkV "ดู" | mkV "เฝ้าดู" | mkV "ค้นคว้า" | mkV "จับตาดู" | mkV "ดู" | mkV "คอยดู" | mkV "เฝ้าดู" ; -- src=panlex
lin white_A = mkA (thword "ขาว") | {-pan-} mkA "ว่าง" | mkA "สีขาว" | mkA "เปล่า" | mkA "ผิวขาว" | mkA "ขาว" | mkA "จาง" | mkA "ซีด" | mkA "หงอก" | mkA "ีขาว" | mkA "สะอาด" | mkA "โชคดี" | mkA "ไร้สี" | mkA "ผิวขาว" | mkA "มีหิมะ" | mkA "สีเงิน" | mkA "ขาวหิมะ" | mkA "ซื่อตรง" | mkA "สีเผือก" | mkA "โปร่งใส" | mkA "ยุติธรรม" | mkA "มีเจตนาดี" | mkA "ว่างเปล่า" | mkA "ไร้เดียงสา" | mkA "สวมเสื้อขาว" | mkA "ขาวบริสุทธิ์" | mkA "เกือบไม่มีสี" | mkA "ไม่ได้เขียนอะไร" ; -- src=panlex
lin situation_N = mkN "ตำแหน่ง" | mkN "หน้าที่" | mkN "สถานการณ์" | mkN "สภาพการณ์" | mkN "ตำแหน่งหน้าที่" | mkN "สภาพ" | mkN "สถานภาพ" | mkN "สถานการณ์" | mkN "สถานที่ตั้ง" | mkN "ตําแหน่งที่ตั้ง" | mkN "เหตุการณ์น่าทึ่ง" ; -- src=panlex
lin ago_Adv = mkAdv "มาแล้ว" | mkAdv "ในอดีต" | mkAdv "แต่ก่อน" | mkAdv "เมื่อก่อน" | mkAdv "ที่ผ่านมาแล้ว" ; -- src=panlex
lin teacherMasc_N = variants{} ; -- 
lin record_N = variants{} ; -- 
lin record_3_N = variants{} ; -- 
lin record_2_N = variants{} ; -- 
lin record_1_N = variants{} ; -- 
lin manager_N = mkN "ผจก." | mkN "โค้ช" | mkN "กุนซือ" | mkN "ผู้จัดการ" | mkN "ผู้จัดการทีม" | mkN "กรรมการผู้จัดการ" | mkN "ผู้ควบคุม" | mkN "ผู้จัดการ" | mkN "ผู้บริหาร" ; -- src=panlex
lin relation_N = mkN "ญาติ" | mkN "กามกิจ" | mkN "พี่น้อง" | mkN "รีเลชัน" | mkN "เครือญาติ" | mkN "การบอกเล่า" | mkN "การร่วมเพศ" | mkN "การเสพเมถุน" | mkN "ญาติพี่น้อง" | mkN "วงศาคณาญาติ" | mkN "การเสพสังวาส" | mkN "ความสัมพันธ์" | mkN "ญาติโกโหติกา" | mkN "การร่วมประเวณี" | mkN "การมีเพศสัมพันธ์" | mkN "ญาติ" | mkN "การเล่า" | mkN "การบรรยาย" | mkN "เครือญาติ" | mkN "เรื่องราว" | mkN "ญาติพี่น้อง" | mkN "ความสัมพันธ์" | mkN "การเล่าเรื่อง" | mkN "ความเกี่ยวดองกัน" | mkN "ความเกี่ยวข้องกัน" ; -- src=panlex
lin common_A = variants{} ; -- 
lin common_2_A = variants{} ; -- 
lin common_1_A = variants{} ; -- 
lin strong_A = mkA "แรง" | mkA "แข็งแรง" | mkA "ซึ่งแข็งแรง" | mkA "ที่มีศักยภาพ" | mkA "จัด" | mkA "ทนทาน" | mkA "ชัดเจน" | mkA "มั่นคง" | mkA "มีพลัง" | mkA "รุนแรง" | mkA "สุดขีด" | mkA "กล้าหาญ" | mkA "ช่ําชอง" | mkA "ดุเดือด" | mkA "ร่ํารวย" | mkA "เข้มข้น" | mkA "เต็มที่" | mkA "แข็งแรง" | mkA "แน่นหนา" | mkA "โดดเด่น" | mkA "์ชํานาญ" | mkA "ก้าวหน้า" | mkA "น่าเชื่อ" | mkA "มีกําลัง" | mkA "มีอํานาจ" | mkA "หนักแน่น" | mkA "เข้มแข็ง" | mkA "เฟื่องฟู" | mkA "มีอิทธิพล" | mkA "เชี่ยวชาญ" | mkA "เน้นเสียง" | mkA "แข็งแกร่ง" | mkA "ฉุนหรือแรง" | mkA "เด็ดเดี่ยว" | mkA "น่าเชื่อถือ" | mkA "อยู่ยงคงกระพัน" | mkA "ไม่เปลี่ยนแปลง" | mkA "เป็นที่โน้มน้าว" ; -- src=panlex
lin whole_A = mkA "ทั้ง" | mkA "เต็ม" | mkA "ล้วน ๆ" | mkA "ครบถ้วน" | mkA "ทั้งหมด" | mkA "สมบูรณ์" | mkA "ทั้งสิ้น" | mkA "พร้อมมูล" | mkA "ไม่เจือปน" | mkA "ไม่บุบสลาย" | mkA "ไม่มีการแบ่งแยก" ; -- src=panlex
lin field_N = variants{} ; -- 
lin field_4_N = variants{} ; -- 
lin field_3_N = variants{} ; -- 
lin field_2_N = variants{} ; -- 
lin field_1_N = variants{} ; -- 
lin free_A = mkA "อิสระ" | mkA "แจกฟรี" | mkA "โดยเสรี" | mkA "ให้เปล่า" | mkA "ไม่คิดมูลค่า" | mkA "ซึ่งเป็นอิสระ" | mkA "ไม่มีข้อจํากัด" ; -- src=panlex
lin break_V2 = mkV2 "แตกหัก" ;
lin break_V = mkV "งัด" | mkV "พัก" | mkV "หัก" | mkV "แตก" | mkV "ถล่ม" | mkV "ทรุด" | mkV "ทลาย" | mkV "ยุติ" | mkV "เลิก" | mkV "เสีย" | mkV "ทำลาย" | mkV "ทุเลา" | mkV "ผิดกฎ" | mkV "กระจาย" | mkV "ฝ่าฝืน" | mkV "ยุบตัว" | mkV "ระเบิด" | mkV "ลดขั้น" | mkV "ละเมิด" | mkV "แตกหัก" | mkV "แยกทาง" | mkV "แหกคุก" | mkV "ดิ่งเหว" | mkV "พังทลาย" | mkV "หล่นวูบ" | mkV "เปิดเผย" | mkV "แตกร้าว" | mkV "ทำให้แตก" | mkV "เกิดขึ้น" | mkV "เสียงแตก" | mkV "แหกตาราง" | mkV "ขัดจังหวะ" | mkV "ลดผลกระทบ" | mkV "เลิกนิสัย" | mkV "แหกกรงขัง" | mkV "ทำให้แตกออก" | mkV "ทำให้แยกออก" | mkV "ทำให้สิ้นสุด" | mkV "ทำให้ล้มละลาย" | mkV "ทำให้เชื่อฟัง" | mkV "เต้นเบรคแดนซ์" | mkV "แตกเป็นเสี่ยง" | mkV "ทำให้กระดูกหัก" | mkV "ทำได้ยอดเยี่ยม" | mkV "ย่างกรายเข้ามา" | mkV "ดิ่งลงอย่างหนัก" | mkV "ทำให้ไม่สมบูรณ์" | mkV "ทำให้ใช้การไม่ได้" | mkV "อ่อนแอทั้งกายและใจ" | mkV "ทุบ" | mkV "ฝ่า" | mkV "หัก" | mkV "แตก" | mkV "แยก" | mkV "แหก" | mkV "หยุด" | mkV "แหวก" | mkV "ล่มจม" | mkV "ขัดขืน" | mkV "ทําลาย" | mkV "ฝ่าฝืน" | mkV "ละเมิด" | mkV "แตกหัก" | mkV "ล้มละลาย" | mkV "เกิดขึ้น" | mkV "ล่วงละเมิด" | mkV "กระจัดกระจาย" ; -- src=panlex
lin yesterday_Adv = mkAdv "เมื่อวาน" | mkAdv "วานนี้" | mkAdv "ระยะนี้" | mkAdv "หมู่นี้" | mkAdv "เมื่อวาน" | mkAdv "เมื่อวานนี้" ; -- src=panlex
lin support_V2 = variants{} ; -- 
lin window_N = mkN (thword "หน้า" "ต่าง" "บาน") | {-pan-} mkN "ช่อง" | mkN "วินโดว์" | mkN "พระบัญชร" | mkN "หน้าต่าง" | mkN "ช่องหน้าต่าง" | mkN "กระจกหน้าต่าง" | mkN "หน้าต่าง" | mkN "หน้าต่างกระจกด้านหน้าของร้านสําหรับโชว์สินค้า" ; -- src=panlex ----?
lin account_N = mkN "บิล" | mkN "ใบเสร็จ" | mkN "คำอธิบาย" | mkN "การรายงาน" | mkN "ความสำคัญ" | mkN "ผลประโยชน์" | mkN "รายงานข่าว" | mkN "ใบแจ้งหนี้" | mkN "ใบเสร็จรับเงิน" | mkN "รายการบัญชีงบดุล" | mkN "ความสัมพันธ์ทางธุรกิจ" | mkN "ใบแจ้งราคาสินค้าที่ขายให้" | mkN "บัญชี" | mkN "บันทึก" | mkN "รายงาน" | mkN "ประวัติ" | mkN "การคํานวณ" | mkN "การบรรยาย" | mkN "การอธิบาย" | mkN "เรื่องราว" | mkN "บัญชีธนาคาร" | mkN "รายการบัญชี" | mkN "บัญชีรายรับ-รายจ่าย" | mkN "บัญชีเงินฝาก" ; -- src=panlex
lin explain_VS = variants{} ; -- 
lin explain_V2 = variants{} ; -- 
lin stay_VA = mmkVA "พัก" ; ---- | mkV "ยุติ" | mkV "อยู่" | mkV "พำนัก" | mkV "ยังคง" | mkV "ระงับ" | mkV "ยกเลิก" | mkV "แล่นฝ่า" | mkV "หลงเหลือ" | mkV "พักอยู่" | mkV "ยังอยู่" | mkV "ค้างอยู่" | mkV "อาศัยอยู่" ; -- src=panlex
lin stay_V = mkV "พัก" | mkV "ยุติ" | mkV "อยู่" | mkV "พำนัก" | mkV "ยังคง" | mkV "ระงับ" | mkV "ยกเลิก" | mkV "แล่นฝ่า" | mkV "หลงเหลือ" | mkV "พักอยู่" | mkV "ยังอยู่" | mkV "ค้างอยู่" | mkV "อาศัยอยู่" ; -- src=panlex
lin few_Det = quantDet (thword "สอง" "สาม") ; ---- | {-pan-} mkDet "สองสาม" ; -- src=panlex
lin wait_VV = mkVV "รอ" ; ---- | mkV "คอย" | mkV "รอคอย" | mkV "ทำงานเป็นบริกร" | mkV "เป็นเด็กเสิร์ฟ" | mkV "เป็นพนักงานเสิร์ฟ" | mkV "รอคอย" | mkV "รั้งรอ" | mkV "ถูกเลื่อนออกไป" | mkV "ทํางานเป็นบริกร" | mkV "หยุดหรือทําช้าๆ เพื่อให้ผู้อื่นตามทัน" | mkV "ทํางานเสิร์ฟอาหาร" | mkV "พร้อมที่จะใช้การได้" ; -- src=panlex
lin wait_V2 = mkV2 "รอ" ;
lin wait_V = mkV "รอ" | mkV "คอย" | mkV "รอคอย" | mkV "ทำงานเป็นบริกร" | mkV "เป็นเด็กเสิร์ฟ" | mkV "เป็นพนักงานเสิร์ฟ" | mkV "รอคอย" | mkV "รั้งรอ" | mkV "ถูกเลื่อนออกไป" | mkV "ทํางานเป็นบริกร" | mkV "หยุดหรือทําช้าๆ เพื่อให้ผู้อื่นตามทัน" | mkV "ทํางานเสิร์ฟอาหาร" | mkV "พร้อมที่จะใช้การได้" ; -- src=panlex
lin usually_Adv = variants{} ; -- 
lin difference_N = mkN "การแปร" | mkN "ตัวแปร" | mkN "ส่วนต่าง" | mkN "การอภิปราย" | mkN "การเปลี่ยนแปลง" | mkN "ความเบี่ยงเบนมาตรฐาน" | mkN "ความต่าง" | mkN "ข้อแตกต่าง" | mkN "ข้อโต้แย้ง" | mkN "ความขัดแย้ง" | mkN "ความแตกต่าง" | mkN "การทะเลาะเบาะแว้ง" | mkN "แบ่งแยกข้อแตกต่าง" ; -- src=panlex
lin material_N = mkN "ผ้า" | mkN "วัตถุ" | mkN "วัสดุ" | mkN "สิ่งทอ" | mkN "ผู้เหมาะสม" | mkN "คนที่เหมาะสม" | mkN "ผ้า" | mkN "สสาร" | mkN "สาระ" | mkN "วัตถุ" | mkN "วัสดุ" | mkN "ข้อมูล" | mkN "ทางกาย" | mkN "ปัจจัย" | mkN "สิ่งทอ" | mkN "ใจความ" | mkN "ความคิด" | mkN "สิ่งของ" | mkN "เนอความ" | mkN "เนื้อหา" | mkN "คนเหมาะสม" | mkN "ผู้เหมาะสม" | mkN "ส่วนประกอบ" | mkN "ข้อเท็จจริง" | mkN "กลุ่มของความคิด ข้อเท็จจริงหรือข้อมูล" | mkN "เป็นปัจจัยสําคัญ" | mkN "เกี่ยวกับวัตถุพยาน" ; -- src=panlex
lin air_N = mkN "ลม" | mkN "รังสี" | mkN "ลมโชย" | mkN "อากาศ" | mkN "ธาตุลม" | mkN "บรรยากาศ" | mkN "สื่ออากาศ" | mkN "สายลมอ่อนๆ" | mkN "ชั้นบรรยากาศ" | mkN "การโดยสารเครื่องบิน" | mkN "การเดินทางโดยเครื่องบิน" | mkN "ลม" | mkN "เผย" | mkN "เพลง" | mkN "อวกาศ" | mkN "อากาศ" | mkN "ทํานอง" | mkN "ลมเย็น" | mkN "ลมอ่อน ๆ" | mkN "ท้องฟ้า" | mkN "กลิ่นอาย" | mkN "การหายใจ" | mkN "กินอากาศ" | mkN "บรรยากาศ" | mkN "ออกอากาศ" | mkN "ผึ่งอากาศ" | mkN "ท่วงทํานอง" | mkN "ลมที่พัดเบา" | mkN "ลักษณะเฉพาะ" | mkN "ออกโทรทัศน์" | mkN "ลักษณะท่าทาง" | mkN "คุณสมบัติเฉพาะ" | mkN "ออกความคิดเห็น" | mkN "อาการกลืนอากาศ" | mkN "เครื่องปรับอากาศ" | mkN "เครื่องทําความเย็น" | mkN "การเดินทางโดยเครื่องบิน" | mkN "ทําให้ลมเข้าออกได้สะดวก" ; -- src=panlex
lin wife_N = personN (thword "เมีย") | {-pan-} mkN "เมีย" | mkN "ภรรยา" | mkN "ภริยา" | mkN "แม่บ้าน" | mkN "ชายา" | mkN "เมีย" | mkN "ภรรยา" | mkN "ภริยา" | mkN "มเหสี" ; -- src=panlex
lin cover_V2 = variants{} ; -- 
lin apply_VV = mkVV "ทา" ; ---- | mkV "ใช้" | mkV "ให้" | mkV "นำมาใช้" | mkV "บังคับใช้" | mkV "นำไปใช้ได้" | mkV "ทา" | mkV "ฉาบ" | mkV "ใช้" | mkV "ไล้" | mkV "ป้าย" | mkV "ดัดแปลง" | mkV "ปรับใช้" | mkV "นํามาใช้" | mkV "ทํางานหนัก" | mkV "นํามาใช้กับ" | mkV "ประยุกต์ใช้" | mkV "ใช้ประโยชน์" ; -- src=panlex
lin apply_V2V = mmkV2V "ทา" ; ---- | mkV "ใช้" | mkV "ให้" | mkV "นำมาใช้" | mkV "บังคับใช้" | mkV "นำไปใช้ได้" | mkV "ทา" | mkV "ฉาบ" | mkV "ใช้" | mkV "ไล้" | mkV "ป้าย" | mkV "ดัดแปลง" | mkV "ปรับใช้" | mkV "นํามาใช้" | mkV "ทํางานหนัก" | mkV "นํามาใช้กับ" | mkV "ประยุกต์ใช้" | mkV "ใช้ประโยชน์" ; -- src=panlex
lin apply_V2 = mkV2 "ทา" ; ---- | mkV "ใช้" | mkV "ให้" | mkV "นำมาใช้" | mkV "บังคับใช้" | mkV "นำไปใช้ได้" | mkV "ทา" | mkV "ฉาบ" | mkV "ใช้" | mkV "ไล้" | mkV "ป้าย" | mkV "ดัดแปลง" | mkV "ปรับใช้" | mkV "นํามาใช้" | mkV "ทํางานหนัก" | mkV "นํามาใช้กับ" | mkV "ประยุกต์ใช้" | mkV "ใช้ประโยชน์" ; -- src=panlex
lin apply_1_V2 = variants{} ; -- 
lin apply_2_V2 = variants{} ; -- 
lin apply_V = mkV "ทา" | mkV "ใช้" | mkV "ให้" | mkV "นำมาใช้" | mkV "บังคับใช้" | mkV "นำไปใช้ได้" | mkV "ทา" | mkV "ฉาบ" | mkV "ใช้" | mkV "ไล้" | mkV "ป้าย" | mkV "ดัดแปลง" | mkV "ปรับใช้" | mkV "นํามาใช้" | mkV "ทํางานหนัก" | mkV "นํามาใช้กับ" | mkV "ประยุกต์ใช้" | mkV "ใช้ประโยชน์" ; -- src=panlex
lin project_N = mkN "งาน" | mkN "โครงการ" | mkN "โครงงาน" | mkN "โปรเจ็ก" | mkN "โปรเจ็กต์" | mkN "แผนการ" | mkN "แผนงาน" | mkN "โครงการ" | mkN "โครงการวิจัย" | mkN "โครงการค้นคว้า" ; -- src=panlex
lin raise_V2 = variants{} ; -- 
lin sale_N = mkN "การขาย" | mkN "การลดราคา" | mkN "การขายลดราคา" | mkN "สัญญาซื้อขาย" | mkN "ตลาด" | mkN "การขาย" | mkN "การประมูล" | mkN "การพาณิชย์" | mkN "การขายลดราคา" | mkN "การจัดจําหน่าย" | mkN "จํานวนที่ขายได้" | mkN "ปริมาณที่ขายได้" | mkN "โอกาสในการขายสินค้า" ; -- src=panlex
lin relationship_N = mkN "ความสัมพันธ์" | mkN "มนุษยสัมพันธ์" | mkN "ความสัมพันธ์ทางสายเลือด" | mkN "ความสัมพันธ์" | mkN "ความเกี่ยวดอง" | mkN "ความเกี่ยวพัน" | mkN "ความเป็นญาติกัน" | mkN "ความเกี่ยวข้องกัน" | mkN "ความสัมพันธ์ฉันท์ชู้สาว" ; -- src=panlex
lin indeed_Adv = mkAdv "จริง ๆ" | mkAdv "โดยแท้จริง" | mkAdv "ตามความจริง" | mkAdv "อย่างแท้จริง" | mkAdv "โดยแท้จริงแล้ว" ; -- src=panlex
lin light_N = mkN "ไฟ" | mkN "แสง" | mkN "ประกาย" | mkN "ที่จุดไฟ" | mkN "สัญญาณไฟ" | mkN "แสงสว่าง" | mkN "ความสว่าง" | mkN "แหล่งกำเนิดแสง" | mkN "แสง" | mkN "ไฟฉาย" | mkN "ไฟแช็ค" | mkN "ไฟจราจร" | mkN "แสงสว่าง" | mkN "ไฟรถยนต์" | mkN "ไฟหน้ารถ" | mkN "ไม้ขีดไฟ" | mkN "ความสว่าง" | mkN "แหล่งกําเนิดแสง" ; -- src=panlex
lin claim_VS = mmkVS "ได้รับ" ; ---- | mkV "ถือสิทธิ์" | mkV "เีรียกร้อง" | mkV "นำความสูญเสีย" | mkV "อ้าง" | mkV "กล่าวอ้าง" | mkV "เรียกร้อง" ; -- src=panlex
lin claim_V2 = mkV2 "ได้รับ" ; ---- | mkV "ถือสิทธิ์" | mkV "เีรียกร้อง" | mkV "นำความสูญเสีย" | mkV "อ้าง" | mkV "กล่าวอ้าง" | mkV "เรียกร้อง" ; -- src=panlex
lin claim_V = mkV "ได้รับ" | mkV "ถือสิทธิ์" | mkV "เีรียกร้อง" | mkV "นำความสูญเสีย" | mkV "อ้าง" | mkV "กล่าวอ้าง" | mkV "เรียกร้อง" ; -- src=panlex
lin form_V2 = mkV2 "เชฟ" ; ---- | mkV "ฟอร์ม" | mkV "ก่อตั้ง" | mkV "ขึ้นรูป" | mkV "จัดตั้ง" | mkV "ปลูกฝัง" | mkV "เป็นรูป" | mkV "ประกอบด้วย" | mkV "ทำให้เป็นรูป" | mkV "เป็นรูปเป็นร่าง" | mkV "ทำให้เป็นรูปร่าง" | mkV "ก่อแบบ" | mkV "จัดเเถว" | mkV "จัดเรียง" | mkV "จัดลําดับ" | mkV "พัฒนาขึ้น" | mkV "สร้างขึ้น" | mkV "เป็นรูปเป็นร่าง" | mkV "สร้างเป็นรูปเป็นร่าง" | mkV "ประกอบเป็นรูปเป็นร่าง" ; -- src=panlex
lin form_V = mkV "เชฟ" | mkV "ฟอร์ม" | mkV "ก่อตั้ง" | mkV "ขึ้นรูป" | mkV "จัดตั้ง" | mkV "ปลูกฝัง" | mkV "เป็นรูป" | mkV "ประกอบด้วย" | mkV "ทำให้เป็นรูป" | mkV "เป็นรูปเป็นร่าง" | mkV "ทำให้เป็นรูปร่าง" | mkV "ก่อแบบ" | mkV "จัดเเถว" | mkV "จัดเรียง" | mkV "จัดลําดับ" | mkV "พัฒนาขึ้น" | mkV "สร้างขึ้น" | mkV "เป็นรูปเป็นร่าง" | mkV "สร้างเป็นรูปเป็นร่าง" | mkV "ประกอบเป็นรูปเป็นร่าง" ; -- src=panlex
lin base_V2 = mkV2 "เผาสูดควัน" ; ---- | mkV "ใช้เป็นฐาน" | mkV "ตั้งเป็นฐาน" | mkV "ประจําการ" | mkV "วางรากฐาน" | mkV "มาจากรากฐาน" ; -- src=panlex
lin base_V = mkV "เผาสูดควัน" | mkV "ใช้เป็นฐาน" | mkV "ตั้งเป็นฐาน" | mkV "ประจําการ" | mkV "วางรากฐาน" | mkV "มาจากรากฐาน" ; -- src=panlex
lin care_N = mkN "การดูแล" | mkN "ความดูแล" | mkN "ความระวัง" | mkN "การช่วยเหลือ" | mkN "การดูแลรักษา" | mkN "ความเอาใจใส่" | mkN "การบำรุงรักษา" | mkN "การระมัดระวัง" | mkN "การดูแลเอาใจใส่" | mkN "การดูแล" | mkN "การปกป้อง" | mkN "ความห่วงใย" | mkN "ความระมัดระวัง" ; -- src=panlex
lin someone_NP = variants{} ; -- 
lin everything_NP = mkNP (thword "ทุก" "สิ่ง") ;
lin certainly_Adv = variants{} ; -- 
lin rule_N = mkN "กฎ" | {-pan-} mkN "สูตร" | mkN "หลัก" | mkN "คำสั่ง" | mkN "ระเบียบ" | mkN "กฎระเบียบ" | mkN "ไม้บรรทัด" | mkN "อำนาจปกครอง" | mkN "กฎทางภาษาศาสตร์" | mkN "ระเบียบข้อบังคับ" | mkN "หลัก" | mkN "กติกา" | mkN "วินัย" | mkN "ชี้ขาด" | mkN "ตีเส้น" | mkN "บรรทัด" | mkN "ปกครอง" | mkN "ครอบงํา" | mkN "ระเบียบ" | mkN "กฎระเบียบ" | mkN "การควบคุม" | mkN "การชี้ขาด" | mkN "การปกครอง" | mkN "ข้อบังคับ" | mkN "นิสัยปกติ" | mkN "มีอิทธิพล" | mkN "หลักเกณฑ์" | mkN "ไม้บรรทัด" | mkN "วินัยศาสนา" | mkN "เส้นบรรทัด" | mkN "การครอบครอง" | mkN "วินัยทางศาสนา" | mkN "วิธีการทางคณิตศาสตร์" | mkN "วิธีการคํานวณทางคณิตศาสตร์" ; -- src=panlex ----?
lin home_Adv = mkAdv "มุ่งไปที่บ้าน" ; -- src=panlex
lin cut_V2 = mkV2 (thword "ตัด") ;
lin cut_V = mkV "ชก" | mkV "ลด" | mkV "คัต" | mkV "งอก" | mkV "ตอน" | mkV "ตัด" | mkV "บาด" | mkV "ปิด" | mkV "ย่อ" | mkV "ออก" | mkV "ขึ้น" | mkV "ต่อย" | mkV "หยุด" | mkV "เจาะ" | mkV "ละลาย" | mkV "จัดการ" | mkV "ตัดชุด" | mkV "ตัดต่อ" | mkV "ตัดทอน" | mkV "ตัดไพ่" | mkV "บันทึก" | mkV "เบิร์น" | mkV "ใช้ตัด" | mkV "ตัดข้าม" | mkV "ปาดหน้า" | mkV "ย่อความ" | mkV "เดินลัด" | mkV "ตัดออกไป" | mkV "ตัดเสื้อ" | mkV "ตีลูกตัด" | mkV "ไม่ใส่ใจ" | mkV "ตีให้หมุน" | mkV "ปิดสวิตช์" | mkV "ตัดเป็นรูป" | mkV "เก็บเกี่ยว" | mkV "เดินตัดข้าม" | mkV "เหวี่ยงหมัด" | mkV "คัดลอกข้อมูล" | mkV "ให้ภาพลักษณ์" | mkV "ทำให้รสอ่อนลง" | mkV "มีผลกระทบลดลง" | mkV "เหวี่ยงกำปั้น" | mkV "ตัด" | mkV "บาด" | mkV "ตัดต่อ" | mkV "จ้วงแทง" | mkV "ลดปริมาณลง" | mkV "เป็นทางลัด" | mkV "ทําให้เป็นแผล" | mkV "ง่ายต่อการหั่น" ; -- src=panlex
lin grow_VA = mmkVA "โต" ; ---- | mkV "งอก" | mkV "ขึ้น" | mkV "ปลูก" | mkV "เติบโต" | mkV "เข้าสู่" | mkV "เริ่มต้น" | mkV "ทำไร่ทำนา" | mkV "เจริญเติบโต" | mkV "มีพัฒนาการทางร่างกาย" | mkV "โต" | mkV "งอก" | mkV "ปลูก" | mkV "เพาะ" | mkV "พัฒนา" | mkV "งอกงาม" | mkV "เติบโต" | mkV "เลี้ยง" | mkV "แผ่ขยาย" | mkV "เจริญเติบโต" | mkV "ทําให้งอกงาม" | mkV "ทําให้โตขึ้น" | mkV "ทําให้ใหญ่ขึ้น" | mkV "ทําให้เจริญเติบโต" | mkV "ทําให้เป็นผู้ใหญ่" ; -- src=panlex
lin grow_V2 = mkV2 "โต" ; ---- | mkV "งอก" | mkV "ขึ้น" | mkV "ปลูก" | mkV "เติบโต" | mkV "เข้าสู่" | mkV "เริ่มต้น" | mkV "ทำไร่ทำนา" | mkV "เจริญเติบโต" | mkV "มีพัฒนาการทางร่างกาย" | mkV "โต" | mkV "งอก" | mkV "ปลูก" | mkV "เพาะ" | mkV "พัฒนา" | mkV "งอกงาม" | mkV "เติบโต" | mkV "เลี้ยง" | mkV "แผ่ขยาย" | mkV "เจริญเติบโต" | mkV "ทําให้งอกงาม" | mkV "ทําให้โตขึ้น" | mkV "ทําให้ใหญ่ขึ้น" | mkV "ทําให้เจริญเติบโต" | mkV "ทําให้เป็นผู้ใหญ่" ; -- src=panlex
lin grow_V = mkV "โต" | mkV "งอก" | mkV "ขึ้น" | mkV "ปลูก" | mkV "เติบโต" | mkV "เข้าสู่" | mkV "เริ่มต้น" | mkV "ทำไร่ทำนา" | mkV "เจริญเติบโต" | mkV "มีพัฒนาการทางร่างกาย" | mkV "โต" | mkV "งอก" | mkV "ปลูก" | mkV "เพาะ" | mkV "พัฒนา" | mkV "งอกงาม" | mkV "เติบโต" | mkV "เลี้ยง" | mkV "แผ่ขยาย" | mkV "เจริญเติบโต" | mkV "ทําให้งอกงาม" | mkV "ทําให้โตขึ้น" | mkV "ทําให้ใหญ่ขึ้น" | mkV "ทําให้เจริญเติบโต" | mkV "ทําให้เป็นผู้ใหญ่" ; -- src=panlex
lin similar_A = mkA "เสมือน" | mkA "เหมือน" | mkA "คล้ายกัน" | mkA "เหมือนกัน" | mkA "คล้ายคลึงกัน" | mkA "เปรียบเสมือน" | mkA "เปรียบเหมือน" | mkA "คล้าย" | mkA "คล้ายกัน" | mkA "เหมือนกัน" | mkA "มีมุมเดียวกัน" | mkA "ทํานองเดียวกัน" | mkA "มีสัดส่วนเหมือนกัน" ; -- src=panlex
lin story_N = mkN "ชั้น" | mkN "นิทาน" | mkN "สตอรี่" | mkN "เรื่อง" | mkN "เรื่องราว" | mkN "เรื่องโม้" | mkN "รายงานข่าว" | mkN "เรื่องเล่า" | mkN "เรื่องขี้โม้" | mkN "ข่าว" | mkN "นิทาน" | mkN "นิยาย" | mkN "การโกหก" | mkN "ประวัติ" | mkN "พงศาวดาร" | mkN "เทพนิยาย" | mkN "การบรรยาย" | mkN "เรื่องราว" | mkN "รายงานข่าว" | mkN "เรื่องเล่า" | mkN "เรื่องแต่ง" | mkN "เรื่องโกหก" | mkN "การเล่านิยาย" | mkN "ชั้นของอาคาร" | mkN "เรื่องโกลาหล" | mkN "การรายงานข่าว" | mkN "เรื่องเล่าลือ" | mkN "ห้องที่อยู่ชั้นเดียวกันของอาคาร" ; -- src=panlex
lin quality_N = mkN "คุณภาพ" | mkN "ลักษณะ" | mkN "โทนเสียง" | mkN "คุณภาพ" | mkN "ลักษณะ" | mkN "น้ําเพชร" | mkN "คุณภาพสูง" | mkN "คุณลักษณะ" | mkN "คุณสมบัติ" | mkN "ความดีเลิศ" | mkN "มีคุณภาพสูง" ; -- src=panlex
lin tax_N = mkN "ภาษี" | mkN "ภาษีอากร" | mkN "ด่า" | mkN "ภาษี" | mkN "ส่วย" | mkN "อากร" | mkN "จังกอบ" | mkN "ตําหนิ" | mkN "ประณาม" | mkN "ภาษีอากร" | mkN "เงินภาษี" | mkN "ประเมินค่า" | mkN "ทําให้เกิดภาระหน้าที่" | mkN "ค่าใช้จ่ายสําหรับสมาชิก" | mkN "การที่ต้องใช้ความพยายามอย่างมาก" | mkN "การเรียกร้องให้ใช้ความพยายามอย่างมาก" ; -- src=panlex
lin worker_N = mkN "คนงาน" | mkN "มดงาน" | mkN "กรรมกร" | mkN "แรงงาน" | mkN "คนทำงาน" | mkN "พนักงาน" | mkN "ผู้กระทำ" | mkN "คน สัตว์ สิ่งของหรือเครื่องจักรที่ใช้ในการทํางาน" | mkN "คนงาน" | mkN "มดงาน" | mkN "กรรมกร" | mkN "ปลวกงาน" | mkN "ผึ้งงาน" | mkN "พนักงาน" | mkN "ลูกจ้าง" | mkN "ผู้ทํางาน" | mkN "เจ้าหน้าที่" | mkN "ผู้ใช้แรงงาน" | mkN "ผู้ปฏิบัติการ" | mkN "ชนชั้นกรรมาชีพ" ; -- src=panlex
lin nature_N = mkN "ธรรมชาติ" | mkN "ชนิด" | mkN "นิสัย" | mkN "วัตถุ" | mkN "ทางโลก" | mkN "ลักษณะ" | mkN "สันดาน" | mkN "ธาตุแท้" | mkN "ธรรมชาติ" | mkN "อุปนิสัย" | mkN "กฎธรรมชาติ" | mkN "สภาพธรรมชาติ" | mkN "หลักธรรมชาติ" | mkN "ลักษณะที่แท้จริงของสิ่งต่างๆ" ; -- src=panlex
lin structure_N = mkN "ระบบสังคม" | mkN "โครงสร้าง" | mkN "สิ่งก่อสร้าง" | mkN "โครงสร้างสังคม" | mkN "องค์การทางสังคม" | mkN "โครงสร้างร่างกาย" | mkN "โครง" | mkN "อาคาร" | mkN "จัดทํา" | mkN "ประกอบ" | mkN "ลักษณะ" | mkN "แบบแผน" | mkN "จัดตั้ง" | mkN "ก่อสร้าง" | mkN "โครงร่าง" | mkN "โครงสร้าง" | mkN "ส่วนประกอบ" | mkN "องค์ประกอบ" | mkN "วิธีการสร้าง" | mkN "สิ่งก่อสร้าง" | mkN "สิ่งที่สร้างขึ้น" | mkN "ส่วนประกอบที่หยาบกว่าของหิน" ; -- src=panlex
lin data_N = mkN "ข้อมูล" | mkN "ชุดข้อมูล" | mkN "กลุ่มข้อมูล" | mkN "สถิติ" | mkN "ข้อมูล" | mkN "ตัวเลข" ; -- src=panlex
lin necessary_A = mkA "จำเป็น" | mkA "สําคัญ" | mkA "จําเป็น" | mkA "ความจําเป็น" | mkA "ไม่มีทางอื่น" | mkA "ซึ่งเลี่ยงไม่ได้" | mkA "ซึ่งเป็นที่ต้องการ" ; -- src=panlex
lin pound_N = mkN "ปอนด์" | mkN "กรงหมา" | mkN "การทุบ" | mkN "คอกหมา" | mkN "กรงสุนัข" | mkN "คอกสุนัข" | mkN "ปอนด์สเตอร์ลิง" | mkN "สัญลักษณ์เงินปอนด์" | mkN "ปอนด์" | mkN "เครื่องบด" | mkN "เครื่องตํา" | mkN "ที่ขังสัตว์" | mkN "ปอนด์สเตอลิงก์" | mkN "กรงขังสุนัขจรจัด" | mkN "หน่วยวัดน้ําหนัก" | mkN "หน่วยเงินตราของอังกฤษ" ; -- src=panlex
lin method_N = mkN "วิธี" | mkN "วิธีการ" | mkN "เทคนิคการแสดง" | mkN "วิธี" | mkN "แนวทาง" | mkN "แบบแผน" | mkN "ระเบียบ" | mkN "วิธีการ" | mkN "วิธีดําเนินการ" ; -- src=panlex
lin unit_N = variants{} ; -- 
lin unit_6_N = variants{} ; -- 
lin unit_5_N = variants{} ; -- 
lin unit_4_N = variants{} ; -- 
lin unit_3_N = variants{} ; -- 
lin unit_2_N = variants{} ; -- 
lin unit_1_N = variants{} ; -- 
lin central_A = mkA "หลัก" | mkA "ใหญ่" | mkA "เป็นศูนย์กลาง" | mkA "สําคัญ" | mkA "ใจกลาง" | mkA "ที่สําคัญ" | mkA "ที่เป็นศูนย์กลาง" | mkA "เกี่ยวกับระบบประสาทส่วนกลาง" | mkA "ซึ่งอยู่ตรงกลางหรือใกล้ตรงกลาง" ; -- src=panlex
lin bed_N = mkN "ก้น" | mkN "ฐาน" | mkN "ชั้น" | mkN "แปลง" | mkN "เตียง" | mkN "ที่นอน" | mkN "ชั้นหิน" | mkN "เตียงนอน" | mkN "แปลงปลูก" | mkN "แท่นพิมพ์" | mkN "ชั้นหินแร่" | mkN "แปลงปลูกพืช" | mkN "พระแท่นบรรทม" | mkN "พื้นดินใต้ทะเลลึก" | mkN "ฐาน" | mkN "ฟูก" | mkN "ร่อง" | mkN "หมอน" | mkN "แท่น" | mkN "แปลง" | mkN "เตียง" | mkN "ที่นอน" | mkN "แนวหิน" | mkN "ชั้นหิน" | mkN "กองหนึ่ง" | mkN "พื้นล่าง" | mkN "เตียงนอน" | mkN "การนอนหลับ" | mkN "แปลงที่ดิน" | mkN "พื้นถนนรถไฟ" | mkN "ที่สําหรับนอน" | mkN "ใต้ท้องแม่น้ํา" | mkN "พื้นดินก้นทะเล แม้น้ําหรือทะเลสาบ" | mkN "การมีเพศสัมพันธ์" | mkN "ฐานของถนนหรือรางรถไฟ" | mkN "พื้นที่ใต้ทะเลที่มีหอยฝังตัวอยู่" ; -- src=panlex
lin union_N = mkN "ผลบวก" | mkN "สหภาพ" | mkN "การสมรส" | mkN "ชีวิตคู่" | mkN "ตราสหภาพ" | mkN "ชีวิตสมรส" | mkN "การออกเรือน" | mkN "สหภาพแรงงาน" | mkN "การงอกประสาน" | mkN "การรวมตัวกัน" | mkN "การมีเพศสัมพันธ์" | mkN "การจับคู่ผสมพันธ์" | mkN "การจับคู่ผสมพันธุ์" | mkN "การรวมเป็นหนึ่งเดียว" | mkN "สมาคม" | mkN "สหภาพ" | mkN "สหพันธ" | mkN "การสมรส" | mkN "การจับคู่" | mkN "การรวมกัน" | mkN "การสังวาส" | mkN "สหพันธรัฐ" | mkN "การมีเรือน" | mkN "การสมรสกัน" | mkN "ส่งท่อร่วม" | mkN "ความสามัคคี" | mkN "สหภาพแรงงาน" | mkN "การรวมตัวกัน" | mkN "ชีวิตการสมรส" | mkN "จํานวนทั้งหมด" | mkN "สหพันธ์แรงงาน" | mkN "องค์การกรรมกร" | mkN "การสอดคล้องกัน" | mkN "เครื่องมือเชื่อมต่อ" ; -- src=panlex
lin movement_N = mkN "การขยับ" | mkN "แนวโน้ม" | mkN "การรณรงค์" | mkN "การเคลื่อนที่" | mkN "การเคลื่อนไหว" | mkN "การเคลื่อนย้าย" | mkN "ขบวนการทางสังคม" | mkN "การขับถ่ายอุจจาระ" | mkN "ขบวนการเคลื่อนไหวทางสังคม" | mkN "การขยับ" | mkN "ขบวนการ" | mkN "องค์การ" | mkN "คณะบุคคล" | mkN "กระบวนการ" | mkN "ความพยายาม" | mkN "กริยาท่าทาง" | mkN "กิริยาท่าทาง" | mkN "การดําเนินงาน" | mkN "การเคลื่อนที่" | mkN "การเคลื่อนไหว" | mkN "ช่วงหนึ่งของเพลง" | mkN "การเคลื่อนกําลังทหาร" | mkN "การโยกย้ายกําลังทหาร" | mkN "ส่วนที่เคลื่อนไหวของระบบกลไก" ; -- src=panlex
lin board_N = variants{} ; -- 
lin board_2_N = variants{} ; -- 
lin board_1_N = variants{} ; -- 
lin true_A = mkA "ตรง" | mkA "แน่นอน" | mkA "แม่นยำ" | mkA "ถูกคีย์" | mkA "เที่ยงตรง" | mkA "ซึ่งวางใจได้" | mkA "ซึ่งไว้ใจได้" | mkA "ซึ่งพึ่งพาได้" | mkA "ที่พูดความจริง" | mkA "แท้" | mkA "จริง" | mkA "แม่น" | mkA "ถูกต้อง" | mkA "ที่ไม่ปลอม" | mkA "ที่ไว้ใจได้" | mkA "ที่ซื่อสัตย์" | mkA "ที่เป็นของแท้" | mkA "ที่ไม่หลอกลวง" | mkA "อย่างซื่อสัตย์" | mkA "ที่เป็นเรื่องจริง" ; -- src=panlex
lin well_Interj = mkInterj "แหม" | mkInterj "ปู้โธ่" ; -- src=panlex
lin simply_Adv = variants{} ; -- 
lin contain_V2 = variants{} ; -- 
lin especially_Adv = variants{} ; -- 
lin open_A = mkA "เปิด" | mkA "ลืมตา" | mkA "ซึ่งเปิด" | mkA "เปิดผนึก" | mkA "ซึ่งเปิดขาย" | mkA "ที่เปิดผนึก" | mkA "ว่าง" | mkA "โล่ง" | mkA "ลงมือ" | mkA "โปร่ง" | mkA "ใจบุญ" | mkA "เปิดรับ" | mkA "เปิดเผย" | mkA "เปิดโล่ง" | mkA "เริ่มต้น" | mkA "เปิดกว้าง" | mkA "เปิดอิสระ" | mkA "ไม่ปิดบัง" | mkA "ที่เปิดอยู่" | mkA "ที่ถกเถียงกันได้" | mkA "ยังไม่ตกลงกันได้" | mkA "ที่มีนิสัยตรงไปตรงมา" | mkA "ที่เปิดเผยสู่สาธารณะ" | mkA "ที่ไม่มีสิ่งใดปิดกั้น" ; -- src=panlex
lin short_A = mkA (thword "สั้น") | {-pan-} mkA "สั้น" | mkA "แคระ" | mkA "สั้นๆ" | mkA "เตี้ย" | mkA "ที่ไม่เพียงพอ" | mkA "ขาด" | mkA "ต่ำ" | mkA "ย่อ" | mkA "กรอบ" | mkA "ตื้น" | mkA "ต่ํา" | mkA "น้อย" | mkA "ย่อๆ" | mkA "ลุ่น" | mkA "สั้น" | mkA "ห้วน" | mkA "อ่อน" | mkA "ใกล้" | mkA "ขัดสน" | mkA "เตี้ย" | mkA "เปราะ" | mkA "ไม่พอ" | mkA "บอบบาง" | mkA "สังเขป" | mkA "ไม่ถึง" | mkA "ไม่นาน" | mkA "ไม่ยาว" | mkA "ขาดแคลน" | mkA "ไม่ดีพอ" | mkA "ชั่วครู่" | mkA "ระยะสั้น" | mkA "เปราะบาง" | mkA "ระยะสั้นๆ" | mkA "ซึ่งไม่อดทน" | mkA "ซึ่งโกรธง่าย" | mkA "ซึ่งแตกหักง่าย" | mkA "ซึ่งถูกกระตุ้นให้โกรธได้ง่าย" ; -- src=panlex
lin personal_A = mkA "ส่วนตัว" | mkA "ส่วนบุคคล" | mkA "ทางร่างกาย" | mkA "ที่แสดงบุคคล" | mkA "ส่วนตัว" | mkA "เฉพาะตัว" | mkA "โดยตนเอง" | mkA "ด้วยตนเอง" | mkA "ส่วนบุคคล" | mkA "เฉพาะบุคคล" | mkA "ทางเรือนร่าง" | mkA "ในด้านร่างกาย" | mkA "เกี่ยวกับบุรุษ" | mkA "เกี่ยวกับรูปร่างภายนอก" | mkA "เกี่ยวกับทรัพย์สินส่วนตัว" ; -- src=panlex
lin detail_N = mkN "ส่วนย่อย" | mkN "รายละเอียด" | mkN "ทีมเฉพาะกิจ" | mkN "กองทหารชั่วคราว" | mkN "หน่วยทหารเฉพาะกิจ" | mkN "ส่วนย่อย" | mkN "ส่วนเล็กๆ น้อยๆ" | mkN "รายละเอียด" | mkN "ข้อปลีกย่อย" | mkN "แต่งตั้งหรือสั่งให้ปฎิบัติการพิเศษ" ; -- src=panlex
lin model_N = mkN "แบบ" | mkN "โมเดล" | mkN "นางแบบ" | mkN "ตัวอย่าง" | mkN "แบบจำลอง" | mkN "แบบอย่าง" | mkN "การทำโมเดล" | mkN "นางแบบแฟชั่น" | mkN "แบบ" | mkN "แสดง" | mkN "ต้นแบบ" | mkN "นางแบบ" | mkN "แม่แบบ" | mkN "ตัวอย่าง" | mkN "สร้างแบบ" | mkN "แบบอย่าง" | mkN "รูปจําลอง" | mkN "สร้างหุ่น" | mkN "แบบจําลอง" | mkN "สิ่งจําลอง" | mkN "หุ่นจําลอง" | mkN "บุคคลตัวอย่าง" | mkN "สิ่งที่เป็นตัวอย่าง" ; -- src=panlex
lin bear_V2 = mkV2 "ทน" ; ---- | mkV "มี" | mkV "ยก" | mkV "ยืด" | mkV "รับ" | mkV "แบก" | mkV "คลอด" | mkV "จ่าย" | mkV "ท้อง" | mkV "ป่อง" | mkV "อดทน" | mkV "เกิด" | mkV "เชิด" | mkV "บรรจุ" | mkV "ยอมทน" | mkV "ออกผล" | mkV "ให้ผล" | mkV "มีท้อง" | mkV "คลอดลูก" | mkV "มีครรภ์" | mkV "อดกลั้น" | mkV "เกิดลูก" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "ประพฤติตน" | mkV "มีหนี้สิน" | mkV "ให้กำเนิด" | mkV "ประพฤติตัว" | mkV "ได้รับสิทธิ์" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "มีพระประสูติการ" | mkV "ทน" | mkV "ถือ" | mkV "ค้ํา" | mkV "พยุง" | mkV "หนุน" | mkV "อดทน" | mkV "ทนทาน" | mkV "นําไป" | mkV "ระลึก" | mkV "คลอดลูก" | mkV "บ่ายหน้า" | mkV "ส่งเสริม" | mkV "รับผิดชอบ" | mkV "ปฏิบัติตัว" | mkV "ประพฤติตัว" | mkV "ให้กําเนิด" | mkV "จดจําไว้ใน่ใจ" | mkV "มุ่งหน้าไปทางใดทางหนึ่ง" ; -- src=panlex
lin bear_V = mkV "ทน" | mkV "มี" | mkV "ยก" | mkV "ยืด" | mkV "รับ" | mkV "แบก" | mkV "คลอด" | mkV "จ่าย" | mkV "ท้อง" | mkV "ป่อง" | mkV "อดทน" | mkV "เกิด" | mkV "เชิด" | mkV "บรรจุ" | mkV "ยอมทน" | mkV "ออกผล" | mkV "ให้ผล" | mkV "มีท้อง" | mkV "คลอดลูก" | mkV "มีครรภ์" | mkV "อดกลั้น" | mkV "เกิดลูก" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "ประพฤติตน" | mkV "มีหนี้สิน" | mkV "ให้กำเนิด" | mkV "ประพฤติตัว" | mkV "ได้รับสิทธิ์" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "มีพระประสูติการ" | mkV "ทน" | mkV "ถือ" | mkV "ค้ํา" | mkV "พยุง" | mkV "หนุน" | mkV "อดทน" | mkV "ทนทาน" | mkV "นําไป" | mkV "ระลึก" | mkV "คลอดลูก" | mkV "บ่ายหน้า" | mkV "ส่งเสริม" | mkV "รับผิดชอบ" | mkV "ปฏิบัติตัว" | mkV "ประพฤติตัว" | mkV "ให้กําเนิด" | mkV "จดจําไว้ใน่ใจ" | mkV "มุ่งหน้าไปทางใดทางหนึ่ง" ; -- src=panlex
lin single_A = variants{} ; -- 
lin single_2_A = variants{} ; -- 
lin single_1_A = variants{} ; -- 
lin join_V2 = mkV2 "ต่อ" ; ---- | mkV "ร่วม" | mkV "เชื่อม" | mkV "เข้าร่วม" | mkV "เชื่อมกัน" | mkV "เชื่อมต่อ" | mkV "ทำให้เชื่อมกัน" | mkV "ต่อ" | mkV "โยง" | mkV "ร่วม" | mkV "สมทบ" | mkV "ประสาน" | mkV "ร่วมวง" | mkV "เชื่อม" | mkV "บรรจบกัน" | mkV "ประสมโรง" | mkV "เข้าร่วม" | mkV "มีส่วนร่วม" | mkV "เข้าร่วมเป็นสมาชิก" ; -- src=panlex
lin join_V = mkV "ต่อ" | mkV "ร่วม" | mkV "เชื่อม" | mkV "เข้าร่วม" | mkV "เชื่อมกัน" | mkV "เชื่อมต่อ" | mkV "ทำให้เชื่อมกัน" | mkV "ต่อ" | mkV "โยง" | mkV "ร่วม" | mkV "สมทบ" | mkV "ประสาน" | mkV "ร่วมวง" | mkV "เชื่อม" | mkV "บรรจบกัน" | mkV "ประสมโรง" | mkV "เข้าร่วม" | mkV "มีส่วนร่วม" | mkV "เข้าร่วมเป็นสมาชิก" ; -- src=panlex
lin reduce_V2 = mkV2 "กด" ; ---- | mkV "ลด" | mkV "ย่อ" | mkV "กำราบ" | mkV "ตัดทอน" | mkV "ลดขนาด" | mkV "เคี่ยว" | mkV "ย่อความ" | mkV "ลดเสียง" | mkV "ปราบปราม" | mkV "รีดไขมัน" | mkV "ลดน้ำหนัก" | mkV "แบ่งเซลล์" | mkV "จัดวางใหม่" | mkV "ดีออกซิไดซ์" | mkV "ทำให้เล็กลง" | mkV "ทำให้พอเพียง" | mkV "ทำให้รสอ่อนลง" | mkV "ลดความซับซ้อน" | mkV "นำมาสู่ความอ่อนแอ" | mkV "คือองค์ประกอบจำเป็น" | mkV "ลดลง" | mkV "สรุป" | mkV "ลดทอน" | mkV "ตัดทอน" | mkV "บังคับ" | mkV "รวบยอด" | mkV "รวบรวม" | mkV "ลดขั้น" | mkV "ลดราคา" | mkV "ลดระดับ" | mkV "ลดหย่อน" | mkV "ปราบปราม" | mkV "ทําให้ถูกลง" | mkV "เคี่ยวจนข้น" | mkV "ทําให้น้อยลง" | mkV "ทําให้เข้มข้นขึ้น" ; -- src=panlex
lin reduce_V = mkV "กด" | mkV "ลด" | mkV "ย่อ" | mkV "กำราบ" | mkV "ตัดทอน" | mkV "ลดขนาด" | mkV "เคี่ยว" | mkV "ย่อความ" | mkV "ลดเสียง" | mkV "ปราบปราม" | mkV "รีดไขมัน" | mkV "ลดน้ำหนัก" | mkV "แบ่งเซลล์" | mkV "จัดวางใหม่" | mkV "ดีออกซิไดซ์" | mkV "ทำให้เล็กลง" | mkV "ทำให้พอเพียง" | mkV "ทำให้รสอ่อนลง" | mkV "ลดความซับซ้อน" | mkV "นำมาสู่ความอ่อนแอ" | mkV "คือองค์ประกอบจำเป็น" | mkV "ลดลง" | mkV "สรุป" | mkV "ลดทอน" | mkV "ตัดทอน" | mkV "บังคับ" | mkV "รวบยอด" | mkV "รวบรวม" | mkV "ลดขั้น" | mkV "ลดราคา" | mkV "ลดระดับ" | mkV "ลดหย่อน" | mkV "ปราบปราม" | mkV "ทําให้ถูกลง" | mkV "เคี่ยวจนข้น" | mkV "ทําให้น้อยลง" | mkV "ทําให้เข้มข้นขึ้น" ; -- src=panlex
lin establish_V2 = variants{} ; -- 
lin wall_N = mkN "ฝา" | mkN "ผนัง" | mkN "กำแพง" | mkN "ฝาผนัง" | mkN "ป้อมปราการ" | mkN "ฝา" | mkN "ผนัง" | mkN "กำแพง" | mkN "กําแพง" | mkN "เขื่อน" | mkN "ผนังห้อง" | mkN "ฉากกําบัง" | mkN "ป้อมปราการ" | mkN "สิ่งที่เป็นอุปสรรค" | mkN "หินที่ก่อขึ้นเป็นรั้ว" | mkN "สิ่งที่ไม่อาจทะลุผ่านไปได้" ; -- src=panlex
lin face_V2 = mkV2 "เผชิญหน้า" ; ---- | mkV "ทำให้เผชิญ" | mkV "ปิดด้านหน้า" | mkV "อยู่ตรงข้าม" | mkV "หันหน้าไปทาง" | mkV "พบ" | mkV "เจอ" | mkV "เผชิญ" | mkV "เผชิญหน้า" | mkV "หันหน้าไปทาง" | mkV "หันหน้าออกไปทาง" | mkV "มองสิ่งหนึ่งสิ่งใด" ; -- src=panlex
lin face_V = mkV "เผชิญหน้า" | mkV "ทำให้เผชิญ" | mkV "ปิดด้านหน้า" | mkV "อยู่ตรงข้าม" | mkV "หันหน้าไปทาง" | mkV "พบ" | mkV "เจอ" | mkV "เผชิญ" | mkV "เผชิญหน้า" | mkV "หันหน้าไปทาง" | mkV "หันหน้าออกไปทาง" | mkV "มองสิ่งหนึ่งสิ่งใด" ; -- src=panlex
lin easy_A = mkA "ง่าย" | mkA "ง่ายๆ" | mkA "ใจง่าย" | mkA "ง่ายดาย" | mkA "มั่งคั่ง" | mkA "ซึ่งได้มาง่าย" | mkA "ง่าย" | mkA "สบายๆ" | mkA "ไม่รัด" | mkA "ง่ายดาย" | mkA "ผ่อนผัน" | mkA "ไม่แน่น" | mkA "สะดวกสบาย" | mkA "ไม่ลําบาก" | mkA "ไม่เข้มงวด" | mkA "ไม่เป็นภาระ" | mkA "สบายอกสบายใจ" | mkA "ไม่มีพิธีรีตรอง" ; -- src=panlex
lin private_A = mkA "บุคคล" | mkA "รโหฐาน" | mkA "สันโดษ" | mkA "ส่วนตัว" | mkA "เฉพาะตัว" | mkA "โดยเอกชน" | mkA "เป็นความลับ" | mkA "ที่เป็นส่วนตัว" | mkA "ไม่ปล่อยให้คนอื่นรู้" ; -- src=panlex
lin computer_N = mkN (thword "คอม" "พิว" "เตอร์") "เครื่อง" | {-pan-} mkN "คอม" | mkN "นักคำนวณ" | mkN "นักคิดเลข" | mkN "คอมพิวเตอร์" | mkN "เครื่องคอมพิวเตอร์" | mkN "ผู้คํานวณ" | mkN "คอมพิวเตอร์" | mkN "เครื่องคํานวณ" | mkN "เครื่องคอมพิวเตอร์" ; -- src=panlex
lin hospital_N = mkN "ร.พ." | mkN "รพ." | mkN "โรงบาล" | mkN "โรงหมอ" | mkN "โรงพยาบาล" | mkN "ร.พ." | mkN "โรงหมอ" | mkN "โรงพยาบาล" ; -- src=panlex
lin chapter_N = mkN "บท" | mkN "สาขา" | mkN "ตอนย่อย" | mkN "การประชุมสงฆ์" | mkN "ตอน" | mkN "สาขา" | mkN "คณะพระ" | mkN "เรื่อง" | mkN "ขั้นตอน" | mkN "คณะสงฆ์" | mkN "ช่วงเวลา" | mkN "ส่วนย่อย" | mkN "บทในหนังสือ" | mkN "ส่วนแบ่งที่สําคัญ" ; -- src=panlex
lin scheme_N = mkN "ระบบ" | mkN "เล่ห์" | mkN "กลยุทธ์" | mkN "เอาท์ไลน์" | mkN "กลเม็ด" | mkN "รายการ" | mkN "วางผัง" | mkN "แบบแผน" | mkN "แผนการ" | mkN "แผนผัง" | mkN "แผนลับ" | mkN "เพทุบาย" | mkN "แผนร้าย" | mkN "โครงการ" | mkN "ออกอุบาย" | mkN "วางแบบแผน" | mkN "วางแผนร้าย" | mkN "วางโครงการ" | mkN "แผนภาพดวงดาว" | mkN "แผนภาพอธิบาย" | mkN "ระบบการจัดการ" ; -- src=panlex
lin theory_N = mkN "ทฤษฎี" | mkN "สมมุติฐาน" | mkN "ทฤษฎี" | mkN "หลักการ" | mkN "สมมติฐาน" | mkN "หลักวิชา" ; -- src=panlex
lin choose_VV = variants{} ; -- 
lin choose_V2 = variants{} ; -- 
lin wish_VV = mkVV "อยาก" ; ---- | mkV "ขอให้" | mkV "อวยพร" | mkV "ให้พร" | mkV "ปรารถนา" | mkV "ประสาทพร" | mkV "แสดงความประสงค์" | mkV "ต้องการ" | mkV "นึกอยาก" | mkV "ประสงค์" | mkV "ปรารถนา" ; -- src=panlex
lin wish_VS = mmkVS "อยาก" ; ---- | mkV "ขอให้" | mkV "อวยพร" | mkV "ให้พร" | mkV "ปรารถนา" | mkV "ประสาทพร" | mkV "แสดงความประสงค์" | mkV "ต้องการ" | mkV "นึกอยาก" | mkV "ประสงค์" | mkV "ปรารถนา" ; -- src=panlex
lin wish_V2V = mmkV2V "อยาก" ; ---- | mkV "ขอให้" | mkV "อวยพร" | mkV "ให้พร" | mkV "ปรารถนา" | mkV "ประสาทพร" | mkV "แสดงความประสงค์" | mkV "ต้องการ" | mkV "นึกอยาก" | mkV "ประสงค์" | mkV "ปรารถนา" ; -- src=panlex
lin wish_V2 = mkV2 "อยาก" ; ---- | mkV "ขอให้" | mkV "อวยพร" | mkV "ให้พร" | mkV "ปรารถนา" | mkV "ประสาทพร" | mkV "แสดงความประสงค์" | mkV "ต้องการ" | mkV "นึกอยาก" | mkV "ประสงค์" | mkV "ปรารถนา" ; -- src=panlex
lin wish_V = mkV "อยาก" | mkV "ขอให้" | mkV "อวยพร" | mkV "ให้พร" | mkV "ปรารถนา" | mkV "ประสาทพร" | mkV "แสดงความประสงค์" | mkV "ต้องการ" | mkV "นึกอยาก" | mkV "ประสงค์" | mkV "ปรารถนา" ; -- src=panlex
lin property_N = variants{} ; -- 
lin property_2_N = variants{} ; -- 
lin property_1_N = variants{} ; -- 
lin achieve_V2 = variants{} ; -- 
lin financial_A = mkA "ทางการเงิน" | mkA "ทางการเงิน" | mkA "เกี่ยวกับการคลัง" | mkA "เกี่ยวกับการเงิน" ; -- src=panlex
lin poor_A = variants{} ; -- 
lin poor_3_A = variants{} ; -- 
lin poor_2_A = variants{} ; -- 
lin poor_1_A = variants{} ; -- 
lin officer_N = variants{} ; -- 
lin officer_3_N = variants{} ; -- 
lin officer_2_N = variants{} ; -- 
lin officer_1_N = variants{} ; -- 
lin up_Prep = mkPrep "ไปตาม" | mkPrep "ข้างบน" ; -- src=panlex
lin charge_N = variants{} ; -- 
lin charge_2_N = variants{} ; -- 
lin charge_1_N = variants{} ; -- 
lin director_N = mkN "ผจก." | mkN "วาทยากร" | mkN "ผู้กำกับ" | mkN "ผู้จัดการ" | mkN "คอนดักเตอร์" | mkN "ผู้กำกับหนัง" | mkN "ผู้อำนวยเพลง" | mkN "ผู้กำกับการแสดง" | mkN "ผู้อำนวยการเพลง" | mkN "กรรมการผู้จัดการ" | mkN "ผู้กำกับภาพยนตร์" | mkN "ผู้ส่ง" | mkN "ผู้บัญชา" | mkN "ผู้จัดการ" | mkN "ผู้ชี้ทาง" | mkN "ผู้บริหาร" | mkN "ผู้แนะนํา" | mkN "ผู้อํานวยการ" | mkN "ผู้นําวงดนตรี" | mkN "หัวหน้าวงดนตรี" | mkN "ผู้ควบคุมวงดนตรี" | mkN "ผู้กํากับการแสดงภาพยนตร์" ; -- src=panlex
lin drive_V2V = mmkV2V "ขับ" ; ---- | mkV "ตอก" | mkV "ขับรถ" | mkV "ไดรฟ์" | mkV "กระแทก" | mkV "ขับดัน" | mkV "ไล่ล่า" | mkV "กระทุ้ง" | mkV "ผลักดัน" | mkV "ล่าสัตว์" | mkV "ต้องการไป" | mkV "ขับเคลื่อน" | mkV "ทำงานขับรถ" | mkV "เป็นคนขับรถ" | mkV "ทำให้ถอยหลัง" | mkV "พยายามอย่างหนัก" | mkV "เป็นพนักงานขับรถ" | mkV "ขับ" | mkV "ขับรถ" | mkV "ขับขี่" | mkV "ควบคุม" | mkV "บังคับ" | mkV "พยายาม" | mkV "ออกแรง" | mkV "กระตุ้น" | mkV "เดินทางโดยรถยนต์" ; -- src=panlex
lin drive_V2 = mkV2 "ขับ" ; ---- | mkV "ตอก" | mkV "ขับรถ" | mkV "ไดรฟ์" | mkV "กระแทก" | mkV "ขับดัน" | mkV "ไล่ล่า" | mkV "กระทุ้ง" | mkV "ผลักดัน" | mkV "ล่าสัตว์" | mkV "ต้องการไป" | mkV "ขับเคลื่อน" | mkV "ทำงานขับรถ" | mkV "เป็นคนขับรถ" | mkV "ทำให้ถอยหลัง" | mkV "พยายามอย่างหนัก" | mkV "เป็นพนักงานขับรถ" | mkV "ขับ" | mkV "ขับรถ" | mkV "ขับขี่" | mkV "ควบคุม" | mkV "บังคับ" | mkV "พยายาม" | mkV "ออกแรง" | mkV "กระตุ้น" | mkV "เดินทางโดยรถยนต์" ; -- src=panlex
lin drive_V = mkV "ขับ" | mkV "ตอก" | mkV "ขับรถ" | mkV "ไดรฟ์" | mkV "กระแทก" | mkV "ขับดัน" | mkV "ไล่ล่า" | mkV "กระทุ้ง" | mkV "ผลักดัน" | mkV "ล่าสัตว์" | mkV "ต้องการไป" | mkV "ขับเคลื่อน" | mkV "ทำงานขับรถ" | mkV "เป็นคนขับรถ" | mkV "ทำให้ถอยหลัง" | mkV "พยายามอย่างหนัก" | mkV "เป็นพนักงานขับรถ" | mkV "ขับ" | mkV "ขับรถ" | mkV "ขับขี่" | mkV "ควบคุม" | mkV "บังคับ" | mkV "พยายาม" | mkV "ออกแรง" | mkV "กระตุ้น" | mkV "เดินทางโดยรถยนต์" ; -- src=panlex
lin deal_V2 = mkV2 "ขาย" ; ---- | mkV "ดีล" | mkV "แจก" | mkV "จ่าย" | mkV "แบ่ง" | mkV "ค้าขาย" | mkV "จัดการ" | mkV "แจกไพ่" | mkV "แมนเนจ" | mkV "แจกจ่าย" | mkV "แบ่งปัน" | mkV "แบ่งให้" | mkV "ทำธุรกิจ" | mkV "แบ่งเค้ก" | mkV "มีเนื้อหา" | mkV "ทำจนสำเร็จ" | mkV "ปฏิบัติต่อ" | mkV "นำมาพิจารณา" | mkV "บริหารจัดการ" | mkV "แบ่งสรรปันส่วน" | mkV "ทํา" | mkV "กระทํา" | mkV "ค้าขาย" | mkV "จัดการ" | mkV "ทําตาม" | mkV "แจกไพ่" | mkV "ปฏิบัติ" | mkV "ประพฤติ" | mkV "จัดเตรียม" | mkV "ประสานงาน" | mkV "เตรียมการ" | mkV "ดําเนินงาน" | mkV "ปฏิบัติตัว" | mkV "ตกลงซื้อขาย" | mkV "ทําความตกลง" | mkV "ติดต่อธุรกิจ" | mkV "ทําการติดต่อ" ; -- src=panlex
lin deal_V = mkV "ขาย" | mkV "ดีล" | mkV "แจก" | mkV "จ่าย" | mkV "แบ่ง" | mkV "ค้าขาย" | mkV "จัดการ" | mkV "แจกไพ่" | mkV "แมนเนจ" | mkV "แจกจ่าย" | mkV "แบ่งปัน" | mkV "แบ่งให้" | mkV "ทำธุรกิจ" | mkV "แบ่งเค้ก" | mkV "มีเนื้อหา" | mkV "ทำจนสำเร็จ" | mkV "ปฏิบัติต่อ" | mkV "นำมาพิจารณา" | mkV "บริหารจัดการ" | mkV "แบ่งสรรปันส่วน" | mkV "ทํา" | mkV "กระทํา" | mkV "ค้าขาย" | mkV "จัดการ" | mkV "ทําตาม" | mkV "แจกไพ่" | mkV "ปฏิบัติ" | mkV "ประพฤติ" | mkV "จัดเตรียม" | mkV "ประสานงาน" | mkV "เตรียมการ" | mkV "ดําเนินงาน" | mkV "ปฏิบัติตัว" | mkV "ตกลงซื้อขาย" | mkV "ทําความตกลง" | mkV "ติดต่อธุรกิจ" | mkV "ทําการติดต่อ" ; -- src=panlex
lin place_V2 = variants{} ; -- 
lin approach_N = mkN "ทาง" | mkN "การดูด" | mkN "จู่โจม" | mkN "ทางเข้าออก" | mkN "การเข้าใกล้" | mkN "วิธีการเข้า-ออก" | mkN "ความใกล้เคียง" | mkN "เส้นทางร่อนลง" | mkN "การตีชอตแอปโพรช" | mkN "การบินเครื่องร่อน" | mkN "การเข้าใกล้" | mkN "ความคล้ายกัน" | mkN "สิ่งที่คล้ายกัน" | mkN "วิธีการทําให้ถึงจุดหมาย" ; -- src=panlex
lin chance_N = mkN "โชค" | mkN "โอกาส" | mkN "การเสี่ยง" | mkN "ความน่าจะเป็น" | mkN "ความเป็นไปได้" | mkN "โชค" | mkN "วาสนา" | mkN "หนทาง" | mkN "โอกาส" | mkN "ท่าทาง" | mkN "เสี่ยง" | mkN "ช่องทาง" | mkN "ยถากรรม" | mkN "เคราะห์" | mkN "การเสี่ยง" | mkN "ความเสี่ยง" | mkN "หนทางสําเร็จ" | mkN "ความน่าจะเป็น" | mkN "ความเป็นไปได้" | mkN "ลักษณะที่เป็นไปได้" ; -- src=panlex
lin application_N = mkN "การใช้" | mkN "โลชั่น" | mkN "ใบสมัคร" | mkN "ความอุตสาหะ" | mkN "แอพพลิเคชั่น" | mkN "โปรแกรมใช้งาน" | mkN "โปรแกรมประยุกต์" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "การขอ" | mkN "การทา" | mkN "การใช้" | mkN "ใบสมัคร" | mkN "การสมัคร" | mkN "การร้องขอ" | mkN "คําร้องขอ" | mkN "การประยุกต์" | mkN "การประยุกต์ใช้" | mkN "ความมีประโยชน์" | mkN "ความเกี่ยวข้อง" | mkN "ความสัมพันธ์กัน" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "ความสนใจอย่างใกล้ชิด" ; -- src=panlex
lin seek_VV = variants{}; -- mkV2 "หา" ;
lin seek_V2 = mkV2 "หา" ;
lin foreign_A = variants{} ; -- 
lin foreign_2_A = variants{} ; -- 
lin foreign_1_A = variants{} ; -- 
lin along_Prep = mkPrep "ตาม" | mkPrep "สาย" | mkPrep "ด้วยกัน" | mkPrep "ระหว่าง" | mkPrep "ไปข้างๆ" | mkPrep "คล้ายกับ" | mkPrep "ร่วมด้วย" | mkPrep "ขนานไปกับ" | mkPrep "คู่กันกับ" ; -- src=panlex
lin top_N = mkN "ยอด" | mkN "ฝาปิด" | mkN "ด้านบน" | mkN "ที่ปิด" | mkN "ยอดเขา" | mkN "ลูกข่าง" | mkN "ครึ่งแรก" | mkN "จุดสูงสุด" | mkN "ระดับสูงสุด" | mkN "เต็นท์ละครสัตว์" | mkN "เต็นท์คณะละครสัตว์" | mkN "บน" | mkN "ฝา" | mkN "ยอด" | mkN "หัว" | mkN "มุมบน" | mkN "เพิ่ม" | mkN "ข้างบน" | mkN "ดีเลิศ" | mkN "ด้านบน" | mkN "ติดตาม" | mkN "ที่ปิด" | mkN "ประทุน" | mkN "ส่วนบน" | mkN "หลังคา" | mkN "ชั้นนํา" | mkN "ลูกข่าง" | mkN "ไม้หมุน" | mkN "มีชัยชนะ" | mkN "หลังคารถ" | mkN "จุดสูงสุด" | mkN "ส่วนเริ่มต้น" | mkN "พื้นผิวด้านบน" | mkN "ตําแหน่งสูงสุด" | mkN "สูงสุดยอดเยี่ยม" | mkN "ส่วนที่ดีที่สุด" | mkN "ส่วนบนสุดของศีรษะ" | mkN "ตําแหน่งหน้าที่หรือคนในตําแหน่งหน้าที่ที่สูงสุด" ; -- src=panlex
lin amount_N = mkN "จำนวน" | mkN "ผลบวก" | mkN "ปริมาณ" | mkN "จำนวนเงิน" | mkN "จํานวน" | mkN "ปริมาณ" | mkN "ค่าเต็ม" | mkN "จํานวนรวม" | mkN "จํานวนเงิน" | mkN "รวมทั้งหมด" | mkN "มีค่าเท่ากับ" ; -- src=panlex
lin son_N = mkN "โอรส" | mkN "ลูกชาย" | mkN "กุลบุตร" | mkN "บุตรชาย" | mkN "พระโอรส" | mkN "ราชบุตร" | mkN "ราชโอรส" | mkN "บุตร" | mkN "ลูกชาย" | mkN "บุตรชาย" ; -- src=panlex
lin operation_N = mkN "การผ่าตัด" | mkN "ปฏิบัติการ" | mkN "กระบวนการคิด" | mkN "การดำเนินการ" | mkN "การประกอบการ" | mkN "กระบวนการผ่าตัด" | mkN "การดำเนินธุรกิจ" | mkN "ปฏิบัติการทางทหาร" | mkN "กระบวนการทางคณิตศาสตร์" | mkN "กิจการ" | mkN "การสู้รบ" | mkN "ศัลยกรรม" | mkN "การกระทํา" | mkN "การทํางาน" | mkN "การผ่าตัด" | mkN "ปฏิบัติการ" | mkN "การศัลยกรรม" | mkN "การดําเนินการ" | mkN "การเดินเครื่อง" | mkN "กิจการทางธุรกิจ" | mkN "วิธีการทางคณิตศาสตร์" ; -- src=panlex
lin fail_VV = mkVV "เสีย" ; ---- | mkV "ละเลย" | mkV "สอบตก" | mkV "ย่ำแย่" | mkV "ซ้ำชั้น" | mkV "ล้มเหลว" | mkV "ล้มละลาย" | mkV "ให้สอบตก" | mkV "ไม่สามารถ" | mkV "ไม่เพียงพอ" | mkV "ทำให้ผิดหวัง" | mkV "ไม่เป็นไปตามที่คาด" | mkV "ตก" | mkV "พัง" | mkV "เจ๊ง" | mkV "เสีย" | mkV "เหลว" | mkV "สอบตก" | mkV "ผิดพลาด" | mkV "ล้มเหลว" | mkV "ไม่ได้ผล" | mkV "้ผิดหวัง" | mkV "้สอบไม่ผ่าน" | mkV "เพลี่ยงพล้ํา" | mkV "ประสบความล้มเหลว" | mkV "ไม่ผ่านการพิจารณา" ; -- src=panlex
lin fail_V2 = mkV2 "เสีย" ; ---- | mkV "ละเลย" | mkV "สอบตก" | mkV "ย่ำแย่" | mkV "ซ้ำชั้น" | mkV "ล้มเหลว" | mkV "ล้มละลาย" | mkV "ให้สอบตก" | mkV "ไม่สามารถ" | mkV "ไม่เพียงพอ" | mkV "ทำให้ผิดหวัง" | mkV "ไม่เป็นไปตามที่คาด" | mkV "ตก" | mkV "พัง" | mkV "เจ๊ง" | mkV "เสีย" | mkV "เหลว" | mkV "สอบตก" | mkV "ผิดพลาด" | mkV "ล้มเหลว" | mkV "ไม่ได้ผล" | mkV "้ผิดหวัง" | mkV "้สอบไม่ผ่าน" | mkV "เพลี่ยงพล้ํา" | mkV "ประสบความล้มเหลว" | mkV "ไม่ผ่านการพิจารณา" ; -- src=panlex
lin fail_V = mkV "เสีย" | mkV "ละเลย" | mkV "สอบตก" | mkV "ย่ำแย่" | mkV "ซ้ำชั้น" | mkV "ล้มเหลว" | mkV "ล้มละลาย" | mkV "ให้สอบตก" | mkV "ไม่สามารถ" | mkV "ไม่เพียงพอ" | mkV "ทำให้ผิดหวัง" | mkV "ไม่เป็นไปตามที่คาด" | mkV "ตก" | mkV "พัง" | mkV "เจ๊ง" | mkV "เสีย" | mkV "เหลว" | mkV "สอบตก" | mkV "ผิดพลาด" | mkV "ล้มเหลว" | mkV "ไม่ได้ผล" | mkV "้ผิดหวัง" | mkV "้สอบไม่ผ่าน" | mkV "เพลี่ยงพล้ํา" | mkV "ประสบความล้มเหลว" | mkV "ไม่ผ่านการพิจารณา" ; -- src=panlex
lin human_A = mkA "มนุษย์" | mkA "ของมนุษย์" | mkA "เกี่ยวกับคน" | mkA "เห็นอกเห็นใจคน" | mkA "เกี่ยวกับมนุษย์" ; -- src=panlex
lin opportunity_N = mkN "โอกาส" | mkN "กาละ" | mkN "โอกาส" | mkN "จังหวะ" | mkN "โอกาสที่ดี" | mkN "จังหวะที่ดี" | mkN "" ; -- src=panlex
lin simple_A = mkA "เรียบง่าย" | mkA "เหมือนเด็ก" | mkA "โง่" | mkA "ง่าย" | mkA "ทึ่ม" | mkA "ปกติ" | mkA "ง่าย ๆ" | mkA "เซ่อ ๆ" | mkA "คนโง่" | mkA "สามัญ" | mkA "เรียบ" | mkA "คนเซ่อ" | mkA "ทั่วไป" | mkA "ธรรมดา" | mkA "เรียบๆ" | mkA "ชัดแจ้ง" | mkA "ถ่อมตัว" | mkA "พื้นฐาน" | mkA "สมองทึบ" | mkA "บริสุทธิ์" | mkA "เข้าใจยาก" | mkA "ไม่เจือปน" | mkA "ไม่ซับซ้อน" | mkA "ไม่ยุ่งยาก" | mkA "สิ่งที่ง่าย ๆ" | mkA "ซึ่งไม่เจือปน" | mkA "ไม่สลับซับซ้อน" | mkA "มีองค์ประกอบเดียว" | mkA "ซึ่งมีองค์ประกอบเดียว" | mkA "ไม่แบ่งออกเป็นส่วนต่าง ๆ" | mkA "ซึ่งประกอบด้วยธาตุเดียว" | mkA "ขาดประสบการณ์หรือความรู้" | mkA "ประกอบด้วยสารหรือธาตุเดียว" ; -- src=panlex
lin leader_N = mkN "ผู้นำ" | mkN "หัวหน้า" | mkN "ลีดเดอร์" | mkN "บทนํา" | mkN "ผู้นํา" | mkN "ท่อน้ํา" | mkN "หัวหน้า" | mkN "ผู้บัญชา" | mkN "ผู้สวดนํา" | mkN "เรื่องเอก" | mkN "นักร้องนํา" | mkN "ผู้นําวงดนตรี" ; -- src=panlex
lin look_N = mkN "กลิ่น" | mkN "การดู" | mkN "การมอง" | mkN "สีหน้า" | mkN "การมองดู" | mkN "การแสดงสีหน้า" | mkN "แบบ" | mkN "การดู" | mkN "การมอง" | mkN "ท่าทาง" | mkN "ลักษณะ" | mkN "สีหน้า" | mkN "แฟชั่น" | mkN "การค้นหา" | mkN "การมองดู" | mkN "สมัยนิยม" | mkN "การตรวจสอบ" | mkN "ลักษณะท่าทาง" | mkN "รูปร่างท่าทาง" | mkN "รูปร่างหน้าตา" ; -- src=panlex
lin share_N = mkN "หุ้น" | mkN "ใบมีดคันไถ" | mkN "ส่วน" | mkN "แบ่ง" | mkN "แบ่งสรร" | mkN "ร่วมส่วน" | mkN "ร่วมหุ้น" | mkN "ส่วนร่วม" | mkN "ส่วนแบ่ง" | mkN "หุ้นส่วน" | mkN "ส่วนหนึ่ง" | mkN "ร่วมกันทํา" | mkN "ร่วมกันรับ" | mkN "แบ่งเฉลี่ย" | mkN "ส่วนร่วมมือ" | mkN "ร่วมกันรับผิดชอบ" | mkN "ส่วนที่รับผิดชอบ" ; -- src=panlex
lin production_N = mkN "ผลผลิต" | mkN "การผลิต" | mkN "โปรดักต์" | mkN "ผลิตภัณฑ์" | mkN "โปรดักชั่น" | mkN "ปริมาณผลผลิต" | mkN "ปริมาณการผลิต" | mkN "ผลิตผล" | mkN "การผลิต" | mkN "การสร้าง" | mkN "ปริมาณที่ผลิตได้" | mkN "สิ่งที่ผลิตขึ้นมาได้" ; -- src=panlex
lin recent_A = mkA "เร็วๆ นี้" | mkA "เมื่อเร็ว ๆ นี้" | mkA "เมื่อไม่นาน" | mkA "ไม่นานมานี้" ; -- src=panlex
lin firm_N = mkN "บริษัท" | mkN "ห้างหุ้นส่วนจำกัด" | mkN "ธุรกิจ" | mkN "บริษัท" | mkN "ห้างหุ้นส่วน" ; -- src=panlex
lin picture_N = mkN "ภาพ" | mkN "รูป" | mkN "หนัง" | mkN "ภาพวาด" | mkN "รูปภาพ" | mkN "รูปวาด" | mkN "ภาพถ่าย" | mkN "รูปถ่าย" | mkN "จิตรกรรม" | mkN "ภาพยนตร์" | mkN "ภาพเขียน" | mkN "การพรรณนา" | mkN "ภาพจิตรกรรม" | mkN "ภาพ" | mkN "หนัง" | mkN "จอภาพ" | mkN "พรรณา" | mkN "นึกภาพ" | mkN "ภาพวาด" | mkN "รูปภาพ" | mkN "รูปวาด" | mkN "ภาพถ่าย" | mkN "ภาพพจน์" | mkN "แผ่นภาพ" | mkN "ตัวอย่าง" | mkN "ภาพยนตร์" | mkN "แบบอย่าง" | mkN "จินตนาการ" | mkN "นึกหลับตา" | mkN "ภาพอันสวย" | mkN "สถานการณ์" | mkN "ภาพจินตนาการ" | mkN "์ภาพความทรงจํา" | mkN "ถ่ายเป็นภาพยนตร์" | mkN "ถ้อยคําพรรณนาทําให้เห็นภาพ" | mkN "์คําบรรยายที่ทําให้เห็นภาพ" ; -- src=panlex
lin source_N = mkN "เชื้อ" | mkN "ต้นกำเนิด" | mkN "แหล่งข่าว" | mkN "ผู้ริเริ่ม" | mkN "เมล็ดพันธุ์" | mkN "แหล่งกำเนิด" | mkN "แหล่งข้อมูล" | mkN "หนังสืออ้างอิง" | mkN "ผู้มีความคิดริเริ่ม" | mkN "ที่มา" | mkN "แหล่ง" | mkN "ต้นกําเนิด" | mkN "แหล่งที่มา" | mkN "แหล่งข้อมูล" | mkN "ผู้ให้ข้อมูล" | mkN "แหล่งกําเนิด" ; -- src=panlex
lin security_N = mkN "ความมั่นคง" | mkN "การค้ำประกัน" | mkN "อุปกรณ์เตือนภัย" | mkN "ระบบรักษาความปลอดภัย" | mkN "แผนกรักษาความปลอดภัย" | mkN "สินทรัพย์ที่ใช้ค้ำประกัน" | mkN "ยาม" | mkN "หุ้น" | mkN "ธนบัตร" | mkN "คนรับรอง" | mkN "พันธบัตร" | mkN "การรับรอง" | mkN "สวัสดิภาพ" | mkN "การป้องกัน" | mkN "ความมั่นคง" | mkN "ความมั่นใจ" | mkN "หลักทรัพย์" | mkN "ความปลอดภัย" | mkN "ความไร้กังวล" | mkN "การค้ําประกัน" | mkN "ของค้ําประกัน" | mkN "ผู้ค้ําประกัน" | mkN "ระบบป้องกันภัย" | mkN "สิ่งคุ้มกันภัย" | mkN "สิ่งค้ําประกัน" | mkN "เครื่องป้องกัน" | mkN "ซึ่งค้ําประกัน. คําที่มีความ" | mkN "มาตราการป้องกัน" | mkN "หลักทรัพย์ประกัน" | mkN "ฝ่ายรักษาความปลอดภัย" | mkN "ระบบรักษาความปลอดภัย" | mkN "สิ่งที่ทําให้ปลอดภัย" | mkN "หลักทรัพย์ค้ําประกัน" | mkN "เจ้าหน้าที่รักษาความปลอดภัย" ; -- src=panlex
lin serve_V2 = mkV2 "เหมาะ" ; ---- | mkV "รับใช้" | mkV "เสิร์ฟ" | mkV "นำไปสู่" | mkV "สนับสนุน" | mkV "อุทิศตัว" | mkV "ทำหน้าที่" | mkV "ผสมพันธุ์" | mkV "อยู่ในคุก" | mkV "เสิร์ฟลูก" | mkV "รับใช้ชาติ" | mkV "รับใช้กองทัพ" | mkV "เข้าประจำการ" | mkV "เป็นประโยชน์" | mkV "ใช้เวลาในคุก" | mkV "ให้ความช่วยเหลือด้านอาหาร" | mkV "บริการ" | mkV "รับใช้" | mkV "มีประโยชน" | mkV "เสิร์ฟลูก" | mkV "ต้อนรับแขก" | mkV "มีประโยชน์" | mkV "คอยปรนนิบัติ" | mkV "ให้ความช่วยเหลือ" ; -- src=panlex
lin serve_V = mkV "เหมาะ" | mkV "รับใช้" | mkV "เสิร์ฟ" | mkV "นำไปสู่" | mkV "สนับสนุน" | mkV "อุทิศตัว" | mkV "ทำหน้าที่" | mkV "ผสมพันธุ์" | mkV "อยู่ในคุก" | mkV "เสิร์ฟลูก" | mkV "รับใช้ชาติ" | mkV "รับใช้กองทัพ" | mkV "เข้าประจำการ" | mkV "เป็นประโยชน์" | mkV "ใช้เวลาในคุก" | mkV "ให้ความช่วยเหลือด้านอาหาร" | mkV "บริการ" | mkV "รับใช้" | mkV "มีประโยชน" | mkV "เสิร์ฟลูก" | mkV "ต้อนรับแขก" | mkV "มีประโยชน์" | mkV "คอยปรนนิบัติ" | mkV "ให้ความช่วยเหลือ" ; -- src=panlex
lin according_to_Prep = variants{} ; -- 
lin end_V2 = mkV2 "จบ" ; ---- | mkV "ยุติ" | mkV "หยุด" | mkV "อวสาน" | mkV "สิ้นสุด" | mkV "ทำให้จบลง" | mkV "เป็นฉากจบ" | mkV "ทําให้จบ" | mkV "มีผลสรุป" | mkV "ทําให้เลิก" | mkV "ทําให้สิ้นสุด" ; -- src=panlex
lin end_V = mkV "จบ" | mkV "ยุติ" | mkV "หยุด" | mkV "อวสาน" | mkV "สิ้นสุด" | mkV "ทำให้จบลง" | mkV "เป็นฉากจบ" | mkV "ทําให้จบ" | mkV "มีผลสรุป" | mkV "ทําให้เลิก" | mkV "ทําให้สิ้นสุด" ; -- src=panlex
lin contract_N = mkN "สัญญา" | mkN "หนังสือสัญญา" | mkN "คอนแทร็คบริดจ์" | mkN "ติด" | mkN "ทํา" | mkN "ย่น" | mkN "ขมวด" | mkN "สัญญา" | mkN "เกร็ง" | mkN "คําย่อ" | mkN "ข้อตกลง" | mkN "การสัญญา" | mkN "หนังสือสัญญา" | mkN "นิติกรรมสัญญา" | mkN "การว่าจ้างเพื่อฆาตกรรม" ; -- src=panlex
lin wide_A = mkA (thword "กว้าง") | {-pan-} mkA "ห่าง" | mkA "กว้าง" | mkA "เบิกกว้าง" | mkA "ซึ่งไม่เข้าเป้า" | mkA "กว้างสุดลูกหูลูกตา" | mkA "ไกล" | mkA "ขยาย" | mkA "หลวม" | mkA "ห่าง" | mkA "กว้าง" | mkA "ไพศาล" | mkA "ใจกว้าง" | mkA "แพร่หลาย" | mkA "กว้างขวาง" ; -- src=panlex
lin occur_V = mkV "แวบ" | mkV "มีอยู่" | mkV "เกิดขึ้น" | mkV "มีอยู่" | mkV "อุบัติ" | mkV "บังเกิด" | mkV "เกิดขึ้น" | mkV "อุบัติขึ้น" | mkV "เข้ามาในจิตใจ" ; -- src=panlex
lin agreement_N = mkN "ข้อตกลง" | mkN "ความสอดคล้องกัน" | mkN "สัญญา" | mkN "การตกลง" | mkN "ข้อตกลง" | mkN "ความตกลง" | mkN "คําสัญญา" | mkN "ความเห็น ตรงกัน" | mkN "การยินยอม" | mkN "ความยินยอม" | mkN "การเห็นด้วย" | mkN "การเห็นพ้อง" | mkN "ความเห็นพ้อง" | mkN "หนังสือสัญญา" | mkN "การยอมรับร่วมกัน" | mkN "การเห็นชอบร่วมกัน" | mkN "ความสอดคล้องทางไวยากรณ์" | mkN "ความสอดคล้องระหว่างประธานและกริยา" ; -- src=panlex
lin better_Adv = mkAdv "ดี" | mkAdv "มาตรฐานหรือคุณภาพที่ดีกว่า" | mkAdv "เป็นที่ชอบหรือพึงพอใจมากกว่า" ; -- src=panlex
lin kill_V2 = mkV2 (thword "ฆ่า") ;
lin kill_V = mkV "ลบ" | mkV "กัด" | mkV "ฆ่า" | mkV "หวด" | mkV "ขจัด" | mkV "ทำลาย" | mkV "ขัดขวาง" | mkV "ดื่มหมด" | mkV "ทำให้ตาย" | mkV "คร่าชีวิต" | mkV "ดับเครื่อง" | mkV "ทำให้คลั่ง" | mkV "หวดเต็มแรง" | mkV "ตีสุดแรงเกิด" | mkV "ไม่ได้ตั้งใจ" | mkV "เหนื่อยแทบตาย" | mkV "เหนื่อยเจียนตาย" | mkV "เหนื่อยสายตัวแทบขาด" | mkV "ฆ่า" | mkV "มล้าง" | mkV "ฆ่าฟัน" | mkV "สังหาร" | mkV "ฆาตกรรม" | mkV "เข่นฆ่า" | mkV "ทําให้ตาย" | mkV "ประหัตประหาร" | mkV "เป็นเหตุให้ตาย" | mkV "ทําให้เสียชีวิต" | mkV "เป็นเหตุให้เสียชีวิต" ; -- src=panlex
lin act_V2 = mkV2 "ทำ" ; ---- | mkV "แสดง" | mkV "กระทำ" | mkV "ทำตัว" | mkV "รับบท" | mkV "ได้ผล" | mkV "เล่นบท" | mkV "ปฏิบัติ" | mkV "แกล้งทำ" | mkV "แสดงออก" | mkV "แสร้งทำ" | mkV "สวมบทบาท" | mkV "เล่นละคร" | mkV "แสดงเป็น" | mkV "ประพฤติตัว" | mkV "มีพฤติกรรม" | mkV "เคลื่อนไหว" | mkV "เล่นละครตบตา" | mkV "มีความประพฤติ" | mkV "แสดง" | mkV "รับบท" | mkV "ทําตัว" | mkV "วางตัว" | mkV "แสดงเป็น" | mkV "แสร้งทํา" | mkV "ประพฤติตน" | mkV "ปฏิบัติตัว" | mkV "เป็นเสมือน" | mkV "ทําหน้าที่เป็น" | mkV "ทําหน้าที่เสมือน" ; -- src=panlex
lin act_V = mkV "ทำ" | mkV "แสดง" | mkV "กระทำ" | mkV "ทำตัว" | mkV "รับบท" | mkV "ได้ผล" | mkV "เล่นบท" | mkV "ปฏิบัติ" | mkV "แกล้งทำ" | mkV "แสดงออก" | mkV "แสร้งทำ" | mkV "สวมบทบาท" | mkV "เล่นละคร" | mkV "แสดงเป็น" | mkV "ประพฤติตัว" | mkV "มีพฤติกรรม" | mkV "เคลื่อนไหว" | mkV "เล่นละครตบตา" | mkV "มีความประพฤติ" | mkV "แสดง" | mkV "รับบท" | mkV "ทําตัว" | mkV "วางตัว" | mkV "แสดงเป็น" | mkV "แสร้งทํา" | mkV "ประพฤติตน" | mkV "ปฏิบัติตัว" | mkV "เป็นเสมือน" | mkV "ทําหน้าที่เป็น" | mkV "ทําหน้าที่เสมือน" ; -- src=panlex
lin site_N = mkN "ทำเล" | mkN "เว็บ" | mkN "ไซต์" | mkN "ที่ตั้ง" | mkN "เว็บไซต์" | mkN "อินเตอร์เน็ตไซต์" | mkN "จุด" | mkN "ติดตั้ง" | mkN "ที่ตั้ง" | mkN "สถานที่" | mkN "ไซต์งาน" | mkN "ตําแหน่ง" | mkN "ที่ทําเล" | mkN "ประจําอยู่" | mkN "แปลงที่ดิน" | mkN "สถานที่ตั้ง" | mkN "เอาไปตั้งไว้" | mkN "แหล่งที่ตั้ง" | mkN "สถานที่เกิดเหตุการณ์" ; -- src=panlex
lin either_Adv = mkAdv "ด้วย" | mkAdv "เช่นกัน" | mkAdv "เหมือนกัน" | mkAdv "เช่นเดียวกัน" ; -- src=panlex
lin labour_N = mkN "งานหนัก" | mkN "กรรมาชีพ" | mkN "งานกรรมกร" | mkN "งานใช้แรง" | mkN "การคลอดบุตร" | mkN "งานใช้แรงกาย" | mkN "ชนชั้นกรรมาชีพ" | mkN "ความเจ็บปวดในการคลอดบุตร" | mkN "งาน" | mkN "ภาระ" | mkN "กรรมกร" | mkN "หน้าที่" | mkN "ชนชั้นแรงงาน" | mkN "งานที่ต้องออกแรง" | mkN "งานที่ใช้พละกําลัง" ; -- src=panlex
lin plan_VV = mkVV "แพลน" ; ---- | mkV "ดีไซน์" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "วางแพลน" | mkV "คิดวางแผน" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "กะแผนการ" | mkV "วางแผนงาน" | mkV "วางโครงการ" | mkV "เขียนแบบแปลน" ; -- src=panlex
lin plan_VS = mmkVS "แพลน" ; ---- | mkV "ดีไซน์" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "วางแพลน" | mkV "คิดวางแผน" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "กะแผนการ" | mkV "วางแผนงาน" | mkV "วางโครงการ" | mkV "เขียนแบบแปลน" ; -- src=panlex
lin plan_V2V = mmkV2V "แพลน" ; ---- | mkV "ดีไซน์" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "วางแพลน" | mkV "คิดวางแผน" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "กะแผนการ" | mkV "วางแผนงาน" | mkV "วางโครงการ" | mkV "เขียนแบบแปลน" ; -- src=panlex
lin plan_V2 = mkV2 "แพลน" ; ---- | mkV "ดีไซน์" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "วางแพลน" | mkV "คิดวางแผน" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "กะแผนการ" | mkV "วางแผนงาน" | mkV "วางโครงการ" | mkV "เขียนแบบแปลน" ; -- src=panlex
lin plan_V = mkV "แพลน" | mkV "ดีไซน์" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "วางแพลน" | mkV "คิดวางแผน" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "กะแผนการ" | mkV "วางแผนงาน" | mkV "วางโครงการ" | mkV "เขียนแบบแปลน" ; -- src=panlex
lin various_A = mkA "ซึ่งแตกต่างกัน" | mkA "ต่าง ๆ กัน" | mkA "มากมาย" | mkA "สารพัด" | mkA "ต่างชนิด" | mkA "หลากหลาย" | mkA "ต่างประเภท" | mkA "หลายลักษณะ" | mkA "ซึ่งแตกต่างกัน" ; -- src=panlex
lin since_Prep = mkPrep "เมื่อ" | mkPrep "ตั้งแต่" | mkPrep "ในเมื่อ" | mkPrep "เนื่องจาก" | mkPrep "เนื่องด้วย" | mkPrep "โดยเหตุที่" | mkPrep "นับตั้งแต่นั้นมา" ; -- src=panlex
lin test_N = mkN "เทสต์" | mkN "การสอบ" | mkN "ข้อสอบ" | mkN "การผ่านบททดสอบ" | mkN "การทดสอบสติปัญญา" | mkN "การทดสอบระดับสติปัญญา" | mkN "ข้อสอบ" | mkN "การทดสอบ" | mkN "แบบทดสอบ" | mkN "การตรวจสอบ" | mkN "วิธีที่ใช้ในการทดสอบ" | mkN "คําถามหรือปัญหาที่ใช้ในการทดสอบ" | mkN "เหตุการณ์ที่เป็นเครื่องพิสูจน์บุคคล" | mkN "เหตุการณ์ที่พิสูจน์คุณสมบัติของบุคคล" ; -- src=panlex
lin eat_V2 = mkV2 (thword "กิน") ;
lin eat_V = mkV "กัด" | mkV "กิน" | mkV "ฉัน" | mkV "ซัด" | mkV "ทาน" | mkV "แดก" | mkV "ใช้" | mkV "เสวย" | mkV "รับประทาน" | mkV "ทำให้กร่อน" | mkV "ทำให้กังวล" | mkV "กิน" | mkV "ทาน" | mkV "กร่อน" | mkV "กัดกิน" | mkV "ทําลาย" | mkV "กัดกร่อน" | mkV "รับประทาน" ; -- src=panlex
lin loss_N = mkN "ตัวแดง" | mkN "สิ้นใจ" | mkN "การจากไป" | mkN "การพ่ายแพ้" | mkN "การสูญเสีย" | mkN "เงินขาดทุน" | mkN "การด้อยโอกาส" | mkN "การเสียชีวิต" | mkN "การถึงแก่กรรม" | mkN "ความด้อยโอกาส" | mkN "การลดลงของจำนวน" | mkN "การสูญเสียกำลังพล" | mkN "ทรัพย์สินที่สูญหาย" | mkN "การหาย" | mkN "การแพ้" | mkN "การเสีย" | mkN "การขาดทุน" | mkN "การทําลาย" | mkN "ความหายนะ" | mkN "การสูญเสีย" | mkN "ความผิดพลาด" | mkN "ความสูญเสีย" | mkN "ความเสียหาย" | mkN "ภาวะที่งงงวย" | mkN "การสูญเสียทหาร" | mkN "ภาวะที่ไม่แน่นอน" | mkN "จํานวนทหารที่สูญเสียไป" | mkN "จํานวนของสิ่งที่เสียหาย" ; -- src=panlex
lin close_V2 = mkV2 (mkV "ปิด") ;
lin close_V = mkV "ปิด" | mkV "อุด" | mkV "โคลส" | mkV "ปิดฉาก" | mkV "ปิดเกม" | mkV "โอบกอด" | mkV "ปิดกิจการ" | mkV "ประจันหน้า" | mkV "นำเข้ามาใกล้" | mkV "จบ" | mkV "ปิด" | mkV "หับ" | mkV "ทําให้จบ" ; -- src=panlex
lin represent_V2 = mkV2 "นำเสนอ" ; ---- | mkV "วาดภาพ" | mkV "อธิบาย" | mkV "เล่นบท" | mkV "แก้ต่าง" | mkV "สวมบทบาท" | mkV "เป็นตัวแทน" | mkV "แสดงละครเวที" | mkV "ประกอบขึ้นเป็น" | mkV "ใช้เป็นสัญลักษณ์" | mkV "แสดง" | mkV "ทําแทน" | mkV "อธิบาย" | mkV "เป็นตัวแทน" | mkV "แสดงให้เห็น" | mkV "ทําหน้าที่แทน" | mkV "เป็นสัญลักษณ์ของ" | mkV "เป็นเครื่องหมายของ" ; -- src=panlex
lin represent_V = mkV "นำเสนอ" | mkV "วาดภาพ" | mkV "อธิบาย" | mkV "เล่นบท" | mkV "แก้ต่าง" | mkV "สวมบทบาท" | mkV "เป็นตัวแทน" | mkV "แสดงละครเวที" | mkV "ประกอบขึ้นเป็น" | mkV "ใช้เป็นสัญลักษณ์" | mkV "แสดง" | mkV "ทําแทน" | mkV "อธิบาย" | mkV "เป็นตัวแทน" | mkV "แสดงให้เห็น" | mkV "ทําหน้าที่แทน" | mkV "เป็นสัญลักษณ์ของ" | mkV "เป็นเครื่องหมายของ" ; -- src=panlex
lin love_VV = variants{}; -- mkV2 rak_s ;
lin love_V2 = mkV2 rak_s ;
lin colour_N = mkN "สี" | mkN "สีสัน" | mkN "เสียงดนตรี" | mkN "ความมีสีสัน" | mkN "กลุ่มคนผิวสี" | mkN "วัตถุที่ให้สี" | mkN "ธง" | mkN "สี" | mkN "สารสี" | mkN "สีสัน" | mkN "สีย้อม" | mkN "เม็ดสี" | mkN "ข้ออ้าง" | mkN "ความสดใส" | mkN "รงควัตถุ" | mkN "คุณลักษณะ" | mkN "สีสันต่างๆ" | mkN "ความมีสีสัน" | mkN "คุณภาพเสียง" | mkN "คํากล่าวอ้าง" | mkN "ลักษณะภายนอก" | mkN "ศิลปะการใช้สี" | mkN "ความมีชีวิตชีวา" | mkN "คุณภาพที่เด่นชัด" | mkN "ใบหน้ามีเลือดฝาด" | mkN "สีผิวที่มีสุขภาพดี" | mkN "สีผิวของชนที่ไม่ใช่คนผิวขาว" | mkN "ใบหน้าที่มีสีแดงเพราะสุขภาพดี" ; -- src=panlex
lin clearly_Adv = variants{} ; -- 
lin shop_N = placeN (thword "ร้าน" "ค้า") | {-pan-} mkN "ร้าน" | mkN "โรงงาน" | mkN "ร้านค้า" | mkN "ร้าน" | mkN "อาชีพ" | mkN "การงาน" | mkN "ร้านค้า" | mkN "โรงซ่อม" | mkN "ร้านเล็ก ๆ" | mkN "ที่ทํางาน" | mkN "สํานักงาน" | mkN "โรงฝึกงาน" | mkN "ห้องทํางาน" | mkN "โรงงานเล็ก" | mkN "ร้านขายปลีก" ; -- src=panlex
lin benefit_N = mkN "สวัสดิการ" | mkN "ผลประโยชน์" | mkN "คุณงามความดี" | mkN "ผลประโยชน์" | mkN "ข้อได้เปรียบ" | mkN "เงินช่วยเหลือ" | mkN "เงินสงเคราะห์" | mkN "เงินส่วนเพิ่ม" | mkN "เงินชดเชยการประกัน" | mkN "การแสดงเพื่อการกุศล" | mkN "การแข่งขันเพื่อการกุศล" | mkN "เงินที่ได้จากประกันชีวิต" ; -- src=panlex
lin animal_N = animalN (thword "สัตว์") | {-pan-} mkN "สัตว์" | mkN "สัตว์ป่า" | mkN "เดียรัจฉาน" | mkN "สิ่งมีชีวิต" | mkN "สัตว์เดียรัจฉาน" | mkN "สัตว์" | mkN "คนที่หยาบคาย" | mkN "คนที่คล้ายสัตว์" | mkN "สัตว์เลี้ยงลูกด้วยนม" | mkN "คนที่โหดร้ายทารุณคล้ายสัตว์" ; -- src=panlex
lin heart_N = mkN (thword "ใจ") | {-pan-} mkN "ใจ" | mkN "จิต" | mkN "สาระ" | mkN "แก่น" | mkN "จิตใจ" | mkN "หัวใจ" | mkN "โพแดง" | mkN "พระกมล" | mkN "เนื้อๆ" | mkN "ใจกลาง" | mkN "ความรัก" | mkN "พระหทัย" | mkN "เนื้อหา" | mkN "พระหฤทัย" | mkN "รูปหัวใจ" | mkN "ไพ่โพแดง" | mkN "ศูนย์กลาง" | mkN "ความกล้าหาญ" | mkN "ความรักใคร่" | mkN "แก่นความคิด" | mkN "มน" | mkN "แด" | mkN "ใจ" | mkN "มโน" | mkN "ฤดี" | mkN "ไส้" | mkN "มนัส" | mkN "ฤทัย" | mkN "หทัย" | mkN "แก่น" | mkN "จิตใจ" | mkN "หฤทัย" | mkN "หัวใจ" | mkN "หน้าอก" | mkN "ใจกลาง" | mkN "ความรัก" | mkN "ไพ่โพแดง" | mkN "จุดสําคัญ" | mkN "สุขภาพจิต" | mkN "ส่วนในสุด" | mkN "ความรู้สึก" | mkN "ความเอ็นดู" | mkN "ส่วนสําคัญ" | mkN "ความกล้าหาญ" | mkN "ส่วนลึกของจิตใจ" | mkN "สิ่งที่เป็นรูปหัวใจ" ; -- src=panlex
lin election_N = mkN "การคัดเลือก" | mkN "การเลือกตั้ง" | mkN "ตัวที่เลือกแล้ว" | mkN "การเลือก" | mkN "การคัดสรร" | mkN "การคัดเลือก" | mkN "การเลือกตั้ง" | mkN "สิทธิการเลือกตั้ง" | mkN "การเลือกโดยพระผู้เป็นเจ้า" ; -- src=panlex
lin purpose_N = mkN "จุดประสงค์" | mkN "ความมุ่งมั่น" | mkN "ผล" | mkN "เจตนา" | mkN "ผลประ-โยชน์" | mkN "ประสงค์" | mkN "มีเจตนา" | mkN "หน้าที่" | mkN "เป้าหมาย" | mkN "จุดประสงค์" | mkN "ความต้องการ" | mkN "ความประสงค์" | mkN "ความปรารถนา" | mkN "ความมุ่งหมาย" | mkN "ตั้งเป้าหมาย" | mkN "วัตถุประสงค์" | mkN "ความมุ่งประสงค์" ; -- src=panlex
lin standard_N = mkN "มาตรฐาน" | mkN "บรรทัดฐาน" | mkN "มาตรฐานเงินตรา" | mkN "มาตรฐาน" | mkN "ตัวชี้วัด" | mkN "บรรทัดฐาน" ; -- src=panlex
lin due_A = mkA "ตรง" | mkA "หนี้" | mkA "พร้อม" | mkA "พอควร" | mkA "สมควร" | mkA "ถูกต้อง" | mkA "พอเพียง" | mkA "เหมาะสม" | mkA "ได้เวลา" | mkA "ครบกําหนด" | mkA "ถึงกําหนด" | mkA "ที่เป็นหนี้" | mkA "ค่าธรรมเนียม" | mkA "ที่ค้างชําระ" | mkA "ยังไม่ได้จ่าย" | mkA "เงินที่พึงชําระ" | mkA "ตามกําหนดถึงเวลา" | mkA "ถูกทํานองคลองธรรม" ; -- src=panlex
lin secretary_N = mkN "เลขา" | mkN "รัฐมนตรี" | mkN "เลขานุการ" | mkN "โต๊ะเขียนหนังสือ" | mkN "เจ้าหน้าที่เลขานุการ" | mkN "เพื่อนที่รักษาความลับ" | mkN "รัฐมนตรี" | mkN "เลขาธิการ" | mkN "เลขานุการ" | mkN "โต๊ะเขียน" | mkN "ผู้ทําหนังสือ" | mkN "เลขานุการส่วนตัว" | mkN "ตําแหน่งเลขานุการ" | mkN "เจ้าหน้าที่ระดับสูง" | mkN "เจ้าหน้าที่ชั้นผู้ใหญ่ของรัฐ" | mkN "โต๊ะหนังสือที่มีลิ้นชักและตู้หนังสือ" ; -- src=panlex
lin rise_V2 = mkV2 "ชู" ; ---- | mkV "ยืน" | mkV "ขึ้น" | mkV "ตื่น" | mkV "ก่อกบฏ" | mkV "คืนชีพ" | mkV "ขึ้นสู่" | mkV "ตื่นนอน" | mkV "ลุกขึ้น" | mkV "เริ่มต้น" | mkV "ก่อการกบฏ" | mkV "ตื่นบรรทม" | mkV "เพิ่มขี้น" | mkV "ขึ้นอันดับ" | mkV "ฟื้นคืนชีพ" | mkV "เคลื่อนขึ้น" | mkV "โผล่จากพื้น" | mkV "ตื่นพระบรรทม" | mkV "เพิ่มสูงขึ้น" | mkV "กบฏ" | mkV "ขึ้น" | mkV "ปรากฏ" | mkV "ลุกฮือ" | mkV "กําเนิด" | mkV "ผุดขึ้น" | mkV "ยืนขึ้น" | mkV "ลุกขึ้น" | mkV "สูงขึ้น" | mkV "ตื่นขึ้น" | mkV "เริ่มต้น" | mkV "เจริญขึ้น" | mkV "เพิ่มขึ้น" | mkV "เลื่อนขึ้น" | mkV "เจริญเติบโต" | mkV "ยุติการประชุม" | mkV "ลุกขึ้นต่อสู้" | mkV "เลื่อนสถานะขึ้น" ; -- src=panlex
lin rise_V = mkV "ชู" | mkV "ยืน" | mkV "ขึ้น" | mkV "ตื่น" | mkV "ก่อกบฏ" | mkV "คืนชีพ" | mkV "ขึ้นสู่" | mkV "ตื่นนอน" | mkV "ลุกขึ้น" | mkV "เริ่มต้น" | mkV "ก่อการกบฏ" | mkV "ตื่นบรรทม" | mkV "เพิ่มขี้น" | mkV "ขึ้นอันดับ" | mkV "ฟื้นคืนชีพ" | mkV "เคลื่อนขึ้น" | mkV "โผล่จากพื้น" | mkV "ตื่นพระบรรทม" | mkV "เพิ่มสูงขึ้น" | mkV "กบฏ" | mkV "ขึ้น" | mkV "ปรากฏ" | mkV "ลุกฮือ" | mkV "กําเนิด" | mkV "ผุดขึ้น" | mkV "ยืนขึ้น" | mkV "ลุกขึ้น" | mkV "สูงขึ้น" | mkV "ตื่นขึ้น" | mkV "เริ่มต้น" | mkV "เจริญขึ้น" | mkV "เพิ่มขึ้น" | mkV "เลื่อนขึ้น" | mkV "เจริญเติบโต" | mkV "ยุติการประชุม" | mkV "ลุกขึ้นต่อสู้" | mkV "เลื่อนสถานะขึ้น" ; -- src=panlex
lin date_N = variants{} ; -- 
lin date_7_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_1_N = variants{} ; -- 
lin hard_A = variants{} ; -- 
lin hard_2_A = variants{} ; -- 
lin hard_1_A = variants{} ; -- 
lin music_N = mkN (thword "ดน" "ตรี") | {-pan-} mkN "เพลง" | mkN "ดนตรี" | mkN "มิวสิค" | mkN "เสียงเพลง" | mkN "เสียงดนตรี" | mkN "เสียงไพเราะ" | mkN "การเล่นดนตรี" | mkN "การแสดงดนตรี" | mkN "การบรรเลงดนตรี" | mkN "เพลง" | mkN "ดนตรี" | mkN "ดนตรี่" | mkN "โน้ตเพลง" | mkN "เสียงเพลง" | mkN "เสียงดนตรี" | mkN "การแต่งเพลง" | mkN "เสียงไพเราะ" | mkN "เสียงที่น่าฟัง" | mkN "เสียงที่ไพเราะ" | mkN "การเรียบเรียงเพลง" | mkN "การแต่งทํานองเพลง" | mkN "การแต่งทํานองดนตรี" ; -- src=panlex ----?
lin hair_N = mkN (thword "ผม") | {-pan-} mkN "ขน" | mkN "เส้นผม" | mkN "พระโลมา" | mkN "เส้นยาแดงผ่าแปด" | mkN "ขน" | mkN "ผม" | mkN "เศษ" | mkN "เส้นขน" | mkN "เส้นผม" | mkN "ผ้าขนสัตว์" | mkN "ขนาดเล็กมาก" | mkN "จํานวนน้อยมาก" ; -- src=panlex
lin prepare_VV = mkVV "ฝึก" ; ---- | mkV "เทรน" | mkV "เตรียม" | mkV "ทำอาหาร" | mkV "จัดเตรียม" | mkV "ทำกับข้าว" | mkV "เตรียมตัว" | mkV "ประกอบอาหาร" | mkV "เตรียมอาหาร" | mkV "วางแผนรัดกุม" | mkV "เตรียม" | mkV "จัดเตรียม" | mkV "ตระเตรียม" | mkV "เตรียมตัว" | mkV "เตรียมพร้อม" | mkV "เตรียมอาหาร" | mkV "วางแผนล่วงหน้า" ; -- src=panlex
lin prepare_V2V = mmkV2V "ฝึก" ; ---- | mkV "เทรน" | mkV "เตรียม" | mkV "ทำอาหาร" | mkV "จัดเตรียม" | mkV "ทำกับข้าว" | mkV "เตรียมตัว" | mkV "ประกอบอาหาร" | mkV "เตรียมอาหาร" | mkV "วางแผนรัดกุม" | mkV "เตรียม" | mkV "จัดเตรียม" | mkV "ตระเตรียม" | mkV "เตรียมตัว" | mkV "เตรียมพร้อม" | mkV "เตรียมอาหาร" | mkV "วางแผนล่วงหน้า" ; -- src=panlex
lin prepare_V2 = mkV2 "ฝึก" ; ---- | mkV "เทรน" | mkV "เตรียม" | mkV "ทำอาหาร" | mkV "จัดเตรียม" | mkV "ทำกับข้าว" | mkV "เตรียมตัว" | mkV "ประกอบอาหาร" | mkV "เตรียมอาหาร" | mkV "วางแผนรัดกุม" | mkV "เตรียม" | mkV "จัดเตรียม" | mkV "ตระเตรียม" | mkV "เตรียมตัว" | mkV "เตรียมพร้อม" | mkV "เตรียมอาหาร" | mkV "วางแผนล่วงหน้า" ; -- src=panlex
lin prepare_V = mkV "ฝึก" | mkV "เทรน" | mkV "เตรียม" | mkV "ทำอาหาร" | mkV "จัดเตรียม" | mkV "ทำกับข้าว" | mkV "เตรียมตัว" | mkV "ประกอบอาหาร" | mkV "เตรียมอาหาร" | mkV "วางแผนรัดกุม" | mkV "เตรียม" | mkV "จัดเตรียม" | mkV "ตระเตรียม" | mkV "เตรียมตัว" | mkV "เตรียมพร้อม" | mkV "เตรียมอาหาร" | mkV "วางแผนล่วงหน้า" ; -- src=panlex
lin factor_N = mkN "ยีน" | mkN "นายหน้า" | mkN "เอเยนต์" | mkN "แฟกเตอร์" | mkN "ตัวประกอบ" | mkN "องค์ประกอบ" | mkN "กรณี" | mkN "เหตุ" | mkN "ตัวคูณ" | mkN "ตัวหาร" | mkN "ปัจจัย" | mkN "ตัวประกอบ" | mkN "ระดับต่างๆ ในระบบที่ใช้วัดมาตรฐาน" | mkN "ปัจจัยที่ทําให้เกิดผลหรือมีอิทธิพลต่อสิ่งต่างๆ" ; -- src=panlex
lin other_A = mkA "อื่น" | {-pan-} mkA "ก่อน" | mkA "อีก" | mkA "อื่นๆ" | mkA "มากกว่า" | mkA "อะไรอีก" | mkA "อันก่อน" | mkA "อื่นอีก" | mkA "ต่างไปกว่า" | mkA "แตกต่างกัน" | mkA "จํานวนพิเศษ" | mkA "ไม่เหมือนกัน" | mkA "เมื่อวานซืนนี้)" ; -- src=panlex
lin anyone_NP = variants{} ; -- 
lin pattern_N = mkN "แม่แบบ" | mkN "แบบอย่าง" | mkN "พิมพ์เขียว" | mkN "กระสวนการบิน" | mkN "รูปแบบการบิน" | mkN "งานออกแบบลวดลาย" | mkN "รูปทรง" | mkN "รูปแบบ" | mkN "ลวดลาย" | mkN "แบบแผน" | mkN "รูปร่าง" | mkN "แบบฉบับ" | mkN "งานศิลป์" | mkN "แบบพิมพ์" | mkN "ธรรมเนียม" | mkN "ประเพณีนิยม" | mkN "จารีตประเพณี" | mkN "ธรรมเนียมปฏิบัติ" | mkN "แบบสําหรับก่อสร้าง" ; -- src=panlex
lin manage_VV = mkVV "จัดการ" ; ---- | mkV "แมนเนจ" | mkV "ทำสำเร็จ" | mkV "กวัดแกว่ง" | mkV "ทำจนสำเร็จ" | mkV "บริหารจัดการ" | mkV "ดำเนินการจนสำเร็จ" | mkV "จัด" | mkV "ถือ" | mkV "ดูแล" | mkV "ควบคุม" | mkV "จัดการ" | mkV "บริหาร" | mkV "ปกครอง" | mkV "ปฏิบัติ" | mkV "สําเร็จ" | mkV "พลิกแพลง" | mkV "มีอิทธิพลต่อ" | mkV "ทําได้สําเร็จ" | mkV "ทําให้เกิดขึ้น" | mkV "จัดการได้สําเร็จ" | mkV "ประสบความสําเร็จ" | mkV "หาทางทําจนสําเร็จ" ; -- src=panlex
lin manage_V2 = mkV2 "จัดการ" ; ---- | mkV "แมนเนจ" | mkV "ทำสำเร็จ" | mkV "กวัดแกว่ง" | mkV "ทำจนสำเร็จ" | mkV "บริหารจัดการ" | mkV "ดำเนินการจนสำเร็จ" | mkV "จัด" | mkV "ถือ" | mkV "ดูแล" | mkV "ควบคุม" | mkV "จัดการ" | mkV "บริหาร" | mkV "ปกครอง" | mkV "ปฏิบัติ" | mkV "สําเร็จ" | mkV "พลิกแพลง" | mkV "มีอิทธิพลต่อ" | mkV "ทําได้สําเร็จ" | mkV "ทําให้เกิดขึ้น" | mkV "จัดการได้สําเร็จ" | mkV "ประสบความสําเร็จ" | mkV "หาทางทําจนสําเร็จ" ; -- src=panlex
lin manage_V = mkV "จัดการ" | mkV "แมนเนจ" | mkV "ทำสำเร็จ" | mkV "กวัดแกว่ง" | mkV "ทำจนสำเร็จ" | mkV "บริหารจัดการ" | mkV "ดำเนินการจนสำเร็จ" | mkV "จัด" | mkV "ถือ" | mkV "ดูแล" | mkV "ควบคุม" | mkV "จัดการ" | mkV "บริหาร" | mkV "ปกครอง" | mkV "ปฏิบัติ" | mkV "สําเร็จ" | mkV "พลิกแพลง" | mkV "มีอิทธิพลต่อ" | mkV "ทําได้สําเร็จ" | mkV "ทําให้เกิดขึ้น" | mkV "จัดการได้สําเร็จ" | mkV "ประสบความสําเร็จ" | mkV "หาทางทําจนสําเร็จ" ; -- src=panlex
lin piece_N = mkN "ชิ้น" | mkN "ส่วน" | mkN "ปืนพก" | mkN "ผลงาน" | mkN "บทเพลง" | mkN "ชิ้นงาน" | mkN "ตัวหมาก" | mkN "ชิ้นส่วน" | mkN "ชิ้นเล็กๆ" | mkN "ปะ" | mkN "กอง" | mkN "ตอน" | mkN "ต่อ" | mkN "ปืน" | mkN "ผืน" | mkN "พับ" | mkN "อัน" | mkN "ก้อน" | mkN "ชิ้น" | mkN "ท่อน" | mkN "ม้วน" | mkN "สิ่ง" | mkN "ส่วน" | mkN "เพลง" | mkN "แผ่น" | mkN "ผลงาน" | mkN "อย่าง" | mkN "บทความ" | mkN "รายการ" | mkN "ซ่อมแซม" | mkN "ปืนใหญ่" | mkN "ระยะทาง" | mkN "ส่วนหนึ่ง" | mkN "ตัวหมากรุก" | mkN "ปืนของทหาร" | mkN "เงินเหรียญ" | mkN "เหรียญกษาปณ์" | mkN "บทประพันธ์เพลง" | mkN "ระยะทางช่วงสั้นๆ" | mkN "เรื่องในหนังสือพิมพ์" ; -- src=panlex
lin discuss_VS = variants{} ; -- 
lin discuss_V2 = variants{} ; -- 
lin prove_VS = mmkVS "ขึ้น" ; ---- | mkV "ทดสอบ" | mkV "ยืนยัน" | mkV "พิสูจน์" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "ตรวจสอบ" | mkV "พิสูจน์" ; -- src=panlex
lin prove_VA = mmkVA "ขึ้น" ; ---- | mkV "ทดสอบ" | mkV "ยืนยัน" | mkV "พิสูจน์" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "ตรวจสอบ" | mkV "พิสูจน์" ; -- src=panlex
lin prove_V2 = mkV2 "ขึ้น" ; ---- | mkV "ทดสอบ" | mkV "ยืนยัน" | mkV "พิสูจน์" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "ตรวจสอบ" | mkV "พิสูจน์" ; -- src=panlex
lin prove_V = mkV "ขึ้น" | mkV "ทดสอบ" | mkV "ยืนยัน" | mkV "พิสูจน์" | mkV "แสดงหลักฐาน" | mkV "แสดงให้เห็น" | mkV "ตรวจสอบ" | mkV "พิสูจน์" ; -- src=panlex
lin front_N = mkN "แนวหน้า" | mkN "ด้านหน้า" | mkN "แนวปะทะอากาศ" | mkN "ขบวนการทางสังคม" | mkN "ขบวนการเคลื่อนไหวทางสังคม" | mkN "หน้า" | mkN "รับมือ" | mkN "ต่อต้าน" | mkN "แถวหน้า" | mkN "ข้างหน้า" | mkN "ด้านหน้า" | mkN "ส่วนหน้า" | mkN "เผชิญหน้า" ; -- src=panlex
lin evening_N = mkN "ตอนเย็น" | mkN "ค่ำ" | mkN "ตอนค่ํา" | mkN "ตอนเย็น" | mkN "สายัณห์" | mkN "ตอนเย็นๆ" | mkN "เย็นย่ํา" | mkN "เวลาเย็น" | mkN "ตอนกลางคืน" | mkN "ช่วงสุดท้าย" | mkN "ระยะที่เสื่อมลงของชีวิต" ; -- src=panlex
lin royal_A = mkA "เกี่ยวกับราชวงศ์" | mkA "ดีเลิศ" | mkA "มโหฬาร" | mkA "ใหญ่โต" | mkA "ชั้นหนึ่ง" | mkA "เกี่ยวกับ" | mkA "ชั้นเยี่ยม" | mkA "เกี่ยวกับราชวงศ์" | mkA "เกี่ยวกับกษัตริย์" | mkA "เกี่ยวกับราชสํานัก" ; -- src=panlex
lin tree_N = mkN (thword "ต้น" "ไม้") | {-pan-} mkN "ต้น" | mkN "ไม้" | mkN "ต้นไม้" | mkN "รุกขชาติ" | mkN "ทรีไดอะแกรม" | mkN "แผนภูมิต้นไม้" | mkN "วน" | mkN "ต้น" | mkN "เฌอ" | mkN "ไม้" | mkN "พฤกษา" | mkN "รุกขะ" | mkN "ต้นไม้" | mkN "ต้นไม้ยืนต้น" | mkN "แผนผังรูปต้นไม้" ; -- src=panlex ----?
lin population_N = mkN "ประชากร" | mkN "สถิติประชากร" | mkN "ราษฎร" | mkN "ประชากร" | mkN "พลเมือง" | mkN "จํานวนทั้งหมด" | mkN "จํานวนประชากร" | mkN "การนําผู้คนเข้าไปตั้งรกราก" | mkN "กลุ่มพืชและสัตว์ที่อาศัยอยู่ในบริเวณหนึ่ง" ; -- src=panlex
lin fine_A = mkA "โอ" | mkA "โอเค" | mkA "ละเอียด" | mkA "ดี" | mkA "งาม" | mkA "บาง" | mkA "วิเศษ" | mkA "ชวนมอง" | mkA "ชั้นดี" | mkA "ดีเลิศ" | mkA "ประณีต" | mkA "สวยงาม" | mkA "แบบบาง" | mkA "น่าพอใจ" | mkA "ละเอียด" | mkA "สุขสบาย" | mkA "ดีเยี่ยม" | mkA "พอใช้ได้" | mkA "เรียวบาง" | mkA "ละเอียดลออ" | mkA "ท้องฟ้าสดใส" | mkA "อากาศแจ่มใส" ; -- src=panlex
lin plant_N = mkN "พืช" | mkN "โรงงาน" | mkN "พฤกษชาติ" | mkN "โรงงานอุตสาหกรรม" | mkN "ฝัง" | mkN "พืช" | mkN "ตั้ง" | mkN "ปลูก" | mkN "แทรก" | mkN "สร้าง" | mkN "ต้นไม้" | mkN "ปักวาง" | mkN "โรงงาน" | mkN "การเกษตร" | mkN "การกสิกรรม" | mkN "เพาะเลี้ยง" | mkN "การเพาะปลูก" | mkN "เครื่องจักร" | mkN "เครื่องมือครบชุด" | mkN "โรงงานอุตสาหกรรม" | mkN "สิ่งหรือคนหลอกลวง" | mkN "อุปกรณ์ติดตั้งทั้งหมด" ; -- src=panlex
lin pressure_N = mkN "การกด" | mkN "แรงดัน" | mkN "ความกดอากาศ" | mkN "ความดันบรรยากาศ" | mkN "อัด" | mkN "กดดัน" | mkN "การกด" | mkN "การอัด" | mkN "การรบกวน" | mkN "การเบียด" | mkN "แรงกดดัน" | mkN "ความกดดัน" | mkN "บีบบังคับ" | mkN "การบีบคั้น" | mkN "แรงกระตุ้น" | mkN "ความกดอากาศ" | mkN "การบีบบังคับ" | mkN "แรงกดบนพื้นผิว" | mkN "ความกดดันของบรรยากาศ" ; -- src=panlex
lin response_N = mkN "คำตอบ" | mkN "การพูดตอบ" | mkN "การตอบสนอง" | mkN "ผลตอบ" | mkN "การตอบ" | mkN "คําตอบ" | mkN "คํารับ" | mkN "การขานรับ" | mkN "การโต้ตอบ" | mkN "การตอบสนอง" | mkN "ความรู้สึกตอบ" ; -- src=panlex
lin catch_V2 = variants{} ; -- 
lin street_N = mkN "ถนน" | mkN "คนในซอย" | mkN "ถนน" | mkN "ทางหลัก" | mkN "ถนนหนทาง" | mkN "ทางสําคัญ" | mkN "ตึกอาคารตามถนน" | mkN "คนที่ทํางานหรืออาศัยอยู่ตามถนน" ; -- src=panlex
lin pick_V2 = mkV2 "ฉก" ; ---- | mkV "ตี" | mkV "คัด" | mkV "จิก" | mkV "ดีด" | mkV "ชำระ" | mkV "หยิบ" | mkV "เก็บ" | mkV "เฟ้น" | mkV "ตำหนิ" | mkV "ถอนขน" | mkV "จับผิด" | mkV "ยั่วยุ" | mkV "คัดเลือก" | mkV "กินนิดหน่อย" | mkV "ตีด้วยพลั่ว" | mkV "ขุด" | mkV "คัด" | mkV "สรร" | mkV "แทะ" | mkV "เจาะ" | mkV "เลือก" | mkV "หาเรื่อง" ; -- src=panlex
lin pick_V = mkV "ฉก" | mkV "ตี" | mkV "คัด" | mkV "จิก" | mkV "ดีด" | mkV "ชำระ" | mkV "หยิบ" | mkV "เก็บ" | mkV "เฟ้น" | mkV "ตำหนิ" | mkV "ถอนขน" | mkV "จับผิด" | mkV "ยั่วยุ" | mkV "คัดเลือก" | mkV "กินนิดหน่อย" | mkV "ตีด้วยพลั่ว" | mkV "ขุด" | mkV "คัด" | mkV "สรร" | mkV "แทะ" | mkV "เจาะ" | mkV "เลือก" | mkV "หาเรื่อง" ; -- src=panlex
lin performance_N = variants{} ; -- 
lin performance_2_N = variants{} ; -- 
lin performance_1_N = variants{} ; -- 
lin knowledge_N = mkN "ความรู้" | mkN "ข่าว" | mkN "ภูมิ" | mkN "ความรู้" | mkN "การเข้าใจ" | mkN "ความสามารถ" | mkN "ความเข้าใจ" | mkN "ความคุ้นเคย" | mkN "ความตระหนัก" ; -- src=panlex
lin despite_Prep = mkPrep "การดูหมิ่น" | mkPrep "จะอย่างไรก็ตาม" | mkPrep "ถึงอย่างไรก็ตาม" ; -- src=panlex
lin design_N = mkN "การคิด" | mkN "แผนการ" | mkN "แม่แบบ" | mkN "โครงร่าง" | mkN "การดีไซน์" | mkN "การออกแบบ" | mkN "จุดประสงค์" | mkN "พิมพ์เขียว" | mkN "งานออกแบบลวดลาย" | mkN "ลาย" | mkN "แบบ" | mkN "ลวดลาย" | mkN "แผนการ" | mkN "ภาพร่าง" | mkN "แบบบ้าน" | mkN "โครงการ" | mkN "งานศิลป์" | mkN "เป้าหมาย" | mkN "การออกแบบ" | mkN "ความตั้งใจ" | mkN "จุดประสงค์" | mkN "พิมพ์เขียว" | mkN "การประดิษฐ์" | mkN "ความมุ่งมั่น" | mkN "การสร้างสรรค์" ; -- src=panlex
lin page_N = mkN "หน้า" | mkN "หน้าหนังสือ" | mkN "คนรับใช้อัศวิน" | mkN "ใบ" | mkN "หน้า" | mkN "แผ่น" | mkN "พลิกหน้า คนรับใช้" | mkN "หน้ากระดาษ" | mkN "หน้าหนังสือ" | mkN "เด็กรับใช้ที่เป็นผู้ชาย" | mkN "คนหนุ่มที่ได้รับการฝึกให้เป็นอัศวิน" ; -- src=panlex
lin enjoy_VV = variants{} ; -- 
lin enjoy_V2 = variants{} ; -- 
lin individual_N = mkN "คน" | mkN "บุคคล" | mkN "ปัจเจกชน" | mkN "ปัจเจกบุคคล" | mkN "คน ๆ เดียว" | mkN "บุคคล" | mkN "ส่วนตัว" | mkN "ตัวบุคคล" | mkN "ปัจเจกชน" | mkN "เฉพาะราย" | mkN "ตัวต่อตัว" | mkN "ส่วนบุคคล" | mkN "โดยลําพัง" | mkN "สิ่งมีชีวิตเดียว" ; -- src=panlex
lin suppose_VS = variants{} ; -- 
lin suppose_V2 = variants{} ; -- 
lin rest_N = mkN "ตัวหยุด" | mkN "การพักผ่อน" | mkN "เวลาหยุดพัก" | mkN "ส่วนที่เหลือ" | mkN "พัก อาศัย" | mkN "นั่ง" | mkN "หลับ" | mkN "วางบน" | mkN "ไว้ใจ" | mkN "การตาย" | mkN "การพัก" | mkN "ที่พัก" | mkN "นอนพัก" | mkN "การหยุด" | mkN "ความตาย" | mkN "ที่ค้ํา" | mkN "ส่วนอื่น" | mkN "หยุดนิ่ง" | mkN "ช่วงเงียบ" | mkN "การนิ่งเฉย" | mkN "การพักผ่อน" | mkN "จังหวะหยุด" | mkN "ที่พักผ่อน" | mkN "ส่วนที่เหลือ" | mkN "ที่สําหรับพัก" | mkN "การหยุดชั่วขณะ" | mkN "ส่วนที่เป็นกไร" | mkN "ส่วนที่เหลือหลังการหักค่าใช้จ่าย" ; -- src=panlex
lin instead_Adv = mkAdv "แทน" | mkAdv "อีกทางหนึ่ง" | mkAdv "อย่างมีทางเลือก" | mkAdv "แทน" | mkAdv "แทนที่" ; -- src=panlex
lin wear_V2 = mkV2 "มี" ; ---- | mkV "สวม" | mkV "ใส่" | mkV "สวมใส่" | mkV "เป็นรอย" | mkV "เหนื่อย" | mkV "แสดงให้เห็น" | mkV "เหน็ดเหนื่อย" | mkV "แตกเป็นเสี่ยง" | mkV "เผยอารมณ์ให้เห็นบนใบหน้า" | mkV "ติด" | mkV "สวม" | mkV "ใส่" | mkV "นุ่ง" | mkV "ประดับ" | mkV "สวมใส่" | mkV "เผยสีหน้า" | mkV "แสดงสีหน้า" | mkV "เผยอารมณ์ให้เห็นบนใบหน้า" ; -- src=panlex
lin wear_V = mkV "มี" | mkV "สวม" | mkV "ใส่" | mkV "สวมใส่" | mkV "เป็นรอย" | mkV "เหนื่อย" | mkV "แสดงให้เห็น" | mkV "เหน็ดเหนื่อย" | mkV "แตกเป็นเสี่ยง" | mkV "เผยอารมณ์ให้เห็นบนใบหน้า" | mkV "ติด" | mkV "สวม" | mkV "ใส่" | mkV "นุ่ง" | mkV "ประดับ" | mkV "สวมใส่" | mkV "เผยสีหน้า" | mkV "แสดงสีหน้า" | mkV "เผยอารมณ์ให้เห็นบนใบหน้า" ; -- src=panlex
lin basis_N = mkN "ฐาน" | mkN "รากฐาน" | mkN "พื้นฐาน" | mkN "หลัก" | mkN "รากฐาน" | mkN "พื้นฐาน" | mkN "มาตรฐาน" | mkN "หลักเกณฑ์" | mkN "ส่วนสําคัญ" | mkN "หลักสําคัญ" | mkN "จุดเริ่มต้น" | mkN "หลักพื้นฐาน" | mkN "ฐานปฏิบัติการ" | mkN "ส่วนประกอบหลัก" ; -- src=panlex
lin size_N = mkN "ขนาด" | mkN "ไซส์" | mkN "ขนาด" | mkN "ขนาดใหญ่" ; -- src=panlex
lin environment_N = mkN "สภาพแวดล้อม" | mkN "สิ่งแวดล้อม" | mkN "สภาวะแวดล้อม" | mkN "การโอบล้อม" | mkN "สภาพแวดล้อม" | mkN "สิ่งแวดล้อม" | mkN "สภาวะแวดล้อม" | mkN "สิ่งที่หุ้มห่อ" | mkN "ภาวะสิ่งแวดล้อม" | mkN "ภาวะที่ถูกหุ้มห่อ" ; -- src=panlex
lin per_Prep = mkPrep "ตาม" | mkPrep "ต่อ" | mkPrep "ทาง" | mkPrep "ทุก" | mkPrep "โดย" | mkPrep "ผ่าน" | mkPrep "อาศัย" | mkPrep "แต่ละ" | mkPrep "ตามที่" | mkPrep "โดยทาง" | mkPrep "โดยผ่านทาง" | mkPrep "ด้วยวิธีการ" ; -- src=panlex
lin fire_N = mkN (thword "ไฟ") ;
lin fire_2_N = variants{} ; -- 
lin fire_1_N = variants{} ; -- 
lin series_N = mkN "ชุด" | mkN "ซีรีย์" | mkN "ซีรีส์" | mkN "อนุกรม" | mkN "หนังสือที่ตีพิมพ์เป็นฉบับ" | mkN "ลําดับ" | mkN "อนุกรม" | mkN "ชุดของสิ่งของ" | mkN "อนุกรมเลขหมาย" | mkN "กลุ่มของสิ่งของ" | mkN "สิ่งที่ต่อเนื่องกัน" | mkN "ลําดับในวิชาคณิตศาสตร์" | mkN "สิ่งตีพิมพ์ที่ออกเป็นวาระ" ; -- src=panlex
lin success_N = mkN "ซัคเซส" | mkN "ความสำเร็จ" | mkN "การบรรลุความสำเร็จ" | mkN "ผู้ประสบความสำเร็จ" | mkN "ชัยชนะ" | mkN "ผลสําเร็จ" | mkN "ความสําเร็จ" | mkN "การประสบผลสําเร็จ" | mkN "ผู้ประสบผลสําเร็จ" | mkN "การประสบความสําเร็จ" | mkN "ผู้ได้รับความสําเร็จ" | mkN "สิ่งที่ประสบความสําเร็จ" | mkN "บุคคลที่ประสบความสําเร็จ" ; -- src=panlex
lin natural_A = mkA "ดิบ" | mkA "ธรรมชาติ" | mkA "เนเจอรัล" | mkA "โดยกำเนิด" | mkA "ตั้งแต่เกิด" | mkA "ตามธรรมชาติ" | mkA "ทางธรรมชาติ" | mkA "เป็นธรรมชาติ" | mkA "ธรรมดา" | mkA "เป็นปกติ" | mkA "ตามธรรมชาติ" | mkA "โดยธรรมชาติ" | mkA "เป็นธรรมชาติ" | mkA "ีเกี่ยวกับธรรมชาติ" ; -- src=panlex
lin wrong_A = mkA "ผิด" | mkA "ซึ่งไม่ถูกต้อง" | mkA "ซึ่งมีข้อผิดพลาด" | mkA "ผิด" | mkA "ผิดปกติ" | mkA "ผิดพลาด" | mkA "ไม่ถูกต้อง" ; -- src=panlex
lin near_Prep = variants{} ; -- 
lin round_Adv = variants{}; -- mkPrep "รอบๆ" ; -- src=panlex
lin thought_N = mkN "การคิด" | mkN "ไอเดีย" | mkN "ความคิด" | mkN "ความเห็น" | mkN "ความคิดเห็น" | mkN "ปัญญา" | mkN "ความคิด" | mkN "การรําพึง" | mkN "การพิจารณา" | mkN "ความนึกคิด" | mkN "การไตร่ตรอง" | mkN "ความสามารถในการคิด" ; -- src=panlex
lin list_N = mkN "บัญชี" | mkN "ลิสต์" | mkN "รายการ" | mkN "รายนาม" | mkN "รายชื่อ" | mkN "ท่าเอียง" | mkN "บัญชีรายการ" | mkN "บัญชีรายชื่อ" | mkN "ขอบ" | mkN "ริม" | mkN "แถบ" | mkN "บัญชี" | mkN "ขอบผ้า" | mkN "รายการ" | mkN "สารบัญ" | mkN "รายชื่อ" | mkN "กระดานไม้" | mkN "บัญชีรายชื่อ" | mkN "ไม้ที่ตัดเป็นแผ่นๆ" | mkN "การเอียงไปข้างหนึ่ง" ; -- src=panlex
lin argue_VS = mmkVS "โต้เถียง" ; ---- | mkV "เสนอเหตุผลโต้แย้ง" | mkV "เถียง" | mkV "อภิปราย" | mkV "โต้แย้ง" | mkV "โต้เถียง" | mkV "ให้เหตุผล" | mkV "อ้างเหตุผล" ; -- src=panlex
lin argue_V2 = mkV2 "โต้เถียง" ; ---- | mkV "เสนอเหตุผลโต้แย้ง" | mkV "เถียง" | mkV "อภิปราย" | mkV "โต้แย้ง" | mkV "โต้เถียง" | mkV "ให้เหตุผล" | mkV "อ้างเหตุผล" ; -- src=panlex
lin argue_V = mkV "โต้เถียง" | mkV "เสนอเหตุผลโต้แย้ง" | mkV "เถียง" | mkV "อภิปราย" | mkV "โต้แย้ง" | mkV "โต้เถียง" | mkV "ให้เหตุผล" | mkV "อ้างเหตุผล" ; -- src=panlex
lin final_A = mkA "สุดท้าย" | mkA "ตอนจบ" | mkA "สุดท้าย" | mkA "เด็ดขาด" | mkA "ในที่สุด" | mkA "ที่สิ้นสุด" | mkA "ขั้นสุดท้าย" ; -- src=panlex
lin future_N = variants{} ; -- 
lin future_3_N = variants{} ; -- 
lin future_1_N = variants{} ; -- 
lin introduce_V2 = variants{} ; -- 
lin analysis_N = mkN "การวิเคราะห์" | mkN "จิตวิเคราะห์" | mkN "การวิภาค" | mkN "การแยกธาตุ" | mkN "การพิเคราะห์" | mkN "การวิเคราะห์" | mkN "จิตวิเคราะห์" | mkN "ผลการวิเคราะห์" | mkN "การจําแนกแยกแยะ" | mkN "การวิเคราะห์ทางจิตใจ" | mkN "การนํามาแยกเป็นส่วนๆ เพื่อพิจารณาในประเด็นต่างๆ" ; -- src=panlex
lin enter_V2 = mkV2 "สอด" ; ---- | mkV "ใส่" | mkV "เข้า" | mkV "บันทึก" | mkV "เข้ามา" | mkV "เขียนลง" | mkV "บันทึกลง" | mkV "เข้าไปใน" | mkV "ลงทะเบียน" | mkV "รับตำแหน่ง" | mkV "สอด" | mkV "แทง" | mkV "ยื่น" | mkV "ร่วม" | mkV "เข้า" | mkV "เสนอ" | mkV "เริ่ม" | mkV "เข้ามา" | mkV "เข้าไป" | mkV "เข้าสู่" | mkV "เข้าร่วม" | mkV "ลงทะเบียน" | mkV "เป็นสมาชิก" | mkV "สมัครเข้าเป็น" | mkV "เข้าไปมีส่วนร่วม" | mkV "บันทึกลงไปในหนังสือ" | mkV "ใส่ข้อมูลลงในคอมพิวเตอร์" | mkV "นําขึ้นเสนออย่างเป็นทางการ" ; -- src=panlex
lin enter_V = mkV "สอด" | mkV "ใส่" | mkV "เข้า" | mkV "บันทึก" | mkV "เข้ามา" | mkV "เขียนลง" | mkV "บันทึกลง" | mkV "เข้าไปใน" | mkV "ลงทะเบียน" | mkV "รับตำแหน่ง" | mkV "สอด" | mkV "แทง" | mkV "ยื่น" | mkV "ร่วม" | mkV "เข้า" | mkV "เสนอ" | mkV "เริ่ม" | mkV "เข้ามา" | mkV "เข้าไป" | mkV "เข้าสู่" | mkV "เข้าร่วม" | mkV "ลงทะเบียน" | mkV "เป็นสมาชิก" | mkV "สมัครเข้าเป็น" | mkV "เข้าไปมีส่วนร่วม" | mkV "บันทึกลงไปในหนังสือ" | mkV "ใส่ข้อมูลลงในคอมพิวเตอร์" | mkV "นําขึ้นเสนออย่างเป็นทางการ" ; -- src=panlex
lin space_N = mkN "สเปซ" | mkN "อวกาศ" | mkN "ช่องไฟ" | mkN "ที่ว่าง" | mkN "พื้นที่" | mkN "ช่วงเวลา" | mkN "ช่องว่าง" | mkN "เว้นวรรค" | mkN "ช่วง" | mkN "ระยะ" | mkN "อวกาศ" | mkN "ที่ว่าง" | mkN "ระยะทาง" | mkN "ที่นั่ง ช่องว่างระหว่างบรรทัด" | mkN "ช่องว่าง" | mkN "ระยะช่อง" | mkN "ระยะห่าง" | mkN "ระยะเวลา" | mkN "เว้นระยะ" | mkN "หน้ากระดาษ" | mkN "พื้นที่ว่าง" | mkN "ที่ว่างเปล่า" | mkN "เกี่ยวกับอวกาศ" | mkN "เว้นช่องบรรทัด" ; -- src=panlex
lin arrive_V = mkV "มาถึง" | mkV "ทำสำเร็จ" | mkV "มาถึงความสำเร็จ" | mkV "ถึง" | mkV "ลุุ" | mkV "เกิด" | mkV "บรรลุ" | mkV "ปรากฏ" | mkV "มาถึง" | mkV "มีใช้" | mkV "เริ่ม" | mkV "ส่งถึง" | mkV "กําเนิด" | mkV "เริ่มต้น" | mkV "หาทางออกได้" | mkV "แก้ปัญหาได้" ; -- src=panlex
lin ensure_VS = mmkVS "ดู" ; ---- | mkV "ตรวจ" | mkV "เช็ก" | mkV "ตรวจดู" | mkV "ตรวจเช็ก" | mkV "ทำให้แน่ใจ" | mkV "ทําให้แน่ใจ" ; -- src=panlex
lin ensure_V2 = mkV2 "ดู" ; ---- | mkV "ตรวจ" | mkV "เช็ก" | mkV "ตรวจดู" | mkV "ตรวจเช็ก" | mkV "ทำให้แน่ใจ" | mkV "ทําให้แน่ใจ" ; -- src=panlex
lin ensure_V = mkV "ดู" | mkV "ตรวจ" | mkV "เช็ก" | mkV "ตรวจดู" | mkV "ตรวจเช็ก" | mkV "ทำให้แน่ใจ" | mkV "ทําให้แน่ใจ" ; -- src=panlex
lin demand_N = mkN "อุปสงค์" | mkN "ความต้องการ" | mkN "ความปรารถนา" | mkN "การเรียกร้อง" | mkN "ถาม" | mkN "ขอทราบ" | mkN "อุปสงค์" | mkN "เรียกร้อง" | mkN "ความต้องการ" | mkN "ปริมาณที่ต้องการซื้อ" | mkN "ความต้องการซื้อและอํานาจซื้อ" ; -- src=panlex
lin statement_N = mkN "ข้อความ" | mkN "การยืนยัน" | mkN "ข้อความสั่ง" | mkN "งบดุล" | mkN "การแถลง" | mkN "คําแถลง" | mkN "ถ้อยแถลง" | mkN "การบรรยาย" | mkN "แถลงการณ์" | mkN "บัญชีการเงิน" | mkN "รายงานการเงิน" ; -- src=panlex
lin to_Adv = mkAdv "ถึง" | mkAdv "ให้" | mkAdv "จนถึง" | mkAdv "เพื่อ" | mkAdv "ไปถึง" | mkAdv "ไปยัง" | mkAdv "ตรงกันกับ" ; -- src=panlex
lin attention_N = mkN "การดูแล" | mkN "ความสนใจ" | mkN "การตั้งใจ" | mkN "การช่วยเหลือ" | mkN "การดูแลรักษา" | mkN "การยืนระวังตรง" | mkN "การดูแลเอาใจใส่" | mkN "ความตั้งอกตั้งใจ" | mkN "การดูแล" | mkN "ความสนใจ" | mkN "การพิจารณา" | mkN "ความตั้งใจ" | mkN "การเอาใจใส่" | mkN "การคํานึงถึง" | mkN "การเอาอกเอาใจ" | mkN "คําสั่งให้ยืนตรง" | mkN "การปฏิบัติที่สมควร" | mkN "การรักษาที่เหมาะสม" | mkN "การพิจารณาอย่างสนใจ" | mkN "การกระทําอย่างรักใคร่" ; -- src=panlex
lin love_N = mkN (thword "ความ" rak_s) | {-pan-} mkN "เลิฟ" | mkN "ที่รัก" | mkN "ความรัก" | mkN "ความใคร่" | mkN "ชีวิตรัก" | mkN "บุคคลอันเป็นที่รักยิ่ง" | mkN "สนใจ" | mkN "คนรัก" | mkN "ใจชอบ" | mkN "คู่รัก" | mkN "ยอดรัก" | mkN "ความชอบ" | mkN "ความรัก" | mkN "ชื่นชอบ" | mkN "ความพอใจ" | mkN "ความเสน่หา" ; -- src=panlex
lin principle_N = mkN "กฎ" | mkN "หลัก" | mkN "กฎ" | mkN "หลัก" | mkN "ทฤษฎี" | mkN "ลัทธิ" | mkN "สาเหตุ" | mkN "ศีลธรรม" | mkN "หลักการ" | mkN "ข้อปฏิบัติ" | mkN "แหล่งที่มา" | mkN "หลักปฏิบัติ" | mkN "หลักศีลธรรม" | mkN "องค์ประกอบที่สําคัญ" ; -- src=panlex
lin pull_V2 = mkV2 (thword "ดึง") ;
lin pull_V = mkV "ตี" | mkV "ฉีก" | mkV "ดึง" | mkV "ถอน" | mkV "พาย" | mkV "ยืด" | mkV "ลาก" | mkV "กระทำ" | mkV "ถอนขน" | mkV "นำทาง" | mkV "กินเลน" | mkV "ดึงดูด" | mkV "ปลอบใจ" | mkV "เอาออกไป" | mkV "ขับกินเลน" | mkV "เป็นแรงส่ง" | mkV "อยู่เคียงข้าง" | mkV "ชักสายบังเหียน" | mkV "ดึง" | mkV "ลาก" | mkV "กระชาก" | mkV "ชักอาวุธออกมา" ; -- src=panlex
lin set_N = variants{} ; -- 
lin set_2_N = variants{} ; -- 
lin set_1_N = variants{} ; -- 
lin doctor_N = mkN "หมอ" "คน" | {-pan-} mkN "ดร." | mkN "หมอ" | mkN "แพทย์" | mkN "ด็อกเตอร์" | mkN "หมอฝึกหัด" | mkN "แพทย์ฝึกหัด" | mkN "การเล่นเป็นหมอ" | mkN "คนเรียนจบปริญญาเอก" | mkN "ผู้เรียนจบปริญญาเอก" | mkN "ผู้จบการศึกษาระดับปริญญาเอก" | mkN "หมอ" | mkN "แพทย์" | mkN "ดุษฎีบัณฑิต" | mkN "ผู้ได้รับปริญญาเอก" ; -- src=panlex
lin choice_N = mkN "ชอยซ์" | mkN "ออปชั่น" | mkN "การเลือก" | mkN "ตัวเลือก" | mkN "ทางเลือก" | mkN "การเลือก" | mkN "คัดเลือก" | mkN "ตัวเลือก" | mkN "ทางเลือก" | mkN "เด่นที่สุด" | mkN "ความพิถีพิถัน" | mkN "ผู้ที่ถูกเลือก" | mkN "สิ่งที่ถูกเลือก" | mkN "ส่วนที่ดีที่สุด" | mkN "ซึ่งเลือกสรรแล้ว" | mkN "ส่วนประกอบที่ดีที่สุด" ; -- src=panlex
lin refer_V2 = mkV2 "อ้าง" ; ---- | mkV "หมายถึง" | mkV "อ้างอิง" | mkV "หาข้อมูล" | mkV "เกี่ยวข้อง" | mkV "ค้นหา" | mkV "พาดพิง" | mkV "อ้างถึง" | mkV "อ้างอิง" | mkV "กล่าวถึง" | mkV "เกี่ยวโยงไปถึง" ; -- src=panlex
lin refer_V = mkV "อ้าง" | mkV "หมายถึง" | mkV "อ้างอิง" | mkV "หาข้อมูล" | mkV "เกี่ยวข้อง" | mkV "ค้นหา" | mkV "พาดพิง" | mkV "อ้างถึง" | mkV "อ้างอิง" | mkV "กล่าวถึง" | mkV "เกี่ยวโยงไปถึง" ; -- src=panlex
lin feature_N = mkN "บทความ" | mkN "ลักษณะ" | mkN "รายการภาพยนตร์" | mkN "ส่วนประกอบใบหน้า" | mkN "รูป" | mkN "หน้าตา" | mkN "รูปหน้า" | mkN "ภาพยนตร์" | mkN "ทําให้เด่น" | mkN "ภูมิประเทศ" | mkN "บทความพิเศษ" | mkN "ลักษณะเฉพาะ" | mkN "สารคดีพิเศษ" | mkN "ลักษณะหน้าตา" | mkN "เค้าโครงหน้า" | mkN "รูปพรรณสัณฐาน" | mkN "ลักษณะโฉมหน้า" | mkN "เป็นลักษณะสําคัญ" ; -- src=panlex
lin couple_N = mkN "คู่" | mkN "ผัวเมีย" | mkN "คู่ชีวิต" | mkN "แรงคู่ควบ" | mkN "จำนวนน้อยๆ" | mkN "คู่สามีภรรยา" | mkN "คู่เหมือนกัน" | mkN "คู่ผัวตัวเมีย" | mkN "คู่สามีภรรยา" | mkN "สองสิ่งที่คล้ายกัน" | mkN "สิ่งที่เชื่อมติดกัน" | mkN "คนสองคนที่ทําบางสิ่งบางอย่างร่วมกัน" ; -- src=panlex
lin step_N = mkN "ก้าว" | mkN "รอยเท้า" | mkN "ขั้นบันได" | mkN "การก้าวเท้า" | mkN "เสียงฝีเท้า" | mkN "ระยะหนึ่งเสียงเต็ม" | mkN "ก้าว" | mkN "ขั้น" | mkN "ชั้น" | mkN "ฐานะ" | mkN "ระดับ" | mkN "จังหวะ" | mkN "ฝีเท้า" | mkN "เดินบน" | mkN "เหยียบ" | mkN "ก้าววัด" | mkN "มาตรการ" | mkN "วิธีการ" | mkN "เต้นรํา" | mkN "ช่วงสั้น" | mkN "ตําแหน่ง" | mkN "ย่างก้าว" | mkN "ระยะสั้น" | mkN "ขั้นบันได" | mkN "ธรณีประตู" | mkN "เสียงก้าว" | mkN "แผ่นเหยียบ" | mkN "แท่นตั้งเสา" | mkN "จังหวะเต้นรํา" | mkN "ตั้งเสาบนแท่น -" | mkN "ก้าวเป็นจังหวะ" | mkN "ท่าทางในการก้าว" ; -- src=panlex
lin following_A = mkA "ถัดมา" | mkA "ที่ตามมา" | mkA "ที่ตามหลัง" | mkA "ต่อมา" | mkA "ถัดมา" | mkA "ถัดไป" | mkA "ที่ตามมาทีหลัง" | mkA "ที่จะกล่าวต่อไป" | mkA "เป็นอันดับต่อมา" ; -- src=panlex
lin thank_V2 = variants{} ; -- 
lin machine_N = mkN "รถ" | mkN "จักรกล" | mkN "รถยนต์" | mkN "แมชชีน" | mkN "เครื่อง" | mkN "เครื่องกล" | mkN "เครื่องจักร" | mkN "เครื่องผ่อนแรง" | mkN "ตัวจักรทางการเมือง" | mkN "กลไก" | mkN "จักร" | mkN "อุปกรณ์" | mkN "เครื่อง" | mkN "เครื่องจักร" | mkN "เครื่องยนต์" | mkN "การปฏิบัติงาน" | mkN "ระบบการทํางาน" | mkN "ระบบที่ซับซ้อน" | mkN "ระบบการปฎิบัติงาน" | mkN "เตรียมด้วยเครื่อง" | mkN "องค์กรที่เป็นกลไกสําคัญ" ; -- src=panlex
lin income_N = mkN "รายได้" | mkN "อินคัม" | mkN "รายรับ" | mkN "รายได้" | mkN "เงินได้" | mkN "การเข้ามา" | mkN "สิ่งที่เพิ่มเข้ามา" ; -- src=panlex
lin training_N = mkN "การอบรม" | mkN "การศึกษา" | mkN "การฝึก" | mkN "การอบรม" | mkN "การฝึกฝน" | mkN "การฝึกหัด" ; -- src=panlex
lin present_V2 = variants{} ; -- 
lin association_N = mkN "สมาคม" | mkN "การรวมตัว" | mkN "การเชื่อมโยง" | mkN "ความสัมพันธ์" | mkN "กลุ่มพืชและสัตว์" | mkN "กลุ่ม" | mkN "สมาคม" | mkN "สหภาพ" | mkN "บริษัท" | mkN "การรวมกัน" | mkN "เกมฟุตบอล" | mkN "การร่วมกัน" | mkN "การสังสรรค์" | mkN "ความสัมพันธ์" | mkN "การเชื่อมติดกัน" | mkN "สันนิบาตพันธมิตร" | mkN "ความคิดเห็นร่วมกัน" | mkN "ความคิดที่เชื่อมโยง" | mkN "ความเห็นที่เชื่อมโยง" | mkN "กลุ่มของพืชที่อยู่ร่วมกัน" ; -- src=panlex
lin film_N = variants{} ; -- 
lin film_2_N = variants{} ; -- 
lin film_1_N = variants{} ; -- 
lin region_N = mkN "ส่วน" | mkN "บริเวณ" | mkN "ภูมิภาค" | mkN "แถบ" | mkN "ส่วน" | mkN "แคว้น" | mkN "ขอบเขต" | mkN "ดินแดน" | mkN "บริเวณ" | mkN "ปริมณฑล" | mkN "ภูมิภาค" | mkN "เขตการปกครอง" ; -- src=panlex
lin effort_N = mkN "การรณรงค์" | mkN "ความพยายาม" | mkN "ความมานะ" | mkN "ความพยายาม" | mkN "ความอุตสาหะ" | mkN "ผลของความพยายาม" | mkN "การทดลองที่ยากลําบาก" | mkN "กําลังของเครื่องจักร" ; -- src=panlex
lin player_N = mkN "ดารา" | mkN "คนดนตรี" | mkN "นักแสดง" | mkN "ผู้เล่น" | mkN "นักดนตรี" | mkN "ดารานักแสดง" | mkN "ศิลปินนักแสดง" | mkN "นักกีฬา" | mkN "นักพนัน" | mkN "นักแสดง" | mkN "ผู้เล่น" | mkN "ผู้แสดง" | mkN "นักเล่นกีฬา" | mkN "ผู้เล่นกีฬา" | mkN "เครื่องดนตรี" | mkN "ผู้บรรเลงดนตรี" | mkN "ผู้เล่นการพนัน" | mkN "เครื่องเล่นเทป" | mkN "เครื่องบันทึกเสียง" | mkN "เครื่องเล่นจานเสียง" ; -- src=panlex
lin everyone_NP = variants{} ; -- 
lin present_A = mkA "ปัจจุบัน" | mkA "ณ ที่นี้" | mkA "มอบ" | mkA "ให้" | mkA "ยื่น" | mkA "เล็ง" | mkA "ขณะนี้" | mkA "ตรงนี้" | mkA "ที่นี้" | mkA "บรรยาย" | mkA "มีอยู่" | mkA "แนะนํา" | mkA "ต่อหน้า" | mkA "ปัจจุบัน" | mkA "นําเข้าพบ" | mkA "ปรากฎอยู่" | mkA "เดี๋ยวนี้" | mkA "แสดงให้เห็น" | mkA "ที่เกิดขึ้นในปัจจุบัน" ; -- src=panlex
lin award_N = mkN "ให้" | mkN "รางวัล" | mkN "รางวัล" ; -- src=panlex
lin village_N = placeN (thword "หมู่" "บ้าน") | {-pan-} mkN "หมู่บ้าน" | mkN "นิคม" | mkN "บ้าน" | mkN "ชุมชน" | mkN "ชาวชนบท" | mkN "หมู่บ้าน" | mkN "คนในหมู่บ้าน" ; -- src=panlex
lin control_V2 = variants{} ; -- 
lin organisation_N = mkN "องค์กร" | mkN "องค์การ" | mkN "การก่อตั้ง" | mkN "การจัดตั้ง" | mkN "ผู้ก่อตั้ง" ; -- src=panlex
lin whatever_Det = variants{} ; -- 
lin news_N = mkN "ข่าว" | mkN "ข่าวสาร" | mkN "รายการข่าว" | mkN "การเป็นข่าว" | mkN "การตกเป็นข่าว" | mkN "ข้อมูลข่าวสาร" | mkN "ข่าว" | mkN "ข่าวคราว" | mkN "กระแสข่าว" | mkN "รายการข่าว" | mkN "หัวข้อข่าว" ; -- src=panlex
lin nice_A = mkA "ดี" | mkA "ดี" | mkA "งาม" | mkA "สวย" | mkA "กรุณา" | mkA "น่าดู" | mkA "สุภาพ" | mkA "น่ามอง" | mkA "ประณีต" | mkA "แน่นอน" | mkA "นิสัยดี" | mkA "น่าคบหา" | mkA "ละเอียด" | mkA "อ่อนโยน" | mkA "มีมารยาท" | mkA "พิถีพิถัน" | mkA "เที่ยงตรง" | mkA "มีมิตรไมตรี" | mkA "ละเอียดละออ" | mkA "ซึ่งทําให้เพลินหรือเบิกบานใจ" ; -- src=panlex
lin difficulty_N = mkN "ความยาก" | mkN "อุปสรรค" | mkN "ความยุ่งยาก" | mkN "ความยากลำบาก" | mkN "คัดค้าน" | mkN "อุปสรรค" | mkN "ความยุ่งยาก" | mkN "ความดื้อรั้น" | mkN "ความยากลําบาก" | mkN "ความเดือดร้อน" ; -- src=panlex
lin modern_A = mkA "ซึ่งล้ำยุค" | mkA "ที่รุดหน้า" | mkA "ซึ่งล้ำสมัย" | mkA "ที่ก้าวหน้า" | mkA "ซึ่งมองกาลไกล" | mkA "ทันสมัย" | mkA "ยุคใหม่" | mkA "สมัยใหม่" | mkA "ไม่ห่างไกล" | mkA "สมัยปัจจุบัน" ; -- src=panlex
lin cell_N = mkN "คุก" | mkN "กุฏิ" | mkN "ซังเต" | mkN "เซลล์" | mkN "มือถือ" | mkN "ห้องขัง" | mkN "โมบายโฟน" | mkN "หน่วยย่อย" | mkN "มุ้งสายบัว" | mkN "ห้องคุมขัง" | mkN "เซลล์ไฟฟ้า" | mkN "โทรศัพท์มือถือ" | mkN "โทรศัพท์ติดตามตัว" | mkN "โทรศัพท์เคลื่อนที่" | mkN "กุฎิ" | mkN "ตลับ" | mkN "กล่อง" | mkN "เซลล์" | mkN "ห้องเล็ก ๆ" | mkN "ห้องเล็กๆ" | mkN "กลุ่มเล็ก ๆ" | mkN "ช่องหนึ่ง ๆ ในหม้อแบตเตอรี่" | mkN "เซลล์ไฟฟ้า" | mkN "ช่องในรังผึ้ง" | mkN "ห้องขังนักโทษ" | mkN "โพรงหรือช่องเล็กๆ" | mkN "อุปกรณ์กําเนิดไฟฟ้า" | mkN "หน่วยเล็กๆในหน่วยใหญ่ เช่น กลุ่มเล็กๆในพรรคการเมือง" | mkN "หน่วยพื้นฐานของสิ่งมีชีวิต" ; -- src=panlex
lin close_A = mkA "สั้น" | mkA "ใกล้" | mkA "ซึ่งหุบปาก" | mkA "ซึ่งไม่พูด" | mkA "ซึ่งรูดซิปปาก" | mkA "ซึ่งปิดปากเงียบ" | mkA "ที่เหมือนต้นฉบับ" | mkA "ที่ใกล้เคียงของเิดิม" | mkA "ใกล้" | mkA "ที่คล้ายกัน" | mkA "ที่มีความใกล้ชิดกัน" | mkA "ที่แตกต่างกันน้อยมาก" ; -- src=panlex
lin current_A = mkA "ซึ่งเกิดขึ้นในปัจจุบัน" | mkA "กระแสลม" | mkA "ปัจจุบัน" | mkA "แพร่หลาย" | mkA "กระแสไฟฟ้า" | mkA "เป็นที่ยอมรับ" | mkA "ความเร็วของกระแส" | mkA "ซึ่งเกิดขึ้นอยู่" | mkA "ซึ่งหมุนเวียนอยู่" | mkA "เป็นที่ยอมรับโดยทั่วไป" | mkA "ที่ใช้กันอยู่ในปัจจุบัน" ; -- src=panlex
lin legal_A = mkA "ตามกฎหมาย" | mkA "ถูกกฎหมาย" | mkA "แห่งนิตินัย" | mkA "ชอบด้วยกฎหมาย" | mkA "เกี่ยวกับกฎหมาย" | mkA "ถูกต้องตามกฎหมาย" | mkA "เกี่ยวกับศาลกฎหมาย" | mkA "ได้รับอนุญาตตามกฎหมาย" ; -- src=panlex
lin energy_N = mkN "พลัง" | mkN "ทรงพลัง" | mkN "พลังงาน" | mkN "พละกำลัง" | mkN "ความแข็งแรง" | mkN "พลังงานเสรี" | mkN "ความมีชีวิตชีวา" | mkN "ความกระปรี้กระเปร่า" | mkN "พลัง" | mkN "กําลัง" | mkN "พลังงาน" | mkN "พลังวิชา" | mkN "กําลังงาน" | mkN "พละกําลัง" | mkN "เรี่ยวแรง" | mkN "ความมีชีวิตชีวา" | mkN "กําลังความสามารถ" | mkN "ความกระฉับกระเฉง" | mkN "ความกระตือรือร้น" ; -- src=panlex
lin finally_Adv = mkAdv "สุดท้าย" | mkAdv "ในที่สุด" | mkAdv "ในเวลาอันใกล้" | mkAdv "โดยสรุป" | mkAdv "ในที่สุด" | mkAdv "ท้ายที่สุด" | mkAdv "โดยเด็ดขาด" | mkAdv "ในบั้นปลาย" | mkAdv "จนแล้วจนรอด" | mkAdv "ในท้ายที่สุด" ; -- src=panlex
lin degree_N = variants{} ; -- 
lin degree_3_N = variants{} ; -- 
lin degree_2_N = variants{} ; -- 
lin degree_1_N = variants{} ; -- 
lin mile_N = mkN "ไมล์" | mkN "ไมล์ทะเล" | mkN "ไมล์โรมัน" | mkN "ไมล์สวีเดน" | mkN "ไมล์" | mkN "ช่องว่างขนาดใหญ่" | mkN "ระยะทางที่นับเป็นไมล์" | mkN "หน่วยระยะทางที่เท่ากับ1760ฟุต" ; -- src=panlex
lin means_N = mkN "มรรค" | mkN "วิธี" | mkN "วิถีทาง" | mkN "วิธี" | mkN "หนทาง" | mkN "ช่องทาง" | mkN "วิธีการ" | mkN "เงินทอง" | mkN "ทรัพย์สิน" | mkN "ความมั่งคั่ง" | mkN "ทรัพย์สมบัติ" ; -- src=panlex
lin growth_N = mkN "การปรากฏ" | mkN "พัฒนาการ" | mkN "การเพิ่มขึ้น" | mkN "สิ่งที่เติบโต" | mkN "สิ่งที่เจริญเติบโต" | mkN "การพัฒนา" | mkN "เนื้องอก" | mkN "การขยายตัว" | mkN "การเพิ่มขึ้น" | mkN "แหล่งกําเนิด" | mkN "การแพร่กระจาย" | mkN "การเจริญเติบโต" | mkN "การเป็นผู้ใหญ่" | mkN "สิ่งที่งอกขึ้น" | mkN "สิ่งที่เจริญเติบโตแล้ว" ; -- src=panlex
lin treatment_N = mkN "การอภิปราย" | mkN "การรักษาพยาบาล" | mkN "วิธี" | mkN "การใส่" | mkN "การดูแล" | mkN "การรักษา" | mkN "การเจรจา" | mkN "วิธีแสดง" | mkN "การบําบัด" | mkN "การปฏิบัติ" | mkN "การเยียวยา" | mkN "การกระทําต่อ" | mkN "การปฎิบัติต่อ" | mkN "การทําให้คืนสภาพ" | mkN "วิธีการทางวรรณกรรม" ; -- src=panlex
lin sound_N = mkN "เสียง" | mkN "ช่องแคบ" | mkN "เสียงพูด" | mkN "ปรากฎ" | mkN "เสียง" | mkN "ประกาศ" | mkN "ได้ยิน" | mkN "สมบูรณ์" | mkN "ถ้วนทั่ว" | mkN "ออกเสียง" | mkN "ไม่มีโรค" | mkN "ปล่อยเสียง" | mkN "มีสุขภาพดี" | mkN "ไม่ถูกรบกวน" | mkN "มีความสามารถ" | mkN "ชอบด้วยกฎหมาย" | mkN "ไม่ถูกขัดขวาง" | mkN "มีฐานะการเงินดี" | mkN "ไม่มีข้อบกพร่อง" | mkN "ระยะที่ได้ยินได้" | mkN "ใช้เครื่องตรวจฟังเสียง" ; -- src=panlex
lin above_Prep = ss (thword "ข้าง" "บน") | {-pan-} mkPrep "กว่า" | mkPrep "เกิน" | mkPrep "เหนือ" | mkPrep "ข้างบน" | mkPrep "มากกว่า" | mkPrep "สูงกว่า" | mkPrep "พ้นเหลือ" | mkPrep "ด้านเหนือ" | mkPrep "เบื้องต้น" | mkPrep "เหนือกว่า" | mkPrep "ดีเกินกว่า" | mkPrep "ในทิศเหนือ" | mkPrep "ยากเกินกว่า" | mkPrep "ดังกว่าเสียงอื่น" ; -- src=panlex
lin task_N = mkN "งาน" | mkN "โครงการ" | mkN "โครงงาน" | mkN "โปรเจ็ก" | mkN "งาน" | mkN "ภารกิจ" | mkN "งานหนัก" | mkN "งานที่ยาก" | mkN "ภาระหน้าที่" | mkN "ใช้สมองหนัก" | mkN "งานที่สําคัญ" | mkN "เรื่องที่ยาก" ; -- src=panlex
lin provision_N = mkN "เสบียง" | mkN "การจัดหา" | mkN "เงื่อนไข" | mkN "การคิดวางแผน" | mkN "ข้อกํา-หนด" | mkN "การจัดหา" | mkN "เงื่อนไข" | mkN "การกําหนด" | mkN "บทบัญญัติ" | mkN "เสบียงอาหาร" | mkN "การจัดเตรียม" | mkN "การเตรียมการ" | mkN "การแต่งตั้งตํา-แหน่งทางศาสนา" | mkN "สิ่งที่จัดหามาให้" | mkN "เสบียงที่เตรียมไว้ในอนาคต" ; -- src=panlex
lin affect_V2 = variants{} ; -- 
lin please_Adv = mkAdv "ได้โปรด" | mkAdv "โปรด" | mkAdv "กรุณา" ; -- src=panlex
lin red_A = mkA "แดง" ; --- (thword "สี" "แดง") ;
lin happy_A = mkA "ซึ่งยินดี" | mkA "ที่มีความสุข" | mkA "สุข" | mkA "สบาย" | mkA "มีโชค" | mkA "สุขใจ" | mkA "โชคดี" | mkA "สําราญ" | mkA "เบิกบาน" | mkA "เป็นสุข" | mkA "รื่นเริง" | mkA "มีความสุข" ; -- src=panlex
lin behaviour_N = mkN "กิริยา" | mkN "มารยาท" | mkN "พฤติกรรม" | mkN "ท่าที" | mkN "อาการ" | mkN "พฤติกรรม" | mkN "พฤติการณ์" | mkN "ความประพฤติ" | mkN "การกระทําตัว" | mkN "การแสดงอาการ" ; -- src=panlex
lin concerned_A = mkA "กังวล" | mkA "ซึ่งเป็นห่วง" | mkA "ที่เกี่ยวข้อง" | mkA "ที่สัมพันธ์กับ" | mkA "ซึ่งเป็นที่สนใจ" ; -- src=panlex
lin point_V2 = mkV2 "มุ่ง" ; ---- | mkV "แสดง" | mkV "นำทาง" | mkV "ชี้บอก" | mkV "บ่งชี้" | mkV "บ่งบอก" | mkV "ตั้งเป้า" | mkV "มุ่งหน้า" | mkV "ทำให้แหลม" | mkV "กำหนดทิศทาง" | mkV "ทำให้เรียวลง" | mkV "แล่นเรือทวนลม" | mkV "ชี้" | mkV "ชี้ทาง" | mkV "ชี้ให้ดู" | mkV "ชี้ไปทาง" | mkV "แล่นอิงลม" | mkV "ทําให้แหลม" | mkV "แสดงให้เห็น" | mkV "ทําให้เรียวแหลม" ; -- src=panlex
lin point_V = mkV "มุ่ง" | mkV "แสดง" | mkV "นำทาง" | mkV "ชี้บอก" | mkV "บ่งชี้" | mkV "บ่งบอก" | mkV "ตั้งเป้า" | mkV "มุ่งหน้า" | mkV "ทำให้แหลม" | mkV "กำหนดทิศทาง" | mkV "ทำให้เรียวลง" | mkV "แล่นเรือทวนลม" | mkV "ชี้" | mkV "ชี้ทาง" | mkV "ชี้ให้ดู" | mkV "ชี้ไปทาง" | mkV "แล่นอิงลม" | mkV "ทําให้แหลม" | mkV "แสดงให้เห็น" | mkV "ทําให้เรียวแหลม" ; -- src=panlex
lin function_N = mkN "วาระ" | mkN "บทบาท" | mkN "ฟังก์ชัน" | mkN "ฟังก์ชั่น" | mkN "โปรแกรมย่อย" | mkN "ฟังก์ชันคณิตศาสตร์" | mkN "บทบาท" | mkN "หน้าที่" | mkN "การทํางาน" | mkN "การทําหน้าที่" | mkN "การปฏิบัติหน้าที่" ; -- src=panlex
lin identify_V2 = mkV2 "วางขาย" ; ---- | mkV "ชี้ตัว" | mkV "ชันสูตร" | mkV "พิสูจน์" | mkV "แสดงตัว" | mkV "ระบุชื่อ" ; -- src=panlex
lin identify_V = mkV "วางขาย" | mkV "ชี้ตัว" | mkV "ชันสูตร" | mkV "พิสูจน์" | mkV "แสดงตัว" | mkV "ระบุชื่อ" ; -- src=panlex
lin resource_N = mkN "ทรัพยากร" | mkN "หนทาง" | mkN "ปฏิภาน" | mkN "วิธีการ" | mkN "ไหวพริบ" | mkN "ทรัพยากร" | mkN "แหล่งที่มา" | mkN "ทรัพย์สมบัติ" ; -- src=panlex
lin defence_N = mkN "ฝ่ายรับ" | mkN "การแก้ตัว" | mkN "คำแก้ต่าง" | mkN "การป้องกัน" | mkN "ทีมป้องกัน" | mkN "ทนายฝ่ายจำเลย" | mkN "มาตรการป้องกัน" | mkN "กลไกป้องกันตนเอง" | mkN "วัจนกรรมกล่าวแย้ง" | mkN "กองกำลังป้องกันตนเอง" | mkN "กลไกในการป้องกันตนเอง" | mkN "การป้องกัน" | mkN "การพิทักษ์" | mkN "การแก้ต่าง" | mkN "การแก้ตัวให้" | mkN "การเป็นทนายให้" | mkN "การต้านการรุกราน" ; -- src=panlex
lin garden_N = placeN "สวน" | {-pan-} mkN "สวน" | mkN "ไร่" | mkN "การ์เดน" | mkN "สวน" | mkN "ไร่" | mkN "ทําสวน" | mkN "อุทยาน" | mkN "สวนสาธารณะ" | mkN "อุทยานสาธารณะ" ; -- src=panlex
lin floor_N = mkN "พื้น" | {-pan-} mkN "ก้น" | mkN "ฐาน" | mkN "ขั้น" | mkN "ชั้น" | mkN "ฟลอร์" | mkN "ห้องค้าหลักทรัพย์" | mkN "กลุ่มผู้อยู่อาศัยในแต่ละชั้น" | mkN "กัน" | mkN "พื้นห้อง" | mkN "ชั้นอาคาร" | mkN "ชั้นของตึก" | mkN "ชั้นต่ําสุด" | mkN "ทําให้ล้มลง" | mkN "ทําให้สับสน" ; -- src=panlex ----?
lin technology_N = mkN "งานวิศวกรรม" | mkN "งานเทคโนโลยี" | mkN "งานทางวิศวกรรม" | mkN "วิศวกรรมศาสตร์" | mkN "งานทางเทคโนโลยี" | mkN "วิทยาศาสตร์ประยุกต์" | mkN "วิศวกรรมศาสตร์ประยุกต์" | mkN "วิชาการ" | mkN "เทคโนโลยี" | mkN "ประยุกต์วิทยา" | mkN "วิทยาศาสตร์ประยุกต์" | mkN "การนําเอาวิทยาศาสตร์มาใช้ในการปฏิบัติ" | mkN "เครื่องมือหรือเครื่องยนต์ที่สร้างขึ้นจากความรู้ทางเทคโนโลยี" ; -- src=panlex
lin style_N = mkN "ลีลา" | mkN "สไตล์" | mkN "แบบอย่าง" | mkN "กระบวนแบบ" | mkN "ึความนิยม" | mkN "ความเก๋ไก๋" | mkN "ปากกาปลายแหลม" | mkN "ชนิด" | mkN "ลีลา" | mkN "" | mkN "เดือย" | mkN "โวหาร" | mkN "ท่าทาง" | mkN "ทํานอง" | mkN "รสนิยม" | mkN "รูปแบน" | mkN "รูปแบบ" | mkN "ลักษณะ" | mkN "สํานวน" | mkN "แฟชั่น" | mkN "วิธีการ" | mkN "ความนิยม" | mkN "สมัยนิยม" | mkN "แบบอย่าง" | mkN "ความงดงาม" | mkN "แกนดอกไม้" | mkN "ความเก๋ไก๋" | mkN "คําขนานนาม" | mkN "ท่วงทํานอง" | mkN "วิธีการเขียน" | mkN "เข็มนาฬิกาแดด" | mkN "วิธีการจับเวลา" | mkN "เข็มเครื่องเล่นจานเสียง" | mkN "สิ่งที่คล้ายปากกาดังกล่าว" | mkN "ปากกาสมัยโบราณสําหรับเขียนบนแผ่นขี้ผึ้ง" ; -- src=panlex
lin feeling_N = mkN "กลิ่น" | mkN "ฟิลลิ่ง" | mkN "ความเชื่อ" | mkN "ความรู้สึก" | mkN "อารมณ์ความรู้สึก" | mkN "ความรู้สึกจากการสัมผัส" | mkN "จิตใจ" | mkN "การแตะ" | mkN "อารมณ์" | mkN "การคลํา" | mkN "ความคิด" | mkN "ความรัก" | mkN "ทัศนคติ" | mkN "การรับรู้" | mkN "การสัมผัส" | mkN "ความเชื่อ" | mkN "ความเมตตา" | mkN "ความรู้สึก" | mkN "ความเข้าใจ" | mkN "ความเห็นใจ" | mkN "ความคิดเห็น" | mkN "ประสาทสัมผัส" | mkN "ความรู้สึกสัมผัส" ; -- src=panlex
lin science_N = mkN "ทักษะ" | mkN "ศาสตร์" | mkN "วิทยาศาสตร์" | mkN "ความรู้ที่ได้จากการสังเกต ค้นคว้าและทดลอง" | mkN "การศึกษาทางด้านวิทยาศาสตร์" | mkN "ศาสตร์หรือสาขาทางวิทยาศาสตร์" ; -- src=panlex
lin relate_V2 = mkV2 "เกี่ยวข้อง" ; ---- | mkV "เล่า" | mkV "บรรยาย" | mkV "เกี่ยวกับ" | mkV "เกี่ยวโยง" | mkV "เกี่ยวข้อง" | mkV "เล่าเรื่อง" | mkV "สัมพันธ์กับ" | mkV "ทําให้สัมพันธ์กัน" | mkV "ทําให้เกี่ยวข้องกัน" ; -- src=panlex
lin relate_V = mkV "เกี่ยวข้อง" | mkV "เล่า" | mkV "บรรยาย" | mkV "เกี่ยวกับ" | mkV "เกี่ยวโยง" | mkV "เกี่ยวข้อง" | mkV "เล่าเรื่อง" | mkV "สัมพันธ์กับ" | mkV "ทําให้สัมพันธ์กัน" | mkV "ทําให้เกี่ยวข้องกัน" ; -- src=panlex
lin doubt_N = mkN "ความสงสัย" | mkN "ความไม่แน่ใจ" | mkN "สงกา" | mkN "สงสัย" | mkN "ข้องใจ" | mkN "ความสงสัย" | mkN "ความไม่แน่ใจ" | mkN "ความคลางแคลงใจ" | mkN "ความไม่เชื่อถือ" ; -- src=panlex
lin horse_N = mkN "ม้า" " ตัว" | {-pan-} mkN "ม้า" | mkN "แสะ" | mkN "พาชี" | mkN "อัศว" | mkN "อาชา" | mkN "อัศวิน" | mkN "ทหารม้า" | mkN "ม้าเลื่อย" | mkN "กองทหารม้า" | mkN "ม้า" | mkN "เบ๊" | mkN "อัศว" | mkN "อาชา" | mkN "สินธพ" | mkN "ทหารม้า" | mkN "ม้าตัวผู้" ; -- src=panlex
lin force_VS = mmkVS "ดัน" ; ---- | mkV "ดึง" | mkV "บีบ" | mkV "ลาก" | mkV "ผลัก" | mkV "เค้น" | mkV "กดดัน" | mkV "ทำแรง" | mkV "โจมตี" | mkV "กระแทก" | mkV "ทำแรงๆ" | mkV "ออกแรง" | mkV "ใช้แรง" | mkV "กระตุ้น" | mkV "กระทุ้ง" | mkV "บีบคั้น" | mkV "บีบบังคับ" | mkV "งัด" | mkV "ดึง" | mkV "บิด" | mkV "ฝืน" | mkV "ฝืนใจ" | mkV "กระชาก" | mkV "บังคับ" | mkV "บีบคั้น" | mkV "ยัดเยียด" | mkV "บีบบังคับ" ; -- src=panlex
lin force_V2V = mmkV2V "ดัน" ; ---- | mkV "ดึง" | mkV "บีบ" | mkV "ลาก" | mkV "ผลัก" | mkV "เค้น" | mkV "กดดัน" | mkV "ทำแรง" | mkV "โจมตี" | mkV "กระแทก" | mkV "ทำแรงๆ" | mkV "ออกแรง" | mkV "ใช้แรง" | mkV "กระตุ้น" | mkV "กระทุ้ง" | mkV "บีบคั้น" | mkV "บีบบังคับ" | mkV "งัด" | mkV "ดึง" | mkV "บิด" | mkV "ฝืน" | mkV "ฝืนใจ" | mkV "กระชาก" | mkV "บังคับ" | mkV "บีบคั้น" | mkV "ยัดเยียด" | mkV "บีบบังคับ" ; -- src=panlex
lin force_V2 = mkV2 "ดัน" ; ---- | mkV "ดึง" | mkV "บีบ" | mkV "ลาก" | mkV "ผลัก" | mkV "เค้น" | mkV "กดดัน" | mkV "ทำแรง" | mkV "โจมตี" | mkV "กระแทก" | mkV "ทำแรงๆ" | mkV "ออกแรง" | mkV "ใช้แรง" | mkV "กระตุ้น" | mkV "กระทุ้ง" | mkV "บีบคั้น" | mkV "บีบบังคับ" | mkV "งัด" | mkV "ดึง" | mkV "บิด" | mkV "ฝืน" | mkV "ฝืนใจ" | mkV "กระชาก" | mkV "บังคับ" | mkV "บีบคั้น" | mkV "ยัดเยียด" | mkV "บีบบังคับ" ; -- src=panlex
lin force_V = mkV "ดัน" | mkV "ดึง" | mkV "บีบ" | mkV "ลาก" | mkV "ผลัก" | mkV "เค้น" | mkV "กดดัน" | mkV "ทำแรง" | mkV "โจมตี" | mkV "กระแทก" | mkV "ทำแรงๆ" | mkV "ออกแรง" | mkV "ใช้แรง" | mkV "กระตุ้น" | mkV "กระทุ้ง" | mkV "บีบคั้น" | mkV "บีบบังคับ" | mkV "งัด" | mkV "ดึง" | mkV "บิด" | mkV "ฝืน" | mkV "ฝืนใจ" | mkV "กระชาก" | mkV "บังคับ" | mkV "บีบคั้น" | mkV "ยัดเยียด" | mkV "บีบบังคับ" ; -- src=panlex
lin answer_N = mkN "เฉลย" | mkN "คำตอบ" | mkN "การตอบ" | mkN "การตอบคำถาม" | mkN "วิธีแก้ปัญหา" | mkN "คําตอบ" | mkN "การโต้ตอบ" | mkN "การตอบคําถาม" | mkN "วิธีแก้ปัญหา" | mkN "สิ่งที่โต้ตอบ" | mkN "สิ่งที่ตอบสนอง" | mkN "คําแก้ต่างในศาล" ; -- src=panlex
lin compare_V = mkV "เทียบ" | mkV "เปรียบ" | mkV "เปรียบเทียบ" | mkV "เปรียบเทียบขั้นกว่า" | mkV "เปรียบเทียบ" ; -- src=panlex
lin suffer_V2 = mkV2 "ทน" ; ---- | mkV "ปวด" | mkV "อดทน" | mkV "เจ็บ" | mkV "ประสบ" | mkV "ยอมทน" | mkV "ได้รับ" | mkV "ทนทุกข์" | mkV "ทุกข์ใจ" | mkV "มีอาการ" | mkV "อดกลั้น" | mkV "เลวร้าย" | mkV "ไม่สบาย" | mkV "รู้สึกปวด" | mkV "รู้สึกเจ็บ" | mkV "เสียประโยชน์" | mkV "อดทน" | mkV "ทนทาน" | mkV "หนักใจ" | mkV "ทุกข์ใจ" | mkV "ทนทุกข์ทรมาน" | mkV "ประสบความทุกข์" ; -- src=panlex
lin suffer_V = mkV "ทน" | mkV "ปวด" | mkV "อดทน" | mkV "เจ็บ" | mkV "ประสบ" | mkV "ยอมทน" | mkV "ได้รับ" | mkV "ทนทุกข์" | mkV "ทุกข์ใจ" | mkV "มีอาการ" | mkV "อดกลั้น" | mkV "เลวร้าย" | mkV "ไม่สบาย" | mkV "รู้สึกปวด" | mkV "รู้สึกเจ็บ" | mkV "เสียประโยชน์" | mkV "อดทน" | mkV "ทนทาน" | mkV "หนักใจ" | mkV "ทุกข์ใจ" | mkV "ทนทุกข์ทรมาน" | mkV "ประสบความทุกข์" ; -- src=panlex
lin individual_A = mkA "แต่ละ" | mkA "ส่วนตัว" | mkA "ส่วนบุคคล" | mkA "แต่ละบุคคล" ; -- src=panlex
lin forward_Adv = mkAdv "ตรงไป" | mkAdv "ด้านหัว" | mkAdv "ข้างหน้า" | mkAdv "สู่อนาคต" | mkAdv "ไว" | mkAdv "กล้า" | mkAdv "เร่ง" | mkAdv "ส่งออก" | mkAdv "คืบหน้า" | mkAdv "สิ่งต่อ" | mkAdv "เร่งรัด" | mkAdv "ก้าวหน้า" | mkAdv "ข้างหน้า" | mkAdv "ล้ําหน้า" | mkAdv "สนับสนุน" | mkAdv "ไปข้างหน้า" | mkAdv "ส่งล่วงหน้า" | mkAdv "โดยล้ําหน้า" | mkAdv "อยู่ข้างหน้า" | mkAdv "โดยไปข้างหน้า" | mkAdv "เกี่ยวกับอนาคต" | mkAdv "เย็บเล่มหนังสือ" | mkAdv "โดยอยู่ข้างหน้า" ; -- src=panlex
lin announce_VS = variants{} ; -- 
lin announce_V2 = variants{} ; -- 
lin userMasc_N = variants{} ; -- 
lin fund_N = mkN "เงินกองทุน" | mkN "บริษัทจัดการลงทุน" | mkN "ทุน" | mkN "เงินทุน" | mkN "เงินสะสม" | mkN "ของที่สํารองไว้" ; -- src=panlex
lin character_2_N = variants{} ; -- 
lin character_1_N = variants{} ; -- 
lin risk_N = mkN "ภยันตราย" | mkN "ความเสี่ยง" | mkN "การทำให้เป็นอันตราย" | mkN "ความเสี่ยงในการติดเชื้อ" | mkN "ความเสี่ยงในการสัมผัสโรค" | mkN "ภัย" | mkN "อันตราย" | mkN "การเสี่ยง" | mkN "ภัยอันตราย" | mkN "การเสี่ยงภัย" ; -- src=panlex
lin normal_A = mkA "ปกติ" | mkA "ปกติ" | mkA "ธรรมดา" | mkA "ประจํา" | mkA "ตั้งฉาก" | mkA "ค่าเฉลี่ย" | mkA "ปกติวิสัย" | mkA "มีจิตปกติ" | mkA "เป็นประจํา" | mkA "เป็นมุมฉาก" | mkA "เป็นมาตรฐาน" | mkA "เส้นตั้งฉาก" | mkA "โดยธรรมชาติ" | mkA "รูปแบบธรรมดา" ; -- src=panlex
lin nor_Conj = variants{} ; -- 
lin dog_N = animalN (thword "หมา") | {-pan-} mkN "หมอ" | mkN "หมา" | mkN "คนเลว" | mkN "สุนัข" | mkN "คนถ่อย" | mkN "บานพับ" | mkN "ยายเชย" | mkN "ฮอตดอก" | mkN "หมาบ้าน" | mkN "อันธพาล" | mkN "ไส้กรอก" | mkN "ไอ้หมอนี่" | mkN "ไส้กรอกรมควัน" | mkN "ไส้กรอกเยอรมัน" | mkN "คนไร้สกุลรุนชาติ" | mkN "สามขาสำหรับวางฟืน" | mkN "หมา" | mkN "คนเชย" | mkN "สุนัข" | mkN "สุวาน" | mkN "คนหัวโบราณ" | mkN "ตะแกรงเหล็ก" | mkN "คนน่ารังเกียจ" | mkN "สัตว์ตระกูลสุนัข" | mkN "ตะแกรงเหล็กในเตาไฟ" ; -- src=panlex
lin obtain_V2 = mkV2 "ได้" ; ---- | mkV "ได้มา" | mkV "ได้รับ" | mkV "เป็นจริง" | mkV "ได้มา" | mkV "ได้รับ" ; -- src=panlex
lin obtain_V = mkV "ได้" | mkV "ได้มา" | mkV "ได้รับ" | mkV "เป็นจริง" | mkV "ได้มา" | mkV "ได้รับ" ; -- src=panlex
lin quickly_Adv = variants{} ; -- 
lin army_N = mkN "ทัพบก" | mkN "กองทัพบก" | mkN "กอง" | mkN "ทัพ" | mkN "กลุ่ม" | mkN "ฝูงชน" | mkN "กองทัพ" | mkN "กลุ่มคน" | mkN "กองทหาร" | mkN "กองทหาร ฝึกและติดอาวุธเพื่อสงคราม" | mkN "กองทัพบก" | mkN "กองทหารบก" | mkN "กลุ่มคนขนาดใหญ่" ; -- src=panlex
lin indicate_VS = variants{} ; -- 
lin indicate_V2 = variants{} ; -- 
lin forget_VS = mmkVS "ลืม" ; ---- | mkV "ทิ้ง" | mkV "ไม่นึกถึง" | mkV "ลืมทิ้งไว้" | mkV "ลืม" | mkV "หลงลืม" | mkV "ลืมเลือน" | mkV "จําไม่ได้" ; -- src=panlex
lin forget_V2 = mkV2 "ลืม" ;
lin forget_V = mkV "ลืม" | mkV "ทิ้ง" | mkV "ไม่นึกถึง" | mkV "ลืมทิ้งไว้" | mkV "ลืม" | mkV "หลงลืม" | mkV "ลืมเลือน" | mkV "จําไม่ได้" ; -- src=panlex
lin station_N = mkN "สถานี" | mkN "สเตชั่น" | mkN "ความถี่กระจายเสียง" | mkN "คลื่นความถี่กระจายเสียง" | mkN "โรง" | mkN "ฐานะ" | mkN "สถานี" | mkN "สถานที่" | mkN "ที่ทําการ" | mkN "สถานีย่อย" | mkN "สถานีรถไฟ" | mkN "สํานักงาน" | mkN "ตั้งประจํา" | mkN "แหล่งกําเนิด" | mkN "สถานีรถโดยสาร" | mkN "จุดรังวัดปักเขต" | mkN "ตําแหน่งหน้าที่" | mkN "ตั้งฐานปฎิบัติการ" | mkN "แหล่งที่อยู่อาศัย" | mkN "ฟาร์มเลี้ยงปศุสัตว์" ; -- src=panlex
lin glass_N = mkN "แก้ว" | mkN "กระจก" | mkN "แก้วน้ำ" | mkN "แก้วดื่มน้ำ" | mkN "กระจกแต่งตัว" | mkN "กระจกส่องหน้า" | mkN "เมทแอมเฟตามีน" | mkN "แก้ว" | mkN "กระจก" | mkN "เลนส์" | mkN "สะท้อน" | mkN "แว่นตา" | mkN "แก้วน้ํา" | mkN "แว่นขยาย" | mkN "เครื่องแก้ว" | mkN "สิ่งที่ทําด้วยแก้ว" ; -- src=panlex
lin cup_N = mkN "คัพ" | mkN "ถ้วย" | mkN "หลุม" | mkN "กาบรูปถ้วย" | mkN "ถ้วยรางวัล" | mkN "ปริมาณหนึ่งถ้วย" | mkN "ถ้วย" | mkN "โชคชะตา" | mkN "ถ้วยกีฬา" | mkN "หลุมกอล์ฟ" | mkN "ถ้วยรางวัล" | mkN "การแข่งขันกีฬา" | mkN "ปริมาณหนึ่งถ้วย" | mkN "ลักษณะคล้ายถ้วย" | mkN "ปริมาณความจุหนึ่งถ้วย" | mkN "ส่วนของพืชที่เป็นรูปถ้วย" | mkN "ส่วนของชุดชั้นในสตรีที่รับเต้านม" ; -- src=panlex
lin previous_A = mkA "ก่อน" | mkA "อดีต" | mkA "เก่า" | mkA "ก่อน" | mkA "อันก่อน" | mkA "แต่ก่อน" | mkA "เมื่อก่อน" ; -- src=panlex
lin husband_N = personN (thword "สา" "มี") | {-pan-} mkN "ผัว" | mkN "สามี" | mkN "สวามี" | mkN "ฝาละมี" | mkN "พระสามี" | mkN "พระภัสดา" | mkN "พระสวามี" | mkN "ไถ" | mkN "ผัว" | mkN "สามี" | mkN "สวามี" | mkN "้สามี" | mkN "ควบคุม" | mkN "พ่อบ้าน" | mkN "แต่งงาน" | mkN "เป็นสามี" | mkN "หาสามีให้" | mkN "ใช้อย่างประหยัด" ; -- src=panlex
lin recently_Adv = variants{} ; -- 
lin publish_V2 = mkV2 "ลง" ; ---- | mkV "พิมพ์" | mkV "ตีพิมพ์" | mkV "ลงข่าว" | mkV "ตีพิมพ์" | mkV "ลงพิมพ์" | mkV "จัดพิมพ์" | mkV "ลงหนังสือ" | mkV "ออกหนังสือ" | mkV "จัดพิมพ์ออกจําหน่าย" ; -- src=panlex
lin publish_V = mkV "ลง" | mkV "พิมพ์" | mkV "ตีพิมพ์" | mkV "ลงข่าว" | mkV "ตีพิมพ์" | mkV "ลงพิมพ์" | mkV "จัดพิมพ์" | mkV "ลงหนังสือ" | mkV "ออกหนังสือ" | mkV "จัดพิมพ์ออกจําหน่าย" ; -- src=panlex
lin serious_A = mkA "ฉกรรจ์" | mkA "จริงจัง" | mkA "ซีเรียส" | mkA "ขรึม" | mkA "หนัก" | mkA "สาหัส" | mkA "ขึงขัง" | mkA "สําคัญ" | mkA "จริงจัง" | mkA "ซีเรียส" | mkA "ร้ายแรง" | mkA "อันตราย" | mkA "เคร่งขรึม" | mkA "เคร่งครัด" | mkA "ไม่ล้อเล่น" | mkA "ไม่เหลาะแหละ" | mkA "เอาจริงเอาจัง" ; -- src=panlex
lin anyway_Adv = mkAdv "อย่างไรก็ตาม" | mkAdv "ไม่ว่าด้วยวิธีใดก็ตาม" | mkAdv "ถึงอย่างไร" | mkAdv "นอกจากนั้น" | mkAdv "อย่างไรก็ตาม" ; -- src=panlex
lin visit_V2 = mkV2 "จ้อ" ; ---- | mkV "กำหนด" | mkV "เมาท์" | mkV "ซุบซิบ" | mkV "พูดคุย" | mkV "เยี่ยม" | mkV "เยี่ยมชม" | mkV "ไปเที่ยว" | mkV "พูดคุยสนุกๆ" | mkV "เยี่ยมเยือน" | mkV "พูดคุยไร้สาระ" | mkV "พูดเรื่อยเปื่อย" | mkV "เยือน" | mkV "มาเยือน" | mkV "มาเยี่ยม" | mkV "ไปเยี่ยม" | mkV "แวะเยี่ยม" | mkV "เยี่ยมเยียน" ; -- src=panlex
lin visit_V = mkV "จ้อ" | mkV "กำหนด" | mkV "เมาท์" | mkV "ซุบซิบ" | mkV "พูดคุย" | mkV "เยี่ยม" | mkV "เยี่ยมชม" | mkV "ไปเที่ยว" | mkV "พูดคุยสนุกๆ" | mkV "เยี่ยมเยือน" | mkV "พูดคุยไร้สาระ" | mkV "พูดเรื่อยเปื่อย" | mkV "เยือน" | mkV "มาเยือน" | mkV "มาเยี่ยม" | mkV "ไปเยี่ยม" | mkV "แวะเยี่ยม" | mkV "เยี่ยมเยียน" ; -- src=panlex
lin capital_N = variants{} ; -- 
lin capital_3_N = variants{} ; -- 
lin capital_2_N = variants{} ; -- 
lin capital_1_N = variants{} ; -- 
lin either_Det = variants{} ; -- 
lin note_N = variants{} ; -- 
lin note_3_N = variants{} ; -- 
lin note_2_N = variants{} ; -- 
lin note_1_N = variants{} ; -- 
lin season_N = mkN "ฤดู" | mkN "ฤดูกาล" | mkN "กาล" | mkN "ฤดู" | mkN "คราว" | mkN "หน้า" | mkN "ปรุงรส" | mkN "ฤดูกาล" | mkN "เทศกาล" | mkN "คุ้นเคย" | mkN "ตั๋วฤดู" | mkN "ช่วงเวลา" | mkN "ระยะเวลา" | mkN "ช่วงเทศกาล" | mkN "ประสบการณ์" | mkN "เพิ่มรสชาด" | mkN "ตัวกําหนดเวลา" | mkN "เวลาที่เหมาะสม" ; -- src=panlex
lin argument_N = mkN "เรื่องย่อ" | mkN "การอภิปราย" | mkN "การโต้แย้ง" | mkN "การโต้เถียง" | mkN "พารามิเตอร์" | mkN "อาร์กิวเมนต์" | mkN "เรื่อง" | mkN "เหตุผล" | mkN "การแย้ง" | mkN "ข้อสรุป" | mkN "หลักฐาน" | mkN "การโต้คารม" | mkN "การโต้แย้ง" | mkN "ข้อพิสูจน์" | mkN "การโต้เถียง" | mkN "ข้อเท็จจริง" | mkN "ข้อโต้เถียง" | mkN "การอ้างเหตุผล" | mkN "ขบวนการให้เหตุผล" | mkN "ทัศนคติที่แสดงออกมา" | mkN "ข้อคิดเห็นที่แสดงออกมา" ; -- src=panlex
lin listen_V = mkV "ฟัง" | mkV "เอาใจใส่" | mkV "ตั้งใจฟัง" | mkV "ฟังอย่างตั้งใจ" | mkV "ฟัง" | mkV "คอยฟัง" | mkV "รับฟัง" ; -- src=panlex
lin show_N = mkN "โชว์" | mkN "การแสดง" | mkN "งานแสดง" | mkN "การสร้างภาพ" | mkN "การแสดงโชว์" | mkN "การแสดง" | mkN "การโชว์" | mkN "การสาธิต" | mkN "การเผยตัว" | mkN "สิ่งลวงตา" | mkN "การปรากฏตัว" | mkN "การแสดงนิทรรศการ" | mkN "สิ่งที่นํามาแสดง" ; -- src=panlex
lin responsibility_N = mkN "ภาระ" | mkN "การทำหน้าที่" | mkN "ความรับผิดชอบ" | mkN "ภาระ" | mkN "หน้าที่" | mkN "ภาระหน้าที่" | mkN "ความรับผิดชอบ" | mkN "สิ่งที่รับผิดชอบ" | mkN "สิ่งที่ต้องรับผิดชอบ" | mkN "สิ่งที่เป็นภาระหน้าที่" ; -- src=panlex
lin significant_A = mkA "สำคัญ" | mkA "สําคัญ" | mkA "มีความหมาย" | mkA "สิ่งที่มีผล" | mkA "ซึ่งมีความหมาย" | mkA "มีลักษณะสําคัญ" | mkA "สิ่งที่มีความหมาย" ; -- src=panlex
lin deal_N = mkN "ไพ่" | mkN "กลุ่ม" | mkN "ไม้สน" | mkN "มากมาย" | mkN "การตกลง" | mkN "การเจรจา" | mkN "จำนวนมาก" | mkN "การค้าขาย" | mkN "การแจกไพ่" | mkN "การซื้อขาย" | mkN "การแจกจ่าย" | mkN "กระดานไม้สน" | mkN "ไม้เนื้ออ่อน" | mkN "จำนวนมากมายก่ายกอง" | mkN "สัญญา" | mkN "การตกลง" | mkN "ข้อตกลง" | mkN "ข้อสัญญา" | mkN "ไพ่ในมือ" | mkN "การจัดสรร" | mkN "การแจกไพ่" | mkN "จํานวนมาก" | mkN "ปริมาณมาก" | mkN "การซื้อขาย" | mkN "การแจกจ่าย" | mkN "การแบ่งปัน" | mkN "การตกลงราคา" | mkN "การตกลงซื้อขาย" | mkN "การทําความตกลง" | mkN "การติดต่อธุรกิจ" | mkN "ชุดของไพ่ซึ่งอยู่ในมือ" | mkN "ถึงกําหนดต้องรับหรือวางไพ่" ; -- src=panlex
lin prime_A = mkA "ที่คัดสรร" | mkA "ที่เลือกเฟ้น" | mkA "ดีเลิศ" | mkA "สั่งสอน" | mkA "แจ้งข่าว" | mkA "ชั้นหนึ่ง" | mkA "ที่ดีเลิศ" | mkA "ขั้นพื้นฐาน" | mkA "ที่ดีที่สุด" | mkA "ฤดูใบไม้ผลิ" | mkA "วันหนุ่มสาว" | mkA "อันดับหนึ่ง" | mkA "ระยะแรกเริ่ม" | mkA "สําคัญที่สุด" | mkA "ส่วนที่ดีเลิศ" | mkA "ที่มาลําดับแรก" | mkA "ที่สําคัญที่สุด" | mkA "ชั่วโมงแรกของวัน" | mkA "ที่เป็นจํานวนเฉพาะ" ; -- src=panlex
lin economy_N = variants{} ; -- 
lin economy_2_N = variants{} ; -- 
lin economy_1_N = variants{} ; -- 
lin element_N = mkN "ธาตุ" | mkN "ส่วนประกอบ" | mkN "องค์ประกอบ" | mkN "ธาตุทางเคมี" | mkN "สภาพแวดล้อม" | mkN "สิ่งเล็กน้อย" | mkN "ธาตุ" | mkN "หน่วย" | mkN "ปัจจัย" | mkN "รากฐาน" | mkN "ธาตุแท้" | mkN "พื้นฐาน" | mkN "ธรรมชาติ" | mkN "ขั้วไฟฟ้า" | mkN "ส่วนประกอบ" | mkN "ส่วนสําคัญ" | mkN "องค์ประกอบ" | mkN "ปัจจัยสําคัญ" | mkN "สิ่งเล็กน้อย" | mkN "จํานวนเล็กน้อย" | mkN "ที่อยู่ตามธรรมชาติ" | mkN "สภาพที่เป็นธรรมชาติ" | mkN "สภาพแวดล้อมตามธรรมชาติ" ; -- src=panlex
lin finish_V2 = mkV2 "จบ" ; ---- | mkV "ยุติ" | mkV "หยุด" | mkV "ลงเอย" | mkV "อวสาน" | mkV "ทำเสร็จ" | mkV "สิ้นสุด" | mkV "จบลงด้วย" | mkV "กินเกลี้ยง" | mkV "ทำให้ลงเอย" | mkV "กินไม่เหลือ" | mkV "จบ" | mkV "ยุติ" | mkV "แล้ว" | mkV "เสร็จ" | mkV "ชักเงา" | mkV "สําเร็จ" | mkV "เคลือบเงา" | mkV "เริยบร้อย" | mkV "เสร็จสิ้น" | mkV "ขัดผิวให้เงา" ; -- src=panlex
lin finish_V = mkV "จบ" | mkV "ยุติ" | mkV "หยุด" | mkV "ลงเอย" | mkV "อวสาน" | mkV "ทำเสร็จ" | mkV "สิ้นสุด" | mkV "จบลงด้วย" | mkV "กินเกลี้ยง" | mkV "ทำให้ลงเอย" | mkV "กินไม่เหลือ" | mkV "จบ" | mkV "ยุติ" | mkV "แล้ว" | mkV "เสร็จ" | mkV "ชักเงา" | mkV "สําเร็จ" | mkV "เคลือบเงา" | mkV "เริยบร้อย" | mkV "เสร็จสิ้น" | mkV "ขัดผิวให้เงา" ; -- src=panlex
lin duty_N = mkN "ภาระ" | mkN "อากร" | mkN "หน้าที่" | mkN "พิกัดอัตรา" | mkN "การทำหน้าที่" | mkN "ภาษี" | mkN "อากร" | mkN "หน้าที่" | mkN "ภาระหน้าที่" | mkN "ภาษีศุลกากร" | mkN "ความรับผิดชอบ" | mkN "หน้าที่รับผิดชอบ" | mkN "ประสิทธิภาพของเครื่อง" ; -- src=panlex
lin fight_V2 = mkV2 (thword "สู้") ;
lin fight_V = mkV "สู้" | mkV "ดิ้นรน" | mkV "ตอบโต้" | mkV "ต่อสู้" | mkV "ประลอง" | mkV "รณรงค์" | mkV "โต้กลับ" | mkV "รบ" | mkV "สู้" | mkV "ปะทะ" | mkV "สู้รบ" | mkV "โจมตี" | mkV "ต่อสู้" | mkV "ต่อต้าน" | mkV "เข้าปะทะ" | mkV "ทําสงคราม" ; -- src=panlex
lin train_V2V = mmkV2V "ฝึก" ; ---- | mkV "ซ้อม" | mkV "อบรม" | mkV "เทรน" | mkV "เล็ง" | mkV "ฝึกฝน" | mkV "ฝึกซ้อม" | mkV "ขึ้นรถไฟ" | mkV "นั่งรถไฟ" | mkV "เตรียมตัว" | mkV "โดยสารรถไฟ" | mkV "ฝึก" | mkV "หัด" | mkV "ซ้อม" | mkV "อบรม" | mkV "ฝึกฝน" | mkV "ฝึกหัด" | mkV "ปลูกฝัง" | mkV "สั่งสอน" | mkV "เตรียมตัว" | mkV "โดยสารรถไฟ" | mkV "ให้ความรู้" | mkV "เดินทางโดยรถไฟ" ; -- src=panlex
lin train_V2 = mkV2 "ฝึก" ; ---- | mkV "ซ้อม" | mkV "อบรม" | mkV "เทรน" | mkV "เล็ง" | mkV "ฝึกฝน" | mkV "ฝึกซ้อม" | mkV "ขึ้นรถไฟ" | mkV "นั่งรถไฟ" | mkV "เตรียมตัว" | mkV "โดยสารรถไฟ" | mkV "ฝึก" | mkV "หัด" | mkV "ซ้อม" | mkV "อบรม" | mkV "ฝึกฝน" | mkV "ฝึกหัด" | mkV "ปลูกฝัง" | mkV "สั่งสอน" | mkV "เตรียมตัว" | mkV "โดยสารรถไฟ" | mkV "ให้ความรู้" | mkV "เดินทางโดยรถไฟ" ; -- src=panlex
lin train_V = mkV "ฝึก" | mkV "ซ้อม" | mkV "อบรม" | mkV "เทรน" | mkV "เล็ง" | mkV "ฝึกฝน" | mkV "ฝึกซ้อม" | mkV "ขึ้นรถไฟ" | mkV "นั่งรถไฟ" | mkV "เตรียมตัว" | mkV "โดยสารรถไฟ" | mkV "ฝึก" | mkV "หัด" | mkV "ซ้อม" | mkV "อบรม" | mkV "ฝึกฝน" | mkV "ฝึกหัด" | mkV "ปลูกฝัง" | mkV "สั่งสอน" | mkV "เตรียมตัว" | mkV "โดยสารรถไฟ" | mkV "ให้ความรู้" | mkV "เดินทางโดยรถไฟ" ; -- src=panlex
lin maintain_VS = mmkVS "คง" ; ---- | mkV "รักษา" | mkV "ยืนยัน" | mkV "สนับสนุน" | mkV "ส่งเสริม" | mkV "อนุรักษ์" | mkV "ใช้อำนาจ" | mkV "บันทึกไว้" | mkV "เก็บรักษา" | mkV "ซื้อทิ้งไว้" | mkV "ซื้อเก็บไว้" | mkV "ให้การสนับสนุน" | mkV "ประกาศอย่างหนักแน่น" | mkV "ดํารง" | mkV "รักษา" | mkV "คงอยู่" | mkV "ทรงไว้" | mkV "คงเอาไว้" | mkV "รักษาไว้" | mkV "ดูแลต่อไป" ; -- src=panlex
lin maintain_V2 = mkV2 "คง" ; ---- | mkV "รักษา" | mkV "ยืนยัน" | mkV "สนับสนุน" | mkV "ส่งเสริม" | mkV "อนุรักษ์" | mkV "ใช้อำนาจ" | mkV "บันทึกไว้" | mkV "เก็บรักษา" | mkV "ซื้อทิ้งไว้" | mkV "ซื้อเก็บไว้" | mkV "ให้การสนับสนุน" | mkV "ประกาศอย่างหนักแน่น" | mkV "ดํารง" | mkV "รักษา" | mkV "คงอยู่" | mkV "ทรงไว้" | mkV "คงเอาไว้" | mkV "รักษาไว้" | mkV "ดูแลต่อไป" ; -- src=panlex
lin maintain_V = mkV "คง" | mkV "รักษา" | mkV "ยืนยัน" | mkV "สนับสนุน" | mkV "ส่งเสริม" | mkV "อนุรักษ์" | mkV "ใช้อำนาจ" | mkV "บันทึกไว้" | mkV "เก็บรักษา" | mkV "ซื้อทิ้งไว้" | mkV "ซื้อเก็บไว้" | mkV "ให้การสนับสนุน" | mkV "ประกาศอย่างหนักแน่น" | mkV "ดํารง" | mkV "รักษา" | mkV "คงอยู่" | mkV "ทรงไว้" | mkV "คงเอาไว้" | mkV "รักษาไว้" | mkV "ดูแลต่อไป" ; -- src=panlex
lin attempt_N = variants{} ; -- 
lin leg_N = mkN (thword "ขา") | {-pan-} mkN "ขา" | mkN "เลก" | mkN "สาขา" | mkN "แข้งขา" | mkN "ขาเทียม" | mkN "พระเพลา" | mkN "ขากางเกง" | mkN "เนื้อส่วนขา" | mkN "ขา" | mkN "สาขา" | mkN "เพลา" | mkN "แขนง" | mkN "กิ่งก้าน" | mkN "ขากางเกง" | mkN "ขาเก้าอี้หรือขาโต๊ะ" | mkN "ผลัดหนึ่งในเกมการแข่งขันกีฬา" ; -- src=panlex
lin investment_N = mkN "กองทุนเพื่อการลงทุน" | mkN "การลงทุน" | mkN "เงินลงทุน" | mkN "สิ่งปกคลุม" | mkN "การมอบตําแหน่ง" | mkN "เสื้อผ้าอาภรณ์" | mkN "การมอบอํานาจหน้าที่" ; -- src=panlex
lin save_V2 = mkV2 "จอง" ; ---- | mkV "เซฟ" | mkV "บรรเทา" | mkV "เซฟงาน" | mkV "จัดเก็บ" | mkV "ประหยัด" | mkV "เซฟไฟล์" | mkV "ช่วยชีวิต" | mkV "บันทึกข้อมูล" | mkV "นำไปสู่ที่ปลอดภัย" | mkV "บันทึกข้อมูลลงคอมพิวเตอร์" | mkV "สงวน" | mkV "เก็บ" | mkV "รักษา" | mkV "ไถ่บาป" | mkV "ประหยัด" | mkV "ป้องกัน" | mkV "ช่วยชีวิต" | mkV "ช่วยเหลือ" | mkV "เก็บรักษา" | mkV "ช่วยให้ปลอดภัย" ; -- src=panlex
lin save_V = mkV "จอง" | mkV "เซฟ" | mkV "บรรเทา" | mkV "เซฟงาน" | mkV "จัดเก็บ" | mkV "ประหยัด" | mkV "เซฟไฟล์" | mkV "ช่วยชีวิต" | mkV "บันทึกข้อมูล" | mkV "นำไปสู่ที่ปลอดภัย" | mkV "บันทึกข้อมูลลงคอมพิวเตอร์" | mkV "สงวน" | mkV "เก็บ" | mkV "รักษา" | mkV "ไถ่บาป" | mkV "ประหยัด" | mkV "ป้องกัน" | mkV "ช่วยชีวิต" | mkV "ช่วยเหลือ" | mkV "เก็บรักษา" | mkV "ช่วยให้ปลอดภัย" ; -- src=panlex
lin throughout_Prep = mkPrep "ทุกขณะ" | mkPrep "ทุกจุด" | mkPrep "โดยตลอด" | mkPrep "ทุกหนทุกแห่ง" | mkPrep "ตั้งแต่ต้นจนจบ" ; -- src=panlex
lin design_V2 = mkV2 "ดีไซน์" ; ---- | mkV "ตั้งใจ" | mkV "ออกแบบ" | mkV "คิด" | mkV "กําหนด" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "ประสงค์" | mkV "ประดิษฐ์" | mkV "มุ่งหมาย" ; -- src=panlex
lin design_V = mkV "ดีไซน์" | mkV "ตั้งใจ" | mkV "ออกแบบ" | mkV "คิด" | mkV "กําหนด" | mkV "วางแผน" | mkV "ออกแบบ" | mkV "ประสงค์" | mkV "ประดิษฐ์" | mkV "มุ่งหมาย" ; -- src=panlex
lin suddenly_Adv = variants{} ; -- 
lin brother_N = mkN "คู่หู" | mkN "พี่ชาย" | mkN "บั๊ดดี้" | mkN "เพื่อนคู่หู" | mkN "ภราดร" | mkN "พี่ชาย" | mkN "น้องชาย" | mkN "บาทหลวง" | mkN "เจษฎาจารย์" | mkN "เพื่อนร่วมงาน" | mkN "บุคคลร่วมอาชีพ" | mkN "พี่น้องร่วมชาติ" | mkN "พี่ชายหรือน้องชาย" ; -- src=panlex
lin improve_V2 = mkV2 "ดีขึ้น" ; ---- | mkV "ปรับปรุง" | mkV "ทำให้ดีขึ้น" | mkV "ทุเลา" | mkV "ดีขึ้น" | mkV "ปรับปรุง" | mkV "ทําให้ดีขึ้น" ; -- src=panlex
lin improve_V = mkV "ดีขึ้น" | mkV "ปรับปรุง" | mkV "ทำให้ดีขึ้น" | mkV "ทุเลา" | mkV "ดีขึ้น" | mkV "ปรับปรุง" | mkV "ทําให้ดีขึ้น" ; -- src=panlex
lin avoid_VV = variants{} ; -- 
lin avoid_V2 = variants{} ; -- 
lin wonder_VQ = mkVQ (regV (thword "ประ" "หลาด" "ใจ")) ; ----
lin wonder_V = mkV "ทึ่ง" | mkV "สงสัย" | mkV "ประหลาดใจ" | mkV "กังขา" | mkV "งงงวย" | mkV "ฉงนใจ" | mkV "สงสัย" | mkV "ข้องใจ" | mkV "รู้สึกพิศวง" | mkV "รู้สึกประหลาดใจ" ; -- src=panlex
lin tend_VV = variants{} ; -- 
lin tend_V2 = variants{} ; -- 
lin title_N = mkN "โฉนด" | mkN "สิทธิ์" | mkN "ไตเติ้ล" | mkN "การแสดงสิทธิ์" | mkN "ความเป็นผู้ชนะ" | mkN "ตำแหน่งชนะเลิศ" | mkN "หัวข้อ" | mkN "คําเรียก" | mkN "ชื่อเรียก" | mkN "หัวเรื่อง" | mkN "กรรมสิทธิ์" | mkN "ชื่อเรื่อง" | mkN "ชื่อหนังสือ" | mkN "ตําแหน่งแชมป์" | mkN "สิทธิครอบครอง" | mkN "ปกในของหนังสือ" | mkN "ตําแหน่งชนะเลิศ" | mkN "ยศฐาบรรดาศักดิ์" | mkN "สิทธิการเป็นเจ้าของ" | mkN "ความบริสุทธิ์ของทองคํา" | mkN "หลักฐานแสดงกรรมสิทธิ์สิทธิ" | mkN "กรรมสิทธิ์ในอสังหาริมทรัพย์" | mkN "คําบรรยายข้างใต้ของภาพยนตร์หรือโทรทัศน์" ; -- src=panlex
lin hotel_N = mkN "ร.ร." | mkN "รร." | mkN "โรงแรม" | mkN "โฮเต็ล" | mkN "โรงแรม" ; -- src=panlex
lin aspect_N = mkN "มุมมอง" | mkN "สีหน้า" | mkN "ทิวทัศน์" | mkN "การ์ณลักษณะ" | mkN "การแสดงสีหน้า" | mkN "มุม" | mkN "ด้าน" | mkN "ทิศทาง" | mkN "มุมมอง" | mkN "รูปการ" | mkN "ลักษณะ" | mkN "แง่มุม" | mkN "ที่ตั้ง" | mkN "รูปลักษณ์" | mkN "หลักเกณฑ์" | mkN "ความคิดเห็น" | mkN "รูปร่างหน้าตา" | mkN "ด้านข้างหรือผิวหน้าด้านที่กําลังมอง" ; -- src=panlex
lin increase_N = mkN "การเพิ่มขึ้น" | mkN "การทำให้เพิ่มขึ้น" | mkN "การขยาย" | mkN "การงอกเงย" | mkN "การเพิ่มขึ้น" | mkN "จํานวนที่เพิ่มขึ้น" ; -- src=panlex
lin help_N = mkN "ผช." | mkN "ผู้ช่วย" | mkN "การบริการ" | mkN "ผู้สนับสนุน" | mkN "การช่วยเหลือ" | mkN "ความช่วยเหลือ" | mkN "การช่วย" | mkN "การสนับสนุน" | mkN "การส่งเสริม" | mkN "การเกื้อกูล" | mkN "การช่วยเหลือ" | mkN "คนที่ช่วยเหลือ" | mkN "สิ่งที่ช่วยเหลือ" ; -- src=panlex
lin industrial_A = mkA "อุตสาหกรรม" | mkA "ทางอุตสาหกรรม" | mkA "ขยัน" | mkA "อุตสาหะ" | mkA "หมั่นเพียร" | mkA "เกี่ยวกับอุตสาหกรรม" ; -- src=panlex
lin express_V2 = variants{} ; -- 
lin summer_N = mkN "ฤดูร้อน" | mkN "หน้าร้อน" | mkN "ฤดูร้อน" | mkN "คิมหันต์" | mkN "หน้าร้อน" | mkN "ช่วงเวลาที่เฟื่องฟูที่สุด" | mkN "ช่วงเวลาที่มีความสุขที่สุด" ; -- src=panlex
lin determine_VV = mkVV "ตั้ง" ; ---- | mkV "กำหนด" | mkV "ค้นพบ" | mkV "ค้นคว้า" | mkV "ตัดสินใจ" | mkV "มีอิทธิพล" | mkV "ยุติ" | mkV "ระบุ" | mkV "กําหนด" | mkV "ตกลงใจ" | mkV "กระตุ้น" | mkV "สิ้นสุด" | mkV "ตัดสินใจ" | mkV "ลงความเห็น" | mkV "มีอิทธิพลต่อ" | mkV "มุ่งมั่นค้นหา" | mkV "ค้นความจริงอย่างแน่วแน่" ; -- src=panlex
lin determine_VS = mmkVS "ตั้ง" ; ---- | mkV "กำหนด" | mkV "ค้นพบ" | mkV "ค้นคว้า" | mkV "ตัดสินใจ" | mkV "มีอิทธิพล" | mkV "ยุติ" | mkV "ระบุ" | mkV "กําหนด" | mkV "ตกลงใจ" | mkV "กระตุ้น" | mkV "สิ้นสุด" | mkV "ตัดสินใจ" | mkV "ลงความเห็น" | mkV "มีอิทธิพลต่อ" | mkV "มุ่งมั่นค้นหา" | mkV "ค้นความจริงอย่างแน่วแน่" ; -- src=panlex
lin determine_V2V = mmkV2V "ตั้ง" ; ---- | mkV "กำหนด" | mkV "ค้นพบ" | mkV "ค้นคว้า" | mkV "ตัดสินใจ" | mkV "มีอิทธิพล" | mkV "ยุติ" | mkV "ระบุ" | mkV "กําหนด" | mkV "ตกลงใจ" | mkV "กระตุ้น" | mkV "สิ้นสุด" | mkV "ตัดสินใจ" | mkV "ลงความเห็น" | mkV "มีอิทธิพลต่อ" | mkV "มุ่งมั่นค้นหา" | mkV "ค้นความจริงอย่างแน่วแน่" ; -- src=panlex
lin determine_V2 = mkV2 "ตั้ง" ; ---- | mkV "กำหนด" | mkV "ค้นพบ" | mkV "ค้นคว้า" | mkV "ตัดสินใจ" | mkV "มีอิทธิพล" | mkV "ยุติ" | mkV "ระบุ" | mkV "กําหนด" | mkV "ตกลงใจ" | mkV "กระตุ้น" | mkV "สิ้นสุด" | mkV "ตัดสินใจ" | mkV "ลงความเห็น" | mkV "มีอิทธิพลต่อ" | mkV "มุ่งมั่นค้นหา" | mkV "ค้นความจริงอย่างแน่วแน่" ; -- src=panlex
lin determine_V = mkV "ตั้ง" | mkV "กำหนด" | mkV "ค้นพบ" | mkV "ค้นคว้า" | mkV "ตัดสินใจ" | mkV "มีอิทธิพล" | mkV "ยุติ" | mkV "ระบุ" | mkV "กําหนด" | mkV "ตกลงใจ" | mkV "กระตุ้น" | mkV "สิ้นสุด" | mkV "ตัดสินใจ" | mkV "ลงความเห็น" | mkV "มีอิทธิพลต่อ" | mkV "มุ่งมั่นค้นหา" | mkV "ค้นความจริงอย่างแน่วแน่" ; -- src=panlex
lin generally_Adv = mkAdv "โดยปกติ" | mkAdv "โดยทั่วไป" | mkAdv "อย่างกว้างๆ" | mkAdv "โดยส่วนใหญ่" | mkAdv "ส่วนมาก" | mkAdv "โดยปกติ" | mkAdv "โดยรวมๆ" | mkAdv "ส่วนใหญ่" | mkAdv "โดยทั่วไป" | mkAdv "ซึ่งไม่ได้เจาะจง" ; -- src=panlex
lin daughter_N = mkN "ธิดา" | mkN "บุตรี" | mkN "ลูกสาว" | mkN "กุลธิดา" | mkN "บุตรสาว" | mkN "พระธิดา" | mkN "ลูกหญิง" | mkN "บุตรหญิง" | mkN "ธิดา" | mkN "บุตรี" | mkN "ลูกสาว" ; -- src=panlex
lin exist_V = mkV "มีอยู่" | mkV "ดำรงอยู่" | mkV "สถิตอยู่" | mkV "ดำรงชีวิต" | mkV "มีอยู่" | mkV "มีชีวิต" | mkV "รอดชีวิต" | mkV "มีชีวิตอยู่" ; -- src=panlex
lin share_V2 = mkV2 "ร่วม" ; ---- | mkV "แชร์" | mkV "แบ่ง" | mkV "แบ่งกัน" | mkV "แบ่งปัน" | mkV "แบ่งให้" | mkV "แบ่งเค้ก" | mkV "มีส่วนแบ่ง" | mkV "แบ่งสรรปันส่วน" | mkV "แบ่ง" | mkV "แบ่งส่วน" | mkV "แบ่งเท่าๆ กัน" | mkV "มีส่วนแบ่ง" | mkV "ร่วมกันทํา" | mkV "ใช้ร่วมกัน" | mkV "แบ่งผลกําไร" | mkV "แบ่งสรรปันส่วน" | mkV "รับผิดชอบร่วมกัน" ; -- src=panlex
lin share_V = mkV "ร่วม" | mkV "แชร์" | mkV "แบ่ง" | mkV "แบ่งกัน" | mkV "แบ่งปัน" | mkV "แบ่งให้" | mkV "แบ่งเค้ก" | mkV "มีส่วนแบ่ง" | mkV "แบ่งสรรปันส่วน" | mkV "แบ่ง" | mkV "แบ่งส่วน" | mkV "แบ่งเท่าๆ กัน" | mkV "มีส่วนแบ่ง" | mkV "ร่วมกันทํา" | mkV "ใช้ร่วมกัน" | mkV "แบ่งผลกําไร" | mkV "แบ่งสรรปันส่วน" | mkV "รับผิดชอบร่วมกัน" ; -- src=panlex
lin baby_N = mkN (thword "เด็ก" "ทา" "รก") "คน" | {-pan-} mkN "ลูก" | mkN "ทารก" | mkN "น้อง" | mkN "เด็ก" | mkN "น้องสาว" | mkN "ลูกอ่อน" | mkN "น้องเล็ก" | mkN "เด็กทารก" | mkN "เด็กน้อย" | mkN "เด็กอ่อน" | mkN "เด็กแดงๆ" | mkN "เด็กแบเบาะ" | mkN "เด็กในท้อง" | mkN "ทารกในครรภ์" | mkN "เด็กในครรภ์" | mkN "เจ้าเนื้ออ่อน" | mkN "ลูกเด็กเล็กแดง" | mkN "แง" | mkN "ทารก" | mkN "เด็กทารก" | mkN "เด็กอ่อน" | mkN "เด็กแรกเกิด" | mkN "สัตว์แรกเกิด" | mkN "ลูกอ่อนของสัตว์" ; -- src=panlex
lin nearly_Adv = mkAdv "เกือบ" | mkAdv "จวนเจียน" | mkAdv "อย่างใกล้ชิด" | mkAdv "เกือบ" | mkAdv "ประมาณ" | mkAdv "ตระหนี่" | mkAdv "ใกล้ชิด" | mkAdv "ไม่ทั้งหมด" | mkAdv "เกือบเหมือน" | mkAdv "เกือบทั้งหมด" ; -- src=panlex
lin smile_V = mkV "ยิ้ม" | mkV "แย้มพระโอษฐ์" | mkV "ยิ้ม" | mkV "ยิ้มแย้ม" ; -- src=panlex
lin sorry_A = mkA "แสดงความเสียใจ" | mkA "เสียใจ" | mkA "เศร้าใจ" | mkA "ที่ขอโทษ" | mkA "น่าสงสาร" | mkA "น่าสมเพช" | mkA "ที่รู้สึกผิด" ; -- src=panlex
lin sea_N = mkN (thword "ทะ" "เล") | {-pan-} mkN "ทะเล" | mkN "มหาสมุทร" | mkN "ทะเล" | mkN "ทางทะเล" | mkN "ท้องทะเล" | mkN "น้ําทะเล" | mkN "น้ําเค็ม" | mkN "มหาสมุทร" | mkN "จํานวนมหาศาล" | mkN "คลื่นลมในทะเล" | mkN "เกี่ยวกับทะเล" | mkN "จํานวนเหลือล้น" ; -- src=panlex
lin skill_N = mkN "สกิล" | mkN "ทักษะ" | mkN "มีผล" | mkN "ฝีมือ" | mkN "ความชํานาญ" | mkN "ความสามารถ" | mkN "ความช่ําชอง" | mkN "เป็นประโยชน์" | mkN "ความเชี่ยวชาญ" ; -- src=panlex
lin claim_N = mkN "สิทธิ์" | mkN "การเรียกร้อง" | mkN "การแสดงสิทธิ์" | mkN "การเรียกร้องสิทธิ์" | mkN "การยืนยันข้อเท็จจริง" | mkN "การเรียกร้อง" ; -- src=panlex
lin treat_V2 = mkV2 "ทรีต" ; ---- | mkV "บำบัด" | mkV "รักษา" | mkV "เลี้ยง" | mkV "พิจารณา" | mkV "เยียวยา" | mkV "มีเนื้อหา" | mkV "บำบัดรักษา" | mkV "ปฏิบัติต่อ" | mkV "ให้การรักษา" | mkV "ให้ความเพลิดเพลิน" | mkV "รักษา" | mkV "จัดการ" | mkV "รับรอง" | mkV "เลี้ยง" | mkV "ซื้อให้" | mkV "ปฏิบัติ" | mkV "เกี่ยวกับ" | mkV "บําบัดรักษา" | mkV "ทําตามกระบวนการ" | mkV "ให้ความเพลิดเพลิน" ; -- src=panlex
lin treat_V = mkV "ทรีต" | mkV "บำบัด" | mkV "รักษา" | mkV "เลี้ยง" | mkV "พิจารณา" | mkV "เยียวยา" | mkV "มีเนื้อหา" | mkV "บำบัดรักษา" | mkV "ปฏิบัติต่อ" | mkV "ให้การรักษา" | mkV "ให้ความเพลิดเพลิน" | mkV "รักษา" | mkV "จัดการ" | mkV "รับรอง" | mkV "เลี้ยง" | mkV "ซื้อให้" | mkV "ปฏิบัติ" | mkV "เกี่ยวกับ" | mkV "บําบัดรักษา" | mkV "ทําตามกระบวนการ" | mkV "ให้ความเพลิดเพลิน" ; -- src=panlex
lin remove_V2 = mkV2 "พา" ; ---- | mkV "ยก" | mkV "ฆ่า" | mkV "ชำระ" | mkV "เก็บ" | mkV "เอาออก" | mkV "ฆาตกรรม" | mkV "ยิงทิ้ง" | mkV "ไม่อยู่" | mkV "เอาออกไป" | mkV "ทำให้หมดไป" | mkV "พ้นจากตำแหน่ง" | mkV "ออกจากตำแหน่ง" | mkV "ถอด" | mkV "ขจัด" | mkV "ย้าย" | mkV "ลบออก" | mkV "เอาออก" | mkV "ไล่ออก" | mkV "ล้างออก" | mkV "โยกย้าย" | mkV "ความห่าง" | mkV "นําออกไป" | mkV "ระยะห่าง" | mkV "ขจัดปัญหา" | mkV "ปลดตําแหน่ง" ; -- src=panlex
lin remove_V = mkV "พา" | mkV "ยก" | mkV "ฆ่า" | mkV "ชำระ" | mkV "เก็บ" | mkV "เอาออก" | mkV "ฆาตกรรม" | mkV "ยิงทิ้ง" | mkV "ไม่อยู่" | mkV "เอาออกไป" | mkV "ทำให้หมดไป" | mkV "พ้นจากตำแหน่ง" | mkV "ออกจากตำแหน่ง" | mkV "ถอด" | mkV "ขจัด" | mkV "ย้าย" | mkV "ลบออก" | mkV "เอาออก" | mkV "ไล่ออก" | mkV "ล้างออก" | mkV "โยกย้าย" | mkV "ความห่าง" | mkV "นําออกไป" | mkV "ระยะห่าง" | mkV "ขจัดปัญหา" | mkV "ปลดตําแหน่ง" ; -- src=panlex
lin concern_N = mkN "กิจการ" | mkN "ธุรกิจ" | mkN "สิ่งสำคัญ" | mkN "องค์กรธุรกิจ" | mkN "ความวิตกกังวล" | mkN "ความกังวล" | mkN "เรื่องราว" | mkN "ความสัมพันธ์" | mkN "เรื่องที่สําคัญกับบุคคลหนึ่ง" ; -- src=panlex
lin university_N = placeN (thword "มหา" "วิท" "ยา" "ลัย") | {-pan-} mkN "ม." | mkN "มอ" | mkN "ยู" | mkN "มหาลัย" | mkN "มหาวิทยาลัย" | mkN "ยูนิเวอร์ซิตี้" | mkN "มหาวิทยาลัย" ; -- src=panlex
lin left_A = mkA "ซ้าย" | mkA "ซ้าย" | mkA "ทางซ้าย" | mkA "ปีกซ้าย" | mkA "มือซ้าย" | mkA "ข้างซ้าย" | mkA "ด้านซ้าย" | mkA "การหันซ้าย" | mkA "ทางซ้ายมือ" | mkA "สิ่งที่อยู่ทางซ้ายมือ" ; -- src=panlex
lin dead_A = mkA "ตาย" | mkA "ร้าง" | mkA "เสีย" | mkA "ที่สงบแล้ว" | mkA "ซึ่งไร้ชีวิต" | mkA "ดับ" | mkA "ตรง" | mkA "ตาย" | mkA "ทื่อ" | mkA "นิ่ง" | mkA "สงัด" | mkA "เสีย" | mkA "จริง ๆ" | mkA "ซบเซา" | mkA "จืดชืด" | mkA "สาบสูญ" | mkA "ตายแล้ว" | mkA "ทั้งหมด" | mkA "สมบูรณ์" | mkA "สูญสิ้น" | mkA "เต็มที่" | mkA "แท้จริง" | mkA "แน่นิ่ง" | mkA "แม่นยํา" | mkA "กะทันหัน" | mkA "สงบเงียบ" | mkA "เฉื่อยชา" | mkA "แห้งแล้ง" | mkA "ราวกับตาย" | mkA "สูญพันธุ์" | mkA "อยู่นิ่งๆ" | mkA "เมื่อยล้า" | mkA "เหมือนตาย" | mkA "ซึ่งหมดแรง" | mkA "ถึงแก่กรรม" | mkA "เกียจคร้าน" | mkA "เงียบเชียบ" | mkA "เงื่องหงอย" | mkA "เสื่อมสภาพ" | mkA "เหนื่อยมาก" | mkA "ไม่มีชีวิต" | mkA "ซึ่งสูญสิ้น" | mkA "ซึ่งแม่นยํา" | mkA "ซึ่งไม่พลาด" | mkA "สิ้นลมหายใจ" | mkA "โดยสิ้นเชิง" | mkA "ซึ่งหยุดนิ่ง" | mkA "เหน็ดเหนื่อย" | mkA "ซึ่งตายไปแล้ว" | mkA "ซึ่งไม่ทํางาน" | mkA "ซึ่งไม่ไหวติง" | mkA "ซึ่งไม่ตอบสนอง" | mkA "ซึ่งไม่มีชีวิต" | mkA "ซึ่งเลิกใช้แล้ว" | mkA "ราวกับสิ้นชีวิต" | mkA "ไม่มีความรู้สึก" | mkA "ซึ่งไม่มีผิดพลาด" | mkA "เหมือนไม่มีชีวิต" | mkA "ซึ่งไม่เคลื่อนไหว" | mkA "ซึ่งไร้ความรู้สึก" | mkA "ซึ่งไม่มีเสียงก้อง" ; -- src=panlex
lin discussion_N = mkN "การอภิปราย" | mkN "การสนทนา" | mkN "การประชุม" | mkN "การอภิปราย" | mkN "การปรึกษาหารือ" | mkN "การโต้แย้งหาเหตุผล" | mkN "การแลกเปลี่ยนความเห็น" ; -- src=panlex
lin specific_A = mkA "ระบุ" | mkA "พิเศษ" | mkA "กําหนด" | mkA "เจาะจง" | mkA "จําเพาะ" | mkA "ตามชนิด" | mkA "โดยเฉพาะ" | mkA "เฉพาะเจาะจง" ; -- src=panlex
lin customerMasc_N = variants{} ; -- 
lin box_N = mkN "คอก" | mkN "กล่อง" | mkN "บ็อกซ์" | mkN "ต้นบ็อกซ์" | mkN "การตบบ้องหู" | mkN "ที่นั่งคนขับ" | mkN "เก้าอี้คนขับ" | mkN "ต้นบ็อกซ์วู้ด" | mkN "จำนวนเต็มกล่อง" | mkN "ที่นั่งของคนขับ" | mkN "รูปกล่องสี่เหลี่ยม" | mkN "คอก" | mkN "ลัง" | mkN "หีบ" | mkN "กลัก" | mkN "กล่อง" | mkN "การตบ" | mkN "การตี" | mkN "การต่อย" | mkN "ช่องสี่เหลี่ยม" | mkN "ต้นไม้ชนิดหนึ่ง" | mkN "ที่นั่งคนขับรถม้า" | mkN "คอกสําหรับคนดูในโรงละคร" | mkN "ต้นไม้ชนิดหนึ่งใช้ทําเครื่องแกะสลักและไม้บรรทัด" ; -- src=panlex
lin outside_Prep = mkPrep "นอก" | mkPrep "นอกจาก" | mkPrep "ภายนอก" | mkPrep "ด้านนอก" ; -- src=panlex
lin state_VS = variants{} ; -- 
lin state_V2 = variants{} ; -- 
lin conference_N = mkN "ลีก" | mkN "การปรึกษาหารือ" | mkN "การอภิปรายกลุ่มย่อย" | mkN "การประชุม" | mkN "การสัมมนา" | mkN "สมาคมทีมกีฬา" ; -- src=panlex
lin whole_N = mkN "เต็ม" | mkN "ล้วน ๆ" | mkN "ครบถ้วน" | mkN "ทั้งหมด" | mkN "สมบูรณ์" | mkN "ทั้งสิ้น" | mkN "พร้อมมูล" | mkN "ไม่เจือปน" | mkN "ไม่บุบสลาย" | mkN "สิ่งที่ครบถ้วน" | mkN "สิ่งที่สมบูรณ์" | mkN "ไม่มีการแบ่งแยก" ; -- src=panlex
lin total_A = mkA "เต็ม" | mkA "ทั้งหมด" | mkA "สมบูรณ์" | mkA "เต็มที่" | mkA "โดยสมบูรณ์" ; -- src=panlex
lin profit_N = mkN "กำไร" | mkN "ผลกำไร" | mkN "กำไรสุทธิ" | mkN "รายได้สุทธิ" | mkN "รายได้สุทธิื" | mkN "กําไร" | mkN "มีผลดี" | mkN "ผลกําไร" | mkN "เอื้อผล" | mkN "ผลตอบแทน" | mkN "ผลประโยชน์" | mkN "ได้ประโยชน์" | mkN "ข้อได้เปรียบ" | mkN "ได้เปรียบเทียบ" ; -- src=panlex
lin division_N = variants{} ; -- 
lin division_3_N = variants{} ; -- 
lin division_2_N = variants{} ; -- 
lin division_1_N = variants{} ; -- 
lin throw_V2 = mkV2 (thword "ขว้าง") ;
lin throw_V = mkV "ปา" | mkV "จัด" | mkV "ทอย" | mkV "วาง" | mkV "ส่ง" | mkV "เปิด" | mkV "กำจัด" | mkV "ขว้าง" | mkV "ด่าทอ" | mkV "ขว้างปา" | mkV "พุ่งตัว" | mkV "เขวี้ยง" | mkV "โยนทิ้ง" | mkV "ทำให้ฉงน" | mkV "ทำให้สับสน" | mkV "หมุนแท่นปั้น" | mkV "ส่งไปข้างหน้า" | mkV "ทำให้รู้สึกสับสน" | mkV "ปา" | mkV "ฉาย" | mkV "ซัด" | mkV "โยน" | mkV "ขว้าง" | mkV "ไล่ออก" | mkV "ทําให้งง" | mkV "ปั่นด้าย" | mkV "ทําให้สับสน" | mkV "เหวี่ยงหมัด" | mkV "ทําให้แปลกใจ" | mkV "ระเบิดอารมณ์" | mkV "ทําให้เป็นรูป" | mkV "ทําให้ออกไปจาก" | mkV "ปั้นให้เป็นรูปร่าง" | mkV "จ้องมองอย่างฉับพลัน" | mkV "ทําให้หมดสถานภาพจาก" | mkV "เป็นเจ้าภาพงานเลี้ยง" | mkV "ทําให้เคลื่อนที่อย่างเร่งรีบ" ; -- src=panlex
lin procedure_N = mkN "โพรเซส" | mkN "กรรมวิธี" | mkN "กระบวนการ" | mkN "โปรแกรมย่อย" | mkN "วิธีดำเนินการ" | mkN "แนวทาง" | mkN "ขบวนการ" | mkN "ขั้นตอน" | mkN "วิธีการ" | mkN "กระบวนการ" | mkN "กําหนดการ" | mkN "ระเบียบการ" | mkN "การดําเนินงาน" | mkN "วิธีการปฏิบัติ" ; -- src=panlex
lin fill_V2 = mkV2 "เติม" ; ---- | mkV "เต็ม" | mkV "บรรจุ" | mkV "พึงพอใจ" | mkV "เติมเต็ม" | mkV "ได้บรรจุ" | mkV "ทำให้เต็ม" | mkV "ถม" | mkV "กลบ" | mkV "ใส่" | mkV "กรอก" | mkV "เติม" | mkV "บรรจุ" | mkV "เพิ่ม" | mkV "ว่าจ้าง" | mkV "บันทึกลง" | mkV "แต่งตั้ง" | mkV "ทําให้เต็ม" | mkV "เติมในช่องว่าง" | mkV "เลือกให้ดํารงตําแหน่ง" ; -- src=panlex
lin fill_V = mkV "เติม" | mkV "เต็ม" | mkV "บรรจุ" | mkV "พึงพอใจ" | mkV "เติมเต็ม" | mkV "ได้บรรจุ" | mkV "ทำให้เต็ม" | mkV "ถม" | mkV "กลบ" | mkV "ใส่" | mkV "กรอก" | mkV "เติม" | mkV "บรรจุ" | mkV "เพิ่ม" | mkV "ว่าจ้าง" | mkV "บันทึกลง" | mkV "แต่งตั้ง" | mkV "ทําให้เต็ม" | mkV "เติมในช่องว่าง" | mkV "เลือกให้ดํารงตําแหน่ง" ; -- src=panlex
lin king_N = mkN (thword "พระ" "รา" "ชา") (thword "พระ" "องด์") | {-pan-} mkN "ขุน" | mkN "คิง" | mkN "ฮอส" | mkN "จ้าว" | mkN "ราชา" | mkN "เจ้า" | mkN "ราชินี" | mkN "พระราชา" | mkN "กษัตริย์" | mkN "ผู้นำธุรกิจ" | mkN "พระมหากษัตริย์" | mkN "พระเจ้าอยู่หัว" | mkN "พระเจ้าแผ่นดิน" | mkN "นักธุรกิจชั้นนำ" | mkN "บุคคลผู้มีอำนาจ" | mkN "ภูมิ" | mkN "ราชา" | mkN "เผ่า" | mkN "บพิตร" | mkN "ประมุข" | mkN "ผู้นํา" | mkN "พระราชา" | mkN "กษัตริย์" | mkN "กษัตริย์์" | mkN "เจ้าแผ่นดิน" | mkN "พระมหากษัตริย์" | mkN "พระเจ้าแผ่นดิน" | mkN "ผู้บริหารสูงสุด" | mkN "หมากรุกตัวพระราชา" | mkN "ผู้ที่มีอํานาจสูงสุด" ; -- src=panlex
lin assume_VS = variants{} ; -- 
lin assume_V2 = variants{} ; -- 
lin image_N = mkN "ภาพ" | mkN "หุ่น" | mkN "ต้นแบบ" | mkN "ภาพพจน์" | mkN "แบบอย่าง" | mkN "คู่เหมือน" | mkN "หุ่นจำลอง" | mkN "ภาพ" | mkN "ภาพถอด" | mkN "มโนภาพ" | mkN "รูปภาพ" | mkN "รูปแทน" | mkN "รูปแบบ" | mkN "ภาพถ่าย" | mkN "ภาพบนจอ" | mkN "ภาพพจน์" | mkN "ภาพในใจ" | mkN "รูปถ่าย" | mkN "รูปบูชา" | mkN "รูปปั้น" | mkN "สิ่งแทน" | mkN "คิดคะนึง" | mkN "จินตนาการ" | mkN "ภาพนึกคิด" | mkN "รูปจําลอง" | mkN "สะท้อนภาพ" | mkN "สัญลักษณ์" | mkN "เหมือนกับ" | mkN "นึกภาพในใจ" | mkN "เครื่องหมาย" | mkN "ภาพในความคิด" | mkN "แสดงเครื่องหมาย" | mkN "สิ่งที่ปรากฎขึ้น" ; -- src=panlex
lin oil_N = mkN (thword "น้ำมัน") | {-pan-} mkN "ออยล์" | mkN "น้ำมัน" | mkN "สีน้ำมัน" | mkN "น้ำมันดิบ" | mkN "น้ำมันพืช" | mkN "น้ำมัน" | mkN "น้ํามัน" | mkN "น้ํามันดิบ" | mkN "น้ํามันพืช" | mkN "น้ํามันปิโตรเลียม" ; -- src=panlex ----?
lin obviously_Adv = variants{} ; -- 
lin unless_Subj = variants{} ; -- 
lin appropriate_A = mkA "ซึ่งเหมาะ" | mkA "พอเหมาะ" | mkA "เข้ากัน" | mkA "เหมาะสม" ; -- src=panlex
lin circumstance_N = mkN "ปัจจัย" | mkN "พิธีการ" | mkN "เงื่อนไข" | mkN "สภาวะแวดล้อม" | mkN "ข้อมูลแวดล้อม" | mkN "สถานการณ์แวดล้อม" | mkN "เหตุการณ์แวดล้อม" | mkN "โชค" | mkN "โอกาส" | mkN "เหตุการณ์" | mkN "สภาวะแวดล้อม" ; -- src=panlex
lin military_A = mkA "ทหาร" | mkA "ทางการทหาร" | mkA "แห่งสงคราม" | mkA "ของทหาร" | mkA "ทางทหาร" | mkA "เกี่ยวกับทหาร" | mkA "เกี่ยวกับสงคราม" ; -- src=panlex
lin proposal_N = mkN "ข้อเสนอ" | mkN "การเสนอความคิดเห็น" | mkN "แผน" | mkN "แนวทาง" | mkN "การเสนอ" | mkN "ข้อเสนอ" | mkN "โครงการ" | mkN "การขอแต่งงาน" | mkN "คําขอแต่งงาน" ; -- src=panlex
lin mention_VS = mmkVS "อ้าง" ; ---- | mkV "แสดงทัศนะ" | mkV "กล่าวสดุดี" | mkV "ออกความเห็น" | mkV "แสดงความคิดเห็น" | mkV "พูดถึง" | mkV "อ้างถึง" | mkV "เอ่ยถึง" | mkV "กล่าวถึง" ; -- src=panlex
lin mention_V2 = mkV2 "อ้าง" ; ---- | mkV "แสดงทัศนะ" | mkV "กล่าวสดุดี" | mkV "ออกความเห็น" | mkV "แสดงความคิดเห็น" | mkV "พูดถึง" | mkV "อ้างถึง" | mkV "เอ่ยถึง" | mkV "กล่าวถึง" ; -- src=panlex
lin mention_V = mkV "อ้าง" | mkV "แสดงทัศนะ" | mkV "กล่าวสดุดี" | mkV "ออกความเห็น" | mkV "แสดงความคิดเห็น" | mkV "พูดถึง" | mkV "อ้างถึง" | mkV "เอ่ยถึง" | mkV "กล่าวถึง" ; -- src=panlex
lin client_N = mkN "ลูกค้า" | mkN "ลูกข่าย" | mkN "ลูกความ" | mkN "ผู้ซื้อสินค้าและบริการ" | mkN "คนไข้" | mkN "ลูกค้า" | mkN "ลูกความ" | mkN "คนซื้อของ" | mkN "ผู้พึ่งคนอื่น" ; -- src=panlex
lin sector_N = mkN "ด้าน" | mkN "ภาคส่วน" | mkN "เซกเตอร์" | mkN "เซคเตอร์" | mkN "เซ็กเตอร์" | mkN "รูปตัด" | mkN "เซ็กเตอร์" | mkN "เขตรับผิดชอบของทหาร" | mkN "รูปตัดที่อยู่ระหว่างเส้นรัศมี 2 เส้นกับส่วนของเส้นรอบวง" ; -- src=panlex
lin direction_N = mkN "ทาง" | mkN "คำสั่ง" | mkN "ทิศทาง" | mkN "คำแนะนำ" | mkN "การจดจ่อ" | mkN "การโฟกัส" | mkN "คำปรึกษา" | mkN "การจัดการ" | mkN "การแนะแนว" | mkN "ข้อชี้แนะ" | mkN "การนำทางไป" | mkN "การดำเนินการ" | mkN "การเพ่งสมาธิ" | mkN "การให้คำปรึกษา" | mkN "การเพ่งความสนใจ" | mkN "ทิศทาง" | mkN "การเล็ง" | mkN "คําสั่ง" | mkN "แนวโน้ม" | mkN "การบัญชา" | mkN "การควบคุม" | mkN "การจัดการ" | mkN "การชี้ทาง" | mkN "การมุ่งหมาย" | mkN "การจ่าหน้าซอง" | mkN "ชื่อและตําบลที่อยู่ของผู้รับ" ; -- src=panlex
lin admit_VS = mmkVS "จุ" ; ---- | mkV "ยอมรับ" | mkV "รองรับ" | mkV "เปิดรับ" | mkV "ยอมให้เข้า" | mkV "สามารถมีได้" | mkV "ให้เข้าร่วม" | mkV "ปล่อยให้เข้า" | mkV "อนุญาตให้ร่วม" | mkV "อนุญาตให้เข้า" | mkV "รับ" | mkV "ยอมรับ" | mkV "สารภาพ" | mkV "ยอมรับผิด" | mkV "รับสารภาพ" | mkV "ยอมให้เข้า" | mkV "รับเข้าไว้" | mkV "ยอมให้เข้าไป" | mkV "อนุญาตให้เข้า" | mkV "ปล่อยให้เข้าไป" | mkV "ยอมรับความจริง" | mkV "มีที่ว่างสําหรับ" ; -- src=panlex
lin admit_V2 = mkV2 "จุ" ; ---- | mkV "ยอมรับ" | mkV "รองรับ" | mkV "เปิดรับ" | mkV "ยอมให้เข้า" | mkV "สามารถมีได้" | mkV "ให้เข้าร่วม" | mkV "ปล่อยให้เข้า" | mkV "อนุญาตให้ร่วม" | mkV "อนุญาตให้เข้า" | mkV "รับ" | mkV "ยอมรับ" | mkV "สารภาพ" | mkV "ยอมรับผิด" | mkV "รับสารภาพ" | mkV "ยอมให้เข้า" | mkV "รับเข้าไว้" | mkV "ยอมให้เข้าไป" | mkV "อนุญาตให้เข้า" | mkV "ปล่อยให้เข้าไป" | mkV "ยอมรับความจริง" | mkV "มีที่ว่างสําหรับ" ; -- src=panlex
lin admit_V = mkV "จุ" | mkV "ยอมรับ" | mkV "รองรับ" | mkV "เปิดรับ" | mkV "ยอมให้เข้า" | mkV "สามารถมีได้" | mkV "ให้เข้าร่วม" | mkV "ปล่อยให้เข้า" | mkV "อนุญาตให้ร่วม" | mkV "อนุญาตให้เข้า" | mkV "รับ" | mkV "ยอมรับ" | mkV "สารภาพ" | mkV "ยอมรับผิด" | mkV "รับสารภาพ" | mkV "ยอมให้เข้า" | mkV "รับเข้าไว้" | mkV "ยอมให้เข้าไป" | mkV "อนุญาตให้เข้า" | mkV "ปล่อยให้เข้าไป" | mkV "ยอมรับความจริง" | mkV "มีที่ว่างสําหรับ" ; -- src=panlex
lin though_Adv = mkAdv "แต่ทว่า" | mkAdv "ถึงกระนั้น" | mkAdv "แต่กระนั้น" | mkAdv "อย่างไรก็ดี" | mkAdv "เพียงแต่ว่า" | mkAdv "อย่างไรก็ตาม" ; -- src=panlex
lin replace_V2 = variants{} ; -- 
lin basic_A = mkA "พื้นฐาน" | mkA "ซึ่งเป็นพื้นฐาน" | mkA "ธรรมดา" | mkA "มูลฐาน" | mkA "รากฐาน" | mkA "สําคัญ" | mkA "พื้นฐาน" | mkA "เป็นด่าง" | mkA "อันดับแรก" | mkA "ลักษณะด่าง" | mkA "สําคัญที่สุด" | mkA "จําเป็นที่สุด" ; -- src=panlex
lin hard_Adv = variants{} ; -- 
lin instance_N = mkN "เคส" | mkN "กรณี" | mkN "ตัวอย่าง" | mkN "ราย" | mkN "กรณี" | mkN "คราว" | mkN "ประการ" | mkN "ตัวอย่าง" | mkN "ยกอุทาหรณ์" | mkN "การฟ้องร้องคดี" ; -- src=panlex
lin sign_N = mkN "ซิก" | mkN "ป้าย" | mkN "ราศี" | mkN "นิมิต" | mkN "สัญญะ" | mkN "อาการ" | mkN "สัญญาณ" | mkN "สัญลักษณ์" | mkN "สภาพมีขั้ว" | mkN "เครื่องหมาย" | mkN "แผ่นป้ายโฆษณา" | mkN "เครื่องหมายคำนวณ" | mkN "ลาง" | mkN "ป้าย" | mkN "นิมิต" | mkN "อาการ" | mkN "สัญญาณ" | mkN "ภาษามือ" | mkN "ภาษาใบ้" | mkN "รอยเท้า" | mkN "ร่องรอย" | mkN "เซ็นชื่อ" | mkN "การบอกใบ้" | mkN "ตัวบ่งชี้" | mkN "สัญลักษณ์" | mkN "ภาษาท่าทาง" | mkN "เครื่องหมาย" | mkN "เขียนสัญลักษณ์" | mkN "แสดงอากัปกิริยา" | mkN "เขียนเครื่องหมาย" | mkN "ติดต่อกันด้วยสัญญาณ" | mkN "ทําเครื่องหมายกางเขน" ; -- src=panlex
lin original_A = mkA "สด" | mkA "เดิม" | mkA "ใหม่" | mkA "ต้นตอ" | mkA "รากฐาน" | mkA "ต้นฉบับ" | mkA "มูลเหตุ" | mkA "เป็นฐาน" | mkA "เป็นราก" | mkA "แปลกใหม่" | mkA "แรกเริ่ม" | mkA "เป็นของแท้" | mkA "เป็นครั้งแรก" | mkA "ที่สร้างสรรค์" | mkA "ที่เป็นอันแรก" | mkA "ซึ่งมีมาแต่เดิม" | mkA "ซึ่งเป็นต้นฉบับ" | mkA "ซึ่งเป็นแบบฉบับ" ; -- src=panlex
lin successful_A = mkA "มีชัยชนะ" | mkA "ประสบชัยชนะ" | mkA "มีผลสําเร็จ" | mkA "เป็นผลสําเร็จ" | mkA "ประสบผลสําเร็จ" | mkA "ประสบความสําเร็จ" ; -- src=panlex
lin okay_Adv = mkAdv "โอเค" | mkAdv "อย่างน่าพอใจ" ; -- src=panlex
lin reflect_V2 = mkV2 "ขบคิด" ; ---- | mkV "ครุ่นคิด" | mkV "คิดทบทวน" | mkV "ตรึกตรอง" | mkV "ใคร่ครวญ" | mkV "ไตร่ตรอง" | mkV "สะท้อนภาพ" | mkV "สะท้อนแสง" | mkV "ครุ่นคิด" | mkV "ส่องกลับ" | mkV "ไตร่ตรอง" | mkV "สะท้อนกลับ" | mkV "ส่อให้เห็น" | mkV "แสดงให้เห็น" | mkV "สะท้อนให้เห็น" ; -- src=panlex
lin reflect_V = mkV "ขบคิด" | mkV "ครุ่นคิด" | mkV "คิดทบทวน" | mkV "ตรึกตรอง" | mkV "ใคร่ครวญ" | mkV "ไตร่ตรอง" | mkV "สะท้อนภาพ" | mkV "สะท้อนแสง" | mkV "ครุ่นคิด" | mkV "ส่องกลับ" | mkV "ไตร่ตรอง" | mkV "สะท้อนกลับ" | mkV "ส่อให้เห็น" | mkV "แสดงให้เห็น" | mkV "สะท้อนให้เห็น" ; -- src=panlex
lin aware_A = mkA "สำเหนียก" | mkA "ทราบ" | mkA "รู้ตัว" | mkA "รู้สึกตัว" | mkA "ตระหนักรู้" ; -- src=panlex
lin measure_N = mkN "จำนวน" | mkN "การวัด" | mkN "ปริมาณ" | mkN "ไม้วัด" | mkN "มาตรฐาน" | mkN "ร่างกฎหมาย" | mkN "ร่างพระราชบัญญัติ" | mkN "จังหวะในฉันทลักษณ์" | mkN "กะ" | mkN "ขนาด" | mkN "ปรับ" | mkN "หาค่า" | mkN "กฎหมาย" | mkN "การวัด" | mkN "จังหวะ" | mkN "จํานวน" | mkN "ประมาณ" | mkN "ปริมาณ" | mkN "ประเมิน" | mkN "มาตรการ" | mkN "น้ําหนัก" | mkN "หน่วยวัด" | mkN "การตวงวัด" | mkN "ระบบการวัด" | mkN "วิธีตัดสิน" | mkN "เครื่องมือ" | mkN "เครื่องวัด" | mkN "หน่วยการวัด" | mkN "หน่วยเมตริก" | mkN "เป็นวิธีการ" | mkN "พระราชบัญญัติ" | mkN "วิธีการประเมิน" | mkN "ปริมาณที่วัดได้" | mkN "ปริมาณที่แน่นอน" | mkN "ร่างพระราชบัญญัติ" ; -- src=panlex
lin attitude_N = mkN "ท่า" | mkN "ทรรศนะ" | mkN "ท่าทาง" | mkN "ทัศนคติ" | mkN "ท่วงท่า" | mkN "ทัศนะ" | mkN "ท่าที" | mkN "ท่าทาง" | mkN "เจตคติ" | mkN "ทัศนคติ" | mkN "ความเห็น" | mkN "การวางตัว" | mkN "ความคิดเห็น" | mkN "ท่าในการบิน" | mkN "กิริยาท่าทาง" | mkN "ลักษณะท่าทาง" ; -- src=panlex
lin disease_N = mkN "โรค" | mkN "โรค" | mkN "ปัญหา" | mkN "ภัยสังคม" | mkN "ความเจ็บป่วย" | mkN "โรคภัยไข้เจ็บ" | mkN "การเจ็บไข้ได้ป่วย" ; -- src=panlex
lin exactly_Adv = variants{} ; -- 
lin above_Adv = mkAdv "เหนือ" | mkAdv "ข้างบน" | mkAdv "ด้านบน" | mkAdv "ข้างต้น" | mkAdv "กว่า" | mkAdv "เกิน" | mkAdv "เหนือ" | mkAdv "สูงกว่า" | mkAdv "พ้นเหลือ" | mkAdv "เบื้องต้น" | mkAdv "เหนือกว่า" | mkAdv "ที่มีอํานาจมากกว่า" ; -- src=panlex
lin commission_N = mkN "งาน" | mkN "คำสั่ง" | mkN "ภารกิจ" | mkN "มิสชั่น" | mkN "ประจำการ" | mkN "คณะผู้แทน" | mkN "คณะกรรมการ" | mkN "กลุ่มผู้แทน" | mkN "การปฎิบัติการ" | mkN "การก่ออาชญากรรม" | mkN "ค่านายหน้า" | mkN "ค่าคอมมิชชั่น" | mkN "อํานาจที่จะทํา" | mkN "งานที่รับผิดชอบ" ; -- src=panlex
lin intend_VV = variants{} ; -- 
lin beyond_Prep = mkPrep "พ้น" | mkPrep "หลัง" | mkPrep "โพ้น" | mkPrep "ถัดไป" | mkPrep "เหนือ" | mkPrep "ไกลจาก" | mkPrep "มากกว่า" | mkPrep "ถัดออกไป" | mkPrep "เลยออกไป" | mkPrep "เหนือกว่า" | mkPrep "อยู่ทางนั้น" ; -- src=panlex
lin seat_N = mkN "ก้น" | mkN "ตูด" | mkN "ที่นั่ง" | mkN "บั้นท้าย" | mkN "ก้น" | mkN "วัง" | mkN "ตั่ง" | mkN "แท่น" | mkN "สะโพก" | mkN "แหล่ง" | mkN "อานม้า" | mkN "ใจกลาง" | mkN "คฤหาสน์" | mkN "ที่ตั้ง" | mkN "ที่นั่ง" | mkN "ท่านั่ง" | mkN "ม้านั่ง" | mkN "เก้าอี้" | mkN "แท่นพัก" | mkN "ตําแหน่ง" | mkN "ทําเนียบ" | mkN "บั้นท้าย" | mkN "วิธีนั่ง" | mkN "ก้นกางเกง" | mkN "ศูนย์รวมอํานาจ" | mkN "ศูนย์กลางอํานาจ" ; -- src=panlex
lin presidentMasc_N = variants{} ; -- 
lin encourage_V2V = variants{} ; -- 
lin encourage_V2 = variants{} ; -- 
lin addition_N = mkN "การเพิ่มขึ้น" | mkN "สิ่งที่เพิ่มเข้าไป" | mkN "การบวก" | mkN "การเพิ่ม" | mkN "การเสริม" | mkN "การต่อเติม" | mkN "สิ่งที่เติม" | mkN "การเพิ่มเติม" | mkN "สิ่งที่เพิ่ม" | mkN "สิ่งที่เสริม" | mkN "สิ่งที่เพิ่มเข้าไป" | mkN "ชื่อที่เพิ่มต่อท้ายชื่อนามสกุล" ; -- src=panlex
lin goal_N = mkN "โกล" | mkN "ประตู" | mkN "ที่หมาย" | mkN "หลักชัย" | mkN "เป้าหมาย" | mkN "การทำประตู" | mkN "การยิงประตู" | mkN "จุดหมายปลายทาง" | mkN "ประตู" | mkN "เป้าหมาย" | mkN "ความประสงค์" | mkN "จุดมุ่งหมาย" | mkN "ประตูฟุตบอล" | mkN "ความมุ่งหมาย" | mkN "จุดหมายปลายทาง" ; -- src=panlex
lin round_Prep = mkPrep "รอบๆ" ; -- src=panlex
lin miss_V2 = mkV2 "ขาด" ; ---- | mkV "ตกรถ" | mkV "พลาด" | mkV "ละเลย" | mkV "คิดถึง" | mkV "พลาดรถ" | mkV "ไม่เจอ" | mkV "ไม่โดน" | mkV "ไม่อยู่" | mkV "ระลึกถึง" | mkV "รำลึกถึง" | mkV "ไม่ทันรถ" | mkV "ยิงไม่โดน" | mkV "หนี" | mkV "คลาด" | mkV "พลาด" | mkV "ไม่พบ" | mkV "คิดถึง" | mkV "ทําพลาด" | mkV "ปรารถนา" | mkV "ไม่เห็น" | mkV "ขาดเรียน" | mkV "พลาดเป้า" | mkV "ไปไม่ทัน" | mkV "หยุดเรียน" | mkV "ไม่เข้าใจ" | mkV "ไม่ได้ยิน" | mkV "หลีกเลี่ยง" ; -- src=panlex
lin miss_V = mkV "ขาด" | mkV "ตกรถ" | mkV "พลาด" | mkV "ละเลย" | mkV "คิดถึง" | mkV "พลาดรถ" | mkV "ไม่เจอ" | mkV "ไม่โดน" | mkV "ไม่อยู่" | mkV "ระลึกถึง" | mkV "รำลึกถึง" | mkV "ไม่ทันรถ" | mkV "ยิงไม่โดน" | mkV "หนี" | mkV "คลาด" | mkV "พลาด" | mkV "ไม่พบ" | mkV "คิดถึง" | mkV "ทําพลาด" | mkV "ปรารถนา" | mkV "ไม่เห็น" | mkV "ขาดเรียน" | mkV "พลาดเป้า" | mkV "ไปไม่ทัน" | mkV "หยุดเรียน" | mkV "ไม่เข้าใจ" | mkV "ไม่ได้ยิน" | mkV "หลีกเลี่ยง" ; -- src=panlex
lin popular_A = mkA "ยอดนิยม" | mkA "พื้น ๆ" | mkA "ทั่วไป" | mkA "แบบธรรมดา" | mkA "ของประชาชน" | mkA "แบบทั่วๆไป" | mkA "เป็นที่นิยม" | mkA "เป็นที่ชื่นชอบ" | mkA "เป็นที่นิยมกัน" | mkA "เป็นที่แพร่หลาย" | mkA "เกี่ยวกับประชากร" | mkA "เป็นที่ยอมรับกัน" ; -- src=panlex
lin affair_N = mkN "วาระ" | mkN "เรื่องอื้อฉาว" | mkN "ควาสัมพันธ์ทางเพศ" | mkN "ความสัมพันธ์ฉันชู้สาว" | mkN "การงาน" | mkN "ธุรกิจ" | mkN "ราชการ" | mkN "เรื่อง" | mkN "งานชุมนุม" | mkN "เหตุการณ์" | mkN "เรื่องรัก ใคร่" | mkN "เรื่องส่วนตัว" | mkN "เรื่องอื้อฉาว" | mkN "ความสัมพันธ์เชิงชู้สาว" | mkN "เรื่องรักที่ไม่ถูกทํานองคลองธรรม" ; -- src=panlex
lin technique_N = mkN "เทคนิค" | mkN "ความช่ำชอง" | mkN "ฝีมือ" | mkN "ศิลปะ" | mkN "กลวิธี" | mkN "เทคนิค" | mkN "วิชาการ" | mkN "หลักวิชา" | mkN "ความสามารถพิเศษ" | mkN "ความสามารถทางเทคนิค" | mkN "วิธีการดึงดูดความสนใจ" ; -- src=panlex
lin respect_N = mkN "ความนับถือ" | mkN "ความน่าเคารพ" | mkN "ความน่านับถือ" | mkN "การแสดงความเคารพ" | mkN "ข้อ" | mkN "เคารพ" | mkN "คํานึง" | mkN "ประเด็น" | mkN "พิจารณา" | mkN "ความคารวะ" | mkN "ความเคารพ" | mkN "เกี่ยวกับ" | mkN "ความนับถือ" | mkN "ความยําเกรง" | mkN "สัมพันธ์กับ" | mkN "ความสัมพันธ์" | mkN "ความเอาใจใส่" | mkN "ความเกี่ยวข้อง" ; -- src=panlex
lin drop_V2 = mkV2 "ตก" ; ---- | mkV "ส่ง" | mkV "หยด" | mkV "แพ้" | mkV "ใช้" | mkV "จ่าย" | mkV "ทิ้ง" | mkV "กำจัด" | mkV "กินยา" | mkV "ตกลูก" | mkV "ละเลย" | mkV "เหยาะ" | mkV "ขนถ่าย" | mkV "คุกเข่า" | mkV "ต่ำทราม" | mkV "ลดระดับ" | mkV "โยนทิ้ง" | mkV "ทำให้ล้ม" | mkV "ทำให้หล่น" | mkV "พูดเกริ่น" | mkV "ให้พักงาน" | mkV "เสื่อมโทรม" | mkV "ให้หยุดงาน" | mkV "ตั้งเสียงต่ำ" | mkV "ห้อยต่องแต่ง" | mkV "จม" | mkV "ตก" | mkV "ลง" | mkV "ทิ้ง" | mkV "ย้อย" | mkV "ลดลง" | mkV "หยุด" | mkV "หล่น" | mkV "เลิก" | mkV "ปล่อย" | mkV "หย่อน" | mkV "แย่ลง" | mkV "น้อยลง" | mkV "ยกเลิก" | mkV "อ่อนแอ" | mkV "ทําแต้ม" | mkV "มองข้าม" | mkV "มองผ่าน" | mkV "โยนทิ้ง" | mkV "ทําคะแนน" | mkV "เลิกคบหา" | mkV "ส่งจดหมาย" | mkV "ทําเสียงต่ําลง" | mkV "ส่งของหรือผู้โดยสาร" ; -- src=panlex
lin drop_V = mkV "ตก" | mkV "ส่ง" | mkV "หยด" | mkV "แพ้" | mkV "ใช้" | mkV "จ่าย" | mkV "ทิ้ง" | mkV "กำจัด" | mkV "กินยา" | mkV "ตกลูก" | mkV "ละเลย" | mkV "เหยาะ" | mkV "ขนถ่าย" | mkV "คุกเข่า" | mkV "ต่ำทราม" | mkV "ลดระดับ" | mkV "โยนทิ้ง" | mkV "ทำให้ล้ม" | mkV "ทำให้หล่น" | mkV "พูดเกริ่น" | mkV "ให้พักงาน" | mkV "เสื่อมโทรม" | mkV "ให้หยุดงาน" | mkV "ตั้งเสียงต่ำ" | mkV "ห้อยต่องแต่ง" | mkV "จม" | mkV "ตก" | mkV "ลง" | mkV "ทิ้ง" | mkV "ย้อย" | mkV "ลดลง" | mkV "หยุด" | mkV "หล่น" | mkV "เลิก" | mkV "ปล่อย" | mkV "หย่อน" | mkV "แย่ลง" | mkV "น้อยลง" | mkV "ยกเลิก" | mkV "อ่อนแอ" | mkV "ทําแต้ม" | mkV "มองข้าม" | mkV "มองผ่าน" | mkV "โยนทิ้ง" | mkV "ทําคะแนน" | mkV "เลิกคบหา" | mkV "ส่งจดหมาย" | mkV "ทําเสียงต่ําลง" | mkV "ส่งของหรือผู้โดยสาร" ; -- src=panlex
lin professional_A = mkA "มืออาชีพ" | mkA "ระดับมืออาชีพ" | mkA "เกี่ยวกับอาชีพ" | mkA "ชํานาญ" | mkA "โดยอาชีพ" | mkA "เป็นอาชีพ" | mkA "นักเล่นอาชีพ" | mkA "ผู้มีวิชาชีพ" | mkA "ผู้เชี่ยวชาญ" | mkA "เกี่ยวกับอาชีพ" | mkA "ที่ทําเป็นอาชีพ" | mkA "ที่มีความเชี่ยวชาญ" ; -- src=panlex
lin less_Det = variants{} ; -- 
lin once_Subj = variants{} ; -- 
lin item_N = mkN "โทเคน" | mkN "ส่วนย่อย" | mkN "รายละเอียด" | mkN "ของ" | mkN "อัน" | mkN "ข่าว" | mkN "ชิ้น" | mkN "มาตรา" | mkN "รายการ" | mkN "เรื่อง" | mkN "สิ่งของ" | mkN "ลงบันทึก" | mkN "รายงานข่าว" | mkN "บัญชีรายการ" | mkN "รายการสิ่งของ" | mkN "รายการในบัญชี" | mkN "สิ่งของในรายการ" ; -- src=panlex
lin fly_V2 = mkV2 (thword "บิน") ; ---- | {-pan-} mkV "ชัก" | mkV "บิน" | mkV "หายไป" | mkV "โบยบิน" | mkV "บินข้าม" | mkV "รีบเผ่น" | mkV "อันตธาน" | mkV "ทำให้บิน" | mkV "อันตรธาน" | mkV "ตีแมลงวัน" | mkV "ขึ้นเครื่อง" | mkV "ขับเครื่องบิน" | mkV "นั่งเครื่องบิน" | mkV "โดยสารเครื่องบิน" | mkV "ขนส่งทางเครื่องบิน" | mkV "โผ" | mkV "บิน" | mkV "ลอย" | mkV "หนี" | mkV "ปราด" | mkV "ล่วง" | mkV "เผ่น" | mkV "เหาะ" | mkV "แล่น" | mkV "หลบหนี" | mkV "รีบเร่ง" | mkV "โบกสะบัด" | mkV "ขนส่งทางอากาศ" | mkV "บังคับเครื่องบิน" | mkV "ทําให้ลอยในอากาศ เช่น ว่าว" | mkV "พุ่งไปอย่างรวดเร็ว" | mkV "เดินทางโดยเครื่องบิน" | mkV "ชักธงขึ้นสู่ยอดเสาเพื่อเป็นสัญญาณ" | mkV "ส่งไปรษณียภัณฑ์หรือสิ่งของทางอากาศ" ; -- src=panlex
lin fly_V = mkV (thword "บิน") | {-pan-} mkV "ชัก" | mkV "บิน" | mkV "หายไป" | mkV "โบยบิน" | mkV "บินข้าม" | mkV "รีบเผ่น" | mkV "อันตธาน" | mkV "ทำให้บิน" | mkV "อันตรธาน" | mkV "ตีแมลงวัน" | mkV "ขึ้นเครื่อง" | mkV "ขับเครื่องบิน" | mkV "นั่งเครื่องบิน" | mkV "โดยสารเครื่องบิน" | mkV "ขนส่งทางเครื่องบิน" | mkV "โผ" | mkV "บิน" | mkV "ลอย" | mkV "หนี" | mkV "ปราด" | mkV "ล่วง" | mkV "เผ่น" | mkV "เหาะ" | mkV "แล่น" | mkV "หลบหนี" | mkV "รีบเร่ง" | mkV "โบกสะบัด" | mkV "ขนส่งทางอากาศ" | mkV "บังคับเครื่องบิน" | mkV "ทําให้ลอยในอากาศ เช่น ว่าว" | mkV "พุ่งไปอย่างรวดเร็ว" | mkV "เดินทางโดยเครื่องบิน" | mkV "ชักธงขึ้นสู่ยอดเสาเพื่อเป็นสัญญาณ" | mkV "ส่งไปรษณียภัณฑ์หรือสิ่งของทางอากาศ" ; -- src=panlex
lin reveal_VS = variants{} ; -- 
lin reveal_V2 = variants{} ; -- 
lin version_N = mkN "การแปล" | mkN "ชุด" | mkN "ฉบับ" | mkN "บทแปล" | mkN "คําแปล" | mkN "เรื่องราว" | mkN "เวอร์ชั่น" | mkN "หนังสือแปล" | mkN "เรื่องเล่า" ; -- src=panlex
lin maybe_Adv = mkAdv "บางที" | mkAdv "อาจจะ" | mkAdv "บางที" | mkAdv "อาจจะ" | mkAdv "เป็นไปได้" ; -- src=panlex
lin ability_N = mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "พรสวรรค์" | mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "ความมีทักษะ" | mkN "ความมีฝีมือ" | mkN "ที่คงอยู่ตลอดไป" ; -- src=panlex
lin operate_V2 = mkV2 "ทำงาน" ; ---- | mkV "ควบคุม" | mkV "ซ้อมรบ" | mkV "ดำเนิน" | mkV "ผ่าตัด" | mkV "ขับ" | mkV "ทํา" | mkV "หมุน" | mkV "เดิน" | mkV "แล่น" | mkV "สู้รบ" | mkV "ทํางาน" | mkV "ผ่าตัด" | mkV "ปฏิบัติ" | mkV "ปฏิบัติการ" | mkV "ปฏิบัติงาน" | mkV "ก่อให้เกิดผล" | mkV "ทําให้เกิดขึ้น" ; -- src=panlex
lin operate_V = mkV "ทำงาน" | mkV "ควบคุม" | mkV "ซ้อมรบ" | mkV "ดำเนิน" | mkV "ผ่าตัด" | mkV "ขับ" | mkV "ทํา" | mkV "หมุน" | mkV "เดิน" | mkV "แล่น" | mkV "สู้รบ" | mkV "ทํางาน" | mkV "ผ่าตัด" | mkV "ปฏิบัติ" | mkV "ปฏิบัติการ" | mkV "ปฏิบัติงาน" | mkV "ก่อให้เกิดผล" | mkV "ทําให้เกิดขึ้น" ; -- src=panlex
lin good_N = mkN "ความดี" | mkN "สินค้า" | mkN "สิ่งดี" | mkN "ข้าวของ" | mkN "ของซื้อขาย" | mkN "คุณประโยชน์" | mkN "ของซื้อของขาย" | mkN "ความดี" | mkN "คุณธรรม" | mkN "ความดีงาม" | mkN "ผลประโยชน์" ; -- src=panlex
lin campaign_N = mkN "การรณรงค์" | mkN "การเดินป่า" | mkN "การล่าสัตว์" | mkN "การรณรงค์หาเสียง" | mkN "การแข่งขันหาเสียง" | mkN "การสู้ศึกเลือกตั้ง" | mkN "การแข่งขันหาเสียงเลือกตั้ง" | mkN "การรณรงค์" | mkN "การหาเสียง" | mkN "การหาเสียงของพรรคการเมือง" | mkN "การกระทําการหรือวางแผนเพื่อให้บรรลุตามเป้าหมาย" ; -- src=panlex
lin heavy_A = mkA (thword "หนัก") | {-pan-} mkA "หนัก" | mkA "ใหญ่" | mkA "คับคั่ง" | mkA "ที่หนัก" | mkA "อ้วนใหญ่" | mkA "ที่ดุเดือด" | mkA "ที่ยากลำบาก" | mkA "ที่รับบทตัวร้าย" | mkA "ที่ใช้แรงงานมาก" | mkA "ที่เล่นบทตัวร้าย" | mkA "ดก" | mkA "มาก" | mkA "หนา" | mkA "หงอย" | mkA "หนัก" | mkA "เพียบ" | mkA "เศร้า" | mkA "รุนแรง" | mkA "ลึกซึ้ง" | mkA "ใหญ่มาก" | mkA "ขนาดหนัก" | mkA "อุ้ยอ้าย" | mkA "จํานวนมาก" | mkA "สําคัญมาก" | mkA "เซื่องซึม" | mkA "ซึ่งมีจํานวนมาก" | mkA "ซึ่งมีน้ําหนักมาก" ; -- src=panlex
lin advice_N = mkN "ข่าว" | mkN "รายงาน" | mkN "ความเห็น" | mkN "คําปรึกษา" | mkN "คําแนะนํา" | mkN "การบอกข่าว" | mkN "การเสนอแนะ" | mkN "ข้อคิดเห็น" | mkN "ข้อเสนอแนะ" | mkN "ความประพฤติ" | mkN "ข้อมูลอย่างเป็นทางการ" | mkN "ข่าวสารอย่างเป็นทางการ" ; -- src=panlex
lin institution_N = mkN "สถาบัน" | mkN "การก่อตั้ง" | mkN "การเริ่มต้น" | mkN "โรงพยาบาลจิตเวช" | mkN "สถาบัน" | mkN "หน่วยงาน" | mkN "ธรรมเนียม" | mkN "ขนบประเพณี" | mkN "สถานที่ตั้งของสถาบัน" | mkN "สิ่งที่ปฏิบัติกันมานาน" ; -- src=panlex
lin discover_VS = mmkVS "พบ" ; ---- | mkV "รู้" | mkV "ค้นพบ" | mkV "เปิดเผย" | mkV "พบโดยบังเอิญ" | mkV "พบ" | mkV "เจอ" | mkV "ค้นพบ" | mkV "ค้นหา" | mkV "ตรวจพบ" | mkV "ทําให้รู้กันทั่ว" ; -- src=panlex
lin discover_V2 = mkV2 "พบ" ; ---- | mkV "รู้" | mkV "ค้นพบ" | mkV "เปิดเผย" | mkV "พบโดยบังเอิญ" | mkV "พบ" | mkV "เจอ" | mkV "ค้นพบ" | mkV "ค้นหา" | mkV "ตรวจพบ" | mkV "ทําให้รู้กันทั่ว" ; -- src=panlex
lin discover_V = mkV "พบ" | mkV "รู้" | mkV "ค้นพบ" | mkV "เปิดเผย" | mkV "พบโดยบังเอิญ" | mkV "พบ" | mkV "เจอ" | mkV "ค้นพบ" | mkV "ค้นหา" | mkV "ตรวจพบ" | mkV "ทําให้รู้กันทั่ว" ; -- src=panlex
lin surface_N = mkN "พื้นผิว" | mkN "เเพนอากาศ" | mkN "แอร์ฟอยล์" | mkN "แอโรฟอยล์" | mkN "พื้นผิวโลก" | mkN "ผิว" | mkN "ขัดมัน" | mkN "ผิวนอก" | mkN "ด้านนอก" | mkN "ผิวพื้น" | mkN "ผิวหน้า" | mkN "ผิวเผิน" | mkN "โฉมหน้า" | mkN "ด้านหน้า" | mkN "ผิวภายนอก" | mkN "โฉมภายนอก" | mkN "การแสดงออก" | mkN "ลักษณะภายนอก" | mkN "สิ่งที่ปรากฏ" | mkN "กระทําบนผิวหน้า" | mkN "บริเวณที่ราบแข็ง" | mkN "พื้นดินหรือพื้นน้ํา" | mkN "พื้นผิวที่เป็นของแข็ง" | mkN "พื้นผิวโลกที่สัมผัสกับอากาศ" ; -- src=panlex
lin library_N = mkN "หอสมุด" | mkN "ห้องสมุด" | mkN "หอสมุด" | mkN "ห้องสมุด" | mkN "หอเก็บหนังสือ" | mkN "การเก็บรวมโปรแกรมของคอมพิวเตอร์" | mkN "การเก็บรวมโปรแกรมมาตรฐานของคอมพิวเตอร์" ; -- src=panlex
lin pupil_N = mkN "นร." | mkN "นศ." | mkN "นิสิต" | mkN "นักศึกษา" | mkN "นักเรียน" | mkN "เด็กนักเรียน" | mkN "นิสิตนักศึกษา" | mkN "นักเรียน" | mkN "ผู้เยาว์" | mkN "รูม่านตา" | mkN "ลูกตาดํา" | mkN "ลูกศิษย์" | mkN "ช่องตาดํา" | mkN "เด็กนักเรียน" ; -- src=panlex
lin record_V2 = variants{} ; -- 
lin refuse_VV = mkVV "ขัดขืน" ; ---- | mkV "ปฏิเสธ" | mkV "ต่อต้าน" | mkV "ปฏิเสธ" | mkV "ไม่ยอมรับ" ; -- src=panlex
lin refuse_V2 = mkV2 "ขัดขืน" ; ---- | mkV "ปฏิเสธ" | mkV "ต่อต้าน" | mkV "ปฏิเสธ" | mkV "ไม่ยอมรับ" ; -- src=panlex
lin refuse_V = mkV "ขัดขืน" | mkV "ปฏิเสธ" | mkV "ต่อต้าน" | mkV "ปฏิเสธ" | mkV "ไม่ยอมรับ" ; -- src=panlex
lin prevent_V2 = variants{} ; -- 
lin advantage_N = mkN "ประโยชน์" | mkN "ข้อได้เปรียบ" | mkN "ความได้เปรียบ" | mkN "ผลดี" | mkN "ข้อดี" | mkN "โอกาส" | mkN "ผลกําไร" | mkN "ผลประโยชน์" | mkN "คุณประโยชน์" | mkN "ข้อได้เปรียบ" | mkN "ความได้เปรียบ" ; -- src=panlex
lin dark_A = mkA "ดำ" | mkA "มืด" | mkA "จอมืด" | mkA "ที่มีผิวสี" | mkA "มัว" | mkA "มืด" | mkA "เข้ม" | mkA "คล้ํา" | mkA "มืดมน" | mkA "สลดใจ" | mkA "หดหู่" | mkA "ซึมเซา" | mkA "ที่มืด" | mkA "มืดมิด" | mkA "ลึกลับ" | mkA "กลางคืน" | mkA "ชั่วช้า" | mkA "หมดหวัง" | mkA "เร้นลับ" | mkA "ชั่วร้าย" | mkA "ซ่อนเร้น" | mkA "ดําคล้ํา" | mkA "มืดครึ้ม" | mkA "หม่นหมอง" | mkA "คลุมเครือ" | mkA "ป่าเถื่อน" | mkA "ไม่ชัดเจน" | mkA "ไม่เบิกบาน" | mkA "ใจคอเหี่ยวแห้ง" | mkA "เร้นลับคลุมเครือ" ; -- src=panlex
lin teach_V2V = mmkV2V "สอน" ; ---- | mkV "ชี้แนะ" | mkV "ถ่ายทอดความรู้" | mkV "สอน" | mkV "อบรม" | mkV "สอนสั่ง" | mkV "สั่งสอน" | mkV "ให้การศึกษา" ; -- src=panlex
lin teach_V2 = mkV2 "สอน" ;
lin teach_V = mkV "สอน" | mkV "ชี้แนะ" | mkV "ถ่ายทอดความรู้" | mkV "สอน" | mkV "อบรม" | mkV "สอนสั่ง" | mkV "สั่งสอน" | mkV "ให้การศึกษา" ; -- src=panlex
lin memory_N = mkN "เมม" | mkN "ความจำ" | mkN "เมมโมรี่" | mkN "ความทรงจำ" | mkN "หน่วยความจำคอมพิวเตอร์" | mkN "ความจํา" | mkN "การจําได้" | mkN "ความทรงจํา" | mkN "การระลึกถึง" | mkN "ระบบความจํา" | mkN "ความจุของข้อมูล" | mkN "บุคคลหรือสิ่งที่จําไว้" ; -- src=panlex
lin culture_N = mkN "สังคม" | mkN "การพัฒนา" | mkN "วัฒนธรรม" | mkN "อารยธรรม" | mkN "การเพาะพันธุ์" | mkN "ความละเอียดปราณีต" | mkN "การอบรม" | mkN "การพัฒนา" | mkN "วัฒนธรรม" | mkN "การเพาะใจ" | mkN "การเลี้ยง" | mkN "การปลูกฝัง" | mkN "การเพาะกาย" | mkN "การปรับปรุง" | mkN "การเพาะปลูก" | mkN "การเพาะเลี้ยง" | mkN "ผลิตผลการเพาะปลูก" | mkN "ค่านิยมและความเชื่อ" | mkN "การเพาะเชื้อจุลินทรีย์" | mkN "การเตรียมที่ดินเพื่อเพาะปลูก" | mkN "คนที่เชื่อและปฏิบัติเหมือนกัน" | mkN "เชื้อจุลินทรีย์ที่เพาะเลี้ยงขึ้น" ; -- src=panlex
lin blood_N = mkN (thword "เลือด") | {-pan-} mkN "กำพืด" | mkN "นิสัย" | mkN "เลือด" | mkN "โลหิต" | mkN "ตระกูล" | mkN "พระโลหิต" | mkN "สายเลือด" | mkN "เชื้อสาย" | mkN "สายตระกูล" | mkN "ผู้สืบสกุล" | mkN "ผู้ชายเจ้าชู้" | mkN "เทือกเถาเหล่ากอ" | mkN "คนที่ใช้จ่ายสุรุ่ยสุร่าย" | mkN "ชีวิต" | mkN "เลือด" | mkN "โลหิต" | mkN "การฆ่า" | mkN "กําลัง" | mkN "ชนชาติ" | mkN "อารมณ์" | mkN "ฆาตกรรม" | mkN "ภาวะจิต" | mkN "ชายหนุ่ม" | mkN "สายเลือด" | mkN "สายโลหิต" | mkN "พลังชีวิต" | mkN "น้ําต้นไม้" | mkN "วงศ์ตระกูล" | mkN "ส่วนสําคัญ" | mkN "การนองเลือด" | mkN "การหลั่งเลือด" | mkN "การเสียเลือดเนื้อ" | mkN "หนุ่มที่ชอบผจญภัย" ; -- src=panlex
lin cost_V2 = mkV2 "มีราคา" ; ---- | mkV "เป็นเหตุให้สูญเสีย" | mkV "มีมูลค่า" | mkV "มีราคาแพง" | mkV "ทําให้สูญเสีย" | mkV "มีราคาเท่ากับ" | mkV "ทําให้สิ้นเปลือง" | mkV "คํานวณเงินที่ต้องการ" ; -- src=panlex
lin cost_V = mkV "มีราคา" | mkV "เป็นเหตุให้สูญเสีย" | mkV "มีมูลค่า" | mkV "มีราคาแพง" | mkV "ทําให้สูญเสีย" | mkV "มีราคาเท่ากับ" | mkV "ทําให้สิ้นเปลือง" | mkV "คํานวณเงินที่ต้องการ" ; -- src=panlex
lin majority_N = mkN "ขนาดใหญ่" | mkN "ส่วนใหญ่" | mkN "วัยผู้ใหญ่" | mkN "เสียงข้างมาก" | mkN "อายุในทางกฎหมาย" | mkN "อายุที่กฎหมายกำหนด" | mkN "ส่วนมาก" | mkN "ส่วนรวม" | mkN "นิติภาวะ" | mkN "ส่วนใหญ่" | mkN "ฝ่ายข้างมาก" | mkN "เสียงข้างมาก" | mkN "เสียงส่วนมาก" | mkN "ตําแหน่งพันตรี" | mkN "คะแนนเสียงข้างมาก" | mkN "ส่วนใหญ่ที่สุดของกลุ่ม" ; -- src=panlex
lin answer_V2 = mkV2 "ตอบ" ; ---- | mkV "สนอง" | mkV "เฉลย" | mkV "เหมาะ" | mkV "ตรงกับ" | mkV "ตอบรับ" | mkV "ตอบสนอง" | mkV "ตอบคำถาม" | mkV "ตอบโจทย์" | mkV "สอดคล้องกับ" | mkV "แก้ข้อกล่าวหา" | mkV "สนองความต้องการ" | mkV "ตอบ" | mkV "เฉลย" | mkV "โต้ตอบ" | mkV "ตอบสนอง" | mkV "ให้คําตอบ" | mkV "แก้ตัวในศาล" | mkV "แก้ต่างในศาล" | mkV "บรรลุจุดประสงค์" | mkV "ทําให้บรรลุตามความต้องการ" ; -- src=panlex
lin answer_V = mkV "ตอบ" | mkV "สนอง" | mkV "เฉลย" | mkV "เหมาะ" | mkV "ตรงกับ" | mkV "ตอบรับ" | mkV "ตอบสนอง" | mkV "ตอบคำถาม" | mkV "ตอบโจทย์" | mkV "สอดคล้องกับ" | mkV "แก้ข้อกล่าวหา" | mkV "สนองความต้องการ" | mkV "ตอบ" | mkV "เฉลย" | mkV "โต้ตอบ" | mkV "ตอบสนอง" | mkV "ให้คําตอบ" | mkV "แก้ตัวในศาล" | mkV "แก้ต่างในศาล" | mkV "บรรลุจุดประสงค์" | mkV "ทําให้บรรลุตามความต้องการ" ; -- src=panlex
lin variety_N = variants{} ; -- 
lin variety_2_N = variants{} ; -- 
lin variety_1_N = variants{} ; -- 
lin press_N = mkN "การกด" | mkN "ฝูงชน" | mkN "ตู้เสื้อผ้า" | mkN "เครื่องพิมพ์" | mkN "สิ่งพิมพ์สาธารณะ" | mkN "ฝูงชนที่เนื่องแน่น" | mkN "กด" | mkN "ดัน" | mkN "ทับ" | mkN "บีบ" | mkN "รัด" | mkN "อัด" | mkN "แนบ" | mkN "คั้น" | mkN "เน้น" | mkN "เร่ง" | mkN "การกด" | mkN "ฝูงชน" | mkN "รบกวน" | mkN "กอดรัด" | mkN "การอัด" | mkN "บังคับ" | mkN "กระตุ้น" | mkN "ความดัน" | mkN "นักข่าว" | mkN "นิตยสาร" | mkN "บีบคั้น" | mkN "ผลักดัน" | mkN "รุกเร้า" | mkN "เครื่องบด" | mkN "แท่นพิมพ์" | mkN "หนังสือพิมพ์" | mkN "เครื่องพิมพ์" | mkN "เครื่องบีบอัด" | mkN "นักหนังสือพิมพ์" | mkN "เบียดไปข้างหน้า" | mkN "ความแออัดของฝูงชน" | mkN "การเกณฑ์เข้าเป็นทหาร" | mkN "การเคลื่อนไหวของฝูงชน" | mkN "การยกน้ําหนักในท่าเหนือศีรษะ" ; -- src=panlex
lin depend_V = mkV "พึ่งพา" | mkV "ห้อย" | mkV "แขวน" | mkV "อาศัย" | mkV "พึ่งพา" | mkV "มั่นใจ" | mkV "พึ่งพิง" | mkV "ห้อยลงมา" | mkV "ไว้วางใจ" | mkV "เชื่อมั่น" | mkV "ขึ้นอยู่กับ" ; -- src=panlex
lin bill_N = mkN "บิล" | mkN "ง้าว" | mkN "จะงอย" | mkN "แบงค์" | mkN "ธนบัตร" | mkN "ประกาศ" | mkN "พร้าขอ" | mkN "ใบปลิว" | mkN "ใบเสร็จ" | mkN "การโฆษณา" | mkN "จะงอยปาก" | mkN "แฮนด์บิล" | mkN "โปสเตอร์" | mkN "ใบประกาศ" | mkN "ป้ายโฆษณา" | mkN "ร่างกฎหมาย" | mkN "เงินกระดาษ" | mkN "ใบเก็บเงิน" | mkN "ใบแจ้งหนี้" | mkN "จงอยปากของนก" | mkN "ใบเสร็จรับเงิน" | mkN "ร่างพระราชบัญญัติ" | mkN "ใบแจ้งราคาสินค้าที่ขายให้" | mkN "บิล" | mkN "ปากนก" | mkN "ธนบัตร" | mkN "ปากไก่" | mkN "รายการ" | mkN "ใบปลิว" | mkN "ปากเป็ด" | mkN "โปรแกรม" | mkN "ใบโฆษณา" | mkN "ร่างกฎหมาย" | mkN "ใบแจ้งหนี้" | mkN "ร่างรัฐธรรมนูญ" | mkN "ใบสําคัญเก็บเงิน" | mkN "ร่างพระราชบัญญัติ" ; -- src=panlex
lin competition_N = mkN "การแข่ง" | mkN "คู่แข่ง" | mkN "คอนเทสต์" | mkN "การประกวด" | mkN "การประลอง" | mkN "คู่ต่อสู้" | mkN "ผู้ท้าชิง" | mkN "การแข่งขัน" | mkN "การแข่งขันทางธุรกิจ" | mkN "การชิงชัย" | mkN "การแข่งขัน" | mkN "ผู้แข่งขัน" | mkN "การดิ้นรนต่อสู้ในการดํารงชีพ" ; -- src=panlex
lin ready_A = mkA "พร้อม" | {-pan-} mkA "หัวไว" | mkA "เตรียมพร้อม" | mkA "ที่มีไหวพริบ" | mkA "ที่มีเชาว์ปัญญา" | mkA "ที่มีไหวพริบปฏิภาณ" | mkA "ชอบ" | mkA "ง่าย" | mkA "ฉลาด" | mkA "คล่อง" | mkA "ทันที" | mkA "มักจะ" | mkA "สะดวก" | mkA "เสร็จ" | mkA "เต็มใจ" | mkA "ฉับพลัน" | mkA "รวดเร็ว" | mkA "พร้อมใช้" | mkA "โน้มน้าว" | mkA "เฉียบแหลม" | mkA "เตรียมพร้อม" | mkA "ใช้ได้ทันที" ; -- src=panlex
lin general_N = mkN "พล.อ." | mkN "พลเอก" | mkN "ความจริงทั่วไป" | mkN "นายพล" | mkN "แม่ทัพ" ; -- src=panlex
lin access_N = mkN "สิทธิ์" | mkN "รหัสผ่าน" | mkN "การเปิดรับ" | mkN "ทางเข้าออก" | mkN "วิธีการเข้า-ออก" | mkN "สิทธิเข้าใช้" | mkN "สิทธิในการเข้าถึง" | mkN "ทางเข้า" | mkN "วิธีเข้า" | mkN "การเข้าไปได้" | mkN "การระเบิดอารมณ์" | mkN "การปะทุของอารมณ์" | mkN "สิทธิ์ในการเข้าพบ" | mkN "สิทธิ์หรือโอกาสในการใช้" | mkN "อารมณ์รุนแรงและกระทันหัน" ; -- src=panlex
lin hit_V2 = mkV2 (thword "ตี") ;
lin hit_V = mkV "ชน" | mkV "ตี" | mkV "ฆ่า" | mkV "ดีด" | mkV "ถึง" | mkV "ทุบ" | mkV "ยิง" | mkV "โขก" | mkV "เก็บ" | mkV "มาถึง" | mkV "ไปถึง" | mkV "ทำแต้ม" | mkV "ยิงปืน" | mkV "เข้าตี" | mkV "ได้ถึง" | mkV "ฆาตกรรม" | mkV "ทำคะแนน" | mkV "ยิงทิ้ง" | mkV "เล่นงาน" | mkV "ได้แต้ม" | mkV "บุกโจมตี" | mkV "ฟาดเรียบ" | mkV "ได้คะแนน" | mkV "ยิงกระสุน" | mkV "ทำให้ตระหนก" | mkV "พบโดยบังเอิญ" | mkV "ชน" | mkV "ตี" | mkV "ทุบ" | mkV "ต่อย" | mkV "ปะทะ" | mkV "กระทบ" | mkV "ไปถึง" | mkV "กระแทก" | mkV "มีผลกระทบ" | mkV "ทําฆาตกรรม" | mkV "ทําแต้มได้" ; -- src=panlex
lin stone_N = mkN (thword "หิน") | {-pan-} mkN "หิน" | mkN "ศิลา" | mkN "สโตน" | mkN "เม็ด" | mkN "ใจหิน" | mkN "อัญมณี" | mkN "ก้อนหิน" | mkN "รัตนชาติ" | mkN "หินมีค่า" | mkN "ผนังผลชั้นใน" | mkN "หิน" | mkN "กรวด" | mkN "นิ่ว" | mkN "พลอย" | mkN "ก้อนหิน" | mkN "ก้อนนิ่ว" | mkN "เพชรพลอย" | mkN "สีเทาอ่อน" | mkN "แท่นพิมพ์" | mkN "เมล็ดผลไม้" | mkN "หน่วยน้ําหนัก" | mkN "แท่นหินเรียงพิมพ์" | mkN "หน่วยวัดน้ําหนักตามมาตราอังกฤษเท่ากับ 14 ปอนด์" ; -- src=panlex
lin useful_A = mkA "ซึ่งมีประโยชน์" | mkA "ดี" | mkA "น่าพอใจ" | mkA "มีประโยชน์" | mkA "ที่มีประโยชน์" | mkA "ใช้เป็นประโยชน์" | mkA "ซึ่งนําไปใช้ประโยชน์ได้" ; -- src=panlex
lin extent_N = mkN "ขอบเขต" | mkN "ขนาด" | mkN "ขอบเขต" | mkN "การประเมินค่า" ; -- src=panlex
lin employment_N = mkN "งาน" | mkN "การใช้" | mkN "การจ้างงาน" | mkN "การว่าจ้าง" | mkN "การให้งานทำ" | mkN "การเป็นลูกจ้าง" | mkN "งานที่ได้รับค่าจ้าง" | mkN "งาน" | mkN "อาชีพ" | mkN "การงาน" | mkN "ธุรกิจ" | mkN "การจ้าง" | mkN "กิจกรรม" | mkN "การจ้างงาน" | mkN "การว่าจ้าง" | mkN "ภาวะที่ถูกว่าจ้าง" ; -- src=panlex
lin regard_V2 = mkV2 "เห็น" ; ---- | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "เล็งเห็น" | mkV "เกี่ยวข้อง" | mkV "สนใจ" | mkV "พิจารณา" | mkV "เอาใจใส่" ; -- src=panlex
lin regard_V = mkV "เห็น" | mkV "มองออก" | mkV "แลเห็น" | mkV "จ้องมอง" | mkV "เล็งเห็น" | mkV "เกี่ยวข้อง" | mkV "สนใจ" | mkV "พิจารณา" | mkV "เอาใจใส่" ; -- src=panlex
lin apart_Adv = mkAdv "แยกจาก" | mkAdv "เป็นชิ้นๆ" | mkAdv "โดยไม่พิจารณา" | mkAdv "แยกจาก" | mkAdv "ต่างหาก" | mkAdv "เป็นส่วนๆ" | mkAdv "คนละต่างหาก" | mkAdv "โดยไม่พิจารณา" ; -- src=panlex
lin present_N = mkN "ของขวัญ" | mkN "ของกำนัล" | mkN "ปัจจุบัน" | mkN "ปัจจุบันกาล" | mkN "เวลาปัจจุบัน" | mkN "เพรสเซนต์เทนส์" | mkN "ของขวัญ" | mkN "ของกํานัล" | mkN "ปัจจุบันนี้" ; -- src=panlex
lin appeal_N = mkN "เสน่ห์" | mkN "ความน่าสนใจ" | mkN "การร้องขอยอดเงิน" | mkN "คำขอร้องเร่งด่วน" | mkN "คําขอร้อง" | mkN "การอุทธรณ์" | mkN "ความน่าสนใจ" | mkN "ความเย้ายวน" | mkN "ความดึงดูดใจ" ; -- src=panlex
lin text_N = mkN "ตำรา" | mkN "ตัวบท" | mkN "เท็กต์" | mkN "เนื้อหา" | mkN "ตำรับตำรา" | mkN "ตำราเรียน" | mkN "หนังสือเรียน" | mkN "ตํารา" | mkN "ใจความ" | mkN "ต้นฉบับ" | mkN "เนื้อหา" | mkN "ตัวพิมพ์" | mkN "แบบเรียน" | mkN "เนื้อเพลง" | mkN "แม่บทเดิม" | mkN "ตําราเรียน" | mkN "ข้อความเดิม" | mkN "ต้นฉบับเดิม" | mkN "ถ้อยคําเดิม" | mkN "ข้อความสั้น ๆ ในพระคัมภีร์ไบเบิล" | mkN "ข้อความสั้นๆ" | mkN "หนังสือเรียน" | mkN "หัวข้อสําคัญ" | mkN "แบบฉบับการเขียน" | mkN "อักษรในพระคัมภีร์ไบเบิล" ; -- src=panlex
lin parliament_N = mkN "รัฐสภา" | mkN "แฟนแทน" | mkN "สภา" | mkN "รัฐสภา" ; -- src=panlex
lin cause_N = mkN "สาเหตุ" | mkN "คดีความ" | mkN "มูลเหตุ" | mkN "การรณรงค์" | mkN "การดำเนินคดี" | mkN "ผู้เป็นสาเหตุ" | mkN "ผู้กระทำเหตุการณ์" | mkN "ผู้ก่อให้เกิดเหตุการณ์" | mkN "สาเหตุ" | mkN "เหตุผลที่ดี" | mkN "เหตุผลที่เหมาะ" | mkN "หัวเรื่องของการอภิปราย" ; -- src=panlex
lin terms_N = mkN "ราคา" | mkN "ค่าใช้จ่าย" | mkN "ข้อตกลง" | mkN "ข้อสัญญา" ; -- src=panlex
lin bar_N = variants{} ; -- 
lin bar_2_N = variants{} ; -- 
lin bar_1_N = variants{} ; -- 
lin attack_N = mkN "การบุก" | mkN "จู่โจม" | mkN "การโจมตี" | mkN "การคุกคาม" | mkN "การวิจารณ์" | mkN "การบุกโจมตี" | mkN "ตี" | mkN "เป็น" | mkN "โจมตี" | mkN "เข้าตี" | mkN "ทําร้าย" | mkN "เล่นงาน" | mkN "การโจมตี" | mkN "ลงมือทํา" ; -- src=panlex
lin effective_A = mkA "ที่เกิดผลจริง" | mkA "ซึ่งมีประสิทธิภาพ" | mkA "มีผล" | mkA "ชะงัด" | mkA "เกิดผล" | mkA "ได้ผลดี" | mkA "มีประสิทธิผล" ; -- src=panlex
lin mouth_N = mkN (thword "ปาก") | {-pan-} mkN "ปาก" | mkN "โอษฐ์" | mkN "การแซว" | mkN "ปากขวด" | mkN "ปากน้ำ" | mkN "ช่องปาก" | mkN "ปากเสียง" | mkN "พระโอษฐ์" | mkN "ปาก" | mkN "มุข" | mkN "โอษฐ์" | mkN "การพูด" | mkN "คําพูด" | mkN "ช่องปาก" | mkN "" | mkN "การคุยโต" | mkN "การเอ่ยปาก" | mkN "การคุยเขื่อง" | mkN "การพูดโอ้อวด" ; -- src=panlex
lin down_Prep = mkPrep "ลงไปตาม" | mkPrep "ไปตามทาง" ; -- src=panlex
lin result_V = mkV "ลงเอย" | mkV "ให้ผล" | mkV "เป็นผล" | mkV "บังเกิดผล" ; -- src=panlex
lin fish_N = animalN (thword "ปลา") | {-pan-} mkN "ปลา" | mkN "มัจฉา" | mkN "มัสยา" | mkN "เนื้อปลา" | mkN "ปลา" | mkN "มัจฉา" | mkN "มัสยา" | mkN "เนื้อปลา" ; -- src=panlex
lin future_A = mkA "อนาคต" | mkA "ในอนาคต" | mkA "อนาคต" ; -- src=panlex
lin visit_N = mkN "การไปหา" | mkN "การเยี่ยม" | mkN "การพักอยู่ชั่วคราว" | mkN "การไปเยี่ยม" | mkN "การไปมาหาสู่" ; -- src=panlex
lin little_Adv = variants{} ; -- 
lin easily_Adv = variants{} ; -- 
lin attempt_VV = variants{} ; -- 
lin attempt_V2 = variants{} ; -- 
lin enable_VS = variants{} ; -- 
lin enable_V2V = variants{} ; -- 
lin enable_V2 = variants{} ; -- 
lin trouble_N = mkN "ปัญหา" | mkN "การรบกวน" | mkN "ความยุ่งยาก" | mkN "ความยากลำบาก" | mkN "ปัญหา" | mkN "อุปสรรค" | mkN "การรบกวน" | mkN "สิ่งรบกวน" | mkN "ความลําบาก" | mkN "ความกังวลใจ" | mkN "ความขัดแย้ง" | mkN "ความยุ่งยาก" | mkN "ความเจ็บปวด" | mkN "ความทุกข์ยาก" | mkN "ความยากลําบาก" | mkN "ความเดือดร้อน" | mkN "ความเป็นทุกข์" | mkN "ทําให้ยุ่งยาก" | mkN "ทําให้เป็นทุกข์" | mkN "ีการตั้งท้องโดยไม่ต้องการ" ; -- src=panlex
lin traditional_A = mkA "โบราณ" | mkA "เก่าแก่" | mkA "ดั้งเดิม" | mkA "เป็นประเพณี" | mkA "แบบดั้งเดิม" ; -- src=panlex
lin payment_N = mkN "การจ่ายเงิน" | mkN "การชำระเงิน" | mkN "เงินที่จ่าย" | mkN "รางวัล. ค่าทดแทน" | mkN "การจ่าย" | mkN "ค่าตอบแทน" | mkN "เงินตอบแทน" | mkN "การจ่ายเงิน" | mkN "การชําระหนี้" ; -- src=panlex
lin best_Adv = mkAdv "ดี" | mkAdv "เหมาะสมที่สุด" ; -- src=panlex
lin post_N = mkN "เสา" | mkN "หลัก" | mkN "ตำแหน่ง" | mkN "หน้าที่" | mkN "ไปรษณีย์" | mkN "ระบบไปรษณีย์" | mkN "ไปรษณียภัณฑ์" | mkN "การส่งไปรษณีย์" | mkN "ตำแหน่งหน้าที่" | mkN "ฐาน" | mkN "เสา" | mkN "ย้าย" | mkN "หลัก" | mkN "สถานี" | mkN "ประกาศ" | mkN "ประจาน" | mkN "เสาปัก" | mkN "ที่มั่น" | mkN "หน้าที่" | mkN "ตําแหน่ง" | mkN "จัดกําลัง" | mkN "ส่งจดหมาย" | mkN "เที่ยวเมล์" | mkN "การไปรษณีย์" | mkN "ไปรษณียภัณฑ์" | mkN "สถานที่ทํางาน" | mkN "ตําแหน่งการงาน" | mkN "โดยทางไปรษณีย์" | mkN "ที่ทําการไปรษณีย์" | mkN "กองกําลังรักษาการณ์" ; -- src=panlex
lin county_N = mkN "เทศมณฑล" | mkN "ผู้บริหารในท้องถิ่น" | mkN "เขต" | mkN "มณฑล" | mkN "เขตปกครอง" ; -- src=panlex
lin lady_N = mkN "สุภาพสตรี" | mkN "คุณผู้หญิง" | mkN "สตรี" | mkN "หญิง" | mkN "ภรรยา" | mkN "คุณหญิง" | mkN "ผู้หญิง" | mkN "สุภาพสตรี" | mkN "คุณผู้หญิง" | mkN "ท่านผู้หญิง" ; -- src=panlex
lin holiday_N = mkN "วันหยุด" | mkN "ฮอลิเดย์" | mkN "ช่วงหยุดงาน" | mkN "วันหยุดพักผ่อน" | mkN "วันหยุด" | mkN "วันพักผ่อน" | mkN "วันนักขัตฤกษ์" | mkN "วันหยุดเทศกาล" ; -- src=panlex
lin realize_VS = variants{} ; -- 
lin realize_V2 = variants{} ; -- 
lin importance_N = mkN "ความสำคัญ" | mkN "ความมีหน้ามีตา" | mkN "ความสําคัญ" | mkN "การวางท่าทาง" ; -- src=panlex
lin chair_N = mkN (thword "เก้า" "อี้") "ตัว" | {-pan-} mkN "ประธาน" | mkN "ม้านั่ง" | mkN "เก้าอี้" | mkN "เก้าอี้ไฟฟ้า" | mkN "ตำแหน่งศาสตราจารย์" | mkN "ที่นั่ง" | mkN "ม้านั่ง" | mkN "เก้าอี้" | mkN "ตําแหน่งการงาน" | mkN "ตําแหน่งประธาน" | mkN "ตําแหน่งศาสตราจารย์" ; -- src=panlex
lin facility_N = mkN "บริการ" | mkN "ความง่าย" | mkN "ความถนัด" | mkN "ความเชี่ยวชาญ" | mkN "สิ่งอำนวยความสะดวก" | mkN "เครื่องอำนวยความสะดวก" | mkN "ความง่าย" | mkN "ความสะดวก" | mkN "ความคล่องแคล่ว" | mkN "กิริยาที่ละมุนละไม" | mkN "สิ่งอํานวยความสะดวก" | mkN "คุณสมบัติพิเศษของเครื่องจักรหรือการบริการต่างๆ" ; -- src=panlex
lin complete_V2 = mkV2 "กรอก" ; ---- | mkV "ทำเสร็จ" | mkV "ปฏิบัติหน้าที่" | mkV "เข้าสอบแข่งขัน" | mkV "จบ" | mkV "เสร็จ" | mkV "เสร็จสิ้น" | mkV "ทําทั้งหมด" ; -- src=panlex
lin complete_V = mkV "กรอก" | mkV "ทำเสร็จ" | mkV "ปฏิบัติหน้าที่" | mkV "เข้าสอบแข่งขัน" | mkV "จบ" | mkV "เสร็จ" | mkV "เสร็จสิ้น" | mkV "ทําทั้งหมด" ; -- src=panlex
lin article_N = mkN "ของ" | mkN "มาตรา" | mkN "บทความ" | mkN "หัวข้อ" | mkN "ของ" | mkN "ข้อ" | mkN "ชิ้น" | mkN "ฟ้อง" | mkN "สิ่ง" | mkN "พัสดุ" | mkN "มาตรา" | mkN "วัตถุ" | mkN "วัสดุ" | mkN "บทความ" | mkN "รายการ" | mkN "สินค้า" | mkN "ข้อย่อย" | mkN "ข้าวของ" | mkN "สิ่งของ" | mkN "อนุมาตรา" | mkN "ข้อบังคับ" | mkN "ผลิตภัณฑ์" | mkN "เครื่องใช้" | mkN "ทําให้ข้อบังคับผูกมัด" | mkN "คํานําหน้านามในภาษาอังกฤษ" ; -- src=panlex
lin object_N = mkN "ของ" | mkN "กรรม" | mkN "วัตถุ" | mkN "อ็อบเจกต์" | mkN "จุดมุ่งหมาย" | mkN "วัตถุ" | mkN "สิ่งของ" | mkN "เป้าหมาย" | mkN "จุดประสงค์" | mkN "จุดมุ่งหมาย" | mkN "วัตถุประสงค์" | mkN "นามที่ทําหน้าที่เป็นกรรมของคํากริยา" ; -- src=panlex
lin context_N = mkN "บริบท" | mkN "สถานการณ์แวดล้อม" | mkN "เหตุการณ์แวดล้อม" | mkN "บริบท" | mkN "สภาพแวดล้อม" | mkN "สิ่งแวดล้อม" | mkN "คําอรรถาธิบาย" | mkN "ตอนต้นหรือตอนต่อจากคําหรือถ้อยคํา" | mkN "ข้อความแวดล้อมที่ช่วยในการเข้าใจความหมาย" ; -- src=panlex
lin survey_N = mkN "การเห็น" | mkN "คณะสํารวจ" | mkN "ทีมสํารวจ" | mkN "การตรวจสอบ" | mkN "ผลการประมวล" | mkN "ผลการสํารวจ" | mkN "การทําแผนที่" | mkN "กลุ่มผู้สํารวจ" | mkN "การรังวัดปักเขต" | mkN "การพินิจพิเคราะห์" ; -- src=panlex
lin notice_VS = variants{} ; -- 
lin notice_V2 = variants{} ; -- 
lin complete_A = mkA "ทั้งหมด" | mkA "ที่เสร็จสิ้น" ; -- src=panlex
lin turn_N = mkN "รอบ" | mkN "การหัน" | mkN "การเล่น" | mkN "ความโค้ง" | mkN "ส่วนโค้ง" | mkN "การเล่นเกม" | mkN "การเปลี่ยนทิศทาง" | mkN "การหันในทิศตรงข้าม" | mkN "ตา" | mkN "ที" | mkN "รอบ" | mkN "เวร" | mkN "คราว" | mkN "โค้ง" | mkN "โอกาส" | mkN "การหัน" | mkN "การสลับ" | mkN "การหมุน" | mkN "หน้าที่" | mkN "โอกาสดี" | mkN "วงเลี้ยว" | mkN "การเลี้ยว" | mkN "งานประจํา" | mkN "การหมุนรอบ" | mkN "การเปลี่ยน" | mkN "การเดินเล่น" | mkN "เหตุการณ์เปลี่ยนแปลง" ; -- src=panlex
lin direct_A = mkA "ตรง" | mkA "ตรงๆ" | mkA "ตรงไป" | mkA "ทันที" | mkA "เปิดเผย" | mkA "ตรงไปตรงมา" | mkA "ไม่คลุมเครือ" | mkA "ไม่เบี่ยงเบน" ; -- src=panlex
lin immediately_Adv = variants{} ; -- 
lin collection_N = mkN "ชุด" | mkN "การรวบรวม" | mkN "การรวมกัน" | mkN "ของที่สะสม" | mkN "คอลเลคชั่น" | mkN "การรวมกลุ่ม" | mkN "สิ่งที่รวมไว้" | mkN "การร้องขอยอดเงิน" | mkN "การสะสม" | mkN "ของสะสม" | mkN "เงินสะสม" | mkN "การชุมนุม" | mkN "การรวบรวม" | mkN "การรวมกัน" | mkN "การจัดเก็บ" | mkN "เงินบริจาค" | mkN "การรวมกลุ่ม" | mkN "การเก็บเงิน" | mkN "เงินเรี่ยไร" | mkN "การเรียกเก็บ" | mkN "การเก็บรวบรวม" | mkN "การเรี่ยไรเงิน" | mkN "สิ่งที่สะสมไว้" | mkN "การขอบริจาคเงิน" | mkN "เงินที่เรี่ยไรมา" | mkN "สิ่งของที่รวบรวมไว้" | mkN "งานศิลปะในพิพิธภัณฑ์" | mkN "สิ่งที่เก็บรวบรวมไว้" | mkN "สิ่งของที่นํามากองรวมกันไว้" | mkN "การรวมตัวกันเป็นกลุ่มเป็นกอง" ; -- src=panlex
lin reference_N = mkN "เชิงอรรถ" | mkN "คุณสมบัติ" | mkN "การอ้างอิง" | mkN "จุดอ้างอิง" | mkN "ความหมายตรง" | mkN "ตำราอ้างอิง" | mkN "การให้คำปรึกษา" | mkN "ตำแหน่งอ้างอิง" | mkN "หนังสืออ้างอิง" | mkN "หลักฐาน" | mkN "การอ้างถึง" | mkN "การอ้างอิง" | mkN "ความสัมพันธ์" | mkN "หนังสือรับรอง" | mkN "เอกสารอ้างอิง" | mkN "หนังสืออ้างอิง" | mkN "บุคคลที่อ้างถึง" | mkN "เครื่องหมายอ้างอิง" | mkN "หลักฐานที่ผู้สมัครงานอ้างถึง" ; -- src=panlex
lin card_N = mkN "เมนู" | mkN "การ์ด" | mkN "คนตลก" | mkN "ประกาศ" | mkN "แผงวงจร" | mkN "บัตรเชิญ" | mkN "แผ่นวงจร" | mkN "โปสเตอร์" | mkN "ใบประกาศ" | mkN "ป้ายโฆษณา" | mkN "เทียบเชิญ" | mkN "เมนูอาหาร" | mkN "แผ่นการ์ด" | mkN "กระดาษการ์ด" | mkN "บัตรจดคะแนน" | mkN "รายการอาหาร" | mkN "บัตรประจำตัว" | mkN "บัตรบันทึกคะแนน" | mkN "ไพ่" | mkN "บัตร" | mkN "เมนู" | mkN "การ์ด" | mkN "คนตลก" | mkN "แผนการ" | mkN "ให้บัตร" | mkN "โปสการ์ด" | mkN "ติดบนบัตร" | mkN "บัตรอวยพร" | mkN "แผ่นการ์ด" | mkN "บัตรรายการ" | mkN "รายการอาหาร" | mkN "บัตรประจําตัว" | mkN "เขียนลงบนบัตร" | mkN "บัตรเรียงดรรชนี" | mkN "อุปกรณ์แปรงขนสักหลาด" | mkN "แปรงสําหรับแปรงเส้นใยให้เรียบ" | mkN "บัตรที่บรรจุข้อมูลทางตัวเลขหรือการเงิน" ; -- src=panlex
lin interesting_A = mkA "น่าทึ่ง" | mkA "น่าสนใจ" | mkA "น่าดึงดูดใจ" | mkA "น่าเอาใจใส่" ; -- src=panlex
lin considerable_A = mkA "สําคัญ" | mkA "น่าพิจารณา" | mkA "ค่อนข้างมาก" | mkA "ค่อนข้างใหญ่" | mkA "จํานวนไม่น้อย" ; -- src=panlex
lin television_N = mkN (thword "ที" "วี")"เครื่อง" | {-pan-} mkN "ทีวี" | mkN "โทรทัศน์" | mkN "การแพร่ภาพ" | mkN "ระบบโทรทัศน์" | mkN "เครื่องโทรทัศน์" | mkN "การถ่ายทอดโทรทัศน์" | mkN "ทีวี" | mkN "โทรทัศน์" | mkN "ธุรกิจโทรทัศน์" | mkN "การถ่ายโทรทัศน์" | mkN "เครื่องโทรทัศน์" | mkN "รายการทางโทรทัศน์" | mkN "เครื่องรับโทรทัศน์" | mkN "ขอบข่ายการถ่ายทอดโทรทัศน์" ; -- src=panlex
lin extend_V2 = mkV2 "กาง" ; ---- | mkV "กิน" | mkV "ควบ" | mkV "ยืด" | mkV "ให้" | mkV "ขยาย" | mkV "ไปไกล" | mkV "ยืดออก" | mkV "เหยียด" | mkV "ยืดเวลา" | mkV "ขยายไปสู่" | mkV "เหยียดออก" | mkV "แผ่อิทธิพล" | mkV "เพิ่มปริมาณ" | mkV "ใช้ระดับสูงสุด" | mkV "ยื่น" | mkV "ไปถึง" | mkV "ยืดออก" | mkV "ขยายออก" | mkV "เสนอให้" | mkV "จัดหาให้" | mkV "ยื่นออกไป" | mkV "เพิ่มขึ้น" | mkV "ประเมินค่า" | mkV "ยืดเวลาออกไป" | mkV "ทําให้ยืดออกไป" ; -- src=panlex
lin extend_V = mkV "กาง" | mkV "กิน" | mkV "ควบ" | mkV "ยืด" | mkV "ให้" | mkV "ขยาย" | mkV "ไปไกล" | mkV "ยืดออก" | mkV "เหยียด" | mkV "ยืดเวลา" | mkV "ขยายไปสู่" | mkV "เหยียดออก" | mkV "แผ่อิทธิพล" | mkV "เพิ่มปริมาณ" | mkV "ใช้ระดับสูงสุด" | mkV "ยื่น" | mkV "ไปถึง" | mkV "ยืดออก" | mkV "ขยายออก" | mkV "เสนอให้" | mkV "จัดหาให้" | mkV "ยื่นออกไป" | mkV "เพิ่มขึ้น" | mkV "ประเมินค่า" | mkV "ยืดเวลาออกไป" | mkV "ทําให้ยืดออกไป" ; -- src=panlex
lin communication_N = mkN "การติดต่อ" | mkN "การสื่อสาร" | mkN "การติดต่อสื่อสาร" | mkN "สิ่งที่ใช้ติดต่อสื่อสาร" | mkN "การคมนาคม" | mkN "การติดต่อ" | mkN "การส่งต่อ" | mkN "การสื่อสาร" | mkN "การติดต่อสื่อสาร" | mkN "วิธีการติดต่อสื่อสาร" | mkN "ความสัมพันธ์ที่ใกล้ชิด" ; -- src=panlex
lin agency_N = mkN "กรม" | mkN "ทบวง" | mkN "มรรค" | mkN "วิธี" | mkN "วิถีทาง" | mkN "หน่วยงาน" | mkN "หน่วยงานราชการ" | mkN "สํา-นักงานของตัวแทน" | mkN "พลัง" | mkN "กําลัง" | mkN "หน้าที่" | mkN "บริษัทตัวแทน" | mkN "การปฏิบัติงาน" | mkN "หน่วยงานบริการ" | mkN "หน่วยงานราชการ" | mkN "สํานักงานตัวแทน" | mkN "หน้าที่หรือการปฏิบัติงานของตัวแทน" ; -- src=panlex
lin physical_A = mkA "ทางกายภาพ" | mkA "ทางฟิสิกส์" | mkA "ทางร่างกาย" | mkA "แน่แท้" | mkA "แท้จริง" | mkA "ทางวัตถุ" | mkA "ืทางกายภาพ" | mkA "โดยรูปร่าง" | mkA "เชิงฟิสิกส์" | mkA "เกี่ยวกับวัตถุ" | mkA "เกี่ยวกับฟิสิกส์" | mkA "เกี่ยวกับรูปธรรม" | mkA "เกี่ยวกับร่างกาย" | mkA "เกี่ยวกับธรรมชาติ" | mkA "โดยพละของธรรมชาติ" | mkA "ที่สามารถสัมผัสได้" | mkA "เกี่ยวกับตัณหาราคะ" | mkA "เกี่ยวกับกิเลสตัณหา" | mkA "เกี่ยวกับกฎของธรรมชาติ" | mkA "เกี่ยวกับเนื้อหนังมังสา" | mkA "เกี่ยวกับความปรารถนาทางโลก" | mkA "เกี่ยวกับสิ่งที่จับต้องได้" | mkA "เกี่ยวกับลักษณะตามธรรมชาติของโลก" ; -- src=panlex
lin except_Conj = variants{} ; -- 
lin check_V2 = mkV2 "ดู" ; ---- | mkV "ฝึก" | mkV "หัก" | mkV "แตก" | mkV "ตรวจ" | mkV "ติ๊ก" | mkV "อบรม" | mkV "เช็ก" | mkV "เช็ค" | mkV "มาร์ค" | mkV "ควบคุม" | mkV "ตรงกัน" | mkV "ตรวจดู" | mkV "รุกฆาต" | mkV "แตกหัก" | mkV "กลมกลืน" | mkV "ค้นคว้า" | mkV "ตรวจสอบ" | mkV "แตกร้าว" | mkV "ตรวจเช็ก" | mkV "ตรวจเช็ค" | mkV "สกัดกั้น" | mkV "เห็นด้วย" | mkV "เขียนเช็ค" | mkV "เหมือนกัน" | mkV "ทำเครื่องหมาย" | mkV "ตรวจความถูกต้อง" | mkV "ฝาก" | mkV "แตก" | mkV "ตรวจ" | mkV "ร้าว" | mkV "เช็ค" | mkV "ควบคุม" | mkV "ฝากของ" | mkV "รุกฆาต" | mkV "ตรวจสอบ" | mkV "ยับยั้ง" | mkV "หยุดยั้ง" | mkV "ขีดกากบาท" | mkV "หยุดชะงัก" | mkV "ดูให้แน่ใจ" | mkV "ทําให้โตช้า" | mkV "ทําสัญลักษณ์" | mkV "หยุดกระทันหัน" | mkV "สํารวจให้แน่ใจ" | mkV "ทําให้เจริญเติบโตช้าลง" ; -- src=panlex
lin check_V = mkV "ดู" | mkV "ฝึก" | mkV "หัก" | mkV "แตก" | mkV "ตรวจ" | mkV "ติ๊ก" | mkV "อบรม" | mkV "เช็ก" | mkV "เช็ค" | mkV "มาร์ค" | mkV "ควบคุม" | mkV "ตรงกัน" | mkV "ตรวจดู" | mkV "รุกฆาต" | mkV "แตกหัก" | mkV "กลมกลืน" | mkV "ค้นคว้า" | mkV "ตรวจสอบ" | mkV "แตกร้าว" | mkV "ตรวจเช็ก" | mkV "ตรวจเช็ค" | mkV "สกัดกั้น" | mkV "เห็นด้วย" | mkV "เขียนเช็ค" | mkV "เหมือนกัน" | mkV "ทำเครื่องหมาย" | mkV "ตรวจความถูกต้อง" | mkV "ฝาก" | mkV "แตก" | mkV "ตรวจ" | mkV "ร้าว" | mkV "เช็ค" | mkV "ควบคุม" | mkV "ฝากของ" | mkV "รุกฆาต" | mkV "ตรวจสอบ" | mkV "ยับยั้ง" | mkV "หยุดยั้ง" | mkV "ขีดกากบาท" | mkV "หยุดชะงัก" | mkV "ดูให้แน่ใจ" | mkV "ทําให้โตช้า" | mkV "ทําสัญลักษณ์" | mkV "หยุดกระทันหัน" | mkV "สํารวจให้แน่ใจ" | mkV "ทําให้เจริญเติบโตช้าลง" ; -- src=panlex
lin sun_N = mkN (thword "พระ" "อา" "ทิตย์") | {-pan-} mkN "แดด" | mkN "ตะวัน" | mkN "แสงแดด" | mkN "สุริยัน" | mkN "อาทิตย์" | mkN "ดวงตะวัน" | mkN "แสงตะวัน" | mkN "ดวงอาทิตย์" | mkN "พระอาทิตย์" | mkN "แสงอาทิตย์" | mkN "ไถง" | mkN "ตะวัน" | mkN "ทินกร" | mkN "สุริยา" | mkN "แสงแดด" | mkN "ดาวฤกษ์" | mkN "ผึ่งแดด" | mkN "แสงตะวัน" | mkN "ดวงอาทิตย์" | mkN "พระอาทิตย์" | mkN "แสงอาทิตย์" | mkN "ความโดดเด่น" | mkN "ความรุ่งโรจน์" | mkN "คนหรือสิ่งที่รุ่งโรจน์" | mkN "พระอาทิตย์ขึ้นหรือพระอาทิตย์ตก" ; -- src=panlex
lin species_N = mkN "ชนิด" | mkN "สปีชีส์" | mkN "ชนิด" | mkN "จําพวก" | mkN "ประเภท" | mkN "ชนิดของสกุลพืช" ; -- src=panlex
lin possibility_N = mkN "สมมุติฐาน" | mkN "ความเป็นไปได้" | mkN "โอกาส" | mkN "ความเป็นไปได้" | mkN "สิ่งที่เป็นไปได้" | mkN "สิ่งที่อาจเกิดขึ้นได้" ; -- src=panlex
lin officialMasc_N = variants{} ; -- 
lin chairman_N = mkN "ประธาน" | mkN "ประธาน" | mkN "คนลากรถลาก" ; -- src=panlex
lin speaker_N = mkN "คนพูด" | mkN "ลำโพง" | mkN "ผู้พูด" | mkN "ผู้พูด" | mkN "ลําโพง" | mkN "ผู้กล่าว" | mkN "ผู้บรรยาย" | mkN "หนังสือฝึกพูด" | mkN "เครื่องขยายเสียง" | mkN "ประธานสภานิติบัญญัติ" ; -- src=panlex
lin second_N = mkN "วิ" | mkN "ที่สอง" | mkN "วินาที" | mkN "ชั่วครู่" | mkN "พี่เลี้ยง" | mkN "เกียร์สอง" | mkN "เบส 2" | mkN "ที่สอง" | mkN "วินาที" | mkN "ชั่วขณะ" | mkN "ผู้ช่วย" | mkN "ฟิลิปดา" | mkN "วิลิปดา" | mkN "คนที่สอง" | mkN "ชั่วครู่" | mkN "ขั้นที่สอง" | mkN "คนสนับสนุน" | mkN "ส่วนที่สอง" | mkN "ครึ่งที่สอง" | mkN "ลําดับที่สอง" | mkN "คุณภาพชั้นสอง" | mkN "ชั่วประเดี๋ยว" | mkN "ระยะเวลาสั้นๆ" | mkN "1/60 นาที" | mkN "1/60 ลิปดา" ; -- src=panlex
lin career_N = mkN "อาชีพ" | mkN "อาชีพ" | mkN "การงาน" ; -- src=panlex
lin laugh_VS = mmkVS (thword "หัว" "เราะ") ; ---- | {-pan-} mkV "หัวร่อ" | mkV "หัวเราะ" | mkV "ทรงพระสรวล" | mkV "หัว" | mkV "หัวร่อ" | mkV "หัวเราะ" | mkV "ทําให้หัวร่อ" | mkV "ทําให้หัวเราะ" | mkV "ส่งเสียงหัวเราะ" ; -- src=panlex
lin laugh_V2 = mkV2 (thword "หัว" "เราะ") ; ---- | {-pan-} mkV "หัวร่อ" | mkV "หัวเราะ" | mkV "ทรงพระสรวล" | mkV "หัว" | mkV "หัวร่อ" | mkV "หัวเราะ" | mkV "ทําให้หัวร่อ" | mkV "ทําให้หัวเราะ" | mkV "ส่งเสียงหัวเราะ" ; -- src=panlex
lin laugh_V = mkV (thword "หัว" "เราะ") | {-pan-} mkV "หัวร่อ" | mkV "หัวเราะ" | mkV "ทรงพระสรวล" | mkV "หัว" | mkV "หัวร่อ" | mkV "หัวเราะ" | mkV "ทําให้หัวร่อ" | mkV "ทําให้หัวเราะ" | mkV "ส่งเสียงหัวเราะ" ; -- src=panlex
lin weight_N = mkN "น.น." | mkN "น้ำหนัก" | mkN "ลูกเหล็ก" | mkN "ตุ้มน้ำหนัก" | mkN "ค่าถ่วงน้ำหนัก" | mkN "มาตรชั่งน้ำหนัก" | mkN "หน่วยวัดน้ำหนัก" | mkN "มาตราชั่งน้ำหนัก" | mkN "หน่วยชั่งน้ำหนัก" | mkN "มวล" | mkN "มีอคตี" | mkN "ความหนัก" | mkN "น้ําหนัก" | mkN "เป็นภาระ" | mkN "ความสําคัญ" | mkN "วัตถุสิ่งของ" | mkN "ระบบวัดน้ําหนัก" | mkN "หน่วยวัดน้ําหนัก" | mkN "ให้น้ําหนักทางสถิติแก่" ; -- src=panlex
lin sound_VS = mmkVS "ส่งเสียง" ; ---- | mkV "วัดความลึก" | mkV "ออกเสียงก้อง" | mkV "ออกเสียงโฆษะ" | mkV "ทำให้เกิดเสียง" | mkV "้เกิดเสียง" | mkV "ดูเหมือนว่า" | mkV "ทําให้เกิดเสียง" | mkV "วัดความลึกด้วยคลื่นเสียง" ; -- src=panlex
lin sound_VA = mmkVA "ส่งเสียง" ; ---- | mkV "วัดความลึก" | mkV "ออกเสียงก้อง" | mkV "ออกเสียงโฆษะ" | mkV "ทำให้เกิดเสียง" | mkV "้เกิดเสียง" | mkV "ดูเหมือนว่า" | mkV "ทําให้เกิดเสียง" | mkV "วัดความลึกด้วยคลื่นเสียง" ; -- src=panlex
lin sound_V2 = mkV2 "ส่งเสียง" ; ---- | mkV "วัดความลึก" | mkV "ออกเสียงก้อง" | mkV "ออกเสียงโฆษะ" | mkV "ทำให้เกิดเสียง" | mkV "้เกิดเสียง" | mkV "ดูเหมือนว่า" | mkV "ทําให้เกิดเสียง" | mkV "วัดความลึกด้วยคลื่นเสียง" ; -- src=panlex
lin sound_V = mkV "ส่งเสียง" | mkV "วัดความลึก" | mkV "ออกเสียงก้อง" | mkV "ออกเสียงโฆษะ" | mkV "ทำให้เกิดเสียง" | mkV "้เกิดเสียง" | mkV "ดูเหมือนว่า" | mkV "ทําให้เกิดเสียง" | mkV "วัดความลึกด้วยคลื่นเสียง" ; -- src=panlex
lin responsible_A = mkA "รับผิดชอบ" | mkA "เป็นภาระ" | mkA "รับผิดชอบ" | mkA "เชื่อถือได้" | mkA "มีความรับผิดชอบ" | mkA "เป็นภาระหน้าที่" ; -- src=panlex
lin base_N = mkN "ฐาน" | mkN "ราก" | mkN "เบส" | mkN "ขั้น" | mkN "ธาตุ" | mkN "บ้าน" | mkN "แท่น" | mkN "รากคำ" | mkN "ฐานทัพ" | mkN "ฐานราก" | mkN "รากฐาน" | mkN "เลขฐาน" | mkN "พื้นฐาน" | mkN "แอลคาไล" | mkN "รากศัพท์" | mkN "ฐานที่มั่น" | mkN "ส่วนผสมหลัก" | mkN "นิวคลีโอไทด์" | mkN "ฐานปฏิบัติการ" | mkN "โครงสร้างพื้นฐาน" | mkN "สาธารณูปโภคพื้นฐาน" | mkN "ฐาน" | mkN "ชั่ว" | mkN "ด่าง" | mkN "พื้น" | mkN "หลัก" | mkN "สีฟัน" | mkN "ฐานทัพ" | mkN "รากฐาน" | mkN "วิบัติ" | mkN "ที่มั่น" | mkN "พื้นฐาน" | mkN "เลวทราม" | mkN "จุดเริ่ม" | mkN "ชั้นต่ํา" | mkN "ฐานที่มั่น" | mkN "จุดศูนย์กลาง" | mkN "น้ํายารักษาสี" | mkN "ส่วนที่ต่ําที่สุด" ; -- src=panlex
lin document_N = mkN "เอกสาร" | mkN "เท็กซ์ไฟล์" | mkN "สาร" | mkN "เอกสาร" | mkN "ข้อเขียน" | mkN "หลักฐานพยาน" | mkN "เอกสารหลักฐาน" | mkN "ภาพยนต์บันทึกเหตุการณ์" ; -- src=panlex
lin solution_N = mkN "เฉลย" | mkN "คำตอบ" | mkN "สารละลาย" | mkN "โซลูชั่น" | mkN "การแก้ปัญหา" | mkN "วิธีแก้ปัญหา" | mkN "คําตอบ" | mkN "ทางออก" | mkN "วิธีการ" | mkN "วิธีแก้" | mkN "การละลาย" | mkN "สารละลาย" | mkN "การอธิบาย" | mkN "คําอธิบาย" | mkN "การแก้ปัญหา" | mkN "วิธีแก้ปัญหา" ; -- src=panlex
lin return_N = mkN "ผลกำไร" | mkN "รายได้" | mkN "คำโต้ตอบ" | mkN "ผลตอบแทน" | mkN "การกลับมา" | mkN "การตอบโต้" | mkN "การหวนคืน" | mkN "คำโต้แย้ง" | mkN "การกลับคืน" | mkN "การตอบกลับ" | mkN "การถอยกลับ" | mkN "การกลับบ้าน" | mkN "การวิ่งย้อน" | mkN "การกลับมาอีกครั้ง" | mkN "ผลกําไร" | mkN "ผลตอบแทน" | mkN "การกลับมา" | mkN "ลูกตีกลับ" | mkN "การกลับคืน" ; -- src=panlex
lin medical_A = mkA "ทางการแพทย์" | mkA "ด้านการแพทย์" | mkA "เกี่ยวกับการรักษา" | mkA "เกี่ยวกับการแพทย์" ; -- src=panlex
lin hot_A = mkA "ร้อน" | {-pan-} mkA "เข้ม" | mkA "เผ็ด" | mkA "ร้อนๆ" | mkA "ล่าสุด" | mkA "เถื่อน" | mkA "ร้อนแรง" | mkA "เร็วจี๋" | mkA "เร้าร้อน" | mkA "ที่ร้อนแรง" | mkA "น่าตื่นเต้น" | mkA "ซึ่งมีกระแสไฟ" | mkA "ที่น่าตื่นเต้น" | mkA "ที่ตำรวจกำลังต้องการตัว" | mkA "ซึ่งมีความกระตือรือร้นสูง" | mkA "ฮิต" | mkA "เก่ง" | mkA "เผ็ด" | mkA "ร้อนๆ" | mkA "รุนแรง" | mkA "ดีเยี่ยม" | mkA "สดๆร้อนๆ" | mkA "ซึ่งได้รับความนิยม" ; -- src=panlex
lin recognize_VS = variants{} ; -- 
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin talk_N = mkN "ทอล์ค ออฟ เดอะ ทาวน์" | mkN "ปาฐกถา" | mkN "การคุยกัน" | mkN "การพูดคุย" | mkN "การกล่าวปราศัย" | mkN "เรื่องที่ทุกคนพูดถึง" | mkN "พูด" | mkN "สนทนา" | mkN "เจรจา" | mkN "โจษจัน" | mkN "ปราศรัย" | mkN "การนินทา" | mkN "การสนทนา" | mkN "คํานินทา" | mkN "การพูดคุย" | mkN "การพิจารณา" | mkN "การอภิปราย" | mkN "คําเล่าลือ" | mkN "วิธีการพูด" | mkN "การถกเรื่อง" | mkN "คําพูดนินทา" | mkN "เรื่องสนทนา" | mkN "การแสดงปาฐกถา" | mkN "สิ่งที่พูดถึง" | mkN "สิ่งที่กล่าวถึง" ; -- src=panlex
lin budget_N = mkN "งบประมาณ" | mkN "ทุน" | mkN "เงิน" | mkN "กองทุน" | mkN "เงินตรา" | mkN "งบประมาณ" | mkN "เงินสะสม" ; -- src=panlex
lin river_N = mkN (thword "แม่" "น้ำ") | {-pan-} mkN "แม่น้ำ" | mkN "นที" | mkN "การไหล" | mkN "สินธุ์" | mkN "แม่น้ำ" | mkN "สายน้ํา" | mkN "แม่น้ํา" | mkN "การไหลบ่า" | mkN "แม่น้ําลําธาร" ; -- src=panlex
lin fit_V2 = mkV2 "ตรงกัน" ; ---- | mkV "กลมกลืน" | mkV "เข้ากับ" | mkV "เหมาะกับ" | mkV "เห็นด้วย" | mkV "แมตช์กับ" | mkV "ทำให้พอดี" | mkV "เหมือนกัน" | mkV "ใส่ได้พอดี" | mkV "สอดคล้องกับ" | mkV "ติดตั้งอุปกรณ์" | mkV "ติด" | mkV "เตรียม" | mkV "ติดตั้ง" | mkV "พอเหมาะ" | mkV "ตระเตรียม" ; -- src=panlex
lin fit_V = mkV "ตรงกัน" | mkV "กลมกลืน" | mkV "เข้ากับ" | mkV "เหมาะกับ" | mkV "เห็นด้วย" | mkV "แมตช์กับ" | mkV "ทำให้พอดี" | mkV "เหมือนกัน" | mkV "ใส่ได้พอดี" | mkV "สอดคล้องกับ" | mkV "ติดตั้งอุปกรณ์" | mkV "ติด" | mkV "เตรียม" | mkV "ติดตั้ง" | mkV "พอเหมาะ" | mkV "ตระเตรียม" ; -- src=panlex
lin organization_N = mkN "องค์กร" | mkN "องค์การ" | mkN "การก่อตั้ง" | mkN "การจัดตั้ง" | mkN "ผู้ก่อตั้ง" | mkN "คณะ" | mkN "รูป" | mkN "ระบบ" | mkN "สมาคม" | mkN "องค์กร" | mkN "องค์การ" | mkN "การควบคุม" | mkN "การจัดตั้ง" | mkN "องค์ประกอบ" | mkN "โครงสร้างสิ่งมีชีวิต" | mkN "การจัดการอย่างเป็นระบบ" ; -- src=panlex
lin existing_A = mkA "ที่มีอยู่" ; -- src=panlex
lin start_N = mkN "ยุคแรก" | mkN "ครั้งแรก" | mkN "การสตาร์ท" | mkN "เส้นสตาร์" | mkN "การเปิดฉาก" | mkN "เส้นสตาร์ต" | mkN "การเริ่มต้น" | mkN "การเริ่มเกม" | mkN "ช่วงเริ่มต้น" | mkN "สัญญาณเริ่มต้น" ; -- src=panlex
lin push_VS = mmkVS "ขาย" ; ---- | mkV "ดัน" | mkV "ผลัก" | mkV "เบ่ง" | mkV "โฆษณา" | mkV "รณรงค์" | mkV "โปรโมท" | mkV "ผลักดัน" | mkV "ย่างเข้า" | mkV "ค่อยๆเคลื่อน" | mkV "ประชาสัมพันธ์" | mkV "พยายามอย่างหนัก" | mkV "โฆษณาประชาสัมพันธ์" | mkV "ดัน" | mkV "ผลัก" | mkV "เข็น" | mkV "กดดัน" | mkV "กระตุ้น" | mkV "ผลักดัน" ; -- src=panlex
lin push_V2V = mmkV2V "ขาย" ; ---- | mkV "ดัน" | mkV "ผลัก" | mkV "เบ่ง" | mkV "โฆษณา" | mkV "รณรงค์" | mkV "โปรโมท" | mkV "ผลักดัน" | mkV "ย่างเข้า" | mkV "ค่อยๆเคลื่อน" | mkV "ประชาสัมพันธ์" | mkV "พยายามอย่างหนัก" | mkV "โฆษณาประชาสัมพันธ์" | mkV "ดัน" | mkV "ผลัก" | mkV "เข็น" | mkV "กดดัน" | mkV "กระตุ้น" | mkV "ผลักดัน" ; -- src=panlex
lin push_V2 = mkV2 (thword "ผลัก") ;
lin push_V = mkV "ขาย" | mkV "ดัน" | mkV "ผลัก" | mkV "เบ่ง" | mkV "โฆษณา" | mkV "รณรงค์" | mkV "โปรโมท" | mkV "ผลักดัน" | mkV "ย่างเข้า" | mkV "ค่อยๆเคลื่อน" | mkV "ประชาสัมพันธ์" | mkV "พยายามอย่างหนัก" | mkV "โฆษณาประชาสัมพันธ์" | mkV "ดัน" | mkV "ผลัก" | mkV "เข็น" | mkV "กดดัน" | mkV "กระตุ้น" | mkV "ผลักดัน" ; -- src=panlex
lin tomorrow_Adv = mkAdv "วันพรุ่งนี้" | mkAdv "อนาคต" | mkAdv "พรุ่งนี้" ; -- src=panlex
lin requirement_N = mkN "สิ่งสำคัญ" | mkN "เงื่อนไขหลัก" | mkN "สิ่งสําคัญ" | mkN "ความต้องการ" | mkN "ความประสงค์" | mkN "ความปรารถนา" | mkN "สิ่งจําเป็น" | mkN "การเรียกร้อง" | mkN "สิ่งที่ต้องการ" | mkN "สิ่งที่เรียกร้อง" ; -- src=panlex
lin cold_A = mkA (thword "หนาว") | {-pan-} mkA "หนาว" | mkA "เย็น" | mkA "เย็นชา" | mkA "หนาว" | mkA "เซ็ง" | mkA "เย็น" | mkA "เฉยเมย" | mkA "เย็นชา" | mkA "หนาวจัด" | mkA "ไม่แยแส" | mkA "เยือกเย็น" | mkA "เย็นยะเยือก" | mkA "ไร้ความรู้สึก" ; -- src=panlex
lin edge_N = mkN "ขอบ" | mkN "เส้นแบ่งเขต" | mkN "ขอบ" | mkN "ชาย" | mkN "ริม" | mkN "สัน" | mkN "ข้าง" | mkN "คมมีด" | mkN "ความคม" | mkN "หน้าผา" | mkN "เขตแดน" | mkN "เนินเขา" | mkN "เส้นขอบ" | mkN "เหลี่ยม" | mkN "ขอบหน้าผา" | mkN "ใส่ขอบให้" | mkN "ความแข็งแรง" | mkN "ข้อได้เปรียบ" | mkN "ด้านคมของใบมีด" | mkN "ความกระฉับกระเฉง" | mkN "เคลื่อนไปทางข้าง" ; -- src=panlex
lin opposition_N = mkN "ศัตรู" | mkN "ข้าศึก" | mkN "คู่แข่ง" | mkN "คู่ต่อสู้" | mkN "การคัดค้าน" | mkN "การปะทะกัน" | mkN "ด้านตรงข้าม" | mkN "ความเป็นปฏิปักษ์" | mkN "ความเป็นคู่ตรงข้าม" | mkN "ความเป็นคู่ตรงกันข้าม" | mkN "ฝ่ายค้าน" | mkN "คู่ต่อสู้" | mkN "การคัดค้าน" | mkN "การต่อต้าน" | mkN "ผู้คัดค้าน" | mkN "ผู้ต่อต้าน" | mkN "การเป็นศัตรู" | mkN "พรรคฝ่ายค้าน" | mkN "การเป็นปรปักษ์" | mkN "ผู้เป็นปรปักษ์" | mkN "การวางให้อยู่ตรงกันข้าม" | mkN "ตําแหน่งที่อยู่ตรงกันข้าม" ; -- src=panlex
lin opinion_N = mkN "ทัศนะ" | mkN "ความเห็น" | mkN "ประชามติ" | mkN "ความเชื่อ" | mkN "ความคิดเห็น" | mkN "ทัศนะ" | mkN "ทัศนคติ" | mkN "ความเห็น" | mkN "ข้อคิดเห็น" | mkN "ข้อวินิจฉัย" | mkN "ความคิดเห็น" | mkN "คําวินิจฉัย" ; -- src=panlex
lin drug_N = mkN "ยา" | mkN "โอสถ" | mkN "พระโอสถ" | mkN "ยา" | mkN "โอสถ" | mkN "ผลิตภัณฑ์" | mkN "สารเสพติด" ; -- src=panlex
lin quarter_N = mkN "ย่าน" | mkN "บริเวณ" | mkN "ไตรมาส" | mkN "ท้ายเรือ" | mkN "สามเดือน" | mkN "ควอร์เตอร์" | mkN "หนึ่งส่วนสี่" | mkN "เหรียญควอร์เตอร์" | mkN "ยี่สิบห้าเปอร์เซนต์" | mkN "เขต" | mkN "แถบ" | mkN "ย่าน" | mkN "เสี้ยว" | mkN "ที่อยู่" | mkN "ค่ายทหาร" | mkN "หนึ่งในสี่ส่วน" | mkN "เศษหนึ่งส่วนสี่" | mkN "หนึ่งในสี่ของชั่วโมง" | mkN "ช่วงเวลาสามเดือนของปีปฏิทิน" | mkN "เวลาการแข่งขันในช่วงสุดท้ายของสี่ช่วง" | mkN "25 เซ็นต์" | mkN "25เซนต์" ; -- src=panlex
lin option_N = mkN "ชอยซ์" | mkN "ออปชั่น" | mkN "การเลือก" | mkN "ตัวเลือก" | mkN "ทางเลือก" | mkN "การเลือก" | mkN "ทางเลือก" | mkN "สิทธิในการเลือก" | mkN "สิ่งที่เลือกได้" | mkN "อํานาจในการเลือก" ; -- src=panlex
lin sign_V2 = mkV2 "เซ็น" ; ---- | mkV "ลงนาม" | mkV "ส่งซิก" | mkV "ทำสัญญา" | mkV "ขึ้นป้าย" | mkV "เซ็นชื่อ" | mkV "ส่งสัญญาณ" | mkV "เซ็นสัญญา" | mkV "ให้สัญญาณ" | mkV "มีสัญญากับ" | mkV "ส่งภาษามือ" | mkV "ติดตั้งป้าย" | mkV "ให้สัตยาบัน" | mkV "ทำสัญญาว่าจ้าง" | mkV "ติดต่อด้วยสัญญาณ" | mkV "ลงนาม" | mkV "ลงชื่อ" | mkV "ส่งสาร" | mkV "เซ็นชื่อ" | mkV "เซ็นสัญญา" | mkV "ทําสัญลักษณ์" | mkV "ทําเครื่องหมาย" | mkV "แสดงอากัปกิริยา" | mkV "ติดต่อกันด้วยสัญญาณ" ; -- src=panlex
lin sign_V = mkV "เซ็น" | mkV "ลงนาม" | mkV "ส่งซิก" | mkV "ทำสัญญา" | mkV "ขึ้นป้าย" | mkV "เซ็นชื่อ" | mkV "ส่งสัญญาณ" | mkV "เซ็นสัญญา" | mkV "ให้สัญญาณ" | mkV "มีสัญญากับ" | mkV "ส่งภาษามือ" | mkV "ติดตั้งป้าย" | mkV "ให้สัตยาบัน" | mkV "ทำสัญญาว่าจ้าง" | mkV "ติดต่อด้วยสัญญาณ" | mkV "ลงนาม" | mkV "ลงชื่อ" | mkV "ส่งสาร" | mkV "เซ็นชื่อ" | mkV "เซ็นสัญญา" | mkV "ทําสัญลักษณ์" | mkV "ทําเครื่องหมาย" | mkV "แสดงอากัปกิริยา" | mkV "ติดต่อกันด้วยสัญญาณ" ; -- src=panlex
lin worth_Prep = variants{} ; -- 
lin call_N = mkN "การโทร" | mkN "การเรียก" | mkN "คำตัดสิน" | mkN "เสียงร้อง" | mkN "คอลออปชั่น" | mkN "การเรียกไพ่" | mkN "การโทรศัพท์" | mkN "เสียงนกร้อง" | mkN "การเรียกร้อง" | mkN "เสียงร้องตะโกน" | mkN "สัญญาณ" | mkN "การเรียก" | mkN "การมาเยี่ยม" | mkN "ความต้องการ" | mkN "การตะโกนเรียก" | mkN "การสนทนาทางโทรศัพท์" ; -- src=panlex
lin define_V2 = mkV2 "กำหนด" ; ---- | mkV "กำหนดคุณภาพ" | mkV "ระบุ" | mkV "นิยาม" | mkV "กําหนด" | mkV "บอกขอบเขต" | mkV "จํากัดความ" | mkV "กําหนดเขตแดน" | mkV "ทําให้ชัดเจน" | mkV "ให้คําจํากัดความ" | mkV "เป็นเครื่องหมายแสดง" ; -- src=panlex
lin define_V = mkV "กำหนด" | mkV "กำหนดคุณภาพ" | mkV "ระบุ" | mkV "นิยาม" | mkV "กําหนด" | mkV "บอกขอบเขต" | mkV "จํากัดความ" | mkV "กําหนดเขตแดน" | mkV "ทําให้ชัดเจน" | mkV "ให้คําจํากัดความ" | mkV "เป็นเครื่องหมายแสดง" ; -- src=panlex
lin stock_N = mkN "ด้าม" | mkN "หุ้น" | mkN "กำพืด" | mkN "ต้นตอ" | mkN "พันธุ์" | mkN "ใบหุ้น" | mkN "น้ำสต็อก" | mkN "ปศุสัตว์" | mkN "สายเลือด" | mkN "เชื้อสาย" | mkN "เน็กโคลท" | mkN "สายตระกูล" | mkN "ผู้สืบสกุล" | mkN "พานท้ายปืน" | mkN "สัตว์ในฟาร์ม" | mkN "สินค้าคงคลัง" | mkN "สินค้าในสต็อก" | mkN "เทือกเถาเหล่ากอ" | mkN "ดอกมัลคอล์มสต็อก" | mkN "ต้นกิลลีฟลาเวอร์" | mkN "ฐาน" | mkN "ก้าน" | mkN "ด้าม" | mkN "ตอไม้" | mkN "พัสดุ" | mkN "สต๊อค" | mkN "ลําต้น" | mkN "โคนต้น" | mkN "ของสะสม" | mkN "ปศุสัตว์" | mkN "พันธบัตร" | mkN "พืชพันธ์" | mkN "เขียงไม้" | mkN "คลังพัสดุ" | mkN "คลังสินค้า" | mkN "ก้านสมอเรือ" | mkN "แท่นต่อเรือ" | mkN "ไม้ค้ําเรือ" | mkN "สินค้าในร้าน" | mkN "บริษัทหุ้นส่วน" | mkN "จํานวนที่สะสมไว้" | mkN "ไม้หมอนใต้ท้องเรือ" | mkN "หลักทรัพย์ของบริษัท" ; -- src=panlex
lin influence_N = mkN "อิทธิพล" | mkN "อํานาจ" | mkN "อิทธิพล" | mkN "การจูงใจ" | mkN "เจ้าถิ่น" | mkN "การชักจูง" | mkN "สิ่งชักจูง" | mkN "การโน้มน้าว" | mkN "อํานาจชักจูง" | mkN "ผู้ทรงอิทธิพล" | mkN "การบังคับควบคุม" | mkN "มีอํานาจโน้มน้าว" ; -- src=panlex
lin occasion_N = mkN "วาระ" | mkN "โอกาส" | mkN "เหตุผล" | mkN "คราว" | mkN "ชนวน" | mkN "ฤกษ์" | mkN "เหตุ" | mkN "โอกาส" | mkN "จังหวะ" | mkN "ธุรกิจ" | mkN "สาเหตุ" | mkN "เหตุผล" | mkN "กาลสมัย" ; -- src=panlex
lin eventually_Adv = variants{} ; -- 
lin software_N = mkN "ซอฟต์แวร์" | mkN "โปรแกรมสำเร็จ" | mkN "คอมพิวเตอร์ซอฟต์แวร์" | mkN "ซอฟต์แวร์" ; -- src=panlex
lin highly_Adv = mkAdv "อย่างสูง" | mkAdv "เป็นอย่างยิ่ง" | mkAdv "อย่างมาก" | mkAdv "อย่างสูง" | mkAdv "อย่างยิ่ง" | mkAdv "ในราคาสูง" | mkAdv "ในระดับสูง" | mkAdv "โดยมีตําแหน่งสูง" | mkAdv "อย่างชื่นชมหรือยกย่องมาก" ; -- src=panlex
lin exchange_N = mkN "ชุมสาย" | mkN "การตีโต้" | mkN "การแลกกัน" | mkN "การแลกเรือ" | mkN "การแลกเปลี่ยน" | mkN "ชุมสายโทรศัพท์" | mkN "สถานที่ซื้อขาย" | mkN "การแลกเปลี่ยนเงินตรา" | mkN "การถกเถียง" | mkN "การโต้เถียง" | mkN "โทรศัพท์กลาง" | mkN "การแลกเปลี่ยน" | mkN "ศูนย์กลางการแลกเปลี่ยนทางการค้า" | mkN "ศูนย์ที่ใช้เชื่อมต่อสายโทรศัพท์" | mkN "ตึกที่ใช้ทํากิจกรรมทางการค้าต่างๆ" ; -- src=panlex
lin lack_N = mkN "ความขาดแคลน" | mkN "ความไม่เพียงพอ" | mkN "ความขาดแคลน" | mkN "ความไม่พอเพียง" | mkN "ความไม่เพียงพอ" ; -- src=panlex
lin shake_V2 = mkV2 "เชค" ; ---- | mkV "โยก" | mkV "สั่น" | mkV "ส่าย" | mkV "โคลง" | mkV "เขย่า" | mkV "หนีจาก" | mkV "โยกเยก" | mkV "กระตุ้น" | mkV "ปลุกเร้า" | mkV "โคลงเคลง" | mkV "สั่นสะเทือน" | mkV "ทำให้สั่นคลอน" | mkV "โยก" | mkV "สั่น" | mkV "เขย่า" | mkV "หวั่นไหว" | mkV "สะเทือนใจ" | mkV "ไม่มั่นคง" | mkV "ทําให้สั่น" | mkV "สั่นสะเทือน" | mkV "ทําให้ว้าวุ่นใจ" | mkV "ทําให้ตกใจและสะเทือนใจ" ; -- src=panlex
lin shake_V = mkV "เชค" | mkV "โยก" | mkV "สั่น" | mkV "ส่าย" | mkV "โคลง" | mkV "เขย่า" | mkV "หนีจาก" | mkV "โยกเยก" | mkV "กระตุ้น" | mkV "ปลุกเร้า" | mkV "โคลงเคลง" | mkV "สั่นสะเทือน" | mkV "ทำให้สั่นคลอน" | mkV "โยก" | mkV "สั่น" | mkV "เขย่า" | mkV "หวั่นไหว" | mkV "สะเทือนใจ" | mkV "ไม่มั่นคง" | mkV "ทําให้สั่น" | mkV "สั่นสะเทือน" | mkV "ทําให้ว้าวุ่นใจ" | mkV "ทําให้ตกใจและสะเทือนใจ" ; -- src=panlex
lin study_V2 = mkV2 "ภาวนา" ; ---- | mkV "ศึกษา" | mkV "เรียน" | mkV "ทำสมาธิ" | mkV "ตั้งสมาธิ" | mkV "วิเคราะห์" | mkV "อ่านหนังสือ" | mkV "เป็นนักเรียน" | mkV "เรียนหนังสือ" | mkV "ทำสมาธิเจริญภาวนา" | mkV "ศึกษา" | mkV "เรียน" | mkV "ตรวจสอบ" | mkV "พิจารณา" | mkV "วิเคราะห์" | mkV "เล่าเรียน" | mkV "พินิจพิจารณา" ; -- src=panlex
lin study_V = mkV "ภาวนา" | mkV "ศึกษา" | mkV "เรียน" | mkV "ทำสมาธิ" | mkV "ตั้งสมาธิ" | mkV "วิเคราะห์" | mkV "อ่านหนังสือ" | mkV "เป็นนักเรียน" | mkV "เรียนหนังสือ" | mkV "ทำสมาธิเจริญภาวนา" | mkV "ศึกษา" | mkV "เรียน" | mkV "ตรวจสอบ" | mkV "พิจารณา" | mkV "วิเคราะห์" | mkV "เล่าเรียน" | mkV "พินิจพิจารณา" ; -- src=panlex
lin concept_N = mkN "มโนภาพ" | mkN "แนวคิด" | mkN "คอนเซปต์" | mkN "มโนทัศน์" | mkN "มโนคติ" | mkN "มโนภาพ" | mkN "ความคิด" | mkN "ข้อคิดเห็น" | mkN "กรอบความคิด" | mkN "ความคิดรวบยอด" ; -- src=panlex
lin blue_A = mkA (thword "น้ำ" "เงิน") | {-pan-} mkA "ทะลึ่ง" | mkA "น้ำเงิน" | mkA "สองแง่สามง่าม" | mkA "ฟ้า" | mkA "ลามก" | mkA "สีฟ้า" | mkA "เคร่ง" | mkA "เสียใจ" | mkA "หยาบโลน" | mkA "เศร้าใจ" | mkA "เคร่งครัด" | mkA "สีน้ําเงิน" ; -- src=panlex --- (thword "สี" "น้ำ" "เงิน") ;
lin star_N = mkN (thword "ดาว") | {-pan-} mkN "ดาว" | mkN "ดวงดาว" | mkN "ดอกจัน" | mkN "ดารานำ" | mkN "ตัวเอก" | mkN "รูปดาว" | mkN "ดาวรุ่ง" | mkN "อัจฉริยะ" | mkN "นักแสดงนำ" | mkN "ผู้เชี่ยวชาญ" | mkN "อัจฉริยบุคคล" | mkN "ซุปเปอร์สตาร์" | mkN "ผู้เชี่ยวชาญเฉพาะด้าน" | mkN "ดาว" | mkN "โชค" | mkN "ดารา" | mkN "วาสนา" | mkN "ดวงดาว" | mkN "ดอกจัน" | mkN "ดวงชะตา" | mkN "ดาวฤกษ์" | mkN "นําแสดง" | mkN "โด่งดัง" | mkN "อินทรธนู" | mkN "เป็นดารา" | mkN "ดาวกระจาย" | mkN "เกี่ยวกับดาว" | mkN "ทําให้เป็นดารา" | mkN "แสดงเป็นตัวเอก" ; -- src=panlex
lin radio_N = mkN (thword "วิท" "ยุ") "เครื่อง" | {-pan-} mkN "วิทยุ" | mkN "ไวร์เลส" | mkN "ระบบไวร์เลส" | mkN "วิทยุสื่อสาร" | mkN "เครื่องวิทยุ" | mkN "เครื่องรับวิทยุ" | mkN "การกระจายเสียงวิทยุ" | mkN "วิทยุ" | mkN "เครื่องรับวิทยุ" | mkN "การสื่อสารทางวิทยุ" ; -- src=panlex
lin arrangement_N = mkN "การจัดระเบียบ" | mkN "การเรียบเรียง" | mkN "การจัดการพื้นที่" | mkN "การเรียบเรียงดนตรี" | mkN "การจัด" | mkN "การจัดการ" | mkN "การจัดเตรียม" | mkN "การตระเตรียม" | mkN "ลักษณะการจัด" | mkN "ภาวะที่ถูกจัด" | mkN "เพลงที่ได้มีการปรับปรุงใหม่" ; -- src=panlex
lin examine_V2 = variants{} ; -- 
lin bird_N = mkN (thword "นก") "ตัว" | {-pan-} mkN "นก" | mkN "วิหค" | mkN "ปักษา" | mkN "สกุณา" | mkN "ลูกแบด" | mkN "น้องนาง" | mkN "สาวน้อย" | mkN "เนื้อนก" | mkN "ลูกขนไก่" | mkN "ลูกแบดมินตัน" | mkN "เสียงโห่ร้อง" | mkN "เสียงร้องแสดงความโกรธ" | mkN "นก" | mkN "วิหค" | mkN "บุหรง" | mkN "สกุณา" | mkN "ลูกขนไก่" | mkN "สัตว์จําพวกมีปีก" | mkN "สัตว์จําพวกไก่และเป็ด" | mkN "สัตว์ปีกที่ใช้กินเป็นอาหาร" ; -- src=panlex
lin green_A = mkA "เขียว" | {-pan-} mkA "ซึ่งหลอกง่าย" | mkA "สด" | mkA "ขีด" | mkA "ดิบ" | mkA "ใหม่" | mkA "เร็ว ๆ นี้" | mkA "สีเขียว" | mkA "อ่อนหัด" | mkA "ใบไม้สด ๆ" | mkA "มีสีเขียว" | mkA "ยังไม่สุก" | mkA "เขียวชอุ่ม" | mkA "วัตถุสีเขียว" | mkA "ประกอบด้วยผัก" | mkA "ไร้ประสบการณ์" | mkA "ซึ่งเขียวชอุ่ม" | mkA "ซึ่งถูกฆ่าใหม่ ๆ" | mkA "ทุ่งหญ้าสีเขียว" | mkA "ยังไม่โตเต็มที่" | mkA "กิ่งไม้และใบไม้ที่ใช้เป็นอาหาร" ; -- src=panlex --- (thword "สี" "เขียว") ;
lin band_N = mkN "วง" | mkN "แถบ" | mkN "แหวน" | mkN "คอคอด" | mkN "แบนด์" | mkN "สายคาด" | mkN "สายรัด" | mkN "กลุ่มคน" | mkN "ธำมรงค์" | mkN "วงดนตรี" | mkN "วงสตริง" | mkN "สายรุ้ง" | mkN "พระธำมรงค์" | mkN "วงดนตรีสตริง" | mkN "คณะ" | mkN "พวก" | mkN "แถบ" | mkN "พันธะ" | mkN "เชือก" | mkN "แตรวง" | mkN "สายคาด" | mkN "สายรัด" | mkN "กลุ่มคน" | mkN "วงดนตรี" | mkN "ข้อผูกพัน" | mkN "ข้อผูกมัด" | mkN "แถบคลื่นวิทยุ" | mkN "แถบคลื่นความถี่" ; -- src=panlex
lin sex_N = mkN "เพศ" | mkN "เพศสภาพ" | mkN "อารมณ์ทางเพศ" | mkN "กิจกรรมทางเพศ" | mkN "ความรู้สึกทางเพศ" | mkN "กาม" | mkN "เพศ" | mkN "อวัยวะเพศ" | mkN "การร่วมเพศ" | mkN "เรื่องประเวณี" | mkN "การร่วมประเวณี" | mkN "ความสนใจทางเพศ" | mkN "สัญชาตญาณทางเพศ" | mkN "ความรู้สึกทางเพศ" | mkN "ความสนใจเรื่องเพศ" | mkN "เสน่ห์ดึงดูดทางเพศ" ; -- src=panlex
lin finger_N = mkN "นิ้ว" | mkN "นิ้วมือ" | mkN "ฟิงเกอร์" | mkN "นิ้ว" | mkN "เล่น" | mkN "นิ้วมือ" | mkN "ความยาวเป็นนิ้วมือ" | mkN "ความกว้างของนิ้วมือ" | mkN "สิ่งที่คล้ายนิ้วมือ" | mkN "ส่วนที่สวมใส่นิ้วของถุงมือ" | mkN "ส่วนที่ยื่นออกมามีลักษณะคล้ายนิ้วมือ" ; -- src=panlex
lin past_N = mkN "อดีต" | mkN "วันวาน" | mkN "อดีตกาล" | mkN "พาสเทนส์" | mkN "ชีวิตในอดีต" | mkN "อดีต" | mkN "สิ่งที่เกิดในอดีต" | mkN "เวลาที่ผ่านไปแล้ว" | mkN "เหตุการณ์ที่ผ่านไปแล้ว" ; -- src=panlex
lin independent_A = variants{} ; -- 
lin independent_2_A = variants{} ; -- 
lin independent_1_A = variants{} ; -- 
lin equipment_N = mkN "อุปกรณ์" | mkN "อุปกรณ์" | mkN "เครื่องมือ" | mkN "การจัดให้มี" | mkN "การจัดหามาให้" | mkN "เครื่องประกอบ" | mkN "การติดตั้งเครื่องมือ" ; -- src=panlex
lin north_N = mkN "น." | mkN "เหนือ" | mkN "ทิศเหนือ" | mkN "ภาคเหนือ" | mkN "ทิศเหนือเข็มทิศ" | mkN "อุดร" | mkN "เหนือ" | mkN "ทิศเหนือ" ; -- src=panlex
lin mind_VS = mmkVS "ระวัง" ; ---- | mkV "เอาใจใส่" | mkV "รู้สึกกังวล" | mkV "เก็บไว้ในใจ" | mkV "ระวัง" | mkV "สังเกต" | mkV "เกี่ยง" | mkV "เข้าใจ" | mkV "คัดค้าน" | mkV "รังเกียจ" | mkV "ระมัดระวัง" | mkV "เอาใจใส่ดูแล" | mkV "ไม่เต็มใจทําบางสิ่ง" ; -- src=panlex
lin mind_V2 = mkV2 "ระวัง" ; ---- | mkV "เอาใจใส่" | mkV "รู้สึกกังวล" | mkV "เก็บไว้ในใจ" | mkV "ระวัง" | mkV "สังเกต" | mkV "เกี่ยง" | mkV "เข้าใจ" | mkV "คัดค้าน" | mkV "รังเกียจ" | mkV "ระมัดระวัง" | mkV "เอาใจใส่ดูแล" | mkV "ไม่เต็มใจทําบางสิ่ง" ; -- src=panlex
lin mind_V = mkV "ระวัง" | mkV "เอาใจใส่" | mkV "รู้สึกกังวล" | mkV "เก็บไว้ในใจ" | mkV "ระวัง" | mkV "สังเกต" | mkV "เกี่ยง" | mkV "เข้าใจ" | mkV "คัดค้าน" | mkV "รังเกียจ" | mkV "ระมัดระวัง" | mkV "เอาใจใส่ดูแล" | mkV "ไม่เต็มใจทําบางสิ่ง" ; -- src=panlex
lin move_N = mkN "การขยับ" | mkN "การย้าย" | mkN "การเดิน" | mkN "การเดินหมาก" | mkN "การเคลื่อนที่" | mkN "การเคลื่อนไหว" | mkN "การย้ายที่อยู่" | mkN "ความเคลื่อนไหว" | mkN "การขยับ" | mkN "การอพยพ" | mkN "การรุกคืบ" | mkN "การโยกย้าย" | mkN "การย้ายบ้าน" | mkN "การดําเนินการ" | mkN "การเคลื่อนไหว" | mkN "การเปลี่ยนงาน" | mkN "การย้ายที่อยู่" | mkN "การเคลื่อนย้าย" | mkN "การทําให้เจริญก้าวหน้า" ; -- src=panlex
lin message_N = mkN "แมสเซจ" | mkN "ข้อความ" | mkN "เนื้อหา" | mkN "คอนเท็นต์" | mkN "เนื้อเรื่อง" | mkN "สาร" | mkN "ข่าวสาร" | mkN "ข้อความ" | mkN "ถ้อยคํา" | mkN "ประเด็น" | mkN "เนื้อหา" | mkN "ข่าวคราว" | mkN "ความหมาย" | mkN "เนื้อความ" | mkN "จุดหมายหรือคําพูดที่ฝากไปให้บุคคลอื่น" ; -- src=panlex
lin fear_N = mkN (thword "ความ" "กลัว") | {-pan-} mkN "ความกลัว" | mkN "ความยำเกรง" | mkN "ความกลัวเกรง" | mkN "ความหวาดกลัว" | mkN "ความเกรงกลัว" | mkN "กลัว" | mkN "ยั่น" | mkN "ความกลัว" | mkN "ความตกใจ" | mkN "หวาดกลัว" | mkN "ความเกรงกลัว" ; -- src=panlex
lin afternoon_N = mkN "ตอนบ่าย" | mkN "บ่าย" | mkN "จวนเย็น" | mkN "ตอนบ่าย" | mkN "ยามบ่าย" | mkN "ช่วงหลัง" | mkN "หลังบ่าย" | mkN "หลังเที่ยง" | mkN "ช่วงหลังของชีวิต" ; -- src=panlex
lin drink_V2 = mkV2 (thword "ดื่ม") ;
lin drink_V = mkV "กิน" | mkV "ดื่ม" | mkV "ดื่มด่ำ" | mkV "กินเหล้า" | mkV "ดื่มหนัก" | mkV "ดื่มอวยพร" | mkV "ดื่มเหล้า" | mkV "กินแต่เหล้า" | mkV "กิน" | mkV "ดื่ม" ; -- src=panlex
lin fully_Adv = mkAdv "เพียบ" | mkAdv "อย่างเต็มที่" | mkAdv "อย่างเพียงพอ" | mkAdv "อย่างครบถ้วน" | mkAdv "อย่างสมบูรณ์" | mkAdv "อย่างเต็มที่" ; -- src=panlex
lin race_N = variants{} ; -- 
lin race_2_N = variants{} ; -- 
lin race_1_N = variants{} ; -- 
lin gain_V2 = mkV2 "ถึง" ; ---- | mkV "ได้" | mkV "ขึ้น" | mkV "มาถึง" | mkV "เพิ่ม" | mkV "ไปถึง" | mkV "ขึ้นนำ" | mkV "ได้รับ" | mkV "ขึ้นแท่น" | mkV "ได้เปรียบ" | mkV "เพิ่มน้ำหนัก" | mkV "ประสบความสำเร็จ" | mkV "บรรลุ" | mkV "มาถึง" | mkV "เพิ่ม" | mkV "ไปถึง" | mkV "ได้รับ" | mkV "สําเร็จ" | mkV "ได้กําไร" | mkV "ได้ประโยชน์" | mkV "ทําให้มากขึ้น" | mkV "เอาชนะจนได้บางสิ่งมา" ; -- src=panlex
lin gain_V = mkV "ถึง" | mkV "ได้" | mkV "ขึ้น" | mkV "มาถึง" | mkV "เพิ่ม" | mkV "ไปถึง" | mkV "ขึ้นนำ" | mkV "ได้รับ" | mkV "ขึ้นแท่น" | mkV "ได้เปรียบ" | mkV "เพิ่มน้ำหนัก" | mkV "ประสบความสำเร็จ" | mkV "บรรลุ" | mkV "มาถึง" | mkV "เพิ่ม" | mkV "ไปถึง" | mkV "ได้รับ" | mkV "สําเร็จ" | mkV "ได้กําไร" | mkV "ได้ประโยชน์" | mkV "ทําให้มากขึ้น" | mkV "เอาชนะจนได้บางสิ่งมา" ; -- src=panlex
lin strategy_N = mkN "กลยุทธ์" | mkN "ยุทธศาสตร์" | mkN "อุบาย" | mkN "กลยุทธ" | mkN "กลวิธี" | mkN "กโลบาย" | mkN "แผนการ" | mkN "วิธีการ" | mkN "โครงการ" | mkN "ยุทธวิธี" | mkN "แผนการณ์" | mkN "ยุทธศาสตร์" ; -- src=panlex
lin extra_A = mkA "พิเศษ" | mkA "เสริม" | mkA "ที่เกิน" | mkA "เพิ่มเติม" | mkA "เป็นพิเศษ" | mkA "เหนือกว่า" | mkA "ดีกว่าปกติ" ; -- src=panlex
lin scene_N = mkN "ฉาก" | mkN "ซีน" | mkN "มุมมอง" | mkN "ฉากละคร" | mkN "ทิวทัศน์" | mkN "อารมณ์เสีย" | mkN "ที่เกิดเหตุ" | mkN "ฉาก" | mkN "ตอน" | mkN "ภาพ" | mkN "เวที" | mkN "บทหนึ่ง" | mkN "ตอนหนึ่ง" | mkN "ทิวทัศน์" | mkN "ทัศนียภาพ" | mkN "สถานการณ์" | mkN "อาการโกรธ" | mkN "เรื่องราว" | mkN "เหตุการณ์" | mkN "จุดเกิดเหตุ" | mkN "ที่เกิดเหตุ" | mkN "สิ่งแวดล้อม" | mkN "ภาพภูมิประเทศ" | mkN "การแสดงความโกรธ" | mkN "สถานที่เกิดเหตุ" | mkN "อุปกรณ์ประกอบฉาก" | mkN "การแสดงความไม่พอใจ" ; -- src=panlex
lin slightly_Adv = variants{} ; -- 
lin kitchen_N = mkN "ครัว" | mkN "ห้องครัว" | mkN "ห้องเครื่อง" | mkN "ห้องประกอบอาหาร" | mkN "สถานที่ประกอบอาหาร" | mkN "ครัว" | mkN "การครัว" | mkN "ห้องครัว" | mkN "เครื่องครัว" ; -- src=panlex
lin speech_N = mkN "บท" | mkN "ภาษา" | mkN "บทพูด" | mkN "ภาษาพูด" | mkN "วิธีการพูด" | mkN "การสื่อสารด้วยภาษา" | mkN "ภาษา" | mkN "การพูด" | mkN "คําพูด" | mkN "ข่าวลือ" | mkN "ถ้อยคํา" | mkN "การกล่าว" | mkN "คําบรรยาย" | mkN "สุนทรพจน์" | mkN "คําปราศรัย" | mkN "ภาษาชนชาติ" | mkN "วิธีการพูด" | mkN "คําสุนทรพจน์" | mkN "วิชาเกี่ยวกับการพูด" ; -- src=panlex
lin arise_V = mkV "ยืน" | mkV "ตื่น" | mkV "ก่อกบฏ" | mkV "เป็นผล" | mkV "ตื่นนอน" | mkV "ลุกขึ้น" | mkV "เริ่มต้น" | mkV "ก่อการกบฏ" | mkV "ตื่นบรรทม" | mkV "ผลุบๆโผล่ๆ" | mkV "เคลื่อนขึ้น" | mkV "ตื่นพระบรรทม" | mkV "ขึ้นสูง" | mkV "บังเกิด" | mkV "เกิดขึ้น" | mkV "เคลื่อนที่ขึ้น" | mkV "ลุกขึ้นจากเตียง" ; -- src=panlex
lin network_N = mkN "ตาข่าย" | mkN "เครือข่าย" | mkN "เน็ตเวิร์ก" | mkN "เน็ตเวิร์ค" | mkN "เครือข่ายไฟฟ้า" | mkN "ตาข่าย" | mkN "ร่างแห" | mkN "เครือข่าย" | mkN "เน็ตเวิร์ค" | mkN "ระบบเครือข่าย" | mkN "แผนประสานซึ่งกันและกัน" | mkN "สิ่งที่คล้ายร่างแหหรือตาข่าย" ; -- src=panlex
lin tea_N = mkN "ชา" | mkN "ที" | mkN "ใบชา" | mkN "ต้นชา" | mkN "น้ำชา" | mkN "น้ำชายามบ่าย" | mkN "ชา" | mkN "ใบชา" | mkN "กัญชา" | mkN "ต้นชา" | mkN "น้ําชา" | mkN "งานเลี้ยงน้ําชา" | mkN "เครื่องดื่มใส่ชา" | mkN "ของว่างที่รับประทานเวลาน้ําชา" ; -- src=panlex
lin peace_N = mkN (thword "สัน" "ติ" "ภาพ") | {-pan-} mkN "ใจสงบ" | mkN "ความสงบ" | mkN "ช่วงปลอดสงคราม" | mkN "สนธิสัญญาสันติภาพ" | mkN "สันติ" | mkN "ความสงบ" | mkN "สันติภาพ" | mkN "ความสงบเรียบร้อย" | mkN "สนธิสัญญาสันติภาพ" ; -- src=panlex ----?
lin failure_N = mkN "คนพ่ายแพ้" | mkN "คนล้มเหลว" | mkN "ผู้พ่ายแพ้" | mkN "การล้มละลาย" | mkN "ความล้มเหลว" | mkN "การล้มราชบัลลังก์" | mkN "การสอบตก" | mkN "การขาดแคลน" | mkN "ความล้มเหลว" | mkN "ภาวะล้มละลาย" | mkN "ความเสื่อมถอย" | mkN "ผู้ที่ล้มเหลว" | mkN "สิ่งที่ล้มเหลว" | mkN "การได้ต่ํากว่าที่กําหนด" ; -- src=panlex
lin employee_N = mkN "พนง." | mkN "พนักงาน" | mkN "ลูกจ้าง" | mkN "พนักงาน" | mkN "ลูกจ้าง" ; -- src=panlex
lin ahead_Adv = mkAdv "ตรงไป" | mkAdv "ข้างหน้า" | mkAdv "ล่วงหน้า" | mkAdv "สู่อนาคต" | mkAdv "อยู่หน้า" | mkAdv "อย่างคู่คี่" | mkAdv "ชนะไป" | mkAdv "ต่อไป" | mkAdv "ออกหน้า" | mkAdv "ในอนาคต" | mkAdv "ด้านหน้า" | mkAdv "ล้ําหน้า" | mkAdv "แต้มนําไป" | mkAdv "ขึ้นหน้าไป" | mkAdv "ไปข้างหน้า" | mkAdv "ก่อนหน้านี้" ; -- src=panlex
lin scale_N = mkN "สเกล" | mkN "แผ่น" | mkN "เกล็ด" | mkN "ขี้ไคล" | mkN "ขี้รังแค" | mkN "มาตราส่วน" | mkN "สเกลดนตรี" | mkN "ระบบการวัด" | mkN "ใบรูปเกล็ด" | mkN "เครื่องชั่ง" | mkN "เครื่องชั่งน้ำหนัก" | mkN "กาบ" | mkN "ต้อ" | mkN "ขนาด" | mkN "คราบ" | mkN "ชั้น" | mkN "ตาชู" | mkN "มาตร" | mkN "ระดับ" | mkN "อัตรา" | mkN "เกล็ด" | mkN "ตาชั่ง" | mkN "ปีนไต่" | mkN "สะเก็ด" | mkN "เปลือก" | mkN "ตราชั่ง" | mkN "บรรลุผล" | mkN "น้ําหนัก" | mkN "สนิมน้ํา" | mkN "เกล็ดปลา" | mkN "จานตาชั่ง" | mkN "มาตราส่วน" | mkN "ระดับชั้น" | mkN "ระดับเสียง" | mkN "ระบบการวัด" | mkN "เอาคราบออก" | mkN "มาตราการนับ" | mkN "เครื่องชั่ง" | mkN "เอาเกล็ดออก" | mkN "ความใหญ่เล็ก" | mkN "ทําตามขั้นตอน" | mkN "วัดตามขั้นตอน" | mkN "ระบบเลื่อนชั้น" | mkN "การแบ่งเป็นขีด ๆ" | mkN "มาตราส่วนแผนที่" | mkN "การแบ่งเป็นชั้น ๆ" | mkN "วัดด้วยไม้บรรทัด" | mkN "หินปูนที่เกาะฟัน" | mkN "ไม้บรรทัดที่มีเส้นแบ่ง" | mkN "เครื่องวัดที่มีเส้นแบ่ง" ; -- src=panlex
lin hardly_Adv = variants{} ; -- 
lin attend_V2 = mkV2 "จัดการ" ; ---- | mkV "รับใช้" | mkV "เข้าร่วม" | mkV "ตั้งใจฟัง" | mkV "ตาม" | mkV "ไปกับ" | mkV "รับใช้" | mkV "เข้าร่วม" | mkV "ฟังหรือดูอย่างตั้งใจ" ; -- src=panlex
lin attend_V = mkV "จัดการ" | mkV "รับใช้" | mkV "เข้าร่วม" | mkV "ตั้งใจฟัง" | mkV "ตาม" | mkV "ไปกับ" | mkV "รับใช้" | mkV "เข้าร่วม" | mkV "ฟังหรือดูอย่างตั้งใจ" ; -- src=panlex
lin shoulder_N = mkN "บ่า" | mkN "ไหล่" | mkN "ข้อไหล่" | mkN "หัวไหล่" | mkN "พระอังสา" | mkN "ผ้าคลุมไหล่" | mkN "เนื้อขาหน้าช่วงบน" | mkN "บ่อ" | mkN "บ่า" | mkN "แบก" | mkN "ไหล่" | mkN "สะบัก" | mkN "ขอบถนน" | mkN "หัวไหล่" | mkN "ไหล่ถนน" | mkN "ไหล่ทาง" | mkN "ไหล่เขา" | mkN "รับผิดชอบ" | mkN "ไหล่เสื้อ" | mkN "ใช้ไหล่เบียด" | mkN "เนื้อขาหน้าช่วงบนของสัตว์" ; -- src=panlex
lin otherwise_Adv = mkAdv "แตกต่าง" | mkAdv "มิฉะนั้น" | mkAdv "หาไม่แล้ว" | mkAdv "ตรงกันข้าม" | mkAdv "อีกอย่างหนึ่ง" | mkAdv "เป็นอย่างอื่น" | mkAdv "ถ้าไม่เช่นนั้น" | mkAdv "อย่างเป็นไปในทิศทางตรงกันข้าม" ; -- src=panlex
lin railway_N = mkN "ทางรถไฟ" | mkN "รางรถไฟ" | mkN "ระบบทางรถไฟ" | mkN "ทางรถไฟ" | mkN "รางรถไฟ" | mkN "ระบบทางรถไฟ" | mkN "ระบบทางรถไฟทางรถ" ; -- src=panlex
lin directly_Adv = variants{} ; -- 
lin supply_N = mkN "อุปทาน" | mkN "การจัดหา" | mkN "บรรจุ" | mkN "หาให้" | mkN "จัดส่ง" | mkN "จัดหาให้" ; -- src=panlex
lin expression_N = mkN "สูตร" | mkN "สีหน้า" | mkN "คำกล่าว" | mkN "การแสดงออก" | mkN "การแสดงสีหน้า" | mkN "โครงสร้างประโยค" | mkN "โครงสร้างทางไวยากรณ์" | mkN "สูตร" | mkN "ศัพท์" | mkN "สีหน้า" | mkN "สํานวน" | mkN "การแสดง ออกเป็นคําพูด" | mkN "น้ําเสียง" | mkN "การแสดงออก" | mkN "เครื่องหมาย" | mkN "ลักษณะท่าทาง" | mkN "เหนือคําพรรณนา)" | mkN "คําพูดที่แสดงออก" | mkN "การแสดงออกทางสีหน้า" | mkN "การแสดงความรู้สึกทางสีหน้า" | mkN "การแสดงเครื่องหมายหรือสูตร" ; -- src=panlex
lin owner_N = mkN "เจ้าของ" | mkN "ผู้ครอบครอง" | mkN "ผู้เป็นเจ้าของ" | mkN "เจ้าของทรัพย์สิน" | mkN "เจ้าของ" | mkN "ผู้เป็นเจ้าของ" ; -- src=panlex
lin associate_V2 = mkV2 "รวมกลุ่ม" ; ---- | mkV "มีความสัมพันธ์" | mkV "เชื่อม" | mkV "รวมกลุ่ม" | mkV "เชื่อมโยง" | mkV "เข้ารวมกัน" | mkV "คบค้าสมาคมกัน" | mkV "ทําให้รู้จักกัน" | mkV "รู้จักเป็นเพื่อนกัน" ; -- src=panlex
lin associate_V = mkV "รวมกลุ่ม" | mkV "มีความสัมพันธ์" | mkV "เชื่อม" | mkV "รวมกลุ่ม" | mkV "เชื่อมโยง" | mkV "เข้ารวมกัน" | mkV "คบค้าสมาคมกัน" | mkV "ทําให้รู้จักกัน" | mkV "รู้จักเป็นเพื่อนกัน" ; -- src=panlex
lin corner_N = mkN "มุม" | mkN "มุมตึก" | mkN "หัวมุมถนน" | mkN "ถิ่นที่ห่างไกล" | mkN "การควบคุมทางการค้า" | mkN "มุม" | mkN "หัวถนน" | mkN "เหลี่ยม" | mkN "การผูกขาด" | mkN "การเตะมุม" | mkN "หัวต่อถนน" | mkN "ที่สงบเงียบ" | mkN "สถานการณ์ที่ยากลําบาก" | mkN "การเตะลูกจากมุมสนามฟุตบอล" | mkN "จุดที่ถนนสองสายมาบรรจบกัน" | mkN "สิ่งที่ทํามาเพื่อให้วางเข้ามุม" ; -- src=panlex
lin past_A = mkA "อดีต" | mkA "พ้น" | mkA "ที่ผ่านไปแล้ว" ; -- src=panlex
lin match_N = variants{} ; -- 
lin match_3_N = variants{} ; -- 
lin match_2_N = variants{} ; -- 
lin match_1_N = variants{} ; -- 
lin sport_N = mkN "กีฬา" | mkN "สปอร์ต" | mkN "การกีฬา" | mkN "นักกีฬา" | mkN "กีฬาอาชีพ" | mkN "สิ่งมีชีวิตกลายพันธุ์" | mkN "กีฬา" | mkN "กรีฑา" | mkN "นักเลง" | mkN "การเล่น" | mkN "งานกีฬา" | mkN "นักกีฬา" | mkN "นักพนัน" | mkN "เล่นกีฬา" | mkN "นันทนาการ" | mkN "การหยอกล้อ" | mkN "เพลิดเพลิน" | mkN "สิ่งบันเทิง" | mkN "เครื่องสนุก" | mkN "เครื่องเล่น" | mkN "ความสนุกสนาน" | mkN "จู้จี้ในสิ่งเล็ก ๆ" | mkN "การพักผ่อนหย่อนใจ" | mkN "ผู้ที่มีน้ําใจนักกีฬา" | mkN "ผู้ที่ยังยิ้มได้แม้ยามพ่ายแพ้" ; -- src=panlex
lin status_N = mkN "ฐานะ" | mkN "ภาวะ" | mkN "สภาพ" | mkN "สถานะ" | mkN "สภาวะ" | mkN "ตำแหน่ง" | mkN "สถานภาพ" | mkN "ยศ" | mkN "ฐานะ" | mkN "ภาวะ" | mkN "สภาพ" | mkN "สถานะ" | mkN "สถานภาพ" | mkN "ตําแหน่ง" | mkN "สภาพการณ์" ; -- src=panlex
lin beautiful_A = mkA "สวย" | {-pan-} mkA "งาม" | mkA "ดี" | mkA "งาม" | mkA "เลิศ" | mkA "งดงาม" | mkA "ดีมาก" | mkA "สดสวย" | mkA "สวยงาม" | mkA "ยอดเยี่ยม" ; -- src=panlex
lin offer_N = mkN "ความพยายาม" | mkN "สิ่งที่เสนอให้" | mkN "ข้อเสนอ" | mkN "ราคาที่ลดลง" | mkN "สิ่งที่เสนอ" ; -- src=panlex
lin marriage_N = mkN "การสมรส" | mkN "คู่สมรส" | mkN "ชีวิตคู่" | mkN "ชีวิตสมรส" | mkN "การแต่งงาน" | mkN "คู่แต่งงาน" | mkN "การออกเรือน" | mkN "พิธีมงคลสมรส" | mkN "การเกี่ยวพันกัน" | mkN "การสมรส" | mkN "พิธีสมรส" | mkN "การแต่งงาน" | mkN "พิธีแต่งงาน" | mkN "ภาวะที่แต่งงานกัน" | mkN "การรวมกันอย่างแนบแน่น" | mkN "การรวมสองสิ่งเข้าไว้ด้วยกัน" ; -- src=panlex
lin hang_V2 = mkV2 "พาด" ; ---- | mkV "ห้อย" | mkV "แขวน" | mkV "แขวนคอ" | mkV "ตั้งใจฟัง" | mkV "ห้อย" | mkV "แขวน" | mkV "ฆ่าด้วยการแขวนคอ" ; -- src=panlex
lin hang_V = mkV "พาด" | mkV "ห้อย" | mkV "แขวน" | mkV "แขวนคอ" | mkV "ตั้งใจฟัง" | mkV "ห้อย" | mkV "แขวน" | mkV "ฆ่าด้วยการแขวนคอ" ; -- src=panlex
lin civil_A = mkA "ที่มีวัฒนธรรม" | mkA "เกี่ยวกับพลเรือน" | mkA "ที่เกี่ยวกับพลเมือง" ; -- src=panlex
lin perform_V2 = mkV2 "จัด" ; ---- | mkV "แสดง" | mkV "รับงาน" | mkV "รับงานมาทำ" | mkV "ทํา" | mkV "กระทํา" | mkV "ทํางาน" | mkV "ปฏิบัติ" | mkV "เล่นดนตรี" | mkV "ทําให้สําเร็จ" | mkV "ประกอบหน้าที่" | mkV "ปฏิบัติหน้าที่" ; -- src=panlex
lin perform_V = mkV "จัด" | mkV "แสดง" | mkV "รับงาน" | mkV "รับงานมาทำ" | mkV "ทํา" | mkV "กระทํา" | mkV "ทํางาน" | mkV "ปฏิบัติ" | mkV "เล่นดนตรี" | mkV "ทําให้สําเร็จ" | mkV "ประกอบหน้าที่" | mkV "ปฏิบัติหน้าที่" ; -- src=panlex
lin sentence_N = mkN "ประโยค" | mkN "โทษจำคุก" | mkN "การพิพากษา" | mkN "การพิพากษาลงโทษ" | mkN "คําคม" | mkN "ประโยค" | mkN "คติพจน์" | mkN "พิพากษา" | mkN "การลงโทษ" | mkN "การชี้ขาด" | mkN "การตัดสิน" | mkN "การพิพากษา" | mkN "การตัดสินลงโทษ" ; -- src=panlex
lin crime_N = mkN "อาชญากรรม" | mkN "การก่ออาชญากรรม" | mkN "บาป" | mkN "อาชญากรรม" | mkN "ความผิดร้ายแรง" | mkN "การกระทําที่ผิดศีลธรรม" | mkN "การกระทําอาชญากรรมและผู้กระทํา" | mkN "การกระทําที่โง่ไร้ความสํานึกหรือน่าอับอาย" ; -- src=panlex
lin ball_N = mkN "บอล" | mkN "ลูก" | mkN "ก้อน" | mkN "อัณฑะ" | mkN "ลูกบอล" | mkN "ก้อนกลม" | mkN "ก้อนดิน" | mkN "เล็ดไข่" | mkN "ก้อนกลมๆ" | mkN "งานบอลล์" | mkN "พระอัณฑะ" | mkN "ลูกอัณฑะ" | mkN "กลุ่มก้อน" | mkN "รูปทรงกลม" | mkN "ลูกกระสุน" | mkN "ลูกกระแป๋ง" | mkN "ลูก" | mkN "ลูกตา" | mkN "งานบอล" | mkN "ลูกบอล" | mkN "ก้อนกลม" | mkN "งานลีลาศ" | mkN "งานเลี้ยง" | mkN "การขว้างบอล" | mkN "งานราตรีสโมสร" | mkN "ลูกลักษณะกลมๆ" | mkN "สโมสรสันนิบาต" | mkN "สิ่งที่เป็นรูปทรงกลม" | mkN "ส่วนของร่างกายที่มีลักษณะกลม" ; -- src=panlex
lin marry_V2 = mkV2 "สมรส" ; ---- | mkV "แต่ง" | mkV "วิวาห์" | mkV "แต่งงาน" | mkV "ทำพิธีสมรส" | mkV "อภิเษกสมรส" | mkV "จัดงานแต่งงาน" | mkV "ทำพิธีแต่งงาน" | mkV "สมรส" | mkV "แต่งงาน" | mkV "ทําพิธีสมรส" | mkV "เข้ากันได้ดี" | mkV "จับเข้าคู่กัน" | mkV "ประกอบพิธีแต่งงาน" | mkV "" ; -- src=panlex
lin marry_V = mkV "สมรส" | mkV "แต่ง" | mkV "วิวาห์" | mkV "แต่งงาน" | mkV "ทำพิธีสมรส" | mkV "อภิเษกสมรส" | mkV "จัดงานแต่งงาน" | mkV "ทำพิธีแต่งงาน" | mkV "สมรส" | mkV "แต่งงาน" | mkV "ทําพิธีสมรส" | mkV "เข้ากันได้ดี" | mkV "จับเข้าคู่กัน" | mkV "ประกอบพิธีแต่งงาน" | mkV "" ; -- src=panlex
lin wind_N = mkN (thword "ลม") | {-pan-} mkN "ลม" | mkN "การตด" | mkN "ลมปาก" | mkN "สายลม" | mkN "พระพาย" | mkN "กระแสลม" | mkN "การผายลม" | mkN "เครื่องเป่า" | mkN "การพูดไร้สาระ" | mkN "เครื่องดนตรีประเภทเป่า" | mkN "ลม" | mkN "วาตะ" | mkN "การขด" | mkN "หายใจ" | mkN "การพัน" | mkN "ลมเป่า" | mkN "กระแสลม" | mkN "การม้วน" | mkN "การหมุน" | mkN "ทางโค้ง" | mkN "พื้นฐาน" | mkN "ลมกลิ่น" | mkN "ลมหายใจ" | mkN "การกว้าน" | mkN "การคุยโว" | mkN "ทิศทางลม" | mkN "แรงอิทธิพล" | mkN "ทางคดเคี้ยว" | mkN "ลมที่อัดไว้" | mkN "การคุยโม้โอ้อวด" | mkN "การเปลี่ยนทิศทาง" | mkN "ความสามารถในการหายใจ" | mkN "ลมในกระเพาะหรือลําไส้" | mkN "เครื่องดนตรีประเภทเป่า" | mkN "เครื่องดนตรีแบบใช้ลมเป่า" ; -- src=panlex
lin truth_N = mkN "ความจริง" | mkN "ความเหมือนจริง" | mkN "สัจธรรม" | mkN "ความจริง" | mkN "ความแน่แท้" | mkN "ข้อเท็จจริง" | mkN "ความถูกต้อง" | mkN "ความซื่อสัตย์" ; -- src=panlex
lin protect_V2 = mkV2 "คุ้มกัน" ; ---- | mkV "ตั้งกำแพงภาษี" | mkV "ป้องกันอันตราย" | mkV "ปกป้อง" | mkV "ป้องกัน" | mkV "อารักขา" | mkV "คุ้มครอง" | mkV "ตั้งภาษีสินค้านําเข้าเพื่อคุ้มครองสินค้าในประเทศ" ; -- src=panlex
lin protect_V = mkV "คุ้มกัน" | mkV "ตั้งกำแพงภาษี" | mkV "ป้องกันอันตราย" | mkV "ปกป้อง" | mkV "ป้องกัน" | mkV "อารักขา" | mkV "คุ้มครอง" | mkV "ตั้งภาษีสินค้านําเข้าเพื่อคุ้มครองสินค้าในประเทศ" ; -- src=panlex
lin safety_N = mkN "ถุง" | mkN "ถุงยาง" | mkN "ถุงมีชัย" | mkN "ที่ปลอดภัย" | mkN "ความปลอดภัย" | mkN "ถุงยางอนามัย" | mkN "อุปกรณ์นิรภัย" | mkN "สถานที่ปลอดภัย" | mkN "ความปลอดภัย" | mkN "ความไม่มีภัย" | mkN "เครื่องป้องกัน" | mkN "ถุงยางคุมกําเนิด" | mkN "สถานที่ที่ปลอดภัย" | mkN "อุปกรณ์ป้องกันภัย" | mkN "การไม่ได้รับบาดเจ็บ" | mkN "อุปกรณ์รักษาความปลอดภัย" ; -- src=panlex
lin partner_N = mkN "คู่" | mkN "คู่ครอง" | mkN "คู่ชีวิต" | mkN "หุ้นส่วน" | mkN "ผู้ร่วมงาน" | mkN "พาร์ตเนอร์" | mkN "คู่ผัวตัวเมีย" | mkN "คู่สามมีภรรยา" | mkN "ผู้เป็นหุ้นส่วน" | mkN "คู่สมรส" | mkN "หุ้นส่วน" | mkN "คู่เต้นรํา" | mkN "ผู้ร่วมมือ" | mkN "ผู้ร่วมกระทํา" | mkN "คู่สามีหรือภรรยา" ; -- src=panlex
lin completely_Adv = variants{} ; -- 
lin copy_N = mkN "สำเนา" | mkN "ก็อปปี้" | mkN "ของก็อป" | mkN "ฉบับสำเนา" | mkN "ของก็อปปี้" | mkN "ฉบับก็อปปี้" | mkN "สำเนาบันทึก" | mkN "ลอกแบบ" | mkN "สําเนา" | mkN "เลียนแบบ" | mkN "เอาอย่าง" | mkN "อัดสําเนา" | mkN "ฉบับสําเนา" | mkN "เล่มคัดลอก" | mkN "1ชุด" | mkN "1ฉบับ" | mkN "1เล่ม" ; -- src=panlex
lin balance_N = mkN "ดุลบัญชี" | mkN "ความสมดุล" | mkN "ความสมมาตร" | mkN "ส่วนที่เหลือ" | mkN "การรักษาสมดุล" | mkN "ตัวถ่วงน้ำหนัก" | mkN "น้ำหนักถ่วงดุล" | mkN "ยอดเงินคงเหลือ" | mkN "ความเท่าเทียมกัน" | mkN "สติ" | mkN "ตาชู" | mkN "งบดุล" | mkN "ตาชั่ง" | mkN "ตาเต็ง" | mkN "คันชั่ง" | mkN "ดุลยภาพ" | mkN "ยอดยกไป" | mkN "การทรงตัว" | mkN "ความสมดุล" | mkN "ความสุขุม" | mkN "สภาพคงที่" | mkN "จํานวนเหลือ" | mkN "ปิดบัญชีคงเหลือ" ; -- src=panlex
lin sister_N = mkN (thword "พี่" "สาว")"คน" | {-pan-} mkN "น้อง" | mkN "พี่สาว" | mkN "น้องสาว" | mkN "แม่ชี" | mkN "พี่สาว" | mkN "น้องสาว" | mkN "น้องสาวหรือพี่สาว" ; -- src=panlex
lin reader_N = mkN "คนอ่าน" | mkN "ผู้อ่าน" | mkN "ผู้บรรยาย" | mkN "คนตรวจปรู๊ฟ" | mkN "ตำราฝึกอ่าน" | mkN "หนังสือฝึกอ่าน" | mkN "นักพิสูจน์อักษร" | mkN "สมาชิกสิ่งพิมพ์" | mkN "คนอ่านบทพระคัมภีร์" | mkN "ผู้อ่าน" | mkN "ผู้ทํานาย" | mkN "ผู้ตรวจปรู๊ฟ" | mkN "ผู้ตรวจเรื่อง" | mkN "ผู้อ่านพระคัมภีร์" | mkN "หนังสือฝึกการอ่าน" | mkN "ผู้ช่วยศาสตราจารย์" | mkN "ผู้บรรยายหรืออาจารย์ในมหาวิทยาลัยของอังกฤษ" ; -- src=panlex
lin below_Adv = mkAdv "ใต้" | mkAdv "ต่ำกว่า" | mkAdv "ข้างล่าง" | mkAdv "ด้านล่าง" | mkAdv "ใต้" | mkAdv "ต่ํา" | mkAdv "บนนรก" | mkAdv "อยู่ใต้" | mkAdv "ข้างล่าง" | mkAdv "ต่ํากว่า" | mkAdv "อยู่ตอนใต้" | mkAdv "อยู่ข้างใต้" | mkAdv "อยู่ข้างล่าง" | mkAdv "อยู่เบื้องล่าง" | mkAdv "ไม่สมเกียรติของ" ; -- src=panlex
lin trial_N = mkN "การผ่านบททดสอบ" | mkN "การซ้อม" | mkN "การทดลอง" | mkN "การทรมาน" | mkN "การสอบสวน" | mkN "ความเจ็บปวด" | mkN "เป็นตัวอย่าง" | mkN "ความยากลําบาก" | mkN "บุคคลที่ลําบากลําบน" ; -- src=panlex
lin rock_N = mkN "หิน" | {-pan-} mkN "ศิลา" | mkN "หินผา" | mkN "ก้อนหิน" | mkN "เพลงร็อก" | mkN "ความเอียง" | mkN "ดนตรีร็อก" | mkN "ร็อกแคนดี้" | mkN "การแกล้งทำเป็น" | mkN "เพลงร็อกแอนด์โรล" | mkN "ดนตรีร็อกแอนด์โรล" | mkN "ไกว" | mkN "เพชร" | mkN "เขย่า" | mkN "แกว่ง" | mkN "การโยก" | mkN "โขดหิน" | mkN "ก้อนหิน" | mkN "ร่อนแร่" | mkN "อันตราย" | mkN "การเขย่า" | mkN "การแกว่ง" | mkN "เพชรพลอย" | mkN "โคลงเคลง" | mkN "ดนตรีร็อค" | mkN "ภัยพิบัติ" | mkN "หินโสโครก" | mkN "รากฐานอันมั่นคง" | mkN "ทําให้สั่นสะเทือน" | mkN "ลูกกวาดที่เป็นแท่งแข็งมีหลากสี" ; -- src=panlex ----?
lin damage_N = mkN "ราคา" | mkN "การทำลาย" | mkN "ความเสื่อม" | mkN "ค่าใช้จ่าย" | mkN "ความเสียหาย" | mkN "การประทุษร้าย" | mkN "ความเสียหายทางอาวุธทหาร" | mkN "ผลร้าย" | mkN "ผลเสีย" | mkN "ผลเสียหาย" | mkN "การทําร้าย" | mkN "ความเสียหาย" | mkN "การประทุษร้าย" ; -- src=panlex
lin adopt_V2 = variants{} ; -- 
lin newspaper_N = mkN (thword "หนัง" "สือ" "พิมพ์") "ฉบับ" | {-pan-} mkN "น.ส.พ." | mkN "นสพ." | mkN "หนังสือพิมพ์" | mkN "กระดาษหนังสือพิมพ์" | mkN "บริษัทหนังสือพิมพ์" | mkN "กระดาษพิมพ์ หนังสือพิมพ์" | mkN "หนังสือพิมพ์" | mkN "กระดาษหนังสือพิมพ์" ; -- src=panlex
lin meaning_N = mkN "ความหมาย" | mkN "เป้าหมาย" | mkN "ตั้งใจไว้" | mkN "จุดประสงค์" | mkN "มุ่งหมายไว้" | mkN "สิ่งที่ตั้งใจจะพูดหรือบอก" | mkN "ความสําคัญของความรู้สึกหรือประสบการณ์" ; -- src=panlex
lin light_A = mkA "ใส" | mkA "เบา" | mkA "น้อย" | mkA "เล็ก" | mkA "สว่าง" | mkA "ใจง่าย" | mkA "ซึ่งไร้สาระ" | mkA "ที่แคลอรี่ต่ำ" | mkA "ที่มีแคลอรี่ต่ำ" | mkA "จาง" | mkA "ซีด" | mkA "เบา" | mkA "ง่าย" | mkA "เล่น ๆ" | mkA "สว่าง" | mkA "สุกใส" | mkA "บอบบาง" | mkA "บางเบา" | mkA "ว่องไว" | mkA "เบาแรง" | mkA "ขนาดเบา" | mkA "ร่าเริง" | mkA "ไม่หนัก" | mkA "นิดหน่อย" | mkA "ผ่อนคลาย" | mkA "เล็กน้อย" | mkA "เหลาะแหละ" | mkA "ไม่ลําบาก" | mkA "คล่องแคล่ว" | mkA "ไม่ยากเย็น" | mkA "ไม่หนักหนา" | mkA "ที่ย่อยง่าย" | mkA "จัดการได้ง่าย" | mkA "ที่ไม่หนักท้อง" | mkA "ไม่เคร่งเครียด" | mkA "ที่มีน้ําหนักเบา" | mkA "ที่มีน้ําหนักน้อย" | mkA "เต็มไปด้วยแสงสว่าง" ; -- src=panlex
lin essential_A = mkA "จำเป็น" | mkA "ซึ่งสำคัญที่สุด" | mkA "ที่จำเป็นอย่างมาก" | mkA "จําเป็น" | mkA "ซึ่งสําคัญ" | mkA "เป็นปัจจัย" | mkA "เป็นธรรมชาติ" | mkA "จําเป็นที่สุด" | mkA "ซึ่งเกิดขึ้นเอง" | mkA "ซึ่งขาดเสียมิได้" | mkA "เกี่ยวกับหัวน้ํามัน" | mkA "เกี่ยวกับหัวน้ําหอม" | mkA "เกี่ยวกับตัวยาสําคัญ" | mkA "เป็นส่วนประกอบที่สําคัญ" | mkA "ซึ่งเป็นส่วนจําเป็นที่สุด" | mkA "ซึ่งเป็นสิ่งที่สําคัญที่สุด" ; -- src=panlex
lin obvious_A = mkA "ชัดเจน" | mkA "ชัดแจ้ง" | mkA "เด่นชัด" | mkA "เห็นได้ง่าย" | mkA "เข้าใจได้ง่าย" ; -- src=panlex
lin nation_N = mkN "รัฐ" | mkN "ชาติ" | mkN "ประเทศ" | mkN "พลเมือง" | mkN "รัฐชาติ" | mkN "คนในชาติ" | mkN "คนในประเทศ" | mkN "ประเทศชาติ" | mkN "ประชาชนพลเมือง" | mkN "ประชาชนในประเทศ" | mkN "ชาติ" | mkN "ประเทศ" | mkN "ประชาชน" | mkN "พลเมือง" | mkN "คนในประเทศ" | mkN "ประเทศชาติ" ; -- src=panlex
lin confirm_VS = variants{} ; -- 
lin confirm_V2 = variants{} ; -- 
lin south_N = mkN "ต." | mkN "ใต้" | mkN "ทิศใต้" | mkN "ภาคใต้" | mkN "ใต้" | mkN "ทักษิณ" | mkN "ทิศใต้" ; -- src=panlex
lin length_N = mkN "ความยาว" | mkN "ระยะทาง" | mkN "ระยะห่าง" | mkN "ความยาวนาน" | mkN "ความยาว" | mkN "ระยะทาง" | mkN "ส่วนยาว" | mkN "ช่วงเวลา" | mkN "ระยะเวลา" | mkN "ช่วงระยะเวลา" ; -- src=panlex
lin branch_N = mkN "แขน" | mkN "กิ่ง" | mkN "สาขา" | mkN "ลำน้ำสาขา" | mkN "หน่วยงานย่อย" | mkN "แขน" | mkN "กิ่ง" | mkN "สาขา" | mkN "แผนก" | mkN "ที่เท้าแขน" | mkN "กิ่งก้านสาขา" ; -- src=panlex
lin deep_A = mkA "ทึบ" | mkA "ลึก" | mkA "หนา" | mkA "เบส" | mkA "ทุ้มต่ำ" | mkA "ที่มืดมิด" | mkA "อันล้ำลึก" | mkA "ซึ่งเข้าใจยาก" | mkA "จัด" | mkA "มาก" | mkA "ลึก" | mkA "หนา" | mkA "ทุ้ม" | mkA "คล้ํา" | mkA "ลึกซึ้ง" | mkA "ลึกล้ํา" | mkA "หมกมุ่น" | mkA "ห่างไกล" | mkA "มีใจจดจ่อ" | mkA "อย่างยิ่ง" | mkA "เหลือเกิน" | mkA "คร่ําเคร่ง" | mkA "ซึ่งมีใจจดจ่อ" | mkA "ลึกจากด้านนอก" | mkA "ลึกจากผิวหน้า" | mkA "ซ่อนความรู้สึก" | mkA "อยู่ตามเส้นขอบ" | mkA "ไกลเข้าไปด้านใน" | mkA "มิติการวัดจากด้านหน้าไปด้านหลัง" ; -- src=panlex
lin none_NP = variants{} ; -- 
lin planning_N = mkN "การวางแผน" | mkN "การคิดวางแผน" ; -- src=panlex
lin trust_N = mkN "ศรัทธา" | mkN "กองมรดก" | mkN "ความไว้ใจ" | mkN "ความมั่นใจ" | mkN "ความศรัทธา" | mkN "กลุ่มบริษัท" | mkN "การร่วมกลุ่มบริษัท" | mkN "ความหวัง" | mkN "สินเชื่อ" | mkN "การปกครอง" | mkN "การฝากฝัง" | mkN "ความมั่นใจ" | mkN "ความพิทักษ์" | mkN "ความเชื่อใจ" | mkN "ความอุปถัมภ์" | mkN "ความเชื่อถือ" | mkN "ความไว้วางใจ" | mkN "สหกรณ์บริษัท" | mkN "ความรับผิดชอบ" | mkN "สิ่งที่ไว้ใจได้" | mkN "บุคคลที่ไว้ใจได้" | mkN "ความไว้เนื้อเชื่อใจ" | mkN "ระบบผูกขาดทางการค้า" | mkN "การรวมตัวกันของบริษัท" | mkN "บริษัทใหญ่ที่รวมบริษัทเล็ก ๆ เข้าไว้" ; -- src=panlex
lin working_A = mkA "ซึ่งได้งาน" | mkA "ซึ่งมีงานทำ" | mkA "ซึ่งทํางาน" | mkA "ซึ่งมีงานทํา" | mkA "ซึ่งใช้การได้" | mkA "ซึ่งปฏิบัติการได้" ; -- src=panlex
lin pain_N = mkN "ความปวด" | mkN "อาการปวด" | mkN "สิ่งกวนใจ" | mkN "ความเจ็บปวด" | mkN "ความปวด" | mkN "ความเจ็บ" | mkN "ความทุกข์" | mkN "ความเศร้า" | mkN "ความเจ็บปวด" | mkN "ความเสียใจมาก" | mkN "ความทุกข์ทรมาน" ; -- src=panlex
lin studio_N = mkN "สตูดิโอ" | mkN "สตูดิโออพาร์ทเมนท์" | mkN "ห้องทํางาน" | mkN "บริษัทภาพยนตร์" | mkN "ห้องชุดขนาดเล็ก" | mkN "โรงถ่ายทําภาพยนตร์" | mkN "โรงเรียนสอนเต้นรํา" | mkN "ห้องถ่ายทําภาพยนตร์" | mkN "ห้องทํางานช่างเขียน" | mkN "ห้องกระจายเสียงวิทยุ โทรทัศน์" | mkN "สถานที่ถ่ายทําภาพยนตร์" | mkN "ห้องแสดงรายการวิทยุโทรทัศน์" | mkN "ห้องทํางานของช่างเขียนหรือช่างปั้น" ; -- src=panlex
lin positive_A = mkA "เชิงบวก" | mkA "ที่เป็นบวก" | mkA "แน่ใจ" | mkA "ทางบวก" | mkA "มั่นใจ" | mkA "ยืนยัน" | mkA "แง่บวก" | mkA "แน่นอน" | mkA "เด็ดขาด" | mkA "ยืนยันได้" | mkA "มีประจุบวก" | mkA "มีอยู่จริง" | mkA "เชื่อถือได้" | mkA "ซึ่งมองในแง่ดี" | mkA "ภาพที่มีสีถูกต้อง" | mkA "ได้ผลบวกของพยาธิสภาพ" | mkA "สัญลักษณ์หรือเครื่องหมายบวก" ; -- src=panlex
lin spirit_N = mkN "กลิ่น" | mkN "เจตนา" | mkN "วิญญาณ" | mkN "สปิริต" | mkN "จิตวิญญาณ" | mkN "สภาวะอารมณ์" | mkN "ความมีชีวิตชีวา" | mkN "ใจ" | mkN "ญาณ" | mkN "ขวัญ" | mkN "จิตใจ" | mkN "หัวใจ" | mkN "เจตนา" | mkN "ปลุกใจ" | mkN "วิญญาณ" | mkN "อารมณ์" | mkN "กระตุ้น" | mkN "ความในใจ" | mkN "ความองอาจ" | mkN "ความรู้สึก" | mkN "หัวน้ําหอม" | mkN "ภูติผีปีศาจ" | mkN "ให้กําลังใจ" | mkN "ความมุ่งมั่น" | mkN "ความเด็ดเดี่ยว" | mkN "สารละลายแอลกอฮอล์" | mkN "เกี่ยวกับสารละลายแอลกอฮอลล์" | mkN "ของเหลวระเหยที่ได้จากการกลั่น" ; -- src=panlex
lin college_N = mkN "คณะ" | mkN "วิทยาลัย" | mkN "อาคารเรียนรวม" | mkN "วิทยาลัย" | mkN "สมาคมหรือบริษัท" | mkN "โรงเรียนเฉพาะสาขาวิชา" ; -- src=panlex
lin accident_N = mkN "อุบัติเหตุ" | mkN "โอกาส" | mkN "บังเอิญ" | mkN "เหตุร้าย" | mkN "ส่วนประกอบ" | mkN "อุบัติเหตุ" | mkN "อุปัทวเหตุ" | mkN "เหตุบังเอิญ" | mkN "พื้นทีไม่เรียบ" | mkN "การตั้งครรภ์โดยไม่ได้เตรียมตัว" ; -- src=panlex
lin star_V2 = variants{} ; -- 
lin hope_N = mkN "ความหวัง" | mkN "การคาดหวัง" | mkN "คาดหมาย" | mkN "ปรารถนา" | mkN "ความหวัง" | mkN "ไว้วางใจ" | mkN "ความปรารถนา" | mkN "สิ่งที่หวังไว้" ; -- src=panlex
lin mark_V3 = variants{} ; -- 
lin mark_V2 = variants{} ; -- 
lin works_N = mkN "โรงงาน" | mkN "โรงงานอุตสาหกรรม" ; -- src=panlex
lin league_N = variants{} ; -- 
lin league_2_N = variants{} ; -- 
lin league_1_N = variants{} ; -- 
lin clear_V2 = mkV2 "ขาย" ; ---- | mkV "กรอง" | mkV "เปิด" | mkV "ขายโละ" | mkV "จางหาย" | mkV "อนุญาต" | mkV "ได้รับ" | mkV "เคลียร์" | mkV "ไอออกมา" | mkV "ให้อำนาจ" | mkV "เคลื่อนย้าย" | mkV "ทำให้กระจ่าง" | mkV "ทำให้เป็นทาง" | mkV "ได้กำไรสุทธิ" | mkV "ไม่มีความผิด" | mkV "ผ่านการเห็นชอบ" | mkV "ทําให้สะอาด" | mkV "ทําให้ชัดเจน" | mkV "กลายเป็นชัดเจน" | mkV "เคลียร์ริ่งเช็ค" ; -- src=panlex
lin clear_V = mkV "ขาย" | mkV "กรอง" | mkV "เปิด" | mkV "ขายโละ" | mkV "จางหาย" | mkV "อนุญาต" | mkV "ได้รับ" | mkV "เคลียร์" | mkV "ไอออกมา" | mkV "ให้อำนาจ" | mkV "เคลื่อนย้าย" | mkV "ทำให้กระจ่าง" | mkV "ทำให้เป็นทาง" | mkV "ได้กำไรสุทธิ" | mkV "ไม่มีความผิด" | mkV "ผ่านการเห็นชอบ" | mkV "ทําให้สะอาด" | mkV "ทําให้ชัดเจน" | mkV "กลายเป็นชัดเจน" | mkV "เคลียร์ริ่งเช็ค" ; -- src=panlex
lin imagine_VS = mmkVS "คาด" ; ---- | mkV "คิด" | mkV "จินตนาการ" | mkV "คาดคิด" | mkV "นึกคิด" | mkV "นึกฝัน" | mkV "วางแผน" | mkV "คาดการณ์" | mkV "จินตนาการ" | mkV "นึกเอาเอง" | mkV "วาดมโนภาพ" | mkV "มีจินตนาการ" | mkV "คิดสรุปเอาเอง" ; -- src=panlex
lin imagine_V2 = mkV2 "คาด" ; ---- | mkV "คิด" | mkV "จินตนาการ" | mkV "คาดคิด" | mkV "นึกคิด" | mkV "นึกฝัน" | mkV "วางแผน" | mkV "คาดการณ์" | mkV "จินตนาการ" | mkV "นึกเอาเอง" | mkV "วาดมโนภาพ" | mkV "มีจินตนาการ" | mkV "คิดสรุปเอาเอง" ; -- src=panlex
lin imagine_V = mkV "คาด" | mkV "คิด" | mkV "จินตนาการ" | mkV "คาดคิด" | mkV "นึกคิด" | mkV "นึกฝัน" | mkV "วางแผน" | mkV "คาดการณ์" | mkV "จินตนาการ" | mkV "นึกเอาเอง" | mkV "วาดมโนภาพ" | mkV "มีจินตนาการ" | mkV "คิดสรุปเอาเอง" ; -- src=panlex
lin through_Adv = mkAdv "ตั้งแต่ต้นจนจบ" | mkAdv "โดยตลอด" | mkAdv "ผ่านไปตาม" | mkAdv "โดยทั้งหมด" | mkAdv "ไปจนเสร็จสิ้น" | mkAdv "ตั้งแต่ต้นจนจบ" | mkAdv "จนกระทั่งเรียบร้อย" ; -- src=panlex
lin cash_N = mkN "เงินสด" | mkN "เงินสด" ; -- src=panlex
lin normally_Adv = variants{} ; -- 
lin play_N = mkN "ละคร" | mkN "ละคอน" | mkN "บทละคร" | mkN "การพนัน" | mkN "การเล่น" | mkN "อบายมุข" | mkN "การรำดาบ" | mkN "แสงแวววาว" | mkN "การเล่นเกม" | mkN "ความพยายาม" | mkN "แผนการเล่น" | mkN "การรำกระบี่" | mkN "การเล่นพนัน" | mkN "การแสดงละคร" | mkN "การร่ายรำดาบ" | mkN "การแสดงทักษะ" | mkN "การเล่นการพนัน" | mkN "การเล่นของเด็ก" | mkN "การละเล่นของเด็ก" | mkN "ระยะเวลาในการเล่น" | mkN "ที" | mkN "คราว" | mkN "พนัน" | mkN "ละคร" | mkN "แสดง" | mkN "ครั้ง" | mkN "บรรเลง" | mkN "การเล่น" | mkN "การแสดง" | mkN "ปฏิบัติ" | mkN "ล้อเล่น" | mkN "หยอกเย้า" | mkN "เล่นละคร" | mkN "การบรรเลง" | mkN "การละเล่น" | mkN "การทําเล่น" | mkN "การล้อเล่น" | mkN "การหยอกล้อ" | mkN "เรื่องละคร" | mkN "การหยอกเย้า" | mkN "การเล่นพนัน" | mkN "การเล่นสนุก" | mkN "การเล่นการพนัน" | mkN "การกระโดดโลดเต้น" | mkN "ช่วงเวลาในการเล่น" | mkN "ระยะเวลาในการแข่งขัน" | mkN "การเคลื่อนไหวโดยอิสระ" | mkN "การเคลื่อนไหวอย่างคล่องแคล่ว" ; -- src=panlex
lin strength_N = mkN "แรง" | mkN "จุดเด่น" | mkN "จุดแข็ง" | mkN "ความเข้ม" | mkN "ความแข็งแรง" | mkN "ความเข้มแข็ง" | mkN "ระดับความเข้ม" | mkN "ความมีประสิทธิภาพ" | mkN "แรง" | mkN "พลัง" | mkN "กําลัง" | mkN "ความทนทาน" | mkN "พละกําลัง" | mkN "อํานาจจิต" | mkN "เรี่ยวแรง" | mkN "แหล่งพลัง" | mkN "กําลังทหาร" | mkN "ความกล้าหาญ" | mkN "ความต้านทาน" | mkN "ความหนาแน่น" | mkN "ความเข้มข้น" | mkN "ความแข็งแรง" | mkN "กําลังกองทัพ" | mkN "ความหนักแน่น" | mkN "อํานาจความต้านทาน" | mkN "จํานวนทหารหรือเรือ" ; -- src=panlex
lin train_N = mkN (thword "รถ" "ไฟ") "ขบวน" | {-pan-} mkN "รถไฟ" | mkN "เกียร์" | mkN "คาราวาน" | mkN "ม้าเหล็ก" | mkN "กองคาราวาน" | mkN "ดึง" | mkN "ลาก" | mkN "ขบวน" | mkN "รถไฟ" | mkN "เส้น" | mkN "ขบวนรถ" | mkN "ฝึกหัด" | mkN "เกียร์" | mkN "ผลลัพธ์" | mkN "ชายกระโปรง" | mkN "หางกระโปรง" | mkN "ชายกระโปรงยาวๆ" | mkN "เหตุการณ์ต่อเนื่อง" | mkN "เหตุการณ์ที่เกิดขึ้นต่อเนื่องตามลําดับ" ; -- src=panlex
lin travel_V2 = mkV2 "เที่ยว" ; ---- | {-pan-} mkV "ไป" | mkV "ท่อง" | mkV "โดยสาร" | mkV "เดินทาง" | mkV "ออกจาริก" | mkV "ท่องเที่ยว" | mkV "ย้าย" | mkV "สัญจร" | mkV "เดินทาง" | mkV "ท่องเที่ยว" | mkV "ย้ายที่อยู่" ; -- src=panlex
lin travel_V = mkV "เที่ยว" | {-pan-} mkV "ไป" | mkV "ท่อง" | mkV "โดยสาร" | mkV "เดินทาง" | mkV "ออกจาริก" | mkV "ท่องเที่ยว" | mkV "ย้าย" | mkV "สัญจร" | mkV "เดินทาง" | mkV "ท่องเที่ยว" | mkV "ย้ายที่อยู่" ; -- src=panlex
lin target_N = mkN "เป้า" | mkN "เหยื่อ" | mkN "เป้าหมาย" | mkN "จุดมุ่งหมาย" | mkN "พื้นที่เป้าหมาย" | mkN "เป้า" | mkN "เหยื่อ" | mkN "โล่กลม" | mkN "จุดหมาย" | mkN "เป้ายิง" | mkN "เป้าหมาย" | mkN "เป้ายิงปืน" | mkN "จุดมุ่งหมาย" | mkN "วัตถุประสงค์" | mkN "เป้าหมายการนินทา" | mkN "เป้าหมายการวิพากย์วิจารณ์" ; -- src=panlex
lin very_A = mkA "เฉพาะ" | mkA "แท้จริง" | mkA "เท่านั้น" ; -- src=panlex
lin pair_N = mkN "คู่" | mkN "คู่เหมือนกัน" | mkN "คู่" | mkN "เป็นคู่" | mkN "คู่แต่งงาน" | mkN "คู่ผสมพันธุ์" | mkN "ของที่เป็นคู่" | mkN "สิ่งที่เป็นคู่กัน" | mkN "ม้าคู่ที่ใช้เทียมเกวียนหรือรถม้า" ; -- src=panlex
lin male_A = mkA "ชาย" | mkA "ที่เป็นเพศชาย" | mkA "ที่เป็นเพศผู้" | mkA "ชาย" | mkA "ถึก" | mkA "ผู้" | mkA "ตัวผู้" | mkA "ผู้ชาย" | mkA "เพศชาย" | mkA "พืชตัวผู้" | mkA "เกสรตัวผู้" | mkA "เกี่ยวกับผู้ชาย" | mkA "เกี่ยวกับเพศชาย" | mkA "ซึ่งเป็นของผู้ชาย" ; -- src=panlex
lin gas_N = mkN "ก๊าซ" | mkN "แก๊ส" | mkN "น้ำมัน" | mkN "เบนซิน" | mkN "คันเร่ง" | mkN "ท้องอืด" | mkN "ท้องเฟ้อ" | mkN "สถานะก๊าซ" | mkN "ก๊าซธรรมชาติ" | mkN "น้ำมันเบนซิน" | mkN "แก๊สธรรมชาติ" | mkN "แป้นเหยียบคันเร่ง" | mkN "ก๊าซ" | mkN "แก๊ซ" | mkN "แก๊ส" | mkN "น้ํามันเชื้อเพลิง" ; -- src=panlex
lin issue_V2 = mkV2 "ออก" ; ---- | mkV "พิมพ์" | mkV "ออกมา" | mkV "ตีพิมพ์" | mkV "พิมพ์" | mkV "จัดทํา" | mkV "ไหลออก" | mkV "ตีพิมพ์" | mkV "โผล่ออกมา" | mkV "ปรากฏออกมา" | mkV "พิมพ์ออกมา" | mkV "ตีพิมพ์เพื่อจําหน่ายหรือแจก" ; -- src=panlex
lin issue_V = mkV "ออก" | mkV "พิมพ์" | mkV "ออกมา" | mkV "ตีพิมพ์" | mkV "พิมพ์" | mkV "จัดทํา" | mkV "ไหลออก" | mkV "ตีพิมพ์" | mkV "โผล่ออกมา" | mkV "ปรากฏออกมา" | mkV "พิมพ์ออกมา" | mkV "ตีพิมพ์เพื่อจําหน่ายหรือแจก" ; -- src=panlex
lin contribution_N = mkN "การบริจาค" | mkN "เงินบริจาค" | mkN "สิ่งของบริจาค" | mkN "การเขียนเรื่องลงหนังสือ" | mkN "การบริจาค" | mkN "ภาษีพิเศษ" | mkN "การอุดหนุน" | mkN "สิ่งที่มอบ" | mkN "การสนับสนุน" | mkN "การช่วยเหลือ" | mkN "สิ่งที่บริจาค" | mkN "เรื่องเขียนที่ส่งไปตีพิมพ์" ; -- src=panlex
lin complex_A = mkA "ซับซ้อน" | mkA "ซับซ้อน" | mkA "เชิงซ้อน" | mkA "ประกอบด้วยส่วนต่าง ๆ" | mkA "ที่ประกอบด้วยสองส่วนขึ้นไป" | mkA "ซึ่งประกอบด้วย2ส่วน" ; -- src=panlex
lin supply_V2 = variants{} ; -- 
lin beat_V2 = mkV2 "ตี" ; ---- | mkV "ขยับ" | mkV "สั่น" | mkV "เข่น" | mkV "เคาะ" | mkV "เต้น" | mkV "ตีปีก" | mkV "บดอัด" | mkV "พิชิต" | mkV "หมดแรง" | mkV "เลี่ยง" | mkV "เอาชนะ" | mkV "ขยับปีก" | mkV "หมดพลัง" | mkV "อ่อนล้า" | mkV "หมดกำลัง" | mkV "กระพือปีก" | mkV "ทำให้สับสน" | mkV "อ่อนเปลี้ย" | mkV "เคาะจังหวะ" | mkV "เหนื่อยล้า" | mkV "ตีเป็นจังหวะ" | mkV "หมดเรี่ยวแรง" | mkV "กะปลกกะเปลี้ย" | mkV "หมดเรี่ยวหมดแรง" | mkV "เอาชนะด้วยอุบาย" | mkV "ตบ" | mkV "ตี" | mkV "หวด" | mkV "หอบ" | mkV "เคาะ" | mkV "ตีไข่" | mkV "เฆี่ยน" | mkV "เอาชนะ" | mkV "กระพือปีก" | mkV "ทําให้พ่ายแพ้" | mkV "เต้นเป็นจังหวะ" | mkV "ตีหรือคนให้เข้ากัน" | mkV "หลีกเลี่ยงการล่าช้า" | mkV "มาถึงหรือทําบางสิ่งเร็วกว่า" ; -- src=panlex
lin beat_V = mkV "ตี" | mkV "ขยับ" | mkV "สั่น" | mkV "เข่น" | mkV "เคาะ" | mkV "เต้น" | mkV "ตีปีก" | mkV "บดอัด" | mkV "พิชิต" | mkV "หมดแรง" | mkV "เลี่ยง" | mkV "เอาชนะ" | mkV "ขยับปีก" | mkV "หมดพลัง" | mkV "อ่อนล้า" | mkV "หมดกำลัง" | mkV "กระพือปีก" | mkV "ทำให้สับสน" | mkV "อ่อนเปลี้ย" | mkV "เคาะจังหวะ" | mkV "เหนื่อยล้า" | mkV "ตีเป็นจังหวะ" | mkV "หมดเรี่ยวแรง" | mkV "กะปลกกะเปลี้ย" | mkV "หมดเรี่ยวหมดแรง" | mkV "เอาชนะด้วยอุบาย" | mkV "ตบ" | mkV "ตี" | mkV "หวด" | mkV "หอบ" | mkV "เคาะ" | mkV "ตีไข่" | mkV "เฆี่ยน" | mkV "เอาชนะ" | mkV "กระพือปีก" | mkV "ทําให้พ่ายแพ้" | mkV "เต้นเป็นจังหวะ" | mkV "ตีหรือคนให้เข้ากัน" | mkV "หลีกเลี่ยงการล่าช้า" | mkV "มาถึงหรือทําบางสิ่งเร็วกว่า" ; -- src=panlex
lin artist_N = mkN "ศิลปิน" | mkN "อาร์ติสต์" | mkN "คนทำงานสร้างสรรค์" | mkN "คนผลิตงานสร้างสรรค์" | mkN "จิตรกร" | mkN "ศิลปิน" | mkN "นักแสดง" | mkN "นักศิลปะ" | mkN "ช่างฝีมือ" | mkN "ช่างเขียน" | mkN "ผู้มีฝีมือ" | mkN "ผู้เชี่ยวชาญ" | mkN "ผู้ที่มีทักษะ" ; -- src=panlex
lin agentMasc_N = variants{} ; -- 
lin presence_N = mkN "วิธีการวางตัว" | mkN "วิญญาณที่รู้สึกว่ามีอยู่" | mkN "บุคคล" | mkN "การปรากฎ" | mkN "การมีอยู่" | mkN "กริยาท่าทาง" | mkN "การเข้าร่วม" | mkN "ภูติผีปีศาจ" | mkN "กิริยาท่าทาง" | mkN "การประพฤติตัว" | mkN "การอยู่ต่อหน้า" | mkN "การอยู่ในที่นี้" | mkN "บริเวณใกล้เคียง" | mkN "สิ่งศักดิ์สิทธิ์" | mkN "ระยะที่เห็นหรือได้ยินได้ของบุคคลใดบุคคลหนึ่ง" ; -- src=panlex
lin along_Adv = mkAdv "ไป" | mkAdv "ไปยัง" | mkAdv "กับ" | mkAdv "ด้วย" | mkAdv "ต่อไป" | mkAdv "มากับ" | mkAdv "ไปยัง" | mkAdv "ไปข้างหน้า" ; -- src=panlex
lin environmental_A = variants{} ; -- 
lin strike_V2 = mkV2 "ชน" ; ---- | mkV "ตี" | mkV "จุด" | mkV "ดีด" | mkV "ทุบ" | mkV "ปาด" | mkV "โขก" | mkV "ปั๊ม" | mkV "กระทบ" | mkV "พิมพ์" | mkV "ขีดฆ่า" | mkV "ขีดออก" | mkV "ถึงจุด" | mkV "สไตรก์" | mkV "อยู่ใน" | mkV "เล่นงาน" | mkV "บุกโจมตี" | mkV "ประทับใจ" | mkV "ย่างเท้า" | mkV "เจาะทะลุ" | mkV "ตีบอกเวลา" | mkV "ทำให้ตระหนก" | mkV "พบโดยบังเอิญ" | mkV "ประท้วงหยุดงาน" | mkV "หยุดงานประท้วง" | mkV "ทำให้เคลื่อนเป็นแนวโค้ง" | mkV "ชน" | mkV "ตี" | mkV "ดีด" | mkV "เขก" | mkV "โขก" | mkV "ปะทะ" | mkV "เคาะ" | mkV "โจมตี" | mkV "กระแทก" | mkV "จู่โจม" | mkV "ก่อการจลาจล" | mkV "หยุดงานประท้วง" ; -- src=panlex
lin strike_V = mkV "ชน" | mkV "ตี" | mkV "จุด" | mkV "ดีด" | mkV "ทุบ" | mkV "ปาด" | mkV "โขก" | mkV "ปั๊ม" | mkV "กระทบ" | mkV "พิมพ์" | mkV "ขีดฆ่า" | mkV "ขีดออก" | mkV "ถึงจุด" | mkV "สไตรก์" | mkV "อยู่ใน" | mkV "เล่นงาน" | mkV "บุกโจมตี" | mkV "ประทับใจ" | mkV "ย่างเท้า" | mkV "เจาะทะลุ" | mkV "ตีบอกเวลา" | mkV "ทำให้ตระหนก" | mkV "พบโดยบังเอิญ" | mkV "ประท้วงหยุดงาน" | mkV "หยุดงานประท้วง" | mkV "ทำให้เคลื่อนเป็นแนวโค้ง" | mkV "ชน" | mkV "ตี" | mkV "ดีด" | mkV "เขก" | mkV "โขก" | mkV "ปะทะ" | mkV "เคาะ" | mkV "โจมตี" | mkV "กระแทก" | mkV "จู่โจม" | mkV "ก่อการจลาจล" | mkV "หยุดงานประท้วง" ; -- src=panlex
lin contact_N = mkN "คนกลาง" | mkN "การติดต่อ" | mkN "การสัมผัส" | mkN "คอนเทคเลนส์" | mkN "การติดต่อสื่อสาร" | mkN "ช่องทางการสื่อสาร" | mkN "การสัมผัส" | mkN "การติดต่อสื่อสาร" | mkN "ช่องทางการติดต่อ" | mkN "คนกลางที่สามารถช่วยเหลือได้" | mkN "ผู้ที่เป็นสื่อกลางช่วยเหลือได้" ; -- src=panlex
lin protection_N = mkN "การปกป้อง" | mkN "การคุ้มกัน" | mkN "ที่ป้องกัน" | mkN "สิ่งป้องกัน" | mkN "การจ่ายค่าคุ้มครอง" | mkN "การปกป้องทางการค้า" | mkN "การปกป้อง" | mkN "การป้องกัน" | mkN "การพิทักษ์" | mkN "การอารักขา" | mkN "ค่าอารักขา" | mkN "การคุ้มครอง" | mkN "ค่าคุ้มครอง" | mkN "หนังสือเดินทาง" | mkN "เอกสารคุ้มครอง" | mkN "คนหรือสิ่งที่คุ้มครอง" | mkN "ระบบการปกป้องสินค้าพื้นเมืองโดยการจัดเก็บภาษีนําเข้าสูง" ; -- src=panlex
lin beginning_N = mkN "ยุคแรก" | mkN "ส่วนต้น" | mkN "ครั้งแรก" | mkN "ต้นกำเนิด" | mkN "การเปิดฉาก" | mkN "การเริ่มต้น" | mkN "แหล่งกำเนิด" | mkN "ช่วงเริ่มต้น" | mkN "ตอนแรก" | mkN "การเริ่ม" | mkN "เริ่มแรก" | mkN "จุดกําเนิด" | mkN "จุดเริ่มต้น" | mkN "ระยะตั้งต้น" | mkN "การมีกําเนิดจาก" ; -- src=panlex
lin demand_VS = variants{} ; -- 
lin demand_V2 = variants{} ; -- 
lin media_N = mkN "ตัวกลาง" | mkN "สื่อกลาง" ; -- src=panlex
lin relevant_A = mkA "สําคัญ" | mkA "ตรงประเด็น" | mkA "มีความหมาย" | mkA "สัมพันธ์กัน" | mkA "เข้าประเด็น" | mkA "เข้าเรื่องกัน" | mkA "ซึ่งสัมพันธ์กัน" | mkA "ซึ่งเกี่ยวเนื่องกัน" ; -- src=panlex
lin employ_V2 = variants{} ; -- 
lin shoot_V2 = mkV2 "ฉีด" ; ---- | mkV "พ่น" | mkV "ยิง" | mkV "อัด" | mkV "ชู้ต" | mkV "ถ่าย" | mkV "พุ่ง" | mkV "แล่น" | mkV "ซัลโว" | mkV "จับภาพ" | mkV "ยิงปืน" | mkV "ถ่ายภาพ" | mkV "ถ่ายรูป" | mkV "แตกหน่อ" | mkV "ถ่ายหนัง" | mkV "บันทึกภาพ" | mkV "ยิงกระสุน" | mkV "ยิงสังหาร" | mkV "ทอยลูกเต๋า" | mkV "ถ่ายภาพยนตร์" | mkV "ถ่ายทำภาพยนตร์" | mkV "ใช้จ่ายอย่างโง่เขลา" | mkV "ยิง" | mkV "พุ่ง" | mkV "ยื่น" | mkV "โผล่" | mkV "ยิงปืน" | mkV "เตะลูก" | mkV "ถ่ายภาพ" | mkV "ถ่ายรูป" | mkV "รวดเร็ว" | mkV "รีบเร่ง" | mkV "พุ่งเข้าใส่" | mkV "ถ่ายภาพยนตร์" | mkV "ปฏิบัติการอย่างรวดเร็ว" ; -- src=panlex
lin shoot_V = mkV "ฉีด" | mkV "พ่น" | mkV "ยิง" | mkV "อัด" | mkV "ชู้ต" | mkV "ถ่าย" | mkV "พุ่ง" | mkV "แล่น" | mkV "ซัลโว" | mkV "จับภาพ" | mkV "ยิงปืน" | mkV "ถ่ายภาพ" | mkV "ถ่ายรูป" | mkV "แตกหน่อ" | mkV "ถ่ายหนัง" | mkV "บันทึกภาพ" | mkV "ยิงกระสุน" | mkV "ยิงสังหาร" | mkV "ทอยลูกเต๋า" | mkV "ถ่ายภาพยนตร์" | mkV "ถ่ายทำภาพยนตร์" | mkV "ใช้จ่ายอย่างโง่เขลา" | mkV "ยิง" | mkV "พุ่ง" | mkV "ยื่น" | mkV "โผล่" | mkV "ยิงปืน" | mkV "เตะลูก" | mkV "ถ่ายภาพ" | mkV "ถ่ายรูป" | mkV "รวดเร็ว" | mkV "รีบเร่ง" | mkV "พุ่งเข้าใส่" | mkV "ถ่ายภาพยนตร์" | mkV "ปฏิบัติการอย่างรวดเร็ว" ; -- src=panlex
lin executive_N = mkN "ผู้บริหาร" | mkN "คณะผู้บริหาร" | mkN "นักบริหาร" | mkN "ผู้บริหาร" | mkN "ผู้มีอํานาจบริหาร" | mkN "เกี่ยวกับการบริหาร" | mkN "เกี่ยวกับการบังคับตามกฎหมาย" ; -- src=panlex
lin slowly_Adv = variants{} ; -- 
lin relatively_Adv = variants{} ; -- 
lin aid_N = mkN "การดูแล" | mkN "ผู้ช่วย" | mkN "การช่วยเหลือ" | mkN "การดูแลรักษา" | mkN "ความช่วยเหลือ" | mkN "เงินช่วยเหลือ" | mkN "การดูแลเอาใจใส่" | mkN "เงินช่วยเหลือทางเศรษฐกิจ" | mkN "ผู้ช่วย" | mkN "ความช่วยเหลือ" | mkN "ผู้ที่ช่วยเหลือ" | mkN "สิ่งที่ช่วยเหลือ" ; -- src=panlex
lin huge_A = mkA "มหึมา" | mkA "ใหญ่" | mkA "มหึมา" | mkA "มหาศาล" | mkA "ใหญ่โต" | mkA "ใหญ่มาก" | mkA "เบ้อเร่อ" ; -- src=panlex
lin late_Adv = mkAdv "สาย" | mkAdv "เร็วๆนี้" | mkAdv "อย่างล่าช้า" ; -- src=panlex
lin speed_N = mkN "ความไว" | mkN "ความเร็ว" | mkN "การรีบเร่ง" | mkN "ความว่องไว" | mkN "แอมเฟตามีน" | mkN "ความรวดเร็ว" | mkN "หมายเลขโฟกัส" | mkN "ยากระตุ้นประสาท" | mkN "ความว่องไว" | mkN "ความรวดเร็ว" ; -- src=panlex
lin review_N = mkN "บทวิจารณ์" | mkN "การสรุปความ" | mkN "การตีราคาใหม่" | mkN "บทความวิจารณ์" | mkN "วารสารวิจารณ์" | mkN "ตรวจพล" | mkN "วิจารณ์" | mkN "การทบทวน" | mkN "การตรวจพล" | mkN "บทวิจารณ์" | mkN "การวิจารณ์" | mkN "ตรวจสอบอีก" | mkN "พิจารณาใหม่" | mkN "การตรวจสอบอีก" | mkN "การพิจารณาใหม่" | mkN "เขียนบทปฏิทัศน์" | mkN "บทนิพนธ์ปฏิทัศน์" | mkN "สิ่งตีพิมพ์ปฏิทัศน์" ; -- src=panlex
lin test_V2 = variants{} ; -- 
lin order_VS = mmkVS "จัด" ; ---- | mkV "บวช" | mkV "สั่ง" | mkV "บัญชา" | mkV "ลำดับ" | mkV "สั่งของ" | mkV "สั่งซื้อ" | mkV "จัดอันดับ" | mkV "เรียงร้อย" | mkV "จัดระเบียบ" | mkV "สั่งสินค้า" | mkV "เรียบเรียง" | mkV "จัดเร็ตติ้ง" | mkV "ลำดับเรื่อง" | mkV "ลำดับความคิด" | mkV "สั่งออร์เดอร์" | mkV "สั่ง" | mkV "บงการ" | mkV "บัญชา" | mkV "สั่งการ" | mkV "สั่งจอง" | mkV "สั่งซื้อ" | mkV "จัดระเบียบ" | mkV "ออกคําสั่ง" | mkV "จัดให้เป็นระเบียบ" ; -- src=panlex
lin order_V2V = mmkV2V "จัด" ; ---- | mkV "บวช" | mkV "สั่ง" | mkV "บัญชา" | mkV "ลำดับ" | mkV "สั่งของ" | mkV "สั่งซื้อ" | mkV "จัดอันดับ" | mkV "เรียงร้อย" | mkV "จัดระเบียบ" | mkV "สั่งสินค้า" | mkV "เรียบเรียง" | mkV "จัดเร็ตติ้ง" | mkV "ลำดับเรื่อง" | mkV "ลำดับความคิด" | mkV "สั่งออร์เดอร์" | mkV "สั่ง" | mkV "บงการ" | mkV "บัญชา" | mkV "สั่งการ" | mkV "สั่งจอง" | mkV "สั่งซื้อ" | mkV "จัดระเบียบ" | mkV "ออกคําสั่ง" | mkV "จัดให้เป็นระเบียบ" ; -- src=panlex
lin order_V2 = mkV2 "จัด" ; ---- | mkV "บวช" | mkV "สั่ง" | mkV "บัญชา" | mkV "ลำดับ" | mkV "สั่งของ" | mkV "สั่งซื้อ" | mkV "จัดอันดับ" | mkV "เรียงร้อย" | mkV "จัดระเบียบ" | mkV "สั่งสินค้า" | mkV "เรียบเรียง" | mkV "จัดเร็ตติ้ง" | mkV "ลำดับเรื่อง" | mkV "ลำดับความคิด" | mkV "สั่งออร์เดอร์" | mkV "สั่ง" | mkV "บงการ" | mkV "บัญชา" | mkV "สั่งการ" | mkV "สั่งจอง" | mkV "สั่งซื้อ" | mkV "จัดระเบียบ" | mkV "ออกคําสั่ง" | mkV "จัดให้เป็นระเบียบ" ; -- src=panlex
lin order_V = mkV "จัด" | mkV "บวช" | mkV "สั่ง" | mkV "บัญชา" | mkV "ลำดับ" | mkV "สั่งของ" | mkV "สั่งซื้อ" | mkV "จัดอันดับ" | mkV "เรียงร้อย" | mkV "จัดระเบียบ" | mkV "สั่งสินค้า" | mkV "เรียบเรียง" | mkV "จัดเร็ตติ้ง" | mkV "ลำดับเรื่อง" | mkV "ลำดับความคิด" | mkV "สั่งออร์เดอร์" | mkV "สั่ง" | mkV "บงการ" | mkV "บัญชา" | mkV "สั่งการ" | mkV "สั่งจอง" | mkV "สั่งซื้อ" | mkV "จัดระเบียบ" | mkV "ออกคําสั่ง" | mkV "จัดให้เป็นระเบียบ" ; -- src=panlex
lin route_N = mkN "ถ." | mkN "ถนน" | mkN "เส้นทาง" | mkN "ถนนรนแคม" | mkN "ถนนหนทาง" | mkN "ทาง" | mkN "เส้นทาง" | mkN "วางเส้นทาง" | mkN "เส้นทางเดิน" | mkN "เส้นทางของรถ เรือ เครื่องบิน" | mkN "คําสั่งเดินทัพ" | mkN "เส้นทางเดินเรือ" ; -- src=panlex
lin consequence_N = mkN "ผลปรากฏ" | mkN "ผลที่ตามมา" | mkN "มีผลกระทบต่อ" | mkN "ผล" | mkN "ผลสรุป" | mkN "ผลลัพธ์" | mkN "ผลที่ตามมา" | mkN "ตําแหน่งที่สําคัญ" | mkN "ผลที่เกิดขึ้นภายหลัง" ; -- src=panlex
lin telephone_N = mkN "โทรศัพท์" | mkN "การใช้โทรศัพท์" | mkN "เครื่องโทรศัพท์" | mkN "โทรศัพท์" | mkN "เครื่องรับโทรศัพท์" | mkN "การสื่อสารทางโทรศัพท์" ; -- src=panlex
lin release_V2 = variants{} ; -- 
lin proportion_N = mkN "สัดส่วน" | mkN "อัตราส่วน" | mkN "สัดส่วน" | mkN "อัตราส่วน" | mkN "การได้สัด-ส่วน" | mkN "ความสมดุลกัน" | mkN "บัญญัติไตรยางค์" | mkN "ขนาดที่สัมพันธ์กัน" | mkN "ความสัมพันธ์ระหว่างส่วนต่างๆ" | mkN "ความสัมพันธ์ที่เหมาะสมหรือสําคัญ" ; -- src=panlex
lin primary_A = mkA "ประถม" | mkA "แม่สี" | mkA "ดีเลิศ" | mkA "ระยะแรก" | mkA "ครั้งแรก" | mkA "ดั้งเดิม" | mkA "อันดับแรก" | mkA "เบื้องต้น" | mkA "ในขั้นแรก" | mkA "ในชั้นประถม" | mkA "สําคัญที่สุด" | mkA "ในขั้นพื้นฐาน" | mkA "ที่มีมาดั้งเดิม" | mkA "ที่สําคัญที่สุด" | mkA "ตําแหน่งอาร์บิชอพ" | mkA "การเลือกตั้งครั้งแรก" | mkA "สิ่งที่อยู่ในอันดับหนึ่ง" | mkA "ดาวที่สว่างกว่าในกลุ่มดาวคู่" ; -- src=panlex
lin consideration_N = mkN "ปัจจัย" | mkN "เงื่อนไข" | mkN "ค่าตอบแทน" | mkN "การพิจารณา" | mkN "การคิดพิจารณา" | mkN "ข้อมูลแวดล้อม" | mkN "ค่าคงที่บริการ" | mkN "การชดเชย" | mkN "การพิจารณา" | mkN "ความนับถือ" | mkN "ความสําคัญ" | mkN "การครุ่นคิด" | mkN "การคิดพิจารณา" | mkN "ความเห็นใจคนอื่น" | mkN "สิ่งที่ควรพิจารณา" | mkN "ความคิดเห็นใจผู้อื่น" ; -- src=panlex
lin reform_N = mkN "การปฎิรูป" | mkN "การปฏิรูป" | mkN "การปรับปรุง" | mkN "การเปลี่ยนแปลง" ; -- src=panlex
lin driverMasc_N = variants{} ; -- 
lin annual_A = mkA "รายปี" | mkA "เป็นรายปี" | mkA "ที่มีอายุไม่เกินหนึ่งปี" | mkA "ทุกปี" | mkA "ประจําปี" | mkA "เกี่ยวกับปี" | mkA "เกิดขึ้นระหว่างปี" | mkA "ซึ่งเกิดขึ้นปีละครั้ง" ; -- src=panlex
lin nuclear_A = mkA "นิวเคลียร์" | mkA "เกี่ยวกับนิวเคลียร์" | mkA "เกี่ยวกับพลังงานนิวเคลียร์" ; -- src=panlex
lin latter_A = mkA "ต่อมา" | mkA "ใกล้จบ" | mkA "ภายหลัง" | mkA "อันหลัง" | mkA "ระยะหลัง" | mkA "ครึ่งหลัง" | mkA "ส่วนที่สอง" | mkA "ในเวลาต่อมา" ; -- src=panlex
lin practical_A = mkA "ได้ผล" | mkA "ใช้ได้" | mkA "เหมาะสม" | mkA "มีประโยชน์" | mkA "ที่ใช้ได้จริง" | mkA "ตามความเป็นจริง" | mkA "เน้นในทางปฏิบัติ" | mkA "เกี่ยวกับการกระทํา" | mkA "เกี่ยวกับการปฏิบัติ" | mkA "ที่ขึ้นอยู่กับความเป็นจริง" ; -- src=panlex
lin commercial_A = mkA "เป็นการค้า" | mkA "เกี่ยวกับการค้า" | mkA "สําหรับนักธุรกิจ" | mkA "ไม่บริสุทธิเต็มที่" | mkA "ซึ่งมีจุดประสงค์เพื่อหวังกําไร" | mkA "ซึ่งมีจุดประสงค์เพื่อหวังกําไรได้" ; -- src=panlex
lin rich_A = mkA "ทึบ" | mkA "รวย" | mkA "มั่งมี" | mkA "ร่ำรวย" | mkA "มั่งคั่ง" | mkA "ซึ่งอุดมสมบูรณ์" | mkA "ซึ่งมีมากมายก่ายกอง" | mkA "จัด" | mkA "รวย" | mkA "อุดม" | mkA "เข้ม" | mkA "มีค่า" | mkA "มั่งมี" | mkA "สวยงาม" | mkA "หรูหรา" | mkA "เลี่ยน" | mkA "นิ่มนวล" | mkA "มันย่อง" | mkA "ร่ํารวย" | mkA "เข้มข้น" | mkA "มั่งคั่ง" | mkA "มีผลิตผลมาก" | mkA "อุดมสมบูรณ์" ; -- src=panlex
lin emerge_V = mkV "ออกมา" | mkV "เกิดขึ้น" | mkV "ปรากฏ" | mkV "ปรากฏตัว" | mkV "ปรากฏออกมา" | mkV "เป็นที่รู้จัก" ; -- src=panlex
lin apparently_Adv = variants{} ; -- 
lin ring_V = mkV "โทร" | mkV "ล้อม" | mkV "โทรหา" | mkV "ตีระฆัง" | mkV "ล้อมรอบ" | mkV "สวมแหวน" | mkV "โทรศัพท์" | mkV "โทรศัพท์หา" | mkV "ส่งเสียงก้อง" | mkV "ล้อม" | mkV "ล้อมวง" | mkV "ปิดล้อม" | mkV "สนตะพาย" | mkV "ใส่ปลอก" | mkV "ใส่ห่วง" | mkV "โทรศัพท์" | mkV "เคาะระฆัง" | mkV "สั่นกระดิ่ง" | mkV "ทําเสียงก้อง" | mkV "ทําเสียงสะท้อน" | mkV "ส่งเสียงดังก้อง" | mkV "ส่งเสียงดังกังวาน" ; -- src=panlex
lin ring_6_V2 = variants{} ; -- 
lin ring_4_V2 = variants{} ; -- 
lin distance_N = mkN "ระยะ" | mkN "ความยาว" | mkN "ระยะทาง" | mkN "ช่วงเวลา" | mkN "ระยะห่าง" | mkN "ระยะเวลา" | mkN "ถิ่นห่างไกล" | mkN "ระยะทาง" | mkN "ช่วงเวลา" | mkN "ระยะห่าง" | mkN "ระยะทางไกล" | mkN "ความห่างไกล" | mkN "ความห่างเหิน" | mkN "จุดหรือบริเวณที่อยู่ไกล" ; -- src=panlex
lin exercise_N = mkN "พิธี" | mkN "การใช้" | mkN "แบบฝึกหัด" | mkN "การฝึกซ้อม" | mkN "การออกกำลังกาย" | mkN "การบริหารร่างกาย" | mkN "การใช้" | mkN "แบบฝึกหัด" | mkN "การออกกําลัง" | mkN "การดําเนินการ" | mkN "การออกกําลังกาย" | mkN "การบริหารร่างกาย" ; -- src=panlex
lin key_A = mkA "หลัก" | mkA "ใหญ่" | mkA "นัย" | mkA "หลัก" | mkA "มีนัย" | mkA "สําคัญ" | mkA "มีความหมาย" ; -- src=panlex
lin close_Adv = mkAdv "เกือบถึง" | mkAdv "อย่างใกล้ชิด" | mkAdv "ใกล้" ; -- src=panlex
lin skin_N = mkN (thword "ผิว" "หนัง") | {-pan-} mkN "หนัง" | mkN "เปลือก" | mkN "ถุงหนัง" | mkN "ผิวหนัง" | mkN "หนังชั้นใน" | mkN "ปีน" | mkN "หวด" | mkN "ป่าย" | mkN "หนัง" | mkN "ชีวิต" | mkN "ปกคลุม" | mkN "เฆี่ยน" | mkN "เปลือก" | mkN "กระตุ้น" | mkN "ถลกหนัง" | mkN "ผิวหนัง" | mkN "ผิวหน้า" | mkN "หลอกลวง" | mkN "คนตระหนี่" | mkN "ถุงหนังสําหรับใส่ของเหลว" | mkN "ฝ้าที่อยู่ลอยบนผิวของเหลว" ; -- src=panlex
lin island_N = mkN "เกาะ" | mkN "เกาะแก่ง" | mkN "เกาะ" | mkN "เนินเดี่ยว" | mkN "เกาะกลางถนน" ; -- src=panlex
lin separate_A = mkA "แยก" | mkA "สกัด" | mkA "อิสระ" | mkA "กระจาย" | mkA "ชัดเจน" | mkA "เอกเทศ" | mkA "แยกกัน" | mkA "แยกออก" | mkA "แยกแยะ" | mkA "เด่นชัด" | mkA "แบ่งสรร" | mkA "วินิจฉัย" | mkA "เดียวดาย" | mkA "กระจายออก" | mkA "โดดเดี่ยว" | mkA "เฉพาะบุคคล" | mkA "ซึ่งแบ่งออก" | mkA "ไม่ต่อเนื่อง" | mkA "ซึ่งแตกต่างกัน" | mkA "ีซึ่งเป็นอิสระ" | mkA "ซึ่งแยกออกจากกัน" | mkA "ซึ่งไม่ต่อเนื่อง" | mkA "ซึ่งไม่เชื่อมกัน" | mkA "ีซึ่งไม่ขึ้นกับใคร" ; -- src=panlex
lin aim_VV = mkVV "มุ่ง" ; ---- | mkV "เล็ง" | mkV "ตั้งใจ" | mkV "ตั้งเป้า" | mkV "ต้องการไป" | mkV "จัดโครงการ" | mkV "มีเป้าหมาย" | mkV "ตั้งความหวัง" | mkV "เจตนา" | mkV "ตั้งใจ" | mkV "วางแผน" | mkV "ตั้งเป้า" | mkV "มุ่งเป้า" | mkV "เล็งเป้าหมาย" ; -- src=panlex
lin aim_V2 = mkV2 "มุ่ง" ; ---- | mkV "เล็ง" | mkV "ตั้งใจ" | mkV "ตั้งเป้า" | mkV "ต้องการไป" | mkV "จัดโครงการ" | mkV "มีเป้าหมาย" | mkV "ตั้งความหวัง" | mkV "เจตนา" | mkV "ตั้งใจ" | mkV "วางแผน" | mkV "ตั้งเป้า" | mkV "มุ่งเป้า" | mkV "เล็งเป้าหมาย" ; -- src=panlex
lin aim_V = mkV "มุ่ง" | mkV "เล็ง" | mkV "ตั้งใจ" | mkV "ตั้งเป้า" | mkV "ต้องการไป" | mkV "จัดโครงการ" | mkV "มีเป้าหมาย" | mkV "ตั้งความหวัง" | mkV "เจตนา" | mkV "ตั้งใจ" | mkV "วางแผน" | mkV "ตั้งเป้า" | mkV "มุ่งเป้า" | mkV "เล็งเป้าหมาย" ; -- src=panlex
lin danger_N = mkN "อันตราย" | mkN "ภยันตราย" | mkN "ที่อันตราย" | mkN "ภัย" | mkN "อันตราย" | mkN "ภยันตราย" | mkN "ภัยอันตราย" | mkN "การเสี่ยงภัย" | mkN "ความไม่ปลอดภัย" | mkN "สถานการณ์อันตราย" | mkN "คนหรือสิ่งที่ก่อให้เกิดอันตราย" ; -- src=panlex
lin credit_N = mkN "เครดิต" | mkN "สินเชื่อ" | mkN "หน่วยกิต" | mkN "เชิงอรรถ" | mkN "การอ้างอิง" | mkN "เงินสินเชื่อ" | mkN "หน่วยกิตรายวิชา" | mkN "รายการทางด้่านเครดิต" | mkN "รายชื่อผู้มีส่วนร่วมในภาพยนต์" | mkN "สินเชื่อ" | mkN "หน่วยกิต" | mkN "ชื่อเสียง" | mkN "การซื้อเชื่อ" | mkN "ความไว้วางใจ" | mkN "ฐานะทางการเงิน" | mkN "ยอดคงเหลือในบัญชี" | mkN "ระยะเวลาที่ให้สินเชื่อ" | mkN "จํานวนเงินที่จ่ายเข้าบัญชี" ; -- src=panlex
lin usual_A = mkA "สามัญ" | mkA "ธรรมดา" | mkA "เป็นปกติ" | mkA "เป็นประจํา" ; -- src=panlex
lin link_V2 = mkV2 "ผูก" ; ---- | mkV "ใส่แอก" | mkV "เชื่อมกัน" | mkV "เชื่อมโยง" | mkV "ต่อ" | mkV "ประสาน" | mkV "เชื่อม" ; -- src=panlex
lin link_V = mkV "ผูก" | mkV "ใส่แอก" | mkV "เชื่อมกัน" | mkV "เชื่อมโยง" | mkV "ต่อ" | mkV "ประสาน" | mkV "เชื่อม" ; -- src=panlex
lin candidateMasc_N = variants{} ; -- 
lin track_N = mkN "ราง" | mkN "ท่อน" | mkN "แทร็ก" | mkN "ร่องรอย" | mkN "เส้นทาง" | mkN "ทางเกวียน" | mkN "แทร็คข้อมูล" | mkN "สนามแข่งวิ่ง" | mkN "เหล็กคาดล้อตีนตะขาบ" | mkN "ถนน" | mkN "ลู่" | mkN "รางรถ" | mkN "หนทาง" | mkN "คอยตาม" | mkN "ตามทาง" | mkN "ทางรถไฟ" | mkN "รอยเท้า" | mkN "รางรถไฟ" | mkN "ร่องรอย" | mkN "ลู่วิ่ง" | mkN "วิถีทาง" | mkN "หลักฐาน" | mkN "เส้นทาง" | mkN "ทางในป่า" | mkN "รอยทางรถ" | mkN "ช่วงล้อรถ" | mkN "ทางเกวียน" | mkN "รางคู่ขนาน" | mkN "ทางเดินเท้า" | mkN "ร่องแผ่นเสียง" | mkN "ร่องรอยทางเดิน" | mkN "ลู่สําหรับวิ่ง" | mkN "ร่องเสียงในเทปแม่เหล็ก" ; -- src=panlex
lin safe_A = mkA "ปลอดภัย" | mkA "ซึ่งไม่มีความเสี่ยง" | mkA "มั่นคง" | mkA "ปลอดภัย" | mkA "ถุงยางคุมกําเนิด" | mkA "ซึ่งได้รับการปกป้อง" | mkA "ซึ่งได้รับการคุ้มครอง" ; -- src=panlex
lin interested_A = mkA "ซึ่งสนใจ" | mkA "ซึ่งอยากรู้" | mkA "ซึ่งเอาใจใส่" ; -- src=panlex
lin assessment_N = mkN "การตัดสิน" | mkN "การประเมิน" | mkN "การกําหนด" | mkN "การประเมิน" | mkN "การประเมินค่า" | mkN "ปริมาณที่ประเมิน" ; -- src=panlex
lin path_N = mkN "ทาง" | mkN "เส้นทาง" | mkN "ทางชีวิต" | mkN "ทาง" | mkN "ลู่" | mkN "แนวทาง" | mkN "ทางผ่าน" | mkN "ทางเดิน" | mkN "วิถีทาง" | mkN "เส้นทาง" ; -- src=panlex
lin merely_Adv = variants{} ; -- 
lin plus_Prep = mkPrep "กับ" | mkPrep "บวก" | mkPrep "มาก" | mkPrep "เพิ่ม" | mkPrep "บวกเพิ่ม" | mkPrep "ส่วนเกิน" | mkPrep "เพิ่มอีก" | mkPrep "เพิ่มเข้าไป" | mkPrep "ของส่วนเพิ่ม" ; -- src=panlex
lin district_N = mkN "เขต" | mkN "เขตปกครอง" | mkN "เขต" | mkN "แถบ" | mkN "แขวง" | mkN "ตําบล" | mkN "เมือง" | mkN "บริเวณ" | mkN "เขตแดน" | mkN "ท้องถิ่น" | mkN "อาณาบริเวณ" ; -- src=panlex
lin regular_A = mkA "ปกติ" | mkA "ตามกฎ" | mkA "สามัญ" | mkA "ธรรมดา" | mkA "ตามแบบแผน" | mkA "มีกฎเกณฑ์" | mkA "มีระเบียบ" | mkA "สม่ําเสมอ" | mkA "ตามระเบียบ" | mkA "เป็นประจํา" | mkA "เป็นกิจวัตร" | mkA "ทหารประจําการ" | mkA "ถูกต้องตามกฎเกณฑ์" | mkA "เกี่ยวกับทหารประจําการ" ; -- src=panlex
lin reaction_N = mkN "ปฏิกิริยา" | mkN "การตอบสนอง" | mkN "ปฏิกิริยาเคมี" | mkN "การโต้ตอบ" | mkN "ปฏิกิริยา" | mkN "การตอบสนอง" | mkN "ลัทธิฝ่ายขวา" | mkN "ปฏิกิริยาเคมี" | mkN "ปฏิกิริยาตอบกลับ" | mkN "ปฏิกิริยาทางเคมี" ; -- src=panlex
lin impact_N = mkN "ปะทะ" | mkN "กระทบ" | mkN "การชน" | mkN "การอัด" | mkN "การปะทะ" | mkN "ผลกระทบ" | mkN "อิทธิพล" | mkN "แรงปะทะ" | mkN "การกระทบ" | mkN "ผลสะท้อน" | mkN "แรงกระทบ" ; -- src=panlex
lin collect_V2 = mkV2 "สะสม" ; ---- | mkV "รวบรวม" | mkV "รวบรวมเงิน" | mkV "ค่อยๆ เพิ่มขึ้น" | mkV "คุมสติ" | mkV "รวบรวม" | mkV "ไปนํามา" | mkV "ไปเอามา" | mkV "เก็บเงิน" | mkV "เพิ่มพูน" | mkV "รวบรวมสติ" | mkV "ไปพาตัวมา" | mkV "เก็บรวบรวม" | mkV "เก็บค่าเช่า" | mkV "เรี่ยไรเงิน" | mkV "ขอเงินเพื่อการกุศล" ; -- src=panlex
lin collect_V = mkV "สะสม" | mkV "รวบรวม" | mkV "รวบรวมเงิน" | mkV "ค่อยๆ เพิ่มขึ้น" | mkV "คุมสติ" | mkV "รวบรวม" | mkV "ไปนํามา" | mkV "ไปเอามา" | mkV "เก็บเงิน" | mkV "เพิ่มพูน" | mkV "รวบรวมสติ" | mkV "ไปพาตัวมา" | mkV "เก็บรวบรวม" | mkV "เก็บค่าเช่า" | mkV "เรี่ยไรเงิน" | mkV "ขอเงินเพื่อการกุศล" ; -- src=panlex
lin debate_N = mkN "การดีเบต" | mkN "การอภิปราย" | mkN "การโต้แย้ง" | mkN "การถกเถียง" | mkN "การพิจารณา" | mkN "การอภิปราย" | mkN "การโต้วาที" | mkN "การโต้แย้ง" | mkN "การวินิจฉัย" | mkN "การใคร่ครวญ" | mkN "การไตร่ตรอง" | mkN "การใช้ดุลยพินิจ" ; -- src=panlex
lin lay_V2 = mkV2 "ก่อ" ; ---- | mkV "วาง" | mkV "ตั้ง" | mkV "ออกไข่" | mkV "วางแนวนอน" | mkV "ปู" | mkV "พาด" | mkV "ลาด" | mkV "วาง" | mkV "คลี่" | mkV "วางลง" | mkV "สร้าง" | mkV "วางราก" | mkV "วางไข่" | mkV "ออกไข่" | mkV "ก่อตั้ง" | mkV "จัดตั้ง" | mkV "จัดโต๊ะ" | mkV "ท้าพนัน" | mkV "นําเสนอ" | mkV "มอบหมาย" | mkV "นําไปแจ้ง" | mkV "ให้เหตุผล" | mkV "วางเดิมพัน" | mkV "อ้างเหตุผล" | mkV "ทําให้เรียบ" | mkV "มีเพศสัมพันธ์" | mkV "จัดวางให้เหมาะสม" | mkV "วางให้เป็นระเบียบ" | mkV "จัดเตรียมโต๊ะอาหาร" | mkV "ทําให้อยู่ในสภาพใดสภาพหนึ่ง" ; -- src=panlex
lin lay_V = mkV "ก่อ" | mkV "วาง" | mkV "ตั้ง" | mkV "ออกไข่" | mkV "วางแนวนอน" | mkV "ปู" | mkV "พาด" | mkV "ลาด" | mkV "วาง" | mkV "คลี่" | mkV "วางลง" | mkV "สร้าง" | mkV "วางราก" | mkV "วางไข่" | mkV "ออกไข่" | mkV "ก่อตั้ง" | mkV "จัดตั้ง" | mkV "จัดโต๊ะ" | mkV "ท้าพนัน" | mkV "นําเสนอ" | mkV "มอบหมาย" | mkV "นําไปแจ้ง" | mkV "ให้เหตุผล" | mkV "วางเดิมพัน" | mkV "อ้างเหตุผล" | mkV "ทําให้เรียบ" | mkV "มีเพศสัมพันธ์" | mkV "จัดวางให้เหมาะสม" | mkV "วางให้เป็นระเบียบ" | mkV "จัดเตรียมโต๊ะอาหาร" | mkV "ทําให้อยู่ในสภาพใดสภาพหนึ่ง" ; -- src=panlex
lin rise_N = mkN "การขึ้น" | mkN "ชันขึ้น" | mkN "การขึ้นราคา" | mkN "การค่อยๆเพิ่ม" | mkN "การทำให้ลาดขึ้น" | mkN "การเพิ่มสูงขึ้น" | mkN "เงินเดือนที่เพิ่มขึ้น" | mkN "การกบฏ" | mkN "การลุกฮือ" | mkN "การยกระดับ" | mkN "การก่อจลาจล" | mkN "จุดเริ่มต้น" | mkN "การเพิ่มขึ้น" | mkN "แหล่งกําเนิด" | mkN "การเลื่อนขึ้น" | mkN "ระดับที่สูงขึ้น" | mkN "การเลื่อนสถานะขึ้น" | mkN "การเปลี่ยนระดับสูงขึ้น" | mkN "การปรากฏขึ้นเหนือเส้นขอบฟ้า" ; -- src=panlex
lin belief_N = mkN "ความเชื่อ" | mkN "ศรัทธา" | mkN "ความเชื่อ" | mkN "ความมั่นใจ" | mkN "ความศรัทธา" | mkN "ความคิดเห็น" | mkN "ความเชื่อถือ" | mkN "ข้อบัญญัติทางศาสนา" ; -- src=panlex
lin conclusion_N = mkN "ตอนจบ" | mkN "บทสรุป" | mkN "ตอนท้าย" | mkN "คำตัดสิน" | mkN "ตอนสุดท้าย" | mkN "การตัดสินใจ" | mkN "ช่วงปิดท้าย" | mkN "เหตุการณ์ตอนจบ" | mkN "การทำให้สิ้นสุด" | mkN "ความเห็นต่อท้าย" | mkN "ช่วงปิดการสนทนา" | mkN "ข้อเสนอแนะที่มีเหตุผล" | mkN "ผล" | mkN "บทสรุป" | mkN "การสรุป" | mkN "การลงเอย" | mkN "ส่วนสุดท้าย" | mkN "การสิ้นสุดลง" | mkN "การตกลงขั้นสุดท้าย" | mkN "การตัดสินใจครั้งสุดท้าย" ; -- src=panlex
lin shape_N = mkN "กาย" | mkN "ทรง" | mkN "รูป" | mkN "รูปทรง" | mkN "สังขาร" | mkN "สุขภาพ" | mkN "รูปร่าง" | mkN "ร่างกาย" | mkN "พระวรกาย" | mkN "ร่างกายมนุษย์" | mkN "ร่างกายของมนุษย์" | mkN "รูป" | mkN "โฉม" | mkN "ร่าง" | mkN "สภาพ" | mkN "ฟอร์ม" | mkN "ท่าทาง" | mkN "รูปทรง" | mkN "รูปแบบ" | mkN "รูปโฉม" | mkN "สัณฐาน" | mkN "สุขภาพ" | mkN "ทรวดทรง" | mkN "รูปร่าง" | mkN "โครงร่าง" | mkN "สภาพการณ์" | mkN "การซ่อมแซม" | mkN "ความสมบูรณ์" | mkN "วิถีทางชีวิต" | mkN "การกําหนดสัณฐาน การจัดอย่างมีระเบียบ" | mkN "เครื่องอาภรณ์แสดงละคร" ; -- src=panlex
lin vote_N = mkN "การโหวต" | mkN "สิทธิเลือกตั้ง" | mkN "การลงคะแนนเสียง" | mkN "จำนวนผู้ใช้สิทธิ" | mkN "ผู้ออกเสียงเลือกตั้ง" | mkN "สิทธิออกเสียงเลือกตั้ง" | mkN "เสนอ" | mkN "ลงมติ" | mkN "เลือกตั้ง" | mkN "คะแนนเสียง" | mkN "การออกเสียง" | mkN "การเลือกตั้ง" | mkN "ลงคะแนนเสียง" | mkN "บัตรคะแนนเสียง" | mkN "การลงคะแนนเสียง" | mkN "จํานวนคะแนนเสียง" | mkN "สิทธิการออกเสียง" | mkN "ผู้ที่มีสิทธิออกเสียง" | mkN "สิทธิในการออกเสียงเลือกตั้ง" ; -- src=panlex
lin aim_N = mkN "ทิศทาง" | mkN "จุดประสงค์" | mkN "จุดมุ่งหมาย" | mkN "เป้า" | mkN "เล็ง" | mkN "เข้าหา" | mkN "การเล็ง" | mkN "จุดหมาย" | mkN "ที่หมาย" | mkN "มุ่งหมาย" | mkN "เป้าหมาย" | mkN "ความตั้งใจ" | mkN "จุดประสงค์" | mkN "จุดมุ่งหมาย" | mkN "ความมุ่งหมาย" | mkN "ทักษะการเล็ง" | mkN "วัตถุประสงค์" | mkN "ระดับความแม่นยํา" ; -- src=panlex
lin politics_N = mkN "รัฐศาสตร์" | mkN "งานการเมือง" | mkN "งานทางการเมือง" | mkN "เรื่องทางการเมือง" | mkN "กิจกรรมทางการเมือง" | mkN "ความเห็นทางการเมือง" | mkN "ความสัมพันธ์ทางการเมือง" | mkN "การเมือง" | mkN "รัฐศาสตร์" | mkN "วิชาการเมือง" | mkN "้อุบายทางการเมือง" | mkN "กิจกรรมทางการเมือง" | mkN "หลักการทางการเมือง" | mkN "ศิลปะการปกครองโดยรัฐ" | mkN "ข้อคิดเห็นทางการเมือง" | mkN "เล่ห์เหลี่ยมทางการเมือง" ; -- src=panlex
lin reply_VS = mmkVS "ตอบ" ; ---- | mkV "ตอบ" ; -- src=panlex
lin reply_V = mkV "ตอบ" | mkV "ตอบ" ; -- src=panlex
lin press_V2V = mmkV2V "กด" ; ---- | mkV "ดัน" | mkV "ทับ" | mkV "บีบ" | mkV "รีด" | mkV "คั้น" | mkV "สั่ง" | mkV "เบ่ง" | mkV "เม้ม" | mkV "กดทับ" | mkV "ยกเวท" | mkV "เบียด" | mkV "ขอร้อง" | mkV "รณรงค์" | mkV "รีดผ้า" | mkV "วิงวอน" | mkV "กระตุ้น" | mkV "ยกน้ำหนัก" | mkV "เรียกร้อง" | mkV "ทำความหนักใจ" | mkV "อัดจากพลาสติก" | mkV "ใช้น้ำหนักกดทับ" | mkV "กด" | mkV "นาบ" | mkV "แนบ" | mkV "บีบอัด" | mkV "รีดผ้า" | mkV "กระตุ้น" | mkV "เรียกร้อง" | mkV "เคี่ยวเข็ญ" | mkV "รีดให้เรียบ" | mkV "คั้นน้ําผลไม้" | mkV "บีบอัดให้เล็กลง" | mkV "เกณฑ์เข้าเป็นทหาร" | mkV "เน้นย้ําให้เห็นความสําคัญ" | mkV "กดดันผู้อื่นให้ทําบางสิ่งบางอย่าง" ; -- src=panlex
lin press_V2 = mkV2 "กด" ; ---- | mkV "ดัน" | mkV "ทับ" | mkV "บีบ" | mkV "รีด" | mkV "คั้น" | mkV "สั่ง" | mkV "เบ่ง" | mkV "เม้ม" | mkV "กดทับ" | mkV "ยกเวท" | mkV "เบียด" | mkV "ขอร้อง" | mkV "รณรงค์" | mkV "รีดผ้า" | mkV "วิงวอน" | mkV "กระตุ้น" | mkV "ยกน้ำหนัก" | mkV "เรียกร้อง" | mkV "ทำความหนักใจ" | mkV "อัดจากพลาสติก" | mkV "ใช้น้ำหนักกดทับ" | mkV "กด" | mkV "นาบ" | mkV "แนบ" | mkV "บีบอัด" | mkV "รีดผ้า" | mkV "กระตุ้น" | mkV "เรียกร้อง" | mkV "เคี่ยวเข็ญ" | mkV "รีดให้เรียบ" | mkV "คั้นน้ําผลไม้" | mkV "บีบอัดให้เล็กลง" | mkV "เกณฑ์เข้าเป็นทหาร" | mkV "เน้นย้ําให้เห็นความสําคัญ" | mkV "กดดันผู้อื่นให้ทําบางสิ่งบางอย่าง" ; -- src=panlex
lin press_V = mkV "กด" | mkV "ดัน" | mkV "ทับ" | mkV "บีบ" | mkV "รีด" | mkV "คั้น" | mkV "สั่ง" | mkV "เบ่ง" | mkV "เม้ม" | mkV "กดทับ" | mkV "ยกเวท" | mkV "เบียด" | mkV "ขอร้อง" | mkV "รณรงค์" | mkV "รีดผ้า" | mkV "วิงวอน" | mkV "กระตุ้น" | mkV "ยกน้ำหนัก" | mkV "เรียกร้อง" | mkV "ทำความหนักใจ" | mkV "อัดจากพลาสติก" | mkV "ใช้น้ำหนักกดทับ" | mkV "กด" | mkV "นาบ" | mkV "แนบ" | mkV "บีบอัด" | mkV "รีดผ้า" | mkV "กระตุ้น" | mkV "เรียกร้อง" | mkV "เคี่ยวเข็ญ" | mkV "รีดให้เรียบ" | mkV "คั้นน้ําผลไม้" | mkV "บีบอัดให้เล็กลง" | mkV "เกณฑ์เข้าเป็นทหาร" | mkV "เน้นย้ําให้เห็นความสําคัญ" | mkV "กดดันผู้อื่นให้ทําบางสิ่งบางอย่าง" ; -- src=panlex
lin approach_V2 = mkV2 "ทาบทาม" ; ---- | mkV "เข้าใกล้" | mkV "ใกล้เคียง" | mkV "ถึง" | mkV "คล้าย" | mkV "จัดการ" | mkV "เข้าหา" | mkV "ใกล้จะ" | mkV "เข้าใกล้" | mkV "ใกล้เคียง" | mkV "ปฎิบัติต่อ" | mkV "เข้าตีสนิท" | mkV "เกือบจะเป็น" ; -- src=panlex
lin approach_V = mkV "ทาบทาม" | mkV "เข้าใกล้" | mkV "ใกล้เคียง" | mkV "ถึง" | mkV "คล้าย" | mkV "จัดการ" | mkV "เข้าหา" | mkV "ใกล้จะ" | mkV "เข้าใกล้" | mkV "ใกล้เคียง" | mkV "ปฎิบัติต่อ" | mkV "เข้าตีสนิท" | mkV "เกือบจะเป็น" ; -- src=panlex
lin file_N = mkN "ตะไบ" | mkN "แฟ้มข้อมูล" | mkN "ตู้เก็บเอกสาร" | mkN "แถว" | mkN "ตะไบ" | mkN "คอลัมน์" | mkN "แฟ้มเอกสาร" | mkN "แถวที่เรียง" | mkN "แฟ้มเก็บเอกสาร" | mkN "เอกสารที่จัดเก็บเป็นหมวดหมู่" ; -- src=panlex
lin western_A = mkA "อยู่ทางทิศตะวันตก" | mkA "ซึ่งอยู่ทางทิศตะวันตก" | mkA "ซึ่งมาจากทางทิศตะวันตก" | mkA "ซึ่งพัดมาจากทางทิศตะวันตก" | mkA "ซึ่งหันหน้าไปทางทิศตะวันตก" | mkA "ี่ซึ่งเป็นคนทางตะวันตกของประเทศหรือภูมิภาค" ; -- src=panlex
lin earth_N = mkN (thword "โลก") | {-pan-} mkN "ดิน" | mkN "โลก" | mkN "พื้น" | mkN "ผืนดิน" | mkN "สายดิน" | mkN "ธาตุดิน" | mkN "พื้นดิน" | mkN "แผ่นดิน" | mkN "สายกราวด์" | mkN "โลกมนุษย์" | mkN "เรื่องทางโลก" | mkN "ดิน" | mkN "โลก" | mkN "ธรณี" | mkN "ปฐพี" | mkN "ที่ดิน" | mkN "มนุษย์" | mkN "โลกีย์" | mkN "พื้นดิน" | mkN "มวลมนุษย์" | mkN "โลกมนุษย์" | mkN "คนที่อาศัยอยู่บนโลก" | mkN "สรรพสิ่งทั้งหลายบนโลก" ; -- src=panlex
lin public_N = mkN "สาธารณชน" | mkN "มวลชน" | mkN "มหาชน" | mkN "กลุ่มคน" | mkN "กลุ่มชน" | mkN "ประชาชน" | mkN "สาธารณชน" | mkN "เลื่องลือ" | mkN "โดยส่วนรวม" | mkN "มีชื่อเสียง" ; -- src=panlex
lin survive_V2 = mkV2 "รอดตาย" ; ---- | mkV "รอดชีวิต" | mkV "ดำรงชีวิต" | mkV "มีชีวิตรอด" | mkV "อยู่ได้นานกว่า" | mkV "อยู่รอด" | mkV "ดํารงอยู่" | mkV "มีชีวิตรอด" | mkV "คงอยู่ต่อไป" | mkV "มีชีวิตอยู่" | mkV "รอดชีวิตอยู่" | mkV "มีชีวิตสืบต่อ" | mkV "มีอายุยืนกว่า" ; -- src=panlex
lin survive_V = mkV "รอดตาย" | mkV "รอดชีวิต" | mkV "ดำรงชีวิต" | mkV "มีชีวิตรอด" | mkV "อยู่ได้นานกว่า" | mkV "อยู่รอด" | mkV "ดํารงอยู่" | mkV "มีชีวิตรอด" | mkV "คงอยู่ต่อไป" | mkV "มีชีวิตอยู่" | mkV "รอดชีวิตอยู่" | mkV "มีชีวิตสืบต่อ" | mkV "มีอายุยืนกว่า" ; -- src=panlex
lin estate_N = mkN "ทรัพย์มรดก" | mkN "อสังหาริมทรัพย์" | mkN "มรดก" | mkN "ที่ดิน" | mkN "ฐานันดร" | mkN "ทรัพย์สิน" | mkN "กลุ่มสังคม" | mkN "กลุ่มการเมือง" | mkN "ทรัพย์สินที่ดิน" | mkN "อสังหาริมทรัพย์" ; -- src=panlex
lin boat_N = mkN (thword "เรือ") "ลำ" | {-pan-} mkN "ชาม" | mkN "นาวา" | mkN "เรือ" | mkN "เภตรา" | mkN "เหยือกน้ำเกรวี่" | mkN "เรือ" ; -- src=panlex
lin prison_N = mkN "รจ." | mkN "คุก" | mkN "เรือนจำ" | mkN "ทัณฑสถาน" | mkN "สถานที่คุมขังนักโทษ" | mkN "คุก" | mkN "ซังเต" | mkN "ตะราง" | mkN "ตาราง" | mkN "เรือนจํา" | mkN "การกักกัน" | mkN "การกักขัง" | mkN "การคุมตัว" | mkN "การติดคุก" | mkN "ที่คุมขัง" | mkN "สถานที่คุมขัง" ; -- src=panlex
lin additional_A = mkA "พิเศษ" | mkA "เสริม" | mkA "เพิ่มเติม" | mkA "ที่มากขึ้น" | mkA "ที่เพิ่มขึ้น" | mkA "ที่เพิ่มเติมขึ้น" ; -- src=panlex
lin settle_V2 = mkV2 "จม" ; ---- | mkV "ตัดสิน" | mkV "นอนก้น" | mkV "ล้างตา" | mkV "ตกตะกอน" | mkV "ทวงแค้น" | mkV "มาเยือน" | mkV "แก้แค้น" | mkV "ชำระแค้น" | mkV "ล้างแค้น" | mkV "สร้างชุมชน" | mkV "ตั้งถิ่นฐาน" | mkV "ตกตะกอนนอนก้น" | mkV "ทำเป็นอันดับสุดท้าย" | mkV "ตัดสิน" | mkV "จ่ายหนี้" | mkV "ตัดสินใจ" | mkV "ปิดบัญชี" | mkV "แก้ปัญหา" | mkV "ชําระเงิน" | mkV "ตั้งรกราก" | mkV "เข้ามาอาศัยอยู่" | mkV "ทําให้เข้ามาอาศัยอยู่" ; -- src=panlex
lin settle_V = mkV "จม" | mkV "ตัดสิน" | mkV "นอนก้น" | mkV "ล้างตา" | mkV "ตกตะกอน" | mkV "ทวงแค้น" | mkV "มาเยือน" | mkV "แก้แค้น" | mkV "ชำระแค้น" | mkV "ล้างแค้น" | mkV "สร้างชุมชน" | mkV "ตั้งถิ่นฐาน" | mkV "ตกตะกอนนอนก้น" | mkV "ทำเป็นอันดับสุดท้าย" | mkV "ตัดสิน" | mkV "จ่ายหนี้" | mkV "ตัดสินใจ" | mkV "ปิดบัญชี" | mkV "แก้ปัญหา" | mkV "ชําระเงิน" | mkV "ตั้งรกราก" | mkV "เข้ามาอาศัยอยู่" | mkV "ทําให้เข้ามาอาศัยอยู่" ; -- src=panlex
lin largely_Adv = variants{} ; -- 
lin wine_N = mkN (thword "เหล้า" "องุ่น") "ขวด" | {-pan-} mkN "ไวน์" | mkN "ไวน์" | mkN "สีไวน์" | mkN "น้ําองุ่น" | mkN "เหล้าไวน์" | mkN "เหล้าองุ่น" | mkN "สีแดงปนม่วงเข้ม" | mkN "สิ่งที่ทําให้เมา" | mkN "งานเลี้ยงเหล้าหลังอาหาร" | mkN "สีแดงเข้มของเหล้าองุ่นแดง" ; -- src=panlex
lin observe_VS = variants{} ; -- 
lin observe_V2 = variants{} ; -- 
lin limit_V2V = variants{} ; -- 
lin limit_V2 = variants{} ; -- 
lin deny_V3 = variants{} ; -- 
lin deny_V2 = variants{} ; -- 
lin for_PConj = variants{} ; -- 
lin straight_Adv = mkAdv "ตรง" | mkAdv "โดยตรง" | mkAdv "อย่างแน่แท้" | mkAdv "อย่างตรงไปตรงมา" | mkAdv "ตรง" | mkAdv "ปกติ" | mkAdv "ทันที" | mkAdv "โดยตรง" | mkAdv "ฉับพลัน" | mkAdv "ซื่อตรง" | mkAdv "ดื่มดวด" | mkAdv "ตรงแน่ว" | mkAdv "ซื่อสัตย์" | mkAdv "มีระเบียบ" | mkAdv "สม่ําเสมอ" | mkAdv "เรียงแต้ม" | mkAdv "เรียบร้อย" | mkAdv "ไม่เจือปน" | mkAdv "ตรงไปตรงมา" | mkAdv "ทันทีทันใด" | mkAdv "เป็นแนวตรง" | mkAdv "โดยฉับพลัน" | mkAdv "ต่อเนื่องกัน" | mkAdv "ชอบด้วยกฎหมาย" | mkAdv "ไม่เปลี่ยนแปลง" ; -- src=panlex
lin somebody_NP = mkNP (thword "บาง" "คน") ;
lin writer_N = mkN "คนเขียน" | mkN "ผู้รจนา" | mkN "ผู้แต่ง" | mkN "นักเขียน" | mkN "ผู้เขียน" | mkN "นักประพันธ์" | mkN "ผู้แต่งหนังสือ" | mkN "กวี" | mkN "ผู้แต่ง" | mkN "นักเขียน" | mkN "ผู้เขียน" | mkN "นักประพันธ์" | mkN "ผู้สามารถเขียนได้" ; -- src=panlex
lin weekend_N = mkN "วีกเอนด์" | mkN "สุดสัปดาห์" | mkN "วันสุดสัปดาห์" | mkN "วันหยุดสุดสัปดาห์" | mkN "วันสุดสัปดาห์" | mkN "ช่วงเวลาตั้งแต่เย็นวันศุกร์ถึงเย็นวันอาทิตย์" ; -- src=panlex
lin clothes_N = mkN "ชุด" | mkN "อาภรณ์" | mkN "ผ้านุ่ง" | mkN "ผ้าผ่อน" | mkN "เสื้อผ้า" | mkN "เสื้อผ้า" | mkN "เครื่องแต่งกาย" ; -- src=panlex
lin active_A = mkA "ปะทุ" | mkA "คึกคัก" | mkA "มีพลัง" | mkA "แอคทีฟ" | mkA "ที่มีผล" | mkA "ที่คึกคัก" | mkA "ยังคุอยู่" | mkA "คล่องแคล่ว" | mkA "ที่ปรากฏขึ้น (จุดมืดบนดวงอาทิตย์)" | mkA "ที่ทำให้เกิดผล" | mkA "ยังคุกรุ่นอยู่" | mkA "ที่แสดงการกระทำ" | mkA "ซึ่งรุนแรงมากขึ้น" | mkA "ซึ่งเป็นผู้กระทำกริยา" | mkA "ไว" | mkA "คล่อง" | mkA "ว่องไว" | mkA "สมมันต์" | mkA "ยังคุอยู่" | mkA "คล่องแคล่ว" | mkA "ซึ่งมีพลัง" | mkA "ปราดเปรียว" | mkA "เป็นผลเร็ว" | mkA "กระฉับกระเฉง" | mkA "กระตือรือร้น" | mkA "ซึ่งทํากําไร" | mkA "ซึ่งประจําการ" | mkA "ที่เคลื่อนที่" | mkA "มีประสิทธิภาพ" | mkA "ซึ่งทํางานอยู่" | mkA "ซึ่งปฏิบัติการ" | mkA "ซึ่งเคลื่อนไหว" | mkA "ยังคุกรุ่นอยู่" | mkA "ซึ่งต้องการพลังงาน" | mkA "ซึ่งพร้อมปฏิบัติการ" | mkA "เกี่ยวกับแหล่งพลังงาน" | mkA "สามารถเคลื่อนไหวเองได้" | mkA "มีลักษณะเป็นกัมมันตภาพรังสี" | mkA "เกี่ยวกับแหล่งกําเนิดพลังงาน" ; -- src=panlex
lin sight_N = mkN "กลุ่ม" | mkN "มากมาย" | mkN "การเห็น" | mkN "จำนวนมาก" | mkN "การมองเห็น" | mkN "จำนวนมากมายก่ายกอง" | mkN "ภาพ" | mkN "วิว" | mkN "ทอด สายตา" | mkN "เล็ง" | mkN "สายตา" | mkN "สังเกต" | mkN "การเห็น" | mkN "ปรับภาพ" | mkN "มองเห็น" | mkN "เล็งวัด" | mkN "ทิวทัศน์" | mkN "การสังเกต" | mkN "จํานวนมาก" | mkN "ปริมาณมาก" | mkN "การพิจารณา" | mkN "การมองเห็น" | mkN "กําลังสายตา" | mkN "สิ่งที่เห็น" | mkN "สิ่งที่มองเห็น" | mkN "ขอบข่ายในการเห็น" | mkN "ความสามารถในการเห็น" ; -- src=panlex
lin video_N = mkN "ภาพ" | mkN "วิดีโอ" | mkN "การแพร่ภาพ" | mkN "การถ่ายทอดโทรทัศน์" | mkN "เครื่องบันทึกวิดีโอ" | mkN "วีดิโอ" | mkN "ภาพโทรทัศน์" | mkN "ตลับเทปวิดีโอ" | mkN "เกี่ยวกับภาพโทรทัศน์" | mkN "ภาพหรือหนังในเทปวิดีโอ" ; -- src=panlex
lin reality_N = mkN "ความเป็นจริง" | mkN "ของจริง" | mkN "ความจริง" | mkN "ความเป็นจริง" | mkN "การคล้ายของจริง" | mkN "สภาพที่เป็นจริง" ; -- src=panlex
lin hall_N = mkN "ฮอล" | mkN "หอพัก" | mkN "คฤหาสน์" | mkN "ล็อบบี้" | mkN "แมนชั่น" | mkN "ห้องประชุม" | mkN "ห้องรับรอง" | mkN "ห้องโถงใหญ่" | mkN "หอพักนักศึกษา" | mkN "ห้องบรรยายรวม" | mkN "หอ" | mkN "ศาล" | mkN "คฤหาสน์" | mkN "ห้องโถง" | mkN "หอประชุม" | mkN "ห้องประชุม" | mkN "ห้องนันทนาการ" | mkN "ห้องรับประทานอาหาร" | mkN "หอพักสําหรับนักศึกษา" | mkN "ระเบียงหรือทางเดินในตึก" | mkN "" | mkN "ห้องซึ่งมีขนาดใหญ่ที่อยู่ด้านหน้าบ้านหรือตึก" | mkN "บ้านหลังใหญ่ที่ตั้งอยู่ในที่ดินที่กว้างขวางมาก" ; -- src=panlex
lin nevertheless_Adv = mkAdv "อย่างไรก็ตาม" | mkAdv "ยิ่งไปกว่านั้น" | mkAdv "ยังคง" | mkAdv "ถึงแม้" | mkAdv "แม้ว่า" | mkAdv "แต่ทว่า" | mkAdv "อย่างไรก็ดี" | mkAdv "อย่างไรก็ตาม" | mkAdv "แต่อย่างไรก็ตาม" | mkAdv "ถึงอย่างนั้นก็ตาม" | mkAdv "ถึงแม้ว่าจะเป็นเช่นนั้นก็ตาม" ; -- src=panlex
lin regional_A = mkA "เกี่ยวกับดินแดน" | mkA "เกี่ยวกับบริเวณ" | mkA "เกี่ยวกับภูมิภาคนั้นๆ" ; -- src=panlex
lin vehicle_N = mkN "กระสายยา" | mkN "ยานพาหนะ" | mkN " สิ่งที่นำไปสู่ความสำเร็จ ความเชื่อหรืออื่นๆ" | mkN "รถ" | mkN "สื่อ" | mkN "พาหนะ" | mkN "น้ํายา" | mkN "ยานยนต์" | mkN "สื่อนํา" | mkN "ยานพาหนะ" | mkN "สื่อกลาง" | mkN "ล้อเลื่อน" | mkN "น้ํากระสาย" | mkN "เครื่องมือ" | mkN "ของเหลวผสมสี" | mkN "สิ่งขับเคลื่อน" | mkN "เครื่องมือลําเลียง" | mkN "สิ่งที่นําไปสู่ความสําเร็จ ความเชื่อหรืออื่นๆ" ; -- src=panlex
lin worry_VS = mmkVS "กังวล" ; ---- | mkV "ก่อกวน" | mkV "วิตกกังวล" | mkV "พะวง" | mkV "ห่วงใย" | mkV "กลุ้มใจ" | mkV "เป็นห่วง" | mkV "วิตกกังวล" | mkV "เป็นทุกข์" | mkV "ทําให้ห่วง" | mkV "ทําให้กลุ้มใจ" | mkV "ทําให้วิตกกังวล" | mkV "ทําให้เป็นทุกข์" ; -- src=panlex
lin worry_V2 = mkV2 "กังวล" ; ---- | mkV "ก่อกวน" | mkV "วิตกกังวล" | mkV "พะวง" | mkV "ห่วงใย" | mkV "กลุ้มใจ" | mkV "เป็นห่วง" | mkV "วิตกกังวล" | mkV "เป็นทุกข์" | mkV "ทําให้ห่วง" | mkV "ทําให้กลุ้มใจ" | mkV "ทําให้วิตกกังวล" | mkV "ทําให้เป็นทุกข์" ; -- src=panlex
lin worry_V = mkV "กังวล" | mkV "ก่อกวน" | mkV "วิตกกังวล" | mkV "พะวง" | mkV "ห่วงใย" | mkV "กลุ้มใจ" | mkV "เป็นห่วง" | mkV "วิตกกังวล" | mkV "เป็นทุกข์" | mkV "ทําให้ห่วง" | mkV "ทําให้กลุ้มใจ" | mkV "ทําให้วิตกกังวล" | mkV "ทําให้เป็นทุกข์" ; -- src=panlex
lin powerful_A = mkA "ที่มีอำนาจ" | mkA "มากมาย" | mkA "แข็งแรง" | mkA "มีแรงมาก" | mkA "ได้ผลมาก" | mkA "มีกําลังมาก" | mkA "มีอํานาจมาก" | mkA "ที่มีอิทธิพล" | mkA "มีสมรรรภาพสูง" | mkA "ที่โน้มน้าวเก่ง" | mkA "ที่มีประสิทธิภาพ" ; -- src=panlex
lin possibly_Adv = variants{} ; -- 
lin cross_V2 = mkV2 "ข้าม" ; ---- | mkV "ขัดขวาง" | mkV "ยับยั้ง" | mkV "ครอบคลุม" | mkV "ขีดเส้นขวาง" | mkV "เดินทางข้าม" | mkV "ผสมข้ามพันธุ์" | mkV "ข้าม" | mkV "ขัดขวาง" | mkV "ต่อต้าน" | mkV "มีอาณาเขตถึง" | mkV "ผสมข้ามพันธุ์" | mkV "เตะบอลขวางสนาม" | mkV "ทําให้มีอาณาเขตถึง" ; -- src=panlex
lin cross_V = mkV "ข้าม" | mkV "ขัดขวาง" | mkV "ยับยั้ง" | mkV "ครอบคลุม" | mkV "ขีดเส้นขวาง" | mkV "เดินทางข้าม" | mkV "ผสมข้ามพันธุ์" | mkV "ข้าม" | mkV "ขัดขวาง" | mkV "ต่อต้าน" | mkV "มีอาณาเขตถึง" | mkV "ผสมข้ามพันธุ์" | mkV "เตะบอลขวางสนาม" | mkV "ทําให้มีอาณาเขตถึง" ; -- src=panlex
lin colleague_N = mkN "สมาชิก" | mkN "เพื่อนร่วมงาน" | mkN "คนระดับเดียวกัน" | mkN "ผู้ร่วมงาน" | mkN "เพื่อนร่วมงาน" ; -- src=panlex
lin charge_V2 = mkV2 "ใส่" ; ---- | mkV "หมอบ" | mkV "ชาร์จ" | mkV "บรรจุ" | mkV "ประจุ" | mkV "หาว่า" | mkV "กล่าวหา" | mkV "ชาร์จไฟ" | mkV "ชาร์จแบต" | mkV "ปลุกปั่น" | mkV "เก็บเงิน" | mkV "แต่งตั้ง" | mkV "เข้าชาร์จ" | mkV "มอบหมายงาน" | mkV "เก็บค่าชาร์จ" | mkV "ชาร์แบตเตอรี่" | mkV "ใช้บัตรเครดิต" | mkV "ใช้บัตรสินเชื่อ" | mkV "มอบ" | mkV "ฟ้อง" | mkV "สั่ง" | mkV "อัดไฟ" | mkV "โจมตี" | mkV "จู่โจม" | mkV "ติดตรา" | mkV "ส่งมอบ" | mkV "กล่าวหา" | mkV "ชาร์จไฟ" | mkV "ติดหนี้" | mkV "ผัดหนี้" | mkV "รับภาระ" | mkV "สั่งให้" | mkV "อัดแน่น" | mkV "ใส่ความ" | mkV "กล่าวโทษ" | mkV "ฟ้องร้อง" | mkV "แต่งตั้ง" | mkV "ชําระเงิน" | mkV "ประทับตรา" | mkV "มากไปด้วย" | mkV "เรียกเก็บ" | mkV "ดําเนินคดี" | mkV "ปกคลุมด้วย" | mkV "มอบหมายให้" | mkV "เต็มไปด้วย" | mkV "เรียกเก็บเงิน" | mkV "ติดเงินไว้ก่อน" | mkV "ลงบันทึกการยืม" | mkV "อัดอยู่ในจิตใจ" | mkV "อัดแน่นอยู่ในใจ" | mkV "ทําให้รับหน้าที่" | mkV "เรียบเก็บค่าใช้จ่าย" | mkV "ยืมหนังสือจากห้องสมุด" | mkV "จ่ายเงินโดยตัดจากบัญชี" | mkV "ทําให้แบกรับภาระหน้าที่" | mkV "จ่ายเงินโดยใช้บัตรเครดิต" | mkV "ส่งเข้าองค์การหรือสถาบันเฉพาะกาล" ; -- src=panlex
lin charge_V = mkV "ใส่" | mkV "หมอบ" | mkV "ชาร์จ" | mkV "บรรจุ" | mkV "ประจุ" | mkV "หาว่า" | mkV "กล่าวหา" | mkV "ชาร์จไฟ" | mkV "ชาร์จแบต" | mkV "ปลุกปั่น" | mkV "เก็บเงิน" | mkV "แต่งตั้ง" | mkV "เข้าชาร์จ" | mkV "มอบหมายงาน" | mkV "เก็บค่าชาร์จ" | mkV "ชาร์แบตเตอรี่" | mkV "ใช้บัตรเครดิต" | mkV "ใช้บัตรสินเชื่อ" | mkV "มอบ" | mkV "ฟ้อง" | mkV "สั่ง" | mkV "อัดไฟ" | mkV "โจมตี" | mkV "จู่โจม" | mkV "ติดตรา" | mkV "ส่งมอบ" | mkV "กล่าวหา" | mkV "ชาร์จไฟ" | mkV "ติดหนี้" | mkV "ผัดหนี้" | mkV "รับภาระ" | mkV "สั่งให้" | mkV "อัดแน่น" | mkV "ใส่ความ" | mkV "กล่าวโทษ" | mkV "ฟ้องร้อง" | mkV "แต่งตั้ง" | mkV "ชําระเงิน" | mkV "ประทับตรา" | mkV "มากไปด้วย" | mkV "เรียกเก็บ" | mkV "ดําเนินคดี" | mkV "ปกคลุมด้วย" | mkV "มอบหมายให้" | mkV "เต็มไปด้วย" | mkV "เรียกเก็บเงิน" | mkV "ติดเงินไว้ก่อน" | mkV "ลงบันทึกการยืม" | mkV "อัดอยู่ในจิตใจ" | mkV "อัดแน่นอยู่ในใจ" | mkV "ทําให้รับหน้าที่" | mkV "เรียบเก็บค่าใช้จ่าย" | mkV "ยืมหนังสือจากห้องสมุด" | mkV "จ่ายเงินโดยตัดจากบัญชี" | mkV "ทําให้แบกรับภาระหน้าที่" | mkV "จ่ายเงินโดยใช้บัตรเครดิต" | mkV "ส่งเข้าองค์การหรือสถาบันเฉพาะกาล" ; -- src=panlex
lin lead_N = mkN "บทนำ" | mkN "ดารานำ" | mkN "ตะกั่ว" | mkN "ตัวเอก" | mkN "สายจูง" | mkN "คะแนนนำ" | mkN "ร่องรอย" | mkN "ไส้ดินสอ" | mkN "นักแสดงนำ" | mkN "สายจั๊มไฟ" | mkN "สายไฟพ่วง" | mkN "ธาตุตะกั่ว" | mkN "ตำแหน่งผู้นำ" | mkN "คะแนนทิ้งห่าง" | mkN "เชือกจูงสุนัข" | mkN "เลขอะตอม 82" | mkN "สายไฟ" | mkN "ตะกั่ว" | mkN "ตัวเอก" | mkN "นางเอก" | mkN "พระเอก" | mkN "ลูกปืน" | mkN "ร่องรอย" | mkN "แบบอย่าง" | mkN "ลูกตะกั่ว" | mkN "สารตะกั่ว" | mkN "หัวเรื่อง" | mkN "ธาตุตะกั่ว" | mkN "หัวข้อข่าว" | mkN "ตําแหน่งนํา" | mkN "สายนําไฟฟ้า" | mkN "เชือกนําทาง" | mkN "ไส้ดินสอดํา" | mkN "การทิ้งไพ่นํา" | mkN "ความเป็นผู้นํา" | mkN "การทิ้งไพ่ใบแรก" | mkN "ข้อมูลที่เป็นประโยชน์ในการค้นหา" | mkN "ระยะห่างระหว่างที่หนึ่งกับที่สอง" ; -- src=panlex
lin farm_N = mkN "ฟาร์ม" | mkN "นา" | mkN "ไร่" | mkN "ทํานา" | mkN "ฟาร์ม" | mkN "ไร่นา" | mkN "ทําไร่" | mkN "ฝากเลี้ยง" | mkN "ที่เพาะปลูกและเลี้ยงสัตว์" ; -- src=panlex
lin respond_VS = mmkVS "ตอบ" ; ---- | mkV "ตอบสนอง" | mkV "ตอบ" | mkV "ตอบรับ" | mkV "พูดตอบ" | mkV "โต้ตอบ" | mkV "ตอบสนอง" ; -- src=panlex
lin respond_V = mkV "ตอบ" | mkV "ตอบสนอง" | mkV "ตอบ" | mkV "ตอบรับ" | mkV "พูดตอบ" | mkV "โต้ตอบ" | mkV "ตอบสนอง" ; -- src=panlex
lin employer_N = mkN "นายจ้าง" | mkN "คนจ้าง" | mkN "นายจ้าง" | mkN "ผู้จ้าง" | mkN "ผู้ว่าจ้าง" ; -- src=panlex
lin carefully_Adv = variants{} ; -- 
lin understanding_N = mkN "ปัญญา" | mkN "เหตุผล" | mkN "ข้อตกลง" | mkN "ความเข้าใจ" | mkN "สัญญา" | mkN "ความเข้าใจ" | mkN "ข้อตกลงร่วมกัน" | mkN "ความสามารถในการเข้าใจ" ; -- src=panlex
lin connection_N = mkN "ตัวเชื่อม" | mkN "การถ่ายโยง" | mkN "การเชื่อมต่อ" | mkN "การเชื่อมโยง" | mkN "คอนเน็กเตอร์" | mkN "ความเชื่อมโยง" | mkN "ผู้จัดหายาเสพย์ติด" | mkN "ญาติ" | mkN "พันธะ" | mkN "การสังวาส" | mkN "การเชื่อมต่อ" | mkN "ความสัมพันธ์" | mkN "การเชื่อมผนึก" | mkN "วงศ์วานวงศ์ญาติมิตร" ; -- src=panlex
lin comment_N = mkN "คำบรรยาย" | mkN "คำอธิบาย" | mkN "ข้อคิดเห็น" | mkN "เรื่องนินทา" | mkN "เรื่องซุบซิบ" | mkN "ข้อคิดเห็น" ; -- src=panlex
lin grant_V3 = variants{} ; -- 
lin grant_V2 = variants{} ; -- 
lin concentrate_V2 = mkV2 "ย่อ" ; ---- | mkV "จดจ่อ" | mkV "โฟกัส" | mkV "ตั้งใจ" | mkV "เคี่ยว" | mkV "รวมศูนย์" | mkV "ตั้งสมาธิ" | mkV "ทำให้น้อยลง" | mkV "ทำให้เข้มข้น" | mkV "มีสมาธิจดจ่อ" | mkV "เพ่งความสนใจ" | mkV "ทําให้เข้มข้นขึ้น" | mkV "ทําให้เพ่งความสนใจ" | mkV "ทําให้ตรงไปยังจุดศูนย์กลาง" ; -- src=panlex
lin concentrate_V = mkV "ย่อ" | mkV "จดจ่อ" | mkV "โฟกัส" | mkV "ตั้งใจ" | mkV "เคี่ยว" | mkV "รวมศูนย์" | mkV "ตั้งสมาธิ" | mkV "ทำให้น้อยลง" | mkV "ทำให้เข้มข้น" | mkV "มีสมาธิจดจ่อ" | mkV "เพ่งความสนใจ" | mkV "ทําให้เข้มข้นขึ้น" | mkV "ทําให้เพ่งความสนใจ" | mkV "ทําให้ตรงไปยังจุดศูนย์กลาง" ; -- src=panlex
lin ignore_V2 = mkV2 "เพิกเฉย" ; ---- | mkV "ตัดออกไป" | mkV "ทำเพิกเฉย" | mkV "มองข้าม" | mkV "ไม่สนใจ" | mkV "ทําละเลย" | mkV "ทําเพิกเฉย" | mkV "ทําไม่รู้ไม่ชี้" ; -- src=panlex
lin ignore_V = mkV "เพิกเฉย" | mkV "ตัดออกไป" | mkV "ทำเพิกเฉย" | mkV "มองข้าม" | mkV "ไม่สนใจ" | mkV "ทําละเลย" | mkV "ทําเพิกเฉย" | mkV "ทําไม่รู้ไม่ชี้" ; -- src=panlex
lin phone_N = mkN "หูฟัง" | mkN "เสียง" | mkN "เฮดโฟน" | mkN "เสียงพูด" | mkN "โทรศัพท์" | mkN "เครื่องโทรศัพท์" | mkN "เสียงพูด" | mkN "ูโทรศัพท์" | mkN "เครื่องรับโทรศัพท์" ; -- src=panlex
lin hole_N = mkN "รู" | mkN "ปาก" | mkN "หลุม" | mkN "โพรง" | mkN "หลุมกอล์ฟ" | mkN "รู" | mkN "ปรุ" | mkN "รอย" | mkN "ช่อง" | mkN "ถ้ํา" | mkN "ร่อง" | mkN "หลุม" | mkN "โพรง" | mkN "ลงหลุม" | mkN "ขุดหลุม" | mkN "จุดอ่อน" | mkN "รอยโหว่" | mkN "ห้องขัง" | mkN "ช่องว่าง" | mkN "เจาะผ่าน" | mkN "ข้อบกพร่อง" | mkN "สถานการณ์ที่เคอะเขิน" | mkN "สถานการณ์ที่น่าอึดอัดใจ" ; -- src=panlex
lin insurance_N = mkN "หลักประกัน" | mkN "การประกันภัย" | mkN "กรมธรรม์ประกันภัย" | mkN "กรมธรรม์" | mkN "การประกัน" | mkN "เบี้ยประกัน" | mkN "การประกันภัย" | mkN "จํานวนเงินที่ประกัน" ; -- src=panlex
lin content_N = mkN "สาระ" | mkN "วัตถุ" | mkN "ความจุ" | mkN "สารัตถะ" | mkN "เนื้อหา" | mkN "คอนเท็นต์" | mkN "ความพึงพอใจ" | mkN "เนื้อเรื่อง" | mkN "สาร" | mkN "พอใจ" | mkN "หัวข้อ" | mkN "เนื้อหา" | mkN "ความหมาย" | mkN "ความสําคัญ" | mkN "ความพึงพอใจ" | mkN "ซึ่งเห็นด้วย" | mkN "ปริมาณความจุ" | mkN "สิ่งที่บรรจุอยู่" | mkN "ความสามารถในการจุ" | mkN "ความหมายที่ต้องการสื่อ" | mkN "จํานวนของสิ่งที่บรรจุอยู่" ; -- src=panlex
lin confidence_N = mkN "ความลับ" | mkN "ความไว้ใจ" | mkN "ความมั่นใจ" | mkN "ความเชื่อมั่น" | mkN "เชื่อมั่นในตัวเอง" | mkN "ความเชื่อมั่นในตนเอง" | mkN "ความเชื่อมั่นในตัวเอง" | mkN "ความมั่นใจ" | mkN "ความเชื่อถือ" | mkN "ความไว้เนื้อเชื่อใจ" | mkN "ความเชื่อมั่นในตัวเอง" | mkN "ความเป็นเพื่อนที่ไว้ใจได้" ; -- src=panlex
lin sample_N = mkN "ตัวอย่าง" | mkN "ของทดลอง" | mkN "ตัวอย่าง" | mkN "ของตัวอย่าง" | mkN "ตัวอย่างทดลอง" | mkN "สินค้าตัวอย่าง" | mkN "ตัวอย่างประชากร" | mkN "ทดลองเป็นตัวอย่าง" | mkN "ตรวจสอบเป็นตัวอย่าง" ; -- src=panlex
lin transport_N = mkN "พาหนะ" | mkN "การขนส่ง" | mkN "ยานพาหนะ" | mkN "การลำเลียง" | mkN "ความปีติยินดี" | mkN "หน่วยขับแถบบันทึก" | mkN "พาหนะ" | mkN "การขนส่ง" | mkN "ความดีใจ" | mkN "ยานพาหนะ" | mkN "บริษัทขนส่ง" | mkN "ความปิติยินดี" ; -- src=panlex
lin objective_N = mkN "เลนส์กล้อง" | mkN "จุดมุ่งหมาย" | mkN "เลนส์ใกล้วัตถุ" | mkN "เป้า" | mkN "เป็นจริง" | mkN "เป้าหมาย" | mkN "ไม่มีอคติ" | mkN "ไม่ลําเอียง" | mkN "วัตถุประสงค์" | mkN "เกี่ยวกับวัตถุ" | mkN "เกี่ยวกับกรรมการ" | mkN "เกี่ยวกับสิ่งของ" | mkN "เกี่ยวกับเป้าหมาย" | mkN "เกี่ยวกับภาวะวิสัย" ; -- src=panlex
lin alone_A = mkA "เพียง" | mkA "ดาย" | mkA "ลําพัง" | mkA "คนเดียว" | mkA "เดียวดาย" | mkA "ตามลําพัง" | mkA "แต่ลําพัง" | mkA "โดดเดี่ยว" | mkA "โดยลําพัง" | mkA "ลําพังตนเอง" | mkA "เพียงลําพัง" | mkA "เปล่าเปลี่ยว" ; -- src=panlex
lin flower_N = mkN (thword "ดอกไม้") "ดอก" | {-pan-} mkN "ดอก" | mkN "มาลี" | mkN "บุปผา" | mkN "ดอกไม้" | mkN "ไม้ดอก" | mkN "ช่วงเวลาออกดอกออกผล" | mkN "ช่วงเวลาที่ออกดอกสะพรั่ง" | mkN "ดอก" | mkN "ปลี" | mkN "บุปผา" | mkN "บุษบา" | mkN "ดอกไม้" | mkN "ไม้ดอก" | mkN "หัวกะทิ" | mkN "พืชดอกไม้" | mkN "ผลิตภัณฑ์ที่ดีที่สุด" | mkN "ระยะที่รุ่งเรืองที่สุด" | mkN "คนหรือสิ่งที่เป็นสุดยอด" | mkN "ช่วงเวลาที่เจริญเติบโตมากที่สุด" | mkN "ระยะที่รุ่งเรืองหรืองดงามที่สุด" ; -- src=panlex
lin injury_N = mkN "การบาดเจ็บ" | mkN "อาการบาดเจ็บ" | mkN "การทำให้บาดเจ็บ" | mkN "การบาดเจ็บจากอุบัติเหตุ" | mkN "ภัย" | mkN "แผล" | mkN "อันตราย" | mkN "การก้าวร้าว" | mkN "ความเสียหาย" | mkN "อาการบาดเจ็บ" | mkN "การล่วงละเมิด" | mkN "ความอยุติธรรมที่ได้รับ" ; -- src=panlex
lin lift_V2 = mkV2 "ชู" ; ---- | mkV "ยก" | mkV "ลัก" | mkV "ขโมย" | mkV "เชิด" | mkV "ยกขึ้น" | mkV "ลบล้าง" | mkV "ดึงหน้า" | mkV "ยกให้สูง" | mkV "ขุดขึ้นมา" | mkV "ขุดหัวมัน" | mkV "ไม่อ้างอิง" | mkV "เคลื่อนขึ้น" | mkV "กวาดทรัพย์สิน" | mkV "ขนส่งทางเครื่องบิน" | mkV "ไม่อ้างอิงแหล่งที่มา" | mkV "ยก" | mkV "ยอ" | mkV "กู้" | mkV "ชูขึ้น" | mkV "ยกขึ้น" | mkV "ยกฐานะ" | mkV "ยกเลิก" | mkV "ยกระดับ" | mkV "ลักขโมย" | mkV "ล้มเลิก" | mkV "เพิกถอน" | mkV "ทําให้ดีใจ" | mkV "เลื่อนฐานะ" | mkV "ทําให้ร่าเริง" | mkV "ทําให้มีความสุข" | mkV "ทําให้กระปรี้กระเปร่า" ; -- src=panlex
lin lift_V = mkV "ชู" | mkV "ยก" | mkV "ลัก" | mkV "ขโมย" | mkV "เชิด" | mkV "ยกขึ้น" | mkV "ลบล้าง" | mkV "ดึงหน้า" | mkV "ยกให้สูง" | mkV "ขุดขึ้นมา" | mkV "ขุดหัวมัน" | mkV "ไม่อ้างอิง" | mkV "เคลื่อนขึ้น" | mkV "กวาดทรัพย์สิน" | mkV "ขนส่งทางเครื่องบิน" | mkV "ไม่อ้างอิงแหล่งที่มา" | mkV "ยก" | mkV "ยอ" | mkV "กู้" | mkV "ชูขึ้น" | mkV "ยกขึ้น" | mkV "ยกฐานะ" | mkV "ยกเลิก" | mkV "ยกระดับ" | mkV "ลักขโมย" | mkV "ล้มเลิก" | mkV "เพิกถอน" | mkV "ทําให้ดีใจ" | mkV "เลื่อนฐานะ" | mkV "ทําให้ร่าเริง" | mkV "ทําให้มีความสุข" | mkV "ทําให้กระปรี้กระเปร่า" ; -- src=panlex
lin stick_V2 = mkV2 "ติด" ; ---- | mkV "แนบ" | mkV "อยู่" | mkV "เสียบ" | mkV "ติดกาว" | mkV "ศรัทธา" | mkV "ติดแน่น" | mkV "ยึดมั่น" | mkV "ติดด้วยกาว" | mkV "ทำให้สับสน" | mkV "ติดด้วยหมุด" | mkV "ยืนเคียงข้าง" | mkV "แทง" ; -- src=panlex
lin stick_V = mkV "ติด" | mkV "แนบ" | mkV "อยู่" | mkV "เสียบ" | mkV "ติดกาว" | mkV "ศรัทธา" | mkV "ติดแน่น" | mkV "ยึดมั่น" | mkV "ติดด้วยกาว" | mkV "ทำให้สับสน" | mkV "ติดด้วยหมุด" | mkV "ยืนเคียงข้าง" | mkV "แทง" ; -- src=panlex
lin front_A = mkA "หน้า" | mkA "หน้า" | mkA "รับมือ" | mkA "ต่อต้าน" | mkA "แถวหน้า" | mkA "ข้างหน้า" | mkA "ด้านหน้า" | mkA "เผชิญหน้า" | mkA "เบื้องหน้า" ; -- src=panlex
lin mainly_Adv = mkAdv "ส่วนใหญ่" | mkAdv "เป็นหลัก" | mkAdv "ส่วนมาก" | mkAdv "ส่วนใหญ่" | mkAdv "โดยทั่วไป" | mkAdv "โดยส่วนใหญ่" ; -- src=panlex
lin battle_N = mkN "การรบ" | mkN "การสู้รบ" | mkN "การต่อสู้" | mkN "ความขัดแย้ง" | mkN "ความมุ่งมั่นฟันฝ่า" | mkN "ผจญ" | mkN "ศึก" | mkN "การรบ" | mkN "ต่อสู้" | mkN "สงคราม" | mkN "ยุทธการ" | mkN "การสู้รบ" | mkN "การแข่งขัน" | mkN "การประจัญบาน" | mkN "การต่อสู้ดิ้นรน" ; -- src=panlex
lin generation_N = mkN "ชั่วรุ่น" | mkN "การอุบัติ" | mkN "เจเนเรชั่น" | mkN "ปูน" | mkN "ยุค" | mkN "รุ่น" | mkN "สมัย" | mkN "ชั่วคน" | mkN "ชั่วอายุ" | mkN "ชั้นอายุ" | mkN "รุ่นอายุ" | mkN "การกําเนิด" | mkN "การก่อให้เกิด" | mkN "การแพร่พันธุ์" | mkN "คนรุ่นเดียวกัน" | mkN "คนรุ่นราวคราวเดียวกัน" ; -- src=panlex
lin currently_Adv = variants{} ; -- 
lin winter_N = mkN "ฤดูหนาว" | mkN "หน้าหนาว" | mkN "ฤดูหนาว" | mkN "เหมันต์" | mkN "หน้าหนาว" ; -- src=panlex
lin inside_Prep = mkPrep "ภายใน" | mkPrep "ในร่ม" | mkPrep "ข้างใน" | mkPrep "ด้านใน" | mkPrep "เครื่องใน" | mkPrep "ลักษณะภายใน" ; -- src=panlex
lin impossible_A = mkA "เป็นไปไม่ได้" | mkA "ทําไม่ได้" | mkA "ซึ่งไม่มีทาง" | mkA "เป็นไปไม่ได้" | mkA "ซึ่งเป็นไปไม่ได้" | mkA "ซึ่งไม่น่าจะเกิดขึ้น" | mkA "ไม่มีทางจะบังเกิดขึ้น" ; -- src=panlex
lin somewhere_Adv = mkAdv (thword "บาง" "แห่ง") | {-pan-} mkAdv "บางที่" | mkAdv "บางแห่ง" | mkAdv "โดยประมาณ" | mkAdv "ที่ใดที่หนึ่ง" ; -- src=panlex
lin arrange_V2 = mkV2 "จัด" ; ---- | mkV "ทำผม" | mkV "ลำดับ" | mkV "เซตผม" | mkV "แต่งผม" | mkV "ฟอร์แมต" | mkV "เซ็ตอัป" | mkV "จัดรูปแบบ" | mkV "จัดเตรียม" | mkV "เรียงร้อย" | mkV "จัดฟอร์แมต" | mkV "เรียบเรียง" | mkV "จัดเป็นระบบ" | mkV "ลำดับเรื่อง" | mkV "ลำดับความคิด" | mkV "จัดให้เป็นระบบ" | mkV "เรียบเรียงดนตรี" | mkV "จัดให้เป็นระเบียบ" | mkV "จัดเตรียม" | mkV "เตรียมการ" ; -- src=panlex
lin arrange_V = mkV "จัด" | mkV "ทำผม" | mkV "ลำดับ" | mkV "เซตผม" | mkV "แต่งผม" | mkV "ฟอร์แมต" | mkV "เซ็ตอัป" | mkV "จัดรูปแบบ" | mkV "จัดเตรียม" | mkV "เรียงร้อย" | mkV "จัดฟอร์แมต" | mkV "เรียบเรียง" | mkV "จัดเป็นระบบ" | mkV "ลำดับเรื่อง" | mkV "ลำดับความคิด" | mkV "จัดให้เป็นระบบ" | mkV "เรียบเรียงดนตรี" | mkV "จัดให้เป็นระเบียบ" | mkV "จัดเตรียม" | mkV "เตรียมการ" ; -- src=panlex
lin will_N = mkN "เจตจำนง" | mkN "เจตนารมณ์" | mkN "การตัดสินใจ" | mkN "ปณิธาน" | mkN "พินัยกรรม" | mkN "ความตั้งใจ" | mkN "จุดประสงค์" | mkN "ความต้องการ" | mkN "ความปรารถนา" | mkN "คําสั่งเสีย" | mkN "ความมุ่งมั่น" ; -- src=panlex
lin sleep_V = mkV "นอน" "หลับ" | {-pan-} mkV "นอน" | mkV "หลับ" | mkV "บรรทม" | mkV "นอนหลับ" | mkV "นอน" | mkV "หลับ" | mkV "ไสยา" | mkV "นิทรา" | mkV "บรรทม" | mkV "ซึมเซา" | mkV "ง่วงซึม" | mkV "ไม่กระฉับกระเฉง" ; -- src=panlex
lin progress_N = mkN "ความเจริญ" | mkN "การเดินหน้า" | mkN "ความก้าวหน้า" | mkN "การก้าวไปข้างหน้า" | mkN "การเดินไปข้างหน้า" | mkN "ความเจริญก้าวหน้า" | mkN "การเคลื่อนที่ไปข้างหน้า" ; -- src=panlex
lin volume_N = mkN "สมุด" | mkN "เล่ม" | mkN "ความจุ" | mkN "ความดัง" | mkN "หนังสือ" | mkN "ความใหญ่" | mkN "เสียงดัง" | mkN "เสียงร้อง" | mkN "ฉบับ" | mkN "เล่ม" | mkN "ความจุ" | mkN "ปริมาณ" | mkN "ทั้งหมด" | mkN "ปริมาตร" | mkN "จํานวนมาก" | mkN "ระดับเสียง" | mkN "ชุดแผ่นเสียง" | mkN "ความดังของเสียง" | mkN "ระดับความดังของเสียง" | mkN "หนังสือเล่มหนึ่งในชุดหนังสือ" ; -- src=panlex
lin ship_N = mkN "เรือ" | {-pan-} mkN "เรือขนส่ง" | mkN "นาวา" | mkN "สำเภา" | mkN "ยานอวกาศ" | mkN "เครื่องบิน" | mkN "เรือขนาดใหญ่" ; -- src=panlex ----?
lin legislation_N = mkN "การตรากฎหมาย" | mkN "กฎหมาย" | mkN "ตัวบทกฎหมาย" | mkN "นิติบัญญัติ" | mkN "การออกกฎหมาย" | mkN "การบัญญัติกฎหมาย" | mkN "การออกพระราชบัญญัติ" ; -- src=panlex
lin commitment_N = mkN "คำอุทิศ" | mkN "ความภักดี" | mkN "พันธะสัญญา" | mkN "ความซื่อสัตย์" | mkN "การส่งตัวไปจองจำ" | mkN "การมอบ" | mkN "การมอบหมาย" | mkN "ความรับผิดชอบ" ; -- src=panlex
lin enough_Predet = variants{} ; -- 
lin conflict_N = mkN "การรบ" | mkN "การสู้รบ" | mkN "การต่อสู้" | mkN "การอภิปราย" | mkN "ความขัดแย้ง" | mkN "ต่อสู้" | mkN "ทะเลาะ" | mkN "สงคราม" | mkN "การต่อสู้" | mkN "การทะเลาะ" | mkN "การขัดแย้ง" | mkN "ความขัดแย้ง" | mkN "การเป็นปรปักษ์" ; -- src=panlex
lin bag_N = mkN "ถุง" | mkN "เบส" | mkN "กระเป๋า" | mkN "งานสบาย" | mkN "ต่อมน้ำนม" | mkN "กระเป๋าถือ" | mkN "กระเป๋าถือสตรี" | mkN "กระเป๋าเดินทาง" | mkN "หญิงอารมณ์ร้าย" | mkN "ต่อมน้ำนมของสัตว์" | mkN "ฐาน" | mkN "ถุง" | mkN "ย่าม" | mkN "กระเป๋าถือ" | mkN "ความร่ํารวย" | mkN "ความล่ําซํา" | mkN "ความมั่งคั่ง" | mkN "หญิงไร้เสน่ห์" | mkN "กระเป๋าถือสตรี" | mkN "ผู้หญิงที่ไม่มีเสน่ห์" | mkN "จํานวนสิ่งของที่กระเป๋าสามารถจะบรรจุได้" ; -- src=panlex
lin fresh_A = mkA "สด" | mkA "จืด" | mkA "ใหม่" | mkA "สะอาด" | mkA "สดชื่น" | mkA "สดใหม่" | mkA "ที่ให้นมได้" | mkA "ที่ยังไม่ใช้" | mkA "ซึ่งรู้สึกสดชื่น" | mkA "สด" | mkA "จืด" | mkA "สดใส" | mkA "ใหม่" | mkA "สดชื่น" | mkA "สีไม่ตก" | mkA "เมื่อเร็ว ๆ นี้" | mkA "มีชีวิตชีวา" | mkA "ไม่มีมารยาท" | mkA "ไม่ใส่เกลือ" | mkA "กระชุ่มกระชวย" | mkA "ไม่มีประสบการณ์" ; -- src=panlex
lin entry_N = variants{} ; -- 
lin entry_2_N = variants{} ; -- 
lin entry_1_N = variants{} ; -- 
lin smile_N = mkN "ยิ้ม" | mkN "รอยยิ้ม" | mkN "รอยยิ้ม" ; -- src=panlex
lin fair_A = mkA "แฟร์" | mkA "สะอาด" | mkA "ปานกลาง" | mkA "ยุติธรรม" | mkA "ซึ่งไม่มีรอยแก้" | mkA "งาม" | mkA "ซีด" | mkA "มาก" | mkA "สภาพ" | mkA "สะอาด" | mkA "สุภาพ" | mkA "ชัดเจน" | mkA "สวยงาม" | mkA "สีอ่อน" | mkA "กระจ่าง" | mkA "ดีพอใช้" | mkA "ถูกต้อง" | mkA "ปานกลาง" | mkA "อ่อนโยน" | mkA "มีมารยาท" | mkA "มีเสน่ห์" | mkA "ยุติธรรม" | mkA "สีขาวซีด" | mkA "อ่อนหวาน" | mkA "เป็นธรรม" | mkA "ซื่อสัตย์" | mkA "เที่ยงตรง" | mkA "เท่าเทียม" | mkA "ไม่มีพายุ" | mkA "ไม่มีอคติ" | mkA "ค่อนข้างดี" | mkA "มากพอสมควร" | mkA "สมเหตุสมผล" | mkA "มากพอประมาณ" | mkA "มีผิวพรรณดี" | mkA "ใหญ่พอสมควร" | mkA "ไม่มีตําหนิ" | mkA "ของสีผิวหรือสีผม" | mkA "ไม่มีจุดด่างพร้อย" | mkA "เกี่ยวกับทัศนวิสัยที่ดี" ; -- src=panlex
lin promise_VV = mkVV "ทาย" ; ---- | mkV "ทำนาย" | mkV "สัญญา" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "สัญญา" | mkV "ยืนยัน" | mkV "รับปาก" | mkV "ให้คํามั่น" | mkV "ทําให้มั่นใจ" ; -- src=panlex
lin promise_VS = mmkVS "ทาย" ; ---- | mkV "ทำนาย" | mkV "สัญญา" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "สัญญา" | mkV "ยืนยัน" | mkV "รับปาก" | mkV "ให้คํามั่น" | mkV "ทําให้มั่นใจ" ; -- src=panlex
lin promise_V2 = mkV2 "ทาย" ; ---- | mkV "ทำนาย" | mkV "สัญญา" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "สัญญา" | mkV "ยืนยัน" | mkV "รับปาก" | mkV "ให้คํามั่น" | mkV "ทําให้มั่นใจ" ; -- src=panlex
lin promise_V = mkV "ทาย" | mkV "ทำนาย" | mkV "สัญญา" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "สัญญา" | mkV "ยืนยัน" | mkV "รับปาก" | mkV "ให้คํามั่น" | mkV "ทําให้มั่นใจ" ; -- src=panlex
lin introduction_N = mkN "การสอด" | mkN "การแนะนำ" | mkN "การก่อตั้ง" | mkN "การเริ่มต้น" | mkN "ตำราพื้นฐาน" | mkN "ตำราเรียนพื้นฐาน" | mkN "ตำราเรียนเบื้องต้น" | mkN "หนังสือเรียนพื้นฐาน" | mkN "หนังสือเรียนเบื้องต้น" | mkN "บทนํา" | mkN "คํานํา" | mkN "การเริ่ม" | mkN "อารัมภบท" | mkN "การแนะนํา" | mkN "การนําเข้า" | mkN "การริเริ่ม" | mkN "การอรัมภบท" | mkN "การเผยแพร่" | mkN "การเริ่มต้น" | mkN "การแนะนําตัว" | mkN "สิ่งที่ถูกนําเข้า" ; -- src=panlex
lin senior_A = mkA "อาวุโส" | mkA "ก่อน" | mkA "อาวุโส" | mkA "อายุมาก" | mkA "ผู้มีอายุ สูงกว่า" | mkA "ซึ่งเป็นรุ่นพี่" | mkA "ซึ่งมีอายุมากกว่า" | mkA "นักเรียนหรือนักศึกษาในปีสุดท้าย" | mkA "เกี่ยวกับนักศึกษาในสองปีสุดท้าย" ; -- src=panlex
lin manner_N = mkN "แนว" | mkN "แบบ" | mkN "ท่าทาง" | mkN "แบบอย่าง" | mkN "แบบ" | mkN "ชนิด" | mkN "อย่าง" | mkN "กิริยา" | mkN "จําพวก" | mkN "ประเภท" | mkN "มารยาท" | mkN "รูปแบบ" | mkN "ลักษณะ" | mkN "วิธีการ" | mkN "วิธีกระทํา" | mkN "กิริยาท่าทาง" | mkN "ลักษณะท่าทาง" | mkN "วิธีการกระทํา" ; -- src=panlex
lin background_N = mkN "ฉากหลัง" | mkN "เดสก์ทอป" | mkN "แบ็คกราวด์" | mkN "พื้นความรู้" | mkN "ภาพพื้นหลัง" | mkN "ข้อมูลพื้นฐาน" | mkN "พื้น" | mkN "ม่าน" | mkN "พื้นเพ" | mkN "ฉากหลัง" | mkN "ประวัติ" | mkN "หลังฉาก" | mkN "ภูมิหลัง" | mkN "ถิ่นที่มา" | mkN "ความเป็นมา" | mkN "เบื้องหลัง" | mkN "พื้นหลังภาพ" | mkN "ส่วนที่อยู่ข้างหลัง" | mkN "เบื้องหน้าเบื้องหลัง" ; -- src=panlex
lin key_N = variants{} ; -- 
lin key_2_N = variants{} ; -- 
lin key_1_N = variants{} ; -- 
lin touch_V2 = mkV2 "จับ" ; ---- | mkV "ชิด" | mkV "ติด" | mkV "แตะ" | mkV "มีผล" | mkV "ยุ่ง" | mkV "ส่งผล" | mkV "ไปถึง" | mkV "พอๆกับ" | mkV "พาดพิง" | mkV "สัมผัส" | mkV "กระทบใจ" | mkV "ซาบซึ้ง" | mkV "ดื่มด่ำ" | mkV "เข้าถึง" | mkV "มีผลกระทบ" | mkV "รับประทาน" | mkV "สัมผัสถึง" | mkV "เทียบเท่า" | mkV "เป็นสีจาง" | mkV "ส่งผลกระทบ" | mkV "เกี่ยวข้อง" | mkV "เทียบเทียม" | mkV "ทำให้สัมผัส" | mkV "ระบายสีอ่อนๆ" | mkV "จับ" | mkV "แตะ" | mkV "กดเบาๆ" | mkV "สัมผัส" | mkV "มีผลกระทบ" | mkV "มีอิทธิพล" | mkV "เกี่ยวพัน" | mkV "เกี่ยวข้อง" | mkV "ใช้หรือกิน" | mkV "เกี่ยวข้องด้วย" | mkV "นําสิ่งของมาให้สัมผัสกัน" ; -- src=panlex
lin touch_V = mkV "จับ" | mkV "ชิด" | mkV "ติด" | mkV "แตะ" | mkV "มีผล" | mkV "ยุ่ง" | mkV "ส่งผล" | mkV "ไปถึง" | mkV "พอๆกับ" | mkV "พาดพิง" | mkV "สัมผัส" | mkV "กระทบใจ" | mkV "ซาบซึ้ง" | mkV "ดื่มด่ำ" | mkV "เข้าถึง" | mkV "มีผลกระทบ" | mkV "รับประทาน" | mkV "สัมผัสถึง" | mkV "เทียบเท่า" | mkV "เป็นสีจาง" | mkV "ส่งผลกระทบ" | mkV "เกี่ยวข้อง" | mkV "เทียบเทียม" | mkV "ทำให้สัมผัส" | mkV "ระบายสีอ่อนๆ" | mkV "จับ" | mkV "แตะ" | mkV "กดเบาๆ" | mkV "สัมผัส" | mkV "มีผลกระทบ" | mkV "มีอิทธิพล" | mkV "เกี่ยวพัน" | mkV "เกี่ยวข้อง" | mkV "ใช้หรือกิน" | mkV "เกี่ยวข้องด้วย" | mkV "นําสิ่งของมาให้สัมผัสกัน" ; -- src=panlex
lin vary_V2 = mkV2 "มีหลากหลาย" ; ---- | mkV "เปลี่ยนแปลง" | mkV "ทำให้หลากหลาย" | mkV "ออกนอกเส้นทาง" | mkV "ผันแปร" | mkV "ปรวนแปร" | mkV "แตกต่าง" | mkV "แปรปรวน" | mkV "เปลี่ยนแปลง" | mkV "ทําให้แตกต่าง" | mkV "ทําให้แปรปรวน" | mkV "ทําให้หลากหลาย" ; -- src=panlex
lin vary_V = mkV "มีหลากหลาย" | mkV "เปลี่ยนแปลง" | mkV "ทำให้หลากหลาย" | mkV "ออกนอกเส้นทาง" | mkV "ผันแปร" | mkV "ปรวนแปร" | mkV "แตกต่าง" | mkV "แปรปรวน" | mkV "เปลี่ยนแปลง" | mkV "ทําให้แตกต่าง" | mkV "ทําให้แปรปรวน" | mkV "ทําให้หลากหลาย" ; -- src=panlex
lin sexual_A = mkA "ทางเพศ" | mkA "แบบอาศัยเพศ" | mkA "มีอวัยวะเพศ" | mkA "เกี่ยวกับเพศ" | mkA "เกี่ยวกับเพศชายและเพศหญิง" | mkA "เกิดขึ้นระหว่างเพศชายกับเพศหญิง" ; -- src=panlex
lin ordinary_A = mkA "ปกติ" | mkA "พื้น ๆ" | mkA "พื้นๆ" | mkA "สามัญ" | mkA "ธรรมดา" | mkA "เรียบๆ" | mkA "ไม่เด่น" | mkA "ไม่น่าสนใจ" | mkA "สิ่งที่ปกติ" | mkA "ต่ํากว่าถัวเฉลี่ย" ; -- src=panlex
lin cabinet_N = mkN "ตู้" | mkN "ครม." | mkN "ตู้เก็บของ" | mkN "คณะรัฐมนตรี" | mkN "ตู้เสื้อผ้า" | mkN "ตู้โทรทัศน์" | mkN "ตู้" | mkN "ห้องเล็ก" | mkN "โทรทัศน์" | mkN "คณะรัฐมนตรี" | mkN "ตู้มีลิ้นชัก" | mkN "ชั้นหรือตู้วางของ" | mkN "เกี่ยวกับห้องส่วนตัว" | mkN "ตู้เฟอร์นิเจอร์ที่มีชั้นวางวิทยุ" ; -- src=panlex
lin painting_N = mkN "ภาพวาด" | mkN "รูปภาพ" | mkN "รูปวาด" | mkN "การระบาย" | mkN "จิตรกรรม" | mkN "ภาพเขียน" | mkN "การระบายสี" | mkN "การทาสีบ้าน" | mkN "ภาพจิตรกรรม" | mkN "ภาพวาด" | mkN "การทาสี" | mkN "งานทาสี" | mkN "การวาดภาพสี" | mkN "การทาสีบ้านหรืออาคาร" ; -- src=panlex
lin entirely_Adv = variants{} ; -- 
lin engine_N = mkN "หัวรถจักร" | mkN "เครื่องจักร" | mkN "เครื่องยนต์" | mkN "รถจักร" | mkN "หัวรถจักร" | mkN "เครื่องกล" | mkN "รถดับเพลิง" | mkN "เครื่องจักร" | mkN "เครื่องยนต์" | mkN "เครื่องทรมาน" | mkN "เครื่องจักรกล" | mkN "เครื่องดับเพลิง" | mkN "เครื่องยนต์กลไก" ; -- src=panlex
lin previously_Adv = variants{} ; -- 
lin administration_N = mkN "ผู้ก่อตั้ง" | mkN "การให้การรักษา" | mkN "การบริหารรัฐกิจ" | mkN "การบริหารงานตุลาการ" | mkN "วาระการดำรงตำแหน่งของประธานาธิบดี" | mkN "การจัดการ" | mkN "การบริหาร" | mkN "คณะจัดการ" | mkN "คณะบริหาร" | mkN "การบริหารรัฐกิจ" | mkN "เจ้าหน้าที่บริหารของรัฐ" ; -- src=panlex
lin tonight_Adv = mkAdv "คืนนี้" | mkAdv "ในคืนนี้" | mkAdv "ในคืนวันนี้" ; -- src=panlex
lin adult_N = mkN "ผู้ใหญ่" | mkN "สัตว์ที่เจริญพันธุ์เต็มที่" | mkN "โตแล้ว" | mkN "ผู้ใหญ่" | mkN "เป็นรูปเป็นร่าง" | mkN "ผู้ที่บรรลุนิติภาวะ" | mkN "คนที่เป็นผู้ใหญ่แล้ว" | mkN "คนหรือสัตว์ที่โตเต็มวัย" ; -- src=panlex
lin prefer_VV = variants{} ; -- 
lin prefer_V2 = variants{} ; -- 
lin author_N = mkN "ผู้รจนา" | mkN "ผู้แต่ง" | mkN "นักเขียน" | mkN "ผู้ริเริ่ม" | mkN "นักประพันธ์" | mkN "ผู้แต่งหนังสือ" | mkN "ผู้มีความคิดริเริ่ม" | mkN "ผู้แต่ง" | mkN "นักเขียน" | mkN "ผู้สร้าง" | mkN "ผู้เขียน" | mkN "นักประพันธ์" | mkN "ผู้คิดสร้าง" | mkN "ผู้ประพันธ์" | mkN "ผลงานประพันธ์" ; -- src=panlex
lin actual_A = mkA "แท้" | mkA "จริง" | mkA "แท้ๆ" | mkA "จริง สภาพปัจจุบัน" | mkA "แท้จริง" | mkA "ตามความเป็นจริง" | mkA "ที่เป็นตามความจริง" | mkA "ซึ่งมีอยู่ในเวลานี้" | mkA "ซึ่งเป็นอยู่ปัจจุบัน" | mkA "ซึ่งเป็นอยู่ในขณะนี้" ; -- src=panlex
lin song_N = mkN "เพลง" | {-pan-} mkN "บทเพลง" | mkN "การร้องเพลง" | mkN "เสียงนกร้อง" | mkN "สินค้าราคารวมต่ำสุด" | mkN "คีตะ คีตา" | mkN "บทกวี" | mkN "บทเพลง" | mkN "สิ่งที่ร้อง" | mkN "ดนตรีขับร้อง" | mkN "เสียงเพรียกร้องของนก แมลงหรืออื่น ๆ" ; -- src=panlex ----?
lin investigation_N = mkN "การสอบสวน" | mkN "การสืบสวน" | mkN "การสํารวจ" | mkN "การไต่สวน" | mkN "การไตร่สวน" | mkN "การตรวจสอบหาความจริง" | mkN "การตรวจสอบข้อเท็จจริง" ; -- src=panlex
lin debt_N = mkN "หนี้" | mkN "หนี้สิน" | mkN "การติดหนี้" | mkN "การเป็นหนี้" | mkN "การมีหนี้สิน" | mkN "หนี้" | mkN "หนี้สิน" | mkN "ความมีหนี้" | mkN "การเป็นหนี้" | mkN "ภาวะลูกหนี้" | mkN "จํานวนหนี้สิน" | mkN "ภาวะที่เป็นหนี้" ; -- src=panlex
lin visitor_N = mkN "อาคันตุกะ" | mkN "ผู้มาเยือน" | mkN "ผู้มาเยี่ยม" | mkN "แขก" | mkN "ผู้มาเยือน" | mkN "ผู้มาเยี่ยม" | mkN "ผู้เยี่ยมเยียน" | mkN "ผู้เยี่ยมเยือน" ; -- src=panlex
lin forest_N = placeN (thword "ป่า") | {-pan-} mkN "ป่า" | mkN "ป่าดง" | mkN "พงไพร" | mkN "ป่าไม้" | mkN "พนาลัย" | mkN "วนาลัย" | mkN "ป่าดงพงพี" | mkN "ดง" | mkN "พง" | mkN "ป่า" | mkN "ไพร" | mkN "ป่าดง" | mkN "พนาลี" | mkN "วนาลี" | mkN "ป่าไม้" | mkN "ต้นไม้ที่เป็นป่า" ; -- src=panlex
lin repeat_VS = mmkVS "ย้ำ" ; ---- | mkV "กำชับ" | mkV "ทำซ้ำ" | mkV "พูดซ้ำ" | mkV "เกิดซ้ำ" | mkV "กล่าวย้ำ" | mkV "กำชับกำชา" | mkV "ซ้ํา" | mkV "ทําซ้ํา" | mkV "พูดซ้ํา" | mkV "เกิดซ้ํา" | mkV "กล่าวซ้ํา" ; -- src=panlex
lin repeat_V2 = mkV2 "ย้ำ" ; ---- | mkV "กำชับ" | mkV "ทำซ้ำ" | mkV "พูดซ้ำ" | mkV "เกิดซ้ำ" | mkV "กล่าวย้ำ" | mkV "กำชับกำชา" | mkV "ซ้ํา" | mkV "ทําซ้ํา" | mkV "พูดซ้ํา" | mkV "เกิดซ้ํา" | mkV "กล่าวซ้ํา" ; -- src=panlex
lin repeat_V = mkV "ย้ำ" | mkV "กำชับ" | mkV "ทำซ้ำ" | mkV "พูดซ้ำ" | mkV "เกิดซ้ำ" | mkV "กล่าวย้ำ" | mkV "กำชับกำชา" | mkV "ซ้ํา" | mkV "ทําซ้ํา" | mkV "พูดซ้ํา" | mkV "เกิดซ้ํา" | mkV "กล่าวซ้ํา" ; -- src=panlex
lin wood_N = mkN "ไม้" | {-pan-} mkN "ป่า" | mkN "ป่าไม้" | mkN "หัวไม้" | mkN "เนื้อไม้" | mkN "เครื่องลมไม้" | mkN "เครื่องเป่าลมไม้" | mkN "ป่าไม้" | mkN "เนื้อไม้" | mkN "พื้นที่ป่า" | mkN "ไม้ตีกอล์ฟชนิดหัวไม้" ; -- src=panlex ----?
lin contrast_N = mkN "การตัดกัน" | mkN "ความแตกต่าง" | mkN "การกำหนดกรอบความคิด" | mkN "ระดับความสว่างของภาพ" | mkN "ข้อแตกต่าง" | mkN "ความแตกต่าง" | mkN "ข้อเปรียบเทียบ" | mkN "ความตรงกันข้าม" | mkN "สิ่งที่ต่างกันอย่างสิ้นเชิง" | mkN "ความแตกต่างระหว่างความสว่างและความมืด" ; -- src=panlex
lin extremely_Adv = variants{} ; -- 
lin wage_N = mkN "ค่าแรง" | mkN "ค่าจ้าง" | mkN "ค่าแรง" | mkN "ดิ้นรน" | mkN "ค่าจ้าง" | mkN "ว่าจ้าง" | mkN "ค่าตอบแทน" | mkN "เงินเดือน" ; -- src=panlex
lin domestic_A = mkA "ภายใน" | mkA "ภายในประเทศ" | mkA "ที่ผลิตภายในประุเทศ" | mkA "เชื่อง" | mkA "พื้นบ้าน" | mkA "ภายในประเทศ" | mkA "เกี่ยวกับบ้าน" | mkA "เกี่ยวกับครอบครัว" | mkA "เกี่ยวกับท้องถิ่น" | mkA "เกี่ยวกับครอบครัว ในบ้าน" | mkA "เกี่ยวกับประเทศของตน" | mkA "ซึ่งพบในหรือผลิตภายในประเทศ" ; -- src=panlex
lin commit_V2 = variants{} ; -- 
lin threat_N = mkN "ภัยคุกคาม" | mkN "คุกคาม" | mkN "ขู่เข็ญ" | mkN "ลางร้าย" | mkN "เตือนภัย" | mkN "การคุกคาม" | mkN "การขู่เข็ญ" | mkN "ลางเตือนภัย" | mkN "เป็นลางร้าย" ; -- src=panlex
lin bus_N = mkN "ซากรถ" | mkN "รถบัส" | mkN "รถเก่า" | mkN "รถเมล์" | mkN "รถประจำทาง" | mkN "สะพานไฟฟ้า" | mkN "บัสโทโพโลจี" | mkN "สายไฟฟ้าใหญ่" | mkN "รถโดยสารสาธารณะ" | mkN "รถโดยสารประจำทาง" | mkN "รถบัส" | mkN "รถเมล์" | mkN "รถโดยสารประจําทาง" ; -- src=panlex
lin warm_A = mkA (thword "อุ่น") | {-pan-} mkA "อุ่น" | mkA "อบอุ่น" | mkA "สด" | mkA "ร้อน" | mkA "อุ่น" | mkA "คึกคัก" | mkA "อบอุ่น" | mkA "อบอุ่นสบาย" | mkA "ที่เป็นมิตร" | mkA "มีชีวิตชีวา" | mkA "มีมิตรไมตรี" | mkA "มีอารมณ์รัก" | mkA "ที่ทําให้อุ่น" | mkA "ที่มีไมตรีจิต" | mkA "ที่โกรธได้ง่าย" | mkA "ที่เกือบจะตอบถูก" | mkA "ที่อารมณ์เสียง่าย" | mkA "ที่มีความกระตือรือร้น" | mkA "ที่ป้องกันความหนาวเย็น" | mkA "ที่เต็มไปด้วยอารมณ์รุนแรง" ; -- src=panlex
lin sir_N = mkN "เซอร์" | mkN "คุณ" | mkN "ท่าน" | mkN "คุณใต้เท้า" | mkN "คําสุภาพสําหรับเรียกผู้ชาย" | mkN "คําสุภาพสําหรับเรียกครูอาจารย์ผู้ชาย" ; -- src=panlex
lin regulation_N = mkN "กฎ" | mkN "ระเบียบ" | mkN "กฎระเบียบ" | mkN "ระเบียบข้อบังคับ" | mkN "กฎ" | mkN "ระบบ" | mkN "ธรรมดา" | mkN "กฎเกณฑ์" | mkN "การดูแล" | mkN "การปรับ" | mkN "ระเบียบ" | mkN "การควบคุม" | mkN "ข้อบังคับ" | mkN "เป็นประจํา" | mkN "กฎข้อบังคับ" | mkN "เป็นกิจวัตร" | mkN "การวางข้อกําหนด" | mkN "การกําหนดกฏเกณฑ์" ; -- src=panlex
lin drink_N = mkN "การกิน" | mkN "การกลืน" | mkN "การดื่ม" | mkN "เครื่องดื่ม" | mkN "การดื่มเกินขนาด" | mkN "การดื่มแอลกอฮอล์เกินขนาด" | mkN "เครื่องดื่ม" | mkN "การดื่มเหล้า" | mkN "เครื่่องดื่ม" | mkN "การบริการเครื่องดื่ม" ; -- src=panlex
lin relief_N = mkN "ตัวสำรอง" | mkN "การบรรเทา" | mkN "สแตนด์อิน" | mkN "ตัวแสดงแทน" | mkN "เวลาหยุดพัก" | mkN "การช่วยเหลือ" | mkN "การบรรเทาทุกข์" | mkN "ภาพนูน" | mkN "ความเด่น" | mkN "ความบรรเทา" | mkN "ความโล่งอก" | mkN "การปลดปล่อย" | mkN "การผ่อนคลาย" | mkN "การช่วยเหลือ" | mkN "การสงเคราะห์" | mkN "ความผ่อนคลาย" | mkN "การปลดเปลื้อง" | mkN "การเปลี่ยนเวร" | mkN "เงินช่วยเหลือ" | mkN "การบรรเทาทุกข์" | mkN "ภาพนั้นแกะสลัก" | mkN "การเปลี่ยนอารมณ์" | mkN "สิ่งที่เปลี่ยนอารมณ์" | mkN "ความไม่เสมอกันของระดับพื้นดิน" ; -- src=panlex
lin internal_A = mkA "ในบ้าน" | mkA "ภายในชาติ" | mkA "ภายในประเทศ" | mkA "ในบ้านเมือง" | mkA "ภายใน" | mkA "เครื่องใน" | mkA "ซึ่งมีอยู่ภายใน" ; -- src=panlex
lin strange_A = mkA "ไม่ธรรมดา" | mkA "แปลก" | mkA "ผิดตา" | mkA "ประหลาด" | mkA "ผิดแปลก" | mkA "ต่างด้าว" | mkA "ต่างถิ่น" | mkA "แปลกถิ่น" | mkA "แปลกหน้า" | mkA "คาดไม่ถึง" | mkA "ผิดธรรมดา" | mkA "ไม่รู้จัก" | mkA "ไม่เคยชิน" | mkA "ต่างประเทศ" | mkA "ไม่คุ้นเคย" ; -- src=panlex
lin excellent_A = mkA "เป็นเลิศ" | mkA "ชั้นเฟิร์ตคลาส" | mkA "ดีงาม" | mkA "ดียิ่ง" | mkA "ดีเด่น" | mkA "ดีเลิศ" | mkA "ดีเยี่ยม" | mkA "เป็นเลิศ" | mkA "ยอดเยี่ยม" | mkA "เยี่ยมยอด" ; -- src=panlex
lin run_N = mkN "รัน" | mkN "ลำธาร" | mkN "การวิ่ง" | mkN "การไหลออก" | mkN "การวิ่งแข่ง" | mkN "การแข่งวิ่ง" | mkN "การแข่งขันวิ่ง" | mkN "การรณรงค์หาเสียง" | mkN "การแข่งขันหาเสียง" | mkN "การสู้ศึกเลือกตั้ง" | mkN "เสรีภาพที่ไม่จำกัด" | mkN "แผนการบุกด้วยการวิ่ง" | mkN "การแข่งขันหาเสียงเลือกตั้ง" | mkN "ช่วงเวลาที่เครื่องจักรทำงาน" | mkN "การวิ่ง" | mkN "ระยะทาง" | mkN "ระยะเวลา" | mkN "การเดินทาง" | mkN "การวิ่งแข่ง" | mkN "คอกล้อมสัตว์" | mkN "ความต่อเนื่อง" ; -- src=panlex
lin fairly_Adv = mkAdv "พอควร" | mkAdv "พอใช้" | mkAdv "พอประมาณ" | mkAdv "อย่างพอใช้" | mkAdv "อย่างปานกลาง" | mkAdv "อย่างพอประมาณ" | mkAdv "อย่างยุติธรรม" | mkAdv "อย่างบริสุทธิ์ยุติธรรม" | mkAdv "พอควร" | mkAdv "พอใช้" | mkAdv "พอใช้ได้" | mkAdv "อย่างพอสมควร" | mkAdv "อย่างยุติธรรม" | mkAdv "อย่างเท่าเทียม" | mkAdv "อย่างสมเหตุสมผล" ; -- src=panlex
lin technical_A = mkA "ทางเทคโนโลยี" | mkA "ทางทฤษฎี" | mkA "ทางเทคนิค" | mkA "เฉพาะวิชา" | mkA "ตามหลักวิชา" | mkA "เฉพาะเรื่อง" | mkA "เกี่ยวกับศิลปะ" | mkA "เกี่ยวกับกลวิธี" | mkA "เกี่ยวกับเทคนิค" | mkA "เกี่ยวกับวิชาช่าง" | mkA "เกี่ยวกับวิชาเทคนิค" | mkA "เชี่ยวชาญเฉพาะอย่าง" | mkA "ที่เชี่ยวชาญเฉพาะอย่าง" | mkA "ที่เชี่ยวชาญเฉพาะเรื่อง" | mkA "เกี่ยวกับวิชาเฉพาะอย่าง" | mkA "เกี่ยวกับวิชาการเฉพาะเรื่อง" ; -- src=panlex
lin tradition_N = mkN "ธรรมเนียม" | mkN "จารีต" | mkN "ประเพณี" | mkN "วัฒนธรรม" | mkN "ธรรมเนียม" | mkN "" | mkN "ขนบธรรมเนียม" | mkN "ขนบธรรมเนียมประเพณี" | mkN "สิ่งที่ทําสืบต่อกันมา" ; -- src=panlex
lin measure_V2 = mkV2 "วัด" ; ---- | mkV "ตีราคา" | mkV "มีมิติ" | mkV "วัดปริมาณ" | mkV "ประเมินค่า" | mkV "วัด" | mkV "หาค่า" | mkV "กะประมาณ" ; -- src=panlex
lin measure_V = mkV "วัด" | mkV "ตีราคา" | mkV "มีมิติ" | mkV "วัดปริมาณ" | mkV "ประเมินค่า" | mkV "วัด" | mkV "หาค่า" | mkV "กะประมาณ" ; -- src=panlex
lin insist_VS = mmkVS "ยืนยัน" ; ---- | mkV "รบเร้า" | mkV "ยืนกราน" | mkV "ย้ํา" | mkV "กําชับ" | mkV "ยืนยัน" | mkV "ยืนกราน" ; -- src=panlex
lin insist_V2 = mkV2 "ยืนยัน" ; ---- | mkV "รบเร้า" | mkV "ยืนกราน" | mkV "ย้ํา" | mkV "กําชับ" | mkV "ยืนยัน" | mkV "ยืนกราน" ; -- src=panlex
lin insist_V = mkV "ยืนยัน" | mkV "รบเร้า" | mkV "ยืนกราน" | mkV "ย้ํา" | mkV "กําชับ" | mkV "ยืนยัน" | mkV "ยืนกราน" ; -- src=panlex
lin farmer_N = mkN "ชาวนา" | mkN "เกษตรกร" | mkN "กสิกร" | mkN "ชาวนา" | mkN "ชาวไร่" | mkN "คนทํานา" | mkN "เกษตรกร" | mkN "ผู้รับเลี้ยง" | mkN "เจ้าของฟาร์ม" ; -- src=panlex
lin until_Prep = mkPrep "ก่อน" | mkPrep "จนถึง" | mkPrep "จนกว่า" | mkPrep "กระทั่ง" | mkPrep "เกือบจะ" | mkPrep "จนกระทั่ง" ; -- src=panlex
lin traffic_N = mkN "การจราจร" | mkN "การลักลอบค้า" | mkN "ค้าขายสิ่งที่ผิดกฎหมาย" ; -- src=panlex
lin dinner_N = mkN "ข้าวเย็น" | mkN "ดินเนอร์" | mkN "มื้อเย็น" | mkN "อาหารเย็น" | mkN "อาหารมื้อเย็น" | mkN "งานเลี้ยงอาหารค่ำ" | mkN "ข้าวเย็น" | mkN "อาหารค่ํา" | mkN "อาหารเย็น" | mkN "อาหารมื้อค่ํา" | mkN "อาหารมื้อเย็น" | mkN "งานเลี้ยงอาหารค่ํา" | mkN "อาหารมื้อที่จัดเป็นเกียรติแก่บุคคลเนื่องในโอกาสสําคัญ" ; -- src=panlex
lin consumer_N = mkN "ผู้บริโภค" | mkN "ผู้ซื้อ" | mkN "สิ่งผลาญ" | mkN "ผู้บริโภค" | mkN "ผู้ใช้สินค้าหรือบริการ" ; -- src=panlex
lin meal_N = mkN "มื้อ" | mkN "ธัญพืชบด" | mkN "พระกระยาหาร" | mkN "อาหารหนึ่งมื้อ" | mkN "มื้อ" | mkN "อาหาร" | mkN "ข้าวบด" | mkN "สารป่น" | mkN "ข้าวป่น" | mkN "ธัญพืชบด" | mkN "มื้ออาหาร" | mkN "ผงหยาบของข้าวบด" | mkN "เวลารับประทานอาหาร" | mkN "อาหารที่กินในมื้อหนึ่ง ๆ" ; -- src=panlex
lin warn_VS = mmkVS "ตำหนิ" ; ---- | mkV "เตือน" | mkV "ห้าม" | mkV "ดุด่า" | mkV "ทัดทาน" | mkV "ว่ากล่าว" | mkV "บอกให้รู้ล่วงหน้า" ; -- src=panlex
lin warn_V2V = mmkV2V "ตำหนิ" ; ---- | mkV "เตือน" | mkV "ห้าม" | mkV "ดุด่า" | mkV "ทัดทาน" | mkV "ว่ากล่าว" | mkV "บอกให้รู้ล่วงหน้า" ; -- src=panlex
lin warn_V2 = mkV2 "ตำหนิ" ; ---- | mkV "เตือน" | mkV "ห้าม" | mkV "ดุด่า" | mkV "ทัดทาน" | mkV "ว่ากล่าว" | mkV "บอกให้รู้ล่วงหน้า" ; -- src=panlex
lin warn_V = mkV "ตำหนิ" | mkV "เตือน" | mkV "ห้าม" | mkV "ดุด่า" | mkV "ทัดทาน" | mkV "ว่ากล่าว" | mkV "บอกให้รู้ล่วงหน้า" ; -- src=panlex
lin living_A = mkA "แรง" | mkA "ไหล" | mkA "งอกงาม" | mkA "มีอยู่" | mkA "ไม่ตาย" | mkA "คุกรุ่น" | mkA "กําลังลุก" | mkA "เจริญขึ้น" | mkA "ขะมักเขม้น" | mkA "มีชีวิตอยู่" | mkA "ที่ยังมีอยู่" | mkA "แน่นอนที่สุด" | mkA "วิธีการครองชีพ" | mkA "ในสภาพธรรมชาติ" | mkA "ไม่เปลี่ยนแปลง" | mkA "เงินเดือนของพระ" | mkA "คนที่มีชีวิตอยู่" | mkA "เกี่ยวกับการครองชีพ" | mkA "ที่มีสภาพตามธรรมชาติ" | mkA "เหมาะสมกับการดํารงชีพ" | mkA "เพียงพอต่อการมีชีวิตอยู่" | mkA "เกี่ยวกับคนที่มีชีวิตอยู่" ; -- src=panlex
lin package_N = mkN "หีบห่อ" | mkN "ซอฟต์แวร์" | mkN "ภาชนะบรรจุ" | mkN "โปรแกรมสำเร็จ" | mkN "คอมพิวเตอร์ซอฟต์แวร์" | mkN "มัด" | mkN "หีบ" | mkN "ห่อ" | mkN "หีบห่อ" | mkN "สัมภาระ" | mkN "ภาชนะบรรจุ" | mkN "ส่วนประกอบทั้งหมด" | mkN "การซื้อขายเหมาทั้งชุด" ; -- src=panlex
lin half_N = mkN "ครึ่งเวลา" | mkN "หนึ่งส่วนสอง" | mkN "กึ่ง" | mkN "ครึ่ง" | mkN "กองหน้า" | mkN "ครึ่งรอบ" | mkN "ครึ่งเกม" | mkN "กึ่งหนึ่ง" | mkN "ครึ่งเทอม" | mkN "ส่วนหนึ่ง" | mkN "ครึ่งหนึ่ง" | mkN "ซีกหนึ่งของโลก" | mkN "ครึ่งปีการศึกษา" | mkN "ครึ่งเวลาของการแข่งขัน" | mkN "เวลาพักระหว่างครึ่งระยะเวลาการแข่งขันกีฬา" ; -- src=panlex
lin increasingly_Adv = mkAdv "เพิ่มขึ้น" | mkAdv "อย่างมากขึ้น" | mkAdv "อย่างเพิ่มพูนขึ้น" ; -- src=panlex
lin description_N = mkN "ชนิด" | mkN "คำบรรยาย" | mkN "การบรรยาย" | mkN "ชนิด" | mkN "การบอก" | mkN "ประเภท" | mkN "ลักษณะ" | mkN "การเล่า" | mkN "การพรรณา" | mkN "การบรรยาย" | mkN "การพรรณนา" | mkN "การอธิบาย" | mkN "รูปร่างลักษณะ" | mkN "การวาดหรือเขียนรูป" ; -- src=panlex
lin soft_A = mkA "นุ่ม" | mkA "อ่อน" | mkA "โฆษะ" | mkA "บอบบาง" | mkA "นุ่มนวล" | mkA "นุ่มนิ่ม" | mkA "อ่อนนุ่ม" | mkA "เสียงก้อง" | mkA "นิ่ม" | mkA "นุ่ม" | mkA "หยุด" | mkA "อ่อน" | mkA "นิ่่ม" | mkA "อ่อนๆ" | mkA "นิ่มนวล" | mkA "นุ่มนวล" | mkA "ผ่อนปรน" | mkA "อ่อนโยน" | mkA "แผ่วเบา" | mkA "ความนิ่ม" | mkA "อ่อนนิ่ม" | mkA "อ่อนนุ่ม" | mkA "ความนิ่มนวล" | mkA "ยืดหยุ่นได้" | mkA "ส่วนที่นิ่ม" | mkA "ไม่เคร่งครัด" | mkA "ไม่เร็วเกินไป!" | mkA "ซึ่งไม่ปนแอลกอฮอล์" | mkA "ซึ่งไม่ผสมแอลกอฮอล์" ; -- src=panlex
lin stuff_N = mkN "วัตถุ" | mkN "วัสดุ" | mkN "ของเบ็ดเตล็ด" | mkN "ของใช้ส่วนตัว" | mkN "เรื่องเหลวไหล" | mkN "เรื่องไร้สาระ" | mkN "สระ" | mkN "อัด" | mkN "บรรจุ" | mkN "วัตถุ" | mkN "ของเลว" | mkN "ปัจจัย" | mkN "ยัดไส้" | mkN "ใส่ไส้" | mkN "ไส้ขนม" | mkN "ธาตุแท้" | mkN "สิ่งของ" | mkN "แก่นแท้" | mkN "วัตถุดิบ" | mkN "เนื้อแท้" | mkN "สัพเพเหระ" | mkN "กินอย่างตะกละ" | mkN "ความเชี่ยวชาญ" | mkN "เรื่องเหลวไหล" | mkN "คําพูดที่ไร้สาระ" | mkN "การกระทําเฉพาะอย่าง" | mkN "คําพูดหรือการกระทํา" | mkN "ความเชี่ยวชาญเฉพาะอย่าง" ; -- src=panlex
lin award_V3 = variants{} ; -- 
lin award_V2 = variants{} ; -- 
lin existence_N = mkN "เป็น" | mkN "จักรวาล" | mkN "สรรพสิ่ง" | mkN "การเป็นอยู่" | mkN "สิ่งมีชีวิต" | mkN "การคงอยู่" | mkN "การมีอยู่" | mkN "การดํารงอยู่" | mkN "ความเป็นอยู่" | mkN "การมีชีวิตอยู่" | mkN "สิ่งที่มีอยู่จริง" ; -- src=panlex
lin improvement_N = mkN "การปรับปรุง" | mkN "การแก้ไข" | mkN "การปรับปรุง" | mkN "การทําให้ดีขึ้น" | mkN "ภาวะหรือสภาพที่ดีขึ้น" | mkN "สิ่งที่ช่วยทําให้ดีขึ้น" | mkN "สิ่งที่ถูกปรับปรุงให้ดีขึ้น" ; -- src=panlex
lin coffee_N = mkN "กาแฟ" | mkN "คอฟฟี่" | mkN "สีกาแฟ" | mkN "ต้นกาแฟ" | mkN "เมล็ดกาแฟ" | mkN "สีน้ำตาลเข้ม" | mkN "กาแฟ" | mkN "สีกาแฟ" | mkN "ข้าวแฝ่" | mkN "ต้นกาแฟ" | mkN "เมล็ดกาแฟ" | mkN "สีน้ําตาลเข้ม" | mkN "เครื่องดื่มกาแฟ" ; -- src=panlex
lin appearance_N = mkN "ลักษณะ" | mkN "ภาพในใจ" | mkN "รูปลักษณ์" | mkN "การปรากฏตัว" | mkN "การสร้างภาพ" | mkN "สิ่งที่ปรากฏ" | mkN "รูปลักษณ์ภายนอก" | mkN "การเข้าร่วมในศาล" | mkN "รูปโฉม" | mkN "รูปร่าง" | mkN "การไปศาล" | mkN "ภาพลักษณ์" | mkN "รูปลักษณะ" | mkN "รูปลักษณ์" | mkN "โฉมภายนอก" | mkN "การปรากฎตัว" | mkN "การปรากฏตัว" | mkN "ลักษณะท่าทาง" | mkN "สิ่งที่ปรากฎ" | mkN "รูปร่างหน้าตา" | mkN "สิ่งที่ปรากฎให้เห็น" ; -- src=panlex
lin standard_A = mkA "มาตรฐาน" | mkA "ซึ่งเป็นมาตรฐาน" ; -- src=panlex
lin attack_V2 = variants{} ; -- 
lin sheet_N = mkN "ชีต" | mkN "แผ่น" | mkN "ตาราง" | mkN "ระนาบ" | mkN "ใบเรือ" | mkN "ผ้าใบเรือ" | mkN "แท็บลอยด์" | mkN "ผ้าปูที่นอน" | mkN "หนังสือพิมพ์แท็บลอยด์" | mkN "เชือกผูกเสากระโดงเรือ" | mkN "กระดาษสำหรับเขียนและพิมพ์" | mkN "ผืน" | mkN "ขนาด" | mkN "แผ่น" | mkN "ปูผ้า" | mkN "ระวาง" | mkN "กางออก" | mkN "ปกคลุม" | mkN "วารสาร" | mkN "ขยายออก" | mkN "ผืนใหญ่" | mkN "แผ่นใหญ่" | mkN "ผ้าคลุมศพ" | mkN "ยกหนังสือ" | mkN "แผ่นกระดาษ" | mkN "แผ่นบันทึก" | mkN "ผ้าปูที่นอน" | mkN "สิ่งตีพิมพ์" | mkN "หน้าหนังสือ" | mkN "หนังสือพิมพ์" | mkN "ความกว้างขวาง" | mkN "ผ้าสี่เหลี่ยมขนาดใหญ่" | mkN "ห่อด้วยแผ่นหรือผืนใหญ่" ; -- src=panlex
lin category_N = mkN "คลาส" | mkN "ประเภท" | mkN "หมวด" | mkN "หมู่" | mkN "ประเภท" | mkN "ปริมณฑล" | mkN "หมวดหมู่" | mkN "ลําดับขั้น" ; -- src=panlex
lin distribution_N = mkN "การกระจาย" | mkN "การจำหน่ายสินค้า" | mkN "การแจก" | mkN "การแพร่" | mkN "การกระจาย" | mkN "การจําแนก" | mkN "การปันส่วน" | mkN "การแจกจ่าย" | mkN "การแบ่งสรร" | mkN "การจําหน่าย" | mkN "การรื้อแม่พิมพ์" ; -- src=panlex
lin equally_Adv = variants{} ; -- 
lin session_N = mkN "เทอม" | mkN "ภาคเรียน" | mkN "การประชุม" | mkN "สมัยประชุม" | mkN "ภาคการศึกษา" | mkN "การนั่งประชุม" | mkN "การร่วมประชุม" | mkN "ระยะการประชุม" | mkN "เวลาในการประชุม" ; -- src=panlex
lin cultural_A = mkA "ทางศิลปะ" | mkA "ทางวัฒนธรรม" | mkA "เกี่ยวกับวัฒนธรรม" | mkA "เกี่ยวกับเพาะปลูก" ; -- src=panlex
lin loan_N = mkN "คำยืม" | mkN "เงินกู้" | mkN "ให้กู้" | mkN "เงินกู้" | mkN "การให้กู้" | mkN "การให้ยืม" | mkN "สิ่งที่ให้ยืม" | mkN "เงินที่ให้กู้" ; -- src=panlex
lin bind_V2 = mkV2 "ผูก" ; ---- | mkV "พัน" | mkV "มัด" | mkV "มัีด" | mkV "ผูกพัน" | mkV "ผูกมัด" | mkV "หุ้มปก" | mkV "ติดแน่น" | mkV "สร้างพันธะ" | mkV "ทำให้ท้องผูก" | mkV "สร้างพันธะเคมี" | mkV "คาด" | mkV "ผูก" | mkV "มัด" | mkV "รัด" ; -- src=panlex
lin bind_V = mkV "ผูก" | mkV "พัน" | mkV "มัด" | mkV "มัีด" | mkV "ผูกพัน" | mkV "ผูกมัด" | mkV "หุ้มปก" | mkV "ติดแน่น" | mkV "สร้างพันธะ" | mkV "ทำให้ท้องผูก" | mkV "สร้างพันธะเคมี" | mkV "คาด" | mkV "ผูก" | mkV "มัด" | mkV "รัด" ; -- src=panlex
lin museum_N = mkN "มิวเซียม" | mkN "พิพิธภัณฑ์" | mkN "พิพิธภัณฑ์" ; -- src=panlex
lin conversation_N = mkN "การสนทนา" | mkN "การสนทนา" | mkN "การสนทนา การคุยกัน" | mkN "การพูดคุย" | mkN "การคบค้าสมาคม" | mkN "ลักษณะการครองชีพ" | mkN "ความสามารถในการสังคมกับคนอื่น" ; -- src=panlex
lin threaten_VV = mkVV "คุกคาม" ; ---- | mkV "ทำอันตราย" | mkV "ขู่" | mkV "คุกคาม" | mkV "ขู่เข็ญ" ; -- src=panlex
lin threaten_VS = mmkVS "คุกคาม" ; ---- | mkV "ทำอันตราย" | mkV "ขู่" | mkV "คุกคาม" | mkV "ขู่เข็ญ" ; -- src=panlex
lin threaten_V2 = mkV2 "คุกคาม" ; ---- | mkV "ทำอันตราย" | mkV "ขู่" | mkV "คุกคาม" | mkV "ขู่เข็ญ" ; -- src=panlex
lin threaten_V = mkV "คุกคาม" | mkV "ทำอันตราย" | mkV "ขู่" | mkV "คุกคาม" | mkV "ขู่เข็ญ" ; -- src=panlex
lin link_N = mkN "ลิงก์" | mkN "ลิงค์" | mkN "ดาต้าลิงค์" | mkN "ลิงค์ข้อมูล" | mkN "เรดิโอลิงค์" | mkN "การเชื่อมต่อ" | mkN "การเชื่อมโยง" | mkN "การเชื่อมโ่ยง" | mkN "ช่องทางการสื่อสาร" | mkN "คบไฟ" | mkN "ข้อต่อ" | mkN "คบเพลิง" | mkN "ข้อลูกโซ่" | mkN "การเชื่อมต่อ" | mkN "เครื่องประสาน" | mkN "ระบบวิทยุสื่อสาร" | mkN "สิ่งที่เชื่อมต่อ" | mkN "หน่วยระบบสื่อสาร" | mkN "ระบบสื่อสารข้อมูล" | mkN "หน่วยความยาว เท่ากับ 7.92" ; -- src=panlex
lin launch_V2 = mkV2 "จัด" ; ---- | mkV "ปล่อย" | mkV "ยิง" | mkV "เริ่ม" | mkV "ริเริ่ม" | mkV "เริ่มต้น" | mkV "เริ่มทํางาน" | mkV "ปล่อยเรือลงน้ํา" | mkV "เริ่มดําเนินการ" ; -- src=panlex
lin launch_V = mkV "จัด" | mkV "ปล่อย" | mkV "ยิง" | mkV "เริ่ม" | mkV "ริเริ่ม" | mkV "เริ่มต้น" | mkV "เริ่มทํางาน" | mkV "ปล่อยเรือลงน้ํา" | mkV "เริ่มดําเนินการ" ; -- src=panlex
lin proper_A = mkA "ซึ่งเหมาะสม" | mkA "กับตา" | mkA "สมควร" | mkA "เหมาะ" | mkA "มารยาท" | mkA "ถูกต้อง" | mkA "สมบูรณ์" | mkA "เต็มที่" | mkA "เหมาะสม" | mkA "ดั้งเดิม" | mkA "ดีเยี่ยม" | mkA "ถูกมารยาท" | mkA "เคร่งครัด" | mkA "ถูกกาลเทศะ" | mkA "อันแท้จริง" | mkA "ความประพฤติ" | mkA "โดยตัวของมันเอง" | mkA "ที่เป็นไปโดยธรรมชาติ" | mkA "เกี่ยวกับบุคคลใดหรือสิ่งใดโดยเฉพาะ" ; -- src=panlex
lin victim_N = mkN "เหยื่อ" | mkN "ผู้ประสบภัย" | mkN "ผู้รับเคราะห์" | mkN "ผู้เคราะห์ร้าย" | mkN "เหยื่อ" | mkN "ผู้ถูกโกง" | mkN "ผู้รับบาป" | mkN "ผู้ถูกหลอก" | mkN "ผู้ประสบภัย" | mkN "ผู้รับเคราะห์" | mkN "ผู้เคราะห์ร้าย" | mkN "สิ่งที่มีชีวิตที่ถูกบูชายัญ" ; -- src=panlex
lin audience_N = mkN "คนดู" | mkN "ผู้ชม" | mkN "โอกาสฟัง" | mkN "การเข้าหารือ" | mkN "คนดู" | mkN "คนฟัง" | mkN "ผู้ชม" | mkN "ผู้ดู" | mkN "ผู้ฟัง" | mkN "ผู้อ่าน" | mkN "การได้ยิน" | mkN "การเข้าพบเป็นทางการ" | mkN "การสัมภาษณ์อย่างเป็นทางการ" ; -- src=panlex
lin famous_A = mkA "ที่มีชื่อเสียง" | mkA "ดียิ่ง" | mkA "โด่งดัง" | mkA "ขึ้นชื่อ" | mkA "ชั้นหนึ่ง" | mkA "ยอดเยี่ยม" | mkA "มีชื่อเสียง" | mkA "เป็นรู้จักกันดี" ; -- src=panlex
lin master_N = variants{} ; -- 
lin master_2_N = variants{} ; -- 
lin master_1_N = variants{} ; -- 
lin lip_N = mkN "ปาก" | mkN "การแซว" | mkN "ปากขวด" | mkN "กลีบปาก" | mkN "ริมฝีปาก" | mkN "ขอบ" | mkN "ริม" | mkN "ฝีปาก" | mkN "ขอบภาชนะ" | mkN "ริมฝีปาก" | mkN "การพูดทะลึ่งหรืออวดดี" | mkN "สิ่งหรือส่วนที่คล้ายริมฝีปาก" ; -- src=panlex
lin religious_A = mkA "เคร่ง" | mkA "ทางศาสนา" | mkA "เคร่งศาสนา" | mkA "ทางจิตวิญญาณ" | mkA "นักพรต" | mkA "ออกบวช" | mkA "เคร่งศาสนา" | mkA "เกี่ยวกับศาสนา" | mkA "เลื่อมใสในศาสนา" | mkA "สมาชิกของนิกายศาสนาหนึ่ง" ; -- src=panlex
lin joint_A = mkA "ที่ประชุมร่วมสองสภา" | mkA "ที่ร่วมกัน" ; -- src=panlex
lin cry_V2 = mkV2 "ตะโกน" ; ---- | mkV "อุทาน" | mkV "ร้องไห้" | mkV "ร้องลั่น" | mkV "ทรงกันแสง" | mkV "ร้องตะโกน" | mkV "ร้องอุทาน" | mkV "ป่าวประกาศ" | mkV "หลั่งน้ำตา" | mkV "ทรงพระกันแสง" | mkV "ส่งเสียงร้อง" | mkV "น้ำหูน้ำตาไหล" | mkV "ร้องห่มร้องไห้" | mkV "ตะโกน" | mkV "ร่ําไห้" | mkV "ร้องไห้" | mkV "ป่าวร้อง" | mkV "หลั่งน้ําตา" ; -- src=panlex
lin cry_V = mkV "ตะโกน" | mkV "อุทาน" | mkV "ร้องไห้" | mkV "ร้องลั่น" | mkV "ทรงกันแสง" | mkV "ร้องตะโกน" | mkV "ร้องอุทาน" | mkV "ป่าวประกาศ" | mkV "หลั่งน้ำตา" | mkV "ทรงพระกันแสง" | mkV "ส่งเสียงร้อง" | mkV "น้ำหูน้ำตาไหล" | mkV "ร้องห่มร้องไห้" | mkV "ตะโกน" | mkV "ร่ําไห้" | mkV "ร้องไห้" | mkV "ป่าวร้อง" | mkV "หลั่งน้ําตา" ; -- src=panlex
lin potential_A = mkA "ที่เป็นไปได้" | mkA "ที่มีทางเป็นไปได้" | mkA "เป็นได้" | mkA "เป็นไปได้" | mkA "กลายเป็นได้" | mkA "ศักยะทางไฟฟ้า หลุมลึก" | mkA "ที่อาจเกิดขึ้นได้" | mkA "มีความสามารถซ่อนเร้นอยู่" | mkA "ความสามารถหรือํานาจที่ซ่อนเร้นอยู่" ; -- src=panlex
lin broad_A = mkA "กว้าง" | {-pan-} mkA "กว้างๆ" | mkA "กว้างสุดลูกหูลูกตา" | mkA "ซึ่งเปิดกว้างทางความคิด" | mkA "หยาบ" | mkA "หลวมๆ" | mkA "ทั่วๆ ไป" | mkA "กว้างๆ" | mkA "ทั่วโลก" | mkA "ครอบคลุม" | mkA "กว้างขวาง" | mkA "ไม่จํากัด" ; -- src=panlex
lin exhibition_N = mkN "งานแสดง" | mkN "นิทรรศการ" | mkN "งานมหกรรม" | mkN "การแสดงออก" | mkN "ทุนการศึกษา" | mkN "การแสดงนิทรรศการ" | mkN "สิ่งที่นํามาแสดง" | mkN "สิ่งของที่นํามาแสดง" | mkN "ผลิตภัณฑ์ที่นํามาแสดงออก" ; -- src=panlex
lin experience_V2 = variants{} ; -- 
lin judge_N = mkN "ศาล" | mkN "ตุลาการ" | mkN "ผู้ประเมิน" | mkN "ผู้พิพากษา" | mkN "ตุลาการ" | mkN "ผู้พิพากษา" | mkN "ผู้พิพากษาิ" | mkN "กรรมการผู้ตัดสิน" ; -- src=panlex
lin formal_A = mkA "ที่เป็นทางการ" | mkA "เหมาะสม" | mkA "ตามรูปแบบ" | mkA "เป็นทางการ" | mkA "เป็นรูปแบบ" | mkA "เจ้าระเบียบ" | mkA "เป็นพิธีการ" | mkA "พิธีรีตองมาก" | mkA "ตามประเพณีนิยม" | mkA "ที่เป็นกฎเกณฑ์" | mkA "เป็นกิจจะลักษณะ" | mkA "ในชุดเครื่องแบบ" | mkA "ตามธรรมเนียมปฏิบัติ" | mkA "ซึ่งเป็นชุดที่เป็นทางการ" | mkA "ซึ่งเป็นเครื่องแบบที่เป็นทางการ" ; -- src=panlex
lin housing_N = mkN "ตัวถัง" | mkN "ที่อยู่" | mkN "ที่อาศัย" | mkN "ที่พักอาศัย" | mkN "อาคารที่พัก" | mkN "ที่อยู่อาศัย" | mkN "อาคารที่พักอาศัย" | mkN "เครื่องประดับม้า" | mkN "การเคหะ" | mkN "ปลอกหุ้ม" | mkN "สิ่งครอบคลุม" | mkN "บ้านพักทั้งหลาย" | mkN "การจัดบ้านพักให้" | mkN "สิ่งปกคลุมหรือป้องกันม้าหรือสัตว์อื่น" ; -- src=panlex
lin past_Prep = mkPrep "ผ่าน" | mkPrep "หลัง" | mkPrep "เลยผ่าน" ; -- src=panlex
lin concern_V2 = variants{} ; -- 
lin freedom_N = mkN "อิสระ" | mkN "เสรีภาพ" | mkN "ความมีอิสระ" | mkN "อิสรภาพ" | mkN "เสรีภาพ" | mkN "ความเป็นอิสระ" ; -- src=panlex
lin gentleman_N = mkN "ชายผู้ดี" | mkN "สุภาพบุรุษ" | mkN "เจนเทิลแมน" | mkN "สุภาพบุรุษ" | mkN "ชายชาติตระกูลดี" | mkN "ผู้มีกิริยาสุภาพ" ; -- src=panlex
lin attract_V2 = variants{} ; -- 
lin explanation_N = mkN "คำอธิบาย" | mkN "การอธิบาย" | mkN "ความหมาย" | mkN "การชี้แจง" | mkN "การอธิบาย" | mkN "คําชี้แจง" | mkN "คําอธิบาย" | mkN "การขยายความ" | mkN "สิ่งที่ชี้แจง" | mkN "สิ่งที่อธิบาย" ; -- src=panlex
lin appoint_V3 = variants{} ; -- 
lin appoint_V2V = variants{} ; -- 
lin appoint_V2 = variants{} ; -- 
lin note_VS = mmkVS "จด" ; ---- | mkV "โน้ต" | mkV "สังเกต" | mkV "แสดงทัศนะ" | mkV "สังเกตเห็น" | mkV "ออกความเห็น" | mkV "แสดงความคิดเห็น" | mkV "จด" | mkV "โน้ต" | mkV "บันทึก" | mkV "สังเกต" ; -- src=panlex
lin note_V2 = mkV2 "จด" ; ---- | mkV "โน้ต" | mkV "สังเกต" | mkV "แสดงทัศนะ" | mkV "สังเกตเห็น" | mkV "ออกความเห็น" | mkV "แสดงความคิดเห็น" | mkV "จด" | mkV "โน้ต" | mkV "บันทึก" | mkV "สังเกต" ; -- src=panlex
lin note_V = mkV "จด" | mkV "โน้ต" | mkV "สังเกต" | mkV "แสดงทัศนะ" | mkV "สังเกตเห็น" | mkV "ออกความเห็น" | mkV "แสดงความคิดเห็น" | mkV "จด" | mkV "โน้ต" | mkV "บันทึก" | mkV "สังเกต" ; -- src=panlex
lin chief_A = mkA "หลัก" | mkA "สําคัญ" | mkA "มีอํานาจสูงสุด" ; -- src=panlex
lin total_N = mkN "ผลบวก" | mkN "ผลรวม" | mkN "ผลรวม" | mkN "ยอดรวม" ; -- src=panlex
lin lovely_A = mkA "น่ารัก" | mkA "ดีงาม" | mkA "น่ารัก" | mkA "สวยงาม" | mkA "ดีเยี่ยม" | mkA "น่าเอ็นดู" | mkA "เป็นที่เบิกบานใจ" ; -- src=panlex
lin official_A = mkA "ที่เป็นทางการ" | mkA "เกี่ยวกับสำนักงาน" | mkA "เป็นทางการ" | mkA "ที่เป็นทางการ" ; -- src=panlex
lin date_V2 = mkV2 "นัดพบ" ; ---- | mkV "มีนัด" | mkV "ออกเดท" | mkV "ระบุเวลา" | mkV "ใส่วันที่" | mkV "ปั๊มวันที่" | mkV "ระบุวันที่" | mkV "ประทับวันที่" | mkV "ประทับตราวันที่" | mkV "นัดพบ" | mkV "นัดหมาย" | mkV "ลงวันที่" | mkV "กําหนดวัน" | mkV "ระบุวันที่" | mkV "ออกไปพบตามนัด" ; -- src=panlex
lin date_V = mkV "นัดพบ" | mkV "มีนัด" | mkV "ออกเดท" | mkV "ระบุเวลา" | mkV "ใส่วันที่" | mkV "ปั๊มวันที่" | mkV "ระบุวันที่" | mkV "ประทับวันที่" | mkV "ประทับตราวันที่" | mkV "นัดพบ" | mkV "นัดหมาย" | mkV "ลงวันที่" | mkV "กําหนดวัน" | mkV "ระบุวันที่" | mkV "ออกไปพบตามนัด" ; -- src=panlex
lin demonstrate_VS = mmkVS "สาธิต" ; ---- | mkV "พิสูจน์" | mkV "เดินขบวน" | mkV "พิสูจน์ให้เห็น" | mkV "เดินขบวนคัดค้าน" | mkV "เดินขบวนประท้วง" | mkV "เป็นพยานหลักฐาน" | mkV "เดินขบวนเรียกร้อง" | mkV "แสดง" | mkV "สาธิต" | mkV "อธิบาย" | mkV "ประท้วง" | mkV "พิสูจน์" | mkV "ให้เหตุผล" | mkV "แสดงให้เห็น" | mkV "ทดลองให้เห็น" ; -- src=panlex
lin demonstrate_V2 = mkV2 "สาธิต" ; ---- | mkV "พิสูจน์" | mkV "เดินขบวน" | mkV "พิสูจน์ให้เห็น" | mkV "เดินขบวนคัดค้าน" | mkV "เดินขบวนประท้วง" | mkV "เป็นพยานหลักฐาน" | mkV "เดินขบวนเรียกร้อง" | mkV "แสดง" | mkV "สาธิต" | mkV "อธิบาย" | mkV "ประท้วง" | mkV "พิสูจน์" | mkV "ให้เหตุผล" | mkV "แสดงให้เห็น" | mkV "ทดลองให้เห็น" ; -- src=panlex
lin demonstrate_V = mkV "สาธิต" | mkV "พิสูจน์" | mkV "เดินขบวน" | mkV "พิสูจน์ให้เห็น" | mkV "เดินขบวนคัดค้าน" | mkV "เดินขบวนประท้วง" | mkV "เป็นพยานหลักฐาน" | mkV "เดินขบวนเรียกร้อง" | mkV "แสดง" | mkV "สาธิต" | mkV "อธิบาย" | mkV "ประท้วง" | mkV "พิสูจน์" | mkV "ให้เหตุผล" | mkV "แสดงให้เห็น" | mkV "ทดลองให้เห็น" ; -- src=panlex
lin construction_N = mkN "การสร้าง" | mkN "การตีความ" | mkN "การวางแผน" | mkN "โครงสร้าง" | mkN "การก่อสร้าง" | mkN "สิ่งก่อสร้าง" | mkN "โครงสร้างประโยค" | mkN "การคิดสังเคราะห์" | mkN "การคิดเชิงสังเคราะห์" | mkN "โครงสร้างทางไวยากรณ์" | mkN "ธุรกิจรับเหมาก่อสร้าง" | mkN "การคิดค้น" | mkN "การตีความ" | mkN "โครงสร้าง" | mkN "การก่อสร้าง" | mkN "การปลูกสร้าง" | mkN "สิ่งปลูกสร้าง" | mkN "การผูกประโยคหรือคํา" | mkN "คําหรือวลีที่ผูกขึ้น" ; -- src=panlex
lin middle_N = mkN "กลาง" | mkN "ใจกลาง" | mkN "ตรงกลาง" | mkN "กลางลำตัว" | mkN "ศูนย์กลาง" | mkN "กลาง" | mkN "จุดกลาง" | mkN "ตอนกลาง" | mkN "ปานกลาง" | mkN "กึ่งกลาง" | mkN "พอประมาณ" | mkN "จุดกึ่งกลาง" ; -- src=panlex
lin yard_N = mkN "พัน" | mkN "หลา" | mkN "สนาม" | mkN "๑๐๐๐" | mkN "สนามหญ้า" | mkN "หนึ่งพัน" | mkN "คิวบิกหลา" | mkN "คอกปศุสัตว์" | mkN "สถานีสับเปลี่ยนขบวนรถ" | mkN "1000" | mkN "คอก" | mkN "ลาน" | mkN "สนาม" | mkN "เล้า" | mkN "ลานบ้าน" | mkN "บริเวณบ้าน" | mkN "คอกปศุสัตว์" | mkN "สนามรอบบ้าน" | mkN "ลานเอนกประสงค์" | mkN "สถานที่เก็บรถไฟ" | mkN "คานยาวพยุงใบเรือ" | mkN "สนามที่มีรั้วล้อมรอบตัวอาคาร" | mkN "ทุ่งหญ้าฤดูหนาวของสัตว์จําพวกกวาง" | mkN "ระยะ 3 ฟุต" ; -- src=panlex
lin unable_A = mkA "ไม่สามารถ" | mkA "ซึ่งไม่สามารถ" ; -- src=panlex
lin acquire_V2 = variants{} ; -- 
lin surely_Adv = variants{} ; -- 
lin crisis_N = mkN "วิกฤต" | mkN "ภาวะวิกฤต" | mkN "วิกฤตการณ์" | mkN "ช่วงวิกฤต" | mkN "วิกฤติกาล" | mkN "ขั้นฉุกเฉิน" | mkN "ช่วงเวลาชี้ขาด" | mkN "เหตุการณ์ฉุกเฉิน" | mkN "ขั้นหัวเลี้ยวหัวต่อ" | mkN "ขั้นที่เป็นตายเท่ากัน" | mkN "ช่วงที่มีปัญหาร้ายแรง" | mkN "ช่วงเวลาที่เป็นตายเท่ากัน" | mkN "ช่วงเวลาที่อาจเกิดการเปลี่ยนแปลงอย่างฉับพลันของโรค" ; -- src=panlex
lin propose_VV = mkVV "เสนอ" ; ---- | mkV "ตั้งใจ" | mkV "ขอแต่งงาน" | mkV "เสนอ" | mkV "วางแผน" | mkV "เสนอชื่อ" | mkV "ขอแต่งงาน" | mkV "เสนอเพื่อให้พิจารณา" | mkV "เสนอชื่อเพื่อแต่งตั้ง" ; -- src=panlex
lin propose_VS = mmkVS "เสนอ" ; ---- | mkV "ตั้งใจ" | mkV "ขอแต่งงาน" | mkV "เสนอ" | mkV "วางแผน" | mkV "เสนอชื่อ" | mkV "ขอแต่งงาน" | mkV "เสนอเพื่อให้พิจารณา" | mkV "เสนอชื่อเพื่อแต่งตั้ง" ; -- src=panlex
lin propose_V2 = mkV2 "เสนอ" ; ---- | mkV "ตั้งใจ" | mkV "ขอแต่งงาน" | mkV "เสนอ" | mkV "วางแผน" | mkV "เสนอชื่อ" | mkV "ขอแต่งงาน" | mkV "เสนอเพื่อให้พิจารณา" | mkV "เสนอชื่อเพื่อแต่งตั้ง" ; -- src=panlex
lin propose_V = mkV "เสนอ" | mkV "ตั้งใจ" | mkV "ขอแต่งงาน" | mkV "เสนอ" | mkV "วางแผน" | mkV "เสนอชื่อ" | mkV "ขอแต่งงาน" | mkV "เสนอเพื่อให้พิจารณา" | mkV "เสนอชื่อเพื่อแต่งตั้ง" ; -- src=panlex
lin west_N = mkN "ต.ต" | mkN "ตะวันตก" | mkN "ทิศตะวันตก" | mkN "ภาคตะวันตก" | mkN "ประจิม" | mkN "ตะวันตก" | mkN "ทิศตะวันตก" | mkN "ทางทิศตะวันตก" | mkN "มาจากทิศตะวันตก" | mkN "ไปทางทิศตะวันตก" | mkN "ประเทศทางตะวันตก" | mkN "อยู่ทางด้านตะวันตก" | mkN "ประเทศทางทวีปยุโรปและอเมริกา" ; -- src=panlex
lin impose_V2 = mkV2 "กำหนด" ; ---- | mkV "ยัดเยียด" | mkV "กําหนด" | mkV "บังคับให้มี" | mkV "กําหนดโทษให้" ; -- src=panlex
lin impose_V = mkV "กำหนด" | mkV "ยัดเยียด" | mkV "กําหนด" | mkV "บังคับให้มี" | mkV "กําหนดโทษให้" ; -- src=panlex
lin market_V2 = mkV2 "จ่ายตลาด" ; ---- | mkV "ทำมาค้าขาย" | mkV "ซื้อขายในตลาด" | mkV "ขาย" | mkV "วางตลาด" | mkV "ขายสินค้า" ; -- src=panlex
lin market_V = mkV "จ่ายตลาด" | mkV "ทำมาค้าขาย" | mkV "ซื้อขายในตลาด" | mkV "ขาย" | mkV "วางตลาด" | mkV "ขายสินค้า" ; -- src=panlex
lin care_V = mkV "อยาก" | mkV "กังวล" | mkV "ใส่ใจ" | mkV "จัดการ" | mkV "แมนเนจ" | mkV "ช่วยดูแล" | mkV "ให้การดูแล" | mkV "บริหารจัดการ" | mkV "ดูแล" | mkV "ปกป้อง" | mkV "ห่วงใย" ; -- src=panlex
lin god_N = mkN "เทพ" | mkN "พระเจ้า" | mkN "เทพเจ้า" | mkN "รูปปั้นบูชา" | mkN "รูปปั้นสักการะ" | mkN "เทวดา" | mkN "พระเจ้า" | mkN "เทพเจ้า" | mkN "พระเป็นเจ้า" | mkN "พระผู้เป็นเจ้า" ; -- src=panlex
lin favour_N = mkN "ความกรุณา" | mkN "การเห็นชอบ" | mkN "ความลำเอียง" | mkN "ของที่ระลึกงานเลี้ยง" | mkN "โบ" | mkN "บุญคุณ" | mkN "ของขวัญ" | mkN "ของระลึก" | mkN "ความนิยม" | mkN "ไมตรีจิต" | mkN "การชื่นชม" | mkN "การยกย่อง" | mkN "การเชิดชู" | mkN "ความกรุณา" | mkN "ของสมนาคุณ" | mkN "การสนับสนุน" | mkN "ของที่ระลึก" | mkN "เครื่องหมาย" | mkN "ความประทับใจ" | mkN "ความเข้าข้าง" | mkN "ความเห็นพ้อง" | mkN "ความช่วยเหลือ" | mkN "ความปรารถนาดี" | mkN "ความสงเคราะห์" | mkN "ความเอื้อเฟื้อ" | mkN "การกระทําที่กรุณา" ; -- src=panlex
lin before_Adv = mkAdv "ก่อน" | mkAdv "อยู่หน้า" | mkAdv "กว่า" | mkAdv "ก่อน" | mkAdv "หน้า" | mkAdv "คอยอยู่" | mkAdv "ตรงหน้า" | mkAdv "ในอนาคต" | mkAdv "ก่อนหน้า" | mkAdv "อยู่หน้า" | mkAdv "ก่อนหน้านี้" | mkAdv "อยู่ข้างหน้า" | mkAdv "ภายใต้อิทธิพลของ" ; -- src=panlex
lin name_V3 = variants{} ; -- 
lin name_V2 = variants{} ; -- 
lin equal_A = mkA "ที่เหมาะสม" | mkA "ที่เท่าเทียมกัน" | mkA "ราบ" | mkA "พอกับ" | mkA "ขึ้นทัน" | mkA "เท่ากัน" | mkA "เสมอกัน" | mkA "เสมอกับ" | mkA "เสมอภาค" | mkA "ทัดเทียม" | mkA "ซึ่งพอกัน" | mkA "เท่าเทียม" | mkA "ได้เท่ากัน" | mkA "ซึ่งเท่ากัน" | mkA "ทําให้เสมอภาค" | mkA "จัดแบ่งให้เท่ากัน" ; -- src=panlex
lin capacity_N = mkN "ความจุ" | mkN "คอแข็ง" | mkN "กำลังไฟ" | mkN "สติปัญญา" | mkN "ความสามารถ" | mkN "ความจุำไฟฟ้า" | mkN "ปริมาณความจุไฟฟ้า" | mkN "ความสามารถทางสติปัญญา" | mkN "ความจุ" | mkN "ปริมาณ" | mkN "สติปัญญา" | mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "รับเต็มที่" | mkN "ประสิทธิภาพ" | mkN "การปฎิบัติหน้าที่" | mkN "ความสามารถที่จะรับ" | mkN "ปริมาณสูงสุดที่จะรับได้" | mkN "ความสามารถทางร่างกายหรือจิตใจ" ; -- src=panlex
lin flat_N = mkN "แฟลต" | mkN "อพาร์ทเมนท์" | mkN "ยางที่ไม่มีลม" | mkN "เครื่องหมายแฟลต" | mkN "กล่องเพาะต้นกล้า" | mkN "เครื่องหมายแฟล็ต" | mkN "เครื่องหมายแปลงเสียงต่ำ" | mkN "แฟลต" | mkN "ที่ราบ" | mkN "ยางแบน" | mkN "ยางแฟบ" | mkN "พื้นราบ" | mkN "ห้องชุด" | mkN "เสียงโน้ตที่ต่ําครึ่งเสียง" ; -- src=panlex
lin selection_N = mkN "ชอยซ์" | mkN "การเลือก" | mkN "ตัวเลือก" | mkN "บทคัดย่อ" | mkN "ส่วนที่ตัดมา" | mkN "การคัดเลือกโดยธรรมชาติ" | mkN "การสรรหา" | mkN "การเลือก" | mkN "ตัวเลือก" | mkN "การคัดสรร" | mkN "การคัดเลือก" | mkN "การเลือกสรร" | mkN "การเลือกเฟ้น" | mkN "รายการให้เลือก" | mkN "สิ่งที่ถูกเลือก" | mkN "สิ่งที่ได้รับเลือก" | mkN "ของที่คัดเลือกมาอย่างดี" | mkN "ผู้ที่ได้รับการคัดเลือก" | mkN "บทหรือตอนในหนังสือที่เลือกมา" ; -- src=panlex
lin alone_Adv = variants{} ; -- 
lin football_N = mkN "ฟุตบอล" | mkN "กีฬาฟุตบอล" | mkN "ลูกอเมริกันฟุตบอล" | mkN "ลูกบอล" | mkN "ลูกฟุตบอล" | mkN "กีฬาฟุตบอล" | mkN "กีฬารักบี้" ; -- src=panlex
lin victory_N = mkN "ชัยชนะ" | mkN "การประสบชัยชนะ" | mkN "การได้รับชัยชนะ" | mkN "ชัย" | mkN "ชัยชนะ" | mkN "การมีชัยชนะในการรบ" ; -- src=panlex
lin factory_N = mkN (thword "โรง" "งาน") "โรง" | {-pan-} mkN "ร.ง." | mkN "รง." | mkN "โรงงาน" | mkN "โรงงาน" | mkN "โรงงานอุตสาหกรรม" ; -- src=panlex
lin rural_A = mkA "ชนบท" | mkA "บ้านนอก" | mkA "ในชนบท" | mkA "ของชนบท" | mkA "เกี่ยวกับชนบท" | mkA "เกี่ยวกับไร่นา" | mkA "เกี่ยวกับบ้านนอก" | mkA "เกี่ยวกับการเกษตร" | mkA "เกี่ยวกับการทําเรือกสวนไร่นา" ; -- src=panlex
lin twice_Adv = mkAdv "สองครั้ง" | mkAdv "เป็นสองเท่า" | mkAdv "สองหน" | mkAdv "สองวาระ" | mkAdv "สองเท่า" | mkAdv "สองครั้ง" | mkAdv "เป็นสองเท่า" ; -- src=panlex
lin sing_V2 = mkV2 (thword "ร้อง") ; ---- | {-pan-} mkV "ร้อง" | mkV "ขับขาน" | mkV "เผยไต๋" | mkV "ขับร้อง" | mkV "เปิดเผย" | mkV "ร้องเพลง" | mkV "เผยเคล็ดลับ" | mkV "ร้อง" | mkV "ขับร้อง" | mkV "ร้องเพลง" | mkV "เปล่งเสียง" | mkV "สดุดีด้วยบทกวี" | mkV "สรรเสริญด้วยบทกวี" | mkV "ทําให้เกิดเสียงดนตรี" ; -- src=panlex
lin sing_V = mkV (thword "ร้อง") | {-pan-} mkV "ร้อง" | mkV "ขับขาน" | mkV "เผยไต๋" | mkV "ขับร้อง" | mkV "เปิดเผย" | mkV "ร้องเพลง" | mkV "เผยเคล็ดลับ" | mkV "ร้อง" | mkV "ขับร้อง" | mkV "ร้องเพลง" | mkV "เปล่งเสียง" | mkV "สดุดีด้วยบทกวี" | mkV "สรรเสริญด้วยบทกวี" | mkV "ทําให้เกิดเสียงดนตรี" ; -- src=panlex
lin whereas_Subj = variants{} ; -- 
lin own_V2 = variants{} ; -- 
lin head_V2 = mkV2 "นำทาง" ; ---- | mkV "ออกรวง" | mkV "มีต้นน้ำ" | mkV "มุ่งหน้า" | mkV "เอาหัวออก" | mkV "ไปล่วงหน้า" | mkV "กำหนดทิศทาง" | mkV "อยู่ข้างหน้า" | mkV "เป็นสมาชิกคนแรก" | mkV "เป็นผู้รับผิดชอบ" | mkV "ดูแล" | mkV "ควบคุม" | mkV "จัดการ" | mkV "มุ่งไปทาง" | mkV "มุ่งหน้าไป" ; -- src=panlex
lin head_V = mkV "นำทาง" | mkV "ออกรวง" | mkV "มีต้นน้ำ" | mkV "มุ่งหน้า" | mkV "เอาหัวออก" | mkV "ไปล่วงหน้า" | mkV "กำหนดทิศทาง" | mkV "อยู่ข้างหน้า" | mkV "เป็นสมาชิกคนแรก" | mkV "เป็นผู้รับผิดชอบ" | mkV "ดูแล" | mkV "ควบคุม" | mkV "จัดการ" | mkV "มุ่งไปทาง" | mkV "มุ่งหน้าไป" ; -- src=panlex
lin examination_N = mkN "เทสต์" | mkN "การสอบ" | mkN "ข้อสอบ" | mkN "การตรวจ" | mkN "การทดสอบ" | mkN "การสอบสวน" | mkN "การไต่สวน" | mkN "การตรวจสอบ" | mkN "การสอบ" | mkN "การทดสอบ" | mkN "การตรวจสอบ" | mkN "การพิจารณาอย่างละเอียด" ; -- src=panlex
lin deliver_V2 = mkV2 "สละ" ; ---- | mkV "ส่ง" | mkV "คลอด" | mkV "เกิด" | mkV "คลอดลูก" | mkV "ปลอดภัย" | mkV "ผลักดัน" | mkV "เกิดลูก" | mkV "ไล่ต้อน" | mkV "ขว้างลูก" | mkV "ให้กำเนิด" | mkV "ผลักดันกลับ" | mkV "กล่าวสุนทรพจน์" | mkV "มีพระประสูติการ" | mkV "ผลักดันกลับประเทศ" | mkV "ปา" | mkV "คืน" | mkV "มอบ" | mkV "ยอม" | mkV "สละ" | mkV "ส่ง" | mkV "ผลิต" | mkV "เสนอ" | mkV "แจ้ง" | mkV "ขว้าง" | mkV "ปล่อย" | mkV "ยกให้" | mkV "สร้าง" | mkV "นําส่ง" | mkV "ประกาศ" | mkV "ปาฐกถา" | mkV "ส่งคืน" | mkV "คลอดลูก" | mkV "บอกกล่าว" | mkV "ปลดปล่อย" | mkV "ปล่อยตัว" | mkV "ยอมยกให้" | mkV "สนับสนุน" | mkV "ส่งพัสดุ" | mkV "ส่งจดหมาย" | mkV "ส่งสินค้า" | mkV "บอกให้ทราบ" | mkV "ให้กําเนิด" | mkV "ช่วยคลอดลูก" | mkV "ช่วยทําคลอด" | mkV "ทําตามสัญญา" | mkV "พูดสุนทรพจน์" | mkV "แสดงการบรรยาย" | mkV "ช่วยให้พ้นจากที่คุมขัง" ; -- src=panlex
lin deliver_V = mkV "สละ" | mkV "ส่ง" | mkV "คลอด" | mkV "เกิด" | mkV "คลอดลูก" | mkV "ปลอดภัย" | mkV "ผลักดัน" | mkV "เกิดลูก" | mkV "ไล่ต้อน" | mkV "ขว้างลูก" | mkV "ให้กำเนิด" | mkV "ผลักดันกลับ" | mkV "กล่าวสุนทรพจน์" | mkV "มีพระประสูติการ" | mkV "ผลักดันกลับประเทศ" | mkV "ปา" | mkV "คืน" | mkV "มอบ" | mkV "ยอม" | mkV "สละ" | mkV "ส่ง" | mkV "ผลิต" | mkV "เสนอ" | mkV "แจ้ง" | mkV "ขว้าง" | mkV "ปล่อย" | mkV "ยกให้" | mkV "สร้าง" | mkV "นําส่ง" | mkV "ประกาศ" | mkV "ปาฐกถา" | mkV "ส่งคืน" | mkV "คลอดลูก" | mkV "บอกกล่าว" | mkV "ปลดปล่อย" | mkV "ปล่อยตัว" | mkV "ยอมยกให้" | mkV "สนับสนุน" | mkV "ส่งพัสดุ" | mkV "ส่งจดหมาย" | mkV "ส่งสินค้า" | mkV "บอกให้ทราบ" | mkV "ให้กําเนิด" | mkV "ช่วยคลอดลูก" | mkV "ช่วยทําคลอด" | mkV "ทําตามสัญญา" | mkV "พูดสุนทรพจน์" | mkV "แสดงการบรรยาย" | mkV "ช่วยให้พ้นจากที่คุมขัง" ; -- src=panlex
lin nobody_NP = mkNP (thword "ไม่" "มี" "ใคร") ;
lin substantial_A = mkA "ซึ่งแข็งแรง" | mkA "ที่จับต้องได้" | mkA "ที่อุดมด้วยสารอาหาร" | mkA "มากมาย" | mkA "สําคัญ" | mkA "แข็งแรง" | mkA "แน่นหนา" | mkA "มั่งคั่ง" | mkA "มีใจความ" | mkA "ยิ่งใหญ่" | mkA "เป็นจริง" | mkA "มีเนื้อหา" | mkA "มีแก่นสาร" | mkA "มีอยู่จริง" | mkA "อุดมสมบูรณ์" | mkA "เป็นของจริง" | mkA "เป็นความจริง" ; -- src=panlex
lin invite_V2V = variants{} ; -- 
lin invite_V2 = variants{} ; -- 
lin intention_N = mkN "จุดประสงค์" | mkN "เจตนา" | mkN "เจตจํานง" | mkN "เป้าหมาย" | mkN "ความตั้งใจ" | mkN "จุดมุ่งหมาย" | mkN "ความมุ่งหมาย" ; -- src=panlex
lin egg_N = mkN (thword "ไข่") "ฟอง" | {-pan-} mkN "ไข่" | mkN "อัณฑะ" | mkN "เล็ดไข่" | mkN "พระอัณฑะ" | mkN "ลูกอัณฑะ" | mkN "ลูกกระแป๋ง" | mkN "ไข่" ; -- src=panlex
lin reasonable_A = mkA "พอสมควร" | mkA "เหมาะสม" | mkA "มีเหตุผล" | mkA "ไม่แพงไป" | mkA "ไม่เกินไป" | mkA "ราคาพอสมควร" ; -- src=panlex
lin onto_Prep = mkPrep "ไปยัง" | mkPrep "รู้ถึง" | mkPrep "เข้าใจ" ; -- src=panlex
lin retain_V2 = variants{} ; -- 
lin aircraft_N = mkN "ยานอากาศ" | mkN "อากาศยาน" | mkN "สิ่งต่างๆ ที่สร้างสําหรับการบิน" | mkN "เครื่องบิน" ; -- src=panlex
lin decade_N = mkN "๑๐" | mkN "สิบ" | mkN "ทศวรรษ" | mkN "10" | mkN "สิบปี" | mkN "ทศวรรษ" | mkN "รอบสิบปี" | mkN "กลุ่มที่ประกอบด้วยสิบ" | mkN "ระยะเวลา 10 ปี" | mkN "กลุ่มที่ประกอบด้วย10" ; -- src=panlex
lin cheap_A = mkA "ถูก" | mkA "ห่วย" | mkA "ไม่แพง" | mkA "ประหยัด" | mkA "ย่อมเยา" | mkA "ห่วยแตก" | mkA "ซังกะบ๊วย" | mkA "ที่ราคาถูก" | mkA "ที่มีราคาถูก" | mkA "ถูก" | mkA "ขวยใจ" | mkA "ตระหนี่" | mkA "ย่อมเยา" | mkA "ราคาถูก" | mkA "หยาบคาย" | mkA "ขั้นต่ํา" | mkA "ราคาต่ํา" | mkA "ขี้เหนียว" | mkA "คุณภาพต่ํา" | mkA "ไร้ศีลธรรม" | mkA "ราคาประหยัด" | mkA "ราคาย่อมเยา" | mkA "ซึ่งได้มาง่าย" ; -- src=panlex
lin quiet_A = mkA "เงียบ" | mkA "ราบเรียบ" | mkA "ที่สงบอยู่" | mkA "สงบ" | mkA "เงียบ" | mkA "สงบเงียบ" | mkA "สงบเสงี่ยม" | mkA "ไม่มีมารยา" | mkA "ไม่เสแสร้ง" ; -- src=panlex
lin bright_A = mkA "จ้า" | mkA "สว่าง" | mkA "เจิดจ้า" | mkA "ซึ่งมีความหวัง" | mkA "ใส" | mkA "จ้า" | mkA "ฉาน" | mkA "ฉลาด" | mkA "สดใส" | mkA "เร็ว" | mkA "สว่าง" | mkA "หัวไว" | mkA "ฉูดฉาด" | mkA "สีสดใส" | mkA "แจ่มใส" | mkA "ร่าเริง" | mkA "หลักแหลม" | mkA "โชติช่วง" | mkA "สีเจิดจ้า" | mkA "เฉียบแหลม" | mkA "มีชีวิตชีวา" | mkA "มีชื่อเสียงโด่งดัง" ; -- src=panlex
lin contribute_V2 = mkV2 "ให้" ; ---- | mkV "เพิ่มระดับ" | mkV "มีส่วนทำให้" | mkV "เพิ่มคุณภาพ" | mkV "ทำให้บังเกิด" | mkV "มีส่วนทําให้" ; -- src=panlex
lin contribute_V = mkV "ให้" | mkV "เพิ่มระดับ" | mkV "มีส่วนทำให้" | mkV "เพิ่มคุณภาพ" | mkV "ทำให้บังเกิด" | mkV "มีส่วนทําให้" ; -- src=panlex
lin row_N = mkN "แถว" | mkN "แนว" | mkN "พายเรือ" | mkN "การโต้เถียง" | mkN "กีฬาพายเรือ" | mkN "ทิว" | mkN "แถว" | mkN "แนว" | mkN "แผง" | mkN "การทะเลาะวิวาท" | mkN "เสียงเอะอะโวยวาย" | mkN "เสียงทะเลาะตึงตัง" | mkN "ถนนที่มีตึกอยู่สองข้าง" ; -- src=panlex
lin search_N = mkN "การค้นหา" | mkN "การค้นหาคำตอบ" | mkN "ค้นคว้า" | mkN "การค้นหา" | mkN "การเสาะหา" | mkN "การแสวงหา" | mkN "การตรวจค้น" | mkN "การตรวจจับ" | mkN "การตรวจสอบ" | mkN "การหาข้อมูล" ; -- src=panlex
lin limit_N = mkN "จุดสะสม" | mkN "ขีดจำกัด" | mkN "เขต" | mkN "ขอบเขต" | mkN "ขีดสุด" | mkN "วงจํากัด" | mkN "ขีดกําหนด" | mkN "ขีดจํากัด" | mkN "ขีดสูงสุด" ; -- src=panlex
lin definition_N = mkN "นิยาม" | mkN "คำนิยาม" | mkN "ความชัดเจน" | mkN "บทนิยาม" | mkN "คํานิยาม" | mkN "การกําหนด" | mkN "การจํากัดวง" | mkN "คําจํากัดความ" | mkN "ความคมชัดของภาพ" | mkN "การอธิบายความหมาย" | mkN "คําอธิบายความหมาย" | mkN "ความคมหรือความชัดของภาพ" ; -- src=panlex
lin unemployment_N = mkN "การว่างงาน" | mkN "การตกงาน" | mkN "การว่างงาน" | mkN "การไม่มีงานทํา" | mkN "จํานวนผู้ว่างงาน" | mkN "ตัวเลขผู้ว่างงาน" ; -- src=panlex
lin spread_V2 = mkV2 "กาง" ; ---- | mkV "แพร่" | mkV "กระจาย" | mkV "เกลี่ย" | mkV "เผยแพร่" | mkV "แพร่หลาย" | mkV "วางด้านบน" | mkV "กระจายกำลัง" | mkV "ทำให้แพร่หลาย" | mkV "แพร่หลาย" | mkV "แพร่กระจาย" | mkV "กระจายไปทั่ว" | mkV "ทําให้กระจาย" ; -- src=panlex
lin spread_V = mkV "กาง" | mkV "แพร่" | mkV "กระจาย" | mkV "เกลี่ย" | mkV "เผยแพร่" | mkV "แพร่หลาย" | mkV "วางด้านบน" | mkV "กระจายกำลัง" | mkV "ทำให้แพร่หลาย" | mkV "แพร่หลาย" | mkV "แพร่กระจาย" | mkV "กระจายไปทั่ว" | mkV "ทําให้กระจาย" ; -- src=panlex
lin mark_N = mkN "ตรา" | mkN "รอย" | mkN "เกรด" | mkN "เป้า" | mkN "แต้ม" | mkN "กากบาท" | mkN "คนซื่อ" | mkN "รอยบาก" | mkN "รอยแผล" | mkN "แผลเป็น" | mkN "เป้าหมาย" | mkN "รอยเปื้อน" | mkN "สัญลักษณ์" | mkN "คนหลอกง่าย" | mkN "รอยแผลเป็น" | mkN "เครื่องหมาย" | mkN "ตราสัญลักษณ์" | mkN "คนเชื่อคนง่าย" | mkN "หน่วยเงินมาร์ค" | mkN "การประสบความสำเร็จ" | mkN "กะ" | mkN "ไฝ" | mkN "จุด" | mkN "ชัด" | mkN "ปาน" | mkN "รอย" | mkN "หมาย" | mkN "เป้า" | mkN "เส้น" | mkN "แต้ม" | mkN "คะแนน" | mkN "ระดับ" | mkN "ระวัง" | mkN "เกณฑ์" | mkN "แกงได" | mkN "ตําหนิ" | mkN "ท่าทาง" | mkN "ทํารอย" | mkN "บันทึก" | mkN "พรมแดน" | mkN "ลักษณะ" | mkN "สังเกต" | mkN "มาตรฐาน" | mkN "มุ่งหมาย" | mkN "เป้าหมาย" | mkN "เพ่งเล็ง" | mkN "ชื่อเสียง" | mkN "สัญลักษณ์" | mkN "เป็นมลทิน" | mkN "ความสําคัญ" | mkN "จุดประสงค์" | mkN "รอยแผลเป็น" | mkN "เส้นสตาร์ท" | mkN "ลักษณะเฉพาะ" | mkN "เครื่องหมาย" | mkN "วัตถุประสงค์" | mkN "ทําให้เป็นจุด" | mkN "แสดงให้ปรากฎชัด" | mkN "รอยตวัดลายเซ็นต์" | mkN "เส้นเริ่มออกวิ่ง" | mkN "ทําให้เป็นแผลเป็น" | mkN "รอยขีดแทนลายเซ็นต์" ; -- src=panlex
lin flight_N = mkN "บันได" | mkN "การบิน" | mkN "แนววิถี" | mkN "ฝูงนกบิน" | mkN "การหลบหนี" | mkN "เที่ยวบิน" | mkN "การบิน" | mkN "การหนี" | mkN "การหลบหนี" | mkN "การหายวับ" | mkN "ขั้นบันได" | mkN "เที่ยวบิน" | mkN "กองบินน้อย" | mkN "การพุ่งตัวของวัตถุ" | mkN "การเจริญอย่างรวดเร็ว" | mkN "ขั้นบันไดระหว่างชั้น" | mkN "การเดินทางด้วยเครื่องบิน" | mkN "การเคลื่อนที่อย่างรวดเร็ว" | mkN "การเคลื่อนที่ของวัตถุผ่านอากาศ" | mkN "นกหรือเครื่องบินที่บินเป็นฝูงองทัพ" ; -- src=panlex
lin account_V2 = mkV2 "อธิบาย" ; ---- | mkV "รับผิดชอบ" | mkV "หาคำอธิบาย" | mkV "พิจารณา" | mkV "ประเมินค่า" | mkV "ทํารายการบัญชี" | mkV "ทําบัญชีรายรับรายจ่าย" ; -- src=panlex
lin account_V = mkV "อธิบาย" | mkV "รับผิดชอบ" | mkV "หาคำอธิบาย" | mkV "พิจารณา" | mkV "ประเมินค่า" | mkV "ทํารายการบัญชี" | mkV "ทําบัญชีรายรับรายจ่าย" ; -- src=panlex
lin output_N = mkN "ผลผลิต" | mkN "เอาต์พุต" | mkN "ปริมาณผลผลิต" | mkN "ปริมาณการผลิต" | mkN "สัญญาณเอาต์พุต" | mkN "ผลผลิต" | mkN "ผลิตผล" | mkN "การผลิต" | mkN "ผลิตภัณฑ์" | mkN "ข้อมูลที่ส่งออกมา" | mkN "ปริมาณของสิ่งที่ผลิตได้" | mkN "ข้อมูลที่ได้จากคอมพิวเตอร์" | mkN "ปริมาณหรือจํานวนที่ผลิตได้" ; -- src=panlex
lin last_V = mkV "รอดตาย" | mkV "รอดชีวิต" | mkV "มีชีวิตรอด" | mkV "มีความทนทาน" | mkV "มีอายุการใช้งาน" | mkV "อยู่" | mkV "คงอยู่" | mkV "อยู่นาน" | mkV "ยังคงดําเนินต่อไป" ; -- src=panlex
lin tour_N = mkN "ทัวร์" | mkN "การท่องเที่ยว" | mkN "ระยะเวลาการปฏิบัติหน้าที่" | mkN "การท่องเที่ยวไปชมสถานที่ต่างๆ" | mkN "เกมการแข่งขันที่แข่งต่อเนื่องกันโดยทีมเดียว" ; -- src=panlex
lin address_N = mkN "ปฏิภาณ" | mkN "ที่อยู่" | mkN "ป้ายบริษัท" | mkN "ชื่อที่อยู่" | mkN "ป้ายร้านค้า" | mkN "ป้ายชื่อบ้าน" | mkN "การจ่าหน้าซอง" | mkN "มารยาททางสังคม" | mkN "ที่พัก" | mkN "ที่อยู่" | mkN "สุนทรพจน์" | mkN "หลักแหล่ง" | mkN "คําปราศรัย" | mkN "ที่อยู่อาศัย" | mkN "กระแสพระราชดํารัส" ; -- src=panlex
lin immediate_A = mkA "ทันที" | mkA "ปุบปับ" | mkA "โดยตรง" | mkA "ฉับพลัน" | mkA "รวดเร็ว" | mkA "ใกล้ชิด" | mkA "ไม่รีรอ" | mkA "กะทันหัน" | mkA "ทันทีทันใด" | mkA "ที่ส่งผลโดยตรง" | mkA "ปัจจุบันทันด่วน" ; -- src=panlex
lin reduction_N = mkN "รีดักชั่น" | mkN "การทำให้ลดลง" | mkN "การลดความซับซ้อน" | mkN "การทด" | mkN "การทอน" | mkN "การย่อ" | mkN "การลดลง" | mkN "การทําให้หด" | mkN "การทําให้เจือจาง" | mkN "การเพิ่มไฮโดรเจนแก่สาร" | mkN "การได้อิเล็กตรอนของสาร" | mkN "การเอาออกซิเจนออกจากออกไซด์" ; -- src=panlex
lin interview_N = mkN "การสัมภาษณ์" | mkN "การเข้าหารือ" | mkN "การสัมภาษณ์" | mkN "การเข้าพบเพื่อสอบถาม" ; -- src=panlex
lin assess_V2 = variants{} ; -- 
lin promote_V2 = mkV2 "โฆษณา" ; ---- | mkV "ต่อให้" | mkV "โปรโมท" | mkV "ส่งเสริม" | mkV "เลื่อนขั้น" | mkV "เลื่อนชั้น" | mkV "เปลี่ยนหมาก" | mkV "ประชาสัมพันธ์" | mkV "เลื่อนตำแหน่ง" | mkV "โฆษณาประชาสัมพันธ์" | mkV "โฆษณา" | mkV "ส่งเสริม" | mkV "เลื่อนตําแหน่ง" | mkV "ช่วยเหลือให้ดีขึ้น" ; -- src=panlex
lin promote_V = mkV "โฆษณา" | mkV "ต่อให้" | mkV "โปรโมท" | mkV "ส่งเสริม" | mkV "เลื่อนขั้น" | mkV "เลื่อนชั้น" | mkV "เปลี่ยนหมาก" | mkV "ประชาสัมพันธ์" | mkV "เลื่อนตำแหน่ง" | mkV "โฆษณาประชาสัมพันธ์" | mkV "โฆษณา" | mkV "ส่งเสริม" | mkV "เลื่อนตําแหน่ง" | mkV "ช่วยเหลือให้ดีขึ้น" ; -- src=panlex
lin everybody_NP = mkNP (thword "ทุก" "คน") ;
lin suitable_A = mkA "สมควร" | mkA "เหมาะ" | mkA "เหมาะสม" | mkA "คู่ควรกับ" ; -- src=panlex
lin growing_A = mkA "อย่างมากขึ้น" | mkA "ีอย่างเพิ่มขึ้น" ; -- src=panlex
lin nod_V = mkV "ผงก" | mkV "ผงกหัว" | mkV "สัปหงก" | mkV "นอนคอพับ" | mkV "ผงกศีรษะ" | mkV "พยักหน้า" | mkV "พยักพเยิด" | mkV "ผงกศรีษะรับ" | mkV "พยักหน้ารับ" | mkV "แสดงอาการรับรู้" ; -- src=panlex
lin reject_V2 = variants{} ; -- 
lin while_N = mkN "แม้ว่า" | mkN "ชั่วขณะ" | mkN "ขณะหนึ่ง" | mkN "ตลอดเวลา" | mkN "พักหนึ่ง" | mkN "ในขณะที่" | mkN "ถึงแม้ว่า" | mkN "ชั่วขณะหนึ่ง" | mkN "ชั่วประเดี๋ยว" | mkN "ในเวลาเดียวกัน" ; -- src=panlex
lin high_Adv = mkAdv "สูง" | mkAdv "อยู่สูง" | mkAdv "สูงขึ้นไป" | mkAdv "อย่างหรูหรา" ; -- src=panlex
lin dream_N = mkN "ฝัน" | mkN "สุบิน" | mkN "ความฝัน" | mkN "พระสุบิน" | mkN "การวาดฝัน" | mkN "ความคิดฝัน" | mkN "ความใฝ่ฝัน" | mkN "การวาดวิมานในอากาศ" | mkN "ความฝัน" | mkN "จิตนาการ" | mkN "ความคิดฝัน" | mkN "ความใฝ่ฝัน" | mkN "ความทะเยอทะยาน" ; -- src=panlex
lin vote_VV = mkVV "โหวต" ; ---- | mkV "ลงคะแนนเสียง" | mkV "ลงคะแนน" | mkV "เสนอแนะ" | mkV "ออกเสียง" | mkV "ลงคะแนนเสียง" ; -- src=panlex
lin vote_V3 = mkV3 "โหวต" ; ---- | mkV "ลงคะแนนเสียง" | mkV "ลงคะแนน" | mkV "เสนอแนะ" | mkV "ออกเสียง" | mkV "ลงคะแนนเสียง" ; -- src=panlex
lin vote_V2 = mkV2 "โหวต" ; ---- | mkV "ลงคะแนนเสียง" | mkV "ลงคะแนน" | mkV "เสนอแนะ" | mkV "ออกเสียง" | mkV "ลงคะแนนเสียง" ; -- src=panlex
lin vote_V = mkV "โหวต" | mkV "ลงคะแนนเสียง" | mkV "ลงคะแนน" | mkV "เสนอแนะ" | mkV "ออกเสียง" | mkV "ลงคะแนนเสียง" ; -- src=panlex
lin divide_V2 = mkV2 "หาร" ; ---- | mkV "แยก" | mkV "คั่น" | mkV "หั่น" | mkV "แบ่ง" | mkV "เฉลี่ย" | mkV "ทำให้แยกออกมา" | mkV "แยก" | mkV "แบ่ง" | mkV "แบ่งแยก" | mkV "แยกเป็นสองส่วน" ; -- src=panlex
lin divide_V = mkV "หาร" | mkV "แยก" | mkV "คั่น" | mkV "หั่น" | mkV "แบ่ง" | mkV "เฉลี่ย" | mkV "ทำให้แยกออกมา" | mkV "แยก" | mkV "แบ่ง" | mkV "แบ่งแยก" | mkV "แยกเป็นสองส่วน" ; -- src=panlex
lin declare_VS = mmkVS "ตัดสิน" ; ---- | mkV "แจ้ง" | mkV "แถลง" | mkV "เรียก" | mkV "กําหนด" | mkV "ประกาศ" | mkV "ยืนยัน" | mkV "รับรอง" | mkV "สินค้า" | mkV "สําแดง" | mkV "เปิดเผย" | mkV "เปิดโปง" | mkV "แถลงการณ์" | mkV "ออกคําสั่ง" | mkV "แสดงหลักฐาน" | mkV "แสดงรายการตามข้อกําหนด เช่น ภาษี" ; -- src=panlex
lin declare_V2 = mkV2 "ตัดสิน" ; ---- | mkV "แจ้ง" | mkV "แถลง" | mkV "เรียก" | mkV "กําหนด" | mkV "ประกาศ" | mkV "ยืนยัน" | mkV "รับรอง" | mkV "สินค้า" | mkV "สําแดง" | mkV "เปิดเผย" | mkV "เปิดโปง" | mkV "แถลงการณ์" | mkV "ออกคําสั่ง" | mkV "แสดงหลักฐาน" | mkV "แสดงรายการตามข้อกําหนด เช่น ภาษี" ; -- src=panlex
lin declare_V = mkV "ตัดสิน" | mkV "แจ้ง" | mkV "แถลง" | mkV "เรียก" | mkV "กําหนด" | mkV "ประกาศ" | mkV "ยืนยัน" | mkV "รับรอง" | mkV "สินค้า" | mkV "สําแดง" | mkV "เปิดเผย" | mkV "เปิดโปง" | mkV "แถลงการณ์" | mkV "ออกคําสั่ง" | mkV "แสดงหลักฐาน" | mkV "แสดงรายการตามข้อกําหนด เช่น ภาษี" ; -- src=panlex
lin handle_V2 = mkV2 "จับ" ; ---- | mkV "ฝึก" | mkV "ทรีต" | mkV "จัดการ" | mkV "แมนเนจ" | mkV "กวัดแกว่ง" | mkV "มีเนื้อหา" | mkV "ใช้มือจับ" | mkV "ปฏิบัติต่อ" | mkV "บริหารจัดการ" | mkV "จับ" | mkV "ถือ" | mkV "ดูแล" | mkV "จัดการ" ; -- src=panlex
lin handle_V = mkV "จับ" | mkV "ฝึก" | mkV "ทรีต" | mkV "จัดการ" | mkV "แมนเนจ" | mkV "กวัดแกว่ง" | mkV "มีเนื้อหา" | mkV "ใช้มือจับ" | mkV "ปฏิบัติต่อ" | mkV "บริหารจัดการ" | mkV "จับ" | mkV "ถือ" | mkV "ดูแล" | mkV "จัดการ" ; -- src=panlex
lin detailed_A = mkA "อย่างละเอียด" | mkA "ซึ่งมีรายละเอียดมาก" ; -- src=panlex
lin challenge_N = mkN "การท้า" | mkN "การท้าทาย" | mkN "การคัดค้าน" | mkN "คำถามท้าทาย" | mkN "การเรียกร้อง" | mkN "การท้าทาย" | mkN "สิ่งที่ท้าทาย" ; -- src=panlex
lin notice_N = mkN "ประกาศ" | mkN "โปสเตอร์" | mkN "ใบประกาศ" | mkN "ป้ายโฆษณา" | mkN "การแจ้งหนี้" | mkN "การแจ้งชำระหนี้" | mkN "การสังเกต" | mkN "ข้อสังเกต" | mkN "ใบแจ้งหนี้" | mkN "การแจ้งล่วงหน้า" ; -- src=panlex
lin rain_N = mkN (thword "ฝน") | {-pan-} mkN "ฝน" | mkN "น้ำฝน" | mkN "สายฝน" | mkN "ห่าฝน" | mkN "ฝน" | mkN "ฤดูฝน" | mkN "น้ําฝน" | mkN "หน้าฝน" | mkN "ให้อย่างมากมาย" | mkN "เสนอให้อย่างมากมาย" | mkN "ทําให้ตกลงมาเป็นจํานวนมาก" ; -- src=panlex
lin destroy_V2 = variants{} ; -- 
lin mountain_N = mkN (thword "เขา") | {-pan-} mkN "เขา" | mkN "กลุ่ม" | mkN "ภูเขา" | mkN "ขุนเขา" | mkN "มากมาย" | mkN "จำนวนมาก" | mkN "จำนวนมากมายก่ายกอง" | mkN "ภู" | mkN "ดอย" | mkN "เขา" | mkN "คิริ" | mkN "ภูเขา" | mkN "กองใหญ่" | mkN "กองมหึมา" | mkN "เทือกเขา" | mkN "กองพะเนิน" ; -- src=panlex
lin concentration_N = mkN "การรวบรวม" | mkN "ความหนาแน่น" | mkN "ความเข้มข้น" | mkN "การตั้งสมาธิ" | mkN "การรวบรวมสมาธิ" | mkN "การมีสมาธิจดจ่อ" | mkN "ความขยันหมั่นเพียร" | mkN "การรวมพล" | mkN "ความเข้มข้น" | mkN "การให้ความสนใจ" | mkN "ภาวะที่เข้มข้น" | mkN "สิ่งที่เข้มข้น" | mkN "ความตั้งอกตั้งใจ" | mkN "ระดับความเข้มข้น" | mkN "สารที่มีความเข้มข้น" | mkN "การมุ่งไปยังศูนย์กลาง" | mkN "ความใส่ใจในสาขาวิชาหนึ่ง" ; -- src=panlex
lin limited_A = mkA "ที่จำกัด" | mkA "ที่ไม่เกิน" | mkA "ที่อยู่ในวงแคบ" | mkA "ที่รวมเพียงส่วนหนึ่ง" | mkA "ที่มีขอบเขต" | mkA "ที่ถูกจํากัด" | mkA "ที่มีขีดขั้น" ; -- src=panlex
lin finance_N = mkN "การเงิน" | mkN "สาขาการเงิน" | mkN "ธุรกิจการเงิน" | mkN "การจัดการทางการเงิน" | mkN "การคลัง" | mkN "การเงิน" | mkN "แหล่งเงิน" | mkN "ให้เครดิตแก่" ; -- src=panlex
lin pension_N = mkN "บำนาญ" | mkN "เงินบำนาญ" | mkN "เบี้ยบำนาญ" | mkN "บํานาญ" | mkN "เงินบํานาญ" | mkN "เบี้ยบํานาญ" | mkN "เงินช่วยเหลือ" | mkN "เงินสงเคราะห์" ; -- src=panlex
lin influence_V2 = variants{} ; -- 
lin afraid_A = mkA "กลัว" | mkA "กลัว" | mkA "เกรง" | mkA "เกรงว่า" | mkA "กลัวเกรง" | mkA "หวาดกลัว" | mkA "หวาดหวั่น" ; -- src=panlex
lin murder_N = mkN "ฆาตกรรม" | mkN "การฆาตกรรม" | mkN "ทําลาย" | mkN "ฆาตกรรม" | mkN "การฆ่าฟัน" | mkN "การสังหาร" | mkN "การฆาตกรรม" ; -- src=panlex
lin neck_N = mkN (thword "คอ") | {-pan-} mkN "คอ" | mkN "ศอ" | mkN "คอคอด" | mkN "พระศอ" | mkN "ส่วนคอ" | mkN "คอเสื้อ" | mkN "เนื้อส่วนคอ" | mkN "คอ" | mkN "ศอ" | mkN "คอขวด" | mkN "ช่วงคอ" | mkN "ส่วนคอ" | mkN "คอเสื้อ" | mkN "ช่องแคบ" | mkN "ส่วนที่แคบเข้ามา" ; -- src=panlex
lin weapon_N = mkN "อาวุธ" | mkN "อาวุธ" | mkN "สิ่งที่ใช้ต่อสู้กับคู่อริ" ; -- src=panlex
lin hide_V2 = mkV2 "ซ่อน" ; ---- | mkV "ปกปิด" | mkV "ซ่อนตัว" | mkV "หลบซ่อน" | mkV "เร้นกาย" | mkV "ซ่อนเร้น" | mkV "ซ่อน" | mkV "ปกปิด" | mkV "ซุกซ่อน" ; -- src=panlex
lin hide_V = mkV "ซ่อน" | mkV "ปกปิด" | mkV "ซ่อนตัว" | mkV "หลบซ่อน" | mkV "เร้นกาย" | mkV "ซ่อนเร้น" | mkV "ซ่อน" | mkV "ปกปิด" | mkV "ซุกซ่อน" ; -- src=panlex
lin offence_N = mkN "ทีมบุก" | mkN "ฝ่ายบุก" | mkN "อาชญากรรม" | mkN "ความไม่สุภาพ" | mkN "การโจมตีศัตรู" | mkN "การก่ออาชญากรรม" | mkN "การรุก" | mkN "ฝ่ายรุก" | mkN "การโจมตี" | mkN "ฝ่ายโจมตี" | mkN "การก้าวร้าว" | mkN "การกระทําผิด" | mkN "สิ่งที่ละเมิด" | mkN "การทําให้ไม่พอใจ" | mkN "การกระทําผิดกฎหมาย" | mkN "การทําให้ขุ่นเคือง" | mkN "ความรู้สึกขุ่นเคือง" | mkN "สิ่งที่ทําให้ขุ่นเคือง" ; -- src=panlex
lin absence_N = mkN "การไม่มี" | mkN "ช่วงเวลาที่ไม่อยู่" | mkN "การขาด" | mkN "การขาดแคลน" | mkN "การไม่อยู่" | mkN "การไม่มีตัวตน" | mkN "การไม่ปรากฏตัว" | mkN "ช่วงเวลาที่ไม่อยู่" | mkN "ระยะเวลาที่ไม่อยู่" ; -- src=panlex
lin error_N = mkN "เออเรอร์" | mkN "จุดผิดพลาด" | mkN "ความบกพร่อง" | mkN "ความผิดพลาด" | mkN "คอมพิวเตอร์เออเรอร์" | mkN "บาป" | mkN "คําผิด" | mkN "ความผิด" | mkN "ข้อผิดพลาด" | mkN "ความผิดพลาด" | mkN "การกระทําผิด" | mkN "ความเชื่อที่ผิด" | mkN "สิ่งที่กระทําผิด" ; -- src=panlex
lin representativeMasc_N = variants{} ; -- 
lin enterprise_N = mkN "บรรษัท" | mkN "บริษัท" | mkN "ความกระตือรือร้น" | mkN "กิจการ" | mkN "บริษัท" | mkN "โครงการ" | mkN "วิสาหกิจ" | mkN "อุตสาหกิจ" | mkN "ความกล้าเสี่ยง" | mkN "โครงการที่เสี่ยง" | mkN "ความกล้าได้กล้าเสีย" ; -- src=panlex
lin criticism_N = mkN "การวิจารณ์" | mkN "การวิพากษ์วิจารณ์" | mkN "การวิจารณ์วรรณกรรม" | mkN "งานวิจารณ์วรรณกรรม" | mkN "การวิจารณ์ข้อผิดพลาด" | mkN "การจับผิด" | mkN "บทวิจารณ์" | mkN "การติเตียน" | mkN "การวิจารณ์" | mkN "วิธีการวิจารณ์" | mkN "การประเมินผลงาน" ; -- src=panlex
lin average_A = mkA "เฉลี่ย" | mkA "ปานกลาง" | mkA "โดยเฉลี่ย" | mkA "เฉลี่ย" | mkA "ปานกลาง" | mkA "โดยเฉลี่ย" ; -- src=panlex
lin quick_A = mkA "หัวไว" | mkA "ว่องไว" | mkA "ที่มีไหวพริบ" | mkA "ที่มีเชาว์ปัญญา" | mkA "ที่มีไหวพริบปฏิภาณ" | mkA "ไว" | mkA "ฉลาด" | mkA "เร็ว" | mkA "ฉับไว" | mkA "ใจร้อน" | mkA "รวดเร็ว" | mkA "แก่นแท้" | mkA "ไม่อดทน" | mkA "หลักแหลม" | mkA "ีรีบร้อน" | mkA "คล่องแคล่ว" | mkA "ทันทีทันใด" | mkA "ีที่ว่องไว" | mkA "ีที่แหลมคม" | mkA "ีที่เข้าใจง่าย" ; -- src=panlex
lin sufficient_A = mkA "พอ" | mkA "พอใจ" | mkA "พอเพียง" | mkA "เต็มที่" ; -- src=panlex
lin appointment_N = mkN "การตกแต่ง" | mkN "การนัดหมาย" | mkN "การแต่งตั้ง" | mkN "การนัดหมายล่วงหน้า" | mkN "ผู้ได้รับมอบหมายให้ดำรงตำแหน่ง" | mkN "งาน" | mkN "อุปกรณ์" | mkN "การนัดพบ" | mkN "ตําแหน่ง" | mkN "การนัดหมาย" | mkN "การแต่งตั้ง" | mkN "เครื่องแต่งตัว" | mkN "ผู้ที่ได้รับการแต่งตั้ง" ; -- src=panlex
lin match_V2 = variants{} ; -- 
lin transfer_V = mkV "พา" | mkV "ยก" | mkV "ส่ง" | mkV "โอน" | mkV "ย้าย" | mkV "โยกย้าย" | mkV "ย้ายที่ปลูก" | mkV "เปลี่ยนเส้นทาง" | mkV "จากที่หนึ่งไปอีกที่หนึ่ง" | mkV "ส่ง" | mkV "โอน" | mkV "ย้าย" | mkV "ขนส่ง" | mkV "ขนถ่าย" | mkV "ขนย้าย" | mkV "ถ่ายเท" | mkV "ถ่ายทอด" | mkV "ยักย้าย" | mkV "ส่งผ่าน" | mkV "เปลี่ยน" | mkV "โยกย้าย" | mkV "ปลูกถ่าย" | mkV "เปลี่ยนมือ" | mkV "เคลื่อนย้าย" | mkV "โอนตําแหน่ง" | mkV "เปลี่ยนตําแหน่ง" ; -- src=panlex
lin acid_N = mkN "กรด" | mkN "แอซิด" | mkN "กรด" | mkN "รุนแรง" | mkN "เปรี้ยว" | mkN "ฉุนเฉียว" | mkN "สิ่งที่เปรี้ยว" | mkN "คําพูดที่แหลมคม" | mkN "คําพูดที่เสียดสี" | mkN "ของเหลวที่มีสภาพเป็นกรด" | mkN "ของเหลวที่มีฤทธิ์เป็นกรด" | mkN "คําพูดที่ทําให้รู้สึกแสบร้อน" | mkN "ยาเสพติดชนิดหนึ่งที่มีฤทธิ์หลอนประสาทรุนแรง" ; -- src=panlex
lin spring_N = variants{} ; -- 
lin birth_N = mkN "การเกิด" | mkN "เวลาเกิด" | mkN "เด็กแรกเกิด" | mkN "การให้กำเนิด" | mkN "ความเป็นพ่อแม่" | mkN "การคลอด" | mkN "การเกิด" | mkN "การออกลูก" | mkN "ต้นกําเนิด" | mkN "จุดเริ่มต้น" | mkN "การสืบสายเลือด" ; -- src=panlex
lin ear_N = mkN (thword "หู") | {-pan-} mkN "หู" | mkN "ฝัก" | mkN "รวง" | mkN "ใบหู" | mkN "การฟัง" | mkN "ได้ยิน" | mkN "พระกรรณ" | mkN "หู" | mkN "กรรณ" | mkN "ใบหู" | mkN "รวงข้าว" | mkN "ความสนใจ" | mkN "ความตั้งใจ" | mkN "รวงของธัญพืช" | mkN "การสดับรับฟัง" | mkN "ความสามารถในการแยกฟังเสียง" ; -- src=panlex
lin recognize_VS = variants{} ; -- 
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin recommend_V2V = variants{} ; -- 
lin recommend_V2 = variants{} ; -- 
lin module_N = mkN "โมดูล" | mkN "" | mkN "เกณฑ์ในการวัด" | mkN "มาตรฐานในการวัด" | mkN "หลักสูตรการศึกษา" ; -- src=panlex
lin instruction_N = mkN "การสอน" | mkN "คำแนะนำ" | mkN "การศึกษา" | mkN "การเรียน" | mkN "ข้อความสั่ง" | mkN "การสอนหนังสือ" | mkN "การเรียนการสอน" | mkN "การสอน" | mkN "คําสอน" | mkN "คําสั่ง" | mkN "วิธีสอน" | mkN "วิธีใช้" | mkN "การศึกษา" | mkN "การชี้แนะ" | mkN "การแนะนํา" | mkN "คําแนะนํา" | mkN "การสั่งสอน" | mkN "วิธีการใช้" ; -- src=panlex
lin democratic_A = mkA "ที่เป็นประชาธิปไตย" | mkA "เกียวกับความเสมอภาค" | mkA "เกี่ยวกับประชาธิปไตย" | mkA "เกี่ยวกับความเสมอภาคของสังคม" ; -- src=panlex
lin park_N = mkN "ทุ่ง" | mkN "ปาร์ก" | mkN "ที่จอดรถ" | mkN "ทุ่งหญ้า" | mkN "สนามเบสบอล" | mkN "สวนสาธารณะ" | mkN "ฝากไว" | mkN "วนอุทยาน" | mkN "สวนสาธารณะ" | mkN "สถานที่พักผ่อนสาธารณะ" ; -- src=panlex
lin weather_N = mkN "สภาพอากาศ" | mkN "ลมแรง" | mkN "อากาศ" | mkN "ภูมิอากาศ" | mkN "สภาพอากาศ" | mkN "ดินฟ้าอากาศ" | mkN "สภาพบรรยากาศ" | mkN "สภาพอากาศที่ไม่ดี" | mkN "สภาพอากาศที่เลวร้าย" ; -- src=panlex
lin bottle_N = mkN "ขวด" | mkN "ขวดนม" | mkN "ปริมาณเต็มขวด" | mkN "ขวด" ; -- src=panlex
lin address_V2 = variants{} ; -- 
lin bedroom_N = mkN "ห้องนอน" | mkN "ห้องพระบรรทม" | mkN "ที่หลับที่นอน" | mkN "ห้องนอน" ; -- src=panlex
lin kid_N = mkN "ลูก" | mkN "บุตร" | mkN "เด็ก" | mkN "ลูกแพะ" | mkN "พยานรัก" | mkN "บุตรธิดา" | mkN "ผู้เยาว์" | mkN "เลือดในอก" | mkN "หนังลูกแพะ" | mkN "โซ่ทองคล้องใจ" | mkN "เลือดเนื้อเชื้อไข" | mkN "หนังลูกแพะ" ; -- src=panlex
lin pleasure_N = mkN "ความสุข" | mkN "สิ่งที่ทำให้พอใจ" | mkN "ความพึงพอใจทางเพศ" | mkN "พอใจ" | mkN "ความสุข" | mkN "ความดีใจ" | mkN "ความพอใจ" | mkN "ความสบาย" | mkN "ความถูกใจ" | mkN "ความยินดี" | mkN "ความหรรษา" | mkN "ความต้องการ" | mkN "ความบันเทิง" | mkN "ความปรารถนา" | mkN "ทําให้ถูกใจ" | mkN "ความรื่นเริง" | mkN "ความสนุกสนาน" | mkN "ความปิติยินดี" | mkN "ความรู้สึกพอใจ" ; -- src=panlex
lin realize_VS = variants{} ; -- 
lin realize_V2 = variants{} ; -- 
lin assembly_N = mkN "ชุมนุม" | mkN "จุดนัดพบ" | mkN "การชุมนุม" | mkN "การประกอบ" | mkN "การรวมตัว" | mkN "การรวมกลุ่ม" | mkN "การทํา" | mkN "สมัชชา" | mkN "กลุ่มคน" | mkN "การสร้าง" | mkN "ชิ้นส่วน" | mkN "ชุมนุมชน" | mkN "การชุมนุม" | mkN "การประกอบ" | mkN "การประชุม" | mkN "การมั่วสุม" | mkN "การเคลื่อน" | mkN "ส่วนประกอบ" | mkN "การรวมกลุ่ม" | mkN "สัญญาณรวมพล" | mkN "ที่ประชุมสภา" | mkN "คนที่รวมตัวกัน" | mkN "เข้าสู่บริเวณหนึ่ง" | mkN "ประกอบชิ้นส่วนต่าง ๆ ของเครื่องจักร" ; -- src=panlex
lin expensive_A = mkA "แพง" | mkA "แพง" | mkA "ราคาสูง" | mkA "มีราคาแพง" | mkA "สิ้นเปลือง" | mkA "มีราคาสูงมาก" ; -- src=panlex
lin select_VV = mkVV "เลือก" ; ---- | mkV "คัด" | mkV "สรรหา" | mkV "เลือก" | mkV "คัดเลือก" | mkV "เลือกสรร" ; -- src=panlex
lin select_V2V = mmkV2V "เลือก" ; ---- | mkV "คัด" | mkV "สรรหา" | mkV "เลือก" | mkV "คัดเลือก" | mkV "เลือกสรร" ; -- src=panlex
lin select_V2 = mkV2 "เลือก" ; ---- | mkV "คัด" | mkV "สรรหา" | mkV "เลือก" | mkV "คัดเลือก" | mkV "เลือกสรร" ; -- src=panlex
lin select_V = mkV "เลือก" | mkV "คัด" | mkV "สรรหา" | mkV "เลือก" | mkV "คัดเลือก" | mkV "เลือกสรร" ; -- src=panlex
lin teaching_N = mkN "คำสอน" | mkN "การสอน" | mkN "การศึกษา" | mkN "การเรียน" | mkN "การสอนหนังสือ" | mkN "การเรียนการสอน" | mkN "การสอน" | mkN "อาชีพครู" | mkN "สิ่งที่สอน" | mkN "" | mkN "อาชีพการสอน" | mkN "เรื่องที่สอน" | mkN "วิชาชีพการสอน" ; -- src=panlex
lin desire_N = mkN "ความปรารถนา" | mkN "ราคะ" | mkN "ต้องการ" | mkN "ประสงค์" | mkN "ความอยาก" | mkN "ความต้องการ" | mkN "ความประสงค์" | mkN "ความปรารถนา" ; -- src=panlex
lin whilst_Subj = variants{} ; -- 
lin contact_V2 = variants{} ; -- 
lin implication_N = mkN "การอนุมาน" | mkN "ความสัมพันธ์แบบมีเงื่อนไข" | mkN "การพัวพัน" | mkN "สิ่งที่พัวพัน" | mkN "ความหมายโดยนัย" | mkN "สิ่งที่เกี่ยวข้อง" | mkN "การทําให้เกี่ยวข้อง" ; -- src=panlex
lin combine_VV = mkVV "ผสม" ; ---- | mkV "มิกซ์" | mkV "รวบรวม" | mkV "การรวมกลุ่ม" | mkV "ผสมเข้าด้วยกัน" | mkV "รวมกัน" | mkV "้ประสานกัน" | mkV "นํามารวมกัน" | mkV "ทําให้รวมกัน" | mkV "นํามารวมเข้าด้วยกัน" | mkV "รวมเป็นอันหนึ่งอันเดียวกัน" ; -- src=panlex
lin combine_V2 = mkV2 "ผสม" ; ---- | mkV "มิกซ์" | mkV "รวบรวม" | mkV "การรวมกลุ่ม" | mkV "ผสมเข้าด้วยกัน" | mkV "รวมกัน" | mkV "้ประสานกัน" | mkV "นํามารวมกัน" | mkV "ทําให้รวมกัน" | mkV "นํามารวมเข้าด้วยกัน" | mkV "รวมเป็นอันหนึ่งอันเดียวกัน" ; -- src=panlex
lin combine_V = mkV "ผสม" | mkV "มิกซ์" | mkV "รวบรวม" | mkV "การรวมกลุ่ม" | mkV "ผสมเข้าด้วยกัน" | mkV "รวมกัน" | mkV "้ประสานกัน" | mkV "นํามารวมกัน" | mkV "ทําให้รวมกัน" | mkV "นํามารวมเข้าด้วยกัน" | mkV "รวมเป็นอันหนึ่งอันเดียวกัน" ; -- src=panlex
lin temperature_N = mkN "อุณหภูมิ" | mkN "อุณหภูมิ" | mkN "ระดับความร้อน" | mkN "อุณหภูมิร่างกาย" ; -- src=panlex
lin wave_N = mkN "คลื่น" | mkN "ผมลอน" | mkN "รูปคลื่น" | mkN "การโบกมือ" | mkN "ระลอกคลื่น" | mkN "การเกิดคลื่น" | mkN "แรงกระเพื่อม" | mkN "ลอน" | mkN "ทะเล" | mkN "คลื่น" | mkN "โบกมือ" | mkN "การแกว่ง" | mkN "น่านน้ํา" | mkN "การเป็นลอน" | mkN "การโบกไปมา" | mkN "ระลอกคลื่น" | mkN "การหลั่งไหล" | mkN "ความหวั่นไหว" | mkN "โค้งสลับทิศทาง" | mkN "ชั่วครั้งชั่วคราว" | mkN "ทําให้เปลี่ยนแปลง" | mkN "การเคลื่อนตัวเป็นกลุ่ม" | mkN "เคลื่อนตัวเป็นรูปคลื่น" | mkN "การเปลี่ยนแปลงอย่างกะทันหัน" | mkN "การโบกมือเพื่อทักทายหรือส่งสัญญาณ" ; -- src=panlex
lin magazine_N = mkN "นิตยสาร" | mkN "แมกกาซีน" | mkN "ซองดินปืน" | mkN "บริษัทนิตยสาร" | mkN "ปลอกกระสุนปืน" | mkN "กล่อง" | mkN "วารสาร" | mkN "นิตยสาร" | mkN "แม็กกาซีน" | mkN "ที่ใส่กระสุน" | mkN "หนังสือรายเดือน" | mkN "หนังสือรายสัปดาห์" | mkN "กระสุนปืนรวมทั้งแก๊ป" | mkN "ปลอกกระสุนและหัวตะกั่ว" | mkN "กล่องใส่กระสุนในปืนอัตโนมัติ" | mkN "ห้องเก็บดินปืนหรือวัตถุระเบิดอื่น ๆ" ; -- src=panlex
lin totally_Adv = variants{} ; -- 
lin mental_A = mkA "ในใจ" | mkA "ทางจิต" | mkA "เป็นโรคจิต" | mkA "เกี่ยวกับจิตใจ" | mkA "ซึ่งผุดขึ้นในใจ" | mkA "ซึ่งเกิดขึ้นในใจ" | mkA "สําหรับคนไข้โรคจิต" ; -- src=panlex
lin used_A = mkA "มือสอง" | mkA "ที่ใช้แล้ว" | mkA "ที่ใช้ให้เป็นประโยชน์" | mkA "ซึ่งถูกใช้" | mkA "ที่เคยใช้มาก่อน" | mkA "ซึ่งเคยมีเจ้าของแล้ว" | mkA "ที่คุ้นเคยเพราะใช้อยู่เป็นประจํา" ; -- src=panlex
lin store_N = mkN "เมม" | mkN "ร้าน" | mkN "ร้านค้า" | mkN "เมมโมรี่" | mkN "คลังพัสดุ" | mkN "คลังเก็บสินค้า" | mkN "หน่วยความจำคอมพิวเตอร์" | mkN "ร้าน" | mkN "ห้าง" | mkN "พัสดุ" | mkN "โกดัง" | mkN "ร้านค้า" | mkN "ห้างร้าน" | mkN "จํานวนมาก" | mkN "ปริมาณมาก" | mkN "ห้องพัสดุ" | mkN "เก็บรักษา" | mkN "คลังสินค้า" | mkN "การเก็บสะสม" | mkN "ห้องเก็บของ" | mkN "การเก็บกักตุนไว้" | mkN "สิ่งที่กักตุนไว้" | mkN "ใส่ไว้ในห้องพัสดุ" | mkN "สิ่งที่เก็บสะสมไว้" | mkN "ป้อนข้อมูลลงในเครื่องคอมพิวเตอร์" ; -- src=panlex
lin scientific_A = mkA "วิทยาศาสตร์" | mkA "ทางวิทยาศาสตร์" | mkA "ตามหลักวิทยาศาสตร์" | mkA "มีระบบ" | mkA "ที่เป็นระบบ" | mkA "ทางวิทยาศาสตร์" | mkA "ตามหลักวิทยาศาสตร์" | mkA "เกี่ยวกับวิทยาศาสตร์" | mkA "ควบคุมโดยหลักความจริงหรือหลักการ" | mkA "ซึ่งดําเนินการอย่างมีวิธีการและเป็นระบบ" ; -- src=panlex
lin frequently_Adv = variants{} ; -- 
lin thanks_N = mkN "การแสดงความขอบคุณ" | mkN "การขอบคุณ" ; -- src=panlex
lin beside_Prep = mkPrep "นอกจาก" | mkPrep "ห่างจาก" | mkPrep "อยู่นอก" | mkPrep "อยู่ข้าง" | mkPrep "อยู่ใกล้" | mkPrep "เทียบกับ" | mkPrep "นอกจากนี้" | mkPrep "ไม่เกี่ยวกับ" | mkPrep "นอกเหนือไปจาก" | mkPrep "เมื่อเทียบกับ" ; -- src=panlex
lin settlement_N = mkN "หมู่บ้าน" | mkN "อาณานิคม" | mkN "ผลการตัดสินใจ" | mkN "การก่อตั้งอาณานิคม" | mkN "นิคม" | mkN "ชุมชน" | mkN "กองทุน" | mkN "ข้อตกลง" | mkN "ถิ่นฐาน" | mkN "การค่อย ๆ จมลง" | mkN "อาณานิคม" | mkN "การจัดการ" | mkN "ทรัพย์สิน" | mkN "การก่อตั้ง" | mkN "การแก้ปัญหา" | mkN "การแก้ปัญหา}การทําข้อตกลง" | mkN "การชําระหนี้" | mkN "การตั้งรกราก" | mkN "การชําระบัญชี" | mkN "การตั้งกิจการ" | mkN "การตั้งถิ่นฐาน" | mkN "การตั้งหลักฐาน" | mkN "การมอบทรัพย์สิน" | mkN "ถิ่นที่อยู่ตามกฎหมาย" ; -- src=panlex
lin absolutely_Adv = variants{} ; -- 
lin critical_A = variants{} ; -- 
lin critical_2_A = variants{} ; -- 
lin critical_1_A = variants{} ; -- 
lin recognition_N = mkN "การจําได้" | mkN "การทักทาย" | mkN "การยอมรับ" | mkN "การรู้จัก" | mkN "การจําแนกออก" | mkN "การแสดงว่ารู้จัก" | mkN "การแสดงความขอบคุณ" | mkN "การแสดงว่าเห็นคุณค่า" ; -- src=panlex
lin touch_N = mkN "การสัมผัส" | mkN "การติดต่อสื่อสาร" | mkN "ความรู้สึกจากการสัมผัส" | mkN "ขอ" | mkN "ถู" | mkN "จับ" | mkN "ถึง" | mkN "ถูก" | mkN "แตะ" | mkN "ใช้" | mkN "ต้อง" | mkN "มีผล" | mkN "ขอยืม" | mkN "บรรลุ" | mkN "จัดการ" | mkN "บริโภค" | mkN "ละเมิด" | mkN "สัมผัส" | mkN "แตะต้อง" | mkN "ประทับใจ" | mkN "ล่วงเกิน" | mkN "การสัมผัส" | mkN "การแตะต้อง" | mkN "ความรู้สึก" | mkN "รายละเอียด" | mkN "เกี่ยวข้อง" | mkN "จํานวนเล็กน้อย" | mkN "การติดต่อสื่อสาร" | mkN "ทําให้เกิดเสียงเบา ๆ" ; -- src=panlex
lin consist_V = mkV "ประกอบด้วย" | mkV "เป็นต้นเหตุ" | mkV "ประกอบด้วย" ; -- src=panlex
lin below_Prep = mkPrep "ใต้" | mkPrep "บนนรก" | mkPrep "ข้างล่าง" | mkPrep "ต่ํากว่า" | mkPrep "อยู่ข้างใต้" | mkPrep "ไม่สมเกียรติของ" ; -- src=panlex
lin silence_N = mkN "การไม่พูด" | mkN "ความเงียบ" | mkN "การกุมความลับ" | mkN "การเก็บความลับ" | mkN "การเก็บงำความลับ" | mkN "การปกปิด" | mkN "การปิดบัง" | mkN "การไม่พูด" | mkN "ความเงียบ" | mkN "การลืมเลือน" | mkN "การนิ่งเงียบ" | mkN "การเก็บไว้ในใจ" | mkN "การไม่มีข่าวคราว" | mkN "การเก็บเป็นความลับ" | mkN "การเก็บไว้เป็นความลับ" ; -- src=panlex
lin expenditure_N = mkN "การใช้" | mkN "ค่าใช้จ่าย" | mkN "งบประมาณ" | mkN "การใช้จ่าย" | mkN "ค่าใช้จ่าย" | mkN "การจับจ่ายใช้สอย" ; -- src=panlex
lin institute_N = mkN "สถาบัน" | mkN "สร้าง" | mkN "สถาบัน" | mkN "ก่อตั้ง" | mkN "ริเริ่ม" | mkN "องค์การ" | mkN "จัดให้มี" | mkN "วิทยาลัย" ; -- src=panlex
lin dress_V2 = mkV2 "ขลิบ" ; ---- | mkV "ทำผม" | mkV "เล็ม" | mkV "เซตผม" | mkV "จัดแถว" | mkV "ตกแต่ง" | mkV "สวมชุด" | mkV "เคลือบ" | mkV "แต่งผม" | mkV "แต่งกาย" | mkV "แต่งตัว" | mkV "รักษาแผล" | mkV "ใส่น้ำสลัด" | mkV "ตกแต่งอาหาร" | mkV "สวมเสื้อผ้า" | mkV "ใส่เสื้อผ้า" | mkV "พันผ้าพันแผล" | mkV "จัดให้เป็นแถว" | mkV "ตกแต่งจานอาหาร" | mkV "แต่งตัวให้ดูดี" | mkV "จัดแต่งจานอาหาร" | mkV "เปลี่ยนเป็นหนัง" | mkV "ทำให้ดูสะอาดสะอ้าน" | mkV "แต่ง" | mkV "ตกแต่ง" | mkV "ประดับ" | mkV "ตัดแต่ง" | mkV "แต่งกาย" | mkV "แต่งตัว" | mkV "ใส่เสื้อผ้า" ; -- src=panlex
lin dress_V = mkV "ขลิบ" | mkV "ทำผม" | mkV "เล็ม" | mkV "เซตผม" | mkV "จัดแถว" | mkV "ตกแต่ง" | mkV "สวมชุด" | mkV "เคลือบ" | mkV "แต่งผม" | mkV "แต่งกาย" | mkV "แต่งตัว" | mkV "รักษาแผล" | mkV "ใส่น้ำสลัด" | mkV "ตกแต่งอาหาร" | mkV "สวมเสื้อผ้า" | mkV "ใส่เสื้อผ้า" | mkV "พันผ้าพันแผล" | mkV "จัดให้เป็นแถว" | mkV "ตกแต่งจานอาหาร" | mkV "แต่งตัวให้ดูดี" | mkV "จัดแต่งจานอาหาร" | mkV "เปลี่ยนเป็นหนัง" | mkV "ทำให้ดูสะอาดสะอ้าน" | mkV "แต่ง" | mkV "ตกแต่ง" | mkV "ประดับ" | mkV "ตัดแต่ง" | mkV "แต่งกาย" | mkV "แต่งตัว" | mkV "ใส่เสื้อผ้า" ; -- src=panlex
lin dangerous_A = mkA "ฉกรรจ์" | mkA "อันตราย" | mkA "เป็นภัย" | mkA "ไม่ปลอดภัย" | mkA "ซึ่งเป็นอันตราย" | mkA "อยู่ในระหว่างอันตราย" ; -- src=panlex
lin familiar_A = mkA "ชิน" | mkA "รู้" | mkA "เคย" | mkA "คุ้น" | mkA "ไม่มี" | mkA "รู้จัก" | mkA "เคยชิน" | mkA "คุ้นเคย" | mkA "ตามสบาย" | mkA "สนิทสนม" | mkA "ใกล้ชิด" | mkA "เห็นเสมอ" | mkA "ซึ่งเป็นที่รู้จัก" ; -- src=panlex
lin asset_N = mkN "ค่า" | mkN "ประโยชน์" | mkN "บุคคล ที่มีค่า" | mkN "เงินทอง" | mkN "ของมีค่า" | mkN "ทรัพย์สิน" | mkN "สินทรัพย์" | mkN "สิ่งที่มีคุณค่า" ; -- src=panlex
lin educational_A = mkA "ทางการศึกษา" | mkA "ด้านการศึกษา" | mkA "ที่ให้ความรู้" | mkA "ที่เกี่ยวกับการศึกษา" | mkA "ที่เกี่ยวกับการเรียนการสอน" ; -- src=panlex
lin sum_N = mkN "สาระ" | mkN "แก่น" | mkN "ผลบวก" | mkN "ผลรวม" | mkN "เนื้อๆ" | mkN "ใจกลาง" | mkN "เนื้อหา" | mkN "จำนวนเงิน" | mkN "แก่นความคิด" | mkN "ยอด" | mkN "สรุป" | mkN "ผลบวก" | mkN "ผลรวม" | mkN "รวบยอด" | mkN "หัวข้อ" | mkN "ข้อสรุป" | mkN "เลขคณิต" | mkN "จํานวนรวม" | mkN "จํานวนเงิน" | mkN "สาระสําคัญ" | mkN "มีใจความย่อ" | mkN "ใจความสําคัญ" | mkN "การคํานวณทางคณิตศาสตร์" ; -- src=panlex
lin publication_N = mkN "สิ่งพิมพ์" | mkN "การตีพิมพ์" | mkN "สิ่งตีพิมพ์" | mkN "สื่อสิ่งพิมพ์" | mkN "ธุรกิจการพิมพ์" | mkN "การตีพิมพ์เผยแพร่" | mkN "การแถลง" | mkN "การโฆษณา" | mkN "การประกาศ" | mkN "สิ่งตีพิมพ์" | mkN "หนังสือพิมพ์" | mkN "การพิมพ์โฆษณา" | mkN "ธุรกิจการพิมพ์" ; -- src=panlex
lin partly_Adv = mkAdv "เป็นบางส่วน" | mkAdv "บางส่วน" | mkAdv "ไม่ทั้งหมด" ; -- src=panlex
lin block_N = mkN "รอก" | mkN "บล็อก" | mkN "มู่เล่" | mkN "การหยุด" | mkN "ห้องแถว" | mkN "ทั้งก้อน" | mkN "ลูกบาศก์" | mkN "เสื้อสูบ" | mkN "การกีดขวาง" | mkN "แท่นประมูล" | mkN "รอกขนาดใหญ่" | mkN "สิ่งกีดขวาง" | mkN "ก้อนสี่เหลี่ยม" | mkN "แท่งสี่เหลี่ยม" | mkN "รูปทรงสี่เหลี่ยม" | mkN "ของที่เป็นก้อนสี่เหลี่ยม" | mkN "การหยุดชะงักทางกระบวนการทางความคิด" | mkN "[แถวติดต่อกันของอาคาร]" | mkN "ช่วงตึก" | mkN "ตึกใหญ่" | mkN "สิ่งกีดขวาง" | mkN "ที่วางของโชว์ในการประมูล" | mkN "ชิ้นของวัสดุที่เป็นของแข็งและมีลักษณะแบนราบ" | mkN "การหยุดชะงักของพัฒนาการของกระบวนการทางความคิดหยุดชะงัก" ; -- src=panlex
lin seriously_Adv = variants{} ; -- 
lin youth_N = mkN "หนุ่ม" | mkN "วัยเยาว์" | mkN "หนุ่มน้อย" | mkN "เด็กหนุ่ม" | mkN "คนหนุ่มสาว" | mkN "วัยหนุ่มสาว" | mkN "ความเป็นหนุ่มเป็นสาว" | mkN "ยุวชน" | mkN "วัยสาว" | mkN "เยาวชน" | mkN "วัยรุ่น" | mkN "วัยหนุ่ม" | mkN "วัยหนุ่มสาว" | mkN "คนหนุ่มคนสาว" | mkN "พลังหนุ่มสาว" | mkN "เด็กหนุ่มสาว" | mkN "วัยหนุ่มวัยสาว" | mkN "ความเป็นหนุ่มสาว" | mkN "ความเป็นหนุ่มเป็นสาว" ; -- src=panlex
lin tape_N = mkN "เทป" | mkN "สายวัด" | mkN "เทปวัด" | mkN "เส้นชัย" | mkN "ตลับเมตร" | mkN "เทปบันทึก" | mkN "เทปแม่เหล็ก" | mkN "ผูก" | mkN "มัด" | mkN "สาย" | mkN "สายผูก" | mkN "สายมัด" | mkN "สายวัด" | mkN "สายเทป" | mkN "เทปกาว" | mkN "แถบกาว" | mkN "ผ้ากุ๊น" | mkN "เส้นชัย" | mkN "กระดาษกาว" | mkN "แถบบันทึกเสียง" | mkN "สายเทปบันทึกเสียง" | mkN "แถบผ้าสําหรับหุ้มริมผ้า ทําปกหนังสือหรือเย็บเล่ม" | mkN "ผ้ายางปิดแผลสําหรับพันสายไฟฟ้า" | mkN "สายหลักชัยที่จุดสิ้นสุดในการแข่งขัน" ; -- src=panlex
lin elsewhere_Adv = mkAdv "ที่อื่น" | mkAdv "แห่งอื่น" ; -- src=panlex
lin cover_N = mkN "ปก" | mkN "ปลอก" | mkN "ฝาปิด" | mkN "ที่ปิด" | mkN "ผ้าห่ม" | mkN "การปกปิด" | mkN "ค่าบริการ" | mkN "สิ่งปกคลุม" | mkN "การยิงคุ้มกัน" | mkN "การเข้าปกหนังสือ" | mkN "การร้องเพลงคนอื่น" | mkN "ฝา" | mkN "ฝาปิด" | mkN "ที่บัง" | mkN "ที่ปิด" | mkN "ผ้าห่ม" | mkN "ฝาครอบ" | mkN "ผ้าคลุม" | mkN "ที่บังตา" | mkN "ปกหนังสือ" | mkN "สถานที่ซ่อน" | mkN "สิ่งที่ปกป้อง" | mkN "สิ่งป้องกันการกระแทก" ; -- src=panlex
lin fee_N = mkN "ค่าธรรมเนียม" | mkN "ค่าตอบแทน" | mkN "ค่าบริการ" | mkN "ค่าธรรมเนียม" | mkN "ค่าเล่าเรียน" ; -- src=panlex
lin program_N = mkN "แผน" | mkN "รายการ" | mkN "แผนการ" | mkN "โครงการ" | mkN "โปรแกรม" | mkN "หลักสูตร" | mkN "รายการออกอากาศ" | mkN "โปรแกรมการแสดง" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "รายการ" | mkN "แผนการ" | mkN "แผนงาน" | mkN "โปรแกรม" | mkN "รายการแสดง" | mkN "ชุดคําสั่งที่ใช้ควบคุมเครื่องอิเล็กทรอนิค" ; -- src=panlex
lin treaty_N = mkN "ข้อตกลง" | mkN "ข้อตกลง" | mkN "สนธิสัญญา" | mkN "การเจรจาเพื่อตกลงกัน" ; -- src=panlex
lin necessarily_Adv = variants{} ; -- 
lin unlikely_A = mkA "ซึ่งไม่น่าเป็นไปได้" | mkA "ไม่แน่" | mkA "เชื่อไม่ได้" | mkA "ไม่น่าเป็นไปได้" | mkA "ไม่น่าจะเกิดขึ้น" | mkA "ที่ไม่น่าจะเกิดขึ้น" | mkA "ที่ไม่น่าเชื่อว่าเป็นจริง" ; -- src=panlex
lin properly_Adv = variants{} ; -- 
lin guest_N = mkN "แขก" | mkN "ลูกข่าย" | mkN "แขกเหรื่อ" | mkN "ผู้เข้าพัก" | mkN "แขกรับเชิญ" | mkN "แขก" | mkN "ลูกค้า" | mkN "แขกเหรื่อ" | mkN "ผู้มาเยี่ยม" ; -- src=panlex
lin code_N = mkN "รหัส" | mkN "โค้ด" | mkN "กฎระเบียบ" | mkN "กฏระเบียบ" | mkN "รหัสคอมพิวเตอร์" | mkN "รหัส" | mkN "กฎเกณฑ์" | mkN "มาตรการ" | mkN "ระเบียบ" | mkN "สัญลักษณ์" | mkN "หลักเกณฑ์" | mkN "เครื่องหมาย" | mkN "ประมวลกฎหมาย" | mkN "ระบบสัญลักษณ์" ; -- src=panlex
lin hill_N = placeN (thword "เนิน" "เขา") | {-pan-} mkN "เนิน" | mkN "จุดขว้าง" | mkN "ภู" | mkN "กอง" | mkN "ดอน" | mkN "ดอย" | mkN "เขา" | mkN "โคก" | mkN "เนิน" | mkN "ภูเขา" | mkN "เนินเขา" | mkN "เขาเตี้ยๆ" | mkN "ภูเขาลูกเล็ก ๆ" ; -- src=panlex
lin screen_N = mkN "ฉาก" | mkN "บังตา" | mkN "จอเงิน" | mkN "ฉากกั้น" | mkN "ที่ซ่อน" | mkN "การปกปิด" | mkN "จอซีอาร์ที" | mkN "สิ่งปกคลุม" | mkN "ประตูมุ้งลวด" | mkN "จอภาพซีอาร์ที" | mkN "จอภาพแบบซีอาร์ที" | mkN "จอ" | mkN "ฉาก" | mkN "ม่าน" | mkN "จอภาพ" | mkN "บังตา" | mkN "กระชอน" | mkN "จอแก้ว" | mkN "ตะแกรง" | mkN "ที่บัง" | mkN "ที่กรอง" | mkN "การปกปิด" | mkN "การกําบัง" | mkN "ที่กําบัง" | mkN "สิ่งปกปิด" | mkN "การอําพราง" | mkN "ของอําพราง" | mkN "จอภาพยนตร์" | mkN "เครื่องบัง" ; -- src=panlex
lin household_N = mkN "บ้าน" | mkN "ที่บ้าน" | mkN "ครอบครัว" | mkN "ทั่วไป" | mkN "ธรรมดา" | mkN "ครอบครัว" | mkN "ครัวเรือน" | mkN "ประจําบ้าน" | mkN "สมาชิกในครอบครัว" | mkN "เกี่ยวกับงานบ้าน" ; -- src=panlex
lin sequence_N = mkN "ลํา ดับ" | mkN "ลําดับ" | mkN "อนุกรม" | mkN "อันดับ" | mkN "ขั้นตอน" | mkN "การเรียงลําดับ" | mkN "การต่อเนื่องกัน" | mkN "ลําดับเหตุการณ์" | mkN "ตอนที่ต่อเนื่องกัน" | mkN "ไพ่ที่เรียงแต้มกัน" | mkN "เหตุการณ์ที่เกิดขึ้นตามลําดับ" | mkN "ตอนหนึ่งหรือฉากหนึ่งซึ่งแสดงติดต่อกันไป" ; -- src=panlex
lin correct_A = mkA (thword "ถูก") | {-pan-} mkA "ถูก" | mkA "ถูกต้อง" | mkA "ถูกต้อง" | mkA "แม่นยํา" | mkA "ไม่มีผิดพลาด" ; -- src=panlex
lin female_A = mkA "หญิง" | mkA "ที่เป็นเพศหญิง" | mkA "ที่เป็นเพศเมีย" | mkA "หญิง" | mkA "ตัวเมีย" | mkA "เกี่ยวกับสตรี" | mkA "เกี่ยวกับผู้หญิง" | mkA "เกี่ยวกับเพศหญิง" | mkA "เกี่ยวกับเพศเมีย" ; -- src=panlex
lin phase_N = mkN "เฟส" | mkN "มุมเฟส" | mkN "ตอน" | mkN "รูป" | mkN "แง่" | mkN "ขั้น" | mkN "ช่วง" | mkN "ด้าน" | mkN "ระยะ" | mkN "หน้า" | mkN "มุมมอง" | mkN "รูปแบบ" | mkN "แง่มุม" | mkN "ขั้นตอน" | mkN "ระยะโรค" | mkN "ระยะของโรค" | mkN "ทําให้ประสานกัน" | mkN "ลักษณะของดวงจันทร์หรือดวงดาวที่ปรากฎในช่วงเวลาต่างๆ กัน" ; -- src=panlex
lin crowd_N = mkN "ฝูง" | mkN "แก๊ง" | mkN "เพื่อนฝูง" | mkN "กลุ่ม" | mkN "ผู้ชม" | mkN "ฝูงชน" | mkN "มวลชน" | mkN "กลุ่มคน" ; -- src=panlex
lin welcome_V2 = variants{} ; -- 
lin metal_N = mkN "โลหะ" | mkN "อัลลอย" | mkN "โลหะผสม" | mkN "ธาตุโลหะ" | mkN "โลหะ" | mkN "โลหะผสม" | mkN "สารผสมที่มีโลหะ" | mkN "เพลงแนวเฮฟวี่เมทัล" ; -- src=panlex
lin human_N = mkN "คน" | mkN "มนุษย์" | mkN "คน" | mkN "คนเรา" | mkN "มนุษย์" ; -- src=panlex
lin widely_Adv = variants{} ; -- 
lin undertake_V2 = variants{} ; -- 
lin cut_N = mkN "แผล" | mkN "ท่อน" | mkN "คูขุด" | mkN "แทร็ก" | mkN "การตัด" | mkN "การบาด" | mkN "คลองขุด" | mkN "การตีบอล" | mkN "การตัดไพ่" | mkN "ชิ้นเนื้อ" | mkN "แผลถูกฟัน" | mkN "แผลมีดบาด" | mkN "การตัดเย็บ" | mkN "ส่วนตัดออก" | mkN "การขาดเรียน" | mkN "การตีลูกตัด" | mkN "การลดปริมาณ" | mkN "การแบ่งผลกำไร" | mkN "สิ่งที่ทิ่มแทงใจ" | mkN "การตัดญาติขาดมิตร" | mkN "ทรงผม" | mkN "รอยตัด" | mkN "การลดลง" | mkN "รอยเฉือน" | mkN "แบบเสื้อ" | mkN "แผลถูกบาด" | mkN "การขาดเรียน" ; -- src=panlex
lin sky_N = mkN (thword "ฟ้า") | {-pan-} mkN "นภา" | mkN "ฟ้า" | mkN "ฟากฟ้า" | mkN "ท้องฟ้า" | mkN "นภา" | mkN "ฟ้า" | mkN "สวรรค์" | mkN "ท้องฟ้า" | mkN "แดนสุขาวดี" | mkN "ทางฟ้าเบื้องบน" ; -- src=panlex
lin brain_N = mkN "หัว" | mkN "สมอง" | mkN "หัวคิด" | mkN "ความคิด" | mkN "จีเนียส" | mkN "อัจฉริยะ" | mkN "อัจฉริยบุคคล" | mkN "ความสามารถในการเรียนรู้" | mkN "สมอง" | mkN "สมอง ขมอง" | mkN "มันสมอง" | mkN "ความฉลาด" | mkN "สติปัญญา" ; -- src=panlex
lin expert_N = mkN "ผู้เชี่ยวชาญ" | mkN "ผู้ชํานาญ" | mkN "ผู้เชี่ยวชาญ" | mkN "ผู้ชํานาญพิเศษ" | mkN "ผู้มีประสบการณ์" ; -- src=panlex
lin experiment_N = mkN "การทดลอง" | mkN "การทดลอง" | mkN "การทดสอบ" | mkN "การทดลองทางวิทยาศาสตร์" ; -- src=panlex
lin tiny_A = mkA "เล็กมาก" ; -- src=panlex
lin perfect_A = mkA "สมบูรณ์แบบ" | mkA "สมควร" | mkA "ชํานาญ" | mkA "ดีเลิศ" | mkA "ครบถ้วน" | mkA "ดีพร้อม" | mkA "ถูกต้อง" | mkA "ทีเดียว" | mkA "สมบูรณ์" | mkA "เหมาะสม" | mkA "แท้จริง" | mkA "แม่นยํา" | mkA "ไร้มลทิน" | mkA "บริสุทธิ์" | mkA "เชี่ยวชาญ" | mkA "ซึ่งแม่นยํา" | mkA "ไม่มีตําหนิ" | mkA "ซึ่งไม่เจือปน" | mkA "ถูกต้องทั้งเพ" | mkA "ซึ่งสมบูรณ์แบบ" | mkA "ซึ่งไม่มีที่ติ" ; -- src=panlex
lin disappear_V = mkV "หาย" | mkV "สาบสูญ" | mkV "สูญหาย" | mkV "อันตธาน" | mkV "อันตรธาน" | mkV "เลือนหาย" | mkV "หายสาบสูญ" | mkV "หาย" | mkV "หายไป" | mkV "ล่องหน" | mkV "สาบสูญ" | mkV "สูญหาย" | mkV "ไม่ปรากฏตัว" ; -- src=panlex
lin initiative_N = mkN "ก้าวแรก" | mkN "ขั้นแรก" | mkN "ความกระตือรือร้น" | mkN "การเริ่มต้น" | mkN "ความริเริ่ม" | mkN "ความมุ่งมั่น" | mkN "การสร้างสรรค์" | mkN "การเริ่มดําเนินการ" ; -- src=panlex
lin assumption_N = mkN "สมมติฐาน" | mkN "คำกล่าวนำ" | mkN "ความบังอาจ" | mkN "การครอบครอง" | mkN "ความยโสโอหัง" | mkN "การตั้งสมมติฐาน" | mkN "การสมมติ" | mkN "สมมติฐาน" | mkN "การนึกเอา" | mkN "ข้อสมมุติ" | mkN "ความหยิ่ง" | mkN "การนึกคะเน" | mkN "การเสแสร้ง" | mkN "ข้อสมมติฐาน" | mkN "การสันนิษฐาน" | mkN "เทศกาลพระแม่ ขึ้นสวรรค์" | mkN "การเข้ารับตําแหน่ง" ; -- src=panlex
lin photograph_N = mkN "ภาพ" | mkN "รูป" | mkN "ภาพถ่าย" | mkN "รูปถ่าย" | mkN "รูปภาพ" | mkN "ถ่ายรูป" | mkN "ภาพถ่าย" | mkN "รูปถ่าย" | mkN "ภาพเหมือน" | mkN "ถูกถ่ายภาพ" | mkN "ถูกถ่ายรูป" ; -- src=panlex
lin ministry_N = mkN "กระทรวง" | mkN "งานกระทรวง" | mkN "ตึกกระทรวง" | mkN "อาคารสำนักงานกระทรวง" | mkN "กระทรวง" | mkN "คณะสงฆ์" | mkN "การบริการ" | mkN "คณะรัฐมนตรี" | mkN "การช่วยเหลือ" ; -- src=panlex
lin congress_N = mkN "กามกิจ" | mkN "การร่วมเพศ" | mkN "การเสพเมถุน" | mkN "การเสพสังวาส" | mkN "การร่วมประเวณี" | mkN "การมีเพศสัมพันธ์" | mkN "การพบปะกัน" | mkN "การมีเพศสัมพันธ์" ; -- src=panlex
lin transfer_N = mkN "การโอน" | mkN "การขนส่ง" | mkN "การส่ง" | mkN "การโอน" | mkN "การแปลง" | mkN "การขนส่ง" | mkN "การขนย้าย" | mkN "การมอบส่ง" | mkN "การถ่ายทอด" | mkN "การเปลี่ยน" | mkN "การเผยแพร่" | mkN "การเปลี่ยนมือ" | mkN "การเปลี่ยนเจ้าของ" ; -- src=panlex
lin reading_N = mkN "การอ่าน" | mkN "ค่ามาตรวัด" | mkN "ค่ามิเตอร์" | mkN "วัสดุที่ใช้อ่าน" | mkN "การแปล" | mkN "การอ่าน" | mkN "ความรู้" | mkN "การอ่านออกเสียง" | mkN "การพิจารณากฎหมายตามวิธีของรัฐสภา" | mkN "จํานวนตัวเลขที่อ่านได้จากอุปกรณ์" ; -- src=panlex
lin scientist_N = mkN "นักวิทยาศาสตร์" | mkN "นักวิทยาศาสตร์" ; -- src=panlex
lin fast_Adv = variants{} ; -- 
lin fast_A = mkA "เร็ว" | mkA "ฟาสต์" | mkA "อยู่กับที่" | mkA "ติด" | mkA "เร็ว" | mkA "แน่น" | mkA "ว่องไว" | mkA "ติดแน่น" | mkA "ยึดแน่น" | mkA "รวดเร็ว" | mkA "เร่งรีบ" ; -- src=panlex
lin closely_Adv = variants{} ; -- 
lin thin_A = mkA (thword "บาง") | {-pan-} mkA "บาง" | mkA "ผอม" | mkA "เบา" | mkA "เบาๆ" | mkA "เหลว" | mkA "บางเฉียบ" | mkA "หร็อมแหร็ม" | mkA "บาง" | mkA "ผอม" | mkA "เบา" | mkA "น้อย" | mkA "เหลว" | mkA "บอบบาง" | mkA "ผอมบาง" | mkA "เบาบาง" | mkA "เจือจาง" | mkA "แผ่วเบา" | mkA "ไม่มีสี" | mkA "มีประปราย" | mkA "เรียวเล็ก" | mkA "ไม่เข้มข้น" | mkA "ที่มองทะลุได้" | mkA "ที่มีเสียงเบา" | mkA "ที่มีน้ําหนักน้อย" | mkA "ที่ไม่น่าเชื่อถือ" | mkA "ที่มีน้ําผสมอยู่มาก" | mkA "ที่สามารถมองผ่านไปได้" ; -- src=panlex
lin solicitorMasc_N = variants{} ; -- 
lin secure_V2 = variants{} ; -- 
lin plate_N = mkN "จาน" | mkN "แผ่น" | mkN "ฟันปลอม" | mkN "โฮมเพลท" | mkN "แผ่นฟิล์ม" | mkN "จาน" | mkN "จานอาหาร" | mkN "ป้ายโลหะ" | mkN "แผ่นโลหะ" | mkN "แผ่นกระจก" | mkN "แผ่นพิมพ์" | mkN "โล่รางวัล" | mkN "อาหารในจาน" | mkN "จานใส่อาหาร" | mkN "แม่พิมพ์โลหะ" | mkN "โลหะสําหรับชุบ" | mkN "ภาพที่พิมพ์ออกมา" | mkN "แผ่นเหล็กต่อเรือ" | mkN "เครื่องใช้ที่เป็นโลหะ" | mkN "การแข่งขันเพื่อโล่รางวัล" | mkN "ภาพที่พิมพ์สอดใส่ในหนังสือ" | mkN "อาหารและการบริการมื้อหนึ่ง" | mkN "แผ่นโลหะที่จารึกไว้เป็นป้ายชื่อ" | mkN "แผ่นโลหะที่ใช้เป็นเครื่องป้องกัน" ; -- src=panlex
lin pool_N = mkN "พูล" | mkN "สระ" | mkN "แอ่ง" | mkN "สหการ" | mkN "บ่อน้ำ" | mkN "สระน้ำ" | mkN "แอ่งน้ำ" | mkN "บริษัทค้าร่วม" | mkN "สมาคม" | mkN "กองทุน" | mkN "สระน้ํา" | mkN "หนองน้ํา" | mkN "กลุ่มสถาบัน" | mkN "เงินกองกลาง" | mkN "เงินเดิมพัน" | mkN "กีฬาบิลเลียด" ; -- src=panlex
lin gold_N = mkN "ทอง" | {-pan-} mkN "ทองคำ" | mkN "สีทอง" | mkN "ขุมทอง" | mkN "ธาตุทองคำ" | mkN "เหรียญทอง" | mkN "สีเหลืองทอง" | mkN "เลขอะตอม 79" | mkN "คำ" | mkN "มาศ" | mkN "เหม" | mkN "กาญจนา" | mkN "ทองคํา" | mkN "สุวรรณ" | mkN "สุุพรรณ" ; -- src=panlex
lin emphasis_N = mkN "การเน้น" | mkN "การเน้นย้ำ" | mkN "ความรุนแรง" | mkN "ความ" | mkN "การเน้น" | mkN "การเน้น คํา" | mkN "ความสําคัญ" | mkN "การเน้นย้ํา" | mkN "ความเข้มข้น" | mkN "สิ่งที่มีความสําคัญ" ; -- src=panlex
lin recall_VS = variants{} ; -- 
lin recall_V2 = variants{} ; -- 
lin shout_V2 = mkV2 "ด่าทอ" ; ---- | mkV "ตะโกน" | mkV "อุทาน" | mkV "ร้องลั่น" | mkV "ร้องตะโกน" | mkV "ร้องอุทาน" | mkV "พูดเสียงดัง" | mkV "ป่าว" | mkV "ร้อง" | mkV "ตะโกน" | mkV "ร้องเรียก" | mkV "ตะเบ็งเสียง" | mkV "ส่งเสียงดัง" ; -- src=panlex
lin shout_V = mkV "ด่าทอ" | mkV "ตะโกน" | mkV "อุทาน" | mkV "ร้องลั่น" | mkV "ร้องตะโกน" | mkV "ร้องอุทาน" | mkV "พูดเสียงดัง" | mkV "ป่าว" | mkV "ร้อง" | mkV "ตะโกน" | mkV "ร้องเรียก" | mkV "ตะเบ็งเสียง" | mkV "ส่งเสียงดัง" ; -- src=panlex
lin generate_V2 = variants{} ; -- 
lin location_N = mkN "ขอบเขต" | mkN "ตำแหน่ง" | mkN "การวัด" | mkN "สถานที่" | mkN "ตําแหน่ง" | mkN "การให้เช่า" | mkN "สถานที่ตั้ง" | mkN "การหาชัยภูมิ" | mkN "การหาที่ตั้ง" | mkN "การหาสถานที่" | mkN "การหาตําแหน่ง" | mkN "การหาทําเลเหมาะ" | mkN "ตําแหน่งที่ตั้ง" | mkN "การกําหนดที่ตั้ง" | mkN "การหาแหล่งที่ตั้ง" | mkN "การหาทําเลที่เหมาะ" | mkN "สถานที่ถ่ายฉากภายนอก" | mkN "ฉากภายนอกโรงถ่ายทําภาพยนตร์" | mkN "สถานที่ถ่ายทําภาพยนตร์ซึ่งเป็นฉากภายนอกโรงถ่าย" ; -- src=panlex
lin display_VS = variants{} ; -- 
lin display_V2 = variants{} ; -- 
lin heat_N = mkN "ความร้อน" | mkN "ช่วงเป็นสัด" | mkN "อุณหภูมิสูง" | mkN "ระบบทำความร้อน" | mkN "พลังงานความร้อน" | mkN "กําหนัด" | mkN "ความร้อน" | mkN "ความโกรธ" | mkN "ความรุนแรง" | mkN "ทําให้อุ่น" | mkN "เร้าอารมณ์" | mkN "ความฉุนเฉียว" | mkN "ความตื่นเต้น" | mkN "ทําให้ตื่นเต้น" | mkN "อุณหภูมิความร้อน" ; -- src=panlex
lin gun_N = mkN "ปืน" | mkN "มือปืน" | mkN "คันเร่ง" | mkN "ปืนใหญ่" | mkN "คนยิงปืน" | mkN "อาวุธปืน" | mkN "ผู้ยิงปืน" | mkN "พระแสงปืน" | mkN "อาวุธหนัก" | mkN "การยิงสลุต" | mkN "มือปืนรับจ้าง" | mkN "กระบอกฉีดจาระบี" | mkN "กระบอกอัดจาระบี" | mkN "แป้นเหยียบคันเร่ง" | mkN "ปืน" | mkN "ท่อลม" | mkN "อาวุธปืน" | mkN "กระบอกฉีด" | mkN "เติมน้ํามัน" | mkN "เร่งความเร็ว" | mkN "ทําให้เร็วขึ้น" ; -- src=panlex
lin shut_V2 = variants{} ; -- 
lin journey_N = mkN "การเดินทาง" | mkN "การทัศนาจร" | mkN "การเดินทาง" | mkN "การท่องเที่ยว" | mkN "ช่วงระยะเวลาที่เดินทาง" ; -- src=panlex
lin imply_VS = mmkVS "กล่าวหา" ; ---- | mkV "เกี่ยวพัน" | mkV "แฝงความหมายว่า" | mkV "แสดงนัย" | mkV "บอกเป็นนัย" ; -- src=panlex
lin imply_V2 = mkV2 "กล่าวหา" ; ---- | mkV "เกี่ยวพัน" | mkV "แฝงความหมายว่า" | mkV "แสดงนัย" | mkV "บอกเป็นนัย" ; -- src=panlex
lin imply_V = mkV "กล่าวหา" | mkV "เกี่ยวพัน" | mkV "แฝงความหมายว่า" | mkV "แสดงนัย" | mkV "บอกเป็นนัย" ; -- src=panlex
lin violence_N = mkN "การใช้ความรุนแรง" | mkN "การทําลาย" | mkN "ความพลการ" | mkN "ความรุนแรง" | mkN "การสบประมาท" | mkN "ความดุเดือด" | mkN "การใช้กําลัง" | mkN "การล่วงละเมิด" | mkN "การทําให้บาดเจ็บ" | mkN "การใช้กําลังทําลาย" ; -- src=panlex
lin dry_A = mkA (thword "แห้ง") | {-pan-} mkA "แห้ง" | mkA "ซึ่งเลิกดื่ม" | mkA "ซึ่งน้ำนมแห้ง" | mkA "ที่ห้ามผลิตเครื่องดื่มมีแอลกอฮอล์" | mkA "ฝืด" | mkA "เฉยๆ" | mkA "แห้ง" | mkA "จืดชืด" | mkA "เงียบๆ" | mkA "เย็นชา" | mkA "แห้งตึง" | mkA "ไม่หวาน" | mkA "ไอแห้งๆ" | mkA "แห้งแล้ง" | mkA "คอแห้งผาก" | mkA "ไร้อารมณ์" | mkA "น้ํานมแห้ง" | mkA "ขาดความหวาน" | mkA "ไม่มีน้ํานม" | mkA "ห้ามขายเหล้า" | mkA "ไม่ดื่มเหล้า" | mkA "ไม่เปียกชื้น" | mkA "ห้ามจําหน่ายสุรา" | mkA "ไม่นํากระแสไฟฟ้า" ; -- src=panlex
lin historical_A = mkA "เชิงประวัติ" | mkA "ทางประวัติศาสตร์" | mkA "แห่งประวัติศาสตร์" | mkA "อิงประวัติศาสตร์" | mkA "เกี่ยวกับประวัติศาสตร์" | mkA "ซึ่งเกิดขึ้นในประวัติศาสตร์" | mkA "ซึ่งมีพื้นฐานมาจากประวัติศาสตร์" | mkA "เกี่ยวข้องกับการศึกษาประวัติศาสตร์" ; -- src=panlex
lin step_V2 = mkV2 "ก้าว" ; ---- | mkV "ย่าง" | mkV "สเต็ป" | mkV "ก้าวเท้า" | mkV "ย่างเท้า" | mkV "กระทำทารุณ" | mkV "เหยียบเท้า" | mkV "ก้าวเข้าสู่" | mkV "วัดด้วยก้าว" | mkV "ก้าว" ; -- src=panlex
lin step_V = mkV "ก้าว" | mkV "ย่าง" | mkV "สเต็ป" | mkV "ก้าวเท้า" | mkV "ย่างเท้า" | mkV "กระทำทารุณ" | mkV "เหยียบเท้า" | mkV "ก้าวเข้าสู่" | mkV "วัดด้วยก้าว" | mkV "ก้าว" ; -- src=panlex
lin curriculum_N = mkN "หลักสูตร" | mkN "หลักสูตร" ; -- src=panlex
lin noise_N = mkN "นอยส์" | mkN "เสียงรบกวน" | mkN "เสียง" | mkN "เสียงดัง" | mkN "เสียงรบกวน" | mkN "เสียงดังอึกทึก" ; -- src=panlex
lin lunch_N = mkN "ข้าวเที่ยง" | mkN "มื้อเที่ยง" | mkN "มื้อกลางวัน" | mkN "อาหารกลางวัน" | mkN "อาหารมื้อกลางวัน" | mkN "ข้าวเที่ยง" | mkN "ข้าวกลางวัน" | mkN "มื้อกลางวัน" | mkN "อาหารกลางวัน" ; -- src=panlex
lin fear_VS = mkVS (regV "กลัว") ;
lin fear_V2 = mkV2 "กลัว" ;
lin fear_V = mkV "กลัว" | mkV "เกรง" | mkV "กังวล" | mkV "เลื่อมใส" | mkV "กลัว" | mkV "ยั่น" | mkV "เกรงกลัว" | mkV "หวาดหวั่น" | mkV "ตระหนกตกใจ" | mkV "ทําให้กลัว" | mkV "ทําให้หวั่นเกรง" ; -- src=panlex
lin succeed_V2 = mkV2 "รับช่วงต่อ" ; ---- | mkV "ประสบผลสำเร็จ" | mkV "ประสบความสำเร็จ" | mkV "ตามมา" | mkV "สืบทอด" | mkV "ตามหลัง" | mkV "สําเร็จ" | mkV "บังเกิดผล" | mkV "มาภายหลัง" | mkV "ดําเนินต่อ" | mkV "รับช่วงต่อ" | mkV "สัมฤทธิ์ผล" | mkV "ประสบความสําเร็จ" ; -- src=panlex
lin succeed_V = mkV "รับช่วงต่อ" | mkV "ประสบผลสำเร็จ" | mkV "ประสบความสำเร็จ" | mkV "ตามมา" | mkV "สืบทอด" | mkV "ตามหลัง" | mkV "สําเร็จ" | mkV "บังเกิดผล" | mkV "มาภายหลัง" | mkV "ดําเนินต่อ" | mkV "รับช่วงต่อ" | mkV "สัมฤทธิ์ผล" | mkV "ประสบความสําเร็จ" ; -- src=panlex
lin fall_N = variants{} ; -- 
lin fall_2_N = variants{} ; -- 
lin fall_1_N = variants{} ; -- 
lin bottom_N = mkN "ก้น" | mkN "ตูด" | mkN "เชิง" | mkN "พื้นดิน" | mkN "ด้านล่าง" | mkN "บั้นท้าย" | mkN "ส่วนล่าง" | mkN "ครึ่งหลัง" | mkN "พื้นดินใต้ทะเลลึก" | mkN "เรือสินค้าพาณิชย์" | mkN "ก้น" | mkN "ฐาน" | mkN "ตูด" | mkN "ท้าย" | mkN "ปลาย" | mkN "ส่วนต่ําที่สุด" | mkN "ส่วนที่ลึกที่สุด" ; -- src=panlex
lin initial_A = mkA "คําย่อ" | mkA "ชั้นต้น" | mkA "ชื่อแรก" | mkA "เริ่มแรก" | mkA "เบื้องต้น" | mkA "เขียนชื่อย่อ" ; -- src=panlex
lin theme_N = mkN "ตีม" | mkN "ราก" | mkN "ธาตุ" | mkN "รากคำ" | mkN "บทความ" | mkN "รายงาน" | mkN "หัวข้อ" | mkN "เปเปอร์" | mkN "รากศัพท์" | mkN "แก่นเรื่อง" | mkN "บทความ" | mkN "หัวข้อ" | mkN "ใจความ" | mkN "แก่นสาร" | mkN "แนวบทเพลง" | mkN "สาระสําคัญ" | mkN "ประเด็นหลัก" | mkN "แกนคําศัพท์" | mkN "ใจความสําคัญ" | mkN "งานเขียนสั้นๆ" | mkN "หัวข้อหนังสือ" | mkN "หัวข้อความเรียง" | mkN "หัวข้อการอภิปราย" | mkN "หัวข้อในการสนทนา" | mkN "เรื่องของหนังสือ" ; -- src=panlex
lin characteristic_N = mkN "ลักษณะ" | mkN "คุณสมบัติเด่น" | mkN "ลักษณะนิสัย" ; -- src=panlex
lin pretty_Adv = variants{} ; -- 
lin empty_A = mkA (thword "ว่าง" "เปล่า") | {-pan-} mkA "เปล่า" | mkA "ซึ่งท้องว่าง" | mkA "ว่าง" | mkA "โล่ง" | mkA "เปล่า" | mkA "เปล่าๆ" | mkA "ว่างเปล่า" | mkA "ที่ไม่จริงใจ" | mkA "ที่ไม่มีความหมาย" ; -- src=panlex
lin display_N = mkN "ภาพนำเสนอ" | mkN "การจัดแสดง" | mkN "ของที่แสดง" | mkN "พรีเซนเทชั่น" | mkN "เครื่องแสดงภาพ" ; -- src=panlex
lin combination_N = mkN "การรวม" | mkN "กลุ่มคน" | mkN "การรวมกัน" | mkN "การจัดหมู่" | mkN "การประกอบขึ้นเป็นหน่วย" | mkN "กลุ่มคน" | mkN "พันธมิตร" | mkN "การผสมกัน" | mkN "การรวมกัน" | mkN "การผนึกกัน" | mkN "รหัสเปิดกุญแจ" | mkN "จํานวนสิ่งของที่รวมกัน" | mkN "สิ่งที่เกิดจากการรวมกัน" ; -- src=panlex
lin interpretation_N = mkN "การตีความ" | mkN "การแปล" | mkN "การล่าม" | mkN "การชี้แจง" | mkN "การตีความ" | mkN "การอธิบาย" | mkN "การแปลความหมาย" | mkN "การแสดงดนตรีเพื่อแสดงความหมายที่แฝงอยู่" ; -- src=panlex
lin rely_V2 = mkV2 "วางใจ" ; ---- | mkV "ไว้ใจ" | mkV "มั่นใจ" | mkV "อาศัย" | mkV "เชื่อใจ" | mkV "พึ่งพาอาศัย" ; -- src=panlex
lin rely_V = mkV "วางใจ" | mkV "ไว้ใจ" | mkV "มั่นใจ" | mkV "อาศัย" | mkV "เชื่อใจ" | mkV "พึ่งพาอาศัย" ; -- src=panlex
lin escape_VS = mmkVS "หลบ" ; ---- | mkV "พลาด" | mkV "รั่ว" | mkV "หลบหนี" | mkV "ไม่เจอ" | mkV "วิ่งหนี" | mkV "เผ่นหนี" | mkV "หลบหนีจากที่คุมขัง" | mkV "ลี้" | mkV "หนีภัย" | mkV "หลบภัย" | mkV "หลบหนี" ; -- src=panlex
lin escape_V2 = mkV2 "หลบ" ; ---- | mkV "พลาด" | mkV "รั่ว" | mkV "หลบหนี" | mkV "ไม่เจอ" | mkV "วิ่งหนี" | mkV "เผ่นหนี" | mkV "หลบหนีจากที่คุมขัง" | mkV "ลี้" | mkV "หนีภัย" | mkV "หลบภัย" | mkV "หลบหนี" ; -- src=panlex
lin escape_V = mkV "หลบ" | mkV "พลาด" | mkV "รั่ว" | mkV "หลบหนี" | mkV "ไม่เจอ" | mkV "วิ่งหนี" | mkV "เผ่นหนี" | mkV "หลบหนีจากที่คุมขัง" | mkV "ลี้" | mkV "หนีภัย" | mkV "หลบภัย" | mkV "หลบหนี" ; -- src=panlex
lin score_V2 = mkV2 "หลอก" ; ---- | mkV "ทำแต้ม" | mkV "ล่อลวง" | mkV "ทำคะแนน" | mkV "ให้เกรด" | mkV "ได้แต้ม" | mkV "ให้คะแนน" | mkV "ได้คะแนน" | mkV "จัดอันดับ" | mkV "ขีดเส้นใต้" | mkV "ทำเครื่องหมาย" | mkV "เขียนโน้ตเพลง" | mkV "ทําแต้ม" | mkV "คิดคะแนน" | mkV "ทํารอยบาก" | mkV "ทําให้เป็นรอย" ; -- src=panlex
lin score_V = mkV "หลอก" | mkV "ทำแต้ม" | mkV "ล่อลวง" | mkV "ทำคะแนน" | mkV "ให้เกรด" | mkV "ได้แต้ม" | mkV "ให้คะแนน" | mkV "ได้คะแนน" | mkV "จัดอันดับ" | mkV "ขีดเส้นใต้" | mkV "ทำเครื่องหมาย" | mkV "เขียนโน้ตเพลง" | mkV "ทําแต้ม" | mkV "คิดคะแนน" | mkV "ทํารอยบาก" | mkV "ทําให้เป็นรอย" ; -- src=panlex
lin justice_N = mkN "ศาล" | mkN "ตุลาการ" | mkN "ผู้พิพากษา" | mkN "ความยุติธรรม" | mkN "ตุลาการ" | mkN "ผู้พิพากษา" | mkN "ความถูกต้อง" | mkN "ความยุติธรรม" | mkN "ความเป็นธรรม" | mkN "ความเที่ยงธรรม" | mkN "ความชอบด้วยกฎหมาย" | mkN "ความถูกต้องตามกฎหมาย" ; -- src=panlex
lin upper_A = mkA "ส่วนบน" | mkA "ฟันบน" | mkA "ด้านบน" | mkA "สภาสูง" | mkA "ส่วนบน" | mkA "สูงกว่า" | mkA "เข็มขัด" | mkA "ผ้ารัดขา" | mkA "ระดับสูง" | mkA "สายคาดเอว" | mkA "เหนือกว่า" | mkA "สิ่งกระตุ้น" | mkA "ที่นอนชั้นบนของตู้รถไฟ" ; -- src=panlex
lin tooth_N = mkN (thword "ฟัน") | {-pan-} mkN "ฟัน" | mkN "ฟันฟาง" | mkN "เขี้ยว" | mkN "พระทนต์" | mkN "ฟัน" | mkN "ทนต์" | mkN "ทันตะ" | mkN "เฟือง" | mkN "ซี่หวี" | mkN "รสชาติ" | mkN "ฟันเฟือง" | mkN "สิ่งที่คล้ายฟัน" | mkN "สิ่งที่มีอํานาจทําลายล้าง" | mkN "ผิวหน้าที่ขรุขระของกระดาษวาดหรือผ้าใบ" ; -- src=panlex ----?
lin organize_V2V = variants{} ; -- 
lin organize_V2 = variants{} ; -- 
lin cat_N = mkN "แมว" "ตัว" | {-pan-} mkN "แมว" | mkN "หนุ่ม" | mkN "ใบแคท" | mkN "แมวใหญ่" | mkN "การนินทา" | mkN "ชายหนุ่ม" | mkN "พ่อหนุ่ม" | mkN "รถตีนตะขาบ" | mkN "แส้แมวเก้าหาง" | mkN "แมว" | mkN "วิฬาร์" | mkN "หญิงที่ถูกว่าในแง่ร้าย" | mkN "แส้หนังที่มีสายหนังอยู่เก้าเส้น" ; -- src=panlex
lin tool_N = mkN "ดอ" | mkN "ควย" | mkN "จู๋" | mkN "ทูล" | mkN "ไข่" | mkN "นกเขา" | mkN "เจี๊ยว" | mkN "จ้าวโลก" | mkN "ดอกจำปี" | mkN "น้องชาย" | mkN "หุ่นเชิด" | mkN "กระเจี๊ยว" | mkN "เครื่องมือ" | mkN "คนที่ถูกหลอกใช้" | mkN "ขับรถ" | mkN "ลึงค์" | mkN "วิธีการ" | mkN "เครื่องมือ" | mkN "ใช้เครื่องมือ" | mkN "สิ่งที่ใช้ในงานต่างๆ" | mkN "ส่วนใบมีดของเครื่องมือ" | mkN "คนที่เป็นเครื่องมือของผู้อื่น" ; -- src=panlex
lin spot_N = mkN "จุด" | mkN "ที่" | mkN "แต้ม" | mkN "ตำแหน่ง" | mkN "สถานที่" | mkN "หน้าที่" | mkN "เล็กๆน้อยๆ" | mkN "ตำแหน่งหน้าที่" | mkN "การทำให้เสื่อมเสีย" | mkN "จุด" | mkN "ดวง" | mkN "ที่" | mkN "หยด" | mkN "บาร์" | mkN "แต้ม" | mkN "มลทิน" | mkN "แหล่ง" | mkN "จุดดํา" | mkN "จําได้" | mkN "เงินสด" | mkN "เปื้อน" | mkN "จุดด่าง" | mkN "ฉับพลัน" | mkN "รอยด่าง" | mkN "รอยเลอะ" | mkN "สถานที่" | mkN "ตําแหน่ง" | mkN "รอยเปรอะ" | mkN "เล็งเป้า" | mkN "ไนท์คลับ" | mkN "จุดด่างพร้อย" | mkN "ทําให้กระจาย" | mkN "ปริมาณที่ดื่ม" | mkN "กําหนดตําแหน่ง" | mkN "จํานวนเล็กน้อย" | mkN "ทําให้เปื้อนเปรอะ" | mkN "ไฟจ้าสําหรับส่องให้สว่างมาก" ; -- src=panlex
lin bridge_N = mkN "สะพาน" | mkN "บริดจ์" | mkN "ดั้งจมูก" | mkN "ไพ่บริดจ์" | mkN "ดาดฟ้าเรือ" | mkN "วงจรบริดจ์" | mkN "ที่ยึดฟันปลอม" | mkN "ข้าม" | mkN "ดั้ง" | mkN "สะพาน" | mkN "ทอดข้าม" | mkN "ผ่านพ้น" | mkN "ดั้งจมูก" | mkN "ตัวเชื่อม" | mkN "สะพานเรือ" | mkN "ไพ่บริดจ์" | mkN "ดั้งแว่นตา" | mkN "ที่ยึดฟันปลอม" | mkN "หอบังคับการเรือ" | mkN "สิ่งเชื่อมประสาน" | mkN "เครื่องวัดความฝืดของกระแสไฟฟ้า" ; -- src=panlex
lin double_A = mkA "สองเท่า" | mkA "ทวีคูณ" | mkA "สองเท่า" | mkA "เป็นคู่" | mkA "ประกอบด้วยสองส่วนที่เหมือนกัน / เท่ากัน" ; -- src=panlex
lin direct_V2 = mkV2 "นำ" ; ---- | mkV "ส่ง" | mkV "มุ่ง" | mkV "สั่ง" | mkV "เล็ง" | mkV "กำกับ" | mkV "นำทาง" | mkV "ชี้ทาง" | mkV "ตั้งเป้า" | mkV "มุ่งหน้า" | mkV "อำนวยเพลง" | mkV "จัดโครงการ" | mkV "จ่าหน้าซอง" | mkV "กำหนดทิศทาง" | mkV "วางแผนอย่างแยบยล" | mkV "เขียนชื่อที่อยู่" | mkV "เป็นผู้รับผิดชอบ" | mkV "สอน" | mkV "เล็ง" | mkV "กํากับ" | mkV "ควบคุม" | mkV "จัดการ" | mkV "ชี้ทาง" | mkV "ชี้แนว" | mkV "ชี้แนะ" | mkV "นําทาง" | mkV "บอกทาง" | mkV "แนะนํา" | mkV "แนะแนว" | mkV "แน่นอน" | mkV "มุ่งส่ง" | mkV "สั่งการ" | mkV "เด็ดขาด" | mkV "เปิดเผย" | mkV "บัญชาการ" | mkV "อํานวยการ" | mkV "จ่าหน้าซอง" | mkV "มุ่งความสนใจไปที่" ; -- src=panlex
lin direct_V = mkV "นำ" | mkV "ส่ง" | mkV "มุ่ง" | mkV "สั่ง" | mkV "เล็ง" | mkV "กำกับ" | mkV "นำทาง" | mkV "ชี้ทาง" | mkV "ตั้งเป้า" | mkV "มุ่งหน้า" | mkV "อำนวยเพลง" | mkV "จัดโครงการ" | mkV "จ่าหน้าซอง" | mkV "กำหนดทิศทาง" | mkV "วางแผนอย่างแยบยล" | mkV "เขียนชื่อที่อยู่" | mkV "เป็นผู้รับผิดชอบ" | mkV "สอน" | mkV "เล็ง" | mkV "กํากับ" | mkV "ควบคุม" | mkV "จัดการ" | mkV "ชี้ทาง" | mkV "ชี้แนว" | mkV "ชี้แนะ" | mkV "นําทาง" | mkV "บอกทาง" | mkV "แนะนํา" | mkV "แนะแนว" | mkV "แน่นอน" | mkV "มุ่งส่ง" | mkV "สั่งการ" | mkV "เด็ดขาด" | mkV "เปิดเผย" | mkV "บัญชาการ" | mkV "อํานวยการ" | mkV "จ่าหน้าซอง" | mkV "มุ่งความสนใจไปที่" ; -- src=panlex
lin conclude_VS = mmkVS "จบ" ; ---- | mkV "สรุป" | mkV "ปิดฉาก" | mkV "เห็นด้วย" | mkV "ใช้เหตุผล" | mkV "จบ" | mkV "สรุป" | mkV "ตัดสินใจ" | mkV "ทําให้จบ" ; -- src=panlex
lin conclude_V2 = mkV2 "จบ" ; ---- | mkV "สรุป" | mkV "ปิดฉาก" | mkV "เห็นด้วย" | mkV "ใช้เหตุผล" | mkV "จบ" | mkV "สรุป" | mkV "ตัดสินใจ" | mkV "ทําให้จบ" ; -- src=panlex
lin conclude_V = mkV "จบ" | mkV "สรุป" | mkV "ปิดฉาก" | mkV "เห็นด้วย" | mkV "ใช้เหตุผล" | mkV "จบ" | mkV "สรุป" | mkV "ตัดสินใจ" | mkV "ทําให้จบ" ; -- src=panlex
lin relative_A = mkA "เทียบเคียง" | mkA "เกี่ยวข้องกัน" | mkA "โดยเทียบเคียง" | mkA "ซึ่งสัมพันธ์กัน" ; -- src=panlex
lin soldier_N = mkN "ทหาร" | mkN "พลทหาร" | mkN "มดทหาร" | mkN "ทหารหาญ" | mkN "รั้วของชาติ" | mkN "ทหาร" | mkN "ทกล้า" | mkN "ทแกล้ว" | mkN "มดทหาร" | mkN "ผู้รับใช้" | mkN "ทหารประจําการ" | mkN "ทําหน้าที่ทหาร" | mkN "หน่วงเหนี่ยวงาน" | mkN "ผู้เชี่ยวชาญการทหาร" | mkN "มดหรือปลวกที่มีขากรรไกรแข็งแรง" ; -- src=panlex
lin climb_V2 = mkV2 "ไต่" ; ---- | mkV "ขึ้น" | mkV "ชันขึ้น" | mkV "ไต่ขึ้น" | mkV "เพิ่มขี้น" | mkV "เพิ่มสูงขึ้น" | mkV "เลื่อนชั้นทางสังคม" | mkV "ปีน" | mkV "ค่อยๆ เพิ่มขึ้น" ; -- src=panlex
lin climb_V = mkV "ไต่" | mkV "ขึ้น" | mkV "ชันขึ้น" | mkV "ไต่ขึ้น" | mkV "เพิ่มขี้น" | mkV "เพิ่มสูงขึ้น" | mkV "เลื่อนชั้นทางสังคม" | mkV "ปีน" | mkV "ค่อยๆ เพิ่มขึ้น" ; -- src=panlex
lin breath_N = mkN "กระแสลม" | mkN "คำแนะนำ" | mkN "ลมหายใจ" | mkN "การหายใจ" | mkN "การชี้แนะ" | mkN "การบอกใบ้" | mkN "ช่วงพักหายใจ" | mkN "ลมหายใจเข้าออก" | mkN "กลิ่น" | mkN "ชีวิต" | mkN "ร่องรอย" | mkN "ลมหายใจ" | mkN "กลิ่นปาก" | mkN "การหายใจ" | mkN "พลังชีวิต" | mkN "กระแสลมอ่อน" | mkN "การพูดเป็นนัยๆ" | mkN "การหายใจเข้าครั้งหนึ่ง" | mkN "การแสดงข้อคิดเห็นเล็กน้อย" ; -- src=panlex
lin afford_V2V = variants{} ; -- 
lin afford_V2 = variants{} ; -- 
lin urban_A = mkA "ในเมือง" | mkA "ในเมือง" | mkA "เกี่ยวกับเมือง" | mkA "อาศัยอยู่ในเมือง" | mkA "เป็นลักษณะของเมือง" | mkA "ทีเป็นลักษณะของชุมชนเมือง" ; -- src=panlex
lin nurse_N = mkN "พยาบาล" | mkN "นางพยาบาล" | mkN "พี่เลี้ยง" | mkN "คนดูแลเด็ก" | mkN "คนเลี้ยงเด็ก" | mkN "พี่เลี้ยงเด็ก" | mkN "แม่นม" | mkN "พยาบาล" | mkN "นางพยาบาล" | mkN "ผู้ช่วยแพทย์" | mkN "ผู้หญิงที่ดูแลเด็กเล็ก" ; -- src=panlex
lin narrow_A = mkA (thword "แคบ") | {-pan-} mkA "แคบ" | mkA "ใจแคบ" | mkA "คับแคบ" | mkA "ซึ่งละเอียด" | mkA "ไม่ห่างกันมาก" | mkA "แคบ" | mkA "คับแคบ" | mkA "จํากัด" | mkA "ประหยัด" | mkA "ระมัดระวัง" | mkA "เกือบไม่พอ" | mkA "เกือบไม่สําเร็จ" ; -- src=panlex
lin liberal_A = mkA "เสรี" | mkA "แบบเสรี" | mkA "ซึ่งเปิดกว้างทางความคิด" | mkA "มากมาย" | mkA "ใจป้ํา" | mkA "ใจกว้าง" | mkA "มีใจป้ํา" | mkA "ตามอารมณ์" | mkA "เป็นอิสระ" | mkA "ตามอําเภอใจ" | mkA "อุดมสมบูรณ์" | mkA "โอบอ้อมอารี" | mkA "นิยมลัทธิเสรีนิยม" | mkA "ผู้มีใจโอบอ้อมอารี" | mkA "เกี่ยวกับลัทธิเสรีนิยม" | mkA "สมาชิกพรรคลิบเบอรัลของอังกฤษ" ; -- src=panlex
lin coal_N = mkN "ถ่านหิน" | mkN "ถ่านแดง" | mkN "ถ่าน" | mkN "ถ่านหิน" | mkN "ก้อนถ่าน" | mkN "" ; -- src=panlex
lin priority_N = mkN "การมาก่อน" | mkN "บุริมสิทธิ" | mkN "สิทธิพิเศษ" | mkN "การมีสิทธิก่อน" | mkN "สิ่งที่ได้รับความสนใจมากกว่า" ; -- src=panlex
lin wild_A = mkA "ป่า" | mkA "คลั่งไคล้" | mkA "ป่าเถื่อน" | mkA "ไร้อารยธรรม" | mkA "ที่ห่างไกลความเจริญ" | mkA "พง" | mkA "คลั่ง" | mkA "เอะอะ" | mkA "ดุร้าย" | mkA "รกร้าง" | mkA "รุนแรง" | mkA "ห่างไกล" | mkA "เป็นป่า" | mkA "แห้งแล้ง" | mkA "ฟุ่มเฟือย" | mkA "ไม่เชื่อง" | mkA "ซึ่งมาจากป่า" | mkA "ซึ่งอยู่ในป่า" | mkA "เตลิดเปิดเปิง" | mkA "ไม่ได้ยับยั้ง" | mkA "ไม่เป็นระเบียบ" | mkA "ซึ่งกระตือรือร้น" | mkA "ยุ่งเหยิงไม่มีการ ควบคุม" | mkA "ซึ่งไม่มีความอดกลั้น" | mkA "ป่าเถื่อนไม่มีอารยธรรม" | mkA "ซึ่งไม่ได้จากการเพาะปลูก" | mkA "ซึ่งไม่มีการยับยั้งชั่งใจ" | mkA "ซึ่งเกิดขึ้นเองตามธรรมชาติ" ; -- src=panlex
lin revenue_N = mkN "รายได้รวม" | mkN "รายได้จากภาษีอากร" | mkN "รายได้" | mkN "ภาษีอากร" | mkN "รายได้ของรัฐซึ่งได้จากภาษีอากรและค่าธรรมเนียม" ; -- src=panlex
lin membership_N = mkN "สมาชิกภาพ" | mkN "จำนวนสมาชิก" | mkN "ความเป็นสมาชิก" | mkN "สมาชิกภาพ" | mkN "สมาชิกสภาพ" | mkN "การเข้าร่วม" | mkN "การเป็นสมาชิก" | mkN "จํานวนสมาชิกทั้งหมด" | mkN "การเป็นส่วนหนึ่งของกลุ่ม" ; -- src=panlex
lin grant_N = mkN "เงินอุดหนุน" | mkN "ทรัพย์สินที่ถูกโอน" | mkN "เงินบริจาค" | mkN "เงินสนับสนุน" | mkN "เงินช่วยเหลือ" ; -- src=panlex
lin approve_V2 = mkV2 "เห็นชอบ" ; ---- | mkV "เห็นด้วย" | mkV "อนุมัติ" | mkV "เห็นควร" | mkV "เห็นชอบ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เห็นสมควร" | mkV "เห็นดีเห็นชอบ" ; -- src=panlex
lin approve_V = mkV "เห็นชอบ" | mkV "เห็นด้วย" | mkV "อนุมัติ" | mkV "เห็นควร" | mkV "เห็นชอบ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เห็นสมควร" | mkV "เห็นดีเห็นชอบ" ; -- src=panlex
lin tall_A = mkA "สูง" | mkA "งาม" | mkA "สูง" | mkA "โกหก" | mkA "คุยโว" | mkA "ขี้คุย" | mkA "ขี้โม้" | mkA "มากมาย" | mkA "โอ้อวด" | mkA "มากเกินไป" | mkA "มากเกินควร" | mkA "เหลือเชื่อ" | mkA "สูงกว่าปกติ" | mkA "ไม่น่าเชื่อ" | mkA "ไม่น่าเป็นไปได้" ; -- src=panlex
lin apparent_A = mkA "เป็นที่ประจักษ์ชัด" | mkA "ชัดเจน" | mkA "ภายนอก" | mkA "เด่นชัด" | mkA "แจ่มแจ้ง" | mkA "ซึ่งเห็นได้" | mkA "เกี่ยวกับหลักฐานแรก เริ่ม" ; -- src=panlex
lin faith_N = mkN "กด" | mkN "ศรัทธา" | mkN "ความมั่นใจ" | mkN "ความศรัทธา" | mkN "องค์กรศาสนา" | mkN "ความเชื่อทางศาสนา" | mkN "ศรัทธา" | mkN "ความมั่นใจ" | mkN "ความศรัทธา" | mkN "ความยึดมั่น" | mkN "ความเชื่อถือ" | mkN "ความเลื่อมใส" | mkN "ความซื่อสัตย์" | mkN "ความเชื่อในศาสนา" ; -- src=panlex
lin under_Adv = mkAdv "ลงมา" | mkAdv "น้อยกว่า" | mkAdv "ใต้เส้นขอบฟ้า" | mkAdv "รอง" | mkAdv "ใต้" | mkAdv "ล่าง" | mkAdv "ตามที่" | mkAdv "ภายใต้" | mkAdv "ข้างล่าง" | mkAdv "ต่ํากว่า" | mkAdv "น้อยกว่า" | mkAdv "ในสังกัด" | mkAdv "ซึ่งอยู่ใต้พื้นผิว" ; -- src=panlex
lin fix_V2 = mkV2 "ติด" ; ---- | mkV "ยึด" | mkV "วาง" | mkV "ซ่อม" | mkV "กำหนด" | mkV "ฟิกซ์" | mkV "เตรียม" | mkV "เอาคืน" | mkV "ซ่อมแซม" | mkV "ทำอาหาร" | mkV "ทำกับข้าว" | mkV "เตรียมตัว" | mkV "ยึดให้แน่น" | mkV "ประกอบอาหาร" | mkV "เตรียมอาหาร" | mkV "ทำให้ติดแน่น" | mkV "ทำให้เป็นหมัน" | mkV "ติด" | mkV "ยึด" | mkV "แก้" | mkV "ซ่อม" | mkV "ผนึก" | mkV "ลงโทษ" | mkV "จัดการ" | mkV "ทําโทษ" | mkV "ซ่อมแซม" | mkV "ติดแน่น" | mkV "จัดหาอาหาร" | mkV "เตรียมอาหาร" | mkV "จัดให้เป็นระบบ" ; -- src=panlex
lin fix_V = mkV "ติด" | mkV "ยึด" | mkV "วาง" | mkV "ซ่อม" | mkV "กำหนด" | mkV "ฟิกซ์" | mkV "เตรียม" | mkV "เอาคืน" | mkV "ซ่อมแซม" | mkV "ทำอาหาร" | mkV "ทำกับข้าว" | mkV "เตรียมตัว" | mkV "ยึดให้แน่น" | mkV "ประกอบอาหาร" | mkV "เตรียมอาหาร" | mkV "ทำให้ติดแน่น" | mkV "ทำให้เป็นหมัน" | mkV "ติด" | mkV "ยึด" | mkV "แก้" | mkV "ซ่อม" | mkV "ผนึก" | mkV "ลงโทษ" | mkV "จัดการ" | mkV "ทําโทษ" | mkV "ซ่อมแซม" | mkV "ติดแน่น" | mkV "จัดหาอาหาร" | mkV "เตรียมอาหาร" | mkV "จัดให้เป็นระบบ" ; -- src=panlex
lin slow_A = mkA "ช้า" | mkA "สโลว์" | mkA "ซึ่งซบเซา" | mkA "ซึ่งเรียนรู้ได้ช้า" | mkA "ช้า" | mkA "ชักช้า" | mkA "ล่าช้า" | mkA "อืดอาด" | mkA "เฉื่อย" | mkA "ล้าหลัง" | mkA "ซึ่งรีๆ รอๆ" | mkA "น่าเบื่อ" | mkA "ซึ่งลังเล" | mkA "รับแสงช้า" | mkA "เชื่องช้า" | mkA "ไม่น่าสนใจ" | mkA "ที่ใช้เวลานาน" | mkA "ที่ใช้เวลามาก" | mkA "ช้ากว่าเวลาจริง" | mkA "ไม่กระฉับกระเฉง" ; -- src=panlex
lin troop_N = mkN "ฝูง" | mkN "หมู่" | mkN "กลุ่มลูกเสือ" | mkN "ฝูง" | mkN "หมู่" | mkN "กลุ่ม" | mkN "เหล่า" | mkN "ชุมนุม" | mkN "หมู่คน" | mkN "กลุ่มคน" | mkN "กองทหาร" | mkN "หมู่ทหาร" | mkN "กองกําลัง" | mkN "คณะผู้แสดง" | mkN "ไปเป็นกลุ่ม" | mkN "กลุ่มนักแสดง" | mkN "กองกําลังทหารม้า" ; -- src=panlex
lin motion_N = mkN "คำถาม" | mkN "ท่าทาง" | mkN "การขยับ" | mkN "ท่วงท่า" | mkN "กระทู้ถาม" | mkN "การเคลื่อนที่" | mkN "การเคลื่อนไหว" | mkN "ญัตติ" | mkN "ท่าทาง" | mkN "เรื่อง" | mkN "แรงดลใจ" | mkN "การทําท่าทาง" | mkN "กิริยาท่าทาง" | mkN "การเคลื่อนที่" | mkN "การเคลื่อนไหว" | mkN "ความเคลื่อนไหว" | mkN "การขอร้องต่อศาล" | mkN "ข้อเสนอเป็นทางการ" | mkN "วิธีการหรือท่าทางในการเดิน" | mkN "ข้อเสนอเพื่อการอภิปรายในที่ประชุม" | mkN "อํานาจการเคลื่อนที่หรือเคลื่อนไหว" ; -- src=panlex
lin leading_A = mkA "ที่นำหน้า" | mkA "ชี้นํา" | mkA "นําทาง" | mkA "สําคัญ" | mkA "ชั้นนํา" | mkA "นําหน้า" | mkA "หัวหน้า" | mkA "เป็นหลัก" | mkA "การชี้นํา" | mkA "ชั้นหนึ่ง" | mkA "ชั้นแนวหน้า" | mkA "สําคัญที่สุด" ; -- src=panlex
lin component_N = mkN "ส่วนประกอบ" | mkN "องค์ประกอบ" | mkN "ส่วนประกอบ" ; -- src=panlex
lin bloody_A = mkA "ที่เต็มไปด้วยเลือด" | mkA "ระยํา" | mkA "แดงฉาน" | mkA "อัปรีย์" | mkA "คล้ายเลือด" | mkA "หลั่งเลือด" | mkA "กระหายเลือด" | mkA "เปื้อนเลือด" | mkA "เต็มไปด้วยเลือด" ; -- src=panlex
lin literature_N = mkN "วรรณกรรม" | mkN "การประพันธ์" | mkN "งานประพันธ์" | mkN "วิชาวรรณกรรม" | mkN "การแต่งหนังสือ" | mkN "การเขียนหนังสือ" | mkN "วรรณคดี" | mkN "งานเขียน" | mkN "วรรณกรรม" | mkN "การประพันธ์" | mkN "งานประพันธ์" | mkN "งานวรรณกรรม" | mkN "สรรพหนังสือ" | mkN "สิ่งตีพิมพ์" | mkN "อักษรศาสตร์" | mkN "ผลงานวรรณคดี" | mkN "ผลงานประพันธ์" | mkN "การแต่งหนังสือ" | mkN "การเขียนหนังสือ" | mkN "อาชีพนักอักษรศาสตร์" ; -- src=panlex
lin conservative_A = mkA "อนุรักษ์นิยม" | mkA "แบบอนุรักษ์นิยม" | mkA "รอบคอบ" | mkA "ตัวกันบูด" | mkA "ระมัดระวัง" | mkA "ซึ่งสงวนไว้" | mkA "ซึ่งมีขอบเขต" | mkA "นักจารีตนิยม" | mkA "ซึ่งอนุรักษ์ไว้" | mkA "ผู้รักษาสิ่งเก่า ๆ" | mkA "ที่เป็นการป้องกัน" | mkA "ที่เป็นอนุรักษ์นิยม" | mkA "สมาชิกพรรคคอนเซอวาตีฟ" | mkA "เกี่ยวกับการเก็บรักษา" ; -- src=panlex
lin variation_N = mkN "การแปรผัน" | mkN "ระบำเดี่ยว" | mkN "สิ่งมีชีวิตกลายพันธุ์" | mkN "การผันแปร" | mkN "การแปรปรวน" | mkN "ความแตกต่าง" | mkN "การเปลี่ยนแปลง" | mkN "ความคลาดเคลื่อน" | mkN "ความเปลี่ยนแปลง" | mkN "การเต้นระบําเดี่ยว" | mkN "จํานวนที่เปลี่ยนแปลง" | mkN "รูปแบบที่เปลี่ยนแปลง" | mkN "การผันแปรของสนามแม่เหล็ก" | mkN "การเปลี่ยนแปลงจากวงจรเดิม" | mkN "การเปลี่ยนแปลงของโครงสร้างเดิม" | mkN "ความเปลี่ยนแปลงของวงจรโคจรของดวงดาว" ; -- src=panlex
lin remind_V2 = variants{} ; -- 
lin inform_V2 = mkV2 "แจ้ง" ; ---- | mkV "บอก" | mkV "ดลใจ" | mkV "แจ้ง" | mkV "รายงาน" | mkV "ฟ้องร้อง" | mkV "บอกให้ทราบ" | mkV "แจ้งให้ทราบ" | mkV "ทําให้เต็มไปด้วย" ; -- src=panlex
lin inform_V = mkV "แจ้ง" | mkV "บอก" | mkV "ดลใจ" | mkV "แจ้ง" | mkV "รายงาน" | mkV "ฟ้องร้อง" | mkV "บอกให้ทราบ" | mkV "แจ้งให้ทราบ" | mkV "ทําให้เต็มไปด้วย" ; -- src=panlex
lin alternative_N = mkN "ชอยซ์" | mkN "ออปชั่น" | mkN "ตัวเลือก" | mkN "ทางเลือก" | mkN "ทางเลือก" | mkN "อีกทางหนึ่ง" | mkN "ของที่จะเลือก" | mkN "โอกาสในการเลือก" | mkN "วิธีการที่พอจะเลือกได้" ; -- src=panlex
lin neither_Adv = mkAdv "ไม่" | mkAdv "ไม่ใช่" | mkAdv "ทั้งไม่" | mkAdv "ต่างก็ไม่" | mkAdv "ไม่ทั้งสอง" ; -- src=panlex
lin outside_Adv = mkAdv "ข้างนอก" | mkAdv "กลางแจ้ง" | mkAdv "ภายนอก" | mkAdv "ข้างนอก" | mkAdv "ด้านนอก" ; -- src=panlex
lin mass_N = mkN "กอง" | mkN "มวล" | mkN "กลุ่ม" | mkN "ความจุ" | mkN "มากมาย" | mkN "คนสามัญ" | mkN "ประชาชน" | mkN "ประชาชี" | mkN "สามัญชน" | mkN "คนทั่วไป" | mkN "ความใหญ่" | mkN "จำนวนมาก" | mkN "กลุ่มก้อน" | mkN "คนธรรมดาทั่วไป" | mkN "จำนวนมากมายก่ายกอง" | mkN "กอง" | mkN "ปึก" | mkN "มวล" | mkN "ก้อน" | mkN "ขนาด" | mkN "ชิ้น" | mkN "ส่วน" | mkN "กลุ่ม" | mkN "ทั้งมวล" | mkN "ครอบคลุม" | mkN "ส่วนใหญ่" | mkN "จํานวนมาก" | mkN "ปริมาณมาก" | mkN "ความเทอะทะ" | mkN "ความใหญ่โต" | mkN "ส่วนสําคัญ" | mkN "ภาพหรือขนาดสามมิติ" ; -- src=panlex
lin busy_A = mkA "ที่วุ่นวาย" | mkA "ขยัน" | mkA "ยุ่ง" | mkA "สับสน" | mkA "อลเวง" | mkA "อลหม่าน" | mkA "ไม่อยู่เฉย" | mkA "ยุ่งวุ่นวาย" ; -- src=panlex
lin chemical_N = mkN "สารเคมี" | mkN "สารเคมี" ; -- src=panlex
lin careful_A = mkA "ประณีต" | mkA "ถี่ถ้วน" | mkA "ละเอียด" | mkA "ระมัดระวัง" | mkA "ระวังรอบคอบ" ; -- src=panlex
lin investigate_V2 = mkV2 "สืบสวน" ; ---- | mkV "ตรวจสอบหาความจริง" | mkV "สอบสวน" | mkV "สืบสวน" | mkV "ไต่สวน" | mkV "ค้นหาความจริง" | mkV "ตรวจสอบหาความจริง" ; -- src=panlex
lin investigate_V = mkV "สืบสวน" | mkV "ตรวจสอบหาความจริง" | mkV "สอบสวน" | mkV "สืบสวน" | mkV "ไต่สวน" | mkV "ค้นหาความจริง" | mkV "ตรวจสอบหาความจริง" ; -- src=panlex
lin roll_V2 = mkV2 "มวน" ; ---- | mkV "ม้วน" | mkV "หมุน" | mkV "กลิ้ง" | mkV "กระพือ" | mkV "เดินวน" | mkV "หมุนตัว" | mkV "เคลื่อน" | mkV "เร่ร่อน" | mkV "กลิ้งทับ" | mkV "เร่่ร่อน" | mkV "ซื้อขายของโจร" | mkV "ส่งเสียงกระหึ่ม" | mkV "ม้วน" | mkV "หมุน" | mkV "กลิ้ง" | mkV "บิดงอ" | mkV "โอนเอน" | mkV "เดินโซเซ" | mkV "โคลงเคลง" | mkV "ดําเนินการ" | mkV "นวดด้วยลูกลิ้ง" | mkV "ขับเคลื่อนบนล้อ" | mkV "บิดตัวเคลื่อนไป" | mkV "เริ่มปฏิบัติการ" | mkV "คลึงด้วยลูกกลิ้ง" | mkV "เคลื่อนเป็นลูกคลื่น" ; -- src=panlex
lin roll_V = mkV "มวน" | mkV "ม้วน" | mkV "หมุน" | mkV "กลิ้ง" | mkV "กระพือ" | mkV "เดินวน" | mkV "หมุนตัว" | mkV "เคลื่อน" | mkV "เร่ร่อน" | mkV "กลิ้งทับ" | mkV "เร่่ร่อน" | mkV "ซื้อขายของโจร" | mkV "ส่งเสียงกระหึ่ม" | mkV "ม้วน" | mkV "หมุน" | mkV "กลิ้ง" | mkV "บิดงอ" | mkV "โอนเอน" | mkV "เดินโซเซ" | mkV "โคลงเคลง" | mkV "ดําเนินการ" | mkV "นวดด้วยลูกลิ้ง" | mkV "ขับเคลื่อนบนล้อ" | mkV "บิดตัวเคลื่อนไป" | mkV "เริ่มปฏิบัติการ" | mkV "คลึงด้วยลูกกลิ้ง" | mkV "เคลื่อนเป็นลูกคลื่น" ; -- src=panlex
lin instrument_N = mkN "อุปกรณ์" | mkN "เครื่องมือ" | mkN "เครื่องดนตรี" | mkN "เอกสารราชการ" | mkN "เอกสารทางกฎหมาย" | mkN "หน้าที่เครื่องมือ" | mkN "ลูกมือ" | mkN "เอกสาร" | mkN "วิธีการ" | mkN "อุปกรณ์" | mkN "นิติกรรม" | mkN "เครื่องมือ" | mkN "เครื่องดนตรี" | mkN "เครื่องตรวจวัด" | mkN "ผู้ที่ถูกใช้เป็นเครื่องมือ" ; -- src=panlex
lin guide_N = mkN "ไกด์" | mkN "แทมเพลต" | mkN "ไกด์บุ๊ค" | mkN "นักแกะรอย" | mkN "คนนำเที่ยว" | mkN "มัคคุเทศก์" | mkN "คู่มือนำเที่ยว" | mkN "หนังสือนำเที่ยว" | mkN "ไกด์" | mkN "คู่มือ" | mkN "ผู้ชี้ทาง" | mkN "ป้ายชี้ทาง" | mkN "ผู้นําร่อง" | mkN "มัคคุเทศก์" | mkN "สิ่งบอกทาง" | mkN "คู่มือทัศนาจร" | mkN "เครื่องนําทาง" | mkN "คู่มือท่องเที่ยว" | mkN "หนังสือแนะนํานักท่องเที่ยว" ; -- src=panlex
lin criterion_N = mkN "มาตรฐาน" | mkN "บรรทัดฐาน" | mkN "เกณฑ์" | mkN "มาตรการ" | mkN "บรรทัดฐาน" ; -- src=panlex
lin pocket_N = mkN "กระเป๋า" | mkN "พ็อคเก็ต" | mkN "หลุมอากาศ" | mkN "ถุงหน้าท้อง" | mkN "กระเป๋าหน้าท้อง" | mkN "มี" | mkN "ถุง" | mkN "บ่อ" | mkN "แทง" | mkN "ช่อง" | mkN "หลุม" | mkN "แอ่ง" | mkN "โพรง" | mkN "ปิดบัง" | mkN "กระเป๋า" | mkN "ถุงเล็ก" | mkN "หลุมแร่" | mkN "ครอบครอง" | mkN "ห้อมล้อม" | mkN "หลุมบิลเลียด" | mkN "ถุงหน้าท้องสัตว์" | mkN "กระเป๋าเสื้อหรือกางเกง" | mkN "ส่วนที่คล้ายถุงหรือกระเป๋า" ; -- src=panlex
lin suggestion_N = mkN "ข้อเสนอ" | mkN "การสะกดจิต" | mkN "การเสนอแนะ" | mkN "นัย" | mkN "การเสนอ" | mkN "ข้อเสนอ" | mkN "ร่องรอย" | mkN "เค้าโครง" | mkN "การชักชวน" | mkN "การแนะนํา" | mkN "ข้อชวนคิด" | mkN "การเสนอแนะ" | mkN "ข้อเสนอแนะ" | mkN "สิ่งที่ชวนคิด" | mkN "สิ่งที่บอกเป็นนัย" ; -- src=panlex
lin aye_Interj = variants{} ; -- 
lin entitle_VS = variants{} ; -- 
lin entitle_V2V = variants{} ; -- 
lin tone_N = mkN "เฉด" | mkN "โทน" | mkN "โน้ต" | mkN "กลิ่น" | mkN "เฉดสี" | mkN "โทนสี" | mkN "โทนเสียง" | mkN "โน้ตดนตรี" | mkN "เสียงบริสุทธิ์" | mkN "ระยะหนึ่งเสียงเต็ม" | mkN "เฉดสี" | mkN "โทนสี" | mkN "ปรับสี" | mkN "ระบบสี" | mkN "การให้สี" | mkN "สีที่ให้" | mkN "การปรับสี" | mkN "น้ําเสียง" | mkN "ปรับเสียง" | mkN "เสียงร้อง" | mkN "ระดับเสียง" | mkN "อิทธิพลของสี" | mkN "เสียงสูงต่ํา" | mkN "ลักษณะทั่วๆไป" | mkN "คุณภาพของเสียง" | mkN "ลักษณะน้ําเสียง" | mkN "เสียงที่เกิดจากเครื่องยนต์กลไก" | mkN "การเน้นเสียงที่พยางค์หนึ่งของคํา" | mkN "ความตึงตัวของกล้ามเนื้อหรืออวัยวะอื่นๆในร่างกาย" ; -- src=panlex
lin attractive_A = mkA "ที่มีเสน่ห์" | mkA "ซึ่งมีเสน่าห์" | mkA "มีเสน่ห์" | mkA "มีเสน่ห์ดึงดูด" | mkA "ซึ่งดึงดูดความสนใจ" ; -- src=panlex
lin wing_N = mkN (thword "ปิก") | {-pan-} mkN "ปีก" | mkN "ด้านปีก" | mkN "บังโคลน" | mkN "ส่วนปีก" | mkN "หลังเวที" | mkN "ผู้เล่นตำแหน่งปีก" | mkN "ปิก" | mkN "ปีก" | mkN "ปีกนก" | mkN "ปีกอาคาร" | mkN "ทําให้บินได้" | mkN "ปีกเครื่องบิน" | mkN "นักฟุตบอลหรือนักรักบี้ที่เล่นในตําแหน่งปีก" ; -- src=panlex
lin surprise_N = mkN "เซอร์ไพรส์" | mkN "ความรู้สึกประหลาดใจ" | mkN "การสร้างความประหลาดใจ" | mkN "ความแปลกใจ" | mkN "ความประหลาดใจ" | mkN "สิ่งที่ทําให้ประหลาดใจ" | mkN "เรื่องที่แปลกประหลาดใจ" ; -- src=panlex
lin male_N = mkN "ชาย" | mkN "บุรุษ" | mkN "ตัวผู้" | mkN "ผู้ชาย" | mkN "เพศชาย" | mkN "บุรุษเพศ" | mkN "สัตว์ตัวผู้" | mkN "สัตว์เพศผู้" | mkN "ชาย" | mkN "ผู้" | mkN "ตัวผู้" | mkN "ผู้ชาย" | mkN "เพศชาย" | mkN "พืชตัวผู้" | mkN "เกสรตัวผู้" ; -- src=panlex
lin ring_N = mkN "ห่วง" | mkN "แหวน" | mkN "แก๊งค์" | mkN "โซ่ปิด" | mkN "ธำมรงค์" | mkN "ทรงหูสมอ" | mkN "รูปโดนัท" | mkN "สังเวียน" | mkN "พระธำมรงค์" | mkN "พวกอันธพาล" | mkN "เสียงระฆัง" | mkN "แก็งค์อาชญากร" | mkN "แก๊งค์อันธพาล" | mkN "แก็งค์อาชญากรรม" | mkN "วง" | mkN "ล้อ" | mkN "ห่วง" | mkN "แหวน" | mkN "วงกลม" | mkN "วงแหวน" | mkN "สนามมวย" | mkN "กลุ่มคณะ" | mkN "สนามวงกลม" | mkN "เสียงกระดิ่ง" | mkN "เสียงดังกังวาน" | mkN "เนื้อที่ที่เป็นวงกลม" ; -- src=panlex
lin pub_N = mkN "ผับ" | mkN "ร้านเหล้า" | mkN "ผับ" | mkN "ร้านเล็ก" | mkN "ร้านเหล้า" | mkN "โรงแรมเล็ก ๆ" | mkN "ภัตตาคารเล็ก ๆ" | mkN "โรงเหล้าเล็ก ๆ" ; -- src=panlex
lin fruit_N = mkN (thword "ผล" "ไม้") | {-pan-} mkN "ผล" | mkN "ลูก" | mkN "ผลไม้" | mkN "ผลผลิต" | mkN "ลูกไม้" | mkN "ลูก" | mkN "บุตร" | mkN "หมาก" | mkN "ทายาท" | mkN "ผลไม้" | mkN "ลูกไม้" | mkN "ผลลัพธ์" | mkN "ลูกสัตว์" ; -- src=panlex
lin passage_N = mkN "ช่อง" | mkN "ทางผ่าน" | mkN "การส่งให้" | mkN "การเคลื่อนผ่าน" | mkN "การเปลี่ยนผ่าน" | mkN "การประกาศใช้เป็นกฎหมาย" | mkN "การเดินทางด้วยเรือโดยสาร" | mkN "ตอน" | mkN "การข้าม" | mkN "การผ่าน" | mkN "ทางผ่าน" | mkN "ทางเดิน" | mkN "ข้อเขียน" | mkN "สิทธิการผ่าน" | mkN "ค่าโดยสารเรือ" | mkN "การเดินทางทางน้ํา" | mkN "ความเจริญก้าวหน้า" | mkN "การแลกเปลี่ยนติดต่อระหว่างบุคคล" ; -- src=panlex
lin illustrate_VS = mmkVS "ยกตัวอย่าง" ; ---- | mkV "ใส่ภาพประกอบ" | mkV "ยกตัวอย่างประกอบ" | mkV "ระบายสีสัน" | mkV "แสดงให้เห็น" | mkV "ให้ตัวอย่าง" | mkV "วาดภาพประกอบ" | mkV "แสดงตัวอย่าง" | mkV "ใส่ภาพประกอบ" | mkV "ให้คําอธิบาย" | mkV "ตกแต่งด้วยภาพ" | mkV "เป็นลักษณะของ" | mkV "มีคุณสมบัติของ" | mkV "เป็นตัวอย่างของ" | mkV "กล่าวเปรียบเทียบ" | mkV "อธิบายด้วยตัวอย่าง" ; -- src=panlex
lin illustrate_V2 = mkV2 "ยกตัวอย่าง" ; ---- | mkV "ใส่ภาพประกอบ" | mkV "ยกตัวอย่างประกอบ" | mkV "ระบายสีสัน" | mkV "แสดงให้เห็น" | mkV "ให้ตัวอย่าง" | mkV "วาดภาพประกอบ" | mkV "แสดงตัวอย่าง" | mkV "ใส่ภาพประกอบ" | mkV "ให้คําอธิบาย" | mkV "ตกแต่งด้วยภาพ" | mkV "เป็นลักษณะของ" | mkV "มีคุณสมบัติของ" | mkV "เป็นตัวอย่างของ" | mkV "กล่าวเปรียบเทียบ" | mkV "อธิบายด้วยตัวอย่าง" ; -- src=panlex
lin illustrate_V = mkV "ยกตัวอย่าง" | mkV "ใส่ภาพประกอบ" | mkV "ยกตัวอย่างประกอบ" | mkV "ระบายสีสัน" | mkV "แสดงให้เห็น" | mkV "ให้ตัวอย่าง" | mkV "วาดภาพประกอบ" | mkV "แสดงตัวอย่าง" | mkV "ใส่ภาพประกอบ" | mkV "ให้คําอธิบาย" | mkV "ตกแต่งด้วยภาพ" | mkV "เป็นลักษณะของ" | mkV "มีคุณสมบัติของ" | mkV "เป็นตัวอย่างของ" | mkV "กล่าวเปรียบเทียบ" | mkV "อธิบายด้วยตัวอย่าง" ; -- src=panlex
lin pay_N = mkN "ค่าแรง" | mkN "ค่าจ้าง" | mkN "ค่าแรง" | mkN "รายได้" | mkN "ค่าจ้าง" | mkN "ค่าตอบแทน" | mkN "การจ่ายเงิน" ; -- src=panlex
lin ride_V2 = mkV2 "ขับ" ; ---- | mkV "ขี่" | mkV "ลอย" | mkV "ล้อ" | mkV "นั่ง" | mkV "ยั่ว" | mkV "แหย่" | mkV "สมพาส" | mkV "ขึ้นรถ" | mkV "ทอดสมอ" | mkV "นั่งรถ" | mkV "ขี่ข้าม" | mkV "ขึ้นขี่" | mkV "ร่นขึ้น" | mkV "ยั่วเย้า" | mkV "ล้อเลียน" | mkV "เยาะเย้อ" | mkV "เย้าหยอก" | mkV "โดยสารรถ" | mkV "ขึ้นคร่อม" | mkV "ขึ้นอยู่กับ" | mkV "ขี่" | mkV "ลอย" | mkV "อาศัย" | mkV "ควบคุม" | mkV "ควบม้า" | mkV "บังคับ" | mkV "ล่องลอย" | mkV "ขึ้นลิฟท์" | mkV "เดินทางโดยใช้ยานพาหนะ" | mkV "ขี่จักรยานหรือจักรยานยนต์" ; -- src=panlex
lin ride_V = mkV "ขับ" | mkV "ขี่" | mkV "ลอย" | mkV "ล้อ" | mkV "นั่ง" | mkV "ยั่ว" | mkV "แหย่" | mkV "สมพาส" | mkV "ขึ้นรถ" | mkV "ทอดสมอ" | mkV "นั่งรถ" | mkV "ขี่ข้าม" | mkV "ขึ้นขี่" | mkV "ร่นขึ้น" | mkV "ยั่วเย้า" | mkV "ล้อเลียน" | mkV "เยาะเย้อ" | mkV "เย้าหยอก" | mkV "โดยสารรถ" | mkV "ขึ้นคร่อม" | mkV "ขึ้นอยู่กับ" | mkV "ขี่" | mkV "ลอย" | mkV "อาศัย" | mkV "ควบคุม" | mkV "ควบม้า" | mkV "บังคับ" | mkV "ล่องลอย" | mkV "ขึ้นลิฟท์" | mkV "เดินทางโดยใช้ยานพาหนะ" | mkV "ขี่จักรยานหรือจักรยานยนต์" ; -- src=panlex
lin foundation_N = mkN "ฐาน" | mkN "ฐานราก" | mkN "รากฐาน" | mkN "มูลนิธิ" | mkN "ชุดชั้นใน" | mkN "การก่อตั้ง" | mkN "การเริ่มต้น" | mkN "การสอนพื้นฐาน" | mkN "สมาคม" | mkN "การก่อ" | mkN "รากฐาน" | mkN "องค์กร" | mkN "พื้นฐาน" | mkN "มูลนิธิ" | mkN "องค์การ" | mkN "การสร้าง" | mkN "การสถาปนา" | mkN "การก่อตั้ง" | mkN "ผู้ก่อตั้ง" | mkN "กองทุนมูลนิธิ" | mkN "คณะผู้ก่อตั้ง" | mkN "เครื่องรัดลําตัวผู้หญิง" ; -- src=panlex
lin restaurant_N = placeN (thword "ร้าน" "อา" "หาร") | {-pan-} mkN "ร้านอาหาร" | mkN "สถานที่ขายอาหาร" | mkN "ภัตตาคาร" | mkN "ร้านอาหาร" ; -- src=panlex
lin vital_A = mkA "ที่จำเป็น" | mkA "มีชีวิตชีวา" | mkA "สําคัญ" | mkA "จําเป็น" | mkA "มีกําลัง" | mkA "มีพลังงาน" | mkA "สําคัญมาก" | mkA "ทําลายชีวิต" | mkA "มีชีวิตชีวา" | mkA "กระฉับกระเฉง" | mkA "ขาดเสียมิได้" | mkA "ทําให้ตายได้" | mkA "เกี่ยวกับชีวิต" | mkA "ความเป็นความตาย" | mkA "ที่ทําให้ถึงตายได้" | mkA "จําเป็นสําหรับชีวิต" ; -- src=panlex
lin alternative_A = mkA "รอง" | mkA "สํารอง" | mkA "หนึ่งเดียว" | mkA "อย่างเดียว" | mkA "แต่ผู้เดียว" | mkA "ที่มีตัวเลือก" | mkA "ซึ่งไม่ตามประเพณี" | mkA "ซึ่งไม่เป็นไปตามแผนเดิม" ; -- src=panlex
lin burn_V2 = mkV2 (thword "เผา") ; ---- | {-pan-} mkV "เผา" | mkV "ไหม้" | mkV "เบิร์น" | mkV "แผดเผา" | mkV "เผาผลาญ" | mkV "เผาไหม้" | mkV "แสบร้อน" | mkV "จุดไฟเผา" | mkV "ถลุงเงิน" | mkV "ผลาญเงิน" | mkV "ร้อนรุ่ม" | mkV "เปล่งแสง" | mkV "ใช้ไฟจี้" | mkV "เผาทั้งเป็น" | mkV "คัดลอกข้อมูล" | mkV "ปวดแสบปวดร้อน" | mkV "เผา" | mkV "ไหม้" | mkV "แดดเผา" | mkV "เผาไหม้" | mkV "ไหม้แดด" | mkV "เกรียมแดด" | mkV "ทําให้ไหม้" ; -- src=panlex
lin burn_V = mkV (thword "เผา") | {-pan-} mkV "เผา" | mkV "ไหม้" | mkV "เบิร์น" | mkV "แผดเผา" | mkV "เผาผลาญ" | mkV "เผาไหม้" | mkV "แสบร้อน" | mkV "จุดไฟเผา" | mkV "ถลุงเงิน" | mkV "ผลาญเงิน" | mkV "ร้อนรุ่ม" | mkV "เปล่งแสง" | mkV "ใช้ไฟจี้" | mkV "เผาทั้งเป็น" | mkV "คัดลอกข้อมูล" | mkV "ปวดแสบปวดร้อน" | mkV "เผา" | mkV "ไหม้" | mkV "แดดเผา" | mkV "เผาไหม้" | mkV "ไหม้แดด" | mkV "เกรียมแดด" | mkV "ทําให้ไหม้" ; -- src=panlex
lin map_N = mkN "ผท." | mkN "แผนที่" | mkN "ฟังก์ชัน" | mkN "ฟังก์ชันคณิตศาสตร์" | mkN "กะ" | mkN "แผนที่" | mkN "ใบหน้า" ; -- src=panlex
lin united_A = mkA "รวมกัน" | mkA "ร่วมกัน" | mkA "สามัคคี" | mkA "ี่รวมกัน" | mkA "ปรองดองกัน" | mkA "สอดคล้องกัน" | mkA "ซึ่งร่วมมือกัน" | mkA "พร้อมเพรียงกัน" | mkA "ซึ่งพร้อมเพรียงกัน" ; -- src=panlex
lin device_N = mkN "กลไก" | mkN "ลวดลาย" | mkN "อุปกรณ์" | mkN "เครื่องมือ" | mkN "ตราเครื่องหมาย" | mkN "กลไก" | mkN "แผนการ" | mkN "อุปกรณ์" | mkN "หลักในใจ" | mkN "เครื่องใช้" | mkN "เครื่องกลไก" | mkN "เครื่องหมาย" | mkN "เครื่องประดิษฐ์" ; -- src=panlex
lin jump_V2 = mkV2 (thword "กระ" "โดด") ; ---- | {-pan-} mkV "โดด" | mkV "ข้าม" | mkV "สลับ" | mkV "จัมพ์" | mkV "ตกราง" | mkV "โดดลง" | mkV "กระโจน" | mkV "กระโดด" | mkV "สะดุ้ง" | mkV "โดดร่ม" | mkV "ขึ้นสู่" | mkV "ทิ้งตัว" | mkV "กระโดดลง" | mkV "พุ่งขึ้น" | mkV "พุ่งพรวด" | mkV "เหินเวหา" | mkV "กระโจนใส่" | mkV "กระโดดร่ม" | mkV "ดิ่งพสุธา" | mkV "ขึ้นอันดับ" | mkV "สะดุ้งโหยง" | mkV "ทำให้กระโดด" | mkV "จั๊มแบตเตอรี่" | mkV "กระโดดเข้าร่วม" | mkV "จัมพ์แบตเตอรี่" | mkV "บังคับให้กระโดด" | mkV "โดด" | mkV "ข้าม" | mkV "พุ่ง" | mkV "กระโดด" | mkV "สะดุ้ง" | mkV "ก้าวข้าม" | mkV "เพิ่มราคา" | mkV "กระโดดข้าม" | mkV "สะดุ้งโหยง" | mkV "เสียวสะดุ้ง" | mkV "ขึ้นราคาพรวดๆ" ; -- src=panlex
lin jump_V = mkV (thword "กระ" "โดด") | {-pan-} mkV "โดด" | mkV "ข้าม" | mkV "สลับ" | mkV "จัมพ์" | mkV "ตกราง" | mkV "โดดลง" | mkV "กระโจน" | mkV "กระโดด" | mkV "สะดุ้ง" | mkV "โดดร่ม" | mkV "ขึ้นสู่" | mkV "ทิ้งตัว" | mkV "กระโดดลง" | mkV "พุ่งขึ้น" | mkV "พุ่งพรวด" | mkV "เหินเวหา" | mkV "กระโจนใส่" | mkV "กระโดดร่ม" | mkV "ดิ่งพสุธา" | mkV "ขึ้นอันดับ" | mkV "สะดุ้งโหยง" | mkV "ทำให้กระโดด" | mkV "จั๊มแบตเตอรี่" | mkV "กระโดดเข้าร่วม" | mkV "จัมพ์แบตเตอรี่" | mkV "บังคับให้กระโดด" | mkV "โดด" | mkV "ข้าม" | mkV "พุ่ง" | mkV "กระโดด" | mkV "สะดุ้ง" | mkV "ก้าวข้าม" | mkV "เพิ่มราคา" | mkV "กระโดดข้าม" | mkV "สะดุ้งโหยง" | mkV "เสียวสะดุ้ง" | mkV "ขึ้นราคาพรวดๆ" ; -- src=panlex
lin estimate_VS = mmkVS "กะ" ; ---- | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "คาด" | mkV "ประมาณ" | mkV "อนุมาน" | mkV "คาดคะเน" | mkV "ประเมิน" | mkV "ประมาณการ" | mkV "ประมาณค่า" ; -- src=panlex
lin estimate_V2V = mmkV2V "กะ" ; ---- | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "คาด" | mkV "ประมาณ" | mkV "อนุมาน" | mkV "คาดคะเน" | mkV "ประเมิน" | mkV "ประมาณการ" | mkV "ประมาณค่า" ; -- src=panlex
lin estimate_V2 = mkV2 "กะ" ; ---- | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "คาด" | mkV "ประมาณ" | mkV "อนุมาน" | mkV "คาดคะเน" | mkV "ประเมิน" | mkV "ประมาณการ" | mkV "ประมาณค่า" ; -- src=panlex
lin estimate_V = mkV "กะ" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "คาด" | mkV "ประมาณ" | mkV "อนุมาน" | mkV "คาดคะเน" | mkV "ประเมิน" | mkV "ประมาณการ" | mkV "ประมาณค่า" ; -- src=panlex
lin conduct_V2 = mkV2 "นำ" ; ---- | mkV "จัดการ" | mkV "ประพฤติตน" | mkV "อำนวยเพลง" | mkV "เป็นตัวนำ" | mkV "ประพฤติตัว" | mkV "นํา" | mkV "ควบคุม" | mkV "จัดการ" | mkV "ประพฤติ" | mkV "นําให้ดู" | mkV "นําให้ทําตาม" ; -- src=panlex
lin conduct_V = mkV "นำ" | mkV "จัดการ" | mkV "ประพฤติตน" | mkV "อำนวยเพลง" | mkV "เป็นตัวนำ" | mkV "ประพฤติตัว" | mkV "นํา" | mkV "ควบคุม" | mkV "จัดการ" | mkV "ประพฤติ" | mkV "นําให้ดู" | mkV "นําให้ทําตาม" ; -- src=panlex
lin derive_V2 = mkV2 "ได้" ; ---- | mkV "อนุมาน" | mkV "กลายมาจาก" | mkV "สืบเชื้อสาย" | mkV "มาจาก" | mkV "กลายมา" | mkV "ได้รับจาก" | mkV "กําเนิดจาก" ; -- src=panlex
lin derive_V = mkV "ได้" | mkV "อนุมาน" | mkV "กลายมาจาก" | mkV "สืบเชื้อสาย" | mkV "มาจาก" | mkV "กลายมา" | mkV "ได้รับจาก" | mkV "กําเนิดจาก" ; -- src=panlex
lin comment_VS = mmkVS "ติชม" ; ---- | mkV "คอมเมนต์" | mkV "คอมเม็นต์" | mkV "มีข้อติชม" | mkV "ตั้งข้อสังเกต" | mkV "เขียนคำอธิบาย" | mkV "แสดงความคิดเห็น" | mkV "แสดงความคิดเห็น" ; -- src=panlex
lin comment_V2 = mkV2 "ติชม" ; ---- | mkV "คอมเมนต์" | mkV "คอมเม็นต์" | mkV "มีข้อติชม" | mkV "ตั้งข้อสังเกต" | mkV "เขียนคำอธิบาย" | mkV "แสดงความคิดเห็น" | mkV "แสดงความคิดเห็น" ; -- src=panlex
lin comment_V = mkV "ติชม" | mkV "คอมเมนต์" | mkV "คอมเม็นต์" | mkV "มีข้อติชม" | mkV "ตั้งข้อสังเกต" | mkV "เขียนคำอธิบาย" | mkV "แสดงความคิดเห็น" | mkV "แสดงความคิดเห็น" ; -- src=panlex
lin east_N = mkN "ต.อ." | mkN "ตะวันออก" | mkN "ทิศตะวันออก" | mkN "ภาคตะวันออก" | mkN "บูรพา" | mkN "ตะวันออก" | mkN "บุริมทิศ" | mkN "บูรพาทิศ" | mkN "ทิศตะวันออก" | mkN "ภาคตะวันออก" ; -- src=panlex
lin advise_VS = mmkVS "เสนอ" ; ---- | mkV "แนะนำ" | mkV "แจ้ง" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "แนะแนว" | mkV "แจ้งข่าว" | mkV "แจ้งให้ทราบ" | mkV "ให้คําปรึกษา" | mkV "ให้คําแนะนํา" ; -- src=panlex
lin advise_V2 = mkV2 "เสนอ" ; ---- | mkV "แนะนำ" | mkV "แจ้ง" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "แนะแนว" | mkV "แจ้งข่าว" | mkV "แจ้งให้ทราบ" | mkV "ให้คําปรึกษา" | mkV "ให้คําแนะนํา" ; -- src=panlex
lin advise_V = mkV "เสนอ" | mkV "แนะนำ" | mkV "แจ้ง" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "แนะแนว" | mkV "แจ้งข่าว" | mkV "แจ้งให้ทราบ" | mkV "ให้คําปรึกษา" | mkV "ให้คําแนะนํา" ; -- src=panlex
lin advance_N = mkN "การปรับปรุง" | mkN "ยก" | mkN "อ้าง" | mkN "เร่ง" | mkN "เจริญ" | mkN "เพิ่ม" | mkN "จัดให้" | mkN "ทาบทาม" | mkN "เกี้ยว" | mkN "เลื่อน" | mkN "เงินกู้" | mkN "การพัฒนา" | mkN "ก้าวหน้า" | mkN "ล่วงหน้า" | mkN "การรุดหน้า" | mkN "การก้าวหน้า" | mkN "การขึ้นราคา" | mkN "การเดินหน้า" | mkN "การเพิ่มค่า" | mkN "เสนอความเห็น" | mkN "การจ่ายเงินล่วงหน้า" | mkN "การเคลื่อนไปข้างหน้า" | mkN "นําหรือส่งไปข้างหน้า" ; -- src=panlex
lin motor_N = mkN "มอเตอร์" | mkN "เครื่องมอเตอร์" | mkN "รถยนต์" | mkN "มอเตอร์" | mkN "เครื่องจักร" | mkN "เครื่องยนต์" | mkN "ซึ่งนํากระแสประสาท" ; -- src=panlex
lin satisfy_V2 = variants{} ; -- 
lin hell_N = mkN "นรก" | mkN "บาป" | mkN "ความปั่นป่วน" | mkN "นรก" | mkN "ยมบาล" | mkN "อเวจี" | mkN "ขุมนรก" | mkN "ความชุลมุนวุ่นวาย" ; -- src=panlex
lin winner_N = mkN "ผู้ชนะ" | mkN "คนชนะพนัน" | mkN "ผู้ชนะพนัน" | mkN "เดอะวินเนอร์" | mkN "ผู้ชนะการพนัน" | mkN "ผู้ได้รับชัยชนะ" | mkN "ผู้ชนะการแข่งขัน" | mkN "ผู้ประสบความสำเร็จ" | mkN "แชมป์" | mkN "ผู้ชนะ" | mkN "ผู้มีชัย" | mkN "ผู้ชนะกีฬา" | mkN "ผู้ชนะการแข่งกีฬา" ; -- src=panlex
lin effectively_Adv = variants{} ; -- 
lin mistake_N = mkN "จุดผิดพลาด" | mkN "ความผิดพลาด" | mkN "ความเข้าใจผิด" | mkN "ข้อผิดพลาด" | mkN "ความผิดพลาด" | mkN "ความสําคัญผิด" | mkN "ความเข้าใจผิด" | mkN "ความนึกคิดที่ผิด" ; -- src=panlex
lin incident_N = mkN "กรณี" | mkN "ประจํา" | mkN "ซึ่งกระทบ" | mkN "เรื่องราว" | mkN "เหตุการณ์" | mkN "การบังเกิด" | mkN "บทปลีกย่อย" | mkN "ซึ่งพุ่งเข้าหา" | mkN "สิ่งที่เกิดขึ้น" | mkN "เหตุการณ์เรื่องราว" ; -- src=panlex
lin focus_V2 = mkV2 "ปรับ" ; ---- | mkV "จดจ่อ" | mkV "โฟกัส" | mkV "ตั้งใจ" | mkV "ตั้งสมาธิ" | mkV "มีสมาธิจดจ่อ" | mkV "สนใจ" | mkV "เพ่ง" | mkV "เล็ง" | mkV "โฟกัส" | mkV "เพ่งความสนใจ" ; -- src=panlex
lin focus_V = mkV "ปรับ" | mkV "จดจ่อ" | mkV "โฟกัส" | mkV "ตั้งใจ" | mkV "ตั้งสมาธิ" | mkV "มีสมาธิจดจ่อ" | mkV "สนใจ" | mkV "เพ่ง" | mkV "เล็ง" | mkV "โฟกัส" | mkV "เพ่งความสนใจ" ; -- src=panlex
lin exercise_VV = mkVV "ใช้" ; ---- | mkV "ฝึกงาน" | mkV "ฝึกปฏิบัติ" | mkV "ทำกายบริหาร" | mkV "ออกกำลังกาย" | mkV "บริหารร่างกาย" | mkV "เอ็กเซอร์ไซส์" | mkV "ฝึกซ้ำแล้วซ้ำอีก" | mkV "ทำให้เอ็กเซอร์ไซส์" | mkV "ใช้" | mkV "ปฏิบัติ" | mkV "บริหารกาย" | mkV "ออกกําลัง" | mkV "ดําเนินการ" | mkV "ทําให้กังวล" | mkV "ออกกําลังกาย" | mkV "บริหารร่างกาย" ; -- src=panlex
lin exercise_V2 = mkV2 "ใช้" ; ---- | mkV "ฝึกงาน" | mkV "ฝึกปฏิบัติ" | mkV "ทำกายบริหาร" | mkV "ออกกำลังกาย" | mkV "บริหารร่างกาย" | mkV "เอ็กเซอร์ไซส์" | mkV "ฝึกซ้ำแล้วซ้ำอีก" | mkV "ทำให้เอ็กเซอร์ไซส์" | mkV "ใช้" | mkV "ปฏิบัติ" | mkV "บริหารกาย" | mkV "ออกกําลัง" | mkV "ดําเนินการ" | mkV "ทําให้กังวล" | mkV "ออกกําลังกาย" | mkV "บริหารร่างกาย" ; -- src=panlex
lin exercise_V = mkV "ใช้" | mkV "ฝึกงาน" | mkV "ฝึกปฏิบัติ" | mkV "ทำกายบริหาร" | mkV "ออกกำลังกาย" | mkV "บริหารร่างกาย" | mkV "เอ็กเซอร์ไซส์" | mkV "ฝึกซ้ำแล้วซ้ำอีก" | mkV "ทำให้เอ็กเซอร์ไซส์" | mkV "ใช้" | mkV "ปฏิบัติ" | mkV "บริหารกาย" | mkV "ออกกําลัง" | mkV "ดําเนินการ" | mkV "ทําให้กังวล" | mkV "ออกกําลังกาย" | mkV "บริหารร่างกาย" ; -- src=panlex
lin representation_N = mkN "ภาพแทน" | mkN "รูปแทน" | mkN "การแทนที่" | mkN "ภาพ" | mkN "รูป" | mkN "การแทน" | mkN "ตัวแทน" | mkN "ผู้แทน" | mkN "ทัศนคติ" | mkN "รูปปั้น" | mkN "ตัวอย่าง" | mkN "การบรรยาย" | mkN "การแสดงออก" | mkN "ข้อคิดเห็น" | mkN "การแสดงละคร" | mkN "ข้อเท็จจริง" | mkN "เครื่องแสดง" | mkN "การเป็นตัวแทน" | mkN "การเป็นผู้แทน" | mkN "การดําเนินการแทน" | mkN "เครื่องหมายแสดงออก" ; -- src=panlex
lin release_N = mkN "ปุ่ม" | mkN "สิ้นใจ" | mkN "การจากไป" | mkN "การไล่ออก" | mkN "การปลดปล่อย" | mkN "การเสียชีวิต" | mkN "การถึงแก่กรรม" | mkN "การทำให้เป็นอิสระ" | mkN "การปล่อยให้ไหลออก" | mkN "การพ้นสภาพพนักงาน" | mkN "ใบรับรองการพ้นสภาพ" | mkN "การตีพิมพ์" | mkN "การออกข่าว" | mkN "การปลดปล่อย" | mkN "การนําออกแสดง" | mkN "การปลดเปลื้อง" | mkN "การปล่อยเป็นอิสระ" | mkN "ข่าวสําหรับหนังสือพิมพ์" ; -- src=panlex
lin leaf_N = mkN (thword "ใบ") | {-pan-} mkN "ใบ" | mkN "ใบไม้" | mkN "หน้ากระดาษ" | mkN "ใบ" | mkN "กลีบ" | mkN "ใบไม้" | mkN "กลีบดอก" | mkN "กลีบดอกไม้" | mkN "หน้ากระดาษ" | mkN "หน้าหนังสือ" ; -- src=panlex
lin border_N = mkN "ขอบ" | mkN "ขอทาน" | mkN "เส้นแบ่งเขต" | mkN "ขอบ" | mkN "กรอบ" | mkN "ขอบนอก" | mkN "ขอบเขต" | mkN "ชายแดน" | mkN "พรมแดน" | mkN "เขตแดน" | mkN "เส้นรอบวง" ; -- src=panlex
lin wash_V2 = mkV2 (thword "ล้าง") ;
lin wash_V = mkV "ซัก" | mkV "ไหล" | mkV "ร่อน" | mkV "ล้าง" | mkV "กระทบ" | mkV "ซักได้" | mkV "กัดเซาะ" | mkV "ชำระล้าง" | mkV "ทำให้ชื้น" | mkV "ยอมถูกซักฟอก" | mkV "ชำระล้างร่างกาย" | mkV "เลียทำความสะอาดร่างกาย" | mkV "ซัก" | mkV "ล้าง" | mkV "ชะล้าง" | mkV "แยกแร่" | mkV "ซักล้าง" | mkV "ล้างออกไป" | mkV "ทําความสะอาดโดยการเลีย" ; -- src=panlex
lin prospect_N = mkN "มุมมอง" | mkN "ทิวทัศน์" | mkN "ผู้สมัคร" | mkN "การคาดการณ์" | mkN "การวินิจฉัย" | mkN "โอกาส" | mkN "สํารวจ" | mkN "มีอนาคต" | mkN "ความหวัง" | mkN "การคาดหวัง" | mkN "กาลภายหน้า" | mkN "มีความหวัง" | mkN "การคาดการณ์" | mkN "ภาพที่มองเห็น" | mkN "ความหวังข้างหน้า" | mkN "ผู้อาจเป็นผู้สมัคร" | mkN "ผู้ที่อาจเป็นลูกค้าได้" ; -- src=panlex
lin blow_V2 = mkV2 (thword "พัด") ; ---- | {-pan-} mkV "อม" | mkV "ขาด" | mkV "ดูด" | mkV "พัด" | mkV "พ่น" | mkV "ปลิว" | mkV "เป่า" | mkV "เลีย" | mkV "โม้ก" | mkV "คุยโว" | mkV "ไสหัว" | mkV "ทำลวกๆ" | mkV "วางไข่" | mkV "เงอะงะ" | mkV "โอ้อวด" | mkV "ล่องลอย" | mkV "โ้อ้อวด" | mkV "ถอนหายใจ" | mkV "เป่าแรงๆ" | mkV "ทำงานชุ่ย" | mkV "ทำงานลวกๆ" | mkV "ทำมักง่าย" | mkV "ทำงานมักง่าย" | mkV "ทำงานสะเพร่า" | mkV "ทำให้เสียหาย" | mkV "ลอยไปตามกระแส" | mkV "ใช้จ่ายสุรุ่ยสุร่าย" | mkV "ขาด" | mkV "บาน" | mkV "พัด" | mkV "โชย" | mkV "เป่า" | mkV "ไหม้" | mkV "พ่นลม" | mkV "ระเบิด" | mkV "รําเพย" | mkV "ส่งจูบ" | mkV "เป่าลม" | mkV "สูดจมูก" | mkV "ทําให้บาน" | mkV "ใช้อย่างสุรุ่ยสุร่าย" ; -- src=panlex
lin blow_V = mkV (thword "พัด") | {-pan-} mkV "อม" | mkV "ขาด" | mkV "ดูด" | mkV "พัด" | mkV "พ่น" | mkV "ปลิว" | mkV "เป่า" | mkV "เลีย" | mkV "โม้ก" | mkV "คุยโว" | mkV "ไสหัว" | mkV "ทำลวกๆ" | mkV "วางไข่" | mkV "เงอะงะ" | mkV "โอ้อวด" | mkV "ล่องลอย" | mkV "โ้อ้อวด" | mkV "ถอนหายใจ" | mkV "เป่าแรงๆ" | mkV "ทำงานชุ่ย" | mkV "ทำงานลวกๆ" | mkV "ทำมักง่าย" | mkV "ทำงานมักง่าย" | mkV "ทำงานสะเพร่า" | mkV "ทำให้เสียหาย" | mkV "ลอยไปตามกระแส" | mkV "ใช้จ่ายสุรุ่ยสุร่าย" | mkV "ขาด" | mkV "บาน" | mkV "พัด" | mkV "โชย" | mkV "เป่า" | mkV "ไหม้" | mkV "พ่นลม" | mkV "ระเบิด" | mkV "รําเพย" | mkV "ส่งจูบ" | mkV "เป่าลม" | mkV "สูดจมูก" | mkV "ทําให้บาน" | mkV "ใช้อย่างสุรุ่ยสุร่าย" ; -- src=panlex
lin trip_N = mkN "ทริป" | mkN "การลื่นหกล้ม" | mkN "ประสบการณ์ที่น่าตื่นเต้น" | mkN "การเดินทาง" | mkN "ความผิดพลาด" | mkN "ประสบการณ์น่าตื่นเต้น" ; -- src=panlex
lin observation_N = mkN "การสังเกต" | mkN "ความจริงจากการสังเกต" | mkN "ข่าว" | mkN "ข้อมูล" | mkN "ข้อความ" | mkN "ความเห็น" | mkN "การสังเกต" | mkN "การเฝ้าดู" | mkN "ข้อสังเกต" | mkN "ข้อเตือนใจ" | mkN "การสังเกตการณ์" | mkN "สิ่งที่ได้จากการสังเกต" | mkN "การปฏิบัติตามกฎหรือระเบียบหรือหน้าที่" ; -- src=panlex
lin gather_V2 = mkV2 "สรุป" ; ---- | mkV "สะสม" | mkV "เพิ่ม" | mkV "ชุมนุม" | mkV "รวบรวม" | mkV "หาอาหาร" | mkV "นัดรวมตัว" | mkV "เย็บติดกัน" | mkV "เก็บ" | mkV "ชุมนุม" | mkV "รวบรวม" | mkV "รวมตัว" | mkV "จับกลุ่ม" | mkV "รวมกลุ่ม" | mkV "รวมตัวกัน" | mkV "รวมความคิด" | mkV "เก็บเกี่ยว" | mkV "จับกลุ่มกัน" ; -- src=panlex
lin gather_V = mkV "สรุป" | mkV "สะสม" | mkV "เพิ่ม" | mkV "ชุมนุม" | mkV "รวบรวม" | mkV "หาอาหาร" | mkV "นัดรวมตัว" | mkV "เย็บติดกัน" | mkV "เก็บ" | mkV "ชุมนุม" | mkV "รวบรวม" | mkV "รวมตัว" | mkV "จับกลุ่ม" | mkV "รวมกลุ่ม" | mkV "รวมตัวกัน" | mkV "รวมความคิด" | mkV "เก็บเกี่ยว" | mkV "จับกลุ่มกัน" ; -- src=panlex
lin ancient_A = mkA "โบราณ" | mkA "เก่าแก่" | mkA "แก่หง่อม" | mkA "ธง" | mkA "แบบ" | mkA "อดีต" | mkA "เก่า" | mkA "โบราณ" | mkA "เก่าแก่" | mkA "คนชรามาก" | mkA "ผู้ถือธง" | mkA "โบราณกาล" ; -- src=panlex
lin brief_A = mkA "ย่อๆ" | mkA "สรุป" | mkA "สั้นๆ" | mkA "โดยย่อ" | mkA "โดยสรุป" | mkA "อย่างย่อ" | mkA "โดยสังเขป" | mkA "อย่างสั้นๆ" ; -- src=panlex
lin gate_N = mkN "เกต" | mkN "ประตู" | mkN "ลอจิกเกต" | mkN "ประตูรั้ว" | mkN "วงจรตรรกะ" | mkN "รายได้ค่าบัตรผ่านประตู" | mkN "ทวาร" | mkN "ประตู" | mkN "ประตูรั้ว" | mkN "ประตูใหญ่" | mkN "ทางเข้าออก" | mkN "ประตูเข้าออก" ; -- src=panlex
lin elderly_A = mkA "อาวุโส" | mkA "แก่" | mkA "สูงวัย" | mkA "อาวุโส" | mkA "อายุมาก" | mkA "ค่อนข้างเก่า" | mkA "เกี่ยวกับคนวัยชรา" | mkA "ซึ่งมีอายุอยู่ระหว่างวัยกลางคนกับวัยชรา" ; -- src=panlex
lin persuade_V2V = variants{} ; -- 
lin persuade_V2 = variants{} ; -- 
lin overall_A = mkA "โดยรวม" | mkA "ทั้งหมด" | mkA "ทั้งหมด" | mkA "รวมทั้งสิ้น" | mkA "กล่าวโดยสรุป" ; -- src=panlex
lin rare_A = mkA "หายาก" | mkA "บาง" | mkA "น้อย" | mkA "เลิศ" | mkA "หายาก" | mkA "เบาบาง" | mkA "กึ่งสุก" | mkA "ไม่บ่อย" | mkA "น่าชมเชย" | mkA "ประเสริฐ" | mkA "ซึ่งมีค่า" | mkA "ซึ่งหายาก" | mkA "ไม่ค่อยมี" | mkA "ไม่สุกมาก" ; -- src=panlex
lin index_N = mkN "ชี้" | mkN "กำลัง" | mkN "ดัชนี" | mkN "ดรรชนี" | mkN "นิ้วชี้" | mkN "ค่าดัชนี" | mkN "พระดัชนี" | mkN "เลขดัชนี" | mkN "ตัวยกกำลัง" | mkN "ดัชนีชี้วัด" | mkN "เลขชี้กำลัง" | mkN "ดัชนี" | mkN "ดรรชนี" | mkN "ตัวชี้" | mkN "ตัววัด" | mkN "นิ้วชี้" | mkN "เข็มชี้" | mkN "ตัวบ่งชี้" | mkN "เครื่องชี้" | mkN "เลขกําลังในเครื่องหมายพีชคณิต" ; -- src=panlex
lin hand_V2 = variants{} ; -- 
lin circle_N = mkN "วง" | mkN "โรช" | mkN "วงกลม" | mkN "กลุ่มคน" | mkN "การหมุน" | mkN "วงเวียน" | mkN "รูปวงกลม" | mkN "การหมุนรอบ" | mkN "ถนนรอบเกาะ" | mkN "ที่นั่งชั้นลอย" | mkN "เม็กซิกันแวเลี่ยม" | mkN "อาร์-2" | mkN "กง" | mkN "วง" | mkN "วงกลม" | mkN "วงการ" | mkN "ขอบเขต" | mkN "บริเวณ" | mkN "วงแหวน" | mkN "ปริมณฑล" | mkN "วงเวียน" | mkN "วัฎจักร" | mkN "โคจรรอบ" | mkN "อาณาจักร" | mkN "เส้นวงกลม" | mkN "โรงละครสัตว์" | mkN "การหมุนเวียนครบรอบ" | mkN "ที่นั่งเป็นรูปวงกลม" | mkN "เส้นรอบวงที่แบ่งโลกออกเป็น2ส่วน" ; -- src=panlex
lin creation_N = mkN "งาน" | mkN "ผลงาน" | mkN "จักรวาล" | mkN "สรรพสิ่ง" | mkN "การก่อตั้ง" | mkN "การเริ่มต้น" | mkN "สิ่งมีชีวิต" | mkN "การสร้างสรรค์" | mkN "การสร้าง" | mkN "สรรพสิ่ง" | mkN "การประดิษฐ์" | mkN "การสร้างสรรค์" | mkN "ผลงานประดิษฐ์" | mkN "เสื้อผ้าที่ตกแต่งสวยงาม" ; -- src=panlex
lin drawing_N = mkN "การดึง" | mkN "การลาก" | mkN "งานวาด" | mkN "ภาพเขียน" | mkN "การซื้อหวย" | mkN "การวาดเส้น" | mkN "การเล่นหวย" | mkN "ภาพดรออิ้ง" | mkN "ภาพวาดเส้น" | mkN "การดูดมาใช้" | mkN "การซื้อลอตเตอรี่" | mkN "สลาก" | mkN "การดึง" | mkN "การลาก" | mkN "การวาด" | mkN "ภาพวาด" | mkN "รูปวาด" | mkN "การยกร่าง" | mkN "การวาดรูป" | mkN "การจับฉลาก" | mkN "การจับสลาก" | mkN "ล็อตเตอรี่" | mkN "การสเก็ตช์ภาพ" | mkN "ภาพสเก็ตช์ภาพ" ; -- src=panlex
lin anybody_NP = variants{} ; -- 
lin flow_N = mkN "ระดู" | mkN "เมนส์" | mkN "การไหล" | mkN "รอบเดือน" | mkN "ประจำเดือน" | mkN "อัตราการไหล" | mkN "การไหลเป็นกระแส" | mkN "การไหล" | mkN "การมีระดู" | mkN "การลื่นไหล" | mkN "การหลั่งไหล" | mkN "การไหลเวียน" | mkN "การมีประจําเดือน" ; -- src=panlex
lin matter_V = mkV "มีน้ำหนัก" | mkV "มีความหมาย" | mkV "มีความสําคัญ" | mkV "มีสาระสําคัญ" | mkV "เป็นเรื่องสําคัญ" ; -- src=panlex
lin external_A = mkA "ภายนอก" | mkA "จากภายนอก" | mkA "ในระดับนานาชาติ" | mkA "ผิวนอก" | mkA "ภายนอก" | mkA "ข้างนอก" | mkA "ชั้นนอก" | mkA "ผิวเผิน" | mkA "สิ่งที่อยู่ข้างนอก" ; -- src=panlex
lin capable_A = mkA "ที่สามารถทำได้" | mkA "ที่มีความสามารถ" | mkA "ซึ่งมีความสามารถ" | mkA "มีวิชา" | mkA "มีฝีมือ" | mkA "ซึ่งสามารถ" | mkA "มีสติปัญญา" | mkA "ที่ทําได้ดี" | mkA "ที่สามารถทําได้" ; -- src=panlex
lin recover_V = mkV "กอบกู้" | mkV "พักฟื้น" | mkV "ฟักฟื้น" | mkV "ฟื้นตัว" | mkV "คลุมใหม่" | mkV "นำกลับมาใช้ใหม่" | mkV "ชดเชย" | mkV "ชดใช้" | mkV "ทุเลา" | mkV "หายจาก" | mkV "ได้คืน" | mkV "ฟื้นไข้" | mkV "เอากลับคืน" | mkV "ได้กลับคืน" | mkV "ทําให้ใช้ได้อีก" | mkV "ฟื้นตัวจากการเจ็บป่วย" | mkV "นํากลับมาใช้ประโยชน์ได้อีก" ; -- src=panlex
lin shot_N = mkN "ฉาก" | mkN "ซีน" | mkN "ช็อต" | mkN "การตี" | mkN "สโตรก" | mkN "โอกาส" | mkN "การฉีด" | mkN "การยิง" | mkN "การเดา" | mkN "ภาพถ่าย" | mkN "ลูกปราย" | mkN "นักยิงปืน" | mkN "การขุดคุ้ย" | mkN "การทำประตู" | mkN "การยิงประตู" | mkN "การเยาะเย้ย" | mkN "คำพูดทิ่มแทง" | mkN "คำพูดเย้ยหยัน" | mkN "คำพูดทิ่มแทงใจ" | mkN "การปล่อยยานอวกาศ" | mkN "โอกาส" | mkN "การยิง" | mkN "การเดา" | mkN "ผู้ยิง" | mkN "มือปืน" | mkN "ระยะยิง" | mkN "การฉีดยา" | mkN "การทดลอง" | mkN "คําหนึ่ง" | mkN "วิถีจรวด" | mkN "เสียงยิง" | mkN "การยิงปืน" | mkN "การระเบิด" | mkN "ดินระเบิด" | mkN "ความพยายาม" | mkN "นักแม่นปืน" | mkN "ระยะที่ยิง" | mkN "วิถีกระสุน" | mkN "กระสุนกระจาย" | mkN "ลูกกระสุนปืน" | mkN "จํานวนเล็กน้อย" | mkN "ปริมาณเล็กน้อย" | mkN "การปล่อยขีปนาวุธ" | mkN "การเตะลูกเข้าประตู" | mkN "เสียงที่คล้ายเสียงปืน" | mkN "การกะประมาณจากข้อมูลเพียงเล็กน้อย" ; -- src=panlex
lin request_N = mkN "การขอ" | mkN "การร้องขอ" | mkN "การขอ" | mkN "การขอร้อง" | mkN "คําขอร้อง" | mkN "คําอ้อนวอน" | mkN "ความต้องการ" | mkN "การเรียกร้อง" | mkN "คําเรียกร้อง" | mkN "สิ่งที่ขอร้อง" ; -- src=panlex
lin impression_N = mkN "รอยเว้า" | mkN "ความเชื่อ" | mkN "ตราประทับ" | mkN "การประทับตรา" | mkN "หนังสือที่พิมพ์ทั้งหมด" | mkN "หนังสือที่ตีพิมพ์ทั้งหมด" | mkN "รอยกด" | mkN "งานพิมพ์" | mkN "รอยฝังใจ" | mkN "รอยพิมพ์" | mkN "รอยประทับ" | mkN "สิ่งพิมพ์" | mkN "การประทับใจ" | mkN "ความซาบซึ้ง" | mkN "ความประทับใจ" | mkN "รอยประทับตรา" | mkN "สิ่งที่ประทับใจ" | mkN "ความรู้สึกชื่นชม" | mkN "การล้อเลียนท่าทางหรือการพูดจาของบุคคลที่มีชื่อเสียง" ; -- src=panlex
lin neighbour_N = mkN "เป็นเพื่อน" | mkN "เพื่อนบ้าน" | mkN "นําเข้ามาใกล้" | mkN "ประเทศเพื่อนบ้าน" | mkN "บ้านใกล้เรือนเคียง" ; -- src=panlex
lin theatre_N = mkN "ละคร" | mkN "ละคอน" | mkN "สนามรบ" | mkN "สมรภูมิ" | mkN "โรงละคร" | mkN "โรงมหรสพ" | mkN "เธียเตอร์" | mkN "สถานที่แสดงละคร" | mkN "พื้นที่ปฏิบัติการ" | mkN "บทละคร" | mkN "การละคร" | mkN "โรงละคร" | mkN "โรงมหรสพ" | mkN "ห้องบรรยาย" | mkN "เรื่องละคร" | mkN "สถานที่แสดง" | mkN "โรงภาพยนตร์" | mkN "การสร้างละคร" | mkN "โรงละครกลางแจ้ง" | mkN "ผู้ชมในโรงดังกล่าว" | mkN "การเกิดผืนดินเป็นชั้น ๆ)" ; -- src=panlex
lin beneath_Prep = mkPrep "ภายใต้" | mkPrep "ข้างใต้" | mkPrep "อยู่ใต้" | mkPrep "เลวกว่า" | mkPrep "ข้างล่าง" | mkPrep "ต่ํากว่า" | mkPrep "ต่ําลงไป" | mkPrep "ไม่สมควร" | mkPrep "ไม่เหมาะ" | mkPrep "เสื่อมเสีย" | mkPrep "เสียศักดิ์ศร’" ; -- src=panlex
lin hurt_V2 = mkV2 "ปวด" ; ---- | mkV "เจ็บ" | mkV "ทนทุกข์" | mkV "ทำให้ปวด" | mkV "ทำให้เจ็บ" | mkV "ทุกข์ระทม" | mkV "รู้สึกปวด" | mkV "ทำให้ปวดใจ" | mkV "รู้สึกเจ็บ" | mkV "ทำให้เจ็บใจ" | mkV "ทำให้บาดเจ็บ" | mkV "ทำร้ายความรู้สึก" | mkV "ทำให้เสียความรู้สึก" | mkV "ปวด" | mkV "เจ็บ" | mkV "บอบช้ํา" | mkV "ทําอันตราย" | mkV "ทําร้ายจิตใจ" | mkV "ทําให้เสียใจ" | mkV "ทําให้เจ็บปวด" ; -- src=panlex
lin hurt_V = mkV "ปวด" | mkV "เจ็บ" | mkV "ทนทุกข์" | mkV "ทำให้ปวด" | mkV "ทำให้เจ็บ" | mkV "ทุกข์ระทม" | mkV "รู้สึกปวด" | mkV "ทำให้ปวดใจ" | mkV "รู้สึกเจ็บ" | mkV "ทำให้เจ็บใจ" | mkV "ทำให้บาดเจ็บ" | mkV "ทำร้ายความรู้สึก" | mkV "ทำให้เสียความรู้สึก" | mkV "ปวด" | mkV "เจ็บ" | mkV "บอบช้ํา" | mkV "ทําอันตราย" | mkV "ทําร้ายจิตใจ" | mkV "ทําให้เสียใจ" | mkV "ทําให้เจ็บปวด" ; -- src=panlex
lin mechanism_N = mkN "กลไก" | mkN "เครื่อง" | mkN "จักรกลนิยม" | mkN "กลไกทางเคมี" | mkN "เครื่องยนต์กลไก" | mkN "กลไก" | mkN "หนทาง" | mkN "กลวิธาน" | mkN "วิธีการ" | mkN "โครงสร้าง" | mkN "เครื่องกลไก" | mkN "วิธีการทํางาน" | mkN "ลัทธิวัตถุนิยม" | mkN "ระบบเครื่องกลไก" | mkN "ชิ้นส่วนของเครื่องกลไก" | mkN "ชิ้นส่วนของเครื่องจักร" | mkN "ส่วนประกอบของเครื่องจักร" | mkN "กระบวนการและปฏิกิริยาของแรงจิต" ; -- src=panlex
lin potential_N = mkN "ศักย์ไฟฟ้า" | mkN "ความต่างศักย์" | mkN "สมรรถภาพ" | mkN "ศักยภาพที่จะพัฒนาได้" ; -- src=panlex
lin lean_V2 = mkV2 "พิง" ; ---- | mkV "เอน" | mkV "พึ่งพา" | mkV "เอนตัว" | mkV "ทำให้เอน" | mkV "มีแนวโน้ม" | mkV "พาด" | mkV "พิง" | mkV "ยัน" | mkV "อิง" | mkV "เอน" | mkV "เอียง" | mkV "พึ่งพา" | mkV "พึ่งพิง" | mkV "มีแนวโน้ม" | mkV "โน้มเอียง" ; -- src=panlex
lin lean_V = mkV "พิง" | mkV "เอน" | mkV "พึ่งพา" | mkV "เอนตัว" | mkV "ทำให้เอน" | mkV "มีแนวโน้ม" | mkV "พาด" | mkV "พิง" | mkV "ยัน" | mkV "อิง" | mkV "เอน" | mkV "เอียง" | mkV "พึ่งพา" | mkV "พึ่งพิง" | mkV "มีแนวโน้ม" | mkV "โน้มเอียง" ; -- src=panlex
lin defendant_N = mkN "จำเลย" | mkN "จำเลย" | mkN "ผู้กระทําผิด" | mkN "ผู้ถูกกล่าวหา" | mkN "ซึ่งเป็นการป้องกันหรือแก้ต่าง" ; -- src=panlex
lin atmosphere_N = mkN "รังสี" | mkN "บรรยากาศ" | mkN "เอทีเอ็ม" | mkN "สภาพแวดล้อม" | mkN "ชั้นบรรยากาศ" | mkN "แอตโมสเฟียร์" | mkN "สภาพภูมิอากาศ" | mkN "หน่วยวัดความดันบรรยากาศ" | mkN "อากาศ" | mkN "ท่าทาง" | mkN "บรรยากาศ" | mkN "ภูมิอากาศ" | mkN "สภาวะอากาศ" | mkN "ชั้นบรรยากาศ" | mkN "คุณภาพที่เด่น" | mkN "บรรยากาศรอบโลก" | mkN "ความกดดันบรรยากาศ" | mkN "แก๊สรอบดาวนพเคราะห์" | mkN "บรรยากาศที่น่าสนใจของสถานที่" | mkN "อารมณ์หรือการให้สีของงานศิลป์" ; -- src=panlex
lin slip_V2 = mkV2 "ไถล" ; ---- | mkV "ลื่น" | mkV "ทำผิด" | mkV "แย่ลง" | mkV "ทำพลาด" | mkV "ทำให้หลุด" | mkV "เสื่อมถอย" | mkV "ใส่หรือถอดอย่างง่ายและรวดเร็ว" | mkV "ไถล" | mkV "ลื่น" | mkV "ลื่นไถล" | mkV "ทําให้ไถลไป" | mkV "ทําให้ลื่นไถล" | mkV "ใส่หรือถอดอย่างง่ายและรวดเร็ว" ; -- src=panlex
lin slip_V = mkV "ไถล" | mkV "ลื่น" | mkV "ทำผิด" | mkV "แย่ลง" | mkV "ทำพลาด" | mkV "ทำให้หลุด" | mkV "เสื่อมถอย" | mkV "ใส่หรือถอดอย่างง่ายและรวดเร็ว" | mkV "ไถล" | mkV "ลื่น" | mkV "ลื่นไถล" | mkV "ทําให้ไถลไป" | mkV "ทําให้ลื่นไถล" | mkV "ใส่หรือถอดอย่างง่ายและรวดเร็ว" ; -- src=panlex
lin chain_N = mkN "พวง" | mkN "เชน" | mkN "โซ่" | mkN "สร้อย" | mkN "เทือก" | mkN "ลูกโซ่" | mkN "สายโซ่" | mkN "สายสร้อย" | mkN "เทือกเขา" | mkN "บริษัทในเครือ" | mkN "ทิว" | mkN "โซ่" | mkN "จํากัด" | mkN "ผูกมัด" | mkN "ลูกโซ่" | mkN "อนุกรม" | mkN "โซ่ตรวน" | mkN "สายสร้อย" | mkN "เทือกเขา" | mkN "เครื่องผูกมัด" | mkN "เหตุการณ์ที่เกิดต่อเนื่องกัน" | mkN "บริษัทต่างๆที่อยู่ในเครือเดียวกัน" ; -- src=panlex
lin accompany_V2 = variants{} ; -- 
lin wonderful_A = mkA "เลอเลิศ" | mkA "ดีเยี่ยม" | mkA "น่าพิศวง" | mkA "มหัศจรรย์" | mkA "ยอดเยี่ยม" ; -- src=panlex
lin earn_V2 = mkV2 "ได้รับ" ; ---- | mkV "ได้" | mkV "หาได้" | mkV "ได้รับ" | mkV "ปรารถนา" | mkV "หามาได้" | mkV "อยากได้" | mkV "มีรายได้" | mkV "ได้กําไร" | mkV "สมควรได้รับ" | mkV "ได้รับรายได้" | mkV "ได้เงินจากการทํางาน" ; -- src=panlex
lin earn_V = mkV "ได้รับ" | mkV "ได้" | mkV "หาได้" | mkV "ได้รับ" | mkV "ปรารถนา" | mkV "หามาได้" | mkV "อยากได้" | mkV "มีรายได้" | mkV "ได้กําไร" | mkV "สมควรได้รับ" | mkV "ได้รับรายได้" | mkV "ได้เงินจากการทํางาน" ; -- src=panlex
lin enemy_N = personN (thword "ศัต" "รู") | {-pan-} mkN "อริ" | mkN "ศัตรู" | mkN "กองทัพ" | mkN "ข้าศึก" | mkN "ปรปักษ์" | mkN "คู่ปรปักษ์" | mkN "กองทัพศัตรู" | mkN "ฝ่ายตรงข้าม" | mkN "กองกำลังข้าศึก" | mkN "กองทัพฝ่ายตรงข้าม" | mkN "กองกำลังฝ่ายตรงข้าม" | mkN "ศัตรู" | mkN "ข้าศึก" | mkN "คู่อริ" | mkN "คู่แค้น" | mkN "ปรปักษ์" | mkN "ฝ่ายศัตรู" | mkN "สิ่งที่เป็นภัย" | mkN "สิ่งที่เป็นอันตราย" ; -- src=panlex ----?
lin desk_N = mkN "โต๊ะเขียนหนังสือ" | mkN "กอง" | mkN "ฝ่าย" | mkN "แผนก" | mkN "โต๊ะ" | mkN "เคาน์เตอร์บริการในโรงแรมหรือสนามบิน" ; -- src=panlex
lin engineering_N = mkN "งานวิศวกรรม" | mkN "ห้องเครื่อง" | mkN "งานเทคโนโลยี" | mkN "งานทางวิศวกรรม" | mkN "วิศวกรรมศาสตร์" | mkN "งานทางเทคโนโลยี" | mkN "ห้องเครื่องยนต์" | mkN "วิทยาศาสตร์ประยุกต์" | mkN "วิศวกรรมศาสตร์ประยุกต์" | mkN "การช่าง" | mkN "วิศวกรรม" | mkN "การจัดการ" | mkN "วิศวกรรมศาสตร์" | mkN "การวางแผนและควบคุมอย่างชํานิชํานาญ" ; -- src=panlex
lin panel_N = mkN "แผ่น" | mkN "คณะลูกขุน" | mkN "แผงควบคุม" | mkN "แผงสวิตช์" | mkN "กรอบโต้ตอบ" | mkN "คอนโทรลพาเนล" | mkN "ผ้าสามเหลี่ยม" | mkN "คณะลุกขุน" | mkN "บัญชีชื่อ" | mkN "แผงหน้าปัด" | mkN "เบาะรองอานม้า" | mkN "แผงควบคุมไฟฟ้า" | mkN "แผนการประกันสังคม" | mkN "ดิ้นประดับบนชุดสตรี" | mkN "คณะผู้อภิปรายทางการเมือง" ; -- src=panlex
lin distinction_N = mkN "ความโดดเด่น" | mkN "การแยกความต่าง" | mkN "การแยกแยะ" | mkN "ความแตกต่าง" | mkN "ความโดดเด่น" | mkN "ความมีอํานาจ" | mkN "ความยอดเยี่ยม" | mkN "ลักษณะที่เด่น" | mkN "ความมีชื่อเสียง" ; -- src=panlex
lin deputy_N = mkN "ตัวแทน" | mkN "ผู้ช่วย" | mkN "รองนายอำเภอ" | mkN "ตัวแทน" | mkN "ผู้แทน" | mkN "ผู้รักษาการแทน" ; -- src=panlex
lin discipline_N = mkN "วิชา" | mkN "สาขา" | mkN "ศาสตร์" | mkN "ความมีระเบียบวินัย" | mkN "กฎ" | mkN "ลงโทษ" | mkN "วินัย" | mkN "แก้ไข" | mkN "ระเบียบ" | mkN "การฝึกฝน" | mkN "การลงโทษ" | mkN "สาขาวิชา" | mkN "ข้อบังคับ" | mkN "ธรรมวินัย" | mkN "ศิลปปฎิบัติ" | mkN "ระเบียบวินัย" | mkN "ทําให้มีวินัย" ; -- src=panlex
lin strike_N = variants{} ; -- 
lin strike_2_N = variants{} ; -- 
lin strike_1_N = variants{} ; -- 
lin married_A = mkA "ที่แต่งงานแล้ว" | mkA "ที่มีเหย้ามีเรือน" | mkA "ซึ่งเกี่ยวกับการสมรส" | mkA "สมรสแล้ว" | mkA "มีครอบครัว" | mkA "แต่งกับงาน" | mkA "แต่งงานแล้ว" | mkA "อุทิศตัวให้กับ" | mkA "เกี่ยวกับการสมรส" | mkA "เกี่ยวกับการแต่งงาน" | mkA "เกี่ยวกับคนที่แต่งงานแล้ว" ; -- src=panlex
lin plenty_NP = variants{} ; -- 
lin establishment_N = mkN "สถาบัน" | mkN "องค์การ" | mkN "การก่อตั้ง" | mkN "การจัดตั้ง" | mkN "ผู้ก่อตั้ง" | mkN "องค์กรขนาดใหญ่" | mkN "การตั้งหลักปักฐาน" | mkN "สถานที่ซึ่งก่อตั้งขึ้น" | mkN "สถาบัน" | mkN "องค์การ" | mkN "การสร้าง" | mkN "การสถาปนา" | mkN "ที่ทําการ" | mkN "บ้านเรือน" | mkN "การก่อตั้ง" | mkN "การจัดตั้ง" | mkN "การตั้งมั่น" | mkN "สิ่งก่อสร้าง" ; -- src=panlex
lin fashion_N = mkN "แฟชั่น" | mkN "แบบอย่าง" | mkN "วิธีปฏิบัติ" | mkN "สินค้าแฟชั่น" | mkN "สินค้าตามกระแสนิยม" | mkN "รูปแบบ" | mkN "แฟชั่น" | mkN "วิธีการ" | mkN "แบบสมัยนิยม" | mkN "รูปแบบที่กําลังนิยม" | mkN "วิธีการที่กําลังนิยม" | mkN "สิ่งที่กําลังนิยมกัน" | mkN "สิ่งที่กําลังเป็นที่นิยม" | mkN "คนที่มีชื่อเสียงเป็นที่นิยม" ; -- src=panlex
lin roof_N = mkN (thword "หลัง" "คา") | {-pan-} mkN "เพดาน" | mkN "หลังคา" | mkN "หลังคารถ" | mkN "ขีดสูงสุด" | mkN "เพดานสูงสุด" | mkN "ส่วนบน" | mkN "หลังคา" | mkN "เพดาปาก" | mkN "หลังคารถ" | mkN "เพดานปาก" | mkN "โครงค้ําหลังคา" | mkN "หลังคาสิ่งปลูกสร้าง" | mkN "สิ่งที่คล้ายหลังคาบ้าน" ; -- src=panlex ----?
lin milk_N = mkN (thword "นม") kew_s | {-pan-} mkN "นม" | mkN "น้ำนม" | mkN "อาหารที่มีประโยชน์เหมือนนม" | mkN "นม" | mkN "รีด" | mkN "น้ํานม" | mkN "ปอกลอก" ; -- src=panlex
lin entire_A = mkA "ทั้งปวง" | mkA "ทั้งมวล" | mkA "ทั้งหมด" | mkA "ทั้งสิ้น" | mkA "อย่างละเอียดถี่ถ้วน" | mkA "จํานวนหรือปริมาณทั้งหมด" ; -- src=panlex
lin tear_N = mkN "น้ำตา" | mkN "การฉีก" | mkN "รอยแยก" | mkN "พระอัสสุ" | mkN "หยดน้ำตา" | mkN "หยาดน้ำตา" | mkN "การกินดื่ม" | mkN "น้ำพระเนตร" | mkN "ช่วงที่กินดื่มมากเกินไป" | mkN "น้ำตา" | mkN "การฉีก" | mkN "น้ําตา" | mkN "รอยขาด" | mkN "รอยฉีก" | mkN "การรีบเร่ง" | mkN "การร้องไห้" | mkN "หยดของเหลว" ; -- src=panlex
lin secondary_A = mkA "รอง" | mkA "ถัดไป" | mkA "มัธยม" | mkA "ทีหลัง" | mkA "ที่สอง" | mkA "ทุติยะ" | mkA "สังกัด" | mkA "สํารอง" | mkA "ทางอ้อม" | mkA "ด้อยกว่า" | mkA "ส่งเสริม" | mkA "ได้มาจาก" | mkA "ต่อเนื่อง" | mkA "ทุติยภูมิ" | mkA "ลําดับสอง" | mkA "ส่วนเสริม" | mkA "อันดับรอง" | mkA "ไม่สําคัญ" | mkA "ระดับมัธยม" | mkA "ลําดับที่สอง" | mkA "ไม่สําคัญมาก" | mkA "ต่อจากขั้นแรก" | mkA "เกี่ยวกับอดีต" | mkA "เป็นอนุพันธุ์" | mkA "เกี่ยวกับโรงเรียนมัธยม" | mkA "เกี่ยวกับการเน้นเสียงที่สอง" ; -- src=panlex
lin finding_N = mkN "สิ่งที่ค้นพบ" | mkN "คำตัดสินของศาล" | mkN "การค้นพบ" | mkN "การค้นหา" | mkN "การตรวจสอบ" | mkN "คําพิพากษา" | mkN "คําวินิจฉัย" | mkN "สิ่งที่ค้นพบ" | mkN "ผลของการค้นหา" | mkN "ผลของการสืบค้น" | mkN "คําตัดสินของศาล" ; -- src=panlex
lin welfare_N = mkN "สวัสดิการ" | mkN "สวัสดิการสังคม" | mkN "ความสุข" | mkN "ความสบาย" | mkN "สวัสดิการ" | mkN "สวัสดิภาพ" | mkN "งานสวัสดิการ" | mkN "ความสะดวกสบาย" | mkN "ความมีสุขภาพดี" | mkN "ประชาสงเคราะห์" | mkN "สังคมสงเคราะห์" ; -- src=panlex
lin increased_A = mkA "ซึ่งมากขึ้น" | mkA "ซึ่งเพิ่มขึ้น" ; -- src=panlex
lin attach_V2 = mkV2 "ติด" ; ---- | mkV "ยึด" | mkV "อายัด" | mkV "ผูกพัน" | mkV "สัมพันธ์" | mkV "ทำให้ติดกัน" | mkV "ต่อ" | mkV "เติม" | mkV "เพิ่ม" | mkV "ติดกัน" | mkV "ยึดติด" | mkV "ทําให้ติดกัน" | mkV "มีความผูกพันกับ" | mkV "มีความสัมพันธ์กับ" ; -- src=panlex
lin attach_V = mkV "ติด" | mkV "ยึด" | mkV "อายัด" | mkV "ผูกพัน" | mkV "สัมพันธ์" | mkV "ทำให้ติดกัน" | mkV "ต่อ" | mkV "เติม" | mkV "เพิ่ม" | mkV "ติดกัน" | mkV "ยึดติด" | mkV "ทําให้ติดกัน" | mkV "มีความผูกพันกับ" | mkV "มีความสัมพันธ์กับ" ; -- src=panlex
lin typical_A = variants{} ; -- 
lin typical_3_A = variants{} ; -- 
lin typical_2_A = variants{} ; -- 
lin typical_1_A = variants{} ; -- 
lin meanwhile_Adv = mkAdv "ขณะที่" | mkAdv "ขณะนั้น" | mkAdv "ขณะที่" | mkAdv "ในขณะที่" | mkAdv "ในระหว่าง" | mkAdv "เวลาในระหว่างนั้น" ; -- src=panlex
lin leadership_N = mkN "ภาวะผู้นำ" | mkN "กลุ่มผู้นำ" | mkN "การเป็นผู้นำ" | mkN "ความเป็นผู้นำ" | mkN "การนํา" | mkN "ความเป็นผู้นํา" | mkN "ตําแหน่งผู้นํา" | mkN "ผู้นําของกลุ่ม" | mkN "ตําแหน่งหัวหน้า" | mkN "ความสามารถในการนํา" | mkN "ความสามารถในการเป็นผู้นํา" ; -- src=panlex
lin walk_N = mkN "การเดิน" | mkN "ทางเดิน" | mkN "ท่าเดิน" | mkN "การเดินของม้า" | mkN "การงานโดยทั่วไป" | mkN "ท่วงท่าในการเดิน" | mkN "การเหยาะย่างของม้า" | mkN "การเดินทางโดยทางเท้า" | mkN "ระยะทางที่เดินทางด้วยเท้า" | mkN "ช่วงเวลาที่เดินทางด้วยเท้า" ; -- src=panlex
lin negotiation_N = mkN "การเจรจา" | mkN "การเจรจา" | mkN "การต่อรอง" | mkN "การเจรจาต่อรอง" ; -- src=panlex
lin clean_A = mkA (thword "ทำ" "ความ" "สะ" "อาด") | {-pan-} mkA "ใส" | mkA "ว่าง" | mkA "สะอาด" | mkA "เปล่า" | mkA "บริสุทธิ์" | mkA "ที่ขาวสะอาด" | mkA "ซึ่งไม่เสพยา" | mkA "ซึ่งไม่พกอาวุธ" | mkA "ซึ่งไม่ติดเชื้อ" | mkA "ซึ่งไม่มีรอยแก้" | mkA "ที่มีน้ำใจนักกีฬา" | mkA "ซึ่งไม่มีรอยขีดแก้" | mkA "ซึ่งไม่มีความยุ่งยาก" | mkA "สะอาด" | mkA "หมดจด" | mkA "สุจริต" | mkA "ทั้งหมด" | mkA "สมบูรณ์" | mkA "เกลี้ยง" | mkA "ยุติธรรม" | mkA "รักสะอาด" | mkA "บริสุทธิ์" | mkA "ไม่มีมลทิน" | mkA "ไม่หยาบคาย" | mkA "ไร้เดียงสา" | mkA "ที่ไม่มีบาป" | mkA "ไม่มีรอยแก้" | mkA "ที่ไม่มีอาวุธ" | mkA "ไม่มีทั้งสิ้น" | mkA "ไม่มีอุปสรรค์" | mkA "เป็นระเบียบเรียบร้อย" | mkA "ไม่มีกัมมันตภาพรังสี" | mkA "ที่ไม่มีปัญหาเรื่องยาเสพย์ติด" ; -- src=panlex
lin religion_N = mkN (thword "ศาส" "นา") | {-pan-} mkN "องค์กรศาสนา" | mkN "ความเชื่อทางศาสนา" | mkN "ธรรมะ" | mkN "ลัทธิ" | mkN "ศาสนา" | mkN "หลักธรรม" | mkN "ความศรัทธา" | mkN "กลุ่มนักบวช" | mkN "เรื่องศาสนา" | mkN "ความเลื่อมใส" | mkN "ชีวิตในศาสนา" | mkN "ลัทธิความเชื่อ" | mkN "ความเชื่อในศาสนา" | mkN "ความเลื่อมใสในศาสนา" ; -- src=panlex ----?
lin count_V2 = mkV2 (thword "นับ") ;
lin count_V = mkV "นับ" | mkV "นับเลข" | mkV "พึ่งพา" | mkV "คำนึงถึง" | mkV "นับจำนวน" | mkV "มีน้ำหนัก" | mkV "นับ" | mkV "พิจารณา" | mkV "มีความสําคัญ" | mkV "รวมเข้าไปด้วย" | mkV "พิจารณารวมไปด้วย" ; -- src=panlex
lin grey_A = mkA "เทา" | mkA "ที่มีผมสีขาว" | mkA "ที่มีผมสีเทา" | mkA "เทา" | mkA "หงอก" | mkA "สีเทา" | mkA "แก่มาก" | mkA "เก่ามาก" ; -- src=panlex
lin hence_Adv = mkAdv "ดังนั้น" | mkAdv "ดังนั้น" | mkAdv "ต่อแต่นี้ไป" | mkAdv "เพราะฉะนั้น" | mkAdv "ตั้งแต่นี้ต่อไป" ; -- src=panlex
lin alright_Adv = mkAdv "ตกลง" | mkAdv "โอเค" | mkAdv "แน่นอน" | mkAdv "อย่างน่าพอใจ" | mkAdv "ดีแล้ว" | mkAdv "น่าพอใจ" ; -- src=panlex
lin first_A = variants{} ; -- 
lin fuel_N = mkN "เชื้อไฟ" | mkN "เชื้อเพลิง" | mkN "เชื้อ" | mkN "เชื้อไฟ" | mkN "ตัวกระตุ้น" | mkN "เชื้อเพลิง" ; -- src=panlex
lin mine_N = mkN "เหมือง" | mkN "ทุ่นระเบิด" | mkN "บ่อแร่" | mkN "ระเบิด" | mkN "ลูกระเบิด" | mkN "เหมืองแร่" | mkN "แหล่งที่มีมากมาย" | mkN "แหล่งอุดมสมบูรณ์" ; -- src=panlex
lin appeal_V2 = mkV2 "อ้าง" ; ---- | mkV "ดึงดูด" | mkV "วิงวอน" | mkV "อุทธรณ์" | mkV "ดึงดูดใจ" | mkV "ขออุทธรณ์" | mkV "ยื่นอุทธรณ์" | mkV "ดึงดูด" | mkV "ร้องขอ" | mkV "อ้อนวอน" | mkV "ขออุทธรณ์" | mkV "ทําให้สนใจ" ; -- src=panlex
lin appeal_V = mkV "อ้าง" | mkV "ดึงดูด" | mkV "วิงวอน" | mkV "อุทธรณ์" | mkV "ดึงดูดใจ" | mkV "ขออุทธรณ์" | mkV "ยื่นอุทธรณ์" | mkV "ดึงดูด" | mkV "ร้องขอ" | mkV "อ้อนวอน" | mkV "ขออุทธรณ์" | mkV "ทําให้สนใจ" ; -- src=panlex
lin servantMasc_N = variants{} ; -- 
lin liability_N = mkN "ข้อผูกมัดทางการเงิน" | mkN "หนี้" | mkN "หนี้สิน" | mkN "หนี้เงิน" | mkN "ภาระหน้าที่" | mkN "ข้อเสียเปรียบ" | mkN "ความรับผิดชอบ" | mkN "ความโน้มเอียง" | mkN "ด้านลูกหนี้ของบัญชี" ; -- src=panlex
lin constant_A = mkA "คงที่" | mkA "มั่นคง" | mkA "แน่วแน่" | mkA "ซื่อสัตย์" | mkA "ต่อเนื่อง" | mkA "ไม่เปลี่ยนแปลง" | mkA "ที่ไม่เปลี่ยนแปลง" | mkA "ที่เกิดขึ้นตลอดเวลา" | mkA "ที่เกิดขึ้นอย่างต่อเนื่อง" ; -- src=panlex
lin hate_VV = variants{}; -- mkV2 "เกลียด" ;
lin hate_V2 = mkV2 "เกลียด" ;
lin shoe_N = mkN (thword "รอง" "เท้า") | {-pan-} mkN "เกือก" | mkN "รองบาท" | mkN "ฝักเบรก" | mkN "รองเท้า" | mkN "กล่องไพ่" | mkN "เกือกม้า" | mkN "รองพระบาท" | mkN "ฉลองพระบาท" | mkN "ปลอก" | mkN "เกือก" | mkN "รองเท้า" | mkN "สวมปลอก" | mkN "เกือกม้า" | mkN "ก้านห้ามล้อ" | mkN "ปลอกเสาเข็ม" | mkN "ปลอกไม้เท้า" | mkN "เหล็กเกือกม้า" | mkN "ใส่หัวหุ้มโลหะ" | mkN "หัวหุ้มโลหะของไม้เท้า" ; -- src=panlex ----?
lin expense_N = mkN "รายจ่าย" | mkN "ค่าใช้จ่าย" | mkN "การสละ" | mkN "การเสียไป" | mkN "การใช้จ่าย" | mkN "ค่าเสียหาย" | mkN "ค่าใช้จ่าย" ; -- src=panlex
lin vast_A = mkA "มหึมา" | mkA "มโหฬาร" | mkA "ใหญ่โต" | mkA "กว้างใหญ่" ; -- src=panlex
lin soil_N = mkN "ดิน" | mkN "ที่" | mkN "ดินแดน" | mkN "อาณาเขต" | mkN "ความสกปรก" | mkN "ดิน" | mkN "ดินแดน" | mkN "ที่ดิน" | mkN "ประเทศ" | mkN "พื้นดิน" | mkN "ปิตุภูมิ" | mkN "เกษตรกรรม" | mkN "ภูมิลําเนา" | mkN "การทําให้เปื้อน" | mkN "ดินชนิดใดชนิดหนึ่ง" | mkN "ที่ทีเหมาะสําหรับเจริญเติบโต" ; -- src=panlex
lin writing_N = mkN "การเขียน" | mkN "งานเขียน" | mkN "การประพันธ์" | mkN "การแต่งหนังสือ" | mkN "การเขียนหนังสือ" | mkN "จดหมาย" | mkN "ลายมือ" | mkN "การเขียน" | mkN "ข้อเขียน" | mkN "งานเขียน" | mkN "ตัวเขียน" | mkN "แบบเขียน" | mkN "ตัวหนังสือ" | mkN "หนังสือสลัก" | mkN "สิ่งที่เขียน" | mkN "การเขียนจดหมาย" | mkN "การแต่งหนังสือ" | mkN "เรื่องที่เขียน" | mkN "การเขียนหนังสือ" ; -- src=panlex
lin nose_N = mkN (thword "จมูก") | {-pan-} mkN "จมูก" | mkN "นาสา" | mkN "ปลาย" | mkN "นาสิก" | mkN "หัวฉีด" | mkN "หัวน้ำ" | mkN "พระนาสา" | mkN "ปลายจมูก" | mkN "พระนาสิก" | mkN "ประสาทรับกลิ่น" | mkN "ทักษะตามธรรมชาติ" | mkN "ความสามารถที่ติดตัวมา" | mkN "จมูก" ; -- src=panlex
lin origin_N = mkN "กำพืด" | mkN "จุดเริ่ม" | mkN "สายเลือด" | mkN "เชื้อสาย" | mkN "จุดกำเนิด" | mkN "ต้นกำเนิด" | mkN "สายตระกูล" | mkN "ผู้สืบสกุล" | mkN "แหล่งกำเนิด" | mkN "การสืบสายเลือด" | mkN "เทือกเถาเหล่ากอ" | mkN "ที่มา" | mkN "รากฐาน" | mkN "การเกิด" | mkN "จุดเดิม" | mkN "บ่อเกิด" | mkN "มูลเหตุ" | mkN "วงศ์วาน" | mkN "ต้นตระกูล" | mkN "บรรพบุรุษ" | mkN "พืชพันธุ์" | mkN "จุดกําเนิด" | mkN "ต้นกําเนิด" | mkN "จุดเริ่มต้น" | mkN "ระยะแรกเริ่ม" | mkN "แหล่งกําเนิด" ; -- src=panlex
lin lord_N = mkN "ผู้มีอำนาจ" | mkN "พระยา" | mkN "ขุนนาง" | mkN "เจ้านาย" | mkN "ท่านลอร์ด" | mkN "เจ้าศักดินา" | mkN "เจ้าเหนือหัว" | mkN "พระเยซูคริสต์" | mkN "เจ้าของที่ดิน" | mkN "ผู้นําในการค้า" | mkN "พระผู้เป็นเจ้า" | mkN "เจ้าของคฤหาสน์" | mkN "สมาชิกสภาขุนนาง" | mkN "สมาชิกของสภาขุนนาง" | mkN "ผู้ทรงอิทธิพลในอาชีพ" | mkN "ตั้งตัวเป็นเจ้าเหนือหัว" | mkN "ผู้ที่เป็นเจ้าของทรัพย์สมบัติ" | mkN "เจ้านายผู้มีอํานาจปกครองแคว้น" | mkN "บรรดาศักดิ์ของเจ้าหน้าที่ระดับสูงในอังกฤษ" | mkN "บรรดาศักดิ์อย่างเป็นทางการของพระในคริสตศาสนา" ; -- src=panlex
lin rest_V2 = variants{} ; -- 
lin drive_N = mkN "ไดรฟ์" | mkN "การขับ" | mkN "แรงขับ" | mkN "การขับรถ" | mkN "การไดรฟ์" | mkN "หน่วยขับ" | mkN "การขับขี่" | mkN "การรณรงค์" | mkN "การตีกอล์ฟ" | mkN "การผลักดัน" | mkN "การต้อนสัตว์" | mkN "ถนนส่วนบุคคล" | mkN "การไดรฟ์กอล์ฟ" | mkN "การต้อนฝูงสัตว์" | mkN "ถนนที่มีต้นไม้สองข้างทาง" | mkN "ถนน" | mkN "แรงขับ" | mkN "การขับรถ" | mkN "การขับขี่" | mkN "การผลักดัน" | mkN "แรงผลักดัน" ; -- src=panlex
lin ticket_N = mkN "ฉลาก" | mkN "ตั๋ว" | mkN "บัตร" | mkN "ตั๋ว" | mkN "บัตร" | mkN "ป้ายราคา" | mkN "ใบอนุญาต" | mkN "บัตรอนุญาต" | mkN "ป้ายบอกขาย" | mkN "ฉลากติดสินค้า" | mkN "รายชื่อสมาชิกผู้สมัครรับเลือกตั้ง" | mkN "ใบอนุญาตสําหรับกัปตันเรือหรือเครื่องบิน" ; -- src=panlex
lin editor_N = mkN "บ.ก." | mkN "สาราณียกร" | mkN "บรรณาธิการ" | mkN "โปรแกรมบรรณาธิกร" | mkN "โปรแกรมอิดิเตอร์" | mkN "บ.ก." | mkN "ผู้รวบรวม" | mkN "บรรณาธิการ" | mkN "ผู้เรียบเรียง" ; -- src=panlex
lin switch_V2 = mkV2 "เปิด" ; ---- | mkV "ค้าขาย" | mkV "จัดใหม่" | mkV "เปลี่ยน" | mkV "สับเปลี่ยน" | mkV "เฆี่ยนด้วยไม้เรียว" | mkV "เปลี่ยน" | mkV "แกว่งไปมา" | mkV "กระดิกไปมา" | mkV "สับรางรถไฟ" | mkV "สับเปลี่ยน" | mkV "เปลี่ยนรางรถไฟ" | mkV "สับเปลี่ยนสวิตช์ไฟฟ้า" ; -- src=panlex
lin switch_V = mkV "เปิด" | mkV "ค้าขาย" | mkV "จัดใหม่" | mkV "เปลี่ยน" | mkV "สับเปลี่ยน" | mkV "เฆี่ยนด้วยไม้เรียว" | mkV "เปลี่ยน" | mkV "แกว่งไปมา" | mkV "กระดิกไปมา" | mkV "สับรางรถไฟ" | mkV "สับเปลี่ยน" | mkV "เปลี่ยนรางรถไฟ" | mkV "สับเปลี่ยนสวิตช์ไฟฟ้า" ; -- src=panlex
lin provided_Subj = variants{} ; -- 
lin northern_A = mkA "ทางเหนือ" | mkA "ที่อยู่ทางเหนือ" | mkA "ที่มาจากทางทิศเหนือ" | mkA "ทางเหนือ" | mkA "เกี่ยวกับทางเหนือ" | mkA "ทางทิศเหนือหรือภาคเหนือ" ; -- src=panlex
lin significance_N = mkN "ความหมาย" | mkN "ความสําคัญ" | mkN "ผลที่ตามมา" | mkN "ประเด็นหลัก" | mkN "การมีความหมาย" | mkN "ลักษณะที่สําคัญ" ; -- src=panlex
lin channel_N = mkN "ช่อง" | mkN "ร่อง" | mkN "หลอด" | mkN "ทางน้ำ" | mkN "แชนเนล" | mkN "ช่องแคบ" | mkN "ร่องน้ำ" | mkN "ช่องทีวี" | mkN "ช่องสัญญาณ" | mkN "ช่องโทรทัศน์" | mkN "ช่องทางสื่อสาร" | mkN "ช่องทางกระจายสินค้า" | mkN "ราง" | mkN "ช่อง" | mkN "ขุดทาง" | mkN "นําทาง" | mkN "แนวทาง" | mkN "ช่องทาง" | mkN "ช่องแคบ" | mkN "ทางผ่าน" | mkN "วิถีทาง" | mkN "ร่องน้ํา" | mkN "ขุดทางน้ํา" | mkN "ทางน้ําไหล" | mkN "บุกเบิกทาง" | mkN "ทางเดินเรือ" | mkN "ช่องทางสื่อสาร" | mkN "เส้นทางที่ใช้ลําเลียง" ; -- src=panlex
lin convention_N = mkN "การประชุม" | mkN "ข้อตกลงนานาชาติ" | mkN "สัญญา" | mkN "ข้อตกลง" | mkN "อนุสัญญา" | mkN "การชุมนุม" | mkN "การประชุม" | mkN "สนธิสัญญา" | mkN "จารีตประเพณี" | mkN "ระเบียบแบบแผน" | mkN "ธรรมเนียมปฎิบัติ" | mkN "การประชุมที่มีกําหนด" | mkN "การประชุมพรรคการเมือง" ; -- src=panlex
lin damage_V2 = variants{} ; -- 
lin funny_A = mkA "ตลก" | mkA "แปลก" | mkA "ซึ่งคาดไม่ถึง" | mkA "ซึ่งรู้สึกแปลกๆ" | mkA "ตลก" | mkA "สนุก" | mkA "พิลึก" | mkA "โอหัง" | mkA "หลอกลวง" | mkA "น่าขบขัน" | mkA "น่าสงสัย" | mkA "แปลกประหลาด" ; -- src=panlex
lin bone_N = mkN (thword "กระ" "ดูก") | {-pan-} mkN "สีนวล" | mkN "กระดูก" | mkN "พระอัฐิ" | mkN "สีงาช้าง" | mkN "กระดูกกระเดี้ยว" | mkN "ก้าง" | mkN "กระดูก" | mkN "วัตถุหรือสารสีขาวจากร่างกายสัตว์" ; -- src=panlex
lin severe_A = mkA "ฉกรรจ์" | mkA "รุนแรง" | mkA "สาหัส" | mkA "เคร่ง" | mkA "กวดขัน" | mkA "รุนแรง" | mkA "ดุเดือด" | mkA "ร้ายแรง" | mkA "หนาวจัด" | mkA "เข้มงวด" | mkA "เสียดสี" | mkA "แม่นยํา" | mkA "เหน็บแนม" | mkA "ยากลําบาก" | mkA "เคร่งขรึม" | mkA "เคร่งครัด" | mkA "เอาจริงเอาจัง" ; -- src=panlex
lin search_V2 = mkV2 "หา" ; ---- | mkV "ค้นหา" | mkV "มองหา" | mkV "เสาะหา" | mkV "ค้นคว้า" | mkV "ค้นหา" | mkV "มองหา" | mkV "ตรวจหา" | mkV "ตรวจค้น" | mkV "ตรวจสอบ" | mkV "สืบเสาะ" | mkV "เสาะหาข้อมูล" | mkV "ค้นคว้าข้อมูล" ; -- src=panlex
lin search_V = mkV "หา" | mkV "ค้นหา" | mkV "มองหา" | mkV "เสาะหา" | mkV "ค้นคว้า" | mkV "ค้นหา" | mkV "มองหา" | mkV "ตรวจหา" | mkV "ตรวจค้น" | mkV "ตรวจสอบ" | mkV "สืบเสาะ" | mkV "เสาะหาข้อมูล" | mkV "ค้นคว้าข้อมูล" ; -- src=panlex
lin iron_N = mkN "เหล็ก" | {-pan-} mkN "เตารีด" | mkN "หัวเหล็ก" | mkN "ธาตุเหล็ก" | mkN "เหล็กตีตรา" | mkN "เลขอะตอม 26" | mkN "ตรวน" | mkN "เตารีด" | mkN "โซ่ตรวน" | mkN "ธาตุเหล็ก" | mkN "สิ่งที่แข็งแกร่ง" | mkN "บึกบึนเหมือนเหล็ก" | mkN "วัตถุที่ทําจากเหล็ก" | mkN "เข้มแข็งเหมือนเหล็ก" | mkN "เครื่องมือที่ทําด้วยเหล็ก" ; -- src=panlex ----?
lin vision_N = mkN "ภาพ" | mkN "การเห็น" | mkN "จินตนาการ" | mkN "การมองเห็น" | mkN "ประสบการณ์ทางศาสนา" | mkN "ภาพ" | mkN "เห็น" | mkN "นิมิต" | mkN "สายตา" | mkN "ทรรศนะ" | mkN "จินตนาการ" | mkN "ทัศนวิสัย" | mkN "การคาดคะเน" | mkN "การมองเห็น" | mkN "การวาดมโนภาพ" | mkN "การวาดภาพในใจ" | mkN "สิ่งที่มองเห็น" | mkN "ความรู้สึกลวงตา" | mkN "อํานาจในการคาดคะเน" | mkN "การเห็นหรือรู้ล่วงหน้า" | mkN "ความสามารถในการเห็นภาพ" | mkN "ความสามารถในการรับรู้หรือเข้าใจด้วยการคาดการณ์" ; -- src=panlex
lin via_Prep = mkPrep "ทาง" | mkPrep "โดยทาง" | mkPrep "โดยเส้นทาง" | mkPrep "ด้วยวิธีการ" ; -- src=panlex
lin somewhat_Adv = mkAdv "พอควร" | mkAdv "พอใช้" | mkAdv "ค่อนข้าง" | mkAdv "พอประมาณ" | mkAdv "อย่างพอใช้" | mkAdv "อย่างปานกลาง" | mkAdv "อย่างพอประมาณ" | mkAdv "บ้าง" | mkAdv "บางตอน" | mkAdv "บางขนาด" | mkAdv "ค่อนข้าง" ; -- src=panlex
lin inside_Adv = mkAdv "ข้างใน" | mkAdv "อยู่ภายใน" | mkAdv "ภายใน" | mkAdv "ในร่ม" | mkAdv "ข้างใน" | mkAdv "ด้านใน" | mkAdv "ภายในร่ม" | mkAdv "ภายในบ้าน" | mkAdv "เครื่องใน" | mkAdv "ภายในอาคาร" | mkAdv "ลักษณะภายใน" ; -- src=panlex
lin trend_N = mkN "แนว" | mkN "แนวโน้ม" | mkN "ึความนิยม" | mkN "ครรลอง" | mkN "ทิศทาง" | mkN "แนวทาง" | mkN "แนวโน้ม" | mkN "สมัยนิยม" | mkN "โน้มน้าว" | mkN "โน้มเอียง" | mkN "แนวความคิด" | mkN "แนวโน้มเอียง" | mkN "มีแนวโน้มเอียง" | mkN "สิ่งที่กําลังเป็นที่นิยม" ; -- src=panlex
lin revolution_N = mkN "การปฏิวัติ" | mkN "วัฏจักร" | mkN "การปฏิวัติ" | mkN "การหมุนหนึ่งรอบ" | mkN "การเปลี่ยนแปลงอย่างสิ้นเชิง" ; -- src=panlex
lin terrible_A = mkA "มหันต์" | mkA "น่ากลัว" | mkA "ร้ายแรง" | mkA "สยองขวัญ" | mkA "ซึ่งแย่มาก" | mkA "น่าเกรงขาม" | mkA "ซึ่งไม่ยอมรับ" | mkA "ซึ่งไม่เห็นด้วย" ; -- src=panlex
lin knee_N = mkN (thword "เข่า") | {-pan-} mkN "เข่า" | mkN "ข้อเข่า" | mkN "พระชานุ" | mkN "หัวเข่า" | mkN "หัวเข่ากางเกง" | mkN "ตัก" | mkN "เข่า" | mkN "หัวเข่า" | mkN "แตะด้วยเข่า" ; -- src=panlex
lin dress_N = mkN "ชุด" | mkN "อาภรณ์" | mkN "ผ้านุ่ง" | mkN "ผ้าผ่อน" | mkN "เสื้อผ้า" | mkN "ชุดกระโปรง" | mkN "เครื่องแต่งกาย" | mkN "ชุดเสื้อกระโปรงติดกัน" | mkN "ชุด" | mkN "ชุดติดกัน" | mkN "เครื่องแต่งกาย" | mkN "เครื่องแต่งตัว" | mkN "เสื้อชุดของผู้หญิง" ; -- src=panlex
lin unfortunately_Adv = mkAdv "อย่างโชคร้าย" | mkAdv "โดยสมควรถูกตำหนิ" | mkAdv "โชคไม่ดี" | mkAdv "น่าเสียดาย" ; -- src=panlex
lin steal_V2 = mkV2 "ลัก" ; ---- | mkV "ขโมย" | mkV "ขโมยเบส" | mkV "ลักขโมย" | mkV "ลัก" | mkV "ขโมย" ; -- src=panlex
lin steal_V = mkV "ลัก" | mkV "ขโมย" | mkV "ขโมยเบส" | mkV "ลักขโมย" | mkV "ลัก" | mkV "ขโมย" ; -- src=panlex
lin criminal_A = mkA "ซึ่งทําผิด" | mkA "ที่น่าเสียใจ" | mkA "เกี่ยวกับอาญา" | mkA "ไร้ความสํานึก" | mkA "มีความผิดทางอาญา" | mkA "เกี่ยวกับอาชญากรรม" ; -- src=panlex
lin signal_N = mkN "ซิก" | mkN "สัญญาณ" | mkN "ลาง" | mkN "นิมิต" | mkN "อาการ" | mkN "สัญญาณ" | mkN "สิ่งบอกใบ้" | mkN "อากัปกิริยา" | mkN "เครื่องหมาย" ; -- src=panlex
lin notion_N = mkN "ความเชื่อ" | mkN "ความคิดแปลกประหลาด" | mkN "แนวคิด" | mkN "ความคิด" | mkN "ความเชื่อ" | mkN "ความนึกคิด" | mkN "ความเข้าใจ" | mkN "ความคิดเห็นโง่ๆ" | mkN "ความนึกคิดที่คลุมเครือ" ; -- src=panlex
lin comparison_N = mkN "การเปรียบเทียบ" | mkN "การเปรียบเทียบได้" | mkN "การเปรียบเทียบ" | mkN "การเปรียบเทียบ ภาวะที่ถูกเปรียบเทียบ" ; -- src=panlex
lin academic_A = mkA "ทางวิชาการ" | mkA "ในทางทฤษฎี" | mkA "ด้านวิชาการ" | mkA "ซึ่งคงแก่เรียน" | mkA "ซึ่งไม่เหมาะในทางปฏิบัติ" | mkA "ซึ่งมีลักษณะเป็นนักวิชาการ" ; -- src=panlex
lin outcome_N = mkN "ผล" | mkN "ผลที่ตามมา" | mkN "ผล" | mkN "ทางออก" | mkN "ผลลัพธ์" | mkN "สิ่งที่ปรากฏออกมาภายหลัง" ; -- src=panlex
lin lawyer_N = mkN "ทนาย" | mkN "นิติกร" | mkN "หมอความ" | mkN "ทนายความ" | mkN "นักกฎหมาย" | mkN "หมอกฎหมาย" | mkN "ทนาย" | mkN "นิติกร" | mkN "ทนายความ" | mkN "นักกฎหมาย" ; -- src=panlex
lin strongly_Adv = variants{} ; -- 
lin surround_V2 = variants{} ; -- 
lin explore_VS = variants{} ; -- 
lin explore_V2 = variants{} ; -- 
lin achievement_N = mkN "ความสำเร็จ" | mkN "ผลสําเร็จ" | mkN "การบรรลุผล" | mkN "ผลสัมฤทธิ์" | mkN "ความสําเร็จ" | mkN "สัมฤทธิ์ภาพ" | mkN "ความสัมฤทธิ์" | mkN "การสําเร็จลุล่วง" | mkN "การบรรลุผลสําเร็จ" ; -- src=panlex
lin odd_A = mkA "คี่" | mkA "แปลก" | mkA "แปลก" | mkA "คร่าวๆ" | mkA "ผิดปกติ" | mkA "ไม่มีคู่" | mkA "โดยประมาณ" | mkA "ไม่ครบคู่" | mkA "ที่ห่างไกล" | mkA "อย่างคร่าวๆ" | mkA "แปลกประหลาด" | mkA "ซึ่งเป็นเลขคี่" | mkA "ที่เหลือเป็นเศษ" | mkA "ซึ่งเป็นจํานวนคี่" | mkA "ที่หายไปข้างหนึ่ง" | mkA "เกิดขึ้นบางครั้งบางคราว" ; -- src=panlex
lin expectation_N = mkN "การคาดการณ์" | mkN "มัชฌิมเลขคณิต" | mkN "ความหวัง" | mkN "การคาดคิด" | mkN "การคาดหมาย" | mkN "การคาดหวัง" | mkN "การคาดการณ์" | mkN "ความคาดหวัง" | mkN "ความควาดหวัง" | mkN "ความมุ่งหวัง" | mkN "สิ่งที่คาดหวัง" | mkN "สิ่งที่คาดหมายไว้" | mkN "มาตรฐานที่คาดหวังไว้" | mkN "สิ่งที่คาดหวังว่าจะเกิดขึ้นในอนาคต" ; -- src=panlex
lin corporate_A = mkA "ซึ่งเป็นตัวเป็นตน" | mkA "ทั้งคณะ" | mkA "ทั้งหมู่" | mkA "ที่ร่วมกัน" | mkA "ที่แชร์ร่วมกัน" | mkA "ซึ่งรวมกันเป็นหมู่" | mkA "ที่เกี่ยวกับบริษัท" ; -- src=panlex
lin prisoner_N = mkN "นักโทษ" | mkN "ผู้ถูกคุมขัง" | mkN "เชลย" | mkN "คนคุก" | mkN "นักโทษ" | mkN "เชลยศึก" | mkN "ผู้ต้องหา" | mkN "ผู้ต้องขัง" | mkN "ผู้ที่สูญเสียอิสรภาพ" ; -- src=panlex
lin question_V2 = variants{} ; -- 
lin rapidly_Adv = variants{} ; -- 
lin deep_Adv = mkAdv "ลึกๆ" | mkAdv "มาก" | mkAdv "ลึก" | mkAdv "ดึกมาก" | mkAdv "ลึกมาก" | mkAdv "ลึกซึ้ง" | mkAdv "ลึกล้ํา" | mkAdv "ห่างไกล" | mkAdv "เต็มที่" | mkAdv "มีใจจดจ่อ" | mkAdv "อย่างยิ่ง" | mkAdv "เหลือเกิน" | mkAdv "อย่างห่างไกล" | mkAdv "อยู่ตามเส้นขอบ" ; -- src=panlex
lin southern_A = mkA "ทางใต้" | mkA "ที่มาจากทางใต้" | mkA "ชาวปักษ์ใต้" | mkA "ในทางภาคใต้" | mkA "ภาษาปักษ์ใต้" | mkA "ที่ตั้งอยู่ทางใต้" | mkA "ซึ่งหันหน้าไปทางใต้" ; -- src=panlex
lin amongst_Prep = mkPrep "ในพวก" | mkPrep "ในหมู่" | mkPrep "ท่ามกลาง" | mkPrep "ในจํานวน" | mkPrep "ในระหว่าง" ; -- src=panlex
lin withdraw_V2 = mkV2 "ถอน" ; ---- | mkV "เบิก" | mkV "เลิก" | mkV "ถอนตัว" | mkV "ล่าถอย" | mkV "เอาออก" | mkV "ขอลาออก" | mkV "ดึงกลับ" | mkV "ปลีกตัว" | mkV "เก็บตัว" | mkV "ถอนคำพูด" | mkV "เรียกคืน" | mkV "เป็นอิสระ" | mkV "ยื่นใบลาออก" | mkV "พักการประชุม" | mkV "ยื่นจดหมายลาออก" | mkV "ยื่นหนังสือลาออก" | mkV "ถอนคืน" | mkV "ถอนทหาร" | mkV "ถอนเงิน" | mkV "เก็บคืน" | mkV "เอากลับ" | mkV "เบิกเงิน" | mkV "ถอนคําพูด" | mkV "ถอนตําแหน่ง" ; -- src=panlex
lin withdraw_V = mkV "ถอน" | mkV "เบิก" | mkV "เลิก" | mkV "ถอนตัว" | mkV "ล่าถอย" | mkV "เอาออก" | mkV "ขอลาออก" | mkV "ดึงกลับ" | mkV "ปลีกตัว" | mkV "เก็บตัว" | mkV "ถอนคำพูด" | mkV "เรียกคืน" | mkV "เป็นอิสระ" | mkV "ยื่นใบลาออก" | mkV "พักการประชุม" | mkV "ยื่นจดหมายลาออก" | mkV "ยื่นหนังสือลาออก" | mkV "ถอนคืน" | mkV "ถอนทหาร" | mkV "ถอนเงิน" | mkV "เก็บคืน" | mkV "เอากลับ" | mkV "เบิกเงิน" | mkV "ถอนคําพูด" | mkV "ถอนตําแหน่ง" ; -- src=panlex
lin afterwards_Adv = mkAdv "ตอนหลัง" | mkAdv "ในภายหลัง" | mkAdv "ต่อมา" | mkAdv "ต่อไป" | mkAdv "ทีหลัง" | mkAdv "จากนั้น" | mkAdv "ตอนหลัง" | mkAdv "ภายหลัง" | mkAdv "คราวหน้า" | mkAdv "คราวหลัง" | mkAdv "ครั้งต่อไป" | mkAdv "ต่อจากนั้น" | mkAdv "หลังจากนั้น" ; -- src=panlex
lin paint_V2 = mkV2 "ทาสี" ; ---- | mkV "ลงสี" | mkV "เพนต์" | mkV "วาดรูป" | mkV "เคลือบ" | mkV "ทาสี" | mkV "ลงสี" | mkV "ป้ายสี" | mkV "วาดรูป" ; -- src=panlex
lin paint_V = mkV "ทาสี" | mkV "ลงสี" | mkV "เพนต์" | mkV "วาดรูป" | mkV "เคลือบ" | mkV "ทาสี" | mkV "ลงสี" | mkV "ป้ายสี" | mkV "วาดรูป" ; -- src=panlex
lin judge_VS = mmkVS "กะ" ; ---- | mkV "ตัดสิน" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "พิพากษา" | mkV "กะประมาณ" | mkV "ตัดสินการแข่งขัน" | mkV "กะ" | mkV "ตัดสิน" | mkV "ประมาณ" | mkV "คาดคะเน" | mkV "พิจารณา" | mkV "ตัดสินความ" | mkV "พิจารณาคดี" | mkV "ลงความเห็น" ; -- src=panlex
lin judge_V2 = mkV2 "กะ" ; ---- | mkV "ตัดสิน" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "พิพากษา" | mkV "กะประมาณ" | mkV "ตัดสินการแข่งขัน" | mkV "กะ" | mkV "ตัดสิน" | mkV "ประมาณ" | mkV "คาดคะเน" | mkV "พิจารณา" | mkV "ตัดสินความ" | mkV "พิจารณาคดี" | mkV "ลงความเห็น" ; -- src=panlex
lin judge_V = mkV "กะ" | mkV "ตัดสิน" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "พิพากษา" | mkV "กะประมาณ" | mkV "ตัดสินการแข่งขัน" | mkV "กะ" | mkV "ตัดสิน" | mkV "ประมาณ" | mkV "คาดคะเน" | mkV "พิจารณา" | mkV "ตัดสินความ" | mkV "พิจารณาคดี" | mkV "ลงความเห็น" ; -- src=panlex
lin citizenMasc_N = variants{} ; -- 
lin permanent_A = mkA "ถาวร" | mkA "คงทน" | mkA "ถาวร" | mkA "ยืนยง" | mkA "ยาวนาน" | mkA "ยั่งยืน" ; -- src=panlex
lin weak_A = mkA "อ่อน" | mkA "อ่อนแอ" | mkA "จาง" | mkA "บาง" | mkA "แผ่ว" | mkA "เปราะ" | mkA "อ่อนลง" | mkA "อ่อนแอ" | mkA "ใจอ่อน" | mkA "ขาดแคลน" | mkA "อ่อนข้อ" | mkA "เจือจาง" | mkA "แพ้ง่าย" | mkA "ขาดทักษะ" | mkA "ปวกเปียก" | mkA "เปราะบาง" | mkA "เสียงอ่อน" | mkA "เหลาะแหละ" | mkA "อ่อนกําลัง" | mkA "ไม่กล้าหาญ" | mkA "ไม่หนักแน่น" | mkA "ขาดความสามารถ" | mkA "เอาชนะได้ง่าย" | mkA "ซึ่งไม่อาจโน้มน้าวได้" | mkA "ซึ่งทํางานได้ไม่เต็มที่" ; -- src=panlex
lin separate_V2 = mkV2 "จัด" ; ---- | mkV "แยก" | mkV "คั่น" | mkV "หั่น" | mkV "แบ่ง" | mkV "จำแนก" | mkV "กีดกัน" | mkV "แยกทาง" | mkV "แบ่งแยก" | mkV "ทำให้แตกออก" | mkV "ทำให้แยกออก" | mkV "แตกเป็นสาขา" | mkV "ทำให้แยกออกมา" | mkV "แยกองค์ประกอบ" | mkV "แยก" | mkV "จับแยก" | mkV "ถอนตัว" | mkV "แตกกัน" | mkV "แยกกัน" | mkV "แยกทาง" | mkV "แยกแยะ" | mkV "แบ่งแยก" | mkV "วินิจฉัย" | mkV "บอกความแตกต่าง" ; -- src=panlex
lin separate_V = mkV "จัด" | mkV "แยก" | mkV "คั่น" | mkV "หั่น" | mkV "แบ่ง" | mkV "จำแนก" | mkV "กีดกัน" | mkV "แยกทาง" | mkV "แบ่งแยก" | mkV "ทำให้แตกออก" | mkV "ทำให้แยกออก" | mkV "แตกเป็นสาขา" | mkV "ทำให้แยกออกมา" | mkV "แยกองค์ประกอบ" | mkV "แยก" | mkV "จับแยก" | mkV "ถอนตัว" | mkV "แตกกัน" | mkV "แยกกัน" | mkV "แยกทาง" | mkV "แยกแยะ" | mkV "แบ่งแยก" | mkV "วินิจฉัย" | mkV "บอกความแตกต่าง" ; -- src=panlex
lin plastic_N = mkN (thword "พลาส" "ติค") | {-pan-} mkN "พลาสติก" | mkN "บัตรเครดิส" | mkN "เครดิตการ์ด" | mkN "บัตรสินเชื่อ" | mkN "พลาสติก" | mkN "บัตรเครดิต" | mkN "วัตถุพลาสติก" ; -- src=panlex ----?
lin connect_V2 = mkV2 "ผูก" ; ---- | mkV "ติดต่อ" | mkV "ต่อสาย" | mkV "สัมผัส" | mkV "หล่นใส่" | mkV "ตีลูกได้" | mkV "คอนเน็กต์" | mkV "เชื่อมกัน" | mkV "เชื่อมโยง" | mkV "เสียบปลั๊ก" | mkV "มีสายสัมพันธ์" | mkV "เชื่อมต่อ" | mkV "บรรลุเป้าหมาย" | mkV "ติดต่อทางโทรศัพท์" ; -- src=panlex
lin connect_V = mkV "ผูก" | mkV "ติดต่อ" | mkV "ต่อสาย" | mkV "สัมผัส" | mkV "หล่นใส่" | mkV "ตีลูกได้" | mkV "คอนเน็กต์" | mkV "เชื่อมกัน" | mkV "เชื่อมโยง" | mkV "เสียบปลั๊ก" | mkV "มีสายสัมพันธ์" | mkV "เชื่อมต่อ" | mkV "บรรลุเป้าหมาย" | mkV "ติดต่อทางโทรศัพท์" ; -- src=panlex
lin fundamental_A = mkA "หลัก" | mkA "ใหญ่" | mkA "มูลฐาน" | mkA "แท้จริง" | mkA "เป็นรากฐาน" | mkA "เป็นแหล่งแรกเริ่ม" | mkA "ซึ่งเป็นส่วนสําคัญ" | mkA "ซึ่งเกี่ยวกับรากฐาน" | mkA "ซึ่งเกี่ยวกับพื้นฐาน" ; -- src=panlex
lin plane_N = mkN "กบ" | mkN "ตาราง" | mkN "ระนาบ" | mkN "กบไฟฟ้า" | mkN "กบไสไม้" | mkN "เครื่อง" | mkN "เครื่องบิน" | mkN "กบไสไม้ไฟฟ้า" | mkN "กบ" | mkN "ขั้น" | mkN "ชั้น" | mkN "ระดับ" | mkN "ที่ราบ" | mkN "แนวราบ" | mkN "กบไสไม้" | mkN "พื้นราบ" | mkN "หน้าราบ" | mkN "เรือบิน" | mkN "ไม้ปาดปูน" | mkN "เครื่องบิน" | mkN "ทําให้เรียบ" | mkN "ปีกเครื่องบิน" | mkN "ผิวหน้าที่ราบ" | mkN "สถานะทางสังคม" | mkN "เครื่องไสโลหะ" | mkN "แพนหางเครื่องบิน" ; -- src=panlex
lin height_N = mkN "ความสูง" | mkN "ส่วนสูง" | mkN "จุดสูงสุด" | mkN "ระดับสูงสุด" | mkN "ภูเขา" | mkN "ความสูง" | mkN "เนินเขา" | mkN "จุดสุดยอด" | mkN "จุดที่สูงสุด" | mkN "ระดับความสูง" | mkN "ระดับที่สูงที่สุด" ; -- src=panlex
lin opening_N = mkN "รู" | mkN "ช่อง" | mkN "โอกาส" | mkN "ก้าวแรก" | mkN "ขั้นแรก" | mkN "ช่องว่าง" | mkN "ช่องโหว่" | mkN "พิธีเปิด" | mkN "ความเป็นไปได้" | mkN "การแสดงครั้งแรก" | mkN "ทางขี้นดาดฟ้าเรือ" | mkN "ช่อง" | mkN "โอกาส" | mkN "ตอนแรก" | mkN "รูเปิด" | mkN "การเปิด" | mkN "ที่โล่ง" | mkN "รอยโหว่" | mkN "ส่วนแรก" | mkN "กลางแจ้ง" | mkN "การเริ่ม" | mkN "การเปิดเกม" | mkN "การเปิดเผย" | mkN "ตอนเริ่มต้น" | mkN "ตําแหน่งงานที่ว่าง" | mkN "การฉลองการเปิดปฐมฤกษ์" ; -- src=panlex
lin lesson_N = mkN "บทเรียน" | mkN "การลงโทษเป็นเยี่ยงอย่าง" | mkN "บทเรียน" | mkN "ตักเตือน" | mkN "ตัวอย่าง" | mkN "แบบอย่าง" | mkN "ชั้นเรียน" | mkN "เยี่ยงอย่าง" | mkN "ชั่วโมงเรียน" | mkN "ตัวอย่างสอนใจ" | mkN "ให้บทเรียนแก่" | mkN "บทเรียนในชีวิต" | mkN "ส่วนหรือบทในคัมภีร์" | mkN "ตอนหนึ่งในพระคัมภีร์" | mkN "สิ่งที่เรียนรู้จากประสบการณ์" | mkN "การว่ากล่าวเพื่อสั่งสอนให้ดีขึ้น" ; -- src=panlex
lin similarly_Adv = variants{} ; -- 
lin shock_N = mkN "ช็อค" | mkN "การตกใจ" | mkN "โช้คอัพ" | mkN "ภาวะช็อค" | mkN "ไฟฟ้าช็อต" | mkN "ความตกตะลึง" | mkN "การกระแทกในทันที" | mkN "สดุ้งตกใจ" | mkN "สภาวะช็อก" | mkN "เขย่าขวัญ" | mkN "อาการเป็นลม" | mkN "อาการสะเทือน" | mkN "กระทบอย่างแรง" | mkN "ทําให้สะเทือน" | mkN "ความสะดุ้งตกใจ" | mkN "อาการตื่นตะลึง" | mkN "อาการสะเทือนใจ" | mkN "อาการตกใจสุดขีด" | mkN "อาการสั่นกระตุก" | mkN "ทําให้สะดุ้งตกใจ" | mkN "ขนหรือผมที่รุงรัง" | mkN "ผมหรือขนที่ยุ่งเหยิง" | mkN "ต้นข้าวที่มัดเป็นกองๆ" | mkN "การกระทบกระแทกอย่างกะทันหัน" | mkN "อาการสะเทือนทางใจอย่างกะทันหัน" ; -- src=panlex
lin rail_N = mkN "ราง" | mkN "ราว" | mkN "นกกวัก" | mkN "ไม้แนวขวาง" | mkN "ราง" | mkN "ราว" | mkN "รั้ว" | mkN "ใส่ราว" | mkN "รางรถไฟ" ; -- src=panlex
lin tenant_N = mkN "คนเช่า" | mkN "ผู้เช่า" | mkN "ผู้อาศัย" | mkN "ผู้จ่ายค่าเช่า" | mkN "ผู้ถือกรรมสิทธิ์" | mkN "ผู้เช่า" | mkN "อาศัยอยู่" | mkN "ผู้เช่าที่" | mkN "ผู้อยู่อาศัย" | mkN "ผู้เช่าที่นา" ; -- src=panlex
lin owe_V2 = mkV2 "ติดค้าง" ; ---- | mkV "ติดหนี้" | mkV "ค้างชำระ" | mkV "เป็นหนี้" | mkV "เป็นหนี้บุญคุณ" | mkV "ติด" | mkV "หนี้" | mkV "ติดเงิน" | mkV "เป็นหนี้" | mkV "เป็นหนี้บุญคุณ" ; -- src=panlex
lin owe_V = mkV "ติดค้าง" | mkV "ติดหนี้" | mkV "ค้างชำระ" | mkV "เป็นหนี้" | mkV "เป็นหนี้บุญคุณ" | mkV "ติด" | mkV "หนี้" | mkV "ติดเงิน" | mkV "เป็นหนี้" | mkV "เป็นหนี้บุญคุณ" ; -- src=panlex
lin originally_Adv = variants{} ; -- 
lin middle_A = mkA "ที่อยู่ระหว่างกลาง" | mkA "กลาง" | mkA "กลางๆ" | mkA "ตรงกลาง" | mkA "ตอนกลาง" | mkA "ปานกลาง" | mkA "กึ่งกลาง" | mkA "พอประมาณ" | mkA "เป็นกลาง" ; -- src=panlex
lin somehow_Adv = mkAdv "อย่างไรก็ตาม" | mkAdv "ด้วยวิธีใดก็ตาม" | mkAdv "ด้วยเหตุผลบางประการ" | mkAdv "ด้วยเหตุใดเหตุหนึ่ง" ; -- src=panlex
lin minor_A = mkA "เล็กๆ" | mkA "ที่มีขนาดเล็ก" | mkA "น้อย" | mkA "เป็นรอง" | mkA "เล็กน้อย" | mkA "ไม่สําคัญ" | mkA "รุนแรงน้อย" | mkA "อันตรายน้อย" | mkA "ชนชาวหมู่น้อย" | mkA "ซึ่งเป็นวิชารอง" | mkA "ผู้มีการศึกษาน้อย" | mkA "เกี่ยวกับผู้เยาว์" | mkA "ซึ่งยังไม่เป็นผู้ใหญ่" | mkA "ซึ่งยังไม่บรรลุนิติภาวะ" ; -- src=panlex
lin negative_A = mkA "ลบ" | mkA "เชิงลบ" | mkA "ตั้งแง่" | mkA "ในทางลบ" | mkA "ที่เป็นลบ" | mkA "ซึ่งไม่เห็นด้วย" | mkA "เชิงลบ" | mkA "ที่เป็นด้านลบ" | mkA "เป็นการปฏิเสธ" | mkA "เป็นการคัดค้าน" ; -- src=panlex
lin knock_V2 = mkV2 "อัด" ; ---- | mkV "เคาะ" | mkV "กระตุก" | mkV "วิจารณ์" | mkV "วิพากษ์" | mkV "ชนอย่างแรง" | mkV "วิพากษ์วิจารณ์" | mkV "ชน" | mkV "เขก" | mkV "โขก" | mkV "เคาะ" | mkV "กระตุก" | mkV "กระแทก" | mkV "กระทุ้ง" ; -- src=panlex
lin knock_V = mkV "อัด" | mkV "เคาะ" | mkV "กระตุก" | mkV "วิจารณ์" | mkV "วิพากษ์" | mkV "ชนอย่างแรง" | mkV "วิพากษ์วิจารณ์" | mkV "ชน" | mkV "เขก" | mkV "โขก" | mkV "เคาะ" | mkV "กระตุก" | mkV "กระแทก" | mkV "กระทุ้ง" ; -- src=panlex
lin root_N = mkN (thword "ราก") | {-pan-} mkN "ราก" | mkN "ธาตุ" | mkN "รากคำ" | mkN "บรรพชน" | mkN "รากฟัน" | mkN "รากศัพท์" | mkN "ต้นกำเนิด" | mkN "ปู่ยาตายาย" | mkN "แหล่งกำเนิด" | mkN "เทือกเถาเหล่ากอ" | mkN "ฐาน" | mkN "ราก" | mkN "หน่อ" | mkN "กรณฑ์" | mkN "รากผม" | mkN "เหง้า" | mkN "รากฐาน" | mkN "รากพืช" | mkN "รากฟัน" | mkN "ลูกหลาน" | mkN "แก่นแท้" | mkN "รากศัพท์" | mkN "รากเหง้า" | mkN "บรรพบุรุษ" | mkN "รากใต้ดิน" | mkN "หัวใต้ดิน" | mkN "เค้าศัพท์" | mkN "ต้นกําเนิด" | mkN "แหล่งที่มา" | mkN "รากของต้นตอ" | mkN "รากในคณิตศาสตร์" ; -- src=panlex ----?
lin pursue_V2 = mkV2 "ไล่ตาม" ; ---- | mkV "เข้าร่วม" | mkV "ดำเนินการ" | mkV "ร่วมกิจกรรม" | mkV "ไล่" | mkV "ไล่ตาม" | mkV "ทําให้ลุล่วง" ; -- src=panlex
lin pursue_V = mkV "ไล่ตาม" | mkV "เข้าร่วม" | mkV "ดำเนินการ" | mkV "ร่วมกิจกรรม" | mkV "ไล่" | mkV "ไล่ตาม" | mkV "ทําให้ลุล่วง" ; -- src=panlex
lin inner_A = mkA "ภายใน" | mkA "ข้างใน" | mkA "ชั้นใน" | mkA "ด้านใน" | mkA "ส่วนตัว" | mkA "ซ่อนเร้น" | mkA "ลับเฉพาะ" | mkA "คลุมเครือ" | mkA "ไม่ชัดเจน" ; -- src=panlex
lin crucial_A = mkA "สำคัญ" | mkA "ซึ่งสำคัญที่สุด" | mkA "รุนแรง" | mkA "เด็ดขาด" | mkA "โหดร้าย" | mkA "สําคัญมาก" | mkA "ซึ่งชี้ขาด" | mkA "ถึงพริกถึงขิง" | mkA "เกี่ยวกับความเป็นความตาย" | mkA "เป็นรูปกากบาทหรือรูปกางเขน" ; -- src=panlex
lin occupy_V2 = mkV2 "พัก" ; ---- | mkV "ใช้" | mkV "ง่วน" | mkV "ยุ่ง" | mkV "กังวล" | mkV "พำนัก" | mkV "ครอบงำ" | mkV "หมกหมุ่น" | mkV "ได้บรรจุ" | mkV "มีงานเยอะ" | mkV "ทำให้จดจ่อ" | mkV "เข้าบุกยึด" | mkV "รุกล้ำอาณาเขต" | mkV "รุกราน" | mkV "สาละวน" | mkV "ยึดครอง" | mkV "ครอบครอง" | mkV "ยุ่งอยู่" | mkV "วุ่นอยู่กับ" | mkV "อาศัยอยู่ใน" | mkV "ครองตําแหน่ง" | mkV "ดํารงตําแหน่ง" ; -- src=panlex
lin occupy_V = mkV "พัก" | mkV "ใช้" | mkV "ง่วน" | mkV "ยุ่ง" | mkV "กังวล" | mkV "พำนัก" | mkV "ครอบงำ" | mkV "หมกหมุ่น" | mkV "ได้บรรจุ" | mkV "มีงานเยอะ" | mkV "ทำให้จดจ่อ" | mkV "เข้าบุกยึด" | mkV "รุกล้ำอาณาเขต" | mkV "รุกราน" | mkV "สาละวน" | mkV "ยึดครอง" | mkV "ครอบครอง" | mkV "ยุ่งอยู่" | mkV "วุ่นอยู่กับ" | mkV "อาศัยอยู่ใน" | mkV "ครองตําแหน่ง" | mkV "ดํารงตําแหน่ง" ; -- src=panlex
lin that_AdA = variants{} ; -- 
lin independence_N = mkN "เอกราช" | mkN "การได้รับอิสรภาพ" | mkN "เอกราช" | mkN "อิสรภาพ" | mkN "ความเป็นอิสระ" ; -- src=panlex
lin column_N = mkN "เสา" | mkN "เสาค้ำ" | mkN "คอลัมน์" | mkN "แนวขบวนทหาร" | mkN "รูปทรงยาวบาง" | mkN "รูปร่างเหมือนเสา" | mkN "คอลัมน์หนังสือพิมพ์" | mkN "โครมาโทกราฟีแบบคอลัมน์" | mkN "เสา" | mkN "เสาค้ํา" | mkN "กองย่อยๆ" | mkN "แนวขบวนทหาร" | mkN "คอลัมน์ในหนังสือพิมพ์" | mkN "กองทหารที่ตั้งแถวตามยาว" | mkN "ขบวนเรือรบที่เป็นแนวตามยาว" | mkN "แถวหรือรายการที่เป็นแนวตรง" ; -- src=panlex
lin proceeding_N = mkN "กระบวนพิจารณา" | mkN "" | mkN "ขบวนการ" | mkN "ขั้นตอน" | mkN "วิธีการ" | mkN "การดําเนินการ" ; -- src=panlex
lin female_N = mkN "ตัวเมีย" | mkN "สตรีเพศ" | mkN "เพศหญิง" | mkN "เพศเมีย" | mkN "คนเพศหญิง" | mkN "สัตว์ตัวเมีย" | mkN "สัตว์เพศเมีย" | mkN "สตรี" | mkN "ผู้หญิง" | mkN "เพศหญิง" | mkN "เพศเมีย" | mkN "คนผู้หญิง" ; -- src=panlex
lin beauty_N = mkN "คนสวย" | mkN "สาวงาม" | mkN "ความงาม" | mkN "ความสวย" | mkN "ความงดงาม" | mkN "ความสวยงาม" | mkN "ความมีเสน่ห์" | mkN "สิ่งที่เด่นกว่า" | mkN "คนงาม" | mkN "คนสวย" | mkN "ข้อขํา" | mkN "คนเด่น" | mkN "หญิงงาม" | mkN "ความสวยงาม" | mkN "ข้อได้เปรียบ" | mkN "สิ่งที่ดีงาม" | mkN "สิ่งที่ดีเด่น" | mkN "สิ่งที่สวยงาม" | mkN "การตกแต่งให้สวยงาม" | mkN "คุณสมบัติที่ดีที่สุด" | mkN "สิ่งที่ดีเด่นกว่าสิ่งอื่น" ; -- src=panlex
lin perfectly_Adv = variants{} ; -- 
lin struggle_N = mkN "ความขัดแย้ง" | mkN "ความมุ่งมั่นฟันฝ่า" | mkN "การดิ้นรน" | mkN "การต่อสู้" | mkN "การฝ่าฟัน" | mkN "การแข่งขัน" | mkN "ความพยายาม" ; -- src=panlex
lin gap_N = mkN "การหยุด" | mkN "ช่องเขา" | mkN "ช่องว่าง" | mkN "ความแตกต่าง" | mkN "การขัดจังหวะ" | mkN "รอยแตก" | mkN "รอยแยก" | mkN "ปากโหว่" | mkN "รอยห่าง" | mkN "ช่องว่าง" | mkN "ช่องห่าง" | mkN "ช่องโหว่" | mkN "หุบเขาลึก" | mkN "ความแตกต่าง" | mkN "ความไม่เข้าใจกัน" | mkN "ความไม่เหมือนกัน" | mkN "ปัญหาที่เกิดจากความแตกต่างกัน" ; -- src=panlex
lin house_V2 = variants{} ; -- 
lin database_N = mkN "ดาต้าเบส" | mkN "ฐานข้อมูล" | mkN "คลังข้อมูล" | mkN "ข้อมูลคอมพิวเตอร์ที่เก็บรวบรวมอย่างเป็นระบบ" ; -- src=panlex
lin stretch_V2 = mkV2 "กาง" ; ---- | mkV "ยืด" | mkV "ปลอมปน" | mkV "ยืดออก" | mkV "เหยียด" | mkV "เหยียดออก" | mkV "ขยายขอบเขต" | mkV "กินเนื้อที่" | mkV "เพิ่มปริมาณ" | mkV "นอนเหยียดกาย" | mkV "นอนเหยียดยาว" | mkV "ดึงในทิศตรงข้าม" | mkV "ยืด" | mkV "ยืดออก" | mkV "ขยายออก" | mkV "ขึงให้ตึง" | mkV "ทําให้ตึง" | mkV "เหยียดตัว" | mkV "เหยียดแขนขา" ; -- src=panlex
lin stretch_V = mkV "กาง" | mkV "ยืด" | mkV "ปลอมปน" | mkV "ยืดออก" | mkV "เหยียด" | mkV "เหยียดออก" | mkV "ขยายขอบเขต" | mkV "กินเนื้อที่" | mkV "เพิ่มปริมาณ" | mkV "นอนเหยียดกาย" | mkV "นอนเหยียดยาว" | mkV "ดึงในทิศตรงข้าม" | mkV "ยืด" | mkV "ยืดออก" | mkV "ขยายออก" | mkV "ขึงให้ตึง" | mkV "ทําให้ตึง" | mkV "เหยียดตัว" | mkV "เหยียดแขนขา" ; -- src=panlex
lin stress_N = mkN "การเน้น" | mkN "แรงเค้น" | mkN "ความตึงเครียด" | mkN "การกด" | mkN "การดัน" | mkN "เน้นหนัก" | mkN "แรงกดดัน" | mkN "เสียงหนัก" | mkN "เสียงเน้น" | mkN "การบีบคั้น" | mkN "ความบังคับ" | mkN "ความเครียด" | mkN "ตัวกระตุ้น" | mkN "แรงกระตุ้น" | mkN "แรงผลักดัน" | mkN "การเน้นเสียง" | mkN "ความฉุกละหุก" | mkN "ออกเสียงหนัก" | mkN "ความตึงเครียด" | mkN "การเน้นเป็นพิเศษ" | mkN "การให้ความสําคัญเป็นพิเศษ" ; -- src=panlex
lin passenger_N = mkN "ผู้โดยสาร" | mkN "คนโดยสาร" | mkN "คนเดินทาง" | mkN "ผู้โดยสาร" | mkN "ผู้เดินทาง" ; -- src=panlex
lin boundary_N = mkN "ขอบ" | mkN "ขอบเขต" | mkN "ขีดจำกัด" | mkN "เส้นบอกเขต" | mkN "แนวแบ่งเขต" | mkN "เส้นแบ่งเขต" | mkN "เขต" | mkN "แดน" | mkN "ขัณฑ์" | mkN "ขอบเขต" | mkN "เขตแดน" | mkN "อาณาเขต" | mkN "เส้นแบ่งเขต" ; -- src=panlex
lin easy_Adv = mkAdv "อย่างช้าๆ" | mkAdv "ง่าย" | mkAdv "ไม่รัด" | mkAdv "ง่ายดาย" | mkAdv "ผ่อนผัน" | mkAdv "ไม่แน่น" | mkAdv "สะดวกสบาย" | mkAdv "ไม่ลําบาก" | mkAdv "ไม่เข้มงวด" | mkAdv "ไม่เป็นภาระ" | mkAdv "สบายอกสบายใจ" ; -- src=panlex
lin view_V2 = variants{} ; -- 
lin manufacturer_N = mkN "คนทำ" | mkN "คนผลิต" | mkN "ผู้ผลิต" | mkN "ผู้ทํา" | mkN "ผู้ผลิต" | mkN "ผู้สร้าง" ; -- src=panlex
lin sharp_A = mkA (thword "คม") | {-pan-} mkA "ชาร์ป" | mkA "ที่มีปลายแหลม" | mkA "ที่มีปลายเหมือนเข็ม" | mkA "คม" | mkA "ฉุน" | mkA "ชัด" | mkA "โกง" | mkA "ฉลาด" | mkA "แจ๋ว" | mkA "รสฉุน" | mkA "คมกริบ" | mkA "ชัดเจน" | mkA "รสเผ็ด" | mkA "รุนแรง" | mkA "ว่องไว" | mkA "แหลมคม" | mkA "ฉับพลัน" | mkA "ทันสมัย" | mkA "เข้มงวด" | mkA "กะทันหัน" | mkA "ฉุนเฉียว" | mkA "เฉียบขาด" | mkA "เผ็ดร้อน" | mkA "เสียดแทง" | mkA "ขุ่นเคือง" | mkA "ยอดเยี่ยม" | mkA "เฉียบแหลม" | mkA "เย็นเฉียบ" | mkA "แสบแก้วหู" | mkA "ทันทีทันใด" | mkA "ซึ่งคาดไม่ถึง" | mkA "มีเล่ห์เหลี่ยม" ; -- src=panlex
lin formation_N = mkN "การก่อตั้ง" | mkN "การจัดตั้ง" | mkN "ลักษณะทางภูมิศาสตร์" | mkN "การพัฒนา" | mkN "การสร้าง" | mkN "การก่อรูปแบบ" | mkN "การวัดขนาดแถว" ; -- src=panlex
lin queen_N = mkN (thword "พระ" "รา" "ชิ" "นี") (thword "พระ" "องค์") | {-pan-} mkN "ควีน" | mkN "เจ้า" | mkN "แหม่ม" | mkN "ราชินี" | mkN "พระราชินี" | mkN "แมวตัวเมีย" | mkN "เทพี" | mkN "กษัตรี" | mkN "นางงาม" | mkN "ราชินี" | mkN "เทพธิดา" | mkN "ไพ่ควีน" | mkN "นางพญามด" | mkN "พระราชินี" | mkN "นางพญาผึ้ง" | mkN "มเหสีของกษัตริย์" | mkN "สิ่งที่เลิศที่สุด" | mkN "ตัวหมากรุกฝรั่งที่มีอํานาจมากที่สุด" ; -- src=panlex
lin waste_N = mkN "ขยะ" | mkN "ปฏิกูล" | mkN "เศษขยะ" | mkN "ของเสีย" | mkN "การสูญเปล่า" | mkN "การปราศจากพืชผล" | mkN "การทำให้เปลืองเสียเปล่า" | mkN "ขยะ" | mkN "ลดลง" | mkN "ผอมลง" | mkN "ของเสีย" | mkN "สูญเสีย" | mkN "เสียเวลา" | mkN "หมดเปลือง" | mkN "บริเวณร้าง" | mkN "สิ่งปฏิกูล" | mkN "สิ้นเปลือง" | mkN "การหมดเปลือง" | mkN "เปล่าประโยชน์" | mkN "ที่รกร้างว่างเปล่า" | mkN "พื้นที่ที่ถูกทําลาย" | mkN "พื้นที่ที่ไม่ได้ใช้ประโยชน์" | mkN "การสูญเสียไปโดยเปล่าประโยชน์" | mkN "สิ่งที่สูญเสียไปโดยเปล่าประโยชน์" ; -- src=panlex
lin virtually_Adv = variants{} ; -- 
lin expand_V2 = mkV2 "บูม" ; ---- | mkV "โก่ง" | mkV "เติบโต" | mkV "ขยายตัว" | mkV "ขยายความ" | mkV "รุ่งเรือง" | mkV "แผ่อิทธิพล" | mkV "เพิ่มเกินปกติ" | mkV "อธิบายเพิ่มเติม" | mkV "บาน" | mkV "แผ่" | mkV "ขยาย" | mkV "เพิ่ม" | mkV "ยืดออก" | mkV "คลี่ออก" | mkV "มากขึ้น" | mkV "แผ่ขยาย" | mkV "กว้างออก" | mkV "ทําให้ขยาย" | mkV "ทําให้กว้าง" | mkV "ทําให้มากขึ้น" | mkV "ทําให้กว้างออก" | mkV "เจริญรุ่งเรือง" | mkV "อธิบายอย่างละเอียด" ; -- src=panlex
lin expand_V = mkV "บูม" | mkV "โก่ง" | mkV "เติบโต" | mkV "ขยายตัว" | mkV "ขยายความ" | mkV "รุ่งเรือง" | mkV "แผ่อิทธิพล" | mkV "เพิ่มเกินปกติ" | mkV "อธิบายเพิ่มเติม" | mkV "บาน" | mkV "แผ่" | mkV "ขยาย" | mkV "เพิ่ม" | mkV "ยืดออก" | mkV "คลี่ออก" | mkV "มากขึ้น" | mkV "แผ่ขยาย" | mkV "กว้างออก" | mkV "ทําให้ขยาย" | mkV "ทําให้กว้าง" | mkV "ทําให้มากขึ้น" | mkV "ทําให้กว้างออก" | mkV "เจริญรุ่งเรือง" | mkV "อธิบายอย่างละเอียด" ; -- src=panlex
lin contemporary_A = mkA "ปัจจุบัน" | mkA "ทันสมัย" | mkA "ที่อยู่ในปัจจุบัน" | mkA "ซึ่งเกิดขึ้นพร้อมกัน" | mkA "ซึ่งกําลังมีชีวิตอยู่" | mkA "ซึ่งที่เกิดขึ้นพร้อมกัน" ; -- src=panlex
lin politician_N = mkN "นักการเมือง" | mkN "คนเล่นการเมือง" | mkN "ผู้นำทางการเมือง" | mkN "คนทำงานทางการเมือง" | mkN "นักการเมือง" | mkN "ผู้เล่นการเมือง" | mkN "ผู้ดํารงตําแหน่งหน้าที่ทางการเมือง" | mkN "ผู้แสวงตําแหน่งอํานาจเพื่อประโยชน์ส่วนตน" ; -- src=panlex
lin back_V = mkV "ถอย" | mkV "พนัน" | mkV "ถอยหลัง" | mkV "สนับสนุน" | mkV "หนุนหลัง" | mkV "วางเดิมพัน" | mkV "ให้การสนับสนุน" | mkV "สนับสนุนทางการเิงิน" | mkV "แสดงให้เห็นอย่างมีเหตุผล" | mkV "กลับมา" | mkV "ถอยหลัง" | mkV "ผลักดัน" | mkV "สนับสนุน" | mkV "หนุนหลัง" | mkV "วางเดิมพัน" | mkV "หันหลังชิด" | mkV "เดินทางกลับ" | mkV "หันหลังพิงกัน" | mkV "เขียนสลักหลัง" | mkV "เขียนบันทึกกํากับ" ; -- src=panlex
lin territory_N = mkN "เขต" | mkN "ขอบเขต" | mkN "ดินแดน" | mkN "อาณาเขต" | mkN "เขตปกครอง" | mkN "เขต" | mkN "ดินแดน" | mkN "เขตแดน" | mkN "ขอบข่าย" | mkN "พื้นที่" | mkN "อาณาเขต" | mkN "อาณาจักร" | mkN "แนวความคิด" | mkN "แนวการปฎิบัติ" | mkN "ดินแดนในอาณัติ" | mkN "ดินแดนในแผนที่" ; -- src=panlex
lin championship_N = mkN "สนับสนุน" | mkN "การแข่งขัน" | mkN "การสนับสนุน" | mkN "การอุปถัมภ์" | mkN "แชมเปี้ยนชิป" | mkN "ความช่วยเหลือ" | mkN "ความเป็นผู้ชนะ" | mkN "ตำแหน่งชนะเลิศ" | mkN "การป้องกัน" | mkN "การสนับสนุน" | mkN "การเป็นทนาย" | mkN "ตําแหน่งชนะเลิศ" | mkN "การต่อสู้ป้องกัน" | mkN "ตําแหน่งผู้ชนะเลิศ" | mkN "ภาวะที่เป็นแชมเปี้ยน" | mkN "การแข่งขันเพื่อได้ตัวผู้ชนะเลิศ" ; -- src=panlex
lin exception_N = mkN "การยกเว้น" | mkN "ข้อยกเว้น" | mkN "กรณีพิเศษ" | mkN "การยกเว้น" | mkN "ข้อยกเว้น" | mkN "การคัดค้าน" | mkN "คนที่ถูกยกเว้น" | mkN "คนที่ได้รับการยกเว้น" ; -- src=panlex
lin thick_A = mkA (thword "หนา") | {-pan-} mkA "ข้น" | mkA "ทึบ" | mkA "หนา" | mkA "หนาเตอะ" | mkA "ที่มืดมิด" | mkA "หัวขี้เลื่อย" | mkA "ดก" | mkA "ข้น" | mkA "ชิด" | mkA "ทึบ" | mkA "มัว" | mkA "หนา" | mkA "โง่" | mkA "ขุ่น" | mkA "ทึ่ม" | mkA "พร่า" | mkA "หยาบ" | mkA "กํายํา" | mkA "หนาทึบ" | mkA "เหนียว" | mkA "งี่เง่า" | mkA "สนิทสนม" | mkA "หนาแน่น" | mkA "ใกล้ชิด" | mkA "เบียดกัน" | mkA "ที่เด่นชัด" | mkA "มองไม่เห็น" | mkA "เป็นกันเอง" | mkA "ที่ไม่ชัดเจน" | mkA "ที่สังเกตได้ง่าย" | mkA "ยากที่จะมองผ่านไปได้" ; -- src=panlex
lin inquiry_N = mkN "การซักถาม" | mkN "การสอบถาม" | mkN "การไต่ถาม" | mkN "การค้นคว้า" | mkN "การไต่สวน" ; -- src=panlex
lin topic_N = mkN "หัวข้อ" | mkN "ญัตติ" | mkN "หัวข้อ" | mkN "เรื่อง" | mkN "กฎเกณฑ์" | mkN "หลักเกณฑ์" | mkN "หัวเรื่อง" | mkN "เรื่องพูด" | mkN "หัวข้อเรื่อง" ; -- src=panlex
lin resident_N = mkN "ผู้อาศัย" | mkN "ผู้พักอาศัย" | mkN "ผู้อยู่อาศัย" | mkN "แพทย์ประจำโรงพยาบาล" | mkN "ประจําอยู่" | mkN "ในเนื้อแท้" | mkN "ผู้พักอาศัย" | mkN "ผู้อยู่อาศัย" | mkN "อยู่เป็นหลักแหล่ง" ; -- src=panlex
lin transaction_N = mkN "ธุรกรรม" | mkN "การดำเนินการ" | mkN "การดำเนินธุรกิจ" | mkN "การค้า" | mkN "ธุรกิจ" | mkN "การจัดการ" | mkN "การติดต่อ" | mkN "การดําเนินการ" | mkN "บันทึกการประชุม" | mkN "การติดต่อทางธุรกิจ" | mkN "ความสัมพันธ์ระหว่างบุคคล" ; -- src=panlex
lin parish_N = mkN "ชุมชนวัด" | mkN "เขตศาสนา" | mkN "เขตทางศาสนา" ; -- src=panlex
lin supporter_N = mkN "ผช." | mkN "กระจับ" | mkN "ผู้ช่วย" | mkN "ผู้สนับสนุน" | mkN "ผู้หนุนหลัง" | mkN "ผู้ให้การสนับสนุน" | mkN "ที่ยึด" | mkN "ผู้ค้ําจุน" | mkN "ผู้อุปการะ" | mkN "ผู้สนับสนุน" | mkN "ผู้ส่งเสริม" | mkN "ผู้อุปถัมภ์" | mkN "เครื่องค้ํา" | mkN "เครื่องหนุน" | mkN "ผู้ช่วยเหลือ" | mkN "ผู้สงเคราะห์" | mkN "สายรัดถุงเท้ายาว" | mkN "เครื่องค้ําบนแผ่นโล่" | mkN "เครื่องช่วยปกป้องร่างกาย" | mkN "อุปกรณ์เสื้อผ้าที่ใช้ปกป้องร่างกายขณะเล่นกีฬา" ; -- src=panlex
lin massive_A = mkA "ที่มีมวลมาก" | mkA "มหึมา" | mkA "มโหฬาร" | mkA "เขื่อง" | mkA "ใหญ่โต หนักและแข็งมาก" | mkA "ใหญ่มาก" | mkA "ขนาดยักษ์" ; -- src=panlex
lin light_V2 = mkV2 "ลง" ; ---- | mkV "จุด" | mkV "จุดไฟ" | mkV "ตกเป็นภาระ" | mkV "เข้ามาเกาะ" | mkV "ตกเป็นหน้าที่" | mkV "เริ่มสูบบุหรี่" | mkV "จุด" | mkV "ก่อไฟ" | mkV "จุดไฟ" | mkV "ติดไฟ" | mkV "สว่าง" | mkV "ทําให้สว่าง" | mkV "ให้แสงสว่าง" | mkV "ให้ความสว่าง" ; -- src=panlex
lin light_V = mkV "ลง" | mkV "จุด" | mkV "จุดไฟ" | mkV "ตกเป็นภาระ" | mkV "เข้ามาเกาะ" | mkV "ตกเป็นหน้าที่" | mkV "เริ่มสูบบุหรี่" | mkV "จุด" | mkV "ก่อไฟ" | mkV "จุดไฟ" | mkV "ติดไฟ" | mkV "สว่าง" | mkV "ทําให้สว่าง" | mkV "ให้แสงสว่าง" | mkV "ให้ความสว่าง" ; -- src=panlex
lin unique_A = mkA "เดียว" | mkA "เป็นพิเศษ" | mkA "ซึ่งเป็นหนึ่งเดียว" ; -- src=panlex
lin challenge_V2 = mkV2 "ท้า" ; ---- | mkV "ท้าทาย" | mkV "คัดค้าน" | mkV "ขอดูบัตร" | mkV "ท้าทาย" | mkV "กระตุ้น" | mkV "เรียกร้อง" ; -- src=panlex
lin challenge_V = mkV "ท้า" | mkV "ท้าทาย" | mkV "คัดค้าน" | mkV "ขอดูบัตร" | mkV "ท้าทาย" | mkV "กระตุ้น" | mkV "เรียกร้อง" ; -- src=panlex
lin inflation_N = mkN "เงินเฟ้อ" | mkN "การเติมลม" | mkN "ภาวะเงินเฟ้อ" | mkN "การพองลม" | mkN "การสูบลม" | mkN "เงินเฟ้อ" | mkN "การพองตัว" | mkN "การลําพอง" | mkN "การเป่าลม" | mkN "การขยายตัว" | mkN "การสูงขึ้นอย่างผิดปกติ" ; -- src=panlex
lin assistance_N = mkN "ผู้ช่วย" | mkN "การช่วยเหลือ" | mkN "ความช่วยเหลือ" | mkN "การสนับสนุน" | mkN "การช่วยเหลือ" | mkN "การสงเคราะห์" | mkN "การอนุเคราะห์" | mkN "ความช่วยเหลือ" ; -- src=panlex
lin list_V2V = mmkV2V "พิง" ; ---- | mkV "เอน" | mkV "ลิสต์" | mkV "แจกแจง" | mkV "ลงบัญชี" | mkV "ทำให้เอน" | mkV "ลงรายการ" | mkV "ลิสต์รายชื่อ" | mkV "ลงบันทึกรายการ" | mkV "เอียงไปด้านหนึ่ง" | mkV "ใส่ขอบ" | mkV "ใส่บัว" | mkV "ลงบัญชี" | mkV "ลงรายการ" | mkV "ลงรายชื่อ" | mkV "ทําเป็นร่อง" | mkV "ทําให้เป็นแนว" ; -- src=panlex
lin list_V2 = mkV2 "พิง" ; ---- | mkV "เอน" | mkV "ลิสต์" | mkV "แจกแจง" | mkV "ลงบัญชี" | mkV "ทำให้เอน" | mkV "ลงรายการ" | mkV "ลิสต์รายชื่อ" | mkV "ลงบันทึกรายการ" | mkV "เอียงไปด้านหนึ่ง" | mkV "ใส่ขอบ" | mkV "ใส่บัว" | mkV "ลงบัญชี" | mkV "ลงรายการ" | mkV "ลงรายชื่อ" | mkV "ทําเป็นร่อง" | mkV "ทําให้เป็นแนว" ; -- src=panlex
lin list_V = mkV "พิง" | mkV "เอน" | mkV "ลิสต์" | mkV "แจกแจง" | mkV "ลงบัญชี" | mkV "ทำให้เอน" | mkV "ลงรายการ" | mkV "ลิสต์รายชื่อ" | mkV "ลงบันทึกรายการ" | mkV "เอียงไปด้านหนึ่ง" | mkV "ใส่ขอบ" | mkV "ใส่บัว" | mkV "ลงบัญชี" | mkV "ลงรายการ" | mkV "ลงรายชื่อ" | mkV "ทําเป็นร่อง" | mkV "ทําให้เป็นแนว" ; -- src=panlex
lin identity_N = mkN "อัตลักษณ์" | mkN "บุคลิกส่วนตัว" | mkN "บุคลิกลักษณะเฉพาะ" | mkN "รูปพรรณ" | mkN "หลักฐาน" | mkN "เอกลักษณ์" | mkN "ลักษณะพิเศษ" | mkN "ลักษณะเฉพาะ" | mkN "บุคลิกลักษณะ" | mkN "ความเหมือนกัน" ; -- src=panlex
lin suit_V2 = mkV2 "เหมาะสม" ; ---- | mkV "เหมาะกับ" | mkV "ยอมรับได้" | mkV "เหมาะกับ" | mkV "เหมาะสมกัน" | mkV "ทําให้เหมาะสม" | mkV "ทําให้เหมาะกับ" ; -- src=panlex
lin suit_V = mkV "เหมาะสม" | mkV "เหมาะกับ" | mkV "ยอมรับได้" | mkV "เหมาะกับ" | mkV "เหมาะสมกัน" | mkV "ทําให้เหมาะสม" | mkV "ทําให้เหมาะกับ" ; -- src=panlex
lin parliamentary_A = mkA "แห่งรัฐสภา" | mkA "ที่ผ่านรัฐสภา" | mkA "เกี่ยวกับรัฐสภา" ; -- src=panlex
lin unknown_A = mkA "นิรนาม" | mkA "ที่ไม่ทราบชื่อ" | mkA "ที่ไม่มีชื่อเสียง" | mkA "ซึ่งไม่เป็นที่รู้จัก" | mkA "ที่ไม่รู้" | mkA "ที่ไม่เป็นเป็นรู้จัก" ; -- src=panlex
lin preparation_N = mkN "การบ้าน" | mkN "ความพร้อม" | mkN "การทำอาหาร" | mkN "การคิดวางแผน" | mkN "การตระเตรียม" | mkN "สภาพความพร้อม" | mkN "การประกอบอาหาร" | mkN "การพร้อมเพรียง" | mkN "การเตรียมพร้อม" | mkN "การเตรียม" | mkN "การตระเตรียม" | mkN "การเตรียมการ" | mkN "สิ่งที่เตรียม" | mkN "วิธีการเตรียมการ" | mkN "ตัวอย่างสําหรับตรวจ วินิจฉัยหรืออื่น ๆ" ; -- src=panlex
lin elect_V3 = mkV3 "เลือก" ; ---- | mkV "เลือกตั้ง" | mkV "คัด" | mkV "เลือก" | mkV "คัดเลือก" | mkV "ออกเสียงเลือกตั้ง" ; -- src=panlex
lin elect_V2V = mmkV2V "เลือก" ; ---- | mkV "เลือกตั้ง" | mkV "คัด" | mkV "เลือก" | mkV "คัดเลือก" | mkV "ออกเสียงเลือกตั้ง" ; -- src=panlex
lin elect_V2 = mkV2 "เลือก" ; ---- | mkV "เลือกตั้ง" | mkV "คัด" | mkV "เลือก" | mkV "คัดเลือก" | mkV "ออกเสียงเลือกตั้ง" ; -- src=panlex
lin elect_V = mkV "เลือก" | mkV "เลือกตั้ง" | mkV "คัด" | mkV "เลือก" | mkV "คัดเลือก" | mkV "ออกเสียงเลือกตั้ง" ; -- src=panlex
lin badly_Adv = variants{} ; -- 
lin moreover_Adv = mkAdv "นอกจากนี้" | mkAdv "อนึ่ง" | mkAdv "จากนั้น" | mkAdv "นอกจากนั้น" | mkAdv "ยิ่งกว่านั้น" ; -- src=panlex
lin tie_V2 = mkV2 (thword "ผูก") ;
lin tie_V = mkV "ผูก" | mkV "มัด" | mkV "เจ๊า" | mkV "เสมอ" | mkV "ผูกพัน" | mkV "ข้อจำกัด" | mkV "โยงเสียง" | mkV "เชื่อมโยง" | mkV "ทำพิธีสมรส" | mkV "จัดงานแต่งงาน" | mkV "ทำพิธีแต่งงาน" | mkV "ผูก" | mkV "มัด" | mkV "ล่าม" | mkV "จํากัด" | mkV "เสมอกัน" | mkV "ผูกเป็นปม" | mkV "ผูกให้แน่น" | mkV "วางเงื่อนไข" | mkV "ผูกเป็นเงื่อน" | mkV "ได้แต้มหรือคะแนนเท่ากัน" ; -- src=panlex
lin cancer_N = mkN "มะเร็ง" | mkN "โรคมะเร็ง" | mkN "มะเร็ง" | mkN "ความหายนะ" | mkN "เนื้อร้าย" | mkN "โรคมะเร็ง" | mkN "ชื่อกลุ่มดาวร" | mkN "เส้นที่ขนานกับเส้นศูนย์สูตร" ; -- src=panlex
lin champion_N = mkN "แชมป์" | mkN "นักสู้" | mkN "ผู้ชนะ" | mkN "ดาวรุ่ง" | mkN "อัจฉริยะ" | mkN "นักต่อสู้" | mkN "แชมเปี้ยน" | mkN "ผู้สนับสนุน" | mkN "ผู้หนุนหลัง" | mkN "ผู้เชี่ยวชาญ" | mkN "อัจฉริยบุคคล" | mkN "ซุปเปอร์สตาร์" | mkN "ผู้ให้การสนับสนุน" | mkN "ผู้เชี่ยวชาญเฉพาะด้าน" | mkN "นักรบ" | mkN "สนับสนุน" | mkN "นักต่อสู้" | mkN "ผู้ชนะเลิศ" | mkN "ผู้สนับสนุน" | mkN "นักสู้ในสนามรบ" | mkN "ผู้ให้ความช่วยเหลือ" | mkN "ผู้ที่ได้คะแนนสูงสุดในการแข่งขัน" ; -- src=panlex
lin exclude_V2 = variants{} ; -- 
lin review_V2 = mkV2 "วิจารณ์" ; ---- | mkV "ทบทวนความจำ" | mkV "ทบทวน" | mkV "ตรวจสอบ" | mkV "พิจารณาใหม่" | mkV "เขียนบทวิจารณ์" ; -- src=panlex
lin review_V = mkV "วิจารณ์" | mkV "ทบทวนความจำ" | mkV "ทบทวน" | mkV "ตรวจสอบ" | mkV "พิจารณาใหม่" | mkV "เขียนบทวิจารณ์" ; -- src=panlex
lin licence_N = mkN "เสรีภาพที่เกินขอบเขต" | mkN "เสรีภาพ" | mkN "ใบอนุญาต" | mkN "การอนุญาต" | mkN "ให้อํานาจ" | mkN "การอนุมัติ" | mkN "สิทธิการดําเนินการ" | mkN "ความเป็นอิสระที่จําทําสิ่งใดสิ่งหนึ่ง" ; -- src=panlex
lin breakfast_N = mkN "ข้าวเช้า" | mkN "มื้อเช้า" | mkN "อาหารเช้า" | mkN "เบรกฟาสต์" | mkN "อาหารมื้อเช้า" | mkN "อาหารเบรกฟาสต์" | mkN "อาหารเช้า" | mkN "อาหารมื้อเช้า" ; -- src=panlex
lin minority_N = mkN "ส่วนน้อย" | mkN "ชนกลุ่มน้อย" | mkN "ส่วนน้อย" | mkN "ชนหมู่น้อย" | mkN "คนกลุ่มน้อย" | mkN "ชนกลุ่มน้อย" | mkN "เสียงข้างน้อย" | mkN "กลุ่มที่น้อยกว่า" | mkN "ความเป็นผู้เยาว์" | mkN "กลุ่มสมาชิกรัฐสภาที่มีเสียงข้างน้อย" ; -- src=panlex
lin appreciate_V2 = mkV2 "หวงแหน" ; ---- | mkV "แข็งค่า" | mkV "เพิ่มค่า" | mkV "ซาบซึ้งใจ" | mkV "ให้คุณค่า" | mkV "เข้าใจถ่องแท้" | mkV "ชื่นชม" | mkV "ยกย่อง" | mkV "ขึ้นราคา" | mkV "เห็นคุณค่า" | mkV "สํานึกคุณค่า" | mkV "สํานึกบุญคุณ" ; -- src=panlex
lin appreciate_V = mkV "หวงแหน" | mkV "แข็งค่า" | mkV "เพิ่มค่า" | mkV "ซาบซึ้งใจ" | mkV "ให้คุณค่า" | mkV "เข้าใจถ่องแท้" | mkV "ชื่นชม" | mkV "ยกย่อง" | mkV "ขึ้นราคา" | mkV "เห็นคุณค่า" | mkV "สํานึกคุณค่า" | mkV "สํานึกบุญคุณ" ; -- src=panlex
lin fan_N = variants{} ; -- 
lin fan_3_N = variants{} ; -- 
lin fan_2_N = variants{} ; -- 
lin fan_1_N = variants{} ; -- 
lin chief_N = mkN "ห.น." | mkN "หน." | mkN "เฮด" | mkN "ลูกพี่" | mkN "หัวหน้า" | mkN "เจ้านาย" | mkN "โฟร์แมน" | mkN "หัวหน้าเผ่า" | mkN "หัวหน้าคนงาน" | mkN "ผู้นํา" | mkN "หัวหน้า" ; -- src=panlex
lin accommodation_N = mkN "ที่อยู่อาศัย" | mkN "การปรับโฟกัสของตา" | mkN "การอำนวยความสะดวก" | mkN "เงินยืม" | mkN "การยินยอม" | mkN "การตกลงกัน" | mkN "การต้อนรับ" | mkN "การปรองดอง" | mkN "การปรับตัว" | mkN "เงินกู้ยืม" | mkN "อาหารและที่พัก" | mkN "การปรับโฟกัสของตา" | mkN "การอํานวยความสะดวก" | mkN "ที่นั่งที่นอนบนรถไฟ" | mkN "การพยายามประนีประนอมกัน" | mkN "ความพร้อมที่จะช่วยเหลือผู้อื่น" ; -- src=panlex
lin subsequent_A = mkA "ก็" | mkA "ต่อมา" | mkA "ภายหลัง" | mkA "ครั้นแล้ว" | mkA "ซึ่งตามมา" | mkA "หลังจากที่" ; -- src=panlex
lin democracy_N = mkN "ประชาธิปไตย" | mkN "ระบอบประชาธิปไตย" | mkN "ประชาธิปไตย" | mkN "ระบอบประชาธิปไตย" | mkN "ความเป็นประชาธิปไตย" | mkN "ความเสมอภาคของสังคม" | mkN "การปกครองแบบประชาธิปไตย" | mkN "ประเทศที่ปกครองด้วยระบอบประชาธปไตย" ; -- src=panlex
lin brown_A = mkA (thword "สี" "น้ำ" "ตาล") | {-pan-} mkA "น้ำตาล" | mkA "สีน้ำตาล" | mkA "สีน้ําตาล" ; -- src=panlex
lin taste_N = mkN "คำ" | mkN "รส" | mkN "รสชาติ" | mkN "การรับรส" | mkN "การรู้รส" | mkN "การแยกแยะอย่างประณีต" | mkN "รส" | mkN "การชิม" | mkN "รสชาติ" | mkN "รสนิยม" | mkN "ลิ้มรส" | mkN "การชิมรส" | mkN "ความพอใจ" | mkN "ประสาทรส" | mkN "การลิ้มรส" | mkN "ความชื่นชอบ" | mkN "ประสาทในการรับรส" | mkN "ความสามารถในการพิจาณา" | mkN "ความสามารถในการเลือกเฟ้น" ; -- src=panlex
lin crown_N = mkN "คอฟัน" | mkN "มงกุฎ" | mkN "ยอดเขา" | mkN "ครอบฟัน" | mkN "ปลายยอด" | mkN "ยอดหมวก" | mkN "กระหม่อม" | mkN "มงกุฎเพชร" | mkN "เหรียญคราวน์" | mkN "รางวัลสำหรับผู้ชนะ" | mkN "ยอด" | mkN "มงกุฎ" | mkN "มาลัย" | mkN "ฟันปลอม" | mkN "หงอนไก่" | mkN "กระหม่อม" | mkN "กษัตริย์" | mkN "จุดสูงสุด" | mkN "ผู้ปกครอง" | mkN "ราชบัลลังก์" | mkN "มาลัยสวมศีรษะ" | mkN "ส่วนยอดของศีรษะ" | mkN "สิ่งที่คล้ายมงกุฎ" | mkN "เครื่องประดับสําหรับศีรษะ" | mkN "เกียรติยศจากผลงานที่ดีเด่น" ; -- src=panlex
lin permit_V2V = mmkV2V "ยอม" ; ---- | mkV "ยินยอม" | mkV "อนุญาต" | mkV "ให้" | mkV "ยินยอม" | mkV "อนุญาต" | mkV "เห็นชอบ" | mkV "เห็นพ้อง" ; -- src=panlex
lin permit_V2 = mkV2 "ยอม" ; ---- | mkV "ยินยอม" | mkV "อนุญาต" | mkV "ให้" | mkV "ยินยอม" | mkV "อนุญาต" | mkV "เห็นชอบ" | mkV "เห็นพ้อง" ; -- src=panlex
lin permit_V = mkV "ยอม" | mkV "ยินยอม" | mkV "อนุญาต" | mkV "ให้" | mkV "ยินยอม" | mkV "อนุญาต" | mkV "เห็นชอบ" | mkV "เห็นพ้อง" ; -- src=panlex
lin buyerMasc_N = variants{} ; -- 
lin gift_N = mkN "การให้" | mkN "พรสวรรค์" | mkN "ความสามารถ" | mkN "ของที่ได้รับ" | mkN "ของฝาก" | mkN "มอบให้" | mkN "ของขวัญ" | mkN "พรสวรรค์" | mkN "ของกํานัล" | mkN "ของเยี่ยม" | mkN "ความสามารถพิเศษ" ; -- src=panlex
lin resolution_N = mkN "เฉลย" | mkN "คำตอบ" | mkN "รีโซลูชัน" | mkN "การแก้ปัญหา" | mkN "ความแน่วแน่" | mkN "วิธีแก้ปัญหา" | mkN "ผลการตัดสินใจ" | mkN "กำลังการแยกชัด" | mkN "ความละเอียดของภาพ" | mkN "มติ" | mkN "มิติ" | mkN "การลงมติ" | mkN "ความเห็น" | mkN "การยืนหยัด" | mkN "การแก้ปัญหา" | mkN "ความแน่วแน่" | mkN "ความเด็ดเดี่ยว" | mkN "การตัดสินใจแล้ว" | mkN "ความตั้งใจอย่างแน่วแน่" | mkN "การตัดสินใจอย่างเด็ดขาด" | mkN "การยุบลงของส่วนที่บวมหรืออักเสบ" ; -- src=panlex
lin angry_A = mkA "โกรธ" | mkA "แค้น" | mkA "โกรธ" | mkA "โมโห" | mkA "เดือด" | mkA "อักเสบ" | mkA "ขัดเคือง" | mkA "ขุ่นข้อง" | mkA "ฉุนเฉียว" | mkA "ขุ่นเคือง" | mkA "โกรธเคือง" | mkA "ที่มีพายุแรง" ; -- src=panlex
lin metre_N = mkN "ม." | mkN "เมตร" | mkN "จังหวะในฉันทลักษณ์" | mkN "เมตร" | mkN "หน่วยวัดเป็นเมตร" ; -- src=panlex
lin wheel_N = mkN "ล้อ" | mkN "รถถีบ" | mkN "จักรยาน" | mkN "พวงมาลัย" | mkN "รถจักรยาน" | mkN "วงล้อรูเล็ต" | mkN "เครื่องทรมานดึงแขนขา" | mkN "กง" | mkN "ล้อ" | mkN "ล้อรถ" | mkN "กงล้อแห่งโชคชะตา" | mkN "การเคลื่อนที่เป็นวงกลม" | mkN "บุคคลที่กระฉับกระเฉงและมีอิทธิพล" | mkN "สิ่งที่มีลักษณะเป็นวงกลมหรือทรงกลม" | mkN "ล้อเลื่อนที่ติดไว้ทําให้เคลื่อนที่ได้ง่าย" ; -- src=panlex
lin clause_N = mkN "มาตรา" | mkN "หัวข้อ" | mkN "อนุประโยค" | mkN "มาตรา" | mkN "ข้อย่อย" | mkN "อนุพากย์" | mkN "อนุประโยค" | mkN "ประโยคเล็ก" | mkN "ประโยคย่อยที่เป็นส่วนหนึ่งของประโยคใหญ่" ; -- src=panlex
lin break_N = mkN "เบรก" | mkN "การหัก" | mkN "การหยุด" | mkN "ช่วงพัก" | mkN "กระดูกแตก" | mkN "การแตกแยก" | mkN "การแหกคุก" | mkN "ความโชคดี" | mkN "ความแตกแยก" | mkN "โอเพ่นเฟรม" | mkN "การทำให้หัก" | mkN "ความแปลกแยก" | mkN "การขัดจังหวะ" | mkN "การหนีออกจาก" | mkN "การเบรกเกมเสิร์ฟ" | mkN "การทะเลาะเบาะแว้ง" | mkN "รอยเลื่อนของเปลือกโลก" | mkN "พัก" | mkN "การแยก" | mkN "การหยุด" | mkN "การแตกหัก" | mkN "การหยุดพัก" | mkN "การเปลี่ยนแปลงอย่างกระทันหัน" ; -- src=panlex
lin tank_N = mkN "คุก" | mkN "รถถัง" | mkN "แทงก์" | mkN "แทงค์" | mkN "แท็งค์" | mkN "ห้องขัง" | mkN "ตู้บรรทุกแก็ส" | mkN "ถัง" | mkN "รถถัง" | mkN "ทะเลสาบ" | mkN "บ่อน้ํา" | mkN "แท็งก์น้ํา" | mkN "ห้องขังนักโทษ" | mkN "ถังขนาดใหญ่สําหรับบรรจุน้ําหรือก๊าซ" | mkN "ปริมาณน้ําหรือก๊าซที่บรรจุในถังขนาดใหญ่" ; -- src=panlex
lin benefit_V2 = mkV2 "ได้รับ" ; ---- | mkV "มีประโยชน์" | mkV "มีผลดีต่อ" | mkV "ได้รับผลดี" | mkV "มีประโยชน์ต่อ" | mkV "ได้รับประโยชน์" ; -- src=panlex
lin benefit_V = mkV "ได้รับ" | mkV "มีประโยชน์" | mkV "มีผลดีต่อ" | mkV "ได้รับผลดี" | mkV "มีประโยชน์ต่อ" | mkV "ได้รับประโยชน์" ; -- src=panlex
lin engage_V2 = mkV2 "จ้าง" ; ---- | mkV "เช่า" | mkV "หมั้น" | mkV "ครอบงำ" | mkV "จ้างวาน" | mkV "ว่าจ้าง" | mkV "หมกหมุ่น" | mkV "เข้าร่วม" | mkV "ก่อสงคราม" | mkV "ทำให้จดจ่อ" | mkV "ร่วมกิจกรรม" | mkV "รบ" | mkV "สู้รบ" | mkV "ต่อสู้" | mkV "ว่าจ้าง" | mkV "หมั้นหมาย" | mkV "มีส่วนร่วม" | mkV "จ้างให้ทํางาน" | mkV "ทําให้เริ่มทํางาน" | mkV "เริ่มเดินเครื่องทํางาน" ; -- src=panlex
lin engage_V = mkV "จ้าง" | mkV "เช่า" | mkV "หมั้น" | mkV "ครอบงำ" | mkV "จ้างวาน" | mkV "ว่าจ้าง" | mkV "หมกหมุ่น" | mkV "เข้าร่วม" | mkV "ก่อสงคราม" | mkV "ทำให้จดจ่อ" | mkV "ร่วมกิจกรรม" | mkV "รบ" | mkV "สู้รบ" | mkV "ต่อสู้" | mkV "ว่าจ้าง" | mkV "หมั้นหมาย" | mkV "มีส่วนร่วม" | mkV "จ้างให้ทํางาน" | mkV "ทําให้เริ่มทํางาน" | mkV "เริ่มเดินเครื่องทํางาน" ; -- src=panlex
lin alive_A = mkA "มีพลัง" | mkA "คุกรุ่น" | mkA "มีชีวิตชีวา" | mkA "อยู่" | mkA "คงอยู่" | mkA "ยังอยู่" | mkA "ร่าเริง" | mkA "สนใจต่อ" | mkA "ระวังตัว" | mkA "ครึกครื้น" | mkA "ยังคงอยู่" | mkA "ตระหนักถึง" | mkA "เต็มไปด้วย" | mkA "มีชีวิตชีวา" | mkA "มีชีวิตอยู่" | mkA "กระปรี้กระเปร่า" | mkA "เต็มไปด้วยชีวิต" ; -- src=panlex
lin complaint_N = mkN "ข้อหา" | mkN "ความไม่พอใจ" | mkN "ความเจ็บป่วย" | mkN "โรคภัยไข้เจ็บ" | mkN "การร้องไห้คร่ำครวญ" | mkN "การบ่น" | mkN "ความไม่พอใจ" | mkN "การร้องทุกข์" | mkN "ข้อที่ไม่พอใจ" | mkN "การแสดงความข้องใจ" | mkN "มูลเหตุที่บ่นหรือร้องทุกข์" | mkN "การฟ้องร้องคดีแพ่งในระยะแรกของโจทก์" ; -- src=panlex
lin inch_N = mkN "นิ้ว" | mkN "คอลัมน์นิ้ว" | mkN "จํานวนเล็กน้อยมาก" ; -- src=panlex
lin firm_A = mkA "แน่น" | mkA "กระชับ" | mkA "มั่นคง" | mkA "แน่วแน่" | mkA "อยู่กับที่" | mkA "กงสี" | mkA "ห้าง" | mkA "แข็ง" | mkA "แน่น" | mkA "มั่นคง" | mkA "แน่นอน" | mkA "ใจแข็ง" | mkA "ร้านค้า" | mkA "เข้มงวด" | mkA "เด็ดขาด" | mkA "แข็งแรง" | mkA "แน่นหนา" | mkA "แน่วแน่" | mkA "ไม่นิ่ม" | mkA "ไม่สั่น" | mkA "หนักแน่น" | mkA "ห้างร้าน" | mkA "เฉียบขาด" | mkA "แข็งแกร่ง" | mkA "เหนียวแน่น" | mkA "ห้างหุ้นส่วน" | mkA "ไม่มีทางเปลี่ยนแปลง" ; -- src=panlex
lin abandon_V2 = variants{} ; -- 
lin blame_V2 = mkV2 "ตำหนิ" ; ---- | mkV "จับผิด" | mkV "ตําหนิ" | mkV "ว่ากล่าว" | mkV "รับผิดชอบต่อสิ่งไม่ดีที่เกิดขึ้น" ; -- src=panlex
lin blame_V = mkV "ตำหนิ" | mkV "จับผิด" | mkV "ตําหนิ" | mkV "ว่ากล่าว" | mkV "รับผิดชอบต่อสิ่งไม่ดีที่เกิดขึ้น" ; -- src=panlex
lin clean_V2 = mkV2 "สี" ; ---- | mkV "ขจัด" | mkV "ล้าง" | mkV "ถอนขน" | mkV "ชำระล้าง" | mkV "กวาดเรียบ" | mkV "ทำความสะอาด" | mkV "ล้างทำความสะอาด" | mkV "เอาสิ่งสกปรกออก" | mkV "สะอาด" | mkV "ทําความสะอาด" | mkV "ทําให้ว่างเปล่า" ; -- src=panlex
lin clean_V = mkV "สี" | mkV "ขจัด" | mkV "ล้าง" | mkV "ถอนขน" | mkV "ชำระล้าง" | mkV "กวาดเรียบ" | mkV "ทำความสะอาด" | mkV "ล้างทำความสะอาด" | mkV "เอาสิ่งสกปรกออก" | mkV "สะอาด" | mkV "ทําความสะอาด" | mkV "ทําให้ว่างเปล่า" ; -- src=panlex
lin quote_V2 = mkV2 "อ้าง" ; ---- | mkV "อ้างถึง" | mkV "กล่างถึง" | mkV "กล่าวอ้าง" | mkV "บอกราคา" | mkV "แจ้งราคา" | mkV "คัดลอกจาก" | mkV "ยกคําพูดมา" | mkV "อ้างมาจากหนังสือ" | mkV "ปิดคําด้วยอัญประกาศ" | mkV "ปิดคําด้วยเครื่องหมายคําพูด" ; -- src=panlex
lin quote_V = mkV "อ้าง" | mkV "อ้างถึง" | mkV "กล่างถึง" | mkV "กล่าวอ้าง" | mkV "บอกราคา" | mkV "แจ้งราคา" | mkV "คัดลอกจาก" | mkV "ยกคําพูดมา" | mkV "อ้างมาจากหนังสือ" | mkV "ปิดคําด้วยอัญประกาศ" | mkV "ปิดคําด้วยเครื่องหมายคําพูด" ; -- src=panlex
lin quantity_N = mkN "จำนวน" | mkN "ปริมาณ" | mkN "จํานวน" | mkN "ปริมาณ" | mkN "ปริมาณมาก" ; -- src=panlex
lin rule_VS = mmkVS "คุม" ; ---- | mkV "ปกครอง" | mkV "ออกคำสั่ง" | mkV "คุม" | mkV "ควบคุม" | mkV "ชี้ขาด" | mkV "ตัดสิน" | mkV "ตีเส้น" | mkV "ปกครอง" | mkV "ขีดเส้น" | mkV "ครอบงํา" | mkV "พิพากษา" | mkV "มีอิทธิพล" | mkV "มีอิทธิพลเหนือ" ; -- src=panlex
lin rule_V2 = mkV2 "คุม" ; ---- | mkV "ปกครอง" | mkV "ออกคำสั่ง" | mkV "คุม" | mkV "ควบคุม" | mkV "ชี้ขาด" | mkV "ตัดสิน" | mkV "ตีเส้น" | mkV "ปกครอง" | mkV "ขีดเส้น" | mkV "ครอบงํา" | mkV "พิพากษา" | mkV "มีอิทธิพล" | mkV "มีอิทธิพลเหนือ" ; -- src=panlex
lin rule_V = mkV "คุม" | mkV "ปกครอง" | mkV "ออกคำสั่ง" | mkV "คุม" | mkV "ควบคุม" | mkV "ชี้ขาด" | mkV "ตัดสิน" | mkV "ตีเส้น" | mkV "ปกครอง" | mkV "ขีดเส้น" | mkV "ครอบงํา" | mkV "พิพากษา" | mkV "มีอิทธิพล" | mkV "มีอิทธิพลเหนือ" ; -- src=panlex
lin guilty_A = mkA "มีความผิด" | mkA "ผิด" | mkA "ละอาย" | mkA "มีความผิด" | mkA "ซึ่งมีความผิด" | mkA "ซึ่งสํานึกผิด" | mkA "เกี่ยวกับความผิด" ; -- src=panlex
lin prior_A = mkA "ก่อน" | mkA "อันก่อน" | mkA "ที่มีมาก่อน" | mkA "ที่สําคัญกว่า" ; -- src=panlex
lin round_A = mkA (thword "กลม") | {-pan-} mkA "กลม" | mkA "มน" | mkA "ยก" | mkA "กลม" | mkA "มาก" | mkA "รอบ" | mkA "อวบ" | mkA "เกม" | mkA "กลมๆ" | mkA "ชัดเจน" | mkA "การตรวจ" | mkA "เต็มที่" | mkA "กลมกล่อม" | mkA "ดังกังวาน" | mkA "การหมุนรอบ" | mkA "คล่องแคล่ว" | mkA "อ้อมกลับมา" | mkA "มีชีวิตชีวา" | mkA "เป็นกิจวัตร" | mkA "การลาดตระเวณ" | mkA "เป็นรูปทรงกลม" | mkA "ซึ่งเคลื่อนเป็นวงกลม" | mkA "สิ่งที่เป็นรูปทรงกลม" | mkA "สิ่งที่เป็นรูปวงแหวน" ; -- src=panlex
lin eastern_A = mkA "ตะวันออก" | mkA "มาจากทิศตะวันออก" | mkA "ไปทางทิศตะวันออก" | mkA "เกี่ยวกับทิศตะวันออก" | mkA "ที่อยู่ทางทิศตะวันออก" | mkA "เกี่ยวกับหรือไปหรือมาจากทางทิศตะวันออก" ; -- src=panlex
lin coat_N = mkN (thword "เสื้อ" "คลุม") "ตัว" | {-pan-} mkN "ขน" | mkN "โค้ต" | mkN "เสื้อโค้ต" | mkN "ระบบผมและขน" | mkN "สิ่งที่ใช้เคลือบ" | mkN "โค้ต" | mkN "เปลือก" | mkN "ขนสัตว์" | mkN "เสื้อนอก" | mkN "หนังสัตว์" | mkN "เสื้อคลุม" | mkN "สิ่งปกคลุม" | mkN "สิ่งที่ห่อหุ้ม" | mkN "สิ่งที่ปกคลุมผิวหน้าไว้บางๆ" ; -- src=panlex
lin involvement_N = mkN "ความสนใจ" | mkN "การมีส่วนร่วม" | mkN "ควาสัมพันธ์ทางเพศ" | mkN "ความสัมพันธ์ฉันชู้สาว" | mkN "การเกี่ยวพัน" | mkN "การเกี่ยวโยง" | mkN "การเกี่ยวข้อง" | mkN "ความอื้อฉาวเชิงชู้สาว" | mkN "ความสัมพันธ์ในด้านชู้สาว" ; -- src=panlex
lin tension_N = mkN "แรงดึง" | mkN "ความตึง" | mkN "การดึงให้ตึง" | mkN "ความตึงเครียด" | mkN "ความตึง" | mkN "ความเครียด" | mkN "เครื่องดึง" | mkN "เครื่องยึด" | mkN "ความตึงเครียด" | mkN "สภาพตึงเครียด" | mkN "ความเครียดทางจิตใจ" | mkN "แรงเบ่งหรือแก๊สหรือไอ" | mkN "เครื่องมือที่ใช้ดึงให้ตึง" ; -- src=panlex
lin diet_N = mkN "อาหาร" | mkN "การควบคุมอาหาร" | mkN "อาหารตามคำแนะนำ" | mkN "อาหาร" | mkN "อาหารพิเศษ" | mkN "สิ่งที่กินได้" ; -- src=panlex
lin enormous_A = mkA "มหึมา" | mkA "ใหญ่โต" | mkA "ร้ายกาจ" | mkA "เลวทราม" | mkA "ชั่วร้าย" | mkA "ไร้ศีลธรรม" | mkA "ที่ใหญ่มหึมา" | mkA "ที่ใหญ่โตมโหฬาร" ; -- src=panlex
lin score_N = mkN "เกรด" | mkN "แต้ม" | mkN "คะแนน" | mkN "สกอร์" | mkN "แต้มสะสม" | mkN "การทำแต้ม" | mkN "การทำคะแนน" | mkN "การทำสกอร์" | mkN "เซตที่มียี่สิบสมาชิก" | mkN "กลุ่มที่มียี่สิบสมาชิก" | mkN "ขีด" | mkN "บาก" | mkN "รอย" | mkN "หมาย" | mkN "แต้ม" | mkN "กระทง" | mkN "คะแนน" | mkN "มีชัย" | mkN "ตําหนิ" | mkN "ยี่สิบ" | mkN "รอยขีด" | mkN "รอยบาก" | mkN "รอยแผล" | mkN "เหตุผล" | mkN "จดคะแนน" | mkN "ทําแต้ม" | mkN "นับแต้ม" | mkN "ประเด็น" | mkN "มูลเหตุ" | mkN "เส้นขีด" | mkN "โน้ตเพลง" | mkN "ทํารอยบาก" | mkN "ประเมินผล" | mkN "การทําแต้ม" | mkN "การนับแต้ม" | mkN "การทําคะแนน" | mkN "รายการบัญชี" | mkN "จํานวนมากมาย" | mkN "บัญชีหนี้สิน" | mkN "ลงบัญชีหนี้สิน" ; -- src=panlex
lin rarely_Adv = variants{} ; -- 
lin prize_N = mkN "ของโจร" | mkN "รางวัล" | mkN "ทรัพย์สินที่ปล้นมา" | mkN "ของด’ ๆ" | mkN "รางวัล" | mkN "ลาภลอย" | mkN "ของมีค่า" | mkN "การจับกุม" | mkN "ของชั้นยอด" | mkN "ทรัพย์เชลย" | mkN "เงินรางวัล" | mkN "ประเมินค่าสูง" | mkN "ที่ได้รับรางวัล" | mkN "สิ่งของที่ยึดได้" | mkN "ทรัพย์สินที่ยึดได้" ; -- src=panlex
lin remaining_A = variants{} ; -- 
lin significantly_Adv = variants{} ; -- 
lin glance_V2 = mkV2 "แอบมอง" ; ---- | mkV "แวบมอง" | mkV "ชายตามอง" | mkV "ชําเลือง" | mkV "เหลือบดู" ; -- src=panlex
lin glance_V = mkV "แอบมอง" | mkV "แวบมอง" | mkV "ชายตามอง" | mkV "ชําเลือง" | mkV "เหลือบดู" ; -- src=panlex
lin dominate_V2 = mkV2 "ครอบงำ" ; ---- | mkV "โดดเด่น" | mkV "มองลงไปเห็น" | mkV "ควบคุม" | mkV "ปกครอง" | mkV "ครอบงํา" | mkV "มีอิทธิพลต่อ" | mkV "มีอํานาจเหนือ" ; -- src=panlex
lin dominate_V = mkV "ครอบงำ" | mkV "โดดเด่น" | mkV "มองลงไปเห็น" | mkV "ควบคุม" | mkV "ปกครอง" | mkV "ครอบงํา" | mkV "มีอิทธิพลต่อ" | mkV "มีอํานาจเหนือ" ; -- src=panlex
lin trust_VS = variants{} ; -- 
lin trust_V2 = variants{} ; -- 
lin naturally_Adv = variants{} ; -- 
lin interpret_V2 = mkV2 "รู้" ; ---- | mkV "แปล" | mkV "ตีความ" | mkV "วาดภาพ" | mkV "อธิบาย" | mkV "เข้าใจ" | mkV "ถอดความ" | mkV "แปล" | mkV "แจ้ง" | mkV "แสดง" | mkV "ตีความ" | mkV "อธิบาย" | mkV "เข้าใจ" | mkV "แปลความหมาย" ; -- src=panlex
lin interpret_V = mkV "รู้" | mkV "แปล" | mkV "ตีความ" | mkV "วาดภาพ" | mkV "อธิบาย" | mkV "เข้าใจ" | mkV "ถอดความ" | mkV "แปล" | mkV "แจ้ง" | mkV "แสดง" | mkV "ตีความ" | mkV "อธิบาย" | mkV "เข้าใจ" | mkV "แปลความหมาย" ; -- src=panlex
lin land_V2 = mkV2 "ชักนำ" ; ---- | mkV "ลงจอด" | mkV "แวะจอด" | mkV "แวะพัก" | mkV "แลนดิ้ง" | mkV "นำขึ้นฝั่้ง" | mkV "นำลงสู่พื้น" | mkV "มาถึงชายฝั่ง" | mkV "เกย" | mkV "บินลง" | mkV "ลงสู่" | mkV "ร่อนลง" | mkV "นําขึ้นบก" ; -- src=panlex
lin land_V = mkV "ชักนำ" | mkV "ลงจอด" | mkV "แวะจอด" | mkV "แวะพัก" | mkV "แลนดิ้ง" | mkV "นำขึ้นฝั่้ง" | mkV "นำลงสู่พื้น" | mkV "มาถึงชายฝั่ง" | mkV "เกย" | mkV "บินลง" | mkV "ลงสู่" | mkV "ร่อนลง" | mkV "นําขึ้นบก" ; -- src=panlex
lin frame_N = mkN "กาย" | mkN "กรอบ" | mkN "เฟรม" | mkN "แฟรม" | mkN "โครง" | mkN "สังขาร" | mkN "ร่างกาย" | mkN "พระวรกาย" | mkN "โครงกระดูก" | mkN "ร่างกายมนุษย์" | mkN "ระบบโครงกระดูก" | mkN "ร่างกายของมนุษย์" | mkN "ฉาก" | mkN "กรอบ" | mkN "ระบบ" | mkN "ร่าง" | mkN "โครง" | mkN "กรอบภาพ" | mkN "ร่างกาย" | mkN "ยกหนึ่ง ๆ" | mkN "รอบหนึ่ง" | mkN "กรอบประตู" | mkN "โครงสร้าง" | mkN "องค์ประกอบ" | mkN "กรอบหน้าต่าง" | mkN "สภาพของจิตใจ" | mkN "โครงสร้างพื้นฐาน" | mkN "โครงสร้างร่างกาย" | mkN "รอบในกีฬาโบว์ลิ่ง" | mkN "ภาพหนึ่งในฟิล์มภาพยนตร์" ; -- src=panlex
lin extension_N = mkN "การยืด" | mkN "การขยาย" | mkN "ส่วนปีก" | mkN "การขยายเวลา" | mkN "ความหมายตรง" | mkN "การเหยียดขาสูง" | mkN "โทรศัพท์พ่วงสาย" | mkN "ชื่อและนามสกุลของไฟล์" | mkN "การเพิ่ม" | mkN "การยืดออก" | mkN "การแผ่ออก" | mkN "การขยายออก" | mkN "การยืดขยาย" | mkN "การทําให้กว้าง" | mkN "สิ่งที่ขยายออก" ; -- src=panlex
lin mix_V2 = mkV2 "ผสม" ; ---- | mkV "มิกซ์" | mkV "รวมตัว" | mkV "ล้างไพ่" | mkV "ผสมเข้าด้วยกัน" | mkV "เปิดรับทุกชาติพันธุ์" | mkV "คน" | mkV "ผสม" | mkV "ปรุง" | mkV "ผสมกัน" | mkV "รวมกัน" | mkV "พบปะผู้คน" | mkV "เข้าสมาคม" | mkV "เข้าสังคม" | mkV "ทําให้รวมตัวกัน" ; -- src=panlex
lin mix_V = mkV "ผสม" | mkV "มิกซ์" | mkV "รวมตัว" | mkV "ล้างไพ่" | mkV "ผสมเข้าด้วยกัน" | mkV "เปิดรับทุกชาติพันธุ์" | mkV "คน" | mkV "ผสม" | mkV "ปรุง" | mkV "ผสมกัน" | mkV "รวมกัน" | mkV "พบปะผู้คน" | mkV "เข้าสมาคม" | mkV "เข้าสังคม" | mkV "ทําให้รวมตัวกัน" ; -- src=panlex
lin spokesman_N = mkN "โฆษกชาย" | mkN "โฆษก" | mkN "ผู้แถลง" | mkN "ผู้แถลงแทน" ; -- src=panlex
lin friendly_A = mkA "กรุณา" | mkA "เป็นมิตร" | mkA "เป็นกันเอง" | mkA "ให้ความสนับสนุน" | mkA "เหมือนเป็นเพื่อน" | mkA "ให้ความช่วยเหลือ" ; -- src=panlex
lin acknowledge_VS = variants{} ; -- 
lin acknowledge_V2 = variants{} ; -- 
lin register_V2 = mkV2 "อ่านค่า" ; ---- | mkV "จดบันทึก" | mkV "ทำบันทึก" | mkV "ลงบันทึก" | mkV "รับรู้ถึง" | mkV "เขียนบันทึก" | mkV "ลงทะเบียนใช้สิทธิเลือกตั้ง" | mkV "แสดง" | mkV "บันทึก" | mkV "ขึ้นบัญชี" | mkV "จดทะเบียน" | mkV "ลงทะเบียน" | mkV "ขึ้นทะเบียน" | mkV "ส่งจดหมายลงทะเบียน" ; -- src=panlex
lin register_V = mkV "อ่านค่า" | mkV "จดบันทึก" | mkV "ทำบันทึก" | mkV "ลงบันทึก" | mkV "รับรู้ถึง" | mkV "เขียนบันทึก" | mkV "ลงทะเบียนใช้สิทธิเลือกตั้ง" | mkV "แสดง" | mkV "บันทึก" | mkV "ขึ้นบัญชี" | mkV "จดทะเบียน" | mkV "ลงทะเบียน" | mkV "ขึ้นทะเบียน" | mkV "ส่งจดหมายลงทะเบียน" ; -- src=panlex
lin regime_N = variants{} ; -- 
lin regime_2_N = variants{} ; -- 
lin regime_1_N = variants{} ; -- 
lin fault_N = mkN "ข้อผิดพลาด" | mkN "ความบกพร่อง" | mkN "ความผิดพลาด" | mkN "การเสิร์ฟเสีย" | mkN "รอยเลื่อนของเปลือกโลก" | mkN "รอยแตก" | mkN "ความผิด" | mkN "รอยตําหนิ" | mkN "ข้อบกพร่อง" | mkN "ข้อผิดพลาด" | mkN "ข้อเสียหาย" | mkN "ความผิดพลาด" | mkN "การเสิร์ฟลูกออก" | mkN "ความคลาดเคลื่อน" | mkN "รอยเลื่อนของเปลือกโลก" | mkN "ชั้นหินที่หักหรือเคลื่อนลง" ; -- src=panlex
lin dispute_N = mkN "การอภิปราย" | mkN "การโต้เถียง" | mkN "การคัดค้าน" | mkN "การโต้แย้ง" | mkN "การโต้เถียง" | mkN "ความขัดแย้ง" | mkN "การไม่เห็นด้วย" ; -- src=panlex
lin grass_N = mkN "หญ้า" | {-pan-} mkN "เนื้อ" | mkN "เบาะแส" | mkN "หญ้าเลี้ยงสัตว์" | mkN "ตฤณ" | mkN "ทุ่งหญ้า" | mkN "สนามหญ้า" | mkN "บริเวณที่มีหญ้า" ; -- src=panlex
lin quietly_Adv = mkAdv "เบาๆ" | mkAdv "อย่างเงียบๆ" | mkAdv "อย่างเงียบสงบ" | mkAdv "อย่างเบาๆ" | mkAdv "อย่างค่อยๆ" | mkAdv "อย่างเงียบ" | mkAdv "อย่างเงียบๆ" ; -- src=panlex
lin decline_N = mkN "การตก" | mkN "การลด" | mkN "การตกลง" | mkN "ความถดถอย" | mkN "ความเสื่อมคุณภาพ" | mkN "ภาวะตกต่ำทางการเงิน" | mkN "ทางลาด" | mkN "การถดถอย" | mkN "ความตกต่ํา" | mkN "ความเสื่อม" | mkN "ภาวะตกต่ํา" | mkN "การเอียงลาด" ; -- src=panlex
lin dismiss_V2 = variants{} ; -- 
lin delivery_N = mkN "การส่ง" | mkN "การโอน" | mkN "การคลอดลูก" | mkN "การเกิดลูก" | mkN "วิธีการพูด" | mkN "การขว้างลูก" | mkN "การคลอดบุตร" | mkN "การแคล้วคลาด" | mkN "การขว้างลูกเบสบอล" | mkN "การส่ง" | mkN "การโยน" | mkN "การกล่าว" | mkN "การนําส่ง" | mkN "การส่งสาร" | mkN "การคลอดลูก" | mkN "การส่งสินค้า" | mkN "การกล่าวสุนทรพจน์" ; -- src=panlex
lin complain_VS = mmkVS "บ่น" ; ---- | mkV "พร่ำบ่น" | mkV "คำร้องเรียน" | mkV "บ่น" | mkV "ร้องทุกข์" ; -- src=panlex
lin complain_V = mkV "บ่น" | mkV "พร่ำบ่น" | mkV "คำร้องเรียน" | mkV "บ่น" | mkV "ร้องทุกข์" ; -- src=panlex
lin conservative_N = variants{} ; -- 
lin shift_V2 = mkV2 "เฉ" ; ---- | mkV "ย้าย" | mkV "ชิฟต์" | mkV "เขยิบ" | mkV "กระเถิบ" | mkV "เปลี่ยน" | mkV "สับเปลี่ยน" | mkV "เปลี่ยนเกียร์" | mkV "จากที่หนึ่งไปอีกที่หนึ่ง" | mkV "เคลื่อน" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "เคลื่อนย้าย" ; -- src=panlex
lin shift_V = mkV "เฉ" | mkV "ย้าย" | mkV "ชิฟต์" | mkV "เขยิบ" | mkV "กระเถิบ" | mkV "เปลี่ยน" | mkV "สับเปลี่ยน" | mkV "เปลี่ยนเกียร์" | mkV "จากที่หนึ่งไปอีกที่หนึ่ง" | mkV "เคลื่อน" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "เคลื่อนย้าย" ; -- src=panlex
lin port_N = mkN "ท่า" | mkN "พอร์ต" | mkN "ช่องยิง" | mkN "ไวนพอร์ต" | mkN "ไวน์พอร์ต" | mkN "อินเตอร์เฟซ" | mkN "จุดเชื่อมต่อ" | mkN "กราบซ้ายของเรือ" | mkN "กราบเรือทางซ้าย" | mkN "ท่า" | mkN "ท่าด่าน" | mkN "ท่าเรือ" | mkN "เมืองท่า" | mkN "ท่าอากาศยาน" | mkN "เหล้าองุ่นแดง" | mkN "ช่องบนกําแพงหรือเรือสําหรับวางปืน" ; -- src=panlex
lin beach_N = mkN "หาด" | mkN "ชายหาด" | mkN "ริมหาด" | mkN "ชายทะเล" | mkN "ริมทะเล" | mkN "ชายหาด" | mkN "ชายทะเล" | mkN "หาดทราย" ; -- src=panlex
lin string_N = mkN "พวง" | mkN "สร้อย" | mkN "สายขึง" | mkN "สายรูด" | mkN "สายสร้อย" | mkN "เชือกขึง" | mkN "เชือกรูด" | mkN "สายอักขระ" | mkN "คอสมิกสตริง" | mkN "เครื่องสายประเภทสี" | mkN "ทาง" | mkN "แถว" | mkN "เชือก" | mkN "สายผูก" | mkN "สายป่าน" | mkN "สายร้อย" | mkN "สายดนตรี" | mkN "สายสร้อย" | mkN "สายประคําคอ" | mkN "ฝูงสัตว์ที่มีเจ้าของเป็นคนเดียวกัน" | mkN "การเรียงต่อเนื่องของเหตุการณ์หรือสิ่งต่างๆ" ; -- src=panlex
lin depth_N = mkN "ความลึก" | mkN "ความลึกสุด" | mkN "ความลึกซึ้ง" | mkN "ระดับความลึก" | mkN "ความตกต่ำทางศีลธรรม" | mkN "ความลึก" | mkN "ส่วนลึก" | mkN "เสียงต่ํา" | mkN "ความซึมซาบ" | mkN "ความรุนแรง" | mkN "ความซับซ้อน" | mkN "ความลึกซึ้ง" | mkN "ความเข้มข้น" | mkN "ความเข้มของสี" | mkN "ความคิดลึกซึ้ง" | mkN "ระดับเสียงต่ํา" | mkN "ส่วนที่ลึกที่สุด" | mkN "ความรู้ความสามารถ" | mkN "ความรู้สึกซาบซึ้ง" | mkN "ความรู้สึกสุดซึ้ง" | mkN "ส่วนที่รุนแรงที่สุด" | mkN "ความต่ําของระดับเสียง" ; -- src=panlex
lin unusual_A = mkA "ไม่ธรรมดา" | mkA "พิเศษ" | mkA "ประหลาด" | mkA "ผิดปกติ" | mkA "แปลกปลอม" | mkA "ผิดธรรมดา" | mkA "ไม่ธรรมดา" | mkA "ผิดจากธรรมดา" | mkA "เป็นข้อยกเว้น" ; -- src=panlex
lin travel_N = mkN "การเดินทาง" | mkN "การเคลื่อนที่ด้วยตัวเอง" | mkN "การเดินทาง" | mkN "การท่องเที่ยว" | mkN "การเคลื่อนที่" | mkN "การเคลื่อนไหว" | mkN "การเคลื่อนย้าย" ; -- src=panlex
lin pilot_N = mkN "น.บ." | mkN "กันชน" | mkN "นักบิน" | mkN "ไฟชนวน" | mkN "แม่พิมพ์" | mkN "คนขับเครื่องบิน" | mkN "กันชน" | mkN "ตัวนํา" | mkN "ต้นแบบ" | mkN "นักบิน" | mkN "การทดลอง" | mkN "การทดสอบ" | mkN "คนนําทาง" | mkN "ไฟสัญญาณ" | mkN "ผู้นําทาง" | mkN "มัคคุเทศก์" | mkN "รายการแนะนํา" | mkN "เครื่องนําวิถี" | mkN "ผู้ที่คอยชี้แนะ" | mkN "เจ้าหน้าที่ขับเครื่องบิน" ; -- src=panlex
lin obligation_N = mkN "ภาระ" | mkN "พันธกรณี" | mkN "ข้อผูกพัน" | mkN "ข้อผูกมัด" | mkN "ตราสารหนี้" | mkN "การเป็นหนี้" | mkN "การทำหน้าที่" | mkN "หนี้" | mkN "พันธะ" | mkN "สัญญา" | mkN "เกณฑ์" | mkN "บุญคุณ" | mkN "หน้าที่" | mkN "ตั๋วเงิน" | mkN "พันธบัตร" | mkN "การบังคับ" | mkN "ข้อผูกพัน" | mkN "ข้อผูกมัด" | mkN "ความจําเป็น" | mkN "ภาระหน้าที่" | mkN "ภาวะหน้าที่" | mkN "สัญญาผูกมัด" | mkN "ความรับผิดชอบ" | mkN "เงินชําระหนี้" | mkN "ความรู้สึกเป็นหนี้บุญคุณ" ; -- src=panlex
lin gene_N = mkN "ยีน" | mkN "ยีน" | mkN "พันธุ์" | mkN "หน่วยทางพันธุกรรมในโครโมโซม" | mkN "ลักษณะที่ถ่ายทอดทางพันธุกรรม" ; -- src=panlex
lin yellow_A = mkA "เหลือง" | {-pan-} mkA "ขี้ตกใจ" | mkA "ขี้ตื่น" | mkA "ขวัญหนีดีฝ่อ" | mkA "เก่าจนเหลือง" | mkA "เก่า" | mkA "ตาขาว" | mkA "ไข่แดง" | mkA "ขี้ขลาด" | mkA "คร่ําครึ" | mkA "สีเหลือง" | mkA "ซีดเหลือง" | mkA "ไว้ใจไม่ได้" | mkA "กลายเป็นสีเหลือง" | mkA "เกี่ยวกับชนชาติผิวเหลือง" | mkA "เกี่ยวกับชนชาติมองโกลอยด์" | mkA "เป็นสีเหลืองคล้ายเนยหรือมะนาวสุก" ; -- src=panlex ---- (thword "สี" "เหลือง") ;
lin republic_N = mkN "ประชาธิปไตย" | mkN "ระบอบประชาธิปไตย" | mkN "สาธารณรัฐ" ; -- src=panlex
lin shadow_N = mkN "เงา" | mkN "ภูตผี" | mkN "ที่มืด" | mkN "ภูตผีปีศาจ" | mkN "คนลอบติดตาม" | mkN "ผู้ลอบติดตาม" | mkN "ผู้เป็นเงาตามตัว" | mkN "ร่ม" | mkN "เงา" | mkN "ฉายา" | mkN "แลเงา" | mkN "บังร่ม" | mkN "บังแดด" | mkN "ร่มเงา" | mkN "เงาร่ม" | mkN "ป้องกัน" | mkN "อําพราง" | mkN "ระบายเงา" | mkN "การคุกคาม" | mkN "การปิดบัง" | mkN "ความทุกข์" | mkN "ที่หลบภัย" | mkN "ทําให้สลัว" | mkN "บอกเป็นนัย" | mkN "ความอําพราง" | mkN "ให้ที่หลบภัย" | mkN "ความไม่ไว้วางใจ" | mkN "ผู้ติดตามเฝ้าดู" | mkN "ระยะเวลาแห่งความน่าสงสัย" ; -- src=panlex
lin dear_A = mkA "ที่รัก" | mkA "แพง" | mkA "มีค่า" | mkA "ขุ่นใจ" | mkA "ที่รัก" | mkA "น่ารัก" | mkA "มีราคา" | mkA "ทุกข์ใจ" | mkA "มีราคาสูง" | mkA "บุคคลที่ดี" | mkA "เป็นที่รัก" | mkA "มีมูลค่าสูง" | mkA "ความโศกเศร้า เช่น อนิจจา! ตายจริง! โอ้!" | mkA "ซึ่งเป็นสุดที่รัก" | mkA "ซึ่งเป็นที่รักยิ่ง" | mkA "มีเกียรติอย่างยิ่ง" ; -- src=panlex
lin analyse_V2 = variants{} ; -- 
lin anywhere_Adv = mkAdv "ทุกแห่ง" | mkAdv "ที่ไหนก็ตาม" | mkAdv "ไหน ๆ" | mkAdv "ทุกแห่ง" | mkAdv "ที่ใดก็ตาม" | mkAdv "ที่ไหนก็ตาม" | mkAdv "ไม่ว่าที่ใด" ; -- src=panlex
lin average_N = mkN "เฉลี่ย" | mkN "ค่าเฉลี่ย" | mkN "ค่าเฉลี่ย" | mkN "อัตราเฉลี่ย" | mkN "คิดถัวเฉลี่ย" ; -- src=panlex
lin phrase_N = mkN "วลี" | mkN "เฟรส" | mkN "วลี" | mkN "คําคม" | mkN "ประจบ" | mkN "โวหาร" | mkN "คําพูด" | mkN "สํานวน" | mkN "ถ้อยคํา" | mkN "กลุ่มคํา" | mkN "คําคุยโว" | mkN "คําพังเพย" | mkN "เนื้อเพลง" | mkN "แสดงโวหาร" | mkN "กลุ่มคําศัพท์" | mkN "การใช้ถ้อยคํา" ; -- src=panlex
lin long_term_A = variants{} ; -- 
lin crew_N = mkN "แก๊ง" | mkN "ฝีพาย" | mkN "ทีมงาน" | mkN "ลูกเรือ" | mkN "เพื่อนฝูง" | mkN "กลุ่มคนงาน" | mkN "กลุ่มคน" | mkN "ลูกเรือ" | mkN "พวกลูกเรือ" | mkN "กลุ่มเพื่อน" | mkN "บรรดาเพื่อนร่วมงาน" | mkN "กลุ่มคนที่ทํางานร่วมกัน" | mkN "กลุ่มคนที่มีความสัมพันธ์กัน" ; -- src=panlex
lin lucky_A = mkA "โชคดี" | mkA "แห่งโชค" | mkA "มีโชค" | mkA "โชคดี" | mkA "นําโชค" | mkA "เคราะห์ดี" | mkA "ที่นําเคราะห์ดีมาให้" ; -- src=panlex
lin restore_V2 = variants{} ; -- 
lin convince_V2V = variants{} ; -- 
lin convince_V2 = variants{} ; -- 
lin coast_N = mkN "การสไลด์" | mkN "การเลื่อน" | mkN "ชายฝั่งทะเล" | mkN "ทางลาดเอียง" | mkN "ชายหาด" | mkN "ชายฝั่ง" | mkN "ริมฝั่ง" | mkN "ฝั่งทะเล" ; -- src=panlex
lin engineer_N = mkN "วิศวกร" | mkN "พนักงานเดินรถ" | mkN "พนักงานขับรถไฟ" | mkN "นักวิทยาศาสตร์ประยุกต์" | mkN "รถไฟ" | mkN "คนขับ" | mkN "สร้าง" | mkN "ควบคุม" | mkN "จัดการ" | mkN "วิศวกร" | mkN "นายช่าง" | mkN "ทหารช่าง" | mkN "คนขับรถไฟ" | mkN "ผู้จัดการ" | mkN "ผู้สร้างเครื่องจักร" ; -- src=panlex
lin heavily_Adv = mkAdv "อย่างหนัก" | mkAdv "อย่างหนักหน่วง" | mkAdv "อย่างไม่ยับยั้ง" | mkAdv "มากมาย" | mkAdv "รุนแรง" | mkAdv "งุ่มง่าม" | mkAdv "อย่างหนัก" ; -- src=panlex
lin extensive_A = mkA "ห่าง ๆ กัน" | mkA "กว้าง" | mkA "ครอบคลุม" | mkA "ถ้วนทั่ว" | mkA "แพร่หลาย" | mkA "กว้างขวาง" | mkA "ครอบคลุมเป็นบริเวณกว้าง" ; -- src=panlex
lin glad_A = mkA "ซึ่งยินดี" | mkA "ที่น่ายินดี" | mkA "ดีใจ" | mkA "พอใจ" | mkA "ยินดี" | mkA "สุขใจ" | mkA "ปิติยินดี" | mkA "ทําให้ดีใจ" ; -- src=panlex
lin charity_N = mkN "การกุศล" | mkN "มูลนิธิ" | mkN "ความใจบุญสุนทาน" | mkN "ต้นกรีกวาลีเรียน" | mkN "ต้นจาค็อบแลดเดอร์" | mkN "งานบุญ" | mkN "การกุศล" | mkN "งานกุศล" | mkN "มูลนิธิ" | mkN "กิจการกุศล" | mkN "เงินบริจาค" | mkN "การทําการกุศล" | mkN "การทําบุญสุนทาน" | mkN "ความโอบอ้อมอารี" | mkN "ความใจบุญสุนทาน" | mkN "สิ่งของที่บริจาค" | mkN "ความเอื้อเฟื้อเผื่อแผ่" ; -- src=panlex
lin oppose_V2 = mkV2 "ตอบโต้" ; ---- | mkV "คัดค้าน" | mkV "ต่อต้าน" | mkV "โต้กลับ" | mkV "ถ่วงน้ำหนัก" | mkV "คัดค้าน" | mkV "ต่อต้าน" | mkV "ไม่ยอมรับ" | mkV "ัไม่ยอมรับ" | mkV "เป็นปรปักษ์" | mkV "ไม่เห็นด้วย" ; -- src=panlex
lin oppose_V = mkV "ตอบโต้" | mkV "คัดค้าน" | mkV "ต่อต้าน" | mkV "โต้กลับ" | mkV "ถ่วงน้ำหนัก" | mkV "คัดค้าน" | mkV "ต่อต้าน" | mkV "ไม่ยอมรับ" | mkV "ัไม่ยอมรับ" | mkV "เป็นปรปักษ์" | mkV "ไม่เห็นด้วย" ; -- src=panlex
lin defend_V2 = variants{} ; -- 
lin alter_V2 = mkV2 "แทรกคำ" ; ---- | mkV "เปลี่ยน" | mkV "ตัดรังไข่" | mkV "เปลี่ยนแปลง" | mkV "ทำให้เปลี่ยน" | mkV "ทำให้เปลี่ยนแปลง" | mkV "ตอน" | mkV "แปลง" | mkV "ทําหมัน" | mkV "เปลี่ยน" | mkV "ปรับเปลี่ยน" | mkV "เย็บซ่อมเสื้อผ้าให้พอดี" ; -- src=panlex
lin alter_V = mkV "แทรกคำ" | mkV "เปลี่ยน" | mkV "ตัดรังไข่" | mkV "เปลี่ยนแปลง" | mkV "ทำให้เปลี่ยน" | mkV "ทำให้เปลี่ยนแปลง" | mkV "ตอน" | mkV "แปลง" | mkV "ทําหมัน" | mkV "เปลี่ยน" | mkV "ปรับเปลี่ยน" | mkV "เย็บซ่อมเสื้อผ้าให้พอดี" ; -- src=panlex
lin warning_N = mkN "คำเตือน" | mkN "คำแนะนำ" | mkN "คําเตือน" | mkN "สัญญาณเตือนถึงเหตุร้าย" ; -- src=panlex
lin arrest_V2 = variants{} ; -- 
lin framework_N = mkN "เฟรม" | mkN "โมเดล" | mkN "แบบจำลอง" | mkN "เฟรมเวิร์ก" | mkN "กรอบ" | mkN "วงกบ" | mkN "เค้าโครง" | mkN "โครงร่าง" | mkN "โครงสร้าง" | mkN "ขอบข่ายงาน" | mkN "โครงประกอบ" | mkN "โครงร่างงาน" ; -- src=panlex
lin approval_N = mkN "ฉันทามติ" | mkN "การยินยอม" | mkN "การอนุมัติ" | mkN "การเห็นชอบ" | mkN "การเห็นด้วย" | mkN "ความเห็นชอบ" | mkN "ความเห็นพ้อง" | mkN "การอนุญาต" | mkN "การอนุมัติ" | mkN "การเห็นด้วย" | mkN "ความเห็นพ้อง" | mkN "การแสดงความพอใจ" | mkN "ความเห็นชอบด้วย" | mkN "ความยินยอมพร้อมใจ" ; -- src=panlex
lin bother_VV = mkVV "ยั่ว" ; ---- | mkV "กวนใจ" | mkV "รบกวน" | mkV "ก่อปัญหา" | mkV "กวนประสาท" | mkV "ซึ่งสับสน" | mkV "ทำให้ไม่สะดวก" | mkV "ทําให้ยุ่งยาก" | mkV "ทําให้เกิดปัญหา" | mkV "ทําให้ตัวเองยุ่งยาก" ; -- src=panlex
lin bother_V2V = mmkV2V "ยั่ว" ; ---- | mkV "กวนใจ" | mkV "รบกวน" | mkV "ก่อปัญหา" | mkV "กวนประสาท" | mkV "ซึ่งสับสน" | mkV "ทำให้ไม่สะดวก" | mkV "ทําให้ยุ่งยาก" | mkV "ทําให้เกิดปัญหา" | mkV "ทําให้ตัวเองยุ่งยาก" ; -- src=panlex
lin bother_V2 = mkV2 "ยั่ว" ; ---- | mkV "กวนใจ" | mkV "รบกวน" | mkV "ก่อปัญหา" | mkV "กวนประสาท" | mkV "ซึ่งสับสน" | mkV "ทำให้ไม่สะดวก" | mkV "ทําให้ยุ่งยาก" | mkV "ทําให้เกิดปัญหา" | mkV "ทําให้ตัวเองยุ่งยาก" ; -- src=panlex
lin bother_V = mkV "ยั่ว" | mkV "กวนใจ" | mkV "รบกวน" | mkV "ก่อปัญหา" | mkV "กวนประสาท" | mkV "ซึ่งสับสน" | mkV "ทำให้ไม่สะดวก" | mkV "ทําให้ยุ่งยาก" | mkV "ทําให้เกิดปัญหา" | mkV "ทําให้ตัวเองยุ่งยาก" ; -- src=panlex
lin novel_N = mkN "นิยาย" | mkN "นวนิยาย" | mkN "หนังสือนิยาย" | mkN "หนังสือนวนิยาย" | mkN "นิยาย" | mkN "นวนิยาย" | mkN "กฎหมายเพิ่มเติม" | mkN "หนังสืออ่านเล่น" ; -- src=panlex
lin accuse_V2 = variants{} ; -- 
lin surprised_A = mkA "งงงัน" | mkA "แปลกใจ" | mkA "ตกตะลึง" | mkA "ประหลาดใจ" ; -- src=panlex
lin currency_N = mkN "เงินตรา" | mkN "ปัจจุบัน" | mkN "การแพร่หลาย" | mkN "เงิน" | mkN "กระแสลม" | mkN "เงินตรา" | mkN "กระแสน้ํา" | mkN "การแพร่หลาย" | mkN "การหมุนเวียน" | mkN "การใช้กันทั่วไป" | mkN "ช่วงเวลาที่แพร่หลาย" | mkN "ช่วงระยะเวลาที่แพร่หลาย" ; -- src=panlex
lin restrict_V2 = mkV2 "จำกัด" ; ---- | mkV "กีดขวาง" | mkV "ตีวง" | mkV "จํากัด" ; -- src=panlex
lin restrict_V = mkV "จำกัด" | mkV "กีดขวาง" | mkV "ตีวง" | mkV "จํากัด" ; -- src=panlex
lin possess_V2 = variants{} ; -- 
lin moral_A = mkA "ทางศีลธรรม" | mkA "บริสุทธิ์" | mkA "ทางศีลธรรม" | mkA "หลักธรรมจริยา" | mkA "เกี่ยวกับจรรยา" | mkA "เกี่ยวกับจิตใจ" | mkA "เกี่ยวกับศีลธรรม" | mkA "เกี่ยวกับความรู้สึกผิดชอบ" | mkA "เกี่ยวกับความรู้สึกผิดชอบชั่วดี" ; -- src=panlex
lin protein_N = mkN "โปรตีน" | mkN "โปรตีน" ; -- src=panlex
lin distinguish_V2 = mkV2 "แยก" ; ---- | mkV "จำแนก" | mkV "จำได้" | mkV "แยกแยะ" | mkV "แบ่งแยก" | mkV "จําแนกความแตกต่าง" | mkV "ทําให้เห็นความแตกต่าง" ; -- src=panlex
lin distinguish_V = mkV "แยก" | mkV "จำแนก" | mkV "จำได้" | mkV "แยกแยะ" | mkV "แบ่งแยก" | mkV "จําแนกความแตกต่าง" | mkV "ทําให้เห็นความแตกต่าง" ; -- src=panlex
lin gently_Adv = mkAdv "เบาๆ" | mkAdv "อย่างอ่อนโยน" | mkAdv "นุ่มนวล" | mkAdv "อ่อนโยน" | mkAdv "ค่อยเป็นค่อยไป" ; -- src=panlex
lin reckon_VS = variants{} ; -- 
lin incorporate_V2 = variants{} ; -- 
lin proceed_V = mkV "ยังคง" | mkV "ดำเนิน" | mkV "ดำเนินการ" | mkV "ไปข้างหน้า" | mkV "ดำเนินการสนทนา" | mkV "ไป" | mkV "ลงมือ" | mkV "กระทําการ" | mkV "ดําเนินการ" | mkV "เดินเรื่อง" | mkV "ติดตามเรื่อง" | mkV "เดินไปข้างหน้า" | mkV "พูดต่อหลังจากถูกขัดจังหวะ" ; -- src=panlex
lin assist_V2 = mkV2 "ช่วย" ; ---- | mkV "รับใช้" | mkV "ช่วยเหลือ" | mkV "เป็นผู้ช่วย" | mkV "ช่วย" | mkV "ช่วยเหลือ" ; -- src=panlex
lin assist_V = mkV "ช่วย" | mkV "รับใช้" | mkV "ช่วยเหลือ" | mkV "เป็นผู้ช่วย" | mkV "ช่วย" | mkV "ช่วยเหลือ" ; -- src=panlex
lin sure_Adv = mkAdv "อย่างแน่นอน" | mkAdv "มั่นคง" | mkAdv "มั่นใจ" | mkAdv "ยืนยัน" | mkAdv "แน่นอน" | mkAdv "" | mkAdv "ไว้ใจได้" | mkAdv "เชื่อมั่น" | mkAdv "ไม่มีปัญหา" | mkAdv "อย่างแน่นอน" | mkAdv "ไม่ต้องสงสัย" | mkAdv "ไม่เปลี่ยนแปลง" | mkAdv "อย่างไม่ต้องสงสัย" ; -- src=panlex
lin stress_VS = variants{} ; -- 
lin stress_V2 = variants{} ; -- 
lin justify_VV = variants{} ; -- 
lin justify_V2 = variants{} ; -- 
lin behalf_N = mkN "ตัวแทน" | mkN "ประโยชน์" | mkN "ในนามของ" ; -- src=panlex
lin councillor_N = mkN "ที่ปรึกษา" | mkN "ผู้แนะนํา" | mkN "สภาเทศบาล" | mkN "สมาชิกสภา" | mkN "สมาชิกสภาท้องถิ่น" ; -- src=panlex
lin setting_N = mkN "ฉาก" | mkN "สถานการณ์แวดล้อม" | mkN "เหตุการณ์แวดล้อม" | mkN "ฉาก" | mkN "ทิวทัศน์" | mkN "ดนตรีประกอบ" | mkN "สภาพแวดล้อม" | mkN "สถานที่ติดตั้ง" ; -- src=panlex
lin command_N = variants{} ; -- 
lin command_2_N = variants{} ; -- 
lin command_1_N = variants{} ; -- 
lin maintenance_N = mkN "ค่าเลี้ยงดู" | mkN "การดูแลรักษา" | mkN "การบำรุงรักษา" | mkN "การผดุง" | mkN "วิถีชีวิต" | mkN "การผดุงไว้" | mkN "การธํารงไว้" | mkN "การรักษาไว้" | mkN "การดูแลรักษา" | mkN "การรักษาสภาพ" | mkN "การทะนุบํารุง" | mkN "การดําเนินชีวิต" | mkN "การดําเนินต่อไป" ; -- src=panlex
lin stair_N = mkN "ขั้นบันได" | mkN "บันได" | mkN "ขั้นบันได" | mkN "ทุ่นหรือแพลอยของท่าเรือ" ; -- src=panlex
lin poem_N = mkN "บทกวี" | mkN "โคลงกลอน" | mkN "กลอน" | mkN "โคลง" | mkN "กาพย์" | mkN "ฉันท์" | mkN "บทกวี" | mkN "คํากลอน" | mkN "ร้อยกรอง" | mkN "กวีนิพนธ์" | mkN "บทประพันธ์ร้อยแก้ว" ; -- src=panlex
lin chest_N = mkN "อก" | mkN "หีบ" | mkN "ทรวงอก" | mkN "หน้าอก" | mkN "พระทรวง" | mkN "พระอุระ" | mkN "ตู้มีลิ้นชัก" | mkN "ลิ้นชักใส่เสื้อผ้า" | mkN "ตู้ลิ้นชักใส่เสื้อผ้า" | mkN "อก" | mkN "ลัง" | mkN "หีบ" | mkN "คลัง" | mkN "กล่อง" | mkN "รอบอก" | mkN "ทรวงอก" | mkN "หน้าอก" | mkN "เต้านม" | mkN "กรมคลัง" | mkN "เงินทุน" | mkN "ลังขนาดใหญ่" | mkN "เงินแผ่นดิน" | mkN "กล่องขนาดใหญ่" | mkN "กระทรวงการคลัง" | mkN "สิ่งที่เก็บอยู่ในหีบ" | mkN "ชั้นที่มีลิ้นชักใส่เสื้อผ้า" ; -- src=panlex
lin like_Adv = variants{}; -- mkPrep "เช่น" | mkPrep "ดังเช่น" | mkPrep "เหมือนกับ" | mkPrep "คล้ายกันกับ" | mkPrep "ลักษณะพิเศษ" | mkPrep "ตัวอย่างเช่น" | mkPrep "เหมือนกันกับ" | mkPrep "เป็นลักษณะเฉพาะ" ; -- src=panlex
lin secret_N = mkN "ปริศนา" | mkN "ความลับ" | mkN "สิ่งลึกลับ" | mkN "สิ่งที่เป็นปริศนา" | mkN "ความใน" | mkN "ความลับ" | mkN "ตําราลับ" | mkN "เคล็ดลับ" | mkN "กลวิธีลับ" ; -- src=panlex
lin restriction_N = mkN "การกําหนด" | mkN "การควบคุม" | mkN "การจํากัด" | mkN "การบังคับ" | mkN "การยับยั้ง" | mkN "การจํากัดวง" | mkN "การกําหนดขอบเขต" ; -- src=panlex
lin efficient_A = mkA "ซึ่งมีประสิทธิภาพ" | mkA "มีผลต่อ" | mkA "ที่ใช้เวลา" | mkA "มีความสามารถ" | mkA "ซึ่งมีประสิทธิภาพ" | mkA "ซึ่งรับภาระได้อย่างสบาย" | mkA "พลังงานหรือเงินน้อยแต่มีประสิทธิภาพมาก" ; -- src=panlex
lin suspect_VS = variants{} ; -- 
lin suspect_V2 = variants{} ; -- 
lin hat_N = mkN "หมวก" "ใบ" | {-pan-} mkN "หมวก" | mkN "หมวกปีก" | mkN "หมวก" | mkN "บทบาท" | mkN "ตําแหน่ง" | mkN "หมวกพระราชาคณะ" ; -- src=panlex
lin tough_A = mkA "ยาก" | mkA "ทนทาน" | mkA "บึกบึน" | mkA "เหนียว" | mkA "ใจแข็ง" | mkA "แข็งแรง" | mkA "ดื้อรั้น" | mkA "ที่ทนทาน" | mkA "ไม่เปราะ" | mkA "ที่น่ากลัว" | mkA "ที่เคี้ยวยาก" | mkA "ที่ใช้ได้นาน" | mkA "ที่ลงโทษร้ายแรง" | mkA "ที่มีพฤติกรรมน่ากลัว" ; -- src=panlex
lin firmly_Adv = variants{} ; -- 
lin willing_A = mkA "ยินดี" | mkA "ตั้งใจ" | mkA "เต็มใจ" | mkA "มีเจตนา" | mkA "สมัครใจ" | mkA "ซึ่งยินดี" | mkA "ซึ่งสมัครใจ" | mkA "ซึ่งมีความตั้งใจ" | mkA "ซึ่งเต็มอกเต็มใจ" ; -- src=panlex
lin healthy_A = mkA "ที่สุขภาพดี" | mkA "แข็งแรง" | mkA "มีสุขภาพดี" | mkA "ซึ่งสมบูรณ์" | mkA "ซึ่งแข็งแรง" | mkA "ซึ่งมีสุขภาพดี" | mkA "ซึ่งดีต่อสุขภาพ" | mkA "ซึ่งมีพลานามัยดี" | mkA "ที่มีสุขภาพสมบูรณ์" | mkA "ซึ่งมีประโยชน์ต่อสุขภาพ" | mkA "ที่เป็นประโยชน์ต่อร่างกาย" ; -- src=panlex
lin focus_N = mkN "โฟกัส" | mkN "การจดจ่อ" | mkN "การโฟกัส" | mkN "จุดโฟกัส" | mkN "การเพ่งสมาธิ" | mkN "การเพ่งความสนใจ" | mkN "หัวใจ" | mkN "จุดสนใจ" | mkN "จุดหลัก" | mkN "จุดโฟกัส" | mkN "จุดรวมแสง" | mkN "จุดสําคัญ" | mkN "จุดศูนย์รวม" | mkN "จุดรวมแสงจากเลนส์" ; -- src=panlex
lin construct_V2 = variants{} ; -- 
lin occasionally_Adv = variants{} ; -- 
lin mode_N = mkN "มาลา" | mkN "โหมด" | mkN "ฐานนิยม" | mkN "แบบอย่าง" | mkN "แบบ" | mkN "หนทาง" | mkN "รูปแบบ" | mkN "แฟชั่น" | mkN "วิถีทาง" | mkN "วิธีการ" | mkN "แบบนิยม" | mkN "ตัวอย่าง" | mkN "สมัยนิยม" | mkN "ลักษณะการกระทํา" ; -- src=panlex
lin saving_N = mkN "การประหยัด" | mkN "การอนุรักษ์" | mkN "การสงวนรักษา" | mkN "การแคล้วคลาด" | mkN "เงินออม" | mkN "การช่วยชีวิต" | mkN "การช่วยเหลือ" | mkN "สิ่งที่สงวนไว้" ; -- src=panlex
lin comfortable_A = mkA "เพียงพอ" | mkA "มั่งคั่ง" | mkA "อบอุ่นใจ" | mkA "สะดวกสบาย" | mkA "สบาย" | mkA "ผาสุก" | mkA "สุขใจ" | mkA "สุขกาย" | mkA "กว้างพอ" | mkA "พอเพียง" | mkA "ร่ํารวย" | mkA "มั่งคั่ง" | mkA "อบอุ่นใจ" | mkA "กว้างขวาง" | mkA "กว้างใหญ่" | mkA "มีเงินมาก" | mkA "สะดวกสบาย" | mkA "สุขสบายใจ" | mkA "มีอันจะกิน" ; -- src=panlex
lin camp_N = mkN "ค่าย" | mkN "หมู่" | mkN "กลุ่ม" | mkN "แคมป์" | mkN "ค่ายพัก" | mkN "กลุ่มภายใน" | mkN "ค่ายกักกัน" | mkN "ค่ายพักแรม" | mkN "ค่ายฤดูร้อน" | mkN "ค่ายผู้ลี้ภัย" | mkN "กลุ่มผลประโยชน์ร่วม" | mkN "ค่าย" | mkN "ค่ายพัก" | mkN "ที่พักชั่วคราว" ; -- src=panlex
lin trade_V2 = mkV2 "ขาย" ; ---- | mkV "ค้า" | mkV "เทรด" | mkV "ค้าขาย" | mkV "ทำธุรกิจ" | mkV "ค้าขาย" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "นําของเก่าไปแลก" | mkV "ทําการตกลงซื้อขาย" ; -- src=panlex
lin trade_V = mkV "ขาย" | mkV "ค้า" | mkV "เทรด" | mkV "ค้าขาย" | mkV "ทำธุรกิจ" | mkV "ค้าขาย" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "นําของเก่าไปแลก" | mkV "ทําการตกลงซื้อขาย" ; -- src=panlex
lin export_N = mkN "ของส่งออก" | mkN "สินค้าส่งออก" | mkN "ของเอ็กซ์พอร์ต" | mkN "สินค้าเอ็กซ์พอร์ต" | mkN "การส่งสินค้าออกไปต่างประเทศ" ; -- src=panlex
lin wake_V2 = mkV2 "ตื่น" ; ---- | mkV "ปลุก" | mkV "ตื่นตัว" | mkV "ลุกขึ้น" | mkV "ปลุกเร้า" | mkV "ทำให้ตื่น" | mkV "รู้สึกตัว" | mkV "ทำให้รับรู้" | mkV "รับรู้" | mkV "ตื่นตัว" | mkV "ตื่นนอน" | mkV "ทําให้ตื่น" | mkV "ปลุกให้ตื่น" | mkV "ทําให้รับรู้" | mkV "ทําให้ตื่นตัว" | mkV "เฝ้าศพก่อนฝังหรือทําพิธี" ; -- src=panlex
lin wake_V = mkV "ตื่น" | mkV "ปลุก" | mkV "ตื่นตัว" | mkV "ลุกขึ้น" | mkV "ปลุกเร้า" | mkV "ทำให้ตื่น" | mkV "รู้สึกตัว" | mkV "ทำให้รับรู้" | mkV "รับรู้" | mkV "ตื่นตัว" | mkV "ตื่นนอน" | mkV "ทําให้ตื่น" | mkV "ปลุกให้ตื่น" | mkV "ทําให้รับรู้" | mkV "ทําให้ตื่นตัว" | mkV "เฝ้าศพก่อนฝังหรือทําพิธี" ; -- src=panlex
lin partnership_N = mkN "ห้างหุ้นส่วน" | mkN "ความเป็นหุ้นส่วน" | mkN "พันธมิตร" | mkN "ห้างหุ้นส่วน" | mkN "ห้างหุ้นส่วนจํากัด" ; -- src=panlex
lin daily_A = mkA "ลำลอง" | mkA "ในตอนกลางวัน" | mkA "ทุกวัน" | mkA "รายวัน" | mkA "แต่ละวัน" | mkA "ประจําวัน" ; -- src=panlex
lin abroad_Adv = mkAdv "ไกล" | mkAdv "ต่างประเทศ" | mkAdv "ไกลบ้านไกลช่อง" | mkAdv "ข้ามน้ำข้ามทะเล" | mkAdv "แพร่" | mkAdv "พิศวง" | mkAdv "ไปทั่ว" | mkAdv "ข้างนอก" | mkAdv "แพร่หลาย" | mkAdv "กว้างขวาง" | mkAdv "ในต่างแดน" | mkAdv "ต่างประเทศ" | mkAdv "แพร่กระจาย" | mkAdv "ในต่างชาติ" | mkAdv "ไม่หนักแน่น" | mkAdv "ในต่างประเทศ" | mkAdv "ไม่ตรงประเด็น" | mkAdv "ที่อยู่ในเมืองนอก" ; -- src=panlex
lin profession_N = mkN "วิชาชีพ" | mkN "การปฏิญาณ" | mkN "อาชีพที่ต้องการความรู้" | mkN "อาชีพ" | mkN "การงาน" | mkN "วิชาชีพ" | mkN "การประกาศ" | mkN "การยอมรับ" | mkN "การแสดงตัว" | mkN "การปฏิญาณตัว" | mkN "การนับถือศาสนา" | mkN "อาชีพที่สุจริต" | mkN "การประกาศความศรัทธา" | mkN "บรรดาผู้มีอาชีพเดียวกัน" | mkN "การประกาศความนับถือในศาสนา" ; -- src=panlex
lin load_N = mkN "ภาระ" | mkN "กรึ๊บ" | mkN "ระวาง" | mkN "หัวรบ" | mkN "ทางแร่" | mkN "หน้าที่" | mkN "สินค้าขนส่ง" | mkN "สินค้าบรรทุก" | mkN "น้ำหนักบรรทุก" | mkN "เครื่องมือรับพลังงานไฟฟ้า" | mkN "ภาระ" | mkN "หน้าที่" | mkN "น้ําหนัก" | mkN "ของบรรทุก" | mkN "ปริมาณงาน" | mkN "น้ําหนักถ่วง" | mkN "ความรับผิดชอบ" | mkN "ระวางน้ําหนัก" | mkN "น้ําหนักบรรทุก" | mkN "สินค้าที่บรรทุก" | mkN "ปริมาณไฟฟ้าที่ผลิตได้" | mkN "เครื่องมือรับพลังงานไฟฟ้า" | mkN "ปริมาณเสื้อผ้าที่ซักในเครื่องซักผ้า" | mkN "ปริมาณงานที่มอบหมายให้คนหรือเครื่องจักรทํา" ; -- src=panlex
lin countryside_N = mkN "ชนบท" | mkN "ชนบท" | mkN "ชาวชนบท" | mkN "บ้านนอก" | mkN "ต่างจังหวัด" | mkN "ส่วนที่เป็นชนบท" ; -- src=panlex
lin boot_N = mkN (thword "รอง" "เท้า" "บูท") "คู่" | {-pan-} mkN "บูท" | mkN "การเตะ" | mkN "เกือกบูท" | mkN "การจู่โจม" | mkN "รองเท้าบูท" | mkN "ช่องหยอดเหรียญ" | mkN "เครื่องบีบทรมานเท้า" | mkN "เท้าที่ถูกเครื่องทรมานบีบ" | mkN "บู๊ต" | mkN "รองเท้าบูท" | mkN "รองเท้าหุ้มข้อเท้า" ; -- src=panlex
lin mostly_Adv = mkAdv "โดยมาก" | mkAdv "โดยปกติ" | mkAdv "ส่วนใหญ่" | mkAdv "โดยทั่วไป" | mkAdv "โดยส่วนใหญ่" | mkAdv "โดยมาก" | mkAdv "ส่วนมาก" | mkAdv "โดยปกติ" | mkAdv "ส่วนใหญ่" ; -- src=panlex
lin sudden_A = mkA "ทันที" | mkA "ทันใด" | mkA "ฉับพลัน" | mkA "รวดเร็ว" | mkA "กะทันหัน" | mkA "โดยปัจจุบัน" ; -- src=panlex
lin implement_V2 = variants{} ; -- 
lin reputation_N = mkN "กิตติ-ศัพท์" | mkN "ชื่อเสียง" | mkN "กิตติศัพท์" | mkN "ความโด่งดัง" | mkN "ความเลื่องลือ" | mkN "ความมีหน้ามีตา" | mkN "ความนับหน้าถือตา" ; -- src=panlex
lin print_V2 = mkV2 "ลง" ; ---- | mkV "พิมพ์" | mkV "เขียน" | mkV "ตีพิมพ์" | mkV "จัดพิมพ์" | mkV "พิมพ์" | mkV "ประทับ" | mkV "ประทับใจ" | mkV "พิมพ์หนังสือ" | mkV "เขียนด้วยตัวพิมพ์" ; -- src=panlex
lin print_V = mkV "ลง" | mkV "พิมพ์" | mkV "เขียน" | mkV "ตีพิมพ์" | mkV "จัดพิมพ์" | mkV "พิมพ์" | mkV "ประทับ" | mkV "ประทับใจ" | mkV "พิมพ์หนังสือ" | mkV "เขียนด้วยตัวพิมพ์" ; -- src=panlex
lin calculate_VS = mmkVS "กะ" ; ---- | mkV "คำนวณ" | mkV "คิดเลข" | mkV "ประมาณ" | mkV "พึ่งพา" | mkV "คาดคะเน" | mkV "คิดคำนวณ" | mkV "จัดโครงการ" | mkV "คํานวณ" | mkV "คาดการณ์ว่า" ; -- src=panlex
lin calculate_V2 = mkV2 "กะ" ; ---- | mkV "คำนวณ" | mkV "คิดเลข" | mkV "ประมาณ" | mkV "พึ่งพา" | mkV "คาดคะเน" | mkV "คิดคำนวณ" | mkV "จัดโครงการ" | mkV "คํานวณ" | mkV "คาดการณ์ว่า" ; -- src=panlex
lin calculate_V = mkV "กะ" | mkV "คำนวณ" | mkV "คิดเลข" | mkV "ประมาณ" | mkV "พึ่งพา" | mkV "คาดคะเน" | mkV "คิดคำนวณ" | mkV "จัดโครงการ" | mkV "คํานวณ" | mkV "คาดการณ์ว่า" ; -- src=panlex
lin keen_A = mkA "คม" | mkA "จัด" | mkA "กล้า" | mkA "ฉลาด" | mkA "แหลม" | mkA "ไวมาก" | mkA "คมกริบ" | mkA "ดีเลิศ" | mkA "รุนแรง" | mkA "หนาวจัด" | mkA "หลักแหลม" | mkA "มีไหวพริบ" | mkA "ยอดเยี่ยม" | mkA "เฉียบแหลม" | mkA "ขะมักเขม้น" | mkA "ช่างสังเกต" | mkA "เอาใจจดจ่อ" | mkA "กระตือรือร้น" | mkA "มีสายตาแหลมคม" | mkA "สายตากว้างไกล" ; -- src=panlex
lin guess_VS = mmkVS "กะ" ; ---- | mkV "คาด" | mkV "คิด" | mkV "เดา" | mkV "คาดเดา" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "ทาย" | mkV "เดา" | mkV "เก็ง" | mkV "คิดว่า" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "เข้าใจว่า" | mkV "เสี่ยงทาย" ; -- src=panlex
lin guess_V2 = mkV2 "กะ" ; ---- | mkV "คาด" | mkV "คิด" | mkV "เดา" | mkV "คาดเดา" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "ทาย" | mkV "เดา" | mkV "เก็ง" | mkV "คิดว่า" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "เข้าใจว่า" | mkV "เสี่ยงทาย" ; -- src=panlex
lin guess_V = mkV "กะ" | mkV "คาด" | mkV "คิด" | mkV "เดา" | mkV "คาดเดา" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "ทาย" | mkV "เดา" | mkV "เก็ง" | mkV "คิดว่า" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "เข้าใจว่า" | mkV "เสี่ยงทาย" ; -- src=panlex
lin recommendation_N = mkN "หนังสือรับรอง" | mkN "การชี้แนะ" | mkN "การแนะนํา" ; -- src=panlex
lin autumn_N = mkN "ฤดูใบไม้ร่วง" | mkN "ฤดูใบไม้ร่วง" | mkN "วัยเจริญเติบโตเต็มที่" ; -- src=panlex
lin conventional_A = mkA "สามัญ" | mkA "ธรรมดา" | mkA "เกี่ยวกับประเพณีนิยม" | mkA "ซึ่งเกี่ยวกับการชุมนุม" | mkA "เกี่ยวกับข้อตกลงหรือสัญญา" | mkA "เกี่ยวกับธรรมเนียมปฏิบัติ" ; -- src=panlex
lin cope_V = mkV "ทำจนสำเร็จ" | mkV "รับมือได้" | mkV "รับมือกับปัญหาได้ดี" ; -- src=panlex
lin constitute_V2 = variants{} ; -- 
lin poll_N = mkN "กระหม่อม" | mkN "การนับคะแนน" | mkN "การนับคะแนนเสียง" | mkN "การสำรวจความเห็น" | mkN "การสำรวจประชามติ" | mkN "การเลือกตั้ง" | mkN "ผลการเลือกตั้ง" | mkN "ออกเสียงลงคะแนน" | mkN "" | mkN "ผลการนับคะแนนเสียง" | mkN "บุคคลที่ปรากฎในรายชื่อ" | mkN "การลงคะแนนเสียงเลือกตั้ง" | mkN "ผลคะแนนการออกเสียงเลือกตั้ง" | mkN "ส่วนปลายกว้างที่ใช้ตีของค้อน" | mkN "รายชื่อผู้ไปลงคะแนนเสียงเลือกตั้ง" | mkN "การสํารวจความคิดเห็นจากคนจํานวนมาก" ; -- src=panlex
lin voluntary_A = mkA "ซึ่งรับอาสา" | mkA "ซึ่งสมัครใจ" | mkA "อิสระ" | mkA "ตั้งใจ" | mkA "สมัครใจ" | mkA "โดยเจตนา" | mkA "โดยสมัครใจ" | mkA "ดนตรีโหมโรง" | mkA "เกิดขึ้นเอง" | mkA "โดยธรรมชาติ" | mkA "โดยอาสาสมัคร" | mkA "ด้วยความตั้งใจ" | mkA "มีอิสระในการเลือก" | mkA "ที่มีอํานาจในการเลือก" ; -- src=panlex
lin valuable_A = mkA "ที่มีค่า" | mkA "ซึ่งมีมูลค่า" | mkA "มีค่า" | mkA "มีราคา" | mkA "สําคัญ" | mkA "มีคุณค่า" | mkA "ซึ่งมีราคา" | mkA "มีความหมาย" | mkA "มีประโยชน์มาก" | mkA "มีค่าเป็นเงินมาก" | mkA "ของที่มีค่าเป็นเงินมาก" ; -- src=panlex
lin recovery_N = mkN "การพักฟื้น" | mkN "การกู้คืนมา" | mkN "การฟื้นคืนสู่สภาพปกติ" | mkN "การกู้" | mkN "การเอากลับคืน" | mkN "สิ่งที่ได้คืนมา" | mkN "การคืนสู่สภาพเดิม" | mkN "การฟื้นคืนสู่สภาพปกติ" ; -- src=panlex
lin cast_V2 = mkV2 "ราก" ; ---- | mkV "อ้วก" | mkV "กำจัด" | mkV "คายออก" | mkV "รากแตก" | mkV "อาเจียน" | mkV "เขวี้ยง" | mkV "เร่ร่อน" | mkV "โยนทิ้ง" | mkV "เร่่ร่อน" | mkV "กำหนดลีลา" | mkV "เลือกสุ่ม" | mkV "เทพิมพ์หล่อ" | mkV "ลงคะแนนเสียง" | mkV "เทลงแม่พิมพ์" | mkV "คัดด้วยตัวเอง" | mkV "ส่งไปข้างหน้า" | mkV "โยน" | mkV "ทิ้ง" | mkV "หลอม" | mkV "หล่อ" | mkV "ขว้าง" | mkV "คํานวณ" | mkV "ทํานาย" | mkV "จับฉลาก" | mkV "มองตรงไปยัง" | mkV "เลือกตัวละคร" ; -- src=panlex
lin cast_V = mkV "ราก" | mkV "อ้วก" | mkV "กำจัด" | mkV "คายออก" | mkV "รากแตก" | mkV "อาเจียน" | mkV "เขวี้ยง" | mkV "เร่ร่อน" | mkV "โยนทิ้ง" | mkV "เร่่ร่อน" | mkV "กำหนดลีลา" | mkV "เลือกสุ่ม" | mkV "เทพิมพ์หล่อ" | mkV "ลงคะแนนเสียง" | mkV "เทลงแม่พิมพ์" | mkV "คัดด้วยตัวเอง" | mkV "ส่งไปข้างหน้า" | mkV "โยน" | mkV "ทิ้ง" | mkV "หลอม" | mkV "หล่อ" | mkV "ขว้าง" | mkV "คํานวณ" | mkV "ทํานาย" | mkV "จับฉลาก" | mkV "มองตรงไปยัง" | mkV "เลือกตัวละคร" ; -- src=panlex
lin premise_N = mkN "คำกล่าวนำ" | mkN "หลักฐาน" | mkN "ข้อเสนอสนับสนุนการสรุปสมมติฐาน" | mkN "ข้อเสนอสนับสนุนการสรุปสมมุติฐาน" ; -- src=panlex
lin resolve_V2 = mkV2 "ตอบ" ; ---- | mkV "สรุป" | mkV "ละลาย" | mkV "ตัดสิน" | mkV "แก้ปัญหา" | mkV "ตัดสินใจแน่วแน่" | mkV "แยก" | mkV "มีมติ" | mkV "ตกลงใจ" | mkV "ตัดสิน" | mkV "แยกออก" | mkV "แยกแยะ" | mkV "ตัดสินใจ" | mkV "แก้ปัญหา" | mkV "ขจัดข้อสงสัย" | mkV "ตอบข้อข้องใจ" | mkV "ตกลงใจแน่วแน่" | mkV "ตัดสินใจแน่วแน่" | mkV "ลงความเห็นชี้ขาด" ; -- src=panlex
lin resolve_V = mkV "ตอบ" | mkV "สรุป" | mkV "ละลาย" | mkV "ตัดสิน" | mkV "แก้ปัญหา" | mkV "ตัดสินใจแน่วแน่" | mkV "แยก" | mkV "มีมติ" | mkV "ตกลงใจ" | mkV "ตัดสิน" | mkV "แยกออก" | mkV "แยกแยะ" | mkV "ตัดสินใจ" | mkV "แก้ปัญหา" | mkV "ขจัดข้อสงสัย" | mkV "ตอบข้อข้องใจ" | mkV "ตกลงใจแน่วแน่" | mkV "ตัดสินใจแน่วแน่" | mkV "ลงความเห็นชี้ขาด" ; -- src=panlex
lin regularly_Adv = variants{} ; -- 
lin solve_V2 = variants{} ; -- 
lin plaintiff_N = mkN "โจทก์" | mkN "ผู้ฟ้องคดี" | mkN "ผู้ร้องทุกข์" | mkN "โจทก์" | mkN "เจ้าทุกข์" | mkN "ผู้ร้องทุกข์" ; -- src=panlex
lin critic_N = mkN "คนช่างติ" | mkN "นักวิจารณ์" | mkN "นักวิจารณ์งานศิลป์" | mkN "ผู้ติชม" | mkN "นักวิจารณ์" | mkN "ผู้ชอบนินทา" | mkN "ผู้วิเคราะห์" | mkN "ผู้ที่ชอบจับผิด" | mkN "ผู้ที่ชอบติเตียน" ; -- src=panlex
lin agriculture_N = mkN "การเกษตร" | mkN "ชนชั้นเกษตรกร" | mkN "ธุรกิจด้านเกษตรกรรม" | mkN "กสิกรรม" | mkN "การเกษตร" | mkN "เกษตรกรรม" | mkN "เกษตรศาสตร์" ; -- src=panlex
lin ice_N = mkN (thword "น้ำ" "แข็ง") | {-pan-} mkN "เพชร" | mkN "น้ำแข็ง" | mkN "เฟรปเป้" | mkN "น้ำตาลไอซิ่ง" | mkN "เมทแอมเฟตามีน" | mkN "ลานสเกตน้ำแข็ง" | mkN "ลานสเก็ตน้ำแข็ง" | mkN "สินบน" | mkN "ไอติม" | mkN "ไอศรีม" | mkN "น้ำแข็ง" | mkN "แข็งตัว" | mkN "น้ําแข็ง" | mkN "ลานน้ําแข็ง" | mkN "พื้นน้ําแข็ง" | mkN "ท่านที่เฉยเมย" | mkN "ลานเสก็ตน้ําแข็ง" | mkN "เปลี่ยนเป็นน้ําแข็ง" | mkN "ก้อนน้ําแข็งที่ใส่เครื่องดื่ม" ; -- src=panlex
lin constitution_N = mkN "การก่อตั้ง" | mkN "การจัดตั้ง" | mkN "รัฐธรรมนูญ" | mkN "ส่วนประกอบ" | mkN "การประกอบขึ้น" | mkN "รากฐาน" | mkN "สันดาน" | mkN "ร่างกาย" | mkN "อุปนิสัย" | mkN "การสถาปนา" | mkN "การก่อตั้ง" | mkN "รัฐธรรมนูญ" | mkN "การประกอบขึ้น" | mkN "สุขภาพร่างกาย" | mkN "รูปแบบการปกครอง" | mkN "ระเบียบข้อบังคับ" ; -- src=panlex
lin communist_N = mkN "คอมมิวนิสต์" | mkN "พวกคอมมิวนิสต์" | mkN "สมาชิกพรรคคอมมิวนิสต์" | mkN "ผู้นิยมลัทธิคอมมิวนิสต์" | mkN "สมาชิกของพรรคคอมมิวนิสต์" ; -- src=panlex
lin layer_N = mkN "ชั้น" | mkN "ส่วนลึก" | mkN "แม่ไก่ที่ออกไข่" | mkN "ชั้น" | mkN "ระดับ" | mkN "ผู้วาง" | mkN "กิ่งตอน" | mkN "ชั้นดิน" | mkN "สิ่งที่เป็นชั้น" | mkN "แม่ไก่ที่วางไข่" | mkN "ความหนาของวัตถุเหนือพื้นผิว" ; -- src=panlex
lin recession_N = mkN "เศรษฐกิจถดถอย" | mkN "ภาวะเศรษฐกิจถดถอย" | mkN "การถอน" | mkN "การถอย" | mkN "การมอบคืน" | mkN "การตกต่ําของราคา" | mkN "ระยะซบเซาของธุรกิจ" | mkN "การตกต่ําทางเศรษฐกิจ" | mkN "ส่วนเว้าเข้าของกําแพงหรืออาคาร" | mkN "การคืนกรรมสิทธิ์กลับเจ้าของเดิม" ; -- src=panlex
lin slight_A = mkA "น้อย" | mkA "ผอมบาง" | mkA "เล็กน้อย" | mkA "สเลนเดอร์" | mkA "เบา" | mkA "อรชร" | mkA "บอบบาง" | mkA "เบาบาง" | mkA "แบบบาง" | mkA "น้อยมาก" | mkA "นิดเดียว" | mkA "เล็กน้อย" | mkA "สะโอดสะอง" | mkA "ไม่แข็งแรง" | mkA "เล็กน้อยมาก" | mkA "เอวบางร่างน้อย" | mkA "ไม่ค่อยแข็งแรง" ; -- src=panlex
lin dramatic_A = mkA "เกี่ยวกับละคร" | mkA "น่าทึ่งใจ" | mkA "ตื่นเต้นเร้าใจ" | mkA "ที่เกี่ยวกับละคร" | mkA "ที่มีลักษณะเกี่ยวกับละคร" ; -- src=panlex
lin golden_A = mkA "ทอง" | mkA "แห่งโชค" | mkA "ที่มีสีทอง" | mkA "ที่เป็นทอง" | mkA "ที่ทำด้วยทอง" | mkA "งดงาม" | mkA "สีทอง" | mkA "มีค่ามาก" | mkA "สีบลอนด์" | mkA "เฟื่องฟู" | mkA "ยอดเยี่ยม" | mkA "รุ่งเรือง" | mkA "ทําด้วยทอง" | mkA "ประกอบด้วยทอง" | mkA "เจริญรุ่งเรือง" | mkA "ครบรอบ50 ปี" ; -- src=panlex
lin temporary_A = mkA "ไม่ถาวร" | mkA "ชั่วคราว" | mkA "ที่ ไม่ถาวร" | mkA "ที่ ไม่ตลอดไป" | mkA "ชั่วคราว" | mkA "ที่ไม่ประจํา" ; -- src=panlex
lin suit_N = mkN "สูท" | mkN "ชุดสูท" | mkN "คดีความ" | mkN "เสื้อนอก" | mkN "การขอความรัก" | mkN "การดำเนินคดี" | mkN "การเกี้ยวพาราสี" | mkN "นักธุรกิจในชุดสูท" | mkN "คดี" | mkN "ชุด" | mkN "ฎีกา" | mkN "คําร้อง" | mkN "เหมาะสม" | mkN "การขอร้อง" | mkN "คําขอร้อง" | mkN "การฟ้องร้อง" | mkN "ชุดเสื้อผ้า" | mkN "การขอความรัก" | mkN "การขอแต่งงาน" | mkN "คําร้องเรียน" | mkN "การฟ้องร้องคดี" | mkN "การเกี้ยวพาราสี" | mkN "ชุดไพ่ดอกสีเดียวกัน" | mkN "ชุดไพ่สํารับเดียวกัน" | mkN "เสื้อผ้าที่เป็นชุดเดียวกัน" | mkN "จัดให้มีชุดเสื้อผ้าหรืออื่น ๆ" ; -- src=panlex
lin shortly_Adv = variants{} ; -- 
lin initially_Adv = variants{} ; -- 
lin arrival_N = mkN "การมาถึง" | mkN "ผู้มาถึง" | mkN "การมาถึง" | mkN "ผู้ที่มาถึง" | mkN "ผู้ที่มาใหม่" | mkN "สิ่งที่ปรากฎ" | mkN "การได้บรรลุถึง" ; -- src=panlex
lin protest_N = mkN "การประท้วง" | mkN "การคัดค้าน" | mkN "การประท้วง" | mkN "คําคัดค้าน" ; -- src=panlex
lin resistance_N = mkN "การคัดค้าน" | mkN "กลุ่มใต้ดิน" | mkN "ความต้านทาน" | mkN "ภูิมิต้านทาน" | mkN "ภูมิุคุ้มกัีน" | mkN "ขบวนการต่อต้าน" | mkN "ความต้านทานไฟฟ้า" | mkN "ความต้านทานไฟฟ้ากระแสสลับ" | mkN "ความทน" | mkN "การต้าน" | mkN "ความอดทน" | mkN "การขัดขืน" | mkN "การต่อต้าน" | mkN "การต้านทาน" | mkN "แรงต้านทาน" | mkN "ความต้านทาน" | mkN "ความอดกลั้น" ; -- src=panlex
lin silent_A = mkA "ใบ้" | mkA "เงียบ" | mkA "เป็นใบ้" | mkA "ซึ่งไม่ออกเสียง" | mkA "เงียบ" | mkA "ถูกลืม" | mkA "ไม่พูด" | mkA "พูดน้อย" | mkA "สงบนิ่ง" | mkA "นิ่งอึ้ง" | mkA "ลืมเลือน" | mkA "เงียบสงบ" | mkA "ไร้เสียง" | mkA "นิ่งเงียบ" | mkA "เงียบกริบ" | mkA "ซึ่งถูกลืม" | mkA "ไม่ค่อยพูด" | mkA "ไม่ออกเสียง" | mkA "ไม่ได้กล่าวถึง" | mkA "ซึ่งไม่ได้กล่าวถึง" ; -- src=panlex
lin presentation_N = mkN "การสาธิต" | mkN "การแนะนำ" | mkN "การนำเสนอ" | mkN "ภาพนำเสนอ" | mkN "พรีเซนเทชั่น" | mkN "การนำเสนอความคิดเห็น" | mkN "การเสนอ" | mkN "การแสดง" | mkN "ของขวัญ" | mkN "การแสดงตัว" | mkN "การแนะนําตัว" | mkN "การมอบของขวัญ" | mkN "สิ่งที่นําเสนอ" ; -- src=panlex
lin soul_N = mkN "คน" | mkN "บุคคล" | mkN "ดวงจิต" | mkN "วิญญาณ" | mkN "เพลงโซล" | mkN "ดนตรีโซล" | mkN "ปัจเจกชน" | mkN "จิตวิญญาณ" | mkN "ปัจเจกบุคคล" | mkN "คน" | mkN "จิตใจ" | mkN "บุคคล" | mkN "มนุษย์" | mkN "วิญญาณ" | mkN "ความคิด" | mkN "พลังจิต" | mkN "แก่นสาร" | mkN "แบบฉบับ" | mkN "จิตวิญญาณ" | mkN "ส่วนที่สําคัญ" | mkN "คุ้นเคยกับนิโกร" | mkN "เห็นอกเห็นใจนิโกร" | mkN "เป็นลักษณะของนิโกร" ; -- src=panlex
lin self_N = mkN "ตนเอง" | mkN "ตัวเอง" | mkN "ตนเอง" | mkN "อัตตะ" | mkN "อัตตา" | mkN "อาตมา" | mkN "ตัวเอง" | mkN "มนุษย์" | mkN "ธาตุแท้" | mkN "รูปพรรณ" | mkN "สภาพปกติ" | mkN "ตัวเขาเอง" | mkN "ตัวของตนเอง" | mkN "ความเป็นตัวตน" | mkN "ความสนใจตัวเอง" | mkN "คุณสมบัติของคน" | mkN "ลักษณะของบุคคล" | mkN "ผลประโยชน์ส่วนตัว" | mkN "เอกลักษณ์ของบุคคล" | mkN "การคํานึงถึงตัวเอง" | mkN "ลักษณะเฉพาะของบุคคล" | mkN "ลักษณะนิสัยที่แสดงออก" ; -- src=panlex
lin judgment_N = mkN "การตัดสิน" | mkN "วิจารณญาณ" | mkN "การประเมิน" | mkN "การพิพากษา" | mkN "การมองทะลุปรุโปร่ง" | mkN "ความเห็น" | mkN "คำตัดสิน" | mkN "การตัดสิน" | mkN "การคาดคะเน" | mkN "การประเมิน" | mkN "การพิจารณา" | mkN "การพิพากษา" | mkN "การตัดสินใจ" | mkN "คําวินิจฉัย" | mkN "การตัดสินความ" | mkN "การพิจารณาคดี" | mkN "การลงความเห็น" | mkN "การพิจารณาอรรถคดี" ; -- src=panlex
lin feed_V2 = mkV2 "กิน" ; ---- | mkV "ไหล" | mkV "อาหาร" | mkV "เลี้ยง" | mkV "ให้อาหาร" | mkV "หล่อเลี้ยง" | mkV "ทำให้รู้จัก" | mkV "ได้ประโยชน์" | mkV "กิน" | mkV "ใส่ปุ๋ย" | mkV "ขุนอาหาร" | mkV "ให้อาหาร" | mkV "ป้อนอาหาร" ; -- src=panlex
lin feed_V = mkV "กิน" | mkV "ไหล" | mkV "อาหาร" | mkV "เลี้ยง" | mkV "ให้อาหาร" | mkV "หล่อเลี้ยง" | mkV "ทำให้รู้จัก" | mkV "ได้ประโยชน์" | mkV "กิน" | mkV "ใส่ปุ๋ย" | mkV "ขุนอาหาร" | mkV "ให้อาหาร" | mkV "ป้อนอาหาร" ; -- src=panlex
lin muscle_N = mkN "กล้ามเนื้อ" | mkN "ความล่ำบึก" | mkN "ความมีกล้ามเนื้อ" | mkN "เนื้อเยื่อกล้ามเนื้อ" | mkN "กล้าม" | mkN "กล้ามเนื้อ" | mkN "กําลังวังชา" | mkN "ความแข็งแรง" | mkN "กําลังของกล้ามเนื้อ" ; -- src=panlex
lin shareholder_N = mkN "ผู้ถือหุ้น" | mkN "ผู้ถือหุ้น" | mkN "ผู้ถือหลักทรัพย์" ; -- src=panlex
lin opposite_A = mkA "ตรงข้าม" | mkA "ตรงกันข้าม" | mkA "ตรงข้าม" | mkA "ซึ่งอยู่คนละข้าง" | mkA "ซึ่งอยู่คนละด้าน" | mkA "ที่อยู่ตรงกันข้าม" | mkA "ที่แตกต่างกันอย่างสิ้นเชิง" ; -- src=panlex
lin pollution_N = mkN "การปนเปื้อน" | mkN "ความสกปรก" | mkN "ภาวะมลพิษ" | mkN "สภาวะมลพิษ" | mkN "สภาพเป็นพิษ" | mkN "มลภาวะเป็นพิษ" | mkN "การทําให้สกปรก" | mkN "การทําให้เป็นมลพิษ" ; -- src=panlex
lin wealth_N = mkN "ความมั่งมี" | mkN "ความมั่งคั่ง" | mkN "ความมีอันจะกิน" | mkN "ความมั่งมีศรีสุข" | mkN "ทรัพย์สิน" | mkN "ความมั่งมี" | mkN "ความร่ํารวย" | mkN "ความมั่งคั่ง" | mkN "สมบัติมากมาย" | mkN "ทรัพย์สินมากมาย" | mkN "ทรัพย์สมบัติมากมาย" ; -- src=panlex
lin video_taped_A = variants{} ; -- 
lin kingdom_N = mkN "คิงดอม" | mkN "ดินแดน" | mkN "อาณาจักร" | mkN "ราชอาณาจักร" | mkN "พวก" | mkN "วงศ์" | mkN "กลุ่ม" | mkN "ดินแดน" | mkN "อาณาจักร" | mkN "ราชอาณาจักร" | mkN "ประเทศที่ปกครองโดยพระราชาหรือพระราชินี" ; -- src=panlex
lin bread_N = mkN (thword "ขนม" "ปัง") "ห่อ" | {-pan-} mkN "ตังค์" | mkN "ขนมปัง" | mkN "ปัจจัย" | mkN "สตางค์" | mkN "หนมปัง" | mkN "สะตุ้งสตางค์" | mkN "ชีวิต" | mkN "อาหาร" | mkN "ขนมปัง" | mkN "เศษขนมปัง" | mkN "ความเป็นอยู่" | mkN "เครื่องประทังชีวิต" ; -- src=panlex
lin perspective_N = mkN "ทัศนะ" | mkN "มุมมอง" | mkN "ความคิด" | mkN "ทัศนคติ" | mkN "ความซึ้ง" | mkN "ทิวทัศน์" | mkN "ทัศนวิสัย" | mkN "ทัศนียภาพ" | mkN "ภาพวาดที่มีสัดส่วนแบบที่มองเห็น" | mkN "ภาพที่ได้จากการเขียนด้วยเทคนิคดังกล่าว" | mkN "เทคนิควาดภาพแบบที่มีสัดส่วนอย่างที่มองเห็น" ; -- src=panlex
lin camera_N = mkN "กล้อง" "ตัว" | {-pan-} mkN "กล้อง" | mkN "กล้องทีวี" | mkN "กล้องถ่ายรูป" | mkN "กล้องโทรทัศน์" | mkN "กล้องถ่ายภาพ" | mkN "กล้องถ่ายรูป" ; -- src=panlex
lin prince_N = mkN "เจ้าชาย" | mkN "เจ้าชาย" | mkN "กษัตริย์" | mkN "ผู้ดีเด่น" | mkN "พระราชนัดดา" | mkN "เจ้าผู้ครองนคร" | mkN "คนเก่งที่สุดในขอบข่ายงานหรือกิจกรรมที่ทํา" ; -- src=panlex
lin illness_N = mkN "ความเจ็บไข้" | mkN "ความเจ็บป่วย" | mkN "โรคภัย" | mkN "การไม่สบาย" | mkN "ความเจ็บไข้" | mkN "ความเลวร้าย" | mkN "ความเจ็บป่วย" | mkN "การเจ็บไข้ได้ป่วย" | mkN "อาการคลื่นเหียนอาเจียน" ; -- src=panlex
lin cake_N = mkN "ก้อน" | mkN "เค้ก" | mkN "แท่ง" | mkN "ขนมเค้ก" | mkN "พายชิ้นเล็กๆ" | mkN "เค้ก" | mkN "ส่วนแบ่ง" ; -- src=panlex
lin meat_N = mkN (thword "เนื้อ") | {-pan-} mkN "สาระ" | mkN "แก่น" | mkN "เนื้อ" | mkN "เนื้อๆ" | mkN "ใจกลาง" | mkN "เนื้อหา" | mkN "เนื้อสัตว์" | mkN "แก่นความคิด" | mkN "เนื้อในเมล็ด" | mkN "อาหาร" | mkN "เนื้อ" | mkN "ของโปรด" | mkN "เนื้อหา" | mkN "แก่นสาร" | mkN "จุดสําคัญ" | mkN "สาระสําคัญ" | mkN "ส่วนสําคัญ" | mkN "เนื้อผลไม้" | mkN "เนื้อสัตว์" | mkN "ใจความสําคัญ" | mkN "สิ่งที่ชอบทํา" | mkN "ส่วนที่กินได้" | mkN "อาหารมื้อสําคัญ" | mkN "ส่วนที่รับประทานได้" | mkN "เนื้อสัตว์ที่ใช้เป็นอาหาร" ; -- src=panlex
lin submit_V2 = mkV2 "ยอม" ; ---- | mkV "ส่ง" | mkV "ยินยอม" | mkV "ส่งคืน" | mkV "ส่งมอบ" | mkV "ให้คืน" | mkV "อ้างถึง" | mkV "ส่งใบสมัคร" | mkV "โอนอ่อนผ่อนตาม" | mkV "มอบ" | mkV "ยอม" | mkV "ยื่น" | mkV "เสนอ" | mkV "ยอมตาม" | mkV "เชื่อฟัง" ; -- src=panlex
lin submit_V = mkV "ยอม" | mkV "ส่ง" | mkV "ยินยอม" | mkV "ส่งคืน" | mkV "ส่งมอบ" | mkV "ให้คืน" | mkV "อ้างถึง" | mkV "ส่งใบสมัคร" | mkV "โอนอ่อนผ่อนตาม" | mkV "มอบ" | mkV "ยอม" | mkV "ยื่น" | mkV "เสนอ" | mkV "ยอมตาม" | mkV "เชื่อฟัง" ; -- src=panlex
lin ideal_A = mkA "ดีมาก" | mkA "วิเศษ" | mkA "ดีเลิศ" | mkA "ดีที่สุด" | mkA "ซึ่งไม่มีตัวตน" | mkA "ซึ่งเป็นนามธรรม" | mkA "ซึ่งอยู่ในความคิด" | mkA "ซึ่งอยู่ในอุดมคติ" ; -- src=panlex
lin relax_V2 = mkV2 "คลาย" ; ---- | mkV "หลวม" | mkV "สบายๆ" | mkV "รีแลกซ์" | mkV "ไม่แน่น" | mkV "ผ่อนคลาย" | mkV "ทำให้ผ่อนคลาย" | mkV "ลดความเข้มงวด" | mkV "คลายความเข้มงวด" | mkV "ทำให้รู้สึกผ่อนคลาย" | mkV "พักผ่อน" | mkV "ผ่อนคลาย" | mkV "คลายอารมณ์" | mkV "คลายเครียด" | mkV "ทําให้ผ่อนคลาย" ; -- src=panlex
lin relax_V = mkV "คลาย" | mkV "หลวม" | mkV "สบายๆ" | mkV "รีแลกซ์" | mkV "ไม่แน่น" | mkV "ผ่อนคลาย" | mkV "ทำให้ผ่อนคลาย" | mkV "ลดความเข้มงวด" | mkV "คลายความเข้มงวด" | mkV "ทำให้รู้สึกผ่อนคลาย" | mkV "พักผ่อน" | mkV "ผ่อนคลาย" | mkV "คลายอารมณ์" | mkV "คลายเครียด" | mkV "ทําให้ผ่อนคลาย" ; -- src=panlex
lin penalty_N = mkN "โทษ" | mkN "ผลร้าย" | mkN "ค่าปรับ" | mkN "อุปสรรค" | mkN "การลงโทษ" | mkN "โทษทัณฑ์" | mkN "ข้อเสียเปรียบ" | mkN "ค่าสินไหมทดแทน" | mkN "การลงทัณฑ์การลงโทษทางอาญา" ; -- src=panlex
lin purchase_V2 = variants{} ; -- 
lin tired_A = mkA "ซึ่งเหน็ดเหนื่อย" | mkA "ล้า" | mkA "จําเจ" | mkA "จืดชืด" | mkA "รําคาญ" | mkA "อิดโรย" | mkA "ซ้ําซาก" | mkA "เหนื่อย" | mkA "น่าเบื่อ" | mkA "มียางออก" | mkA "อ่อนเพลีย" | mkA "เมื่อยล้า" | mkA "เบื่อหน่าย" | mkA "ไม่น่าสนใจ" | mkA "เหน็ดเหนื่อย" | mkA "มีแถบโลหะหุ้มล้อรถ" ; -- src=panlex
lin beer_N = mkN biar_s kew_s | {-pan-} mkN "เบียร์" | mkN "เบียร์" ; -- src=panlex
lin specify_VS = mmkVS "กำหนด" ; ---- | mkV "ตั้งใจ" | mkV "มอบหมาย" | mkV "กำหนดคุณภาพ" | mkV "กำหนดเงื่อนไข" | mkV "ทำให้เฉพาะเจาะจง" | mkV "นิยามอย่างชัดเจน" | mkV "ระบุ" | mkV "กําหนด" ; -- src=panlex
lin specify_V2 = mkV2 "กำหนด" ; ---- | mkV "ตั้งใจ" | mkV "มอบหมาย" | mkV "กำหนดคุณภาพ" | mkV "กำหนดเงื่อนไข" | mkV "ทำให้เฉพาะเจาะจง" | mkV "นิยามอย่างชัดเจน" | mkV "ระบุ" | mkV "กําหนด" ; -- src=panlex
lin specify_V = mkV "กำหนด" | mkV "ตั้งใจ" | mkV "มอบหมาย" | mkV "กำหนดคุณภาพ" | mkV "กำหนดเงื่อนไข" | mkV "ทำให้เฉพาะเจาะจง" | mkV "นิยามอย่างชัดเจน" | mkV "ระบุ" | mkV "กําหนด" ; -- src=panlex
lin short_Adv = mkAdv "ทันทีทันใด" | mkAdv "อย่างห้วนๆ" | mkAdv "โดยย่อๆ" | mkAdv "โดยสังเขป" | mkAdv "อย่างฉับพลัน" | mkAdv "อย่างกะทันหัน" | mkAdv "อย่างหยาบกระด้าง" | mkAdv "อย่างไม่มีมารยาท" ; -- src=panlex
lin monitor_V2 = mkV2 "ดูแล" ; ---- | mkV "ตรวจ" | mkV "ติดตาม" | mkV "เฝ้าสังเกต" ; -- src=panlex
lin monitor_V = mkV "ดูแล" | mkV "ตรวจ" | mkV "ติดตาม" | mkV "เฝ้าสังเกต" ; -- src=panlex
lin electricity_N = mkN "ไฟ" | mkN "ไฟฟ้า" | mkN "กระแสไฟฟ้า" | mkN "ความตื่นเต้น" | mkN "พลังงานไฟฟ้า" | mkN "ไฟฟ้า" | mkN "การไฟฟ้า" | mkN "วิชาไฟฟ้า" | mkN "ไฟฟ้าสถิต" | mkN "กระแสไฟฟ้า" | mkN "ประจุไฟฟ้า" | mkN "พลังงานไฟฟ้า" | mkN "อารมณ์ตื่นเต้น" | mkN "อารมณ์ตึงเครียด" | mkN "เร่าร้อนตึงเครียด" | mkN "อารมณ์หรือความรู้สึกที่ตื่นเต้น" ; -- src=panlex
lin specifically_Adv = variants{} ; -- 
lin bond_N = mkN "พันธะ" | mkN "กรมธรรม์" | mkN "พันธบัตร" | mkN "การผูกติด" | mkN "การผูกมัด" | mkN "การยึดติด" | mkN "พันธนาการ" | mkN "พันธะเคมี" | mkN "การเกี่ยวดอง" | mkN "ใบแทนพันธบัตร" | mkN "กระดาษคุณภาพดี" | mkN "ข้อผูกมัด" | mkN "พันธนาการ" ; -- src=panlex
lin statutory_A = mkA "ตามกฎหมาย" ; -- src=panlex
lin laboratory_N = mkN "แล็บ" | mkN "ห้องแล็บ" | mkN "ห้องทดลอง" | mkN "ห้องปฏิบัติการ" | mkN "ห้องปฏิบัติการทางวิทยาศาสตร์" | mkN "ห้องทดลอง" | mkN "ห้องวิจัย" | mkN "ห้องปฏิบัติการ" | mkN "ห้องปฏิบัติการวิจัย" ; -- src=panlex
lin federal_A = mkA "แห่งสหพันธรัฐ" | mkA "กลาง" | mkA "สหรัฐ" | mkA "สหพันธ์" | mkA "พันธมิตร" | mkA "สันนิบาต" | mkA "สมาพันธรัฐ" | mkA "เกี่ยวกับสหพันธรัฐ" ; -- src=panlex
lin captain_N = mkN "น.อ." | mkN "ร.อ." | mkN "กัปตัน" | mkN "นาวาเอก" | mkN "ร้อยเอก" | mkN "สารวัตร" | mkN "กัปตันเรือ" | mkN "นักบินอาวุโส" | mkN "หัวหน้ากลุ่ม" | mkN "หัวหน้าบริกร" | mkN "กัปตันเรือสินค้า" | mkN "หัวหน้าพนักงานเสิร์ฟ" | mkN "กัปตัน" | mkN "หัวหน้าทีม" | mkN "หัวหน้าผู้ควบคุมเรือ" ; -- src=panlex
lin deeply_Adv = variants{} ; -- 
lin pour_V2 = mkV2 "เท" ; ---- | mkV "กรู" | mkV "ริน" | mkV "ตกหนัก" | mkV "ฝนตกหนัก" | mkV "ฝนลงหนัก" | mkV "ฝนเทลงมา" | mkV "ฝนตกกระหน่ำ" | mkV "รด" | mkV "เท" | mkV "ราด" | mkV "ริน" | mkV "หลั่ง" | mkV "ฝนตกหนัก" | mkV "ฝนตกกรูกราว" | mkV "ทําให้ไหลหลั่ง" | mkV "ปล่อยออกอย่างมาก" | mkV "เสิร์ฟเครื่องดื่ม" ; -- src=panlex
lin pour_V = mkV "เท" | mkV "กรู" | mkV "ริน" | mkV "ตกหนัก" | mkV "ฝนตกหนัก" | mkV "ฝนลงหนัก" | mkV "ฝนเทลงมา" | mkV "ฝนตกกระหน่ำ" | mkV "รด" | mkV "เท" | mkV "ราด" | mkV "ริน" | mkV "หลั่ง" | mkV "ฝนตกหนัก" | mkV "ฝนตกกรูกราว" | mkV "ทําให้ไหลหลั่ง" | mkV "ปล่อยออกอย่างมาก" | mkV "เสิร์ฟเครื่องดื่ม" ; -- src=panlex
lin boss_N = mkN (thword "เจ้า" "นาย")" คน" | {-pan-} mkN "นาย" | mkN "บอส" | mkN "ปุ่ม" | mkN "นายจ้าง" | mkN "หัวหน้า" | mkN "เจ้านาย" | mkN "โฟร์แมน" | mkN "หัวหน้าพรรค" | mkN "หัวหน้าคนงาน" | mkN "หัวหน้าพรรคการเมือง" | mkN "นาย" | mkN "นายจ้าง" | mkN "หัวหน้า" | mkN "เจ้านาย" | mkN "ผู้เป็นใหญ่" ; -- src=panlex
lin creature_N = mkN "สัตว์" | mkN "มนุษย์" | mkN "สัตว์ป่า" | mkN "หุ่นเชิด" | mkN "เครื่องมือ" | mkN "เดียรัจฉาน" | mkN "สิ่งมีชีวิต" | mkN "คนที่ถูกหลอกใช้" | mkN "สัตว์เดียรัจฉาน" | mkN "คน" | mkN "ทาส" | mkN "บุคคล" | mkN "สัตว์" | mkN "เครื่องมือ" | mkN "ลักษณะของคน" | mkN "สัตว์ประหลาด" | mkN "สิ่งสร้างสรรค์" | mkN "สรรพสิ่งที่สร้างขึ้น" ; -- src=panlex
lin urge_VS = variants{} ; -- 
lin urge_V2V = variants{} ; -- 
lin urge_V2 = variants{} ; -- 
lin locate_V2 = mkV2 "ตั้งถิ่นฐาน" ; ---- | mkV "กำหนดตำแหน่ง" | mkV "ส่งไปปฎิบัติหน้าที่" | mkV "หา" | mkV "ตั้ง" | mkV "สร้าง" | mkV "ก่อตั้ง" | mkV "หาที่ตั้ง" | mkV "ก่อตั้งธุรกิจ" | mkV "หาตําแหน่งที่ตั้ง" | mkV "สร้างธุรกิจหรือบริษัท" ; -- src=panlex
lin locate_V = mkV "ตั้งถิ่นฐาน" | mkV "กำหนดตำแหน่ง" | mkV "ส่งไปปฎิบัติหน้าที่" | mkV "หา" | mkV "ตั้ง" | mkV "สร้าง" | mkV "ก่อตั้ง" | mkV "หาที่ตั้ง" | mkV "ก่อตั้งธุรกิจ" | mkV "หาตําแหน่งที่ตั้ง" | mkV "สร้างธุรกิจหรือบริษัท" ; -- src=panlex
lin being_N = mkN "เป็น" | mkN "การเป็นอยู่" | mkN "สิ่งมีชีวิต" | mkN "คน" | mkN "สาร" | mkN "ชีวิต" | mkN "บุคคล" | mkN "มนุษย์" | mkN "ธาตุแท้" | mkN "พระเจ้า" | mkN "ธรรมชาติ" | mkN "การมีอยู่" | mkN "มีตัวมีตน" | mkN "การเป็นอยู่" | mkN "สิ่งมีชีวิต" | mkN "การดํารงอยู่" | mkN "การมีชีวิตอยู่" | mkN "ภาวะมีชีวิตอยู่" ; -- src=panlex
lin struggle_VV = mkVV "ปีน" ; ---- | mkV "สู้" | mkV "ดิ้นรน" | mkV "ต่อสู้" | mkV "ประลอง" | mkV "ปีนขึ้นอย่างทุลักทุเล" | mkV "ดิ้นรน" | mkV "ต่อสู้" | mkV "พยายาม" | mkV "แข่งขัน" ; -- src=panlex
lin struggle_V = mkV "ปีน" | mkV "สู้" | mkV "ดิ้นรน" | mkV "ต่อสู้" | mkV "ประลอง" | mkV "ปีนขึ้นอย่างทุลักทุเล" | mkV "ดิ้นรน" | mkV "ต่อสู้" | mkV "พยายาม" | mkV "แข่งขัน" ; -- src=panlex
lin lifespan_N = mkN "ช่วงอายุ" ; -- src=panlex
lin flat_A = mkA "จืด" | mkA "แบน" | mkA "ซบเซา" | mkA "แฟล็ต" | mkA "สองมิติ" | mkA "น่าเบื่อ" | mkA "โทนเดียว" | mkA "ซึ่งไม่มีแก๊ส" | mkA "ซึ่งไม่มีรสชาติ" | mkA "ซึ่งไม่สะท้อนแสง" | mkA "ซึ่งพูดเสียงโทนเดียว" | mkA "ตก" | mkA "ซึม" | mkA "บาง" | mkA "ราบ" | mkA "แบน" | mkA "แฟบ" | mkA "ตื้น" | mkA "ทื่อ" | mkA "ซบเซา" | mkA "เรียบ" | mkA "ไม่คม" | mkA "แบนราบ" | mkA "ไร้ฟอง" | mkA "เด็ดขาด" | mkA "แน่นนอน" | mkA "ไร้สาระ" | mkA "น่าเบื่อ" | mkA "ราบเรียบ" | mkA "ไม่มีส้น" | mkA "ไม่ชัดเจน" | mkA "ตรงไปตรงมา" | mkA "ไม่น่าสนใจ" | mkA "ไม่มีรสชาติ" | mkA "เหมือนกันหมด" | mkA "ไม่กระเตื้อง" | mkA "ไร้ชีวิตชีวา" | mkA "ไม่มีชีวิตชีวา" | mkA "ที่ไม่เปลี่ยนแปลง" | mkA "ไม่มีจุดหมายปลายทาง" | mkA "ไม่ตัดกันอย่างชัดเจน" | mkA "ไม่มีเสียงสูงเสียงต่ํา" | mkA "ซึ่งถูกโค่นหรือปราบเรียบ" ; -- src=panlex
lin valley_N = mkN "หุบเขา" | mkN "ห้วย" | mkN "หุบเขา" | mkN "ห้วยเขา" | mkN "แอ่งลึก" | mkN "หว่างเขา" | mkN "หุบลําธาร" | mkN "หุบเขาลําธาร" ; -- src=panlex
lin like_A = mkA "เสมือน" | mkA "เหมือน" | mkA "เท่ากัน" | mkA "คล้ายกัน" | mkA "เหมือนกัน" | mkA "ซึ่งเท่ากัน" | mkA "คล้ายคลึงกัน" | mkA "เปรียบเสมือน" | mkA "เปรียบเหมือน" | mkA "เท่ากัน" | mkA "เสมอกัน" | mkA "คล้ายกัน" | mkA "เป็นไปได้" | mkA "เหมือนกัน" | mkA "เหมือนว่าจะ" | mkA "เท่าเทียมกัน" | mkA "อย่างเดียวกัน" | mkA "จําพวกเดียวกัน" | mkA "น่าจะเป็นไปได้" | mkA "ประเภทเดียวกัน" ; -- src=panlex
lin guard_N = mkN "ยาม" | mkN "การ์ด" | mkN "กองหลัง" | mkN "ท่าป้องกัน" | mkN "ท่าตั้งการ์ด" | mkN "อุปกรณ์นิรภัย" | mkN "หน้าที่เฝ้ายาม" | mkN "หน้าที่ยามรักษาการณ์" | mkN "ยาม" | mkN "การ์ด" | mkN "คนเฝ้า" | mkN "ผู้ดูแล" | mkN "คนเฝ้ายาม" | mkN "ผู้คุ้มกัน" | mkN "ยามรักษาการณ์" | mkN "อุปกรณ์ป้องกัน" | mkN "เครื่องป้องกันภัย" | mkN "ตัวเบี้ยของกีฬาหมากรุก" | mkN "ตําแหน่งการ์ดในการเล่นกีฬาฟุตบอล" ; -- src=panlex
lin emergency_N = mkN "เบรกมือ" | mkN "ภาวะฉุกเฉิน" | mkN "กรณีฉุกเฉิน" | mkN "ภาวะฉุกเฉิน" | mkN "ภาวะเร่งด่วน" | mkN "ภาวะปัจจุบันทันด่วน" | mkN "สถานการณ์ที่ต้องรีบเร่ง" ; -- src=panlex
lin dark_N = mkN "ค่ำคืน" | mkN "ค่ำมืด" | mkN "ที่มืด" | mkN "กลางคืน" | mkN "ความมืด" | mkN "ยามวิกาล" | mkN "รัตติกาล" | mkN "ความมืดมน" | mkN "ตอนดึก" | mkN "ที่มืด" | mkN "มุมมืด" | mkN "เงามืด" | mkN "กลางคืน" | mkN "ความมืด" | mkN "เวลาดึก" | mkN "เวลาค่ํา" | mkN "ความมืดมิด" | mkN "ช่วงเวลาดึก" | mkN "การปราศจากแสง" ; -- src=panlex
lin bomb_N = mkN "ระเบิด" | mkN "ลูกระเบิด" | mkN "ความล้มเหลว" | mkN "ระเบิด" | mkN "ลูกระเบิด" ; -- src=panlex
lin dollar_N = mkN "ดอล" | mkN "เหรียญ" | mkN "ดอลลาร์" | mkN "หนึ่งดอลล่าร์" | mkN "เหรียญดอลลาร์" | mkN "สกุลเงินดอลลาร์" | mkN "สัญลักษณ์ดอลลาร์" | mkN "สัญลักษณ์เงินดอล" | mkN "แบงค์หนึ่งดอลลาร์" | mkN "ธนบัตรหนึ่งดอลลาร์" | mkN "ดอลลาร์" | mkN "สกุลเงินดอลลาร์" ; -- src=panlex
lin efficiency_N = mkN "สมรรถนะ" | mkN "การมีประสิทธิผล" | mkN "ความได้ผล" | mkN "ประสิทธิผล" | mkN "ประสิทธิภาพ" | mkN "ความมีประสิทธิภาพ" | mkN "ความสามารถในการทํางานที่ใช้เวลา" | mkN "พลังงานหรือเงินน้อยแต่มีประสิทธิภาพมาก" ; -- src=panlex
lin mood_N = mkN "มาลา" | mkN "อารมณ์" | mkN "ใจคอ" | mkN "อารมณ์" | mkN "อารมณ์ขุ่นหมอง" | mkN "กลุ่มคํากริยาแสดงทัศนคติ" ; -- src=panlex
lin convert_V2 = mkV2 "ยิง" ; ---- | mkV "แปลง" | mkV "เปลี่ยน" | mkV "กลายเป็น" | mkV "ยิงจุดโทษ" | mkV "แลกเปลี่ยน" | mkV "เปลี่ยนเป็น" | mkV "เสียค่าปรับ" | mkV "ทำความเข้าใจ" | mkV "เปลี่ยนศาสนา" | mkV "เปลี่ยนความเชื่อ" | mkV "เปลี่ยน" | mkV "เปลี่ยนศาสนา" | mkV "แปลงหน่วยวัด" | mkV "เปลี่ยนไปเป็น" | mkV "เปลี่ยนความเชื่อ" | mkV "ทําให้เปลี่ยนศาสนา" | mkV "ทําให้เปลี่ยนไปเป็น" | mkV "ทําให้เปลี่ยนความเชื่อ" ; -- src=panlex
lin convert_V = mkV "ยิง" | mkV "แปลง" | mkV "เปลี่ยน" | mkV "กลายเป็น" | mkV "ยิงจุดโทษ" | mkV "แลกเปลี่ยน" | mkV "เปลี่ยนเป็น" | mkV "เสียค่าปรับ" | mkV "ทำความเข้าใจ" | mkV "เปลี่ยนศาสนา" | mkV "เปลี่ยนความเชื่อ" | mkV "เปลี่ยน" | mkV "เปลี่ยนศาสนา" | mkV "แปลงหน่วยวัด" | mkV "เปลี่ยนไปเป็น" | mkV "เปลี่ยนความเชื่อ" | mkV "ทําให้เปลี่ยนศาสนา" | mkV "ทําให้เปลี่ยนไปเป็น" | mkV "ทําให้เปลี่ยนความเชื่อ" ; -- src=panlex
lin possession_N = mkN "กำลังใจ" | mkN "การคุมสติ" | mkN "การครองบอล" | mkN "การระงับใจ" | mkN "การถูกครอบงำ" | mkN "การข่มใจตนเอง" | mkN "การควบคุมตนเอง" | mkN "การเป็นเจ้าของ" | mkN "อาการคลั่งไคล้" | mkN "สิ่งที่ครอบครอง" | mkN "อาณาเขตในครอบครอง" | mkN "การมี" | mkN "ความคิด" | mkN "อาณานิคม" | mkN "การควบคุม" | mkN "การครอบงํา" | mkN "การครอบครอง" | mkN "การเข้ายึดเอา" | mkN "ความเป็นเจ้าของ" | mkN "สิ่งที่ครองครอง" | mkN "ที่ดินในครอบครอง" | mkN "การครอบงําความคิด" | mkN "สิ่งที่ครอบครองอยู่" | mkN "ทรัพย์สมบัติหรือดินแดนที่ครอบครอง" ; -- src=panlex
lin marketing_N = mkN "การขาย" | mkN "การตลาด" | mkN "การทำตลาด" | mkN "การจำหน่าย" | mkN "มาเก็ตติ้ง" | mkN "การตลาด" | mkN "การซื้อขายในตลาด" | mkN "การซื้อขายสินค้าหรือบริการ" ; -- src=panlex
lin please_VV = mkVV "พอใจ" ; ---- | mkV "ทำให้พอใจ" | mkV "สร้างความพอใจ" | mkV "ให้ความพึงพอใจ" | mkV "ชอบ" | mkV "พอใจ" | mkV "ต้องการ" | mkV "ทําให้พอใจ" | mkV "พึงปรารถนา" | mkV "ทําให้ถูกใจ" | mkV "ให้ความพอใจ" | mkV "ให้ความเพลิดเพลิน" ; -- src=panlex
lin please_V2V = mmkV2V "พอใจ" ; ---- | mkV "ทำให้พอใจ" | mkV "สร้างความพอใจ" | mkV "ให้ความพึงพอใจ" | mkV "ชอบ" | mkV "พอใจ" | mkV "ต้องการ" | mkV "ทําให้พอใจ" | mkV "พึงปรารถนา" | mkV "ทําให้ถูกใจ" | mkV "ให้ความพอใจ" | mkV "ให้ความเพลิดเพลิน" ; -- src=panlex
lin please_V2 = mkV2 "พอใจ" ; ---- | mkV "ทำให้พอใจ" | mkV "สร้างความพอใจ" | mkV "ให้ความพึงพอใจ" | mkV "ชอบ" | mkV "พอใจ" | mkV "ต้องการ" | mkV "ทําให้พอใจ" | mkV "พึงปรารถนา" | mkV "ทําให้ถูกใจ" | mkV "ให้ความพอใจ" | mkV "ให้ความเพลิดเพลิน" ; -- src=panlex
lin please_V = mkV "พอใจ" | mkV "ทำให้พอใจ" | mkV "สร้างความพอใจ" | mkV "ให้ความพึงพอใจ" | mkV "ชอบ" | mkV "พอใจ" | mkV "ต้องการ" | mkV "ทําให้พอใจ" | mkV "พึงปรารถนา" | mkV "ทําให้ถูกใจ" | mkV "ให้ความพอใจ" | mkV "ให้ความเพลิดเพลิน" ; -- src=panlex
lin habit_N = mkN "กิจวัตร" | mkN "ชุดขี่ม้า" | mkN "ความเคยชิน" | mkN "นิสัย" | mkN "กิจวัตร" | mkN "ประเพณี" | mkN "ธรรมเนียม" | mkN "ความเคยชิน" | mkN "สวมเสื้อผ้า" | mkN "อาศัยอยู่ใน" | mkN "การติดยาเสพย์ติด" | mkN "สิ่งที่ทําเป็นประจํา" ; -- src=panlex
lin subsequently_Adv = variants{} ; -- 
lin round_N = mkN "รอบ" | mkN "การหมุน" | mkN "เนื้อสะโพก" | mkN "กิจวัตรประจำวัน" | mkN "เส้นทางลาดตระเวน" | mkN "รอบ" | mkN "ชุดยิง" | mkN "รูปทรงกลม" | mkN "การลาดตระเวณ" | mkN "การหมุนไปรอบๆ" | mkN "รอบการแข่งขัน" | mkN "สิ่งที่เป็นวงกลม" | mkN "ขนมปังที่หั่นเป็นแผ่น" | mkN "ท่อนเพลงที่ร้องต่อกันเป็นทอดๆ" ; -- src=panlex
lin purchase_N = mkN "การซื้อ" | mkN "ของที่ซื้อ" | mkN "สิ่งที่ซื้อ" | mkN "การซื้อ" | mkN "ของที่ซื้อมา" | mkN "การได้มาด้วยความพยายาม" ; -- src=panlex
lin sort_V2 = mkV2 "จัด" ; ---- | mkV "จำแนก" | mkV "สกรีน" | mkV "แยกประเภท" | mkV "จัดเข้าประเภท" ; -- src=panlex
lin sort_V = mkV "จัด" | mkV "จำแนก" | mkV "สกรีน" | mkV "แยกประเภท" | mkV "จัดเข้าประเภท" ; -- src=panlex
lin outside_A = mkA "กลางแจ้ง" | mkA "จากภายนอก" | mkA "ในระดับนานาชาติ" | mkA "ที่อยู่ข้างนอก" | mkA "ที่อยู่ด้านนอก" | mkA "ที่เป็นไปได้มากที่สุด" ; -- src=panlex
lin gradually_Adv = variants{} ; -- 
lin expansion_N = mkN "การขยาย" | mkN "การขยายออก" | mkN "การขยายความ" | mkN "การเพิ่มรายละเอียด" | mkN "การขยาย" | mkN "การเพิ่ม" | mkN "การขยายออก" | mkN "การแผ่ขยาย" | mkN "สิ่งที่ถูกขยาย" | mkN "ส่วนที่ขยายออก" | mkN "การทําให้กว้างออก" | mkN "ปริมาณหรือขนาดของการขยายออก" ; -- src=panlex
lin competitive_A = mkA "เกี่ยวกับการแข่งขัน" | mkA "ซึ่งสามารถแข่งขันได้" | mkA "ที่เกี่ยวกับการแข่งขัน" ; -- src=panlex
lin cooperation_N = mkN "การร่วมมือ" | mkN "การร่วมมือ" | mkN "การยอมทําตาม" | mkN "การร่วมมือกัน" | mkN "การทํางานร่วมกัน" ; -- src=panlex
lin acceptable_A = mkA "ที่น่าพอใจ" | mkA "ซึ่งเป็นที่ยอมรับ" | mkA "ถูกใจ" | mkA "น่ายินดี" | mkA "เห็นด้วย" | mkA "ยอมรับได้" | mkA "ี่น่าพอใจ" | mkA "ที่ยอมรับได้" | mkA "สามารถรับได้" | mkA "ซึ่งยอมรับได้" | mkA "ซึ่งเป็นที่ยอมรับ" | mkA "ซึ่งได้รับการเห็นชอบ" ; -- src=panlex
lin angle_N = mkN "มุม" | mkN "มุม" | mkN "มุมมอง" | mkN "การวัดมุม" | mkN "แง่มุมในการพิจารณา" ; -- src=panlex
lin cook_V2 = mkV2 "ทำอาหาร" ; ---- | mkV "ปลอมแปลง" | mkV "ทำกับข้าว" | mkV "ประกอบอาหาร" | mkV "เตรียมอาหาร" | mkV "หุง" | mkV "หุงต้ม" | mkV "ทําอาหาร" | mkV "ปลอมแปลง" | mkV "เกิดขึ้น" | mkV "เตรียมอาหาร" | mkV "รู้สึกร้อนระอุ" | mkV "อึดอัดเพราะอากาศร้อน" ; -- src=panlex
lin cook_V = mkV "ทำอาหาร" | mkV "ปลอมแปลง" | mkV "ทำกับข้าว" | mkV "ประกอบอาหาร" | mkV "เตรียมอาหาร" | mkV "หุง" | mkV "หุงต้ม" | mkV "ทําอาหาร" | mkV "ปลอมแปลง" | mkV "เกิดขึ้น" | mkV "เตรียมอาหาร" | mkV "รู้สึกร้อนระอุ" | mkV "อึดอัดเพราะอากาศร้อน" ; -- src=panlex
lin net_A = mkA "สุทธิ" | mkA "สุดท้าย" | mkA "ซึ่งเหลือหลังหักค่าสิ่งอื่นแล้ว" ; -- src=panlex
lin sensitive_A = mkA "ซึ่งไวต่อสิ่งกระตุ้น" | mkA "ประสาทไว" | mkA "รู้สึกไว" | mkA "ไวต่อแสง" | mkA "รับอิทธิ-พลภายนอกได้ง่าย" | mkA "ซึ่งรู้สึกไว" | mkA "มีเล่ห์นัยยิ่ง" | mkA "ไวต่อสิ่งกระตุ้น" | mkA "ซึ่งตอบสนองได้ง่าย" | mkA "ซึ่งไวต่อสิ่งกระตุ้น" | mkA "รับความรู้สึกได้ง่าย" | mkA "เกี่ยวกับอวัยวะสัมผัส" ; -- src=panlex
lin ratio_N = mkN "สัดส่วน" | mkN "อัตราส่วน" | mkN "สัดส่วน" | mkN "อัตราส่วน" | mkN "อัตราเปรียบเทียบ" | mkN "ความสัมพันธ์ระหว่างสองจํานวน" ; -- src=panlex
lin kiss_V2 = variants{} ; -- 
lin amount_V = mkV "รวม" | mkV "พัฒนา" | mkV "คิดเป็น" | mkV "มีผลรวม" | mkV "มีผลรวม" | mkV "มีจํานวนรวม" ; -- src=panlex
lin sleep_N = mkN "การนอน" | mkN "การหลับ" | mkN "เวลานอน" | mkN "การนอนหลับ" | mkN "การพักผ่อน" | mkN "อาการหลับลึก" | mkN "การหลับ" | mkN "การง่วงซึม" | mkN "การนอนหลับ" ; -- src=panlex
lin finance_V2 = variants{} ; -- 
lin essentially_Adv = variants{} ; -- 
lin fund_V2 = variants{} ; -- 
lin preserve_V2 = variants{} ; -- 
lin wedding_N = mkN "งานสมรส" | mkN "งานแต่ง" | mkN "งานวิวาห์" | mkN "การแต่งงาน" | mkN "งานแต่งงาน" | mkN "งานมงคลสมรส" | mkN "พิธีมงคลสมรส" | mkN "งานเลี้ยงแต่งงาน" | mkN "งานเลี้ยงฉลองสละโสด" | mkN "งานเลี้ยงฉลองมงคลสมรส" | mkN "การสมรส" | mkN "พิธีสมรส" | mkN "การร่วมกัน" | mkN "การแต่งงาน" | mkN "งานแต่งงาน" | mkN "การประสานกัน" | mkN "การฉลองครบรอบการสมรส" ; -- src=panlex
lin personality_N = mkN "บุคลิก" | mkN "บุคลิกภาพ" | mkN "คนมีชื่อเสียง" | mkN "บุคคล" | mkN "บุคลิกภาพ" | mkN "บุคลิกลักษณะ" | mkN "ลักษณะเฉพาะตัว" | mkN "คนที่มีชื่อเสียง" | mkN "บุคคลมีชื่อเสียง" | mkN "ลักษณะเฉพาะของแต่ละคน" | mkN "คนที่เป็นที่รู้จักกันดี" ; -- src=panlex
lin bishop_N = mkN "บิชอป" | mkN "บิชอพ" | mkN "ไวน์ที่มีส่วนผสมของส้มและกานพลู" | mkN "สังฆนายก" | mkN "หัวหน้าบาทหลวง" | mkN "ตัวหมากรุกที่มีวิธีเดินทแยงมุม" | mkN "ตําแหน่งบาทหลวงที่มีอํานาจปกครองบาทหลวงอื่นๆ" ; -- src=panlex
lin dependent_A = mkA "ซึ่งติดยาเสพติด" | mkA "แล้วแต่" | mkA "ขึ้นอยู่กับ" | mkA "ผู้อยู่ในความอุปถัมภ์" ; -- src=panlex
lin landscape_N = mkN "ภาพวิว" | mkN "ภูมิทัศน์" | mkN "ภาพทิวทัศน์" | mkN "ภาพแลนด์สเคป" | mkN "ทิวทัศน์" | mkN "ภูมิทัศน์" | mkN "ภูมิประเทศ" | mkN "ภาพภูมิประเทศ" ; -- src=panlex
lin pure_A = mkA "พรหมจารี" | mkA "บริสุทธิ์" | mkA "พรหมจรรย์" | mkA "สะอาด" | mkA "ไม่ผสม" | mkA "ไร้มลทิน" | mkA "บริสุทธิ์" | mkA "อย่างที่สุด" | mkA "อย่างสมบูรณ์" | mkA "ไม่มีสารอื่นเจือปน" ; -- src=panlex
lin mirror_N = mkN "กระจก" | mkN "พระฉาย" | mkN "คันฉ่อง" | mkN "กระจกเงา" | mkN "ส่อ" | mkN "กระจก" | mkN "กระจกเงา" | mkN "ภาพสะท้อน" | mkN "สิ่งสะท้อน" | mkN "ส่องเป็นเงา" | mkN "เครื่องสะท้อน" | mkN "เครื่องส่อแสดง" | mkN "เป็นตัวแทนที่แท้จริง" | mkN "สิ่งที่เป็นตัวแทนที่แท้จริง" ; -- src=panlex
lin lock_V2 = mkV2 "ล็อก" ; ---- | mkV "ล็อค" | mkV "เก็บใส่กุญแจ" | mkV "กอดรัด" | mkV "ใส่กุญแจ" | mkV "การทะเลาะวิวาท" | mkV "ทําให้ติดแน่นเคลื่อนที่ไม่ได้" | mkV "เก็บไว้ในที่ปลอดภัยและใส่กุญแจ" | mkV "เข้าไปพัวพันในสถานการณ์ที่ยุ่งยาก เช่น การต่อสู้" ; -- src=panlex
lin lock_V = mkV "ล็อก" | mkV "ล็อค" | mkV "เก็บใส่กุญแจ" | mkV "กอดรัด" | mkV "ใส่กุญแจ" | mkV "การทะเลาะวิวาท" | mkV "ทําให้ติดแน่นเคลื่อนที่ไม่ได้" | mkV "เก็บไว้ในที่ปลอดภัยและใส่กุญแจ" | mkV "เข้าไปพัวพันในสถานการณ์ที่ยุ่งยาก เช่น การต่อสู้" ; -- src=panlex
lin symptom_N = mkN "อาการ" | mkN "อาการป่วย" | mkN "อาการเจ็บป่วย" | mkN "อาการ" | mkN "เครื่องบอก" | mkN "อาการของโรค" | mkN "เครื่องแสดง" | mkN "เครื่องบ่งบอก" ; -- src=panlex
lin promotion_N = mkN "การส่งเสริม" | mkN "การเลื่อนขั้น" | mkN "การเลื่อน" | mkN "การสนับสนุน" | mkN "การส่งเสริม" | mkN "การเลื่อนตําแหน่ง" ; -- src=panlex
lin global_A = mkA "ทรงกลม" | mkA "ทั่วโลก" | mkA "ซึ่งเป็นทรงกลม" | mkA "กว้างๆ" | mkA "โดยรวม" | mkA "ทั่วโลก" | mkA "ทั้งหมด" | mkA "ทั้งโลก" | mkA "เป็นรูปโลก" | mkA "กลมเหมือนโลก" | mkA "ซึ่งมีรูปร่างกลม" ; -- src=panlex
lin aside_Adv = mkAdv "สำรอง" | mkAdv "แยกจาก" | mkAdv "ในทิศทางอื่น" | mkAdv "โดยไม่พิจารณา" | mkAdv "กันไว้ด้านหนึ่ง" | mkAdv "ข้างๆ" | mkAdv "สํารอง" | mkAdv "ออกไปจาก" | mkAdv "ออกไปจากใจ" | mkAdv "ไปด้านข้าง" | mkAdv "เก็บเอาไว้ใช้" | mkAdv "ออกไปจากความคิด" ; -- src=panlex
lin tendency_N = mkN "นิสัย" | mkN "แนวโน้ม" | mkN "การบริการ" | mkN "การโน้มเอียง" | mkN "ความโน้มน้าว" | mkN "ความโน้มเอียง" | mkN "จุดประสงค์เฉพาะ" | mkN "จุดประสงค์พิเศษ หรือเฉพาะ" ; -- src=panlex
lin conservation_N = mkN "การอนุรักษ์" | mkN "การสงวน" | mkN "การสงวนไว้" | mkN "การรักษาไว้" | mkN "การเก็บรักษาไว้" | mkN "การอนุรักษ์ธรรมชาติ" | mkN "การป้องกันความสูญเสีย" | mkN "การอนุรักษ์ทรัพยากรธรรมชาติ" ; -- src=panlex
lin reply_N = mkN "คำตอบ" | mkN "การพูดตอบ" | mkN "การตอบ" | mkN "คําตอบ" | mkN "การตอบสนอง" ; -- src=panlex
lin estimate_N = mkN "การประมาณ" | mkN "ความเคารพ" | mkN "ใบประเมิน" | mkN "การประเมิน" | mkN "การตีราคา" | mkN "การประมาณค่า" ; -- src=panlex
lin qualification_N = mkN "คุณสมบัติ" | mkN "ข้อแม้" | mkN "คุณวุฒิ" | mkN "ข้อจํากัด" | mkN "ข้อบังคับ" | mkN "คุณสมบัติ" | mkN "ความเหมาะสม" ; -- src=panlex
lin pack_V2 = mkV2 "พก" ; ---- | mkV "พัน" | mkV "แบก" | mkV "แพ็ค" | mkV "อัดให้แน่น" | mkV "เอาขึ้นหลัง" | mkV "เดินทางแบกเป้" | mkV "อัดให้เป็นก้อน" | mkV "บรรจุ" | mkV "ใส่หีบห่อ" | mkV "เก็บของใส่กระเป๋า" ; -- src=panlex
lin pack_V = mkV "พก" | mkV "พัน" | mkV "แบก" | mkV "แพ็ค" | mkV "อัดให้แน่น" | mkV "เอาขึ้นหลัง" | mkV "เดินทางแบกเป้" | mkV "อัดให้เป็นก้อน" | mkV "บรรจุ" | mkV "ใส่หีบห่อ" | mkV "เก็บของใส่กระเป๋า" ; -- src=panlex
lin governor_N = mkN "หัวหน้ารัฐบาล" | mkN "ข้าหลวง" | mkN "ผู้ควบคุม" | mkN "ผู้ปกครอง" | mkN "เจ้าเมือง" | mkN "ผู้ว่าการรัฐ" | mkN "ผู้ว่าราชการ" | mkN "เครื่องควบคุมความเร็วของเครื่องยนต์" ; -- src=panlex
lin expected_A = mkA "ที่คาดหมายไว้" | mkA "ที่คาดหวังไว้" ; -- src=panlex
lin invest_V2 = mkV2 "ให้" ; ---- | mkV "ทุ่ม" | mkV "ลงทุน" | mkV "ประสาท" | mkV "มอบอำนาจ" | mkV "แต่งตั้ง" | mkV "มอบตำแหน่ง" | mkV "มอบ" | mkV "สละ" | mkV "ลงทุน" | mkV "แต่งตั้ง" | mkV "ให้อํานาจ" | mkV "ลงเงินเป็นทุนเพื่อหากําไร" ; -- src=panlex
lin invest_V = mkV "ให้" | mkV "ทุ่ม" | mkV "ลงทุน" | mkV "ประสาท" | mkV "มอบอำนาจ" | mkV "แต่งตั้ง" | mkV "มอบตำแหน่ง" | mkV "มอบ" | mkV "สละ" | mkV "ลงทุน" | mkV "แต่งตั้ง" | mkV "ให้อํานาจ" | mkV "ลงเงินเป็นทุนเพื่อหากําไร" ; -- src=panlex
lin cycle_N = mkN "รอบ" | mkN "วงจร" | mkN "รถถีบ" | mkN "จักรยาน" | mkN "วัฏจักร" | mkN "เฮิร์ตซ์" | mkN "รถจักรยาน" | mkN "รอบความถี่" | mkN "รอบต่อวินาที" | mkN "วง" | mkN "รอบ" | mkN "วงจร" | mkN "วงโคจร" | mkN "จักรยาน" | mkN "วัฎจักร" | mkN "วัฏจักร" | mkN "หมุนรอบ" | mkN "การหมุนเวียน" | mkN "ระยะเวลายาวนาน" | mkN "กระบวนการที่สมบูรณ์" ; -- src=panlex
lin alright_A = variants{} ; -- 
lin philosophy_N = mkN "ลัทธิ" | mkN "ปรัชญา" | mkN "แนวคิด" | mkN "สำนักคิด" | mkN "วิชาปรัชญา" | mkN "ระบบความคิด" | mkN "สำนักความคิด" | mkN "ปรัชญา" | mkN "ระบบปรัชญา" | mkN "วิชาปรัชญา" | mkN "หลักปรัชญา" | mkN "ระบบหลักการ" | mkN "สาขาวิชาทั้งหมด" | mkN "หลักความจริงของชีวิต" ; -- src=panlex
lin gallery_N = mkN "ระเบียง" | mkN "หอศิลป์" | mkN "อุโมงค์" | mkN "แกลเลอรี่" | mkN "ห้องโถงยาว" | mkN "ห้องแสดงภาพ" | mkN "ผู้ชมการแข่งขันกอล์ฟ" | mkN "ผู้ชมการแข่งขันเทนนิส" | mkN "คนดู" | mkN "ผู้ชม" | mkN "ดาดฟ้า" | mkN "เฉลียง" | mkN "ระเบียง" | mkN "สตูดิโอ" | mkN "หอศิลป์" | mkN "อุโมงค์" | mkN "ทางใต้ดิน" | mkN "เฉลียงภาพ" | mkN "ระเบียงบ้าน" | mkN "ห้องแสดงภาพ" | mkN "ทางเดินมีหลังคา" | mkN "ทางเข้าประตูบ้าน" | mkN "ห้องแสดงนิทรรศการ" | mkN "ห้องแสดงผลงานศิลปะ" | mkN "ห้องแสดงผลงานศิลปะห้องถ่ายรูป" ; -- src=panlex
lin sad_A = mkA "มอๆ" | mkA "หม่น" | mkA "ทุกข์" | mkA "สลดใจ" | mkA "เศร้า" | mkA "ตรอมใจ" | mkA "เสียใจ" | mkA "โทมนัส" | mkA "เศร้าโศก" | mkA "ทําให้เสียใจ" ; -- src=panlex
lin intervention_N = mkN "การไกล่เกลี่ย" | mkN "การรักษาพยาบาล" | mkN "การสอดเข้าแก้หน้า" | mkN "การยุ่ง" | mkN "การแทรกแซง" | mkN "การก้าวก่าย" ; -- src=panlex
lin emotional_A = mkA "ทางอารมณ์" | mkA "ด้วยอารมณ์" | mkA "มีอารมณ์" | mkA "ซึ่งเร้าอารมณ์" | mkA "เกี่ยวกับอารมณ์" | mkA "ถืออารมณ์เป็นใหญ่" | mkA "ซึ่งกระเทือนอารมณ์" | mkA "เกี่ยวกับความรู้สึก" | mkA "ซึ่งชอบใช้อารมณ์ตัดสิน" | mkA "ซึ่งอารมณ์เปลี่ยนแปลงง่าย" ; -- src=panlex
lin advertising_N = mkN "โฆษณา" | mkN "การโฆษณา" | mkN "ธุรกิจโฆษณา" | mkN "การโฆษณา" | mkN "คําโฆษณา" | mkN "งานโฆษณา" | mkN "สิ่งโฆษณา" | mkN "ธุรกิจโฆษณา" | mkN "สิ่งที่ใช้ในการโฆษณา" | mkN "อาชีพหรือธุรกิจการโฆษณา" ; -- src=panlex
lin regard_N = mkN "การจับจ้อง" | mkN "ความน่าเคารพ" | mkN "ความน่านับถือ" | mkN "ความปรารถนาดี" | mkN "ดู" | mkN "เพ่ง" | mkN "จ้องมอง" | mkN "ความสนใจ" | mkN "ความเคารพ" | mkN "การจ้องมอง" | mkN "ความเอาใจใส่" | mkN "ความเป็นที่นับถือ" ; -- src=panlex
lin dance_V2 = mkV2 "รำ" ; ---- | mkV "ดิ้น" | mkV "เต้น" | mkV "แดนซ์" | mkV "ร่ายรำ" | mkV "เต้นรำ" | mkV "เต้นระบำ" | mkV "กระโดดโลดเต้น" | mkV "จับระบำรำฟ้อน" | mkV "รำ" | mkV "รํา" | mkV "ฟ้อน" | mkV "เต้น" | mkV "ร่ายรํา" | mkV "เต้นรํา" | mkV "เต้นระบํา" | mkV "เต้นลีลาศ" | mkV "เคลื่อนไหวเหมือนเต้นรํา" ; -- src=panlex
lin dance_V = mkV "รำ" | mkV "ดิ้น" | mkV "เต้น" | mkV "แดนซ์" | mkV "ร่ายรำ" | mkV "เต้นรำ" | mkV "เต้นระบำ" | mkV "กระโดดโลดเต้น" | mkV "จับระบำรำฟ้อน" | mkV "รำ" | mkV "รํา" | mkV "ฟ้อน" | mkV "เต้น" | mkV "ร่ายรํา" | mkV "เต้นรํา" | mkV "เต้นระบํา" | mkV "เต้นลีลาศ" | mkV "เคลื่อนไหวเหมือนเต้นรํา" ; -- src=panlex
lin cigarette_N = mkN "ยาสูบ" | mkN "บุหรี่" | mkN "ซิกาแรต" | mkN "ยาซิกาแรต" | mkN "ยาสูบ" | mkN "บุหรี่" | mkN "ยากาแร็ต" ; -- src=panlex
lin predict_VS = variants{} ; -- 
lin predict_V2 = variants{} ; -- 
lin adequate_A = mkA "ที่เหมาะสม" | mkA "พอ" | mkA "พอแล้ว" | mkA "พอเพียง" | mkA "พอเหมาะ" | mkA "เพียงพอ" | mkA "เหมาะสม" | mkA "สามารถถึงขีด" | mkA "สามารถพอที่จะทําได้" ; -- src=panlex
lin variable_N = mkN "ตัวแปร" | mkN "ตัวแปร" ; -- src=panlex
lin net_N = mkN "กำไร" | mkN "เน็ต" | mkN "ตาข่าย" | mkN "ผลกำไร" | mkN "กำไรสุทธิ" | mkN "ประตูตาข่าย" | mkN "รายได้สุทธิ" | mkN "ไซเบอร์สเปซ" | mkN "รายได้สุทธิื" | mkN "อินเตอร์เน็ต" | mkN "อินเทอร์เน็ต" | mkN "แห" | mkN "ตาข่าย" | mkN "ร่างแห" | mkN "เครือข่าย" | mkN "ตาข่ายดักสัตว์" | mkN "เครือข่ายอินเตอร์เน็ต" ; -- src=panlex
lin retire_V2 = mkV2 "ถอน" ; ---- | mkV "นอน" | mkV "ปลด" | mkV "เลิก" | mkV "รีไทร์" | mkV "ล่าถอย" | mkV "เกษียณ" | mkV "ไล่ออก" | mkV "ดึงกลับ" | mkV "ปลีกตัว" | mkV "เข้านอน" | mkV "เลิกใช้" | mkV "เออร์ลี่" | mkV "ปลดเกษียณ" | mkV "เกษียณอายุ" | mkV "พักการประชุม" | mkV "ไล่ออกจากสนาม" | mkV "เออร์ลี่รีไทร์" | mkV "จากไป" | mkV "ออกไป" | mkV "ถอนตัว" | mkV "เกษียณ" | mkV "ปลีกตัว" | mkV "เข้านอน" | mkV "ปลดเกษียณ" | mkV "เกษียณอายุ" ; -- src=panlex
lin retire_V = mkV "ถอน" | mkV "นอน" | mkV "ปลด" | mkV "เลิก" | mkV "รีไทร์" | mkV "ล่าถอย" | mkV "เกษียณ" | mkV "ไล่ออก" | mkV "ดึงกลับ" | mkV "ปลีกตัว" | mkV "เข้านอน" | mkV "เลิกใช้" | mkV "เออร์ลี่" | mkV "ปลดเกษียณ" | mkV "เกษียณอายุ" | mkV "พักการประชุม" | mkV "ไล่ออกจากสนาม" | mkV "เออร์ลี่รีไทร์" | mkV "จากไป" | mkV "ออกไป" | mkV "ถอนตัว" | mkV "เกษียณ" | mkV "ปลีกตัว" | mkV "เข้านอน" | mkV "ปลดเกษียณ" | mkV "เกษียณอายุ" ; -- src=panlex
lin sugar_N = mkN "ตังค์" | mkN "น้ำตาล" | mkN "ปัจจัย" | mkN "สตางค์" | mkN "น้ำตาลทราย" | mkN "คาร์โบไฮเดรต" | mkN "สะตุ้งสตางค์" | mkN "เเป้งและน้ำตาล" | mkN "ที่รัก" | mkN "น้ำตาล" | mkN "น้ําตาล" | mkN "เฮโรอีน" | mkN "ถ้อยคําหวาน" | mkN "สารประกอบคาร์โบไฮเดรตมีรสหวาน" ; -- src=panlex
lin pale_A = mkA "โอบล้อม" | mkA "ไม่มีสี" | mkA "ไม้รั้ว" | mkA "ล้อมรั้ว" | mkA "ไม่มีชีวิตชีวา" ; -- src=panlex
lin frequency_N = mkN "ความถี่" | mkN "ความถี่สัมพัทธ์" | mkN "ความชุก" | mkN "ความถี่" | mkN "ความบ่อย" | mkN "อัตราการปรากฏ" | mkN "การเกิดขึ้นถี่" | mkN "อัตราการปรากฎขึ้น" ; -- src=panlex
lin guy_N = mkN "หนุ่ม" | mkN "เชือก" | mkN "ชายหนุ่ม" | mkN "พ่อหนุ่ม" | mkN "เชือกโยงเต็นท์" | mkN "คนนี้" | mkN "คนนั้น" | mkN "สายรัด" | mkN "หมอนั่น" | mkN "พ่อหนุ่ม" | mkN "เจ้านั่น" | mkN "เชือกรัด" | mkN "คนนั้นคนนี้" | mkN "เจ้าหมอนี่หมอโน่น" ; -- src=panlex
lin feature_V2 = variants{} ; -- 
lin furniture_N = mkN "เฟอร์" | mkN "เครื่องเรือน" | mkN "เฟอร์นิเจอร์" | mkN "เครื่องเรือน" | mkN "เฟอร์นิเจอร์" | mkN "เครื่องตกแต่งบ้าน" ; -- src=panlex
lin administrative_A = mkA "จัดการ" | mkA "ดําเนินการ" | mkA "เกี่ยวกับการบริหาร" | mkA "ซึ่งเกี่ยวกับการจัดการหรือบริหาร" ; -- src=panlex
lin wooden_A = mkA "ไม้" | mkA "เฉยเมย" | mkA "งุ่มง่าม" | mkA "เก้งก้าง" | mkA "แข็งทื่อ" | mkA "ทําด้วยไม้" | mkA "ประกอบด้วยไม้" | mkA "ไม่มีชีวิตชีวา" | mkA "ไม่มีอารมณ์ความรู้สึก" | mkA "ครบรอบปีที่5" | mkA "เป็นครั้งที่5" ; -- src=panlex
lin input_N = mkN "สิ่งเร้า" | mkN "ข้อคิดเห็น" | mkN "แรงกระตุ้น" | mkN "สิ่งกระตุ้น" | mkN "สัญญาณอินพุต" | mkN "ข้อมูล" | mkN "ทางเข้า" | mkN "ด้านเข้า" | mkN "การนําเข้า" | mkN "การป้อนเข้า" | mkN "การสนับสนุน" | mkN "กําลังโวลท์" | mkN "สิ่งที่ใส่เข้า" | mkN "สิ่งที่ป้อนเข้า" | mkN "กําลังกระแสไฟฟ้า" | mkN "ข้อมูลสําหรับแก้ปัญหา" | mkN "สิ่งของหรือเงินที่เข้ามาช่วยเหลือ" | mkN "ข้อมูลซึ่งป้อนเข้าสู่เครื่องคอมพิวเตอร์" ; -- src=panlex
lin phenomenon_N = mkN "ปรากฏการณ์" | mkN "ปรากฎการณ์" | mkN "ปรากฏการณ์" | mkN "ข้อเท็จจริง" | mkN "สิ่งประทับใจ" | mkN "สิ่งมหัศจรรย์" | mkN "สิ่งที่ประทับใจ" | mkN "บุคคลที่ประทับใจ" | mkN "สิ่งหรือคนพิสดาร" | mkN "ผู้มีความสามารถพิเศษ" ; -- src=panlex
lin surprising_A = mkA "น่าประหลาดใจ" | mkA "ทําให้ประหลาดใจ" | mkA "ไม่คาดคิดมาก่อน" ; -- src=panlex
lin jacket_N = mkN "ครอบฟัน" | mkN "แจ็คเก็ต" | mkN "เสื้อแจ็คเก็ต" | mkN "เปลือกมันฝรั่ง" | mkN "หุ้มห่อ" | mkN "แจ็คเก็ต" | mkN "สิ่งปกคลุม" | mkN "เปลือกหุ้ม" | mkN "เสื้อชั้นนอก" | mkN "เสื้อแจ๊คเก็ต" | mkN "กระดาษห่อหนังสือ" | mkN "กระดาษหุ้มหนังสือ" ; -- src=panlex
lin actor_N = variants{} ; -- 
lin actor_2_N = variants{} ; -- 
lin actor_1_N = variants{} ; -- 
lin kick_V2 = mkV2 "งด" ; ---- | mkV "บ่น" | mkV "เตะ" | mkV "เลิก" | mkV "ละเว้น" | mkV "เตะสูง" | mkV "พร่ำบ่น" | mkV "เตะ" ; -- src=panlex
lin kick_V = mkV "งด" | mkV "บ่น" | mkV "เตะ" | mkV "เลิก" | mkV "ละเว้น" | mkV "เตะสูง" | mkV "พร่ำบ่น" | mkV "เตะ" ; -- src=panlex
lin producer_N = mkN "คนทำ" | mkN "คนผลิต" | mkN "ผู้ผลิต" | mkN "แหล่งผลิต" | mkN "โปรดิวเซอร์" | mkN "ผู้ผลิต" | mkN "ผู้สร้าง" | mkN "ผู้ประกอบการ" | mkN "ผู้ควบคุมเวที" | mkN "ผู้ให้กําเนิด" | mkN "ผู้อํานวยการสร้างภาพยนต์" ; -- src=panlex
lin hearing_N = mkN "การฟัง" | mkN "โอกาสฟัง" | mkN "การรับฟัง" | mkN "การได้ยิน" | mkN "การฟัง" | mkN "การได้ยิน" | mkN "โสตประสาท" | mkN "การพิจารณา" | mkN "การพิจารณาคดี" | mkN "การรับรู้เสียง" | mkN "ระยะที่พอได้ยิน" | mkN "ความสามารถในการได้ยิน" | mkN "ระยะทางที่สามารถได้ยินเสียง" ; -- src=panlex
lin chip_N = mkN "ชิป" | mkN "รอย" | mkN "เศษ" | mkN "เบี้ย" | mkN "สะเก็ด" | mkN "รอยสลัก" | mkN "ไมโครชิป" | mkN "การชิพลูก" | mkN "เบี้ยพนัน" | mkN "เศษขี้วัว" | mkN "การกระเทาะ" | mkN "การแกะสลัก" | mkN "ขี้วัวแห้ง" | mkN "มันฝรั่งกรอบ" | mkN "มันฝรั่งแผ่น" | mkN "การเล่นลูกชิพ" | mkN "ชิ้นส่วนเล็กๆ" | mkN "มันฝรั่งทอดกรอบ" | mkN "มันฝรั่งแผ่นทอดกรอบ" | mkN "ชิพ" | mkN "เบี้ย" | mkN "การถาก" | mkN "การแกะ" | mkN "รอยแตก" | mkN "การสลัก" | mkN "รอยแหว่ง" | mkN "ไมโครชิป" | mkN "เศษที่แตกออก" | mkN "แผ่นไมโครชิป" | mkN "เศษที่บิ่นออก" | mkN "มันฝรั่งทอดแผ่นบางๆ" | mkN "เบี้ยที่ใช้แทนเงินในการเล่นพนัน" ; -- src=panlex
lin equation_N = mkN "สมการ" | mkN "ความเสมอภาค" | mkN "ความทัดเทียม" | mkN "ความเท่่าเทียม" | mkN "ความเท่าเทียมกัน" | mkN "สมการ" | mkN "ความสมดุล" | mkN "การทําให้เท่ากัน" | mkN "ความเท่าเทียมกัน" ; -- src=panlex
lin certificate_N = mkN "ใบรับรอง" | mkN "ประกาศนียบัตร" | mkN "หนังสือรับรอง" | mkN "ประกาศนียบัตร" | mkN "หนังสือรับรอง" | mkN "หลักฐานทางการเงิน" ; -- src=panlex
lin hello_Interj = variants{} ; -- 
lin remarkable_A = mkA "พิเศษ" | mkA "น่าคิด" | mkA "น่าทึ่ง" | mkA "ประหลาด" | mkA "น่าสังเกต" | mkA "ยอดเยี่ยม" | mkA "ไม่ธรรมดา" ; -- src=panlex
lin alliance_N = mkN "สหพันธ์" | mkN "สมาพันธ์" | mkN "การเกี่ยวดอง" | mkN "สมาชิก" | mkN "องค์กร" | mkN "สหพันธ์" | mkN "แนวร่วม" | mkN "พันธมิตร" | mkN "สมาพันธ์" | mkN "สันนิบาต" | mkN "การแต่งงาน" | mkN "ผู้สนับสนุน" | mkN "ความสัมพันธ์ใกล้ชิด" | mkN "ข้อตกลงระหว่างประเทศ" | mkN "ความสัมพันธ์ที่เกิดจากการแต่งงาน" ; -- src=panlex
lin smoke_V2 = mkV2 "พ่น" ; ---- | mkV "สูบ" | mkV "พ่นควัน" | mkV "สูบ" | mkV "ดูดควัน" | mkV "สูดควัน" | mkV "สูบบุหรี่" ; -- src=panlex
lin smoke_V = mkV "พ่น" | mkV "สูบ" | mkV "พ่นควัน" | mkV "สูบ" | mkV "ดูดควัน" | mkV "สูดควัน" | mkV "สูบบุหรี่" ; -- src=panlex
lin awareness_N = mkN "ความมีสติ" | mkN "ความตระหนัก" | mkN "ความตระหนักรู้" | mkN "การทราบ" | mkN "การรับรู้" | mkN "ความตระหนัก" ; -- src=panlex
lin throat_N = mkN "คอ" | mkN "คอหอย" | mkN "ช่องคอ" | mkN "คอ" | mkN "ทําคอ" | mkN "ลําคอ" | mkN "ช่องคอ" | mkN "ทางเข้า" | mkN "ส่วนหน้าของคอ" | mkN "ส่วนที่คล้ายคอ" | mkN "เสียงที่เปล่งจากคอ" ; -- src=panlex
lin discovery_N = mkN "การค้นพบ" | mkN "การค้นพบ" | mkN "การเปิดเผย" | mkN "การแสดงตัว" | mkN "สิ่งที่ค้นพบ" ; -- src=panlex
lin festival_N = mkN "ช่วงเทศกาล" | mkN "เทศกาล" | mkN "งานฉลอง" | mkN "วันเทศกาล" ; -- src=panlex
lin dance_N = mkN "ระบำ" | mkN "การเต้น" | mkN "ท่าเต้น" | mkN "การร่ายรำ" | mkN "การเต้นรำ" | mkN "งานเต้นรำ" | mkN "ศิลปะการเต้น" | mkN "การรํา" | mkN "งานบอล" | mkN "นาฏกรรม" | mkN "การลีลาศ" | mkN "งานลีลาศ" | mkN "นาฎศิลป์" | mkN "การฟ้อนรํา" | mkN "การร่ายรํา" | mkN "การเต้นรํา" | mkN "งานเต้นรํา" | mkN "การเต้นระบํา" | mkN "ศิลปการเต้นรํา" ; -- src=panlex
lin promise_N = mkN "การสัญญา" | mkN "การคาดหวัง" | mkN "การให้สัญญา" | mkN "การให้คำมั่นสัญญา" | mkN "สัญญา" | mkN "คําสัญญา" | mkN "คําปฏิญาณ" | mkN "คํามั่นสัญญา" | mkN "เป็นเครื่องบอก" | mkN "รับปากจะแต่งงาน" | mkN "ให้คํามั่นสัญญา" | mkN "" ; -- src=panlex
lin rose_N = mkN "กุหลาบ" | mkN "สีกุหลาบ" | mkN "ดอกกุหลาบ" | mkN "ต้นกุหลาบ" | mkN "สีดอกกุหลาบ" | mkN "ไวน์สีกุหลาบ" | mkN "กุหลาบ" | mkN "นางงาม" | mkN "สีกุหลาบ" | mkN "ดอกกุหลาบ" | mkN "ต้นกุหลาบ" | mkN "สีชมพูแดง" | mkN "ปลายหัวฝักบัวรดน้ํา" ; -- src=panlex
lin principal_A = mkA "ตัวการ" | mkA "ต้นทุน" | mkA "ประธาน" | mkA "ครูใหญ่" | mkA "รายใหญ่" | mkA "หัวหน้า" | mkA "เงินต้น" | mkA "อธิการบดี" | mkA "อันดับแรก" | mkA "ผู้ว่าอ้าง" | mkA "อันดับหนึ่ง" | mkA "ตัวการสําคัญ" | mkA "ผู้อํานวยการ" | mkA "สําคัญที่สุด" | mkA "เป็นส่วนใหญ่" | mkA "โครงร่างสําคัญ" | mkA "สําคัญมากกว่าอย่างอื่น" ; -- src=panlex
lin brilliant_A = mkA "สว่าง" | mkA "เจิดจ้า" | mkA "งดงาม" | mkA "สุกใส" | mkA "สวยงาม" | mkA "ฉลาดมาก" | mkA "พรายแสง" | mkA "ส่องแสง" | mkA "แพรวพราย" | mkA "แพรวพราว" | mkA "โชติช่วง" | mkA "พริ้งพราย" | mkA "หลักแหลมมาก" ; -- src=panlex
lin proposed_A = mkA "ซึ่งถูกเสนอ" ; -- src=panlex
lin coach_N = variants{} ; -- 
lin coach_3_N = variants{} ; -- 
lin coach_2_N = variants{} ; -- 
lin coach_1_N = variants{} ; -- 
lin absolute_A = mkA "สัมบูรณ์" | mkA "ล้วน" | mkA "เพียวๆ" | mkA "แน่นอน" | mkA "ทั้งหมด" | mkA "สมบูรณ์" | mkA "เด็ดขาด" | mkA "แท้จริง" | mkA "เผด็จการ" | mkA "ไม่จํากัด" | mkA "ไม่เจือปน" | mkA "ไม่มีขอบเขต" | mkA "อย่างแท้จริง" ; -- src=panlex
lin drama_N = mkN "บทละคร" | mkN "ละคร" | mkN "บทละคร" | mkN "บทวิทยุ" | mkN "บทโทรทัศน์" ; -- src=panlex
lin recording_N = mkN "การบันทึกเสียง" | mkN "สัญญาณที่ใช้บันทึก" | mkN "อุปกรณ์บันทึกข้อมูล" | mkN "บันทึก" | mkN "จานเสียง" | mkN "การบันทึก" | mkN "เทปบันทึก" | mkN "เทปบันทึกเสียง" | mkN "สิ่งที่บันทึกไว้" ; -- src=panlex
lin precisely_Adv = variants{} ; -- 
lin bath_N = mkN "บาธ" | mkN "อ่าง" | mkN "ห้องน้ำ" | mkN "ห้องสรง" | mkN "ห้องอาบน้ำ" | mkN "อ่างอาบน้ำ" | mkN "การอาบในอ่าง" | mkN "การอาบน้ำในอ่าง" | mkN "น้ําอาบ" | mkN "ห้องน้ํา" | mkN "การอาบน้ํา" | mkN "ถังอาบน้ํา" | mkN "ที่อาบน้ํา" | mkN "อ่างอาบน้ํา" | mkN "น้ําที่ใช้อาบ" | mkN "สถานที่อาบน้ํา" | mkN "การอาบน้ําเพื่อการรักษา" ; -- src=panlex
lin celebrate_V2 = variants{} ; -- 
lin substance_N = mkN "สาร" | mkN "สาระ" | mkN "แก่น" | mkN "เนื้อๆ" | mkN "ใจกลาง" | mkN "เนื้อหา" | mkN "คอนเท็นต์" | mkN "เนื้อเรื่อง" | mkN "แก่นความคิด" | mkN "สาร" | mkN "สสาร" | mkN "สาระ" | mkN "ใจความ" | mkN "ธาตุแท้" | mkN "ร่างกาย" | mkN "เงินทอง" | mkN "เนื้อหา" | mkN "แก่นสาร" | mkN "แก่นแท้" | mkN "เนื้อแท้" | mkN "ทรัพย์สิน" | mkN "ส่วนสําคัญ" | mkN "ความแน่นหนา" | mkN "เนื้อหาสาระ" | mkN "ใจความสําคัญ" | mkN "ความหมายสําคัญ" | mkN "เนื้อหนังมังสา" | mkN "วัตถุที่จับต้องได้" ; -- src=panlex
lin swing_V2 = mkV2 "สวิง" ; ---- | mkV "แกว่ง" | mkV "เหวี่ยง" | mkV "ขึ้นๆลงๆ" | mkV "เดินโยกเยก" | mkV "เหวี่ยงแขน" | mkV "มีจังหวะสวิง" | mkV "ห้อยต่องแต่ง" | mkV "ทำให้เอนเอียง" | mkV "เล่นจังหวะสวิง" | mkV "ใช้ชีวิตสมัยใหม่" | mkV "หมุน" | mkV "ห้อย" | mkV "แขวน" | mkV "แกว่ง" | mkV "หมุนวน" | mkV "หมุนรอบ" | mkV "แกว่งไปมา" ; -- src=panlex
lin swing_V = mkV "สวิง" | mkV "แกว่ง" | mkV "เหวี่ยง" | mkV "ขึ้นๆลงๆ" | mkV "เดินโยกเยก" | mkV "เหวี่ยงแขน" | mkV "มีจังหวะสวิง" | mkV "ห้อยต่องแต่ง" | mkV "ทำให้เอนเอียง" | mkV "เล่นจังหวะสวิง" | mkV "ใช้ชีวิตสมัยใหม่" | mkV "หมุน" | mkV "ห้อย" | mkV "แขวน" | mkV "แกว่ง" | mkV "หมุนวน" | mkV "หมุนรอบ" | mkV "แกว่งไปมา" ; -- src=panlex
lin for_Adv = variants{}; -- ss "ให้" | {-pan-} mkPrep "แก่" | mkPrep "แทน" | mkPrep "เพื่อ" | mkPrep "ไปยัง" | mkPrep "แลกกับ" | mkPrep "ในส่วน" | mkPrep "ให้กับ" | mkPrep "ให้แก่" | mkPrep "สําหรับ" | mkPrep "สนับสนุน" | mkPrep "เป็นระยะ" | mkPrep "เป็นเวลา" | mkPrep "เพราะว่า" | mkPrep "เห็นด้วย" | mkPrep "ในฐานะของ" | mkPrep "เป็นจํานวนเงิน" ; -- src=panlex
lin rapid_A = mkA "เร็ว" | mkA "ฉับไว" | mkA "ว่องไว" | mkA "ฉับพลัน" | mkA "รวดเร็ว" ; -- src=panlex
lin rough_A = mkA "ขรุขระ" | mkA "ซึ่งไม่เรียบ" | mkA "ที่ไม่ถูกตัด" | mkA "ที่ทำอย่างหยาบๆ" | mkA "สาก" | mkA "หยาบ" | mkA "เกเร" | mkA "จลาจล" | mkA "หยาบๆ" | mkA "เรียบ" | mkA "คร่าว ๆ" | mkA "ขรุขระ" | mkA "คร่าวๆ" | mkA "ตึงตัง" | mkA "รุนแรง" | mkA "ไม่สวย" | mkA "กระด้าง" | mkA "หยาบคาย" | mkA "ไม่เรียบ" | mkA "ทุรกันดาร" | mkA "ยากลําบาก" | mkA "มีขนรุงรัง" | mkA "เอะอะโวยวาย" | mkA "มีพายุรุนแรง" | mkA "ไม่ได้ตกแต่ง" | mkA "ไม่เป็นระเบียบ" | mkA "ไม่ได้เสริมแต่ง" | mkA "ยังไม่เสร็จเรียบร้อย" ; -- src=panlex
lin investor_N = mkN "นักลงทุน" | mkN "นักลงทุน" | mkN "ผู้ลงทุน" ; -- src=panlex
lin fire_V2 = mkV2 "ยิง" ; ---- | mkV "เผา" | mkV "ปลุก" | mkV "เร้า" | mkV "จุดไฟเผา" | mkV "ปลุกเร้า" | mkV "เลิกจ้าง" | mkV "เติมเชื้อเพลิง" | mkV "ก่อให้เกิดความรู้สึก" | mkV "ยิง" | mkV "ลั่น" | mkV "ก่อไฟ" | mkV "จุดไฟ" | mkV "ไล่ออก" | mkV "ปลุกเร้า" | mkV "เลิกจ้าง" | mkV "ไล่ออกจากงาน" | mkV "กระตุ้นอารมณ์" | mkV "เติมเชื้อเพลิง" ; -- src=panlex
lin fire_V = mkV "ยิง" | mkV "เผา" | mkV "ปลุก" | mkV "เร้า" | mkV "จุดไฟเผา" | mkV "ปลุกเร้า" | mkV "เลิกจ้าง" | mkV "เติมเชื้อเพลิง" | mkV "ก่อให้เกิดความรู้สึก" | mkV "ยิง" | mkV "ลั่น" | mkV "ก่อไฟ" | mkV "จุดไฟ" | mkV "ไล่ออก" | mkV "ปลุกเร้า" | mkV "เลิกจ้าง" | mkV "ไล่ออกจากงาน" | mkV "กระตุ้นอารมณ์" | mkV "เติมเชื้อเพลิง" ; -- src=panlex
lin rank_N = mkN "ขั้น" | mkN "จำนวนสมาชิก" | mkN "ฐานะทางสังคม" | mkN "สถานภาพทางสังคม" | mkN "ยศ" | mkN "แถว" | mkN "ขบวน" | mkN "ชนชั้น" | mkN "ตําแหน่ง" | mkN "ตําแหน่งทางสังคม" ; -- src=panlex
lin compete_V = mkV "แข่ง" | mkV "แข่งขัน" | mkV "แข่งขัน" ; -- src=panlex
lin sweet_A = mkA "สด" | mkA "จืด" | mkA "หวาน" | mkA "เพราะ" | mkA "ไพเราะ" | mkA "หอมหวาน" | mkA "อันงดงาม" | mkA "ที่น่าพึงใจ" | mkA "ที่มีรสหวาน" | mkA "แห่งเทพธิดา" | mkA "ที่ส่งกลิ่นหอม" | mkA "ที่เพิ่มความหวาน" | mkA "สด" | mkA "หอม" | mkA "เอม" | mkA "หวาน" | mkA "ใจดี" | mkA "งดงาม" | mkA "มธุรส" | mkA "มีค่า" | mkA "เพราะ" | mkA "ที่รัก" | mkA "น่ารัก" | mkA "มีรสดี" | mkA "รื่นหู" | mkA "สดใหม่" | mkA "ไพเราะ" | mkA "นิ่มนวล" | mkA "น่าพอใจ" | mkA "หอมหวาน" | mkA "ไม่เค็ม" | mkA "น่ายินดี" | mkA "มีน้ําใจ" | mkA "มีรสหวาน" | mkA "มีเสน่ห์" | mkA "น่าชื่นใจ" | mkA "น่าดึงดูด" | mkA "มีกลิ่นดี" | mkA "เป็นที่รัก" | mkA "ใส่น้ําตาล" | mkA "ไม่มีเกลือ" | mkA "ไม่ใส่เกลือ" | mkA "จัดการได้ง่าย" ; -- src=panlex
lin decline_VV = mkVV "แย่ลง" ; ---- | mkV "ปฏิเสธ" | mkV "ลาด" | mkV "ลดลง" | mkV "โทรม" | mkV "ลาดลง" | mkV "เลวลง" | mkV "เอียง" | mkV "แย่ลง" | mkV "ตกต่ํา" | mkV "บอกปัด" | mkV "ปฏิเสธ" | mkV "เสื่อม" | mkV "ไม่ยอมรับ" | mkV "ไม่รับสมัคร" ; -- src=panlex
lin decline_V2 = mkV2 "แย่ลง" ; ---- | mkV "ปฏิเสธ" | mkV "ลาด" | mkV "ลดลง" | mkV "โทรม" | mkV "ลาดลง" | mkV "เลวลง" | mkV "เอียง" | mkV "แย่ลง" | mkV "ตกต่ํา" | mkV "บอกปัด" | mkV "ปฏิเสธ" | mkV "เสื่อม" | mkV "ไม่ยอมรับ" | mkV "ไม่รับสมัคร" ; -- src=panlex
lin decline_V = mkV "แย่ลง" | mkV "ปฏิเสธ" | mkV "ลาด" | mkV "ลดลง" | mkV "โทรม" | mkV "ลาดลง" | mkV "เลวลง" | mkV "เอียง" | mkV "แย่ลง" | mkV "ตกต่ํา" | mkV "บอกปัด" | mkV "ปฏิเสธ" | mkV "เสื่อม" | mkV "ไม่ยอมรับ" | mkV "ไม่รับสมัคร" ; -- src=panlex
lin rent_N = mkN "รอยแยก" | mkN "ค่าเช่า" | mkN "ค่าเช่าทางเศรษฐกิจ" | mkN "รูขาด" | mkN "รูฉีก" | mkN "รอยขาด" | mkN "รอยฉีก" | mkN "รอยแยก" | mkN "การเช่า" | mkN "ค่าเช่า" | mkN "ทรัพย์สินที่ให้เช่า" ; -- src=panlex
lin dealer_N = mkN "บริษัท" | mkN "ผู้ค้า" | mkN "เอเยนต์" | mkN "คนแจกไพ่" | mkN "ดีลเลอร์" | mkN "ผู้แจกไพ่" | mkN "ตัวแทนจำหน่าย" | mkN "ผู้ซื้อขายในตลาดหุ้น" | mkN "พ่อค้า" | mkN "คนแจกไพ่" | mkN "นักธุรกิจ" | mkN "ผู้ติดต่อ" ; -- src=panlex
lin bend_V2 = mkV2 "งอ" ; ---- | mkV "ก้ม" | mkV "บิด" | mkV "หัก" | mkV "โค้ง" | mkV "ก้มตัว" | mkV "ค้อมตัว" | mkV "ทำให้งอ" | mkV "ทำให้โค้ง" | mkV "งอ" | mkV "ก้ม" | mkV "โค้ง" | mkV "โน้ม" | mkV "งอตัว" | mkV "หันเห" | mkV "ย่อตัว" | mkV "เหนี่ยว" | mkV "ทําให้ยอม" | mkV "ใจจดใจจ่อ" | mkV "ทําให้โค้ง" | mkV "ศิโรราบให้" | mkV "เปลี่ยนเส้นทาง" | mkV "ทําให้ค้อมหัวให้" | mkV "มีสมาธิต่องานที่ทํา" ; -- src=panlex
lin bend_V = mkV "งอ" | mkV "ก้ม" | mkV "บิด" | mkV "หัก" | mkV "โค้ง" | mkV "ก้มตัว" | mkV "ค้อมตัว" | mkV "ทำให้งอ" | mkV "ทำให้โค้ง" | mkV "งอ" | mkV "ก้ม" | mkV "โค้ง" | mkV "โน้ม" | mkV "งอตัว" | mkV "หันเห" | mkV "ย่อตัว" | mkV "เหนี่ยว" | mkV "ทําให้ยอม" | mkV "ใจจดใจจ่อ" | mkV "ทําให้โค้ง" | mkV "ศิโรราบให้" | mkV "เปลี่ยนเส้นทาง" | mkV "ทําให้ค้อมหัวให้" | mkV "มีสมาธิต่องานที่ทํา" ; -- src=panlex
lin solid_A = mkA "ตัน" | mkA "แข็ง" | mkA "แน่น" | mkA "ซึ่งแข็งแรง" | mkA "ที่เป็นของแข็ง" | mkA "ที่อุดมด้วยสารอาหาร" | mkA "แข็ง" | mkA "ของแข็ง" | mkA "ต่อเนื่อง" | mkA "มีสามมิติ" | mkA "มีลักษณะตัน" | mkA "ซึ่งไว้ใจได้" | mkA "ซึ่งไม่หยุดพัก" ; -- src=panlex
lin cloud_N = mkN (thword "เมฆ") | {-pan-} mkN "ฝูง" | mkN "เมฆ" | mkN "มลทิน" | mkN "ขี้เมฆ" | mkN "ปุยเมฆ" | mkN "ก้อนเมฆ" | mkN "ฝูงห่าน" | mkN "ม่านหมอก" | mkN "กลุ่มหมอกควัน" | mkN "ความขุ่นข้องหมองมัว" | mkN "เมฆ" | mkN "หมอก" | mkN "กลุ่มควัน" | mkN "สิ่งของจํานวนมากที่อยู่รวมกัน" ; -- src=panlex
lin across_Adv = mkAdv "ตรงข้าม" | mkAdv "ตามขวาง" | mkAdv "ทางขวาง" | mkAdv "ขวาง" | mkAdv "ข้าม" | mkAdv "ตลอด" | mkAdv "ทั่ว" | mkAdv "แนวนอน" | mkAdv "ตามขวาง" ; -- src=panlex
lin level_A = mkA "ไม่กะพริบ" | mkA "แบน" | mkA "คงที่" | mkA "เรียบ" | mkA "แบนราบ" | mkA "เท่ากัน" | mkA "เสมอกัน" | mkA "ราบเรียบ" | mkA "ระดับเดียวกัน" | mkA "ไม่เปลี่ยนแปลง" ; -- src=panlex
lin enquiry_N = mkN "การซักถาม" | mkN "การสอบถาม" | mkN "การไต่ถาม" | mkN "การค้นคว้า" | mkN "การสอบถาม" | mkN "การไต่สวน" | mkN "การขอข้อมูล" | mkN "การสืบสวนหาข้อเท็จจริง" ; -- src=panlex
lin fight_N = mkN "ไฟต์" | mkN "การรบ" | mkN "การแข่ง" | mkN "การสู้รบ" | mkN "การต่อสู้" | mkN "การสู้รบตบมือ" | mkN "ศึก" | mkN "สงคราม" | mkN "การต่อสู้" | mkN "การแข่งขัน" | mkN "การประชันขันแข่ง" ; -- src=panlex
lin abuse_N = mkN "การดูถูก" | mkN "การเย้ยหยัน" | mkN "การทารุณกรรม" | mkN "การใช้ในทางที่ผิด" | mkN "การข่มเหง" | mkN "การสบประมาท" | mkN "การกระทําทารุณ" | mkN "การใช้ในทางที่ผิด" | mkN "การปฏิบัติไม่ดีต่อ" ; -- src=panlex
lin golf_N = mkN "กอล์ฟ" | mkN "กีฬากอล์ฟ" | mkN "กอล์ฟ" | mkN "กีฬากอล์ฟ" ; -- src=panlex
lin guitar_N = mkN "กีตาร์" | mkN "กีตาร์" | mkN "เครื่องเล่นดนตรีประเภทดีด" ; -- src=panlex
lin electronic_A = mkA "เกี่ยวกับอิเล็กทรอนิกส์" | mkA "เกี่ยวกับระบบอิเล็กทรอนิกส์" | mkA "เกี่ยวกับวงจรอิเล็กทรอนิกส์" ; -- src=panlex
lin cottage_N = mkN "กระท่อม" | mkN "บังกะโล" | mkN "กระท่อม" | mkN "บ้านในชนบท" | mkN "บ้านพักเดี่ยว" | mkN "ที่พักตากอากาศหลังเล็กๆ" ; -- src=panlex
lin scope_N = mkN "ขอบเขต" | mkN "ออสซิลโลสโคป" | mkN "กล้องโทรทรรศน์" | mkN "วง" | mkN "วิถี" | mkN "วิสัย" | mkN "โอกาส" | mkN "ขอบเขต" | mkN "ลู่ทาง" | mkN "ขอบข่าย" | mkN "ความยาว" | mkN "วงจํากัด" | mkN "แนวสายตา" | mkN "กล้องส่อง" | mkN "ทัศนวิสัย" | mkN "กล้องจุลทรรศน์" | mkN "กล้องส่องทางไกล" | mkN "ความสามารถในการทําบางสิ่ง" ; -- src=panlex
lin pause_VS = mmkVS "พัก" ; ---- | mkV "ชะงัก" | mkV "ลังเล" | mkV "หยุดชะงัก" | mkV "หยุดคิด" | mkV "หยุดพัก" | mkV "หยุดนิ่ง" | mkV "หยุดชะงักชั่วคราว" ; -- src=panlex
lin pause_V2V = mmkV2V "พัก" ; ---- | mkV "ชะงัก" | mkV "ลังเล" | mkV "หยุดชะงัก" | mkV "หยุดคิด" | mkV "หยุดพัก" | mkV "หยุดนิ่ง" | mkV "หยุดชะงักชั่วคราว" ; -- src=panlex
lin pause_V = mkV "พัก" | mkV "ชะงัก" | mkV "ลังเล" | mkV "หยุดชะงัก" | mkV "หยุดคิด" | mkV "หยุดพัก" | mkV "หยุดนิ่ง" | mkV "หยุดชะงักชั่วคราว" ; -- src=panlex
lin mixture_N = mkN "การผสม" | mkN "สารผสม" | mkN "อาหารผสม" | mkN "การรวบรวม" | mkN "การผสมผสาน" | mkN "ของเบ็ดเตล็ด" | mkN "การผสม" | mkN "ของผสม" | mkN "สารผสม" | mkN "ส่วนผสม" | mkN "การรวมกัน" | mkN "การปนเปกัน" | mkN "ความหลากหลาย" | mkN "สภาพที่ผสมกัน" | mkN "สิ่งทอด้วยเส้นใยหลายสี" ; -- src=panlex
lin emotion_N = mkN "อารมณ์" | mkN "อารมณ์" | mkN "อาวรณ์" | mkN "ความรู้สึก" | mkN "ความสะเทือนใจ" | mkN "สิ่งที่ทําให้เกิดอารมณ์" ; -- src=panlex
lin comprehensive_A = mkA "ครอบคลุม" | mkA "กว้างขวาง" | mkA "ที่ครอบคลุม" | mkA "ซึ่งหยั่งรู้" | mkA "เข้าใจได้กว้าง" | mkA "ที่มีเนื้อหาครอบคลุม" ; -- src=panlex
lin shirt_N = mkN (thword "เสื้อ" "เชิ้ต")"ตัว" | {-pan-} mkN "เสื้อเชิ้ต" | mkN "เชิ้ต" | mkN "เสื้อ" | mkN "เสื้อเชิ้ต" | mkN "เสื้อชั้นใน" | mkN "เสื้อนอกสมัยก่อน" ; -- src=panlex ----?
lin allowance_N = mkN "ค่าต่าง" | mkN "การยินยอม" | mkN "ค่าเบี้ยเลี้ยง" | mkN "จัดสรร" | mkN "จัดให้" | mkN "ส่วนลด" | mkN "การอดทน" | mkN "การยอมทน" | mkN "งบประมาณ" | mkN "การยอมรับ" | mkN "การยินยอม" | mkN "ส่วนเสริม" | mkN "การพิจารณา" | mkN "ค่าใช้จ่าย" | mkN "เบี้ยเลี้ยง" | mkN "การอนุญาตให้" | mkN "ค่าเลี้ยงชีพ" | mkN "เงินส่วนแบ่ง" | mkN "เงินช่วยเหลือ" | mkN "เงินค่าใช้จ่าย" | mkN "สิ่งที่ได้รับส่วนแบ่ง" | mkN "ความคลาดเคลื่อนที่ยอมให้เกิดขึ้นได้" ; -- src=panlex
lin retirement_N = mkN "การปลดเกษียณ" | mkN "การเกษียณอายุ" | mkN "สถานภาพถูกไล่ออก" | mkN "การพ้นจากตำแหน่งหน้าที่" | mkN "การถอนตัว" | mkN "ความสันโดษ" | mkN "การปลดเกษียณ" | mkN "สถานที่สันโดษ" | mkN "การอยู่ตามลําพัง" | mkN "การอยู่อย่างสันโดษ" | mkN "การอยู่อย่างเงียบๆ" ; -- src=panlex
lin breach_N = mkN "การเปิด" | mkN "การฝ่าฝืน" | mkN "การแตกแยก" | mkN "ความแตกแยก" | mkN "ความแปลกแยก" | mkN "การทะเลาะเบาะแว้ง" | mkN "รอยแตก" ; -- src=panlex
lin infection_N = mkN "การติดเชื้อ" | mkN "การแพร่กระจายจากคนหนึ่งไปยังอีกคนหนึ่ง." | mkN "เชื้อ" | mkN "อิทธิพล" | mkN "การติดโรค" | mkN "โรคติดต่อ" | mkN "การติดเชื้อ" | mkN "การทําให้มัวหมอง" ; -- src=panlex
lin resist_VV = mkVV "ขัดขืน" ; ---- | mkV "ต่อต้าน" | mkV "ประท้วง" | mkV "ยืนหยัด" | mkV "ท้ากาลเวลา" | mkV "ต้าน" | mkV "อดทน" | mkV "ทนต่อ" | mkV "ขัดขวาง" | mkV "ต่อต้าน" | mkV "ต้านทาน" | mkV "อดกลั้น" ; -- src=panlex
lin resist_V2 = mkV2 "ขัดขืน" ; ---- | mkV "ต่อต้าน" | mkV "ประท้วง" | mkV "ยืนหยัด" | mkV "ท้ากาลเวลา" | mkV "ต้าน" | mkV "อดทน" | mkV "ทนต่อ" | mkV "ขัดขวาง" | mkV "ต่อต้าน" | mkV "ต้านทาน" | mkV "อดกลั้น" ; -- src=panlex
lin resist_V = mkV "ขัดขืน" | mkV "ต่อต้าน" | mkV "ประท้วง" | mkV "ยืนหยัด" | mkV "ท้ากาลเวลา" | mkV "ต้าน" | mkV "อดทน" | mkV "ทนต่อ" | mkV "ขัดขวาง" | mkV "ต่อต้าน" | mkV "ต้านทาน" | mkV "อดกลั้น" ; -- src=panlex
lin qualify_V2 = mkV2 "อธิบายลักษณะ" ; ---- | mkV "กำหนดเงื่อนไข" | mkV "มีคุณสมบัติเหมาะสม" | mkV "แก้ไข" | mkV "ดัดแปลง" | mkV "มีสิทธิ" | mkV "มีอํานาจ" | mkV "้เหมาะสม" | mkV "ทําให้มีคุณวุฒิ" | mkV "ทําให้มีคุณสมบัติ" | mkV "มีคุณสมบัติเหมาะสม" ; -- src=panlex
lin qualify_V = mkV "อธิบายลักษณะ" | mkV "กำหนดเงื่อนไข" | mkV "มีคุณสมบัติเหมาะสม" | mkV "แก้ไข" | mkV "ดัดแปลง" | mkV "มีสิทธิ" | mkV "มีอํานาจ" | mkV "้เหมาะสม" | mkV "ทําให้มีคุณวุฒิ" | mkV "ทําให้มีคุณสมบัติ" | mkV "มีคุณสมบัติเหมาะสม" ; -- src=panlex
lin paragraph_N = mkN "ย่อหน้า" | mkN "ตอน" | mkN "วรรค" | mkN "ย่อหน้า" | mkN "ข่าวสั้น" | mkN "ข้อความสั้น ๆ" | mkN "ตอนหนึ่งของข้อความ" ; -- src=panlex
lin sick_A = mkA "ป่วย" | mkA "อาพาท" | mkA "ประชวร" | mkA "เจ็บป่วย" | mkA "เจ็บไข้ได้ป่วย" | mkA "ซีด" | mkA "ป่วย" | mkA "คนไข้" | mkA "อมโรค" | mkA "เบื่อ" | mkA "เปราะ" | mkA "เอียน" | mkA "ขาวซีด" | mkA "ร้อนใจ" | mkA "เจ็บใจ" | mkA "ขยะแขยง" | mkA "เป็นโรค" | mkA "เป็นไข้" | mkA "ไม่สบาย" | mkA "คลื่นไส้" | mkA "รังเกียจ" | mkA "รําคาญใจ" | mkA "เจ็บป่วย" | mkA "ไม่สบายใจ" | mkA "คลื่นเหียน" | mkA "มีเชื้อโรค" | mkA "เสื่อมเสีย" | mkA "ได้พืชผลไม่ค่อยดี" ; -- src=panlex
lin near_A = mkA "ใกล้" | {-pan-} mkA "ที่เกือบเหมือน" | mkA "จวน" | mkA "ใกล้ๆ" | mkA "เกือบจะ" | mkA "ใกล้ชิด" | mkA "ใกล้เคียง" | mkA "ที่มีระยะทางใกล้กัน" | mkA "ที่มีความสัมพันธ์ใกล้ชิด" ; -- src=panlex
lin researcherMasc_N = variants{} ; -- 
lin consent_N = mkN "การอนุญาต" ; -- src=panlex
lin written_A = mkA "ที่บันทึกเป็นอักษร" | mkA "ที่เขียนเป็นบทละคร" | mkA "ที่เขียนเป็นสคริปต์" | mkA "ที่เป็นลายลักษณ์อักษร" ; -- src=panlex
lin literary_A = mkA "มีเนื้อหาสาระดี" | mkA "เกี่ยวกับวรรณคดี" | mkA "เกี่ยวกับหนังสือ" | mkA "เกี่ยวกับวรรณกรรม" | mkA "เกี่ยวกับการประพันธ์" | mkA "เกี่ยวกับผลงานวรรณคดี" | mkA "เกี่ยวกับผลงานประพันธ์" ; -- src=panlex
lin ill_A = mkA "ป่วย" | mkA "อาพาท" | mkA "ประชวร" | mkA "เจ็บป่วย" | mkA "เจ็บไข้ได้ป่วย" | mkA "เลว" | mkA "ไข้" | mkA "ชั่ว" | mkA "ป่วย" | mkA "ร้าย" | mkA "ผลร้าย" | mkA "โรคบาป" | mkA "ไม่ชอบ" | mkA "บาดเจ็บ" | mkA "ยุ่งยาก" | mkA "อันตราย" | mkA "เป็นโรค" | mkA "โชคร้าย" | mkA "ไม่สบาย" | mkA "ชั่วร้าย" | mkA "เจ็บป่วย" | mkA "เกลียดชัง" | mkA "ไม่ชํานาญ" | mkA "ไม่เหมาะสม" | mkA "น่ารังเกียจ" | mkA "ไม่เป็นมิตร" ; -- src=panlex
lin wet_A = mkA (thword "เปียก") | {-pan-} mkA "เปียก" | mkA "เมาหนัก" | mkA "เมาปลิ้น" | mkA "ซึ่งให้นม" | mkA "ที่ขายสุรา" | mkA "ซึ่งมีน้ำนม" | mkA "เมาหัวราน้ำ" | mkA "ที่มีสุราขาย" | mkA "ซึ่งอนุญาตให้ผลิตเครื่องดื่มแอลกอฮอล์" | mkA "แฉะ" | mkA "โชก" | mkA "เปียก" | mkA "ชื้นแฉะ" | mkA "ชุ่มไปด้วยน้ํา" | mkA "ซึ่งยังไม่แห้งดี" ; -- src=panlex
lin lake_N = mkN (thword "ทะ" "เล" "สาบ") | {-pan-} mkN "ทะเลสาบ" | mkN "ทะเลสาบ" | mkN "สีแดงเข้ม" | mkN "บ่อน้ํามัน" | mkN "บึงขนาดใหญ่" | mkN "บึงขนาดใหญ่มาก" ; -- src=panlex ----?
lin entrance_N = mkN "การเข้า" | mkN "ทางอ้อม" | mkN "ทางเข้า" | mkN "สิ่งที่เข้าถึง" | mkN "ประตู" | mkN "การเข้า" | mkN "ทางเข้า" | mkN "ประตูออก" | mkN "ประตูเข้า" | mkN "ปากทางเข้า" | mkN "การเข้าสนาม" | mkN "ทําให้งงงวย" | mkN "วิธีการเข้า" | mkN "การเริ่มลงมือ" | mkN "สิทธิในการเข้า" | mkN "การเข้าโรงเรียน" | mkN "การเข้ารับตําแหน่ง" ; -- src=panlex
lin peak_N = mkN "จุดยอด" | mkN "ยอดเขา" | mkN "ปลายแหลม" | mkN "จุดสูงสุด" | mkN "ระดับสูงสุด" | mkN "ปริมาณสูงสุด" | mkN "ช่วงเวลาออกดอกออกผล" | mkN "ช่วงเวลาที่ออกดอกสะพรั่ง" | mkN "ยอด" | mkN "จุดยอด" | mkN "ยอดดอย" | mkN "ยอดเขา" | mkN "จุดสุดยอด" | mkN "จุดสูงสุด" | mkN "ยอดสูงสุด" | mkN "ช่วงที่ให้ดอกผล" | mkN "ช่วงรุ่งเรืองที่สุด" | mkN "ช่วงที่เจริญเติบโตมากที่สุด" | mkN "ช่วงเวลาที่มีความต้องการมาก" ; -- src=panlex
lin successfully_Adv = variants{} ; -- 
lin sand_N = mkN (thword "ทราย") | {-pan-} mkN "ทราย" | mkN "ดินทราย" | mkN "ความหนักแน่น" | mkN "ทราย" | mkN "ดินทราย" | mkN "หาดทราย" | mkN "ใส่ทราย" | mkN "ฝังในทราย" | mkN "สันดอนทราย" | mkN "พรมด้วยทราย" | mkN "ขัดด้วยกระดาษทราย" ; -- src=panlex
lin breathe_V2 = mkV2 (thword "หาย" "ใจ") ; ---- | {-pan-} mkV "พัก" | mkV "หายใจ" | mkV "ขับกลิ่น" | mkV "มีลมหายใจ" | mkV "ปล่อยกลิ่น" | mkV "หายใจเข้าออก" | mkV "หายใจ" | mkV "พักผ่อน" | mkV "คลายเครียด" | mkV "พักเหนื่อย" | mkV "หยุดชั่วหายเหนื่อย" ; -- src=panlex
lin breathe_V = mkV (thword "หาย" "ใจ") | {-pan-} mkV "พัก" | mkV "หายใจ" | mkV "ขับกลิ่น" | mkV "มีลมหายใจ" | mkV "ปล่อยกลิ่น" | mkV "หายใจเข้าออก" | mkV "หายใจ" | mkV "พักผ่อน" | mkV "คลายเครียด" | mkV "พักเหนื่อย" | mkV "หยุดชั่วหายเหนื่อย" ; -- src=panlex
lin cold_N = mkN "หวัด" | mkN "ไข้หวัด" | mkN "ความหนาว" | mkN "ความเย็น" | mkN "อุณหภูมิต่ำ" | mkN "ตาย" | mkN "หนาว" | mkN "หวัด" | mkN "อ่อน" | mkN "เย็น" | mkN "เฉยเมย" | mkN "เย็นชา" | mkN "แน่ชัด" | mkN "ครบถ้วน" | mkN "โรคหวัด" | mkN "ไข้หวัด" | mkN "ไม่แยแส" | mkN "ความหนาว" | mkN "ความเย็น" | mkN "ไร้อารมณ์" | mkN "ความหนาวเย็น" | mkN "อุณหภูมิใต้ศูนย์องศา" ; -- src=panlex
lin cheek_N = mkN "แก้ม" | mkN "พระปราง" | mkN "ความกล้า" | mkN "เครื่องกีดขวาง" | mkN "ปราง" | mkN "แก้ม" | mkN "ความทะลึ่ง" | mkN "พฤติกรรมที่ทะลึ่ง" ; -- src=panlex
lin platform_N = mkN "แท่น" | mkN "แพลตฟอร์ม" | mkN "รองเท้าโชพีน" | mkN "เวที" | mkN "แท่น" | mkN "ฐานปืน" | mkN "ดาดฟ้า" | mkN "ยกพื้น" | mkN "แผนงาน" | mkN "ชานชาลา" | mkN "หลักการ" | mkN "แท่นยิง" | mkN "การปาฐกถา" | mkN "คําปราศรัย" | mkN "ชานชลาสถานี" | mkN "แท่นปืนใหญ่" | mkN "คําแถลงการณ์" | mkN "ชานชาลาสถานี" | mkN "การแสดงปาฐกถา" | mkN "การปราศรัยต่อมวลชน" | mkN "นโยบายของพรรคการเมือง" | mkN "เวทีสําหรับกล่าวคําปราศัย" | mkN "เวทีสําหรับกล่าวคําปราศรัย" | mkN "นโยบายพรรคที่แถลงก่อนการเลือกตั้ง" ; -- src=panlex
lin interaction_N = mkN "การมีปฏิสัมพันธ์" | mkN "การเกิดปฏิกิริยา" | mkN "ปฏิกิริยา" | mkN "การทํางานร่วมกัน" | mkN "การมีปฏิสัมพันธ์" | mkN "การสื่อสารระหว่างกัน" ; -- src=panlex
lin watch_N = mkN "ทหารยาม" | mkN "นาฬิกาพก" | mkN "คนเฝ้ายาม" | mkN "นาฬิกาพกพา" | mkN "ช่วงเฝ้ายาม" | mkN "ชม" | mkN "ดู" | mkN "ยาม" | mkN "เฝ้า" | mkN "คนยาม" | mkN "รอคอย" | mkN "กะเวลา" | mkN "การดูแล" | mkN "จ้องมอง" | mkN "เฝ้ายาม" | mkN "การเฝ้าดู" | mkN "การเฝ้ายาม" | mkN "ระมัดระวัง" | mkN "การเฝ้าระวัง" | mkN "นาฬิกาข้อมือ" | mkN "เวลาอยู่เวรในเรือ" ; -- src=panlex
lin borrow_VV = mkVV "ยืม" ; ---- | mkV "ขอยืม" | mkV "รับมาใช้" | mkV "กู้" | mkV "ยืม" | mkV "เข้า" | mkV "ขอยืม" | mkV "กู้ยืม" | mkV "รับเอา" | mkV "หยิบยืม" ; -- src=panlex
lin borrow_V2 = mkV2 "ยืม" ; ---- | mkV "ขอยืม" | mkV "รับมาใช้" | mkV "กู้" | mkV "ยืม" | mkV "เข้า" | mkV "ขอยืม" | mkV "กู้ยืม" | mkV "รับเอา" | mkV "หยิบยืม" ; -- src=panlex
lin borrow_V = mkV "ยืม" | mkV "ขอยืม" | mkV "รับมาใช้" | mkV "กู้" | mkV "ยืม" | mkV "เข้า" | mkV "ขอยืม" | mkV "กู้ยืม" | mkV "รับเอา" | mkV "หยิบยืม" ; -- src=panlex
lin birthday_N = mkN "ชาตะ" | mkN "วันเกิด" | mkN "เวลาตกฟาก" | mkN "วันประสูติ" | mkN "วันพระราชสมภพ" | mkN "วันคล้ายวันเกิด" | mkN "วันที่ลืมตาดูโลก" | mkN "วันเกิด" | mkN "วันครบรอบ" | mkN "วันคล้ายวันเกิด" ; -- src=panlex
lin knife_N = mkN "มีด" | mkN "ศาสตราวุธ" | mkN "อาวุธมีคม" | mkN "ดาบ" | mkN "ผ่า" | mkN "มีด" | mkN "กริช" | mkN "พร้า" | mkN "ใบมีด" | mkN "ดาบสั้น" | mkN "มีดพร้า" | mkN "อาวุธที่คล้ายมีด" ; -- src=panlex
lin extreme_A = mkA "สุดขีด" | mkA "ที่สุด" | mkA "ที่รุนแรงมาก" | mkA "ที่ร้ายแรงมาก" ; -- src=panlex
lin core_N = mkN "แกน" | mkN "สาระ" | mkN "แก่น" | mkN "เนื้อๆ" | mkN "ใจกลาง" | mkN "เนื้อหา" | mkN "ใจกลางโลก" | mkN "กลุ่มแกนนำ" | mkN "แก่นเรื่อง" | mkN "แก่นความคิด" | mkN "ใจความสำคัญ" | mkN "แกน" | mkN "แกนโลก" | mkN "แก่นแท้" | mkN "ไส้ผลไม้" | mkN "ส่วนในสุด" | mkN "กลุ่มเล็ก ๆ" | mkN "ส่วนสําคัญ" | mkN "บริษัทเล็ก ๆ" | mkN "แกนของผลไม้" | mkN "เอาส่วนในออก" | mkN "ใจความสําคัญ" | mkN "หน่วยความจําคอมพิวเตอร์" | mkN "ก้อนหินที่คนโบราณนํามาทุบเป็นเกล็ดใช้เป็นเครื่องมือ" ; -- src=panlex
lin peasantMasc_N = variants{} ; -- 
lin armed_A = mkA "ซึ่งมีแขน" | mkA "ซึ่งมีอาวุธ" | mkA "ซึ่งใช้กองกำลัง" | mkA "ติดอาวุธ" | mkA "ที่มีแขน" ; -- src=panlex
lin permission_N = mkN "การอนุญาต" | mkN "ใบอนุญาต" | mkN "การยินยอม" | mkN "การอนุญาต" | mkN "ใบอนุมัติ" | mkN "การอนุมัติ" | mkN "ความยินยอม" ; -- src=panlex
lin supreme_A = mkA "ชั้นเลิศ" | mkA "ที่สุด" | mkA "สุดขีด" | mkA "สุดยอด" | mkA "สูงสุด" | mkA "เหนือสุด" | mkA "สุดกําลัง" | mkA "สําคัญที่สุด" | mkA "มีอํานาจสูงสุด" | mkA "ยิ่งใหญ่ที่สุด" | mkA "ซึ่งอยู่ในระดับสูงสุด" | mkA "เกี่ยวกับรัฎฐาธิปัตย์" ; -- src=panlex
lin overcome_V2 = mkV2 "เอาชนะ" ; ---- | mkV "ควบคุมได้สำเร็จ" | mkV "ทำให้ร่างกายอ่อนแอ" | mkV "พิชิต" | mkV "มีชัย" | mkV "ปกคลุม" | mkV "เอาชนะ" | mkV "มีชัยต่อ" | mkV "ถูกข่มขวัญ" | mkV "ถูกครอบงํา" | mkV "ทําให้หมดกําลัง" ; -- src=panlex
lin overcome_V = mkV "เอาชนะ" | mkV "ควบคุมได้สำเร็จ" | mkV "ทำให้ร่างกายอ่อนแอ" | mkV "พิชิต" | mkV "มีชัย" | mkV "ปกคลุม" | mkV "เอาชนะ" | mkV "มีชัยต่อ" | mkV "ถูกข่มขวัญ" | mkV "ถูกครอบงํา" | mkV "ทําให้หมดกําลัง" ; -- src=panlex
lin greatly_Adv = mkAdv "อย่างมาก" | mkAdv "มาก" | mkAdv "เยอะ" | mkAdv "อย่างมาก" | mkAdv "อย่างสูง" | mkAdv "อย่างรุนแรง" ; -- src=panlex
lin visual_A = mkA "เข้าใจได้" | mkA "ที่เห็นได้" | mkA "มองเห็นได้" | mkA "ใช้ในการมอง" | mkA "เกี่ยวกับสายตา" | mkA "เกี่ยวกับการมอง" | mkA "เกี่ยวกับการเห็น" | mkA "เกี่ยวกับการมองเห็น" | mkA "เกี่ยวกับกําลังสายตา" | mkA "เกี่ยวกับจักษุประสาท" ; -- src=panlex
lin lad_N = mkN "พ่อ" | mkN "หนุ่ม" | mkN "เด็กชาย" | mkN "พ่อหนุ่ม" | mkN "เจ้าหนุ่ม" | mkN "เด็กหนุ่ม" | mkN "คนหนุ่ม" | mkN "อ้ายหนู" | mkN "พ่อหนุ่ม" | mkN "วัยหนุ่ม" | mkN "เด็กหนุ่ม" | mkN "คนเลี้ยงม้า" | mkN "พ่อหนุ่มน้อย" ; -- src=panlex
lin genuine_A = mkA "แท้" | mkA "แท้" | mkA "จริงใจ" | mkA "แท้จริง" | mkA "ไม่เสแสร้ง" | mkA "ซึ่งเป็นของแท้" | mkA "ซึ่งเป็นของจริง" ; -- src=panlex
lin personnel_N = mkN "แผนกบุคคล" | mkN "กลุ่มผู้ปฏิบัติงาน" | mkN "กลุ่มผู้ปฏิบัติหน้าที่" | mkN "บุคลากร" | mkN "พนักงาน" | mkN "ฝ่ายบุคคล" | mkN "แผนกบุคคล" | mkN "เจ้าหน้าที่" ; -- src=panlex
lin judgement_N = mkN "การตัดสิน" | mkN "วิจารณญาณ" | mkN "การประเมิน" | mkN "การพิพากษา" | mkN "การมองทะลุปรุโปร่ง" | mkN "พิพากษา" | mkN "ความเห็น" | mkN "การตัดสิน" | mkN "การคาดคะเน" | mkN "การประเมิน" | mkN "การพิจารณา" | mkN "การตัดสินใจ" | mkN "คําวินิจฉัย" | mkN "การตัดสินความ" | mkN "การพิจารณาคดี" | mkN "การลงความเห็น" | mkN "การพิจารณาอรรถคดี" ; -- src=panlex
lin exciting_A = mkA "เร้าอารมณ์" | mkA "น่าตื่นเต้น" | mkA "ที่น่าตื่นเต้น" | mkA "ที่ทําให้ตื่นเต้น" | mkA "ซึ่งทําให้ตื่นเต้น" | mkA "ที่เป็นสาเหตุให้ตื่นเต้น" ; -- src=panlex
lin stream_N = mkN "สาย" | mkN "กระแส" | mkN "การไหล" | mkN "ธารน้ำ" | mkN "สายน้ำ" | mkN "การไหลเป็นกระแส" | mkN "พุ่ง" | mkN "กระแส" | mkN "ลําธาร" | mkN "ลําแสง" | mkN "แม่น้ำ" | mkN "ธารน้ํา" | mkN "สายน้ํา" | mkN "แนวโน้ม" | mkN "หลั่งไหล" | mkN "ไหลเวียน" | mkN "กระแสน้ํา" | mkN "สะบัดพริ้ว" | mkN "ปลิวเป็นทาง" | mkN "แม่น้ําเล็ก ๆ" | mkN "การไหลต่อเนื่อง" | mkN "การไหลที่ต่อเนื่อง" ; -- src=panlex
lin perception_N = mkN "การรับรู้" | mkN "ญาน" | mkN "สัญญาน" | mkN "การรับรู้" | mkN "การเข้าใจ" | mkN "การแลเห็น" | mkN "การมองเห็น" | mkN "ความรู้สึก" | mkN "ความเข้าใจ" | mkN "แนวความคิด" | mkN "การหยั่งรู้" | mkN "ความตระหนัก" | mkN "การกําหนดรู้" | mkN "การกําหนดหมาย" | mkN "การแสดงความคิด" | mkN "สิ่งที่มองเห็น" | mkN "การรับรู้สัมผัส" | mkN "ความรู้สึกสัมผัส" ; -- src=panlex
lin guarantee_VS = mmkVS "อาสา" ; ---- | mkV "รับประกัน" | mkV "ทำให้แน่ใจ" | mkV "ประกัน" | mkV "รับรอง" | mkV "รับประกัน" | mkV "ค้ําประกัน" ; -- src=panlex
lin guarantee_V2 = mkV2 "อาสา" ; ---- | mkV "รับประกัน" | mkV "ทำให้แน่ใจ" | mkV "ประกัน" | mkV "รับรอง" | mkV "รับประกัน" | mkV "ค้ําประกัน" ; -- src=panlex
lin guarantee_V = mkV "อาสา" | mkV "รับประกัน" | mkV "ทำให้แน่ใจ" | mkV "ประกัน" | mkV "รับรอง" | mkV "รับประกัน" | mkV "ค้ําประกัน" ; -- src=panlex
lin disaster_N = mkN "กลียุค" | mkN "ความหายนะ" | mkN "เหตุการณ์เลวร้าย" | mkN "ความพินาศ" | mkN "ความล่มจม" | mkN "ความวินาศ" | mkN "ความหายนะ" | mkN "ภัยพิบัติ" | mkN "ความวิบัติ" | mkN "ความโชคร้าย" ; -- src=panlex
lin darkness_N = mkN "ที่มืด" | mkN "ความมืด" | mkN "ความมืดมน" | mkN "สีผิวคล้ำ" | mkN "ความมืด" ; -- src=panlex
lin bid_N = mkN "คำสั่ง" | mkN "การสั่ง" | mkN "การประมูล" | mkN "คำสั่งการ" | mkN "ความพยายาม" | mkN "การประกวดราคา" | mkN "การประมูล" | mkN "การให้ราคา" | mkN "การเสนอราคา" | mkN "การเรียกราคา" | mkN "จํานวนที่ให้ราคา" | mkN "ความพยายามที่จะทําบางสิ่ง" ; -- src=panlex
lin sake_N = variants{} ; -- 
lin sake_2_N = variants{} ; -- 
lin sake_1_N = variants{} ; -- 
lin organize_V2V = variants{} ; -- 
lin organize_V2 = variants{} ; -- 
lin tourist_N = mkN "ทัวริสต์" | mkN "คนมาเที่ยว" | mkN "นักท่องเที่ยว" | mkN "นักเดินทาง" | mkN "นักท่องเที่ยว" ; -- src=panlex
lin policeman_N = mkN (thword "ตำ" "รวจ")"คน" | {-pan-} mkN "ตร." | mkN "ตำรวจ" | mkN "นายตำรวจ" | mkN "เจ้าหน้าที่ตำรวจ" | mkN "ผู้พิทักษ์สันติราษฎร์" | mkN "ตํารวจ" | mkN "เจ้าหน้าที่ตํารวจ" | mkN "ผู้พิทักษ์สันติราษฎร์" ; -- src=panlex
lin castle_N = mkN "เรือ" | mkN "ปราสาท" | mkN "ป้อมปราการ" | mkN "ปราสาท" | mkN "คฤหาสน์" | mkN "พระราชวัง" | mkN "ป้อมปราการ" | mkN "ตัวเรือในเกมหมากรุก" ; -- src=panlex
lin figure_VS = mmkVS "กะ" ; ---- | mkV "คำนวณ" | mkV "คิดเลข" | mkV "นึกภาพ" | mkV "ประมาณ" | mkV "เข้าใจ" | mkV "เห็นภาพ" | mkV "คิดคำนวณ" | mkV "นึกถึง" | mkV "ฝันถึง" | mkV "วาดภาพ" | mkV "วาดรูป" | mkV "คาดคะเน" | mkV "ประเมิน" | mkV "คิดคํานวน" | mkV "จินตนาการ" | mkV "มีส่วนร่วม" | mkV "เป็นส่วนสําคัญ" ; -- src=panlex
lin figure_V = mkV "กะ" | mkV "คำนวณ" | mkV "คิดเลข" | mkV "นึกภาพ" | mkV "ประมาณ" | mkV "เข้าใจ" | mkV "เห็นภาพ" | mkV "คิดคำนวณ" | mkV "นึกถึง" | mkV "ฝันถึง" | mkV "วาดภาพ" | mkV "วาดรูป" | mkV "คาดคะเน" | mkV "ประเมิน" | mkV "คิดคํานวน" | mkV "จินตนาการ" | mkV "มีส่วนร่วม" | mkV "เป็นส่วนสําคัญ" ; -- src=panlex
lin race_VV = mkVV "รี่" ; ---- | mkV "เร่ง" | mkV "แข่ง" | mkV "วิ่งแข่ง" | mkV "ทำงานแข่ง" | mkV "เร่งรีบ" | mkV "วิ่งแข่ง" | mkV "วิ่งอย่างเร็ว" | mkV "รีบไปอย่างรวดเร็ว" ; -- src=panlex
lin race_V2V = mmkV2V "รี่" ; ---- | mkV "เร่ง" | mkV "แข่ง" | mkV "วิ่งแข่ง" | mkV "ทำงานแข่ง" | mkV "เร่งรีบ" | mkV "วิ่งแข่ง" | mkV "วิ่งอย่างเร็ว" | mkV "รีบไปอย่างรวดเร็ว" ; -- src=panlex
lin race_V2 = mkV2 "รี่" ; ---- | mkV "เร่ง" | mkV "แข่ง" | mkV "วิ่งแข่ง" | mkV "ทำงานแข่ง" | mkV "เร่งรีบ" | mkV "วิ่งแข่ง" | mkV "วิ่งอย่างเร็ว" | mkV "รีบไปอย่างรวดเร็ว" ; -- src=panlex
lin race_V = mkV "รี่" | mkV "เร่ง" | mkV "แข่ง" | mkV "วิ่งแข่ง" | mkV "ทำงานแข่ง" | mkV "เร่งรีบ" | mkV "วิ่งแข่ง" | mkV "วิ่งอย่างเร็ว" | mkV "รีบไปอย่างรวดเร็ว" ; -- src=panlex
lin demonstration_N = mkN "การสาธิต" | mkN "การพิสูจน์" | mkN "ตัวอย่างผลงาน" | mkN "การแสดงกำลังทหาร" | mkN "การแสดงความรู้สึก" | mkN "การแสดงออกของสังคม" | mkN "การทดลอง" | mkN "การสาธิต" | mkN "การอธิบาย" | mkN "การประท้วง" | mkN "การพิสูจน์" | mkN "การเดินขบวน" | mkN "การให้เหตุผล" | mkN "การแสดงให้เห็น" ; -- src=panlex
lin anger_N = mkN "ความโกรธ" | mkN "อารมณ์โกรธ" | mkN "ความรู้สึกโกรธ" | mkN "ฉิว" | mkN "โทสะ" | mkN "เคือง" | mkN "ความโกรธ" | mkN "ความเคือง" | mkN "ความฉุนเฉียว" ; -- src=panlex
lin briefly_Adv = variants{} ; -- 
lin presumably_Adv = mkAdv "ตามสมมติฐาน" ; -- src=panlex
lin clock_N = mkN "นาฬิกา" | mkN "นาฬิกา" ; -- src=panlex
lin hero_N = mkN "ฮีโร่" | mkN "ตัวพระ" | mkN "นักสู้" | mkN "พระเอก" | mkN "วีรบุรุษ" | mkN "นักต่อสู้" | mkN "แซนด์วิชยักษ์" | mkN "แซนด์วิชอิตาลี" | mkN "คนเก่ง" | mkN "พระเอก" | mkN "วีรบุรุษ" ; -- src=panlex
lin expose_V2 = mkV2 "แสดง" ; ---- | mkV "โดนแสง" | mkV "เปิดเผย" | mkV "ได้รับแสง" | mkV "ทำให้พ่ายแพ้" | mkV "เผยออกมา" | mkV "โผล่ออกมา" | mkV "ปรากฏออกมา" | mkV "เปิดเผยออกมา" | mkV "เปิดเผยความผิดของคนอื่น" ; -- src=panlex
lin expose_V = mkV "แสดง" | mkV "โดนแสง" | mkV "เปิดเผย" | mkV "ได้รับแสง" | mkV "ทำให้พ่ายแพ้" | mkV "เผยออกมา" | mkV "โผล่ออกมา" | mkV "ปรากฏออกมา" | mkV "เปิดเผยออกมา" | mkV "เปิดเผยความผิดของคนอื่น" ; -- src=panlex
lin custom_N = mkN "ภาษีอากร" | mkN "ธรรมเนียม" | mkN "ขนบธรรมเนียม" | mkN "การปฏิบัติตาม" | mkN "พิกัดอัตราภาษีอากร" | mkN "พิกัดอัตราภา่ษีอากร" | mkN "กิจวัตร" | mkN "ประเพณี" | mkN "ธรรมเนียม" | mkN "การอุดหนุน" | mkN "ความเคยชิน" | mkN "ขนบธรรมเนียม" | mkN "จารีตประเพณี" | mkN "ธรรมเนียมปฏิบัติ" ; -- src=panlex
lin maximum_A = mkA "สูงสุด" | mkA "มากที่สุด" | mkA "สูงสุด" | mkA "ใหญ่สุด" | mkA "มากที่สุด" ; -- src=panlex
lin wish_N = mkN "ความปราถนา" | mkN "ความต้องการ" | mkN "ความประสงค์" | mkN "ความปรารถนาดี" | mkN "สั่ง" | mkN "หวัง" | mkN "อวยพร" | mkN "ให้พร" | mkN "ต้องการ" | mkN "ประสงค์" | mkN "ปรารถนา" | mkN "อยากให้" | mkN "ความอยาก" | mkN "ความต้องการ" | mkN "ความประสงค์" | mkN "ความปรารถนา" | mkN "สิ่งที่ปรารถนา" ; -- src=panlex
lin earning_N = mkN "การหามา" | mkN "การหารายได้" ; -- src=panlex
lin priest_N = mkN (thword "นัก" "บวช")"รูป" | {-pan-} mkN "พระ" | mkN "พระ" | mkN "นักบวช" | mkN "บาทหลวง" | mkN "พระสงฆ์" | mkN "พระสอนศาสนา" ; -- src=panlex
lin resign_V2 = mkV2 "พอ" ; ---- | mkV "ออก" | mkV "ยินยอม" | mkV "วางมือ" | mkV "ออกจากงาน" | mkV "สมัครใจลาออก" | mkV "ออกจากตำแหน่ง" | mkV "รับผิดชอบด้วยการลาออก" | mkV "แสดงความรับผิดชอบด้วยการลาออก" | mkV "ยอม" | mkV "สละ" | mkV "ลาออก" | mkV "ลาออกจากตําแหน่ง" ; -- src=panlex
lin resign_V = mkV "พอ" | mkV "ออก" | mkV "ยินยอม" | mkV "วางมือ" | mkV "ออกจากงาน" | mkV "สมัครใจลาออก" | mkV "ออกจากตำแหน่ง" | mkV "รับผิดชอบด้วยการลาออก" | mkV "แสดงความรับผิดชอบด้วยการลาออก" | mkV "ยอม" | mkV "สละ" | mkV "ลาออก" | mkV "ลาออกจากตําแหน่ง" ; -- src=panlex
lin store_V2 = variants{} ; -- 
lin widespread_A = mkA "แพร่หลาย" | mkA "กระจาย" | mkA "กางออก" | mkA "ขยายออก" | mkA "แพร่หลาย" | mkA "กว้างขวาง" | mkA "แพร่ไปทั่ว" ; -- src=panlex
lin comprise_V2 = variants{} ; -- 
lin chamber_N = mkN "สภา" | mkN "ห้อง" | mkN "ห้องนอน" | mkN "ห้องพิพากษา" | mkN "ห้องพระบรรทม" | mkN "ที่หลับที่นอน" | mkN "สภา" | mkN "ช่อง" | mkN "ห้อง" | mkN "โพรง" | mkN "สมาคม" | mkN "หอการค้า" | mkN "จัดห้องให้" | mkN "ห้องประชุม" | mkN "ลํากล้องปืน" | mkN "ห้องพักเดี่ยว" | mkN "ลํากล้องกระสุน" | mkN "สํานักงานทนายความ" | mkN "ห้องหรือช่องว่างในร่างกาย" ; -- src=panlex
lin acquisition_N = mkN "สกิล" | mkN "ทักษะ" | mkN "สิ่งที่ได้มา" | mkN "กระบวนการเรียนรู้" | mkN "การได้มา" | mkN "สิ่งที่ได้มา" | mkN "การพัฒนาทักษะ" | mkN "สิ่งที่เพิ่มเติม" | mkN "การได้มาซึ่งการเข้าถือสิทธิ์" | mkN "การตรวจหาที่ตั้งโดยเครื่องมืออื่นๆ" ; -- src=panlex
lin involved_A = mkA "ซึ่งเกี่ยวข้อง" | mkA "หมกมุ่น" | mkA "ี่ซับซ้อน" | mkA "ซึ่งพัวพัน" | mkA "เอาใจจดจ่อ" | mkA "ที่เอาใจใส่" | mkA "ซึ่งเข้าใจยาก" | mkA "ที่เกี่ยวข้อง" | mkA "ซึ่งเกี่ยวข้อง" ; -- src=panlex
lin confident_A = mkA "กล้า" | mkA "มั่นใจ" | mkA "ซึ่งไว้วางใจ" ; -- src=panlex
lin circuit_N = mkN "วงจร" | mkN "ทัวร์" | mkN "วงจรไฟฟ้า" | mkN "การหมุนรอบ" | mkN "สนามแข่งรถ" | mkN "เขตอำนาจศาล" | mkN "สนามความเร็ว" | mkN "การท่องเที่ยว" | mkN "กำหนดการจัดงาน" | mkN "เรซซิ่งเซอร์กิต" | mkN "เขตอำนาจศาลในสหรัฐอเมริกา" | mkN "ขอบเขต" | mkN "การโคจรรอบ" | mkN "พื้นที่ที่จํากัดเขตไว้" ; -- src=panlex
lin radical_A = mkA "มูลฐาน" | mkA "รากฐาน" | mkA "รุนแรง" | mkA "สุดขีด" | mkA "ทั่วถึง" | mkA "สมุฎฐาน" | mkA "โดยตลอด" | mkA "หัวรุนแรง" | mkA "โดยมูลฐาน" | mkA "โดยรากฐาน" | mkA "โดยพื้นฐาน" | mkA "ถึงรากถึงโคน" | mkA "ซึ่งแผ่ไปทั่ว" | mkA "ซึ่งเปลี่ยนแปลงครั้งใหญ่" ; -- src=panlex
lin detect_V2 = variants{} ; -- 
lin stupid_A = mkA "โง่" | {-pan-} mkA "ที่ไม่มีปัญญา" | mkA "ที่ไร้สติปัญญา" | mkA "ที่ไม่มีสติปัญญา" | mkA "ทึ่ม" | mkA "เง่า" | mkA "เซ่อ" | mkA "งงงวย" | mkA "บัดซบ" | mkA "มึนงง" | mkA "กึ่งสลบ" | mkA "หงอยซึม" | mkA "โฉดเขลา" | mkA "ไร้สมอง" | mkA "ไร้สาระ" | mkA "ตะลึงงัน" | mkA "เชื่องช้า" | mkA "ไร้หัวคิด" | mkA "ไม่น่าสนใจ" | mkA "ไม่มีรสชาติ" | mkA "น่าเบื่อหน่าย" ; -- src=panlex
lin grand_A = mkA "งดงาม" | mkA "มหึมา" | mkA "อวดดี" | mkA "โอหัง" | mkA "หรูหรา" | mkA "โอ่อ่า" | mkA "ใหญ่โต" | mkA "ผึ่งผาย" | mkA "สง่างาม" | mkA "สมบูรณ์" | mkA "ดีเยี่ยม" | mkA "ชั้นหนึ่ง" | mkA "น่านับถือ" | mkA "สําคัญมาก" | mkA "น่าเกรงขาม" | mkA "ซึ่งมีอํานาจ" | mkA "เป็นที่เคารพ" | mkA "1000 ดอล-ลาร์" ; -- src=panlex
lin consumption_N = mkN "การกิน" | mkN "การใช้" | mkN "วัณโรค" | mkN "การบริโภค" | mkN "วัณโรคปอด" | mkN "กา่รบริโภคสินค้าและบริการ" | mkN "วัณโรค" | mkN "การบริโภค" | mkN "การเผาผลาญ" | mkN "การใช้หมดไป" | mkN "ปริมาณการบริโภค" | mkN "โรคที่ทําให้ร่างกายเสื่อมโทรม" ; -- src=panlex
lin hold_N = mkN "คัน" | mkN "ด้าม" | mkN "การจับ" | mkN "ที่จับ" | mkN "มือจับ" | mkN "หูหิ้ว" | mkN "ด้ามจับ" | mkN "ช่วงเวลารอคอย" | mkN "ห้องเก็บสินค้่า" | mkN "การอยู่ในอารักขา" | mkN "คุก" | mkN "การจับ" | mkN "การดูแล" | mkN "การเกาะ" | mkN "การควบคุม" | mkN "การจับไว้" | mkN "พันธนาการ" | mkN "การครอบงํา" | mkN "การคว้าไว้" | mkN "การเกาะกุม" | mkN "การครอบคลุม" | mkN "การทําให้ล่าช้า" | mkN "การทําให้หยุดชะงัก" | mkN "ระวางบรรทุกสินค้าในเรือหรือเครื่องบิน" | mkN "พื้นที่ที่ใช้เก็บสินค้าในเรือหรือเครื่องบิน" ; -- src=panlex
lin zone_N = mkN "เขต" | mkN "แดน" | mkN "โซน" | mkN "บริเวณ" | mkN "เขตวงรอบ" | mkN "ภาค" | mkN "เขต" | mkN "แถบ" | mkN "โซน" | mkN "บริเวณ" | mkN "พื้นที่" | mkN "เขตเวลา" ; -- src=panlex
lin mean_A = mkA "โดยเฉลี่ย" | mkA "สกปรก" | mkA "ใจดํา" | mkA "ใจแคบ" | mkA "ซอมซ่อ" | mkA "ใจร้าย" | mkA "เลวทราม" | mkA "โหดร้าย" | mkA "ทรุดโทรม" | mkA "ขะมุกขมอม" ; -- src=panlex
lin altogether_Adv = mkAdv "อย่างสมบูรณ์" | mkAdv "รวมทั้งหมดแล้ว" | mkAdv "ด้วยประการทั้งปวง" | mkAdv "แน่นอน" | mkAdv "ทั้งหมด" | mkAdv "โดยสรุป" | mkAdv "ทั้งสิ้น" | mkAdv "พร้อมกัน" | mkAdv "โดยสิ้นเชิง" | mkAdv "รวมทั้งสิ้นเป็น" | mkAdv "ด้วยประการทั้งปวง" ; -- src=panlex
lin rush_VV = mkVV "รีบ" ; ---- | mkV "รี่" | mkV "เร่ง" | mkV "ให้ไว" | mkV "จู่โจม" | mkV "วิ่งพาลูก" | mkV "จู่โจมทันที" | mkV "วิ่ง" | mkV "เร่ง" | mkV "โจมตี" | mkV "จู่โจม" | mkV "ผลักไส" | mkV "รีบเร่ง" | mkV "พรวดพราด" | mkV "พาหรือนําไปอย่างรีบเร่ง" ; -- src=panlex
lin rush_V2 = mkV2 "รีบ" ; ---- | mkV "รี่" | mkV "เร่ง" | mkV "ให้ไว" | mkV "จู่โจม" | mkV "วิ่งพาลูก" | mkV "จู่โจมทันที" | mkV "วิ่ง" | mkV "เร่ง" | mkV "โจมตี" | mkV "จู่โจม" | mkV "ผลักไส" | mkV "รีบเร่ง" | mkV "พรวดพราด" | mkV "พาหรือนําไปอย่างรีบเร่ง" ; -- src=panlex
lin rush_V = mkV "รีบ" | mkV "รี่" | mkV "เร่ง" | mkV "ให้ไว" | mkV "จู่โจม" | mkV "วิ่งพาลูก" | mkV "จู่โจมทันที" | mkV "วิ่ง" | mkV "เร่ง" | mkV "โจมตี" | mkV "จู่โจม" | mkV "ผลักไส" | mkV "รีบเร่ง" | mkV "พรวดพราด" | mkV "พาหรือนําไปอย่างรีบเร่ง" ; -- src=panlex
lin numerous_A = mkA "มาก" | mkA "มีมาก" | mkA "มากมาย" | mkA "เยอะแยะ" ; -- src=panlex
lin sink_V2 = mkV2 "จม" ; ---- | mkV "ทรุด" | mkV "ดำดิ่ง" | mkV "คุกเข่า" | mkV "หล่นฮวบ" | mkV "ทรุดหนัก" | mkV "หมกหมุ่น" | mkV "ทรุดตัวลง" | mkV "จม" | mkV "ตกลง" | mkV "ลดลง" | mkV "ต่ําลง" | mkV "ทําให้จม" ; -- src=panlex
lin sink_V = mkV "จม" | mkV "ทรุด" | mkV "ดำดิ่ง" | mkV "คุกเข่า" | mkV "หล่นฮวบ" | mkV "ทรุดหนัก" | mkV "หมกหมุ่น" | mkV "ทรุดตัวลง" | mkV "จม" | mkV "ตกลง" | mkV "ลดลง" | mkV "ต่ําลง" | mkV "ทําให้จม" ; -- src=panlex
lin everywhere_Adv = ss (thword "ทุก" "ที") | {-pan-} mkAdv "ทุกหนทุกแห่ง" | mkAdv "ทุกที่" | mkAdv "ทุกหนแห่ง" ; -- src=panlex
lin classical_A = mkA "คลาสสิค" | mkA "ดีเด่น" | mkA "ชั้นหนึ่ง" | mkA "เป็นแนวหน้า" | mkA "ชื่อเสียงโด่งดัง" | mkA "ที่เป็นเพลงคลาสสิค" | mkA "ที่เป็นแบบดั้งเดิม" | mkA "เป็นมรดกตกทอดแต่โบราณ" | mkA "เป็นแบบฉบับที่เชื่อถือได้" | mkA "เกี่ยวกับวรรณคดีสมัยคลาสซิค" | mkA "เกี่ยวกับแบบกรีกและโรมันโบราณ" | mkA "ที่เกี่ยวกับกรีกหรือโรมันโบราณ" ; -- src=panlex
lin respectively_Adv = variants{} ; -- 
lin distinct_A = mkA "หายาก" | mkA "ชัดเจน" | mkA "เจาะจง" | mkA "แน่นอน" | mkA "จําเพาะ" | mkA "แตกต่าง" | mkA "แจ่มแจ้ง" | mkA "น่าสังเกต" | mkA "แยกกันชัดเจน" | mkA "แตกต่างชัดเจน" ; -- src=panlex
lin mad_A = mkA "โง่ๆ" | mkA "ฉุน" | mkA "บ้า" | mkA "โกรธ" | mkA "โมโห" | mkA "คลั่ง" | mkA "หลงใหล" | mkA "โง่มาก" | mkA "วิกลจริต" | mkA "สติไม่ดี" | mkA "ไร้เหตุผล" | mkA "ร่าเริงมาก" | mkA "โง่เง่ามาก" | mkA "ตื่นเต้นมาก" | mkA "ไม่มีเหตุผล" | mkA "กระตือรือร้นมาก" ; -- src=panlex
lin honour_N = mkN "รางวัล" | mkN "เกียรติ" | mkN "พรหมจารี" | mkN "ศักดิ์ศรี" | mkN "เกียรติยศ" | mkN "นับถือ" | mkN "เกียรติ" | mkN "ยศศักดิ์" | mkN "ความเคารพ" | mkN "ชื่อเสียง" | mkN "ศักดิ์ศรี" | mkN "เกียรติยศ" | mkN "เหรียญตรา" | mkN "ความนับถือ" | mkN "เกียรติศักดิ์" | mkN "ให้เกียรติแก่กัน" | mkN "จ่ายเงินตามตั๋วแลกเงิน" ; -- src=panlex
lin statistics_N = mkN "สถิติ" | mkN "ข้อมูล" | mkN "วิชาสถิติ" | mkN "ข้อเท็จจริงที่เป็นตัวเลข" ; -- src=panlex
lin false_A = mkA "ปลอม" | mkA "ผิด" | mkA "เก๊" | mkA "ปลอม" | mkA "เท็จ" | mkA "ปลอมๆ" | mkA "เทียม" | mkA "ไม่แท้" | mkA "หลอกลวง" | mkA "ไม่จริง" | mkA "คบไม่ได้" | mkA "ไม่จริงใจ" | mkA "ไม่ถูกต้อง" | mkA "ไม่น่าไว้ใจ" | mkA "ไม่ซื่อสัตย์" | mkA "ไม่ถูกทํานอง" | mkA "ซึ่งผลิตขึ้นมา" | mkA "ซึ่งไม่ธรรมชาติ" | mkA "ซึ่งไม่ซื่อสัตย์" | mkA "ซึ่งสังเคราะห์ขึ้นมา" ; -- src=panlex
lin square_N = mkN "ไม้ฉาก" | mkN "จัตุรัส" | mkN "กำลังสอง" | mkN "สี่เหลี่ยม" | mkN "จัตุรัสสาธารณะ" | mkN "สี่เหลี่ยมจัตุรัส" | mkN "รูปสี่เหลี่ยมจัตุรัส" | mkN "รูปสี่เหลี่ยมด้านเท่า" | mkN "งบดุล" | mkN "บัญชี" | mkN "ควบคุม" | mkN "จตุรัส" | mkN "สี่แยก" | mkN "ไม้ฉาก" | mkN "จัตุรัส" | mkN "ทําตาราง" | mkN "ลานกว้าง" | mkN "ให้สินบน" | mkN "ทําให้ตรง" | mkN "ปรับระดับ" | mkN "สนามกว้าง" | mkN "ยกกําลังสอง" | mkN "ตารางหมากรุก" | mkN "คูณด้วยตัวเอง" | mkN "ทําให้เสมอกัน" | mkN "ลานสี่เหลี่ยม" | mkN "ทําให้เป็นมุมฉาก" | mkN "ผลคูณยกกําลังสอง" | mkN "ไม้ฉากของช่างไม้" | mkN "จํานวนยกกําลังสอง" | mkN "สี่เหลี่ยมจัตุรัส" | mkN "ตึกที่มีถนนสี่ด้าน" | mkN "ผลที่ได้จากกําลังสอง" | mkN "พื้นที่รูปสี่เหลี่ยม" | mkN "แผ่นกระดานเล่นเกมซึ่งเป็นรูปสี่เหลี่ยมจัตุรัส" ; -- src=panlex
lin differ_V = mkV "แตกต่าง" | mkV "ต่างไป" | mkV "แปลกไป" | mkV "ขัดแย้ง" | mkV "แตกต่าง" | mkV "ไม่เห็นด้วย" | mkV "ไม่เห็นพ้อง" | mkV "ผิดแผกแตกต่าง" ; -- src=panlex
lin disk_N = mkN "แผ่นดิสก์" | mkN "แผ่นเสียง" | mkN "แผ่นกลมแบน" | mkN "ดิสก์" | mkN "แผ่นกลม" | mkN "จานบันทึกแม่เหล็ก" | mkN "สิ่งที่มีรูปร่างเป็นแผ่นกลมและแบน" ; -- src=panlex
lin truly_Adv = variants{} ; -- 
lin survival_N = mkN "ความทนนาน" | mkN "การคัดเลือกโดยธรรมชาติ" | mkN "การคงอยู่" | mkN "การรอดตาย" | mkN "การอยู่รวด" | mkN "การอยู่รอด" | mkN "การดํารงอยู่" | mkN "การเหลืออยู่" | mkN "สิ่งที่คงทนอยู่" | mkN "สิ่งที่ดํารงอยู่" | mkN "บุคคลที่ยังมีชีวิตอยู่" ; -- src=panlex
lin proud_A = mkA "ภูมิใจ" | mkA "ถือดี" | mkA "หยิ่ง" | mkA "ภูมิใจ" | mkA "มีทิฐิ" | mkA "ทะนงตัว" | mkA "ลําพองใจ" | mkA "ซึ่งหยิ่งทะนง" | mkA "ภูมิใจในตนเอง" ; -- src=panlex
lin tower_N = mkN "หอคอย" | mkN "เรือลาก" | mkN "ทาวเวอร์" | mkN "รูปทรงยาวบาง" | mkN "รูปร่างเหมือนเสา" | mkN "หอคอย" | mkN "หอสูง" | mkN "ตึกสูง" | mkN "บินสูง" | mkN "ป้อมปราการ" | mkN "สูงขึ้นมาก" | mkN "ยืนตระหง่าน" | mkN "ตั้งตระหง่าน" | mkN "ชั้นเก็บแผ่นซีดีหรือวีดีโอ" ; -- src=panlex
lin deposit_N = mkN "ตะกอน" | mkN "การวาง" | mkN "การเก็บ" | mkN "การทับถม" | mkN "เงินมัดจำ" | mkN "การตกตะกอน" | mkN "เงินประกัน" | mkN "โรงเก็บของ" | mkN "คลังเก็บของ" | mkN "เงินฝากธนาคาร" | mkN "การตกตะกอนน้ำพา" | mkN "การทับถมตามธรรมชาติ" | mkN "เงินฝาก" | mkN "ค่ามัดจํา" | mkN "เงินดาวน์" | mkN "เงินมัดจํา" ; -- src=panlex
lin pace_N = mkN "หลา" | mkN "ก้าว" | mkN "อัตราเร็ว" | mkN "การก้าวเดิน" | mkN "อัตราจังหวะ" | mkN "ก้าว" | mkN "ฝีเท้า" | mkN "ระยะก้าว" | mkN "อัตราการวิ่ง" | mkN "อัตราการเดิน" | mkN "จังหวะก้าวเดิน" | mkN "อัตราการเคลื่อนไหว" ; -- src=panlex
lin compensation_N = mkN "การทดแทน" | mkN "การชดเชย" | mkN "การทดแทน" | mkN "การตอบแทน" | mkN "สิ่งที่ชดเชย" ; -- src=panlex
lin adviserMasc_N = variants{} ; -- 
lin consultant_N = mkN "ที่ปรึกษา" | mkN "ผู้ให้คำแนะนำ" | mkN "ผู้ขอคําปรึกษา" | mkN "ผู้ให้คําปรึกษา" | mkN "นายแพทย์ที่ปรึกษา" ; -- src=panlex
lin drag_V2 = mkV2 "งม" ; ---- | mkV "ดึง" | mkV "ดูด" | mkV "ลาก" | mkV "เข็น" | mkV "ล้าหลัง" | mkV "ยืดเยื้อ" | mkV "ลากเมาส์" | mkV "เดินลากเท้า" | mkV "เดินไม่ยกเท้า" | mkV "ขุด" | mkV "ชัก" | mkV "ดึง" | mkV "ลาก" | mkV "สาว" | mkV "พ่นควัน" ; -- src=panlex
lin drag_V = mkV "งม" | mkV "ดึง" | mkV "ดูด" | mkV "ลาก" | mkV "เข็น" | mkV "ล้าหลัง" | mkV "ยืดเยื้อ" | mkV "ลากเมาส์" | mkV "เดินลากเท้า" | mkV "เดินไม่ยกเท้า" | mkV "ขุด" | mkV "ชัก" | mkV "ดึง" | mkV "ลาก" | mkV "สาว" | mkV "พ่นควัน" ; -- src=panlex
lin advanced_A = mkA "ซึ่งล้ำยุค" | mkA "ที่รุดหน้า" | mkA "ซึ่งล้ำสมัย" | mkA "ที่ก้าวหน้า" | mkA "ซึ่งมองกาลไกล" | mkA "ซึ่งสลับซํบซ้อน" | mkA "ดึก" | mkA "ข้างหน้า" | mkA "ความเจริญ" | mkA "ความก้าวหน้า" | mkA "อยู่ข้างหน้า" | mkA "ที่อยู่นําหน้า" | mkA "การเลื่อนตําแหน่ง" ; -- src=panlex
lin landlord_N = mkN "เจ้าที่ดิน" | mkN "แลนด์ลอร์ด" | mkN "เจ้าของที่ดิน" | mkN "เจ้าของโรงแรม" | mkN "เจ้าของบ้านเช่า" ; -- src=panlex
lin whenever_Adv = mkAdv "เมื่อไรก็ตาม" ; -- src=panlex
lin delay_N = mkN "ช่วงเวลารอคอย" | mkN "การเลื่อนออกไป" | mkN "การเถลไถล" | mkN "ความชักช้า" | mkN "ความยืดยาด" | mkN "การเสียเวลา" | mkN "การหน่วงเหนี่ยว" ; -- src=panlex
lin green_N = mkN "ผัก" | mkN "กรีน" | mkN "ทุ่ง" | mkN "ยาเค" | mkN "เจ็ต" | mkN "เขียว" | mkN "สีเขียว" | mkN "เคตามีน" | mkN "ทุ่งหญ้า" | mkN "ผักใบเขียว" | mkN "สีเขียว" | mkN "พื้นที่สีเขียว" | mkN "พื้นที่ที่มีหญ้าปกคลุม" ; -- src=panlex
lin car_V = variants{} ; -- 
lin holder_N = mkN "ผู้ทรง" | mkN "ผู้ถือพันธบัตร" | mkN "ด้าม" | mkN "ที่จับ" | mkN "ที่ยึด" | mkN "ผู้ยึด" | mkN "เจ้าของ" | mkN "ผู้ครอบครอง" ; -- src=panlex
lin secret_A = mkA "ลับ" | mkA "ซึ่งปิดเป็นความลับ" | mkA "ลับ" | mkA "หลบ" | mkA "ปิดบัง" | mkA "ลึกลับ" | mkA "ความลับ" | mkA "อําพราง" | mkA "เร้นลับ" | mkA "แอบซ่อน" | mkA "ซ่อนเร้น" | mkA "ตําราลับ" | mkA "ลับเฉพาะ" | mkA "ความลึกลับ" | mkA "เป็นความลับ" | mkA "วิธีการลึกลับ" | mkA "สิ่งที่อําพราง" ; -- src=panlex
lin edition_N = mkN "ฉบับที่ตีพิมพ์" | mkN "เล่มที่ตีพิมพ์" | mkN "หนังสือที่ตีพิมพ์" | mkN "การพิมพ์" | mkN "ฉบับพิมพ์" | mkN "คนที่คล้ายกันมาก" | mkN "การเป็นบรรณาธิการ" | mkN "ฉบับพิมพ์ครั้งที่" | mkN "รูปแบบของสิ่งพิมพ์" | mkN "สิ่งที่คล้ายกันมาก" | mkN "จํานวนพิมพ์ทั้งหมดต่อครั้ง" ; -- src=panlex
lin occupation_N = mkN "งาน" | mkN "อาชีพ" | mkN "การงาน" | mkN "สายงาน" | mkN "หน้าที่การงาน" | mkN "การใช้เวลาว่าง" | mkN "ช่วงเวลายึดครอง" | mkN "การเข้าครอบครองทรัพย์สิน" | mkN "การควบคุมประเทศโดยใช้กำลังทหาร" | mkN "อาชีพ" | mkN "การงาน" | mkN "งานหลัก" | mkN "งานอาชีพ" | mkN "งานประจํา" | mkN "การยึดครอง" | mkN "การครอบครอง" ; -- src=panlex
lin agricultural_A = mkA "เกษตร" | mkA "เกษตรกรรม" | mkA "ทางการเกษตร" | mkA "ที่เกี่ยวกับเกษตรกรรม" ; -- src=panlex
lin intelligence_N = variants{} ; -- 
lin intelligence_2_N = variants{} ; -- 
lin intelligence_1_N = variants{} ; -- 
lin empire_N = mkN "จักรวรรดิ" | mkN "การรวมตัวกัน" | mkN "อาณาจักร" | mkN "จักรวรรดิ" | mkN "อํานาจเด็ดขาด" | mkN "พระราชอาณาจักร" | mkN "การปกครองอย่างเฉียบขาด" | mkN "เครือบริษัทที่ยิ่งใหญ่" ; -- src=panlex
lin definitely_Adv = variants{} ; -- 
lin negotiate_VV = mkVV "เจรจาต่อรอง" ; ---- | mkV "เจรจาต่อรอง" ; -- src=panlex
lin negotiate_V2 = mkV2 "เจรจาต่อรอง" ; ---- | mkV "เจรจาต่อรอง" ; -- src=panlex
lin negotiate_V = mkV "เจรจาต่อรอง" | mkV "เจรจาต่อรอง" ; -- src=panlex
lin host_N = mkN "ฝูง" | mkN "โฆษก" | mkN "พิธีกร" | mkN "เจ้าภาพ" | mkN "แม่ข่าย" | mkN "เจ้าบ้าน" | mkN "ตัวถูกเบียน" | mkN "ตัวให้อาศัย" | mkN "เซิร์ฟเวอร์" | mkN "เจ้าของโรงแรม" | mkN "ผู้จัดการโรงแรม" | mkN "ผู้ดำเนินรายการ" | mkN "ผู้รับการเปลี่ยนถ่ายอวัยวะ" | mkN "กองทัพ" | mkN "พิธีกร" | mkN "เจ้าภาพ" | mkN "เจ้าบ้าน" | mkN "ผู้จัดการ" | mkN "ผู้จัดงาน" | mkN "เจ้าของบ้าน" | mkN "ผู้จัดรายการ" | mkN "กลุ่มคนจํานวนมาก" | mkN "สิ่งของจํานวนมาก" | mkN "สัตว์หรือพืชที่เป็นที่อาศัยของปรสิต" ; -- src=panlex
lin relative_N = mkN "ญาติ" | mkN "พี่น้อง" | mkN "เครือญาติ" | mkN "ญาติพี่น้อง" | mkN "วงศาคณาญาติ" | mkN "ญาติโกโหติกา" | mkN "พืชหรือสัตว์ชนิดเดียวกัน" | mkN "ญาติ" | mkN "เครือญาติ" | mkN "ญาติพี่น้อง" | mkN "เกี่ยวดองกัน" | mkN "เกี่ยวข้องกัน" | mkN "สิ่งที่มีความสัมพันธ์กัน" ; -- src=panlex
lin mass_A = mkA "ทั่วไป" | mkA "มากมาย" | mkA "กว้างมาก" | mkA "ถ้วนทั่ว" | mkA "เป็นวงกว้าง" | mkA "ซึ่งมีจํานวนมาก" | mkA "เกี่ยวกับคนจํานวนมาก" | mkA "เกี่ยวข้องกับคนจํานวนมาก" ; -- src=panlex
lin helpful_A = mkA "ซึ่งช่วยเหลือ" | mkA "ซึ่งให้ความช่วยเหลือ" | mkA "ซึ่งเกื้อกูล" | mkA "ซึ่งช่วยเหลือ" | mkA "ให้ความช่วยเหลือ" ; -- src=panlex
lin fellow_N = mkN "พ่อ" | mkN "หนุ่ม" | mkN "สมาชิก" | mkN "เพื่อน" | mkN "พ่อหนุ่ม" | mkN "แฟนหนุ่ม" | mkN "ไอ้หนุ่ม" | mkN "คนคุ้นเคย" | mkN "เจ้าหนุ่ม" | mkN "เพื่อนชาย" | mkN "เพื่อนผู้ชาย" | mkN "เพื่อนร่วมงาน" | mkN "คนระดับเดียวกัน" | mkN "สหาย" | mkN "เกลอ" | mkN "บุคคล" | mkN "มนุษย์" | mkN "เพื่อน" | mkN "เจ้าหมอ" | mkN "คนผู้ชาย" | mkN "พ่อหนุ่ม" | mkN "ไอ้หนุ่ม" | mkN "ของคู่กัน" | mkN "เด็กผู้ชาย" | mkN "เพื่อนร่วมงาน" | mkN "คนชั้นเดียวกัน" | mkN "สิ่งประกอบเป็นคู่" | mkN "สมาชิกของสมาคมวิชาการ" | mkN "คําเรียกผู้ชายหรือเด็กชาย" ; -- src=panlex
lin sweep_V2 = mkV2 "ระ" ; ---- | mkV "ดึง" | mkV "กวาด" | mkV "แกว่ง" | mkV "ครอบคลุม" | mkV "กวาดชัยชนะ" | mkV "ครอบคลุมขอบเขตทั้งหมด" | mkV "ปัด" | mkV "กวาด" | mkV "ปัดกวาด" | mkV "ชนะท่วมท้น" | mkV "พัดพาเอาไป" | mkV "มีชัยท่วมท้น" | mkV "กวาดเอาไปด้วย" | mkV "ผ่านไปอย่างรวดเร็ว" | mkV "เคลื่อนไปอย่างรวดเร็ว" ; -- src=panlex
lin sweep_V = mkV "ระ" | mkV "ดึง" | mkV "กวาด" | mkV "แกว่ง" | mkV "ครอบคลุม" | mkV "กวาดชัยชนะ" | mkV "ครอบคลุมขอบเขตทั้งหมด" | mkV "ปัด" | mkV "กวาด" | mkV "ปัดกวาด" | mkV "ชนะท่วมท้น" | mkV "พัดพาเอาไป" | mkV "มีชัยท่วมท้น" | mkV "กวาดเอาไปด้วย" | mkV "ผ่านไปอย่างรวดเร็ว" | mkV "เคลื่อนไปอย่างรวดเร็ว" ; -- src=panlex
lin poet_N = mkN "กวี" | mkN "นักกวี" | mkN "นักกลอน" | mkN "กวี" | mkN "นักกวี" | mkN "คนแต่งบทกวี" | mkN "นักแต่งโคลงกลอน" | mkN "คนเขียนบทประพันธ์" ; -- src=panlex
lin journalist_N = mkN "นักหนังสือพิมพ์" | mkN "ผู้เขียนบันทึกประจำวัน" | mkN "นักข่าว" | mkN "คนเขียนข่าว" | mkN "ผู้สื่อข่าว" | mkN "ผู้เขียนบันทึก" | mkN "ผู้เขียนอนุทิน" | mkN "นักหนังสือพิมพ์" ; -- src=panlex
lin defeat_N = mkN "ความพ่ายแพ้" | mkN "การประสบความพ่ายแพ้" | mkN "ปราชัย" | mkN "ความปราชัย" | mkN "ความผิดหวัง" | mkN "ความพ่ายแพ้" | mkN "ความล้มเหลว" | mkN "ความสิ้นหวัง" ; -- src=panlex
lin unlike_Prep = mkPrep "ผิดแผกจาก" | mkPrep "แตกต่างกัน" | mkPrep "แตกต่างจาก" | mkPrep "ไม่เท่ากัน" | mkPrep "ไม่เหมือนกัน" ; -- src=panlex
lin primarily_Adv = variants{} ; -- 
lin tight_A = mkA "เมาหนัก" | mkA "เมาปลิ้น" | mkA "เมาหัวราน้ำ" | mkA "คับ" | mkA "ยาก" | mkA "แน่น" | mkA "ใจแคบ" | mkA "กระชับ" | mkA "กวดขัน" | mkA "คับขัน" | mkA "คับแคบ" | mkA "รัดกุม" | mkA "รัดรูป" | mkA "ลําบาก" | mkA "สังเขป" | mkA "คับแน่น" | mkA "ตระหนี่" | mkA "ติดสนิท" | mkA "ติดแน่น" | mkA "ตึงแน่น" | mkA "ผูกแน่น" | mkA "พันแน่น" | mkA "รัดแน่น" | mkA "หนาแน่น" | mkA "อัดแน่น" | mkA "เข้มงวด" | mkA "แน่นหนา" | mkA "ไม่รั่ว" | mkA "เมาเหล้า" | mkA "ขี้เหนียว" | mkA "ได้ใจความ" | mkA "สั้นกระชับ" | mkA "จัดการลําบาก" | mkA "เกือบเสมอกัน" | mkA "เคร่งระเบียบ" | mkA "ไม่มีที่ว่าง" | mkA "ใกล้ชิดสนิทสนม" | mkA "อากาศเข้าไม่ได้" | mkA "ใกล้เคียงกันมาก" | mkA "ที่ไม่มีเวลาว่าง" | mkA "ที่มีคู่แข่งที่มีความสามารถใกล้เคียงกัน" ; -- src=panlex
lin indication_N = mkN "ค่ามาตรวัด" | mkN "ค่ามิเตอร์" | mkN "สิ่งชี้บอก" | mkN "สิ่งบ่งชี้" | mkN "สิ่งบ่งบอก" | mkN "เครื่องหมาย" | mkN "อาการ" | mkN "สัญญาณ" | mkN "อาการโรค" | mkN "การชี้บอก" | mkN "การบ่งบอก" | mkN "การแสดงออก" | mkN "สิ่งที่บอก" | mkN "เครื่องหมายแสดง" | mkN "ระดับขีดแบ่งของเครื่องมือ" ; -- src=panlex
lin dry_V2 = mkV2 "แห้ง" ; ---- | mkV "ทำให้แห้ง" | mkV "แห้ง" | mkV "ทําให้แห้ง" | mkV "ถนอมอาหารด้วยการอบแห้ง" ; -- src=panlex
lin dry_V = mkV "แห้ง" | mkV "ทำให้แห้ง" | mkV "แห้ง" | mkV "ทําให้แห้ง" | mkV "ถนอมอาหารด้วยการอบแห้ง" ; -- src=panlex
lin cricket_N = mkN "คริกเก็ต" | mkN "จิ้งหรีด" | mkN "กีฬาคริกเก็ต" | mkN "จิ้งหรีด" | mkN "กีฬาคริกเก็ต" | mkN "กีฬาคริคเก็ต" | mkN "การเล่นที่ยุติธรรม" ; -- src=panlex
lin whisper_V2 = mkV2 "กระซิบ" ; ---- | mkV "พูดเบาๆ" | mkV "พูดค่อยๆ" | mkV "พูดกระซิบ" | mkV "พูดเสียงเบา" | mkV "กระซิบกระซาบ" | mkV "พูดเสียงค่อย" | mkV "กระซิบ" | mkV "พูดเบาๆ" | mkV "กระซิบกระซาบ" | mkV "ส่งเสียงเบาๆ" ; -- src=panlex
lin whisper_V = mkV "กระซิบ" | mkV "พูดเบาๆ" | mkV "พูดค่อยๆ" | mkV "พูดกระซิบ" | mkV "พูดเสียงเบา" | mkV "กระซิบกระซาบ" | mkV "พูดเสียงค่อย" | mkV "กระซิบ" | mkV "พูดเบาๆ" | mkV "กระซิบกระซาบ" | mkV "ส่งเสียงเบาๆ" ; -- src=panlex
lin routine_N = mkN "กิจวัตร" | mkN "โปรแกรมย่อย" | mkN "ตามปกติ" | mkN "งานประจํา" | mkN "กิจวัตรประจํา" | mkN "วิธีการประจํา" | mkN "หน้าที่ประจํา" ; -- src=panlex
lin print_N = mkN "รอย" | mkN "ภาพพิมพ์" | mkN "สิ่งพิมพ์" | mkN "การพิมพ์" | mkN "ตัวพิมพ์" | mkN "ผ้าพิมพ์" | mkN "ภาพพิมพ์" | mkN "วิธีการพิมพ์" | mkN "สิ่งที่ใช้พิมพ์" | mkN "รูปถ่ายที่อัดออกมาจากฟิล์ม" | mkN "รูปถ่ายที่อัดออกมาจากฟิล์มหรือกระจก" ; -- src=panlex
lin anxiety_N = mkN "อาการวิตกกังวล" | mkN "ความวิตก" | mkN "ความกลุ้ม" | mkN "ความกังวล" | mkN "ความห่วงใย" | mkN "ความกระตือ รือร้น" | mkN "ความกลุ้มใจ" | mkN "ความวิตกกังวล" | mkN "ความเป็นทุกข์" | mkN "เรื่องน่าห่วง" | mkN "สิ่งที่ทําให้กังวล" ; -- src=panlex
lin witness_N = mkN "คนดู" | mkN "พยาน" | mkN "ผู้ชม" | mkN "ผู้เห็นเหตุการณ์" | mkN "ผู้อยู่ในเหตุการณ์" | mkN "พยาน" | mkN "เห็น" | mkN "ผู้เห็น" | mkN "หลักฐาน" | mkN "เป็นพยาน" | mkN "ผู้รับรู้" | mkN "ผู้รู้เห็น" | mkN "เห็นด้วยตา" | mkN "เป็นหลักฐาน" | mkN "ลงนามเป็นพยาน" | mkN "เป็นผู้ลงนามร่วม" | mkN "ผู้ลงชื่อเป็นพยาน" | mkN "ผู้เซ็นชื่อรวมเป็นพยาน" ; -- src=panlex
lin concerning_Prep = mkPrep "เกี่ยวกับ" ; -- src=panlex
lin mill_N = mkN "ร.ง." | mkN "รง." | mkN "การบด" | mkN "โรงงาน" | mkN "เครื่องโม่" | mkN "ชก" | mkN "ตี" | mkN "โม่" | mkN "โรงสี" | mkN "ต่อสู้" | mkN "เอาชนะ" | mkN "โรงงาน" | mkN "โรงโม่" | mkN "เครื่องบด" | mkN "เครื่องโม่" | mkN "โรงบดวัตถุ" | mkN "โรงงานผลิตสินค้า" | mkN "โรงประกอบหัตถกรรม" | mkN "โรงเครื่องจักรเครื่องกล" ; -- src=panlex
lin gentle_A = mkA "อ่อน" | mkA "ใจดี" | mkA "สุภาพ" | mkA "ตบเบา ๆ" | mkA "นุ่มนวล" | mkA "มีเมตตา" | mkA "ลูบคลํา" | mkA "ว่าง่าย" | mkA "อ่อนโยน" | mkA "ใจกว้าง" | mkA "มีน้ําใจ" | mkA "อ่อนน้อม" | mkA "ทําให้สงบ" | mkA "น่านับถือ" | mkA "มีสกุลสูง" | mkA "เป็นผู้ดี" | mkA "ทําให้อ่อนโยน" ; -- src=panlex
lin curtain_N = mkN "ม่าน" | mkN "ผ้าม่าน" | mkN "พระสูตร" | mkN "พระวิสูตร" | mkN "ม่าน" ; -- src=panlex
lin mission_N = mkN "งาน" | mkN "คำสั่ง" | mkN "ภารกิจ" | mkN "มิสชั่น" | mkN "คณะผู้แทน" | mkN "กลุ่มผู้แทน" | mkN "ภารกิจทางทหาร" | mkN "การเผยแผ่ศาสนา" | mkN "งานเผยแผ่ศาสนา" | mkN "กลุ่มมิชชันนารี" | mkN "กลุ่มหมอสอนศาสนา" | mkN "คณะทูต" | mkN "ผู้แทน" | mkN "ภารกิจ" | mkN "สถานทูต" | mkN "คณะผู้แทน" | mkN "ภาระหน้าที่" | mkN "งานที่ได้รับมอบหมาย" | mkN "งานปฏิบัติงานทางทหาร" | mkN "ภาระหน้าที่ของคณะผู้แทน" ; -- src=panlex
lin supplier_N = mkN "ซัปพลายเออร์" | mkN "ผู้จัดหาสินค้า" | mkN "ผู้จัดหาสิ่งของให้" ; -- src=panlex
lin basically_Adv = mkAdv "โดยพื้นฐาน" | mkAdv "โดยทั่วๆ ไป" | mkAdv "โดยพื้นฐาน" | mkAdv "โดยแท้จริง" ; -- src=panlex
lin assure_V2S = variants{} ; -- 
lin assure_V2 = variants{} ; -- 
lin poverty_N = mkN "ความยากจน" | mkN "ความยากจนข้นแค้น" | mkN "ความจน" | mkN "ความขัดสน" | mkN "ความยากจน" | mkN "ความอัตคัด" | mkN "ความขาดแคลน" | mkN "ความฝืดเคือง" | mkN "ความไม่พอเพียง" ; -- src=panlex
lin snow_N = mkN (thword "หิ" "มะ") | {-pan-} mkN "หิมะ" | mkN "โค้ก" | mkN "สโนว์" | mkN "หิมะตก" | mkN "หิมะ" | mkN "ชักชวน" | mkN "หลอกลวง" | mkN "โยนหิมะ" | mkN "ก้อนหิมะ" | mkN "สิ่งที่เหมือนหิมะ" | mkN "ทําให้ขาวเหมือนหิมะ" | mkN "ปริมาณหิมะที่ตกลงมา" | mkN "ยาเสพติดที่มีลักษณะเป็นผงสีขาว เช่น โคเคน" ; -- src=panlex
lin prayer_N = mkN "บทสวดมนต์" | mkN "การสวดมนต์" | mkN "ผู้อ้อนวอน" | mkN "คำขอร้องเร่งด่วน" | mkN "การภาวนา" | mkN "ผู้ภาวนา" | mkN "การขอร้อง" | mkN "บทสวดมนต์" | mkN "ผู้วิงวอน" | mkN "สิ่งที่ขอ" | mkN "การสวดมนต์" | mkN "การอธิษฐาน" | mkN "คําสวดมนต์" | mkN "คําอธิษฐาน" | mkN "ผู้สวดมนต์" | mkN "ผู้อธิษฐาน" | mkN "ผู้อ้อนวอน" | mkN "สิ่งที่อ้อนวอน" ; -- src=panlex
lin pipe_N = mkN "ท่อ" | mkN "ปี่" | mkN "ไปป์" | mkN "ท่อส่ง" | mkN "กล้องยาสูบ" | mkN "ออร์แกนไปป์" | mkN "ท่อ" | mkN "ปี่" | mkN "หลอด" | mkN "กล้อง" | mkN "ขลุ่ย" | mkN "ไป๊ป์" | mkN "ซิการ์" | mkN "นกหวีด" | mkN "การคุยกัน" | mkN "ท่อนําส่ง" | mkN "กล้องสูบยา" | mkN "ท่อนําวิถี" | mkN "กล้องยาเส้น" | mkN "จัดให้มีท่อ" | mkN "การส่งทางท่อ" | mkN "เปล่งเสียงแหลม" | mkN "ยาเส้นหนึ่งกล้อง" | mkN "เป่าปี่หรือขลุ่ย" | mkN "เสียงร้องเพลงของคน" | mkN "นกหวีดที่เป่าในเรือ" | mkN "อวัยวะที่เป็นหลอดนําส่ง" | mkN "ยาเส้นหรือยาสูบหนึ่งกล้อง" | mkN "เครื่องดนตรีประเภทปี่หรือขลุ่ย" | mkN "ถังไม้ขนาดใหญ่สําหรับบรรจุไวน์หรือน้ํามัน" ; -- src=panlex
lin deserve_VV = mkVV "สมควรได้รับ" ; ---- | mkV "คู่ควร" | mkV "สมควรได้รับ" | mkV "ควรค่าแก่การได้รับ" ; -- src=panlex
lin deserve_V2 = mkV2 "สมควรได้รับ" ; ---- | mkV "คู่ควร" | mkV "สมควรได้รับ" | mkV "ควรค่าแก่การได้รับ" ; -- src=panlex
lin deserve_V = mkV "สมควรได้รับ" | mkV "คู่ควร" | mkV "สมควรได้รับ" | mkV "ควรค่าแก่การได้รับ" ; -- src=panlex
lin shift_N = mkN "กะ" | mkN "ชิฟต์" | mkN "ชุดชั้นใน" | mkN "เวลาทำงาน" | mkN "ชั่วโมงทำงาน" | mkN "การเปลี่ยนรูป" | mkN "คนทำงานเป็นกะ" | mkN "ช่วงเวลาทำงาน" | mkN "การเปลี่ยนตำแหน่ง" | mkN "รอยเลื่อนของเปลือกโลก" | mkN "การย้าย" | mkN "การเคลื่อนย้าย" | mkN "ช่วงเวลาการทํางาน" ; -- src=panlex
lin split_V2 = mkV2 (thword "ผ่า") ;
lin split_V = mkV "แตก" | mkV "หั่น" | mkV "แบ่ง" | mkV "ระเบิด" | mkV "แยกทาง" | mkV "ผ่า" | mkV "หั่น" | mkV "แตกแยก" ; -- src=panlex
lin near_Adv = mkAdv "ใกล้" | {-pan-} mkAdv "เกือบ" | mkAdv "จวนเจียน" | mkAdv "เกือบถึง" | mkAdv "จวน" | mkAdv "เกือบจะ" | mkAdv "ใกล้เคียง" | mkAdv "ในระยะเวลาอันใกล้" ; -- src=panlex
lin consistent_A = mkA "ซึ่งสามารถผลิตซ้ำ" | mkA "มั่นคง" | mkA "ลงรอยกัน" | mkA "เห็นพ้อง" | mkA "ที่สอดคล้องกัน" | mkA "ซึ่งยึดมั่นเหนียวแน่น" ; -- src=panlex
lin carpet_N = mkN "พรม" "ผืน" | {-pan-} mkN "พรม" | mkN "ลาดพระบาท" | mkN "พรม" | mkN "ลักษณะพื้นผิวที่นุ่มเหมือนพรม" ; -- src=panlex
lin ownership_N = mkN "กรรมสิทธิ์" | mkN "การเป็นเจ้าของ" | mkN "ความเป็นเจ้าของ" | mkN "ความเป็นเจ้าของ" | mkN "สิทธิการครอบครอง" ; -- src=panlex
lin joke_N = mkN "มุก" | mkN "มุข" | mkN "แก๊ก" | mkN "มุกตลก" | mkN "มุขตลก" | mkN "การเล่นตลก" | mkN "เรื่องโจ๊ก" | mkN "ตัวตลก" | mkN "คําพูดตลก" | mkN "เรื่องตลก" | mkN "เรื่องขบขัน" | mkN "เรื่องของคนหรือสถานการณ์ที่น่าหัวเราะ" ; -- src=panlex
lin fewer_Det = variants{} ; -- 
lin workshop_N = mkN "โรงงาน" | mkN "เวิร์กช็อป" | mkN "หลักสูตรเร่งรัด" | mkN "หลักสูตรระยะสั้น" | mkN "โรงงาน" | mkN "ที่ทํางาน" | mkN "ห้องทํางาน" | mkN "ห้องเครื่อง" | mkN "การประชุมปฏิบัติการ" | mkN "การสัมนาเชิงปฏิบัติการ" | mkN "การประชุมเชิงปฏิบัติการ" ; -- src=panlex
lin salt_N = mkN (thword "เกลือ") | {-pan-} mkN "เกลือ" | mkN "รสเค็ม" | mkN "เกลือแกง" | mkN "เกลือ" | mkN "เกลือแกง" | mkN "กลาสีเรือ" | mkN "จัดให้ได้รับเกลือ" ; -- src=panlex
lin aged_Prep = variants{} ; -- 
lin symbol_N = mkN "สัญลักษณ์" | mkN "สัญลักษณ์" | mkN "เครื่องหมาย" | mkN "เครื่องแสดง" | mkN "เป็นเครื่องหมาย" ; -- src=panlex
lin slide_V2 = mkV2 "ไถล" ; ---- | mkV "ลื่น" | mkV "สไลด์" | mkV "ลื่นไถล" | mkV "ไถล" | mkV "ตกลง" | mkV "ลดลง" | mkV "ลื่น" | mkV "ลดค่า" | mkV "ลื่นถลา" | mkV "ลดต่ําลง" | mkV "ทําให้ไถล" | mkV "ทําให้ลื่น" | mkV "ทําให้ลื่นถลา" | mkV "เปลี่ยนไปสู่สภาพที่แตกต่าง" ; -- src=panlex
lin slide_V = mkV "ไถล" | mkV "ลื่น" | mkV "สไลด์" | mkV "ลื่นไถล" | mkV "ไถล" | mkV "ตกลง" | mkV "ลดลง" | mkV "ลื่น" | mkV "ลดค่า" | mkV "ลื่นถลา" | mkV "ลดต่ําลง" | mkV "ทําให้ไถล" | mkV "ทําให้ลื่น" | mkV "ทําให้ลื่นถลา" | mkV "เปลี่ยนไปสู่สภาพที่แตกต่าง" ; -- src=panlex
lin cross_N = mkN "กากบาท" | mkN "ลูกผสม" | mkN "พันธุ์ผสม" | mkN "ความทุกข์ทรมาน" | mkN "การผสมข้ามสายพันธุ์" | mkN "กากบาท" | mkN "ลูกผสม" | mkN "ไม้กางเขน" | mkN "การผสมผสาน" | mkN "การผสมข้ามพันธุ์" ; -- src=panlex
lin anxious_A = mkA "ห่วงใย" | mkA "กังวลใจ" | mkA "ที่วิตก" | mkA "น่าห่วง" | mkA "ช่างวิตก" | mkA "ที่กังวล" | mkA "ที่ร้อนใจ" | mkA "ที่วิตกกังวล" | mkA "ที่กระวนกระวาย" | mkA "ที่ทําให้เกิดความกลัว" | mkA "ที่ทําให้เกิดความกังวล" | mkA "ที่เต็มไปด้วยความกังวล" ; -- src=panlex
lin tale_N = mkN "นิทาน" | mkN "เรื่องราว" | mkN "เรื่องโม้" | mkN "เรื่องเล่า" | mkN "เรื่องขี้โม้" | mkN "นิทาน" | mkN "นิยาย" | mkN "คํานินทา" | mkN "คําเล่าลือ" | mkN "เรื่องเล่า" | mkN "เรื่องโกหก" | mkN "จํานวนทั้งหมด" | mkN "เรื่องเล่าลือ" ; -- src=panlex
lin preference_N = mkN "ความพึงใจ" | mkN "บุริมสิทธิ" | mkN "สิทธิพิเศษ" | mkN "การชอบมากกว่า" | mkN "การใช้สิทธิพิเศษ" | mkN "สิ่งที่ชอบมากกว่า" ; -- src=panlex
lin inevitably_Adv = variants{} ; -- 
lin mere_A = mkA "เฉย ๆ" | mkA "แท้ ๆ" | mkA "แท้ๆ" | mkA "เท่านั้น" | mkA "บริสุทธิ์" | mkA "เป็นเพียง" | mkA "อุดมสมบูรณ์" | mkA "ไม่เกินกว่า" | mkA "เพียงเท่านั้น" | mkA "ไม่มีสิ่งเจือปน" ; -- src=panlex
lin behave_V = mkV "ทำตัว" | mkV "ทำตัวดี" | mkV "ประพฤติตน" | mkV "ประพฤติตัว" | mkV "มีพฤติกรรม" | mkV "ประพฤติตัวดี" | mkV "มีความประพฤติ" | mkV "วางตัว" | mkV "ประพฤติ" | mkV "ปฏิบัติตัว" | mkV "ประพฤติตัว" ; -- src=panlex
lin gain_N = mkN "กำไร" | mkN "ผลกำไร" | mkN "อัตราขยาย" | mkN "การเพิ่มขึ้น" | mkN "ผลกําไร" | mkN "ผลประโยชน์" | mkN "ปริมาณที่ขยายออก" | mkN "จํานวนที่เพิ่มขึ้น" ; -- src=panlex
lin nervous_A = mkA "ขี้ตื่นตกใจ" | mkA "ร้อนรน" | mkA "กังวลใจ" | mkA "ประหม่า" | mkA "แข็งแรง" | mkA "หงุดหงิด" | mkA "กลัวลนลาน" | mkA "ทางประสาท" | mkA "เป็นประสาท" | mkA "กระวนกระวาย" | mkA "กระสับกระส่าย" | mkA "เกี่ยวกับประสาท" ; -- src=panlex
lin guide_V2 = variants{} ; -- 
lin remark_N = mkN "ข้อคิดเห็น" | mkN "คําติชม" | mkN "ความเห็น" | mkN "ข้อสังเกต" | mkN "ข้อคิดเห็น" | mkN "การให้ข้อคิดเห็น" | mkN "การวิพากษ์วิจารณ์" ; -- src=panlex
lin pleased_A = mkA "พอใจ" | mkA "ยินดี" | mkA "อภิรมย์" | mkA "มีความสุข" ; -- src=panlex
lin province_N = mkN "รัฐ" | mkN "มลรัฐ" | mkN "จังหวัด" | mkN "วง" | mkN "เขต" | mkN "มณฑล" | mkN "จังหวัด" | mkN "ภูมิภาค" | mkN "อาณาเขต" | mkN "บริเวณที่ต่ํากว่าบริเวณหนึ่ง" ; -- src=panlex
lin steel_N = mkN "เหล็ก" | {-pan-} mkN "ดาบ" | mkN "กระบี่" | mkN "พระขรรค์" | mkN "เหล็กกล้า" | mkN "เหล็กลับมีด" | mkN "ทําให้คล้ายเหล็กกล้า" ; -- src=panlex ----?
lin practise_V2 = mkV2 "ฝึกงาน" ; ---- | mkV "ฝึกปฏิบัติ" | mkV "ฝึกซ้ำแล้วซ้ำอีก" | mkV "ซ้อม" | mkV "ฝึกฝน" | mkV "ฝึกซ้อม" | mkV "ทําเป็นกิจวัตร" | mkV "ทําตามหลักทางศาสนา" ; -- src=panlex
lin practise_V = mkV "ฝึกงาน" | mkV "ฝึกปฏิบัติ" | mkV "ฝึกซ้ำแล้วซ้ำอีก" | mkV "ซ้อม" | mkV "ฝึกฝน" | mkV "ฝึกซ้อม" | mkV "ทําเป็นกิจวัตร" | mkV "ทําตามหลักทางศาสนา" ; -- src=panlex
lin flow_V = mkV (thword "ไหล") | {-pan-} mkV "นอง" | mkV "พาด" | mkV "ไหล" | mkV "มีระดู" | mkV "ไหลนอง" | mkV "มีเมนส์" | mkV "ทำให้ไหล" | mkV "หลั่งไหล" | mkV "มีรอบเดือน" | mkV "มีประจำเดือน" | mkV "ไหล" | mkV "ท่วม" | mkV "ระบาย" | mkV "หลั่ง" | mkV "ไหลบ่า" | mkV "ไหลออก" | mkV "ลื่นไหล" | mkV "ล้นหลาม" | mkV "ไหลคล่อง" | mkV "ไหลเวียน" | mkV "ดําเนินไปอย่างราบรื่น" ; -- src=panlex
lin holy_A = mkA "ศักดิ์สิทธิ์" | mkA "อย่ายิ่ง" | mkA "เหลือเกิน" | mkA "เคร่งศาสนา" | mkA "ศักดิ์สิทธิ์" | mkA "ที่เคร่งศาสนา" | mkA "ใจบุญอย่างยิ่ง" | mkA "ซึ่งศักดิ์สิทธิ์" | mkA "สิ่งศักดิ์สิทธิ์" | mkA "เป็นที่เคารพบูชา" ; -- src=panlex
lin dose_N = mkN "โดส" | mkN "กามโรค" | mkN "ปริมาณยา" | mkN "โรคผู้หญิง" | mkN "ปริมาณยาที่ให้ต่อครั้ง" ; -- src=panlex
lin alcohol_N = mkN "เหล้า" | mkN "น้ำเมา" | mkN "แอลกอฮอล์" | mkN "เครื่องดองของเมา" | mkN "เครื่องดื่มแอลกอฮอล์" | mkN "เครื่องดื่มที่มีแอลกอฮอล์" | mkN "เครื่องดื่มที่มีส่วนผสมของแอลกฮอล์ล" | mkN "สุรา" | mkN "เหล้า" | mkN "แอลกอฮอล์" | mkN "สารชนิดหนึ่งไม่มีสี ติดไฟได้" | mkN "เครื่องดื่มที่มีแอลกอฮอล์" | mkN "เครื่องดื่มที่ผสมแอลกอฮอล์" ; -- src=panlex
lin guidance_N = mkN "คำแนะนำ" | mkN "คำปรึกษา" | mkN "การบอกทาง" | mkN "การแนะแนว" | mkN "ข้อชี้แนะ" | mkN "การนำทางไป" | mkN "การให้คำปรึกษา" | mkN "การนําทาง" | mkN "การแนะนํา" | mkN "การแนะแนว" | mkN "คําแนะนํา" | mkN "สิ่งนําทาง" | mkN "เครื่องนําทาง" ; -- src=panlex
lin constantly_Adv = variants{} ; -- 
lin climate_N = mkN "สภาพอากาศ" | mkN "ภูมิสถาปัตย์" | mkN "สภาพอากาศ" | mkN "อากาศตามฤดูกาล" | mkN "แนวโน้มทั่วไปของสังคม" | mkN "ประเพณีนิยมที่เป็นอยู่" ; -- src=panlex
lin enhance_V2 = variants{} ; -- 
lin reasonably_Adv = variants{} ; -- 
lin waste_V2 = mkV2 "เก็บ" ; ---- | mkV "ตรอมใจ" | mkV "ทำลายล้าง" | mkV "ทำให้อ่อนแอ" | mkV "ทิ้งของเสีย" | mkV "ปล่อยของเสีย" | mkV "มีร่างกายอ่อนแอ" | mkV "ทำให้หายไปจากโลก" | mkV "อ่อนแอทางร่างกาย" | mkV "ใช้อย่างสิ้นเปลือง" | mkV "ใช้จ่ายสุรุ่ยสุร่าย" | mkV "ทําลาย" | mkV "ฆาตกรรม" | mkV "ไม่สบาย" | mkV "ทําให้เหนื่อย" | mkV "ทําให้ไม่สบาย" | mkV "ทําให้อ่อนเพลีย" | mkV "ไม่ได้ใช้ประโยชน์" | mkV "พูดไปโดยเปล่าประโยชน์" | mkV "ใช้ไปโดยเปล่าประโยชน์" | mkV "สูญเสียไปโดยเปล่าประโยชน์" ; -- src=panlex
lin waste_V = mkV "เก็บ" | mkV "ตรอมใจ" | mkV "ทำลายล้าง" | mkV "ทำให้อ่อนแอ" | mkV "ทิ้งของเสีย" | mkV "ปล่อยของเสีย" | mkV "มีร่างกายอ่อนแอ" | mkV "ทำให้หายไปจากโลก" | mkV "อ่อนแอทางร่างกาย" | mkV "ใช้อย่างสิ้นเปลือง" | mkV "ใช้จ่ายสุรุ่ยสุร่าย" | mkV "ทําลาย" | mkV "ฆาตกรรม" | mkV "ไม่สบาย" | mkV "ทําให้เหนื่อย" | mkV "ทําให้ไม่สบาย" | mkV "ทําให้อ่อนเพลีย" | mkV "ไม่ได้ใช้ประโยชน์" | mkV "พูดไปโดยเปล่าประโยชน์" | mkV "ใช้ไปโดยเปล่าประโยชน์" | mkV "สูญเสียไปโดยเปล่าประโยชน์" ; -- src=panlex
lin smooth_A = mkA (thword "ละ" "มุน") | {-pan-} mkA "เรียบ" | mkA "ราบเรียบ" | mkA "ราบ" | mkA "สงบ" | mkA "ลื่น" | mkA "ละมุน" | mkA "เรียบ" | mkA "ไพเราะ" | mkA "ราบรื่น" | mkA "อ่อนโยน" | mkA "กลมกล่อม" | mkA "ผสมกันดี" | mkA "ระรื่นหู" | mkA "ราบเรียบ" | mkA "เงียบสงบ" | mkA "แบนเรียบ" | mkA "ไม่มีปัญหา" ; -- src=panlex
lin dominant_A = mkA "เด่น" | mkA "โดดเด่น" | mkA "ซึ่งปกครอง" | mkA "ซึ่งครอบงํา" | mkA "มีอํานาจเหนือ" | mkA "ซึ่งมีบทบาทสําคัญ" | mkA "ซึ่งเป็นส่วนสําคัญ" | mkA "ที่มีอํานาจครอบครอง" | mkA "ที่มีอํานาจเหนือกว่า" ; -- src=panlex
lin conscious_A = mkA "ซึ่งมีสติ" | mkA "ซึ่งรู้ตัว" | mkA "พิชาน" | mkA "มีสติ" | mkA "มีเจตนา" | mkA "ที่รู้สึกตัว" | mkA "ที่ตระหนักได้" | mkA "ซึ่งมีจิตสํานึก" | mkA "ที่รู้สึกหรือคิดได้" ; -- src=panlex
lin formula_N = mkN "กฎ" | mkN "สูตร" | mkN "สูตรเคมี" | mkN "ฟอร์มูล่า" | mkN "กฎ" | mkN "สูตร" | mkN "หลัก" | mkN "แผ่น" | mkN "เกณฑ์" | mkN "ตํารับ" | mkN "รูปแบบ" | mkN "มาตรฐาน" | mkN "วิธีทํา" ; -- src=panlex
lin tail_N = mkN (thword "หาง") | {-pan-} mkN "ก้น" | mkN "ตูด" | mkN "หาง" | mkN "ก้อย" | mkN "ท้ายเรือ" | mkN "บั้นท้าย" | mkN "คนลอบติดตาม" | mkN "ผู้ลอบติดตาม" | mkN "ชาย" | mkN "หาง" | mkN "ท้าย" | mkN "ปลาย" | mkN "เปีย" | mkN "ค่อย ๆ หายไป" | mkN "ตัดหาง" | mkN "ลากหาง" | mkN "ส่วนใน" | mkN "ใส่หาง" | mkN "ตอนหลัง" | mkN "ล้าหลัง" | mkN "ชายเสื้อ" | mkN "บั้นท้าย" | mkN "ส่วนท้าย" | mkN "ผู้ติดตาม" | mkN "ช่วงสุดท้าย" | mkN "เวลาสุดท้าย" | mkN "เป็นส่วนปลาย" | mkN "ด้านก้อยของเหรียญ" | mkN "ส่วนที่ไม่ต้องการ" ; -- src=panlex ----?
lin ha_Interj = mkInterj "ฮ้า" | mkInterj "ฮ่า" | mkInterj "คําอุทานแสดงคําถาม" | mkInterj "คําอุทานแสดงความสงสัย" | mkInterj "คําอุทานแสดงความประหลาดใจ" ; -- src=panlex
lin electric_A = mkA "ไฟฟ้า" | mkA "เหมือนถูกไฟฟ้าช็อต" | mkA "ตื่นตระหนก" | mkA "น่าตื่นเต้น" | mkA "เกี่ยวกับไฟฟ้า" ; -- src=panlex
lin sheep_N = animalN "แกะ" | {-pan-} mkN "แกะ" | mkN "เด็กว่านอนสอนง่าย" | mkN "แกะ" | mkN "หนังแกะ" | mkN "ศาสนิกชน" | mkN "บุคคลที่เหนียมอายและถูกชักจูงได้ง่าย" ; -- src=panlex
lin medicine_N = mkN "ยา" | mkN "หยูกยา" | mkN "ยารักษา" | mkN "ยารักษาโรค" | mkN "อาชีพแพทย์" | mkN "อายุรศาสตร์" | mkN "ยา" | mkN "เวชกรรม" | mkN "การแพทย์" | mkN "อายุรกรรม" | mkN "เวชศาสตร์" | mkN "ยารักษาโรค" | mkN "แพทยศาสตร์" | mkN "แพทย์ศาสตร์" | mkN "สารที่ใช้เป็นยา" | mkN "การรักษาโรคทางยา" | mkN "วิทยาศาสตร์แพทย์" | mkN "การบําบัดโรคด้วยยา" | mkN "สิ่งที่ใช้ในการบําบัดโรค" ; -- src=panlex
lin strategic_A = mkA "เกี่ยวกับ" | mkA "ในทางยุทธศาสตร์" | mkA "เกี่ยวกับยุทธวิธีหรือกลยุทธ์" ; -- src=panlex
lin disabled_A = mkA "พิการ" | mkA "พิการ" | mkA "ทุพพลภาพ" | mkA "หย่อนความสามารถ" | mkA "ซึ่งไร้ความสามารถ" ; -- src=panlex
lin smell_N = mkN "กลิ่น" | mkN "การดม" | mkN "การดมกลิ่น" | mkN "การรับกลิ่น" | mkN "การรู้กลิ่น" | mkN "สมบัติของกลิ่น" | mkN "กลิ่น" ; -- src=panlex
lin operator_N = mkN "ผู้ควบคุม" | mkN "โอเปอเรเตอร์" | mkN "เจ้าของธุรกิจ" | mkN "คนงาน" | mkN "ช่างคนงาน" | mkN "พนักงานขับรถ" | mkN "ช่างผู้ชํานาญ" | mkN "ผู้คุมเครื่อง" | mkN "ผู้ปฏิบัติการ" | mkN "ผู้ประกอบธุรกิจ" | mkN "ผู้กระทําศัลยกรรม" | mkN "เครื่องหมายคํานวณ" | mkN "พนักงานต่อโทรศัพท์" | mkN "สัญลักษณ์ทางคณิตศาสตร์" | mkN "ผู้ดําเนินกิจการทางธุรกิจ" | mkN "ผู้ดําเนินกิจการทางอุตสาหกรรม" | mkN "พ่อค้าซื้อขายที่ดินหรืออสังหาริมทรัพย์" ; -- src=panlex
lin mount_V2 = mkV2 "ขึ้น" ; ---- | mkV "สมพาส" | mkV "ขึ้นขี่" | mkV "ไต่ขึ้น" | mkV "ขึ้นคร่อม" | mkV "เพิ่มขี้น" | mkV "พอกพูน" | mkV "จัดตั้ง" | mkV "จัดแสดง" | mkV "เพิ่มขึ้น" | mkV "นําออกแสดง" ; -- src=panlex
lin mount_V = mkV "ขึ้น" | mkV "สมพาส" | mkV "ขึ้นขี่" | mkV "ไต่ขึ้น" | mkV "ขึ้นคร่อม" | mkV "เพิ่มขี้น" | mkV "พอกพูน" | mkV "จัดตั้ง" | mkV "จัดแสดง" | mkV "เพิ่มขึ้น" | mkV "นําออกแสดง" ; -- src=panlex
lin advance_V2 = mkV2 "ขึ้น" ; ---- | mkV "พัฒนา" | mkV "เพิ่ม" | mkV "ขึ้นนำ" | mkV "ก้าวหน้า" | mkV "ขึ้นแท่น" | mkV "ส่งเสริม" | mkV "เคลื่อนไป" | mkV "ได้เปรียบ" | mkV "เลื่อนขั้น" | mkV "เลื่อนชั้น" | mkV "นำมาพิจารณา" | mkV "เลื่อนตำแหน่ง" | mkV "ให้เบิกล่วงหน้า" | mkV "เคลื่อนไปข้างหน้า" | mkV "เร่ง" | mkV "เพิ่ม" | mkV "ให้ยืม" | mkV "คืบหน้า" | mkV "รุดหน้า" | mkV "ก้าวหน้า" | mkV "ล้ําหน้า" | mkV "เพิ่มขึ้น" | mkV "เลื่อนขึ้น" | mkV "ให้ล่วงหน้า" | mkV "จ่ายล่วงหน้า" | mkV "ทําให้เร็วขึ้น" | mkV "เลื่อนตําแหน่ง" | mkV "เคลื่อนไปข้างหน้า" | mkV "ทําให้เคลื่อนไปข้างหน้า" ; -- src=panlex
lin advance_V = mkV "ขึ้น" | mkV "พัฒนา" | mkV "เพิ่ม" | mkV "ขึ้นนำ" | mkV "ก้าวหน้า" | mkV "ขึ้นแท่น" | mkV "ส่งเสริม" | mkV "เคลื่อนไป" | mkV "ได้เปรียบ" | mkV "เลื่อนขั้น" | mkV "เลื่อนชั้น" | mkV "นำมาพิจารณา" | mkV "เลื่อนตำแหน่ง" | mkV "ให้เบิกล่วงหน้า" | mkV "เคลื่อนไปข้างหน้า" | mkV "เร่ง" | mkV "เพิ่ม" | mkV "ให้ยืม" | mkV "คืบหน้า" | mkV "รุดหน้า" | mkV "ก้าวหน้า" | mkV "ล้ําหน้า" | mkV "เพิ่มขึ้น" | mkV "เลื่อนขึ้น" | mkV "ให้ล่วงหน้า" | mkV "จ่ายล่วงหน้า" | mkV "ทําให้เร็วขึ้น" | mkV "เลื่อนตําแหน่ง" | mkV "เคลื่อนไปข้างหน้า" | mkV "ทําให้เคลื่อนไปข้างหน้า" ; -- src=panlex
lin remote_A = mkA "ซึ่งอยู่ห่างไกล" | mkA "ไกล" | mkA "ห่าง ๆ" | mkA "ยาวนาน" | mkA "ลึกลับ" | mkA "ไกลพ้น" | mkA "เมินเฉย" | mkA "ห่างเหิน" | mkA "นานมาแล้ว" | mkA "โดดเดี่ยว" | mkA "เป็นญาติห่างๆ" | mkA "ไม่เกี่ยวข้องโดยตรง" | mkA "ซึ่งเกี่ยวข้องกันห่างๆ" ; -- src=panlex
lin measurement_N = mkN "การวัด" | mkN "ขนาด" | mkN "การวัด" | mkN "ปริมาณ" | mkN "ปริมาตร" | mkN "หน่วยวัด" | mkN "ขนาดที่วัด" | mkN "ระบบการวัด" ; -- src=panlex
lin favour_VS = mmkVS "ให้สิทธิพิเศษ" ; ---- | mkV "ยกย่อง" | mkV "เชิดชู" | mkV "ชื่นชอบ" | mkV "สนับสนุน" | mkV "อุปถัมภ์" | mkV "ช่วยเหลือ" ; -- src=panlex
lin favour_V2 = mkV2 "ให้สิทธิพิเศษ" ; ---- | mkV "ยกย่อง" | mkV "เชิดชู" | mkV "ชื่นชอบ" | mkV "สนับสนุน" | mkV "อุปถัมภ์" | mkV "ช่วยเหลือ" ; -- src=panlex
lin favour_V = mkV "ให้สิทธิพิเศษ" | mkV "ยกย่อง" | mkV "เชิดชู" | mkV "ชื่นชอบ" | mkV "สนับสนุน" | mkV "อุปถัมภ์" | mkV "ช่วยเหลือ" ; -- src=panlex
lin neither_Det = variants{} ; -- 
lin architecture_N = mkN "งานสถาปนิก" | mkN "สถาปัตยกรรม" | mkN "สถาปัตยกรรมศาสตร์" | mkN "สถาปัตยกรรมคอมพิวเตอร์" | mkN "สิ่งปลูก สร้าง" | mkN "โครงสร้าง" | mkN "สถาปัตยกรรม" | mkN "งานสถาปัตยกรรม" | mkN "วิชาการก่อสร้าง" | mkN "รูปแบบการก่อสร้าง" | mkN "ผลงานทางสถาปัตยกรรม" ; -- src=panlex
lin worth_N = mkN "มูลค่า" | mkN "ค่า" | mkN "ราคา" | mkN "สมกับ" | mkN "มูลค่า" | mkN "ประโยชน์" | mkN "เกิดขึ้น" | mkN "ความสําคัญ" | mkN "ความร่ํารวย" | mkN "คุณประโยชน์" | mkN "ความมั่งคั่ง" | mkN "ทรัพย์สมบัติ" | mkN "คุณค่าทางจิตใจ" | mkN "มูลค่าเป็นเงิน" | mkN "จํานวนมูลค่าเป็นเงินค่าเป็นเงิน" ; -- src=panlex
lin tie_N = mkN "ไท้" | mkN "เนคไท" | mkN "ไม้หมอน" | mkN "เชือกผูก" | mkN "การเสมอกัน" | mkN "เชือกมัดของ" | mkN "ไม้หมอนรถไฟ" | mkN "คะแนนเท่ากัน" | mkN "คะแนนเสมอกัน" | mkN "สาย" | mkN "ด้าย" | mkN "เชือก" | mkN "เนคไท" | mkN "การเสมอกัน" | mkN "สิ่งที่ใช้ผูก" | mkN "สิ่งที่เป็นเงื่อนไข" | mkN "สิ่งที่จํากัดขอบเขตไว้" | mkN "การได้แต้มหรือคะแนนเท่ากัน" | mkN "การได้แต้มหรือคะแนนเสมอกัน" ; -- src=panlex
lin barrier_N = mkN "ที่กั้น" | mkN "อุปสรรคขัดขวาง" | mkN "อุปสรรค" | mkN "สิ่งกีดขวาง" | mkN "สิ่งกีดขวางทางผ่าน" ; -- src=panlex
lin practitioner_N = mkN "ผู้ฝึกหัด" | mkN "แพทย์" | mkN "ผู้ฝึกหัด" | mkN "ผู้ปฏิบัติ" | mkN "ผู้ประกอบการงาน" ; -- src=panlex
lin outstanding_A = mkA "ค้าง" | mkA "เด่น" | mkA "ดีเด่น" | mkA "นูนออก" | mkA "ยังไม่ยุติ" | mkA "ที่ดีเยี่ยม" | mkA "ยังแก้ไม่ตก" | mkA "ที่ค้างชําระ" | mkA "ที่ต้องชําระ" | mkA "ที่ยอดเยี่ยม" | mkA "ยังคงเป็นอยู่" | mkA "ยังไม่สําเร็จ" | mkA "สําคัญโผล่ออก" | mkA "ยังไม่ได้ชําระ" | mkA "ยังคาราคาซังอยู่" | mkA "ที่ยังไม่ได้ชําระ" | mkA "เป็นที่สังเกตเห็นได้" | mkA "ซึ่งสังเกตเห็นได้ง่าย" ; -- src=panlex
lin enthusiasm_N = mkN "ความเบิกบาน" | mkN "ความกระตือรือร้น" | mkN "ความสนใจเป็นพิเศษ" | mkN "ความกระตือรือร้น" | mkN "สิ่งกระตุ้นความสนใจ" | mkN "สิ่งที่ทําให้เกิดความสนใจ" ; -- src=panlex
lin theoretical_A = mkA "เชิงทฤษฎี" | mkA "ตามทฤษฎี" | mkA "เชิงทฤษฎี" | mkA "ตามสมมุติฐาน" | mkA "เป็นสมมุติฐาน" | mkA "เกี่ยวกับทฤษฎี" | mkA "เป็นการคาดคะเน" | mkA "ที่ยึดเอาทฤษฎีเป็นหลัก" | mkA "ที่มีแนวโน้มเป็นการคาดเดา" ; -- src=panlex
lin implementation_N = mkN "การนำไปปฏิบัติ" | mkN "การปฏิบัติเพื่อให้บังเกิดผล" ; -- src=panlex
lin worried_A = mkA "ระทม" | mkA "กลุ้มใจ" | mkA "เป็นห่วง" | mkA "เป็นกังวล" | mkA "เป็นทุกข์" | mkA "วิตกทุกข์ร้อน" | mkA "เป็นทุกข์เป็นร้อน" ; -- src=panlex
lin pitch_N = mkN "แผงลอย" | mkN "การขว้าง" | mkN "น้ำมันดิน" | mkN "ระดับเสียง" | mkN "การขว้างลูก" | mkN "การพิตช์ลูก" | mkN "ความลาดเอียง" | mkN "การขว้างลูกเบสบอล" | mkN "การเล่นลูกพิตช์ชอต" | mkN "ระดับ" | mkN "เรซิน" | mkN "การทอย" | mkN "การโยน" | mkN "แผงลอย" | mkN "ความลาด" | mkN "การขว้าง" | mkN "ตําแหน่ง" | mkN "ยางมะตอย" | mkN "การเร่ขาย" | mkN "ความเอียง" | mkN "จุดสูงสุด" | mkN "การเหวี่ยง" | mkN "น้ํามันดิบ" | mkN "ระดับเสียง" | mkN "การโฆษณาเร่ขาย" | mkN "สนามหญ้าระหว่างไม้ที่ปักในสนามคริกเก็ต" ; -- src=panlex
lin drop_N = mkN "หยด" | mkN "หน้าผา" | mkN "ที่ซ่อนของผิดกฎหมาย" | mkN "การตก" | mkN "การทิ้ง" | mkN "การหล่น" | mkN "หยดน้ํา" | mkN "การปล่อย" ; -- src=panlex
lin phone_V2 = mkV2 "โทร" ; ---- | mkV "โทรหา" | mkV "โทรศัพท์" | mkV "โทรศัพท์หา" | mkV "โทร" | mkV "โทรศัพท์" ; -- src=panlex
lin phone_V = mkV "โทร" | mkV "โทรหา" | mkV "โทรศัพท์" | mkV "โทรศัพท์หา" | mkV "โทร" | mkV "โทรศัพท์" ; -- src=panlex
lin shape_VV = mkVV "เชฟ" ; ---- | mkV "ฟอร์ม" | mkV "ขึ้นรูป" | mkV "มีอิทธิพล" | mkV "ทำให้เป็นรูป" | mkV "ทำให้เป็นรูปร่าง" | mkV "บังเกิดขึ้น" | mkV "ทําให้เป็นรูปแบบ" | mkV "เป็นรูปแบบขึ้นมา" | mkV "ทําให้เป็นรูปร่าง" | mkV "มีอิทธิพลต่อบางสิ่ง" | mkV "เป็นรูปเป็นร่างขึ้น" | mkV "ปรับให้เข้ารูปเข้าร่าง" ; -- src=panlex
lin shape_V2 = mkV2 "เชฟ" ; ---- | mkV "ฟอร์ม" | mkV "ขึ้นรูป" | mkV "มีอิทธิพล" | mkV "ทำให้เป็นรูป" | mkV "ทำให้เป็นรูปร่าง" | mkV "บังเกิดขึ้น" | mkV "ทําให้เป็นรูปแบบ" | mkV "เป็นรูปแบบขึ้นมา" | mkV "ทําให้เป็นรูปร่าง" | mkV "มีอิทธิพลต่อบางสิ่ง" | mkV "เป็นรูปเป็นร่างขึ้น" | mkV "ปรับให้เข้ารูปเข้าร่าง" ; -- src=panlex
lin shape_V = mkV "เชฟ" | mkV "ฟอร์ม" | mkV "ขึ้นรูป" | mkV "มีอิทธิพล" | mkV "ทำให้เป็นรูป" | mkV "ทำให้เป็นรูปร่าง" | mkV "บังเกิดขึ้น" | mkV "ทําให้เป็นรูปแบบ" | mkV "เป็นรูปแบบขึ้นมา" | mkV "ทําให้เป็นรูปร่าง" | mkV "มีอิทธิพลต่อบางสิ่ง" | mkV "เป็นรูปเป็นร่างขึ้น" | mkV "ปรับให้เข้ารูปเข้าร่าง" ; -- src=panlex
lin clinical_A = mkA "เกี่ยวกับคลินิก" | mkA "ที่เกี่ยวกับคลินิค" ; -- src=panlex
lin lane_N = mkN "ซ." | mkN "ซอย" | mkN "เลน" | mkN "ถนนซอย" | mkN "ซอย" | mkN "ทาง" | mkN "เลน" | mkN "โดด" | mkN "ตรอก" | mkN "สันโดษ" | mkN "ทางแคบ ๆ" | mkN "ช่องทาง" | mkN "ทางเดิน" | mkN "ช่องทางเดินรถ" | mkN "ทางวิ่งแข่งของนักกรีฑาแต่ละคน" | mkN "ช่องถนนที่ให้รถผ่านได้หนึ่งคันต่อครั้ง" ; -- src=panlex
lin apple_N = mkN (thbind "แอป" "เปิ้ล") "ลูก" | {-pan-} mkN "แอปเปิ้ล" | mkN "ผลแอปเปิ้ล" | mkN "ลูกแอปเปิ้ล" | mkN "ต้นแอปเปิ้ลสวน" | mkN "แอปเปิล" | mkN "แอปเปิ้ล" | mkN "ลูกเบสบอล" | mkN "ผลแอ๊ปเปิล" | mkN "ต้นแอปเปิ้ล" ; -- src=panlex
lin catalogue_N = mkN "แคตาล็อก" | mkN "รายชื่อ" | mkN "แค็ตตาล็อก" | mkN "บัญชีรายชื่อ" ; -- src=panlex
lin tip_N = mkN "ทิป" | mkN "ปลาย" | mkN "ยอดเขา" | mkN "ปลายแหลม" | mkN "ยอด" | mkN "สุด" | mkN "ปลาย" | mkN "แทรก" | mkN "ต่อปลาย" | mkN "ปลายแหลม" | mkN "การตีเบา ๆ" | mkN "การตีเบาๆ" | mkN "ข้อแนะนํา" | mkN "คําแนะนํา" | mkN "ปลายเรียว" | mkN "เสริมปลาย" | mkN "จุดปลายสุด" | mkN "ประดับปลาย" | mkN "เงินรางวัล" | mkN "เอาปลายออก" | mkN "การเคาะเบา ๆ" | mkN "การลาดเอียง" | mkN "ติดผนวกปลาย" | mkN "ทําให้เอียง" | mkN "จัดให้มีปลาย" | mkN "ใบแทรกหนังสือ" | mkN "การทําให้เอียง" | mkN "ส่วนที่สวมปลาย" | mkN "ส่วนที่อยู่ปลาย" | mkN "เงินรางวัลพิเศษ" | mkN "งินตอบแทนเล็กน้อย" | mkN "สถานที่สําหรับเทขยะ" | mkN "เงินตอบแทนการบริการ" | mkN "ข้อคิดเห็นที่มีประโยชน์" ; -- src=panlex
lin publisher_N = mkN "สำนักพิมพ์" | mkN "ผู้จัดพิมพ์" | mkN "ผู้พิมพ์โฆษณา" | mkN "ผู้แถลง" | mkN "ผู้พิมพ์" | mkN "ผู้โฆษณา" | mkN "โรงพิมพ์" | mkN "ผู้ประกาศ" | mkN "ผู้ตีพิมพ์" | mkN "ผู้จัดพิมพ์" | mkN "สํานักพิมพ์" | mkN "ผู้พิมพ์ผู้โฆษณา" ; -- src=panlex
lin opponentMasc_N = variants{} ; -- 
lin live_A = mkA "สด" | mkA "มีพลัง" | mkA "คุกรุ่น" | mkA "สปริงตัว" | mkA "มีชีวิตชีวา" | mkA "ซึ่งมีกระแสไฟ" | mkA "สด" | mkA "สดใส" | mkA "คุแดง" | mkA "เป็นๆ" | mkA "คงอยู่" | mkA "ไม่ตาย" | mkA "ทันสมัย" | mkA "มีชีวิต" | mkA "เด้งได้" | mkA "มีอํานาจ" | mkA "ถ่ายทอดสด" | mkA "กําลังเล่น" | mkA "ขะมักเขม้น" | mkA "ขับเคลื่อน" | mkA "มีชีวิตชีวา" | mkA "ยังไม่ระเบิด" | mkA "มีสิ่งมีชีวิต" | mkA "อาจปะทุได้อีก" | mkA "เกี่ยวกับชีวิต" | mkA "เต็มไปด้วยพลัง" | mkA "ยังคงใช้กันอยู่" | mkA "เต็มไปด้วยชีวิตชีวา" | mkA "ต่อเข้ากับแหล่งพลังงานไฟฟ้า" | mkA "ที่เกี่ยวข้องกับความสนใจในปัจจุบัน" ; -- src=panlex
lin burden_N = mkN "ภาระ" | mkN "ระวาง" | mkN "หน้าที่" | mkN "แก่นเรื่อง" | mkN "ใจความสำคัญ" | mkN "น้ำหนักบรรทุก" | mkN "ภาระ" | mkN "ระวาง" | mkN "ทําให้ยุ่งยาก" ; -- src=panlex
lin tackle_V2 = mkV2 "แย่งลูก" ; ---- | mkV "สวมบังเหียน" | mkV "ใส่บังเหียน" | mkV "จัดการแก้ปัญหา" | mkV "ควบคุม" | mkV "จัดการ" | mkV "รับมือ" | mkV "เข้าแย่งลูก" | mkV "จัดการแก้ปัญหา" | mkV "แย่งหรือหยุดฝ่ายตรงข้ามที่ครองลูกในการเตะฟุตบอล" ; -- src=panlex
lin tackle_V = mkV "แย่งลูก" | mkV "สวมบังเหียน" | mkV "ใส่บังเหียน" | mkV "จัดการแก้ปัญหา" | mkV "ควบคุม" | mkV "จัดการ" | mkV "รับมือ" | mkV "เข้าแย่งลูก" | mkV "จัดการแก้ปัญหา" | mkV "แย่งหรือหยุดฝ่ายตรงข้ามที่ครองลูกในการเตะฟุตบอล" ; -- src=panlex
lin historian_N = mkN "นักประวัติศาสตร์" | mkN "นักวิชาการประวัติศาสตร์" | mkN "นักวิชาการด้านประวัติศาสตร์" | mkN "นักประวัติศาสตร์" | mkN "ผู้เชี่ยวชาญเกี่ยวกับประวัติศาสตร์" | mkN "นักเขียนเรื่องราวเกี่ยวกับประวัติศาสตร์" ; -- src=panlex
lin bury_V2 = mkV2 "ฝัง" ; ---- | mkV "ฝังศพ" | mkV "กลืนกิน" | mkV "หมกหมุ่น" | mkV "ไม่นึกถึง" | mkV "จม" | mkV "บัง" | mkV "ฝัง" | mkV "ฝังศพ" ; -- src=panlex
lin bury_V = mkV "ฝัง" | mkV "ฝังศพ" | mkV "กลืนกิน" | mkV "หมกหมุ่น" | mkV "ไม่นึกถึง" | mkV "จม" | mkV "บัง" | mkV "ฝัง" | mkV "ฝังศพ" ; -- src=panlex
lin stomach_N = mkN "พุง" | mkN "ท้อง" | mkN "กระเพาะ" | mkN "พระอุทร" | mkN "พุงกะทิ" | mkN "กระเพาะอาหาร" | mkN "ความอยากอาหาร" | mkN "ท้อง" | mkN "โกรธ" | mkN "เสียใจ" | mkN "กระเพาะ" | mkN "ช่องท้อง" | mkN "ความหยิ่ง" | mkN "ความภูมิใจ" | mkN "ความเสียใจ" | mkN "กระเพาะอาหาร" | mkN "เก็บไว้ในกระ-เพาะอาหาร" | mkN "ความอยากอาหาร" ; -- src=panlex
lin percentage_N = mkN "หุ้น" | mkN "ร้อยละ" | mkN "เปอร์เซนต์" | mkN "อัตราร้อยล" | mkN "อัตราร้อยละ" | mkN "จํานวนร้อยละ" | mkN "อัตราต่อหนึ่งร้อย" ; -- src=panlex
lin evaluation_N = mkN "การประเมิน" | mkN "การประเมินค่า" ; -- src=panlex
lin outline_V2 = variants{} ; -- 
lin talent_N = mkN "พรสวรรค์" | mkN "ความสามารถ" | mkN "คนมีพรสวรรค์" | mkN "พรสวรรค์" | mkN "ผู้มีพรสวรรค์" | mkN "ความสามารถพิเศษ" | mkN "กลุ่มคนที่มีความสามารถ" | mkN "ผู้ที่มีความสามารถพิเศษ" | mkN "บุคคลที่มีความสามารถพิเศษ" ; -- src=panlex
lin lend_V2 = mkV2 "ให้กู้" ; ---- | mkV "ให้ยืม" | mkV "เปิดทาง" | mkV "เพิ่มระดับ" | mkV "เพิ่มคุณภาพ" | mkV "ให้ยืม" ; -- src=panlex
lin lend_V = mkV "ให้กู้" | mkV "ให้ยืม" | mkV "เปิดทาง" | mkV "เพิ่มระดับ" | mkV "เพิ่มคุณภาพ" | mkV "ให้ยืม" ; -- src=panlex
lin silver_N = mkN "เงิน" | {-pan-} mkN "ธาตุเงิน" | mkN "สีเทาเงิน" | mkN "เหรียญเงิน" | mkN "เครื่องเงิน" | mkN "เลขอะตอม 47" | mkN "หิรัญ" | mkN "สีเงิน" | mkN "แร่เงิน" | mkN "ธาตุเงิน" | mkN "ภาชนะเงิน" | mkN "เหรียญเงิน" | mkN "เครื่องเงิน" | mkN "สิ่งที่คล้ายเงิน" ; -- src=panlex ----?
lin pack_N = mkN "กอง" | mkN "หมู่" | mkN "แพ็ค" | mkN "กลุ่ม" | mkN "แก๊งค์" | mkN "กลุ่มภายใน" | mkN "พวกอันธพาล" | mkN "ครีมพอกหน้า" | mkN "จำนวนมากมาย" | mkN "วัสดุปิดแผล" | mkN "แก็งค์อาชญากร" | mkN "แก๊งค์อันธพาล" | mkN "ฝูงสัตว์นักล่า" | mkN "แก็งค์อาชญากรรม" | mkN "ฝูงสัตว์ล่าเหยื่อ" | mkN "กลุ่มผลประโยชน์ร่วม" | mkN "คณะ" | mkN "ฝูง" | mkN "พวก" | mkN "มัด" | mkN "หีบ" | mkN "ห่อ" | mkN "หมู่" | mkN "แก๊ง" | mkN "กลุ่ม" | mkN "เลือก" | mkN "เหล่า" | mkN "รวบรวม" | mkN "หีบห่อ" | mkN "กลุ่มคน" | mkN "ของจํานวนมาก" | mkN "ของที่กองรวมกัน" | mkN "กระเป๋าสะพายหลัง" ; -- src=panlex
lin fun_N = mkN "ความสนุก" | mkN "ความสนุกสนาน" | mkN "ความสนุกสุดเหวี่ยง" | mkN "ความขบขัน" | mkN "เรื่องขบขัน" | mkN "ความรื่นเริง" | mkN "ความสนุกสนาน" | mkN "ความครึกครื้น" | mkN "สิ่งบันเทิงใจ" | mkN "ความสนุกสนานครื้นเครง" | mkN "สิ่งที่ทําให้สนุกสนาน" ; -- src=panlex
lin democrat_N = mkN "ผู้สนับสนุนประชาธิปไตย" | mkN "นักประชาธิปไตย" | mkN "สมาชิกพรรคเดมโมแครท" | mkN "ผู้นิยมการปกครองในระบบประชาธิปไตย" | mkN "ผู้นิยมการปกครองในระบอบประชาธิปไตย" ; -- src=panlex
lin fortune_N = mkN "โชค" | mkN "วาสนา" | mkN "ชะตากรรม" | mkN "โชค" | mkN "โชคดี" | mkN "โชคลาภ" | mkN "โชคชะตา" | mkN "ผู้รับมรดก" | mkN "ความสําเร็จ" | mkN "ความรุ่งเรือง" | mkN "ทรัพย์สมบัติมากมาย" | mkN "ทรัพย์สมบัติจํานวนมาก" ; -- src=panlex
lin storage_N = mkN "เมม" | mkN "เมมโมรี่" | mkN "คลังพัสดุ" | mkN "คลังเก็บสินค้า" | mkN "การจัดเก็บข้อมูล" | mkN "ธุรกิจคลังสินค้า" | mkN "ธุรกิจจัดเก็บสินค้า" | mkN "หน่วยความจำคอมพิวเตอร์" | mkN "การเก็บ" | mkN "ที่เก็บ" | mkN "สถานที่เก็บ" | mkN "การเก็บรักษา" | mkN "ตัวเก็บข้อมูล" | mkN "แหล่งเก็บข้อมูล" | mkN "สถานที่เก็บรักษา" | mkN "ค่าเก็บรักษาสินค้า" | mkN "ตัวบันทึกความจําในคอมพิวเตอร์" ; -- src=panlex
lin professional_N = mkN "มือโปร" | mkN "มืออาชีพ" | mkN "นักกีฬาอาชีพ" | mkN "ผู้เชี่ยวชาญ" | mkN "ผู้ประกอบอาชีพ" | mkN "มืออาชีพ" | mkN "ผู้เชี่ยวชาญ" | mkN "ผู้เชี่ยวชาญในวิชาชีพ" | mkN "ผู้ที่เล่นกีฬาหรือทํางานศิลปะเป็นอาชีพ" ; -- src=panlex
lin reserve_N = mkN "ของสำรอง" | mkN "ตัวสำรอง" | mkN "ผู้เล่นสำรอง" | mkN "ความเงียบขรึม" | mkN "นักกีฬาตัวสำรอง" | mkN "การเป็นคนไม่ค่อยพูด" | mkN "กองหนุน" | mkN "เขตสงวน" | mkN "กําลังพล" | mkN "เงินสะสม" | mkN "กองกําลัง" | mkN "ตัวสํารอง" | mkN "เงินสํารอง" | mkN "พื้นที่สงวน" | mkN "สิ่งที่สํารองไว้" ; -- src=panlex
lin interval_N = mkN "ช่วง" | mkN "ขั้นคู่" | mkN "ช่วงเวลา" | mkN "ช่องห่าง" | mkN "ระยะห่าง" | mkN "ขั้นคู่เสียง" | mkN "ช่วง" | mkN "เวลาพัก" | mkN "ช่วงห่าง" | mkN "ช่วงเวลา" | mkN "ระยะเวลา" | mkN "เวลาว่าง" | mkN "ช่วงระหว่าง" | mkN "เวลาระหว่าง" | mkN "เป็นครั้งคราว" | mkN "หยุดพักเป็นช่วงๆ" ; -- src=panlex
lin dimension_N = mkN "มิติ" | mkN "ไดเมนชั่น" | mkN "ขนาด" | mkN "มิติ" | mkN "" | mkN "ขอบข่าย" | mkN "การหามิติ" | mkN "การวัดขนาด" | mkN "การวัดระยะ" | mkN "ความสําคัญ" | mkN "การหาขอบเขต" | mkN "ขนาดกว้างยาวและหนา" ; -- src=panlex
lin honest_A = mkA "แท้" | mkA "จริง" | mkA "ตงฉิน" | mkA "สะอาด" | mkA "สุจริต" | mkA "ซื่อตรง" | mkA "มือสะอาด" | mkA "ซื่อสัตย์" | mkA "ซึ่งวางใจได้" | mkA "ซึ่งไว้ใจได้" | mkA "ซึ่งพึ่งพาได้" | mkA "ซึ่งตรงไปตรงมา" | mkA "ซื่อสัตย์สุจริต" | mkA "ง่าย ๆ" | mkA "เรียบ ๆ" | mkA "สุจริต" | mkA "ชื่อตรง" | mkA "ซื่อตรง" | mkA "ถ่อมตัว" | mkA "ไม่ปลอม" | mkA "ยุติธรรม" | mkA "ซื่อสัตย์" | mkA "เที่ยงตรง" | mkA "ไม่เจือปน" | mkA "เที่ยงธรรม" | mkA "น่าเชื่อถือ" | mkA "ไม่ลําเอียง" | mkA "ไม่เข้าข้างใดข้างหนึ่ง" ; -- src=panlex
lin awful_A = mkA "แย่มาก" | mkA "น่ากลัว" | mkA "น่ายําเกรง" | mkA "ไม่น่าพอใจ" | mkA "น่าสะพรึงกลัว" | mkA "น่าเลื่อมใสศรัทธา" ; -- src=panlex
lin manufacture_V2 = variants{} ; -- 
lin confusion_N = mkN "ความสับสน" | mkN "จิตใจสับสน" | mkN "ความว้าวุ่น" | mkN "ความยุ่งวุ่นวาย" | mkN "ความชุลมุนวุ่นวาย" | mkN "ความสับสนวุ่นวายใจ" | mkN "ความงงงวย" | mkN "ความสับสน" | mkN "ความไม่ชัด" | mkN "ความพ่ายแพ้" | mkN "ความยุ่งเหยิง" | mkN "ความเสื่อมสลาย" | mkN "การให้ยุ่งหรือสับสน" ; -- src=panlex
lin pink_A = mkA "ชมพู" | mkA "ชมพู" | mkA "สีชมพู" | mkA "ซึ่งมีสีชมพู" ; -- src=panlex
lin impressive_A = mkA "รุนแรง" | mkA "น่าทึ่ง" | mkA "ประทับใจ" | mkA "ซาบซึ้งใจ" | mkA "ซึ่งจับใจ" | mkA "น่าชื่นชม" | mkA "เหลือขนาด" | mkA "น่าซาบซึ้งใจ" | mkA "ซึ่งน่าประทับใจ" ; -- src=panlex
lin satisfaction_N = mkN "การทำให้พึงพอใจ" | mkN "การชดเชย" | mkN "การชดใช้" | mkN "ความพอใจ" | mkN "ความถูกใจ" | mkN "การถ่ายบาป" | mkN "การแก้แค้น" | mkN "สิ่งที่ชดเชย" | mkN "การทําให้พอใจ" | mkN "การทําให้พึงพอใจ" ; -- src=panlex
lin visible_A = mkA "เด่น" | mkA "ชัดเจน" | mkA "แน่ชัด" | mkA "ชัดแจ้ง" | mkA "เห็นได้" | mkA "มองเห็นได้" | mkA "ที่สามารถมองเห็นได้" ; -- src=panlex
lin vessel_N = mkN "หลอด" | mkN "ภาชนะ" | mkN "พาหนะทางน้ำ" | mkN "ยานพาหนะทางน้ำ" | mkN "หลอด" | mkN "เรือ ท่อ" | mkN "บุคคล" | mkN "หลอดเลือด" | mkN "ภาชนะใส่ของเหลว" | mkN "เรือเดินสมุทรขนาดใหญ่" ; -- src=panlex
lin stand_N = mkN "ฐาน" | mkN "แท่น" | mkN "ทรรศนะ" | mkN "มุมมอง" | mkN "แง่มุม" | mkN "แผงลอย" | mkN "จุดที่ยืน" | mkN "เวทีวงดนตรี" | mkN "แผงขายสินค้า" | mkN "ตำแหน่งที่ยืน" | mkN "บููทขายสินค้า" | mkN "การยืน" | mkN "จุดยืน" ; -- src=panlex
lin curve_N = mkN "โค้ง" | mkN "เคิร์ฟ" | mkN "ทางโค้ง" | mkN "รูปโค้ง" | mkN "ความโค้ง" | mkN "เส้นโค้ง" | mkN "การขว้างลูกโค้ง" | mkN "ทางโค้ง" | mkN "แนวโค้ง" | mkN "เส้นโค้ง" ; -- src=panlex
lin pot_N = mkN "พุง" | mkN "หม้อ" | mkN "กลุ่ม" | mkN "เนื้อ" | mkN "กระถาง" | mkN "มากมาย" | mkN "โถส้วม" | mkN "จำนวนมาก" | mkN "เงินแจ็กพ็อต" | mkN "จำนวนมากมายก่ายกอง" | mkN "ตัวต้านทานโพเทนติโอมิเตอร์" | mkN "ยิง" | mkN "หม้อ" | mkN "กัญชา" | mkN "กระถาง" | mkN "กระปุก" | mkN "กาน้ํา" | mkN "เหยือก" | mkN "หลุมลึก" | mkN "บรรจุขวด" | mkN "ภาชนะบรรจุ" | mkN "ภาชนะดินเผา" | mkN "ภาชนะหุงต้ม" | mkN "กระถางดินเผา" | mkN "จํานวนมากมาย" | mkN "เงินจํานวนมาก" | mkN "เงินพนันกองกลางทั้งหมด" | mkN "จํานวน 1 หม้อ" ; -- src=panlex
lin replacement_N = mkN "การแทนที่" | mkN "ผู้สืบทอด" | mkN "การทดแทน" | mkN "ของทดแทน" | mkN "การแทนที่" | mkN "การรับช่วง" | mkN "การชดใช้คืน" | mkN "การสวมตําแหน่ง" | mkN "การทําหน้าที่แทน" | mkN "บุคคลที่เข้าแทนคนอื่น" ; -- src=panlex
lin accurate_A = mkA "เที่ยงตรง" | mkA "แน่นอน" | mkA "ถูกต้อง" | mkA "แม่นยํา" | mkA "เที่ยงตรง" | mkA "ระมัดระวัง" | mkA "ไร้ข้อผิดพลาด" ; -- src=panlex
lin mortgage_N = mkN "การจำนอง" | mkN "จํานอง" | mkN "การจํานอง" | mkN "เป็นพันธะ" | mkN "ให้คํามั่น" | mkN "สัญญาจํานอง" ; -- src=panlex
lin salary_N = mkN "ค่าแรง" | mkN "ค่าจ้าง" | mkN "เงินเดือน" | mkN "ค่าจ้างรายเดือน" ; -- src=panlex
lin impress_V2 = mkV2 "พิมพ์" ; ---- | mkV "จัดพิมพ์" | mkV "ประทับใจ" | mkV "ประทับตรา" | mkV "กด" | mkV "จับใจ" | mkV "ตรึงใจ" | mkV "ประทับ" | mkV "ประทับใจ" | mkV "เน้นย้ํา" | mkV "ซาบซึ้งใจ" | mkV "ประทับตรา" | mkV "ติดอกติดใจ" | mkV "ทําให้ประทับใจ" | mkV "ทําให้ติดอกติดใจ" | mkV "ทําให้ซาบซึ้งตรึงใจ" | mkV "ทําให้เข้าใจแจ่มแจ้ง" | mkV "ยึดเพื่อเป็นสาธารณประโยชน์" ; -- src=panlex
lin impress_V = mkV "พิมพ์" | mkV "จัดพิมพ์" | mkV "ประทับใจ" | mkV "ประทับตรา" | mkV "กด" | mkV "จับใจ" | mkV "ตรึงใจ" | mkV "ประทับ" | mkV "ประทับใจ" | mkV "เน้นย้ํา" | mkV "ซาบซึ้งใจ" | mkV "ประทับตรา" | mkV "ติดอกติดใจ" | mkV "ทําให้ประทับใจ" | mkV "ทําให้ติดอกติดใจ" | mkV "ทําให้ซาบซึ้งตรึงใจ" | mkV "ทําให้เข้าใจแจ่มแจ้ง" | mkV "ยึดเพื่อเป็นสาธารณประโยชน์" ; -- src=panlex
lin constitutional_A = mkA "เป็นรากฐาน" | mkA "เป็นส่วนสําคัญ" | mkA "ที่เป็นส่วนกําเนิด" | mkA "ที่เป็นส่วนพื้นฐาน" | mkA "เป็นประโยชน์ต่อสุขภาพ" | mkA "ที่เป็นส่วนหนึ่งที่จําเป็น" | mkA "ถูกต้องหรือเป็นไปตามรัฐธรรมนูญ" ; -- src=panlex
lin emphasize_VS = variants{} ; -- 
lin emphasize_V2 = variants{} ; -- 
lin developing_A = mkA "ที่กําลังพัฒนา" ; -- src=panlex
lin proof_N = mkN "พรูฟ" | mkN "การพิสูจน์" | mkN "ข้อพิสูจน์" | mkN "ฉบับที่ใช้พิสูจน์อักษร" | mkN "พยาน" | mkN "ทดลอง" | mkN "กําลัง" | mkN "ไม่ซึม" | mkN "กันทะลุ" | mkN "กันน้ํา" | mkN "ตรวจสอบ" | mkN "ต้านทาน" | mkN "หลักฐาน" | mkN "การทดสอบ" | mkN "การตรวจทาน" | mkN "การพิสูจน์" | mkN "ไม่หวั่นไหว" | mkN "การตรวจปรู๊ฟ" | mkN "ป้องกันไฟได้" | mkN "ความเข้มข้นของแอลกอฮอล" | mkN "คุณสมบัติที่ผ่านการตรวจสอบแล้ว" ; -- src=panlex
lin furthermore_Adv = mkAdv "นอกจากนี้" | mkAdv "นอกจากนี้" | mkAdv "ยิ่งกว่านี้" | mkAdv "มากไปกว่านี้" ; -- src=panlex
lin dish_N = mkN "กับ" | mkN "จาน" | mkN "เมนู" | mkN "คนสวย" | mkN "สาวงาม" | mkN "กับข้าว" | mkN "งานสบาย" | mkN "ความมีเสน่ห์" | mkN "จานรับสัญญาณ" | mkN "จาน" | mkN "ชาม" | mkN "อาหาร" ; -- src=panlex
lin interview_V2 = variants{} ; -- 
lin considerably_Adv = variants{} ; -- 
lin distant_A = mkA "ซึ่งอยู่ห่างไกล" | mkA "ไกล" | mkA "ยาวนาน" | mkA "แยกกัน" | mkA "ห่างไกล" | mkA "ไกลลับตา" | mkA "ไม่คุ้นเคย" | mkA "ไม่ต่อเนื่องกัน" ; -- src=panlex
lin lower_V2 = mkV2 "เอาลงมา" ; ---- | mkV "ทำหน้าบูด" | mkV "ทำหน้าบึ้ง" | mkV "จม" | mkV "จมลง" | mkV "ลดลง" | mkV "ดํามืด" | mkV "น้อยลง" | mkV "ลดเสียง" | mkV "ขมวดคิ้ว" | mkV "ลดต่ําลง" | mkV "ลดเกียรติ" | mkV "ทําให้ต่ําลง" | mkV "ทําหน้าบูดบึ้ง" | mkV "ทําให้ต่ําต้อย" | mkV "ทําให้เสื่อมเสีย" | mkV "ลดระดับความดังของเสียง" ; -- src=panlex
lin lower_V = mkV "เอาลงมา" | mkV "ทำหน้าบูด" | mkV "ทำหน้าบึ้ง" | mkV "จม" | mkV "จมลง" | mkV "ลดลง" | mkV "ดํามืด" | mkV "น้อยลง" | mkV "ลดเสียง" | mkV "ขมวดคิ้ว" | mkV "ลดต่ําลง" | mkV "ลดเกียรติ" | mkV "ทําให้ต่ําลง" | mkV "ทําหน้าบูดบึ้ง" | mkV "ทําให้ต่ําต้อย" | mkV "ทําให้เสื่อมเสีย" | mkV "ลดระดับความดังของเสียง" ; -- src=panlex
lin favouriteMasc_N = variants{} ; -- 
lin tear_V2 = mkV2 "ฉีก" ; ---- | mkV "แตก" | mkV "ถอนขน" | mkV "ระเบิด" | mkV "น้ำตาคลอ" | mkV "น้ำตาไหล" | mkV "น้ำตาคลอเบ้า" | mkV "น้ำตาคลอหน่วย" | mkV "ฉีก" | mkV "รี่" | mkV "ฉีกออก" | mkV "เร่งรีบ" | mkV "แบ่งออก" | mkV "รีบตะบึง" | mkV "ไม่สบายใจ" | mkV "ทําให้เป็นรู" | mkV "น้ําตาไหลออกมา" | mkV "ทําให้ไม่สบายใจ" | mkV "เคลื่อนที่หรือกระทําอย่างเร่งรีบ" ; -- src=panlex
lin tear_V = mkV "ฉีก" | mkV "แตก" | mkV "ถอนขน" | mkV "ระเบิด" | mkV "น้ำตาคลอ" | mkV "น้ำตาไหล" | mkV "น้ำตาคลอเบ้า" | mkV "น้ำตาคลอหน่วย" | mkV "ฉีก" | mkV "รี่" | mkV "ฉีกออก" | mkV "เร่งรีบ" | mkV "แบ่งออก" | mkV "รีบตะบึง" | mkV "ไม่สบายใจ" | mkV "ทําให้เป็นรู" | mkV "น้ําตาไหลออกมา" | mkV "ทําให้ไม่สบายใจ" | mkV "เคลื่อนที่หรือกระทําอย่างเร่งรีบ" ; -- src=panlex
lin fixed_A = mkA "ถาวร" | mkA "มั่นคง" | mkA "แน่นอน" | mkA "ติดแน่น" | mkA "ที่ตายตัว" | mkA "ที่มั่นคง" | mkA "ไม่ผันแปร" | mkA "เป็นระเบียบ" | mkA "ที่เหนียวแน่น" | mkA "ซึ่งได้กําหนดไว้" | mkA "ที่ปรับเปลี่ยนได้ยาก" | mkA "ที่ไม่สามารถเปลี่ยนแปลง" | mkA "ซึ่งได้ทําให้มั่นคงหรือถาวร" | mkA "เป็นการเพ่งมองหรือเพ่งความสนใจ" ; -- src=panlex
lin by_Adv = mkAdv "ผ่าน" | mkAdv "สำรอง" | mkAdv "ก่อนเวลาที่กําหนด" ; -- src=panlex
lin luck_N = mkN "โชค" | mkN "วาสนา" | mkN "ชะตากรรม" | mkN "ดวง" | mkN "โชค" | mkN "วาสนา" | mkN "โชคดี" | mkN "เคราะห์" | mkN "โชคชะตา" | mkN "เคราะห์ดี" ; -- src=panlex
lin count_N = mkN "การนับ" | mkN "เคานต์" | mkN "ท่านเคานต์" | mkN "การนับจำนวน" | mkN "จำนวนที่นับได้ทั้งหมด" | mkN "ผลรวม" | mkN "การนับ" | mkN "การคํานวณ" | mkN "จํานวนรวม" | mkN "การประเมิน" | mkN "การหาผลรวม" | mkN "จํานวนทั้งหมด" | mkN "บรรดาศักดิ์ทางยุโรป" | mkN "ตําแหน่งของขุนนางอังกฤษเทียบเท่ากับเอิร์ล" ; -- src=panlex
lin precise_A = mkA "พอดี" | mkA "จู้จี้" | mkA "แน่นอน" | mkA "ถูกต้อง" | mkA "ละเอียด" | mkA "แม่นยํา" | mkA "เฉียบขาด" | mkA "พิถีพิถัน" | mkA "เที่ยงตรง" | mkA "ระมัดระวัง" | mkA "ชัดถ้อยชัดคํา" ; -- src=panlex
lin determination_N = mkN "คำตัดสิน" | mkN "การตัดสินใจ" | mkN "ความมุ่งมั่น" | mkN "ความเห็นต่อท้าย" | mkN "การยุติ" | mkN "การสรุป" | mkN "การคํานวณ" | mkN "การตกลงใจ" | mkN "ความตั้งใจ" | mkN "ความมุมานะ" | mkN "การตัดสินใจ" | mkN "ความแน่วแน่" | mkN "ความมุ่งมั่น" | mkN "การลงความเห็น" | mkN "ความตั้งใจมั่น" | mkN "ผลของการคํานวณ" | mkN "การกําหนดความแน่นอน" ; -- src=panlex
lin bite_V2 = mkV2 (thword "กัด") ;
lin bite_V = mkV "กัด" | mkV "ต่อย" | mkV "แผดเผา" | mkV "ขบ" | mkV "กัด" | mkV "งับ" ; -- src=panlex
lin dear_Interj = variants{} ; -- 
lin consultation_N = mkN "การหารือ" | mkN "การเข้าหารือ" | mkN "การให้คำปรึกษา" | mkN "การปรึกษา" | mkN "การปรึกษาหารือ" | mkN "การประชุมปรึกษาหารือ" | mkN "การประชุมแลกเปลี่ยนความคิดเห็น" ; -- src=panlex
lin range_V = mkV "พุ่ง" | mkV "ปล่อย" | mkV "เร่ร่อน" | mkV "ครอบคลุม" | mkV "เร่่ร่อน" | mkV "จัดอันดับ" | mkV "จัดเตรียม" | mkV "มีระยะยิง" | mkV "จัดเร็ตติ้ง" | mkV "จัดแถว" | mkV "จัดแนว" | mkV "จัดลําดับ" | mkV "ตั้งวิถียิง" | mkV "ผันแปรภายในขอบเขตหนึ่ง" | mkV "เปลี่ยนแปลงในช่วงหนึ่ง" | mkV "ปล่อยให้สัตว์ไปกินหญ้าในทุ่ง" ; -- src=panlex
lin residential_A = mkA "สำหรับพักอาศัย" | mkA "เกี่ยวกับที่พัก" | mkA "เกี่ยวกับถิ่นที่อยู่" | mkA "เกี่ยวกับที่พักอาศัย" | mkA "เกี่ยวกับการอยู่อาศัย" ; -- src=panlex
lin conduct_N = mkN "มารยาท" | mkN "พฤติกรรม" | mkN "การจัดการ" | mkN "ความประพฤติ" ; -- src=panlex
lin capture_V2 = variants{} ; -- 
lin ultimately_Adv = variants{} ; -- 
lin cheque_N = mkN "เช็ค" | mkN "เช็ค" | mkN "ใบสั่งจ่ายเงิน" | mkN "เอกสารที่ผู้สั่งจ่ายเขียนเพื่อให้ธนาคารจ่ายเงินแก่ผู้ถือ" ; -- src=panlex
lin economics_N = mkN "เศรษฐศาสตร์" | mkN "เศรษฐศาสตร์การเมือง" | mkN "เศรษฐศาสตร์" | mkN "สภาพเศรษฐกิจ" | mkN "วิชาเศรษฐศาสตร์" ; -- src=panlex
lin sustain_V2 = variants{} ; -- 
lin secondly_Adv = mkAdv "อย่างเป็นอันดับสอง" | mkAdv "ถัดไป" | mkAdv "ที่สอง" | mkAdv "ลําดับต่อไป" | mkAdv "ในลําดับสอง" | mkAdv "ในลําดับที่สอง" ; -- src=panlex
lin silly_A = mkA "งี่เง่า" | mkA "งง" | mkA "มึน" | mkA "โง่" | mkA "ทึ่ม" | mkA "เขลา" | mkA "เง่า" | mkA "เซ่อ" | mkA "คนโง่" | mkA "งงงัน" | mkA "คนเง่า" | mkA "อ่อนแอ" | mkA "เหลวไหล" | mkA "ไร้สาระ" | mkA "น่าสมเพท" | mkA "น่าเวทนา" | mkA "ไร้เหตุผล" ; -- src=panlex
lin merchant_N = mkN "พ่อค้า" | mkN "แม่ค้า" | mkN "ผู้ค้าปลีก" | mkN "พ่อค้าแม่ขาย" | mkN "พ่อค้าแม่ค้า" | mkN "ผู้ประกอบการค้าปลีก" | mkN "คนขาย" | mkN "ผู้ขาย" | mkN "ผู้ค้า" | mkN "พ่อค้า" | mkN "คนขายของ" | mkN "นายวาณิช" | mkN "เซลล์แมน" | mkN "ผู้จําหน่าย" | mkN "เจ้าของร้าน" | mkN "เกี่ยวกับเรือพาณิชย์สมุทร" ; -- src=panlex
lin lecture_N = mkN "ปาฐกถา" | mkN "เลกเชอร์" | mkN "การบรรยาย" | mkN "การกล่าวปราศัย" | mkN "การบรรยาย" ; -- src=panlex
lin musical_A = mkA "ที่มีทำนอง" | mkA "ที่เป็นเพลง" | mkA "ที่มีท่วงทำนอง" | mkA "ไพเราะ" | mkA "เสนาะหู" | mkA "เพราะพริ้ง" | mkA "ในทางดนตรี" | mkA "เกี่ยวกับดนตรี" | mkA "ซึ่งมีเสียงไพเราะ" | mkA "ซึ่งมีทักษะทางดนตรี" ; -- src=panlex
lin leisure_N = mkN "เวลาพักผ่อน" | mkN "เวลาว่าง" | mkN "การว่างจากงาน" ; -- src=panlex
lin check_N = mkN "รอย" | mkN "เช็ค" | mkN "การรุก" | mkN "การตรวจ" | mkN "การหยุด" | mkN "รอยสลัก" | mkN "ใบเสร็จ" | mkN "การควบคุม" | mkN "เช็คมาร์ค" | mkN "การตรวจจับ" | mkN "การพิสูจน์" | mkN "การเข้าสกัด" | mkN "สิ่งกีดขวาง" | mkN "การหยุดชะงัก" | mkN "ลายตารางหมากรุก" | mkN "รอย" | mkN "เช็ค" | mkN "การหยุด" | mkN "การเช็ค" | mkN "ใบเสร็จ" | mkN "การทดสอบ" | mkN "ตาหมากรุก" | mkN "การตรวจสอบ" | mkN "ลายหมากรุก" | mkN "การตรวจสภาพ" | mkN "การเข้าสกัด" | mkN "รอยร้าวเล็กๆ" | mkN "หนังสือตราสาร" | mkN "การเข้ากีดขวาง" | mkN "การหยุดอยู่กับที่" | mkN "สิ่งที่เหนี่ยวรั้งจิตใจ" ; -- src=panlex
lin cheese_N = mkN (thword "เนย" "แข็ง") "ก้อน" | {-pan-} mkN "ชีส" | mkN "ต้นชีส" | mkN "ต้นแมลโลว์สูง" | mkN "ชีส" | mkN "เนยแข็ง" | mkN "โชคไม่ดี" ; -- src=panlex
lin lift_N = mkN "การยก" | mkN "ลิฟต์" | mkN "แรงยก" | mkN "ลิฟต์สกี" | mkN "การยกขึ้น" | mkN "การดึงหน้า" | mkN "การยกสูงขึ้น" | mkN "การขนส่งทางอากาศ" | mkN "การยก" | mkN "ลิฟต์" | mkN "การขโมย" | mkN "ความดีใจ" | mkN "การโดยสาร" | mkN "การพาไปส่ง" | mkN "การหยิบฉวย" | mkN "การแบกขึ้น" | mkN "ความร่าเริง" | mkN "การโดยสารไปด้วย" | mkN "การให้ติดรถไปด้วย" | mkN "ความกระปรี้กระเปร่า" ; -- src=panlex
lin participate_V2 = mkV2 "ร่วม" ; ---- | mkV "เข้า" | mkV "มีส่วน" | mkV "มีส่วนร่วม" | mkV "มีส่วน" | mkV "ร่วมมือ" | mkV "เข้าร่วม" | mkV "มีส่วนร่วม" | mkV "ร่วมกระทํา" | mkV "เกี่ยวข้อง" ; -- src=panlex
lin participate_V = mkV "ร่วม" | mkV "เข้า" | mkV "มีส่วน" | mkV "มีส่วนร่วม" | mkV "มีส่วน" | mkV "ร่วมมือ" | mkV "เข้าร่วม" | mkV "มีส่วนร่วม" | mkV "ร่วมกระทํา" | mkV "เกี่ยวข้อง" ; -- src=panlex
lin fabric_N = mkN "ผ้า" | mkN "สิ่งทอ" | mkN "ผ้า" | mkN "ผ้าไหม" | mkN "สิ่งทอ" | mkN "ผ้าฝ้าย" | mkN "ตัวอาคาร" | mkN "โครงสร้าง" | mkN "ผ้าขนสัตว์" | mkN "วิธีการสร้าง" | mkN "ผ้าหรือสิ่งทอ" | mkN "โครงสร้างของตึกหรืออาคาร" | mkN "โครงสร้างของสิ่งที่เป็นรูปธรรม เช่น โครงสร้างของสังคม" ; -- src=panlex
lin distribute_V2 = variants{} ; -- 
lin lover_N = mkN "แฟน" | mkN "สาวก" | mkN "คนรัก" | mkN "คู่รัก" | mkN "คู่เลิฟ" | mkN "ผู้นับถือ" | mkN "คนมีความรัก" | mkN "แฟน" | mkN "คนรัก" | mkN "คู่รัก" | mkN "คนที่ชอบ" ; -- src=panlex
lin childhood_N = mkN "วัยเด็ก" | mkN "ความเป็นเด็ก" | mkN "ช่วงเป็นเด็ก" | mkN "ปฐมวัย" | mkN "วัยต้น" | mkN "ช่วงต้น" | mkN "วัยเด็ก" | mkN "ระยะต้นๆ" | mkN "ความเป็นเด็ก" | mkN "ระยะแรกเริ่ม" ; -- src=panlex
lin cool_A = mkA "เย็น" | mkA "เย็นชา" | mkA "ใจเย็น" | mkA "ทันสมัย" | mkA "ดีเยี่ยม" | mkA "หนาวเย็น" | mkA "ซึ่งไม่เป็นมิตร" | mkA "ซึ่งไร้ความรู้สึก" ; -- src=panlex
lin ban_V2 = variants{} ; -- 
lin supposed_A = mkA "คิดเอา" | mkA "นึกเอา" | mkA "สมมุติ" | mkA "อนุมาน" | mkA "คาดคะเน" | mkA "จินตนาการ" | mkA "ทึกทักเอา" | mkA "ซึ่งทึกทักว่าเป็นจริง" | mkA "ซึ่งสมมุติว่าเป็นจริง" ; -- src=panlex
lin mouse_N = mkN "หนู" | mkN "เมาส์" | mkN "ตาฟกช้ำ" | mkN "ตาเขียว" | mkN "ตาบวมปูด" | mkN "เมาส์คอมพิวเตอร์" | mkN "หนู" | mkN "คนตาขาว" ; -- src=panlex
lin strain_N = mkN "พันธุ์" | mkN "ความล้า" | mkN "การร้องเพลง" | mkN "วงศ์" | mkN "ร่องรอย" | mkN "สายเลือด" | mkN "บรรพบุรุษ" | mkN "การทําให้ตึง" | mkN "ความตึงเครียด" ; -- src=panlex
lin specialist_A = variants{} ; -- 
lin consult_V2 = mkV2 "ปรึกษา" ; ---- | mkV "หาข้อมูล" | mkV "เป็นที่ปรึกษา" | mkV "เข้าร่วมประชุม" | mkV "ปรึกษา" | mkV "ขอคําปรึกษา" | mkV "ค้นหาข้อมูล" | mkV "ปรึกษาหารือ" | mkV "ขอความคิดเห็น" | mkV "ทํางานให้คําปรึกษา" ; -- src=panlex
lin consult_V = mkV "ปรึกษา" | mkV "หาข้อมูล" | mkV "เป็นที่ปรึกษา" | mkV "เข้าร่วมประชุม" | mkV "ปรึกษา" | mkV "ขอคําปรึกษา" | mkV "ค้นหาข้อมูล" | mkV "ปรึกษาหารือ" | mkV "ขอความคิดเห็น" | mkV "ทํางานให้คําปรึกษา" ; -- src=panlex
lin minimum_A = mkA "ต่ำที่สุด" | mkA "น้อยที่สุด" | mkA "ต่ําสุด" | mkA "ขั้นต่ํา" | mkA "อย่างต่ํา" | mkA "น้อยที่สุด" ; -- src=panlex
lin approximately_Adv = variants{} ; -- 
lin participant_N = mkN "ผู้เล่น" | mkN "ผู้มีส่วนร่วม" | mkN "ผู้ร่วม" | mkN "ร่วมมือ" | mkN "ผู้เข้าร่วม" | mkN "ผู้มีส่วนร่วม" | mkN "ผู้ร่วมกระทํา" ; -- src=panlex
lin monetary_A = mkA "ที่เป็นเงิน" | mkA "เกี่ยวกับเงิน" | mkA "เกี่ยวกับการเงิน" | mkA "เกี่ยวกับตัวเงิน" | mkA "เกี่ยวกับเงินตรา" | mkA "เกี่ยวกับอัตราแลกเปลี่ยนเงินตรา" ; -- src=panlex
lin confuse_V2 = variants{} ; -- 
lin dare_VV = mkVV "กล้าที่จะ" | mkVV "เสี่ยงที่จะ" ; -- src=panlex
lin dare_V2 = variants{}; -- mkVV "กล้าที่จะ" | mkVV "เสี่ยงที่จะ" ; -- src=panlex
lin smoke_N = mkN (thword "ควัน") | {-pan-} mkN "ควัน" | mkN "เนื้อ" | mkN "ควันไฟ" | mkN "มวนยาสูบ" | mkN "หมอกควัน" | mkN "การเกิดควัน" | mkN "การสูบบุหรี่" | mkN "การขว้างบอลเร็ว" | mkN "ควัน" | mkN "หมอก" | mkN "เขม่า" | mkN "สีควัน" | mkN "ไอน้ํา" | mkN "พ่นควัน" | mkN "คนผิวดํา" | mkN "หมอกควัน" | mkN "การสูบบุ-หรี่" | mkN "ละอองควัน" | mkN "สูบบุหรี่" | mkN "ควันบุหรี่" | mkN "ความคลุมเครือ" | mkN "มีไอลอยขึ้นมา" | mkN "ความไม่ชัดแจ้ง" | mkN "สีน้ําเงินอ่อน" | mkN "บุหรี่หรือซิการ์" | mkN "เจ้าหน้าที่ดับเพลิง" | mkN "สิ่งที่ไม่มีความหมาย" | mkN "ช่วงเวลาของการสูบบุหรี่" | mkN "ระบบอนุภาคของแข็งในแก๊ส" ; -- src=panlex
lin movie_N = mkN "หนัง" | mkN "ภาพยนตร์" | mkN "หนัง" | mkN "ภาพยนต์" | mkN "ภาพยนตร์" | mkN "โรงภาพยนต์" ; -- src=panlex
lin seed_N = mkN (thword "เม็ด") | {-pan-} mkN "น้ำ" | mkN "เม็ด" | mkN "เชื้อ" | mkN "เมล็ด" | mkN "น้ำกาม" | mkN "น้ำรัก" | mkN "น้ำอสุจิ" | mkN "น้ำเชื้อ" | mkN "ดาวยูเรนัส" | mkN "เมล็ดพันธุ์" | mkN "นักกีฬาดีเด่น" | mkN "นักกีฬาดาวรุ่ง" | mkN "เม็ด" | mkN "เชื้อ" | mkN "เมล็ด" | mkN "พันธุ์" | mkN "น้ํากาม" | mkN "ลูกหลาน" | mkN "เมล็ดพืช" | mkN "น้ําอสุจิ" | mkN "น้ําเชื้อ" | mkN "ต้นกําเนิด" | mkN "นักกีฬาเด่น" | mkN "เมล็ดพันธุ์" | mkN "ไข่ของสัตว์บางชนิด" ; -- src=panlex
lin cease_V2 = mkV2 "จบ" ; ---- | mkV "ยุติ" | mkV "หยุด" | mkV "อวสาน" | mkV "สิ้นสุด" | mkV "จบ" | mkV "ยุติ" | mkV "หยุด" | mkV "เลิก" | mkV "สิ้นสุด" ; -- src=panlex
lin cease_V = mkV "จบ" | mkV "ยุติ" | mkV "หยุด" | mkV "อวสาน" | mkV "สิ้นสุด" | mkV "จบ" | mkV "ยุติ" | mkV "หยุด" | mkV "เลิก" | mkV "สิ้นสุด" ; -- src=panlex
lin open_Adv = variants{} ; -- 
lin journal_N = mkN "วารสาร" | mkN "ไดอะรี่" | mkN "สมุดขายเชื่อ" | mkN "บันทึกประจำวัน" | mkN "วารสาร" | mkN "ไดอารี" | mkN "นิตยสาร" | mkN "บันทึกประจําวัน" | mkN "หนังสือพิมพ์ประจําวัน" ; -- src=panlex
lin shopping_N = mkN "การจับจ่าย" | mkN "การช็อปปิ้ง" | mkN "ของที่ซื้อจากห้าง" | mkN "สรรพสินค้าในร้าน" | mkN "ของทั้งหมดที่ซื้อ" | mkN "การเดินดูและซื้อของตามร้าน" ; -- src=panlex
lin equivalent_N = mkN "คนที่เท่าเทียมกัน" ; -- src=panlex
lin palace_N = mkN "ปราสาท" | mkN "คฤหาสน์" | mkN "วัง" | mkN "ปราสาท" | mkN "ราชวัง" | mkN "ตําหนัก" | mkN "พระราชวัง" ; -- src=panlex
lin exceed_V2 = variants{} ; -- 
lin isolated_A = mkA "โดดเดี่ยว" ; -- src=panlex
lin poetry_N = mkN "บทกวี" | mkN "บทกลอน" | mkN "กวีนิพนธ์" | mkN "กาพย์กลอน" | mkN "บทร้อยกรอง" | mkN "บทกวี" | mkN "กวีนิพนธ์" | mkN "การประพันธ์บทกวี" | mkN "ลักษณะของกวีนิพนธ์" ; -- src=panlex
lin perceive_VS = variants{} ; -- 
lin perceive_V2V = variants{} ; -- 
lin perceive_V2 = variants{} ; -- 
lin lack_V2 = mkV2 "ขาด" ; ---- | mkV "ขาด" | mkV "ไร้" | mkV "ไม่มี" | mkV "ต้องการ" | mkV "ปราศจาก" | mkV "มีไม่พอ" ; -- src=panlex
lin lack_V = mkV "ขาด" | mkV "ขาด" | mkV "ไร้" | mkV "ไม่มี" | mkV "ต้องการ" | mkV "ปราศจาก" | mkV "มีไม่พอ" ; -- src=panlex
lin strengthen_V2 = variants{} ; -- 
lin snap_V2 = mkV2 "ฉก" ; ---- | mkV "ฉีก" | mkV "แตก" | mkV "ตะคอก" | mkV "ขาดผึง" | mkV "จับภาพ" | mkV "ระเบิด" | mkV "สติแตก" | mkV "เกี่ยว" | mkV "ดีดนิ้ว" | mkV "ถ่ายภาพ" | mkV "ถ่ายรูป" | mkV "บันทึกภาพ" | mkV "ทำเสียงแหลม" | mkV "หมดความอดทน" | mkV "พูดอย่างโกรธเคือง" | mkV "เกิดเสียงดังแหลม" | mkV "แตกและมีเสียงดังแหลม" | mkV "ทําให้แตกและเกิดเสียงดังแหลม" ; -- src=panlex
lin snap_V = mkV "ฉก" | mkV "ฉีก" | mkV "แตก" | mkV "ตะคอก" | mkV "ขาดผึง" | mkV "จับภาพ" | mkV "ระเบิด" | mkV "สติแตก" | mkV "เกี่ยว" | mkV "ดีดนิ้ว" | mkV "ถ่ายภาพ" | mkV "ถ่ายรูป" | mkV "บันทึกภาพ" | mkV "ทำเสียงแหลม" | mkV "หมดความอดทน" | mkV "พูดอย่างโกรธเคือง" | mkV "เกิดเสียงดังแหลม" | mkV "แตกและมีเสียงดังแหลม" | mkV "ทําให้แตกและเกิดเสียงดังแหลม" ; -- src=panlex
lin readily_Adv = variants{} ; -- 
lin spite_N = mkN "การมุ่งร้าย" | mkN "ความประสงค์ร้าย" | mkN "เจตนาร้าย" | mkN "ประสงค์ร้าย" | mkN "ความมุ่งร้าย" | mkN "ความโกรธเคือง" ; -- src=panlex
lin conviction_N = mkN "การพิพากษา" | mkN "ความเชื่อมั่น" | mkN "การพิพากษาลงโทษ" | mkN "การลงโทษ" | mkN "ความมั่นใจ" | mkN "ความเชื่อมั่น" | mkN "ความเชื่อมั่นใจ" | mkN "การตัดสินว่ากระทําผิด" | mkN "ความเชื่ออย่างแรงกล้า" | mkN "การพิสูจน์ว่ากระทําผิด" | mkN "ภาวะที่ถูกตัดสินว่ากระทําผิด" ; -- src=panlex
lin corridor_N = mkN "ทางเดิน" | mkN "เฉลียง" | mkN "ระเบียง" | mkN "เขตฉนวน" | mkN "เส้นทางการบิน" | mkN "ทางเดินยาวในตึก" ; -- src=panlex
lin behind_Adv = mkAdv "ช้า" | mkAdv "ก้น" | mkAdv "หลัง" | mkAdv "ข้างหลัง" | mkAdv "ชําระเงิน" | mkAdv "ล้าหลังกว่า" | mkAdv "ที่เหลืออยู่" | mkAdv "ที่ค้างชําระเงิน" | mkAdv "เหตุการณ์ที่ผ่านมาแล้ว" ; -- src=panlex
lin ward_N = mkN "ผู้ที่อยู่ในความคุ้มครอง" | mkN "ขจัด" | mkN "ขับออก" | mkN "ตึกคนไข้" | mkN "เขตต่างๆ ในเรือนจํา" | mkN "ห้องคนไข้" | mkN "ห้องเรือนจํา" | mkN "แผนกในโรงพยาบาล" | mkN "ความเป็นผู้ปกครอง" | mkN "ท่าทางการเคลื่อนไหวในการป้องกัน เช่น ในการฟันดาบ" | mkN "บริเวณที่เปิดโล่งภายในคอกปศุสัตว์" | mkN "ผู้ที่อยู่ในความปกครองหรือความพิทักษ์" | mkN "แผนกในโรงพยาบาลที่มีคนไข้ประเภทเดียวกัน" | mkN "เด็กหรือผู้เยาว์ที่อยู่ในความคุ้มครองของศาล หรือผู้ปกครอง" ; -- src=panlex
lin profile_N = mkN "โปรไฟล์" | mkN "ประวัติย่อ" | mkN "บรร-ยายประวัติบุคคลโดยย่อ" | mkN "ภาพเงา" | mkN "โครงร่าง" | mkN "รูปภายนอก" | mkN "วาดภาพเงา" | mkN "รูปด้านข้าง" | mkN "รูปโครงร่าง" | mkN "วาดโครงร่าง" | mkN "ข้อมูลโดยรวม" | mkN "ประวัติโดยย่อ" | mkN "รูปหน้าเสี้ยว" | mkN "รูปเส้นรอบนอก" | mkN "รูปหน้าด้านข้าง" | mkN "การวินิจฉัยขบวนการ" ; -- src=panlex
lin fat_A = mkA "อ้วน" | mkA "ที่มีไขมัน" | mkA "ซึ่งอุดมสมบูรณ์" | mkA "โต" | mkA "หนา" | mkA "ท้วม" | mkA "อ้วน" | mkA "ใหญ่" | mkA "กว้าง" | mkA "เป็นไข" | mkA "ร่ํารวย" | mkA "จ้ําม่ํา" | mkA "มั่งคั่ง" | mkA "อุดมสมบูรณ์" ; -- src=panlex
lin comfort_N = mkN "ความสบาย" | mkN "การปลอบใจ" | mkN "ความสะดวกสบาย" | mkN "การเปิดทางสะดวก" | mkN "ความรู้สึกสบายๆ" | mkN "ความสบาย" | mkN "คําปลอบใจ" | mkN "ความสบายใจ" | mkN "สิ่งปลอบใจ" | mkN "ความสบายกาย" | mkN "ความสุขสบาย" | mkN "ความอบอุ่นใจ" | mkN "ความรู้สึกสบาย" | mkN "เครื่องบรรเทาทุกข์" | mkN "คนหรือสิ่งอํานวยความสะดวก" ; -- src=panlex
lin bathroom_N = mkN "สุขา" | mkN "ส้วม" | mkN "ห้องน้ำ" | mkN "ห้องสรง" | mkN "ห้องสุขา" | mkN "ห้องส้วม" | mkN "ห้องอาบน้ำ" | mkN "ห้องพระบังคน" | mkN "ห้องน้ํา" | mkN "ห้องอาบน้ํา" ; -- src=panlex
lin shell_N = mkN "กรอบ" | mkN "ปลอก" | mkN "แผ่น" | mkN "กระดอง" | mkN "กระสุน" | mkN "เปลือก" | mkN "เปลือกหอย" | mkN "เปลือกไข่" | mkN "ฝัก" | mkN "หอย" | mkN "คราบ" | mkN "ปลอก" | mkN "กระดอง" | mkN "เปลือก" | mkN "ใส่ปลอก" | mkN "โกร่งดาบ" | mkN "ปอกเปลือก" | mkN "เปลือกหอย" | mkN "โฉมภายนอก" | mkN "ปลอกกระสุน" | mkN "รองในโลงศพ" | mkN "ลูกปืนใหญ่" | mkN "โลงศพภายใน" | mkN "ชั้นหินผ้าบาง" | mkN "ตัวเรือด้านนอก" | mkN "ลูกปืนล่าสัตว์" | mkN "แก้วเบียร์ขนาดเล็ก" | mkN "สิ่งที่เหมือนเปลือก" | mkN "โครงสร้างอาคารหรือสิ่งก่อสร้าง" | mkN "เรือแข่งแคบซึ่งนั่งได้เพียง 1-2 คน" ; -- src=panlex
lin reward_N = mkN "รางวัล" | mkN "ประโยชน์" | mkN "สินน้ำใจ" | mkN "เงินรางวัล" | mkN "การเสริมแรง" | mkN "การให้รางวัล" | mkN "ชดเชย" | mkN "ทดแทน" | mkN "ตอบแทน" | mkN "รางวัล" | mkN "สิ่งตอบแทน" | mkN "เงินรางวัล" ; -- src=panlex
lin deliberately_Adv = variants{} ; -- 
lin automatically_Adv = mkAdv "ด้วยกลไก" | mkAdv "โดยอัตโนมัติ" | mkAdv "โดยอัตโนมัติ" ; -- src=panlex
lin vegetable_N = mkN "ผัก" | mkN "พืชผัก" | mkN "ผัก" | mkN "พืช" | mkN "พืชผัก" | mkN "เกี่ยวกับพืช" | mkN "บุคคลที่น่าเบื่อหน่าย" ; -- src=panlex
lin imagination_N = mkN "จินตนาการ" | mkN "มโนภาพ" | mkN "จินตนาการ" | mkN "เจ้าความคิด" | mkN "การนึกเอาเอง" | mkN "การวาดภาพในใจ" ; -- src=panlex
lin junior_A = mkA "เยาว์วัย" | mkA "รอง" | mkA "กว่า" | mkA "ใหม่" | mkA "อ่อนอาวุโส" | mkA "อ่อนวัยกว่า" | mkA "อายุน้อยกว่า" | mkA "ที่อายุน้อยกว่า" | mkA "ที่อายุอ่อนกว่า" | mkA "ที่เป็นรุ่นน้อง" | mkA "มีคุณวุฒิด้อยกว่า" | mkA "อยู่ชั้นเรียนต่ํากว่า" | mkA "ขนาดเสื้อเอวสั้นของผู้หญิง" | mkA "ผู้มาใหม่นักศึกษาปีที่ 2" ; -- src=panlex
lin unemployed_A = mkA "ว่าง" | mkA "ตกงาน" | mkA "ว่างงาน" | mkA "เตะฝุ่น" | mkA "วิจัยฝุ่น" | mkA "ตกงาน" | mkA "ซึ่งว่างงาน" | mkA "ไม่มีงานทํา" | mkA "ซึ่งไม่ทํางาน" | mkA "ซึ่งไม่ได้นํามาใช้งาน" | mkA "ซึ่งไม่ได้ใช้ให้เกิดประโยชน์" ; -- src=panlex
lin mystery_N = mkN "ปริศนา" | mkN "สิ่งลึกลับ" | mkN "เรื่องลึกลับ" | mkN "นวนิยายลึกลับ" | mkN "สิ่งที่เป็นปริศนา" | mkN "ปริศนา" | mkN "ความลับ" | mkN "เงื่อนงํา" | mkN "ความลึกลับ" | mkN "สิ่งลี้ลับ" | mkN "ความซับซ้อน" | mkN "ความแปลกประหลาด" | mkN "สิ่งแปลกประหลาด" | mkN "ศิลปะของการค้าขาย" | mkN "สิ่งที่ไม่สามารถอธิบายได้" ; -- src=panlex
lin pose_V2 = mkV2 "วาง" ; ---- | mkV "ตั้ง" | mkV "วางท่า" | mkV "โพสท่า" | mkV "ปลอมตัว" | mkV "เป็นแบบ" | mkV "ทำให้สับสน" | mkV "ถาม" | mkV "วางท่า" | mkV "ทําท่าทาง" | mkV "เลียนแบบผู้อื่น" ; -- src=panlex
lin pose_V = mkV "วาง" | mkV "ตั้ง" | mkV "วางท่า" | mkV "โพสท่า" | mkV "ปลอมตัว" | mkV "เป็นแบบ" | mkV "ทำให้สับสน" | mkV "ถาม" | mkV "วางท่า" | mkV "ทําท่าทาง" | mkV "เลียนแบบผู้อื่น" ; -- src=panlex
lin violent_A = mkA "ซึ่งใช้ความรุนแรง" | mkA "ที่เกิดจากความรุนแรง" | mkA "พลการ" | mkA "สาหัส" | mkA "ทําลาย" | mkA "รุนแรง" | mkA "ดุเดือด" | mkA "สบประมาท" | mkA "ี่ร้ายแรง" | mkA "ใช้กําลัง" | mkA "ล่วงละเมิด" | mkA "ซึ่งทําให้บาดเจ็บ" | mkA "ที่มีอารมณ์ดุเดือด" | mkA "ที่มีสาเหตุจากความรุนแรง" ; -- src=panlex
lin march_N = variants{} ; -- 
lin found_V2 = variants{} ; -- 
lin dig_V2 = mkV2 (thword "ขุด") ; ---- | {-pan-} mkV "ขุด" | mkV "รู้" | mkV "ทิ่ม" | mkV "ขุดค้น" | mkV "เข้าใจ" | mkV "กระทุ้ง" | mkV "ขุดเจาะ" | mkV "ตรากตรำ" | mkV "ทำงานหนัก" | mkV "ตรากตรำทำงาน" | mkV "เข้าใจความหมาย" | mkV "ดู" | mkV "ขุด" | mkV "แทง" | mkV "แยง" | mkV "คุ้ย" | mkV "จ้อง" | mkV "ทิ่ม" | mkV "เจาะ" | mkV "ขุดหา" | mkV "มองดู" | mkV "ขุดค้น" | mkV "เข้าใจ" | mkV "กระทุ้ง" | mkV "รับทราบ" | mkV "ทําเป็นโพรง" ; -- src=panlex
lin dig_V = mkV (thword "ขุด") | {-pan-} mkV "ขุด" | mkV "รู้" | mkV "ทิ่ม" | mkV "ขุดค้น" | mkV "เข้าใจ" | mkV "กระทุ้ง" | mkV "ขุดเจาะ" | mkV "ตรากตรำ" | mkV "ทำงานหนัก" | mkV "ตรากตรำทำงาน" | mkV "เข้าใจความหมาย" | mkV "ดู" | mkV "ขุด" | mkV "แทง" | mkV "แยง" | mkV "คุ้ย" | mkV "จ้อง" | mkV "ทิ่ม" | mkV "เจาะ" | mkV "ขุดหา" | mkV "มองดู" | mkV "ขุดค้น" | mkV "เข้าใจ" | mkV "กระทุ้ง" | mkV "รับทราบ" | mkV "ทําเป็นโพรง" ; -- src=panlex
lin dirty_A = mkA (thword "สก" "ปรก") | {-pan-} mkA "ลามก" | mkA "สกปรก" | mkA "เปื้อน" | mkA "ลามกจกเปรต" | mkA "ซึ่งเล่นโกง" | mkA "ซึ่งผิดกติกา" | mkA "ซึ่งมีรอยแก้" | mkA "ซึ่งเล่นสกปรก" | mkA "ซึ่งเล่นขี้โกง" | mkA "ลาม" | mkA "ลามก" | mkA "สลัว" | mkA "เลอะ" | mkA "สกปรก" | mkA "แพศยา" | mkA "ทึมทึบ" | mkA "ชั่วช้า" | mkA "เลวทราม" | mkA "โชคร้าย" | mkA "ไม่พอใจ" | mkA "เป็นหนอง" | mkA "ไม่สะอาด" | mkA "ขุ่นเคือง" | mkA "น่าเกลียด" | mkA "น่าเสียใจ" | mkA "ไม่จริงใจ" | mkA "ไม่ชัดเจน" | mkA "เปรอะเปื้อน" | mkA "ไม่ซื่อสัตย์" | mkA "ไม่บริสุทธิ์" | mkA "น่าเบื่อหน่าย" ; -- src=panlex
lin straight_A = mkA (thword "ตรง") | {-pan-} mkA "ตรง" | mkA "ยืด" | mkA "เพียวๆ" | mkA "ซื่อตรง" | mkA "ซื่อสัตย์" | mkA "เรียบร้อย" | mkA "อย่างซื่อตรง" | mkA "ตามความเป็นจริง" | mkA "ซึ่งไม่ใช่รักร่วมเพศ" | mkA "ตรง" | mkA "ดิ่ง" | mkA "ปกติ" | mkA "ทันที" | mkA "โดยตรง" | mkA "ไม่ผสม" | mkA "ฉับพลัน" | mkA "ซื่อตรง" | mkA "ดื่มดวด" | mkA "ตรงแน่ว" | mkA "ถูกต้อง" | mkA "เปิดเผย" | mkA "แม่นยํา" | mkA "ไม่โค้ง" | mkA "ต่อเนื่อง" | mkA "มีระเบียบ" | mkA "สม่ําเสมอ" | mkA "เรียงแต้ม" | mkA "เรียบร้อย" | mkA "ไม่ขาดตอน" | mkA "ไม่เจือปน" | mkA "ไม่เบี้ยว" | mkA "คงเส้นคงวา" | mkA "ตรงไปตรงมา" | mkA "ต่อเนื่องกัน" | mkA "ชอบด้วยกฎหมาย" | mkA "ไม่เปลี่ยนแปลง" ; -- src=panlex
lin psychological_A = mkA "ทางจิตใจ" | mkA "ทางจิตวิทยา" | mkA "ทางจิตวิทยา" | mkA "ทางด้านจิตใจ" | mkA "เกี่ยวกับจิต" | mkA "ในทางจิตศาสตร์" | mkA "เกี่ยวกับจิตวิทยา" | mkA "ทางด้านจิตวิเคราะห์" ; -- src=panlex
lin grab_V2 = mkV2 "จับ" ; ---- | mkV "ฉวย" | mkV "คว้า" | mkV "ตรึง" | mkV "หยิบฉวย" | mkV "คว้า" | mkV "ฉกฉวย" | mkV "ไขว่คว้า" ; -- src=panlex
lin grab_V = mkV "จับ" | mkV "ฉวย" | mkV "คว้า" | mkV "ตรึง" | mkV "หยิบฉวย" | mkV "คว้า" | mkV "ฉกฉวย" | mkV "ไขว่คว้า" ; -- src=panlex
lin pleasant_A = mkA "ตลก" | mkA "พอใจ" | mkA "ถูกใจ" | mkA "น่าคบ" | mkA "สุภาพ" | mkA "สบายใจ" | mkA "น่าคบหา" | mkA "น่าพอใจ" | mkA "น่าสบาย" | mkA "น่าอยู่" | mkA "ร่าเริง" | mkA "น่ายินดี" | mkA "สนุกสนาน" | mkA "เป็นมิตร" | mkA "เรียบร้อย" | mkA "เพลิดเพลิน" | mkA "ให้ความพอใจ" | mkA "มีมิตรไมตรีจิต" | mkA "สุภาพเรียบร้อย" | mkA "ซึ่งให้ความพอใจ" | mkA "ซึ่งให้ความเพลิดเพลิน" ; -- src=panlex
lin surgery_N = mkN "การผ่าตัด" | mkN "ห้องแพทย์" | mkN "ศัลยศาสตร์" | mkN "ห้องผ่าตัด" | mkN "กระบวนการผ่าตัด" | mkN "ศัลยกรรม" | mkN "การผ่าตัด" | mkN "ห้องแพทย์" | mkN "ศัลยศาสตร์" | mkN "ห้องผ่าตัด" | mkN "ห้องศัลยกรรม" | mkN "วิชาการผ่าตัด" | mkN "วิชาศัลยศาสตร์" | mkN "ห้องทําศัลยกรรม" ; -- src=panlex
lin inevitable_A = mkA "แน่นอน" | mkA "ซึ่งหลีกเลี่ยงไม่ได้" | mkA "สิ่งที่ไม่สามารถหลีกเลี่ยงได้" ; -- src=panlex
lin transform_V2 = variants{} ; -- 
lin bell_N = mkN "ฆ้อง" | mkN "กริ่ง" | mkN "ระฆัง" | mkN "รูปกรวย" | mkN "รูประฆัง" | mkN "ระฆังเรือ" | mkN "รูปกระดิ่ง" | mkN "เสียงระฆัง" | mkN "ระฆัง" | mkN "กระดิ่ง" | mkN "ทรงระฆัง" | mkN "กริ่งประตู" | mkN "ทรงกระดิ่ง" | mkN "กริ่งสัญญาณ" | mkN "ของที่มีลักษณะคล้ายระฆัง" | mkN "เสียงร้องหรือเสียงหอนของสุนัขล่าเนื้อ" ; -- src=panlex
lin announcement_N = mkN "ประกาศ" | mkN "แถลงการณ์" | mkN "การแถลง" | mkN "การโฆษณา" | mkN "การประกาศ" | mkN "คําประกาศ" | mkN "เสียงประกาศ" | mkN "การทําให้รู้" | mkN "การป่าวประกาศ" ; -- src=panlex
lin draft_N = mkN "การซด" | mkN "เหล้า" | mkN "การดึง" | mkN "การลาก" | mkN "ดราฟท์" | mkN "กระแสลม" | mkN "ภาพร่าง" | mkN "ฉบับร่าง" | mkN "เบียร์สด" | mkN "การร่างภาพ" | mkN "ตั๋วแลกเงิน" | mkN "การเกณฑ์ทหาร" | mkN "ขนาดระวางเรือ" | mkN "เช็ค" | mkN "ดราฟท์" | mkN "กระแสลม" | mkN "ภาพร่าง" | mkN "แผนร่าง" | mkN "ฉบับร่าง" | mkN "ร่างจดหมาย" | mkN "ตั๋วแลกเงิน" | mkN "เอกสารฉบับร่าง" | mkN "เครื่องถ่ายเทอากาศ" | mkN "อุปกรณ์ควบคุมการไหลของอากาศ" ; -- src=panlex
lin unity_N = mkN "๑" | mkN "หนึ่ง" | mkN "ความสมบูรณ์" | mkN "1" | mkN "หนึ่ง" | mkN "การรวมกัน" | mkN "ความสามัคคี" | mkN "ความเป็นเอกภาพ" | mkN "สิ่งที่ร่วมกัน" | mkN "จํานวนหนึ่งหน่วย" | mkN "ความพร้อมเพรียงกัน" | mkN "ความเป็นอันหนึ่งอันเดียวกัน" ; -- src=panlex
lin airport_N = mkN "สนามบิน" | mkN "ท่าอากาศยาน" | mkN "สนามบิน" | mkN "ท่าอากาศยาน" ; -- src=panlex
lin upset_V2 = mkV2 "ตอก" ; ---- | mkV "คว่ำ" | mkV "ตอกโลหะ" | mkV "ทำให้ล้ม" | mkV "ทำให้ดำดิ่ง" | mkV "ทำให้กระวนกระวาย" | mkV "คว่ํา" | mkV "พลิกคว่ํา" | mkV "ทําให้กลัดกลุ้ม" | mkV "ทําให้พลิกคว่ํา" | mkV "ทําให้อารมณ์เสีย" | mkV "ทําให้สะอิดสะเอียน" | mkV "ทําให้คลื่นไส้อาเจียน" | mkV "ทําให้พ่ายแพ้อย่างคาดไม่ถึง" ; -- src=panlex
lin upset_V = mkV "ตอก" | mkV "คว่ำ" | mkV "ตอกโลหะ" | mkV "ทำให้ล้ม" | mkV "ทำให้ดำดิ่ง" | mkV "ทำให้กระวนกระวาย" | mkV "คว่ํา" | mkV "พลิกคว่ํา" | mkV "ทําให้กลัดกลุ้ม" | mkV "ทําให้พลิกคว่ํา" | mkV "ทําให้อารมณ์เสีย" | mkV "ทําให้สะอิดสะเอียน" | mkV "ทําให้คลื่นไส้อาเจียน" | mkV "ทําให้พ่ายแพ้อย่างคาดไม่ถึง" ; -- src=panlex
lin pretend_VS = mmkVS "คาด" ; ---- | mkV "เดา" | mkV "แกล้ง" | mkV "แสร้ง" | mkV "คาดเดา" | mkV "แกล้งทำ" | mkV "ทำเหมือน" | mkV "แกล้งทําว่าเป็นจริง" ; -- src=panlex
lin pretend_V2 = mkV2 "คาด" ; ---- | mkV "เดา" | mkV "แกล้ง" | mkV "แสร้ง" | mkV "คาดเดา" | mkV "แกล้งทำ" | mkV "ทำเหมือน" | mkV "แกล้งทําว่าเป็นจริง" ; -- src=panlex
lin pretend_V = mkV "คาด" | mkV "เดา" | mkV "แกล้ง" | mkV "แสร้ง" | mkV "คาดเดา" | mkV "แกล้งทำ" | mkV "ทำเหมือน" | mkV "แกล้งทําว่าเป็นจริง" ; -- src=panlex
lin plant_V2 = variants{} ; -- 
lin till_Prep = variants{} ; -- 
lin known_A = mkA "ซึ่งเป็นที่รู้จัก" | mkA "ซึ่งเป็นที่รู้จักโดยทั่วไป" ; -- src=panlex
lin admission_N = mkN "สิทธิ์" | mkN "คำยอมรับ" | mkN "การยอมรับ" | mkN "การเปิดรับ" | mkN "ค่าผ่านประตู" | mkN "สิทธิในการเข้าถึง" | mkN "ค่าธรรมเนียมในการเข้า" | mkN "การยอมรับ" | mkN "คํายอมรับ" | mkN "คําสารภาพ" | mkN "การรับเข้า" | mkN "การยอมรับรอง" | mkN "การรับสารภาพ" | mkN "การประกาศยอมรับ" | mkN "ราคาสําหรับเข้าไป" | mkN "สิทธิ์ในการเข้าไป" | mkN "ค่าธรรมเนียมในการเข้า" | mkN "สิทธหรือวิธีการเข้าไป" | mkN "การยอมรับข้อกล่าวหาหรือความจริง" ; -- src=panlex
lin tissue_N = mkN "เนื้อเยื่อ" | mkN "เยื่อกระดาษ" | mkN "ร่างแห" | mkN "เนื้อผ้า" | mkN "กระดาษบาง" | mkN "เนื้อเยื่อ" | mkN "กระดาษบางๆ สําหรับเช็ดหน้าหรือเช็ดมือ" | mkN "เยื่อกระดาษ" | mkN "เนื้อเยื่อของคน สัตว์หรือพืช" | mkN "เนื้อเยื่อกระดาษ" | mkN "กระดาษบางที่ใช้ห่อหุ้ม" | mkN "สิ่งที่เป็นชุดต่อเนื่องและมีความซับซ้อน" ; -- src=panlex
lin magistrate_N = mkN "ผู้พิพากษา" | mkN "พนักงานปกครอง" | mkN "พนักงานผู้ปกครอง" | mkN "เจ้าหน้าที่ฝ่ายปกครอง" ; -- src=panlex
lin joy_N = mkN "ความปีติ" | mkN "สิ่งที่ทำให้พอใจ" | mkN "ความผาสุก" | mkN "ความสุขใจ" | mkN "ความเบิกบาน" | mkN "ความสุขสันต์" | mkN "ความสุขสําราญ" | mkN "สิ่งที่ทําให้รู้สึกเป็นสุข" ; -- src=panlex
lin free_V2V = variants{} ; -- 
lin free_V2 = variants{} ; -- 
lin pretty_A = mkA "มาก" | mkA "สวย" | mkA "งดงาม" | mkA "ชวนตา" | mkA "ชวนใจ" | mkA "สะสวย" | mkA "น่ามอง" | mkA "น่ารัก" | mkA "มากมาย" | mkA "สวยงาม" | mkA "ไพเราะ" | mkA "กล้าหาญ" | mkA "สละสลวย" | mkA "น่าเอ็นดู" | mkA "" ; -- src=panlex
lin operating_N = variants{} ; -- 
lin headquarters_N = mkN "กองบัญชาการ" | mkN "สำนักงานใหญ่" | mkN "ศูนย์บัญชาการ" | mkN "หน่วยบัญชาการ" | mkN "กองบัญชาการ" | mkN "กองบังคับการ" | mkN "สํานักงานใหญ่" ; -- src=panlex
lin grateful_A = mkA "ซึ่งสำนึกในบุญคุณ" | mkA "ขอบคุณ" | mkA "น่าสบาย" | mkA "ปลื้มปีติ" | mkA "อย่างสุขสบาย" | mkA "ซึ่งกตัญญูรู้คุณ" | mkA "ซึ่งสํานึกในบุญคุณ" | mkA "เป็นที่ชื่นชมยินดี" ; -- src=panlex
lin classroom_N = mkN "คลาสรูม" | mkN "ชั้นเรียน" | mkN "ห้องเรียน" | mkN "ห้องเรียน" ; -- src=panlex
lin turnover_N = mkN "การพลิกคว่ำ" | mkN "พับได้" | mkN "ขนมม้วน" | mkN "การคว่ํา" | mkN "คว่ําได้" | mkN "จํานวนขาย" | mkN "การหมุนตัว" | mkN "การพลิกกลับ" | mkN "อัตราการขาย" | mkN "การหมุนเวียน" | mkN "การเดินสะพัด" | mkN "จํานวนซื้อขาย" | mkN "อัตราการลาออก" | mkN "การเปลี่ยนแปลง" | mkN "เงินที่เก็บได้ทั้งหมด" ; -- src=panlex
lin project_VS = mmkVS "ฉาย" ; ---- | mkV "ยื่น" | mkV "ยื่่น" | mkV "นึกภาพ" | mkV "เห็นภาพ" | mkV "ทำให้ได้ยิน" | mkV "ส่งไปข้างหน้า" | mkV "ถือเป็นภาวะวิสัย" | mkV "เสนอ" | mkV "นูนออก" | mkV "โผล่ออก" | mkV "ยื่นออกมา" | mkV "เสนอแผนงาน" | mkV "ทําให้เห็นหรือได้ยินชัดเจน" ; -- src=panlex
lin project_V2V = mmkV2V "ฉาย" ; ---- | mkV "ยื่น" | mkV "ยื่่น" | mkV "นึกภาพ" | mkV "เห็นภาพ" | mkV "ทำให้ได้ยิน" | mkV "ส่งไปข้างหน้า" | mkV "ถือเป็นภาวะวิสัย" | mkV "เสนอ" | mkV "นูนออก" | mkV "โผล่ออก" | mkV "ยื่นออกมา" | mkV "เสนอแผนงาน" | mkV "ทําให้เห็นหรือได้ยินชัดเจน" ; -- src=panlex
lin project_V2 = mkV2 "ฉาย" ; ---- | mkV "ยื่น" | mkV "ยื่่น" | mkV "นึกภาพ" | mkV "เห็นภาพ" | mkV "ทำให้ได้ยิน" | mkV "ส่งไปข้างหน้า" | mkV "ถือเป็นภาวะวิสัย" | mkV "เสนอ" | mkV "นูนออก" | mkV "โผล่ออก" | mkV "ยื่นออกมา" | mkV "เสนอแผนงาน" | mkV "ทําให้เห็นหรือได้ยินชัดเจน" ; -- src=panlex
lin project_V = mkV "ฉาย" | mkV "ยื่น" | mkV "ยื่่น" | mkV "นึกภาพ" | mkV "เห็นภาพ" | mkV "ทำให้ได้ยิน" | mkV "ส่งไปข้างหน้า" | mkV "ถือเป็นภาวะวิสัย" | mkV "เสนอ" | mkV "นูนออก" | mkV "โผล่ออก" | mkV "ยื่นออกมา" | mkV "เสนอแผนงาน" | mkV "ทําให้เห็นหรือได้ยินชัดเจน" ; -- src=panlex
lin shrug_V2 = variants{} ; -- 
lin sensible_A = mkA "ฉลาด" | mkA "มากมาย" | mkA "มีเหตุผล" | mkA "มีไหวพริบ" | mkA "เฉลียวฉลาด" | mkA "มีสติสัมปชัญญะ" | mkA "ซึ่งมีวิจารณญาณ" | mkA "ซึ่งไวต่อสิ่งกระตุ้น" | mkA "สามารถรู้สึกได้ไวต่อสิ่งกระตุ้น" ; -- src=panlex
lin limitation_N = mkN "อายุความ" | mkN "กฎเกณฑ์" | mkN "ข้อด้อย" | mkN "จุดอ่อน" | mkN "วงจํากัด" | mkN "ขีดจํากัด" | mkN "ข้อกําหนด" | mkN "ข้อจํากัด" | mkN "ข้อบกพร่อง" | mkN "ความจํากัด" ; -- src=panlex
lin specialist_N = mkN "ผู้เชี่ยวชาญ" | mkN "ผู้ชำนาญการพิเศษ" | mkN "แพทย์ผู้เชี่ยวชาญ" | mkN "ผู้ชํานาญการ" | mkN "ผู้เชี่ยวชาญ" | mkN "ผู้ชํานาญพิเศษ" | mkN "ผู้ชํานาญเฉพาะทาง" | mkN "ผู้เชี่ยวชาญพิเศษ" ; -- src=panlex
lin newly_Adv = variants{} ; -- 
lin tongue_N = mkN (thword "ลิ้น") | {-pan-} mkN "ภาษา" | mkN "ลิ้น" | mkN "ชิวหา" | mkN "พระชิวหา" | mkN "ลิ้นกระดิ่ง" | mkN "ลิ้นรองเท้า" | mkN "สันดอนจะงอย" | mkN "ภาษาธรรมชาติ" | mkN "คารม" | mkN "ภาษา" | mkN "ลิ้น" | mkN "ชิวหา" | mkN "ชนชาติ" | mkN "สํานวนภาษา" | mkN "เข็มตาชั่ง" | mkN "ลูกตุ้มระฆัง" | mkN "สิ่งที่เหมือนลิ้น" | mkN "ความสามารถในการพูด" | mkN "แผ่นลิ้นของเครื่องดนตรี" | mkN "แผ่นดินที่ยื่นไปในแหล่งน้ํา" | mkN "สิ่งที่มีรูปร่างลักษณะคล้ายลิ้น" ; -- src=panlex ----?
lin refugee_N = mkN "ผู้ลี้ภัย" | mkN "ผู้ลี้ภัย" | mkN "ผู้หนีภัย" | mkN "ผู้หลบภัย" ; -- src=panlex
lin delay_V2 = mkV2 "ยุติ" ; ---- | mkV "เลื่อน" | mkV "ทำให้เลื่อนออกไป" | mkV "ล่าช้า" | mkV "เลื่อน" | mkV "ยืดเวลา" | mkV "ถ่วงเวลา" | mkV "หยุดยั้ง" | mkV "ทําให้ช้า" | mkV "เลื่อนเวลา" | mkV "ทําให้ล่าช้า" | mkV "ทําให้หยุดยั้ง" | mkV "ทําให้เสียเวลา" ; -- src=panlex
lin delay_V = mkV "ยุติ" | mkV "เลื่อน" | mkV "ทำให้เลื่อนออกไป" | mkV "ล่าช้า" | mkV "เลื่อน" | mkV "ยืดเวลา" | mkV "ถ่วงเวลา" | mkV "หยุดยั้ง" | mkV "ทําให้ช้า" | mkV "เลื่อนเวลา" | mkV "ทําให้ล่าช้า" | mkV "ทําให้หยุดยั้ง" | mkV "ทําให้เสียเวลา" ; -- src=panlex
lin dream_V2 = mkV2 "ฝัน" ; ---- | mkV "คิดฝัน" | mkV "วาดฝัน" | mkV "ทรงสุบิน" | mkV "ฝันกลางวัน" | mkV "ทรงพระสุบิน" | mkV "วาดวิมานในอากาศ" | mkV "ฝัน" | mkV "สุบิน" | mkV "เพ้อฝัน" ; -- src=panlex
lin dream_V = mkV "ฝัน" | mkV "คิดฝัน" | mkV "วาดฝัน" | mkV "ทรงสุบิน" | mkV "ฝันกลางวัน" | mkV "ทรงพระสุบิน" | mkV "วาดวิมานในอากาศ" | mkV "ฝัน" | mkV "สุบิน" | mkV "เพ้อฝัน" ; -- src=panlex
lin composition_N = mkN "บทความ" | mkN "บทเพลง" | mkN "รายงาน" | mkN "เปเปอร์" | mkN "ไทโปกราฟี" | mkN "ส่วนประกอบ" | mkN "การประพันธ์" | mkN "การแต่งเพลง" | mkN "การประกอบขึ้น" | mkN "การแต่งหนังสือ" | mkN "สิ่งที่ผสมขึ้น" | mkN "การประพันธ์เพลง" | mkN "การเขียนหนังสือ" | mkN "ของผสม" | mkN "ผลิตผล" | mkN "ข้อตกลง" | mkN "อุปนิสัย" | mkN "คุณสมบัติ" | mkN "ภาพประกอบ" | mkN "การตกลงกัน" | mkN "ส่วนประกอบ" | mkN "องค์ประกอบ" | mkN "การประพันธ์" | mkN "การแต่งเพลง" | mkN "การประนีประนอม" | mkN "สิ่งที่ประกอบขึ้น" | mkN "การจัดวางองค์ประกอบ" | mkN "การจัดเรียงตัวพิมพ์" | mkN "การเกิดเป็นสารประกอบ" | mkN "การประกอบเป็นส่วนต่าง ๆ ทั้งหมด" ; -- src=panlex
lin alongside_Prep = mkPrep "ข้างๆ" | mkPrep "เคียง" | mkPrep "อยู่ข้าง" | mkPrep "เทียบท่า" | mkPrep "อยู่ถัดไป" | mkPrep "อยู่ติดกับ" ; -- src=panlex
lin ceiling_N = mkN (thword "เพ" "ดาน") | {-pan-} mkN "เพดาน" | mkN "เพดานบิน" | mkN "เพดานเมฆ" | mkN "ขีดสูงสุด" | mkN "เพดานสูงสุด" | mkN "เพดาน" | mkN "ดาดฟ้า" | mkN "การกรุผนัง" | mkN "การกรุฝาผนัง" | mkN "สิ่งที่ใช้กรุผนัง" ; -- src=panlex ----?
lin highlight_V2 = variants{} ; -- 
lin stick_N = mkN (thword "กิ่ง") | {-pan-} mkN "ไม้" | mkN "ก้าน" | mkN "ไม้ตี" | mkN "เนยแท่ง" | mkN "แท่งไม้" | mkN "มวนกัญชา" | mkN "บุหรี่ยัดไส้กัญชา" | mkN "กิ่ง" | mkN "ไม้เท้า" ; -- src=panlex
lin favourite_A = mkA "ซึ่งเป็นที่ชื่นชอบ" ; -- src=panlex
lin tap_V2 = mkV2 "เคาะ" ; ---- | mkV "ดักฟัง" | mkV "ตบเบาๆ" | mkV "วิงวอน" | mkV "ถอนออกมา" | mkV "เต้นแท็ป" | mkV "เดินลงส้น" | mkV "ใช้ประโยชน์" | mkV "ใช้ให้เกิดประโยชน์" | mkV "เคาะ" | mkV "ตบเบาๆ" | mkV "ตีเบาๆ" | mkV "ไขก๊อก" | mkV "แตะเบาๆ" | mkV "คัดเลือก" | mkV "เต้นแท็พ" | mkV "ติดหัวก๊อก" | mkV "ปล่อยให้ไหลออก" | mkV "ปล่อยของเหลวออกจากก๊อก" | mkV "ใส่แผ่นหนังหรือแผ่นเหล็กที่ส้นรองเท้า" | mkV "เต้นรําโดยใช้รองเท้าเคาะพื้นเป็นจังหวะ" ; -- src=panlex
lin tap_V = mkV "เคาะ" | mkV "ดักฟัง" | mkV "ตบเบาๆ" | mkV "วิงวอน" | mkV "ถอนออกมา" | mkV "เต้นแท็ป" | mkV "เดินลงส้น" | mkV "ใช้ประโยชน์" | mkV "ใช้ให้เกิดประโยชน์" | mkV "เคาะ" | mkV "ตบเบาๆ" | mkV "ตีเบาๆ" | mkV "ไขก๊อก" | mkV "แตะเบาๆ" | mkV "คัดเลือก" | mkV "เต้นแท็พ" | mkV "ติดหัวก๊อก" | mkV "ปล่อยให้ไหลออก" | mkV "ปล่อยของเหลวออกจากก๊อก" | mkV "ใส่แผ่นหนังหรือแผ่นเหล็กที่ส้นรองเท้า" | mkV "เต้นรําโดยใช้รองเท้าเคาะพื้นเป็นจังหวะ" ; -- src=panlex
lin universe_N = mkN "เอกภพ" | mkN "จักรวาล" | mkN "สรรพสิ่ง" | mkN "สิ่งมีชีวิต" | mkN "สถิติประชากร" | mkN "เอกภพของสรรพสาระ" | mkN "สากล" | mkN "เอกภาพ" | mkN "จักรวาล" | mkN "โลกทั้งหมด" | mkN "สิ่งทั้งมวล" | mkN "สัตว์ทั้งหลาย" | mkN "โลกและมนุษยชาติ" | mkN "ประสบการณ์ทั้งมวล" | mkN "ปรากฎการณ์ทั้งหลาย" | mkN "มนุษย์ชาติทั้งหลาย" ; -- src=panlex
lin request_VS = variants{} ; -- 
lin request_V2 = variants{} ; -- 
lin label_N = mkN "ฉลาก" | mkN "ชื่อค่ายเพลง" | mkN "ตรา" | mkN "แถบ" | mkN "ฉลาก" | mkN "ชื่อ" | mkN "ป้าย" | mkN "สลาก" | mkN "แผ่น" | mkN "ยี่ห้อ" | mkN "เครื่องหมายการค้า" ; -- src=panlex
lin confine_V2 = variants{} ; -- 
lin scream_VS = mmkVS "ตะโกน" ; ---- | mkV "แหกปาก" | mkV "ร้องลั่น" | mkV "ร้องตะโกน" | mkV "ตะโกน" | mkV "กรีดร้อง" | mkV "แผดเสียง" | mkV "กรีดเสียง" | mkV "ร้องกรี๊ด" | mkV "ตะเบ็งเสียง" ; -- src=panlex
lin scream_V2 = mkV2 "ตะโกน" ; ---- | mkV "แหกปาก" | mkV "ร้องลั่น" | mkV "ร้องตะโกน" | mkV "ตะโกน" | mkV "กรีดร้อง" | mkV "แผดเสียง" | mkV "กรีดเสียง" | mkV "ร้องกรี๊ด" | mkV "ตะเบ็งเสียง" ; -- src=panlex
lin scream_V = mkV "ตะโกน" | mkV "แหกปาก" | mkV "ร้องลั่น" | mkV "ร้องตะโกน" | mkV "ตะโกน" | mkV "กรีดร้อง" | mkV "แผดเสียง" | mkV "กรีดเสียง" | mkV "ร้องกรี๊ด" | mkV "ตะเบ็งเสียง" ; -- src=panlex
lin rid_V2 = variants{} ; -- 
lin acceptance_N = mkN "ความอดทน" | mkN "การยอมรับ" | mkN "การสนับสนุน" | mkN "การได้รับความเห็นชอบ" | mkN "การรับ" | mkN "การอดทน" | mkN "การทนทาน" | mkN "การยอมทน" | mkN "การยอมรับ" | mkN "การตรวจรับ" | mkN "การตกลงด้วย" | mkN "การรับเอามา" | mkN "การเต็มใจเชื่อ" | mkN "การเห็นด้วยกับ" | mkN "การเห็นพ้องกับ" | mkN "การตอบรับคําเชิญ" | mkN "การยอมรับเข้ากลุ่ม" ; -- src=panlex
lin detective_N = mkN "นักสืบ" | mkN "ตำรวจสายสืบ" | mkN "พนักงานสอบสวน" | mkN "พนักงานสืบสวน" | mkN "นับสืบ" | mkN "สายลับ" | mkN "สายสืบ" | mkN "ผู้สืบสวน" | mkN "ผู้ตรวจสอบ" ; -- src=panlex
lin sail_V = mkV "ท่อง" | mkV "นั่งเรือใบ" | mkV "แล่นเรือใบ" | mkV "ล่องเรือข้าม" | mkV "แล่นใบ" | mkV "ออกเรือ" | mkV "เดินเรือ" | mkV "แล่นเรือ" ; -- src=panlex
lin adjust_V2 = mkV2 "ปรับ" ; ---- | mkV "ปรับตัว" | mkV "จัดเป็นแนว" | mkV "ปรับเปลี่ยน" | mkV "ปรับให้เหมาะสม" | mkV "แก้ไข" | mkV "ปรับตัว" | mkV "ปรับปรุง" | mkV "ปรับเปลี่ยน" | mkV "เปลี่ยนแปลง" | mkV "ปรับให้เข้ากับสภาวะใหม่" ; -- src=panlex
lin adjust_V = mkV "ปรับ" | mkV "ปรับตัว" | mkV "จัดเป็นแนว" | mkV "ปรับเปลี่ยน" | mkV "ปรับให้เหมาะสม" | mkV "แก้ไข" | mkV "ปรับตัว" | mkV "ปรับปรุง" | mkV "ปรับเปลี่ยน" | mkV "เปลี่ยนแปลง" | mkV "ปรับให้เข้ากับสภาวะใหม่" ; -- src=panlex
lin designer_N = mkN "สถาปนิก" | mkN "มัณฑนากร" | mkN "ดีไซเนอร์" | mkN "นักออกแบบ" | mkN "ช่างตัดเสื้อ" | mkN "กราฟิคดีไซเนอร์" | mkN "ช่างตัดเสื้อสตรี" | mkN "ช่างออกแบบเสื้อผ้า" | mkN "นักออกแบบตกแต่งภายใน" | mkN "เจ้าหน้าที่กราฟฟิคดีไซด์" | mkN "นักออกแบบ" | mkN "ผู้วางแผน" | mkN "ผู้ออกแบบ" | mkN "ดีไซน์เนอร์" | mkN "นักออกแบบภายใน" ; -- src=panlex
lin running_A = mkA "ซึ่งวิ่งอยู่" | mkA "ซึ่งไหล" | mkA "ซึ่งต่อเนื่องกัน" | mkA "ซึ่งปฏิบัติหน้าที่อยู่" ; -- src=panlex
lin summit_N = mkN "ยอดเขา" | mkN "จุดสูงสุด" | mkN "ระดับสูงสุด" | mkN "ยอดเขา" | mkN "สุดขีด" | mkN "สุดยอด" | mkN "จุดสุดยอด" | mkN "จุดสูงสุด" | mkN "ระดับสูงสุด" | mkN "ยอดสุดของภูเขา" | mkN "การประชุมสุดยอด" | mkN "ความต้องการสูงสุด" ; -- src=panlex
lin participation_N = mkN "การมีส่วนร่วม" | mkN "การร่วมมือ" | mkN "การเข้าร่วม" | mkN "การมีส่วนร่วม" ; -- src=panlex
lin weakness_N = mkN "ข้อเสีย" | mkN "ความอ่อนแอ" | mkN "ข้อด้อย" | mkN "ข้อเสีย" | mkN "จุดอ่อน" | mkN "ความอ่อน" | mkN "ข้อบกพร่อง" | mkN "ความอ่อนแอ" | mkN "ความไม่แข็งแรง" | mkN "ความไม่เข้มแข็ง" | mkN "ความไร้สมรรถภาพ" | mkN "ความชอบเป็นพิเศษ" | mkN "ความไม่มีสมรรถภาพ" | mkN "สิ่งที่ชอบเป็นพิเศษ" ; -- src=panlex
lin block_V2 = variants{} ; -- 
lin socalled_A = variants{} ; -- 
lin adapt_V2 = mkV2 "ดัดแปลง" ; ---- | mkV "ปรับตัว" | mkV "ปรับ" | mkV "เหมาะ" | mkV "กลมกลืน" | mkV "เข้ากับ" | mkV "ทําให้เหมาะ" | mkV "ทําให้กลมกลืน" | mkV "ทําให้เข้ากับ" ; -- src=panlex
lin adapt_V = mkV "ดัดแปลง" | mkV "ปรับตัว" | mkV "ปรับ" | mkV "เหมาะ" | mkV "กลมกลืน" | mkV "เข้ากับ" | mkV "ทําให้เหมาะ" | mkV "ทําให้กลมกลืน" | mkV "ทําให้เข้ากับ" ; -- src=panlex
lin absorb_V2 = variants{} ; -- 
lin encounter_V2 = variants{} ; -- 
lin defeat_V2 = variants{} ; -- 
lin excitement_N = mkN "ความชุลมุน" | mkN "ความตื่นตัว" | mkN "ความวุ่นวาย" | mkN "ความตื่นเต้น" | mkN "ความรู้สึกระทึกใจ" | mkN "สิ่งเร้า" | mkN "ความตื่นเต้น" | mkN "ความเร่าร้อน" | mkN "สิ่งที่กระตุ้น" | mkN "ความกระตือรือร้น" | mkN "สิ่งที่น่าตื่นเต้น" ; -- src=panlex
lin brick_N = mkN "อิฐ" | mkN "อิฐ" | mkN "คนดี" | mkN "ิอิฐ" | mkN "ดินเผา" | mkN "ก้อนอิฐ" | mkN "คล้ายอิฐ" | mkN "สิ่งที่คล้ายอิฐ" ; -- src=panlex
lin blind_A = mkA "ซึ่งมองไม่เห็น" | mkA "ตัน" | mkA "บอด" | mkA "ปิด" | mkA "มองไม่เห็น" | mkA "ขาดการเตรียมพร้อม" ; -- src=panlex
lin wire_N = mkN "โทรเลข" | mkN "ลวด" | mkN "สายไฟ" | mkN "โทรเลข" | mkN "สายโลหะ" | mkN "สื่อสาร" | mkN "สายชักใย" | mkN "สายไฟฟ้า" | mkN "สายเคเบิล" | mkN "สายโทรเลข" | mkN "ระบบโทรเลข" | mkN "สายเบ็ดตกปลา" | mkN "สายลวดของเครื่องดนตรีประเภทสาย" ; -- src=panlex
lin crop_N = mkN "แส้" | mkN "กลุ่ม" | mkN "ผลผลิต" | mkN "ด้ามแส้" | mkN "พืชผลการเกษตร" | mkN "ผลผลิตพืชในฤดู" | mkN "กระเพาะพักอาหาร" | mkN "ผลผลิตในฤดูเก็บเกี่ยว" | mkN "แส้" | mkN "กลุ่ม" | mkN "พืชผล" | mkN "ทรงผมแบบสั้น" | mkN "ผลผลิตที่เก็บเกี่ยว" | mkN "กลุ่มคนหรือของที่รวมกันอยู่" | mkN "กระเพาะย่อยอาหารของสัตว์บางชนิด" ; -- src=panlex
lin square_A = mkA "ซื่อตรง" | mkA "ซื่อสัตย์" | mkA "สี่เหลี่ยม" | mkA "อย่างซื่อตรง" | mkA "ที่อุดมด้วยสารอาหาร" | mkA "มีสี่ด้าน" | mkA "เป็นสี่เหลี่ยม" | mkA "เป็นรูปสี่เหลี่ยม" ; -- src=panlex
lin transition_N = mkN "การเปลี่ยนผ่าน" | mkN "การเปลี่ยนแปลง" | mkN "การเปลี่ยนสถานะ" | mkN "การเปลี่ยนสภาวะ" | mkN "การเปลี่ยนกุญแจเสียง" | mkN "การผ่าน" | mkN "การนําส่ง" | mkN "การส่งผ่าน" | mkN "การเปลี่ยน" | mkN "การเปลี่ยนแปลง" | mkN "ภาวะหัวเลี้ยวหัวต่อ" | mkN "การเปลี่ยนแปลงลําดับ" ; -- src=panlex
lin thereby_Adv = mkAdv "ด้วยวิธีนั้น" | mkAdv "ดังนั้น" | mkAdv "โดยวิธีนั้น" | mkAdv "ด้วยวิธีนั้น" | mkAdv "ด้วยเหตุนั้น" | mkAdv "เนื่องด้วยเหตุนั้น" ; -- src=panlex
lin protest_V2 = mkV2 "ประท้วง" ; ---- | mkV "ยืนยัน" | mkV "ขัดขวาง" | mkV "คัดค้าน" | mkV "ทักท้วง" | mkV "ประท้วง" | mkV "ประกาศยืนยัน" ; -- src=panlex
lin protest_V = mkV "ประท้วง" | mkV "ยืนยัน" | mkV "ขัดขวาง" | mkV "คัดค้าน" | mkV "ทักท้วง" | mkV "ประท้วง" | mkV "ประกาศยืนยัน" ; -- src=panlex
lin roll_N = mkN "โรล" | mkN "ม้วน" | mkN "การกลิ้ง" | mkN "ความหยิก" | mkN "การทอดลูกเต๋า" | mkN "การทอยลูกเต๋า" | mkN "การหมุนรอบแกน" | mkN "เสียงกลองสแนร์" | mkN "การหมุน" | mkN "การโคลง" | mkN "ลูกกลิ้ง" | mkN "เสียงรัว" | mkN "เครื่องบด" | mkN "ก้อนขนมปัง" | mkN "ม้วนเอกสาร" | mkN "เสียงรัวกลอง" | mkN "การโยนลูกเต๋า" | mkN "การบินควงสว่าน" | mkN "การหมุนแบบวงล้อ" | mkN "การเดินโคลงเคลง" | mkN "อาหารที่อยู่ในห่อ" | mkN "การคลึงด้วยลูกกลิ้ง" | mkN "สิ่งที่มีลักษณะเป็นม้วนกลม" ; -- src=panlex
lin stop_N = mkN "จุด" | mkN "จุดจอด" | mkN "การหยุด" | mkN "ฟุลสต็อป" | mkN "ไดอะแฟรม" | mkN "การหยุดพัก" | mkN "พยัญชนะกัก" | mkN "จุดฟุลสต็อป" | mkN "พยัญชนะหยุด" | mkN "สิ่งกีดขวาง" | mkN "การหยุดชะงัก" | mkN "พยัญชนะระเบิด" | mkN "การหน่วงเหนี่ยว" | mkN "พยัญชนะเสียงกัก" | mkN "พยัญชนะเสียงหยุด" | mkN "พยัญชนะเสียงระเบิด" | mkN "เครื่องหมายมหัพภาค" | mkN "ฝา" | mkN "จอด" | mkN "จุก" | mkN "ปิด" | mkN "พัก" | mkN "อุด" | mkN "ยุติ" | mkN "หยุด" | mkN "ห้าม" | mkN "เลิก" | mkN "ฝาปิด" | mkN "การพัก" | mkN "การแวะ" | mkN "ตัดขาด" | mkN "ที่ปิด" | mkN "การค้าง" | mkN "การยุติ" | mkN "การหยุด" | mkN "การเลิก" | mkN "ขัดขวาง" | mkN "ป้องกัน" | mkN "ยับยั้ง" | mkN "การแวะพัก" | mkN "สถานีรถไฟ" | mkN "สิ่งกีดขวาง" | mkN "สถานีรถประจําทาง" | mkN "ป้ายหยุดรถประจําทางหรือรถไฟ" ; -- src=panlex
lin assistant_N = variants{} ; -- 
lin deaf_A = mkA "หูหนวก" | mkA "หนวก" | mkA "หูหนวก" | mkA "ไม่ยอมฟัง" | mkA "ไม่เชื่อฟัง" | mkA "ซึ่งไม่ได้ยิน" ; -- src=panlex
lin constituency_N = mkN "ผู้มีสิทธิเลือกตั้งในเขต" | mkN "เขตเลือกตั้ง" | mkN "ประชาชนผู้มีสิทธิเลือกตั้งในเขตหนึ่ง" | mkN "ผู้ที่มีสิทธิเลือกตั้งในเขตเลือกตั้ง" ; -- src=panlex
lin continuous_A = mkA "ต่อเนื่อง" | mkA "ซึ่งติดต่อกัน" | mkA "ซึ่งต่อเนื่องกัน" ; -- src=panlex
lin concert_N = mkN "คอนเสิร์ต" | mkN "คอนเสิร์ต" | mkN "การแสดงดนตรี" | mkN "การเห็นพ้องร่วมกัน" ; -- src=panlex
lin breast_N = mkN (thword "หน้า" "อก") | {-pan-} mkN "นม" | mkN "อก" | mkN "ถัน" | mkN "เต้า" | mkN "ทรวงอก" | mkN "พระถัน" | mkN "หน้าอก" | mkN "เต้านม" | mkN "พระทรวง" | mkN "พระอุระ" | mkN "พระเต้า" | mkN "เนื้อหน้าอก" | mkN "หน้าอกหน้าใจ" | mkN "หน้าอกของผู้หญิง" | mkN "นม" | mkN "ถัน" | mkN "หน้าอก" ; -- src=panlex
lin extraordinary_A = mkA "พิเศษ" | mkA "วิสามัญ" | mkA "เกินปกติ" | mkA "ผิดธรรมดา" | mkA "เกินธรรมดา" | mkA "เพื่อจุดประสงค์พิเศษ" ; -- src=panlex
lin squad_N = mkN "ทีม" | mkN "หน่วย" | mkN "หน่วยตำรวจ" | mkN "คณะ" | mkN "ทีม" | mkN "หมู่" | mkN "กลุ่ม" | mkN "หมู่คน" | mkN "กลุ่มคน" | mkN "กลุ่มทหาร" | mkN "จัดเข้ากลุ่ม" ; -- src=panlex
lin wonder_N = mkN "สิ่งมหัศจรรย์" | mkN "ความอยากรู้อยากเห็น" | mkN "ความงงงวย" | mkN "ความแปลกใจ" | mkN "สิ่งประหลาด" | mkN "สิ่งน่าพิศวง" | mkN "ความประหลาดใจ" | mkN "ความรู้สึกประหลาดใจ" ; -- src=panlex
lin cream_N = mkN "ครีม" | mkN "พวกหัวกะทิ" | mkN "กลุ่มหัวกะทิ" | mkN "ครีมบำรุงผิว" | mkN "ครีม" | mkN "สีนวล" | mkN "สีครีม" | mkN "ครีมทาผิว" | mkN "โลชั่นทาผิว" | mkN "ส่วนที่ดีที่สุด" | mkN "อาหารที่ประกอบหรือมีลักษณะเป็นครีม" ; -- src=panlex
lin tennis_N = mkN "เทนนิส" | mkN "กีฬาเทนนิส" | mkN "กีฬาลูกสักหลาด" | mkN "เทนนิสคอร์ตหญ้า" | mkN "เทนนิส" | mkN "กีฬาเทนนิส" ; -- src=panlex
lin personally_Adv = variants{} ; -- 
lin communicate_V2 = mkV2 "ส่ง" ; ---- | mkV "ติดต่อ" | mkV "สื่อสาร" | mkV "แพร่เชื้อ" | mkV "ติดต่อสื่อสาร" | mkV "ส่งต่อ" | mkV "ส่งผ่าน" | mkV "เชื่อมติดกัน" | mkV "ติดต่อสื่อสาร" ; -- src=panlex
lin communicate_V = mkV "ส่ง" | mkV "ติดต่อ" | mkV "สื่อสาร" | mkV "แพร่เชื้อ" | mkV "ติดต่อสื่อสาร" | mkV "ส่งต่อ" | mkV "ส่งผ่าน" | mkV "เชื่อมติดกัน" | mkV "ติดต่อสื่อสาร" ; -- src=panlex
lin pride_N = mkN "ฝูงสิงโต" | mkN "ความภูมิใจ" | mkN "ความภาคภูมิใจ" | mkN "ทิฐิ" | mkN "ความทะนง" | mkN "ฝูงสิงโต" | mkN "ลําพองใจ" | mkN "ความหยิ่ง" | mkN "ความโอหัง" | mkN "ความดีเด่น" | mkN "ความทะนงตน" | mkN "ความภูมิใจ" | mkN "กําลังของม้า" | mkN "ความลําพองใจ" | mkN "ความภาคภูมิใจ" | mkN "สิ่งที่ดีที่สุด" | mkN "ภาวะที่รุ่งโรจน์" | mkN "สิ่งที่น่าภูมิใจ" ; -- src=panlex
lin bowl_N = mkN "ชาม" | mkN "การกลิ้ง" | mkN "สนามกีฬา" | mkN "สเตเดียม" | mkN "ลูกโบวลิ่ง" | mkN "ที่ใส่ยาสูบ" | mkN "ลูกโบว์ลิ่ง" | mkN "โถ" | mkN "ขัน" | mkN "ชาม" | mkN "ถ้วย" | mkN "บาตร" | mkN "สนาม" | mkN "เล่น" | mkN "เวที" | mkN "กระปุก" | mkN "ชามกลม" | mkN "เหยือก" | mkN "กระเปาะ" | mkN "ลูกโบว์ลิ่ง" | mkN "เล่นโบว์ลิ่ง" | mkN "ส่วนกลมของกล้องสูบยาเส้นสําหรับบรรจุยา" ; -- src=panlex
lin file_V2 = mkV2 "ทำบันทึก" ; ---- | mkV "เดินเป็นแถว" | mkV "เดินเรียงแถว" | mkV "ตะไบ" | mkV "เดินแถว" | mkV "ใส่แฟ้ม" | mkV "ฟ้องร้อง" | mkV "ยื่นฟ้อง" | mkV "ถูด้วยตะไบ" | mkV "จัดเข้าแฟ้ม" | mkV "ยื่นคําร้อง" | mkV "เก็บเข้าไฟล์" | mkV "เดินเรียงแถว" | mkV "จัดเก็บเข้าแฟ้ม" | mkV "ส่งต้นฉบับไปที่สํานักข่าว" | mkV "ส่งต้นฉบับไปที่สํานักพิมพ์" ; -- src=panlex
lin file_V = mkV "ทำบันทึก" | mkV "เดินเป็นแถว" | mkV "เดินเรียงแถว" | mkV "ตะไบ" | mkV "เดินแถว" | mkV "ใส่แฟ้ม" | mkV "ฟ้องร้อง" | mkV "ยื่นฟ้อง" | mkV "ถูด้วยตะไบ" | mkV "จัดเข้าแฟ้ม" | mkV "ยื่นคําร้อง" | mkV "เก็บเข้าไฟล์" | mkV "เดินเรียงแถว" | mkV "จัดเก็บเข้าแฟ้ม" | mkV "ส่งต้นฉบับไปที่สํานักข่าว" | mkV "ส่งต้นฉบับไปที่สํานักพิมพ์" ; -- src=panlex
lin expertise_N = mkN "ความเชี่ยวชาญ" | mkN "ความชํานาญ" | mkN "ทักษะความรู้" | mkN "ความรู้ความชํานาญ" | mkN "ความคิดเห็นของผู้เชี่ยวชาญ" ; -- src=panlex
lin govern_V2 = mkV2 "กำหนด" ; ---- | mkV "ปกครอง" | mkV "จัดระเบียบ" | mkV "ดูแล" | mkV "ควบคุม" | mkV "บังคับ" | mkV "ปกครอง" | mkV "ครอบงํา" | mkV "วางระเบียบ" ; -- src=panlex
lin govern_V = mkV "กำหนด" | mkV "ปกครอง" | mkV "จัดระเบียบ" | mkV "ดูแล" | mkV "ควบคุม" | mkV "บังคับ" | mkV "ปกครอง" | mkV "ครอบงํา" | mkV "วางระเบียบ" ; -- src=panlex
lin leather_N = mkN (thword "หนัง" "สัตว์") | {-pan-} mkN "หนัง" | mkN "หนัง" | mkN "หนังสัตว์" ; -- src=panlex ----?
lin observer_N = mkN "ผู้รับรู้" | mkN "ผู้ให้ทัศนะ" | mkN "ผู้สังเกตการณ์" | mkN "ผู้สังเกต" | mkN "ผู้สังเกตการณ์" ; -- src=panlex
lin margin_N = mkN "ขอทาน" | mkN "ค่าต่าง" | mkN "กำไรขั้นต้น" | mkN "เส้นแบ่งเขต" | mkN "หลักประกันลูกค้า" | mkN "ขอบ" | mkN "ชาย" | mkN "ริม" | mkN "ข้าง" | mkN "ขอบเขต" | mkN "ผลต่าง" | mkN "ร่อแร่" | mkN "ช่องว่าง" | mkN "ส่วนเกิน" | mkN "วางเงินทดรอง" | mkN "ปริมาณที่ต่างกัน" | mkN "ส่วนที่เผื่อเอาไว้" | mkN "ทําให้มีริมหรือข้าง" | mkN "จํานวนที่เผื่อเอาไว้" | mkN "เงินทดรองความสูญเสีย" | mkN "จํานวนที่แตกต่างกันอยู่" | mkN "ค่าแตกต่างระหว่างสองสิ่ง" | mkN "จํานวนที่เผื่อเหลือเผื่อขาด" | mkN "ค่าแตกต่างระหว่างราคาทุนกับราคาขาย" ; -- src=panlex
lin uncertainty_N = mkN "ความไม่แน่ใจ" | mkN "ความลังเล" | mkN "ความไม่แน่ใจ" | mkN "ความคลุมเครือ" | mkN "ความไม่แน่นอน" | mkN "ความรู้สึกไม่แน่ใจ" | mkN "ความรู้สึกไม่มั่นคง" ; -- src=panlex
lin reinforce_V2 = variants{} ; -- 
lin ideal_N = mkN "อุดมคติ" | mkN "ตัวอย่างที่ดี" | mkN "แบบอย่างที่ดี" | mkN "สมบูรณ์" | mkN "อุดมคติ" | mkN "เพ้อฝัน" | mkN "ไม่มีจริง" | mkN "แบบอย่างที่ดี" | mkN "ไม่เป็นความจริง" | mkN "ต้นแบบที่สมบูรณ์" | mkN "เกี่ยวกับอุดมคติ" | mkN "ตัวอย่างที่สมบูรณ์" | mkN "เกี่ยวกับอุดมการณ์" | mkN "เป็นเพียงความนึกฝัน" ; -- src=panlex
lin injure_V2 = variants{} ; -- 
lin holding_N = mkN "ทรัพย์สิน" | mkN "การยึด" | mkN "สิ่งยึด" | mkN "สินทรัพย์ โดยเฉพาะหุ้นและพันธบัตร" | mkN "การครอบครอง" | mkN "ที่ดินที่เช่านา" | mkN "พื้นที่ที่เช่าจากผู้อื่นเพื่อทําการเพาะปลูก" ; -- src=panlex
lin universal_A = mkA "สากล" | mkA "อเนกประสงค์" | mkA "สากล" | mkA "ทั่วไป" | mkA "ทั้งมวล" | mkA "ทั้งหมด" | mkA "มีผลทั่วไป" | mkA "ี่เป็นสากล" | mkA "ทุกหนทุกแห่ง" | mkA "มโนธรรมทั่วไป" | mkA "เกี่ยวกับจักรวาล" | mkA "ข้อต่ออเนกประสงค์" | mkA "ลักษณะเฉพาะทั่วไป" | mkA "ที่มีผลกับคนทั้งโลก" ; -- src=panlex
lin evident_A = mkA "เป็นที่ประจักษ์ชัด" | mkA "ชัดเจน" | mkA "ชัดแจ้ง" | mkA "ปรากฏชัด" ; -- src=panlex
lin dust_N = mkN (thword "ฝุ่น") | {-pan-} mkN "ผง" | mkN "ฝุ่น" | mkN "เศษซาก" | mkN "ขี้ฝุ่น" | mkN "ซากปรักหักพัง" | mkN "ผง" | mkN "ธุลี" | mkN "ฝุ่น" | mkN "ละออง" | mkN "เศษผง" | mkN "ฝุ่นละออง" ; -- src=panlex
lin overseas_A = mkA "เกี่ยวกับต่างประเทศ" | mkA "ที่เดินทางท่องเที่ยวข้ามทะเล" ; -- src=panlex
lin desperate_A = mkA "จน" | mkA "รุนแรง" | mkA "เข้าตา" | mkA "เลวมาก" | mkA "ร้ายแรง" | mkA "ล่อแหลม" | mkA "อันตราย" | mkA "เต็มที่" | mkA "อย่างยิ่ง" | mkA "เหลือเกิน" | mkA "ร้ายแรงมาก" | mkA "ซึ่งหมดหวัง" | mkA "ซึ่งสิ้นหวัง" | mkA "เต็มไปด้วยอันตราย" | mkA "มีความต้องการอย่างมาก" ; -- src=panlex
lin swim_V2 = mkV2 (thword "ว่าย") ; ---- | {-pan-} mkV "จม" | mkV "ลอย" | mkV "ว่าย" | mkV "ล่องลอย" | mkV "ว่ายน้ำ" | mkV "หมุนติ้ว" | mkV "ลอย" | mkV "ว่าย" | mkV "ตาลาย" | mkV "สับสน" | mkV "ลอยน้ํา" | mkV "ลอยคว้าง" | mkV "วิงเวียน" | mkV "ว่ายน้ํา" | mkV "เวียนศีรษะ" ; -- src=panlex
lin swim_V = mkV (thword "ว่าย") | {-pan-} mkV "จม" | mkV "ลอย" | mkV "ว่าย" | mkV "ล่องลอย" | mkV "ว่ายน้ำ" | mkV "หมุนติ้ว" | mkV "ลอย" | mkV "ว่าย" | mkV "ตาลาย" | mkV "สับสน" | mkV "ลอยน้ํา" | mkV "ลอยคว้าง" | mkV "วิงเวียน" | mkV "ว่ายน้ํา" | mkV "เวียนศีรษะ" ; -- src=panlex
lin occasional_A = mkA "ตามโอกาส" | mkA "เฉพาะกาล" | mkA "เฉพาะสมัย" | mkA "ซึ่งเป็นครั้งคราว" | mkA "สําหรับโอกาสพิเศษ" | mkA "เป็นครั้งเป็นคราว" | mkA "ซึ่งใช้ในโอกาสพิเศษ" ; -- src=panlex
lin trouser_N = mkN "กางเกง" | mkN "พระสนับเพลา" ; -- src=panlex
lin surprisingly_Adv = variants{} ; -- 
lin register_N = mkN "ทะเบียน" | mkN "รีจิสเตอร์" | mkN "เครื่องบันทึกจำนวนเงิน" | mkN "บันทึก" | mkN "ทะเบียน" | mkN "สมุดทะเบียน" | mkN "การลงทะเบียน" | mkN "สมุดลงทะเบียน" | mkN "เครื่องบันทึก" | mkN "เจ้าหน้าที่ทะเบียน" | mkN "เครื่องรับจ่ายเงินสดโดยอัตโนมัติ" ; -- src=panlex
lin album_N = mkN "อัลบั้มบันทึก" | mkN "อัลบั้ม" | mkN "จานเสียง" | mkN "แผ่นเสียง" | mkN "ชุดแผ่นเสียง" | mkN "แผ่นเสียงขนาดใหญ่" | mkN "สมุดลงนามของผู้มาเยี่ยม" ; -- src=panlex
lin guideline_N = mkN "โรดแมพ" | mkN "ไกด์ไลน์" | mkN "แบบแผนต้นแบบ" | mkN "นโยบาย" | mkN "ตัวชี้นํา" | mkN "เครื่องชี้แนว" | mkN "เครื่องนําทาง" ; -- src=panlex
lin disturb_V2 = variants{} ; -- 
lin amendment_N = mkN "การแก้ไข" | mkN "การปรับปรุง" | mkN "การพัฒนาขึ้น" | mkN "การปรับปรุงขึ้น" | mkN "การแก้หรือแปรญัตติ" | mkN "คําแก้หรือคําแปรญัตติ" ; -- src=panlex
lin architectMasc_N = variants{} ; -- 
lin objection_N = mkN "การคัดค้าน" | mkN "การประท้วง" | mkN "การคัดค้าน" | mkN "การโต้แย้ง" | mkN "" | mkN "การไม่เห็นด้วย" | mkN "เหตุผลที่คัดค้าน" | mkN "ความรู้สึกคัดค้าน" | mkN "สาเหตุของการคัดค้าน" ; -- src=panlex
lin chart_N = mkN "ชาร์ต" | mkN "แผนภูมิ" | mkN "ผัง" | mkN "กราฟ" | mkN "ตาราง" | mkN "แผนที่" | mkN "แผนผัง" | mkN "แผนภาพ" | mkN "แผนภูมิ" | mkN "ผังอากาศ" | mkN "วางแผนการ" | mkN "แผนที่ทะเล" | mkN "แผนที่การบิน" ; -- src=panlex
lin cattle_N = mkN "วัวควาย" | mkN "สัตว์" | mkN "คนชั่ว" | mkN "วัวควาย" | mkN "ปศุสัตว์" ; -- src=panlex
lin doubt_VS = variants{} ; -- 
lin doubt_V2 = variants{} ; -- 
lin react_V = mkV "ตอบสนอง" | mkV "ต่อต้าน" | mkV "ทำปฏิกิริยา" | mkV "เกิดปฏิกิริยา" | mkV "ตอบสนอง" | mkV "เกิดปฏิกิริยาต่อต้าน" | mkV "เกิดปฏิกิริยาทางเคมี" ; -- src=panlex
lin consciousness_N = mkN "ความมีสติ" | mkN "ความตระหนัก" | mkN "ความตระหนักรู้" | mkN "ภาวะจิต" | mkN "ความมีสติ" | mkN "ความตระหนัก" | mkN "ความตระหนักรู้" | mkN "ความมีจิตสํานึก" | mkN "ความคิดและความรู้สึกรวมกัน" ; -- src=panlex
lin right_Interj = variants{} ; -- 
lin purely_Adv = variants{} ; -- 
lin tin_N = mkN "ป๋อง" | mkN "ดีบุก" | mkN "กระป๋อง" | mkN "ธาตุดีบุก" | mkN "เลขอะตอม 50" | mkN "ดีบุก" | mkN "กระป๋อง" | mkN "แร่ดีบุก" | mkN "ภาชนะที่ทําจากดีบุก" ; -- src=panlex
lin tube_N = mkN "ท่อ" | mkN "หลอดสุญญากาศ" | mkN "หลอดสูญญากาศ" | mkN "ทางรถไฟใต้ดิน" | mkN "รางรถไฟใต้ดิน" | mkN "โครงสร้างรูปท่อ" | mkN "ท่อ" | mkN "หลอด" | mkN "ทางใต้ดิน" ; -- src=panlex
lin fulfil_V2 = variants{} ; -- 
lin commonly_Adv = variants{} ; -- 
lin sufficiently_Adv = variants{} ; -- 
lin coin_N = mkN "เหรียญ" | mkN "เงินเหรียญ" | mkN "เหรียญ" | mkN "เหรียญกษาปน์" ; -- src=panlex
lin frighten_V2 = variants{} ; -- 
lin grammar_N = mkN (thword "ไวย" "กรณ์") | {-pan-} mkN "ไวยากรณ์" | mkN "หลักไวยากรณ์" | mkN "หนังสือไวยากรณ์" ; -- src=panlex ----?
lin diary_N = mkN "ไดอะรี่" | mkN "ไดอารี่" | mkN "สมุดบันทึก" | mkN "บันทึกประจำวัน" | mkN "อนุทิน" | mkN "ไดอารี่" | mkN "สมุดบันทึก" | mkN "บันทึกประจําวัน" ; -- src=panlex
lin flesh_N = mkN "กาย" | mkN "เนื้อ" | mkN "สังขาร" | mkN "ร่างกาย" | mkN "พระมังสา" | mkN "พระวรกาย" | mkN "เนื้อหนัง" | mkN "เนื้อผลไม้" | mkN "ร่างกายมนุษย์" | mkN "เนื้อหนังมังสา" | mkN "ร่างกายของมนุษย์" | mkN "มังสา" | mkN "เนื้อ" | mkN "มนุษย์" | mkN "ผิวหนัง" | mkN "ร่างกาย" | mkN "ความอ้วน" | mkN "น้ําหนัก" | mkN "ลูกในไส้" | mkN "เนื้อผลไม้" | mkN "เนื้อสัตว์" | mkN "ญาติพี่น้อง" | mkN "ผิวเนื้อของคน" | mkN "เนื้อหนังมังสา" | mkN "สิ่งมีชีวิตทั้งหลาย" ; -- src=panlex
lin summary_N = mkN "สรุป" | mkN "สรุปผล" | mkN "ใจความสรุป" | mkN "สรุป" | mkN "รวบรัด" | mkN "โดยตรง" | mkN "รวดเร็ว" | mkN "บทความย่อ" | mkN "โดยสังเขป" | mkN "สาระสําคัญ" | mkN "ใจความสรุป" | mkN "ใจความรวบรัด" | mkN "ใจความสําคัญ" ; -- src=panlex
lin infant_N = mkN "ทารก" | mkN "ลูกอ่อน" | mkN "เด็กทารก" | mkN "เด็กอ่อน" | mkN "เด็กแดงๆ" | mkN "เด็กแบเบาะ" | mkN "เจ้าเนื้ออ่อน" | mkN "ลูกเด็กเล็กแดง" | mkN "ทารก" | mkN "เด็กอ่อน" ; -- src=panlex
lin stir_V2 = mkV2 "คน" ; ---- | mkV "กวน" | mkV "ผสม" | mkV "เสก" | mkV "เร้า" | mkV "เขยิบ" | mkV "กระตุ้น" | mkV "กระทบใจ" | mkV "กระเถิบ" | mkV "ปลุกเร้า" | mkV "เร้าความรู้สึก" | mkV "เริ่มเคลื่อนที่" | mkV "กระตุ้นความรู้สึก" | mkV "กวน" | mkV "ขยับ" | mkV "ค่อยๆ เคลื่อน" | mkV "กระตุ้น" | mkV "ปลุกเร้า" | mkV "คนให้เข้ากัน" | mkV "ทําให้ตื่นเต้น" ; -- src=panlex
lin stir_V = mkV "คน" | mkV "กวน" | mkV "ผสม" | mkV "เสก" | mkV "เร้า" | mkV "เขยิบ" | mkV "กระตุ้น" | mkV "กระทบใจ" | mkV "กระเถิบ" | mkV "ปลุกเร้า" | mkV "เร้าความรู้สึก" | mkV "เริ่มเคลื่อนที่" | mkV "กระตุ้นความรู้สึก" | mkV "กวน" | mkV "ขยับ" | mkV "ค่อยๆ เคลื่อน" | mkV "กระตุ้น" | mkV "ปลุกเร้า" | mkV "คนให้เข้ากัน" | mkV "ทําให้ตื่นเต้น" ; -- src=panlex
lin storm_N = mkN "พายุ" | mkN "พายุ" | mkN "มรสุม" | mkN "การโหม กระหน่ํา" | mkN "ลมมรสุม" | mkN "การระดมยิง" | mkN "ความโกลาหล" | mkN "การโหมกระหน่ํา" | mkN "ความเกรียวกราว" | mkN "การโจมตีอย่างรุนแรง" | mkN "การแสดงออกอย่างรุนแรง" | mkN "สิ่งที่กระหน่ําลงมาอย่างแรง" | mkN "อารมณ์ที่แสดงออกอย่างรุนแรง" | mkN "การโจมตีหรือกล่าวหาอย่างรุนแรง" ; -- src=panlex
lin mail_N = mkN "เมล์" | mkN "ไปรษณีย์" | mkN "เกราะโซ่ถัก" | mkN "ระบบไปรษณีย์" | mkN "ไปรษณียภัณฑ์" | mkN "ชุดเกราะห่วงโซ่" | mkN "รถส่งไปรษณียภัณฑ์" | mkN "เกราะ" | mkN "จดหมาย" | mkN "ไปรษณีย์" | mkN "ระบบไปรษณีย์" | mkN "ไปรษณียภัณฑ์" | mkN "ไปรษณีย์ภัณฑ์" | mkN "การขนส่งทางไปรษณีย์" | mkN "ของที่ส่งทางไปรษณีย์" | mkN "พาหนะบรรทุกไปรษณียภัณฑ์" ; -- src=panlex
lin rugby_N = mkN "รักบี้" | mkN "กีฬารักบี้" | mkN "รักบี้ฟุตบอล" | mkN "กีฬารักบี้" ; -- src=panlex
lin virtue_N = mkN "ความมีศีลธรรม" | mkN "การไม่ประพฤติผิดในกาม" | mkN "ศีลธรรม" | mkN "พรหมจารี" | mkN "คุณความดี" | mkN "พรหมจรรย์" | mkN "กําลังวังชา" | mkN "ความถูกต้อง" | mkN "คุณงามความดี" | mkN "ความบริสุทธิ์" | mkN "ความมีศีลธรรม" | mkN "คุณสมบัติที่ดีและน่าชื่นชม" | mkN "" ; -- src=panlex
lin specimen_N = mkN "ตัวอย่าง" | mkN "อุทาหรณ์" | mkN "แบบอย่าง" | mkN "ประเภทประหลาด" | mkN "ตัวอย่างสําหรับทดสอบ" ; -- src=panlex
lin psychology_N = mkN "จิตวิทยา" | mkN "จิตวิทยา" ; -- src=panlex
lin paint_N = mkN "สี" | mkN "แป้งตลับ" | mkN "ตลัีบแป้ง" | mkN "สี" | mkN "สีย้อม" | mkN "การทาสี" | mkN "การระบายสี" | mkN "สีแต่งหน้า" | mkN "การเคลือบสี" | mkN "เครื่องสําอาง" | mkN "สีสําหรับทาหรือเขียน" ; -- src=panlex
lin constraint_N = mkN "การยับยั้ง" | mkN "การคุมขัง" | mkN "การจํากัด" | mkN "ข้อจํากัด" | mkN "การบีบบังคับ" | mkN "แรงบีบบังคับ" | mkN "ความยับยั้งชั่งใจ" | mkN "การระงับความรู้สึก" | mkN "การควบคุมความรู้สึก" | mkN "ภาวะที่ถูกบีบบังคับ" ; -- src=panlex
lin trace_V2 = mkV2 "ขีด" ; ---- | mkV "ลาก" | mkV "ตามรอย" | mkV "ตามล่า" | mkV "ติดตาม" | mkV "ย้อนรอยเดิม" | mkV "ตามหา" | mkV "ตามรอย" | mkV "ติดตาม" | mkV "สะกดรอย" | mkV "ร่างคร่าวๆ" | mkV "สืบหาร่องรอย" | mkV "อธิบายคร่าวๆ" ; -- src=panlex
lin trace_V = mkV "ขีด" | mkV "ลาก" | mkV "ตามรอย" | mkV "ตามล่า" | mkV "ติดตาม" | mkV "ย้อนรอยเดิม" | mkV "ตามหา" | mkV "ตามรอย" | mkV "ติดตาม" | mkV "สะกดรอย" | mkV "ร่างคร่าวๆ" | mkV "สืบหาร่องรอย" | mkV "อธิบายคร่าวๆ" ; -- src=panlex
lin privilege_N = mkN "สิทธิ" | mkN "โอกาส" | mkN "อภิสิทธิ์" | mkN "เอกสิทธิ์" | mkN "สิทธิพิเศษ" | mkN "อํานาจพิเศษ" | mkN "ข้อได้เปรียบ" | mkN "ประโยชน์พิเศษ" | mkN "ให้อภิสิทธิ์แก่" ; -- src=panlex
lin completion_N = mkN "การจบ" | mkN "การลงเอย" | mkN "การเสร็จสมบูรณ์" | mkN "การสรุป" | mkN "การทําเสร็จ" | mkN "การทําให้เสร็จ" | mkN "การทําให้สมบูรณ์" | mkN "การสําเร็จลุล่วง" | mkN "การส่งลูกฟุตบอลไปข้างหน้าได้สําเร็จ" ; -- src=panlex
lin progress_V2 = mkV2 "สะสม" ; ---- | mkV "ก้าวหน้า" | mkV "เคลื่อนไป" | mkV "คืบหน้า" | mkV "รุดหน้า" | mkV "ก้าวหน้า" | mkV "เดินหน้า" | mkV "เดินไปข้างหน้า" ; -- src=panlex
lin progress_V = mkV "สะสม" | mkV "ก้าวหน้า" | mkV "เคลื่อนไป" | mkV "คืบหน้า" | mkV "รุดหน้า" | mkV "ก้าวหน้า" | mkV "เดินหน้า" | mkV "เดินไปข้างหน้า" ; -- src=panlex
lin grade_N = mkN "ชั้น" | mkN "เกรด" | mkN "แต้ม" | mkN "ดีกรี" | mkN "ระดับ" | mkN "เลเวล" | mkN "การทำทางลาด" | mkN "ขีด" | mkN "ตอน" | mkN "ขั้น" | mkN "ชนิด" | mkN "ชั้น" | mkN "เกรด" | mkN "ระดับ" | mkN "ชนชั้น" | mkN "ระดับคะแนน" | mkN "นักเรียนในชั้น" ; -- src=panlex
lin exploit_V2 = variants{} ; -- 
lin import_N = mkN "ของนำเข้า" | mkN "ของอิมพอร์ต" | mkN "มีผลกระทบต่อ" | mkN "สินค้านำเข้า" | mkN "สินค้าอิมพอร์ต" | mkN "ความหมาย" | mkN "การนําเข้า" | mkN "ความสําคัญ" | mkN "สินค้าเข้า" | mkN "สินค้านําเข้า" | mkN "การนําสินค้าเข้าประเทศ" ; -- src=panlex
lin potato_N = mkN "มันฝรั่ง" | mkN "ต้นไวต์โปเตโต" | mkN "มัน" | mkN "มันฝรั่ง" | mkN "หัวมันฝรั่ง" ; -- src=panlex
lin repair_N = mkN "การซ่อม" | mkN "การซ่อมแซม" | mkN "สถานที่ที่ไปบ่อย" | mkN "สถานที่ที่ไปเป็นประจำ" | mkN "การแก้ไข" | mkN "การซ่อมแซม" ; -- src=panlex
lin passion_N = mkN "ความรัก" | mkN "ความหลงใหล" | mkN "ความลุ่มหลง" | mkN "ความบ้าคลั่ง" | mkN "ราคะ" | mkN "โทสะ" | mkN "กิเลส" | mkN "ตัณหา" | mkN "ตันหา" | mkN "อารมณ์" | mkN "ความชอบ" | mkN "ความโกรธ" | mkN "ความโมโห" | mkN "ความหลงใหล" | mkN "ความไม่พอใจ" ; -- src=panlex
lin seize_V2 = mkV2 "กุม" ; ---- | mkV "ยึด" | mkV "ตรึง" | mkV "เย้อ" | mkV "อายัด" | mkV "จับตัว" | mkV "จับไว้แน่น" | mkV "เข้าควบคุม" | mkV "เกาะกุมจิตใจ" | mkV "ฉก" | mkV "กุม" | mkV "กํา" | mkV "จับ" | mkV "ฉวย" | mkV "มัด" | mkV "ยึด" | mkV "คว้า" | mkV "ยั้ง" | mkV "หยุด" | mkV "ฉกฉวย" | mkV "จับกุม" | mkV "บุกจับ" | mkV "รวบตัว" | mkV "รวบรัด" | mkV "เข้าใจ" | mkV "เกาะกุม" | mkV "ฉวยโอกาส" | mkV "ถือโอกาส" | mkV "ควบคุมตัว" | mkV "คว้าโอกาส" | mkV "ผูกเงื่อน" | mkV "ยึดครองจิตใจ" | mkV "ยึดสถานการณ์" | mkV "เกาะกุมจิตใจ" | mkV "เข้าครอบครอง" | mkV "ครองสถานการณ์" | mkV "ใช้อํานาจมิชอบ" | mkV "เข้าครอบงําจิตใจ" ; -- src=panlex
lin seize_V = mkV "กุม" | mkV "ยึด" | mkV "ตรึง" | mkV "เย้อ" | mkV "อายัด" | mkV "จับตัว" | mkV "จับไว้แน่น" | mkV "เข้าควบคุม" | mkV "เกาะกุมจิตใจ" | mkV "ฉก" | mkV "กุม" | mkV "กํา" | mkV "จับ" | mkV "ฉวย" | mkV "มัด" | mkV "ยึด" | mkV "คว้า" | mkV "ยั้ง" | mkV "หยุด" | mkV "ฉกฉวย" | mkV "จับกุม" | mkV "บุกจับ" | mkV "รวบตัว" | mkV "รวบรัด" | mkV "เข้าใจ" | mkV "เกาะกุม" | mkV "ฉวยโอกาส" | mkV "ถือโอกาส" | mkV "ควบคุมตัว" | mkV "คว้าโอกาส" | mkV "ผูกเงื่อน" | mkV "ยึดครองจิตใจ" | mkV "ยึดสถานการณ์" | mkV "เกาะกุมจิตใจ" | mkV "เข้าครอบครอง" | mkV "ครองสถานการณ์" | mkV "ใช้อํานาจมิชอบ" | mkV "เข้าครอบงําจิตใจ" ; -- src=panlex
lin low_Adv = mkAdv "ถูก" | mkAdv "หมด" | mkAdv "เลว" | mkAdv "งอลง" | mkAdv "ชั่ว" | mkAdv "ต่ํา" | mkAdv "น้อย" | mkAdv "ลดลง" | mkAdv "พร่อง" | mkAdv "หย่อน" | mkAdv "เตี้ย" | mkAdv "ความเลว" | mkAdv "ค่าต่ํา" | mkAdv "หดหู่ใจ" | mkAdv "หยาบช้า" | mkAdv "อ่อนแรง" | mkAdv "ต่ําต้อย" | mkAdv "ราคาต่ํา" | mkAdv "เสียงเบา" | mkAdv "อ่อนเพลีย" | mkAdv "เกียร์แรก" | mkAdv "เสียงต่ํา" | mkAdv "เสียงแผ่ว" | mkAdv "เกียร์ต่ํา" | mkAdv "ไม่มีเหลือ" | mkAdv "ในราคาที่ต่ํา" ; -- src=panlex
lin underlying_A = mkA "จําเป็น" | mkA "แฝงอยู่" | mkA "เป็นรากฐาน" | mkA "อยู่ข้างใต้" | mkA "อยู่ชั้นใต้" | mkA "มีบุริมสิทธิ์" | mkA "ที่สําคัญและซ่อนอยู่" | mkA "ที่อยู่ในตําแหน่งต่ํากว่า" ; -- src=panlex
lin heaven_N = mkN "สวรรค์" | mkN "เมืองฟ้า" | mkN "แดนสวรรค์" | mkN "สรวงสวรรค์" | mkN "แดนสุขาวดี" | mkN "เมืองสวรรค์" | mkN "สรวง" | mkN "สวรรค์" | mkN "ท้องฟ้า" | mkN "พระเจ้า" | mkN "เมืองบน" | mkN "สรวงสวรรค์" | mkN "อํานาจสวรรค์" ; -- src=panlex
lin nerve_N = mkN "ประสาท" | mkN "ความกล้า" | mkN "เส้นประสาท" | mkN "ความกล้าหาญ" | mkN "กําลัง" | mkN "เส้นใบ" | mkN "พลังงาน" | mkN "ลายเส้น" | mkN "ความกล้า" | mkN "ความทะลึ่ง" | mkN "เส้นประสาท" | mkN "ความกล้าหาญ" | mkN "ให้กําลังใจ" | mkN "ความหงุดหงิด" | mkN "ความหนักแน่น" ; -- src=panlex
lin park_V2 = mkV2 "จอด" ; ---- | mkV "เข้าจอด" | mkV "จอดรถ" ; -- src=panlex
lin park_V = mkV "จอด" | mkV "เข้าจอด" | mkV "จอดรถ" ; -- src=panlex
lin collapse_V2 = mkV2 "หุบ" ; ---- | mkV "ถล่ม" | mkV "ทรุด" | mkV "ทลาย" | mkV "ยุบตัว" | mkV "พังทลาย" | mkV "หมดสภาพ" | mkV "ทำให้แตก" | mkV "ทำให้ระเบิด" | mkV "ทนทุกข์จากการไร้ความรู้สึก" | mkV "พับ" | mkV "ทรุด" | mkV "ยุบลง" | mkV "พับได้" | mkV "พังครืน" | mkV "พังทลาย" | mkV "ล้มเจ็บ" | mkV "ล้มเหลว" | mkV "ทําให้ยุบลง" | mkV "หมดแรงล้มลง" | mkV "ทําให้พังครืน" | mkV "ทําให้พังทลาย" ; -- src=panlex
lin collapse_V = mkV "หุบ" | mkV "ถล่ม" | mkV "ทรุด" | mkV "ทลาย" | mkV "ยุบตัว" | mkV "พังทลาย" | mkV "หมดสภาพ" | mkV "ทำให้แตก" | mkV "ทำให้ระเบิด" | mkV "ทนทุกข์จากการไร้ความรู้สึก" | mkV "พับ" | mkV "ทรุด" | mkV "ยุบลง" | mkV "พับได้" | mkV "พังครืน" | mkV "พังทลาย" | mkV "ล้มเจ็บ" | mkV "ล้มเหลว" | mkV "ทําให้ยุบลง" | mkV "หมดแรงล้มลง" | mkV "ทําให้พังครืน" | mkV "ทําให้พังทลาย" ; -- src=panlex
lin win_N = mkN "เงินรางวัล" | mkN "การเป็นผู้ชนะ" | mkN "ชัยชนะ" | mkN "การชนะเลิศ" ; -- src=panlex
lin printer_N = mkN "ช่างพิมพ์" | mkN "ปรินเตอร์" | mkN "ปริ้นเตอร์" | mkN "เครื่องพิมพ์" | mkN "เครื่องปริ้นต์" | mkN "เครื่องพิมพ์คอมพิวเตอร์" | mkN "ผู้พิมพ์" | mkN "ช่างพิมพ์" | mkN "แท่นพิมพ์" | mkN "เครื่องพิมพ์" | mkN "เจ้าของโรงพิมพ์" ; -- src=panlex
lin coalition_N = mkN "สหพันธ์" | mkN "การรวมตัว" | mkN "การประสานกัน" | mkN "รัฐบาลผสม" | mkN "การร่วมกัน" | mkN "รัฐบาลร่วม" | mkN "สัมพันธมิตร" | mkN "การประสานกัน" | mkN "การร่วมมือกัน" | mkN "การรวมเป็นหนึ่งเดียว" ; -- src=panlex
lin button_N = mkN "ปุ่ม" | mkN "กระดุม" | mkN "ปุ่มกด" | mkN "คลิตอริส" | mkN "ปุ่มเปิด-ปิด" | mkN "กระดุมเห็ด" | mkN "ปุ่มกระสัน" | mkN "ปุ่มคลิตอริส" | mkN "ช่อ" | mkN "ดุม" | mkN "ปุ่ม" | mkN "กระดุม" | mkN "ลูกดุม" | mkN "สวิตช์" | mkN "หน่อไม้" | mkN "เห็ดตูม" | mkN "หน่ออ่อน" | mkN "ติดกระดุม" | mkN "กระดุมเสื้อ" | mkN "ประสาทที่ดี" | mkN "พนักงานบริการ" | mkN "ปุ่มกระดิ่งไฟฟ้า" ; -- src=panlex
lin pray_V2 = mkV2 "ภาวนา" ; ---- | mkV "ขอร้อง" | mkV "ขอ" | mkV "ภาวนา" | mkV "สวดมนต์" | mkV "อธิษฐาน" ; -- src=panlex
lin pray_V = mkV "ภาวนา" | mkV "ขอร้อง" | mkV "ขอ" | mkV "ภาวนา" | mkV "สวดมนต์" | mkV "อธิษฐาน" ; -- src=panlex
lin ultimate_A = mkA "สูงสุด" | mkA "ที่สุด" | mkA "มากสุด" | mkA "ไกลสุด" | mkA "พื้นฐาน" | mkA "สุดท้าย" | mkA "สูงที่สุด" | mkA "ที่มากที่สุด" | mkA "หลักการขั้นพื้นฐาน" ; -- src=panlex
lin venture_N = mkN "การลงทุนเก็งกำไร" | mkN "ผจญภัย" | mkN "การผจญภัย" | mkN "การเสี่ยง" | mkN "เสี่ยงภัย" | mkN "การเสี่ยงภัย" | mkN "กล้าได้กล้าเสีย" | mkN "กิจการเสี่ยงภัย" | mkN "เรื่องเสี่ยงภัย" | mkN "ธุริกิจเสี่ยงแต่สามารถทํากําไรได้" | mkN "เงินหรือทรัพย์สินที่ลงทุนในธุรกิจ" ; -- src=panlex
lin timber_N = mkN "ป่า" | mkN "ป่าดง" | mkN "พงไพร" | mkN "คานไม้" | mkN "พนาลัย" | mkN "วนาลัย" | mkN "เสาไม้" | mkN "โทนเสียง" | mkN "ป่าดงพงพี" | mkN "ไม้ที่เลื่อยเป็นท่อน" | mkN "ไม้" | mkN "ต้นไม้" | mkN "ป่าไม้" | mkN "ไม้ซุง" | mkN "ท่อนไม้" | mkN "โครงเรือ" | mkN "คุณสมบัติของบุคคล" ; -- src=panlex
lin companion_N = mkN "เพื่อน" | mkN "คนคุ้นเคย" | mkN "ผู้ร่วมทาง" | mkN "เพื่อนร่วมทาง" | mkN "เพื่อนเดินทาง" | mkN "ผู้ร่วมเดินทาง" | mkN "เพื่อน" | mkN "เพื่อนเดินทาง" ; -- src=panlex
lin horror_N = mkN "ความขยะแขยง" | mkN "ความน่ากลัว" | mkN "ความหวาดกลัว" | mkN "ความเลวร้ายมาก" | mkN "ความน่าเบื่อหน่ายที่สุด" ; -- src=panlex
lin gesture_N = mkN "ท่าที" | mkN "ทางท่า" | mkN "ท่าทาง" | mkN "ท่วงท่า" | mkN "การแสดงท่าทาง" | mkN "อิริยาบถ" | mkN "การแสดงท่าทาง" ; -- src=panlex
lin moon_N = mkN (thword "พระ" "จันทร์") | {-pan-} mkN "เดือน" | mkN "จันทรา" | mkN "จันทร์" | mkN "จันทรมาส" | mkN "ดวงเดือน" | mkN "ดวงจันทร์" | mkN "พระจันทร์" | mkN "เดือนทางจันทรคติ" | mkN "สิ่งที่เหมือนดวงจันทร์" | mkN "แข" | mkN "เดือน" | mkN "บุหลัน" | mkN "ดวงจันทร์" | mkN "พระจันทร์" | mkN "แสงจันทร์" | mkN "ดวงจันทร์ของดาวนพเคราะห์" | mkN "สิ่งที่เป็นรูปเสี้ยวพระจันทร์" ; -- src=panlex
lin remark_VS = mmkVS "ติชม" ; ---- | mkV "คอมเม็นต์" | mkV "มีข้อติชม" | mkV "แสดงทัศนะ" | mkV "ออกความเห็น" | mkV "ตั้งข้อสังเกต" | mkV "แสดงความคิดเห็น" | mkV "สังเกต" | mkV "ให้ความเห็น" | mkV "ตั้งข้อสังเกต" | mkV "ให้ข้อคิดเห็น" ; -- src=panlex
lin remark_V = mkV "ติชม" | mkV "คอมเม็นต์" | mkV "มีข้อติชม" | mkV "แสดงทัศนะ" | mkV "ออกความเห็น" | mkV "ตั้งข้อสังเกต" | mkV "แสดงความคิดเห็น" | mkV "สังเกต" | mkV "ให้ความเห็น" | mkV "ตั้งข้อสังเกต" | mkV "ให้ข้อคิดเห็น" ; -- src=panlex
lin clever_A = mkA "ฉลาด" | {-pan-} mkA "ที่ชาญฉลาด" | mkA "เหมาะ" | mkA "ชํานาญ" | mkA "ประณีต" | mkA "ว่องไว" | mkA "น่าพอใจ" | mkA "สร้างสรรค์" | mkA "เฉลียวฉลาด" | mkA "ริเริ่มเก่ง" ; -- src=panlex
lin van_N = mkN "รถตู้" | mkN "นิวเวฟ" | mkN "คาราวาน" | mkN "รถตู้" | mkN "รถแวน" | mkN "กองหน้า" | mkN "รถบรรทุก" | mkN "รถสินค้า" | mkN "ขบวนพาหนะ" | mkN "ขบวนรถยนต์" | mkN "ขบวนนักเดินทาง" | mkN "รถบรรทุกสัมภาระ" | mkN "แนวหน้ามรถบรรทุก" | mkN "กองกําลังส่วนหน้า" | mkN "เกวียนบรรทุกสินค้า" ; -- src=panlex
lin consequently_Adv = variants{} ; -- 
lin raw_A = mkA "ดิบ" | mkA "หยาบ" | mkA "มือใหม่" | mkA "สด" | mkA "ดิบ" | mkA "หยาบ" | mkA "ยังสด" | mkA "ยังแสบ" | mkA "อักเสบ" | mkA "อ่อนหัด" | mkA "เย็นแสบ" | mkA "หนาวเหน็บ" | mkA "ยังไม่คุ้น" | mkA "ยังไม่ได้ฟอก" | mkA "สภาพธรรมชาติ" | mkA "ไร้ประสบการณ์" | mkA "สภาพเปลือยเปล่า" | mkA "ไม่มีประสบการณ์" | mkA "ยังไม่ได้เสริมแต่ง" | mkA "ยังไม่ได้รับการฝึกฝน" | mkA "ยังไม่ได้ผ่านกรรมวิธี" | mkA "ยังไม่ได้ผสมให้เจือจาง" ; -- src=panlex
lin glance_N = mkN "การชำเลือง" | mkN "การชำเลืองมอง" | mkN "การแวบมอง" | mkN "การชําเลือง" | mkN "การเหลือบมอง" ; -- src=panlex
lin broken_A = mkA "หัก" | mkA "ซึ่งตกต่ำ" | mkA "ขาด" | mkA "แตก" | mkA "หยาบ" | mkA "เสีย" | mkA "วิกฤต" | mkA "ขรุขระ" | mkA "แตกหัก" | mkA "ไม่ครบ" | mkA "แตกสลาย" | mkA "ต่ําต้อย" | mkA "ไม่ติดต่อ" | mkA "ไม่ถูกต้อง" | mkA "ไม่สมบูรณ์" | mkA "ไม่สมบูรณ์แบบ" ; -- src=panlex
lin jury_N = mkN "คณะลูกขุน" | mkN "ชั่วคราว" | mkN "คณะลูกขุน" | mkN "คณะตุลาการ" | mkN "คณะกรรมการตัดสินการแข่งขัน" ; -- src=panlex
lin gaze_V = mkV "เพ่ง" | mkV "จ้องมอง" | mkV "เพ่งมอง" ; -- src=panlex
lin burst_V2 = mkV2 "แตก" ; ---- | mkV "โผล่" | mkV "อลเวง" | mkV "ระเบิด" | mkV "ทำให้แตก" | mkV "ทำให้ระเบิด" | mkV "ระเบิดเสียงดัง" | mkV "แตก" | mkV "ปะทุ" | mkV "โพล่ง" | mkV "ระเบิด" ; -- src=panlex
lin burst_V = mkV "แตก" | mkV "โผล่" | mkV "อลเวง" | mkV "ระเบิด" | mkV "ทำให้แตก" | mkV "ทำให้ระเบิด" | mkV "ระเบิดเสียงดัง" | mkV "แตก" | mkV "ปะทุ" | mkV "โพล่ง" | mkV "ระเบิด" ; -- src=panlex
lin charter_N = mkN "ใบอนุญาต" | mkN "สัญญาเช่า" | mkN "กฎบัตร" | mkN "ตราตั้ง" | mkN "ใบอนุญาต" | mkN "สัญญาเช่า" | mkN "ใบทะเบียน" | mkN "รัฐธรรมนูญ" | mkN "สัญญารับเหมา" | mkN "หนังสือสัญญา" | mkN "เอกสารทางการ" | mkN "หนังสืออนุญาต" ; -- src=panlex
lin feministMasc_N = variants{} ; -- 
lin discourse_N = mkN "การเทศนา" | mkN "การอภิปราย" | mkN "สัมพันธสาร" | mkN "การสนทนา" | mkN "การปาฐกถา" | mkN "การกล่าวสุนทรพจน์" | mkN "การบรรยายที่เคร่งเครียด" ; -- src=panlex
lin reflection_N = mkN "การสะท้อน" | mkN "ภาพสะท้อน" | mkN "เงาสะท้อน" | mkN "การแสดงออก" | mkN "การครุ่นคิด" | mkN "การไตร่ตรอง" | mkN "ภาพกระจกเงา" | mkN "การสะท้อนแสง" | mkN "ผลสะท้อน" | mkN "การงอกลับ" | mkN "การตําหนิ" | mkN "การสะท้อน" | mkN "ภาพสะท้อน" | mkN "แสงสะท้อน" | mkN "การกล่าวหา" | mkN "การพับกลับ" | mkN "การครุ่นคิด" | mkN "การส่องกลับ" | mkN "การไตร่ตรอง" | mkN "การสะท้อนกลับ" | mkN "สิ่งที่สะท้อนกลับ" | mkN "ความร้อนสะท้อนกลับ" ; -- src=panlex
lin carbon_N = mkN "คาร์บอน" | mkN "ธาตุคาร์บอน" | mkN "กระดาษก๊อปปี้" | mkN "กระดาษคาร์บอน" | mkN "ก็อปปี้กระดาษคาร์บอน" | mkN "เลขอะตอม 6" | mkN "คาร์บอน" | mkN "ธาตุคาร์บอน" ; -- src=panlex
lin sophisticated_A = mkA "ซึ่งสลับซํบซ้อน" | mkA "ตบตา" | mkA "เจนโลก" | mkA "ซับซ้อน" | mkA "หลอกลวง" | mkA "ช่ําชองโลก" | mkA "ทําให้หลงผิด" | mkA "ซึ่งผ่านโลกมามาก" | mkA "ขาดความไร้เดียงสา" | mkA "ขาดลักษณะธรรมชาติ" | mkA "ซึ่งอ้างเหตุผลผิด ๆ" | mkA "ซึ่งรอบรู้ในทางโลก" | mkA "มีลักษณะของชาวกรุง" | mkA "ซึ่งมีประสบการณ์มาก" ; -- src=panlex
lin ban_N = mkN "แบน" | mkN "ห้าม" | mkN "การห้าม" | mkN "การห้าม" | mkN "คําสั่งห้าม" ; -- src=panlex
lin taxation_N = mkN "ภาษี" | mkN "ภาษีอากร" | mkN "การเก็บภาษีอากร" | mkN "รายได้จากภาษีอากร" | mkN "ภาษี" | mkN "ภาษีอากร" | mkN "เงินภาษี" | mkN "การเก็บภาษี" | mkN "การเสียภาษี" | mkN "รายได้จากภาษี" | mkN "การจัดเก็บภาษี" | mkN "ภาษีที่จัดเก็บ" | mkN "ระบบการจัดเก็บภาษี" ; -- src=panlex
lin prosecution_N = mkN "การฟ้องร้อง" | mkN "การดําเนินคดี" | mkN "การดําเนินถึงที่สุด" | mkN "การดําเนินให้ลุล่วง" | mkN "การดําเนินคดีตามกฎหมาย" ; -- src=panlex
lin softly_Adv = variants{} ; -- 
lin asleep_A = mkA "หลับ" | mkA "จากไป" | mkA "หลับไหล" | mkA "ชา" | mkA "ตาย" | mkA "หลับ" | mkA "เฉื่อย" | mkA "นอนหลับ" | mkA "หยุดนิ่ง" | mkA "ไม่ตื่นตัว" | mkA "ไม่มีความรู้สึกเนื่องจากมีเลือดไปเลี้ยงไม่พอ" ; -- src=panlex
lin aids_N = variants{} ; -- 
lin publicity_N = mkN "การโฆษณา" | mkN "ชื่อเสียง" | mkN "การเผยแพร่" | mkN "การประชาสัมพันธ์" ; -- src=panlex
lin departure_N = mkN "การไป" | mkN "การแปร" | mkN "ตัวแปร" | mkN "สิ้นใจ" | mkN "การจากไป" | mkN "การเสียชีวิต" | mkN "การถึงแก่กรรม" | mkN "การออกเดินทาง" | mkN "ความเบี่ยงเบนมาตรฐาน" | mkN "การตาย" | mkN "ทางออก" | mkN "การจากไป" | mkN "การออกไป" | mkN "การแยกไป" | mkN "การฝ่าฝืน" | mkN "การเบี่ยงเบน" | mkN "การออกเดินทาง" | mkN "การแตกต่างจากปกติ หรือที่คาดไว้" ; -- src=panlex
lin welcome_A = mkA "ซึ่งยินดี" | mkA "ซึ่งเต็มใจ" | mkA "เป็นที่ยอมรับ" | mkA "เป็นที่ชื่นชมยินดี" ; -- src=panlex
lin sharply_Adv = variants{} ; -- 
lin reception_N = mkN "การรับ" | mkN "งานเลี้ยง" | mkN "การรับ" | mkN "การรับรอง" | mkN "การรับไว้" | mkN "งานตอบรับ" | mkN "การต้อนรับ" | mkN "การรับเข้า" | mkN "การรับวิทยุ" ; -- src=panlex
lin cousin_N = mkN "ญาติ" "คน" | {-pan-} mkN "ลูกพี่ลูกน้อง" | mkN "ญาติห่าง ๆ" | mkN "ญาติห่างๆ" | mkN "ลูกพี่ลูกน้อง" ; -- src=panlex
lin relieve_V2 = variants{} ; -- 
lin linguistic_A = mkA "ทางภาษา" | mkA "ทางภาษาศาสตร์" | mkA "เกี่ยวกับภาษา" | mkA "เกี่ยวกับภาษาศาสตร์" ; -- src=panlex
lin vat_N = mkN "กะทะ" | mkN "ตุ่ม" | mkN "หม้อ" | mkN "โอ่ง" | mkN "ถังใหญ่" | mkN "หม้อขนาดใหญ่" | mkN "ภาชนะขนาดใหญ่" | mkN "ถังหรือภาชนะใส่น้ําขนาดใหญ่" ; -- src=panlex
lin forward_A = mkA "ข้างหน้า" | mkA "ซึ่งเคลื่อนไปข้างหน้า" | mkA "ซึ่งเข้าเกียร์เดินหน้า" | mkA "ซึ่งไปข้างหน้า" | mkA "เกี่ยวกับวันข้างหน้า" | mkA "เกี่ยวกับอนาคตข้างหน้า" ; -- src=panlex
lin blue_N = mkN "คราม" | mkN "น้ำเงิน" | mkN "แอมมีทอล" | mkN "ฟ้าสีคราม" | mkN "สีน้ำเงิน" | mkN "ยาแอมมีทอล" | mkN "ชุดสีกรมท่า" | mkN "ท้องฟ้าสีคราม" | mkN "เสื้อผ้าสีฟ้า" | mkN "ผีเสื้อชนิดหนึ่ง" | mkN "หน่วยงานชุดน้ำเงิน" | mkN "แอมโมบาร์บิทอลโซเดียม" | mkN "ยาแอมโมบาร์บิทอลโซเดียม" | mkN "สีฟ้า" | mkN "สีน้ําเงิน" ; -- src=panlex
lin multiple_A = mkA "หลาย" | mkA "มากมาย" | mkA "หลายเท่า" | mkA "หลายอย่าง" | mkA "หลายประการ" | mkA "เป็นทวีคูณ" ; -- src=panlex
lin pass_N = mkN "ผ่าน" | mkN "ช่องเขา" | mkN "พาสปอร์ต" | mkN "การส่งบอล" | mkN "การจ่ายบอล" | mkN "การผ่านบอล" | mkN "ความพยายาม" | mkN "หนังสือเดินทาง" | mkN "สถานการณ์ที่ยากลำบาก" | mkN "การทำระยะด้วยการขว้างลูก" | mkN "การโยน" | mkN "การผ่าน" | mkN "ช่องทาง" | mkN "ช่องเขา" | mkN "ช่องแคบ" | mkN "การพ้นไป" | mkN "การสะบัด" | mkN "ใบอนุญาต" | mkN "การผ่านไป" | mkN "การสอบผ่าน" | mkN "การเหวี่ยง" | mkN "การฉวยโอกาส" | mkN "การเดินผ่าน" | mkN "การสละสิทธิ์" | mkN "การล่วงละเมิด" | mkN "บัตรผ่านบัตรผ่านทางหนังสือเดินทาง" ; -- src=panlex
lin outer_A = mkA "ที่อยู่รอบนอก" | mkA "ที่ห่างไกลจากศูนย์กลาง" ; -- src=panlex
lin vulnerable_A = mkA "เปราะ" | mkA "อ่อนแอ" | mkA "ไม่มั่นคง" | mkA "บาดเจ็บได้" | mkA "ที่มีจุดอ่อน" | mkA "ถูกโจมตีได้ง่าย" | mkA "ถูกตําหนิได้ง่าย" | mkA "ซึ่งบาดเจ็บได้ง่าย" | mkA "ซึ่งติดเชื้อได้ง่าย" | mkA "ซึ่งถูกโจมตีได้ง่าย" | mkA "ซึ่งถูกทําลายได้ง่าย" ; -- src=panlex
lin patient_A = mkA "อดทน" | mkA "ลูกค้า" | mkA "อดกลั้น" | mkA "หักห้ามใจ" ; -- src=panlex
lin evolution_N = mkN "ไฟโลเจนี" | mkN "วิวัฒนาการ" | mkN "การเจริญเติบโต" | mkN "การค่อย ๆ ปรากฎขึ้น" | mkN "วิวัฒนาการ" | mkN "การหมุนเวียน" | mkN "ความก้าวหน้า" | mkN "การเจริญเติบโต" ; -- src=panlex
lin allocate_V2 = mkV2 "จัดสรร" ; ---- | mkV "จัดสรร" | mkV "จัดแบ่ง" | mkV "แบ่งสันปันส่วน" ; -- src=panlex
lin allocate_V = mkV "จัดสรร" | mkV "จัดสรร" | mkV "จัดแบ่ง" | mkV "แบ่งสันปันส่วน" ; -- src=panlex
lin creative_A = mkA "สร้างสรรค์" | mkA "ที่สร้างสรรค์" | mkA "เจ้าความคิด" | mkA "ช่างประดิษฐ์" | mkA "ซึ่งสามารถสร้าง" | mkA "ซึ่งมีความคิดริเริ่ม" | mkA "ซึ่งมีความคิดสร้างสรรค์" | mkA "ซึ่งสร้างหรือประดิษฐ์ขึ้น" | mkA "ซึ่งเกิดจากความคิดสร้างสรรค์" | mkA "เกี่ยวกับการสร้างหรือประดิษฐ์ขึ้น" ; -- src=panlex
lin potentially_Adv = variants{} ; -- 
lin just_A = mkA "ดี" | mkA "แฟร์" | mkA "ยุติธรรม" | mkA "เที่ยงธรรม" | mkA "พอดี" | mkA "จริง ๆ" | mkA "สมควร" | mkA "ชอบธรรม" | mkA "พอเหมาะ" | mkA "เหมาะสม" | mkA "ยุติธรรม" | mkA "เท่านั้น" | mkA "เป็นธรรม" | mkA "เล็กน้อย" | mkA "สมเหตุสมผล" | mkA "เที่ยงธรรม" | mkA "ที่เป็นจริง" | mkA "ถูกต้องแม่นยํา" | mkA "ที่เป็นของจริง" | mkA "ถูกต้องตามกฎหมาย" ; -- src=panlex
lin out_Prep = mkPrep "นอก" | mkPrep "ภายนอก" | mkPrep "ข้างนอก" ; -- src=panlex
lin judicial_A = mkA "เกี่ยวกับกฎหมาย" | mkA "เกี่ยวกับผู้พิพากษา" | mkA "เกี่ยวกับศาลยุติธรรม" | mkA "เกี่ยวกับการพิจารณาคดี" | mkA "ซึ่งเกิดจากพระผู้เป็นเจ้า" | mkA "เกี่ยวกับการตัดสินอรรถคดีตามกฎหมาย" ; -- src=panlex
lin risk_VV = variants{} ; -- 
lin risk_V2 = variants{} ; -- 
lin ideology_N = mkN "คตินิยม" | mkN "ทฤษฎีการเมือง" | mkN "ทฤษฎีทางการเมือง" | mkN "อุดมการณ์" | mkN "มโนคติวิทยา" | mkN "ระบบความนึกคิด" | mkN "ความคิดที่เป็นไปไม่ได้" | mkN "แนวคิดอันเป็นรากฐานของสังคม เศรษฐกิจและการเมือง" ; -- src=panlex
lin smell_VA = mmkVA (thword "มี" "กลิ่น") ; ---- | {-pan-} mkV "ดม" | mkV "เหม็น" | mkV "ดมกลิ่น" | mkV "มีกลิ่น" | mkV "มีเซนส์" | mkV "ส่งกลิ่น" | mkV "โชยกลิ่น" | mkV "ได้กลิ่น" | mkV "สังหรณ์ใจ" | mkV "มีกลิ่นเหม็น" | mkV "มีลางสังหรณ์" | mkV "ดมกลิ่น" | mkV "มีกลิ่น" | mkV "ได้กลิ่น" ; -- src=panlex
lin smell_V2 = mkV2 (thword "มี" "กลิ่น") ; ---- | {-pan-} mkV "ดม" | mkV "เหม็น" | mkV "ดมกลิ่น" | mkV "มีกลิ่น" | mkV "มีเซนส์" | mkV "ส่งกลิ่น" | mkV "โชยกลิ่น" | mkV "ได้กลิ่น" | mkV "สังหรณ์ใจ" | mkV "มีกลิ่นเหม็น" | mkV "มีลางสังหรณ์" | mkV "ดมกลิ่น" | mkV "มีกลิ่น" | mkV "ได้กลิ่น" ; -- src=panlex
lin smell_V = mkV (thword "มี" "กลิ่น") | {-pan-} mkV "ดม" | mkV "เหม็น" | mkV "ดมกลิ่น" | mkV "มีกลิ่น" | mkV "มีเซนส์" | mkV "ส่งกลิ่น" | mkV "โชยกลิ่น" | mkV "ได้กลิ่น" | mkV "สังหรณ์ใจ" | mkV "มีกลิ่นเหม็น" | mkV "มีลางสังหรณ์" | mkV "ดมกลิ่น" | mkV "มีกลิ่น" | mkV "ได้กลิ่น" ; -- src=panlex
lin agenda_N = mkN "กำหนดการ" | mkN "ระเบียบวาระการประชุม" | mkN "กําหนดการ" | mkN "ระเบียบวาระ" | mkN "ระเบียบวาระการประชุม" | mkN "หนังสือบันทึกเรื่องราว" ; -- src=panlex
lin transport_V2 = variants{} ; -- 
lin illegal_A = mkA "ผิดกฎหมาย" | mkA "ผิดกฎ" | mkA "ผิดกติกา" | mkA "นอกกฎหมาย" | mkA "ผิดกฎหมาย" ; -- src=panlex
lin chicken_N = mkN "ไก่" | mkN "กุ๊กไก่" | mkN "เนื้อไก่" | mkN "คนขี้ขลาด" | mkN "ไก่เลี้ยง" | mkN "การแข่งขันเสี่ยงตาย" | mkN "การแข่งขันท้าความตาย" | mkN "ไก่" | mkN "เด็ก" | mkN "ลูกนก" | mkN "ลูกไก่" | mkN "ลูกเป็ด" | mkN "เนื้อนก" | mkN "เนื้อไก่" | mkN "คนที่ขี้ขลาด" | mkN "ผู้ที่อายุน้อย" | mkN "ผู้ที่ด้อยประสบการณ์" ; -- src=panlex
lin plain_A = mkA "เรียบๆ" | mkA "ที่ไม่มีลาย" | mkA "ที่ดูเรียบง่าย" | mkA "ซึ่งไม่มีลวดลาย" | mkA "ที่ไม่ประดับประดา" | mkA "เป็นที่ประจักษ์ชัด" | mkA "ที่ไม่มีสิ่งอื่นผสม" | mkA "จืด" | mkA "ตรง" | mkA "ง่าย" | mkA "ซื่อ" | mkA "ปกติ" | mkA "ง่าย ๆ" | mkA "ง่ายๆ" | mkA "พื้นๆ" | mkA "เรียบ" | mkA "เปล่า ๆ" | mkA "จริงใจ" | mkA "ที่ราบ" | mkA "ธรรมดา" | mkA "เปลือย" | mkA "เรียบๆ" | mkA "แน่ชัด" | mkA "ไม่รวย" | mkA "ไม่สวย" | mkA "กระจ่าง" | mkA "ชัดแจ้ง" | mkA "เปิดเผย" | mkA "ราบเรียบ" | mkA "ซื่อสัตย์" | mkA "ทุ่งกว้าง" | mkA "บริสุทธิ์" | mkA "เรียบง่าย" | mkA "ตรงไปตรงมา" | mkA "เข้าใจง่าย" | mkA "ไม่มีอะไรขัด" | mkA "ซึ่งเห็นได้ชัด" | mkA "ซึ่งไม่ซับซ้อน" | mkA "ซึ่งไม่ผสมปนเป" | mkA "ที่เป็นน้ําเปล่า" | mkA "ซึ่งไม่มีการปรุงแต่ง" ; -- src=panlex
lin innovation_N = mkN "การคิด" | mkN "นวัตกรรม" | mkN "การก่อตั้ง" | mkN "การเริ่มต้น" | mkN "นวัตกรรม" | mkN "สิ่งใหม่" | mkN "่นวัตกรรม" | mkN "วิธีการใหม่" | mkN "การปรับปรุงใหม่" | mkN "การสร้างสรรค์สิ่งใหม่ๆ" | mkN "การนําสิ่งใหม่หรือวิธีการใหม่เข้ามา" ; -- src=panlex
lin opera_N = mkN "อุปรากร" | mkN "โอเปร่า" | mkN "โรงอุปรากร" | mkN "โรงโอเปร่า" | mkN "โอเปร่าเฮาส์" | mkN "โรงละครโอเปร่า" | mkN "อุปรากร" | mkN "โอเปร่า" | mkN "ละครดนตรี" | mkN "ละครดนตรี’" ; -- src=panlex
lin lock_N = mkN "ลอน" | mkN "ปอยผม" | mkN "ตัวล็อก" | mkN "ที่ล็อก" | mkN "ท่าล็อก" | mkN "ประตูน้ำ" | mkN "ท่าจับล็อก" | mkN "ล็อค" | mkN "สลัก" | mkN "กุญแจ" | mkN "ปอยผม" | mkN "กระจุกผม" | mkN "ประตูน้ํา" | mkN "ปอยขนสัตว์" | mkN "การควบคุมทั้งหมด" | mkN "ท่าการจับแบบกีฬามวยปล้ํา" ; -- src=panlex
lin grin_V = mkV "ยิ้มแฉ่ง" | mkV "ยิ้มยิงฟัน" | mkV "ดักสัตว์" | mkV "ยิงฟันยิ้ม" | mkV "ยิ้มยิงฟัน" ; -- src=panlex
lin shelf_N = mkN "ชั้น" | mkN "ชั้นวางของ" | mkN "ชั้น" | mkN "หิ้ง" | mkN "โครง" | mkN "สันดอน" | mkN "โขดหิน" | mkN "ชั้นวางหนังสือ" | mkN "ปริมาณความจุของหิ้ง" | mkN "สิ่งของที่วางบนหิ้ง" | mkN "หินใต้น้ําที่ยื่นออก" ; -- src=panlex
lin pole_N = mkN "รอด" | mkN "เสา" | mkN "โพล" | mkN "ขั้ว" | mkN "เพิร์ช" | mkN "ขั้วโลก" | mkN "ขั้วแม่เหล็ก" | mkN "คาน" | mkN "เสา" | mkN "หลัก" | mkN "ไม้คาน" | mkN "ไม้ถ่อ" | mkN "ขั้วโลก" | mkN "ขั้วไฟฟ้า" | mkN "ไม้ค้ําถ่อ" | mkN "ขั้วแม่เหล็ก" ; -- src=panlex
lin punishment_N = mkN "โทษ" | mkN "ทัณฑ์" | mkN "การทารุณ" | mkN "การลงโทษ" | mkN "การทําโทษ" | mkN "การทําให้เจ็บปวด" | mkN "การใช้สิ้นเปลือง" ; -- src=panlex
lin strict_A = mkA "กวดขัน" | mkA "รอบคอบ" | mkA "แน่นอน" | mkA "ถูกต้อง" | mkA "สมบูรณ์" | mkA "เข้มงวด" | mkA "แม่นยํา" | mkA "ถ้วนทั่ว" | mkA "เคร่งครัด" | mkA "เที่ยงตรง" ; -- src=panlex
lin wave_V2 = mkV2 "แกว่ง" ; ---- | mkV "กระพือ" | mkV "ม้วนผม" | mkV "โบกมือ" | mkV "ทำผมลอน" | mkV "ดัดเป็นลอน" | mkV "ทำให้เป็นลอน" | mkV "โบกไม้โบกมือ" | mkV "โบกมือ" | mkV "เป็นลอน" | mkV "โบกไปมา" | mkV "เป็นคลื่น" | mkV "ทําให้เป็นลอน" | mkV "ทําให้ขึ้นๆลงๆ" | mkV "ทําให้หยักเป็นลอน" | mkV "โบกเพื่อทักทายหรือส่งสัญญาณ" ; -- src=panlex
lin wave_V = mkV "แกว่ง" | mkV "กระพือ" | mkV "ม้วนผม" | mkV "โบกมือ" | mkV "ทำผมลอน" | mkV "ดัดเป็นลอน" | mkV "ทำให้เป็นลอน" | mkV "โบกไม้โบกมือ" | mkV "โบกมือ" | mkV "เป็นลอน" | mkV "โบกไปมา" | mkV "เป็นคลื่น" | mkV "ทําให้เป็นลอน" | mkV "ทําให้ขึ้นๆลงๆ" | mkV "ทําให้หยักเป็นลอน" | mkV "โบกเพื่อทักทายหรือส่งสัญญาณ" ; -- src=panlex
lin inside_N = mkN "ภายใน" | mkN "ส่วนใน" | mkN "เครื่องใน" | mkN "ลักษณะภายใน" ; -- src=panlex
lin carriage_N = mkN "รถเข็นทารก" | mkN "รถเข็นเด็ก" | mkN "รถไฟโดยสาร" | mkN "รถม้าโดยสาร" | mkN "ลักษณะท่าทาง" | mkN "รถม้า" | mkN "ท่าทาง" | mkN "การขนส่ง" | mkN "ค่าขนส่ง" | mkN "การบริหาร" | mkN "รถเข็นเด็ก" | mkN "รถม้าสี่ล้อ" | mkN "อากัปกิริยา" | mkN "ตู้โดยสารรถไฟ" | mkN "รถไฟตู้โดยสาร" | mkN "ที่ค้ําที่มีล้อ" | mkN "ส่วนที่เคลื่อนได้เพื่อแบกพาอีกส่วนหนึ่ง" ; -- src=panlex
lin fit_A = mkA "พร้อม" | mkA "แข็งแรง" | mkA "ที่สมควร" | mkA "ที่เหมาะสม" | mkA "ที่เหมาะเจาะ" | mkA "ที่มีสุขภาพดี" | mkA "ที่เตรียมพร้อม" ; -- src=panlex
lin conversion_N = mkN "การแลกเงิน" | mkN "การเกิดใหม่" | mkN "การเปลี่ยนแปลง" | mkN "การเปลี่ยนศาสนา" | mkN "การเปลี่ยนสภาวะ" | mkN "การเตะลูกเข้าประตู" | mkN "การเปลี่ยน" | mkN "การเปลี่ยนแปลง" | mkN "การเปลี่ยนศาสนา" | mkN "การแปลงหน่วยวัด" | mkN "สิ่งที่เปลี่ยนแปลง" | mkN "การเปลี่ยนความเชื่อ" | mkN "ภาวะที่ถูกเปลี่ยนแปลง" ; -- src=panlex
lin hurry_V = mkV "รีบ" | mkV "เร่ง" | mkV "ให้ไว" | mkV "ว่องไว" | mkV "เคลื่อนไหวอย่างรวดเร็ว" | mkV "รีบ" | mkV "รีบร้อน" | mkV "รีบเร่ง" | mkV "เร่งรีบ" ; -- src=panlex
lin essay_N = mkN "เรียงความ" | mkN "ความพยายาม" | mkN "บทความ" | mkN "ปกิณกะ" | mkN "ข้อเขียน" | mkN "ความเรียง" | mkN "เรียงความ" | mkN "ความพยายาม" | mkN "ข้อเขียนสั้น ๆ" | mkN "การทําให้สําเร็จ" | mkN "เรียงความร้อยแก้ว" ; -- src=panlex
lin integration_N = mkN "การรวมกัน" | mkN "สหศึกษา" | mkN "การผสมกัน" | mkN "การผสมผสาน" | mkN "การรวมเข้าด้วยกัน" | mkN "การรวมกันเป็นก้อนหรือกลุ่ม" | mkN "การยกเลิกการศึกษาแบบแบ่งแยกผิว" | mkN "การปรับตัวให้เข้ากับสิ่งแวดล้อม" ; -- src=panlex
lin resignation_N = mkN "ใบลาออก" | mkN "การลาออก" | mkN "การยอมจำนน" | mkN "จดหมายลาออก" | mkN "การยอม" | mkN "การสละ" | mkN "ใบลาออก" | mkN "การจํานน" | mkN "การลาออก" | mkN "การยอมจํานน" | mkN "การยอมรับสภาพ" | mkN "การลาออกจากตําแหน่ง" | mkN "การยอมอยู่ใต้อิทธิพล" ; -- src=panlex
lin treasury_N = mkN "เงินคงคลัง" | mkN "คลัง" | mkN "กรมคลัง" | mkN "กองคลัง" | mkN "เงินทุน" | mkN "คลังสมบัติ" | mkN "ท้องพระคลัง" | mkN "ทรัพย์สมบัติ" | mkN "วรรณกรรมมีค่า" | mkN "ที่เก็บทรัพย์สมบัติ" ; -- src=panlex
lin traveller_N = mkN "คนเดินทาง" | mkN "นักเดินทาง" | mkN "ผู้เดินทาง" | mkN "นักทัศนาจร" | mkN "ผู้เดินทาง" | mkN "นักท่องเที่ยว" | mkN "โครงปั้นจั่นที่เคลื่อนไปมาได้" ; -- src=panlex
lin chocolate_N = mkN "โกโก้" | mkN "สีกาแฟ" | mkN "ช็อคโกแลต" | mkN "สีน้ำตาลเข้ม" | mkN "ช็อกโกเลต" | mkN "ช็อกโกแลต" | mkN "สีน้ําตาลเข้ม" ; -- src=panlex
lin assault_N = mkN "การข่มขืน" | mkN "การข่มขืนกระทำชำเรา" | mkN "จู่โจม" | mkN "ทําลาย" | mkN "การโจมตี" | mkN "การข่มขืน" | mkN "การจู่โจม" | mkN "การทําลาย" | mkN "การประชาทัณฑ์" | mkN "การทําร้ายร่างกาย" | mkN "การโจมตีอย่างรุนแรง" ; -- src=panlex
lin schedule_N = mkN "กำหนดการ" | mkN "ตาราง" | mkN "กําหนด" | mkN "รายการ" | mkN "วางแผน" | mkN "แผนการ" | mkN "กําหนดการ" | mkN "ตารางเวลา" | mkN "รายละเอียด" | mkN "เรียงลําดับ" | mkN "กําหนดรายการ" | mkN "หมายกําหนดการ" ; -- src=panlex
lin undoubtedly_Adv = variants{} ; -- 
lin twin_N = mkN "แฝด" | mkN "ฝาแฝด" | mkN "สำเนา" | mkN "คู่แฝด" | mkN "แฝด" | mkN "ฝาแฝด" | mkN "เข้าคู่" | mkN "เปรียบเทียบ" | mkN "ห้องเตียงคู่" | mkN "ความเหมือนกัน" | mkN "ฝาแฝดใดฝาแฝดหนึ่ง" | mkN "สิ่งที่เป็นคู่กัน" ; -- src=panlex
lin format_N = mkN "ฟอร์แมต" | mkN "แบบ" | mkN "รูปแบบ" | mkN "แผนการรวมทั้งหมด" | mkN "การจัดรูปแบบข้อมูล" ; -- src=panlex
lin murder_V2 = variants{} ; -- 
lin sigh_VS = mmkVS "ถอนใจ" ; ---- | mkV "ถอนหายใจ" | mkV "ทอดถอนใจ" | mkV "ถอนหายใจยาว" | mkV "ถอนใจ" | mkV "โหยหา" | mkV "ถอนหายใจ" | mkV "คร่ําครวญ" | mkV "เรียกร้อง" ; -- src=panlex
lin sigh_V2 = mkV2 "ถอนใจ" ; ---- | mkV "ถอนหายใจ" | mkV "ทอดถอนใจ" | mkV "ถอนหายใจยาว" | mkV "ถอนใจ" | mkV "โหยหา" | mkV "ถอนหายใจ" | mkV "คร่ําครวญ" | mkV "เรียกร้อง" ; -- src=panlex
lin sigh_V = mkV "ถอนใจ" | mkV "ถอนหายใจ" | mkV "ทอดถอนใจ" | mkV "ถอนหายใจยาว" | mkV "ถอนใจ" | mkV "โหยหา" | mkV "ถอนหายใจ" | mkV "คร่ําครวญ" | mkV "เรียกร้อง" ; -- src=panlex
lin sellerMasc_N = variants{} ; -- 
lin lease_N = mkN "ของเช่า" | mkN "สัญญาเช่า" | mkN "กำหนดเวลาตามสัญญา" | mkN "สัญญาเช่า" ; -- src=panlex
lin bitter_A = mkA "ขม" | mkA "ที่แสบสัน" | mkA "ขม" | mkA "ขมขื่น" | mkA "ขื่นขม" | mkA "ระทมใจ" | mkA "ชอกช้ํา" | mkA "ตรอมตรม" | mkA "ทุกข์ใจ" | mkA "หนาวจัด" | mkA "หนาวมาก" ; -- src=panlex
lin double_V2 = mkV2 "งอตัว" ; ---- | mkV "ทำซ้ำ" | mkV "ทำตัวงอ" | mkV "เพิ่มขึ้นสองเท่า" | mkV "ทําซ้ํา" | mkV "ทําเป็นสองเท่า" ; -- src=panlex
lin double_V = mkV "งอตัว" | mkV "ทำซ้ำ" | mkV "ทำตัวงอ" | mkV "เพิ่มขึ้นสองเท่า" | mkV "ทําซ้ํา" | mkV "ทําเป็นสองเท่า" ; -- src=panlex
lin ally_N = mkN "พันธมิตร" | mkN "ชาติพันธมิตร" | mkN "ประเทศพันธมิตร" | mkN "สมาชิกในกลุ่ม" | mkN "อวัยวะที่เชื่อมกัน" | mkN "อวัยวะที่สัมพันธ์กัน" | mkN "คนหรือประเทศที่อยู่ในกลุ่มเดียวกัน" ; -- src=panlex
lin stake_N = mkN "เสา" | mkN "หลัก" | mkN "ดอกเบี้ย" | mkN "เงินพนัน" | mkN "ผลประโยชน์" | mkN "ส่วนได้เสีย" | mkN "เงินเดิมพัน" | mkN "เสามัดนักโทษ" | mkN "เงินเล่นการพนัน" | mkN "เสาหลัก" | mkN "เสาเข็ม" | mkN "เงินเดิมพัน" | mkN "ดอกเบี้ยหรือส่วนแบ่งผลประโยชน์" | mkN "การประหารชีวิตแบบผูกติดกับเสาแล้วเผา" ; -- src=panlex
lin processing_N = mkN "การจัดการ" | mkN "การดําเนินการ" | mkN "ช่วงดําเนินการ" ; -- src=panlex
lin informal_A = mkA "ที่ไม่เป็นทางการ" | mkA "กันเอง" | mkA "ไม่เคร่งครัด" | mkA "ไม่เป็นทางการ" | mkA "ซึ่งเป็นกันเอง" | mkA "ไม่มีพิธีรีตอง" | mkA "ซึ่งไม่เป็นทางการ" ; -- src=panlex
lin flexible_A = mkA "ประนีประนอม" | mkA "ซึ่งยืดหยุ่น" | mkA "ที่โค้งงอได้" | mkA "คล่อง" | mkA "งอได้" | mkA "แก้ได้" | mkA "ดิ้นได้" | mkA "ยืดหยุ่น" | mkA "งอได้ง่าย" | mkA "ละมุนละไม" | mkA "ที่ยืดหดได้" | mkA "พลิกแพลงได้" | mkA "ที่โค้งงอได้" | mkA "เปลี่ยนแปลงได้" | mkA "ผ่อนสั้นผ่อนยาว" | mkA "ที่ดัดงอได้โดยไม่แตกหัก" | mkA "ที่ปรับตัวเข้ากับสถานการณ์" ; -- src=panlex
lin cap_N = mkN "หมวก" | {-pan-} mkN "ฝา" | mkN "จุก" | mkN "แก็ป" | mkN "ฝาจุก" | mkN "ส่วนบน" | mkN "ครอบฟัน" | mkN "หมวกเห็ด" | mkN "หมวกแก็ป" | mkN "ขีดสูงสุด" | mkN "ชนวนระเบิด" | mkN "เชื้อระเบิด" | mkN "เพดานสูงสุด" | mkN "มาลา" | mkN "แก๊บ" | mkN "ฝาครอบ" | mkN "อักษรตัวใหญ่" | mkN "หมวกที่มีกระบังหน้า" ; -- src=panlex
lin stable_A = mkA "คงตัว" | mkA "คงรูป" | mkA "คอกวัว" | mkA "มั่นคง" | mkA "อยู่ตัว" | mkA "แน่วแน่" | mkA "คอกสัตว์" | mkA "ไม่เปลี่ยนแปลง" ; -- src=panlex
lin till_Subj = variants{} ; -- 
lin sympathy_N = mkN "ความเห็นใจ" | mkN "ความสงสาร" | mkN "ความเห็นใจ" | mkN "การเข้าข้างกัน" | mkN "ความเห็นอกเห็นใจ" | mkN "" | mkN "ความมีใจเหมือนกัน" | mkN "ความเห็นพ้องต้องกัน" ; -- src=panlex
lin tunnel_N = mkN "โพรง" | mkN "อุโมงค์" | mkN "หลุม" | mkN "อุโมงค์" ; -- src=panlex
lin pen_N = mkN (thword "ปาก" "กา") | {-pan-} mkN "คอก" | mkN "เล้า" | mkN "ปากกา" | mkN "คอกสัตว์" | mkN "ทัณฑสถาน" | mkN "หงส์ตัวเมีย" | mkN "หงส์เพศเมีย" | mkN "คอกสำหรับปล่อยเด็กเล่น" | mkN "คอก" | mkN "อู่" | mkN "เล้า" | mkN "ปากกา" | mkN "ใส่เล้า" | mkN "นักเขียน" | mkN "สถานกักกัน" | mkN "หงส์ตัวเมีย" | mkN "ลีลาการเขียน" | mkN "คอกเลี้ยงเด็ก" | mkN "สํานวนการเขียน" | mkN "เขียนด้วยปากกา" | mkN "บริเวณล้อมรั้วสําหรับเลี้ยงสัตว์" ; -- src=panlex ----?
lin instal_V = mkV "ตั้ง" | mkV "ติดตั้ง" | mkV "แต่งตั้ง" | mkV "เข้ารับตำแหน่ง" ; -- src=panlex
lin suspend_V2 = mkV2 "พักงาน" ; ---- | mkV "รอลงอาญา" | mkV "แขวนห้อย" | mkV "พักราชการ" | mkV "พักงานชั่วคราว" | mkV "ห้อย" | mkV "แขวน" | mkV "เลื่อน" | mkV "งดชั่วคราว" | mkV "พักไว้ก่อน" | mkV "ระงับชั่วคราว" | mkV "ยกเลิกชั่วคราว" ; -- src=panlex
lin suspend_V = mkV "พักงาน" | mkV "รอลงอาญา" | mkV "แขวนห้อย" | mkV "พักราชการ" | mkV "พักงานชั่วคราว" | mkV "ห้อย" | mkV "แขวน" | mkV "เลื่อน" | mkV "งดชั่วคราว" | mkV "พักไว้ก่อน" | mkV "ระงับชั่วคราว" | mkV "ยกเลิกชั่วคราว" ; -- src=panlex
lin blow_N = mkN "โค้ก" | mkN "สโนว์" | mkN "การตกใจ" | mkN "การกระทบ" | mkN "การหายใจ" | mkN "ลมพัดแรง" | mkN "การกระแทก" | mkN "การถอยกลับ" | mkN "การตีเต็มแรง" | mkN "การตี" | mkN "การต่อย" | mkN "การเป่า" ; -- src=panlex
lin wander_V = mkV "คบชู้" | mkV "นอกใจ" | mkV "มีชู้" | mkV "สวมเขา" | mkV "เร่ร่อน" | mkV "ไหลผ่าน" | mkV "เร่่ร่อน" | mkV "ไปเที่ยว" | mkV "คบชู้สู่ชาย" | mkV "ออกนอกเรื่อง" | mkV "ร่อนเร่" | mkV "ขาดสมาธิ" | mkV "เดินเล่น" | mkV "ฝันกลางวัน" | mkV "พูดนอกเรื่อง" | mkV "ออกนอกเส้นทาง" | mkV "ไปในทางที่คดเคี้ยว" | mkV "พูดหรือเขียนไม่ชัดเจน" | mkV "พูดหรือเขียนวกวนนอกเรื่อง" | mkV "เดินทางไปโดยไม่มีจุดหมายที่แน่นอน" ; -- src=panlex
lin notably_Adv = variants{} ; -- 
lin disappoint_V2 = variants{} ; -- 
lin wipe_V2 = mkV2 (thword "เช็ด") ;
lin wipe_V = mkV "ถู" | mkV "ถู" | mkV "ขัด" | mkV "เช็ด" | mkV "เช็ดให้สะอาด" ; -- src=panlex
lin folk_N = mkN "เผ่า" | mkN "ชนเผ่า" | mkN "ตระกูล" | mkN "วงศ์วาน" | mkN "วงศ์ตระกูล" | mkN "เพลงพื้นบ้าน" | mkN "ดนตรีท้องถิ่น" | mkN "ดนตรีพื้นบ้าน" | mkN "เพลงพื้นเมือง" | mkN "ดนตรีประจำถิ่น" | mkN "ดนตรีพื้นเมือง" | mkN "วงศ์วานว่านเครือ" | mkN "กลุ่มชน" | mkN "ชาวบ้าน" | mkN "ประชาชน" | mkN "คนทั่วไป" | mkN "ดนตรีแนวลูกทุ่ง" | mkN "ดนตรีแนวพื้นบ้าน" | mkN "ญาติสมาชิกของครอบครัว" | mkN "ผู้คนที่อยู่ในถิ่นและมีวิถีชีวิตเฉพาะตน" ; -- src=panlex
lin attraction_N = mkN "แรงดึงดูด" | mkN "ความดึงดูด" | mkN "ดารายอดนิยม" | mkN "ความมีเสน่ห์" | mkN "เสน่ห์" | mkN "การดึงดูด" | mkN "แรงดึงดูด" | mkN "การดึงดูดความสนใจ" | mkN "สิ่งหรือบุคคลที่ดึงดูดความสนใจ" ; -- src=panlex
lin disc_N = mkN "แผ่นดิสก์" | mkN "แผ่นเสียง" | mkN "แผ่นกลมแบน" | mkN "แผ่นบันทึกข้อมูล" | mkN "สิ่งของที่มีลักษณะกลมแบน" ; -- src=panlex
lin inspire_V2V = variants{} ; -- 
lin inspire_V2 = variants{} ; -- 
lin machinery_N = mkN "" | mkN "เครื่องกล" | mkN "โครงสร้าง" | mkN "เครื่องจักร" | mkN "กลุ่มเครื่องกล" | mkN "ระบบปฎิบัติงาน" | mkN "ชิ้นส่วนของเครื่องจักร" ; -- src=panlex
lin undergo_V2 = variants{} ; -- 
lin nowhere_Adv = mkAdv "ไม่ว่าที่ไหนก็ตาม" | mkAdv "ไม่มีที่ไหน" | mkAdv "ไม่ปรากฏว่ามีที่ไหน" ; -- src=panlex
lin inspector_N = mkN "ผู้ตรวจสอบ" | mkN "จราจร" | mkN "นายตรวจ" | mkN "สารวัตร" | mkN "ผู้ตรวจสอบ" | mkN "ผู้สังเกตการณ์" ; -- src=panlex
lin wise_A = mkA "ฉลาด" | mkA "รู้" | mkA "ฉลาด" | mkA "ทะนง" | mkA "ทะลึ่ง" | mkA "ท่าทาง" | mkA "รอบรู้" | mkA "รูปแบบ" | mkA "รู้แจ้ง" | mkA "มีสติปัญญา" | mkA "เฉลียวฉลาด" ; -- src=panlex
lin balance_V2 = mkV2 "ทำให้สมดุล" ; ---- | mkV "ตั้งให้สมดุล" | mkV "ตั้งให้บาลานซ์" | mkV "คิดงบดุล" | mkV "ทําให้สมดุล" | mkV "ทําให้เข้าสู่ดุลยภาพ" ; -- src=panlex
lin balance_V = mkV "ทำให้สมดุล" | mkV "ตั้งให้สมดุล" | mkV "ตั้งให้บาลานซ์" | mkV "คิดงบดุล" | mkV "ทําให้สมดุล" | mkV "ทําให้เข้าสู่ดุลยภาพ" ; -- src=panlex
lin purchaser_N = mkN "คนซื้อ" | mkN "ผู้ซื้อ" | mkN "ผู้อุดหนุน" | mkN "ผู้ซื้อ" ; -- src=panlex
lin resort_N = mkN "รีสอร์ท" | mkN "บ้านพักตากอากาศ" | mkN "สถานที่ที่ไปบ่อย" | mkN "การขอความช่วยเหลือ" | mkN "สถานที่พักตากอากาศ" | mkN "สถานที่ที่ไปเป็นประจำ" | mkN "รีสอร์ต" | mkN "การหันไปใช้" | mkN "การหันไปพึ่ง" | mkN "แหล่งพึ่งพิง" | mkN "การหันไปอาศัย" | mkN "สถานที่พักผ่อน" | mkN "สถานที่ที่ไปบ่อย" | mkN "สถานที่พักตากอากาศ" ; -- src=panlex
lin pop_N = mkN "ป๋า" | mkN "พ่อ" | mkN "โซดา" | mkN "เตี่ย" | mkN "คุณพ่อ" | mkN "น้ำขวด" | mkN "ป่ะป๊า" | mkN "ป๊ะป๋า" | mkN "น้ำอัดลม" | mkN "เพลงป๊อป" | mkN "ดนตรีป๊อป" | mkN "เสียงดังป๊อป" | mkN "พ่อ" | mkN "ปืนสั้น" | mkN "ความพยายาม" | mkN "เสียงระเบิด เช่น เสียงฝาขวดระเบิด" | mkN "เสียงดังเปาะ" | mkN "เพลงที่เป็นที่นิยมกัน" ; -- src=panlex
lin organ_N = mkN "อวัยวะ" | mkN "ออร์แกน" | mkN "ออร์แกนไฟฟ้า" | mkN "ออร์แกนเหยียบ" | mkN "อวัยวะ" | mkN "นิตยสาร" | mkN "หีบเพลง" | mkN "องค์การ" | mkN "ออร์แกน" | mkN "หีบเพลงปาก" | mkN "เครื่องมือ" | mkN "กระบอกเสียง" | mkN "หีบเพลงเป่า" | mkN "หนังสือพิมพ์" | mkN "อวัยวะที่สําคัญต่างๆ" ; -- src=panlex
lin ease_V2 = mkV2 "บรรเทา" ; ---- | mkV "ทำตัวตามสบาย" | mkV "ทำให้ง่ายขึ้น" | mkV "บรรเทา" | mkV "ผ่อนคลาย" | mkV "ทําให้ง่าย" | mkV "ทําให้สบาย" | mkV "ทําให้สะดวก" ; -- src=panlex
lin ease_V = mkV "บรรเทา" | mkV "ทำตัวตามสบาย" | mkV "ทำให้ง่ายขึ้น" | mkV "บรรเทา" | mkV "ผ่อนคลาย" | mkV "ทําให้ง่าย" | mkV "ทําให้สบาย" | mkV "ทําให้สะดวก" ; -- src=panlex
lin friendship_N = mkN "มิตรภาพ" | mkN "ความเป็นเพื่อน" | mkN "มิตรภาพ" | mkN "ความเป็นมิตร" | mkN "ความเป็นเพื่อน" | mkN "ความสัมพันธ์อย่างเพื่อน" ; -- src=panlex
lin deficit_N = mkN "การขาดดุล" | mkN "ความขาดแคลน" | mkN "ความบกพร่อง" | mkN "คะแนนตามหลัง" | mkN "การขาดดุล" | mkN "การขาดทุน" | mkN "การขาดแคลน" | mkN "จํานวนที่ขาด" | mkN "ปริมาณที่ขาด" ; -- src=panlex
lin dear_N = mkN "ที่รัก" | mkN "ลูกรัก" | mkN "บุคคลอันเป็นที่รักยิ่ง" | mkN "ที่รัก" | mkN "ทูนหัว" | mkN "ยอดรัก" | mkN "สุดที่รัก" | mkN "ผู้เป็นที่รัก" ; -- src=panlex
lin convey_V2 = variants{} ; -- 
lin reserve_V2 = mkV2 "กัน" ; ---- | mkV "จอง" | mkV "จอง" | mkV "สงวนไว้" | mkV "จอง" | mkV "สํารอง" | mkV "สงวนไว้" ; -- src=panlex
lin reserve_V = mkV "กัน" | mkV "จอง" | mkV "จอง" | mkV "สงวนไว้" | mkV "จอง" | mkV "สํารอง" | mkV "สงวนไว้" ; -- src=panlex
lin planet_N = mkN "ดาว" | {-pan-} mkN "ดาวเคราะห์" | mkN "ดาวพระเคราะห์" | mkN "ดาวเคราะห์ใหญ่" | mkN "ผู้ติดสอยห้อยตาม" | mkN "โลก" | mkN "ดาวเคราะห์" | mkN "ดาวนพเคราะห์" | mkN "ดาวเคราะห์ที่มีสิ่งมีชีวิตอาศัยอยู่" ; -- src=panlex ----?
lin frequent_A = mkA "ที่มาบ่อย" | mkA "ชุก" | mkA "ถี่" | mkA "บ่อย" | mkA "ไม่บ่อย" | mkA "เป็นนิสัย" | mkA "เป็นนิจสิน" | mkA "เป็นประจํา" | mkA "ซึ่งเป็นประจํา" | mkA "ซ้ําแล้วซ้ําเล่า" ; -- src=panlex
lin loose_A = mkA "หลวม" | mkA "ใจง่าย" | mkA "ซึ่งหลบหนี" | mkA "ซึ่งหลุดออก" | mkA "โยก" | mkA "คลอน" | mkA "ว่าง" | mkA "หลวม" | mkA "หลุด" | mkA "ห้อย" | mkA "กว้าง" | mkA "คายปม" | mkA "พล่าม" | mkA "ละเลย" | mkA "หย่อน" | mkA "เสเพล" | mkA "แพศยา" | mkA "กระชับ" | mkA "พูดมาก" | mkA "แก้มัด" | mkA "ไม่คับ" | mkA "ช่างพูด" | mkA "สะเพร่า" | mkA "สําส่อน" | mkA "หละหลวม" | mkA "ไม่สนใจ" | mkA "ไม่แน่น" | mkA "หลุดลุ่ย" | mkA "โคลงเคลง" | mkA "เป็นอิสระ" | mkA "ไม่กระชับ" | mkA "ไม่ถูกผูก" | mkA "ไม่รอบคอบ" | mkA "ไม่แน่นอน" | mkA "ไม่ถูกต้อง" | mkA "ไม่อัดแน่น" | mkA "ไม่มีงานทํา" | mkA "ไม่เที่ยงตรง" | mkA "ไม่ได้แยกไว้" | mkA "ซึ่งระบายท้อง" | mkA "ปล่อยขีปนาวุธ" | mkA "ไม่รวมกันแน่น" | mkA "ไม่เกาะติดกัน" | mkA "ไม่ได้ผูกแน่น" | mkA "มาพร้อมกับเสมหะ" | mkA "ไม่ถูกควบคุมตัว" | mkA "ปล่อยให้เป็นอิสระ" | mkA "ไม่เกาะกันเป็นก้อน" | mkA "ไม่ได้ควบคุมอย่างเข้มงวด" | mkA "ไม่ได้บรรจุในหีบห่อด้วยกัน" | mkA "ไม่ได้จัดระเบียบอย่างจริงจัง" ; -- src=panlex
lin intense_A = mkA "สด" | mkA "เข้ม" | mkA "เข้มข้น" | mkA "รุนแรง" | mkA "แรงจัด" | mkA "หนาแน่น" | mkA "เข้มข้น" | mkA "แรงกล้า" | mkA "เร่าร้อน" | mkA "ถึงขีดสุด" | mkA "เอาจริงเอาใจ" | mkA "เอาจริงเอาจัง" ; -- src=panlex
lin retail_A = mkA "ขายปลีก" | mkA "เกี่ยวกับการขายปลีก" ; -- src=panlex
lin wind_V = mkV "ยก" | mkV "ม้วน" | mkV "ไขลาน" | mkV "ไหลผ่าน" | mkV "ได้กลิ่น" | mkV "ตัดตามแนว" | mkV "จัดพวงหรีด" | mkV "ขด" | mkV "พัน" | mkV "โค้ง" | mkV "คดเคี้ยว" | mkV "ลดเลี้ยว" | mkV "ทําให้ไม่สามารถหายใจเอาอากาศเข้าได้พอ" ; -- src=panlex
lin lost_A = mkA "สาบสูญ" | mkA "ที่พ่ายแพ้" | mkA "หาย" | mkA "แพ้" | mkA "พลาด" | mkA "พินาศ" | mkA "สับสน" | mkA "หายไป" | mkA "ไม่พบ" | mkA "ฉิบหาย" | mkA "สูญหาย" | mkA "หลงทาง" | mkA "อับปาง" | mkA "เสียไป" | mkA "หมกมุ่น" | mkA "หมดหวัง" | mkA "สูญหายไป" | mkA "ถูกทําลาย" | mkA "ไม่สบายใจ" | mkA "ที่พ่ายแพ้" | mkA "ไม่มีคนรู้" | mkA "ที่สิ้นหวัง" | mkA "ไร้ความหวัง" | mkA "ไร้ประโยชน์" | mkA "ที่ถูกทําลาย" | mkA "สูญเสียเปล่า" | mkA "สับสนจนหลงทิศทาง" | mkA "ไม่ได้คงอยู่ต่อไป" | mkA "ไม่ได้ครอบครองต่อไป" ; -- src=panlex
lin grain_N = mkN "ธัญพืช" | mkN "ลายเนื้อวัสดุ" | mkN "เมล็ดธัญญาพืช" | mkN "เมล็ด" | mkN "ธัญพืช" | mkN "เนื้อไม้" | mkN "เมล็ดพืช" | mkN "เม็ดข้าว" | mkN "เมล็ดข้าว" | mkN "เม็ดเล็กๆ" | mkN "เมล็ดเล็ก ๆ" | mkN "ลายเนื้อไม้" | mkN "พืชประเภทข้าว" | mkN "หน่วยมาตราชั่ง" | mkN "เมล็ดพืชที่ใช้เป็นอาหาร" | mkN "หน่วยน้ําหนักที่เล็กที่สุด" ; -- src=panlex
lin particle_N = mkN "อะตอม" | mkN "อนุภาค" | mkN "โมเลกุล" | mkN "อณู" | mkN "ธุลี" | mkN "ผลคุลี" | mkN "อนุภาค" | mkN "คําศัพท์เล็กน้อย" | mkN "ส่วนที่น้อยที่สุด" | mkN "ส่วนที่เล็กที่สุด" | mkN "ปริมาณที่น้อยที่สุด" ; -- src=panlex
lin destruction_N = mkN "การทำลาย" | mkN "การรื้อถอน" | mkN "จุดสุดท้าย" | mkN "การทำลายล้าง" | mkN "การทำให้พังพินาศ" | mkN "การทําลาย" | mkN "วิธีทําลาย" | mkN "ภาวะที่ถูกทําลาย" | mkN "" | mkN "สาเหตุของการทําลาย" ; -- src=panlex
lin witness_V2 = mkV2 "รับรู้" ; ---- | mkV "เป็นพยาน" | mkV "รู้เห็น" | mkV "ลงนามเป็นพยาน" | mkV "เป็นสักขีพยาน" | mkV "ลงชื่อเป็นพยาน" ; -- src=panlex
lin witness_V = mkV "รับรู้" | mkV "เป็นพยาน" | mkV "รู้เห็น" | mkV "ลงนามเป็นพยาน" | mkV "เป็นสักขีพยาน" | mkV "ลงชื่อเป็นพยาน" ; -- src=panlex
lin pit_N = mkN "นรก" | mkN "พิต" | mkN "ร่อง" | mkN "หลุม" | mkN "เม็ด" | mkN "แอ่ง" | mkN "ขุมนรก" | mkN "สังเวียน" | mkN "หลุมพราง" | mkN "แหล่งตัดหิน" | mkN "ผนังผลชั้นใน" | mkN "เหมืองถ่านหิน" | mkN "หลุมวงดุริยางค์" | mkN "หลุมสำหรับวงออร์เคสตร้า" | mkN "รู" | mkN "นรก" | mkN "บ่อ" | mkN "ปลัก" | mkN "หลุม" | mkN "ถังดัก" | mkN "บ่อแร่" | mkN "รอยโบ๋" | mkN "เหมือง" | mkN "บ่อแร่ หรือถ่านหิน" | mkN "ขุดหลุม" | mkN "รอบโหว่" | mkN "รอยโหว่" | mkN "หลุมพราง" | mkN "ฝังในหลุม" | mkN "เล้าสัตว์" | mkN "หลุมดักสัตว์" | mkN "เก็บไว้ในหลุม" | mkN "อุโมงค์ในเหมือง" | mkN "เมล็ดในของผลไม้" | mkN "ที่นั่งตอนหลังๆ ชั้นล่างในโรงภาพยนตร์" | mkN "ปล่อยไก่ให้ชนกัน" | mkN "อุโมงค์เก็บพืชผล" | mkN "สังเวียนไก่หรือสัตว์" | mkN "ทําให้เป็นหลุมเป็นบ่อ" | mkN "สังเวียนชนไก่หรือสัตว์" | mkN "บริเวณหยุดเติมน้ํามันหรือเปลี่ยนยางสําหรับรถแข่งในสนามแข่ง" ; -- src=panlex
lin registration_N = mkN "การลงทะเบียน" | mkN "การสมัครเรียน" | mkN "กลุ่มผู้ลงทะเบียน" | mkN "การจดทะเบียน" | mkN "การลงทะเบียน" | mkN "สมุดจดทะเบียน" | mkN "การขึ้นทะเบียน" | mkN "วิธีการพิมพ์สอดสีให้เข้ากัน" ; -- src=panlex
lin conception_N = mkN "การคิด" | mkN "มโนภาพ" | mkN "แนวคิด" | mkN "คอนเซปต์" | mkN "มโนทัศน์" | mkN "การเริ่มต้น" | mkN "การตั้งครรภ์" | mkN "การคิด" | mkN "แบบแผน" | mkN "ความคิด" | mkN "โครงการ" | mkN "การเข้าใจ" | mkN "การตั้งต้น" | mkN "การริเริ่ม" | mkN "กรอบความคิด" | mkN "การเริ่มต้น" | mkN "สร้างมโนคติ" | mkN "ภาวะตั้งครรภ์" | mkN "อํานาจความคิด" ; -- src=panlex
lin steady_A = mkA "มั่นคง" | mkA "แน่วแน่" | mkA "มั่นคง" | mkA "แน่นอน" | mkA "แน่วแน่" | mkA "ไม่ลดละ" | mkA "หนักแน่น" | mkA "ต่อเนื่อง" | mkA "สม่ําเสมอ" | mkA "เป็นนิสัย" | mkA "ไม่เปลี่ยนแปลง" | mkA "ซึ่งไม่สั่นคลอน" ; -- src=panlex
lin rival_N = mkN "คู่แข่ง" | mkN "คู่ต่อสู้" | mkN "ผู้ท้าชิง" | mkN "ชิงดี" | mkN "ตีเสมอ" | mkN "คู่ปรับ" | mkN "คู่แข่ง" | mkN "คู่ต่อสู้" | mkN "คู่แข่งขัน" | mkN "เป็นคู่แข่งขัน" | mkN "สิ่งที่พอจะทัดเทียมกันได้" | mkN "ผู้ที่มีความสามารถทัดเทียมกัน" ; -- src=panlex
lin steam_N = mkN "ไอน้ำ" | mkN "อบ" | mkN "ไอ" | mkN "หมอก" | mkN "โกรธ" | mkN "พ่นไอ" | mkN "กําลัง" | mkN "เป็นไอ" | mkN "ไอน้ํา" | mkN "พลังงาน" | mkN "ทําไอน้ํา" | mkN "ใช้ไอน้ํา" | mkN "เกี่ยวกับไอน้ํา" | mkN "เคลื่อนที่ด้วยพลังไอน้ํา" ; -- src=panlex
lin back_A = mkA "หลัง" | mkA "ข้างหลัง" | mkA "ค้างจ่าย" | mkA "ค้างชําระ" | mkA "ซึ่งผ่านมาแล้ว" | mkA "ซึ่งอยู่ด้านหลัง" ; -- src=panlex
lin chancellor_N = mkN "นายก" | mkN "อธิการบดี" | mkN "นายกรัฐมนตรี" | mkN "หัวหน้ารัฐบาล" | mkN "เสนาบดี" | mkN "ตุลาการใหญ่" | mkN "นายกรัฐมนตรี" | mkN "เอกอัครราชทูต" | mkN "อัครมหาเสนาบดี" ; -- src=panlex
lin crash_V = mkV "ชน" | mkV "ตก" | mkV "นอน" | mkV "เจ๊ง" | mkV "ชนโครม" | mkV "ดิ่งลง" | mkV "พุ่งชน" | mkV "นอนหลับ" | mkV "ยึดครอง" | mkV "เขวี้ยง" | mkV "ตกกระแทก" | mkV "เข้าแบบไม่ได้่รับเชิญ" | mkV "เข้ามาโดยไม่ได้รับเชิญ" | mkV "ล้มละลาย" | mkV "ชนอย่างแรง" | mkV "เกิดเสียงดัง" | mkV "ตกอย่างรวดเร็ว" | mkV "ทําให้เกิดเสียงดัง" | mkV "เสื่อมอย่างรวดเร็ว" | mkV "เคลื่อนที่อย่างเสียงดัง" | mkV "ทําให้เคลื่อนที่อย่างเสียงดัง" ; -- src=panlex
lin belt_N = mkN "การทุบ" | mkN "การฟาด" | mkN "สายคาด" | mkN "สายพาน" | mkN "เข็มขัด" | mkN "การทุบตี" | mkN "สายกระสุน" | mkN "รัดพระองค์" | mkN "การชนอย่างแรง" | mkN "บริเวณที่ยื่นออกไป" | mkN "สายพาน" | mkN "เข็มขัด" | mkN "สายคาดเอว" | mkN "สายรัดที่นั่ง" | mkN "สายคาดแสดงตําแหน่ง" ; -- src=panlex
lin logic_N = mkN "ตรรกะ" | mkN "ลอจิก" | mkN "ตรรกวิทยา" | mkN "ระบบตรรกะ" | mkN "วิชาลอจิก" | mkN "ตรรกศาสตร์" | mkN "ตรรก" | mkN "เหตุผล" | mkN "ตรรกวิทยา" | mkN "ตรรกศาสตร์" | mkN "ระบบการใช้เหตุผล" | mkN "การตัดสินด้วยเหตุผล" | mkN "การอนุมานด้วยเหตุผล" ; -- src=panlex
lin premium_N = mkN "ค่าหัว" | mkN "เงินค่าหัว" | mkN "เงินประกัน" | mkN "ส่วนเกินมูลค่า" | mkN "ค่าธรรมเนียมแลกเปลี่ยนเงินตราต่างประเทศ" | mkN "รางวัล" | mkN "เงินแถม" | mkN "ค่าบริการ" | mkN "เงินพิเศษ" | mkN "เงินรางวัล" | mkN "เบี้ยประกัน" | mkN "เบี้ยประกันภัย" | mkN "ค่าบริการเพิ่มเติม" | mkN "ค่าธรรมเนียมนายหน้า" ; -- src=panlex
lin confront_V2 = variants{} ; -- 
lin precede_V2 = variants{} ; -- 
lin experimental_A = mkA "เกี่ยวกับประสบการณ์" | mkA "เกี่ยวกับการทดลองทางวิทยาศาสตร์" ; -- src=panlex
lin alarm_N = mkN "ระบบเตือนภัย" | mkN "ความตระหนกตกใจ" | mkN "ความตื่นตระหนก" | mkN "สัญญาณเตือนภัย" | mkN "ความกลัว" | mkN "เสียงเตือน" | mkN "สัญญาณบอกเหตุ" | mkN "สัญญาณเตือนภัย" | mkN "กระดิ่งของนาฬิกาปลุก" ; -- src=panlex
lin rational_A = mkA "มีเหตุผล" | mkA "ซึ่งมีเหตุผล" | mkA "รู้จักเหตุผล" | mkA "เข้าใจเหตุผล" ; -- src=panlex
lin incentive_N = mkN "โบนัส" | mkN "สิ่งจูงใจ" | mkN "เงินโบนัส" | mkN "สิ่งดลใจ" | mkN "สิ่งเร้า" | mkN "สิ่งกระตุ้น" | mkN "เครื่องกระตุ้น" | mkN "เครื่องส่งเสริม" ; -- src=panlex
lin roughly_Adv = variants{} ; -- 
lin bench_N = mkN "ตัวสำรอง" | mkN "โต๊ะช่าง" | mkN "คณะตุลาการ" | mkN "ม้านั่งยาว" | mkN "เก้าอี้ยาว" | mkN "ผู้เล่นสำรอง" | mkN "คณะผู้พิพากษา" | mkN "โต๊ะทำงานของช่าง" | mkN "บังลังก์ผู้พิพากษา" | mkN "ม้านั่ง" | mkN "กระดานนั่ง" | mkN "ผู้พิพากษา" | mkN "โต๊ะทํางาน" | mkN "แนวหินที่นูนขึ้น" | mkN "บัลลังก์ของตุลาการ" | mkN "ที่นั่งสําหรับนักกีฬาตัวสํารอง" | mkN "แท่นที่ให้สัตว์ยืนเพื่อทําการแสดง" | mkN "ยกพื้นที่ให้สัตว์ยืนเพื่อทําการแสดง" ; -- src=panlex
lin wrap_V2 = mkV2 "ห่อ" ; ---- | mkV "ม้วน" | mkV "ห่อหุ้ม" | mkV "ห่อ" | mkV "คลุม" | mkV "พันรอบ" | mkV "มัดรอบ" | mkV "โอบรอบ" ; -- src=panlex
lin wrap_V = mkV "ห่อ" | mkV "ม้วน" | mkV "ห่อหุ้ม" | mkV "ห่อ" | mkV "คลุม" | mkV "พันรอบ" | mkV "มัดรอบ" | mkV "โอบรอบ" ; -- src=panlex
lin regarding_Prep = mkPrep "ในเรื่อง" | mkPrep "เกี่ยวกับ" ; -- src=panlex
lin inadequate_A = mkA "ที่ไม่เพียงพอ" | mkA "ซึ่งไม่เพียงพอ" | mkA "ไม่ดีพอ" | mkA "ไม่พอเพียง" | mkA "ไม่เพียงพอ" ; -- src=panlex
lin ambition_N = mkN "ความใฝ่ฝัน" | mkN "ความทะเยอทะยาน" | mkN "เป้าหมาย" | mkN "จุดมุ่งหมาย" | mkN "ความทะเยอทะยาน" | mkN "ความมักใหญ่ใฝ่สูง" | mkN "ความปรารถนาอันแรงกล้า" ; -- src=panlex
lin since_Adv = mkAdv "จากนั้นมา" | mkAdv "เมื่อก่อน" | mkAdv "ตั้งแต่นั้นมา" | mkAdv "เมื่อหลายปีมาแล้ว" ; -- src=panlex
lin fate_N = mkN "โชคชะตา" | mkN "ชะตากรรม" | mkN "พรหมลิขิต" | mkN "เทพีแห่งโชคชะตา" | mkN "ชะตา" | mkN "ผลลัพธ์" | mkN "โชคชะตา" | mkN "ชะตากรรม" | mkN "ผลสุดท้าย" | mkN "พรหมลิขิต" ; -- src=panlex
lin vendor_N = mkN "คนขาย" | mkN "ผู้ขาย" | mkN "คนขายของ" | mkN "ผู้ขาย" | mkN "คนขายของ" | mkN "ผู้จําหน่าย" ; -- src=panlex
lin stranger_N = mkN "คนต่างถิ่น" | mkN "คนแปลกหน้า" | mkN "คนต่างเมือง" | mkN "แขก" | mkN "ผู้มาใหม่" | mkN "คนต่างถิ่น" | mkN "คนแปลกหน้า" | mkN "คนที่มาใหม่" | mkN "คนไม่รู้จัก" | mkN "แขกแปลกหน้า" | mkN "" | mkN "คนที่เพิ่งมาเป็นครั้งแรก" ; -- src=panlex
lin spiritual_A = mkA "ทางศาสนา" | mkA "ที่เหมือนผี" | mkA "ทางจิตวิญญาณ" | mkA "เกี่ยวกับใจ" | mkA "เกี่ยวกับจิตใจ" | mkA "เกี่ยวกับศาสนา" | mkA "เกี่ยวกับวิญญาณ" | mkA "เกี่ยวกับอารมณ์" | mkA "เกี่ยวกับจิตวิญญาณ" | mkA "เกี่ยวกับความรู้สึก" | mkA "เกี่ยวกับภูติผีปีศาจ" | mkA "เกี่ยวกับสิ่งศักดิ์สิทธิ์" ; -- src=panlex
lin increasing_A = mkA "ซึ่งเพิ่มขึ้น" ; -- src=panlex
lin anticipate_VV = mkVV "ทาย" ; ---- | mkV "กังวล" | mkV "ทำนาย" | mkV "คาดหวัง" | mkV "ดักหน้า" | mkV "ตัดหน้า" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "รู้ล่วงหน้า" | mkV "คอย" | mkV "คะเน" | mkV "คอยท่า" | mkV "ทํานาย" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "เตรียมป้องกันล่วงหน้า" | mkV "ลงมือกระทําก่อนล่วงหน้า" ; -- src=panlex
lin anticipate_VS = mmkVS "ทาย" ; ---- | mkV "กังวล" | mkV "ทำนาย" | mkV "คาดหวัง" | mkV "ดักหน้า" | mkV "ตัดหน้า" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "รู้ล่วงหน้า" | mkV "คอย" | mkV "คะเน" | mkV "คอยท่า" | mkV "ทํานาย" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "เตรียมป้องกันล่วงหน้า" | mkV "ลงมือกระทําก่อนล่วงหน้า" ; -- src=panlex
lin anticipate_V2 = mkV2 "ทาย" ; ---- | mkV "กังวล" | mkV "ทำนาย" | mkV "คาดหวัง" | mkV "ดักหน้า" | mkV "ตัดหน้า" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "รู้ล่วงหน้า" | mkV "คอย" | mkV "คะเน" | mkV "คอยท่า" | mkV "ทํานาย" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "เตรียมป้องกันล่วงหน้า" | mkV "ลงมือกระทําก่อนล่วงหน้า" ; -- src=panlex
lin anticipate_V = mkV "ทาย" | mkV "กังวล" | mkV "ทำนาย" | mkV "คาดหวัง" | mkV "ดักหน้า" | mkV "ตัดหน้า" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "รู้ล่วงหน้า" | mkV "คอย" | mkV "คะเน" | mkV "คอยท่า" | mkV "ทํานาย" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "เตรียมป้องกันล่วงหน้า" | mkV "ลงมือกระทําก่อนล่วงหน้า" ; -- src=panlex
lin logical_A = mkA "สมควร" | mkA "มีเหตุผล" | mkA "ตามเหตุผล" | mkA "เกี่ยวกับตรรกวิทยา" | mkA "สอดคล้องกับหลักตรรกวิทยา" | mkA "เกี่ยวกับการตัดสินด้วยเหตุผล" ; -- src=panlex
lin fibre_N = mkN "เส้นใย" | mkN "ไฟเบอร์" | mkN "คาแร็กเตอร์" | mkN "ลักษณะสำคัญ" | mkN "เส้นใย" | mkN "ไฟเบอร์" | mkN "ลักษณะที่" | mkN "ลักษณะสําคัญ" | mkN "โครงสร้างพื้นฐาน" | mkN "สิ่งที่เป็นเส้นใย" | mkN "สิ่งที่มีลักษณะเป็นเส้น" ; -- src=panlex
lin attribute_V2 = variants{} ; -- 
lin sense_VS = variants{} ; -- 
lin sense_V2 = variants{} ; -- 
lin black_N = mkN "สีดำ" | mkN "ชุดดำ" | mkN "หมากดำ" | mkN "ความมืด" | mkN "ชุดสีดำ" | mkN "หมากสีดำ" | mkN "ความมืดดำ" | mkN "หมากตัวสีดำ" | mkN "สีดํา" | mkN "คนผิวดํา" ; -- src=panlex
lin petrol_N = mkN "น้ำมัน" | mkN "เบนซิน" | mkN "น้ำมันเบนซิน" | mkN "น้ํามันปิโตร" | mkN "น้ํามันเบนซิน" | mkN "น้ํามันปิโตรเลียม" ; -- src=panlex
lin maker_N = mkN "ช่าง" | mkN "ผู้ผลิต" | mkN "ช่างฝีมือ" | mkN "คนทำงานฝีมือ" | mkN "กวี" | mkN "ผู้ทํา" | mkN "ผู้ผลิต" | mkN "พระเจ้า" | mkN "ผู้สร้าง" | mkN "ผู้ประดิษฐ์" | mkN "ผู้สร้างสรรค์" | mkN "ผู้ออกตัวเงิน" | mkN "ผู้เซ็นชื่อกํากับในตั๋วสัญญาใช้เงิน" ; -- src=panlex
lin generous_A = mkA "ใจดี" | mkA "มากมาย" | mkA "เกินพอ" | mkA "ใจกว้าง" | mkA "มีน้ําใจ" | mkA "ใจนักเลง" | mkA "เหลือเฟือ" | mkA "เอื้อเฟื้อ" | mkA "อุดมสมบูรณ์" | mkA "ใจดีมีเมตตา" | mkA "ไม่เห็นแก่ตัว" ; -- src=panlex
lin allocation_N = mkN "การแบ่งส่วน" | mkN "การบรรจุ" | mkN "ส่วนแบ่ง" | mkN "การจัดสรร" | mkN "การลงบัญชี" | mkN "การแบ่งสรร" | mkN "การแบ่งส่วน" | mkN "การจัดสรรปันส่วน" | mkN "ภาวะที่ถูกจัดสรรหรือแบ่งสรร" ; -- src=panlex
lin depression_N = mkN "การกด" | mkN "การกดลง" | mkN "การเคาะ" | mkN "รอยเว้า" | mkN "ภาวะจิตตก" | mkN "พื้นที่ต่ำ" | mkN "ความสลดหดหู่" | mkN "ความเศร้าสลด" | mkN "วิกฤตเศรษฐกิจ" | mkN "เศรษฐกิจตกต่ำ" | mkN "ความกดอากาศต่ำ" | mkN "ภาวะเศรษฐกิจตกต่ำ" | mkN "รอยกด" | mkN "ไซโคลน" | mkN "รอยบุ๋ม" | mkN "ความหดหู่" | mkN "ดีเปรสชั่น" | mkN "รอยเว้าลงไป" | mkN "ความเศร้าสลด" | mkN "การยุบตัวลงไป" | mkN "ความสะเทือนใจ" | mkN "การทําให้ตกต่ํา" | mkN "ความกดอากาศต่ํา" | mkN "ส่วนที่ยุบตัวลง" | mkN "ความกดดันของอากาศต่ํา" | mkN "ความตกต่ําทางเศรษฐกิจ" | mkN "บริเวณความกดอากาศต่ํา" | mkN "ภาวะที่เศรษฐกิจตกต่ํา" | mkN "ที่เป็นแอ่งหลุมหรือเว้า" | mkN "บริเวณที่มีความกดดันของอากาศต่ํา" ; -- src=panlex
lin declaration_N = mkN "ประกาศ" | mkN "การสำแดง" | mkN "คําสั่ง" | mkN "หลักฐาน" | mkN "ประกาศิต" | mkN "การประกาศ" | mkN "การยืนยัน" | mkN "คําประกาศ" | mkN "คํายืนยัน" | mkN "คําให้การ" | mkN "แถลงการณ์" | mkN "การอุทธรณ์" | mkN "คําอุทธรณ์" | mkN "การลงนามเป็นพยาน" ; -- src=panlex
lin spot_VS = mmkVS "จุด" ; ---- | mkV "แต้ม" | mkV "จำได้" | mkV "แต้มจุด" | mkV "สังเกตเห็น" | mkV "เหลือบเห็น" | mkV "ทำให้เป็นรอย" | mkV "พบเห็น" | mkV "ทําให้ด่างพร้อย" | mkV "ทําให้เป็นจุดด่าง" ; -- src=panlex
lin spot_V2 = mkV2 "จุด" ; ---- | mkV "แต้ม" | mkV "จำได้" | mkV "แต้มจุด" | mkV "สังเกตเห็น" | mkV "เหลือบเห็น" | mkV "ทำให้เป็นรอย" | mkV "พบเห็น" | mkV "ทําให้ด่างพร้อย" | mkV "ทําให้เป็นจุดด่าง" ; -- src=panlex
lin spot_V = mkV "จุด" | mkV "แต้ม" | mkV "จำได้" | mkV "แต้มจุด" | mkV "สังเกตเห็น" | mkV "เหลือบเห็น" | mkV "ทำให้เป็นรอย" | mkV "พบเห็น" | mkV "ทําให้ด่างพร้อย" | mkV "ทําให้เป็นจุดด่าง" ; -- src=panlex
lin modest_A = mkA "เล็กๆ" | mkA "ที่มีขนาดเล็ก" | mkA "สุภาพ" | mkA "เรียบ ๆ" | mkA "เรียบๆ" | mkA "ถ่อมตัว" | mkA "ปานกลาง" | mkA "พอประมาณ" | mkA "เรียบง่าย" | mkA "เรียบร้อย" | mkA "ไม่มากมาย" | mkA "ไม่รุนแรง" | mkA "สงบเสงี่ยม" | mkA "ค่อนข้างเล็ก" | mkA "ไม่คุยโม้โอ้อวด" | mkA "ไม่ใหญ่โตโอ่อ่า" ; -- src=panlex
lin bottom_A = mkA "ล่างสุด" | mkA "ชั้นล่าง" | mkA "ต่ําสุด" ; -- src=panlex
lin dividend_N = mkN "ตัวตั้ง" | mkN "เงินปันผล" | mkN "ผลกําไร" | mkN "เงินปันผล" | mkN "ส่วนแบ่งจากผลกําไร" | mkN "จํานวนตั้งที่ถูกหาร" ; -- src=panlex
lin devote_V2 = variants{} ; -- 
lin condemn_V2 = variants{} ; -- 
lin integrate_V2 = mkV2 "คละ" ; ---- | mkV "บูรณาการ" | mkV "อินทิเกรต" | mkV "เปิดรับทุกชาติพันธุ์" | mkV "ผสมผสาน" | mkV "รวมเข้าด้วยกัน" ; -- src=panlex
lin integrate_V = mkV "คละ" | mkV "บูรณาการ" | mkV "อินทิเกรต" | mkV "เปิดรับทุกชาติพันธุ์" | mkV "ผสมผสาน" | mkV "รวมเข้าด้วยกัน" ; -- src=panlex
lin pile_N = mkN "กอง" | mkN "กลุ่ม" | mkN "มากมาย" | mkN "เสาเข็ม" | mkN "จำนวนมาก" | mkN "เงินก้อน" | mkN "ขนชั้นล่าง" | mkN "จำนวนมากมายก่ายกอง" | mkN "ขน" | mkN "กอง" | mkN "กลุ่ม" | mkN "ขนพรม" | mkN "กองไม้" | mkN "ขนนิ่ม" | mkN "เสาปัก" | mkN "ขนสัตว์" | mkN "เสาเข็ม" | mkN "จํานวนมาก" | mkN "ปริมาณมาก" | mkN "หม้อไฟฟ้า" | mkN "ตอม่อสะพาน" | mkN "ขนกํามะหยี่" | mkN "ริดสีดวงทวาร" | mkN "เงินจํานวนมาก" | mkN "หม้อแบตเตอรี่แห้ง" | mkN "กลุ่มหรือสิ่งปลูกสร้างที่สูงใหญ่" | mkN "กองเหล็กสําหรับหลอมเครื่องปฏิกรณ์ปรมาณู" ; -- src=panlex
lin identification_N = mkN "การระบุ" | mkN "การชี้ตัว" | mkN "การแสดงตัว" | mkN "การหาเอกลักษณ์" ; -- src=panlex
lin acute_A = mkA "แหลม" | mkA "เฉียบพลัน" | mkA "ที่มีปลายแหลม" | mkA "ที่มีปลายเหมือนเข็ม" | mkA "คม" | mkA "ไว" | mkA "ฉลาด" | mkA "หนัก" | mkA "แหลม" | mkA "สาหัส" | mkA "รุนแรง" | mkA "เหี้ยม" | mkA "ฉับพลัน" | mkA "ร้ายแรง" | mkA "เข้มข้น" | mkA "ตาคมกริบ" | mkA "อย่างแรง" | mkA "เฉียบพลัน" | mkA "เฉียบแหลม" | mkA "มีมุมนแหลม" | mkA "มีไหวพริบดี" | mkA "ที่มีปลายแหลม" ; -- src=panlex
lin barely_Adv = mkAdv "แทบจะไม่" | mkAdv "อย่างไม่เพียงพอ" | mkAdv "น้อยมาก" | mkAdv "เรียบง่าย" | mkAdv "ไม่ตกแต่ง" | mkAdv "เกือบไม่พอ" ; -- src=panlex
lin providing_Subj = variants{} ; -- 
lin directive_N = mkN "คำสั่งอย่างเป็นทางการ" | mkN "คําสั่ง" | mkN "คําบัญชา" ; -- src=panlex
lin bet_VS = mmkVS "พนัน" ; ---- | mkV "พึ่งพา" | mkV "ท้าพนัน" | mkV "วางเดิมพัน" | mkV "พนัน" | mkV "พนันกับ" | mkV "เดิมพัน" ; -- src=panlex
lin bet_V2 = mkV2 "พนัน" ; ---- | mkV "พึ่งพา" | mkV "ท้าพนัน" | mkV "วางเดิมพัน" | mkV "พนัน" | mkV "พนันกับ" | mkV "เดิมพัน" ; -- src=panlex
lin bet_V = mkV "พนัน" | mkV "พึ่งพา" | mkV "ท้าพนัน" | mkV "วางเดิมพัน" | mkV "พนัน" | mkV "พนันกับ" | mkV "เดิมพัน" ; -- src=panlex
lin modify_V2 = variants{} ; -- 
lin bare_A = mkA "นู้ด" | mkA "เปล่า" | mkA "เปลือย" | mkA "ล่อนจ้อน" | mkA "เปลือยกาย" | mkA "ซึ่งแก้ผ้า" | mkA "นุ่งลมห่มฟ้า" | mkA "ซึ่งโชวเนื้อหนัง" | mkA "ที่ไม่ประดับประดา" | mkA "แท้ ๆ" | mkA "เปล่า" | mkA "โกร๋น" | mkA "เกรียน" | mkA "เปลือย" | mkA "น้อยมาก" | mkA "เปิดออก" | mkA "เปิดเผย" | mkA "ไม่มีใบ" | mkA "นิดเดียว" | mkA "หวุดหวิด" | mkA "แทบจะไม่พอ" | mkA "เปลือยเปล่า" | mkA "เกือบจะไม่รอด" | mkA "ไม่มีเสื้อผ้า" | mkA "ไร้สิ่งตกแต่ง" | mkA "เอาสิ่งคลุมออก" | mkA "ไม่มีสิ่งยืนยัน" | mkA "ไม่มีเครื่องหุ้มห่อ" ; -- src=panlex
lin swear_VV = mkVV "สบถ" ; ---- | mkV "วางใจ" | mkV "สาบาน" | mkV "ไว้ใจ" | mkV "มั่นใจ" | mkV "ยืนยัน" | mkV "สบถ" | mkV "สัญญา" | mkV "สาบาน" | mkV "ก่นด่า" | mkV "ปฏิญาณ" | mkV "ยืนยัน" | mkV "สาบแช่ง" ; -- src=panlex
lin swear_V2 = mkV2 "สบถ" ; ---- | mkV "วางใจ" | mkV "สาบาน" | mkV "ไว้ใจ" | mkV "มั่นใจ" | mkV "ยืนยัน" | mkV "สบถ" | mkV "สัญญา" | mkV "สาบาน" | mkV "ก่นด่า" | mkV "ปฏิญาณ" | mkV "ยืนยัน" | mkV "สาบแช่ง" ; -- src=panlex
lin swear_V = mkV "สบถ" | mkV "วางใจ" | mkV "สาบาน" | mkV "ไว้ใจ" | mkV "มั่นใจ" | mkV "ยืนยัน" | mkV "สบถ" | mkV "สัญญา" | mkV "สาบาน" | mkV "ก่นด่า" | mkV "ปฏิญาณ" | mkV "ยืนยัน" | mkV "สาบแช่ง" ; -- src=panlex
lin final_N = mkN "การสอบไฟนอล" | mkN "การสอบปลายภาค" | mkN "การแข่งขันรอบไฟนอล" | mkN "การแข่งขันนัดสุดท้าย" | mkN "การแข่งขันนัดชิงชนะเลิศ" | mkN "การแข่งขันรอบชิงชนะเลิศ" ; -- src=panlex
lin accordingly_Adv = mkAdv "ฉะนั้น" | mkAdv "ตามที่" | mkAdv "ตามนั้น" | mkAdv "ตาม" | mkAdv "ดังนั้น" | mkAdv "ตามนั้น" | mkAdv "สอดคล้อง" | mkAdv "เช่นนั้น" | mkAdv "อย่างกลมกลืน" | mkAdv "อย่างสอดคล้อง" ; -- src=panlex
lin valid_A = mkA "มีผล" | mkA "มีมูล" | mkA "ใช้ได้" | mkA "ฟังขึ้น" | mkA "แข็งแรง" | mkA "มีเหตุผล" | mkA "มีหลักฐาน" | mkA "มีสุขภาพดี" | mkA "เป็นทางการ" | mkA "ซึ่งมีเหตุผล" | mkA "ชอบด้วยกฎหมาย" | mkA "ให้ผลที่ต้องการ" | mkA "ถูกต้องตามกฎหมาย" | mkA "ซึ่งชอบด้วยกฎหมาย" | mkA "ซึ่งหาเหตุผลสนับสนุนได้" ; -- src=panlex
lin wherever_Adv = mkAdv "ที่ใดๆ" | mkAdv "ที่ไหนก็ได้" | mkAdv "ไม่ว่าที่ไหนก็ตาม" ; -- src=panlex
lin mortality_N = mkN "อัตราการตาย" | mkN "ความตาย" | mkN "อัตราตาย" | mkN "ความหายนะ" | mkN "อัตราการตาย" | mkN "จํานวนผู้ตาย" | mkN "การที่ต้องตาย" | mkN "ภาวะที่ต้องตาย" | mkN "มนุษย์ที่ต้องตาย" | mkN "สิ่งมีชีวิตทั้งหลายที่ต้องตาย" ; -- src=panlex
lin medium_N = mkN "สื่อ" | mkN "คนทรง" | mkN "ตัวกลาง" | mkN "ร่างทรง" | mkN "สายกลาง" | mkN "สื่อกลาง" | mkN "สารตัวกลาง" | mkN "ภาวะตรงกลาง" | mkN "สภาพแวดล้อม" | mkN "สื่อสารมวลชน" | mkN "น้ำที่ใช้ผสมสี" | mkN "อาหารเพาะเชื้อ" | mkN "การสื่อสารมวลชน" | mkN "อาชีพที่เหมาะสม" | mkN "วิธี" | mkN "สื่อ" | mkN "มัชฌิม" | mkN "ตัวกลาง" | mkN "วิธีการ" | mkN "สายกลาง" | mkN "สื่อกลาง" | mkN "สื่อมวลชน" | mkN "จุดกึ่งกลาง" | mkN "สภาพแวดล้อม" | mkN "สิ่งแวดล้อม" | mkN "ที่อยู่สิ่งมีชีวิต" | mkN "ภาวะที่อยู่ตรงกลาง" | mkN "สิ่งที่อยู่ระหว่างกลาง" | mkN "สิ่งที่แสงหรือเสียงผ่านไป" | mkN "ผู้เป็นสื่อกลางระหว่างวิญญาณและมนุษย์" ; -- src=panlex
lin silk_N = mkN "ใยไหม" | mkN "ผ้าไหม" | mkN "ไหม" | mkN "ใยไหม" | mkN "ผ้าแพร" | mkN "ผ้าไหม" | mkN "ด้ายไหม" | mkN "เส้นไหม" | mkN "เสื้อแพร" | mkN "ซังข้าวโพด" | mkN "เสื้อผ้าไหม" | mkN "เกี่ยวกับไหม" | mkN "เสื้อของนักกฎหมาย" ; -- src=panlex
lin funeral_N = mkN "งานศพ" | mkN "พิธีศพ" | mkN "งานบำเพ็ญกุศล" | mkN "งานสวดอภิธรรมศพ" | mkN "งานพระราชทานเพลิงศพ" | mkN "งานศพ" | mkN "การฝังศพ" | mkN "งานฝังศพ" | mkN "พิธีฝังศพ" ; -- src=panlex
lin depending_A = variants{} ; -- 
lin cow_N = mkN "วัว" "ตัว" | {-pan-} mkN "อีเวร" | mkN "แม่โค" | mkN "แม่วัว" | mkN "ตัวเมีย" | mkN "วัวตัวเมีย" | mkN "วัวเพศเมีย" | mkN "วัว" | mkN "แม่วัว" | mkN "วัวตัวเมีย" | mkN "สัตว์ตัวเมียขนาดใหญ่" ; -- src=panlex
lin correspond_V2 = mkV2 "ตรงกัน" ; ---- | mkV "กลมกลืน" | mkV "เท่ากับ" | mkV "แก้ต่าง" | mkV "เห็นด้วย" | mkV "เหมือนกัน" | mkV "มีค่าเท่ากับ" | mkV "ติดต่อทางจดหมาย" | mkV "เท่ากัน" | mkV "เหมือนกัน" | mkV "สอดคล้องกัน" | mkV "โต้ตอบจดหมาย" | mkV "ติดต่อกันทางจดหมาย" | mkV "มีลักษณะเช่นเดียวกัน" ; -- src=panlex
lin correspond_V = mkV "ตรงกัน" | mkV "กลมกลืน" | mkV "เท่ากับ" | mkV "แก้ต่าง" | mkV "เห็นด้วย" | mkV "เหมือนกัน" | mkV "มีค่าเท่ากับ" | mkV "ติดต่อทางจดหมาย" | mkV "เท่ากัน" | mkV "เหมือนกัน" | mkV "สอดคล้องกัน" | mkV "โต้ตอบจดหมาย" | mkV "ติดต่อกันทางจดหมาย" | mkV "มีลักษณะเช่นเดียวกัน" ; -- src=panlex
lin cite_V2 = variants{} ; -- 
lin classic_A = mkA "อมตะ" | mkA "ดีเด่น" | mkA "ชั้นเอก" | mkA "นักวรรณค" | mkA "เป็นหลัก" | mkA "ชั้นหนึ่ง" | mkA "ดีถึงขนาด" | mkA "ยอดเยี่ยม" | mkA "เป็นประเพณี" | mkA "เป็นพื้นฐาน" | mkA "เป็นแบบอย่าง" | mkA "ที่มีคุณภาพสูง" | mkA "แบบกรีกและโรมัน" | mkA "ที่เป็นรูปแบบดั้งเดิม" | mkA "เกี่ยวกับภาษากรีกและลาติน" | mkA "มีชื่อเสียงทางประวัติศาสตร์หรือวรรณคดี" ; -- src=panlex
lin inspection_N = mkN "การตระเวน" | mkN "การตรวจจับ" | mkN "การตรวจการณ์" | mkN "การพินิจพิเคราะห์" | mkN "การตรวจสอบอย่างละเอียด" ; -- src=panlex
lin calculation_N = mkN "การคำนวณ" | mkN "ความรอบคอบ" | mkN "การคิดคำนวณ" | mkN "การคิดพิจารณา" | mkN "การคํานวณ" | mkN "การคาดการณ์" | mkN "การประมาณการณ์" | mkN "ผลจากการคํานวณ" ; -- src=panlex
lin rubbish_N = mkN "ขยะ" | mkN "เรื่องไร้สาระ" | mkN "วรรณกรรมไร้คุณค่า" | mkN "ขยะ" | mkN "สวะ" | mkN "ของเสีย" | mkN "สิ่งที่ไร้ค่า" | mkN "สิ่งที่เหลวไหล" | mkN "สิ่งที่ไร้สาระ" ; -- src=panlex
lin minimum_N = mkN "จุดมินิมัม" | mkN "ปริมาณน้อยที่สุด" | mkN "ค่าที่น้อยที่สุด" | mkN "จํานวนน้อยที่สุด" | mkN "ปริมาณต่ําที่สุด" ; -- src=panlex
lin hypothesis_N = mkN "สมมติฐาน" | mkN "สมมุติฐาน" | mkN "ข้อสมมุติ" | mkN "สมมุติฐาน" | mkN "ข้อสันนิษฐาน" ; -- src=panlex
lin youngster_N = mkN "เด็ก" | mkN "ผู้เยาว์" | mkN "เด็ก" | mkN "ลูกม้า" | mkN "ลูกสัตว์" | mkN "คนหนุ่มคนสาว" | mkN "สัตว์ที่ยังมีอายุน้อย" | mkN "นักเรียนนายเรือปีที่ 2 ของอเมริกา" ; -- src=panlex
lin slope_N = mkN "สโลป" | mkN "ความชัน" | mkN "ความลาด" | mkN "ที่ลาด" | mkN "ที่เอียง" | mkN "พื้นที่ลาดเอียง" | mkN "สิ่งที่ลาดเอียง" ; -- src=panlex
lin patch_N = mkN "จุด" | mkN "แปลง" | mkN "รอยชุน" | mkN "ผ้าปิดตา" | mkN "ผ้าใช้ปะ" | mkN "ผ้าพันแผล" | mkN "แปลงปลูกพืช" | mkN "แปลงปลูกต้นไม้" | mkN "แต้ม" | mkN "คนโง่" | mkN "รอยปะ" | mkN "ตัวตลก" | mkN "ที่ดิน" | mkN "ปะซ่อม" | mkN "แผ่นปะ" | mkN "จุดด่าง" | mkN "รอยซ่อม" | mkN "รอยแต้ม" | mkN "แผ่นเสริม" | mkN "แผ่นปะหย่อม" | mkN "ช่วงเวลายากลําบาก" ; -- src=panlex
lin invitation_N = mkN "การเชิญชวน" | mkN "การเชื้อเชิญ" | mkN "การเชิญ" | mkN "คําเชิญ" | mkN "บัตรเชิญ" | mkN "การชักจูง" | mkN "การเชิญชวน" | mkN "การเชื้อเชิญ" | mkN "ความดึงดูดใจ" | mkN "คําเชื้อเชิญ" ; -- src=panlex
lin ethnic_A = mkA "เกี่ยวกับเชื้อชาติ" | mkA "เกี่ยวกับชาติพันธุ์" | mkA "เกี่ยวกับเผ่าพันธุ์" ; -- src=panlex
lin federation_N = mkN "สหพันธ์" | mkN "สมาพันธ์" | mkN "สหภาพ" | mkN "สหรัฐ" | mkN "สหพันธ์" | mkN "สหพันธรัฐ" | mkN "กลุ่มการเมือง" | mkN "การรวมเข้าเป็นสหรัฐหรือสมาพันธรัฐ" ; -- src=panlex
lin duke_N = mkN "ดยุค" | mkN "ท่านดยุค" | mkN "ท่านดยุค" | mkN "ขุนนางชั้นสูงของอังกฤษ" ; -- src=panlex
lin wholly_Adv = mkAdv "อย่างสมบูรณ์" | mkAdv "ทั้งหมด" | mkAdv "เต็มที่" | mkAdv "ทั้งสิ้น" ; -- src=panlex
lin closure_N = mkN "การจบ" | mkN "การปิด" | mkN "การหยุด" | mkN "การใกล้" | mkN "การขัดขวาง" | mkN "สิ่งกีดขวาง" | mkN "ผลการตัดสินใจ" | mkN "กฎแห่งความสมบูรณ์" | mkN "กฎแห่งความสิ้นสุด" | mkN "ยุติ" | mkN "การจบ" | mkN "ฝาปิด" | mkN "การปิด" | mkN "การยุติ" | mkN "การสิ้นสุด" | mkN "สิ่งที่ปิด" | mkN "กําแพงล้อมรอบ" ; -- src=panlex
lin dictionary_N = mkN "ดิก" | mkN "ปทานุกรม" | mkN "พจนานุกรม" | mkN "ดิกชันนารี" | mkN "ปทานุกรม" | mkN "นามานุกรม" | mkN "พจนานุกรม" | mkN "ประมวลคําศัพท์" | mkN "อภิธานคําศัพท์" ; -- src=panlex
lin withdrawal_N = mkN "การถอนออก" | mkN "การเลิกยา" | mkN "การถอนเงิน" | mkN "การเลิกเสพยา" | mkN "การหด" | mkN "การถอน" | mkN "การเลิก" | mkN "การถอนออ" | mkN "การถอนคืน" | mkN "การดึงกลับ" | mkN "การเก็บคืน" | mkN "การเอากลับ" | mkN "การเบิกเงิน" ; -- src=panlex
lin automatic_A = mkA "อัตโนมัติ" | mkA "ที่เหมือนเครื่องจักร" | mkA "เป็นกลไก" | mkA "อัตโนมัติ" | mkA "เกิดขึ้นอย่างอิสระ" | mkA "เป็นไปโดยอัตโนมัติ" ; -- src=panlex
lin liable_A = mkA "อาจจะ" | mkA "ง่ายต่อ" | mkA "โน้มน้าว" | mkA "รับผิดชอบ" | mkA "โน้มเอียง" | mkA "ที่มีแนวโน้ม" | mkA "ที่โน้มเอียง" | mkA "เป็นความรับผิดชอบ" | mkA "ซึ่งมีความรู้สึกไวต่อ" | mkA "ซึ่งรับผิดชอบตามกฎหมาย" ; -- src=panlex
lin cry_N = mkN "คำขวัญ" | mkN "เสียงร้อง" | mkN "การร้องไห้" | mkN "เสียงตะโกน" | mkN "เสียงร้องตะโกน" | mkN "เสียงร้อง" | mkN "เสียงครวญคราง" | mkN "ช่วงเวลาการร้องไห้" | mkN "ความต้องการของมวลชน" | mkN "การเรียกร้องของมวลชน" ; -- src=panlex
lin slow_V2 = mkV2 "ช้าลง" ; ---- | mkV "ถดถอย" | mkV "ทำให้ช้า" | mkV "ทำให้ช้าลง" | mkV "ลดความเร็ว" | mkV "ชะลอความเร็ว" ; -- src=panlex
lin slow_V = mkV "ช้าลง" | mkV "ถดถอย" | mkV "ทำให้ช้า" | mkV "ทำให้ช้าลง" | mkV "ลดความเร็ว" | mkV "ชะลอความเร็ว" ; -- src=panlex
lin borough_N = mkN "เขตบูโรฮ์" | mkN "เมืองบูโรฮ์" | mkN "เมืองเล็กๆ ที่ปกครองตนเอง" | mkN "เขตเลือกตั้ง" | mkN "เขตเทศบาลที่เล็กกว่าเมือง" ; -- src=panlex
lin well_A = mkA "ดี" | mkA "ดี" | mkA "พอใจ" | mkA "หายดี" | mkA "เหมาะสม" | mkA "เรียบร้อย" | mkA "ซึ่งมีสุขภาพดี" | mkA "ซึ่งหายเป็นปกติ" ; -- src=panlex
lin suspicion_N = mkN "ความสงสัย" | mkN "ความสังหรณ์" | mkN "ความคลางแคลงใจ" | mkN "ร่องรอย" | mkN "ความกังขา" | mkN "ความระแวง" | mkN "ความสงสัย" | mkN "ความหวาดระแวง" | mkN "ความคลางแคลงใจ" | mkN "ความไม่ไว้วางใจ" | mkN "รอยแต้มเล็กน้อย" | mkN "สิ่งที่บอกเป็นนัย" ; -- src=panlex
lin portrait_N = mkN "ภาพ" | mkN "รูป" | mkN "รูปคน" | mkN "รูปแกะสลัก" | mkN "ภาพครึ่งตัว" | mkN "ภาพถ่ายของคน" ; -- src=panlex
lin local_N = mkN "ยาชา" | mkN "รถหวานเย็น" | mkN "ร้านเหล้า" | mkN "คนท้องถิ่น" | mkN "คนพื้นเมือง" | mkN "ลักษณะพิเศษของเฉพาะท้องถิ่น" ; -- src=panlex
lin jew_N = variants{} ; -- 
lin fragment_N = mkN "เศษเครื่องปั้นดินเผา" | mkN "สะเก็ด" | mkN "เศษที่แตกออก" | mkN "ชิ้นที่แตกออก" | mkN "ส่วนที่แตกออกมา" | mkN "ส่วนที่ยังไม่สมบูรณ์" | mkN "ทําให้แตกออกเป็นชิ้น ๆ" | mkN "ส่วนที่ยังทําไม่เสร็จ" ; -- src=panlex
lin revolutionary_A = mkA "เกี่ยวกับการปฏิวัติ" ; -- src=panlex
lin evaluate_V2 = mkV2 "ตัดสิน" ; ---- | mkV "ตีราคา" | mkV "ประเมิน" | mkV "ประเมินค่า" | mkV "ประเมินผล" | mkV "ประเมินค่า" ; -- src=panlex
lin evaluate_V = mkV "ตัดสิน" | mkV "ตีราคา" | mkV "ประเมิน" | mkV "ประเมินค่า" | mkV "ประเมินผล" | mkV "ประเมินค่า" ; -- src=panlex
lin competitor_N = mkN "คู่แข่ง" | mkN "คู่ต่อสู้" | mkN "ผู้ท้าชิง" | mkN "คู่แข่ง" | mkN "ผู้แข่ง" | mkN "คู่ต่อสู้" | mkN "ผู้แข่งขัน" ; -- src=panlex
lin sole_A = mkA "เพียงคนเดียว" | mkA "คนเดียว" | mkA "ส่วนพื้น" | mkA "อันเดียว" | mkA "โดดเดี่ยว" | mkA "พื้นรองเท้า" | mkA "เพียงคนเดียว" ; -- src=panlex
lin reliable_A = mkA "ซึ่งวางใจได้" | mkA "ซึ่งไว้ใจได้" | mkA "ซึ่งพึ่งพาได้" | mkA "ไว้วางใจ" | mkA "ไว้ใจได้" | mkA "น่าเชื่อถือ" | mkA "เชื่อถือได้" | mkA "ไว้วางใจได้" ; -- src=panlex
lin weigh_V2 = mkV2 "หนัก" ; ---- | mkV "คำนึงถึง" | mkV "มีน้ำหนัก" | mkV "ชั่งน้ำหนัก" | mkV "ทำความหนักใจ" | mkV "หนัก" | mkV "ประเมิน" | mkV "วัดน้ําหนัก" | mkV "ชั่งน้ําหนัก" | mkV "มีความสําคัญ" ; -- src=panlex
lin weigh_V = mkV "หนัก" | mkV "คำนึงถึง" | mkV "มีน้ำหนัก" | mkV "ชั่งน้ำหนัก" | mkV "ทำความหนักใจ" | mkV "หนัก" | mkV "ประเมิน" | mkV "วัดน้ําหนัก" | mkV "ชั่งน้ําหนัก" | mkV "มีความสําคัญ" ; -- src=panlex
lin medieval_A = mkA "เชย" | mkA "โบราณ" | mkA "ล้าสมัย" | mkA "สมัยเก่า" | mkA "ในยุคกลาง" | mkA "ในสมัยกลาง" | mkA "เกี่ยวกับยุคกลาง" | mkA "เกี่ยวกับสมัยกลาง" ; -- src=panlex
lin clinic_N = mkN "คลินิก" | mkN "ร้านหมอ" | mkN "การเข้ารับการรักษา" | mkN "คลินิก" | mkN "สถานรักษาพยาบาล" ; -- src=panlex
lin shine_V2 = mkV2 "ชัด" ; ---- | mkV "กระทบ" | mkV "ขัดมัน" | mkV "ขัดเงา" | mkV "ชัดเจน" | mkV "ผ่องใส" | mkV "วาววับ" | mkV "ผุดผ่อง" | mkV "ส่องแสง" | mkV "ผ่องแผ้ว" | mkV "อิ่มเอิบ" | mkV "สะท้อนแสง" | mkV "เปล่งปลั่ง" | mkV "ส่อง" | mkV "ส่องแสง" | mkV "โชติช่วง" | mkV "ทําให้สุกใส" | mkV "ทําให้ส่องแสง" ; -- src=panlex
lin shine_V = mkV "ชัด" | mkV "กระทบ" | mkV "ขัดมัน" | mkV "ขัดเงา" | mkV "ชัดเจน" | mkV "ผ่องใส" | mkV "วาววับ" | mkV "ผุดผ่อง" | mkV "ส่องแสง" | mkV "ผ่องแผ้ว" | mkV "อิ่มเอิบ" | mkV "สะท้อนแสง" | mkV "เปล่งปลั่ง" | mkV "ส่อง" | mkV "ส่องแสง" | mkV "โชติช่วง" | mkV "ทําให้สุกใส" | mkV "ทําให้ส่องแสง" ; -- src=panlex
lin knit_V2 = mkV2 "ผูก" ; ---- | mkV "เม้ม" | mkV "ถักนิตติ้ง" | mkV "ถัก" | mkV "ขมวดคิ้ว" | mkV "ย่นหน้าผาก" ; -- src=panlex
lin knit_V = mkV "ผูก" | mkV "เม้ม" | mkV "ถักนิตติ้ง" | mkV "ถัก" | mkV "ขมวดคิ้ว" | mkV "ย่นหน้าผาก" ; -- src=panlex
lin complexity_N = mkN "ความสลับซับซ้อน" | mkN "ความซับซ้อน" | mkN "ลักษณะเชิงซ้อน" | mkN "สิ่งที่ซับซ้อน" | mkN "ความสลับซับซ้อน" ; -- src=panlex
lin remedy_N = mkN "ยารักษา" | mkN "ยา" | mkN "ขจัด" | mkN "กําจัด" | mkN "บรรเทา" | mkN "ฟื้นฟู" | mkN "เยียวยา" | mkN "การรักษา" | mkN "วิธีการรักษา" | mkN "วิธีการแก้ไข" | mkN "ทําให้ถูกต้อง" | mkN "สิ่งที่ใช้ในการรักษา" ; -- src=panlex
lin fence_N = mkN "รั้ว" | mkN "คนรับซื้อของโจร" | mkN "พ่อค้ารับซื้อของโจร" | mkN "รั้ว" | mkN "กําแพง" | mkN "ที่กั้น" | mkN "สิ่งกีดขวาง" | mkN "ผู้ซื้อหรือขายของที่โขมยมา" ; -- src=panlex
lin bike_N = mkN (thword "จักร" "ยาน") "คัน" | {-pan-} mkN "จยย." | mkN "รถถีบ" | mkN "จักรยาน" | mkN "รถจักรยาน" | mkN "รถเครื่อง" | mkN "แมงกาไซค์" | mkN "จักรยานยนต์" | mkN "มอเตอร์ไซค์" | mkN "รถจักรยานยนต์" | mkN "รถมอเตอร์ไซค์" | mkN "จักรยานยนต์" | mkN "จักรยานสองล้อ" | mkN "จักรยานหรือรถมอเตอร์ไซค์" | mkN "ขี่จักรยานสองล้อหรือจักรยานยนต์" ; -- src=panlex
lin freeze_V2 = mkV2 (thword "แข็ง") ; ---- | {-pan-} mkV "ระงับ" | mkV "เฉยชา" | mkV "เย็นชา" | mkV "แช่แข็ง" | mkV "รู้สึกหนาว" | mkV "เป็นน้ำแข็ง" | mkV "กลายเป็นของแข็ง" | mkV "ทำให้ชาด้วยความเย็น" | mkV "อยู่ต่ำกว่าจุดเยือกแข็ง" | mkV "แข็ง" | mkV "กลายเป็นน้ําแข็ง" | mkV "ปกคลุมไปด้วยน้ําแข็ง" ; -- src=panlex
lin freeze_V = mkV (thword "แข็ง") | {-pan-} mkV "ระงับ" | mkV "เฉยชา" | mkV "เย็นชา" | mkV "แช่แข็ง" | mkV "รู้สึกหนาว" | mkV "เป็นน้ำแข็ง" | mkV "กลายเป็นของแข็ง" | mkV "ทำให้ชาด้วยความเย็น" | mkV "อยู่ต่ำกว่าจุดเยือกแข็ง" | mkV "แข็ง" | mkV "กลายเป็นน้ําแข็ง" | mkV "ปกคลุมไปด้วยน้ําแข็ง" ; -- src=panlex
lin eliminate_V2 = variants{} ; -- 
lin interior_N = mkN "ภายใน" | mkN "ด้านใน" | mkN "ส่วนใน" ; -- src=panlex
lin intellectual_A = mkA "ซึ่งรอบรู้" | mkA "ทางสติปัญญา" | mkA "ซึ่งมีปัญญาสูง" | mkA "ซึ่งมีสติปัญญา" | mkA "เกี่ยวกับปัญญา" | mkA "ผู้ที่มีเหตุผลสูง" | mkA "ผู้ที่ใช้สติปัญญา" | mkA "เกี่ยวกับความคิดและการใช้เหตุผล" ; -- src=panlex
lin established_A = mkA "ที่ตั้งขึ้น" ; -- src=panlex
lin voter_N = mkN "ผู้ใช้สิทธิ" | mkN "ผู้เลือกตั้ง" | mkN "ผู้ออกเสียงเลือกตั้ง" | mkN "ผู้ออกเสียง" | mkN "ผู้ลงคะแนนเสียง" | mkN "ผู้มีสิทธิเลือกตั้ง" ; -- src=panlex
lin garage_N = mkN "โรงรถ" | mkN "อู่ซ่อมรถ" | mkN "ศูนย์ซ่อมรถ" | mkN "อู่" | mkN "โรงรถ" | mkN "อู่ซ่อมรถ" ; -- src=panlex
lin era_N = mkN "ยุค" | mkN "มหายุค" | mkN "ศก" | mkN "ตอน" | mkN "ยุค" | mkN "ช่วง" | mkN "ระยะ" | mkN "สมัย" | mkN "ศักราช" ; -- src=panlex
lin pregnant_A = mkA "อุ้มท้อง" | mkA "ตั้งครรภ์" | mkA "ท้อง" | mkA "มีครรภ์" | mkA "ตั้งท้อง" | mkA "ตั้งครรภ์" | mkA "อุดมสมบูรณ์" | mkA "เป็นไปได้มาก" | mkA "เต็มไปด้วยนัย" | mkA "เต็มไปด้วยความคิด" | mkA "เต็มไปด้วยความหมาย" ; -- src=panlex
lin plot_N = mkN "แปลง" | mkN "พล็อต" | mkN "แผนการ" | mkN "แปลงปลูกพืช" | mkN "แปลงปลูกต้นไม้" | mkN "แผน" | mkN "อุบาย" | mkN "ที่ดิน" | mkN "วางแผน" | mkN "แผนการ" | mkN "แผนที่" | mkN "แผนผัง" | mkN "แผนการลับ" | mkN "โครงเรื่อง" | mkN "ที่ดินแปลเล็ก" | mkN "แผนที่วางขึ้น" | mkN "ที่ดินแปลงเล็ก" | mkN "เค้าโครงเรื่อง" ; -- src=panlex
lin greet_V2 = variants{} ; -- 
lin electrical_A = mkA "ไฟฟ้า" | mkA "ที่ใช้ไฟฟ้า" | mkA "เกี่ยวกับไฟฟ้า" | mkA "ที่ทํางานด้วยไฟฟ้า" ; -- src=panlex
lin lie_N = mkN "คำโกหก" | mkN "คำโป้ปด" | mkN "ที่ตั้ง" | mkN "เรื่องเท็จ" | mkN "เรื่องโกหก" | mkN "เรื่องไม่จริง" | mkN "เรื่องโกหกมดเท็จ" | mkN "การวาง" | mkN "คําเท็จ" | mkN "คําโกหก" | mkN "การพูดโกหก" | mkN "การวางอยู่" | mkN "การหลอกลวง" | mkN "การตั้งอยู่" | mkN "คํากล่าวเท็จ" | mkN "ตําแหน่งที่ตั้งอยู่" | mkN "ตําแหน่งที่วางลูกกอลฟ์" ; -- src=panlex
lin disorder_N = mkN "ความผิดปกติ" | mkN "ความสับสนวุ่นวาย" | mkN "ความไม่เป็นระเบียบ" | mkN "ความสับสน" | mkN "ความโกลาหล" | mkN "ความวุ่นวาย" | mkN "ความอลหม่าน" | mkN "ทําให้สับสน" | mkN "ทําให้ยุ่งเหยิง" | mkN "ความไม่เป็นระเบียบ" ; -- src=panlex
lin formally_Adv = variants{} ; -- 
lin excuse_N = mkN "ข้อแก้ตัว" | mkN "การหาข้อแก้ตัว" | mkN "ตัวอย่างที่แย่" | mkN "ตัวอย่างที่ไม่ดี" | mkN "ข้ออ้าง" | mkN "ข้อแก้ตัว" | mkN "คํากล่าวอ้าง" ; -- src=panlex
lin socialist_A = variants{} ; -- 
lin cancel_V2 = mkV2 "งด" ; ---- | mkV "ลบ" | mkV "ดีลีต" | mkV "ยกเลิก" | mkV "แคนเซิล" | mkV "ประกาศยกเลิก" | mkV "ยกเลิก" | mkV "ลบทิ้ง" | mkV "ตัดทิ้ง" ; -- src=panlex
lin cancel_V = mkV "งด" | mkV "ลบ" | mkV "ดีลีต" | mkV "ยกเลิก" | mkV "แคนเซิล" | mkV "ประกาศยกเลิก" | mkV "ยกเลิก" | mkV "ลบทิ้ง" | mkV "ตัดทิ้ง" ; -- src=panlex
lin harm_N = mkN "การทำลาย" | mkN "การบาดเจ็บ" | mkN "ความเสื่อม" | mkN "ความเสียหาย" | mkN "อาการบาดเจ็บ" | mkN "การประทุษร้าย" | mkN "อันตราย" | mkN "ความชั่ว" | mkN "การบาดเจ็บ" | mkN "การเป็นภัย" | mkN "ความเสียหาย" | mkN "ความชั่วร้าย" | mkN "ทําให้ได้รับบาดเจ็บ" | mkN "การทําให้ได้รับบาดเจ็บ" ; -- src=panlex
lin excess_N = mkN "จำนวนมากเกินไป" | mkN "ส่วนเกิน" | mkN "ความเกินพอดี" | mkN "จํานวนที่เกิน" | mkN "จํานวนที่เกินควร" | mkN "จํานวนที่มากเกินไป" | mkN "ส่วนที่เพิ่มขึ้นมา" | mkN "พฤติกรรมที่เกินขอบเขต" ; -- src=panlex
lin exact_A = mkA "ถูกต้องแม่นยํา" ; -- src=panlex
lin oblige_V2V = variants{} ; -- 
lin oblige_V2 = variants{} ; -- 
lin accountant_N = mkN "นักบัญชี" | mkN "สมุหบัญชี" | mkN "พนักงานบัญชี" | mkN "นักบัญชี" | mkN "สมุห์บัญชี" ; -- src=panlex
lin mutual_A = mkA "ร่วมกัน" | mkA "ทั้งสองฝ่าย" | mkA "ซึ่งกันและกัน" | mkA "ซึ่งมีร่วมกัน" | mkA "ซึ่งสัมพันธ์กัน" ; -- src=panlex
lin fat_N = mkN (thword "ไข" "มัน") | {-pan-} mkN "ไขมัน" | mkN "ความอ้วน" | mkN "เนื้อเยื่อไขมัน" | mkN "ไข" | mkN "มัน" | mkN "ไขมัน" ; -- src=panlex
lin volunteerMasc_N = variants{} ; -- 
lin laughter_N = mkN "การหัวเราะ" | mkN "เสียงหัวเราะ" | mkN "การหัวเราะ" | mkN "อาการขบขัน" | mkN "เสียงหัวเราะ" | mkN "สิ่งที่น่าหัวเราะ" ; -- src=panlex
lin trick_N = mkN "แขก" | mkN "มายากล" | mkN "คนเที่ยว" | mkN "การเล่นกล" | mkN "คนเที่ยวหญิง" | mkN "การแสดงมายากล" | mkN "คนเที่ยวผู้หญิง" | mkN "คนซื้อบริการทางเพศ" | mkN "ผู้ซื้อบริการทางเพศ" | mkN "กล" | mkN "เด็ก" | mkN "อุบาย" | mkN "เล่ห์" | mkN "มายากล" | mkN "กลอุบาย" | mkN "ภาพหลอน" | mkN "เพทุบาย" | mkN "เล่ห์กล" | mkN "เคล็ดลับ" | mkN "การเล่นกล" | mkN "นิสัยแปลก ๆ" | mkN "การเล่นตลก" | mkN "เด็กผู้หญิง" | mkN "เทคนิคพิเศษ" | mkN "วิธีพลิกแพลง" | mkN "เล่ห์เหลี่ยม" ; -- src=panlex
lin load_V2 = mkV2 "ใส่" ; ---- | mkV "โหลด" | mkV "บรรจุ" | mkV "ประจุ" | mkV "บรรทุก" | mkV "ปลอมปน" | mkV "บรรจุกระสุน" | mkV "ถ่วงน้ําหนัก" | mkV "ทําให้หนักใจ" | mkV "เป็นภาระหนัก" | mkV "เพิ่มน้ําหนัก" | mkV "เข้าไปในยานพาหนะ" | mkV "ถ่ายข้อมูลหรือโปรแกรมในคอมพิวเตอร์" | mkV "ใส่ดิสก์หรือเทปลงในคอมพิวเตอร์หรือเครื่องเล่น" ; -- src=panlex
lin load_V = mkV "ใส่" | mkV "โหลด" | mkV "บรรจุ" | mkV "ประจุ" | mkV "บรรทุก" | mkV "ปลอมปน" | mkV "บรรจุกระสุน" | mkV "ถ่วงน้ําหนัก" | mkV "ทําให้หนักใจ" | mkV "เป็นภาระหนัก" | mkV "เพิ่มน้ําหนัก" | mkV "เข้าไปในยานพาหนะ" | mkV "ถ่ายข้อมูลหรือโปรแกรมในคอมพิวเตอร์" | mkV "ใส่ดิสก์หรือเทปลงในคอมพิวเตอร์หรือเครื่องเล่น" ; -- src=panlex
lin disposal_N = mkN "การกำจัดสิ่งของ" | mkN "เครื่องกำจัดขยะ" | mkN "การกําจัด" | mkN "การจัดการ" | mkN "การจัดวาง" | mkN "การจัดวางกําลัง" | mkN "กระบวนการกําจัดสิ่งของ" ; -- src=panlex
lin taxi_N = mkN "แท็กซี่" | mkN "รถแท็กซี่" | mkN "ทําให้" | mkN "รถรับจ้าง" | mkN "รถแท็กซี่" ; -- src=panlex
lin murmur_V2 = mkV2 "พึมพำ" ; ---- | mkV "บ่นพึมพำ" | mkV "พูดพึมพำ" | mkV "ทำปากกระหมุบกระหมิบ" | mkV "บ่นพึมพํา" | mkV "บ่นอุบอิบ" ; -- src=panlex
lin murmur_V = mkV "พึมพำ" | mkV "บ่นพึมพำ" | mkV "พูดพึมพำ" | mkV "ทำปากกระหมุบกระหมิบ" | mkV "บ่นพึมพํา" | mkV "บ่นอุบอิบ" ; -- src=panlex
lin tonne_N = mkN "ตัน" | mkN "เมตริกตัน" | mkN "เมตริกตัน" | mkN "1000 กิโลกรัม" ; -- src=panlex
lin spell_V2 = mkV2 "สะกด" ; ---- | mkV "ลดภาระ" | mkV "สะกดคำ" | mkV "นำเข้ามา" | mkV "เปลี่ยนกะทำงาน" | mkV "เสน่ห์" | mkV "มนตร์คาถา" | mkV "อ่านสะกดคํา" ; -- src=panlex
lin spell_V = mkV "สะกด" | mkV "ลดภาระ" | mkV "สะกดคำ" | mkV "นำเข้ามา" | mkV "เปลี่ยนกะทำงาน" | mkV "เสน่ห์" | mkV "มนตร์คาถา" | mkV "อ่านสะกดคํา" ; -- src=panlex
lin clerk_N = mkN "เสมียน" | mkN "เด็กขายของ" | mkN "เสมียน" | mkN "พาแขกไปที่ห้องพัก" | mkN "พนักงานโรงแรมที่ทําหน้าที่เกี่ยวกับการลงทะเบียน" ; -- src=panlex
lin curious_A = mkA "แปลก" | mkA "แปลก" | mkA "หายาก" | mkA "ประณีต" | mkA "น่าสนใจ" | mkA "ซึ่งหายาก" | mkA "ผิดธรรมดา" | mkA "อยากรู้อยากเห็น" | mkA "ซึ่งอยากรู้อยากเห็น" ; -- src=panlex
lin satisfactory_A = mkA "น่าพอใจ" | mkA "ที่ให้ความพอใจ" | mkA "จุใจ" | mkA "พอใจ" | mkA "ชดเชย" | mkA "แน่ใจ" | mkA "หนําใจ" | mkA "ถ่ายบาป" | mkA "น่าพอใจ" | mkA "สาแก่ใจ" | mkA "เพียงพอ" | mkA "เป็นที่น่าพอใจ" ; -- src=panlex
lin identical_A = mkA "จากไข่ใบเดียว" | mkA "เหมือนกันเปี๊ยบ" | mkA "ตรงกัน" | mkA "เท่ากัน" | mkA "เหมือนกัน" | mkA "แบบเดียวกัน" | mkA "อย่างเดียวกัน" | mkA "เหมือนกันทุกอย่าง" ; -- src=panlex
lin applicant_N = mkN "คนสมัคร" | mkN "ผู้สมัคร" | mkN "ผู้ขอ" | mkN "ผู้สมัคร" | mkN "ผู้แจ้งความจํานง" ; -- src=panlex
lin removal_N = mkN "การเอาออก" | mkN "การฆ่า" | mkN "การถอด" | mkN "การย้าย" | mkN "การขับออก" | mkN "การถอนออก" | mkN "การลอบฆ่า" | mkN "การเอาออก" | mkN "การไล่ออก" | mkN "การย้ายออก" | mkN "การโยกย้าย" | mkN "การเปลี่ยนแปลง" | mkN "การเคลื่อนย้ายได้" ; -- src=panlex
lin processor_N = mkN "ซีพียู" | mkN "หน่วยประมวลผลกลาง" | mkN "ผู้แปรรูป" | mkN "เครื่องจัด" | mkN "ผู้ดําเนินการ" | mkN "หน่วยประมวลผลกลาง" | mkN "โปรแกรมคอมพิวเตอร์ที่ใช้ในการประมวลผลข้อความ" ; -- src=panlex
lin cotton_N = mkN "ฝ้าย" | mkN "ใยฝ้าย" | mkN "ต้นฝ้าย" | mkN "ผ้าฝ้าย" | mkN "ผ้าคอตตอน" | mkN "เส้นใยฝ้าย" | mkN "เส้นใยคอตตอน" | mkN "ฝ้าย" | mkN "สําลี" | mkN "ใยฝ้าย" | mkN "ต้นฝ้าย" | mkN "ผ้าฝ้าย" | mkN "พืชประเภทฝ้าย" ; -- src=panlex
lin reverse_V2 = mkV2 "ลบล้าง" ; ---- | mkV "กลับตาลปัตร" | mkV "วกกลับ" | mkV "กลับกัน" | mkV "ถอยกลับ" | mkV "ถอยหลัง" | mkV "เลี้ยวกลับ" | mkV "กลับคําพิพากษา" | mkV "ยกเลิกคําสั่งเดิม" ; -- src=panlex
lin reverse_V = mkV "ลบล้าง" | mkV "กลับตาลปัตร" | mkV "วกกลับ" | mkV "กลับกัน" | mkV "ถอยกลับ" | mkV "ถอยหลัง" | mkV "เลี้ยวกลับ" | mkV "กลับคําพิพากษา" | mkV "ยกเลิกคําสั่งเดิม" ; -- src=panlex
lin hesitate_VV = mkVV "ชะงัก" ; ---- | mkV "ลังเล" | mkV "หยุดชะงัก" | mkV "ลังเล" | mkV "ชักช้า" | mkV "อึกอัก" | mkV "ละล้าละลัง" ; -- src=panlex
lin hesitate_V = mkV "ชะงัก" | mkV "ลังเล" | mkV "หยุดชะงัก" | mkV "ลังเล" | mkV "ชักช้า" | mkV "อึกอัก" | mkV "ละล้าละลัง" ; -- src=panlex
lin professor_N = mkN "ศ." | mkN "ศาสตราจารย์" | mkN "โปรเฟสเซอร์" | mkN "ศาสตราจารย์" | mkN "ผู้เชี่ยวชาญ" | mkN "ผู้สอนวิชากีฬา" | mkN "อาจารย์มหาวิทยาลัย" | mkN "ผู้แสดงความเลื่อมใส" | mkN "อาจารย์ในมหาวิทยาลัย หรือวิทยาลัย" | mkN "ผู้สอนวิชาทางศิลปกรรม" | mkN "ผู้เชี่ยวชาญในวิชาชีพหนึ่ง" ; -- src=panlex
lin admire_V2 = variants{} ; -- 
lin namely_Adv = mkAdv "กล่าวคือ" | mkAdv "กล่าวคือ" ; -- src=panlex
lin electoral_A = mkA "เกี่ยวกับการเลือก" | mkA "เกี่ยวกับผู้เลือก" | mkA "เกี่ยวกับการเลือกตั้ง" ; -- src=panlex
lin delight_N = mkN "ความยินดี" | mkN "สิ่งที่ทำให้พอใจ" | mkN "ความดีใจ" | mkN "ความยินดี" | mkN "ความสุขใจ" | mkN "ความปิติยินดี" ; -- src=panlex
lin urgent_A = mkA "ฉุกเฉิน" | mkA "รีบด่วน" | mkA "เร่งรีบ" | mkA "เร่งด่วน" | mkA "เร้าร้อน" | mkA "ซึ่งต้องเร่งรีบทํา" | mkA "ที่จําเป็นเร่งด่วน" ; -- src=panlex
lin prompt_V2V = variants{} ; -- 
lin prompt_V2 = variants{} ; -- 
lin mate_N = mkN "คู่" | mkN "เมต" | mkN "เพื่อน" | mkN "คู่ครอง" | mkN "คู่ชีวิต" | mkN "คู่ผสมพันธุ์" | mkN "คู่ผัวตัวเมีย" | mkN "คู่สามมีภรรยา" | mkN "ต้นชาปารากวัย" | mkN "เพื่อนร่วมงาน" | mkN "เพื่อนร่วมทีม" | mkN "ผู้ช่วยกัปตันเรือ" | mkN "เกลอ" | mkN "เพื่อน" | mkN "คู่ครอง" | mkN "คู่สมรส" | mkN "ผู้ช่วย" | mkN "การรุกฆาต" | mkN "สามีภรรยา" | mkN "คู่แต่งงาน" | mkN "เพื่อนร่วม" | mkN "สามีหรือภรรยา" | mkN "เพื่อนร่วมทีม" | mkN "อันหนึ่งในจํานวนคู่" | mkN "ส่วนหนึ่งในจํานวนคู่" | mkN "ผู้ช่วยผู้บังคับการเรือ" ; -- src=panlex
lin mate_2_N = variants{} ; -- 
lin mate_1_N = variants{} ; -- 
lin exposure_N = mkN "ภาพ" | mkN "รูป" | mkN "แสงจ้า" | mkN "การทิ้ง" | mkN "ภาพถ่าย" | mkN "รูปถ่าย" | mkN "การจัดแสดง" | mkN "การเปิดเผย" | mkN "ความอ่อนแอ" | mkN "การเปิดฟิล์มให้โดนแสง" | mkN "การเผย" | mkN "การผึ่ง" | mkN "การทอดทิ้ง" | mkN "การเปิดเผย" | mkN "การเปิดโปง" | mkN "การให้ถูกแสง" | mkN "การนําออกแสดง" | mkN "ผิวหน้าที่เผยออก" | mkN "ระยะเวลาที่ให้ถูกแสง" ; -- src=panlex
lin server_N = mkN "บ๋อย" | mkN "แม่ข่าย" | mkN "ผู้เสิร์ฟ" | mkN "เด็กเสิร์ฟ" | mkN "เซิร์ฟเวอร์" | mkN "ผู้เสิร์ฟลูก" | mkN "พนักงานเสิร์ฟ" | mkN "ภาชนะใส่อาหาร" | mkN "บ๋อย" | mkN "บริกร" | mkN "ผู้บริการ" | mkN "ผู้รับใช้" | mkN "เด็กเสิร์ฟ" | mkN "ผู้เสิร์ฟลูก" | mkN "ผู้ให้บริการ" | mkN "เครื่องรับใช" ; -- src=panlex
lin distinctive_A = mkA "เด่น" | mkA "พิเศษ" | mkA "มีลักษณะเฉพาะ" | mkA "เกี่ยวกับลักษณะเฉพาะ" ; -- src=panlex
lin marginal_A = mkA "ร่อแร่" | mkA "เล็กน้อย" | mkA "เกือบขาดทุน" | mkA "เกี่ยวกับขอบ" | mkA "ซึ่งไม่จําเป็น" | mkA "เกือบใช้ไม่ได้" | mkA "เกี่ยวกับขอบเขต" | mkA "เกี่ยวกับพรมแดน" | mkA "เล็กและไม่สําคัญ" | mkA "ขายในราคาเกือบขาดทุน" | mkA "ซึ่งอยู่ในขอบของหน้ากระดาษ" ; -- src=panlex
lin structural_A = mkA "ทางสัณฐานวิทยา" | mkA "ทางโครงสร้างนิยม" | mkA "ทางธรณีสันฐานวิทยา" | mkA "มีความสําคัญ" | mkA "เกี่ยวกับโครงสร้าง" | mkA "มีความสําคัญกับโครงสร้าง" | mkA "เกี่ยวกับโครงสร้างโมเลกุล" | mkA "เกี่ยวกับโครงสร้างทางธรณีวิทยา" | mkA "เกี่ยวกับโครงสร้างหรือการก่อสร้าง" | mkA "เป็นผลมาจากโครงสร้างทางเศรษฐกิจหรือการเมือง" ; -- src=panlex
lin rope_N = mkN (thword "เชือก") | {-pan-} mkN "โรช" | mkN "เชือก" | mkN "สายเชือก" | mkN "เส้นเชือก" | mkN "เม็กซิกันแวเลี่ยม" | mkN "อาร์-2" | mkN "พวง" | mkN "เชือก" | mkN "กลายเป็นเชือก" ; -- src=panlex ----?
lin miner_N = mkN "คนงานเหมือง" | mkN "คนงานเหมืองแร่" | mkN "กรรมกรเหมืองแร่" | mkN "คนงานเหมือง" | mkN "ผู้วางทุนระเบิด" | mkN "ผู้ทํางานในเหมือง" ; -- src=panlex
lin entertainment_N = mkN "ความบันเทิง" | mkN "มหรสพ" | mkN "การแสดง" | mkN "การยอมรับ" | mkN "สันทนาการ" | mkN "ความบันเทิง" | mkN "ความสนุกสนาน" | mkN "การต้อนรับแขก" | mkN "การรับพิจารณา" | mkN "การให้ความเพลิดเพลิน" | mkN "สิ่งที่ให้ความเพลิดเพลิน" ; -- src=panlex
lin acre_N = mkN "เอเคอร์" | mkN "ที่ดิน" | mkN "หน่วยวัดเนื้อที่เป็นเอเคอร์" | mkN "หน่วยวัดเนื้อที่ที่เท่ากับ 2.5 ไร่" ; -- src=panlex
lin pig_N = mkN "หมู" | mkN "สุกร" | mkN "ตำรวจ" | mkN "หมูขุน" | mkN "หมูตอน" | mkN "หมูเลี้ยง" | mkN "แท่งตะกั่ว" | mkN "ไอ้หัวปิงปอง" | mkN "แม่พิมพ์รูปหมู" | mkN "หมู" | mkN "สุกร" | mkN "คนรั้น" | mkN "ตํารวจ" | mkN "นักสืบ" | mkN "ม้าเลว" | mkN "หมูป่า" | mkN "คนสกปรก" | mkN "คนมูมมาม" | mkN "เนื้อหมู" | mkN "เตาหลอมโลหะ" | mkN "คนตะกละตะกลาม" | mkN "คนที่เหมือนหมู" | mkN "อยู่กันอย่างหมู" | mkN "หญิงที่มั่วโลกีย์" | mkN "โลหะที่ออกจากเตาหลอม" | mkN "โลหะที่เอาออกมาจากเตาหลอม" ; -- src=panlex
lin encouraging_A = mkA "ใ้ห้กำลังใจ" ; -- src=panlex
lin guarantee_N = mkN "สัญญา" | mkN "ประกัน" | mkN "ใบสัญญา" | mkN "ใบรับรอง" | mkN "การประกัน" | mkN "คํารับรอง" | mkN "ผู้รับรอง" | mkN "ค้ําประกัน" | mkN "สิ่งประกัน" | mkN "หลักประกัน" | mkN "ให้คํามั่น" | mkN "ใบรับประกัน" | mkN "ผู้ค้ําประกัน" | mkN "เครื่องประกัน" | mkN "ผู้ให้หลักประกัน" ; -- src=panlex
lin gear_N = mkN "เกียร์" | mkN "ล้อเฟือง" | mkN "เฟือง" | mkN "เกียร์" | mkN "อุปกรณ์" | mkN "เครื่องมือ" ; -- src=panlex
lin anniversary_N = mkN "วันครบรอบ" | mkN "วาระครบรอบ" | mkN "ประจําปี" | mkN "วันครบรอบปี" | mkN "การฉลองครบรอบปี" | mkN "การครบรอบปีของเหตุการณ์ในอดีต" ; -- src=panlex
lin past_Adv = mkAdv "ผ่าน" ; -- src=panlex
lin ceremony_N = mkN "งาน" | mkN "พิธี" | mkN "งานพิธี" | mkN "พิธีการ" | mkN "พิธี" | mkN "พิธีการ" | mkN "พิธีรีตอง" | mkN "ระเบียบแบบแผน" | mkN "ความเป็นทางการ" | mkN "ความมีระเบียบแบบแผน" | mkN "พฤติกรรมที่เป็นทางการ" ; -- src=panlex
lin rub_V2 = mkV2 (thword "ถู") ;
lin rub_V = mkV "ขัด" | mkV "เกา" | mkV "ขัดถู" | mkV "ทำให้เสียดสี" | mkV "ถู" | mkV "สี" | mkV "ขูด" | mkV "นวด" | mkV "ครูด" | mkV "ขัดถู" | mkV "เสียดสี" ; -- src=panlex
lin monopoly_N = mkN "การผูกขาด" | mkN "ตลาดผูกขาด" | mkN "เอกสิทธิ์" | mkN "ระบบผูกขาด" | mkN "บริษัทที่มีเอกสิทธิ" | mkN "ภาวะตลาดที่มีผู้ขายเพียงผู้เดียว" ; -- src=panlex
lin left_N = mkN "ทางซ้าย" | mkN "มือซ้าย" | mkN "ด้านซ้าย" | mkN "ฝ่ายซ้าย" | mkN "ทางซ้ายมือ" | mkN "เลฟต์ฟีลด์" | mkN "มือข้างซ้าย" | mkN "การหันทางซ้าย" | mkN "ซ้ายมือ" | mkN "ด้านซ้าย" ; -- src=panlex
lin flee_V2 = mkV2 "รีบเผ่น" ; ---- | mkV "หนี" | mkV "โกย" | mkV "หลบหนี" | mkV "เผ่นหนี" ; -- src=panlex
lin flee_V = mkV "รีบเผ่น" | mkV "หนี" | mkV "โกย" | mkV "หลบหนี" | mkV "เผ่นหนี" ; -- src=panlex
lin yield_V2 = variants{} ; -- 
lin discount_N = mkN "ส่วนลด" | mkN "การลดราคา" | mkN "อัตราส่วนลด" | mkN "การลดราคา" ; -- src=panlex
lin above_A = mkA "ข้างต้น" ; -- src=panlex
lin uncle_N = mkN "ลุง" | mkN "ที่ปรึกษา" | mkN "อา" | mkN "ลุง" | mkN "คุณอา" | mkN "อาเขย" | mkN "คุณน้า" | mkN "คุณลุง" | mkN "น้าเขย" | mkN "อาผู้ชาย" | mkN "น้าผู้ชาย" | mkN "" ; -- src=panlex
lin audit_N = mkN "การตรวจสอบบัญชี" | mkN "บัญชี" | mkN "เข้าฟัง" | mkN "การตรวจสอบบัญชี" | mkN "การวัดประสิทธิภาพ" ; -- src=panlex
lin advertisement_N = mkN "โฆษณา" | mkN "การโฆษณา" | mkN "การโฆษณา" | mkN "คําโฆษณา" | mkN "การแจ้งความ" | mkN "คําแจ้งความ" ; -- src=panlex
lin explosion_N = mkN "การระเบิด" | mkN "เสียงระเบิด" | mkN "การระเบิดทราย" | mkN "การทำให้ระเบิด" | mkN "การระเบิดรุนแรง" | mkN "การปะทุ" | mkN "การระเบิด" | mkN "เสียงระเบิด" | mkN "การบันดาลอารมณ์อย่างกะทันหัน" ; -- src=panlex
lin contrary_A = mkA "ตรงกันข้าม" | mkA "ตรงกันข้าม" | mkA "ซึ่งขัดแย้งกัน" | mkA "ซึ่งเป็นอุปสรรค" ; -- src=panlex
lin tribunal_N = mkN "ศาล" | mkN "ศาลตุลาการ" | mkN "บัลลังก์" | mkN "ศาลยุติธรรม" | mkN "บัลลังก์ตุลาการ" | mkN "บัลลังก์พิจารณาพิพากษาอรรถคดี" ; -- src=panlex
lin swallow_V2 = mkV2 "กลืน" ; ---- | mkV "กลืนกิน" | mkV "กล้ำกลืน" | mkV "ถอนคำพูด" | mkV "พูดคลุมเครือ" | mkV "กล้ำกลืนฝืนทน" | mkV "กลืน" | mkV "ขยอก" | mkV "อดทน" | mkV "ฝืนทน" | mkV "ดูดกลืน" | mkV "ท่วมท้น" | mkV "หลงเชื่อ" | mkV "กล้ํากลืน" | mkV "คืนคําพูด" | mkV "ถอนคําพูด" | mkV "กลืนเข้าไป" | mkV "พูดกลับคํา" | mkV "ข่มความรู้สึก" | mkV "อดกลั้นความรู้สึก" ; -- src=panlex
lin swallow_V = mkV "กลืน" | mkV "กลืนกิน" | mkV "กล้ำกลืน" | mkV "ถอนคำพูด" | mkV "พูดคลุมเครือ" | mkV "กล้ำกลืนฝืนทน" | mkV "กลืน" | mkV "ขยอก" | mkV "อดทน" | mkV "ฝืนทน" | mkV "ดูดกลืน" | mkV "ท่วมท้น" | mkV "หลงเชื่อ" | mkV "กล้ํากลืน" | mkV "คืนคําพูด" | mkV "ถอนคําพูด" | mkV "กลืนเข้าไป" | mkV "พูดกลับคํา" | mkV "ข่มความรู้สึก" | mkV "อดกลั้นความรู้สึก" ; -- src=panlex
lin typically_Adv = variants{} ; -- 
lin fun_A = mkA "ตลก" | mkA "เฮฮา" | mkA "สนุกสนาน" | mkA "ครื้นเครง" ; -- src=panlex
lin rat_N = mkN "สาย" | mkN "หนู" | mkN "คนโง่" | mkN "คนทรยศ" | mkN "คนไร้ค่า" | mkN "คนไม่เอาไหน" | mkN "คนน่ารังเกียจ" | mkN "คนงานที่ไม่หยุดงานประท้วง" | mkN "หนู" | mkN "มุสิก" | mkN "คนทรยศ" | mkN "คนเนรคุณ" | mkN "หญิงชั่ว" | mkN "ม้วนผมปลอม" | mkN "ผู้สื่อข่าว" | mkN "คนที่ทิ้งเพื่อนยามยาก" ; -- src=panlex
lin cloth_N = mkN "ผ้า" | mkN "สิ่งทอ" | mkN "ผ้า" | mkN "เสื้อผ้า" ; -- src=panlex
lin cable_N = mkN "สายส่ง" | mkN "โทรเลข" | mkN "ความยาว" | mkN "สายเคเบิล" | mkN "เคเบิลทีวี" | mkN "ระบบส่งสัญญาณ" | mkN "การแพร่ภาพทางเคเบิลทีวี" | mkN "โทรเลข" | mkN "สายเคเบิ้ล" | mkN "เชือกหรือเหล็กเส้นขนาดใหญ่" | mkN "ระบบโทรทัศน์ที่ส่งสัญญาณผ่านสายเคเบิ้ล" ; -- src=panlex
lin interrupt_V2 = mkV2 "ยุติ" ; ---- | mkV "ทำลาย" | mkV "รบกวน" | mkV "ขัดจังหวะ" | mkV "ทำให้สิ้นสุด" | mkV "ขัด" | mkV "หยุด" | mkV "แทรก" | mkV "รบกวน" | mkV "ยับยั้ง" | mkV "สอดแทรก" | mkV "ขัดจังหวะ" | mkV "ทําให้หยุดชะงัก" ; -- src=panlex
lin interrupt_V = mkV "ยุติ" | mkV "ทำลาย" | mkV "รบกวน" | mkV "ขัดจังหวะ" | mkV "ทำให้สิ้นสุด" | mkV "ขัด" | mkV "หยุด" | mkV "แทรก" | mkV "รบกวน" | mkV "ยับยั้ง" | mkV "สอดแทรก" | mkV "ขัดจังหวะ" | mkV "ทําให้หยุดชะงัก" ; -- src=panlex
lin crash_N = mkN "การชน" | mkN "การยุบ" | mkN "คอมเจ๊ง" | mkN "การล้มละลาย" | mkN "เครื่องคอมเจ๊ง" | mkN "คอมพิวเตอร์เสีย" | mkN "เสียงก้องกังวาน" | mkN "เสียงก้องสะท้อน" | mkN "อุบัติเหตุร้ายแรง" | mkN "เครื่องคอมพิวเตอร์เสีย" | mkN "เครื่องคอมพิวเตอร์ชำรุด" | mkN "การชน" | mkN "การล้มละลาย" | mkN "ผ้าเนื้อหยาบ" | mkN "เสียงดังที่เกิดจากการชน" ; -- src=panlex
lin flame_N = mkN "การลุกไหม้" | mkN "การลุกเป็นไฟ" | mkN "ไฟ" | mkN "เปลว" | mkN "คนรัก" | mkN "สีส้ม" | mkN "ที่รัก" | mkN "เปลวไฟ" | mkN "สีแดงจ้า" | mkN "เปลวเพลิง" | mkN "ความรุ่มร้อน" | mkN "ความรู้สึกที่รุนแรง" | mkN "ความเร่าร้อนของอารมณ์" ; -- src=panlex
lin controversy_N = mkN "การโต้เถียง" | mkN "การโต้ความ" | mkN "การโต้เถียง" | mkN "การทะเลาะวิวาท" | mkN "การโต้เถียงอย่างรุนแรง" ; -- src=panlex
lin rabbit_N = mkN "กระต่าย" | mkN "ขนกระต่าย" | mkN "เจ้าหูยาว" | mkN "เนื้อกระต่าย" | mkN "กระต่าย" | mkN "ขนกระต่าย" | mkN "เนื้อกระต่าย" | mkN "หนังขนกระต่าย" ; -- src=panlex
lin everyday_A = mkA "ลำลอง" | mkA "สามัญ" | mkA "ทุกวัน" | mkA "ธรรมดา" | mkA "คนธรรมดา" | mkA "ไม่น่าสนใจ" | mkA "ซึ่งเกิดขึ้นทุกวัน" | mkA "ซึ่งใช้สําหรับงานประจําวัน" | mkA "ซึ่งเหมาะสําหรับใช้ในชีวิตประจําวัน" ; -- src=panlex
lin allegation_N = mkN "ข้อหา" | mkN "มลทิน" | mkN "ข้อกล่าวหา" | mkN "ข้อหา" | mkN "กล่าวหา" | mkN "การอ้าง" | mkN "ข้ออ้าง" | mkN "การยืนยัน" | mkN "ข้อยืนยัน" | mkN "การกล่าวหา" | mkN "ข้อกล่าวหา" ; -- src=panlex
lin strip_N = mkN "แถบ" | mkN "ลานบิน" | mkN "ชิ้นยาว" | mkN "ภาพการ์ตูน" | mkN "ภาพวาดการ์ตูน" | mkN "ระบำเปลื้องผ้า" | mkN "สิ่งที่เป็นแถบ" | mkN "ริ้ว" | mkN "ชิ้นยาว" | mkN "แผ่นยาว" | mkN "ลานสนามบิน" | mkN "การ์ตูนเรื่องยาว" | mkN "การเต้นระบําเปลื้องผ้า" | mkN "ภาพแสดงเรื่องราวเป็นตอนๆ" | mkN "ถนนที่มีร้านค้าสองข้างทาง" | mkN "ทางยาวสําหรับเครื่องบินขึ้นลง" ; -- src=panlex
lin stability_N = mkN "เสถียรภาพ" | mkN "ความมั่นคง" | mkN "ความแน่วแน่" | mkN "ความเด็ดเดี่ยว" ; -- src=panlex
lin tide_N = mkN "น้ำขึ้นน้ำลง" | mkN "ช่วงน้ำขึ้นน้ำลง" | mkN "ปรากฏการณ์น้ำขึ้นน้ำลง" | mkN "ฤดู" | mkN "เทศกาล" | mkN "แนวโน้ม" | mkN "กระแสน้ำ" | mkN "ช่วงเวลา" | mkN "กระแสน้ํา" | mkN "วิกฤติกาล" | mkN "สิ่งที่ขึ้น ๆ ลง ๆ สลับกัน" | mkN "สิ่งที่ขึ้นๆ ลงๆ" | mkN "โอกาสที่เหมาะ" | mkN "น้ําขึ้นน้ําลง" | mkN "ช่วงระยะเวลาหนึ่ง" | mkN "กระแสน้ําขึ้นน้ําลง" | mkN "ปรากฏการณ์น้ําขึ้นน้ําลง" ; -- src=panlex
lin illustration_N = mkN "ตัวอย่าง" | mkN "ภาพประกอบ" | mkN "ภาพอธิบาย" | mkN "รูปประกอบ" | mkN "ความชัดเจน" | mkN "การยกตัวอย่าง" | mkN "การใส่ตัวอย่าง" | mkN "การแสดงด้วยตัวอย่าง" | mkN "การให้ตัวอย่างประกอบ" | mkN "การอธิบายด้วยภาพประกอบ" ; -- src=panlex
lin insect_N = mkN "แมง" | mkN "แมลง" | mkN "แมง" | mkN "แมลง" | mkN "คนเลวทราม" | mkN "บุคคลที่ดูถูก" ; -- src=panlex
lin correspondent_N = mkN "คนเขียนจดหมาย" | mkN "ผู้เขียนจดหมาย" | mkN "นักหนังสือพิมพ์" | mkN "นักข่าว" | mkN "สิ่งตรงกัน" | mkN "ซึ่งลงรอยกัน" | mkN "ผู้ส่งจดหมาย" | mkN "ซึ่งเหมือนกัน" | mkN "ผู้ติดต่อจดหมาย" | mkN "สิ่งที่เป็นคู่กัน" | mkN "ผู้ติดต่อกันทางจดหมาย" | mkN "บุคคลหรือบริษัทที่ติดต่อกัน" ; -- src=panlex
lin devise_V2 = variants{} ; -- 
lin determined_A = mkA "ดึงดัน" | mkA "แน่นอน" | mkA "ดื้อดึง" | mkA "แน่วแน่" | mkA "ตั้งใจจริง" | mkA "เด็ดเดี่ยว" | mkA "ซึ่งมุ่งมั่น" | mkA "ซึ่งตัดสินแล้ว" | mkA "ไม่ประนีประนอม" | mkA "ซึ่งตัดสินใจแล้ว" | mkA "ซึ่งไม่ยอมเปลี่ยน" ; -- src=panlex
lin brush_V2 = mkV2 "ระ" ; ---- | mkV "แปรง" | mkV "ทาด้วยแปรง" | mkV "ปัดด้วยแปรง" | mkV "ปัด" | mkV "กวาด" | mkV "แปรง" ; -- src=panlex
lin brush_V = mkV "ระ" | mkV "แปรง" | mkV "ทาด้วยแปรง" | mkV "ปัดด้วยแปรง" | mkV "ปัด" | mkV "กวาด" | mkV "แปรง" ; -- src=panlex
lin adjustment_N = mkN "การดัดแปลง" | mkN "การปรับเปลี่ยน" | mkN "การจัด" | mkN "ตัวปรับ" | mkN "การแก้ไข" | mkN "การปรองดอง" | mkN "การปรับตัว" | mkN "การปรับเปลี่ยน" ; -- src=panlex
lin controversial_A = mkA "ซึ่งชอบโต้คารม" | mkA "ซึ่งชอบโต้แย้ง" | mkA "ซึ่งชอบสําบัดสํานวน" | mkA "" | mkA "เกี่ยวกับการโต้เถียง" | mkA "ซึ่งก่อให้เกิดการโต้แย้ง" ; -- src=panlex
lin organic_A = mkA "เกี่ยวกับอวัยวะ" | mkA "ซึ่งมาจากสิ่งมีชีวิต" | mkA "เกี่ยวกับสารอินทรีย์" | mkA "เกี่ยวกับสิ่งมีชีวิต" ; -- src=panlex
lin escape_N = mkN "การรั่ว" | mkN "การหลบหนี" | mkN "การรั่วไหล" | mkN "ลิ้นนิรภัย" | mkN "การหลีกเลี่ยง" | mkN "การหนีความจริง" | mkN "วาล์วระบายฉุกเฉิน" | mkN "การหลบ" | mkN "การหลบหนี" ; -- src=panlex
lin thoroughly_Adv = variants{} ; -- 
lin interface_N = mkN "พอร์ต" | mkN "อินเตอร์เฟซ" | mkN "จุดเชื่อมต่อ" | mkN "โปรแกรมต่อประสาน" | mkN "ส่วนต่อประสานกับผู้ใช้" | mkN "อินเตอร์เฟส" | mkN "พื้นที่ร่วมของสองสิ่ง" | mkN "จุดที่สองสิ่งสัมผัสกัน" ; -- src=panlex
lin historic_A = mkA "แห่งประวัติศาสตร์" | mkA "ซึ่งเป็นเหตุการณ์สำคัญในประวัติศาสตร์" | mkA "เกี่ยวกับประวัติศาสตร์" | mkA "ที่สําคัญในประวัติศาสตร์" | mkA "ซึ่งเกี่ยวกับประวัติศาสตร์" | mkA "ซึ่งเกิดขึ้นในประวัติศาสตร์" ; -- src=panlex
lin collapse_N = mkN "การพัง" | mkN "การยุบ" | mkN "การล้ม" | mkN "การพังทลาย" | mkN "การล้มละลาย" | mkN "การพังทลาย" | mkN "การล้มป่วย" | mkN "ความล้มเหลว" ; -- src=panlex
lin temple_N = mkN "วัด" | mkN "ขมับ" | mkN "วัดวา" | mkN "อาราม" | mkN "วัดวาอาราม" | mkN "สุเหร่ายิว" | mkN "วัด" | mkN "ขมับ" | mkN "วิหาร" | mkN "อาราม" | mkN "โบสถ์" | mkN "วัดวาอาราม" ; -- src=panlex
lin shade_N = mkN "ผี" | mkN "ร่ม" | mkN "เงา" | mkN "เฉด" | mkN "ผีสาง" | mkN "เฉดสี" | mkN "โทนสี" | mkN "ร่มเงา" | mkN "วิญญาณ" | mkN "ที่บังแดด" | mkN "ความแตกต่างทางความหมาย" | mkN "ความแตกต่างเพียงเล็กน้อย" | mkN "ผี" | mkN "ร่ม" | mkN "กะบัง" | mkN "บังตา" | mkN "ปีศาจ" | mkN "ที่ร่ม" | mkN "บังร่ม" | mkN "บังเงา" | mkN "บังแดด" | mkN "เงามืด" | mkN "ความมืด" | mkN "โป๊ะโคม" | mkN "ระบายเงา" | mkN "ที่กําบัง" | mkN "ที่บังแดด" | mkN "ทําให้สลัว" | mkN "ลําดับแลเงา" | mkN "เงามืดในภาพ" | mkN "ทําให้มืดมัว" | mkN "ความคลุมเครือ" | mkN "สิ่งที่ใช้บัง" | mkN "จํานวนเล็กน้อย" | mkN "เครื่องเตือนความจํา" | mkN "ปริมาณสีที่แตกต่างกันเล็กน้อย" ; -- src=panlex
lin craft_N = mkN "ยาน" | mkN "ช่าง" | mkN "งานฝีมือ" | mkN "หัตถ์ศิลป์" | mkN "ทักษะการช่าง" | mkN "ทักษะการทำงาน" | mkN "ความมีเล่ห์เหลี่ยม" | mkN "ทักษะ" | mkN "ฝีมือ" | mkN "ยานพาหนะ" | mkN "ทักษะการโกง" | mkN "การทํางานศิลปะด้วยมือ" | mkN "งานศิลปะที่ต้องทําด้วยมือ" ; -- src=panlex
lin nursery_N = mkN "เรือนกระจก" | mkN "เรือนเพาะชำ" | mkN "ห้องเนสเซอรี่" | mkN "ห้องทารกแรกเกิด" | mkN "สถานที่ปลูกต้นไม้" | mkN "สถานรับเลี้ยงเด็ก" | mkN "ห้องหรือสถานที่เลี้ยงเด็ก" ; -- src=panlex
lin piano_N = mkN "เปียโน" | mkN "เปียนโน" ; -- src=panlex
lin desirable_A = mkA "น่าปรารถนา" | mkA "ดีเลิศ" | mkA "น่าเอา" | mkA "น่ายินดี" | mkA "น่าปรารถนา" | mkA "ซึ่งถูกอกถูกใจ" | mkA "เป็นที่ชื่นชอบ" | mkA "เป็นที่ต้องการ" | mkA "เป็นที่น่าพอใจ" ; -- src=panlex
lin assurance_N = mkN "คำรับรอง" | mkN "การประกันภัย" | mkN "เชื่อมั่นในตัวเอง" | mkN "ความเชื่อมั่นในตนเอง" | mkN "ความเชื่อมั่นในตัวเอง" | mkN "คําสัญญา" | mkN "การรับรอง" | mkN "ความมั่นใจ" | mkN "ความแน่นอน" | mkN "ความบ้าบิ่น" | mkN "การประกันภัย" | mkN "การรับประกัน" | mkN "ความเชื่อถือ" | mkN "ความเชื่อมั่น" | mkN "การทําให้มั่นใจ" | mkN "การทําให้แน่นอน" | mkN "การโอนทรัพย์สิน" | mkN "ความไม่กลัวเกรง" | mkN "การทําให้เชื่อมั่น" ; -- src=panlex
lin jurisdiction_N = mkN "อํานาจศาล" | mkN "ขอบเขตอํานาจ" | mkN "อํานาจการควบคุม" | mkN "อํานาจในการตัดสินคดี" | mkN "ขอบเขตอํานาจที่ศาลและกฏหมายควบคุมไปถึง" ; -- src=panlex
lin advertise_V2 = mkV2 "โฆษณา" ; ---- | mkV "โปรโมท" | mkV "ป่าวประกาศ" | mkV "ประชาสัมพันธ์" | mkV "โฆษณาประชาสัมพันธ์" | mkV "ลงโฆษณา" | mkV "ลงประกาศ" | mkV "เสนอข่าว" | mkV "แจ้งความ" ; -- src=panlex
lin advertise_V = mkV "โฆษณา" | mkV "โปรโมท" | mkV "ป่าวประกาศ" | mkV "ประชาสัมพันธ์" | mkV "โฆษณาประชาสัมพันธ์" | mkV "ลงโฆษณา" | mkV "ลงประกาศ" | mkV "เสนอข่าว" | mkV "แจ้งความ" ; -- src=panlex
lin bay_N = mkN "มุข" | mkN "อ่าว" | mkN "ติ่งห้อง" | mkN "เสียงหอน" | mkN "ต้นอบเชยเดือน" | mkN "ม้าสีน้ำตาลแดง" | mkN "ที่ว่างที่จัดไว้" | mkN "ที่ว่างที่จัดไว้ในเครื่องบิน" | mkN "มุข" | mkN "อ่าว" | mkN "การอับจน" | mkN "เสียงหอน" | mkN "สีน้ําตาลแดง" | mkN "ต้นอบเชยเดือน" | mkN "ม้าสีน้ําตาลแดง" | mkN "ที่เว้าของเทือกเขา" | mkN "ม้าที่มีสีน้ําตาลแดง" | mkN "เวิ้งในห้องระหว่างเสาสองต้น" | mkN "พื้นที่หรือบริเวณที่กําหนดไว้" | mkN "ใบพืชที่มีกลิ่นหอมใช้ปรุงอาหาร" ; -- src=panlex
lin specification_N = mkN "เกณฑ์" | mkN "รายการ" | mkN "โครงการ" | mkN "การจํากัด" | mkN "การเจาะจง" | mkN "ข้อจํากัด" | mkN "รายละเอียด" | mkN "การกําหนดเฉพาะ" ; -- src=panlex
lin disability_N = mkN "ความพิการ" | mkN "ความบกพร่อง" | mkN "ความทุพพลภาพ" | mkN "ความพิการ" | mkN "การไร้กําลัง" | mkN "การถูกตัดสิทธิ์" | mkN "การไร้ความสามารถ" ; -- src=panlex
lin presidential_A = mkA "เกี่ยวกับประธานาธิบดี" ; -- src=panlex
lin arrest_N = mkN "การหยุด" | mkN "การจับกุม" | mkN "การหยุดชะงัก" | mkN "การลากคอเข้าคุก" | mkN "การชะงัก" | mkN "การจับกุม" | mkN "การหยุดอย่างกระทันหัน" ; -- src=panlex
lin unexpected_A = mkA "ฉับพลัน" | mkA "นึกไม่ถึง" | mkA "ประหลาดใจ" | mkA "ที่ไม่ได้คาดไว้" | mkA "ไม่ได้คาดคิดมาก่อน" ; -- src=panlex
lin switch_N = mkN "สวิตช์" | mkN "ไม้เรียว" | mkN "รางสับหลีก" | mkN "สวิตช์ไฟฟ้า" | mkN "การซ้อนตำแหน่ง" | mkN "การเปลี่ยนตำแหน่ง" | mkN "ฉก" | mkN "ฉวย" | mkN "หัน" | mkN "หันเห" | mkN "แกว่ง" | mkN "การหวด" | mkN "สวิตช์" | mkN "สะพานไฟ" | mkN "ไม้เท้า" | mkN "ไม้เรียว" | mkN "กระดิกหาง" | mkN "การแทนที่" | mkN "ไม้เฆี่ยน" | mkN "การเปลี่ยน" | mkN "การเปิดปิด" | mkN "ที่เปิดปิด" | mkN "สับเปลี่ยน" | mkN "หัวเปิดปิด" | mkN "เครื่องปิด/เปิดไฟฟ้า" | mkN "การสับเปลี่ยน" | mkN "เครื่องเปลี่ยน" | mkN "สับเปลี่ยนกระแสไฟ" | mkN "ไม้ยางสําหรับเฆี่ยนตี" | mkN "การเปลี่ยนแปลงอย่างทันที" | mkN "เฆี่ยนหรือหวดด้วยไม้เรียว" | mkN "การเปลี่ยนแปลงอย่างกระทันหัน" ; -- src=panlex
lin penny_N = mkN "เซนต์" | mkN "เพนนี" | mkN "เหรียญเพนนี" | mkN "เหรียญเพนนีของอังกฤษมีค่าเท่ากับ 1/12 ชิลลิง" ; -- src=panlex
lin respect_V2 = variants{} ; -- 
lin celebration_N = mkN "พิธีการ" | mkN "การเฉลิมฉลอง" | mkN "งานเฉลิมฉลอง" | mkN "การฉลอง" | mkN "งานฉลอง" | mkN "งานมงคล" | mkN "งานสมโภช" | mkN "งานเลี้ยง" | mkN "งานรื่นเริง" | mkN "งานสังสรรค์" | mkN "การเฉลิมฉลอง" | mkN "งานกินเลี้ยง" | mkN "งานเฉลิมฉลอง" | mkN "งานพบปะสังสรรค์" ; -- src=panlex
lin gross_A = mkA "รวม" | mkA "หนา" | mkA "หยาบ" | mkA "เหมา" | mkA "แน่น" | mkA "ใหญ่" | mkA "ยอดรวม" | mkA "ต่ําช้า" | mkA "ทั้งหมด" | mkA "หยาบคาย" | mkA "หยาบช้า" | mkA "อ้วนมาก" | mkA "เลวร้าย" | mkA "อ้วนเผละ" | mkA "จํานวนมาก" | mkA "จํานวนมาก ๆ" | mkA "หนึ่งกุรุส" | mkA "ไม่เหมาะสม" | mkA "โดยไม่มีการลด" | mkA "ใหญ่เบ้อเริ่ม" | mkA "จํานวนส่วนใหญ่" | mkA "น่าสะอิดสะเอียน" | mkA "รายได้ทั้งหมดที่ยังไม่ได้หัก" ; -- src=panlex
lin aid_V2 = mkV2 "ช่วย" ; ---- | mkV "ช่วยเหลือ" | mkV "ช่วยเหลือ" | mkV "สงเคราะห์" | mkV "เกื้อหนุน" | mkV "อนุเคราะห์" ; -- src=panlex
lin aid_V = mkV "ช่วย" | mkV "ช่วยเหลือ" | mkV "ช่วยเหลือ" | mkV "สงเคราะห์" | mkV "เกื้อหนุน" | mkV "อนุเคราะห์" ; -- src=panlex
lin superb_A = mkA "รวย" | mkA "วิเศษ" | mkA "ดีเลิศ" | mkA "มากมาย" | mkA "หรูหรา" | mkA "โอ่อ่า" | mkA "สง่างาม" | mkA "ดีเยี่ยม" | mkA "ใหญ่ยิ่ง" | mkA "ฟุ่มเฟือย" | mkA "ยอดเยี่ยม" | mkA "ยอมเยี่ยม" ; -- src=panlex
lin process_V2 = mkV2 "ขึ้นรูป" ; ---- | mkV "ฟ้องคดี" | mkV "เดินแถว" | mkV "ฟ้องร้อง" | mkV "เดินขบวน" | mkV "ดำเนินการ" | mkV "ดำเนินคดี" | mkV "เคลื่อนขบวน" | mkV "ดําเนินการ" | mkV "ลงมือปฏิบัติ" ; -- src=panlex
lin process_V = mkV "ขึ้นรูป" | mkV "ฟ้องคดี" | mkV "เดินแถว" | mkV "ฟ้องร้อง" | mkV "เดินขบวน" | mkV "ดำเนินการ" | mkV "ดำเนินคดี" | mkV "เคลื่อนขบวน" | mkV "ดําเนินการ" | mkV "ลงมือปฏิบัติ" ; -- src=panlex
lin innocent_A = mkA "สะอาด" | mkA "ใสซื่อ" | mkA "บริสุทธิ์" | mkA "อินโนเซนต์" | mkA "อ่อนต่อโลก" | mkA "ไร้เดียงสา" | mkA "ปราศจากมลทิน" | mkA "ที่ไม่มีกิเลส" | mkA "ซื่อ" | mkA "คนโง่" | mkA "ใสซื่อ" | mkA "ไร้มลทิน" | mkA "เด็กเล็ก ๆ ผู้ไม่มีมายา" | mkA "บริสุทธิ์" | mkA "ไม่รุนแรง" | mkA "ไม่รู้ตัว" | mkA "ไม่เป็นภัย" | mkA "ไร้เดียงสา" | mkA "ซึ่งไร้เดียงสา" | mkA "ซึ่งไม่มีพิษภัย" ; -- src=panlex
lin leap_V2 = mkV2 "โดด" ; ---- | mkV "โดดลง" | mkV "กระโจน" | mkV "กระโดด" | mkV "ทิ้งตัว" | mkV "กระโดดลง" | mkV "ทำให้กระโดด" | mkV "บังคับให้กระโดด" | mkV "โดด" | mkV "ข้าม" | mkV "กระโจน" | mkV "กระโดด" | mkV "ผ่านข้าม" | mkV "ทําให้กระโดด" | mkV "ดําเนินการอย่างรวดเร็ว" | mkV "เคลื่อนไหวอย่างรวดเร็ว" ; -- src=panlex
lin leap_V = mkV "โดด" | mkV "โดดลง" | mkV "กระโจน" | mkV "กระโดด" | mkV "ทิ้งตัว" | mkV "กระโดดลง" | mkV "ทำให้กระโดด" | mkV "บังคับให้กระโดด" | mkV "โดด" | mkV "ข้าม" | mkV "กระโจน" | mkV "กระโดด" | mkV "ผ่านข้าม" | mkV "ทําให้กระโดด" | mkV "ดําเนินการอย่างรวดเร็ว" | mkV "เคลื่อนไหวอย่างรวดเร็ว" ; -- src=panlex
lin colony_N = mkN "ฝูงสัตว์" | mkN "อาณานิคม" | mkN "เมืองขึ้น" | mkN "กล