--# -path=.:../../maltese

-- Maltese translation dictionary
-- started by Aarne Ranta 2015
-- based on Maltese resource grammar by John J. Camilleri 2011 -- 2013
-- Licensed under LGPL

concrete TopDictionaryMlt of TopDictionary = CatMlt ** open
  MorphoMlt,
  ResMlt,
  ParadigmsMlt,
  IrregMlt,
  DictMlt,
  (C = ConstructX),
  Prelude

in {

  flags
    coding=utf8 ;

  oper
    fuqP = mkPrep "fuq" ;
    ghandP = mkPrep "għand" ;
    ghalP = mkPrep "għal" ;
    minnP = mkPrep "minn" ;
    goP = mkPrep "ġo" ;
    lilP = mkPrep "lil" ;
    maP = mkPrep "ma'" ;
    taP = mkPrep "ta'" ;
    saP = mkPrep "sa" ;
    biP = mkPrep "bi" ;
    fiP = mkPrep "fi" ;

    lilV2 : V -> V2 ;
    lilV2 v = prepV2 v (mkPrep "lil") ;

    genderedN : N = overload {
      genderedN : Str -> Str -> N = \qattus,qtates ->
        let
          m : N = mkN qattus qtates masculine ;
          f : N = mkN (qattus+"a") qtates feminine ;
        in (m | f) ;
      genderedN : Str -> Str -> Str -> N = \qattus,qattusa,qtates ->
        let
          m : N = mkN qattus qtates masculine ;
          f : N = mkN qattusa qtates feminine ;
        in (m | f) ;
      } ;

    af_V = irregularV form1 (ResMlt.mkRoot "'-'-f") (ResMlt.mkVowels "a" [])
      "kont naf" "kont taf" "kien jaf" "kienet taf" "konna nafu" "kontu tafu" "kienu jafu" --- will fail for negative
      "naf" "taf" "jaf" "taf" "nafu" "tafu" "jafu"
      "kun af" "kunu afu"
      ;
    sata'_V = mkV "sata'" (ResMlt.mkRoot "s-t-għ") ;
    ried_V = mkV "ried" (ResMlt.mkRoot "r-j-d") ;
    kellu_V = irregularV form1 (ResMlt.mkRoot) (ResMlt.mkVowels)
      "kelli" "kellek" "kellu" "kellha" "kellna" "kellkom" "kellhom"
      "għandi" "għandek" "għandu" "għandha" "għandna" "għandkom" "għandhom"
      "kollok" "kollkom"
      ;


lin of_Prep = prep_ta ; -- 
lin and_Conj = mkConj "u" ;
lin in_Prep = mkPrep "fi" "f'" "fil-" "fit-" "fl-" ;
lin have_VV = variants{}; -- dirV2 (kellu_V) ;
lin have_V2 = dirV2 (kellu_V) ;
lin have_V = kellu_V ;
lin it_Pron = he_Pron ;
lin to_Prep = mkPrep "lil" "lill-" "lit-" ;
lin for_Prep = mkPrep "għal" "għall-" "għall-" "għat-" "għall-" "għalija" "għalik" "għalih" "għaliha" "għalina" "għalikom" "għalihom" True ;
lin i_Pron = mkPron "jien" "i" singular P1 masculine ; --- also JIENA
lin iFem_Pron = variants{} ; -- 
lin that_Subj = ss "li" ;
lin he_Pron = mkPron "hu" "u" singular P3 masculine ; --- also HUWA
lin on_Prep = mkPrep "fuq" ;
lin with_Prep = mkPrep "ma'" "m'" "mal-" "mat-" "mal-" ;
lin do_V2 = dirV2 (ghamel_GHML_1_10544_V) ;
lin at_Prep = variants{} ; -- 
lin by_Prep = variants{} ; -- 
lin but_Conj = variants{} ; -- 
lin from_Prep = mkPrep "mingħand" ;
lin they_Pron = mkPron "huma" "hom" plural P3 masculine ;
lin theyFem_Pron = variants{} ; -- 
lin she_Pron = mkPron "hi" "ha" singular P3 feminine ; --- also HIJA
lin or_Conj = mkConj "jew" ;
lin as_Subj = variants{} ; -- 
lin we_Pron = mkPron "aħna" "na" plural P1 masculine ;
lin weFem_Pron = variants{} ; -- 
lin say_VS = qal_QWL_1_9357_V ;
lin say_V2 = variants{}; -- qal_QWL_1_9357_V ;
lin say_V = variants{}; -- qal_QWL_1_9357_V ;
lin if_Subj = ss "jekk" ;
lin go_VV = variants{}; -- mar_MWR_1_8918_V ;
lin go_VA = variants{}; -- mar_MWR_1_8918_V ;
lin go_V = mar_MWR_1_8918_V ;
lin get_VV = variants{} ; -- 
lin get_V2V = variants{} ; -- 
lin make_V2V = variants{} ; -- 
lin make_V2A = variants{} ; -- 
lin make_V2 = variants{} ; -- 
lin make_V = variants{} ; -- 
lin as_Prep = variants{} ; -- 
lin out_Adv = variants{} ; -- 
lin up_Adv = variants{} ; -- 
lin see_VS = variants{}; -- lilV2 (ra_R'J_1_9513_V) ;
lin see_VQ = variants{}; -- lilV2 (ra_R'J_1_9513_V) ;
lin see_V2V = variants{}; -- lilV2 (ra_R'J_1_9513_V) ;
lin see_V2 = lilV2 (ra_R'J_1_9513_V) ;
lin see_V = variants{}; -- lilV2 (ra_R'J_1_9513_V) ;
lin know_VS = af_''F_1_10774_V ;
lin know_VQ = af_''F_1_10774_V ;
lin know_V2 = lilV2 (af_''F_1_10774_V) ;
lin know_V = variants{}; -- lilV2 (af_''F_1_10774_V) ;
lin time_N = variants{} ; -- 
lin time_2_N = variants{} ; -- 
lin time_1_N = variants{} ; -- 
lin take_V2 = variants{} ; -- 
lin so_Adv = variants{} ; -- 
lin year_N = mkNDual "sena" "sentejn" "snin" ;
lin into_Prep = variants{} ; -- 
lin then_Adv = variants{} ; -- 
lin think_VS = variants{}; -- haseb_HSB_1_8387_V ;
lin think_V2 = variants{}; -- haseb_HSB_1_8387_V ;
lin think_V = haseb_HSB_1_8387_V ;
lin come_V = gie_GJ'_1_8123_V ;
lin than_Subj = variants{} ; -- 
lin more_Adv = variants{} ; -- 
lin about_Prep = variants{} ; -- 
lin now_Adv = mkAdv "issa" ;
lin last_A = variants{} ; -- 
lin last_1_A = variants{} ; -- 
lin last_2_A = variants{} ; -- 
lin other_A = variants{} ; -- 
lin give_V3 = mkV3 ta_GHTJ_1_10767_V lilP ;
lin give_V2 = variants{}; -- mkV3 ta_GHTJ_1_10767_V lilP ;
lin give_V = variants{}; -- mkV3 ta_GHTJ_1_10767_V lilP ;
lin just_Adv = variants{} ; -- 
lin people_N = variants{} ; -- 
lin also_Adv = variants{} ; -- 
lin well_Adv = variants{} ; -- 
lin only_Adv = variants{} ; -- 
lin new_A = brokenA "ġdid" "ġodda" ;
lin when_Subj = ss "meta" ;
lin way_N = variants{} ; -- 
lin way_2_N = variants{} ; -- 
lin way_1_N = variants{} ; -- 
lin look_VA = variants{} ; -- 
lin look_V2 = variants{} ; -- 
lin look_V = variants{} ; -- 
lin like_Prep = variants{} ; -- 
lin use_VV = variants{} ; -- 
lin use_V2 = variants{} ; -- 
lin use_V = variants{} ; -- 
lin because_Subj = ss "għax" ;
lin good_A = mkA "tajjeb" "tajba" "tajbin" ;
lin find_VS = variants{}; -- lilV2 (sab_SJB_1_9779_V) ;
lin find_V2A = variants{}; -- lilV2 (sab_SJB_1_9779_V) ;
lin find_V2 = lilV2 (sab_SJB_1_9779_V) ;
lin find_V = variants{}; -- lilV2 (sab_SJB_1_9779_V) ;
lin man_N = mkN "raġel" "rġiel" ;
lin want_VV = ried_V ;
lin want_V2V = variants{}; -- ried_V ;
lin want_V2 = variants{}; -- ried_V ;
lin want_V = variants{}; -- ried_V ;
lin day_N = mkN "ġurnata" "ġranet" ;
lin between_Prep = mkPrep "bejn" ;
lin even_Adv = variants{} ; -- 
lin there_Adv = mkAdv "hemm" ;
lin many_Det = mkDeterminer plural "ħafna" ;
lin after_Prep = mkPrep "wara" ;
lin down_Adv = variants{} ; -- 
lin yeah_Interj = variants{} ; -- 
lin so_Subj = variants{} ; -- 
lin thing_N = variants{} ; -- 
lin tell_VS = variants{} ; -- 
lin tell_V3 = variants{} ; -- 
lin tell_1_V3 = variants{} ; -- 
lin tell_2_V3 = variants{} ; -- 
lin tell_V2V = variants{} ; -- 
lin tell_V2S = variants{} ; -- 
lin tell_V2 = variants{} ; -- 
lin tell_V = variants{} ; -- 
lin through_Prep = mkPrep "minn ġo" "minn ġo" "minn ġol-" "minn ġot-" "minn ġol-" "minn ġo fija" "minn ġo fik" "minn ġo fih" "minn ġo fiha" "minn ġo fina" "minn ġo fikom" "minn ġo fihom" False ;
lin back_Adv = variants{} ; -- 
lin still_Adv = variants{} ; -- 
lin child_N = mkN "tifel / tifla" "tfal" ; -- genderedN
lin here_Adv = mkAdv "hawn" ;
lin over_Prep = variants{} ; -- 
lin too_Adv = variants{} ; -- 
lin put_V2 = lilV2 (qieghed_QGHD_3_9212_V) ;
lin on_Adv = variants{}; -- mkPrep "fuq" ;
lin no_Interj = variants{} ; -- 
lin work_V2 = variants{} ; -- 
lin work_V = variants{} ; -- 
lin work_2_V = variants{} ; -- 
lin work_1_V = variants{} ; -- 
lin become_VA = sar_SJR_1_9797_V ;
lin become_V2 = variants{}; -- sar_SJR_1_9797_V ;
lin become_V = variants{}; -- sar_SJR_1_9797_V ;
lin old_A = brokenA "qadim" "qodma" "eqdem" ; -- xiħ
lin government_N = variants{} ; -- 
lin mean_VV = variants{} ; -- 
lin mean_VS = variants{} ; -- 
lin mean_V2V = variants{} ; -- 
lin mean_V2 = variants{} ; -- 
lin part_N = variants{} ; -- 
lin leave_V2V = variants{}; -- prepV2 (telaq_TLQ_1_9903_V) minnP ;
lin leave_V2 = prepV2 (telaq_TLQ_1_9903_V) minnP ;
lin leave_V = variants{}; -- prepV2 (telaq_TLQ_1_9903_V) minnP ;
lin life_N = variants{} ; -- 
lin great_A = variants{} ; -- 
lin case_N = variants{} ; -- 
lin woman_N = mkN "mara" "nisa" ;
lin over_Adv = variants{} ; -- 
lin seem_VV = variants{} ; -- 
lin seem_VS = variants{} ; -- 
lin seem_VA = variants{} ; -- 
lin work_N = variants{} ; -- 
lin need_VV = variants{} ; -- 
lin need_VV = variants{} ; -- 
lin need_V2 = variants{} ; -- 
lin need_V = variants{} ; -- 
lin feel_VS = variants{} ; -- 
lin feel_VA = variants{} ; -- 
lin feel_V2 = variants{} ; -- 
lin feel_V = variants{} ; -- 
lin system_N = variants{} ; -- 
lin each_Det = variants{} ; -- 
lin may_2_VV = variants{} ; -- 
lin may_1_VV = variants{} ; -- 
lin much_Adv = variants{} ; -- 
lin ask_VQ = variants{}; -- lilV2 (saqsa_SQSJ_1_7268_V) ;
lin ask_V2V = variants{}; -- lilV2 (saqsa_SQSJ_1_7268_V) ;
lin ask_V2 = variants{}; -- lilV2 (saqsa_SQSJ_1_7268_V) ;
lin ask_V = variants{}; -- lilV2 (saqsa_SQSJ_1_7268_V) ;
lin group_N = variants{} ; -- 
lin number_N = mkN "numru" "numrui" ;
lin number_3_N = variants{} ; -- 
lin number_2_N = variants{} ; -- 
lin number_1_N = variants{} ; -- 
lin yes_Interj = variants{} ; -- 
lin however_Adv = variants{} ; -- 
lin another_Det = variants{} ; -- 
lin again_Adv = variants{} ; -- 
lin world_N = variants{} ; -- 
lin area_N = variants{} ; -- 
lin area_6_N = variants{} ; -- 
lin area_5_N = variants{} ; -- 
lin area_4_N = variants{} ; -- 
lin area_3_N = variants{} ; -- 
lin area_2_N = variants{} ; -- 
lin area_1_N = variants{} ; -- 
lin show_VS = variants{} ; -- 
lin show_VQ = variants{} ; -- 
lin show_V2 = variants{} ; -- 
lin show_V = variants{} ; -- 
lin course_N = variants{} ; -- 
lin company_2_N = variants{} ; -- 
lin company_1_N = variants{} ; -- 
lin under_Prep = mkPrep "taħt" ;
lin problem_N = variants{} ; -- 
lin against_Prep = variants{} ; -- 
lin never_Adv = variants{} ; -- 
lin most_Adv = variants{} ; -- 
lin service_N = variants{} ; -- 
lin try_VV = variants{} ; -- 
lin try_V2 = variants{} ; -- 
lin try_V = variants{} ; -- 
lin call_V2 = variants{} ; -- 
lin call_V = variants{} ; -- 
lin hand_N = possN (mkNDual "id" "idejn" "idejn" feminine) ;
lin party_N = variants{} ; -- 
lin party_2_N = variants{} ; -- 
lin party_1_N = variants{} ; -- 
lin high_A = variants{} ; -- 
lin about_Adv = variants{} ; -- 
lin something_NP = regNP "xi ħaġa" ;
lin school_N = mkN "skola" "skejjel" ;
lin in_Adv = variants{}; -- mkPrep "fi" "f'" "fil-" "fit-" "fl-" ;
lin in_1_Adv = variants{} ; -- 
lin in_2_Adv = variants{} ; -- 
lin small_A = brokenA "zgħir" "zgħar" "iżgħar" ;
lin place_N = variants{} ; -- 
lin before_Prep = mkPrep "qabel" "qabli" "qablek" "qablu" "qabilha" "qabilna" "qabilkom" "qabilhom" ;
lin while_Subj = variants{} ; -- 
lin away_Adv = variants{} ; -- 
lin away_2_Adv = variants{} ; -- 
lin away_1_Adv = variants{} ; -- 
lin keep_VV = variants{} ; -- 
lin keep_V2A = variants{} ; -- 
lin keep_V2 = variants{} ; -- 
lin keep_V = variants{} ; -- 
lin point_N = variants{} ; -- 
lin point_2_N = variants{} ; -- 
lin point_1_N = variants{} ; -- 
lin house_N = mkN "dar" "djar" feminine ;
lin different_A = variants{} ; -- 
lin country_N = possN (mkN "pajjiż" "pajjiżi") ;
lin really_Adv = variants{} ; -- 
lin provide_V2 = variants{} ; -- 
lin provide_V = variants{} ; -- 
lin week_N = variants{} ; -- 
lin hold_VS = variants{}; -- lilV2 (zamm_ZMM_1_10392_V) ;
lin hold_V2 = lilV2 (zamm_ZMM_1_10392_V) ;
lin hold_V = variants{}; -- lilV2 (zamm_ZMM_1_10392_V) ;
lin large_A = variants{} ; -- 
lin member_N = variants{} ; -- 
lin off_Adv = variants{} ; -- 
lin always_Adv = variants{}; -- mkAdV "dejjem" ;
lin follow_VS = variants{} ; -- 
lin follow_V2 = variants{} ; -- 
lin follow_V = variants{} ; -- 
lin without_Prep = mkPrep "mingħajr" ;
lin turn_VA = variants{}; -- dar_DWR_1_7803_V ;
lin turn_V2 = variants{}; -- dar_DWR_1_7803_V ;
lin turn_V = dar_DWR_1_7803_V ;
lin end_N = variants{} ; -- 
lin end_2_N = variants{} ; -- 
lin end_1_N = variants{} ; -- 
lin within_Prep = variants{} ; -- 
lin local_A = variants{} ; -- 
lin where_Subj = variants{} ; -- 
lin during_Prep = mkPrep "waqt" ;
lin bring_V3 = variants{} ; -- 
lin bring_V2 = variants{} ; -- 
lin most_Det = variants{} ; -- 
lin word_N = variants{} ; -- 
lin begin_V2 = variants{} ; -- 
lin begin_V = variants{} ; -- 
lin although_Subj = ss "avolja" ;
lin example_N = variants{} ; -- 
lin next_Adv = variants{} ; -- 
lin family_N = variants{} ; -- 
lin rather_Adv = variants{} ; -- 
lin fact_N = variants{} ; -- 
lin like_VV = variants{}; -- lilV2 (ghogob_GHGB_1_10485_V) ;
lin like_VS = variants{}; -- lilV2 (ghogob_GHGB_1_10485_V) ;
lin like_V2 = lilV2 (ghogob_GHGB_1_10485_V) ;
lin social_A = variants{} ; -- 
lin write_VS = variants{}; -- dirV2 (kiteb_KTB_1_8641_V) ;
lin write_V2 = dirV2 (kiteb_KTB_1_8641_V) ;
lin write_V = variants{}; -- dirV2 (kiteb_KTB_1_8641_V) ;
lin state_N = variants{} ; -- 
lin state_2_N = variants{} ; -- 
lin state_1_N = variants{} ; -- 
lin percent_N = variants{} ; -- 
lin quite_Adv = mkAdv "pjuttost" ;
lin both_Det = variants{} ; -- 
lin start_V2 = variants{} ; -- 
lin start_V = variants{} ; -- 
lin run_V2 = variants{}; -- gera_GRJ_1_8131_V ;
lin run_V = gera_GRJ_1_8131_V ;
lin long_A = brokenA "twil" "twal" "itwal" ;
lin right_Adv = variants{} ; -- 
lin right_2_Adv = variants{} ; -- 
lin right_1_Adv = variants{} ; -- 
lin set_V2 = variants{} ; -- 
lin help_V2V = variants{} ; -- 
lin help_V2 = variants{} ; -- 
lin help_V = variants{} ; -- 
lin every_Det = mkDeterminer singular "kull" ;
lin home_N = variants{} ; -- 
lin month_N = variants{} ; -- 
lin side_N = variants{} ; -- 
lin night_N = mkN "lejl" "ljieli" ;
lin important_A = sameA "importanti" ;
lin eye_N = possN (mkNDual "għajn" "għajnejn" "għajnejn" "għejun" feminine) ;
lin head_N = possN (mkN "ras" "rjus" feminine) ;
lin information_N = variants{} ; -- 
lin question_N = mkN "mistoqsija" "mistoqsijiet" ;
lin business_N = variants{} ; -- 
lin play_V2 = prepV2 (laghab_LGHB_1_8724_V) maP ;
lin play_V = daqq_DQQ_1_7736_V ;
lin play_3_V2 = variants{} ; -- 
lin play_3_V = variants{} ; -- 
lin play_2_V2 = variants{} ; -- 
lin play_2_V = variants{} ; -- 
lin play_1_V2 = variants{} ; -- 
lin play_1_V = variants{} ; -- 
lin power_N = variants{} ; -- 
lin money_N = variants{} ; -- 
lin change_N = variants{} ; -- 
lin move_V2 = variants{} ; -- 
lin move_V = variants{} ; -- 
lin move_2_V = variants{} ; -- 
lin move_1_V = variants{} ; -- 
lin interest_N = variants{} ; -- 
lin interest_4_N = variants{} ; -- 
lin interest_2_N = variants{} ; -- 
lin interest_1_N = variants{} ; -- 
lin order_N = variants{} ; -- 
lin book_N = mkN "ktieb" "kotba" ;
lin often_Adv = variants{} ; -- 
lin development_N = variants{} ; -- 
lin young_A = small_A ;
lin national_A = variants{} ; -- 
lin pay_V3 = variants{} ; -- 
lin pay_V2V = variants{} ; -- 
lin pay_V2 = variants{} ; -- 
lin pay_V = variants{} ; -- 
lin hear_VS = variants{}; -- lilV2 (sema'_SMGH_1_9698_V) ;
lin hear_V2V = variants{}; -- lilV2 (sema'_SMGH_1_9698_V) ;
lin hear_V2 = lilV2 (sema'_SMGH_1_9698_V) ;
lin hear_V = variants{}; -- lilV2 (sema'_SMGH_1_9698_V) ;
lin room_N = variants{} ; -- 
lin room_1_N = variants{} ; -- 
lin room_2_N = variants{} ; -- 
lin whether_Subj = variants{} ; -- 
lin water_N = mkN "ilma" "ilmijiet" masculine ;
lin form_N = variants{} ; -- 
lin car_N = mkN "karozza" "karozzi" ;
lin other_N = variants{} ; -- 
lin yet_Adv = variants{} ; -- 
lin yet_2_Adv = variants{} ; -- 
lin yet_1_Adv = variants{} ; -- 
lin perhaps_Adv = variants{} ; -- 
lin meet_V2 = variants{} ; -- 
lin meet_V = variants{} ; -- 
lin level_N = variants{} ; -- 
lin level_2_N = variants{} ; -- 
lin level_1_N = variants{} ; -- 
lin until_Subj = variants{} ; -- 
lin though_Subj = variants{} ; -- 
lin policy_N = variants{} ; -- 
lin include_V2 = variants{} ; -- 
lin include_V = variants{} ; -- 
lin believe_VS = variants{} ; -- 
lin believe_V2 = variants{} ; -- 
lin believe_V = variants{} ; -- 
lin council_N = variants{} ; -- 
lin already_Adv = mkAdv "diġà" ;
lin possible_A = variants{} ; -- 
lin nothing_NP = regNP "xejn" ;
lin line_N = variants{} ; -- 
lin allow_V2V = variants{} ; -- 
lin allow_V2 = variants{} ; -- 
lin need_N = variants{} ; -- 
lin effect_N = variants{} ; -- 
lin big_A = brokenA "kbir" "kbar" "ikbar" ;
lin use_N = variants{} ; -- 
lin lead_V2V = variants{} ; -- 
lin lead_V2 = variants{} ; -- 
lin lead_V = variants{} ; -- 
lin stand_V2 = variants{}; -- qaghad_QGHD_1_9210_V ;
lin stand_V = qaghad_QGHD_1_9210_V ;
lin idea_N = variants{} ; -- 
lin study_N = variants{} ; -- 
lin lot_N = variants{} ; -- 
lin live_V = ghex_GHJX_1_10711_V ;
lin job_N = variants{} ; -- 
lin since_Subj = variants{} ; -- 
lin name_N = possN (mkN "isem" "ismijiet") ;
lin result_N = variants{} ; -- 
lin body_N = variants{} ; -- 
lin happen_VV = variants{} ; -- 
lin happen_V = variants{} ; -- 
lin friend_N = possN (mkN "ħabib" "ħbieb") ; -- genderedN
lin right_N = variants{} ; -- 
lin least_Adv = variants{} ; -- 
lin right_A = variants{} ; -- 
lin right_2_A = variants{} ; -- 
lin right_1_A = variants{} ; -- 
lin almost_Adv = variants{} ; -- 
lin much_Det = mkDeterminer singular "ħafna" ;
lin carry_V2 = variants{} ; -- 
lin carry_V = variants{} ; -- 
lin authority_N = variants{} ; -- 
lin authority_2_N = variants{} ; -- 
lin authority_1_N = variants{} ; -- 
lin long_Adv = variants{} ; -- 
lin early_A = variants{} ; -- 
lin view_N = variants{} ; -- 
lin view_2_N = variants{} ; -- 
lin view_1_N = variants{} ; -- 
lin public_A = variants{} ; -- 
lin together_Adv = variants{} ; -- 
lin talk_V2 = variants{}; -- mkV3 kellem_KLM_2_8597_V maP fuqP ; -- PAĊPAĊ, PARLA
lin talk_V = variants{}; -- mkV3 kellem_KLM_2_8597_V maP fuqP ; -- PAĊPAĊ, PARLA
lin report_N = variants{} ; -- 
lin after_Subj = variants{} ; -- 
lin only_Predet = ss "biss" ;
lin before_Subj = variants{} ; -- 
lin bit_N = variants{} ; -- 
lin face_N = variants{} ; -- 
lin sit_V2 = variants{}; -- pogga_PGJ_2_9157_V ;
lin sit_V = pogga_PGJ_2_9157_V ;
lin market_N = variants{} ; -- 
lin market_1_N = variants{} ; -- 
lin market_2_N = variants{} ; -- 
lin appear_VV = variants{} ; -- 
lin appear_VS = variants{} ; -- 
lin appear_VA = variants{} ; -- 
lin appear_V = variants{} ; -- 
lin continue_VV = variants{} ; -- 
lin continue_V2 = variants{} ; -- 
lin continue_V = variants{} ; -- 
lin able_A = variants{} ; -- 
lin political_A = variants{} ; -- 
lin later_Adv = variants{} ; -- 
lin hour_N = variants{} ; -- 
lin rate_N = variants{} ; -- 
lin law_N = variants{} ; -- 
lin law_2_N = variants{} ; -- 
lin law_1_N = variants{} ; -- 
lin door_N = mkN "bieb" "bibien" ;
lin court_N = variants{} ; -- 
lin court_2_N = variants{} ; -- 
lin court_1_N = variants{} ; -- 
lin office_N = variants{} ; -- 
lin let_V2V = variants{} ; -- 
lin war_N = mkN "gwerra" "gwerrer" ;
lin produce_V2 = variants{} ; -- 
lin produce_V = variants{} ; -- 
lin reason_N = mkN "raġun" "raġunijiet" ;
lin less_Adv = variants{} ; -- 
lin minister_N = variants{} ; -- 
lin minister_2_N = variants{} ; -- 
lin minister_1_N = variants{} ; -- 
lin subject_N = variants{} ; -- 
lin subject_2_N = variants{} ; -- 
lin subject_1_N = variants{} ; -- 
lin person_N = mkNColl "persuna" "persuni" ;
lin term_N = variants{} ; -- 
lin particular_A = variants{} ; -- 
lin full_A = mkA "mimli" ;
lin involve_VS = variants{} ; -- 
lin involve_V2 = variants{} ; -- 
lin involve_V = variants{} ; -- 
lin sort_N = variants{} ; -- 
lin require_VS = variants{} ; -- 
lin require_V2V = variants{} ; -- 
lin require_V2 = variants{} ; -- 
lin require_V = variants{} ; -- 
lin suggest_VS = variants{} ; -- 
lin suggest_V2 = variants{} ; -- 
lin suggest_V = variants{} ; -- 
lin far_A = variants{} ; -- 
lin towards_Prep = variants{} ; -- 
lin anything_NP = variants{} ; -- 
lin period_N = variants{} ; -- 
lin period_3_N = variants{} ; -- 
lin period_2_N = variants{} ; -- 
lin period_1_N = variants{} ; -- 
lin consider_VV = variants{} ; -- 
lin consider_VS = variants{} ; -- 
lin consider_V3 = variants{} ; -- 
lin consider_V2V = variants{} ; -- 
lin consider_V2A = variants{} ; -- 
lin consider_V2 = variants{} ; -- 
lin consider_V = variants{} ; -- 
lin read_VS = variants{}; -- dirV2 (qara_QRJ_1_9350_V) ;
lin read_V2 = dirV2 (qara_QRJ_1_9350_V) ;
lin read_V = variants{}; -- dirV2 (qara_QRJ_1_9350_V) ;
lin change_V2 = variants{} ; -- 
lin change_V = variants{} ; -- 
lin society_N = variants{} ; -- 
lin process_N = variants{} ; -- 
lin mother_N = variants{} ; -- 
lin offer_VV = variants{} ; -- 
lin offer_V2 = variants{} ; -- 
lin late_A = variants{} ; -- 
lin voice_N = variants{} ; -- 
lin both_Adv = variants{} ; -- 
lin once_Adv = variants{} ; -- 
lin police_N = variants{} ; -- 
lin kind_N = variants{} ; -- 
lin lose_V2 = lilV2 (tilef_TLF_1_9895_V) ;
lin lose_V = variants{}; -- lilV2 (tilef_TLF_1_9895_V) ;
lin add_VS = variants{}; -- mkV3 zied_ZJD_1_10424_V maP ;
lin add_V2 = variants{}; -- mkV3 zied_ZJD_1_10424_V maP ;
lin add_V = variants{}; -- mkV3 zied_ZJD_1_10424_V maP ;
lin probably_Adv = variants{} ; -- 
lin expect_VV = variants{} ; -- 
lin expect_VS = variants{} ; -- 
lin expect_V2V = variants{} ; -- 
lin expect_V2 = variants{} ; -- 
lin expect_V = variants{} ; -- 
lin ever_Adv = variants{} ; -- 
lin available_A = variants{} ; -- 
lin price_N = variants{} ; -- 
lin little_A = variants{} ; -- 
lin action_N = variants{} ; -- 
lin issue_N = variants{} ; -- 
lin issue_2_N = variants{} ; -- 
lin issue_1_N = variants{} ; -- 
lin far_Adv = mkAdv "il-bogħod" ; -- use glue?
lin remember_VS = variants{} ; -- 
lin remember_V2 = variants{} ; -- 
lin remember_V = variants{} ; -- 
lin position_N = variants{} ; -- 
lin low_A = variants{} ; -- 
lin cost_N = variants{} ; -- 
lin little_Det = variants{} ; -- 
lin matter_N = variants{} ; -- 
lin matter_1_N = variants{} ; -- 
lin matter_2_N = variants{} ; -- 
lin community_N = variants{} ; -- 
lin remain_VV = variants{} ; -- 
lin remain_VA = variants{} ; -- 
lin remain_V2 = variants{} ; -- 
lin remain_V = variants{} ; -- 
lin figure_N = variants{} ; -- 
lin figure_2_N = variants{} ; -- 
lin figure_1_N = variants{} ; -- 
lin type_N = variants{} ; -- 
lin research_N = variants{} ; -- 
lin actually_Adv = variants{} ; -- 
lin education_N = variants{} ; -- 
lin fall_V = waqa'_WQGH_1_10070_V ;
lin speak_V2 = prepV2 (kellem_KLM_2_8597_V) maP ;
lin speak_V = variants{}; -- prepV2 (kellem_KLM_2_8597_V) maP ;
lin few_N = variants{} ; -- 
lin today_Adv = mkAdv "illum" ;
lin enough_Adv = variants{} ; -- 
lin open_V2 = dirV2 (fetah_FTH_1_7932_V) ;
lin open_V = variants{}; -- dirV2 (fetah_FTH_1_7932_V) ;
lin bad_A = brokenA "ħażin" "hżiena" "agħar" ;
lin buy_V2 = dirV2 (xtara_XRJ_8_10296_V) ;
lin buy_V = variants{}; -- dirV2 (xtara_XRJ_8_10296_V) ;
lin programme_N = variants{} ; -- 
lin minute_N = variants{} ; -- 
lin moment_N = variants{} ; -- 
lin girl_N = mkN "tifla" "tfajliet" ;
lin age_N = variants{} ; -- 
lin centre_N = variants{} ; -- 
lin stop_VV = variants{}; -- waqaf_WQF_1_10067_V ;
lin stop_V2 = variants{}; -- waqaf_WQF_1_10067_V ;
lin stop_V = waqaf_WQF_1_10067_V ;
lin control_N = variants{} ; -- 
lin value_N = variants{} ; -- 
lin send_V2V = variants{} ; -- 
lin send_V2 = variants{}; -- mkV3 baghat_BGHT_1_7412_V lilP ;
lin send_V = variants{}; -- mkV3 baghat_BGHT_1_7412_V lilP ;
lin health_N = variants{} ; -- 
lin decide_VV = variants{} ; -- 
lin decide_VS = variants{} ; -- 
lin decide_V2 = variants{} ; -- 
lin decide_V = variants{} ; -- 
lin main_A = variants{} ; -- 
lin win_V2 = dirV2 (rebah_RBH_1_9371_V) ;
lin win_V = variants{}; -- dirV2 (rebah_RBH_1_9371_V) ;
lin understand_VS = variants{}; -- lilV2 (fehem_FHM_1_10830_V) ;
lin understand_V2 = lilV2 (fehem_FHM_1_10830_V) ;
lin understand_V = variants{}; -- lilV2 (fehem_FHM_1_10830_V) ;
lin decision_N = variants{} ; -- 
lin develop_V2 = variants{} ; -- 
lin develop_V = variants{} ; -- 
lin class_N = variants{} ; -- 
lin industry_N = mkN "industrija" "industriji" ;
lin receive_V2 = variants{} ; -- 
lin receive_V = variants{} ; -- 
lin back_N = possN (mkN "dahar" "dhur") ;
lin several_Det = variants{} ; -- 
lin return_V2 = variants{} ; -- 
lin return_V = variants{} ; -- 
lin build_V2 = variants{} ; -- 
lin build_V = variants{} ; -- 
lin spend_V2 = variants{} ; -- 
lin spend_V = variants{} ; -- 
lin force_N = variants{} ; -- 
lin condition_N = variants{} ; -- 
lin condition_1_N = variants{} ; -- 
lin condition_2_N = variants{} ; -- 
lin paper_N = mkN "karta" "karti" ;
lin off_Prep = variants{} ; -- 
lin major_A = variants{} ; -- 
lin describe_VS = variants{} ; -- 
lin describe_V2 = variants{} ; -- 
lin agree_VV = variants{} ; -- 
lin agree_VS = variants{} ; -- 
lin agree_V = variants{} ; -- 
lin economic_A = variants{} ; -- 
lin increase_V2 = variants{} ; -- 
lin increase_V = variants{} ; -- 
lin upon_Prep = variants{} ; -- 
lin learn_VV = variants{}; -- dirV2 (tghallem_GHLM_5_10527_V) ;
lin learn_VS = variants{}; -- dirV2 (tghallem_GHLM_5_10527_V) ;
lin learn_V2 = dirV2 (tghallem_GHLM_5_10527_V) ;
lin learn_V = variants{}; -- dirV2 (tghallem_GHLM_5_10527_V) ;
lin general_A = variants{} ; -- 
lin century_N = variants{} ; -- 
lin therefore_Adv = variants{} ; -- 
lin father_N = variants{} ; -- 
lin section_N = variants{} ; -- 
lin patient_N = variants{} ; -- 
lin around_Adv = variants{} ; -- 
lin activity_N = variants{} ; -- 
lin road_N = mkN "triq" "triqat" "toroq" feminine ;
lin table_N = mkN "mejda" "mwejjed" ;
lin including_Prep = variants{} ; -- 
lin church_N = mkN "knisja" "knejjes" ;
lin reach_V2 = variants{} ; -- 
lin reach_V = variants{} ; -- 
lin real_A = variants{} ; -- 
lin lie_VS = variants{}; -- mtedd_MDD_8_8816_V ; -- lie down
lin lie_2_V = variants{} ; -- 
lin lie_1_V = variants{} ; -- 
lin mind_N = variants{} ; -- 
lin likely_A = variants{} ; -- 
lin among_Prep = variants{} ; -- 
lin team_N = variants{} ; -- 
lin experience_N = variants{} ; -- 
lin death_N = variants{} ; -- 
lin soon_Adv = variants{} ; -- 
lin act_N = variants{} ; -- 
lin sense_N = variants{} ; -- 
lin staff_N = variants{} ; -- 
lin staff_2_N = variants{} ; -- 
lin staff_1_N = variants{} ; -- 
lin certain_A = variants{} ; -- 
lin certain_2_A = variants{} ; -- 
lin certain_1_A = variants{} ; -- 
lin studentMasc_N = variants{} ; -- 
lin half_Predet = variants{} ; -- 
lin half_Predet = variants{} ; -- 
lin around_Prep = variants{} ; -- 
lin language_N = mkN "lingwa" "lingwi" ;
lin walk_V2 = variants{}; -- mexa_MXJ_1_8926_V ;
lin walk_V = mexa_MXJ_1_8926_V ;
lin die_V = miet_MWT_1_8923_V ;
lin special_A = variants{} ; -- 
lin difficult_A = variants{} ; -- 
lin international_A = variants{} ; -- 
lin particularly_Adv = variants{} ; -- 
lin department_N = variants{} ; -- 
lin management_N = variants{} ; -- 
lin morning_N = variants{} ; -- 
lin draw_V2 = variants{} ; -- 
lin draw_1_V2 = variants{} ; -- 
lin draw_2_V2 = variants{} ; -- 
lin draw_V = variants{} ; -- 
lin hope_VV = variants{}; -- xtaq_XWQ_8_10313_V ;
lin hope_VS = xtaq_XWQ_8_10313_V ;
lin hope_V = variants{}; -- xtaq_XWQ_8_10313_V ;
lin across_Prep = variants{} ; -- 
lin plan_N = variants{} ; -- 
lin product_N = variants{} ; -- 
lin city_N = mkN "belt" "bliet" feminine ;
lin early_Adv = variants{} ; -- 
lin committee_N = variants{} ; -- 
lin ground_N = variants{} ; -- 
lin ground_2_N = variants{} ; -- 
lin ground_1_N = variants{} ; -- 
lin letter_N = variants{} ; -- 
lin letter_2_N = variants{} ; -- 
lin letter_1_N = variants{} ; -- 
lin create_V2 = variants{} ; -- 
lin create_V = variants{} ; -- 
lin evidence_N = variants{} ; -- 
lin evidence_2_N = variants{} ; -- 
lin evidence_1_N = variants{} ; -- 
lin foot_N = possN (mkNDual "sieq" "saqajn" "saqajn" feminine) ;
lin clear_A = variants{} ; -- 
lin boy_N = mkN "tifel" "subien" ;
lin game_N = variants{} ; -- 
lin game_3_N = variants{} ; -- 
lin game_2_N = variants{} ; -- 
lin game_1_N = variants{} ; -- 
lin food_N = variants{} ; -- 
lin role_N = variants{} ; -- 
lin role_2_N = variants{} ; -- 
lin role_1_N = variants{} ; -- 
lin practice_N = variants{} ; -- 
lin bank_N = mkN "bank" "bankijiet" ;
lin else_Adv = variants{} ; -- 
lin support_N = variants{} ; -- 
lin sell_V2 = variants{}; -- mkV3 biegh_BJGH_1_7565_V lilP ;
lin sell_V = variants{}; -- mkV3 biegh_BJGH_1_7565_V lilP ;
lin event_N = variants{} ; -- 
lin building_N = variants{} ; -- 
lin range_N = variants{} ; -- 
lin behind_Prep = after_Prep ;
lin sure_A = variants{} ; -- 
lin report_VS = variants{} ; -- 
lin report_V2 = variants{} ; -- 
lin report_V = variants{} ; -- 
lin pass_V = variants{} ; -- 
lin black_A = mkA "iswed" "sewda" "suwed" ;
lin stage_N = variants{} ; -- 
lin meeting_N = variants{} ; -- 
lin meeting_N = variants{} ; -- 
lin sometimes_Adv = variants{} ; -- 
lin thus_Adv = variants{} ; -- 
lin accept_VS = variants{} ; -- 
lin accept_V2 = variants{} ; -- 
lin accept_V = variants{} ; -- 
lin town_N = variants{} ; -- 
lin art_N = mkNNoPlural "arti" feminine ;
lin further_Adv = variants{} ; -- 
lin club_N = variants{} ; -- 
lin club_2_N = variants{} ; -- 
lin club_1_N = variants{} ; -- 
lin cause_V2V = variants{} ; -- 
lin cause_V2 = variants{} ; -- 
lin arm_N = variants{} ; -- 
lin arm_1_N = variants{} ; -- 
lin arm_2_N = variants{} ; -- 
lin history_N = variants{} ; -- 
lin parent_N = variants{} ; -- 
lin land_N = variants{} ; -- 
lin trade_N = variants{} ; -- 
lin watch_VS = variants{}; -- dirV2 (ra_R'J_1_9513_V) ;
lin watch_V2V = variants{}; -- dirV2 (ra_R'J_1_9513_V) ;
lin watch_V2 = dirV2 (ra_R'J_1_9513_V) ;
lin watch_1_V2 = variants{} ; -- 
lin watch_2_V2 = variants{} ; -- 
lin watch_V = variants{}; -- dirV2 (ra_R'J_1_9513_V) ;
lin white_A = mkA "abjad" "bajda" "bojod" ;
lin situation_N = variants{} ; -- 
lin ago_Adv = variants{} ; -- 
lin teacherMasc_N = variants{} ; -- 
lin record_N = variants{} ; -- 
lin record_3_N = variants{} ; -- 
lin record_2_N = variants{} ; -- 
lin record_1_N = variants{} ; -- 
lin manager_N = variants{} ; -- 
lin relation_N = variants{} ; -- 
lin common_A = variants{} ; -- 
lin common_2_A = variants{} ; -- 
lin common_1_A = variants{} ; -- 
lin strong_A = variants{} ; -- 
lin whole_A = variants{} ; -- 
lin field_N = variants{} ; -- 
lin field_4_N = variants{} ; -- 
lin field_3_N = variants{} ; -- 
lin field_2_N = variants{} ; -- 
lin field_1_N = variants{} ; -- 
lin free_A = variants{} ; -- 
lin break_V2 = dirV2 (kiser_KSR_1_8636_V) ;
lin break_V = variants{}; -- dirV2 (kiser_KSR_1_8636_V) ;
lin yesterday_Adv = variants{} ; -- 
lin support_V2 = variants{} ; -- 
lin window_N = mkN "tieqa" "twieqi" ;
lin account_N = variants{} ; -- 
lin explain_VS = variants{} ; -- 
lin explain_V2 = variants{} ; -- 
lin stay_VA = variants{} ; -- 
lin stay_V = variants{} ; -- 
lin few_Det = mkDeterminer plural "ftit" ;
lin wait_VV = variants{}; -- lilV2 (stenna_'NJ_10_10781_V) ;
lin wait_V2 = lilV2 (stenna_'NJ_10_10781_V) ;
lin wait_V = variants{}; -- lilV2 (stenna_'NJ_10_10781_V) ;
lin usually_Adv = variants{} ; -- 
lin difference_N = variants{} ; -- 
lin material_N = variants{} ; -- 
lin air_N = variants{} ; -- 
lin wife_N = mkN "mara" "nisa" ;
lin cover_V2 = variants{} ; -- 
lin apply_VV = variants{} ; -- 
lin apply_V2V = variants{} ; -- 
lin apply_V2 = variants{} ; -- 
lin apply_1_V2 = variants{} ; -- 
lin apply_2_V2 = variants{} ; -- 
lin apply_V = variants{} ; -- 
lin project_N = variants{} ; -- 
lin raise_V2 = variants{} ; -- 
lin sale_N = variants{} ; -- 
lin relationship_N = variants{} ; -- 
lin indeed_Adv = variants{} ; -- 
lin light_N = variants{} ; -- 
lin claim_VS = variants{} ; -- 
lin claim_V2 = variants{} ; -- 
lin claim_V = variants{} ; -- 
lin form_V2 = variants{} ; -- 
lin form_V = variants{} ; -- 
lin base_V2 = variants{} ; -- 
lin base_V = variants{} ; -- 
lin care_N = variants{} ; -- 
lin someone_NP = variants{} ; -- 
lin everything_NP = regNP "kollox" ;
lin certainly_Adv = variants{} ; -- 
lin rule_N = mkN "regola" "regoli" ;
lin home_Adv = variants{} ; -- 
lin cut_V2 = dirV2 (qata'_QTGH_1_9305_V) ;
lin cut_V = variants{}; -- dirV2 (qata'_QTGH_1_9305_V) ;
lin grow_VA = variants{} ; -- 
lin grow_V2 = variants{} ; -- 
lin grow_V = variants{} ; -- 
lin similar_A = variants{} ; -- 
lin story_N = variants{} ; -- 
lin quality_N = variants{} ; -- 
lin tax_N = variants{} ; -- 
lin worker_N = variants{} ; -- 
lin nature_N = variants{} ; -- 
lin structure_N = variants{} ; -- 
lin data_N = variants{} ; -- 
lin necessary_A = variants{} ; -- 
lin pound_N = variants{} ; -- 
lin method_N = variants{} ; -- 
lin unit_N = variants{} ; -- 
lin unit_6_N = variants{} ; -- 
lin unit_5_N = variants{} ; -- 
lin unit_4_N = variants{} ; -- 
lin unit_3_N = variants{} ; -- 
lin unit_2_N = variants{} ; -- 
lin unit_1_N = variants{} ; -- 
lin central_A = variants{} ; -- 
lin bed_N = variants{} ; -- 
lin union_N = variants{} ; -- 
lin movement_N = variants{} ; -- 
lin board_N = variants{} ; -- 
lin board_2_N = variants{} ; -- 
lin board_1_N = variants{} ; -- 
lin true_A = variants{} ; -- 
lin well_Interj = variants{} ; -- 
lin simply_Adv = variants{} ; -- 
lin contain_V2 = variants{} ; -- 
lin especially_Adv = variants{} ; -- 
lin open_A = variants{} ; -- 
lin short_A = brokenA "qasir" "qosra" "iqsar" ;
lin personal_A = variants{} ; -- 
lin detail_N = variants{} ; -- 
lin model_N = variants{} ; -- 
lin bear_V2 = variants{} ; -- 
lin bear_V = variants{} ; -- 
lin single_A = variants{} ; -- 
lin single_2_A = variants{} ; -- 
lin single_1_A = variants{} ; -- 
lin join_V2 = variants{} ; -- 
lin join_V = variants{} ; -- 
lin reduce_V2 = variants{} ; -- 
lin reduce_V = variants{} ; -- 
lin establish_V2 = variants{} ; -- 
lin wall_N = variants{} ; -- 
lin face_V2 = variants{} ; -- 
lin face_V = variants{} ; -- 
lin easy_A = variants{} ; -- 
lin private_A = variants{} ; -- 
lin computer_N = mkN "kompjuter" "kompjuters" ;
lin hospital_N = variants{} ; -- 
lin chapter_N = variants{} ; -- 
lin scheme_N = variants{} ; -- 
lin theory_N = variants{} ; -- 
lin choose_VV = variants{} ; -- 
lin choose_V2 = variants{} ; -- 
lin wish_VV = variants{} ; -- 
lin wish_VS = variants{} ; -- 
lin wish_V2V = variants{} ; -- 
lin wish_V2 = variants{} ; -- 
lin wish_V = variants{} ; -- 
lin property_N = variants{} ; -- 
lin property_2_N = variants{} ; -- 
lin property_1_N = variants{} ; -- 
lin achieve_V2 = variants{} ; -- 
lin financial_A = variants{} ; -- 
lin poor_A = variants{} ; -- 
lin poor_3_A = variants{} ; -- 
lin poor_2_A = variants{} ; -- 
lin poor_1_A = variants{} ; -- 
lin officer_N = variants{} ; -- 
lin officer_3_N = variants{} ; -- 
lin officer_2_N = variants{} ; -- 
lin officer_1_N = variants{} ; -- 
lin up_Prep = variants{} ; -- 
lin charge_N = variants{} ; -- 
lin charge_2_N = variants{} ; -- 
lin charge_1_N = variants{} ; -- 
lin director_N = variants{} ; -- 
lin drive_V2V = variants{} ; -- 
lin drive_V2 = variants{} ; -- 
lin drive_V = variants{} ; -- 
lin deal_V2 = variants{} ; -- 
lin deal_V = variants{} ; -- 
lin place_V2 = variants{} ; -- 
lin approach_N = variants{} ; -- 
lin chance_N = variants{} ; -- 
lin application_N = variants{} ; -- 
lin seek_VV = variants{}; -- lilV2 (fittex_FTX_2_7952_V) ;
lin seek_V2 = lilV2 (fittex_FTX_2_7952_V) ;
lin foreign_A = variants{} ; -- 
lin foreign_2_A = variants{} ; -- 
lin foreign_1_A = variants{} ; -- 
lin along_Prep = variants{} ; -- 
lin top_N = variants{} ; -- 
lin amount_N = variants{} ; -- 
lin son_N = variants{} ; -- 
lin operation_N = variants{} ; -- 
lin fail_VV = variants{} ; -- 
lin fail_V2 = variants{} ; -- 
lin fail_V = variants{} ; -- 
lin human_A = variants{} ; -- 
lin opportunity_N = variants{} ; -- 
lin simple_A = variants{} ; -- 
lin leader_N = variants{} ; -- 
lin look_N = variants{} ; -- 
lin share_N = variants{} ; -- 
lin production_N = variants{} ; -- 
lin recent_A = variants{} ; -- 
lin firm_N = variants{} ; -- 
lin picture_N = variants{} ; -- 
lin source_N = variants{} ; -- 
lin security_N = variants{} ; -- 
lin serve_V2 = variants{} ; -- 
lin serve_V = variants{} ; -- 
lin according_to_Prep = variants{} ; -- 
lin end_V2 = variants{} ; -- 
lin end_V = variants{} ; -- 
lin contract_N = variants{} ; -- 
lin wide_A = broad_A ;
lin occur_V = variants{} ; -- 
lin agreement_N = variants{} ; -- 
lin better_Adv = variants{} ; -- 
lin kill_V2 = lilV2 (qatel_QTL_1_9312_V) ;
lin kill_V = variants{}; -- lilV2 (qatel_QTL_1_9312_V) ;
lin act_V2 = variants{} ; -- 
lin act_V = variants{} ; -- 
lin site_N = variants{} ; -- 
lin either_Adv = variants{} ; -- 
lin labour_N = variants{} ; -- 
lin plan_VV = variants{} ; -- 
lin plan_VS = variants{} ; -- 
lin plan_V2V = variants{} ; -- 
lin plan_V2 = variants{} ; -- 
lin plan_V = variants{} ; -- 
lin various_A = variants{} ; -- 
lin since_Prep = variants{} ; -- 
lin test_N = variants{} ; -- 
lin eat_V2 = dirV2 (kiel_KJL_1_8672_V) ;
lin eat_V = variants{}; -- dirV2 (kiel_KJL_1_8672_V) ;
lin loss_N = variants{} ; -- 
lin close_V2 = dirV2 (ghalaq_GHLQ_1_10530_V) ;
lin close_V = variants{}; -- dirV2 (ghalaq_GHLQ_1_10530_V) ;
lin represent_V2 = variants{} ; -- 
lin represent_V = variants{} ; -- 
lin love_VV = variants{}; -- lilV2 (habb_HBB_1_8174_V) ;
lin love_V2 = lilV2 (habb_HBB_1_8174_V) ;
lin colour_N = variants{} ; -- 
lin clearly_Adv = variants{} ; -- 
lin shop_N = mkN "ħanut" "ħwienet" ;
lin benefit_N = variants{} ; -- 
lin animal_N = mkN "annimal" "annimali" ;
lin heart_N = possN (mkN "qalb" "qlub" feminine) ;
lin election_N = variants{} ; -- 
lin purpose_N = variants{} ; -- 
lin standard_N = variants{} ; -- 
lin due_A = variants{} ; -- 
lin secretary_N = variants{} ; -- 
lin rise_V2 = variants{} ; -- 
lin rise_V = variants{} ; -- 
lin date_N = variants{} ; -- 
lin date_7_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_1_N = variants{} ; -- 
lin hard_A = variants{} ; -- 
lin hard_2_A = variants{} ; -- 
lin hard_1_A = variants{} ; -- 
lin music_N = mkN "mużika" "mużiki" ;
lin hair_N = possN (mkNColl "xagħara" "xagħar" "xagħariet" "xgħur") ;
lin prepare_VV = variants{} ; -- 
lin prepare_V2V = variants{} ; -- 
lin prepare_V2 = variants{} ; -- 
lin prepare_V = variants{} ; -- 
lin factor_N = variants{} ; -- 
lin other_A = variants{} ; -- 
lin anyone_NP = variants{} ; -- 
lin pattern_N = variants{} ; -- 
lin manage_VV = variants{} ; -- 
lin manage_V2 = variants{} ; -- 
lin manage_V = variants{} ; -- 
lin piece_N = variants{} ; -- 
lin discuss_VS = variants{} ; -- 
lin discuss_V2 = variants{} ; -- 
lin prove_VS = variants{} ; -- 
lin prove_VA = variants{} ; -- 
lin prove_V2 = variants{} ; -- 
lin prove_V = variants{} ; -- 
lin front_N = variants{} ; -- 
lin evening_N = variants{} ; -- 
lin royal_A = variants{} ; -- 
lin tree_N = mkNColl "siġra" "siġar" "siġriet" ;
lin population_N = variants{} ; -- 
lin fine_A = variants{} ; -- 
lin plant_N = variants{} ; -- 
lin pressure_N = variants{} ; -- 
lin response_N = variants{} ; -- 
lin catch_V2 = variants{} ; -- 
lin street_N = variants{} ; -- 
lin pick_V2 = variants{} ; -- 
lin pick_V = variants{} ; -- 
lin performance_N = variants{} ; -- 
lin performance_2_N = variants{} ; -- 
lin performance_1_N = variants{} ; -- 
lin knowledge_N = variants{} ; -- 
lin despite_Prep = variants{} ; -- 
lin design_N = variants{} ; -- 
lin page_N = variants{} ; -- 
lin enjoy_VV = variants{} ; -- 
lin enjoy_V2 = variants{} ; -- 
lin individual_N = variants{} ; -- 
lin suppose_VS = variants{} ; -- 
lin suppose_V2 = variants{} ; -- 
lin rest_N = variants{} ; -- 
lin instead_Adv = variants{} ; -- 
lin wear_V2 = variants{} ; -- 
lin wear_V = variants{} ; -- 
lin basis_N = variants{} ; -- 
lin size_N = variants{} ; -- 
lin environment_N = variants{} ; -- 
lin per_Prep = variants{} ; -- 
lin fire_N = mkN "nar" "nirien" ;
lin fire_2_N = variants{} ; -- 
lin fire_1_N = variants{} ; -- 
lin series_N = variants{} ; -- 
lin success_N = variants{} ; -- 
lin natural_A = variants{} ; -- 
lin wrong_A = variants{} ; -- 
lin near_Prep = variants{} ; -- 
lin round_Adv = variants{} ; -- 
lin thought_N = variants{} ; -- 
lin list_N = variants{} ; -- 
lin argue_VS = variants{} ; -- 
lin argue_V2 = variants{} ; -- 
lin argue_V = variants{} ; -- 
lin final_A = variants{} ; -- 
lin future_N = variants{} ; -- 
lin future_3_N = variants{} ; -- 
lin future_1_N = variants{} ; -- 
lin introduce_V2 = variants{} ; -- 
lin analysis_N = variants{} ; -- 
lin enter_V2 = variants{} ; -- 
lin enter_V = variants{} ; -- 
lin space_N = variants{} ; -- 
lin arrive_V = variants{} ; -- 
lin ensure_VS = variants{} ; -- 
lin ensure_V2 = variants{} ; -- 
lin ensure_V = variants{} ; -- 
lin demand_N = variants{} ; -- 
lin statement_N = variants{} ; -- 
lin to_Adv = variants{}; -- mkPrep "lil" "lill-" "lit-" ;
lin attention_N = variants{} ; -- 
lin love_N = mkN "mħabba" "mħabbiet" ;
lin principle_N = variants{} ; -- 
lin pull_V2 = lilV2 (gibed_GBD_1_8043_V) ;
lin pull_V = variants{}; -- lilV2 (gibed_GBD_1_8043_V) ;
lin set_N = variants{} ; -- 
lin set_2_N = variants{} ; -- 
lin set_1_N = variants{} ; -- 
lin doctor_N = mkN "tabib" "tobba" ; -- genderedN
lin choice_N = variants{} ; -- 
lin refer_V2 = variants{} ; -- 
lin refer_V = variants{} ; -- 
lin feature_N = variants{} ; -- 
lin couple_N = variants{} ; -- 
lin step_N = variants{} ; -- 
lin following_A = variants{} ; -- 
lin thank_V2 = variants{} ; -- 
lin machine_N = variants{} ; -- 
lin income_N = variants{} ; -- 
lin training_N = variants{} ; -- 
lin present_V2 = variants{} ; -- 
lin association_N = variants{} ; -- 
lin film_N = variants{} ; -- 
lin film_2_N = variants{} ; -- 
lin film_1_N = variants{} ; -- 
lin region_N = variants{} ; -- 
lin effort_N = variants{} ; -- 
lin player_N = variants{} ; -- 
lin everyone_NP = variants{} ; -- 
lin present_A = variants{} ; -- 
lin award_N = variants{} ; -- 
lin village_N = mkN "raħal" "rħula" ;
lin control_V2 = variants{} ; -- 
lin organisation_N = variants{} ; -- 
lin whatever_Det = variants{} ; -- 
lin news_N = variants{} ; -- 
lin nice_A = variants{} ; -- 
lin difficulty_N = variants{} ; -- 
lin modern_A = variants{} ; -- 
lin cell_N = variants{} ; -- 
lin close_A = variants{} ; -- 
lin current_A = variants{} ; -- 
lin legal_A = variants{} ; -- 
lin energy_N = variants{} ; -- 
lin finally_Adv = variants{} ; -- 
lin degree_N = variants{} ; -- 
lin degree_3_N = variants{} ; -- 
lin degree_2_N = variants{} ; -- 
lin degree_1_N = variants{} ; -- 
lin mile_N = variants{} ; -- 
lin means_N = variants{} ; -- 
lin growth_N = variants{} ; -- 
lin treatment_N = variants{} ; -- 
lin sound_N = variants{} ; -- 
lin above_Prep = mkPrep "fuq" ;
lin task_N = variants{} ; -- 
lin provision_N = variants{} ; -- 
lin affect_V2 = variants{} ; -- 
lin please_Adv = variants{} ; -- 
lin red_A = mkA "aħmar" "ħamra" "ħomor" ;
lin happy_A = variants{} ; -- 
lin behaviour_N = variants{} ; -- 
lin concerned_A = variants{} ; -- 
lin point_V2 = variants{} ; -- 
lin point_V = variants{} ; -- 
lin function_N = variants{} ; -- 
lin identify_V2 = variants{} ; -- 
lin identify_V = variants{} ; -- 
lin resource_N = variants{} ; -- 
lin defence_N = variants{} ; -- 
lin garden_N = mkN "ġnien" "ġonna" ;
lin floor_N = mkN "art" "artijiet" feminine ;
lin technology_N = variants{} ; -- 
lin style_N = variants{} ; -- 
lin feeling_N = variants{} ; -- 
lin science_N = mkN "xjenza" "xjenzi" ;
lin relate_V2 = variants{} ; -- 
lin relate_V = variants{} ; -- 
lin doubt_N = variants{} ; -- 
lin horse_N = mkN "żiemel" "żwiemel" ;
lin force_VS = variants{} ; -- 
lin force_V2V = variants{} ; -- 
lin force_V2 = variants{} ; -- 
lin force_V = variants{} ; -- 
lin answer_N = variants{} ; -- 
lin compare_V = variants{} ; -- 
lin suffer_V2 = variants{} ; -- 
lin suffer_V = variants{} ; -- 
lin individual_A = variants{} ; -- 
lin forward_Adv = variants{} ; -- 
lin announce_VS = variants{} ; -- 
lin announce_V2 = variants{} ; -- 
lin userMasc_N = variants{} ; -- 
lin fund_N = variants{} ; -- 
lin character_2_N = variants{} ; -- 
lin character_1_N = variants{} ; -- 
lin risk_N = variants{} ; -- 
lin normal_A = variants{} ; -- 
lin nor_Conj = variants{} ; -- 
lin dog_N = mkN "kelb" "klieb" ;
lin obtain_V2 = variants{} ; -- 
lin obtain_V = variants{} ; -- 
lin quickly_Adv = variants{} ; -- 
lin army_N = variants{} ; -- 
lin indicate_VS = variants{} ; -- 
lin indicate_V2 = variants{} ; -- 
lin forget_VS = variants{}; -- lilV2 (nesa_NSJ_1_9126_V) ;
lin forget_V2 = lilV2 (nesa_NSJ_1_9126_V) ;
lin forget_V = variants{}; -- lilV2 (nesa_NSJ_1_9126_V) ;
lin station_N = variants{} ; -- 
lin glass_N = variants{} ; -- 
lin cup_N = variants{} ; -- 
lin previous_A = variants{} ; -- 
lin husband_N = mkN "raġel" "rġiel" ;
lin recently_Adv = variants{} ; -- 
lin publish_V2 = variants{} ; -- 
lin publish_V = variants{} ; -- 
lin serious_A = variants{} ; -- 
lin anyway_Adv = variants{} ; -- 
lin visit_V2 = variants{} ; -- 
lin visit_V = variants{} ; -- 
lin capital_N = variants{} ; -- 
lin capital_3_N = variants{} ; -- 
lin capital_2_N = variants{} ; -- 
lin capital_1_N = variants{} ; -- 
lin either_Det = variants{} ; -- 
lin note_N = variants{} ; -- 
lin note_3_N = variants{} ; -- 
lin note_2_N = variants{} ; -- 
lin note_1_N = variants{} ; -- 
lin season_N = variants{} ; -- 
lin argument_N = variants{} ; -- 
lin listen_V = variants{}; -- lilV2 (sema'_SMGH_1_9698_V) ;
lin show_N = variants{} ; -- 
lin responsibility_N = variants{} ; -- 
lin significant_A = variants{} ; -- 
lin deal_N = variants{} ; -- 
lin prime_A = variants{} ; -- 
lin economy_N = variants{} ; -- 
lin economy_2_N = variants{} ; -- 
lin economy_1_N = variants{} ; -- 
lin element_N = variants{} ; -- 
lin finish_V2 = variants{} ; -- 
lin finish_V = variants{} ; -- 
lin duty_N = variants{} ; -- 
lin fight_V2 = prepV2 (ggieled_GLD_6_8074_V) maP ;
lin fight_V = variants{}; -- prepV2 (ggieled_GLD_6_8074_V) maP ;
lin train_V2V = variants{} ; -- 
lin train_V2 = variants{} ; -- 
lin train_V = variants{} ; -- 
lin maintain_VS = variants{} ; -- 
lin maintain_V2 = variants{} ; -- 
lin maintain_V = variants{} ; -- 
lin attempt_N = variants{} ; -- 
lin leg_N = (mkNDual "riġel" "riġlejn" "riġlejn") ;
lin investment_N = variants{} ; -- 
lin save_V2 = variants{} ; -- 
lin save_V = variants{} ; -- 
lin throughout_Prep = variants{} ; -- 
lin design_V2 = variants{} ; -- 
lin design_V = variants{} ; -- 
lin suddenly_Adv = variants{} ; -- 
lin brother_N = variants{} ; -- 
lin improve_V2 = variants{} ; -- 
lin improve_V = variants{} ; -- 
lin avoid_VV = variants{} ; -- 
lin avoid_V2 = variants{} ; -- 
lin wonder_VQ = kkuntempla_V ;
lin wonder_V = variants{}; -- kkuntempla_V ;
lin tend_VV = variants{} ; -- 
lin tend_V2 = variants{} ; -- 
lin title_N = variants{} ; -- 
lin hotel_N = variants{} ; -- 
lin aspect_N = variants{} ; -- 
lin increase_N = variants{} ; -- 
lin help_N = variants{} ; -- 
lin industrial_A = variants{} ; -- 
lin express_V2 = variants{} ; -- 
lin summer_N = variants{} ; -- 
lin determine_VV = variants{} ; -- 
lin determine_VS = variants{} ; -- 
lin determine_V2V = variants{} ; -- 
lin determine_V2 = variants{} ; -- 
lin determine_V = variants{} ; -- 
lin generally_Adv = variants{} ; -- 
lin daughter_N = variants{} ; -- 
lin exist_V = variants{} ; -- 
lin share_V2 = variants{} ; -- 
lin share_V = variants{} ; -- 
lin baby_N = mkN "tarbija" "trabi" ;
lin nearly_Adv = variants{} ; -- 
lin smile_V = variants{} ; -- 
lin sorry_A = variants{} ; -- 
lin sea_N = mkNDual "baħar" "baħrejn" "ibħra" ;
lin skill_N = variants{} ; -- 
lin claim_N = variants{} ; -- 
lin treat_V2 = variants{} ; -- 
lin treat_V = variants{} ; -- 
lin remove_V2 = variants{} ; -- 
lin remove_V = variants{} ; -- 
lin concern_N = variants{} ; -- 
lin university_N = mkN "università" "universitàjiet" ;
lin left_A = variants{} ; -- 
lin dead_A = variants{} ; -- 
lin discussion_N = variants{} ; -- 
lin specific_A = variants{} ; -- 
lin customerMasc_N = variants{} ; -- 
lin box_N = variants{} ; -- 
lin outside_Prep = variants{} ; -- 
lin state_VS = variants{} ; -- 
lin state_V2 = variants{} ; -- 
lin conference_N = variants{} ; -- 
lin whole_N = variants{} ; -- 
lin total_A = variants{} ; -- 
lin profit_N = variants{} ; -- 
lin division_N = variants{} ; -- 
lin division_3_N = variants{} ; -- 
lin division_2_N = variants{} ; -- 
lin division_1_N = variants{} ; -- 
lin throw_V2 = dirV2 (waddab_WDB_2_10027_V) ;
lin throw_V = variants{}; -- dirV2 (waddab_WDB_2_10027_V) ;
lin procedure_N = variants{} ; -- 
lin fill_V2 = variants{} ; -- 
lin fill_V = variants{} ; -- 
lin king_N = mkN "re" "rejjiet" ;
lin assume_VS = variants{} ; -- 
lin assume_V2 = variants{} ; -- 
lin image_N = variants{} ; -- 
lin oil_N = mkN "żejt" "żjut" ;
lin obviously_Adv = variants{} ; -- 
lin unless_Subj = variants{} ; -- 
lin appropriate_A = variants{} ; -- 
lin circumstance_N = variants{} ; -- 
lin military_A = variants{} ; -- 
lin proposal_N = variants{} ; -- 
lin mention_VS = variants{} ; -- 
lin mention_V2 = variants{} ; -- 
lin mention_V = variants{} ; -- 
lin client_N = variants{} ; -- 
lin sector_N = variants{} ; -- 
lin direction_N = variants{} ; -- 
lin admit_VS = variants{} ; -- 
lin admit_V2 = variants{} ; -- 
lin admit_V = variants{} ; -- 
lin though_Adv = variants{} ; -- 
lin replace_V2 = variants{} ; -- 
lin basic_A = variants{} ; -- 
lin hard_Adv = variants{} ; -- 
lin instance_N = variants{} ; -- 
lin sign_N = variants{} ; -- 
lin original_A = variants{} ; -- 
lin successful_A = variants{} ; -- 
lin okay_Adv = variants{} ; -- 
lin reflect_V2 = variants{} ; -- 
lin reflect_V = variants{} ; -- 
lin aware_A = variants{} ; -- 
lin measure_N = variants{} ; -- 
lin attitude_N = variants{} ; -- 
lin disease_N = variants{} ; -- 
lin exactly_Adv = variants{} ; -- 
lin above_Adv = variants{}; -- mkPrep "fuq" ;
lin commission_N = variants{} ; -- 
lin intend_VV = variants{} ; -- 
lin beyond_Prep = variants{} ; -- 
lin seat_N = variants{} ; -- 
lin presidentMasc_N = variants{} ; -- 
lin encourage_V2V = variants{} ; -- 
lin encourage_V2 = variants{} ; -- 
lin addition_N = variants{} ; -- 
lin goal_N = variants{} ; -- 
lin round_Prep = variants{} ; -- 
lin miss_V2 = variants{} ; -- 
lin miss_V = variants{} ; -- 
lin popular_A = variants{} ; -- 
lin affair_N = variants{} ; -- 
lin technique_N = variants{} ; -- 
lin respect_N = variants{} ; -- 
lin drop_V2 = variants{} ; -- 
lin drop_V = variants{} ; -- 
lin professional_A = variants{} ; -- 
lin less_Det = variants{} ; -- 
lin once_Subj = variants{} ; -- 
lin item_N = variants{} ; -- 
lin fly_V2 = variants{}; -- tar_TJR_1_9972_V ;
lin fly_V = tar_TJR_1_9972_V ;
lin reveal_VS = variants{} ; -- 
lin reveal_V2 = variants{} ; -- 
lin version_N = variants{} ; -- 
lin maybe_Adv = variants{} ; -- 
lin ability_N = variants{} ; -- 
lin operate_V2 = variants{} ; -- 
lin operate_V = variants{} ; -- 
lin good_N = variants{} ; -- 
lin campaign_N = variants{} ; -- 
lin heavy_A = brokenA "tqil" "tqal" "itqal" ;
lin advice_N = variants{} ; -- 
lin institution_N = variants{} ; -- 
lin discover_VS = variants{} ; -- 
lin discover_V2 = variants{} ; -- 
lin discover_V = variants{} ; -- 
lin surface_N = variants{} ; -- 
lin library_N = variants{} ; -- 
lin pupil_N = variants{} ; -- 
lin record_V2 = variants{} ; -- 
lin refuse_VV = variants{} ; -- 
lin refuse_V2 = variants{} ; -- 
lin refuse_V = variants{} ; -- 
lin prevent_V2 = variants{} ; -- 
lin advantage_N = variants{} ; -- 
lin dark_A = variants{} ; -- 
lin teach_V2V = variants{}; -- lilV2 (ghallem_GHLM_2_10526_V) ;
lin teach_V2 = lilV2 (ghallem_GHLM_2_10526_V) ;
lin teach_V = variants{}; -- lilV2 (ghallem_GHLM_2_10526_V) ;
lin memory_N = variants{} ; -- 
lin culture_N = variants{} ; -- 
lin blood_N = possN (mkNColl "demm" "dmija") ;
lin cost_V2 = variants{} ; -- 
lin cost_V = variants{} ; -- 
lin majority_N = variants{} ; -- 
lin answer_V2 = variants{}; -- lilV2 (wiegeb_WGB_3_10033_V) ;
lin answer_V = variants{}; -- lilV2 (wiegeb_WGB_3_10033_V) ;
lin variety_N = variants{} ; -- 
lin variety_2_N = variants{} ; -- 
lin variety_1_N = variants{} ; -- 
lin press_N = variants{} ; -- 
lin depend_V = variants{} ; -- 
lin bill_N = variants{} ; -- 
lin competition_N = variants{} ; -- 
lin ready_A = mkA "lest" ;
lin general_N = variants{} ; -- 
lin access_N = variants{} ; -- 
lin hit_V2 = lilV2 (laqat_LQT_1_8772_V) ;
lin hit_V = variants{}; -- lilV2 (laqat_LQT_1_8772_V) ;
lin stone_N = mkNColl "ġebla" "ġebel" "ġebliet" "ġbiel" ;
lin useful_A = variants{} ; -- 
lin extent_N = variants{} ; -- 
lin employment_N = variants{} ; -- 
lin regard_V2 = variants{} ; -- 
lin regard_V = variants{} ; -- 
lin apart_Adv = variants{} ; -- 
lin present_N = variants{} ; -- 
lin appeal_N = variants{} ; -- 
lin text_N = variants{} ; -- 
lin parliament_N = variants{} ; -- 
lin cause_N = variants{} ; -- 
lin terms_N = variants{} ; -- 
lin bar_N = variants{} ; -- 
lin bar_2_N = variants{} ; -- 
lin bar_1_N = variants{} ; -- 
lin attack_N = variants{} ; -- 
lin effective_A = variants{} ; -- 
lin mouth_N = possN (mkN "ħalq" "ħluq") ;
lin down_Prep = variants{} ; -- 
lin result_V = variants{} ; -- 
lin fish_N = mkNColl "ħuta" "ħut" "ħutiet" ;
lin future_A = variants{} ; -- 
lin visit_N = variants{} ; -- 
lin little_Adv = variants{} ; -- 
lin easily_Adv = variants{} ; -- 
lin attempt_VV = variants{} ; -- 
lin attempt_V2 = variants{} ; -- 
lin enable_VS = variants{} ; -- 
lin enable_V2V = variants{} ; -- 
lin enable_V2 = variants{} ; -- 
lin trouble_N = variants{} ; -- 
lin traditional_A = variants{} ; -- 
lin payment_N = variants{} ; -- 
lin best_Adv = variants{} ; -- 
lin post_N = variants{} ; -- 
lin county_N = variants{} ; -- 
lin lady_N = variants{} ; -- 
lin holiday_N = variants{} ; -- 
lin realize_VS = variants{} ; -- 
lin realize_V2 = variants{} ; -- 
lin importance_N = variants{} ; -- 
lin chair_N = mkN "siġġu" "siġġijiet" ;
lin facility_N = variants{} ; -- 
lin complete_V2 = variants{} ; -- 
lin complete_V = variants{} ; -- 
lin article_N = variants{} ; -- 
lin object_N = variants{} ; -- 
lin context_N = variants{} ; -- 
lin survey_N = variants{} ; -- 
lin notice_VS = variants{} ; -- 
lin notice_V2 = variants{} ; -- 
lin complete_A = variants{} ; -- 
lin turn_N = variants{} ; -- 
lin direct_A = variants{} ; -- 
lin immediately_Adv = variants{} ; -- 
lin collection_N = variants{} ; -- 
lin reference_N = variants{} ; -- 
lin card_N = variants{} ; -- 
lin interesting_A = variants{} ; -- 
lin considerable_A = variants{} ; -- 
lin television_N = mkN "televixin" "televixins" ;
lin extend_V2 = variants{} ; -- 
lin extend_V = variants{} ; -- 
lin communication_N = variants{} ; -- 
lin agency_N = variants{} ; -- 
lin physical_A = variants{} ; -- 
lin except_Conj = variants{} ; -- 
lin check_V2 = variants{} ; -- 
lin check_V = variants{} ; -- 
lin sun_N = mkN "xemx" "xmux" feminine ;
lin species_N = variants{} ; -- 
lin possibility_N = variants{} ; -- 
lin officialMasc_N = variants{} ; -- 
lin chairman_N = variants{} ; -- 
lin speaker_N = variants{} ; -- 
lin second_N = variants{} ; -- 
lin career_N = variants{} ; -- 
lin laugh_VS = variants{}; -- dahak_DHK_1_7688_V ;
lin laugh_V2 = variants{}; -- dahak_DHK_1_7688_V ;
lin laugh_V = dahak_DHK_1_7688_V ;
lin weight_N = variants{} ; -- 
lin sound_VS = variants{} ; -- 
lin sound_VA = variants{} ; -- 
lin sound_V2 = variants{} ; -- 
lin sound_V = variants{} ; -- 
lin responsible_A = variants{} ; -- 
lin base_N = variants{} ; -- 
lin document_N = variants{} ; -- 
lin solution_N = variants{} ; -- 
lin return_N = variants{} ; -- 
lin medical_A = variants{} ; -- 
lin hot_A = mkA "jaħraq" "taħraq" "jaħarqu" ;
lin recognize_VS = variants{} ; -- 
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin talk_N = variants{} ; -- 
lin budget_N = variants{} ; -- 
lin river_N = mkN "xmara" "xmajjar" ;
lin fit_V2 = variants{} ; -- 
lin fit_V = variants{} ; -- 
lin organization_N = variants{} ; -- 
lin existing_A = variants{} ; -- 
lin start_N = variants{} ; -- 
lin push_VS = variants{}; -- dirV2 (mbotta_V) ; -- GĦAFAS
lin push_V2V = variants{}; -- dirV2 (mbotta_V) ; -- GĦAFAS
lin push_V2 = dirV2 (mbotta_V) ; -- GĦAFAS
lin push_V = variants{}; -- dirV2 (mbotta_V) ; -- GĦAFAS
lin tomorrow_Adv = variants{} ; -- 
lin requirement_N = variants{} ; -- 
lin cold_A = mkA "kiesaħ" "kiesħa" "kesħin" ;
lin edge_N = variants{} ; -- 
lin opposition_N = variants{} ; -- 
lin opinion_N = variants{} ; -- 
lin drug_N = variants{} ; -- 
lin quarter_N = variants{} ; -- 
lin option_N = variants{} ; -- 
lin sign_V2 = variants{} ; -- 
lin sign_V = variants{} ; -- 
lin worth_Prep = variants{} ; -- 
lin call_N = variants{} ; -- 
lin define_V2 = variants{} ; -- 
lin define_V = variants{} ; -- 
lin stock_N = variants{} ; -- 
lin influence_N = variants{} ; -- 
lin occasion_N = variants{} ; -- 
lin eventually_Adv = variants{} ; -- 
lin software_N = variants{} ; -- 
lin highly_Adv = variants{} ; -- 
lin exchange_N = variants{} ; -- 
lin lack_N = variants{} ; -- 
lin shake_V2 = variants{} ; -- 
lin shake_V = variants{} ; -- 
lin study_V2 = variants{} ; -- 
lin study_V = variants{} ; -- 
lin concept_N = variants{} ; -- 
lin blue_A = sameA "blu" ;
lin star_N = mkN "stilla" "stilel" ;
lin radio_N = mkN "radju" "radjijiet" ;
lin arrangement_N = variants{} ; -- 
lin examine_V2 = variants{} ; -- 
lin bird_N = mkN "għasfur" "għasafar" ; -- genderedN
lin green_A = mkA "aħdar" "ħadra" "ħodor" ;
lin band_N = variants{} ; -- 
lin sex_N = variants{} ; -- 
lin finger_N = variants{} ; -- 
lin past_N = variants{} ; -- 
lin independent_A = variants{} ; -- 
lin independent_2_A = variants{} ; -- 
lin independent_1_A = variants{} ; -- 
lin equipment_N = variants{} ; -- 
lin north_N = variants{} ; -- 
lin mind_VS = variants{} ; -- 
lin mind_V2 = variants{} ; -- 
lin mind_V = variants{} ; -- 
lin move_N = variants{} ; -- 
lin message_N = variants{} ; -- 
lin fear_N = variants{} ; -- 
lin afternoon_N = variants{} ; -- 
lin drink_V2 = dirV2 (xorob_XRB_1_10231_V) ;
lin drink_V = variants{}; -- dirV2 (xorob_XRB_1_10231_V) ;
lin fully_Adv = variants{} ; -- 
lin race_N = variants{} ; -- 
lin race_2_N = variants{} ; -- 
lin race_1_N = variants{} ; -- 
lin gain_V2 = variants{} ; -- 
lin gain_V = variants{} ; -- 
lin strategy_N = variants{} ; -- 
lin extra_A = variants{} ; -- 
lin scene_N = variants{} ; -- 
lin slightly_Adv = variants{} ; -- 
lin kitchen_N = variants{} ; -- 
lin speech_N = variants{} ; -- 
lin arise_V = variants{} ; -- 
lin network_N = variants{} ; -- 
lin tea_N = variants{} ; -- 
lin peace_N = mkN "paċi" "paċijiet" feminine ;
lin failure_N = variants{} ; -- 
lin employee_N = variants{} ; -- 
lin ahead_Adv = variants{} ; -- 
lin scale_N = variants{} ; -- 
lin hardly_Adv = variants{} ; -- 
lin attend_V2 = variants{} ; -- 
lin attend_V = variants{} ; -- 
lin shoulder_N = variants{} ; -- 
lin otherwise_Adv = variants{} ; -- 
lin railway_N = variants{} ; -- 
lin directly_Adv = variants{} ; -- 
lin supply_N = variants{} ; -- 
lin expression_N = variants{} ; -- 
lin owner_N = variants{} ; -- 
lin associate_V2 = variants{} ; -- 
lin associate_V = variants{} ; -- 
lin corner_N = variants{} ; -- 
lin past_A = variants{} ; -- 
lin match_N = variants{} ; -- 
lin match_3_N = variants{} ; -- 
lin match_2_N = variants{} ; -- 
lin match_1_N = variants{} ; -- 
lin sport_N = variants{} ; -- 
lin status_N = variants{} ; -- 
lin beautiful_A = brokenA "sabiħ" "sbieħ" "isbaħ" ;
lin offer_N = variants{} ; -- 
lin marriage_N = variants{} ; -- 
lin hang_V2 = variants{} ; -- 
lin hang_V = variants{} ; -- 
lin civil_A = variants{} ; -- 
lin perform_V2 = variants{} ; -- 
lin perform_V = variants{} ; -- 
lin sentence_N = variants{} ; -- 
lin crime_N = variants{} ; -- 
lin ball_N = variants{} ; -- 
lin marry_V2 = variants{} ; -- 
lin marry_V = variants{} ; -- 
lin wind_N = mkN "riħ" "rjieħ" ;
lin truth_N = variants{} ; -- 
lin protect_V2 = variants{} ; -- 
lin protect_V = variants{} ; -- 
lin safety_N = variants{} ; -- 
lin partner_N = variants{} ; -- 
lin completely_Adv = variants{} ; -- 
lin copy_N = variants{} ; -- 
lin balance_N = variants{} ; -- 
lin sister_N = (mkN "oħt" "aħwa" feminine) ;
lin reader_N = variants{} ; -- 
lin below_Adv = variants{} ; -- 
lin trial_N = variants{} ; -- 
lin rock_N = mkNColl "blata" "blat" "blatiet" ;
lin damage_N = variants{} ; -- 
lin adopt_V2 = variants{} ; -- 
lin newspaper_N = mkN "gazzetta" "gazzetti" ;
lin meaning_N = variants{} ; -- 
lin light_A = variants{} ; -- 
lin essential_A = variants{} ; -- 
lin obvious_A = variants{} ; -- 
lin nation_N = variants{} ; -- 
lin confirm_VS = variants{} ; -- 
lin confirm_V2 = variants{} ; -- 
lin south_N = variants{} ; -- 
lin length_N = variants{} ; -- 
lin branch_N = variants{} ; -- 
lin deep_A = variants{} ; -- 
lin none_NP = variants{} ; -- 
lin planning_N = variants{} ; -- 
lin trust_N = variants{} ; -- 
lin working_A = variants{} ; -- 
lin pain_N = variants{} ; -- 
lin studio_N = variants{} ; -- 
lin positive_A = variants{} ; -- 
lin spirit_N = variants{} ; -- 
lin college_N = variants{} ; -- 
lin accident_N = variants{} ; -- 
lin star_V2 = variants{} ; -- 
lin hope_N = variants{} ; -- 
lin mark_V3 = variants{} ; -- 
lin mark_V2 = variants{} ; -- 
lin works_N = variants{} ; -- 
lin league_N = variants{} ; -- 
lin league_2_N = variants{} ; -- 
lin league_1_N = variants{} ; -- 
lin clear_V2 = variants{} ; -- 
lin clear_V = variants{} ; -- 
lin imagine_VS = variants{} ; -- 
lin imagine_V2 = variants{} ; -- 
lin imagine_V = variants{} ; -- 
lin through_Adv = variants{}; -- mkPrep "minn ġo" "minn ġo" "minn ġol-" "minn ġot-" "minn ġol-" "minn ġo fija" "minn ġo fik" "minn ġo fih" "minn ġo fiha" "minn ġo fina" "minn ġo fikom" "minn ġo fihom" False ;
lin cash_N = variants{} ; -- 
lin normally_Adv = variants{} ; -- 
lin play_N = variants{} ; -- 
lin strength_N = variants{} ; -- 
lin train_N = mkN "ferrovija" "ferroviji" ;
lin travel_V2 = variants{}; -- vvjagga_V ;
lin travel_V = vvjagga_V ;
lin target_N = variants{} ; -- 
lin very_A = variants{} ; -- 
lin pair_N = variants{} ; -- 
lin male_A = variants{} ; -- 
lin gas_N = variants{} ; -- 
lin issue_V2 = variants{} ; -- 
lin issue_V = variants{} ; -- 
lin contribution_N = variants{} ; -- 
lin complex_A = variants{} ; -- 
lin supply_V2 = variants{} ; -- 
lin beat_V2 = variants{} ; -- 
lin beat_V = variants{} ; -- 
lin artist_N = variants{} ; -- 
lin agentMasc_N = variants{} ; -- 
lin presence_N = variants{} ; -- 
lin along_Adv = variants{} ; -- 
lin environmental_A = variants{} ; -- 
lin strike_V2 = variants{} ; -- 
lin strike_V = variants{} ; -- 
lin contact_N = variants{} ; -- 
lin protection_N = variants{} ; -- 
lin beginning_N = variants{} ; -- 
lin demand_VS = variants{} ; -- 
lin demand_V2 = variants{} ; -- 
lin media_N = variants{} ; -- 
lin relevant_A = variants{} ; -- 
lin employ_V2 = variants{} ; -- 
lin shoot_V2 = variants{} ; -- 
lin shoot_V = variants{} ; -- 
lin executive_N = variants{} ; -- 
lin slowly_Adv = variants{} ; -- 
lin relatively_Adv = variants{} ; -- 
lin aid_N = variants{} ; -- 
lin huge_A = variants{} ; -- 
lin late_Adv = variants{} ; -- 
lin speed_N = variants{} ; -- 
lin review_N = variants{} ; -- 
lin test_V2 = variants{} ; -- 
lin order_VS = variants{} ; -- 
lin order_V2V = variants{} ; -- 
lin order_V2 = variants{} ; -- 
lin order_V = variants{} ; -- 
lin route_N = variants{} ; -- 
lin consequence_N = variants{} ; -- 
lin telephone_N = variants{} ; -- 
lin release_V2 = variants{} ; -- 
lin proportion_N = variants{} ; -- 
lin primary_A = variants{} ; -- 
lin consideration_N = variants{} ; -- 
lin reform_N = variants{} ; -- 
lin driverMasc_N = variants{} ; -- 
lin annual_A = variants{} ; -- 
lin nuclear_A = variants{} ; -- 
lin latter_A = variants{} ; -- 
lin practical_A = variants{} ; -- 
lin commercial_A = variants{} ; -- 
lin rich_A = variants{} ; -- 
lin emerge_V = variants{} ; -- 
lin apparently_Adv = variants{} ; -- 
lin ring_V = variants{} ; -- 
lin ring_6_V2 = variants{} ; -- 
lin ring_4_V2 = variants{} ; -- 
lin distance_N = variants{} ; -- 
lin exercise_N = variants{} ; -- 
lin key_A = variants{} ; -- 
lin close_Adv = variants{} ; -- 
lin skin_N = mkN "ġilda" "ġildiet" ;
lin island_N = variants{} ; -- 
lin separate_A = variants{} ; -- 
lin aim_VV = variants{} ; -- 
lin aim_V2 = variants{} ; -- 
lin aim_V = variants{} ; -- 
lin danger_N = variants{} ; -- 
lin credit_N = variants{} ; -- 
lin usual_A = variants{} ; -- 
lin link_V2 = variants{} ; -- 
lin link_V = variants{} ; -- 
lin candidateMasc_N = variants{} ; -- 
lin track_N = variants{} ; -- 
lin safe_A = variants{} ; -- 
lin interested_A = variants{} ; -- 
lin assessment_N = variants{} ; -- 
lin path_N = variants{} ; -- 
lin merely_Adv = variants{} ; -- 
lin plus_Prep = variants{} ; -- 
lin district_N = variants{} ; -- 
lin regular_A = variants{} ; -- 
lin reaction_N = variants{} ; -- 
lin impact_N = variants{} ; -- 
lin collect_V2 = variants{} ; -- 
lin collect_V = variants{} ; -- 
lin debate_N = variants{} ; -- 
lin lay_V2 = variants{} ; -- 
lin lay_V = variants{} ; -- 
lin rise_N = variants{} ; -- 
lin belief_N = variants{} ; -- 
lin conclusion_N = variants{} ; -- 
lin shape_N = variants{} ; -- 
lin vote_N = variants{} ; -- 
lin aim_N = variants{} ; -- 
lin politics_N = variants{} ; -- 
lin reply_VS = variants{} ; -- 
lin reply_V = variants{} ; -- 
lin press_V2V = variants{} ; -- 
lin press_V2 = variants{} ; -- 
lin press_V = variants{} ; -- 
lin approach_V2 = variants{} ; -- 
lin approach_V = variants{} ; -- 
lin file_N = variants{} ; -- 
lin western_A = variants{} ; -- 
lin earth_N = mkN "art" "artijiet" feminine ;
lin public_N = variants{} ; -- 
lin survive_V2 = variants{} ; -- 
lin survive_V = variants{} ; -- 
lin estate_N = variants{} ; -- 
lin boat_N = mkN "dgħajsa" "dgħajjes" ;
lin prison_N = variants{} ; -- 
lin additional_A = variants{} ; -- 
lin settle_V2 = variants{} ; -- 
lin settle_V = variants{} ; -- 
lin largely_Adv = variants{} ; -- 
lin wine_N = mkNColl "nbid" "nbejjed" ;
lin observe_VS = variants{} ; -- 
lin observe_V2 = variants{} ; -- 
lin limit_V2V = variants{} ; -- 
lin limit_V2 = variants{} ; -- 
lin deny_V3 = variants{} ; -- 
lin deny_V2 = variants{} ; -- 
lin for_PConj = variants{} ; -- 
lin straight_Adv = variants{} ; -- 
lin somebody_NP = regNP "xi ħadd" ;
lin writer_N = variants{} ; -- 
lin weekend_N = variants{} ; -- 
lin clothes_N = variants{} ; -- 
lin active_A = variants{} ; -- 
lin sight_N = variants{} ; -- 
lin video_N = variants{} ; -- 
lin reality_N = variants{} ; -- 
lin hall_N = variants{} ; -- 
lin nevertheless_Adv = variants{} ; -- 
lin regional_A = variants{} ; -- 
lin vehicle_N = variants{} ; -- 
lin worry_VS = variants{} ; -- 
lin worry_V2 = variants{} ; -- 
lin worry_V = variants{} ; -- 
lin powerful_A = variants{} ; -- 
lin possibly_Adv = variants{} ; -- 
lin cross_V2 = variants{} ; -- 
lin cross_V = variants{} ; -- 
lin colleague_N = variants{} ; -- 
lin charge_V2 = variants{} ; -- 
lin charge_V = variants{} ; -- 
lin lead_N = variants{} ; -- 
lin farm_N = variants{} ; -- 
lin respond_VS = variants{} ; -- 
lin respond_V = variants{} ; -- 
lin employer_N = variants{} ; -- 
lin carefully_Adv = variants{} ; -- 
lin understanding_N = variants{} ; -- 
lin connection_N = variants{} ; -- 
lin comment_N = variants{} ; -- 
lin grant_V3 = variants{} ; -- 
lin grant_V2 = variants{} ; -- 
lin concentrate_V2 = variants{} ; -- 
lin concentrate_V = variants{} ; -- 
lin ignore_V2 = variants{} ; -- 
lin ignore_V = variants{} ; -- 
lin phone_N = variants{} ; -- 
lin hole_N = variants{} ; -- 
lin insurance_N = variants{} ; -- 
lin content_N = variants{} ; -- 
lin confidence_N = variants{} ; -- 
lin sample_N = variants{} ; -- 
lin transport_N = variants{} ; -- 
lin objective_N = variants{} ; -- 
lin alone_A = variants{} ; -- 
lin flower_N = mkN "fjura" "fjuri" ;
lin injury_N = variants{} ; -- 
lin lift_V2 = variants{} ; -- 
lin lift_V = variants{} ; -- 
lin stick_V2 = variants{} ; -- 
lin stick_V = variants{} ; -- 
lin front_A = variants{} ; -- 
lin mainly_Adv = variants{} ; -- 
lin battle_N = variants{} ; -- 
lin generation_N = variants{} ; -- 
lin currently_Adv = variants{} ; -- 
lin winter_N = variants{} ; -- 
lin inside_Prep = variants{} ; -- 
lin impossible_A = variants{} ; -- 
lin somewhere_Adv = mkAdv "x'imkien" ;
lin arrange_V2 = variants{} ; -- 
lin arrange_V = variants{} ; -- 
lin will_N = variants{} ; -- 
lin sleep_V = raqad_RQD_1_9469_V ;
lin progress_N = variants{} ; -- 
lin volume_N = variants{} ; -- 
lin ship_N = mkN "vapur" "vapuri" ;
lin legislation_N = variants{} ; -- 
lin commitment_N = variants{} ; -- 
lin enough_Predet = variants{} ; -- 
lin conflict_N = variants{} ; -- 
lin bag_N = variants{} ; -- 
lin fresh_A = variants{} ; -- 
lin entry_N = variants{} ; -- 
lin entry_2_N = variants{} ; -- 
lin entry_1_N = variants{} ; -- 
lin smile_N = variants{} ; -- 
lin fair_A = variants{} ; -- 
lin promise_VV = variants{} ; -- 
lin promise_VS = variants{} ; -- 
lin promise_V2 = variants{} ; -- 
lin promise_V = variants{} ; -- 
lin introduction_N = variants{} ; -- 
lin senior_A = variants{} ; -- 
lin manner_N = variants{} ; -- 
lin background_N = variants{} ; -- 
lin key_N = variants{} ; -- 
lin key_2_N = variants{} ; -- 
lin key_1_N = variants{} ; -- 
lin touch_V2 = variants{} ; -- 
lin touch_V = variants{} ; -- 
lin vary_V2 = variants{} ; -- 
lin vary_V = variants{} ; -- 
lin sexual_A = variants{} ; -- 
lin ordinary_A = variants{} ; -- 
lin cabinet_N = variants{} ; -- 
lin painting_N = variants{} ; -- 
lin entirely_Adv = variants{} ; -- 
lin engine_N = variants{} ; -- 
lin previously_Adv = variants{} ; -- 
lin administration_N = variants{} ; -- 
lin tonight_Adv = variants{} ; -- 
lin adult_N = variants{} ; -- 
lin prefer_VV = variants{} ; -- 
lin prefer_V2 = variants{} ; -- 
lin author_N = variants{} ; -- 
lin actual_A = variants{} ; -- 
lin song_N = mkN "kanzunetta" "kanzunetti" ;
lin investigation_N = variants{} ; -- 
lin debt_N = variants{} ; -- 
lin visitor_N = variants{} ; -- 
lin forest_N = mkN "foresta" "foresti" ;
lin repeat_VS = variants{} ; -- 
lin repeat_V2 = variants{} ; -- 
lin repeat_V = variants{} ; -- 
lin wood_N = mkN "injam" "injamiet" ;
lin contrast_N = variants{} ; -- 
lin extremely_Adv = variants{} ; -- 
lin wage_N = variants{} ; -- 
lin domestic_A = variants{} ; -- 
lin commit_V2 = variants{} ; -- 
lin threat_N = variants{} ; -- 
lin bus_N = variants{} ; -- 
lin warm_A = brokenA "sħun" "sħan" ;
lin sir_N = variants{} ; -- 
lin regulation_N = variants{} ; -- 
lin drink_N = variants{} ; -- 
lin relief_N = variants{} ; -- 
lin internal_A = variants{} ; -- 
lin strange_A = variants{} ; -- 
lin excellent_A = variants{} ; -- 
lin run_N = variants{} ; -- 
lin fairly_Adv = variants{} ; -- 
lin technical_A = variants{} ; -- 
lin tradition_N = variants{} ; -- 
lin measure_V2 = variants{} ; -- 
lin measure_V = variants{} ; -- 
lin insist_VS = variants{} ; -- 
lin insist_V2 = variants{} ; -- 
lin insist_V = variants{} ; -- 
lin farmer_N = variants{} ; -- 
lin until_Prep = variants{} ; -- 
lin traffic_N = variants{} ; -- 
lin dinner_N = variants{} ; -- 
lin consumer_N = variants{} ; -- 
lin meal_N = variants{} ; -- 
lin warn_VS = variants{} ; -- 
lin warn_V2V = variants{} ; -- 
lin warn_V2 = variants{} ; -- 
lin warn_V = variants{} ; -- 
lin living_A = variants{} ; -- 
lin package_N = variants{} ; -- 
lin half_N = variants{} ; -- 
lin increasingly_Adv = variants{} ; -- 
lin description_N = variants{} ; -- 
lin soft_A = variants{} ; -- 
lin stuff_N = variants{} ; -- 
lin award_V3 = variants{} ; -- 
lin award_V2 = variants{} ; -- 
lin existence_N = variants{} ; -- 
lin improvement_N = variants{} ; -- 
lin coffee_N = variants{} ; -- 
lin appearance_N = variants{} ; -- 
lin standard_A = variants{} ; -- 
lin attack_V2 = variants{} ; -- 
lin sheet_N = variants{} ; -- 
lin category_N = variants{} ; -- 
lin distribution_N = variants{} ; -- 
lin equally_Adv = variants{} ; -- 
lin session_N = variants{} ; -- 
lin cultural_A = variants{} ; -- 
lin loan_N = variants{} ; -- 
lin bind_V2 = variants{} ; -- 
lin bind_V = variants{} ; -- 
lin museum_N = variants{} ; -- 
lin conversation_N = variants{} ; -- 
lin threaten_VV = variants{} ; -- 
lin threaten_VS = variants{} ; -- 
lin threaten_V2 = variants{} ; -- 
lin threaten_V = variants{} ; -- 
lin link_N = variants{} ; -- 
lin launch_V2 = variants{} ; -- 
lin launch_V = variants{} ; -- 
lin proper_A = variants{} ; -- 
lin victim_N = variants{} ; -- 
lin audience_N = variants{} ; -- 
lin famous_A = variants{} ; -- 
lin master_N = variants{} ; -- 
lin master_2_N = variants{} ; -- 
lin master_1_N = variants{} ; -- 
lin lip_N = variants{} ; -- 
lin religious_A = variants{} ; -- 
lin joint_A = variants{} ; -- 
lin cry_V2 = variants{} ; -- 
lin cry_V = variants{} ; -- 
lin potential_A = variants{} ; -- 
lin broad_A = mkA "wiesgħa" "wiesgħa" "wiesgħin" ;
lin exhibition_N = variants{} ; -- 
lin experience_V2 = variants{} ; -- 
lin judge_N = variants{} ; -- 
lin formal_A = variants{} ; -- 
lin housing_N = variants{} ; -- 
lin past_Prep = variants{} ; -- 
lin concern_V2 = variants{} ; -- 
lin freedom_N = variants{} ; -- 
lin gentleman_N = variants{} ; -- 
lin attract_V2 = variants{} ; -- 
lin explanation_N = variants{} ; -- 
lin appoint_V3 = variants{} ; -- 
lin appoint_V2V = variants{} ; -- 
lin appoint_V2 = variants{} ; -- 
lin note_VS = variants{} ; -- 
lin note_V2 = variants{} ; -- 
lin note_V = variants{} ; -- 
lin chief_A = variants{} ; -- 
lin total_N = variants{} ; -- 
lin lovely_A = variants{} ; -- 
lin official_A = variants{} ; -- 
lin date_V2 = variants{} ; -- 
lin date_V = variants{} ; -- 
lin demonstrate_VS = variants{} ; -- 
lin demonstrate_V2 = variants{} ; -- 
lin demonstrate_V = variants{} ; -- 
lin construction_N = variants{} ; -- 
lin middle_N = variants{} ; -- 
lin yard_N = variants{} ; -- 
lin unable_A = variants{} ; -- 
lin acquire_V2 = variants{} ; -- 
lin surely_Adv = variants{} ; -- 
lin crisis_N = variants{} ; -- 
lin propose_VV = variants{} ; -- 
lin propose_VS = variants{} ; -- 
lin propose_V2 = variants{} ; -- 
lin propose_V = variants{} ; -- 
lin west_N = variants{} ; -- 
lin impose_V2 = variants{} ; -- 
lin impose_V = variants{} ; -- 
lin market_V2 = variants{} ; -- 
lin market_V = variants{} ; -- 
lin care_V = variants{} ; -- 
lin god_N = variants{} ; -- 
lin favour_N = variants{} ; -- 
lin before_Adv = variants{}; -- mkPrep "qabel" "qabli" "qablek" "qablu" "qabilha" "qabilna" "qabilkom" "qabilhom" ;
lin name_V3 = variants{} ; -- 
lin name_V2 = variants{} ; -- 
lin equal_A = variants{} ; -- 
lin capacity_N = variants{} ; -- 
lin flat_N = variants{} ; -- 
lin selection_N = variants{} ; -- 
lin alone_Adv = variants{} ; -- 
lin football_N = variants{} ; -- 
lin victory_N = variants{} ; -- 
lin factory_N = mkN "fabbrika" "fabbriki" ;
lin rural_A = variants{} ; -- 
lin twice_Adv = variants{} ; -- 
lin sing_V2 = variants{}; -- kanta_KNTJ_1_7016_V ;
lin sing_V = kanta_KNTJ_1_7016_V ;
lin whereas_Subj = variants{} ; -- 
lin own_V2 = variants{} ; -- 
lin head_V2 = variants{} ; -- 
lin head_V = variants{} ; -- 
lin examination_N = variants{} ; -- 
lin deliver_V2 = variants{} ; -- 
lin deliver_V = variants{} ; -- 
lin nobody_NP = regNP "ħadd" ;
lin substantial_A = variants{} ; -- 
lin invite_V2V = variants{} ; -- 
lin invite_V2 = variants{} ; -- 
lin intention_N = variants{} ; -- 
lin egg_N = mkNColl "bajda" "bajd" "bajdiet" ;
lin reasonable_A = variants{} ; -- 
lin onto_Prep = variants{} ; -- 
lin retain_V2 = variants{} ; -- 
lin aircraft_N = variants{} ; -- 
lin decade_N = variants{} ; -- 
lin cheap_A = variants{} ; -- 
lin quiet_A = variants{} ; -- 
lin bright_A = variants{} ; -- 
lin contribute_V2 = variants{} ; -- 
lin contribute_V = variants{} ; -- 
lin row_N = variants{} ; -- 
lin search_N = variants{} ; -- 
lin limit_N = variants{} ; -- 
lin definition_N = variants{} ; -- 
lin unemployment_N = variants{} ; -- 
lin spread_V2 = variants{} ; -- 
lin spread_V = variants{} ; -- 
lin mark_N = variants{} ; -- 
lin flight_N = variants{} ; -- 
lin account_V2 = variants{} ; -- 
lin account_V = variants{} ; -- 
lin output_N = variants{} ; -- 
lin last_V = variants{} ; -- 
lin tour_N = variants{} ; -- 
lin address_N = variants{} ; -- 
lin immediate_A = variants{} ; -- 
lin reduction_N = variants{} ; -- 
lin interview_N = variants{} ; -- 
lin assess_V2 = variants{} ; -- 
lin promote_V2 = variants{} ; -- 
lin promote_V = variants{} ; -- 
lin everybody_NP = regNP "kulħadd" ;
lin suitable_A = variants{} ; -- 
lin growing_A = variants{} ; -- 
lin nod_V = variants{} ; -- 
lin reject_V2 = variants{} ; -- 
lin while_N = variants{} ; -- 
lin high_Adv = variants{} ; -- 
lin dream_N = variants{} ; -- 
lin vote_VV = variants{} ; -- 
lin vote_V3 = variants{} ; -- 
lin vote_V2 = variants{} ; -- 
lin vote_V = variants{} ; -- 
lin divide_V2 = variants{} ; -- 
lin divide_V = variants{} ; -- 
lin declare_VS = variants{} ; -- 
lin declare_V2 = variants{} ; -- 
lin declare_V = variants{} ; -- 
lin handle_V2 = variants{} ; -- 
lin handle_V = variants{} ; -- 
lin detailed_A = variants{} ; -- 
lin challenge_N = variants{} ; -- 
lin notice_N = variants{} ; -- 
lin rain_N = mkNNoPlural "xita" ;
lin destroy_V2 = variants{} ; -- 
lin mountain_N = mkN "muntanja" "muntanji" ;
lin concentration_N = variants{} ; -- 
lin limited_A = variants{} ; -- 
lin finance_N = variants{} ; -- 
lin pension_N = variants{} ; -- 
lin influence_V2 = variants{} ; -- 
lin afraid_A = variants{} ; -- 
lin murder_N = variants{} ; -- 
lin neck_N = possN (mkN "għonq" "għenuq") ;
lin weapon_N = variants{} ; -- 
lin hide_V2 = variants{} ; -- 
lin hide_V = variants{} ; -- 
lin offence_N = variants{} ; -- 
lin absence_N = variants{} ; -- 
lin error_N = variants{} ; -- 
lin representativeMasc_N = variants{} ; -- 
lin enterprise_N = variants{} ; -- 
lin criticism_N = variants{} ; -- 
lin average_A = variants{} ; -- 
lin quick_A = variants{} ; -- 
lin sufficient_A = variants{} ; -- 
lin appointment_N = variants{} ; -- 
lin match_V2 = variants{} ; -- 
lin transfer_V = variants{} ; -- 
lin acid_N = variants{} ; -- 
lin spring_N = variants{} ; -- 
lin birth_N = variants{} ; -- 
lin ear_N = possN (mkNDual "widna" "widnejn" "widniet") ;
lin recognize_VS = variants{} ; -- 
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin recommend_V2V = variants{} ; -- 
lin recommend_V2 = variants{} ; -- 
lin module_N = variants{} ; -- 
lin instruction_N = variants{} ; -- 
lin democratic_A = variants{} ; -- 
lin park_N = variants{} ; -- 
lin weather_N = variants{} ; -- 
lin bottle_N = variants{} ; -- 
lin address_V2 = variants{} ; -- 
lin bedroom_N = variants{} ; -- 
lin kid_N = variants{} ; -- 
lin pleasure_N = variants{} ; -- 
lin realize_VS = variants{} ; -- 
lin realize_V2 = variants{} ; -- 
lin assembly_N = variants{} ; -- 
lin expensive_A = variants{} ; -- 
lin select_VV = variants{} ; -- 
lin select_V2V = variants{} ; -- 
lin select_V2 = variants{} ; -- 
lin select_V = variants{} ; -- 
lin teaching_N = variants{} ; -- 
lin desire_N = variants{} ; -- 
lin whilst_Subj = variants{} ; -- 
lin contact_V2 = variants{} ; -- 
lin implication_N = variants{} ; -- 
lin combine_VV = variants{} ; -- 
lin combine_V2 = variants{} ; -- 
lin combine_V = variants{} ; -- 
lin temperature_N = variants{} ; -- 
lin wave_N = variants{} ; -- 
lin magazine_N = variants{} ; -- 
lin totally_Adv = variants{} ; -- 
lin mental_A = variants{} ; -- 
lin used_A = variants{} ; -- 
lin store_N = variants{} ; -- 
lin scientific_A = variants{} ; -- 
lin frequently_Adv = variants{} ; -- 
lin thanks_N = variants{} ; -- 
lin beside_Prep = variants{} ; -- 
lin settlement_N = variants{} ; -- 
lin absolutely_Adv = variants{} ; -- 
lin critical_A = variants{} ; -- 
lin critical_2_A = variants{} ; -- 
lin critical_1_A = variants{} ; -- 
lin recognition_N = variants{} ; -- 
lin touch_N = variants{} ; -- 
lin consist_V = variants{} ; -- 
lin below_Prep = variants{} ; -- 
lin silence_N = variants{} ; -- 
lin expenditure_N = variants{} ; -- 
lin institute_N = variants{} ; -- 
lin dress_V2 = variants{} ; -- 
lin dress_V = variants{} ; -- 
lin dangerous_A = variants{} ; -- 
lin familiar_A = variants{} ; -- 
lin asset_N = variants{} ; -- 
lin educational_A = variants{} ; -- 
lin sum_N = variants{} ; -- 
lin publication_N = variants{} ; -- 
lin partly_Adv = variants{} ; -- 
lin block_N = variants{} ; -- 
lin seriously_Adv = variants{} ; -- 
lin youth_N = variants{} ; -- 
lin tape_N = variants{} ; -- 
lin elsewhere_Adv = variants{} ; -- 
lin cover_N = variants{} ; -- 
lin fee_N = variants{} ; -- 
lin program_N = variants{} ; -- 
lin treaty_N = variants{} ; -- 
lin necessarily_Adv = variants{} ; -- 
lin unlikely_A = variants{} ; -- 
lin properly_Adv = variants{} ; -- 
lin guest_N = variants{} ; -- 
lin code_N = variants{} ; -- 
lin hill_N = mkN "għolja" "għoljiet" ;
lin screen_N = variants{} ; -- 
lin household_N = variants{} ; -- 
lin sequence_N = variants{} ; -- 
lin correct_A = mkA "korrett" ;
lin female_A = variants{} ; -- 
lin phase_N = variants{} ; -- 
lin crowd_N = variants{} ; -- 
lin welcome_V2 = variants{} ; -- 
lin metal_N = variants{} ; -- 
lin human_N = variants{} ; -- 
lin widely_Adv = variants{} ; -- 
lin undertake_V2 = variants{} ; -- 
lin cut_N = variants{} ; -- 
lin sky_N = mkN "sema" "smewwiet" masculine ;
lin brain_N = variants{} ; -- 
lin expert_N = variants{} ; -- 
lin experiment_N = variants{} ; -- 
lin tiny_A = variants{} ; -- 
lin perfect_A = variants{} ; -- 
lin disappear_V = variants{} ; -- 
lin initiative_N = variants{} ; -- 
lin assumption_N = variants{} ; -- 
lin photograph_N = variants{} ; -- 
lin ministry_N = variants{} ; -- 
lin congress_N = variants{} ; -- 
lin transfer_N = variants{} ; -- 
lin reading_N = variants{} ; -- 
lin scientist_N = variants{} ; -- 
lin fast_Adv = variants{} ; -- 
lin fast_A = variants{} ; -- 
lin closely_Adv = variants{} ; -- 
lin thin_A = brokenA "rqiq" "rqaq" "rqaq" ;
lin solicitorMasc_N = variants{} ; -- 
lin secure_V2 = variants{} ; -- 
lin plate_N = variants{} ; -- 
lin pool_N = variants{} ; -- 
lin gold_N = mkNColl "deheb" "dehbijiet" ;
lin emphasis_N = variants{} ; -- 
lin recall_VS = variants{} ; -- 
lin recall_V2 = variants{} ; -- 
lin shout_V2 = variants{} ; -- 
lin shout_V = variants{} ; -- 
lin generate_V2 = variants{} ; -- 
lin location_N = variants{} ; -- 
lin display_VS = variants{} ; -- 
lin display_V2 = variants{} ; -- 
lin heat_N = variants{} ; -- 
lin gun_N = variants{} ; -- 
lin shut_V2 = variants{} ; -- 
lin journey_N = variants{} ; -- 
lin imply_VS = variants{} ; -- 
lin imply_V2 = variants{} ; -- 
lin imply_V = variants{} ; -- 
lin violence_N = variants{} ; -- 
lin dry_A = mkA "niexef" ;
lin historical_A = variants{} ; -- 
lin step_V2 = variants{} ; -- 
lin step_V = variants{} ; -- 
lin curriculum_N = variants{} ; -- 
lin noise_N = variants{} ; -- 
lin lunch_N = variants{} ; -- 
lin fear_VS = beza'_BZGH_1_7541_V;
lin fear_V2 = prepV2 (beza'_BZGH_1_7541_V) minnP ;
lin fear_V = variants{}; -- prepV2 (beza'_BZGH_1_7541_V) minnP ;
lin succeed_V2 = variants{} ; -- 
lin succeed_V = variants{} ; -- 
lin fall_N = variants{} ; -- 
lin fall_2_N = variants{} ; -- 
lin fall_1_N = variants{} ; -- 
lin bottom_N = variants{} ; -- 
lin initial_A = variants{} ; -- 
lin theme_N = variants{} ; -- 
lin characteristic_N = variants{} ; -- 
lin pretty_Adv = variants{} ; -- 
lin empty_A = mkA "vojt" "vojta" "vojta" ;
lin display_N = variants{} ; -- 
lin combination_N = variants{} ; -- 
lin interpretation_N = variants{} ; -- 
lin rely_V2 = variants{} ; -- 
lin rely_V = variants{} ; -- 
lin escape_VS = variants{} ; -- 
lin escape_V2 = variants{} ; -- 
lin escape_V = variants{} ; -- 
lin score_V2 = variants{} ; -- 
lin score_V = variants{} ; -- 
lin justice_N = variants{} ; -- 
lin upper_A = variants{} ; -- 
lin tooth_N = possN (mkN "sinna" "sinniet" "snien") ;
lin organize_V2V = variants{} ; -- 
lin organize_V2 = variants{} ; -- 
lin cat_N = mkN "qattus" "qtates" ; -- genderedN
lin tool_N = variants{} ; -- 
lin spot_N = variants{} ; -- 
lin bridge_N = variants{} ; -- 
lin double_A = variants{} ; -- 
lin direct_V2 = variants{} ; -- 
lin direct_V = variants{} ; -- 
lin conclude_VS = variants{} ; -- 
lin conclude_V2 = variants{} ; -- 
lin conclude_V = variants{} ; -- 
lin relative_A = variants{} ; -- 
lin soldier_N = variants{} ; -- 
lin climb_V2 = variants{} ; -- 
lin climb_V = variants{} ; -- 
lin breath_N = variants{} ; -- 
lin afford_V2V = variants{} ; -- 
lin afford_V2 = variants{} ; -- 
lin urban_A = variants{} ; -- 
lin nurse_N = variants{} ; -- 
lin narrow_A = mkA "dejjaq" "dejqa" "dojoq" "idjaq" ;
lin liberal_A = variants{} ; -- 
lin coal_N = variants{} ; -- 
lin priority_N = variants{} ; -- 
lin wild_A = variants{} ; -- 
lin revenue_N = variants{} ; -- 
lin membership_N = variants{} ; -- 
lin grant_N = variants{} ; -- 
lin approve_V2 = variants{} ; -- 
lin approve_V = variants{} ; -- 
lin tall_A = variants{} ; -- 
lin apparent_A = variants{} ; -- 
lin faith_N = variants{} ; -- 
lin under_Adv = variants{}; -- mkPrep "taħt" ;
lin fix_V2 = variants{} ; -- 
lin fix_V = variants{} ; -- 
lin slow_A = variants{} ; -- 
lin troop_N = variants{} ; -- 
lin motion_N = variants{} ; -- 
lin leading_A = variants{} ; -- 
lin component_N = variants{} ; -- 
lin bloody_A = variants{} ; -- 
lin literature_N = variants{} ; -- 
lin conservative_A = variants{} ; -- 
lin variation_N = variants{} ; -- 
lin remind_V2 = variants{} ; -- 
lin inform_V2 = variants{} ; -- 
lin inform_V = variants{} ; -- 
lin alternative_N = variants{} ; -- 
lin neither_Adv = variants{} ; -- 
lin outside_Adv = variants{} ; -- 
lin mass_N = variants{} ; -- 
lin busy_A = variants{} ; -- 
lin chemical_N = variants{} ; -- 
lin careful_A = variants{} ; -- 
lin investigate_V2 = variants{} ; -- 
lin investigate_V = variants{} ; -- 
lin roll_V2 = variants{} ; -- 
lin roll_V = variants{} ; -- 
lin instrument_N = variants{} ; -- 
lin guide_N = variants{} ; -- 
lin criterion_N = variants{} ; -- 
lin pocket_N = variants{} ; -- 
lin suggestion_N = variants{} ; -- 
lin aye_Interj = variants{} ; -- 
lin entitle_VS = variants{} ; -- 
lin entitle_V2V = variants{} ; -- 
lin tone_N = variants{} ; -- 
lin attractive_A = variants{} ; -- 
lin wing_N = mkN "ġewnaħ" "ġwienaħ" ;
lin surprise_N = variants{} ; -- 
lin male_N = variants{} ; -- 
lin ring_N = variants{} ; -- 
lin pub_N = variants{} ; -- 
lin fruit_N = mkNColl "frotta" "frott" "frottiet" "frottijiet" ;
lin passage_N = variants{} ; -- 
lin illustrate_VS = variants{} ; -- 
lin illustrate_V2 = variants{} ; -- 
lin illustrate_V = variants{} ; -- 
lin pay_N = variants{} ; -- 
lin ride_V2 = variants{} ; -- 
lin ride_V = variants{} ; -- 
lin foundation_N = variants{} ; -- 
lin restaurant_N = mkN "restorant" "restoranti" ;
lin vital_A = variants{} ; -- 
lin alternative_A = variants{} ; -- 
lin burn_V2 = variants{}; -- haraq_HRQ_1_8367_V ;
lin burn_V = haraq_HRQ_1_8367_V ;
lin map_N = variants{} ; -- 
lin united_A = variants{} ; -- 
lin device_N = variants{} ; -- 
lin jump_V2 = variants{}; -- qabez_QBZ_1_9182_V ;
lin jump_V = qabez_QBZ_1_9182_V ;
lin estimate_VS = variants{} ; -- 
lin estimate_V2V = variants{} ; -- 
lin estimate_V2 = variants{} ; -- 
lin estimate_V = variants{} ; -- 
lin conduct_V2 = variants{} ; -- 
lin conduct_V = variants{} ; -- 
lin derive_V2 = variants{} ; -- 
lin derive_V = variants{} ; -- 
lin comment_VS = variants{} ; -- 
lin comment_V2 = variants{} ; -- 
lin comment_V = variants{} ; -- 
lin east_N = variants{} ; -- 
lin advise_VS = variants{} ; -- 
lin advise_V2 = variants{} ; -- 
lin advise_V = variants{} ; -- 
lin advance_N = variants{} ; -- 
lin motor_N = variants{} ; -- 
lin satisfy_V2 = variants{} ; -- 
lin hell_N = variants{} ; -- 
lin winner_N = variants{} ; -- 
lin effectively_Adv = variants{} ; -- 
lin mistake_N = variants{} ; -- 
lin incident_N = variants{} ; -- 
lin focus_V2 = variants{} ; -- 
lin focus_V = variants{} ; -- 
lin exercise_VV = variants{} ; -- 
lin exercise_V2 = variants{} ; -- 
lin exercise_V = variants{} ; -- 
lin representation_N = variants{} ; -- 
lin release_N = variants{} ; -- 
lin leaf_N = mkNDual "werqa" "werqtejn" "werqiet" ;
lin border_N = variants{} ; -- 
lin wash_V2 = lilV2 (hasel_HSL_1_8395_V) ;
lin wash_V = variants{}; -- lilV2 (hasel_HSL_1_8395_V) ;
lin prospect_N = variants{} ; -- 
lin blow_V2 = variants{}; -- nefah_NFH_1_8966_V ;
lin blow_V = nefah_NFH_1_8966_V ;
lin trip_N = variants{} ; -- 
lin observation_N = variants{} ; -- 
lin gather_V2 = variants{} ; -- 
lin gather_V = variants{} ; -- 
lin ancient_A = variants{} ; -- 
lin brief_A = variants{} ; -- 
lin gate_N = variants{} ; -- 
lin elderly_A = variants{} ; -- 
lin persuade_V2V = variants{} ; -- 
lin persuade_V2 = variants{} ; -- 
lin overall_A = variants{} ; -- 
lin rare_A = variants{} ; -- 
lin index_N = variants{} ; -- 
lin hand_V2 = variants{} ; -- 
lin circle_N = variants{} ; -- 
lin creation_N = variants{} ; -- 
lin drawing_N = variants{} ; -- 
lin anybody_NP = variants{} ; -- 
lin flow_N = variants{} ; -- 
lin matter_V = variants{} ; -- 
lin external_A = variants{} ; -- 
lin capable_A = variants{} ; -- 
lin recover_V = variants{} ; -- 
lin shot_N = variants{} ; -- 
lin request_N = variants{} ; -- 
lin impression_N = variants{} ; -- 
lin neighbour_N = variants{} ; -- 
lin theatre_N = variants{} ; -- 
lin beneath_Prep = variants{} ; -- 
lin hurt_V2 = variants{} ; -- 
lin hurt_V = variants{} ; -- 
lin mechanism_N = variants{} ; -- 
lin potential_N = variants{} ; -- 
lin lean_V2 = variants{} ; -- 
lin lean_V = variants{} ; -- 
lin defendant_N = variants{} ; -- 
lin atmosphere_N = variants{} ; -- 
lin slip_V2 = variants{} ; -- 
lin slip_V = variants{} ; -- 
lin chain_N = variants{} ; -- 
lin accompany_V2 = variants{} ; -- 
lin wonderful_A = variants{} ; -- 
lin earn_V2 = variants{} ; -- 
lin earn_V = variants{} ; -- 
lin enemy_N = mkN "għadu" "għedewwa" ;
lin desk_N = variants{} ; -- 
lin engineering_N = variants{} ; -- 
lin panel_N = variants{} ; -- 
lin distinction_N = variants{} ; -- 
lin deputy_N = variants{} ; -- 
lin discipline_N = variants{} ; -- 
lin strike_N = variants{} ; -- 
lin strike_2_N = variants{} ; -- 
lin strike_1_N = variants{} ; -- 
lin married_A = variants{} ; -- 
lin plenty_NP = variants{} ; -- 
lin establishment_N = variants{} ; -- 
lin fashion_N = variants{} ; -- 
lin roof_N = mkN "saqaf" "soqfa" ;
lin milk_N = mkNColl "ħalib" "ħalibijiet" ;
lin entire_A = variants{} ; -- 
lin tear_N = variants{} ; -- 
lin secondary_A = variants{} ; -- 
lin finding_N = variants{} ; -- 
lin welfare_N = variants{} ; -- 
lin increased_A = variants{} ; -- 
lin attach_V2 = variants{} ; -- 
lin attach_V = variants{} ; -- 
lin typical_A = variants{} ; -- 
lin typical_3_A = variants{} ; -- 
lin typical_2_A = variants{} ; -- 
lin typical_1_A = variants{} ; -- 
lin meanwhile_Adv = variants{} ; -- 
lin leadership_N = variants{} ; -- 
lin walk_N = variants{} ; -- 
lin negotiation_N = variants{} ; -- 
lin clean_A = brokenA "nadif" "nodfa" ;
lin religion_N = mkN "reliġjon" "reliġjonijiet" ;
lin count_V2 = dirV2 (ghadd_GHDD_1_10460_V) ;
lin count_V = variants{}; -- dirV2 (ghadd_GHDD_1_10460_V) ;
lin grey_A = variants{} ; -- 
lin hence_Adv = variants{} ; -- 
lin alright_Adv = variants{} ; -- 
lin first_A = variants{} ; -- 
lin fuel_N = variants{} ; -- 
lin mine_N = variants{} ; -- 
lin appeal_V2 = variants{} ; -- 
lin appeal_V = variants{} ; -- 
lin servantMasc_N = variants{} ; -- 
lin liability_N = variants{} ; -- 
lin constant_A = variants{} ; -- 
lin hate_VV = variants{}; -- lilV2 (baghad_BGHD_1_7402_V) ;
lin hate_V2 = lilV2 (baghad_BGHD_1_7402_V) ;
lin shoe_N = mkN "żarbun" "żraben" ;
lin expense_N = variants{} ; -- 
lin vast_A = variants{} ; -- 
lin soil_N = variants{} ; -- 
lin writing_N = variants{} ; -- 
lin nose_N = possN (mkN "mnieħer" "mniħrijiet") ;
lin origin_N = variants{} ; -- 
lin lord_N = variants{} ; -- 
lin rest_V2 = variants{} ; -- 
lin drive_N = variants{} ; -- 
lin ticket_N = variants{} ; -- 
lin editor_N = variants{} ; -- 
lin switch_V2 = variants{} ; -- 
lin switch_V = variants{} ; -- 
lin provided_Subj = variants{} ; -- 
lin northern_A = variants{} ; -- 
lin significance_N = variants{} ; -- 
lin channel_N = variants{} ; -- 
lin convention_N = variants{} ; -- 
lin damage_V2 = variants{} ; -- 
lin funny_A = variants{} ; -- 
lin bone_N = mkNColl "għadma" "għadam" "għadmiet" ;
lin severe_A = variants{} ; -- 
lin search_V2 = variants{} ; -- 
lin search_V = variants{} ; -- 
lin iron_N = mkNColl "ħadida" "ħadid" "ħadidiet" "ħdejjed" ;
lin vision_N = variants{} ; -- 
lin via_Prep = variants{} ; -- 
lin somewhat_Adv = variants{} ; -- 
lin inside_Adv = variants{} ; -- 
lin trend_N = variants{} ; -- 
lin revolution_N = variants{} ; -- 
lin terrible_A = variants{} ; -- 
lin knee_N = possN (mkNDual "rkoppa" "rkopptejn" "rkoppiet") ;
lin dress_N = variants{} ; -- 
lin unfortunately_Adv = variants{} ; -- 
lin steal_V2 = variants{} ; -- 
lin steal_V = variants{} ; -- 
lin criminal_A = variants{} ; -- 
lin signal_N = variants{} ; -- 
lin notion_N = variants{} ; -- 
lin comparison_N = variants{} ; -- 
lin academic_A = variants{} ; -- 
lin outcome_N = variants{} ; -- 
lin lawyer_N = variants{} ; -- 
lin strongly_Adv = variants{} ; -- 
lin surround_V2 = variants{} ; -- 
lin explore_VS = variants{} ; -- 
lin explore_V2 = variants{} ; -- 
lin achievement_N = variants{} ; -- 
lin odd_A = variants{} ; -- 
lin expectation_N = variants{} ; -- 
lin corporate_A = variants{} ; -- 
lin prisoner_N = variants{} ; -- 
lin question_V2 = variants{} ; -- 
lin rapidly_Adv = variants{} ; -- 
lin deep_Adv = variants{} ; -- 
lin southern_A = variants{} ; -- 
lin amongst_Prep = variants{} ; -- 
lin withdraw_V2 = variants{} ; -- 
lin withdraw_V = variants{} ; -- 
lin afterwards_Adv = variants{} ; -- 
lin paint_V2 = variants{}; -- dirV2 (zeba'_ZBGH_1_10339_V) ; -- dirV2 (pitter_PTR_2_9152_V) ;
lin paint_V = variants{}; -- dirV2 (zeba'_ZBGH_1_10339_V) ; -- dirV2 (pitter_PTR_2_9152_V) ;
lin judge_VS = variants{} ; -- 
lin judge_V2 = variants{} ; -- 
lin judge_V = variants{} ; -- 
lin citizenMasc_N = variants{} ; -- 
lin permanent_A = variants{} ; -- 
lin weak_A = variants{} ; -- 
lin separate_V2 = variants{} ; -- 
lin separate_V = variants{} ; -- 
lin plastic_N = mkNNoPlural "plastik" ;
lin connect_V2 = variants{} ; -- 
lin connect_V = variants{} ; -- 
lin fundamental_A = variants{} ; -- 
lin plane_N = variants{} ; -- 
lin height_N = variants{} ; -- 
lin opening_N = variants{} ; -- 
lin lesson_N = variants{} ; -- 
lin similarly_Adv = variants{} ; -- 
lin shock_N = variants{} ; -- 
lin rail_N = variants{} ; -- 
lin tenant_N = variants{} ; -- 
lin owe_V2 = variants{} ; -- 
lin owe_V = variants{} ; -- 
lin originally_Adv = variants{} ; -- 
lin middle_A = variants{} ; -- 
lin somehow_Adv = variants{} ; -- 
lin minor_A = variants{} ; -- 
lin negative_A = variants{} ; -- 
lin knock_V2 = variants{} ; -- 
lin knock_V = variants{} ; -- 
lin root_N = mkN "qħerq" "qħeruq" ;
lin pursue_V2 = variants{} ; -- 
lin pursue_V = variants{} ; -- 
lin inner_A = variants{} ; -- 
lin crucial_A = variants{} ; -- 
lin occupy_V2 = variants{} ; -- 
lin occupy_V = variants{} ; -- 
lin that_AdA = variants{} ; -- 
lin independence_N = variants{} ; -- 
lin column_N = variants{} ; -- 
lin proceeding_N = variants{} ; -- 
lin female_N = variants{} ; -- 
lin beauty_N = variants{} ; -- 
lin perfectly_Adv = variants{} ; -- 
lin struggle_N = variants{} ; -- 
lin gap_N = variants{} ; -- 
lin house_V2 = variants{} ; -- 
lin database_N = variants{} ; -- 
lin stretch_V2 = variants{} ; -- 
lin stretch_V = variants{} ; -- 
lin stress_N = variants{} ; -- 
lin passenger_N = variants{} ; -- 
lin boundary_N = variants{} ; -- 
lin easy_Adv = variants{} ; -- 
lin view_V2 = variants{} ; -- 
lin manufacturer_N = variants{} ; -- 
lin sharp_A = mkA "jaqta'" "taqta'" "jaqtgħu" ;
lin formation_N = variants{} ; -- 
lin queen_N = mkN "reġina" "rġejjen" ;
lin waste_N = variants{} ; -- 
lin virtually_Adv = variants{} ; -- 
lin expand_V2 = variants{} ; -- 
lin expand_V = variants{} ; -- 
lin contemporary_A = variants{} ; -- 
lin politician_N = variants{} ; -- 
lin back_V = variants{} ; -- 
lin territory_N = variants{} ; -- 
lin championship_N = variants{} ; -- 
lin exception_N = variants{} ; -- 
lin thick_A = mkA "oħxon" "ħoxna" "ħoxnin" "eħxen" ;
lin inquiry_N = variants{} ; -- 
lin topic_N = variants{} ; -- 
lin resident_N = variants{} ; -- 
lin transaction_N = variants{} ; -- 
lin parish_N = variants{} ; -- 
lin supporter_N = variants{} ; -- 
lin massive_A = variants{} ; -- 
lin light_V2 = variants{} ; -- 
lin light_V = variants{} ; -- 
lin unique_A = variants{} ; -- 
lin challenge_V2 = variants{} ; -- 
lin challenge_V = variants{} ; -- 
lin inflation_N = variants{} ; -- 
lin assistance_N = variants{} ; -- 
lin list_V2V = variants{} ; -- 
lin list_V2 = variants{} ; -- 
lin list_V = variants{} ; -- 
lin identity_N = variants{} ; -- 
lin suit_V2 = variants{} ; -- 
lin suit_V = variants{} ; -- 
lin parliamentary_A = variants{} ; -- 
lin unknown_A = variants{} ; -- 
lin preparation_N = variants{} ; -- 
lin elect_V3 = variants{} ; -- 
lin elect_V2V = variants{} ; -- 
lin elect_V2 = variants{} ; -- 
lin elect_V = variants{} ; -- 
lin badly_Adv = variants{} ; -- 
lin moreover_Adv = variants{} ; -- 
lin tie_V2 = dirV2 (qafel_QFL_1_9206_V) ;
lin tie_V = variants{}; -- dirV2 (qafel_QFL_1_9206_V) ;
lin cancer_N = variants{} ; -- 
lin champion_N = variants{} ; -- 
lin exclude_V2 = variants{} ; -- 
lin review_V2 = variants{} ; -- 
lin review_V = variants{} ; -- 
lin licence_N = variants{} ; -- 
lin breakfast_N = variants{} ; -- 
lin minority_N = variants{} ; -- 
lin appreciate_V2 = variants{} ; -- 
lin appreciate_V = variants{} ; -- 
lin fan_N = variants{} ; -- 
lin fan_3_N = variants{} ; -- 
lin fan_2_N = variants{} ; -- 
lin fan_1_N = variants{} ; -- 
lin chief_N = variants{} ; -- 
lin accommodation_N = variants{} ; -- 
lin subsequent_A = variants{} ; -- 
lin democracy_N = variants{} ; -- 
lin brown_A = sameA "kannella" ;
lin taste_N = variants{} ; -- 
lin crown_N = variants{} ; -- 
lin permit_V2V = variants{} ; -- 
lin permit_V2 = variants{} ; -- 
lin permit_V = variants{} ; -- 
lin buyerMasc_N = variants{} ; -- 
lin gift_N = variants{} ; -- 
lin resolution_N = variants{} ; -- 
lin angry_A = variants{} ; -- 
lin metre_N = variants{} ; -- 
lin wheel_N = variants{} ; -- 
lin clause_N = variants{} ; -- 
lin break_N = variants{} ; -- 
lin tank_N = variants{} ; -- 
lin benefit_V2 = variants{} ; -- 
lin benefit_V = variants{} ; -- 
lin engage_V2 = variants{} ; -- 
lin engage_V = variants{} ; -- 
lin alive_A = variants{} ; -- 
lin complaint_N = variants{} ; -- 
lin inch_N = variants{} ; -- 
lin firm_A = variants{} ; -- 
lin abandon_V2 = variants{} ; -- 
lin blame_V2 = variants{} ; -- 
lin blame_V = variants{} ; -- 
lin clean_V2 = variants{} ; -- 
lin clean_V = variants{} ; -- 
lin quote_V2 = variants{} ; -- 
lin quote_V = variants{} ; -- 
lin quantity_N = variants{} ; -- 
lin rule_VS = variants{} ; -- 
lin rule_V2 = variants{} ; -- 
lin rule_V = variants{} ; -- 
lin guilty_A = variants{} ; -- 
lin prior_A = variants{} ; -- 
lin round_A = mkA "tond" ;
lin eastern_A = variants{} ; -- 
lin coat_N = mkN "kowt" "kowtijiet" ;
lin involvement_N = variants{} ; -- 
lin tension_N = variants{} ; -- 
lin diet_N = variants{} ; -- 
lin enormous_A = variants{} ; -- 
lin score_N = variants{} ; -- 
lin rarely_Adv = variants{} ; -- 
lin prize_N = variants{} ; -- 
lin remaining_A = variants{} ; -- 
lin significantly_Adv = variants{} ; -- 
lin glance_V2 = variants{} ; -- 
lin glance_V = variants{} ; -- 
lin dominate_V2 = variants{} ; -- 
lin dominate_V = variants{} ; -- 
lin trust_VS = variants{} ; -- 
lin trust_V2 = variants{} ; -- 
lin naturally_Adv = variants{} ; -- 
lin interpret_V2 = variants{} ; -- 
lin interpret_V = variants{} ; -- 
lin land_V2 = variants{} ; -- 
lin land_V = variants{} ; -- 
lin frame_N = variants{} ; -- 
lin extension_N = variants{} ; -- 
lin mix_V2 = variants{} ; -- 
lin mix_V = variants{} ; -- 
lin spokesman_N = variants{} ; -- 
lin friendly_A = variants{} ; -- 
lin acknowledge_VS = variants{} ; -- 
lin acknowledge_V2 = variants{} ; -- 
lin register_V2 = variants{} ; -- 
lin register_V = variants{} ; -- 
lin regime_N = variants{} ; -- 
lin regime_2_N = variants{} ; -- 
lin regime_1_N = variants{} ; -- 
lin fault_N = variants{} ; -- 
lin dispute_N = variants{} ; -- 
lin grass_N = mkNColl "ħaxixa" "ħaxix" "ħxejjex" ;
lin quietly_Adv = variants{} ; -- 
lin decline_N = variants{} ; -- 
lin dismiss_V2 = variants{} ; -- 
lin delivery_N = variants{} ; -- 
lin complain_VS = variants{} ; -- 
lin complain_V = variants{} ; -- 
lin conservative_N = variants{} ; -- 
lin shift_V2 = variants{} ; -- 
lin shift_V = variants{} ; -- 
lin port_N = variants{} ; -- 
lin beach_N = variants{} ; -- 
lin string_N = variants{} ; -- 
lin depth_N = variants{} ; -- 
lin unusual_A = variants{} ; -- 
lin travel_N = variants{} ; -- 
lin pilot_N = variants{} ; -- 
lin obligation_N = variants{} ; -- 
lin gene_N = variants{} ; -- 
lin yellow_A = mkA "isfar" "safra" "sofor" ;
lin republic_N = variants{} ; -- 
lin shadow_N = variants{} ; -- 
lin dear_A = variants{} ; -- 
lin analyse_V2 = variants{} ; -- 
lin anywhere_Adv = variants{} ; -- 
lin average_N = variants{} ; -- 
lin phrase_N = variants{} ; -- 
lin long_term_A = variants{} ; -- 
lin crew_N = variants{} ; -- 
lin lucky_A = variants{} ; -- 
lin restore_V2 = variants{} ; -- 
lin convince_V2V = variants{} ; -- 
lin convince_V2 = variants{} ; -- 
lin coast_N = variants{} ; -- 
lin engineer_N = variants{} ; -- 
lin heavily_Adv = variants{} ; -- 
lin extensive_A = variants{} ; -- 
lin glad_A = variants{} ; -- 
lin charity_N = variants{} ; -- 
lin oppose_V2 = variants{} ; -- 
lin oppose_V = variants{} ; -- 
lin defend_V2 = variants{} ; -- 
lin alter_V2 = variants{} ; -- 
lin alter_V = variants{} ; -- 
lin warning_N = variants{} ; -- 
lin arrest_V2 = variants{} ; -- 
lin framework_N = variants{} ; -- 
lin approval_N = variants{} ; -- 
lin bother_VV = variants{} ; -- 
lin bother_V2V = variants{} ; -- 
lin bother_V2 = variants{} ; -- 
lin bother_V = variants{} ; -- 
lin novel_N = variants{} ; -- 
lin accuse_V2 = variants{} ; -- 
lin surprised_A = variants{} ; -- 
lin currency_N = variants{} ; -- 
lin restrict_V2 = variants{} ; -- 
lin restrict_V = variants{} ; -- 
lin possess_V2 = variants{} ; -- 
lin moral_A = variants{} ; -- 
lin protein_N = variants{} ; -- 
lin distinguish_V2 = variants{} ; -- 
lin distinguish_V = variants{} ; -- 
lin gently_Adv = variants{} ; -- 
lin reckon_VS = variants{} ; -- 
lin incorporate_V2 = variants{} ; -- 
lin proceed_V = variants{} ; -- 
lin assist_V2 = variants{} ; -- 
lin assist_V = variants{} ; -- 
lin sure_Adv = variants{} ; -- 
lin stress_VS = variants{} ; -- 
lin stress_V2 = variants{} ; -- 
lin justify_VV = variants{} ; -- 
lin justify_V2 = variants{} ; -- 
lin behalf_N = variants{} ; -- 
lin councillor_N = variants{} ; -- 
lin setting_N = variants{} ; -- 
lin command_N = variants{} ; -- 
lin command_2_N = variants{} ; -- 
lin command_1_N = variants{} ; -- 
lin maintenance_N = variants{} ; -- 
lin stair_N = variants{} ; -- 
lin poem_N = variants{} ; -- 
lin chest_N = variants{} ; -- 
lin like_Adv = variants{} ; -- 
lin secret_N = variants{} ; -- 
lin restriction_N = variants{} ; -- 
lin efficient_A = variants{} ; -- 
lin suspect_VS = variants{} ; -- 
lin suspect_V2 = variants{} ; -- 
lin hat_N = mkN "kappell" "kpiepel" ;
lin tough_A = variants{} ; -- 
lin firmly_Adv = variants{} ; -- 
lin willing_A = variants{} ; -- 
lin healthy_A = variants{} ; -- 
lin focus_N = variants{} ; -- 
lin construct_V2 = variants{} ; -- 
lin occasionally_Adv = variants{} ; -- 
lin mode_N = variants{} ; -- 
lin saving_N = variants{} ; -- 
lin comfortable_A = variants{} ; -- 
lin camp_N = variants{} ; -- 
lin trade_V2 = variants{} ; -- 
lin trade_V = variants{} ; -- 
lin export_N = variants{} ; -- 
lin wake_V2 = variants{} ; -- 
lin wake_V = variants{} ; -- 
lin partnership_N = variants{} ; -- 
lin daily_A = variants{} ; -- 
lin abroad_Adv = variants{} ; -- 
lin profession_N = variants{} ; -- 
lin load_N = variants{} ; -- 
lin countryside_N = variants{} ; -- 
lin boot_N = mkNColl "żarbuna" "żarbun" "żraben" ;
lin mostly_Adv = variants{} ; -- 
lin sudden_A = variants{} ; -- 
lin implement_V2 = variants{} ; -- 
lin reputation_N = variants{} ; -- 
lin print_V2 = variants{} ; -- 
lin print_V = variants{} ; -- 
lin calculate_VS = variants{} ; -- 
lin calculate_V2 = variants{} ; -- 
lin calculate_V = variants{} ; -- 
lin keen_A = variants{} ; -- 
lin guess_VS = variants{} ; -- 
lin guess_V2 = variants{} ; -- 
lin guess_V = variants{} ; -- 
lin recommendation_N = variants{} ; -- 
lin autumn_N = variants{} ; -- 
lin conventional_A = variants{} ; -- 
lin cope_V = variants{} ; -- 
lin constitute_V2 = variants{} ; -- 
lin poll_N = variants{} ; -- 
lin voluntary_A = variants{} ; -- 
lin valuable_A = variants{} ; -- 
lin recovery_N = variants{} ; -- 
lin cast_V2 = variants{} ; -- 
lin cast_V = variants{} ; -- 
lin premise_N = variants{} ; -- 
lin resolve_V2 = variants{} ; -- 
lin resolve_V = variants{} ; -- 
lin regularly_Adv = variants{} ; -- 
lin solve_V2 = variants{} ; -- 
lin plaintiff_N = variants{} ; -- 
lin critic_N = variants{} ; -- 
lin agriculture_N = variants{} ; -- 
lin ice_N = mkN "silġ" "silġiet" ;
lin constitution_N = variants{} ; -- 
lin communist_N = variants{} ; -- 
lin layer_N = variants{} ; -- 
lin recession_N = variants{} ; -- 
lin slight_A = variants{} ; -- 
lin dramatic_A = variants{} ; -- 
lin golden_A = variants{} ; -- 
lin temporary_A = variants{} ; -- 
lin suit_N = variants{} ; -- 
lin shortly_Adv = variants{} ; -- 
lin initially_Adv = variants{} ; -- 
lin arrival_N = variants{} ; -- 
lin protest_N = variants{} ; -- 
lin resistance_N = variants{} ; -- 
lin silent_A = variants{} ; -- 
lin presentation_N = variants{} ; -- 
lin soul_N = variants{} ; -- 
lin self_N = variants{} ; -- 
lin judgment_N = variants{} ; -- 
lin feed_V2 = variants{} ; -- 
lin feed_V = variants{} ; -- 
lin muscle_N = variants{} ; -- 
lin shareholder_N = variants{} ; -- 
lin opposite_A = variants{} ; -- 
lin pollution_N = variants{} ; -- 
lin wealth_N = variants{} ; -- 
lin video_taped_A = variants{} ; -- 
lin kingdom_N = variants{} ; -- 
lin bread_N = mkNColl "ħobża" "ħobż" "ħobżiet" ;
lin perspective_N = variants{} ; -- 
lin camera_N = mkN "kamera" "kameras" ;
lin prince_N = variants{} ; -- 
lin illness_N = variants{} ; -- 
lin cake_N = variants{} ; -- 
lin meat_N = mkNColl "laħma" "laħam" "laħmiet" "laħmijiet" ;
lin submit_V2 = variants{} ; -- 
lin submit_V = variants{} ; -- 
lin ideal_A = variants{} ; -- 
lin relax_V2 = variants{} ; -- 
lin relax_V = variants{} ; -- 
lin penalty_N = variants{} ; -- 
lin purchase_V2 = variants{} ; -- 
lin tired_A = variants{} ; -- 
lin beer_N = mkN "birra" "birer" ;
lin specify_VS = variants{} ; -- 
lin specify_V2 = variants{} ; -- 
lin specify_V = variants{} ; -- 
lin short_Adv = variants{} ; -- 
lin monitor_V2 = variants{} ; -- 
lin monitor_V = variants{} ; -- 
lin electricity_N = variants{} ; -- 
lin specifically_Adv = variants{} ; -- 
lin bond_N = variants{} ; -- 
lin statutory_A = variants{} ; -- 
lin laboratory_N = variants{} ; -- 
lin federal_A = variants{} ; -- 
lin captain_N = variants{} ; -- 
lin deeply_Adv = variants{} ; -- 
lin pour_V2 = variants{} ; -- 
lin pour_V = variants{} ; -- 
lin boss_N = mkN "mgħallem" "mgħallmin" ;
lin creature_N = variants{} ; -- 
lin urge_VS = variants{} ; -- 
lin urge_V2V = variants{} ; -- 
lin urge_V2 = variants{} ; -- 
lin locate_V2 = variants{} ; -- 
lin locate_V = variants{} ; -- 
lin being_N = variants{} ; -- 
lin struggle_VV = variants{} ; -- 
lin struggle_V = variants{} ; -- 
lin lifespan_N = variants{} ; -- 
lin flat_A = variants{} ; -- 
lin valley_N = variants{} ; -- 
lin like_A = variants{} ; -- 
lin guard_N = variants{} ; -- 
lin emergency_N = variants{} ; -- 
lin dark_N = variants{} ; -- 
lin bomb_N = variants{} ; -- 
lin dollar_N = variants{} ; -- 
lin efficiency_N = variants{} ; -- 
lin mood_N = variants{} ; -- 
lin convert_V2 = variants{} ; -- 
lin convert_V = variants{} ; -- 
lin possession_N = variants{} ; -- 
lin marketing_N = variants{} ; -- 
lin please_VV = variants{} ; -- 
lin please_V2V = variants{} ; -- 
lin please_V2 = variants{} ; -- 
lin please_V = variants{} ; -- 
lin habit_N = variants{} ; -- 
lin subsequently_Adv = variants{} ; -- 
lin round_N = variants{} ; -- 
lin purchase_N = variants{} ; -- 
lin sort_V2 = variants{} ; -- 
lin sort_V = variants{} ; -- 
lin outside_A = variants{} ; -- 
lin gradually_Adv = variants{} ; -- 
lin expansion_N = variants{} ; -- 
lin competitive_A = variants{} ; -- 
lin cooperation_N = variants{} ; -- 
lin acceptable_A = variants{} ; -- 
lin angle_N = variants{} ; -- 
lin cook_V2 = variants{} ; -- 
lin cook_V = variants{} ; -- 
lin net_A = variants{} ; -- 
lin sensitive_A = variants{} ; -- 
lin ratio_N = variants{} ; -- 
lin kiss_V2 = variants{} ; -- 
lin amount_V = variants{} ; -- 
lin sleep_N = variants{} ; -- 
lin finance_V2 = variants{} ; -- 
lin essentially_Adv = variants{} ; -- 
lin fund_V2 = variants{} ; -- 
lin preserve_V2 = variants{} ; -- 
lin wedding_N = variants{} ; -- 
lin personality_N = variants{} ; -- 
lin bishop_N = variants{} ; -- 
lin dependent_A = variants{} ; -- 
lin landscape_N = variants{} ; -- 
lin pure_A = variants{} ; -- 
lin mirror_N = variants{} ; -- 
lin lock_V2 = variants{} ; -- 
lin lock_V = variants{} ; -- 
lin symptom_N = variants{} ; -- 
lin promotion_N = variants{} ; -- 
lin global_A = variants{} ; -- 
lin aside_Adv = variants{} ; -- 
lin tendency_N = variants{} ; -- 
lin conservation_N = variants{} ; -- 
lin reply_N = variants{} ; -- 
lin estimate_N = variants{} ; -- 
lin qualification_N = variants{} ; -- 
lin pack_V2 = variants{} ; -- 
lin pack_V = variants{} ; -- 
lin governor_N = variants{} ; -- 
lin expected_A = variants{} ; -- 
lin invest_V2 = variants{} ; -- 
lin invest_V = variants{} ; -- 
lin cycle_N = variants{} ; -- 
lin alright_A = variants{} ; -- 
lin philosophy_N = variants{} ; -- 
lin gallery_N = variants{} ; -- 
lin sad_A = variants{} ; -- 
lin intervention_N = variants{} ; -- 
lin emotional_A = variants{} ; -- 
lin advertising_N = variants{} ; -- 
lin regard_N = variants{} ; -- 
lin dance_V2 = variants{} ; -- 
lin dance_V = variants{} ; -- 
lin cigarette_N = variants{} ; -- 
lin predict_VS = variants{} ; -- 
lin predict_V2 = variants{} ; -- 
lin adequate_A = variants{} ; -- 
lin variable_N = variants{} ; -- 
lin net_N = variants{} ; -- 
lin retire_V2 = variants{} ; -- 
lin retire_V = variants{} ; -- 
lin sugar_N = variants{} ; -- 
lin pale_A = variants{} ; -- 
lin frequency_N = variants{} ; -- 
lin guy_N = variants{} ; -- 
lin feature_V2 = variants{} ; -- 
lin furniture_N = variants{} ; -- 
lin administrative_A = variants{} ; -- 
lin wooden_A = variants{} ; -- 
lin input_N = variants{} ; -- 
lin phenomenon_N = variants{} ; -- 
lin surprising_A = variants{} ; -- 
lin jacket_N = variants{} ; -- 
lin actor_N = variants{} ; -- 
lin actor_2_N = variants{} ; -- 
lin actor_1_N = variants{} ; -- 
lin kick_V2 = variants{} ; -- 
lin kick_V = variants{} ; -- 
lin producer_N = variants{} ; -- 
lin hearing_N = variants{} ; -- 
lin chip_N = variants{} ; -- 
lin equation_N = variants{} ; -- 
lin certificate_N = variants{} ; -- 
lin hello_Interj = variants{} ; -- 
lin remarkable_A = variants{} ; -- 
lin alliance_N = variants{} ; -- 
lin smoke_V2 = variants{} ; -- 
lin smoke_V = variants{} ; -- 
lin awareness_N = variants{} ; -- 
lin throat_N = variants{} ; -- 
lin discovery_N = variants{} ; -- 
lin festival_N = variants{} ; -- 
lin dance_N = variants{} ; -- 
lin promise_N = variants{} ; -- 
lin rose_N = variants{} ; -- 
lin principal_A = variants{} ; -- 
lin brilliant_A = variants{} ; -- 
lin proposed_A = variants{} ; -- 
lin coach_N = variants{} ; -- 
lin coach_3_N = variants{} ; -- 
lin coach_2_N = variants{} ; -- 
lin coach_1_N = variants{} ; -- 
lin absolute_A = variants{} ; -- 
lin drama_N = variants{} ; -- 
lin recording_N = variants{} ; -- 
lin precisely_Adv = variants{} ; -- 
lin bath_N = variants{} ; -- 
lin celebrate_V2 = variants{} ; -- 
lin substance_N = variants{} ; -- 
lin swing_V2 = variants{} ; -- 
lin swing_V = variants{} ; -- 
lin for_Adv = variants{}; -- mkPrep "għal" "għall-" "għall-" "għat-" "għall-" "għalija" "għalik" "għalih" "għaliha" "għalina" "għalikom" "għalihom" True ;
lin rapid_A = variants{} ; -- 
lin rough_A = variants{} ; -- 
lin investor_N = variants{} ; -- 
lin fire_V2 = variants{} ; -- 
lin fire_V = variants{} ; -- 
lin rank_N = variants{} ; -- 
lin compete_V = variants{} ; -- 
lin sweet_A = variants{} ; -- 
lin decline_VV = variants{} ; -- 
lin decline_V2 = variants{} ; -- 
lin decline_V = variants{} ; -- 
lin rent_N = variants{} ; -- 
lin dealer_N = variants{} ; -- 
lin bend_V2 = variants{} ; -- 
lin bend_V = variants{} ; -- 
lin solid_A = variants{} ; -- 
lin cloud_N = mkNColl "sħaba" "sħab" "sħabiet" ;
lin across_Adv = variants{} ; -- 
lin level_A = variants{} ; -- 
lin enquiry_N = variants{} ; -- 
lin fight_N = variants{} ; -- 
lin abuse_N = variants{} ; -- 
lin golf_N = variants{} ; -- 
lin guitar_N = variants{} ; -- 
lin electronic_A = variants{} ; -- 
lin cottage_N = variants{} ; -- 
lin scope_N = variants{} ; -- 
lin pause_VS = variants{} ; -- 
lin pause_V2V = variants{} ; -- 
lin pause_V = variants{} ; -- 
lin mixture_N = variants{} ; -- 
lin emotion_N = variants{} ; -- 
lin comprehensive_A = variants{} ; -- 
lin shirt_N = mkN "qmis" "qomos" feminine ;
lin allowance_N = variants{} ; -- 
lin retirement_N = variants{} ; -- 
lin breach_N = variants{} ; -- 
lin infection_N = variants{} ; -- 
lin resist_VV = variants{} ; -- 
lin resist_V2 = variants{} ; -- 
lin resist_V = variants{} ; -- 
lin qualify_V2 = variants{} ; -- 
lin qualify_V = variants{} ; -- 
lin paragraph_N = variants{} ; -- 
lin sick_A = variants{} ; -- 
lin near_A = mkA "viċin" ;
lin researcherMasc_N = variants{} ; -- 
lin consent_N = variants{} ; -- 
lin written_A = variants{} ; -- 
lin literary_A = variants{} ; -- 
lin ill_A = variants{} ; -- 
lin wet_A = mkA "mxarrab" "mxarrba" "mxarrbin" ;
lin lake_N = mkN "għadira" "għadajjar" ;
lin entrance_N = variants{} ; -- 
lin peak_N = variants{} ; -- 
lin successfully_Adv = variants{} ; -- 
lin sand_N = mkNColl "ramla" "ramel" "ramliet" ;
lin breathe_V2 = variants{}; -- mkV "respira" ; -- ĦA N-NIFS
lin breathe_V = mkV "respira" ; -- ĦA N-NIFS
lin cold_N = variants{} ; -- 
lin cheek_N = variants{} ; -- 
lin platform_N = variants{} ; -- 
lin interaction_N = variants{} ; -- 
lin watch_N = variants{} ; -- 
lin borrow_VV = variants{} ; -- 
lin borrow_V2 = variants{} ; -- 
lin borrow_V = variants{} ; -- 
lin birthday_N = variants{} ; -- 
lin knife_N = variants{} ; -- 
lin extreme_A = variants{} ; -- 
lin core_N = variants{} ; -- 
lin peasantMasc_N = variants{} ; -- 
lin armed_A = variants{} ; -- 
lin permission_N = variants{} ; -- 
lin supreme_A = variants{} ; -- 
lin overcome_V2 = variants{} ; -- 
lin overcome_V = variants{} ; -- 
lin greatly_Adv = variants{} ; -- 
lin visual_A = variants{} ; -- 
lin lad_N = variants{} ; -- 
lin genuine_A = variants{} ; -- 
lin personnel_N = variants{} ; -- 
lin judgement_N = variants{} ; -- 
lin exciting_A = variants{} ; -- 
lin stream_N = variants{} ; -- 
lin perception_N = variants{} ; -- 
lin guarantee_VS = variants{} ; -- 
lin guarantee_V2 = variants{} ; -- 
lin guarantee_V = variants{} ; -- 
lin disaster_N = variants{} ; -- 
lin darkness_N = variants{} ; -- 
lin bid_N = variants{} ; -- 
lin sake_N = variants{} ; -- 
lin sake_2_N = variants{} ; -- 
lin sake_1_N = variants{} ; -- 
lin organize_V2V = variants{} ; -- 
lin organize_V2 = variants{} ; -- 
lin tourist_N = variants{} ; -- 
lin policeman_N = mkNNoPlural "pulizija" ;
lin castle_N = variants{} ; -- 
lin figure_VS = variants{} ; -- 
lin figure_V = variants{} ; -- 
lin race_VV = variants{} ; -- 
lin race_V2V = variants{} ; -- 
lin race_V2 = variants{} ; -- 
lin race_V = variants{} ; -- 
lin demonstration_N = variants{} ; -- 
lin anger_N = variants{} ; -- 
lin briefly_Adv = variants{} ; -- 
lin presumably_Adv = variants{} ; -- 
lin clock_N = variants{} ; -- 
lin hero_N = variants{} ; -- 
lin expose_V2 = variants{} ; -- 
lin expose_V = variants{} ; -- 
lin custom_N = variants{} ; -- 
lin maximum_A = variants{} ; -- 
lin wish_N = variants{} ; -- 
lin earning_N = variants{} ; -- 
lin priest_N = mkN "qassis" "qassisin" ;
lin resign_V2 = variants{} ; -- 
lin resign_V = variants{} ; -- 
lin store_V2 = variants{} ; -- 
lin widespread_A = variants{} ; -- 
lin comprise_V2 = variants{} ; -- 
lin chamber_N = variants{} ; -- 
lin acquisition_N = variants{} ; -- 
lin involved_A = variants{} ; -- 
lin confident_A = variants{} ; -- 
lin circuit_N = variants{} ; -- 
lin radical_A = variants{} ; -- 
lin detect_V2 = variants{} ; -- 
lin stupid_A = mkA "iblah" "belha" "boloh" ;
lin grand_A = variants{} ; -- 
lin consumption_N = variants{} ; -- 
lin hold_N = variants{} ; -- 
lin zone_N = variants{} ; -- 
lin mean_A = variants{} ; -- 
lin altogether_Adv = variants{} ; -- 
lin rush_VV = variants{} ; -- 
lin rush_V2 = variants{} ; -- 
lin rush_V = variants{} ; -- 
lin numerous_A = variants{} ; -- 
lin sink_V2 = variants{} ; -- 
lin sink_V = variants{} ; -- 
lin everywhere_Adv = mkAdv "kullimkien" ;
lin classical_A = variants{} ; -- 
lin respectively_Adv = variants{} ; -- 
lin distinct_A = variants{} ; -- 
lin mad_A = variants{} ; -- 
lin honour_N = variants{} ; -- 
lin statistics_N = variants{} ; -- 
lin false_A = variants{} ; -- 
lin square_N = variants{} ; -- 
lin differ_V = variants{} ; -- 
lin disk_N = variants{} ; -- 
lin truly_Adv = variants{} ; -- 
lin survival_N = variants{} ; -- 
lin proud_A = variants{} ; -- 
lin tower_N = variants{} ; -- 
lin deposit_N = variants{} ; -- 
lin pace_N = variants{} ; -- 
lin compensation_N = variants{} ; -- 
lin adviserMasc_N = variants{} ; -- 
lin consultant_N = variants{} ; -- 
lin drag_V2 = variants{} ; -- 
lin drag_V = variants{} ; -- 
lin advanced_A = variants{} ; -- 
lin landlord_N = variants{} ; -- 
lin whenever_Adv = variants{} ; -- 
lin delay_N = variants{} ; -- 
lin green_N = variants{} ; -- 
lin car_V = variants{} ; -- 
lin holder_N = variants{} ; -- 
lin secret_A = variants{} ; -- 
lin edition_N = variants{} ; -- 
lin occupation_N = variants{} ; -- 
lin agricultural_A = variants{} ; -- 
lin intelligence_N = variants{} ; -- 
lin intelligence_2_N = variants{} ; -- 
lin intelligence_1_N = variants{} ; -- 
lin empire_N = variants{} ; -- 
lin definitely_Adv = variants{} ; -- 
lin negotiate_VV = variants{} ; -- 
lin negotiate_V2 = variants{} ; -- 
lin negotiate_V = variants{} ; -- 
lin host_N = variants{} ; -- 
lin relative_N = variants{} ; -- 
lin mass_A = variants{} ; -- 
lin helpful_A = variants{} ; -- 
lin fellow_N = variants{} ; -- 
lin sweep_V2 = variants{} ; -- 
lin sweep_V = variants{} ; -- 
lin poet_N = variants{} ; -- 
lin journalist_N = variants{} ; -- 
lin defeat_N = variants{} ; -- 
lin unlike_Prep = variants{} ; -- 
lin primarily_Adv = variants{} ; -- 
lin tight_A = variants{} ; -- 
lin indication_N = variants{} ; -- 
lin dry_V2 = variants{} ; -- 
lin dry_V = variants{} ; -- 
lin cricket_N = variants{} ; -- 
lin whisper_V2 = variants{} ; -- 
lin whisper_V = variants{} ; -- 
lin routine_N = variants{} ; -- 
lin print_N = variants{} ; -- 
lin anxiety_N = variants{} ; -- 
lin witness_N = variants{} ; -- 
lin concerning_Prep = variants{} ; -- 
lin mill_N = variants{} ; -- 
lin gentle_A = variants{} ; -- 
lin curtain_N = variants{} ; -- 
lin mission_N = variants{} ; -- 
lin supplier_N = variants{} ; -- 
lin basically_Adv = variants{} ; -- 
lin assure_V2S = variants{} ; -- 
lin assure_V2 = variants{} ; -- 
lin poverty_N = variants{} ; -- 
lin snow_N = mkNColl "borra" ;
lin prayer_N = variants{} ; -- 
lin pipe_N = variants{} ; -- 
lin deserve_VV = variants{} ; -- 
lin deserve_V2 = variants{} ; -- 
lin deserve_V = variants{} ; -- 
lin shift_N = variants{} ; -- 
lin split_V2 = lilV2 (qasam_QSM_1_9292_V) ;
lin split_V = variants{}; -- lilV2 (qasam_QSM_1_9292_V) ;
lin near_Adv = variants{} ; -- 
lin consistent_A = variants{} ; -- 
lin carpet_N = mkN "tapit" "twapet" ;
lin ownership_N = variants{} ; -- 
lin joke_N = variants{} ; -- 
lin fewer_Det = variants{} ; -- 
lin workshop_N = variants{} ; -- 
lin salt_N = mkN "melħ" "melħiet" ;
lin aged_Prep = variants{} ; -- 
lin symbol_N = variants{} ; -- 
lin slide_V2 = variants{} ; -- 
lin slide_V = variants{} ; -- 
lin cross_N = variants{} ; -- 
lin anxious_A = variants{} ; -- 
lin tale_N = variants{} ; -- 
lin preference_N = variants{} ; -- 
lin inevitably_Adv = variants{} ; -- 
lin mere_A = variants{} ; -- 
lin behave_V = variants{} ; -- 
lin gain_N = variants{} ; -- 
lin nervous_A = variants{} ; -- 
lin guide_V2 = variants{} ; -- 
lin remark_N = variants{} ; -- 
lin pleased_A = variants{} ; -- 
lin province_N = variants{} ; -- 
lin steel_N = mkNNoPlural "azzar" ;
lin practise_V2 = variants{} ; -- 
lin practise_V = variants{} ; -- 
lin flow_V = ghadda_GHDJ_2_10679_V ;
lin holy_A = variants{} ; -- 
lin dose_N = variants{} ; -- 
lin alcohol_N = variants{} ; -- 
lin guidance_N = variants{} ; -- 
lin constantly_Adv = variants{} ; -- 
lin climate_N = variants{} ; -- 
lin enhance_V2 = variants{} ; -- 
lin reasonably_Adv = variants{} ; -- 
lin waste_V2 = variants{} ; -- 
lin waste_V = variants{} ; -- 
lin smooth_A = mkA "lixx" ;
lin dominant_A = variants{} ; -- 
lin conscious_A = variants{} ; -- 
lin formula_N = variants{} ; -- 
lin tail_N = (mkN "denb" "dnieb") ;
lin ha_Interj = variants{} ; -- 
lin electric_A = variants{} ; -- 
lin sheep_N = mkNColl "nagħġa" "ngħaġ" "nagħġiet" ;
lin medicine_N = variants{} ; -- 
lin strategic_A = variants{} ; -- 
lin disabled_A = variants{} ; -- 
lin smell_N = variants{} ; -- 
lin operator_N = variants{} ; -- 
lin mount_V2 = variants{} ; -- 
lin mount_V = variants{} ; -- 
lin advance_V2 = variants{} ; -- 
lin advance_V = variants{} ; -- 
lin remote_A = variants{} ; -- 
lin measurement_N = variants{} ; -- 
lin favour_VS = variants{} ; -- 
lin favour_V2 = variants{} ; -- 
lin favour_V = variants{} ; -- 
lin neither_Det = variants{} ; -- 
lin architecture_N = variants{} ; -- 
lin worth_N = variants{} ; -- 
lin tie_N = variants{} ; -- 
lin barrier_N = variants{} ; -- 
lin practitioner_N = variants{} ; -- 
lin outstanding_A = variants{} ; -- 
lin enthusiasm_N = variants{} ; -- 
lin theoretical_A = variants{} ; -- 
lin implementation_N = variants{} ; -- 
lin worried_A = variants{} ; -- 
lin pitch_N = variants{} ; -- 
lin drop_N = variants{} ; -- 
lin phone_V2 = variants{} ; -- 
lin phone_V = variants{} ; -- 
lin shape_VV = variants{} ; -- 
lin shape_V2 = variants{} ; -- 
lin shape_V = variants{} ; -- 
lin clinical_A = variants{} ; -- 
lin lane_N = variants{} ; -- 
lin apple_N = mkNColl "tuffieħa" "tuffieħ" "tuffieħat" ;
lin catalogue_N = variants{} ; -- 
lin tip_N = variants{} ; -- 
lin publisher_N = variants{} ; -- 
lin opponentMasc_N = variants{} ; -- 
lin live_A = variants{} ; -- 
lin burden_N = variants{} ; -- 
lin tackle_V2 = variants{} ; -- 
lin tackle_V = variants{} ; -- 
lin historian_N = variants{} ; -- 
lin bury_V2 = variants{} ; -- 
lin bury_V = variants{} ; -- 
lin stomach_N = variants{} ; -- 
lin percentage_N = variants{} ; -- 
lin evaluation_N = variants{} ; -- 
lin outline_V2 = variants{} ; -- 
lin talent_N = variants{} ; -- 
lin lend_V2 = variants{} ; -- 
lin lend_V = variants{} ; -- 
lin silver_N = mkN "fidda" "fided" ;
lin pack_N = variants{} ; -- 
lin fun_N = variants{} ; -- 
lin democrat_N = variants{} ; -- 
lin fortune_N = variants{} ; -- 
lin storage_N = variants{} ; -- 
lin professional_N = variants{} ; -- 
lin reserve_N = variants{} ; -- 
lin interval_N = variants{} ; -- 
lin dimension_N = variants{} ; -- 
lin honest_A = variants{} ; -- 
lin awful_A = variants{} ; -- 
lin manufacture_V2 = variants{} ; -- 
lin confusion_N = variants{} ; -- 
lin pink_A = variants{} ; -- 
lin impressive_A = variants{} ; -- 
lin satisfaction_N = variants{} ; -- 
lin visible_A = variants{} ; -- 
lin vessel_N = variants{} ; -- 
lin stand_N = variants{} ; -- 
lin curve_N = variants{} ; -- 
lin pot_N = variants{} ; -- 
lin replacement_N = variants{} ; -- 
lin accurate_A = variants{} ; -- 
lin mortgage_N = variants{} ; -- 
lin salary_N = variants{} ; -- 
lin impress_V2 = variants{} ; -- 
lin impress_V = variants{} ; -- 
lin constitutional_A = variants{} ; -- 
lin emphasize_VS = variants{} ; -- 
lin emphasize_V2 = variants{} ; -- 
lin developing_A = variants{} ; -- 
lin proof_N = variants{} ; -- 
lin furthermore_Adv = variants{} ; -- 
lin dish_N = variants{} ; -- 
lin interview_V2 = variants{} ; -- 
lin considerably_Adv = variants{} ; -- 
lin distant_A = variants{} ; -- 
lin lower_V2 = variants{} ; -- 
lin lower_V = variants{} ; -- 
lin favouriteMasc_N = variants{} ; -- 
lin tear_V2 = variants{} ; -- 
lin tear_V = variants{} ; -- 
lin fixed_A = variants{} ; -- 
lin by_Adv = variants{} ; -- 
lin luck_N = variants{} ; -- 
lin count_N = variants{} ; -- 
lin precise_A = variants{} ; -- 
lin determination_N = variants{} ; -- 
lin bite_V2 = lilV2 (gidem_GDM_1_8009_V) ;
lin bite_V = variants{}; -- lilV2 (gidem_GDM_1_8009_V) ;
lin dear_Interj = variants{} ; -- 
lin consultation_N = variants{} ; -- 
lin range_V = variants{} ; -- 
lin residential_A = variants{} ; -- 
lin conduct_N = variants{} ; -- 
lin capture_V2 = variants{} ; -- 
lin ultimately_Adv = variants{} ; -- 
lin cheque_N = variants{} ; -- 
lin economics_N = variants{} ; -- 
lin sustain_V2 = variants{} ; -- 
lin secondly_Adv = variants{} ; -- 
lin silly_A = variants{} ; -- 
lin merchant_N = variants{} ; -- 
lin lecture_N = variants{} ; -- 
lin musical_A = variants{} ; -- 
lin leisure_N = variants{} ; -- 
lin check_N = variants{} ; -- 
lin cheese_N = mkNColl "ġobna" "ġobon" "ġobniet" ;
lin lift_N = variants{} ; -- 
lin participate_V2 = variants{} ; -- 
lin participate_V = variants{} ; -- 
lin fabric_N = variants{} ; -- 
lin distribute_V2 = variants{} ; -- 
lin lover_N = variants{} ; -- 
lin childhood_N = variants{} ; -- 
lin cool_A = variants{} ; -- 
lin ban_V2 = variants{} ; -- 
lin supposed_A = variants{} ; -- 
lin mouse_N = variants{} ; -- 
lin strain_N = variants{} ; -- 
lin specialist_A = variants{} ; -- 
lin consult_V2 = variants{} ; -- 
lin consult_V = variants{} ; -- 
lin minimum_A = variants{} ; -- 
lin approximately_Adv = variants{} ; -- 
lin participant_N = variants{} ; -- 
lin monetary_A = variants{} ; -- 
lin confuse_V2 = variants{} ; -- 
lin dare_VV = variants{} ; -- 
lin dare_V2 = variants{} ; -- 
lin smoke_N = mkN "duħħan" "dħaħen" ;
lin movie_N = variants{} ; -- 
lin seed_N = mkN "żerriegħa" "żerrigħat" ;
lin cease_V2 = variants{} ; -- 
lin cease_V = variants{} ; -- 
lin open_Adv = variants{} ; -- 
lin journal_N = variants{} ; -- 
lin shopping_N = variants{} ; -- 
lin equivalent_N = variants{} ; -- 
lin palace_N = variants{} ; -- 
lin exceed_V2 = variants{} ; -- 
lin isolated_A = variants{} ; -- 
lin poetry_N = variants{} ; -- 
lin perceive_VS = variants{} ; -- 
lin perceive_V2V = variants{} ; -- 
lin perceive_V2 = variants{} ; -- 
lin lack_V2 = variants{} ; -- 
lin lack_V = variants{} ; -- 
lin strengthen_V2 = variants{} ; -- 
lin snap_V2 = variants{} ; -- 
lin snap_V = variants{} ; -- 
lin readily_Adv = variants{} ; -- 
lin spite_N = variants{} ; -- 
lin conviction_N = variants{} ; -- 
lin corridor_N = variants{} ; -- 
lin behind_Adv = variants{}; -- after_Prep ;
lin ward_N = variants{} ; -- 
lin profile_N = variants{} ; -- 
lin fat_A = variants{} ; -- 
lin comfort_N = variants{} ; -- 
lin bathroom_N = variants{} ; -- 
lin shell_N = variants{} ; -- 
lin reward_N = variants{} ; -- 
lin deliberately_Adv = variants{} ; -- 
lin automatically_Adv = variants{} ; -- 
lin vegetable_N = variants{} ; -- 
lin imagination_N = variants{} ; -- 
lin junior_A = variants{} ; -- 
lin unemployed_A = variants{} ; -- 
lin mystery_N = variants{} ; -- 
lin pose_V2 = variants{} ; -- 
lin pose_V = variants{} ; -- 
lin violent_A = variants{} ; -- 
lin march_N = variants{} ; -- 
lin found_V2 = variants{} ; -- 
lin dig_V2 = variants{}; -- haffer_HFR_2_8236_V ;
lin dig_V = haffer_HFR_2_8236_V ;
lin dirty_A = mkA "maħmuġ" ;
lin straight_A = mkA "dritt" ;
lin psychological_A = variants{} ; -- 
lin grab_V2 = variants{} ; -- 
lin grab_V = variants{} ; -- 
lin pleasant_A = variants{} ; -- 
lin surgery_N = variants{} ; -- 
lin inevitable_A = variants{} ; -- 
lin transform_V2 = variants{} ; -- 
lin bell_N = variants{} ; -- 
lin announcement_N = variants{} ; -- 
lin draft_N = variants{} ; -- 
lin unity_N = variants{} ; -- 
lin airport_N = variants{} ; -- 
lin upset_V2 = variants{} ; -- 
lin upset_V = variants{} ; -- 
lin pretend_VS = variants{} ; -- 
lin pretend_V2 = variants{} ; -- 
lin pretend_V = variants{} ; -- 
lin plant_V2 = variants{} ; -- 
lin till_Prep = variants{} ; -- 
lin known_A = variants{} ; -- 
lin admission_N = variants{} ; -- 
lin tissue_N = variants{} ; -- 
lin magistrate_N = variants{} ; -- 
lin joy_N = variants{} ; -- 
lin free_V2V = variants{} ; -- 
lin free_V2 = variants{} ; -- 
lin pretty_A = variants{} ; -- 
lin operating_N = variants{} ; -- 
lin headquarters_N = variants{} ; -- 
lin grateful_A = variants{} ; -- 
lin classroom_N = variants{} ; -- 
lin turnover_N = variants{} ; -- 
lin project_VS = variants{} ; -- 
lin project_V2V = variants{} ; -- 
lin project_V2 = variants{} ; -- 
lin project_V = variants{} ; -- 
lin shrug_V2 = variants{} ; -- 
lin sensible_A = variants{} ; -- 
lin limitation_N = variants{} ; -- 
lin specialist_N = variants{} ; -- 
lin newly_Adv = variants{} ; -- 
lin tongue_N = possN (mkN "lsien" "ilsna") ;
lin refugee_N = variants{} ; -- 
lin delay_V2 = variants{} ; -- 
lin delay_V = variants{} ; -- 
lin dream_V2 = variants{} ; -- 
lin dream_V = variants{} ; -- 
lin composition_N = variants{} ; -- 
lin alongside_Prep = variants{} ; -- 
lin ceiling_N = mkN "saqaf" "soqfa" ;
lin highlight_V2 = variants{} ; -- 
lin stick_N = mkN "lasta" "lasti" ;
lin favourite_A = variants{} ; -- 
lin tap_V2 = variants{} ; -- 
lin tap_V = variants{} ; -- 
lin universe_N = variants{} ; -- 
lin request_VS = variants{} ; -- 
lin request_V2 = variants{} ; -- 
lin label_N = variants{} ; -- 
lin confine_V2 = variants{} ; -- 
lin scream_VS = variants{} ; -- 
lin scream_V2 = variants{} ; -- 
lin scream_V = variants{} ; -- 
lin rid_V2 = variants{} ; -- 
lin acceptance_N = variants{} ; -- 
lin detective_N = variants{} ; -- 
lin sail_V = variants{} ; -- 
lin adjust_V2 = variants{} ; -- 
lin adjust_V = variants{} ; -- 
lin designer_N = variants{} ; -- 
lin running_A = variants{} ; -- 
lin summit_N = variants{} ; -- 
lin participation_N = variants{} ; -- 
lin weakness_N = variants{} ; -- 
lin block_V2 = variants{} ; -- 
lin socalled_A = variants{} ; -- 
lin adapt_V2 = variants{} ; -- 
lin adapt_V = variants{} ; -- 
lin absorb_V2 = variants{} ; -- 
lin encounter_V2 = variants{} ; -- 
lin defeat_V2 = variants{} ; -- 
lin excitement_N = variants{} ; -- 
lin brick_N = variants{} ; -- 
lin blind_A = variants{} ; -- 
lin wire_N = variants{} ; -- 
lin crop_N = variants{} ; -- 
lin square_A = variants{} ; -- 
lin transition_N = variants{} ; -- 
lin thereby_Adv = variants{} ; -- 
lin protest_V2 = variants{} ; -- 
lin protest_V = variants{} ; -- 
lin roll_N = variants{} ; -- 
lin stop_N = variants{} ; -- 
lin assistant_N = variants{} ; -- 
lin deaf_A = variants{} ; -- 
lin constituency_N = variants{} ; -- 
lin continuous_A = variants{} ; -- 
lin concert_N = variants{} ; -- 
lin breast_N = possN (mkN "sider" "sdur") ;
lin extraordinary_A = variants{} ; -- 
lin squad_N = variants{} ; -- 
lin wonder_N = variants{} ; -- 
lin cream_N = variants{} ; -- 
lin tennis_N = variants{} ; -- 
lin personally_Adv = variants{} ; -- 
lin communicate_V2 = variants{} ; -- 
lin communicate_V = variants{} ; -- 
lin pride_N = variants{} ; -- 
lin bowl_N = variants{} ; -- 
lin file_V2 = variants{} ; -- 
lin file_V = variants{} ; -- 
lin expertise_N = variants{} ; -- 
lin govern_V2 = variants{} ; -- 
lin govern_V = variants{} ; -- 
lin leather_N = mkN "ġilda" "ġildiet" ;
lin observer_N = variants{} ; -- 
lin margin_N = variants{} ; -- 
lin uncertainty_N = variants{} ; -- 
lin reinforce_V2 = variants{} ; -- 
lin ideal_N = variants{} ; -- 
lin injure_V2 = variants{} ; -- 
lin holding_N = variants{} ; -- 
lin universal_A = variants{} ; -- 
lin evident_A = variants{} ; -- 
lin dust_N = mkNColl "traba" "trab" "trabiet" ;
lin overseas_A = variants{} ; -- 
lin desperate_A = variants{} ; -- 
lin swim_V2 = variants{}; -- gham_GHWM_1_10750_V ;
lin swim_V = gham_GHWM_1_10750_V ;
lin occasional_A = variants{} ; -- 
lin trouser_N = variants{} ; -- 
lin surprisingly_Adv = variants{} ; -- 
lin register_N = variants{} ; -- 
lin album_N = variants{} ; -- 
lin guideline_N = variants{} ; -- 
lin disturb_V2 = variants{} ; -- 
lin amendment_N = variants{} ; -- 
lin architectMasc_N = variants{} ; -- 
lin objection_N = variants{} ; -- 
lin chart_N = variants{} ; -- 
lin cattle_N = variants{} ; -- 
lin doubt_VS = variants{} ; -- 
lin doubt_V2 = variants{} ; -- 
lin react_V = variants{} ; -- 
lin consciousness_N = variants{} ; -- 
lin right_Interj = variants{} ; -- 
lin purely_Adv = variants{} ; -- 
lin tin_N = variants{} ; -- 
lin tube_N = variants{} ; -- 
lin fulfil_V2 = variants{} ; -- 
lin commonly_Adv = variants{} ; -- 
lin sufficiently_Adv = variants{} ; -- 
lin coin_N = variants{} ; -- 
lin frighten_V2 = variants{} ; -- 
lin grammar_N = mkN "grammatika" "grammatiki" ;
lin diary_N = variants{} ; -- 
lin flesh_N = variants{} ; -- 
lin summary_N = variants{} ; -- 
lin infant_N = variants{} ; -- 
lin stir_V2 = variants{} ; -- 
lin stir_V = variants{} ; -- 
lin storm_N = variants{} ; -- 
lin mail_N = variants{} ; -- 
lin rugby_N = variants{} ; -- 
lin virtue_N = variants{} ; -- 
lin specimen_N = variants{} ; -- 
lin psychology_N = variants{} ; -- 
lin paint_N = variants{} ; -- 
lin constraint_N = variants{} ; -- 
lin trace_V2 = variants{} ; -- 
lin trace_V = variants{} ; -- 
lin privilege_N = variants{} ; -- 
lin completion_N = variants{} ; -- 
lin progress_V2 = variants{} ; -- 
lin progress_V = variants{} ; -- 
lin grade_N = variants{} ; -- 
lin exploit_V2 = variants{} ; -- 
lin import_N = variants{} ; -- 
lin potato_N = variants{} ; -- 
lin repair_N = variants{} ; -- 
lin passion_N = variants{} ; -- 
lin seize_V2 = variants{} ; -- 
lin seize_V = variants{} ; -- 
lin low_Adv = variants{} ; -- 
lin underlying_A = variants{} ; -- 
lin heaven_N = variants{} ; -- 
lin nerve_N = variants{} ; -- 
lin park_V2 = variants{} ; -- 
lin park_V = variants{} ; -- 
lin collapse_V2 = variants{} ; -- 
lin collapse_V = variants{} ; -- 
lin win_N = variants{} ; -- 
lin printer_N = variants{} ; -- 
lin coalition_N = variants{} ; -- 
lin button_N = variants{} ; -- 
lin pray_V2 = variants{} ; -- 
lin pray_V = variants{} ; -- 
lin ultimate_A = variants{} ; -- 
lin venture_N = variants{} ; -- 
lin timber_N = variants{} ; -- 
lin companion_N = variants{} ; -- 
lin horror_N = variants{} ; -- 
lin gesture_N = variants{} ; -- 
lin moon_N = mkN "qamar" "oqmra" ;
lin remark_VS = variants{} ; -- 
lin remark_V = variants{} ; -- 
lin clever_A = mkA "bravu" ;
lin van_N = variants{} ; -- 
lin consequently_Adv = variants{} ; -- 
lin raw_A = variants{} ; -- 
lin glance_N = variants{} ; -- 
lin broken_A = variants{} ; -- 
lin jury_N = variants{} ; -- 
lin gaze_V = variants{} ; -- 
lin burst_V2 = variants{} ; -- 
lin burst_V = variants{} ; -- 
lin charter_N = variants{} ; -- 
lin feministMasc_N = variants{} ; -- 
lin discourse_N = variants{} ; -- 
lin reflection_N = variants{} ; -- 
lin carbon_N = variants{} ; -- 
lin sophisticated_A = variants{} ; -- 
lin ban_N = variants{} ; -- 
lin taxation_N = variants{} ; -- 
lin prosecution_N = variants{} ; -- 
lin softly_Adv = variants{} ; -- 
lin asleep_A = variants{} ; -- 
lin aids_N = variants{} ; -- 
lin publicity_N = variants{} ; -- 
lin departure_N = variants{} ; -- 
lin welcome_A = variants{} ; -- 
lin sharply_Adv = variants{} ; -- 
lin reception_N = variants{} ; -- 
lin cousin_N = mkN "kuġin" "kuġini" ; -- genderedN
lin relieve_V2 = variants{} ; -- 
lin linguistic_A = variants{} ; -- 
lin vat_N = variants{} ; -- 
lin forward_A = variants{} ; -- 
lin blue_N = variants{} ; -- 
lin multiple_A = variants{} ; -- 
lin pass_N = variants{} ; -- 
lin outer_A = variants{} ; -- 
lin vulnerable_A = variants{} ; -- 
lin patient_A = variants{} ; -- 
lin evolution_N = variants{} ; -- 
lin allocate_V2 = variants{} ; -- 
lin allocate_V = variants{} ; -- 
lin creative_A = variants{} ; -- 
lin potentially_Adv = variants{} ; -- 
lin just_A = variants{} ; -- 
lin out_Prep = variants{} ; -- 
lin judicial_A = variants{} ; -- 
lin risk_VV = variants{} ; -- 
lin risk_V2 = variants{} ; -- 
lin ideology_N = variants{} ; -- 
lin smell_VA = variants{}; -- xamm_XMM_1_10207_V ;
lin smell_V2 = variants{}; -- xamm_XMM_1_10207_V ;
lin smell_V = xamm_XMM_1_10207_V ;
lin agenda_N = variants{} ; -- 
lin transport_V2 = variants{} ; -- 
lin illegal_A = variants{} ; -- 
lin chicken_N = variants{} ; -- 
lin plain_A = variants{} ; -- 
lin innovation_N = variants{} ; -- 
lin opera_N = variants{} ; -- 
lin lock_N = variants{} ; -- 
lin grin_V = variants{} ; -- 
lin shelf_N = variants{} ; -- 
lin pole_N = variants{} ; -- 
lin punishment_N = variants{} ; -- 
lin strict_A = variants{} ; -- 
lin wave_V2 = variants{} ; -- 
lin wave_V = variants{} ; -- 
lin inside_N = variants{} ; -- 
lin carriage_N = variants{} ; -- 
lin fit_A = variants{} ; -- 
lin conversion_N = variants{} ; -- 
lin hurry_V = variants{} ; -- 
lin essay_N = variants{} ; -- 
lin integration_N = variants{} ; -- 
lin resignation_N = variants{} ; -- 
lin treasury_N = variants{} ; -- 
lin traveller_N = variants{} ; -- 
lin chocolate_N = variants{} ; -- 
lin assault_N = variants{} ; -- 
lin schedule_N = variants{} ; -- 
lin undoubtedly_Adv = variants{} ; -- 
lin twin_N = variants{} ; -- 
lin format_N = variants{} ; -- 
lin murder_V2 = variants{} ; -- 
lin sigh_VS = variants{} ; -- 
lin sigh_V2 = variants{} ; -- 
lin sigh_V = variants{} ; -- 
lin sellerMasc_N = variants{} ; -- 
lin lease_N = variants{} ; -- 
lin bitter_A = variants{} ; -- 
lin double_V2 = variants{} ; -- 
lin double_V = variants{} ; -- 
lin ally_N = variants{} ; -- 
lin stake_N = variants{} ; -- 
lin processing_N = variants{} ; -- 
lin informal_A = variants{} ; -- 
lin flexible_A = variants{} ; -- 
lin cap_N = mkN "kappell" "kpiepel" ;
lin stable_A = variants{} ; -- 
lin till_Subj = variants{} ; -- 
lin sympathy_N = variants{} ; -- 
lin tunnel_N = variants{} ; -- 
lin pen_N = mkN "pinna" "pinen" ;
lin instal_V = variants{} ; -- 
lin suspend_V2 = variants{} ; -- 
lin suspend_V = variants{} ; -- 
lin blow_N = variants{} ; -- 
lin wander_V = variants{} ; -- 
lin notably_Adv = variants{} ; -- 
lin disappoint_V2 = variants{} ; -- 
lin wipe_V2 = dirV2 (mesah_MSH_1_8881_V) ;
lin wipe_V = variants{}; -- dirV2 (mesah_MSH_1_8881_V) ;
lin folk_N = variants{} ; -- 
lin attraction_N = variants{} ; -- 
lin disc_N = variants{} ; -- 
lin inspire_V2V = variants{} ; -- 
lin inspire_V2 = variants{} ; -- 
lin machinery_N = variants{} ; -- 
lin undergo_V2 = variants{} ; -- 
lin nowhere_Adv = variants{} ; -- 
lin inspector_N = variants{} ; -- 
lin wise_A = variants{} ; -- 
lin balance_V2 = variants{} ; -- 
lin balance_V = variants{} ; -- 
lin purchaser_N = variants{} ; -- 
lin resort_N = variants{} ; -- 
lin pop_N = variants{} ; -- 
lin organ_N = variants{} ; -- 
lin ease_V2 = variants{} ; -- 
lin ease_V = variants{} ; -- 
lin friendship_N = variants{} ; -- 
lin deficit_N = variants{} ; -- 
lin dear_N = variants{} ; -- 
lin convey_V2 = variants{} ; -- 
lin reserve_V2 = variants{} ; -- 
lin reserve_V = variants{} ; -- 
lin planet_N = mkN "pjaneta" "pjaneti" ;
lin frequent_A = variants{} ; -- 
lin loose_A = variants{} ; -- 
lin intense_A = variants{} ; -- 
lin retail_A = variants{} ; -- 
lin wind_V = variants{} ; -- 
lin lost_A = variants{} ; -- 
lin grain_N = variants{} ; -- 
lin particle_N = variants{} ; -- 
lin destruction_N = variants{} ; -- 
lin witness_V2 = variants{} ; -- 
lin witness_V = variants{} ; -- 
lin pit_N = variants{} ; -- 
lin registration_N = variants{} ; -- 
lin conception_N = variants{} ; -- 
lin steady_A = variants{} ; -- 
lin rival_N = variants{} ; -- 
lin steam_N = variants{} ; -- 
lin back_A = variants{} ; -- 
lin chancellor_N = variants{} ; -- 
lin crash_V = variants{} ; -- 
lin belt_N = variants{} ; -- 
lin logic_N = variants{} ; -- 
lin premium_N = variants{} ; -- 
lin confront_V2 = variants{} ; -- 
lin precede_V2 = variants{} ; -- 
lin experimental_A = variants{} ; -- 
lin alarm_N = variants{} ; -- 
lin rational_A = variants{} ; -- 
lin incentive_N = variants{} ; -- 
lin roughly_Adv = variants{} ; -- 
lin bench_N = variants{} ; -- 
lin wrap_V2 = variants{} ; -- 
lin wrap_V = variants{} ; -- 
lin regarding_Prep = variants{} ; -- 
lin inadequate_A = variants{} ; -- 
lin ambition_N = variants{} ; -- 
lin since_Adv = variants{} ; -- 
lin fate_N = variants{} ; -- 
lin vendor_N = variants{} ; -- 
lin stranger_N = variants{} ; -- 
lin spiritual_A = variants{} ; -- 
lin increasing_A = variants{} ; -- 
lin anticipate_VV = variants{} ; -- 
lin anticipate_VS = variants{} ; -- 
lin anticipate_V2 = variants{} ; -- 
lin anticipate_V = variants{} ; -- 
lin logical_A = variants{} ; -- 
lin fibre_N = variants{} ; -- 
lin attribute_V2 = variants{} ; -- 
lin sense_VS = variants{} ; -- 
lin sense_V2 = variants{} ; -- 
lin black_N = variants{} ; -- 
lin petrol_N = variants{} ; -- 
lin maker_N = variants{} ; -- 
lin generous_A = variants{} ; -- 
lin allocation_N = variants{} ; -- 
lin depression_N = variants{} ; -- 
lin declaration_N = variants{} ; -- 
lin spot_VS = variants{} ; -- 
lin spot_V2 = variants{} ; -- 
lin spot_V = variants{} ; -- 
lin modest_A = variants{} ; -- 
lin bottom_A = variants{} ; -- 
lin dividend_N = variants{} ; -- 
lin devote_V2 = variants{} ; -- 
lin condemn_V2 = variants{} ; -- 
lin integrate_V2 = variants{} ; -- 
lin integrate_V = variants{} ; -- 
lin pile_N = variants{} ; -- 
lin identification_N = variants{} ; -- 
lin acute_A = variants{} ; -- 
lin barely_Adv = variants{} ; -- 
lin providing_Subj = variants{} ; -- 
lin directive_N = variants{} ; -- 
lin bet_VS = variants{} ; -- 
lin bet_V2 = variants{} ; -- 
lin bet_V = variants{} ; -- 
lin modify_V2 = variants{} ; -- 
lin bare_A = variants{} ; -- 
lin swear_VV = variants{} ; -- 
lin swear_V2 = variants{} ; -- 
lin swear_V = variants{} ; -- 
lin final_N = variants{} ; -- 
lin accordingly_Adv = variants{} ; -- 
lin valid_A = variants{} ; -- 
lin wherever_Adv = variants{} ; -- 
lin mortality_N = variants{} ; -- 
lin medium_N = variants{} ; -- 
lin silk_N = variants{} ; -- 
lin funeral_N = variants{} ; -- 
lin depending_A = variants{} ; -- 
lin cow_N = mkNColl "baqra" "baqar" "baqriet" ;
lin correspond_V2 = variants{} ; -- 
lin correspond_V = variants{} ; -- 
lin cite_V2 = variants{} ; -- 
lin classic_A = variants{} ; -- 
lin inspection_N = variants{} ; -- 
lin calculation_N = variants{} ; -- 
lin rubbish_N = variants{} ; -- 
lin minimum_N = variants{} ; -- 
lin hypothesis_N = variants{} ; -- 
lin youngster_N = variants{} ; -- 
lin slope_N = variants{} ; -- 
lin patch_N = variants{} ; -- 
lin invitation_N = variants{} ; -- 
lin ethnic_A = variants{} ; -- 
lin federation_N = variants{} ; -- 
lin duke_N = variants{} ; -- 
lin wholly_Adv = variants{} ; -- 
lin closure_N = variants{} ; -- 
lin dictionary_N = variants{} ; -- 
lin withdrawal_N = variants{} ; -- 
lin automatic_A = variants{} ; -- 
lin liable_A = variants{} ; -- 
lin cry_N = variants{} ; -- 
lin slow_V2 = variants{} ; -- 
lin slow_V = variants{} ; -- 
lin borough_N = variants{} ; -- 
lin well_A = variants{} ; -- 
lin suspicion_N = variants{} ; -- 
lin portrait_N = variants{} ; -- 
lin local_N = variants{} ; -- 
lin jew_N = variants{} ; -- 
lin fragment_N = variants{} ; -- 
lin revolutionary_A = variants{} ; -- 
lin evaluate_V2 = variants{} ; -- 
lin evaluate_V = variants{} ; -- 
lin competitor_N = variants{} ; -- 
lin sole_A = variants{} ; -- 
lin reliable_A = variants{} ; -- 
lin weigh_V2 = variants{} ; -- 
lin weigh_V = variants{} ; -- 
lin medieval_A = variants{} ; -- 
lin clinic_N = variants{} ; -- 
lin shine_V2 = variants{} ; -- 
lin shine_V = variants{} ; -- 
lin knit_V2 = variants{} ; -- 
lin knit_V = variants{} ; -- 
lin complexity_N = variants{} ; -- 
lin remedy_N = variants{} ; -- 
lin fence_N = variants{} ; -- 
lin bike_N = mkN "rota" "roti" ;
lin freeze_V2 = variants{}; -- ffriza_V ;
lin freeze_V = ffriza_V ;
lin eliminate_V2 = variants{} ; -- 
lin interior_N = variants{} ; -- 
lin intellectual_A = variants{} ; -- 
lin established_A = variants{} ; -- 
lin voter_N = variants{} ; -- 
lin garage_N = variants{} ; -- 
lin era_N = variants{} ; -- 
lin pregnant_A = variants{} ; -- 
lin plot_N = variants{} ; -- 
lin greet_V2 = variants{} ; -- 
lin electrical_A = variants{} ; -- 
lin lie_N = variants{} ; -- 
lin disorder_N = variants{} ; -- 
lin formally_Adv = variants{} ; -- 
lin excuse_N = variants{} ; -- 
lin socialist_A = variants{} ; -- 
lin cancel_V2 = variants{} ; -- 
lin cancel_V = variants{} ; -- 
lin harm_N = variants{} ; -- 
lin excess_N = variants{} ; -- 
lin exact_A = variants{} ; -- 
lin oblige_V2V = variants{} ; -- 
lin oblige_V2 = variants{} ; -- 
lin accountant_N = variants{} ; -- 
lin mutual_A = variants{} ; -- 
lin fat_N = mkNColl "xaħma" "xaħam" "xaħmiet" "xaħmijiet" ;
lin volunteerMasc_N = variants{} ; -- 
lin laughter_N = variants{} ; -- 
lin trick_N = variants{} ; -- 
lin load_V2 = variants{} ; -- 
lin load_V = variants{} ; -- 
lin disposal_N = variants{} ; -- 
lin taxi_N = variants{} ; -- 
lin murmur_V2 = variants{} ; -- 
lin murmur_V = variants{} ; -- 
lin tonne_N = variants{} ; -- 
lin spell_V2 = variants{} ; -- 
lin spell_V = variants{} ; -- 
lin clerk_N = variants{} ; -- 
lin curious_A = variants{} ; -- 
lin satisfactory_A = variants{} ; -- 
lin identical_A = variants{} ; -- 
lin applicant_N = variants{} ; -- 
lin removal_N = variants{} ; -- 
lin processor_N = variants{} ; -- 
lin cotton_N = variants{} ; -- 
lin reverse_V2 = variants{} ; -- 
lin reverse_V = variants{} ; -- 
lin hesitate_VV = variants{} ; -- 
lin hesitate_V = variants{} ; -- 
lin professor_N = variants{} ; -- 
lin admire_V2 = variants{} ; -- 
lin namely_Adv = variants{} ; -- 
lin electoral_A = variants{} ; -- 
lin delight_N = variants{} ; -- 
lin urgent_A = variants{} ; -- 
lin prompt_V2V = variants{} ; -- 
lin prompt_V2 = variants{} ; -- 
lin mate_N = variants{} ; -- 
lin mate_2_N = variants{} ; -- 
lin mate_1_N = variants{} ; -- 
lin exposure_N = variants{} ; -- 
lin server_N = variants{} ; -- 
lin distinctive_A = variants{} ; -- 
lin marginal_A = variants{} ; -- 
lin structural_A = variants{} ; -- 
lin rope_N = mkN "ħabel" "ħbula" ;
lin miner_N = variants{} ; -- 
lin entertainment_N = variants{} ; -- 
lin acre_N = variants{} ; -- 
lin pig_N = variants{} ; -- 
lin encouraging_A = variants{} ; -- 
lin guarantee_N = variants{} ; -- 
lin gear_N = variants{} ; -- 
lin anniversary_N = variants{} ; -- 
lin past_Adv = variants{} ; -- 
lin ceremony_N = variants{} ; -- 
lin rub_V2 = dirV2 (ghorok_GHRK_1_10599_V) ;
lin rub_V = variants{}; -- dirV2 (ghorok_GHRK_1_10599_V) ;
lin monopoly_N = variants{} ; -- 
lin left_N = variants{} ; -- 
lin flee_V2 = variants{} ; -- 
lin flee_V = variants{} ; -- 
lin yield_V2 = variants{} ; -- 
lin discount_N = variants{} ; -- 
lin above_A = variants{} ; -- 
lin uncle_N = variants{} ; -- 
lin audit_N = variants{} ; -- 
lin advertisement_N = variants{} ; -- 
lin explosion_N = variants{} ; -- 
lin contrary_A = variants{} ; -- 
lin tribunal_N = variants{} ; -- 
lin swallow_V2 = variants{} ; -- 
lin swallow_V = variants{} ; -- 
lin typically_Adv = variants{} ; -- 
lin fun_A = variants{} ; -- 
lin rat_N = variants{} ; -- 
lin cloth_N = variants{} ; -- 
lin cable_N = variants{} ; -- 
lin interrupt_V2 = variants{} ; -- 
lin interrupt_V = variants{} ; -- 
lin crash_N = variants{} ; -- 
lin flame_N = variants{} ; -- 
lin controversy_N = variants{} ; -- 
lin rabbit_N = variants{} ; -- 
lin everyday_A = variants{} ; -- 
lin allegation_N = variants{} ; -- 
lin strip_N = variants{} ; -- 
lin stability_N = variants{} ; -- 
lin tide_N = variants{} ; -- 
lin illustration_N = variants{} ; -- 
lin insect_N = variants{} ; -- 
lin correspondent_N = variants{} ; -- 
lin devise_V2 = variants{} ; -- 
lin determined_A = variants{} ; -- 
lin brush_V2 = variants{} ; -- 
lin brush_V = variants{} ; -- 
lin adjustment_N = variants{} ; -- 
lin controversial_A = variants{} ; -- 
lin organic_A = variants{} ; -- 
lin escape_N = variants{} ; -- 
lin thoroughly_Adv = variants{} ; -- 
lin interface_N = variants{} ; -- 
lin historic_A = variants{} ; -- 
lin collapse_N = variants{} ; -- 
lin temple_N = variants{} ; -- 
lin shade_N = variants{} ; -- 
lin craft_N = variants{} ; -- 
lin nursery_N = variants{} ; -- 
lin piano_N = variants{} ; -- 
lin desirable_A = variants{} ; -- 
lin assurance_N = variants{} ; -- 
lin jurisdiction_N = variants{} ; -- 
lin advertise_V2 = variants{} ; -- 
lin advertise_V = variants{} ; -- 
lin bay_N = variants{} ; -- 
lin specification_N = variants{} ; -- 
lin disability_N = variants{} ; -- 
lin presidential_A = variants{} ; -- 
lin arrest_N = variants{} ; -- 
lin unexpected_A = variants{} ; -- 
lin switch_N = variants{} ; -- 
lin penny_N = variants{} ; -- 
lin respect_V2 = variants{} ; -- 
lin celebration_N = variants{} ; -- 
lin gross_A = variants{} ; -- 
lin aid_V2 = variants{} ; -- 
lin aid_V = variants{} ; -- 
lin superb_A = variants{} ; -- 
lin process_V2 = variants{} ; -- 
lin process_V = variants{} ; -- 
lin innocent_A = variants{} ; -- 
lin leap_V2 = variants{} ; -- 
lin leap_V = variants{} ; -- 
lin colony_N = variants{} ; -- 
lin wound_N = variants{} ; -- 
lin hardware_N = variants{} ; -- 
lin satellite_N = variants{} ; -- 
lin float_V = gham_GHWM_1_10750_V ; ---
lin bible_N = variants{} ; -- 
lin statistical_A = variants{} ; -- 
lin marked_A = variants{} ; -- 
lin hire_V2V = variants{} ; -- 
lin hire_V2 = variants{} ; -- 
lin cathedral_N = variants{} ; -- 
lin motive_N = variants{} ; -- 
lin correct_VS = variants{} ; -- 
lin correct_V2 = variants{} ; -- 
lin correct_V = variants{} ; -- 
lin gastric_A = variants{} ; -- 
lin raid_N = variants{} ; -- 
lin comply_V2 = variants{} ; -- 
lin comply_V = variants{} ; -- 
lin accommodate_V2 = variants{} ; -- 
lin accommodate_V = variants{} ; -- 
lin mutter_V2 = variants{} ; -- 
lin mutter_V = variants{} ; -- 
lin induce_V2 = variants{} ; -- 
lin trap_V2 = variants{} ; -- 
lin trap_V = variants{} ; -- 
lin invasion_N = variants{} ; -- 
lin humour_N = variants{} ; -- 
lin bulk_N = variants{} ; -- 
lin traditionally_Adv = variants{} ; -- 
lin commission_V2V = variants{} ; -- 
lin commission_V2 = variants{} ; -- 
lin upstairs_Adv = variants{} ; -- 
lin translate_V2 = variants{} ; -- 
lin translate_V = variants{} ; -- 
lin rhythm_N = variants{} ; -- 
lin emission_N = variants{} ; -- 
lin collective_A = variants{} ; -- 
lin transformation_N = variants{} ; -- 
lin battery_N = variants{} ; -- 
lin stimulus_N = variants{} ; -- 
lin naked_A = variants{} ; -- 
lin white_N = variants{} ; -- 
lin menu_N = variants{} ; -- 
lin toilet_N = variants{} ; -- 
lin butter_N = mkNColl "butir" "butirijiet" ;
lin surprise_V2V = variants{} ; -- 
lin surprise_V2 = variants{} ; -- 
lin needle_N = variants{} ; -- 
lin effectiveness_N = variants{} ; -- 
lin accordance_N = variants{} ; -- 
lin molecule_N = variants{} ; -- 
lin fiction_N = variants{} ; -- 
lin learning_N = variants{} ; -- 
lin statute_N = variants{} ; -- 
lin reluctant_A = variants{} ; -- 
lin overlook_V2 = variants{} ; -- 
lin junction_N = variants{} ; -- 
lin necessity_N = variants{} ; -- 
lin nearby_A = variants{} ; -- 
lin experienced_A = variants{} ; -- 
lin lorry_N = variants{} ; -- 
lin exclusive_A = variants{} ; -- 
lin graphics_N = variants{} ; -- 
lin stimulate_V2 = variants{} ; -- 
lin warmth_N = variants{} ; -- 
lin therapy_N = variants{} ; -- 
lin convenient_A = variants{} ; -- 
lin cinema_N = variants{} ; -- 
lin domain_N = variants{} ; -- 
lin tournament_N = variants{} ; -- 
lin doctrine_N = variants{} ; -- 
lin sheer_A = variants{} ; -- 
lin proposition_N = variants{} ; -- 
lin grip_N = variants{} ; -- 
lin widow_N = variants{} ; -- 
lin discrimination_N = variants{} ; -- 
lin bloody_Adv = variants{} ; -- 
lin ruling_A = variants{} ; -- 
lin fit_N = variants{} ; -- 
lin nonetheless_Adv = variants{} ; -- 
lin myth_N = variants{} ; -- 
lin episode_N = variants{} ; -- 
lin drift_V2 = variants{} ; -- 
lin drift_V = variants{} ; -- 
lin assert_VS = variants{} ; -- 
lin assert_V2 = variants{} ; -- 
lin assert_V = variants{} ; -- 
lin terrace_N = variants{} ; -- 
lin uncertain_A = mkA "inċert" ;
lin twist_V2 = variants{} ; -- 
lin insight_N = variants{} ; -- 
lin undermine_V2 = variants{} ; -- 
lin tragedy_N = variants{} ; -- 
lin enforce_V2 = variants{} ; -- 
lin criticize_V2 = variants{} ; -- 
lin criticize_V = variants{} ; -- 
lin march_V2 = variants{} ; -- 
lin march_V = variants{} ; -- 
lin leaflet_N = variants{} ; -- 
lin fellow_A = variants{} ; -- 
lin object_V2 = variants{} ; -- 
lin object_V = variants{} ; -- 
lin pond_N = variants{} ; -- 
lin adventure_N = variants{} ; -- 
lin diplomatic_A = variants{} ; -- 
lin mixed_A = variants{} ; -- 
lin rebel_N = variants{} ; -- 
lin equity_N = variants{} ; -- 
lin literally_Adv = variants{} ; -- 
lin magnificent_A = variants{} ; -- 
lin loyalty_N = variants{} ; -- 
lin tremendous_A = variants{} ; -- 
lin airline_N = variants{} ; -- 
lin shore_N = variants{} ; -- 
lin restoration_N = variants{} ; -- 
lin physically_Adv = variants{} ; -- 
lin render_V2 = variants{} ; -- 
lin institutional_A = variants{} ; -- 
lin emphasize_VS = variants{} ; -- 
lin emphasize_V2 = variants{} ; -- 
lin mess_N = variants{} ; -- 
lin commander_N = variants{} ; -- 
lin straightforward_A = variants{} ; -- 
lin singer_N = variants{} ; -- 
lin squeeze_V2 = dirV2 (ghasar_GHSR_1_10625_V) ;
lin squeeze_V = variants{}; -- dirV2 (ghasar_GHSR_1_10625_V) ;
lin full_time_A = variants{} ; -- 
lin breed_V2 = variants{} ; -- 
lin breed_V = variants{} ; -- 
lin successor_N = variants{} ; -- 
lin triumph_N = variants{} ; -- 
lin heading_N = variants{} ; -- 
lin mathematics_N = variants{} ; -- 
lin laugh_N = variants{} ; -- 
lin clue_N = variants{} ; -- 
lin still_A = variants{} ; -- 
lin ease_N = variants{} ; -- 
lin specially_Adv = variants{} ; -- 
lin biological_A = variants{} ; -- 
lin forgive_V2 = variants{} ; -- 
lin forgive_V = variants{} ; -- 
lin trustee_N = variants{} ; -- 
lin photo_N = variants{} ; -- 
lin fraction_N = variants{} ; -- 
lin chase_V2 = variants{} ; -- 
lin chase_V = variants{} ; -- 
lin whereby_Adv = variants{} ; -- 
lin mud_N = variants{} ; -- 
lin pensioner_N = variants{} ; -- 
lin functional_A = variants{} ; -- 
lin copy_V2 = variants{} ; -- 
lin copy_V = variants{} ; -- 
lin strictly_Adv = variants{} ; -- 
lin desperately_Adv = variants{} ; -- 
lin await_V2 = variants{} ; -- 
lin coverage_N = variants{} ; -- 
lin wildlife_N = variants{} ; -- 
lin indicator_N = variants{} ; -- 
lin lightly_Adv = variants{} ; -- 
lin hierarchy_N = variants{} ; -- 
lin evolve_V2 = variants{} ; -- 
lin evolve_V = variants{} ; -- 
lin mechanical_A = variants{} ; -- 
lin expert_A = variants{} ; -- 
lin creditor_N = variants{} ; -- 
lin capitalist_N = variants{} ; -- 
lin essence_N = variants{} ; -- 
lin compose_V2 = variants{} ; -- 
lin compose_V = variants{} ; -- 
lin mentally_Adv = variants{} ; -- 
lin gaze_N = variants{} ; -- 
lin seminar_N = variants{} ; -- 
lin target_V2V = variants{} ; -- 
lin target_V2 = variants{} ; -- 
lin label_V3 = variants{} ; -- 
lin label_V2 = variants{} ; -- 
lin label_V = variants{} ; -- 
lin fig_N = variants{} ; -- 
lin continent_N = variants{} ; -- 
lin chap_N = variants{} ; -- 
lin flexibility_N = variants{} ; -- 
lin verse_N = variants{} ; -- 
lin minute_A = variants{} ; -- 
lin whisky_N = variants{} ; -- 
lin equivalent_A = variants{} ; -- 
lin recruit_V2 = variants{} ; -- 
lin recruit_V = variants{} ; -- 
lin echo_V2 = variants{} ; -- 
lin echo_V = variants{} ; -- 
lin unfair_A = variants{} ; -- 
lin launch_N = variants{} ; -- 
lin cupboard_N = variants{} ; -- 
lin bush_N = variants{} ; -- 
lin shortage_N = variants{} ; -- 
lin prominent_A = variants{} ; -- 
lin merger_N = variants{} ; -- 
lin command_V2 = variants{} ; -- 
lin command_V = variants{} ; -- 
lin subtle_A = variants{} ; -- 
lin capital_A = variants{} ; -- 
lin gang_N = variants{} ; -- 
lin fish_V2 = variants{} ; -- 
lin fish_V = variants{} ; -- 
lin unhappy_A = variants{} ; -- 
lin lifetime_N = variants{} ; -- 
lin elite_N = variants{} ; -- 
lin refusal_N = variants{} ; -- 
lin finish_N = variants{} ; -- 
lin aggressive_A = variants{} ; -- 
lin superior_A = variants{} ; -- 
lin landing_N = variants{} ; -- 
lin exchange_V2 = variants{} ; -- 
lin debate_V2 = variants{} ; -- 
lin debate_V = variants{} ; -- 
lin educate_V2 = variants{} ; -- 
lin separation_N = variants{} ; -- 
lin productivity_N = variants{} ; -- 
lin initiate_V2 = variants{} ; -- 
lin probability_N = variants{} ; -- 
lin virus_N = variants{} ; -- 
lin reporterMasc_N = variants{} ; -- 
lin fool_N = variants{} ; -- 
lin pop_V2 = variants{} ; -- 
lin capitalism_N = variants{} ; -- 
lin painful_A = variants{} ; -- 
lin correctly_Adv = variants{} ; -- 
lin complex_N = variants{} ; -- 
lin rumour_N = variants{} ; -- 
lin imperial_A = variants{} ; -- 
lin justification_N = variants{} ; -- 
lin availability_N = variants{} ; -- 
lin spectacular_A = variants{} ; -- 
lin remain_N = variants{} ; -- 
lin ocean_N = variants{} ; -- 
lin cliff_N = variants{} ; -- 
lin sociology_N = variants{} ; -- 
lin sadly_Adv = variants{} ; -- 
lin missile_N = variants{} ; -- 
lin situate_V2 = variants{} ; -- 
lin artificial_A = variants{} ; -- 
lin apartment_N = mkN "appartament" "appartamenti" ;
lin provoke_V2 = variants{} ; -- 
lin oral_A = variants{} ; -- 
lin maximum_N = variants{} ; -- 
lin angel_N = variants{} ; -- 
lin spare_A = variants{} ; -- 
lin shame_N = variants{} ; -- 
lin intelligent_A = variants{} ; -- 
lin discretion_N = variants{} ; -- 
lin businessman_N = variants{} ; -- 
lin explicit_A = variants{} ; -- 
lin book_V2 = variants{} ; -- 
lin uniform_N = variants{} ; -- 
lin push_N = variants{} ; -- 
lin counter_N = variants{} ; -- 
lin subject_A = variants{} ; -- 
lin objective_A = variants{} ; -- 
lin hungry_A = variants{} ; -- 
lin clothing_N = variants{} ; -- 
lin ride_N = variants{} ; -- 
lin romantic_A = variants{} ; -- 
lin attendance_N = variants{} ; -- 
lin part_time_A = variants{} ; -- 
lin trace_N = variants{} ; -- 
lin backing_N = variants{} ; -- 
lin sensation_N = variants{} ; -- 
lin carrier_N = variants{} ; -- 
lin interest_V2 = variants{} ; -- 
lin interest_V = variants{} ; -- 
lin classification_N = variants{} ; -- 
lin classic_N = variants{} ; -- 
lin beg_V2 = variants{}; -- mkV2V ttallab_TLB_5_9893_V ghalP minnP ;
lin beg_V = variants{}; -- mkV2V ttallab_TLB_5_9893_V ghalP minnP ;
lin appendix_N = variants{} ; -- 
lin doorway_N = variants{} ; -- 
lin density_N = variants{} ; -- 
lin working_class_A = variants{} ; -- 
lin legislative_A = variants{} ; -- 
lin hint_N = variants{} ; -- 
lin shower_N = variants{} ; -- 
lin current_N = variants{} ; -- 
lin succession_N = variants{} ; -- 
lin nasty_A = variants{} ; -- 
lin duration_N = variants{} ; -- 
lin desert_N = variants{} ; -- 
lin receipt_N = variants{} ; -- 
lin native_A = variants{} ; -- 
lin chapel_N = variants{} ; -- 
lin amazing_A = variants{} ; -- 
lin hopefully_Adv = variants{} ; -- 
lin fleet_N = variants{} ; -- 
lin comparable_A = variants{} ; -- 
lin oxygen_N = variants{} ; -- 
lin installation_N = variants{} ; -- 
lin developer_N = variants{} ; -- 
lin disadvantage_N = variants{} ; -- 
lin recipe_N = variants{} ; -- 
lin crystal_N = variants{} ; -- 
lin modification_N = variants{} ; -- 
lin schedule_V2V = variants{} ; -- 
lin schedule_V2 = variants{} ; -- 
lin schedule_V = variants{} ; -- 
lin midnight_N = variants{} ; -- 
lin successive_A = variants{} ; -- 
lin formerly_Adv = variants{} ; -- 
lin loud_A = variants{} ; -- 
lin value_V2 = variants{} ; -- 
lin value_V = variants{} ; -- 
lin physics_N = variants{} ; -- 
lin truck_N = variants{} ; -- 
lin stroke_N = variants{} ; -- 
lin kiss_N = variants{} ; -- 
lin envelope_N = variants{} ; -- 
lin speculation_N = variants{} ; -- 
lin canal_N = variants{} ; -- 
lin unionist_N = variants{} ; -- 
lin directory_N = variants{} ; -- 
lin receiver_N = variants{} ; -- 
lin isolation_N = variants{} ; -- 
lin fade_V2 = variants{} ; -- 
lin fade_V = variants{} ; -- 
lin chemistry_N = variants{} ; -- 
lin unnecessary_A = variants{} ; -- 
lin hit_N = variants{} ; -- 
lin defenderMasc_N = variants{} ; -- 
lin stance_N = variants{} ; -- 
lin sin_N = variants{} ; -- 
lin realistic_A = variants{} ; -- 
lin socialist_N = variants{} ; -- 
lin subsidy_N = variants{} ; -- 
lin content_A = variants{} ; -- 
lin toy_N = variants{} ; -- 
lin darling_N = variants{} ; -- 
lin decent_A = variants{} ; -- 
lin liberty_N = variants{} ; -- 
lin forever_Adv = variants{} ; -- 
lin skirt_N = variants{} ; -- 
lin coordinate_V2 = variants{} ; -- 
lin coordinate_V = variants{} ; -- 
lin tactic_N = variants{} ; -- 
lin influential_A = variants{} ; -- 
lin import_V2 = variants{} ; -- 
lin accent_N = variants{} ; -- 
lin compound_N = variants{} ; -- 
lin bastard_N = variants{} ; -- 
lin ingredient_N = variants{} ; -- 
lin dull_A = sameA "tad-dwejjaq" ;
lin cater_V = variants{} ; -- 
lin scholar_N = variants{} ; -- 
lin faint_A = variants{} ; -- 
lin ghost_N = variants{} ; -- 
lin sculpture_N = variants{} ; -- 
lin ridiculous_A = variants{} ; -- 
lin diagnosis_N = variants{} ; -- 
lin delegate_N = variants{} ; -- 
lin neat_A = variants{} ; -- 
lin kit_N = variants{} ; -- 
lin lion_N = variants{} ; -- 
lin dialogue_N = variants{} ; -- 
lin repair_V2 = variants{} ; -- 
lin repair_V = variants{} ; -- 
lin tray_N = variants{} ; -- 
lin fantasy_N = variants{} ; -- 
lin leave_N = variants{} ; -- 
lin export_V2 = variants{} ; -- 
lin export_V = variants{} ; -- 
lin forth_Adv = variants{} ; -- 
lin lamp_N = mkN "lampa" "lampi" ;
lin allege_VS = variants{} ; -- 
lin allege_V2 = variants{} ; -- 
lin pavement_N = variants{} ; -- 
lin brand_N = variants{} ; -- 
lin constable_N = variants{} ; -- 
lin compromise_N = variants{} ; -- 
lin flag_N = variants{} ; -- 
lin filter_N = variants{} ; -- 
lin reign_N = variants{} ; -- 
lin execute_V2 = variants{} ; -- 
lin pity_N = variants{} ; -- 
lin merit_N = variants{} ; -- 
lin diagram_N = variants{} ; -- 
lin wool_N = variants{} ; -- 
lin organism_N = variants{} ; -- 
lin elegant_A = variants{} ; -- 
lin red_N = variants{} ; -- 
lin undertaking_N = variants{} ; -- 
lin lesser_A = variants{} ; -- 
lin reach_N = variants{} ; -- 
lin marvellous_A = variants{} ; -- 
lin improved_A = variants{} ; -- 
lin locally_Adv = variants{} ; -- 
lin entity_N = variants{} ; -- 
lin rape_N = variants{} ; -- 
lin secure_A = variants{} ; -- 
lin descend_V2 = variants{} ; -- 
lin descend_V = variants{} ; -- 
lin backwards_Adv = variants{} ; -- 
lin peer_V = variants{} ; -- 
lin excuse_V2 = variants{} ; -- 
lin genetic_A = variants{} ; -- 
lin fold_V2 = variants{} ; -- 
lin fold_V = variants{} ; -- 
lin portfolio_N = variants{} ; -- 
lin consensus_N = variants{} ; -- 
lin thesis_N = variants{} ; -- 
lin shop_V = variants{} ; -- 
lin nest_N = variants{} ; -- 
lin frown_V = variants{} ; -- 
lin builder_N = variants{} ; -- 
lin administer_V2 = variants{} ; -- 
lin administer_V = variants{} ; -- 
lin tip_V2 = variants{} ; -- 
lin tip_V = variants{} ; -- 
lin lung_N = variants{} ; -- 
lin delegation_N = variants{} ; -- 
lin outside_N = variants{} ; -- 
lin heating_N = variants{} ; -- 
lin like_Subj = variants{} ; -- 
lin instinct_N = variants{} ; -- 
lin teenager_N = variants{} ; -- 
lin lonely_A = variants{} ; -- 
lin residence_N = variants{} ; -- 
lin radiation_N = variants{} ; -- 
lin extract_V2 = variants{} ; -- 
lin concession_N = variants{} ; -- 
lin autonomy_N = variants{} ; -- 
lin norm_N = variants{} ; -- 
lin musicianMasc_N = variants{} ; -- 
lin graduate_N = variants{} ; -- 
lin glory_N = variants{} ; -- 
lin bear_N = variants{} ; -- 
lin persist_V = variants{} ; -- 
lin rescue_V2 = variants{} ; -- 
lin equip_V2 = variants{} ; -- 
lin partial_A = variants{} ; -- 
lin officially_Adv = variants{} ; -- 
lin capability_N = variants{} ; -- 
lin worry_N = variants{} ; -- 
lin liberation_N = variants{} ; -- 
lin hunt_V2 = prepV2 (kaccac_KCC_2_8571_V) ghalP ;
lin hunt_V = variants{}; -- prepV2 (kaccac_KCC_2_8571_V) ghalP ;
lin daily_Adv = variants{} ; -- 
lin heel_N = variants{} ; -- 
lin contract_V2V = variants{} ; -- 
lin contract_V2 = variants{} ; -- 
lin contract_V = variants{} ; -- 
lin update_V2 = variants{} ; -- 
lin assign_V2V = variants{} ; -- 
lin assign_V2 = variants{} ; -- 
lin spring_V2 = variants{} ; -- 
lin spring_V = variants{} ; -- 
lin single_N = variants{} ; -- 
lin commons_N = variants{} ; -- 
lin weekly_A = variants{} ; -- 
lin stretch_N = variants{} ; -- 
lin pregnancy_N = variants{} ; -- 
lin happily_Adv = variants{} ; -- 
lin spectrum_N = variants{} ; -- 
lin interfere_V = variants{} ; -- 
lin suicide_N = variants{} ; -- 
lin panic_N = variants{} ; -- 
lin invent_V2 = variants{} ; -- 
lin invent_V = variants{} ; -- 
lin intensive_A = variants{} ; -- 
lin damp_A = variants{} ; -- 
lin simultaneously_Adv = variants{} ; -- 
lin giant_N = variants{} ; -- 
lin casual_A = variants{} ; -- 
lin sphere_N = variants{} ; -- 
lin precious_A = variants{} ; -- 
lin sword_N = variants{} ; -- 
lin envisage_V2 = variants{} ; -- 
lin bean_N = variants{} ; -- 
lin time_V2 = variants{} ; -- 
lin crazy_A = variants{} ; -- 
lin changing_A = variants{} ; -- 
lin primary_N = variants{} ; -- 
lin concede_VS = variants{} ; -- 
lin concede_V2 = variants{} ; -- 
lin concede_V = variants{} ; -- 
lin besides_Adv = variants{} ; -- 
lin unite_V2 = variants{} ; -- 
lin unite_V = variants{} ; -- 
lin severely_Adv = variants{} ; -- 
lin separately_Adv = variants{} ; -- 
lin instruct_V2 = variants{} ; -- 
lin insert_V2 = variants{} ; -- 
lin go_N = variants{} ; -- 
lin exhibit_V2 = variants{} ; -- 
lin brave_A = variants{} ; -- 
lin tutor_N = variants{} ; -- 
lin tune_N = variants{} ; -- 
lin debut_N = variants{} ; -- 
lin debut_2_N = variants{} ; -- 
lin debut_1_N = variants{} ; -- 
lin continued_A = variants{} ; -- 
lin bid_V2 = variants{} ; -- 
lin bid_V = variants{} ; -- 
lin incidence_N = variants{} ; -- 
lin downstairs_Adv = variants{} ; -- 
lin cafe_N = variants{} ; -- 
lin regret_VS = variants{} ; -- 
lin regret_V2 = variants{} ; -- 
lin killer_N = variants{} ; -- 
lin delicate_A = variants{} ; -- 
lin subsidiary_N = variants{} ; -- 
lin gender_N = variants{} ; -- 
lin entertain_V2 = variants{} ; -- 
lin cling_V = variants{} ; -- 
lin vertical_A = variants{} ; -- 
lin fetch_V2 = variants{} ; -- 
lin strip_V2 = variants{} ; -- 
lin strip_V = variants{} ; -- 
lin plead_VS = variants{} ; -- 
lin plead_V2 = variants{} ; -- 
lin plead_V = variants{} ; -- 
lin duck_N = variants{} ; -- 
lin breed_N = variants{} ; -- 
lin assistant_A = variants{} ; -- 
lin pint_N = variants{} ; -- 
lin abolish_V2 = variants{} ; -- 
lin translation_N = variants{} ; -- 
lin princess_N = variants{} ; -- 
lin line_V2 = variants{} ; -- 
lin line_V = variants{} ; -- 
lin excessive_A = variants{} ; -- 
lin digital_A = variants{} ; -- 
lin steep_A = variants{} ; -- 
lin jet_N = variants{} ; -- 
lin hey_Interj = variants{} ; -- 
lin grave_N = variants{} ; -- 
lin exceptional_A = variants{} ; -- 
lin boost_V2 = variants{} ; -- 
lin random_A = variants{} ; -- 
lin correlation_N = variants{} ; -- 
lin outline_N = variants{} ; -- 
lin intervene_V2V = variants{} ; -- 
lin intervene_V = variants{} ; -- 
lin packet_N = variants{} ; -- 
lin motivation_N = variants{} ; -- 
lin safely_Adv = variants{} ; -- 
lin harsh_A = variants{} ; -- 
lin spell_N = variants{} ; -- 
lin spread_N = variants{} ; -- 
lin draw_N = variants{} ; -- 
lin concrete_A = variants{} ; -- 
lin complicated_A = variants{} ; -- 
lin alleged_A = variants{} ; -- 
lin redundancy_N = variants{} ; -- 
lin progressive_A = variants{} ; -- 
lin intensity_N = variants{} ; -- 
lin crack_N = variants{} ; -- 
lin fly_N = variants{} ; -- 
lin fancy_V2 = variants{} ; -- 
lin alternatively_Adv = variants{} ; -- 
lin waiting_A = variants{} ; -- 
lin scandal_N = variants{} ; -- 
lin resemble_V2 = variants{} ; -- 
lin parameter_N = variants{} ; -- 
lin fierce_A = variants{} ; -- 
lin tropical_A = variants{} ; -- 
lin colour_V2A = variants{} ; -- 
lin colour_V2 = variants{} ; -- 
lin colour_V = variants{} ; -- 
lin engagement_N = variants{} ; -- 
lin contest_N = variants{} ; -- 
lin edit_V2 = variants{} ; -- 
lin courage_N = variants{} ; -- 
lin hip_N = variants{} ; -- 
lin delighted_A = variants{} ; -- 
lin sponsor_V2 = variants{} ; -- 
lin carer_N = variants{} ; -- 
lin crack_V2 = variants{} ; -- 
lin substantially_Adv = variants{} ; -- 
lin occupational_A = variants{} ; -- 
lin trainer_N = variants{} ; -- 
lin remainder_N = variants{} ; -- 
lin related_A = variants{} ; -- 
lin inherit_V2 = variants{} ; -- 
lin inherit_V = variants{} ; -- 
lin resume_V2 = variants{} ; -- 
lin resume_V = variants{} ; -- 
lin assignment_N = variants{} ; -- 
lin conceal_V2 = variants{} ; -- 
lin disclose_VS = variants{} ; -- 
lin disclose_V2 = variants{} ; -- 
lin disclose_V = variants{} ; -- 
lin exclusively_Adv = variants{} ; -- 
lin working_N = variants{} ; -- 
lin mild_A = variants{} ; -- 
lin chronic_A = variants{} ; -- 
lin splendid_A = variants{} ; -- 
lin function_V = variants{} ; -- 
lin riderMasc_N = variants{} ; -- 
lin clay_N = variants{} ; -- 
lin firstly_Adv = variants{} ; -- 
lin conceive_V2 = variants{} ; -- 
lin conceive_V = variants{} ; -- 
lin politically_Adv = variants{} ; -- 
lin terminal_N = variants{} ; -- 
lin accuracy_N = variants{} ; -- 
lin coup_N = variants{} ; -- 
lin ambulance_N = variants{} ; -- 
lin living_N = variants{} ; -- 
lin offenderMasc_N = variants{} ; -- 
lin similarity_N = variants{} ; -- 
lin orchestra_N = variants{} ; -- 
lin brush_N = variants{} ; -- 
lin systematic_A = variants{} ; -- 
lin striker_N = variants{} ; -- 
lin guard_V2 = variants{} ; -- 
lin guard_V = variants{} ; -- 
lin casualty_N = variants{} ; -- 
lin steadily_Adv = variants{} ; -- 
lin painter_N = variants{} ; -- 
lin opt_VV = variants{} ; -- 
lin opt_V = variants{} ; -- 
lin handsome_A = variants{} ; -- 
lin banking_N = variants{} ; -- 
lin sensitivity_N = variants{} ; -- 
lin navy_N = variants{} ; -- 
lin fascinating_A = variants{} ; -- 
lin disappointment_N = variants{} ; -- 
lin auditor_N = variants{} ; -- 
lin hostility_N = variants{} ; -- 
lin spending_N = variants{} ; -- 
lin scarcely_Adv = variants{} ; -- 
lin compulsory_A = variants{} ; -- 
lin photographer_N = variants{} ; -- 
lin ok_Interj = variants{} ; -- 
lin neighbourhood_N = variants{} ; -- 
lin ideological_A = variants{} ; -- 
lin wide_Adv = variants{} ; -- 
lin pardon_N = variants{} ; -- 
lin double_N = variants{} ; -- 
lin criticize_V2 = variants{} ; -- 
lin criticize_V = variants{} ; -- 
lin supervision_N = variants{} ; -- 
lin guilt_N = variants{} ; -- 
lin deck_N = variants{} ; -- 
lin payable_A = variants{} ; -- 
lin execution_N = variants{} ; -- 
lin suite_N = variants{} ; -- 
lin elected_A = variants{} ; -- 
lin solely_Adv = variants{} ; -- 
lin moral_N = variants{} ; -- 
lin collector_N = variants{} ; -- 
lin questionnaire_N = variants{} ; -- 
lin flavour_N = variants{} ; -- 
lin couple_V2 = variants{} ; -- 
lin couple_V = variants{} ; -- 
lin faculty_N = variants{} ; -- 
lin tour_V2 = variants{} ; -- 
lin tour_V = variants{} ; -- 
lin basket_N = variants{} ; -- 
lin mention_N = variants{} ; -- 
lin kick_N = variants{} ; -- 
lin horizon_N = variants{} ; -- 
lin drain_V2 = variants{} ; -- 
lin drain_V = variants{} ; -- 
lin happiness_N = variants{} ; -- 
lin fighter_N = variants{} ; -- 
lin estimated_A = variants{} ; -- 
lin copper_N = variants{} ; -- 
lin legend_N = variants{} ; -- 
lin relevance_N = variants{} ; -- 
lin decorate_V2 = variants{} ; -- 
lin continental_A = variants{} ; -- 
lin ship_V2 = variants{} ; -- 
lin ship_V = variants{} ; -- 
lin operational_A = variants{} ; -- 
lin incur_V2 = variants{} ; -- 
lin parallel_A = variants{} ; -- 
lin divorce_N = variants{} ; -- 
lin opposed_A = variants{} ; -- 
lin equilibrium_N = variants{} ; -- 
lin trader_N = variants{} ; -- 
lin ton_N = variants{} ; -- 
lin can_N = variants{} ; -- 
lin juice_N = variants{} ; -- 
lin forum_N = variants{} ; -- 
lin spin_V2 = variants{} ; -- 
lin spin_V = variants{} ; -- 
lin research_V2 = variants{} ; -- 
lin research_V = variants{} ; -- 
lin hostile_A = variants{} ; -- 
lin consistently_Adv = variants{} ; -- 
lin technological_A = variants{} ; -- 
lin nightmare_N = variants{} ; -- 
lin medal_N = variants{} ; -- 
lin diamond_N = variants{} ; -- 
lin speed_V2 = variants{} ; -- 
lin speed_V = variants{} ; -- 
lin peaceful_A = variants{} ; -- 
lin accounting_A = variants{} ; -- 
lin scatter_V2 = variants{} ; -- 
lin scatter_V = variants{} ; -- 
lin monster_N = variants{} ; -- 
lin horrible_A = variants{} ; -- 
lin nonsense_N = variants{} ; -- 
lin chaos_N = variants{} ; -- 
lin accessible_A = variants{} ; -- 
lin humanity_N = variants{} ; -- 
lin frustration_N = variants{} ; -- 
lin chin_N = variants{} ; -- 
lin bureau_N = variants{} ; -- 
lin advocate_VS = variants{} ; -- 
lin advocate_V2 = variants{} ; -- 
lin polytechnic_N = variants{} ; -- 
lin inhabitant_N = variants{} ; -- 
lin evil_A = variants{} ; -- 
lin slave_N = variants{} ; -- 
lin reservation_N = variants{} ; -- 
lin slam_V2 = variants{} ; -- 
lin slam_V = variants{} ; -- 
lin handle_N = variants{} ; -- 
lin provincial_A = variants{} ; -- 
lin fishing_N = variants{} ; -- 
lin facilitate_V2 = variants{} ; -- 
lin yield_N = variants{} ; -- 
lin elbow_N = variants{} ; -- 
lin bye_Interj = variants{} ; -- 
lin warm_V2 = variants{} ; -- 
lin warm_V = variants{} ; -- 
lin sleeve_N = variants{} ; -- 
lin exploration_N = variants{} ; -- 
lin creep_V = variants{} ; -- 
lin adjacent_A = variants{} ; -- 
lin theft_N = variants{} ; -- 
lin round_V2 = variants{} ; -- 
lin round_V = variants{} ; -- 
lin grace_N = variants{} ; -- 
lin predecessor_N = variants{} ; -- 
lin supermarket_N = variants{} ; -- 
lin smart_A = variants{} ; -- 
lin sergeant_N = variants{} ; -- 
lin regulate_V2 = variants{} ; -- 
lin clash_N = variants{} ; -- 
lin assemble_V2 = variants{} ; -- 
lin assemble_V = variants{} ; -- 
lin arrow_N = variants{} ; -- 
lin nowadays_Adv = variants{} ; -- 
lin giant_A = variants{} ; -- 
lin waiting_N = variants{} ; -- 
lin tap_N = variants{} ; -- 
lin shit_N = variants{} ; -- 
lin sandwich_N = variants{} ; -- 
lin vanish_V = variants{} ; -- 
lin commerce_N = variants{} ; -- 
lin pursuit_N = variants{} ; -- 
lin post_war_A = variants{} ; -- 
lin will_V2 = variants{} ; -- 
lin will_V = variants{} ; -- 
lin waste_A = variants{} ; -- 
lin collar_N = variants{} ; -- 
lin socialism_N = variants{} ; -- 
lin skill_V = variants{} ; -- 
lin rice_N = variants{} ; -- 
lin exclusion_N = variants{} ; -- 
lin upwards_Adv = variants{} ; -- 
lin transmission_N = variants{} ; -- 
lin instantly_Adv = variants{} ; -- 
lin forthcoming_A = variants{} ; -- 
lin appointed_A = variants{} ; -- 
lin geographical_A = variants{} ; -- 
lin fist_N = variants{} ; -- 
lin abstract_A = variants{} ; -- 
lin embrace_V2 = variants{} ; -- 
lin embrace_V = variants{} ; -- 
lin dynamic_A = variants{} ; -- 
lin drawer_N = variants{} ; -- 
lin dismissal_N = variants{} ; -- 
lin magic_N = variants{} ; -- 
lin endless_A = variants{} ; -- 
lin definite_A = variants{} ; -- 
lin broadly_Adv = variants{} ; -- 
lin affection_N = variants{} ; -- 
lin dawn_N = variants{} ; -- 
lin principal_N = variants{} ; -- 
lin bloke_N = variants{} ; -- 
lin trap_N = variants{} ; -- 
lin communist_A = variants{} ; -- 
lin competence_N = variants{} ; -- 
lin complicate_V2 = variants{} ; -- 
lin neutral_A = variants{} ; -- 
lin fortunately_Adv = variants{} ; -- 
lin commonwealth_N = variants{} ; -- 
lin breakdown_N = variants{} ; -- 
lin combined_A = variants{} ; -- 
lin candle_N = variants{} ; -- 
lin venue_N = variants{} ; -- 
lin supper_N = variants{} ; -- 
lin analyst_N = variants{} ; -- 
lin vague_A = variants{} ; -- 
lin publicly_Adv = variants{} ; -- 
lin marine_A = variants{} ; -- 
lin fair_Adv = variants{} ; -- 
lin pause_N = variants{} ; -- 
lin notable_A = variants{} ; -- 
lin freely_Adv = variants{} ; -- 
lin counterpart_N = variants{} ; -- 
lin lively_A = variants{} ; -- 
lin script_N = variants{} ; -- 
lin sue_V2V = variants{} ; -- 
lin sue_V2 = variants{} ; -- 
lin sue_V = variants{} ; -- 
lin legitimate_A = variants{} ; -- 
lin geography_N = variants{} ; -- 
lin reproduce_V2 = variants{} ; -- 
lin reproduce_V = variants{} ; -- 
lin moving_A = variants{} ; -- 
lin lamb_N = variants{} ; -- 
lin gay_A = variants{} ; -- 
lin contemplate_VS = variants{} ; -- 
lin contemplate_V2 = variants{} ; -- 
lin contemplate_V = variants{} ; -- 
lin terror_N = variants{} ; -- 
lin stable_N = variants{} ; -- 
lin founder_N = variants{} ; -- 
lin utility_N = variants{} ; -- 
lin signal_VS = variants{} ; -- 
lin signal_V2 = variants{} ; -- 
lin shelter_N = variants{} ; -- 
lin poster_N = variants{} ; -- 
lin hitherto_Adv = variants{} ; -- 
lin mature_A = variants{} ; -- 
lin cooking_N = variants{} ; -- 
lin head_A = variants{} ; -- 
lin wealthy_A = variants{} ; -- 
lin fucking_A = variants{} ; -- 
lin confess_VS = variants{} ; -- 
lin confess_V2 = variants{} ; -- 
lin confess_V = variants{} ; -- 
lin age_V = variants{} ; -- 
lin miracle_N = variants{} ; -- 
lin magic_A = variants{} ; -- 
lin jaw_N = variants{} ; -- 
lin pan_N = variants{} ; -- 
lin coloured_A = variants{} ; -- 
lin tent_N = variants{} ; -- 
lin telephone_V2 = variants{} ; -- 
lin telephone_V = variants{} ; -- 
lin reduced_A = variants{} ; -- 
lin tumour_N = variants{} ; -- 
lin super_A = variants{} ; -- 
lin funding_N = variants{} ; -- 
lin dump_V2 = variants{} ; -- 
lin dump_V = variants{} ; -- 
lin stitch_N = variants{} ; -- 
lin shared_A = variants{} ; -- 
lin ladder_N = variants{} ; -- 
lin keeper_N = variants{} ; -- 
lin endorse_V2 = variants{} ; -- 
lin invariably_Adv = variants{} ; -- 
lin smash_V2 = variants{} ; -- 
lin smash_V = variants{} ; -- 
lin shield_N = variants{} ; -- 
lin heat_V2 = variants{} ; -- 
lin heat_V = variants{} ; -- 
lin surgeon_N = variants{} ; -- 
lin centre_V2 = variants{} ; -- 
lin centre_V = variants{} ; -- 
lin orange_N = variants{} ; -- 
lin orange_2_N = variants{} ; -- 
lin orange_1_N = variants{} ; -- 
lin explode_V = variants{} ; -- 
lin comedy_N = variants{} ; -- 
lin classify_V2 = variants{} ; -- 
lin artistic_A = variants{} ; -- 
lin ruler_N = variants{} ; -- 
lin biscuit_N = variants{} ; -- 
lin workstation_N = variants{} ; -- 
lin prey_N = variants{} ; -- 
lin manual_N = variants{} ; -- 
lin cure_N = variants{} ; -- 
lin cure_2_N = variants{} ; -- 
lin cure_1_N = variants{} ; -- 
lin overall_N = variants{} ; -- 
lin tighten_V2 = variants{} ; -- 
lin tighten_V = variants{} ; -- 
lin tax_V2 = variants{} ; -- 
lin pope_N = variants{} ; -- 
lin manufacturing_A = variants{} ; -- 
lin adult_A = variants{} ; -- 
lin rush_N = variants{} ; -- 
lin blanket_N = variants{} ; -- 
lin republican_N = variants{} ; -- 
lin referendum_N = variants{} ; -- 
lin palm_N = variants{} ; -- 
lin nearby_Adv = variants{} ; -- 
lin mix_N = variants{} ; -- 
lin devil_N = variants{} ; -- 
lin adoption_N = variants{} ; -- 
lin workforce_N = variants{} ; -- 
lin segment_N = variants{} ; -- 
lin regardless_Adv = variants{} ; -- 
lin contractor_N = variants{} ; -- 
lin portion_N = variants{} ; -- 
lin differently_Adv = variants{} ; -- 
lin deposit_V2 = variants{} ; -- 
lin cook_N = variants{} ; -- 
lin prediction_N = variants{} ; -- 
lin oven_N = variants{} ; -- 
lin matrix_N = variants{} ; -- 
lin liver_N = mkN "fwied" "ifdwa" ;
lin fraud_N = variants{} ; -- 
lin beam_N = variants{} ; -- 
lin signature_N = variants{} ; -- 
lin limb_N = variants{} ; -- 
lin verdict_N = variants{} ; -- 
lin dramatically_Adv = variants{} ; -- 
lin container_N = variants{} ; -- 
lin aunt_N = variants{} ; -- 
lin dock_N = variants{} ; -- 
lin submission_N = variants{} ; -- 
lin arm_V2 = variants{} ; -- 
lin arm_V = variants{} ; -- 
lin odd_N = variants{} ; -- 
lin certainty_N = variants{} ; -- 
lin boring_A = variants{} ; -- 
lin electron_N = variants{} ; -- 
lin drum_N = variants{} ; -- 
lin wisdom_N = variants{} ; -- 
lin antibody_N = variants{} ; -- 
lin unlike_A = variants{} ; -- 
lin terrorist_N = variants{} ; -- 
lin post_V2 = variants{} ; -- 
lin post_V = variants{} ; -- 
lin circulation_N = variants{} ; -- 
lin alteration_N = variants{} ; -- 
lin fluid_N = variants{} ; -- 
lin ambitious_A = variants{} ; -- 
lin socially_Adv = variants{} ; -- 
lin riot_N = variants{} ; -- 
lin petition_N = variants{} ; -- 
lin fox_N = variants{} ; -- 
lin recruitment_N = variants{} ; -- 
lin well_known_A = variants{} ; -- 
lin top_V2 = variants{} ; -- 
lin service_V2 = variants{} ; -- 
lin flood_V2 = variants{} ; -- 
lin flood_V = variants{} ; -- 
lin taste_V2 = variants{} ; -- 
lin taste_V = variants{} ; -- 
lin memorial_N = variants{} ; -- 
lin helicopter_N = variants{} ; -- 
lin correspondence_N = variants{} ; -- 
lin beef_N = variants{} ; -- 
lin overall_Adv = variants{} ; -- 
lin lighting_N = variants{} ; -- 
lin harbour_N = mkN "port" "portijiet" ;
lin empirical_A = variants{} ; -- 
lin shallow_A = variants{} ; -- 
lin seal_V2 = variants{} ; -- 
lin seal_V = variants{} ; -- 
lin decrease_V2 = variants{} ; -- 
lin decrease_V = variants{} ; -- 
lin constituent_N = variants{} ; -- 
lin exam_N = variants{} ; -- 
lin toe_N = variants{} ; -- 
lin reward_V2 = variants{} ; -- 
lin thrust_V2 = variants{} ; -- 
lin thrust_V = variants{} ; -- 
lin bureaucracy_N = variants{} ; -- 
lin wrist_N = variants{} ; -- 
lin nut_N = variants{} ; -- 
lin plain_N = variants{} ; -- 
lin magnetic_A = variants{} ; -- 
lin evil_N = variants{} ; -- 
lin widen_V2 = variants{} ; -- 
lin hazard_N = variants{} ; -- 
lin dispose_V2 = variants{} ; -- 
lin dispose_V = variants{} ; -- 
lin dealing_N = variants{} ; -- 
lin absent_A = variants{} ; -- 
lin reassure_V2S = variants{} ; -- 
lin reassure_V2 = variants{} ; -- 
lin model_V2 = variants{} ; -- 
lin model_V = variants{} ; -- 
lin inn_N = variants{} ; -- 
lin initial_N = variants{} ; -- 
lin suspension_N = variants{} ; -- 
lin respondent_N = variants{} ; -- 
lin over_N = variants{} ; -- 
lin naval_A = variants{} ; -- 
lin monthly_A = variants{} ; -- 
lin log_N = variants{} ; -- 
lin advisory_A = variants{} ; -- 
lin fitness_N = variants{} ; -- 
lin blank_A = variants{} ; -- 
lin indirect_A = variants{} ; -- 
lin tile_N = variants{} ; -- 
lin rally_N = variants{} ; -- 
lin economist_N = variants{} ; -- 
lin vein_N = variants{} ; -- 
lin strand_N = variants{} ; -- 
lin disturbance_N = variants{} ; -- 
lin stuff_V2 = variants{} ; -- 
lin seldom_Adv = variants{} ; -- 
lin coming_A = variants{} ; -- 
lin cab_N = variants{} ; -- 
lin grandfather_N = variants{} ; -- 
lin flash_V = variants{} ; -- 
lin destination_N = variants{} ; -- 
lin actively_Adv = variants{} ; -- 
lin regiment_N = variants{} ; -- 
lin closed_A = variants{} ; -- 
lin boom_N = variants{} ; -- 
lin handful_N = variants{} ; -- 
lin remarkably_Adv = variants{} ; -- 
lin encouragement_N = variants{} ; -- 
lin awkward_A = variants{} ; -- 
lin required_A = variants{} ; -- 
lin flood_N = variants{} ; -- 
lin defect_N = variants{} ; -- 
lin surplus_N = variants{} ; -- 
lin champagne_N = variants{} ; -- 
lin liquid_N = variants{} ; -- 
lin shed_V2 = variants{} ; -- 
lin welcome_N = variants{} ; -- 
lin rejection_N = variants{} ; -- 
lin discipline_V2 = variants{} ; -- 
lin halt_V2 = variants{} ; -- 
lin halt_V = variants{} ; -- 
lin electronics_N = variants{} ; -- 
lin administratorMasc_N = variants{} ; -- 
lin sentence_V2 = variants{} ; -- 
lin sentence_V = variants{} ; -- 
lin ill_Adv = variants{} ; -- 
lin contradiction_N = variants{} ; -- 
lin nail_N = variants{} ; -- 
lin senior_N = variants{} ; -- 
lin lacking_A = variants{} ; -- 
lin colonial_A = variants{} ; -- 
lin primitive_A = variants{} ; -- 
lin whoever_NP = variants{} ; -- 
lin lap_N = variants{} ; -- 
lin commodity_N = variants{} ; -- 
lin planned_A = variants{} ; -- 
lin intellectual_N = variants{} ; -- 
lin imprisonment_N = variants{} ; -- 
lin coincide_V = variants{} ; -- 
lin sympathetic_A = variants{} ; -- 
lin atom_N = variants{} ; -- 
lin tempt_V2V = variants{} ; -- 
lin tempt_V2 = variants{} ; -- 
lin sanction_N = variants{} ; -- 
lin praise_V2 = variants{} ; -- 
lin favourable_A = variants{} ; -- 
lin dissolve_V2 = variants{} ; -- 
lin dissolve_V = variants{} ; -- 
lin tightly_Adv = variants{} ; -- 
lin surrounding_N = variants{} ; -- 
lin soup_N = variants{} ; -- 
lin encounter_N = variants{} ; -- 
lin abortion_N = variants{} ; -- 
lin grasp_V2 = variants{} ; -- 
lin grasp_V = variants{} ; -- 
lin custody_N = variants{} ; -- 
lin composer_N = variants{} ; -- 
lin charm_N = variants{} ; -- 
lin short_term_A = variants{} ; -- 
lin metropolitan_A = variants{} ; -- 
lin waist_N = variants{} ; -- 
lin equality_N = variants{} ; -- 
lin tribute_N = variants{} ; -- 
lin bearing_N = variants{} ; -- 
lin auction_N = variants{} ; -- 
lin standing_N = variants{} ; -- 
lin manufacture_N = variants{} ; -- 
lin horn_N = mkN "ħorn" "ħornijiet" ;
lin barn_N = variants{} ; -- 
lin mayor_N = variants{} ; -- 
lin emperor_N = variants{} ; -- 
lin rescue_N = variants{} ; -- 
lin integrated_A = variants{} ; -- 
lin conscience_N = variants{} ; -- 
lin commence_V2 = variants{} ; -- 
lin commence_V = variants{} ; -- 
lin grandmother_N = variants{} ; -- 
lin discharge_V2 = variants{} ; -- 
lin discharge_V = variants{} ; -- 
lin profound_A = variants{} ; -- 
lin takeover_N = variants{} ; -- 
lin nationalist_N = variants{} ; -- 
lin effect_V2 = variants{} ; -- 
lin dolphin_N = variants{} ; -- 
lin fortnight_N = variants{} ; -- 
lin elephant_N = variants{} ; -- 
lin seal_N = variants{} ; -- 
lin spoil_V2 = variants{} ; -- 
lin spoil_V = variants{} ; -- 
lin plea_N = variants{} ; -- 
lin forwards_Adv = variants{} ; -- 
lin breeze_N = variants{} ; -- 
lin prevention_N = variants{} ; -- 
lin mineral_N = variants{} ; -- 
lin runner_N = variants{} ; -- 
lin pin_V2 = variants{} ; -- 
lin integrity_N = variants{} ; -- 
lin thereafter_Adv = variants{} ; -- 
lin quid_N = variants{} ; -- 
lin owl_N = variants{} ; -- 
lin rigid_A = variants{} ; -- 
lin orange_A = variants{} ; -- 
lin draft_V2 = variants{} ; -- 
lin reportedly_Adv = variants{} ; -- 
lin hedge_N = variants{} ; -- 
lin formulate_V2 = variants{} ; -- 
lin associated_A = variants{} ; -- 
lin position_V2 = variants{} ; -- 
lin thief_N = variants{} ; -- 
lin tomato_N = variants{} ; -- 
lin exhaust_V2 = variants{} ; -- 
lin evidently_Adv = variants{} ; -- 
lin eagle_N = variants{} ; -- 
lin specified_A = variants{} ; -- 
lin resulting_A = variants{} ; -- 
lin blade_N = variants{} ; -- 
lin peculiar_A = variants{} ; -- 
lin killing_N = variants{} ; -- 
lin desktop_N = variants{} ; -- 
lin bowel_N = variants{} ; -- 
lin long_V = variants{} ; -- 
lin ugly_A = mkA "ikrah" "kerha" "koroh" ;
lin expedition_N = variants{} ; -- 
lin saint_N = variants{} ; -- 
lin variable_A = variants{} ; -- 
lin supplement_V2 = variants{} ; -- 
lin stamp_N = variants{} ; -- 
lin slide_N = variants{} ; -- 
lin faction_N = variants{} ; -- 
lin enthusiastic_A = variants{} ; -- 
lin enquire_V2 = variants{} ; -- 
lin enquire_V = variants{} ; -- 
lin brass_N = variants{} ; -- 
lin inequality_N = variants{} ; -- 
lin eager_A = variants{} ; -- 
lin bold_A = variants{} ; -- 
lin neglect_V2 = variants{} ; -- 
lin saying_N = variants{} ; -- 
lin ridge_N = variants{} ; -- 
lin earl_N = variants{} ; -- 
lin yacht_N = variants{} ; -- 
lin suck_V2 = lilV2 (rada'_RDGH_1_9388_V) ;
lin suck_V = variants{}; -- lilV2 (rada'_RDGH_1_9388_V) ;
lin missing_A = variants{} ; -- 
lin extended_A = variants{} ; -- 
lin valuation_N = variants{} ; -- 
lin delight_V2 = variants{} ; -- 
lin delight_V = variants{} ; -- 
lin beat_N = variants{} ; -- 
lin worship_N = variants{} ; -- 
lin fossil_N = variants{} ; -- 
lin diminish_V2 = variants{} ; -- 
lin diminish_V = variants{} ; -- 
lin taxpayer_N = variants{} ; -- 
lin corruption_N = variants{} ; -- 
lin accurately_Adv = variants{} ; -- 
lin honour_V2 = variants{} ; -- 
lin depict_V2 = variants{} ; -- 
lin pencil_N = variants{} ; -- 
lin drown_V2 = variants{} ; -- 
lin drown_V = variants{} ; -- 
lin stem_N = variants{} ; -- 
lin lump_N = variants{} ; -- 
lin applicable_A = variants{} ; -- 
lin rate_V2 = variants{} ; -- 
lin rate_V = variants{} ; -- 
lin mobility_N = variants{} ; -- 
lin immense_A = variants{} ; -- 
lin goodness_N = variants{} ; -- 
lin price_V2V = variants{} ; -- 
lin price_V2 = variants{} ; -- 
lin price_V = variants{} ; -- 
lin preliminary_A = variants{} ; -- 
lin graph_N = variants{} ; -- 
lin referee_N = variants{} ; -- 
lin calm_A = variants{} ; -- 
lin onwards_Adv = variants{} ; -- 
lin omit_V2 = variants{} ; -- 
lin genuinely_Adv = variants{} ; -- 
lin excite_V2 = variants{} ; -- 
lin dreadful_A = variants{} ; -- 
lin cave_N = variants{} ; -- 
lin revelation_N = variants{} ; -- 
lin grief_N = variants{} ; -- 
lin erect_V2 = variants{} ; -- 
lin tuck_V2 = variants{} ; -- 
lin tuck_V = variants{} ; -- 
lin meantime_N = variants{} ; -- 
lin barrel_N = variants{} ; -- 
lin lawn_N = variants{} ; -- 
lin hut_N = variants{} ; -- 
lin swing_N = variants{} ; -- 
lin subject_V2 = variants{} ; -- 
lin ruin_V2 = variants{} ; -- 
lin slice_N = variants{} ; -- 
lin transmit_V2 = variants{} ; -- 
lin thigh_N = variants{} ; -- 
lin practically_Adv = variants{} ; -- 
lin dedicate_V2 = variants{} ; -- 
lin mistake_V2 = variants{} ; -- 
lin mistake_V = variants{} ; -- 
lin corresponding_A = variants{} ; -- 
lin albeit_Subj = variants{} ; -- 
lin sound_A = variants{} ; -- 
lin nurse_V2 = variants{} ; -- 
lin discharge_N = variants{} ; -- 
lin comparative_A = variants{} ; -- 
lin cluster_N = variants{} ; -- 
lin propose_VV = variants{} ; -- 
lin propose_VS = variants{} ; -- 
lin propose_V2 = variants{} ; -- 
lin propose_V = variants{} ; -- 
lin obstacle_N = variants{} ; -- 
lin motorway_N = variants{} ; -- 
lin heritage_N = variants{} ; -- 
lin counselling_N = variants{} ; -- 
lin breeding_N = variants{} ; -- 
lin characteristic_A = variants{} ; -- 
lin bucket_N = variants{} ; -- 
lin migration_N = variants{} ; -- 
lin campaign_V = variants{} ; -- 
lin ritual_N = variants{} ; -- 
lin originate_V2 = variants{} ; -- 
lin originate_V = variants{} ; -- 
lin hunting_N = variants{} ; -- 
lin crude_A = variants{} ; -- 
lin protocol_N = variants{} ; -- 
lin prejudice_N = variants{} ; -- 
lin inspiration_N = variants{} ; -- 
lin dioxide_N = variants{} ; -- 
lin chemical_A = variants{} ; -- 
lin uncomfortable_A = variants{} ; -- 
lin worthy_A = variants{} ; -- 
lin inspect_V2 = variants{} ; -- 
lin summon_V2 = variants{} ; -- 
lin parallel_N = variants{} ; -- 
lin outlet_N = variants{} ; -- 
lin okay_A = variants{} ; -- 
lin collaboration_N = variants{} ; -- 
lin booking_N = variants{} ; -- 
lin salad_N = variants{} ; -- 
lin productive_A = variants{} ; -- 
lin charming_A = variants{} ; -- 
lin polish_A = variants{} ; -- 
lin oak_N = variants{} ; -- 
lin access_V2 = variants{} ; -- 
lin tourism_N = variants{} ; -- 
lin independently_Adv = variants{} ; -- 
lin cruel_A = variants{} ; -- 
lin diversity_N = variants{} ; -- 
lin accused_A = variants{} ; -- 
lin supplement_N = variants{} ; -- 
lin fucking_Adv = variants{} ; -- 
lin forecast_N = variants{} ; -- 
lin amend_V2V = variants{} ; -- 
lin amend_V2 = variants{} ; -- 
lin amend_V = variants{} ; -- 
lin soap_N = variants{} ; -- 
lin ruling_N = variants{} ; -- 
lin interference_N = variants{} ; -- 
lin executive_A = variants{} ; -- 
lin mining_N = variants{} ; -- 
lin minimal_A = variants{} ; -- 
lin clarify_V2 = variants{} ; -- 
lin clarify_V = variants{} ; -- 
lin strain_V2 = variants{} ; -- 
lin novel_A = variants{} ; -- 
lin try_N = variants{} ; -- 
lin coastal_A = variants{} ; -- 
lin rising_A = variants{} ; -- 
lin quota_N = variants{} ; -- 
lin minus_Prep = variants{} ; -- 
lin kilometre_N = variants{} ; -- 
lin characterize_V2 = variants{} ; -- 
lin suspicious_A = variants{} ; -- 
lin pet_N = variants{} ; -- 
lin beneficial_A = variants{} ; -- 
lin fling_V2 = variants{} ; -- 
lin fling_V = variants{} ; -- 
lin deprive_V2 = variants{} ; -- 
lin covenant_N = variants{} ; -- 
lin bias_N = variants{} ; -- 
lin trophy_N = variants{} ; -- 
lin verb_N = variants{} ; -- 
lin honestly_Adv = variants{} ; -- 
lin extract_N = variants{} ; -- 
lin straw_N = variants{} ; -- 
lin stem_V2 = variants{} ; -- 
lin stem_V = variants{} ; -- 
lin eyebrow_N = variants{} ; -- 
lin noble_A = variants{} ; -- 
lin mask_N = variants{} ; -- 
lin lecturer_N = variants{} ; -- 
lin girlfriend_N = variants{} ; -- 
lin forehead_N = variants{} ; -- 
lin timetable_N = variants{} ; -- 
lin symbolic_A = variants{} ; -- 
lin farming_N = variants{} ; -- 
lin lid_N = variants{} ; -- 
lin librarian_N = variants{} ; -- 
lin injection_N = variants{} ; -- 
lin sexuality_N = variants{} ; -- 
lin irrelevant_A = variants{} ; -- 
lin bonus_N = variants{} ; -- 
lin abuse_V2 = variants{} ; -- 
lin thumb_N = variants{} ; -- 
lin survey_V2 = variants{} ; -- 
lin ankle_N = variants{} ; -- 
lin psychologist_N = variants{} ; -- 
lin occurrence_N = variants{} ; -- 
lin profitable_A = variants{} ; -- 
lin deliberate_A = variants{} ; -- 
lin bow_V2 = variants{} ; -- 
lin bow_V = variants{} ; -- 
lin tribe_N = variants{} ; -- 
lin rightly_Adv = variants{} ; -- 
lin representative_A = variants{} ; -- 
lin code_V2 = variants{} ; -- 
lin validity_N = variants{} ; -- 
lin marble_N = variants{} ; -- 
lin bow_N = variants{} ; -- 
lin plunge_V2 = variants{} ; -- 
lin plunge_V = variants{} ; -- 
lin maturity_N = variants{} ; -- 
lin maturity_3_N = variants{} ; -- 
lin maturity_2_N = variants{} ; -- 
lin maturity_1_N = variants{} ; -- 
lin hidden_A = variants{} ; -- 
lin contrast_V2 = variants{} ; -- 
lin contrast_V = variants{} ; -- 
lin tobacco_N = variants{} ; -- 
lin middle_class_A = variants{} ; -- 
lin grip_V2 = variants{} ; -- 
lin clergy_N = variants{} ; -- 
lin trading_A = variants{} ; -- 
lin passive_A = variants{} ; -- 
lin decoration_N = variants{} ; -- 
lin racial_A = variants{} ; -- 
lin well_N = variants{} ; -- 
lin embarrassment_N = variants{} ; -- 
lin sauce_N = variants{} ; -- 
lin fatal_A = variants{} ; -- 
lin banker_N = variants{} ; -- 
lin compensate_V2 = variants{} ; -- 
lin compensate_V = variants{} ; -- 
lin make_up_N = variants{} ; -- 
lin popularity_N = variants{} ; -- 
lin interior_A = variants{} ; -- 
lin eligible_A = variants{} ; -- 
lin continuity_N = variants{} ; -- 
lin bunch_N = variants{} ; -- 
lin hook_N = variants{} ; -- 
lin wicket_N = variants{} ; -- 
lin pronounce_V2 = variants{} ; -- 
lin pronounce_V = variants{} ; -- 
lin ballet_N = variants{} ; -- 
lin heir_N = variants{} ; -- 
lin positively_Adv = variants{} ; -- 
lin insufficient_A = variants{} ; -- 
lin substitute_V2 = variants{} ; -- 
lin substitute_V = variants{} ; -- 
lin mysterious_A = variants{} ; -- 
lin dancer_N = variants{} ; -- 
lin trail_N = variants{} ; -- 
lin caution_N = variants{} ; -- 
lin donation_N = variants{} ; -- 
lin added_A = variants{} ; -- 
lin weaken_V2 = variants{} ; -- 
lin weaken_V = variants{} ; -- 
lin tyre_N = variants{} ; -- 
lin sufferer_N = variants{} ; -- 
lin managerial_A = variants{} ; -- 
lin elaborate_A = variants{} ; -- 
lin restraint_N = variants{} ; -- 
lin renew_V2 = variants{} ; -- 
lin gardenerMasc_N = variants{} ; -- 
lin dilemma_N = variants{} ; -- 
lin configuration_N = variants{} ; -- 
lin rear_A = variants{} ; -- 
lin embark_V2 = variants{} ; -- 
lin embark_V = variants{} ; -- 
lin misery_N = variants{} ; -- 
lin importantly_Adv = variants{} ; -- 
lin continually_Adv = variants{} ; -- 
lin appreciation_N = variants{} ; -- 
lin radical_N = variants{} ; -- 
lin diverse_A = variants{} ; -- 
lin revive_V2 = variants{} ; -- 
lin revive_V = variants{} ; -- 
lin trip_V = variants{} ; -- 
lin lounge_N = variants{} ; -- 
lin dwelling_N = variants{} ; -- 
lin parental_A = variants{} ; -- 
lin loyal_A = variants{} ; -- 
lin privatisation_N = variants{} ; -- 
lin outsider_N = variants{} ; -- 
lin forbid_V2 = variants{} ; -- 
lin yep_Interj = variants{} ; -- 
lin prospective_A = variants{} ; -- 
lin manuscript_N = variants{} ; -- 
lin inherent_A = variants{} ; -- 
lin deem_V2V = variants{} ; -- 
lin deem_V2A = variants{} ; -- 
lin deem_V2 = variants{} ; -- 
lin telecommunication_N = variants{} ; -- 
lin intermediate_A = variants{} ; -- 
lin worthwhile_A = variants{} ; -- 
lin calendar_N = variants{} ; -- 
lin basin_N = variants{} ; -- 
lin utterly_Adv = variants{} ; -- 
lin rebuild_V2 = variants{} ; -- 
lin pulse_N = variants{} ; -- 
lin suppress_V2 = variants{} ; -- 
lin predator_N = variants{} ; -- 
lin width_N = variants{} ; -- 
lin stiff_A = variants{} ; -- 
lin spine_N = variants{} ; -- 
lin betray_V2 = variants{} ; -- 
lin punish_V2 = variants{} ; -- 
lin stall_N = variants{} ; -- 
lin lifestyle_N = variants{} ; -- 
lin compile_V2 = variants{} ; -- 
lin arouse_V2V = variants{} ; -- 
lin arouse_V2 = variants{} ; -- 
lin partially_Adv = variants{} ; -- 
lin headline_N = variants{} ; -- 
lin divine_A = variants{} ; -- 
lin unpleasant_A = variants{} ; -- 
lin sacred_A = variants{} ; -- 
lin useless_A = variants{} ; -- 
lin cool_V2 = variants{} ; -- 
lin cool_V = variants{} ; -- 
lin tremble_V = variants{} ; -- 
lin statue_N = variants{} ; -- 
lin obey_V2 = variants{} ; -- 
lin obey_V = variants{} ; -- 
lin drunk_A = variants{} ; -- 
lin tender_A = variants{} ; -- 
lin molecular_A = variants{} ; -- 
lin circulate_V2 = variants{} ; -- 
lin circulate_V = variants{} ; -- 
lin exploitation_N = variants{} ; -- 
lin explicitly_Adv = variants{} ; -- 
lin utterance_N = variants{} ; -- 
lin linear_A = variants{} ; -- 
lin chat_V = variants{} ; -- 
lin revision_N = variants{} ; -- 
lin distress_N = variants{} ; -- 
lin spill_V2 = variants{} ; -- 
lin spill_V = variants{} ; -- 
lin steward_N = variants{} ; -- 
lin knight_N = variants{} ; -- 
lin sum_V2 = variants{} ; -- 
lin sum_V = variants{} ; -- 
lin semantic_A = variants{} ; -- 
lin selective_A = variants{} ; -- 
lin learner_N = variants{} ; -- 
lin dignity_N = variants{} ; -- 
lin senate_N = variants{} ; -- 
lin grid_N = variants{} ; -- 
lin fiscal_A = variants{} ; -- 
lin activate_V2 = variants{} ; -- 
lin rival_A = variants{} ; -- 
lin fortunate_A = variants{} ; -- 
lin jeans_N = variants{} ; -- 
lin select_A = variants{} ; -- 
lin fitting_N = variants{} ; -- 
lin commentator_N = variants{} ; -- 
lin weep_V2 = variants{} ; -- 
lin weep_V = variants{} ; -- 
lin handicap_N = variants{} ; -- 
lin crush_V2 = variants{} ; -- 
lin crush_V = variants{} ; -- 
lin towel_N = variants{} ; -- 
lin stay_N = variants{} ; -- 
lin skilled_A = variants{} ; -- 
lin repeatedly_Adv = variants{} ; -- 
lin defensive_A = variants{} ; -- 
lin calm_V2 = variants{} ; -- 
lin calm_V = variants{} ; -- 
lin temporarily_Adv = variants{} ; -- 
lin rain_V2 = variants{} ; -- 
lin rain_V = variants{} ; -- 
lin pin_N = variants{} ; -- 
lin villa_N = variants{} ; -- 
lin rod_N = variants{} ; -- 
lin frontier_N = variants{} ; -- 
lin enforcement_N = variants{} ; -- 
lin protective_A = variants{} ; -- 
lin philosophical_A = variants{} ; -- 
lin lordship_N = variants{} ; -- 
lin disagree_VS = variants{} ; -- 
lin disagree_V2 = variants{} ; -- 
lin disagree_V = variants{} ; -- 
lin boyfriend_N = variants{} ; -- 
lin activistMasc_N = variants{} ; -- 
lin viewer_N = variants{} ; -- 
lin slim_A = variants{} ; -- 
lin textile_N = variants{} ; -- 
lin mist_N = variants{} ; -- 
lin harmony_N = variants{} ; -- 
lin deed_N = variants{} ; -- 
lin merge_V2 = variants{} ; -- 
lin merge_V = variants{} ; -- 
lin invention_N = variants{} ; -- 
lin commissioner_N = variants{} ; -- 
lin caravan_N = variants{} ; -- 
lin bolt_N = variants{} ; -- 
lin ending_N = variants{} ; -- 
lin publishing_N = variants{} ; -- 
lin gut_N = variants{} ; -- 
lin stamp_V2 = variants{} ; -- 
lin stamp_V = variants{} ; -- 
lin map_V2 = variants{} ; -- 
lin loud_Adv = variants{} ; -- 
lin stroke_V2 = variants{} ; -- 
lin shock_V2 = variants{} ; -- 
lin rug_N = variants{} ; -- 
lin picture_V2 = variants{} ; -- 
lin slip_N = variants{} ; -- 
lin praise_N = variants{} ; -- 
lin fine_N = variants{} ; -- 
lin monument_N = variants{} ; -- 
lin material_A = variants{} ; -- 
lin garment_N = variants{} ; -- 
lin toward_Prep = variants{} ; -- 
lin realm_N = variants{} ; -- 
lin melt_V2 = variants{} ; -- 
lin melt_V = variants{} ; -- 
lin reproduction_N = variants{} ; -- 
lin reactor_N = variants{} ; -- 
lin furious_A = variants{} ; -- 
lin distinguished_A = variants{} ; -- 
lin characterize_V2 = variants{} ; -- 
lin alike_Adv = variants{} ; -- 
lin pump_N = variants{} ; -- 
lin probe_N = variants{} ; -- 
lin feedback_N = variants{} ; -- 
lin aspiration_N = variants{} ; -- 
lin suspect_N = variants{} ; -- 
lin solar_A = variants{} ; -- 
lin fare_N = variants{} ; -- 
lin carve_V2 = variants{} ; -- 
lin carve_V = variants{} ; -- 
lin qualified_A = variants{} ; -- 
lin membrane_N = variants{} ; -- 
lin dependence_N = variants{} ; -- 
lin convict_V2 = variants{} ; -- 
lin bacteria_N = variants{} ; -- 
lin trading_N = variants{} ; -- 
lin ambassador_N = variants{} ; -- 
lin wound_V2 = variants{} ; -- 
lin drug_V2 = variants{} ; -- 
lin conjunction_N = variants{} ; -- 
lin cabin_N = variants{} ; -- 
lin trail_V2 = variants{} ; -- 
lin trail_V = variants{} ; -- 
lin shaft_N = variants{} ; -- 
lin treasure_N = variants{} ; -- 
lin inappropriate_A = variants{} ; -- 
lin half_Adv = variants{} ; -- 
lin attribute_N = variants{} ; -- 
lin liquid_A = variants{} ; -- 
lin embassy_N = variants{} ; -- 
lin terribly_Adv = variants{} ; -- 
lin exemption_N = variants{} ; -- 
lin array_N = variants{} ; -- 
lin tablet_N = variants{} ; -- 
lin sack_V2 = variants{} ; -- 
lin erosion_N = variants{} ; -- 
lin bull_N = variants{} ; -- 
lin warehouse_N = variants{} ; -- 
lin unfortunate_A = variants{} ; -- 
lin promoter_N = variants{} ; -- 
lin compel_VV = variants{} ; -- 
lin compel_V2V = variants{} ; -- 
lin compel_V2 = variants{} ; -- 
lin motivate_V2V = variants{} ; -- 
lin motivate_V2 = variants{} ; -- 
lin burning_A = variants{} ; -- 
lin vitamin_N = variants{} ; -- 
lin sail_N = variants{} ; -- 
lin lemon_N = variants{} ; -- 
lin foreigner_N = variants{} ; -- 
lin powder_N = variants{} ; -- 
lin persistent_A = variants{} ; -- 
lin bat_N = variants{} ; -- 
lin ancestor_N = variants{} ; -- 
lin predominantly_Adv = variants{} ; -- 
lin mathematical_A = variants{} ; -- 
lin compliance_N = variants{} ; -- 
lin arch_N = variants{} ; -- 
lin woodland_N = variants{} ; -- 
lin serum_N = variants{} ; -- 
lin overnight_Adv = variants{} ; -- 
lin doubtful_A = variants{} ; -- 
lin doing_N = variants{} ; -- 
lin coach_V2 = variants{} ; -- 
lin coach_V = variants{} ; -- 
lin binding_A = variants{} ; -- 
lin surrounding_A = variants{} ; -- 
lin peer_N = variants{} ; -- 
lin ozone_N = variants{} ; -- 
lin mid_A = variants{} ; -- 
lin invisible_A = variants{} ; -- 
lin depart_V = variants{} ; -- 
lin brigade_N = variants{} ; -- 
lin manipulate_V2 = variants{} ; -- 
lin consume_V2 = variants{} ; -- 
lin consume_V = variants{} ; -- 
lin temptation_N = variants{} ; -- 
lin intact_A = variants{} ; -- 
lin glove_N = mkN "ingwanta" "ingwanti" ;
lin aggression_N = variants{} ; -- 
lin emergence_N = variants{} ; -- 
lin stag_V = variants{} ; -- 
lin coffin_N = variants{} ; -- 
lin beautifully_Adv = variants{} ; -- 
lin clutch_V2 = variants{} ; -- 
lin clutch_V = variants{} ; -- 
lin wit_N = variants{} ; -- 
lin underline_V2 = variants{} ; -- 
lin trainee_N = variants{} ; -- 
lin scrutiny_N = variants{} ; -- 
lin neatly_Adv = variants{} ; -- 
lin follower_N = variants{} ; -- 
lin sterling_A = variants{} ; -- 
lin tariff_N = variants{} ; -- 
lin bee_N = variants{} ; -- 
lin relaxation_N = variants{} ; -- 
lin negligence_N = variants{} ; -- 
lin sunlight_N = variants{} ; -- 
lin penetrate_V2 = variants{} ; -- 
lin penetrate_V = variants{} ; -- 
lin knot_N = variants{} ; -- 
lin temper_N = variants{} ; -- 
lin skull_N = variants{} ; -- 
lin openly_Adv = variants{} ; -- 
lin grind_V2 = variants{} ; -- 
lin grind_V = variants{} ; -- 
lin whale_N = variants{} ; -- 
lin throne_N = variants{} ; -- 
lin supervise_V2 = variants{} ; -- 
lin supervise_V = variants{} ; -- 
lin sickness_N = variants{} ; -- 
lin package_V2 = variants{} ; -- 
lin intake_N = variants{} ; -- 
lin within_Adv = variants{} ; -- 
lin inland_A = variants{} ; -- 
lin beast_N = variants{} ; -- 
lin rear_N = variants{} ; -- 
lin morality_N = variants{} ; -- 
lin competent_A = variants{} ; -- 
lin sink_N = variants{} ; -- 
lin uniform_A = variants{} ; -- 
lin reminder_N = variants{} ; -- 
lin permanently_Adv = variants{} ; -- 
lin optimistic_A = variants{} ; -- 
lin bargain_N = variants{} ; -- 
lin seemingly_Adv = variants{} ; -- 
lin respective_A = variants{} ; -- 
lin horizontal_A = variants{} ; -- 
lin decisive_A = variants{} ; -- 
lin bless_V2 = variants{} ; -- 
lin bile_N = variants{} ; -- 
lin spatial_A = variants{} ; -- 
lin bullet_N = variants{} ; -- 
lin respectable_A = variants{} ; -- 
lin overseas_Adv = variants{} ; -- 
lin convincing_A = variants{} ; -- 
lin unacceptable_A = variants{} ; -- 
lin confrontation_N = variants{} ; -- 
lin swiftly_Adv = variants{} ; -- 
lin paid_A = variants{} ; -- 
lin joke_V = variants{} ; -- 
lin instant_A = variants{} ; -- 
lin illusion_N = variants{} ; -- 
lin cheer_V2 = variants{} ; -- 
lin cheer_V = variants{} ; -- 
lin congregation_N = variants{} ; -- 
lin worldwide_Adv = variants{} ; -- 
lin winning_A = variants{} ; -- 
lin wake_N = variants{} ; -- 
lin toss_V2 = variants{} ; -- 
lin toss_V = variants{} ; -- 
lin medium_A = variants{} ; -- 
lin jewellery_N = variants{} ; -- 
lin fond_A = variants{} ; -- 
lin alarm_V2 = variants{} ; -- 
lin guerrilla_N = variants{} ; -- 
lin dive_V = variants{} ; -- 
lin desire_V2 = variants{} ; -- 
lin cooperation_N = variants{} ; -- 
lin thread_N = variants{} ; -- 
lin prescribe_V2 = variants{} ; -- 
lin prescribe_V = variants{} ; -- 
lin calcium_N = variants{} ; -- 
lin redundant_A = variants{} ; -- 
lin marker_N = variants{} ; -- 
lin chemistMasc_N = variants{} ; -- 
lin mammal_N = variants{} ; -- 
lin legacy_N = variants{} ; -- 
lin debtor_N = variants{} ; -- 
lin testament_N = variants{} ; -- 
lin tragic_A = variants{} ; -- 
lin silver_A = variants{} ; -- 
lin grin_N = variants{} ; -- 
lin spectacle_N = variants{} ; -- 
lin inheritance_N = variants{} ; -- 
lin heal_V2 = variants{} ; -- 
lin heal_V = variants{} ; -- 
lin sovereignty_N = variants{} ; -- 
lin enzyme_N = variants{} ; -- 
lin host_V2 = variants{} ; -- 
lin neighbouring_A = variants{} ; -- 
lin corn_N = variants{} ; -- 
lin layout_N = variants{} ; -- 
lin dictate_VS = variants{} ; -- 
lin dictate_V2 = variants{} ; -- 
lin dictate_V = variants{} ; -- 
lin rip_V2 = variants{} ; -- 
lin rip_V = variants{} ; -- 
lin regain_V2 = variants{} ; -- 
lin probable_A = variants{} ; -- 
lin inclusion_N = variants{} ; -- 
lin booklet_N = variants{} ; -- 
lin bar_V2 = variants{} ; -- 
lin privately_Adv = variants{} ; -- 
lin laser_N = variants{} ; -- 
lin fame_N = variants{} ; -- 
lin bronze_N = variants{} ; -- 
lin mobile_A = variants{} ; -- 
lin metaphor_N = variants{} ; -- 
lin complication_N = variants{} ; -- 
lin narrow_V2 = variants{} ; -- 
lin narrow_V = variants{} ; -- 
lin old_fashioned_A = variants{} ; -- 
lin chop_V2 = variants{} ; -- 
lin chop_V = variants{} ; -- 
lin synthesis_N = variants{} ; -- 
lin diameter_N = variants{} ; -- 
lin bomb_V2 = variants{} ; -- 
lin bomb_V = variants{} ; -- 
lin silently_Adv = variants{} ; -- 
lin shed_N = variants{} ; -- 
lin fusion_N = variants{} ; -- 
lin trigger_V2 = variants{} ; -- 
lin printing_N = variants{} ; -- 
lin onion_N = variants{} ; -- 
lin dislike_V2 = variants{} ; -- 
lin embody_V2 = variants{} ; -- 
lin curl_V = variants{} ; -- 
lin sunshine_N = variants{} ; -- 
lin sponsorship_N = variants{} ; -- 
lin rage_N = variants{} ; -- 
lin loop_N = variants{} ; -- 
lin halt_N = variants{} ; -- 
lin cop_V2 = variants{} ; -- 
lin bang_V2 = variants{} ; -- 
lin bang_V = variants{} ; -- 
lin toxic_A = variants{} ; -- 
lin thinking_A = variants{} ; -- 
lin orientation_N = variants{} ; -- 
lin likelihood_N = variants{} ; -- 
lin wee_A = variants{} ; -- 
lin up_to_date_A = variants{} ; -- 
lin polite_A = variants{} ; -- 
lin apology_N = variants{} ; -- 
lin exile_N = variants{} ; -- 
lin brow_N = variants{} ; -- 
lin miserable_A = variants{} ; -- 
lin outbreak_N = variants{} ; -- 
lin comparatively_Adv = variants{} ; -- 
lin pump_V2 = variants{} ; -- 
lin pump_V = variants{} ; -- 
lin fuck_V2 = variants{} ; -- 
lin fuck_V = variants{} ; -- 
lin forecast_VS = variants{} ; -- 
lin forecast_V2 = variants{} ; -- 
lin forecast_V = variants{} ; -- 
lin timing_N = variants{} ; -- 
lin headmaster_N = variants{} ; -- 
lin terrify_V2 = variants{} ; -- 
lin sigh_N = variants{} ; -- 
lin premier_A = variants{} ; -- 
lin joint_N = variants{} ; -- 
lin incredible_A = variants{} ; -- 
lin gravity_N = variants{} ; -- 
lin regulatory_A = variants{} ; -- 
lin cylinder_N = variants{} ; -- 
lin curiosity_N = variants{} ; -- 
lin resident_A = variants{} ; -- 
lin narrative_N = variants{} ; -- 
lin cognitive_A = variants{} ; -- 
lin lengthy_A = variants{} ; -- 
lin gothic_A = variants{} ; -- 
lin dip_V2 = variants{} ; -- 
lin dip_V = variants{} ; -- 
lin adverse_A = variants{} ; -- 
lin accountability_N = variants{} ; -- 
lin hydrogen_N = variants{} ; -- 
lin gravel_N = variants{} ; -- 
lin willingness_N = variants{} ; -- 
lin inhibit_V2 = variants{} ; -- 
lin attain_V2 = variants{} ; -- 
lin attain_V = variants{} ; -- 
lin specialize_V2 = variants{} ; -- 
lin specialize_V = variants{} ; -- 
lin steer_V2 = variants{} ; -- 
lin steer_V = variants{} ; -- 
lin selected_A = variants{} ; -- 
lin like_N = variants{} ; -- 
lin confer_V = variants{} ; -- 
lin usage_N = variants{} ; -- 
lin portray_V2 = variants{} ; -- 
lin planner_N = variants{} ; -- 
lin manual_A = variants{} ; -- 
lin boast_VS = variants{} ; -- 
lin boast_V2 = variants{} ; -- 
lin boast_V = variants{} ; -- 
lin unconscious_A = variants{} ; -- 
lin jail_N = variants{} ; -- 
lin fertility_N = variants{} ; -- 
lin documentation_N = variants{} ; -- 
lin wolf_N = variants{} ; -- 
lin patent_N = variants{} ; -- 
lin exit_N = variants{} ; -- 
lin corps_N = variants{} ; -- 
lin proclaim_VS = variants{} ; -- 
lin proclaim_V2 = variants{} ; -- 
lin multiply_V2 = variants{} ; -- 
lin multiply_V = variants{} ; -- 
lin brochure_N = variants{} ; -- 
lin screen_V2 = variants{} ; -- 
lin screen_V = variants{} ; -- 
lin orthodox_A = variants{} ; -- 
lin locomotive_N = variants{} ; -- 
lin considering_Prep = variants{} ; -- 
lin unaware_A = variants{} ; -- 
lin syndrome_N = variants{} ; -- 
lin reform_V2 = variants{} ; -- 
lin reform_V = variants{} ; -- 
lin confirmation_N = variants{} ; -- 
lin printed_A = variants{} ; -- 
lin curve_V2 = variants{} ; -- 
lin curve_V = variants{} ; -- 
lin costly_A = variants{} ; -- 
lin underground_A = variants{} ; -- 
lin territorial_A = variants{} ; -- 
lin designate_VS = variants{} ; -- 
lin designate_V2V = variants{} ; -- 
lin designate_V2 = variants{} ; -- 
lin designate_V = variants{} ; -- 
lin comfort_V2 = variants{} ; -- 
lin plot_V2 = variants{} ; -- 
lin plot_V = variants{} ; -- 
lin misleading_A = variants{} ; -- 
lin weave_V2 = variants{} ; -- 
lin weave_V = variants{} ; -- 
lin scratch_V2 = lilV2 (barax_BRX_1_7504_V) ;
lin scratch_V = variants{}; -- lilV2 (barax_BRX_1_7504_V) ;
lin echo_N = variants{} ; -- 
lin ideally_Adv = variants{} ; -- 
lin endure_V2 = variants{} ; -- 
lin endure_V = variants{} ; -- 
lin verbal_A = variants{} ; -- 
lin stride_V = variants{} ; -- 
lin nursing_N = variants{} ; -- 
lin exert_V2 = variants{} ; -- 
lin compatible_A = variants{} ; -- 
lin causal_A = variants{} ; -- 
lin mosaic_N = variants{} ; -- 
lin manor_N = variants{} ; -- 
lin implicit_A = variants{} ; -- 
lin following_Prep = variants{} ; -- 
lin fashionable_A = variants{} ; -- 
lin valve_N = variants{} ; -- 
lin proceed_N = variants{} ; -- 
lin sofa_N = variants{} ; -- 
lin snatch_V2 = variants{} ; -- 
lin snatch_V = variants{} ; -- 
lin jazz_N = variants{} ; -- 
lin patron_N = variants{} ; -- 
lin provider_N = variants{} ; -- 
lin interim_A = variants{} ; -- 
lin intent_N = variants{} ; -- 
lin chosen_A = variants{} ; -- 
lin applied_A = variants{} ; -- 
lin shiver_V = variants{} ; -- 
lin pie_N = variants{} ; -- 
lin fury_N = variants{} ; -- 
lin abolition_N = variants{} ; -- 
lin soccer_N = variants{} ; -- 
lin corpse_N = variants{} ; -- 
lin accusation_N = variants{} ; -- 
lin kind_A = variants{} ; -- 
lin dead_Adv = variants{} ; -- 
lin nursing_A = variants{} ; -- 
lin contempt_N = variants{} ; -- 
lin prevail_V = variants{} ; -- 
lin murderer_N = variants{} ; -- 
lin liberal_N = variants{} ; -- 
lin gathering_N = variants{} ; -- 
lin adequately_Adv = variants{} ; -- 
lin subjective_A = variants{} ; -- 
lin disagreement_N = variants{} ; -- 
lin cleaner_N = variants{} ; -- 
lin boil_V2 = variants{} ; -- 
lin boil_V = variants{} ; -- 
lin static_A = variants{} ; -- 
lin scent_N = variants{} ; -- 
lin civilian_N = variants{} ; -- 
lin monk_N = variants{} ; -- 
lin abruptly_Adv = variants{} ; -- 
lin keyboard_N = variants{} ; -- 
lin hammer_N = variants{} ; -- 
lin despair_N = variants{} ; -- 
lin controller_N = variants{} ; -- 
lin yell_V2 = variants{} ; -- 
lin yell_V = variants{} ; -- 
lin entail_V2 = variants{} ; -- 
lin cheerful_A = variants{} ; -- 
lin reconstruction_N = variants{} ; -- 
lin patience_N = variants{} ; -- 
lin legally_Adv = variants{} ; -- 
lin habitat_N = variants{} ; -- 
lin queue_N = variants{} ; -- 
lin spectatorMasc_N = variants{} ; -- 
lin given_A = variants{} ; -- 
lin purple_A = variants{} ; -- 
lin outlook_N = variants{} ; -- 
lin genius_N = variants{} ; -- 
lin dual_A = variants{} ; -- 
lin canvas_N = variants{} ; -- 
lin grave_A = variants{} ; -- 
lin pepper_N = variants{} ; -- 
lin conform_V2 = variants{} ; -- 
lin conform_V = variants{} ; -- 
lin cautious_A = variants{} ; -- 
lin dot_N = variants{} ; -- 
lin conspiracy_N = variants{} ; -- 
lin butterfly_N = variants{} ; -- 
lin sponsor_N = variants{} ; -- 
lin sincerely_Adv = variants{} ; -- 
lin rating_N = variants{} ; -- 
lin weird_A = variants{} ; -- 
lin teenage_A = variants{} ; -- 
lin salmon_N = variants{} ; -- 
lin recorder_N = variants{} ; -- 
lin postpone_V2 = variants{} ; -- 
lin maid_N = variants{} ; -- 
lin furnish_V2 = variants{} ; -- 
lin ethical_A = variants{} ; -- 
lin bicycle_N = variants{} ; -- 
lin sick_N = variants{} ; -- 
lin sack_N = variants{} ; -- 
lin renaissance_N = variants{} ; -- 
lin luxury_N = variants{} ; -- 
lin gasp_V2 = variants{} ; -- 
lin gasp_V = variants{} ; -- 
lin wardrobe_N = variants{} ; -- 
lin native_N = variants{} ; -- 
lin fringe_N = variants{} ; -- 
lin adaptation_N = variants{} ; -- 
lin quotation_N = variants{} ; -- 
lin hunger_N = variants{} ; -- 
lin enclose_V2 = variants{} ; -- 
lin disastrous_A = variants{} ; -- 
lin choir_N = variants{} ; -- 
lin overwhelming_A = variants{} ; -- 
lin glimpse_N = variants{} ; -- 
lin divorce_V2 = variants{} ; -- 
lin circular_A = variants{} ; -- 
lin locality_N = variants{} ; -- 
lin ferry_N = variants{} ; -- 
lin balcony_N = variants{} ; -- 
lin sailor_N = variants{} ; -- 
lin precision_N = variants{} ; -- 
lin desert_V2 = variants{} ; -- 
lin desert_V = variants{} ; -- 
lin dancing_N = variants{} ; -- 
lin alert_V2 = variants{} ; -- 
lin surrender_V2 = variants{} ; -- 
lin surrender_V = variants{} ; -- 
lin archive_N = variants{} ; -- 
lin jump_N = variants{} ; -- 
lin philosopher_N = variants{} ; -- 
lin revival_N = variants{} ; -- 
lin presume_VS = variants{} ; -- 
lin presume_V2 = variants{} ; -- 
lin presume_V = variants{} ; -- 
lin node_N = variants{} ; -- 
lin fantastic_A = variants{} ; -- 
lin herb_N = variants{} ; -- 
lin assertion_N = variants{} ; -- 
lin thorough_A = variants{} ; -- 
lin quit_V2 = variants{} ; -- 
lin quit_V = variants{} ; -- 
lin grim_A = variants{} ; -- 
lin fair_N = variants{} ; -- 
lin broadcast_V2 = variants{} ; -- 
lin broadcast_V = variants{} ; -- 
lin annoy_V2 = variants{} ; -- 
lin divert_V = variants{} ; -- 
lin accelerate_V2 = variants{} ; -- 
lin accelerate_V = variants{} ; -- 
lin polymer_N = variants{} ; -- 
lin sweat_N = variants{} ; -- 
lin survivor_N = variants{} ; -- 
lin subscription_N = variants{} ; -- 
lin repayment_N = variants{} ; -- 
lin anonymous_A = variants{} ; -- 
lin summarize_V2 = variants{} ; -- 
lin punch_N = variants{} ; -- 
lin lodge_V2 = variants{} ; -- 
lin lodge_V = variants{} ; -- 
lin landowner_N = variants{} ; -- 
lin ignorance_N = variants{} ; -- 
lin discourage_V2 = variants{} ; -- 
lin bride_N = variants{} ; -- 
lin likewise_Adv = variants{} ; -- 
lin depressed_A = variants{} ; -- 
lin abbey_N = variants{} ; -- 
lin quarry_N = variants{} ; -- 
lin archbishop_N = variants{} ; -- 
lin sock_N = mkN "kalzetta" "kalzetti" ;
lin large_scale_A = variants{} ; -- 
lin glare_V2 = variants{} ; -- 
lin glare_V = variants{} ; -- 
lin descent_N = variants{} ; -- 
lin stumble_V = variants{} ; -- 
lin mistress_N = variants{} ; -- 
lin empty_V2 = variants{} ; -- 
lin empty_V = variants{} ; -- 
lin prosperity_N = variants{} ; -- 
lin harm_V2 = variants{} ; -- 
lin formulation_N = variants{} ; -- 
lin atomic_A = variants{} ; -- 
lin agreed_A = variants{} ; -- 
lin wicked_A = variants{} ; -- 
lin threshold_N = variants{} ; -- 
lin lobby_N = variants{} ; -- 
lin repay_V2 = variants{} ; -- 
lin repay_V = variants{} ; -- 
lin varying_A = variants{} ; -- 
lin track_V2 = variants{} ; -- 
lin track_V = variants{} ; -- 
lin crawl_V = variants{} ; -- 
lin tolerate_V2 = variants{} ; -- 
lin salvation_N = variants{} ; -- 
lin pudding_N = variants{} ; -- 
lin counter_VS = variants{} ; -- 
lin counter_V = variants{} ; -- 
lin propaganda_N = variants{} ; -- 
lin cage_N = variants{} ; -- 
lin broker_N = variants{} ; -- 
lin ashamed_A = variants{} ; -- 
lin scan_V2 = variants{} ; -- 
lin scan_V = variants{} ; -- 
lin document_V2 = variants{} ; -- 
lin apparatus_N = variants{} ; -- 
lin theology_N = variants{} ; -- 
lin analogy_N = variants{} ; -- 
lin efficiently_Adv = variants{} ; -- 
lin bitterly_Adv = variants{} ; -- 
lin performer_N = variants{} ; -- 
lin individually_Adv = variants{} ; -- 
lin amid_Prep = variants{} ; -- 
lin squadron_N = variants{} ; -- 
lin sentiment_N = variants{} ; -- 
lin making_N = variants{} ; -- 
lin exotic_A = variants{} ; -- 
lin dominance_N = variants{} ; -- 
lin coherent_A = variants{} ; -- 
lin placement_N = variants{} ; -- 
lin flick_V2 = variants{} ; -- 
lin colourful_A = variants{} ; -- 
lin mercy_N = variants{} ; -- 
lin angrily_Adv = variants{} ; -- 
lin amuse_V2 = variants{} ; -- 
lin mainstream_N = variants{} ; -- 
lin appraisal_N = variants{} ; -- 
lin annually_Adv = variants{} ; -- 
lin torch_N = variants{} ; -- 
lin intimate_A = variants{} ; -- 
lin gold_A = variants{} ; -- 
lin arbitrary_A = variants{} ; -- 
lin venture_VS = variants{} ; -- 
lin venture_V2 = variants{} ; -- 
lin venture_V = variants{} ; -- 
lin preservation_N = variants{} ; -- 
lin shy_A = variants{} ; -- 
lin disclosure_N = variants{} ; -- 
lin lace_N = variants{} ; -- 
lin inability_N = variants{} ; -- 
lin motif_N = variants{} ; -- 
lin listenerMasc_N = variants{} ; -- 
lin hunt_N = variants{} ; -- 
lin delicious_A = variants{} ; -- 
lin term_VS = variants{} ; -- 
lin term_V2 = variants{} ; -- 
lin substitute_N = variants{} ; -- 
lin highway_N = variants{} ; -- 
lin haul_V2 = variants{} ; -- 
lin haul_V = variants{} ; -- 
lin dragon_N = variants{} ; -- 
lin chair_V2 = variants{} ; -- 
lin accumulate_V2 = variants{} ; -- 
lin accumulate_V = variants{} ; -- 
lin unchanged_A = variants{} ; -- 
lin sediment_N = variants{} ; -- 
lin sample_V2 = variants{} ; -- 
lin exclaim_V2 = variants{} ; -- 
lin fan_V2 = variants{} ; -- 
lin fan_V = variants{} ; -- 
lin volunteer_V2 = variants{} ; -- 
lin volunteer_V = variants{} ; -- 
lin root_V2 = variants{} ; -- 
lin root_V = variants{} ; -- 
lin parcel_N = variants{} ; -- 
lin psychiatric_A = variants{} ; -- 
lin delightful_A = variants{} ; -- 
lin confidential_A = variants{} ; -- 
lin calorie_N = variants{} ; -- 
lin flash_N = variants{} ; -- 
lin crowd_V2 = variants{} ; -- 
lin crowd_V = variants{} ; -- 
lin aggregate_A = variants{} ; -- 
lin scholarship_N = variants{} ; -- 
lin monitor_N = variants{} ; -- 
lin disciplinary_A = variants{} ; -- 
lin rock_V2 = variants{} ; -- 
lin rock_V = variants{} ; -- 
lin hatred_N = variants{} ; -- 
lin pill_N = variants{} ; -- 
lin noisy_A = variants{} ; -- 
lin feather_N = mkNColl "rixa" "rix" "rixiet" ;
lin lexical_A = variants{} ; -- 
lin staircase_N = variants{} ; -- 
lin autonomous_A = variants{} ; -- 
lin viewpoint_N = variants{} ; -- 
lin projection_N = variants{} ; -- 
lin offensive_A = variants{} ; -- 
lin controlled_A = variants{} ; -- 
lin flush_V2 = variants{} ; -- 
lin flush_V = variants{} ; -- 
lin racism_N = variants{} ; -- 
lin flourish_V = variants{} ; -- 
lin resentment_N = variants{} ; -- 
lin pillow_N = variants{} ; -- 
lin courtesy_N = variants{} ; -- 
lin photography_N = variants{} ; -- 
lin monkey_N = variants{} ; -- 
lin glorious_A = variants{} ; -- 
lin evolutionary_A = variants{} ; -- 
lin gradual_A = variants{} ; -- 
lin bankruptcy_N = variants{} ; -- 
lin sacrifice_N = variants{} ; -- 
lin uphold_V2 = variants{} ; -- 
lin sketch_N = variants{} ; -- 
lin presidency_N = variants{} ; -- 
lin formidable_A = variants{} ; -- 
lin differentiate_V2 = variants{} ; -- 
lin differentiate_V = variants{} ; -- 
lin continuing_A = variants{} ; -- 
lin cart_N = variants{} ; -- 
lin stadium_N = variants{} ; -- 
lin dense_A = variants{} ; -- 
lin catch_N = variants{} ; -- 
lin beyond_Adv = variants{} ; -- 
lin immigration_N = variants{} ; -- 
lin clarity_N = variants{} ; -- 
lin worm_N = mkNColl "dudu" "dud" "dudiet" ;
lin slot_N = variants{} ; -- 
lin rifle_N = variants{} ; -- 
lin screw_V2 = variants{} ; -- 
lin screw_V = variants{} ; -- 
lin harvest_N = variants{} ; -- 
lin foster_V2 = variants{} ; -- 
lin academic_N = variants{} ; -- 
lin impulse_N = variants{} ; -- 
lin guardian_N = variants{} ; -- 
lin ambiguity_N = variants{} ; -- 
lin triangle_N = variants{} ; -- 
lin terminate_V2 = variants{} ; -- 
lin terminate_V = variants{} ; -- 
lin retreat_V = variants{} ; -- 
lin pony_N = variants{} ; -- 
lin outdoor_A = variants{} ; -- 
lin deficiency_N = variants{} ; -- 
lin decree_N = variants{} ; -- 
lin apologize_V = variants{} ; -- 
lin yarn_N = variants{} ; -- 
lin staff_V2 = variants{} ; -- 
lin renewal_N = variants{} ; -- 
lin rebellion_N = variants{} ; -- 
lin incidentally_Adv = variants{} ; -- 
lin flour_N = variants{} ; -- 
lin developed_A = variants{} ; -- 
lin chorus_N = variants{} ; -- 
lin ballot_N = variants{} ; -- 
lin appetite_N = variants{} ; -- 
lin stain_V2 = variants{} ; -- 
lin stain_V = variants{} ; -- 
lin notebook_N = variants{} ; -- 
lin loudly_Adv = variants{} ; -- 
lin homeless_A = variants{} ; -- 
lin census_N = variants{} ; -- 
lin bizarre_A = variants{} ; -- 
lin striking_A = variants{} ; -- 
lin greenhouse_N = variants{} ; -- 
lin part_V2 = variants{} ; -- 
lin part_V = variants{} ; -- 
lin burial_N = variants{} ; -- 
lin embarrassed_A = variants{} ; -- 
lin ash_N = variants{} ; -- 
lin actress_N = variants{} ; -- 
lin cassette_N = variants{} ; -- 
lin privacy_N = variants{} ; -- 
lin fridge_N = mkN "friġġ" "friġġijiet" ;
lin feed_N = variants{} ; -- 
lin excess_A = variants{} ; -- 
lin calf_N = variants{} ; -- 
lin associate_N = variants{} ; -- 
lin ruin_N = variants{} ; -- 
lin jointly_Adv = variants{} ; -- 
lin drill_V2 = variants{} ; -- 
lin drill_V = variants{} ; -- 
lin photograph_V2 = variants{} ; -- 
lin devoted_A = variants{} ; -- 
lin indirectly_Adv = variants{} ; -- 
lin driving_A = variants{} ; -- 
lin memorandum_N = variants{} ; -- 
lin default_N = variants{} ; -- 
lin costume_N = variants{} ; -- 
lin variant_N = variants{} ; -- 
lin shatter_V2 = variants{} ; -- 
lin shatter_V = variants{} ; -- 
lin methodology_N = variants{} ; -- 
lin frame_V2 = variants{} ; -- 
lin frame_V = variants{} ; -- 
lin allegedly_Adv = variants{} ; -- 
lin swell_V2 = variants{}; -- ntefah_NFH_8_8970_V ;
lin swell_V = ntefah_NFH_8_8970_V ;
lin investigator_N = variants{} ; -- 
lin imaginative_A = variants{} ; -- 
lin bored_A = variants{} ; -- 
lin bin_N = variants{} ; -- 
lin awake_A = variants{} ; -- 
lin recycle_V2 = variants{} ; -- 
lin group_V2 = variants{} ; -- 
lin group_V = variants{} ; -- 
lin enjoyment_N = variants{} ; -- 
lin contemporary_N = variants{} ; -- 
lin texture_N = variants{} ; -- 
lin donor_N = variants{} ; -- 
lin bacon_N = variants{} ; -- 
lin sunny_A = variants{} ; -- 
lin stool_N = variants{} ; -- 
lin prosecute_V2 = variants{} ; -- 
lin commentary_N = variants{} ; -- 
lin bass_N = variants{} ; -- 
lin sniff_V2 = variants{} ; -- 
lin sniff_V = variants{} ; -- 
lin repetition_N = variants{} ; -- 
lin eventual_A = variants{} ; -- 
lin credit_V2 = variants{} ; -- 
lin suburb_N = variants{} ; -- 
lin newcomer_N = variants{} ; -- 
lin romance_N = variants{} ; -- 
lin film_V2 = variants{} ; -- 
lin film_V = variants{} ; -- 
lin experiment_V2 = variants{} ; -- 
lin experiment_V = variants{} ; -- 
lin daylight_N = variants{} ; -- 
lin warrant_N = variants{} ; -- 
lin fur_N = variants{} ; -- 
lin parking_N = variants{} ; -- 
lin nuisance_N = variants{} ; -- 
lin civilian_A = variants{} ; -- 
lin foolish_A = variants{} ; -- 
lin bulb_N = variants{} ; -- 
lin balloon_N = variants{} ; -- 
lin vivid_A = variants{} ; -- 
lin surveyor_N = variants{} ; -- 
lin spontaneous_A = variants{} ; -- 
lin biology_N = variants{} ; -- 
lin injunction_N = variants{} ; -- 
lin appalling_A = variants{} ; -- 
lin amusement_N = variants{} ; -- 
lin aesthetic_A = variants{} ; -- 
lin vegetation_N = variants{} ; -- 
lin stab_V2 = lilV2 (mewwes_MWS_2_8921_V) ;
lin stab_V = variants{}; -- lilV2 (mewwes_MWS_2_8921_V) ;
lin rude_A = variants{} ; -- 
lin offset_V2 = variants{} ; -- 
lin thinking_N = variants{} ; -- 
lin mainframe_N = variants{} ; -- 
lin flock_N = variants{} ; -- 
lin amateur_A = variants{} ; -- 
lin academy_N = variants{} ; -- 
lin shilling_N = variants{} ; -- 
lin reluctance_N = variants{} ; -- 
lin velocity_N = variants{} ; -- 
lin spare_V2 = variants{} ; -- 
lin spare_V = variants{} ; -- 
lin wartime_N = variants{} ; -- 
lin soak_V2 = variants{} ; -- 
lin soak_V = variants{} ; -- 
lin rib_N = variants{} ; -- 
lin mighty_A = variants{} ; -- 
lin shocked_A = variants{} ; -- 
lin vocational_A = variants{} ; -- 
lin spit_V2 = variants{}; -- bezaq_BZQ_1_7549_V ;
lin spit_V = bezaq_BZQ_1_7549_V ;
lin gall_N = variants{} ; -- 
lin bowl_V2 = variants{} ; -- 
lin bowl_V = variants{} ; -- 
lin prescription_N = variants{} ; -- 
lin fever_N = variants{} ; -- 
lin axis_N = variants{} ; -- 
lin reservoir_N = variants{} ; -- 
lin magnitude_N = variants{} ; -- 
lin rape_V2 = variants{} ; -- 
lin cutting_N = variants{} ; -- 
lin bracket_N = variants{} ; -- 
lin agony_N = variants{} ; -- 
lin strive_VV = variants{} ; -- 
lin strive_V = variants{} ; -- 
lin strangely_Adv = variants{} ; -- 
lin pledge_VS = variants{} ; -- 
lin pledge_V2V = variants{} ; -- 
lin pledge_V2 = variants{} ; -- 
lin recipient_N = variants{} ; -- 
lin moor_N = variants{} ; -- 
lin invade_V2 = variants{} ; -- 
lin dairy_N = variants{} ; -- 
lin chord_N = variants{} ; -- 
lin shrink_V2 = variants{} ; -- 
lin shrink_V = variants{} ; -- 
lin poison_N = variants{} ; -- 
lin pillar_N = variants{} ; -- 
lin washing_N = variants{} ; -- 
lin warrior_N = variants{} ; -- 
lin supervisor_N = variants{} ; -- 
lin outfit_N = variants{} ; -- 
lin innovative_A = variants{} ; -- 
lin dressing_N = variants{} ; -- 
lin dispute_V2 = variants{} ; -- 
lin dispute_V = variants{} ; -- 
lin jungle_N = variants{} ; -- 
lin brewery_N = variants{} ; -- 
lin adjective_N = variants{} ; -- 
lin straighten_V2 = variants{} ; -- 
lin straighten_V = variants{} ; -- 
lin restrain_V2 = variants{} ; -- 
lin monarchy_N = variants{} ; -- 
lin trunk_N = variants{} ; -- 
lin herd_N = variants{} ; -- 
lin deadline_N = variants{} ; -- 
lin tiger_N = variants{} ; -- 
lin supporting_A = variants{} ; -- 
lin moderate_A = variants{} ; -- 
lin kneel_V = variants{} ; -- 
lin ego_N = variants{} ; -- 
lin sexually_Adv = variants{} ; -- 
lin ministerial_A = variants{} ; -- 
lin bitch_N = variants{} ; -- 
lin wheat_N = variants{} ; -- 
lin stagger_V = variants{} ; -- 
lin snake_N = mkN "serp" "sriep" ;
lin ribbon_N = variants{} ; -- 
lin mainland_N = variants{} ; -- 
lin fisherman_N = variants{} ; -- 
lin economically_Adv = variants{} ; -- 
lin unwilling_A = variants{} ; -- 
lin nationalism_N = variants{} ; -- 
lin knitting_N = variants{} ; -- 
lin irony_N = variants{} ; -- 
lin handling_N = variants{} ; -- 
lin desired_A = variants{} ; -- 
lin bomber_N = variants{} ; -- 
lin voltage_N = variants{} ; -- 
lin unusually_Adv = variants{} ; -- 
lin toast_N = variants{} ; -- 
lin feel_N = variants{} ; -- 
lin suffering_N = variants{} ; -- 
lin polish_V2 = variants{} ; -- 
lin polish_V = variants{} ; -- 
lin technically_Adv = variants{} ; -- 
lin meaningful_A = variants{} ; -- 
lin aloud_Adv = variants{} ; -- 
lin waiter_N = variants{} ; -- 
lin tease_V2 = variants{} ; -- 
lin opposite_Adv = variants{} ; -- 
lin goat_N = variants{} ; -- 
lin conceptual_A = variants{} ; -- 
lin ant_N = variants{} ; -- 
lin inflict_V2 = variants{} ; -- 
lin bowler_N = variants{} ; -- 
lin roar_V2 = variants{} ; -- 
lin roar_V = variants{} ; -- 
lin drain_N = variants{} ; -- 
lin wrong_N = variants{} ; -- 
lin galaxy_N = variants{} ; -- 
lin aluminium_N = variants{} ; -- 
lin receptor_N = variants{} ; -- 
lin preach_V2 = variants{} ; -- 
lin preach_V = variants{} ; -- 
lin parade_N = variants{} ; -- 
lin opposite_N = variants{} ; -- 
lin critique_N = variants{} ; -- 
lin query_N = variants{} ; -- 
lin outset_N = variants{} ; -- 
lin integral_A = variants{} ; -- 
lin grammatical_A = variants{} ; -- 
lin testing_N = variants{} ; -- 
lin patrol_N = variants{} ; -- 
lin pad_N = variants{} ; -- 
lin unreasonable_A = variants{} ; -- 
lin sausage_N = variants{} ; -- 
lin criminal_N = variants{} ; -- 
lin constructive_A = variants{} ; -- 
lin worldwide_A = variants{} ; -- 
lin highlight_N = variants{} ; -- 
lin doll_N = variants{} ; -- 
lin frightened_A = variants{} ; -- 
lin biography_N = variants{} ; -- 
lin vocabulary_N = variants{} ; -- 
lin offend_V2 = variants{} ; -- 
lin offend_V = variants{} ; -- 
lin accumulation_N = variants{} ; -- 
lin linen_N = variants{} ; -- 
lin fairy_N = variants{} ; -- 
lin disco_N = variants{} ; -- 
lin hint_VS = variants{} ; -- 
lin hint_V2 = variants{} ; -- 
lin hint_V = variants{} ; -- 
lin versus_Prep = variants{} ; -- 
lin ray_N = variants{} ; -- 
lin pottery_N = variants{} ; -- 
lin immune_A = variants{} ; -- 
lin retreat_N = variants{} ; -- 
lin master_V2 = variants{} ; -- 
lin injured_A = variants{} ; -- 
lin holly_N = variants{} ; -- 
lin battle_V2 = variants{} ; -- 
lin battle_V = variants{} ; -- 
lin solidarity_N = variants{} ; -- 
lin embarrassing_A = variants{} ; -- 
lin cargo_N = variants{} ; -- 
lin theorist_N = variants{} ; -- 
lin reluctantly_Adv = variants{} ; -- 
lin preferred_A = variants{} ; -- 
lin dash_V = variants{} ; -- 
lin total_V2 = variants{} ; -- 
lin total_V = variants{} ; -- 
lin reconcile_V2 = variants{} ; -- 
lin drill_N = variants{} ; -- 
lin credibility_N = variants{} ; -- 
lin copyright_N = variants{} ; -- 
lin beard_N = variants{} ; -- 
lin bang_N = variants{} ; -- 
lin vigorous_A = variants{} ; -- 
lin vaguely_Adv = variants{} ; -- 
lin punch_V2 = variants{} ; -- 
lin prevalence_N = variants{} ; -- 
lin uneasy_A = variants{} ; -- 
lin boost_N = variants{} ; -- 
lin scrap_N = variants{} ; -- 
lin ironically_Adv = variants{} ; -- 
lin fog_N = mkNColl "ċpar" ;
lin faithful_A = variants{} ; -- 
lin bounce_V2 = variants{} ; -- 
lin bounce_V = variants{} ; -- 
lin batch_N = variants{} ; -- 
lin smooth_V2 = variants{} ; -- 
lin smooth_V = variants{} ; -- 
lin sleeping_A = variants{} ; -- 
lin poorly_Adv = variants{} ; -- 
lin accord_V = variants{} ; -- 
lin vice_president_N = variants{} ; -- 
lin duly_Adv = variants{} ; -- 
lin blast_N = variants{} ; -- 
lin square_V2 = variants{} ; -- 
lin square_V = variants{} ; -- 
lin prohibit_V2 = variants{} ; -- 
lin prohibit_V = variants{} ; -- 
lin brake_N = variants{} ; -- 
lin asylum_N = variants{} ; -- 
lin obscure_V2 = variants{} ; -- 
lin nun_N = variants{} ; -- 
lin heap_N = variants{} ; -- 
lin smoothly_Adv = variants{} ; -- 
lin rhetoric_N = variants{} ; -- 
lin privileged_A = variants{} ; -- 
lin liaison_N = variants{} ; -- 
lin jockey_N = variants{} ; -- 
lin concrete_N = variants{} ; -- 
lin allied_A = variants{} ; -- 
lin rob_V2 = variants{} ; -- 
lin indulge_V2 = variants{} ; -- 
lin indulge_V = variants{} ; -- 
lin except_Prep = mkPrep "apparti" ; --- special case..
lin distort_V2 = variants{} ; -- 
lin whatsoever_Adv = variants{} ; -- 
lin viable_A = variants{} ; -- 
lin nucleus_N = variants{} ; -- 
lin exaggerate_V2 = variants{} ; -- 
lin exaggerate_V = variants{} ; -- 
lin compact_N = variants{} ; -- 
lin nationality_N = variants{} ; -- 
lin direct_Adv = variants{} ; -- 
lin cast_N = variants{} ; -- 
lin altar_N = variants{} ; -- 
lin refuge_N = variants{} ; -- 
lin presently_Adv = variants{} ; -- 
lin mandatory_A = variants{} ; -- 
lin authorize_V2V = variants{} ; -- 
lin authorize_V2 = variants{} ; -- 
lin accomplish_V2 = variants{} ; -- 
lin startle_V2 = variants{} ; -- 
lin indigenous_A = variants{} ; -- 
lin worse_Adv = variants{} ; -- 
lin retailer_N = variants{} ; -- 
lin compound_V2 = variants{} ; -- 
lin compound_V = variants{} ; -- 
lin admiration_N = variants{} ; -- 
lin absurd_A = variants{} ; -- 
lin coincidence_N = variants{} ; -- 
lin principally_Adv = variants{} ; -- 
lin passport_N = variants{} ; -- 
lin depot_N = variants{} ; -- 
lin soften_V2 = variants{} ; -- 
lin soften_V = variants{} ; -- 
lin secretion_N = variants{} ; -- 
lin invoke_V2 = variants{} ; -- 
lin dirt_N = variants{} ; -- 
lin scared_A = variants{} ; -- 
lin mug_N = variants{} ; -- 
lin convenience_N = variants{} ; -- 
lin calm_N = variants{} ; -- 
lin optional_A = variants{} ; -- 
lin unsuccessful_A = variants{} ; -- 
lin consistency_N = variants{} ; -- 
lin umbrella_N = variants{} ; -- 
lin solo_N = variants{} ; -- 
lin hemisphere_N = variants{} ; -- 
lin extreme_N = variants{} ; -- 
lin brandy_N = variants{} ; -- 
lin belly_N = possN (mkN "żaqq" "żquq") ;
lin attachment_N = variants{} ; -- 
lin wash_N = variants{} ; -- 
lin uncover_V2 = variants{} ; -- 
lin treat_N = variants{} ; -- 
lin repeated_A = variants{} ; -- 
lin pine_N = variants{} ; -- 
lin offspring_N = variants{} ; -- 
lin communism_N = variants{} ; -- 
lin nominate_V2 = variants{} ; -- 
lin soar_V2 = variants{} ; -- 
lin soar_V = variants{} ; -- 
lin geological_A = variants{} ; -- 
lin frog_N = variants{} ; -- 
lin donate_V2 = variants{} ; -- 
lin donate_V = variants{} ; -- 
lin cooperative_A = variants{} ; -- 
lin nicely_Adv = variants{} ; -- 
lin innocence_N = variants{} ; -- 
lin housewife_N = variants{} ; -- 
lin disguise_V2 = variants{} ; -- 
lin demolish_V2 = variants{} ; -- 
lin counsel_N = variants{} ; -- 
lin cord_N = variants{} ; -- 
lin semi_final_N = variants{} ; -- 
lin reasoning_N = variants{} ; -- 
lin litre_N = variants{} ; -- 
lin inclined_A = variants{} ; -- 
lin evoke_V2 = variants{} ; -- 
lin courtyard_N = variants{} ; -- 
lin arena_N = variants{} ; -- 
lin simplicity_N = variants{} ; -- 
lin inhibition_N = variants{} ; -- 
lin frozen_A = variants{} ; -- 
lin vacuum_N = variants{} ; -- 
lin immigrant_N = variants{} ; -- 
lin bet_N = variants{} ; -- 
lin revenge_N = variants{} ; -- 
lin jail_V2 = variants{} ; -- 
lin helmet_N = variants{} ; -- 
lin unclear_A = variants{} ; -- 
lin jerk_V2 = variants{} ; -- 
lin jerk_V = variants{} ; -- 
lin disruption_N = variants{} ; -- 
lin attainment_N = variants{} ; -- 
lin sip_V2 = variants{} ; -- 
lin sip_V = variants{} ; -- 
lin program_V2V = variants{} ; -- 
lin program_V2 = variants{} ; -- 
lin lunchtime_N = variants{} ; -- 
lin cult_N = variants{} ; -- 
lin chat_N = variants{} ; -- 
lin accord_N = variants{} ; -- 
lin supposedly_Adv = variants{} ; -- 
lin offering_N = variants{} ; -- 
lin broadcast_N = variants{} ; -- 
lin secular_A = variants{} ; -- 
lin overwhelm_V2 = variants{} ; -- 
lin momentum_N = variants{} ; -- 
lin infinite_A = variants{} ; -- 
lin manipulation_N = variants{} ; -- 
lin inquest_N = variants{} ; -- 
lin decrease_N = variants{} ; -- 
lin cellar_N = variants{} ; -- 
lin counsellor_N = variants{} ; -- 
lin avenue_N = variants{} ; -- 
lin rubber_A = variants{} ; -- 
lin labourer_N = variants{} ; -- 
lin lab_N = variants{} ; -- 
lin damn_V2 = variants{} ; -- 
lin comfortably_Adv = variants{} ; -- 
lin tense_A = variants{} ; -- 
lin socket_N = variants{} ; -- 
lin par_N = variants{} ; -- 
lin thrust_N = variants{} ; -- 
lin scenario_N = variants{} ; -- 
lin frankly_Adv = variants{} ; -- 
lin slap_V2 = variants{} ; -- 
lin recreation_N = variants{} ; -- 
lin rank_V2 = variants{} ; -- 
lin rank_V = variants{} ; -- 
lin spy_N = variants{} ; -- 
lin filter_V2 = variants{} ; -- 
lin filter_V = variants{} ; -- 
lin clearance_N = variants{} ; -- 
lin blessing_N = variants{} ; -- 
lin embryo_N = variants{} ; -- 
lin varied_A = variants{} ; -- 
lin predictable_A = variants{} ; -- 
lin mutation_N = variants{} ; -- 
lin equal_V2 = variants{} ; -- 
lin can_1_VV = variants{} ; -- 
lin can_2_VV = variants{} ; -- 
lin can_V2 = variants{}; -- sata'_V ;
lin burst_N = variants{} ; -- 
lin retrieve_V2 = variants{} ; -- 
lin retrieve_V = variants{} ; -- 
lin elder_N = variants{} ; -- 
lin rehearsal_N = variants{} ; -- 
lin optical_A = variants{} ; -- 
lin hurry_N = variants{} ; -- 
lin conflict_V = variants{} ; -- 
lin combat_V2 = variants{} ; -- 
lin combat_V = variants{} ; -- 
lin absorption_N = variants{} ; -- 
lin ion_N = variants{} ; -- 
lin wrong_Adv = variants{} ; -- 
lin heroin_N = variants{} ; -- 
lin bake_V2 = variants{} ; -- 
lin bake_V = variants{} ; -- 
lin x_ray_N = variants{} ; -- 
lin vector_N = variants{} ; -- 
lin stolen_A = variants{} ; -- 
lin sacrifice_V2 = variants{} ; -- 
lin sacrifice_V = variants{} ; -- 
lin robbery_N = variants{} ; -- 
lin probe_V2 = variants{} ; -- 
lin probe_V = variants{} ; -- 
lin organizational_A = variants{} ; -- 
lin chalk_N = variants{} ; -- 
lin bourgeois_A = variants{} ; -- 
lin villager_N = variants{} ; -- 
lin morale_N = variants{} ; -- 
lin express_A = variants{} ; -- 
lin climb_N = variants{} ; -- 
lin notify_V2 = variants{} ; -- 
lin jam_N = variants{} ; -- 
lin bureaucratic_A = variants{} ; -- 
lin literacy_N = variants{} ; -- 
lin frustrate_V2 = variants{} ; -- 
lin freight_N = variants{} ; -- 
lin clearing_N = variants{} ; -- 
lin aviation_N = variants{} ; -- 
lin legislature_N = variants{} ; -- 
lin curiously_Adv = variants{} ; -- 
lin banana_N = variants{} ; -- 
lin deploy_V2 = variants{} ; -- 
lin deploy_V = variants{} ; -- 
lin passionate_A = variants{} ; -- 
lin monastery_N = variants{} ; -- 
lin kettle_N = variants{} ; -- 
lin enjoyable_A = variants{} ; -- 
lin diagnose_V2 = variants{} ; -- 
lin quantitative_A = variants{} ; -- 
lin distortion_N = variants{} ; -- 
lin monarch_N = variants{} ; -- 
lin kindly_Adv = variants{} ; -- 
lin glow_V = variants{} ; -- 
lin acquaintance_N = variants{} ; -- 
lin unexpectedly_Adv = variants{} ; -- 
lin handy_A = variants{} ; -- 
lin deprivation_N = variants{} ; -- 
lin attacker_N = variants{} ; -- 
lin assault_V2 = variants{} ; -- 
lin screening_N = variants{} ; -- 
lin retired_A = variants{} ; -- 
lin quick_Adv = variants{} ; -- 
lin portable_A = variants{} ; -- 
lin hostage_N = variants{} ; -- 
lin underneath_Prep = variants{} ; -- 
lin jealous_A = variants{} ; -- 
lin proportional_A = variants{} ; -- 
lin gown_N = variants{} ; -- 
lin chimney_N = variants{} ; -- 
lin bleak_A = variants{} ; -- 
lin seasonal_A = variants{} ; -- 
lin plasma_N = variants{} ; -- 
lin stunning_A = variants{} ; -- 
lin spray_N = variants{} ; -- 
lin referral_N = variants{} ; -- 
lin promptly_Adv = variants{} ; -- 
lin fluctuation_N = variants{} ; -- 
lin decorative_A = variants{} ; -- 
lin unrest_N = variants{} ; -- 
lin resent_VS = variants{} ; -- 
lin resent_V2 = variants{} ; -- 
lin plaster_N = variants{} ; -- 
lin chew_V2 = variants{} ; -- 
lin chew_V = variants{} ; -- 
lin grouping_N = variants{} ; -- 
lin gospel_N = variants{} ; -- 
lin distributor_N = variants{} ; -- 
lin differentiation_N = variants{} ; -- 
lin blonde_A = variants{} ; -- 
lin aquarium_N = variants{} ; -- 
lin witch_N = variants{} ; -- 
lin renewed_A = variants{} ; -- 
lin jar_N = variants{} ; -- 
lin approved_A = variants{} ; -- 
lin advocateMasc_N = variants{} ; -- 
lin worrying_A = variants{} ; -- 
lin minimize_V2 = variants{} ; -- 
lin footstep_N = variants{} ; -- 
lin delete_V2 = variants{} ; -- 
lin underneath_Adv = variants{} ; -- 
lin lone_A = variants{} ; -- 
lin level_V2 = variants{} ; -- 
lin level_V = variants{} ; -- 
lin exceptionally_Adv = variants{} ; -- 
lin drift_N = variants{} ; -- 
lin spider_N = variants{} ; -- 
lin hectare_N = variants{} ; -- 
lin colonel_N = variants{} ; -- 
lin swimming_N = variants{} ; -- 
lin realism_N = variants{} ; -- 
lin insider_N = variants{} ; -- 
lin hobby_N = variants{} ; -- 
lin computing_N = variants{} ; -- 
lin infrastructure_N = variants{} ; -- 
lin cooperate_V = variants{} ; -- 
lin burn_N = variants{} ; -- 
lin cereal_N = variants{} ; -- 
lin fold_N = variants{} ; -- 
lin compromise_V2 = variants{} ; -- 
lin compromise_V = variants{} ; -- 
lin boxing_N = variants{} ; -- 
lin rear_V2 = variants{} ; -- 
lin rear_V = variants{} ; -- 
lin lick_V2 = variants{} ; -- 
lin constrain_V2 = variants{} ; -- 
lin clerical_A = variants{} ; -- 
lin hire_N = variants{} ; -- 
lin contend_VS = variants{} ; -- 
lin contend_V = variants{} ; -- 
lin amateurMasc_N = variants{} ; -- 
lin instrumental_A = variants{} ; -- 
lin terminal_A = variants{} ; -- 
lin electorate_N = variants{} ; -- 
lin congratulate_V2 = variants{} ; -- 
lin balanced_A = variants{} ; -- 
lin manufacturing_N = variants{} ; -- 
lin split_N = variants{} ; -- 
lin domination_N = variants{} ; -- 
lin blink_V2 = variants{} ; -- 
lin blink_V = variants{} ; -- 
lin bleed_VS = variants{} ; -- 
lin bleed_V2 = variants{} ; -- 
lin bleed_V = variants{} ; -- 
lin unlawful_A = variants{} ; -- 
lin precedent_N = variants{} ; -- 
lin notorious_A = variants{} ; -- 
lin indoor_A = variants{} ; -- 
lin upgrade_V2 = variants{} ; -- 
lin trench_N = variants{} ; -- 
lin therapist_N = variants{} ; -- 
lin illuminate_V2 = variants{} ; -- 
lin bargain_V2 = variants{} ; -- 
lin bargain_V = variants{} ; -- 
lin warranty_N = variants{} ; -- 
lin scar_V2 = variants{} ; -- 
lin scar_V = variants{} ; -- 
lin consortium_N = variants{} ; -- 
lin anger_V2 = variants{} ; -- 
lin insure_VS = variants{} ; -- 
lin insure_V2 = variants{} ; -- 
lin insure_V = variants{} ; -- 
lin extensively_Adv = variants{} ; -- 
lin appropriately_Adv = variants{} ; -- 
lin spoon_N = variants{} ; -- 
lin sideways_Adv = variants{} ; -- 
lin enhanced_A = variants{} ; -- 
lin disrupt_V2 = variants{} ; -- 
lin disrupt_V = variants{} ; -- 
lin satisfied_A = variants{} ; -- 
lin precaution_N = variants{} ; -- 
lin kite_N = variants{} ; -- 
lin instant_N = variants{} ; -- 
lin gig_N = variants{} ; -- 
lin continuously_Adv = variants{} ; -- 
lin consolidate_V2 = variants{} ; -- 
lin consolidate_V = variants{} ; -- 
lin fountain_N = variants{} ; -- 
lin graduate_V2 = variants{} ; -- 
lin graduate_V = variants{} ; -- 
lin gloom_N = variants{} ; -- 
lin bite_N = variants{} ; -- 
lin structure_V2 = variants{} ; -- 
lin noun_N = variants{} ; -- 
lin nomination_N = variants{} ; -- 
lin armchair_N = variants{} ; -- 
lin virtual_A = variants{} ; -- 
lin unprecedented_A = variants{} ; -- 
lin tumble_V2 = variants{} ; -- 
lin tumble_V = variants{} ; -- 
lin ski_N = variants{} ; -- 
lin architectural_A = variants{} ; -- 
lin violation_N = variants{} ; -- 
lin rocket_N = variants{} ; -- 
lin inject_V2 = variants{} ; -- 
lin departmental_A = variants{} ; -- 
lin row_V2 = variants{} ; -- 
lin row_V = variants{} ; -- 
lin luxury_A = variants{} ; -- 
lin fax_N = variants{} ; -- 
lin deer_N = variants{} ; -- 
lin climber_N = variants{} ; -- 
lin photographic_A = variants{} ; -- 
lin haunt_V2 = variants{} ; -- 
lin fiercely_Adv = variants{} ; -- 
lin dining_N = variants{} ; -- 
lin sodium_N = variants{} ; -- 
lin gossip_N = variants{} ; -- 
lin bundle_N = variants{} ; -- 
lin bend_N = variants{} ; -- 
lin recruit_N = variants{} ; -- 
lin hen_N = variants{} ; -- 
lin fragile_A = variants{} ; -- 
lin deteriorate_V2 = variants{} ; -- 
lin deteriorate_V = variants{} ; -- 
lin dependency_N = variants{} ; -- 
lin swift_A = variants{} ; -- 
lin scramble_V2 = variants{} ; -- 
lin scramble_V = variants{} ; -- 
lin overview_N = variants{} ; -- 
lin imprison_V2 = variants{} ; -- 
lin trolley_N = variants{} ; -- 
lin rotation_N = variants{} ; -- 
lin denial_N = variants{} ; -- 
lin boiler_N = variants{} ; -- 
lin amp_N = variants{} ; -- 
lin trivial_A = variants{} ; -- 
lin shout_N = variants{} ; -- 
lin overtake_V2 = variants{} ; -- 
lin make_N = variants{} ; -- 
lin hunter_N = variants{} ; -- 
lin guess_N = variants{} ; -- 
lin doubtless_Adv = variants{} ; -- 
lin syllable_N = variants{} ; -- 
lin obscure_A = variants{} ; -- 
lin mould_N = variants{} ; -- 
lin limestone_N = variants{} ; -- 
lin leak_V2 = variants{} ; -- 
lin leak_V = variants{} ; -- 
lin beneficiary_N = variants{} ; -- 
lin veteran_N = variants{} ; -- 
lin surplus_A = variants{} ; -- 
lin manifestation_N = variants{} ; -- 
lin vicar_N = variants{} ; -- 
lin textbook_N = variants{} ; -- 
lin novelist_N = variants{} ; -- 
lin halfway_Adv = variants{} ; -- 
lin contractual_A = variants{} ; -- 
lin swap_V2 = variants{} ; -- 
lin swap_V = variants{} ; -- 
lin guild_N = variants{} ; -- 
lin ulcer_N = variants{} ; -- 
lin slab_N = variants{} ; -- 
lin detector_N = variants{} ; -- 
lin detection_N = variants{} ; -- 
lin cough_V = variants{} ; -- 
lin whichever_Quant = variants{} ; -- 
lin spelling_N = variants{} ; -- 
lin lender_N = variants{} ; -- 
lin glow_N = variants{} ; -- 
lin raised_A = variants{} ; -- 
lin prolonged_A = variants{} ; -- 
lin voucher_N = variants{} ; -- 
lin t_shirt_N = variants{} ; -- 
lin linger_V = variants{} ; -- 
lin humble_A = variants{} ; -- 
lin honey_N = variants{} ; -- 
lin scream_N = variants{} ; -- 
lin postcard_N = variants{} ; -- 
lin managing_A = variants{} ; -- 
lin alien_A = variants{} ; -- 
lin trouble_V2 = variants{} ; -- 
lin reverse_N = variants{} ; -- 
lin odour_N = variants{} ; -- 
lin fundamentally_Adv = variants{} ; -- 
lin discount_V2 = variants{} ; -- 
lin discount_V = variants{} ; -- 
lin blast_V2 = variants{} ; -- 
lin blast_V = variants{} ; -- 
lin syntactic_A = variants{} ; -- 
lin scrape_V2 = variants{} ; -- 
lin scrape_V = variants{} ; -- 
lin residue_N = variants{} ; -- 
lin procession_N = variants{} ; -- 
lin pioneer_N = variants{} ; -- 
lin intercourse_N = variants{} ; -- 
lin deter_V2 = variants{} ; -- 
lin deadly_A = variants{} ; -- 
lin complement_V2 = variants{} ; -- 
lin restrictive_A = variants{} ; -- 
lin nitrogen_N = variants{} ; -- 
lin citizenship_N = variants{} ; -- 
lin pedestrian_N = variants{} ; -- 
lin detention_N = variants{} ; -- 
lin wagon_N = variants{} ; -- 
lin microphone_N = variants{} ; -- 
lin hastily_Adv = variants{} ; -- 
lin fixture_N = variants{} ; -- 
lin choke_V2 = variants{} ; -- 
lin choke_V = variants{} ; -- 
lin wet_V2 = variants{} ; -- 
lin weed_N = variants{} ; -- 
lin programming_N = variants{} ; -- 
lin power_V2 = variants{} ; -- 
lin nationally_Adv = variants{} ; -- 
lin dozen_N = variants{} ; -- 
lin carrot_N = variants{} ; -- 
lin bulletin_N = variants{} ; -- 
lin wording_N = variants{} ; -- 
lin vicious_A = variants{} ; -- 
lin urgency_N = variants{} ; -- 
lin spoken_A = variants{} ; -- 
lin skeleton_N = variants{} ; -- 
lin motorist_N = variants{} ; -- 
lin interactive_A = variants{} ; -- 
lin compute_V2 = variants{} ; -- 
lin compute_V = variants{} ; -- 
lin whip_N = variants{} ; -- 
lin urgently_Adv = variants{} ; -- 
lin telly_N = variants{} ; -- 
lin shrub_N = variants{} ; -- 
lin porter_N = variants{} ; -- 
lin ethics_N = variants{} ; -- 
lin banner_N = variants{} ; -- 
lin velvet_N = variants{} ; -- 
lin omission_N = variants{} ; -- 
lin hook_V2 = variants{} ; -- 
lin hook_V = variants{} ; -- 
lin gallon_N = variants{} ; -- 
lin financially_Adv = variants{} ; -- 
lin superintendent_N = variants{} ; -- 
lin plug_V2 = variants{} ; -- 
lin plug_V = variants{} ; -- 
lin continuation_N = variants{} ; -- 
lin reliance_N = variants{} ; -- 
lin justified_A = variants{} ; -- 
lin fool_V2 = variants{} ; -- 
lin detain_V2 = variants{} ; -- 
lin damaging_A = variants{} ; -- 
lin orbit_N = variants{} ; -- 
lin mains_N = variants{} ; -- 
lin discard_V2 = variants{} ; -- 
lin dine_V = variants{} ; -- 
lin compartment_N = variants{} ; -- 
lin revised_A = variants{} ; -- 
lin privatization_N = variants{} ; -- 
lin memorable_A = variants{} ; -- 
lin lately_Adv = variants{} ; -- 
lin distributed_A = variants{} ; -- 
lin disperse_V2 = variants{} ; -- 
lin disperse_V = variants{} ; -- 
lin blame_N = variants{} ; -- 
lin basement_N = variants{} ; -- 
lin slump_V2 = variants{} ; -- 
lin slump_V = variants{} ; -- 
lin puzzle_V2 = variants{} ; -- 
lin monitoring_N = variants{} ; -- 
lin talented_A = variants{} ; -- 
lin nominal_A = variants{} ; -- 
lin mushroom_N = variants{} ; -- 
lin instructor_N = variants{} ; -- 
lin fork_N = variants{} ; -- 
lin fork_4_N = variants{} ; -- 
lin fork_3_N = variants{} ; -- 
lin fork_1_N = variants{} ; -- 
lin board_V2 = variants{} ; -- 
lin want_N = variants{} ; -- 
lin disposition_N = variants{} ; -- 
lin cemetery_N = variants{} ; -- 
lin attempted_A = variants{} ; -- 
lin nephew_N = variants{} ; -- 
lin magical_A = variants{} ; -- 
lin ivory_N = variants{} ; -- 
lin hospitality_N = variants{} ; -- 
lin besides_Prep = variants{} ; -- 
lin astonishing_A = variants{} ; -- 
lin tract_N = variants{} ; -- 
lin proprietor_N = variants{} ; -- 
lin license_V2 = variants{} ; -- 
lin differential_A = variants{} ; -- 
lin affinity_N = variants{} ; -- 
lin talking_N = variants{} ; -- 
lin royalty_N = variants{} ; -- 
lin neglect_N = variants{} ; -- 
lin irrespective_A = variants{} ; -- 
lin whip_V2 = variants{} ; -- 
lin whip_V = variants{} ; -- 
lin sticky_A = variants{} ; -- 
lin regret_N = variants{} ; -- 
lin incapable_A = variants{} ; -- 
lin franchise_N = variants{} ; -- 
lin dentist_N = variants{} ; -- 
lin contrary_N = variants{} ; -- 
lin profitability_N = variants{} ; -- 
lin enthusiast_N = variants{} ; -- 
lin crop_V2 = variants{} ; -- 
lin crop_V = variants{} ; -- 
lin utter_V2 = variants{} ; -- 
lin pile_V2 = variants{} ; -- 
lin pile_V = variants{} ; -- 
lin pier_N = variants{} ; -- 
lin dome_N = variants{} ; -- 
lin bubble_N = variants{} ; -- 
lin treasurer_N = variants{} ; -- 
lin stocking_N = variants{} ; -- 
lin sanctuary_N = variants{} ; -- 
lin ascertain_V2 = variants{} ; -- 
lin arc_N = variants{} ; -- 
lin quest_N = variants{} ; -- 
lin mole_N = variants{} ; -- 
lin marathon_N = variants{} ; -- 
lin feast_N = variants{} ; -- 
lin crouch_V = variants{} ; -- 
lin storm_V2 = variants{} ; -- 
lin storm_V = variants{} ; -- 
lin hardship_N = variants{} ; -- 
lin entitlement_N = variants{} ; -- 
lin circular_N = variants{} ; -- 
lin walking_A = variants{} ; -- 
lin strap_N = variants{} ; -- 
lin sore_A = variants{} ; -- 
lin complementary_A = variants{} ; -- 
lin understandable_A = variants{} ; -- 
lin noticeable_A = variants{} ; -- 
lin mankind_N = variants{} ; -- 
lin majesty_N = variants{} ; -- 
lin pigeon_N = variants{} ; -- 
lin goalkeeper_N = variants{} ; -- 
lin ambiguous_A = variants{} ; -- 
lin walker_N = variants{} ; -- 
lin virgin_N = variants{} ; -- 
lin prestige_N = variants{} ; -- 
lin preoccupation_N = variants{} ; -- 
lin upset_A = variants{} ; -- 
lin municipal_A = variants{} ; -- 
lin groan_V2 = variants{} ; -- 
lin groan_V = variants{} ; -- 
lin craftsman_N = variants{} ; -- 
lin anticipation_N = variants{} ; -- 
lin revise_V2 = variants{} ; -- 
lin revise_V = variants{} ; -- 
lin knock_N = variants{} ; -- 
lin infect_V2 = variants{} ; -- 
lin infect_V = variants{} ; -- 
lin denounce_V2 = variants{} ; -- 
lin confession_N = variants{} ; -- 
lin turkey_N = variants{} ; -- 
lin toll_N = variants{} ; -- 
lin pal_N = variants{} ; -- 
lin transcription_N = variants{} ; -- 
lin sulphur_N = variants{} ; -- 
lin provisional_A = variants{} ; -- 
lin hug_V2 = variants{} ; -- 
lin particular_N = variants{} ; -- 
lin intent_A = variants{} ; -- 
lin fascinate_V2 = variants{} ; -- 
lin conductor_N = variants{} ; -- 
lin feasible_A = variants{} ; -- 
lin vacant_A = variants{} ; -- 
lin trait_N = variants{} ; -- 
lin meadow_N = variants{} ; -- 
lin creed_N = variants{} ; -- 
lin unfamiliar_A = variants{} ; -- 
lin optimism_N = variants{} ; -- 
lin wary_A = variants{} ; -- 
lin twist_N = variants{} ; -- 
lin sweet_N = variants{} ; -- 
lin substantive_A = variants{} ; -- 
lin excavation_N = variants{} ; -- 
lin destiny_N = variants{} ; -- 
lin thick_Adv = variants{} ; -- 
lin pasture_N = variants{} ; -- 
lin archaeological_A = variants{} ; -- 
lin tick_V2 = variants{} ; -- 
lin tick_V = variants{} ; -- 
lin profit_V2 = variants{} ; -- 
lin profit_V = variants{} ; -- 
lin pat_V2 = variants{} ; -- 
lin pat_V = variants{} ; -- 
lin papal_A = variants{} ; -- 
lin cultivate_V2 = variants{} ; -- 
lin awake_V = variants{} ; -- 
lin trained_A = variants{} ; -- 
lin civic_A = variants{} ; -- 
lin voyage_N = variants{} ; -- 
lin siege_N = variants{} ; -- 
lin enormously_Adv = variants{} ; -- 
lin distract_V2 = variants{} ; -- 
lin distract_V = variants{} ; -- 
lin stroll_V = variants{} ; -- 
lin jewel_N = variants{} ; -- 
lin honourable_A = variants{} ; -- 
lin helpless_A = variants{} ; -- 
lin hay_N = variants{} ; -- 
lin expel_V2 = variants{} ; -- 
lin eternal_A = variants{} ; -- 
lin demonstrator_N = variants{} ; -- 
lin correction_N = variants{} ; -- 
lin civilization_N = variants{} ; -- 
lin ample_A = variants{} ; -- 
lin retention_N = variants{} ; -- 
lin rehabilitation_N = variants{} ; -- 
lin premature_A = variants{} ; -- 
lin encompass_V2 = variants{} ; -- 
lin distinctly_Adv = variants{} ; -- 
lin diplomat_N = variants{} ; -- 
lin articulate_V2 = variants{} ; -- 
lin articulate_V = variants{} ; -- 
lin restricted_A = variants{} ; -- 
lin prop_V2 = variants{} ; -- 
lin intensify_V2 = variants{} ; -- 
lin intensify_V = variants{} ; -- 
lin deviation_N = variants{} ; -- 
lin contest_V2 = variants{} ; -- 
lin contest_V = variants{} ; -- 
lin workplace_N = variants{} ; -- 
lin lazy_A = variants{} ; -- 
lin kidney_N = variants{} ; -- 
lin insistence_N = variants{} ; -- 
lin whisper_N = variants{} ; -- 
lin multimedia_N = variants{} ; -- 
lin forestry_N = variants{} ; -- 
lin excited_A = variants{} ; -- 
lin decay_N = variants{} ; -- 
lin screw_N = variants{} ; -- 
lin rally_V2V = variants{} ; -- 
lin rally_V2 = variants{} ; -- 
lin rally_V = variants{} ; -- 
lin pest_N = variants{} ; -- 
lin invaluable_A = variants{} ; -- 
lin homework_N = variants{} ; -- 
lin harmful_A = variants{} ; -- 
lin bump_V2 = variants{} ; -- 
lin bump_V = variants{} ; -- 
lin bodily_A = variants{} ; -- 
lin grasp_N = variants{} ; -- 
lin finished_A = variants{} ; -- 
lin facade_N = variants{} ; -- 
lin cushion_N = variants{} ; -- 
lin conversely_Adv = variants{} ; -- 
lin urge_N = variants{} ; -- 
lin tune_V2 = variants{} ; -- 
lin tune_V = variants{} ; -- 
lin solvent_N = variants{} ; -- 
lin slogan_N = variants{} ; -- 
lin petty_A = variants{} ; -- 
lin perceived_A = variants{} ; -- 
lin install_V2 = variants{} ; -- 
lin install_V = variants{} ; -- 
lin fuss_N = variants{} ; -- 
lin rack_N = variants{} ; -- 
lin imminent_A = variants{} ; -- 
lin short_N = variants{} ; -- 
lin revert_V = variants{} ; -- 
lin ram_N = variants{} ; -- 
lin contraction_N = variants{} ; -- 
lin tread_V2 = variants{} ; -- 
lin tread_V = variants{} ; -- 
lin supplementary_A = variants{} ; -- 
lin ham_N = variants{} ; -- 
lin defy_V2V = variants{} ; -- 
lin defy_V2 = variants{} ; -- 
lin athlete_N = variants{} ; -- 
lin sociological_A = variants{} ; -- 
lin physician_N = variants{} ; -- 
lin crossing_N = variants{} ; -- 
lin bail_N = variants{} ; -- 
lin unwanted_A = variants{} ; -- 
lin tight_Adv = variants{} ; -- 
lin plausible_A = variants{} ; -- 
lin midfield_N = variants{} ; -- 
lin alert_A = variants{} ; -- 
lin feminine_A = variants{} ; -- 
lin drainage_N = variants{} ; -- 
lin cruelty_N = variants{} ; -- 
lin abnormal_A = variants{} ; -- 
lin relate_N = variants{} ; -- 
lin poison_V2 = variants{} ; -- 
lin symmetry_N = variants{} ; -- 
lin stake_V2 = variants{} ; -- 
lin rotten_A = mkA "mħassar" "mħassra" "mħassrin" ;
lin prone_A = variants{} ; -- 
lin marsh_N = variants{} ; -- 
lin litigation_N = variants{} ; -- 
lin curl_N = variants{} ; -- 
lin urine_N = variants{} ; -- 
lin latin_A = variants{} ; -- 
lin hover_V = variants{} ; -- 
lin greeting_N = variants{} ; -- 
lin chase_N = variants{} ; -- 
lin spouseMasc_N = variants{} ; -- 
lin produce_N = variants{} ; -- 
lin forge_V2 = variants{} ; -- 
lin forge_V = variants{} ; -- 
lin salon_N = variants{} ; -- 
lin handicapped_A = variants{} ; -- 
lin sway_V2 = variants{} ; -- 
lin sway_V = variants{} ; -- 
lin homosexual_A = variants{} ; -- 
lin handicap_V2 = variants{} ; -- 
lin colon_N = variants{} ; -- 
lin upstairs_N = variants{} ; -- 
lin stimulation_N = variants{} ; -- 
lin spray_V2 = variants{} ; -- 
lin original_N = variants{} ; -- 
lin lay_A = variants{} ; -- 
lin garlic_N = variants{} ; -- 
lin suitcase_N = variants{} ; -- 
lin skipper_N = variants{} ; -- 
lin moan_VS = variants{} ; -- 
lin moan_V = variants{} ; -- 
lin manpower_N = variants{} ; -- 
lin manifest_V2 = variants{} ; -- 
lin incredibly_Adv = variants{} ; -- 
lin historically_Adv = variants{} ; -- 
lin decision_making_N = variants{} ; -- 
lin wildly_Adv = variants{} ; -- 
lin reformer_N = variants{} ; -- 
lin quantum_N = variants{} ; -- 
lin considering_Subj = variants{} ; -- 
}
