--# -path=.:src/finnish/stemmed:src/finnish:src/abstract:src/common:src/finnish/kotus:src/api
---- checked by AR till beginning_N in the BNC order
concrete TopDictionaryFin of TopDictionary = CatFin ** open ParadigmsFin,
  (S = StructuralFin),
  (L = LexiconFin),
  (R = ResFin),
  MorphoFin, ParadigmsFin, (E = ExtraFin), Kotus, WNKotus, StemFin, Prelude in {

flags coding=utf8 ; 

oper tehda_V = mkV (lin VK {s = c71 "tehdä"}) ; 
oper nahda_V = mkV (lin VK {s = c71 "nähdä"}) ; 
oper optProDrop : Pron -> Pron = \p -> p | E.ProDrop p ;
oper luokse_Prep : Prep = mkPrep "luokse" ; -- to enable (luo|luokse)-luokseni

  mika_NForms : R.NForm => Str = 
    let {
      mi  = snoun2nounBind (mkN "mi")
    } in
    table {
       NCase Sg Nom  => "mikä" ;
       NCase Pl Nom  => "mitkä" ;
       NCase _ Gen   => "minkä" ;
       NCase _ Part  => "mitä" ;
       NCase _ Illat => "mihin" ;
       c => mi.s ! c
       } ;


lin of_Prep = casePrep genitive ; ---
lin and_Conj = S.and_Conj ;
lin in_Prep = S.in_Prep ;
lin have_VV = S.must_VV ;
lin have_V2 = S.have_V2 ;
lin have_V = lin V S.have_V2 ;
lin it_Pron = S.it_Pron ;
lin to_Prep = mkPrep illative | mkPrep allative ; ---- | luokse_Prep | luokse_Prep ** {s = luokse_Prep.s ** {p2 = "luo"}} | mkPrep "tykö" ;
lin for_Prep = S.for_Prep ;
lin i_Pron = optProDrop S.i_Pron ;
lin iFem_Pron = optProDrop S.i_Pron ;
lin that_Subj = S.that_Subj ;
lin he_Pron = S.he_Pron ;
lin on_Prep = mkPrep adessive | mkPrep "päällä" | mkPrep "päälle" ;
lin with_Prep = mkPrep "kanssa" | mkPrep "luona" | mkPrep "tykönä" ; ---- split
lin do_V2 = mkV2 tehda_V ;
lin at_Prep = casePrep adessive | casePrep inessive ; ---- | mkPrep "luona" | mkPrep "tykönä" ; ---- split
lin by_Prep = postPrep genitive "kautta" ;
lin but_Conj = mkConj "mutta" ;
lin from_Prep = casePrep elative | casePrep ablative | mkPrep "luota" | mkPrep "tyköä" ; ---- split
lin they_Pron = S.they_Pron ;
lin theyFem_Pron = S.they_Pron ;
lin she_Pron = S.she_Pron ;
lin or_Conj = S.or_Conj ;
lin as_Subj = mkSubj "kun" ;
lin we_Pron = optProDrop S.we_Pron ;
lin weFem_Pron = optProDrop S.we_Pron ;
lin say_VS = L.say_VS ;
lin say_V2 = mkV2 "sanoa" ;
lin say_V = mkV "sanoa" ;
lin if_Subj = S.if_Subj ;
lin go_VV = mkVV (mkV "aikoa") ; ---- subcat
lin go_VA = mkVA (mkV "käydä") (casePrep translative) ;
lin go_V = L.go_V ;
lin get_VV = mkVV "päätyä" infIllat ;
lin get_V2V = mkV2V (mkV "saada") accusative infIllat ;
lin make_V2V = mkV2V (mkV "saada") accusative ;
lin make_V2A = mkV2A tehda_V accusative (mkPrep translative) ;
lin make_V2 = mkV2 tehda_V ;
lin make_V = tehda_V ;
lin as_Prep = casePrep essive ;
lin out_Adv = mkWAdv (k99 "ulkona") ;
lin up_Adv = mkAdv "ylös" | mkAdv "ylhäällä" ;
lin see_VS = mkVS (mkV (mkV "pitää") "huolta") ;
lin see_VQ = mkVQ nahda_V ;
lin see_V2V = mkV2V nahda_V (mkPrep genitive) infPresPart ;
lin see_V2 = L.see_V2 ;
lin see_V = nahda_V ;
lin know_VS = L.know_VS ;
lin know_VQ = L.know_VQ ;
lin know_V2 = L.know_V2 ;
lin know_V = mkV "tietää" ;
lin time_N = mkN "aika" "ajan" "aikoja" ;
lin time_2_N = mkN "kerta" ;
lin time_1_N = mkN "aika" "ajan" "aikoja" ;
lin take_V2 = mkV2 "ottaa" ;
lin so_Adv = mkAdv "niin" ;
lin year_N = L.year_N ;
lin into_Prep = casePrep illative | mkPrep "sisään" | mkPrep "sisälle" ;
lin then_Adv = mkAdv "silloin" ; -- mkAdv "siinä tapauksessa"
lin think_VS = mkVS (mkV "ajatella") ;
lin think_V2 = mkV2 (mkV "ajatella") partitive ;
lin think_V = L.think_V ;
lin come_V = L.come_V ;
lin than_Subj = mkSubj "kuin" ;
lin more_Adv = mkWAdv (k99 "enemmän") ;
lin about_Prep = casePrep elative ;
lin now_Adv = L.now_Adv ;
lin last_A = mkA "viimeinen" ;
lin last_1_A = mkA "viimeinen" ;
lin last_2_A = invarA "viime" ;
lin other_A = mkA "muu" ;
lin give_V3 = L.give_V3 ;
lin give_V2 = mkV2 "antaa" ;
lin give_V = mkV "antaa" ;
lin just_Adv = mkAdv "juuri" ;
lin people_N = mkN "kansa" ;
lin also_Adv = mkAdv "myös" | mkAdv "lisäksi" ;
lin well_Adv = mkAdv "hyvin" ;
lin only_Adv = mkAdv "vain" ;
lin new_A = L.new_A ;
lin when_Subj = S.when_Subj ;
lin way_N = mkN "tie" ;
lin way_2_N = mkN "tapa" ;
lin way_1_N = mkN "tie" ;
lin look_VA = mkVA (mkV "näyttää") (mkPrep ablative) ;
lin look_V2 = mkV2 (mkV "näyttää") (mkPrep ablative) ;
lin look_V = mkV "katsoa" ;
lin like_Prep = postPrep genitive "tavalla" | mkPrep nominative "kuin" ;
lin use_VV = mkVV "tavata" ;
lin use_V2 = mkV2 "käyttää" partitive ;
lin use_V = mkV "käyttää" ;
lin because_Subj = S.because_Subj ;
lin good_A = L.good_A ;
lin find_VS = mkVS (mkV "huomata") ; --?
lin find_V2A = mkV2A (mkV "pitää") (mkPrep partitive) (mkPrep essive) ; --WV2A (k54A "löytää") ;
lin find_V2 = L.find_V2 ;
lin find_V = mkV "löytää" "löysi" ;
lin man_N = L.man_N ;
lin want_VV = S.want_VV ;
lin want_V2V = mkWV2V (k75 "haluta") ;
lin want_V2 = mkWV2 (k75 "haluta") ;
lin want_V = mkWV (k75 "haluta") ;
lin day_N = L.day_N ;
lin between_Prep = S.between_Prep ;
lin even_Adv = mkAdv "jopa" ;
lin there_Adv = S.there_Adv ;
lin many_Det = S.many_Det ;
lin after_Prep = S.after_Prep ;
lin down_Adv = mkAdv "alhaalla" | mkAdv "alas" ;
lin yeah_Interj = mkInterj "joo" ; --mkInterj "yess" ;
lin so_Subj = mkSubj "niin että" ;
lin thing_N = mkN "asia" ;
lin tell_VS = mkVS (mkV "kertoa") ;
lin tell_V3 = mkV3 (mkV "kertoa") accusative (casePrep allative) ;
lin tell_1_V3 = mkV3 (mkV "erottaa") accusative (casePrep elative) ;
lin tell_2_V3 = mkV3 (mkV "kertoa") accusative (casePrep allative) ;
lin tell_V2V = mkV2V (mkV "kertoa") genitive infPresPart ;
lin tell_V2S = mkV2S (mkV "kertoa") (mkPrep allative) ;
lin tell_V2 = mkV2 "kertoa" ;
lin tell_V = mkV "kertoa" ;
lin through_Prep = S.through_Prep ;
lin back_Adv = mkAdv "takaisin" ;
lin still_Adv = mkAdv "yhä" ;
lin child_N = L.child_N ;
lin here_Adv = mkAdv "täällä" ;
lin over_Prep = postPrep genitive "yli" ;
lin too_Adv = mkAdv "myös" ;
lin put_V2 = L.put_V2 ;
lin on_Adv = mkAdv "päällä" ;
lin no_Interj = mkInterj "ei" | mkInterj "en" ;
lin work_V2 = mkV2 "työstää" ;
lin work_V = mkV "toimia" ;
lin work_2_V = mkV "toimia" ;
lin work_1_V = mkV "työskennellä" ;
lin become_VA = L.become_VA ;
lin become_V2 = mkV2 "tulla" translative ;
lin become_V = caseV elative (mkV "tulla") ; --hänestä tuli
lin old_A = L.old_A ;
lin government_N = mkN "hallitus" ;
lin mean_VV = mkVV (mkV "ajatella") ;
lin mean_VS = mkVS (mkV "tarkoittaa") ;
lin mean_V2V = mkV2V (mkV "tarkoittaa") (mkPrep genitive) infPresPart ;
lin mean_V2 = mkV2 "tarkoittaa" partitive ;
lin part_N = mkN "osa" ;
lin leave_V2V = mkV2V (mkV "jättää") accusative ;
lin leave_V2 = L.leave_V2 ;
lin leave_V = mkV "lähteä" ;
lin life_N = mkN "elämä" ;
lin great_A = mkA "hieno" | mkA "suurenmoinen" ;
lin case_N = mkN "tapaus" ;
lin woman_N = L.woman_N ;
lin over_Adv = mkAdv "ohi" | mkAdv "yli" ; ---- split
lin seem_VV = mkVV (mkV "vaikuttaa") infPresPart ;
lin seem_VS = mkVS (mkV "vaikuttaa") ;
lin seem_VA = mkVA (mkV "näyttää") (casePrep ablative) ;
lin work_N = mkN "työ" ;
lin need_VV = mkVV (caseV genitive (mkV "tarvita")) ;
lin need_VV = mkVV (caseV genitive (mkV "tarvita")) ;
lin need_V2 = mkV2 (mkV "tarvita") partitive ;
lin need_V = mkV "tarvita" ;
lin feel_VS = mkVS "tuntea" ;
lin feel_VA = mkVA (caseV elative (mkV "tuntua")) (mkPrep ablative) ;
lin feel_V2 = mkV2 "tuntea" ;
lin feel_V = mkV "tuntea" ;
lin system_N = mkN "järjestelmä" | mkN "systeemi" ;
lin each_Det = mkDet Sg (mkN "jokainen") ;
lin may_2_VV = mkVV (mkV "saada") ;
lin may_1_VV = mkVV (mkV "saattaa") ;
lin much_Adv = mkAdv "paljon" ;
lin ask_VQ = mkVQ (mkV "kysyä") ;
lin ask_V2V = mkV2V (mkV "pyytää" "pyysi") ;
lin ask_V2 = mkV2 (mkV "kysyä") ;
lin ask_V = mkV "kysyä" ;
lin group_N = mkN "ryhmä" ;
lin number_N = mkN "luku" ; --- split already
lin number_3_N = mkN "luku" ;
lin number_2_N = mkN "luku" (mkN "määrä") | mkN "määrä" ;
lin number_1_N = mkN "luku" ;
lin yes_Interj = mkInterj "kyllä" ;
lin however_Adv = mkAdv "kuitenkin" ;
lin another_Det = mkDet Sg (mkN "toinen") ;
lin again_Adv = mkAdv "taas" | mkAdv "uudelleen" ;
lin world_N = mkWN (k13 "maailma") ;
lin area_N = mkWN (k48 "alue") ;
lin area_6_N = mkN "pinta-" (mkN "ala") ;
lin area_5_N = mkN "alue" ;
lin area_4_N = mkN "ala" ;
lin area_3_N = mkN "alue" ;
lin area_2_N = mkN "ala" ;
lin area_1_N = mkN "alue" ;
lin show_VS = mkVS (mkV "osoittaa") ;
lin show_VQ = mkVQ (mkV "vahvistaa") ; ---- subcat
lin show_V2 = mkV2 "näyttää" ;
lin show_V = mkV "näyttää" ;
lin course_N = mkN "kurssi" ;
lin company_2_N = mkN "seura" ;
lin company_1_N = mkN "yhtiö" ;
lin under_Prep = S.under_Prep ;
lin problem_N = mkN "ongelma" ;
lin against_Prep = postPrep partitive "vastaan" ;
lin never_Adv = mkAdv "ei koskaan" | mkAdv "koskaan" ; ---- will look weird in sentences
lin most_Adv = mkAdv "suurin osa" ;
lin service_N = mkWN (k2 "palvelu") ;
lin try_VV = mkVV (mkV "yrittää") ;
lin try_V2 = mkV2 (mkV "syyttää") ;
lin try_V = mkV "kokeilla" ;
lin call_V2 = mkV2 (mkV "soittaa") (casePrep allative) ;
lin call_V = mkV "soittaa" ; --mkV "kutsua" ;
lin hand_N = L.hand_N ;
lin party_N = mkN "puolue" ;
lin party_2_N = mkN "puolue" ;
lin party_1_N = mkN "juhla" ;
lin high_A = mkA "korkea" ;
lin about_Adv = mkAdv "suunnilleen" ;
lin something_NP = S.something_NP ;
lin school_N = L.school_N ;
lin in_Adv = mkAdv "sisään" ; --- already split
lin in_1_Adv = mkAdv "sisällä" ;
lin in_2_Adv = mkAdv "sisään" ;
lin small_A = L.small_A ;
lin place_N = mkN "paikka" ;
lin before_Prep = S.before_Prep ;
lin while_Subj = mkSubj "samalla kun" ;
lin away_Adv = mkAdv "pois" ;
lin away_2_Adv = mkAdv "pois" ;
lin away_1_Adv = mkAdv "poissa" ;
lin keep_VV = mkVV "jatkaa" ; ---- ??? puhumista ; add more Inf3s in ParadigmsFin
lin keep_V2A = mkV2A (mkV "säilyttää") accusative (mkPrep essive) ;
lin keep_V2 = mkV2 "pitää" ;
lin keep_V = mkV "pysyä" ;
lin point_N = mkN "piste" ;
lin point_2_N = mkN "pointti" ;
lin point_1_N = mkN "piste" ;
lin house_N = L.house_N ;
lin different_A = mkA "erilainen" ;
lin country_N = L.country_N ;
lin really_Adv = mkAdv "todella" ;
lin provide_V2 = mkV2 "tarjota" partitive ;
lin provide_V = mkWV (k52A "varautua") ;
lin week_N = mkN "viikko" ;
lin hold_VS = mkVS "katsoa" ; --hän katsoo, että XYZ
lin hold_V2 = L.hold_V2 ;
lin hold_V = mkV "pitää" ;
lin large_A = mkA "suuri" ;
lin member_N = mkN "jäsen" ;
lin off_Adv = mkAdv "pois" ;
lin always_Adv = mkAdv "aina" ;
lin follow_VS = mkVS (caseV elative (mkV "seurata")) ; --siitä seuraa, että
lin follow_V2 = mkV2 (mkV "seurata") partitive ;
lin follow_V = mkV "seurata" ;
lin without_Prep = S.without_Prep ;
lin turn_VA = mkVA (mkV "muuttua") (mkPrep translative) ;
lin turn_V2 = mkV2 "kääntää" partitive | mkV2 (mkV "kääntää") accusative ;
lin turn_V = L.turn_V ;
lin end_N = mkN "loppu" ;
lin end_2_N = mkN "pää" | mkN "perä" ;
lin end_1_N = mkN "loppu" ;
lin within_Prep = postPrep genitive "sisällä" ;
lin local_A = mkA "paikallinen" ;
lin where_Subj = mkSubj "missä" ;
lin during_Prep = S.during_Prep ;
lin bring_V3 = mkV3 (mkV "saattaa") accusative (mkPrep illative) ; --saattaa hänet vankilaan
lin bring_V2 = mkV2 "tuoda" ;
lin most_Det = mkDet Pl (mkN "usein" "useimman" "useimpia") ;
lin word_N = mkN "sana" ;
lin begin_V2 = mkV2 "aloittaa" ;
lin begin_V = mkV "alkaa" "alkoi" ;
lin although_Subj = S.although_Subj ;
lin example_N = mkN "esimerkki" ;
lin next_Adv = mkAdv "seuraavaksi" ;
lin family_N = mkWN (k48 "perhe") ;
lin rather_Adv = mkAdv "mieluummin" ;
lin fact_N = mkN "tosiasia" ;
lin like_VV = mkVV "tykätä" ; ---- need more inf forms; "pidän kutomisesta" rather than "tykkään kutoa"
lin like_VS = mkVS (mkV (mkV "pitää") "siitä") ; -- pidän siitä, että XYZ
lin like_V2 = L.like_V2 ;
lin social_A = mkWA (k38 "sosiaalinen") ;
lin write_VS = mkWVS (k53A "kirjoittaa") ;
lin write_V2 = L.write_V2 ;
lin write_V = mkWV (k53A "kirjoittaa") ;
lin state_N = mkN "valtio" ;
lin state_2_N = mkN "tila" ;
lin state_1_N = mkN "valtio" ;
lin percent_N = mkWN (k5A "prosentti") ;
lin quite_Adv = S.quite_Adv ;
lin both_Det = mkDet Pl (mkN "molempi" "molemman" "molempia") ;
lin start_V2 = mkV2 "aloittaa" ;
lin start_V = mkV "aloittaa" ;
lin run_V2 = mkV2 (mkV "suorittaa") accusative | mkV2 "pitää" ; --- split
lin run_V = L.run_V ;
lin long_A = L.long_A ;
lin right_Adv = mkAdv "oikein" ;
lin right_2_Adv = mkAdv "oikealle" | mkAdv "oikealla" ; --- split
lin right_1_Adv = mkAdv "oikeassa" ;
lin set_V2 = mkV2 "asettaa" ;
lin help_V2V = mkWV2V (mkV "auttaa") ;
lin help_V2 = mkV2 "auttaa" partitive ;
lin help_V = mkV "auttaa" ;
lin every_Det = S.every_Det ;
lin home_N = mkN "koti" ;
lin month_N = mkN "kuukausi" "kuukauden" "kuukausia" ;
lin side_N = mkWN (k26 "puoli") ;
lin night_N = L.night_N ;
lin important_A = L.important_A ;
lin eye_N = L.eye_N ;
lin head_N = L.head_N ;
lin information_N = mkN "informaatio" ;
lin question_N = L.question_N ;
lin business_N = mkN "liikeasia" ;
lin play_V2 = L.play_V2 ;
lin play_V = L.play_V ;
lin play_3_V2 = mkV2 "soittaa" partitive ;
lin play_3_V = mkV "soittaa" ;
lin play_2_V2 = mkV2 "leikkiä" partitive ;
lin play_2_V = mkV "leikkiä" ;
lin play_1_V2 = mkV2 "pelata" partitive ;
lin play_1_V = mkV "pelata" ;
lin power_N = mkN "teho" ;
lin money_N = mkN "raha" ;
lin change_N = mkN "muutos" ;
lin move_V2 = mkV2 "siirtää" | mkV2 "liikuttaa" ;
lin move_V = mkV "liikkua" ;
lin move_2_V = mkV "muuttaa" ;
lin move_1_V = mkV "liikkua" ;
lin interest_N = mkN "korko" ;
lin interest_4_N = mkN "kiinnostus" ; ---- sense
lin interest_2_N = mkN "korko" ;
lin interest_1_N = mkN "kiinnostus" | mkN "mielenkiinto" ;
lin order_N = mkN "järjestys" ;
lin book_N = L.book_N ;
lin often_Adv = mkAdv "usein" ;
lin development_N = mkN "kehitys" ;
lin young_A = L.young_A ;
lin national_A = mkA "kansallinen" ;
lin pay_V3 = mkV3 (mkV "osoittaa") (mkPrep partitive) (mkPrep allative) ; --osoittaa huomiota hänelle
lin pay_V2V = mkV2V (mkV "maksaa") accusative infIllat ; ---- subcat ("maksan hänet laulamaan"? if you have better ideas go ahead and change!)
lin pay_V2 = mkV2 "maksaa" ;
lin pay_V = mkV "kannattaa" ;
lin hear_VS = mkVS (mkV "kuulla") | mkVS (mkV (mkV "saada") "tietää") ;
lin hear_V2V = mkV2V (mkV "kuulla") genitive infPresPart ; --kuulin hänen tehneen
lin hear_V2 = L.hear_V2 ;
lin hear_V = mkV "kuulla" ;
lin room_N = mkWN (k48 "huone") ;
lin room_1_N = mkN "huone" ;
lin room_2_N = mkN "tila" ;
lin whether_Subj = mkSubj "josko" ;
lin water_N = L.water_N ;
lin form_N = mkWN (k1A "muoto") ;
lin car_N = L.car_N ;
lin other_N = mkN "toinen" ;
lin yet_Adv = mkAdv "vielä" ;
lin yet_2_Adv = mkAdv "kuitenkin" ;
lin yet_1_Adv = mkAdv "vielä" ;
lin perhaps_Adv = mkAdv "ehkä" ;
lin meet_V2 = mkV2 "tavata" ;
lin meet_V = mkV "kokoontua" ;
lin level_N = mkN "taso" ;
lin level_2_N = mkN "taso" ;
lin level_1_N = mkN "taso" ;
lin until_Subj = lin Subj (ss "kunnes") ;
lin though_Subj = mkSubj "vaikka" ;
lin policy_N = mkN "politiikka" ;
lin include_V2 = mkV2 "sisältää" | mkV2 "sisällyttää" ;
lin include_V = mkV "sisältää" ;
lin believe_VS = mkVS (mkV "uskoa") ;
lin believe_V2 = mkV2 "uskoa" illative ;
lin believe_V = mkV "uskoa" ;
lin council_N = mkN "neuvosto" ;
lin already_Adv = L.already_Adv ;
lin possible_A = mkWA (k38 "mahdollinen") ;
lin nothing_NP = S.nothing_NP ** {s = \\c => "ei" ++ S.nothing_NP.s ! c} ;
lin line_N = mkN "linja" ;
lin allow_V2V = mkV2Vf (mkV "sallia") (mkPrep genitive) infFirst ;
lin allow_V2 = mkV2 "hyväksyä" | mkV2 "sallia" ;
lin need_N = mkWN (k48A "tarve") ;
lin effect_N = mkN "vaikutus" ;
lin big_A = L.big_A ;
lin use_N = mkN "käyttö" ;
lin lead_V2V = mkV2V (mkV "ajaa") accusative infIllat ;
lin lead_V2 = mkV2 "johtaa" partitive ;
lin lead_V = mkV "johtaa" ;
lin stand_V2 = mkV2 (mkV "kestää") ;
lin stand_V = L.stand_V ;
lin idea_N = mkN "idea" "ideoita" ;
lin study_N = mkN "opiskelu" | mkN "tutkimus" ; ---- split
lin lot_N = mkN "paljous" | mkWN (k9A "arpa") ; ---- split
lin live_V = L.live_V ;
lin job_N = mkN "työ" | mkN "työpaikka" ;
lin since_Subj = mkSubj "siitä lähtien kun" ;
lin name_N = L.name_N ;
lin result_N = mkN "tulos" ;
lin body_N = mkN "ruumis" ;
lin happen_VV = mkVV "sattua" infIllat ;
lin happen_V = mkV "tapahtua" ;
lin friend_N = L.friend_N ;
lin right_N = mkN "oikeus" | mkN "oikea" ; ---- split
lin least_Adv = mkAdv "vähiten" ;
lin right_A = mkWA (k15 "oikea") ;
lin right_2_A = mkA "oikea" ;
lin right_1_A = mkA "oikea" ;
lin almost_Adv = mkAdv "melkein" | mkAdv "lähes" ;
lin much_Det = S.much_Det ;
lin carry_V2 = mkV2 (mkV "kantaa") partitive ;
lin carry_V = mkV "kantaa" ;
lin authority_N = mkN "viranomainen" ;
lin authority_2_N = mkN "viranomainen" ;
lin authority_1_N = mkN "auktoriteetti" ;
lin long_Adv = mkAdv "kauan" | mkAdv "pitkään" ;
lin early_A = mkA "aikainen" ;
lin view_N = mkWN (k10 "näkymä") ;
lin view_2_N = mkN "mielipide" ;
lin view_1_N = mkN "näkymä" | mkN "näky" ;
lin public_A = mkA "julkinen" ;
lin together_Adv = mkAdv "yhdessä" ;
lin talk_V2 = mkV2 "puhua" partitive ;
lin talk_V = mkV "puhua" ;
lin report_N = mkN "raportti" ;
lin after_Subj = lin Subj (ss "sen jälkeen kun") ;
lin only_Predet = S.only_Predet ;
lin before_Subj = lin Subj (ss "ennen kuin") ;
lin bit_N = mkN "palanen" | mkN "bitti" ; ---- split
lin face_N = mkN "kasvo" | mkN "naama" ; ---- plural "kasvot" also possible
lin sit_V2 = mkV2 (mkV "istua") ;
lin sit_V = L.sit_V ;
lin market_N = mkN "markkina" ;
lin market_1_N = mkN "tori" ;
lin market_2_N = mkN "markkina" ; ---- plural only
lin appear_VV = mkVV (mkV "näyttää") infPresPart ;
lin appear_VS = mkVS (mkV (mkV "näyttää") "siltä") ;
lin appear_VA = mkVA (mkV "vaikuttaa") (casePrep ablative) ;
lin appear_V = mkV "ilmestyä" ;
lin continue_VV = mkVV (mkV "jatkaa") ; --- add more Inf3 forms *jatkaa kulkea
lin continue_V2 = mkV2 (mkV "jatkaa") partitive ;
lin continue_V = mkV "jatkua" ;
lin able_A = mkA "kykenevä" ;
lin political_A = mkA "poliittinen" ;
lin later_Adv = mkAdv "myöhemmin" ;
lin hour_N = mkN "tunti" ;
lin rate_N = mkN "taso" | mkN "kurssi" ;
lin law_N = mkN "laki" ;
lin law_2_N = mkN "oikeustiede" ;
lin law_1_N = mkN "laki" ;
lin door_N = L.door_N ;
lin court_N = mkN "tuomioistuin" ;
lin court_2_N = mkN "tuomioistuin" ;
lin court_1_N = mkN "hovi" ;
lin office_N = mkN "toimisto" ;
lin let_V2V = mkV2V (mkV "antaa") genitive infFirst ;
lin war_N = L.war_N ;
lin produce_V2 = mkV2 "tuottaa" partitive ;
lin produce_V = mkV "tuottaa" ;
lin reason_N = L.reason_N ;
lin less_Adv = mkAdv "vähemmän" ;
lin minister_N = mkN "ministeri" ;
lin minister_2_N = mkN "pastori" ;
lin minister_1_N = mkN "ministeri" ;
lin subject_N = mkWN (k48 "aihe") ;
lin subject_2_N = mkN "subjekti" ;
lin subject_1_N = mkN "aihe" ;
lin person_N = L.person_N ;
lin term_N = mkN "ehto" | mkN "termi" ; ---- split
lin particular_A = mkA "yksittäinen" ;
lin full_A = L.full_A ;
lin involve_VS = mkVS "sisältää" ;
lin involve_V2 = mkV2 "koskea" partitive ;
lin involve_V = mkV "koskea" ;
lin sort_N = mkWN (k5 "laji") ;
lin require_VS = mkVS (mkV "vaatia") ;
lin require_V2V = mkV2V (mkV "vaatia") ;
lin require_V2 = mkV2 "vaatia" ;
lin require_V = mkV vOlla "vaatimuksena" ;
lin suggest_VS = mkVS (mkV "ehdottaa") ;
lin suggest_V2 = mkV2 (mkV "ehdottaa") ;
lin suggest_V = mkV "ehdottaa" ;
lin far_A = mkA "etäinen" | mkA "kaukainen" ;
lin towards_Prep = mkPrep partitive "kohti" ;
lin anything_NP = {s = \\c => S.mikaInt ! Sg ! (npform2case Sg c) ++ "tahansa" ; a = agrP3 Sg ; isPron, isNeg = False} ;
lin period_N = mkN "ajanjakso" ;
lin period_3_N = mkN "kuukautinen" ; ---- plural only
lin period_2_N = mkN "piste" ;
lin period_1_N = mkN "ajanjakso" ;
lin consider_VV = mkVV "harkita" infPresPart ;
lin consider_VS = mkVS (mkV "arvella" "arveli") ;
lin consider_V3 = mkV3 (mkV "pitää") (mkPrep partitive) (mkPrep essive) ;
lin consider_V2V = mkV2V (mkV "arvella" "alveli") genitive infPresPart ;
lin consider_V2A = mkV2A (mkV "pitää") (mkPrep partitive) (mkPrep essive) ;
lin consider_V2 = mkV2 "harkita" partitive ;
lin consider_V = mkV vOlla "mieltä" ;
lin read_VS = mkVS "kuulua" ; --käsky kuuluu, että XYZ ?
lin read_V2 = L.read_V2 ;
lin read_V = mkV "lukea" ;
lin change_V2 = mkV2 "muuttaa" ;
lin change_V = mkV "muuttua" ;
lin society_N = mkN "yhteis" (mkN "kunta") ;
lin process_N = mkN "prosessi" ;
lin mother_N = mkN "äiti" ;
lin offer_VV = mkVV "tarjoutua" infIllat ;
lin offer_V2 = mkV2 (mkV "tarjota") ;
lin late_A = mkA "myöhäinen" ;
lin voice_N = mkN "ääni" ;
lin both_Adv = mkAdv "molemmat" ; ---- cat
lin once_Adv = mkAdv "kerran" ;
lin police_N = mkN "poliisi" ;
lin kind_N = mkN "laji" | mkN "tyyppi" ;
lin lose_V2 = L.lose_V2 ;
lin lose_V = mkV "hävitä" ;
lin add_VS = mkVS (mkV "lisätä") ;
lin add_V2 = mkV2 "lisätä" ;
lin add_V = mkV "lisätä" ;
lin probably_Adv = mkAdv "todennäköisesti" ;
lin expect_VV = mkVV (mkV "aikoa") ;
lin expect_VS = mkVS (mkV "odottaa") ;
lin expect_V2V = mkV2V (mkV "odottaa") (mkPrep genitive) infPresPart ;
lin expect_V2 = mkV2 "odottaa" partitive ;
lin expect_V = mkWV (k53A "odottaa") ;
lin ever_Adv = mkAdv "aina" ;
lin available_A = mkA "saatavillaoleva" | mkA "vapaa" ;
lin price_N = mkN "hinta" ;
lin little_A = mkA "pieni" | mkA "vähäinen" ;
lin action_N = mkN "toiminta" ;
lin issue_N = mkN "ongelma" ;
lin issue_2_N = mkN "numero" ;
lin issue_1_N = mkN "ongelma" ;
lin far_Adv = L.far_Adv ;
lin remember_VS = mkVS "muistaa" ;
lin remember_V2 = mkV2 "muistaa" ;
lin remember_V = mkV "muistaa" ;
lin position_N = mkN "asema" | mkN "positio" ;
lin low_A = mkA "matala" ;
lin cost_N = mkN "kustannus" ;
lin little_Det = mkDet False Sg (exceptNomN (mkN "vähä") "vähän") partitive ;
lin matter_N = mkWN (k48 "aine") ;
lin matter_1_N = mkN "materia" | mkN "aine" ;
lin matter_2_N = mkN "ongelma" ;
lin community_N = mkN "yhteisö" ;
lin remain_VV = mkVV "jäädä" infIllat ;
lin remain_VA = mkVA (mkV "pysyä") (mkPrep essive) ;
lin remain_V2 = mkV2 (mkV "pysyä") (mkPrep essive) ;
lin remain_V = mkV "jäädä" ;
lin figure_N = mkN "kuvio" ; --- split already mkN "luku"
lin figure_2_N = mkN "luku" ;
lin figure_1_N = mkN "kuvio" ;
lin type_N = mkN "tyyppi" ;
lin research_N = mkN "tutkimus" ;
lin actually_Adv = mkAdv "itse asiassa" ;
lin education_N = mkN "koulutus" | mkN "sivistys" ;
lin fall_V = mkV "pudota" ;
lin speak_V2 = L.speak_V2 ;
lin speak_V = mkV "puhua" ;
lin few_N = mkN "harva" ;
lin today_Adv = L.today_Adv ;
lin enough_Adv = mkAdv "tarpeeksi" ;
lin open_V2 = L.open_V2 ;
lin open_V = mkV "aueta" "aukesi" ;
lin bad_A = L.bad_A ;
lin buy_V2 = L.buy_V2 ;
lin buy_V = mkV "ostaa" ;
lin programme_N = mkN "ohjelma" ;
lin minute_N = mkN "minuutti" | mkN "muistiinpano" ; ---- split
lin moment_N = mkN "hetki" ;
lin girl_N = L.girl_N ;
lin age_N = mkN "ikä" "iän" "ikää" "ikänä" "ikään" "ikien" "ikiä" "ikinä" "i'issä" "ikiin" ;
lin centre_N = mkN "keskus" ;
lin stop_VV = mkVV "lakata" infElat ;
lin stop_V2 = mkV2 "lopettaa" ;
lin stop_V = L.stop_V ;
lin control_N = mkN "kontrolli" ;
lin value_N = mkN "arvo" ;
lin send_V2V = mkV2V (mkV "lähettää") accusative infIllat ;
lin send_V2 = mkV2 "lähettää" ;
lin send_V = mkV "lähettää" ;
lin health_N = mkWN (k40 "terveys") ;
lin decide_VV = mkVV "päättää" ;
lin decide_VS = mkVS (mkV "päättää") ;
lin decide_V2 = mkV2 (mkV "päättää") ;
lin decide_V = mkV "päättää" ;
lin main_A = mkA "pääasiallinen" ;
lin win_V2 = L.win_V2 ;
lin win_V = mkV "voittaa" ;
lin understand_VS = mkVS "ymmärtää" | mkWVS (k74 "älytä") ;
lin understand_V2 = L.understand_V2 ;
lin understand_V = mkV "ymmärtää" ;
lin decision_N = mkN "päätös" ;
lin develop_V2 = mkV2 "kehittää" ;
lin develop_V = mkV "kehittyä" ;
lin class_N = mkN "luokka" ;
lin industry_N = L.industry_N ;
lin receive_V2 = mkWV2 (compoundV "vastaan" (k53A "ottaa")) ;
lin receive_V = mkWV (compoundV "vastaan" (k53A "ottaa")) ;
lin back_N = L.back_N ;
lin several_Det = mkDet Pl (mkN "usea") ;
lin return_V2 = mkV2 "palauttaa" ;
lin return_V = mkV "palata" ;
lin build_V2 = mkV2 "rakentaa" | mkV2 (mkV "rakentaa") partitive ;
lin build_V = mkV "rakentaa" ;
lin spend_V2 = mkV2 "kuluttaa" ;
lin spend_V = mkV "kuluttaa" | mkV "kulua" ;
lin force_N = mkN "voima" ;
lin condition_N = mkN "ehto" ;
lin condition_1_N = mkN "ehto" ;
lin condition_2_N = mkN "olosuhde" ;
lin paper_N = L.paper_N ;
lin off_Prep = mkPrep "ulkopuolella" ;
lin major_A = mkA "merkittävä" ;
lin describe_VS = mkVS (mkV "kuvailla") ;
lin describe_V2 = mkV2 (mkV "kuvailla") partitive | mkV2 (mkV "kuvata" "kuvasi") partitive ;
lin agree_VV = mkVV (mkV "suostua") infIllat ;
lin agree_VS = mkVS (mkV "sopia") ;
lin agree_V = mkV olla_V "samaa mieltä" ;
lin economic_A = mkA "taloudellinen" ;
lin increase_V2 = mkV2 "lisätä" partitive ;
lin increase_V = mkV "kasvaa" ;
lin upon_Prep = mkPrep "päällä" ;
lin learn_VV = mkVV (mkV "oppia") infIllat ;
lin learn_VS = mkVS (mkV "oppia") ;
lin learn_V2 = L.learn_V2 ;
lin learn_V = mkV "oppia" ;
lin general_A = mkA "yleinen" ;
lin century_N = mkN "vuosi" (mkN "sata") ;
lin therefore_Adv = mkAdv "siksi" ;
lin father_N = mkN "isä" ;
lin section_N = mkN "osasto" | mkN "sektio" | mkN "leikkaus" ; ---- split
lin patient_N = mkWN "potilas" ;
lin around_Adv = mkAdv "suunnilleen" | mkAdv "lähes" ;
lin activity_N = mkWN (k9A "toiminta") ;
lin road_N = L.road_N ;
lin table_N = L.table_N ;
lin including_Prep = mkPrep "mukaanluettuna" nominative ;
lin church_N = L.church_N ;
lin reach_V2 = mkV2 "saavuttaa" ;
lin reach_V = mkV "saavuttaa" ;
lin real_A = mkA "todellinen" ;
lin lie_VS = mkVS (mkV "valehdella") ;
lin lie_2_V = mkV "valehdella" ;
lin lie_1_V = mkV "maata" ;
lin mind_N = mkN "mieli" ;
lin likely_A = mkWA (compoundA "toden" (k38 "näköinen")) ;
lin among_Prep = postPrep genitive "joukossa" ;
lin team_N = mkN "ryhmä" | mkN "joukkue" ;
lin experience_N = mkN "kokemus" ;
lin death_N = mkN "kuolema" ;
lin soon_Adv = mkAdv "pian" ;
lin act_N = mkWN (k25 "toimi") | mkN "näytös" ; ---- split
lin sense_N = mkN "aisti" | mkN "järki" | mkN "mieli" ; ---- split
lin staff_N = mkN "henkilökunta" ;
lin staff_2_N = mkN "sauva" ;
lin staff_1_N = mkN "henkilökunta" ;
lin certain_A = mkA (mkN "varma") "varmempi" "varmin" ;
lin certain_2_A = mkA "tietty" ;
lin certain_1_A = mkA (mkN "varma") "varmempi" "varmin" ;
lin studentMasc_N = mkN "opiskelija" ;
lin half_Predet = mkPredet "puoliksi" ;
lin half_Predet = mkPredet "puoliksi" ;
lin around_Prep = mkPrep "ympärillä" ;
lin language_N = L.language_N ;
lin walk_V2 = mkV2 "kävelyttää" partitive ; --mkWV2 (k63 "saada") "piste" ;
lin walk_V = L.walk_V ;
lin die_V = L.die_V ;
lin special_A = mkA "erityinen" ;
lin difficult_A = mkA "vaikea" ;
lin international_A = mkWA (compoundA "kansain" (k38 "välinen")) ;
lin particularly_Adv = mkAdv "erityisesti" ;
lin department_N = mkN "osasto" | mkN "laitos" ;
lin management_N = mkN "johto" ;
lin morning_N = mkN "aamu" ;
lin draw_V2 = mkV2 "vetää" ;
lin draw_1_V2 = mkV2 "piirtää" ;
lin draw_2_V2 = mkV2 "vetää" ;
lin draw_V = mkV "vetää" ;
lin hope_VV = mkVV (mkV "toivoa") infPresPartAgr ;
lin hope_VS = L.hope_VS ;
lin hope_V = mkV "toivoa" ;
lin across_Prep = mkPrep "poikki" ;
lin plan_N = mkN "suunnitelma" ;
lin product_N = mkN "tuote" ;
lin city_N = L.city_N ;
lin early_Adv = mkAdv "aikaisin" ;
lin committee_N = mkN "komitea" "komiteoita" ;
lin ground_N = mkN "perusta" ;
lin ground_2_N = mkN "peruste" ;
lin ground_1_N = mkN "tontti" | mkN "perusta" ;
lin letter_N = mkN "kirje" ;
lin letter_2_N = mkN "kirjain" ;
lin letter_1_N = mkN "kirje" ;
lin create_V2 = mkV2 "luoda" ;
lin create_V = mkV "luoda" ;
lin evidence_N = mkN "evidenssi" ;
lin evidence_2_N = mkN "selvyys" ;
lin evidence_1_N = mkN "todiste" | mkN "evidenssi" ;
lin foot_N = L.foot_N ;
lin clear_A = mkA (mkN "selvä") "selvempi" "selvin" ;
lin boy_N = L.boy_N ;
lin game_N = mkWN (k5 "peli") ;
lin game_3_N = mkN "riista" ;
lin game_2_N = mkN "leikki" ;
lin game_1_N = mkN "peli" ;
lin food_N = mkWN (k10A "ruoka") ;
lin role_N = mkN "rooli" ;
lin role_2_N = mkN "rooli" ; ---- sense
lin role_1_N = mkN "rooli" ;
lin practice_N = mkN "käytäntö" ;
lin bank_N = L.bank_N ;
lin else_Adv = mkAdv "muutoin" ;
lin support_N = mkN (lin NK {s = d07A "tuki"}) ;
lin sell_V2 = mkV2 (mkV "myydä") ;
lin sell_V = mkV "myydä" ;
lin event_N = mkN "tapahtuma" ;
lin building_N = mkN "rakennus" ;
lin range_N = mkN "valikoima" | mkN "vuorijono" | mkN "arvojoukko" | mkN "kantama" ; ---- split
lin behind_Prep = S.behind_Prep ;
lin sure_A = mkA "varma" ;
lin report_VS = mkVS "raportoida" ;
lin report_V2 = mkV2 "raportoida" elative ;
lin report_V = mkV "raportoida" ;
lin pass_V = mkV (mkV "päästä") "läpi" ;
lin black_A = L.black_A ;
lin stage_N = mkN "vaihe" | mkN "näyttämö" ; --- split
lin meeting_N = mkN "kokous" ;
lin meeting_N = mkN "kokous" ;
lin sometimes_Adv = mkAdv "joskus" | mkWAdv (k99 "ajoittain") ;
lin thus_Adv = mkAdv "siten" ;
lin accept_VS = mkVS (mkV "hyväksyä") ;
lin accept_V2 = mkV2 "hyväksyä" ;
lin accept_V = mkV "hyväksyä" ;
lin town_N = mkN "kaupunki" ;
lin art_N = L.art_N ;
lin further_Adv = mkAdv "pidemmälle" ;
lin club_N = mkN "klubi" ;
lin club_2_N = mkN "maila" ;
lin club_1_N = mkN "kerho" | mkN "klubi" ;
lin cause_V2V = mkV2V (mkV "saada") accusative infIllat ;
lin cause_V2 = mkV2 "aiheuttaa" ;
lin arm_N = mkN "käsi" ;
lin arm_1_N = mkN "käsivarsi" | mkN "käsi" ;
lin arm_2_N = mkN "ase" ;
lin history_N = mkN "historia" ;
lin parent_N = mkN "vanhempi" "vanhemman" "vanhempia" ;
lin land_N = mkN "maa" ;
lin trade_N = mkN "kauppa" ;
lin watch_VS = mkVS "katsoa" | mkVS "seurata" ;
lin watch_V2V = mkV2V (mkV "katsoa") (mkPrep genitive) infPresPart | mkV2V (mkV "katsella") (mkPrep partitive) infIness ;
lin watch_V2 = L.watch_V2 ;
lin watch_1_V2 = mkV2 "katsella" partitive | mkV2 "katsoa" partitive;
lin watch_2_V2 = mkV2 "vartioida" partitive ;
lin watch_V = mkV "katsella" ;
lin white_A = L.white_A ;
lin situation_N = mkN (lin NK {s = d48A "tilanne"}) ;
lin ago_Adv = mkAdv "sitten" ;
lin teacherMasc_N = mkN "opettaja" ;
lin record_N = mkN "ennätys" ;
lin record_3_N = mkN "kirjanpito" ;
lin record_2_N = mkN "levy" | mkN "äänilevy" ;
lin record_1_N = mkN "ennätys" ;
lin manager_N = mkN "johtaja" ;
lin relation_N = mkWN (k48A "suhde") ;
lin common_A = mkA "tavallinen" ;
lin common_2_A = mkA "yhteinen" ;
lin common_1_A = mkA "tavallinen" ;
lin strong_A = mkA "vahva" ;
lin whole_A = mkA "kokonainen" ;
lin field_N = mkN "kenttä" ;
lin field_4_N = mkN "kunta" ;
lin field_3_N = mkN "kenttä" ;
lin field_2_N = mkN "kenttä" ;
lin field_1_N = mkN "pelto" ;
lin free_A = mkA "vapaa" ;
lin break_V2 = L.break_V2 ;
lin break_V = mkV "murtua" ;
lin yesterday_Adv = mkAdv "eilen" ;
lin support_V2 = mkV2 "kannattaa" partitive ;
lin window_N = L.window_N ;
lin account_N = mkN "selvitys" ;
lin explain_VS = mkVS (mkV "selittää") ;
lin explain_V2 = mkV2 "selittää" ;
lin stay_VA = mkVA (mkV "pysyä") (mkPrep essive) ;
lin stay_V = mkV "jäädä" | mkV "pysyä" ;
lin few_Det = S.few_Det ;
lin wait_VV = mkVV "valmistautua" infIllat ;
lin wait_V2 = L.wait_V2 ;
lin wait_V = mkV "odottaa" ;
lin usually_Adv = mkAdv "tavallisesti" ;
lin difference_N = mkN "ero" ;
lin material_N = mkN "materiaali" ;
lin air_N = mkN "ilma" ;
lin wife_N = L.wife_N ;
lin cover_V2 = mkV2 "peittää" ;
lin apply_VV = mkVV "hakea" infIllat ;
lin apply_V2V = mkV2V (mkV "soveltaa") partitive infIllat ;
lin apply_V2 = mkV2 "soveltaa" partitive ;
lin apply_1_V2 = mkV2 "soveltaa" partitive ;
lin apply_2_V2 = mkV2 "hakea" partitive ;
lin apply_V = mkV "soveltua" ;
lin project_N = mkN "projekti" "projektin" "projekteja" ;
lin raise_V2 = mkV2 "nostaa" ;
lin sale_N = mkN "myynti" ;
lin relationship_N = mkWN (k48A "suhde") ;
lin indeed_Adv = mkAdv "tosiaan" ;
lin light_N = mkN "valo" ;
lin claim_VS = mkVS (mkV "väittää") ;
lin claim_V2 = mkV2 "vaatia" ;
lin claim_V = mkV (mkV "hakea") "korvausta" ; --mkWV (k61 "periä") ;
lin form_V2 = mkV2 "muodostaa" | mkV2 "muovata" ;
lin form_V = mkV "muodostua" | mkV "muovautua" ;
lin base_V2 = mkV2 "perustaa" ;
lin base_V = mkV "pohjautua" ;
lin care_N = mkN "hoito" ;
lin someone_NP = S.somebody_NP ;
lin everything_NP = S.everything_NP ;
lin certainly_Adv = mkAdv "varmasti" ;
lin rule_N = L.rule_N ;
lin home_Adv = mkAdv "kotiin" | mkAdv "kotona" ; ---- split
lin cut_V2 = L.cut_V2 ;
lin cut_V = mkV "leikata" ;
lin grow_VA = mkVA (mkV "kasvaa") (mkPrep translative) ;
lin grow_V2 = mkV2 "kasvattaa" ;
lin grow_V = mkV "kasvaa" ;
lin similar_A = mkA "samanlainen" ;
lin story_N = mkN "tarina" | mkN "kerros" ; ---- split
lin quality_N = mkN "laatu" ;
lin tax_N = mkN "vero" ;
lin worker_N = mkN "työläinen" ;
lin nature_N = mkN "luonto" ;
lin structure_N = mkN "rakenne" | mkN "rakennelma" ;
lin data_N = mkN "data" ;
lin necessary_A = mkA "välttämätön" ;
lin pound_N = mkN "punta" | mkN "pauna" | mkN "naula" ; ---- split
lin method_N = mkN "menetelmä" ;
lin unit_N = mkN "yksikkö" ;
lin unit_6_N = mkN "yksikkö" ;
lin unit_5_N = mkN "yksikkö" ;
lin unit_4_N = mkN "yksikkö" ;
lin unit_3_N = mkN "yksikkö" ;
lin unit_2_N = mkN "yksikkö" ;
lin unit_1_N = mkN "yksikkö" ;
lin central_A = mkA "keskeinen" ;
lin bed_N = mkN "sänky" | mkN "vuode" ;
lin union_N = mkN (lin NK {s = d06 "unioni"}) ;
lin movement_N = mkN "liike" ;
lin board_N = mkN "hallitus" ;
lin board_2_N = mkN "hallitus" | mkN "lautakunta" ;
lin board_1_N = mkN "taulu" ;
lin true_A = mkA (mkN "tosi" "toden" "tosia" "totta") "todempi" "tosin" ;
lin well_Interj = mkInterj "no" ;
lin simply_Adv = mkAdv "yksinkertaisesti" ;
lin contain_V2 = mkV2 "sisältää" | mkV2 "pidätellä" ; ---- split
lin especially_Adv = mkAdv "erityisesti" ;
lin open_A = mkA "avoin" ;
lin short_A = L.short_A ;
lin personal_A = mkA "henkilökohtainen" ;
lin detail_N = mkN "yksityiskohta" ;
lin model_N = mkN "malli" ;
lin bear_V2 = mkV2 "kantaa" | mkV2 "sietää" partitive ; ---- split
lin bear_V = mkV "kantaa" ;
lin single_A = mkA "yksittäinen" ;
lin single_2_A = mkA "naimaton" | mkA "sinkku" ;
lin single_1_A = mkA "yksittäinen" ;
lin join_V2 = mkV2 "liittyä" illative ;
lin join_V = mkV (mkV "tulla") "mukaan" ;
lin reduce_V2 = mkV2 "vähentää" partitive ;
lin reduce_V = mkV "vähentää" | mkV "vähentyä" ;
lin establish_V2 = mkWV2 (mkV "perustaa") ;
lin wall_N = mkN "seinä" | mkN "muuri" | mkN "valli" ; ---- split
lin face_V2 = mkV2 (mkV "kohdata") ;
lin face_V = mkV "kohdata" ;
lin easy_A = mkA "helppo" ;
lin private_A = mkA "yksityinen" ;
lin computer_N = L.computer_N ;
lin hospital_N = mkWN (k13 "sairaala") ;
lin chapter_N = mkWN (k1A "luku") ;
lin scheme_N = mkN "luonnos" ;
lin theory_N = mkWN (k12 "teoria") ;
lin choose_VV = mkVV "päättää" ;
lin choose_V2 = mkV2 "valita" ;
lin wish_VV = mkVV "toivoa" infPresPartAgr ;
lin wish_VS = mkVS "toivoa" ;
lin wish_V2V = mkV2V (mkV "toivoa") genitive infPresPart ;
lin wish_V2 = mkV2 "toivoa" | mkV2 "toivottaa" partitive ;
lin wish_V = mkV "toivoa" ;
lin property_N = mkN "omaisuus" ; ---- already split
lin property_2_N = mkN "ominaisuus" ;
lin property_1_N = mkN "omaisuus" ;
lin achieve_V2 = mkV2 "saavuttaa" ;
lin financial_A = mkA "taloudellinen" ;
lin poor_A = mkA "köyhä" ;
lin poor_3_A = mkA "kehno" | mkA "surkea" ;
lin poor_2_A = mkA "säälittävä" | mkA "raukka" | mkA "parka" ; ---- position
lin poor_1_A = mkA "köyhä" ;
lin officer_N = mkN "vastaava" ; --- already split
lin officer_3_N = mkN "poliisi" ;
lin officer_2_N = mkN "upseeri" ;
lin officer_1_N = mkN "vastaava" ;
lin up_Prep = mkPrep "ylös" partitive ;
lin charge_N = mkN "varaus" ;
lin charge_2_N = mkN "syytös" ;
lin charge_1_N = mkN "varaus" ;
lin director_N = mkN "johtaja" ;
lin drive_V2V = mkV2V "ajaa" ;
lin drive_V2 = mkV2 "ajaa" partitive ;
lin drive_V = mkV "ajaa" ;
lin deal_V2 = mkV2 "käsitellä" partitive | mkV2 "jakaa" ; ---- split
lin deal_V = mkV (mkV "käydä") "kauppaa" ;
lin place_V2 = mkV2 "sijoittaa" ;
lin approach_N = mkN "lähestymis" (mkN "tapa") ;
lin chance_N = mkN (lin NK {s = d40 "mahdollisuus"}) ;
lin application_N = mkN "sovellus" ;
lin seek_VV = mkVV (mkV "pyytää") infIllat ;
lin seek_V2 = L.seek_V2 ;
lin foreign_A = mkA "ulkomainen" ;
lin foreign_2_A = mkA "vieras" ;
lin foreign_1_A = mkA "ulkomaalainen" | mkA "ulkomainen" ;
lin along_Prep = mkPrep "pitkin" ;
lin top_N = mkN "huippu" ;
lin amount_N = mkN "summa" ;
lin son_N = mkN "poika" "pojan" "poikia" ;
lin operation_N = mkN "operaatio" ;
lin fail_VV = mkVV (mkV "epäonnistua") infIllat ;
lin fail_V2 = mkV2 (mkV "epäonnistua") (mkPrep inessive) ;
lin fail_V = mkV "epäonnistua" ;
lin human_A = mkA "inhimillinen" ;
lin opportunity_N = mkN (lin NK {s = d40 "tilaisuus"}) ;
lin simple_A = mkA "yksinkertainen" ;
lin leader_N = mkN (lin NK {s = d10 "johtaja"}) ;
lin look_N = mkWN (k48 "katse") ;
lin share_N = mkN "osuus" ;
lin production_N = mkN "tuotanto" ;
lin recent_A = mkA "viimeaikainen" ;
lin firm_N = mkN "yritys" ;
lin picture_N = mkN "kuva" ;
lin source_N = mkN "lähde" ;
lin security_N = mkWN (k40 "turvallisuus") ;
lin serve_V2 = mkV2 "palvella" partitive ;
lin serve_V = mkV "palvella" ;
lin according_to_Prep = postPrep genitive "mukaan" ;
lin end_V2 = mkV2 "lopettaa" ;
lin end_V = mkV "loppua" ;
lin contract_N = mkN "sopimus" ;
lin wide_A = L.wide_A ;
lin occur_V = mkV "käydä" ;
lin agreement_N = mkN "sopimus" ;
lin better_Adv = mkAdv "paremmin" ;
lin kill_V2 = L.kill_V2 ;
lin kill_V = mkV "tappaa" ;
lin act_V2 = mkV2 "näytellä" partitive ;
lin act_V = mkV "toimia" | mkV "käyttäytyä" ;
lin site_N = mkN "sijaintipaikka" ;
lin either_Adv = mkAdv "myöskään" ;
lin labour_N = mkN "työ" ;
lin plan_VV = mkVV (mkV "suunnitella") infPresPartAgr | mkVV "aikoa" ;
lin plan_VS = mkVS (mkV "suunnitella") ;
lin plan_V2V = mkV2V (mkV "suunnitella") genitive infPresPart ;
lin plan_V2 = mkV2 "suunnitella" partitive ;
lin plan_V = mkV "suunnitella" ;
lin various_A = mkA "erilainen" ; ---??
lin since_Prep = postPrep elative "lähtien" ;
lin test_N = mkN "testi" ;
lin eat_V2 = L.eat_V2 ;
lin eat_V = mkV "syödä" ;
lin loss_N = mkN "menetys" ;
lin close_V2 = L.close_V2 ;
lin close_V = mkV "sulkea" ;
lin represent_V2 = mkV2 "edustaa" partitive ;
lin represent_V = mkV "edustaa" | mkV "merkitä" ;
lin love_VV = mkVV "rakastaa" ;
lin love_V2 = L.love_V2 ;
lin colour_N = mkN "väri" ;
lin clearly_Adv = mkAdv "selvästi" ;
lin shop_N = L.shop_N ;
lin benefit_N = mkWN (k1A "hyöty") ;
lin animal_N = L.animal_N ;
lin heart_N = L.heart_N ;
lin election_N = mkWN (k9A "valinta") ;
lin purpose_N = mkN "tarkoitus" ;
lin standard_N = mkN "standardi" ;
lin due_A = mkA "asianmukainen" ;
lin secretary_N = mkWN (compoundN "kirjoitus" (k10A "pöytä")) ;
lin rise_V2 = mkV2 "nousta" elative ;
lin rise_V = mkV "nousta" ;
lin date_N = mkN "päivämäärä" ; --- already split
lin date_7_N = mkN "taateli" ;
lin date_3_N = mkN "tapaaminen" ;
lin date_3_N = mkN "tapaaminen" ;
lin date_1_N = mkN "päivä" (mkN "määrä") ;
lin hard_A = mkA "kova" ; --- already split
lin hard_2_A = mkA "vaikea" ;
lin hard_1_A = mkA "kova" ;
lin music_N = L.music_N ;
lin hair_N = L.hair_N ;
lin prepare_VV = mkVV (mkV "varautua") infIllat ;
lin prepare_V2V = mkWV2V (k52A "varautua") ;
lin prepare_V2 = mkV2 "valmistaa" ;
lin prepare_V = mkV "valmistautua" ;
lin factor_N = mkN "tekijä" ;
lin other_A = mkA "muu" ;
lin anyone_NP = {s = table {NPAcc => "kenet" ++ "tahansa" ; c => S.kukaInt ! Sg ! npform2case Sg c ++ "tahansa"} ; a = agrP3 Sg ; isPron, isNeg = False} ;
lin pattern_N = mkN "kuvio" ;
lin manage_VV = mkVVf (mkV "onnistua") infIllat ;
lin manage_V2 = mkV2 "johtaa" partitive ;
lin manage_V = mkV "johtaa" ;
lin piece_N = mkN "palanen" ;
lin discuss_VS = mkVS "keskustella" ;
lin discuss_V2 = mkV2 "keskustella" elative ;
lin prove_VS = mkVS "todistaa" ;
lin prove_VA = mkVA (mkV "osoittautua") (mkPrep translative) ;
lin prove_V2 = mkV2 "todistaa" ;
lin prove_V = mkV "todistaa" ;
lin front_N = mkWN (compoundN "etu" (k26 "puoli")) ;
lin evening_N = mkWN (k9A "ilta") ;
lin royal_A = mkWA (k38 "kuninkaallinen") ;
lin tree_N = L.tree_N ;
lin population_N = mkN "populaatio" | mkN "väestö" | mkN "kanta" ;
lin fine_A = mkA "hieno" ;
lin plant_N = mkN "kasvi" | mkN "laitos" ; ---- split
lin pressure_N = mkN "paine" ;
lin response_N = mkN "vastaus" ;
lin catch_V2 = mkV2 (mkV (mkV "saada") "kiinni") | mkV2 (mkV (mkV "ottaa") "kiinni") ;
lin street_N = mkWN (k1A "katu") ;
lin pick_V2 = mkV2 "poimia" partitive | mkV2 "kerätä" partitive ;
lin pick_V = mkV "poimia" | mkV "kerätä" | mkV "valita" | mkV "nyppiä" ;
lin performance_N = mkN "suoritus" ;
lin performance_2_N = mkN "esitys" ;
lin performance_1_N = mkN "suoritus" (mkN "kyky") ;
lin knowledge_N = mkN "tieto" ;
lin despite_Prep = postPrep elative "huolimatta" ;
lin design_N = mkN "muotoilu" | mkN "design" "designin" "designia" "designina" "designiin" "designien" "designeja" "designeina" "designeissa" "designeihin" ;
lin page_N = mkN "sivu" ;
lin enjoy_VV = mkVV "pitää" infElat ; --- tekemisestä ; add more Inf3s in ParadigmsFin
lin enjoy_V2 = mkV2 (mkV "nauttia") partitive ;
lin individual_N = mkN "yksilö" ;
lin suppose_VS = mkVS "olettaa" ;
lin suppose_V2 = mkV2 "arvata" ;
lin rest_N = mkWN (k1A "lepo") ;
lin instead_Adv = mkAdv "sen sijaan" ;
lin wear_V2 = mkV2 "kuluttaa" | mkV2 (mkV (mkV "pitää") "päällä") partitive ; ---- split
lin wear_V = mkV "kulua" ;
lin basis_N = mkN "perusta" ;
lin size_N = mkN "koko" ;
lin environment_N = mkN "ympäristö" ;
lin per_Prep = mkPrep "per" nominative ;
lin fire_N = mkN "tuli" "tulia" ;
lin fire_2_N = mkN "tulipalo" | mkN "palo" ;
lin fire_1_N = mkN "tuli" "tulia" ;
lin series_N = mkWN (k9 "sarja") ;
lin success_N = mkN "menestys" ;
lin natural_A = mkA "luonnollinen" ;
lin wrong_A = mkWA (k10 "väärä") ;
lin near_Prep = postPrep genitive "lähellä" ;
lin round_Adv = mkAdv "ympäri" ;
lin thought_N = mkN "ajatus" | mkN "ajattelu" ;
lin list_N = mkN "lista" ;
lin argue_VS = mkVS (mkV "väittää") ;
lin argue_V2 = mkV2 "perustella" ;
lin argue_V = mkV "riidellä" | mkV "kiistellä" ;
lin final_A = mkA "lopullinen" ;
lin future_N = mkN "tulevaisuus" ; --- already split
lin future_3_N = mkN "futuuri" ;
lin future_1_N = mkN "tulevaisuus" ;
lin introduce_V2 = mkV2 "esitellä" ;
lin analysis_N = mkN "analyysi" | mkWN (k2 "tarkastelu") ;
lin enter_V2 = mkV2 (mkV L.go_V "sisään") illative ;
lin enter_V = mkV L.go_V "sisään" ;
lin space_N = mkN "avaruus" ;
lin arrive_V = mkV "saapua" | mkV (mkV "tulla") "perille" ;
lin ensure_VS = mkVS "varmistaa" ;
lin ensure_V2 = mkV2 "varmistaa" ;
lin ensure_V = mkV "varmistaa" ;
lin demand_N = mkN "kysyntä" ;
lin statement_N = mkN "lausunto" ;
lin to_Adv = mkAdv "luo" ; ---- what is this?
lin attention_N = mkN (lin NK {s = d03 "huomio"}) ;
lin love_N = L.love_N ;
lin principle_N = mkN "periaate" ;
lin pull_V2 = L.pull_V2 ;
lin pull_V = mkV "vetää" ;
lin set_N = mkWN (k9 "sarja") ;
lin set_2_N = mkN "joukko" ;
lin set_1_N = mkN "setti" | mkN "sarja" ;
lin doctor_N = L.doctor_N ;
lin choice_N = mkN "valinta" ;
lin refer_V2 = mkV2 (mkV "viitata") illative ;
lin refer_V = mkV "viitata" ;
lin feature_N = mkN "piirre" | mkWN (compoundN "erikois" (k6 "artikkeli")) ; ---- split
lin couple_N = mkN "pari" ;
lin step_N = mkN "askel" ;
lin following_A = mkWA (k10 "seuraava") ;
lin thank_V2 = mkV2 "kiittää" partitive ;
lin machine_N = mkN "kone" ;
lin income_N = mkN "tulo" ;
lin training_N = mkN "harjoitus" ;
lin present_V2 = mkV2 "esittää" ;
lin association_N = mkN "järjestö" | mkN "assosiaatio" ; ---- split
lin film_N = mkN "elokuva" ;
lin film_2_N = mkN "kalvo" ;
lin film_1_N = mkN "filmi" | mkN "elo" (mkN "kuva") ;
lin region_N = mkN "alue" ;
lin effort_N = mkN "ponnistus" ;
lin player_N = mkN "pelaaja" ;
lin everyone_NP = S.everybody_NP ;
lin present_A = mkA "nykyinen" | mkA "läsnäoleva" ; ---- split
lin award_N = mkN "palkinto" ;
lin village_N = L.village_N ;
lin control_V2 = mkV2 "kontrolloida" partitive ;
lin organisation_N = mkN "organisaatio" ;
lin whatever_Det = mkDet Sg {s = table NForm {nf => mika_NForms ! nf ++ "tahansa"} ; h = Back} ;
lin news_N = mkN "uutinen" ;
lin nice_A = mkA "mukava" ;
lin difficulty_N = mkN "ongelma" ;
lin modern_A = mkA "moderni" | mkWA (compoundA "nyky" (k38 "aikainen")) ;
lin cell_N = mkN "solu" ;
lin close_A = mkA "läheinen" ;
lin current_A = mkA "nykyinen" ;
lin legal_A = mkA "laillinen" ;
lin energy_N = mkN "energia" ;
lin finally_Adv = mkAdv "lopuksi" | mkAdv "lopulta" ; ---- split
lin degree_N = mkN "aste" ; ---- already split
lin degree_3_N = mkN "aste" ;
lin degree_2_N = mkN "oppiarvo" ;
lin degree_1_N = mkN "aste" ;
lin mile_N = mkWN (kH1 "maili") ;
lin means_N = mkN "keino" | mkWN (k5 "konsti") ;
lin growth_N = mkN "kasvu" ;
lin treatment_N = mkWN (k2 "käsittely") ;
lin sound_N = mkWN (k26 "ääni") ;
lin above_Prep = S.above_Prep ;
lin task_N = mkN "tehtävä" | mkWN (k25 "toimi") ;
lin provision_N = mkWN (k9A "hankinta") ;
lin affect_V2 = mkV2 "vaikuttaa" illative ;
lin please_Adv = mkAdv "ole hyvä" | mkAdv "mielellään" ; ---- cat
lin red_A = L.red_A ;
lin happy_A = mkA "onnellinen" ;
lin behaviour_N = mkN "käyttäytyminen" | mkN "käytös" ; ---- split
lin concerned_A = mkA "tarkoitettu" ;
lin point_V2 = mkV2 "osoittaa" partitive ;
lin point_V = mkV "osoittaa" ;
lin function_N = mkN "funktio" | mkN "tehtävä" ;
lin identify_V2 = mkV2 "tunnistaa" ;
lin identify_V = mkV "tunnistaa" ;
lin resource_N = mkWN (k9 "vara") ;
lin defence_N = mkN "puolustus" ;
lin garden_N = L.garden_N ;
lin floor_N = L.floor_N ;
lin technology_N = mkN "tekniikka" | mkN "teknologia" ;
lin style_N = mkN "tyyli" ;
lin feeling_N = mkN "tunne" ;
lin science_N = L.science_N ;
lin relate_V2 = mkV2 "liittää" | mkV2 "suhteuttaa" ;
lin relate_V = mkV "liittyä" | mkV vOlla "yhteydessä" ;
lin doubt_N = mkN "epäilys" ;
lin horse_N = L.horse_N ;
lin force_VS = mkVS "pakottaa" ;
lin force_V2V = mkV2V (mkV "pakottaa") accusative infIllat ; ---ARB (k53A "tyrkyttää") ;
lin force_V2 = mkV2 "pakottaa" ;
lin force_V = mkV "pakottaa" ;
lin answer_N = mkN "vastaus" ;
lin compare_V = mkV "verrata" ;
lin suffer_V2 = mkV2 "kärsiä" ;
lin suffer_V = mkV "kärsiä" ;
lin individual_A = mkA "yksilöllinen" ;
lin forward_Adv = mkAdv "eteenpäin" | mkAdv "edelleen" ;
lin announce_VS = mkVS "julkistaa" | mkVS "tiedottaa" ;
lin announce_V2 = mkV2 "julkistaa" ;
lin userMasc_N = mkN "käyttäjä" ;
lin fund_N = mkN "rahasto" ;
lin character_2_N = mkN "merkki" ; ---- sense ?
lin character_1_N = mkN "luonne" ; ---- sense ?
lin risk_N = mkN "riski" ;
lin normal_A = mkWA (k6 "normaali") ;
lin nor_Conj = mkConj "eikä" ;
lin dog_N = L.dog_N ;
lin obtain_V2 = mkWV2 (k61A "hankkia") ;
lin obtain_V = mkWV (k61A "hankkia") ;
lin quickly_Adv = mkAdv "nopeasti" ;
lin army_N = mkN "armeija" ;
lin indicate_VS = mkWVS (k53A "osoittaa") ;
lin indicate_V2 = mkWV2 (k53A "osoittaa") ;
lin forget_VS = mkV "unohtaa" ;
lin forget_V2 = L.forget_V2 ;
lin forget_V = mkV "unohtaa" ;
lin station_N = mkWN (k10 "asema") ;
lin glass_N = mkN "lasi" ;
lin cup_N = mkWN (k5A "kuppi") ;
lin previous_A = mkA "edellinen" ;
lin husband_N = L.husband_N ;
lin recently_Adv = mkAdv "äskettäin" | mkAdv "hiljattain" ;
lin publish_V2 = mkWV2 (k66 "julkaista") ;
lin publish_V = mkWV (k66 "julkaista") ;
lin serious_A = mkWA (k10 "vakava") ;
lin anyway_Adv = mkAdv "joka tapauksessa" ;
lin visit_V2 = mkV2 (mkV "vierailla") (postGenPrep "luona") ; --- agreement to prep, "minun luonani"
lin visit_V = mkV "vierailla" ;
lin capital_N = mkN "pää" (mkN "oma") ;
lin capital_3_N = mkN "isokirjain" ; ---- iso kirjain : CN
lin capital_2_N = mkN "pää" (mkN "oma") ;
lin capital_1_N = mkN "pää" (mkN "kaupunki") ;
lin either_Det = MorphoFin.mkDetPol False Sg {s = table NForm {nf => (snoun2nounBind (nforms2snoun (dSuurempi "kumpi"))).s ! nf ++ "tahansa"} ; h = Back} ;
lin note_N = mkN "huomautus" ; --- already split
lin note_3_N = mkN "nuotti" ;
lin note_2_N = mkN "huomautus" ;
lin note_1_N = mkN "muistiin" (mkN "pano") ;
lin season_N = mkWN (k9A "vuodenaika") ;
lin argument_N = mkN "argumentti" ;
lin listen_V = mkWV (k67A "kuunnella") ;
lin show_N = mkN "näytös" ;
lin responsibility_N = mkN (lin NK {s = d17 "vastuu"}) ;
lin significant_A = mkA "merkittävä" ;
lin deal_N = mkN "jako" ;
lin prime_A = mkA (mkN "ensi" (mkN "sijainen")) ;
lin economy_N = mkN "talous" "talouden" "talouksia" ;
lin economy_2_N = mkN "säästö" ;
lin economy_1_N = mkN "talous" ;
lin element_N = mkN "alku" (mkN "aine") ;
lin finish_V2 = mkWV2 (k53A "lopettaa") ;
lin finish_V = mkWV (k53A "lopettaa") ;
lin duty_N = mkN (lin NK {s = d40 "velvollisuus"}) ;
lin fight_V2 = L.fight_V2 ;
lin fight_V = mkWV (k67 "taistella") ;
lin train_V2V = mkV2V "valmentaa" | mkV2V "harjoittaa" ; --valmensin häntä taistelemaan
lin train_V2 = mkWV2 (k67A "harjoitella") ;
lin train_V = mkWV (k67A "harjoitella") ;
lin maintain_VS = mkVS "vakuuttaa" ;
lin maintain_V2 = mkV2 "ylläpitää" partitive ;
lin maintain_V = mkV "säilyä" | mkWV (k53A "säilyttää") ;
lin attempt_N = mkN (lin NK {s = d39 "yritys"}) ;
lin leg_N = L.leg_N ;
lin investment_N = mkN (lin NK {s = d05A "investointi"}) ;
lin save_V2 = mkV2 "pelastaa" ;
lin save_V = mkV "säästää" ;
lin throughout_Prep = mkPrep "läpi koko" genitive ;
lin design_V2 = mkV2 "muotoilla" ;
lin design_V = mkV "muotoilla" ;
lin suddenly_Adv = mkAdv "yhtäkkiä" | mkAdv "äkkiä" ;
lin brother_N = exceptNomN (mkN "velji" "veljen" "veljiä") "veli" ;
lin improve_V2 = mkV2 "parantaa" partitive ;
lin improve_V = mkWV (k52A "parantua") ;
lin avoid_VV = mkVV (mkV "välttää") infElat ;
lin avoid_V2 = mkWV2 (k53A "välttää") partitive ;
lin wonder_VQ = L.wonder_VQ ;
lin wonder_V = mkV "ihmetellä" ;
lin tend_VV = mkVV (mkV "tavata") ;
lin tend_V2 = mkV2 "pitää" partitive | mkV2 "hoitaa" partitive ;
lin title_N = mkN "titteli" ;
lin hotel_N = mkWN (k6 "hotelli") ;
lin aspect_N = mkN "aspekti" ;
lin increase_N = mkN "nousu" ;
lin help_N = mkN "apu" ;
lin industrial_A = mkA "teollinen" ;
lin express_V2 = mkV2 "ilmaista" ;
lin summer_N = mkN "kesä" ;
lin determine_VV = mkVV "päättää" ;
lin determine_VS = mkVS (mkV "päättää") ;
lin determine_V2V = mkV2V (mkV "päättää") genitive infPresPart ;
lin determine_V2 = mkV2 "päättää" | mkV2 "määrätä" ;
lin determine_V = mkV "määrätä" | mkV "päättää" ;
lin generally_Adv = mkAdv "yleisesti" ;
lin daughter_N = mkN "tytär" ;
lin exist_V = mkV vOlla "olemassa" ;
lin share_V2 = mkWV2 (k56A "jakaa") ;
lin share_V = mkWV (k56A "jakaa") ;
lin baby_N = L.baby_N ;
lin nearly_Adv = mkAdv "lähestulkoon" ;
lin smile_V = mkWV (k67 "hymyillä") ;
lin sorry_A = mkWA (k10 "oleva") "pahoillaan" ;
lin sea_N = L.sea_N ;
lin skill_N = mkN "taito" | mkN "kyky" ;
lin claim_N = mkN "vaatimus" ;
lin treat_V2 = mkWV2 (k53A "hoitaa") ;
lin treat_V = mkV "hoitua" ; --mkWV (k53A "hoitaa") ;
lin remove_V2 = mkV2 "poistaa" ;
lin remove_V = mkV "poistua" ;
lin concern_N = mkN "konserni" ;
lin university_N = L.university_N ;
lin left_A = mkA "vasemmistolainen" ;
lin dead_A = mkWA (k47 "kuollut") ;
lin discussion_N = mkN "keskustelu" ;
lin specific_A = mkA "erityinen" ;
lin customerMasc_N = mkN "asiakas" ;
lin box_N = mkN "laatikko" | mkWN (k41A "lipas") ;
lin outside_Prep = mkPrep "ulkopuolella" ;
lin state_VS = mkWVS (k74A "todeta") | mkVS "lausua" ;
lin state_V2 = mkWV2 (k74A "todeta") ;
lin conference_N = mkN "konferenssi" ;
lin whole_N = mkWN (k40 "kokonaisuus") ;
lin total_A = mkA "totaalinen" ;
lin profit_N = mkN "voitto" ;
lin division_N = mkN "osasto" ;
lin division_3_N = mkN "jako" (mkN "lasku") ;
lin division_2_N = mkN "divisioona" ;
lin division_1_N = mkN "osasto" ;
lin throw_V2 = L.throw_V2 ;
lin throw_V = mkV "heittää" ;
lin procedure_N = mkWN (k2 "menettely") ;
lin fill_V2 = mkV2 "täyttää" ;
lin fill_V = mkV "täyttyä" ;
lin king_N = L.king_N ;
lin assume_VS = mkVS (mkV "olettaa") ;
lin assume_V2 = mkV2 "olettaa" ;
lin image_N = mkN "mielikuva" ;
lin oil_N = L.oil_N ;
lin obviously_Adv = mkAdv "selvästi" | mkAdv "ilmeisesti" ;
lin unless_Subj = mkSubj "ellei" ;
lin appropriate_A = mkA "sopiva" ;
lin circumstance_N = mkN "olosuhde" ;
lin military_A = mkA "sotilaallinen" ;
lin proposal_N = mkN "ehdotus" ;
lin mention_VS = mkVS "mainita" ;
lin mention_V2 = mkV2 "mainita" ;
lin mention_V = mkV "mainita" ;
lin client_N = mkN (lin NK {s = d41A "asiakas"}) ;
lin sector_N = mkN (lin NK {s = d06 "sektori"}) ;
lin direction_N = mkWN (k39 "ohjaus") ;
lin admit_VS = mkVS "myöntää" | mkWVS (k53 "tunnustaa") ;
lin admit_V2 = mkV2 "myöntää" | mkV2 "tunnustaa" ;
lin admit_V = mkV "myöntää" | mkWV (k53 "tunnustaa") ;
lin though_Adv = mkWAdv (k99 "kuitenkin") ;
lin replace_V2 = mkV2 "korvata" ;
lin basic_A = mkA "perustava" ; --WA (k38 "perimmäinen") ;
lin hard_Adv = mkAdv "kovasti" ;
lin instance_N = mkN "tapaus" ;
lin sign_N = mkN "merkki" ;
lin original_A = mkA (mkN "alku" (mkN "peräinen")) ;
lin successful_A = mkWA (k47 "onnistunut") ;
lin okay_Adv = mkAdv "hyvin" | mkAdv "ihan hyvin" | mkWAdv (k99 "mukavasti") ;
lin reflect_V2 = mkV2 "harkita" partitive ;
lin reflect_V = mkV "pohtia" | mkWV (k61 "tuumia") ;
lin aware_A = mkA "tietoinen" ;
lin measure_N = mkN "keino" ;
lin attitude_N = mkN "asenne" ;
lin disease_N = mkWN (k5A "tauti") ;
lin exactly_Adv = mkAdv "täsmälleen" ;
lin above_Adv = mkAdv "yläpuolella" ;
lin commission_N = mkN (lin NK {s = d03 "komissio"}) ;
lin intend_VV = mkVV (mkV "aikoa") ;
lin beyond_Prep = mkPrep "saavuttamattomissa" ;
lin seat_N = mkWN (k33 "istuin") ;
lin presidentMasc_N = mkN "presidentti" ;
lin encourage_V2V = mkV2V (mkWV (k66 "rohkaista")) (mkPrep partitive) ;
lin encourage_V2 = mkWV2 (k66 "rohkaista") ;
lin addition_N = mkWN (k39 "lisäys") ;
lin goal_N = mkWN (kH1 "maali") ;
lin round_Prep = mkPrep "ympärillä" ;
lin miss_V2 = mkV2 "menettää" | mkV2 "kaivata" partitive | mkWV2 (k73 "missata") ; ---- split
lin miss_V = mkV "puuttua" ;
lin popular_A = mkWA (k1A "suosittu") ;
lin affair_N = mkN "liiketoimi" | mkWN (k1A "juttu") ; --- split
lin technique_N = mkN "tekniikka" ;
lin respect_N = mkWN (k39 "kunnioitus") ;
lin drop_V2 = mkWV2 (k53A "pudottaa") ;
lin drop_V = mkV "pudota" ;
lin professional_A = mkA "ammattimainen" ;
lin less_Det = mkDet Sg (exceptNomN (mkN "vähempä") "vähemmän") ;
lin once_Subj = mkSubj "sitten kun" ;
lin item_N = mkN "kohta" | mkN "esine" ; ---- split
lin fly_V2 = mkV2 "lennättää" partitive ;
lin fly_V = L.fly_V ;
lin reveal_VS = mkVS (mkV "paljastaa") ;
lin reveal_V2 = mkV2 (mkV "paljastaa") ;
lin version_N = mkN "versio" ;
lin maybe_Adv = mkAdv "ehkä" ;
lin ability_N = mkN "kyky" ;
lin operate_V2 = mkWV2 (k62 "operoida") ;
lin operate_V = mkV "operoida" | mkV "toimia" ;
lin good_N = mkN "hyvä" ;
lin campaign_N = mkN "kampanja" ;
lin heavy_A = L.heavy_A ;
lin advice_N = mkWN (k1 "neuvo") ;
lin institution_N = mkN "instituutio" ;
lin discover_VS = mkWVS (k63 "saada") "tietää" ;
lin discover_V2 = mkV2 "löytää" ;
lin discover_V = mkV "löytää" ;
lin surface_N = mkWN (k9A "pinta") ;
lin library_N = mkWN (k2 "kirjasto") ;
lin pupil_N = mkN "oppilas" | mkWN (k5 "pupilli") ; ---- split
lin record_V2 = mkV2 "tallentaa" | mkV2 "äänittää" ;
lin refuse_VV = mkVV "kieltäytyä" infElat ;
lin refuse_V2 = mkWV2 (k52 "torjua") ;
lin refuse_V = mkV "kieltäytyä" ;
lin prevent_V2 = mkV2 "estää" partitive ;
lin advantage_N = mkN "etu" ;
lin dark_A = mkA "pimeä" | mkA "tumma" ; ---- split
lin teach_V2V = mkWV2V (k53A "opettaa") ;
lin teach_V2 = L.teach_V2 ;
lin teach_V = mkWV (k53A "opettaa") ;
lin memory_N = mkWN (k5 "muisti") ;
lin culture_N = mkN "kulttuuri" ; ---- WN (k2 "viljely") ;
lin blood_N = L.blood_N ;
lin cost_V2 = mkWV2 (k56 "maksaa") ;
lin cost_V = mkWV (k56 "maksaa") ;
lin majority_N = mkN "enemmistö" ;
lin answer_V2 = mkV2 "vastata" illative ;
lin answer_V = mkV "vastata" ;
lin variety_N = mkWN (k40 "moninaisuus") ;
lin variety_2_N = mkN "laatu" ;
lin variety_1_N = mkN "valikoima" | mkN "vaihtelu" | mkN "moninaisuus" ; ---- split
lin press_N = mkN "lehdistö" | mkWN (k39 "painallus") ; ---- split
lin depend_V = mkV "riippua" ;
lin bill_N = mkN "lasku" | mkN "seteli" ; ---- split
lin competition_N = mkWN (k2 "kilpailu") ;
lin ready_A = L.ready_A ;
lin general_N = mkWN (k38 "yleinen") ;
lin access_N = mkWN (k1 "pääsy") ;
lin hit_V2 = L.hit_V2 ;
lin hit_V = mkWV (k58 "iskeä") ;
lin stone_N = L.stone_N ;
lin useful_A = mkWA (k38 "hyödyllinen") ;
lin extent_N = mkWN (k40 "laajuus") ;
lin employment_N = mkN "työ" (mkN "paikka") | mkN "työllisyys" ; ---- split
lin regard_V2 = mkWV2 (k62 "arvioida") ;
lin regard_V = mkWV (k62 "arvioida") ;
lin apart_Adv = mkAdv "erillään" | mkAdv "erikseen" | mkAdv "syrjässä" | mkAdv "syrjään" ; ---- split
lin present_N = mkN "lahja" | mkN "nyky" (mkN "hetki") | mkWN (k5 "preesens") ; ---- split
lin appeal_N = mkN "vetoomus" ;
lin text_N = mkWN (k5 "teksti") ;
lin parliament_N = mkN "parlamentti" | mkN "edus" (mkN "kunta") ;
lin cause_N = mkN "syy" ;
lin terms_N = mkN "ehto" ;
lin bar_N = mkN "baari" ;
lin bar_2_N = mkN "tanko" ;
lin bar_1_N = mkN "baari" ;
lin attack_N = mkN "hyökkäys" ;
lin effective_A = mkA "toimiva" ;
lin mouth_N = L.mouth_N ;
lin down_Prep = mkPrep "alas" partitive ;
lin result_V = mkV "seurata" ; ---- subcat
lin fish_N = L.fish_N ;
lin future_A = mkWA (k10 "tuleva") ;
lin visit_N = mkN "vierailu" ;
lin little_Adv = mkAdv "vähän" ;
lin easily_Adv = mkAdv "helposti" ;
lin attempt_VV = mkVV (mkV "yrittää") ;
lin attempt_V2 = mkV2 "yrittää" partitive ;
lin enable_VS = mkVS (mkV "mahdollistaa") ;
lin enable_V2V = mkWV2V (k71 "tehdä") "kykeneväksi" ;
lin enable_V2 = mkV2 "mahdollistaa" ;
lin trouble_N = mkN "hankaluus" | mkN "vaikeus" ;
lin traditional_A = mkWA (k38 "perinteinen") | mkA "traditionaalinen" ;
lin payment_N = mkN "maksu" ;
lin best_Adv = mkWAdv (k99 "parhaiten") ;
lin post_N = mkWN (kH1 "posti") ;
lin county_N = mkWN (compoundN "maa" (k10A "kunta")) | mkWN (compoundN "kreivi" (k10A "kunta")) ;
lin lady_N = mkN "lady" "ladyja" ;
lin holiday_N = mkWN (k10 "loma") ;
lin realize_VS = mkWVS (k74 "älytä") ;
lin realize_V2 = mkV2 "toteuttaa" ;
lin importance_N = mkWN (k40 "tärkeys") ;
lin chair_N = L.chair_N ;
lin facility_N = mkN "fasiliteetti" ;
lin complete_V2 = mkV2 (mkV "täydentää") partitive ;
lin complete_V = mkWV (k54A "täydentää") ;
lin article_N = mkN "artikkeli" ;
lin object_N = mkN "objekti" | mkN "esine" ;
lin context_N = mkN "konteksti" | mkWN (k40 "yhteys") ;
lin survey_N = mkWN (k39 "kartoitus") ;
lin notice_VS = mkVS (mkV "huomata") ;
lin notice_V2 = mkV2 "huomata" ;
lin complete_A = mkA "täydellinen" ;
lin turn_N = mkN "käänne" | mkN "vuoro" ; ---- split
lin direct_A = mkWA (k10 "suora") ;
lin immediately_Adv = mkAdv "välittömästi" ;
lin collection_N = mkN "kokoelma" ;
lin reference_N = mkN "viite" | mkN "referenssi" ;
lin card_N = mkWN (k5A "kortti") ;
lin interesting_A = mkA "kiinnostava" | mkA "mielenkiintoinen" | mkWA (k10 "kiintoisa") ;
lin considerable_A = mkA "huomattava" | mkWA (k10 "varteenotettava") ;
lin television_N = L.television_N ;
lin extend_V2 = mkV2 "laajentaa" | mkV2 "pidentää" ;
lin extend_V = mkV "jatkua" ;
lin communication_N = mkN "kommunikaatio" | mkN "tiedon" (mkN "välitys") ;
lin agency_N = mkN "virasto" ;
lin physical_A = mkA "fyysinen" | mkA "fysikaalinen" | mkWA (k38 "ruumiillinen") ; ---- split
lin except_Conj = mkConj "paitsi" ;
lin check_V2 = mkV2 "tarkastaa" | mkV2 "tarkistaa" | mkV2 "estää" ; ---- split
lin check_V = mkV "tarkastaa" ; ---- subcat
lin sun_N = L.sun_N ;
lin species_N = mkWN (k5 "laji") ;
lin possibility_N = mkN (lin NK {s = d40 "mahdollisuus"}) ;
lin officialMasc_N = mkN "virkailija" ;
lin chairman_N = mkN "puheenjohtaja" | mkN "puhe" L.man_N ;
lin speaker_N = mkN "puhuja" | mkWN (k33A "kaiutin") ; ---- split
lin second_N = mkN "sekunti" | mkN "kakkonen" ; ---- split
lin career_N = mkWN (k10 "ura") ;
lin laugh_VS = mkVS (mkV "nauraa") ;
lin laugh_V2 = mkV2 "nauraa" allative ;
lin laugh_V = L.laugh_V ;
lin weight_N = mkWN (k1 "paino") ;
lin sound_VS = mkVS (mkV "kuulostaa") ;
lin sound_VA = mkVA (mkV "kuulostaa") (mkPrep ablative) ;
lin sound_V2 = mkV2 (mkV "kuulostaa") ablative ;
lin sound_V = mkV "soida" ;
lin responsible_A = mkWA (k38 "vastuullinen") ;
lin base_N = mkN "perusta" | mkN "kanta" ;
lin document_N = mkN "dokumentti" | mkN "asia" (mkN "kirja") ;
lin solution_N = mkWN (k2 "ratkaisu") | mkN "liuos" ; ---- split
lin return_N = mkWN (k17 "paluu") ;
lin medical_A = mkA "lääketieteellinen" | mkWA (k38 "lääkinnällinen") ;
lin hot_A = L.hot_A ;
lin recognize_VS = mkWVS (k54A "myöntää") ;
lin recognize_4_V2 = mkV2 "tunnistaa" ; ---- sense ?
lin recognize_1_V2 = mkV2 "tuntea" ; ---- sense ?
lin talk_N = mkN "puhe" ;
lin budget_N = mkWN (k5A "budjetti") ;
lin river_N = L.river_N ;
lin fit_V2 = mkV2 "sovittaa" partitive ;
lin fit_V = mkV "sopia" | mkV "mahtua" ;
lin organization_N = mkN "organisaatio" ;
lin existing_A = mkA "olemassaoleva" ;
lin start_N = mkN "lähtö" ;
lin push_VS = mkWVS (k53 "patistaa") ;
lin push_V2V = mkWV2V (k53 "patistaa") ;
lin push_V2 = L.push_V2 ;
lin push_V = mkV "työntää" ;
lin tomorrow_Adv = mkWAdv (k99 "huomenna") ;
lin requirement_N = mkN "vaatimus" ;
lin cold_A = L.cold_A ;
lin edge_N = mkN "terä" | mkWN (k10 "särmä") | mkN "reuna" ; ---- split
lin opposition_N = mkN "oppositio" | mkN "vastustus" ;
lin opinion_N = mkN "mielipide" ;
lin drug_N = mkWN (k48 "huume") | mkN "lääke" ; ---- split
lin quarter_N = mkN "neljännes" | mkN "neljäs" (mkN "osa") | mkN "vartti" ;
lin option_N = mkN "optio" ;
lin sign_V2 = mkV2 "allekirjoittaa" ;
lin sign_V = mkV "allekirjoittaa" ;
lin worth_Prep = mkPrep "arvoinen" ; ---- cat
lin call_N = mkN "kutsu" ;
lin define_V2 = mkV2 "määritellä" ;
lin define_V = mkV "määritellä" ;
lin stock_N = mkN (lin NK {s = d48A "osake"}) | mkN "liemi" ; ---- split
lin influence_N = mkWN (k39 "vaikutus") ;
lin occasion_N = mkWN (k39 "tapaus") ;
lin eventually_Adv = mkAdv "lopulta" ;
lin software_N = mkN "ohjelmisto" ;
lin highly_Adv = mkAdv "suuressa määrin" ;
lin exchange_N = mkN "vaihto" ;
lin lack_N = mkN "puute" ;
lin shake_V2 = mkV2 "ravistaa" ;
lin shake_V = mkV "vavista" ;
lin study_V2 = mkWV2 (k67 "opiskella") partitive ;
lin study_V = mkWV (k67 "opiskella") ;
lin concept_N = mkN "käsite" | mkN "konsepti" ;
lin blue_A = L.blue_A ;
lin star_N = L.star_N ;
lin radio_N = L.radio_N ;
lin arrangement_N = mkN "järjestely" ;
lin examine_V2 = mkV2 (lin VK {s = c61 "tutkia"}) ;
lin bird_N = L.bird_N ;
lin green_A = L.green_A ;
lin band_N = mkWN (k9A "panta") ;
lin sex_N = mkN "seksi" | mkN "sukupuoli" "sukupuolia" ; ---- split
lin finger_N = mkWN (k7 "sormi") ;
lin past_N = mkN "menneisyys" ;
lin independent_A = mkWA (k38 "itsenäinen") ;
lin independent_2_A = mkA "itsenäinen" ;
lin independent_1_A = mkA "riippumaton" ;
lin equipment_N = mkWN (k1 "kalusto") | mkN "varuste" ;
lin north_N = mkN (lin NK {s = d38 "pohjoinen"}) ;
lin mind_VS = mkWVS (k62 "huomioida") ;
lin mind_V2 = mkWV2 (k62 "huomioida") ;
lin mind_V = mkV "pahastua" ;
lin move_N = mkN "siirto" ;
lin message_N = mkN "viesti" ;
lin fear_N = mkN "pelko" ;
lin afternoon_N = mkN "ilta" (mkN "päivä") ;
lin drink_V2 = L.drink_V2 ;
lin drink_V = mkV "juoda" ;
lin fully_Adv = mkAdv "täysin" ;
lin race_N = mkN "kilpailu" ;
lin race_2_N = mkN "rotu" ;
lin race_1_N = mkN "kilpailu" ;
lin gain_V2 = mkV2 (mkV "voittaa") partitive ;
lin gain_V = mkV "voittaa" ;
lin strategy_N = mkN (lin NK {s = d12 "strategia"}) ;
lin extra_A = mkA "ylimääräinen" ;
lin scene_N = mkN "näkymä" ;
lin slightly_Adv = mkAdv "jossain määrin" ;
lin kitchen_N = mkWN (k3 "keittiö") ;
lin speech_N = mkN "puhe" ;
lin arise_V = mkV (lin VK {s = c66 "nousta"}) ;
lin network_N = mkN "verkosto" ;
lin tea_N = mkN "tee" ;
lin peace_N = L.peace_N ;
lin failure_N = mkN "epä" (mkN "onnistuminen") ;
lin employee_N = mkN "työntekijä" ;
lin ahead_Adv = mkWAdv (k99 "edellä") ;
lin scale_N = mkN "mittakaava" | mkWN (k1 "suomu") ; ---- split
lin hardly_Adv = mkAdv "tuskin" ;
lin attend_V2 = mkV2 "osallistua" elative ;
lin attend_V = mkV "osallistua" ;
lin shoulder_N = mkN "olka" (mkN "pää") | mkN "hartia" | mkWN (k49A "piennar") ; ---- split
lin otherwise_Adv = mkWAdv (k99 "muuten") ;
lin railway_N = mkN "rautatie" | mkWN (k9A "rata") ;
lin directly_Adv = mkAdv "suoraan" ;
lin supply_N = mkN "tarjonta" ;
lin expression_N = mkN "ilmaisu" | mkN "ilmaus" ;
lin owner_N = mkN (lin NK {s = d10 "omistaja"}) ;
lin associate_V2 = mkWV2 (k62 "assosioida") ;
lin associate_V = mkV "assosioitua" ;
lin corner_N = mkWN (k10 "kulma") ;
lin past_A = mkA "entinen" ;
lin match_N = mkN "vastine" ;
lin match_3_N = mkN "yhteensopivuus" | mkN "vastine" ;
lin match_2_N = mkN "tuli" (mkN "tikku") ;
lin match_1_N = mkN "ottelu" | mkN "matsi" ;
lin sport_N = mkN "urheilu" ;
lin status_N = mkN "asema" ;
lin beautiful_A = L.beautiful_A ;
lin offer_N = mkN "tarjous" ;
lin marriage_N = mkN "avioliitto" ;
lin hang_V2 = mkV2 "ripustaa" | mkWV2 (k53A "riiputtaa") | mkV2 "hirttää" ; ---- split
lin hang_V = mkV "riippua" | mkV "roikkua" ;
lin civil_A = mkA "siviili" ; ---
lin perform_V2 = mkV2 "suorittaa" ;
lin perform_V = mkV "esittää" ;
lin sentence_N = mkN "lause" | mkWN (k3 "tuomio") ; --- split
lin crime_N = mkWN (k39 "rikos") ;
lin ball_N = mkN "pallo" ;
lin marry_V2 = mkV2 "naida" ;
lin marry_V = mkV L.go_V "naimisiin" | mkV "avioitua" ;
lin wind_N = L.wind_N ;
lin truth_N = mkWN (k40 "totuus") ;
lin protect_V2 = mkV2 "suojella" partitive ;
lin protect_V = mkWV (k67 "suojella") ;
lin safety_N = mkN "turvallisuus" ;
lin partner_N = mkWN (k6 "partneri") | mkN "kumppani" ;
lin completely_Adv = mkAdv "täysin" ;
lin copy_N = mkN "kopio" | mkN "jäljennös" ;
lin balance_N = mkN "tasapaino" | mkN "balanssi" ;
lin sister_N = L.sister_N ;
lin reader_N = mkN "lukija" | mkN "lukemisto" ; ---- split
lin below_Adv = mkAdv "alapuolella" ;
lin trial_N = mkWN (k5 "testi") ;
lin rock_N = L.rock_N ;
lin damage_N = mkN "vahinko" ;
lin adopt_V2 = mkV2 "omaksua" ;
lin newspaper_N = L.newspaper_N ;
lin meaning_N = mkN "merkitys" ;
lin light_A = mkA "kevyt" | mkWA (k10 "valoisa") ; ---- split
lin essential_A = mkA "olennainen" ;
lin obvious_A = mkWA (kH1 "ilmeinen") ;
lin nation_N = mkN "kansa" (mkN "kunta") ;
lin confirm_VS = mkVS (mkV "vahvistaa") ;
lin confirm_V2 = mkV2 "vahvistaa" | mkV2 "varmistaa" ;
lin south_N = mkWN (k10 "etelä") ;
lin length_N = mkWN (k40 "pituus") ;
lin branch_N = mkWN (k9 "haara") | mkN "oksa" ; ---- split
lin deep_A = mkWA (k10 "syvä") | mkA "syvällinen" ; ---- split ?
lin none_NP = S.nothing_NP ** {s = \\c => "ei" ++ S.nothing_NP.s ! c} ;
lin planning_N = mkWN (k2 "suunnittelu") ;
lin trust_N = mkN (lin NK {s = d39 "luottamus"}) ;
lin working_A = mkA "toimiva" | mkA "työtätekevä" ; ---- split
lin pain_N = mkWN (k1A "särky") | mkN "kipu" ;
lin studio_N = mkWN (k3 "studio") ;
lin positive_A = mkA "positiivinen" | mkA "myönteinen" ; ---- split
lin spirit_N = mkN "henki" ;
lin college_N = mkWN (k8 "college") ; ---- yliopisto
lin accident_N = mkN "onnettomuus" | mkN "sattuma" ; ---- split
lin star_V2 = mkV2 "esiintyä" inessive ; ---- sense
lin hope_N = mkWN (k1 "toivo") ;
lin mark_V3 = mkV3 (mkV "merkitä") accusative (mkPrep allative) ; ---- sense
lin mark_V2 = mkWV2 (k53A "merkitä") ;
lin works_N = mkN "laitos" | mkWN (compoundN "suur" (k19 "työ")) ; ---- split: water works ; collected words
lin league_N = mkWN (k1A "liitto") ;
lin league_2_N = mkN "liiga" ;
lin league_1_N = mkN "liiga" ;
lin clear_V2 = mkWV2 (k53 "puhdistaa") ;
lin clear_V = mkV "selkeytyä" ;
lin imagine_VS = mkVS (mkV "kuvitella") ;
lin imagine_V2 = mkV2 "kuvitella" ;
lin imagine_V = mkV "kuvitella" ;
lin through_Adv = mkAdv "läpi" ;
lin cash_N = mkN "käteinen" ;
lin normally_Adv = mkAdv "normaalisti" ;
lin play_N = mkN "näytelmä" ;
lin strength_N = mkN "vahvuus" ;
lin train_N = L.train_N ;
lin travel_V2 = mkV2 "matkustaa" illative ;
lin travel_V = L.travel_V ;
lin target_N = mkN "maalitaulu" | mkN "kohde" ; ---- split concrete vs. abstract
lin very_A = mkA "nimenomainen" ;
lin pair_N = mkWN (kH1 "pari") ;
lin male_A = mkA "miespuolinen" | mkA "urospuolinen" ;
lin gas_N = mkWN (k1 "kaasu") | mkN "bensiini" | mkN "bensa" ; ---- split liquid or gas ; gasoline
lin issue_V2 = mkV2 "julkaista" ;
lin issue_V = mkWV (k67 "tulla") "esiin" ; ---- sense
lin contribution_N = mkWN (k40 "panos") ;
lin complex_A = mkA "monimutkainen" ;
lin supply_V2 = mkV2 "tarjota" partitive ;
lin beat_V2 = mkV2 "hakata" partitive | mkV2 "lyödä" partitive ;
lin beat_V = mkWV (k52A "takoa") ;
lin artist_N = mkN "taiteilija" | mkWN (k5 "artisti") ;
lin agentMasc_N = mkN "agentti" | mkN "edustaja" ;
lin presence_N = mkN "läsnäolo" ;
lin along_Adv = mkAdv "mukana" | mkAdv "mukaan" ; ---- split be along ; go along
lin environmental_A = mkA (separateN "ympäristöä" (mkN "koskeva")) ;
lin strike_V2 = mkV2 "iskeä" allative ;
lin strike_V = mkV "iskeä" ;
lin contact_N = mkN "kontakti" | mkWN (k40 "yhteys") ;
lin protection_N = mkN "suojelu" ;
lin beginning_N = mkN "alku" ; ---- END checked AR
lin demand_VS = mkWVS (k61A "vaatia") ;
lin demand_V2 = mkWV2 (k61A "vaatia") ; --f52
lin media_N = mkN "media" ;
lin relevant_A = mkWA (k38 "merkityksellinen") ; --UNCHK
lin employ_V2 = mkV2 "työllistää" ;
lin shoot_V2 = mkV2 "ampua" ; --mkWV2 (k53 "pistää") ;
lin shoot_V = mkWV (k53 "pistää") ; --UNCHK
lin executive_N = mkN (lin NK {s = d10 "johtaja"}) ;
lin slowly_Adv = mkAdv "hitaasti" ;
lin relatively_Adv = mkAdv "suhteellisesti" ;
lin aid_N = mkN (lin NK {s = d01A "apu"}) ;
lin huge_A = mkWA (k10 "valtava") ; --f167
lin late_Adv = mkWAdv (k99 "myöhään") ; --f122
lin speed_N = mkWN (k5A "vauhti") ;
lin review_N = mkWN (k39 "tarkastus") ; --f61
lin test_V2 = mkV2 "testata" ;
lin order_VS = mkWVS (k53 "järjestää") ; --UNCHK
lin order_V2V = mkWV2V (k53 "järjestää") ; --UNCHK
lin order_V2 = mkV2 "tilata" ;
lin order_V = mkWV (k53 "järjestää") ; --UNCHK
lin route_N = mkWN (k5A "reitti") ;
lin consequence_N = mkN "seuraus" ;
lin telephone_N = mkWN (k33 "puhelin") ; --f132
lin release_V2 = mkV2 "julkistaa" ;
lin proportion_N = mkWN (k40 "suhteellisuus") ; --UNCHK
lin primary_A = mkWA (compoundA "ensi" (k38 "sijainen")) ;
lin consideration_N = mkWN (k40 "huomaavaisuus") ;
lin reform_N = mkN (lin NK {s = d39 "uudistus"}) ;
lin driverMasc_N = mkN "ajaja" ;
lin annual_A = mkA "vuosittainen" ;
lin nuclear_A = mkA "ytimellinen" ; ---ARB mkWA "ydin-" ;
lin latter_A = mkWA (k38 "jälkimmäinen") ; --UNCHK
lin practical_A = mkWA (k38 "käytännöllinen") ; --UNCHK
lin commercial_A = mkWA (k38 "kaupallinen") ;
lin rich_A = mkA "rikas" ;
lin emerge_V = mkWV (k67 "tulla") "näkyviin" ; --f71
lin apparently_Adv = mkAdv "näennäisesti" ;
lin ring_V = mkV "soida" ;
lin ring_6_V2 = mkV2 "rengastaa" ;
lin ring_4_V2 = mkV2 (mkV "soittaa") allative ;
lin distance_N = mkWN (compoundN "väli" (k9 "matka")) ; --UNCHK
lin exercise_N = mkN "harjoitus" ; ---ARB mkWN (k2 "kuntoilu") ;
lin key_A = mkA "ratkaiseva" ;
lin close_Adv = mkWAdv (k99 "lähettyvillä") ; --f74
lin skin_N = L.skin_N ;
lin island_N = mkWN (k26 "saari") ;
lin separate_A = mkWA (k38 "erillinen") ; --f183
lin aim_VV = mkVV (mkV "aikoa") ;
lin aim_V2 = mkV2 (mkV "tähdätä") (casePrep illative) ; --f71
lin aim_V = mkV "tähdätä" ;
lin danger_N = mkWN (kH1 "vaara") ;
lin credit_N = mkN "luotto" ;
lin usual_A = mkWA (k38 "tavallinen") ;
lin link_V2 = mkV2 "yhdistää" ;
lin link_V = mkV "yhdistää" ;
lin candidateMasc_N = mkN "ehdokas" ;
lin track_N = mkN "ura" ;
lin safe_A = mkWA (k38 "turvallinen") ; --f70
lin interested_A = mkA ("kiinnostunut") ;
lin assessment_N = mkWN (k3 "arvio") ;
lin path_N = mkN "polku" ;
lin merely_Adv = mkAdv "pelkästään" | mkAdv "ainoastaan" ;
lin plus_Prep = mkPrep "plus" nominative ; ----
lin district_N = mkN "piiri" ;
lin regular_A = mkA "säännöllinen" ;
lin reaction_N = mkN "reaktio" "reaktioita" ;
lin impact_N = mkN (lin NK {s = d39 "vaikutus"}) ;
lin collect_V2 = mkV2 "kerätä" partitive ;
lin collect_V = mkWV (k53 "yhdistää") ; --UNCHK
lin debate_N = mkN "debatti" ;
lin lay_V2 = mkV2 "asettaa" ;
lin lay_V = mkWV (k53 "pistää") ; --UNCHK
lin rise_N = mkWN (k1 "nousu") ;
lin belief_N = mkWN (k48A "mielipide") ; --UNCHK
lin conclusion_N = mkWN (compoundN "pää" (k38 "ttäminen")) ; --UNCHK
lin shape_N = mkWN (k1A "muoto") ; --UNCHK
lin vote_N = mkWN (k39 "äänestys") ;
lin aim_N = mkWN (k33 "tähtäin") ; --UNCHK
lin politics_N = mkN "politiikka" ;
lin reply_VS = mkWVS (k73 "vastata") ;
lin reply_V = mkWV (k73 "vastata") ; --UNCHK
lin press_V2V = mkWV2V (k74A "vedota") ; --UNCHK
lin press_V2 = mkWV2 (k74A "vedota") ; --UNCHK
lin press_V = mkV "painostaa" ;
lin approach_V2 = mkV2 "lähestyä" partitive ;
lin approach_V = mkWV (k52A "lähentyä") ; --UNCHK
lin file_N = mkWN (k9 "viila") ; --UNCHK
lin western_A = mkA "läntinen" ;
lin earth_N = L.earth_N ;
lin public_N = mkWN (k2 "yleisö") ;
lin survive_V2 = mkWV2 (k75 "selvitä") ; --UNCHK
lin survive_V = mkV (mkV "säilyä") "hengissä" ; ---ARB mkWV (k75 "selvitä") ;
lin estate_N = mkN (lin NK {s = d09 "tila"}) ;
lin boat_N = L.boat_N ;
lin prison_N = mkN "vankila" ;
lin additional_A = mkA "lisätty" ;
lin settle_V2 = mkV2 (mkV (mkV "asettaa") "aloilleen") ; --f60
lin settle_V = mkWV (k52A "laskeutua") ; --f87
lin largely_Adv = mkAdv "suurin piirtein" ;
lin wine_N = L.wine_N ;
lin observe_VS = mkWVS (k53A "säilyttää") ; --UNCHK
lin observe_V2 = mkV2 "tarkkailla" partitive ; --mkWV2 (k53A "säilyttää") ;
lin limit_V2V = mkV2V "rajoittaa" ;
lin limit_V2 = mkV2 "rajoittaa" partitive ;
lin deny_V3 = mkWV3 (k53 "kiistää") ; --UNCHK
lin deny_V2 = mkWV2 (k53 "kiistää") ; --f84
lin for_PConj = mkPConj "sillä" ;
lin straight_Adv = mkWAdv (k99 "suoraan") ;
lin somebody_NP = S.somebody_NP ;
lin writer_N = mkWN (k12 "kirjailija") ; --f55
lin weekend_N = mkN "viikonloppu" ;
lin clothes_N = mkN "asu" | mkN "vaate" ; ---- plural only
lin active_A = mkA "aktiivinen" ;
lin sight_N = mkWN (k10 "näkymä") ; --UNCHK
lin video_N = mkN "video" ;
lin reality_N = mkWN (k40 "todellisuus") ;
lin hall_N = mkWN (k3 "lämpiö") ; --UNCHK
lin nevertheless_Adv = mkAdv "kuitenkin" ;
lin regional_A = mkWA (k38 "alueellinen") ; --f88
lin vehicle_N = mkWN (compoundN "ajo" (k1 "neuvo")) ; --f130
lin worry_VS = mkVS (caseV partitive (mkV "huolettaa")) ;
lin worry_V2 = mkV2 "huolestuttaa" partitive ;
lin worry_V = mkV vOlla "huolissaan" ; --f58
lin powerful_A = mkA (lin AK {s = d41A "voimakas"}) ;
lin possibly_Adv = mkAdv "mahdollisesti" ;
lin cross_V2 = mkWV2 (k53A "risteyttää") ; --UNCHK
lin cross_V = mkWV (k53A "risteyttää") ; --UNCHK
lin colleague_N = mkWN (k13 "kollega") ; --f55
lin charge_V2 = mkV2 "kuormittaa" partitive ;
lin charge_V = mkV "latautua" ;
lin lead_N = mkN "johto" (mkN "asema") ; --f56
lin farm_N = mkN "maatila" ;
lin respond_VS = mkWVS (k73 "vastata") ;
lin respond_V = mkWV (k73 "vastata") ;
lin employer_N = mkWN (compoundN "työn" (k10 "antaja")) ;
lin carefully_Adv = mkAdv "huolellisesti" ;
lin understanding_N = mkWN (k1 "äly") ; --UNCHK
lin connection_N = mkWN (k40 "yhteys") ;
lin comment_N = mkN "kommentti" ;
lin grant_V3 = mkWV3 (k54A "myöntää") ; --UNCHK
lin grant_V2 = mkWV2 (k54A "myöntää") ;
lin concentrate_V2 = mkWV2 (k53A "kiehuttaa") "vähiin" ; --UNCHK
lin concentrate_V = mkV "keskittyä" ; --WV (k53A "kiehuttaa") "vähiin" ;
lin ignore_V2 = mkWV2 (k67 "olla") "huomaamatta" ;
lin ignore_V = mkWV (k67 "olla") "huomaamatta" ; --UNCHK
lin phone_N = mkN "puhelin" ;
lin hole_N = mkWN (k1 "kolo") ; --UNCHK
lin insurance_N = mkN (lin NK {s = d39 "vakuutus"}) ;
lin content_N = mkWN (k48 "aihe") ; --UNCHK
lin confidence_N = mkN "luottamus" ;
lin sample_N = mkWN (k39 "otos") ; --UNCHK
lin transport_N = mkWN (k1A "siirto") ; --UNCHK
lin objective_N = mkN "tavoite" ; ---ARB mkWN (k5 "linssi") "objektiivin" ;
lin alone_A = mkA "yksi" ;
lin flower_N = L.flower_N ;
lin injury_N = mkN "vamma" ;
lin lift_V2 = mkWV2 (k71 "tehdä") "kasvojenkohotusleikkaus" ; --UNCHK
lin lift_V = mkWV (k71 "tehdä") "kasvojenkohotusleikkaus" ; --UNCHK
lin stick_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin stick_V = mkV "pistää" ; ----mkWV (k53A "sekoittaa") ;
lin front_A = mkA "etummainen" ;
lin mainly_Adv = mkAdv "pääasiassa" ;
lin battle_N = mkN "taistelu" ;
lin generation_N = mkN "suku" (mkN "polvi") ; --f62
lin currently_Adv = mkAdv "tällä hetkellä" ;
lin winter_N = mkN "talvi" ;
lin inside_Prep = mkPrep "sisällä" | mkPrep "sisälle" ; ---- split
lin impossible_A = mkWA (k34A "mahdoton") ;
lin somewhere_Adv = S.somewhere_Adv ;
lin arrange_V2 = mkV2 "järjestää" | mkWV2 (k67A "asetella") ;
lin arrange_V = mkWV (k67A "asetella") ; --UNCHK
lin will_N = mkWN (k1A "tahto") ; ---ARB mkN "testamentti" ;
lin sleep_V = L.sleep_V ;
lin progress_N = mkN "edistys" ;
lin volume_N = mkN "volyymi" ;
lin ship_N = L.ship_N ;
lin legislation_N = mkN "lain" (mkN "säädäntö") ;
lin commitment_N = mkN "sitoumus" ;
lin enough_Predet = {s = \\_,_ => "tarpeeksi"} ; ---- cat
lin conflict_N = mkN "konflikti" ; --WN (k14A "kahakka") ;
lin bag_N = mkWN (k1A "juttu") ; --UNCHK
lin fresh_A = mkA (lin AK {s = d48 "tuore"}) ;
lin entry_N = mkWN (compoundN "sisään" (k1 "tulo")) ;
lin entry_2_N = mkN "haku" (mkN "sana") ;
lin entry_1_N = mkN "pääsy" ;
lin smile_N = mkWN (k39 "virnistys") ; --UNCHK
lin fair_A = mkA "reilu" ;
lin promise_VV = mkWVV (k53A "vakuuttaa") ; --UNCHK
lin promise_VS = mkWVS (k53A "vakuuttaa") ;
lin promise_V2 = mkV2 "luvata" ;
lin promise_V = mkWV (k53A "vakuuttaa") ; --UNCHK
lin introduction_N = mkN "esittely" ; --WN (k38 "ensiesiintyminen") ;
lin senior_A = mkWA (k16A "vanhempi") ; --f286
lin manner_N = mkWN (k39 "käytös") ; --UNCHK
lin background_N = mkWN (k9 "tausta") ;
lin key_N = mkWN (k33 "avain") ;
lin key_2_N = mkN "sävel" (mkN "laji") ;
lin key_1_N = mkN "avain" "avaimen" "avaimia" ;
lin touch_V2 = mkV2 "koskea" partitive ; --mkWV2 (k52A "liittyä") ;
lin touch_V = mkWV (k52A "liittyä") ; --UNCHK
lin vary_V2 = mkV2 "vaihdella" partitive ; --mkWV2 (k52A "muuttua") ;
lin vary_V = mkV "vaihdella" ;
lin sexual_A = mkWA (k38 "seksuaalinen") ;
lin ordinary_A = mkWA (k38 "tavallinen") ;
lin cabinet_N = mkWN (k2 "kaapisto") ; --UNCHK
lin painting_N = mkN "maalaus" ;
lin entirely_Adv = mkAdv "kokonaan" ;
lin engine_N = mkWN (k6 "moottori") ; --f57
lin previously_Adv = mkAdv "aikaisemmin" ;
lin administration_N = mkN "hallinto" ;
lin tonight_Adv = mkWAdv "tänä" "iltana" ; --UNCHK
lin adult_N = mkN "aikuinen" ;
lin prefer_VV = mkWVV (k53A "pitää") "parempana" ; --UNCHK
lin prefer_V2 = mkV2 (mkWV (k53A "pitää") "parempana") partitive ;
lin author_N = mkWN (k12 "tekijä") ; --f57
lin actual_A = mkA "nykyinen" ;
lin song_N = L.song_N ;
lin investigation_N = mkWN (k9A "tutkinta") ;
lin debt_N = mkN (lin NK {s = d09A "velka"}) ;
lin visitor_N = mkN "vierailija" | mkWN (k41 "vieras") ;
lin forest_N = mkN "metsä" ;
lin repeat_VS = mkVS (mkV "toistaa") ;
lin repeat_V2 = mkV2 "toistaa" ;
lin repeat_V = mkWV (k52 "toistua") ;
lin wood_N = L.wood_N ;
lin contrast_N = mkWN (k2 "vertailu") ; --f59
lin extremely_Adv = mkAdv "äärimmäisesti" ;
lin wage_N = mkN "palkka" ;
lin domestic_A = mkWA (k38 "kotimainen") ; --f191
lin commit_V2 = mkV2 "harjoittaa" ; --f59 ---ARB ; tehdä ; velvoittaa , sitouttaa
lin threat_N = mkWN (k39 "uhkaus") ; --f84
lin bus_N = mkN (lin NK {s = d05 "bussi"}) ;
lin warm_A = L.warm_A ;
lin sir_N = mkWN (k9 "herra") ; --UNCHK
lin regulation_N = mkWN (k2 "säännöstely") ; --f87
lin drink_N = mkN "juoma" ;
lin relief_N = mkWN (k39 "helpotus") ; --f66
lin internal_A = mkA "sisäinen" ;
lin strange_A = mkWA (k38 "merkillinen") ;
lin excellent_A = mkA "erinomainen" ;
lin run_N = mkN "juoksu" ;
lin fairly_Adv = mkAdv "melkoisesti" ;
lin technical_A = mkWA (k38 "tekninen") ; --f78
lin tradition_N = mkWN (k48A "perinne") ; --UNCHK
lin measure_V2 = mkWV2 (k73A "mitata") ;
lin measure_V = mkWV (k73A "mitata") ; --UNCHK
lin insist_VS = mkWVS (k53A "vakuuttaa") ; --f77
lin insist_V2 = mkWV2 (k53A "vakuuttaa") ; --UNCHK
lin insist_V = mkV "inttää" ;
lin farmer_N = mkN "viljelijä" ;
lin until_Prep = postPrep elative "asti" | postPrep illative "saakka" ;
lin traffic_N = mkN "liikenne" ; --f64
lin dinner_N = mkWN (k38 "päivällinen") ; --UNCHK
lin consumer_N = mkWN (k10 "kuluttaja") ; --f319
lin meal_N = mkWN (k1 "jauho") ; --UNCHK
lin warn_VS = mkWVS (k53A "varoittaa") ;
lin warn_V2V = mkV2V (mkV "varoittaa") partitive infElat ;
lin warn_V2 = mkV2 "varoittaa" partitive ;
lin warn_V = mkWV (k53A "varoittaa") ;
lin living_A = mkWA (k10 "elävä") ; --UNCHK
lin package_N = mkN "pakkaus" "pakkauksen" "pakkauksia" ;
lin half_N = mkN (lin NK {s = d26 "puoli"}) ;
lin increasingly_Adv = mkWAdv (k99 "enemmän") "yhä" ; --f80
lin description_N = mkWN (k5 "laji") ; --UNCHK
lin soft_A = mkA "pehmeä" ;
lin stuff_N = mkWN (k1 "romu") ; --UNCHK
lin award_V3 = mkWV3 (k54A "ojentaa") ; --UNCHK
lin award_V2 = mkV2 "myöntää" ;
lin existence_N = mkWN (k40 "avaruus") ; --UNCHK
lin improvement_N = mkN "parannus" ;
lin coffee_N = mkN "kahvi" ;
lin appearance_N = mkWN (compoundN "esi" (k38 "intyminen")) ; --UNCHK
lin standard_A = mkA "vakiintunut" ; --f65
lin attack_V2 = mkWV2 (k53A "syövyttää") ; --UNCHK
lin sheet_N = mkN "arkki" ;
lin category_N = mkN "kategoria" ; --f53
lin distribution_N = mkN (lin NK {s = d02 "jakelu"}) ;
lin equally_Adv = mkAdv "yhtä" ;
lin session_N = mkN "istunto" ;
lin cultural_A = mkWA "viljely-" ; --UNCHK
lin loan_N = mkN "laina" ;
lin bind_V2 = mkV2 "sitoa" ; --WV2 (k53A "aiheuttaa") "ummetusta" ;
lin bind_V = mkWV (k53A "aiheuttaa") "ummetusta" ; --UNCHK
lin museum_N = mkWN (k3 "museo") ; --UNCHK
lin conversation_N = mkWN (k2 "keskustelu") ;
lin threaten_VV = mkVV "uhata" ;
lin threaten_VS = mkWVS (k67 "uhkailla") ; --UNCHK
lin threaten_V2 = mkV2 "uhata" partitive ;
lin threaten_V = mkWV (k67 "uhkailla") ; --UNCHK
lin link_N = mkWN (k48 "kahle") ; --UNCHK
lin launch_V2 = mkV2 (mkV (mkV "tuoda") "markkinoille") ;
lin launch_V = mkWV (k53A "aloittaa") ;
lin proper_A = mkWA (k38 "kunnollinen") ;
lin victim_N = mkWN (k5 "uhri") ;
lin audience_N = mkWN (k5 "audienssi") ; --f72
lin famous_A = mkWA (k41A "nimekäs") ; --UNCHK
lin master_N = mkN "mestari" ; ---ARB WN (k5 "originaali") ;
lin master_2_N = mkN "maisteri" ;
lin master_1_N = mkN "mestari" ;
lin lip_N = mkN "huuli" ; --mkWN (k9 "reuna") ;
lin religious_A = mkWA (k38 "kirkollinen") ; --UNCHK
lin joint_A = mkA (lin AK {s = d38 "yhteinen"}) ;
lin cry_V2 = mkWV2 (k61A "kyynelehtiä") ; --UNCHK
lin cry_V = mkWV (k61A "kyynelehtiä") ; --UNCHK
lin potential_A = mkA "potentiaalinen" ;
lin broad_A = L.broad_A ;
lin exhibition_N = mkWN (k39 "osoitus") ; --UNCHK
lin experience_V2 = mkWV2 (k58A "kokea") ;
lin judge_N = mkWN (k6 "tuomari") ; --f195
lin formal_A = mkWA (k38 "muodollinen") ; --f64
lin housing_N = mkN "asuntotuotanto" ;
lin past_Prep = mkPrep "ohi" ;
lin concern_V2 = mkV2 (mkV vOlla "tekemistä") (mkPrep "kanssa") ; --f65
lin freedom_N = mkWN (k40 "vapaus") ;
lin gentleman_N = mkWN (compoundN "herras" (k42 "mies")) ; --UNCHK
lin attract_V2 = mkV2 (mkWV (k53A "vetää") "puoleensa") partitive ;
lin explanation_N = mkWN (k39 "selitys") ; --UNCHK
lin appoint_V3 = mkWV3 (k53 "varustaa") ; --UNCHK
lin appoint_V2V = mkWV2V (k53 "varustaa") ; --UNCHK
lin appoint_V2 = mkV2 "nimittää" ; --WV2 (k53 "varustaa") ;
lin note_VS = mkVS (mkV "huomauttaa") ;
lin note_V2 = mkWV2 (k73 "huomata") ;
lin note_V = mkWV (k73 "huomata") ; --UNCHK
lin chief_A = mkA "johtava" ;
lin total_N = mkWN (k40 "kokonaisuus") ; --f112
lin lovely_A = mkWA (k38 "suloinen") ;
lin official_A = mkWA (k38 "virallinen") ; --f107
lin date_V2 = mkWV2 (k53A "määrittää") "ikä" ; --UNCHK
lin date_V = mkWV (k53A "määrittää") "ikä" ; --UNCHK
lin demonstrate_VS = mkWVS (k53 "vahvistaa") ; --UNCHK
lin demonstrate_V2 = mkWV2 (k53 "havainnollistaa") ;
lin demonstrate_V = mkV (mkV "osoittaa") "mieltä" ;
lin construction_N = mkN "konstruktio" "konstruktioita" ;
lin middle_N = mkWN (compoundN "keski" (k41 "ruumis")) ; --UNCHK
lin yard_N = mkWN (k39 "aitaus") ; --UNCHK
lin unable_A = mkWA (k34A "kyvytön") ;
lin acquire_V2 = mkV2 "hankkia" ;
lin surely_Adv = mkAdv "varmasti" ;
lin crisis_N = mkN (lin NK {s = d05 "kriisi"}) ;
lin propose_VV = mkVV "ehdottaa" infPresPartAgr ;
lin propose_VS = mkWVS (k53A "esittää") ; --UNCHK
lin propose_V2 = mkV2 "ehdottaa" partitive ;
lin propose_V = mkWV (k53A "esittää") ;
lin west_N = mkWN (k28 "länsi") ; --UNCHK
lin impose_V2 = mkV2 "määrätä" ;
lin impose_V = mkWV (k53A "tyrkyttää") ; --UNCHK
lin market_V2 = mkWV2 (k62 "markkinoida") partitive ;
lin market_V = mkWV (k62 "markkinoida") ;
lin care_V = mkV "välittää" ;
lin god_N = mkWN (k10 "jumala") ; --UNCHK
lin favour_N = mkN "palvelus" ;
lin before_Adv = mkAdv "ennen" ;
lin name_V3 = mkV3 (mkV "nimittää") accusative (mkPrep translative) ;
lin name_V2 = mkV2 "nimetä" ;
lin equal_A = mkA "samanarvoinen" ;
lin capacity_N = mkN "kapasiteetti" ;
lin flat_N = mkWN (k1A "asunto") ; --UNCHK
lin selection_N = mkWN (k9A "valinta") ; --UNCHK
lin alone_Adv = mkWAdv (k99 "yksin") ; --f92
lin football_N = mkN "jalka" (mkN "pallo") ;
lin victory_N = mkN "voitto" ;
lin factory_N = L.factory_N ;
lin rural_A = mkWA (k38 "maalaismainen") ; --UNCHK
lin twice_Adv = mkWAdv (k99 "kahdesti") ; --f56
lin sing_V2 = mkV2 "laulaa" ; --mkWV2 (k62 "vasikoida") ;
lin sing_V = L.sing_V ;
lin whereas_Subj = mkSubj "kun taas" ;
lin own_V2 = mkV2 "omistaa" ;
lin head_V2 = mkV2 "johtaa" partitive ;
lin head_V = mkV "johtaa" ; --f60
lin examination_N = mkWN (k2 "tarkastelu") ; --UNCHK
lin deliver_V2 = mkV2 "toimittaa" ; --f64
lin deliver_V = mkV (mkV "tuottaa") "tulosta" ; ---ARB mkWV (k63 "saada") "lapsi" ;
lin nobody_NP = S.nobody_NP ** {s = \\c => "ei" ++ S.nobody_NP.s ! c} ;
lin substantial_A = mkA "merkittävä" ;
lin invite_V2V = mkWV2V (k54A "pyytää") ; --UNCHK
lin invite_V2 = mkV2 "kutsua" ;
lin intention_N = mkWN (k39 "aikomus") ;
lin egg_N = L.egg_N ;
lin reasonable_A = mkWA (k38 "järjellinen") ; --f56
lin onto_Prep = mkPrep "päälle" ;
lin retain_V2 = mkV2 "pitää" ;
lin aircraft_N = mkWN (compoundN "lento" (k48 "kone")) ; --f85
lin decade_N = mkN "vuosi" (mkN "kymmen" "kymmenen" "kymmeniä") ;
lin cheap_A = mkWA (k38 "edullinen") ; --f84
lin quiet_A = mkWA (k38 "hiljainen") ;
lin bright_A = mkWA (k10 "loistava") ;
lin contribute_V2 = mkWV2 (k56 "maksaa") "osansa" ; --UNCHK
lin contribute_V = mkV "osallistua" ;
lin row_N = mkN "rivi" ; ---ARB mkWN (k1A "soutu") ;
lin search_N = mkN "haku" | mkWN (k9A "etsintä") ;
lin limit_N = mkWN (kH1 "raja") ;
lin definition_N = mkWN (k39 "rajaus") ; --UNCHK
lin unemployment_N = mkWN (k40 "työttömyys") ;
lin spread_V2 = mkV2 "levittää" ;
lin spread_V = mkV "levitä" ;
lin mark_N = mkN "merkki" ;
lin flight_N = mkN "lento" ;
lin account_V2 = mkWV2 (k73 "vastata") ; --UNCHK
lin account_V = mkWV (k73 "vastata") ; --f163
lin output_N = mkN "tuotos" ; ---ARB mkN "tuloste" ;
lin last_V = mkWV (k53A "rökittää") ; --UNCHK
lin tour_N = mkWN (k9 "matka") ; --UNCHK
lin address_N = mkWN (k40 "tahdikkuus") ; --UNCHK
lin immediate_A = mkWA (k34A "välitön") ; --f136
lin reduction_N = mkN "vähennys" ;
lin interview_N = mkN "haastattelu" ;
lin assess_V2 = mkWV2 (k67 "arvostella") ; --UNCHK
lin promote_V2 = mkV2 (mkV "edistää") partitive ;
lin promote_V = mkWV (k53 "edistää") ; --UNCHK
lin everybody_NP = S.everybody_NP ;
lin suitable_A = mkWA (k10 "sopiva") ;
lin growing_A = mkA "kasvava" ;
lin nod_V = mkWV (k52A "nuokkua") ; --UNCHK
lin reject_V2 = mkV2 (mkV "hylätä" "hylkäsi") ;
lin while_N = mkN "hetki" ;
lin high_Adv = mkWAdv (k99 "ylös") ; --UNCHK
lin dream_N = mkWN (k10 "unelma") ; --UNCHK
lin vote_VV = mkWVV (k53 "äänestää") ; ---???
lin vote_V3 = mkV3 (mkV "äänestää") accusative (mkPrep translative) ;
lin vote_V2 = mkWV2 (k53 "äänestää") ; --UNCHK
lin vote_V = mkWV (k53 "äänestää") ; --f109
lin divide_V2 = mkWV2 (k56A "jakaa") ;
lin divide_V = mkV "jakautua" ; --WV (k56A "jakaa") ;
lin declare_VS = mkVS (mkV "julistaa") ;
lin declare_V2 = mkWV2 (k53A "ilmoittaa") ; --UNCHK
lin declare_V = mkWV (k53A "ilmoittaa") ; --UNCHK
lin handle_V2 = mkV2 (mkV "käsitellä") partitive ;
lin handle_V = mkWV (k67A "käsitellä") ;
lin detailed_A = mkA "yksityiskohtainen" ;
lin challenge_N = mkN "haaste" ; --f56
lin notice_N = mkWN (k1A "havainto") ; --UNCHK
lin rain_N = L.rain_N ;
lin destroy_V2 = mkV2 "hävittää" ;
lin mountain_N = L.mountain_N ;
lin concentration_N = mkN "keskittyminen" ;
lin limited_A = mkA "rajoitettu" | mkA "rajattu" ;
lin finance_N = mkN "finanssi" ;
lin pension_N = mkWN (k48A "eläke") ; --f95
lin influence_V2 = mkWV2 (k67A "säännellä") ; --UNCHK
lin afraid_A = mkWA (k10 "oleva") "peloissaan" ; --UNCHK
lin murder_N = mkWN (k39 "teloitus") ; --UNCHK
lin neck_N = mkN "kaula" ; ---ARB mkN "niska"
lin weapon_N = mkWN (k48 "ase") ;
lin hide_V2 = mkWV2 (k74 "verhota") ; --UNCHK
lin hide_V = mkWV (k74 "verhota") ; --UNCHK
lin offence_N = mkWN (k39 "rikos") ; --UNCHK
lin absence_N = mkN "poissaolo" ; --WN (compoundN "jää" (k38 "minen")) "saapumatta" ;
lin error_N = mkN "virhe" ;
lin representativeMasc_N = mkN "edustaja" ;
lin enterprise_N = mkWN (k48A "hanke") ; --UNCHK
lin criticism_N = mkN "kritiikki" ; --f56
lin average_A = mkA "keskimääräinen" ;
lin quick_A = mkA "nopea" ;
lin sufficient_A = mkWA (k10 "riittävä") ;
lin appointment_N = mkN "nimitys" ;
lin match_V2 = mkV2 (mkV "vastata") (casePrep partitive) ; --f60
lin transfer_V = mkWV (k54A "siirtää") ; --UNCHK
lin acid_N = mkWN (k1A "happo") ;
lin spring_N = mkN "kevät" "kevään" "keväitä" ; ---AR mkWN (k39 "hyppäys") ; --f97
lin birth_N = mkWN (k10 "syntymä") ; --UNCHK
lin ear_N = L.ear_N ;
lin recognize_VS = mkWVS (k54A "myöntää") ;
lin recognize_4_V2 = mkV2 "tunnistaa" ; ---- sense ?
lin recognize_1_V2 = mkV2 "tuntea" ; ---- sense ?
lin recommend_V2V = mkV2V (mkV "suositella") partitive infIllat ;
lin recommend_V2 = mkV2 "suositella" ; --f53
lin module_N = mkWN (k6 "moduuli") ; --UNCHK
lin instruction_N = mkWN (k9A "didaktiikka") ; --UNCHK
lin democratic_A = mkA (lin AK {s = d38 "demokraattinen"}) ;
lin park_N = mkN "puisto" ;
lin weather_N = mkN "sää" ;
lin bottle_N = mkWN (k1 "pullo") ; --UNCHK
lin address_V2 = mkV2 (mkV (mkV "kohdistaa") "huomio") ;
lin bedroom_N = mkWN (k6 "kamari") ; --UNCHK
lin kid_N = mkN "lapsi" ; ---ARB mkWN (k10 "vohla") ;
lin pleasure_N = mkWN (k1A "nautinto") ;
lin realize_VS = mkWVS (k74 "älytä") ;
lin realize_V2 = mkV2 "toteuttaa" ;
lin assembly_N = mkN (lin NK {s = d39 "kokous"}) ;
lin expensive_A = mkA "kallis" ;
lin select_VV = mkWVV (k61 "poimia") ; --UNCHK
lin select_V2V = mkWV2V (k61 "poimia") ; --UNCHK
lin select_V2 = mkV2 "valita" ; ---ARB mkWV2 (k61 "poimia") ;
lin select_V = mkV "valikoitua" ;
lin teaching_N = mkN "opetus" ; --mkWN (k9A "didaktiikka") ;
lin desire_N = mkWN (k1 "himo") ;
lin whilst_Subj = variants{} ; -- 
lin contact_V2 = mkWV2 (k53A "ottaa") "yhteyttä" ; --UNCHK
lin implication_N = mkN "seuraus" ;
lin combine_VV = mkWVV (k53 "yhdistää") ; ---- subcat
lin combine_V2 = mkWV2 (k53 "yhdistää") ;
lin combine_V = mkWV (k53 "yhdistää") ;
lin temperature_N = mkWN (compoundN "lämpö" (k9 "tila")) ;
lin wave_N = mkN (lin NK {s = d01A "aalto"}) ;
lin magazine_N = mkN (lin NK {s = d05 "makasiini"}) ;
lin totally_Adv = mkAdv "kokonaan" ;
lin mental_A = mkA "henkinen" | mkWA (k38 "psyykkinen") ;
lin used_A = mkA "käytetty" ;
lin store_N = mkN "varasto" ;
lin scientific_A = mkWA (k38 "tieteellinen") ;
lin frequently_Adv = mkAdv "usein" ;
lin thanks_N = mkWN (k39 "kiitos") ;
lin beside_Prep = mkPrep "vieressä" ;
lin settlement_N = mkN "asutus" ;
lin absolutely_Adv = mkAdv "ehdottomasti" ;
lin critical_A = mkA "kriittinen" ;
lin critical_2_A = mkA "kriittinen" ;
lin critical_1_A = mkA "kriittinen" ;
lin recognition_N = mkN "tunnustus" ;
lin touch_N = mkWN (k39 "kosketus") ;
lin consist_V = mkV "koostua" ;
lin below_Prep = mkPrep "alapuolella" ;
lin silence_N = mkN "hiljaisuus" ;
lin expenditure_N = mkN "kulu" ;
lin institute_N = mkN "instituutti" ;
lin dress_V2 = mkV2 "pukea" ;
lin dress_V = mkV "pukeutua" ;
lin dangerous_A = mkA (lin AK {s = d38 "vaarallinen"}) ;
lin familiar_A = mkWA (k1A "tuttu") ;
lin asset_N = mkN "vara" ;
lin educational_A = mkA "kasvatuksellinen" ;
lin sum_N = mkN "summa" ;
lin publication_N = mkN "julkaisu" ;
lin partly_Adv = mkWAdv (k99 "osaksi") ;
lin block_N = mkN "blokki" ;
lin seriously_Adv = mkAdv "vakavasti" ;
lin youth_N = mkN "nuoruus" ;
lin tape_N = mkN "teippi" ; ---- split nauha
lin elsewhere_Adv = mkAdv "muualla" | mkWAdv (k99 "toisaalla") ;
lin cover_N = mkN "kansi" "kannen" "kansia" ;
lin fee_N = mkN (lin NK {s = d01 "maksu"}) ;
lin program_N = mkWN (k10 "ohjelma") ;
lin treaty_N = mkWN (k39 "sopimus") ;
lin necessarily_Adv = mkAdv "välttämättä" ;
lin unlikely_A = mkA ( mkN "epätoden" (mkN "näköinen")) ;
lin properly_Adv = mkAdv "kunnolla" ;
lin guest_N = mkN "vieras" | mkWN (k12 "vierailija") ;
lin code_N = mkN "koodi" ;
lin hill_N = L.hill_N ;
lin screen_N = mkN "näyttöruutu" ;
lin household_N = mkN "kotitalous" ;
lin sequence_N = mkN "jono" ;
lin correct_A = L.correct_A ;
lin female_A = mkWA (compoundA "nais" (k38 "puolinen")) ;
lin phase_N = mkWN (k48 "vaihe") ;
lin crowd_N = mkWN (k1A "joukko") ;
lin welcome_V2 = mkWV2 (mkV "toivottaa") "tervetulleeksi" ;
lin metal_N = mkWN (k5 "metalli") ;
lin human_N = mkWN (k38 "ihminen") ;
lin widely_Adv = mkAdv "laajalti" ;
lin undertake_V2 = mkWV2 (k52A "sitoutua") ; --UNCHK
lin cut_N = mkN "leikkaus" ;
lin sky_N = L.sky_N ;
lin brain_N = mkN "aivo" ;
lin expert_N = mkWN (k5A "ekspertti") | mkN "asiantuntija" "asiantuntijoita" ;
lin experiment_N = mkN "koe" ;
lin tiny_A = mkA "pikkuruinen" ;
lin perfect_A = mkWA (k38 "täydellinen") ;
lin disappear_V = mkV "kadota" ;
lin initiative_N = mkN "aloite" ;
lin assumption_N = mkN "oletus" ;
lin photograph_N = mkN "valokuva" ;
lin ministry_N = mkN "ministeriö" ;
lin congress_N = mkN "kongressi" ;
lin transfer_N = mkN "siirto" ;
lin reading_N = mkN "lukeminen" ; ---- split mkN "lukema" "lukemia" ;
lin scientist_N = mkN "tiede" L.man_N ;
lin fast_Adv = mkAdv "nopeasti" ;
lin fast_A = mkWA (k15 "nopea") ;
lin closely_Adv = mkAdv "läheisesti" ;
lin thin_A = L.thin_A ;
lin solicitorMasc_N = mkN "laki" L.man_N ; ---- sense
lin secure_V2 = mkV2 "turvata" ;
lin plate_N = mkN "levy" ;
lin pool_N = mkN "allas" ;
lin gold_N = L.gold_N ;
lin emphasis_N = mkWN (k39 "painotus") ;
lin recall_VS = mkVS "muistaa" ;
lin recall_V2 = mkWV2 (k64 "tuoda") "mieleen" ; --UNCHK
lin shout_V2 = mkWV2 (k73A "loukata") ; --UNCHK
lin shout_V = mkWV (k73A "loukata") ; --UNCHK
lin generate_V2 = mkV2 "tuottaa" ; --f73
lin location_N = mkN "sijainti" ; --f54
lin display_VS = variants{}; -- mkV2 "näyttää" ;
lin display_V2 = mkV2 "näyttää" ;
lin heat_N = mkN "lämpö" ;
lin gun_N = mkN "ase" ; --WN (compoundN "tykin" (k39 "laukaus")) ;
lin shut_V2 = mkWV2 (k52A "sulkeutua") ; --UNCHK
lin journey_N = mkWN (k2 "matkailu") ; --UNCHK
lin imply_VS = mkWVS (k73 "vihjata") ; --UNCHK
lin imply_V2 = mkWV2 (k73 "vihjata") ; --UNCHK
lin imply_V = mkWV (k73 "vihjata") ; --UNCHK
lin violence_N = mkWN (compoundN "väki" (k9A "valta")) ; --UNCHK
lin dry_A = L.dry_A ;
lin historical_A = mkWA (k38 "historiallinen") ;
lin step_V2 = mkV2 "astua" ; ---ARB ; porrastaa ; pengertää
lin step_V = mkV (lin VK {s = c52 "astua"}) ;
lin curriculum_N = mkWN (compoundN "opetus" (k10 "suunnitelma")) ; --UNCHK
lin noise_N = mkN "häly" ; --mkWN (k40 "umpimähkäisyys") ;
lin lunch_N = mkWN (k41 "lounas") "virallinen" ; --UNCHK
lin fear_VS = L.fear_VS ;
lin fear_V2 = L.fear_V2 ;
lin fear_V = mkWV (k53A "kunnioittaa") "syvästi" ; --UNCHK
lin succeed_V2 = mkWV2 (k73 "seurata") partitive ;
lin succeed_V = mkV "onnistua" ;
lin fall_N = mkN "putoaminen" ;
lin fall_2_N = variants{} ; -- 
lin fall_1_N = variants{} ; -- 
lin bottom_N = mkN "pohja" ;
lin initial_A = mkA "alustava" ;
lin theme_N = mkN "teema" ;
lin characteristic_N = mkWN (compoundN "tunto" (k5A "merkki")) ; --UNCHK
lin pretty_Adv = mkAdv "aika" ; ---- cat : should be AdA
lin empty_A = L.empty_A ;
lin display_N = mkN "näyttö" ; ---ARB mkWN (k2 "näyttely") ;
lin combination_N = mkN "yhdistelmä" ; --WN (k3 "kombinaatio") ;
lin interpretation_N = mkWN (k9A "tulkinta") ; --UNCHK
lin rely_V2 = variants{}; -- mkWV (k53A "luottaa") ; --f52
lin rely_V = mkWV (k53A "luottaa") ; --f52
lin escape_VS = variants{}; -- mkV2 "paeta" partitive ;
lin escape_V2 = mkV2 "paeta" partitive ;
lin escape_V = mkV (mkV "lähteä") "pakoon" ;
lin score_V2 = mkWV2 (k73 "korjata") ; --UNCHK
lin score_V = mkWV (k73 "korjata") ; --UNCHK
lin justice_N = mkN "oikeus" ;
lin upper_A = mkWA (k16A "ylempi") ; --UNCHK
lin tooth_N = L.tooth_N ;
lin organize_V2V = mkWV2V (k53 "järjestää") ; --UNCHK
lin organize_V2 = mkV2 "organisoida" ;
lin cat_N = L.cat_N ;
lin tool_N = mkWN (k48 "väline") ; --f53
lin spot_N = mkN "kohta" ; --WN (k10A "läikkä") ; --f62 ---ARB
lin bridge_N = mkN "silta" ;
lin double_A = mkA "kaksinkertainen" ; --WA (compoundA "kahden" (k38 "arvoinen")) ;
lin direct_V2 = mkWV2 (k53A "toteuttaa") ; --UNCHK
lin direct_V = mkWV (k53A "toteuttaa") ; --UNCHK
lin conclude_VS = mkWVS (k67A "päätellä") ; --f52
lin conclude_V2 = mkWV2 (k67A "päätellä") ; --UNCHK
lin conclude_V = mkWV (k67A "päätellä") ; --UNCHK
lin relative_A = mkA "suhteellinen" ;
lin soldier_N = mkWN (k38 "työläinen") ; --UNCHK
lin climb_V2 = mkV2 (mkV "kiivetä") partitive ; --f56
lin climb_V = mkWV (k74A "kiivetä") ; --f63
lin breath_N = mkWN (k2 "henkäisy") ;
lin afford_V2V = mkWV2V (k67 "olla") "varaa" ; --UNCHK
lin afford_V2 = mkV2 (caseV adessive (mkV olla_V "varaa")) illative ;
lin urban_A = mkWA (k6 "urbaani") ; --UNCHK
lin nurse_N = mkWN (k10 "imettäjä") ; --UNCHK
lin narrow_A = L.narrow_A ;
lin liberal_A = mkWA (k38 "liberaalinen") ; --UNCHK
lin coal_N = mkN "hiili" "hiiliä" ; --WN (k48 "kekäle") ;
lin priority_N = mkN (lin NK {s = d05A "prioriteetti"}) ;
lin wild_A = mkA "villi" ;
lin revenue_N = mkN "tulo" ;
lin membership_N = mkN "jäsenyys" ;
lin grant_N = mkN "apuraha" ;
lin approve_V2 = mkV2 "hyväksyä" ;
lin approve_V = mkWV (k52 "hyväksyä") ; --f63
lin tall_A = mkWA (k41A "kookas") ; --UNCHK
lin apparent_A = mkA "ilmeinen" ;
lin faith_N = mkWN (k1 "usko") ; --UNCHK
lin under_Adv = mkWAdv (k99 "tuonnempana") ; --UNCHK
lin fix_V2 = mkV2 "kiinnittää" ;
lin fix_V = mkV "kiinnittää" ;
lin slow_A = mkWA (k41A "hidas") ; --f115
lin troop_N = mkN "joukko" ;
lin motion_N = mkWN (k48A "liike") ;
lin leading_A = variants{} ; -- 
lin component_N = mkWN (k5A "komponentti") ;
lin bloody_A = mkA "verinen" ;
lin literature_N = mkN "kirjallisuus" ;
lin conservative_A = mkWA (k38 "konservatiivinen") ; --f85
lin variation_N = mkWN (k2 "vaihtelu") ;
lin remind_V2 = mkWV2 (k53A "muistuttaa") ; --UNCHK
lin inform_V2 = mkWV2 (k56 "painaa") "leimansa" ; --UNCHK
lin inform_V = mkWV (k56 "painaa") "leimansa" ; --UNCHK
lin alternative_N = mkN "vaihto" (mkN "ehto") ; --f79
lin neither_Adv = variants{} ; -- 
lin outside_Adv = mkWAdv (k99 "ulkosalla") ; --UNCHK
lin mass_N = mkWN (k1 "messu") ; --UNCHK
lin busy_A = mkWA (k38 "kiireinen") ;
lin chemical_N = mkN "kemikaali" ;
lin careful_A = mkWA (k38 "varovainen") ;
lin investigate_V2 = mkV2 "tutkia" ;
lin investigate_V = mkWV (k67 "tiedustella") ; --UNCHK
lin roll_V2 = mkWV2 (k61 "kääriä") ;
lin roll_V = mkWV (k61 "kieriä") ;
lin instrument_N = mkWN (k48 "väline") ; --f64
lin guide_N = mkWN (k9A "merkintä") ; --UNCHK
lin criterion_N = mkWN (k6 "standardi") ; --UNCHK
lin pocket_N = mkWN (k1 "tasku") ; --UNCHK
lin suggestion_N = mkWN (k3 "suggestio") ; --UNCHK
lin aye_Interj = variants{} ; -- 
lin entitle_VS = mkWVS (k75 "nimetä") ; --UNCHK
lin entitle_V2V = mkV2V (mkV "oikeuttaa") accusative infIllat ; --mkWV2V (k75 "nimetä") ;
lin tone_N = mkN "sävy" | mkWN (k48A "vivahde") ;
lin attractive_A = mkWA (k10 "viehättävä") ;
lin wing_N = L.wing_N ;
lin surprise_N = mkN "yllätys" ;
lin male_N = mkWN (k41 "koiras") ; --UNCHK
lin ring_N = mkWN (k41A "rengas") ; ---ARB ; sormus ; kilinä ; sävy
lin pub_N = mkWN (k5 "pub") ; --UNCHK
lin fruit_N = L.fruit_N ;
lin passage_N = mkWN (k10 "siirtymä") ; --UNCHK
lin illustrate_VS = mkWVS (k53A "esittää") ; --UNCHK
lin illustrate_V2 = mkWV2 (k53A "esittää") ; --UNCHK
lin illustrate_V = mkWV (k53A "esittää") ; --UNCHK
lin pay_N = mkN "palkka" ;
lin ride_V2 = mkWV2 (k53A "ärsyttää") ; --UNCHK
lin ride_V = mkWV (k53A "ärsyttää") ; --UNCHK
lin foundation_N = mkN "säätiö" ; --WN (k3 "initiaatio") ;
lin restaurant_N = L.restaurant_N ;
lin vital_A = mkWA (compoundA "elinvoi" (k38 "mainen")) ; --UNCHK
lin alternative_A = mkWA (compoundA "vaihtoeh" (k38 "toinen")) ; --UNCHK
lin burn_V2 = mkV2 "polttaa" ;
lin burn_V = L.burn_V ;
lin map_N = mkWN (k9A "kartta") ; --UNCHK
lin united_A = variants{} ; -- 
lin device_N = mkN "laite" ;
lin jump_V2 = mkV2 "anastaa" ; --f77
lin jump_V = L.jump_V ;
lin estimate_VS = mkVS "arvioida" ;
lin estimate_V2V = mkWV2V (k62 "estimoida") ; --UNCHK
lin estimate_V2 = mkV2 (mkV (lin VK {s = c62 "arvioida"})) partitive ;
lin estimate_V = mkWV (k62 "estimoida") ; --f77
lin conduct_V2 = mkWV2 (k53A "johtaa") ; --f57
lin conduct_V = mkWV (k53A "johtaa") ; --UNCHK
lin derive_V2 = mkV2 "johtaa" ;
lin derive_V = mkWV (k52A "kehittyä") ; --UNCHK
lin comment_VS = mkVS "kommentoida" ;
lin comment_V2 = variants{}; -- mkV "kommentoida" ;
lin comment_V = mkV "kommentoida" ;
lin east_N = mkWN (k10A "itä") ; --UNCHK
lin advise_VS = mkVS "neuvoa" ; --mkWVS (k73 "ohjata") ;
lin advise_V2 = mkV2 "neuvoa" partitive ;
lin advise_V = mkV "neuvoa" ;
lin advance_N = mkWN (compoundN "eteenpäin" (k1 "meno")) ; --f75
lin motor_N = mkWN (k6 "moottori") ; --UNCHK
lin satisfy_V2 = mkWV2 (k53A "toteuttaa") ; --UNCHK
lin hell_N = mkN "helvetti" ; --UNCHK
lin winner_N = mkN "voittaja" ; ---ARB mkWN "menestyjä" ;
lin effectively_Adv = variants{} ; -- 
lin mistake_N = mkN "erehdys" ;
lin incident_N = mkWN (k10 "tapahtuma") ; --UNCHK
lin focus_V2 = mkWV2 (k54A "tarkentaa") illative ;
lin focus_V = mkV "keskittyä" ;
lin exercise_VV = mkWVV (k67 "kuntoilla") ; --UNCHK
lin exercise_V2 = mkV2 "harjoittaa" ;
lin exercise_V = mkWV (k67 "kuntoilla") ;
lin representation_N = mkWN (compoundN "edus" (k38 "taminen")) ;
lin release_N = mkN "päästäminen" ;
lin leaf_N = L.leaf_N ;
lin border_N = mkWN (k39 "reunus") ; --UNCHK
lin wash_V2 = L.wash_V2 ;
lin wash_V = mkWV (k53 "puhdistaa") "nuolemalla" ; --UNCHK
lin prospect_N = mkWN (k48 "ennuste") ; --f87
lin blow_V2 = mkWV2 (k54A "puhaltaa") ; --UNCHK
lin blow_V = L.blow_V ;
lin trip_N = mkN "matka" ;
lin observation_N = mkWN (k2 "tarkkailu") ; --UNCHK
lin gather_V2 = mkV2 "koota" ;
lin gather_V = mkV "kerääntyä" ;
lin ancient_A = mkWA (compoundA "iki" (k9 "vanha")) ;
lin brief_A = mkWA (k43 "lyhyt") ;
lin gate_N = mkWN (k5A "portti") ; --UNCHK
lin elderly_A = mkWA (k41A "iäkäs") ; --UNCHK
lin persuade_V2V = mkV2V (mkV "taivutella") accusative infIllat ;
lin persuade_V2 = mkWV2 (k53A "taivuttaa") ;
lin overall_A = mkA "totaalinen" ;
lin rare_A = mkWA (k38 "harvinainen") ;
lin index_N = mkN (lin NK {s = d05 "indeksi"}) ;
lin hand_V2 = mkWV2 (k53A "johdattaa") ; --UNCHK
lin circle_N = mkWN (k39 "kierros") ; --UNCHK
lin creation_N = mkWN (compoundN "luoma" (k10A "kunta")) ; --UNCHK
lin drawing_N = mkN "piirustus" ; --WN (k1A "otto") ;
lin anybody_NP = {s = table {NPAcc => "kenet" ++ "tahansa" ; c => S.kukaInt ! Sg ! npform2case Sg c ++ "tahansa"} ; a = agrP3 Sg ; isPron, isNeg = False} ;
lin flow_N = mkWN (k39 "virtaus") ; --f72
lin matter_V = mkWV (k67 "olla") "merkitystä" ; --UNCHK
lin external_A = mkWA (k38 "ulkoinen") ;
lin capable_A = mkWA (k10 "pystyvä") ; --UNCHK
lin recover_V = mkWV (k52A "tervehtyä") ;
lin shot_N = mkN "laukaus" ; ---ARB mkWN (k1A "lähtö") ;
lin request_N = mkN "pyyntö" ;
lin impression_N = mkWN (k10 "painauma") ; --UNCHK
lin neighbour_N = mkWN (k6 "naapuri") ; --UNCHK
lin theatre_N = mkWN (k2 "katsomo") ; --UNCHK
lin beneath_Prep = mkPrep "alapuolella" ;
lin hurt_V2 = mkV2 "loukata" ;
lin hurt_V = mkWV (k52A "sattua") ;
lin mechanism_N = mkWN (k9A "toiminta") ; --UNCHK
lin potential_N = mkN "potentiaali" ;
lin lean_V2 = mkWV2 (k52A "tukeutua") ; --UNCHK
lin lean_V = mkWV (k52A "tukeutua") ; --UNCHK
lin defendant_N = mkN (lin NK {s = d10 "vastaaja"}) ;
lin atmosphere_N = mkWN (k39 "tuulahdus") ; --UNCHK
lin slip_V2 = mkV2 "luiskahtaa" ; ----
lin slip_V = mkV "luisua" ; --f52
lin chain_N = mkN "ketju" ;
lin accompany_V2 = mkWV2 (k73 "seurata") ;
lin wonderful_A = mkWA (k38 "fantastinen") ; --UNCHK
lin earn_V2 = mkV2 "ansaita" ;
lin earn_V = mkWV (k53A "tuottaa") ; --f64
lin enemy_N = L.enemy_N ;
lin desk_N = mkWN (compoundN "työ" (k10A "pöytä")) ;
lin engineering_N = mkWN (k12 "teknologia") ; --f64
lin panel_N = mkWN (compoundN "ohjaus" (k6 "paneeli")) ; --f90
lin distinction_N = mkWN (k1 "ero") ;
lin deputy_N = mkN "sijainen" ;
lin discipline_N = mkWN (k39 "harjoitus") ; --UNCHK
lin strike_N = mkN "lakko" ;
lin strike_2_N = variants{} ; -- 
lin strike_1_N = variants{} ; -- 
lin married_A = variants{} ; -- 
lin plenty_NP = variants{} ; -- 
lin establishment_N = mkN "perustaminen" ; --WN (compoundN "koko" (k38 "aminen")) ;
lin fashion_N = mkN "muoti" ; ---ARB mkWN (k9A "tapa") ;
lin roof_N = L.roof_N ;
lin milk_N = L.milk_N ;
lin entire_A = mkA "kokonainen" ;
lin tear_N = mkWN "repiminen" ; --UNCHK
lin secondary_A = mkWA (compoundA "tois" (k38 "sijainen")) ;
lin finding_N = mkN "löydös" ; --WN "löytäminen" ;
lin welfare_N = mkWN (compoundN "sosiaali" (k39 "avustus")) ;
lin increased_A = variants{} ; -- 
lin attach_V2 = mkWV2 (k53A "liittää") ;
lin attach_V = mkWV (k53A "liittää") ; --UNCHK
lin typical_A = mkA (lin AK {s = d38 "tyypillinen"}) ;
lin typical_3_A = mkA "tyypillinen" ;
lin typical_2_A = variants{} ; -- 
lin typical_1_A = mkA "tyypillinen" ;
lin meanwhile_Adv = mkAdv "samaan aikaan" ; --f194
lin leadership_N = mkWN (k40 "johtajuus") ; --f60
lin walk_N = mkWN (k50 "vapaataival") ; --UNCHK
lin negotiation_N = mkWN (k2 "neuvottelu") ;
lin clean_A = L.clean_A ;
lin religion_N = L.religion_N ;
lin count_V2 = L.count_V2 ;
lin count_V = mkWV (k53A "ottaa") "lukuun" ;
lin grey_A = mkWA (k10 "harmahtava") ; --UNCHK
lin hence_Adv = mkAdv "sen vuoksi" ;
lin alright_Adv = mkWAdv (k99 "mukavasti") ; --UNCHK
lin first_A = variants{} ; -- 
lin fuel_N = mkWN (compoundN "poltto" (k48 "aine")) ; --f53
lin mine_N = mkWN (k9 "miina") ; --f57
lin appeal_V2 = mkV2 "vedota" illative ; --mkWV2 (k67 "rukoilla") ;
lin appeal_V = mkV "vedota" ;
lin servantMasc_N = variants{} ; -- 
lin liability_N = mkWN (k48A "rasite") ; --f86
lin constant_A = mkA "jatkuva" ;
lin hate_VV = variants{}; -- mkWV2V (k74 "inhota") ; --UNCHK
lin hate_V2 = L.hate_V2 ;
lin shoe_N = L.shoe_N ;
lin expense_N = mkWN (k39 "kustannus") ; --f149
lin vast_A = mkWA (k10 "valtava") ;
lin soil_N = mkWN (k48 "alue") ; --UNCHK
lin writing_N = mkWN (compoundN "kirjo" (k38 "ittaminen")) ;
lin nose_N = L.nose_N ;
lin origin_N = mkWN (compoundN "synty" (k10 "perä")) ; --UNCHK
lin lord_N = mkWN (compoundN "Kaikki" (k41 "valtias")) ; --UNCHK
lin rest_V2 = mkWV2 (k73A "levätä") ; --UNCHK
lin drive_N = mkN "ajomatka" ;
lin ticket_N = mkN "lippu" ;
lin editor_N = mkWN (k5 "editori") ; --f80
lin switch_V2 = mkWV2 (k54A "kääntää") "kelkkansa" ; --UNCHK
lin switch_V = mkV "vaihtaa" ;
lin provided_Subj = variants{} ; -- 
lin northern_A = mkWA (k38 "pohjoinen") ;
lin significance_N = mkWN (k40 "tärkeys") ; --UNCHK
lin channel_N = mkWN (k10 "kanava") ; --UNCHK
lin convention_N = mkWN (compoundN "koko" (k38 "ontuminen")) ; --UNCHK
lin damage_V2 = mkV2 (lin VK {s = c53A "vahingoittaa"}) ;
lin funny_A = mkA "hauska" ; --UNCHK
lin bone_N = L.bone_N ;
lin severe_A = mkWA (k10 "ankara") ;
lin search_V2 = mkWV2 (k58A "hakea") ; --UNCHK
lin search_V = mkWV (k58A "hakea") ; --UNCHK
lin iron_N = L.iron_N ;
lin vision_N = mkWN (k2 "kuvittelu") ; --UNCHK
lin via_Prep = postPrep genitive "kautta" ;
lin somewhat_Adv = mkAdv "jossain määrin" ;
lin inside_Adv = mkWAdv (k99 "sisimmältään") ;
lin trend_N = mkN "trendi" ;
lin revolution_N = mkWN (compoundN "vallan" (k39 "kumous")) ; --UNCHK
lin terrible_A = mkWA (k38 "hirmuinen") ; --UNCHK
lin knee_N = L.knee_N ;
lin dress_N = mkWN (k1A "puku") ; --UNCHK
lin unfortunately_Adv = variants{} ; -- 
lin steal_V2 = mkV2 "varastaa" ; ---ARB mkWV2 (k53A "ottaa") "varaslähtö" ;
lin steal_V = mkWV (k53A "ottaa") "varaslähtö" ; --UNCHK
lin criminal_A = mkA (lin AK {s = d38 "rikollinen"}) ;
lin signal_N = mkN "signaali" ;
lin notion_N = mkN "käsite" ; --WN (k50 "lyhyttavara") ;
lin comparison_N = mkWN (k2 "vertailu") ;
lin academic_A = mkA (lin AK {s = d38 "akateeminen"}) ;
lin outcome_N = mkN "tulos" ;
lin lawyer_N = mkN "asianajaja" ;
lin strongly_Adv = variants{} ; -- 
lin surround_V2 = mkV2 "ympäröidä" ;
lin explore_VS = mkWVS (k61 "tutkia") ; --UNCHK
lin explore_V2 = mkWV2 (k61 "tutkia") ; --UNCHK
lin achievement_N = mkWN (k1A "teko") ; --UNCHK
lin odd_A = mkWA (k34A "pariton") ; --UNCHK
lin expectation_N = mkWN (k10 "näkymä") ;
lin corporate_A = mkA "yhtiönlaajuinen" ;
lin prisoner_N = mkWN (k5A "vanki") ; --UNCHK
lin question_V2 = mkV2 (mkV (mkV "asettaa") "kyseenalaiseksi") ;
lin rapidly_Adv = variants{} ; -- 
lin deep_Adv = mkWAdv (k99 "syvälle") ; --UNCHK
lin southern_A = mkWA (k38 "eteläinen") ;
lin amongst_Prep = postPrep genitive "joukossa" ;
lin withdraw_V2 = mkV2 (mkV (mkV "vetää") "pois") ;
lin withdraw_V = mkV "luopua" ;
lin afterwards_Adv = mkWAdv (k99 "sittemmin") ; --UNCHK
lin paint_V2 = mkV2 "maalata" ;
lin paint_V = mkV "maalata" ;
lin judge_VS = mkWVS (k67 "arvostella") ; --UNCHK
lin judge_V2 = mkWV2 (k67 "arvostella") ; --UNCHK
lin judge_V = mkWV (k67 "arvostella") ; --UNCHK
lin citizenMasc_N = variants{} ; -- 
lin permanent_A = mkA "pysyvä" ;
lin weak_A = mkWA (k1A "heikko") ; --f133
lin separate_V2 = mkV2 "erottaa" ; --mkWV2 (k52A "erkaantua") ;
lin separate_V = mkWV (k52A "erkaantua") ;
lin plastic_N = L.plastic_N ;
lin connect_V2 = mkWV2 (k63 "saada") "yhteys" ; --UNCHK
lin connect_V = mkWV (k63 "saada") "yhteys" ; --UNCHK
lin fundamental_A = mkA "perustavanlaatuinen" ; --WA "kardinaali-" ;
lin plane_N = mkWN (compoundN "lento" (k48 "kone")) ; --f63
lin height_N = mkWN (k40 "pituus") ;
lin opening_N = mkWN (k39 "avaus") ; --f59
lin lesson_N = mkWN (k10 "tehtävä") ; --UNCHK
lin similarly_Adv = variants{} ; -- 
lin shock_N = mkWN (compoundN "sähkö" (k1 "isku")) ; --UNCHK
lin rail_N = mkWN (compoundN "ranta" (k9 "kana")) ; --UNCHK
lin tenant_N = mkWN (k38 "vuokralainen") ;
lin owe_V2 = mkV2 (mkV olla_V "velkaa") allative ;
lin owe_V = mkWV (k67 "olla") "auki" ; --UNCHK
lin originally_Adv = variants{} ; -- 
lin middle_A = variants{} ; -- 
lin somehow_Adv = mkWAdv (k99 "lailla") "jollain" ; --UNCHK
lin minor_A = mkWA (k26 "pieni") ; --f56
lin negative_A = mkWA (k38 "kielteinen") ; --f90
lin knock_V2 = mkWV2 (k61A "moittia") ; --UNCHK
lin knock_V = mkV "koputtaa" ; ---ARB mkWV (k61A "moittia") ;
lin root_N = L.root_N ;
lin pursue_V2 = mkV2 (mkV "tavoitella") partitive ;
lin pursue_V = mkWV (k67A "tavoitella") ; --UNCHK
lin inner_A = mkWA (k16A "sisempi") ; --UNCHK
lin crucial_A = mkA "ratkaiseva" ;
lin occupy_V2 = mkV2 "vallata" ;
lin occupy_V = mkV "vallata" ;
lin that_AdA = variants{} ; -- 
lin independence_N = mkWN (k40 "itsenäisyys") "Yhdysvaltain" ; --UNCHK
lin column_N = mkN "kolumni" ;
lin proceeding_N = mkWN (k5 "prosessi") ; --f59
lin female_N = mkN "nainen" ; --mkWN (k41 "naaras") ; --figured it's worse to call nainen a naaras than vice versa.
lin beauty_N = mkWN (k40 "kauneus") ; --UNCHK
lin perfectly_Adv = variants{} ; -- 
lin struggle_N = mkWN (k2 "ponnistelu") ; --UNCHK
lin gap_N = mkWN (k5 "väli") ;
lin house_V2 = mkV2 "majoittaa" ; --mkV2 (mkV (mkV "antaa") "yösija") allative ;
lin database_N = mkWN (compoundN "tieto" (k9A "kanta")) ; --UNCHK
lin stretch_V2 = mkV2 "venyttää" ;
lin stretch_V = mkWV (k67A "venytellä") ; --UNCHK
lin stress_N = mkWN (k5A "aksentti") ; --UNCHK
lin passenger_N = mkWN (k10 "matkustaja") ;
lin boundary_N = mkWN (kH1 "raja") ; --UNCHK
lin easy_Adv = mkWAdv (k99 "helposti") ;
lin view_V2 = mkWV2 (k62 "arvioida") ; --f78
lin manufacturer_N = mkWN (k10 "valmistaja") ; --f129
lin sharp_A = L.sharp_A ;
lin formation_N = mkWN (compoundN "koko" (k38 "aminen")) ; --UNCHK
lin queen_N = L.queen_N ;
lin waste_N = mkWN (k10A "hukka") ;
lin virtually_Adv = variants{} ; -- 
lin expand_V2 = mkV2 "laajentaa" partitive ;
lin expand_V = mkWV (k52A "laajentua") ;
lin contemporary_A = mkWA (k38 "nykyinen") ; --UNCHK
lin politician_N = mkWN (k1A "poliitikko") ;
lin back_V = mkWV (k52A "perääntyä") ;
lin territory_N = mkWN (k48 "alue") ; --UNCHK
lin championship_N = mkN "mestaruus" ; --mkWN (k39 "kannatus") ;
lin exception_N = mkN "poikkeus" ;
lin thick_A = L.thick_A ;
lin inquiry_N = mkN "kysely" ;
lin topic_N = mkN "aihe" ;
lin resident_N = mkN "asukas" ;
lin transaction_N = mkN "transaktio" ;
lin parish_N = mkWN (compoundN "seura" (k10A "kunta")) ; --UNCHK
lin supporter_N = mkN "kannattaja" ;
lin massive_A = mkA "massiivinen" ;
lin light_V2 = mkWV2 (k66 "valaista") ; --UNCHK
lin light_V = mkWV (k66 "valaista") ; --UNCHK
lin unique_A = mkA "ainutlaatuinen" ;
lin challenge_V2 = mkV2 "haastaa" ; --WV2 (k61A "moittia") ;
lin challenge_V = mkV (mkV "joutua") "kyseenalaiseksi" ; --mkWV (k61A "moittia") ;
lin inflation_N = mkN "inflaatio" ;
lin assistance_N = mkWN (k7A "tuki") ; --f56
lin list_V2V = mkWV2V (k67A "luetella") ; --UNCHK
lin list_V2 = mkWV2 (k67A "luetella") ;
lin list_V = mkWV (k67A "luetella") ; --UNCHK
lin identity_N = mkWN (k40 "yksilöllisyys") ; --UNCHK
lin suit_V2 = mkV2 "sopia" allative ; --mkWV2 (k58A "pukea") ;
lin suit_V = mkWV (k58A "pukea") ; --UNCHK
lin parliamentary_A = mkWA (k38 "parlamentaarinen") ; --UNCHK
lin unknown_A = mkWA (k34A "tuntematon") ;
lin preparation_N = mkWN (compoundN "ruuan" (k39 "valmistus")) ; --UNCHK
lin elect_V3 = mkV3 (mkV "valita") accusative (mkPrep translative) ;
lin elect_V2V = mkWV2V (k53A "päättää") ; --UNCHK
lin elect_V2 = mkV2 (lin VK {s = c69 "valita"}) ;
lin elect_V = mkV "valita" ;
lin badly_Adv = variants{} ; -- 
lin moreover_Adv = mkAdv "lisäksi" ;
lin tie_V2 = L.tie_V2 ;
lin tie_V = mkWV (k61 "solmia") ; --UNCHK
lin cancer_N = mkN "syöpä" ; --f112
lin champion_N = mkWN (k5A "ekspertti") ; --UNCHK
lin exclude_V2 = mkV2 (mkV (mkV "jättää") "ulkopuolelle") ;
lin review_V2 = mkV2 "arvioida" ;
lin review_V = mkWV (k53 "tarkistaa") ; --UNCHK
lin licence_N = mkWN (k5 "lisenssi") ; --UNCHK
lin breakfast_N = mkWN (k38 "aamiainen") ; --UNCHK
lin minority_N = mkWN (k1 "vähemmistö") ; --f88
lin appreciate_V2 = mkV2 "arvostaa" partitive ;
lin appreciate_V = mkV "arvostaa" ;
lin fan_N = variants{} ; -- 
lin fan_3_N = mkN "ihailija" ; ---ARB viuhka
lin fan_2_N = mkN "ihailija" ; ---ARB viuhka
lin fan_1_N = mkN "ihailija" ; ---ARB viuhka
lin chief_N = mkN "päällikkö" ;
lin accommodation_N = mkWN (k3 "akkommodaatio") ; --UNCHK
lin subsequent_A = mkWA (k10 "seuraava") ;
lin democracy_N = mkN (lin NK {s = d12 "demokratia"}) ;
lin brown_A = L.brown_A ;
lin taste_N = mkWN (compoundN "mais" (k38 "taminen")) ; --UNCHK
lin crown_N = mkWN (k1A "kupu") ; --UNCHK
lin permit_V2V = mkV2Vf (mkV "sallia") (casePrep genitive) infFirst ;
lin permit_V2 = mkV2 "sallia" ; ---ARB mkWV2 (k53 "päästää") ;
lin permit_V = mkWV (k53 "päästää") ; --UNCHK
lin buyerMasc_N = variants{} ; -- 
lin gift_N = mkWN "antaminen" ; --UNCHK
lin resolution_N = mkWN (k2 "ratkaisu") ;
lin angry_A = mkWA (k38 "vihainen") ;
lin metre_N = mkWN (compoundN "tasa" (k5 "rytmi")) ; --UNCHK
lin wheel_N = mkWN (k10 "pyörä") ;
lin clause_N = mkWN (k48 "lause") ;
lin break_N = mkN "tauko" ;
lin tank_N = mkN "tankki" ; ---ARB mkN "panssarivaunu" ;
lin benefit_V2 = mkV2 "hyödyttää" partitive ;
lin benefit_V = mkV "hyötyä" ;
lin engage_V2 = mkWV2 (k58 "kytkeä") ; --UNCHK
lin engage_V = mkWV (k58 "kytkeä") ;
lin alive_A = mkWA (k99 "hengissä") ; --UNCHK
lin complaint_N = mkWN (k48A "kanne") ; --f61
lin inch_N = mkWN (kH1 "tuuma") ; --UNCHK
lin firm_A = mkWA (k10 "luja") ; --f73
lin abandon_V2 = mkWV2 (k73A "hylätä") ; --f62
lin blame_V2 = mkV2 "syyttää" partitive ;
lin blame_V = mkV "syyttää" ;
lin clean_V2 = mkWV2 (k53 "puhdistaa") ; --UNCHK
lin clean_V = mkWV (k53 "puhdistaa") ; --UNCHK
lin quote_V2 = mkWV2 (k73 "lainata") ; --f70
lin quote_V = mkWV (k73 "lainata") ;
lin quantity_N = mkWN (k10 "summa") ; --UNCHK
lin rule_VS = mkVS (mkV "säätää") ;
lin rule_V2 = mkWV2 (k69 "hillitä") ; --UNCHK
lin rule_V = mkWV (k69 "hallita") ; --f54
lin guilty_A = mkWA (k38 "syyllinen") ; --f67
lin prior_A = mkA (mkN "aiempi" "aiemman" "aiempia") ;
lin round_A = L.round_A ;
lin eastern_A = mkWA (k38 "itäinen") ;
lin coat_N = L.coat_N ;
lin involvement_N = mkWN (compoundN "osan" (k1A "otto")) ; --UNCHK
lin tension_N = mkWN (k39 "kiristys") ; --UNCHK
lin diet_N = mkN "ravinto" ; --mkWN (k5 "laihdutuskuuri") ;
lin enormous_A = mkA "suunnaton" ;
lin score_N = mkN "piste" (mkN "määrä") ; --WN (k5A "saanti") ;
lin rarely_Adv = variants{} ; -- 
lin prize_N = mkWN (k1A "palkinto") ; --UNCHK
lin remaining_A = variants{} ; -- 
lin significantly_Adv = variants{} ; -- 
lin glance_V2 = mkWV2 (k64 "lyödä") "kulmaan" ; --UNCHK
lin glance_V = mkWV (k64 "lyödä") "kulmaan" ; --UNCHK
lin dominate_V2 = mkV2 (mkV "dominoida") partitive ;
lin dominate_V = mkV vOlla "hallitseva" ; --mkWV (k53A "ylittää") ;
lin trust_VS = mkWVS (k53A "luottaa") ; --UNCHK
lin trust_V2 = mkV2 "luottaa" illative ;
lin naturally_Adv = variants{} ; -- 
lin interpret_V2 = mkWV2 (k73 "osata") ; --UNCHK
lin interpret_V = mkWV (k73 "osata") ; --UNCHK
lin land_V2 = mkWV2 (k56A "saattaa") ; --UNCHK
lin land_V = mkV "laskeutua" ;
lin frame_N = mkN "kehys" ; ---ARB --mkWN (k39 "kierros") ;
lin extension_N = mkN "laajennus" ; ---ARB mkWN "laajentaminen" ;
lin mix_V2 = mkWV2 (k53A "sekoittaa") ;
lin mix_V = mkWV (k53A "sekoittaa") ; --UNCHK
lin spokesman_N = mkWN (k10 "edustaja") ; --f420
lin friendly_A = mkWA (k38 "ystävällinen") ;
lin acknowledge_VS = mkWVS (k54A "myöntää") ;
lin acknowledge_V2 = mkWV2 (k54A "myöntää") ; --UNCHK
lin register_V2 = mkV2 "rekisteröidä" ;
lin register_V = mkV "kirjoittautua" ; ---ARB --mkWV (k67 "tulla") "ymmärretyksi" ;
lin regime_N = variants{} ; -- 
lin regime_2_N = variants{} ; -- 
lin regime_1_N = mkN "hallinto" ;
lin fault_N = mkN "virhe" ;
lin dispute_N = mkWN (k2 "väittely") ;
lin grass_N = L.grass_N ;
lin quietly_Adv = variants{} ; -- 
lin decline_N = mkN "rappio" ;
lin dismiss_V2 = mkV2 (mkV "hylätä" "hylkäsi") ;
lin delivery_N = mkWN (k39 "synnytys") ; --f140
lin complain_VS = mkVS "valittaa" ; --WVS (k53 "nostaa") "kanne" ;
lin complain_V = mkV "valittaa" ;
lin conservative_N = mkN "konservatiivinen" ;
lin shift_V2 = mkWV2 (k56A "vaihtaa") ; --UNCHK
lin shift_V = mkWV (k56A "vaihtaa") ; --UNCHK
lin port_N = mkWN (k5A "portti") ; --UNCHK
lin beach_N = mkWN (k9A "ranta") ; --UNCHK
lin string_N = mkWN (compoundN "kieli" (k33A "soitin")) ; --UNCHK
lin depth_N = mkWN (k40 "syvyys") ;
lin unusual_A = mkA "epätavallinen" ;
lin travel_N = mkN "matka" ;
lin pilot_N = mkN "lentäjä" ;
lin obligation_N = mkWN (k17 "vastuu") ; --f73
lin gene_N = mkWN (k5 "geeni") ; --f99
lin yellow_A = L.yellow_A ;
lin republic_N = mkWN (k2 "yhteisö") ; --UNCHK
lin shadow_N = mkWN (k1 "varjo") ; --UNCHK
lin dear_A = mkWA (k38 "läheinen") ; --UNCHK
lin analyse_V2 = mkWV2 (k62 "analysoida") ; --UNCHK
lin anywhere_Adv = mkWAdv (k99 "tahansa") "missä" ; --UNCHK
lin average_N = mkN "keskiarvo" ;
lin phrase_N = mkWN (k5 "fraasi") ; --UNCHK
lin long_term_A = mkA "pitkäaikainen" ;
lin crew_N = mkWN (k2 "miehistö") ; --UNCHK
lin lucky_A = mkWA (k41A "onnekas") ; --UNCHK
lin restore_V2 = mkWV2 (k53A "elävöittää") ; --f52
lin convince_V2V = mkWV2V (k53A "vakuuttaa") ; --UNCHK
lin convince_V2 = mkWV2 (k53A "vakuuttaa") ;
lin coast_N = mkWN (compoundN "liu" (k38 "kuminen")) ; --UNCHK
lin engineer_N = mkWN (k5 "insinööri") ;
lin heavily_Adv = variants{} ; -- 
lin extensive_A = mkWA (compoundA "laaja" (k38 "peräinen")) ; --UNCHK
lin glad_A = mkWA (k99 "mielissään") ; --UNCHK
lin charity_N = mkWN (k40 "hyväntekeväisyys") ;
lin oppose_V2 = mkWV2 (k53 "vastustaa") partitive ;
lin oppose_V = mkWV (k53 "vastustaa") ;
lin defend_V2 = mkV2 "puolustaa" partitive ;
lin alter_V2 = mkWV2 (k62 "steriloida") ; --UNCHK
lin alter_V = mkWV (k62 "steriloida") ; --UNCHK
lin warning_N = mkN "varoitus" ;
lin arrest_V2 = mkWV2 (k67A "pidätellä") ; --UNCHK
lin framework_N = mkN "kehys" ;
lin approval_N = mkN "hyväksyntä" ;
lin bother_VV = variants{}; -- mkWV2V (k53A "ottaa") "päähän" ; --UNCHK
lin bother_V2V = mkWV2V (k53A "ottaa") "päähän" ; --UNCHK
lin bother_V2 = mkV2 "vaivata" partitive ; --mkWV2 (k53A "ottaa") "päähän" ;
lin bother_V = mkV "vaivautua" ; --mkWV (k53A "ottaa") "päähän" ;
lin novel_N = mkWN (k6 "romaani") ;
lin accuse_V2 = mkWV2 (k53A "syyttää") "rikoksesta" ; --f79
lin surprised_A = variants{} ; -- 
lin currency_N = mkN "valuutta" ;
lin restrict_V2 = mkV2 "rajoittaa" ;
lin restrict_V = mkWV (k54A "tarkentaa") ; --UNCHK
lin possess_V2 = mkWV2 (k67 "olla") "oma" ; --UNCHK
lin moral_A = mkWA (k38 "moraalinen") ;
lin protein_N = mkWN (k5 "proteiini") ; --UNCHK
lin distinguish_V2 = mkV2 "erottaa" partitive ; --mkWV2 (k73 "huomata") "ero" ;
lin distinguish_V = mkWV (k73 "huomata") "ero" ; --UNCHK
lin gently_Adv = mkWAdv (k99 "vienosti") ; --UNCHK
lin reckon_VS = mkWVS (k73 "arvata") ;
lin incorporate_V2 = mkWV2 (k53A "sisällyttää") ;
lin proceed_V = mkWV (k52 "edistyä") ;
lin assist_V2 = mkWV2 (k53 "avustaa") ; --UNCHK
lin assist_V = mkWV (k53 "avustaa") ; --UNCHK
lin sure_Adv = mkWAdv (k99 "tosiaan") "totta" ; --UNCHK
lin stress_VS = mkWVS (k53A "painottaa") ; --UNCHK
lin stress_V2 = mkWV2 (k53A "painottaa") ; --UNCHK
lin justify_VV = mkWVV (k73 "tasata") ; --UNCHK
lin justify_V2 = mkV2 "oikeuttaa" ;
lin behalf_N = mkWN (k99 "puolesta") ; --UNCHK
lin councillor_N = mkWN (k32 "jäsen") "neuvoston" ; --UNCHK
lin setting_N = mkN "asetelma" ;
lin command_N = mkWN (k9A "hallinta") ; --UNCHK
lin command_2_N = variants{} ; -- 
lin command_1_N = variants{} ; -- 
lin maintenance_N = mkN "ylläpito" ;
lin stair_N = mkWN (k10 "askelma") ; --UNCHK
lin poem_N = mkWN (k1 "runo") ; --UNCHK
lin chest_N = mkWN (k1 "kirstu") ; --UNCHK
lin like_Adv = variants{}; -- postPrep genitive "tavalla" ; ---
lin secret_N = mkWN (k12 "asia") "tuntematon" ; --UNCHK
lin restriction_N = mkN "rajoitus" ;
lin efficient_A = mkWA (k41A "tehokas") ;
lin suspect_VS = mkWVS (k67 "epäillä") ;
lin suspect_V2 = mkV2 "epäillä" partitive ;
lin hat_N = L.hat_N ;
lin tough_A = mkA "tiukka" ;
lin firmly_Adv = variants{} ; -- 
lin willing_A = mkA "halukas" ;
lin healthy_A = mkA (lin AK {s = d48 "terve"}) ;
lin focus_N = mkWN (k39 "fokus") ;
lin construct_V2 = mkWV2 (k54A "jäljentää") ; --UNCHK
lin occasionally_Adv = variants{} ; -- 
lin mode_N = mkN "tapa" ; ---ARB --mkWN (k5 "tyyli") ;
lin saving_N = mkN "säästö" ; --f79
lin comfortable_A = mkA "mukava" ;
lin camp_N = mkWN (k5 "leiri") ; --UNCHK
lin trade_V2 = mkWV2 (mkV "myydä") ; --f95
lin trade_V = mkV (lin VK {s = c73A "kaupata"}) ;
lin export_N = mkWN (k5A "vienti") ;
lin wake_V2 = mkWV2 (k52A "havahtua") ; --UNCHK
lin wake_V = mkV "herättää" ;
lin partnership_N = mkN (lin NK {s = d40 "kumppanuus"}) ;
lin daily_A = mkA "päivittäinen" ;
lin abroad_Adv = mkWAdv "ulkomailla" ; --f56
lin profession_N = mkWN (k19 "työ") ; --UNCHK
lin load_N = mkWN (k39 "lähetys") ; --UNCHK
lin countryside_N = mkWN (k18 "maa") ; --UNCHK
lin boot_N = L.boot_N ;
lin mostly_Adv = mkWAdv (k99 "lähinnä") ; --f85
lin sudden_A = mkWA (k38 "yhtäkkinen") ;
lin implement_V2 = mkWV2 (k65 "käydä") "läpi" ; --UNCHK
lin reputation_N = mkWN (k48 "maine") ;
lin print_V2 = mkWV2 (k66 "julkaista") ; --UNCHK
lin print_V = mkWV (k66 "julkaista") ;
lin calculate_VS = mkWVS (k58 "laskea") ;
lin calculate_V2 = mkWV2 (k58 "laskea") ;
lin calculate_V = mkWV (k58 "laskea") ;
lin keen_A = mkWA (k9A "tarkka") ;
lin guess_VS = mkWVS (k73 "arvata") ; --UNCHK
lin guess_V2 = mkWV2 (k73 "arvata") ; --UNCHK
lin guess_V = mkWV (k73 "arvata") ; --UNCHK
lin recommendation_N = mkN "suositus" ;
lin autumn_N = mkWN (k1 "syksy") ; --UNCHK
lin conventional_A = mkWA (k38 "sovinnainen") ; --f60
lin cope_V = mkWV (k53 "kestää") ; --UNCHK
lin constitute_V2 = mkV2 "muodostaa" ;
lin poll_N = mkN "äänestys" ;
lin voluntary_A = mkA "vapaaehtoinen" ;
lin valuable_A = mkWA (k41A "arvokas") ;
lin recovery_N = mkN "toipuminen" ;
lin cast_V2 = mkV2 "heittää" ;
lin cast_V = mkV (mkV "saada") "rooli" ; ---ARB --mkV (mkV "antaa") "ääni") ; --mkWV (k53A "heittää") "laattaa" ;
lin premise_N = mkN "tila" ;
lin resolve_V2 = mkV2 "ratkaista" ;
lin resolve_V = mkV "selvitä" ; --mkWV (k53A "liuottaa") ;
lin regularly_Adv = variants{} ; -- 
lin solve_V2 = mkV2 "ratkaista" ;
lin plaintiff_N = mkWN (k10 "kantaja") ;
lin critic_N = mkN (lin NK {s = d04A "kriitikko"}) ;
lin agriculture_N = mkWN (compoundN "maa" (k40 "talous")) ; --UNCHK
lin ice_N = L.ice_N ;
lin constitution_N = mkN "perustus" (mkN "laki") ; ---ARB --mkWN (compoundN "koko" (k38 "aminen")) ;
lin communist_N = mkWN (compoundN "Bordeaux-" (k39 "seos")) ; --UNCHK
lin layer_N = mkWN (k39 "kerros") ; --UNCHK
lin recession_N = mkN "lama" ;
lin slight_A = mkWA (k38 "vähäinen") ;
lin dramatic_A = mkWA (k38 "dramaattinen") ;
lin golden_A = mkWA (k41A "onnekas") ; --UNCHK
lin temporary_A = mkWA (k38 "tilapäinen") ; --f111
lin suit_N = mkWN (k48A "kanne") ; --f239 ---ARB mkN "puku"
lin shortly_Adv = variants{} ; -- 
lin initially_Adv = variants{} ; -- 
lin arrival_N = mkN "saapuminen" ;
lin protest_N = mkN "protesti" ;
lin resistance_N = mkWN (k39 "vastustus") ;
lin silent_A = mkA "hiljainen" ; --mkWA (k10A "mykkä") ;
lin presentation_N = mkWN (k10 "esitelmä") ; --UNCHK
lin soul_N = mkWN (k1 "sielu") ;
lin self_N = mkWN (k101 "minä") ; --UNCHK
lin judgment_N = mkWN (k3 "arvio") ; --UNCHK
lin feed_V2 = mkWV2 (k53A "syöttää") ; --UNCHK
lin feed_V = mkWV (k53A "syöttää") ; --UNCHK
lin muscle_N = mkWN (k10 "voima") ; ---ARB --mkN "lihas" "lihaksia" ;
lin shareholder_N = mkN "osakkeenomistaja" ;
lin opposite_A = mkWA (k38 "parillinen") ; --UNCHK
lin pollution_N = mkN "saaste" ;
lin wealth_N = mkN (lin NK {s = d40 "varallisuus"}) ;
lin video_taped_A = variants{} ; -- 
lin kingdom_N = mkWN (k10A "kunta") ; --UNCHK
lin bread_N = L.bread_N ;
lin perspective_N = mkWN (k5 "perspektiivi") "lineaarinen" ; --UNCHK
lin camera_N = L.camera_N ;
lin prince_N = mkWN (k5 "prinssi") ; --UNCHK
lin illness_N = mkWN (k5A "tauti") ; --UNCHK
lin cake_N = mkWN (k14A "patukka") ; --UNCHK
lin meat_N = L.meat_N ;
lin submit_V2 = mkV2 (mkV (mkV "lähettää") "arvioitavaksi") ;
lin submit_V = mkWV (k53A "sietää") ; --UNCHK
lin ideal_A = mkWA (k38 "ihanteellinen") ;
lin relax_V2 = mkWV2 (k71 "tehdä") "rentoutuneeksi" ; --UNCHK
lin relax_V = mkV "rentoutua" ;
lin penalty_N = mkWN (k39 "rangaistus") ;
lin purchase_V2 = mkWV2 (k53 "ostaa") ; --f177
lin tired_A = variants{} ; -- 
lin beer_N = L.beer_N ;
lin specify_VS = mkVS "täsmentää" ; --mkWVS (k73 "varata") ;
lin specify_V2 = mkV2 "spesifioida" ; --WV2 (k73 "varata") ;
lin specify_V = mkWV (k73 "varata") ; --UNCHK
lin short_Adv = mkWAdv (k99 "äkillisesti") ; --UNCHK
lin monitor_V2 = mkWV2 (k61A "vahtia") ;
lin monitor_V = mkWV (k61A "vahtia") ; --UNCHK
lin electricity_N = mkN "sähkö" ;
lin specifically_Adv = variants{} ; -- 
lin bond_N = mkN "sidos" ;
lin statutory_A = mkWA (compoundA "laki" (k38 "sääteinen")) ;
lin laboratory_N = mkWN (k3 "laboratorio") ;
lin federal_A = mkA "liittovaltiollinen" ;
lin captain_N = mkWN (compoundN "hovi" (k6 "mestari")) ; --UNCHK
lin deeply_Adv = variants{} ; -- 
lin pour_V2 = mkWV2 (k67 "parveilla") ; --UNCHK
lin pour_V = mkWV (k67 "parveilla") ; --UNCHK
lin boss_N = L.boss_N ;
lin creature_N = mkWN (k3 "olio") ; --UNCHK
lin urge_VS = mkWVS (k53 "ahdistaa") ; --UNCHK
lin urge_V2V = mkWV2V (k53 "ahdistaa") ; --UNCHK
lin urge_V2 = mkWV2 (k53 "ahdistaa") ; --f88
lin locate_V2 = mkV2 "sijoittaa" ; --WV2 (k52A "sijoittua") ;
lin locate_V = mkWV (k52A "sijoittua") ;
lin being_N = mkWN (k1A "olento") ; --UNCHK
lin struggle_VV = mkVV "ponnistella" infIllat ;
lin struggle_V = mkWV (k67 "taistella") ; --UNCHK
lin lifespan_N = variants{} ; -- 
lin flat_A = mkA "litteä" ;
lin valley_N = mkWN (k1 "laakso") ; --UNCHK
lin like_A = mkWA (k38 "samanlainen") ;
lin guard_N = mkN "vartija" ; --WN "guard" ;
lin emergency_N = mkN "hätä" (mkN "jarru") ; --f96
lin dark_N = mkWN (k40 "tietämättömyys") ; --UNCHK
lin bomb_N = mkWN (kH1 "pommi") ;
lin dollar_N = mkN (lin NK {s = d06 "dollari"}) ;
lin efficiency_N = mkWN (k40 "tehokkuus") ; --UNCHK
lin mood_N = mkWN (k26 "tuuli") ; --UNCHK
lin convert_V2 = mkV2 "muuntaa" ; --f56
lin convert_V = mkWV (k52A "muuntua") ; --UNCHK
lin possession_N = mkWN (k40 "omaisuus") ; --UNCHK
lin marketing_N = mkN (lin NK {s = d05A "markkinointi"}) ;
lin please_VV = mkWVV (k53A "riemastuttaa") ; --UNCHK
lin please_V2V = mkWV2V (k53A "riemastuttaa") ; --UNCHK
lin please_V2 = mkV2 "miellyttää" partitive ;
lin please_V = mkWV (k53A "riemastuttaa") ; --UNCHK
lin habit_N = mkN (lin NK {s = d09A "tapa"}) ;
lin subsequently_Adv = variants{} ; -- 
lin round_N = mkN "kierros" ;
lin purchase_N = mkWN (k1 "osto") ; --f272
lin sort_V2 = mkWV2 (k53A "ryhmittää") ; --UNCHK
lin sort_V = mkV "ryhmittyä" ; --mkWV (k53A "ryhmittää") ;
lin outside_A = mkA (mkN "ulko" (mkN "puolinen")) ; --f53
lin gradually_Adv = variants{} ; -- 
lin expansion_N = mkN "laajeneminen" ;
lin competitive_A = mkWA "kilpailu-" ; --f77
lin cooperation_N = mkWN (compoundN "yhteis" (k19 "työ")) ;
lin acceptable_A = mkWA (k10 "tyydyttävä") ; --UNCHK
lin angle_N = mkWN (k5 "perspektiivi") ; --UNCHK
lin cook_V2 = mkWV2 (k52 "kypsyä") ; --UNCHK
lin cook_V = mkWV (k52 "kypsyä") ; --UNCHK
lin net_A = mkA "puhdas" ;
lin sensitive_A = mkWA (k10A "herkkä") ;
lin ratio_N = mkWN (k48A "suhde") ; --f53
lin kiss_V2 = mkWV2 (k73 "pussata") ; --UNCHK
lin amount_V = mkWV (k66 "nousta") ;
lin sleep_N = mkWN (k9 "rauha") ; --UNCHK
lin finance_V2 = mkWV2 (k53A "rahoittaa") ; --f132
lin essentially_Adv = variants{} ; -- 
lin fund_V2 = mkWV2 (k53A "rahoittaa") ; --f64
lin preserve_V2 = mkV2 "säilyttää" ; ---ARB mkWV2 (k52 "säilöä") ;
lin wedding_N = mkN "vihkiminen" ;
lin personality_N = mkWN (k40 "persoonallisuus") ; --UNCHK
lin bishop_N = mkWN (k5A "lähetti") ; --UNCHK
lin dependent_A = mkWA (k10 "oleva") "riippuvuussuhteessa" ; --UNCHK
lin landscape_N = mkWN (k39 "maisemamaalaus") ; --UNCHK
lin pure_A = mkWA (k38 "intensiivinen") ; --UNCHK
lin mirror_N = mkWN (k5 "peili") ; --UNCHK
lin lock_V2 = mkV2 "lukita" ; --mkWV2 (k73A "pilkata") "Jumalaa" ;
lin lock_V = mkWV (k73A "pilkata") "Jumalaa" ; --UNCHK
lin symptom_N = mkWN (k5 "symptomi") ; --UNCHK
lin promotion_N = mkWN (k39 "ylennys") ;
lin global_A = mkWA (k38 "globaalinen") ; --f67
lin aside_Adv = mkWAdv (k99 "syrjään") ; --UNCHK
lin tendency_N = mkWN (k39 "viettymys") ; --UNCHK
lin conservation_N = mkWN (compoundN "ympäristön" (k2 "suojelu")) ; --UNCHK
lin reply_N = mkWN (k48 "vastine") ; --UNCHK
lin estimate_N = mkWN (k3 "arvio") ; --f218
lin qualification_N = mkWN (compoundN "muu" (k38 "ttaminen")) ; --UNCHK
lin pack_V2 = mkV2 "pakata" partitive ; --mkWV2 (k61 "kääriä") ;
lin pack_V = mkV "täyttyä" ; --mkWV (k61 "kääriä") ;
lin governor_N = mkN "kuvernööri" ;
lin expected_A = variants{} ; -- 
lin invest_V2 = mkV2 "investoida" ; --WV2 (k73 "satsata") ;
lin invest_V = mkV (lin VK {s = c53A "sijoittaa"}) ;
lin cycle_N = mkN "sykli" ;
lin alright_A = mkWA (k99 "oikein") ; --UNCHK
lin philosophy_N = mkWN (k5A "oppi") ; --UNCHK
lin gallery_N = mkWN (k10 "perä") ; --UNCHK
lin sad_A = mkA (lin AK {s = d38 "surullinen"}) ;
lin intervention_N = mkWN (k2 "käsittely") ; --UNCHK
lin emotional_A = mkA "emotionaalinen" ;
lin advertising_N = mkWN (k9A "mainonta") ; --f170
lin regard_N = mkN "arvostus" ; --mkWN (k48 "katse") ;
lin dance_V2 = mkWV2 (k73 "jorata") ; --UNCHK
lin dance_V = mkWV (k73 "jorata") ; --UNCHK
lin cigarette_N = mkN "savuke" ;
lin predict_VS = mkVS (mkV "ennustaa") ;
lin predict_V2 = mkV2 "ennustaa" ;
lin adequate_A = mkA "tarkoituksenmukainen" ;
lin variable_N = mkWN (k10 "muuttuja") ;
lin net_N = mkWN (k1A "verkko") ; --f213
lin retire_V2 = mkV2 (mkV (mkV "vetää") "pois") ;
lin retire_V = mkV "vetäytyä" ;
lin sugar_N = mkN "sokeri" ; --f52
lin pale_A = mkWA (k15 "kelmeä") ; --UNCHK
lin frequency_N = mkN "frekvenssi" ; --WN (k5 "frekvenssi") "absoluuttinen" ;
lin guy_N = mkN "kaveri" ; --f62
lin feature_V2 = mkV2 "esittää" ;
lin furniture_N = mkWN (compoundN "huone" (k1 "kalu")) ;
lin administrative_A = mkWA (k38 "hallinnollinen") ;
lin wooden_A = mkA "puinen" ;
lin input_N = mkN "syöte" ;
lin phenomenon_N = mkWN (k3 "ilmiö") ; --UNCHK
lin surprising_A = mkWA (k10 "yllättävä") ; --f69
lin jacket_N = mkN "pusakka" ;
lin actor_N = mkWN (k12 "näyttelijä") ;
lin actor_2_N = mkWN (k12 "näyttelijä") ;
lin actor_1_N = mkWN (k12 "näyttelijä") ;
lin kick_V2 = mkV2 (mkV "potkaista") partitive ;
lin kick_V = mkV "potkia" ;
lin producer_N = mkN (lin NK {s = d10 "tuottaja"}) ;
lin hearing_N = mkN "kuulustelu" ;
lin chip_N = mkN "hippu" ;
lin equation_N = mkN "yhtälö" ;
lin certificate_N = mkN (lin NK {s = d39 "todistus"}) ;
lin hello_Interj = mkInterj "terve" | mkInterj "hei" | mkInterj "moro" | mkInterj "moi" ;
lin remarkable_A = mkA "huomattava" ;
lin alliance_N = mkN "allianssi" | mkN "liitto" ;
lin smoke_V2 = mkV2 "savustaa" | mkV2 "polttaa" ; --- split -- | smoke fish -- | smoke a cigarette
lin smoke_V = mkWV (k68 "tupakoida") ;
lin awareness_N = mkN "tietoisuus" ;
lin throat_N = mkN "kurkku" ;
lin discovery_N = mkN "löytö" ;
lin festival_N = mkN "festivaali" ;
lin dance_N = mkWN (k5 "tanssi") ; --UNCHK
lin promise_N = mkN "lupaus" ;
lin rose_N = mkWN (k10 "roosa") ; --UNCHK
lin principal_A = mkWA (compoundA "pää" (k38 "asiallinen")) ;
lin brilliant_A = mkWA (k10 "loistava") ;
lin proposed_A = variants{} ; -- 
lin coach_N = mkWN (k5 "bussi") ; --UNCHK
lin coach_3_N = variants{} ; -- 
lin coach_2_N = variants{} ; -- 
lin coach_1_N = variants{} ; -- 
lin absolute_A = mkA "ehdoton" | mkA "absoluuttinen" ;
lin drama_N = mkWN (k40 "dramaattisuus") ; --UNCHK
lin recording_N = mkWN (k39 "tallennus") ; --UNCHK
lin precisely_Adv = variants{} ; -- 
lin bath_N = mkWN (k1A "kylpy") ; --UNCHK
lin celebrate_V2 = mkV2 "juhlia" partitive ; --WV2 (k53 "ylistää") ;
lin substance_N = mkWN (k12 "materia") ; --UNCHK
lin swing_V2 = mkWV2 (k67A "heilahdella") ; --UNCHK
lin swing_V = mkWV (k67A "heilahdella") ; --UNCHK
lin for_Adv = variants{}; -- S.for_Prep ;
lin rapid_A = mkWA (k15 "ripeä") ; --f84
lin rough_A = mkWA (k15 "karkea") ; --f95
lin investor_N = mkN (lin NK {s = d10 "sijoittaja"}) ;
lin fire_V2 = mkWV2 (k53A "polttaa") ; --UNCHK
lin fire_V = mkWV (k53A "polttaa") ; --UNCHK
lin rank_N = mkN "arvoaste" ;
lin compete_V = mkV (lin VK {s = c67 "kilpailla"}) ;
lin sweet_A = mkWA (k15 "makea") ; --UNCHK
lin decline_VV = mkVV (mkV "pidättäytyä") infElat ;
lin decline_V2 = mkV2 (mkV "hylätä" "hylkäsi") ;
lin decline_V = mkV (lin VK {s = c58 "laskea"}) ;
lin rent_N = mkN "vuokra" ; ---ARB mkWN (k2 "halkaisu") ;
lin dealer_N = mkWN (k41 "kauppias") ; --f226
lin bend_V2 = mkWV2 (k54A "vääntää") "mutkalle" ; --UNCHK
lin bend_V = mkWV (k54A "vääntää") "mutkalle" ; --UNCHK
lin solid_A = mkWA (k15 "kiinteä") ;
lin cloud_N = L.cloud_N ;
lin across_Adv = mkWAdv (k99 "ristiin") ; --UNCHK
lin level_A = mkWA (k99 "tasan") ; --UNCHK
lin enquiry_N = mkWN (k39 "tutkimus") ; --UNCHK
lin fight_N = mkN "taistelu" ;
lin abuse_N = mkN "väärinkäyttö" ; --C "hyväksikäyttö" ;
lin golf_N = mkWN (k5 "golf") ; --UNCHK
lin guitar_N = mkWN (k13 "kitara") ; --UNCHK
lin electronic_A = mkWA (k38 "elektroninen") ; --f82
lin cottage_N = mkWN (k9 "maja") ; --UNCHK
lin scope_N = mkN "laajuus" ; --mkWN (k5A "oskilloskooppi") ;
lin pause_VS = mkWVS (k53A "pitää") "tauko" ; --UNCHK
lin pause_V2V = mkWV2V (k53A "pitää") "tauko" ; --UNCHK
lin pause_V = mkWV (k53A "pitää") "tauko" ; --UNCHK
lin mixture_N = mkWN (k39 "seos") ; --UNCHK
lin emotion_N = mkWN (k48A "tunne") ; --UNCHK
lin comprehensive_A = mkWA "kattava" ;
lin shirt_N = L.shirt_N ;
lin allowance_N = mkN "osuus" ; --WN (k10A "lupa") ;
lin retirement_N = mkWN "vetäytyminen" ;
lin breach_N = mkWN (k39 "rikkomus") ; --UNCHK
lin infection_N = mkWN (k9A "tartunta") ;
lin resist_VV = mkWVV (k53 "vastustaa") ; ---???
lin resist_V2 = mkWV2 (k53 "vastustaa") ; --UNCHK
lin resist_V = mkWV (k53 "vastustaa") ; --UNCHK
lin qualify_V2 = mkWV2 (k53A "määrittää") ; --UNCHK
lin qualify_V = mkWV (k53A "määrittää") ; --UNCHK
lin paragraph_N = mkWN (k5 "paragrafi") ; --UNCHK
lin sick_A = mkWA (k41 "sairas") ; --UNCHK
lin near_A = L.near_A ;
lin researcherMasc_N = variants{} ; -- 
lin consent_N = mkWN (k39 "suostumus") ;
lin written_A = variants{} ; -- 
lin literary_A = mkWA (compoundA "kauno" (k38 "kirjallinen")) ;
lin ill_A = mkWA (k41 "sairas") ;
lin wet_A = L.wet_A ;
lin lake_N = L.lake_N ;
lin entrance_N = mkWN (compoundN "sisään" (k1 "tulo")) ; --UNCHK
lin peak_N = mkN "huippu" ;
lin successfully_Adv = variants{} ; -- 
lin sand_N = L.sand_N ;
lin breathe_V2 = mkWV2 (k66 "henkäistä") ; --UNCHK
lin breathe_V = L.breathe_V ;
lin cold_N = mkWN (k38 "vilustuminen") ;
lin cheek_N = mkWN (k40 "hävyttömyys") ; --UNCHK
lin platform_N = mkWN (k10A "kenkä") "korokepohjainen" ; --UNCHK
lin interaction_N = mkWN (k2 "keskustelu") ; --UNCHK
lin watch_N = mkWN (k5A "vahti") ; --UNCHK
lin borrow_VV = mkWVV (k53A "ottaa") "lainaksi" ; --UNCHK
lin borrow_V2 = mkV2 "lainata" | mkWV2 (k53A "ottaa") "lainaksi" ;
lin borrow_V = mkWV (k53A "ottaa") "lainaksi" ; --f59
lin birthday_N = mkWN (compoundN "syntymä" (k10 "päivä")) ;
lin knife_N = mkWN (k30 "veitsi") ; --UNCHK
lin extreme_A = mkA "äärimmäinen" ; --f66
lin core_N = mkN "ydin" ;
lin peasantMasc_N = variants{} ; -- 
lin armed_A = variants{} ; -- 
lin permission_N = mkWN (k10A "lupa") ;
lin supreme_A = mkWA (k36 "ylin") ; --UNCHK
lin overcome_V2 = mkV2 "voittaa" ;
lin overcome_V = mkWV (k52A "selviytyä") ; --UNCHK
lin greatly_Adv = variants{} ; -- 
lin visual_A = mkA "visuaalinen" ;
lin lad_N = mkWN (k1 "poju") ; --UNCHK
lin genuine_A = mkWA (k1A "aito") ; --UNCHK
lin personnel_N = mkWN (compoundN "henkilöstö" (k2 "osasto")) ; --UNCHK
lin judgement_N = mkWN (k3 "arvio") ; --UNCHK
lin exciting_A = mkWA (k10 "jännittävä") ; --UNCHK
lin stream_N = mkWN (k39 "virtaus") ; --UNCHK
lin perception_N = mkWN (k39 "aistimus") ;
lin guarantee_VS = mkWVS (k73A "luvata") ; --UNCHK
lin guarantee_V2 = mkV2 "taata" ;
lin guarantee_V = mkWV (k73A "luvata") ; --UNCHK
lin disaster_N = mkWN (k5 "katastrofi") ; --f107
lin darkness_N = mkWN "tummaihoisuus" ; --UNCHK
lin bid_N = mkN "tarjous" ;
lin sake_N = mkWN (k1A "hyöty") ; --UNCHK
lin sake_2_N = variants{} ; -- 
lin sake_1_N = variants{} ; -- 
lin organize_V2V = mkWV2V (k53 "järjestää") ; --UNCHK
lin organize_V2 = mkV2 "organisoida" ;
lin tourist_N = mkWN (k5 "turisti") ;
lin policeman_N = L.policeman_N ;
lin castle_N = mkWN (k39 "linnoitus") ; --UNCHK
lin figure_VS = mkWVS (k74 "tajuta") ;
lin figure_V = mkV "kuvitella" ;
lin race_VV = mkVV "rynnätä" infIllat ;
lin race_V2V = mkWV2V (k70 "juosta") ; --UNCHK
lin race_V2 = mkWV2 (k70 "juosta") ; --UNCHK
lin race_V = mkWV (k70 "juosta") ; --UNCHK
lin demonstration_N = mkWN (k10 "esitelmä") ; --UNCHK
lin anger_N = mkWN (k39 "suuttumus") ; --UNCHK
lin briefly_Adv = variants{} ; -- 
lin presumably_Adv = variants{} ; -- 
lin clock_N = mkWN (k1 "kello") ;
lin hero_N = mkWN (compoundN "pää" (k2 "henkilö")) ; --UNCHK
lin expose_V2 = mkWV2 (k53A "jättää") "heitteille" ; --UNCHK
lin expose_V = mkV (mkV "tulla") "ilmi" ; --mkWV (k53A "jättää") "heitteille" ;
lin custom_N = mkWN (k1A "käytäntö") ; --UNCHK
lin maximum_A = mkWA (k38 "maksimaalinen") ; --UNCHK
lin wish_N = mkWN (k48 "toive") ;
lin earning_N = variants{} ; -- 
lin priest_N = L.priest_N ;
lin resign_V2 = mkV2 "luopua" elative ;
lin resign_V = mkV "luopua" ;
lin store_V2 = mkWV2 (k62 "varastoida") ; --UNCHK
lin widespread_A = mkA (mkN "laajalle" (mkN "levinnyt")) ;
lin comprise_V2 = mkWV2 (k54A "sisältää") ; --UNCHK
lin chamber_N = mkWN (k6 "kamari") ; --UNCHK
lin acquisition_N = mkN "hankinta" ;
lin involved_A = variants{} ; -- 
lin confident_A = mkA "luottavainen" ;
lin circuit_N = mkWN (k39 "kierros") ; --f57
lin radical_A = mkA "radikaali" ; --WA "tyvi-" ;
lin detect_V2 = mkWV2 (k73 "huomata") ; --UNCHK
lin stupid_A = L.stupid_A ;
lin grand_A = mkWA (k10 "mahtava") ;
lin consumption_N = mkWN (k39 "kulutus") ;
lin hold_N = mkWN (k48A "ote") ; --UNCHK
lin zone_N = mkWN (k48A "rakenne") ; --UNCHK
lin mean_A = mkA "ilkeä" ; --mkWA (k38 "viheliäinen") ;
lin altogether_Adv = mkWAdv (k99 "tyystin") ; --UNCHK
lin rush_VV = variants{}; -- mkWV2V (k53A "hoputtaa") ; --UNCHK
lin rush_V2 = mkWV2 (k53A "hoputtaa") ; --UNCHK
lin rush_V = mkV "kiirehtiä" ; --WV (k53A "hoputtaa") ;
lin numerous_A = mkA "lukematon" ;
lin sink_V2 = mkWV2 (k52A "vaipua") ; --UNCHK
lin sink_V = mkWV (k52A "vaipua") ; --UNCHK
lin everywhere_Adv = S.everywhere_Adv ;
lin classical_A = mkWA (k38 "klassinen") ; --UNCHK
lin respectively_Adv = variants{} ; -- 
lin distinct_A = mkWA "erottuva" ;
lin mad_A = mkWA (k38 "vihainen") ;
lin honour_N = mkWN (k40 "koskemattomuus") ; --UNCHK
lin statistics_N = mkN "tilasto" ; ---ARB mkWN (compoundN "tilasto" (k48A "tiede")) ;
lin false_A = mkWA (k10 "väärä") ;
lin square_N = mkWN (k50 "suorakulma") ; --UNCHK
lin differ_V = mkV "eritä" ;
lin disk_N = mkN (lin NK {s = d01 "levy"}) ;
lin truly_Adv = mkWAdv (k99 "oikeasti") ; --UNCHK
lin survival_N = mkWN (compoundN "elo" (k38 "onjääminen")) ; --UNCHK
lin proud_A = mkWA (k15 "ylpeä") ; --UNCHK
lin tower_N = mkWN (k5 "torni") ;
lin deposit_N = mkN "takuusumma" ; ---??
lin pace_N = mkN "tahti" ; --f62
lin compensation_N = mkN "korvaus" ; --WN (k3 "palkkio") ;
lin adviserMasc_N = variants{} ; -- 
lin consultant_N = mkWN (k5A "konsultti") ; --f133
lin drag_V2 = mkV2 "vetää" ; ---ARB --mkV2 "raahata" ; --mkV2 "pitkittää" ;
lin drag_V = mkWV (k52A "pitkittyä") ; --UNCHK
lin advanced_A = variants{} ; -- 
lin landlord_N = mkWN (k10 "omistaja") ; --UNCHK
lin whenever_Adv = variants{} ; -- 
lin delay_N = mkWN (k39 "viivästys") ; --f72
lin green_N = mkN "vihreä" ; --mkWN "super" "C" ;
lin car_V = variants{} ; -- 
lin holder_N = mkN "omistaja" ; ---ARB mkN "pitäjä"
lin secret_A = mkWA (k38 "salainen") ;
lin edition_N = mkWN (k39 "painos") ;
lin occupation_N = mkN "ammatti" ; ---ARB --mkN "miehitys" ; --mkN "haltuunotto" ; --mkWN (k1A "muutto") ;
lin agricultural_A = mkA (mkN "maan" (mkN "viljelyllinen")) ;
lin intelligence_N = variants{} ; -- 
lin intelligence_2_N = mkN "älykkyys" ; ---ARB WN (k2 "tiedustelu") ;
lin intelligence_1_N = mkN "älykkyys" ; ---ARB WN (k2 "tiedustelu") ;
lin empire_N = mkWN "Empire" ; --UNCHK
lin definitely_Adv = variants{} ; -- 
lin negotiate_VV = mkWVV (k61A "sopia") "ehdoista" ; --UNCHK
lin negotiate_V2 = mkV2 "neuvotella" elative ;
lin negotiate_V = mkV "neuvotella" ;
lin host_N = mkWN (k10A "isäntä") ;
lin relative_N = mkWN (k38 "sukulainen") ; --UNCHK
lin mass_A = variants{} ; -- 
lin helpful_A = mkWA (k38 "hyödyllinen") ;
lin fellow_N = mkWN (k4A "nuorikko") ; --UNCHK
lin sweep_V2 = mkV2 "raivata" ;
lin sweep_V = mkWV (k53A "voittaa") "ylivoimaisesti" ; --UNCHK
lin poet_N = mkWN (k12 "runoilija") ; --UNCHK
lin journalist_N = mkWN (k10 "pitäjä") "päiväkirjan" ; --UNCHK
lin defeat_N = mkWN (k3 "häviö") ;
lin unlike_Prep = mkPrep "erilainen kuin" nominative ;
lin primarily_Adv = variants{} ; -- 
lin tight_A = mkA "tiukka" ;
lin indication_N = mkN "merkki" ; --f61
lin dry_V2 = mkWV2 (k53A "kuivattaa") ; --UNCHK
lin dry_V = mkWV (k53A "kuivattaa") ; --UNCHK
lin cricket_N = mkWN (k5A "kriketti") ; --UNCHK
lin whisper_V2 = mkWV2 (k73 "kuiskata") ; --UNCHK
lin whisper_V = mkWV (k73 "kuiskata") ; --UNCHK
lin routine_N = mkWN (k5 "rutiini") ; --UNCHK
lin print_N = mkWN (k39 "vedos") ; --UNCHK
lin anxiety_N = mkWN (k26 "huoli") ; --UNCHK
lin witness_N = mkWN (k10 "todistaja") ;
lin concerning_Prep = variants{} ; -- 
lin mill_N = mkN "mylly" ;
lin gentle_A = mkA "lempeä" ; --mkWA (k38 "vähittäinen") ;
lin curtain_N = mkN "esirippu" ;
lin mission_N = mkN "tehtävä" ;
lin supplier_N = mkWN (k10 "toimittaja") ;
lin basically_Adv = mkWAdv (k99 "sisimmältään") ; --UNCHK
lin assure_V2S = mkV2S (mkV "vakuuttaa") (casePrep allative) ;
lin assure_V2 = mkV2 "varmistaa" ;
lin poverty_N = mkN "köyhyys" ;
lin snow_N = L.snow_N ;
lin prayer_N = mkWN (k39 "rukous") ; --UNCHK
lin pipe_N = mkWN (k1 "pillistö") ; --UNCHK
lin deserve_VV = mkWVV (k69 "ansaita") ; --UNCHK
lin deserve_V2 = mkWV2 (k69 "ansaita") ; --UNCHK
lin deserve_V = mkWV (k69 "ansaita") ; --UNCHK
lin shift_N = mkWN (k39 "muutos") ;
lin split_V2 = L.split_V2 ;
lin split_V = mkWV (k52A "rikkoutua") ; --UNCHK
lin near_Adv = mkWAdv (k99 "liki") ; --UNCHK
lin consistent_A = mkA "johdonmukainen" ;
lin carpet_N = L.carpet_N ;
lin ownership_N = mkWN (k39 "omistus") ;
lin joke_N = mkN (lin NK {s = d05 "vitsi"}) ;
lin fewer_Det = variants{} ; -- 
lin workshop_N = mkWN (k5 "seminaari") ; --UNCHK
lin salt_N = L.salt_N ;
lin aged_Prep = variants{} ; -- 
lin symbol_N = mkN "symboli" ;
lin slide_V2 = mkWV2 (k52 "lipsua") ; --UNCHK
lin slide_V = mkV "liukua" ;
lin cross_N = mkWN (k39 "risteytys") ;
lin anxious_A = mkWA (k41A "innokas") ; --UNCHK
lin tale_N = mkWN (k1A "pöty") ; --UNCHK
lin preference_N = mkWN (compoundN "etu" (k40 "oikeus")) ; --UNCHK
lin inevitably_Adv = variants{} ; -- 
lin mere_A = mkWA (k10A "pelkkä") ; --f64
lin behave_V = mkWV (k67A "menetellä") ; --UNCHK
lin gain_N = mkN "hyöty" ;
lin nervous_A = mkA "hermostunut" ; ---ARB WA (k38 "hermostollinen") ;
lin guide_V2 = mkWV2 (k53A "liikuttaa") ; --UNCHK
lin remark_N = mkN "huomautus" ;
lin pleased_A = variants{} ; -- 
lin province_N = mkWN (compoundN "maa" (k10A "kunta")) ; --UNCHK
lin steel_N = L.steel_N ;
lin practise_V2 = mkWV2 (k73 "treenata") ; --UNCHK
lin practise_V = mkWV (k73 "treenata") ; --UNCHK
lin flow_V = L.flow_V ;
lin holy_A = mkWA (k10 "pyhä") ; --UNCHK
lin dose_N = mkN "annos" ; --mkWN (k1A "lappu") ;
lin alcohol_N = mkWN (k9 "viina") ; --UNCHK
lin guidance_N = mkWN (k39 "ohjaus") ; --UNCHK
lin constantly_Adv = variants{} ; -- 
lin climate_N = mkWN (k2 "ilmasto") ;
lin enhance_V2 = mkWV2 (k53 "tehostaa") ;
lin reasonably_Adv = variants{} ; -- 
lin waste_V2 = mkWV2 (k52 "virua") ; --UNCHK
lin waste_V = mkWV (k52 "virua") ; --UNCHK
lin smooth_A = L.smooth_A ;
lin dominant_A = mkWA (k10 "hallitseva") ; --UNCHK
lin conscious_A = mkWA (k38 "tietoinen") ; --UNCHK
lin formula_N = mkWN (k1A "käytäntö") ; --UNCHK
lin tail_N = L.tail_N ;
lin ha_Interj = variants{} ; -- 
lin electric_A = mkA "sähköinen" ; ---ARB WA "sähkö-" ;
lin sheep_N = L.sheep_N ;
lin medicine_N = mkWN (compoundN "lääke" (k48A "tiede")) ; --UNCHK
lin strategic_A = mkWA (k38 "strateginen") ; --f54
lin disabled_A = variants{} ; -- 
lin smell_N = mkWN (compoundN "hai" (k38 "staminen")) ; --UNCHK
lin operator_N = mkN "operaattori" "operaattoreita" ;
lin mount_V2 = mkWV2 (k54A "asentaa") ; --UNCHK
lin mount_V = mkWV (k54A "asentaa") ; --UNCHK
lin advance_V2 = mkV2 "edistää" ;
lin advance_V = mkV "edetä" ;
lin remote_A = mkWA (k38 "etäinen") ; --UNCHK
lin measurement_N = mkWN (k9A "mitta") ; --UNCHK
lin favour_VS = variants{}; -- mkWV2 (k61 "suosia") ; --UNCHK
lin favour_V2 = mkWV2 (k61 "suosia") ; --UNCHK
lin favour_V = variants{}; -- mkWV2 (k61 "suosia") ; --UNCHK
lin neither_Det = MorphoFin.mkDetPol True Sg {s = table NForm {nf => (snoun2nounBind (nforms2snoun (dSuurempi "kumpi"))).s ! nf + "kaan"} ; h = Back} ;
lin architecture_N = mkWN (k5 "arkkitehtuuri") ; --UNCHK
lin worth_N = mkWN (k1 "arvo") ;
lin tie_N = mkN "tasa" (mkN "peli") ; --f54 ---ARB ; solmio ; kahle
lin barrier_N = mkN "este" ; --WN (k5 "puomi") ;
lin practitioner_N = mkWN (compoundN "ammatin" (k10 "harjoittaja")) ;
lin outstanding_A = mkA "erinomainen" ;
lin enthusiasm_N = mkWN (k1A "into") ; --UNCHK
lin theoretical_A = mkWA (k38 "teoreettinen") ;
lin implementation_N = mkWN (k39 "toteutus") ; --UNCHK
lin worried_A = variants{} ; -- 
lin pitch_N = mkWN (k1A "syöttö") ; --UNCHK
lin drop_N = mkN "putoaminen" ;
lin phone_V2 = mkWV2 (k53A "soittaa") ; --UNCHK
lin phone_V = mkWV (k53A "soittaa") ; --UNCHK
lin shape_VV = mkWVV (k73 "muovata") ; --UNCHK
lin shape_V2 = mkWV2 (k73 "muovata") partitive ;
lin shape_V = mkV "muovautua" ;
lin clinical_A = mkWA (k38 "kliininen") ;
lin lane_N = mkWN (k10 "kuja") ; --UNCHK
lin apple_N = L.apple_N ;
lin catalogue_N = mkWN (k2 "luettelo") ; --UNCHK
lin tip_N = mkN "kärki" ;
lin publisher_N = mkN (lin NK {s = d10 "kustantaja"}) ;
lin opponentMasc_N = variants{} ; -- 
lin live_A = mkWA (k99 "hengissä") ; --UNCHK
lin burden_N = mkN "taakka" ;
lin tackle_V2 = mkWV2 (k73 "taklata") ; --UNCHK
lin tackle_V = mkWV (k73 "taklata") ; --UNCHK
lin historian_N = mkWN (k12 "historioitsija") ; --UNCHK
lin bury_V2 = mkWV2 (k53A "unohtaa") ; --UNCHK
lin bury_V = mkWV (k53A "unohtaa") ; --UNCHK
lin stomach_N = mkWN (k1 "masu") ; --UNCHK
lin percentage_N = mkN "prosenttiosuus" ;
lin evaluation_N = mkWN (k5A "evaluointi") ; --UNCHK
lin outline_V2 = mkWV2 (k53A "vetää") "yhteen" ; --UNCHK
lin talent_N = mkWN (k40 "lahjakkuus") ; --UNCHK
lin lend_V2 = mkWV2 (k56A "antaa") "lainaksi" ; --UNCHK
lin lend_V = mkWV (k56A "antaa") "lainaksi" ; --f76
lin silver_N = L.silver_N ;
lin pack_N = mkWN (k5A "paketti") ; --UNCHK
lin fun_N = mkWN (k40 "hauskuus") ; --UNCHK
lin democrat_N = mkWN (k5 "populisti") ; --UNCHK
lin fortune_N = mkWN (kH1 "säkä") ; --UNCHK
lin storage_N = mkWN (k5A "varastointi") ;
lin professional_N = mkWN (k38 "ammattilainen") ;
lin reserve_N = mkN "reservi" ;
lin interval_N = mkWN (k1 "ero") ; --UNCHK
lin dimension_N = mkWN (k40 "laajuus") ; --UNCHK
lin honest_A = mkA "rehellinen" ;
lin awful_A = mkWA (k9 "paha") ; --UNCHK
lin manufacture_V2 = mkV2 (lin VK {s = c53A "tuottaa"}) ;
lin confusion_N = mkWN (compoundN "seka" (k38 "antuminen")) ; --UNCHK
lin pink_A = mkWA (compoundA "vaalean" (k38 "punainen")) ; --UNCHK
lin impressive_A = mkWA (k10 "vaikuttava") ; --UNCHK
lin satisfaction_N = mkN "tyytyväisyys" ;
lin visible_A = mkWA (k10 "näkyvä") ; --UNCHK
lin vessel_N = mkWN (k39 "alus") ; --UNCHK
lin stand_N = mkWN (compoundN "puolustus" (k10 "asema")) ; --UNCHK
lin curve_N = mkN "käyrä" ; ---ARB --mkWN (k48A "kierre") ;
lin pot_N = mkWN (k12 "kattila") ;
lin replacement_N = mkN "korvaaminen" ;
lin accurate_A = mkWA (k34A "virheetön") ; --UNCHK
lin mortgage_N = mkN "kiinnelaina" ;
lin salary_N = mkN "palkka" ;
lin impress_V2 = mkV2 (mkV (mkWV (k71 "tehdä")) "vaikutus") (mkPrep illative) ; --mkWV2 (k73 "värjätä") ;
lin impress_V = mkWV (k73 "värjätä") ; --UNCHK
lin constitutional_A = mkWA (compoundA "perustus" (k38 "laillinen")) ;
lin emphasize_VS = mkWVS (k54A "tähdentää") ; --UNCHK
lin emphasize_V2 = mkWV2 (k54A "tähdentää") ; --UNCHK
lin developing_A = variants{} ; -- 
lin proof_N = mkWN (k39 "todistus") ; --UNCHK
lin furthermore_Adv = mkWAdv (k99 "lisäksi") "sen" ; --UNCHK
lin dish_N = mkN "annos" ; ---ARB --mkWN (k1A "juttu") ;
lin interview_V2 = mkWV2 (k67 "kysellä") ; --UNCHK
lin considerably_Adv = variants{} ; -- 
lin distant_A = mkWA (k38 "kaukainen") ;
lin lower_V2 = mkV2 (mkV (lin VK {s = c58 "laskea"})) partitive ;
lin lower_V = mkWV (k67 "mulkoilla") ; --UNCHK
lin favouriteMasc_N = variants{} ; -- 
lin tear_V2 = mkWV2 (k61A "kyynelehtiä") ; --UNCHK
lin tear_V = mkV "repeytyä" ;
lin fixed_A = variants{} ; -- 
lin by_Adv = mkWAdv (k99 "talteen") ; --UNCHK
lin luck_N = mkN "tuuri" ;
lin count_N = mkWN (k38 "lukeminen") "numeroiden" ; --UNCHK
lin precise_A = mkWA (k38 "täsmällinen") ; --UNCHK
lin determination_N = mkN "päättäväisyys" ; --mkWN "löytäminen" ;
lin bite_V2 = L.bite_V2 ;
lin bite_V = mkV "purra" ; --UNCHK
lin dear_Interj = variants{} ; -- 
lin consultation_N = mkWN (k5A "konsultointi") ; --UNCHK
lin range_V = mkV "luokitella" ; --f79
lin residential_A = mkWA "asuin-" ; --UNCHK
lin conduct_N = mkWN (k9A "toiminta") ; --UNCHK
lin capture_V2 = mkWV2 (k73A "napata") ;
lin ultimately_Adv = variants{} ; -- 
lin cheque_N = mkWN (k5A "šekki") ; --UNCHK
lin economics_N = mkWN (k12 "ekonomia") ; --UNCHK
lin sustain_V2 = mkV2 "ylläpitää" ; --f54
lin secondly_Adv = variants{} ; -- 
lin silly_A = mkWA (k10 "sekava") ;
lin merchant_N = mkWN (k41 "kauppias") ;
lin lecture_N = mkWN (k5A "esitelmöinti") ; --UNCHK
lin musical_A = mkWA (k38 "melodinen") ; --UNCHK
lin leisure_N = mkWN (k9 "vapaa-aika") ;
lin check_N = mkN "tarkistus" ;
lin cheese_N = L.cheese_N ;
lin lift_N = mkWN (k1 "nosto") ; --UNCHK
lin participate_V2 = mkWV2 (k53A "ottaa") "osaa" ; --UNCHK
lin participate_V = mkWV (k53A "ottaa") "osaa" ; --f59
lin fabric_N = mkWN (k48A "vaate") ; --UNCHK
lin distribute_V2 = mkV2 "levittää" ; --f63
lin lover_N = mkWN (k10 "rakastaja") ; --UNCHK
lin childhood_N = mkWN (k40 "lapseus") ; --UNCHK
lin cool_A = mkWA (k15 "viileä") ; --UNCHK
lin ban_V2 = mkWV2 (k54A "kieltää") ; --f58
lin supposed_A = mkWA (k38 "hypoteettinen") ; --UNCHK
lin mouse_N = mkWN (k24 "hiiri") ; --UNCHK
lin strain_N = mkWN (k10 "sävelmä") ; --UNCHK
lin specialist_A = variants{} ; -- 
lin consult_V2 = mkV2 "konsultoida" partitive ; --WV2 (k61 "toimia") "neuvonantajana" ;
lin consult_V = mkV (mkV "pyytää") "neuvoa" ; --f56
lin minimum_A = mkWA (k38 "minimaalinen") ; --f64
lin approximately_Adv = variants{} ; -- 
lin participant_N = mkWN (k10 "osallistuja") ; --f59
lin monetary_A = mkWA (k38 "rahallinen") ; --f62
lin confuse_V2 = mkWV2 (k52A "erehtyä") ; --UNCHK
lin dare_VV = mkWVV (k56 "haastaa") ; --UNCHK
lin dare_V2 = mkWV2 (k56 "haastaa") ; --UNCHK
lin smoke_N = L.smoke_N ;
lin movie_N = mkN "elokuva" ;
lin seed_N = L.seed_N ;
lin cease_V2 = mkWV2 (k52A "loppua") ; --UNCHK
lin cease_V = mkWV (k52A "loppua") ; --UNCHK
lin open_Adv = variants{} ; -- 
lin journal_N = mkWN (compoundN "laakeri" (k9A "pinta")) ; --UNCHK
lin shopping_N = mkWN "ostaminen" ;
lin equivalent_N = mkN "samanarvoinen" ; --WN (k5A "ekvivalentti") ;
lin palace_N = mkWN (k5 "palatsi") ; --UNCHK
lin exceed_V2 = mkV2 "ylittää" ;
lin isolated_A = variants{} ; -- 
lin poetry_N = mkWN (k14A "lyriikka") ; --UNCHK
lin perceive_VS = mkWVS (k54A "oivaltaa") ; --UNCHK
lin perceive_V2V = mkWV2V (k54A "oivaltaa") ; --UNCHK
lin perceive_V2 = mkWV2 (k54A "oivaltaa") ; --UNCHK
lin lack_V2 = mkV2 (caseV ablative (mkV "puuttua")) ;
lin lack_V = mkV "puuttua" ;
lin strengthen_V2 = mkV2 (mkV "vahvistaa") partitive ;
lin snap_V2 = mkWV2 (k67 "rakoilla") ; --UNCHK
lin snap_V = mkWV (k67 "rakoilla") ; --UNCHK
lin readily_Adv = variants{} ; -- 
lin spite_N = mkWN (k9 "kauna") ; --UNCHK
lin conviction_N = mkN "vakaumus" ; ---ARB mkWN (k3 "tuomio") ;
lin corridor_N = mkWN (k10 "käytävä") ; --UNCHK
lin behind_Adv = mkWAdv (k99 "takana") ; --UNCHK
lin ward_N = mkWN (compoundN "vanki" (k2 "osasto")) ; --UNCHK
lin profile_N = mkWN (compoundN "henkilö" (k10 "kuva")) ; --UNCHK
lin fat_A = mkWA (k10 "pulska") ; --UNCHK
lin comfort_N = mkWN (k7A "tuki") ; --UNCHK
lin bathroom_N = mkWN (k99 "WC") ; --UNCHK
lin shell_N = mkN "kuori" ;
lin reward_N = mkWN (k39 "vahvistus") ; --UNCHK
lin deliberately_Adv = variants{} ; -- 
lin automatically_Adv = mkWAdv (k99 "automaattisesti") ; --UNCHK
lin vegetable_N = mkWN (k39 "kasvis") ;
lin imagination_N = mkWN (k2 "kuvittelu") ; --UNCHK
lin junior_A = mkWA (k16A "alempi") ; --UNCHK
lin unemployed_A = mkWA (k34A "työtön") ; --UNCHK
lin mystery_N = mkWN (k12 "asia") "tuntematon" ; --UNCHK
lin pose_V2 = mkWV2 (k53A "sekoittaa") ;
lin pose_V = mkWV (k53A "sekoittaa") ; --UNCHK
lin violent_A = mkWA (k1 "raju") ; --UNCHK
lin march_N = variants{} ; -- 
lin found_V2 = mkV2 "perustaa" ;
lin dig_V2 = mkWV2 (k74 "tajuta") ; --UNCHK
lin dig_V = L.dig_V ;
lin dirty_A = L.dirty_A ;
lin straight_A = L.straight_A ;
lin psychological_A = mkWA (k38 "psykologinen") ; --UNCHK
lin grab_V2 = mkWV2 (k53A "valloittaa") ; --UNCHK
lin grab_V = mkWV (k53A "valloittaa") ; --UNCHK
lin pleasant_A = mkWA (k10 "mukava") ; --UNCHK
lin surgery_N = mkWN (k48A "toimenpide") "kirurginen" ; --UNCHK
lin inevitable_A = mkWA (k34A "vääjäämätön") ; --UNCHK
lin transform_V2 = mkWV2 (k52A "muuttua") ; --UNCHK
lin bell_N = mkN "soittokello" ; --WN (k1A "tiuku") ;
lin announcement_N = mkWN (k39 "kuulutus") ; --f135
lin draft_N = mkWN (kH1 "veto") ; --UNCHK
lin unity_N = mkWN (k40 "yhtenäisyys") ;
lin airport_N = mkWN (compoundN "lento" (k10A "kenttä")) ;
lin upset_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin upset_V = mkV "järkkyä" ; --mkWV (k53A "sekoittaa") ;
lin pretend_VS = mkWVS (k67A "uskotella") ; --UNCHK
lin pretend_V2 = mkWV2 (k67A "uskotella") ; --UNCHK
lin pretend_V = mkWV (k67A "uskotella") ; --UNCHK
lin plant_V2 = mkWV2 (k53A "juurruttaa") ; --UNCHK
lin till_Prep = variants{} ; -- 
lin known_A = variants{} ; -- 
lin admission_N = mkWN (k1 "tulo") ; --UNCHK
lin tissue_N = mkWN (k39 "kudos") ; --UNCHK
lin magistrate_N = mkWN (k5A "maistraatti") ; --UNCHK
lin joy_N = mkWN (k1 "ilo") ; --UNCHK
lin free_V2V = mkWV2V (k53A "vapauttaa") ; --UNCHK
lin free_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin pretty_A = mkA "sievä" ;
lin operating_N = variants{} ; -- 
lin headquarters_N = mkWN (compoundN "esi" (k10A "kunta")) ; --UNCHK
lin grateful_A = mkWA (k38 "kiitollinen") ; --UNCHK
lin classroom_N = mkWN (kH1 "luokka") ; --UNCHK
lin turnover_N = mkN "liikevaihto" ; ---ARB mkWN "kumoaminen" ;
lin project_VS = mkWVS (k53A "esittää") ; --UNCHK
lin project_V2V = mkWV2V (k53A "esittää") ; --UNCHK
lin project_V2 = mkWV2 (k53A "esittää") ; --UNCHK
lin project_V = mkV "heijastua" ; --mkWV (k53A "esittää") ;
lin shrug_V2 = mkV2 "kohauttaa" ;
lin sensible_A = mkWA (k38 "järjellinen") ; --UNCHK
lin limitation_N = mkWN (k39 "rajoitus") ;
lin specialist_N = mkWN (k5 "spesialisti") ; --f108
lin newly_Adv = variants{} ; -- 
lin tongue_N = L.tongue_N ;
lin refugee_N = mkWN (k38 "pakolainen") ; --UNCHK
lin delay_V2 = mkWV2 (k53A "viivyttää") ; --f56
lin delay_V = mkWV (k53A "viivyttää") ; --UNCHK
lin dream_V2 = mkWV2 (k67 "haaveilla") ; --UNCHK
lin dream_V = mkWV (k67 "haaveilla") ;
lin composition_N = mkWN (k2 "kynäily") ; --UNCHK
lin alongside_Prep = mkPrep "rinnalla" ;
lin ceiling_N = L.ceiling_N ;
lin highlight_V2 = mkWV2 (k53 "korostaa") ; --UNCHK
lin stick_N = L.stick_N ;
lin favourite_A = mkWA "mieli-" ; --UNCHK
lin tap_V2 = mkWV2 (k73 "kerjätä") ; --UNCHK
lin tap_V = mkV (mkV "päästä") "käsiksi" ; ---ARB --mkWV (k73 "kerjätä") ;
lin universe_N = mkN "niversumi" ;
lin request_VS = mkWVS (k52 "anoa") ; --UNCHK
lin request_V2 = mkV2 (mkV "pyytää") partitive ;
lin label_N = mkWN (compoundN "levy-" (k3 "yhtiö")) ; --UNCHK
lin confine_V2 = mkV2 "rajoittaa" partitive ; --mkWV2 (k54A "vähentää") ;
lin scream_VS = mkWVS (k52A "kirkua") ;
lin scream_V2 = mkWV2 (k52A "kirkua") ; --UNCHK
lin scream_V = mkWV (k52A "kirkua") ;
lin rid_V2 = mkWV2 (k53 "päästää") ; --UNCHK
lin acceptance_N = mkWN (compoundN "vastaan" (k1A "otto")) ; --UNCHK
lin detective_N = mkWN (k10 "etsivä") ;
lin sail_V = mkWV (k73 "seilata") ; --UNCHK
lin adjust_V2 = mkV2 "tottua" illative ;
lin adjust_V = mkWV (k52A "tottua") ;
lin designer_N = mkWN (k12 "suunnittelija") ; --UNCHK
lin running_A = variants{} ; -- 
lin summit_N = mkN "huippukokous" ;
lin participation_N = mkWN (compoundN "osan" (k1A "otto")) ;
lin weakness_N = mkWN (k40 "heikkous") ; --f77
lin block_V2 = mkWV2 (k58A "sulkea") ; --f88
lin socalled_A = variants{} ; -- 
lin adapt_V2 = mkV2 "mukauttaa" ; --mkWV2 (k52A "tottua") ;
lin adapt_V = mkWV (k52A "tottua") ;
lin absorb_V2 = mkV2 "imeä" ;
lin encounter_V2 = mkV2 "kohdata" partitive ; --WV2 (k53A "ottaa") "yhteen" ;
lin defeat_V2 = mkWV2 (k64 "lyödä") ; --UNCHK
lin excitement_N = mkN "innostus" ; --mkWN (k6 "meteli") ;
lin brick_N = mkWN (k23 "tiili") ; --UNCHK
lin blind_A = mkA "sokea" ; --mkWA (k34A "varaukseton") ;
lin wire_N = mkWN (compoundN "metalli" (k9A "lanka")) ;
lin crop_N = mkWN (k1A "sato") ; --f65
lin square_A = mkWA (compoundA "nelikul" (k38 "mainen")) ; --UNCHK
lin transition_N = mkWN (k10 "siirtymä") ; --UNCHK
lin thereby_Adv = mkWAdv (k99 "siten") ; --UNCHK
lin protest_V2 = mkV2 "vastustaa" partitive ; --mkWV2 (k53A "esittää") "vastalause" ;
lin protest_V = mkWV (k53A "esittää") "vastalause" ; --UNCHK
lin roll_N = mkN "rulla" ; ---ARB mkWN (k39 "vieritys") ;
lin stop_N = mkWN (k39 "pysähdys") ;
lin assistant_N = mkWN (k10 "avustaja") ;
lin deaf_A = mkWA (compoundA "kuulo" (k38 "vammainen")) ; --UNCHK
lin constituency_N = mkWN (compoundN "valitsija" (k10A "kunta")) ; --UNCHK
lin continuous_A = mkWA (k34A "keskeytymätön") ; --UNCHK
lin concert_N = mkWN (k5A "konsertti") ;
lin breast_N = L.breast_N ;
lin extraordinary_A = mkA (separateN "tavallisuudesta" (mkN "poikkeava" "poikkeavia")) ;
lin squad_N = mkWN (k2 "osasto") ;
lin wonder_N = mkWN (k40 "uteliaisuus") ; --UNCHK
lin cream_N = mkWN (k48A "voide") ; --UNCHK
lin tennis_N = mkWN (k39 "tennis") ;
lin personally_Adv = variants{} ; -- 
lin communicate_V2 = mkWV2 (k67 "olla") "vuorovaikutuksessa" ; --UNCHK
lin communicate_V = mkWV (k67 "olla") "vuorovaikutuksessa" ; --UNCHK
lin pride_N = mkWN (k40 "kopeus") ; --UNCHK
lin bowl_N = mkWN (k39 "vieritys") ; --UNCHK
lin file_V2 = mkV2 (mkWV (k53 "nostaa") "kanne") (mkPrep partitive "vastaan") ;
lin file_V = mkV "arkistoida" ;
lin expertise_N = mkWN (k1A "taito") ; --UNCHK
lin govern_V2 = mkWV2 (k53A "vaikuttaa") "ratkaisevasti" ; --UNCHK
lin govern_V = mkWV (k53A "vaikuttaa") "ratkaisevasti" ; --UNCHK
lin leather_N = L.leather_N ;
lin observer_N = mkN "tarkkailija" ;
lin margin_N = mkN "marginaali" ;
lin uncertainty_N = mkN "epä" (mkN "varmuus") ; ----CHANGE "sattumanvaraisuus" ;
lin reinforce_V2 = mkWV2 (k53A "lujittaa") ; --UNCHK
lin ideal_N = mkN "ihanne" ; --mkWN (k5 "ideaali") ;
lin injure_V2 = mkWV2 (k53A "satuttaa") ; --UNCHK
lin holding_N = mkN "omistus" ;
lin universal_A = mkWA (k5 "universaali") ; --UNCHK
lin evident_A = mkWA (kH1 "ilmeinen") ; --UNCHK
lin dust_N = L.dust_N ;
lin overseas_A = mkWA (k38 "ulkomainen") ; --f62
lin desperate_A = mkA "epätoivoinen" ;
lin swim_V2 = mkWV2 (k52 "pysyä") "pinnalla" ; --UNCHK
lin swim_V = L.swim_V ;
lin occasional_A = mkWA (k38 "ajoittainen") ; --UNCHK
lin trouser_N = mkN "housu" ;
lin surprisingly_Adv = variants{} ; -- 
lin register_N = mkWN (k9 "kassa") ; --UNCHK
lin album_N = mkWN (k6 "albumi") ; --UNCHK
lin guideline_N = mkN (lin NK {s = d48 "ohje"}) ;
lin disturb_V2 = mkWV2 (k53A "vahingoittaa") ; --UNCHK
lin amendment_N = mkWN (k2 "oikaisu") ; --f60
lin architectMasc_N = variants{} ; -- 
lin objection_N = mkWN (compoundN "vasta" (k48 "lause")) ; --UNCHK
lin chart_N = mkWN (compoundN "meri" (k5A "kortti")) ; --UNCHK
lin cattle_N = mkWN (k9A "nauta") ; --UNCHK
lin doubt_VS = mkWVS (k67 "epäillä") ; --UNCHK
lin doubt_V2 = mkV2 "epäillä" partitive ;
lin react_V = mkWV (k62 "reagoida") ;
lin consciousness_N = mkWN (k1 "taju") ; --UNCHK
lin right_Interj = variants{} ; -- 
lin purely_Adv = variants{} ; -- 
lin tin_N = mkWN (k5A "tölkki") ; --UNCHK
lin tube_N = mkWN (k1 "metro") ; --UNCHK
lin fulfil_V2 = mkWV2 (k53A "toteuttaa") ; --UNCHK
lin commonly_Adv = variants{} ; -- 
lin sufficiently_Adv = variants{} ; -- 
lin coin_N = mkN "kolikko" ; --WN (k5A "lantti") ;
lin frighten_V2 = mkV2 "pelotella" partitive ;
lin grammar_N = L.grammar_N ;
lin diary_N = mkWN (k6 "päivyri") ; --UNCHK
lin flesh_N = mkWN (k41 "ruumis") ; --UNCHK
lin summary_N = mkWN (k10 "lyhennelmä") ;
lin infant_N = mkN "pikku" (mkN "lapsi") ; --mkWN (k38 "pienokainen") ;
lin stir_V2 = mkV2 "sekoittaa" partitive ;
lin stir_V = mkWV (k73 "vatkata") ; --UNCHK
lin storm_N = mkN "myrsky" ; ---ARB mkWN (k4A "rynnäkkö") ;
lin mail_N = mkN "posti" ;
lin rugby_N = mkWN (k1 "rugby") ; --UNCHK
lin virtue_N = mkN "hyve" ; --mkWN (k40 "erinomaisuus") "moraalinen" ;
lin specimen_N = mkWN (k48A "näyte") ; --UNCHK
lin psychology_N = mkWN (k48A "tiede") "psykologinen" ; --UNCHK
lin paint_N = mkWN (k5A "pigmentti") ; --UNCHK
lin constraint_N = mkWN (compoundN "pakko" (k1 "keino")) ;
lin trace_V2 = mkV2 "jäljittää" ;
lin trace_V = variants{}; -- mkV2 "jäljittää" ;
lin privilege_N = mkWN (compoundN "etu" (k40 "oikeus")) ; --UNCHK
lin completion_N = mkWN (k1A "loppu") ; --UNCHK
lin progress_V2 = mkWV2 (k52A "kehittyä") ; --UNCHK
lin progress_V = mkWV (k52A "kehittyä") ; --UNCHK
lin grade_N = mkWN (k1 "taso") ; --UNCHK
lin exploit_V2 = mkWV2 (k52A "hyötyä") "jstk" ; --UNCHK
lin import_N = mkN "tuonti" ;
lin potato_N = mkWN (k5A "potaatti") ; --UNCHK
lin repair_N = mkN "korjaus" ;
lin passion_N = mkN "intohimo" ;
lin seize_V2 = mkWV2 (k53A "valloittaa") ; --UNCHK
lin seize_V = mkWV (k53A "valloittaa") ; --UNCHK
lin low_Adv = mkWAdv (k99 "matalalla") ;
lin underlying_A = mkWA "kätketty" ; --UNCHK
lin heaven_N = mkWN (k41 "taivas") ; --UNCHK
lin nerve_N = mkWN (k40 "hävyttömyys") ; --UNCHK
lin park_V2 = mkWV2 (k62 "pysäköidä") ; --UNCHK
lin park_V = mkWV (k62 "pysäköidä") ; --UNCHK
lin collapse_V2 = mkWV2 (k52 "lyyhistyä") ; --UNCHK
lin collapse_V = mkV (lin VK {s = c53A "romahtaa"}) ;
lin win_N = mkWN (k1A "voitto") ;
lin printer_N = mkWN (k33 "tulostin") ;
lin coalition_N = mkWN (compoundN "yhteen" (k38 "liityminen")) ; --UNCHK
lin button_N = mkWN (k5A "nappi") ;
lin pray_V2 = mkWV2 (k54A "pyytää") ; --UNCHK
lin pray_V = mkWV (k54A "pyytää") ; --UNCHK
lin ultimate_A = mkWA (k38 "lopullinen") ; --f69
lin venture_N = mkN "yritys" ; ----CHANGE "vaarantaa" ;
lin timber_N = mkWN (k28 "hirsi") ; --UNCHK
lin companion_N = mkWN (k38 "seuralainen") ;
lin horror_N = mkWN (k39 "kauhistus") ; --UNCHK
lin gesture_N = mkWN (k48 "ele") ;
lin moon_N = L.moon_N ;
lin remark_VS = mkWVS (k73 "huomata") ; --UNCHK
lin remark_V = mkWV (k73 "huomata") ; --UNCHK
lin clever_A = L.clever_A ;
lin van_N = mkWN (compoundN "paketti" (k1 "auto")) ; --UNCHK
lin consequently_Adv = variants{} ; -- 
lin raw_A = mkWA (kH1 "raaka") ;
lin glance_N = mkWN (k39 "silmäys") ; --UNCHK
lin broken_A = variants{} ; -- 
lin jury_N = mkWN (compoundN "vala" (k2 "miehistö")) ; --f83
lin gaze_V = mkWV (k53A "tuijottaa") ; --UNCHK
lin burst_V2 = mkWV2 (k53A "syöksähtää") ; --UNCHK
lin burst_V = mkWV (k53A "syöksähtää") ; --UNCHK
lin charter_N = mkWN (compoundN "perustamis" (k9 "kirja")) ; --UNCHK
lin feministMasc_N = variants{} ; -- 
lin discourse_N = mkWN (k10 "tutkielma") ; --UNCHK
lin reflection_N = mkWN (k39 "heijastus") ;
lin carbon_N = mkWN (k39 "jäljennös") ; --UNCHK
lin sophisticated_A = mkA "sofistikoitu" ;
lin ban_N = mkWN (k1A "kielto") ; --f52
lin taxation_N = mkWN (k39 "verotus") ; --UNCHK
lin prosecution_N = mkN "syyte" ; --WN "tavoitteleminen" ;
lin softly_Adv = variants{} ; -- 
lin asleep_A = mkA "nukkuva" ; ---?? different POS
lin aids_N = mkWN (k5 "AIDS") ; --UNCHK
lin publicity_N = mkWN (k40 "julkisuus") ; --UNCHK
lin departure_N = mkN "lähtö" ;
lin welcome_A = mkWA (k47 "tervetullut") ;
lin sharply_Adv = variants{} ; -- 
lin reception_N = mkWN (compoundN "vastaan" (k1A "otto")) ;
lin cousin_N = L.cousin_N ;
lin relieve_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin linguistic_A = mkWA (k38 "kielellinen") ; --UNCHK
lin vat_N = mkWN (k5A "vati") ; --UNCHK
lin forward_A = mkWA (compoundA "suu" (k1 "nnattu")) "eteenpäin" ; --UNCHK
lin blue_N = mkN "sinisyys" ; --mkWN (compoundN "sini" (k38 "siipinen")) ;
lin multiple_A = mkWA (k15 "usea") ; --UNCHK
lin pass_N = mkN "passi" ;
lin outer_A = mkWA (k16A "ulompi") ; --UNCHK
lin vulnerable_A = mkWA (k34A "suojaton") ;
lin patient_A = mkWA (k38 "kärsivällinen") ; --UNCHK
lin evolution_N = mkN "evoluutio" ; --mkWN "kehittyminen" ;
lin allocate_V2 = mkWV2 (k67 "annostella") ; --UNCHK
lin allocate_V = mkWV (k67 "annostella") ; --UNCHK
lin creative_A = mkWA (k10 "luova") ;
lin potentially_Adv = variants{} ; -- 
lin just_A = mkWA (k1 "reilu") ; --UNCHK
lin out_Prep = mkPrep "ulos" elative ;
lin judicial_A = mkWA (k38 "juridinen") ; --UNCHK
lin risk_VV = mkWVV (k53A "ottaa") "riski" ; --UNCHK
lin risk_V2 = mkWV2 (k53A "ottaa") "riski" ; --UNCHK
lin ideology_N = mkWN (k12 "ideologia") ; --UNCHK
lin smell_VA = mkWVA (k69 "havaita") ; --UNCHK
lin smell_V2 = mkWV2 (k69 "havaita") ; --UNCHK
lin smell_V = L.smell_V ;
lin agenda_N = mkN (lin NK {s = d10 "suunnitelma"}) ;
lin transport_V2 = mkWV2 (k53A "lähettää") ; --UNCHK
lin illegal_A = mkWA (k34A "laiton") ; --f69
lin chicken_N = mkN "kanan" L.boy_N ; --WN (k9 "kana") ;
lin plain_A = mkWA (compoundA "yks" (k38 "inkertainen")) ; --UNCHK
lin innovation_N = mkWN (k3 "initiaatio") ; --UNCHK
lin opera_N = mkWN (k12 "ooppera") ; --UNCHK
lin lock_N = mkN "lukko" ;
lin grin_V = mkWV (k67 "virnistellä") ; --UNCHK
lin shelf_N = mkWN (k1 "hylly") ;
lin pole_N = mkWN (k1A "salko") ; --UNCHK
lin punishment_N = mkWN (k39 "rangaistus") ; --UNCHK
lin strict_A = mkA "tiukka" ;
lin wave_V2 = mkWV2 (k53A "taivuttaa") ; --UNCHK
lin wave_V = mkV "aaltoilla" ; --mkWV (k53A "taivuttaa") ;
lin inside_N = mkWN (k13 "sisusta") ; --UNCHK
lin carriage_N = variants{} ; -- 
lin fit_A = mkA "sopiva" ; ---ARB ; hyväkuntoinen
lin conversion_N = mkWN (k38 "uudestisyntyminen") ; --UNCHK
lin hurry_V = mkWV (k53A "hoputtaa") ; --UNCHK
lin essay_N = mkN "essee" ;
lin integration_N = mkN "integraatio" "integraatioita" ; --WN (k5A "integrointi") ;
lin resignation_N = mkN "irtisanoutuminen" ;
lin treasury_N = mkWN (compoundN "pankki" (k5 "holvi")) ;
lin traveller_N = mkWN (k10 "matkustaja") ; --UNCHK
lin chocolate_N = mkN "suklaa" ;
lin assault_N = mkWN (k4A "rynnäkkö") ;
lin schedule_N = mkN "aikataulu" ; --WN (k10 "ohjelma") ;
lin undoubtedly_Adv = variants{} ; -- 
lin twin_N = mkWN (k39 "jäljennös") ; --UNCHK
lin format_N = mkWN (kH1 "koko") ; --UNCHK
lin murder_V2 = mkV2 "murhata" ;
lin sigh_VS = mkWVS (k73A "huoata") ; --UNCHK
lin sigh_V2 = mkWV2 (k73A "huoata") ; --UNCHK
lin sigh_V = mkWV (k73A "huoata") ; --UNCHK
lin sellerMasc_N = variants{} ; -- 
lin lease_N = mkWN (compoundN "vuokra" (k39 "sopimus")) ;
lin bitter_A = mkWA (k10 "katkera") ; --UNCHK
lin double_V2 = mkWV2 (k52 "kaksinkertaistua") ; --UNCHK
lin double_V = mkWV (k52 "kaksinkertaistua") ;
lin ally_N = mkN "liittolainen" ;
lin stake_N = mkN "osallisuus" ;
lin processing_N = mkWN (k5A "prosessointi") ; --UNCHK
lin informal_A = mkWA (compoundA "epä" (k38 "virallinen")) ; --UNCHK
lin flexible_A = mkWA (k15 "notkea") ; --UNCHK
lin cap_N = L.cap_N ;
lin stable_A = mkWA (k17 "vakaa") ;
lin till_Subj = variants{} ; -- 
lin sympathy_N = mkN "sympatia" ; --mkWN (k39 "ymmärtämys") ;
lin tunnel_N = mkWN (k6 "tunneli") ;
lin pen_N = L.pen_N ;
lin instal_V = variants{} ; -- 
lin suspend_V2 = mkV2 (mkV (mkV "keskeyttää") "väliaikaisesti") ;
lin suspend_V = mkWV (compoundV "suspen" (k62 "soida")) ; --UNCHK
lin blow_N = mkWN (k7A "henki") ;
lin wander_V = mkWV (k74A "poiketa") ; --UNCHK
lin notably_Adv = variants{} ; -- 
lin disappoint_V2 = mkWV2 (k53A "pettää") ;
lin wipe_V2 = L.wipe_V2 ;
lin wipe_V = mkWV (k66 "pyyhkäistä") ; --UNCHK
lin folk_N = mkWN (compoundN "folk" (k5A "musiikki")) ; --UNCHK
lin attraction_N = mkN "viehätys" ; --WN (k40 "viehättävyys") ;
lin disc_N = mkWN (k38 "lautanen") ; --UNCHK
lin inspire_V2V = mkWV2V (k53A "hengittää") "sisään" ; --UNCHK
lin inspire_V2 = mkV2 "inspiroida" partitive ;
lin machinery_N = mkN "koneisto" ;
lin undergo_V2 = mkWV2 (k58A "kokea") ; --UNCHK
lin nowhere_Adv = mkWAdv (k99 "minnekään") "ei" ;
lin inspector_N = mkWN (k10 "tarkastaja") ; --UNCHK
lin wise_A = mkWA (k41 "viisas") ; --UNCHK
lin balance_V2 = mkV2 "tasapainottaa" partitive ; --mkWV2 (k53A "pitää") "tasapainossa" ;
lin balance_V = mkWV (k53A "pitää") "tasapainossa" ; --UNCHK
lin purchaser_N = mkWN (k10 "ostaja") ; --UNCHK
lin resort_N = mkN "turvautuminen" ; ---ARB mkN "resortti"
lin pop_N = mkN "pop-" (mkN "musiikki") ;
lin organ_N = mkN "elin" ;
lin ease_V2 = mkWV2 (k53A "lievittää") partitive ;
lin ease_V = mkV "lievittyä" ; --f55
lin friendship_N = mkWN (k40 "ystävyys") ; --UNCHK
lin deficit_N = mkWN (k48 "vaje") ; --f197
lin dear_N = mkWN (k1A "rakastettu") ; --UNCHK
lin convey_V2 = mkWV2 (k53A "välittää") ;
lin reserve_V2 = mkV2 "varata" ;
lin reserve_V = mkV (mkV "esittää") "varaus" ;
lin planet_N = L.planet_N ;
lin frequent_A = mkWA (k38 "yleinen") ; --f59
lin loose_A = mkWA (k99 "irti") ; --UNCHK
lin intense_A = mkA "intensiivinen" ;
lin retail_A = variants{} ; -- 
lin wind_V = mkWV (k53 "nostaa") "ylös" ; --UNCHK
lin lost_A = variants{} ; -- 
lin grain_N = mkWN (k48A "rakenne") ; --f52 ---ARB
lin particle_N = mkWN (k6 "partikkeli") ; --UNCHK
lin destruction_N = mkWN (compoundN "tuho" (k38 "aminen")) ; --UNCHK
lin witness_V2 = mkWV2 (k53 "todistaa") ;
lin witness_V = mkWV (k53 "todistaa") ; --UNCHK
lin pit_N = mkWN (k39 "kaivos") ; --UNCHK
lin registration_N = mkWN (compoundN "kirjo" (k38 "ittautuminen")) ; --UNCHK
lin conception_N = mkN "käsitys" ; ---ARB --mkWN (compoundN "hede" (k38 "lmöittyminen")) ;
lin steady_A = mkWA (k17 "vakaa") ; --f69
lin rival_N = mkN (lin NK {s = d12 "kilpailija"}) ;
lin steam_N = mkWN (k1 "höyry") ; --UNCHK
lin back_A = variants{} ; -- 
lin chancellor_N = mkWN (k6 "kansleri") ;
lin crash_V = mkWV (k52A "nukkua") ; --UNCHK
lin belt_N = mkWN (k39 "läimäys") ; --UNCHK
lin logic_N = mkWN (k14A "logiikka") ; --UNCHK
lin premium_N = mkWN (k3 "palkkio") ; --f122
lin confront_V2 = mkWV2 (k73A "kohdata") ; --UNCHK
lin precede_V2 = mkV2 "edeltää" partitive ; --mkWV2 (k53 "perustaa") ;
lin experimental_A = mkWA (k38 "kokeellinen") ;
lin alarm_N = mkWN (k33A "hälytin") ; --UNCHK
lin rational_A = mkA "rationaalinen" ; --WA (k38 "järjellinen") ;
lin incentive_N = mkN (lin NK {s = d33 "kannustin"}) ;
lin roughly_Adv = variants{} ; -- 
lin bench_N = mkWN (k5A "penkki") ; --UNCHK
lin wrap_V2 = mkWV2 (k62 "paketoida") ; --UNCHK
lin wrap_V = mkV "paketoitua" ; --mkWV (k62 "paketoida") ;
lin regarding_Prep = variants{} ; -- 
lin inadequate_A = mkWA (k34A "sopimaton") ; --UNCHK
lin ambition_N = mkWN (k39 "pyrkimys") ; --UNCHK
lin since_Adv = mkAdv "siitä lähtien" ;
lin fate_N = mkWN (k2 "kohtalo") ; --UNCHK
lin vendor_N = mkWN (k12 "kaupittelija") ; --UNCHK
lin stranger_N = mkN "vieras" ; --mkWN (k38 "muukalainen") ;
lin spiritual_A = mkWA (k38 "hengellinen") ; --UNCHK
lin increasing_A = variants{} ; -- 
lin anticipate_VV = mkWVV (k62 "ennakoida") ; --UNCHK
lin anticipate_VS = mkWVS (k62 "ennakoida") ;
lin anticipate_V2 = mkWV2 (k62 "ennakoida") ; --f62
lin anticipate_V = mkWV (k62 "ennakoida") ; --UNCHK
lin logical_A = mkA "looginen" ; --mkWA (k38 "järjestelmällinen") ;
lin fibre_N = mkN "kuitu" ;
lin attribute_V2 = mkV2 "nimittää" ;
lin sense_VS = mkWVS (k54A "ymmärtää") ; --UNCHK
lin sense_V2 = mkV2 "aistia" partitive ; --mkWV2 (k54A "ymmärtää") ;
lin black_N = mkWN (k10 "musta") ; --f69
lin petrol_N = mkWN (k9 "bensa") ; --UNCHK
lin maker_N = mkN "tekijä" ;
lin generous_A = mkWA (k1 "reilu") ; --UNCHK
lin allocation_N = mkWN (k39 "varaus") ; --UNCHK
lin depression_N = mkWN (compoundN "pai" (k38 "naminen")) ; --UNCHK
lin declaration_N = mkN (lin NK {s = d39 "julistus"}) ;
lin spot_VS = mkWVS (k69 "merkitä") ; --UNCHK
lin spot_V2 = mkWV2 (k69 "merkitä") ; --UNCHK
lin spot_V = mkWV (k69 "merkitä") ; --UNCHK
lin modest_A = mkA "vaatimaton" ;
lin bottom_A = mkWA (k36 "alin") ; --UNCHK
lin dividend_N = mkWN (k1A "osinko") ; --f264
lin devote_V2 = mkV2 "omistaa" ;
lin condemn_V2 = mkWV2 (k69 "tuomita") ; --UNCHK
lin integrate_V2 = mkWV2 (k53A "sisällyttää") ; --UNCHK
lin integrate_V = mkWV (k53A "sisällyttää") ; --UNCHK
lin pile_N = mkWN (k6 "reaktori") ; --UNCHK
lin identification_N = mkWN "tunnistaminen" ; --UNCHK
lin acute_A = mkWA (k38 "äkillinen") ; --UNCHK
lin barely_Adv = variants{} ; -- 
lin providing_Subj = variants{} ; -- 
lin directive_N = mkWN (k5 "direktiivi") ;
lin bet_VS = mkWVS (k73 "nojata") ; --UNCHK
lin bet_V2 = mkWV2 (k73 "nojata") ; --UNCHK
lin bet_V = mkV (mkV "lyödä") "vetoa" ; --mkWV (k73 "nojata") ;
lin modify_V2 = mkWV2 (k53A "muuttaa") ; --UNCHK
lin bare_A = mkA "paljas" ;
lin swear_VV = mkVV "vannoa" infPresPartAgr ;
lin swear_V2 = mkWV2 (k53A "luottaa") ; --UNCHK
lin swear_V = mkWV (k53A "luottaa") ; --UNCHK
lin final_N = mkWN (compoundN "loppu" (k48A "koe")) ; --UNCHK
lin accordingly_Adv = mkWAdv (k99 "asianmukaisesti") ;
lin valid_A = mkWA (k5 "validi") ; --UNCHK
lin wherever_Adv = mkWAdv (k99 "ikinä") "missä" ; --UNCHK
lin mortality_N = mkWN (k40 "kuolevaisuus") ; --UNCHK
lin medium_N = mkWN (k9 "ala") ; --UNCHK
lin silk_N = mkWN (k5A "silkki") ; --UNCHK
lin funeral_N = mkN "hautajaistilaisuus" ;
lin depending_A = variants{} ; -- 
lin cow_N = L.cow_N ;
lin correspond_V2 = mkV2 (mkV "vastata") partitive ;
lin correspond_V = mkV vOlla "kirjeenvaihdossa" ;
lin cite_V2 = mkV2 "lainata" partitive ;
lin classic_A = mkWA (k38 "klassinen") ; --UNCHK
lin inspection_N = mkWN (k2 "tarkastelu") ;
lin calculation_N = mkWN (k9A "laskenta") ; --UNCHK
lin rubbish_N = mkWN (k6 "liirumlaarum") ; --UNCHK
lin minimum_N = mkN "minimi" ;
lin hypothesis_N = mkWN (k12 "teoria") ; --UNCHK
lin youngster_N = mkWN (k38 "nuorukainen") ;
lin slope_N = mkN "luiska" ; --mkWN (k40 "kaltevuus") ;
lin patch_N = mkWN (k6 "laastari") ; --UNCHK
lin invitation_N = mkN "kutsu" ; --WN (k39 "houkutus") ;
lin ethnic_A = mkWA (k38 "etninen") ; --UNCHK
lin federation_N = mkN "valtioliitto" ;
lin duke_N = mkWN (k12 "herttua") ; --UNCHK
lin wholly_Adv = mkWAdv (k99 "tyystin") ;
lin closure_N = mkWN (compoundN "lakka" (k38 "uttaminen")) ; --UNCHK
lin dictionary_N = mkWN (k2 "sanasto") ; --UNCHK
lin withdrawal_N = mkN "pois" (mkN "vetäminen") ;
lin automatic_A = mkWA (k38 "automaattinen") ; --UNCHK
lin liable_A = mkWA (k41A "altis") ; --UNCHK
lin cry_N = mkWN (k1A "parku") ;
lin slow_V2 = mkWV2 (k53A "jarruttaa") ; --UNCHK
lin slow_V = mkV "hidastaa" ;
lin borough_N = mkN "kauppala" ; --UNCHK
lin well_A = mkWA (k99 "kunnossa") "hyvässä" ; --UNCHK
lin suspicion_N = mkN "epäilys" ; --mkWN (compoundN "epä" (k1 "luulo")) ;
lin portrait_N = mkWN (k5A "potretti") ; --UNCHK
lin local_N = mkWN (compoundN "paikallis" (k10 "juna")) ; --UNCHK
lin jew_N = mkWN (k38 "israelilainen") ; --UNCHK
lin fragment_N = mkWN (k38 "osanen") ; --UNCHK
lin revolutionary_A = mkWA (compoundA "vallan" (k38 "kumouksellinen")) ; --UNCHK
lin evaluate_V2 = mkWV2 (k67 "arvostella") ; --UNCHK
lin evaluate_V = mkWV (k67 "arvostella") ; --UNCHK
lin competitor_N = mkN "kilpailija" ;
lin sole_A = mkA "ainoa" ;
lin reliable_A = mkWA (k10 "luotettava") ;
lin weigh_V2 = mkWV2 (k69 "punnita") ; --UNCHK
lin weigh_V = mkWV (k69 "punnita") ; --UNCHK
lin medieval_A = mkWA (compoundA "keski" (k38 "aikainen")) ; --UNCHK
lin clinic_N = mkWN (k14A "klinikka") ; --UNCHK
lin shine_V2 = mkWV2 (k53A "kiillottaa") ; --UNCHK
lin shine_V = mkV (lin VK {s = c53 "loistaa"}) ;
lin knit_V2 = mkWV2 (k53 "mutristaa") ; --UNCHK
lin knit_V = mkWV (k53 "mutristaa") ; --UNCHK
lin complexity_N = mkWN (k40 "mutkikkuus") ; --UNCHK
lin remedy_N = mkWN (k39 "parannus") ; --UNCHK
lin fence_N = mkWN (k39 "aitaus") ;
lin bike_N = L.bike_N ;
lin freeze_V2 = mkWV2 (k52A "käyttäytyä") "jäätävästi" ; --UNCHK
lin freeze_V = L.freeze_V ;
lin eliminate_V2 = mkV2 (lin VK {s = c53 "poistaa"}) ;
lin interior_N = mkN "sisus" ; --mkWN (compoundN "sisäasiain" (k3 "ministeriö")) ;
lin intellectual_A = mkWA (k41A "älykäs") ; --UNCHK
lin established_A = variants{} ; -- 
lin voter_N = mkWN (k10 "äänestäjä") ; --f70
lin garage_N = mkN "auto" (mkN "talli") ;
lin era_N = mkWN (compoundN "keski" (k1 "arvo")) "ansaittujen" "juoksujen" ; --UNCHK
lin pregnant_A = mkWA (k10 "oleva") "raskaana" ; --UNCHK
lin plot_N = mkWN (k26 "juoni") ; --UNCHK
lin greet_V2 = mkWV2 (k53A "ottaa") "vastaan" ;
lin electrical_A = mkWA "sähkö-" ; --UNCHK
lin lie_N = mkWN (k48 "valhe") ; --UNCHK
lin disorder_N = mkWN (k40 "levottomuus") ; --UNCHK
lin formally_Adv = variants{} ; -- 
lin excuse_N = mkWN (compoundN "anteeksi" (k1A "pyyntö")) ; --UNCHK
lin socialist_A = mkWA (k38 "sosialistinen") ; --UNCHK
lin cancel_V2 = mkV2 "peruuttaa" ;
lin cancel_V = mkV "peruuttaa" ; --UNCHK
lin harm_N = mkN "haitta" ; --mkWN (compoundN "hai" (k38 "ttaaminen")) ;
lin excess_N = mkN (lin NK {s = d09A "liika"}) ;
lin exact_A = mkWA (k9A "tarkka") ; --f60
lin oblige_V2V = mkWV2V (k53A "pitää") "voimassa" ; --UNCHK
lin oblige_V2 = mkWV2 (k53A "pitää") "voimassa" ; --UNCHK
lin accountant_N = mkWN (k10 "valvoja") "varainhoidon" ; --UNCHK
lin mutual_A = mkWA (k38 "keskinäinen") ; --f89
lin fat_N = L.fat_N ;
lin volunteerMasc_N = variants{} ; -- 
lin laughter_N = mkWN (k1 "nauru") ; --UNCHK
lin trick_N = mkWN (k3 "illuusio") ; --UNCHK
lin load_V2 = mkV2 "lastata" ; --mkWV2 (k53A "vesittää") ;
lin load_V = mkWV (k53A "vesittää") ; --UNCHK
lin disposal_N = mkWN (compoundN "hei" (k38 "ttäminen")) "pois" ; --UNCHK
lin taxi_N = mkWN (k5 "taksi") ;
lin murmur_V2 = mkWV2 (k66 "äristä") ; --UNCHK
lin murmur_V = mkWV (k66 "äristä") ; --UNCHK
lin tonne_N = mkWN (k5 "tonni") ; --UNCHK
lin spell_V2 = mkWV2 (k53A "vuorottaa") ; --UNCHK
lin spell_V = mkWV (k53A "vuorottaa") ; --UNCHK
lin clerk_N = mkWN (k5 "konttoristi") ; --UNCHK
lin curious_A = mkWA (compoundA "tiedon" (k38 "haluinen")) ; --UNCHK
lin satisfactory_A = mkWA (k10 "tyydyttävä") ; --UNCHK
lin identical_A = mkWA (k38 "identtinen") ;
lin applicant_N = mkN (lin NK {s = d12 "hakija"}) ;
lin removal_N = mkWN (compoundN "ero" (k38 "ttaminen")) ; --UNCHK
lin processor_N = mkWN (k6 "prosessori") ; --UNCHK
lin cotton_N = mkWN (k9 "puuvilla") ;
lin reverse_V2 = mkWV2 (k56A "vaihtaa") "päinvastaiseksi" ; --UNCHK
lin reverse_V = mkV (mkV "vaihtua") "päinvastaiseksi" ; --mkWV (k56A "vaihtaa") "päinvastaiseksi" ;
lin hesitate_VV = mkWVV (k67 "aikailla") ; --UNCHK
lin hesitate_V = mkWV (k67 "aikailla") ; --UNCHK
lin professor_N = mkWN (k6 "professori") ;
lin admire_V2 = mkWV2 (k53A "kunnioittaa") ; --UNCHK
lin namely_Adv = mkWAdv (k99 "nimittäin") ;
lin electoral_A = mkA (separateN "vaaleja" (mkN "koskeva" "koskevia")) ; ---?? --WA "valitsija-" ;
lin delight_N = mkWN (k1 "ilo") ; --UNCHK
lin urgent_A = mkWA (k10 "pakottava") ; --UNCHK
lin prompt_V2V = mkWV2V (k53A "yllyttää") ; --UNCHK
lin prompt_V2 = mkWV2 (k53A "yllyttää") ;
lin mate_N = mkWN (kH1 "matti") ; --UNCHK
lin mate_2_N = variants{} ; -- 
lin mate_1_N = mkN "kumppani" ;
lin exposure_N = mkN "altistuminen" ;
lin server_N = mkWN (k33A "otin") ; --UNCHK
lin distinctive_A = mkWA (k38 "tyypillinen") ; --UNCHK
lin marginal_A = mkWA (k38 "marginaalinen") ; --UNCHK
lin structural_A = mkA "rakenteellinen" ;
lin rope_N = L.rope_N ;
lin miner_N = mkWN (compoundN "kaivos" (k38 "työläinen")) ;
lin entertainment_N = mkN "viihde" ;
lin acre_N = mkN "eekkeri" ;
lin pig_N = mkN "sika" ;
lin encouraging_A = mkWA (k10 "lupaava") ; --UNCHK
lin guarantee_N = mkWN (k17 "takuu") ; --f83
lin gear_N = mkWN (k41A "ratas") ;
lin anniversary_N = mkN "merkkipäivä" ;
lin past_Adv = mkWAdv (k99 "ohi") ; --UNCHK
lin ceremony_N = mkWN (k12 "seremonia") ; --UNCHK
lin rub_V2 = L.rub_V2 ;
lin rub_V = mkWV (k73A "hinkata") ; --UNCHK
lin monopoly_N = mkWN "Monopoly" ; --UNCHK
lin left_N = mkWN (k37 "vasen") ; --UNCHK
lin flee_V2 = mkWV2 (k73A "karata") ; --UNCHK
lin flee_V = mkWV (k73A "karata") ; --UNCHK
lin yield_V2 = mkV2 "tuottaa" ;
lin discount_N = mkN "alennus" ;
lin above_A = mkWA (compoundA "main" (k1 "ittu")) "edellä" ; --UNCHK
lin uncle_N = mkWN (k10A "setä") ; --UNCHK
lin audit_N = mkWN (k39 "tarkastus") ; --UNCHK
lin advertisement_N = mkN "mainos" ; --WN (k39 "mainostus") ;
lin explosion_N = mkWN (k39 "räjähdys") ; --UNCHK
lin contrary_A = mkWA (k38 "vastakkainen") ; --UNCHK
lin tribunal_N = mkWN (k1A "istunto") ; --UNCHK
lin swallow_V2 = mkV2 "niellä" ; --mkWV2 (k52 "uskoa") ;
lin swallow_V = mkWV (k52 "uskoa") ; --UNCHK
lin typically_Adv = variants{} ; -- 
lin fun_A = variants{} ; -- 
lin rat_N = mkWN (k10A "rotta") ; --UNCHK
lin cloth_N = mkWN (k48A "vaate") ; --UNCHK
lin cable_N = mkN "kaapeli" "kaapeleita" ;
lin interrupt_V2 = mkWV2 (k66 "katkaista") ; --UNCHK
lin interrupt_V = mkWV (k66 "katkaista") ; --UNCHK
lin crash_N = mkN "törmays" ;
lin flame_N = mkWN (k5A "liekki") ; --UNCHK
lin controversy_N = mkN "kiista" ;
lin rabbit_N = mkWN (kH1 "kani") ; --UNCHK
lin everyday_A = mkWA (compoundA "joka" (k38 "päiväinen")) ;
lin allegation_N = mkWN (k48A "väite") ;
lin strip_N = mkWN "strippaus" ; --UNCHK
lin stability_N = mkN "vakaus" ;
lin tide_N = mkN "vuoro" L.water_N ;
lin illustration_N = mkWN (k39 "kuvitus") ; --UNCHK
lin insect_N = mkWN (k14A "ötökkä") ; --UNCHK
lin correspondent_N = mkN "kirjeenvaihtaja" ; --mkWN (k10 "kirjoittaja") "kirjeiden" ;
lin devise_V2 = mkV2 "keksiä" ; --WV2 (k73A "kekata") ;
lin determined_A = variants{} ; -- 
lin brush_V2 = mkWV2 (k61A "pyyhkiä") ; --UNCHK
lin brush_V = mkWV (k61A "pyyhkiä") ;
lin adjustment_N = mkN "säätö" ;
lin controversial_A = mkWA (compoundA "kiistan" (k38 "alainen")) ;
lin organic_A = mkWA (k38 "elimellinen") ; --UNCHK
lin escape_N = mkWN (k1A "pako") ; --UNCHK
lin thoroughly_Adv = variants{} ; -- 
lin interface_N = mkWN (compoundN "liittymä" (k9A "pinta")) ; --UNCHK
lin historic_A = mkWA (k38 "historiallinen") ; --UNCHK
lin collapse_N = mkWN (k39 "romahdus") ; --f74
lin temple_N = mkWN (k6 "temppeli") ; --UNCHK
lin shade_N = mkWN (k33 "varjostin") ; --UNCHK
lin craft_N = mkWN (k1A "taito") ; --UNCHK
lin nursery_N = mkWN (compoundN "taimi" (k9 "tarha")) ; --UNCHK
lin piano_N = mkWN (k1 "piano") ;
lin desirable_A = mkWA (k10 "toivottava") ;
lin assurance_N = mkWN (k40 "varmuus") ; --UNCHK
lin jurisdiction_N = mkWN (k9A "valta") "oikeudellinen" ; --UNCHK
lin advertise_V2 = mkWV2 (k53 "julkistaa") ; --UNCHK
lin advertise_V = mkWV (k53 "julkistaa") ; --UNCHK
lin bay_N = mkWN (k4A "ruunikko") ; --UNCHK
lin specification_N = mkWN (k1A "ehto") ;
lin disability_N = mkN "kykenemättömyys" ; --mkWN (k40 "vammaisuus") ;
lin presidential_A = mkWA "presidentillinen" ;
lin arrest_N = mkWN (k99 "kiinni") "saada" ; --UNCHK
lin unexpected_A = mkWA (k34A "odottamaton") ;
lin switch_N = mkN "vaihdos" ; --WN (k39 "muutos") ;
lin penny_N = mkN "penni" ;
lin respect_V2 = mkWV2 (k53A "pitää") "arvossa" ; --UNCHK
lin celebration_N = mkWN (k40 "juhlallisuus") ; --UNCHK
lin gross_A = mkWA "kokonais-" ; --f56
lin aid_V2 = mkWV2 (k67 "olla") "avuksi" ; --UNCHK
lin aid_V = mkV vOlla "avuksi" ;
lin superb_A = mkWA (k38 "suurenmoinen") ; --UNCHK
lin process_V2 = mkWV2 (k67A "käsitellä") ; --UNCHK
lin process_V = mkWV (k67A "käsitellä") ;
lin innocent_A = mkWA (k34A "syytön") ; --UNCHK
lin leap_V2 = mkWV2 (k73A "loikata") ; --UNCHK
lin leap_V = mkWV (k73A "loikata") ; --UNCHK
lin colony_N = mkN "siirtokunta" ; --WN (compoundN "yhdys" (k10A "kunta")) ;
lin wound_N = mkWN (compoundN "haa" (k38 "voittaminen")) ;
lin hardware_N = mkWN (k1 "laitteisto") ; --UNCHK
lin satellite_N = mkWN (k5A "satelliitti") ; --UNCHK
lin float_V = L.float_V ;
lin bible_N = mkWN "raamattu" ; --UNCHK
lin statistical_A = mkWA (k38 "tilastollinen") ;
lin marked_A = mkWA "merkitty" ;
lin hire_V2V = mkWV2V (k53A "ottaa") "vuokralle" ; --UNCHK
lin hire_V2 = mkV2 (lin VK {s = c73A "palkata"}) ;
lin cathedral_N = mkWN (k5 "katedraali") ; --UNCHK
lin motive_N = mkN "motiivi" ; --WN (k48A "tarve") ;
lin correct_VS = mkWVS (k73 "korjata") ; --UNCHK
lin correct_V2 = mkWV2 (k73 "korjata") ; --UNCHK
lin correct_V = mkWV (k73 "korjata") ; --UNCHK
lin gastric_A = mkWA "vatsa-" ; --UNCHK
lin raid_N = mkN "hyökkäys" ;
lin comply_V2 = mkWV2 (k52A "taipua") ; --UNCHK
lin comply_V = mkWV (k52A "taipua") ; --UNCHK
lin accommodate_V2 = mkWV2 (k54A "soveltaa") ; --UNCHK
lin accommodate_V = mkWV (k54A "soveltaa") ; --UNCHK
lin mutter_V2 = mkWV2 (k66 "äristä") ; --UNCHK
lin mutter_V = mkWV (k66 "äristä") ; --UNCHK
lin induce_V2 = mkWV2 (k67A "päätellä") ; --UNCHK
lin trap_V2 = mkWV2 (k71 "tehdä") "liikkumattomaksi" ; --UNCHK
lin trap_V = mkWV (k71 "tehdä") "liikkumattomaksi" ; --UNCHK
lin invasion_N = mkWN (k3 "invaasio") ; --UNCHK
lin humour_N = mkWN (k6 "huumori") ; --UNCHK
lin bulk_N = mkWN (compoundN "aine" (k10 "määrä")) ; --UNCHK
lin traditionally_Adv = variants{} ; -- 
lin commission_V2V = mkWV2V (k56A "antaa") "tehtäväksi" ; --UNCHK
lin commission_V2 = mkWV2 (k56A "antaa") "tehtäväksi" ;
lin upstairs_Adv = mkWAdv "ylemmässä" "kerroksessa" ; --UNCHK
lin translate_V2 = mkV2 "kääntää" ;
lin translate_V = mkV "kääntää" ;
lin rhythm_N = mkWN (compoundN "rytmi" (k10 "menetelmä")) ; --UNCHK
lin emission_N = mkN "päästö" ; --WN (k1A "vuoto") ;
lin collective_A = mkWA "yhteis-" ; --UNCHK
lin transformation_N = mkWN (compoundN "muu" (k38 "ntaminen")) ; --UNCHK
lin battery_N = mkWN (compoundN "pahoin" (k2 "pitely")) ; --UNCHK
lin stimulus_N = mkWN (k48A "ärsyke") ; --UNCHK
lin naked_A = mkA "alaston" ;
lin white_N = mkN "valkoinen" ;
lin menu_N = mkWN (k10 "ohjelma") ; ---ARB --mkN "valikko" ; --mkN "ruokalista" ;
lin toilet_N = mkN "käymälä" ;
lin butter_N = L.butter_N ;
lin surprise_V2V = mkWV2V (k53A "yllättää") ; --UNCHK
lin surprise_V2 = mkWV2 (k53A "yllättää") ;
lin needle_N = mkWN (k9 "neula") ; --UNCHK
lin effectiveness_N = mkWN (k1 "teho") ;
lin accordance_N = mkWN (compoundN "suo" (k38 "minen")) ; --UNCHK
lin molecule_N = mkWN (k38 "hitunen") ; --UNCHK
lin fiction_N = mkWN (k39 "teos") "kaunokirjallinen" ; --UNCHK
lin learning_N = mkWN (compoundN "han" (k38 "kkiminen")) "tiedon" ; --UNCHK
lin statute_N = mkWN (kH1 "laki") ; --UNCHK
lin reluctant_A = mkWA (k34A "haluton") ;
lin overlook_V2 = mkV2 "ylenkatsoa" ;
lin junction_N = mkWN (k39 "liitos") ; --UNCHK
lin necessity_N = mkWN (k48A "tarve") ; --UNCHK
lin nearby_A = mkA "läheinen" ;
lin experienced_A = mkWA (k47 "kokenut") ; --UNCHK
lin lorry_N = mkWN (compoundN "kuorma-" (k1 "auto")) ; --UNCHK
lin exclusive_A = mkA "eksklusiivinen" ;
lin graphics_N = mkWN (k14A "grafiikka") ; --UNCHK
lin stimulate_V2 = mkWV2 (k62 "stimuloida") ; --UNCHK
lin warmth_N = mkWN (k1A "lämpö") ; --UNCHK
lin therapy_N = mkWN (k12 "terapia") ; --UNCHK
lin convenient_A = mkWA (k10 "sopiva") ;
lin cinema_N = mkWN (compoundN "elokuva" (k6 "teatteri")) ; --UNCHK
lin domain_N = mkWN (k39 "tietämys") ; --UNCHK
lin tournament_N = mkWN (k39 "turnaus") ; --UNCHK
lin doctrine_N = mkWN (k5A "oppi") ;
lin sheer_A = mkWA (k9A "silkka") ; --UNCHK
lin proposition_N = mkN "ehdotus" ; ---ARB --mkWN (k48A "hanke") ;
lin grip_N = mkWN (k48A "ote") ;
lin widow_N = mkWN (k7 "leski") ; --UNCHK
lin discrimination_N = mkWN (k9A "syrjintä") ; --UNCHK
lin bloody_Adv = mkWAdv (compoundAdv "pahuk" (k99 "sen")) ; --UNCHK
lin ruling_A = variants{} ; -- 
lin fit_N = mkWN (k10 "puuska") ; --UNCHK
lin nonetheless_Adv = variants{} ; -- 
lin myth_N = mkWN (k39 "uskomus") ; --UNCHK
lin episode_N = mkWN (k5 "episodi") ;
lin drift_V2 = mkWV2 (k52 "kinostua") ; --UNCHK
lin drift_V = mkWV (k52 "kinostua") ; --UNCHK
lin assert_VS = mkWVS (k53A "vakuuttaa") ; --UNCHK
lin assert_V2 = mkWV2 (k53A "vakuuttaa") ;
lin assert_V = mkWV (k53A "vakuuttaa") ; --UNCHK
lin terrace_N = mkWN (k5 "terassi") ; --UNCHK
lin uncertain_A = L.uncertain_A ;
lin twist_V2 = mkV2 "vääntää" ; --mkWV2 (k53A "niksauttaa") ;
lin insight_N = mkWN (k5 "aisti") "kuudes" ; --UNCHK
lin undermine_V2 = mkWV2 (k56 "kaivaa") "maata" ; --UNCHK
lin tragedy_N = mkWN (k12 "tragedia") ;
lin enforce_V2 = mkV2 "pakottaa" ;
lin criticize_V2 = mkV2 (mkV "kritisoida") partitive ;
lin criticize_V = mkWV (k61A "moittia") ;
lin march_V2 = mkWV2 (k52A "liittyä") "päittäin" ; --UNCHK
lin march_V = mkWV (k52A "liittyä") "päittäin" ; --UNCHK
lin leaflet_N = mkWN (kH1 "läppä") ; --UNCHK
lin fellow_A = variants{} ; -- 
lin object_V2 = mkWV2 (k62 "protestoida") ; --UNCHK
lin object_V = mkWV (k62 "protestoida") ;
lin pond_N = mkWN (k4A "lammikko") ; --UNCHK
lin adventure_N = mkWN (k39 "yritys") "vaarallinen" ; --UNCHK
lin diplomatic_A = mkA "diplomaattinen" ;
lin mixed_A = variants{} ; -- 
lin rebel_N = mkWN (k38 "kapinallinen") ;
lin equity_N = mkN (lin NK {s = d48A "osake"}) ;
lin literally_Adv = variants{} ; -- 
lin magnificent_A = mkWA (k38 "suurenmoinen") ; --UNCHK
lin loyalty_N = mkWN (k5A "lojaliteetti") ;
lin tremendous_A = mkWA (k26 "suuri") "suunnattoman" ; --UNCHK
lin airline_N = mkN "lento" (mkN "yhtiö" "yhtiöitä") ;
lin shore_N = mkWN (k10A "pönkkä") ; --UNCHK
lin restoration_N = mkWN (k39 "palautus") ;
lin physically_Adv = variants{} ; -- 
lin render_V2 = mkWV2 (k53A "sulattaa") ; --UNCHK
lin institutional_A = mkA "institutionaalinen" ;
lin emphasize_VS = mkWVS (k54A "tähdentää") ; --UNCHK
lin emphasize_V2 = mkWV2 (k54A "tähdentää") ; --UNCHK
lin mess_N = mkWN (k6 "kanttiini") ; --UNCHK
lin commander_N = mkWN (k10 "komentaja") ;
lin straightforward_A = mkWA (compoundA "kohti" (k10 "suora")) ; --UNCHK
lin singer_N = mkWN (k5 "vokalisti") ; --UNCHK
lin squeeze_V2 = L.squeeze_V2 ;
lin squeeze_V = mkWV (k56A "ahtaa") ; --UNCHK
lin full_time_A = mkA "täyspäiväinen" ;
lin breed_V2 = mkWV2 (k52A "lisääntyä") ; --UNCHK
lin breed_V = mkWV (k52A "lisääntyä") ; --UNCHK
lin successor_N = mkWN (k10 "seuraaja") ;
lin triumph_N = mkWN (k39 "menestys") ; --UNCHK
lin heading_N = mkWN (k10 "perä") ; --UNCHK
lin mathematics_N = mkN "matematiikka" ; ---!! WN (kH1 "matikka") ;
lin laugh_N = mkWN (k1 "kasku") ; --UNCHK
lin clue_N = mkWN (k48 "vihje") ; --UNCHK
lin still_A = mkWA "asetelma-" ; --UNCHK
lin ease_N = mkWN (k1A "lepo") ; --UNCHK
lin specially_Adv = variants{} ; -- 
lin biological_A = mkWA (k38 "biologinen") ; --UNCHK
lin forgive_V2 = mkV2 (mkV (mkV "antaa") "anteeksi") allative ;
lin forgive_V = mkWV (k56A "antaa") "anteeksi" ; --UNCHK
lin trustee_N = mkWN (k32 "jäsen") "johtokunnan" ; --UNCHK
lin photo_N = mkN "valokuva" ; --WN (k1 "foto") ;
lin fraction_N = mkWN (compoundN "murto-" (k10 "osa")) ; --UNCHK
lin chase_V2 = mkV2 (mkV (mkV "ajaa") "takaa") partitive ; --mkWV2 (k54A "kaivertaa") ;
lin chase_V = mkWV (k54A "kaivertaa") ; --UNCHK
lin whereby_Adv = variants{} ; -- 
lin mud_N = mkWN (k10A "loka") ; --UNCHK
lin pensioner_N = mkWN (k38 "eläkeläinen") ; --UNCHK
lin functional_A = mkWA (k38 "toiminnallinen") ; --UNCHK
lin copy_V2 = mkWV2 (k73 "kopsata") ; --UNCHK
lin copy_V = mkV "kopioida" ;
lin strictly_Adv = variants{} ; -- 
lin desperately_Adv = variants{} ; -- 
lin await_V2 = mkV2 "varautua" illative ;
lin coverage_N = mkN "kattavuus" ;
lin wildlife_N = variants{} ; -- 
lin indicator_N = mkWN (k6 "mittari") ; --f57
lin lightly_Adv = variants{} ; -- 
lin hierarchy_N = mkWN (k12 "hierarkia") ; --UNCHK
lin evolve_V2 = mkWV2 (k52A "kehittyä") ; --UNCHK
lin evolve_V = mkWV (k52A "kehittyä") ;
lin mechanical_A = mkWA (k38 "mekaaninen") ;
lin expert_A = mkWA (k41A "taidokas") ; --UNCHK
lin creditor_N = mkWN (k10 "velkoja") ; --f140
lin capitalist_N = mkWN (k5 "kapitalisti") ; --UNCHK
lin essence_N = mkWN (k1 "tuoksu") ; --UNCHK
lin compose_V2 = mkWV2 (k61A "laatia") ;
lin compose_V = mkWV (k61A "laatia") ; --UNCHK
lin mentally_Adv = variants{} ; -- 
lin gaze_N = mkWN (k48 "katse") ; --UNCHK
lin seminar_N = mkWN (k5 "seminaari") ;
lin target_V2V = mkWV2V (k73A "suunnata") ; --UNCHK
lin target_V2 = mkWV2 (k73A "suunnata") ; --f53
lin label_V3 = variants{}; -- mkWV2 (k73 "leimata") ; --UNCHK
lin label_V2 = mkWV2 (k73 "leimata") ; --UNCHK
lin label_V = mkWV (k73 "leimata") ; --UNCHK
lin fig_N = mkWN (k3 "kaavio") ; --UNCHK
lin continent_N = mkWN "Manner-Eurooppa" ; --UNCHK
lin chap_N = variants{} ; -- 
lin flexibility_N = mkWN (k40 "joustavuus") ; --UNCHK
lin verse_N = mkWN (k5 "riimi") ; --UNCHK
lin minute_A = mkWA (compoundA "yks" (k38 "ityiskohtainen")) ; --UNCHK
lin whisky_N = mkWN (k5 "viski") ; --UNCHK
lin equivalent_A = mkWA (k38 "samanlainen") ; --UNCHK
lin recruit_V2 = mkWV2 (k53A "ottaa") "sotaväkeen" ; --UNCHK
lin recruit_V = mkWV (k53A "ottaa") "sotaväkeen" ; --UNCHK
lin echo_V2 = mkWV2 (k67A "jäljitellä") ; --UNCHK
lin echo_V = mkWV (k67A "jäljitellä") ; --UNCHK
lin unfair_A = mkA "epäreilu" ;
lin launch_N = mkWN (k2 "laukaisu") ; --UNCHK
lin cupboard_N = mkWN (k2 "komero") ; --UNCHK
lin bush_N = mkWN (k10 "puska") ; --UNCHK
lin shortage_N = mkWN (k48 "vaje") ;
lin prominent_A = mkWA (k10 "huomattava") ; --UNCHK
lin merger_N = mkWN (k3 "fuusio") ; --f154
lin command_V2 = mkWV2 (k58 "käskeä") ; --UNCHK
lin command_V = mkWV (k58 "käskeä") ; --UNCHK
lin subtle_A = mkA "hienovarainen" ; --mkWA (k38 "haitallinen") ;
lin capital_A = mkA (mkN "pää" (mkN "asiallinen")) ; --mkWA (k6 "versaali") ;
lin gang_N = mkWN (compoundN "työkalu" (k9A "kerta")) ; --UNCHK
lin fish_V2 = mkWV2 (k53 "kalastaa") ; --UNCHK
lin fish_V = mkWV (k53 "kalastaa") ; --UNCHK
lin unhappy_A = mkWA (k34A "onneton") ; --UNCHK
lin lifetime_N = mkN "elin" (mkN "aika") ;
lin elite_N = mkWN (k1 "parhaimmisto") ; --UNCHK
lin refusal_N = mkWN "kieltäytyminen" ; --UNCHK
lin finish_N = mkWN (k39 "lopetus") ; --UNCHK
lin aggressive_A = mkA "aggressiivinen" ; --f86
lin superior_A = mkWA (k16A "ylempi") ; --UNCHK
lin landing_N = mkWN (k1 "lasku") ; --UNCHK
lin exchange_V2 = mkWV2 (k56A "vaihtaa") ; --UNCHK
lin debate_V2 = mkWV2 (k67A "väitellä") ; --UNCHK
lin debate_V = mkWV (k67A "väitellä") ; --UNCHK
lin educate_V2 = mkWV2 (k53A "opettaa") ; --UNCHK
lin separation_N = mkWN (compoundN "ero" (k38 "ttaminen")) ; --UNCHK
lin productivity_N = mkWN (k40 "tuottavuus") ; --UNCHK
lin initiate_V2 = mkV2 "aloittaa" ;
lin probability_N = mkWN (compoundN "toden" (k40 "näköisyys")) ;
lin virus_N = mkWN (k39 "virus") ;
lin reporterMasc_N = variants{} ; -- 
lin fool_N = mkN "typerys" ; --mkWN (k6 "tomppeli") ;
lin pop_V2 = mkWV2 (k53A "poksahtaa") ; --UNCHK
lin capitalism_N = mkWN (k5 "kapitalismi") ;
lin painful_A = mkWA (k10 "rasittava") ; --UNCHK
lin correctly_Adv = variants{} ; -- 
lin complex_N = mkWN (k5 "kompleksi") ;
lin rumour_N = mkWN (k1 "juoru") ; --UNCHK
lin imperial_A = mkWA (k38 "keisarillinen") ; --UNCHK
lin justification_N = mkWN (k39 "oikeutus") ; --UNCHK
lin availability_N = mkWN (k5A "saanti") ; --UNCHK
lin spectacular_A = mkWA (k38 "keskeinen") ; --UNCHK
lin remain_N = variants{} ; -- 
lin ocean_N = mkWN (compoundN "valta" (k24 "meri")) ; --UNCHK
lin cliff_N = mkWN (k48A "jyrkänne") ; --UNCHK
lin sociology_N = mkWN (k12 "sosiologia") ; --UNCHK
lin sadly_Adv = variants{} ; -- 
lin missile_N = mkWN (k39 "ohjus") ;
lin situate_V2 = mkWV2 (k53A "asettaa") ; --UNCHK
lin artificial_A = mkA "keinotekoinen" ;
lin apartment_N = L.apartment_N ;
lin provoke_V2 = mkWV2 (k62 "stimuloida") ; --UNCHK
lin oral_A = mkA "suullinen" ; --mkWA (k38 "oraalinen") ;
lin maximum_N = mkWN (k1 "taso") "paras" ; --UNCHK
lin angel_N = variants{} ; -- 
lin spare_A = mkA "ylijäänyt" ;
lin shame_N = mkN "häpeä" ; --mkWN (k10 "ikävä") ;
lin intelligent_A = mkA "älykäs" ; --mkWA (k38 "älyllinen") ;
lin discretion_N = mkWN (compoundN "harkinta" (k1A "kyky")) ;
lin businessman_N = mkN "liike" L.man_N ;
lin explicit_A = mkWA (k15 "selkeä") ;
lin book_V2 = mkV2 "varata" ; --mkWV2 (k53 "järjestää") ;
lin uniform_N = mkWN (k1 "univormu") ;
lin push_N = mkWN (k2 "tönäisy") ; --UNCHK
lin counter_N = mkWN (compoundN "vasta" (k1 "isku")) ; --UNCHK
lin subject_A = mkWA (k41A "altis") ; --UNCHK
lin objective_A = mkWA (k34A "puolueeton") ; --UNCHK
lin hungry_A = mkWA (k38 "nälkäinen") ; --UNCHK
lin clothing_N = mkWN (k1A "puku") ; --UNCHK
lin ride_N = mkWN (k1 "ajo") ; --UNCHK
lin romantic_A = mkWA (k38 "romanttinen") ;
lin attendance_N = mkWN (compoundN "läsnä" (k1A "olo")) ;
lin part_time_A = mkA "osa-aikainen" ;
lin trace_N = mkWN (k9 "aisa") ; --UNCHK
lin backing_N = mkWN (k39 "kannatus") ; --UNCHK
lin sensation_N = mkWN (k1A "kyky") ; --UNCHK
lin carrier_N = mkWN (k10 "kantaja") ; --f135
lin interest_V2 = mkWV2 (k53 "kiinnostaa") ; --f65
lin interest_V = mkWV (k53 "kiinnostaa") ; --UNCHK
lin classification_N = mkWN (k2 "lajittelu") ; --UNCHK
lin classic_N = mkWN (k4A "klassikko") ; --UNCHK
lin beg_V2 = mkWV2 (k54A "pyytää") ; --UNCHK
lin beg_V = mkWV (k54A "pyytää") ; --UNCHK
lin appendix_N = mkWN (k48A "lisäke") "sekaalinen" ; --UNCHK
lin doorway_N = mkWN (compoundN "ovi" (k1A "aukko")) ; --UNCHK
lin density_N = mkWN (k40 "tiiviys") ; --UNCHK
lin working_class_A = mkA "työväenluokkainen" ;
lin legislative_A = mkWA (k38 "lainsäädännöllinen") ;
lin hint_N = mkWN (k5A "vinkki") ;
lin shower_N = mkWN (k1 "suihku") ; --UNCHK
lin current_N = mkWN (k9A "virta") ; --UNCHK
lin succession_N = mkN "sarja" ; --mkWN (compoundN "per" (k38 "iminen")) ;
lin nasty_A = mkWA (k9 "paha") ; --UNCHK
lin duration_N = mkWN (k40 "pituus") ; --UNCHK
lin desert_N = mkWN (k4A "aavikko") ; --UNCHK
lin receipt_N = mkN (lin NK {s = d05A "kuitti"}) ;
lin native_A = mkA (mkN "synty" (mkN "peräinen")) ;
lin chapel_N = mkWN (compoundN "jumalan" (k39 "palvelus")) ; --UNCHK
lin amazing_A = mkWA (k10 "vaikuttava") ; --UNCHK
lin hopefully_Adv = variants{} ; -- 
lin fleet_N = mkWN (k2 "laivasto") ;
lin comparable_A = mkWA (k10 "oleva") "verrattavissa" ; --f60
lin oxygen_N = mkWN (k7A "happi") ; --UNCHK
lin installation_N = mkWN (k39 "asennus") ; --UNCHK
lin developer_N = mkN "kehittäjä" ;
lin disadvantage_N = mkWN (k10 "asema") "epäedullinen" ; --UNCHK
lin recipe_N = mkWN (k5 "resepti") ;
lin crystal_N = mkWN (compoundN "kellon" (k5 "lasi")) ; --UNCHK
lin modification_N = mkWN (compoundN "muu" (k38 "ttaminen")) ; --UNCHK
lin schedule_V2V = mkWV2V (k67A "suunnitella") ;
lin schedule_V2 = mkV2 "määrätä" ;
lin schedule_V = mkWV (k67A "suunnitella") ;
lin midnight_N = mkWN "keskiyö" ; --UNCHK
lin successive_A = mkWA (k38 "perättäinen") ; --UNCHK
lin formerly_Adv = variants{} ; -- 
lin loud_A = mkWA (k10 "kova") ;
lin value_V2 = mkV2 "arvostaa" ; --f104
lin value_V = mkWV (k62 "arvioida") ; --UNCHK
lin physics_N = mkWN (k14A "fysiikka") ;
lin truck_N = mkN "rekka" ;
lin stroke_N = mkN "veto" ; ---ARB --mkN "infarkti"
lin kiss_N = mkWN (k2 "hipaisu") ; --UNCHK
lin envelope_N = mkWN (k39 "päällys") ; --UNCHK
lin speculation_N = mkN "spekulaatio" ;
lin canal_N = mkWN (k10 "kanava") ; --UNCHK
lin unionist_N = mkWN (k32 "jäsen") "ammattiliiton" ; --UNCHK
lin directory_N = mkN "hakemisto" ; --mkWN (k2 "luettelo") ;
lin receiver_N = mkWN (compoundN "vastaan" (k33A "otin")) ;
lin isolation_N = mkWN (k39 "eristys") ; --UNCHK
lin fade_V2 = mkWV2 (k52 "virua") ; --UNCHK
lin fade_V = mkWV (k52 "virua") ; --UNCHK
lin chemistry_N = mkWN (k12 "kemia") ;
lin unnecessary_A = mkWA (k10 "turha") ; --UNCHK
lin hit_N = mkWN (k10 "osuma") ;
lin defenderMasc_N = variants{} ; -- 
lin stance_N = mkWN (k1A "asento") ; --UNCHK
lin sin_N = mkWN (k5A "synti") ;
lin realistic_A = mkWA (k38 "realistinen") ; --UNCHK
lin socialist_N = mkWN (k5 "sosialisti") ; --UNCHK
lin subsidy_N = mkWN (k38 "tukiainen") ; --f52
lin content_A = mkWA (k38 "tyytyväinen") ; --UNCHK
lin toy_N = mkN "lelu" ;
lin darling_N = mkWN (compoundN "Darling-" (k7A "joki")) ; --UNCHK
lin decent_A = mkWA (k38 "säädyllinen") ; --UNCHK
lin liberty_N = mkWN (k40 "vapaus") ; --UNCHK
lin forever_Adv = mkAdv "ikuisesti" ; --WAdv (k99 "alati") ;
lin skirt_N = mkWN (k48 "hame") ; --UNCHK
lin coordinate_V2 = mkV2 "koordinoida" ; --WV2 (k53 "järjestää") ;
lin coordinate_V = mkWV (k53 "järjestää") ; --UNCHK
lin tactic_N = mkWN (k5 "manööveri") ; --UNCHK
lin influential_A = mkWA (compoundA "vaikutus" (k38 "valtainen")) ; --UNCHK
lin import_V2 = mkV2 "tuoda" ; --WV2 (k76A "tietää") ;
lin accent_N = mkWN (k5A "aksentti") ; --UNCHK
lin compound_N = mkWN "kampong" ; --UNCHK
lin bastard_N = mkWN (compoundN "seka" (k3 "sikiö")) ; --UNCHK
lin ingredient_N = mkWN (k39 "aines") ;
lin dull_A = L.dull_A ;
lin cater_V = mkWV (k53A "toimittaa") "ruokaa" ; --UNCHK
lin scholar_N = mkWN (k12 "opiskelija") ; --UNCHK
lin faint_A = mkWA (k1A "säikky") ; --UNCHK
lin ghost_N = mkWN (k1 "haamu") ;
lin sculpture_N = mkWN (compoundN "kuvanveisto" (k48A "taide")) ; --UNCHK
lin ridiculous_A = mkWA (k1 "hupsu") ; --UNCHK
lin diagnosis_N = mkWN (k5 "diagnoosi") ; --UNCHK
lin delegate_N = mkWN (k10 "edustaja") ;
lin neat_A = mkWA (k10 "taitava") ; --UNCHK
lin kit_N = mkWN (k1A "pentu") ; --UNCHK
lin lion_N = mkN "leijona" ; --mkWN (k41A "kuningas") "eläinten" ;
lin dialogue_N = mkWN (k5 "dialogi") ; --UNCHK
lin repair_V2 = mkV2 "korjata" ;
lin repair_V = mkWV (k53 "virkistää") ; --UNCHK
lin tray_N = mkWN (k9A "kelkka") ; --UNCHK
lin fantasy_N = mkWN (k12 "fantasia") ; --UNCHK
lin leave_N = mkN "virkavapaa" ; --WN (k2 "hyvästely") ---ARB
lin export_V2 = mkWV2 (k64 "viedä") ; --UNCHK
lin export_V = mkWV (k64 "viedä") ; --UNCHK
lin forth_Adv = mkWAdv (k99 "esiin") ;
lin lamp_N = L.lamp_N ;
lin allege_VS = mkVS (mkV "väittää") ;
lin allege_V2 = mkV2 "väittää" ;
lin pavement_N = mkWN (k39 "kiveys") ; --UNCHK
lin brand_N = mkN "tavaramerkki" ;
lin constable_N = mkWN (k6 "konstaapeli") ; --UNCHK
lin compromise_N = mkWN (k5 "kompromissi") ; --f56
lin flag_N = mkN "lippu" ;
lin filter_N = mkWN (k33A "suodatin") ;
lin reign_N = mkWN (k9A "valta") ; --UNCHK
lin execute_V2 = mkV2 "suorittaa" ; --WV2 (k53A "teloittaa") ; ----ARB
lin pity_N = mkWN (k5 "sääli") ; --UNCHK
lin merit_N = mkWN (k3 "ansio") ; --UNCHK
lin diagram_N = mkWN (k3 "kaavio") ; --UNCHK
lin wool_N = mkN "villa" ; --WN (kH1 "turkki") ;
lin organism_N = mkWN (k1A "olento") ; --UNCHK
lin elegant_A = mkA "elegantti" | mkWA (k41A "tyylikäs") ;
lin red_N = mkWN (k40 "punaisuus") ; --UNCHK
lin undertaking_N = mkN "hanke" ; --mkWN (k19 "työ") ;
lin lesser_A = mkWA "vähäpätöisempi" ; --UNCHK
lin reach_N = mkWN "venyttäminen" ; --UNCHK
lin marvellous_A = mkWA (k38 "ihmeellinen") ; --UNCHK
lin improved_A = variants{} ; -- 
lin locally_Adv = variants{} ; -- 
lin entity_N = mkN "olio" ;
lin rape_N = mkN "raiskaus" | mkWN (k38 "väkisinmakaaminen") ;
lin secure_A = mkWA (k34A "huoleton") ; --UNCHK
lin descend_V2 = mkWV2 (k52A "laskeutua") ; --UNCHK
lin descend_V = mkWV (k52A "laskeutua") ; --UNCHK
lin backwards_Adv = mkWAdv (k99 "taemmaksi") ; --UNCHK
lin peer_V = mkWV (k67 "tähyillä") ; --UNCHK
lin excuse_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin genetic_A = mkA "perinnöllinen" ; ---ARB mkWA (k38 "geneettinen") ;
lin fold_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin fold_V = mkV (mkV "kaatua") "kokoon" ; --mkWV (k53A "sekoittaa") ;
lin portfolio_N = mkWN (k1A "salkku") ; --f219
lin consensus_N = mkWN (k39 "konsensus") ;
lin thesis_N = mkWN (k10 "tutkielma") "tieteellinen" ; --UNCHK
lin shop_V = mkV (mkV "käydä") "ostoksilla" ; --mkWV (k62 "vasikoida") ;
lin nest_N = mkWN (k48A "pesäke") ; --UNCHK
lin frown_V = mkWV (k67 "mulkoilla") ; --UNCHK
lin builder_N = mkWN (k10 "rakentaja") ; --UNCHK
lin administer_V2 = mkV2 "hallinnoida" partitive ; --mkWV2 (k56A "jakaa") ;
lin administer_V = mkWV (k56A "jakaa") ; --UNCHK
lin tip_V2 = mkWV2 (k73 "sysätä") ; --UNCHK
lin tip_V = mkWV (k73 "sysätä") ; --UNCHK
lin lung_N = mkWN (k1 "keuhko") ; --UNCHK
lin delegation_N = mkWN "valtuuttaminen" ; --UNCHK
lin outside_N = mkN "ulko" (mkN "puoli") ; --mkWN (compoundN "ulko" (k9A "pinta")) ;
lin heating_N = mkWN (k33A "lämmitin") ; --UNCHK
lin like_Subj = variants{} ; -- 
lin instinct_N = mkWN (k1A "kyky") "luontainen" ; --UNCHK
lin teenager_N = mkWN (k38 "nuorukainen") ; --UNCHK
lin lonely_A = mkWA (k38 "yksinäinen") ; --UNCHK
lin residence_N = mkN "koti" (mkN "paikka") ; --mkWN (k2 "oleskelu") ;
lin radiation_N = mkWN (compoundN "säde" (k1A "hoito")) ; --UNCHK
lin extract_V2 = mkWV2 (k53A "vetää") "ulos" ; --UNCHK
lin concession_N = mkWN (compoundN "toimi" (k10A "lupa")) ; --UNCHK
lin autonomy_N = mkWN (k40 "vapaus") ; --UNCHK
lin norm_N = mkWN (k6 "standardi") ;
lin musicianMasc_N = variants{} ; -- 
lin graduate_N = mkWN (compoundN "mitta" (k5 "lasi")) ; --UNCHK
lin glory_N = mkWN (k40 "upeus") ;
lin bear_N = mkN "karhu" ;
lin persist_V = mkWV (k52 "pysyä") "järkähtämättömänä" ; --UNCHK
lin rescue_V2 = mkWV2 (k53 "pelastaa") ;
lin equip_V2 = mkV2 "varustaa" ;
lin partial_A = mkWA (k38 "puolueellinen") ; ----ARB osittainen
lin officially_Adv = variants{} ; -- 
lin capability_N = mkN (lin NK {s = d01A "kyky"}) ;
lin worry_N = mkWN (k9 "vaiva") ; --UNCHK
lin liberation_N = mkWN (k39 "vapautus") ; --UNCHK
lin hunt_V2 = L.hunt_V2 ;
lin hunt_V = mkWV (k53 "pyydystää") ; --UNCHK
lin daily_Adv = mkWAdv (k99 "päivittäin") ; --UNCHK
lin heel_N = mkWN (k1A "korko") ; --UNCHK
lin contract_V2V = mkWV2V (k63 "saada") ; --UNCHK
lin contract_V2 = mkV2 (mkV (mkV "ottaa") "palvelukseen") ; --mkWV2 (k63 "saada") ;
lin contract_V = mkWV (k63 "saada") ; --UNCHK
lin update_V2 = mkWV2 (k53 "ajantasaistaa") ; --UNCHK
lin assign_V2V = mkWV2V (k73 "varata") ; --UNCHK
lin assign_V2 = mkWV2 (k73 "varata") ; --UNCHK
lin spring_V2 = mkV2 "laukaista" ; --mkWV2 (k63 "saada") ;
lin spring_V = mkV "syöksyä" ; --mkWV (k63 "saada") ;
lin single_N = mkWN (compoundN "ykköspesä" (k5A "lyönti")) ; --UNCHK
lin commons_N = mkWN (k1A "sääty") "kolmas" ; --UNCHK
lin weekly_A = mkWA (k38 "viikoittainen") ;
lin stretch_N = mkN "pätkä" ;
lin pregnancy_N = mkWN (k9A "raskausaika") ; --UNCHK
lin happily_Adv = variants{} ; -- 
lin spectrum_N = mkWN (k1 "kirjo") ; --UNCHK
lin interfere_V = mkWV (k69 "häiritä") ; --UNCHK
lin suicide_N = mkWN (compoundN "itse" (k10 "murha")) ; --UNCHK
lin panic_N = mkWN (k5A "paniikki") ; --f54
lin invent_V2 = mkV2 "keksiä" ;
lin invent_V = mkV "keksiä" ;
lin intensive_A = mkA "tehokas" ;
lin damp_A = mkWA (k15 "kostea") ; --UNCHK
lin simultaneously_Adv = variants{} ; -- 
lin giant_N = mkWN (k38 "jättiläinen") ; --f78
lin casual_A = mkA "epäformaali" ;
lin sphere_N = mkWN (k1 "pallo") ; --UNCHK
lin precious_A = mkA "arvokas" ;
lin sword_N = mkWN (k9A "kalpa") ; --UNCHK
lin envisage_V2 = mkWV2 (k71 "nähdä") "mielessään" ; --UNCHK
lin bean_N = mkWN (k7A "päälaki") ; --UNCHK
lin time_V2 = mkWV2 (k53A "ajoittaa") ;
lin crazy_A = mkWA (k47 "höpsähtänyt") ; --UNCHK
lin changing_A = variants{} ; -- 
lin primary_N = mkN "esi" (mkN "vaali") ;
lin concede_VS = mkVS (mkV "tunnustaa") ; --f56
lin concede_V2 = mkWV2 (k54A "myöntää") ; --UNCHK
lin concede_V = mkV (mkV "antaa") "myöten" ; --mkWV (k54A "myöntää") ;
lin besides_Adv = mkWAdv (k99 "toisekseen") ; --UNCHK
lin unite_V2 = mkWV2 (k53 "yhdistää") ; --UNCHK
lin unite_V = mkV "yhdistyä" ; --mkWV (k53 "yhdistää") ;
lin severely_Adv = variants{} ; -- 
lin separately_Adv = variants{} ; -- 
lin instruct_V2 = mkWV2 (k52 "neuvoa") ;
lin insert_V2 = mkWV2 (k56A "laittaa") ;
lin go_N = mkWN (compoundN "go-" (k5 "peli")) ; --UNCHK
lin exhibit_V2 = mkWV2 (k53A "marssittaa") ; --UNCHK
lin brave_A = mkWA (k38 "urhoollinen") ; --UNCHK
lin tutor_N = mkWN (k6 "tutor") ; --UNCHK
lin tune_N = mkN "sävel" ;
lin debut_N = mkWN (k38 "ensiesiintyminen") ; --UNCHK
lin debut_2_N = variants{} ; -- 
lin debut_1_N = mkN "debyytti" ;
lin continued_A = variants{} ; -- 
lin bid_V2 = mkWV2 (k74A "vedota") ; --UNCHK
lin bid_V = mkV "tarjota" ;
lin incidence_N = mkWN (compoundN "kohta" (k38 "aminen")) ; --UNCHK
lin downstairs_Adv = mkWAdv (k99 "alhaalla") ; --UNCHK
lin cafe_N = mkWN (k12 "kuppila") ; --UNCHK
lin regret_VS = mkWVS (k67 "olla") "pahoillaan" ; --UNCHK
lin regret_V2 = mkV2 "katua" partitive ; --mkWV2 vOlla "pahoillaan" ;
lin killer_N = mkN "tappaja" ; --mkWN (compoundN "miekka" (k41 "valas")) ;
lin delicate_A = mkWA (k41 "hauras") ;
lin subsidiary_N = mkWN (compoundN "tytär" (k3 "yhtiö")) ; --f223
lin gender_N = mkWN (k40 "sukupuolisuus") ; --UNCHK
lin entertain_V2 = mkWV2 (k69 "harkita") ; --UNCHK
lin cling_V = mkWV (k52A "roikkua") ; --UNCHK
lin vertical_A = mkWA (k38 "vertikaalinen") ; --UNCHK
lin fetch_V2 = mkWV2 (k53A "kuljettaa") ; --UNCHK
lin strip_V2 = mkWV2 (k52A "riisuuntua") ; --UNCHK
lin strip_V = mkWV (k52A "riisuuntua") ; --UNCHK
lin plead_VS = mkWVS (k74A "vedota") ; --UNCHK
lin plead_V2 = mkWV2 (k74A "vedota") ; --UNCHK
lin plead_V = mkWV (k74A "vedota") ;
lin duck_N = mkWN (k10 "sorsa") ; --UNCHK
lin breed_N = mkN "rotu" ; --WN (k5A "tyyppi") ;
lin assistant_A = variants{} ; -- 
lin pint_N = mkWN "0,47" "l" ; --UNCHK
lin abolish_V2 = mkWV2 (k53A "lopettaa") ; --UNCHK
lin translation_N = mkN "käännös" ;
lin princess_N = mkWN (k13 "prinsessa") ; --UNCHK
lin line_V2 = mkWV2 (k53 "päällystää") ; --UNCHK
lin line_V = mkWV (k53 "päällystää") ; --UNCHK
lin excessive_A = mkWA (k34A "kohtuuton") ; --UNCHK
lin digital_A = mkWA (k38 "digitaalinen") ;
lin steep_A = mkWA (k10A "jyrkkä") ;
lin jet_N = mkN "suihkukone" ; ---ARB mkWN (k1 "suihku") ;
lin hey_Interj = mkInterj "hei" ;
lin grave_N = mkWN (k9A "hauta") ; --UNCHK
lin exceptional_A = mkWA (k38 "erikoinen") ; --UNCHK
lin boost_V2 = mkV2 "vahvistaa" partitive ;
lin random_A = mkWA (k38 "satunnainen") ; --UNCHK
lin correlation_N = mkWN (k40 "vastaavuus") "tilastollinen" ; --UNCHK
lin outline_N = mkWN (k39 "luonnos") ; --UNCHK
lin intervene_V2V = mkWV2V (k67 "tulla") "väliin" ; --UNCHK
lin intervene_V = mkWV (k67 "tulla") "väliin" ;
lin packet_N = mkWN (compoundN "posti" (k48 "vene")) ; --UNCHK
lin motivation_N = mkWN (k48A "tarve") ; --UNCHK
lin safely_Adv = variants{} ; -- 
lin harsh_A = mkWA (k15 "karhea") ; --UNCHK
lin spell_N = mkWN (k1 "loitsu") ; --UNCHK
lin spread_N = mkN "levinneisyys" ;
lin draw_N = mkN "tasapeli" ; ---ARB ; arvonta
lin concrete_A = mkWA (k38 "konkreettinen") ; --UNCHK
lin complicated_A = variants{} ; -- 
lin alleged_A = variants{} ; -- 
lin redundancy_N = mkWN (k40 "liiallisuus") ; --UNCHK
lin progressive_A = mkWA (compoundA "edistys" (k38 "mielinen")) ;
lin intensity_N = mkN "intensiteetti" ;
lin crack_N = mkWN (compoundN "rikko" (k38 "minen")) ; --UNCHK
lin fly_N = mkWN (k1 "pallo") "korkea" ; --UNCHK
lin fancy_V2 = mkWV2 (k62 "visioida") ; --UNCHK
lin alternatively_Adv = variants{} ; -- 
lin waiting_A = variants{} ; -- 
lin scandal_N = mkWN (k1A "törky") ; --f71
lin resemble_V2 = mkWV2 (k53A "muistuttaa") ; --UNCHK
lin parameter_N = mkWN (k5 "parametri") ; --UNCHK
lin fierce_A = mkA "raju" ; --WA (k10 "kova") ;
lin tropical_A = mkWA (k38 "trooppinen") ; --UNCHK
lin colour_V2A = mkWV2A (k52A "värjääntyä") ; --UNCHK
lin colour_V2 = mkWV2 (k52A "värjääntyä") ; --UNCHK
lin colour_V = mkWV (k52A "värjääntyä") ; --UNCHK
lin engagement_N = mkWN (k39 "kiinnitys") ; --UNCHK
lin contest_N = mkN (lin NK {s = d02 "kilpailu"}) ;
lin edit_V2 = mkWV2 (k62 "editoida") ; --UNCHK
lin courage_N = mkWN (k40 "urhoollisuus") ; --UNCHK
lin hip_N = mkWN (k10A "lonkka") ; --UNCHK
lin delighted_A = variants{} ; -- 
lin sponsor_V2 = mkWV2 (k54A "kustantaa") ; --UNCHK
lin carer_N = variants{} ; -- 
lin crack_V2 = mkV2 "murtaa" ; --WV2 "krakkautua" ;
lin substantially_Adv = variants{} ; -- 
lin occupational_A = mkWA "ammatti-" ; --UNCHK
lin trainer_N = mkN "valmentaja" ;
lin remainder_N = mkWN (compoundN "jäännös" (k9 "pala")) ; --UNCHK
lin related_A = variants{} ; -- 
lin inherit_V2 = mkWV2 (k61 "periä") ; --also mkV2 "periä" partitive ;
lin inherit_V = mkWV (k61 "periä") ; --UNCHK
lin resume_V2 = mkWV2 (k53 "käynnistää") "uudelleen" ;
lin resume_V = mkWV (k53 "käynnistää") "uudelleen" ; --UNCHK
lin assignment_N = mkWN (compoundN "nimi" (k38 "ttäminen")) ; --UNCHK
lin conceal_V2 = mkWV2 (k53A "peittää") ;
lin disclose_VS = mkWVS (k52A "kertoa") ; --UNCHK
lin disclose_V2 = mkV2 (lin VK {s = c53 "paljastaa"}) ;
lin disclose_V = mkWV (k52A "kertoa") ;
lin exclusively_Adv = variants{} ; -- 
lin working_N = mkWN (k9A "louhinta") ; --UNCHK
lin mild_A = mkWA (k1 "vaisu") ; --UNCHK
lin chronic_A = mkWA (k38 "krooninen") ; --UNCHK
lin splendid_A = mkWA (k10 "mahtava") ; --UNCHK
lin function_V = mkWV (k61 "toimia") ;
lin riderMasc_N = variants{} ; -- 
lin clay_N = mkWN (k1A "raato") ; --UNCHK
lin firstly_Adv = variants{} ; -- 
lin conceive_V2 = mkWV2 (k67 "tulla") "raskaaksi" ; --UNCHK
lin conceive_V = mkWV (k67 "tulla") "raskaaksi" ; --UNCHK
lin politically_Adv = variants{} ; -- 
lin terminal_N = mkWN (k10 "asema") ; --UNCHK
lin accuracy_N = mkWN (k40 "totuus") ; --UNCHK
lin coup_N = mkWN (k39 "menestys") ; ---ARB --mkN "vallankaappaus" ;
lin ambulance_N = mkWN (k5 "ambulanssi") ; --UNCHK
lin living_N = mkWN (k1 "elo") ; --UNCHK
lin offenderMasc_N = variants{} ; -- 
lin similarity_N = mkWN (k40 "samanlaisuus") ;
lin orchestra_N = mkN "orkesteri" ; --mkWN (k1A "permanto") ;
lin brush_N = mkWN (compoundN "yhteen" (k1A "otto")) ; --UNCHK
lin systematic_A = mkWA (k38 "systemaattinen") ; --UNCHK
lin striker_N = mkWN (k6 "iskuri") ; --UNCHK
lin guard_V2 = mkV2 "suojata" partitive ;
lin guard_V = mkWV (k73 "suojata") ; --UNCHK
lin casualty_N = mkWN (k3 "tappio") ; --UNCHK
lin steadily_Adv = variants{} ; -- 
lin painter_N = mkWN (k10 "puuma") ; --UNCHK
lin opt_VV = mkWVV (k53A "pitää") "parempana" ; --UNCHK
lin opt_V = mkV (mkV "antaa") "äänensä" ; --mkWV (k53A "pitää") "parempana" ; --assuming a complement beginning with "for", that's why chose this verb in Finnish.
lin handsome_A = mkWA (k15 "upea") ;
lin banking_N = mkN "pankkitoiminta" ;
lin sensitivity_N = mkWN (k40 "herkkyys") ; --UNCHK
lin navy_N = mkWN (compoundN "laivaston" (k38 "sininen")) ; --UNCHK
lin fascinating_A = mkWA (k10 "hurmaava") ; --UNCHK
lin disappointment_N = mkWN (compoundN "aihe" (k38 "uttaminen")) "pettymyksen" ; --UNCHK
lin auditor_N = mkWN (compoundN "tilin" (k10 "tarkastaja")) ; --UNCHK
lin hostility_N = mkWN (k39 "hyökkäys") ; --UNCHK
lin spending_N = mkWN (compoundN "rahan" (k1A "käyttö")) ; --UNCHK
lin scarcely_Adv = variants{} ; -- 
lin compulsory_A = variants{} ; -- 
lin photographer_N = mkWN (k10 "kuvaaja") ; --UNCHK
lin ok_Interj = mkInterj "okei" ;
lin neighbourhood_N = mkWN (k1 "naapurusto") ; --UNCHK
lin ideological_A = mkWA (k38 "ideologinen") ; --UNCHK
lin wide_Adv = mkWAdv (k99 "paljon") ; --UNCHK
lin pardon_N = mkWN (compoundN "anteeksi" (k1A "anto")) ; --UNCHK
lin double_N = mkWN (k5A "lyönti") "kahden" "pesän" ; --UNCHK
lin criticize_V2 = mkV2 (mkV "kritisoida") partitive ;
lin criticize_V = mkWV (k61A "moittia") ;
lin supervision_N = mkWN (k39 "ohjaus") ;
lin guilt_N = mkWN (k51 "omatunto") "syyllinen" ; --UNCHK
lin deck_N = mkN (lin NK {s = d28 "kansi"}) ;
lin payable_A = mkWA "maksettava" ;
lin execution_N = mkWN (k39 "toteutus") ;
lin suite_N = mkWN (k5A "sviitti") ; ---ARB ; seurue ; sarja
lin elected_A = mkA "valittu" ;
lin solely_Adv = variants{} ; -- 
lin moral_N = mkWN (k1 "läksy") ; --UNCHK
lin collector_N = mkWN (k5 "kollektori") ; --UNCHK
lin questionnaire_N = mkWN (compoundN "kysely" (k48A "kaavake")) ; --UNCHK
lin flavour_N = mkN "maku" ; --WN (k1A "maku") "vahva" ;
lin couple_V2 = mkWV2 (k53 "yhdistää") ;
lin couple_V = mkWV (k53 "yhdistää") ; --UNCHK
lin faculty_N = mkN "henkilö" (mkN "kunta") ; --mkWN (k6 "moduuli") ;
lin tour_V2 = mkWV2 (k67A "kierrellä") ; --UNCHK
lin tour_V = mkWV (k67A "kierrellä") ; --UNCHK
lin basket_N = mkWN (k5 "kori") ; --f55
lin mention_N = mkWN (compoundN "kunnia" (k9A "maininta")) ; --UNCHK
lin kick_N = mkWN (kH1 "potku") ; --UNCHK
lin horizon_N = mkWN (k10 "näkymä") ; --UNCHK
lin drain_V2 = mkV2 "kuluttaa" partitive ; --mkWV2 (k64 "viedä") "voimat" ;
lin drain_V = mkWV (k64 "viedä") "voimat" ; --UNCHK
lin happiness_N = mkN "onnellisuus" ; --UNCHK
lin fighter_N = mkWN (k10 "hävittäjä") ; --UNCHK
lin estimated_A = variants{} ; -- 
lin copper_N = mkN (lin NK {s = d06 "kupari"}) ;
lin legend_N = mkWN (k48 "seloste") ; --UNCHK
lin relevance_N = mkWN (k5 "relevanssi") ; --UNCHK
lin decorate_V2 = mkWV2 (k53 "somistaa") ; --UNCHK
lin continental_A = mkA "mannermainen" ;
lin ship_V2 = mkWV2 (k53A "toimittaa") ;
lin ship_V = mkWV (k53A "toimittaa") ; --UNCHK
lin operational_A = mkWA "operaatio-" ; --UNCHK
lin incur_V2 = mkV2 (lin VK {s = c53A "aiheuttaa"}) ;
lin parallel_A = mkWA (compoundA "saman" (k38 "suuntainen")) ; --UNCHK
lin divorce_N = mkWN (k1 "ero") ; --UNCHK
lin opposed_A = variants{} ; -- 
lin equilibrium_N = mkWN (compoundN "tasapaino" (k5 "aisti")) ; --UNCHK
lin trader_N = mkN (lin NK {s = d41 "kauppias"}) ;
lin ton_N = mkWN (k5 "tonni") ; --f151
lin can_N = mkWN (k5A "tölkki") ; --UNCHK
lin juice_N = mkWN (k48 "neste") ; --UNCHK
lin forum_N = mkWN (k39 "kokous") ; --UNCHK
lin spin_V2 = mkWV2 (k53A "pitkittää") ; --UNCHK
lin spin_V = mkWV (k53A "pitkittää") ; --UNCHK
lin research_V2 = mkWV2 (k58A "hakea") ; --UNCHK
lin research_V = mkWV (k58A "hakea") ; --UNCHK
lin hostile_A = mkA "vihamielinen" ;
lin consistently_Adv = variants{} ; -- 
lin technological_A = mkWA (k38 "teknologinen") ; --UNCHK
lin nightmare_N = mkWN (k38 "painajainen") ;
lin medal_N = mkWN (k1A "palkinto") ; --UNCHK
lin diamond_N = mkWN (compoundN "sisä" (k10A "kenttä")) ; --UNCHK
lin speed_V2 = mkWV2 (k73 "lisätä") "vauhtia" ; --UNCHK
lin speed_V = mkWV (k73 "lisätä") "vauhtia" ; --UNCHK
lin peaceful_A = mkWA (k38 "rauhallinen") ;
lin accounting_A = variants{} ; -- 
lin scatter_V2 = mkWV2 (k53A "hajottaa") ; --UNCHK
lin scatter_V = mkWV (k53A "hajottaa") ; --UNCHK
lin monster_N = mkWN (compoundN "epä" (k3 "sikiö")) ; --UNCHK
lin horrible_A = mkA "kamala" ;
lin nonsense_N = mkWN (k40 "turhuus") ; --UNCHK
lin chaos_N = mkWN (k39 "kaaos") ; --UNCHK
lin accessible_A = mkWA "päästävä" ; --UNCHK
lin humanity_N = mkWN (k13 "maailma") ; --UNCHK
lin frustration_N = mkWN (k38 "tekeminen") "tyhjäksi" ; --UNCHK
lin chin_N = mkWN (k9A "leuka") ; --UNCHK
lin bureau_N = mkN "virasto" ; ---ARB mkWN (k5A "piironki") ;
lin advocate_VS = mkWVS (k53A "kannattaa") ; --UNCHK
lin advocate_V2 = mkWV2 (k53A "kannattaa") ; --UNCHK
lin polytechnic_N = mkWN (k2 "opisto") "polytekninen" ; --UNCHK
lin inhabitant_N = mkWN (k5A "asukki") ; --UNCHK
lin evil_A = mkWA (k9 "paha") ;
lin slave_N = mkWN (k10 "orja") ; --UNCHK
lin reservation_N = mkWN (k39 "varaus") ; --UNCHK
lin slam_V2 = mkWV2 (k53A "läimäyttää") ; --UNCHK
lin slam_V = mkWV (k53A "läimäyttää") ; --UNCHK
lin handle_N = mkWN (k33A "otin") ; --UNCHK
lin provincial_A = mkWA (k38 "provinsiaalinen") ; --UNCHK
lin fishing_N = mkWN (k39 "kalastus") ; --UNCHK
lin facilitate_V2 = mkV2 "helpottaa" partitive ; --mkWV2 (k53A "lievittää") ;
lin yield_N = mkN "tuotos" ;
lin elbow_N = mkWN (compoundN "kyynär" (k18 "pää")) ; --UNCHK
lin bye_Interj = mkInterj "hei sitten" ;
lin warm_V2 = mkWV2 (k53A "lämmittää") ; --UNCHK
lin warm_V = mkWV (k53A "lämmittää") ; --UNCHK
lin sleeve_N = mkWN (k9 "hiha") ; --UNCHK
lin exploration_N = mkWN (k39 "tutkimus") ;
lin creep_V = mkV "madella" ;
lin adjacent_A = mkWA (k38 "viereinen") ;
lin theft_N = mkWN (k2 "varastelu") ; --UNCHK
lin round_V2 = mkWV2 (k52A "tukevoitua") ; --UNCHK
lin round_V = mkWV (k52A "tukevoitua") ; --UNCHK
lin grace_N = mkWN (k40 "arvokkuus") ;
lin predecessor_N = mkWN (k10 "edeltäjä") ;
lin supermarket_N = mkWN (compoundN "valinta" (k12 "myymälä")) ; --UNCHK
lin smart_A = mkWA (k10 "terävä") ; --UNCHK
lin sergeant_N = mkWN (compoundN "yli" (k6 "konstaapeli")) ; --UNCHK
lin regulate_V2 = mkV2 (mkV "säädellä") partitive ;
lin clash_N = mkN "yhteen" (mkN "törmäys") ; --mkWN (k1A "suukopu") ;
lin assemble_V2 = mkWV2 (k61 "kursia") ; --UNCHK
lin assemble_V = mkV "kokoontua" ; --mkWV (k61 "kursia") ;
lin arrow_N = mkWN (k26 "nuoli") ; --UNCHK
lin nowadays_Adv = mkWAdv (k99 "nykyään") ; --UNCHK
lin giant_A = variants{} ; -- 
lin waiting_N = variants{} ; -- 
lin tap_N = mkN "tappi" ; ---ARB (koputus ; salakuuntelulaite ; hana)
lin shit_N = mkN "paska" ;
lin sandwich_N = mkWN (compoundN "voi" (k10A "leipä")) ; --UNCHK
lin vanish_V = mkWV (k52A "haihtua") ; --UNCHK
lin commerce_N = mkN "kauppa" ; --mkWN (k40 "kaupallisuus") ;
lin pursuit_N = mkWN (kH1 "jahti") ; --UNCHK
lin post_war_A = variants{} ; -- 
lin will_V2 = mkWV2 (k75 "haluta") ; --UNCHK
lin will_V = mkWV (k75 "haluta") ;
lin waste_A = mkWA (k5 "villi") ; --UNCHK
lin collar_N = mkWN (k99 "kiinni") "saada" ; --UNCHK
lin socialism_N = mkWN (k5 "sosialismi") ; --UNCHK
lin skill_V = variants{} ; -- 
lin rice_N = mkWN (kH1 "riisi") ; --UNCHK
lin exclusion_N = mkWN (k39 "karkotus") ; --UNCHK
lin upwards_Adv = mkWAdv (compoundAdv "ylös" (k99 "päin")) ; --UNCHK
lin transmission_N = mkWN (k39 "lähetys") ;
lin instantly_Adv = variants{} ; -- 
lin forthcoming_A = mkWA (k99 "saatavilla") ; --UNCHK
lin appointed_A = variants{} ; -- 
lin geographical_A = mkWA (compoundA "maan" (k38 "tieteellinen")) ; --UNCHK
lin fist_N = mkWN (k5A "nyrkki") ; --UNCHK
lin abstract_A = mkWA (k38 "käsitteellinen") ; --UNCHK
lin embrace_V2 = mkWV2 (k52A "liittyä") "jhk" ; --UNCHK
lin embrace_V = mkWV (k52A "liittyä") "jhk" ; --UNCHK
lin dynamic_A = mkWA (k38 "dynaaminen") ;
lin drawer_N = mkWN (k4A "laatikko") ; --UNCHK
lin dismissal_N = mkWN (k39 "vapautus") ; --UNCHK
lin magic_N = mkWN (k3 "illuusio") ; --UNCHK
lin endless_A = mkWA (k34A "päättymätön") ;
lin definite_A = mkA (lin AK {s = d09 "varma"}) ;
lin broadly_Adv = variants{} ; -- 
lin affection_N = mkWN (k1A "lämpö") ; --UNCHK
lin dawn_N = mkWN (k39 "sarastus") ; --UNCHK
lin principal_N = mkN "rehtori" ;
lin bloke_N = mkWN (k5 "kundi") ; --UNCHK
lin trap_N = mkWN (k9 "ansa") ;
lin communist_A = mkA "kommunistinen" ;
lin competence_N = mkWN (k40 "pätevyys") ; --UNCHK
lin complicate_V2 = mkV2 "monimutkaistaa" partitive ;
lin neutral_A = mkWA (k6 "neutraali") ;
lin fortunately_Adv = variants{} ; -- 
lin commonwealth_N = mkWN (k33 "elin") "poliittinen" ; --UNCHK
lin breakdown_N = mkWN (k3 "häiriö") ; --UNCHK
lin combined_A = variants{} ; -- 
lin candle_N = mkWN (k12 "kynttilä") ; --UNCHK
lin venue_N = mkWN (compoundN "oikeus" (k9A "paikka")) ; --UNCHK
lin supper_N = mkWN (k38 "illallinen") ; --UNCHK
lin analyst_N = mkN (lin NK {s = d04A "analyytikko"}) ;
lin vague_A = mkWA (k34A "määrittelemätön") ; --UNCHK
lin publicly_Adv = variants{} ; -- 
lin marine_A = mkWA (k38 "merellinen") ; --UNCHK
lin fair_Adv = mkWAdv (k99 "tasapuolisesti") ; --UNCHK
lin pause_N = mkWN (k1A "tauko") ; --UNCHK
lin notable_A = mkA "huomattava" ;
lin freely_Adv = variants{} ; -- 
lin counterpart_N = mkN "vastine" ;
lin lively_A = mkWA (k41A "vilkas") ; --UNCHK
lin script_N = mkWN (k39 "kirjoitus") ; --UNCHK
lin sue_V2V = mkWV2V (k56 "haastaa") ; --UNCHK
lin sue_V2 = mkWV2 (k56 "haastaa") ; --UNCHK
lin sue_V = mkWV (k56 "haastaa") ; --UNCHK
lin legitimate_A = mkWA (k10 "pätevä") ; --UNCHK
lin geography_N = mkWN (compoundN "maan" (k1A "tieto")) ;
lin reproduce_V2 = mkWV2 (k56 "jatkaa") "sukua" ; --UNCHK
lin reproduce_V = mkWV (k56 "jatkaa") "sukua" ; --UNCHK
lin moving_A = variants{} ; -- 
lin lamb_N = mkWN (k10 "vuona") ; --UNCHK
lin gay_A = mkWA (k38 "aurinkoinen") ; --UNCHK
lin contemplate_VS = mkWVS (k61 "tuumia") ; --UNCHK
lin contemplate_V2 = mkWV2 (k61 "tuumia") ; --UNCHK
lin contemplate_V = mkWV (k61 "tuumia") ; --UNCHK
lin terror_N = mkWN (k6 "terrori") ; --UNCHK
lin stable_N = mkWN (k5 "talli") ; --UNCHK
lin founder_N = mkN "perustaja" ;
lin utility_N = mkWN (k48A "hyödyke") ;
lin signal_VS = mkWVS (k73A "viitata") ; --UNCHK
lin signal_V2 = mkWV2 (k73A "viitata") ; --UNCHK
lin shelter_N = mkWN (k10 "turva") ; --UNCHK
lin poster_N = mkN "juliste" ; ---ARB --mkWN (compoundN "kyyti" (k38 "hevonen")) ;
lin hitherto_Adv = mkWAdv (k99 "vielä") ; --UNCHK
lin mature_A = mkA "kypsä" ; --mkWA (compoundA "lentoky" (k38 "kyinen")) ;
lin cooking_N = mkWN (compoundN "ruuan" (k39 "valmistus")) ; --UNCHK
lin head_A = mkA "johtava" ;
lin wealthy_A = mkA "varakas" ;
lin fucking_A = mkA "vittumainen" ; ----
lin confess_VS = mkWVS (k54A "myöntää") ; --UNCHK
lin confess_V2 = mkWV2 (k54A "myöntää") ; --UNCHK
lin confess_V = mkWV (k54A "myöntää") ; --UNCHK
lin age_V = mkWV (k52A "vanhentua") ; --UNCHK
lin miracle_N = mkWN (k48 "ihme") ; --UNCHK
lin magic_A = mkWA (k10 "lumoava") ; --UNCHK
lin jaw_N = mkWN (compoundN "kiinnitys" (k9A "leuka")) ; --UNCHK
lin pan_N = mkWN (compoundN "Pan-" (k1A "suku")) ; --UNCHK
lin coloured_A = variants{} ; -- 
lin tent_N = mkWN (k9A "teltta") ; --UNCHK
lin telephone_V2 = mkWV2 (k53A "soittaa") ; --UNCHK
lin telephone_V = mkWV (k53A "soittaa") ; --UNCHK
lin reduced_A = variants{} ; -- 
lin tumour_N = mkWN (k33 "kasvain") ; --UNCHK
lin super_A = mkWA (compoundA "huippu" (k1 "hieno")) ; --UNCHK
lin funding_N = variants{} ; -- 
lin dump_V2 = mkV2 (mkV (mkV "heittää") "pois") ; --WV2 (k73 "tyrmätä") ;
lin dump_V = mkWV (k73 "tyrmätä") ; --UNCHK
lin stitch_N = mkWN (k1 "pisto") ; --UNCHK
lin shared_A = variants{} ; -- 
lin ladder_N = mkN "arvojärjestys" ; ---ARB
lin keeper_N = mkWN (k6 "pehtori") ; --UNCHK
lin endorse_V2 = mkWV2 (k52 "hyväksyä") ; --UNCHK
lin invariably_Adv = variants{} ; -- 
lin smash_V2 = mkWV2 (k71 "tehdä") "loppu" ; --UNCHK
lin smash_V = mkWV (k71 "tehdä") "loppu" ; --UNCHK
lin shield_N = mkN "kilpi" ;
lin heat_V2 = mkWV2 (k54A "kuumentaa") ; --UNCHK
lin heat_V = mkWV (k54A "kuumentaa") ; --UNCHK
lin surgeon_N = mkWN (k6 "haavuri") ; --UNCHK
lin centre_V2 = mkWV2 (k53 "kohdistaa") "huomionsa" ; --UNCHK
lin centre_V = mkWV (k53 "kohdistaa") "huomionsa" ; --UNCHK
lin orange_N = mkWN (k5 "oranssi") ; --UNCHK
lin orange_2_N = variants{} ; -- 
lin orange_1_N = mkN "appelsiini" ;
lin explode_V = mkWV (k53 "päästää") "valloilleen" ; --UNCHK
lin comedy_N = mkN "komedia" ;
lin classify_V2 = mkWV2 (k53A "ryhmittää") ; --UNCHK
lin artistic_A = mkA "taiteellinen" ;
lin ruler_N = mkWN (k33A "viivoitin") ; --UNCHK
lin biscuit_N = mkWN (kH1 "keksi") ; --UNCHK
lin workstation_N = mkWN (compoundN "työ" (k10 "asema")) ; --UNCHK
lin prey_N = mkWN (k41 "saalis") ; --UNCHK
lin manual_N = mkWN (compoundN "sulkeis" (k39 "harjoitus")) ; --UNCHK
lin cure_N = variants{} ; -- 
lin cure_2_N = variants{} ; -- 
lin cure_1_N = mkN "hoito" ;
lin overall_N = mkN "haalari" ; ---
lin tighten_V2 = mkWV2 (k53 "kiristää") ;
lin tighten_V = mkWV (k53 "kiristää") ; --UNCHK
lin tax_V2 = mkV2 "verottaa" partitive ;
lin pope_N = mkWN (k5 "paavi") "Rooman" ; --UNCHK
lin manufacturing_A = variants{} ; -- 
lin adult_A = mkWA (kH1 "iso") ; --UNCHK
lin rush_N = mkWN (k1 "syöksy") ; --UNCHK
lin blanket_N = mkWN (k1A "peitto") ;
lin republican_N = mkWN "Republican" "River" ; --UNCHK
lin referendum_N = mkWN (compoundN "kansan" (k39 "äänestys")) ; --UNCHK
lin palm_N = mkWN (k12 "päkiä") ; --UNCHK
lin nearby_Adv = mkWAdv (k99 "lähellä") ; --UNCHK
lin mix_N = mkWN (k39 "seos") ; --UNCHK
lin devil_N = mkWN (k48 "perkele") ; --UNCHK
lin adoption_N = mkWN (compoundN "oma" (k38 "ksuminen")) ; ---ARB --mkN "adoptio" ;
lin workforce_N = variants{} ; -- 
lin segment_N = mkN "segmentti" ;
lin regardless_Adv = mkWAdv (k99 "huolimatta") "siitä" ; --UNCHK
lin contractor_N = mkN "osapuoli" ;
lin portion_N = mkWN (k40 "osuus") ; --f80
lin differently_Adv = variants{} ; -- 
lin deposit_V2 = mkWV2 (k56A "laittaa") ; --UNCHK
lin cook_N = mkWN (k10 "keittäjä") ; --UNCHK
lin prediction_N = mkWN (k39 "povaus") ; --UNCHK
lin oven_N = mkWN (k5 "uuni") ; --UNCHK
lin matrix_N = mkWN (compoundN "valu" (k5A "muotti")) ; --UNCHK
lin liver_N = L.liver_N ;
lin fraud_N = mkN (lin NK {s = d39 "petos"}) ;
lin beam_N = mkWN (k5 "puomi") ; --UNCHK
lin signature_N = mkN "alle" (mkN "kirjoitus") ; --mkWN (k39 "kosketus") ;
lin limb_N = mkWN (k9 "raaja") ; --UNCHK
lin verdict_N = mkWN (k39 "päätös") ; --UNCHK
lin dramatically_Adv = mkWAdv (k99 "dramaattisesti") ; --UNCHK
lin container_N = mkWN (k3 "säiliö") ; --UNCHK
lin aunt_N = mkWN (k5A "täti") ; --UNCHK
lin dock_N = mkWN (compoundN "töpö" (k10A "häntä")) ; --UNCHK
lin submission_N = mkWN (compoundN "ali" (k38 "stuminen")) ; --UNCHK
lin arm_V2 = mkWV2 (k54A "rakentaa") "linnakkeita" ; --UNCHK
lin arm_V = mkWV (k54A "rakentaa") "linnakkeita" ; --UNCHK
lin odd_N = variants{} ; -- 
lin certainty_N = mkWN (k1A "juttu") "varma" ; --UNCHK
lin boring_A = mkA "ikävystyttävä" ;
lin electron_N = mkWN (k5 "elektroni") ; --UNCHK
lin drum_N = mkWN (compoundN "rumpu" (k9 "kala")) ; --UNCHK
lin wisdom_N = mkWN (k40 "viisaus") ; --UNCHK
lin antibody_N = mkWN (compoundN "vasta-" (k48 "aine")) ; --UNCHK
lin unlike_A = mkWA (k38 "erilainen") ; --UNCHK
lin terrorist_N = mkWN (k5 "terroristi") ; --UNCHK
lin post_V2 = mkV2 "postittaa" ;
lin post_V = mkWV (k53A "ilmoittaa") ; --f58
lin circulation_N = mkWN (k2 "jakelu") ;
lin alteration_N = mkWN (compoundN "muu" (k38 "ttaminen")) ; --UNCHK
lin fluid_N = mkWN (k39 "petos") ; --UNCHK
lin ambitious_A = mkWA (compoundA "kunnianhi" (k38 "moinen")) ;
lin socially_Adv = variants{} ; -- 
lin riot_N = mkN "mellakka" ;
lin petition_N = mkWN (k5 "adressi") ;
lin fox_N = mkWN (k1A "kettu") ; --UNCHK
lin recruitment_N = mkWN (k5A "rekrytointi") ; --UNCHK
lin well_known_A = mkA "tunnettu" ;
lin top_V2 = mkWV2 (k54A "huipentaa") ;
lin service_V2 = mkWV2 (k54A "huoltaa") ; --UNCHK
lin flood_V2 = mkWV2 (k53A "täyttää") ;
lin flood_V = mkWV (k53A "peittää") ; --UNCHK
lin taste_V2 = mkWV2 (k58A "kokea") ; --UNCHK
lin taste_V = mkWV (k58A "kokea") ; --UNCHK
lin memorial_N = mkWN (k5A "monumentti") ; --UNCHK
lin helicopter_N = mkWN (k6 "kopteri") ; --UNCHK
lin correspondence_N = mkWN (k40 "vastaavuus") ; --UNCHK
lin beef_N = mkWN (compoundN "liha" (k9 "karja")) ; --UNCHK
lin overall_Adv = variants{} ; -- 
lin lighting_N = mkWN (k39 "sytytys") ; --UNCHK
lin harbour_N = L.harbour_N ;
lin empirical_A = mkWA (k38 "kokeellinen") ; --UNCHK
lin shallow_A = mkWA (k10 "matala") ; --UNCHK
lin seal_V2 = mkWV2 (k62 "sinetöidä") ; --UNCHK
lin seal_V = mkWV (k62 "sinetöidä") ; --UNCHK
lin decrease_V2 = mkWV2 (k58 "laskea") ;
lin decrease_V = mkWV (k58 "laskea") ; --UNCHK
lin constituent_N = mkWN (k5A "komponentti") ; --UNCHK
lin exam_N = mkWN (k5A "tentti") ; --UNCHK
lin toe_N = mkWN (k7A "kärki") ; --UNCHK
lin reward_V2 = mkWV2 (k56 "maksaa") ; --UNCHK
lin thrust_V2 = mkWV2 (k53A "tyrkyttää") ; --UNCHK
lin thrust_V = mkWV (k53A "tyrkyttää") ; --UNCHK
lin bureaucracy_N = mkWN (k12 "byrokratia") ; --UNCHK
lin wrist_N = mkWN (k48A "ranne") ; --UNCHK
lin nut_N = mkWN (k6 "mutteri") ; --UNCHK
lin plain_N = mkWN (k14A "silmukka") ; --UNCHK
lin magnetic_A = mkA "magneettinen" ;
lin evil_N = mkWN (k40 "häijyys") ; --UNCHK
lin widen_V2 = mkWV2 (k52A "leventyä") ; --UNCHK
lin hazard_N = mkWN (k48 "este") ; --UNCHK
lin dispose_V2 = mkWV2 (k53A "kelpuuttaa") ; --UNCHK
lin dispose_V = mkWV (k53A "kelpuuttaa") ; --UNCHK
lin dealing_N = mkWN (k39 "toimitus") ;
lin absent_A = mkWA (compoundA "poissa" (k10 "oleva")) ; --UNCHK
lin reassure_V2S = mkWV2S (k67A "tyynnytellä") ; --UNCHK
lin reassure_V2 = mkV2 "tyynnytellä" partitive ;
lin model_V2 = mkWV2 (k73A "muokata") ; --UNCHK
lin model_V = mkWV (k73A "muokata") ; --UNCHK
lin inn_N = mkWN (k6 "kievari") ; --UNCHK
lin initial_N = mkWN (compoundN "alku" (k33 "kirjain")) ; --UNCHK
lin suspension_N = mkN "erottaminen" ; --f60
lin respondent_N = mkWN (k10 "vastaaja") ; --UNCHK
lin over_N = mkWN (compoundN "puolen" (k1A "vaihto")) ; --UNCHK
lin naval_A = mkWA (compoundA "merivoim" (k32A "ien")) ; --UNCHK
lin monthly_A = mkA "kuukausittainen" ;
lin log_N = mkWN (k5 "loki") ; --UNCHK
lin advisory_A = mkWA (k10 "neuvoa-antava") ; --UNCHK
lin fitness_N = mkWN (k40 "soveltuvuus") ;
lin blank_A = mkWA (k34A "ilmeetön") ;
lin indirect_A = mkWA (compoundA "epä" (k10 "suora")) ; --UNCHK
lin tile_N = mkWN (k9A "laatta") ;
lin rally_N = mkN "ralli" ;
lin economist_N = mkWN (k5 "ekonomisti") ; --f211
lin vein_N = mkWN (compoundN "siipi" (k26 "suoni")) ; --UNCHK
lin strand_N = mkWN (k9 "nauha") ; --UNCHK
lin disturbance_N = mkWN (k9A "häirintä") ; --UNCHK
lin stuff_V2 = mkWV2 (k53A "täyttää") ; --UNCHK
lin seldom_Adv = mkWAdv (k99 "harvoin") ;
lin coming_A = variants{} ; -- 
lin cab_N = mkWN (k5 "pirssi") ; --UNCHK
lin grandfather_N = mkWN (kH1 "vaari") ; --UNCHK
lin flash_V = mkWV (k53A "välähtää") ;
lin destination_N = mkWN (k48A "tavoite") ;
lin actively_Adv = variants{} ; -- 
lin regiment_N = mkWN (k5A "rykmentti") ; --UNCHK
lin closed_A = variants{} ; -- 
lin boom_N = mkN "buumi" ; --WN (k5 "puomi") ; ----ARB
lin handful_N = mkWN (k38 "kourallinen") ;
lin remarkably_Adv = variants{} ; -- 
lin encouragement_N = mkN "rohkaisu" ;
lin awkward_A = mkWA (k2 "kömpelö") ; --UNCHK
lin required_A = variants{} ; -- 
lin flood_N = mkWN (k10 "tulva") ;
lin defect_N = mkWN (kH1 "vika") ; --UNCHK
lin surplus_N = mkN "ylimäärä" ;
lin champagne_N = mkWN (k5 "kuohuviini") ; --UNCHK
lin liquid_N = mkN "likvidi" ; ---ARB --mkN "neste" ; --mkWN (k39 "petos") ;
lin shed_V2 = mkWV2 (k64 "luoda") "nahkansa" ; --UNCHK
lin welcome_N = mkWN (compoundN "vastaan" (k1A "otto")) ; --UNCHK
lin rejection_N = mkWN "hylkääminen" ;
lin discipline_V2 = mkWV2 (k54A "ojentaa") ; --UNCHK
lin halt_V2 = mkV2 "pysäyttää" ;
lin halt_V = mkWV (k53A "tyrehdyttää") ; --UNCHK
lin electronics_N = mkWN (k9A "elektroniikka") ;
lin administratorMasc_N = variants{} ; -- 
lin sentence_V2 = mkWV2 (k69 "tuomita") ; --UNCHK
lin sentence_V = mkWV (k69 "tuomita") ; --UNCHK
lin ill_Adv = mkWAdv (k99 "huonosti") ; --UNCHK
lin contradiction_N = mkWN (compoundN "kii" (k38 "stäminen")) ; --UNCHK
lin nail_N = mkWN (k9 "naula") ; --UNCHK
lin senior_N = mkN "seniori" ; --mkWN (k2 "henkilö") "vanhempi" ;
lin lacking_A = variants{} ; -- 
lin colonial_A = mkWA "siirtomaa-" ; --UNCHK
lin primitive_A = mkA "primitiivinen" ;
lin whoever_NP = variants{} ; -- 
lin lap_N = mkWN (k39 "lipitys") ; --UNCHK
lin commodity_N = mkN "hyödyke" ;
lin planned_A = variants{} ; -- 
lin intellectual_N = mkN "älykkö" ;
lin imprisonment_N = mkWN (k40 "vankeus") ;
lin coincide_V = mkV (mkV "sattua") "samaan aikaan" ;
lin sympathetic_A = mkWA (k38 "sympaattinen") ; --UNCHK
lin atom_N = mkWN (k38 "hitunen") ; --UNCHK
lin tempt_V2V = mkWV2V (k67A "vietellä") ; --UNCHK
lin tempt_V2 = mkWV2 (k67A "vietellä") ; --UNCHK
lin sanction_N = mkWN (kH1 "laki") ; --UNCHK
lin praise_V2 = mkWV2 (k53 "ylistää") ; --UNCHK
lin favourable_A = mkWA (k10 "suotuisa") ; --UNCHK
lin dissolve_V2 = mkWV2 (k53A "hajottaa") ; --UNCHK
lin dissolve_V = mkWV (k53A "hajottaa") ; --UNCHK
lin tightly_Adv = variants{} ; -- 
lin surrounding_N = variants{} ; -- 
lin soup_N = mkWN (k25 "liemi") ; --UNCHK
lin encounter_N = mkWN (compoundN "kohta" (k38 "aminen")) ; --UNCHK
lin abortion_N = mkWN (k5A "abortti") ;
lin grasp_V2 = mkWV2 (k74 "tajuta") ; --UNCHK
lin grasp_V = mkWV (k74 "tajuta") ; --UNCHK
lin custody_N = mkWN "huoltajuus" ; --UNCHK
lin composer_N = mkWN (k10 "säveltäjä") ;
lin charm_N = mkWN (k5A "amuletti") ; --UNCHK
lin short_term_A = mkA "lyhytaikainen" ;
lin metropolitan_A = mkWA "suurkaupunkilainen" ;
lin waist_N = mkWN (k39 "kavennus") ; --UNCHK
lin equality_N = mkWN (compoundN "yhtä" (k40 "suuruus")) ; --UNCHK
lin tribute_N = mkWN (compoundN "suojelu" (k9 "raha")) ; --UNCHK
lin bearing_N = mkWN (kH1 "laakeri") ; --UNCHK
lin auction_N = mkWN (compoundN "huuto" (k9A "kauppa")) ;
lin standing_N = mkWN (compoundN "sei" (k38 "sominen")) ; --UNCHK
lin manufacture_N = mkWN (k1A "tuotanto") ; --UNCHK
lin horn_N = L.horn_N ;
lin barn_N = mkWN (k9A "aitta") ; --UNCHK
lin mayor_N = mkWN (k6 "pormestari") ;
lin emperor_N = mkWN (compoundN "häive" (k38 "perhonen")) ; --UNCHK
lin rescue_N = mkWN (k39 "vapahdus") ; --UNCHK
lin integrated_A = variants{} ; -- 
lin conscience_N = mkWN (k51 "omatunto") ; --UNCHK
lin commence_V2 = mkV2 "aloittaa" ;
lin commence_V = variants{}; -- mkV2 "aloittaa" ;
lin grandmother_N = mkWN (k5 "mummi") ; --UNCHK
lin discharge_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin discharge_V = mkWV (k53A "vapauttaa") ; --UNCHK
lin profound_A = mkWA (compoundA "syvä" (k38 "henkinen")) ; --UNCHK
lin takeover_N = mkWN (k39 "valtaus") ; --f363
lin nationalist_N = mkWN (k5 "nationalisti") ; --UNCHK
lin effect_V2 = mkV2 "toteuttaa" ;
lin dolphin_N = mkWN (k6 "delfiini") ; --UNCHK
lin fortnight_N = mkWN "kaksi" "viikkoa" ; --UNCHK
lin elephant_N = mkWN (k1 "norsu") ;
lin seal_N = mkWN (k48A "hylje") ; --UNCHK
lin spoil_V2 = mkWV2 (k73 "pilata") ; --UNCHK
lin spoil_V = mkWV (k73 "pilata") ; --UNCHK
lin plea_N = mkWN (k39 "vetoomus") ;
lin forwards_Adv = mkWAdv (k99 "edelleen") ; --UNCHK
lin breeze_N = mkN "tuulen" (mkN "vire") ;
lin prevention_N = mkWN (k9A "torjunta") ; --UNCHK
lin mineral_N = mkWN (k5 "mineraali") ; --UNCHK
lin runner_N = mkWN "Caranx" "crysos" ; --UNCHK
lin pin_V2 = mkWV2 (k53A "kiinnittää") ;
lin integrity_N = mkWN (k40 "rehellisyys") ; --UNCHK
lin thereafter_Adv = mkWAdv (k99 "jälkeen") "sen" ; --UNCHK
lin quid_N = mkWN (kH1 "mälli") ; --UNCHK
lin owl_N = mkWN (k1 "pöllö") "Minervan" ; --UNCHK
lin rigid_A = mkWA (k10A "jäykkä") ; --UNCHK
lin orange_A = mkWA (k5 "oranssi") ; --UNCHK
lin draft_V2 = mkWV2 (k52 "kutsua") "palvelukseen" ; --UNCHK
lin reportedly_Adv = mkWAdv (k99 "mukaan") "saatujen" "tietojen" ; --UNCHK
lin hedge_N = mkN "suoja" ; --mkWN (k4A "pensaikko") ;
lin formulate_V2 = mkWV2 (k73A "kekata") ; --UNCHK
lin associated_A = variants{} ; -- 
lin position_V2 = mkWV2 (k53 "pistää") ; --UNCHK
lin thief_N = mkWN (k1 "rosvo") ; --UNCHK
lin tomato_N = mkWN (k5A "tomaatti") ; --UNCHK
lin exhaust_V2 = mkWV2 (k53A "näännyttää") ; --UNCHK
lin evidently_Adv = variants{} ; -- 
lin eagle_N = mkWN (k10 "kotka") ; --UNCHK
lin specified_A = variants{} ; -- 
lin resulting_A = variants{} ; -- 
lin blade_N = mkWN (k10 "terä") ; --UNCHK
lin peculiar_A = mkWA (k38 "poikkeuksellinen") ; --UNCHK
lin killing_N = mkN "tappaminen" ;
lin desktop_N = mkWN (k9 "tausta") ; --UNCHK
lin bowel_N = mkWN (k2 "suolisto") ; --UNCHK
lin long_V = mkWV (k68 "ikävöidä") ; --UNCHK
lin ugly_A = L.ugly_A ;
lin expedition_N = mkWN (compoundN "tutkimus" (k7 "retki")) ; --UNCHK
lin saint_N = mkWN (k5 "ideaali") ; --UNCHK
lin variable_A = mkWA "muuttuva" ; --UNCHK
lin supplement_V2 = mkWV2 (k53A "liittää") "loppuun" ; --UNCHK
lin stamp_N = mkN "leima" ;
lin slide_N = mkN "liukuminen" ; --f60
lin faction_N = mkN "ryhmä" (mkN "kunta") ; --mkWN (k10 "kopla") ;
lin enthusiastic_A = mkWA (k47 "innostunut") ;
lin enquire_V2 = mkWV2 (k67 "tiedustella") ; --UNCHK
lin enquire_V = mkWV (k67 "tiedustella") ; --UNCHK
lin brass_N = mkWN (k7 "torvi") ; --UNCHK
lin inequality_N = mkWN "epätasa-arvo" ; --UNCHK
lin eager_A = mkA "innokas" ;
lin bold_A = mkWA (k41 "uskalias") ; --UNCHK
lin neglect_V2 = mkV2 "laiminlyödä" partitive ; --mkWV2 (k73 "missata") ;
lin saying_N = mkWN (k2 "ilmaisu") ; --UNCHK
lin ridge_N = mkWN (k9A "malka") ; --UNCHK
lin earl_N = mkWN (k5 "kreivi") ; --UNCHK
lin yacht_N = mkWN (kH1 "jahti") ; --UNCHK
lin suck_V2 = L.suck_V2 ;
lin suck_V = mkWV (k53A "lutkuttaa") ; --UNCHK
lin missing_A = variants{} ; -- 
lin extended_A = variants{} ; -- 
lin valuation_N = mkWN (k39 "luokitus") ; --UNCHK
lin delight_V2 = mkV2 "ilahduttaa" ;
lin delight_V = mkV "nauttia" ; --intransitive
lin beat_N = mkN "isku" ;
lin worship_N = mkWN (k9A "palvonta") ; --UNCHK
lin fossil_N = mkWN (k6 "fossiili") ; --UNCHK
lin diminish_V2 = mkWV2 (k58 "laskea") ; --UNCHK
lin diminish_V = mkWV (k58 "laskea") ; --UNCHK
lin taxpayer_N = mkWN (compoundN "veron" (k10 "maksaja")) ;
lin corruption_N = mkWN (k9A "lahjonta") ; --UNCHK
lin accurately_Adv = variants{} ; -- 
lin honour_V2 = mkWV2 (k53A "kelpuuttaa") ; --UNCHK
lin depict_V2 = mkWV2 (k53A "hahmottaa") ; --UNCHK
lin pencil_N = mkWN (k10 "kynä") ; --UNCHK
lin drown_V2 = mkWV2 (k52A "hukkua") ; --UNCHK
lin drown_V = mkWV (k52A "hukkua") ; --UNCHK
lin stem_N = mkWN (k39 "auraus") ; --UNCHK
lin lump_N = mkWN (k5A "klöntti") ; --UNCHK
lin applicable_A = mkWA (k10 "sopiva") ;
lin rate_V2 = mkWV2 (k67A "luokitella") ; --UNCHK
lin rate_V = mkWV (k67A "luokitella") ; --UNCHK
lin mobility_N = mkWN (k40 "liikkuvuus") ; --UNCHK
lin immense_A = mkWA (k10 "valtava") ; --UNCHK
lin goodness_N = mkWN (k40 "hyvyys") ; --UNCHK
lin price_V2V = variants{}; -- mkV2 "hinnoitella" ;
lin price_V2 = mkV2 "hinnoitella" ;
lin price_V = mkV (lin VK {s = c67A "hinnoitella"}) ;
lin preliminary_A = mkWA (k10 "alustava") ; --f56
lin graph_N = mkWN (k10 "kuvaaja") ; --UNCHK
lin referee_N = mkWN (k6 "tuomari") ; --UNCHK
lin calm_A = mkWA (k26 "tyyni") ;
lin onwards_Adv = mkWAdv (k99 "edelleen") ; --UNCHK
lin omit_V2 = mkV2 (mkV (mkV "jättää") "pois") ;
lin genuinely_Adv = variants{} ; -- 
lin excite_V2 = mkWV2 (k53 "piristää") ; --UNCHK
lin dreadful_A = mkWA (k38 "hirmuinen") ; --UNCHK
lin cave_N = mkWN (k2 "luolasto") ; --UNCHK
lin revelation_N = mkWN (k39 "paljastus") ; --UNCHK
lin grief_N = mkWN (k1 "suru") ; --UNCHK
lin erect_V2 = mkWV2 (k53A "pystyttää") ; --UNCHK
lin tuck_V2 = mkWV2 (k53A "taivuttaa") ; --UNCHK
lin tuck_V = mkWV (k53A "taivuttaa") ; --UNCHK
lin meantime_N = mkWN (k5 "väli") ; --UNCHK
lin barrel_N = mkN "tynnyri" ;
lin lawn_N = mkWN (k7 "nurmi") ; --UNCHK
lin hut_N = mkWN (k5A "mökki") ; --UNCHK
lin swing_N = mkWN (k39 "heilahdus") ; --f59
lin subject_V2 = mkV2 "altistaa" ; ---ARB --mkWV2 (k56A "antaa") "arvioitavaksi" ;
lin ruin_V2 = mkV2 "pilata" ; --mkV2 "raunioittaa" ;
lin slice_N = mkWN "slicing" ; --UNCHK
lin transmit_V2 = mkWV2 (k53A "välittää") ;
lin thigh_N = mkWN (k27 "reisi") ; --UNCHK
lin practically_Adv = variants{} ; -- 
lin dedicate_V2 = mkV2 "omistaa" ; --mkWV2 (k53A "pyhittää") ;
lin mistake_V2 = mkWV2 (k71 "tehdä") "virhe" ; --UNCHK
lin mistake_V = mkWV (k71 "tehdä") "virhe" ; --UNCHK
lin corresponding_A = variants{} ; -- 
lin albeit_Subj = variants{} ; -- 
lin sound_A = mkWA (compoundA "vaka" (k38 "varainen")) ; --UNCHK
lin nurse_V2 = mkWV2 (k53A "hoitaa") ; --UNCHK
lin discharge_N = mkWN (k2 "laukaisu") ; --UNCHK
lin comparative_A = mkWA (k38 "relatiivinen") ; --UNCHK
lin cluster_N = mkWN (k1A "terttu") ; --UNCHK
lin propose_VV = mkVV "ehdottaa" infPresPartAgr ;
lin propose_VS = mkWVS (k53A "esittää") ; --UNCHK
lin propose_V2 = mkV2 "ehdottaa" partitive ;
lin propose_V = mkWV (k53A "esittää") ;
lin obstacle_N = mkWN (k48 "este") ; --UNCHK
lin motorway_N = mkWN (compoundN "valta" (k19 "tie")) ; --UNCHK
lin heritage_N = mkWN (k1A "perintö") ; --UNCHK
lin counselling_N = variants{} ; -- 
lin breeding_N = mkWN (compoundN "lisä" (k38 "äntyminen")) ; --UNCHK
lin characteristic_A = mkWA (k38 "ominainen") ; --UNCHK
lin bucket_N = mkWN (k1A "sanko") ; --UNCHK
lin migration_N = mkWN (k1A "muutto") ; --UNCHK
lin campaign_V = mkWV (k60A "lähteä") "sotaan" ; --UNCHK
lin ritual_N = mkWN (k5 "rituaali") ; --UNCHK
lin originate_V2 = mkWV2 (k53 "perustaa") ; --UNCHK
lin originate_V = mkWV (k53 "perustaa") ; --UNCHK
lin hunting_N = mkWN (k39 "metsästys") ; --UNCHK
lin crude_A = mkWA (kH1 "raaka") ;
lin protocol_N = mkWN (k10 "protokolla") ; --UNCHK
lin prejudice_N = mkWN (compoundN "ennakko" (k39 "käsitys")) ; --UNCHK
lin inspiration_N = mkWN (k3 "inhalaatio") ; --UNCHK
lin dioxide_N = mkWN "dioksidi" ; --UNCHK
lin chemical_A = mkWA (k38 "kemiallinen") ; --UNCHK
lin uncomfortable_A = mkWA (compoundA "epä" (k10 "mukava")) ;
lin worthy_A = mkA (mkN "varteen" (mkN "otettava")) ;
lin inspect_V2 = mkV2 "tutkia" partitive ;
lin summon_V2 = mkV2 (mkV (mkV "kutsua") "koolle") ; --mkWV2 (k73 "kerätä") ;
lin parallel_N = mkWN (k12 "analogia") ;
lin outlet_N = mkN "tehtaan" (mkN "myymälä") ; ---ARB mkWN (compoundN "purkautumis" (k19 "tie")) ;
lin okay_A = mkA "kelvollinen" ;
lin collaboration_N = mkN "yhteis" (mkN "työ") ;
lin booking_N = mkWN (k39 "varaus") ;
lin salad_N = mkWN (k5A "salaatti") ; --UNCHK
lin productive_A = mkWA (k10 "tuottoisa") ;
lin charming_A = variants{} ; -- 
lin polish_A = mkWA (k38 "puolalainen") ; --UNCHK
lin oak_N = mkWN (kH1 "tammi") ; --UNCHK
lin access_V2 = mkV2 (mkV "päästä") (casePrep illative) ;
lin tourism_N = mkWN (k2 "matkailu") ; --UNCHK
lin independently_Adv = variants{} ; -- 
lin cruel_A = mkWA (kH1 "raaka") ; --UNCHK
lin diversity_N = mkN "moni" (mkN "puolisuus") ; --mkWN "vaihtelevuus" ;
lin accused_A = variants{} ; -- 
lin supplement_N = mkN "täydennys" ; --mkWN (k48 "varuste") ;
lin fucking_Adv = mkWAdv "vitun" ; --UNCHK
lin forecast_N = mkN (lin NK {s = d48 "ennuste"}) ;
lin amend_V2V = mkWV2V (k53A "muuttaa") ; --UNCHK
lin amend_V2 = mkWV2 (k53A "muuttaa") ; --UNCHK
lin amend_V = mkWV (k53A "muuttaa") ; --UNCHK
lin soap_N = mkWN (k12 "saippua") ;
lin ruling_N = mkN "hallinto" ;
lin interference_N = mkWN "blokkaaminen" ; --UNCHK
lin executive_A = mkA "suorittava" ;
lin mining_N = mkWN (k9A "louhinta") ;
lin minimal_A = mkWA (k38 "minimaalinen") ; --UNCHK
lin clarify_V2 = mkWV2 (k53 "kirkastaa") ; --UNCHK
lin clarify_V = mkWV (k53 "kirkastaa") ; --UNCHK
lin strain_V2 = mkV2 "koetella" partitive ; --mkWV2 (k52A "jännittyä") ;
lin novel_A = mkWA (k38 "uudenlainen") ; --UNCHK
lin try_N = mkN "yritys" ;
lin coastal_A = mkWA "rannikko-" ; --UNCHK
lin rising_A = variants{} ; -- 
lin quota_N = mkWN (k3 "kiintiö") ;
lin minus_Prep = prePrep nominative "miinus" ;
lin kilometre_N = mkWN (compoundN "kilo" (k5 "metri")) ; --UNCHK
lin characterize_V2 = mkWV2 (k61A "luonnehtia") ; --UNCHK
lin suspicious_A = mkWA (k10 "epäilyttävä") ; --UNCHK
lin pet_N = mkN "lemmikki" ; --mkWN (compoundN "PET-" (k39 "kuvaus")) ;
lin beneficial_A = mkWA (k38 "hyödyllinen") ; --UNCHK
lin fling_V2 = mkWV2 (k53A "heittää") ; --UNCHK
lin fling_V = mkWV (k53A "heittää") ; --UNCHK
lin deprive_V2 = mkWV2 (k53A "köyhdyttää") ; --UNCHK
lin covenant_N = mkWN (k1A "liitto") ; --UNCHK
lin bias_N = mkWN (compoundN "ennakko" (k39 "käsitys")) ; --UNCHK
lin trophy_N = mkWN (k1A "palkinto") ; --UNCHK
lin verb_N = mkWN (k5 "verbi") ; --UNCHK
lin honestly_Adv = variants{} ; -- 
lin extract_N = variants{} ; -- 
lin straw_N = mkWN (k5 "pilli") ; --UNCHK
lin stem_V2 = mkV2 (mkV (mkV "poistaa") "kanta") elative ;
lin stem_V = mkV olla_V "peräisin" ;
lin eyebrow_N = mkWN (compoundN "kulma" (k9 "karva")) ; --UNCHK
lin noble_A = mkA "jalo" ;
lin mask_N = mkN "naamio" ;
lin lecturer_N = mkWN (k12 "luennoitsija") ; --UNCHK
lin girlfriend_N = mkWN (compoundN "tyttö" (k10 "ystävä")) ;
lin forehead_N = mkWN (k10 "otsa") ; --UNCHK
lin timetable_N = mkWN (compoundN "aika" (k1 "taulu")) ; --UNCHK
lin symbolic_A = mkWA (k38 "symbolinen") ; --UNCHK
lin farming_N = mkWN (compoundN "maan" (k39 "viljelys")) ; --UNCHK
lin lid_N = mkN "kansi" "kannen" "kansia" ; --mkWN (k5A "lakki") ;
lin librarian_N = mkWN (compoundN "kirjaston" (k10 "hoitaja")) ; --UNCHK
lin injection_N = mkN (lin NK {s = d03 "injektio"}) ;
lin sexuality_N = mkWN (k40 "sukupuolisuus") ; --UNCHK
lin irrelevant_A = mkWA (compoundA "asiaan" (k34A "kuulumaton")) ;
lin bonus_N = mkWN (k39 "bonus") ;
lin abuse_V2 = mkWV2 (k53A "käyttää") "väärin" ; ---ARB --mkV2 "solvata" partitive ; --mkV2 (mkV (mkV "käyttää") "hyväkseen") partitive ;
lin thumb_N = mkN "peukalo" ; --mkWN (compoundN "pyörö" (k9 "lista")) ;
lin survey_V2 = mkV2 "katsastaa" ; ---ARB mkWV2 (k62 "arvioida") ;
lin ankle_N = mkWN (k9A "nilkka") ; --UNCHK
lin psychologist_N = mkWN (k5 "psykologi") ;
lin occurrence_N = mkWN (k39 "tapaus") ; --UNCHK
lin profitable_A = mkWA (k10 "tuottoisa") ; --f81
lin deliberate_A = mkWA (k38 "verkkainen") ; --UNCHK
lin bow_V2 = mkWV2 (k56A "antaa") "myöten" ; --UNCHK
lin bow_V = mkWV (k56A "antaa") "myöten" ; --UNCHK
lin tribe_N = mkWN (k1 "heimo") ; --UNCHK
lin rightly_Adv = variants{} ; -- 
lin representative_A = mkWA (k10 "edustava") ; --UNCHK
lin code_V2 = mkWV2 (k73 "kryptata") ; --UNCHK
lin validity_N = mkWN (k40 "oikeellisuus") ; --UNCHK
lin marble_N = mkN "marmori" ; --mkWN (compoundN "marmori" (k10 "kuula")) ;
lin bow_N = mkWN "bow" ; --UNCHK
lin plunge_V2 = mkWV2 (k52A "hyytyä") ;
lin plunge_V = mkWV (k52 "syöksyä") ; --f62
lin maturity_N = mkWN (k40 "kypsyys") ; --UNCHK
lin maturity_3_N = mkN "kypsyys" ;
lin maturity_2_N = variants{} ; -- 
lin maturity_1_N = variants{} ; -- 
lin hidden_A = variants{} ; -- 
lin contrast_V2 = mkWV2 (k73A "verrata") ; --UNCHK
lin contrast_V = mkWV (k73A "verrata") ; --UNCHK
lin tobacco_N = mkWN (k14A "tupakka") ;
lin middle_class_A = mkA "keskiluokkainen" ;
lin grip_V2 = mkWV2 (k52A "tarttua") ; --UNCHK
lin clergy_N = mkWN (k2 "papisto") ; --UNCHK
lin trading_A = variants{} ; -- 
lin passive_A = mkWA (k34A "toimeton") ; --UNCHK
lin decoration_N = mkWN (k2 "koristelu") ;
lin racial_A = mkWA (k38 "rodullinen") ;
lin well_N = mkWN (k48A "lähde") ;
lin embarrassment_N = mkWN (k10 "määrä") "yletön" ; --UNCHK
lin sauce_N = mkWN (k48A "kastike") ; --UNCHK
lin fatal_A = mkWA (k38 "fataalinen") ; --UNCHK
lin banker_N = mkWN (k6 "pankkiiri") ;
lin compensate_V2 = mkWV2 (k62 "kompensoida") ; --UNCHK
lin compensate_V = mkWV (k62 "kompensoida") ;
lin make_up_N = variants{} ; -- 
lin popularity_N = mkWN (k3 "suosio") ; --UNCHK
lin interior_A = mkWA (k38 "sisäinen") ; --UNCHK
lin eligible_A = mkWA (k41 "sovelias") ; --UNCHK
lin continuity_N = mkWN (k40 "yhtäjaksoisuus") ; --UNCHK
lin bunch_N = mkWN (k1A "nippu") ;
lin hook_N = mkN "koukku" ;
lin wicket_N = mkWN (compoundN "ristikko" (k12 "ikkuna")) ; --UNCHK
lin pronounce_V2 = mkWV2 (k69 "tuomita") ; --UNCHK
lin pronounce_V = mkWV (k69 "tuomita") ; --UNCHK
lin ballet_N = mkWN (k5A "baletti") ; --UNCHK
lin heir_N = mkWN (k12 "perijä") ;
lin positively_Adv = variants{} ; -- 
lin insufficient_A = mkWA (k38 "vajavainen") ;
lin substitute_V2 = mkV2 "korvata" partitive ; --mkWV2 (k56A "vaihtaa") ;
lin substitute_V = mkWV (k56A "vaihtaa") ; --UNCHK
lin mysterious_A = mkA "mystinen" ; --mkWA (k38 "okkulttinen") ;
lin dancer_N = mkWN (k12 "tanssija") ; --UNCHK
lin trail_N = mkWN (k1A "polku") ; --UNCHK
lin caution_N = mkWN (k40 "tarkkaavaisuus") ; --UNCHK
lin donation_N = mkWN (k39 "lahjoitus") ;
lin added_A = variants{} ; -- 
lin weaken_V2 = mkWV2 (k72A "heiketä") ; --UNCHK
lin weaken_V = mkWV (k72A "heiketä") ;
lin tyre_N = mkWN (k41A "rengas") ; --UNCHK
lin sufferer_N = mkWN (k12 "kärsijä") ; --UNCHK
lin managerial_A = mkWA "liikkeenjohdollinen" ; --UNCHK
lin elaborate_A = mkWA (k9A "tarkka") ; --UNCHK
lin restraint_N = mkWN (k39 "rajoitus") ; --UNCHK
lin renew_V2 = mkWV2 (k53 "uudistaa") ; --f60
lin gardenerMasc_N = variants{} ; -- 
lin dilemma_N = mkWN (k10 "pulma") ;
lin configuration_N = mkWN (k10 "asetelma") ; --UNCHK
lin rear_A = variants{} ; -- 
lin embark_V2 = mkWV2 (k52A "uskaltautua") ; --UNCHK
lin embark_V = mkWV (k52A "uskaltautua") ; --UNCHK
lin misery_N = mkWN (k40 "surkeus") ; --UNCHK
lin importantly_Adv = variants{} ; -- 
lin continually_Adv = variants{} ; -- 
lin appreciation_N = mkN "arvostus" ; ---ARB mkWN (compoundN "arvon" (k1 "nousu")) ;
lin radical_N = mkWN (k2 "vartalo") ; --UNCHK
lin diverse_A = mkWA (k38 "erilainen") ;
lin revive_V2 = mkV2 (mkV (mkV "herättää") "henkiin") ;
lin revive_V = mkWV (k73 "herätä") "henkiin" ;
lin trip_V = mkWV (k53A "vetää") "huumeita" ; --UNCHK
lin lounge_N = mkWN (k9 "aula") ;
lin dwelling_N = mkWN (k1A "asunto") ; --UNCHK
lin parental_A = mkA (separateN "vanhemmuuteen" (mkN "liittyvä")) ; --mkWA (k38 "isällinen") ;
lin loyal_A = mkWA (k5 "lojaali") ;
lin privatisation_N = variants{} ; -- 
lin outsider_N = mkWN (k41 "vieras") ; --UNCHK
lin forbid_V2 = mkV2 "kieltää" partitive ; --mkWV2 (k53A "käyttää") "veto-oikeuttaan" ;
lin yep_Interj = variants{} ; -- 
lin prospective_A = mkWA (k10 "tuleva") ; --UNCHK
lin manuscript_N = mkWN (compoundN "käsi" (k39 "kirjoitus")) ; --UNCHK
lin inherent_A = mkWA "kätketty" ; --UNCHK
lin deem_V2V = mkWV2V (k53A "olettaa") ; --UNCHK
lin deem_V2A = mkWV2A (k53A "olettaa") ; --UNCHK
lin deem_V2 = mkWV2 (k53A "olettaa") ; --UNCHK
lin telecommunication_N = mkN "telekommunikaatio" ;
lin intermediate_A = mkWA (k10 "oleva") "välillä" ; --UNCHK
lin worthwhile_A = mkWA (k38 "arvoinen") "vaivan" ;
lin calendar_N = mkWN (k6 "kalenteri") ;
lin basin_N = mkWN (k10A "vuoka") ; --UNCHK
lin utterly_Adv = variants{} ; -- 
lin rebuild_V2 = mkV2 "uudelleenrakentaa" ;
lin pulse_N = mkWN (k48A "syke") ; --UNCHK
lin suppress_V2 = mkWV2 (k53A "tukahduttaa") ; --UNCHK
lin predator_N = mkWN (k10 "saalistaja") ; --UNCHK
lin width_N = mkWN (k40 "laajuus") ; --UNCHK
lin stiff_A = mkWA (k10 "terävä") ; --UNCHK
lin spine_N = mkWN (k5A "piikki") ; --UNCHK
lin betray_V2 = mkWV2 (k62 "vasikoida") ; --UNCHK
lin punish_V2 = mkWV2 (k54A "ojentaa") ; --UNCHK
lin stall_N = mkWN (k39 "viivytys") ; --UNCHK
lin lifestyle_N = variants{} ; -- 
lin compile_V2 = mkWV2 (k53 "koostaa") ; --UNCHK
lin arouse_V2V = mkWV2V (k52A "havahtua") ; --UNCHK
lin arouse_V2 = mkV2 "herättää" ; --mkWV2 (k52A "havahtua") ;
lin partially_Adv = variants{} ; -- 
lin headline_N = mkWN (k4A "otsikko") ; --UNCHK
lin divine_A = mkWA (k38 "taivaallinen") ; --UNCHK
lin unpleasant_A = mkWA (compoundA "epä" (k10 "miellyttävä")) ; --UNCHK
lin sacred_A = mkWA (k10 "pyhä") ; --UNCHK
lin useless_A = mkWA (k10 "turha") ; --UNCHK
lin cool_V2 = mkV2 "viilentää" partitive ;
lin cool_V = mkWV (k52A "kylmentyä") ; --UNCHK
lin tremble_V = mkWV (k66 "väristä") ; --UNCHK
lin statue_N = mkN "patsas" ; --mkWN (k39 "veistos") ;
lin obey_V2 = mkWV2 (k67A "totella") ; --UNCHK
lin obey_V = mkWV (k67A "totella") ; --UNCHK
lin drunk_A = mkWA (k38 "humalainen") ; --UNCHK
lin tender_A = mkWA (k15 "murea") ; --UNCHK
lin molecular_A = mkWA (k38 "alkeellinen") ; --UNCHK
lin circulate_V2 = mkV2 "levittää" partitive ; --mkWV2 (k53A "kierrättää") ;
lin circulate_V = mkV "kiertää" ;
lin exploitation_N = mkWN (k1 "riisto") ; --UNCHK
lin explicitly_Adv = variants{} ; -- 
lin utterance_N = mkWN (k2 "ääntely") ; --UNCHK
lin linear_A = mkA "lineaarinen" ;
lin chat_V = mkWV (k66 "horista") ; --UNCHK
lin revision_N = mkWN (k39 "tarkistus") ; --UNCHK
lin distress_N = mkWN (compoundN "ulos" (k1A "otto")) ; --UNCHK
lin spill_V2 = mkWV2 (k53 "päästää") ; --UNCHK
lin spill_V = mkV "levitä" ; --mkWV (k53 "päästää") ;
lin steward_N = mkWN (k6 "pehtori") ; --UNCHK
lin knight_N = mkWN (k1 "ratsu") ; --UNCHK
lin sum_V2 = mkWV2 (k73 "ynnätä") ; --UNCHK
lin sum_V = mkWV (k73 "summata") ;
lin semantic_A = mkWA (k38 "semanttinen") ; --UNCHK
lin selective_A = mkWA (compoundA "valik" (k10 "oiva")) ; --UNCHK
lin learner_N = mkWN (k41 "oppilas") ; --UNCHK
lin dignity_N = mkN "arvokkuus" ;
lin senate_N = mkWN (k5A "senaatti") ; --UNCHK
lin grid_N = mkWN (k6 "halstari") ; --UNCHK
lin fiscal_A = mkA "verotuksellinen" ;
lin activate_V2 = mkWV2 (k53A "ottaa") "käyttöön" ; --UNCHK
lin rival_A = variants{} ; -- 
lin fortunate_A = mkWA (k41A "onnekas") ;
lin jeans_N = variants{} ; -- 
lin select_A = mkWA (compoundA "valiko" (k1A "itu")) ; --UNCHK
lin fitting_N = mkWN (k39 "sovitus") ; --UNCHK
lin commentator_N = mkN (lin NK {s = d06 "kommentaattori"}) ;
lin weep_V2 = mkWV2 (k61A "kyynelehtiä") ; --UNCHK
lin weep_V = mkWV (k61A "kyynelehtiä") ; --UNCHK
lin handicap_N = mkWN (k39 "tasoitus") ; --UNCHK
lin crush_V2 = mkV2 "murskata" ;
lin crush_V = mkWV (k71 "tehdä") "loppu" ; --UNCHK
lin towel_N = mkWN (k48A "pyyhe") ;
lin stay_N = mkWN (k2 "oleskelu") ;
lin skilled_A = mkWA (k10 "taitava") ;
lin repeatedly_Adv = mkWAdv (k99 "toistuvasti") ; --UNCHK
lin defensive_A = mkA "defensiivinen" ; ---ARB WA "puolustus-" ;
lin calm_V2 = mkV2 "rauhoittaa" partitive ;
lin calm_V = mkWV (k56A "antaa") "rauhoittavia" ; --UNCHK
lin temporarily_Adv = variants{} ; -- 
lin rain_V2 = mkWV2 (k56A "sataa") ; --UNCHK
lin rain_V = mkWV (k56A "sataa") ; --UNCHK
lin pin_N = mkWN (k9 "keila") ; --UNCHK
lin villa_N = mkWN (kH1 "villa") ; --UNCHK
lin rod_N = mkN "sauva" ; --mkWN (compoundN "sauva" (k6 "bakteeri")) ;
lin frontier_N = mkWN (compoundN "etu" (k10 "rintama")) "tieteen" ; --UNCHK
lin enforcement_N = mkN "pakottaminen" ; ---ARB mkWN (compoundN "pakko" (k1 "keino")) ;
lin protective_A = mkWA (compoundA "turv" (k9 "aava")) ; --UNCHK
lin philosophical_A = mkWA (k38 "filosofinen") ; --UNCHK
lin lordship_N = mkWN (k40 "herruus") ; --UNCHK
lin disagree_VS = variants{}; -- mkV vOlla "eri mieltä" ;
lin disagree_V2 = variants{}; -- mkV vOlla "eri mieltä" ;
lin disagree_V = mkV vOlla "eri mieltä" ;
lin boyfriend_N = mkWN (k4A "nuorikko") ; --UNCHK
lin activistMasc_N = variants{} ; -- 
lin viewer_N = mkN (lin NK {s = d12 "katselija"}) ;
lin slim_A = mkWA (k9 "laiha") ;
lin textile_N = mkWN (k48A "vaate") ; --UNCHK
lin mist_N = mkWN (k1A "utu") ; --UNCHK
lin harmony_N = mkWN (k12 "harmonia") ; --UNCHK
lin deed_N = mkWN (k25 "toimi") ; --UNCHK
lin merge_V2 = mkWV2 (k53 "yhdistää") ; --UNCHK
lin merge_V = mkV "yhdistyä" ;
lin invention_N = mkN "keksintö" ;
lin commissioner_N = mkWN "hallintovirkamies" ; --UNCHK
lin caravan_N = mkWN (compoundN "matkailu" (k1 "vaunu")) ; --UNCHK
lin bolt_N = mkN "pultti" ;
lin ending_N = mkWN (k39 "lopetus") ; --UNCHK
lin publishing_N = variants{} ; -- 
lin gut_N = mkN "sisu" ; ---ARB --mkN "suoli" ; --mkN "sisälmys" ; --mkWN (k5A "katgutti") ;
lin stamp_V2 = mkWV2 (k67A "luokitella") ; --UNCHK
lin stamp_V = mkWV (k67A "luokitella") ; --UNCHK
lin map_V2 = mkWV2 (k69 "merkitä") ; --UNCHK
lin loud_Adv = mkWAdv (k99 "kovaa") ; --UNCHK
lin stroke_V2 = mkWV2 (k67A "imarrella") ; --UNCHK
lin shock_V2 = mkV2 "järkyttää" partitive ;
lin rug_N = mkWN (k1 "ryijy") ; --UNCHK
lin picture_V2 = mkWV2 (k62 "visioida") ; --UNCHK
lin slip_N = mkN "erehdys" ;
lin praise_N = mkWN (k12 "kunnia") ; --UNCHK
lin fine_N = mkWN (k1A "sakko") ;
lin monument_N = mkWN (k5A "monumentti") ; --UNCHK
lin material_A = mkWA (k38 "todellinen") ;
lin garment_N = mkWN (k48A "vaate") ; --UNCHK
lin toward_Prep = mkPrep partitive "kohti" ;
lin realm_N = mkWN (k5 "piiri") ; --UNCHK
lin melt_V2 = mkWV2 (k52A "haihtua") ; --UNCHK
lin melt_V = mkWV (k52A "haihtua") ; --UNCHK
lin reproduction_N = mkWN (compoundN "lisä" (k38 "äntyminen")) ; --UNCHK
lin reactor_N = mkWN (k6 "reaktori") ;
lin furious_A = mkA "raivokas" ;
lin distinguished_A = variants{} ; -- 
lin characterize_V2 = mkWV2 (k61A "luonnehtia") ; --UNCHK
lin alike_Adv = mkWAdv (k99 "samoin") ; --UNCHK
lin pump_N = mkWN (k1A "pumppu") ; --UNCHK
lin probe_N = mkN "koe" ; ---ARB mkWN (k39 "tähystys") ;
lin feedback_N = mkWN (k48A "palaute") ; --UNCHK
lin aspiration_N = mkWN (k3 "inhalaatio") ; --UNCHK
lin suspect_N = mkN "epäilty" ; --mkWN (k1A "syytetty") ;
lin solar_A = mkWA "aurinkoon" "liittyvä" ;
lin fare_N = mkWN (k10 "ohjelma") ; --UNCHK
lin carve_V2 = mkWV2 (k73A "leikata") ; --UNCHK
lin carve_V = mkV "kaivertaa" ;
lin qualified_A = variants{} ; -- 
lin membrane_N = mkWN (k1 "kalvo") ; --UNCHK
lin dependence_N = mkWN (k40 "riippuvuus") ;
lin convict_V2 = mkWV2 (k69 "tuomita") ;
lin bacteria_N = mkWN (k6 "bakteeri") ; --UNCHK
lin trading_N = mkWN (compoundN "kaupan" (k5A "käynti")) ; --UNCHK
lin ambassador_N = mkN "suur" (mkN "lähettiläs") ;
lin wound_V2 = mkWV2 (k53A "satuttaa") ; --UNCHK
lin drug_V2 = mkWV2 (k73 "huumata") ; --UNCHK
lin conjunction_N = mkWN (k48 "yhdiste") ; --UNCHK
lin cabin_N = mkWN (k2 "matkustamo") ; --UNCHK
lin trail_V2 = mkWV2 (k73 "laahata") ; --UNCHK
lin trail_V = mkWV (k73 "laahata") ;
lin shaft_N = mkWN (k1A "ruoto") ; --UNCHK
lin treasure_N = mkWN (compoundN "taide" (k48A "aarre")) ; --UNCHK
lin inappropriate_A = mkWA (k34A "sopimaton") ; --UNCHK
lin half_Adv = mkWAdv (k99 "puolittain") ; --UNCHK
lin attribute_N = mkWN (k5A "attribuutti") ; --UNCHK
lin liquid_A = mkA "nestemäinen" ;
lin embassy_N = mkWN (compoundN "suur" (k1 "lähetystö")) ; --UNCHK
lin terribly_Adv = variants{} ; -- 
lin exemption_N = mkWN (k39 "vapautus") ; --UNCHK
lin array_N = mkWN "antenni-" ; --UNCHK
lin tablet_N = mkWN (kH1 "tabu") ; --UNCHK
lin sack_V2 = mkWV2 (k53A "pussittaa") ; --UNCHK
lin erosion_N = mkWN (k3 "eroosio") ;
lin bull_N = mkN "härkä" ; ---ARB --mkWN (k39 "munaus") ;
lin warehouse_N = mkWN (k2 "varasto") ; --UNCHK
lin unfortunate_A = mkA "epäonninen" ;
lin promoter_N = mkWN (k6 "promoottori") ;
lin compel_VV = mkWVV (k53A "edellyttää") ; --UNCHK
lin compel_V2V = mkWV2V (k53A "edellyttää") ; --UNCHK
lin compel_V2 = mkWV2 (k53A "edellyttää") ; --UNCHK
lin motivate_V2V = mkWV2V (k53 "innostaa") ; --UNCHK
lin motivate_V2 = mkV2 "innostaa" partitive ;
lin burning_A = variants{} ; -- 
lin vitamin_N = mkWN (k5 "vitamiini") ; --UNCHK
lin sail_N = mkWN (k39 "purjehdus") ; --UNCHK
lin lemon_N = mkWN (k27 "susi") ; --UNCHK
lin foreigner_N = mkWN (compoundN "vieras" (k38 "maalainen")) ; --UNCHK
lin powder_N = mkWN (k6 "puuteri") ; --UNCHK
lin persistent_A = mkWA (k10 "pysyvä") ; --UNCHK
lin bat_N = mkN "maila" ; ---ARB --mkN "lepakko" ; --mkWN (k1 "vuoro") ;
lin ancestor_N = mkWN (compoundN "kanta" (k10 "isä")) ; --UNCHK
lin predominantly_Adv = variants{} ; -- 
lin mathematical_A = mkWA (k38 "matemaattinen") ;
lin compliance_N = mkWN (compoundN "ali" (k38 "stuminen")) ; --UNCHK
lin arch_N = mkWN (kH1 "kaari") ; --UNCHK
lin woodland_N = mkWN (k10 "metsä") ; --UNCHK
lin serum_N = mkWN (k6 "seerumi") ; --UNCHK
lin overnight_Adv = mkWAdv (k99 "yli") "yön" ; --UNCHK
lin doubtful_A = mkWA (k10 "epäilevä") ;
lin doing_N = variants{} ; -- 
lin coach_V2 = mkWV2 (k54A "valmentaa") ; --UNCHK
lin coach_V = mkWV (k54A "valmentaa") ; --UNCHK
lin binding_A = variants{} ; -- 
lin surrounding_A = mkWA "ympäröivä" ; --UNCHK
lin peer_N = mkWN (k38 "vertainen") ; --UNCHK
lin ozone_N = mkWN (k5 "otsoni") ; --UNCHK
lin mid_A = mkWA "keski-" ; --UNCHK
lin invisible_A = mkWA (k34A "näkymätön") ; --UNCHK
lin depart_V = mkWV (k52 "poistua") ;
lin brigade_N = mkWN (k5 "prikaati") ; --UNCHK
lin manipulate_V2 = mkWV2 (k62 "manipuloida") ; --UNCHK
lin consume_V2 = mkWV2 (k53A "kuluttaa") ; --UNCHK
lin consume_V = mkWV (k53A "kuluttaa") ; --UNCHK
lin temptation_N = mkN "houkutus" ; --mkWN (k2 "viettely") ;
lin intact_A = mkWA (k10 "ehjä") ; --UNCHK
lin glove_N = L.glove_N ;
lin aggression_N = mkWN (k39 "hyökkäys") ; --UNCHK
lin emergence_N = mkN "ilmaantuminen" ; ---ARB --mkN "nousu" ; --mkWN (compoundN "ulos" (k1 "tulo")) ;
lin stag_V = variants{} ; -- 
lin coffin_N = mkWN (k1A "arkku") ; --UNCHK
lin beautifully_Adv = variants{} ; -- 
lin clutch_V2 = mkWV2 (k58 "iskeä") ; --UNCHK
lin clutch_V = mkWV (k58 "iskeä") ; --UNCHK
lin wit_N = mkWN (k40 "älykkyys") ; --UNCHK
lin underline_V2 = mkWV2 (compoundV "alle" (k73 "viivata")) ; --UNCHK
lin trainee_N = mkWN (k12 "harjoittelija") ; --UNCHK
lin scrutiny_N = mkWN (k2 "tarkastelu") ; --UNCHK
lin neatly_Adv = variants{} ; -- 
lin follower_N = mkWN (k10 "seuraaja") ; --UNCHK
lin sterling_A = mkWA (k41 "paras") ; --UNCHK
lin tariff_N = mkWN (k5 "tariffi") ; --UNCHK
lin bee_N = mkWN (k38 "mehiläinen") ; --UNCHK
lin relaxation_N = mkWN (k39 "höllennys") "sääntöjen" ; --UNCHK
lin negligence_N = mkWN (k40 "huolimattomuus") ; --UNCHK
lin sunlight_N = mkWN (k1A "aurinko") ; --UNCHK
lin penetrate_V2 = mkV2 "läpäistä" ; --mkWV2 (k52 "paljastua") ;
lin penetrate_V = mkWV (k52 "paljastua") ; --UNCHK
lin knot_N = mkWN (compoundN "iso" (k5 "sirri")) ; --UNCHK
lin temper_N = mkWN (k40 "äreys") ; --UNCHK
lin skull_N = mkWN (k1 "kallo") ; --UNCHK
lin openly_Adv = variants{} ; -- 
lin grind_V2 = mkWV2 (k73 "muusata") ; --UNCHK
lin grind_V = mkV "jauhaa" ; --mkWV (k73 "muusata") ;
lin whale_N = mkWN (k41 "valas") ; --UNCHK
lin throne_N = mkWN (compoundN "valta" (k33 "istuin")) ; --UNCHK
lin supervise_V2 = mkWV2 (k61A "vahtia") ; --UNCHK
lin supervise_V = mkWV (k61A "vahtia") ; --UNCHK
lin sickness_N = mkWN (k5A "tauti") ; --UNCHK
lin package_V2 = mkV2 "pakata" ;
lin intake_N = mkWN (k3 "inhalaatio") ; --UNCHK
lin within_Adv = variants{}; -- postPrep genitive "sisällä" ;
lin inland_A = mkWA "sisämaa-" ; --UNCHK
lin beast_N = mkWN (k3 "olio") ; --UNCHK
lin rear_N = mkWN (k13 "selusta") ; --UNCHK
lin morality_N = mkWN (k40 "moraalisuus") ; --UNCHK
lin competent_A = mkA "kompetentti" ;
lin sink_N = mkN "allas" ; ---ARB ; likakaivo ; nielu (technical term)
lin uniform_A = mkWA (k38 "yhtenäinen") ;
lin reminder_N = mkWN (k39 "muistutus") ;
lin permanently_Adv = variants{} ; -- 
lin optimistic_A = mkWA (k38 "optimistinen") ;
lin bargain_N = mkN "kauppa" ; --WN (k39 "sopimus") ;
lin seemingly_Adv = variants{} ; -- 
lin respective_A = mkA "vastaava" ;
lin horizontal_A = mkWA (compoundA "vaaka" (k10 "suora")) ; --UNCHK
lin decisive_A = mkWA (k10 "ratkaiseva") ;
lin bless_V2 = mkWV2 (k73 "siunata") ; --UNCHK
lin bile_N = mkWN (k7A "sappi") ; --UNCHK
lin spatial_A = mkWA (k38 "spatiaalinen") ; --UNCHK
lin bullet_N = mkN "luoti" ; --WN (k1A "syöttö") "nopea" ;
lin respectable_A = mkWA (k38 "kunniallinen") ; --UNCHK
lin overseas_Adv = mkWAdv (k99 "takana") "meren" ;
lin convincing_A = mkWA (k10 "vakuuttava") ; --UNCHK
lin unacceptable_A = mkWA (k34A "sopimaton") ;
lin confrontation_N = mkWN (compoundN "ase" (k38 "ttaminen")) "vastakkain" ; --UNCHK
lin swiftly_Adv = variants{} ; -- 
lin paid_A = variants{} ; -- 
lin joke_V = mkWV (k67 "pilailla") ; --UNCHK
lin instant_A = mkWA (k10 "pakottava") ; --UNCHK
lin illusion_N = mkWN (k3 "illuusio") ;
lin cheer_V2 = mkWV2 (k73 "hurrata") ; --UNCHK
lin cheer_V = mkV (lin VK {s = c53 "kannustaa"}) ;
lin congregation_N = mkWN (compoundN "koko" (k38 "ontuminen")) ; --UNCHK
lin worldwide_Adv = variants{} ; -- 
lin winning_A = variants{} ; -- 
lin wake_N = mkN "herääminen" ;
lin toss_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin toss_V = mkWV (k53A "sekoittaa") ; --UNCHK
lin medium_A = mkWA (compoundA "puoli" (k10 "kypsä")) ; --UNCHK
lin jewellery_N = mkWN (k1 "koru") ; --UNCHK
lin fond_A = mkA "kiintynyt" ;
lin alarm_V2 = mkV2 "hälyttää" ;
lin guerrilla_N = mkWN (k5 "partisaani") ; --UNCHK
lin dive_V = mkWV (k54A "sukeltaa") ;
lin desire_V2 = mkV2 "haluta" partitive ; --mkWV2 (k61 "mieliä") ;
lin cooperation_N = mkWN (compoundN "yhteis" (k19 "työ")) ;
lin thread_N = mkWN (compoundN "ruuvi" (k48A "kierre")) ; --UNCHK
lin prescribe_V2 = mkV2 "määrätä" partitive ; --mkWV2 (k58 "käskeä") ;
lin prescribe_V = mkWV (k58 "käskeä") ; --UNCHK
lin calcium_N = mkWN (k5 "kalsium") ; --UNCHK
lin redundant_A = mkWA (k38 "tautologinen") ; --UNCHK
lin marker_N = mkWN (k5A "merkki") ; --UNCHK
lin chemistMasc_N = variants{} ; -- 
lin mammal_N = mkWN (k38 "imettäväinen") ; --UNCHK
lin legacy_N = mkWN (k5A "testamentti") ; --UNCHK
lin debtor_N = mkWN (k38 "velallinen") ; --UNCHK
lin testament_N = mkWN (k5A "testamentti") ; --UNCHK
lin tragic_A = mkWA (k38 "traaginen") ; --UNCHK
lin silver_A = mkWA (k10 "puhuva") "miellyttävästi" ; --UNCHK
lin grin_N = mkWN (k39 "virnistys") ; --UNCHK
lin spectacle_N = mkWN (k38 "naurunalainen") ; --UNCHK
lin inheritance_N = mkWN (k1A "perintö") ; --UNCHK
lin heal_V2 = mkWV2 (k53A "hoitaa") ; --UNCHK
lin heal_V = mkWV (k53A "hoitaa") ; --UNCHK
lin sovereignty_N = mkWN (k5A "suvereniteetti") ;
lin enzyme_N = mkWN (k6 "entsyymi") ; --UNCHK
lin host_V2 = mkV2 "isännöidä" partitive ; --WV2 (k61 "toimia") "isäntänä" ;
lin neighbouring_A = variants{} ; -- 
lin corn_N = mkN "maissi" ; --f63
lin layout_N = mkWN (k2 "asettelu") ; --UNCHK
lin dictate_VS = mkWVS (k67 "sanella") ; --UNCHK
lin dictate_V2 = mkWV2 (k67 "sanella") ; --UNCHK
lin dictate_V = mkWV (k67 "sanella") ; --UNCHK
lin rip_V2 = mkWV2 (k65 "käydä") "kimppuun" ; --UNCHK
lin rip_V = mkWV (k65 "käydä") "kimppuun" ; --UNCHK
lin regain_V2 = mkWV2 (k53A "saavuttaa") ; --UNCHK
lin probable_A = mkA (mkN "toden" (mkN "näköinen")) ;
lin inclusion_N = mkN "mukaanotto" ; --WN (k39 "lisäys") ;
lin booklet_N = mkWN (k48A "esite") ;
lin bar_V2 = mkWV2 (k58A "sulkea") "pois" ;
lin privately_Adv = variants{} ; -- 
lin laser_N = mkWN (k6 "laser") ; --UNCHK
lin fame_N = mkWN (k40 "julkisuus") ; --UNCHK
lin bronze_N = mkWN (compoundN "pronssi" (k41 "patsas")) ; --UNCHK
lin mobile_A = mkWA (k10 "liikkuva") ;
lin metaphor_N = mkWN (k10 "metafora") ;
lin complication_N = mkN "komplikaatio" ;
lin narrow_V2 = mkV2 "kaventaa" partitive ;
lin narrow_V = mkWV (k52A "kaventua") ;
lin old_fashioned_A = mkA "vanhanaikainen" ;
lin chop_V2 = mkWV2 (k58 "iskeä") ; --UNCHK
lin chop_V = mkWV (k58 "iskeä") ; --UNCHK
lin synthesis_N = mkWN (k5 "synteesi") ; --UNCHK
lin diameter_N = mkWN (k12 "halkaisija") ; --UNCHK
lin bomb_V2 = mkV2 (mkV (lin VK {s = c53A "pommittaa"})) partitive ;
lin bomb_V = mkWV (k53A "pommittaa") ; --UNCHK
lin silently_Adv = variants{} ; -- 
lin shed_N = mkWN (k9 "vaja") ; --UNCHK
lin fusion_N = mkWN (k3 "fuusio") ; --UNCHK
lin trigger_V2 = mkV2 "laukaista" ;
lin printing_N = mkWN (compoundN "kustannus" (k9A "toiminta")) ;
lin onion_N = mkWN (k6 "sipuli") ; --UNCHK
lin dislike_V2 = mkV2 "inhota" partitive ; --WV2 (k53A "pitää") "vastenmielisenä" ;
lin embody_V2 = mkWV2 (k62 "personoida") ; --UNCHK
lin curl_V = mkWV (k52A "kiertyä") ; --UNCHK
lin sunshine_N = mkWN (k40 "hilpeys") ; --UNCHK
lin sponsorship_N = mkWN (k5A "sponsorointi") ; --UNCHK
lin rage_N = mkN "raivo" ; ---ARB --mkWN (k5A "muoti") ;
lin loop_N = mkWN (k14A "silmukka") ; --UNCHK
lin halt_N = mkWN (k39 "pysähdys") ;
lin cop_V2 = mkWV2 (k69 "vangita") ; --UNCHK
lin bang_V2 = mkWV2 (k53A "paukahtaa") ; --UNCHK
lin bang_V = mkWV (k53A "paukahtaa") ; --UNCHK
lin toxic_A = mkA "myrkyllinen" ; --mkWA (k38 "toksinen") ;
lin thinking_A = variants{} ; -- 
lin orientation_N = mkWN (compoundN "johdanto" (k5 "kurssi")) ; --UNCHK
lin likelihood_N = mkWN (compoundN "toden" (k40 "näköisyys")) ; --UNCHK
lin wee_A = mkWA (k38 "aikainen") ; --UNCHK
lin up_to_date_A = variants{} ; -- 
lin polite_A = mkWA (k41 "kohtelias") ; --UNCHK
lin apology_N = mkWN (compoundN "anteeksi" (k1A "pyyntö")) ; --UNCHK
lin exile_N = mkWN (k39 "karkotus") ; --UNCHK
lin brow_N = mkWN (compoundN "kulma" (k9 "karva")) ; --UNCHK
lin miserable_A = mkWA (k38 "vähäpätöinen") ; --UNCHK
lin outbreak_N = mkWN (k39 "purkaus") ; --UNCHK
lin comparatively_Adv = variants{} ; -- 
lin pump_V2 = mkV2 "pumpata" partitive ; --WV2 (k54 "lypsää") ;
lin pump_V = mkWV (k54 "lypsää") ; --UNCHK
lin fuck_V2 = mkV2 "naida" partitive | mkV2 "panna" partitive ;
lin fuck_V = mkV "naida" | mkV "nussia" ;
lin forecast_VS = mkWVS (k53 "ennustaa") ; --UNCHK
lin forecast_V2 = mkWV2 (k53 "ennustaa") ; --UNCHK
lin forecast_V = mkWV (k53 "ennustaa") ; --UNCHK
lin timing_N = mkN (lin NK {s = d39 "ajoitus"}) ;
lin headmaster_N = mkWN (k6 "rehtori") ; --UNCHK
lin terrify_V2 = mkWV2 (k53A "pelottaa") ; --UNCHK
lin sigh_N = mkWN (k39 "huokaus") ;
lin premier_A = mkWA "kanta-" ; --UNCHK
lin joint_N = mkWN (compoundN "kannabis" (k48A "savuke")) ; --UNCHK
lin incredible_A = mkWA (k34A "uskomaton") ;
lin gravity_N = mkWN (k40 "synkkyys") ; --UNCHK
lin regulatory_A = variants{} ; -- 
lin cylinder_N = mkWN (k1 "pullo") ; --UNCHK
lin curiosity_N = mkWN (k40 "erikoisuus") ; --UNCHK
lin resident_A = mkWA "vakituisesti" "asuva" ; --UNCHK
lin narrative_N = mkWN (k39 "kertomus") ; --UNCHK
lin cognitive_A = mkWA (k38 "kognitiivinen") ; --UNCHK
lin lengthy_A = mkWA (k38 "pitkällinen") ; --UNCHK
lin gothic_A = mkWA (compoundA "goott" (k32A "ien")) ; --UNCHK
lin dip_V2 = mkWV2 (k52A "hyytyä") ; --UNCHK
lin dip_V = mkWV (k52A "hyytyä") ; --UNCHK
lin adverse_A = mkWA (k38 "vastakkainen") ;
lin accountability_N = mkWN (k17 "vastuu") ; --UNCHK
lin hydrogen_N = mkWN (k1A "vety") ; --UNCHK
lin gravel_N = mkWN (k10 "sora") ; --UNCHK
lin willingness_N = mkWN (k40 "halukkuus") ; --UNCHK
lin inhibit_V2 = mkV2 "estää" partitive ;
lin attain_V2 = mkWV2 (k56 "kasvaa") ; --UNCHK
lin attain_V = mkWV (k56 "kasvaa") ; --UNCHK
lin specialize_V2 = mkV2 "erikoistaa" ; --mkWV2 (k52 "erikoistua") ;
lin specialize_V = mkWV (k52 "erikoistua") ;
lin steer_V2 = mkWV2 (k67 "ohjailla") ; --UNCHK
lin steer_V = mkWV (k67 "ohjailla") ; --UNCHK
lin selected_A = variants{} ; -- 
lin like_N = mkWN (k38 "lainen") ; --UNCHK
lin confer_V = mkWV (k67A "neuvotella") ; --UNCHK
lin usage_N = mkN "käyttö" ; --mkWN (k1A "käytäntö") ;
lin portray_V2 = mkWV2 (k73 "kuvata") ; --UNCHK
lin planner_N = mkN "suunnittelija" ; --f55
lin manual_A = mkA "manuaalinen" ;
lin boast_VS = mkWVS (k67A "rehennellä") ;
lin boast_V2 = mkWV2 (k67A "rehennellä") ; --UNCHK
lin boast_V = mkWV (k67A "rehennellä") ;
lin unconscious_A = mkWA (k34A "tiedoton") ; --UNCHK
lin jail_N = mkWN (k10 "putka") ; --UNCHK
lin fertility_N = mkWN (k40 "hedelmällisyys") ; --UNCHK
lin documentation_N = mkWN (k39 "vahvistus") ; --UNCHK
lin wolf_N = mkWN (k10A "hukka") ; --UNCHK
lin patent_N = mkN "patentti" ;
lin exit_N = mkWN (compoundN "pois" (k38 "tuminen")) ;
lin corps_N = mkWN (compoundN "armeija" (k10A "kunta")) ; --UNCHK
lin proclaim_VS = mkWVS (k53 "julistaa") ;
lin proclaim_V2 = mkWV2 (k53 "julistaa") ; --UNCHK
lin multiply_V2 = mkWV2 (k56 "jatkaa") "sukua" ; --UNCHK
lin multiply_V = mkWV (k56 "jatkaa") "sukua" ; --UNCHK
lin brochure_N = mkWN (k48A "esite") ; --UNCHK
lin screen_V2 = mkWV2 (k61 "tutkia") ; --UNCHK
lin screen_V = mkV "siivilöityä" ; --mkWV (k61 "tutkia") ;
lin orthodox_A = mkWA (compoundA "puhdas" (k38 "oppinen")) ; --UNCHK
lin locomotive_N = mkWN (k6 "veturi") ; --UNCHK
lin considering_Prep = variants{} ; -- 
lin unaware_A = mkWA (k34A "tietämätön") ; --UNCHK
lin syndrome_N = mkWN (k10 "syndrooma") ; --UNCHK
lin reform_V2 = mkV2 "uudistaa" ; --mkWV2 (k52 "valaistua") ;
lin reform_V = mkWV (k52 "valaistua") ; --UNCHK
lin confirmation_N = mkWN (k3 "konfirmaatio") ; --UNCHK
lin printed_A = variants{} ; -- 
lin curve_V2 = mkWV2 (k52A "kiertyä") ; --UNCHK
lin curve_V = mkWV (k52A "kiertyä") ; --UNCHK
lin costly_A = mkA "hintava" ;
lin underground_A = mkWA (k38 "salainen") ;
lin territorial_A = mkWA (k38 "alueellinen") ; --UNCHK
lin designate_VS = mkWVS (k54A "täsmentää") ; --UNCHK
lin designate_V2V = mkV2V (mkV "osoittaa") accusative infIness ; --mkWV2V (k54A "täsmentää")
lin designate_V2 = mkV2 "nimittää" ; --mkWV2 (k54A "täsmentää") ;
lin designate_V = mkWV (k54A "täsmentää") ; --UNCHK
lin comfort_V2 = mkWV2 (k53A "lievittää") ; --UNCHK
lin plot_V2 = mkWV2 (k61 "juonia") ; --UNCHK
lin plot_V = mkWV (k61 "juonia") ; --UNCHK
lin misleading_A = variants{} ; -- 
lin weave_V2 = mkWV2 (k52A "kutoa") "yhteen" ; --UNCHK
lin weave_V = mkWV (k52A "kutoa") "yhteen" ; --UNCHK
lin scratch_V2 = L.scratch_V2 ;
lin scratch_V = mkWV (k73A "hangata") ; --UNCHK
lin echo_N = mkWN (k10 "jäljitelmä") ; --UNCHK
lin ideally_Adv = variants{} ; -- 
lin endure_V2 = mkV2 (mkV "kestää") partitive ; --mkWV2 (k52 "pysyä") "järkähtämättömänä" ;
lin endure_V = mkWV (k52 "pysyä") "järkähtämättömänä" ; --UNCHK
lin verbal_A = mkWA (k38 "verbaalinen") ; ---ARB --mkA "sanallinen" ;
lin stride_V = mkWV (k52A "harppoa") ; --UNCHK
lin nursing_N = mkWN (compoundN "hoito" (k19 "työ")) ; --UNCHK
lin exert_V2 = mkWV2 (k53A "ottaa") "käyttöön" ; --UNCHK
lin compatible_A = mkA (mkN "yhteen" (mkN "sopiva")) ; --mkWA (compoundA "sopu" (k38 "sointuinen")) ;
lin causal_A = mkWA (k38 "kausaalinen") ; --UNCHK
lin mosaic_N = mkWN (k5A "mosaiikki") ; --UNCHK
lin manor_N = mkWN (k2 "kartano") ; --UNCHK
lin implicit_A = mkWA (k38 "implisiittinen") ;
lin following_Prep = variants{} ; -- 
lin fashionable_A = mkWA (k41A "tyylikäs") ;
lin valve_N = mkN "venttiili" ;
lin proceed_N = variants{} ; -- 
lin sofa_N = mkWN (k5A "seslonki") ; --UNCHK
lin snatch_V2 = mkWV2 (k73A "siepata") ; --UNCHK
lin snatch_V = mkWV (k73A "siepata") ; --UNCHK
lin jazz_N = mkWN (k5 "jazz") ;
lin patron_N = mkN "omistaja" ; ---ARB --mkWN (compoundN "kanta-" (k41A "asiakas")) ;
lin provider_N = mkWN (k10 "elättäjä") ; --UNCHK
lin interim_A = mkWA (compoundA "väli" (k38 "aikainen")) ; --UNCHK
lin intent_N = mkWN (k10 "suunnitelma") ;
lin chosen_A = variants{} ; -- 
lin applied_A = variants{} ; -- 
lin shiver_V = mkWV (k66A "vavista") ; --UNCHK
lin pie_N = mkN "piirakka" ; --mkWN (compoundN "kanta" (k26 "kieli")) "indoeurooppalainen" ;
lin fury_N = mkWN (k40 "villiys") ; --UNCHK
lin abolition_N = mkWN (compoundN "lakka" (k38 "uttaminen")) "orjuuden" ; --UNCHK
lin soccer_N = mkWN (compoundN "jalka" (k1 "pallo")) ; --UNCHK
lin corpse_N = mkWN (k1A "raato") ; --UNCHK
lin accusation_N = mkWN (k39 "syytös") ; --UNCHK
lin kind_A = mkWA (k38 "ystävällinen") ;
lin dead_Adv = mkWAdv (k99 "kaikkiaan") "kerta" ; --UNCHK
lin nursing_A = variants{} ; -- 
lin contempt_N = mkWN "oikeuden" "halventaminen" ; --UNCHK
lin prevail_V = mkWV (k52 "pysyä") "järkähtämättömänä" ;
lin murderer_N = mkWN (k10 "tappaja") ; --UNCHK
lin liberal_N = mkWN (k5 "liberalisti") ; --UNCHK
lin gathering_N = mkWN (compoundN "koko" (k38 "aminen")) ; --UNCHK
lin adequately_Adv = variants{} ; -- 
lin subjective_A = mkWA (k38 "subjektiivinen") ; --UNCHK
lin disagreement_N = mkN (lin NK {s = d09 "kiista"}) ;
lin cleaner_N = mkWN (k33 "puhdistin") ; --UNCHK
lin boil_V2 = mkWV2 (k53A "keittää") ; --UNCHK
lin boil_V = mkWV (k53A "keittää") ; --UNCHK
lin static_A = mkWA (k38 "staattinen") ; --UNCHK
lin scent_N = mkWN (k1 "tuoksu") ; --UNCHK
lin civilian_N = mkWN (k6 "siviili") ; --UNCHK
lin monk_N = mkWN (k5A "munkki") ; --UNCHK
lin abruptly_Adv = variants{} ; -- 
lin keyboard_N = mkN "näppäimistö" ; --mkWN (compoundN "avain" (k48A "pidike")) ;
lin hammer_N = mkWN (k39 "jyskytys") ; --UNCHK
lin despair_N = mkWN (compoundN "epä" (k1 "toivo")) ; --UNCHK
lin controller_N = mkWN (k33A "säädin") ;
lin yell_V2 = mkWV2 (k52A "kirkua") ; --UNCHK
lin yell_V = mkWV (k52A "kirkua") ; --UNCHK
lin entail_V2 = mkWV2 (k53A "rajoittaa") "perintöä" ; --UNCHK
lin cheerful_A = mkWA (k15 "hilpeä") ; --UNCHK
lin reconstruction_N = mkWN (k5A "rekonstruointi") ; --UNCHK
lin patience_N = mkN "kärsivällisyys" ;
lin legally_Adv = variants{} ; -- 
lin habitat_N = mkWN (k5A "habitaatti") ; --UNCHK
lin queue_N = mkWN (k5A "letti") ; --UNCHK
lin spectatorMasc_N = variants{} ; -- 
lin given_A = variants{} ; -- 
lin purple_A = mkWA (k12 "purppura") ; --UNCHK
lin outlook_N = mkN "suhtautumis" (mkN "tapa") ; --f60
lin genius_N = mkWN (k40 "nerokkuus") ; --UNCHK
lin dual_A = mkA "duaalinen" ;
lin canvas_N = mkWN (k41A "telttakangas") ; --UNCHK
lin grave_A = mkWA (k10 "ankara") ;
lin pepper_N = mkWN (k6 "pippuri") ; --UNCHK
lin conform_V2 = mkWV2 (k52A "tottua") ; --UNCHK
lin conform_V = mkWV (k52A "tottua") ; --UNCHK
lin cautious_A = mkA "harkitsevainen" ;
lin dot_N = mkWN (k1A "lappu") ; --UNCHK
lin conspiracy_N = mkWN (compoundN "sala" (k48A "hanke")) ; --UNCHK
lin butterfly_N = mkWN (compoundN "perhos" (k5A "uinti")) ; --UNCHK
lin sponsor_N = mkWN (k12 "tukija") ; --UNCHK
lin sincerely_Adv = variants{} ; -- 
lin rating_N = mkN "hinta-arvio" ;
lin weird_A = mkA "omituinen" ; --mkWA (k38 "merkillinen") ;
lin teenage_A = mkWA (compoundA "kasvu" (k38 "ikäinen")) ; --UNCHK
lin salmon_N = mkWN (k23 "lohi") ; --UNCHK
lin recorder_N = mkWN (compoundN "nokka" (k1 "huilu")) ; --UNCHK
lin postpone_V2 = mkWV2 (k54A "siirtää") "myöhemmäksi" ;
lin maid_N = mkWN (k5A "neiti") ; --UNCHK
lin furnish_V2 = mkWV2 (k53 "kalustaa") ; --UNCHK
lin ethical_A = mkWA (k38 "eettinen") ; --UNCHK
lin bicycle_N = mkWN (k10 "pyörä") ;
lin sick_N = variants{} ; -- 
lin sack_N = mkN "säkki" ; --WN (k39 "vapautus") ; ----ARB
lin renaissance_N = mkWN (k5 "renessanssi") ; --UNCHK
lin luxury_N = mkWN (k39 "luksus") ; --f64
lin gasp_V2 = mkWV2 (k53A "läähättää") ; --UNCHK
lin gasp_V = mkWV (k53A "läähättää") ; --UNCHK
lin wardrobe_N = mkWN (k2 "komero") ; --UNCHK
lin native_N = mkWN (compoundN "eliö" (k5 "laji")) "kotoperäinen" ; --UNCHK
lin fringe_N = mkN "laita" ;
lin adaptation_N = mkWN (k3 "adaptaatio") ; --UNCHK
lin quotation_N = mkN "lainaus" ;
lin hunger_N = mkN "nälkä" ; --WN (k1 "himo") ;
lin enclose_V2 = mkWV2 (k56A "laittaa") ; --UNCHK
lin disastrous_A = mkWA (k38 "katastrofaalinen") ; --UNCHK
lin choir_N = mkN "kuoro" ; ---ARB mkWN (kH1 "kuori") ; --UNCHK
lin overwhelming_A = variants{} ; -- 
lin glimpse_N = mkWN (k39 "silmäys") ; --UNCHK
lin divorce_V2 = mkWV2 (k52A "erottautua") ; --UNCHK
lin circular_A = mkWA (k15 "pyöreä") ; --UNCHK
lin locality_N = mkWN (k40 "läheisyys") ; --UNCHK
lin ferry_N = mkWN (k39 "kuljetus") ; --UNCHK
lin balcony_N = mkWN (k48A "parveke") ; --UNCHK
lin sailor_N = mkWN (compoundN "panama" (k1A "hattu")) ; --UNCHK
lin precision_N = mkWN (k40 "tarkkuus") ;
lin desert_V2 = mkWV2 (k53A "jättää") "heitteille" ; --UNCHK
lin desert_V = mkWV (k53A "jättää") "heitteille" ; --UNCHK
lin dancing_N = mkWN (k5 "tanssi") ; --UNCHK
lin alert_V2 = mkV2 "varoittaa" partitive ;
lin surrender_V2 = mkV2 "luovuttaa" ; --mkWV2 (k52A "luopua") ;
lin surrender_V = mkV "luovuttaa" ; --mkWV (k52A "luopua") ;
lin archive_N = mkWN (k2 "arkisto") ; --UNCHK
lin jump_N = mkN "hyppy" ; ---WN (k2 "ponkaisu") ;
lin philosopher_N = mkWN (k5 "filosofi") ;
lin revival_N = mkWN (k1 "nousu") "uusi" ; --UNCHK
lin presume_VS = mkWVS (k61A "tohtia") ; --UNCHK
lin presume_V2 = mkWV2 (k61A "tohtia") ; --UNCHK
lin presume_V = mkWV (k61A "tohtia") ; --UNCHK
lin node_N = mkWN (k12 "vierailija") ; --UNCHK
lin fantastic_A = mkWA (k41A "irvokas") ; --UNCHK
lin herb_N = mkWN (k5A "yrtti") ; --UNCHK
lin assertion_N = mkWN (k39 "julistus") ;
lin thorough_A = mkWA (k38 "perusteellinen") ;
lin quit_V2 = mkWV2 (k53A "keskeyttää") ; --UNCHK
lin quit_V = mkWV (k53A "keskeyttää") ; --UNCHK
lin grim_A = mkWA (k10 "kamala") ; --UNCHK
lin fair_N = mkWN (k6 "tivoli") ; --UNCHK
lin broadcast_V2 = mkWV2 (k74 "juoruta") ; --UNCHK
lin broadcast_V = mkV (mkV "lähettää") "ohjelmaa" ; --mkWV (k74 "juoruta") ;
lin annoy_V2 = mkWV2 (k53A "ottaa") "päähän" ; --UNCHK
lin divert_V = mkWV (k53A "harhauttaa") ; --UNCHK
lin accelerate_V2 = mkV2 "kiihdyttää" ;
lin accelerate_V = mkWV (k73 "lisätä") "vauhtia" ; --UNCHK
lin polymer_N = mkWN (k5 "polymeeri") ; --UNCHK
lin sweat_N = mkN "hiki" "hikiä" ;
lin survivor_N = mkN "selviytyjä" ;
lin subscription_N = mkWN (compoundN "alle" (k38 "kirjoittaminen")) ; --UNCHK
lin repayment_N = mkN "takaisin" (mkN "maksu") ;
lin anonymous_A = mkWA (k34A "nimetön") ; --UNCHK
lin summarize_V2 = mkWV2 (k71 "tehdä") "yhteenveto" ; --UNCHK
lin punch_N = mkWN (k5 "tälli") ; --UNCHK
lin lodge_V2 = mkWV2 (k53 "nostaa") "kanne" ; --UNCHK
lin lodge_V = mkWV (k53 "nostaa") "kanne" ; --UNCHK
lin landowner_N = mkWN (compoundN "maan" (k10 "omistaja")) ; --UNCHK
lin ignorance_N = mkWN (k40 "tietämättömyys") ; --UNCHK
lin discourage_V2 = mkV2 "lannistaa" ;
lin bride_N = mkWN (k33 "morsian") ; --UNCHK
lin likewise_Adv = mkWAdv (k99 "kanssa") ; --UNCHK
lin depressed_A = variants{} ; -- 
lin abbey_N = mkWN (k6 "luostari") ; --UNCHK
lin quarry_N = mkWN (k41 "saalis") ; --UNCHK
lin archbishop_N = mkWN (compoundN "arkki" (k9 "piispa")) ; --UNCHK
lin sock_N = L.sock_N ;
lin large_scale_A = mkA "laajamittainen" ;
lin glare_V2 = mkWV2 (k67 "mulkoilla") ; --UNCHK
lin glare_V = mkWV (k67 "mulkoilla") ; --UNCHK
lin descent_N = mkWN (k1 "lasku") ; --UNCHK
lin stumble_V = mkWV (k53A "kömmähtää") ; --UNCHK
lin mistress_N = mkWN (k32A "valtiatar") ; --UNCHK
lin empty_V2 = mkWV2 (k53A "miehittää") ; --UNCHK
lin empty_V = mkWV (k53A "miehittää") ; --UNCHK
lin prosperity_N = mkWN (k39 "menestys") ;
lin harm_V2 = mkWV2 (k53A "vahingoittaa") ; --UNCHK
lin formulation_N = mkWN (k2 "muotoilu") ; --UNCHK
lin atomic_A = mkWA "ydin-" ; --UNCHK
lin agreed_A = variants{} ; -- 
lin wicked_A = mkWA (k9 "paha") ; --UNCHK
lin threshold_N = mkWN (k39 "kynnys") ; --UNCHK
lin lobby_N = mkN "aula" ;
lin repay_V2 = mkWV2 (k56 "maksaa") ; --UNCHK
lin repay_V = mkWV (k56 "maksaa") ; --UNCHK
lin varying_A = variants{} ; -- 
lin track_V2 = mkV2 "jäljittää" partitive ;
lin track_V = mkWV (k53A "jättää") "jäljet" ;
lin crawl_V = mkWV (k61A "mönkiä") ; --UNCHK
lin tolerate_V2 = mkWV2 (k69 "suvaita") ;
lin salvation_N = mkWN (k39 "lunastus") ; --UNCHK
lin pudding_N = mkWN (k41A "vanukas") ; --UNCHK
lin counter_VS = mkWVS (k73 "vastata") ;
lin counter_V = mkWV (k73 "vastata") ; --UNCHK
lin propaganda_N = mkWN (k9 "propaganda") ;
lin cage_N = mkWN (compoundN "lyönti" (k5A "häkki")) ; --UNCHK
lin broker_N = mkN "välittäjä" ;
lin ashamed_A = mkWA (k1 "nolo") ; --UNCHK
lin scan_V2 = mkWV2 (k61 "tutkia") ; --UNCHK
lin scan_V = mkWV (k61 "tutkia") ; --UNCHK
lin document_V2 = mkV2 "dokumentoida" partitive ; --mkWV2 (k53 "vahvistaa") ;
lin apparatus_N = mkWN (k5A "aparaatti") ; --UNCHK
lin theology_N = mkWN (k12 "teologia") ; --UNCHK
lin analogy_N = mkWN (k40 "vastaavuus") ; --UNCHK
lin efficiently_Adv = variants{} ; -- 
lin bitterly_Adv = variants{} ; -- 
lin performer_N = mkWN (k12 "taiteilija") "esiintyvä" ; --UNCHK
lin individually_Adv = variants{} ; -- 
lin amid_Prep = mkPrep "keskellä" ;
lin squadron_N = mkWN (k6 "eskaaderi") ; --UNCHK
lin sentiment_N = mkWN (k48A "mielipide") ; --UNCHK
lin making_N = mkWN (k1A "tuotanto") ; --UNCHK
lin exotic_A = mkWA (k38 "eksoottinen") ; --UNCHK
lin dominance_N = mkN "valta-" (mkN "asema") ; --mkWN (k5 "dominanssi") ;
lin coherent_A = mkWA (k5A "koherentti") ; --UNCHK
lin placement_N = mkWN (k5A "rekrytointi") ; --UNCHK
lin flick_V2 = mkWV2 (k53 "karistaa") ; --UNCHK
lin colourful_A = mkWA (k41A "värikäs") ; --UNCHK
lin mercy_N = mkWN (k1 "armo") ; --UNCHK
lin angrily_Adv = variants{} ; -- 
lin amuse_V2 = mkWV2 (k53A "viihdyttää") ; --UNCHK
lin mainstream_N = mkWN (compoundN "valta" (k9A "virta")) ;
lin appraisal_N = mkWN (k5A "arviointi") ;
lin annually_Adv = variants{} ; -- 
lin torch_N = mkWN (compoundN "puhallus" (k1A "lamppu")) ; --UNCHK
lin intimate_A = mkA "läheinen" ;
lin gold_A = mkWA (k38 "kultainen") ; --UNCHK
lin arbitrary_A = mkWA (k38 "mielivaltainen") ;
lin venture_VS = mkWVS (k52A "uskaltautua") ; --UNCHK
lin venture_V2 = mkWV2 (k52A "uskaltautua") ; --UNCHK
lin venture_V = mkWV (k52A "uskaltautua") ; --UNCHK
lin preservation_N = mkWN (k2 "varjelu") ; --UNCHK
lin shy_A = mkWA (k41A "pelokas") ; --UNCHK
lin disclosure_N = mkN "paljastaminen" ;
lin lace_N = mkWN (k5 "pitsi") ; --UNCHK
lin inability_N = mkWN (k40 "kyvyttömyys") ; --UNCHK
lin motif_N = mkWN (k10 "aihelma") ; --UNCHK
lin listenerMasc_N = variants{} ; -- 
lin hunt_N = mkWN (k39 "metsästys") ; --UNCHK
lin delicious_A = mkWA (k10 "miellyttävä") ; --UNCHK
lin term_VS = mkWVS (k67A "määritellä") ;
lin term_V2 = mkWV2 (k67A "määritellä") ; --UNCHK
lin substitute_N = mkWN (k38 "sijainen") ; --UNCHK
lin highway_N = mkWN (compoundN "valta" (k19 "tie")) ;
lin haul_V2 = mkWV2 (k73A "rahdata") ; --UNCHK
lin haul_V = mkWV (k73A "rahdata") ; --UNCHK
lin dragon_N = mkWN (k1 "liitolisko") ; --UNCHK
lin chair_V2 = mkWV2 (k53A "johtaa") "puhetta" ;
lin accumulate_V2 = mkV2 "kerryttää" partitive ;
lin accumulate_V = mkWV (k52A "kertyä") ; --UNCHK
lin unchanged_A = mkA "muuttumaton" ;
lin sediment_N = mkWN (k10 "esiintymä") ; --UNCHK
lin sample_V2 = mkWV2 (k67 "kokeilla") ; --UNCHK
lin exclaim_V2 = mkWV2 (k52A "parkua") ; --UNCHK
lin fan_V2 = mkWV2 (k52 "lietsoa") ; --UNCHK
lin fan_V = mkWV (k52 "lietsoa") ; --UNCHK
lin volunteer_V2 = mkWV2 (k52A "kertoa") "vapaaehtoisesti" ; --UNCHK
lin volunteer_V = mkWV (k52A "kertoa") "vapaaehtoisesti" ; --UNCHK
lin root_V2 = mkWV2 (k52A "juurtua") ; --UNCHK
lin root_V = mkWV (k52A "juurtua") ; --UNCHK
lin parcel_N = mkWN (k40 "osuus") ; --UNCHK
lin psychiatric_A = mkWA (k38 "psykiatrinen") ;
lin delightful_A = mkWA (k10 "miellyttävä") ; --UNCHK
lin confidential_A = mkWA (k38 "luottamuksellinen") ;
lin calorie_N = mkWN (k6 "kalori") ; --UNCHK
lin flash_N = mkWN (k12 "salama") ; --UNCHK
lin crowd_V2 = mkWV2 (k61 "tungeksia") ; --UNCHK
lin crowd_V = mkWV (k61 "tungeksia") ;
lin aggregate_A = mkWA "massa-" ; --UNCHK
lin scholarship_N = mkN "stipendi" ; --mkWN (k39 "tietämys") ;
lin monitor_N = mkN "valvoja" ; ---ARB --mkN "monitori" ;
lin disciplinary_A = mkWA "oppisuunnan" ; --UNCHK
lin rock_V2 = mkWV2 (k52A "keikkua") ; --UNCHK
lin rock_V = mkWV (k52A "keikkua") ; --UNCHK
lin hatred_N = mkWN (k9 "viha") ; --UNCHK
lin pill_N = mkN "pilleri" ;
lin noisy_A = mkWA (k41A "äänekäs") ; --UNCHK
lin feather_N = L.feather_N ;
lin lexical_A = mkWA (k38 "sanastollinen") ; --UNCHK
lin staircase_N = mkWN (k4A "portaikko") ; --UNCHK
lin autonomous_A = mkWA (k38 "itsenäinen") ; --UNCHK
lin viewpoint_N = mkN "näkö" (mkN "kulma") ;
lin projection_N = mkN "projektio" ;
lin offensive_A = mkWA (k10 "loukkaava") ;
lin controlled_A = variants{} ; -- 
lin flush_V2 = mkWV2 (k52 "punastua") ; --UNCHK
lin flush_V = mkWV (k52 "punastua") ; --UNCHK
lin racism_N = mkWN (k5 "rasismi") ; --UNCHK
lin flourish_V = mkWV (k53 "kukoistaa") ; --UNCHK
lin resentment_N = mkWN (k9 "viha") ; --UNCHK
lin pillow_N = mkWN (k1 "tyyny") ; --UNCHK
lin courtesy_N = mkWN (k40 "kohteliaisuus") ; --UNCHK
lin photography_N = mkWN (k39 "kuvaus") ; --UNCHK
lin monkey_N = mkWN (k12 "apina") ; --UNCHK
lin glorious_A = mkWA (k41A "maineikas") ; --UNCHK
lin evolutionary_A = mkWA (compoundA "kehitys" (k38 "opillinen")) ; --UNCHK
lin gradual_A = mkWA (k38 "vähittäinen") ; --UNCHK
lin bankruptcy_N = mkWN (k5 "konkurssi") ;
lin sacrifice_N = mkWN (k39 "uhraus") ; --UNCHK
lin uphold_V2 = mkWV2 (compoundV "yllä" (k53A "pitää")) ; --UNCHK
lin sketch_N = mkWN (k5 "skitsi") ; --UNCHK
lin presidency_N = mkWN (compoundN "presidentti" (k27 "kausi")) ; --UNCHK
lin formidable_A = mkWA (k38 "hirmuinen") ; --UNCHK
lin differentiate_V2 = mkWV2 (k52 "erilaistua") ; --UNCHK
lin differentiate_V = mkWV (k52 "erilaistua") ; --UNCHK
lin continuing_A = variants{} ; -- 
lin cart_N = mkWN (k1 "vaunu") ; --UNCHK
lin stadium_N = mkN (lin NK {s = d06 "stadion"}) ;
lin dense_A = mkWA (k38 "idioottimainen") ; --UNCHK
lin catch_N = mkWN (k99 "kiinni") "saada" ; --UNCHK
lin beyond_Adv = mkWAdv (k99 "yli") "jnk" ; --UNCHK
lin immigration_N = mkWN (k40 "siirtolaisuus") ; --UNCHK
lin clarity_N = mkWN (k40 "kirkkaus") ; --UNCHK
lin worm_N = L.worm_N ;
lin slot_N = mkN "kolo" ;
lin rifle_N = mkWN (k6 "kivääri") ; --UNCHK
lin screw_V2 = mkWV2 (k73 "huijata") ; --UNCHK
lin screw_V = mkWV (k73 "huijata") ; --UNCHK
lin harvest_N = mkN (lin NK {s = d01A "sato"}) ;
lin foster_V2 = mkV2 "edistää" partitive ;
lin academic_N = mkN (mkN "akateeminen") (mkN "henkilö") ;
lin impulse_N = mkWN (k5 "impulssi") ; --UNCHK
lin guardian_N = mkWN (k5A "vahti") ; --UNCHK
lin ambiguity_N = mkWN (compoundN "epä" (k40 "selvyys")) ; --UNCHK
lin triangle_N = mkWN (k6 "triangeli") ; --UNCHK
lin terminate_V2 = mkWV2 (k53A "päättää") ; --UNCHK
lin terminate_V = mkV "päättyä" ; --mkWV (k53A "päättää") ;
lin retreat_V = mkWV (k53A "peruuttaa") ; --UNCHK
lin pony_N = mkWN (k5 "poni") ; --UNCHK
lin outdoor_A = mkWA "ulko-" ; --UNCHK
lin deficiency_N = mkWN (k39 "vajaus") ; --UNCHK
lin decree_N = mkWN (k39 "asetus") ; --UNCHK
lin apologize_V = mkWV (k54A "pyytää") "anteeksi" ; --UNCHK
lin yarn_N = mkWN (k9 "rihma") ; --UNCHK
lin staff_V2 = mkWV2 (k53A "miehittää") ; --UNCHK
lin renewal_N = mkWN (k39 "kunnostus") ;
lin rebellion_N = mkWN (k5A "kapinointi") ; --UNCHK
lin incidentally_Adv = variants{} ; -- 
lin flour_N = mkWN (k1 "jauho") ; --UNCHK
lin developed_A = variants{} ; -- 
lin chorus_N = mkN "kuoro" ; ---ARB --mkWN (compoundN "kerto" (k48A "säe")) ;
lin ballot_N = mkWN (k26 "ääni") ; --UNCHK
lin appetite_N = mkWN (k39 "viehtymys") ; --UNCHK
lin stain_V2 = mkWV2 (k73 "värjätä") ; --UNCHK
lin stain_V = mkWV (k73 "värjätä") ; --UNCHK
lin notebook_N = mkWN (compoundN "tieto" (k48 "kone")) "kannettava" ; --UNCHK
lin loudly_Adv = variants{} ; -- 
lin homeless_A = mkWA (k34A "asunnoton") ; --UNCHK
lin census_N = mkWN (compoundN "väestön" (k9A "laskenta")) ; --UNCHK
lin bizarre_A = mkWA (k38 "merkillinen") ; --UNCHK
lin striking_A = mkA "vaikuttava" ; --mkWA (k38 "keskeinen") ;
lin greenhouse_N = mkWN (compoundN "taimi" (k9 "tarha")) ; --UNCHK
lin part_V2 = mkWV2 (k56A "jakaa") ; --UNCHK
lin part_V = mkWV (k56A "jakaa") ; --UNCHK
lin burial_N = mkWN (k39 "hautaus") ; --UNCHK
lin embarrassed_A = mkA "hämmentynyt" ;
lin ash_N = mkWN (k7 "saarni") ; --UNCHK
lin actress_N = mkWN (k32A "näyttelijätär") ;
lin cassette_N = mkWN (k5A "kasetti") ; --UNCHK
lin privacy_N = mkN "yksityisyys" ; --mkWN (k9 "rauha") "oma" ;
lin fridge_N = L.fridge_N ;
lin feed_N = mkN "syöttö" ; --mkWN (k48A "ape") ;
lin excess_A = mkWA (k38 "liiallinen") ;
lin calf_N = mkWN (k14A "vasikka") ; --UNCHK
lin associate_N = mkN "liittolainen" ;
lin ruin_N = mkWN (k3 "turmio") ; --UNCHK
lin jointly_Adv = variants{} ; -- 
lin drill_V2 = mkWV2 (k53A "harjoituttaa") ;
lin drill_V = mkWV (k53A "harjoituttaa") ;
lin photograph_V2 = mkWV2 (k53A "ottaa") "valokuva" ; --UNCHK
lin devoted_A = variants{} ; -- 
lin indirectly_Adv = variants{} ; -- 
lin driving_A = variants{} ; -- 
lin memorandum_N = mkWN (k1A "mietintö") ;
lin default_N = mkN "laimin" (mkN "lyönti") ; --f56
lin costume_N = mkWN (k1 "asu") ; --UNCHK
lin variant_N = mkWN (k39 "painos") ; --UNCHK
lin shatter_V2 = mkV2 "särkeä" ;
lin shatter_V = mkWV (k52A "särkyä") ; --UNCHK
lin methodology_N = mkWN (k12 "metodologia") ; --UNCHK
lin frame_V2 = mkWV2 (k61A "laatia") ; --UNCHK
lin frame_V = mkWV (k61A "laatia") ; --UNCHK
lin allegedly_Adv = variants{}; -- mkAdV "väitetysti" ;
lin swell_V2 = mkV2 "paisuttaa" partitive ; --mkWV2 (k52A "pöhöttyä") ;
lin swell_V = L.swell_V ;
lin investigator_N = mkWN (k10 "etsivä") ; --UNCHK
lin imaginative_A = mkWA (k38 "mielikuvituksellinen") ; --UNCHK
lin bored_A = variants{} ; -- 
lin bin_N = mkWN (k3 "säiliö") ;
lin awake_A = mkWA (k99 "valveilla") ; --UNCHK
lin recycle_V2 = mkWV2 (k53A "käyttää") "uudelleen" ; --UNCHK
lin group_V2 = mkWV2 (k67A "luokitella") ; --UNCHK
lin group_V = mkWV (k67A "luokitella") ; --UNCHK
lin enjoyment_N = mkWN (k1 "ilo") ; --UNCHK
lin contemporary_N = mkWN (k38 "aikalainen") ; --UNCHK
lin texture_N = mkWN (k48A "rakenne") ; --UNCHK
lin donor_N = mkWN (k10 "lahjoittaja") ;
lin bacon_N = mkWN (k6 "pekoni") ; --UNCHK
lin sunny_A = mkWA (k38 "aurinkoinen") ; --UNCHK
lin stool_N = mkWN (kH1 "palli") ; --UNCHK
lin prosecute_V2 = mkWV2 (k53A "harjoittaa") ; --UNCHK
lin commentary_N = mkWN (k39 "selitys") ; --UNCHK
lin bass_N = mkWN (k32 "ahven") ; --UNCHK
lin sniff_V2 = mkWV2 (k66 "tuhista") ; --UNCHK
lin sniff_V = mkWV (k66 "tuhista") ; --UNCHK
lin repetition_N = mkWN (k39 "kertaus") ; --UNCHK
lin eventual_A = mkA (mkN "lopulta" (mkN "tapahtuva")) ;
lin credit_V2 = mkWV2 (k52 "uskoa") ; --UNCHK
lin suburb_N = mkWN (k3 "lähiö") ; --UNCHK
lin newcomer_N = mkWN (k41A "tulokas") ; --UNCHK
lin romance_N = mkWN (k9A "romantiikka") ; --UNCHK
lin film_V2 = mkWV2 (k53A "ottaa") ; --UNCHK
lin film_V = mkWV (k53A "ottaa") ; --UNCHK
lin experiment_V2 = mkWV2 (k71 "tehdä") "koe" ; --UNCHK
lin experiment_V = mkWV (k71 "tehdä") "koe" ; --UNCHK
lin daylight_N = mkWN (compoundN "päivän" (k1 "valo")) ; --UNCHK
lin warrant_N = mkWN (k39 "oikeutus") ; --f86
lin fur_N = mkN "turkis" ; --UNCHK
lin parking_N = mkWN (k5A "pysäköinti") ; --UNCHK
lin nuisance_N = mkWN (k3 "häiriö") ; --UNCHK
lin civilian_A = mkWA "siviili-" ; --UNCHK
lin foolish_A = mkWA (k34A "älytön") ; --UNCHK
lin bulb_N = mkWN (k1A "kupu") ; --UNCHK
lin balloon_N = mkWN (k50 "kuumailmapallo") ; --UNCHK
lin vivid_A = mkWA (k41A "kirkas") ; --UNCHK
lin surveyor_N = mkWN (compoundN "maanmittaus" (k5 "insinööri")) ; --UNCHK
lin spontaneous_A = mkWA (k34A "välitön") ; --UNCHK
lin biology_N = mkWN (k12 "biologia") ; --UNCHK
lin injunction_N = mkWN (k1A "kielto") ; --UNCHK
lin appalling_A = mkWA (compoundA "kauhis" (k10 "tuttava")) ; --UNCHK
lin amusement_N = mkWN (k5 "huvi") ; --UNCHK
lin aesthetic_A = mkA "esteettinen" ;
lin vegetation_N = mkWN (k2 "oleilu") "tylsistyneenä" ; --UNCHK
lin stab_V2 = L.stab_V2 ;
lin stab_V = mkWV (k66 "tökkäistä") ; --UNCHK
lin rude_A = mkWA (k15 "töykeä") ; --UNCHK
lin offset_V2 = mkWV2 (k56 "painaa") "offsetilla" ; --f118
lin thinking_N = mkWN (k2 "ajattelu") ;
lin mainframe_N = mkWN (k6 "prosessori") ; --UNCHK
lin flock_N = mkWN (kH1 "parvi") ; --UNCHK
lin amateur_A = mkWA "ei-ammattilais-" ; --UNCHK
lin academy_N = mkWN (k50 "korkeakoulu") ; --UNCHK
lin shilling_N = mkWN (k5A "šillinki") ; --UNCHK
lin reluctance_N = mkWN (k40 "innottomuus") ; --UNCHK
lin velocity_N = mkWN (k5A "vauhti") ; --UNCHK
lin spare_V2 = mkV2 "säästää" ;
lin spare_V = mkWV (k53 "säästää") ; --UNCHK
lin wartime_N = mkWN (k9A "sota-aika") ; --UNCHK
lin soak_V2 = mkWV2 (k56 "kastaa") ; --UNCHK
lin soak_V = mkWV (k56 "kastaa") ; --UNCHK
lin rib_N = mkWN (k26 "vahvistuskaari") ; --UNCHK
lin mighty_A = mkWA (k10 "mahtava") ;
lin shocked_A = variants{} ; -- 
lin vocational_A = mkWA (k38 "ammatillinen") ; --UNCHK
lin spit_V2 = mkWV2 (k67 "syljeskellä") ; --UNCHK
lin spit_V = L.spit_V ;
lin gall_N = mkWN (k10A "pokka") ; --UNCHK
lin bowl_V2 = mkWV2 (k73 "keilata") ; --UNCHK
lin bowl_V = mkWV (k73 "keilata") ; --UNCHK
lin prescription_N = mkWN (compoundN "resepti" (k48A "lääke")) ; --UNCHK
lin fever_N = mkWN (k48 "kuume") ;
lin axis_N = variants{} ; -- 
lin reservoir_N = mkWN (k3 "säiliö") ; --UNCHK
lin magnitude_N = mkWN (k40 "voimakkuus") ; --UNCHK
lin rape_V2 = mkV2 "raiskata" ; --mkWV2 (k73 "ryövätä") ;
lin cutting_N = mkWN (k17 "leikkuu") ; --UNCHK
lin bracket_N = mkWN (k33A "pidin") ; --UNCHK
lin agony_N = mkWN (k39 "kidutus") ; --UNCHK
lin strive_VV = mkWVV (k67 "pinnistellä") ; --UNCHK
lin strive_V = mkWV (k67 "pinnistellä") ; --UNCHK
lin strangely_Adv = variants{} ; -- 
lin pledge_VS = mkWVS (k53A "vakuuttaa") ; --UNCHK
lin pledge_V2V = mkWV2V (k53A "vakuuttaa") ; --UNCHK
lin pledge_V2 = mkWV2 (k53A "vakuuttaa") ;
lin recipient_N = mkWN (compoundN "vastaan" (k10 "ottaja")) ;
lin moor_N = mkWN (k7 "nummi") ; --UNCHK
lin invade_V2 = mkWV2 (k73A "vallata") ;
lin dairy_N = mkWN (k6 "meijeri") ;
lin chord_N = mkWN (k1A "sointu") ; --UNCHK
lin shrink_V2 = mkWV2 (k52A "kuihtua") ; --UNCHK
lin shrink_V = mkV "kutistua" ;
lin poison_N = mkWN (k1A "myrkky") ;
lin pillar_N = mkWN (k6 "pilari") ;
lin washing_N = mkWN (k1 "pesu") ; --UNCHK
lin warrior_N = mkWN (k12 "taistelija") ; --UNCHK
lin supervisor_N = mkWN (compoundN "valvonta" (k10 "ohjelma")) ; --UNCHK
lin outfit_N = mkWN "-sarja" ; --UNCHK
lin innovative_A = mkWA (k10 "uraauurtava") ; --UNCHK
lin dressing_N = mkWN (k39 "sidos") ; --UNCHK
lin dispute_V2 = mkWV2 (k67A "väitellä") ; --UNCHK
lin dispute_V = mkWV (k67A "väitellä") ; --UNCHK
lin jungle_N = mkWN (k4A "viidakko") ; --UNCHK
lin brewery_N = mkWN (k2 "panimo") ; --UNCHK
lin adjective_N = mkWN (k3 "kahvio") ; --UNCHK
lin straighten_V2 = mkWV2 (k53 "järjestää") ; --UNCHK
lin straighten_V = mkWV (k53 "järjestää") ; --UNCHK
lin restrain_V2 = mkWV2 (k54A "vähentää") ; --UNCHK
lin monarchy_N = mkWN (k12 "monarkia") ; --UNCHK
lin trunk_N = mkWN (k10 "kärsä") ; --UNCHK
lin herd_N = mkWN (k9 "lauma") ;
lin deadline_N = mkN "määräaika" ;
lin tiger_N = mkWN (k6 "tiikeri") ; --UNCHK
lin supporting_A = variants{} ; -- 
lin moderate_A = mkWA (k38 "kohtuullinen") ; --f56
lin kneel_V = mkWV (k52 "polvistua") ; --UNCHK
lin ego_N = mkWN (k1 "ego") ; --UNCHK
lin sexually_Adv = variants{} ; -- 
lin ministerial_A = mkWA "ministeriön" ; --UNCHK
lin bitch_N = mkWN (k1A "narttu") ; --UNCHK
lin wheat_N = mkWN (k10 "vehnä") ;
lin stagger_V = mkV "horjua" ; --mkWV (k53 "järjestää") ;
lin snake_N = L.snake_N ;
lin ribbon_N = mkWN (compoundN "koriste" (k9 "nauha")) ; --UNCHK
lin mainland_N = mkWN (k49 "mantere") ; --UNCHK
lin fisherman_N = mkWN (k10 "kalastaja") ; --UNCHK
lin economically_Adv = variants{} ; -- 
lin unwilling_A = mkWA (k38 "vastahakoinen") ; --UNCHK
lin nationalism_N = mkWN (compoundN "kansallis" (k48A "tunne")) ; --UNCHK
lin knitting_N = mkWN (k9A "neulonta") ; --UNCHK
lin irony_N = mkWN (k12 "ironia") ;
lin handling_N = mkWN (k1A "käyttö") ; --UNCHK
lin desired_A = variants{} ; -- 
lin bomber_N = mkWN (compoundN "pommi" (k48 "kone")) ;
lin voltage_N = mkWN (k48A "jännite") ; --UNCHK
lin unusually_Adv = variants{} ; -- 
lin toast_N = mkWN (compoundN "paahto" (k10A "leipä")) ; --UNCHK
lin feel_N = mkWN (k2 "koskettelu") ; --UNCHK
lin suffering_N = mkWN (k39 "kärsimys") ;
lin polish_V2 = mkWV2 (k53A "kehittää") ; --UNCHK
lin polish_V = mkWV (k53A "kehittää") ; --UNCHK
lin technically_Adv = variants{} ; -- 
lin meaningful_A = mkWA (k41A "mielekäs") ;
lin aloud_Adv = mkWAdv (k99 "ääneen") ; --UNCHK
lin waiter_N = mkWN (k12 "tarjoilija") ; --UNCHK
lin tease_V2 = mkWV2 (k67A "vietellä") ; --UNCHK
lin opposite_Adv = variants{}; -- mkPrep "vastapäätä" partitive ;
lin goat_N = mkWN (k23 "vuohi") ; --UNCHK
lin conceptual_A = mkWA (k38 "käsitteellinen") ; --UNCHK
lin ant_N = mkWN (k38 "kusiainen") ; --UNCHK
lin inflict_V2 = mkWV2 (k53A "tyrkyttää") ; --UNCHK
lin bowler_N = mkWN (k5 "knalli") ; --UNCHK
lin roar_V2 = mkWV2 (k52 "ulvoa") ; --UNCHK
lin roar_V = mkWV (k52 "ulvoa") ; --UNCHK
lin drain_N = mkWN (k39 "kuivatus") ; --UNCHK
lin wrong_N = mkWN (k1A "vahinko") ; --UNCHK
lin galaxy_N = mkWN (k1A "joukko") "häikäisevä" ; --UNCHK
lin aluminium_N = mkWN (k5 "alumiini") ; --UNCHK
lin receptor_N = mkWN (k5 "reseptori") ; --UNCHK
lin preach_V2 = mkWV2 (k53A "kannattaa") ; --UNCHK
lin preach_V = mkWV (k53A "kannattaa") ; --UNCHK
lin parade_N = mkWN (k39 "esitys") ;
lin opposite_N = mkWN (k10A "vastakohta") ; --UNCHK
lin critique_N = mkWN (k2 "tarkastelu") ; --UNCHK
lin query_N = mkWN (k2 "kuulustelu") ; --UNCHK
lin outset_N = mkN "alku" ; --mkWN (k9A "alkamisaika") ;
lin integral_A = mkWA (k38 "kokonainen") ; --UNCHK
lin grammatical_A = mkWA (k15 "oikea") "kieliopillisesti" ; --UNCHK
lin testing_N = mkWN (k5A "tentti") ; --UNCHK
lin patrol_N = mkN "partio" ; --mkWN (k5A "partiointi") ;
lin pad_N = mkWN (k12 "antura") ; --UNCHK
lin unreasonable_A = mkA "kohtuuton" ; --mkWA (compoundA "arvostelu" (k34A "kyvytön")) ;
lin sausage_N = mkWN (compoundN "ilma" (k9 "laiva")) ; --UNCHK
lin criminal_N = mkWN (k10 "konna") ; --UNCHK
lin constructive_A = mkWA (k10 "rakentava") ;
lin worldwide_A = mkWA (k5 "universaali") ; --UNCHK
lin highlight_N = mkWN (k39 "korostus") ; --UNCHK
lin doll_N = mkWN (k8A "nukke") ; --UNCHK
lin frightened_A = variants{} ; -- 
lin biography_N = mkWN (k10 "elämä") ; --UNCHK
lin vocabulary_N = mkWN (k2 "sanasto") "mentaalinen" ; --UNCHK
lin offend_V2 = mkV2 "loukata" partitive ;
lin offend_V = mkWV (k73A "loukata") ; --UNCHK
lin accumulation_N = mkWN (k1 "kasvu") ; --UNCHK
lin linen_N = mkWN (k9 "liina") ; --UNCHK
lin fairy_N = mkWN (k1A "tonttu") ; --UNCHK
lin disco_N = mkWN (k5A "diskoteekki") ; --UNCHK
lin hint_VS = mkWVS (k66 "vihjaista") ;
lin hint_V2 = mkWV2 (k66 "vihjaista") ; --UNCHK
lin hint_V = mkWV (k66 "vihjaista") ; --UNCHK
lin versus_Prep = prePrep nominative "vastaan" ;
lin ray_N = mkWN (k1 "rausku") ;
lin pottery_N = mkWN (compoundN "saven" (k9A "valanta")) ; --UNCHK
lin immune_A = mkWA "immuuni-" ; --UNCHK
lin retreat_N = mkWN "vetäytyminen" ; --UNCHK
lin master_V2 = mkWV2 (k69 "hallita") ; --UNCHK
lin injured_A = variants{} ; -- 
lin holly_N = variants{} ; -- 
lin battle_V2 = mkV2 (mkV "taistella") (mkPrep "vastaan" partitive) ;
lin battle_V = mkWV (k67 "taistella") ; --UNCHK
lin solidarity_N = mkWN (k40 "solidaarisuus") ; --UNCHK
lin embarrassing_A = mkWA (k38 "kiusallinen") ;
lin cargo_N = mkWN (k39 "lähetys") ; --UNCHK
lin theorist_N = mkWN (k12 "ideologia") ; --UNCHK
lin reluctantly_Adv = variants{} ; -- 
lin preferred_A = variants{} ; -- 
lin dash_V = mkWV (k53A "pirskauttaa") ; --UNCHK
lin total_V2 = mkV2 "yltää" illative ;
lin total_V = mkV "yltää" ; ----
lin reconcile_V2 = mkWV2 (k53A "sovittaa") ; --UNCHK
lin drill_N = mkWN (k39 "harjoitus") ; --UNCHK
lin credibility_N = mkN "uskottavuus" | mkWN (k40 "luotettavuus") ;
lin copyright_N = mkWN (compoundN "tekijän" (k40 "oikeus")) ;
lin beard_N = mkWN (compoundN "kiinnitys" (k2 "rihmasto")) ; --UNCHK
lin bang_N = mkN "isku" ; --mkWN (k39 "menestys") ;
lin vigorous_A = mkWA (k41A "tarmokas") ; --UNCHK
lin vaguely_Adv = variants{} ; -- 
lin punch_V2 = mkWV2 (k64 "lyödä") "nyrkillä" ; --UNCHK
lin prevalence_N = mkWN (k40 "yleisyys") ; --UNCHK
lin uneasy_A = mkWA "huolestunut" ;
lin boost_N = mkN (lin NK {s = d07A "tuki"}) ;
lin scrap_N = mkWN (k2 "kamppailu") ; --UNCHK
lin ironically_Adv = variants{} ; -- 
lin fog_N = L.fog_N ;
lin faithful_A = mkWA (k38 "uskollinen") ; --UNCHK
lin bounce_V2 = mkWV2 (k53A "hyppäyttää") ; --UNCHK
lin bounce_V = mkWV (k53A "hyppäyttää") ; --UNCHK
lin batch_N = mkN "erä" ; --mkWN (k10 "ryhmä") ;
lin smooth_V2 = mkWV2 (k53A "kiillottaa") ; --UNCHK
lin smooth_V = mkWV (k53A "kiillottaa") ; --UNCHK
lin sleeping_A = variants{} ; -- 
lin poorly_Adv = variants{} ; -- 
lin accord_V = mkWV (k73 "määrätä") ; --UNCHK
lin vice_president_N = mkN "vara" (mkN "presidentti") ;
lin duly_Adv = variants{}; -- mkAdV "odotetusti" ;
lin blast_N = mkN "purkaus" ; --mkWN (k5A "lyönti") "pitkä" ;
lin square_V2 = mkWV2 (k62 "neliöidä") ; --UNCHK
lin square_V = mkWV (k62 "neliöidä") ; --UNCHK
lin prohibit_V2 = mkV2 "kieltää" ;
lin prohibit_V = mkWV (k53A "käyttää") "veto-oikeuttaan" ; --UNCHK
lin brake_N = mkWN (k1 "jarru") ;
lin asylum_N = mkWN (k13 "sairaala") "psykiatrinen" ; --UNCHK
lin obscure_V2 = mkWV2 (k54A "pimentää") ; --UNCHK
lin nun_N = mkWN "nun" ; --UNCHK
lin heap_N = mkWN (k2 "kottero") ; --UNCHK
lin smoothly_Adv = variants{} ; -- 
lin rhetoric_N = mkN (lin NK {s = d09A "retoriikka"}) ;
lin privileged_A = mkWA (compoundA "etu" (k1A "oikeutettu")) ; --UNCHK
lin liaison_N = mkWN (k5 "kontakti") ; --UNCHK
lin jockey_N = mkWN (compoundN "kilpa" (k10 "ratsastaja")) ; --UNCHK
lin concrete_N = mkWN (k6 "betoni") ; --UNCHK
lin allied_A = variants{} ; -- 
lin rob_V2 = mkV2 "ryöstää" ; --mkWV2 (k73 "ryövätä") ;
lin indulge_V2 = mkWV2 (k52A "sortua") ; --UNCHK
lin indulge_V = mkWV (k52A "sortua") ; --UNCHK
lin except_Prep = S.except_Prep ;
lin distort_V2 = mkV2 "vääristää" ; --mkWV2 (k54A "rumentaa") ;
lin whatsoever_Adv = variants{} ; -- 
lin viable_A = mkWA (compoundA "elin" (k38 "kelpoinen")) ; --UNCHK
lin nucleus_N = mkWN (k33A "ydin") ; --UNCHK
lin exaggerate_V2 = mkV2 "liioitella" partitive ; --mkWV2 (k52A "ampua") "yli" ;
lin exaggerate_V = mkWV (k52A "ampua") "yli" ; --UNCHK
lin compact_N = mkWN (compoundN "puuteri" (k12 "rasia")) ; --UNCHK
lin nationality_N = mkWN (k9 "kansa") ; --UNCHK
lin direct_Adv = mkWAdv (k99 "suoraan") ; --UNCHK
lin cast_N = mkWN (k1A "heitto") ; --UNCHK
lin altar_N = mkWN (k6 "alttari") ; --UNCHK
lin refuge_N = mkN "turva" ; --mkWN (compoundN "turva" (k38 "utuminen")) ;
lin presently_Adv = variants{} ; -- 
lin mandatory_A = mkA "pakollinen" ;
lin authorize_V2V = mkV2V (mkV "valtuuttaa") accusative infIllat ;
lin authorize_V2 = mkV2 "valtuuttaa" ;
lin accomplish_V2 = mkWV2 (k56A "saattaa") "voimaan" ; --UNCHK
lin startle_V2 = mkWV2 (k53A "säikäyttää") ; --UNCHK
lin indigenous_A = mkWA (k38 "kotimainen") ; --UNCHK
lin worse_Adv = mkWAdv "huonommin" ; --UNCHK
lin retailer_N = mkWN (compoundN "jälleen" (k10 "myyjä")) ; --f98
lin compound_V2 = mkWV2 (k53 "yhdistää") ;
lin compound_V = mkWV (k53 "yhdistää") ; --UNCHK
lin admiration_N = mkWN (k39 "kunnioitus") ; --UNCHK
lin absurd_A = mkWA (k34A "mahdoton") ; --UNCHK
lin coincidence_N = mkWN (k10 "tapahtuma") "samanaikainen" ; --UNCHK
lin principally_Adv = variants{} ; -- 
lin passport_N = mkWN (k33 "avain") ; --UNCHK
lin depot_N = mkWN (k2 "varasto") ; --UNCHK
lin soften_V2 = mkWV2 (k52A "pehmentyä") ; --UNCHK
lin soften_V = mkWV (k52A "pehmentyä") ; --UNCHK
lin secretion_N = mkWN (k48A "erite") ; --UNCHK
lin invoke_V2 = mkWV2 (k67 "rukoilla") ; --UNCHK
lin dirt_N = mkWN (k1A "törky") ; --UNCHK
lin scared_A = variants{} ; -- 
lin mug_N = mkWN (k5 "muki") ; --UNCHK
lin convenience_N = mkN "mukavuus" ; --WN (k5A "värkki") ;
lin calm_N = mkWN (k40 "rauhallisuus") ; --UNCHK
lin optional_A = mkWA (k38 "valinnainen") ; --UNCHK
lin unsuccessful_A = mkA "epäonnistunut" ;
lin consistency_N = mkWN (k40 "loogisuus") ; --UNCHK
lin umbrella_N = mkWN (k1A "katto") ; --UNCHK
lin solo_N = mkN (lin NK {s = d01 "soolo"}) ;
lin hemisphere_N = mkWN (k5 "hemisfääri") ; --UNCHK
lin extreme_N = mkWN (k40 "äärimmäisyys") ; --UNCHK
lin brandy_N = mkWN (k1 "brandy") ; --UNCHK
lin belly_N = L.belly_N ;
lin attachment_N = mkWN (k39 "kiinnitys") ; --UNCHK
lin wash_N = mkWN (k1 "pesu") ; --UNCHK
lin uncover_V2 = mkWV2 (k53 "paljastaa") ; --UNCHK
lin treat_N = mkWN (k1A "nautinto") ; --UNCHK
lin repeated_A = variants{} ; -- 
lin pine_N = mkWN (k1A "mänty") ; --UNCHK
lin offspring_N = mkWN (k38 "jälkeläinen") ; --UNCHK
lin communism_N = mkWN (k5 "kommunismi") ; --UNCHK
lin nominate_V2 = mkWV2 (k53A "esittää") partitive ;
lin soar_V2 = mkWV2 (k66 "nousta") ; --UNCHK
lin soar_V = mkV "ampaista" ;
lin geological_A = mkWA (k38 "geologinen") ; --UNCHK
lin frog_N = mkWN (k10 "konna") ; --UNCHK
lin donate_V2 = mkWV2 (k53A "lahjoittaa") ; --UNCHK
lin donate_V = mkWV (k53A "lahjoittaa") ; --UNCHK
lin cooperative_A = mkWA (compoundA "yhteis" (k38 "toiminnallinen")) ; --UNCHK
lin nicely_Adv = variants{} ; -- 
lin innocence_N = mkWN (k40 "luonnollisuus") ; --UNCHK
lin housewife_N = mkWN (k10A "emäntä") "talon" ; --UNCHK
lin disguise_V2 = mkWV2 (k73 "salata") ; --UNCHK
lin demolish_V2 = mkWV2 (k71 "tehdä") "loppu" ; --UNCHK
lin counsel_N = mkWN (k39 "ohjaus") ;
lin cord_N = mkWN (k1 "naru") ; --UNCHK
lin semi_final_N = variants{} ; -- 
lin reasoning_N = mkWN (k2 "päättely") ; --UNCHK
lin litre_N = mkWN (k9 "litra") ; --UNCHK
lin inclined_A = variants{} ; -- 
lin evoke_V2 = mkWV2 (k64 "tuoda") "mieleen" ; --UNCHK
lin courtyard_N = mkWN (k9 "piha") ; --UNCHK
lin arena_N = mkWN (k13 "areena") ;
lin simplicity_N = mkWN (k40 "vaatimattomuus") ; --UNCHK
lin inhibition_N = mkWN (k1A "kielto") ; --UNCHK
lin frozen_A = variants{} ; -- 
lin vacuum_N = mkWN (k6 "imuri") ; --UNCHK
lin immigrant_N = mkWN (k38 "siirtolainen") ; --UNCHK
lin bet_N = mkN "vedon" (mkN "lyönti") ;
lin revenge_N = mkWN (k1 "kosto") ; --UNCHK
lin jail_V2 = mkV2 "vangita" ;
lin helmet_N = mkWN (k10 "kypärä") ; --UNCHK
lin unclear_A = mkWA (compoundA "epä" (k10 "selvä")) ; --UNCHK
lin jerk_V2 = mkWV2 (k53A "nytkähtää") ; --UNCHK
lin jerk_V = mkWV (k53A "nytkähtää") ; --UNCHK
lin disruption_N = mkWN (k5 "väli") ; --UNCHK
lin attainment_N = mkWN (compoundN "pää" (k38 "seminen")) ; --UNCHK
lin sip_V2 = mkWV2 "siemailla" ; --UNCHK
lin sip_V = mkWV "siemailla" ; --UNCHK
lin program_V2V = mkWV2V (k67A "suunnitella") "ohjelma" ; --UNCHK
lin program_V2 = mkWV2 (k67A "suunnitella") "ohjelma" ; --UNCHK
lin lunchtime_N = mkWN (compoundN "ruoka" (k5A "tunti")) ; --UNCHK
lin cult_N = mkWN (k5A "muoti") ; --UNCHK
lin chat_N = mkWN (k1A "sieppo") ; --UNCHK
lin accord_N = mkWN (k12 "harmonia") ; --f65
lin supposedly_Adv = variants{} ; -- 
lin offering_N = mkN "tarjous" ;
lin broadcast_N = mkWN (k39 "lähetys") ; --UNCHK
lin secular_A = mkWA (k38 "sekulaarinen") ; --UNCHK
lin overwhelm_V2 = mkV2 (mkV "pursuta") (mkPrep "yli") ;
lin momentum_N = mkWN (compoundN "liike" (k10 "määrä")) ; --UNCHK
lin infinite_A = mkWA (k34A "rajaton") ; --UNCHK
lin manipulation_N = mkN "manipulointi" ; --WN (k1A "käyttö") ;
lin inquest_N = mkWN (k39 "tutkimus") "kuolemansyyn" ; --UNCHK
lin decrease_N = mkWN (k39 "vähennys") ; --UNCHK
lin cellar_N = mkWN (k6 "kellari") ; --UNCHK
lin counsellor_N = mkWN (compoundN "oikeus" (k10 "avustaja")) ; --UNCHK
lin avenue_N = mkWN (k19 "tie") ; --UNCHK
lin rubber_A = mkWA (k1A "epäkelpo") ; --UNCHK
lin labourer_N = mkWN (k38 "työläinen") ; --UNCHK
lin lab_N = mkWN (k3 "laboratorio") ; --UNCHK
lin damn_V2 = mkWV2 (k74 "kirota") ; --UNCHK
lin comfortably_Adv = variants{} ; -- 
lin tense_A = mkA "kireä" ;
lin socket_N = mkWN (compoundN "pisto" (k12 "rasia")) ; --UNCHK
lin par_N = mkWN (k5 "par") ; --f60
lin thrust_N = mkWN (compoundN "työntö" (k10 "voima")) ;
lin scenario_N = mkN "skenaario" ;
lin frankly_Adv = variants{} ; -- 
lin slap_V2 = mkWV2 (k53A "läpsäyttää") ; --UNCHK
lin recreation_N = mkWN (k39 "virkistys") ;
lin rank_V2 = mkWV2 (k67A "luokitella") ; --UNCHK
lin rank_V = mkWV (k67A "luokitella") ; --UNCHK
lin spy_N = mkWN (k5A "agentti") "salainen" ; --UNCHK
lin filter_V2 = mkWV2 (k52A "siivilöityä") ; --UNCHK
lin filter_V = mkWV (k52A "siivilöityä") ; --UNCHK
lin clearance_N = mkWN (k10A "lupa") ; --UNCHK
lin blessing_N = mkWN (k39 "siunaus") ;
lin embryo_N = mkWN (k3 "alkio") ;
lin varied_A = variants{} ; -- 
lin predictable_A = mkWA (compoundA "odotuksen" (k38 "mukainen")) ; --UNCHK
lin mutation_N = mkWN (k39 "muutos") ; --UNCHK
lin equal_V2 = mkV2 (mkV olla_V "sama") (mkPrep "kuin" nominative) ; ----
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_V2 = mkWV2 (k53A "purkittaa") ; --UNCHK
lin burst_N = mkWN (k10 "puuska") ; --UNCHK
lin retrieve_V2 = mkWV2 (k64 "tuoda") "mieleen" ; --UNCHK
lin retrieve_V = mkWV (k64 "tuoda") "mieleen" ; --UNCHK
lin elder_N = mkWN (k2 "henkilö") "vanhempi" ; --UNCHK
lin rehearsal_N = mkWN (k39 "harjoitus") ; --UNCHK
lin optical_A = mkA "optinen" ;
lin hurry_N = mkN "kiire" ; --mkWN (k1 "syöksy") ;
lin conflict_V = mkWV (k73A "loukata") ; --UNCHK
lin combat_V2 = mkV2 (mkV "taistella") (mkPrep "vastaan" partitive) ;
lin combat_V = mkWV (k67 "taistella") ; --UNCHK
lin absorption_N = mkWN (compoundN "päähän" (k10 "piintymä")) ; --UNCHK
lin ion_N = mkWN (k5 "ioni") ; --UNCHK
lin wrong_Adv = mkWAdv (k99 "virheellisesti") ; --UNCHK
lin heroin_N = mkWN (k5 "heroiini") ; --UNCHK
lin bake_V2 = mkWV2 (k56 "paistaa") ; --UNCHK
lin bake_V = mkWV (k56 "paistaa") ; --UNCHK
lin x_ray_N = mkWN (compoundN "röntgen" (k10 "kuva")) ; --UNCHK
lin vector_N = mkWN (k6 "vektori") ; --UNCHK
lin stolen_A = variants{} ; -- 
lin sacrifice_V2 = mkWV2 (k73 "uhrata") ; --UNCHK
lin sacrifice_V = mkV "uhrautua" ; --mkWV (k73 "uhrata") ;
lin robbery_N = mkWN (k1 "ryöstö") ;
lin probe_V2 = mkWV2 (k67 "tarkastella") ; --UNCHK
lin probe_V = mkWV (k67 "tarkastella") ; --UNCHK
lin organizational_A = mkWA (k38 "järjestöllinen") ; --UNCHK
lin chalk_N = mkWN (k1A "liitu") ; --UNCHK
lin bourgeois_A = mkWA (k38 "porvarillinen") ; --UNCHK
lin villager_N = mkWN (k38 "kyläläinen") ; --UNCHK
lin morale_N = mkWN (k7A "henki") ;
lin express_A = mkWA (compoundA "nimen" (k38 "omainen")) ; --UNCHK
lin climb_N = mkWN (compoundN "koho" (k38 "aminen")) ; --UNCHK
lin notify_V2 = mkV2 "ilmoittaa" allative ;
lin jam_N = mkN "ruuhka" ; ---ARB --mkN "hillo" ; --mkWN (k9A "häirintä") ;
lin bureaucratic_A = mkWA (k38 "byrokraattinen") ; --UNCHK
lin literacy_N = mkWN (compoundN "luku" (k1A "taito")) ; --UNCHK
lin frustrate_V2 = mkV2 "turhauttaa" ; --WV2 (k53 "ahdistaa") ;
lin freight_N = mkN "rahti" ; ---ARB mkWN (k39 "rahtaus") ;
lin clearing_N = mkWN (compoundN "kirkas" (k38 "taminen")) ; --UNCHK
lin aviation_N = mkWN (k2 "ilmailu") ; --UNCHK
lin legislature_N = mkN "lain" (mkN "säädäntö") ;
lin curiously_Adv = variants{} ; -- 
lin banana_N = mkWN (k6 "banaani") ; --UNCHK
lin deploy_V2 = mkWV2 (k53A "sijoittaa") ; --UNCHK
lin deploy_V = mkWV (k53A "sijoittaa") ; --UNCHK
lin passionate_A = mkWA (k38 "tulinen") ; --UNCHK
lin monastery_N = mkWN (k6 "luostari") ; --UNCHK
lin kettle_N = mkWN (k6 "boileri") ; --UNCHK
lin enjoyable_A = mkWA (k10 "miellyttävä") ; --UNCHK
lin diagnose_V2 = mkWV2 (k53A "määrittää") "tauti" ; --UNCHK
lin quantitative_A = mkA "kvantitatiivinen" ;
lin distortion_N = mkWN (k10 "vääristymä") ; --UNCHK
lin monarch_N = mkWN (k5A "monarkki") ; --UNCHK
lin kindly_Adv = variants{} ; -- 
lin glow_V = mkWV (k52 "hehkua") ; --UNCHK
lin acquaintance_N = mkWN (k40 "perehtyneisyys") ; --UNCHK
lin unexpectedly_Adv = variants{} ; -- 
lin handy_A = mkA "kätevä" ;
lin deprivation_N = mkWN (k48A "puute") ; --UNCHK
lin attacker_N = mkWN (k10 "ahdistaja") ; --UNCHK
lin assault_V2 = mkWV2 (k67A "piikitellä") ; --UNCHK
lin screening_N = mkWN (k9A "seulonta") ; --UNCHK
lin retired_A = variants{} ; -- 
lin quick_Adv = mkWAdv (k99 "äkkiä") ; --UNCHK
lin portable_A = mkWA "matka-" ; --UNCHK
lin hostage_N = mkWN (compoundN "pantti" (k5A "vanki")) ;
lin underneath_Prep = postPrep genitive "alapuolella" ;
lin jealous_A = mkWA (k38 "mustasukkainen") ; --UNCHK
lin proportional_A = mkWA (k38 "suhteellinen") ; --UNCHK
lin gown_N = mkWN (k1A "puku") "naisen" ; --UNCHK
lin chimney_N = mkWN (compoundN "savu" (k1A "piippu")) ; --UNCHK
lin bleak_A = mkWA (k1A "kolkko") ; --UNCHK
lin seasonal_A = mkWA (k38 "kausittainen") ; --f53
lin plasma_N = mkWN (k9 "plasma") ; --UNCHK
lin stunning_A = mkA "mykistävä" ;
lin spray_N = mkWN (k33A "suutin") ; --UNCHK
lin referral_N = mkWN (compoundN "viitta" (k38 "aminen")) ; --UNCHK
lin promptly_Adv = variants{} ; -- 
lin fluctuation_N = mkWN (k40 "epävakaisuus") ; --UNCHK
lin decorative_A = mkWA (k38 "koristeellinen") ; --UNCHK
lin unrest_N = mkWN (k40 "levottomuus") ; --UNCHK
lin resent_VS = mkWVS (k67 "olla") "katkera" ; --UNCHK
lin resent_V2 = mkWV2 (k67 "olla") "katkera" ; --UNCHK
lin plaster_N = mkWN (k6 "laastari") ; --UNCHK
lin chew_V2 = mkWV2 (k61 "pureksia") ; --UNCHK
lin chew_V = mkWV (k61 "pureksia") ; --UNCHK
lin grouping_N = mkWN (k10 "ryhmittymä") ; --UNCHK
lin gospel_N = mkWN (k5A "oppi") ; --UNCHK
lin distributor_N = mkN "jakelija" ;
lin differentiation_N = mkWN "differentaatio" ; --UNCHK
lin blonde_A = mkWA (k15 "vaalea") ; --UNCHK
lin aquarium_N = mkWN (k3 "akvaario") ; --UNCHK
lin witch_N = mkWN (k10A "noita") ;
lin renewed_A = variants{} ; -- 
lin jar_N = mkWN (k5A "tölkki") ; --UNCHK
lin approved_A = variants{} ; -- 
lin advocateMasc_N = variants{} ; -- 
lin worrying_A = variants{} ; -- 
lin minimize_V2 = mkWV2 (k62 "minimoida") ; --UNCHK
lin footstep_N = mkWN (k49 "askel") ; --UNCHK
lin delete_V2 = mkWV2 (k61A "pyyhkiä") ; --UNCHK
lin underneath_Adv = mkWAdv "alapuolella" ; --UNCHK
lin lone_A = mkWA (k99 "ainut") ; --UNCHK
lin level_V2 = mkWV2 (k52A "tasoittua") ; --UNCHK
lin level_V = mkWV (k52A "tasoittua") ; --UNCHK
lin exceptionally_Adv = variants{} ; -- 
lin drift_N = mkWN (k10 "perä") ; --UNCHK
lin spider_N = mkWN (k5A "lukki") ; --UNCHK
lin hectare_N = mkWN (k6 "hehtaari") ; --UNCHK
lin colonel_N = mkWN (k5 "eversti") ; --UNCHK
lin swimming_N = mkWN (k5A "uinti") ; --UNCHK
lin realism_N = mkWN (k5 "pragmatismi") ; --UNCHK
lin insider_N = mkWN (k32 "jäsen") "sisäpiirin" ;
lin hobby_N = mkWN (k9A "toiminta") "vapaa-ajan" ; --UNCHK
lin computing_N = variants{} ; -- 
lin infrastructure_N = mkN "infrastruktuuri" ; --WN (k10 "pohja") ;
lin cooperate_V = mkWV (k61 "toimia") "yhteistyössä" ; --UNCHK
lin burn_N = mkN "palo" ;
lin cereal_N = mkWN (k5 "velli") ; --UNCHK
lin fold_N = mkWN (compoundN "tai" (k38 "ttaminen")) ; --UNCHK
lin compromise_V2 = mkWV2 (k67A "sovitella") ; --UNCHK
lin compromise_V = mkWV (k67A "sovitella") ;
lin boxing_N = mkWN (compoundN "pakka" (k38 "aminen")) ; --UNCHK
lin rear_V2 = mkWV2 (k53A "pystyttää") ; --UNCHK
lin rear_V = mkWV (k53A "pystyttää") ; --UNCHK
lin lick_V2 = mkWV2 (k53A "rökittää") ; --UNCHK
lin constrain_V2 = mkWV2 (k53 "kiristää") ; --UNCHK
lin clerical_A = mkWA "papin" ; --UNCHK
lin hire_N = mkWN (k39 "vuokraus") ; --UNCHK
lin contend_VS = mkVS (mkV (mkV "pitää") "selviönä") ; --f93
lin contend_V = mkWV (k53A "pitää") "selviönä" ; --UNCHK
lin amateurMasc_N = variants{} ; -- 
lin instrumental_A = mkWA (k38 "instrumentaalinen") ; --UNCHK
lin terminal_A = mkWA (k38 "viimeinen") ; --UNCHK
lin electorate_N = mkWN (compoundN "valitsija" (k10A "kunta")) ; --UNCHK
lin congratulate_V2 = mkWV2 (k52 "lausua") "kohteliaisuus" ; --UNCHK
lin balanced_A = variants{} ; -- 
lin manufacturing_N = variants{} ; -- 
lin split_N = mkWN (k10 "eripura") ;
lin domination_N = mkWN (k40 "herruus") ;
lin blink_V2 = mkWV2 (k53A "räpyttää") ; --UNCHK
lin blink_V = mkWV (k53A "räpyttää") ; --UNCHK
lin bleed_VS = variants{}; -- mkV (mkV "vuotaa") "verta" ;
lin bleed_V2 = variants{}; -- mkV (mkV "vuotaa") "verta" ;
lin bleed_V = mkV (mkV "vuotaa") "verta" ;
lin unlawful_A = mkWA (k34A "laiton") ;
lin precedent_N = mkWN (compoundN "ennakko" (k39 "tapaus")) ; --UNCHK
lin notorious_A = mkA (mkN "paha" (mkN "maineinen")) ;
lin indoor_A = mkWA "sisä-" ; --UNCHK
lin upgrade_V2 = mkWV2 (k53A "päivittää") ; --UNCHK
lin trench_N = mkWN (k10 "oja") ; --UNCHK
lin therapist_N = mkWN (k10 "parantaja") ; --UNCHK
lin illuminate_V2 = mkWV2 (k66 "valaista") ; --UNCHK
lin bargain_V2 = mkWV2 (k67A "neuvotella") ; --UNCHK
lin bargain_V = mkWV (k67A "neuvotella") ; --UNCHK
lin warranty_N = mkWN (k17 "takuu") ;
lin scar_V2 = mkWV2 (k53A "jättää") "arpi" ; --UNCHK
lin scar_V = mkWV (k53A "jättää") "arpi" ; --UNCHK
lin consortium_N = mkN "konsortio" ;
lin anger_V2 = mkWV2 (k53A "vihastuttaa") ; --UNCHK
lin insure_VS = variants{}; -- mkV2 "vakuuttaa" ;
lin insure_V2 = mkV2 "vakuuttaa" ;
lin insure_V = mkV "vakuuttaa" ;
lin extensively_Adv = variants{} ; -- 
lin appropriately_Adv = variants{} ; -- 
lin spoon_N = mkWN (k14A "lusikka") ; --UNCHK
lin sideways_Adv = mkWAdv (k99 "vinottain") ; --UNCHK
lin enhanced_A = variants{} ; -- 
lin disrupt_V2 = mkWV2 (k66 "katkaista") ; --UNCHK
lin disrupt_V = mkWV (k66 "katkaista") ; --UNCHK
lin satisfied_A = variants{} ; -- 
lin precaution_N = mkWN (kH1 "suoja") ; --UNCHK
lin kite_N = mkWN (compoundN "haara" (k9A "haukka")) ; --UNCHK
lin instant_N = mkWN (k10A "ajankohta") ; --UNCHK
lin gig_N = mkWN (k9A "keikka") ; --UNCHK
lin continuously_Adv = variants{} ; -- 
lin consolidate_V2 = mkWV2 (k53 "vahvistaa") ;
lin consolidate_V = mkWV (k53 "vahvistaa") ; --UNCHK
lin fountain_N = mkWN (k48A "lähde") ; --UNCHK
lin graduate_V2 = mkWV2 (k62 "kalibroida") ; --UNCHK
lin graduate_V = mkWV (k62 "kalibroida") ; --UNCHK
lin gloom_N = mkWN (k40 "synkkyys") ; --UNCHK
lin bite_N = mkWN (k9 "pala") ; --UNCHK
lin structure_V2 = mkWV2 (k54A "jäsentää") ; --UNCHK
lin noun_N = mkWN (k5 "substantiivi") ; --UNCHK
lin nomination_N = mkWN (compoundN "ehdolle" (k1 "pano")) ;
lin armchair_N = mkWN (compoundN "noja" (k5 "tuoli")) ; --UNCHK
lin virtual_A = mkWA (k38 "virtuaalinen") ; --f66
lin unprecedented_A = mkWA (k38 "uudenlainen") ; --UNCHK
lin tumble_V2 = mkWV2 (k73 "sysätä") ; --UNCHK
lin tumble_V = mkV "pyöriä" ;
lin ski_N = mkWN (k7 "suksi") ; --UNCHK
lin architectural_A = mkWA (k38 "arkkitehtoninen") ;
lin violation_N = mkN "rikkomus" ; --f63
lin rocket_N = mkWN (k5A "raketti") ; ---ARB
lin inject_V2 = mkWV2 (k53 "pistää") ; --UNCHK
lin departmental_A = mkWA "osaston" ; --UNCHK
lin row_V2 = mkWV2 (k55A "soutaa") ; --UNCHK
lin row_V = mkWV (k55A "soutaa") ; --UNCHK
lin luxury_A = variants{} ; -- 
lin fax_N = variants{} ; -- 
lin deer_N = mkWN (k41 "kauris") ; --UNCHK
lin climber_N = mkWN (k9 "nasta") ; --UNCHK
lin photographic_A = mkWA "valokuvaus-" ; --UNCHK
lin haunt_V2 = mkWV2 (k52A "näyttäytyä") "kummituksena" ; --UNCHK
lin fiercely_Adv = variants{} ; -- 
lin dining_N = mkWN (k38 "syöminen") "päivällisen" ; --UNCHK
lin sodium_N = mkWN (k5 "natrium") ; --UNCHK
lin gossip_N = mkN "juoru" ;
lin bundle_N = mkWN (k1A "kimppu") ; --UNCHK
lin bend_N = mkWN (k5 "kurvi") ; --UNCHK
lin recruit_N = mkWN (k41A "tulokas") ; --UNCHK
lin hen_N = mkWN "naaras-" ; --UNCHK
lin fragile_A = mkWA (k41 "hauras") ; --UNCHK
lin deteriorate_V2 = mkWV2 (k72A "heiketä") ; --UNCHK
lin deteriorate_V = mkWV (k72A "heiketä") ; --UNCHK
lin dependency_N = mkWN (compoundN "alus" (k18 "maa")) ; --UNCHK
lin swift_A = mkWA (k10 "vikkelä") ; --UNCHK
lin scramble_V2 = mkWV2 (k53 "vääristää") ; --UNCHK
lin scramble_V = mkWV (k53 "vääristää") ; --UNCHK
lin overview_N = mkWN (compoundN "yleis" (k10 "kuva")) ; --UNCHK
lin imprison_V2 = mkV2 "vangita" ;
lin trolley_N = mkWN (compoundN "johdin" (k5 "bussi")) ; --UNCHK
lin rotation_N = mkWN (k48A "liike") "pyörivä" ; --UNCHK
lin denial_N = mkWN (k39 "kieltäymys") ; --UNCHK
lin boiler_N = mkWN (compoundN "höyry" (k12 "kattila")) ; --UNCHK
lin amp_N = mkWN (k6 "ampeeri") ; --UNCHK
lin trivial_A = mkWA (k5 "triviaali") ; --UNCHK
lin shout_N = mkWN (k2 "karjaisu") ; --UNCHK
lin overtake_V2 = mkWV2 (k53A "tavoittaa") ; --UNCHK
lin make_N = mkN "teko" ;
lin hunter_N = mkWN (k1 "kello") "umpikuorinen" ; --UNCHK
lin guess_N = mkWN (k2 "arvelu") ; --UNCHK
lin doubtless_Adv = mkWAdv (k99 "varmaan") ; --UNCHK
lin syllable_N = mkWN (k1 "tavu") ; --UNCHK
lin obscure_A = mkWA (k10 "hämärä") ; --UNCHK
lin mould_N = mkWN (k39 "valos") ; --UNCHK
lin limestone_N = mkWN (compoundN "kalkki" (k7 "kivi")) ; --UNCHK
lin leak_V2 = mkWV2 (k53A "vuotaa") ; --UNCHK
lin leak_V = mkWV (k53A "vuotaa") ; --UNCHK
lin beneficiary_N = mkWN (compoundN "testamentin" (k10 "saaja")) ; --UNCHK
lin veteran_N = mkWN (k12 "tekijä") "vanha" ; --UNCHK
lin surplus_A = variants{} ; -- 
lin manifestation_N = mkWN (compoundN "mielen" (k39 "osoitus")) ; --UNCHK
lin vicar_N = mkN "pastori" ; --mkWN (compoundN "vik" (k5 "aari")) ;
lin textbook_N = mkWN (k9 "kirja") ; --UNCHK
lin novelist_N = mkN "romaanikirjailija" ;
lin halfway_Adv = mkWAdv (k99 "puolitiessä") ; --UNCHK
lin contractual_A = mkWA "sopimus-" ; --UNCHK
lin swap_V2 = mkV2 (mkV (lin VK {s = c56A "vaihtaa"})) partitive ;
lin swap_V = mkWV (k53A "sivuttaa") ; --UNCHK
lin guild_N = mkN "kilta" ; --mkWN (k5 "loosi") ;
lin ulcer_N = mkWN (k10 "haavautuma") ; --UNCHK
lin slab_N = mkWN (k1 "levy") ; --UNCHK
lin detector_N = mkWN (k33 "aistin") ; --UNCHK
lin detection_N = mkWN "löytäminen" ; --UNCHK
lin cough_V = mkWV (k61 "köhiä") ; --UNCHK
lin whichever_Quant = variants{} ; -- 
lin spelling_N = mkWN (k12 "ortografia") ; --UNCHK
lin lender_N = mkWN (k10 "lainaaja") ; --f58
lin glow_N = variants{} ; -- 
lin raised_A = variants{} ; -- 
lin prolonged_A = variants{} ; -- 
lin voucher_N = mkWN (k5A "kuponki") ; --UNCHK
lin t_shirt_N = variants{} ; -- 
lin linger_V = mkWV (k67 "viivytellä") ;
lin humble_A = mkWA (k10 "nöyrä") ; --UNCHK
lin honey_N = mkWN (k10 "hunaja") ; --UNCHK
lin scream_N = mkWN (k1A "juttu") "hauska" ; --UNCHK
lin postcard_N = mkWN (compoundN "posti" (k5A "kortti")) ; --UNCHK
lin managing_A = variants{} ; -- 
lin alien_A = mkWA (k38 "eksoottinen") ; --UNCHK
lin trouble_V2 = mkV2 "vaivata" partitive ;
lin reverse_N = mkWN (k39 "käännös") ; --UNCHK
lin odour_N = mkWN (k1 "tuoksu") ; --UNCHK
lin fundamentally_Adv = variants{} ; -- 
lin discount_V2 = mkWV2 (k73 "tyrmätä") ; --UNCHK
lin discount_V = mkWV (k73 "tyrmätä") ; --UNCHK
lin blast_V2 = mkWV2 (k67 "turmella") ; --UNCHK
lin blast_V = mkWV (k67 "turmella") ; --UNCHK
lin syntactic_A = mkWA (k38 "syntaktinen") ; --UNCHK
lin scrape_V2 = mkWV2 (k61A "raapia") ; --UNCHK
lin scrape_V = mkWV (k61A "raapia") ; --UNCHK
lin residue_N = mkWN (k39 "jäännös") ; --UNCHK
lin procession_N = mkWN (compoundN "eteenpäin" (k1 "meno")) ; --UNCHK
lin pioneer_N = mkN "pioneeri" ; --mkWN (compoundN "uudis" (k41A "asukas")) ;
lin intercourse_N = mkWN (k38 "kanssakäyminen") "seksuaalinen" ; --UNCHK
lin deter_V2 = mkWV2 (k63 "saada") "luopumaan" ; --UNCHK
lin deadly_A = mkWA "tappava" ;
lin complement_V2 = mkWV2 (k54A "täydentää") ;
lin restrictive_A = mkWA "rajoittava" ;
lin nitrogen_N = mkWN (k7A "typpi") ; --UNCHK
lin citizenship_N = mkWN (compoundN "kansalais" (k7A "henki")) ; --UNCHK
lin pedestrian_N = mkWN (k12 "kävelijä") ; --UNCHK
lin detention_N = mkWN (compoundN "jälki-" (k1A "istunto")) ; --UNCHK
lin wagon_N = mkWN (k6 "farmari") ; --UNCHK
lin microphone_N = mkWN (k5A "mikki") ; --UNCHK
lin hastily_Adv = variants{} ; -- 
lin fixture_N = mkWN (k1A "huolto") ; --UNCHK
lin choke_V2 = mkWV2 (k52A "tukahtua") ; --UNCHK
lin choke_V = mkWV (k52A "tukahtua") ; --UNCHK
lin wet_V2 = mkWV2 (k67 "kastella") ; --UNCHK
lin weed_N = mkWN (k7 "pilvi") ; --UNCHK
lin programming_N = mkWN (k5A "ohjelmointi") ; --UNCHK
lin power_V2 = mkWV2 (k56A "antaa") "virtaa" ; --UNCHK
lin nationally_Adv = variants{} ; -- 
lin dozen_N = mkWN (k12 "tusina") ; --f72
lin carrot_N = mkWN (k12 "porkkana") ; --UNCHK
lin bulletin_N = mkWN (k48A "tiedote") ; --UNCHK
lin wording_N = mkWN (k12 "fraseologia") ; --UNCHK
lin vicious_A = mkA "häijy" ;
lin urgency_N = mkWN (k40 "kiireellisyys") ;
lin spoken_A = variants{} ; -- 
lin skeleton_N = mkWN (k4A "kehikko") ; --UNCHK
lin motorist_N = mkWN (k12 "autoilija") ;
lin interactive_A = mkWA (k38 "synergistinen") ; --UNCHK
lin compute_V2 = mkWV2 (k58 "laskea") ; --UNCHK
lin compute_V = mkWV (k58 "laskea") ;
lin whip_N = mkWN (k1 "isku") "piiskan" ; --UNCHK
lin urgently_Adv = variants{} ; -- 
lin telly_N = mkWN (k20 "teevee") ; --UNCHK
lin shrub_N = mkWN (k1A "varpu") ; --UNCHK
lin porter_N = mkWN (k6 "portteri") ; --UNCHK
lin ethics_N = mkWN (k14A "etiikka") ; --UNCHK
lin banner_N = mkWN (k5 "viiri") ; --UNCHK
lin velvet_N = mkWN (k5A "sametti") ; --UNCHK
lin omission_N = mkWN "väliin" "jättäminen" ; --UNCHK
lin hook_V2 = mkWV2 (k67 "ahdistella") ; --UNCHK
lin hook_V = mkWV (k67 "ahdistella") ; --UNCHK
lin gallon_N = mkWN (k10 "gallona") "amerikkalainen" ; --UNCHK
lin financially_Adv = variants{} ; -- 
lin superintendent_N = mkWN (k10 "johtaja") ; --UNCHK
lin plug_V2 = mkWV2 (k58 "kytkeä") ;
lin plug_V = mkWV (k58 "kytkeä") ; --UNCHK
lin continuation_N = mkWN "jatkaminen" ; --UNCHK
lin reliance_N = mkWN (k39 "luottamus") ;
lin justified_A = variants{} ; -- 
lin fool_V2 = mkWV2 (k67A "hullutella") ; --UNCHK
lin detain_V2 = mkWV2 (k53A "viivästyttää") ; --UNCHK
lin damaging_A = mkWA (k38 "kielteinen") ; --UNCHK
lin orbit_N = mkWN (k40 "ulottuvuus") ; --UNCHK
lin mains_N = variants{} ; -- 
lin discard_V2 = mkWV2 (k73A "hylätä") ;
lin dine_V = mkV (mkV "syödä") "päivällistä" ; --UNCHK
lin compartment_N = mkWN (k2 "osasto") ; --UNCHK
lin revised_A = variants{} ; -- 
lin privatization_N = mkWN (compoundN "yks" (k38 "ityistäminen")) ; --UNCHK
lin memorable_A = mkWA (compoundA "ikimuis" (k38 "toinen")) ; --UNCHK
lin lately_Adv = variants{} ; -- 
lin distributed_A = variants{} ; -- 
lin disperse_V2 = mkWV2 (k53A "hajottaa") ; --UNCHK
lin disperse_V = mkWV (k53A "hajottaa") ; --UNCHK
lin blame_N = mkWN (k48A "moite") ; --UNCHK
lin basement_N = mkN "pohjakerros" ; --WN (k6 "kellari") ;
lin slump_V2 = mkWV2 (k72 "vähetä") ; --UNCHK
lin slump_V = mkWV (k72 "vähetä") ; --UNCHK
lin puzzle_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin monitoring_N = mkWN (k9A "valvonta") ; --UNCHK
lin talented_A = mkWA (k10 "etevä") ; --UNCHK
lin nominal_A = mkWA "nimellis-" ; --UNCHK
lin mushroom_N = mkWN (k26 "sieni") ;
lin instructor_N = mkWN (k10 "kouluttaja") ; --UNCHK
lin fork_N = variants{} ; -- 
lin fork_4_N = variants{} ; -- 
lin fork_3_N = variants{} ; -- 
lin fork_1_N = mkWN (compoundN "haa" (k38 "roittuminen")) ; --UNCHK
lin board_V2 = mkWV2 (k53A "majoittaa") ; --UNCHK
lin want_N = mkN "tarve" ;
lin disposition_N = mkWN (compoundN "hei" (k38 "ttäminen")) "pois" ; --UNCHK
lin cemetery_N = mkWN (k2 "kalmisto") ; --UNCHK
lin attempted_A = variants{} ; -- 
lin nephew_N = mkWN (compoundN "veljen" (k10A "poika")) ; --UNCHK
lin magical_A = mkWA (k10 "lumoava") ; --UNCHK
lin ivory_N = mkWN (compoundN "luun" (k38 "valkoinen")) ; --UNCHK
lin hospitality_N = mkN "vieraanvaraisuus" ;
lin besides_Prep = mkPrep "rinnalla" ;
lin astonishing_A = mkWA "ällistyttävä" ; --UNCHK
lin tract_N = mkN "traktaatti" ; ---ARB --mkN "kanava" ; --mkWN (k9A "rata") ;
lin proprietor_N = mkWN (k10 "omistaja") ; --UNCHK
lin license_V2 = mkV2 "luvallistaa" ;
lin differential_A = mkWA (k38 "erilainen") ; --UNCHK
lin affinity_N = mkWN (k39 "viehtymys") ; --UNCHK
lin talking_N = variants{} ; -- 
lin royalty_N = mkN "kuningas" (mkN "perhe") ;
lin neglect_N = mkWN (k40 "välinpitämättömyys") ; --UNCHK
lin irrespective_A = variants{} ; -- 
lin whip_V2 = mkWV2 (k61 "suomia") ; --UNCHK
lin whip_V = mkWV (k61 "suomia") ; --UNCHK
lin sticky_A = mkWA (k15 "tahmea") ; --UNCHK
lin regret_N = mkWN (k39 "katumus") ;
lin incapable_A = mkWA (k34A "kykenemätön") ; --UNCHK
lin franchise_N = mkWN (k40 "oikeus") ;
lin dentist_N = mkWN (compoundN "hammas" (k6 "lääkäri")) ; --UNCHK
lin contrary_N = mkWN (k10A "vastakohta") ; --UNCHK
lin profitability_N = variants{} ; -- 
lin enthusiast_N = mkN "intoilija" ; --mkWN (k10 "kannattaja") ;
lin crop_V2 = mkWV2 (k61 "oksia") ; --UNCHK
lin crop_V = mkWV (k61 "oksia") ; --UNCHK
lin utter_V2 = mkWV2 (k52 "sanoa") "ääneen" ; --UNCHK
lin pile_V2 = mkWV2 (k73 "kasata") ; --UNCHK
lin pile_V = mkWV (k73 "kasata") ; --UNCHK
lin pier_N = mkWN (k10 "satama") ; --UNCHK
lin dome_N = mkWN (k6 "kupoli") ; --UNCHK
lin bubble_N = mkWN (k1A "kupu") ; --UNCHK
lin treasurer_N = mkWN (k10 "johtaja") "rahatoimiston" ; --UNCHK
lin stocking_N = mkWN (compoundN "varus" (k38 "taminen")) ; --UNCHK
lin sanctuary_N = mkWN (kH1 "kuori") ; --UNCHK
lin ascertain_V2 = variants{} ; -- 
lin arc_N = mkWN (kH1 "kaari") ; --UNCHK
lin quest_N = mkWN (k9A "etsintä") ; --UNCHK
lin mole_N = mkWN (k10 "myyrä") ; --UNCHK
lin marathon_N = mkWN (k5 "maraton") ; --UNCHK
lin feast_N = variants{} ; -- 
lin crouch_V = mkWV (k52 "kyykistyä") ; --UNCHK
lin storm_V2 = mkWV2 (k73A "rynnätä") ; --UNCHK
lin storm_V = mkWV (k73A "rynnätä") ; --UNCHK
lin hardship_N = mkWN (k40 "vakavuus") ; --UNCHK
lin entitlement_N = mkWN (compoundN "tuki" (k40 "oikeus")) ; --UNCHK
lin circular_N = mkWN (k38 "lehtinen") ; --UNCHK
lin walking_A = variants{} ; -- 
lin strap_N = mkWN (k9 "piiska") ; --UNCHK
lin sore_A = mkWA (k38 "vihainen") ; --UNCHK
lin complementary_A = mkWA (k38 "komplementaarinen") ; --UNCHK
lin understandable_A = mkWA (k10 "ymmärrettävä") ;
lin noticeable_A = mkWA (k10 "näkyvä") ; --UNCHK
lin mankind_N = mkWN (k13 "maailma") ; --UNCHK
lin majesty_N = mkWN (k40 "ylevyys") ; --UNCHK
lin pigeon_N = mkWN (k1 "pulu") ; --UNCHK
lin goalkeeper_N = mkWN (k9 "veska") ; --UNCHK
lin ambiguous_A = mkWA (compoundA "epä" (k10 "selvä")) ; --UNCHK
lin walker_N = mkWN (compoundN "kävely" (k1 "kärry")) ; --UNCHK
lin virgin_N = mkN "neitsyt" ;
lin prestige_N = mkWN (k40 "arvovaltaisuus") ;
lin preoccupation_N = mkN "keskittyminen" ; --WN (k39 "valtaus") ;
lin upset_A = variants{} ; -- 
lin municipal_A = mkWA (k38 "kunnallinen") ; --f67
lin groan_V2 = mkWV2 (k73 "purnata") ; --UNCHK
lin groan_V = mkWV (k73 "purnata") ; --UNCHK
lin craftsman_N = mkWN (k5 "artesaani") ; --UNCHK
lin anticipation_N = mkWN (k39 "povaus") ; --UNCHK
lin revise_V2 = mkV2 "tarkistaa" ;
lin revise_V = mkV "tarkistaa" ;
lin knock_N = mkWN (k39 "läimäys") ; --UNCHK
lin infect_V2 = mkWV2 (k53A "saastuttaa") ; --UNCHK
lin infect_V = mkWV (k53A "saastuttaa") ; --UNCHK
lin denounce_V2 = mkWV2 (k62 "kritisoida") ; --UNCHK
lin confession_N = mkWN (k5A "rippi") ; --UNCHK
lin turkey_N = mkWN (k12 "kalkkuna") ; --UNCHK
lin toll_N = mkWN (k1 "maksu") ; --UNCHK
lin pal_N = mkWN (k10 "tuttava") ; --UNCHK
lin transcription_N = mkWN (k39 "tallennus") ; --UNCHK
lin sulphur_N = mkWN (kH1 "rikki") ; --UNCHK
lin provisional_A = mkWA (k38 "tilapäinen") ; --UNCHK
lin hug_V2 = mkWV2 (k53 "puristaa") ; --UNCHK
lin particular_N = mkWN (k10A "yksityiskohta") ; --UNCHK
lin intent_A = mkA "tarkkaavainen" ; ---
lin fascinate_V2 = mkWV2 (k53A "houkuttaa") ; --UNCHK
lin conductor_N = mkN "johdin" ; ---ARB ; rahastaja ; kapellimestari
lin feasible_A = mkWA (k38 "mahdollinen") ; --UNCHK
lin vacant_A = mkWA (k17 "vapaa") ;
lin trait_N = mkWN (compoundN "luonteen" (k48A "piirre")) ; --UNCHK
lin meadow_N = mkWN (k1A "niitty") ; --UNCHK
lin creed_N = mkWN (k5A "oppi") ; --UNCHK
lin unfamiliar_A = mkWA (k34A "tuntematon") ; --UNCHK
lin optimism_N = mkWN (k5 "optimismi") ; --UNCHK
lin wary_A = mkWA (compoundA "epäluu" (k38 "loinen")) ; --UNCHK
lin twist_N = mkWN (k5 "konsti") ; --UNCHK
lin sweet_N = mkWN (k40 "makeus") ; --UNCHK
lin substantive_A = mkA "huomattava" ;
lin excavation_N = mkWN (k9A "louhinta") ; --UNCHK
lin destiny_N = mkWN (k2 "kohtalo") ; --UNCHK
lin thick_Adv = mkWAdv (compoundAdv "perä" (k99 "jälkeen")) ; --UNCHK
lin pasture_N = mkWN (k4A "nurmikko") ; --UNCHK
lin archaeological_A = mkWA (k38 "arkeologinen") ; --UNCHK
lin tick_V2 = mkWV2 (k69 "merkitä") "rastilla" ; --UNCHK
lin tick_V = mkWV (k69 "merkitä") "rastilla" ; --UNCHK
lin profit_V2 = mkWV2 (k63 "saada") "voittoa" ; --UNCHK
lin profit_V = mkWV (k63 "saada") "voittoa" ; --UNCHK
lin pat_V2 = mkWV2 (k53A "taputtaa") ; --UNCHK
lin pat_V = mkWV (k53A "taputtaa") ; --UNCHK
lin papal_A = mkWA (k38 "paavillinen") ; --UNCHK
lin cultivate_V2 = mkWV2 (k67 "viljellä") ; --UNCHK
lin awake_V = mkWV (k52A "havahtua") ; --UNCHK
lin trained_A = variants{} ; -- 
lin civic_A = mkWA "kansalais-" ; --UNCHK
lin voyage_N = mkWN (k9 "matka") ; --UNCHK
lin siege_N = mkWN (k1A "saarto") ; --UNCHK
lin enormously_Adv = variants{} ; -- 
lin distract_V2 = mkWV2 (k52 "huolestua") ; --UNCHK
lin distract_V = mkWV (k52 "huolestua") ; --UNCHK
lin stroll_V = mkWV (k67 "käveleskellä") ; --UNCHK
lin jewel_N = mkWN (k50 "jalokivi") ; --UNCHK
lin honourable_A = mkWA (k38 "kunniallinen") ; --UNCHK
lin helpless_A = mkWA (k34A "avuton") ; --UNCHK
lin hay_N = mkWN (k10 "heinä") ; --UNCHK
lin expel_V2 = mkWV2 (k53A "erottaa") ;
lin eternal_A = mkWA (k34A "päättymätön") ; --UNCHK
lin demonstrator_N = mkWN (compoundN "mielen" (k10 "osoittaja")) ; --UNCHK
lin correction_N = mkWN (k2 "oikaisu") ; --UNCHK
lin civilization_N = mkWN (k40 "sivistyneisyys") ; --UNCHK
lin ample_A = mkWA (k41 "runsas") ; --UNCHK
lin retention_N = mkWN "pitäminen" ; --UNCHK
lin rehabilitation_N = mkWN (k39 "kunnostus") ; --UNCHK
lin premature_A = mkWA (compoundA "ennen" (k38 "aikainen")) ;
lin encompass_V2 = mkWV2 (k53A "käsittää") ; --UNCHK
lin distinctly_Adv = variants{} ; -- 
lin diplomat_N = mkWN (k5A "diplomaatti") ; --UNCHK
lin articulate_V2 = mkWV2 (k52 "lausua") ; --UNCHK
lin articulate_V = mkWV (k52 "lausua") ; --UNCHK
lin restricted_A = variants{} ; -- 
lin prop_V2 = mkWV2 (k53A "pönkittää") partitive ;
lin intensify_V2 = mkV2 "syventää" partitive ;
lin intensify_V = mkWV (k54A "syventää") ;
lin deviation_N = mkN "poikkeama" ; --mkWN (compoundN "kierto" (k19 "tie")) ;
lin contest_V2 = mkWV2 (k53 "kyseenalaistaa") ; --UNCHK
lin contest_V = mkWV (k53 "kyseenalaistaa") ; --UNCHK
lin workplace_N = mkWN (compoundN "työ" (k9A "paikka")) ; --UNCHK
lin lazy_A = mkWA (k1A "veltto") ; --UNCHK
lin kidney_N = mkWN (k38 "munuainen") ; --UNCHK
lin insistence_N = mkWN (k39 "vaatimus") ;
lin whisper_N = mkWN (k40 "äänettömyys") ; --UNCHK
lin multimedia_N = mkWN (compoundN "multimedia" (k10 "järjestelmä")) ; --UNCHK
lin forestry_N = mkWN (compoundN "metsätalous" (k48A "tiede")) ; --UNCHK
lin excited_A = variants{} ; -- 
lin decay_N = mkWN (compoundN "mätä" (k38 "neminen")) ; --UNCHK
lin screw_N = mkWN (k5 "seksi") ; --UNCHK
lin rally_V2V = mkWV2V (k52A "toipua") ; --UNCHK
lin rally_V2 = mkV2 "koota" ; --mkWV2 (k52A "toipua") ;
lin rally_V = mkV "kilpailla" ; ---ARB WV (k52A "toipua") ;
lin pest_N = mkWN (k38 "tuholainen") ; --UNCHK
lin invaluable_A = mkWA (k34A "korvaamaton") ; --UNCHK
lin homework_N = mkWN (compoundN "valmis" (k38 "tautuminen")) ; --UNCHK
lin harmful_A = mkWA (k38 "vahingollinen") ;
lin bump_V2 = mkWV2 (k73 "törmätä") ; --UNCHK
lin bump_V = mkWV (k73 "törmätä") ; --UNCHK
lin bodily_A = mkWA (k38 "ruumiillinen") ; --UNCHK
lin grasp_N = mkWN (k48A "ote") ; --UNCHK
lin finished_A = variants{} ; -- 
lin facade_N = mkWN (k5 "fasadi") ; --UNCHK
lin cushion_N = mkWN (k1 "tyyny") ;
lin conversely_Adv = variants{} ; -- 
lin urge_N = mkWN (k5A "vietti") ; --UNCHK
lin tune_V2 = mkWV2 (k53A "säätää") ; --UNCHK
lin tune_V = mkV "virittyä" ; --mkWV (k53A "säätää") ;
lin solvent_N = mkWN (k39 "vastaus") ; --UNCHK
lin slogan_N = mkN "isku" (mkN "lause") ; --mkWN (k5 "fraasi") ;
lin petty_A = mkWA (k38 "pikkumainen") ; --UNCHK
lin perceived_A = variants{} ; -- 
lin install_V2 = mkV2 "asentaa" ;
lin install_V = mkV "asentua" ;
lin fuss_N = mkWN (k39 "touhotus") ; --UNCHK
lin rack_N = mkWN (compoundN "tasa" (k5A "käynti")) ; --UNCHK
lin imminent_A = mkWA (k10 "tuleva") ; --UNCHK
lin short_N = mkN "lyhyt" ; ----TODO "one who operates on the short side of the market"
lin revert_V = mkWV (k52A "palautua") ; --UNCHK
lin ram_N = mkWN (k5 "pässi") ; --UNCHK
lin contraction_N = mkWN (k39 "supistus") ;
lin tread_V2 = mkWV2 (k53A "jännittää") ; --UNCHK
lin tread_V = mkWV (k53A "jännittää") ; --UNCHK
lin supplementary_A = mkWA "täydennetty" ; --UNCHK
lin ham_N = mkWN (k1A "kinkku") ; --UNCHK
lin defy_V2V = mkWV2V (k56 "haastaa") ; --UNCHK
lin defy_V2 = mkWV2 (k56 "haastaa") ;
lin athlete_N = mkWN (k5A "atleetti") ; --UNCHK
lin sociological_A = mkWA (k38 "sosiologinen") ; --UNCHK
lin physician_N = mkWN (k6 "tohtori") ; --UNCHK
lin crossing_N = mkWN (k39 "ylitys") ; --UNCHK
lin bail_N = mkWN (k17 "takuu") ; --UNCHK
lin unwanted_A = mkWA (compoundA "ei-" (k1A "toivottu")) ;
lin tight_Adv = mkWAdv (k99 "lujasti") ;
lin plausible_A = mkWA (k10 "uskottava") ; --UNCHK
lin midfield_N = mkWN (compoundN "keski" (k10A "kenttä")) ; --UNCHK
lin alert_A = mkWA (k15 "virkeä") ; --UNCHK
lin feminine_A = mkWA (k38 "naisellinen") ; --UNCHK
lin drainage_N = mkWN (k39 "kuivatus") ; --UNCHK
lin cruelty_N = mkWN (k2 "kohtelu") "epäinhimillinen" ; --UNCHK
lin abnormal_A = mkWA (k10 "poikkeava") ; --UNCHK
lin relate_N = variants{} ; -- 
lin poison_V2 = mkWV2 (k53A "myrkyttää") ; --UNCHK
lin symmetry_N = mkWN (k12 "symmetria") ; --UNCHK
lin stake_V2 = mkWV2 (k73 "riskeerata") ; ---ARB
lin rotten_A = L.rotten_A ;
lin prone_A = mkWA (k99 "rähmällään") ; --UNCHK
lin marsh_N = mkWN (k1A "letto") ; --UNCHK
lin litigation_N = mkN "riita" ;
lin curl_N = mkWN (k12 "kiehkura") ; --UNCHK
lin urine_N = mkWN (k5 "pissi") ; --UNCHK
lin latin_A = mkWA (k38 "latinalainen") ; --UNCHK
lin hover_V = mkV "leijua" ;
lin greeting_N = mkWN (k39 "tervehdys") ; --UNCHK
lin chase_N = mkWN (kH1 "jahti") ; --UNCHK
lin spouseMasc_N = variants{} ; -- 
lin produce_N = mkWN (k1A "sato") ; --UNCHK
lin forge_V2 = mkV2 "takoa" partitive ; --mkWV2 (k73A "kekata") ;
lin forge_V = mkWV (k73A "kekata") ; --UNCHK
lin salon_N = mkWN (k5A "salonki") ; --UNCHK
lin handicapped_A = variants{} ; -- 
lin sway_V2 = mkV2 "huojuttaa" ; --WV2 (k52A "keikkua") ;
lin sway_V = mkV "huojua" ; --mkWV (k52A "keikkua") ;
lin homosexual_A = mkWA (k1 "homo") ; --UNCHK
lin handicap_V2 = mkWV2 (k52A "vammautua") ; --UNCHK
lin colon_N = mkWN (k50 "paksusuoli") ; --UNCHK
lin upstairs_N = mkWN (compoundN "ylä" (k9A "kerta")) ; --UNCHK
lin stimulation_N = mkWN (k39 "kiihotus") ; --UNCHK
lin spray_V2 = mkWV2 (k53A "suihkuttaa") ; --UNCHK
lin original_N = mkWN (k5 "originaali") ; --UNCHK
lin lay_A = mkWA "maallikko-" ; --UNCHK
lin garlic_N = mkWN (k9A "kynsilaukka") ; --UNCHK
lin suitcase_N = mkWN (compoundN "matka" (k1A "laukku")) ; --UNCHK
lin skipper_N = mkWN (k6 "kapteeni") ; --UNCHK
lin moan_VS = mkWVS (k73 "purnata") ; --UNCHK
lin moan_V = mkWV (k73 "purnata") ; --UNCHK
lin manpower_N = mkWN (k2 "miehistö") ; --UNCHK
lin manifest_V2 = mkWV2 (k52 "ilmestyä") ; --UNCHK
lin incredibly_Adv = variants{} ; -- 
lin historically_Adv = variants{} ; -- 
lin decision_making_N = variants{} ; -- 
lin wildly_Adv = variants{} ; -- 
lin reformer_N = mkWN "uudistin" ; --UNCHK
lin quantum_N = mkWN (k5A "kvantti") ; --UNCHK
lin considering_Subj = variants{} ; -- 
}
