concrete DictionaryTha of Dictionary = CatTha **
open ParadigmsTha, ResTha, Prelude in {


-- (c) AR 2011-2015 in collaboration with Chotiros Kairoje, under LGPL

flags coding = utf8 ;


oper poss = "ของ" ;
oper mkInterj : Str -> Interj = \s -> lin Interj (ss s) ;
oper mkVV : Str -> VV = \s -> lin VV {s = s ; typ = VVPost} ;
oper mmkVS : Str -> VS = \s -> mkVS (mkV s) ;
oper mmkVA : Str -> VA = \s -> mkVA (mkV s) ;
oper mmkVQ : Str -> VQ = \s -> mkVQ (mkV s) ;
oper mmkV2V : Str -> V2V = \s -> mkV2V (mkV s) [] [] ;
oper mmkV2A : Str -> V2A = \s -> mkV2A (mkV s) [] [] ;
oper mmkV2S : Str -> V2S = \s -> mkV2S (mkV s) [] ;
oper prepV2 : V -> Prep -> V2 = \v,p -> mkV2 v p.s ;
oper advV : V -> Adv -> V = \v,a -> mkV v.s1 (thbind v.s2 a.s) ; ----


lin aardvark_N = mkN "ตัวกินมด" ; -- src=panlex
lin aba_N = mkN "ชุดอาบา" | mkN "ผ้าอาบา" | mkN "ชุดชาวอาหรับ" ; -- src=panlex
lin aback_Adv = mkAdv "ผงะ" | mkAdv "ถอยหลัง" | mkAdv "งงงวย" | mkAdv "ตกตะลึง" | mkAdv "ถอยหลัง" ; -- src=panlex
lin abacus_N = mkN "ลูกคิด" | mkN "ลูกคิด" ; -- src=panlex
lin abaft_Adv = mkAdv "ข้างหลัง" | mkAdv "ท้ายเรือ" | mkAdv "ข้างหลัง" | mkAdv "ไปทางข้างหลัง" ; -- src=panlex
lin abaft_Prep = mkPrep "ข้างหลัง" | mkPrep "ไปทางท้าย" | mkPrep "ไปทางข้างหลัง" | mkPrep "ไปทางท้ายเรือ" ; -- src=panlex
lin abalone_N = mkN "หอยโข่งทะเล" ; -- src=panlex
lin abampere_N = mkN "แอบแอมแปร์" | mkN "10 แอมป์" ; -- src=panlex
lin abandon_N = mkN "ความเอาแต่ใจตนเอง" | mkN "การปลดปล่อย" | mkN "การปลดปล่อยอารมณ์" ; -- src=panlex
lin abandonment_N = mkN "ยอมแพ้" | mkN "การยอมสละ" | mkN "การสละ" | mkN "การละทิ้ง" | mkN "การทอดทิ้ง" ; -- src=panlex
lin abasement_N = mkN "การลบหลู่" | mkN "การเสื่อม" ; -- src=panlex
lin abashment_N = mkN "ความขี้อาย" | mkN "การทําให้อาย" ; -- src=panlex
lin abasic_A = mkA "ที่เดินไม่ได้" ; -- src=panlex
lin abate_V = mkV "ซา" | mkV "บรรเทา" | mkV "ลดความรุนแรง" | mkV "ลดลง" | mkV "น้อยลง" | mkV "บรรเทา" | mkV "เบาบาง" | mkV "สิ้นสุด" | mkV "ทําให้น้อยลง" | mkV "ทําให้สิ้นสุด" ; -- src=panlex
lin abate_V2 = mkV2 "ซา" ; ---- | mkV "บรรเทา" | mkV "ลดความรุนแรง" | mkV "ลดลง" | mkV "น้อยลง" | mkV "บรรเทา" | mkV "เบาบาง" | mkV "สิ้นสุด" | mkV "ทําให้น้อยลง" | mkV "ทําให้สิ้นสุด" ; -- src=panlex
lin abatement_N = mkN "การลดลง" ; -- src=panlex
lin abattoir_N = mkN "โรงชำแหละ" | mkN "โรงฆ่าสัตว์" | mkN "โรงฆ่าสัตว์" ; -- src=panlex
lin abaxial_A = mkA "ซึ่งอยู่ห่างจากแกน" | mkA "ซึ่งอยู่ห่างจากแกน" ; -- src=panlex
lin abaya_N = mkN "อาบาย่า" | mkN "ชุดอาบาย่า" ; -- src=panlex
lin abbacy_N = mkN "ตำแหน่งอธิการวัด" | mkN "อํานาจของอธิการในวัดวาอาราม" ; -- src=panlex
lin abbatial_A = mkA "ที่เป็นของวัด" | mkA "ซึ่งเกี่ยวกับอธิการวัดวาอาราม" ; -- src=panlex
lin abbess_N = mkN "แม่อธิการ" | mkN "บาทหลวงหญิง" | mkN "หัวหน้าสํานักแม่ชี" ; -- src=panlex
lin abbey_N = mkN "วัด" | mkN "สํานักสงฆ์" ; -- src=panlex
lin abbot_N = mkN "เจ้าอาวาส" | mkN "เจ้าวัด" | mkN "อธิการวัด" | mkN "เจ้าอาราม" | mkN "เจ้าอาวาส" ; -- src=panlex
lin abbreviation_N = mkN "คำย่อ" | mkN "อักษรย่อ" | mkN "การย่อ" | mkN "คําย่อ" | mkN "ตัวย่อ" | mkN "ชื่อย่อ" | mkN "อักษรย่อ" | mkN "การตัดทอน" ; -- src=panlex
lin abdicate_V = mkV "สละราชสมบัติ" | mkV "สละราชบัลลังก์" | mkV "สละอํานาจ" | mkV "ละเลยหน้าที่" | mkV "สละราชสมบัติ" | mkV "สละราชบัลลังก์" | mkV "ทําให้สละอํานาจ" | mkV "ทําให้สละราชสมบัติ" | mkV "ทําให้สละราชบัลลังก์" ; -- src=panlex
lin abdicate_V2 = mkV2 "สละราชสมบัติ" ; ---- | mkV "สละราชบัลลังก์" | mkV "สละอํานาจ" | mkV "ละเลยหน้าที่" | mkV "สละราชสมบัติ" | mkV "สละราชบัลลังก์" | mkV "ทําให้สละอํานาจ" | mkV "ทําให้สละราชสมบัติ" | mkV "ทําให้สละราชบัลลังก์" ; -- src=panlex
lin abdication_N = mkN "การสละอำนาจ" | mkN "การลงจากอำนาจ" | mkN "การสละราชสมบัติ" | mkN "การสละราชสมบัติ" ; -- src=panlex
lin abdomen_N = mkN "พุง" | mkN "ท้อง" | mkN "พระอุทร" | mkN "พุงกะทิ" | mkN "ช่องท้อง" | mkN "โพรงท้อง" | mkN "พุง" | mkN "ท้อง" | mkN "ช่องท้อง" ; -- src=panlex
lin abdominal_A = mkA "ส่วนท้อง" | mkA "ตรงช่องท้อง" | mkA "เกี่ยวกับท้อง" | mkA "ซึ่งเกี่ยวกับช่องท้อง" ; -- src=panlex
lin abdominal_N = mkN "กล้ามเนื้อบริเวณท้อง" ; -- src=panlex
lin abdominocentesis_N = mkN "ศัลยกรรมการเจาะ" ; -- src=panlex
lin abdominoplasty_N = mkN "การตัดไขมันหน้าท้อง" ; -- src=panlex
lin abdominous_A = mkA "พุงยื่น" | mkA "พุงหลาม" | mkA "พุงอ้วน" | mkA "พุงพลุ้ย" | mkA "ซึ่งมีพุงใหญ่" ; -- src=panlex
lin abdominovesical_A = mkA "เกี่ยวกับกระเพาะปัสสาวะ" ; -- src=panlex
lin abducent_A = mkA "ซึ่งดึงออก" | mkA "ดึงออก" | mkA "ซึ่งลักพา" | mkA "ซึ่งดึงออก" ; -- src=panlex
lin abduction_N = mkN "การลักพาตัว" ; -- src=panlex
lin abductor_N = mkN "โจรลักพาตัว" | mkN "โจรเรียกค่าไถ่" | mkN "กล้ามเนื้อแอ็บดัคเตอร์" ; -- src=panlex
lin abeam_Adv = mkAdv "ตามขวางเรือ" | mkAdv "ตามขวางและข้างเรือ" | mkAdv "ซึ่งเป็นมุมฉากกับแนวหน้าและหลัง" ; -- src=panlex
lin abecedarian_A = mkA "มูลฐาน" | mkA "ขั้นต้น" | mkA "เบื้องต้น" | mkA "เรียงตามลําดับพยัญชนะ" ; -- src=panlex
lin abecedarian_N = mkN "มูลฐาน" | mkN "ขั้นต้น" | mkN "เบื้องต้น" | mkN "เรียงตามลําดับพยัญชนะ" ; -- src=panlex
lin abed_Adv = mkAdv "บนหลังม้า" | mkAdv "บนเตียง" | mkAdv "ล้มป่วยลง" ; -- src=panlex
lin abelmosk_N = mkN "ต้นไม้เมืองร้อนชนิดหนึ่ง" ; -- src=panlex
lin aberrance_N = mkN "สภาวะผิดปกติ" ; -- src=panlex
lin aberrant_A = mkA "ซึ่งเบี่ยงเบนจากปกติ" ; -- src=panlex
lin aberration_N = mkN "การขัดคำสั่ง" | mkN "สภาวะผิดปกติ" | mkN "การผิดสัดส่วน" | mkN "ความคลาดเคลื่อน" | mkN "ความผิดปกติ" | mkN "การเบี่ยงเบนจากปกติ" ; -- src=panlex
lin abet_V = mkV "เป็นใจ" | mkV "ให้กําลังใจ" | mkV "กระตุ้นความรู้สึกให้ดีขึ้น" ; -- src=panlex
lin abet_V2 = mkV2 "เป็นใจ" ; ---- | mkV "ให้กําลังใจ" | mkV "กระตุ้นความรู้สึกให้ดีขึ้น" ; -- src=panlex
lin abetalipoproteinemia_N = mkN "โรคเลือดไร้บีตาลิโพโปรตีน" ; -- src=panlex
lin abetment_N = mkN "การให้กําลังใจ" ; -- src=panlex
lin abettor_N = mkN "ผู้ยุยงส่งเสริม" ; -- src=panlex
lin abeyance_N = mkN "การหยุดพักชั่วคราว" | mkN "การระงับไว้ชั่วคราว" ; -- src=panlex
lin abeyant_A = mkA "ที่หยุดชั่วคราว" | mkA "ซึ่งระงับชั่วคราว" ; -- src=panlex
lin abfarad_N = mkN "แอ็บฟาเรด" ; -- src=panlex
lin abhenry_N = mkN "แอ็บเฮนดรี" ; -- src=panlex
lin abhorrence_N = mkN "ความชิงชัง" | mkN "ความรังเกียจ" | mkN "ความเกลียดชัง" | mkN "ความชิงชัง" | mkN "ความเกลียดชัง" | mkN "ผู้ถูกเกลียดชัง" | mkN "สิ่งหรือผู้ที่ถูกเกลียดชัง" ; -- src=panlex
lin abidance_N = mkN "การพักอาศัย" ; -- src=panlex
lin abide_V = mkV "ทน" | mkV "พัก" | mkV "อดทน" | mkV "พำนัก" | mkV "ยอมทน" | mkV "อดกลั้น" | mkV "ทน" | mkV "อดทน" | mkV "อยู่" | mkV "ทนต่อ" | mkV "ยอมทน" | mkV "รอคอย" | mkV "อาศัย" | mkV "พักอาศัย" | mkV "อาศัยอยู่" ; -- src=panlex
lin abide_V2 = mkV2 "ทน" ; ---- | mkV "พัก" | mkV "อดทน" | mkV "พำนัก" | mkV "ยอมทน" | mkV "อดกลั้น" | mkV "ทน" | mkV "อดทน" | mkV "อยู่" | mkV "ทนต่อ" | mkV "ยอมทน" | mkV "รอคอย" | mkV "อาศัย" | mkV "พักอาศัย" | mkV "อาศัยอยู่" ; -- src=panlex
lin abient_A = mkA "ที่ชอบหลีกเลี่ยง" ; -- src=panlex
lin ability_N = mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "พรสวรรค์" | mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "ความมีทักษะ" | mkN "ความมีฝีมือ" | mkN "ที่คงอยู่ตลอดไป" ; -- src=panlex
lin abiogenesis_N = mkN "สปอนเทเนียสเจเนอเรชัน" | mkN "สมมติฐานที่ว่าสิ่งมีชีวิตเกิดขึ้นได้จากสิ่งไม่มีชีวิต" ; -- src=panlex
lin abiogenetic_A = mkA "ที่กำเนิดขึ้นจากสิ่งไม่มีชีวิต" ; -- src=panlex
lin abject_A = mkA "ต่ําช้า" | mkA "ถ่อมตัว" | mkA "เลวทราม" | mkA "น่าสงสาร" | mkA "น่าสังเวช" | mkA "น่าสังเวชใจ" ; -- src=panlex
lin abjection_N = mkN "การเสื่อม" ; -- src=panlex
lin abjuration_N = mkN "การกลับคำ" ; -- src=panlex
lin ablactation_N = mkN "การหยุดหลั่งน้ำนม" | mkN "การหยุดนม" ; -- src=panlex
lin ablation_N = mkN "การตัดออก" | mkN "การผ่าออก" | mkN "การเสียดกร่อน" | mkN "การเสียดละลาย" ; -- src=panlex
lin ablative_A = mkA "ที่มีแนวโน้มจะระเหย" ; -- src=panlex
lin ablative_N = mkN "การกแหล่งที่มา" ; -- src=panlex
lin ablaut_N = mkN "การเปลี่ยนส่วนของคํา" ; -- src=panlex
lin ablaze_A = mkA "อยาก" | mkA "ไหม้" | mkA "สว่าง" | mkA "กระหาย" | mkA "เจิดจ้า" | mkA "ตื่นเต้น" | mkA "ต้องการมาก" ; -- src=panlex
lin able_A = mkA "สามารถ" | mkA "เก่ง" | mkA "สามารถ" | mkA "มีฝีมือ" | mkA "สมบูรณ์" | mkA "หลักแหลม" | mkA "ที่มีทักษะดี" | mkA "มีคุณสมบัติตามกฎเกณฑ์" | mkA "ที่มีความสามารถที่จะทําได้" ; -- src=panlex
lin ableism_N = mkN "การกีดกันในเรื่องสภาพร่างกาย" ; -- src=panlex
lin abloom_A = mkA "บาน" | mkA "กําลังบาน" ; -- src=panlex
lin ablution_N = mkN "การชําระล้าง" ; -- src=panlex
lin abnegation_N = mkN "การละทิ้ง" | mkN "การไม่ยอมรับ" | mkN "การสละ" | mkN "การละทิ้ง" ; -- src=panlex
lin abnormal_A = mkA "ผิดปรกติ" | mkA "ที่ไม่ปกติ" | mkA "แปลก" | mkA "ผิดปกติ" | mkA "ผิดแปลก" | mkA "ผิดวิสัย" | mkA "ผิดธรรมดา" ; -- src=panlex
lin abnormality_N = mkN "ความผิดปกติ" | mkN "ความผิดปกติของร่างกาย" | mkN "สภาพผิดปกติ" | mkN "ความผิดปรกติ" ; -- src=panlex
lin aboard_Adv = mkAdv "บนเรือ" | mkAdv "บนแท่น" | mkAdv "อยู่ข้าง" | mkAdv "บนยานพาหนะ" ; -- src=panlex
lin aboard_Prep = mkPrep "บนยานพาหนะ" ; -- src=panlex
lin abode_N = mkN "บ้าน" | mkN "เรือน" | mkN "นิวาสถาน" | mkN "บ้านช่อง" | mkN "ที่อยู่อาศัย" | mkN "บ้าน" | mkN "ที่พัก" | mkN "ที่อยู่อาศัย" ; -- src=panlex
lin abohm_N = mkN "อะโบห์ม" ; -- src=panlex
lin abolition_N = mkN "การเลิก" | mkN "การล้มเลิก" | mkN "การเลิกล้ม" ; -- src=panlex
lin abolitionism_N = mkN "ลัทธิการเลิกทาส" | mkN "การเลิกทาส" ; -- src=panlex
lin abolitionist_N = mkN "นักรณรงค์การยกเลิกระบบทาส" | mkN "ผู้ที่เห็นด้วยกับการเลิกทาส" ; -- src=panlex
lin abomasum_N = mkN "กระเพาะอะโบมาซัม" ; -- src=panlex
lin abominable_A = mkA "น่าชัง" | mkA "น่ารําคาญ" | mkA "น่ารังเกียจ" | mkA "เลวมากที่สุด" | mkA "เลวทรามต่ําช้า" ; -- src=panlex
lin abomination_N = mkN "ความชิงชัง" | mkN "ความรังเกียจ" | mkN "ความเกลียดชัง" | mkN "การกระทำที่ชั่วร้าย" | mkN "บุคคลที่น่ารังเกียจ" | mkN "ความชัง" | mkN "ความชิงชัง" | mkN "สิ่งที่เลวทราม" | mkN "สิ่งที่น่าเกลียดชัง" ; -- src=panlex
lin aboral_A = mkA "ว่งตรงข้ามหรือไปจากปาก" ; -- src=panlex
lin aboriginal_A = mkA "พื้นเมือง" | mkA "ที่อยู่มาดั้งเดิม" | mkA "ที่อยู่มาตั้งแต่แรก" ; -- src=panlex
lin aborigine_N = mkN "คนพื้นเมือง" | mkN "ชนพื้นเมืองดั้งเดิม" ; -- src=panlex
lin abort_V = mkV "แท้ง" | mkV "ทำแท้ง" | mkV "ยกเลิก" | mkV "รีดลูก" | mkV "รีดเด็ก" | mkV "เอาเด็กออก" | mkV "แท้ง" | mkV "แท้งลูก" | mkV "แท้งบุตร" | mkV "ไม่เป็นผล" | mkV "ทําให้ล้มเหลว" ; -- src=panlex
lin abort_V2 = mkV2 "แท้ง" ; ---- | mkV "ทำแท้ง" | mkV "ยกเลิก" | mkV "รีดลูก" | mkV "รีดเด็ก" | mkV "เอาเด็กออก" | mkV "แท้ง" | mkV "แท้งลูก" | mkV "แท้งบุตร" | mkV "ไม่เป็นผล" | mkV "ทําให้ล้มเหลว" ; -- src=panlex
lin aborticide_N = mkN "ยาทำแท้ง" | mkN "ยาขับทารก" | mkN "ยาแท้งบุตร" | mkN "การทำลายทารกในครรภ์" | mkN "การทําแท้ง" | mkN "สารที่ทําให้เกิดการแท้ง" ; -- src=panlex
lin abortifacient_A = mkA "ที่ทําให้แท้ง" ; -- src=panlex
lin abortifacient_N = mkN "ยาทำแท้ง" | mkN "ยาขับทารก" | mkN "ยาแท้งบุตร" ; -- src=panlex
lin abortion_N = mkN "แผนการไม่สำเร็จ" | mkN "การยกเลิก" | mkN "การทําแท้ง" | mkN "การแท้งลูก" | mkN "ความล้มเหลว" | mkN "ความไม่สําเร็จ" | mkN "การคลอดก่อนกําหนด" | mkN "ความไม่สามารถไปถึงจุดมุ่งหมาย" ; -- src=panlex
lin abortionistFem_N = variants {} ; ---- sense to be split
lin abortionistMasc_N = variants {} ; ---- sense to be split
lin abortive_A = mkA "แท้ง" | mkA "ไร้ผล" | mkA "ซึ่งมี" | mkA "ซึ่งไร้ผล" | mkA "ไม่สําเร็จ" | mkA "คลอดก่อนกําหนด" | mkA "ซึ่งทําให้แท้ง" | mkA "ซึ่งไม่สําเร็จ" ; -- src=panlex
lin abound_V = mkV "อลเวง" | mkV "มากมาย" | mkV "ชุก" | mkV "ชุม" | mkV "อุดม" | mkV "ชุกชุม" | mkV "มากมาย" | mkV "ดาษดื่น" | mkV "หนาแน่น" | mkV "อุดมสมบูรณ์" ; -- src=panlex
lin about_Adv = mkAdv "หัน" | mkAdv "ทั่ว" | mkAdv "รอบๆ" | mkAdv "เกือบ" | mkAdv "ประมาณ" | mkAdv "จวนเจียน" | mkAdv "ทั่วๆ" | mkAdv "แพร่หลาย" | mkAdv "ในที่ต่างๆ" | mkAdv "ในทิศทางตรงข้าม" ; -- src=panlex
lin about_Prep = mkPrep "รอบ" | mkPrep "ราว" | mkPrep "ราวๆ" | mkPrep "ทั่วๆ" | mkPrep "ประมาณ" | mkPrep "ใกล้กับ" | mkPrep "เกี่ยวกับ" | mkPrep "ในที่ต่างๆ" ; -- src=panlex
lin above_A = mkA "ข้างต้น" ; -- src=panlex
lin above_Adv = mkAdv "เหนือ" | mkAdv "ข้างบน" | mkAdv "ด้านบน" | mkAdv "ข้างต้น" | mkAdv "กว่า" | mkAdv "เกิน" | mkAdv "เหนือ" | mkAdv "สูงกว่า" | mkAdv "พ้นเหลือ" | mkAdv "เบื้องต้น" | mkAdv "เหนือกว่า" | mkAdv "ที่มีอํานาจมากกว่า" ; -- src=panlex
lin above_Prep = ss (thword "ข้าง" "บน") | {-pan-} mkPrep "กว่า" | mkPrep "เกิน" | mkPrep "เหนือ" | mkPrep "ข้างบน" | mkPrep "มากกว่า" | mkPrep "สูงกว่า" | mkPrep "พ้นเหลือ" | mkPrep "ด้านเหนือ" | mkPrep "เบื้องต้น" | mkPrep "เหนือกว่า" | mkPrep "ดีเกินกว่า" | mkPrep "ในทิศเหนือ" | mkPrep "ยากเกินกว่า" | mkPrep "ดังกว่าเสียงอื่น" ; -- src=panlex
lin aboveboard_A = mkA "เปิดเผย" ; -- src=panlex
lin abracadabra_N = mkN "คาถา" | mkN "คาถายันตร์" | mkN "การพูดที่ไร้ความหมาย" ; -- src=panlex
lin abrader_N = mkN "สารขัดถู" ; -- src=panlex
lin abranchiate_A = mkA "ไม่มีเหงือก" ; -- src=panlex
lin abrasion_N = mkN "รอยครูด" | mkN "การครูดไถ" | mkN "การเสียดสี" | mkN "การสึกกร่อน" | mkN "การสึก" | mkN "รอยขัด" | mkN "รอยสึก" | mkN "การถลอก" | mkN "รอยถลอก" | mkN "บริเวณถลอก" | mkN "รอยขีดข่วน" ; -- src=panlex
lin abrasive_A = mkA "ซึ่งกัดเซาะ" | mkA "ซึ่งกัดกร่อน" | mkA "ที่ทําให้โกรธ" | mkA "ที่ทําให้โมโห" | mkA "ที่ทําให้รําคาญ" | mkA "สารหรือสิ่งที่ใช้ขัดหรือถูหรือกัดกร่อน" ; -- src=panlex
lin abrasive_N = mkN "ของมีคม" | mkN "สารขัดถู" | mkN "ผงขัด" | mkN "สารขัด" | mkN "ซึ่งกัดกร่อน" | mkN "สารหรือสิ่งที่ใช้ขัดหรือถูหรือกัดกร่อน" ; -- src=panlex
lin abreast_Adv = mkAdv "เคียงข้าง" | mkAdv "เคียงบ่าเคียงไหล่" ; -- src=panlex
lin abridgement_N = mkN "บทย่อ" | mkN "ฉบับย่อ" | mkN "การย่อ" | mkN "ฉบับย่อ" | mkN "ย่อความ" ; -- src=panlex
lin abridger_N = mkN "คนย่อความ" ; -- src=panlex
lin abroach_A = mkA "ซึ่งเปิดช่องหรือรู" ; -- src=panlex
lin abroad_A = mkA "พิศวง" | mkA "ไปทั่ว" | mkA "ข้างนอก" | mkA "แพร่หลาย" | mkA "ต่างประเทศ" | mkA "ไม่หนักแน่น" | mkA "ไม่ตรงประเด็น" ; -- src=panlex
lin abroad_Adv = mkAdv "ไกล" | mkAdv "ต่างประเทศ" | mkAdv "ไกลบ้านไกลช่อง" | mkAdv "ข้ามน้ำข้ามทะเล" | mkAdv "แพร่" | mkAdv "พิศวง" | mkAdv "ไปทั่ว" | mkAdv "ข้างนอก" | mkAdv "แพร่หลาย" | mkAdv "กว้างขวาง" | mkAdv "ในต่างแดน" | mkAdv "ต่างประเทศ" | mkAdv "แพร่กระจาย" | mkAdv "ในต่างชาติ" | mkAdv "ไม่หนักแน่น" | mkAdv "ในต่างประเทศ" | mkAdv "ไม่ตรงประเด็น" | mkAdv "ที่อยู่ในเมืองนอก" ; -- src=panlex
lin abrocome_N = mkN "ชินชิลลาแรต" ; -- src=panlex
lin abrogation_N = mkN "การยกเลิก" ; -- src=panlex
lin abrupt_A = mkA "ชัน" | mkA "หยาบ" | mkA "ทันที" | mkA "ทันใด" | mkA "คับขัน" | mkA "ฉับพลัน" | mkA "ฉุกเฉิน" | mkA "หยาบคาย" | mkA "ขาดตอนกัน" | mkA "ซึ่งขาดตอน" | mkA "ทันทีทันใด" | mkA "ไม่ติดต่อกัน" | mkA "ปัจจุบันทันด่วน" | mkA "ซึ่งไม่ติดต่อกัน" ; -- src=panlex
lin abruptness_N = mkN "ความลาดชัน" | mkN "ความสูงชัน" | mkN "ความฉับพลัน" | mkN "ความกระทันหัน" | mkN "ความไม่มีมารยาท" ; -- src=panlex
lin abscess_N = mkN "ฝี" | mkN "ฝีหนอง" ; -- src=panlex
lin abscissa_N = mkN "พิกัดที่หนึ่ง" | mkN "จุบนแนวนอน" ; -- src=panlex
lin abscission_N = mkN "การร่วง" | mkN "การตัดออก" | mkN "การหยุดทันที" ; -- src=panlex
lin abscond_V = mkV "เผ่นหนี" | mkV "หนี" | mkV "หลบ" | mkV "หลบหนี" | mkV "หลบๆซ่อนๆ" ; -- src=panlex
lin absconder_N = mkN "ผู้หลบหนีเข้าเมือง" ; -- src=panlex
lin absence_N = mkN "การไม่มี" | mkN "ช่วงเวลาที่ไม่อยู่" | mkN "การขาด" | mkN "การขาดแคลน" | mkN "การไม่อยู่" | mkN "การไม่มีตัวตน" | mkN "การไม่ปรากฏตัว" | mkN "ช่วงเวลาที่ไม่อยู่" | mkN "ระยะเวลาที่ไม่อยู่" ; -- src=panlex
lin absent_A = mkA "ขาด" | mkA "ไม่มา" | mkA "ซึ่งไม่ให้ความสนใจ" ; -- src=panlex
lin absent_Prep = mkPrep "ปราศจาก" ; -- src=panlex
lin absentee_N = mkN "คนที่ไม่อยู่" | mkN "ผู้ที่ไม่มา" | mkN "ผู้ขาดการประชุม" | mkN "ผู้ละเว้นหน้าที่" | mkN "ผู้สละทรัพย์สมบัติ" | mkN "ผู้ที่ไม่เข้าร่วมประชุม" ; -- src=panlex
lin absinthe_N = mkN "แอบซินท์" | mkN "เหล้าแอบซินท์" | mkN "ต้นไม้สีเขียวชนิดหนึ่งที่มีรสขม" ; -- src=panlex
lin absolute_A = mkA "สัมบูรณ์" | mkA "ล้วน" | mkA "เพียวๆ" | mkA "แน่นอน" | mkA "ทั้งหมด" | mkA "สมบูรณ์" | mkA "เด็ดขาด" | mkA "แท้จริง" | mkA "เผด็จการ" | mkA "ไม่จํากัด" | mkA "ไม่เจือปน" | mkA "ไม่มีขอบเขต" | mkA "อย่างแท้จริง" ; -- src=panlex
lin absolute_N = mkN "กฎซึ่งเป็นจริงเสมอ" ; -- src=panlex
lin absoluteness_N = mkN "ความสัมบูรณ์" ; -- src=panlex
lin absolution_N = mkN "การยกเว้น" | mkN "การอภัยโทษ" | mkN "นิรโทษกรรม" | mkN "การชําระบาป" | mkN "การให้อภัยบาป" | mkN "การสวดอ้อนวอนให้อภัยโทษ" ; -- src=panlex
lin absolutism_N = mkN "เผด็จการ" | mkN "ลัทธิสตาลิน" | mkN "ลัทธิเบ็ดเสร็จนิยม" | mkN "การปกครองแบบเผด็จการ" | mkN "การปกครอบแบบเผด็จการ" | mkN "ระบบเผด็จการทางการเมือง" ; -- src=panlex
lin absolutist_A = mkA "ที่รวบอำนาจ" | mkA "เกี่ยวกับระบบเผด็จการ" ; -- src=panlex
lin absorbable_A = mkA "ที่ดูดซึมได้" ; -- src=panlex
lin absorbent_A = mkA "ซึ่งอุ้มน้ำไว้" | mkA "ยาดูดซึม" | mkA "ซึ่งไม่สะท้อน" | mkA "ซึ่งอุ้มน้ําไว้" | mkA "ซึ่งสามารถดูดซึม" ; -- src=panlex
lin absorbent_N = mkN "ตัวดูดกลืน" | mkN "วัสดุดูดกลืน" | mkN "ยาดูดซึม" | mkN "ซึ่งสามารถดูดซึม" ; -- src=panlex
lin absorber_N = mkN "ตัวดูดกลืนรังสี" ; -- src=panlex
lin absorbing_A = mkA "ที่น่าสนใจมาก" | mkA "ที่ดึงดูดความสนใจ" ; -- src=panlex
lin absorption_N = mkN "การดูดซึม" | mkN "การตั้งสมาธิ" | mkN "ความหมกหมุ่น" | mkN "การผสมกลมกลืน" | mkN "การรวบรวมสมาธิ" | mkN "การมีสมาธิจดจ่อ" | mkN "การรับ" | mkN "การดูดซึม" | mkN "การหมกมุ่น" | mkN "การไม่สะท้อนกลับ" | mkN "การรวมเข้าด้วยกัน" ; -- src=panlex
lin abstain_V = mkV "งด" | mkV "เว้น" | mkV "ละเว้น" | mkV "งดออกเสียง" | mkV "งดเว้น" | mkV "ละเว้น" | mkV "ไม่ลงคะแนนเสียง" | mkV "นอนหลับทับสิทธิ์" ; -- src=panlex
lin abstainer_N = mkN "นักบวช" | mkN "คนไม่กินเหล้า" | mkN "ผู้ไม่ดื่มสุรา" ; -- src=panlex
lin abstemious_A = mkA "พอประมาณ" | mkA "พอประมาณ" | mkA "ตามอัตภาพ" ; -- src=panlex
lin abstemiousness_N = mkN "การรู้จักระงับตนเอง" | mkN "การรู้จักบันยะบันยัง" ; -- src=panlex
lin abstention_N = mkN "การงด" | mkN "การละเว้น" ; -- src=panlex
lin abstinence_N = mkN "ความพอเหมาะ" | mkN "ความพอประมาณ" | mkN "การบังคับใจตนเอง" | mkN "การบังคับใจตัวเอง" ; -- src=panlex
lin abstinent_A = mkA "ไม่มูมมาม" ; -- src=panlex
lin abstract_A = mkA "นามธรรม" | mkA "เชิงนามธรรม" | mkA "ที่เป็นนามธรรม" | mkA "ถอด" | mkA "ถอน" | mkA "ลอย ๆ" | mkA "เฉย ๆ" | mkA "ควัก" | mkA "สรุป" | mkA "นามธรรม" | mkA "ทางทฤษฎี" | mkA "รายการย่อ" | mkA "ทางวิชาการ" | mkA "ทางหลักการ" | mkA "ไม่มีตัวตน" | mkA "ทางหลักวิชา" | mkA "ที่เป็นนามธรรม" ; -- src=panlex
lin abstract_N = mkN "นามธรรม" | mkN "บทคัดย่อ" | mkN "ข้อสรุป" | mkN "บทคัดย่อ" | mkN "ประเด็นสําคัญ" | mkN "ความคิดในทางทฤษฎี" ; -- src=panlex
lin abstraction_N = mkN "นามธรรม" | mkN "ภาพนามธรรม" | mkN "ภาพแอบสแตรค" | mkN "ภาพเชิงนามธรรม" | mkN "จิตรกรรมนามธรรม" | mkN "ภาพศิลปะนามธรรม" | mkN "ภาพจิตรกรรมนามธรรม" | mkN "สิ่งที่เป็นนามธรรม" | mkN "นามธรรม" ; -- src=panlex
lin abstractionism_N = mkN "ศิลปะนามธรรม" | mkN "ศิลปะแอ็บสแตร็กต์" ; -- src=panlex
lin abstractionist_N = mkN "ศิลปินแอ็บสแตรค" | mkN "ศิลปินแนวนามธรรม" ; -- src=panlex
lin abstractness_N = mkN "ความเป็นนามธรรม" ; -- src=panlex
lin abstractor_N = mkN "ผู้สรุปข่าว" ; -- src=panlex
lin abstruse_A = mkA "ซึ่งเข้าใจยาก" | mkA "เร้นลับ" | mkA "ยากที่จะเข้าใจ" ; -- src=panlex
lin abstruseness_N = mkN "ความคลุมเครือ" ; -- src=panlex
lin absurd_A = mkA "ที่ไร้สาระ" | mkA "เหลวไหล" | mkA "โง่เขลา" | mkA "ไร้สาระ" | mkA "น่าหัวเราะ" | mkA "ไร้ความหมาย" | mkA "ที่ไม่เป็นเหตุเป็นผล" ; -- src=panlex
lin absurdity_N = mkN "เรื่องไร้สาระ" | mkN "ความน่าขัน" | mkN "ความไร้สาระ" | mkN "ความไม่เป็นเหตุเป็นผล" ; -- src=panlex
lin abulia_N = mkN "การหมดกำลังจิต" | mkN "โรคจิตเสื่อม" ; -- src=panlex
lin abundance_N = mkN "ความอุดม" | mkN "ความมากมาย" | mkN "ความสมบูรณ์" | mkN "ความอุดมสมบูรณ์" ; -- src=panlex
lin abundant_A = mkA "อุดมสมบูรณ์" | mkA "มากมาย" | mkA "ท่วมท้น" | mkA "ล้นหลาม" | mkA "เยอะแยะ" | mkA "ล้นเหลือ" | mkA "เหลือล้น" | mkA "เหลือเฟือ" | mkA "เต็มเปี่ยม" | mkA "อุดมสมบูรณ์" ; -- src=panlex
lin abuse_N = mkN "การดูถูก" | mkN "การเย้ยหยัน" | mkN "การทารุณกรรม" | mkN "การใช้ในทางที่ผิด" | mkN "การข่มเหง" | mkN "การสบประมาท" | mkN "การกระทําทารุณ" | mkN "การใช้ในทางที่ผิด" | mkN "การปฏิบัติไม่ดีต่อ" ; -- src=panlex
lin abusive_A = mkA "ซึ่งดูถูก" | mkA "ซึ่งไม่ถูกต้อง" | mkA "ซึ่งหมิ่นประมาท" | mkA "ซึ่งเป็นอันตราย" ; -- src=panlex
lin abut_V = mkV "ติด" | mkV "ประชิด" | mkV "จด" | mkV "ชิด" | mkV "ติดกัน" | mkV "ติดกันกับ" ; -- src=panlex
lin abutment_N = mkN "ตอม่อ" | mkN "ที่ค้ํา" | mkN "แรงค้ํา" | mkN "การติดกัน" | mkN "เครื่องยัน" | mkN "เครื่องค้ํา" | mkN "ส่วนที่จดกัน" | mkN "เครื่องรับน้ําหนัก" ; -- src=panlex
lin abutter_N = mkN "ผู้ที่มีที่ดินติดกัน" ; -- src=panlex
lin abvolt_N = mkN "แอบโวลต์" ; -- src=panlex
lin abwatt_N = mkN "แอบวัตต์" | mkN "10-9 วัตต์" ; -- src=panlex
lin abysm_N = mkN "เหว" | mkN "นรกหนึ่ง" | mkN "ห้วงเหวหนึ่ง" ; -- src=panlex
lin abysmal_A = mkA "ลึกระดับก้นสมุทร" | mkA "เหลือเกิน" | mkA "ลึกสุดหยั่ง" | mkA "ใหญ่สุดหยั่ง" ; -- src=panlex
lin abyss_N = mkN "เหว" | mkN "นรก" | mkN "ปลัก" | mkN "อเวจี" | mkN "ขุมนรก" | mkN "เหวลึก" | mkN "ห้วงเหว" | mkN "หุบเหวลึก" | mkN "ความสุดซึ้ง" | mkN "สิ่งที่ลึกมาก" | mkN "สถานการณ์ที่เลวร้าย" ; -- src=panlex
lin abyssal_A = mkA "ลึกระดับก้นสมุทร" | mkA "ลึกซึ้ง" | mkA "สุดหยั่ง" | mkA "วัดไม่ได้" ; -- src=panlex
lin acacia_N = mkN "ต้นอะเคเซีย" ; -- src=panlex
lin academic_A = mkA "ทางวิชาการ" | mkA "ในทางทฤษฎี" | mkA "ด้านวิชาการ" | mkA "ซึ่งคงแก่เรียน" | mkA "ซึ่งไม่เหมาะในทางปฏิบัติ" | mkA "ซึ่งมีลักษณะเป็นนักวิชาการ" ; -- src=panlex
lin academic_N = mkN "นักวิชาการ" | mkN "อาจารย์มหาลัย" | mkN "อาจารย์วิทยาลัย" | mkN "อาจารย์มหาวิทยาลัย" | mkN "อาจารย์หรือนักศึกษามหาวิทยาลัย" ; -- src=panlex
lin academicianFem_N = variants {} ; ---- sense to be split
lin academicianMasc_N = variants {} ; ---- sense to be split
lin academicianship_N = mkN "ตำแหน่งวิชาการ" ; -- src=panlex
lin academy_N = mkN "สำนัก" | mkN "อคาเดมี" | mkN "บัณฑิตยสถาน" | mkN "โรงเรียน" | mkN "สถานศึกษา" | mkN "สถาบันการศึกษา" | mkN "สมาคมส่งเสริมความรู้หรือวัฒนธรรม" ; -- src=panlex
lin acanthion_N = mkN "อะแคนไทออน" ; -- src=panlex
lin acanthoid_A = mkA "ที่เหมือนหนาม" | mkA "ซึ่งเป็นหนาม" ; -- src=panlex
lin acanthotic_A = mkA "ที่หนังหนาขึ้น" ; -- src=panlex
lin acanthus_N = mkN "ชื่อพืชใบเป็นหนามชนิดหนึ่ง" ; -- src=panlex
lin acapnic_A = mkA "เกี่ยวกับภาวะคาร์บอนไดออกซ์ในเลือดต่ำกว่าปรกติ" ; -- src=panlex
lin acariasis_N = mkN "โรคตัวไร" | mkN "ภาวะที่มีแมลง 6 ขา" ; -- src=panlex
lin acaricide_N = mkN "สารกำจัดไร" | mkN "ยาฆ่าแมลงวันจําพวกเห็บ" ; -- src=panlex
lin acarid_N = mkN "เห็บ" | mkN "แมลงจําพวกเห็บ" ; -- src=panlex
lin acarine_N = mkN "อะคารีน" | mkN "แมลงจําพวกเห็บหรือหมัด" ; -- src=panlex
lin acarophobia_N = mkN "อาการกลัวหนอน" ; -- src=panlex
lin acarpelous_A = mkA "ที่ไม่มีคาร์เพล" | mkA "ซึ่งไร้โพรงเกสรตัวเมีย" ; -- src=panlex
lin acarpous_A = mkA "ไม่ออกผล" | mkA "ไม่ให้ผล" ; -- src=panlex
lin acaudate_A = mkA "ที่ไม่มีหาง" ; -- src=panlex
lin acaulescent_A = mkA "ซึ่งไร้ก้าน" | mkA "ซึ่งไม่มีก้าน" ; -- src=panlex
lin accede_V = mkV "ยอมรับ" | mkV "รับตำแหน่ง" | mkV "โอนอ่อนผ่อนตาม" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "เห็นด้วย" | mkV "ขึ้นครองราชย์" | mkV "ขึ้นครองอํานาจ" | mkV "ลงนามในสนธิสัญญา" ; -- src=panlex
lin accelerando_A = mkA "ที่ค่อยๆเพิ่มจังหวะดนตรีให้เร็วขึ้น" ; -- src=panlex
lin accelerando_Adv = mkAdv "อย่างเร่งรีบ" | mkAdv "ค่อยเร็วขึ้น" | mkAdv "อย่างค่อยๆเพิ่มจังหวัดดนตรีให้เร็วให้" ; -- src=panlex
lin accelerate_V = mkV "เร่ง" | mkV "เร่งความเร็ว" | mkV "เร่งความเร็ว" | mkV "เพิ่มความเร็ว" | mkV "เร่งให้เกิดขึ้น" ; -- src=panlex
lin accelerate_V2 = mkV2 "เร่ง" ; ---- | mkV "เร่งความเร็ว" | mkV "เร่งความเร็ว" | mkV "เพิ่มความเร็ว" | mkV "เร่งให้เกิดขึ้น" ; -- src=panlex
lin acceleration_N = mkN "การเร่งความเร็ว" | mkN "การเร่ง" | mkN "ความเร่ง" | mkN "การเพิ่มความเร็ว" ; -- src=panlex
lin accelerative_A = mkA "ซึ่งเพิ่มด้วยอัตราเร่ง" | mkA "ที่เกี่ยวกับการเร่งความเร็ว" ; -- src=panlex
lin accelerator_N = mkN "คันเร่ง" | mkN "ตัวเร่ง" | mkN "อุปกรณ์เร่งอนู" | mkN "ตัวเร่งปฎิกิริยา" | mkN "ตัวเร่งปฏิกิริยา" | mkN "เครื่องเร่งอนุภาค" | mkN "แป้นเหยียบคันเร่ง" | mkN "คันเร่ง" | mkN "ตัวเร่ง" ; -- src=panlex
lin accelerometer_N = mkN "มาตรความเร่ง" | mkN "มาตรวัดความเร่ง" | mkN "มิเตอร์วัดความเร่ง" ; -- src=panlex
lin accent_N = mkN "การเน้น" | mkN "ภาษาถิ่น" | mkN "การเน้นย้ำ" | mkN "การเน้น" | mkN "สําเนียง" | mkN "น้ําเสียง" | mkN "เสียงหนัก" | mkN "เสียงเน้น" | mkN "การเน้นหนัก" | mkN "ลักษณะเฉพาะ" | mkN "การเน้นเสียง" | mkN "ความเน้นหนัก" | mkN "ลักษณะจําพวก" | mkN "สําเนียงเปล่ง" | mkN "เครื่องหมายเสียงหนัก" | mkN "เครื่องหมายแสดงการเน้นเสียง" | mkN "การเน้นเสียงหนักตรงพยางค์หนึ่งพยางค์ใด" ; -- src=panlex
lin accentor_N = mkN "นกแอ็กเซนเตอร์" ; -- src=panlex
lin accentual_A = mkA "เกี่ยวกับการเน้นเสียงหนัก" ; -- src=panlex
lin accept_V = mkV "รับ" | mkV "ตอบรับ" | mkV "ยอมรับ" | mkV "เปิดรับ" | mkV "กล้ำกลืน" | mkV "ทำให้ติด" | mkV "มีหนี้สิน" | mkV "กล้ำกลืนฝืนทน" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "ออกแบบให้รับได้" | mkV "รับ" | mkV "ยอมทน" | mkV "เชื่อ" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "รับเอา" | mkV "ต้อนรับ" | mkV "รับช่วง" | mkV "รับภาระ" | mkV "รับเอามา" | mkV "เห็นด้วย" | mkV "รับผิดชอบ" | mkV "รับคําเชิญ" | mkV "เห็นด้วยกับ" | mkV "ยอมรับว่าจริง" | mkV "ยอมรับการตําหนิ" | mkV "ยอมรับเข้ากลุ่ม" | mkV "ทําให้ผ่านกระบวนการ" ; -- src=panlex
lin accept_V2 = mkV2 "รับ" ; ---- | mkV "ตอบรับ" | mkV "ยอมรับ" | mkV "เปิดรับ" | mkV "กล้ำกลืน" | mkV "ทำให้ติด" | mkV "มีหนี้สิน" | mkV "กล้ำกลืนฝืนทน" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "ออกแบบให้รับได้" | mkV "รับ" | mkV "ยอมทน" | mkV "เชื่อ" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "รับเอา" | mkV "ต้อนรับ" | mkV "รับช่วง" | mkV "รับภาระ" | mkV "รับเอามา" | mkV "เห็นด้วย" | mkV "รับผิดชอบ" | mkV "รับคําเชิญ" | mkV "เห็นด้วยกับ" | mkV "ยอมรับว่าจริง" | mkV "ยอมรับการตําหนิ" | mkV "ยอมรับเข้ากลุ่ม" | mkV "ทําให้ผ่านกระบวนการ" ; -- src=panlex
lin accept_VS = mmkVS "รับ" ; ---- | mkV "ตอบรับ" | mkV "ยอมรับ" | mkV "เปิดรับ" | mkV "กล้ำกลืน" | mkV "ทำให้ติด" | mkV "มีหนี้สิน" | mkV "กล้ำกลืนฝืนทน" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "ออกแบบให้รับได้" | mkV "รับ" | mkV "ยอมทน" | mkV "เชื่อ" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "รับเอา" | mkV "ต้อนรับ" | mkV "รับช่วง" | mkV "รับภาระ" | mkV "รับเอามา" | mkV "เห็นด้วย" | mkV "รับผิดชอบ" | mkV "รับคําเชิญ" | mkV "เห็นด้วยกับ" | mkV "ยอมรับว่าจริง" | mkV "ยอมรับการตําหนิ" | mkV "ยอมรับเข้ากลุ่ม" | mkV "ทําให้ผ่านกระบวนการ" ; -- src=panlex
lin acceptable_A = mkA "ที่น่าพอใจ" | mkA "ซึ่งเป็นที่ยอมรับ" | mkA "ถูกใจ" | mkA "น่ายินดี" | mkA "เห็นด้วย" | mkA "ยอมรับได้" | mkA "ี่น่าพอใจ" | mkA "ที่ยอมรับได้" | mkA "สามารถรับได้" | mkA "ซึ่งยอมรับได้" | mkA "ซึ่งเป็นที่ยอมรับ" | mkA "ซึ่งได้รับการเห็นชอบ" ; -- src=panlex
lin acceptance_N = mkN "ความอดทน" | mkN "การยอมรับ" | mkN "การสนับสนุน" | mkN "การได้รับความเห็นชอบ" | mkN "การรับ" | mkN "การอดทน" | mkN "การทนทาน" | mkN "การยอมทน" | mkN "การยอมรับ" | mkN "การตรวจรับ" | mkN "การตกลงด้วย" | mkN "การรับเอามา" | mkN "การเต็มใจเชื่อ" | mkN "การเห็นด้วยกับ" | mkN "การเห็นพ้องกับ" | mkN "การตอบรับคําเชิญ" | mkN "การยอมรับเข้ากลุ่ม" ; -- src=panlex
lin acceptation_N = mkN "การสนับสนุน" | mkN "การได้รับความเห็นชอบ" | mkN "ความเชื่อ" | mkN "การเห็นด้วย" ; -- src=panlex
lin accepted_A = mkA "เป็นที่ยอมรับ" | mkA "ได้มาตรฐาน" | mkA "ซึ่งเป็นที่ยอมรับ" | mkA "ที่ไม่สามารถปฏิเสธได้" | mkA "ซึ่งยอมรับกันโดยทั่วไป" | mkA "ที่ไม่สามารถโต้แย้งได้" | mkA "ี่ที่ไม่สามารถคัดค้านได้" ; -- src=panlex
lin acceptive_A = mkA "ยอมรับ" ; -- src=panlex
lin acceptor_N = mkN "ตัวรับ" ; -- src=panlex
lin access_N = mkN "สิทธิ์" | mkN "รหัสผ่าน" | mkN "การเปิดรับ" | mkN "ทางเข้าออก" | mkN "วิธีการเข้า-ออก" | mkN "สิทธิเข้าใช้" | mkN "สิทธิในการเข้าถึง" | mkN "ทางเข้า" | mkN "วิธีเข้า" | mkN "การเข้าไปได้" | mkN "การระเบิดอารมณ์" | mkN "การปะทุของอารมณ์" | mkN "สิทธิ์ในการเข้าพบ" | mkN "สิทธิ์หรือโอกาสในการใช้" | mkN "อารมณ์รุนแรงและกระทันหัน" ; -- src=panlex
lin accessary_A = mkA "การสมคบ" | mkA "ผู้สมคบ" | mkA "ซึ่งสมคบ" | mkA "ผู้ร่วมมือ" | mkA "สิ่งประกอบ" | mkA "ซึ่งประกอบด้วย" ; -- src=panlex
lin accessary_N = mkN "ผู้สมรู้ร่วมคิด" | mkN "ผู้ร่วมกระทำความผิด" | mkN "ผู้ร่วมก่ออาชญากรรม" | mkN "การสมคบ" | mkN "ผู้สมคบ" | mkN "ซึ่งสมคบ" | mkN "ผู้ร่วมมือ" | mkN "สิ่งประกอบ" | mkN "ซึ่งประกอบด้วย" ; -- src=panlex
lin accessibility_N = mkN "การมีอยู่" | mkN "ความสะดวก" | mkN "หาได้ใช้ได้" ; -- src=panlex
lin accessible_A = mkA "ซึ่งได้มาง่าย" | mkA "ที่สามารถเข้าได้" | mkA "ซึ่งเข้ากับคนง่าย" | mkA "ใช้ง่าย" | mkA "ได้ง่าย" | mkA "เข้าหาได้ง่าย" | mkA "เข้าไปได้ง่าย" | mkA "ที่สามารถเข้าได้" ; -- src=panlex
lin accession_N = mkN "สิทธิ์" | mkN "การเปิดรับ" | mkN "การเข้าครอบครอง" | mkN "สิทธิในการเข้าถึง" | mkN "สิ่งที่เพิ่มเข้าไป" | mkN "สรรหา" | mkN "การตกลง" | mkN "ลงบัญชี" | mkN "การเพิ่มขึ้น" | mkN "การเข้าครอบครอง" | mkN "สิ่งที่เพิ่มหรือใส่เข้า" | mkN "การพิมพ์ขึ้นของทรัพย์สิน" ; -- src=panlex
lin accessional_A = mkA "ที่ได้รับสิทธิ์" ; -- src=panlex
lin accessory_A = mkA "์" | mkA "ผนวก" | mkA "สมคบ" | mkA "สังกัด" | mkA "อุปกรณ์" | mkA "ของประกอบ" | mkA "ส่วนประกอบ" | mkA "ของเพิ่มเติม" | mkA "ผู้สมรู้ร่วมคิด" | mkA "ซึ่งสมรู้ร่วมคิด" | mkA "ซึ่งเป็นส่วนเพิ่มเติม" ; -- src=panlex
lin accessory_N = mkN "ส่วนเพิ่มเติม" | mkN "ผู้สมรู้ร่วมคิด" | mkN "ผู้ร่วมกระทำความผิด" | mkN "ผู้ร่วมก่ออาชญากรรม" | mkN "์" | mkN "ผนวก" | mkN "สมคบ" | mkN "สังกัด" | mkN "อุปกรณ์" | mkN "ของประกอบ" | mkN "ส่วนประกอบ" | mkN "ของเพิ่มเติม" | mkN "ผู้สมรู้ร่วมคิด" | mkN "์อุปกรณ์เพิ่มเติม" | mkN "ส่วนประกอบเพิ่มเติม" | mkN "เครื่องประดับตามสมัยนิยม" ; -- src=panlex
lin accidence_N = mkN "วิทยาหน่วยคำวิภัตติปัจจัย" | mkN "อักขรวิธี" | mkN "การศึกษาเกี่ยวกับการเปลี่ยนแปลงของรูปคํา" ; -- src=panlex
lin accident_N = mkN "อุบัติเหตุ" | mkN "โอกาส" | mkN "บังเอิญ" | mkN "เหตุร้าย" | mkN "ส่วนประกอบ" | mkN "อุบัติเหตุ" | mkN "อุปัทวเหตุ" | mkN "เหตุบังเอิญ" | mkN "พื้นทีไม่เรียบ" | mkN "การตั้งครรภ์โดยไม่ได้เตรียมตัว" ; -- src=panlex
lin accidental_A = mkA "บังเอิญ" | mkA "ส่วนประกอบ" | mkA "โดยบังเอิญ" | mkA "ลักษณะสังกัด" | mkA "เป็นการบังเอิญ" | mkA "ซึ่งไม่ได้เจตนา" | mkA "ส่วนที่ไม่เรียบ" | mkA "เป็นเหตุบังเอิญ" | mkA "โดยไม่ได้คาดคิด" | mkA "โดยไม่ได้ตั้งใจ" | mkA "ซึ่งเป็นผลข้างเคียง" ; -- src=panlex
lin accidental_N = mkN "บังเอิญ" | mkN "ส่วนประกอบ" | mkN "ผลข้างเคียง" | mkN "ลักษณะสังกัด" | mkN "ส่วนที่ไม่เรียบ" | mkN "สิ่งที่เกิดโดยบังเอิญ" | mkN "สิ่งที่เกิดโดยไม่ได้ตั้งใจ" ; -- src=panlex
lin accipitrine_A = mkA "แอกซิพิไทรน์" | mkA "ซึ่งคล้ายเหยี่ยว" | mkA "ซึ่งเกี่ยวกับนกจําพวกเหยี่ยว" ; -- src=panlex
lin acclaim_N = mkN "การแซ่ซ้อง" | mkN "การสรรเสริญ" | mkN "เสียงแซ่ซ้อง" | mkN "เสียงโห่ร้อง" | mkN "เสียงตะโกนด้วยความชื่นชม" ; -- src=panlex
lin acclamation_N = mkN "การแซ่ซ้อง" | mkN "การสรรเสริญ" ; -- src=panlex
lin acclimate_V = mkV "ปรับตัวกับสภาพอากาศ" | mkV "ปรับตัวให้ชินกับอากาศ" ; -- src=panlex
lin acclimate_V2 = mkV2 "ปรับตัวกับสภาพอากาศ" ; ---- | mkV "ปรับตัวให้ชินกับอากาศ" ; -- src=panlex
lin acclimatize_V = mkV "ปรับตัวกับสภาพอากาศ" | mkV "ปรับตัวให้ชินกับอากาศ" ; -- src=panlex
lin acclimatize_V2 = mkV2 "ปรับตัวกับสภาพอากาศ" ; ---- | mkV "ปรับตัวให้ชินกับอากาศ" ; -- src=panlex
lin acclivity_N = mkN "ชันขึ้น" | mkN "การค่อยๆเพิ่ม" | mkN "ความชัน" | mkN "ทางขึ้น" | mkN "ที่ชันขึ้น" ; -- src=panlex
lin accolade_N = mkN "รางวัล" | mkN "รางวัล" ; -- src=panlex
lin accommodate_V = mkV "จุ" | mkV "คืนดี" | mkV "ประนอม" | mkV "รองรับ" | mkV "ดัดแปลง" | mkV "เหมาะกับ" | mkV "จัดเตรียม" | mkV "ให้ที่พัก" | mkV "ให้ความช่วยเหลือ" | mkV "ปรับตัว" | mkV "ให้ยืมเงิน" | mkV "จัดให้เหมาะ" | mkV "บรรลุข้อตกลง" | mkV "หาที่อยู่ให้" | mkV "จัดที่อยู่ให้" | mkV "ทําให้เข้ากับ" | mkV "ปรับโฟกัสของตา" | mkV "ปรับจุดรวมแสงของตา" ; -- src=panlex
lin accommodate_V2 = mkV2 "จุ" ; ---- | mkV "คืนดี" | mkV "ประนอม" | mkV "รองรับ" | mkV "ดัดแปลง" | mkV "เหมาะกับ" | mkV "จัดเตรียม" | mkV "ให้ที่พัก" | mkV "ให้ความช่วยเหลือ" | mkV "ปรับตัว" | mkV "ให้ยืมเงิน" | mkV "จัดให้เหมาะ" | mkV "บรรลุข้อตกลง" | mkV "หาที่อยู่ให้" | mkV "จัดที่อยู่ให้" | mkV "ทําให้เข้ากับ" | mkV "ปรับโฟกัสของตา" | mkV "ปรับจุดรวมแสงของตา" ; -- src=panlex
lin accommodation_N = mkN "ที่อยู่อาศัย" | mkN "การปรับโฟกัสของตา" | mkN "การอำนวยความสะดวก" | mkN "เงินยืม" | mkN "การยินยอม" | mkN "การตกลงกัน" | mkN "การต้อนรับ" | mkN "การปรองดอง" | mkN "การปรับตัว" | mkN "เงินกู้ยืม" | mkN "อาหารและที่พัก" | mkN "การปรับโฟกัสของตา" | mkN "การอํานวยความสะดวก" | mkN "ที่นั่งที่นอนบนรถไฟ" | mkN "การพยายามประนีประนอมกัน" | mkN "ความพร้อมที่จะช่วยเหลือผู้อื่น" ; -- src=panlex
lin accommodational_A = mkA "ของการปรับโฟกัสดวงตา" ; -- src=panlex
lin accommodative_A = mkA "โอนอ่อนผ่อนตาม" | mkA "ที่ทำให้กลมกลืน" | mkA "ที่ทำให้สอดคล้อง" ; -- src=panlex
lin accompaniment_N = mkN "การคุ้มกัน" | mkN "ส่วนเติมเต็ม" | mkN "การเกิดพร้อมกัน" | mkN "ร้องตาม" | mkN "คลอเสียง" | mkN "ร้องร่วม" | mkN "สิ่งเสริม" | mkN "สิ่งประกอบ" | mkN "สิ่งที่ตามมา" | mkN "สิ่งที่เพิ่มเติม" | mkN "สิ่งที่เสริมเข้ามา" ; -- src=panlex
lin accompanist_N = mkN "ผู้ร้องตาม" | mkN "ผู้ร้องร่วม" ; -- src=panlex
lin accomplice_N = mkN "ผู้สมคบ" | mkN "ผู้สมคบ" | mkN "ผู้สมรู้ร่วมคิด" ; -- src=panlex
lin accomplished_A = mkA "สมบูรณ์" | mkA "ซึ่งบรรลุผล" ; -- src=panlex
lin accomplishment_N = mkN "สกิล" | mkN "ทักษะ" | mkN "ความสำเร็จ" | mkN "ผลสําเร็จ" | mkN "ผลสัมฤทธิ์" | mkN "ความสําเร็จ" | mkN "การบรรลุเป้าหมาย" | mkN "งานที่ทําสําเร็จ" | mkN "ความสามารถพิเศษที่ฝึกฝน" ; -- src=panlex
lin accord_N = mkN "ข้อตกลง" | mkN "ความเห็นอกเห็นใจ" | mkN "สัญญา" | mkN "ข้อตกลง" | mkN "สอดคล้อง" | mkN "สนธิสัญญา" | mkN "ยอมตามตกลง" | mkN "เสียงดนตรี ที่ประสานกัน" | mkN "ความกลมกลืน" | mkN "ความสอดคล้อง" | mkN "การตกลงร่วมกัน" | mkN "การยอมรับร่วมกัน" ; -- src=panlex
lin accord_V = mkV "มอบ" | mkV "กลมกลืน" | mkV "มอบ" | mkV "ให้" | mkV "ทําให้" | mkV "เห็นด้วย" | mkV "ยอมตกลงกัน" | mkV "มีความเห็นสอดคล้อง" ; -- src=panlex
lin accordance_N = mkN "ความตกลง" | mkN "ความสอดคล้อง" | mkN "การยอมรับร่วมกัน" | mkN "การทําให้สอดคล้อง" | mkN "การเห็นพ้องต้องกัน" | mkN "การมอบรางวัลหรือตําแหน่งให้" ; -- src=panlex
lin accordant_A = mkA "ที่สอดคล้องกัน" | mkA "ซึ่งตกลง" | mkA "ซี่งสอดคล้อง" | mkA "ที่สอดคล้องกัน" ; -- src=panlex
lin accordingly_Adv = mkAdv "ฉะนั้น" | mkAdv "ตามที่" | mkAdv "ตามนั้น" | mkAdv "ตาม" | mkAdv "ดังนั้น" | mkAdv "ตามนั้น" | mkAdv "สอดคล้อง" | mkAdv "เช่นนั้น" | mkAdv "อย่างกลมกลืน" | mkAdv "อย่างสอดคล้อง" ; -- src=panlex
lin accordion_N = mkN "หีบเพลง" | mkN "แอคคอร์เดียน" | mkN "เเอคคอร์เีดียน" | mkN "หีบเพลง" ; -- src=panlex
lin accordionist_N = mkN "นักเป่าแอ็กคอร์เดียน" ; -- src=panlex
lin accouchement_N = mkN "การคลอดลูก" | mkN "การคลอดบุตร" | mkN "การให้กําเนิด" ; -- src=panlex
lin account_N = mkN "บิล" | mkN "ใบเสร็จ" | mkN "คำอธิบาย" | mkN "การรายงาน" | mkN "ความสำคัญ" | mkN "ผลประโยชน์" | mkN "รายงานข่าว" | mkN "ใบแจ้งหนี้" | mkN "ใบเสร็จรับเงิน" | mkN "รายการบัญชีงบดุล" | mkN "ความสัมพันธ์ทางธุรกิจ" | mkN "ใบแจ้งราคาสินค้าที่ขายให้" | mkN "บัญชี" | mkN "บันทึก" | mkN "รายงาน" | mkN "ประวัติ" | mkN "การคํานวณ" | mkN "การบรรยาย" | mkN "การอธิบาย" | mkN "เรื่องราว" | mkN "บัญชีธนาคาร" | mkN "รายการบัญชี" | mkN "บัญชีรายรับ-รายจ่าย" | mkN "บัญชีเงินฝาก" ; -- src=panlex
lin account_V = mkV "อธิบาย" | mkV "รับผิดชอบ" | mkV "หาคำอธิบาย" | mkV "พิจารณา" | mkV "ประเมินค่า" | mkV "ทํารายการบัญชี" | mkV "ทําบัญชีรายรับรายจ่าย" ; -- src=panlex
lin account_V2 = mkV2 "อธิบาย" ; ---- | mkV "รับผิดชอบ" | mkV "หาคำอธิบาย" | mkV "พิจารณา" | mkV "ประเมินค่า" | mkV "ทํารายการบัญชี" | mkV "ทําบัญชีรายรับรายจ่าย" ; -- src=panlex
lin account_for_V2 = prepV2 OP_account_V OP_for_Prep ; -- guess-p-verb
lin accountability_N = mkN "การตอบคำถาม" | mkN "ความรับผิดชอบ" ; -- src=panlex
lin accountable_A = mkA "ซึ่งรับผิดชอบ" | mkA "สามารถอธิบายได้" | mkA "ที่สามารถอธิบายได้" | mkA "ซึ่งต้องรายงานหรืออธิบาย" ; -- src=panlex
lin accountancy_N = mkN "นักการบัญชี" | mkN "การบัญชี" ; -- src=panlex
lin accountant_N = mkN "นักบัญชี" | mkN "สมุหบัญชี" | mkN "พนักงานบัญชี" | mkN "นักบัญชี" | mkN "สมุห์บัญชี" ; -- src=panlex
lin accountantship_N = mkN "ตำแหน่งบัญชี" | mkN "ตำแหน่งนักบัญชี" ; -- src=panlex
lin accounting_N = mkN "นักการบัญชี" | mkN "ระบบการทำบัญชี" | mkN "รายการบัญชีงบดุล" | mkN "หลักการบัญชี" | mkN "วิชาการทําบัญชี" | mkN "ทฤษฎีการทําบัญชี" | mkN "ทฤษฎีระบบการทําบัญชี" ; -- src=panlex
lin accretion_N = mkN "การงอกติดกัน" | mkN "การงอกพอกพูน" | mkN "ที่งอกชายฝั่ง" | mkN "ที่งอกริมตลิ่ง" ; -- src=panlex
lin accrue_V = mkV "ตกเป็นของ" | mkV "เพิ่มขึ้น" | mkV "พอกพูน" | mkV "มากขึ้น" | mkV "เพิ่มขึ้น" | mkV "ทําให้มากขึ้น" | mkV "ทําให้เพิ่มขึ้น" | mkV "ทําให้พอกพูนขึ้น" ; -- src=panlex
lin accrue_V2 = mkV2 "ตกเป็นของ" ; ---- | mkV "เพิ่มขึ้น" | mkV "พอกพูน" | mkV "มากขึ้น" | mkV "เพิ่มขึ้น" | mkV "ทําให้มากขึ้น" | mkV "ทําให้เพิ่มขึ้น" | mkV "ทําให้พอกพูนขึ้น" ; -- src=panlex
lin acculturation_N = mkN "วัฒนธรรม" | mkN "กระบวนการปรับแผนหรือลักษณะวัฒนธรรม" ; -- src=panlex
lin acculturational_A = mkA "ที่เรียนรู้ต่างวัฒนธรรม" ; -- src=panlex
lin accumbent_A = mkA "ทอดบนดิน" | mkA "เอียง" | mkA "เอียงชิด" ; -- src=panlex
lin accumulate_V = mkV "สะสม" | mkV "รวบรวม" | mkV "สะสม" | mkV "เก็บ" | mkV "สั่งสม" | mkV "เก็บสะสม" ; -- src=panlex
lin accumulate_V2 = mkV2 "สะสม" ; ---- | mkV "รวบรวม" | mkV "สะสม" | mkV "เก็บ" | mkV "สั่งสม" | mkV "เก็บสะสม" ; -- src=panlex
lin accumulation_N = mkN "ชุด" | mkN "การรวมกัน" | mkN "ของที่สะสม" | mkN "คอลเลคชั่น" | mkN "การเก็บสะสม" | mkN "การงอกพอกพูน" | mkN "สิ่งที่รวมไว้" | mkN "การพอกพูน" | mkN "การเก็บสะสม" | mkN "ของที่เก็บสะสม" | mkN "ของที่รวบรวมไว้" | mkN "การเพิ่มของผลกําไร" | mkN "การรวมตัวกันมากขึ้น" | mkN "การเพิ่มจํานวนมากขึ้น" ; -- src=panlex
lin accumulative_A = mkA "ซึ่งเกิดการสะสม" ; -- src=panlex
lin accumulator_N = mkN "ผู้เก็บเงิน" | mkN "พลังงานสำรอง" | mkN "แบตเตอรี่สำรอง" | mkN "แอคคิวมูเลเตอร์" | mkN "พนักงานจัดเก็บภาษี" ; -- src=panlex
lin accuracy_N = mkN "ความเที่ยง" | mkN "ความแน่นอน" | mkN "ความถูกต้อง" | mkN "ความแม่นยํา" | mkN "ความเที่ยงตรง" | mkN "ความระมัดระวัง" | mkN "ความสามารถที่จะหลีกเลี่ยงข้อผิดพลาด" ; -- src=panlex
lin accurate_A = mkA "เที่ยงตรง" | mkA "แน่นอน" | mkA "ถูกต้อง" | mkA "แม่นยํา" | mkA "เที่ยงตรง" | mkA "ระมัดระวัง" | mkA "ไร้ข้อผิดพลาด" ; -- src=panlex
lin accursed_A = mkA "น่าชิงชัง" | mkA "ถูกสาปแช่ง" | mkA "เคราะห์ร้าย" ; -- src=panlex
lin accusation_N = mkN "ข้อหา" | mkN "การตําหนิ" | mkN "การประณาม" | mkN "การหาเหตุ" | mkN "คําประนาม" | mkN "การกล่าวหา" | mkN "การใส่ความ" | mkN "ข้อกล่าวหา" | mkN "คํากล่าวหา" | mkN "การกล่าวโทษ" ; -- src=panlex
lin accusative_A = mkA "ที่เป็นกรรม" | mkA "ซึ่งกล่าวหา" ; -- src=panlex
lin accusative_N = mkN "กรรมการก" ; -- src=panlex
lin accusatorial_A = mkA "ที่ถูกฟ้อง" | mkA "เกี่ยวกับผู้กล่าวหา" ; -- src=panlex
lin accused_A = mkA "ผู้ถูกกล่าวหาหรือฟ้องร้อง" | mkA "ซึ่งถูกกล่าวหาหรือฟ้องร้อง" ; -- src=panlex
lin accused_N = mkN "ผู้ต้องหา" | mkN "จำเลยคดีอาญา" | mkN "จำเลยในคดีอาญา" | mkN "จําเลย" | mkN "ผู้ต้องหา" | mkN "ผู้ถูกกล่าวหา" | mkN "ผู้ถูกกล่าวหาหรือฟ้องร้อง" | mkN "ซึ่งถูกกล่าวหาหรือฟ้องร้อง" ; -- src=panlex
lin accuserFem_N = variants {} ; ---- sense to be split
lin accuserMasc_N = variants {} ; ---- sense to be split
lin accusingly_Adv = mkAdv "อย่างตำหนิ" ; -- src=panlex
lin ace_A = mkA "ที่มีคุณภาพสูง" | mkA "เก่ง" | mkA "ดีเลิศ" | mkA "ดีเยี่ยม" ; -- src=panlex
lin ace_N = mkN "๑" | mkN "เอซ" | mkN "หนึ่ง" | mkN "ดาวรุ่ง" | mkN "อัจฉริยะ" | mkN "การเสิร์ฟเอซ" | mkN "ผู้เชี่ยวชาญ" | mkN "อัจฉริยบุคคล" | mkN "ซุปเปอร์สตาร์" | mkN "ผู้เชี่ยวชาญเฉพาะด้าน" | mkN "1" | mkN "ผู้ที่มีความสามารถมาก" | mkN "นักบินที่ยิงเครื่องบินศัตรูได้ตั้งแต่ห้าลําขึ้นไป" ; -- src=panlex
lin acebutolol_N = mkN "อะเซบิวโทลอล" ; -- src=panlex
lin acentric_A = mkA "ขาดเซนโทรเมียร์" | mkA "ห่างใจกลาง" | mkA "ไร้ศูนย์กลาง" | mkA "ไม่อยู่ตรงกลาง" ; -- src=panlex
lin acephalous_A = mkA "ที่ไม่มีหัว" | mkA "ไร้หัว" | mkA "ที่เด่นชัด" ; -- src=panlex
lin acerate_A = mkA "คล้ายรูปเข็ม" ; -- src=panlex
lin acerb_A = mkA "ที่แสบสัน" ; -- src=panlex
lin acerbity_N = mkN "อารมณ์รุนแรง" | mkN "ความรุนแรง" | mkN "รสเปรี้ยวและฝาด" ; -- src=panlex
lin acerola_N = mkN "เชอร์รี่บาร์บาดอส" | mkN "ต้นบาร์บาดอสเชอร์รี่" ; -- src=panlex
lin acervate_A = mkA "เกี่ยวกับการเติบโตของรา" | mkA "งอกเป็นกลุ่ม" ; -- src=panlex
lin acervulus_N = mkN "อาเซอร์วูลัส" ; -- src=panlex
lin acetal_N = mkN "อะซีทัล" ; -- src=panlex
lin acetaldehyde_N = mkN "เอทานอล" | mkN "อะเซทัลดิไฮด์" ; -- src=panlex
lin acetaldol_N = mkN "อะซีทัลดอล" ; -- src=panlex
lin acetamide_N = mkN "อะเซตาไมด์" ; -- src=panlex
lin acetaminophen_N = mkN "ไทลีนอล" | mkN "ยาไทลีนอล" ; -- src=panlex
lin acetanilide_N = mkN "อะซิตานิไลด์" | mkN "ยาอะซิตานิไลด์" ; -- src=panlex
lin acetate_N = mkN "อะซีเทต" | mkN "ผ้าอะซีเตท" ; -- src=panlex
lin acetic_A = mkA "คล้ายน้ำส้ม" ; -- src=panlex
lin acetin_N = mkN "อะซีติน" ; -- src=panlex
lin acetone_N = mkN "อะซีโตน" ; -- src=panlex
lin acetonic_A = mkA "อะซีโทน" ; -- src=panlex
lin acetophenetidin_N = mkN "อะซิโตฟีนีติดิน" | mkN "ยาอะซิโตฟีนีติดิน" ; -- src=panlex
lin acetum_N = mkN "น้ำส้ม" | mkN "อะซีตัม" | mkN "น้ำส้มสายชู" ; -- src=panlex
lin acetyl_N = mkN "หมู่อะซิทิล" ; -- src=panlex
lin acetylcholine_N = mkN "อะซิทีลโคลีน" ; -- src=panlex
lin acetylene_N = mkN "อะเซทิลีน" ; -- src=panlex
lin acetylenic_A = mkA "อะซิทิลีน" ; -- src=panlex
lin acetylic_A = mkA "กรดอะซิติก" ; -- src=panlex
lin ache_N = mkN "ความปวดร้าว" | mkN "ความเจ็บปวด" | mkN "ความรู้สึกเจ็บปวด" ; -- src=panlex
lin ache_V = mkV "ปวด" | mkV "เจ็บ" | mkV "โหยหา" | mkV "รู้สึกปวด" | mkV "รู้สึกเจ็บ" | mkV "ปวด" | mkV "อยาก" | mkV "เจ็บ" | mkV "ต้องการ" | mkV "ประสงค์" | mkV "ปรารถนา" | mkV "เจ็บปวด" ; -- src=panlex
lin achene_N = mkN "เอคีน" | mkN "ผลไม้ชนิดที่มีเม็ดเล็ก ๆ และแข็ง" ; -- src=panlex
lin achenial_A = mkA "เกี่ยวกับผลแห้งเมล็ดล่อน" ; -- src=panlex
lin achievability_N = mkN "การบรรลุถึง" ; -- src=panlex
lin achievable_A = mkA "ที่สามารถได้มา" | mkA "ที่สามารถทําให้สําเร็จ" ; -- src=panlex
lin achievement_N = mkN "ความสำเร็จ" | mkN "ผลสําเร็จ" | mkN "การบรรลุผล" | mkN "ผลสัมฤทธิ์" | mkN "ความสําเร็จ" | mkN "สัมฤทธิ์ภาพ" | mkN "ความสัมฤทธิ์" | mkN "การสําเร็จลุล่วง" | mkN "การบรรลุผลสําเร็จ" ; -- src=panlex
lin achiever_N = mkN "ผู้ประสบความสำเร็จ" ; -- src=panlex
lin achillea_N = mkN "ต้นแอคีลเลีย" ; -- src=panlex
lin achimenes_N = mkN "ต้นอะชิเมนส์" ; -- src=panlex
lin achlamydeous_A = mkA "ไร้กลีบ" | mkA "ไร้วงกลีบ" | mkA "ไม่มีลวดลาย" ; -- src=panlex
lin achlorhydria_N = mkN "ภาวะไร้กรดเกลือ" | mkN "ภาวะการไร้กรดเกลือในน้ําย่อยกระเพาะอาหาร" ; -- src=panlex
lin achlorhydric_A = mkA "ขาดกรดไฮโดรคลอริก" ; -- src=panlex
lin achondrite_N = mkN "อุกกาบาตหินเนื้อไร้เม็ด" ; -- src=panlex
lin achondritic_A = mkA "อะโคนไดรต์" | mkA "ไม่มีโครงสร้างเป็นเม็ด" ; -- src=panlex
lin achondroplasia_N = mkN "ภาวะกระดูกอ่อนไม่เจริญ" ; -- src=panlex
lin achromatic_A = mkA "ที่ไม่มีสี" | mkA "ที่ไม่มีสี" | mkA "ซึ่งไม่แยกสี" ; -- src=panlex
lin achromatin_N = mkN "อะโครมาติน" ; -- src=panlex
lin achromatinic_A = mkA "ไม่ให้สี" ; -- src=panlex
lin achromatous_A = mkA "สีซีด" | mkA "ไร้สี" ; -- src=panlex
lin achromic_A = mkA "ไร้สี" | mkA "ไร้สารสี" ; -- src=panlex
lin acicula_N = mkN "โครงสร้างรูปเข็ม" | mkN "หนาม" | mkN "ส่วนที่คล้ายเข็ม" ; -- src=panlex
lin aciculate_A = mkA "มีรูปคล้ายเข็ม" | mkA "มีรูปคล้ายเข็ม" ; -- src=panlex
lin acid_A = mkA "กรด" | mkA "ที่แสบสัน" | mkA "ที่เป็นกรด" | mkA "ที่มีรสเหมือนกรด" | mkA "ที่เปรี้ยวเหมือนกรด" | mkA "กรด" | mkA "รุนแรง" | mkA "เปรี้ยว" | mkA "ฉุนเฉียว" | mkA "สิ่งที่เปรี้ยว" | mkA "ซึ่งมีคุณสมบัติเป็นกรด" | mkA "ที่ทําให้รู้สึกแสบร้อน" ; -- src=panlex
lin acid_N = mkN "กรด" | mkN "แอซิด" | mkN "กรด" | mkN "รุนแรง" | mkN "เปรี้ยว" | mkN "ฉุนเฉียว" | mkN "สิ่งที่เปรี้ยว" | mkN "คําพูดที่แหลมคม" | mkN "คําพูดที่เสียดสี" | mkN "ของเหลวที่มีสภาพเป็นกรด" | mkN "ของเหลวที่มีฤทธิ์เป็นกรด" | mkN "คําพูดที่ทําให้รู้สึกแสบร้อน" | mkN "ยาเสพติดชนิดหนึ่งที่มีฤทธิ์หลอนประสาทรุนแรง" ; -- src=panlex
lin acidemia_N = mkN "ภาวะเลือดเป็นกรด" | mkN "ภาวะความเป็นกรดในเลือดสูง" ; -- src=panlex
lin acidic_A = mkA "ซึ่งเป็นกรด" | mkA "ที่มีรสเหมือนกรด" | mkA "ที่เปรี้ยวเหมือนกรด" | mkA "เปรี้ยว" | mkA "ซึ่งเป็นกรด" | mkA "เกี่ยวกับกรด" | mkA "ซึ่งสามารถสร้างกรด" | mkA "ที่มีคุณสมบัติเป็นกรด" ; -- src=panlex
lin acidification_N = mkN "การเกิดกรด" ; -- src=panlex
lin acidify_V = mkV "ทำให้เปรี้ยว" | mkV "ทำให้เป็นกรด" | mkV "ทำให้มีรสเปรี้ยว" | mkV "ทําให้เป็นกรด" | mkV "เปลี่ยนเป็นกรด" ; -- src=panlex
lin acidify_V2 = mkV2 "ทำให้เปรี้ยว" ; ---- | mkV "ทำให้เป็นกรด" | mkV "ทำให้มีรสเปรี้ยว" | mkV "ทําให้เป็นกรด" | mkV "เปลี่ยนเป็นกรด" ; -- src=panlex
lin acidimetric_A = mkA "ที่เป็นกระบวนการสร้างกรด" ; -- src=panlex
lin acidity_N = mkN "ความเปรี้ยว" | mkN "ความเป็นกรด" | mkN "ความเปรี้ยว" | mkN "ภาวะเป็นกรด" | mkN "สภาพเป็นกรด" | mkN "ความเป็นกรดมากเกินไป" ; -- src=panlex
lin acidophil_N = mkN "พืชทนกรด" ; -- src=panlex
lin acidophilic_A = mkA "ที่เติบโตในสภาพกรดปานกลาง" ; -- src=panlex
lin acidophilus_N = mkN "อะซิโดฟิลัส" ; -- src=panlex
lin acidosis_N = mkN "ภาวะกระเดียดกรด" ; -- src=panlex
lin acidotic_A = mkA "ที่มีสภาวะกรด" ; -- src=panlex
lin acidulous_A = mkA "ที่มีรสเหมือนกรด" | mkA "ที่เปรี้ยวเหมือนกรด" | mkA "ทารุณ" | mkA "รุนแรง" | mkA "ค่อนข้างเปรี้ยว" ; -- src=panlex
lin acinus_N = mkN "กระเปาะ" | mkN "อะซินัส" ; -- src=panlex
lin ackee_N = mkN "แอคกี" | mkN "ลูกแอคกี" | mkN "ต้นอะคี" ; -- src=panlex
lin acknowledgement_N = mkN "ใบตอบรับ" | mkN "การยอมรับ" | mkN "การรับรู้" | mkN "การแสดงว่าได้รับ" | mkN "การแสดงความขอบคุณ" | mkN "ข้อความแสดงว่าได้รับ" | mkN "เชิงอรรถ" | mkN "การอ้างอิง" ;
lin acme_N = mkN "จุดยอด" | mkN "จุดสูงสุด" | mkN "ระดับสูงสุด" | mkN "จุดสูงสุด" ; -- src=panlex
lin acne_N = mkN "สิว" | mkN "สิว" ; -- src=panlex
lin acneiform_A = mkA "ที่คล้ายสิว" ; -- src=panlex
lin acold_A = mkA "ซึ่งรู้สึกหนาว" ; -- src=panlex
lin acolyte_N = mkN "ผู้ช่วยพระ" | mkN "แอ็กโคไลต์" | mkN "ผู้ช่วยบาทหลวง" | mkN "ผู้ช่วยพระ" | mkN "พระในนิกายดรมันคาทอลิก" | mkN "เด็กผู้ช่วยขาดหลวงทําพิธี" ; -- src=panlex
lin aconite_N = mkN "ต้นอะโคไนต์" ; -- src=panlex
lin acorn_N = mkN "ผลต้นโอ๊ค" | mkN "ลูกเอคอร์น" | mkN "ผลต้นโอ๊ก" ; -- src=panlex
lin acoustic_A = mkA "ซึ่งเกี่ยวข้องกับเสียง" | mkA "เกี่ยวกับการฟัง" | mkA "ซึ่งเกี่ยวข้องกับเสียง" | mkA "ซึ่งใช้บันทึกคลื่นเสียง" | mkA "เกี่ยวกับการควบคุมเสียง" | mkA "ซึ่งไม่ได้ผ่านการขยายเสียง" | mkA "ซึ่งออกแบบมาเพื่อการควบคุมหรือบันทึกเสียง" ; -- src=panlex
lin acoustician_N = mkN "นักสวนศาสตร์" | mkN "ผู้ชํานาญทางโสตศาสตร์" | mkN "ผู้ชํานาญเกี่ยวกับเสียง" ; -- src=panlex
lin acoustics_N = mkN "สวนศาสตร์" | mkN "โสตศาสตร์" | mkN "วิชาว่าด้วยเสียง" | mkN "วิชาที่ว่าด้วยเสียง" | mkN "ประสิทธิภาพของห้องที่มีต่อเสียง" | mkN "สภาพของสถานที่ซึ่งมีผลต่อการรับฟังเสียง" ; -- src=panlex
lin acquaintance_N = mkN "เพื่อน" | mkN "ความคุ้นเคย" | mkN "ความรู้" | mkN "คนรู้จัก" | mkN "ประสบการณ์" | mkN "คนที่รู้จักกันแต่ไม่คุ้นเคยนัก" ; -- src=panlex
lin acquiesce_V = mkV "ยอมรับ" | mkV "ยอมรับ" | mkV "ยอมทําตาม" | mkV "เห็นด้วยอย่างเงียบๆ" ; -- src=panlex
lin acquiescence_N = mkN "การยอมรับ" | mkN "การยอมตาม" | mkN "การยอมรับ" | mkN "ความเห็นพ้อง" ; -- src=panlex
lin acquirement_N = mkN "สกิล" | mkN "ทักษะ" | mkN "กรรมสิทธิ์" | mkN "สิทธิในการครอบครอง" ; -- src=panlex
lin acquirer_N = mkN "เสมียนธนาคาร" | mkN "ผู้รับผลประโยชน์" ; -- src=panlex
lin acquiring_N = mkN "การได้" | mkN "การได้รับ" ; -- src=panlex
lin acquisition_N = mkN "สกิล" | mkN "ทักษะ" | mkN "สิ่งที่ได้มา" | mkN "กระบวนการเรียนรู้" | mkN "การได้มา" | mkN "สิ่งที่ได้มา" | mkN "การพัฒนาทักษะ" | mkN "สิ่งที่เพิ่มเติม" | mkN "การได้มาซึ่งการเข้าถือสิทธิ์" | mkN "การตรวจหาที่ตั้งโดยเครื่องมืออื่นๆ" ; -- src=panlex
lin acquisitive_A = mkA "โลภ" | mkA "ละโมบ" | mkA "ละโมบโลภมาก" | mkA "โลภ" | mkA "ละโมบ" | mkA "มักได้" | mkA "โลภมาก" | mkA "อยากได้" | mkA "สามารถได้รับ" | mkA "สามารถได้มาซึ่ง" | mkA "อยากได้อย่างมาก" ; -- src=panlex
lin acquittal_N = mkN "การตัดสินโทษโดยไม่มีความผิด" | mkN "การปฏิบัติ" | mkN "การชําระหนี้" | mkN "การตัดสินให้พ้นโทษ" ; -- src=panlex
lin acquittance_N = mkN "การชําระหนี้" ; -- src=panlex
lin acre_N = mkN "เอเคอร์" | mkN "ที่ดิน" | mkN "หน่วยวัดเนื้อที่เป็นเอเคอร์" | mkN "หน่วยวัดเนื้อที่ที่เท่ากับ 2.5 ไร่" ; -- src=panlex
lin acreage_N = mkN "จํานวนเนื้อที่เป็นเอเคอร์" ; -- src=panlex
lin acrid_A = mkA "ที่แสบสัน" | mkA "ฉุน" | mkA "รุนแรง" | mkA "แสบจมูก" | mkA "เผ็ดร้อน" ; -- src=panlex
lin acridity_N = mkN "กลิ่นฉุน" | mkN "กลิ่นฉุนแสบจมูก" ; -- src=panlex
lin acrimonious_A = mkA "รุนแรง" | mkA "เผ็ดร้อน" ; -- src=panlex
lin acrimony_N = mkN "อารมณ์รุนแรง" | mkN "ความรุนแรง" | mkN "ความเหี้ยม" | mkN "ความดุเดือด" | mkN "ความเกรี้ยวกราด" ; -- src=panlex
lin acrobatFem_N = variants {} ; ---- sense to be split
lin acrobatMasc_N = variants {} ; ---- sense to be split
lin acrobatic_A = mkA "ซึ่งเล่นต่อตัว" | mkA "เกี่ยวกับกายกรรม" | mkA "เกี่ยวกับนักกายกรรม" ; -- src=panlex
lin acrobatics_N = mkN "กายกรรม" | mkN "กายกรรม" | mkN "ศิลปกายกรรม" | mkN "การกระทําที่โลดโผน" | mkN "ศิลปการแสดงกายกรรม" ; -- src=panlex
lin acrocarp_N = mkN "มอสสที่เจริญแบบตั้งตรง" ; -- src=panlex
lin acrocarpous_A = mkA "ซึ่งมีผลไม้ที่ปลายของแกนแรก" ; -- src=panlex
lin acrocyanosis_N = mkN "ภาวะเขียวที่มือและเท้า" ; -- src=panlex
lin acrodont_N = mkN "แอ็กโครดอนต์" ; -- src=panlex
lin acrogen_N = mkN "พืชไร้ดอกจำพวกเฟิร์นหรือมอส" | mkN "พืชไร้ดอกจําพวกเฟิร์นหรือมอส" ; -- src=panlex
lin acrogenic_A = mkA "เกี่ยวกับพืชไร้ดอก" ; -- src=panlex
lin acromegaly_N = mkN "โรคอะโครเมกาลี" ; -- src=panlex
lin acromion_N = mkN "อโครเมียน" | mkN "อโครเมียล โพรเซส" ; -- src=panlex
lin acronym_N = mkN "คำจากอักษรย่อ" | mkN "ตัวย่อ" ; -- src=panlex
lin acropetal_A = mkA "ซึ่งงอกสู่จุดยอด" | mkA "ซึ่งเกิดหรืองอกขึ้นสู่จุดยอด" ; -- src=panlex
lin acrophobia_N = mkN "อาการกลัวที่สูง" | mkN "โรคกลัวความสูง" ; -- src=panlex
lin acrophobic_A = mkA "ซึ่งกลัวที่สูง" ; -- src=panlex
lin acrophony_N = mkN "การกำหนดเรียกชื่อสัญลักษณ์" ; -- src=panlex
lin acropolis_N = mkN "อะโครโปลิส" | mkN "เมืองบริวาร" ; -- src=panlex
lin acroscopic_A = mkA "สู่ส่วนปลาย" ; -- src=panlex
lin acrosome_N = mkN "อะโครโซม" ; -- src=panlex
lin across_Adv = mkAdv "ตรงข้าม" | mkAdv "ตามขวาง" | mkAdv "ทางขวาง" | mkAdv "ขวาง" | mkAdv "ข้าม" | mkAdv "ตลอด" | mkAdv "ทั่ว" | mkAdv "แนวนอน" | mkAdv "ตามขวาง" ; -- src=panlex
lin across_Prep = mkPrep "ผ่า" | mkPrep "พาด" | mkPrep "ขวาง" | mkPrep "ข้าม" | mkPrep "ทะลุ" | mkPrep "ไขว้" | mkPrep "ก่ายกัน" | mkPrep "ตามขวาง" | mkPrep "ประสานกัน" | mkPrep "สะพายแล่ง" | mkPrep "ข้ามพรมแดน" | mkPrep "ตัดผ่านกัน" | mkPrep "อยู่อีกข้างหนึ่ง" | mkPrep "จากข้างหนึ่งไปยังอีกข้างหนึ่ง" ; -- src=panlex
lin acrostic_N = mkN "อักษรกล" | mkN "โคลงกระทู้" | mkN "โคลงที่แยกรวมได้" | mkN "ปริศนารูปโครงที่แยกรวมได้" ; -- src=panlex
lin acrylamide_N = mkN "อะคลิลาไมด์" ; -- src=panlex
lin acrylic_N = mkN "สีอะครีลิค" | mkN "สีอาครีลิค" | mkN "ผ้าอะครีลิก" | mkN "เรซินอะครีลิก" | mkN "พลาสติคอะครีลิค" ; -- src=panlex
lin act_N = mkN "แอ็ก" | mkN "กฎหมาย" | mkN "การแสร้งทำ" | mkN "การกระทำของคน" | mkN "การกระทำของมนุษย์" | mkN "มารยา" | mkN "กฎหมาย" | mkN "ผู้แสดง" | mkN "พฤติกรรม" | mkN "การกระทํา" | mkN "การแสร้งทํา" | mkN "ลักษณะนิสัย" | mkN "การทําหน้าที่" | mkN "เหตุการณ์ในละคร" | mkN "การปฏิบัติหน้าที่" | mkN "บันทึกที่เป็นทางการ" | mkN "สิ่งที่กระทําด้วยความตั้งใจ" ; -- src=panlex
lin act_V = mkV "ทำ" | mkV "แสดง" | mkV "กระทำ" | mkV "ทำตัว" | mkV "รับบท" | mkV "ได้ผล" | mkV "เล่นบท" | mkV "ปฏิบัติ" | mkV "แกล้งทำ" | mkV "แสดงออก" | mkV "แสร้งทำ" | mkV "สวมบทบาท" | mkV "เล่นละคร" | mkV "แสดงเป็น" | mkV "ประพฤติตัว" | mkV "มีพฤติกรรม" | mkV "เคลื่อนไหว" | mkV "เล่นละครตบตา" | mkV "มีความประพฤติ" | mkV "แสดง" | mkV "รับบท" | mkV "ทําตัว" | mkV "วางตัว" | mkV "แสดงเป็น" | mkV "แสร้งทํา" | mkV "ประพฤติตน" | mkV "ปฏิบัติตัว" | mkV "เป็นเสมือน" | mkV "ทําหน้าที่เป็น" | mkV "ทําหน้าที่เสมือน" ; -- src=panlex
lin act_V2 = mkV2 "ทำ" ; ---- | mkV "แสดง" | mkV "กระทำ" | mkV "ทำตัว" | mkV "รับบท" | mkV "ได้ผล" | mkV "เล่นบท" | mkV "ปฏิบัติ" | mkV "แกล้งทำ" | mkV "แสดงออก" | mkV "แสร้งทำ" | mkV "สวมบทบาท" | mkV "เล่นละคร" | mkV "แสดงเป็น" | mkV "ประพฤติตัว" | mkV "มีพฤติกรรม" | mkV "เคลื่อนไหว" | mkV "เล่นละครตบตา" | mkV "มีความประพฤติ" | mkV "แสดง" | mkV "รับบท" | mkV "ทําตัว" | mkV "วางตัว" | mkV "แสดงเป็น" | mkV "แสร้งทํา" | mkV "ประพฤติตน" | mkV "ปฏิบัติตัว" | mkV "เป็นเสมือน" | mkV "ทําหน้าที่เป็น" | mkV "ทําหน้าที่เสมือน" ; -- src=panlex
lin act_on_V2 = prepV2 OP_act_V OP_on_Prep ; -- guess-p-verb
lin act_out_V2 = prepV2 OP_act_V OP_out_Prep ; -- guess-p-verb
lin act_up_V = advV OP_act_V OP_up_Adv ; -- guess-p-verb
lin act_upon_V2 = prepV2 OP_act_V OP_upon_Prep ; -- guess-p-verb
lin actable_A = mkA "สามารถขึ้นแสดงได้" ; -- src=panlex
lin actin_N = mkN "แอกติน" | mkN "โปรตีนในกล้ามเนื้อ" ; -- src=panlex
lin actinal_A = mkA "บริเวณปาก" | mkA "ซึ่งมีหนวดหรือส่วนยื่นหรือรังสี" ; -- src=panlex
lin acting_A = mkA "ว่าที่" | mkA "รักษาการ" | mkA "รักษาการแทน" | mkA "ศิลปะการแสดง" | mkA "อาชีพการแสดง" | mkA "ทําหน้าที่แทน" | mkA "ที่รักษาการแทน" | mkA "สําหรับการแสดง" | mkA "เหมาะแก่การแสดง" | mkA "ทําหน้าที่ชั่วคราว" | mkA "เพื่อใช้สําหรับแสดงบนเวทีละคร" ; -- src=panlex
lin acting_N = mkN "การแสดง" | mkN "การเล่นละคร" | mkN "การแสดงละคร" | mkN "ว่าที่" | mkN "การแสดง" | mkN "รักษาการ" | mkN "ศิลปะการแสดง" | mkN "อาชีพการแสดง" | mkN "สําหรับการแสดง" | mkN "เหมาะแก่การแสดง" ; -- src=panlex
lin actinia_N = mkN "สัตว์ทะเลชนิดหนึ่งมีหนวดรอบปาก" ; -- src=panlex
lin actinic_A = mkA "มีรังสี" | mkA "เกี่ยวกับคุณสมบัติของการแผ่รังสี" ; -- src=panlex
lin actinism_N = mkN "ปฏิกิริยาของแสงอาทิตย์" | mkN "คุณสมบัติการแผ่รังสีซึ่งมีผลทางเคมี" ; -- src=panlex
lin actinium_N = mkN "แอกทิเนียม" | mkN "ธาตุแอกทิเนียม" | mkN "เลขอะตอม 89" ; -- src=panlex
lin actinoid_A = mkA "ซึ่งคล้ายรังสี" ; -- src=panlex
lin actinoid_N = mkN "แอกตินอน" | mkN "แอกติไนด์" | mkN "แอกตินอยด์" ; -- src=panlex
lin actinolite_N = mkN "แอกติโนไลต์" | mkN "แร่แอกติโนไลต์" ; -- src=panlex
lin actinometer_N = mkN "แอกติโนมิเตอร์" | mkN "เครื่องมือวัดความเข้มการแผ่รังสี" ; -- src=panlex
lin actinometric_A = mkA "เกี่ยวกับการวัดความเข้มของรังสี" ; -- src=panlex
lin actinometry_N = mkN "การวัดความเข้มของรังสี" ; -- src=panlex
lin actinomyces_N = mkN "แอคติโนไมซีส" ; -- src=panlex
lin actinomycete_N = mkN "แอคติโนไมซีต" ; -- src=panlex
lin actinomycin_N = mkN "แอคติโนไมซิน" ; -- src=panlex
lin actinomyxidian_N = mkN "แอคติโนไมซิเดียน" ; -- src=panlex
lin actinopod_N = mkN "แอคติโนพอด" ; -- src=panlex
lin action_N = mkN "การรบ" | mkN "กิจกรรม" | mkN "แอคชั่น" | mkN "การกระทำ" | mkN "กระฉับกระเฉง" | mkN "การใช้กำลังรบ" | mkN "การใช้กำลังทหาร" | mkN "กระบวนการตามธรรมชาติ" | mkN "การดำเนินคดีตามกฏหมาย" | mkN "การปฏิบัติงานของคณะรัฐบาล" | mkN "กลไกที่ทำให้เครื่องจักรทำงาน" | mkN "การรบ" | mkN "ฤทธิ์" | mkN "ท่าทาง" | mkN "อํานาจ" | mkN "การพนัน" | mkN "การเดิน" | mkN "ขั้นตอน" | mkN "อิทธิพล" | mkN "การกระทํา" | mkN "เหตุการณ์" | mkN "การปฏิบัติ" | mkN "ปฏิบัติการ" | mkN "การฟ้องร้อง" | mkN "อากัปกิริยา" | mkN "การใช้กําลัง" | mkN "การดําเนินการ" | mkN "การดําเนินคดี" | mkN "การเคลื่อนไหว" | mkN "ความกระฉับกระเฉง" | mkN "ความกระตือรือร้น" | mkN "ฉากในนิยายหรือภาพยนตร์" | mkN "การทํางานของเครื่องจักร" | mkN "เหตุการณ์ในนิยายหรือภาพยนตร์" ; -- src=panlex
lin actionable_A = mkA "ซึ่งฟ้องร้องได้" ; -- src=panlex
lin activation_N = mkN "การกระตุ้น" ; -- src=panlex
lin activator_N = mkN "ตัวปลุกฤทธิ์" | mkN "สารปลุกฤทธิ์" ; -- src=panlex
lin active_A = mkA "ปะทุ" | mkA "คึกคัก" | mkA "มีพลัง" | mkA "แอคทีฟ" | mkA "ที่มีผล" | mkA "ที่คึกคัก" | mkA "ยังคุอยู่" | mkA "คล่องแคล่ว" | mkA "ที่ปรากฏขึ้น (จุดมืดบนดวงอาทิตย์)" | mkA "ที่ทำให้เกิดผล" | mkA "ยังคุกรุ่นอยู่" | mkA "ที่แสดงการกระทำ" | mkA "ซึ่งรุนแรงมากขึ้น" | mkA "ซึ่งเป็นผู้กระทำกริยา" | mkA "ไว" | mkA "คล่อง" | mkA "ว่องไว" | mkA "สมมันต์" | mkA "ยังคุอยู่" | mkA "คล่องแคล่ว" | mkA "ซึ่งมีพลัง" | mkA "ปราดเปรียว" | mkA "เป็นผลเร็ว" | mkA "กระฉับกระเฉง" | mkA "กระตือรือร้น" | mkA "ซึ่งทํากําไร" | mkA "ซึ่งประจําการ" | mkA "ที่เคลื่อนที่" | mkA "มีประสิทธิภาพ" | mkA "ซึ่งทํางานอยู่" | mkA "ซึ่งปฏิบัติการ" | mkA "ซึ่งเคลื่อนไหว" | mkA "ยังคุกรุ่นอยู่" | mkA "ซึ่งต้องการพลังงาน" | mkA "ซึ่งพร้อมปฏิบัติการ" | mkA "เกี่ยวกับแหล่งพลังงาน" | mkA "สามารถเคลื่อนไหวเองได้" | mkA "มีลักษณะเป็นกัมมันตภาพรังสี" | mkA "เกี่ยวกับแหล่งกําเนิดพลังงาน" ; -- src=panlex
lin active_N = mkN "กรรตุวาจก" ; -- src=panlex
lin activeness_N = mkN "กิจกรรม" | mkN "กระฉับกระเฉง" ; -- src=panlex
lin activism_N = mkN "ลัทธิที่ดําเนินการเพื่อให้บรรลุผลทางการเมือง" ; -- src=panlex
lin activistFem_N = variants {} ; ---- sense to be split
lin activistMasc_N = variants {} ; ---- sense to be split
lin activist_A = mkA "ซึ่งเป็นนักกิจกรรม" ; -- src=panlex
lin activity_N = mkN "กิจกรรม" | mkN "กระฉับกระเฉง" | mkN "กระบวนการตามธรรมชาติ" | mkN "กิจกรรม" | mkN "การกระทํา" | mkN "การเคลื่อนไหว" | mkN "การกระตือรือร้น" | mkN "ลักษณะการดําเนินการ" | mkN "ลักษณะการเคลื่อนไหว" | mkN "ระดับความมีชีวิตชีวา" | mkN "เรื่องราวที่ดําเนินการ" | mkN "การกระทําอย่างมีชีวิตชีวา" | mkN "การวัดความสามารถในการเกิดปฏิกริยาเคมี" ; -- src=panlex
lin actomyosin_N = mkN "แอคโตไมโอซิน" ; -- src=panlex
lin actor_1_N = variants {} ; ---- sense to be split
lin actor_2_N = variants {} ; ---- sense to be split
lin actress_N = mkN "ดาราหญิง" | mkN "นักแสดงหญิง" | mkN "นางละคร" | mkN "ศิลปินหญิง" | mkN "ตัวแสดงหญิง" | mkN "นักแสดงหญิง" | mkN "ผู้แสดงหญิง" | mkN "ตัวนําแสดงหญิง" ; -- src=panlex
lin actual_A = mkA "แท้" | mkA "จริง" | mkA "แท้ๆ" | mkA "จริง สภาพปัจจุบัน" | mkA "แท้จริง" | mkA "ตามความเป็นจริง" | mkA "ที่เป็นตามความจริง" | mkA "ซึ่งมีอยู่ในเวลานี้" | mkA "ซึ่งเป็นอยู่ปัจจุบัน" | mkA "ซึ่งเป็นอยู่ในขณะนี้" ; -- src=panlex
lin actually_Adv = mkAdv "ที่จริง" | mkAdv "อันที่จริง" | mkAdv "ตามความเป็นจริง" | mkAdv "อย่างที่เกิดขึ้นตามจริง" ; -- src=panlex
lin actuarial_A = mkA "หาค่าสถิติประกันภัย" ; -- src=panlex
lin actuary_N = mkN "นักสถิติ" | mkN "นักคำนวนค่าสถิติ" | mkN "พนักงาน" | mkN "พนักงานค่าสถิติประกันภัย" | mkN "พนักงานหาค่าสถิติประกันภัย" ; -- src=panlex
lin acuate_A = mkA "ที่มีปลายแหลม" | mkA "ที่มีปลายเหมือนเข็ม" ; -- src=panlex
lin acuity_N = mkN "ความหลักแหลม" | mkN "ความคม" | mkN "ความคมกริบ" | mkN "ความชัดเจน" | mkN "ความรุนแรง" | mkN "ความหลักแหลม" | mkN "ความเฉียบแหลม" | mkN "ความฉลาดเฉลียว" ; -- src=panlex
lin aculeate_A = mkA "มีหนาม" | mkA "รุนแรง" | mkA "ดุเดือด" | mkA "หลักแหลม" | mkA "มีส่วนที่แหลม" | mkA "มีเดือยหรือเล็บแหลม" ; -- src=panlex
lin acumen_N = mkN "ไหวพริบ" | mkN "ความเฉียบแหลม" | mkN "ความฉลาดเฉียบแหลม" | mkN "ความมีไหวพริบเฉียบแหลม" ; -- src=panlex
lin acuminate_A = mkA "เรียวแหลม" | mkA "ทําให้คม" | mkA "ทําให้มีไหวพริบ" | mkA "ซึ่งมีปลายแหลมเรียว" ; -- src=panlex
lin acupressure_N = mkN "การรักษาด้วยการนวดแบบซีอัทซู" ; -- src=panlex
lin acupuncture_N = mkN "การฝังเข็ม" | mkN "การฝังเข็ม" ; -- src=panlex
lin acute_A = mkA "แหลม" | mkA "เฉียบพลัน" | mkA "ที่มีปลายแหลม" | mkA "ที่มีปลายเหมือนเข็ม" | mkA "คม" | mkA "ไว" | mkA "ฉลาด" | mkA "หนัก" | mkA "แหลม" | mkA "สาหัส" | mkA "รุนแรง" | mkA "เหี้ยม" | mkA "ฉับพลัน" | mkA "ร้ายแรง" | mkA "เข้มข้น" | mkA "ตาคมกริบ" | mkA "อย่างแรง" | mkA "เฉียบพลัน" | mkA "เฉียบแหลม" | mkA "มีมุมนแหลม" | mkA "มีไหวพริบดี" | mkA "ที่มีปลายแหลม" ; -- src=panlex
lin acuteness_N = mkN "ความหลักแหลม" ; -- src=panlex
lin acyclic_A = mkA "เป็นเกลียว" | mkA "แบบโซ่เปิด" | mkA "ไม่เป็นวัฏจักร" | mkA "ไม่มีลักษณ์หมุนรอบ" ; -- src=panlex
lin acyclovir_N = mkN "ยาโซไวแร็ก" | mkN "อะไซโคลเวียร์" | mkN "ยาอะไซโคลเวียร์" ; -- src=panlex
lin acyl_N = mkN "หมู่เอซิล" ; -- src=panlex
lin ad_N = mkN "โฆษณา" | mkN "การโฆษณา" | mkN "โฆษณา" ; -- src=panlex
lin adactylous_A = mkA "ไม่มีนิ้ว" | mkA "ไร้นิ้วมือหรือนิ้วเท้า" ; -- src=panlex
lin adage_N = mkN "สุภาษิต" | mkN "ภาษิต" | mkN "คติพจน์" | mkN "สุภาษิต" ; -- src=panlex
lin adagio_A = mkA "อะดาจิโอ" | mkA "อย่างช้า ๆ" ; -- src=panlex
lin adagio_Adv = mkAdv "อย่างช้าๆ" | mkAdv "อย่างช้า ๆ" ; -- src=panlex
lin adagio_N = mkN "อะดาจิโอ" | mkN "อย่างช้า ๆ" | mkN "ดนตรีที่บรรเลงอย่างช้า ๆ" ; -- src=panlex
lin adamance_N = mkN "ความใจแข็ง" | mkN "ความดื้อรั้น" ; -- src=panlex
lin adamant_A = mkA "ใจแข็ง" | mkA "ยืนกราน" | mkA "แน่วแน่" ; -- src=panlex
lin adamant_N = mkN "เพชร" | mkN "หินในตํานานที่มีความแข็งมาก" ; -- src=panlex
lin adamantine_A = mkA "ที่มีความแข็ง" | mkA "ที่แข็งเหมือนเพชร" ; -- src=panlex
lin adapt_V = mkV "ดัดแปลง" | mkV "ปรับตัว" | mkV "ปรับ" | mkV "เหมาะ" | mkV "กลมกลืน" | mkV "เข้ากับ" | mkV "ทําให้เหมาะ" | mkV "ทําให้กลมกลืน" | mkV "ทําให้เข้ากับ" ; -- src=panlex
lin adapt_V2 = mkV2 "ดัดแปลง" ; ---- | mkV "ปรับตัว" | mkV "ปรับ" | mkV "เหมาะ" | mkV "กลมกลืน" | mkV "เข้ากับ" | mkV "ทําให้เหมาะ" | mkV "ทําให้กลมกลืน" | mkV "ทําให้เข้ากับ" ; -- src=panlex
lin adaptability_N = mkN "ความสามารถในการปรับตัว" ; -- src=panlex
lin adaptable_A = mkA "ปรับตัวได้" | mkA "ที่ปรับตัวได้" ; -- src=panlex
lin adaptation_N = mkN "การปรับเปลี่ยน" | mkN "การปรับตัว" | mkN "ภาวะที่เหมาะสม" | mkN "การปรับให้เหมาะ" | mkN "ฉบับแก้ไขปรับปรุง" | mkN "สิ่งที่แก้ไขปรับปรุง" | mkN "การปรับตัวของรูม่านตา" | mkN "สิ่งที่ได้จากการปรับให้เหมาะ" | mkN "การปรับตัวให้เข้ากับสิ่งแวดล้อม" ; -- src=panlex
lin adaptational_A = mkA "เกี่ยวกับการปรับตัว" ; -- src=panlex
lin adapter_N = mkN "อะแด็ปเตอร์" | mkN "ผู้เรียบเรียง" | mkN "บุคคลหรือสิ่งที่ปรับตัว" | mkN "สิ่งที่ปรับให้สิ่งสองสิ่งเข้ากัน" ; -- src=panlex
lin adaptive_A = mkA "ที่ปรับได้" | mkA "ซึ่งปรับตัวได้" ; -- src=panlex
lin adaptor_N = mkN "อะแด็ปเตอร์" | mkN "สิ่งที่ปรับให้สิ่งสองสิ่งเข้ากัน" ; -- src=panlex
lin adaxial_A = mkA "ที่ใกล้ชิดอวัยวะ" ; -- src=panlex
lin add_V = mkV "บวก" | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "รวมยอด" | mkV "ทำให้เพิ่ม" | mkV "เพิ่มระดับ" | mkV "เพิ่มคุณภาพ" | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "พูดต่อ" | mkV "เชื่อม" | mkV "นําเข้า" | mkV "พูดเติม" | mkV "เผยแพร่" | mkV "คิดผลรวม" | mkV "พูดเพิ่ม" | mkV "คิดยอดรวม" | mkV "เติมส่วนผสม" | mkV "เพิ่มส่วนผสม" | mkV "ทําให้รุนแรงขึ้น" ; -- src=panlex
lin add_V2 = mkV2 "บวก" ; ---- | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "รวมยอด" | mkV "ทำให้เพิ่ม" | mkV "เพิ่มระดับ" | mkV "เพิ่มคุณภาพ" | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "พูดต่อ" | mkV "เชื่อม" | mkV "นําเข้า" | mkV "พูดเติม" | mkV "เผยแพร่" | mkV "คิดผลรวม" | mkV "พูดเพิ่ม" | mkV "คิดยอดรวม" | mkV "เติมส่วนผสม" | mkV "เพิ่มส่วนผสม" | mkV "ทําให้รุนแรงขึ้น" ; -- src=panlex
lin add_V3 = mkV3 (mkV "เพิ่ม") ;
lin add_VS = mmkVS "บวก" ; ---- | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "รวมยอด" | mkV "ทำให้เพิ่ม" | mkV "เพิ่มระดับ" | mkV "เพิ่มคุณภาพ" | mkV "รวม" | mkV "เพิ่ม" | mkV "เสริม" | mkV "พูดต่อ" | mkV "เชื่อม" | mkV "นําเข้า" | mkV "พูดเติม" | mkV "เผยแพร่" | mkV "คิดผลรวม" | mkV "พูดเพิ่ม" | mkV "คิดยอดรวม" | mkV "เติมส่วนผสม" | mkV "เพิ่มส่วนผสม" | mkV "ทําให้รุนแรงขึ้น" ; -- src=panlex
lin add_in_V = advV OP_add_V OP_in_Adv ; -- guess-p-verb
lin add_on_to_V2 = prepV2 OP_add_V OP_on_Prep ; -- guess-p-verb
lin add_up_V = advV OP_add_V OP_up_Adv ; -- guess-p-verb
lin add_up_V2 = prepV2 OP_add_V OP_up_Prep ; -- guess-p-verb
lin add_up_to_V2 = prepV2 (advV OP_add_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin addable_A = mkA "ซึ่งเติมได้" ; -- src=panlex
lin addend_N = mkN "ตัวบวก" | mkN "จํานวนที่บวกเข้าไป" | mkN "เลขหรือจํานวนที่บวกเข้าด้วยกัน" ; -- src=panlex
lin addendum_N = mkN "ภาคผนวก" | mkN "คําเพิ่มเติม" | mkN "สิ่งที่เพิ่มเข้า" ; -- src=panlex
lin adder_N = mkN "งูงอด" | mkN "คนบวกเลข" | mkN "ผู้บวกเลข" | mkN "เครื่องบวก" | mkN "เครื่องบวกเลข" | mkN "ผู้บวก" | mkN "เครื่องคิดเลข" ; -- src=panlex
lin addict_N = mkN "ผู้ติดยา" | mkN "คนหมกมุ่น" | mkN "ผู้ติดยาเสพย์ติด" | mkN "ผู้ที่หมกมุ่นกับสิ่งใดสิ่งหนึ่ง" ; -- src=panlex
lin addiction_N = mkN "การติด" | mkN "การเสพติด" | mkN "การติดยาเสพติด" | mkN "ภาวะติดยาเสพติด" ; -- src=panlex
lin addictive_A = mkA "ติดนิสัย" | mkA "ที่ติดเป็นนิสัย" | mkA "ซึ่งทําให้ติดยาได้" ; -- src=panlex
lin addition_N = mkN "การเพิ่มขึ้น" | mkN "สิ่งที่เพิ่มเข้าไป" | mkN "การบวก" | mkN "การเพิ่ม" | mkN "การเสริม" | mkN "การต่อเติม" | mkN "สิ่งที่เติม" | mkN "การเพิ่มเติม" | mkN "สิ่งที่เพิ่ม" | mkN "สิ่งที่เสริม" | mkN "สิ่งที่เพิ่มเข้าไป" | mkN "ชื่อที่เพิ่มต่อท้ายชื่อนามสกุล" ; -- src=panlex
lin additional_A = mkA "พิเศษ" | mkA "เสริม" | mkA "เพิ่มเติม" | mkA "ที่มากขึ้น" | mkA "ที่เพิ่มขึ้น" | mkA "ที่เพิ่มเติมขึ้น" ; -- src=panlex
lin additionally_Adv = mkAdv "นอกจากนี้" ; -- src=panlex
lin additive_A = mkA "ที่เติมเข้าไป" | mkA "ซึ่งเพิ่มเข้าไป" | mkA "ซึ่งมีลักษณะหรือเกิดจากการเพิ่มหรือบวก" ; -- src=panlex
lin additive_N = mkN "สิ่งที่เพิ่มเข้าไป" ; -- src=panlex
lin addle_V = mkV "เน่า" | mkV "สับสน" ; -- src=panlex
lin addle_V2 = mkV2 "เน่า" ; ---- | mkV "สับสน" ; -- src=panlex
lin address_N = mkN "ปฏิภาณ" | mkN "ที่อยู่" | mkN "ป้ายบริษัท" | mkN "ชื่อที่อยู่" | mkN "ป้ายร้านค้า" | mkN "ป้ายชื่อบ้าน" | mkN "การจ่าหน้าซอง" | mkN "มารยาททางสังคม" | mkN "ที่พัก" | mkN "ที่อยู่" | mkN "สุนทรพจน์" | mkN "หลักแหล่ง" | mkN "คําปราศรัย" | mkN "ที่อยู่อาศัย" | mkN "กระแสพระราชดํารัส" ; -- src=panlex
lin addressee_N = mkN "ผู้รับจดหมาย" | mkN "ผู้รับ" ; -- src=panlex
lin adduct_N = mkN "กล้ามเนื้อที่ดึงเข้าสู่แกนร่างกาย" ; -- src=panlex
lin adduction_N = mkN "การหุบ" ; -- src=panlex
lin adductor_N = mkN "กล้ามเนื้อแอ็ดดัคเตอร์" | mkN "กล้ามเนื้อที่ดึงเข้าสู่แกนร่างกาย" ; -- src=panlex
lin adenine_N = mkN "อะดีนีน" | mkN "แอลกาลอยด์ชนิดหนึ่งจากชา" ; -- src=panlex
lin adenoid_A = mkA "ที่เกี่ยวกับต่อมอดีนอยด์" ; -- src=panlex
lin adenoidal_A = mkA "ขึ้นจมูก" ; -- src=panlex
lin adenoma_N = mkN "เนื้องอกต่อม" ; -- src=panlex
lin adenopathy_N = mkN "โรคต่อม" ; -- src=panlex
lin adenosine_N = mkN "อะดีโนซีน" ; -- src=panlex
lin adenovirus_N = mkN "อาดิโนไวรัส" ; -- src=panlex
lin adept_A = mkA "ช่ำชอง" | mkA "เชี่ยวชาญ" | mkA "ชํานาญ" | mkA "สันทัด" | mkA "ช่ําชอง" | mkA "เก่งกาจ" ; -- src=panlex
lin adept_N = mkN "ดาวรุ่ง" | mkN "อัจฉริยะ" | mkN "ผู้เชี่ยวชาญ" | mkN "อัจฉริยบุคคล" | mkN "ซุปเปอร์สตาร์" | mkN "ผู้เชี่ยวชาญเฉพาะด้าน" | mkN "ผู้ชํานาญการ" | mkN "ผู้เชี่ยวชาญ" ; -- src=panlex
lin adeptness_N = mkN "ความง่าย" | mkN "ความถนัด" | mkN "ความเชี่ยวชาญ" ; -- src=panlex
lin adequacy_N = mkN "ความพอเพียง" | mkN "ความพอเพียง" | mkN "ความพอเหมาะ" | mkN "ความเพียงพอ" ; -- src=panlex
lin adequate_A = mkA "ที่เหมาะสม" | mkA "พอ" | mkA "พอแล้ว" | mkA "พอเพียง" | mkA "พอเหมาะ" | mkA "เพียงพอ" | mkA "เหมาะสม" | mkA "สามารถถึงขีด" | mkA "สามารถพอที่จะทําได้" ; -- src=panlex
lin adesite_N = mkN "หินอะดีไซต์" ; -- src=panlex
lin adhere_V = mkV "ติด" | mkV "ยึด" | mkV "แนบ" | mkV "ศรัทธา" | mkV "ติดแน่น" | mkV "ยึดมั่น" | mkV "ยืนเคียงข้าง" | mkV "จับ" | mkV "ติด" | mkV "แนบติด" | mkV "ติดแน่น" | mkV "ยึดมั่น" | mkV "เกาะติด" | mkV "ตั้งมั่น" | mkV "มุ่งมั่น" | mkV "อยู่ติดกัน" ; -- src=panlex
lin adherence_N = mkN "การผูกมัด" | mkN "การยึดติด" | mkN "การถือทิฐิ" | mkN "การถือมั่น" | mkN "การยึดมั่น" | mkN "ความเลื่อมใส" ; -- src=panlex
lin adherent_A = mkA "ซึ่งติดแน่น" | mkA "ยึด" | mkA "ซึ่งติดแน่น" ; -- src=panlex
lin adherent_N = mkN "สาวก" | mkN "สาวก" | mkN "พลพรรค" | mkN "พรรคพวก" | mkN "ผู้ติดตาม" | mkN "ผู้ยึดมั่น" | mkN "ผู้สนับสนุน" ; -- src=panlex
lin adhesion_N = mkN "การผูกมัด" | mkN "การยึดติด" | mkN "การติดตาม" | mkN "การติดแน่น" | mkN "ความศรัทธา" | mkN "ภาวะการเกาะติด" | mkN "สิ่งที่ติดอยู่" | mkN "การติดอยู่ด้วยกัน" ; -- src=panlex
lin adhesive_A = mkA "เหนียว" | mkA "ซึ่งติดแน่น" | mkA "ยึด" | mkA "ซึ่งติดแน่น" ; -- src=panlex
lin adhesive_N = mkN "กาว" | mkN "สารยึดติด" | mkN "เทปกาว" | mkN "สิ่งที่ทําให้ของติดกัน เช่น กาว" | mkN "สิ่งที่ทําให้ติดอยู่ได้" ; -- src=panlex
lin adhesiveness_N = mkN "การผูกมัด" | mkN "การยึดติด" ; -- src=panlex
lin adieu_N = mkN "ลาก่อน" | mkN "การจากลา" ; -- src=panlex
lin adit_N = mkN "อุโมงค์แนวระดับ" | mkN "ทางเข้า" | mkN "การเข้าหา" | mkN "ทางลาดยาวเข้าไปในเหมือง" | mkN "ทางตามแนวนอนเช้าสู่เหมือง" ; -- src=panlex
lin adjacency_N = mkN "ความใกล้" ; -- src=panlex
lin adjacent_A = mkA "ซึ่งอยู่ติดกัน" | mkA "ชิด" | mkA "ใกล้" | mkA "ข้างๆ" | mkA "ประกบ" | mkA "ติดกัน" | mkA "ข้างเคียง" | mkA "ติดต่อกัน" | mkA "ประชิดกัน" | mkA "ซึ่งมียอดและด้านเดียวกัน" ; -- src=panlex
lin adjectival_A = mkA "เกี่ยวกับหรือใช้เป็นคุณศัพท์" ; -- src=panlex
lin adjective_A = mkA "ประกอบ" | mkA "คําคุณศัพท์" | mkA "เป็นคุณศัพท์" | mkA "เครื่องประกอบ" | mkA "เกี่ยวกับคุณศัพท์" | mkA "ศัพท์ที่ขยายคํานาม" ; -- src=panlex
lin adjective_N = mkN "ค." | mkN "คุณศัพท์" | mkN "คำคุณศัพท์" | mkN "ประกอบ" | mkN "คําขยายนาม" | mkN "คําคุณศัพท์" | mkN "เครื่องประกอบ" | mkN "ศัพท์ที่ขยายคํานาม" ; -- src=panlex
lin adjoin_V = mkV "ชิด" | mkV "ติด" | mkV "ประชิด" | mkV "มีเขตแดนติดกัน" | mkV "ชิด" | mkV "ติด" | mkV "มีเขตแดนติดกัน" | mkV "มีเขตแดนติดกับ" ; -- src=panlex
lin adjoin_V2 = mkV2 "ชิด" ; ---- | mkV "ติด" | mkV "ประชิด" | mkV "มีเขตแดนติดกัน" | mkV "ชิด" | mkV "ติด" | mkV "มีเขตแดนติดกัน" | mkV "มีเขตแดนติดกับ" ; -- src=panlex
lin adjourn_V = mkV "เลิกประชุม" | mkV "ปิดการประชุม" | mkV "พักการประชุม" | mkV "เลื่อน" | mkV "บอกเลื่อน" | mkV "เลื่อนออกไป" ; -- src=panlex
lin adjourn_V2 = mkV2 "เลิกประชุม" ; ---- | mkV "ปิดการประชุม" | mkV "พักการประชุม" | mkV "เลื่อน" | mkV "บอกเลื่อน" | mkV "เลื่อนออกไป" ; -- src=panlex
lin adjournment_N = mkN "การล้มเลิก" | mkN "การเลื่อนออกไป" | mkN "การเลื่อน" | mkN "การเลื่อนออกไป" | mkN "ภาวะหรือระยะเวลาที่เลื่อน" ; -- src=panlex
lin adjudicate_V = mkV "ตัดสิน" | mkV "พิพากษา" | mkV "ตัดสิน" | mkV "พิจารณา" | mkV "พิพากษา" | mkV "วินิจฉัย" ; -- src=panlex
lin adjudicate_V2 = mkV2 "ตัดสิน" ; ---- | mkV "พิพากษา" | mkV "ตัดสิน" | mkV "พิจารณา" | mkV "พิพากษา" | mkV "วินิจฉัย" ; -- src=panlex
lin adjudication_N = mkN "การพิพากษา" ; -- src=panlex
lin adjunct_A = mkA "ซึ่งเป็นผู้ช่วย" | mkA "บทเพิ่ม" | mkA "ผู้ช่วย" | mkA "สิ่งเสริม" | mkA "ส่วนประกอบ" | mkA "สิ่งเพิ่มเติม" | mkA "ที่เข้ามาเสริมชั่วคราว" | mkA "ซึ่งได้รับมอบหมายชั่วคราว" ; -- src=panlex
lin adjunct_N = mkN "บทเพิ่ม" | mkN "ผู้ช่วย" | mkN "สิ่งเสริม" | mkN "สิ่งประกอบ" | mkN "ส่วนประกอบ" | mkN "สิ่งที่เสริม" | mkN "สิ่งเพิ่มเติม" ; -- src=panlex
lin adjunctive_A = mkA "คําเสริม" | mkA "ส่วนสังกัด" | mkA "ที่เป็นสิ่งประกอบ" | mkA "เป็นสิ่งประกอบหรือส่งเสริม" ; -- src=panlex
lin adjuration_N = mkN "การถือสัตย์ปฏิญาณ" ; -- src=panlex
lin adjust_V = mkV "ปรับ" | mkV "ปรับตัว" | mkV "จัดเป็นแนว" | mkV "ปรับเปลี่ยน" | mkV "ปรับให้เหมาะสม" | mkV "แก้ไข" | mkV "ปรับตัว" | mkV "ปรับปรุง" | mkV "ปรับเปลี่ยน" | mkV "เปลี่ยนแปลง" | mkV "ปรับให้เข้ากับสภาวะใหม่" ; -- src=panlex
lin adjust_V2 = mkV2 "ปรับ" ; ---- | mkV "ปรับตัว" | mkV "จัดเป็นแนว" | mkV "ปรับเปลี่ยน" | mkV "ปรับให้เหมาะสม" | mkV "แก้ไข" | mkV "ปรับตัว" | mkV "ปรับปรุง" | mkV "ปรับเปลี่ยน" | mkV "เปลี่ยนแปลง" | mkV "ปรับให้เข้ากับสภาวะใหม่" ; -- src=panlex
lin adjustable_A = mkA "ปรับได้" | mkA "ที่สามารถปรับตัวได้" ; -- src=panlex
lin adjustive_A = mkA "ที่นำไปสู่การปรับเปลี่ยน" ; -- src=panlex
lin adjustment_N = mkN "การดัดแปลง" | mkN "การปรับเปลี่ยน" | mkN "การจัด" | mkN "ตัวปรับ" | mkN "การแก้ไข" | mkN "การปรองดอง" | mkN "การปรับตัว" | mkN "การปรับเปลี่ยน" ; -- src=panlex
lin adjutant_N = mkN "นกตะกรุม" | mkN "นายทหารฝ่ายธุรการ" | mkN "นายทหารฝ่้ายธุรการ" | mkN "ผู้ช่วย" | mkN "ยาเสริม" | mkN "สิ่งช่วย" ; -- src=panlex
lin adjuvant_A = mkA "ผู้ช่วย" | mkA "ยาเสริม" | mkA "สิ่งช่วย" | mkA "ซึ่งช่วยเหลือ" ; -- src=panlex
lin adjuvant_N = mkN "ผู้ช่วย" | mkN "ยาเสริม" | mkN "สิ่งช่วย" ; -- src=panlex
lin administer_V = mkV "แจก" | mkV "จ่าย" | mkV "เข้า" | mkV "จัดการ" | mkV "แจกจ่าย" | mkV "ให้การรักษา" | mkV "ดูแล" | mkV "จัดการ" | mkV "จ่ายยา" | mkV "บริหารงาน" | mkV "ให้บริการ" | mkV "ดําเนินการ" ; -- src=panlex
lin administer_V2 = mkV2 "แจก" ; ---- | mkV "จ่าย" | mkV "เข้า" | mkV "จัดการ" | mkV "แจกจ่าย" | mkV "ให้การรักษา" | mkV "ดูแล" | mkV "จัดการ" | mkV "จ่ายยา" | mkV "บริหารงาน" | mkV "ให้บริการ" | mkV "ดําเนินการ" ; -- src=panlex
lin administration_N = mkN "ผู้ก่อตั้ง" | mkN "การให้การรักษา" | mkN "การบริหารรัฐกิจ" | mkN "การบริหารงานตุลาการ" | mkN "วาระการดำรงตำแหน่งของประธานาธิบดี" | mkN "การจัดการ" | mkN "การบริหาร" | mkN "คณะจัดการ" | mkN "คณะบริหาร" | mkN "การบริหารรัฐกิจ" | mkN "เจ้าหน้าที่บริหารของรัฐ" ; -- src=panlex
lin administrative_A = mkA "จัดการ" | mkA "ดําเนินการ" | mkA "เกี่ยวกับการบริหาร" | mkA "ซึ่งเกี่ยวกับการจัดการหรือบริหาร" ; -- src=panlex
lin administratorFem_N = variants {} ; ---- sense to be split
lin administratorMasc_N = variants {} ; ---- sense to be split
lin admirable_A = mkA "น่าชมเชย" | mkA "ดียอดยิ่ง" | mkA "น่าชื่นชม" | mkA "น่ายกย่อง" | mkA "น่าศรัทธา" | mkA "น่าเลื่อมใส" ; -- src=panlex
lin admiral_N = mkN "พล.ร.อ." | mkN "พลเรือเอก" | mkN "นายพลเรือ" | mkN "พลเรือเอก" | mkN "นาวิกโยธิน" | mkN "ผีเสื้อขนาดใหญ่ชนิดหนึ่งมีสีสวย" | mkN "เรือธงที่มีผู้บังคับการกองเรืออยู่" | mkN "หัวหน้าหน่วยเรือประมงหรือเรือสินค้า" ; -- src=panlex
lin admiralty_N = mkN "ตำแหน่งพลเรือเอก" | mkN "หน่วยงานด้านกองทัพเรือของรัฐบาลอังกฤษ" | mkN "ศาลทางทะเล" | mkN "กระทรวงกองทัพเรืออังกฤษ" | mkN "หน่วยงานด้านกองทัพเรือของรัฐบาลอังกฤษ" ; -- src=panlex
lin admiration_N = mkN "ดุษฎี" | mkN "ศรัทธา" | mkN "การชื่นชม" | mkN "ความชื่นชม" | mkN "การสรรเสริญ" | mkN "ความเลื่อมใส" | mkN "การยกย่องชมเชย" | mkN "บุคคลหรือสิ่งที่ทําให้คนเลื่อมใส" | mkN "บุคคลหรือสิ่งที่ได้รับความชื่นชม" ; -- src=panlex
lin admirer_N = mkN "ผู้หลงใหล" | mkN "ผู้สนับสนุน" | mkN "ผู้หนุนหลัง" | mkN "ผู้ให้การสนับสนุน" ; -- src=panlex
lin admiringly_Adv = mkAdv "อย่างเลื่อมใส" ; -- src=panlex
lin admissible_A = mkA "ยอมได้" | mkA "ซึ่งยอมรับได้" | mkA "พอจะรับไว้ได้" | mkA "ซึ่งยอมให้เข้า" ; -- src=panlex
lin admission_N = mkN "สิทธิ์" | mkN "คำยอมรับ" | mkN "การยอมรับ" | mkN "การเปิดรับ" | mkN "ค่าผ่านประตู" | mkN "สิทธิในการเข้าถึง" | mkN "ค่าธรรมเนียมในการเข้า" | mkN "การยอมรับ" | mkN "คํายอมรับ" | mkN "คําสารภาพ" | mkN "การรับเข้า" | mkN "การยอมรับรอง" | mkN "การรับสารภาพ" | mkN "การประกาศยอมรับ" | mkN "ราคาสําหรับเข้าไป" | mkN "สิทธิ์ในการเข้าไป" | mkN "ค่าธรรมเนียมในการเข้า" | mkN "สิทธหรือวิธีการเข้าไป" | mkN "การยอมรับข้อกล่าวหาหรือความจริง" ; -- src=panlex
lin admissive_A = mkA "ยินยอมรับ" ; -- src=panlex
lin admit_V = mkV "จุ" | mkV "ยอมรับ" | mkV "รองรับ" | mkV "เปิดรับ" | mkV "ยอมให้เข้า" | mkV "สามารถมีได้" | mkV "ให้เข้าร่วม" | mkV "ปล่อยให้เข้า" | mkV "อนุญาตให้ร่วม" | mkV "อนุญาตให้เข้า" | mkV "รับ" | mkV "ยอมรับ" | mkV "สารภาพ" | mkV "ยอมรับผิด" | mkV "รับสารภาพ" | mkV "ยอมให้เข้า" | mkV "รับเข้าไว้" | mkV "ยอมให้เข้าไป" | mkV "อนุญาตให้เข้า" | mkV "ปล่อยให้เข้าไป" | mkV "ยอมรับความจริง" | mkV "มีที่ว่างสําหรับ" ; -- src=panlex
lin admit_V2 = mkV2 "จุ" ; ---- | mkV "ยอมรับ" | mkV "รองรับ" | mkV "เปิดรับ" | mkV "ยอมให้เข้า" | mkV "สามารถมีได้" | mkV "ให้เข้าร่วม" | mkV "ปล่อยให้เข้า" | mkV "อนุญาตให้ร่วม" | mkV "อนุญาตให้เข้า" | mkV "รับ" | mkV "ยอมรับ" | mkV "สารภาพ" | mkV "ยอมรับผิด" | mkV "รับสารภาพ" | mkV "ยอมให้เข้า" | mkV "รับเข้าไว้" | mkV "ยอมให้เข้าไป" | mkV "อนุญาตให้เข้า" | mkV "ปล่อยให้เข้าไป" | mkV "ยอมรับความจริง" | mkV "มีที่ว่างสําหรับ" ; -- src=panlex
lin admit_VS = mmkVS "จุ" ; ---- | mkV "ยอมรับ" | mkV "รองรับ" | mkV "เปิดรับ" | mkV "ยอมให้เข้า" | mkV "สามารถมีได้" | mkV "ให้เข้าร่วม" | mkV "ปล่อยให้เข้า" | mkV "อนุญาตให้ร่วม" | mkV "อนุญาตให้เข้า" | mkV "รับ" | mkV "ยอมรับ" | mkV "สารภาพ" | mkV "ยอมรับผิด" | mkV "รับสารภาพ" | mkV "ยอมให้เข้า" | mkV "รับเข้าไว้" | mkV "ยอมให้เข้าไป" | mkV "อนุญาตให้เข้า" | mkV "ปล่อยให้เข้าไป" | mkV "ยอมรับความจริง" | mkV "มีที่ว่างสําหรับ" ; -- src=panlex
lin admittance_N = mkN "สิทธิ์" | mkN "การยอมรับ" | mkN "การเปิดรับ" | mkN "สิทธิในการเข้าถึง" | mkN "การสารภาพ" | mkN "การรับเข้า" | mkN "การอนุญาติให้เข้า" | mkN "การอนุญาตให้เข้าได้" | mkN "การวัดการนําไฟฟ้าสลับ" ; -- src=panlex
lin admittedly_Adv = mkAdv "จริงอยู่" | mkAdv "โดยเปิดเผย" | mkAdv "เป็นที่ยอมรับกัน" ; -- src=panlex
lin admix_V = mkV "ผสม" | mkV "คลุกเคล้ากับ" ; -- src=panlex
lin admix_V2 = mkV2 "ผสม" ; ---- | mkV "คลุกเคล้ากับ" ; -- src=panlex
lin admixture_N = mkN "การผสม" | mkN "ส่วนผสม" | mkN "การผสมผสาน" | mkN "ส่วนผสม" | mkN "การผสมกัน" | mkN "สิ่งที่เติมเข้า" | mkN "สารประกอบที่มีสิ่งที่เติมเข้านี้" ; -- src=panlex
lin admonisher_N = mkN "ผู้เตือน" ; -- src=panlex
lin admonition_N = mkN "คำแนะนำ" | mkN "การท้วงติง" | mkN "การตักเตือน" | mkN "การเตือนให้ระวังข้อผิดพลาด" ; -- src=panlex
lin admonitory_A = mkA "ซึ่งตักเตือน" ; -- src=panlex
lin adnate_A = mkA "ติดกับบางอย่าง" ; -- src=panlex
lin ado_N = mkN "ความวุ่นวาย" | mkN "ความพลุกพล่าน" | mkN "อุปสรรค" | mkN "ความยุ่งยาก" | mkN "ความวุ่นวาย" | mkN "ความมีธุรกิจมาก" ; -- src=panlex
lin adobe_N = mkN "ดินทำอิฐ" | mkN "อิฐดินดิบ" | mkN "ผนังดิน" | mkN "อิฐที่ตากแห้ง" | mkN "สิ่งปลูกสร้างที่ก่อด้วยอิฐ" ; -- src=panlex
lin adobo_N = mkN "อะโดโบ" ; -- src=panlex
lin adolescence_N = mkN "วัยรุ่นตอนปลาย" | mkN "ช่วงวัยรุ่น" | mkN "วัยหนุ่มสาว" | mkN "ขั้นกลางของการพัฒนา" ; -- src=panlex
lin adolescent_A = mkA "วัยรุ่น" | mkA "ที่เป็นวัยรุ่น" | mkA "วัยรุ่น" | mkA "ซึ่งยังเยาว์วัย" | mkA "ซึ่งยังไม่เติบโตเต็มที่" ; -- src=panlex
lin adolescent_N = mkN "วัยใส" | mkN "วัยรุ่น" | mkN "วัยมันส์" | mkN "วัยสะรุ่น" | mkN "คนวัยมันส์" | mkN "เด็กวัยทีน" | mkN "เด็กวัยรุ่น" | mkN "วัยเริ่มหนุ่มสาว" | mkN "วัยรุ่น" ; -- src=panlex
lin adonis_N = mkN "หนุ่มหล่อ" ; -- src=panlex
lin adoptable_A = mkA "ที่สามารถรับเอามาได้" ; -- src=panlex
lin adoptee_N = mkN "บุตรบุญธรรม" | mkN "เด็กในอุปการะ" ; -- src=panlex
lin adoption_N = mkN "การยืม" | mkN "การสนับสนุน" | mkN "การได้รับความเห็นชอบ" | mkN "การรับเลี้ยงบุตรบุญธรรม" | mkN "การเลือกเอา" | mkN "การเลือกรับเอามา" | mkN "การรับเลี้ยงบุตรบุญธรรม" | mkN "ขั้นตอนการรับเลี้ยงบุตรบุญธรรม" ; -- src=panlex
lin adoptive_A = mkA "บุญธรรม" | mkA "ที่เกี่ยวกับการรับเลี้ยงบุตรบุญธรรม" ; -- src=panlex
lin adorable_A = mkA "ที่น่ารัก" | mkA "ที่น่าชื่นชม" ; -- src=panlex
lin adoration_N = mkN "การนมัสการ" | mkN "ความหลงรัก" | mkN "ความเลื่อมใส" | mkN "ความเคารพบูชา" ; -- src=panlex
lin adorer_N = mkN "ผู้หลงใหล" ; -- src=panlex
lin adornment_N = mkN "สิ่งประดับตกแต่ง" | mkN "สรัอย" | mkN "การตกแต่ง" | mkN "การประดับ" | mkN "การจัดแต่ง" | mkN "เครื่องตกแต่ง" | mkN "เครื่องประดับ" | mkN "การประดับประดา" | mkN "สิ่งประดับตกแต่ง" ; -- src=panlex
lin adrenal_A = mkA "ต่อมอะดริเนล" | mkA "ที่อยู่ใกล้ไต" | mkA "อยู่ใกล้หรือบนไต" | mkA "เกิดจากต่อมหมวกไต" ; -- src=panlex
lin adrenocorticotropic_A = mkA "ซึ่งกระตุ้นส่วนเปลือกของต่อมหมวกไต" ; -- src=panlex
lin adrift_A = mkA "ลอยเคว้งคว้าง" | mkA "คว้าง" | mkA "ลอยไป" | mkA "ล่องลอย" | mkA "เคว้งคว้าง" | mkA "ซึ่งไม่มีจุดหมาย" ; -- src=panlex
lin adrift_Adv = mkAdv "ล่องลอย" ; -- src=panlex
lin adroit_A = mkA "ว่องไว" | mkA "คล่องแคล่ว" ; -- src=panlex
lin adroitness_N = mkN "ความง่าย" | mkN "ความถนัด" | mkN "ความเชี่ยวชาญ" | mkN "ความคล่องแคล่ว" | mkN "ความชํานิชํานาญ" ; -- src=panlex
lin adscript_A = mkA "เขียนตามหลัง" | mkA "อักษรที่เขียนตามหลัง" ; -- src=panlex
lin adsorbable_A = mkA "ที่ดูดซับได้" | mkA "ที่ดูดซึมได้" ; -- src=panlex
lin adsorbate_N = mkN "สารดูดกลืน" | mkN "สารที่ถูกดูดซับ" ; -- src=panlex
lin adsorbent_A = mkA "ที่ดูดซับ" | mkA "ซึ่งดูดซับ" ; -- src=panlex
lin adsorbent_N = mkN "ตัวดูดซับ" ; -- src=panlex
lin adsorption_N = mkN "การดูดซับ" ; -- src=panlex
lin adulation_N = mkN "การยกยอ" | mkN "การป้อยอ" | mkN "การประจบประแจง" ; -- src=panlex
lin adult_A = mkA "โป๊" | mkA "ลามก" | mkA "ผู้ใหญ่" | mkA "ลามกอนาจาร" | mkA "ซึ่งโตเต็มวัย" | mkA "โตแล้ว" | mkA "ผู้ใหญ่" | mkA "โตเต็มที่" | mkA "โตเต็มวัย" | mkA "เป็นผู้ใหญ่" | mkA "สําหรับผู้ใหญ่" | mkA "เป็นรูปเป็นร่าง" | mkA "คนที่เป็นผู้ใหญ่แล้ว" ; -- src=panlex
lin adult_N = mkN "ผู้ใหญ่" | mkN "สัตว์ที่เจริญพันธุ์เต็มที่" | mkN "โตแล้ว" | mkN "ผู้ใหญ่" | mkN "เป็นรูปเป็นร่าง" | mkN "ผู้ที่บรรลุนิติภาวะ" | mkN "คนที่เป็นผู้ใหญ่แล้ว" | mkN "คนหรือสัตว์ที่โตเต็มวัย" ; -- src=panlex
lin adulterant_N = mkN "สารปลอมปน" | mkN "ซึ่งเจือปน" | mkN "สิ่งเจือปน" ; -- src=panlex
lin adulterate_A = mkA "ซึ่งถูกเจือปน" | mkA "ซึ่งไม่บริสุทธิ์" ; -- src=panlex
lin adulteration_N = mkN "การปลอมปน" | mkN "การเจือปน" ; -- src=panlex
lin adulterator_N = mkN "สารปลอมปน" ; -- src=panlex
lin adulterer_N = mkN "ชายชู้" | mkN "ชู้" | mkN "ชายชู้" | mkN "ผู้ที่เป็นชู้" | mkN "ผู้ทําผิดประเวณี" ; -- src=panlex
lin adulteress_N = mkN "หญิงชู้" | mkN "หญิงโสเภณี" | mkN "หญิงชู้" ; -- src=panlex
lin adulterous_A = mkA "เป็นชู้" | mkA "ผิดกฎหมาย" | mkA "ซึ่งเจือปน" | mkA "ที่เป็นชู้" ; -- src=panlex
lin adultery_N = mkN "การคบชู้" | mkN "การมีชู้" | mkN "การคบชู้" | mkN "การมีชู้" | mkN "การเป็นชู้" | mkN "ผิดลูกผิดเมีย" ; -- src=panlex
lin adulthood_N = mkN "วัยผู้ใหญ่" ; -- src=panlex
lin adust_A = mkA "หดหู้" | mkA "เศร้าหมอง" | mkA "ไหม้เกรียม" | mkA "ยางไหม้เกรียม" ; -- src=panlex
lin advance_N = mkN "การปรับปรุง" | mkN "ยก" | mkN "อ้าง" | mkN "เร่ง" | mkN "เจริญ" | mkN "เพิ่ม" | mkN "จัดให้" | mkN "ทาบทาม" | mkN "เกี้ยว" | mkN "เลื่อน" | mkN "เงินกู้" | mkN "การพัฒนา" | mkN "ก้าวหน้า" | mkN "ล่วงหน้า" | mkN "การรุดหน้า" | mkN "การก้าวหน้า" | mkN "การขึ้นราคา" | mkN "การเดินหน้า" | mkN "การเพิ่มค่า" | mkN "เสนอความเห็น" | mkN "การจ่ายเงินล่วงหน้า" | mkN "การเคลื่อนไปข้างหน้า" | mkN "นําหรือส่งไปข้างหน้า" ; -- src=panlex
lin advance_V = mkV "ขึ้น" | mkV "พัฒนา" | mkV "เพิ่ม" | mkV "ขึ้นนำ" | mkV "ก้าวหน้า" | mkV "ขึ้นแท่น" | mkV "ส่งเสริม" | mkV "เคลื่อนไป" | mkV "ได้เปรียบ" | mkV "เลื่อนขั้น" | mkV "เลื่อนชั้น" | mkV "นำมาพิจารณา" | mkV "เลื่อนตำแหน่ง" | mkV "ให้เบิกล่วงหน้า" | mkV "เคลื่อนไปข้างหน้า" | mkV "เร่ง" | mkV "เพิ่ม" | mkV "ให้ยืม" | mkV "คืบหน้า" | mkV "รุดหน้า" | mkV "ก้าวหน้า" | mkV "ล้ําหน้า" | mkV "เพิ่มขึ้น" | mkV "เลื่อนขึ้น" | mkV "ให้ล่วงหน้า" | mkV "จ่ายล่วงหน้า" | mkV "ทําให้เร็วขึ้น" | mkV "เลื่อนตําแหน่ง" | mkV "เคลื่อนไปข้างหน้า" | mkV "ทําให้เคลื่อนไปข้างหน้า" ; -- src=panlex
lin advance_V2 = mkV2 "ขึ้น" ; ---- | mkV "พัฒนา" | mkV "เพิ่ม" | mkV "ขึ้นนำ" | mkV "ก้าวหน้า" | mkV "ขึ้นแท่น" | mkV "ส่งเสริม" | mkV "เคลื่อนไป" | mkV "ได้เปรียบ" | mkV "เลื่อนขั้น" | mkV "เลื่อนชั้น" | mkV "นำมาพิจารณา" | mkV "เลื่อนตำแหน่ง" | mkV "ให้เบิกล่วงหน้า" | mkV "เคลื่อนไปข้างหน้า" | mkV "เร่ง" | mkV "เพิ่ม" | mkV "ให้ยืม" | mkV "คืบหน้า" | mkV "รุดหน้า" | mkV "ก้าวหน้า" | mkV "ล้ําหน้า" | mkV "เพิ่มขึ้น" | mkV "เลื่อนขึ้น" | mkV "ให้ล่วงหน้า" | mkV "จ่ายล่วงหน้า" | mkV "ทําให้เร็วขึ้น" | mkV "เลื่อนตําแหน่ง" | mkV "เคลื่อนไปข้างหน้า" | mkV "ทําให้เคลื่อนไปข้างหน้า" ; -- src=panlex
lin advanced_A = mkA "ซึ่งล้ำยุค" | mkA "ที่รุดหน้า" | mkA "ซึ่งล้ำสมัย" | mkA "ที่ก้าวหน้า" | mkA "ซึ่งมองกาลไกล" | mkA "ซึ่งสลับซํบซ้อน" | mkA "ดึก" | mkA "ข้างหน้า" | mkA "ความเจริญ" | mkA "ความก้าวหน้า" | mkA "อยู่ข้างหน้า" | mkA "ที่อยู่นําหน้า" | mkA "การเลื่อนตําแหน่ง" ; -- src=panlex
lin advancement_N = mkN "การส่งเสริม" | mkN "การพัฒนา" | mkN "การรุดหน้า" | mkN "ความเติบโต" | mkN "ความคืบหน้า" | mkN "ความรุ่งโรจน์" | mkN "การเลื่อนตําแหน่ง" | mkN "การเคลื่อนไปข้างหน้า" ; -- src=panlex
lin advancer_N = mkN "ผู้มีความก้าวหน้า" ; -- src=panlex
lin advantage_N = mkN "ประโยชน์" | mkN "ข้อได้เปรียบ" | mkN "ความได้เปรียบ" | mkN "ผลดี" | mkN "ข้อดี" | mkN "โอกาส" | mkN "ผลกําไร" | mkN "ผลประโยชน์" | mkN "คุณประโยชน์" | mkN "ข้อได้เปรียบ" | mkN "ความได้เปรียบ" ; -- src=panlex
lin advantageous_A = mkA "เป็นคุณ" | mkA "เป็นผลดี" | mkA "ได้กําไร" | mkA "มีประโยชน์" | mkA "ได้ประโยชน์" | mkA "เป็นประโยชน์" ; -- src=panlex
lin advection_N = mkN "การเคลื่อนที่ทางแนวระดับ" | mkN "การนําตามแนวนอน" ; -- src=panlex
lin advent_N = mkN "การมาถึง" | mkN "การมาถึง การปรากฏ" | mkN "การปรากฎ" | mkN "การมาถีง" | mkN "การกําเนิด" | mkN "การจุติของพระเยซูคริสต์" ; -- src=panlex
lin adventistFem_N = variants {} ; ---- sense to be split
lin adventistMasc_N = variants {} ; ---- sense to be split
lin adventitious_A = mkA "บังเอิญ" | mkA "ผิดปกติ" | mkA "ไม่สําคัญ" | mkA "ที่เพิ่มขึ้นมาเอง" | mkA "ที่เพิ่มหรืองอกขึ้นมาแบบไม่ปกติ" ; -- src=panlex
lin adventive_A = mkA "มาจากที่อื่น" | mkA "ไม่ใช่ของท้องถิ่น" | mkA "ไม่ใช่ของของพื้นเมือง" | mkA "สัตว์หรือพืชที่ไม่ใช่ท้องถิ่น" ; -- src=panlex
lin adventure_N = mkN "การผจญภัย" | mkN "การผจญภัย" | mkN "การเสี่ยง" | mkN "การเก็งกําไร" | mkN "การเสี่ยงภัย" | mkN "ความตื่นเต้น" | mkN "อันตรายที่คาดไม่ถึง" | mkN "ประสบการณ์ที่ตื่นเต้น" | mkN "ประสบการณ์ที่น่าตื่นเต้น" ; -- src=panlex
lin adventurer_N = mkN "นักสำรวจ" | mkN "นักผจญภัย" | mkN "ผู้รักการผจญภัย" | mkN "นักผจญภัย" | mkN "นักฉวยโอกาส" | mkN "ผู้เสี่ยงภัย" | mkN "ผู้เสี่ยงโชค" ; -- src=panlex
lin adventuresome_A = mkA "ที่ชอบความเสี่ยง" | mkA "กล้า" | mkA "ชอบผจญภัย" ; -- src=panlex
lin adventuress_N = mkN "นักผจญภัยสาว" ; -- src=panlex
lin adventurous_A = mkA "ที่ชอบความเสี่ยง" | mkA "ชอบผจญภัย" | mkA "ชอบเสี่ยงภัย" | mkA "ค่อนข้างเสี่ยง" ; -- src=panlex
lin adverb_N = mkN "ว." | mkN "วิเศษณ์" | mkN "คำวิเศษณ์" | mkN "คําวิเศษณ์" | mkN "คํากริยาวิเศษณ์" ; -- src=panlex
lin adverbial_A = mkA "เกี่ยวกับกริยาวิเศษณ์" | mkA "เกี่ยวกับหรือทําหน้าที่เป็นกริยาวิเศษณ์" ; -- src=panlex
lin adverbial_N = mkN "คําวิเศษณ์" | mkN "คํากริยาวิเศษณ์" | mkN "คําหรือกลุ่มคําที่ทําหน้าที่เป็นกริยาวิเศษณ์" ; -- src=panlex
lin adversary_N = mkN "ปรปักษ์" | mkN "ฝ่ายตรงข้าม" | mkN "ศัตรู" | mkN "อมิตร" | mkN "ข้าศึก" | mkN "ปรปักษ์" | mkN "คู่อาฆาต" | mkN "คู่ต่อสู้" | mkN "คู่ปรปักษ์" ; -- src=panlex
lin adversative_A = mkA "ซึ่งมีความ หมายตรงกันข้าม" | mkA "คําที่มีความหมายตรงกันข้าม" ; -- src=panlex
lin adverse_A = mkA "ตรงข้าม" | mkA "ตรงกันข้าม" | mkA "เป็นผลร้าย" | mkA "เสียเปรียบ" | mkA "หันไปทางแกน" | mkA "เป็นปฏิปักษ์" | mkA "ซึ่งเป็นอันตราย" ; -- src=panlex
lin adversity_N = mkN "เคราะห์หามยามร้าย" | mkN "ภัยพิบัติ" | mkN "เคราะห์กรรม" | mkN "ความทุกข์ร้อน" | mkN "ความเคราะห์ร้าย" ; -- src=panlex
lin advert_N = mkN "โฆษณา" | mkN "การโฆษณา" ; -- src=panlex
lin advert_V = mkV "อ้าง" | mkV "พาดพิง" | mkV "ตั้งใจฟัง" | mkV "หันความสนใจ" | mkV "เรียกความสนใจ" ; -- src=panlex
lin advertent_A = mkA "สนใจ" | mkA "ที่ให้ความสนใจ" ; -- src=panlex
lin advertise_V = mkV "โฆษณา" | mkV "โปรโมท" | mkV "ป่าวประกาศ" | mkV "ประชาสัมพันธ์" | mkV "โฆษณาประชาสัมพันธ์" | mkV "ลงโฆษณา" | mkV "ลงประกาศ" | mkV "เสนอข่าว" | mkV "แจ้งความ" ; -- src=panlex
lin advertise_V2 = mkV2 "โฆษณา" ; ---- | mkV "โปรโมท" | mkV "ป่าวประกาศ" | mkV "ประชาสัมพันธ์" | mkV "โฆษณาประชาสัมพันธ์" | mkV "ลงโฆษณา" | mkV "ลงประกาศ" | mkV "เสนอข่าว" | mkV "แจ้งความ" ; -- src=panlex
lin advertisement_N = mkN "โฆษณา" | mkN "การโฆษณา" | mkN "การโฆษณา" | mkN "คําโฆษณา" | mkN "การแจ้งความ" | mkN "คําแจ้งความ" ; -- src=panlex
lin advertiser_N = mkN "นักโฆษณา" | mkN "นักโฆษณาประชาสัมพันธ์" | mkN "นักโฆษณา" ; -- src=panlex
lin advertising_N = mkN "โฆษณา" | mkN "การโฆษณา" | mkN "ธุรกิจโฆษณา" | mkN "การโฆษณา" | mkN "คําโฆษณา" | mkN "งานโฆษณา" | mkN "สิ่งโฆษณา" | mkN "ธุรกิจโฆษณา" | mkN "สิ่งที่ใช้ในการโฆษณา" | mkN "อาชีพหรือธุรกิจการโฆษณา" ; -- src=panlex
lin advice_N = mkN "ข่าว" | mkN "รายงาน" | mkN "ความเห็น" | mkN "คําปรึกษา" | mkN "คําแนะนํา" | mkN "การบอกข่าว" | mkN "การเสนอแนะ" | mkN "ข้อคิดเห็น" | mkN "ข้อเสนอแนะ" | mkN "ความประพฤติ" | mkN "ข้อมูลอย่างเป็นทางการ" | mkN "ข่าวสารอย่างเป็นทางการ" ; -- src=panlex
lin advisability_N = mkN "ความเหมาะสม" ; -- src=panlex
lin advisable_A = mkA "เหมาะ" | mkA "ซึ่งคู่ควร" | mkA "ซึ่งมีค่าพอ" | mkA "ซึ่งแนะนําได้" ; -- src=panlex
lin advise_V = mkV "เสนอ" | mkV "แนะนำ" | mkV "แจ้ง" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "แนะแนว" | mkV "แจ้งข่าว" | mkV "แจ้งให้ทราบ" | mkV "ให้คําปรึกษา" | mkV "ให้คําแนะนํา" ; -- src=panlex
lin advise_V2 = mkV2 "เสนอ" ; ---- | mkV "แนะนำ" | mkV "แจ้ง" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "แนะแนว" | mkV "แจ้งข่าว" | mkV "แจ้งให้ทราบ" | mkV "ให้คําปรึกษา" | mkV "ให้คําแนะนํา" ; -- src=panlex
lin advise_VS = mmkVS "เสนอ" ; ---- | mkV "แนะนำ" | mkV "แจ้ง" | mkV "ชี้แนะ" | mkV "แนะนํา" | mkV "แนะแนว" | mkV "แจ้งข่าว" | mkV "แจ้งให้ทราบ" | mkV "ให้คําปรึกษา" | mkV "ให้คําแนะนํา" ; -- src=panlex
lin advisee_N = mkN "ผู้รับคำปรึกษา" | mkN "ผู้ที่ได้รับการปรึกษา" ; -- src=panlex
lin adviserFem_N = variants {} ; ---- sense to be split
lin adviserMasc_N = variants {} ; ---- sense to be split
lin advisor_N = mkN "ที่ปรึกษา" | mkN "ผู้ให้คำแนะนำ" ; -- src=panlex
lin advisory_A = mkA "รายงาน" | mkA "ซึ่งแนะนํา" | mkA "มีอํานาจหรือหน้าที่แนะนํา" | mkA "ที่เกี่ยวกับการให้คําปรึกษา" ; -- src=panlex
lin advisory_N = mkN "รายงาน" | mkN "ซึ่งแนะนํา" | mkN "มีอํานาจหรือหน้าที่แนะนํา" ; -- src=panlex
lin advocacy_N = mkN "ทนาย" | mkN "การแก้ต่าง" | mkN "การสนับสนุน" | mkN "การเป็นทนาย" | mkN "ผู้สนับสนุน" ; -- src=panlex
lin advocateFem_N = variants {} ; ---- sense to be split
lin advocateMasc_N = variants {} ; ---- sense to be split
lin adynamia_N = mkN "อาการไม่มีแรง" ; -- src=panlex
lin adynamic_A = mkA "อ่อนแรง" | mkA "ไร้กําลัง" ; -- src=panlex
lin adz_N = mkN " ขวานถากไม้" ; -- src=panlex
lin adze_N = mkN " ขวานถากไม้" | mkN "ผึ่ง" ; -- src=panlex
lin aeciospore_N = mkN "อีซิโอสปอร์" ; -- src=panlex
lin aecium_N = mkN "แอเซียม" ; -- src=panlex
lin aegis_N = mkN "เกราะเเผ่นอก" | mkN "เกราะป้องกันหน้าอก" | mkN "โล่" | mkN "การปกป้อง" | mkN "การป้องกัน" | mkN "การคุ้มครอง" | mkN "การช่วยเหลือ" ; -- src=panlex
lin aeon_N = mkN "เอออน" | mkN "บรมยุค" | mkN "ยุคเอออน" | mkN "กัลปาวสาน" | mkN "พลังเอออน" | mkN "ระยะเวลายาวนาน" | mkN "ระยะเวลาทางธรณีวิทยา" | mkN "ชั่วนิรันดร" | mkN "ช่วงเวลาที่ยาวนานไม่สิ้นสุด" | mkN "ระยะเวลาที่ยาวนานไม่สิ้นสุด" ; -- src=panlex
lin aeration_N = mkN "การให้อากาศ" | mkN "การอัดแก๊สเข้าของเหลว" ; -- src=panlex
lin aerator_N = mkN "เครื่องอัดลม" | mkN "เครื่องอัดลม" | mkN "เครื่องมืออัดอากาศเข้าไปในน้ําหรือของเหลวอื่น ๆ" ; -- src=panlex
lin aerial_A = mkA "สวยงาม" | mkA "เบาหวิว" | mkA "เพ้อฝัน" | mkA "อยู่ในอา-กาศ" | mkA "เหนือจริง" | mkA "ไม่มีรูปร่าง" | mkA "อยู่สูงในอากาศ" | mkA "เกี่ยวกับอากาศ" | mkA "ซึ่งอยู่ในอากาศ" | mkA "ซึ่งมีชีวิตในอากาศ" | mkA "ซึ่งอยู่ในจินตนาการ" | mkA "ซึ่งเกิดขึ้นในอากาศ" | mkA "เกี่ยวกับเครื่องบิน" | mkA "โดยวิธีทางเครื่องบิน" | mkA "เจริญได้ดีในที่ที่มีอากาศ" ; -- src=panlex
lin aerial_N = mkN "สายอากาศ" | mkN "การตีลังกาโดยไม่ใช้มือ" ; -- src=panlex
lin aerialist_N = mkN "นักกายกรรมห้อยโหน" | mkN "นักกายกรรมกลางหาว" ; -- src=panlex
lin aerides_N = mkN "แอไรส์" ; -- src=panlex
lin aerie_N = mkN "รังนกอินทรี" | mkN "รังนกเหยี่ยว" | mkN "ที่พักบนที่สูง" | mkN "ลูกนก" | mkN "ที่พัก บ้านหรือปราสาทซึ่งอยู่บนที่สูง" | mkN "ที่พักบนที่สูง" | mkN "รังของนกขนาดใหญ่" | mkN "รังนกของนกขนาดใหญ่" ; -- src=panlex
lin aeriferous_A = mkA "ซึ่งนําพาอากาศ" ; -- src=panlex
lin aeriform_A = mkA "ที่เหมือนอากาศ" ; -- src=panlex
lin aerobatics_N = mkN "กายกรรม" ; -- src=panlex
lin aerobe_N = mkN "แบคทีเรีย" | mkN "สิ่งมีชีวิตที่ต้องอาศัยออกซิเจนในการดำรงชีพ" | mkN "สิ่งมีชีวิต" | mkN "สิ่งที่มีชีวิตอยู่ได้โดยต้องอาศัยออกซิเจน" ; -- src=panlex
lin aerobic_A = mkA "แอโรบิก" | mkA "ซึ่งต้องการอากาศหรือออกซิเจนในการดํารงชีวิต" ; -- src=panlex
lin aerobics_N = mkN "การเต้นแอโรบิก" ; -- src=panlex
lin aerobiotic_A = mkA "ที่อาศัยออกซิเจน" ; -- src=panlex
lin aerodrome_N = mkN "สนามบิน" | mkN "ท่าอากาศยาน" | mkN "สนามบิน" ; -- src=panlex
lin aerodynamics_N = mkN "อากาศพลศาสตร์" | mkN "กลศาสตร์ที่เกี่ยวกับการเคลื่อนไหวของอากาศและก๊าซ" ; -- src=panlex
lin aerolite_N = mkN "อุกาบาตชนิดเป็นหิน" | mkN "อุกกาบาตที่ส่วนใหญ่ประกอบด้วยหิน" ; -- src=panlex
lin aeromechanic_A = mkA "ซึ่งเกี่ยวกับกลศาสตร์อากาศหรือก๊าซ" ; -- src=panlex
lin aeromechanics_N = mkN "อากาศพลศาสตร์" ; -- src=panlex
lin aeromedicine_N = mkN "เวชศาสตร์การบิน" | mkN "วิชาแพทย์ทางอากาศ" ; -- src=panlex
lin aeronaut_N = mkN "นักบิน" | mkN "คนขับเครื่องบิน" | mkN "นักขับขี่บอลลูนหรือเรือบิน" | mkN "นักขับขี่บอลลูนหรือเครื่องบิน" ; -- src=panlex
lin aeronautical_A = mkA "ที่เกี่ยวกับการศึกษาเกี่ยวกับการออกแบบหรือสร้างเครื่องบิน" ; -- src=panlex
lin aeronautics_N = mkN "วิทยาศาสตร์ หรือศิลปะการบิน" | mkN "การศึกษาเกี่ยวกับการออกแบบหรือสร้างเครื่องบิน" ; -- src=panlex
lin aerophagia_N = mkN "การกลืนอากาศ" ; -- src=panlex
lin aerophile_N = mkN "คนรักการบิน" ; -- src=panlex
lin aeroplane_N = mkN "เครื่อง" | mkN "เครื่องบิน" | mkN "เครี่องบิน" | mkN "เครื่องบิน" ; -- src=panlex
lin aerosol_N = mkN "ละออง" | mkN "กระป๋องสเปรย์" | mkN "ควัน" | mkN "หมอก" | mkN "ละอองของเหลว" ; -- src=panlex
lin aerospace_A = mkA "เกี่ยวกับอวกาศหรือยานอวกาศ" ; -- src=panlex
lin aerospace_N = mkN "อวกาศ" | mkN "บรรยากาศและอวกาศทั้งหมด" | mkN "บรรยากาศและอากาศทั้งหมด" ; -- src=panlex
lin aery_N = mkN "รังนกอินทรี" | mkN "รังนกเหยี่ยว" | mkN "ที่พักบนที่สูง" | mkN "ที่จับต้องไม่ได้" ; -- src=panlex
lin aesculapian_A = mkA "หมอ" | mkA "เกี่ยวกับแพทยศาสตร์" ; -- src=panlex
lin aestheteFem_N = variants {} ; ---- sense to be split
lin aestheteMasc_N = variants {} ; ---- sense to be split
lin aesthetic_A = mkA "อันงดงาม" | mkA "ที่มีสุนทรียะ" | mkA "งาม" | mkA "สวยงาม" | mkA "ที่เกี่ยวกับความงาม" | mkA "เกี่ยวกับสุนทรียศาสตร์" | mkA "ซึ่งชื่นชมความงามหรือศิลปะ" ; -- src=panlex
lin aesthetic_N = mkN "ทฤษฎีความงาม" | mkN "หลักแห่งความงาม" | mkN "ทฤษฎีความงาม" | mkN "หลักแห่งความงาม" ; -- src=panlex
lin aesthetical_A = mkA "ที่มีสุนทรียะ" ; -- src=panlex
lin aesthetics_N = mkN "สุนทรียศาสตร์" | mkN "สุนทรียภาพ" | mkN "สุนทรียศาสตร์" | mkN "การศึกษาความงาม" ; -- src=panlex
lin aestival_A = mkA "แห่งฤดูร้อน" ; -- src=panlex
lin aether_N = mkN "อีเทอร์" | mkN "สารอีเทอร์" | mkN "สารอีเทอร์ที่ใช้เป็นตัวละลาย มีกลิ่นหอม" ; -- src=panlex
lin aetiology_N = mkN "สมุฏฐานโรค" | mkN "สมุฏฐานวิทยา" ; -- src=panlex
lin afar_Adv = mkAdv "จาก" | mkAdv "แต่ไกล" | mkAdv "ไกลจาก" | mkAdv "ไกลมาก" | mkAdv "ห่างไกล" | mkAdv "ห่างกันไกล" ; -- src=panlex
lin afebrile_A = mkA "ซึ่งไม่มีไข้" ; -- src=panlex
lin affability_N = mkN "ความเป็นมิตร" ; -- src=panlex
lin affable_A = mkA "ง่าย" | mkA "กรุณา" | mkA "สุภาพ" | mkA "อ่อนโยน" | mkA "เป็นมิตร" ; -- src=panlex
lin affair_N = mkN "วาระ" | mkN "เรื่องอื้อฉาว" | mkN "ควาสัมพันธ์ทางเพศ" | mkN "ความสัมพันธ์ฉันชู้สาว" | mkN "การงาน" | mkN "ธุรกิจ" | mkN "ราชการ" | mkN "เรื่อง" | mkN "งานชุมนุม" | mkN "เหตุการณ์" | mkN "เรื่องรัก ใคร่" | mkN "เรื่องส่วนตัว" | mkN "เรื่องอื้อฉาว" | mkN "ความสัมพันธ์เชิงชู้สาว" | mkN "เรื่องรักที่ไม่ถูกทํานองคลองธรรม" ; -- src=panlex
lin affairs_N = mkN "เรื่อง" ; -- src=panlex
lin affect_N = mkN "ความสะเทือนใจ" | mkN "ความรู้สึกสะเทือนใจ" ; -- src=panlex
lin affectation_N = mkN "การแสร้งทำ" | mkN "ท่าทางเสแสร้ง" | mkN "การเสแสร้ง" | mkN "การทําท่าทาง" ; -- src=panlex
lin affected_A = mkA "ซาบซึ้ง" | mkA "เสแสร้ง" | mkA "ซาบซึ้งใจ" | mkA "สงสาร" | mkA "แกล้ง" | mkA "เสียใจ" | mkA "เสแสร้ง" | mkA "แกล้งทํา" | mkA "แสร้งทํา" | mkA "ได้รับผล" | mkA "ไม่จริงใจ" | mkA "กระทบกระเทือน" | mkA "ได้รับอิทธิพล" | mkA "โน้มเอียงไปทาง" ; -- src=panlex
lin affectedness_N = mkN "การแสร้งทำ" | mkN "ท่าทางเสแสร้ง" ; -- src=panlex
lin affecting_A = mkA "กระทบกระเทือนใจ" | mkA "ที่กระทบกระเทือนใจ" ; -- src=panlex
lin affection_N = mkN "ความรัก" | mkN "ความรักใคร่" | mkN "โรค" | mkN "อารมณ์" | mkN "ความรัก" | mkN "ความรักใคร่" ; -- src=panlex
lin affectionate_A = mkA "ชอบ" | mkA "รัก" | mkA "เมตตา" | mkA "ซึ่งรักใคร่" | mkA "ซึ่งแสดงถึงความรัก" ; -- src=panlex
lin affectionateness_N = mkN "ความรัก" | mkN "ความรักใคร่" ; -- src=panlex
lin affenpinscher_N = mkN "สุนัขพันธุ์แอฟเฟนพินเชอร์" | mkN "สุนัขพันธุ์หนึ่ง มีขนาดเล็ก" ; -- src=panlex
lin afferent_A = mkA "ส่งเข้า" | mkA "ไปทางอวัยวะ" | mkA "ที่นําไปสู่อวัยวะในร่างกาย" ; -- src=panlex
lin affiant_N = mkN "ผู้ให้การ" | mkN "คู่หมั้น" | mkN "ผู้ให้คํามั่น" ; -- src=panlex
lin affidavit_N = mkN "คําให้การเป็นลายลักษณ์อักษร" | mkN "คําให้การที่เป็นลายลักษณ์อักษร" ; -- src=panlex
lin affiliate_N = mkN "สาขา" | mkN "กิจการในเครือ" | mkN "บริษัทในเครือ" ; -- src=panlex
lin affiliate_V = mkV "ควบรวม" | mkV "มีความสัมพันธ์" | mkV "รวมกัน" | mkV "สืบสาวต้นตอ" ; -- src=panlex
lin affiliate_V2 = mkV2 "ควบรวม" ; ---- | mkV "มีความสัมพันธ์" | mkV "รวมกัน" | mkV "สืบสาวต้นตอ" ; -- src=panlex
lin affine_N = mkN "สัมพรรค" | mkN "บุคคลที่เกี่ยวดองกันด้วยการแต่งงาน" ; -- src=panlex
lin affined_A = mkA "เลียนแบบ" | mkA "ที่เป็นญาติกัน" | mkA "ที่เกี่ยวดองกัน" ; -- src=panlex
lin affinity_N = mkN "สัมพรรคภาพ" | mkN "ความเกี่ยวดอง" | mkN "ความ สัมพรรค" | mkN "ความดึงดูด" | mkN "คนที่น่ารัก" | mkN "ความใกล้ชิด" | mkN "คนที่น่าสนใจ" | mkN "ความชอบพอกัน" | mkN "คนที่น่าดึงดูด" | mkN "การมีอารมณ์ร่วม" | mkN "ความรู้สึกชอบพอ" | mkN "ความพอใจในการร่วม" | mkN "ความดึงดูดความสนใจ" | mkN "ความสัมพันธ์อย่างสนิท" | mkN "ความสัมพันธ์ที่ใกล้ชิด" | mkN "ความเกี่ยวดองจากการแต่งงาน" | mkN "ความสัมพันธ์ที่เกิดจากการแต่งงาน" ; -- src=panlex
lin affirm_V = mkV "ยืนยัน" | mkV "สนับสนุน" | mkV "ช่วยสนับสนุน" | mkV "ยืนยัน" | mkV "รับรอง" | mkV "พิสูจน์ความเป็นจริง" ; -- src=panlex
lin affirm_V2 = mkV2 "ยืนยัน" ; ---- | mkV "สนับสนุน" | mkV "ช่วยสนับสนุน" | mkV "ยืนยัน" | mkV "รับรอง" | mkV "พิสูจน์ความเป็นจริง" ; -- src=panlex
lin affirm_VS = mmkVS "ยืนยัน" ; ---- | mkV "สนับสนุน" | mkV "ช่วยสนับสนุน" | mkV "ยืนยัน" | mkV "รับรอง" | mkV "พิสูจน์ความเป็นจริง" ; -- src=panlex
lin affirmation_N = mkN "การยืนยัน" | mkN "การยืนยัน" | mkN "การรับรอง" ; -- src=panlex
lin affirmative_A = mkA "ซึ่งเห็นด้วย" | mkA "ซึ่งยืนยัน" | mkA "ซึ่งเห็นพ้อง" | mkA "ซึ่งยืนยันว่าจริง" | mkA "ซึ่งแสดงถึงการยินยอม" ; -- src=panlex
lin affirmative_N = mkN "คําตอบรับ" | mkN "คํายืนยัน" | mkN "ข้อความที่แสดงการยินยอม" | mkN "ข้อความที่แสดงการเห็นพ้อง" ; -- src=panlex
lin affix_N = mkN "คําเติม" | mkN "สิ่งที่เติม" | mkN "สิ่งที่เพิ่ม" | mkN "สิ่งที่ผูกติดกัน" ; -- src=panlex
lin affixation_N = mkN "การติด" | mkN "การเติมหน่วยคำเติม" ; -- src=panlex
lin afflatus_N = mkN "การดลใจ" | mkN "การบันดาลใจ" | mkN "การดลใจจากเบื้องสวรรค์" ; -- src=panlex
lin affliction_N = mkN "ความทุกข์" | mkN "โรคภัยไข้เจ็บ" | mkN "ความเจ็บปวดรวดร้าว" ; -- src=panlex
lin afflictive_A = mkA "ที่เป็นเหตุให้เจ็บปวดหรือเศร้าหมอง" ; -- src=panlex
lin affluence_N = mkN "ความรวย" | mkN "ความล่ำซำ" | mkN "ความร่ำรวย" | mkN "ความมั่นคง" | mkN "ความร่ํารวย" | mkN "ความมั่งคั่ง" | mkN "ความหลากหลาย" ; -- src=panlex
lin affluent_A = mkA "ร่ํารวย" | mkA "มั่งคั่ง" ; -- src=panlex
lin affluent_N = mkN "ผู้มั่งมี" | mkN "ผู้มั่งคั่ง" | mkN "ผู้ที่ร่ํารวย" | mkN "ผู้ที่มั่งคั่ง" ; -- src=panlex
lin affordable_A = mkA "ที่ราคาต่ำ" | mkA "ที่มีราคาต่ำ" ; -- src=panlex
lin afforestation_N = mkN "การปลูกป่า" ; -- src=panlex
lin affray_N = mkN "การวิวาท" | mkN "การทะเลาะวิวาท" | mkN "การตะลุมบอน" | mkN "การปะทะคารม" | mkN "การทะเลาะวิวาท" ; -- src=panlex
lin affricate_N = mkN "พยัญชนะกักเสียดแทรก" | mkN "เสียงกระทบของลิ้น" ; -- src=panlex
lin affront_N = mkN "การดูถูก" | mkN "การลบหลู่" | mkN "การสบประมาท" | mkN "การหมิ่นประมาท" | mkN "การหมิ่นเกียรติ" | mkN "การลบหลู่ดูหมิ่น" | mkN "คําดูแคลน" | mkN "คําปรามาส" ; -- src=panlex
lin affusion_N = mkN "การเทน้ํา" | mkN "วิธีเทน้ํา" | mkN "การรินของเหลว" ; -- src=panlex
lin afghanFem_N = variants {} ; ---- sense to be split
lin afghanMasc_N = variants {} ; ---- sense to be split
lin afghani_N = mkN "อัฟกานิ" ; -- src=panlex
lin afghanistaniFem_N = variants {} ; ---- sense to be split
lin afghanistaniMasc_N = variants {} ; ---- sense to be split
lin aficionado_N = mkN "อะฟิชีโอนาโด" | mkN "แฟนพันธุ์แท้" | mkN "ผู้ที่คลั่งไคล้ในเรื่องใดเรื่องหนึ่ง" ; -- src=panlex
lin afield_Adv = mkAdv "ไกล" | mkAdv "ไกลบ้านไกลช่อง" | mkAdv "ไปนา" | mkAdv "ไปนอก" | mkAdv "จากบ้าน" | mkAdv "ไปบ้านนอก" | mkAdv "นอกลู่นอกทาง" | mkAdv "จากสิ่งที่คุ้นเคย" ; -- src=panlex
lin afire_A = mkA "ไหม้" | mkA "ร้อนรุ่ม" | mkA "ลุกเป็นไฟ" | mkA "ที่ลุกไหม้" ; -- src=panlex
lin aflame_A = mkA "ลุกเป็นไฟ" | mkA "กระตือรือร้น" ; -- src=panlex
lin aflatoxin_N = mkN "อะฟลาท็อกซิน" ; -- src=panlex
lin afloat_A = mkA "ลอยน้ำ" | mkA "ลอย" | mkA "บนแพ" | mkA "บนเรือ" | mkA "ลอยตัว" | mkA "ไม่ล่ม" | mkA "ไม่ล้ม" | mkA "ล่องลอย" | mkA "ชุ่มน้ํา" | mkA "ท่วมน้ํา" | mkA "แพร่หลาย" ; -- src=panlex
lin aflutter_A = mkA "ฮือ" | mkA "ตื่นเต้น" | mkA "สะบัดพลิ้ว" | mkA "ที่น่าตื่นเต้น" ; -- src=panlex
lin afoot_A = mkA "ซึ่งเดินเท้า" | mkA "ดําเนินการ" | mkA "เคลื่อนไหว" | mkA "เดินเท้าเปล่า" ; -- src=panlex
lin afoot_Adv = mkAdv "ดําเนินการ" | mkAdv "เคลื่อนไหว" | mkAdv "โดยการเดิน" | mkAdv "เดินเท้าเปล่า" ; -- src=panlex
lin afore_Adv = mkAdv "ก่อน" | mkAdv "มาแล้ว" | mkAdv "ข้างต้น" | mkAdv "แต่ก่อน" | mkAdv "อยู่หน้า" ; -- src=panlex
lin afore_Prep = mkPrep "ก่อน" | mkPrep "มาแล้ว" | mkPrep "ข้างต้น" | mkPrep "แต่ก่อน" | mkPrep "อยู่หน้า" ; -- src=panlex
lin aforementioned_A = mkA "ดังที่กล่าวมา" | mkA "ดังที่กล่าวมาก่อนแล้ว" | mkA "ตามที่กล่าวไว้ข้างต้น" ; -- src=panlex
lin aforesaid_A = mkA "ดังที่กล่าวมาก่อน" ; -- src=panlex
lin afoul_Adv = mkAdv "พัวพัน" | mkAdv "ซึ่งปะทะกัน" | mkAdv "ในภาวะที่ปะทะกัน" ; -- src=panlex
lin afraid_A = mkA "กลัว" | mkA "กลัว" | mkA "เกรง" | mkA "เกรงว่า" | mkA "กลัวเกรง" | mkA "หวาดกลัว" | mkA "หวาดหวั่น" ; -- src=panlex
lin afresh_Adv = mkAdv "ใหม่" | mkAdv "อีกครั้ง" | mkAdv "อีก" | mkAdv "ใหม่" ; -- src=panlex
lin africanFem_N = variants {} ; ---- sense to be split
lin africanMasc_N = variants {} ; ---- sense to be split
lin afrikanerFem_N = variants {} ; ---- sense to be split
lin afrikanerMasc_N = variants {} ; ---- sense to be split
lin afro_americanFem_N = variants {} ; ---- sense to be split
lin afro_americanMasc_N = variants {} ; ---- sense to be split
lin aft_A = mkA "ทางท้าย" | mkA "ทางท้ายเรือ" | mkA "ไปทางท้ายเรือ" | mkA "อยู่ทางท้ายเรือ" ; -- src=panlex
lin aft_Adv = mkAdv "ข้างหลัง" | mkAdv "ท้ายเรือ" | mkAdv "ทางท้ายเรือ" | mkAdv "ไปทางท้ายเรือ" | mkAdv "อยู่ทางท้ายเรือ" | mkAdv "ตอนท้ายของยานหรือเครื่องบิน" ; -- src=panlex
lin after_A = mkA "หลัง" | mkA "ตามหา" | mkA "ต่อมา" | mkA "ติดตาม" | mkA "ทีหลัง" | mkA "แสวงหา" | mkA "ภายหลัง" | mkA "หลังจาก" | mkA "ข้างหลัง" | mkA "เอาอย่าง" ; -- src=panlex
lin after_Adv = mkAdv "ตอนหลัง" | mkAdv "ในภายหลัง" | mkAdv "หลัง" | mkAdv "ตามหา" | mkAdv "ต่อมา" | mkAdv "ติดตาม" | mkAdv "ทีหลัง" | mkAdv "แสวงหา" | mkAdv "ภายหลัง" | mkAdv "หลังจาก" | mkAdv "ข้างหลัง" | mkAdv "เอาอย่าง" | mkAdv "ภายหลังที่" | mkAdv "หลังจากที่" ; -- src=panlex
lin after_Prep = ss (thword "หลัง" "จาก") | {-pan-} mkPrep "หลัง" | mkPrep "ตามหา" | mkPrep "ต่อมา" | mkPrep "ติดตาม" | mkPrep "ทีหลัง" | mkPrep "แสวงหา" | mkPrep "ภายหลัง" | mkPrep "หลังจาก" | mkPrep "ข้างหลัง" | mkPrep "เอาอย่าง" | mkPrep "ภายหลังที่" | mkPrep "หลังจากที่" ; -- src=panlex
lin afterbirth_N = mkN "รกและเยื่อหุ้มที่ออกมากับทารกแรกเกิด" ; -- src=panlex
lin afterburner_N = mkN "อุปกรณ์ช่วยในการเผาไหม้ของเครื่องยนต์" | mkN "อุปกรณ์ช่วยในการเผาไหม้ของเครื่องยนต์" ; -- src=panlex
lin aftercare_N = mkN "การดูแลผู้ป่วยหลังการรักษา" | mkN "การดูแลรักษาคนไข้พักฟื้น" | mkN "การดูแลคนไข้ในช่วงพักฟื้น" ; -- src=panlex
lin afterdeck_N = mkN "ส่วนท้ายของดาดฟ้าเรือ" | mkN "ดาดฟ้าเรือข้างหลัง" | mkN "ส่วนท้ายของดาดฟ้าเรือ" ; -- src=panlex
lin aftereffect_N = mkN "ผลตามหลัง" | mkN "ผลกระทบ" | mkN "ผลภายหลัง" | mkN "ผลที่ตามมา" | mkN "ผลหลังจากการกระตุ้น" ; -- src=panlex
lin afterglow_N = mkN "ตะวันยอแสง" | mkN "แสงสายัณห์" ; -- src=panlex
lin afterlife_N = mkN "ชีวิตหลังความตาย" | mkN "ชีวิตหลังความตาย" | mkN "ชีวิตหลังจากตายแล้ว" ; -- src=panlex
lin aftermath_N = mkN "ผลปรากฏ" | mkN "ผลที่ตามมา" | mkN "ควันหลง" | mkN "ผลที่ตามมา" ; -- src=panlex
lin aftermost_A = mkA "บ่าย" | mkA "ท้ายสุด" | mkA "หลังเที่ยง" ; -- src=panlex
lin afternoon_N = mkN "ตอนบ่าย" | mkN "บ่าย" | mkN "จวนเย็น" | mkN "ตอนบ่าย" | mkN "ยามบ่าย" | mkN "ช่วงหลัง" | mkN "หลังบ่าย" | mkN "หลังเที่ยง" | mkN "ช่วงหลังของชีวิต" ; -- src=panlex
lin afterpains_N = mkN "ความเจ็บปวดหลังคลอดบุตร" ; -- src=panlex
lin aftershock_N = mkN "อาฟเตอร์ช็อก" | mkN "แผ่นดินไหวตาม" | mkN "แผ่นดินไหวเล็กน้อยที่เกิดหลังจากแผ่นดินไหวรุนแรง" ; -- src=panlex
lin aftertaste_N = mkN "ความคิดที่ล่าช้า" | mkN "รสที่ยังกรุ่นอยู่ในปาก" | mkN "ความคิดหรือการพิจารณาภายหลัง" | mkN "สิ่งเพิ่มเติมที่ไม่ได้คิดมาก่อน" ; -- src=panlex
lin afterthought_N = mkN "การคิดทบทวน" | mkN "ความคิดหรือการพิจารณาภายหลัง" | mkN "ความคิดหรือการพิจารณาภายหลัง" ; -- src=panlex
lin afterwards_Adv = mkAdv "ตอนหลัง" | mkAdv "ในภายหลัง" | mkAdv "ต่อมา" | mkAdv "ต่อไป" | mkAdv "ทีหลัง" | mkAdv "จากนั้น" | mkAdv "ตอนหลัง" | mkAdv "ภายหลัง" | mkAdv "คราวหน้า" | mkAdv "คราวหลัง" | mkAdv "ครั้งต่อไป" | mkAdv "ต่อจากนั้น" | mkAdv "หลังจากนั้น" ; -- src=panlex
lin afterworld_N = mkN "ดินแดนหลังความตาย" | mkN "ชาติหน้า" ; -- src=panlex
lin again_Adv = mkAdv "อีกครั้ง" | mkAdv "อีก" | mkAdv "ใหม่" | mkAdv "อนึ่ง" | mkAdv "อีกที" | mkAdv "ซ้ําสอง" | mkAdv "อีกแล้ว" | mkAdv "เช่นเคย" | mkAdv "อีกครั้ง" | mkAdv "เช่นเดิม" | mkAdv "นอกจากนี้" | mkAdv "ในอีกด้านหนึ่ง" | mkAdv "เพิ่มจากที่กล่าวไปแล้ว" ; -- src=panlex
lin against_Prep = mkPrep "ขัด" | mkPrep "ทวน" | mkPrep "ทาบ" | mkPrep "ฝืน" | mkPrep "พาด" | mkPrep "พิง" | mkPrep "สู้" | mkPrep "แนบ" | mkPrep "ต้าน" | mkPrep "ย้อน" | mkPrep "ฝ่าฝืน" | mkPrep "สู้กับ" | mkPrep "ต่อต้าน" | mkPrep "ทวนน้ํา" | mkPrep "ปะทะกับ" | mkPrep "ป้องกัน" | mkPrep "กระทบกับ" | mkPrep "ดูขัดกับ" | mkPrep "เทียบกับ" | mkPrep "แนบเนื้อ" | mkPrep "ปกป้องจาก" | mkPrep "ประชิดกับ" | mkPrep "ผิดกฎหมาย" | mkPrep "ตรงกันข้าม" | mkPrep "ไม่เห็นด้วย" | mkPrep "ดูขัดแย้งกับ" | mkPrep "อยู่ข้างหน้า" | mkPrep "ตรงกันข้ามกับ" | mkPrep "เปรียบเทียบกับ" | mkPrep "เป็นข้อเสียของ" | mkPrep "เพื่อใช้คืนให้กับ" | mkPrep "เกี่ยวข้องกับเหตุการณ์" ; -- src=panlex
lin agal_N = mkN "อะกาล" ; -- src=panlex
lin agamete_N = mkN "อะกามีต" | mkN "เซลล์สืบพันธุ์ที่ไร้เพศเช่น สปอร์" ; -- src=panlex
lin agamic_A = mkA "ไร้เพศ" | mkA "เกิดขึ้นโดยไม่มีการร่วมเพศ" ; -- src=panlex
lin agammaglobulinemia_N = mkN "อะแกมมาโกลบูลีนเมีย" ; -- src=panlex
lin agapanthus_N = mkN "ต้นอะกาแพนทัส" ; -- src=panlex
lin agape_A = mkA "อ้าปากค้างด้วยความตกใจ" ; -- src=panlex
lin agape_N = mkN "ความรักของพระเจ้า" | mkN "ความรักเพื่อนมนุษย์" | mkN "ความรักเพื่อนร่วมโลก" | mkN "ความรักต่อเพื่อนมนุษย์" | mkN "ความรักเพื่อนร่วมชะตากรรม" ; -- src=panlex
lin agar_N = mkN "วุ้น" | mkN "วุ้นอะการ์-อะการ์" | mkN "ผลิตผลคล้ายวุ้นทําจากสาหร่ายทะเล" | mkN "ผลิตภัณฑ์ชนิดหนึ่งคล้ายวุ้นทําจากสาหร่ายทะเล" ; -- src=panlex
lin agaric_N = mkN "แอ็กเกอริก" | mkN "เห็ด" | mkN "เชื่อราจําพวกหนึ่ง" ; -- src=panlex
lin agate_N = mkN "อะเกต" | mkN "หินโมรา" | mkN "หินมโนรา" | mkN "ต้วพิมพ์หล่อ" ; -- src=panlex
lin agateware_N = mkN "อเกตแวร์" | mkN "อะเกตแวร์" ; -- src=panlex
lin agave_N = mkN "ต้นอะกาวี" | mkN "ต้นอะกาเว" | mkN "ต้นดอกโคม" | mkN "ต้นหางจระเข้" | mkN "ว่านหางจระเข้" | mkN "พืชประเภทดอกโคม" ; -- src=panlex
lin agaze_A = mkA "จ้องเขม็ง" | mkA "ที่จ้องเขม็ง" ; -- src=panlex
lin age_N = mkN "ยุค" | mkN "วัย" | mkN "อายุ" | mkN "ชันษา" | mkN "พรรษา" | mkN "วัยชรา" | mkN "อายุขัย" | mkN "พระชันษา" | mkN "พระชนมายุ" | mkN "วัยแก่ชรา" | mkN "วัยแก่เฒ่า" | mkN "พระชนมพรรษา" | mkN "เวลาอันยาวนาน" | mkN "ยุค" | mkN "วัย" | mkN "ช่วง" | mkN "รุ่น" | mkN "สมัย" | mkN "อายุ" | mkN "ความแก่" | mkN "ช่วงวัย" | mkN "ยุคสมัย" | mkN "นิติภาวะ" | mkN "ช่วงชีวิต" | mkN "ระดับการพัฒนา" | mkN "การเป็นผู้ใหญ่ตามกฎหมาย" ; -- src=panlex
lin age_V = mkV "มีอายุ" | mkV "แก่ขึ้น" | mkV "ทำให้แก่" | mkV "อายุมากขึ้น" | mkV "แก่ขึ้น" | mkV "ทําให้แก่ขึ้น" | mkV "มีอายุมากขึ้น" | mkV "มีอายุเพิ่มขึ้น" | mkV "ทําให้อายุเพิ่มขึ้น" ; -- src=panlex
lin aged_N = mkN "ผู้สูงอายุ" | mkN "กลุ่มผู้สูงวัย" | mkN "กลุ่มผู้สูงอายุ" | mkN "ผู้สูงอายุ" ; -- src=panlex
lin agedness_N = mkN "ภาวะล่วงเข้าวัยชรา" ; -- src=panlex
lin ageing_N = mkN "การแก่ตัว" ; -- src=panlex
lin ageless_A = mkA "ตลอดไป" | mkA "ไม่ยอมแก่" | mkA "ที่เป็นอมตะ" | mkA "ชั่วกาลปาวสาน" | mkA "ไม่ยอมล้าสมัย" ; -- src=panlex
lin age_long_A = mkA "ยาวนาน" ; -- src=panlex
lin agency_N = mkN "กรม" | mkN "ทบวง" | mkN "มรรค" | mkN "วิธี" | mkN "วิถีทาง" | mkN "หน่วยงาน" | mkN "หน่วยงานราชการ" | mkN "สํา-นักงานของตัวแทน" | mkN "พลัง" | mkN "กําลัง" | mkN "หน้าที่" | mkN "บริษัทตัวแทน" | mkN "การปฏิบัติงาน" | mkN "หน่วยงานบริการ" | mkN "หน่วยงานราชการ" | mkN "สํานักงานตัวแทน" | mkN "หน้าที่หรือการปฏิบัติงานของตัวแทน" ; -- src=panlex
lin agenda_N = mkN "กำหนดการ" | mkN "ระเบียบวาระการประชุม" | mkN "กําหนดการ" | mkN "ระเบียบวาระ" | mkN "ระเบียบวาระการประชุม" | mkN "หนังสือบันทึกเรื่องราว" ; -- src=panlex
lin agenesis_N = mkN "ภาวะไม่งอก" | mkN "ภาวะไม่สร้าง" | mkN "ภาวะไม่เจริญ" ; -- src=panlex
lin agentFem_N = variants {} ; ---- sense to be split
lin agentMasc_N = variants {} ; ---- sense to be split
lin agential_A = mkA "ที่เป็นตัวแทนจำหน่าย" | mkA "เกี่ยวกับตัวแทน" ; -- src=panlex
lin ageratum_N = mkN "ต้นอะเจอเรทัม" ; -- src=panlex
lin agglomerate_A = mkA "ที่เกาะตัวกัน" | mkA "ซึ่งจับรวมเป็นกลุ่มก้อน" ; -- src=panlex
lin agglomerate_N = mkN "กอง" | mkN "หินกรวดภูเขาไฟ" | mkN "หินภูเขาไฟ" | mkN "การรวมตัวเป็นกลุ่มก้อน" ; -- src=panlex
lin agglomerate_V = mkV "เกาะตัวกัน" | mkV "เกาะตัว" | mkV "ทําให้เกาะตัว" | mkV "จับรวมเป็นกลุ่มก้อน" | mkV "ทําให้จับรวมเป็นกลุ่มก้อน" ; -- src=panlex
lin agglomerate_V2 = mkV2 "เกาะตัวกัน" ; ---- | mkV "เกาะตัว" | mkV "ทําให้เกาะตัว" | mkV "จับรวมเป็นกลุ่มก้อน" | mkV "ทําให้จับรวมเป็นกลุ่มก้อน" ; -- src=panlex
lin agglomeration_N = mkN "การรวมกลุ่ม" ; -- src=panlex
lin agglomerator_N = mkN "แอ็กโกลมีราเตอร์" | mkN "เครื่องย่อยวัสดุให้เป็นเม็ด" ; -- src=panlex
lin agglutinate_A = mkA "ซึ่งใช้กาวติด" | mkA "ซึ่งติดกัน" ; -- src=panlex
lin agglutination_N = mkN "การเกาะกลุ่ม" | mkN "การเกาะติดกัน" | mkN "การเกาะติดกัน" | mkN "ก้อนที่เกาะติดกัน" ; -- src=panlex
lin agglutinative_A = mkA "ซึ่งใช้กาวติด" | mkA "ซึ่งเป็นภาษาคำติดต่อ" ; -- src=panlex
lin agglutinin_N = mkN "แอ็กกลูตินิน" ; -- src=panlex
lin agglutinogen_N = mkN "แอกกลูติโนเจน" ; -- src=panlex
lin aggrandizement_N = mkN "การยกสูงขึ้น" ; -- src=panlex
lin aggravation_N = mkN "ความโมโห" ; -- src=panlex
lin aggravator_N = mkN "คนที่น่ารำคาญ" ; -- src=panlex
lin aggregate_A = mkA "รวม" | mkA "สรุป" | mkA "รวมตัว" | mkA "ไหลไปรวมกัน" | mkA "สิ่งที่รวมตัวกัน" | mkA "ที่เป็นจํานวนทั้งหมด" ; -- src=panlex
lin aggregate_N = mkN "ผลรวม" | mkN "มวลรวม" | mkN "ผลรวม" | mkN "ผลรวบยอด" | mkN "จํานวนรวมทั้งหมด" | mkN "ส่วนผสมของคอนกรีต" ; -- src=panlex
lin aggregate_V = mkV "รวบรวม" | mkV "รวมยอด" | mkV "รวบรวม" | mkV "รวมกัน" | mkV "รวมยอด" | mkV "รวมเป็นจํานวนเท่ากับ" ; -- src=panlex
lin aggregate_V2 = mkV2 "รวบรวม" ; ---- | mkV "รวมยอด" | mkV "รวบรวม" | mkV "รวมกัน" | mkV "รวมยอด" | mkV "รวมเป็นจํานวนเท่ากับ" ; -- src=panlex
lin aggregation_N = mkN "ชุด" | mkN "การรวบรวม" | mkN "การรวมกัน" | mkN "ของที่สะสม" | mkN "คอลเลคชั่น" | mkN "การรวมกลุ่ม" | mkN "สิ่งที่รวมไว้" | mkN "กลุ่มรวม" | mkN "การรวมกัน" | mkN "ภาวะที่รวมเป็นกลุ่ม" ; -- src=panlex
lin aggression_N = mkN "ความก้าวร้าว" | mkN "การบุกรุก" | mkN "การรุกราน" | mkN "การล่วงละเมิด" ; -- src=panlex
lin aggressive_A = mkA "ก้าวร้าว" | mkA "มั่นใจ" | mkA "รุกราน" | mkA "ก้าวร้าว" | mkA "เริ่มต่อสู้" | mkA "เริ่มทะเลาะ" | mkA "เริ่มรุกราน" | mkA "ซึ่งมีความมั่นใจสูง" | mkA "ซึ่งลุกลามอย่างรวดเร็ว" ; -- src=panlex
lin aggressiveness_N = mkN "ความก้าวร้าว" ; -- src=panlex
lin aggressorFem_N = variants {} ; ---- sense to be split
lin aggressorMasc_N = variants {} ; ---- sense to be split
lin aghast_A = mkA "ตกตะลึง" | mkA "น่าสะพรึงกลัว" | mkA "อกสั่นขวัญหนี" | mkA "ซึ่งทําให้อกสั่นขวัญหนี" ; -- src=panlex
lin agile_A = mkA "ว่องไว" | mkA "ว่องไว" | mkA "กระฉับ กระเฉง" | mkA "คล่องแคล่ว" | mkA "กระฉับกระเฉง" | mkA "คล่องแคล่วว่องไว" ; -- src=panlex
lin agility_N = mkN "ความว่องไว" | mkN "ความคล่องตัว" | mkN "ความคล่องแคล่ว" ; -- src=panlex
lin aging_N = mkN "การแก่ตัว" ; -- src=panlex
lin agio_N = mkN "ค่าธรรมเนียมแลกเปลี่ยนเงินตราต่างประเทศ" | mkN "ค่าธรรมเนียมในการแลกเปลี่ยนเงินตรา" ; -- src=panlex
lin agitate_V = mkV "เชค" | mkV "รื้อ" | mkV "สั่น" | mkV "เขยิบ" | mkV "เขย่า" | mkV "ก่อกวน" | mkV "รณรงค์" | mkV "กระเถิบ" | mkV "ปลุกปั่น" | mkV "เขย่า" | mkV "ก่อกวน" | mkV "ปลุกปั่น" | mkV "ปลุกระดม" | mkV "ปลุกเร้า" | mkV "ทําให้สั่น" | mkV "ทําให้ปั่นป่วน" | mkV "ทําให้เป็นกังวล" ; -- src=panlex
lin agitate_V2 = mkV2 "เชค" ; ---- | mkV "รื้อ" | mkV "สั่น" | mkV "เขยิบ" | mkV "เขย่า" | mkV "ก่อกวน" | mkV "รณรงค์" | mkV "กระเถิบ" | mkV "ปลุกปั่น" | mkV "เขย่า" | mkV "ก่อกวน" | mkV "ปลุกปั่น" | mkV "ปลุกระดม" | mkV "ปลุกเร้า" | mkV "ทําให้สั่น" | mkV "ทําให้ปั่นป่วน" | mkV "ทําให้เป็นกังวล" ; -- src=panlex
lin agitation_N = mkN "ความชุลมุน" | mkN "ความไม่สงบ" | mkN "ความวุ่นวาย" | mkN "ความกระวนกระวาย" ; -- src=panlex
lin agitator_N = mkN "ผู้ยุแหย่" | mkN "ผู้ปลุกปั่น" ; -- src=panlex
lin agleam_A = mkA "สว่าง" | mkA "่สองแสง" | mkA "นิดหน่อย" | mkA "ที่ส่องแสง" ; -- src=panlex
lin aglet_N = mkN "สายสะพายเครื่องแบบ" | mkN "โลหะหุ้มหรือปลอกหุ้ม" ; -- src=panlex
lin aglow_A = mkA "สว่าง" | mkA "วาววับ" | mkA "เปล่งปลั่ง" ; -- src=panlex
lin agnail_N = mkN "ภาวะด้านข้างของเล็กแทงเพข้าไปในเนื้อ" ; -- src=panlex
lin agnate_A = mkA "ญาติฝ่ายผู้ชาย" ; -- src=panlex
lin agnate_N = mkN "ญาติฝ่ายบิดา" | mkN "ญาติฝ่ายพ่อ" | mkN "ญาติฝ่ายผู้ชาย" ; -- src=panlex
lin agnomen_N = mkN "ชื่อเล่น" | mkN "ชื่อเล่น" | mkN "ชื่อเสริม" | mkN "ฐานันดรศักดิ์ของชาวโรมัน" ; -- src=panlex
lin agnostic_A = mkA "ที่ไม่แน่ใจในความรู้" | mkA "เกี่ยวกับผู้ไม่เชื่อการมีอยู่ของพระเจ้า" ; -- src=panlex
lin agnostic_N = mkN "ผู้สงสัย" | mkN "แอ็กนอสติก" | mkN "ผู้ที่เชื่อว่าไม่สามารถพิสูจน์ได้ถึงการมีอยู่ของพระเจ้า" ; -- src=panlex
lin agnosticism_N = mkN "กังขาคติ" | mkN "ทฤษฎีที่ไม่มีใครที่อาจจะรู้ได้" ; -- src=panlex
lin ago_Adv = mkAdv "มาแล้ว" | mkAdv "ในอดีต" | mkAdv "แต่ก่อน" | mkAdv "เมื่อก่อน" | mkAdv "ที่ผ่านมาแล้ว" ; -- src=panlex
lin agog_A = mkA "ตื่นเต้นมาก" ; -- src=panlex
lin agon_N = mkN "อากอน" ; -- src=panlex
lin agonadal_A = mkA "ไม่มีอวัยวะเพศ" ; -- src=panlex
lin agonal_A = mkA "เกี่ยวกับการทรมาน" ; -- src=panlex
lin agonist_N = mkN "ตัวเอก" | mkN "ตัวทำการ" | mkN "กล้ามเนื้อทำการ" ; -- src=panlex
lin agonistic_A = mkA "เกี่ยวกับการแข่งขันกีฬา" ; -- src=panlex
lin agonize_V = mkV "เจ็บปวด" | mkV "ทำให้เจ็บปวด" | mkV "ดิ้นรน" | mkV "ปวดร้าว" | mkV "เจ็บปวด" | mkV "เจ็บร้าว" | mkV "เป็นกังวล" | mkV "ทําให้ทรมาน" | mkV "ทําให้เจ็บปวด" ; -- src=panlex
lin agonized_A = mkA "ทุกข์ทรมาน" ; -- src=panlex
lin agonizingly_Adv = mkAdv "อย่างทุกข์ทรมาน" | mkAdv "อย่างเจ็บปวดทรมาน" ; -- src=panlex
lin agony_N = mkN "ความทุกข์ทรมาน" | mkN "การดิ้นรน" | mkN "ความทรมาน" | mkN "ความทุกข์" | mkN "ความกลัดกลุ้ม" | mkN "การระเบิดอารมณ์" | mkN "ความเจ็บปวดแสนสาหัส" ; -- src=panlex
lin agora_N = mkN "แอโกรา" | mkN "อะโกร่า" | mkN "ตลาดกลางแจ้ง" | mkN "จัตุรัสสาธารณะ" | mkN "เวที" | mkN "สถานที่ ๆ มีการชุมนุมดังกล่าว" | mkN "การชุมนุมทางการเมืองที่มีชื่อเสียง" ; -- src=panlex
lin agoraphobia_N = mkN "ความกลัวฝูงชน" | mkN "อาการกลัวที่โล่ง" | mkN "โรคกลัวอยู่ในที่โล่งหรือที่ชุมชน" ; -- src=panlex
lin agoraphobic_A = mkA "ซึ่งกลัวที่โล่ง" ; -- src=panlex
lin agouti_N = mkN "อากูติ" ; -- src=panlex
lin agranulocytic_A = mkA "ที่เกี่ยวกับความผิดปรกติของเลือด" ; -- src=panlex
lin agrarian_A = mkA "เกษตร" | mkA "เกษตรกรรม" | mkA "เกี่ยวกับชาวนา" | mkA "เกี่ยวกับไร่นาและที่ดิน" ; -- src=panlex
lin agree_V = mkV "เหมาะ" | mkV "ตรงกัน" | mkV "ยอมรับ" | mkV "กลมกลืน" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เหมือนกัน" | mkV "ตกลง" | mkV "ตัดสิน" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "เข้ากัน" | mkV "ลงรอยกัน" | mkV "เหมาะกับ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "สอดคล้องกัน" | mkV "ไปด้วยกันได้" | mkV "ยอมรับความจริง" ; -- src=panlex
lin agree_VS = mmkVS "เหมาะ" ; ---- | mkV "ตรงกัน" | mkV "ยอมรับ" | mkV "กลมกลืน" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เหมือนกัน" | mkV "ตกลง" | mkV "ตัดสิน" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "เข้ากัน" | mkV "ลงรอยกัน" | mkV "เหมาะกับ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "สอดคล้องกัน" | mkV "ไปด้วยกันได้" | mkV "ยอมรับความจริง" ; -- src=panlex
lin agree_VV = mkVV "เหมาะ" ; ---- | mkV "ตรงกัน" | mkV "ยอมรับ" | mkV "กลมกลืน" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เหมือนกัน" | mkV "ตกลง" | mkV "ตัดสิน" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "เข้ากัน" | mkV "ลงรอยกัน" | mkV "เหมาะกับ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "สอดคล้องกัน" | mkV "ไปด้วยกันได้" | mkV "ยอมรับความจริง" ; -- src=panlex
lin agree_on_V = advV OP_agree_V OP_on_Adv ; -- guess-p-verb
lin agree_with_V2 = prepV2 OP_agree_V OP_with_Prep ; -- guess-p-verb
lin agreeable_A = mkA "ที่สอดคล้องกับความคิด" | mkA "น่าคบ" | mkA "น่าพอใจ" | mkA "เป็นมิตร" | mkA "เห็นด้วย" | mkA "ซึ่งยินยอม" | mkA "ซึ่งเห็นด้วย" | mkA "เป็นที่พึงพอใจ" | mkA "ซึ่งยินดีทําตาม" | mkA "เต็มใจหรือพร้อมที่จะตกลง" ; -- src=panlex
lin agreed_A = mkA "ซึ่งตกลงกันแล้ว" ; -- src=panlex
lin agreement_N = mkN "ข้อตกลง" | mkN "ความสอดคล้องกัน" | mkN "สัญญา" | mkN "การตกลง" | mkN "ข้อตกลง" | mkN "ความตกลง" | mkN "คําสัญญา" | mkN "ความเห็น ตรงกัน" | mkN "การยินยอม" | mkN "ความยินยอม" | mkN "การเห็นด้วย" | mkN "การเห็นพ้อง" | mkN "ความเห็นพ้อง" | mkN "หนังสือสัญญา" | mkN "การยอมรับร่วมกัน" | mkN "การเห็นชอบร่วมกัน" | mkN "ความสอดคล้องทางไวยากรณ์" | mkN "ความสอดคล้องระหว่างประธานและกริยา" ; -- src=panlex
lin agrestic_A = mkA "เซอะซะ" | mkA "บ้านนอก" | mkA "ไม่สละสลวย" ; -- src=panlex
lin agribusiness_N = mkN "ธุรกิจด้านเกษตรกรรม" ; -- src=panlex
lin agricultural_A = mkA "เกษตร" | mkA "เกษตรกรรม" | mkA "ทางการเกษตร" | mkA "ที่เกี่ยวกับเกษตรกรรม" ; -- src=panlex
lin agriculture_N = mkN "การเกษตร" | mkN "ชนชั้นเกษตรกร" | mkN "ธุรกิจด้านเกษตรกรรม" | mkN "กสิกรรม" | mkN "การเกษตร" | mkN "เกษตรกรรม" | mkN "เกษตรศาสตร์" ; -- src=panlex
lin agriculturist_N = mkN "กสิกร" | mkN "เกษตรกร" | mkN "กสิกร" | mkN "ชาวนา" | mkN "เกษตรกร" | mkN "ชาวไร่ชาวนา" ; -- src=panlex
lin agrobiologic_A = mkA "เกี่ยวกับชีวเกษตร" ; -- src=panlex
lin agrobiology_N = mkN "ชีวเกษตรกรรม" ; -- src=panlex
lin agrologic_A = mkA "เกี่ยวกับวิทยาศาสตร์การเกษตร" ; -- src=panlex
lin agrology_N = mkN "ปฐพีเกษตรกรรม" | mkN "วิทยาศาสตร์ที่ศึกษาเกี่ยวกับผลผลิตทางการเกษตร" ; -- src=panlex
lin agronomic_A = mkA "ที่ส่งเสริมการผลิต" ; -- src=panlex
lin agronomy_N = mkN "ปฐพีศาสตร์" | mkN "วิทยาศาสตร์และเศรษฐศาสตร์เกี่ยวกับผลผลิตทางการเกษตร" ; -- src=panlex
lin aground_A = mkA "ตามแนวชายฝั่ง" | mkA "เกยตื้น" | mkA "บนพื้นดิน" ; -- src=panlex
lin aground_Adv = mkAdv "เกยตื้น" | mkAdv "บนพื้นดิน" ; -- src=panlex
lin ague_N = mkN "เครื่องหมายแสดงการเน้นเสียง" | mkN "อาการสั่น" ; -- src=panlex
lin agueweed_N = mkN "ต้นโบนเซต" | mkN "ต้นเอกวีวีด" ; -- src=panlex
lin ah_Interj = mkInterj "แหม" | mkInterj "ความเจ็บปวด" | mkInterj "ความประหลาดใจ" ; -- src=panlex
lin ahead_Adv = mkAdv "ตรงไป" | mkAdv "ข้างหน้า" | mkAdv "ล่วงหน้า" | mkAdv "สู่อนาคต" | mkAdv "อยู่หน้า" | mkAdv "อย่างคู่คี่" | mkAdv "ชนะไป" | mkAdv "ต่อไป" | mkAdv "ออกหน้า" | mkAdv "ในอนาคต" | mkAdv "ด้านหน้า" | mkAdv "ล้ําหน้า" | mkAdv "แต้มนําไป" | mkAdv "ขึ้นหน้าไป" | mkAdv "ไปข้างหน้า" | mkAdv "ก่อนหน้านี้" ; -- src=panlex
lin ahimsa_N = mkN "อหิงสา" | mkN "หลักอหิงสา" | mkN "หลักสันติอหิงสา" ; -- src=panlex
lin ahistorical_A = mkA "ที่ไม่เกี่ยวกับประวัติศาสตร์" ; -- src=panlex
lin aid_N = mkN "การดูแล" | mkN "ผู้ช่วย" | mkN "การช่วยเหลือ" | mkN "การดูแลรักษา" | mkN "ความช่วยเหลือ" | mkN "เงินช่วยเหลือ" | mkN "การดูแลเอาใจใส่" | mkN "เงินช่วยเหลือทางเศรษฐกิจ" | mkN "ผู้ช่วย" | mkN "ความช่วยเหลือ" | mkN "ผู้ที่ช่วยเหลือ" | mkN "สิ่งที่ช่วยเหลือ" ; -- src=panlex
lin aid_V = mkV "ช่วย" | mkV "ช่วยเหลือ" | mkV "ช่วยเหลือ" | mkV "สงเคราะห์" | mkV "เกื้อหนุน" | mkV "อนุเคราะห์" ; -- src=panlex
lin aid_V2 = mkV2 "ช่วย" ; ---- | mkV "ช่วยเหลือ" | mkV "ช่วยเหลือ" | mkV "สงเคราะห์" | mkV "เกื้อหนุน" | mkV "อนุเคราะห์" ; -- src=panlex
lin aide_N = mkN "ผู้ช่วย" | mkN "นายทหารฝ่ายธุรการ" | mkN "นายทหารฝ่้ายธุรการ" | mkN "ผู้ช่วย" | mkN "องครักษ์" | mkN "ราชองครักษ์" | mkN "นายทหารคนสนิท" | mkN "นายทหารผู้ช่วย" ; -- src=panlex
lin aigrette_N = mkN "ขนนกประดับ" ; -- src=panlex
lin aikido_N = mkN "อาคิโด" ; -- src=panlex
lin ail_V = mkV "ป่วย" | mkV "ไม่สบาย" | mkV "ทำให้ป่วย" | mkV "ทำให้ไม่สบาย" | mkV "ทำให้เจ็บป่วย" | mkV "ปวด" | mkV "ป่วย" | mkV "ไม่สบาย" | mkV "ทําให้ปวด" | mkV "ทําให้ทรมาน" | mkV "ทําให้ไม่สบาย" | mkV "ทําให้เจ็บป่วย" ; -- src=panlex
lin ail_V2 = mkV2 "ป่วย" ; ---- | mkV "ไม่สบาย" | mkV "ทำให้ป่วย" | mkV "ทำให้ไม่สบาย" | mkV "ทำให้เจ็บป่วย" | mkV "ปวด" | mkV "ป่วย" | mkV "ไม่สบาย" | mkV "ทําให้ปวด" | mkV "ทําให้ทรมาน" | mkV "ทําให้ไม่สบาย" | mkV "ทําให้เจ็บป่วย" ; -- src=panlex
lin aileron_N = mkN "พื้นผิวหน้าที่เคลื่อนไหวได้" | mkN "ปีกเสริม" | mkN "ปีกประกอบ" | mkN "ผิวหน้าที่เคลื่อนไหวได้" | mkN "พื้นผิวหน้าที่เคลื่อนไหวได้" ; -- src=panlex
lin ailment_N = mkN "ความเจ็บป่วย" | mkN "โรคภัยไข้เจ็บ" | mkN "ความป่วย" | mkN "อาการป่วย" | mkN "โรคทางกาย" | mkN "ความเจ็บไข้" | mkN "ความเจ็บป่วย" | mkN "ความไม่สบายกาย" ; -- src=panlex
lin ailurophobia_N = mkN "อาการกลัวแมว" ; -- src=panlex
lin aim_N = mkN "ทิศทาง" | mkN "จุดประสงค์" | mkN "จุดมุ่งหมาย" | mkN "เป้า" | mkN "เล็ง" | mkN "เข้าหา" | mkN "การเล็ง" | mkN "จุดหมาย" | mkN "ที่หมาย" | mkN "มุ่งหมาย" | mkN "เป้าหมาย" | mkN "ความตั้งใจ" | mkN "จุดประสงค์" | mkN "จุดมุ่งหมาย" | mkN "ความมุ่งหมาย" | mkN "ทักษะการเล็ง" | mkN "วัตถุประสงค์" | mkN "ระดับความแม่นยํา" ; -- src=panlex
lin aim_V = mkV "มุ่ง" | mkV "เล็ง" | mkV "ตั้งใจ" | mkV "ตั้งเป้า" | mkV "ต้องการไป" | mkV "จัดโครงการ" | mkV "มีเป้าหมาย" | mkV "ตั้งความหวัง" | mkV "เจตนา" | mkV "ตั้งใจ" | mkV "วางแผน" | mkV "ตั้งเป้า" | mkV "มุ่งเป้า" | mkV "เล็งเป้าหมาย" ; -- src=panlex
lin aim_V2 = mkV2 "มุ่ง" ; ---- | mkV "เล็ง" | mkV "ตั้งใจ" | mkV "ตั้งเป้า" | mkV "ต้องการไป" | mkV "จัดโครงการ" | mkV "มีเป้าหมาย" | mkV "ตั้งความหวัง" | mkV "เจตนา" | mkV "ตั้งใจ" | mkV "วางแผน" | mkV "ตั้งเป้า" | mkV "มุ่งเป้า" | mkV "เล็งเป้าหมาย" ; -- src=panlex
lin aim_VV = mkVV "มุ่ง" ; ---- | mkV "เล็ง" | mkV "ตั้งใจ" | mkV "ตั้งเป้า" | mkV "ต้องการไป" | mkV "จัดโครงการ" | mkV "มีเป้าหมาย" | mkV "ตั้งความหวัง" | mkV "เจตนา" | mkV "ตั้งใจ" | mkV "วางแผน" | mkV "ตั้งเป้า" | mkV "มุ่งเป้า" | mkV "เล็งเป้าหมาย" ; -- src=panlex
lin aim_at_V2 = prepV2 OP_aim_V OP_at_Prep ; -- guess-p-verb
lin aimless_A = mkA "เลื่อนลอย" | mkA "ไร้จุดหมาย" | mkA "ไม่มีจุดหมาย" ; -- src=panlex
lin aioli_N = mkN "ซอสไอโอลี" ; -- src=panlex
lin air_N = mkN "ลม" | mkN "รังสี" | mkN "ลมโชย" | mkN "อากาศ" | mkN "ธาตุลม" | mkN "บรรยากาศ" | mkN "สื่ออากาศ" | mkN "สายลมอ่อนๆ" | mkN "ชั้นบรรยากาศ" | mkN "การโดยสารเครื่องบิน" | mkN "การเดินทางโดยเครื่องบิน" | mkN "ลม" | mkN "เผย" | mkN "เพลง" | mkN "อวกาศ" | mkN "อากาศ" | mkN "ทํานอง" | mkN "ลมเย็น" | mkN "ลมอ่อน ๆ" | mkN "ท้องฟ้า" | mkN "กลิ่นอาย" | mkN "การหายใจ" | mkN "กินอากาศ" | mkN "บรรยากาศ" | mkN "ออกอากาศ" | mkN "ผึ่งอากาศ" | mkN "ท่วงทํานอง" | mkN "ลมที่พัดเบา" | mkN "ลักษณะเฉพาะ" | mkN "ออกโทรทัศน์" | mkN "ลักษณะท่าทาง" | mkN "คุณสมบัติเฉพาะ" | mkN "ออกความคิดเห็น" | mkN "อาการกลืนอากาศ" | mkN "เครื่องปรับอากาศ" | mkN "เครื่องทําความเย็น" | mkN "การเดินทางโดยเครื่องบิน" | mkN "ทําให้ลมเข้าออกได้สะดวก" ; -- src=panlex
lin air_V = mkV "ผึ่ง" | mkV "ตากลม" | mkV "โฆษณา" | mkV "ผึ่งลม" | mkV "ถ่ายทอด" | mkV "เผยแพร่" | mkV "ออกอากาศ" | mkV "เปิดโล่ง" | mkV "กระจายเสียง" | mkV "แสดง" | mkV "ประกาศ" | mkV "ถ่ายทอด" | mkV "ออกอากาศ" | mkV "เปิดโล่ง" | mkV "ระบายอากาศ" | mkV "กระจายเสียง" | mkV "ปล่อยให้อากาศเข้า" | mkV "ออกอากาศทางสถานีวิทยุหรือโทรทัศน์" ; -- src=panlex
lin air_V2 = mkV2 "ผึ่ง" ; ---- | mkV "ตากลม" | mkV "โฆษณา" | mkV "ผึ่งลม" | mkV "ถ่ายทอด" | mkV "เผยแพร่" | mkV "ออกอากาศ" | mkV "เปิดโล่ง" | mkV "กระจายเสียง" | mkV "แสดง" | mkV "ประกาศ" | mkV "ถ่ายทอด" | mkV "ออกอากาศ" | mkV "เปิดโล่ง" | mkV "ระบายอากาศ" | mkV "กระจายเสียง" | mkV "ปล่อยให้อากาศเข้า" | mkV "ออกอากาศทางสถานีวิทยุหรือโทรทัศน์" ; -- src=panlex
lin airborne_A = mkA "ที่ถูกขนส่งผ่านอากาศ" | mkA "ร่อน" | mkA "ลอยในอากาศ" | mkA "ขนมาทางอากาศ" | mkA "ลงมาจากอากาศ" ; -- src=panlex
lin airbrake_N = mkN "ห้ามล้อ" | mkN " เครื่องมือลดความเร็วเครื่องบิน" | mkN "ระบบเบรคด้วยอากาศที่อัดอยู่" | mkN "เครื่องมือลดความเร็วเครื่องบิน" ; -- src=panlex
lin airbrush_N = mkN "แอร์บรัช" | mkN "แปรงพ่นสี" ; -- src=panlex
lin airbus_N = mkN "แอร์บัส" | mkN "เครื่องบินแอร์บัส" | mkN "เครื่องบินโดยสารขนาดใหญ่" ; -- src=panlex
lin aircraft_N = mkN "ยานอากาศ" | mkN "อากาศยาน" | mkN "สิ่งต่างๆ ที่สร้างสําหรับการบิน" | mkN "เครื่องบิน" ; -- src=panlex
lin aircraftman_N = mkN "ทหารอากาศชั้นประทวน" ; -- src=panlex
lin aircraftsman_N = mkN "ทหารอากาศชั้นประทวน" ; -- src=panlex
lin aircrew_N = mkN "พนักงานเครื่องบิน" | mkN "ลูกเรือเครื่องบิน" | mkN "พนักงานประจำเครื่องบิน" | mkN "ลูกเรือบนเครื่องบิน" ; -- src=panlex
lin aircrewman_N = mkN "ลูกเรือ" | mkN "ลูกเรือบนเครื่องบิน" ; -- src=panlex
lin airdock_N = mkN "โรงเก็บเครื่องบิน" ; -- src=panlex
lin airdrop_N = mkN "การกระโดดร่มชูชีพจากเครื่องบิน" ; -- src=panlex
lin airfare_N = mkN "ค่าเครื่องบิน" | mkN "ค่าตั๋วเครื่องบิน" ; -- src=panlex
lin airfield_N = mkN "ลานบิน" | mkN "ลานบิน" ; -- src=panlex
lin airflow_N = mkN "การไหลของอากาศ" | mkN "กระแสลม" | mkN "กระแสลมที่เกิดจากเครื่องบินหรือรถยนต์ที่วิ่งผ่าน" ; -- src=panlex
lin airfoil_N = mkN "เเพนอากาศ" | mkN "แอร์ฟอยล์" | mkN "แอโรฟอยล์" ; -- src=panlex
lin airforce_N = mkN "ทัพอากาศ" | mkN "กองทัพอากาศ" ; -- src=panlex
lin airframe_N = mkN "แอร์เฟรม" | mkN "โครงสร้างอากาศยาน" | mkN "โครงสร้างเครื่องบิน" ; -- src=panlex
lin airhead_N = mkN "คนสมองกลวง" | mkN "คนหัวขี้เลื่อย" ; -- src=panlex
lin airiness_N = mkN "การลอย" | mkN "การลอยตัว" | mkN "ความบางเบา" ; -- src=panlex
lin airing_N = mkN "การเผยแพร่" | mkN "การตาก" | mkN "การตากลม" | mkN "การสนทนาโต้แย้ง" | mkN "การผึ่งลมเพื่อให้แห้ง" ; -- src=panlex
lin airless_A = mkA "ที่ไม่มีอากาศบริสุทธิ์" ; -- src=panlex
lin airlift_N = mkN "การขนส่งทางอากาศ" ; -- src=panlex
lin airline_N = mkN "ท่ออากาศ" | mkN "แอร์เวย์" | mkN "แอร์ไลน์" | mkN "สายการบิน" | mkN "ธุรกิจสายการบิน" | mkN "สายการบิน" ; -- src=panlex
lin airliner_N = mkN "เครื่องบินพาณิชย์" | mkN "สายการบิน" ; -- src=panlex
lin airlock_N = mkN "แอร์ล็อค" ; -- src=panlex
lin airmail_N = mkN "ไปรษณีย์อากาศ" | mkN "จดหมายที่ส่งทางเครื่องบิน" ; -- src=panlex
lin airman_N = mkN "นักบิน" | mkN "คนขับเครื่องบิน" | mkN "ทหารอากาศ" | mkN "นักขับเครื่องบิน" ; -- src=panlex
lin airplane_N = mkN (thword "เครื่อง" "บิน") "ลำ" | {-pan-} mkN "เครื่อง" | mkN "เครื่องบิน" | mkN "เรือบิน" | mkN "เครื่องบิน" ; -- src=panlex
lin airport_N = mkN (thword "สนาม" "บิน") ;
lin airscrew_N = mkN "ใบพัด" | mkN "ใบพัดเครื่องบิน" | mkN "ใบพัดเครื่องบิน" ; -- src=panlex
lin airship_N = mkN "เรือเหาะ" ; -- src=panlex
lin air_sick_A = mkA "เมาเครื่องบิน" ; -- src=panlex
lin air_sickness_N = mkN "อาการเมาเครื่องบิน" | mkN "การเมาเครื่องบิน" ; -- src=panlex
lin airspace_N = mkN "น่านฟ้า" | mkN "ห้วงอวกาศ" | mkN "เขตน่านฟ้า" | mkN "น่านฟ้า" ; -- src=panlex
lin airspeed_N = mkN "ความเร็วอากาศ" | mkN "ความเร็วของเครื่อง" | mkN "ความเร็วของเครื่องบิน" ; -- src=panlex
lin airstream_N = mkN "กระแสลมดูด" | mkN "กระแสอากาศ" ; -- src=panlex
lin airstrip_N = mkN "ลานบิน" | mkN "ทางวิ่งเครื่องบิน" | mkN "ทางวิ่งของเครื่องบิน" ; -- src=panlex
lin airtight_A = mkA "ซึ่งไม่ให้อากาศผ่าน" | mkA "ไม่มีจุดอ่อน" | mkA "ที่ไม่มีจุดให้โต้ตอบ" | mkA "ผนึกแน่นไม่ให้อากาศเข้า" | mkA "ที่ผนึกแน่นไม่ให้อากาศเข้า" ; -- src=panlex
lin airway_N = mkN "ท่อลม" | mkN "แอร์เวย์" | mkN "แอร์ไลน์" | mkN "สายการบิน" | mkN "เส้นทางบิน" | mkN "ทางเดินหายใจ" | mkN "ธุรกิจสายการบิน" | mkN "ทางเดินอากาศหายใจ" | mkN "เส้นทางบิน" ; -- src=panlex
lin airwoman_N = mkN "นักบินหญิง" ; -- src=panlex
lin airworthy_A = mkA "ที่มีคุณสมบัติในการบิน" | mkA "ได้มาตรฐานความปลอดภัยสําหรับการบิน" ; -- src=panlex
lin airy_A = mkA "เบาเหมือนอากาศ" | mkA "ซึ่งมีอากาศถ่ายเท" | mkA "เบา" | mkA "โล่ง" | mkA "เบาใจ" | mkA "โปร่ง" | mkA "สบายใจ" | mkA "บนอากาศ" | mkA "เพ้อฝัน" | mkA "จินตนาการ" | mkA "คล่องแคล่ว" | mkA "ที่อยู่บนอากาศ" | mkA "ที่บางเบาเหมือนอากาศ" | mkA "ซึ่งมีอากาศถ่ายเทได้สะดวก" ; -- src=panlex
lin aisle_N = mkN "ทางเดินระหว่างที่นั่ง" | mkN "ทางเดินระหว่างที่นั่ง" ; -- src=panlex
lin aitchbone_N = mkN "เนื้อส่วนสะโพก" | mkN "สะโพก" | mkN "กระดูกตะโพก" | mkN "กระดูกสะโพก" | mkN "เนื้อส่วนสะโพก" ; -- src=panlex
lin ajar_A = mkA "ไม่ลงรอยกัน" | mkA "เปิดแง้มอยู่" | mkA "ไม่สอดคล้องกัน" ; -- src=panlex
lin akaryocyte_N = mkN "อะคาริโอต" | mkN "เซลล์อะคาริโอต" ; -- src=panlex
lin akimbo_Adv = mkAdv "เท้าสะเอว" | mkAdv "เท้าสะเอว" ; -- src=panlex
lin akin_A = mkA "คล้ายกัน" | mkA "เหมือนกัน" | mkA "เกี่ยวดองกัน" | mkA "ตระกูลเดียวกัน" | mkA "เป็นพี่น้องกัน" | mkA "มีคุณสมบัติบางอย่างเหมือนกัน" ; -- src=panlex
lin ala_N = mkN "ปีกแมลง" ; -- src=panlex
lin alabaster_A = mkA "เหมือนหินปูน" ; -- src=panlex
lin alabaster_N = mkN "อะลาบาสเทอร์" | mkN "แร่อะลาบาสเทอร์" | mkN "หินปูนชนิดหนึ่งที่เป็นยิปซัมลื่นและขาวสะอาด" ; -- src=panlex
lin alacrity_N = mkN "ความเต็มใจ" | mkN "ความฮึกเหิม" | mkN "ความคล่องแคล่ว" | mkN "ความกระตือรือร้น" ; -- src=panlex
lin alanine_N = mkN "อะลานีน" ; -- src=panlex
lin alar_A = mkA "ที่คล้ายปีก" | mkA "เกี่ยวกับง่ามไม้" | mkA "คล้ายปีก" | mkA "เกี่ยวกับหรือมีปีก" ; -- src=panlex
lin alarm_N = mkN "ระบบเตือนภัย" | mkN "ความตระหนกตกใจ" | mkN "ความตื่นตระหนก" | mkN "สัญญาณเตือนภัย" | mkN "ความกลัว" | mkN "เสียงเตือน" | mkN "สัญญาณบอกเหตุ" | mkN "สัญญาณเตือนภัย" | mkN "กระดิ่งของนาฬิกาปลุก" ; -- src=panlex
lin alarming_A = mkA "น่าวิตก" | mkA "ซึ่งน่าตกใจ" | mkA "ที่น่าหวาดกลัว" ; -- src=panlex
lin alarmist_N = mkN "กระต่ายตื่นตูม" | mkN "พวกกระต่ายตื่นตูม" | mkN "ผู้ชอบทําให้ตกใจกลัวด้วยเรื่องเล็ก" ; -- src=panlex
lin alas_Interj = mkInterj "โธ่" | mkInterj "โว้ย" | mkInterj "ปัดโธ่" | mkInterj "ปัทโธ่" | mkInterj "อนิจจา" | mkInterj "อนิจจัง" | mkInterj "โถ" | mkInterj "โธ่" | mkInterj "ปัดโธ่" | mkInterj "ปัทโธ่" | mkInterj "พุทโธ่" | mkInterj "อนิจจา" | mkInterj "อนิจจัง" | mkInterj "คําอุทานแสดงความเศร้าหรือเสียใจ" ; -- src=panlex
lin alate_A = mkA "ซึ่งมีปีก" ; -- src=panlex
lin alb_N = mkN "เสื้อคลุมยาวของบาทหลวง" ; -- src=panlex
lin albacore_N = mkN "ปลาอัลบาคอร์" | mkN "เนื้อปลาอัลบาคอร์" | mkN "ปลาทูน่าชนิดหนึ่ง" ; -- src=panlex
lin albanian_A = mkA "ภาษาอัลบาเนีย" | mkA "เกี่ยวกับประเทศอัลบาเนีย" ; -- src=panlex
lin albanian_N = mkN "ภาษาอัลบาเนีย" | mkN "เกี่ยวกับประเทศอัลบาเนีย" ; -- src=panlex
lin albatross_N = mkN "นกอัลบาทรอส" ; -- src=panlex
lin albedo_N = mkN "อัตราส่วนสะท้อน" | mkN "อัตราส่วนสะ้ท้อน" | mkN "อัตราสะท้อนกลับ" ; -- src=panlex
lin albescent_A = mkA "เปลี่ยนเป็นสีขาว" ; -- src=panlex
lin albinal_A = mkA "เผือก" ; -- src=panlex
lin albinism_N = mkN "ภาวะผิวเผือก" ; -- src=panlex
lin albino_N = mkN "คนเผือก" | mkN "คนหรือสัตว์ที่มีผิวเผือก" ; -- src=panlex
lin albite_N = mkN "อัลไบท์" | mkN "แร่อัลไบท์" ; -- src=panlex
lin albitic_A = mkA "เกี่ยวกับแร่หินภูเขาไฟ" ; -- src=panlex
lin albizzia_N = mkN "ต้นอัลบิซเซีย" ; -- src=panlex
lin albuca_N = mkN "ต้นอัลบูกา" ; -- src=panlex
lin albuginea_N = mkN "อาลบูจิเนีย" ; -- src=panlex
lin album_N = mkN "อัลบั้มบันทึก" | mkN "อัลบั้ม" | mkN "จานเสียง" | mkN "แผ่นเสียง" | mkN "ชุดแผ่นเสียง" | mkN "แผ่นเสียงขนาดใหญ่" | mkN "สมุดลงนามของผู้มาเยี่ยม" ; -- src=panlex
lin albumen_N = mkN "ไข่ขาว" | mkN "อัลบูมิน" | mkN "ไข่ขาว" ; -- src=panlex
lin albumin_N = mkN "อัลบูมิน" | mkN "โปรตีนชนิดหนึ่ง" ; -- src=panlex
lin albuminous_A = mkA "เหมือนอัลบูมิน" ; -- src=panlex
lin albuminuric_A = mkA "เกี่ยวกับอัลบูมินูเรีย" ; -- src=panlex
lin albuterol_N = mkN "อัลบูเทอรอล" ; -- src=panlex
lin alcalde_N = mkN "อัลคอลดี" ; -- src=panlex
lin alcazar_N = mkN "อัลคาซาร์" ; -- src=panlex
lin alchemic_A = mkA "ที่เกี่ยวกับการเล่นแร่แปรธาตุ" ; -- src=panlex
lin alchemist_N = mkN "นักเล่นแร่แปรธาตุ" ; -- src=panlex
lin alchemistic_A = mkA "ที่เกี่ยวกับนักเล่นแร่แปรธาตุ" ; -- src=panlex
lin alchemy_N = mkN "การมีปฏิกิริยา" | mkN "การเล่นแร่แปรธาตุ" | mkN "การเปลี่ยนแปลงบางสิ่งให้ดีขึ้นหรือมีพลังมากขึ้น" ; -- src=panlex
lin alcohol_N = mkN "เหล้า" | mkN "น้ำเมา" | mkN "แอลกอฮอล์" | mkN "เครื่องดองของเมา" | mkN "เครื่องดื่มแอลกอฮอล์" | mkN "เครื่องดื่มที่มีแอลกอฮอล์" | mkN "เครื่องดื่มที่มีส่วนผสมของแอลกฮอล์ล" | mkN "สุรา" | mkN "เหล้า" | mkN "แอลกอฮอล์" | mkN "สารชนิดหนึ่งไม่มีสี ติดไฟได้" | mkN "เครื่องดื่มที่มีแอลกอฮอล์" | mkN "เครื่องดื่มที่ผสมแอลกอฮอล์" ; -- src=panlex
lin alcoholic_A = mkA "ติดเหล้า" | mkA "ซึ่งติดสุรา" | mkA "ซึ่งมีแอลกอฮอล์" | mkA "คนติดเหล้า" | mkA "ซึ่งติดสุรา" | mkA "ซึ่งติดเหล้า" | mkA "ผสมแอลกอฮอล์" | mkA "ที่มีสุราอยู่" | mkA "ซึ่งเกี่ยวกับหรือ เกิดจากแอลกอฮอล์" | mkA "ซึ่งเกิดจากการดื่มสุรา" | mkA "ซึ่งเกิดจากการดื่มเหล้า" | mkA "ที่มีส่วนผสมของแอลกอฮอล์" ; -- src=panlex
lin alcoholic_N = mkN "ขี้เมา" | mkN "ขี้เหล้า" | mkN "คนขี้เมา" | mkN "คนขี้เหล้า" | mkN "ผู้ติดสุราเรื้อรัง" | mkN "ผู้ป่วยสุราเรื้อรัง" | mkN "ผู้ที่ติดสุรา" | mkN "ผู้ที่ติดเหล้า" ; -- src=panlex
lin alcoholism_N = mkN "การติดสุรา" | mkN "โรคพิษสุรา" | mkN "ความอยากสุรา" | mkN "โรคพิษสุราเรื้อรัง" | mkN "การติดสุรา" | mkN "การติดเหล้า" | mkN "โรคพิษสุราเรื้อรัง" ; -- src=panlex
lin alcove_N = mkN "มุข" | mkN "ติ่งห้อง" | mkN "ซุ้มไม้" | mkN "ส่วนที่เป็นเวิ้ง" | mkN "เวิ้งที่ติดกับห้องสําหรับตั้งเตียงตู้หรือเฟอร์นิเจอร์อื่น ๆ" ; -- src=panlex
lin aldehyde_N = mkN "อัลดีไฮด์" | mkN "แอลดีไฮด์" ; -- src=panlex
lin aldehydic_A = mkA "อัลดีไฮด์" ; -- src=panlex
lin alder_N = mkN "ต้นออลเดอร์" | mkN "ไม้อัลเดอร์" ; -- src=panlex
lin alderman_N = mkN "เทศมนตรี" ; -- src=panlex
lin aldermanic_A = mkA "ที่เกี่ยวกับเทศมนตรี" ; -- src=panlex
lin aldohexose_N = mkN "อัลโดเฮกโซส" | mkN "น้ำตาลอัลโดเฮกโซส" ; -- src=panlex
lin aldol_N = mkN "อัลดอล" | mkN "ใช้ในอุตสาหกรรมเครื่องสําอาง" ; -- src=panlex
lin aldose_N = mkN "อัลโดส" | mkN "น้ำตาลอัลโดส" ; -- src=panlex
lin aldosterone_N = mkN "แอลโดสเตอโรน" ; -- src=panlex
lin ale_N = mkN "เหล้าเอล" | mkN "เครื่องดื่มที่ทําจากข้าว" | mkN "เครื่องดื่มมีแอลกอฮอล์ชนิดหนึ่งที่ทําจากข้าวมอลต์" ; -- src=panlex
lin aleatory_A = mkA "แล้วแต่ดวง" | mkA "ซึ่งผสมกันยุ่ง" | mkA "แล้วแต่เหตุการณ์" ; -- src=panlex
lin alee_A = mkA "อยู่ใต้ลม" | mkA "ไปทางใต้ลม" ; -- src=panlex
lin alee_Adv = mkAdv "อยู่ใต้ลม" | mkAdv "ไปทางใต้ลม" ; -- src=panlex
lin ale_house_N = mkN "ร้านเหล้าเอล" ; -- src=panlex
lin alembic_N = mkN "หม้อกลั่นโบราณ" | mkN "ภาชนะแก้วหรือโลหะที่ใช้ในการกลั่น" ; -- src=panlex
lin alendronate_N = mkN "ยาฟอซาแมกซ์" | mkN "อะเลนโดรเนต" | mkN "ยาอะเลนโดรเนต" ; -- src=panlex
lin aleph_N = mkN "อักษรอาเลฟ" | mkN "ชื่อของอักษรตัวแรกในภาษาฮิบรู" ; -- src=panlex
lin alert_A = mkA "ว่องไว" | mkA "ไหวตัว" | mkA "ตั้งท่า" | mkA "ตื่นตัว" | mkA "ระมัดระวัง" | mkA "เตรียมพร้อม" ; -- src=panlex
lin alert_N = mkN "การพร้อมรับมือ" | mkN "สัญญาณเตือนภัย" | mkN "ว่องไว" | mkN "การเตือนภัย" | mkN "ช่วงเวลาที่มีอันตราย" ; -- src=panlex
lin alertness_N = mkN "การระวังระไว" | mkN "การเฝ้าระวัง" | mkN "ความระวัง" | mkN "ความตื่นตัว" | mkN "การเตรียมพร้อม" | mkN "ความระมัดระวัง" ; -- src=panlex
lin aleurone_N = mkN "แอลิวโรน" ; -- src=panlex
lin aleuronic_A = mkA "อะเลวโรน" ; -- src=panlex
lin alewife_N = mkN "ปลาเอลไวฟ์" | mkN "เนื้อปลาเอลไวฟ์" ; -- src=panlex
lin alexandrine_N = mkN "โคลงกลอนที่มี 6 พยางค์" ; -- src=panlex
lin alexandrite_N = mkN "อเล็กซานไดรต์" | mkN "แร่อเล็กซานไดรต์" ; -- src=panlex
lin alexia_N = mkN "การสูญเสียความสามารถในการอ่าน" ; -- src=panlex
lin alexic_A = mkA "อะเลกเซีย" ; -- src=panlex
lin alexic_N = mkN "ผู้มีภาวะเสียการอ่าน" ; -- src=panlex
lin alfalfa_N = mkN "อัลฟัลฟา" | mkN "พืชประเภทมีฝักในยุโรปใช้เลี้ยงสัตว์" | mkN "พืชตระกูลถั่วประเภทมีฝักในยุโรปใช้เลี้ยงสัตว์" ; -- src=panlex
lin alfresco_A = mkA "กลางแจ้ง" ; -- src=panlex
lin alfresco_Adv = mkAdv "ข้างนอก" | mkAdv "กลางแจ้ง" | mkAdv "กลางแจ้ง" ; -- src=panlex
lin alga_N = mkN "สาหร่าย" | mkN "สาหร่าย" ; -- src=panlex
lin algal_A = mkA "ที่เกี่ยวกับสาหร่าย" ; -- src=panlex
lin algarroba_N = mkN "ต้นคารอบ" | mkN "ต้นอัลการ์โรบา" ; -- src=panlex
lin algebra_N = mkN "พีชคณิต" | mkN "พีชคณิต" | mkN "พืชคณิต" ; -- src=panlex
lin algebraic_A = mkA "เกี่ยวกับพีชคณิต" | mkA "เกี่ยวกับพีชคณิต" | mkA "เกี่ยวกับพืชคณิต" ; -- src=panlex
lin algebraical_A = mkA "เกี่ยวกับพีชคณิต" ; -- src=panlex
lin algebraist_N = mkN "นักคณิตศาสตร์พีชคณิต" ; -- src=panlex
lin algid_A = mkA "หนาว" ; -- src=panlex
lin algin_N = mkN "กรดอัลจินิก" ; -- src=panlex
lin algoid_A = mkA "เหมือนสาหร่าย" ; -- src=panlex
lin algolagnia_N = mkN "อัลกอฟิเลีย" ; -- src=panlex
lin algolagnic_A = mkA "อัลโกเลกเนีย" ; -- src=panlex
lin algometric_A = mkA "อัลโกเมทรี" ; -- src=panlex
lin algophobia_N = mkN "อาการกลัวเจ็บ" | mkN "โรคกลัวความเจ็บปวด" ; -- src=panlex
lin algophobic_A = mkA "ซึ่งกลัวเจ็บ" ; -- src=panlex
lin algorism_N = mkN "ระบบเครื่องหมายทางคณิตศาสตร์ของอาหรับ" ; -- src=panlex
lin algorithm_N = mkN "อัลกอริทึม" | mkN "คําสั่ง" | mkN "อัลกอริธึม" | mkN "ขั้นตอนวิธี" | mkN "ชุดของคําสั่งที่สร้างไว้ตามขั้นตอน" | mkN "ลําดับขั้นตอนที่แน่นอนซึ่งใช้ในการแก้ปัญหา" ; -- src=panlex
lin algorithmic_A = mkA "อัลกอรีธึม" ; -- src=panlex
lin alias_Adv = mkAdv "มีนามแฝงว่า" | mkAdv "โดยมีนามแฝงว่า" | mkAdv "เป็นที่รู้จักในชื่อ" | mkAdv "มีนามแฝงว่า" | mkAdv "ใช้อีกชื่อหนึ่งว่า" | mkAdv "อีกนัยหนึ่งเรียกว่า" ; -- src=panlex
lin alias_N = mkN "ชื่อสมมุติ" | mkN "ฉายา" | mkN "สมญานาม" ; -- src=panlex
lin alibi_N = mkN "ข้อแก้ตัว" | mkN "การหาข้อแก้ตัว" | mkN "คํากล่าวอ้างที่ผู้ถูกกล่าวหาอ้างว่าได้อยู่ที่อื่นขณะเกิดเหตุ" ; -- src=panlex
lin alidade_N = mkN "เครื่องเล็ง" | mkN "เครื่องเล็กง" ; -- src=panlex
lin alienFem_N = variants {} ; ---- sense to be split
lin alienMasc_N = variants {} ; ---- sense to be split
lin alien_A = mkA "แปลก" | mkA "ต่างแดน" | mkA "จากต่างแดน" | mkA "ต่างประเทศ" | mkA "จากต่างประเทศ" | mkA "แปลก" | mkA "ต่างด้าว" | mkA "คนต่างด้าว" | mkA "คนแปลกหน้า" | mkA "ต่างประเทศ" | mkA "ไม่เข้ากัน" | mkA "ความแตกต่างกับตน" | mkA "แตกต่างกับตัวเอง" | mkA "ที่เป็นคนต่างชาติ" | mkA "ไม่เป็นโดยธรรมชาติ" ; -- src=panlex
lin alienable_A = mkA "ซึ่งขายได้" ; -- src=panlex
lin alienage_N = mkN "ความแปลกหน้า" | mkN "ภาวะที่แตกต่างกับตน" | mkN "ภาวะที่เป็นคําต่างด้าว" ; -- src=panlex
lin alienation_N = mkN "ความแตกแยก" | mkN "ความแปลกแยก" | mkN "การโอนทรัพย์สิน" | mkN "การโอน" | mkN "ความหมางเมิน" | mkN "ความห่างเหิน" | mkN "สภาวะผิดปกติ" | mkN "สภาวะวิกลจริต" | mkN "การทําให้บาดหมาง" | mkN "การทําให้เหินห่าง" ; -- src=panlex
lin alienee_N = mkN "ผู้รับโอนกรรมสิทธิ์" ; -- src=panlex
lin alienor_N = mkN "ผู้โอนกรรมสิทธิ์" ; -- src=panlex
lin alight_A = mkA "โชติช่วง" | mkA "เต็มไปด้วยพลัง" | mkA "ซึ่งกําลังลุกโชนอยู่" ; -- src=panlex
lin alight_V = mkV "ร่อนลง" | mkV "เข้ามาเกาะ" | mkV "ลงจอด" | mkV "บินถลาลง" | mkV "ลงจากพาหนะ" | mkV "พบโดยบังเอิญ" | mkV "เห็นโดยบังเอิญ" ; -- src=panlex
lin align_V = mkV "ปรับ" | mkV "ประสาน" | mkV "จัดเป็นแนว" | mkV "จัดอาร์เรย์" | mkV "จัดเป็นกลุ่มความคิด" | mkV "ประกาศสนับสนุน" | mkV "อยู่ในแนวเดียวกัน" | mkV "จัดให้เป็นแนวเดียวกัน" | mkV "จัดให้อยู่ในแนวเดียวกัน" | mkV "จัดให้อยู่ในตําแหน่งที่ถูกต้อง" ; -- src=panlex
lin align_V2 = mkV2 "ปรับ" ; ---- | mkV "ประสาน" | mkV "จัดเป็นแนว" | mkV "จัดอาร์เรย์" | mkV "จัดเป็นกลุ่มความคิด" | mkV "ประกาศสนับสนุน" | mkV "อยู่ในแนวเดียวกัน" | mkV "จัดให้เป็นแนวเดียวกัน" | mkV "จัดให้อยู่ในแนวเดียวกัน" | mkV "จัดให้อยู่ในตําแหน่งที่ถูกต้อง" ; -- src=panlex
lin alignment_N = mkN "สหพันธ์" | mkN "การวางแนว" | mkN "แนวร่วม" | mkN "การวางแนว" | mkN "การจัดเรียง" | mkN "ผู้สนับสนุน" | mkN "การจัดให้เป็นแถวตรง" | mkN "การจัดให้ถูกตําแหน่ง" ; -- src=panlex
lin alike_A = mkA "คล้ายกัน" | mkA "เหมือนกัน" | mkA "คล้ายคลึงกัน" | mkA "คล้ายกัน" | mkA "เหมือนกัน" | mkA "เหมือนกับ" | mkA "คล้ายคลึงกัน" | mkA "อาการเดียวกัน" | mkA "ไม่แตกต่างกัน" | mkA "ลักษณะเดียวกัน" ; -- src=panlex
lin alike_Adv = mkAdv "เหมือนกัน" | mkAdv "คล้ายกัน" | mkAdv "เหมือนกัน" | mkAdv "เหมือนกับ" | mkAdv "แบบเดียวกัน" | mkAdv "เช่นเดียวกัน" | mkAdv "อย่างเดียวกัน" | mkAdv "อาการเดียวกัน" | mkAdv "ลักษณะเดียวกัน" ; -- src=panlex
lin alimentary_A = mkA "ซึ่งค้ําชู" | mkA "ซึ่งบํารุง" | mkA "เกี่ยวกับอาหาร" | mkA "เกี่ยวกับโภชนาการ" | mkA "เกี่ยวกับการเลี้ยงดู" | mkA "เกี่ยวกับการบํารุงเลี้ยง" ; -- src=panlex
lin alimentative_A = mkA "ที่เป็นแหล่งอาหาร" ; -- src=panlex
lin alimony_N = mkN "ค่าเลี้ยงดู" | mkN "ค่าเลี้ยงดู" | mkN "ค่าเลี้ยงดูภรรยาที่หย่าร้างกับสามี" | mkN "ค่าเลี้ยงดูที่ศาลสั่งให้จ่ายให้กับคู่ครองหลังการหย่า" ; -- src=panlex
lin aliquot_A = mkA "เป็นตัวหารได้พอดี" ; -- src=panlex
lin aliquot_N = mkN "ส่วนลงตัว" | mkN "ส่วนที่หารลงตัว" ; -- src=panlex
lin aliterate_N = mkN "คนไม่ชอบอ่าน" | mkN "ผู้ไม่ชอบอ่าน" | mkN "คนไม่ชอบอ่านหนังสือ" | mkN "ผู้ไม่ชอบอ่านหนังสือ" ; -- src=panlex
lin alive_A = mkA "มีพลัง" | mkA "คุกรุ่น" | mkA "มีชีวิตชีวา" | mkA "อยู่" | mkA "คงอยู่" | mkA "ยังอยู่" | mkA "ร่าเริง" | mkA "สนใจต่อ" | mkA "ระวังตัว" | mkA "ครึกครื้น" | mkA "ยังคงอยู่" | mkA "ตระหนักถึง" | mkA "เต็มไปด้วย" | mkA "มีชีวิตชีวา" | mkA "มีชีวิตอยู่" | mkA "กระปรี้กระเปร่า" | mkA "เต็มไปด้วยชีวิต" ; -- src=panlex
lin alizarin_N = mkN "อะริซาริน" ; -- src=panlex
lin alkalemia_N = mkN "ภาวะเลือดเป็นด่าง" | mkN "สภาวะความเป็นด่างในเลือดสูง" ; -- src=panlex
lin alkalescent_A = mkA "ซึ่งกลายเป็นอัลคาไลน์" ; -- src=panlex
lin alkali_N = mkN "อัลคาไล" | mkN "แอลคาไล" | mkN "ด่าง" | mkN "สารชนิดหนึ่งมีฤทธิ์เป็นด่าง" ; -- src=panlex
lin alkaline_A = mkA "ด่าง" | mkA "เป็นแอลคาไล" | mkA "ซึ่งประ-กอบด้วยหรือมีลักษณะเป็นด่าง" | mkA "เป็นด่าง" ; -- src=panlex
lin alkalinity_N = mkN "ความเป็นด่าง" | mkN "ภาวะที่เป็นด่าง" ; -- src=panlex
lin alkaloidal_A = mkA "เกี่ยวกับอัลคาลอยด์" ; -- src=panlex
lin alkalosis_N = mkN "แอลคาโลซิส" ; -- src=panlex
lin alkalotic_A = mkA "ที่กำหนดด้วยอัลคาลอยด์" ; -- src=panlex
lin alkapton_N = mkN "อัลแคปตอน" | mkN "กรดโฮโมเจนติซิก" | mkN "โฮโมเจนติซิกแอซิด" ; -- src=panlex
lin alkaptonuria_N = mkN "โรคแอลแคปโตนููเรีย" ; -- src=panlex
lin alkene_N = mkN "อัลคีน" ; -- src=panlex
lin alkyd_N = mkN "อัลคิดเรซิน" ; -- src=panlex
lin alkyl_N = mkN "หมู่อัลคิล" ; -- src=panlex
lin alkylbenzene_N = mkN "อัลคิลเบนซีน" ; -- src=panlex
lin alkylbenzenesulfonate_N = mkN "อัลคิลเบนซีนซัลโฟเนต" ; -- src=panlex
lin alkylic_A = mkA "เกี่ยวกับอัลคีล์" ; -- src=panlex
lin all_A = mkA "ทั้ง" | mkA "ทั้งหมด" | mkA "ทุก" | mkA "แท้" | mkA "ใดๆ" | mkA "ตลอด" | mkA "ทุกๆ" | mkA "ล้วน" | mkA "สรรพ" | mkA "สูงสุด" | mkA "ทั่วทุก" | mkA "ทั้งปวง" | mkA "ทั้งผอง" | mkA "ทั้งมวล" | mkA "ทั้งหมด" | mkA "ล้วนแต่" | mkA "จวนเจียน" | mkA "ทั้งสิ้น" | mkA "ทั้งหลาย" | mkA "อย่างยิ่ง" | mkA "ล้วนแล้วแต่" | mkA "จํานวนทั้งหมด" | mkA "เท่าที่มีทั้งหมด" ; -- src=panlex
lin all_Predet = {s1 = thword "ทั้ง" "หมด" ; s2 = []} ;
lin allantoic_A = mkA "อัลแลนทอยส์" ; -- src=panlex
lin allantoid_A = mkA "ซึ่งเป็นรูปไส้กรอก" ; -- src=panlex
lin allantois_N = mkN "แอลแลนทอยส์" ; -- src=panlex
lin allegation_N = mkN "ข้อหา" | mkN "มลทิน" | mkN "ข้อกล่าวหา" | mkN "ข้อหา" | mkN "กล่าวหา" | mkN "การอ้าง" | mkN "ข้ออ้าง" | mkN "การยืนยัน" | mkN "ข้อยืนยัน" | mkN "การกล่าวหา" | mkN "ข้อกล่าวหา" ; -- src=panlex
lin alleged_A = mkA "น่าสงสัย" | mkA "ซึ่งยืนยัน" | mkA "ซึ่งกล่าวหา" | mkA "ซึ่งถูกกล่าวหา" ; -- src=panlex
lin allegiance_N = mkN "ความซื่อสัตย์" | mkN "การอุทิศต่อ" | mkN "ความจงรักภักดี" | mkN "ความสามิภักดิ์" | mkN "ความสวามิภักดิ์" ; -- src=panlex
lin allegory_N = mkN "ตรา" | mkN "สัญลักษณ์" | mkN "นิทานคำสอน" | mkN "เครื่องหมาย" | mkN "ตราสัญลักษณ์" | mkN "นิทานสอนศีลธรรม" | mkN "เครื่องหมายสัญลักษณ์" | mkN "การสมมุติ" | mkN "การแฝงคติ" | mkN "เครื่องหมาย" | mkN "การเปรียบเทียบ" | mkN "นิทานเปรียบเทียบ" | mkN "การสมมติเปรียบเทียบ" | mkN "เครื่องหมายสัญลักษณ์" ; -- src=panlex
lin allegretto_A = mkA "ค่อนข้างเร็ว" | mkA "อัลเลเกร็ตโต" | mkA "ซึ่งมีจังหวะเบาและค่อนข้างเร็ว" ; -- src=panlex
lin allegretto_N = mkN "ดนตรีซึ่งมีจังหวะค่อนข้างเร็ว" | mkN "ซึ่งมีจังหวะเบาและค่อนข้างเร็ว" ; -- src=panlex
lin allegro_A = mkA "เร็ว" | mkA "อัลเลโกร" ; -- src=panlex
lin allele_N = mkN "แอลลีล" | mkN "รูปแบบของยีน" ; -- src=panlex
lin allemande_N = mkN "ซอสอัลเลอแมนด์" ; -- src=panlex
lin allergen_N = mkN "สารก่อโรคภูมิแพ้" | mkN "สารที่ทําให้เกิดโรคภูมิแพ้ได้" ; -- src=panlex
lin allergic_A = mkA "แพ้" | mkA "ไม่พอใจ" | mkA "เป็นโรคภูมิแพ้" | mkA "ที่เป็นโรคภูมิแพ้" | mkA "ที่ทําให้เกิดอาการแพ้" ; -- src=panlex
lin allergist_N = mkN "หมอโรคภูมิแพ้" | mkN "แพทย์ผู้ชํานาญด้านภูมิแพ้" | mkN "แพทย์ผู้เชี่ยวชาญด้านโรคภูมิแพ้" ; -- src=panlex
lin allergology_N = mkN "วิทยาโรคภูมิแพ้" ; -- src=panlex
lin allergy_N = mkN "อาการแพ้" | mkN "ความเกลียด" | mkN "ความไม่ชอบ" | mkN "โรคภูมิแพ้" | mkN "ความไม่พอใจ" ; -- src=panlex
lin alleviation_N = mkN "การบรรเทา" | mkN "การบรรเทา" | mkN "การทําให้น้อยลง" | mkN "สิ่งที่บรรเทาหรือทําให้น้อยลง" ; -- src=panlex
lin alleviative_A = mkA "ซึ่งบรรเทา" | mkA "ซึ่งทําให้ลดน้อยลง" ; -- src=panlex
lin alley_N = mkN "ตรอก" | mkN "รางโบลิ่ง" | mkN "ซอย" | mkN "ตรอก" | mkN "ซอกซอย" | mkN "ทางวิ่งที่แคบ" | mkN "ทางเดินที่แคบ" | mkN "ทางเดินที่แคบๆ" ; -- src=panlex
lin alleyway_N = mkN "ตรอก" | mkN "ซอย" | mkN "ตรอก" | mkN "ซอกซอย" | mkN "ทางที่แคบ" | mkN "ทางเดินที่แคบ" ; -- src=panlex
lin alliance_N = mkN "สหพันธ์" | mkN "สมาพันธ์" | mkN "การเกี่ยวดอง" | mkN "สมาชิก" | mkN "องค์กร" | mkN "สหพันธ์" | mkN "แนวร่วม" | mkN "พันธมิตร" | mkN "สมาพันธ์" | mkN "สันนิบาต" | mkN "การแต่งงาน" | mkN "ผู้สนับสนุน" | mkN "ความสัมพันธ์ใกล้ชิด" | mkN "ข้อตกลงระหว่างประเทศ" | mkN "ความสัมพันธ์ที่เกิดจากการแต่งงาน" ; -- src=panlex
lin allied_A = mkA "มาจากที่เดียวกัน" | mkA "ซึ่งมีลักษณะคล้ายกัน" | mkA "ซึ่งมีความสัมพันธ์กัน" | mkA "มีแหล่งกําเนิดเดียวกัน" | mkA "เป็นพันธมิตรกันโดยสนธิสัญญา" | mkA "ซึ่งมีลักษณะที่เกี่ยวข้องกัน" | mkA "ซึ่งเป็นพันธมิตรกันโดยสนธิสัญญา" ; -- src=panlex
lin allies_N = mkN "สมาชิกสนธิสัญญานาโต้" ; -- src=panlex
lin alligator_N = mkN "หนังจระเข้" | mkN "เข้" | mkN "จระเข้" | mkN "รถสะเทินน้ําสะเทินบก" | mkN "หนังของสัตว์ชนิดหนึ่ง" | mkN "สัตว์ชนิดหนึ่งตระกูลเดียวกับจระเข้แต่มีขนาดใหญ่กว่า" ; -- src=panlex
lin alligatorfish_N = mkN "ปลาอัลลิกาเตอร์ฟิช" ; -- src=panlex
lin alliteration_N = mkN "การสัมผัสอักษร" | mkN "วิธีสัมผัสอักษรพยางค์" ; -- src=panlex
lin allocate_V = mkV "จัดสรร" | mkV "จัดสรร" | mkV "จัดแบ่ง" | mkV "แบ่งสันปันส่วน" ; -- src=panlex
lin allocate_V2 = mkV2 "จัดสรร" ; ---- | mkV "จัดสรร" | mkV "จัดแบ่ง" | mkV "แบ่งสันปันส่วน" ; -- src=panlex
lin allocation_N = mkN "การแบ่งส่วน" | mkN "การบรรจุ" | mkN "ส่วนแบ่ง" | mkN "การจัดสรร" | mkN "การลงบัญชี" | mkN "การแบ่งสรร" | mkN "การแบ่งส่วน" | mkN "การจัดสรรปันส่วน" | mkN "ภาวะที่ถูกจัดสรรหรือแบ่งสรร" ; -- src=panlex
lin allochthonous_A = mkA "มาจากแหล่งอื่น" | mkA "เกิดจากบริเวณอื่น" | mkA "ซึ่งถูกนํามาจากแหล่งอื่น" ; -- src=panlex
lin allocution_N = mkN "การแสดงสุนทรพจน์" ; -- src=panlex
lin allograph_N = mkN "อักษรย่อย" ; -- src=panlex
lin allometry_N = mkN "แอลโลเมตรี" | mkN "การวัดหรือสึกษาการเจริญเติบโตแบบนี้" ; -- src=panlex
lin allomorph_N = mkN "หน่วยคำย่อย" | mkN "อัญรูปหน่วยคำ" | mkN "รูปย่อยหน่วยคำ" ; -- src=panlex
lin allopathy_N = mkN "อัลโลพาธี" | mkN "การรักษาโรคด้วยสารที่ออกฤทธิ์ตรงข้าม" ; -- src=panlex
lin allophone_N = mkN "หน่วยเสียงย่อย" | mkN "อัญรูปหน่วยเสียง" | mkN "รูปย่อยหน่วยเสียง" ; -- src=panlex
lin allopurinol_N = mkN "ยาไซโลพริม" | mkN "ยาอัลโลพูรินอล" ; -- src=panlex
lin allosaur_N = mkN "อัลโลซอรัส" ; -- src=panlex
lin allotment_N = mkN "การแบ่งส่วน" | mkN "การจัดสรร" | mkN "การจัดแบ่ง" | mkN "ส่วนที่จัดแบ่ง" | mkN "ส่วนแบ่งที่ได้รับ" | mkN "ที่ดินที่ให้คนสวนเช่า" ; -- src=panlex
lin allotrope_N = mkN "อัญรูป" | mkN "รูปแบบที่ต่างกันของธาตุหนึ่ง ๆ" ; -- src=panlex
lin allotropy_N = mkN "การมีอัญรูป" | mkN "คุณสมบัติทางเคมีของธาตุบางชนิดที่มีหลายรูปแบบ" ; -- src=panlex
lin allover_A = mkA "ทั่วไปหมด" | mkA "เต็มไปหมด" | mkA "เต็มผิวหน้า" ; -- src=panlex
lin allow_for_V2 = prepV2 (lin V OP_allow_V2) OP_for_Prep ; -- guess-p-verb
lin allow_of_V2 = prepV2 (lin V OP_allow_V2) OP_of_Prep ; -- guess-p-verb
lin allowable_A = mkA "ซึ่งยอมได้" | mkA "ที่อนุญาตได้" ; -- src=panlex
lin allowance_N = mkN "ค่าต่าง" | mkN "การยินยอม" | mkN "ค่าเบี้ยเลี้ยง" | mkN "จัดสรร" | mkN "จัดให้" | mkN "ส่วนลด" | mkN "การอดทน" | mkN "การยอมทน" | mkN "งบประมาณ" | mkN "การยอมรับ" | mkN "การยินยอม" | mkN "ส่วนเสริม" | mkN "การพิจารณา" | mkN "ค่าใช้จ่าย" | mkN "เบี้ยเลี้ยง" | mkN "การอนุญาตให้" | mkN "ค่าเลี้ยงชีพ" | mkN "เงินส่วนแบ่ง" | mkN "เงินช่วยเหลือ" | mkN "เงินค่าใช้จ่าย" | mkN "สิ่งที่ได้รับส่วนแบ่ง" | mkN "ความคลาดเคลื่อนที่ยอมให้เกิดขึ้นได้" ; -- src=panlex
lin alloy_N = mkN "อัลลอย" | mkN "โลหะผสม" | mkN "ของผสม" | mkN "เจือปน" | mkN "ส่วนผสม" | mkN "โลหะผสม" | mkN "สิ่งเจือปน" ; -- src=panlex
lin allspice_N = mkN "ออลสไปซ์" | mkN "ต้นออลสไปซ์" ; -- src=panlex
lin allude_V = mkV "พาดพิง" | mkV "หมายถึง" | mkV "พูดเป็นนัย" ; -- src=panlex
lin allure_N = mkN "การจูงใจ" | mkN "ความยั่วยวน" ; -- src=panlex
lin allurement_N = mkN "เสน่ห์" | mkN "การจูงใจ" | mkN "ความยั่วยวน" | mkN "เครื่องล่อใจ" | mkN "อํานาจดึงดูดใจ" | mkN "สิ่งหรือวิธีหรือกระบวนการดึงดูดใจ" ; -- src=panlex
lin alluring_A = mkA "ซึ่งล่อใจ" | mkA "ที่ดึงดูดใจ" | mkA "ซึ่งดึงดูดใจ" ; -- src=panlex
lin allusion_N = mkN "คําอุปมา" | mkN "การหมายถึง" | mkN "การพาดพิงถึง" ; -- src=panlex
lin allusive_A = mkA "ซึ่งอ้างอิง" | mkA "อุปมาอุปไมย" | mkA "ซึ่งพูดเป็นนัย" | mkA "ซึ่งพาดพิงถึงบางอย่าง" ; -- src=panlex
lin alluvial_A = mkA "เกี่ยวกับชั้นของดินโคลนที่น้ําพัดพามา" ; -- src=panlex
lin alluvion_N = mkN "น้ำท่วม" | mkN "อุทกภัย" | mkN "ตะกอนน้ำพา" | mkN "ภัยน้ำท่วม" | mkN "การงอกของแผ่นดิน" | mkN "น้ําท่วม" | mkN "ผืนดินที่เกิดจากสิ่งที่น้ําพัดพามาทับถม" ; -- src=panlex
lin ally_N = mkN "พันธมิตร" | mkN "ชาติพันธมิตร" | mkN "ประเทศพันธมิตร" | mkN "สมาชิกในกลุ่ม" | mkN "อวัยวะที่เชื่อมกัน" | mkN "อวัยวะที่สัมพันธ์กัน" | mkN "คนหรือประเทศที่อยู่ในกลุ่มเดียวกัน" ; -- src=panlex
lin allyl_N = mkN "หมู่อัลลิล" ; -- src=panlex
lin almanac_N = mkN "ปฏิทินร้อยปี" | mkN "สมุดปฏิทินโหร" | mkN "ปฎิทินประจําปี" | mkN "ปฏิทินโหราศาสตร์" | mkN "ปฏิทินดาราศาสตร์ประจําปี" | mkN "หนังสือที่บันทึกข้อมูลสถิติ" ; -- src=panlex
lin almandine_N = mkN "อัลแมนดีน" | mkN "แอลมันไดต์" | mkN "แอลมันไดน์" ; -- src=panlex
lin almandite_N = mkN "แอลมันไดต์" | mkN "แอลมันไดน์" ; -- src=panlex
lin almighty_A = mkA "ที่มีอำนาจไม่จำกัด" | mkA "รุนแรง" | mkA "สุดขีด" | mkA "น่ากลัว" | mkA "อย่างมาก" | mkA "อย่างที่สุด" | mkA "ซึ่งมีอํานาจทุกอย่าง" | mkA "ซึ่งมีอํานาจไม่จํากัด" | mkA "ซึ่งมีความสามารถทุกอย่าง" | mkA "ซึ่งมีอํานาจหรืออิทธิพลมาก" ; -- src=panlex
lin almond_N = mkN "อัลมอนด์" | mkN "ต้นอัลมอนด์" | mkN "เมล็ดอัลมอนด์" | mkN "อัลมอนด์" | mkN "เมล็ดอามันด์" | mkN "สีน้ําตาลอ่อน" | mkN "เมล็ดอัลมอนด์" | mkN "สีของเปลือกอัลมอนต์" | mkN "เมล็ดพืชคล้ายถั่วลิสง" | mkN "เมล็ดพืชชนิดหนึ่งคล้ายเมล็ดถั่ว กินได้" ; -- src=panlex
lin almoner_N = mkN "นักสังคมสงเคราะห์" | mkN "เจ้าหน้าที่แจกของสงเคราะห์" | mkN "นักสังคมสงเคราะห์ในโรงพยาบาล" ; -- src=panlex
lin almost_AdA = ss (thword "เกิ" "อบ") ;
lin almost_AdN = ss (thword "เกิ" "อบ") ;
lin almost_Adv = mkAdv "เกือบ" | mkAdv "จวนเจียน" | mkAdv "จวน" | mkAdv "จวนจะ" | mkAdv "เกือบ" | mkAdv "แทบจะ" | mkAdv "เกือบจะ" | mkAdv "จวนเจียน" | mkAdv "เกือบถึง" ; -- src=panlex
lin alms_N = mkN "ทาน" | mkN "ของบริจาค" | mkN "ของให้ทาน" | mkN "เงินบริจาค" ; -- src=panlex
lin almsgiver_N = mkN "คนให้ของบริจาค" | mkN "ผู้ให้ของบริจาค" | mkN "ผู้ให้ทาน" | mkN "เจ้าของทาน" ; -- src=panlex
lin aloe_N = mkN "ว่านหางจระเข้" | mkN "หางจระเข้" | mkN "ว่านหางจระเข้" ; -- src=panlex
lin aloft_Adv = mkAdv "บนสวรรค์" | mkAdv "เบื้องบน" | mkAdv "สูงขั้นไป" | mkAdv "สูงขึ้นไป" | mkAdv "ขึ้นไปในอากาศ" | mkAdv "บนเสากระโดงเรือ" ; -- src=panlex
lin aloha_N = mkN "ชาว" | mkN "อะโลฮา" | mkN "การอําลา" | mkN "การต้อนรับ" ; -- src=panlex
lin alone_A = mkA "เพียง" | mkA "ดาย" | mkA "ลําพัง" | mkA "คนเดียว" | mkA "เดียวดาย" | mkA "ตามลําพัง" | mkA "แต่ลําพัง" | mkA "โดดเดี่ยว" | mkA "โดยลําพัง" | mkA "ลําพังตนเอง" | mkA "เพียงลําพัง" | mkA "เปล่าเปลี่ยว" ; -- src=panlex
lin aloneness_N = mkN "ความสันโดษ" | mkN "ความโดดเดี่ยว" ; -- src=panlex
lin along_Adv = mkAdv "ไป" | mkAdv "ไปยัง" | mkAdv "กับ" | mkAdv "ด้วย" | mkAdv "ต่อไป" | mkAdv "มากับ" | mkAdv "ไปยัง" | mkAdv "ไปข้างหน้า" ; -- src=panlex
lin along_Prep = mkPrep "ตาม" | mkPrep "สาย" | mkPrep "ด้วยกัน" | mkPrep "ระหว่าง" | mkPrep "ไปข้างๆ" | mkPrep "คล้ายกับ" | mkPrep "ร่วมด้วย" | mkPrep "ขนานไปกับ" | mkPrep "คู่กันกับ" ; -- src=panlex
lin alongside_Adv = mkAdv "อยู่ข้าง" | mkAdv "เคียง" | mkAdv "อยู่ข้าง" | mkAdv "เทียบท่า" | mkAdv "อยู่ติดกับ" ; -- src=panlex
lin alongside_Prep = mkPrep "ข้างๆ" | mkPrep "เคียง" | mkPrep "อยู่ข้าง" | mkPrep "เทียบท่า" | mkPrep "อยู่ถัดไป" | mkPrep "อยู่ติดกับ" ; -- src=panlex
lin aloof_A = mkA "ห่าง" | mkA "เย็นชา" | mkA "ต่างหาก" | mkA "ออกห่าง" | mkA "ห่างเหิน" | mkA "โดดเดี่ยว" | mkA "ที่อยู่ไกล" ; -- src=panlex
lin aloof_Adv = mkAdv "ห่าง" | mkAdv "เย็นชา" | mkAdv "ต่างหาก" | mkAdv "ห่างไกล" | mkAdv "ออกห่าง" | mkAdv "ห่างเหิน" | mkAdv "โดดเดี่ยว" ; -- src=panlex
lin aloofness_N = mkN "ความห่างเหิน" ; -- src=panlex
lin alopecia_N = mkN "หัวล้าน" | mkN "โรคหัวล้าน" ; -- src=panlex
lin aloud_Adv = mkAdv "ดัง" | mkAdv "อย่างดัง" | mkAdv "อย่างได้ยินชัด" ; -- src=panlex
lin alp_N = mkN "ไหล่เขาสูง" ; -- src=panlex
lin alpaca_N = mkN "อัลปาคา" | mkN "ขนอัลปาคา" | mkN "ผ้าขนอัลปาคา" | mkN "สิ่งทอที่ทําด้วยขนสัตว์ดังกล่าว" ; -- src=panlex
lin alpenstock_N = mkN "ไม้ที่มีปลายเป็นเหล็กใช้ในการปีนเขา" | mkN "ไม้ที่มีปลายเป็นเหล็กใช้ในการปีนเขา" ; -- src=panlex
lin alpestrine_A = mkA "ซึ่งเกี่ยวกับบริเวณเชิงเทือกเขาแอลป์" | mkA "ซึ่งเกี่ยวกับบริเวณเชิงเทือกเขาแอลพ์" ; -- src=panlex
lin alpha_N = mkN "อัลฟา" | mkN "จุดเริ่มต้น" | mkN "สิ่งแรก" | mkN "จุดเริ่ม" | mkN "พยัญชนะตัวแรกของภาษากรีก" | mkN "ดาวที่สว่างที่สุดในกลุ่มดาว" ; -- src=panlex
lin alphabet_N = mkN "อักษร" | mkN "มูลฐาน" | mkN "ตัวอักษร" | mkN "อักษร" | mkN "อักขระ" | mkN "ตัวอักษร" | mkN "ขั้นมูลฐาน" | mkN "ตัวหนังสือ" | mkN "ระบบตัวอักษร" | mkN "อักษรพยัญชนะ" | mkN "ความรู้พื้นฐาน" | mkN "สัญลักษณ์ในการสื่อสาร" ; -- src=panlex
lin alphabetic_A = mkA "ที่เรียงตามลําดับอักษร" ; -- src=panlex
lin alphabetical_A = mkA "เรียงตามอักษร" | mkA "เรียงตามอักขรานุกรม" | mkA "ที่เรียงตามลําดับอักษร" | mkA "เกี่ยวกับอักษรหรืออักขระ" ; -- src=panlex
lin alphabetizer_N = mkN "คนจัดเรียงตามลำดับพยัญชนะ" | mkN "ผู้จัดเรียงตามลำดับพยัญชนะ" ; -- src=panlex
lin alphavirus_N = mkN "ไวรัสอัลฟา" ; -- src=panlex
lin alpine_A = mkA "สูงมาก" | mkA "ซึ่งยกขึ้นสูง" | mkA "เกี่ยวกับเทือกเขาแอลพ์" | mkA "ซึ่งเจริญเติบโตบนภูเขาสูง" | mkA "ซึ่งเกี่ยวกับเทือกเขาแอลป์" | mkA "มีลักษณะคล้ายเทือกเขาแอลพ์" | mkA "ซึ่งเกี่ยวกับเทือกเขาที่สูง" ; -- src=panlex
lin alpinist_N = mkN "นักปีนเขา" ; -- src=panlex
lin already_Adv = mkAdv (thword "เรียบ" "ร้อย") | {-pan-} mkAdv "แล้ว" | mkAdv "แล้ว" | mkAdv "เรียบร้อย" | mkAdv "เรียบร้อยแล้ว" | mkAdv "ที่เกิดแล้วก่อนหน้านี้" ; -- src=panlex
lin alright_Adv = mkAdv "ตกลง" | mkAdv "โอเค" | mkAdv "แน่นอน" | mkAdv "อย่างน่าพอใจ" | mkAdv "ดีแล้ว" | mkAdv "น่าพอใจ" ; -- src=panlex
lin alsatianFem_N = variants {} ; ---- sense to be split
lin alsatianMasc_N = variants {} ; ---- sense to be split
lin also_Adv = mkAdv "เช่นกัน" | mkAdv "ด้วย" | mkAdv "อีกด้วย" | mkAdv "เช่นกัน" | mkAdv "โดยเฉพาะ" | mkAdv "เหมือนกัน" | mkAdv "ยิ่งกว่านั้น" | mkAdv "เช่นเดียวกัน" | mkAdv "ยิ่งไปกว่านั้น" ; -- src=panlex
lin alstroemeria_N = mkN "พืชสกุลอัลสเตรียมีเรีย" ; -- src=panlex
lin altar_N = mkN "แท่น" | mkN "ที่บูชา" | mkN "แท่นบูชา" | mkN "โต๊ะหมู่บูชา" ; -- src=panlex
lin altar_piece_N = mkN "ฉากหลังแท่นบูชาในโบสถ์ชาวคริสต์" ; -- src=panlex
lin altazimuth_N = mkN "เครื่องมือวัดเส้นแวงพื้นราบ" | mkN "เครื่องมือวัดเส้นแวงพื้นราบ" ; -- src=panlex
lin alter_V = mkV "แทรกคำ" | mkV "เปลี่ยน" | mkV "ตัดรังไข่" | mkV "เปลี่ยนแปลง" | mkV "ทำให้เปลี่ยน" | mkV "ทำให้เปลี่ยนแปลง" | mkV "ตอน" | mkV "แปลง" | mkV "ทําหมัน" | mkV "เปลี่ยน" | mkV "ปรับเปลี่ยน" | mkV "เย็บซ่อมเสื้อผ้าให้พอดี" ; -- src=panlex
lin alter_V2 = mkV2 "แทรกคำ" ; ---- | mkV "เปลี่ยน" | mkV "ตัดรังไข่" | mkV "เปลี่ยนแปลง" | mkV "ทำให้เปลี่ยน" | mkV "ทำให้เปลี่ยนแปลง" | mkV "ตอน" | mkV "แปลง" | mkV "ทําหมัน" | mkV "เปลี่ยน" | mkV "ปรับเปลี่ยน" | mkV "เย็บซ่อมเสื้อผ้าให้พอดี" ; -- src=panlex
lin alteration_N = mkN "การแก้ไข" | mkN "การดัดแปลง" | mkN "การเปลี่ยนแปลง" | mkN "การแก้ไข" | mkN "การดัดแปลง" | mkN "การปรับเปลี่ยน" | mkN "การเปลี่ยนแปลงแก้ไข" | mkN "ผลของการเปลี่ยนแปลง" ; -- src=panlex
lin altercation_N = mkN "การทะเลาะวิวาท" | mkN "การทุ่มเถียง" | mkN "การทะเลาะวิวาท" ; -- src=panlex
lin altered_A = mkA "ที่เปลี่ยนแปลง" ; -- src=panlex
lin alternate_A = mkA "สลับ" | mkA "ตัวแทน" | mkA "ผลัดกัน" | mkA "สลับกัน" | mkA "คนละครั้ง" | mkA "ซึ่งสลับกัน" | mkA "หมุนเวียนกัน" | mkA "หนึ่งเว้นหนึ่ง" | mkA "ที่เป็นตัวเลือก" ; -- src=panlex
lin alternate_V = mkV "กลับ" | mkV "สลับ" | mkV "แสดงแทน" | mkV "สับเปลี่ยน" | mkV "ผลัด" | mkV "สลับ" | mkV "ผันผวน" | mkV "สํารอง" | mkV "ผลัดกัน" | mkV "สลับกัน" | mkV "เปลี่ยนแปลง" | mkV "ทําให้สลับกัน" | mkV "เป็นตัวสํารอง" ; -- src=panlex
lin alternate_V2 = mkV2 "กลับ" ; ---- | mkV "สลับ" | mkV "แสดงแทน" | mkV "สับเปลี่ยน" | mkV "ผลัด" | mkV "สลับ" | mkV "ผันผวน" | mkV "สํารอง" | mkV "ผลัดกัน" | mkV "สลับกัน" | mkV "เปลี่ยนแปลง" | mkV "ทําให้สลับกัน" | mkV "เป็นตัวสํารอง" ; -- src=panlex
lin alternation_N = mkN "การสลับ" | mkN "ภาวะที่ถูกสลับ" | mkN "การผลัดเปลี่ยนกัน" | mkN "ครึ่งหนึ่งของวงจรสลับ" | mkN "การต่อเนื่องที่สลับกัน" ; -- src=panlex
lin alternative_A = mkA "รอง" | mkA "สํารอง" | mkA "หนึ่งเดียว" | mkA "อย่างเดียว" | mkA "แต่ผู้เดียว" | mkA "ที่มีตัวเลือก" | mkA "ซึ่งไม่ตามประเพณี" | mkA "ซึ่งไม่เป็นไปตามแผนเดิม" ; -- src=panlex
lin alternative_N = mkN "ชอยซ์" | mkN "ออปชั่น" | mkN "ตัวเลือก" | mkN "ทางเลือก" | mkN "ทางเลือก" | mkN "อีกทางหนึ่ง" | mkN "ของที่จะเลือก" | mkN "โอกาสในการเลือก" | mkN "วิธีการที่พอจะเลือกได้" ; -- src=panlex
lin alternator_N = mkN "เครื่องกำเนิดไฟฟ้ากระแสสลับ" | mkN "ตัวกําเนิดไฟฟ้าสลับ" ; -- src=panlex
lin although_Subj = ss "ถืง" ;
lin altimeter_N = mkN "เครื่องมือวัดความสูง" ; -- src=panlex
lin altissimo_A = mkA "อัลติสซิโม" ; -- src=panlex
lin altitude_N = mkN "มุมเงย" | mkN "มุมตั้ง" | mkN "อัลติจูด" | mkN "ระดับความสูง" | mkN "ระยะความสูงจากฟ้า" | mkN "ระดับความสูงเชิงมุม" | mkN "ที่สูง" | mkN "ความสูง" | mkN "ระยะทาง" | mkN "ชนชั้นสูง" | mkN "ระดับหรือตําแหน่ง" | mkN "ความสูงเหนือระดับน้ําทะเล" | mkN "ความสูงโดยเฉพาะเหนือพื้นดินหรือเหนือน้ําทะเล" ; -- src=panlex
lin alto_A = mkA "อัลโต" | mkA "เกี่ยวกับเสียงดนตรีที่มีเสียงสูงสุดเป็นลําดับที่สอง" ; -- src=panlex
lin alto_N = mkN "อัลโต" | mkN "เสียงอัลโต" | mkN "นักร้องเสียงอัลโต" | mkN "เสียงเคาเตอร์เทอเนอร์" | mkN "เสียงร้องเพลงระดับต่ําที่สุดของผู้หญิง" ; -- src=panlex
lin altocumulus_N = mkN "เมฆแอลโตคิวมูลัส" ; -- src=panlex
lin altogether_Adv = mkAdv "อย่างสมบูรณ์" | mkAdv "รวมทั้งหมดแล้ว" | mkAdv "ด้วยประการทั้งปวง" | mkAdv "แน่นอน" | mkAdv "ทั้งหมด" | mkAdv "โดยสรุป" | mkAdv "ทั้งสิ้น" | mkAdv "พร้อมกัน" | mkAdv "โดยสิ้นเชิง" | mkAdv "รวมทั้งสิ้นเป็น" | mkAdv "ด้วยประการทั้งปวง" ; -- src=panlex
lin altostratus_N = mkN "เมฆเเอลโตสเตรตัส" ; -- src=panlex
lin altruism_N = mkN "ความไม่เห็นแก่ตัว" | mkN "ความเห็นแก่ผู้อื่น" ; -- src=panlex
lin altruist_N = mkN "ผู้ที่เห็นแก่ประโยชน์ของผู้อื่นเป็นที่ตั้ง" ; -- src=panlex
lin altruistic_A = mkA "ไม่เห็นแก่ตัว" ; -- src=panlex
lin alum_N = mkN "แอลัม" | mkN "สารส้ม" | mkN "คนเรียนจบ" | mkN "คนจบการศึกษา" | mkN "ผู้จบการศึกษา" | mkN "โปรแตสเซียมแอลัม" | mkN "ผู้สำเร็จการศึกษา" | mkN "สารส้ม" ; -- src=panlex
lin alumina_N = mkN "อะลูมินา" | mkN "ออกไซด์ของอะลูมิเนียม" ; -- src=panlex
lin aluminate_N = mkN "อะลูมิเนต" ; -- src=panlex
lin aluminiferous_A = mkA "ที่ประกอบด้วยอะลูมิเนียม" | mkA "ซึ่งประกอบหรือให้อะลูมินัม" ; -- src=panlex
lin aluminium_N = mkN "อะลูมิเนียม" | mkN "ธาตุอะลูมิเนียม" | mkN "เลขอะตอม 13" | mkN "อะลูมินัม" | mkN "อลูมิเนียม" | mkN "ธาตุอะลูมิเนียม" ; -- src=panlex
lin aluminum_N = mkN "อะลูมิเนียม" | mkN "ธาตุอะลูมิเนียม" | mkN "เลขอะตอม 13" | mkN "อะลูมินัม" | mkN "อลูมิเนียม" ; -- src=panlex
lin alumna_N = mkN "คนเรียนจบ" | mkN "คนจบการศึกษา" | mkN "ผู้จบการศึกษา" | mkN "ผู้สำเร็จการศึกษา" | mkN "ศิษย์เก่าหญิง" ; -- src=panlex
lin alumnus_N = mkN "คนเรียนจบ" | mkN "คนจบการศึกษา" | mkN "ผู้จบการศึกษา" | mkN "ผู้สำเร็จการศึกษา" | mkN "ศิษย์เก่าชาย" | mkN "ศิษย์เก่าที่เป็นชาย" ; -- src=panlex
lin alumroot_N = mkN "ต้นอะลัมรูท" ; -- src=panlex
lin alveolar_A = mkA "ที่มีลักษณะเหมือนถุง" ; -- src=panlex
lin alveolar_N = mkN "ฐานฟัน" ; -- src=panlex
lin alveolate_A = mkA "แบบรังผึ้ง" | mkA "ซึ่งเป็นแอ่งหรือหลุม" | mkA "ที่โครงสร้างเป็นรูหรือช่องเล็กๆ" ; -- src=panlex
lin alveolus_N = mkN "เบ้าฟัน" | mkN "ถุงลมในปอด" | mkN "ถุงลมเล็กๆ ในปอด" ; -- src=panlex
lin always_AdV = ss (thword "เส" "มอ") ; --- pronunciation
lin always_Adv = mkAdv "ตลอดเวลา" | mkAdv "อย่างสม่ำเสมอ" | mkAdv "อย่างไม่มีหยุด" | mkAdv "อย่างไม่เปลี่ยนแปลง" | mkAdv "เสมอ" | mkAdv "ทุกที" | mkAdv "บ่อยๆ" | mkAdv "เสมอๆ" | mkAdv "ตลอดไป" | mkAdv "ตายตัว" | mkAdv "ทุกคราว" | mkAdv "เด็ดขาด" | mkAdv "ตลอดเวลา" | mkAdv "ทุกครั้ง" | mkAdv "เป็นประจํา" | mkAdv "โดยไม่มีเงื่อนไข" | mkAdv "โดยไม่มีการยกเว้น" ; -- src=panlex
lin alyssum_N = mkN "ต้นอะลีสซัม" ; -- src=panlex
lin amah_N = mkN "เมด" | mkN "แม่นม" | mkN "สาวใช้" | mkN "หญิงรับใช้" | mkN "คนใช้หญิง" | mkN "นางพยาบาล" ; -- src=panlex
lin amain_Adv = mkAdv "ทันที" | mkAdv "รุนแรง" | mkAdv "ฉับพลัน" | mkAdv "ดุเดือด" | mkAdv "รีบร้อน" | mkAdv "เติมกําลัง" | mkAdv "ด้วยความเร็วเต็มที่" ; -- src=panlex
lin amalgam_N = mkN "อะมัลกัม" | mkN "โลหะเจือปรอท" | mkN "การผสม" | mkN "การรวมกัน" | mkN "สารที่ใช้อุดฟัน" | mkN "โลหะผสมของปรอทกับโลหะอื่น" ; -- src=panlex
lin amalgamate_V = mkV "ผสม" | mkV "รวมตัว" | mkV "รวมกัน" | mkV "ทําให้รวมกัน" ; -- src=panlex
lin amalgamate_V2 = mkV2 "ผสม" ; ---- | mkV "รวมตัว" | mkV "รวมกัน" | mkV "ทําให้รวมกัน" ; -- src=panlex
lin amalgamation_N = mkN "การรวมกับปรอท" | mkN "การรวมบริษัทกัน" | mkN "การสกัดโลหะจากแร่ด้วยปรอท" | mkN "ผลที่เกิดจากการรวมกับปรอท" ; -- src=panlex
lin amanuensis_N = mkN "นักจดชวเลข" | mkN "เลขานุการ" ; -- src=panlex
lin amaranth_N = mkN "เมล็ดผักโขม" | mkN "ต้นแอเมอแรนท์" | mkN "ต้นบานไม่รู้โรย" ; -- src=panlex
lin amaranthine_A = mkA "ไม่ซีด" | mkA "ไม่รู้จักจบ" ; -- src=panlex
lin amaretto_N = mkN "อะมาเร็ตโต้" | mkN "เหล้าอะมาเร็ตโต้" ; -- src=panlex
lin amaryllis_N = mkN "ต้นแอมเมอริลลิส" | mkN "สาวงาม" | mkN "หญิงบ้านนอก" ; -- src=panlex
lin amateurFem_N = variants {} ; ---- sense to be split
lin amateurMasc_N = variants {} ; ---- sense to be split
lin amateur_A = mkA "ที่ไร้ฝีมือ" | mkA "มือสมัครเล่น" | mkA "สมัครเล่น" | mkA "นักสมัครเล่น" | mkA "ซึ่งไม่มีทักษะ" | mkA "ซึ่งไม่มีฝีมือ" | mkA "นักกีฬาสมัครเล่น" | mkA "ผู้ไร้ความชํานาญ" | mkA "ผู้ไร้ประสบการณ์" | mkA "ซึ่งไม่เป็นมืออาชีพ" | mkA "ผู้อุทิศตัวในศิลปะหรือกิจกรรมหนึ่ง" ; -- src=panlex
lin amateurish_A = mkA "ที่ไร้ฝีมือ" | mkA "อดิเรก" | mkA "สมัครเล่น" ; -- src=panlex
lin amateurishness_N = mkN "การเป็นมือสมัครเล่น" ; -- src=panlex
lin amative_A = mkA "เกี่ยวกับความรัก" | mkA "เกี่ยวกับความรักใคร่" ; -- src=panlex
lin amatory_A = mkA "เกี่ยวกับการแสดงความรัก" ; -- src=panlex
lin amaurosis_N = mkN "ตาบอดตาใส" ; -- src=panlex
lin amazement_N = mkN "ความประหลาดใจ" ; -- src=panlex
lin amazing_A = mkA "น่าแปลกใจ" | mkA "น่าประหลาดใจ" | mkA "ซึ่งทําให้ประหลาดใจ" ; -- src=panlex
lin amazon_N = mkN "หญิงร่างกำยำ" | mkN "ผู้หญิงแข็งแรง" | mkN "แม่น้ําอะเมซอนในภาคเหนือของอเมริกาใต้" ; -- src=panlex
lin ambages_N = mkN "ทางวกวน" | mkN "การพูดจาอ้อมค้อม" ; -- src=panlex
lin ambassador_N = mkN "ทูต" | mkN "เอกอัครราชทูต" | mkN "ทูต" | mkN "ตัวแทน" | mkN "ผู้แทน" | mkN "ราชทูต" | mkN "นักการทูต" | mkN "เอกอัครราชทูต" ; -- src=panlex
lin ambassadorship_N = mkN "ตำแหน่งท่านฑูต" | mkN "ตำแหน่งเอกอัครราชฑูต" ; -- src=panlex
lin ambassadress_N = mkN "เอกอัครราชฑูตหญิง" | mkN "ภรรยาเอกอัครราชทูต" ; -- src=panlex
lin amber_A = mkA "น้ำตาลอมเหลือง" | mkA "อําพัน" | mkA "สีอําพัน" | mkA "ที่ทําจากอําพัน" | mkA "สีน้ําตาลเหลือง" | mkA "สีเหลืองอย่างอําพัน" ; -- src=panlex
lin amber_N = mkN "ทอง" | mkN "สีทอง" | mkN "อำพัน" | mkN "สีเหลืองทอง" | mkN "อําพัน" | mkN "สีอําพัน" | mkN "สีเหลืองอําพัน" | mkN "สีน้ําตาลเหลือง" ; -- src=panlex
lin ambergris_N = mkN "ขี้ปลาวาฬ" | mkN "ไขจากลําไส้ปลาวาฬนํามาใช้ทําเครื่องสําอาง" ; -- src=panlex
lin amberjack_N = mkN "ปลาแอมเบอร์แจ็ก" ; -- src=panlex
lin ambidexterity_N = mkN "ความหลอกลวง" | mkN "ความชํานาญมาก" | mkN "ความคล่องแคล่ว" | mkN "ความถนัดทั้งสองมือ" | mkN "ความฉลาดอย่างผิดปกติ" | mkN "ความชํานาญในการใช้มือทั้งของข้างได้ดีเท่ากัน" ; -- src=panlex
lin ambidextrous_A = mkA "ถนัดทั้งซ้ายและขวา" | mkA "ชํานาญมาก" | mkA "ตีสองหน้า" | mkA "คล่องแคล่ว" | mkA "ซึ่งถนัดทั้งสองมือ" | mkA "ซึ่งมีทักษะหลายด้าน" | mkA "ใช้มือได้ดีทั้งสองข้าง" ; -- src=panlex
lin ambience_N = mkN "บรรยากาศ" | mkN "สภาพแวดล้อม" | mkN "สภาพแวดล้อม" ; -- src=panlex
lin ambient_A = mkA "ที่อยู่" | mkA "ล้อมรอบ" | mkA "ซึ่งล้อมรอบ" ; -- src=panlex
lin ambiguity_N = mkN "ความกํากวม" | mkN "ภาวะกํากวม" | mkN "ความน่าสงสัย" | mkN "ความมีสองนัย" | mkN "ข้อความกํากวม" | mkN "ความเคลือบคลุม" | mkN "ข้อความคลุมเครือ" | mkN "คําพูดที่คลุมเครือ" | mkN "ความหมายที่คลุมเครือ" | mkN "การตีความหมายได้หลายอย่าง" ; -- src=panlex
lin ambiguous_A = mkA "กำกวม" | mkA "กํากวม" | mkA "คลุมเครือ" | mkA "ที่กํากวม" | mkA "เคลือบคลุม" | mkA "ไม่กระจ่าง" | mkA "ที่ไม่ชัดเจน" | mkA "มีหลายความหมาย" | mkA "ยากที่จะเข้าใจ" | mkA "ที่ตีความหมายได้มากกว่าหนึ่ง" ; -- src=panlex
lin ambit_N = mkN "ขอบเขต" | mkN "วง" | mkN "ขอบเขต" | mkN "เส้นรอบวง" | mkN "บริเวณรอบ ๆ" ; -- src=panlex
lin ambition_N = mkN "ความใฝ่ฝัน" | mkN "ความทะเยอทะยาน" | mkN "เป้าหมาย" | mkN "จุดมุ่งหมาย" | mkN "ความทะเยอทะยาน" | mkN "ความมักใหญ่ใฝ่สูง" | mkN "ความปรารถนาอันแรงกล้า" ; -- src=panlex
lin ambitious_A = mkA "ทะเยอทะยาน" | mkA "ยาก" | mkA "ลําบาก" | mkA "ทะเยอทะยาน" | mkA "ปรารถนาอย่างแรงกล้า" | mkA "ที่ต้องใช้ความพยายามสูง" ; -- src=panlex
lin ambivalence_N = mkN "ความไม่แน่ใจ" ; -- src=panlex
lin amble_N = mkN "การเดินเล่น" | mkN "การเดินช้าๆ สบายๆ" ; -- src=panlex
lin amble_V = mkV "เดินช้าๆ" | mkV "เดินเล่น" | mkV "เดินช้าๆ" | mkV "เดินทอดน่อง" | mkV "เดินช้าๆอย่างสบายๆ" ; -- src=panlex
lin amblygonite_N = mkN "แอมบลีโกไนต์" | mkN "แร่แอมบลีโกไนต์" ; -- src=panlex
lin ambrosia_N = mkN "อาหารทิพย์" | mkN "แอมโบรเซีย" | mkN "ต้นแอมโบรเซีย" | mkN "อาหารของพระเจ้า" | mkN "อาหารที่แสนอร่อย" ; -- src=panlex
lin ambulacrum_N = mkN "แผ่นฐานตีนท่อดาวทะเล" ; -- src=panlex
lin ambulance_N = mkN "รถพยาบาล" | mkN "รถพยาบาลฉุกเฉิน" | mkN "รถพยาบาล" | mkN "ยานพาหนะส่งผู้ป่วย" | mkN "เรือหรือเครื่องบิน" | mkN "โรงพยาบาลเคลื่อนที่" ; -- src=panlex
lin ambulant_A = mkA "ที่เคลื่อนจากที่หนึ่งไปยังอีกที่หนึ่ง" ; -- src=panlex
lin ambulatory_A = mkA "เดินไปมา" | mkA "ที่สามารถเดินได้" | mkA "เกี่ยวกับการเดิน" | mkA "เหมาะสําหรับเดิน" | mkA "ที่เดินเล่นที่มีหลังคา" | mkA "แข็งแรงพอที่จะเดินได้แล้ว" | mkA "ที่เคลื่อนที่จากที่หนึ่งไปที่หนึ่ง" ; -- src=panlex
lin ambulatory_N = mkN "สถานที่ที่ทําไว้สําหรับการเดิน" ; -- src=panlex
lin ambuscade_N = mkN "การซุ่มโจมตี" | mkN "การซุ่มโจมตี" ; -- src=panlex
lin ambush_N = mkN "การซุ่มโจมตี" | mkN "การซุ่มโจมตี" | mkN "การดักลอบทําร้าย" | mkN "ผู้ที่ดักลอบทําร้าย" | mkN "การโจมตีที่ไม่ได้คาดคิด" ; -- src=panlex
lin ambystomid_N = mkN "แอมไบสโตมิด" ; -- src=panlex
lin amebiasis_N = mkN "บิดมีตัว" | mkN "บิดอะมีบา" ; -- src=panlex
lin ameboid_A = mkA "เหมือนอะมีบา" | mkA "คล้ายหรือเกี่ยวกับอะมีบา" ; -- src=panlex
lin ameer_N = mkN "อีเมียร์" ; -- src=panlex
lin ameliorate_V = mkV "ดีขึ้น" | mkV "ปรับปรุง" | mkV "ทำให้ดีขึ้น" | mkV "ดีขึ้น" | mkV "ทําให้ดีขึ้น" | mkV "ปรับปรุงขึ้น" ; -- src=panlex
lin ameliorate_V2 = mkV2 "ดีขึ้น" ; ---- | mkV "ปรับปรุง" | mkV "ทำให้ดีขึ้น" | mkV "ดีขึ้น" | mkV "ทําให้ดีขึ้น" | mkV "ปรับปรุงขึ้น" ; -- src=panlex
lin amelioration_N = mkN "การเยียวยา" | mkN "การทําให้ดีขึ้น" | mkN "การปรับปรุงให้ดีขึ้น" ; -- src=panlex
lin ameloblast_N = mkN "อะมีโลบลาสต์" ; -- src=panlex
lin amelogenesis_N = mkN "กระบวนการสร้างเคลือบฟัน" ; -- src=panlex
lin amen_Interj = mkInterj "สาธุ" | mkInterj "ดีแล้ว" | mkInterj "ชอบแล้ว" | mkInterj "ถูกต้องแล้ว" | mkInterj "ขอให้เป็นเช่นนั้นเทอญ" ; -- src=panlex
lin amenable_A = mkA "ยอม รับฟัง" | mkA "อ่อนโยน" | mkA "ไม่ดื้อ" | mkA "ที่ยอมให้" | mkA "ซึ่งรับผิดชอบ" | mkA "ที่ตอบสนองต่อ" | mkA "ซึ่งยอมให้ทดสอบ" | mkA "ซึ่งยินดีร่วมมือ" ; -- src=panlex
lin amend_V = mkV "แก้ไข" | mkV "ปรับปรุง" | mkV "ทำให้ดีขึ้น" | mkV "แก้ไข" | mkV "ปรับปรุง" | mkV "ทําให้ดีขึ้น" | mkV "ทําให้ถูกต้อง" | mkV "ประพฤติตัวดีขึ้น" ; -- src=panlex
lin amend_V2 = mkV2 "แก้ไข" ; ---- | mkV "ปรับปรุง" | mkV "ทำให้ดีขึ้น" | mkV "แก้ไข" | mkV "ปรับปรุง" | mkV "ทําให้ดีขึ้น" | mkV "ทําให้ถูกต้อง" | mkV "ประพฤติตัวดีขึ้น" ; -- src=panlex
lin amend_V2V = mmkV2V "แก้ไข" ; ---- | mkV "ปรับปรุง" | mkV "ทำให้ดีขึ้น" | mkV "แก้ไข" | mkV "ปรับปรุง" | mkV "ทําให้ดีขึ้น" | mkV "ทําให้ถูกต้อง" | mkV "ประพฤติตัวดีขึ้น" ; -- src=panlex
lin amendatory_A = mkA "ซึ่งแก้ไข" | mkA "ที่ทําให้ถูกต้อง" ; -- src=panlex
lin amendment_N = mkN "การแก้ไข" | mkN "การปรับปรุง" | mkN "การพัฒนาขึ้น" | mkN "การปรับปรุงขึ้น" | mkN "การแก้หรือแปรญัตติ" | mkN "คําแก้หรือคําแปรญัตติ" ; -- src=panlex
lin amenity_N = mkN "ความน่าสนใจ" | mkN "ความน่าดึงดูด" | mkN "สิ่งอํานวยความสะดวก" ; -- src=panlex
lin amenorrhea_N = mkN "ภาวะไม่มีประจำเดือน" | mkN "ภาวะที่ไร้ประจําเดือน" ; -- src=panlex
lin amenorrheic_A = mkA "ที่ประจำเดือนไม่มา" ; -- src=panlex
lin americanFem_N = variants {} ; ---- sense to be split
lin americanMasc_N = variants {} ; ---- sense to be split
lin american_A = mkA "ชาวทวีปอเมริกา" ; -- src=panlex
lin americanism_N = mkN "แบบอเมริกัน" | mkN "ประเพณีอเมริกัน" | mkN "ความเลื่อมในในอเมริกา" | mkN "ภาษาหรือคําศัพท์ที่ใช้ในสหรัฐอเมริกา" ; -- src=panlex
lin americium_N = mkN "อะเมริเซียม" | mkN "ธาตุอะเมริเซียม" | mkN "เลขอะตอม 95" ; -- src=panlex
lin ametabolic_A = mkA "ที่ไม่เปลี่ยนแปลงรูปร่าง" ; -- src=panlex
lin amethyst_A = mkA "สีม่วงปานกลาง" ; -- src=panlex
lin amethyst_N = mkN "อะเมทิสต์" | mkN "แอเมทิสต์" ; -- src=panlex
lin amethystine_A = mkA "เหมือนสีม่วง" ; -- src=panlex
lin ametropia_N = mkN "สายตาผิดปรกติ" ; -- src=panlex
lin ametropic_A = mkA "ซึ่งไม่โฟกัสบนเรตินา" ; -- src=panlex
lin amiability_N = mkN "อารมณ์ดี" | mkN "ความเป็นมิตร" ; -- src=panlex
lin amiable_A = mkA "เป็นมิตร" | mkA "สุภาพ" | mkA "น่ารัก" | mkA "เป็นมิตร" | mkA "มีไมตรีจิต" | mkA "เป็นกันเอง" | mkA "ด้วยไมตรีจิต" ; -- src=panlex
lin amicable_A = mkA "เป็นมิตร" | mkA "ฉันมิตร" | mkA "เป็นมิตร" | mkA "รักใคร่กัน" | mkA "เป็นกันเอง" ; -- src=panlex
lin amid_Prep = mkPrep "ระหว่าง" | mkPrep "ท่ามกลาง" ; -- src=panlex
lin amide_N = mkN "อะไมด์" ; -- src=panlex
lin amidship_Adv = mkAdv "ตรงกลางลำเรือ" | mkAdv "ตรงกลางลำ้เรือ" ; -- src=panlex
lin amidships_Adv = mkAdv "ตรงกลางลำเรือ" | mkAdv "ตรงกลางลำ้เรือ" | mkAdv "ตรงกลางลําเรือ" ; -- src=panlex
lin amidst_Prep = mkPrep "ตรงกลาง" | mkPrep "ระหว่าง" ; -- src=panlex
lin amigo_N = mkN "เพื่อน" ; -- src=panlex
lin amine_N = mkN "อะมิโนอัลเคน" ; -- src=panlex
lin amino_A = mkA "อะมิโน" ; -- src=panlex
lin amino_N = mkN "หมู่อะมิโน" ; -- src=panlex
lin aminomethane_N = mkN "อะมิโนมีเทน" ; -- src=panlex
lin aminophylline_N = mkN "อะมิโนฟิลลีน" ; -- src=panlex
lin aminopyrine_N = mkN "อะมิโนไพรีน" | mkN "ยาอะมิโนไพรีน" ; -- src=panlex
lin amiodarone_N = mkN "อะมีโอดาโรน" | mkN "ยาอะมีโอดาโรน" ; -- src=panlex
lin amir_N = mkN "อีเมียร์" ; -- src=panlex
lin amiss_A = mkA "ไม่ถูกต้อง" | mkA "ไม่เหมาะสม" ; -- src=panlex
lin amiss_Adv = mkAdv "ผิด" | mkAdv "ไม่สมบูรณ์" | mkAdv "อย่างไม่ถูกต้อง" | mkAdv "อย่างไม่สมบูรณ์" | mkAdv "อย่างไม่ถูกต้อง" | mkAdv "อย่างไม่เหมาะสม" ; -- src=panlex
lin amitosis_N = mkN "อะไมโทซิส" | mkN "วิธีแบ่งเซลล์โดยตรง" ; -- src=panlex
lin amitotic_A = mkA "เกี่ยวกับวิธีการแบ่งเซลล์อย่างง่าย" ; -- src=panlex
lin amitriptyline_N = mkN "อะมิทริบไทลีน" | mkN "ยาอะมิทริบไทลีน" ; -- src=panlex
lin amity_N = mkN "มิตรภาพ" | mkN "มิตรภาพ" | mkN "ไมตรีจิต" | mkN "สัมพันธไมตรี" | mkN "ความสัมพันธ์ฉันท์มิตร" ; -- src=panlex
lin ammeter_N = mkN "แอมมิเตอร์" | mkN "เครื่องมือวัดกระแสไฟฟ้าเป็นหน่วยแอมแปร์" | mkN "เครื่องมือวัดกระแสไฟฟ้ามีหน่วยเป็นแอมแปร์" ; -- src=panlex
lin ammine_N = mkN "แอมมีน" ; -- src=panlex
lin ammino_A = mkA "แอมมิโน" ; -- src=panlex
lin ammobium_N = mkN "ดอกแอมโมเบียม" ; -- src=panlex
lin ammonia_N = mkN "แอมโมเนีย" | mkN "สารละลายแอมโมเนีย" | mkN "แอมโมเนีย" | mkN "ก๊าซแอมโมเนีย" | mkN "สารละลายแอมโมเนีย" ; -- src=panlex
lin ammoniac_A = mkA "ที่คล้ายแอมโมเนีย" ; -- src=panlex
lin ammoniated_A = mkA "ที่รักษาด้วยแอมโมเนีย" ; -- src=panlex
lin ammonification_N = mkN "การใส่แอมโมเนีย" | mkN "การสร้างแอมโมเนีย" | mkN "การใส่แอมโมเนีย" | mkN "การสร้างแอมโมเนีย" | mkN "ภาวะที่ถูกใส่แอมโมเนีย" ; -- src=panlex
lin ammonite_N = mkN "แอมโมนอยด์" ; -- src=panlex
lin ammonitic_A = mkA "แอมโมนิติค" ; -- src=panlex
lin ammonium_N = mkN "แอมโมเนียม" | mkN "แอมโมเนียมไอออน" | mkN "แอมโมเนีย" ; -- src=panlex
lin ammunition_N = mkN "อมภัณฑ์" | mkN "เครื่องกระสุน" | mkN "กระสุน" | mkN "ข้อมูล" | mkN "ดินระเบิด" | mkN "ลูกกระสุน" | mkN "วิธีการโต้ตอบ" | mkN "อาวุธยุทธภัณฑ์" ; -- src=panlex
lin amnesia_N = mkN "ภาวะเสียความจำ" | mkN "ภาวะสูญเสียความทรงจํา" ; -- src=panlex
lin amnesic_A = mkA "ที่เป็นโรคความจำเสื่อม" | mkA "ที่สูญเสียความจําทั้งหมดหรือบางส่วน" ; -- src=panlex
lin amnesic_N = mkN "ผู้ป่วยโรคแอมนีเซีย" | mkN "ผู้สูญเสียความจําทั้งหมดหรือบางส่วน" ; -- src=panlex
lin amnestic_A = mkA "ที่เป็นโรคความจำเสื่อม" ; -- src=panlex
lin amnesty_N = mkN "การยกโทษ" | mkN "การอภัยโทษ" | mkN "นิรโทษกรรม" | mkN "ช่วงอภัยโทษ" | mkN "ช่วงนิรโทษกรรม" ; -- src=panlex
lin amnion_N = mkN "ถุงน้ำคร่ำ" | mkN "ถุงน้ําคร่ํา" ; -- src=panlex
lin amniote_N = mkN "สัตว์ที่มีถุงน้ำคร่ำ" ; -- src=panlex
lin amniotic_A = mkA "แอมนิค" | mkA "เกี่ยวกับมีถุงน้ําคร่ํา" ; -- src=panlex
lin amobarbital_N = mkN "แอมโมบาร์บิทอล" | mkN "ยาแอมโมบาร์บิทอล" ; -- src=panlex
lin amoeba_N = mkN "อะมีบา" | mkN "อะมีบา" | mkN "ตัวอะมีบา" ; -- src=panlex
lin amoebic_A = mkA "อะมีบา" | mkA "ซึ่งมีอะมีบาอยู่" | mkA "เกี่ยวกับหรือคล้ายตัวอะมีบา" ; -- src=panlex
lin among_Prep = mkPrep "ในพวก" | mkPrep "ในหมู่" | mkPrep "ระหว่าง" | mkPrep "ท่ามกลาง" | mkPrep "ในจํานวน" | mkPrep "ในจําพวก" | mkPrep "ในระหว่าง" ; -- src=panlex
lin amongst_Prep = mkPrep "ในพวก" | mkPrep "ในหมู่" | mkPrep "ท่ามกลาง" | mkPrep "ในจํานวน" | mkPrep "ในระหว่าง" ; -- src=panlex
lin amora_N = mkN "อะโมรา" ; -- src=panlex
lin amoral_A = mkA "ไร้ศีลธรรม" ; -- src=panlex
lin amorist_N = mkN "คนรัก" | mkN "คนที่ชอบรัก" | mkN "ผู้ที่เขียนเรื่องราวเกี่ยวกับความรัก" ; -- src=panlex
lin amoristic_A = mkA "เกี่ยวกับความรักโรแมนติค" ; -- src=panlex
lin amorous_A = mkA "ชอบรัก" | mkA "เจ้าชู้" | mkA "อยู่ความรัก" | mkA "แสดงความรัก" | mkA "ที่เต็มไปด้วยความรัก" ; -- src=panlex
lin amorousness_N = mkN "ความรักและปรารถนา" ; -- src=panlex
lin amorpha_N = mkN "ต้นอะมอร์ฟา" ; -- src=panlex
lin amorphophallus_N = mkN "พืชสกุลอะมอร์โฟฟัลลัส" ; -- src=panlex
lin amorphous_A = mkA "อสัณฐาน" | mkA "ไร้รูปทรง" | mkA "ไม่เป็นรูปผลึก" | mkA "อสัณฐาน" | mkA "ซึ่งไม่มีรูปร่างที่แน่นอน" | mkA "ซึ่งไม่สามารถแบ่งแยกประเภทได้" ; -- src=panlex
lin amort_A = mkA "ไม่มีชีวิต" | mkA "ไม่มีจิตวิญญาณ" ; -- src=panlex
lin amount_N = mkN "จำนวน" | mkN "ผลบวก" | mkN "ปริมาณ" | mkN "จำนวนเงิน" | mkN "จํานวน" | mkN "ปริมาณ" | mkN "ค่าเต็ม" | mkN "จํานวนรวม" | mkN "จํานวนเงิน" | mkN "รวมทั้งหมด" | mkN "มีค่าเท่ากับ" ; -- src=panlex
lin amount_V = mkV "รวม" | mkV "พัฒนา" | mkV "คิดเป็น" | mkV "มีผลรวม" | mkV "มีผลรวม" | mkV "มีจํานวนรวม" ; -- src=panlex
lin amour_N = mkN "ควาสัมพันธ์ทางเพศ" | mkN "ความสัมพันธ์ฉันชู้สาว" | mkN "ความรัก" | mkN "เรื่องรัก ๆ ใคร่ ๆ" | mkN "เรื่องชู้สาว" | mkN "การลักลอบรักกัน" ; -- src=panlex
lin amoxicillin_N = mkN "อะมอกซิซิลลิน" ; -- src=panlex
lin amp_N = mkN "เเอมแปร์" | mkN "กําลังกระแสไฟฟ้า" ; -- src=panlex
lin amperage_N = mkN "จำนวนแอมแปร์" | mkN "กําลังกระแสไฟฟ้าที่วัดเป็นหน่วยแอมแปร์" ; -- src=panlex
lin ampere_N = mkN "แอมแปร์" | mkN "เเอมแปร์" | mkN "แอมป์" | mkN "แอมแปร์" | mkN "หน่วยของกระแสไฟฟ้า" ; -- src=panlex
lin ampersand_N = mkN "เครื่องหมายแอมเปอร์แซนด์" ; -- src=panlex
lin amphetamine_N = mkN "แอมเฟตามีน" | mkN "ยากระตุ้นประสาท" | mkN "ยาบ้า" | mkN "ยาม้า" | mkN "ยาขยัน" | mkN "แอมเฟตามีน" ; -- src=panlex
lin amphibia_N = mkN "ชั้นแอมฟิเบีย" | mkN "จําพวกสัตว์สะเทินน้ําสะเทินบก" ; -- src=panlex
lin amphibian_N = mkN "รถสะเทินน้ำสะเทินบก" | mkN "สัตว์ครึ่งบกครึ่งน้ำ" | mkN "เครื่องบินสะเทินน้ำสะเทินบก" | mkN "เครื่องบินสะเทิ้นน้ำสะเทิ้นบก" | mkN "สัตว์ครึ่งบกครึ่งน้ํา" | mkN "สัตว์สะเทินน้ําสะเทินบก" | mkN "กระทําได้ทั้งบนน้ําและบนบก" | mkN "พืชที่อยู่ได้ทั้งในน้ําและบนบก" | mkN "ยานพาหนะที่เดินทางได้ทั้งในน้ําและบนบก" ; -- src=panlex
lin amphibious_A = mkA "ครึ่งบกครึ่งน้ำ" | mkA "สะเทินน้ำสะเทินบก" | mkA "สะเทินน้ําสะเทินบก" | mkA "ซึ่งสามารถใช้ได้ทั้งบนน้ําและบนบก" | mkA "ซึ่งอาศัยอยู่ได้ทั้งในน้ําและบนบก" ; -- src=panlex
lin amphibole_N = mkN "แอมฟิโบล" | mkN "แร่แอมฟิโบล" ; -- src=panlex
lin amphibolite_N = mkN "หินแอมฟิโบโลต์" ; -- src=panlex
lin amphibology_N = mkN "ความหมายที่คลุมเคลือ" | mkN "การที่มีความหมายสองนัย" ; -- src=panlex
lin amphictyony_N = mkN "สันติบาทรัฐ" ; -- src=panlex
lin amphidiploid_N = mkN "เซลล์ที่มีโครโมโซมคู่ซ้ำจากพ่อและแม่" ; -- src=panlex
lin amphimixis_N = mkN "การสืบพันธุ์แบบอาศัยเพศ" ; -- src=panlex
lin amphisbaena_N = mkN "งูสองหัว" ; -- src=panlex
lin amphistylar_A = mkA "มีเสาทั้งสองข้าง" | mkA "มีเสาทั้งด้านหน้าและหลัง" ; -- src=panlex
lin amphitheatre_N = mkN "โคลีเซียม" | mkN "โรงละครกลางแจ้ง" | mkN "อัฒจันทร์แบบกรีกและโรมัน" | mkN "อัฒจันทร์" | mkN "ที่นั่งชมการแสดงรูปวงกลมที่ไม่มีหลังคา" ; -- src=panlex
lin amphora_N = mkN "แอมโฟร่า" | mkN "ไหแอมโฟร่า" ; -- src=panlex
lin amphoric_A = mkA "ที่เป็นเสียงเป่าปากขวด" ; -- src=panlex
lin amphoteric_A = mkA "ที่เป็นได้ทั้งกรดและเบส" | mkA "ซึ่งมีฤทธิ์เป็นกรดหรือด่าง" ; -- src=panlex
lin amphotericin_N = mkN "แอมโฟเทอริซิน" ; -- src=panlex
lin ampicillin_N = mkN "แอมพิซิลลิน" ; -- src=panlex
lin ample_A = mkA "ใหญ่" | mkA "ซึ่งมีมากมายก่ายกอง" | mkA "ใหญ่" | mkA "มากพอ" | mkA "ถึงขนาด" | mkA "พอเพียง" | mkA "เพียงพอ" | mkA "ขนาดใหญ่" | mkA "กว้างขวาง" | mkA "อุดมสมบูรณ์" | mkA "เหลือพอเพียง" ; -- src=panlex
lin amplification_N = mkN "อัตราขยาย" | mkN "สิ่งที่ใช้ขยาย" | mkN "ภาวะที่ถูกขยายออก" | mkN "การขยายข้อความหรือเรื่องราว" | mkN "การขยายออกให้กว้างหรือใหญ่ขึ้น" | mkN "ข้อความหรือเรื่องราวที่ขยายออก" ; -- src=panlex
lin amplifier_N = mkN "แอมปลิไฟเออร์" | mkN "อุปกรณ์ขยายสัญญาณ" | mkN "เครื่องขยายสัญญาณ" | mkN "เครื่องขยายเสียง" | mkN "บุคคลหรือสิ่งที่ขยายใหญ่" ; -- src=panlex
lin amplitude_N = mkN "จำนวนมาก" | mkN "แอมพิจูด" | mkN "แอมพลิจูด" | mkN "ความล้นเหลือ" | mkN "ความกว้างขวาง" | mkN "ความอุดมสมบูรณ์" ; -- src=panlex
lin ampoule_N = mkN "ขวดยา" | mkN "หลอดยาสำเ็ร็จรูป" | mkN "หลอดแก้วหรือพลาสติกที่ใส่ยาสําหรับฉีด" ; -- src=panlex
lin ampulla_N = mkN "กระเปาะ" | mkN "แอมพูลลา" | mkN "ภาชนะใส่น้ำมันเพื่อทำพิธีกรรม" | mkN "ภาชนะใส่น้ํามันเพื่อทําพิธีกรรม" ; -- src=panlex
lin ampullar_A = mkA "แอมพูลลา" ; -- src=panlex
lin amputee_N = mkN "ผู้สูญเสียแขนขา" | mkN "ผู้ที่ถูดตัด" | mkN "ผู้ที่ถูกตัดแขนหรือขา" ; -- src=panlex
lin amrinone_N = mkN "ยาแอมริโนน" ; -- src=panlex
lin amuck_Adv = mkAdv "ที่อาละวาด" | mkAdv "อย่างบ้าคลั่ง" | mkAdv "อาละวาด" | mkAdv "บ้าคลั่ง" | mkAdv "บ้าระห่ํา" | mkAdv "ที่อาละวาด" | mkAdv "เตลิดเปิดเปิง" | mkAdv "ซึ่งไม่สามารถควบคุมตัวเองได้" ; -- src=panlex
lin amulet_N = mkN "วัตถุมงคล" | mkN "ของปลุกเสก" | mkN "พระเครื่อง" | mkN "เครื่องราง" | mkN "ของดี" | mkN "ของขลัง" | mkN "เครื่องราง" ; -- src=panlex
lin amusement_N = mkN "ความขบขัน" | mkN "ความบันเทิง" | mkN "มหรสพ" | mkN "ความขบขัน" | mkN "นันทนาการ" | mkN "ความอภิรมย์" | mkN "เครื่องหย่อนใจ" | mkN "สิ่งให้ความอภิรมย์" | mkN "สิ่งที่ทําให้สนุกสนาน" | mkN "กิจกรรมที่เป็นสันทนาการ" | mkN "กิจกรรมที่ให้ความบันเทิง" ; -- src=panlex
lin amusing_A = mkA "ตลก" | mkA "ขบขัน" | mkA "ตลกขบขัน" | mkA "น่าสนุกสนาน" ; -- src=panlex
lin amygdala_N = mkN "} ผลอัลมันต์" | mkN "ต่อมทอนซิล" | mkN "ผลเฮ้งยิ้งของจีน" | mkN "ส่วนที่คล้ายผลอัลมันต์" ; -- src=panlex
lin amygdalin_N = mkN "อะมิกดาลิน" ; -- src=panlex
lin amygdaline_A = mkA "อัลมอนด์" ; -- src=panlex
lin amygdaloid_N = mkN "อะมีกดาลอยด์" ; -- src=panlex
lin amyl_N = mkN "เอมิล" ; -- src=panlex
lin amylase_N = mkN "อะไมเลส" | mkN "เอ็นไซม์ย่อมแป้งชนิดหนึ่ง" ; -- src=panlex
lin amyloid_N = mkN "แอมีลอยด์" ; -- src=panlex
lin amyloidosis_N = mkN "โรคแอมีลอยด์" ; -- src=panlex
lin amylolysis_N = mkN "การเปลี่ยนแป้งเป็นน้ำตาล" ; -- src=panlex
lin amylolytic_A = mkA "เอมีโลลีติค" ; -- src=panlex
lin amyotrophia_N = mkN "กล้ามเนื้อฝ่อลีบ" ; -- src=panlex
lin anabatic_A = mkA "อะนาบาติค" | mkA "เลื่อนขึ้น" | mkA "เกี่ยวกับลมพัดขึ้นเชา" ; -- src=panlex
lin anabiotic_A = mkA "อะนาไบโอติค" ; -- src=panlex
lin anabolic_A = mkA "อะนาโบลิค" ; -- src=panlex
lin anabolism_N = mkN "การสร้างเนื้อเยื่อ" ; -- src=panlex
lin anachronism_N = mkN "คนเกิดผิดยุค" | mkN "ผู้เกิดก่อนกาล" | mkN "เกิดผิดยุคสมัย" ; -- src=panlex
lin anaclinal_A = mkA "แห่งหุบเขา" ; -- src=panlex
lin anaclitic_A = mkA "ที่เป็นความสัมพันธ์พึ่งพา" ; -- src=panlex
lin anaconda_N = mkN "อนาคอนด้า" | mkN "งูเหลือมหรืองูหลามขนาดใหญ่" | mkN "งูขนาดใหญ่ชนิดหนึ่งในอเมริกาใต้" ; -- src=panlex
lin anadiplosis_N = mkN "การซ้ําคําของอนุประโยคหรือประโยค" ; -- src=panlex
lin anadromous_A = mkA "ซึ่งอพยพไปวางไข่" | mkA "ซึ่งว่ายจากทะเลสู่แม่น้ําเพื่อวางไข่" ; -- src=panlex
lin anaemia_N = mkN "โรคโลหิตจาง" ; -- src=panlex
lin anaemic_A = mkA "อะเนมิค" ; -- src=panlex
lin anaerobe_N = mkN "แบคทีเรีย" ; -- src=panlex
lin anaerobic_A = mkA "ที่ไม่ต้องการอากาศ" | mkA "ซึ่งอาศัยในที่ไม่มีออกซิเจน" ; -- src=panlex
lin anaesthesia_N = mkN "อาการสลบ" | mkN "การทําให้ชา" | mkN "การไร้ความรู้สึก" ; -- src=panlex
lin anaesthetist_N = mkN "วิสัญญีแพทย์" ; -- src=panlex
lin anaglyph_N = mkN "แอนะกลิฟ" | mkN "ของประดับที่มีปลายนูน" | mkN "ของประดับที่มีปลายนูน" ; -- src=panlex
lin anaglyphic_A = mkA "สามมิติแบบภาพเหลื่อม" ; -- src=panlex
lin anaglyphy_N = mkN " ภาพสามมิติ" ; -- src=panlex
lin anagogic_A = mkA "ซึ่งแปลความหมายตามหลักจิตวิญญาณ" ; -- src=panlex
lin anagram_N = mkN "คำสลับอักษร" | mkN "การสับเปลี่ยนพยัญชนะของคําหรือวลีเพื่อให้ได้คําหรือวลีใหม่" ; -- src=panlex
lin anagrammatic_A = mkA "เกี่ยวกับการสับเปลี่ยนคำ" ; -- src=panlex
lin anagrams_N = mkN "อะนาแกรม" ; -- src=panlex
lin anal_A = mkA "ระยะทวาร" | mkA "ทางทวารหนัก" | mkA "เกี่ยวกับทวารหนัก" ; -- src=panlex
lin analects_N = mkN "งานกวีนิพนธ์สั้น ๆ" ; -- src=panlex
lin analeptic_A = mkA "เสริมกําลัง" | mkA "บํารุงกําลัง" | mkA "ยาบํารุงกําลัง" ; -- src=panlex
lin analeptic_N = mkN "ยาบำรุงกำลัง" | mkN "เสริมกําลัง" | mkN "บํารุงกําลัง" | mkN "ยาบํารุงกําลัง" ; -- src=panlex
lin analgesia_N = mkN "ความไม่รู้เจ็บ" | mkN "อาการชา" | mkN "การไร้ความรู้สึกปวด" | mkN "ภาวะไร้ความรู้สึกเจ็บปวด" ; -- src=panlex
lin analgesic_A = mkA "ซึ่งทําให้ไม่รู้สึกเจ็บปวด" ; -- src=panlex
lin analgesic_N = mkN "ยาแก้ปวด" | mkN "ยาบรรเทาปวด" ; -- src=panlex
lin analogous_A = mkA "ซึ่งสอดคล้องกับหน้าที่" | mkA "คล้าย" | mkA "คล้ายคลึง" | mkA "เหมือนกัน" | mkA "ที่คล้ายกัน" | mkA "คล้ายคลึงกัน" ; -- src=panlex
lin analogue_A = mkA "อะนาล็อก" ; -- src=panlex
lin analogue_N = mkN "ของที่คล้ายกัน" | mkN "สิ่งที่คล้ายกัน" | mkN "ของที่คล้ายหรือเหมือนกัน" | mkN "ค่าที่มีความต่อเนื่องกันโดยตลอด" ; -- src=panlex
lin analogy_N = mkN "ความเหมือนกัน" | mkN "การเปรียบเหมือน" | mkN "ภาวะอุปมาเหมือน" | mkN "ความคล้ายคลึงกัน" | mkN "ประสิทธิภาพเหมือนกัน" ; -- src=panlex
lin analphabet_N = mkN "คนไม่รู้พยัญชนะ" | mkN "ผู้ไม่รู้พยัญชนะ" ; -- src=panlex
lin analphabetic_A = mkA "ซึ่งไม่เรียงตามลำดับอักษร" ; -- src=panlex
lin analysis_N = mkN "การวิเคราะห์" | mkN "จิตวิเคราะห์" | mkN "การวิภาค" | mkN "การแยกธาตุ" | mkN "การพิเคราะห์" | mkN "การวิเคราะห์" | mkN "จิตวิเคราะห์" | mkN "ผลการวิเคราะห์" | mkN "การจําแนกแยกแยะ" | mkN "การวิเคราะห์ทางจิตใจ" | mkN "การนํามาแยกเป็นส่วนๆ เพื่อพิจารณาในประเด็นต่างๆ" ; -- src=panlex
lin analyst_N = mkN "นักวิเคราะห์" | mkN "นักจิตวิเคราะห์" | mkN "นักวิเคราะห์" | mkN "ผู้วิเคราะห์" | mkN "นักวิเคราะห์ทางจิต" | mkN "จิตแพทย์ผู้ทําการวิเคราะห์" ; -- src=panlex
lin analytic_A = mkA "ซึ่งไม่ผันคำ" | mkA "เชิงวิเคราะห์" | mkA "อย่างวิเคราะห์" | mkA "ซึ่งใช้การวิเคราะห์" | mkA "เกี่ยวกับการแยกธาตุ" | mkA "เกี่ยวกับการวิเคราะห์" | mkA "เกี่ยวกับการจําแนกแยกแยะ" ; -- src=panlex
lin analytical_A = mkA "อย่างวิเคราะห์" ; -- src=panlex
lin analyzer_N = mkN "เครื่องวิเคราะห์" ; -- src=panlex
lin anamnestic_A = mkA "ซึ่งช่วยความจำ" ; -- src=panlex
lin anamorphic_A = mkA "เกี่ยวกับวิวัฒนาการของอวัยวะ" | mkA "เกี่ยวกับความผิดปรกติของระบบสายตา" ; -- src=panlex
lin anamorphism_N = mkN "ภาพเพี้ยน" | mkN "อะนามอร์ฟิซึม" | mkN "การเพิ่มปล้องหลังฝัก" ; -- src=panlex
lin anamorphosis_N = mkN "ภาพเพี้ยน" | mkN "การเพิ่มปล้องหลังฝัก" | mkN "การเขียนภาพที่ผิดจากธรรมชาติ" ; -- src=panlex
lin anaphase_N = mkN "แอนาเฟส" ; -- src=panlex
lin anaphasic_A = mkA "ระยะแบ่งเซลล์" ; -- src=panlex
lin anaphor_N = mkN "รูปอ้าง" ; -- src=panlex
lin anaphrodisia_N = mkN "กำหนัด" ; -- src=panlex
lin anaphrodisiac_A = mkA "ซึ่งไม่เร้าความรู้สึกทางเพศ" ; -- src=panlex
lin anaphylactic_A = mkA "เกี่ยวกับความรู้สึกไว" ; -- src=panlex
lin anaphylaxis_N = mkN "ภาวะภูมิแพ้" ; -- src=panlex
lin anapsid_N = mkN "อะแนปซิด" ; -- src=panlex
lin anarchism_N = mkN "ลัทธิอนาธิปัตย์" | mkN "อนาธิปไตย" | mkN "ลัทธิไม่มีรัฐบาล" | mkN "ลัทธิที่เห็นว่าบ้านเมืองไม่ควรมีกฎหมายหรือรัฐบาล" ; -- src=panlex
lin anarchistFem_N = variants {} ; ---- sense to be split
lin anarchistMasc_N = variants {} ; ---- sense to be split
lin anarchistic_A = mkA "ซึ่งไม่มีขื่อมีแปร" ; -- src=panlex
lin anarchy_N = mkN "อนาธิปไตย" | mkN "ความสับสน" | mkN "อนาธิปไตย" | mkN "ภาวะอนาธิปไตย" | mkN "ภาวะไม่มีรัฐบาล" | mkN "สถานการณ์ที่สับสน" | mkN "ภาวะที่ไม่มีรัฐบาล" ; -- src=panlex
lin anarthria_N = mkN "ภาวะไร้สมรถภาพในการพูด" ; -- src=panlex
lin anasarca_N = mkN "มานทะลุน" | mkN "การบวมทั้งตัว" | mkN "ภาวะบวมน้ําทั่วไป" ; -- src=panlex
lin anaspid_N = mkN "ปลาแอนาสปิด" ; -- src=panlex
lin anastigmat_N = mkN " เลนส์ที่ทำให้แสงไม่พร่า" | mkN "ไม่พร่า" | mkN "เลนซ์รวมที่ใช้แก้ภาวะตาพร่า" ; -- src=panlex
lin anastigmatic_A = mkA "เกี่ยวกับระบบเลนส์แบบอิสระ" ; -- src=panlex
lin anastrophe_N = mkN "การกลับกัน" | mkN "การวางกลับกัน" ; -- src=panlex
lin anastylosis_N = mkN "การประกอบคืนสภาพ" ; -- src=panlex
lin anathema_N = mkN "การสาปแช่ง" | mkN "การขับไล่ออกจากศาสนา" | mkN "บุคคลหรือสิ่งที่คนสาปแช่งหรือเกลียด" | mkN "บุคคลหรือสิ่งที่ถูกสาปแช่งหรือเกลียด" ; -- src=panlex
lin anathematize_V = mkV "ประณาม" | mkV "สาปแช่ง" | mkV "ประณาม" ; -- src=panlex
lin anathematize_V2 = mkV2 "ประณาม" ; ---- | mkV "สาปแช่ง" | mkV "ประณาม" ; -- src=panlex
lin anatomic_A = mkA "เชิงกายวิภาค" | mkA "ที่เกี่ยวกับโครงสร้าง" ; -- src=panlex
lin anatomical_A = mkA "เชิงกายวิภาค" | mkA "ที่เกี่ยวกับโครงสร้าง" ; -- src=panlex
lin anatomist_N = mkN "นักกายวิภาค" | mkN "นักกายวิภาคศาสตร์" | mkN "ผู้ที่เชี่ยวชาญเกี่ยวกับโครงสร้างมนุษย์" ; -- src=panlex
lin anatomy_N = mkN "กาย" | mkN "สังขาร" | mkN "ร่างกาย" | mkN "กายวิภาค" | mkN "พระวรกาย" | mkN "ร่างกายมนุษย์" | mkN "กายวิิภาคศาสตร์" | mkN "ร่างกายของมนุษย์" | mkN "โครงกระดูก" | mkN "กายวิภาควิทยา" | mkN "กายวิภาคศาสตร์" | mkN "การวิเคราะห์อย่างละเอียด" | mkN "การตรวจวิเคราะห์อย่างละเอียด" ; -- src=panlex
lin anatotitan_N = mkN "อะนาโตติแตน" ; -- src=panlex
lin anatoxin_N = mkN "อะนาทอกซิน" ; -- src=panlex
lin anatropous_A = mkA "ซึ่งสับเปลี่ยนที่กัน" ; -- src=panlex
lin ancestor_N = mkN "บรรพชน" | mkN "ปู่ยาตายาย" | mkN "เทือกเถาเหล่ากอ" | mkN "ต้นตระกูล" | mkN "บรรพบุรุษ" | mkN "ปู่ย่าตายาย" | mkN "ผู้ถูกสืบทอด" | mkN "ผู้ที่นําหน้า" | mkN "ผู้ที่ทายาทได้รับมรดก" | mkN "รูปแบบเดิมของสิ่งมีชีวิต" ; -- src=panlex
lin ancestral_A = mkA "ที่ได้จากบรรพบุรุษ" | mkA "ตกทอด" | mkA "ที่ได้จากบรรพบุรุษ" | mkA "เกี่ยวกับบรรพบุรุษ" | mkA "ที่สืบต่อมาจากบรรพบุรุษ" ; -- src=panlex
lin ancestress_N = mkN "บรรพชนหญิง" | mkN "บรรพบุรุษหญิง" | mkN "บรรพบุรุษหญิง" | mkN "บรรพบุรุษหญิงเทือกเถาเหล่ากอหญิง" ; -- src=panlex
lin ancestry_N = mkN "กำพืด" | mkN "สายเลือด" | mkN "เชื้อสาย" | mkN "การสืบทอด" | mkN "สายตระกูล" | mkN "ผู้สืบสกุล" | mkN "เทือกเถาเหล่ากอ" | mkN "ต้นตระกูล" | mkN "บรรพบุรุษ" | mkN "วงศ์ตระกูล" | mkN "เทือกเถาเหล่ากอทั้งหลาย" | mkN "ขบวนการหรือประวัติดังกล่าว" ; -- src=panlex
lin anchor_N = mkN "สมอ" | mkN "สมอเรือ" | mkN "เสาหลัก" | mkN "ปัจจัยหลัก" | mkN "กระดูกสันหลัง" | mkN "ผู้ประกาศข่าว" | mkN "แกนสนับสนุนหลัก" | mkN "สมอ" | mkN "สมอเรือ" | mkN "ที่ยึดเหนี่ยว" | mkN "ผู้ประกาศข่าว" | mkN "ผู้ที่พึ่งพิงได้" | mkN "เครื่องยึดเหนี่ยว" | mkN "ผู้ที่สามารถไว้ใจได้" ; -- src=panlex
lin anchor_V = mkV "ทอดสมอ" | mkV "ติดแน่น" | mkV "ทอดสมอเรือ" | mkV "ทอดสมอ" | mkV "เป็นผู้ประกาศข่าว" ; -- src=panlex
lin anchor_V2 = mkV2 "ทอดสมอ" ; ---- | mkV "ติดแน่น" | mkV "ทอดสมอเรือ" | mkV "ทอดสมอ" | mkV "เป็นผู้ประกาศข่าว" ; -- src=panlex
lin anchorage_N = mkN "การทอดสมอ" | mkN "ตัวค้ํา" | mkN "ที่ทอดสมอ" | mkN "ภาษีที่จอดเรือ" | mkN "ภาวะที่ยึดเหนี่ยว" | mkN "วิธีการยึดเหนี่ยว" ; -- src=panlex
lin anchorite_N = mkN "ฤาษี" | mkN "โยคี" | mkN "ผู้อยู่" | mkN "ผู้ที่อยู่สันโดษเพื่อรักษาศีล" ; -- src=panlex
lin anchoritic_A = mkA "ซึ่งถือสันโดษ" ; -- src=panlex
lin anchorman_N = mkN "ผู้ประกาศข่าว" | mkN "หัวเรี่ยวหัวแรง" ; -- src=panlex
lin anchovy_N = mkN "ปลากะตัก" | mkN "แองโชวี่" | mkN "ปลาแองโชวี่" | mkN "ปลาแอนโชวี่" ; -- src=panlex
lin ancient_A = mkA "โบราณ" | mkA "เก่าแก่" | mkA "แก่หง่อม" | mkA "ธง" | mkA "แบบ" | mkA "อดีต" | mkA "เก่า" | mkA "โบราณ" | mkA "เก่าแก่" | mkA "คนชรามาก" | mkA "ผู้ถือธง" | mkA "โบราณกาล" ; -- src=panlex
lin ancient_N = mkN "คนยุคโบราณ" | mkN "คนแก่หง่อม" | mkN "คนยุคบรรพกาล" | mkN "คนเก่าแก่" | mkN "คนสมัยโบราณ" | mkN "ผู้ที่ชรามาก" ; -- src=panlex
lin ancientness_N = mkN "ความเก่าแก่" ; -- src=panlex
lin ancillary_A = mkA "ซึ่งช่วยเหลือ" ; -- src=panlex
lin and_Conj = {s1 = [] ; s2 = "และ"} ;
lin andante_A = mkA "ค่อนข้างช้าและแรียบ" ; -- src=panlex
lin andantino_A = mkA "อันดันติโน" ; -- src=panlex
lin andesite_N = mkN "หินแอนดีไซต์" ; -- src=panlex
lin andiron_N = mkN "สามขาสำหรับวางฟืน" | mkN "ขาหยั่งโลหะ" ; -- src=panlex
lin andradite_N = mkN "แอนดราไดต์" ; -- src=panlex
lin andrena_N = mkN "ผึ้งแอนดรีนา" ; -- src=panlex
lin androecium_N = mkN "แอนดรีเซียม" | mkN "เกสรตัวผู้" ; -- src=panlex
lin androgen_N = mkN "แอนโดรเจน" | mkN "ฮอร์โมนแอนโดรเจน" ; -- src=panlex
lin androgenesis_N = mkN "แอนโดรเจเนซิส" ; -- src=panlex
lin androgenic_A = mkA "เกี่ยวกับฮอร์โมนแอนโดรเจน" ; -- src=panlex
lin androgynous_A = mkA "ที่มีสองเพศ" | mkA "แอนโดรจีเนียส" | mkA "กะเทย" ; -- src=panlex
lin android_N = mkN "มนุษย์ยนต์" | mkN "หุ่นแอนดรอยด์" ; -- src=panlex
lin andromeda_N = mkN "ต้นแอนโดรมีดา" | mkN "ต้นไม้สกุลแอนโดรมีดา" ; -- src=panlex
lin androsterone_N = mkN "แอนโดรสเตอโรน" | mkN "ฮอร์โมนชายที่มักพบในปัสสาวะชาย" ; -- src=panlex
lin andryala_N = mkN "ต้นแอนเดรียลา" ; -- src=panlex
lin anecdotal_A = mkA "ที่มีเรื่องราว" ; -- src=panlex
lin anecdote_N = mkN "เรื่องราว" | mkN "ประวัติหรือเรื่องราวเล็ก ๆ น้อย ๆ" ; -- src=panlex
lin anecdotist_N = mkN "นักเล่านิทาน" | mkN "ผู้เล่าเกร็ดประวัติ" | mkN "ผู้เล่าเรื่องราวเล็ก ๆ น้อย ๆ" ; -- src=panlex
lin anechoic_A = mkA "ไม่มีเสียงสะท้อนกลัย" | mkA "ซึ่งมีเสียงก้องต่ําที่สุดที่จะเป็นไปได้" ; -- src=panlex
lin anemia_N = mkN "โรคโลหิตจาง" | mkN "ความอ่อนแอ" | mkN "ภาวะโลหิตจาง" | mkN "ภาวะไร้กําลัง" | mkN "ความอ่อนกําลัง" ; -- src=panlex
lin anemic_A = mkA "อะเนมิค" ; -- src=panlex
lin anemographic_A = mkA "เกี่ยวกับการบันทึกมาตรวัดกระแสลม" ; -- src=panlex
lin anemometer_N = mkN "เครื่องวัดลม" | mkN "มาตรความเร็วลม" | mkN "เครืองวัดอัตราความเร็วของลม" | mkN "เครื่องวัดอัตราความเร็วของลม" ; -- src=panlex
lin anemometric_A = mkA "เกี่ยวกับการวัดความเร็วและทิศทางลม" ; -- src=panlex
lin anemone_N = mkN "ต้นอะนีโมนี" ; -- src=panlex
lin anemophilous_A = mkA "เกี่ยวกับพืชดอก" ; -- src=panlex
lin anencephalic_A = mkA "ที่มีสมองบางส่วน" ; -- src=panlex
lin anent_Prep = mkPrep "นอกจาก" | mkPrep "เกี่ยวกับ" ; -- src=panlex
lin anergy_N = mkN "การตอบสนองต่อการทดสอบปฏิกิริยาภูมิไวเกินชนิดค่าเป็นลบ" ; -- src=panlex
lin aneroid_A = mkA "ที่ไม่บรรจุของเหลว" | mkA "ไม่ใช้ของเหลว" | mkA "ซึ่งไม่ใช้ของเหลว" ; -- src=panlex
lin aneroid_N = mkN "แอเนอรอยด์บารอมิเตอร์" ; -- src=panlex
lin anesthesia_N = mkN "อาการสลบ" | mkN "การชา" | mkN "อาการชา" | mkN "การไม่สนใจ" | mkN "การไร้อารมณ์" | mkN "การไร้ความรู้สึก" | mkN "การสูญเสียความรู้สึก" | mkN "การไร้ความรู้สึกต่อความเจ็บปวด" ; -- src=panlex
lin anesthesiologist_N = mkN "วิสัญญีแพทย์" | mkN "วิสัญญีแพทย์" | mkN "แพทย์ผู้ชํานาญการวางยาสลบหรือชา" | mkN "แพทย์ผู้ชํานาญการวางยาสลบหรือยาชา" ; -- src=panlex
lin anesthesiology_N = mkN "วิสัญญีวิทยา" | mkN "วิชาเกี่ยวกับการวางยาสลบหรือยาชา" ; -- src=panlex
lin anesthetic_A = mkA "ยาชา" | mkA "ยาสลบ" | mkA "ยาระงับความรู้สึก" | mkA "ที่เกี่ยวกับการไร้ความรู้สึก" ; -- src=panlex
lin anesthetic_N = mkN "ยาชา" | mkN "ยาสลบ" | mkN "ยาระงับความรู้สึก" ; -- src=panlex
lin anesthetist_N = mkN "วิสัญญีแพทย์" | mkN "ผู้วางยาชาหรือยาสลบ" | mkN "ผู้ที่ถูกฝึกฝนในการใช้ยาชา" ; -- src=panlex
lin anesthyl_N = mkN "อะเนสทิล" ; -- src=panlex
lin anestrous_A = mkA "ที่ตัวไม่ตั้งตรง" ; -- src=panlex
lin aneuploid_A = mkA "ที่มีเลขโครโมโซม" ; -- src=panlex
lin aneurysm_N = mkN "หลอดเลือดโป่งพอง" | mkN "ภาวะเส้นโลหิตแดงโป่งพองเป็นถุงขังโลหิตไว้" ; -- src=panlex
lin aneurysmal_A = mkA "ซึ่งเส้นโลหิดแดงโป่งพอง" ; -- src=panlex
lin anew_Adv = mkAdv "ใหม่" | mkAdv "อีกครั้ง" | mkAdv "อีกครั้ง" ; -- src=panlex
lin anfractuous_A = mkA "วกวน" ; -- src=panlex
lin angel_N = mkN "เซนต์" | mkN "นักบุญ" | mkN "นางฟ้า" | mkN "เทพธิดา" | mkN "นางสวรรค์" | mkN "เทวดา" | mkN "นางฟ้า" | mkN "นายทุน" | mkN "เทพธิดา" | mkN "คนที่ใจดี" | mkN "ฑูตสวรรค์" | mkN "เทพเจ้าที่เฝ้ารักษา" | mkN "ผู้ตายที่มีวิญญาณขึ้นสวรรค์" ; -- src=panlex
lin angelfish_N = mkN "ฉลามนางฟ้า" | mkN "ปลาสเปดฟิช" | mkN "ปลาแองเจลฟิช" ; -- src=panlex
lin angelic_A = mkA "จากเทพธิดา" | mkA "แห่งเทพธิดา" | mkA "ที่เหมือนนักบุญ" ; -- src=panlex
lin angelica_N = mkN "ต้นแอนเจลิกา" | mkN "ต้นต้นเกย" | mkN "ต้นไ้จําพวกหนึ่ง ใช้ทําเครื่องหอม" ; -- src=panlex
lin angelim_N = mkN "ต้นแองจิลิม" ; -- src=panlex
lin angelology_N = mkN "ทูตสวรรค์วิทยา" | mkN "ทูตสวรรค์วิทยา" | mkN "ทฤษฎีเกี่ยวกับทูตสวรรค์" | mkN "การศึกษาเกี่ยวกับเทพหรือเทวดา" ; -- src=panlex
lin anger_N = mkN "ความโกรธ" | mkN "อารมณ์โกรธ" | mkN "ความรู้สึกโกรธ" | mkN "ฉิว" | mkN "โทสะ" | mkN "เคือง" | mkN "ความโกรธ" | mkN "ความเคือง" | mkN "ความฉุนเฉียว" ; -- src=panlex
lin angina_N = mkN "อาการปวดเค้น" | mkN "โรคอักเสบที่ลําคอ" ; -- src=panlex
lin angiocardiogram_N = mkN "แองจิโอคาร์ดิโอแกรม" ; -- src=panlex
lin angiocarp_N = mkN "พืชที่ให้ผลชนิดมีเปลือกแข็งหุ้ม" ; -- src=panlex
lin angiocarpic_A = mkA "ที่มีเปลือกแข็งหุ้ม" ; -- src=panlex
lin angiogenesis_N = mkN "แองจิโอเจเนซิส" ; -- src=panlex
lin angiogram_N = mkN "แองจิโอแกรม" ; -- src=panlex
lin angiologist_N = mkN "หมอนาฬิวิทยา" ; -- src=panlex
lin angiology_N = mkN "นาฬิวิทยา" | mkN "วิทยาหลอดเลือดและหลอดน้ำเหลือง" | mkN "วิชาเกี่ยวกับหลอดโลหิตและหลอดน้ําเหลือง" ; -- src=panlex
lin angioplasty_N = mkN "ศัลยกรรมตกแต่งหลอดเลือด" ; -- src=panlex
lin angiopteris_N = mkN "ต้นเฟิร์นยักษ์" ; -- src=panlex
lin angiosarcoma_N = mkN "แอนจิโอซาร์โคมา" ; -- src=panlex
lin angioscope_N = mkN "กล้องส่องหลอดเลือดหัวใจ" ; -- src=panlex
lin angiosperm_N = mkN "พืชดอก" | mkN "พืชเมล็ดอยู่ภายในผลหรือเมล็ดมีรังไข่ห่อหุ้ม" ; -- src=panlex
lin angiotensin_N = mkN "แองกิโอเทนซิน" ; -- src=panlex
lin angle_N = mkN "มุม" | mkN "มุม" | mkN "มุมมอง" | mkN "การวัดมุม" | mkN "แง่มุมในการพิจารณา" ; -- src=panlex
lin angle_V = mkV "มีอคติ" | mkV "ลงเบ็ด" | mkV "เอนตัว" | mkV "วางเบ็ด" | mkV "เอนเอียง" | mkV "ตกปลาด้วยเบ็ด" | mkV "ล่อ" | mkV "ตกปลา" | mkV "หักมุม" | mkV "เคลื่อนที่ทํามุม" | mkV "ทําให้เคลื่อนที่เป็นมุม" ; -- src=panlex
lin angle_V2 = mkV2 "มีอคติ" ; ---- | mkV "ลงเบ็ด" | mkV "เอนตัว" | mkV "วางเบ็ด" | mkV "เอนเอียง" | mkV "ตกปลาด้วยเบ็ด" | mkV "ล่อ" | mkV "ตกปลา" | mkV "หักมุม" | mkV "เคลื่อนที่ทํามุม" | mkV "ทําให้เคลื่อนที่เป็นมุม" ; -- src=panlex
lin angle_dozer_N = mkN "แองเกิลโดเซอร์" ; -- src=panlex
lin angler_N = mkN "คนตกปลา" | mkN "นักตกปลา" | mkN "พรานเบ็ด" | mkN "ปลากูสฟิช" | mkN "ผู้ตกปลา" ; -- src=panlex
lin anglewing_N = mkN "ผีเสื้อแองกลีวิง" ; -- src=panlex
lin angling_N = mkN "การลงเบ็ด" | mkN "การวางเบ็ด" | mkN "การตกปลา" ; -- src=panlex
lin anglophilFem_N = variants {} ; ---- sense to be split
lin anglophilMasc_N = variants {} ; ---- sense to be split
lin anglophileFem_N = variants {} ; ---- sense to be split
lin anglophileMasc_N = variants {} ; ---- sense to be split
lin anglophobe_N = mkN "คนต่อต้านอังกฤษ" ; -- src=panlex
lin angostura_N = mkN "เปลือกแองกอสตูรา" | mkN "ชื่อเปลือกไม้หอมที่ใช้เป็นยาบํารุงและยาลดไข้" ; -- src=panlex
lin angrecum_N = mkN "แองกรีคัม" ; -- src=panlex
lin angry_A = mkA "โกรธ" | mkA "แค้น" | mkA "โกรธ" | mkA "โมโห" | mkA "เดือด" | mkA "อักเสบ" | mkA "ขัดเคือง" | mkA "ขุ่นข้อง" | mkA "ฉุนเฉียว" | mkA "ขุ่นเคือง" | mkA "โกรธเคือง" | mkA "ที่มีพายุแรง" ; -- src=panlex
lin angst_N = mkN "ความวิตกกังวล" | mkN "ความกังวล" | mkN "ความเป็นห่วง" | mkN "ความเป็นทุกข์" ; -- src=panlex
lin angstrom_N = mkN "อังสตรอม" ; -- src=panlex
lin anguine_A = mkA "ที่คล้ายงู" | mkA "เกี่ยวกับหรือคล้ายงู" ; -- src=panlex
lin anguish_N = mkN "ความทุกข์ทรมาน" | mkN "ความทุกข์" | mkN "ความรวดร้าว" | mkN "ความทุกข์ทรมาน" | mkN "อาการกลัดกลุ้มมาก" | mkN "อาการปวดอย่างรุนแรง" | mkN "อาการทนทุกข์ทรมานมาก" ; -- src=panlex
lin anguished_A = mkA "กลัดกลุ้ม" | mkA "ทนทุกข์ทรมาน" ; -- src=panlex
lin angular_A = mkA "เชิงมุม" | mkA "ที่มีมุม" | mkA "มีมุม" | mkA "เกี่ยว กับหรือวัดด้วยมุม" | mkA "ผอมแห้ง" | mkA "แข็งทื่อ" | mkA "ซึ่งเป็นมุม" | mkA "เกี่ยวกับมุม" ; -- src=panlex
lin angularity_N = mkN "รูปทรงที่มีมุม" | mkN "มุมแหลม" | mkN "ความที่เป็นมุม" | mkN "ภาวะที่เป็นมุม" | mkN "โครงร่างที่เป็นมุม" ; -- src=panlex
lin angulation_N = mkN "การทำให้เกิดมุม" | mkN "การเกิดมุม" | mkN "การวัดมุมอย่างละเอียด" ; -- src=panlex
lin angwantibo_N = mkN "แองแวนติโบ" ; -- src=panlex
lin anhedonia_N = mkN "ภาวะสิ้นยินดี" ; -- src=panlex
lin anhydride_N = mkN "แอนไฮไดรด์" | mkN "สารประกอบที่เอาน้ําออก" | mkN "สารประกอบที่เมื่อรวมกับน้ําจะได้กรดหรือด่าง" ; -- src=panlex
lin anhydrous_A = mkA "ปราศจากน้ำ" | mkA "ปราศจากน้ํา" | mkA "ซึ่งเอาน้ําออกหมด" ; -- src=panlex
lin ani_N = mkN "นกกาเหว่าชนิดหนึ่งในอเมริกา" ; -- src=panlex
lin anicteric_A = mkA "ปลอดจากโรคดีซ่าน" ; -- src=panlex
lin anil_N = mkN "ต้นแอนิล" | mkN "สีอินดิโก" | mkN "คราม" | mkN "สีน้ําเงินเข้ม" ; -- src=panlex
lin anile_A = mkA "เหมือนหญิงแก่" ; -- src=panlex
lin aniline_N = mkN "อะนิลีน" | mkN "อะมิโนเบนซีน" ; -- src=panlex
lin anima_N = mkN "ชีวิต" | mkN "จิตวิญญาณ" | mkN "ความรู้สึกตัว" ; -- src=panlex
lin animadversion_N = mkN "การวิพากษ์วิจารณ์" | mkN "การตําหนิ" | mkN "คําตําหนิ" | mkN "การวิจารณ์" | mkN "คําวิจารณ์" | mkN "การวิพากษ์วิจารณ์" ; -- src=panlex
lin animadvert_V = mkV "แสดงความคิดเห็น" | mkV "วิจารณ์" ; -- src=panlex
lin animal_A = mkA "เกี่ยวกับสัตว์" | mkA "ซึ่งเกิดจากสัตว์" | mkA "เกี่ยวกับเนื้อหนังมังสา" ; -- src=panlex
lin animal_N = animalN (thword "สัตว์") | {-pan-} mkN "สัตว์" | mkN "สัตว์ป่า" | mkN "เดียรัจฉาน" | mkN "สิ่งมีชีวิต" | mkN "สัตว์เดียรัจฉาน" | mkN "สัตว์" | mkN "คนที่หยาบคาย" | mkN "คนที่คล้ายสัตว์" | mkN "สัตว์เลี้ยงลูกด้วยนม" | mkN "คนที่โหดร้ายทารุณคล้ายสัตว์" ; -- src=panlex
lin animalcule_N = mkN "จุลินทรีย์" | mkN "จุลินทรีย์" | mkN "สัตว์ขนาดเล็ก" ; -- src=panlex
lin animalism_N = mkN "ธรรมชาติของสัตว์" ; -- src=panlex
lin animalistic_A = mkA "เกี่ยวกับธรรมชาติของสัตว์" ; -- src=panlex
lin animality_N = mkN "ธรรมชาติของสัตว์" | mkN "ลักษณะสัตว์" | mkN "ความเป็นสัตว์" | mkN "อาณาจักรของสัตว์" ; -- src=panlex
lin animalization_N = mkN "ภาพร่างของสัตว์" ; -- src=panlex
lin animate_A = mkA "ที่มีความรู้สึก" | mkA "ที่เป็นหมวดสิ่งมีชีวิต" | mkA "ร่าเริง" | mkA "ซึ่งมีชีวิต" | mkA "ที่มีชีวิตชีวา" | mkA "ซึ่งมีชีวิตชีวา" ; -- src=panlex
lin animatedly_Adv = mkAdv "อย่างกระตือรือร้น" ; -- src=panlex
lin animateness_N = mkN "ความเป็นสัตว์" ; -- src=panlex
lin animation_N = mkN "ชีวิต" | mkN "ความมีชีวิตชีวา" | mkN "การสร้างการ์ตูนเอนิเมชั่น" | mkN "การสร้างภาพยนตร์เอนิเมชั่น" | mkN "พลังงาน" | mkN "ความดีใจ" | mkN "ความมีชีวิต" | mkN "ความมีชีวิตชีวา" | mkN "การสร้างภาพยนตร์" | mkN "ความกระตือรือร้น" | mkN "ภาวะที่มีชีวิตชีวา" | mkN "ขบวนการสร้างหนังการ์ตูน" | mkN "การสร้างภาพเคลื่อนไหวได้" | mkN "ภาพการ์ตูนที่เคลื่อนไหวได้" ; -- src=panlex
lin animatistic_A = mkA "เกี่ยวกับธรรมชาติของสัตว์" ; -- src=panlex
lin animator_N = mkN "อนิเมเตอร์" | mkN "คนวาดภาพการ์ตูน" | mkN "บุคคลหรือสิ่งที่มีชีวิตชีวา" | mkN "ผู้สร้างภาพที่เคลื่อนไหวได้" | mkN "บุคคลหรือสิ่งที่ทําให้มีชีวิตชีวา" ; -- src=panlex
lin animatronics_N = mkN "เอนิเมทรอนิกส์" ; -- src=panlex
lin anime_N = mkN "ซานซิบาร์โคปอล" ; -- src=panlex
lin animism_N = mkN "ความเชื่อว่ามีวิญญาณในธรรมชาติและจักรวาล" ; -- src=panlex
lin animist_A = mkA "เกี่ยวกับสัตวนิยม" ; -- src=panlex
lin animosity_N = mkN "ความจง-เกลียดจงชัง" | mkN "ความเกลียด" | mkN "ความเกลียดชัง" | mkN "ความเป็นปรปักษ์" ; -- src=panlex
lin animus_N = mkN "เจตจํานง" | mkN "ความตั้งใจ" | mkN "ความเกลียด" | mkN "ความเป็นปรปักษ์" ; -- src=panlex
lin anion_N = mkN "แอนไอออน" | mkN "ไอออนที่มีประจุลบ" ; -- src=panlex
lin anionic_A = mkA "เกี่ยวกับไอออนประจุลบ" ; -- src=panlex
lin anise_N = mkN "ต้นแอนิส" | mkN "เมล็ดผักชีหรือ" | mkN "เมล็ดพืชชนิดหนึ่งใช้เป็นตัวแต่งกลิ่นแต่งรส" ; -- src=panlex
lin aniseed_N = mkN "เมล็ดพืชชนิดหนึ่งใช้เป็นตัวแต่งกลิ่นแต่งรส" ; -- src=panlex
lin aniseikonia_N = mkN "อาการตาเห็นรูปต่างกัน" ; -- src=panlex
lin anisogamete_N = mkN "เซลล์สืบพันธุ์ต่างขนาด" ; -- src=panlex
lin anisogamy_N = mkN "การผสมแบบเซลล์สืบพันธุ์ต่างขนาด" ; -- src=panlex
lin anisometric_A = mkA "สัดส่วนไม่เท่ากัน" | mkA "มีแกนที่มีความยาวต่างกัน" ; -- src=panlex
lin anisotropy_N = mkN "แอนไอโซทรอปี" ; -- src=panlex
lin ankle_N = mkN "ข้อตีน" | mkN "ข้อเท้า" | mkN "ข้อเท้า" | mkN "ส่วนเรียวยาวบริเวณเหนือข้อเท้า" ; -- src=panlex
lin anklebone_N = mkN "กระดูกข้อเท้า" | mkN "กระดูกข้อเท้า" ; -- src=panlex
lin anklet_N = mkN "สายข้อเท้า" | mkN "กำไลข้อเท้า" | mkN "ถุงเท้าสั้น" | mkN "สร้อยข้อเท้า" | mkN "รองเท้ารัดข้อ" | mkN "ตรวน" | mkN "กําไลเท้า" | mkN "สิ่งที่สวมรอบข้อเท้า" | mkN "รองเท้าที่มีสายรัดข้อเท้า" | mkN "สิ่งประดับที่สวมรอบข้อเท้า" ; -- src=panlex
lin ankus_N = mkN "ขอสับช้าง" ; -- src=panlex
lin ankylosaur_N = mkN "แองกีโลซอรัส" ; -- src=panlex
lin ankylosis_N = mkN "ข้อยึดติด" ; -- src=panlex
lin anna_N = mkN "อันนา" ; -- src=panlex
lin annalist_N = mkN "ผู้บันทึกเหตุการณ์ประจำปี" | mkN "บันทึกประวัติศาสตร์" | mkN "ผู้บันทึกเหตุการณ์ประจําปี" | mkN "หนังสือรายงานเป็นทางการของหน่วยงาน" ; -- src=panlex
lin annals_N = mkN "รายงานประจำปี" | mkN "บันทึก" | mkN "จดหมายเหตุ" | mkN "ประวัติการณ์" | mkN "ข้อความที่บันทึกไว้" | mkN "บันทึกเหตุการณ์ประจําปี" ; -- src=panlex
lin annealing_N = mkN "การเผาให้อ่อนตัว" ; -- src=panlex
lin annelid_N = mkN "สัตว์พวกหนอนปล้อง" ; -- src=panlex
lin annex_N = mkN "ส่วนปีก" | mkN "ภาคผนวก" ; -- src=panlex
lin annexation_N = mkN "การเข้าร่วม" | mkN "การผนวก" | mkN "สิ่งที่ผนวกเข้า" ; -- src=panlex
lin annexe_N = mkN "ส่วนปีก" ; -- src=panlex
lin annihilation_N = mkN "การขจัด" | mkN "การทำลายล้าง" | mkN "การทําลายล้าง" | mkN "ภาวะที่ถูกทําลายล้าง" ; -- src=panlex
lin anniversary_N = mkN "วันครบรอบ" | mkN "วาระครบรอบ" | mkN "ประจําปี" | mkN "วันครบรอบปี" | mkN "การฉลองครบรอบปี" | mkN "การครบรอบปีของเหตุการณ์ในอดีต" ; -- src=panlex
lin annotation_N = mkN "บรรณนิทัศน์" | mkN "การทําหมายเหตุประกอบ" | mkN "การให้คําจํากัดความประกอบ" ; -- src=panlex
lin announcement_N = mkN "ประกาศ" | mkN "แถลงการณ์" | mkN "การแถลง" | mkN "การโฆษณา" | mkN "การประกาศ" | mkN "คําประกาศ" | mkN "เสียงประกาศ" | mkN "การทําให้รู้" | mkN "การป่าวประกาศ" ; -- src=panlex
lin announcer_N = mkN "ผู้ประกาศ" | mkN "โฆษก" | mkN "ผู้แถลง" | mkN "ผู้โฆษณา" | mkN "ผู้ประกาศ" ; -- src=panlex
lin annoyance_N = mkN "ความรำคาญ" | mkN "สิ่งกวนใจ" | mkN "คนที่น่ารำคาญ" | mkN "ความรู้สึกรำคาญ" | mkN "ตัวกวน" | mkN "การรบกวน" | mkN "การทําให้" | mkN "ความรําคาญ" | mkN "สิ่งที่รบกวน" | mkN "ความน่ารําคาญ" | mkN "ความรู้สึกรําคาญ" | mkN "บุคคลหรือสิ่งที่รบกวน" ; -- src=panlex
lin annoying_A = mkA "น่ารำคาญ" | mkA "น่ารําคาญ" | mkA "ซึ่งมารบกวน" | mkA "ซึ่งทําให้รําคาญ" ; -- src=panlex
lin annual_A = mkA "รายปี" | mkA "เป็นรายปี" | mkA "ที่มีอายุไม่เกินหนึ่งปี" | mkA "ทุกปี" | mkA "ประจําปี" | mkA "เกี่ยวกับปี" | mkA "เกิดขึ้นระหว่างปี" | mkA "ซึ่งเกิดขึ้นปีละครั้ง" ; -- src=panlex
lin annual_N = mkN "หนังสือประจําปี" ; -- src=panlex
lin annuitant_N = mkN "ผู้รับเงินรายปี" | mkN "ผู้รับเงินประจำปี" | mkN "ผู้ได้รับเงินรายปี" ; -- src=panlex
lin annuity_N = mkN "เงินรายปี" | mkN "เงินรายปี" | mkN "เงินรายได้เป็นรายปี" | mkN "สิทธิในการรับเงินรายปี" | mkN "การลงทุนที่จ่ายเงินคืนรายปี" | mkN "สิทธิที่จะได้รับเงินดังกล่าว" ; -- src=panlex
lin annular_A = mkA "ซึ่งเป็นรูปวงแหวน" | mkA "ซึ่งเป็นรูปวงแหวน" ; -- src=panlex
lin annulet_N = mkN "แหวนวงเล็ก" | mkN "วงแหวนเล็กๆ" ; -- src=panlex
lin annulment_N = mkN "การยกเลิก" | mkN "การยกเลิก" | mkN "การลบล้าง" | mkN "การประกาศว่าเป็นโมฆะ" ; -- src=panlex
lin annulus_N = mkN "ทรงหูสมอ" | mkN "รูปโดนัท" ; -- src=panlex
lin annum_N = mkN "พรรษา" ; -- src=panlex
lin annunciation_N = mkN "ประกาศ" ; -- src=panlex
lin annunciator_N = mkN "แอนนันซิเอเตอร์" | mkN "ผู้ประกาศ" | mkN "เครื่องบอกสัญญาณ" ; -- src=panlex
lin anoa_N = mkN "ควายแคระ" ; -- src=panlex
lin anode_N = mkN "แอโนด" | mkN "ไฟฟ้าขั้วบวก" | mkN "ขั้วบวก" | mkN "ขั้วบวกในแบตเตอรี่" ; -- src=panlex
lin anodic_A = mkA "เกี่ยวกับขั้วบวก" ; -- src=panlex
lin anodyne_A = mkA "บรรเทาความเจ็บปวด" ; -- src=panlex
lin anodyne_N = mkN "ยาแก้ปวด" | mkN "สิ่งที่บรรเทาปวด" | mkN "ยาบรรเทาอาการปวด สิ่งที่บรรเทาความทุกข์" ; -- src=panlex
lin anointing_N = mkN "การทาด้วยน้ำมัน" ; -- src=panlex
lin anointment_N = mkN "การทาด้วยน้ำมัน" | mkN "การทาด้วยน้ํามัน" ; -- src=panlex
lin anomalopteryx_N = mkN "อะโนมาลอปทีรีกซ์" ; -- src=panlex
lin anomalous_A = mkA "ผิดที่" | mkA "วิปริต" | mkA "ผิดปกติ" | mkA "ผิดหลัก" | mkA "ที่ต่างไปจากปกติ" | mkA "ที่ต่างจากเกณฑ์ปกติ" ; -- src=panlex
lin anomaly_N = mkN "มุมกวาด" | mkN "อะนอมาลี" | mkN "คนที่ไม่ปกติ" | mkN "ความผิดปกติ" | mkN "บุคคลที่ผิดจากปกติ" | mkN "สิ่งที่แปลกประหลาด" ; -- src=panlex
lin anomie_N = mkN "ภาวะผิดปกติของบุคคลหรือสังคม" ; -- src=panlex
lin anon_Adv = mkAdv "บ่อย" | mkAdv "ไม่ช้า" | mkAdv "เวลาอื่น" | mkAdv "ในไม่ช้า" ; -- src=panlex
lin anonymity_N = mkN "ความไม่มีลักษณะเฉพาะ" ; -- src=panlex
lin anonymous_A = mkA "นิรนาม" | mkA "นิรนาม" | mkA "ไม่ระบุชื่อ" | mkA "ซึ่งไม่ระบุชื่อ" | mkA "ซึ่งไม่มีลักษณะเด่น" | mkA "ซึ่งไม่มีลักษณะเฉพาะ" ; -- src=panlex
lin anopheles_N = mkN "ยุงก้นปล่องซึ่งเป็นพาหะนําไข้มาลาเรีย" ; -- src=panlex
lin anorak_N = mkN "เสื้อคลุมมีหมวก" | mkN "เสื้อกันหนาวมีหมวก" | mkN "เสื้อแจ็กเก็ตมีหมวก" | mkN "เสื้อกันหนาวที่มีส่วนที่เป็นหมวกคลุม" ; -- src=panlex
lin anorexia_N = mkN "โรคเบื่ออาหาร" | mkN "ภาวะไร้ความอยากอาหารหรือไม่สามารถรับประทานอาหารได้" ; -- src=panlex
lin anorexic_N = mkN "ผู้ป่วยโรคอะโนเร็กเซียเนอร์โวซา" ; -- src=panlex
lin anorthite_N = mkN "อะนอร์ไทต์" ; -- src=panlex
lin anorthitic_A = mkA "อะนอร์ไทต์" ; -- src=panlex
lin anosmia_N = mkN "การสูญเสียประสาทรับกลิ่น" ; -- src=panlex
lin anosmic_A = mkA "ซึ่งสูญเสียประสาทรับกลิ่น" ; -- src=panlex
lin anovulation_N = mkN "การไม่ตกไข่" ; -- src=panlex
lin anoxemia_N = mkN "ภาวะออกซิเจนในเลือดลดลง" ; -- src=panlex
lin anoxemic_A = mkA "ซึ่งออกซิเจนน้อยผิดปกติ" ; -- src=panlex
lin anoxic_A = mkA "ซึ่งขาดออกซิเจน" ; -- src=panlex
lin anserine_A = mkA "เหมือนห่าน" | mkA "คล้ายห่าน" ; -- src=panlex
lin answer_N = mkN "เฉลย" | mkN "คำตอบ" | mkN "การตอบ" | mkN "การตอบคำถาม" | mkN "วิธีแก้ปัญหา" | mkN "คําตอบ" | mkN "การโต้ตอบ" | mkN "การตอบคําถาม" | mkN "วิธีแก้ปัญหา" | mkN "สิ่งที่โต้ตอบ" | mkN "สิ่งที่ตอบสนอง" | mkN "คําแก้ต่างในศาล" ; -- src=panlex
lin answer_V = mkV "ตอบ" | mkV "สนอง" | mkV "เฉลย" | mkV "เหมาะ" | mkV "ตรงกับ" | mkV "ตอบรับ" | mkV "ตอบสนอง" | mkV "ตอบคำถาม" | mkV "ตอบโจทย์" | mkV "สอดคล้องกับ" | mkV "แก้ข้อกล่าวหา" | mkV "สนองความต้องการ" | mkV "ตอบ" | mkV "เฉลย" | mkV "โต้ตอบ" | mkV "ตอบสนอง" | mkV "ให้คําตอบ" | mkV "แก้ตัวในศาล" | mkV "แก้ต่างในศาล" | mkV "บรรลุจุดประสงค์" | mkV "ทําให้บรรลุตามความต้องการ" ; -- src=panlex
lin answer_V2 = mkV2 "ตอบ" ; ---- | mkV "สนอง" | mkV "เฉลย" | mkV "เหมาะ" | mkV "ตรงกับ" | mkV "ตอบรับ" | mkV "ตอบสนอง" | mkV "ตอบคำถาม" | mkV "ตอบโจทย์" | mkV "สอดคล้องกับ" | mkV "แก้ข้อกล่าวหา" | mkV "สนองความต้องการ" | mkV "ตอบ" | mkV "เฉลย" | mkV "โต้ตอบ" | mkV "ตอบสนอง" | mkV "ให้คําตอบ" | mkV "แก้ตัวในศาล" | mkV "แก้ต่างในศาล" | mkV "บรรลุจุดประสงค์" | mkV "ทําให้บรรลุตามความต้องการ" ; -- src=panlex
lin answer_V2S = mkV2S (regV "ตอบ") [] ; ---- prep
lin answer_back_V2 = mkV2 (advV OP_answer_V OP_back_Adv ) ; -- guess-p-verb
lin answer_for_V2 = prepV2 OP_answer_V OP_for_Prep ; -- guess-p-verb
lin answerable_A = mkA "ที่ตอบได้" | mkA "ตอบได้" | mkA "แก้ได้" | mkA "ที่มีคําตอบ" ; -- src=panlex
lin ant_N = mkN "มด" | mkN "มด" | mkN "ปลวก" ; -- src=panlex
lin ant_eater_N = mkN "ตัวตุ่น" | mkN "พาโกลิน" | mkN "ตัวกินมด" | mkN "ตัวกินมดซึ่งเป็นสัตว์เลี้ยงลูกด้วยนม" ; -- src=panlex
lin ant_hill_N = mkN "รังมด" ; -- src=panlex
lin antacid_N = mkN "ยาลดกรด" | mkN "สารลดกรด" ; -- src=panlex
lin antagonism_N = mkN "ความเป็นศัตรู" | mkN "สภาวะปฏิปักษ์" | mkN "ความเป็นปรปักษ์" | mkN "สภาวะตรงกันข้าม" | mkN "การต่อต้าน" | mkN "ความเป็นปรปักษ์" | mkN "ความเป็นศัตรูกัน" | mkN "บทบาทของการต่อต้าน" ; -- src=panlex
lin antagonist_N = mkN "ยาต้าน" | mkN "ปรปักษ์" | mkN "ฝ่ายตรงข้าม" | mkN "กล้ามเนื้อต้าน" | mkN "ศัตรู" | mkN "ผู้ต่อต้าน" | mkN "ยาต้านฤทธิ์" | mkN "ผู้เป็นปรปักษ์" | mkN "กล้ามเนื้อที่ต้านกล้ามเนื้ออื่น" ; -- src=panlex
lin antagonistic_A = mkA "ซึ่งเป็นศัตรู" | mkA "ซึ่งเป็นปรปักษ์" | mkA "ซึ่งเป็นปฏิปักษ์" ; -- src=panlex
lin antbird_N = mkN "นกแอนต์เบิร์ด" ; -- src=panlex
lin antecedence_N = mkN "สิ่งที่มาก่อน" | mkN "การดําเนินการก่อน" | mkN "เรื่องราวที่ต้องมาก่อน" ; -- src=panlex
lin antecedent_A = mkA "ก่อนหน้า" | mkA "ก่อน" | mkA "มาก่อน" | mkA "แต่ก่อน" | mkA "ข้อเสนอแรก" | mkA "เกิดขึ้นก่อน" | mkA "ซึ่งมีมาแต่อดีต" | mkA "ซึ่งเกิดขึ้นก่อน" ; -- src=panlex
lin antecedent_N = mkN "บรรพชน" | mkN "ปู่ยาตายาย" | mkN "เทือกเถาเหล่ากอ" | mkN "ก่อน" | mkN "มาก่อน" | mkN "แต่ก่อน" | mkN "ข้อเสนอแรก" | mkN "เกิดขึ้นก่อน" | mkN "สิ่งที่มาก่อน" ; -- src=panlex
lin antechamber_N = mkN "ล็อบบี้" | mkN "ห้องรับรอง" | mkN "ห้องโถงใหญ่" | mkN "ห้องขนาดเล็กซึ่งเป็นห้องที่เป็นทางผ่านไปยังห้องที่ใหญ่กว่า" ; -- src=panlex
lin antecubital_A = mkA "ตรงบริเวณแขนท่อนล่าง" ; -- src=panlex
lin antediluvian_A = mkA "ก่อนน้ำท่วมโลก" | mkA "เก่าแก่มาก" | mkA "ก่อนสมัยน้ําท่วมโลก" ; -- src=panlex
lin antediluvian_N = mkN "คนแก่หง่อม" | mkN "คนหัวโบราณ" ; -- src=panlex
lin antelope_N = mkN "ละมั่ง" | mkN "สัตว์จําพวกที่มีเขาเป็นเกลียว" ; -- src=panlex
lin antemeridian_A = mkA "ก่อนเที่ยง" | mkA "ก่อนเที่ยง" | mkA "ที่เกิดก่อนเที่ยง" ; -- src=panlex
lin antemortem_A = mkA "ก่อนตาย" ; -- src=panlex
lin antenatal_A = mkA "ก่อนการคลอดลูก" | mkA "ก่อนเกิด" ; -- src=panlex
lin antenna_N = mkN "สายอากาศ" | mkN "หนวดสัมผัส" | mkN "สายอากาศ" | mkN "เสาอากาศ" | mkN "หนวดของสัตว์ที่ใช้สัมผัสอากาศ" ; -- src=panlex
lin antenuptial_A = mkA "ก่อนแต่งงาน" ; -- src=panlex
lin antepenult_N = mkN "พยางค์ที่สามจากท้ายสุดของคํา" ; -- src=panlex
lin anterior_A = mkA "ด้านหน้า" | mkA "ก่อน" | mkA "ข้างหน้า" | mkA "ล่วงหน้า" | mkA "ตําแหน่งหน้า" | mkA "เกิดขึ้นก่อน" | mkA "ซึ่งอยู่ข้างหน้า" | mkA "อยู่ตําแหน่งข้างหน้า" ; -- src=panlex
lin anterograde_A = mkA "ซึ่งสูญเสียความทรงจำ" ; -- src=panlex
lin anteroom_N = mkN "ล็อบบี้" | mkN "ห้องรับรอง" | mkN "ห้องโถงใหญ่" | mkN "ห้องนอกสําหรับนั่งคอย" | mkN "ห้องเล็กที่อยู่ด้านหน้าห้องใหญ่" ; -- src=panlex
lin anthelmintic_A = mkA "ซึ่งฆ่าหรือขับพยาธิ" ; -- src=panlex
lin anthem_N = mkN "เพลงสดุดี" | mkN "เพลงสวดสรรเสริญ" | mkN "เพลงสวด" | mkN "เพลงชาติ" | mkN "เพลงสดุดี" | mkN "เพลงสวดในโบสถ์" | mkN "เพลงสรรเสริญพระบารมี" ; -- src=panlex
lin anther_N = mkN "เกสรตัวผู้ของดอกไม้" | mkN "เกสรตัวผู้ของดอกไม้" ; -- src=panlex
lin antheridiophore_N = mkN "แอนเทอริดีโอฟอร์" ; -- src=panlex
lin antheridium_N = mkN "แอนเทอริเดียม" ; -- src=panlex
lin antherozoid_N = mkN "แอนเทอโรซอยด์" ; -- src=panlex
lin anthology_N = mkN "ประชุมบทนิพนธ์" | mkN "บทเขียนรวมของหลายนักเขียน" | mkN "การรวบรวมบทประพันธ์ของหลายนักเขียน" ; -- src=panlex
lin anthophyllite_N = mkN "แอนโทฟีลไลต์" | mkN "แร่แอนโทฟีลไลต์" ; -- src=panlex
lin anthozoan_N = mkN "กะละปังหา" | mkN "กะละปังหา" ; -- src=panlex
lin anthracite_N = mkN "ถ่านหินไร้ควัน" | mkN "ถ่านหินแข็ง" | mkN "ถ่านหินชนิดแข็ง" | mkN "ถ่านที่ไม่มีควัน" ; -- src=panlex
lin anthracitic_A = mkA "เหมือนถ่านหินแอนทราไซต์" ; -- src=panlex
lin anthracosis_N = mkN "โรคปอดดำ" ; -- src=panlex
lin anthrax_N = mkN "โรคแอนแทรกซ์" | mkN "โรคแอนแทร็คซ์" | mkN "โรคติดต่อร้ายแรงในสัตว์เลี้ยง" ; -- src=panlex
lin anthropocentric_A = mkA "ที่มนุษย์เป็นศูนย์กลาง" ; -- src=panlex
lin anthropocentrism_N = mkN "มานุษยประมาณนิยม" ; -- src=panlex
lin anthropogenetic_A = mkA "เกี่ยวกับจุดกำเนิดของมนุษย์" ; -- src=panlex
lin anthropoid_A = mkA "คล้ายคน" ; -- src=panlex
lin anthropoid_N = mkN "มนุษย์วานร" | mkN "ที่มีลักษณะคล้ายลิงเอป" ; -- src=panlex
lin anthropological_A = mkA "มานุษยวิทยา" ; -- src=panlex
lin anthropologistFem_N = variants {} ; ---- sense to be split
lin anthropologistMasc_N = variants {} ; ---- sense to be split
lin anthropology_N = mkN "มานุษยวิทยา" | mkN "มานุษยวิทยา" | mkN "การศึกษาเกี่ยวกับมนุษยในด้านต่างๆ" ; -- src=panlex
lin anthropometric_A = mkA "เกี่ยวกับการศึกษาร่างกายของมนุษย์" ; -- src=panlex
lin anthropometry_N = mkN "การวัดร่างกายมนุษย์ตามหลักวิทยาศาสตร์" ; -- src=panlex
lin anthropophagous_A = mkA "เกียวกับมนุษย์กินคน" ; -- src=panlex
lin anthropophagy_N = mkN "การกินเนื้อมนุษย์" ; -- src=panlex
lin anthroposophy_N = mkN "มนุษยปรัชญา" ; -- src=panlex
lin anthurium_N = mkN "ต้นเทลฟลาเวอร์" ; -- src=panlex
lin anti_A = mkA "ต่อต้าน" ; -- src=panlex
lin anti_N = mkN "พวกแอนตี้" | mkN "คนที่คัดค้าน" | mkN "คนที่ต่อต้าน" ; -- src=panlex
lin anti_aircraft_A = mkA "ซึ่งต่อต้านอากาศยาน" | mkA "ต่อต้านอากาศยาน" | mkA "ปืนใหญ่ต่อสู้อากาศยาน" | mkA "ที่ใช้ต่อสู้กับเครื่องบินรบ" ; -- src=panlex
lin anti_aircraft_N = mkN "ปืนต่อสู้อากาศยาน" | mkN "ต่อต้านอากาศยาน" | mkN "ปืนใหญ่ต่อสู้อากาศยาน" ; -- src=panlex
lin antiapartheid_A = mkA "ซึ่งต่อต้านนโยบายแบ่งแยกสีผิว" ; -- src=panlex
lin antiarrhythmic_N = mkN "ยาแอนติอะริทึมมิก" ; -- src=panlex
lin antiauthoritarian_A = mkA "ที่ต่อต้านอำนาจนิยม" ; -- src=panlex
lin antibacterial_A = mkA "ซึ่งทำลายแบคทีเรีย" | mkA "ซึ่งต้านฤทธิ์ของแบคทีเรีย" ; -- src=panlex
lin antibacterial_N = mkN "ยาฆ่าเชื้อแบคทีเรีย" | mkN "ยาหรือสารที่ต้านฤทธิ์ของแบคทีเรีย" ; -- src=panlex
lin antibaryon_N = mkN "แอนติแบริออน" ; -- src=panlex
lin antibiosis_N = mkN "ปฏิชีวภาพ" ; -- src=panlex
lin antibiotic_A = mkA "ที่เป็นสารปฏิชีวนะ" | mkA "ที่หยุดยั้งการเติบโตของแบคทีเรียหรือเชื้อโรคอื่นๆ" ; -- src=panlex
lin antibiotic_N = mkN "ยาปฏิชีวนะ" | mkN "ยาปฏิชีวนะ" | mkN "ยาที่มีฤทธิ์หยุดยั้งการเติบโตของเชื้อโรค" ; -- src=panlex
lin antibody_N = mkN "แอนติบอดี" | mkN "สารภูมิต้านทาน" | mkN "โปรตีนต่อต้านเชื้อโรคในร่างกาย" ; -- src=panlex
lin antic_A = mkA "ตัวตลก" | mkA "วิตถาร" | mkA "เหมือนตัว ตลก" | mkA "การเล่นตลก" | mkA "แปลกและน่าขบขัน" | mkA "พฤติการตลกหรือวิตถาร" ; -- src=panlex
lin antic_N = mkN "ตัวตลก" | mkN "วิตถาร" | mkN "เหมือนตัว ตลก" | mkN "การเล่นตลก" | mkN "พฤติการตลกหรือวิตถาร" ; -- src=panlex
lin anticancer_A = mkA "ซึ่งใช้รักษามะเร็ง" ; -- src=panlex
lin anticatalyst_N = mkN "สารหน่วงตัวเร่งปฏิกิริยา" ; -- src=panlex
lin anticholinergic_N = mkN "แอนติโคลิเนอร์จิก" ; -- src=panlex
lin anticholinesterase_N = mkN "ยาแอนติโคลิเนสเตอเรส" ; -- src=panlex
lin anticipant_A = mkA "ที่คาดการณ์ไว้" ; -- src=panlex
lin anticipate_V = mkV "ทาย" | mkV "กังวล" | mkV "ทำนาย" | mkV "คาดหวัง" | mkV "ดักหน้า" | mkV "ตัดหน้า" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "รู้ล่วงหน้า" | mkV "คอย" | mkV "คะเน" | mkV "คอยท่า" | mkV "ทํานาย" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "เตรียมป้องกันล่วงหน้า" | mkV "ลงมือกระทําก่อนล่วงหน้า" ; -- src=panlex
lin anticipate_V2 = mkV2 "ทาย" ; ---- | mkV "กังวล" | mkV "ทำนาย" | mkV "คาดหวัง" | mkV "ดักหน้า" | mkV "ตัดหน้า" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "รู้ล่วงหน้า" | mkV "คอย" | mkV "คะเน" | mkV "คอยท่า" | mkV "ทํานาย" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "เตรียมป้องกันล่วงหน้า" | mkV "ลงมือกระทําก่อนล่วงหน้า" ; -- src=panlex
lin anticipate_VS = mmkVS "ทาย" ; ---- | mkV "กังวล" | mkV "ทำนาย" | mkV "คาดหวัง" | mkV "ดักหน้า" | mkV "ตัดหน้า" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "รู้ล่วงหน้า" | mkV "คอย" | mkV "คะเน" | mkV "คอยท่า" | mkV "ทํานาย" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "เตรียมป้องกันล่วงหน้า" | mkV "ลงมือกระทําก่อนล่วงหน้า" ; -- src=panlex
lin anticipate_VV = mkVV "ทาย" ; ---- | mkV "กังวล" | mkV "ทำนาย" | mkV "คาดหวัง" | mkV "ดักหน้า" | mkV "ตัดหน้า" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "สังหรณ์ใจ" | mkV "รู้ล่วงหน้า" | mkV "คอย" | mkV "คะเน" | mkV "คอยท่า" | mkV "ทํานาย" | mkV "คาดคะเน" | mkV "คาดหมาย" | mkV "คาดหวัง" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "เตรียมป้องกันล่วงหน้า" | mkV "ลงมือกระทําก่อนล่วงหน้า" ; -- src=panlex
lin anticipation_N = mkN "การทำนาย" | mkN "การตั้งตารอ" | mkN "การรอคอยอย่างคาดหวัง" ; -- src=panlex
lin anticlimactic_A = mkA "ถึงจุดแอนตี้ไคลแมกซ์" ; -- src=panlex
lin anticlimax_N = mkN "การเสแสร้งสงสารหรือเห็นใจมากเกินไป" | mkN "เหตุการณ ์" | mkN "เหตุการณ์ที่ลดความสําคัญอย่างกะทันหัน" ; -- src=panlex
lin anticlinal_A = mkA "ลาดลง" | mkA "ลาดลงทั้งสองข้างจากแกนกลาง" ; -- src=panlex
lin anticlockwise_Adv = mkAdv "ทวนเข็มนาฬิกา" ; -- src=panlex
lin anticoagulant_N = mkN "สารหรือยาที่มีฤทธิ์ดังกล่าว" | mkN "ซึ่งต้านการจับเป็นก้อนหรือลิ่มของเลือด" | mkN "ยาหรือสารซึ่งต้านการจับตัวเป็นก้อนของเลือด" ; -- src=panlex
lin anticoagulative_A = mkA "เกียวกับสารต้านการจับตัวเป็นเลือด" ; -- src=panlex
lin antics_N = mkN "ลักษณะ" ; -- src=panlex
lin anticyclone_N = mkN "บริเวณที่ความกดอากาศสูงและมีลมแรงพัดออกมา" ; -- src=panlex
lin anticyclonic_A = mkA "เกี่ยวกับบรรยากาศรอบศูนย์กลางความดัน" ; -- src=panlex
lin antidepressant_N = mkN "ยาต้านอารมณ์เศร้า" | mkN "ยาต้านอาการเศร้าซึม" ; -- src=panlex
lin antidiabetic_N = mkN "ยาแอนตี้ไดอะเบติก" | mkN "ยาป้องกันหรือบรรเทาอาการโรคเบาหวาน" ; -- src=panlex
lin antidiarrheal_N = mkN "ยาแก้ท้องเสีย" ; -- src=panlex
lin antidiuretic_N = mkN "แอนติไดยูเรติก" | mkN "ยาแอนติไดยูเรติก" | mkN "ยดลดการขับปัสสาวะ" | mkN "ซึ่งลดการบับปัสสาวะ" ; -- src=panlex
lin antidotal_A = mkA "ซึ่งถอนพิษ" ; -- src=panlex
lin antidote_N = mkN "ยาถอนพิษ" | mkN "ยาแก้พิษ" | mkN "ยาต้านพิษ" ; -- src=panlex
lin antiemetic_N = mkN "ยาแก้อาเจียน" | mkN "ยาแก้คลื่นไส้" | mkN "ยาแก้อาเจียน" ; -- src=panlex
lin antiferromagnetism_N = mkN "สภาพแม่เหล็กแอทนไทเฟอร์ไร" ; -- src=panlex
lin antiflatulent_N = mkN "แอนตี้ฟลาตูเลนต์" ; -- src=panlex
lin antifreeze_N = mkN "สารต้านการเยือกแข็ง" | mkN "สารต้านการเยือกแข็ง" | mkN "ของเหลวที่ต้านการแข็งตัวของน้ํา" ; -- src=panlex
lin antifungal_N = mkN "ยาฆ่าเชื้อรา" | mkN "ยาฆ่้าเชื้อรา" | mkN "ยากำจัดเชื้อรา" | mkN "ซึ่งต้านเชื้อรา" | mkN "สารหรือยาต้านเชื้อรา" ; -- src=panlex
lin antigen_N = mkN "แอนติเจน" | mkN "แอนติเจน" | mkN "สารที่กระตุ้นการสร้างแอนติบอดี้" ; -- src=panlex
lin antigenic_A = mkA "เกี่ยวกับแอนตี้เจน" ; -- src=panlex
lin anti_hero_N = mkN "ตัวเอกปฏิลักษณ์" ; -- src=panlex
lin antihistamine_N = mkN "ยาต้านฮิสตามีน" | mkN "ยาแอนติฮิสตามีน" ; -- src=panlex
lin antihypertensive_N = mkN "ยาลดความดันโลหิต" ; -- src=panlex
lin antiknock_A = mkA "สารที่มีฤทธิ์ดังกล่าว" | mkA "กันการระเบิดสะเทือนของเครื่องยนต์" ; -- src=panlex
lin antiknock_N = mkN "สารกันน็อก" | mkN "สารที่มีฤทธิ์ดังกล่าว" | mkN "กันการระเบิดสะเทือนของเครื่องยนต์" | mkN "สารที่เติมในเชื้อเพลิงเพื่อลดเสียงระเบิดของเครื่องยนต์" ; -- src=panlex
lin antilogarithm_N = mkN "แอนติลอการิทึม" ; -- src=panlex
lin antimacassar_N = mkN "ผ้าหุ้มเก้าอี้" | mkN "ผ้าสําหรับคลุมที่พิงหลังเพื่อกันเปื้อน" ; -- src=panlex
lin antimagnetic_A = mkA "ซึ่งป้องกันสนามแม่เหล็ก" | mkA "ซึ่งต้านสนามแม่เหล็ก" ; -- src=panlex
lin antimalarial_N = mkN "ยาต้านเชื้อมาเลเรีย" ; -- src=panlex
lin antimatter_N = mkN "สสารตรงข้าม" ; -- src=panlex
lin antimeson_N = mkN "แอนติมีซอน" ; -- src=panlex
lin antimetabolite_N = mkN "แอนติมีทาโบไลต์" ; -- src=panlex
lin antimonic_A = mkA "ซึ่งมาจากแอนติโมนี" | mkA "ประกอบหรือผสมด้วยพลวง" | mkA "สารผสมหรือสารประกอบพลวง" ; -- src=panlex
lin antimony_N = mkN "พลวง" | mkN "ธาตุพลวง" | mkN "เลขอะตอม 51" | mkN "พลวง" ; -- src=panlex
lin antimycin_N = mkN "แอนติไมซิน" ; -- src=panlex
lin antineoplastic_N = mkN "ยารักษามะเร็ง" ; -- src=panlex
lin antineutrino_N = mkN "แอนตินิวตริโน" | mkN "อนุภาคต้าน" ; -- src=panlex
lin antineutron_N = mkN "แอนตินิวตรอน" ; -- src=panlex
lin antinode_N = mkN "ปฏิพับ" | mkN "จุดปฏิบัพ" ; -- src=panlex
lin antinomianism_N = mkN "ปฏิบัญญัตินิยม" ; -- src=panlex
lin antinomy_N = mkN "ความขัดแย้งกันระหว่างกฎหรือหลักการ" ; -- src=panlex
lin antioxidant_N = mkN "แอนติออกซิแดนท์" ; -- src=panlex
lin antiparallel_A = mkA "ที่ขนานสวน" ; -- src=panlex
lin antiparticle_N = mkN "ปฏิยานุภาค" | mkN "อนุภาคตรงข้าม" | mkN "อนุภาคที่ทําลายกันเองเมื่อปะทะกัน เช่น อิเล็กตรอนและโปรตอน" ; -- src=panlex
lin antipasto_N = mkN "อันตีปัสโต" | mkN "แอนติพาสโต" | mkN "ชนิดของเครื่องแต่งกลิ่นปรุงรส" ; -- src=panlex
lin antipathetic_A = mkA "ที่แย้งกัน" | mkA "ที่ตรงกันข้าม" ; -- src=panlex
lin antipathy_N = mkN "ความไม่ชอบ" | mkN "ความเกลียดชัง" | mkN "การแตกร้าว" | mkN "ความชิงชัง" | mkN "ความเกลียด" | mkN "ความไม่พอใจ" | mkN "ความไม่ลงรอย" | mkN "ความเกลียดชัง" | mkN "ความเป็นศัตรู" | mkN "สิ่งที่ไม่ชอบ" | mkN "สิ่งที่ไม่ลงรอย" | mkN "สิ่งที่เกลียดชัง" | mkN "ความเกลียดชังอย่างมาก" ; -- src=panlex
lin anti_personnel_A = mkA "ใช้ต่อต้านหรือทําลายคน" | mkA "ใช้ต่อต้านหรือทําลายคน ชนิดระเบิดสังหาร" ; -- src=panlex
lin antiperspirant_N = mkN "ยาลดการขับเหงื่อ" | mkN "ยาลดการขับเหงื่อ" ; -- src=panlex
lin antiphlogistic_A = mkA "ต้านการอักเสบ" | mkA "ที่ต้านการอักเสบ" ; -- src=panlex
lin antiphon_N = mkN "แอนติฟอน" | mkN "เพลงสวดแอนติฟอน" | mkN "เพลงที่ร้องโต้ตอบ" | mkN "โคลงกลอนนําหรือส่งท้าย" | mkN "เพลงหรือโคลงกลอนที่ร้องตอบ" ; -- src=panlex
lin antiphonary_A = mkA "คล้ายเพลงแอนติโฟน" | mkA "คล้ายเพลงแอนตี้โฟน" ; -- src=panlex
lin antiphonary_N = mkN "การโต้สลับแบบกลุ่ม" ; -- src=panlex
lin antiphony_N = mkN "แอนติฟอน" | mkN "เพลงสวดแอนติฟอน" | mkN "การขับร้องสลับกัน" | mkN "โคลงกลอนที่ร้องสลับกัน" | mkN "การขับร้องสลับกันในหมู่นักร้อง" ; -- src=panlex
lin antiphrasis_N = mkN "การใช้คําที่มีความหมายตรงข้าม" ; -- src=panlex
lin antipodal_A = mkA "ที่อยู่คนละด้าน" | mkA "ตรงกันข้ามพอดี" | mkA "ตรงกันข้ามกับเท้า" | mkA "บนด้านตรงข้ามของทรงกลม" ; -- src=panlex
lin antipode_N = mkN "ขั้วตรงข้าม" | mkN "สิ่งที่ตรงกันข้ามกัน" | mkN "สิ่งหรือส่วนที่ตรงกันข้ามพอดี" ; -- src=panlex
lin antipodes_N = mkN "จุดแอนติโพด" | mkN "สถานที่ 2 แห่งที่อยู่ด้านตรงข้ามกันบนโลก" ; -- src=panlex
lin antipollution_A = mkA "ซึ่งลดมลภาวะ" ; -- src=panlex
lin antipope_N = mkN "พระสันตะปาปาเท็จ" | mkN "ผู้ที่อ้างเป็นสันตะปาปา" ; -- src=panlex
lin antiproton_N = mkN "แอนติโปรตอน" | mkN "อนุภาคด้านของโปรตอน" ; -- src=panlex
lin antiprotozoal_N = mkN "ยาต้านเชื้อโปรโตซัว" ; -- src=panlex
lin antipyretic_A = mkA "ซึ่งลดไข้" | mkA "ลดไข้" | mkA "ซึ่งลดไข้" ; -- src=panlex
lin antipyretic_N = mkN "ลดไข้" | mkN "ยาลดไข้" ; -- src=panlex
lin antiquarian_A = mkA "เกี่ยวกับโบราณวัตถุ" | mkA "เกี่ยวกับผู้ศึกษาโบราณวัตถุ" | mkA "เกี่ยวกับโบราณวัตถุ" | mkA "เกี่ยวกับการศึกษาโบราณวัตถุ" ; -- src=panlex
lin antiquarian_N = mkN "นักสะสมโบราณวัตถุ" | mkN "ผู้ศึกษาโบราณวัตถุ" ; -- src=panlex
lin antiquark_N = mkN "แอนติควอร์ก" | mkN "แอนติควาร์ก" ; -- src=panlex
lin antiquary_N = mkN "นักสะสมโบราณวัตถุ" | mkN "ผู้สะสมโบราณวัตถุ" | mkN "ผู้ชํานาญหรือศึกษาทางโบราณวัตถุ" ; -- src=panlex
lin antiquated_A = mkA "ชรา" | mkA "โบราณ" | mkA "ล้าสมัย" | mkA "เก่าแก่" ; -- src=panlex
lin antique_A = mkA "โบราณ" | mkA "เก่าแก่" | mkA "โบราณ" | mkA "เก่าแก่" | mkA "ซึ่งเป็นของโบราณ" | mkA "ซึ่งทําในสมัยโบราณ" ; -- src=panlex
lin antique_N = mkN "คนแก่" | mkN "ของเก่า" | mkN "ผู้เฒ่า" | mkN "โบราณวัตถุ" | mkN "ของโบราณ" | mkN "โบราณวัตถุ" | mkN "ศิลปสมัยโบราณ" ; -- src=panlex
lin antiquity_N = mkN "ของโบราณ" | mkN "วัตถุโบราณ" | mkN "ความเก่าแก่" | mkN "ขนบ ธรรม เนียม" | mkN "เผ่า" | mkN "ยุคโบราณ" | mkN "ความโบราณ" | mkN "สมัยโบราณ" | mkN "ประเพณีและอื่น" | mkN "บรรดาความโบราณทั้งหลาย (คน" | mkN "ช่วงเวลาในประวัติศาสตร์" ; -- src=panlex
lin antisatellite_A = mkA "เกี่ยวกับระบบต่อต้านดาวเทียม" ; -- src=panlex
lin antisepsis_N = mkN "การป้องกันเชื้อโรค" | mkN "การทําให้ปราศจากเชื้อจุลินทรีย์" ; -- src=panlex
lin antiseptic_A = mkA "แอนตี้เซปติก" | mkA "สารหรือ ยาที่มีฤทธิ์ดังกล่าว" | mkA "ซึ่งฆ่าเชื้อโรค" | mkA "ที่ปราศจากเชื้อโรค" | mkA "ซึ่งควบคุมการติดต่อของโรค" ; -- src=panlex
lin antiseptic_N = mkN "สารหรือ ยาที่มีฤทธิ์ดังกล่าว" | mkN "ยาฆ่าเชื้อโรค" ; -- src=panlex
lin antiserum_N = mkN "ซีรัมที่มีแอนติบอดี้มีภูมิคุ้มกันโรค" ; -- src=panlex
lin antisocial_A = mkA "ต่อต้านสังคม" | mkA "ที่ต่อต้านสังคม" | mkA "เบื่อหน่ายสังคม" | mkA "ซึ่งไม่เข้าสังคม" | mkA "ซึ่งไม่สังคมกับใคร" | mkA "ที่หลีกเลี่ยงการมีความสัมพันธ์กับผู้อื่น" ; -- src=panlex
lin antispasmodic_N = mkN "ยาแก้เกร็ง" ; -- src=panlex
lin antisubmarine_A = mkA "ซึ่องต่อต้านเรือดำน้ำ" | mkA "ซี่งต่อต้านหรือทําลายเรือดําน้ํา" ; -- src=panlex
lin antisyphilitic_N = mkN "ยาต้านซิฟิลิส" ; -- src=panlex
lin antitank_A = mkA "ซึ่งต่อต้านรถถัง" | mkA "ใช้ต่อสู้กับรถถัง" | mkA "ต่อต้านหรือทําลายรถถังหรือรถหุ้มเกราะ" ; -- src=panlex
lin antithesis_N = mkN "บทแย้ง" | mkN "การใช้ถ้อยคําขัดแย้งกัน" | mkN "สิ่งที่ตรงกันข้ามอย่างสิ้นเชิง" | mkN "ผู้ที่อยู่ตรงกันข้ามอย่างสิ้นเชิง" ; -- src=panlex
lin antithyroid_A = mkA "แอนตี้ไทรอยด์" ; -- src=panlex
lin antitoxin_N = mkN "ภูมิต้านพิษ" | mkN "สารหรือยาต้านพิษเฉพาะอย่าง" ; -- src=panlex
lin antitrade_N = mkN "ลมทวนลมค้า" | mkN "ลมที่พัดเหนือลม" ; -- src=panlex
lin antitrades_N = mkN "ลมที่พัดเหนือลมสินค้าบนแถบร้อนชื้นของโลก" ; -- src=panlex
lin antitussive_N = mkN "ยาแก้ไอ" | mkN "ยาแก้ไอ" | mkN "ยาบรรเทาการไอ" | mkN "ซึ่งบรรเทาการไอ" ; -- src=panlex
lin antivenin_N = mkN "สารต้านพิษงูในเลือด" | mkN "ซีรัมที่มีสารต้านพิษงูดังกล่าว" ; -- src=panlex
lin antiviral_A = mkA "ซึ่งยับยั้งการเจริญเติบโตของไวรัส" | mkA "ยาต้านเชื้อไวรัส" | mkA "ซึ่งต้านเชื้อไวรัส" ; -- src=panlex
lin antiviral_N = mkN "ยาต้านไวรัส" | mkN "ยาต้านเชื้อไวรัส" | mkN "ซึ่งต้านเชื้อไวรัส" ; -- src=panlex
lin antler_N = mkN "เขากวาง" | mkN "เขากวาง" ; -- src=panlex
lin antlered_A = mkA "ที่มีเขากวาง" ; -- src=panlex
lin antonym_N = mkN "คำตรงข้าม" | mkN "คําที่มีความหมายตรงกันข้าม" ; -- src=panlex
lin antonymous_A = mkA "ที่มีความหมายตรงข้าม" ; -- src=panlex
lin antonymy_N = mkN "ความหมายตรงข้าม" ; -- src=panlex
lin antrorse_A = mkA "ซึ่งโค้งขึ้น" | mkA "งอไปข้างหน้าหรือขึ้นข้างบน" ; -- src=panlex
lin antrum_N = mkN "แอนทรัม" | mkN "โพรงในกระดูก" ; -- src=panlex
lin anuran_A = mkA "เกี่ยวกับสัตว์จำพวกกบ" ; -- src=panlex
lin anuresis_N = mkN "ภาวะไร้ปัสสาวะ" ; -- src=panlex
lin anuretic_A = mkA "ซึ่งปัสสาวะขัด" ; -- src=panlex
lin anurous_A = mkA "ที่ไม่มีหาง" | mkA "ไร้หาง" ; -- src=panlex
lin anus_N = mkN "เวจมรรค" | mkN "ทวารหนัก" | mkN "ทวารหนัก" | mkN "ช่องทวารหนัก" ; -- src=panlex
lin anvil_N = mkN "ทั่ง" | mkN "กระดูกทั่ง" | mkN "ทั่ง" | mkN "ทั่งตีเหล็ก" | mkN "กระดูกรูปทั่งในหูชั้นกลาง" ; -- src=panlex
lin anxiety_N = mkN "อาการวิตกกังวล" | mkN "ความวิตก" | mkN "ความกลุ้ม" | mkN "ความกังวล" | mkN "ความห่วงใย" | mkN "ความกระตือ รือร้น" | mkN "ความกลุ้มใจ" | mkN "ความวิตกกังวล" | mkN "ความเป็นทุกข์" | mkN "เรื่องน่าห่วง" | mkN "สิ่งที่ทําให้กังวล" ; -- src=panlex
lin anxiolytic_A = mkA "ซึ่งผ่อนคลายความกังวล" ; -- src=panlex
lin anxious_A = mkA "ห่วงใย" | mkA "กังวลใจ" | mkA "ที่วิตก" | mkA "น่าห่วง" | mkA "ช่างวิตก" | mkA "ที่กังวล" | mkA "ที่ร้อนใจ" | mkA "ที่วิตกกังวล" | mkA "ที่กระวนกระวาย" | mkA "ที่ทําให้เกิดความกลัว" | mkA "ที่ทําให้เกิดความกังวล" | mkA "ที่เต็มไปด้วยความกังวล" ; -- src=panlex
lin anxiousness_N = mkN "อาการวิตกกังวล" | mkN "ความกระวนกระวาย" ; -- src=panlex
lin any_Adv = mkAdv "ใด ๆ" | mkAdv "ทุก" | mkAdv "เลย" | mkAdv "ใคร" | mkAdv "ไหน" | mkAdv "บ้าง" | mkAdv "ทั้งหมด" | mkAdv "ใครก็ได้" | mkAdv "คนหนึ่งคนใด" | mkAdv "สักเล็กน้อย" ; -- src=panlex
lin anyhow_Adv = mkAdv "อย่างไรก็ตาม" | mkAdv "ไม่ว่าด้วยวิธีใดก็ตาม" | mkAdv "กรณีใด ๆ" | mkAdv "ในทุกๆ กรณี" | mkAdv "กรณีใดๆ" | mkAdv "อย่างไรก็ตาม" | mkAdv "ไม่ว่ากรณีใดก็ตาม" | mkAdv "อย่างไม่ระมัดระวัง" ; -- src=panlex
lin anymore_Adv = mkAdv "ตั้งแต่เดี๋ยวนี้" | mkAdv "อีก" | mkAdv "อีกต่อไป" ; -- src=panlex
lin anyplace_Adv = mkAdv "ทุกแห่ง" | mkAdv "ที่ไหนก็ตาม" | mkAdv "ที่ไหนก็ตาม" | mkAdv "ทุกหนทุกแห่ง" ; -- src=panlex
lin anyway_Adv = mkAdv "อย่างไรก็ตาม" | mkAdv "ไม่ว่าด้วยวิธีใดก็ตาม" | mkAdv "ถึงอย่างไร" | mkAdv "นอกจากนั้น" | mkAdv "อย่างไรก็ตาม" ; -- src=panlex
lin anywhere_Adv = mkAdv "ทุกแห่ง" | mkAdv "ที่ไหนก็ตาม" | mkAdv "ไหน ๆ" | mkAdv "ทุกแห่ง" | mkAdv "ที่ใดก็ตาม" | mkAdv "ที่ไหนก็ตาม" | mkAdv "ไม่ว่าที่ใด" ; -- src=panlex
lin aorist_N = mkN "กาลกริยาในไวยากรณ์" | mkN "กาลกริยาในไวยากรณ์" ; -- src=panlex
lin aoristic_A = mkA "ไม่แน่นอน" ; -- src=panlex
lin aorta_N = mkN "หลอดเลือดแดงใหญ่เออาร์ตา" | mkN "เส้นเลือดใหญ่ที่นําเลือดออกจากหัวใจด้านซ้าย" ; -- src=panlex
lin aortal_A = mkA "เกี่ยวกับเส้นเลือดหัวใจด้านซ้าย" ; -- src=panlex
lin apace_Adv = mkAdv "โดยด่วน" | mkAdv "อย่างรวดเร็ว" | mkAdv "เร็ว" | mkAdv "รวดเร็ว" | mkAdv "อย่างเร็ว" | mkAdv "ด้วยความเร็ว" ; -- src=panlex
lin apache_N = mkN "อาปาเช่" | mkN "นักเลงหรืออันธพาลในปารีส" ; -- src=panlex
lin apadana_N = mkN "อพาดานา" ; -- src=panlex
lin apart_Adv = mkAdv "แยกจาก" | mkAdv "เป็นชิ้นๆ" | mkAdv "โดยไม่พิจารณา" | mkAdv "แยกจาก" | mkAdv "ต่างหาก" | mkAdv "เป็นส่วนๆ" | mkAdv "คนละต่างหาก" | mkAdv "โดยไม่พิจารณา" ; -- src=panlex
lin apartheid_N = mkN "การแบ่งผิว" | mkN "การแบ่งแยกชนชาติ" ; -- src=panlex
lin apartment_N = mkN (thword "ห้อง" "เช่า")"ห้อง" | {-pan-} mkN "แฟลต" | mkN "อพาร์ทเมนท์" | mkN "ห้อง" | mkN "ห้องชุด" | mkN "ห้องเช่า" | mkN "อพาร์ทเมนท์" | mkN "ห้องชุดในโรงแรม" | mkN "อาคารที่มีห้องชุด" | mkN "อาคารที่มีห้องให้เช่า" ; -- src=panlex
lin apathetic_A = mkA "ไม่แยแส" | mkA "เฉื่อยชา" | mkA "ที่ไม่กระตือรือร้น" | mkA "สนใจหรือมีความเป็นห่วงน้อย" | mkA "มีหรือแสดงอารมณ์เล็กน้อยหรือไม่มีอารมณ์" ; -- src=panlex
lin apathy_N = mkN "ความไม่ เป็นห่วง" | mkN "ความไม่สนใจ" | mkN "การไร้อารมณ์" | mkN "การขาดความสนใจ" | mkN "การขาดความกระตือรือร้น" ; -- src=panlex
lin apatite_N = mkN "อะพาไทต์" | mkN "แร่อะพาไทต์" ; -- src=panlex
lin apatosaur_N = mkN "อะปาโตซอรัส" ; -- src=panlex
lin ape_N = mkN "มนุษย์วานร" | mkN "นักเลียนแบบ" | mkN "คนชอบเลียนแบบ" | mkN "วานร" | mkN "ผู้เลียนแบบ" | mkN "ผู้เอาอย่าง" | mkN "ลิงไม่มีหาง" | mkN "ลิงไร้หางหรือมีหางสั้น" ; -- src=panlex
lin aperient_A = mkA "ถ่าย" | mkA "ระบาย" | mkA "ที่ถ่ายออกมา" | mkA "ที่ระบายออกมา" | mkA "ที่อุจจาระออกมา" | mkA "ที่ถ่ายเป็นอุจจาระ" | mkA "ยาระบายหรืออาหารที่เป็นยาระบาย" ; -- src=panlex
lin aperient_N = mkN "ยาถ่าย" | mkN "ยาระบาย" | mkN "ถ่าย" | mkN "ระบาย" | mkN "ยาระบายหรืออาหารที่เป็นยาระบาย" ; -- src=panlex
lin aperiodic_A = mkA "เป็นช่วงๆ" | mkA "เป็นช่วง ๆ" | mkA "ไม่เป็นระยะ" | mkA "ที่เกิดขึ้นไม่สม่ําเสมอ" ; -- src=panlex
lin aperitif_N = mkN "แอพเพอริทิฟ" | mkN "การดื่มเหล็กเล็กน้อยเพื่อเจริญอาหาร" | mkN "การดื่มเหล้าเล็กน้อยเพื่อช่วยให้เจริญอาหาร" ; -- src=panlex
lin aperture_N = mkN "รู" | mkN "ช่อง" | mkN "เส้นผ่าศูนย์กลางของรู" | mkN "เส้นผ่าศูนย์กลางของช่อง" ; -- src=panlex
lin apery_N = mkN "การเลียนแบบ" | mkN "การกระทําที่งี่เง่า" ; -- src=panlex
lin apetalous_A = mkA "ไร้กลีบดอก" | mkA "ซึ่งไม่มีกลีบ" | mkA "ไร้กลีบดอก" ; -- src=panlex
lin apex_N = mkN "จุดยอด" | mkN "โซล่าร์ เอเพกซ์" | mkN "จุดสูงสุด" | mkN "ทิศทางที่ดวงอาทิตย์เคลื่อนไปในอวกาศระหว่างดาว" | mkN "ปลายยอด" | mkN "ปลายสุด" | mkN "จุดสุดยอด" | mkN "จุดสูงสุด" ; -- src=panlex
lin aphaeresis_N = mkN "การละพยางค์หน้า" ; -- src=panlex
lin aphagia_N = mkN "อาการกลืนไม่ลง" ; -- src=panlex
lin aphakia_N = mkN "สภาพไร้แก้วตา" ; -- src=panlex
lin aphakic_N = mkN "ผู้ไม่มีเลนส์ตา" ; -- src=panlex
lin aphanite_N = mkN "หินอัคนีสีอ่อน" ; -- src=panlex
lin aphasia_N = mkN "โรคพูดไม่ได้" ; -- src=panlex
lin aphasic_A = mkA "เอฟาเซีย" | mkA "ซึ่งพูดไม่ได้" ; -- src=panlex
lin aphasic_N = mkN "ผู้ป่วยโรคอะฟาเซีย" ; -- src=panlex
lin aphelion_N = mkN "จุดอะฟีเลียน" | mkN "จุดไกลดวงอาทิตย์ที่สุด" | mkN "จุดไกลสุดของดาวหางหรือดาวนพเคราะห์ที่อยู่ห่างจากพระอาทิตย์" ; -- src=panlex
lin apheresis_N = mkN "การละพยางค์หน้า" | mkN "การงดออกเสียงในพยางค์แรกของคํา" ; -- src=panlex
lin aphesis_N = mkN "การละเสียงสระต้นคำ" ; -- src=panlex
lin aphid_N = mkN "เพลี้ย" | mkN "เพลี้ยอ่อน" | mkN "แมลงชนิดหนึ่งที่ดูดน้ําเลี้ยงจากต้นหรือใบของพืช" ; -- src=panlex
lin aphonia_N = mkN "เสียงแหบ" | mkN "เสียงแห้ง" ; -- src=panlex
lin aphorism_N = mkN "คติพจน์" | mkN "คําพังเพย" ; -- src=panlex
lin aphorist_N = mkN "ผู้ที่เขียนหรือพูดเป็นคติพจน์หรือคําพังเพย" ; -- src=panlex
lin aphoristic_A = mkA "ที่เป็นความจริง" ; -- src=panlex
lin aphotic_A = mkA "มืด" | mkA "ไร้แสง" ; -- src=panlex
lin aphrodisia_N = mkN "ความต้องการทางเพศ" | mkN "กําหนัด" | mkN "ความต้องการทางเพศ" ; -- src=panlex
lin aphrodisiac_A = mkA "ซึ่งเร้าความรู้สึกทางเพศ" | mkA "ซึ่งกระตุ้นกําหนัด" | mkA "ยาหรือสารกระตุ้นกําหนัด" | mkA "ซึ่งกระตุ้นความต้องการทางเพศ" ; -- src=panlex
lin aphrodisiac_N = mkN "ยาปลุกเซ็กส์" | mkN "ยาเร้ากำหนัด" | mkN "ซึ่งกระตุ้นกําหนัด" | mkN "ยาหรือสารกระตุ้นกําหนัด" | mkN "ยาหรือสารกระตุ้นความต้องการทางเพศ" ; -- src=panlex
lin aphyllous_A = mkA "ที่ไม่มีใบ" | mkA "ที่ไร้ใบ" ; -- src=panlex
lin apian_A = mkA "เกี่ยวกับผึ้ง" | mkA "เกี่ยวกับผึ้ง" ; -- src=panlex
lin apiarian_A = mkA "เกี่ยวกับผึ้ง" | mkA "เกี่ยวกับการเลี้ยงผึ้ง" | mkA "เกี่ยวกับผึ้งหรือการเลี้ยงผึ้ง" ; -- src=panlex
lin apiarist_N = mkN "คนเลี้ยงผึ้ง" | mkN "เกษตรกรผู้เลี้ยงผึ้ง" | mkN "ผู้ที่เลี้ยงผึ้ง" ; -- src=panlex
lin apiary_N = mkN "โรงเลี้ยงผึ้ง" | mkN "ที่เลี้ยงผึ้ง" | mkN "สถานที่ที่เลี้ยงผึ้ง" ; -- src=panlex
lin apical_A = mkA "ยอด" | mkA "สุด" | mkA "ปลาย" | mkA "ใช้ปลายลิ้นเปล่งเสียงออกมา" ; -- src=panlex
lin apiculate_A = mkA "มีติ่งเล็กเรียวแหลม" ; -- src=panlex
lin apicultural_A = mkA "เกี่ยวกับการเลี้ยงผึ้ง" ; -- src=panlex
lin apiculture_N = mkN "การเลี้ยงผึ้ง" | mkN "การเลี้ยงผึ้ง" ; -- src=panlex
lin apiece_Adv = mkAdv "แต่ละ" | mkAdv "อันละ" | mkAdv "แต่ละ" | mkAdv "ชิ้นละ" ; -- src=panlex
lin apish_A = mkA "เลียนแบบคน" | mkA "คล้ายมนุษย์หรือลิงไม่มีหาง" | mkA "คล้ายมนุษย์วานรหรือลิงไม่มีหาง" ; -- src=panlex
lin apishamore_N = mkN "อานเอพิชามอร์" | mkN "อานม้าเอพิชามอร์" ; -- src=panlex
lin apivorous_A = mkA "ที่กินผึ้งเป็นอาหาร" ; -- src=panlex
lin aplacental_A = mkA "ที่ไม่มีรก" | mkA "ไม่มีรก" ; -- src=panlex
lin aplanatic_A = mkA "ไม่มีการบ่ายบนทางทรงกรมหรือสี" ; -- src=panlex
lin aplasia_N = mkN "การไร้อวัยวะหรือเนื้อเยื่อแต่กําเนิด" ; -- src=panlex
lin aplite_N = mkN "หินแอพไลต์" ; -- src=panlex
lin aplomb_N = mkN "ความเยือกเย็น" | mkN "ความสุขุม" | mkN "ความมั่นใจ" | mkN "ความปราศจากความประหม่า" ; -- src=panlex
lin apnea_N = mkN "การหยุดหายใจ" | mkN "ภาวะหอบ" | mkN "ภาวะหยุดหายใจชั่วคราว" ; -- src=panlex
lin apneic_A = mkA "ซึ่งหยุดหายใจชั่วคราว" ; -- src=panlex
lin apoapsis_N = mkN "อะโพแอปซิส" | mkN "จุดโคจรไกลสุดจากดาวเคราะห์" ; -- src=panlex
lin apocalyptic_A = mkA "เกี่ยวกับบันทึกทางศาสนาของยิว" ; -- src=panlex
lin apocrine_A = mkA "ซึ่งผลิตสารหลั่ง" ; -- src=panlex
lin apocryphal_A = mkA "ปลอม" | mkA "เทียม" | mkA "น่าสงสัย" ; -- src=panlex
lin apocynaceous_A = mkA "อะโพคีเนเซีย" ; -- src=panlex
lin apodal_A = mkA "ที่ไม่มีเท้าตามธรรมชาติ" | mkA "ที่ไม่มีขาหรือเท้า" ; -- src=panlex
lin apodeme_N = mkN "แผ่นยึดกล้ามเนื้อรยางค์" ; -- src=panlex
lin apodictic_A = mkA "ไม่เป็นที่สงสัย" ; -- src=panlex
lin apoenzyme_N = mkN "แอโพเอนไซม์" ; -- src=panlex
lin apogamic_A = mkA "เกี่ยวพัฒนาการของเอมบริโอ" ; -- src=panlex
lin apogamy_N = mkN "แอโพแกมี" ; -- src=panlex
lin apogean_A = mkA "เกี่ยวกับจุดไกลที่สุดที่อยู่ห่างจากโลก" ; -- src=panlex
lin apogee_N = mkN "อะโปจี" | mkN "จุดไกลสุดของดาวนพเคราะห์หรืออื่น ๆ ที่อยู่ห่างจากโลก" ; -- src=panlex
lin apolitical_A = mkA "ไม่ใช่การเมือง" | mkA "ไม่สนใจการเมือง" | mkA "ไม่มีความสําคัญทางการเมือง" ; -- src=panlex
lin apologetic_A = mkA "ซึ่งแสดงคำขอโทษ" | mkA "เกี่ยวกับการขออภัย" | mkA "ที่แสดงการเสียใจต่อ" | mkA "ที่แสดงถึงการขออภัย" | mkA "เต็มที่หรือต้องการขออภัย" ; -- src=panlex
lin apologist_N = mkN "ผู้ขออภัย" | mkN "ผู้ที่แก้ต่าง" | mkN "ผู้แก้ข้อกล่าวหา" ; -- src=panlex
lin apologize_V = mkV "ขอโทษ" | mkV "แก้ตัว" | mkV "ขอขมา" | mkV "ขอโทษ" | mkV "ขออภัย" | mkV "แก้ตัว" | mkV "แก้ต่าง" | mkV "ขอรับผิด" | mkV "ขอประทานโทษ" | mkV "แสดงความเสียใจ" ; -- src=panlex
lin apology_N = mkN "การแก้ต่าง" | mkN "ตัวอย่างที่แย่" | mkN "การแสดงความขอโทษ" | mkN "ตัวอย่างที่ไม่ดี" | mkN "การขอขมา" | mkN "การขอโทษ" | mkN "คําขอโทษ" | mkN "การขออภัย" | mkN "คําขอโทษหรือขออภัย" ; -- src=panlex
lin apomict_N = mkN "อะโพมิกต์" ; -- src=panlex
lin apomixis_N = mkN "แอโพมิกซิส" | mkN "วิธีการสืบพันธ์โดยใช้เพศ" ; -- src=panlex
lin apomorphine_N = mkN "อะโพมอร์ฟีน" ; -- src=panlex
lin aponeurosis_N = mkN "แอโพนิวโรซิส" ; -- src=panlex
lin aponeurotic_A = mkA "อะโพนิวโรซิส" ; -- src=panlex
lin apopemptic_A = mkA "เกี่ยวกับการจากไป" ; -- src=panlex
lin apophatism_N = mkN "อะโพฟาติสม์" ; -- src=panlex
lin apophthegm_N = mkN "คติพจน์" ; -- src=panlex
lin apophyseal_A = mkA "อะโพฟีซิส" ; -- src=panlex
lin apophysis_N = mkN "แง่กระดูก" | mkN "ส่วนอื่น" ; -- src=panlex
lin apoplectic_A = mkA "เกี่ยวกับอาการเป็นลมจากเส้นโลหิตในสมองแตก" ; -- src=panlex
lin apoplectiform_A = mkA "คล้ายอาการเป็นลมจากเส้นโลหิตในสมองแตก" ; -- src=panlex
lin apoplexy_N = mkN "โรคลมปัจจุบัน" | mkN "โรคลมเหตุร้อน" | mkN "ภาวะตกโลหิตและไหลเข้าไปในเนื้อเยื่อ" | mkN "การเป็นลมเนื่องจากเส้นโลหิตในสมองแตก" ; -- src=panlex
lin apoptosis_N = mkN "อะพอพโทซิส" | mkN "การตายของเซลล์แบบอะพอพโทซิส" ; -- src=panlex
lin aposelene_N = mkN "แอโพลูน" | mkN "จุดไกลดวงจันทร์" ; -- src=panlex
lin aposiopesis_N = mkN "การชะงักงันในขณะพูด" ; -- src=panlex
lin aposiopetic_A = mkA "เกี่ยวกับการชะงักงันในการพูด" ; -- src=panlex
lin apostasy_N = mkN "การเลิกนับถือ" | mkN "การเลิกเชื่อ" | mkN "การเลิกศรัทธา" ; -- src=panlex
lin apostate_N = mkN "คนทรยศ" | mkN "ผู้ที่เลิกศรัทธา" ; -- src=panlex
lin apostle_N = mkN "ผู้ปฏิรูป" | mkN "ผู้เผยแพร่" | mkN "สาวกของพระเยซูคริสต์" ; -- src=panlex
lin apostolic_A = mkA "ซึ่งมาจากผู้เผยแพร่คริสตศาสนาครั้งแรก" ; -- src=panlex
lin apostrophe_N = mkN "อะโพสโทรฟี" | mkN "เครื่องหมายอะโพสโทรฟี" | mkN "เครื่องหมายย่อ" | mkN "การพูดกับบุคคลในจินตนาการ" | mkN "การพูดกับบุคคลที่ล่วงลับไปแล้ว" ; -- src=panlex
lin apostrophic_A = mkA "เกี่ยวกับเครื่องหมายอะโพสโตรฟี" ; -- src=panlex
lin apothecary_N = mkN "ภก." | mkN "หมอยา" | mkN "เภสัชกร" | mkN "คนปรุงยา" | mkN "เภสัชกร" | mkN "ร้านขายยา" ; -- src=panlex
lin apothecium_N = mkN "อะโปทีเซียม" ; -- src=panlex
lin apothegm_N = mkN "คติพจน์" ; -- src=panlex
lin apothegmatic_A = mkA "ซึ่งให้คติพจน์" ; -- src=panlex
lin apotheosis_N = mkN "การยกย่อง" | mkN "ตัวอย่างที่ดี" | mkN "แบบอย่างที่ดี" | mkN "การยกบุคคลให้เป็นพระเจ้า" ; -- src=panlex
lin apotropaic_A = mkA "ที่ขจัดความชั่วร้าย" | mkA "เพื่อขนัดสิ่งชั่วร้าย" ; -- src=panlex
lin appalling_A = mkA "ซึ่งทําให้ตกใจ" ; -- src=panlex
lin appanage_N = mkN "ทรัพย์สินที่ครอบครองตามกฎหมาย" ; -- src=panlex
lin apparatchik_N = mkN "อะเพอราชิก" ; -- src=panlex
lin apparatus_N = mkN "อวัยวะ" | mkN "อุปกรณ์" | mkN "เครื่อง" | mkN "เครื่องมือ" | mkN "กลไก" | mkN "ระบบ" | mkN "อุปกรณ์" | mkN "เครื่องมือ" | mkN "เครื่องช่วย" ; -- src=panlex
lin apparel_N = mkN "ชุด" | mkN "อาภรณ์" | mkN "ผ้านุ่ง" | mkN "ผ้าผ่อน" | mkN "เสื้อผ้า" | mkN "เสื้อผ้า" | mkN "เครื่องประดับ" | mkN "เครื่องนุ่งห่ม" | mkN "เครื่องแต่งตัว" ; -- src=panlex
lin appareled_A = mkA "ซึ่งสวมชุด" ; -- src=panlex
lin apparent_A = mkA "เป็นที่ประจักษ์ชัด" | mkA "ชัดเจน" | mkA "ภายนอก" | mkA "เด่นชัด" | mkA "แจ่มแจ้ง" | mkA "ซึ่งเห็นได้" | mkA "เกี่ยวกับหลักฐานแรก เริ่ม" ; -- src=panlex
lin apparition_N = mkN "ผี" | mkN "ภูตผี" | mkN "ภูตผีปีศาจ" | mkN "การปรากฏตัวของผี" | mkN "ผี" | mkN "การแสดงออก" | mkN "การปรากฎตัวของผี" | mkN "สิ่งที่ดูน่ากลัว" | mkN "การปรากฎของจินตภาพ" ; -- src=panlex
lin apparitional_A = mkA "ที่เหมือนผี" ; -- src=panlex
lin appeal_N = mkN "เสน่ห์" | mkN "ความน่าสนใจ" | mkN "การร้องขอยอดเงิน" | mkN "คำขอร้องเร่งด่วน" | mkN "คําขอร้อง" | mkN "การอุทธรณ์" | mkN "ความน่าสนใจ" | mkN "ความเย้ายวน" | mkN "ความดึงดูดใจ" ; -- src=panlex
lin appeal_V = mkV "อ้าง" | mkV "ดึงดูด" | mkV "วิงวอน" | mkV "อุทธรณ์" | mkV "ดึงดูดใจ" | mkV "ขออุทธรณ์" | mkV "ยื่นอุทธรณ์" | mkV "ดึงดูด" | mkV "ร้องขอ" | mkV "อ้อนวอน" | mkV "ขออุทธรณ์" | mkV "ทําให้สนใจ" ; -- src=panlex
lin appeal_V2 = mkV2 "อ้าง" ; ---- | mkV "ดึงดูด" | mkV "วิงวอน" | mkV "อุทธรณ์" | mkV "ดึงดูดใจ" | mkV "ขออุทธรณ์" | mkV "ยื่นอุทธรณ์" | mkV "ดึงดูด" | mkV "ร้องขอ" | mkV "อ้อนวอน" | mkV "ขออุทธรณ์" | mkV "ทําให้สนใจ" ; -- src=panlex
lin appealing_A = mkA "ซึ่งดึงดูดใจ" | mkA "ที่รู้สึกเห็นอกเห็นใจ" | mkA "ที่ดึงดูดความสนใจ" ; -- src=panlex
lin appear_V = mkV "ออก" | mkV "ปรากฏ" | mkV "ตีพิมพ์" | mkV "ดูเหมือน" | mkV "ปรากฏตัว" | mkV "ดูเหมือนว่า" | mkV "ปรากฏ" | mkV "ออกมา" | mkV "มีขึ้น" | mkV "แสดงตน" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "ดูเหมือนจะ" | mkV "ดูเหมือนว่า" | mkV "พิมพ์จําหน่าย" | mkV "ปรากฏตัวต่อสาธารณะ" | mkV "ปรากฏตัวอย่างเป็นทางการในศาล" ; -- src=panlex
lin appear_VA = mmkVA "ออก" ; ---- | mkV "ปรากฏ" | mkV "ตีพิมพ์" | mkV "ดูเหมือน" | mkV "ปรากฏตัว" | mkV "ดูเหมือนว่า" | mkV "ปรากฏ" | mkV "ออกมา" | mkV "มีขึ้น" | mkV "แสดงตน" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "ดูเหมือนจะ" | mkV "ดูเหมือนว่า" | mkV "พิมพ์จําหน่าย" | mkV "ปรากฏตัวต่อสาธารณะ" | mkV "ปรากฏตัวอย่างเป็นทางการในศาล" ; -- src=panlex
lin appear_VS = mmkVS "ออก" ; ---- | mkV "ปรากฏ" | mkV "ตีพิมพ์" | mkV "ดูเหมือน" | mkV "ปรากฏตัว" | mkV "ดูเหมือนว่า" | mkV "ปรากฏ" | mkV "ออกมา" | mkV "มีขึ้น" | mkV "แสดงตน" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "ดูเหมือนจะ" | mkV "ดูเหมือนว่า" | mkV "พิมพ์จําหน่าย" | mkV "ปรากฏตัวต่อสาธารณะ" | mkV "ปรากฏตัวอย่างเป็นทางการในศาล" ; -- src=panlex
lin appear_VV = mkVV "ออก" ; ---- | mkV "ปรากฏ" | mkV "ตีพิมพ์" | mkV "ดูเหมือน" | mkV "ปรากฏตัว" | mkV "ดูเหมือนว่า" | mkV "ปรากฏ" | mkV "ออกมา" | mkV "มีขึ้น" | mkV "แสดงตน" | mkV "แสดงตัว" | mkV "ปรากฏตัว" | mkV "ดูเหมือนจะ" | mkV "ดูเหมือนว่า" | mkV "พิมพ์จําหน่าย" | mkV "ปรากฏตัวต่อสาธารณะ" | mkV "ปรากฏตัวอย่างเป็นทางการในศาล" ; -- src=panlex
lin appearance_N = mkN "ลักษณะ" | mkN "ภาพในใจ" | mkN "รูปลักษณ์" | mkN "การปรากฏตัว" | mkN "การสร้างภาพ" | mkN "สิ่งที่ปรากฏ" | mkN "รูปลักษณ์ภายนอก" | mkN "การเข้าร่วมในศาล" | mkN "รูปโฉม" | mkN "รูปร่าง" | mkN "การไปศาล" | mkN "ภาพลักษณ์" | mkN "รูปลักษณะ" | mkN "รูปลักษณ์" | mkN "โฉมภายนอก" | mkN "การปรากฎตัว" | mkN "การปรากฏตัว" | mkN "ลักษณะท่าทาง" | mkN "สิ่งที่ปรากฎ" | mkN "รูปร่างหน้าตา" | mkN "สิ่งที่ปรากฎให้เห็น" ; -- src=panlex
lin appeasement_N = mkN "การปลอบ" | mkN "การยอมตาม" | mkN "การพะเน้าพะนอ" ; -- src=panlex
lin appellant_A = mkA "ที่เป็นการอุทธรณ์" ; -- src=panlex
lin appellant_N = mkN "ผู้อุทธรณ์" | mkN "ผู้ร้องขอ" | mkN "ผู้อุทธรณ์" | mkN "ผู้อ้อนวอน" ; -- src=panlex
lin appellate_A = mkA "ที่เป็นการอุทธรณ์" | mkA "เกี่ยวกับการอุทธรณ์" | mkA "ซึ่งมีอํานาจพิจารณารับการอุทธรณ์" ; -- src=panlex
lin appellation_N = mkN "ชื่อ" | mkN "ชื่อที่อยู่" | mkN "ยศ" | mkN "นาม" | mkN "ชื่อ" | mkN "ศักดิ์" | mkN "นามสมญา" | mkN "ตําแหน่ง" | mkN "นามาภิไธย" | mkN "การตั้งชื่อ" ; -- src=panlex
lin appellative_A = mkA "เกี่ยวกับสามานยนาม" ; -- src=panlex
lin appendage_N = mkN "ส่วนยื่น" | mkN "ส่วนที่ยื่น" | mkN "ส่วนที่ยื่นออกจากร่างกาย" | mkN "แขนขา" | mkN "ส่วนผนวก" | mkN "ส่วนห้อยท้าย" | mkN "ส่วนเพิ่มใส่" | mkN "อวัยวะประกอบ" | mkN "ผู้อยู่ในสังกัด" | mkN "ผู้อยู่ใต้บังคับบัญชา" | mkN "ส่วนที่ยื่นออกไปจากร่างกาย" ; -- src=panlex
lin appendaged_A = mkA "ที่มีภาคผนวก" ; -- src=panlex
lin appendant_A = mkA "ติด" | mkA "ใส่" | mkA "ผนวก" | mkA "เพิ่ม" | mkA "ในสังกัด" ; -- src=panlex
lin appendectomy_N = mkN "การผ่าตัดไส้ติ่ง" | mkN "ศัลยกรรมตัดไส้ติ่งออก" ; -- src=panlex
lin appendicitis_N = mkN "ไส้ติ่งอักเสบ" | mkN "ไส้ติ่งอักเสบ" ; -- src=panlex
lin appendicle_N = mkN "ส่วนเล็กๆ ที่ยื่นออกมา" ; -- src=panlex
lin appendicularia_N = mkN "แอปเพนดิคูลาเรีย" ; -- src=panlex
lin appendix_N = mkN "ไส้ติ่ง" | mkN "ไส้ตะเกียง" | mkN "ภาคผนวก" | mkN "ไส้ติ่ง" | mkN "ส่วนเพิ่ม" ; -- src=panlex
lin apperception_N = mkN "สติสัมปชัญญะ" | mkN "การมีสติสัมปชัญญะ" ; -- src=panlex
lin appertain_V = mkV "เป็นของ" | mkV "เป็นของ" ; -- src=panlex
lin appetite_N = mkN "ความกระหาย" | mkN "ความชอบ" | mkN "ความหิว" | mkN "ความอยาก" | mkN "ความกระหาย" | mkN "ความปรารถนา" | mkN "ความอยากอาหาร" | mkN "ความต้องการของร่างกาย" | mkN "ความอยากอาหารหรือเครื่องดื่ม" ; -- src=panlex
lin appetizer_N = mkN "อาหารเรียกน้ำย่อย" | mkN "ยาเจริญอาหาร" | mkN "สิ่งที่เจริญอาหาร" | mkN "อาหารเรียกน้ําย่อย" ; -- src=panlex
lin appetizing_A = mkA "ที่กระตุ้นความอยากอาหาร" | mkA "น่ากิน" | mkA "มีเสน่ห์" | mkA "เจริญอาหาร" | mkA "กระตุ้นความต้องการ" | mkA "กระตุ้นความอยากกิน" ; -- src=panlex
lin appetizingness_N = mkN "การกระุตุ้นความเจริญอาหาร" ; -- src=panlex
lin applaud_V = mkV "ตบมือ" | mkV "ปรบมือ" | mkV "ปรบมือ" | mkV "ปรบมือ แสดงความชมชอบ" | mkV "ยกย่องนับถือ" | mkV "แสดงความสรรเสริญ" ; -- src=panlex
lin applaud_V2 = mkV2 "ตบมือ" ; ---- | mkV "ปรบมือ" | mkV "ปรบมือ" | mkV "ปรบมือ แสดงความชมชอบ" | mkV "ยกย่องนับถือ" | mkV "แสดงความสรรเสริญ" ; -- src=panlex
lin applaudable_A = mkA "ที่สมควรยกย่อง" ; -- src=panlex
lin applause_N = mkN "การตบมือ" | mkN "การปรบมือ" | mkN "การปรบมือ" | mkN "เสียงปรบมือ" | mkN "การปรบมือแสดงความชื่นชม" ; -- src=panlex
lin apple_N = mkN (thbind "แอป" "เปิ้ล") "ลูก" ;
lin applecart_N = mkN "รถเข็นผลไม้" | mkN "รถเข็นแอปเปิ้ล" ; -- src=panlex
lin applejack_N = mkN "แอปเปิ้ลแจ็ค" | mkN "บรั่นดีจากน้ําแอปเปิ้ล" ; -- src=panlex
lin applesauce_N = mkN "ซอสแอปเปิ้ล" | mkN "เรื่องไร้สาระ" | mkN "วรรณกรรมไร้คุณค่า" | mkN "ซอสแอปเปิล" ; -- src=panlex
lin applet_N = mkN "แอปเพล็ต" ; -- src=panlex
lin applewood_N = mkN "ไม้แอปเปิ้ล" ; -- src=panlex
lin appliance_N = mkN "อุปกรณ์" | mkN "เครื่องมือ" | mkN "เครื่องใช้" | mkN "เครื่องจักรกล" | mkN "อุปกรณ์ทุ่นแรง" | mkN "เครื่องมือเครื่องไม้" | mkN "อุปกรณ์" | mkN "เครื่องมือ" | mkN "เครื่องใช้" | mkN "เครื่องกลสําหรับใช้สอยในบ้าน" ; -- src=panlex
lin applicability_N = mkN "ความเกี่ยวข้อง" ; -- src=panlex
lin applicable_A = mkA "ใช้สอยได้" | mkA "ปฏิบัติได้" | mkA "ที่สามารถนับไปปรับใช้ได้" ; -- src=panlex
lin applicant_N = mkN "คนสมัคร" | mkN "ผู้สมัคร" | mkN "ผู้ขอ" | mkN "ผู้สมัคร" | mkN "ผู้แจ้งความจํานง" ; -- src=panlex
lin application_1_N = mkN "การใช้" | mkN "โลชั่น" | mkN "ใบสมัคร" | mkN "ความอุตสาหะ" | mkN "แอพพลิเคชั่น" | mkN "โปรแกรมใช้งาน" | mkN "โปรแกรมประยุกต์" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "การขอ" | mkN "การทา" | mkN "การใช้" | mkN "ใบสมัคร" | mkN "การสมัคร" | mkN "การร้องขอ" | mkN "คําร้องขอ" | mkN "การประยุกต์" | mkN "การประยุกต์ใช้" | mkN "ความมีประโยชน์" | mkN "ความเกี่ยวข้อง" | mkN "ความสัมพันธ์กัน" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "ความสนใจอย่างใกล้ชิด" ; -- src=panlex
lin application_2_N = mkN "การใช้" | mkN "โลชั่น" | mkN "ใบสมัคร" | mkN "ความอุตสาหะ" | mkN "แอพพลิเคชั่น" | mkN "โปรแกรมใช้งาน" | mkN "โปรแกรมประยุกต์" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "การขอ" | mkN "การทา" | mkN "การใช้" | mkN "ใบสมัคร" | mkN "การสมัคร" | mkN "การร้องขอ" | mkN "คําร้องขอ" | mkN "การประยุกต์" | mkN "การประยุกต์ใช้" | mkN "ความมีประโยชน์" | mkN "ความเกี่ยวข้อง" | mkN "ความสัมพันธ์กัน" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "ความสนใจอย่างใกล้ชิด" ; -- src=panlex
lin application_3_N = mkN "การใช้" | mkN "โลชั่น" | mkN "ใบสมัคร" | mkN "ความอุตสาหะ" | mkN "แอพพลิเคชั่น" | mkN "โปรแกรมใช้งาน" | mkN "โปรแกรมประยุกต์" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "การขอ" | mkN "การทา" | mkN "การใช้" | mkN "ใบสมัคร" | mkN "การสมัคร" | mkN "การร้องขอ" | mkN "คําร้องขอ" | mkN "การประยุกต์" | mkN "การประยุกต์ใช้" | mkN "ความมีประโยชน์" | mkN "ความเกี่ยวข้อง" | mkN "ความสัมพันธ์กัน" | mkN "โปรแกรมคอมพิวเตอร์" | mkN "ความสนใจอย่างใกล้ชิด" ; -- src=panlex
lin applicative_A = mkA "ใช้ได้" | mkA "ปฏิบัติได้" | mkA "ใช้ประโยชน์ได้" ; -- src=panlex
lin applicator_N = mkN "แอปพลิเคเตอร์" | mkN "อุปกรณ์ง่าย ๆ" | mkN "อุปกรณ์ง่าย ๆ เครื่องมือง่าย ๆ" ; -- src=panlex
lin applied_A = mkA "ประยุกต์ได้" | mkA "ที่ประยุกต์ได้" | mkA "ใช้เป็นประโยชน์" ; -- src=panlex
lin apply_V = mkV "ทา" | mkV "ใช้" | mkV "ให้" | mkV "นำมาใช้" | mkV "บังคับใช้" | mkV "นำไปใช้ได้" | mkV "ทา" | mkV "ฉาบ" | mkV "ใช้" | mkV "ไล้" | mkV "ป้าย" | mkV "ดัดแปลง" | mkV "ปรับใช้" | mkV "นํามาใช้" | mkV "ทํางานหนัก" | mkV "นํามาใช้กับ" | mkV "ประยุกต์ใช้" | mkV "ใช้ประโยชน์" ; -- src=panlex
lin apply_V2 = mkV2 "ทา" ; ---- | mkV "ใช้" | mkV "ให้" | mkV "นำมาใช้" | mkV "บังคับใช้" | mkV "นำไปใช้ได้" | mkV "ทา" | mkV "ฉาบ" | mkV "ใช้" | mkV "ไล้" | mkV "ป้าย" | mkV "ดัดแปลง" | mkV "ปรับใช้" | mkV "นํามาใช้" | mkV "ทํางานหนัก" | mkV "นํามาใช้กับ" | mkV "ประยุกต์ใช้" | mkV "ใช้ประโยชน์" ; -- src=panlex
lin apply_V2V = mmkV2V "ทา" ; ---- | mkV "ใช้" | mkV "ให้" | mkV "นำมาใช้" | mkV "บังคับใช้" | mkV "นำไปใช้ได้" | mkV "ทา" | mkV "ฉาบ" | mkV "ใช้" | mkV "ไล้" | mkV "ป้าย" | mkV "ดัดแปลง" | mkV "ปรับใช้" | mkV "นํามาใช้" | mkV "ทํางานหนัก" | mkV "นํามาใช้กับ" | mkV "ประยุกต์ใช้" | mkV "ใช้ประโยชน์" ; -- src=panlex
lin apply_VV = mkVV "ทา" ; ---- | mkV "ใช้" | mkV "ให้" | mkV "นำมาใช้" | mkV "บังคับใช้" | mkV "นำไปใช้ได้" | mkV "ทา" | mkV "ฉาบ" | mkV "ใช้" | mkV "ไล้" | mkV "ป้าย" | mkV "ดัดแปลง" | mkV "ปรับใช้" | mkV "นํามาใช้" | mkV "ทํางานหนัก" | mkV "นํามาใช้กับ" | mkV "ประยุกต์ใช้" | mkV "ใช้ประโยชน์" ; -- src=panlex
lin apply_for_V2 = prepV2 OP_apply_V OP_for_Prep ; -- guess-p-verb
lin appointed_A = mkA "ได้รับแต่งตั้ง" | mkA "ที่ได้รับแต่งตั้ง" | mkA "ที่ได้รับการแต่งตั้ง" | mkA "ที่มีเครื่องตกแต่งพร้อม" ; -- src=panlex
lin appointee_N = mkN "ผู้ได้รับแต่งตั้ง" | mkN "ผู้ได้รับมอบหมายให้ดำรงตำแหน่ง" | mkN "ผู้ได้รับการแต่งตั้ง" ; -- src=panlex
lin appointive_A = mkA "เกี่ยวกับการแต่งตั้ง" ; -- src=panlex
lin appointment_N = mkN "การตกแต่ง" | mkN "การนัดหมาย" | mkN "การแต่งตั้ง" | mkN "การนัดหมายล่วงหน้า" | mkN "ผู้ได้รับมอบหมายให้ดำรงตำแหน่ง" | mkN "งาน" | mkN "อุปกรณ์" | mkN "การนัดพบ" | mkN "ตําแหน่ง" | mkN "การนัดหมาย" | mkN "การแต่งตั้ง" | mkN "เครื่องแต่งตัว" | mkN "ผู้ที่ได้รับการแต่งตั้ง" ; -- src=panlex
lin apportionment_N = mkN "การแบ่งส่วน" | mkN "การจัดสรร" | mkN "การแบ่งปัน" | mkN "การแบ่งสรร" | mkN "การแบ่งสันปันส่วน" ; -- src=panlex
lin apposite_A = mkA "เหมาะ" | mkA "เหมาะสม" | mkA "เกิดควบคู่หรือขนานกัน" ; -- src=panlex
lin apposition_N = mkN "แอปโพซิชัน" | mkN "การวางข้างกัน" | mkN "อนุประโยคอื่น" | mkN "การวางเข้าด้วยกัน" | mkN "การวางเคียงข้างกัน" ; -- src=panlex
lin appositively_Adv = mkAdv "โดยวางติดกัน" ; -- src=panlex
lin appraisal_N = mkN "ใบประเมิน" | mkN "การประเมิน" | mkN "การตีราคา" | mkN "การประเมิน" ; -- src=panlex
lin appraiser_N = mkN "ผู้ประเมิน" ; -- src=panlex
lin appreciable_A = mkA "จํานวนมาก" | mkA "ซึ่งประเมินค่าได้" | mkA "ซึ่งพอประเมินค่าได้" ; -- src=panlex
lin appreciate_V = mkV "หวงแหน" | mkV "แข็งค่า" | mkV "เพิ่มค่า" | mkV "ซาบซึ้งใจ" | mkV "ให้คุณค่า" | mkV "เข้าใจถ่องแท้" | mkV "ชื่นชม" | mkV "ยกย่อง" | mkV "ขึ้นราคา" | mkV "เห็นคุณค่า" | mkV "สํานึกคุณค่า" | mkV "สํานึกบุญคุณ" ; -- src=panlex
lin appreciate_V2 = mkV2 "หวงแหน" ; ---- | mkV "แข็งค่า" | mkV "เพิ่มค่า" | mkV "ซาบซึ้งใจ" | mkV "ให้คุณค่า" | mkV "เข้าใจถ่องแท้" | mkV "ชื่นชม" | mkV "ยกย่อง" | mkV "ขึ้นราคา" | mkV "เห็นคุณค่า" | mkV "สํานึกคุณค่า" | mkV "สํานึกบุญคุณ" ; -- src=panlex
lin appreciation_N = mkN "การจับ" | mkN "การแข็งค่า" | mkN "การแยกแยะอย่างประณีต" | mkN "บทวิจารณ์" | mkN "การตระหนัก" | mkN "การวิจารณ์" | mkN "ความกตัญญู" | mkN "ความขอบคุณ" | mkN "การหยั่งรู้" | mkN "การประเมินค่า" | mkN "ความรู้คุณค่า" | mkN "ความสํานึกบุญคุณ" | mkN "การมีค่าเพิ่มขึ้น" | mkN "การเพิ่มขึ้นของราคา" ; -- src=panlex
lin appreciative_A = mkA "เห็นคุณค่า" | mkA "รู้สึกขอบคุณ" ; -- src=panlex
lin apprehender_N = mkN "ผู้รู้" ; -- src=panlex
lin apprehension_N = mkN "ความกลัว" | mkN "การจับกุม" | mkN "ความเข้าใจ" | mkN "ความเกรงกลัว" | mkN "ความกลัวสุดขีด" | mkN "การลากคอเข้าคุก" | mkN "ความกลัว" | mkN "การจับกุม" | mkN "ความสงสัย" | mkN "ความเข้าใจ" | mkN "การหยั่งรู้" | mkN "ความคิดเห็น" | mkN "ความหวาดหวั่น" ; -- src=panlex
lin apprehensive_A = mkA "ซึ่งกลัวอันตราย" | mkA "กลัว" | mkA "ตระหนก" | mkA "ตระหนัก" | mkA "กลัวเกรง" | mkA "ประหวั่น" | mkA "พรั่นพรึง" | mkA "หวั่นกลัว" | mkA "สามารถเข้าใจได้เร็ว" | mkA "หวั่นว่าบางสิ่งบางอย่างอาจเกิดขึ้น" ; -- src=panlex
lin apprentice_N = mkN "เด็กฝึกงาน" | mkN "ผู้ฝึกงาน" | mkN "เด็กฝึกงาน" | mkN "ผู้เรียนรู้" | mkN "มือสมัครเล่น" | mkN "ผู้ที่ไม่มีประสบการณ์" ; -- src=panlex
lin appressed_A = mkA "กดหรือดันติดกับ" | mkA "ที่ถูกกดติดกับพื้นผิว" ; -- src=panlex
lin approach_N = mkN "ทาง" | mkN "การดูด" | mkN "จู่โจม" | mkN "ทางเข้าออก" | mkN "การเข้าใกล้" | mkN "วิธีการเข้า-ออก" | mkN "ความใกล้เคียง" | mkN "เส้นทางร่อนลง" | mkN "การตีชอตแอปโพรช" | mkN "การบินเครื่องร่อน" | mkN "การเข้าใกล้" | mkN "ความคล้ายกัน" | mkN "สิ่งที่คล้ายกัน" | mkN "วิธีการทําให้ถึงจุดหมาย" ; -- src=panlex
lin approach_V = mkV "ทาบทาม" | mkV "เข้าใกล้" | mkV "ใกล้เคียง" | mkV "ถึง" | mkV "คล้าย" | mkV "จัดการ" | mkV "เข้าหา" | mkV "ใกล้จะ" | mkV "เข้าใกล้" | mkV "ใกล้เคียง" | mkV "ปฎิบัติต่อ" | mkV "เข้าตีสนิท" | mkV "เกือบจะเป็น" ; -- src=panlex
lin approach_V2 = mkV2 "ทาบทาม" ; ---- | mkV "เข้าใกล้" | mkV "ใกล้เคียง" | mkV "ถึง" | mkV "คล้าย" | mkV "จัดการ" | mkV "เข้าหา" | mkV "ใกล้จะ" | mkV "เข้าใกล้" | mkV "ใกล้เคียง" | mkV "ปฎิบัติต่อ" | mkV "เข้าตีสนิท" | mkV "เกือบจะเป็น" ; -- src=panlex
lin approachable_A = mkA "ซึ่งเข้าถึงง่าย" | mkA "ที่เข้าถึงได้ง่าย" | mkA "ที่เป็นมิตร" | mkA "ที่สนิทได้ง่าย" | mkA "ซึ่งเข้าใกล้ได้" | mkA "ที่เข้าถึงได้ง่าย" ; -- src=panlex
lin approbation_N = mkN "การยินยอม" | mkN "การแนะนํา" | mkN "การเห็นด้วย" | mkN "ความรู้สึกพอใจต่อ" ; -- src=panlex
lin appropriable_A = mkA "ที่สามารถทําให้เหมาะสมได้" | mkA "สามารถเห็นคุณค่าหรือขอบคุณได้" ; -- src=panlex
lin appropriate_A = mkA "ซึ่งเหมาะ" | mkA "พอเหมาะ" | mkA "เข้ากัน" | mkA "เหมาะสม" ; -- src=panlex
lin appropriateness_N = mkN "ความถูกต้อง" ; -- src=panlex
lin appropriation_N = mkN "เงินสำรอง" | mkN "การเข้าร่วม" | mkN "การจัดสรรไว้" | mkN "การตั้งเงินไว้เป็นพิเศษ" ; -- src=panlex
lin appropriator_N = mkN "ผู้ถือเอา" ; -- src=panlex
lin approval_N = mkN "ฉันทามติ" | mkN "การยินยอม" | mkN "การอนุมัติ" | mkN "การเห็นชอบ" | mkN "การเห็นด้วย" | mkN "ความเห็นชอบ" | mkN "ความเห็นพ้อง" | mkN "การอนุญาต" | mkN "การอนุมัติ" | mkN "การเห็นด้วย" | mkN "ความเห็นพ้อง" | mkN "การแสดงความพอใจ" | mkN "ความเห็นชอบด้วย" | mkN "ความยินยอมพร้อมใจ" ; -- src=panlex
lin approve_V = mkV "เห็นชอบ" | mkV "เห็นด้วย" | mkV "อนุมัติ" | mkV "เห็นควร" | mkV "เห็นชอบ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เห็นสมควร" | mkV "เห็นดีเห็นชอบ" ; -- src=panlex
lin approve_V2 = mkV2 "เห็นชอบ" ; ---- | mkV "เห็นด้วย" | mkV "อนุมัติ" | mkV "เห็นควร" | mkV "เห็นชอบ" | mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เห็นสมควร" | mkV "เห็นดีเห็นชอบ" ; -- src=panlex
lin approved_A = mkA "ที่อนุมัติ" ; -- src=panlex
lin approver_N = mkN "ผู้อนุมัติ" ; -- src=panlex
lin approvingly_Adv = mkAdv "อย่างเห็นด้วย" ; -- src=panlex
lin approximate_A = mkA "ราวๆ" | mkA "ประมาณ" | mkA "เกือบจะ" | mkA "คล้ายคลึง" | mkA "ใกล้เคียง" | mkA "คล้ายกันมาก" | mkA "จํานวนใกล้เคียง" ; -- src=panlex
lin approximate_V = mkV "กะ" | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "ใกล้เคียง" | mkV "กะ" | mkV "ประมาณ" | mkV "เกือบจะเหมือน" ; -- src=panlex
lin approximate_V2 = mkV2 "กะ" ; ---- | mkV "ประมาณ" | mkV "ประเมิน" | mkV "กะประมาณ" | mkV "ใกล้เคียง" | mkV "กะ" | mkV "ประมาณ" | mkV "เกือบจะเหมือน" ; -- src=panlex
lin approximation_N = mkN "การประมาณ" | mkN "ความใกล้เคียง" | mkN "การเดา" | mkN "การประมาณ" | mkN "ค่าประมาณ" | mkN "ความคล้ายคลึง" | mkN "ความใกล้เคียง" | mkN "การคํานวณอย่างหยาบๆ" ; -- src=panlex
lin appurtenance_N = mkN "ส่วนเพิ่มเติม" | mkN "ส่วนเสริม" | mkN "ส่วนประกอบ" | mkN "เครื่องมือ" | mkN "การต่อเนื่อง" | mkN "สิทธิต่อเนื่อง" ; -- src=panlex
lin apricot_N = mkN "แอพริคอต" | mkN "ผลแอพริคอต" | mkN "ต้นแอปริคอท" | mkN "ลูกแอพริคอต" | mkN "สีเหลืองอมส้ม" | mkN "สีส้มอ่อนอมชมพู" | mkN "ต้น" | mkN "แอปริคอท" | mkN "สีชมพูเหลือง" | mkN "ผลไม้ชนิดหนึ่งมีสีเหลืองส้ม มีรสหวาน" ; -- src=panlex
lin apron_N = mkN "ที่กำบัง" | mkN "ลานสนามบิน" | mkN "เวทีหน้าม่าน" | mkN "ที่ค้ํา" | mkN "หน้าเวที" | mkN "กะบังโลหะ" | mkN "ที่กําบัง" | mkN "ผ้ากันเปื้อน" | mkN "ลานจอดเครื่องบิน" ; -- src=panlex
lin apropos_A = mkA "เหมาะสมกับกาละเทศะ" | mkA "เหมาะสม" | mkA "ถูกจังหวะ" | mkA "ที่ถูกโอกาส" | mkA "ถูกจุดประสงค์" ; -- src=panlex
lin apropos_Adv = mkAdv "อนึ่ง" | mkAdv "เหมาะกับเวลา" | mkAdv "เหมาะแก่เวลา" | mkAdv "อีกประการหนึ่ง" | mkAdv "เหมาะสม" | mkAdv "ถูกจังหวะ" | mkAdv "เหมาะกับเวลา" | mkAdv "ถูกจุดประสงค์" ; -- src=panlex
lin apse_N = mkN "มุขโค้งด้านสกัด" | mkN "ส่วนของอาคารที่เป็นมุขยื่นออกไป" ; -- src=panlex
lin apt_A = mkA "ฉลาด" | mkA "พร้อม" | mkA "เหมาะสม" | mkA "เป็นไปได้" | mkA "เรียนเก่ง" | mkA "โน้มเอียง" | mkA "ง่ายต่อการ" | mkA "เฉลียวฉลาด" | mkA "เรียนรู้เร็ว" | mkA "มีความโน้มเอียง" | mkA "สามารถเป็นพิเศษ" ; -- src=panlex
lin apteral_A = mkA "ซึ่งไม่มีปีก" ; -- src=panlex
lin apterous_A = mkA "ซึ่งไม่มีปีก" | mkA "ไม่มีปีก" ; -- src=panlex
lin aptitude_N = mkN "แนวโน้ม" | mkN "ความถนัด" | mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "ความเหมาะสม" | mkN "ความฉลาดในการเรียนรู้" | mkN "ความสามารถในการเรียนรู้ได้เร็ว" ; -- src=panlex
lin aquaculture_N = mkN "เกษตรกรรมใต้น้ํา" | mkN "เพาะเลี้ยงสัตว์น้ํา" | mkN "การปลูกพืชและเลี้ยงสัตว์ใต้น้ํา" ; -- src=panlex
lin aqualung_N = mkN "สคูบ้า" | mkN "อุปกรณ์ช่วยหายใจ" ; -- src=panlex
lin aquamarine_N = mkN "สีน้ำทะเล" | mkN "อะคัวมารีน" | mkN "สีเทอร์คอยซ์" | mkN "น้ำเงินอมเขียว" | mkN "สีน้ำเงินอมเขียว" | mkN "สีเขียวน้ําเงินอ่อน" | mkN "พลอยเขียวน้ําเงินอ่อน" ; -- src=panlex
lin aquanaut_N = mkN "นักดำน้ำ" | mkN "นักประดาน้ำ" | mkN "นักประดาน้ํา" | mkN "นักสํารวจใต้ทะเล" ; -- src=panlex
lin aquaphobia_N = mkN "อาการกลัวการจมน้ำ" ; -- src=panlex
lin aquaplane_N = mkN "กระดานลากโต้คลื่น" ; -- src=panlex
lin aquaplane_V = mkV "โต้คลื่น" | mkV "ไถลพื้นเปียก" ; -- src=panlex
lin aquarium_N = mkN "ตู้ปลา" | mkN "พิพิธภัณฑ์สัตว์น้ำ" | mkN "ตู้ปลา" | mkN "ที่เก็บ" | mkN "พิพิธภัณฑ์สัตว์น้ํา" | mkN "สถานที่เลี้ยงสัตว์น้ําสําหรับคนดู" ; -- src=panlex
lin aquatic_A = mkA "น้ำ" | mkA "ซึ่งอาศัยน้ํา" | mkA "เกี่ยวกับน้ํา" | mkA "ที่เกี่ยวกับทะเล" | mkA "ที่มีชีวิตอยู่ในน้ํา" | mkA "ที่ใช้ชีวิตอยู่ในน้ํา" | mkA "อาศัยหรือมีชีวิตอยู่ใต้น้ํา" ; -- src=panlex
lin aquatic_N = mkN "พืชน้ำ" | mkN "พืชหรือสัตว์น้ํา" ; -- src=panlex
lin aquavit_N = mkN "อะควาวิต" | mkN "เหล้าอะควาวิต" ; -- src=panlex
lin aqueduct_N = mkN "ท่อส่งน้ำ" | mkN "ท่อน้ํา" | mkN "ทางระบายน้ํา" | mkN "ท่อระบายน้ํา" | mkN "สะพานท่อน้ํา" ; -- src=panlex
lin aqueous_A = mkA "ซึ่งละลายน้ำ" | mkA "ซึ่งมีน้ํา" | mkA "เกี่ยวกับน้ํา" | mkA "ประกอบด้วยน้ํา" | mkA "ซึ่งประกอบด้วยน้ํา" ; -- src=panlex
lin aquifer_N = mkN "ชั้นน้ำ" | mkN "ชั้นหินอุ้มน้ำ" ; -- src=panlex
lin aquiline_A = mkA "เป็นรูปขอ" | mkA "เป็นรูปปากนกอินทรีย์" | mkA "เกี่ยวกับหรือคล้ายนกอินทรีย์" ; -- src=panlex
lin arab_N = mkN "คนพเนจร" | mkN "คนอาหรับ" | mkN "ม้าอาหรับ" ; -- src=panlex
lin arabesque_N = mkN "ประณีต" | mkN "พิสดาร" | mkN "ลายแบบอาหรับ" ; -- src=panlex
lin arabianFem_N = variants {} ; ---- sense to be split
lin arabianMasc_N = variants {} ; ---- sense to be split
lin arabic_A = mkA "เกี่ยวกับอาระเบีย" ; -- src=panlex
lin arability_N = mkN "การเพาะปลูกได้" ; -- src=panlex
lin arabist_N = mkN "ผู้เชี่ยวชาญภาษาหรือวัฒนธรรมของอาหรับ" ; -- src=panlex
lin arable_A = mkA "เหมาะแก่การเพาะปลูก" ; -- src=panlex
lin arachnid_N = mkN "อะแร็กนิด" ; -- src=panlex
lin arachnoid_N = mkN "อะแร็กนิด" | mkN "แมลงมุม" | mkN "คล้ายใยแมงมุม" ; -- src=panlex
lin arachnophobia_N = mkN "อาการกลัวแมงมุม" ; -- src=panlex
lin aragonite_N = mkN "อะราโกไนต์" | mkN "แร่อะราโกไนต์" ; -- src=panlex
lin aralia_N = mkN "ต้นอะราเลีย" ; -- src=panlex
lin arame_N = mkN "สาหร่ายอะราเม" ; -- src=panlex
lin arariba_N = mkN "ต้นอะราริบา" ; -- src=panlex
lin araroba_N = mkN "แป้งอะราโรบา" ; -- src=panlex
lin araucaria_N = mkN "ต้นอะรอคาเรีย" ; -- src=panlex
lin arbiter_N = mkN "ผู้สร้างแรงบันดาลใจ" | mkN "ตุลาการ" | mkN "คนชี้ขาด" | mkN "ผู้ชี้ขาด" | mkN "ผู้ตัดสิน" | mkN "ผู้ที่มีอํานาจ" | mkN "อนุญาโตตุลาการ" | mkN "ผู้กําชะตาชีวิต" | mkN "ผู้ที่มีอิทธิพล" ; -- src=panlex
lin arbitrage_N = mkN "การซื้อขายหุ้น" | mkN "การค้ากําไร" | mkN "การตัดสินโดยอนุญาโตตุลาการ" ; -- src=panlex
lin arbitrageur_N = mkN "พ่อค้า" ; -- src=panlex
lin arbitral_A = mkA "เกี่ยวกับผู้ตัดสินหรือการตัดสิน" ; -- src=panlex
lin arbitrament_N = mkN "การตัดสิน" | mkN "การตัดสิน" | mkN "การตัดสินโดยอนุญาโตตุลาการ" ; -- src=panlex
lin arbitrary_A = mkA "ตามใจชอบ" | mkA "โดยพลการ" | mkA "ไร้เหตุผล" | mkA "ตามอําเภอใจ" | mkA "เอาแต่อารมณ์" | mkA "โดยการสุ่มเลือก" | mkA "โดยไม่มีกฎเกณฑ์" | mkA "เกี่ยวกับอํานาจเผด็จการ" | mkA "เกี่ยวกับอํานาจเบ็ดเสร็จ" | mkA "ที่ไม่ได้ขึ้นอยู่กับกฎเกณฑ์" ; -- src=panlex
lin arbitrate_V = mkV "ประสาน" | mkV "ไกล่เกลี่ย" | mkV "ชี้ขาด" | mkV "ตัดสิน" | mkV "เป็นผู้ตัดสิน" | mkV "ยุติการโต้แย้ง" | mkV "ขอให้ตัดสินโดยมีผู้ชี้ขาด" | mkV "เสนอให้ตัดสินโดยมีผู้ชี้ขาด" ; -- src=panlex
lin arbitrate_V2 = mkV2 "ประสาน" ; ---- | mkV "ไกล่เกลี่ย" | mkV "ชี้ขาด" | mkV "ตัดสิน" | mkV "เป็นผู้ตัดสิน" | mkV "ยุติการโต้แย้ง" | mkV "ขอให้ตัดสินโดยมีผู้ชี้ขาด" | mkV "เสนอให้ตัดสินโดยมีผู้ชี้ขาด" ; -- src=panlex
lin arbitration_N = mkN "การตัดสิน" | mkN "อนุญาโตตุลาการ" | mkN "การชี้ขาด" | mkN "การตัดสิน" | mkN "การตัดสินโดยอนุญาโตตุลาการ" ; -- src=panlex
lin arbitrator_N = mkN "ผู้ตัดสิน" | mkN "ผู้ที่ถูกเลือกให้มาตัดสิน" ; -- src=panlex
lin arbor_N = mkN "ซุ้ม" | mkN "ซุ้มไม้" | mkN "แกนหมุน" | mkN "ที่ร่มใต้ต้นไม้" | mkN "แกน" | mkN "ด้าม" | mkN "ต้นไม้" | mkN "ซุ้มไม้" | mkN "เพลามีด" | mkN "สิ่งที่ช่วยค้ํา" | mkN "เครื่องช่วยค้ํา" | mkN "ที่ร่มใต้ต้นไม้หรือซุ้มต้นไม้" ; -- src=panlex
lin arboraceous_A = mkA "ซึ่งเต็มไปด้วยต้นไม้" ; -- src=panlex
lin arboreal_A = mkA "ที่เหมือนต้นไม้" | mkA "เกี่ยวกับต้นไม้" | mkA "ซึ่งอาศัยบนต้นไม้" | mkA "คล้ายต้นไม้" | mkA "เกี่ยวกับต้นไม้" ; -- src=panlex
lin arboretum_N = mkN "สวนพฤกษชาติ" | mkN "สวนพฤกษศาสตร์" ; -- src=panlex
lin arborical_A = mkA "เกี่ยวกับต้นไม้" ; -- src=panlex
lin arborolatry_N = mkN "การบูชาต้นไม้" ; -- src=panlex
lin arbour_N = mkN "ซุ้ม" | mkN "ซุ้มไม้" | mkN "แกน" | mkN "ด้าม" | mkN "ต้นไม้" | mkN "สุมทุม" | mkN "ซุ้มไม้" | mkN "เพลามีด" | mkN "ที่มีร่มเงา" ; -- src=panlex
lin arbovirus_N = mkN "เชื้อไวรัสที่มีแมลงเป็นพาหะนำโรค" | mkN "ไข้เหลือง" ; -- src=panlex
lin arbutus_N = mkN "ต้นไม้สกุลอาร์บูทัส" | mkN "ชื่อต้นไม้ในยุโรปมีผลสีม่วง" ; -- src=panlex
lin arc_N = mkN "โค้ง" | mkN "ประกายไฟ" | mkN "ส่วนโค้ง" | mkN "อาร์กไฟฟ้า" | mkN "วัตถุรูปโค้ง" | mkN "การปล่อยประจุไฟฟ้า" | mkN "ความโค้ง" | mkN "ส่วนโค้ง" ; -- src=panlex
lin arcade_N = mkN "ซุ้มประตู" | mkN "ทางเดินที่มีหลังคาโค้ง" | mkN "ทางเดินที่มีหลังคาโค้ง" | mkN "ทางเดินที่มีเสาทั้งสองข้าง" | mkN "บริเวณที่มีตู้เกมส์ให้เล่น" | mkN "ทางเดินที่มีร้านขายของสองฝั่ง" | mkN "อนุกรมของส่วนโค้งที่มีเสาค้ํา" ; -- src=panlex
lin arcadian_A = mkA "ที่เป็นชีวิตในชนบท" | mkA "ลูกทุ่ง" | mkA "อย่าง่าย ๆ" ; -- src=panlex
lin arcane_A = mkA "ลี้ลับ" | mkA "ลึกลับ" | mkA "ที่ซ่อนไว้" | mkA "ที่เป็นความลับ" ; -- src=panlex
lin arcella_N = mkN "อาร์เซลลา" ; -- src=panlex
lin arch_A = mkA "สําคัญ" | mkA "เป็นหัวโจก" | mkA "ที่มีเล่ห์เหลี่ยม" ; -- src=panlex
lin arch_N = mkN "โค้ง" | mkN "อาร์ช" | mkN "กระดูกส่วนโค้ง" | mkN "ทางเดินใต้ประตูโค้ง" | mkN "โค้ง" | mkN "ซุ้มประตู" | mkN "สิ่งที่มีลักษณะโค้ง" | mkN "โครงสร้างที่มีรูปโค้ง" | mkN "ทางเดินใต้ประตูรูปโค้ง" | mkN "การก่อตัวของหินเป็นรูปโค้ง" ; -- src=panlex
lin arch_V = mkV "โค้ง" | mkV "ทําให้งอ" | mkV "มีรูปโค้ง" | mkV "ทําให้โค้ง" | mkV "มีโครงสร้างโค้ง" ; -- src=panlex
lin arch_V2 = mkV2 "โค้ง" ; ---- | mkV "ทําให้งอ" | mkV "มีรูปโค้ง" | mkV "ทําให้โค้ง" | mkV "มีโครงสร้างโค้ง" ; -- src=panlex
lin archaebacteria_N = mkN "อาร์คีแบคทีเรีย" ; -- src=panlex
lin archaeological_A = mkA "ทางโบราณคดี" | mkA "เกี่ยวกับโบราณคดี" ; -- src=panlex
lin archaeologist_N = mkN "นักโบราณคดี" ; -- src=panlex
lin archaeology_N = mkN "โบราณคดี" | mkN "วิชาโบราณคดี" | mkN "โบราณคดี" | mkN "โบราณคดีวิทยา" ; -- src=panlex
lin archaeopteryx_N = mkN "นกอาร์คีออปเตอริกซ์" ; -- src=panlex
lin archaeornis_N = mkN "นกอาร์คีออร์นิส" ; -- src=panlex
lin archaic_A = mkA "โบราณ" | mkA "พ้นสมัย" | mkA "ล้าสมัย" | mkA "เก่าแก่" | mkA "แบบโบราณ" ; -- src=panlex
lin archaism_N = mkN "คําเก่า" | mkN "คําโบราณ" | mkN "สิ่งที่โบราณ" | mkN "การเลียนแบบคําพูดหรือเทคนิคโบราณ" ; -- src=panlex
lin archaist_N = mkN "นักสะสมโบราณวัตถุ" ; -- src=panlex
lin archangel_N = mkN "อาร์คแองเจิล" | mkN "ต้นการ์เด้นแองเจลิกา" | mkN "ประมุขทูตสวรรค์" | mkN "ทูตสวรรค์ชั้นหัวหน้า" ; -- src=panlex
lin archbishop_N = mkN "อาร์ชบิชอป" | mkN "หัวหน้าของบิชอพ" ; -- src=panlex
lin archbishopric_N = mkN "ตำแหน่งหัวหน้า" ; -- src=panlex
lin archdeacon_N = mkN "อาร์ชดีคอน" ; -- src=panlex
lin archduchess_N = mkN "เจ้าหญิงออสเตรีย" ; -- src=panlex
lin archduke_N = mkN "อาร์คดยุค" | mkN "ตําแหน่งเจ้าชายออสเตรีย" ; -- src=panlex
lin archegonium_N = mkN "อาร์คิโกเนียม" ; -- src=panlex
lin archenteron_N = mkN "อาร์เคนเทอรอน" ; -- src=panlex
lin archer_N = mkN "นักยิงธนู" | mkN "โรบินฮู้ด" | mkN "มือธนู" | mkN "ผู้ยิงธนู" | mkN "ชื่อกลุ่มดาว" ; -- src=panlex
lin archerfish_N = mkN "ปลาอาร์เชอร์ฟิช" ; -- src=panlex
lin archery_N = mkN "กีฬายิงธนู" | mkN "การยิงธนู" | mkN "กลุ่มพลธนู" | mkN "อุปกรณ์การยิงธนู" | mkN "กลุ่มพลธนูอุปกรณ์การยิงธนู" ; -- src=panlex
lin archespore_N = mkN "อาร์คีสปอร์" | mkN "เซลล์แรกเริ่มอันเป็นที่มาของเซลล์สปอร์" ; -- src=panlex
lin archetype_N = mkN "แม่พิมพ์" | mkN "ต้นแบบ" | mkN "แม่แบบ" ; -- src=panlex
lin archidiaconate_N = mkN "ตำแหน่งอาร์ชดีคอน" ; -- src=panlex
lin archil_N = mkN "สีอาร์คิล" ; -- src=panlex
lin archimandrite_N = mkN "เจ้าอาวาส" ; -- src=panlex
lin archine_N = mkN "อาร์เชน" ; -- src=panlex
lin archipelago_N = mkN "หมู่เกาะ" | mkN "กลุ่มเกาะ" | mkN "หมู่เกาะ" | mkN "ทะเลบริเวณที่มีหมู่เกาะ" ; -- src=panlex
lin architectFem_N = variants {} ; ---- sense to be split
lin architectMasc_N = variants {} ; ---- sense to be split
lin architectonics_N = mkN "สถาปัตยกรรมศาสตร์" | mkN "สถาปัตยกรรม" | mkN "วิชาการก่อสร้าง" ; -- src=panlex
lin architectural_A = mkA "เกี่ยวกับสถาปัตยกรรม" ; -- src=panlex
lin architecture_N = mkN "งานสถาปนิก" | mkN "สถาปัตยกรรม" | mkN "สถาปัตยกรรมศาสตร์" | mkN "สถาปัตยกรรมคอมพิวเตอร์" | mkN "สิ่งปลูก สร้าง" | mkN "โครงสร้าง" | mkN "สถาปัตยกรรม" | mkN "งานสถาปัตยกรรม" | mkN "วิชาการก่อสร้าง" | mkN "รูปแบบการก่อสร้าง" | mkN "ผลงานทางสถาปัตยกรรม" ; -- src=panlex
lin architeuthis_N = mkN "ปลาหมึกยักษ์" ; -- src=panlex
lin architrave_N = mkN "บัวปิดแนววงกบ" | mkN "ขอบประตูหรือหน้าต่าง" | mkN "ส่วนล่างสุดของคิ้วบนเสา" ; -- src=panlex
lin archival_A = mkA "เกี่ยวกับหอเก็บเอกสาร" ; -- src=panlex
lin archive_N = mkN "หอจดหมายเหตุ" | mkN "ที่เก็บเอกสารสำคัญ" | mkN "เอกสารสําคัญ" | mkN "สถานที่เก็บเอกสารสําคัญ" ; -- src=panlex
lin archives_N = mkN "การเก็บข้อมูลสำคัญ" ; -- src=panlex
lin archivist_N = mkN "นักจดหมายเหตุ" | mkN "ผู้เก็บและดูแลเอกสารหรือบันทึกสําคัญ" ; -- src=panlex
lin archosaur_N = mkN "อาร์โคซอร์" ; -- src=panlex
lin archpriest_N = mkN "พระราชาคณะ" ; -- src=panlex
lin archway_N = mkN "ทางเดินใต้ประตูโค้ง" | mkN "ทางลอดซุ้ม" | mkN "ส่วนโค้งปิด" ; -- src=panlex
lin arctic_N = mkN "รองเท้ายางกันน้ำ" ; -- src=panlex
lin ardeb_N = mkN "อาร์เดบ" ; -- src=panlex
lin ardent_A = mkA "รุนแรง" | mkA "กระจ่าง" | mkA "ร้อนแรง" | mkA "เร่าร้อน" | mkA "สว่างสดใส" | mkA "กระตือรือร้น" | mkA "มีอารมณ์เร่าร้อน" ; -- src=panlex
lin ardor_N = mkN "พิศวาส" | mkN "ความพิศวาส" | mkN "ความปรารถนา" | mkN "ความร้อนรุ่ม" | mkN "ความเร่าร้อน" | mkN "ความกระตือรือร้น" | mkN "ความเร่าร้อน" | mkN "อารมณ์ที่รุนแรง" | mkN "ความกระตือรือร้น" ; -- src=panlex
lin ardour_N = mkN "พิศวาส" | mkN "ความพิศวาส" | mkN "ความปรารถนา" | mkN "ความร้อนรุ่ม" | mkN "ความเร่าร้อน" | mkN "ความกระตือรือร้น" | mkN "ความเร่าร้อน" | mkN "อารมณ์ที่รุนแรง" | mkN "ความกระตือรือร้น" ; -- src=panlex
lin arduous_A = mkA "ที่หนัก" | mkA "ที่ยากลำบาก" | mkA "ที่ใช้แรงงานมาก" | mkA "ชัน" | mkA "ยากเข็ญ" | mkA "ตรากตรํา" | mkA "อย่างแรง" | mkA "ยากลําบาก" | mkA "หนักหน่วง" | mkA "เหน็ดเหนื่อย" | mkA "ยากที่จะปีนได้" ; -- src=panlex
lin arduousness_N = mkN "ความยากลำบาก" | mkN "ความยากเข็บ" | mkN "ความยากลําบาก" ; -- src=panlex
lin are_N = mkN "แอ" ; -- src=panlex
lin area_1_N = variants {} ; ---- sense to be split
lin area_2_N = variants {} ; ---- sense to be split
lin area_3_N = variants {} ; ---- sense to be split
lin area_4_N = variants {} ; ---- sense to be split
lin area_5_N = variants {} ; ---- sense to be split
lin area_6_N = variants {} ; ---- sense to be split
lin areaway_N = mkN "ที่ว่างหน้าห้องใต้ดิน" ; -- src=panlex
lin areca_N = mkN "ผลหมาก" | mkN "พืชหมาก" ; -- src=panlex
lin arena_N = mkN "อารีน่า" | mkN "สนามกีฬา" | mkN "สเตเดียม" | mkN "เส้นทางชีวิต" | mkN "เวที" | mkN "สนามกีฬา" | mkN "สังเวียน" | mkN "สถานการณ์" | mkN "สถานที่เกิดเหตุ" | mkN "ช่วงเวลาที่เกิดเหตุ" ; -- src=panlex
lin arenaceous_A = mkA "เหมือนทราย" | mkA "เป็นทราย" | mkA "คล้ายทราย" | mkA "มีถิ่นที่อยู่เป็นทราย" ; -- src=panlex
lin arenavirus_N = mkN "ไวรัสอรีนา" ; -- src=panlex
lin arenicolous_A = mkA "มีทราย" | mkA "อยู่บนทราย" | mkA "เกี่ยวกับทราย" ; -- src=panlex
lin areola_N = mkN "รอบหัวนม" | mkN "ช่องร่างแห" ; -- src=panlex
lin arete_N = mkN "สันเขาที่สูงชัน" | mkN "สันเขาที่สูงชัน" ; -- src=panlex
lin argent_A = mkA "สีเงิน" ; -- src=panlex
lin argent_N = mkN "ธาตุเงิน" | mkN "เนื้อเงินสูง" ; -- src=panlex
lin argentic_A = mkA "ประกอบด้วยเงิน" ; -- src=panlex
lin argentiferous_A = mkA "มีเงินผสม" ; -- src=panlex
lin argentine_N = mkN "ปลาอาร์เจนไทน์" ; -- src=panlex
lin argentinosaur_N = mkN "อาร์เจนติโนซอร์" ; -- src=panlex
lin argentite_N = mkN "อาร์เจนไทต์" | mkN "แร่อาร์เจนไทต์" ; -- src=panlex
lin argentous_A = mkA "ประกอบด้วยเงิน" ; -- src=panlex
lin argillaceous_A = mkA "คล้ายดินเหนียว" | mkA "ประกอบด้วยสารดินเหนียว" | mkA "เกี่ยวกับหรือคล้ายดินเหนียว" ; -- src=panlex
lin argillite_N = mkN "หินอาร์จิลไลต์" ; -- src=panlex
lin arginine_N = mkN "อาร์จีนีน" ; -- src=panlex
lin argon_N = mkN "อาร์กอน" | mkN "ก๊าซอาร์กอน" | mkN "เลขอะตอม 18" ; -- src=panlex
lin argosy_N = mkN "เรือสินค้า" | mkN "กลุ่มเรือสินค้า" | mkN "สินค้าจํานวนมาก" | mkN "เรือสินค้าขนาดใหญ่" ; -- src=panlex
lin argot_N = mkN "ภาษาแสลง" | mkN "ภาษาเฉพาะกลุ่ม" | mkN "ภาษาเฉพาะวงการ" | mkN "ศัพท์เฉพาะกลุ่ม" | mkN "ภาษาลับ" | mkN "ศัพท์ลับ" ; -- src=panlex
lin argue_V = mkV "โต้เถียง" | mkV "เสนอเหตุผลโต้แย้ง" | mkV "เถียง" | mkV "อภิปราย" | mkV "โต้แย้ง" | mkV "โต้เถียง" | mkV "ให้เหตุผล" | mkV "อ้างเหตุผล" ; -- src=panlex
lin argue_V2 = mkV2 "โต้เถียง" ; ---- | mkV "เสนอเหตุผลโต้แย้ง" | mkV "เถียง" | mkV "อภิปราย" | mkV "โต้แย้ง" | mkV "โต้เถียง" | mkV "ให้เหตุผล" | mkV "อ้างเหตุผล" ; -- src=panlex
lin argue_VS = mmkVS "โต้เถียง" ; ---- | mkV "เสนอเหตุผลโต้แย้ง" | mkV "เถียง" | mkV "อภิปราย" | mkV "โต้แย้ง" | mkV "โต้เถียง" | mkV "ให้เหตุผล" | mkV "อ้างเหตุผล" ; -- src=panlex
lin argue_down_V2 = prepV2 OP_argue_V OP_down_Prep ; -- guess-p-verb
lin argue_out_V2 = prepV2 OP_argue_V OP_out_Prep ; -- guess-p-verb
lin argument_N = mkN "เรื่องย่อ" | mkN "การอภิปราย" | mkN "การโต้แย้ง" | mkN "การโต้เถียง" | mkN "พารามิเตอร์" | mkN "อาร์กิวเมนต์" | mkN "เรื่อง" | mkN "เหตุผล" | mkN "การแย้ง" | mkN "ข้อสรุป" | mkN "หลักฐาน" | mkN "การโต้คารม" | mkN "การโต้แย้ง" | mkN "ข้อพิสูจน์" | mkN "การโต้เถียง" | mkN "ข้อเท็จจริง" | mkN "ข้อโต้เถียง" | mkN "การอ้างเหตุผล" | mkN "ขบวนการให้เหตุผล" | mkN "ทัศนคติที่แสดงออกมา" | mkN "ข้อคิดเห็นที่แสดงออกมา" ; -- src=panlex
lin argumentation_N = mkN "การอภิปราย" | mkN "การโต้แย้ง" | mkN "ข้อสรุป" | mkN "ข้ออนุมาน" | mkN "การถกเถียง" | mkN "การอภิปราย" | mkN "ข้อพิสูจน์" | mkN "บทความเชิงอภิปราย" | mkN "ขบวนการโต้เถียงการให้เหตุผล" ; -- src=panlex
lin argumentative_A = mkA "ขัดแย้ง" | mkA "ชอบโต้เถียง" | mkA "เกี่ยวกับโต้เถียง" | mkA "ที่เกี่ยวกับการโต้แย้ง" ; -- src=panlex
lin argus_N = mkN "ผู้สังเกต" | mkN "ยักษ์ 100 ตาในนิยายกรีก" ; -- src=panlex
lin argyle_N = mkN "ลายข้าวหลามตัด" | mkN "เหยือกน้ำเกรวี่" | mkN "ถุงเท้าถักลายข้าวหลามตัด" | mkN "ถุงเ้ท้าถักลายข้าวหลามตัด" ; -- src=panlex
lin argyll_N = mkN "ลายข้าวหลามตัด" | mkN "เหยือกน้ำเกรวี่" | mkN "ถุงเท้าถักลายข้าวหลามตัด" | mkN "ถุงเ้ท้าถักลายข้าวหลามตัด" ; -- src=panlex
lin argyrodite_N = mkN "อาร์จีโรไดต์" | mkN "แร่อาร์จีโรไดต์" ; -- src=panlex
lin aria_N = mkN "ทำนอง" | mkN "ทํานอง" | mkN "ท่วงทํานอง" ; -- src=panlex
lin arid_A = mkA "แล้ง" | mkA "แห้ง" | mkA "แห้งมาก" | mkA "น่าเบื่อ" | mkA "แห้งแล้ง" | mkA "ไม่น่าสนใจ" | mkA "ไม่มีรสชาติ" | mkA "ไม่มีความชื้น" ; -- src=panlex
lin arietta_N = mkN "บทร้องรำพันน้อย" ; -- src=panlex
lin aright_Adv = mkAdv "ถูก" | mkAdv "ถูกต้อง" | mkAdv "อย่างถูกต้อง" | mkAdv "ถูกต้อง" | mkAdv "อย่างถูกต้อง" ; -- src=panlex
lin aril_N = mkN "ปุยหุ้มเมล็ด" | mkN "เยื่อหุ้มเมล็ด" ; -- src=panlex
lin ariose_A = mkA "มีทํานอง" | mkA "คล้ายเพลง" ; -- src=panlex
lin arioso_N = mkN "บทร้องบรรยาย" ; -- src=panlex
lin arise_V = mkV "ยืน" | mkV "ตื่น" | mkV "ก่อกบฏ" | mkV "เป็นผล" | mkV "ตื่นนอน" | mkV "ลุกขึ้น" | mkV "เริ่มต้น" | mkV "ก่อการกบฏ" | mkV "ตื่นบรรทม" | mkV "ผลุบๆโผล่ๆ" | mkV "เคลื่อนขึ้น" | mkV "ตื่นพระบรรทม" | mkV "ขึ้นสูง" | mkV "บังเกิด" | mkV "เกิดขึ้น" | mkV "เคลื่อนที่ขึ้น" | mkV "ลุกขึ้นจากเตียง" ; -- src=panlex
lin arista_N = mkN "หนวดแมลง" | mkN "ส่วนยื่นของเมล็ดข้าว" ; -- src=panlex
lin aristocracy_N = mkN "ชนชั้นสูง" | mkN "คณาธิปไตย" | mkN "ชนชั้นสูง" | mkN "พวกขุนนาง" | mkN "พวกคนชั้นสูง" | mkN "การปกครองของขุนนาง" | mkN "การปกครองโดยชนชั้นสูง" | mkN "สมาชิกของกลุ่มชนชั้นสูง" | mkN "การปกครองที่ผูกขาดโดยหมู่คณะ" | mkN "ประเทศหรือรัฐที่ปกครองโดยชนชั้นสูง" ; -- src=panlex
lin aristocrat_N = mkN "ผู้ดี" | mkN "คนชั้นนำ" | mkN "คนชั้นสูง" | mkN "ชนชั้นสูง" | mkN "ผู้ดี" | mkN "ขุนนาง" | mkN "คนชั้นสูง" | mkN "สมาชิกของชนชั้นสูง" | mkN "ผู้ที่สนับสนุนการปกครองโดยคนชั้นสูง" ; -- src=panlex
lin aristocratic_A = mkA "เกี่ยวกับชนชั้นสูง" | mkA "เกี่ยวกับการปกครองที่ผูกขาดโดยหมู่คณะ" ; -- src=panlex
lin arithmancy_N = mkN "การทํานายด้วยตัวเลข" ; -- src=panlex
lin arithmetic_N = mkN "เลขคณิต" | mkN "เลขคณิต" | mkN "คณิตศาสตร์" ; -- src=panlex
lin arithmetical_A = mkA "เกี่ยวกับเลขคณิต" ; -- src=panlex
lin arithmetician_N = mkN "ผู้ชํานาญเลขคณิต" ; -- src=panlex
lin arity_N = mkN "อาริตี้" | mkN "จำนวนอาร์กิวเมนต์" | mkN "จำนวนอาร์กิวเมนต์ของการดำเนินการ" ; -- src=panlex
lin ark_N = mkN "เรือโนอา" | mkN "เรือโนอา" | mkN "เรือขนาดใหญ่ที่สร้างโดยโนอา ในคัมภีร์ไบเบิล" ; -- src=panlex
lin arm_1_N = variants {} ; ---- sense to be split
lin arm_2_N = variants {} ; ---- sense to be split
lin arm_V = mkV "จัดส่งกำลังพล" | mkV "จัดส่งกำลังทหาร" | mkV "เตรียมเผชิญหน้า" | mkV "พร้อมรบ" | mkV "มีอาวุธ" | mkV "ติดอาวุธ" | mkV "เตรียมอาวุธ" | mkV "เตรียมอุปกรณ์" | mkV "พร้อมสําหรับปฎิบัติหน้าที่" ; -- src=panlex
lin arm_V2 = mkV2 "จัดส่งกำลังพล" ; ---- | mkV "จัดส่งกำลังทหาร" | mkV "เตรียมเผชิญหน้า" | mkV "พร้อมรบ" | mkV "มีอาวุธ" | mkV "ติดอาวุธ" | mkV "เตรียมอาวุธ" | mkV "เตรียมอุปกรณ์" | mkV "พร้อมสําหรับปฎิบัติหน้าที่" ; -- src=panlex
lin armada_N = mkN "กองทัพเรือ" | mkN "กองเรือรบ" | mkN "กองเรือรบใหญ่" ; -- src=panlex
lin armadillo_N = mkN "อาร์มาดิลโล" | mkN "ตัวอาร์มาดิลโล" | mkN "ตัวนิ่ม" | mkN "ตัวนางอาย" ; -- src=panlex
lin armament_N = mkN "การติดอาวุธ" | mkN "ยานเกราะ" | mkN "ยุทธภัณฑ์" | mkN "กําลังทหาร" | mkN "รถหุ้มเกราะ" | mkN "กองทัพติดอาวุธ" | mkN "กําลังทางการรบ" | mkN "อาวุธยุทธภัณฑ์" | mkN "อาวุธยุทโธปกรณ์" | mkN "ขบวนการติดอาวุธสําหรับสงคราม" ; -- src=panlex
lin armature_N = mkN "เกราะ" | mkN "สิ่งที่ใช้ป้องกัน เช่น เกราะ" | mkN "อวัยวะป้องกันภัยของสัตว์" ; -- src=panlex
lin armband_N = mkN "ปลอกแขน" ; -- src=panlex
lin armchair_N = mkN "อาร์มแชร์" | mkN "เก้าอี้เท้าแขน" | mkN "เก้าอี้มีที่วางแขน" | mkN "เก้าอี้ที่มีที่วางแขน" ; -- src=panlex
lin armed_A = mkA "ซึ่งมีแขน" | mkA "ซึ่งมีอาวุธ" | mkA "ซึ่งใช้กองกำลัง" | mkA "ติดอาวุธ" | mkA "ที่มีแขน" ; -- src=panlex
lin armet_N = mkN "หมวกเกราะอาร์เมต" ; -- src=panlex
lin armful_N = mkN "หอบ" | mkN "ปริมาณที่มาก" | mkN "ปริมาณเต็มมือ" | mkN "ปริมาณเต็มแขน" ; -- src=panlex
lin arm_hole_N = mkN "วงแขนเสื้อ" | mkN "รูเปิดที่เสื้อสําหรับสอดแขนได้" ; -- src=panlex
lin armiger_N = mkN "อาร์มิเจอร์" | mkN "คนแบกอาวุธของอัศวิน" ; -- src=panlex
lin armilla_N = mkN "อาร์มิลลา" | mkN "สร้อยอาร์มิลลา" | mkN "ลูกโลกอาร์มิลลา" ; -- src=panlex
lin armillary_A = mkA "เกี่ยวกับกําไลมือ" | mkA "ประกอบด้วยหรือมีรูปเป็นห่วงหรือวงแหวน" ; -- src=panlex
lin arming_N = mkN "การติดอาวุธ" ; -- src=panlex
lin armistice_N = mkN "สัญญาสงบศึก" | mkN "การสงบศึกชั่วคราว" | mkN "การพักรบ" | mkN "การหยุดรบ" | mkN "การสงบศึกชั่วคราว" | mkN "การหยุดรบชั่วคราว" ; -- src=panlex
lin armless_A = mkA "ไม่มีแขน" | mkA "ซึ่งไร้แขน" | mkA "ซึ่งไม่มีแขน" ; -- src=panlex
lin armlet_N = mkN "ปลอกแขน" | mkN "ปลอกแขน" | mkN "แขนเล็ก ๆ" | mkN "กําไลแขน" ; -- src=panlex
lin armlike_A = mkA "คล้ายแขน" ; -- src=panlex
lin armoire_N = mkN "ตู้อาร์มวาร์" | mkN "ตู้ใหญ่ที่มีประตูและหิ้ง" ; -- src=panlex
lin armored_A = mkA "ซึ่งมีเปลือก" | mkA "ซึ่งหุ้มเกราะป้องกัน" ; -- src=panlex
lin armour_N = mkN "เสื้อเกราะ" | mkN "เกราะป้องกัน" | mkN "หน่วยยานเกราะ" | mkN "หนัง" | mkN "อาวุธ" | mkN "เกราะ" | mkN "เปลือก" | mkN "ชุดอาวุธ" | mkN "เสื้อเกราะ" | mkN "สิ่งป้องกัน" | mkN "สิ่งห่อหุ้ม" | mkN "เกราะป้องกัน" | mkN "กองทัพติดอาวุธ" | mkN "อวัยวะป้องกันภัยของสัตว์" ; -- src=panlex
lin armoured_A = mkA "ซึ่งมีเปลือก" | mkA "ซึ่งหุ้มเกราะป้องกัน" | mkA "ติดอาวุธ" | mkA "หุ้มเกราะ" ; -- src=panlex
lin armourer_N = mkN "ช่างทำอาวุธ" | mkN "ทหารซ่อมบำรุงอาวุธยุทโธปกรณ์" | mkN "ผู้ผลิตอาวุธ" | mkN "ทหารฝ่ายสรรพาวุธ" | mkN "ผู้สร้างและซ่อมแซมอาวุธ" ; -- src=panlex
lin armoury_N = mkN "คลัง" | mkN "คลังแสง" | mkN "กรมช่างแสง" | mkN "คลังแสงสรรพาวุธ" | mkN "อาวุธยุทโธปกรณ์" | mkN "โรงงานผลิตอาวุธ" | mkN "คลังแสง" | mkN "ที่เก็บอาวุธ" ; -- src=panlex
lin armpit_N = mkN "รักแร้" | mkN "จั๊กแร้" | mkN "พระกัจฉะ" | mkN "รักแร้" ; -- src=panlex
lin armrest_N = mkN "เท้าแขน" | mkN "ที่เท้าแขน" | mkN "ที่พักแขน" | mkN "ที่วางแขน" | mkN "ที่เท้าแขน" ; -- src=panlex
lin army_N = mkN "ทัพบก" | mkN "กองทัพบก" | mkN "กอง" | mkN "ทัพ" | mkN "กลุ่ม" | mkN "ฝูงชน" | mkN "กองทัพ" | mkN "กลุ่มคน" | mkN "กองทหาร" | mkN "กองทหาร ฝึกและติดอาวุธเพื่อสงคราม" | mkN "กองทัพบก" | mkN "กองทหารบก" | mkN "กลุ่มคนขนาดใหญ่" ; -- src=panlex
lin armyworm_N = mkN "หนอนกระทู้คอรวง" ; -- src=panlex
lin arnica_N = mkN "อาร์นิกา" | mkN "ยาอาร์นิกา" | mkN "ต้นดอกยานภูเขาทอง" | mkN "ทิงคเจอร์ผสมดอกยานภู่เขาทอง" ; -- src=panlex
lin aroma_N = mkN "กลิ่น" | mkN "กลิ่นหอม" | mkN "สมบัติของกลิ่น" | mkN "ความหอม" | mkN "กลิ่นหอม" ; -- src=panlex
lin aromatic_A = mkA "ที่มีกลิ่นหอม" | mkA "หอม" | mkA "ที่มีกลิ่มหอม" | mkA "ซึ่งมีกลิ่นหอม" ; -- src=panlex
lin around_Adv = mkAdv "หัน" | mkAdv "ทั่ว" | mkAdv "รอบๆ" | mkAdv "ประมาณ" | mkAdv "รอบ" | mkAdv "ราว" | mkAdv "กลับ" | mkAdv "ผ่าน" | mkAdv "รอบๆ" | mkAdv "ราวๆ" | mkAdv "ใกล้ๆ" | mkAdv "ไปยัง" | mkAdv "วกกลับ" | mkAdv "โดยรอบ" | mkAdv "อ้อมรอบ" | mkAdv "อยู่รอบ ๆ" | mkAdv "อ้อมผ่าน" | mkAdv "โดยประมาณ" | mkAdv "ไม่ไกลนัก" ; -- src=panlex
lin around_Prep = mkPrep "รอบ" | mkPrep "ราว" | mkPrep "กลับ" | mkPrep "ผ่าน" | mkPrep "รอบๆ" | mkPrep "ราวๆ" | mkPrep "ประมาณ" | mkPrep "วกกลับ" | mkPrep "โดยรอบ" | mkPrep "อ้อมรอบ" | mkPrep "อยู่รอบ ๆ" | mkPrep "อ้อมผ่าน" ; -- src=panlex
lin arousal_N = mkN "การตื่น" | mkN "การเร้า" | mkN "การกระตุ้น" | mkN "การเล้าโลม" | mkN "การเล้ัาโลม" ; -- src=panlex
lin arpeggio_N = mkN "อาร์เพคจิโอ" ; -- src=panlex
lin arpent_N = mkN "อาร์เพนท์" ; -- src=panlex
lin arquebus_N = mkN "ปืนอาร์เคอบัส" ; -- src=panlex
lin arrack_N = mkN "น้ำตาลเมา" | mkN "น้ําตาลเมา" | mkN "เหล้าชนิดหนึ่งในประเทศมุสลิม" ; -- src=panlex
lin arraignment_N = mkN "หมายศาล" | mkN "การกล่าวหา" | mkN "การนําตัวมาขึ้นศาล" | mkN "ภาวะที่ถูกกล่าวหาหรือถูกนําตัวมาขึ้นศาล" ; -- src=panlex
lin arrange_V = mkV "จัด" | mkV "ทำผม" | mkV "ลำดับ" | mkV "เซตผม" | mkV "แต่งผม" | mkV "ฟอร์แมต" | mkV "เซ็ตอัป" | mkV "จัดรูปแบบ" | mkV "จัดเตรียม" | mkV "เรียงร้อย" | mkV "จัดฟอร์แมต" | mkV "เรียบเรียง" | mkV "จัดเป็นระบบ" | mkV "ลำดับเรื่อง" | mkV "ลำดับความคิด" | mkV "จัดให้เป็นระบบ" | mkV "เรียบเรียงดนตรี" | mkV "จัดให้เป็นระเบียบ" | mkV "จัดเตรียม" | mkV "เตรียมการ" ; -- src=panlex
lin arrange_V2 = mkV2 "จัด" ; ---- | mkV "ทำผม" | mkV "ลำดับ" | mkV "เซตผม" | mkV "แต่งผม" | mkV "ฟอร์แมต" | mkV "เซ็ตอัป" | mkV "จัดรูปแบบ" | mkV "จัดเตรียม" | mkV "เรียงร้อย" | mkV "จัดฟอร์แมต" | mkV "เรียบเรียง" | mkV "จัดเป็นระบบ" | mkV "ลำดับเรื่อง" | mkV "ลำดับความคิด" | mkV "จัดให้เป็นระบบ" | mkV "เรียบเรียงดนตรี" | mkV "จัดให้เป็นระเบียบ" | mkV "จัดเตรียม" | mkV "เตรียมการ" ; -- src=panlex
lin arrangement_N = mkN "การจัดระเบียบ" | mkN "การเรียบเรียง" | mkN "การจัดการพื้นที่" | mkN "การเรียบเรียงดนตรี" | mkN "การจัด" | mkN "การจัดการ" | mkN "การจัดเตรียม" | mkN "การตระเตรียม" | mkN "ลักษณะการจัด" | mkN "ภาวะที่ถูกจัด" | mkN "เพลงที่ได้มีการปรับปรุงใหม่" ; -- src=panlex
lin arranger_N = mkN "ผู้เรียบเรียง" ; -- src=panlex
lin arrant_A = mkA "ตลอด" | mkA "ร้ายกาจ" | mkA "อย่างมาก" | mkA "เหลือเกิน" | mkA "อย่างที่สุด" | mkA "โดยสิ้นเชิง" ; -- src=panlex
lin arras_N = mkN "พรมแขวนผนัง" | mkN "ผืนพรมทอประดับผนัง" | mkN "พรมปัก" | mkN "ม่านปัก" | mkN "สิ่งปักที่แขวนกับผนัง" | mkN "สิ่งทอสําหรับแขวนบนฝาผนัง" ; -- src=panlex
lin array_N = mkN "อาร์เรย์" | mkN "การจัดแสดง" | mkN "เครื่องนุ่งห่ม" | mkN "เครื่องแต่งกาย" | mkN "การจัดการพื้นที่ทางอากาศ" | mkN "ทิว" | mkN "แถว" | mkN "ขบวน" | mkN "ลําดับ" | mkN "จัดเรียง" | mkN "ตั้งแนวรบ" | mkN "เครื่องแต่งกาย" | mkN "การจัดเรียงตามลําดับ" ; -- src=panlex
lin arrears_N = mkN "หนี้ค้างชำระ" | mkN "หนี้ค้างชําระ" | mkN "เงินค้างชําระ" ; -- src=panlex
lin arrest_N = mkN "การหยุด" | mkN "การจับกุม" | mkN "การหยุดชะงัก" | mkN "การลากคอเข้าคุก" | mkN "การชะงัก" | mkN "การจับกุม" | mkN "การหยุดอย่างกระทันหัน" ; -- src=panlex
lin arresting_A = mkA "ซึ่งจับกุม" | mkA "ซึ่งดึงดูดความสนใจ" ; -- src=panlex
lin arrival_N = mkN "การมาถึง" | mkN "ผู้มาถึง" | mkN "การมาถึง" | mkN "ผู้ที่มาถึง" | mkN "ผู้ที่มาใหม่" | mkN "สิ่งที่ปรากฎ" | mkN "การได้บรรลุถึง" ; -- src=panlex
lin arrive_V = mkV "มาถึง" | mkV "ทำสำเร็จ" | mkV "มาถึงความสำเร็จ" | mkV "ถึง" | mkV "ลุุ" | mkV "เกิด" | mkV "บรรลุ" | mkV "ปรากฏ" | mkV "มาถึง" | mkV "มีใช้" | mkV "เริ่ม" | mkV "ส่งถึง" | mkV "กําเนิด" | mkV "เริ่มต้น" | mkV "หาทางออกได้" | mkV "แก้ปัญหาได้" ; -- src=panlex
lin arroba_N = mkN "อาร์โรบา" | mkN "หน่วยน้ําหนักของสเปนและปอร์ตุเกส" ; -- src=panlex
lin arrogance_N = mkN "ความหยิ่งยโส" | mkN "ความยโส" | mkN "ความทะนง" | mkN "ความหยิ่ง" | mkN "ความจองหอง" | mkN "ความเย่อหยิ่ง" ; -- src=panlex
lin arrogant_A = mkA "ยโส" | mkA "ทะนง" | mkA "ทระนง" | mkA "วางโต" | mkA "หยิ่ง" | mkA "โอหัง" | mkA "จองหอง" | mkA "ถือตัว" | mkA "อหังการ" ; -- src=panlex
lin arrondissement_N = mkN "ท้องถิ่นการปกครอง" ; -- src=panlex
lin arrow_N = mkN "ศร" | mkN "ลูกศร" | mkN "ศรชี้" | mkN "ลูกธนู" | mkN "พระแสงศร" | mkN "ลูกศรชี้" | mkN "ลูกเกาทัณฑ์" | mkN "ลูกศร" | mkN "ลูกดอก" | mkN "ลูกธนู" | mkN "เกาทัณฑ์" | mkN "ลูกศรชี้ทิศทาง" | mkN "สัญลักษณ์รูปลูกศร" | mkN "สิ่งที่คล้ายลูกศร" ; -- src=panlex
lin arrowhead_N = mkN "หัวลูกธนู" | mkN "หัวลูกศร" | mkN "พืชจําพวก เห็ดเมตตา" | mkN "สิ่งที่คล้ายลูกศร" ; -- src=panlex
lin arrowroot_N = mkN "ต้นสามสิบ" | mkN "แป้งของพืชจําพวก ดังกล่าว" | mkN "ต้นไม้เท้ายายม่อม" | mkN "แป้งไม้เท้ายายม่อม" ; -- src=panlex
lin arroyo_N = mkN "ลำธาร" ; -- src=panlex
lin arse_N = mkN "ก้น" | mkN "ตูด" | mkN "รูตูด" | mkN "บั้นท้าย" | mkN "ประตูหลัง" ; -- src=panlex
lin arsehole_N = mkN "ตูด" | mkN "รูตูด" | mkN "ประตูหลัง" ; -- src=panlex
lin arsenal_N = mkN "คลังแสง" | mkN "กรมช่างแสง" | mkN "คลังแสงสรรพาวุธ" | mkN "อาวุธยุทโธปกรณ์" | mkN "โรงงานผลิตอาวุธ" | mkN "คลังสรรพาวุธ" | mkN "คลังแสงสรรพาวุธ" ; -- src=panlex
lin arsenate_N = mkN "อาร์เซเนต" | mkN "เกลือของกรดสารหนู" ; -- src=panlex
lin arsenic_N = mkN "สารหนู" | mkN "ธาตุอาร์ซีนิก" | mkN "เลขอะตอม 33" | mkN "สารหนู" | mkN "เกี่ยวกับสารหนู" ; -- src=panlex
lin arsenical_N = mkN "สารหนู" ; -- src=panlex
lin arsenide_N = mkN "อาร์เซไนด์" ; -- src=panlex
lin arsenopyrite_N = mkN "อาร์ซิโนไพไรต์" | mkN "แร่อาร์ซิโนไพไรต์" ; -- src=panlex
lin arsine_N = mkN "อาร์ซีน" ; -- src=panlex
lin arson_N = mkN "การวางเพลิง" | mkN "การลอบวางเพลิง" | mkN "เผา" | mkN "วางเพลิง" | mkN "การลอบวางเพลิง" ; -- src=panlex
lin arsonist_N = mkN "มือเพลิง" | mkN "คนวางเพลิง" | mkN "มือวางเพลิง" | mkN "คนลอบวางเพลิง" | mkN "โจรลอบวางเพลิง" | mkN "นักวางเพลิง" | mkN "ผู้ที่ลอบวางเพลิง" ; -- src=panlex
lin art_N = mkN (thword "ศิล" "ปะ") | {-pan-} mkN "ศิลปะ" | mkN "งานศิลปะ" | mkN "งานศิลป์" | mkN "ภาพประกอบ" | mkN "ไฟน์อาร์ท" | mkN "ผลงานศิลปะ" | mkN "การสร้างงานศิลปะ" | mkN "ศิลป" | mkN "ทักษะ" | mkN "ศิลป์" | mkN "งานศิลปะ" | mkN "งานศิลป์" | mkN "ศิลปกรรม" | mkN "ความสามารถ" | mkN "ทักษะทางศิลปะ" | mkN "ผลงานทางศิลปะ" ; -- src=panlex
lin artefact_N = mkN "สิ่งของ" | mkN "สิ่งประดิษฐ์" | mkN "สิ่งที่มนุษย์ประดิษฐ์ขึ้น" ; -- src=panlex
lin artemisia_N = mkN "ต้นอาร์ตีมิเซีย" | mkN "พืชจําพวกหนึ่ง" ; -- src=panlex
lin arterial_A = mkA "เกี่ยวกับเส้นโลหิตแดงใหญ่" | mkA "เกี่ยวกับทางใหญ่หรือทางสําคัญ" | mkA "เกี่ยวกับเส้นเลือดแดงที่นําเลือดแดงออกจากหัวใจ" ; -- src=panlex
lin arteriogram_N = mkN "อาร์ทีริโอแกรม" ; -- src=panlex
lin arteritis_N = mkN "ภาวะเส้นโลหิตแดงอักเสบ" ; -- src=panlex
lin artery_N = mkN "เส้นเลือด" | mkN "หลอดเลือดแดง" | mkN "เส้นเลือดแดง" | mkN "ทางสําคัญ" | mkN "เส้นเลือด" | mkN "เส้นโลหิต" | mkN "เส้นทางหลัก" | mkN "หลอดเลือดแดง" | mkN "หลอดโลหิตแดง" | mkN "เส้นโลหิตแดง" | mkN "เส้นเลือดแดงที่นําเลือดแดงออกจากหัวใจ" ; -- src=panlex
lin artful_A = mkA "มีเลศนัย" | mkA "ไม่จริงใจ" | mkA "ฉลาด" | mkA "เก่ง" | mkA "ชํานาญ" | mkA "มีทักษะ" | mkA "มีเล่ห์เหลี่ยม" | mkA "เต็มไปด้วยเล่ห์" ; -- src=panlex
lin artfulness_N = mkN "ความมีเล่ห์เหลี่ยม" | mkN "ความมีทักษะ" ; -- src=panlex
lin arthritic_N = mkN "คนเป็นโรคข้ออักเสบ" | mkN "ผู้เป็นโรคข้ออักเสบ" ; -- src=panlex
lin arthritis_N = mkN "ข้อต่ออักเสบ" | mkN "ข้อต่ออักเสบ" | mkN "ภาวะข้อต่ออักเสบ" ; -- src=panlex
lin arthrogram_N = mkN "อาร์โทรแกรม" ; -- src=panlex
lin arthropathy_N = mkN "โรคข้อ" ; -- src=panlex
lin arthropod_N = mkN "สัตว์ขาปล้อง" ; -- src=panlex
lin arthroscope_N = mkN "กล้องข้อเข่า" ; -- src=panlex
lin arthroscopy_N = mkN "สันธิทรรศนา" | mkN "การส่องกล้องในข้อ" ; -- src=panlex
lin arthrospore_N = mkN "อาร์โทรสปอร์" ; -- src=panlex
lin artichoke_N = mkN "อาร์ติโชค" | mkN "ต้นอาร์ติโชค" ; -- src=panlex
lin article_N = mkN "ของ" | mkN "มาตรา" | mkN "บทความ" | mkN "หัวข้อ" | mkN "ของ" | mkN "ข้อ" | mkN "ชิ้น" | mkN "ฟ้อง" | mkN "สิ่ง" | mkN "พัสดุ" | mkN "มาตรา" | mkN "วัตถุ" | mkN "วัสดุ" | mkN "บทความ" | mkN "รายการ" | mkN "สินค้า" | mkN "ข้อย่อย" | mkN "ข้าวของ" | mkN "สิ่งของ" | mkN "อนุมาตรา" | mkN "ข้อบังคับ" | mkN "ผลิตภัณฑ์" | mkN "เครื่องใช้" | mkN "ทําให้ข้อบังคับผูกมัด" | mkN "คํานําหน้านามในภาษาอังกฤษ" ; -- src=panlex
lin articular_A = mkA "เกี่ยกับข้อต่อ" | mkA "เกี่ยวกับข้อต่อ" ; -- src=panlex
lin articulate_A = mkA "ชัดเจน" | mkA "ต่อกัน" | mkA "เป็นข้อ" | mkA "เป็นปล้อง" | mkA "สามารถพูดได้" | mkA "พูดอย่างชัดเจน" | mkA "ออกเสียงชัดเจน" | mkA "ที่มีส่วนเชื่อมต่อ" | mkA "ที่เกิดจากคําที่มีความหมาย" ; -- src=panlex
lin articulate_V = mkV "ออกเสียง" | mkV "พูดชัดเจน" | mkV "เชื่อมต่อ" | mkV "ใส่ข้อต่อ" | mkV "พูดเสียงดังชัดเจน" | mkV "ประกบ" | mkV "สื่อสาร" | mkV "เชื่อมต่อ" | mkV "พูดเสียงดังชัดเจน" ; -- src=panlex
lin articulate_V2 = mkV2 "ออกเสียง" ; ---- | mkV "พูดชัดเจน" | mkV "เชื่อมต่อ" | mkV "ใส่ข้อต่อ" | mkV "พูดเสียงดังชัดเจน" | mkV "ประกบ" | mkV "สื่อสาร" | mkV "เชื่อมต่อ" | mkV "พูดเสียงดังชัดเจน" ; -- src=panlex
lin articulation_N = mkN "ข้อต่อ" | mkN "ปล้อง" | mkN "ข้อต่อ" | mkN "การต่อกัน" | mkN "การออกเสียง" | mkN "การออกสําเนียง" | mkN "การเชื่อมประกบ" | mkN "เสียงที่เปล่งออกมา" | mkN "กระบวนการพูดได้อย่างชัดเจน" ; -- src=panlex
lin articulator_N = mkN "ฐานกรณ์" | mkN "ผู้เปล่งเสียง" | mkN "อวัยวะที่ใช้สําหรับพูด" | mkN "สิ่งที่มีเสียงที่ชัดเจน" | mkN "ผู้ที่พูดหรือออกเสียงได้ชัดเจน" ; -- src=panlex
lin artifact_N = mkN "สิ่งของ" | mkN "สิ่งประดิษฐ์" | mkN "สิ่งที่มนุษย์ประดิษฐ์ขึ้น" | mkN "สิ่งประดิษฐ์" | mkN "สิ่งประดิษฐ์ด้วยฝีมือคน" ; -- src=panlex
lin artifice_N = mkN "เล่ห์กล" | mkN "ทักษะ" | mkN "อุบาย" | mkN "เล่ห์" | mkN "กลวิธี" | mkN "กลเม็ด" | mkN "กลยุทธ์" | mkN "กลอุบาย" | mkN "ชั้นเชิง" | mkN "ความชํานาญ" | mkN "เล่ห์เหลี่ยม" ; -- src=panlex
lin artificer_N = mkN "ช่าง" | mkN "นายช่าง" | mkN "ช่างฝีมือ" | mkN "ช่างศิลป์" | mkN "นักประดิษฐ์" | mkN "ทหารซ่อมบำรุงอาวุธยุทโธปกรณ์" ; -- src=panlex
lin artificial_A = mkA "ซึ่งประดิษฐ์ขึ้น" | mkA "ปลอม" | mkA "เทียม" | mkA "ไม่แท้" | mkA "ทําขึ้นเอง" | mkA "สังเคราะห์" | mkA "ซึ่งไม่จริงใจ" | mkA "ประดิษฐ์ขึ้นเอง" | mkA "ซึ่งประดิษฐ์ขึ้น" | mkA "ซึ่งไม่ซื่อสัตย์" | mkA "ซึ่งมนุษย์ทําขึ้น" | mkA "ซึ่งไม่เป็นไปตามธรรมชาติ" ; -- src=panlex
lin artillery_N = mkN "ปืนใหญ่" | mkN "อาวุธหนัก" | mkN "ทหารปืนใหญ่" | mkN "ปืนใหญ่" | mkN "ปืนใหญ่กองทหารปืนใหญ่" | mkN "วิชาเกี่ยวกับการใช้ปืนใหญ่" ; -- src=panlex
lin artilleryman_N = mkN "ทหารปืนใหญ่" | mkN "ทหารปืนใหญ่ชั้นประทวน" | mkN "ทหารปืนใหญ่" | mkN "ผู้ยิงด้วยปืนใหญ่" ; -- src=panlex
lin artisan_N = mkN "ช่าง" | mkN "นายช่าง" | mkN "ช่างฝีมือ" | mkN "ช่างศิลป์" | mkN "นายช่าง" | mkN "ช่างฝีมือ" ; -- src=panlex
lin artist_N = mkN "ศิลปิน" | mkN "อาร์ติสต์" | mkN "คนทำงานสร้างสรรค์" | mkN "คนผลิตงานสร้างสรรค์" | mkN "จิตรกร" | mkN "ศิลปิน" | mkN "นักแสดง" | mkN "นักศิลปะ" | mkN "ช่างฝีมือ" | mkN "ช่างเขียน" | mkN "ผู้มีฝีมือ" | mkN "ผู้เชี่ยวชาญ" | mkN "ผู้ที่มีทักษะ" ; -- src=panlex
lin artiste_N = mkN "นักแสดงในที่สาธารณะ" | mkN "นักศิลปะ" ; -- src=panlex
lin artistic_A = mkA "ทางศิลปะ" | mkA "อันงดงาม" | mkA "ที่มีศิลปะ" | mkA "มีศิลปะ" | mkA "มีรสนิยม" | mkA "วิจิตรศิลป์" | mkA "ผู้ที่ใช้เล่ห์" | mkA "เกี่ยวกับศิลปะ" | mkA "ชอบหรือรักในศิลปะ" ; -- src=panlex
lin artistry_N = mkN "ศิลปะ" | mkN "ศิลปะกรรม" | mkN "ผลของศิลปะ" | mkN "ลักษณะศิลปะ" | mkN "คุณภาพของศิลปะ" | mkN "ความสามารถในทางศิลปะ" ; -- src=panlex
lin artless_A = mkA "เป็นธรรมชาติ" | mkA "ที่ไม่มีศิลปะ" | mkA "ไม่มีเล่ห์เหลี่ยม" | mkA "เลว" | mkA "ซื่อ" | mkA "หยาบ" | mkA "ไร้มารยา" | mkA "ไร้ศิลปะ" | mkA "ไม่มีเล่ห์" | mkA "ที่ไม่มีศิลปะ" | mkA "ไร้ความชํานาญ" ; -- src=panlex
lin artlessness_N = mkN "ความเป็นธรรมชาติ" ; -- src=panlex
lin artwork_N = mkN "งานศิลปะ" | mkN "ภาพประกอบ" | mkN "งานด้านศิลปะ" ; -- src=panlex
lin arty_A = mkA "ที่มีความเป็นศิลปะ" | mkA "มีลักษณะโอ้อวดทางศิลปะ" ; -- src=panlex
lin arum_N = mkN "ต้นอะรัม" | mkN "พืชจําพวก กนกนารี" | mkN "แป้งเท้ายายม่อม" ; -- src=panlex
lin arundinaceous_A = mkA "เต็มไปด้วยหญ้า" | mkA "เกี่ยวกับหรือคล้ายไม้จําพวกอ้อ" ; -- src=panlex
lin aryanFem_N = variants {} ; ---- sense to be split
lin aryanMasc_N = variants {} ; ---- sense to be split
lin aryan_A = mkA "ชาวอารยัน" | mkA "ภาษาอาหรับ" | mkA "เกี่ยวกับอารยัน" ; -- src=panlex
lin arytenoid_N = mkN "กระดูกอ่อนแอริทินอยด์" ; -- src=panlex
lin as_CAdv = {s = thword "เท่า" ; p = "กับ"} ; ----
lin as_Prep = mkPrep "ตาม" | mkPrep "เช่น" | mkPrep "ฉันใด" | mkPrep "อย่าง" | mkPrep "ดังที่" | mkPrep "ดุจดัง" | mkPrep "ตามที่" | mkPrep "เหมือน" | mkPrep "ในฐานะ" | mkPrep "ในบทบาท" | mkPrep "ในข้อนี้" | mkPrep "ในฐานะที่" | mkPrep "ดูประหนึ่ง" | mkPrep "ในตําแหน่ง" | mkPrep "เช่นเดียวกับ" ; -- src=panlex
lin asafetida_N = mkN "อะซาเฟทิดา" ; -- src=panlex
lin asana_N = mkN "ท่าอาสนะ" ; -- src=panlex
lin asarabacca_N = mkN "ต้นอะซาราแบคกา" ; -- src=panlex
lin asbestos_N = mkN "แร่ใยหิน" | mkN "ใยหิน" | mkN "แร่ใยหิน" | mkN "เยื่อหินทนไฟ" ; -- src=panlex
lin asbestosis_N = mkN "โรคปอดชนิดหนึ่ง" ; -- src=panlex
lin ascariasis_N = mkN "โรคพยาธิไส้เดือน" ; -- src=panlex
lin ascend_V = mkV "ขึ้น" | mkV "ไต่ขึ้น" | mkV "เลื้อยขึ้น" | mkV "ขึ้นครองราชย์" | mkV "ปีน" | mkV "ขึ้น" | mkV "ขึ้นสูง" | mkV "ปีนขึ้น" | mkV "รับตําแหน่ง" | mkV "ขึ้นครองราชย์" | mkV "เคลื่อนที่ไปยัง" ; -- src=panlex
lin ascend_V2 = mkV2 "ขึ้น" ; ---- | mkV "ไต่ขึ้น" | mkV "เลื้อยขึ้น" | mkV "ขึ้นครองราชย์" | mkV "ปีน" | mkV "ขึ้น" | mkV "ขึ้นสูง" | mkV "ปีนขึ้น" | mkV "รับตําแหน่ง" | mkV "ขึ้นครองราชย์" | mkV "เคลื่อนที่ไปยัง" ; -- src=panlex
lin ascendancy_N = mkN "การมีอำนาจ" | mkN "ภาวะมีอํานาจ" | mkN "ภาวะขึ้นครองตําแหน่ง" ; -- src=panlex
lin ascendant_A = mkA "ขึ้น" ; -- src=panlex
lin ascendant_N = mkN "บรรพชน" | mkN "ปู่ยาตายาย" | mkN "เทือกเถาเหล่ากอ" | mkN "อํานาจ" | mkN "อิทธิพล" | mkN "ก้าวหน้า" | mkN "มีอํานาจ" | mkN "ฐานะได้เปรียบ" | mkN "มีอิทธิพลเหนือ" | mkN "ตําแหน่งที่ครอง" ; -- src=panlex
lin ascendency_N = mkN "การมีอำนาจ" ; -- src=panlex
lin ascendent_N = mkN "บรรพชน" | mkN "ปู่ยาตายาย" | mkN "เทือกเถาเหล่ากอ" | mkN "อํานาจ" | mkN "อิทธิพล" | mkN "ก้าวหน้า" | mkN "มีอํานาจ" | mkN "ฐานะได้เปรียบ" | mkN "มีอิทธิพลเหนือ" | mkN "ตําแหน่งที่ครอง" ; -- src=panlex
lin ascender_N = mkN "อักษรที่มีหางขึ้น" | mkN "ผู้ขึ้นครองอำนาจ" | mkN "ผู้ขึ้นครองอํานาจ" | mkN "ผู้ขึ้นครองตําแหน่ง" ; -- src=panlex
lin ascension_N = mkN "การขึ้น" ; -- src=panlex
lin ascent_N = mkN "การขึ้น" | mkN "ชันขึ้น" | mkN "การค่อยๆเพิ่ม" | mkN "การปีน" | mkN "ทางชัน" | mkN "การขึ้น" | mkN "การเคลื่อนขึ้น" | mkN "การย้อนไปในอดีต" | mkN "การขึ้นสู่ที่สูงกว่า" ; -- src=panlex
lin ascetic_A = mkA "ตามหลักศาสนา" | mkA "ที่เข้มงวดกับตนเอง" | mkA "ที่เข้มงวดกับตัวเอง" | mkA "เข้มงวด" | mkA "เคร่งครัด" | mkA "เกี่ยวกับการบําเพ็ญตนอย่างเคร่งครัด" ; -- src=panlex
lin ascetic_N = mkN "นักบวช" | mkN "บําเพ็ญตบะ" | mkN "ผู้ถือสันโดษ" | mkN "ผู้บําเพ็ญตบะ" ; -- src=panlex
lin asceticism_N = mkN "พรตนิยม" | mkN "ความเคร่งครัด" ; -- src=panlex
lin ascidian_N = mkN "แอสซิเดียน" ; -- src=panlex
lin ascites_N = mkN "โรคท้องมาน" ; -- src=panlex
lin asclepiad_N = mkN "ต้นแอสคลีเพียด" ; -- src=panlex
lin ascocarp_N = mkN "แอสโคคาร์พ" ; -- src=panlex
lin ascoma_N = mkN "แอสโคมา" ; -- src=panlex
lin ascomycete_N = mkN "แอสโคไมซีต" ; -- src=panlex
lin ascospore_N = mkN "แอสโคสปอร์" ; -- src=panlex
lin ascot_N = mkN "แอสคอต" ; -- src=panlex
lin ascription_N = mkN "การให้เหตุผล" | mkN "การลงความเห็นว่าเป็นของ" ; -- src=panlex
lin ascus_N = mkN "แอสกัส" ; -- src=panlex
lin asdic_N = mkN "เครื่องหยั่งความลึกน้ำ" | mkN "เครื่องหยั่งน้ำแบบเสียงสะท้อน" | mkN "เครื่องหยั่งน้ำแบบสัญญาณสะท้อนกลับ" ; -- src=panlex
lin asepsis_N = mkN "การป้องกันเชื้อโรค" | mkN "วิธีการทําให้ปราศจากเชื้อโรค" | mkN "ภาวะปราศจากเชื้อโรคหรือจุลินทรีย์" ; -- src=panlex
lin aseptic_A = mkA "ซึ่งปราศจากเชื้อโรคหรือจุลินทรีย์" ; -- src=panlex
lin asexual_A = mkA "แบบไม่อาศัยเพศ" | mkA "ไร้เพศ" ; -- src=panlex
lin asexuality_N = mkN "ความไม่มีเพศ" ; -- src=panlex
lin ash_N = mkN "เถ้า" | mkN "ไม้แอช" | mkN "ขี้เถ้า" | mkN "ต้นมะกอก" | mkN "เถ้าถ่าน" | mkN "อัฐิ" | mkN "เถ้า" | mkN "ขี้เถ้า" | mkN "เถ้าถ่าน" ; -- src=panlex
lin ashamed_A = mkA "อาย" | mkA "อับอาย" | mkA "กระดากใจ" | mkA "ซึ่งละอายใจ" | mkA "ที่รู้สึกผิด" | mkA "ไม่เต็มใจเพราะกลัวถูกหัวเราะหรือต่อว่า" ; -- src=panlex
lin ashcake_N = mkN "แอชเค้ก" ; -- src=panlex
lin ash_can_N = mkN "ถังขยะ" | mkN "ถังขยะ" | mkN "ภาชนะโลหะใส่เถ้า" ; -- src=panlex
lin ashen_A = mkA "ไม้แอช" | mkA "ซีด" | mkA "ถอดสี" | mkA "ซีดเผือด" ; -- src=panlex
lin ashes_N = mkN (thword "เถ้า") ;
lin ashlar_N = mkN "แอชลาร์" ; -- src=panlex
lin ashore_Adv = mkAdv "เทียบฝั่ง" | mkAdv "เกยฝั่ง" | mkAdv "เทียบฝั่ง" ; -- src=panlex
lin ashram_N = mkN "อาศรม" | mkN "สถานที่สอนศาสนาฮินดู" ; -- src=panlex
lin ashtray_N = mkN "ที่เขี่ยบุหรี่" | mkN "ที่เขี่ยบุหรี่" | mkN "ที่ใส่ขี้บุหรี่หรือซิการ์" ; -- src=panlex
lin ashy_A = mkA "ขี้เถ้า" | mkA "ที่มีสีขี้เถ้า" | mkA "ซีด" | mkA "คล้ายเถ้า" | mkA "สีเถ้าถ่าน" | mkA "คลุมด้วยขี้เถ้า" | mkA "ที่ปกคลุมด้วยเถ้าถ่าน" ; -- src=panlex
lin aside_Adv = mkAdv "สำรอง" | mkAdv "แยกจาก" | mkAdv "ในทิศทางอื่น" | mkAdv "โดยไม่พิจารณา" | mkAdv "กันไว้ด้านหนึ่ง" | mkAdv "ข้างๆ" | mkAdv "สํารอง" | mkAdv "ออกไปจาก" | mkAdv "ออกไปจากใจ" | mkAdv "ไปด้านข้าง" | mkAdv "เก็บเอาไว้ใช้" | mkAdv "ออกไปจากความคิด" ; -- src=panlex
lin aside_N = mkN "ข้อความในวงเล็บ" | mkN "เรื่องนอกประเด็น" | mkN "การพูดกับคนดูโดยเฉพาะ" ; -- src=panlex
lin asinine_A = mkA "โง่" | mkA "คล้ายลา" | mkA "ไม่ฉลาด" ; -- src=panlex
lin asininity_N = mkN "ความโง่งม" ; -- src=panlex
lin ask_V = mkV "ถาม" | mkV "ซักถาม" | mkV "ต้องการ" | mkV "เรียกราคา" | mkV "เรียกร้อง" | mkV "เรียกเงิน" | mkV "ขอ" | mkV "ถาม" | mkV "เชิญ" | mkV "ขอราคา" | mkV "ขอร้อง" | mkV "ต้องการ" | mkV "บอกราคา" | mkV "ประสงค์" | mkV "เชื้อเชิญ" | mkV "เสนอราคาที่ต้องการ" ; -- src=panlex
lin ask_V2 = mkV2 "ถาม" ; ---- | mkV "ซักถาม" | mkV "ต้องการ" | mkV "เรียกราคา" | mkV "เรียกร้อง" | mkV "เรียกเงิน" | mkV "ขอ" | mkV "ถาม" | mkV "เชิญ" | mkV "ขอราคา" | mkV "ขอร้อง" | mkV "ต้องการ" | mkV "บอกราคา" | mkV "ประสงค์" | mkV "เชื้อเชิญ" | mkV "เสนอราคาที่ต้องการ" ; -- src=panlex
lin ask_V2Q = regV "ถาม" ** {c2 = []} ;
lin ask_V2V = mmkV2V "ถาม" ; ---- | mkV "ซักถาม" | mkV "ต้องการ" | mkV "เรียกราคา" | mkV "เรียกร้อง" | mkV "เรียกเงิน" | mkV "ขอ" | mkV "ถาม" | mkV "เชิญ" | mkV "ขอราคา" | mkV "ขอร้อง" | mkV "ต้องการ" | mkV "บอกราคา" | mkV "ประสงค์" | mkV "เชื้อเชิญ" | mkV "เสนอราคาที่ต้องการ" ; -- src=panlex
lin ask_VQ = mmkVQ "ถาม" ; ---- | mkV "ซักถาม" | mkV "ต้องการ" | mkV "เรียกราคา" | mkV "เรียกร้อง" | mkV "เรียกเงิน" | mkV "ขอ" | mkV "ถาม" | mkV "เชิญ" | mkV "ขอราคา" | mkV "ขอร้อง" | mkV "ต้องการ" | mkV "บอกราคา" | mkV "ประสงค์" | mkV "เชื้อเชิญ" | mkV "เสนอราคาที่ต้องการ" ; -- src=panlex
lin ask_about_V2 = prepV2 OP_ask_V OP_about_Prep ; -- guess-p-verb
lin ask_after_V2 = prepV2 OP_ask_V OP_after_Prep ; -- guess-p-verb
lin ask_around_V = advV OP_ask_V OP_around_Adv ; -- guess-p-verb
lin ask_around_V2 = prepV2 OP_ask_V OP_around_Prep ; -- guess-p-verb
lin ask_for_V2 = prepV2 OP_ask_V OP_for_Prep ; -- guess-p-verb
lin ask_for_V3 = variants {} ; -- guess-p-verb
lin ask_in_V2 = prepV2 OP_ask_V OP_in_Prep ; -- guess-p-verb
lin ask_out_V2 = prepV2 OP_ask_V OP_out_Prep ; -- guess-p-verb
lin ask_over_V2 = prepV2 OP_ask_V OP_over_Prep ; -- guess-p-verb
lin ask_round_V2 = prepV2 OP_ask_V OP_round_Prep ; -- guess-p-verb
lin askance_Adv = mkAdv "ค้อน ด้วยลักษณะที่มองด้านข้าง" | mkAdv "สงสัย" | mkAdv "ชายตามอง" | mkAdv "ไม่ไว้ใจ" | mkAdv "ชําเลืองมอง" | mkAdv "ไม่เห็นด้วย" | mkAdv "เหลือบมองด้านข้าง" ; -- src=panlex
lin askew_A = mkA "เฉ" | mkA "เฉียง" | mkA "เอียง" | mkA "เบี่ยง" | mkA "ออกนอกทาง" | mkA "ไปทางข้างหนึ่ง" | mkA "เอียงไปข้างเดียว" ; -- src=panlex
lin askew_Adv = mkAdv "เฉ" | mkAdv "เฉ" | mkAdv "เฉียง" | mkAdv "เอียง" | mkAdv "เบี่ยง" | mkAdv "ออกนอกทาง" | mkAdv "ไปทางข้างหนึ่ง" | mkAdv "เอียงไปข้างเดียว" ; -- src=panlex
lin asking_N = mkN "การขอ" | mkN "การร้องขอ" ; -- src=panlex
lin aslant_A = mkA "เฉ" | mkA "เฉียง" | mkA "เอียง" | mkA "เบี่ยง" ; -- src=panlex
lin aslant_Adv = mkAdv "เฉียง" | mkAdv "โย้" | mkAdv "เฉียง" | mkAdv "เอียง" ; -- src=panlex
lin asleep_A = mkA "หลับ" | mkA "จากไป" | mkA "หลับไหล" | mkA "ชา" | mkA "ตาย" | mkA "หลับ" | mkA "เฉื่อย" | mkA "นอนหลับ" | mkA "หยุดนิ่ง" | mkA "ไม่ตื่นตัว" | mkA "ไม่มีความรู้สึกเนื่องจากมีเลือดไปเลี้ยงไม่พอ" ; -- src=panlex
lin asleep_Adv = mkAdv "ชา" | mkAdv "ตาย" | mkAdv "นอนหลับ" | mkAdv "หยุดนิ่ง" ; -- src=panlex
lin asocial_A = mkA "สันโดษ" | mkA "เก็บตัว" | mkA "ไม่สังคม" | mkA "เห็นแก่ตัว" ; -- src=panlex
lin asp_N = mkN "งูพิษ" | mkN "งูแอสป์" | mkN "งูเหลือม" | mkN "งูพิษชนิดหนึ่ง" ; -- src=panlex
lin asparaginase_N = mkN "ยาแอสปาราจิเนส" ; -- src=panlex
lin asparagine_N = mkN "แอสพาราจีน" | mkN "กรดอะมิโนแอสพาราจีน" ; -- src=panlex
lin asparagus_N = mkN "หน่อไม้ฝรั่ง" | mkN "หน่อไม้ฝรั่ง" ; -- src=panlex
lin aspartame_N = mkN "แอสเพอร์เทม" ; -- src=panlex
lin aspect_N = mkN "มุมมอง" | mkN "สีหน้า" | mkN "ทิวทัศน์" | mkN "การ์ณลักษณะ" | mkN "การแสดงสีหน้า" | mkN "มุม" | mkN "ด้าน" | mkN "ทิศทาง" | mkN "มุมมอง" | mkN "รูปการ" | mkN "ลักษณะ" | mkN "แง่มุม" | mkN "ที่ตั้ง" | mkN "รูปลักษณ์" | mkN "หลักเกณฑ์" | mkN "ความคิดเห็น" | mkN "รูปร่างหน้าตา" | mkN "ด้านข้างหรือผิวหน้าด้านที่กําลังมอง" ; -- src=panlex
lin aspen_N = mkN "ต้นแอสเพน" | mkN "ต้นไป่หยาง" ; -- src=panlex
lin asper_N = mkN "แอสเปอร์" ; -- src=panlex
lin aspergill_N = mkN "แอสเปอร์จิล" ; -- src=panlex
lin aspergillosis_N = mkN "โรคราแอสเพอร์จิลลัส" ; -- src=panlex
lin asperity_N = mkN "ความฉุนเฉียว" | mkN "ความหยาบกระด้าง" | mkN "ความหยาบ" | mkN "ความรุนแรง" | mkN "ความลําบาก" | mkN "ความไม่ละมุนละม่อม" ; -- src=panlex
lin aspersion_N = mkN "การป้ายสี" | mkN "การใส่ร้าย" | mkN "คำพูดใส่ร้าย" | mkN "การใส่ร้ายป้ายสี" | mkN "การใส่ร้าย" | mkN "ข้อกล่าวหา" | mkN "การป้ายร้าย" | mkN "การพรมน้ํามนต์" ; -- src=panlex
lin aspersorium_N = mkN "แอสเปอร์จิล" | mkN "ถ้วยแอสเปอร์โซเรียม" ; -- src=panlex
lin asphalt_N = mkN "ยางมะตอย" | mkN "แอสฟัลต์" | mkN "สารแอสฟัลต์" | mkN "แอสฟัลต์" | mkN "สารชนิดหนึ่งมีสีน้ําตาลหรือดําเหมือนดินน้ํามัน" ; -- src=panlex
lin asphaltic_A = mkA "แอสฟัลติค" ; -- src=panlex
lin asphodel_N = mkN "ต้นอัสโฟเดล" ; -- src=panlex
lin asphyxia_N = mkN "การขาดออกซิเจนในเลือด" ; -- src=panlex
lin asphyxiation_N = mkN "การหายใจไม่ออก" | mkN "การทำให้หายใจไม่ออก" ; -- src=panlex
lin aspic_N = mkN "วุ้น" ; -- src=panlex
lin aspidistra_N = mkN "ต้นแอสพิดิสตรา" ; -- src=panlex
lin aspirant_N = mkN "คนทะเยอทะยาน" | mkN "แสวงหา" | mkN "ผู้แสวงหา" | mkN "ผู้ปรารถนา" | mkN "ผู้ที่มีความปรารถนา" ; -- src=panlex
lin aspirate_N = mkN "พยัญชนะธนิต" | mkN "พยัญชนะพ่นลม" ; -- src=panlex
lin aspiration_N = mkN "ความใฝ่ฝัน" | mkN "การหายใจเข้า" | mkN "ความตั้งใจทำให้สำเร็จ" | mkN "การออกเสียงที่ปล่อยลมหายใจออกมา" | mkN "การหายใจ" | mkN "ความอยาก" | mkN "ความปรารถนา" | mkN "ความทะยานอยาก" | mkN "ความทะเยอทะยาน" | mkN "การสูดลมหายใจเข้า" | mkN "ความมักใหญ่ใฝ่สูง" | mkN "ความมุ่งมาดปรารถนา" | mkN "การออกเสียงเป็นเสียงลมหายใจออก" | mkN "การออกเสียงพร้อมกับปล่อยลมหายใจออก" ; -- src=panlex
lin aspirator_N = mkN "แอสไพเรเตอร์" | mkN "เครื่องสูบอากาศ" | mkN "เครื่องช่วยหายใจ" | mkN "เครื่องดูดของเหลวออกจากร่างกาย" ; -- src=panlex
lin aspire_V = mkV "ตั้งเป้า" | mkV "มีเป้าหมาย" | mkV "ตั้งความหวัง" | mkV "ทะเยอทะยาน" | mkV "มีความต้องการ" | mkV "มีความปรารถนา" ; -- src=panlex
lin aspire_VV = mkVV "ตั้งเป้า" ; ---- | mkV "มีเป้าหมาย" | mkV "ตั้งความหวัง" | mkV "ทะเยอทะยาน" | mkV "มีความต้องการ" | mkV "มีความปรารถนา" ; -- src=panlex
lin aspirin_N = mkN "แอสไพริน" | mkN "ยาแอสไพริน" | mkN "อะซีทิลซาลิไซลิกแอซิด" | mkN "แอสไพริน" | mkN "ยาลดไข้และบรรเทาปวด" | mkN "แอสไพรินซึ่งเป็นยาแก้ปวดและลดไข้" ; -- src=panlex
lin ass_N = mkN "ลา" | mkN "ก้น" | mkN "ตูด" | mkN "แอส" | mkN "การเอา" | mkN "บั้นท้าย" | mkN "การเอากัน" | mkN "ลา" | mkN "ก้น" | mkN "คนโง่" | mkN "ไอ้โง่" | mkN "ทวารหนัก" | mkN "บั้นท้าย" | mkN "การร่วมเพศ" ; -- src=panlex
lin assagai_N = mkN "หอกแอสเซอไก" ; -- src=panlex
lin assailant_N = mkN "ผู้โจมตี" | mkN "ผู้โจมตี" | mkN "ผู้ป้ายร้าย" ; -- src=panlex
lin assassin_N = mkN "ผู้ลอบสังหาร" | mkN "ฆาตกรลอบสังหาร" | mkN "นักฆ่าลอบสังหาร" | mkN "ผู้ฆ่า" | mkN "ผู้ทําลาย" | mkN "ผู้ลอบฆ่า" | mkN "ผู้สังหาร" | mkN "ผู้ที่ลอบสังหาร" | mkN "ผู้ร้ายที่ลอบฆ่า" ; -- src=panlex
lin assassination_N = mkN "การลอบฆ่า" | mkN "การลอบสังหาร" | mkN "การทําลาย" | mkN "การลอบฆ่า" | mkN "การลอบสังหาร" ; -- src=panlex
lin assault_N = mkN "การข่มขืน" | mkN "การข่มขืนกระทำชำเรา" | mkN "จู่โจม" | mkN "ทําลาย" | mkN "การโจมตี" | mkN "การข่มขืน" | mkN "การจู่โจม" | mkN "การทําลาย" | mkN "การประชาทัณฑ์" | mkN "การทําร้ายร่างกาย" | mkN "การโจมตีอย่างรุนแรง" ; -- src=panlex
lin assay_N = mkN "รายงาน" | mkN "การตรวจ" | mkN "สารที่ใช้วิเคราะห์" | mkN "การตรวจสอบคุณภาพสินแร่" | mkN "การทดสอบ" | mkN "สารที่ใช้วิเคราะห์" | mkN "การวิเคราะห์ทางเคมี" ; -- src=panlex
lin assegai_N = mkN "หอกแอสเซอไก" | mkN "หอกยาวในอาฟริกา" ; -- src=panlex
lin assemblage_N = mkN "ชุด" | mkN "ฝูงชน" | mkN "กลุ่มคน" | mkN "การชุมนุม" | mkN "การรวมกัน" | mkN "การรวมตัว" | mkN "ของที่สะสม" | mkN "คอลเลคชั่น" | mkN "การรวมกลุ่ม" | mkN "สิ่งที่รวมไว้" | mkN "ฝูงชน" | mkN "กลุ่มคน" | mkN "ชุมนุมชน" | mkN "การรวบรวม" | mkN "กลุ่มสิ่งของ" | mkN "ภาวะที่รวมกัน" ; -- src=panlex
lin assemble_V = mkV "ชุมนุม" | mkV "ประกอบ" | mkV "นัดรวมตัว" | mkV "ประกอบ" | mkV "รวมตัว" | mkV "เอามารวมกัน" ; -- src=panlex
lin assemble_V2 = mkV2 "ชุมนุม" ; ---- | mkV "ประกอบ" | mkV "นัดรวมตัว" | mkV "ประกอบ" | mkV "รวมตัว" | mkV "เอามารวมกัน" ; -- src=panlex
lin assembler_N = mkN "แอสเซมเบลอร์" | mkN "โปรแกรมแอสแซมบลี" | mkN "โปรแกรมภาษาแอสแซมบลี" ; -- src=panlex
lin assembly_N = mkN "ชุมนุม" | mkN "จุดนัดพบ" | mkN "การชุมนุม" | mkN "การประกอบ" | mkN "การรวมตัว" | mkN "การรวมกลุ่ม" | mkN "การทํา" | mkN "สมัชชา" | mkN "กลุ่มคน" | mkN "การสร้าง" | mkN "ชิ้นส่วน" | mkN "ชุมนุมชน" | mkN "การชุมนุม" | mkN "การประกอบ" | mkN "การประชุม" | mkN "การมั่วสุม" | mkN "การเคลื่อน" | mkN "ส่วนประกอบ" | mkN "การรวมกลุ่ม" | mkN "สัญญาณรวมพล" | mkN "ที่ประชุมสภา" | mkN "คนที่รวมตัวกัน" | mkN "เข้าสู่บริเวณหนึ่ง" | mkN "ประกอบชิ้นส่วนต่าง ๆ ของเครื่องจักร" ; -- src=panlex
lin assemblyman_N = mkN "ส.ส." | mkN "ผู้แทน" | mkN "ผู้แทนราษฎร" | mkN "สมาชิกสภานิติบัญญัติ" | mkN "สมาชิกสภาผู้แทนราษฎร" | mkN "สมาชิกสภาผู้แทนราษฎร" ; -- src=panlex
lin assemblywoman_N = mkN "ส.ส.หญิง" | mkN "สมาชิกสภาผู้แทนราษฎรหญิง" ; -- src=panlex
lin assent_N = mkN "การยอมรับ" | mkN "การตกลง" | mkN "การยอมรับ" | mkN "การยินยอม" ; -- src=panlex
lin assent_V = mkV "ยอมรับ" | mkV "ยอมรับ" | mkV "ยินยอม" | mkV "เห็นด้วย" ; -- src=panlex
lin assenter_N = mkN "ผู้ยินยอม" | mkN "ผู้ตกลง" | mkN "ผู้ยินยอม" ; -- src=panlex
lin assert_V = mkV "ยืนยัน" | mkV "ประกาศอย่างหนักแน่น" | mkV "อ้าง" | mkV "ยืนยัน" | mkV "ยืนกราน" | mkV "ถือสิทธิ์" | mkV "แสดงสิทธิ์" ; -- src=panlex
lin assert_V2 = mkV2 "ยืนยัน" ; ---- | mkV "ประกาศอย่างหนักแน่น" | mkV "อ้าง" | mkV "ยืนยัน" | mkV "ยืนกราน" | mkV "ถือสิทธิ์" | mkV "แสดงสิทธิ์" ; -- src=panlex
lin assert_VS = mmkVS "ยืนยัน" ; ---- | mkV "ประกาศอย่างหนักแน่น" | mkV "อ้าง" | mkV "ยืนยัน" | mkV "ยืนกราน" | mkV "ถือสิทธิ์" | mkV "แสดงสิทธิ์" ; -- src=panlex
lin assertion_N = mkN "การประกาศ" | mkN "การยืนยัน" | mkN "การประกาศอย่างหนักแน่น" | mkN "การอ้าง" | mkN "ข้อเสนอ" | mkN "การรักษา" | mkN "การยืนยัน" | mkN "การพิทักษ์" | mkN "การวินิจฉัย" | mkN "ข้อวินิจฉัย" | mkN "การถือสิทธิ์" | mkN "การกล่าวยืนยัน" ; -- src=panlex
lin assertive_A = mkA "ซึ่งแสดงความมั่นใจ" | mkA "รุกราน" | mkA "ซึ่งยืนยัน" | mkA "ซึ่งยืนยันอย่างมั่นใจ" ; -- src=panlex
lin assertiveness_N = mkN "ความจริงจัง" | mkN "ความจริืงจัง" ; -- src=panlex
lin assessable_A = mkA "ที่ประเมินค่าได้" ; -- src=panlex
lin assessee_N = mkN "คนที่ถูกประเมิน" ; -- src=panlex
lin assessment_N = mkN "การตัดสิน" | mkN "การประเมิน" | mkN "การกําหนด" | mkN "การประเมิน" | mkN "การประเมินค่า" | mkN "ปริมาณที่ประเมิน" ; -- src=panlex
lin assessor_N = mkN "เจ้าหน้าที่ประเมินภาษี" | mkN "ผู้ประเมิน" | mkN "ที่ปรึกษาหรือผู้ช่วยผู้พิพากษา" ; -- src=panlex
lin asset_N = mkN "ค่า" | mkN "ประโยชน์" | mkN "บุคคล ที่มีค่า" | mkN "เงินทอง" | mkN "ของมีค่า" | mkN "ทรัพย์สิน" | mkN "สินทรัพย์" | mkN "สิ่งที่มีคุณค่า" ; -- src=panlex
lin assets_N = mkN "ทรัพย์สิน" | mkN "สินทรัพย์" ; -- src=panlex
lin asseveration_N = mkN "การประกาศ" | mkN "การยืนยัน" | mkN "การประกาศอย่างหนักแน่น" ; -- src=panlex
lin asshole_N = mkN "ตูด" | mkN "คนโง่" | mkN "รูตูด" | mkN "คนเลวทราม" | mkN "ประตูหลัง" | mkN "ไอ้สารเลว" | mkN "คนเลว" | mkN "ทวารหนัก" | mkN "สิ่งที่เลว )" ; -- src=panlex
lin assiduity_N = mkN "ความขยันหมั่นเพียร" | mkN "ความขยัน" | mkN "ความเพียร" | mkN "ความตั้งใจ" | mkN "ความพยายาม" | mkN "ความบากบั่น" ; -- src=panlex
lin assiduous_A = mkA "ตั้งอกตั้งใจ" | mkA "ที่ทําด้วยความตั้งใจ" ; -- src=panlex
lin assignation_N = mkN "การนัดพบ" | mkN "การแบ่งส่วน" | mkN "การโอน" | mkN "การนัดพบ" | mkN "การมอบหมาย" | mkN "ภาระหน้าที่" | mkN "การบ้านจากโรงเรียน" ; -- src=panlex
lin assignee_N = mkN "ตัวแทน" | mkN "ผู้รับโอน" ; -- src=panlex
lin assignment_N = mkN "การแต่งตั้ง" | mkN "เอกสารการโอนสิทธิ" | mkN "ทรัพย์สินที่ถูกโอน" | mkN "งานที่ได้รับมอบหมาย" | mkN "งาน" | mkN "การโอน" | mkN "การบ้าน" | mkN "การมอบหมาย" | mkN "งานที่ได้รับมอบหมาย" | mkN "หน้าที่ที่ได้รับมอบหมาย" ; -- src=panlex
lin assignor_N = mkN "ผู้โอน" | mkN "ผู้โอนสิทธิ์" | mkN "ผู้โอน" ; -- src=panlex
lin assimilable_A = mkA "เอาอย่างได้" ; -- src=panlex
lin assimilate_V = mkV "กลืน" | mkV "ย่อย" | mkV "ซึมซับ" | mkV "ดูดซึม" | mkV "กลมกลืนเสียง" | mkV "ดูดซึมสารอาหาร" | mkV "ทําให้เหมือนหรือคล้ายกัน" | mkV "กลายเป็นเหมือนหรือคล้ายกัน" ; -- src=panlex
lin assimilate_V2 = mkV2 "กลืน" ; ---- | mkV "ย่อย" | mkV "ซึมซับ" | mkV "ดูดซึม" | mkV "กลมกลืนเสียง" | mkV "ดูดซึมสารอาหาร" | mkV "ทําให้เหมือนหรือคล้ายกัน" | mkV "กลายเป็นเหมือนหรือคล้ายกัน" ; -- src=panlex
lin assimilation_N = mkN "การผสมกลมกลืน" | mkN "การกลมกลืนเสียง" | mkN "การย่อยและดูดซึม" | mkN "การปรับเข้ากันของลักษณะของสังคม" ; -- src=panlex
lin assimilative_A = mkA "ที่เป็นตัวทำละลาย" ; -- src=panlex
lin assist_N = mkN "การหนุน" | mkN "การช่วยเหลือ" | mkN "ความช่วยเหลือ" | mkN "การช่วย" | mkN "การช่วยเหลือ" ; -- src=panlex
lin assist_V = mkV "ช่วย" | mkV "รับใช้" | mkV "ช่วยเหลือ" | mkV "เป็นผู้ช่วย" | mkV "ช่วย" | mkV "ช่วยเหลือ" ; -- src=panlex
lin assist_V2 = mkV2 "ช่วย" ; ---- | mkV "รับใช้" | mkV "ช่วยเหลือ" | mkV "เป็นผู้ช่วย" | mkV "ช่วย" | mkV "ช่วยเหลือ" ; -- src=panlex
lin assistance_N = mkN "ผู้ช่วย" | mkN "การช่วยเหลือ" | mkN "ความช่วยเหลือ" | mkN "การสนับสนุน" | mkN "การช่วยเหลือ" | mkN "การสงเคราะห์" | mkN "การอนุเคราะห์" | mkN "ความช่วยเหลือ" ; -- src=panlex
lin assistantFem_N = variants {} ; ---- sense to be split
lin assistantMasc_N = variants {} ; ---- sense to be split
lin assistant_A = mkA "ซึ่งเป็นผู้ช่วย" | mkA "ซึ่งช่วยเหลือ" | mkA "ซึ่งคอยสนับสนุน" ; -- src=panlex
lin assistive_A = mkA "ซึ่งให้ความช่วยเหลือ" ; -- src=panlex
lin assize_N = mkN "การไตร่สวน" | mkN "สภานิติบัญญัติ" | mkN "การนั่งพิจารณาคดี" | mkN "มาตราการกําหนดราคาสินค้า" | mkN "คําสั่งหรือคําพิพากษาของศาลชนิดนี้" | mkN "ศาลอังกฤษที่พิจารณาความโดยข้าหลวงพิเศษ" ; -- src=panlex
lin associate_A = mkA "ซึ่งมีส่วนร่วม" | mkA "ซึ่งเกี่ยวเนื่อง" ; -- src=panlex
lin associate_N = mkN "เพื่อน" | mkN "คนคุ้นเคย" | mkN "อนุปริญญา" | mkN "ผู้เข้าร่วม" | mkN "เหตุการณ์ที่เกี่ยวเนื่อง" ; -- src=panlex
lin associate_V = mkV "รวมกลุ่ม" | mkV "มีความสัมพันธ์" | mkV "เชื่อม" | mkV "รวมกลุ่ม" | mkV "เชื่อมโยง" | mkV "เข้ารวมกัน" | mkV "คบค้าสมาคมกัน" | mkV "ทําให้รู้จักกัน" | mkV "รู้จักเป็นเพื่อนกัน" ; -- src=panlex
lin associate_V2 = mkV2 "รวมกลุ่ม" ; ---- | mkV "มีความสัมพันธ์" | mkV "เชื่อม" | mkV "รวมกลุ่ม" | mkV "เชื่อมโยง" | mkV "เข้ารวมกัน" | mkV "คบค้าสมาคมกัน" | mkV "ทําให้รู้จักกัน" | mkV "รู้จักเป็นเพื่อนกัน" ; -- src=panlex
lin associated_A = mkA "ที่สัมพันธ์กัน" | mkA "ที่เกี่ยวข้องกัน" ; -- src=panlex
lin association_N = mkN "สมาคม" | mkN "การรวมตัว" | mkN "การเชื่อมโยง" | mkN "ความสัมพันธ์" | mkN "กลุ่มพืชและสัตว์" | mkN "กลุ่ม" | mkN "สมาคม" | mkN "สหภาพ" | mkN "บริษัท" | mkN "การรวมกัน" | mkN "เกมฟุตบอล" | mkN "การร่วมกัน" | mkN "การสังสรรค์" | mkN "ความสัมพันธ์" | mkN "การเชื่อมติดกัน" | mkN "สันนิบาตพันธมิตร" | mkN "ความคิดเห็นร่วมกัน" | mkN "ความคิดที่เชื่อมโยง" | mkN "ความเห็นที่เชื่อมโยง" | mkN "กลุ่มของพืชที่อยู่ร่วมกัน" ; -- src=panlex
lin associationism_N = mkN "ทฤษฎีสัมพันธ์เชื่อมโยง" ; -- src=panlex
lin associative_A = mkA "ร่วมกันเชื่อมโยง" ; -- src=panlex
lin assonance_N = mkN "สัมผัสสระ" | mkN "ภาวะสัมผัสเพี้ยน" | mkN "ความคล้ายคลึงกันของเสียง" ; -- src=panlex
lin assonant_A = mkA "ที่พ้องเสียงสระ" ; -- src=panlex
lin assorted_A = mkA "ซึ่งแตกต่างกัน" | mkA "ต่างๆ" | mkA "ต่างๆ ชนิด" | mkA "คละกัน" | mkA "เหมาะสม" | mkA "หลากหลาย" | mkA "หลายชนิด" | mkA "ที่หลากหลาย" | mkA "ี่ีหลายชนิด" | mkA "แบ่งประเภทเป็นหมู่" | mkA "ประกอบด้วยชนิดต่าง ๆ" | mkA "ประกอบด้วยหลายอย่าง" | mkA "ประกอบด้วยชนิดที่คัดเลือกแล้ว" ; -- src=panlex
lin assortment_N = mkN "การรวบรวม" | mkN "การจัดกลุ่ม" | mkN "ของเบ็ดเตล็ด" | mkN "การจำแนกประเภท" | mkN "การแบ่ง" | mkN "การจัดประเภท" ; -- src=panlex
lin assuasive_A = mkA "ซึ่งบรรเทา" ; -- src=panlex
lin assumption_N = mkN "สมมติฐาน" | mkN "คำกล่าวนำ" | mkN "ความบังอาจ" | mkN "การครอบครอง" | mkN "ความยโสโอหัง" | mkN "การตั้งสมมติฐาน" | mkN "การสมมติ" | mkN "สมมติฐาน" | mkN "การนึกเอา" | mkN "ข้อสมมุติ" | mkN "ความหยิ่ง" | mkN "การนึกคะเน" | mkN "การเสแสร้ง" | mkN "ข้อสมมติฐาน" | mkN "การสันนิษฐาน" | mkN "เทศกาลพระแม่ ขึ้นสวรรค์" | mkN "การเข้ารับตําแหน่ง" ; -- src=panlex
lin assumptive_A = mkA "ซึ่งยอมรับโดยไม่มีการพิสูจน์" | mkA "หยิ่ง" | mkA "โอหัง" | mkA "สมมุติ" | mkA "สันนิษฐาน" ; -- src=panlex
lin assurance_N = mkN "คำรับรอง" | mkN "การประกันภัย" | mkN "เชื่อมั่นในตัวเอง" | mkN "ความเชื่อมั่นในตนเอง" | mkN "ความเชื่อมั่นในตัวเอง" | mkN "คําสัญญา" | mkN "การรับรอง" | mkN "ความมั่นใจ" | mkN "ความแน่นอน" | mkN "ความบ้าบิ่น" | mkN "การประกันภัย" | mkN "การรับประกัน" | mkN "ความเชื่อถือ" | mkN "ความเชื่อมั่น" | mkN "การทําให้มั่นใจ" | mkN "การทําให้แน่นอน" | mkN "การโอนทรัพย์สิน" | mkN "ความไม่กลัวเกรง" | mkN "การทําให้เชื่อมั่น" ; -- src=panlex
lin assuredly_Adv = mkAdv "อย่างแน่นอน" ; -- src=panlex
lin assuredness_N = mkN "ความเยือกเย็น" ; -- src=panlex
lin astatic_A = mkA "ไม่มั่นคง" | mkA "ไม่แน่นอน" ; -- src=panlex
lin astatine_N = mkN "แอสทาทีน" | mkN "ธาตุแอสทาทีน" | mkN "เลขอะตอม 85" ; -- src=panlex
lin aster_N = mkN "เอสเตอร์" | mkN "ต้นแอสเตอร์" | mkN "ต้นไม้ดอกจําพวกดอกเบญจมาศหรือดอกเก๊กฮวย" ; -- src=panlex
lin asteriated_A = mkA "มีลักษณะคล้ายดาว" ; -- src=panlex
lin asterion_N = mkN "แอสตีเรียน" ; -- src=panlex
lin asterisk_N = mkN "ดอกจัน" | mkN "เครื่องหมายดอกจันทร์" ; -- src=panlex
lin asterisked_A = mkA "ซึ่งมีดอกจัน" | mkA "ซึ่งมีเครื่องหมายดอกจัน" ; -- src=panlex
lin asterism_N = mkN "ดอกจัน" | mkN "รูปเครื่องหมายดอกจัน" | mkN "กลุ่มดาว" | mkN "กลุ่มของดาว" | mkN "คุณสมบัติของผลึกแร่บางชนิดที่ทําให้มีลักษณะคล้ายดาว" ; -- src=panlex
lin astern_Adv = mkAdv "ข้างหลัง" | mkAdv "ด้านหลัง" | mkAdv "ท้ายเรือ" | mkAdv "ทางท้ายเรือ" | mkAdv "ไปทางข้างหลัง" | mkAdv "ไปทางท้ายเรือ" | mkAdv "ทางด้านหลังของพาหนะ" | mkAdv "ไปทางด้านหลังของเรือ" ; -- src=panlex
lin asternal_A = mkA "ไม่ไปทางกระดูกสันอก" | mkA "ไม่ติดกับกระดูกสันอก" ; -- src=panlex
lin asteroid_A = mkA "ที่มีลักษณะเหมือนดาว" ; -- src=panlex
lin asteroid_N = mkN "ดาวเคราะห์น้อย" ; -- src=panlex
lin asthenia_N = mkN "การศูญเสียกําลัง" ; -- src=panlex
lin asthenosphere_N = mkN "ฐานธรณีภาค" ; -- src=panlex
lin asthma_N = mkN "โรคหืด" | mkN "โรคหืดหลอดลม" | mkN "หืด" | mkN "โรคหืด" ; -- src=panlex
lin asthmatic_N = mkN "คนเป็นหอบหืด" | mkN "คนเป็นโรคหอบหืด" ; -- src=panlex
lin astigmatism_N = mkN "สายตาเอียง" | mkN "สายตาพร่าต่างแนว" | mkN "ภาวะตาพร่า" ; -- src=panlex
lin astir_A = mkA "ซึ่งลุกจากเตียง" | mkA "ไป ๆ มา ๆ" | mkA "ลุกขึ้น" | mkA "เคลื่อนไหว" | mkA "ลุกจากเตียง" ; -- src=panlex
lin astomatous_A = mkA "ไร้ปาก" | mkA "ไร้ส่วนที่เป็นปาก" ; -- src=panlex
lin astonishing_A = mkA "น่าแปลกใจ" | mkA "น่าประหลาดใจ" ; -- src=panlex
lin astonishment_N = mkN "ความประหลาดใจ" | mkN "ความมหัศจรรย์" | mkN "ความอัศจรรย์ใจ" ; -- src=panlex
lin astounding_A = mkA "น่าประหลาดใจ" ; -- src=panlex
lin astrakhan_N = mkN "ขนลูกแกะ" | mkN "หนังลูกแกะเมืองแอสตราแคน" | mkN "สิ่งทอที่ทําด้วยหนังดังกล่าว" ; -- src=panlex
lin astral_A = mkA "แห่งดวงดาว" | mkA "เกี่ยวข้องกับดวงดาว" | mkA "คล้ายดาว" | mkA "เกี่ยวกับดาว" ; -- src=panlex
lin astrantia_N = mkN "ต้นไม้สกุลแอสแรนเทีย" ; -- src=panlex
lin astraphobia_N = mkN "อาการกลัวฟ้าคะนอง" ; -- src=panlex
lin astray_A = mkA "หลงทาง" | mkA "หลงผิด" | mkA "ในทางที่ผิด" ; -- src=panlex
lin astray_Adv = mkAdv "พลัดหลง" | mkAdv "พลาดเป้า" | mkAdv "ไม่ตรงเป้า" | mkAdv "หลง" | mkAdv "พลัด" | mkAdv "หลงทาง" | mkAdv "หลงผิด" | mkAdv "อย่างใจแตก" | mkAdv "อย่างหลงผิด" | mkAdv "ในทางที่ผิด" ; -- src=panlex
lin astride_Adv = mkAdv "นั่งคร่อม" | mkAdv "คร่อม" | mkAdv "นั่งคร่อม" ; -- src=panlex
lin astride_Prep = mkPrep "คร่อม" | mkPrep "นั่งคร่อมบน" ; -- src=panlex
lin astringency_N = mkN "รสฝาด" ; -- src=panlex
lin astringent_A = mkA "สมาน" | mkA "หดตัว" | mkA "รัดแน่น" | mkA "เข้มงวด" | mkA "เฉียบขาด" | mkA "ที่รุนแรง" | mkA "ยาสมานแผล" | mkA "ที่ทําให้หดตัว" | mkA "ที่ทําให้กระชับ" ; -- src=panlex
lin astringent_N = mkN "ยาสมานแผล" | mkN "ยาห้ามเลือด" ; -- src=panlex
lin astrocyte_N = mkN "แอสโตรไซต์" | mkN "เซลล์แอสโตรไซต์" ; -- src=panlex
lin astrodome_N = mkN "แอสโตรโดม" ; -- src=panlex
lin astroglia_N = mkN "แอสโตรเกลีย" ; -- src=panlex
lin astrolabe_N = mkN "แอสโตรแลบ" ; -- src=panlex
lin astrolatry_N = mkN "การบูชาดวงดาว" ; -- src=panlex
lin astrologer_N = mkN "โหร" | mkN "โหราจารย์" | mkN "โหร" | mkN "โหราจารย์" | mkN "นักโหราศาสตร์" ; -- src=panlex
lin astrological_A = mkA "ในทางโหราศาสตร์" ; -- src=panlex
lin astrology_N = mkN "โหราศาสตร์" | mkN "โหราศาสตร์" ; -- src=panlex
lin astronaut_N = mkN "นักบินอวกาศ" | mkN "นักบินอวกาศ" | mkN "มนุษย์อวกาศ" ; -- src=panlex
lin astronautic_A = mkA "อวกาศ" ; -- src=panlex
lin astronautics_N = mkN "วิทยาศาสตร์เกี่ยวกับการบินในอวกาศ" | mkN "ศาสตร์ที่ศึกษาเกี่ยวกับการเดินทางไปในอวกาศ" ; -- src=panlex
lin astronomer_N = mkN "นักดาราศาสตร์" | mkN "นักดาราศาสตร์" ; -- src=panlex
lin astronomical_A = mkA "มหึมา" | mkA "มหาศาล" | mkA "ใหญ่โต" | mkA "ใหญ่มาก" | mkA "เกี่ยวกับดาราศาสตร์" ; -- src=panlex
lin astronomy_N = mkN "ดาราศาสตร์" | mkN "ดาราศาสตร์" ; -- src=panlex
lin astrophysicist_N = mkN "นักดาราศาสตร์" ; -- src=panlex
lin astute_A = mkA "ฉลาด" | mkA "มีเชาว์" | mkA "หลักแหลม" | mkA "มีไหวพริบ" | mkA "มีเล่ห์เหลี่ยม" ; -- src=panlex
lin astuteness_N = mkN "ความลึกซึ้ง" | mkN "ความฉลาดหลักแหลม" | mkN "ความฉลาด" | mkN "ความมีไหวพริบ" | mkN "ความฉลาดเฉลียว" | mkN "ความมีเล่ห์เหลี่ยม" ; -- src=panlex
lin astylar_A = mkA "ซึ่งไม่มีเสา" ; -- src=panlex
lin asunder_Adv = mkAdv "เป็นชิ้นๆ" | mkAdv "กระจายออก" | mkAdv "แยกออกเป็นชิ้น ๆ" | mkAdv "แยกออกเป็นชิ้นๆ" ; -- src=panlex
lin asylum_N = mkN "ที่หลบภัย" | mkN "โรงพยาบาลจิตเวช" | mkN "ที่พ้นภัย" | mkN "ที่ลี้ภัย" | mkN "ที่หลบภัย" | mkN "สถานที่ปกป้อง" | mkN "โรงพยาบาลคนบ้า" | mkN "สถานที่ดูแลคนตาบอด คนบ้า เด็กกําพร้า" ; -- src=panlex
lin asymmetric_A = mkA "ที่ไม่สมมาตรกัน" | mkA "ไม่รับกัน" | mkA "ไม่สมส่วนกัน" | mkA "ไม่เหมือนกันบนสองข้างของเส้นกลาง" ; -- src=panlex
lin asymmetrical_A = mkA "ที่ไม่สมมาตรกัน" | mkA "ไม่รับกัน" | mkA "ไม่สมส่วนกัน" | mkA "ไม่เหมือนกันบนสองข้างของเส้นกลาง" ; -- src=panlex
lin asymmetry_N = mkN "อสมมาตร" | mkN "ความไม่สมส่วนกัน" | mkN "ความไม่เหมือนกันบนสองข้างของเส้นกลาง" ; -- src=panlex
lin asymptomatic_A = mkA "ไร้อาการโรค" ; -- src=panlex
lin asymptote_N = mkN "เส้นกำกับ" | mkN "ค่าไม่สิ้นสุด" | mkN "เส้นตรงที่เส้นโค้งเช้าหา" ; -- src=panlex
lin asynergy_N = mkN "การเสียสหการของอวัยวะ" ; -- src=panlex
lin asystole_N = mkN "หัวใจหยุดเต้น" ; -- src=panlex
lin at_N = mkN "อัต" ; -- src=panlex
lin at_Prep = mkPrep "ที่" | {-pan-} mkPrep "ณ เวลา" | mkPrep "จาก" | mkPrep "ไปยัง" | mkPrep "เข้าร่วม" | mkPrep "ในลักษณะ" | mkPrep "ในช่วงเวลา" ; -- src=panlex
lin at_least_AdN = ss (thword "อย่าง" "น้อย") ;
lin at_most_AdN = ss (thword "อย่าง" "มาก") ;
lin ataraxia_N = mkN "ภาวะสงบเงียบ" ; -- src=panlex
lin atavism_N = mkN "การย้อนสายพันธุ์" | mkN "สัตว์หรือพืชที่มีลักษณะดังกล่าว" ; -- src=panlex
lin ataxia_N = mkN "ภาวะกล้ามเนื้อทํางานไม่ประสานกัน" ; -- src=panlex
lin atelectasis_N = mkN "ปอดแฟบ" ; -- src=panlex
lin atelier_N = mkN "ห้องทำงานของศิลปิน" | mkN "ห้องทํางานด้านศิลป" ; -- src=panlex
lin atenolol_N = mkN "เทนอร์มิน" ; -- src=panlex
lin atheism_N = mkN "อเทวนิยม" | mkN "ความชั่วร้าย" | mkN "ความไม่มีพระเจ้า" | mkN "ความไม่เชื่อในพระเจ้า" | mkN "ความไม่เชื่อว่ามีพระเจ้า" | mkN "ความเชื่อที่ว่าไม่มีพระเจ้า" ; -- src=panlex
lin atheist_N = mkN "คนที่ไม่เชื่อว่าพระเจ้ามีจริง" | mkN "ผู้เชื่อว่าไม่มีพระเจ้า" | mkN "ผู้ที่เชื่อว่าพระเจ้าไม่มีอยู่จริง" ; -- src=panlex
lin athenaeum_N = mkN "อะเทอเนียม" | mkN "ห้องสมุด" | mkN "สถาบันส่งเสริมการเรียนรู้" ; -- src=panlex
lin athenianFem_N = variants {} ; ---- sense to be split
lin athenianMasc_N = variants {} ; ---- sense to be split
lin athens_1_PN = variants {} ; ---- sense to be split
lin athens_2_PN = variants {} ; ---- sense to be split
lin atherogenesis_N = mkN "การเกิดหลอดเลือดแดงแข็ง" ; -- src=panlex
lin atheroma_N = mkN "ตะกรันท่อเลือดแดง" | mkN "ถุงไขมัน" | mkN "ภาวะที่มีไขมันสะสมที่ผนังหลอดโลหิตแดง" ; -- src=panlex
lin atherosclerosis_N = mkN "โรคท่อเลือดแดงและหลอดเลือดแดงแข็ง" ; -- src=panlex
lin athirst_A = mkA "กระหายน้ํา" | mkA "มีความปรารถนามาก" ; -- src=panlex
lin athlete_N = mkN "นักกีฬา" | mkN "นักกีฬา" | mkN "นักกรีฑา" ; -- src=panlex
lin athletic_A = mkA "กรีฑา" | mkA "แข็งแรง" | mkA "ปราดเปรียว" | mkA "ในด้านกีฬา" | mkA "มีร่างกายที่แข็งแรง" | mkA "ที่มีร่างกายเหมือนนักกีฬา" | mkA "มีร่างกายที่เหมือนนักกีฬา" | mkA "เกี่ยวกับนักกีฬาหรือกรีฑา" ; -- src=panlex
lin athleticism_N = mkN "ความเป็นนักกีฬา" ; -- src=panlex
lin athletics_N = mkN "กีฬา" | mkN "การกีฬา" | mkN "การแข่งกีฬา" | mkN "การแข่งขันกีฬา" | mkN "การ" | mkN "การกีฬา" ; -- src=panlex
lin athwart_Adv = mkAdv "เฉียง" ; -- src=panlex
lin atilt_A = mkA "ลาด" | mkA "เอียง" | mkA "เอียงเข้าหา" ; -- src=panlex
lin atlas_N = mkN "แอตลาส" | mkN "สมุดแผนที่" | mkN "กระดูกสันหลัง" | mkN "หนังสือแผนที่" | mkN "สมุดแผนที่" | mkN "หนังสือแผนที่" | mkN "คนที่แบกภาระหนักมาก" | mkN "ชุดรวมแผนภาพและตาราง" | mkN "ชื่อเทพเจ้ากรีกที่ค้ําฟ้าอยู่" | mkN "กระดูกสันหลังส่วนคอที่ค้ําศีรษะ" | mkN "ชื่อขีปนาวุธขนาดยักษ์ของอเมริกา" ; -- src=panlex
lin atmometer_N = mkN "เครื่องวัดการระเหยของน้ำ" ; -- src=panlex
lin atmosphere_N = mkN "รังสี" | mkN "บรรยากาศ" | mkN "เอทีเอ็ม" | mkN "สภาพแวดล้อม" | mkN "ชั้นบรรยากาศ" | mkN "แอตโมสเฟียร์" | mkN "สภาพภูมิอากาศ" | mkN "หน่วยวัดความดันบรรยากาศ" | mkN "อากาศ" | mkN "ท่าทาง" | mkN "บรรยากาศ" | mkN "ภูมิอากาศ" | mkN "สภาวะอากาศ" | mkN "ชั้นบรรยากาศ" | mkN "คุณภาพที่เด่น" | mkN "บรรยากาศรอบโลก" | mkN "ความกดดันบรรยากาศ" | mkN "แก๊สรอบดาวนพเคราะห์" | mkN "บรรยากาศที่น่าสนใจของสถานที่" | mkN "อารมณ์หรือการให้สีของงานศิลป์" ; -- src=panlex
lin atmospheric_A = mkA "เกี่ยวกับบรรยากาศ" ; -- src=panlex
lin atmospherics_N = mkN "คลื่นรบกวน" ; -- src=panlex
lin atoll_N = mkN "อะทอลล์" | mkN "เกาะปะการังวงแหวน" | mkN "เกาะที่เกิดจากหินปะการัง" | mkN "เกาะรูปวงแหวนที่เกิดจากหินปะการัง" | mkN "เกาะรูปวงแหวนที่เกิดจากหินประการัง" ; -- src=panlex
lin atom_N = mkN "อะตอม" | mkN "อนุภาค" | mkN "โมเลกุล" | mkN "อะตอม" | mkN "ปรมาณู" | mkN "สิ่งที่เล็กมาก ๆ" | mkN "ปริมาณที่น้อยมาก" ; -- src=panlex
lin atomic_A = mkA "เล็กขนาดอะตอม" | mkA "เล็กเท่าอะตอม" | mkA "น้อยมาก" | mkA "เล็กมาก" | mkA "เกี่ยวกับอะตอม" | mkA "เกี่ยวกับปรมาณู" ; -- src=panlex
lin atomism_N = mkN "ทฤษฎีอะตอม" | mkN "ปรมาณูนิยม" ; -- src=panlex
lin atomization_N = mkN "การทำให้เป็นละออง" ; -- src=panlex
lin atomizer_N = mkN "ขวดฉีดพ่น" | mkN "ขวดสเปรย์" | mkN "เครื่องมือทําลองของเหลว" ; -- src=panlex
lin atonal_A = mkA "ไร้ท่วงทํานองเสียง" ; -- src=panlex
lin atonality_N = mkN "ระบบไม่อิงกุญแจเสียง" ; -- src=panlex
lin atone_V = mkV "ชดใช้" | mkV "สำนึกบาป" | mkV "ชดเชย" | mkV "ชดใช้" | mkV "แก้ไข" | mkV "ใช้โทษ" | mkV "ไถ่โทษ" ; -- src=panlex
lin atonement_N = mkN "การสำนึกผิด" | mkN "การตกลง" | mkN "การคืนดี" | mkN "การชดเชย" | mkN "การไถ่คืน" | mkN "การไถ่โทษ" ; -- src=panlex
lin atonicity_N = mkN "ภาวะไร้ความตึงตัว" ; -- src=panlex
lin atop_Adv = mkAdv "บนยอด" | mkAdv "บนยอด" ; -- src=panlex
lin atop_Prep = mkPrep "บนยอด" ; -- src=panlex
lin atorvastatin_N = mkN "ลิพิเตอร์" ; -- src=panlex
lin atrazine_N = mkN "อาทราซีน" ; -- src=panlex
lin atrioventricular_A = mkA "เกี่ยวกับหัวใจห้องบนและล่าง" ; -- src=panlex
lin atrium_N = mkN "หัวใจห้องบน" | mkN "หัวใจห้องบน" | mkN "ห้องโถงใหญ่" | mkN "ห้องใหญ่หรือห้องกลางของบ้านโรมันโบราณ" ; -- src=panlex
lin atrocious_A = mkA "ที่สยดสยอง" | mkA "ดุร้าย" | mkA "เลวมาก" | mkA "แย่มาก" | mkA "น่ากลัว" | mkA "เลวร้าย" | mkA "โหดร้าย" | mkA "ชั่วร้าย" | mkA "น่าเกลียด" | mkA "ป่าเถื่อน" | mkA "อัปลักษณ์" | mkA "เหี้ยมโหด" | mkA "ข่มขืนใจสตรี" ; -- src=panlex
lin atrocity_N = mkN "ความเลวร้าย" | mkN "ความโหดร้าย" | mkN "ความโหดเหี้ยมทารุณ" | mkN "ความดุร้าย" | mkN "ความชั่วภัย" | mkN "ความน่ากลัว" | mkN "ความโหดร้าย" | mkN "สิ่งชั่วร้าย" | mkN "การกระทําที่ชั่วร้าย" ; -- src=panlex
lin atrophy_N = mkN "การฝ่อ" | mkN "การลีบ" | mkN "ฝ่อลีบ" | mkN "การโรยรา" | mkN "การเสื่อม" | mkN "การเสื่อมลง" | mkN "อาการลีบเล็ก" | mkN "การลีบฝ่อของอวัยวะ" ; -- src=panlex
lin atrophy_V = mkV "ฝ่อ" | mkV "ตีบ" | mkV "เหี่ยว" ; -- src=panlex
lin atrophy_V2 = mkV2 "ฝ่อ" ; ---- | mkV "ตีบ" | mkV "เหี่ยว" ; -- src=panlex
lin atropine_N = mkN "อะโทรพีน" ; -- src=panlex
lin attach_V = mkV "ติด" | mkV "ยึด" | mkV "อายัด" | mkV "ผูกพัน" | mkV "สัมพันธ์" | mkV "ทำให้ติดกัน" | mkV "ต่อ" | mkV "เติม" | mkV "เพิ่ม" | mkV "ติดกัน" | mkV "ยึดติด" | mkV "ทําให้ติดกัน" | mkV "มีความผูกพันกับ" | mkV "มีความสัมพันธ์กับ" ; -- src=panlex
lin attach_V2 = mkV2 "ติด" ; ---- | mkV "ยึด" | mkV "อายัด" | mkV "ผูกพัน" | mkV "สัมพันธ์" | mkV "ทำให้ติดกัน" | mkV "ต่อ" | mkV "เติม" | mkV "เพิ่ม" | mkV "ติดกัน" | mkV "ยึดติด" | mkV "ทําให้ติดกัน" | mkV "มีความผูกพันกับ" | mkV "มีความสัมพันธ์กับ" ; -- src=panlex
lin attache_N = mkN "ผู้ช่วยทูต" | mkN "กระเป๋าเอกสาร" | mkN "นักการทูต" | mkN "ผู้ช่วยทูต" ; -- src=panlex
lin attachment_N = mkN "การติด" | mkN "ความรัก" | mkN "การอายัด" | mkN "การผูกติด" | mkN "สิ่งที่แนบมา" | mkN "การทำให้ติดกัน" | mkN "การติด" | mkN "การอุทิศ" | mkN "การผูกติด" | mkN "การยึดติด" | mkN "สิ่งยึดติด" | mkN "การยึดทรัพย์" | mkN "การเชื่อมต่อ" | mkN "สิ่งที่แนบมา" | mkN "ภาวะที่ผูกติด" | mkN "สิ่งที่ผูกพัน" | mkN "อุปกรณ์ยึดติด" | mkN "อุปกรณ์ติดตั้ง" | mkN "ความรู้สึกผูกพัน" | mkN "ความผูกพันทางอารมณ์" | mkN "เนื้อความที่แนบมาด้วย" ; -- src=panlex
lin attack_N = mkN "การบุก" | mkN "จู่โจม" | mkN "การโจมตี" | mkN "การคุกคาม" | mkN "การวิจารณ์" | mkN "การบุกโจมตี" | mkN "ตี" | mkN "เป็น" | mkN "โจมตี" | mkN "เข้าตี" | mkN "ทําร้าย" | mkN "เล่นงาน" | mkN "การโจมตี" | mkN "ลงมือทํา" ; -- src=panlex
lin attacker_N = mkN "ผู้โจมตี" ; -- src=panlex
lin attain_V = mkV "ถึง" | mkV "บรรลุ" | mkV "มาถึง" | mkV "ไปถึง" | mkV "ได้ถึง" | mkV "พบโดยบังเอิญ" | mkV "ถึง" | mkV "ไปถึง" | mkV "สําเร็จ" | mkV "บรรลุเป้าหมาย" ; -- src=panlex
lin attain_V2 = mkV2 "ถึง" ; ---- | mkV "บรรลุ" | mkV "มาถึง" | mkV "ไปถึง" | mkV "ได้ถึง" | mkV "พบโดยบังเอิญ" | mkV "ถึง" | mkV "ไปถึง" | mkV "สําเร็จ" | mkV "บรรลุเป้าหมาย" ; -- src=panlex
lin attainder_N = mkN "การเพิกถอนสิทธิ" ; -- src=panlex
lin attainment_N = mkN "สกิล" | mkN "ทักษะ" | mkN "การบรรลุผล" | mkN "การบรรลุผล" | mkN "ความสําเร็จ" ; -- src=panlex
lin attar_N = mkN "หัวน้ำหอม" | mkN "หัวน้ํานม" | mkN "หัวน้ําหอม" ; -- src=panlex
lin attempt_1_N = variants {} ; ---- sense to be split
lin attempt_2_N = variants {} ; ---- sense to be split
lin attend_V = mkV "จัดการ" | mkV "รับใช้" | mkV "เข้าร่วม" | mkV "ตั้งใจฟัง" | mkV "ตาม" | mkV "ไปกับ" | mkV "รับใช้" | mkV "เข้าร่วม" | mkV "ฟังหรือดูอย่างตั้งใจ" ; -- src=panlex
lin attend_V2 = mkV2 "จัดการ" ; ---- | mkV "รับใช้" | mkV "เข้าร่วม" | mkV "ตั้งใจฟัง" | mkV "ตาม" | mkV "ไปกับ" | mkV "รับใช้" | mkV "เข้าร่วม" | mkV "ฟังหรือดูอย่างตั้งใจ" ; -- src=panlex
lin attendance_N = mkN "การเข้าร่วม" | mkN "การไป" | mkN "การอยู่กับ" | mkN "การดูแลรักษา" | mkN "การเข้าชั้นเรียน" | mkN "จํานวนหรือผู้คนที่ไปเข้าร่วม" ; -- src=panlex
lin attendant_N = mkN "คนรับใช้" | mkN "คนเข้าร่วม" | mkN "ผู้เข้าประชุม" | mkN "คนคอยช่วยเหลือ" | mkN "การเกิดพร้อมกัน" | mkN "ผู้คอยช่วยเหลือ" | mkN "ผู้เข้าร่วมประชุม" | mkN "ผู้ดูแล" | mkN "ดูแลรักษา" | mkN "ผู้รับใช้" | mkN "ผู้ต้อนรับ" | mkN "เกี่ยวข้อง" | mkN "ผู้ปรนนิบัติ" | mkN "ผู้เข้าร่วมประชุม" ; -- src=panlex
lin attention_N = mkN "การดูแล" | mkN "ความสนใจ" | mkN "การตั้งใจ" | mkN "การช่วยเหลือ" | mkN "การดูแลรักษา" | mkN "การยืนระวังตรง" | mkN "การดูแลเอาใจใส่" | mkN "ความตั้งอกตั้งใจ" | mkN "การดูแล" | mkN "ความสนใจ" | mkN "การพิจารณา" | mkN "ความตั้งใจ" | mkN "การเอาใจใส่" | mkN "การคํานึงถึง" | mkN "การเอาอกเอาใจ" | mkN "คําสั่งให้ยืนตรง" | mkN "การปฏิบัติที่สมควร" | mkN "การรักษาที่เหมาะสม" | mkN "การพิจารณาอย่างสนใจ" | mkN "การกระทําอย่างรักใคร่" ; -- src=panlex
lin attentive_A = mkA "ตั้งใจ" | mkA "ซึ่งเอาใจใส่" | mkA "สนใจ" | mkA "ใส่ใจ" | mkA "มีมารยาท" | mkA "เป็นห่วง" | mkA "ระมัดระวัง" | mkA "เอาอกเอาใจ" | mkA "เป็นห่วงเป็นใย" | mkA "ซึ่งให้ความสนใจ" ; -- src=panlex
lin attentiveness_N = mkN "ความตั้งใจ" | mkN "ความสนใจ" | mkN "ความใส่ใจ" ; -- src=panlex
lin attenuate_A = mkA "เบา" | mkA "อ่อน" | mkA "แผ่ว" ; -- src=panlex
lin attenuation_N = mkN "การลด" | mkN "การเฟดดิง" ; -- src=panlex
lin attenuator_N = mkN "อุปกรณ์ลดสัญญาณ" | mkN "เครื่องมือลดขนาดของสัญญาณไฟฟ้า" ; -- src=panlex
lin attest_V = mkV "ยืนยัน" | mkV "ให้การ" | mkV "เป็นพยาน" | mkV "พิสูจน์ให้เห็น" | mkV "เป็นพยานหลักฐาน" | mkV "ทําให้ชัดเจน" | mkV "พิสูจน์ว่าจริง" ; -- src=panlex
lin attest_V2 = mkV2 "ยืนยัน" ; ---- | mkV "ให้การ" | mkV "เป็นพยาน" | mkV "พิสูจน์ให้เห็น" | mkV "เป็นพยานหลักฐาน" | mkV "ทําให้ชัดเจน" | mkV "พิสูจน์ว่าจริง" ; -- src=panlex
lin attest_VS = mmkVS "ยืนยัน" ; ---- | mkV "ให้การ" | mkV "เป็นพยาน" | mkV "พิสูจน์ให้เห็น" | mkV "เป็นพยานหลักฐาน" | mkV "ทําให้ชัดเจน" | mkV "พิสูจน์ว่าจริง" ; -- src=panlex
lin attestation_N = mkN "การเป็นพยาน" | mkN "หลักฐานมัดตัว" | mkN "หลักฐานในการจับกุม" | mkN "การรับรอง" | mkN "การให้การ" | mkN "การเป็นพยาน" | mkN "หลักฐานพยาน" ; -- src=panlex
lin attic_N = mkN "กบาล" | mkN "กระโหลก" | mkN "ห้องใต้หลังคา" | mkN "ห้องเพดาน" | mkN "ห้องใต้หลังคา" ; -- src=panlex
lin attire_N = mkN "เครื่องแต่งกาย" | mkN "เครื่องนุ่งห่ม" | mkN "เครื่องแต่งกาย" | mkN "เครื่องแต่งตัว" ; -- src=panlex
lin attitude_N = mkN "ท่า" | mkN "ทรรศนะ" | mkN "ท่าทาง" | mkN "ทัศนคติ" | mkN "ท่วงท่า" | mkN "ทัศนะ" | mkN "ท่าที" | mkN "ท่าทาง" | mkN "เจตคติ" | mkN "ทัศนคติ" | mkN "ความเห็น" | mkN "การวางตัว" | mkN "ความคิดเห็น" | mkN "ท่าในการบิน" | mkN "กิริยาท่าทาง" | mkN "ลักษณะท่าทาง" ; -- src=panlex
lin attitudinize_V = mkV "วางท่า" | mkV "ทําท่า" | mkV "วางท่า" ; -- src=panlex
lin attorney_N = mkN "ทนาย" | mkN "นิติกร" | mkN "หมอความ" | mkN "ทนายความ" | mkN "นักกฎหมาย" | mkN "หมอกฎหมาย" | mkN "ทนาย" | mkN "นิติกร" | mkN "ทนายความ" | mkN "นักกฎหมาย" ; -- src=panlex
lin attorneyship_N = mkN "ตำแหน่งทนายความ" ; -- src=panlex
lin attosecond_N = mkN "แอตโตวินาที" ; -- src=panlex
lin attraction_N = mkN "แรงดึงดูด" | mkN "ความดึงดูด" | mkN "ดารายอดนิยม" | mkN "ความมีเสน่ห์" | mkN "เสน่ห์" | mkN "การดึงดูด" | mkN "แรงดึงดูด" | mkN "การดึงดูดความสนใจ" | mkN "สิ่งหรือบุคคลที่ดึงดูดความสนใจ" ; -- src=panlex
lin attractive_A = mkA "ที่มีเสน่ห์" | mkA "ซึ่งมีเสน่าห์" | mkA "มีเสน่ห์" | mkA "มีเสน่ห์ดึงดูด" | mkA "ซึ่งดึงดูดความสนใจ" ; -- src=panlex
lin attractiveness_N = mkN "ความดึงดูด" | mkN "ความมีเสน่ห์" | mkN "ความน่าดึงดูด" ; -- src=panlex
lin attractor_N = mkN "ความดึงดูด" | mkN "ดารายอดนิยม" ; -- src=panlex
lin attribute_N = mkN "ลักษณะ" | mkN "คุณลักษณะ" | mkN "คุณลักษณ์" | mkN "คุณลักษณะ" | mkN "คุณสมบัติ" ; -- src=panlex
lin attributive_A = mkA "ซึ่งขยายหน้านาม" | mkA "เกี่ยวกับลักษณะของ" ; -- src=panlex
lin attrited_A = mkA "สึกกร่อน" ; -- src=panlex
lin attrition_N = mkN "การครูดไถ" | mkN "การสึกหรอ" | mkN "ความถดถอย" | mkN "การเสียดสี" | mkN "การสำนึกผิด" | mkN "การสึกกร่อน" | mkN "การถดถอย" | mkN "การเสียดสี" | mkN "การสึกกร่อน" | mkN "ความอ่อนแอลง" | mkN "การสึกกร่อนเนื่องจากการเสียดสี" ; -- src=panlex
lin atypical_A = mkA "ผิดพวก" | mkA "ผิดแบบ" | mkA "ผิดปกติ" ; -- src=panlex
lin aubergine_N = mkN "มะเขือ" | mkN "ต้นมะเขือ" | mkN "ลูกมะเขือ" | mkN "มะเขือม่วง" ; -- src=panlex
lin auburn_A = mkA "ที่มีสีออเบิร์น" ; -- src=panlex
lin auction_N = mkN "การประมูล" | mkN "อ็อกชั่นบริดจ์" | mkN "การประ-มูลของ" | mkN "การเลหลัง" | mkN "การขายทอดตลาด" | mkN "การขายโดยการประมูล" ; -- src=panlex
lin auctioneer_N = mkN "ผู้ดำเนินการประมูล" | mkN "ผู้ขายทอดตลาด" ; -- src=panlex
lin audacious_A = mkA "ที่กล้าเสี่ยง" | mkA "กล้าหาญ" | mkA "ชอบเสี่ยงภัย" ; -- src=panlex
lin audacity_N = mkN "ความกล้า" | mkN "ความอาจหาญ" | mkN "ความกล้าหาญ" | mkN "ความกล้าบ้าบิ่น" | mkN "ความกล้า" | mkN "ความทะลุ" | mkN "ความไม่มีมารยาท" ; -- src=panlex
lin audible_A = mkA "ซึ่งฟังได้ยิน" | mkA "ได้ยิน" | mkA "ฟังได้ยิน" | mkA "สามารถได้ยิน" | mkA "สามารถได้ยินได้" | mkA "ดังพอที่จะได้ยิน" | mkA "ซึ่งดังพอที่จะได้ยินได้" ; -- src=panlex
lin audible_N = mkN "การเปลี่ยนแผนการเล่น" ; -- src=panlex
lin audience_N = mkN "คนดู" | mkN "ผู้ชม" | mkN "โอกาสฟัง" | mkN "การเข้าหารือ" | mkN "คนดู" | mkN "คนฟัง" | mkN "ผู้ชม" | mkN "ผู้ดู" | mkN "ผู้ฟัง" | mkN "ผู้อ่าน" | mkN "การได้ยิน" | mkN "การเข้าพบเป็นทางการ" | mkN "การสัมภาษณ์อย่างเป็นทางการ" ; -- src=panlex
lin audile_N = mkN "ผู้มีภาพพจน์จากการฟัง" | mkN "ผู้รู้สึกได้ดีจากการฟัง" ; -- src=panlex
lin audio_A = mkA "เกี่ยวกับเสียง" | mkA "วงจรของตัวรับที่ให้เสียง" | mkA "ที่เกี่ยวกับความถี่ของเครื่องเสียง" ; -- src=panlex
lin audio_N = mkN "เสียง" | mkN "คลื่นความถี่เสียง" | mkN "เครื่องบันทึกเสียง" | mkN "ส่วนเสียงของโทรทัศน์" ; -- src=panlex
lin audiocassette_N = mkN "ตลับเทป" | mkN "ม้วนเทป" | mkN "เทปเสียง" ; -- src=panlex
lin audiogram_N = mkN "ออดิโอแกรม" ; -- src=panlex
lin audiometer_N = mkN "เครื่องตรวจความไวเสียงของหู" | mkN "เครื่องตรวจการได้ยิน" ; -- src=panlex
lin audiotape_N = mkN "เทปบันทึกเสียง" | mkN "แถบบันทึกเสียง" | mkN "เทปบันทึกเสียง" | mkN "แถบบันทึกเสียง" ; -- src=panlex
lin audiovisual_A = mkA "เกี่ยวกับโสตประสาทและจักษุประสาท" ; -- src=panlex
lin audiovisual_N = mkN "เครื่องฉายภาพและเสียง" ; -- src=panlex
lin audit_N = mkN "การตรวจสอบบัญชี" | mkN "บัญชี" | mkN "เข้าฟัง" | mkN "การตรวจสอบบัญชี" | mkN "การวัดประสิทธิภาพ" ; -- src=panlex
lin audition_N = mkN "การได้ยิน" | mkN "การทดสอบการแสดง" | mkN "การได้ยิน" | mkN "การทดลองฟัง" | mkN "การทดลองแสดง" | mkN "การทดสอบการแสดง" | mkN "ประสาทหรืออํานาจในการฟัง" ; -- src=panlex
lin audition_V = mkV "ทดสอบบท" | mkV "ทดสอบการแสดง" | mkV "ทดลองแสดง" | mkV "ทดสอบการแสดง" ; -- src=panlex
lin audition_V2 = mkV2 "ทดสอบบท" ; ---- | mkV "ทดสอบการแสดง" | mkV "ทดลองแสดง" | mkV "ทดสอบการแสดง" ; -- src=panlex
lin auditor_N = mkN "ผู้ฟัง" | mkN "ผู้เข้าฟัง" | mkN "ผู้ตรวจสอบบัญชี" | mkN "ผู้ฟัง" | mkN "ผู้สอบบัญชี" | mkN "ผู้ตรวจสอบบัญชี" | mkN "นักเรียนที่ลงทะเบียนเรียนโดยไม่ได้รับหน่วยกิต" ; -- src=panlex
lin auditorium_N = mkN "หอประชุม" | mkN "โรงละคร" | mkN "หอประชุม" | mkN "ห้องบรรยาย" | mkN "ห้องประชุม" | mkN "อาคารห้องประชุม" | mkN "สถานที่แสดงละครหรือคอนเสิร์ต" | mkN "บริเวณที่นั่งของผู้ชมในโรงละครหรือหอประชุม" ; -- src=panlex
lin auditory_A = mkA "เกี่ยวกับการได้ยิน" | mkA "เกี่ยวกับการได้ยินเสียง" | mkA "ห้องบรรยาย" | mkA "ห้องประชุม" | mkA "กลุ่มคนที่ฟัง" | mkA "เกี่ยวกับโสตประสาท" | mkA "เกี่ยวกับการได้ยินเสียง" | mkA "เกี่ยวกับการฟังหรือการได้ยิน" ; -- src=panlex
lin augend_N = mkN "ตัวตั้ง" | mkN "จํานวนที่ถูกเพิ่ม" ; -- src=panlex
lin auger_N = mkN "สว่าน" | mkN "สว่านมือ" | mkN "สว่าน" ; -- src=panlex
lin aught_N = mkN "เล็กๆน้อยๆ" | mkN "ความว่างเปล่า" | mkN "ส่วนใด" | mkN "สิ่งใด ๆ" ; -- src=panlex
lin augite_N = mkN "ออไจต์" | mkN "แร่ออไจต์" | mkN "เหล็ก" | mkN "แมกนีเซี่ยม" | mkN "แร่ซิลิเกทที่ส่วนใหญ่ประกอบด้วยแคลเซียม" ; -- src=panlex
lin augment_V = mkV "เพิ่มพูน" | mkV "ขยาย" | mkV "เพิ่ม" | mkV "พอกพูน" | mkV "เพิ่มพูน" ; -- src=panlex
lin augment_V2 = mkV2 "เพิ่มพูน" ; ---- | mkV "ขยาย" | mkV "เพิ่ม" | mkV "พอกพูน" | mkV "เพิ่มพูน" ; -- src=panlex
lin augmentation_N = mkN "การเพิ่ม" | mkN "การเพิ่มขึ้น" | mkN "สิ่งที่เพิ่ม" | mkN "ภาวะที่ถูกเพิ่ม" | mkN "ปริมาณหรือจํานวนที่เพิ่ม" ; -- src=panlex
lin augmentative_A = mkA "ซึ่งเพิ่ม" ; -- src=panlex
lin augur_N = mkN "หมอดู" | mkN "โหรหลวง" | mkN "ผู้ทํานาย" ; -- src=panlex
lin augur_V = mkV "เป็นลาง" | mkV "เป็นลางบอกเหตุ" | mkV "ทำนายจากลางบอกเหตุ" ; -- src=panlex
lin augur_V2 = mkV2 "เป็นลาง" ; ---- | mkV "เป็นลางบอกเหตุ" | mkV "ทำนายจากลางบอกเหตุ" ; -- src=panlex
lin augury_N = mkN "นิมิต" | mkN "ลาง" | mkN "นิมิต" | mkN "การทํานาย" | mkN "การพยากรณ์" | mkN "พิธีทํานาย" | mkN "ลางสังหรณ์" | mkN "ศิลปะในการทํานาย" | mkN "ศิลปในการพยากรณ์" ; -- src=panlex
lin august_A = mkA "สง่า" | mkA "น่าเคารพ" | mkA "น่าชื่นชม" ; -- src=panlex
lin auk_N = mkN "นกอ็อก" ; -- src=panlex
lin auklet_N = mkN "นกอ็อกเลต" ; -- src=panlex
lin auld_A = mkA "แก่" ; -- src=panlex
lin aunt_N = mkN "น้า" | mkN "อา" | mkN "น้า" | mkN "ป้า" | mkN "อาผู้หญิง" | mkN "น้าผู้หญิง" | mkN "พี่หรือน้องสาวของแม่หรือพ่อ" ; -- src=panlex
lin auntie_N = mkN "น้า" ; -- src=panlex
lin aunty_N = mkN "น้า" ; -- src=panlex
lin aura_N = mkN "รังสี" | mkN "รัศมี" | mkN "บรรยากาศ" | mkN "ฉัพพรรณรังสี" | mkN "สัญญาณบอกเหตุ" | mkN "บรรยากาศ" | mkN "สภาพอากาศโดยรอบ" | mkN "พลังหรือรัศมีที่ออกมาจากคนหรือสิ่งของ" ; -- src=panlex
lin aureate_A = mkA "ทอง" | mkA "ที่มีสีทอง" ; -- src=panlex
lin aureole_N = mkN "รัศมี" | mkN "โคโรนา" | mkN "ฉัพพรรณรังสี" | mkN "แสงรอบดวงอาทิตย์" | mkN "กลด" | mkN "แสงหรือสีที่มีลักษณะดังกล่าว" | mkN "รัศมีคล้ายแสงเรืองรอบศีรษะของภาพเทพเจ้า" ; -- src=panlex
lin auricle_N = mkN "ใบหู" | mkN "หัวใจห้องบน" | mkN "ใบหู" | mkN "หัวใจห้องบน" | mkN "กระดูกคล้ายใบหู" ; -- src=panlex
lin auricula_N = mkN "ต้นออริคูลา" ; -- src=panlex
lin auricular_A = mkA "คล้ายใบหู" | mkA "เกี่ยวกับหูหัวใจ" | mkA "เกี่ยวกับหูหรือโสตประสาท" ; -- src=panlex
lin auriculare_N = mkN "จุดศูนย์กลางของรูหูนอก" ; -- src=panlex
lin auriculate_A = mkA "คล้ายใบหู" | mkA "มีส่วนที่คล้ายใบหู" ; -- src=panlex
lin auriferous_A = mkA "ที่ประกอบด้วยทอง" | mkA "ให้หรือประกอบด้วยทอง" ; -- src=panlex
lin auriform_A = mkA "ที่เหมือนใบหู" | mkA "ซึ่งเป็นรูปใบหู" ; -- src=panlex
lin aurochs_N = mkN "วีเซนต์" | mkN "วัวออร็อค" ; -- src=panlex
lin aurora_N = mkN "ตอนเช้า" | mkN "ยามเช้า" | mkN "รุ่งอรุณ" | mkN "รุ่งเช้า" | mkN "รุ่งแจ้ง" | mkN "เช้าตรู่" | mkN "แสงเหนือ-แสงใต้" | mkN "แสงออโรรา" | mkN "แสงเหนือแสงใต้" | mkN "แสงอรุณ" | mkN "แสงอรุโณทัย" | mkN "แสงสว่างยามเช้า" | mkN "เทพธิดาแห่งอรุณของโรมันโบราณ" | mkN "แสงเงินแสงทองในบรรยากาศเบื้องบน" ; -- src=panlex
lin auroral_A = mkA "คล้ายแสงอรุณ" | mkA "เกี่ยวกับแสงขั้วโลก" ; -- src=panlex
lin aurous_A = mkA "เกี่ยวกับหรือประกอบด้วยทอง" ; -- src=panlex
lin auscultation_N = mkN "การตรวจฟัง" | mkN "การฟังเสียง" | mkN "การฟังตรวจโรค" ; -- src=panlex
lin auspice_N = mkN "ฤกษ์ดี" | mkN "มงคล" | mkN "นิมิตร" | mkN "ฤกษ์ดี" | mkN "ศุภมงคล" | mkN "การทํานาย" | mkN "สุภมงคลสมัย" | mkN "ความอุปถัมภ์" ; -- src=panlex
lin auspicious_A = mkA "เป็นมงคล" | mkA "ได้ฤกษ์" | mkA "เป็นมงคล" | mkA "ที่มีฤกษ์ดี" ; -- src=panlex
lin aussie_N = mkN "ชาวออสเตรเลีย" ; -- src=panlex
lin austenite_N = mkN "ออสเทนไนต์" | mkN "สารละลาย" ; -- src=panlex
lin austere_A = mkA "ที่เข้มงวดกับตนเอง" | mkA "ที่เข้มงวดกับตัวเอง" | mkA "อดออม" | mkA "เคร่ง" | mkA "ขึงขัง" | mkA "เข้มงวด" | mkA "มัธยัสถ์" | mkA "วินัยจัด" | mkA "เคร่งครัด" | mkA "เรียบง่าย" | mkA "ไม่หรูหรา" ; -- src=panlex
lin austerity_N = mkN "ความเคร่งครัด" | mkN "ความสมถะ" | mkN "ความสมถะมาก" | mkN "ความมัธยัสถ์" | mkN "ความเคร่งครัด" | mkN "ความมีวินัยจัด" ; -- src=panlex
lin austral_A = mkA "ทางใต้" ; -- src=panlex
lin austral_N = mkN "ออสทรัล" ; -- src=panlex
lin australianFem_N = variants {} ; ---- sense to be split
lin australianMasc_N = variants {} ; ---- sense to be split
lin australian_A = mkA "ภาษาออสเตรเลีย" | mkA "ชาวพื้นเมืองออสเตรเลีย" ; -- src=panlex
lin australopithecine_N = mkN "ออสตราโลพิเทซีน" ; -- src=panlex
lin austrianFem_N = variants {} ; ---- sense to be split
lin austrianMasc_N = variants {} ; ---- sense to be split
lin autarchy_N = mkN "สมบูรณาญาธิปไตย" | mkN "การพึ่งตนเองทางเศรษฐกิจ" | mkN "เอกาธิปไตย" | mkN "อัตตาธิปไตย" ; -- src=panlex
lin autarky_N = mkN "การพึ่งตนเองทางเศรษฐกิจ" ; -- src=panlex
lin authentic_A = mkA "จริง" | mkA "ของแท้" | mkA "แท้จริง" | mkA "มีหลักฐาน" | mkA "ไม่ใช่ปลอม" | mkA "น่าเชื่อถือ" | mkA "มีผลตามกฎหมาย" ; -- src=panlex
lin authentication_N = mkN "หนังสือรับรอง" ; -- src=panlex
lin authenticity_N = mkN "ของแตกง่าย" | mkN "ลักษณะของแท้" | mkN "ลักษณะที่เชื่อถือได้" ; -- src=panlex
lin author_N = mkN "ผู้รจนา" | mkN "ผู้แต่ง" | mkN "นักเขียน" | mkN "ผู้ริเริ่ม" | mkN "นักประพันธ์" | mkN "ผู้แต่งหนังสือ" | mkN "ผู้มีความคิดริเริ่ม" | mkN "ผู้แต่ง" | mkN "นักเขียน" | mkN "ผู้สร้าง" | mkN "ผู้เขียน" | mkN "นักประพันธ์" | mkN "ผู้คิดสร้าง" | mkN "ผู้ประพันธ์" | mkN "ผลงานประพันธ์" ; -- src=panlex
lin authoress_N = mkN "นักเขียนหญิง" | mkN "นักประพันธ์หญิง" ; -- src=panlex
lin authoritarian_A = mkA "ที่เป็นอำนาจนิยม" | mkA "เผด็จการ" | mkA "ผู้ใช้อํานาจเผด็จการ" | mkA "เกี่ยวกับอํานาจเบ็ดเสร็จ" ; -- src=panlex
lin authoritarian_N = mkN "ผู้ปกครองเผด็จการ" | mkN "ผู้ใช้อำนาจเผด็จการ" | mkN "ผู้ที่เผด็จการ" | mkN "ผู้ที่ใช้อํานาจเผด็จการ" ; -- src=panlex
lin authoritarianism_N = mkN "ลัทธิสตาลิน" | mkN "การปกครองแบบเผด็จการ" | mkN "การปกครอบแบบเผด็จการ" ; -- src=panlex
lin authoritative_A = mkA "เผด็จการ" | mkA "เชื่อถือได้" | mkA "ซึ่งมีอํานาจ" | mkA "ซึ่งไว้ใจได้" | mkA "ซึ่งเชื่อถือได้" | mkA "ซึ่งแสดงถึงอํานาจ" | mkA "มีหลักฐานพิสูจน์ได้" | mkA "ซึ่งมีอํานาจสนับสนุน" ; -- src=panlex
lin authority_1_N = variants {} ; ---- sense to be split
lin authority_2_N = variants {} ; ---- sense to be split
lin authorization_N = mkN "อำนาจ" | mkN "คำสั่ง" | mkN "การอนุญาต" | mkN "การอนุมัติ" | mkN "เอกสารอนุญาต" | mkN "การอนุญาต" | mkN "การประพันธ์" | mkN "เอกสารอนุญาต" | mkN "เอกสารมอบอํานาจ" | mkN "การอนุญาตหรืออํานาจที่ได้มอบหมาย" ; -- src=panlex
lin authorship_N = mkN "การประพันธ์" | mkN "การแต่งหนังสือ" | mkN "การเขียนหนังสือ" | mkN "การเป็นผู้ริเริ่ม" | mkN "แหล่งที่มาของผลงาน" | mkN "อาชีพการเขียนหนังสือหรือบทความ" ; -- src=panlex
lin autism_N = mkN "โรคออทิซึม" | mkN "การคิดหมกมุ่นอยู่กับตัวเอง" | mkN "ความผิดปกติทางการสื่อสารและอารมณ์" ; -- src=panlex
lin auto_N = mkN "รถ" | mkN "รถยนต์" | mkN "รถ" ; -- src=panlex
lin autoantibody_N = mkN "ออโตแอนติบอดี" ; -- src=panlex
lin autobahn_N = mkN "ทางด่วน" ; -- src=panlex
lin autobiographer_N = mkN "ผู้เขียนอัตชีวประวัติ" ; -- src=panlex
lin autobiography_N = mkN "อัตชีวประวัติ" | mkN "อัตประวัติ" | mkN "อัตชีวประวัติ" | mkN "ชีวประวัติของตัวเอง" | mkN "การเขียนชีวประวัติของตนเอง" ; -- src=panlex
lin autochthon_N = mkN "ออท็อกทอน" ; -- src=panlex
lin autoclave_N = mkN "สเตอริไลเซอร์" ; -- src=panlex
lin autocracy_N = mkN "อัตตาธิปไตย" | mkN "สมบูรณาญาธิปไตย" | mkN "เอกาธิปไตย" | mkN "อัตตาธิปไตย" | mkN "ผู้มีอํานาจเด็ดขาด" | mkN "การปกครองโดยผู้มีอํานาจเด็ดขาด" | mkN "ราชาธิปไตยแบบกษัตริย์ที่มีอํานาจเด็ดขาด" ; -- src=panlex
lin autocrat_N = mkN "ทรราช" | mkN "ผู้มีอำนาจเด็ดขาด" | mkN "ผู้มีอํานาจเด็ดขาด" | mkN "ผู้ปกครองที่มีอํานาจเด็ดขาด" ; -- src=panlex
lin autocratic_A = mkA "ที่เป็นอำนาจนิยม" | mkA "ที่มีอํานาจเด็ดขาด" ; -- src=panlex
lin autodidact_N = mkN "คนที่สอนตนเอง" | mkN "ผู้ศึกษาด้วยตัวเอง" ; -- src=panlex
lin autoerotic_A = mkA "ซึ่งกระตุ้นความรู้สึกทางเพศด้วยตัวเอง" | mkA "ที่เกิดอารมณ์ใคร่" | mkA "ที่เกิดอารมณ์ทางเพศ" ; -- src=panlex
lin autoeroticism_N = mkN "การกระตุ้นกำหนัดตัวเอง" ; -- src=panlex
lin autofluorescence_N = mkN "การเรืองแสงโดยอัตโนมัติ" ; -- src=panlex
lin autofocus_N = mkN "โฟกัสอัตโนมัติ" ; -- src=panlex
lin autogamy_N = mkN "การปฎิสนธิภายในตัวเอง" ; -- src=panlex
lin autogenous_A = mkA "ซึ่งเกิดภายในร่างกาย" | mkA "เกิดขึ้นเอง" | mkA "เกี่ยวกับสารที่เกิดขึ้นเองในร่างกาย" ; -- src=panlex
lin autogiro_N = mkN "ไจโรเพลน" ; -- src=panlex
lin autograft_N = mkN "เนื้อเยื่อปลูกถ่ายให้ตนเอง" ; -- src=panlex
lin autograph_N = mkN "ลายเซ็น" | mkN "งานที่เขียนด้วยลายมือ" | mkN "ลายเซ็น" | mkN "ลายเซ็นของตัวเอง" | mkN "สิ่งที่เขียนด้วยมือตัวเอง" ; -- src=panlex
lin autogyro_N = mkN "ไจโรเพลน" ; -- src=panlex
lin autoimmune_A = mkA "เกี่ยวกับระบบภูมิคุ้มกัน" ; -- src=panlex
lin autoimmunity_N = mkN "ภูมิต้านตนเอง" ; -- src=panlex
lin autoinjector_N = mkN "เครื่องฉีดสารอัตโนมัติ" ; -- src=panlex
lin autoloader_N = mkN "ปืนบรรจุกระสุนอัตโนมัติ" ; -- src=panlex
lin autolytic_A = mkA "เกี่ยวกับการย่อยอาหารอัตโนมัติ" ; -- src=panlex
lin automat_N = mkN "ร้านขายอาหารอัตโนมัติ" | mkN "เครื่องจำหน่ายอาหารอัตโนมัติ" | mkN "เครื่องอัตโนมัต’" ; -- src=panlex
lin automated_A = mkA "อัตโนมัติ" ; -- src=panlex
lin automatic_A = mkA "อัตโนมัติ" | mkA "ที่เหมือนเครื่องจักร" | mkA "เป็นกลไก" | mkA "อัตโนมัติ" | mkA "เกิดขึ้นอย่างอิสระ" | mkA "เป็นไปโดยอัตโนมัติ" ; -- src=panlex
lin automatic_N = mkN "ปืนกล" | mkN "ปืนพก" | mkN "ปืนพกออโตเมติก" | mkN "ปืนไรเฟิลออโตเมติก" ; -- src=panlex
lin automation_N = mkN "อัตโนมัติ" | mkN "อัตโนมัติกรรม" | mkN "เครื่องจักรกล" | mkN "เครื่องมืออัตโนมัติ" | mkN "อัตโนมัติ" | mkN "ลักษณะอัตโน" | mkN "ภาวะอัตโนมัติ" | mkN "ขบวนการอัตโนมัติ" | mkN "การนําเครื่องจักรมาใช้แทนคนในการทํางาน" ; -- src=panlex
lin automatism_N = mkN "ภาวะอัตโนมัติ" ; -- src=panlex
lin automaton_N = mkN "มนุษย์กล" | mkN "หุ่นยนต์" ; -- src=panlex
lin automobile_N = mkN "รถ" | mkN "รถยนต์" | mkN "รถ" | mkN "รถยนต์" | mkN "รถเก๋ง" ; -- src=panlex
lin automotive_A = mkA "เกี่ยวกับรถยนต์" | mkA "ซึ่งขับเคลื่อนอัตโนมัติ" | mkA "อัตโนมัติ" | mkA "เกี่ยวกับรถยนต์" | mkA "ที่เคลื่อนที่ด้วยตัวเอง" | mkA "เคลื่อนไหวไปด้วยเครื่องจักร" | mkA "ที่เคลื่อนไหวด้วยพลังในตัวเอง" ; -- src=panlex
lin automysophobia_N = mkN "อาการกลัวสิ่งสกปรก" ; -- src=panlex
lin autonomic_A = mkA "อัตโนมัติ" | mkA "เป็นอิสระ" | mkA "ที่เกิดขึ้นโดยอัตโนมัติ" | mkA "เกี่ยวกับระบบประสาทส่วนกลาง" ; -- src=panlex
lin autonomous_A = mkA "ซึ่งปกครองตนเอง" | mkA "เป็นอิสระ" | mkA "ปกครองตนเอง" | mkA "เกิดขึ้นเอง" | mkA "ซึ่งปกครองตนเอง" | mkA "ซึ่งพึ่งตนเองได้" | mkA "ซึ่งอยู่ได้ด้วยตนเอง" | mkA "ซึ่งมีอิสระในการเลือก" ; -- src=panlex
lin autonomy_N = mkN "เอกราช" | mkN "ความพึ่งตนเอง" | mkN "เอกราช" | mkN "ความอิสระ" | mkN "การปกครองตนเอง" | mkN "สิทธิในการปกครองตัวเอง" ; -- src=panlex
lin autophyte_N = mkN "ออโตไฟต์" ; -- src=panlex
lin autopilot_N = mkN "เครื่องนำร่องการเดินเรือ" ; -- src=panlex
lin autoplasty_N = mkN "เนื้อเยื่อปลูกถ่ายให้ตนเอง" ; -- src=panlex
lin autopsy_N = mkN "การชันสูตร" | mkN "การชันสูตรพลิกศพ" | mkN "การชันสูตรศพ" | mkN "การตรวจสอบอย่างละเอียด" | mkN "การตรวจสอบหาสาเหตุการตาย" ; -- src=panlex
lin autoradiograph_N = mkN "ออโตเรดิโอกราฟ" ; -- src=panlex
lin autoradiography_N = mkN "ออโตเรดิโอกราฟี" ; -- src=panlex
lin autoregulation_N = mkN "การปรับสมดุลอัตโนมัติของร่างกาย" ; -- src=panlex
lin autosome_N = mkN "ออโตโซม" | mkN "โครโมโซมที่ไม่ใช้โครโมโซมเพศ" ; -- src=panlex
lin autostrada_N = mkN "ทางด่วนออโตสตราดา" ; -- src=panlex
lin autotomy_N = mkN "การทิ้งส่วนของร่างกายตัวเองออก" ; -- src=panlex
lin autotype_N = mkN "สำเนา" | mkN "กระบวนการพิมพ์ด้วยสารสีคาร์บอน" | mkN "สิ่งที่ประดิษฐ์จากแบบเดิม" ; -- src=panlex
lin autumn_N = mkN "ฤดูใบไม้ร่วง" | mkN "ฤดูใบไม้ร่วง" | mkN "วัยเจริญเติบโตเต็มที่" ; -- src=panlex
lin autumnal_A = mkA "ในวัยกลางคน" | mkA "ผ่านพ้นวัยหนุ่มฉกรรจ์" | mkA "เกี่ยวกับฤดูใบไม้ร่วง" | mkA "ผ่านพ้นสมัยที่เจริญรุ่งเรือง" ; -- src=panlex
lin auxesis_N = mkN "การเจริญเติบโต (โดยเฉพาะอย่างยิ่งเนื่องจากเพิ่มขนาดของเซลล์)" | mkN "การเจริญเติบโต" ; -- src=panlex
lin auxiliary_A = mkA "ซึ่งช่วยเสริม" | mkA "ช่วย" | mkA "หนุน" | mkA "เพิ่ม" | mkA "เสริม" | mkA "สํารอง" | mkA "ผู้ช่วย" | mkA "สนับสนุน" | mkA "ผู้สนับสนุน" | mkA "ซึ่งช่วยเหลือ" | mkA "บุคคลในสังกัด" | mkA "เป็นองค์ประกอบ" | mkA "เครื่องสนับสนุน" | mkA "ซึ่งเป็นองค์ประกอบ" ; -- src=panlex
lin auxiliary_N = mkN "ผู้ช่วย" | mkN "เครื่องช่วย" | mkN "เครื่องสนับสนุน" | mkN "ผู้ที่ช่วยสนับสนุน" ; -- src=panlex
lin auxin_N = mkN "ออกซิน" | mkN "ฮอร์โมนออกซิน" | mkN "สารที่เป็นปัจจัยการเจริญเติบโตของพืช" ; -- src=panlex
lin avadavat_N = mkN "นกกระติ๊ด" ; -- src=panlex
lin avail_N = mkN "การบริการ" | mkN "ประโยชน์" | mkN "ความช่วยเหลือ" ; -- src=panlex
lin avail_V = mkV "ช่วย" | mkV "ใช้ให้เป็นประโยชน์แก่ตนเอง" | mkV "เป็นคุณ" | mkV "ใช้ประโยชน์" | mkV "ให้ประโยชน์" | mkV "เป็นประโยชน์" ; -- src=panlex
lin avail_V2 = mkV2 "ช่วย" ; ---- | mkV "ใช้ให้เป็นประโยชน์แก่ตนเอง" | mkV "เป็นคุณ" | mkV "ใช้ประโยชน์" | mkV "ให้ประโยชน์" | mkV "เป็นประโยชน์" ; -- src=panlex
lin availability_N = mkN "การมีอยู่" | mkN "ความสะดวก" | mkN "หาได้ใช้ได้" ; -- src=panlex
lin available_A = mkA "มี" | mkA "หาได้" | mkA "มีอยู่" | mkA "หาง่าย" | mkA "ที่หาง่าย" | mkA "เหมาะที่ใช้" | mkA "เท่าที่จะหาได้" | mkA "ใช้ประโยชน์ได้" | mkA "ที่สามารถใช้ประโยชน์ได้" ; -- src=panlex
lin avalanche_N = mkN "ถล่มทลาย" | mkN "หิมะถล่ม" | mkN "ก้อนหิมะ" | mkN "หิมะถล่ม" | mkN "ปริมาณมาก" ; -- src=panlex
lin avaram_N = mkN "ต้นอะวาราม" ; -- src=panlex
lin avarice_N = mkN "ความโลภ" | mkN "ความละโมบ" | mkN "ความโลภ" | mkN "ความละโมบ" | mkN "ความเห็นแก่ได้" ; -- src=panlex
lin avaricious_A = mkA "โลภ" | mkA "โลภ" | mkA "ละโมบ" | mkA "เห็นแก่ได้" ; -- src=panlex
lin avatar_N = mkN "อวตาร" | mkN "การอวตาร" | mkN "พระอวตาร" | mkN "เทพอวตาร" | mkN "อวตาร" | mkN "ร่างอวตาร" | mkN "ร่างที่แบ่งภาค" | mkN "การจุติลงมาเกิดของเทพในศาสนาพราหมณ์" ; -- src=panlex
lin avenger_N = mkN "ผู้ล้างแค้น" ; -- src=panlex
lin avens_N = mkN "ต้นเอเวนส์" ; -- src=panlex
lin avenue_N = mkN "ถนนใหญ่" | mkN "วิธีการ" | mkN "ถนนเอก" | mkN "ลู่ทาง" | mkN "ถนนใหญ่" | mkN "วิถีทาง" | mkN "วิธีการ" | mkN "เส้นทาง" | mkN "ถนนสายหลัก" | mkN "ถนนกว้างใหญ่" ; -- src=panlex
lin average_A = mkA "เฉลี่ย" | mkA "ปานกลาง" | mkA "โดยเฉลี่ย" | mkA "เฉลี่ย" | mkA "ปานกลาง" | mkA "โดยเฉลี่ย" ; -- src=panlex
lin average_N = mkN "เฉลี่ย" | mkN "ค่าเฉลี่ย" | mkN "ค่าเฉลี่ย" | mkN "อัตราเฉลี่ย" | mkN "คิดถัวเฉลี่ย" ; -- src=panlex
lin average_V = mkV "เฉลี่ย" | mkV "คิดเฉลี่ย" | mkV "หาค่าเฉลี่ย" | mkV "เฉลี่ย" | mkV "หาค่าเฉลี่ย" ; -- src=panlex
lin average_V2 = mkV2 "เฉลี่ย" ; ---- | mkV "คิดเฉลี่ย" | mkV "หาค่าเฉลี่ย" | mkV "เฉลี่ย" | mkV "หาค่าเฉลี่ย" ; -- src=panlex
lin averageness_N = mkN "สภาพปานกลาง" ; -- src=panlex
lin averse_A = mkA "ไม่ชอบ" | mkA "คัดค้าน" | mkA "รังเกียจ" | mkA "ไม่ยินยอม" | mkA "ซึ่งไม่ชอบ" | mkA "ไม่สมัครใจ" | mkA "ซึ่งคัดค้าน" | mkA "ซึ่งรังเกียจ" | mkA "หันไปด้านตรงกันข้ามกับต้น" ; -- src=panlex
lin aversion_N = mkN "ความไม่ชอบ" | mkN "ความเกลียดชัง" | mkN "การหันมองไปทางอื่น" | mkN "ความไม่ชอบ" | mkN "การรังเกียจ" | mkN "การเกลียดชัง" | mkN "ความรังเกียจ" ; -- src=panlex
lin averting_N = mkN "การปกป้อง" | mkN "การหันมองไปทางอื่น" ; -- src=panlex
lin avian_A = mkA "เกี่ยวกับนกหรือตาข่ายนก" ; -- src=panlex
lin aviary_N = mkN "กรงสัตว์ปีก" | mkN "กรงนกขนาดใหญ่" | mkN "บริเวณสงวนพันธุ์นก" | mkN "กรงนกขนาดใหญ่" | mkN "สถานที่เลี้ยงนก" ; -- src=panlex
lin aviation_N = mkN "การบิน" | mkN "ศาตร์การบิน" | mkN "ศาสตร์การบิน" | mkN "การโดยสารเครื่องบิน" | mkN "การเดินทางโดยเครื่องบิน" | mkN "การออกแบบ พัฒนาและสร้างเครื่องบิน" | mkN "วิชาการบิน" | mkN "วิธีการบิน" | mkN "ศิลปและศาสตร์ในการบิน" ; -- src=panlex
lin aviatorFem_N = variants {} ; ---- sense to be split
lin aviatorMasc_N = variants {} ; ---- sense to be split
lin aviatrix_N = mkN "นักบินหญิง" | mkN "นักบินหญิง" | mkN "นักขับเครื่องบินหญิง" ; -- src=panlex
lin avid_A = mkA "อยาก" | mkA "ละโมบ" | mkA "ต้องการ" | mkA "หิวกระหาย" | mkA "ซึ่งปรารถนา" | mkA "ซึ่งต้องการมาก" | mkA "ปรารถนาอย่างมาก" ; -- src=panlex
lin avidity_N = mkN "ความกระตือรือร้น" | mkN "ความละโมบ" | mkN "ความกระหาย" | mkN "ความปรารถนาอย่างมาก" ; -- src=panlex
lin avifauna_N = mkN "นกในท้องถิ่นหรือเขตหนึ่ง" ; -- src=panlex
lin avionics_N = mkN "วิทยาศาสตร์และเทคโนโลยีด้านอิเล็กทรอนิกส์การบิน" ; -- src=panlex
lin avirulent_A = mkA "ที่ไม่ติดเชื้อ" | mkA "ที่ไม่ก่อให้เกิดโรค" ; -- src=panlex
lin avo_N = mkN "อะโว" ; -- src=panlex
lin avocado_A = mkA "ที่มีสีอะโวคาโด" ; -- src=panlex
lin avocado_N = mkN "อาโวกาโด" | mkN "อาโวคาโด" | mkN "ต้นอาโวกาโด" ; -- src=panlex
lin avocation_N = mkN "งานอดิเรก" | mkN "งาน" | mkN "อาชีพ" | mkN "งานว่าง" | mkN "งานประจํา" | mkN "งานอดิเรก" | mkN "การเบนความสนใจ" ; -- src=panlex
lin avoidance_N = mkN "การหลีกเลี่ยง" | mkN "การหลีก" | mkN "การยกเลิก" | mkN "การเลี่ยง" | mkN "การหลบหลีก" | mkN "การทําให้โมฆะ" | mkN "การหลีกเลี่ยง" ; -- src=panlex
lin avoirdupois_N = mkN "ความอ้วน" ; -- src=panlex
lin avouch_V = mkV "ทำให้ไม่มีกระดูก" ; -- src=panlex
lin avouch_V2 = mkV2 "ทำให้ไม่มีกระดูก" ; ---- ; -- src=panlex
lin avowal_N = mkN "การยอมรับ" | mkN "การรับรองอย่างเปิดเผยการประกาศ" ; -- src=panlex
lin avowedly_Adv = mkAdv "จริงอยู่" | mkAdv "โดยเปิดเผย" | mkAdv "อย่างเปิดเผย" ; -- src=panlex
lin avulsion_N = mkN "การดึงให้ขาด" | mkN "การเปลี่ยนแปลงของที่ดินโดยกระแสน้ำ" | mkN "การฉีกขาด" | mkN "การดึงออกจากกัน" | mkN "การเคลื่อนย้ายไปสู่ที่อื่นอย่างฉับพลัน" ; -- src=panlex
lin awake_A = mkA "ตื่น" | mkA "ตื่น" | mkA "ตื่นตัว" | mkA "ซึ่งยังไม่หลับ" ; -- src=panlex
lin awake_V = mkV "ตื่น" | mkV "ลุกขึ้น" | mkV "รู้สึกตัว" | mkV "ตื่น" | mkV "ปลุก" | mkV "กระตุ้น" | mkV "ตื่นตัว" | mkV "ทําให้ตื่น" | mkV "ทําให้ตื่นตัว" ; -- src=panlex
lin awakening_N = mkN "การตระหนักถึง" ; -- src=panlex
lin award_N = mkN "ให้" | mkN "รางวัล" | mkN "รางวัล" ; -- src=panlex
lin aware_A = mkA "สำเหนียก" | mkA "ทราบ" | mkA "รู้ตัว" | mkA "รู้สึกตัว" | mkA "ตระหนักรู้" ; -- src=panlex
lin awareness_N = mkN "ความมีสติ" | mkN "ความตระหนัก" | mkN "ความตระหนักรู้" | mkN "การทราบ" | mkN "การรับรู้" | mkN "ความตระหนัก" ; -- src=panlex
lin awash_A = mkA "ท่วมน้ํา" | mkA "เปียกน้ํา" | mkA "น้ําซัดถึง" | mkA "ถูกคลื่นกระทบ" | mkA "จุ่มอยู่ใต้น้ํา" | mkA "เสมอกับระดับน้ํา" ; -- src=panlex
lin away_1_Adv = variants {} ; ---- sense to be split
lin away_2_Adv = variants {} ; ---- sense to be split
lin away_A = mkA "นอกบ้าน" | mkA "ไป" | mkA "จากไป" | mkA "หมดไป" | mkA "ไปเสีย" | mkA "ไม่อยู่" | mkA "ที่จากไป" ; -- src=panlex
lin awe_N = mkN "ความยำเกรง" | mkN "ความกลัวเกรง" | mkN "ความเกรงกลัว" | mkN "ทําให้เกรง" | mkN "ความกลัวเกรง" | mkN "ความน่าเกรงขาม" | mkN "ความน่าสะพรึงกลัว" ; -- src=panlex
lin aweary_A = mkA "อิดโรย" | mkA "อ่อนเพลีย" ; -- src=panlex
lin aweless_A = mkA "ไม่กลัว" ; -- src=panlex
lin awesome_A = mkA "น่ากลัว" | mkA "น่าหวาดเสียว" | mkA "น่าสะพรึงกลัว" | mkA "ทําให้น่ายําเกรง" | mkA "ซึ่งทําให้สะเทือนขวัญ" ; -- src=panlex
lin awful_A = mkA "แย่มาก" | mkA "น่ากลัว" | mkA "น่ายําเกรง" | mkA "ไม่น่าพอใจ" | mkA "น่าสะพรึงกลัว" | mkA "น่าเลื่อมใสศรัทธา" ; -- src=panlex
lin awfulness_N = mkN "ความเลวร้าย" ; -- src=panlex
lin awheel_A = mkA "ซึ่งเดินทางด้วยพาหนะที่มีล้อ" ; -- src=panlex
lin awhile_Adv = mkAdv "สักครู่" | mkAdv "ประเดี๋ยว" | mkAdv "สักครู่" | mkAdv "ชั่วครู่" | mkAdv "ประเดี๋ยว" | mkAdv "สักประเดี๋ยว" ; -- src=panlex
lin awkward_A = mkA "ซึ่งเทอะทะ" | mkA "ติดขัด" | mkA "อันตราย" | mkA "งุ่มง่าม" | mkA "อึดอัดใจ" | mkA "เก้งก้าง" | mkA "เคอะเขิน" | mkA "ไม่สะดวก" | mkA "เชื่องช้า" | mkA "ที่ไม่สะดวกสบาย" | mkA "ยากที่จะจัดการได้" | mkA "ที่ดูไม่คล่องแคล่ว" | mkA "ไม่รู้จะทําอย่างไรดี" ; -- src=panlex
lin awkwardness_N = mkN "ความเปิ่น" | mkN "ความเงอะงะ" | mkN "ความเทอะทะ" | mkN "ความเขินอาย" ; -- src=panlex
lin awl_N = mkN "เหล็กหมาด" | mkN "หมาด" ; -- src=panlex
lin awlwort_N = mkN "ต้นออลเวิร์ต" ; -- src=panlex
lin awn_N = mkN "หนาม" | mkN "หนามพืช" | mkN "หนวดรวงข้าว" ; -- src=panlex
lin awning_N = mkN "กันสาด" | mkN "กระโจม" | mkN "ที่พัก" | mkN "ผ้าใบบังแดด" ; -- src=panlex
lin awry_A = mkA "คด" | mkA "งอ" | mkA "ผิด" | mkA "เฉไป" | mkA "เฉียง" | mkA "ผิดทาง" | mkA "เบี้ยว" | mkA "ผิดพลาด" | mkA "บิดเบี้ยว" | mkA "ซึ่งไม่เป็นไปตามที่คาด" | mkA "งอหรือคดหรือเฉียงไปทางข้างหนึ่ง" ; -- src=panlex
lin awry_Adv = mkAdv "เฉ" | mkAdv "อย่างไม่ถูกต้อง" | mkAdv "เฉไป" | mkAdv "ผิดทาง" | mkAdv "เบี้ยว" | mkAdv "งอหรือคดหรือเฉียงไปทางข้างหนึ่ง" ; -- src=panlex
lin ax_N = mkN "ขวาน" | mkN "ขวาน" ; -- src=panlex
lin axe_N = mkN "ขวาน" | mkN "ขวาน" ; -- src=panlex
lin axenic_A = mkA "ไร้เชื้อโรค" | mkA "ไม่มีสิ่งอื่นเจือปน" ; -- src=panlex
lin axial_A = mkA "อยู่บนแกน" | mkA "เกี่ยวกับแกน" ; -- src=panlex
lin axil_N = mkN "ง่ามกิ่ง" | mkN "รักแร้" | mkN "ง่ามไม้" | mkN "มุมระหว่างใบกับกิ่ง" ; -- src=panlex
lin axillary_A = mkA "เกี่ยวกับง่ามไม้" ; -- src=panlex
lin axiology_N = mkN "คุณวิทยา" ; -- src=panlex
lin axiom_N = mkN "คติบท" | mkN "สัจพจน์" | mkN "หลักการที่เป็นที่ยอมรับ" | mkN "ความจริงในตัวของมันเอง" | mkN "หลักการที่เป็นที่ยอมรับ" | mkN "กฎเกณฑ์ที่ยอมรับกันทั่วไป" | mkN "ความจริงที่ไม่ต้องพิสูจน์" | mkN "กฎหรือหลักการที่ยอมรับกันทั่วไป" ; -- src=panlex
lin axiomatic_A = mkA "ที่เป็นความจริง" | mkA "แน่ชัดในตัวของมันเอง" | mkA "เป็นที่ยอมรับโดยทั่วไป" ; -- src=panlex
lin axis_N = mkN "แกน" | mkN "สันนิบาต" | mkN "กลุ่มประเทศ" | mkN "กระดูกสันหลังข้อที่สอง" | mkN "แกน" | mkN "ขั้ว" | mkN "เพลา" | mkN "อักษะ" | mkN "สัมพันธมิตร" | mkN "เส้นศูนย์กลาง" | mkN "แนวหลักในการพัฒ-นาหรือเคลื่อนที่" | mkN "กระดูกสันหลังที่คอ" ; -- src=panlex
lin axle_N = mkN "แกน" | mkN "เพลา" | mkN "แกน" | mkN "หมุด" | mkN "เข็ม" | mkN "เพลา" | mkN "เพลารถ" | mkN "แกนล้อ" | mkN "เพลาหมุน" ; -- src=panlex
lin axletree_N = mkN "ลําต้น" ; -- src=panlex
lin axolemma_N = mkN "แอ็กโซเลมมา" ; -- src=panlex
lin axon_N = mkN "แอกซอน" ; -- src=panlex
lin axseed_N = mkN "ต้นแอ็กซ์ซีด" ; -- src=panlex
lin ayah_N = mkN "อะยาห์" | mkN "คนใช้" ; -- src=panlex
lin ayapana_N = mkN "ต้นอะยาพานา" ; -- src=panlex
lin ayatollah_N = mkN "อะยาโตเลาะห์" ; -- src=panlex
lin ayin_N = mkN "อักษรอายิน" ; -- src=panlex
lin azadirachtin_N = mkN "อาซาดิเรซติน" ; -- src=panlex
lin azalea_N = mkN "ต้นอาเซเลีย" | mkN "พืชไม้ดอกจําพวกหนึ่งคล้ายต้นดอกขนแขกเต้า" ; -- src=panlex
lin azathioprine_N = mkN "ยาเอซาไทโอพรีน" ; -- src=panlex
lin azide_N = mkN "เอไซด์" ; -- src=panlex
lin azimuth_N = mkN "เส้นแวงราบ" | mkN "เส้นวางราบ" | mkN "มุมตําแหน่ง" | mkN "ทิศทางของดวงดาวที่วัดบนพื้นโลก" ; -- src=panlex
lin azithromycin_N = mkN "ยาซิโทรแม็กซ์" | mkN "ยาอะซีโทรมัยซิน" ; -- src=panlex
lin azoic_A = mkA "ไม่มีการเกิด" ; -- src=panlex
lin azonal_A = mkA "ที่ไม่แบ่งโซน" ; -- src=panlex
lin azonic_A = mkA "ซึ่งไม่กำหนดโซน" ; -- src=panlex
lin azote_N = mkN "อาโซต" ; -- src=panlex
lin azoturia_N = mkN "ภาวะปัสสาวะมีสารไนโตรเจนเกิน" ; -- src=panlex
lin aztreonam_N = mkN "แอสทรีโอแนม" ; -- src=panlex
lin azure_A = mkA "ฟ้าคราม" | mkA "ท้องฟ้าที่ไม่มีเมฆ" | mkA "สีฟ้าเหมือนท้องฟ้า" | mkA "ที่มีสีฟ้าเหมือนท้องฟ้า" ; -- src=panlex
lin azure_N = mkN "สีฟ้า" | mkN "สีฟ้าคราม" | mkN "ฟ้าเหมือนท้องฟ้า" ; -- src=panlex
lin azurite_N = mkN "อะซูไรต์" | mkN "หินเขียว" | mkN "พลอยที่ประกอบด้วยแร่ชนิดดังกล่าว" ; -- src=panlex
lin azygous_A = mkA "เดียว" ; -- src=panlex
lin azymia_N = mkN "ภาวะไร้เอนไซม์" ; -- src=panlex
lin baa_N = mkN "เสียงแกะๆ" ; -- src=panlex
lin baa_V = mkV "ร้องแบะๆ" ; -- src=panlex
lin baas_N = mkN "หัวหน้า" ; -- src=panlex
lin baba_N = mkN "เค้กบาบา" ; -- src=panlex
lin babble_N = mkN "การพูดเหมือนเด็ก" ; -- src=panlex
lin babble_V = mkV "พึมพำ" | mkV "เผยไต๋" | mkV "เปิดเผย" | mkV "พูดไร้สาระ" | mkV "เผยเคล็ดลับ" | mkV "พูดไม่เป็นภาษา" | mkV "พูดเรื่อยเปื่อย" | mkV "พูดเรื่้อยเปื่อย" | mkV "พูดมาก" | mkV "พูดอ้อแอ้" | mkV "พูดไม่ชัด" | mkV "พูดไร้สาระ" | mkV "พูดเป็นต่อยหอย" | mkV "พูดไม่เป็นภาษา" ; -- src=panlex
lin babble_V2 = mkV2 "พึมพำ" ; ---- | mkV "เผยไต๋" | mkV "เปิดเผย" | mkV "พูดไร้สาระ" | mkV "เผยเคล็ดลับ" | mkV "พูดไม่เป็นภาษา" | mkV "พูดเรื่อยเปื่อย" | mkV "พูดเรื่้อยเปื่อย" | mkV "พูดมาก" | mkV "พูดอ้อแอ้" | mkV "พูดไม่ชัด" | mkV "พูดไร้สาระ" | mkV "พูดเป็นต่อยหอย" | mkV "พูดไม่เป็นภาษา" ; -- src=panlex
lin babbler_N = mkN "คนช่างพูด" | mkN "คนพูดไม่ชัด" | mkN "นกแบ็บเบลอร์" | mkN "คนที่พูดไม่ชัด" ; -- src=panlex
lin babe_N = mkN "ทารก" | mkN "น้อง" | mkN "น้องสาว" | mkN "ลูกอ่อน" | mkN "เด็กทารก" | mkN "เด็กอ่อน" | mkN "เด็กแดงๆ" | mkN "เด็กแบเบาะ" | mkN "เจ้าเนื้ออ่อน" | mkN "ลูกเด็กเล็กแดง" | mkN "ทารก" | mkN "เด็กทารก" | mkN "เด็กเล็ก ๆ" | mkN "หญิงมีเสน่ห์" | mkN "ผู้ไร้เดียงสา" | mkN "เด็กไร้เดียงสา" ; -- src=panlex
lin babel_N = mkN "เสียงคุยกันอึกทึก" | mkN "เสียงคุยจ้อกแจ้กจอแจ" | mkN "หอสูงสู่สวรรค์ที่สร้างไม่สําเร็จ" ; -- src=panlex
lin babka_N = mkN "เค้กบับคา" ; -- src=panlex
lin baboo_N = mkN "นาย" | mkN "บาบู" ; -- src=panlex
lin baboon_N = mkN "ลิงบาบูน" | mkN "หางสั้น" | mkN "คนที่หยาบคาย" | mkN "ลิงขนาดใหญ่ชนิดหนึ่ง" ; -- src=panlex
lin babu_N = mkN "นาย" | mkN "บาบู" | mkN "คําทักทายยกย่อง" ; -- src=panlex
lin babushka_N = mkN "ผ้าโพกศีรษะ" | mkN "ผ้าคลุมศีรษะบาบุชก้า" | mkN "ผ้าโพกศีรษะของสตรี" ; -- src=panlex
lin baby_N = mkN (thword "เด็ก" "ทา" "รก") "คน" | {-pan-} mkN "ลูก" | mkN "ทารก" | mkN "น้อง" | mkN "เด็ก" | mkN "น้องสาว" | mkN "ลูกอ่อน" | mkN "น้องเล็ก" | mkN "เด็กทารก" | mkN "เด็กน้อย" | mkN "เด็กอ่อน" | mkN "เด็กแดงๆ" | mkN "เด็กแบเบาะ" | mkN "เด็กในท้อง" | mkN "ทารกในครรภ์" | mkN "เด็กในครรภ์" | mkN "เจ้าเนื้ออ่อน" | mkN "ลูกเด็กเล็กแดง" | mkN "แง" | mkN "ทารก" | mkN "เด็กทารก" | mkN "เด็กอ่อน" | mkN "เด็กแรกเกิด" | mkN "สัตว์แรกเกิด" | mkN "ลูกอ่อนของสัตว์" ; -- src=panlex
lin babyhood_N = mkN "วัยทารก" | mkN "วัยทารก" | mkN "ช่วงวัยเยาว์" ; -- src=panlex
lin babyish_A = mkA "แบบเด็กๆ" | mkA "เหมือนทารก" | mkA "เป็นของเด็กๆ" | mkA "เหมาะกับเด็กๆ" | mkA "มีนิสัยเหมือนเด็ก" | mkA "ทําตัวเป็นเด็กเล็กๆ" | mkA "ซึ่งเหมาะสําหรับเด็กเล็ก" ; -- src=panlex
lin baby_minder_N = mkN "คนเลี้ยงดูทารก" ; -- src=panlex
lin babysit_V = mkV "ช่วยดูแลเด็ก" ; -- src=panlex
lin babysitter_N = mkN "พี่เลี้ยงเด็ก" | mkN "พี่เลี้ยงเด็ก" ; -- src=panlex
lin babysitting_N = mkN "การดูแลเด็ก" | mkN "การเลี้ยงเด็ก" | mkN "การเป็นพี่เลี้ยงเด็ก" ; -- src=panlex
lin baccalaureate_N = mkN "ป.ตรี" | mkN "ปริญญาตรี" | mkN "ปัจฉิมนิเทศ" | mkN "บัณฑิต" | mkN "บัณฑิตปริญญาตรี" | mkN "คําสวดมนต์ในพิธีดังกล่าว" | mkN "พิธีศาสนาสําหรับบัณฑิตจบใหม่" ; -- src=panlex
lin baccarat_N = mkN "บาเคอรา" ; -- src=panlex
lin baccate_A = mkA "เหมือนลูกเบอร์รี่" ; -- src=panlex
lin bacchanal_N = mkN "การมั่วโลกีย์" | mkN "ผู้ชอบดื่มสุรามาก" | mkN "เทพแห่งเหล้าองุ่น&ความอุดมสมบูรณ์" | mkN "งานดื่มสุราหาความสําราญ" | mkN "การรื่นเริงฉลองเทพเจ้าเมรัย" | mkN "งานเลี้ยงฉลองเทพเจ้าแบ็กคัส" ; -- src=panlex
lin baccy_N = mkN "ยาสูบ" | mkN "ใบยาสูบ" ; -- src=panlex
lin bachelor_N = mkN "ชายโสด" | mkN "หนุ่มโสด" | mkN "ผู้ชายโสด" | mkN "คนโสด" | mkN "ชายโสด" | mkN "บัณฑิต" | mkN "อัศวินหนุ่ม" | mkN "ผู้ได้รับปริญญาตรี" | mkN "สัตว์ตัวผู้ที่ไม่มีเมีย" ; -- src=panlex
lin bachelorhood_N = mkN "วัยโสด" | mkN "ความเป็นโสด" | mkN "ช่วงเป็นโสดก่อนแต่งงาน" ; -- src=panlex
lin bacillus_N = mkN "บี" | mkN "บาซิลลัส" | mkN "แบคทีเรียบาซิลลัส" | mkN "แบ็กทีเรียบาซิลลัส" ; -- src=panlex
lin bacitracin_N = mkN "บาซิทราซิน" ; -- src=panlex
lin back_A = mkA "หลัง" | mkA "ข้างหลัง" | mkA "ค้างจ่าย" | mkA "ค้างชําระ" | mkA "ซึ่งผ่านมาแล้ว" | mkA "ซึ่งอยู่ด้านหลัง" ; -- src=panlex
lin back_Adv = mkAdv "ตอบกลับ" | mkAdv "ถอยหลัง" | mkAdv "ให้ถอยมา" | mkAdv "ตอบรับ" | mkAdv "ตอบโต้" | mkAdv "ผ่านมา" | mkAdv "ในอดีต" | mkAdv "ตอบกลับ" | mkAdv "ย้อนกลับ" | mkAdv "ผ่านมาแล้ว" | mkAdv "หวนกลับคืนมา" | mkAdv "หันไปข้างหลัง" ; -- src=panlex
lin back_N = mkN (thword "หลัง") | {-pan-} mkN "ปก" | mkN "หลัง" | mkN "แบ็ก" | mkN "ที่พิง" | mkN "กองหลัง" | mkN "พนักพิง" | mkN "ด้านหลัง" | mkN "พนักพิงหลัง" | mkN "กระดูกสันหลัง" | mkN "ตำแหน่งกองหลัง" | mkN "ผู้เล่นกองหลัง" | mkN "การเข้าปกหนังสือ" | mkN "หลัง" | mkN "ที่พิง" | mkN "กองหลัง" | mkN "พนักพิง" | mkN "ด้านท้าย" | mkN "ด้านหลัง" | mkN "ส่วนท้าย" | mkN "ส่วนหลัง" | mkN "แผ่นหลัง" | mkN "พนักเก้าอี้" | mkN "กระดูกสันหลัง" ; -- src=panlex
lin back_V = mkV "ถอย" | mkV "พนัน" | mkV "ถอยหลัง" | mkV "สนับสนุน" | mkV "หนุนหลัง" | mkV "วางเดิมพัน" | mkV "ให้การสนับสนุน" | mkV "สนับสนุนทางการเิงิน" | mkV "แสดงให้เห็นอย่างมีเหตุผล" | mkV "กลับมา" | mkV "ถอยหลัง" | mkV "ผลักดัน" | mkV "สนับสนุน" | mkV "หนุนหลัง" | mkV "วางเดิมพัน" | mkV "หันหลังชิด" | mkV "เดินทางกลับ" | mkV "หันหลังพิงกัน" | mkV "เขียนสลักหลัง" | mkV "เขียนบันทึกกํากับ" ; -- src=panlex
lin back_away_V = advV OP_back_V OP_away_Adv ; -- guess-p-verb
lin back_down_V = advV OP_back_V OP_down_Adv ; -- guess-p-verb
lin back_into_V3 = variants {} ; -- guess-p-verb
lin back_off_V = advV OP_back_V OP_off_Adv ; -- guess-p-verb
lin back_out_V = advV OP_back_V OP_out_Adv ; -- guess-p-verb
lin back_out_of_V2 = prepV2 (advV OP_back_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin back_out_of_V3 = variants {} ; -- guess-p-verb
lin back_up_V = advV OP_back_V OP_up_Adv ; -- guess-p-verb
lin back_up_1_V2 = prepV2 OP_back_V OP_up_Prep ; -- guess-p-verb
lin back_up_2_V2 = prepV2 OP_back_V OP_up_Prep ; -- guess-p-verb
lin backache_N = mkN "อาการปวดหลัง" ; -- src=panlex
lin backbeat_N = mkN "จังหวะดนตรีที่หนักแน่น" | mkN "จังหวะดนตรีที่หนักแน่น โดยเฉพาะจังหวะร็อก" ; -- src=panlex
lin backbench_N = mkN "ที่นั่งของสมาชิกรัฐสภา" ; -- src=panlex
lin backbend_N = mkN "การทำสะพานโค้ง" | mkN "การงอตัวมาข้างหลังจนมือทั้งสองแตะพื้น" ; -- src=panlex
lin backbite_V = mkV "นินทา" | mkV "ลอบกัด" | mkV "พูดให้ร้าย" | mkV "นินทาลับหลัง" | mkV "ทําลายชื่อเสียง" ; -- src=panlex
lin backbite_V2 = mkV2 "นินทา" ; ---- | mkV "ลอบกัด" | mkV "พูดให้ร้าย" | mkV "นินทาลับหลัง" | mkV "ทําลายชื่อเสียง" ; -- src=panlex
lin backboard_N = mkN "แป้นบาส" | mkN "แป้นบาสเกตบอล" | mkN "กระดานด้านหลังห่วงในกีฬาบาสเก็ตบอล" ; -- src=panlex
lin backbone_N = mkN "สันปก" | mkN "เสาหลัก" | mkN "แบ็กโบน" | mkN "ปัจจัยหลัก" | mkN "ความหนักแน่น" | mkN "กระดูกสันหลัง" | mkN "แกนสนับสนุนหลัก" | mkN "ความกล้า" | mkN "ความตั้งใจ" | mkN "ความเข้มแข็ง" | mkN "กระดูกสันหลัง" | mkN "สิ่งที่เหมือนกระดูกสันหลัง" ; -- src=panlex
lin backchat_N = mkN "การล้อเล่น" | mkN "การหยอกล้อ" | mkN "คําพูดหยาบคาย" ; -- src=panlex
lin backcloth_N = mkN "ฉากหลัง" | mkN "ฉาก" | mkN "ม่าน" | mkN "ฉากหลัง" | mkN "ที่กําบัง" ; -- src=panlex
lin backdoor_N = mkN "ประตูหลัง" | mkN "วิธีการที่ผิดกฎหมาย" ; -- src=panlex
lin backdrop_N = mkN "ฉากหลัง" | mkN "ฉากหลัง" | mkN "ม่านด้านหลัง" ; -- src=panlex
lin backerFem_N = variants {} ; ---- sense to be split
lin backerMasc_N = variants {} ; ---- sense to be split
lin backfire_N = mkN "บูมเมอแรง" | mkN "ไฟย้อนกลับ" ; -- src=panlex
lin backfire_V = mkV "ทำให้เกิดผลย้อนกลับ" | mkV "ส่งผลตรงกันข้ามกับที่ตั้งใจเอาไว้" ; -- src=panlex
lin backgammon_N = mkN "แบ็คแกมมอน" | mkN "เกมแบ็คแกมมอน" | mkN "เกมแบคแกมมอน" ; -- src=panlex
lin background_N = mkN "ฉากหลัง" | mkN "เดสก์ทอป" | mkN "แบ็คกราวด์" | mkN "พื้นความรู้" | mkN "ภาพพื้นหลัง" | mkN "ข้อมูลพื้นฐาน" | mkN "พื้น" | mkN "ม่าน" | mkN "พื้นเพ" | mkN "ฉากหลัง" | mkN "ประวัติ" | mkN "หลังฉาก" | mkN "ภูมิหลัง" | mkN "ถิ่นที่มา" | mkN "ความเป็นมา" | mkN "เบื้องหลัง" | mkN "พื้นหลังภาพ" | mkN "ส่วนที่อยู่ข้างหลัง" | mkN "เบื้องหน้าเบื้องหลัง" ; -- src=panlex
lin backhand_A = mkA "ซึ่งเขียนจากซ้ายไปขวา" ; -- src=panlex
lin backhand_N = mkN "ลูกหลังมือ" | mkN "การตีลูกหลังมือ" | mkN "การเขียนไปทางซ้าย" | mkN "การคัดลายมือที่หันไปทางซ้าย" | mkN "ท่าตีโดยหันหลังมือออกนอกตัว" | mkN "การเขียนคัดลายมือที่เอนไปทางซ้าย" | mkN "การตีลูกบอลทางตรงข้ามกับมือที่ถือไม้ตี" ; -- src=panlex
lin backhanded_A = mkA "ลังเล" | mkA "อ้อมค้อม" | mkA "อิดเอื้อน" | mkA "กลับทิศทาง" | mkA "พลิกมือกลับ" ; -- src=panlex
lin backhander_N = mkN "การแบ็กแฮนด์" | mkN "การตบด้วยหลังมือ" ; -- src=panlex
lin backhoe_N = mkN "แบ็กโฮ" | mkN "รถขุดหรือรถเจาะ" ; -- src=panlex
lin backing_N = mkN "เงินทุน" | mkN "สนับสนุน" | mkN "การสนับสนุน" | mkN "การอุปถัมภ์" | mkN "ความช่วยเหลือ" | mkN "กองทุนสนับสนุน" | mkN "สิ่งหนุน" | mkN "การสนับสนุน" | mkN "ผู้สนับสนุน" | mkN "ผู้ช่วยเหลือ" | mkN "ความช่วยเหลือ" | mkN "ของที่บุหรือรองสิ่งของอื่น" ; -- src=panlex
lin backlash_N = mkN "สะท้อนกลับ" | mkN "การสะท้อนกลับ" | mkN "ปฏิกริยาต่อเหตุการณ์ทางการเมืองหรือสังคม" | mkN "การกระตุก" | mkN "ปฏิกิริยารุนแรงฉับพลัน" | mkN "การสะท้อนกลับอย่างรุนแรง" ; -- src=panlex
lin backless_A = mkA "ที่ไม่มีด้านหลัง" ; -- src=panlex
lin backlighting_N = mkN "ไฟด้านหลัง" ; -- src=panlex
lin backlog_N = mkN "ของสำรอง" | mkN "งานคั่งค้าง" | mkN "งานที่ยังทําไม่เสร็จ" | mkN "ท่อนไม้ใหญ่สําหรับเล่นแคมป์ไฟ" ; -- src=panlex
lin backmost_A = mkA "ซึ่งอยู่ด้านหลังสุด" ; -- src=panlex
lin backpack_N = mkN "เป้" | mkN "เป้สะพายหลัง" | mkN "กระเป๋าสะพายหลัง" ; -- src=panlex
lin backpacker_N = mkN "คนสะพายเป้" | mkN "ผู้ใส่กระเป๋าสะพายหลัง" ; -- src=panlex
lin backpedal_V = mkV "เปลี่ยนท่าที" | mkV "ขี่จักรยานถอยหลัง" | mkV "ถอน" | mkV "เปลี่ยน" | mkV "เปลี่ยนใจ" | mkV "ถีบกลับหลัง" | mkV "กลับคําสัญญา" | mkV "ถีบจักรยานให้ช้าลง" ; -- src=panlex
lin backplate_N = mkN "เกราะป้องกันหลัง" ; -- src=panlex
lin backroom_N = mkN "ห้องประชุมผู้มีอํานาจเบื้องหลัง" ; -- src=panlex
lin backsaw_N = mkN "เลื่อยรอ" | mkN "เลื่อย" | mkN "เลื่อยขนาดเล็ก" ; -- src=panlex
lin backscratcher_N = mkN "ที่เกาหลัง" | mkN "ไม้เกาหลัง" ; -- src=panlex
lin backseat_N = mkN "เบาะหลัง" ; -- src=panlex
lin backsheesh_N = mkN "ทิป" ; -- src=panlex
lin backside_N = mkN "ก้น" | mkN "ตูด" | mkN "ข้างหลัง" | mkN "ด้านหลัง" | mkN "บั้นท้าย" | mkN "ข้างหลัง" | mkN "ด้านหลัง" | mkN "บั้นท้าย" | mkN "ส่วนหลัง" ; -- src=panlex
lin backslide_V = mkV "ย้อนกลับ" | mkV "ความผิดพลาดที่เกิดขึ้นหลังพยายามเปลี่ยนแปลงพฤติกรรม" ; -- src=panlex
lin backsliding_N = mkN "การกลับทรุด" | mkN "การเสื่อมถอย" ; -- src=panlex
lin backspin_N = mkN "การหมุนถอยหลัง" | mkN "การหมุนกลับ" ; -- src=panlex
lin backstage_Adv = mkAdv "ถอยไปอยู่หลังฉาก" | mkAdv "เกี่ยวกับเรื่องลับๆ" | mkAdv "เกี่ยวกับชิวิตส่วนตัว" ; -- src=panlex
lin backstairs_N = mkN "บันไดหลังอาคาร" ; -- src=panlex
lin backstitch_N = mkN "การเย็บด้นถอยหลัง" ; -- src=panlex
lin backstop_N = mkN "แบ็กสต็อป" | mkN "ตำแหน่งแคทเชอร์" | mkN "แผงกั้นด้านหลัง" ; -- src=panlex
lin backstroke_N = mkN "ท่ากรรเชียง" | mkN "ท่าว่ายน้ําแบบหงายหลัง" | mkN "ท่าว่ายน้ําแบบตีกรรเชียง" ; -- src=panlex
lin backstroker_N = mkN "นักว่ายท่ากรรเชียง" | mkN "นักว่ายน้ำท่ากรรเชียง" ; -- src=panlex
lin backsword_N = mkN "ดาบซ้อม" | mkN "ดาบคมเดียว" | mkN "ดาบไม้" | mkN "ดาบคมเดียว" ; -- src=panlex
lin backtalk_N = mkN "การแซว" ; -- src=panlex
lin back_up_N = mkN "ตัวสำรอง" | mkN "สนับสนุน" | mkN "สแตนด์อิน" | mkN "ตัวแสดงแทน" | mkN "การสนับสนุน" | mkN "การอุปถัมภ์" | mkN "ผู้สนับสนุน" | mkN "สำรองข้อมูล" | mkN "ความช่วยเหลือ" | mkN "ตัวแทน" | mkN "ผู้ช่วย" | mkN "สนับสนุน" | mkN "ตัวสํารอง" | mkN "ผู้สนับสนุน" | mkN "สิ่งค้ําจุน" | mkN "การท่วมหรือสะสมเพราะอุดตัน" ; -- src=panlex
lin backward_A = mkA "ข้างหลัง" | mkA "ซึ่งถดถอย" | mkA "ล่าช้า" | mkA "ล้าหลัง" | mkA "สมองช้า" | mkA "สู่อดีต" | mkA "ย้อนกลับ" | mkA "ไปข้างหลัง" | mkA "กลับสู่อดีต" | mkA "สติปัญญาไม่ดี" | mkA "ซึ่งไปทางข้างหลัง" | mkA "ซึ่งอยู่ทางข้างหลัง" | mkA "กลับสู่สิ่งที่ผ่านมา" ; -- src=panlex
lin backward_Adv = mkAdv "ถอยหลัง" | mkAdv "ให้ถอยมา" | mkAdv "กลับหน้ากลับหลัง" | mkAdv "ถอยกลับ" | mkAdv "ล้าหลัง" | mkAdv "สู่อดีต" | mkAdv "ย้อนกลับ" | mkAdv "ไปข้างหลัง" | mkAdv "กลับไปที่เดิม" | mkAdv "ไปทางข้างหลัง" | mkAdv "ย้อนกลับทางเดิม" | mkAdv "อยู่ทางข้างหลัง" ; -- src=panlex
lin backwards_A = mkA "ล้าหลัง" | mkA "สู่อดีต" | mkA "ย้อนกลับ" | mkA "ไปข้างหลัง" ; -- src=panlex
lin backwards_Adv = mkAdv "ถอยหลัง" | mkAdv "กลับหน้ากลับหลัง" | mkAdv "ถอยหลัง" | mkAdv "ล้าหลัง" | mkAdv "สู่อดีต" | mkAdv "ย้อนกลับ" | mkAdv "ไปข้างหลัง" ; -- src=panlex
lin backwash_N = mkN "กระแสลมดูด" ; -- src=panlex
lin backwater_N = mkN "น้ำวน" | mkN "เขตที่ล้าหลัง" | mkN "หนอง" | mkN "ห้วย" | mkN "น้ํานิ่ง" | mkN "น้ําไหลกลับ" | mkN "สถานที่ซึมเซา" | mkN "กระแสที่ไหลกลับ" | mkN "บรรยากาศที่ซึมเซา" | mkN "สาขาของแม่น้ําที่แยกออกมา" | mkN "ลําคลองที่ติดกับแม่น้ําสายใหญ่" ; -- src=panlex
lin backwoods_N = mkN "ที่ทุรกันดาร" | mkN "ที่ห่างไกลความเจริญ" | mkN "ชนบท" | mkN "ไร้ชื่อเสียง" | mkN "บริเวณห่างไกล" | mkN "สถานที่ห่างไกล" ; -- src=panlex
lin backwoodsman_N = mkN "คนชนบท" | mkN "คนอยู่ในป่า" | mkN "คนที่อาศัยอยู่ในบริเวณห่างไกล" ; -- src=panlex
lin backyard_N = mkN "สวนหลังบ้าน" | mkN "สนามหญ้าหลังบ้าน" | mkN "ลานบ้าน" | mkN "ด้านหลัง" | mkN "สวนหลังบ้าน" | mkN "สนามหลังบ้าน" | mkN "พื้นที่หลังบ้าน" | mkN "ความไม่โสมมข้างใน" ; -- src=panlex
lin bacon_N = mkN "เบคอน" | mkN "หมูเค็ม" | mkN "เนื้อหมูอบ" | mkN "เนื้อซี่โครงหมูเค็ม" | mkN "ส่วนเนื้อด้านหลังและข้างของหมูที่ใส่เกลือรมควัน" ; -- src=panlex
lin bacteria_N = mkN "บัคเตรี" | mkN "แบคทีเรีย" | mkN "เชื้อโรค" | mkN "แบ็กทีเรีย" | mkN "เชื้อแบกทีเรีย" | mkN "เชื้อแบคทีเรีย" ; -- src=panlex
lin bacterial_A = mkA "ที่เป็นแบ็กทีเรีย" | mkA "ที่ประกอบด้วยแบกทีเรีย" ; -- src=panlex
lin bactericidal_A = mkA "ลักษณะฆ่าเชื้อแบกทีเรีย" | mkA "เกี่ยวกับการฆ่าเชื้อแบ็กทีเรีย" ; -- src=panlex
lin bactericide_N = mkN "สารฆ่าแบคทีเรีย" | mkN "ยาฆ่าเชื้อแบคทีเรีย" | mkN "สิ่งหรือยาฆ่าเชื้อแบคทีเรีย" ; -- src=panlex
lin bacteriochlorophyll_N = mkN "แบคเทอริโอคลอโรฟีลล์" ; -- src=panlex
lin bacteriologist_N = mkN "นักวิจัยแบคทีเรีย" | mkN "นักแบคทีเรียวิทยา" ; -- src=panlex
lin bacteriology_N = mkN "วิทยาแบคทีเรีย" | mkN "แบคทีเรียวิทยา" | mkN "แบ็กทีเรียวิทยา" | mkN "การศึกษาเกี่ยวกับเชื้อแบคทีเรีย" ; -- src=panlex
lin bacteriophage_N = mkN "ไวรัสทำลายแบคทีเรีย" ; -- src=panlex
lin bacteriostasis_N = mkN "การยับยั้งแบคทีเรีย" | mkN "การหยุดยั้งแบคทีเรีย" | mkN "การยับยั้งการเจริญเติบโตของแบคทีเรีย" ; -- src=panlex
lin bacteriostat_N = mkN "แบคเทอริโอสแตท" ; -- src=panlex
lin bacterium_N = mkN "บัคเตรี" | mkN "แบคทีเรีย" ; -- src=panlex
lin bacteroid_N = mkN "แบคทีรอยด์" ; -- src=panlex
lin bad_A = mkA (thword "เลว") | {-pan-} mkA "เลว" | mkA "แย่" | mkA "เสีย" | mkA "ไม่ดี" | mkA "ยอดแย่" | mkA "แสดงความเสียใจ" | mkA "เลว" | mkA "แย่" | mkA "ชั่ว" | mkA "ร้าย" | mkA "ร้้าย" | mkA "ไม่ดี" | mkA "ชั่วช้า" | mkA "ผิดหวัง" | mkA "เลวทราม" | mkA "เลวร้าย" | mkA "ไม่พอใจ" | mkA "เป็นอันตราย" | mkA "ไม่มีความสุข" | mkA "ต่ํากว่ามาตรฐาน" | mkA "ีไม่เป็นที่ยอมรับบ" ; -- src=panlex
lin bad_N = mkN "เลว" | mkN "ความเลว" | mkN "ความชั่ว" | mkN "ความไม่ดี" ; -- src=panlex
lin baddeleyite_N = mkN "แบดเดเลย์ไอต์" | mkN "แร่แบดเดเลย์ไอต์" ; -- src=panlex
lin badge_N = mkN "เครื่องหมาย" | mkN "เข็มสัญลักษณ์" | mkN "แถบเครื่องหมาย" | mkN "เข็มเครื่องหมาย" | mkN "เข็ม" | mkN "เครื่องหมาย" ; -- src=panlex
lin badger_N = mkN "แบดเจอร์" | mkN "สัตวสี่เท้ามีขนสีเทา และหัวมีลายเส้นสีขาวตัดกับขนสีเทา" ; -- src=panlex
lin badinage_N = mkN "การยั่วเย้า" | mkN "การพูดตลก" | mkN "การพูดเล่น" ; -- src=panlex
lin badlands_N = mkN "ที่รกร้างว่างเปล่า" | mkN "ป่ารก" | mkN "ที่รกร้างว่างเปล่า" ; -- src=panlex
lin badminton_N = mkN "แบด" | mkN "แบดมินตัน" | mkN "กีฬาลูกขนไก่" | mkN "กีฬาแบดมินตัน" | mkN "ลูกขนไก่" | mkN "แบดมินตัน" | mkN "การเล่นแบดมินตัน" ; -- src=panlex
lin badness_N = mkN "เลว" | mkN "ความเลว" | mkN "ความชั่วร้าย" ; -- src=panlex
lin baffle_N = mkN "กะบัง" | mkN "แผงกั้นหน้าลำโพง" ; -- src=panlex
lin bag_N = mkN "ถุง" | mkN "เบส" | mkN "กระเป๋า" | mkN "งานสบาย" | mkN "ต่อมน้ำนม" | mkN "กระเป๋าถือ" | mkN "กระเป๋าถือสตรี" | mkN "กระเป๋าเดินทาง" | mkN "หญิงอารมณ์ร้าย" | mkN "ต่อมน้ำนมของสัตว์" | mkN "ฐาน" | mkN "ถุง" | mkN "ย่าม" | mkN "กระเป๋าถือ" | mkN "ความร่ํารวย" | mkN "ความล่ําซํา" | mkN "ความมั่งคั่ง" | mkN "หญิงไร้เสน่ห์" | mkN "กระเป๋าถือสตรี" | mkN "ผู้หญิงที่ไม่มีเสน่ห์" | mkN "จํานวนสิ่งของที่กระเป๋าสามารถจะบรรจุได้" ; -- src=panlex
lin bag_V = mkV "นูน" | mkV "กรีดกระเป๋า" | mkV "ล้วงกระเป๋า" | mkV "ฆ่า" | mkV "บวม" | mkV "พอง" | mkV "ห้อย" | mkV "แขวน" | mkV "ใส่ถุง" | mkV "รอยโป่ง" | mkV "ล่าเหยื่อ" | mkV "เอาใส่กระเป๋า" ; -- src=panlex
lin bag_V2 = mkV2 "นูน" ; ---- | mkV "กรีดกระเป๋า" | mkV "ล้วงกระเป๋า" | mkV "ฆ่า" | mkV "บวม" | mkV "พอง" | mkV "ห้อย" | mkV "แขวน" | mkV "ใส่ถุง" | mkV "รอยโป่ง" | mkV "ล่าเหยื่อ" | mkV "เอาใส่กระเป๋า" ; -- src=panlex
lin bagasse_N = mkN "ชานอ้อย" | mkN "กระดาษชานอ้อย" ; -- src=panlex
lin bagassosis_N = mkN "โรคบากัสโซสิส" | mkN "โรคปอดชานอ้อย" ; -- src=panlex
lin bagatelle_N = mkN "บากาแตล" | mkN "สิ่งไร้สาระ" | mkN "ของประดับไร้ค่า" | mkN "เกมคล้ายเกมบิลเลียด" ; -- src=panlex
lin bagel_N = mkN "ขนมปังเบเกิ้ล" | mkN "ขนมปังที่มีลักษณะเป็นวง" ; -- src=panlex
lin baggage_N = mkN "หญิงไร้ค่า" | mkN "ผู้หญิงไร้ค่า" | mkN "กระเป๋าเดินทาง" | mkN "กระเป๋าเดินทาง" ; -- src=panlex
lin baggageman_N = mkN "คนดูแลกระเป๋าเดินทาง" | mkN "ผู้ดูแลกระเป๋าเดินทาง" ; -- src=panlex
lin bagger_N = mkN "พนักงานบรรจุกล่อง" | mkN "พนักงานบรรจุหีบห่อ" | mkN "เครื่องบรรจุถุงอัตโนมัติ" | mkN "คนใส่ของลงในถุง" | mkN "คนที่เอาของใส่ถุงตามร้านค้า" | mkN "ถุงผ้าหรือถุงพลาสติกที่ติดกับเครื่องตัดหญ้า" ; -- src=panlex
lin baggy_A = mkA "คล้ายถุง" | mkA "โป่งหรือหลวมลง" | mkA "แขวนอยู่อย่างหลวม ๆ" | mkA "โป่งหรือพองเหมือนถุง" ; -- src=panlex
lin bagman_N = mkN "พนักงานเดินขายสินค้า" ; -- src=panlex
lin bagnio_N = mkN "ซ่อง" | mkN "หอนางโลม" | mkN "โคมเขียว" | mkN "โรงอาบน้ำ" | mkN "ซ่องโสเภณี" ; -- src=panlex
lin bagpipe_N = mkN "ปี่" | mkN "ปี่สก็อต" | mkN "ปี่สก็อต" | mkN "ปี่สก๊อต" ; -- src=panlex
lin baguet_N = mkN "ขนมปังฝรั่งเศส" ; -- src=panlex
lin baht_N = mkN "บ." | mkN "บาท" | mkN "เงินบาท" | mkN "เงินบาทของไทย" ; -- src=panlex
lin bail_N = mkN "ถังวิดน้ํา" | mkN "การประกันตัว" | mkN "ที่ถือครึ่งวงกลมของถัง" ; -- src=panlex
lin bail_V = mkV "ตัก" | mkV "ประกันตัว" | mkV "ประกันตัวออกไป" | mkV "ได้รับการปล่อยตัว" | mkV "วิดน้ํา" | mkV "ประกันตัวออกไป" ; -- src=panlex
lin bail_V2 = mkV2 "ตัก" ; ---- | mkV "ประกันตัว" | mkV "ประกันตัวออกไป" | mkV "ได้รับการปล่อยตัว" | mkV "วิดน้ํา" | mkV "ประกันตัวออกไป" ; -- src=panlex
lin bailable_A = mkA "สามารถให้ประกันตัวได้" | mkA "อนุญาตให้ประกันตัวได้" ; -- src=panlex
lin bailee_N = mkN "ผู้ที่ได้รับทรัพย์สินในการประกันตัว" ; -- src=panlex
lin bailey_N = mkN "กำแพงชั้นนอก" | mkN "สนามรอบนอกของคฤหาสน์" | mkN "ศาล" | mkN "สวนหย่อม" | mkN "รั้วกั้นชั้นนอก" | mkN "กําแพงเมืองชั้นนอก" | mkN "สวนที่ถูกล้อมรอบด้วยตึก" ; -- src=panlex
lin bailiff_N = mkN "เจ้าพนักงานศาล" | mkN "เจ้าพนักงานยึดทรัพย์สิน" | mkN "ตํารวจศาล" | mkN "ปลัดอําเภอ" | mkN "ผู้ดูแลผลประโยชน์ของเจ้าของที่ดิน" ; -- src=panlex
lin bailiwick_N = mkN "วิชา" | mkN "สาขา" | mkN "ศาสตร์" ; -- src=panlex
lin bailment_N = mkN "ทรัพย์ที่ใช้ประกันตัว" | mkN "การส่งคืนทรัพย์สินที่ประกันตัว" ; -- src=panlex
lin bailor_N = mkN "ผู้ส่งมอบทรัพย์สินให้ประกันตัว" | mkN "ผู้ส่งมอบทรัพย์สินเพื่อประกันตัว" ; -- src=panlex
lin bairn_N = mkN "ลูก" | mkN "เด็ก" | mkN "เด็กชายหรือเด็กหญิง" ; -- src=panlex
lin bait_N = mkN "เหยื่อ" | mkN "เหยื่อล่อ" | mkN "เหยื่อ" | mkN "สิ่งล่อใจ" ; -- src=panlex
lin bait_V = mkV "ล้อ" | mkV "ยั่ว" | mkV "แหย่" | mkV "ยั่วเย้า" | mkV "ล้อเลียน" | mkV "เยาะเย้อ" | mkV "เย้าหยอก" | mkV "ให้สุนัขรุมกัด" | mkV "หยอกล้อ" | mkV "เย้าแหย่" | mkV "ล่อเหยื่อ" | mkV "การล่อหลอก" | mkV "การดึงดูดใจ" | mkV "ใส่เหยื่อตกปลา" | mkV "เอาเหยื่อติดเบ็ด" ; -- src=panlex
lin bait_V2 = mkV2 "ล้อ" ; ---- | mkV "ยั่ว" | mkV "แหย่" | mkV "ยั่วเย้า" | mkV "ล้อเลียน" | mkV "เยาะเย้อ" | mkV "เย้าหยอก" | mkV "ให้สุนัขรุมกัด" | mkV "หยอกล้อ" | mkV "เย้าแหย่" | mkV "ล่อเหยื่อ" | mkV "การล่อหลอก" | mkV "การดึงดูดใจ" | mkV "ใส่เหยื่อตกปลา" | mkV "เอาเหยื่อติดเบ็ด" ; -- src=panlex
lin baiza_N = mkN "ไบซา" ; -- src=panlex
lin bake_V = mkV "อบ" | mkV "ร้อนตับแตก" | mkV "ร้อนตับแลบ" | mkV "ร้อนอบอ้าว" | mkV "ร้อนอย่างกับเตาอบ" | mkV "อบ" | mkV "เผา" | mkV "ย่าง" ; -- src=panlex
lin bake_V2 = mkV2 "อบ" ; ---- | mkV "ร้อนตับแตก" | mkV "ร้อนตับแลบ" | mkV "ร้อนอบอ้าว" | mkV "ร้อนอย่างกับเตาอบ" | mkV "อบ" | mkV "เผา" | mkV "ย่าง" ; -- src=panlex
lin baker_N = mkN "คนทำขนม" | mkN "คนอบขนม" | mkN "คนขายขนมอบ" | mkN "คนขายขนมปัง" | mkN "คนทําขนมปัง" ; -- src=panlex
lin bakery_N = mkN "ร้านขนมปัง" | mkN "ร้านขนมเค้ก" | mkN "ร้านขายขนมอบ" | mkN "ร้านเบเกอรี่" | mkN "ร้านขายขนมปัง" | mkN "ร้านขนมปัง" | mkN "โรงทําขนมปัง" | mkN "ร้านขายขนมปัง" ; -- src=panlex
lin baking_N = mkN "การอบ" | mkN "การอบขนมปังหรือเค้ก" | mkN "การอบ" | mkN "การย่าง" | mkN "การปิ้งขนมปัง" ; -- src=panlex
lin baklava_N = mkN "บาคลาวา" ; -- src=panlex
lin baksheesh_N = mkN "ทิป" ; -- src=panlex
lin balaclava_N = mkN "ไอ้โม่ง" | mkN "หมวกไอ้โม่ง" | mkN "หมวกเหล็กที่คลุมหัว คอ ยกเว้นหน้า" ; -- src=panlex
lin balalaika_N = mkN "บาลาไลกา" | mkN "เครื่องดนตรีชนิดหนึ่งเหมือนกีตาร์" ; -- src=panlex
lin balance_N = mkN "ดุลบัญชี" | mkN "ความสมดุล" | mkN "ความสมมาตร" | mkN "ส่วนที่เหลือ" | mkN "การรักษาสมดุล" | mkN "ตัวถ่วงน้ำหนัก" | mkN "น้ำหนักถ่วงดุล" | mkN "ยอดเงินคงเหลือ" | mkN "ความเท่าเทียมกัน" | mkN "สติ" | mkN "ตาชู" | mkN "งบดุล" | mkN "ตาชั่ง" | mkN "ตาเต็ง" | mkN "คันชั่ง" | mkN "ดุลยภาพ" | mkN "ยอดยกไป" | mkN "การทรงตัว" | mkN "ความสมดุล" | mkN "ความสุขุม" | mkN "สภาพคงที่" | mkN "จํานวนเหลือ" | mkN "ปิดบัญชีคงเหลือ" ; -- src=panlex
lin balance_V = mkV "ทำให้สมดุล" | mkV "ตั้งให้สมดุล" | mkV "ตั้งให้บาลานซ์" | mkV "คิดงบดุล" | mkV "ทําให้สมดุล" | mkV "ทําให้เข้าสู่ดุลยภาพ" ; -- src=panlex
lin balance_V2 = mkV2 "ทำให้สมดุล" ; ---- | mkV "ตั้งให้สมดุล" | mkV "ตั้งให้บาลานซ์" | mkV "คิดงบดุล" | mkV "ทําให้สมดุล" | mkV "ทําให้เข้าสู่ดุลยภาพ" ; -- src=panlex
lin balanced_A = mkA "สมดุล" | mkA "ที่สมดุล" | mkA "ได้สัดส่วน" ; -- src=panlex
lin balancer_N = mkN "นักกายกรรมทรงตัว" | mkN "บุคคลหรือสิ่งที่ทําให้สมดุล" ; -- src=panlex
lin balas_N = mkN "บาลัสรูบี้" ; -- src=panlex
lin balata_N = mkN "ต้นบาลาตา" ; -- src=panlex
lin balboa_N = mkN "บัลโบ" ; -- src=panlex
lin balbriggan_N = mkN "บาลบริกเกน" ; -- src=panlex
lin balconied_A = mkA "ที่มีระเบียง" ; -- src=panlex
lin balcony_N = mkN "นอกชาน" | mkN "ชาน" | mkN "มุข" | mkN "นอกชาน" | mkN "เฉลียง" | mkN "เทอเรซ" | mkN "ระเบียง" | mkN "หน้ามุข" | mkN "ที่นั่งชั้นบน" | mkN "ที่นั่งในโรงละครชั้นบน" ; -- src=panlex
lin bald_A = mkA "หัวล้าน" | mkA "หัวโล้น" | mkA "หัวโกร๋น" | mkA "ซึ่งมีศีรษะล้าน" | mkA "ล้าน" | mkA "โล่ง" | mkA "โล้น" | mkA "ศรีษะล้าน" ; -- src=panlex
lin baldachin_N = mkN "พิดานศักดิ์" ; -- src=panlex
lin balderdash_N = mkN "ความไร้สาระ" | mkN "ความเหลวไหล" | mkN "คําพูดที่เหลวไหล" | mkN "การเขียนหรือพูดไร้สาระ" ; -- src=panlex
lin bald_head_N = mkN "คนหัวล้าน" | mkN "คนหัวโล้น" ; -- src=panlex
lin balding_A = mkA "ล้าน" | mkA "หัวล้าน" | mkA "หัวล้าน" | mkA "ซึ่งมีหัวล้าน" ; -- src=panlex
lin baldness_N = mkN "อาการหัวล้าน" | mkN "ความล้าน" | mkN "ความโล่ง" ; -- src=panlex
lin baldric_N = mkN "สายสะพายดาบ" ; -- src=panlex
lin bale_N = mkN "หีบห่อ" | mkN "หีบห่อ" | mkN "มัดใหญ่" | mkN "ห่อใหญ่" | mkN "ความชั่ว" | mkN "ม้วนใหญ่" | mkN "ความหายนะ" | mkN "บรรจุภัณฑ์" | mkN "ความทุกข์ทรมาน" | mkN "ความเคราะห์ร้าย" ; -- src=panlex
lin baleful_A = mkA "ร้ายกาจ" | mkA "ชั่วร้าย" | mkA "มุ่งร้าย" | mkA "ทําให้เกิดอันตราย" | mkA "มุ่งร้ายหรือร้ายกาจ" ; -- src=panlex
lin balk_N = mkN "คาน" | mkN "ส่วนบอค" | mkN "สิ่งกีดขวาง" | mkN "คานค้ำหลังคา" | mkN "การทำผิดกฎของพิทเชอร์" | mkN "การหยุดยั้ง" | mkN "ความผิดหวัง" | mkN "ความพ่ายแพ้" ; -- src=panlex
lin balk_V = mkV "ต่อต้าน" | mkV "ชะงัก" | mkV "ขัดขวาง" | mkV "คัดค้าน" | mkV "ต้านทาน" | mkV "หยุดยั้ง" | mkV "หยุดอย่างกระทันหัน" ; -- src=panlex
lin balk_V2 = mkV2 "ต่อต้าน" ; ---- | mkV "ชะงัก" | mkV "ขัดขวาง" | mkV "คัดค้าน" | mkV "ต้านทาน" | mkV "หยุดยั้ง" | mkV "หยุดอย่างกระทันหัน" ; -- src=panlex
lin balkline_N = mkN "เส้นขึ้นลูกบิลเลียด" ; -- src=panlex
lin ball_N = mkN "บอล" | mkN "ลูก" | mkN "ก้อน" | mkN "อัณฑะ" | mkN "ลูกบอล" | mkN "ก้อนกลม" | mkN "ก้อนดิน" | mkN "เล็ดไข่" | mkN "ก้อนกลมๆ" | mkN "งานบอลล์" | mkN "พระอัณฑะ" | mkN "ลูกอัณฑะ" | mkN "กลุ่มก้อน" | mkN "รูปทรงกลม" | mkN "ลูกกระสุน" | mkN "ลูกกระแป๋ง" | mkN "ลูก" | mkN "ลูกตา" | mkN "งานบอล" | mkN "ลูกบอล" | mkN "ก้อนกลม" | mkN "งานลีลาศ" | mkN "งานเลี้ยง" | mkN "การขว้างบอล" | mkN "งานราตรีสโมสร" | mkN "ลูกลักษณะกลมๆ" | mkN "สโมสรสันนิบาต" | mkN "สิ่งที่เป็นรูปทรงกลม" | mkN "ส่วนของร่างกายที่มีลักษณะกลม" ; -- src=panlex
lin ball_V = mkV "ม้วนเป็นลูกบอล" | mkV "ทําให้เป็นรูปกลม" | mkV "จับก้อนเป็นลูกบอล" ; -- src=panlex
lin ball_V2 = mkV2 "ม้วนเป็นลูกบอล" ; ---- | mkV "ทําให้เป็นรูปกลม" | mkV "จับก้อนเป็นลูกบอล" ; -- src=panlex
lin ballad_N = mkN "เพลง" | mkN "ลำนำนิทาน" | mkN "นิทานขับลำ" | mkN "นิทานพื้นบ้านคำกลอน" | mkN "เพลง" | mkN "เพลงลูกทุ่ง" | mkN "เพลงพื้นเมือง" | mkN "บทกวีบาทชนิดหนึ่ง" | mkN "โคลงที่มีใจความเป็นบรรยายโวหาร" | mkN "เพลงที่มีใจความเป็นการบรรยายโวหาร" | mkN "เพลงช้าที่มีใจความบรรยายถึงความรัก" ; -- src=panlex
lin ballade_N = mkN "บทร้อยกรองบาลาด" ; -- src=panlex
lin ballast_N = mkN "แบลลัสต์" | mkN "เรือบรรทุกของถ่วงน้ําหนัก" | mkN "การถ่วงท้องเรือด้วยของหนักๆ" ; -- src=panlex
lin ballcock_N = mkN "ลูกลอย" ; -- src=panlex
lin ballerina_N = mkN "นักบัลเลต์หญิง" | mkN "นักเต้นบัลเลต์หญิง" | mkN "นักเต้นระบําบาเล่ท์หญิง" | mkN "นักเต้นระบําปลายเท้าหญิง" ; -- src=panlex
lin ballet_N = mkN "บัลเลต์" | mkN "เพลงบัลเลต์" | mkN "ระบำปลายเท้า" | mkN "การแสดงบัลเลต์" | mkN "ดนตรีสำหรับบัลเลต์" | mkN "ระบําบาเล่ห์" | mkN "ระบําปลายเท้า" | mkN "การเต้นบัลเลต์" ; -- src=panlex
lin balletomania_N = mkN "ความหลงใหลในบัลเลต์" ; -- src=panlex
lin ballgame_N = mkN "บอลเกม" ; -- src=panlex
lin ballistic_A = mkA "เกี่ยวกับขีปนาวุธ" | mkA "เกี่ยวกับการเคลื่อนที่ของวัตถุในอากาศ" ; -- src=panlex
lin ballistics_N = mkN "ขีปนศาสตร์" | mkN "การศึกษาเกี่ยวกับขีปนาวุธ" | mkN "การศึกษาการเคลื่อนไหวของกระสุนปืนและจรวด / ขีปนาวุธ" ; -- src=panlex
lin ballistocardiograph_N = mkN "คาร์ดิโอกราฟ" ; -- src=panlex
lin ballock_N = mkN "อัณฑะ" | mkN "เล็ดไข่" | mkN "พระอัณฑะ" | mkN "ลูกอัณฑะ" | mkN "ลูกกระแป๋ง" ; -- src=panlex
lin balloon_N = mkN "บอลลูน" | mkN "บัลลูน" | mkN "ลูกโป่ง" | mkN "ลูกโป่งสวรรค์" | mkN "ลูกโป่ง" | mkN "ลูกบอลลูน" | mkN "บอลลูนใช้เดินทาง" ; -- src=panlex
lin balloon_V = mkV "พองขึ้น" | mkV "นั่งบอลลูน" | mkV "โป่งออก" | mkV "ทําให้โป่งออก" ; -- src=panlex
lin balloon_V2 = mkV2 "พองขึ้น" ; ---- | mkV "นั่งบอลลูน" | mkV "โป่งออก" | mkV "ทําให้โป่งออก" ; -- src=panlex
lin balloonfish_N = mkN "บอลลูนฟิช" ; -- src=panlex
lin ballooning_N = mkN "การบิน" ; -- src=panlex
lin balloonist_N = mkN "นักบินบอลลูน" | mkN "ผู้ที่คอยควบคุมบอลลูน" ; -- src=panlex
lin ballot_N = mkN "การโหวต" | mkN "ใบรูปเข็ม" | mkN "การลงคะแนนเสียง" | mkN "จับฉลาก" | mkN "บัตรเลือกตั้ง" | mkN "จํานวนผู้ลงคะแนน" | mkN "วิธีลงคะแนนเสียงแบบลับ" ; -- src=panlex
lin ballot_V = mkV "ลงคะแนนโดยใช้บัตร" | mkV "จับสลาก" | mkV "ลงคะแนน" | mkV "ออกเสียงลงคะแนน" ; -- src=panlex
lin ballpark_N = mkN "ระยะประมาณ" | mkN "สนามเบสบอล" ; -- src=panlex
lin ballpen_N = mkN "ลูกลื่น" | mkN "ปากกาลูกลื่น" ; -- src=panlex
lin ballplayer_N = mkN "นักเบสบอล" | mkN "นักกีฬาเบสบอล" | mkN "ผู้เล่นเบสบอล" ; -- src=panlex
lin ballpoint_N = mkN "ลูกลื่น" | mkN "ปากกาลูกลื่น" | mkN "ปากกาลูกลื่น" ; -- src=panlex
lin ballroom_N = mkN "ห้องเต้นรำ" | mkN "ที่เต้นรํา" | mkN "ห้องเต้นรํา" ; -- src=panlex
lin ballup_N = mkN "ความสับสน" ; -- src=panlex
lin bally_A = mkA "เต็มที่" | mkA "อย่างยิ่ง" | mkA "เหลือเกิน" ; -- src=panlex
lin ballyhoo_N = mkN "การโฆษณา" | mkN "การป่าวประกาศ" | mkN "การส่งเสียงอึกทึก" ; -- src=panlex
lin balm_N = mkN "บาล์ม" | mkN "ยาหม่อง" | mkN "ยาขี้ผึ้ง" | mkN "ขี้ผึ้งทารักษาแผล" | mkN "ขี้ผึ้ง" | mkN "ยาหม่อง" | mkN "ไขมันหอม" | mkN "น้ํามันหอม" | mkN "ยาขี้ผึ้งแก้ปวด" ; -- src=panlex
lin balmoral_N = mkN "ร้องเท้าแบลมอเรล" ; -- src=panlex
lin balmy_A = mkA "โง่" | mkA "นิ่ม" | mkA "บรรเทา" | mkA "ชุ่มชื้น" | mkA "มีกลิ่นหอม" | mkA "เย็นคล้ายยาหม่อง" ; -- src=panlex
lin baloney_N = mkN "เรื่องเหลวไหล" | mkN "เรื่องไร้สาระ" | mkN "คําพูดไร้สาระ" ; -- src=panlex
lin balsa_N = mkN "ต้นบัลซา" | mkN "ไม้บัลซา" | mkN "ไม้บัลซาวู้ด" | mkN "ต้นไม้เขตร้อนของอเมริกา" ; -- src=panlex
lin balsam_N = mkN "ยาหม่อง" | mkN "ขี้ผึ้งยา" | mkN "ยางไม้หอมชนิดหนึ่ง" | mkN "ต้นไม้ที่มีน้ํามันหอม" ; -- src=panlex
lin balsamroot_N = mkN "ต้นบอลแซมรูต" ; -- src=panlex
lin baluster_N = mkN "ลูกกรงราวบันได" | mkN "กรง" | mkN "ซี่กรง" | mkN "ลูกกรง" | mkN "ซี่ลูกกรง" | mkN "ซี่ราวบันได / เฉลียง" | mkN "เสาราวระเบียง" ; -- src=panlex
lin balustrade_N = mkN "ราวบันได" | mkN "ราวระเบียง" | mkN "ราวบันไดหรือสะพาน" ; -- src=panlex
lin bamboo_N = mkN "ไผ่" | mkN "ต้นไผ่" | mkN "ไม้ไผ่" | mkN "ไผ่" | mkN "ต้นไผ่" | mkN "ไม้ไผ่" ; -- src=panlex
lin ban_N = mkN "แบน" | mkN "ห้าม" | mkN "การห้าม" | mkN "การห้าม" | mkN "คําสั่งห้าม" ; -- src=panlex
lin banal_A = mkA "ซ้ํา ๆ ซาก ๆ" | mkA "เก่าแก่" | mkA "น่าเบื่อ" | mkA "ธรรมดามาก" | mkA "ไม่น่าสนใจ" | mkA "ไม่สร้างสรรค์" | mkA "ไร้ความสดชื่น" ; -- src=panlex
lin banality_N = mkN "คำพูดซ้ำซาก" | mkN "สำนวนประดาษ" | mkN "ความน่าเบื่อ" | mkN "ความธรรมดามาก" | mkN "ความไม่สร้างสรรค์" ; -- src=panlex
lin banana_N = mkN "กล้วย" | mkN "ผลกล้วย" | mkN "ต้นกล้วย" | mkN "กล้วย" | mkN "กัทลี" | mkN "พืชกล้วย" ; -- src=panlex
lin band_N = mkN "วง" | mkN "แถบ" | mkN "แหวน" | mkN "คอคอด" | mkN "แบนด์" | mkN "สายคาด" | mkN "สายรัด" | mkN "กลุ่มคน" | mkN "ธำมรงค์" | mkN "วงดนตรี" | mkN "วงสตริง" | mkN "สายรุ้ง" | mkN "พระธำมรงค์" | mkN "วงดนตรีสตริง" | mkN "คณะ" | mkN "พวก" | mkN "แถบ" | mkN "พันธะ" | mkN "เชือก" | mkN "แตรวง" | mkN "สายคาด" | mkN "สายรัด" | mkN "กลุ่มคน" | mkN "วงดนตรี" | mkN "ข้อผูกพัน" | mkN "ข้อผูกมัด" | mkN "แถบคลื่นวิทยุ" | mkN "แถบคลื่นความถี่" ; -- src=panlex
lin band_V = mkV "สวมแหวน" | mkV "ผูกสายรัด" | mkV "ผูก" | mkV "คาดด้วยผ้าแถบ" | mkV "ผูกด้วยผ้าแถบ" | mkV "รัดด้วยสายรัด" | mkV "ประดับด้วยสายหรือแถบ" ; -- src=panlex
lin band_V2 = mkV2 "สวมแหวน" ; ---- | mkV "ผูกสายรัด" | mkV "ผูก" | mkV "คาดด้วยผ้าแถบ" | mkV "ผูกด้วยผ้าแถบ" | mkV "รัดด้วยสายรัด" | mkV "ประดับด้วยสายหรือแถบ" ; -- src=panlex
lin bandage_N = mkN "ผ้าพันแผล" | mkN "ผ้าพันแผล" ; -- src=panlex
lin bandanna_N = mkN "ผ้าพันคอ" ; -- src=panlex
lin bandbox_N = mkN "กล่องทรงกระบอก" | mkN "กล่องใส่ของกระจุกกระจิก" ; -- src=panlex
lin bandeau_N = mkN "บรา" | mkN "ยกทรง" | mkN "เสื้อใน" | mkN "บราเซียร์" | mkN "ผ้าปิดตา" | mkN "ผ้าพันศีรษะ" | mkN "ผ้าพันผมสตรี" | mkN "ผ้าพันแผลสตรี" ; -- src=panlex
lin banderilla_N = mkN "แบนเดอริลลา" ; -- src=panlex
lin banderillero_N = mkN "แบนเดอเรลแยโร" ; -- src=panlex
lin bandicoot_N = mkN "แบนดิคูต" ; -- src=panlex
lin bandit_N = mkN "โจรร่วมขบวนการ" | mkN "โจร" | mkN "ผู้ร้าย" | mkN "คนนอกกฎหมาย" ; -- src=panlex
lin banditry_N = mkN "การขโมยและก่อความรุนแรงของผู้ร้าย" ; -- src=panlex
lin bandleader_N = mkN "ผู้นำวง" | mkN "วาทยากร" ; -- src=panlex
lin bandmaster_N = mkN "ผู้ควบคุมวงดนตรี" | mkN "ผู้นําจังหวะวงดนตรี" ; -- src=panlex
lin bandoleer_N = mkN "สายสะพายกระสุน" | mkN "แถบลูกปืนที่ใช้รัดหรือพาดบริเวณไหล่" ; -- src=panlex
lin bandolier_N = mkN "สายสะพายกระสุน" | mkN "แถบลูกปืนที่ใช้รัดหรือพาดบริเวณไหล่" ; -- src=panlex
lin bandoneon_N = mkN "แบนโดเนียน" ; -- src=panlex
lin band_saw_N = mkN "เลื่อนสายพาน" ; -- src=panlex
lin bandsman_N = mkN "นักเล่นวงดนตรี" | mkN "นักดนตรีที่เล่นในวงดนตรี" ; -- src=panlex
lin bandstand_N = mkN "เวทีวงดนตรี" | mkN "เวทีวงดนตรีที่ยกขึ้น" ; -- src=panlex
lin bandwagon_N = mkN "กระแสที่คนนิยม" | mkN "รถบรรทุกเครื่องดนตรี" | mkN "ความนิยม" | mkN "รถดนตรีในขบวนแห่" ; -- src=panlex
lin bandwidth_N = mkN "ช่วงความถี่ของวิทยุ" | mkN "ช่วงความถี่ของคลื่นวิทยุ" ; -- src=panlex
lin bandy_A = mkA "ขาโก่ง" ; -- src=panlex
lin bane_N = mkN "สิ่งที่ทำให้ตาย" | mkN "เหตุแห่งความหายนะ" | mkN "ความตาย" | mkN "การทําลาย" | mkN "ความหายนะ" | mkN "ของที่มีพิษ" | mkN "บุคคลหรือสิ่งที่ทําลาย" | mkN "สิ่งที่ก่อให้เกิดความตายหรือความเสียหาย" ; -- src=panlex
lin baneberry_N = mkN "เบนเบอรี่" | mkN "ลูกเบนเบอรี่" | mkN "ต้นบานเบอร์รี่" ; -- src=panlex
lin baneful_A = mkA "เป็นพิษ" | mkA "ซึ่งทําลาย" | mkA "นําความหายนะ" | mkA "ก่อความเสียหาย" ; -- src=panlex
lin bang_Adv = mkAdv "ตรง" | mkAdv "กะทันหัน" | mkAdv "อย่างไม่คาดฝัน" ; -- src=panlex
lin bang_N = mkN "การทุบ" | mkN "การฟาด" | mkN "การเตะ" | mkN "การทุบตี" | mkN "การจู่โจม" | mkN "ผมหน้าม้า" | mkN "เสียงโครม" | mkN "การแผดเสียง" | mkN "เสียงดังมาก" | mkN "ทรงผมหน้าม้า" | mkN "การชนอย่างแรง" | mkN "เสียงดังระเบิด" | mkN "ความสำเร็จที่ปรากฏ" | mkN "ผมม้า" | mkN "การฟาด" | mkN "ความสนุก" | mkN "เสียงปัง" | mkN "ลั่นดังปัง" | mkN "เสียงดังมาก" | mkN "เสียงระเบิด" | mkN "ผมปรกหน้าผาก" | mkN "การตีอย่างแรง" | mkN "การระเบิดของพลังงาน" ; -- src=panlex
lin bang_V = mkV "นอน" | mkV "ปี้" | mkV "ล่อ" | mkV "หวด" | mkV "เอา" | mkV "เย็ด" | mkV "ตีหม้อ" | mkV "เสพกาม" | mkV "ร่วมรัก" | mkV "ร่วมสุข" | mkV "ร่วมเพศ" | mkV "หลับนอน" | mkV "มีเซ็กส์" | mkV "เสพเมถุน" | mkV "ปิดกระแทก" | mkV "ร่วมประเวณี" | mkV "มีเพศสัมพันธ์" | mkV "ฟาด" | mkV "ตัดผมม้า" | mkV "กระแทกปิด" | mkV "ปิดดังปัง" | mkV "ตีอย่างแรง" | mkV "ปิดอย่างแรง" | mkV "ตัดผมปรกหน้าผาก" | mkV "ทํากระแทกกระทั้น" | mkV "ทําเสียงดังปึงปัง" ; -- src=panlex
lin bang_V2 = mkV2 "นอน" ; ---- | mkV "ปี้" | mkV "ล่อ" | mkV "หวด" | mkV "เอา" | mkV "เย็ด" | mkV "ตีหม้อ" | mkV "เสพกาม" | mkV "ร่วมรัก" | mkV "ร่วมสุข" | mkV "ร่วมเพศ" | mkV "หลับนอน" | mkV "มีเซ็กส์" | mkV "เสพเมถุน" | mkV "ปิดกระแทก" | mkV "ร่วมประเวณี" | mkV "มีเพศสัมพันธ์" | mkV "ฟาด" | mkV "ตัดผมม้า" | mkV "กระแทกปิด" | mkV "ปิดดังปัง" | mkV "ตีอย่างแรง" | mkV "ปิดอย่างแรง" | mkV "ตัดผมปรกหน้าผาก" | mkV "ทํากระแทกกระทั้น" | mkV "ทําเสียงดังปึงปัง" ; -- src=panlex
lin banger_N = mkN "ประทัด" | mkN "ไส้กรอกหมู" | mkN "ไส้กรอก" ; -- src=panlex
lin banging_N = mkN "การกระแทก" | mkN "การชนอย่างแรง" | mkN "การเคาะอย่างแรง" ; -- src=panlex
lin bangle_N = mkN "กำไล" | mkN "สร้อย" | mkN "กําไล" | mkN "กําไลมือ" | mkN "กําไลเท้า" | mkN "สร้อยข้อเท้าหรือข้อมือ" ; -- src=panlex
lin banian_N = mkN "ต้นไทร" | mkN "เสื้อแบนเยิน" ; -- src=panlex
lin banishment_N = mkN "การเนรเทศ" | mkN "การเนรเทศ" ; -- src=panlex
lin banister_N = mkN "ราวบันได" | mkN "ราวระเบียง" | mkN "ราวบันได" | mkN "ราวเฉลียง" | mkN "ราวระเบียง" | mkN "ราวระเบียงหรือบันได" ; -- src=panlex
lin banjo_N = mkN "แบนโจ" | mkN "แบนโจ" | mkN "เครื่องดนตรีประเภทเดียวกับกีตาร์" | mkN "ส่วนล่างเป็นรูปกลม มีสาย 4-5 สาย" ; -- src=panlex
lin bank_1_N = mkN "ธ." | mkN "ฝั่ง" | mkN "แบงค์" | mkN "ความลาด" | mkN "คลังสำรอง" | mkN "ตึกธนาคาร" | mkN "การลาดเอียง" | mkN "กล่องใส่เงิน" | mkN "สถาบันการเงิน" | mkN "เงินบ่อนคาสิโน" | mkN "เงินบ่อนการพนัน" | mkN "ของที่วางเป็นแถวเดียวกัน" | mkN "แถว" | mkN "แนว" | mkN "ฝั่ง" | mkN "ตลิ่ง" | mkN "เทือก" | mkN "แบงค์" | mkN "ทิวยาว" | mkN "ธนาคาร" | mkN "มูลดิน" | mkN "เขื่อน" | mkN "ชายฝั่ง" | mkN "เงินพนัน" | mkN "ที่ลาดชัน" | mkN "เอียงข้าง" | mkN "การลาดเอียง" | mkN "ที่ตื้นเขิน" | mkN "ฝากเงินธนาคาร" | mkN "ที่เก็บข้อมูล อาหารหรือเลือดเพื่อใช้ตอนฉุกเฉิน" | mkN "สิ่งที่สํารองเอาไว้" | mkN "เงินที่ได้จากการเล่นการพนัน" ; -- src=panlex
lin bank_2_N = placeN (thword "ธนา" "คาร") ;
lin bank_V = mkV "ฝาก" | mkV "วางใจ" | mkV "ไว้ใจ" | mkV "มั่นใจ" | mkV "ฝากเงิน" | mkV "ฝากแบงค์" | mkV "ฝากธนาคาร" | mkV "ทำงานแบงค์" | mkV "ทำงานธนาคาร" | mkV "คลุมด้วยขี้เถ้า" | mkV "ทำธุรกรรมกับธนาคาร" | mkV "สะสม" | mkV "เอามากอง" | mkV "ทําให้เอียง" | mkV "ทําให้เป็นกอง" | mkV "เอาเงินฝากธนาคาร" | mkV "เอาเงินเข้าธนาคาร" | mkV "ใส่ขี้เถ้าลงในไฟเพื่อให้ความร้อนลดลงและไหม้ช้า" ; -- src=panlex
lin bank_V2 = mkV2 "ฝาก" ; ---- | mkV "วางใจ" | mkV "ไว้ใจ" | mkV "มั่นใจ" | mkV "ฝากเงิน" | mkV "ฝากแบงค์" | mkV "ฝากธนาคาร" | mkV "ทำงานแบงค์" | mkV "ทำงานธนาคาร" | mkV "คลุมด้วยขี้เถ้า" | mkV "ทำธุรกรรมกับธนาคาร" | mkV "สะสม" | mkV "เอามากอง" | mkV "ทําให้เอียง" | mkV "ทําให้เป็นกอง" | mkV "เอาเงินฝากธนาคาร" | mkV "เอาเงินเข้าธนาคาร" | mkV "ใส่ขี้เถ้าลงในไฟเพื่อให้ความร้อนลดลงและไหม้ช้า" ; -- src=panlex
lin bankable_A = mkA "ทำเงิน" | mkA "ซึ่งฝากธนาคารได้" | mkA "ซึ่งเก็บเงินไว้ให้บางคน" ; -- src=panlex
lin bank_book_N = mkN "สมุดธนาคาร" | mkN "สมุดเงินฝากของธนาคาร" ; -- src=panlex
lin banker_N = mkN "นายธนาคาร" | mkN "ลูกหนี้ธนาคาร" | mkN "เจ้ามือ" | mkN "นายธนาคาร" | mkN "แท่นทํางาน" | mkN "เจ้ามือการพนัน" | mkN "แท่นแบบของงานแกะสลักหิน หรือก่ออิฐ" ; -- src=panlex
lin banking_N = mkN "การทำธุรกรรมทางการเงิน" | mkN "การทำธุรกรรมผ่านธนาคาร" | mkN "การธนาคาร" ; -- src=panlex
lin banknote_N = mkN "แบงค์" | mkN "ธนบัตร" | mkN "เงินกระดาษ" | mkN "ธนบัตร" ; -- src=panlex
lin bankroll_N = mkN "ม้วนธนบัตร" | mkN "แหล่งของเงิน" | mkN "เงินที่อยู่ในครอบครอง" | mkN "เงินทุนสําหรับโครงการหนึ่งๆ" ; -- src=panlex
lin bankrupt_A = mkA "ล้มละลาย" | mkA "เจ๊งหมดตัว" ; -- src=panlex
lin bankrupt_N = mkN "คนล้มละลาย" | mkN "ผู้ล้มละลาย" | mkN "บุคคลล้มละลาย" | mkN "บุคคลล้มละลาย" ; -- src=panlex
lin bankruptcy_N = mkN "การล้มละลาย" | mkN "การล้มราชบัลลังก์" | mkN "การล้มละลาย" | mkN "ความล้มเหลว" | mkN "ภาวะล้มละลาย" | mkN "ภาวะสิ้นเนื้อประดาตัว" ; -- src=panlex
lin banksia_N = mkN "ต้นแบงค์เซีย" ; -- src=panlex
lin banner_A = mkA "ที่ประสบผลสําเร็จ" | mkA "ที่ดีหรือเด่นเป็นพิเศษ" ; -- src=panlex
lin banner_N = mkN "ผ้าแถบ" | mkN "พาดหัวข่าว" | mkN "พาดหัวยักษ์เต็มหน้า" | mkN "ธง" | mkN "ผืนธง" | mkN "ร่มธง" | mkN "พาดหัวข่าว" ; -- src=panlex
lin bannister_N = mkN "ราวบันได" | mkN "ราวระเบียง" | mkN "ราวระเบียงหรือบันได" ; -- src=panlex
lin bannock_N = mkN "ขนมปังกลมแบน" ; -- src=panlex
lin banquet_N = mkN "โต๊ะจีน" | mkN "งานเลี้ยง" | mkN "อาหารโต๊ะจีน" | mkN "งานเลี้ยงฉลอง" | mkN "อาหารงานเลี้ยง" | mkN "งานเลี้ยง" | mkN "งานรื่นเริง" | mkN "ไปรับประทานอาหารในงานเลี้ยง" | mkN "การรับประทานอาหารอย่างฟุ่มเฟือย" ; -- src=panlex
lin banquet_V = mkV "กินเลี้ยง" | mkV "จัดงานเลี้ยง" | mkV "ร่วมงานเลี้ยง" ; -- src=panlex
lin banquet_V2 = mkV2 "กินเลี้ยง" ; ---- | mkV "จัดงานเลี้ยง" | mkV "ร่วมงานเลี้ยง" ; -- src=panlex
lin banquette_N = mkN "ทางเดินข้างถนน" | mkN "ม้านั่งหุ้มใส่นวม" | mkN "ม้านั่งตรงหน้าต่าง" | mkN "เชิงที่มั่นสําหรับยิงของทหาร" ; -- src=panlex
lin banshee_N = mkN "แบนชี" | mkN "วิญญาณหญิงที่ร้องครวญครางเตือนว่าคนในบ้านกําลังจะตาย" ; -- src=panlex
lin bantam_A = mkA "เล็กพริกขี้หนู" ; -- src=panlex
lin bantam_N = mkN "ไก่แจ้" | mkN "ไก่แจ้" | mkN "ไก่ขนาดเล็ก" | mkN "ไก่ชนิดหนึ่ง" ; -- src=panlex
lin bantamweight_N = mkN "นักชกรุ่นแบนตั้มเวท" | mkN "นักมวยปล้ำรุ่นแบนตั้มเวท" | mkN "นักมวยรุ่นแบนตัมเวท" | mkN "นักมวยรุ่นน้ําหนักตัว 51-53.5 กิโลกรัม" ; -- src=panlex
lin banteng_N = mkN "วัวแดง" ; -- src=panlex
lin banter_N = mkN "การล้อเล่น" | mkN "การหยอกล้อ" | mkN "การล้อเล่น" | mkN "การเย้าแหย่" | mkN "การพูดหยอกเย้า" ; -- src=panlex
lin banter_V = mkV "ล้อเล่น" | mkV "ยั่ว" | mkV "แหย่" | mkV "แกล้ง" | mkV "ล้อเล่น" | mkV "หยอกเย้า" ; -- src=panlex
lin banter_V2 = mkV2 "ล้อเล่น" ; ---- | mkV "ยั่ว" | mkV "แหย่" | mkV "แกล้ง" | mkV "ล้อเล่น" | mkV "หยอกเย้า" ; -- src=panlex
lin banteringly_Adv = mkAdv "อย่างหยิกแกมหยอก" ; -- src=panlex
lin banting_N = mkN "วัวแดง" ; -- src=panlex
lin banyan_N = mkN "ต้นไทร" | mkN "เสื้อแบนเยิน" | mkN "ไทร" | mkN "ต้นไทร" | mkN "เสื้อคลุมของชาวฮินดู" ; -- src=panlex
lin banzai_N = mkN "บันไซ" ; -- src=panlex
lin baobab_N = mkN "ต้นเบโอแบบ" ; -- src=panlex
lin bap_N = mkN "ม้วนขนมปังแบน กลมและเล็ก" ; -- src=panlex
lin baptism_N = mkN "ศีลจุ่ม" | mkN "บัพติศมา" | mkN "ศีลล้างบาป" | mkN "พีธีล้างบาปในศาสนาคริสต์" ; -- src=panlex
lin bar_1_N = mkN (thword "บาร์") ;
lin bar_2_N = variants {} ;
lin barb_N = mkN "กิ่งขน" | mkN "เงี่ยง" | mkN "ปลายลวด" | mkN "กิ่งขนนก" | mkN "การขุดคุ้ย" | mkN "การเยาะเย้ย" | mkN "คำพูดทิ่มแทง" | mkN "คำพูดเย้ยหยัน" | mkN "คำพูดทิ่มแทงใจ" | mkN "หนวด" | mkN "เงี่ยง" | mkN "ลวดหนาม" | mkN "ขวากหนาม" | mkN "หนามเบ็ด" | mkN "เงี่ยงปลา" ; -- src=panlex
lin barbarian_A = mkA "ป่าเถื่อน" | mkA "ไร้อารยธรรม" ; -- src=panlex
lin barbarian_N = mkN "คนเถื่อน" | mkN "คนชั้นต่ำ" | mkN "คนงุ่มง่าม" | mkN "คนป่าเถื่อน" | mkN "บาร์บาเรียน" | mkN "คนไร้การศึกษา" | mkN "คนป่า" | mkN "อนารยชน" | mkN "คนเถื่อน" | mkN "คนหยาบคาย" | mkN "คนโหดร้าย" | mkN "คนป่าเถื่อน" ; -- src=panlex
lin barbaric_A = mkA "ป่าเถื่อน" | mkA "ไร้อารยธรรม" | mkA "ทารุณ" | mkA "อนารยะ" | mkA "เถื่อน" | mkA "หยาบคาย" | mkA "ป่าเถื่อน" | mkA "ไม่มีวัฒนธรรม" ; -- src=panlex
lin barbarism_N = mkN "ความโหดเหี้ยม" | mkN "อนารยธรรม" | mkN "ความป่าเถื่อน" | mkN "สภาพป่าเถื่อน" ; -- src=panlex
lin barbarity_N = mkN "ความเลวร้าย" | mkN "ความโหดเหี้ยม" | mkN "ความโหดเหี้ยมทารุณ" | mkN "ความหยาบ" | mkN "ความทารุณ" | mkN "อนารยธรรม" | mkN "ความโหดร้าย" | mkN "ความป่าเถื่อน" | mkN "ความโหดเหี้ยม" | mkN "ความไม่มีวัฒนธรรม" | mkN "การกระทําที่โหดร้าย" ; -- src=panlex
lin barbarous_A = mkA "ดุร้าย" | mkA "หยาบคาย" | mkA "โหดร้าย" | mkA "ป่าเถื่อน" | mkA "โหดเหี้ยม" ; -- src=panlex
lin barbasco_N = mkN "ต้นบาร์บาสโก" ; -- src=panlex
lin barbecue_N = mkN "บาร์บีคิว" | mkN "ตะแกรงย่างบาร์บีคิว" | mkN "บาร์บีคิว" | mkN "เนื้อย่าง" | mkN "ตะแกรงย่าง" | mkN "หมูหรือวัวที่ย่างทั้งตัว" | mkN "การย่างอาหารโดยใช้เหล็กเสียบเนื้อสัตว์" ; -- src=panlex
lin barbecuing_N = mkN "การย่างบาร์บีคิว" ; -- src=panlex
lin barbed_A = mkA "ซึ่งมีหนาม" ; -- src=panlex
lin barbell_N = mkN "ด้ามโลหะยาวที่มีแท่งน้ําหนักที่ปลายทั้ง2ข้าง" ; -- src=panlex
lin barber_N = mkN "กัลบก" | mkN "คนตัดผม" | mkN "ช่างตัดผม" | mkN "ช่างตัดผมชาย" | mkN "ช่างตัดผม" ; -- src=panlex
lin barberry_N = mkN "ต้นบาร์เบอร์รี่" ; -- src=panlex
lin barbershop_N = mkN "ร้านตัดผม" | mkN "ร้านตัดผมชาย" | mkN "ร้านตัดผม" | mkN "ร้านทําผม" ; -- src=panlex
lin barbet_N = mkN "นกตีทอง" | mkN "นกบาร์เบต" ; -- src=panlex
lin barbican_N = mkN "หอคอยบาร์บิแคน" ; -- src=panlex
lin barbital_N = mkN "บาร์บิทอล" | mkN "บาร์บิโทน" | mkN "ยาบาร์บิทอล" | mkN "ยาบาร์บิโทน" | mkN "กรดไดเอทีลบาร์บิทูริก" | mkN "ไดเอทีลบาร์บิทูริกแอซิด" ; -- src=panlex
lin barbitone_N = mkN "บาร์บิทอล" | mkN "บาร์บิโทน" | mkN "ยาบาร์บิทอล" | mkN "ยาบาร์บิโทน" | mkN "กรดไดเอทีลบาร์บิทูริก" | mkN "ไดเอทีลบาร์บิทูริกแอซิด" ; -- src=panlex
lin barbiturate_N = mkN "บาร์บิทูเรต" | mkN "ยาบาร์บิทูเรต" | mkN "ยากดประสาทชนิดหนึ่ง" ; -- src=panlex
lin barbu_N = mkN "ปลาบาร์บู" ; -- src=panlex
lin bard_N = mkN "บทกวี" | mkN "เครื่องแต่งตัวของม้า" | mkN "กวี" ; -- src=panlex
lin bare_A = mkA "นู้ด" | mkA "เปล่า" | mkA "เปลือย" | mkA "ล่อนจ้อน" | mkA "เปลือยกาย" | mkA "ซึ่งแก้ผ้า" | mkA "นุ่งลมห่มฟ้า" | mkA "ซึ่งโชวเนื้อหนัง" | mkA "ที่ไม่ประดับประดา" | mkA "แท้ ๆ" | mkA "เปล่า" | mkA "โกร๋น" | mkA "เกรียน" | mkA "เปลือย" | mkA "น้อยมาก" | mkA "เปิดออก" | mkA "เปิดเผย" | mkA "ไม่มีใบ" | mkA "นิดเดียว" | mkA "หวุดหวิด" | mkA "แทบจะไม่พอ" | mkA "เปลือยเปล่า" | mkA "เกือบจะไม่รอด" | mkA "ไม่มีเสื้อผ้า" | mkA "ไร้สิ่งตกแต่ง" | mkA "เอาสิ่งคลุมออก" | mkA "ไม่มีสิ่งยืนยัน" | mkA "ไม่มีเครื่องหุ้มห่อ" ; -- src=panlex
lin bareback_A = mkA "ไม่มีอานม้า" ; -- src=panlex
lin bareback_Adv = mkAdv "โดยไม่มีอาน" | mkAdv "หลังเปล่าๆ ของม้า" | mkAdv "หลังม้าที่ไม่มีอาน" ; -- src=panlex
lin barebacked_Adv = mkAdv "โดยไม่มีอาน" ; -- src=panlex
lin barefaced_A = mkA "กล้า" | mkA "ไม่อาย" | mkA "เปิดเผย" | mkA "หน้าด้าน" | mkA "ไม่อายหรือหน้าด้าน" | mkA "ซึ่งมีใบหน้าที่ไม่ได้ปกคลุม" ; -- src=panlex
lin barefoot_A = mkA "ที่ไม่สวมรองเท้า" | mkA "ตีนเปล่า" | mkA "เท้าเปล่า" | mkA "ไม่ใส่รองเท้า" ; -- src=panlex
lin barefoot_Adv = mkAdv "เท้าเปล่า" | mkAdv "ตีนเปล่า" | mkAdv "เท้าเปล่า" | mkAdv "ไม่ใส่รองเท้า" ; -- src=panlex
lin barefooted_A = mkA "ที่ไม่สวมรองเท้า" | mkA "ตีนเปล่า" | mkA "เท้าเปล่า" | mkA "ไม่ใส่รองเท้า" ; -- src=panlex
lin barefooted_Adv = mkAdv "เท้าเปล่า" | mkAdv "ตีนเปล่า" | mkAdv "เท้าเปล่า" | mkAdv "ไม่ใส่รองเท้า" ; -- src=panlex
lin barehanded_A = mkA "ด้วยมือเปล่า" | mkA "มือเปล่า" | mkA "ไร้อาวุธ" | mkA "ไม่สวมถุงมือ" | mkA "ไม่มีสิ่งช่วยเหลือ" ; -- src=panlex
lin bareheaded_A = mkA "เปิดศีรษะ" | mkA "ไม่สวมหมวก" | mkA "ไม่ใส่หมวกหรือคลุมหัวด้วยสิ่งอื่น" ; -- src=panlex
lin barelegged_A = mkA "เปลือยขา" | mkA "ขาเปล่า" | mkA "ไม่มีถุงเท้า" | mkA "ไม่มีสิ่งใดคลุมขา" ; -- src=panlex
lin barely_Adv = mkAdv "แทบจะไม่" | mkAdv "อย่างไม่เพียงพอ" | mkAdv "น้อยมาก" | mkAdv "เรียบง่าย" | mkAdv "ไม่ตกแต่ง" | mkAdv "เกือบไม่พอ" ; -- src=panlex
lin bareness_N = mkN "ความสิ้นหวัง" ; -- src=panlex
lin bargain_N = mkN "การตกลง" | mkN "การเจรจา" | mkN "สินค้าราคาต่อ" | mkN "การเจรจา" | mkN "การต่อรอง" | mkN "สัญญาซื้อขาย" | mkN "การต่อรองราคา" | mkN "ข้อตกลงทางการค้า" | mkN "สิ่งที่ได้มาด้วยการต่อรองราคา" ; -- src=panlex
lin bargain_V = mkV "ต่อรอง" | mkV "ต่อ" | mkV "เจรจา" | mkV "ต่อรอง" | mkV "ต่อราคา" | mkV "แลกเปลี่ยน" ; -- src=panlex
lin bargain_V2 = mkV2 "ต่อรอง" ; ---- | mkV "ต่อ" | mkV "เจรจา" | mkV "ต่อรอง" | mkV "ต่อราคา" | mkV "แลกเปลี่ยน" ; -- src=panlex
lin bargainer_N = mkN "ผู้ค้า" ; -- src=panlex
lin bargaining_N = mkN "การเจรจาต่อรอง" | mkN "การต่อรอง" ; -- src=panlex
lin barge_N = mkN "เรือกัญญา" | mkN "เรือลำเลียงสินค้า" | mkN "ถลา" | mkN "เรือกัญญา" | mkN "เรือบรรทุก" | mkN "เรือท้องแบน" | mkN "โผล่พรวดเข้าไป" | mkN "เรือที่ใช้ในราชพิธี" | mkN "เรือบรรทุกลําเลียงขนส่ง" | mkN "เรือที่ใช้ในพิธีการต่างๆ" ; -- src=panlex
lin barge_V = mkV "ขนส่งทางเรือ" | mkV "เร่งรีบ" | mkV "ขนส่งทางเรือ" | mkV "ผลักดันอย่างแรง" ; -- src=panlex
lin bargee_N = mkN "คนเรือ" ; -- src=panlex
lin bargepole_N = mkN "เสายาวใช้จูงหรือดุนให้เรือแล่น" ; -- src=panlex
lin baric_A = mkA "สารประกอบเคมีแบริค" | mkA "ประกอบด้วยธาตุแบเรียม" | mkA "เกี่ยวกับการวัดความกดอากาศ" ; -- src=panlex
lin barilla_N = mkN "ต้นบาริลลา" | mkN "ต้นซอลต์วอร์ต" ; -- src=panlex
lin baritone_A = mkA "บาริโทน" ; -- src=panlex
lin baritone_N = mkN "บาริโทน" | mkN "บาริโทนฮอร์น" | mkN "เสียงบาริโทน" | mkN "นักร้องเสียงแบริโทน" | mkN "น้ําเสียงร้องของผู้ชาย" | mkN "เสียงทุ้มของนักร้องชาย" | mkN "นักร้องที่มีเสียงดังกล่าว" ; -- src=panlex
lin barium_N = mkN "แบเรียม" | mkN "ธาตุแบเรียม" | mkN "เลขอะตอม 56" | mkN "แบเรียม" | mkN "ธาตุแบเรียม" ; -- src=panlex
lin bark_N = mkN (thword "เปลือก") | {-pan-} mkN "เรือ" | mkN "เปลือกไม้" | mkN "เสียงเห่า" | mkN "เรือที่มีเสากระโดง 3 ต้น" | mkN "ผิว" | mkN "เปลือก" | mkN "เรือเล็ก" | mkN "เปลือกไม้" | mkN "เสียงเห่าของสุนัข" | mkN "เรือสําเภาที่มีเสากระโดงเรือ 3 เสา" ; -- src=panlex
lin bark_V = mkV "ลอก" | mkV "เห่า" | mkV "พูดเสียงแข็ง" | mkV "พูดเสียงกร้าว" | mkV "ปิดด้วยเปลือกไม้" | mkV "ฟอก" | mkV "ย้อม" | mkV "เห่า" | mkV "ตะคอก" | mkV "ลอกหนัง" | mkV "พูดก้าวร้าว" | mkV "ทําให้หนังฟกช้ํา ถลอก" | mkV "ทําเสียงร้องคล้ายเสียงสุนัข" ; -- src=panlex
lin bark_V2 = mkV2 "ลอก" ; ---- | mkV "เห่า" | mkV "พูดเสียงแข็ง" | mkV "พูดเสียงกร้าว" | mkV "ปิดด้วยเปลือกไม้" | mkV "ฟอก" | mkV "ย้อม" | mkV "เห่า" | mkV "ตะคอก" | mkV "ลอกหนัง" | mkV "พูดก้าวร้าว" | mkV "ทําให้หนังฟกช้ํา ถลอก" | mkV "ทําเสียงร้องคล้ายเสียงสุนัข" ; -- src=panlex
lin barker_N = mkN "น้องหมา" | mkN "เจ้าตูบ" | mkN "ไอ้โฮ่ง" | mkN "เจ้าโฮ่ง" ; -- src=panlex
lin barky_A = mkA "ที่คล้ายเปลือกไม้" ; -- src=panlex
lin barley_N = mkN "ข้าวบาร์เลย์" | mkN "บาร์เลย์" | mkN "ข้าวบาร์เลย์" | mkN "ต้นข้าวบาร์เลย์" | mkN "เมล็ดข้าวบาร์เลย์" ; -- src=panlex
lin barleycorn_N = mkN "ข้าวบาร์เลย์" ; -- src=panlex
lin barm_N = mkN "ยีสต์" | mkN "เชื้อหมัก" | mkN "ยีสต์" | mkN "เชื้อฟู" | mkN "เชื้อหมัก" | mkN "ฟองจากเชื้อหมัก" | mkN "ฟองที่เกิดจากการหมักเหล้า" ; -- src=panlex
lin barmaid_N = mkN "หญิงเสิร์ฟเครื่องดื่มในบาร์" | mkN "พนักงานบาร์ผู้หญิง" | mkN "หญิงเสิร์ฟเครื่องดื่มในบาร์" ; -- src=panlex
lin barman_N = mkN "คนชงเหล้า" | mkN "บาร์เทนเดอร์" | mkN "พนักงานบาร์ผู้ชาย" | mkN "ชายเสิร์ฟเครื่องดื่มในบาร์" ; -- src=panlex
lin barmbrack_N = mkN "บาร์มแบร็ก" ; -- src=panlex
lin barmy_A = mkA "เป็นฟอง" | mkA "เพี้ยนๆ" | mkA "คล้ายเชื้อหมัก" ; -- src=panlex
lin barn_N = mkN "บาร์น" | mkN "ยุ้งฉาง" | mkN "ฉาง" | mkN "โรงนา" | mkN "ยุ้งฉาง" | mkN "ยุ้งข้าว" | mkN "ตึกขนาดใหญ่" | mkN "โรงเก็บยานพาหนะ" ; -- src=panlex
lin barnacle_N = mkN "ห่านเพรียง" | mkN "ห่านบาร์นาเคิล" | mkN "สิ่งที่เกาะติด" | mkN "เพรียงที่เกาะตามวัตถุใต้น้ํา" | mkN "คนที่ยากที่จะสลัดให้หลุดหรือหนีได้" | mkN "เพรียงที่เกาะอยู่ใต้ท้องเรือและหิน" ; -- src=panlex
lin barnburner_N = mkN "คนเผายุ้งฉาง" | mkN "โจรเผายุ้งฉาง" ; -- src=panlex
lin barnful_N = mkN "ยุ้งฉาง" ; -- src=panlex
lin barnstorm_V = mkV "เดินทางไปบรรยาย" | mkV "แสดงการกระโดดร่มผาดโผน" | mkV "แสดงการกระโดดร่มแบบผาดโผน" | mkV "ตระเวณไปที่ต่างๆ เพื่อแสดงละครหรือแสดงสุนทรพจน์" ; -- src=panlex
lin barnstormer_N = mkN "คณะนักแสดง" | mkN "คณะผู้แสดง" | mkN "นักบินผาดโผน" ; -- src=panlex
lin barnyard_N = mkN "คอกที่อยู่ติดยุ้งฉาง" | mkN "ลานยุ้งข้าว" | mkN "บริเวณที่เก็บยุ้งข้าว" ; -- src=panlex
lin barograph_N = mkN "บารอกราฟ" | mkN "เครื่องวัดความกดอากาศแบบกราฟ" ; -- src=panlex
lin barometer_N = mkN "บารอมิเตอร์" | mkN "เครื่องวัดความกดอากาศ" | mkN "เครื่องวัด" | mkN "บาโรมิเตอร์" | mkN "ตัวชี้วัดอารมณ์หรือบรรยากาศ" | mkN "เครื่องวัดความกดดันของอากาศ" | mkN "เครื่องวัดความดันของบรรยากาศ" ; -- src=panlex
lin baron_N = mkN "บารอน" | mkN "ท่านบารอน" | mkN "ผู้นำธุรกิจ" | mkN "นักธุรกิจชั้นนำ" | mkN "บุคคลผู้มีอำนาจ" | mkN "บารอน" | mkN "ผู้ดี" | mkN "คหบดีใหญ่" | mkN "ท่านบารอน" | mkN "นักอุตสาหกรรม" | mkN "บุคคลที่มีอํานาจ" | mkN "ยศขุนนางชั้นต่ําที่สุดในสภาขุนนาง" | mkN "ขุนนางขั้นต่ําของอังกฤษหรือญี่ปุ่น" ; -- src=panlex
lin baronage_N = mkN "บรรดาศักดิ์บารอน" | mkN "ขุนนางจําพวกที่มียศชั้นบารอนทั้งหมด" ; -- src=panlex
lin baroness_N = mkN "บารอนเนส" | mkN "ภรรยาบารอน" | mkN "ภรรยาของท่านบารอน" | mkN "ท่านบารอนที่เป็นหญิง" ; -- src=panlex
lin baronet_N = mkN "บาร์ท" | mkN "บารอเนต" | mkN "ยศขุนนางที่ต่ํากว่าบารอนแต่เหนืออัศวิน" ; -- src=panlex
lin baronetage_N = mkN "ตำแหน่งบารอเนต" ; -- src=panlex
lin baronetcy_N = mkN "ตำแหน่งบาโรเนส" | mkN "ยศของท่านบารอน" | mkN "ยศของท่านบารอน" ; -- src=panlex
lin barong_N = mkN "มีดบารอง" ; -- src=panlex
lin baronial_A = mkA "เกี่ยวกับท่านบารอน" ; -- src=panlex
lin barony_N = mkN "ตำแหน่งบาโรเนส" | mkN "ที่ดินของบารอน" | mkN "ตําแหน่งหรือที่ดินของท่านแบรอน" ; -- src=panlex
lin baroque_A = mkA "ยุคบาโร้ค" | mkA "แบบบาโร้ค" | mkA "อย่างศิลปะหรือสถาปัตยกรรมแบบบาโรก" ; -- src=panlex
lin baroque_N = mkN "ศิลปะบาโรก" | mkN "ศิลปะแบบบาร็อก" | mkN "พิสดาร" | mkN "ประดับมากไป" | mkN "แปลกประหลาด" ; -- src=panlex
lin baroreceptor_N = mkN "บาร์โรรีเซปเตอร์" ; -- src=panlex
lin barosaur_N = mkN "บาโรซอร์" ; -- src=panlex
lin barouche_N = mkN "รถม้าบารูช" ; -- src=panlex
lin barque_N = mkN "เรือ" | mkN "เรือที่มีเสากระโดง 3 ต้น" | mkN "เรือเล็กที่มีเสาเรือมากกว่าหรือเท่ากับ 3 เสา" ; -- src=panlex
lin barrack_N = mkN "ค่ายทหาร" | mkN "โรงทหาร" | mkN "ค่ายทหาร" ; -- src=panlex
lin barrack_V = mkV "โห่ร้อง" | mkV "เยาะเย้ย" | mkV "เข้าพักในค่ายทหาร" | mkV "จัดทหารเข้าค่ายพัก" ; -- src=panlex
lin barrack_V2 = mkV2 "โห่ร้อง" ; ---- | mkV "เยาะเย้ย" | mkV "เข้าพักในค่ายทหาร" | mkV "จัดทหารเข้าค่ายพัก" ; -- src=panlex
lin barracks_N = mkN "อาคารขนาดใหญ่ที่ไม่สวยงาม" | mkN "โรงหรืออาคารใหญ่เป็นที่พักทหาร" ; -- src=panlex
lin barracouta_N = mkN "ปลาบาร์ราคอตา" ; -- src=panlex
lin barracuda_N = mkN "ปลาบาราคูด้า" | mkN "ดุร้ายและมีฟันแหลมคม" ; -- src=panlex
lin barrage_N = mkN "การระดมยิง" | mkN "การใช้ปืนใหญ่ระดมยิง" | mkN "เขื่อน" | mkN "การโจมตี" | mkN "การวิจารณ์" | mkN "การโต้แย้ง" | mkN "การระดมยิงปืน" | mkN "ทํานบกั้นน้ํา" | mkN "เขื่อนกั้นน้ํา" ; -- src=panlex
lin barramundi_N = mkN "ปลาไจแอนท์เพิร์ช" ; -- src=panlex
lin barratry_N = mkN "การติดสินบนศาล" ; -- src=panlex
lin barrel_N = mkN "บาร์เรล" | mkN "ลำกล้อง" | mkN "ถังใส่เหล้า" | mkN "ปริมาณมาก" | mkN "ลํากล้องปืน" | mkN "ถังใส่ของเหลว" | mkN "ภาชนะตักเบียร์ / น้ํามัน" | mkN "ถังรูปทรงกระบอก" | mkN "ภาชนะรูปทรงกระบอก" | mkN "จํานวนของของเหลวต่อบาร์เร็ล" | mkN "จํานวนของน้ํามันหรือเบียร์ต่อบาร์เร็ล" ; -- src=panlex
lin barrelfish_N = mkN "ปลาบาร์เรลฟิช" ; -- src=panlex
lin barrels_N = mkN "บาร์เรล" ; -- src=panlex
lin barren_A = mkA "จืดชืด" | mkA "ไร้ค่า" | mkA "ขาดแคลน" | mkA "เป็นหมัน" | mkA "แห้งแล้ง" | mkA "ไม่ได้ผล" | mkA "ไม่มีบุตร" | mkA "ไม่น่าสนใจ" | mkA "ไร้ความคิด" | mkA "ปราศจากพืชผล" | mkA "ไม่มีประโยชน์" ; -- src=panlex
lin barren_N = mkN "การปราศจากพืชผล" ; -- src=panlex
lin barrenwort_N = mkN "ต้นบาร์เรนวอร์ต" ; -- src=panlex
lin barrette_N = mkN "กิ๊บติดผมทรงยาว" | mkN "ที่หนีบผม" ; -- src=panlex
lin barricade_N = mkN "ด่าน" | mkN "คอกกั้น" | mkN "ด่านขนอน" | mkN "ด่านหรือสิ่งกีดขวาง" ; -- src=panlex
lin barrier_N = mkN "ที่กั้น" | mkN "อุปสรรคขัดขวาง" | mkN "อุปสรรค" | mkN "สิ่งกีดขวาง" | mkN "สิ่งกีดขวางทางผ่าน" ; -- src=panlex
lin barrister_N = mkN "เนติบัณฑิต" | mkN "ทนาย" | mkN "ทนายความ" ; -- src=panlex
lin barroom_N = mkN "ห้องโถง" | mkN "ร้านเหล้า" | mkN "ห้องหรือสถานที่ที่มีการบริการเหล้า" ; -- src=panlex
lin barrow_N = mkN "รถเข็น" | mkN "บาร์โรว" | mkN "หลุมฝังศพ" | mkN "เนินหลุมฝังศพ" | mkN "รถเข็นล้อเดียว" | mkN "รถเข็น" | mkN "รถสาลี่" | mkN "หิ้งหาบ" | mkN "รถเข็นสองล้อสําหรับขายของ" ; -- src=panlex
lin bartender_N = mkN "คนชงเหล้า" | mkN "บาร์เทนเดอร์" | mkN "คนเสิร์ฟ" | mkN "บริกรในบาร์" | mkN "บาร์เทนเดอร์" ; -- src=panlex
lin barter_N = mkN "การแลกเปลี่ยนสินค้า" | mkN "การแลกเปลี่ยนสินค้า" | mkN "แลกเปลี่ยนสิ่งของต่อสิ่งของ" ; -- src=panlex
lin barter_V = mkV "แลกเปลี่ยนสินค้า" | mkV "ค้า" | mkV "แลก" | mkV "เปลี่ยน" | mkV "เจรจาต่อรอง" | mkV "ต่อรองการค้า" ; -- src=panlex
lin barter_V2 = mkV2 "แลกเปลี่ยนสินค้า" ; ---- | mkV "ค้า" | mkV "แลก" | mkV "เปลี่ยน" | mkV "เจรจาต่อรอง" | mkV "ต่อรองการค้า" ; -- src=panlex
lin barterer_N = mkN "ผู้แลกเปลี่ยนสินค้า" ; -- src=panlex
lin bartlett_N = mkN "ลูกแพร์" ; -- src=panlex
lin bartonia_N = mkN "ต้นบาร์โตเนีย" ; -- src=panlex
lin barycenter_N = mkN "แบรีเซ็นเตอร์" ; -- src=panlex
lin barye_N = mkN "ไมโครบาร์" ; -- src=panlex
lin baryon_N = mkN "แบริออน" | mkN "อนุภาคหนัก" | mkN "อนุภาพแบริออน" ; -- src=panlex
lin baryta_N = mkN "แบริตา" ; -- src=panlex
lin basal_A = mkA "พื้นฐาน" | mkA "แรกเริ่ม" | mkA "เป็นมูลฐาน" | mkA "เป็นรากฐาน" | mkA "เกี่ยวกับฐาน" ; -- src=panlex
lin basalt_N = mkN "หินบะซอลต์" | mkN "หินภูเขาไฟ" | mkN "หินภูเขาไฟสีดําชนิดหนึ่ง" ; -- src=panlex
lin base_A = mkA "ชั่ว" | mkA "ร้าย" | mkA "เสื่อม" | mkA "ต่ําช้า" | mkA "เลวทราม" | mkA "เลวร้าย" | mkA "คุณภาพไม่ดี" ; -- src=panlex
lin base_N = mkN "ฐาน" | mkN "ราก" | mkN "เบส" | mkN "ขั้น" | mkN "ธาตุ" | mkN "บ้าน" | mkN "แท่น" | mkN "รากคำ" | mkN "ฐานทัพ" | mkN "ฐานราก" | mkN "รากฐาน" | mkN "เลขฐาน" | mkN "พื้นฐาน" | mkN "แอลคาไล" | mkN "รากศัพท์" | mkN "ฐานที่มั่น" | mkN "ส่วนผสมหลัก" | mkN "นิวคลีโอไทด์" | mkN "ฐานปฏิบัติการ" | mkN "โครงสร้างพื้นฐาน" | mkN "สาธารณูปโภคพื้นฐาน" | mkN "ฐาน" | mkN "ชั่ว" | mkN "ด่าง" | mkN "พื้น" | mkN "หลัก" | mkN "สีฟัน" | mkN "ฐานทัพ" | mkN "รากฐาน" | mkN "วิบัติ" | mkN "ที่มั่น" | mkN "พื้นฐาน" | mkN "เลวทราม" | mkN "จุดเริ่ม" | mkN "ชั้นต่ํา" | mkN "ฐานที่มั่น" | mkN "จุดศูนย์กลาง" | mkN "น้ํายารักษาสี" | mkN "ส่วนที่ต่ําที่สุด" ; -- src=panlex
lin base_V = mkV "เผาสูดควัน" | mkV "ใช้เป็นฐาน" | mkV "ตั้งเป็นฐาน" | mkV "ประจําการ" | mkV "วางรากฐาน" | mkV "มาจากรากฐาน" ; -- src=panlex
lin base_V2 = mkV2 "เผาสูดควัน" ; ---- | mkV "ใช้เป็นฐาน" | mkV "ตั้งเป็นฐาน" | mkV "ประจําการ" | mkV "วางรากฐาน" | mkV "มาจากรากฐาน" ; -- src=panlex
lin baseball_N = mkN "เบสบอล" | mkN "กีฬาสเก็ต" | mkN "ลูกเบสบอล" | mkN "ลูกเบสบอล" | mkN "กีฬาเบสบอล" ; -- src=panlex
lin baseboard_N = mkN "คิ้วไม้บัว" | mkN "แผ่นกระดานที่ปิดขอบด้านล่างของผนัง" ; -- src=panlex
lin baseless_A = mkA "ไร้ฐาน" | mkA "ไร้เหตุผล" | mkA "ไม่มีเหตุผล" | mkA "ไม่มีมูลความจริง" ; -- src=panlex
lin baseline_N = mkN "เบสไลน์" | mkN "เส้นหลัง" | mkN "บรรทัดฐาน" | mkN "เส้นฐาน" | mkN "เส้นหลังของสนามเทนนิส" | mkN "เส้นขอบด้านหลังของสนามกีฬา" ; -- src=panlex
lin basement_N = mkN "ชั้นใต้ดิน" | mkN "ห้องใต้ดิน" | mkN "รากฐาน" | mkN "ห้องใต้ดิน" ; -- src=panlex
lin baseness_N = mkN "ความต่ำค่า" | mkN "ความไม่ดี" | mkN "ความเลวทราม" ; -- src=panlex
lin basenji_N = mkN "บาเซนจิ" | mkN "สุนัขพันธุ์บาเซนจิ" ; -- src=panlex
lin bash_N = mkN "การทุบ" | mkN "การฟาด" | mkN "การทุบตี" | mkN "ความอึกทึก" | mkN "การชนอย่างแรง" | mkN "การทะเลาะวิวาท" | mkN "งานเลี้ยงเสียงดัง" ; -- src=panlex
lin bashful_A = mkA "อาย" | mkA "กระดาก" | mkA "ขี้อาย" | mkA "ขวยเขิน" | mkA "ประหม่า" | mkA "เขินอาย" | mkA "เหนียมอาย" ; -- src=panlex
lin basic_A = mkA "พื้นฐาน" | mkA "ซึ่งเป็นพื้นฐาน" | mkA "ธรรมดา" | mkA "มูลฐาน" | mkA "รากฐาน" | mkA "สําคัญ" | mkA "พื้นฐาน" | mkA "เป็นด่าง" | mkA "อันดับแรก" | mkA "ลักษณะด่าง" | mkA "สําคัญที่สุด" | mkA "จําเป็นที่สุด" ; -- src=panlex
lin basic_N = mkN "ของใช้จำเป็น" | mkN "ของใช้ที่จำเป็น" | mkN "ของใช้ในชีวิตประจำวัน" ; -- src=panlex
lin basically_Adv = mkAdv "โดยพื้นฐาน" | mkAdv "โดยทั่วๆ ไป" | mkAdv "โดยพื้นฐาน" | mkAdv "โดยแท้จริง" ; -- src=panlex
lin basics_N = mkN "ข้อเท็จจริง" | mkN "ส่วนที่สําคัญที่สุด" ; -- src=panlex
lin basidiocarp_N = mkN "บาซิดิโอคาร์พ" ; -- src=panlex
lin basidiomycete_N = mkN "บาซิดิโอไมซีต" ; -- src=panlex
lin basidiospore_N = mkN "เบซิดิโอสปอร์" ; -- src=panlex
lin basidium_N = mkN "บาซิเดียม" ; -- src=panlex
lin basil_N = mkN "ใบโหระพา" | mkN "ใบโหระพา" ; -- src=panlex
lin basilar_A = mkA "อยู่ที่ฐาน" | mkA "เกี่ยวกับฐาน" ; -- src=panlex
lin basileus_N = mkN "บาซิเลียส" ; -- src=panlex
lin basilica_N = mkN "บาซิลิกา" | mkN "บาซิลิกาของโรมัน" | mkN "โบสถ์นิกายโรมันคาทอลิก" ; -- src=panlex
lin basilisk_N = mkN "บาซิลิสก์" | mkN "งูบาซิลิสก์" | mkN "ปืนบาซิลิสก์" | mkN "สัตว์เลื้อยคลาน" ; -- src=panlex
lin basin_N = mkN "อ่าง" | mkN "เบซิน" | mkN "ลุ่มน้ำ" | mkN "อ่างน้ำ" | mkN "ลุ่มแม่น้ำ" | mkN "อ่างล้างหน้า" | mkN "บริเวณลุ่มน้ำ" | mkN "พื้นที่รับน้ำ" | mkN "แผ่นดินที่ยุบตัวลงไปในทะเล" | mkN "อ่าง" | mkN "กะละมัง" | mkN "ชามอ่าง" | mkN "สระน้ํา" | mkN "อู่น้ํา" | mkN "อู่เรือ" | mkN "ลุ่มน้ํา" | mkN "อ่างน้ํา" | mkN "แอ่งน้ํา" | mkN "อ่าวด้านใน" | mkN "อ่างล้างหน้า" | mkN "ที่จอดเรือซึ่งขุดเข้าไปจากแม่น้ําหรือทะเล" ; -- src=panlex
lin basinet_N = mkN "หมวกเกราะบาซิเนต" ; -- src=panlex
lin basis_N = mkN "ฐาน" | mkN "รากฐาน" | mkN "พื้นฐาน" | mkN "หลัก" | mkN "รากฐาน" | mkN "พื้นฐาน" | mkN "มาตรฐาน" | mkN "หลักเกณฑ์" | mkN "ส่วนสําคัญ" | mkN "หลักสําคัญ" | mkN "จุดเริ่มต้น" | mkN "หลักพื้นฐาน" | mkN "ฐานปฏิบัติการ" | mkN "ส่วนประกอบหลัก" ; -- src=panlex
lin basiscopic_A = mkA "สู่ส่วนโคน" ; -- src=panlex
lin bask_V = mkV "ตาก" | mkV "เป็นสุข" | mkV "ปลาบปลื้ม" | mkV "อาบแดด" | mkV "ผึ่งแดด" | mkV "ได้รับความพึงพอใจ" ; -- src=panlex
lin basket_N = mkN "ห่วง" | mkN "ตะกร้า" | mkN "ห่วงบาส" | mkN "ห่วงบาสเกตบอล" | mkN "การชู้ตลูกลงห่วง" | mkN "เข่ง" | mkN "กระจาด" | mkN "กระด้ง" | mkN "กระบุง" | mkN "ตะกร้า" | mkN "กระเช้า" | mkN "เต็มกระเช้า" | mkN "เต็มตระกร้า" | mkN "คะแนนของบาสเกตบอล" | mkN "กระเช้าของลูกบอลลูน" | mkN "สิ่งที่อยู่ในตะกร้า" | mkN "ห่วงของกีฬาบาสเกตบอล" | mkN "จํานวนของสิ่งของในตะกร้า" ; -- src=panlex
lin basketball_N = mkN "บาส" | mkN "ลูกบาส" | mkN "กีฬาบาส" | mkN "บาสเกตบอล" | mkN "กีฬายัดห่วง" | mkN "กีฬาบาสเกตบอล" | mkN "ลูกบาสเก็ตบอล" | mkN "กีฬาบาสเก็ตบอล" | mkN "บาสเกตบอล" | mkN "กีฬาบาสเกตบอล" ; -- src=panlex
lin basketry_N = mkN "การทำตะกร้า" | mkN "การสานตะกร้า" | mkN "งานจักสาน" | mkN "กลุ่มตะกร้า" | mkN "กลุ่มสิ่งจักสาน" | mkN "งานจักสานพวกตะกร้าต่างๆ" | mkN "ศิลปะหรือกระบวนการทําสิ่งจักสาน" ; -- src=panlex
lin basketweaver_N = mkN "คนสานตะกร้า" | mkN "ช่างสานตะกร้า" ; -- src=panlex
lin bass_A = mkA "เบส" | mkA "ทุ้มต่ำ" | mkA "เสียงทุ้ม" | mkA "ที่มีเสียงต่ํา" ; -- src=panlex
lin bass_N = mkN "เบส" | mkN "ปลาเบส" | mkN "ปลาซีเบส" | mkN "เสียงเบส" | mkN "เสียงบาสโซ" | mkN "ปลากระพงขาว" | mkN "เนื้อปลาเบส" | mkN "ปลาเบสน้ำจืด" | mkN "เนื้อปลาซีเบส" | mkN "เนื้อปลาเบสน้ำจืด" | mkN "นักร้องชายเสียงเบส" | mkN "เสียงทุ้ม" | mkN "โทนเสียงต่ํา" | mkN "เสียงร้องต่ํา" | mkN "นักร้องเสียงต่ํา" | mkN "พันธุ์ไม้ชนิดหนึ่ง" | mkN "เสียงต่ําของผู้ชาย" | mkN "ท่วงทํานองเสียงต่ํา" | mkN "เสียงร้องต่ําที่สุด" | mkN "เครื่องดนตรีเสียงต่ํา" | mkN "ปลาที่ถูกจับมาเป็นอาหาร" | mkN "ปลาน้ําจืดชนิดหนึ่งคล้ายปลาตะเพียน" ; -- src=panlex
lin bassarisk_N = mkN "บาสซาริก" ; -- src=panlex
lin basset_N = mkN "บาสเซตเฮานด์" | mkN "สุนัขพันธุ์บาสเซตเฮานด์" | mkN "สุนัขพันธุ์หนึ่ง ขาสั้น ลําตัวและหูยาว" ; -- src=panlex
lin bassinet_N = mkN "เปล" | mkN "เปลนอนของทารก" ; -- src=panlex
lin bassist_N = mkN "มือเบส" | mkN "คนเล่นเบส" | mkN "นักดนตรีเล่นเบส" ; -- src=panlex
lin bassoon_N = mkN "บาสซูน" | mkN "ปี่ใหญ่" | mkN "ปี่ใหญ่" | mkN "ปี่บาซูน" ; -- src=panlex
lin bassoonist_N = mkN "นักเป่าปี่บาสซุน" | mkN "นักเป่าปี่ใหญ่" ; -- src=panlex
lin basswood_N = mkN "ต้นไลม์" | mkN "ไม้ลินเดน" | mkN "ไม้เบสวู้ด" ; -- src=panlex
lin bast_N = mkN "เส้นใยเปลือกใน" | mkN "ใยเปลือกไม้" | mkN "เนื้อเยื่อส่วนที่เป็นอาหารของต้นไม้" ; -- src=panlex
lin bastard_N = mkN "คนโง่" | mkN "คนเลวทราม" | mkN "ไอ้สารเลว" | mkN "ลูกนอกสมรส" | mkN "เลว" | mkN "ปลอม" | mkN "พิกล" | mkN "พันทาง" | mkN "ผิดปกติ" | mkN "วายร้าย" | mkN "สิ่งสารเลว" | mkN "ลูกไม่มีพ่อ" | mkN "ลูกนอกกฎหมาย" | mkN "สิ่งปลอมแปลง" | mkN "เชื่อถือไม่ได้" | mkN "ทําให้ผิดกฎหมาย)" ; -- src=panlex
lin bastardly_A = mkA "นอกสมรส" ; -- src=panlex
lin bastardy_N = mkN "ความเป็นลูกนอกสมรส" | mkN "ความเป็นบุตรนอกกฎหมาย" | mkN "ลูกที่เกิดจากพ่อแม่ที่ไม่ได้แต่งงานกัน" ; -- src=panlex
lin baster_N = mkN "ผู้รุกราน" ; -- src=panlex
lin bastille_N = mkN "คุกบาสตีย์" | mkN "คุก" | mkN "ป้อมปราการ" ; -- src=panlex
lin bastinado_N = mkN "กระบองแบสตินาโด" | mkN "การลงโทษด้วยการตีเท้า" ; -- src=panlex
lin basting_N = mkN "การทาน้ำมันระหว่างอบ" ; -- src=panlex
lin bastion_N = mkN "ป้อมปราการ" | mkN "หอ" | mkN "หอรบ" | mkN "ปราการ" | mkN "ป้อมแหลม" | mkN "ปราการหรือป้อมแหลม" ; -- src=panlex
lin bastnasite_N = mkN "แบสต์เนไซต์" | mkN "แร่แบสต์เนไซต์" ; -- src=panlex
lin bat_N = mkN "ไม้ตี" | mkN "ค้างคาว" | mkN "ไม้สควอช" | mkN "การกลับมาตี" | mkN "ไม้ตีคริกเก็ต" | mkN "กระบอง" | mkN "ค้างคาว" | mkN "ไม้ตีลูกบอล" | mkN "แส้ไว้ใช้หวดหรือตีม้าเวลาแข่ง" | mkN "ไม้ตีลูกเบสบอลหรือลูกคริกเก็ต" ; -- src=panlex
lin bat_V = mkV "ขยิบตา" | mkV "เอาชนะ" | mkV "ตีด้วยไม้" | mkV "ตีด้วยไม้เบสบอล" | mkV "เอาชนะไปอย่างขาดลอย" | mkV "ขยิบตา" | mkV "กระพริบตา" | mkV "ตีด้วยไม้" | mkV "ได้เปรียบจากการตีลูก" ; -- src=panlex
lin bat_V2 = mkV2 "ขยิบตา" ; ---- | mkV "เอาชนะ" | mkV "ตีด้วยไม้" | mkV "ตีด้วยไม้เบสบอล" | mkV "เอาชนะไปอย่างขาดลอย" | mkV "ขยิบตา" | mkV "กระพริบตา" | mkV "ตีด้วยไม้" | mkV "ได้เปรียบจากการตีลูก" ; -- src=panlex
lin batch_N = mkN "กลุ่ม" | mkN "มากมาย" | mkN "จำนวนมาก" | mkN "จำนวนมากมายก่ายกอง" | mkN "ปริมาณทั้งหมดที่หุงต้มในเวลาเดียวกัน" | mkN "ชุด" | mkN "พวก" | mkN "ยุก" | mkN "หมู่" | mkN "กลุ่ม" | mkN "ปริมาณวัตถุที่ทําแต่ละครั้ง" | mkN "ปริมาณอาหารที่หุงต้มในหนึ่งครั้ง" ; -- src=panlex
lin batfish_N = mkN "ปลาค้างคาว" ; -- src=panlex
lin bath_N = mkN "บาธ" | mkN "อ่าง" | mkN "ห้องน้ำ" | mkN "ห้องสรง" | mkN "ห้องอาบน้ำ" | mkN "อ่างอาบน้ำ" | mkN "การอาบในอ่าง" | mkN "การอาบน้ำในอ่าง" | mkN "น้ําอาบ" | mkN "ห้องน้ํา" | mkN "การอาบน้ํา" | mkN "ถังอาบน้ํา" | mkN "ที่อาบน้ํา" | mkN "อ่างอาบน้ํา" | mkN "น้ําที่ใช้อาบ" | mkN "สถานที่อาบน้ํา" | mkN "การอาบน้ําเพื่อการรักษา" ; -- src=panlex
lin bath_V = mkV "อาบน้ำ" | mkV "อาบน้ํา" ; -- src=panlex
lin bath_V2 = mkV2 "อาบน้ำ" ; ---- | mkV "อาบน้ํา" ; -- src=panlex
lin bathe_N = mkN "การว่ายน้ำ" ; -- src=panlex
lin bathe_V = mkV "อาบ" | mkV "สรงน้ำ" | mkV "อาบน้ำ" | mkV "อาบน้ำอาบท่า" | mkV "อาบน้ำ" | mkV "อาบน้ํา" | mkV "ชําระล้าง" ; -- src=panlex
lin bathe_V2 = mkV2 "อาบ" ; ---- | mkV "สรงน้ำ" | mkV "อาบน้ำ" | mkV "อาบน้ำอาบท่า" | mkV "อาบน้ำ" | mkV "อาบน้ํา" | mkV "ชําระล้าง" ; -- src=panlex
lin bather_N = mkN "คนอาบน้ำ" | mkN "ผู้อาบน้ำ" | mkN "นักว่ายน้ำ" ; -- src=panlex
lin bathetic_A = mkA "น้ำเน่า" ; -- src=panlex
lin bathhouse_N = mkN "โรงอาบน้ำ" | mkN "สถานที่อาบน้ำ" | mkN "ที่อาบน้ํา" | mkN "โรงอาบน้ํา" ; -- src=panlex
lin bathing_N = mkN "การอาบ" | mkN "การอาบน้ำ" | mkN "ว่ายน้ํา" ; -- src=panlex
lin batholith_N = mkN "บาโทลิท" ; -- src=panlex
lin bathos_N = mkN "การแสร้งทำเป็นสงสาร" | mkN "การเสแสร้งสงสารหรือเห็นใจมากเกินไป" | mkN "ความแสร้ง" | mkN "ความไม่จริงใจ" | mkN "ความตรงกันข้าม" | mkN "ความธรรมดาหรือจืดชืด" | mkN "วิธีการลดหรือเปลี่ยนอย่างฮวบฮาบ" | mkN "การเสแสร้งสงสารหรือเห็นใจมากเกินไป" ; -- src=panlex
lin bathrobe_N = mkN "เสื้อคลุมอาบน้ำ" | mkN "เสื้อคลุมอาบน้ํา" | mkN "เสื้อคลุมใส่ก่อนและหลังอาบน้ํา" ; -- src=panlex
lin bathroom_N = mkN "สุขา" | mkN "ส้วม" | mkN "ห้องน้ำ" | mkN "ห้องสรง" | mkN "ห้องสุขา" | mkN "ห้องส้วม" | mkN "ห้องอาบน้ำ" | mkN "ห้องพระบังคน" | mkN "ห้องน้ํา" | mkN "ห้องอาบน้ํา" ; -- src=panlex
lin bathtub_N = mkN "อ่างอาบน้ำ" | mkN "อ่างอาบน้ํา" ; -- src=panlex
lin bathymeter_N = mkN "บาโทมิเตอร์" ; -- src=panlex
lin bathymetry_N = mkN "การวัดความลึก" ; -- src=panlex
lin bathyscaphe_N = mkN "ยานสำรวจน้ำลึก" ; -- src=panlex
lin bathysphere_N = mkN "เครื่องดําน้ําลึกทรงกลม" ; -- src=panlex
lin batik_N = mkN "ผ้าบาติก" | mkN "ผ้าบาติก" | mkN "การพิมพ์ผ้าด้วยมือ" | mkN "สิ่งทอที่ย้อมสีโดยวิธีดังกล่าว" ; -- src=panlex
lin batiste_N = mkN "ผ้าบาติส" ; -- src=panlex
lin batman_N = mkN "ทหารรับใช้" ; -- src=panlex
lin baton_N = mkN "คทา" | mkN "ไม้บาตอง" | mkN "กระบองตำรวจ" | mkN "ไม้วิ่งพลัด" | mkN "ตะบองของตำรวจ" | mkN "คฑาดรัมเมเยอร์" | mkN "ไม้กระบองตำรวจ" | mkN "ไม้ดรัมเมเยอร์" | mkN "ไม้ตะบองของตำรวจ" | mkN "ไม้สำหรับวาทยากร" | mkN "คทา" | mkN "ตะบอง" | mkN "กระบอง" | mkN "ไม้ของผู้นําจังหวะดนตรี" | mkN "ไม้ต่อแรงของการวิ่งผลัด" | mkN "ไม้สั้นของวาทยากรที่ควบคุมการบรรเลงเพลง" ; -- src=panlex
lin bats_A = mkA "บ้า" | mkA "ติ๊งต๊อง" | mkA "จิตไม่ปกติ" | mkA "สติฟั่นเฟือน" ; -- src=panlex
lin batsman_N = mkN "เบ็ตเตอร์" | mkN "ผู้ตีเบสบอล" | mkN "ผู้ตีลูกเบสบอล" | mkN "คนตีลูก" | mkN "ผู้ตีด้วยไม้" ; -- src=panlex
lin battalion_N = mkN "กอง" | mkN "จำนวนมากมาย" | mkN "โขลง" | mkN "กองทัพ" | mkN "กองพัน" | mkN "กองทหาร" | mkN "กองพันทหาร" | mkN "หน่วยกองพัน" | mkN "กองกําลังใหญ่" ; -- src=panlex
lin batten_N = mkN "ไม้ตี" | mkN "ไม้ดาม" | mkN "ไม้ระแนง" | mkN "ไม้สําหรับตรึงผ้าใบเรือ" | mkN "ไม้ยาวสําหรับดามหรือเป็นที่ค้ํา" ; -- src=panlex
lin batten_V = mkV "ใช้ไม้ดาม" | mkV "ตกแต่งด้วยไม้ดาม" | mkV "ตรึง" | mkV "ใช้ไม้ดาม" ; -- src=panlex
lin batten_V2 = mkV2 "ใช้ไม้ดาม" ; ---- | mkV "ตกแต่งด้วยไม้ดาม" | mkV "ตรึง" | mkV "ใช้ไม้ดาม" ; -- src=panlex
lin batter_N = mkN "เบ็ตเตอร์" | mkN "ผู้ตีเบสบอล" | mkN "ผู้ตีลูกเบสบอล" | mkN "แป้งเค้กที่ผสมเสร็จแล้ว" | mkN "ส่วนผสมที่ทําจากแป้ง นมและไข่" | mkN "ส่วนผสมของแป้งเค้กที่ผสมเสร็จแล้ว" ; -- src=panlex
lin batter_V = mkV "ตี" | mkV "กระหน่ำตี" | mkV "ทำให้เป็นรอย" | mkV "ทุบตีติดต่อกัน" | mkV "ทุบตีอย่างรุนแรง" | mkV "ตีติดต่อกัน" | mkV "ทุบตีติดต่อกัน" | mkV "โจมตีติดต่อกัน" | mkV "คลุมหรือหุ้มด้วยแป้งเค้ก" | mkV "เคลือบด้วยส่วนผสมที่ทําจากแป้ง นมและไข่" ; -- src=panlex
lin batter_V2 = mkV2 "ตี" ; ---- | mkV "กระหน่ำตี" | mkV "ทำให้เป็นรอย" | mkV "ทุบตีติดต่อกัน" | mkV "ทุบตีอย่างรุนแรง" | mkV "ตีติดต่อกัน" | mkV "ทุบตีติดต่อกัน" | mkV "โจมตีติดต่อกัน" | mkV "คลุมหรือหุ้มด้วยแป้งเค้ก" | mkV "เคลือบด้วยส่วนผสมที่ทําจากแป้ง นมและไข่" ; -- src=panlex
lin battering_N = mkN "การทุบตีอย่างรุนแรง" ; -- src=panlex
lin battery_1_N = mkN "แบต" | mkN "แบตเตอรี่" | mkN "การระดมยิง" | mkN "การทำร้ายร่างกาย" | mkN "การใช้ปืนระดมยิง" | mkN "การใช้ปืนใหญ่ระดมยิง" | mkN "ผู้ตีแลผู้รับลูกในกีฬาเบสบอล" | mkN "ถ่าน" | mkN "ฝูงชน" | mkN "กลุ่มคน" | mkN "การทุบตี" | mkN "การโจมตี" | mkN "การต่อสู้" | mkN "แบตเตอรี่" | mkN "ชุดปืนเรือ" | mkN "การทําโจมตี" | mkN "ที่กําเนิดไฟฟ้า" | mkN "หม้อกําเนิดไฟฟ้า" | mkN "การทําร้ายร่างกาย" | mkN "กองร้อยทหารปืนใหญ่" | mkN "กลุ่มอาวุธยุทธภัณฑ์" | mkN "กลุ่มของอาวุธยุทธภัณฑ์" ; -- src=panlex
lin battery_2_N = mkN "แบต" | mkN "แบตเตอรี่" | mkN "การระดมยิง" | mkN "การทำร้ายร่างกาย" | mkN "การใช้ปืนระดมยิง" | mkN "การใช้ปืนใหญ่ระดมยิง" | mkN "ผู้ตีแลผู้รับลูกในกีฬาเบสบอล" | mkN "ถ่าน" | mkN "ฝูงชน" | mkN "กลุ่มคน" | mkN "การทุบตี" | mkN "การโจมตี" | mkN "การต่อสู้" | mkN "แบตเตอรี่" | mkN "ชุดปืนเรือ" | mkN "การทําโจมตี" | mkN "ที่กําเนิดไฟฟ้า" | mkN "หม้อกําเนิดไฟฟ้า" | mkN "การทําร้ายร่างกาย" | mkN "กองร้อยทหารปืนใหญ่" | mkN "กลุ่มอาวุธยุทธภัณฑ์" | mkN "กลุ่มของอาวุธยุทธภัณฑ์" ; -- src=panlex
lin batting_N = mkN "ไม้ตี" | mkN "การพยายามตีลูกเบสบอล" ; -- src=panlex
lin battle_N = mkN "การรบ" | mkN "การสู้รบ" | mkN "การต่อสู้" | mkN "ความขัดแย้ง" | mkN "ความมุ่งมั่นฟันฝ่า" | mkN "ผจญ" | mkN "ศึก" | mkN "การรบ" | mkN "ต่อสู้" | mkN "สงคราม" | mkN "ยุทธการ" | mkN "การสู้รบ" | mkN "การแข่งขัน" | mkN "การประจัญบาน" | mkN "การต่อสู้ดิ้นรน" ; -- src=panlex
lin battle_V = mkV "รบ" | mkV "สู้รบ" | mkV "ดิ้นรนต่อสู้" | mkV "มุ่งมั่นฝ่าฟัน" ; -- src=panlex
lin battle_V2 = mkV2 "รบ" ; ---- | mkV "สู้รบ" | mkV "ดิ้นรนต่อสู้" | mkV "มุ่งมั่นฝ่าฟัน" ; -- src=panlex
lin battledore_N = mkN "ไม้แบด" | mkN "แบตเทิลดอร์" | mkN "ไม้แบดมินตัน" | mkN "แร็กเก็ตแบดมินตัน" ; -- src=panlex
lin battledress_N = mkN "เครื่องแบบทหาร" ; -- src=panlex
lin battlefield_N = mkN "สนามรบ" | mkN "สมรภูมิ" | mkN "สมรภูมิรบ" | mkN "แนวรบ" | mkN "สนามรบ" | mkN "สมรภูมิ" ; -- src=panlex
lin battlefront_N = mkN "แนวหน้า" ; -- src=panlex
lin battleground_N = mkN "สนามรบ" | mkN "สมรภูมิ" | mkN "สมรภูมิรบ" | mkN "แนวรบ" | mkN "สนามรบ" | mkN "สมรภูมิ" ; -- src=panlex
lin battlement_N = mkN "กำแพงที่มีใบเสมา" ; -- src=panlex
lin battleship_N = mkN "แบตเทิลชิป" | mkN "เรือรบเหล็กขนาดใหญ่" ; -- src=panlex
lin battue_N = mkN "การนองเลือด" | mkN "การฆ่าฟันอย่างบ้าคลั่ง" | mkN "การสังหารหมู่อย่างป่าเถื่อน" ; -- src=panlex
lin batty_A = mkA "บ้า" | mkA "ติ๊งต๊อง" | mkA "วิกลจริต" ; -- src=panlex
lin batwing_A = mkA "ที่เหมือนปีกค้างคาว" ; -- src=panlex
lin bauble_N = mkN "ของฉาบฉวย" | mkN "ของเด็กเล่น" | mkN "การประดับเล็ก ๆ น้อย ๆ" | mkN "สิ่งที่ไม่มีค่า" | mkN "เครื่องประดับชิ้นเล็กๆ ราคาถูก" ; -- src=panlex
lin baud_N = mkN "บอดเรท" | mkN "หน่วยวัดอัตราการส่งข้อมูล" | mkN "หน่วยความเร็วในการส่งข้อมูล" ; -- src=panlex
lin baulk_N = mkN "คาน" | mkN "ส่วนบอค" | mkN "สิ่งกีดขวาง" | mkN "คานค้ำหลังคา" ; -- src=panlex
lin baulk_V = mkV "ต่อต้าน" | mkV "ไม่เต็มใจทํา" ; -- src=panlex
lin baulk_V2 = mkV2 "ต่อต้าน" ; ---- | mkV "ไม่เต็มใจทํา" ; -- src=panlex
lin bauxite_N = mkN "บอกไซต์" | mkN "แร่บอกไซต์" | mkN "แร่อะลูมิเนียม" | mkN "หินแร่สําคัญที่อยู่ในอะลูมิเนียม" ; -- src=panlex
lin bawbee_N = mkN "เหรียญบอบี" ; -- src=panlex
lin bawd_N = mkN "ไก่" | mkN "อีตัว" | mkN "กะหรี่" | mkN "นางโลม" | mkN "โสเภณี" | mkN "นางคณิกา" | mkN "หญิงขายตัว" | mkN "หญิงบริการ" | mkN "นางกลางเมือง" | mkN "ผู้หญิงหากิน" | mkN "หญิงงามเมือง" | mkN "ผู้หญิงขายตัว" | mkN "หญิงขายบริการ" | mkN "หญิงขายบริการทางเพศ" | mkN "โสเภณี" | mkN "แม่เล้า" | mkN "คําพูดหยาบคาย" | mkN "ผู้ล่อลวงหญิงมาให้ทําประเวณี ’" ; -- src=panlex
lin bawdry_N = mkN "ความลามก" | mkN "ภาษาลามก" | mkN "ความต่ําช้า" | mkN "ความหยาบคาย" | mkN "การผิดประเวณี" ; -- src=panlex
lin bawdy_A = mkA "ตลกลามก" | mkA "หยาบคาย" | mkA "คําเขียนที่หยาบคาย" ; -- src=panlex
lin bawl_V = mkV "ร่ำไห้" | mkV "ปล่อยโฮ" | mkV "ร้องไห้โฮ" | mkV "ตะโกนสุดเสียง" | mkV "ตวาด" | mkV "ตะคอก" | mkV "ตะโกนหรือร้องเสียงดัง" ; -- src=panlex
lin bawl_V2 = mkV2 "ร่ำไห้" ; ---- | mkV "ปล่อยโฮ" | mkV "ร้องไห้โฮ" | mkV "ตะโกนสุดเสียง" | mkV "ตวาด" | mkV "ตะคอก" | mkV "ตะโกนหรือร้องเสียงดัง" ; -- src=panlex
lin bay_N = mkN "มุข" | mkN "อ่าว" | mkN "ติ่งห้อง" | mkN "เสียงหอน" | mkN "ต้นอบเชยเดือน" | mkN "ม้าสีน้ำตาลแดง" | mkN "ที่ว่างที่จัดไว้" | mkN "ที่ว่างที่จัดไว้ในเครื่องบิน" | mkN "มุข" | mkN "อ่าว" | mkN "การอับจน" | mkN "เสียงหอน" | mkN "สีน้ําตาลแดง" | mkN "ต้นอบเชยเดือน" | mkN "ม้าสีน้ําตาลแดง" | mkN "ที่เว้าของเทือกเขา" | mkN "ม้าที่มีสีน้ําตาลแดง" | mkN "เวิ้งในห้องระหว่างเสาสองต้น" | mkN "พื้นที่หรือบริเวณที่กําหนดไว้" | mkN "ใบพืชที่มีกลิ่นหอมใช้ปรุงอาหาร" ; -- src=panlex
lin bay_V = mkV "เห่าเสียงขรม" | mkV "หอน" ; -- src=panlex
lin baya_N = mkN "นกกระจาบธรรมดา" ; -- src=panlex
lin bayberry_N = mkN "ต้นเบเบอรี่" | mkN "ต้นเบย์เบอร์รี่" ; -- src=panlex
lin bayonet_N = mkN "ดาบปลายปืน" | mkN "มีดปลายปืน" | mkN "ดาบปลายปืน" | mkN "มีดหรือหอกปลายปืน" ; -- src=panlex
lin bayou_N = mkN "บึงบายู" | mkN "ลําธาร" | mkN "สาขาแม่น้ํา" | mkN "สาขาของแม่น้ําทางใต้ของอเมริกาที่ไหลเอื่อยๆ" ; -- src=panlex
lin bazaar_N = mkN "บาซาร์" | mkN "ตลาด" | mkN "ตลาดขายของ" | mkN "ตลาดที่ขายของหลากหลายชนิด" | mkN "ที่ซึ่งมีร้านขายของรวมกันมากๆ" ; -- src=panlex
lin bazooka_N = mkN "บาซูก้า" | mkN "ปืนยิงรถถัง" | mkN "เครื่องยิงจรวดต่อสู้รถถัง" ; -- src=panlex
lin bdellium_N = mkN "เดลเลียม" ; -- src=panlex
lin beach_N = mkN "หาด" | mkN "ชายหาด" | mkN "ริมหาด" | mkN "ชายทะเล" | mkN "ริมทะเล" | mkN "ชายหาด" | mkN "ชายทะเล" | mkN "หาดทราย" ; -- src=panlex
lin beachcomber_N = mkN "คนเก็บของตามชายหาด" | mkN "คนเก็บของตามชายหาด" ; -- src=panlex
lin beachfront_N = mkN "แผ่นดินที่ขนานไปกับชายหาด" ; -- src=panlex
lin beachhead_N = mkN "ฐานทัพ" | mkN "หัวหาด" | mkN "หัวหาด" | mkN "การยึดหัวหาด" | mkN "สถานที่ขึ้นบกทางทหาร" ; -- src=panlex
lin beachwear_N = mkN "ชุดชายหาด" | mkN "เครื่องนุ่งห่มชายหาด" | mkN "ชุดชายหาด" | mkN "ชุดสําหรับใส่เดินชายหาด" ; -- src=panlex
lin beacon_N = mkN "กระโจมไฟ" | mkN "ประภาคาร" | mkN "ไฟสัญญาณ" | mkN "ไฟเตือนภัย" | mkN "หอคอยที่มีไฟเตือนภัย" | mkN "สถานีวิทยุกระจายเสียง" | mkN "นําทาง" | mkN "กระโจมไฟ" | mkN "สัญญาณไฟ" | mkN "ไฟสัญญาณ" | mkN "ดวงประทีป" | mkN "ไฟเตือนภัย" | mkN "เครื่องเตือน" | mkN "เป็นสัญญาณให้" | mkN "เป็นสัญญาณไฟให้" | mkN "ไฟนําทางในการเดินเรือ" ; -- src=panlex
lin bead_N = mkN "หยด" | mkN "ลูกปัด" | mkN "การประดับด้วยลูกปัด" | mkN "ปัด" | mkN "ลูกปัด" | mkN "ลูกประคํา" | mkN "หยดเหงื่อ" | mkN "สิ่งใดที่กลมเหมือนลูกปัด" | mkN "สิ่งที่เป็นลูกทรงกลมเล็ก ๆ" ; -- src=panlex
lin beaded_A = mkA "ซึ่งเต็มไปด้วยหยดน้ำ" | mkA "ตกแต่งด้วยลูกปัด" ; -- src=panlex
lin beading_N = mkN "งานลูกปัด" | mkN "การประดับด้วยลูกปัด" | mkN "ขอบหรือริมของวัตถุที่ประดับด้วยลูกทรงกลม" ; -- src=panlex
lin beadle_N = mkN "ผู้ช่วยประกอบศาสนพิธี" | mkN "นักการ" | mkN "ผู้ถือคทาพิธี" | mkN "ผู้นําพิธีการ" | mkN "ผู้นําพิธีในโบสถ์ของยิว" ; -- src=panlex
lin beads_N = mkN "สร้อยลูกปัด" ; -- src=panlex
lin beady_A = mkA "เหมือนลูกปัด" | mkA "ซึ่งประดับด้วยอัญมณี" | mkA "เหมือนลูกปัด" ; -- src=panlex
lin beagle_N = mkN "บีเกิล" | mkN "สุนัขพันธุ์บีเกิล" | mkN "สุนัขพันธุ์เล็กขาสั้น ใช้ในการล่าสัตว์" | mkN "สุนัขพันธุ์หนึ่งที่มีหูยาว ขาสั้น" ; -- src=panlex
lin beagling_N = mkN "การล่ากระต่าย" ; -- src=panlex
lin beak_N = mkN "จงอย" | mkN "จมูก" | mkN "จะงอย" | mkN "จะงอยปาก" | mkN "จงอยปากของนก" | mkN "ครู" | mkN "จงอย" | mkN "จมูก" | mkN "จะงอย" | mkN "ปากกา" | mkN "ปากนก" | mkN "จงอยปากนก" | mkN "ผู้พิพากษา" | mkN "ส่วนที่คล้ายจะงอบปาก" ; -- src=panlex
lin beaked_A = mkA "ซึ่งมีจงอยปาก" | mkA "ซึ่งมีจงอยปาก" ; -- src=panlex
lin beaker_N = mkN "บีกเกอร์" | mkN "บีกเกอร์" | mkN "ถ้วยสุราขนาดใหญ่" | mkN "ถ้วยที่ใช้ในห้องทดลอง" | mkN "ถ้วยขนาดใหญ่ที่มีปากกว้าง" | mkN "แก้วที่มีส่วนปากเป็นรูปจะงอย" ; -- src=panlex
lin beakless_A = mkA "ซึ่งไม่มีจงอยปาก" ; -- src=panlex
lin beaklike_A = mkA "เหมือนปากนก" ; -- src=panlex
lin beam_N = mkN "คาน" | mkN "รังสี" | mkN "รัศมี" | mkN "ลำแสง" | mkN "คานทรงตัว" | mkN "แป" | mkN "คาน" | mkN "รอด" | mkN "ลํา" | mkN "ขื่อ" | mkN "คร่าว" | mkN "คันรถ" | mkN "คันไถ" | mkN "ขื่อแป" | mkN "คานหาม" | mkN "ลําแสง" | mkN "เขาแกน" | mkN "คันชั่ง" | mkN "ไม้ขวาง" | mkN "ลําแสงไฟ" | mkN "ยิ้มกว้าง" | mkN "สัญญาณวิทยุ" | mkN "รอยยิ้มกว้าง" | mkN "แกนที่ม้วนได้" | mkN "คานรับน้ําหนัก" | mkN "ส่งสัญญาณวิทยุ" | mkN "ลํารังสีขนานกัน" | mkN "มองดูด้วยความดีใจ" | mkN "แสงสว่างซึ่งส่องเป็นลํา" | mkN "เปล่งยิ้มหรือมีสีหน้าที่ปิติยินดี" ; -- src=panlex
lin beam_V = mkV "ผ่องใส" | mkV "ถ่ายทอด" | mkV "ผุดผ่อง" | mkV "ส่องแสง" | mkV "ผ่องแผ้ว" | mkV "ยิ้มแป้น" | mkV "ยิ้มแย้ม" | mkV "ออกอากาศ" | mkV "อิ่มเอิบ" | mkV "เปล่งปลั่ง" | mkV "กระจายเสียง" | mkV "แผ่รังสี" | mkV "ยิ้มกว้าง" | mkV "ส่งสัญญาณวิทยุ" ; -- src=panlex
lin beam_V2 = mkV2 "ผ่องใส" ; ---- | mkV "ถ่ายทอด" | mkV "ผุดผ่อง" | mkV "ส่องแสง" | mkV "ผ่องแผ้ว" | mkV "ยิ้มแป้น" | mkV "ยิ้มแย้ม" | mkV "ออกอากาศ" | mkV "อิ่มเอิบ" | mkV "เปล่งปลั่ง" | mkV "กระจายเสียง" | mkV "แผ่รังสี" | mkV "ยิ้มกว้าง" | mkV "ส่งสัญญาณวิทยุ" ; -- src=panlex
lin beamish_A = mkA "ซึ่งยิ้มแย้ม" ; -- src=panlex
lin beamy_A = mkA "เปล่งแสง" | mkA "มีเขาเป็นกิ่งก้าน" | mkA "เป็นคานที่กว้างใหญ่" ; -- src=panlex
lin bean_N = mkN "กบาล" | mkN "ถั่ว" | mkN "กระโหลก" | mkN "ต้นถั่ว" | mkN "เมล็ดถั่ว" | mkN "ถั่วที่กินได้" | mkN "พืชตระกูลถั่ว" | mkN "ถั่ว" | mkN "เมล็ดถั่ว" | mkN "พืชจําพวก ถั่ว" | mkN "พืชจําพวกถั่ว" | mkN "เมล็ดพืชที่คล้ายถั่ว" ; -- src=panlex
lin beanbag_N = mkN "ถุงใส่ถั่ว" ; -- src=panlex
lin beanball_N = mkN "การขว้างลูกใส่หัวผู้ตี" ; -- src=panlex
lin beano_N = mkN "เกมบิงโก" ; -- src=panlex
lin beanstalk_N = mkN "ลำต้นถั่ว" | mkN "ต้นถั่ว" ; -- src=panlex
lin bear_N = mkN "หมี" | mkN "นักเก็งกำไรหุ้น" | mkN "หมี" | mkN "คนอารมณ์ร้าย" | mkN "ผู้เก็งกําไรหุ้น" ; -- src=panlex
lin bear_V = mkV "ทน" | mkV "มี" | mkV "ยก" | mkV "ยืด" | mkV "รับ" | mkV "แบก" | mkV "คลอด" | mkV "จ่าย" | mkV "ท้อง" | mkV "ป่อง" | mkV "อดทน" | mkV "เกิด" | mkV "เชิด" | mkV "บรรจุ" | mkV "ยอมทน" | mkV "ออกผล" | mkV "ให้ผล" | mkV "มีท้อง" | mkV "คลอดลูก" | mkV "มีครรภ์" | mkV "อดกลั้น" | mkV "เกิดลูก" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "ประพฤติตน" | mkV "มีหนี้สิน" | mkV "ให้กำเนิด" | mkV "ประพฤติตัว" | mkV "ได้รับสิทธิ์" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "มีพระประสูติการ" | mkV "ทน" | mkV "ถือ" | mkV "ค้ํา" | mkV "พยุง" | mkV "หนุน" | mkV "อดทน" | mkV "ทนทาน" | mkV "นําไป" | mkV "ระลึก" | mkV "คลอดลูก" | mkV "บ่ายหน้า" | mkV "ส่งเสริม" | mkV "รับผิดชอบ" | mkV "ปฏิบัติตัว" | mkV "ประพฤติตัว" | mkV "ให้กําเนิด" | mkV "จดจําไว้ใน่ใจ" | mkV "มุ่งหน้าไปทางใดทางหนึ่ง" ; -- src=panlex
lin bear_V2 = mkV2 "ทน" ; ---- | mkV "มี" | mkV "ยก" | mkV "ยืด" | mkV "รับ" | mkV "แบก" | mkV "คลอด" | mkV "จ่าย" | mkV "ท้อง" | mkV "ป่อง" | mkV "อดทน" | mkV "เกิด" | mkV "เชิด" | mkV "บรรจุ" | mkV "ยอมทน" | mkV "ออกผล" | mkV "ให้ผล" | mkV "มีท้อง" | mkV "คลอดลูก" | mkV "มีครรภ์" | mkV "อดกลั้น" | mkV "เกิดลูก" | mkV "อุ้มท้อง" | mkV "ตั้งครรภ์" | mkV "ประพฤติตน" | mkV "มีหนี้สิน" | mkV "ให้กำเนิด" | mkV "ประพฤติตัว" | mkV "ได้รับสิทธิ์" | mkV "แบกรับหนี้สิน" | mkV "รับภาระหนี้สิน" | mkV "มีพระประสูติการ" | mkV "ทน" | mkV "ถือ" | mkV "ค้ํา" | mkV "พยุง" | mkV "หนุน" | mkV "อดทน" | mkV "ทนทาน" | mkV "นําไป" | mkV "ระลึก" | mkV "คลอดลูก" | mkV "บ่ายหน้า" | mkV "ส่งเสริม" | mkV "รับผิดชอบ" | mkV "ปฏิบัติตัว" | mkV "ประพฤติตัว" | mkV "ให้กําเนิด" | mkV "จดจําไว้ใน่ใจ" | mkV "มุ่งหน้าไปทางใดทางหนึ่ง" ; -- src=panlex
lin bear_down_on_V2 = prepV2 (advV OP_bear_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin bear_on_V2 = prepV2 OP_bear_V OP_on_Prep ; -- guess-p-verb
lin bear_out_V2 = prepV2 OP_bear_V OP_out_Prep ; -- guess-p-verb
lin bear_up_V = advV OP_bear_V OP_up_Adv ; -- guess-p-verb
lin bear_up_under_V2 = prepV2 (advV OP_bear_V OP_up_Adv ) OP_under_Prep ; -- guess-p-verb
lin bear_with_V2 = prepV2 OP_bear_V OP_with_Prep ; -- guess-p-verb
lin bearable_A = mkA "ทนได้" | mkA "รับไหว" | mkA "ซึ่งทนได้" | mkA "ออกลูกได้" | mkA "สามารถให้ผล" ; -- src=panlex
lin bearberry_N = mkN "ต้นแบร์เบอร์รี่" | mkN "ต้นแคสคาราบัคทอร์น" ; -- src=panlex
lin beard_N = mkN "เครา" | mkN "ขนเครา" | mkN "รากหอย" | mkN "พระทาฐิกะ" | mkN "พระทาฒิกะ" | mkN "หนวด" | mkN "เครา" | mkN "หนวดสัตว์" | mkN "ขนใต้คางสัตว์" | mkN "ขนแหลมที่รวงข้าว" ; -- src=panlex
lin beardless_A = mkA "ซึ่งไม่มีหนวดเครา" ; -- src=panlex
lin bearer_N = mkN "คนยกของ" | mkN "คนแบกหาม" | mkN "เด็กยกของ" | mkN "คนแบกหีบศพ" | mkN "ผู้ถือพันธบัตร" | mkN "คนใช้" | mkN "ผู้รับ" | mkN "ผู้แบก" | mkN "ผู้ถือจดหมาย" | mkN "เครื่องมือขนส่ง" | mkN "ผู้ประจําตําแหน่ง" | mkN "ผู้ถือจดหมายสั่งของหรือรับเงิน" ; -- src=panlex
lin bearing_N = mkN "ทิศทาง" | mkN "ลักษณะท่าทาง" | mkN "การเกี่ยวข้อง" | mkN "วิธีการวางตัว" | mkN "ผล" | mkN "ทิศทาง" | mkN "ผลผลิต" | mkN "การออกผล" | mkN "การให้ผล" | mkN "ความอดทน" | mkN "ตําแหน่ง" | mkN "ที่รองรับ" | mkN "การอ้างอิง" | mkN "ความสามารถ" | mkN "ความสัมพันธ์" | mkN "ทิศทางที่แน่นอน" | mkN "ลักษณะบุคลิกประจําตัว" | mkN "ลักษณะการเดินหรือการยืน" ; -- src=panlex
lin bearish_A = mkA "หยาบ" | mkA "ชักช้า" | mkA "คล้ายหมี" | mkA "งุ่มง่าม" | mkA "อารมณ์ร้าย" ; -- src=panlex
lin bearnaise_N = mkN "ซอสแบร์เนส" ; -- src=panlex
lin bearskin_N = mkN "ขนหมี" | mkN "หมวกบัสบี" | mkN "ขนและหนังหมี" ; -- src=panlex
lin beast_N = mkN "สัตว์" | mkN "สัตว์ป่า" | mkN "คนโหดร้าย" | mkN "เดียรัจฉาน" | mkN "สิ่งมีชีวิต" | mkN "สัตว์เดียรัจฉาน" | mkN "คนดุร้ายเหมือนสัตว์" | mkN "สัตว์" | mkN "คนเลวทราม" | mkN "คนซึ่งร้าย" | mkN "มนุษย์ร้ายกาจ" | mkN "สัตว์เดรัจฉาน" | mkN "สิงห์สาราสัตว์" | mkN "คนดุร้ายเหมือนสัตว์" ; -- src=panlex
lin beastly_A = mkA "ทารุณ" | mkA "อย่างยิ่ง" | mkA "โหดเหี้ยม" | mkA "คล้ายสัตว์" | mkA "ไม่น่าพอใจ" | mkA "น่าเกลียดน่าชัง" ; -- src=panlex
lin beastly_Adv = mkAdv "เยี่ยงสัตว์" ; -- src=panlex
lin beat_N = mkN "บีต" | mkN "การตี" | mkN "ริทึม" | mkN "จังหวะ" | mkN "เสียงตี" | mkN "จังหวะเพลง" | mkN "จังหวะดนตรี" | mkN "การเต้นของชีพจร" | mkN "การเต้นของหัวใจ" | mkN "จังหวะการทำซ้ำๆ" | mkN "เส้นทางลาดตระเวน" | mkN "การเต้นเป็นจังหวะ" | mkN "จังหวะในฉันทลักษณ์" | mkN "ชีพจรเต้นเป็นจังหวะ" | mkN "หอบ" | mkN "จังหวะ" | mkN "ใจสั่น" | mkN "ใจเต้น" | mkN "เสียงเคาะ" | mkN "การลาดตระเวน" ; -- src=panlex
lin beat_V = mkV "ตี" | mkV "ขยับ" | mkV "สั่น" | mkV "เข่น" | mkV "เคาะ" | mkV "เต้น" | mkV "ตีปีก" | mkV "บดอัด" | mkV "พิชิต" | mkV "หมดแรง" | mkV "เลี่ยง" | mkV "เอาชนะ" | mkV "ขยับปีก" | mkV "หมดพลัง" | mkV "อ่อนล้า" | mkV "หมดกำลัง" | mkV "กระพือปีก" | mkV "ทำให้สับสน" | mkV "อ่อนเปลี้ย" | mkV "เคาะจังหวะ" | mkV "เหนื่อยล้า" | mkV "ตีเป็นจังหวะ" | mkV "หมดเรี่ยวแรง" | mkV "กะปลกกะเปลี้ย" | mkV "หมดเรี่ยวหมดแรง" | mkV "เอาชนะด้วยอุบาย" | mkV "ตบ" | mkV "ตี" | mkV "หวด" | mkV "หอบ" | mkV "เคาะ" | mkV "ตีไข่" | mkV "เฆี่ยน" | mkV "เอาชนะ" | mkV "กระพือปีก" | mkV "ทําให้พ่ายแพ้" | mkV "เต้นเป็นจังหวะ" | mkV "ตีหรือคนให้เข้ากัน" | mkV "หลีกเลี่ยงการล่าช้า" | mkV "มาถึงหรือทําบางสิ่งเร็วกว่า" ; -- src=panlex
lin beat_V2 = mkV2 "ตี" ; ---- | mkV "ขยับ" | mkV "สั่น" | mkV "เข่น" | mkV "เคาะ" | mkV "เต้น" | mkV "ตีปีก" | mkV "บดอัด" | mkV "พิชิต" | mkV "หมดแรง" | mkV "เลี่ยง" | mkV "เอาชนะ" | mkV "ขยับปีก" | mkV "หมดพลัง" | mkV "อ่อนล้า" | mkV "หมดกำลัง" | mkV "กระพือปีก" | mkV "ทำให้สับสน" | mkV "อ่อนเปลี้ย" | mkV "เคาะจังหวะ" | mkV "เหนื่อยล้า" | mkV "ตีเป็นจังหวะ" | mkV "หมดเรี่ยวแรง" | mkV "กะปลกกะเปลี้ย" | mkV "หมดเรี่ยวหมดแรง" | mkV "เอาชนะด้วยอุบาย" | mkV "ตบ" | mkV "ตี" | mkV "หวด" | mkV "หอบ" | mkV "เคาะ" | mkV "ตีไข่" | mkV "เฆี่ยน" | mkV "เอาชนะ" | mkV "กระพือปีก" | mkV "ทําให้พ่ายแพ้" | mkV "เต้นเป็นจังหวะ" | mkV "ตีหรือคนให้เข้ากัน" | mkV "หลีกเลี่ยงการล่าช้า" | mkV "มาถึงหรือทําบางสิ่งเร็วกว่า" ; -- src=panlex
lin beat_back_V = advV OP_beat_V OP_back_Adv ; -- guess-p-verb
lin beat_down_V = advV OP_beat_V OP_down_Adv ; -- guess-p-verb
lin beat_down_V2 = prepV2 OP_beat_V OP_down_Prep ; -- guess-p-verb
lin beat_out_V2 = prepV2 OP_beat_V OP_out_Prep ; -- guess-p-verb
lin beat_up_V2 = prepV2 OP_beat_V OP_up_Prep ; -- guess-p-verb
lin beaten_A = mkA "ถูกตี" | mkA "ถูกตีให้แบน" | mkA "ขยี้" | mkA "เก่า" | mkA "พ่ายแพ้" | mkA "อ่อนแรง" | mkA "เหนื่อย" | mkA "ถูกโจมตี" | mkA "ทําเป็นผง" | mkA "กลายเป็นผง" | mkA "หมดเรี่ยวแรง" | mkA "ถูกเหยียบจนเรียบ" | mkA "เป็นผงหรือที่ตีแล้ว" ; -- src=panlex
lin beater_N = mkN "ที่ตี" | mkN "ที่ใช้ตี" | mkN "คนไล่ต้อนสัตว์" | mkN "อุปกรณ์สำหรับตี" | mkN "ผู้ตี" | mkN "สิ่งตี" ; -- src=panlex
lin beatific_A = mkA "ที่เหมือนนักบุญ" | mkA "ซึ่งปิติยินดี" | mkA "ซึ่งมีความอิ่มเอิบใจ" ; -- src=panlex
lin beatification_N = mkN "ความสุข" ; -- src=panlex
lin beating_N = mkN "การเฆี่ยน" | mkN "การเอาชนะ" | mkN "การตีซ้ําๆ" | mkN "ความปราชัย" | mkN "การฟาดซ้ําๆ" | mkN "ความพ่ายแพ้" ; -- src=panlex
lin beatitude_N = mkN "ความสุข" | mkN "สุขคติ" | mkN "การประสาทพร" | mkN "ความสุขสุดขีด" | mkN "ความสุขอย่างยิ่ง" | mkN "ความปิติอย่างยิ่ง" ; -- src=panlex
lin beatnik_N = mkN "คนหนุ่มสาวยุค1950-1960ที่ทําตัวต่างจากคนส่วนมากในสังคม" ; -- src=panlex
lin beau_N = mkN "คนขี้โอ่" | mkN "แฟนหนุ่ม" | mkN "เพื่อนชาย" | mkN "หนุ่มสำรวย" | mkN "หนุ่มสำอาง" | mkN "เพื่อนผู้ชาย" | mkN "พ่อ" | mkN "คู่รัก" | mkN "พวงมาลัย" | mkN "ชายที่คอยเอาอกเอาใจหญิง คนเจ้าชู้" | mkN "ชายคู่ควงที่มีเสน่ห์ของหญิง" ; -- src=panlex
lin beaugregory_N = mkN "ปลาบิวเกรกอรี" ; -- src=panlex
lin beauteous_A = mkA "น่ามอง" | mkA "สวยงาม" | mkA "ที่สวยงาม" ; -- src=panlex
lin beautician_N = mkN "ช่างเสริมสวย" | mkN "ผู้เสริมสวย" | mkN "ช่างเสริมสวย" | mkN "ผู้จัดการร้านเสริมสวย" ; -- src=panlex
lin beautification_N = mkN "การทำให้สวย" | mkN "การเสริมสวย" | mkN "การเสริมสวย" | mkN "การเสริมความงาม" ; -- src=panlex
lin beautiful_A = mkA "สวย" | {-pan-} mkA "งาม" | mkA "ดี" | mkA "งาม" | mkA "เลิศ" | mkA "งดงาม" | mkA "ดีมาก" | mkA "สดสวย" | mkA "สวยงาม" | mkA "ยอดเยี่ยม" ; -- src=panlex
lin beauty_N = mkN "คนสวย" | mkN "สาวงาม" | mkN "ความงาม" | mkN "ความสวย" | mkN "ความงดงาม" | mkN "ความสวยงาม" | mkN "ความมีเสน่ห์" | mkN "สิ่งที่เด่นกว่า" | mkN "คนงาม" | mkN "คนสวย" | mkN "ข้อขํา" | mkN "คนเด่น" | mkN "หญิงงาม" | mkN "ความสวยงาม" | mkN "ข้อได้เปรียบ" | mkN "สิ่งที่ดีงาม" | mkN "สิ่งที่ดีเด่น" | mkN "สิ่งที่สวยงาม" | mkN "การตกแต่งให้สวยงาม" | mkN "คุณสมบัติที่ดีที่สุด" | mkN "สิ่งที่ดีเด่นกว่าสิ่งอื่น" ; -- src=panlex
lin beaver_N = mkN "เกราะ" | mkN "เคราดก" | mkN "ขนบีเวอร์" | mkN "ตัวบีเวอร์" | mkN "หมวกทรงสูง" | mkN "หมวกทรงกระบอก" | mkN "หมวกที่มีขนยาว" | mkN "ขนของตัวบีเวอร์" | mkN "คนที่ขยันขันแข็งอย่างพิเศษ" | mkN "สัตว์ครึ่งบกครึ่งน้ําคล้ายนาก" | mkN "หนังหรือสิ่งทอของสัตว์จําพวกนี้" ; -- src=panlex
lin beaver_V = mkV "ขยันทำงาน" ; -- src=panlex
lin because_Subj = ss (thword "เพ" "ราะ") ;
lin beck_N = mkN "การส่งสัญญาณโดยใช้ท่าทาง" | mkN "ลําธาร" ; -- src=panlex
lin becket_N = mkN "เชือกขนาดสั้นชนิดหนึ่งที่มีปมของเรือ" ; -- src=panlex
lin beckon_V = mkV "โบกมือ" | mkV "เชื้อเชิญ" | mkV "กวักมือเรียก" | mkV "โบกไม้โบกมือ" | mkV "ผงกศรีษะ" | mkV "ทําให้สนใจ" | mkV "กวักมือเรียก" | mkV "ส่งสัญญาณเรียกโดยการใช้มือหรือศีรษะ" ; -- src=panlex
lin beckon_V2 = mkV2 "โบกมือ" ; ---- | mkV "เชื้อเชิญ" | mkV "กวักมือเรียก" | mkV "โบกไม้โบกมือ" | mkV "ผงกศรีษะ" | mkV "ทําให้สนใจ" | mkV "กวักมือเรียก" | mkV "ส่งสัญญาณเรียกโดยการใช้มือหรือศีรษะ" ; -- src=panlex
lin become_V = mkV "รู้สึก" | mkV "กลายเป็น" | mkV "เหมาะกับ" | mkV "งดงาม" | mkV "เข้ากับ" | mkV "เหมาะสม" | mkV "กลายเป็น" | mkV "ดูสวยงาม" | mkV "เหมาะสมกับ" | mkV "เปลี่ยนเป็น" ; -- src=panlex
lin become_V2 = mkV2 "รู้สึก" ; ---- | mkV "กลายเป็น" | mkV "เหมาะกับ" | mkV "งดงาม" | mkV "เข้ากับ" | mkV "เหมาะสม" | mkV "กลายเป็น" | mkV "ดูสวยงาม" | mkV "เหมาะสมกับ" | mkV "เปลี่ยนเป็น" ; -- src=panlex
lin become_VA = mkV (thword "กลาย" "เป็น") ; -- pen
lin bed_N = mkN "ก้น" | mkN "ฐาน" | mkN "ชั้น" | mkN "แปลง" | mkN "เตียง" | mkN "ที่นอน" | mkN "ชั้นหิน" | mkN "เตียงนอน" | mkN "แปลงปลูก" | mkN "แท่นพิมพ์" | mkN "ชั้นหินแร่" | mkN "แปลงปลูกพืช" | mkN "พระแท่นบรรทม" | mkN "พื้นดินใต้ทะเลลึก" | mkN "ฐาน" | mkN "ฟูก" | mkN "ร่อง" | mkN "หมอน" | mkN "แท่น" | mkN "แปลง" | mkN "เตียง" | mkN "ที่นอน" | mkN "แนวหิน" | mkN "ชั้นหิน" | mkN "กองหนึ่ง" | mkN "พื้นล่าง" | mkN "เตียงนอน" | mkN "การนอนหลับ" | mkN "แปลงที่ดิน" | mkN "พื้นถนนรถไฟ" | mkN "ที่สําหรับนอน" | mkN "ใต้ท้องแม่น้ํา" | mkN "พื้นดินก้นทะเล แม้น้ําหรือทะเลสาบ" | mkN "การมีเพศสัมพันธ์" | mkN "ฐานของถนนหรือรางรถไฟ" | mkN "พื้นที่ใต้ทะเลที่มีหอยฝังตัวอยู่" ; -- src=panlex
lin bedaubed_A = mkA "ซึ่งประดับอย่างไร้รสนิยม" ; -- src=panlex
lin bedbug_N = mkN "ตัวไร" | mkN "ตัวเรือด" ; -- src=panlex
lin bedclothes_N = mkN "เครื่องนอน" | mkN "ที่นอนหมอนมุ้ง" | mkN "ผ้าปูที่นอนหรือผ้าคลุมเตียง" ; -- src=panlex
lin bedding_N = mkN "เครื่องนอน" | mkN "ที่ปูคอกสัตว์" | mkN "ที่นอนหมอนมุ้ง" | mkN "ที่นอนและผ้าปูที่นอน" ; -- src=panlex
lin bedfast_A = mkA "ซึ่งนอนป่วย" | mkA "ซึ่งล้มป่วย" | mkA "ซึ่งล้มหมอนนอนเสื่อ" ; -- src=panlex
lin bedfellow_N = mkN "เพื่อนร่วมเตียง" | mkN "การเกี่ยวข้องชั่วคราว" | mkN "ผู้ร่วมงาน" | mkN "ผู้ร่วมเตียงนอน" | mkN "คนหรือสิ่งที่เกี่ยวข้องกับ" ; -- src=panlex
lin bedlam_N = mkN "ความสับสน" | mkN "ความโกลาหล" | mkN "ความวิกลจริต" | mkN "เสียงสับสน" | mkN "เสียงวุ่นวาย" | mkN "โรงพยาบาลคนบ้า" | mkN "ภาพโกลาหลอลหม่าน" ; -- src=panlex
lin bedlamite_N = mkN "คนบ้า" ; -- src=panlex
lin bedless_A = mkA "ที่ไม่มีเตียง" ; -- src=panlex
lin bedouin_N = mkN "อาหรับในทะเลทราย" | mkN "อาหรับที่ร่อนเร่พเนจร" ; -- src=panlex
lin bedpan_N = mkN "กระโถนที่ให้คนไข้บนเตียงขับถ่าย" | mkN "ภาชนะสําหรับอุจจาระ หรือปัสสาวะบนเตียง" | mkN "หม้อนอนสําหรับถ่ายอุจจาระและปัสสาวะบนเตียง" ; -- src=panlex
lin bedpost_N = mkN "ขาเตียง" | mkN "เสาเตียง" | mkN "เสาเตียง" ; -- src=panlex
lin bedraggled_A = mkA "ซึ่งทําให้เปรอะเปื้อนและเปียก" ; -- src=panlex
lin bedridden_A = mkA "ซึ่งนอนป่วย" | mkA "ซึ่งล้มป่วย" | mkA "ซึ่งล้มหมอนนอนเสื่อ" | mkA "ล้มป่วย" | mkA "ล้มหมอนนอนเสื่อ" ; -- src=panlex
lin bedrock_N = mkN "ข้อเท็จจริง" | mkN "หินแข็งชั้นล่างใต้ชั้นดินและทราย" | mkN "ฐานที่แน่น" | mkN "ชั้นล่างสุด" | mkN "ชั้นหินที่ยังไม่แตก" | mkN "หินแข็งชั้นล่างที่อยู่ใต้ชั้นดินและทราย" ; -- src=panlex
lin bedroom_N = mkN "ห้องนอน" | mkN "ห้องพระบรรทม" | mkN "ที่หลับที่นอน" | mkN "ห้องนอน" ; -- src=panlex
lin bedside_N = mkN "พื้นที่ข้างเตียง" | mkN "ข้างเตียง" | mkN "พื้นที่ข้างเตียง" ; -- src=panlex
lin bedsit_N = mkN "ห้องที่ให้เช่าและพักอาศัย" ; -- src=panlex
lin bedsitter_N = mkN "ห้องที่ให้เช่าและพักอาศัย" ; -- src=panlex
lin bedsore_N = mkN "แผลนอนทับ" | mkN "แผลกดทับ" ; -- src=panlex
lin bedspread_N = mkN "ผ้าคลุมเตียง" | mkN "ผ้าคลุมที่นอน" | mkN "ผ้าคลุมเตียง" ; -- src=panlex
lin bedspring_N = mkN "สปริงที่นอน" ; -- src=panlex
lin bedstead_N = mkN "โครงเตียง" | mkN "โครงเตียงนอน" | mkN "โครงเตียง" | mkN "โครงไม้หรือเหล็กของเตียงแบบเก่า" ; -- src=panlex
lin bedstraw_N = mkN "ต้นเบดสตรอว์" ; -- src=panlex
lin bedtime_N = mkN "เวลานอน" | mkN "เวลาเข้านอน" | mkN "เวลานอน" | mkN "เวลาเข้านอน" ; -- src=panlex
lin bedwetter_N = mkN "คนฉี่รดที่นอน" ; -- src=panlex
lin bee_N = mkN "ผึ้ง" | mkN "การรวมตัวกัน" | mkN "กวี" | mkN "ภมร" | mkN "ผึ้ง" | mkN "งานสังสรรค์" | mkN "ความคิดที่แปลก" | mkN "การรวมตัวเพื่อทํากิจกรรมร่วมกัน" ; -- src=panlex
lin beebread_N = mkN "แอมโบรเซีย" ; -- src=panlex
lin beech_N = mkN "ต้นบีช" | mkN "ไม้บีช" | mkN "ไม้บีชวู้ด" | mkN "ไม้มะเดื่อ" | mkN "ต้นไม้จำพวกมะเดื่อ" ; -- src=panlex
lin beechen_A = mkA "ไม้บีช" ; -- src=panlex
lin beechnut_N = mkN "บีชนัท" ; -- src=panlex
lin beef_1_N = mkN "เนื้อ" | mkN "การบ่น" | mkN "เนื้อโค" | mkN "โคเนื้อ" | mkN "วัวเนื้อ" | mkN "เนื้อวัว" | mkN "การบ่นไม่หยุด" | mkN "การบ่น" | mkN "อํานาจ" | mkN "เนื้อวัว" | mkN "พละกําลัง" | mkN "กําลังกล้ามเนื้อ" | mkN "วัวที่เลี้ยงไว้ฆ่าเป็นอาหาร" ; -- src=panlex
lin beef_2_N = mkN "เนื้อ" | mkN "การบ่น" | mkN "เนื้อโค" | mkN "โคเนื้อ" | mkN "วัวเนื้อ" | mkN "เนื้อวัว" | mkN "การบ่นไม่หยุด" | mkN "การบ่น" | mkN "อํานาจ" | mkN "เนื้อวัว" | mkN "พละกําลัง" | mkN "กําลังกล้ามเนื้อ" | mkN "วัวที่เลี้ยงไว้ฆ่าเป็นอาหาร" ; -- src=panlex
lin beef_3_N = mkN "เนื้อ" | mkN "การบ่น" | mkN "เนื้อโค" | mkN "โคเนื้อ" | mkN "วัวเนื้อ" | mkN "เนื้อวัว" | mkN "การบ่นไม่หยุด" | mkN "การบ่น" | mkN "อํานาจ" | mkN "เนื้อวัว" | mkN "พละกําลัง" | mkN "กําลังกล้ามเนื้อ" | mkN "วัวที่เลี้ยงไว้ฆ่าเป็นอาหาร" ; -- src=panlex
lin beef_V = mkV "บ่น" ; -- src=panlex
lin beefcake_N = mkN "ภาพนักเพาะกาย" | mkN "ชายที่มีกล้ามใหญ่" ; -- src=panlex
lin beefeater_N = mkN "หน่วยราชองครักษ์" ; -- src=panlex
lin beefsteak_N = mkN "สเต็กเนื้อ" | mkN "สเต็กเนื้อวัว" | mkN "สเต็กประเภทหนึ่ง" ; -- src=panlex
lin beefwood_N = mkN "ต้นบีฟวู้ด" | mkN "ไม้บีฟวู้ด" ; -- src=panlex
lin beefy_A = mkA "อ้วนมาก" ; -- src=panlex
lin beehive_N = mkN "รวงรัง" | mkN "รวงผึ้ง" | mkN "รังผึ้ง" | mkN "สถานที่จอแจ" | mkN "ทรงผมรังผึ้ง" | mkN "รวงผึ้ง" | mkN "รังผึ้ง" ; -- src=panlex
lin beekeeper_N = mkN "คนเลี้ยงผึ้ง" | mkN "เกษตรกรผู้เลี้ยงผึ้ง" | mkN "คนเลี้ยงผึ้ง" ; -- src=panlex
lin beekeeping_N = mkN "การเลี้ยงผึ้ง" ; -- src=panlex
lin beeline_N = mkN "ทางตรง" | mkN "ทางตรง" | mkN "ทางลัดตัดตรง" ; -- src=panlex
lin beep_N = mkN "เสียงบี๊บ" | mkN "เสียงตี๊ดๆ" | mkN "เสียงบี๊ปๆ" | mkN "เสียงบี๊ปๆ" | mkN "เสียงแตรรถยนต์" | mkN "เสียงเตือนแหลมสั้น" ; -- src=panlex
lin beeper_N = mkN "เพจ" | mkN "เพจเจอร์" | mkN "วิทยุติดตามตัว" | mkN "เครื่องเพจเจอร์" | mkN "เครื่องวิทยุติดตามตัว" ; -- src=panlex
lin beer_N = mkN biar_s kew_s ;
lin beery_A = mkA "ที่เหม็นกลิ่นเบียร์" | mkA "กลิ่นเบียร์" ; -- src=panlex
lin beeswax_N = mkN "ขี้ผึ้ง" | mkN "ขี้ผึ้ง" | mkN "ขึ้ผึ้ง" ; -- src=panlex
lin beet_N = mkN "หัวบีท" | mkN "หัวผักกาดหวาน" | mkN "ใบของพืชจําพวก นี้ ใช้ทําสลัดกินได้" | mkN "พืชชนิดหนึ่งคล้ายหัวผักกาด" ; -- src=panlex
lin beetle_A = mkA "ที่ยื่นออกมา" | mkA "ที่โผล่ออกมา" ; -- src=panlex
lin beetle_N = mkN "ด้วง" | mkN "ค้อนไม้" | mkN "ตะลุมพุก" | mkN "แมลงปีกแข็ง" | mkN "ไม้ตี" | mkN "แมลงปีกแข็ง" | mkN "แมลงปีกแข็งเช่น ตัวด้วง" | mkN "สิ่งของที่มีลักษณะคล้ายค้อน" ; -- src=panlex
lin beetle_V = mkV "ยื่นออกมา" | mkV "โผล่ออกมา" | mkV "ไปหรือมาอย่างรีบร้อน" ; -- src=panlex
lin beetroot_N = mkN "หัวบีท" | mkN "ต้นบีทรูท" | mkN "หัวผักกาดหวาน" | mkN "หัวบีตรูตใช้เป็นอาหารสัตว์" ; -- src=panlex
lin befall_V = mkV "อุบัติ" | mkV "กล้ำกราย" | mkV "เกิดขึ้น" | mkV "เกิดขึ้นกับ" | mkV "เกิดขึ้น" | mkV "บังเกิดขึ้น" ; -- src=panlex
lin befall_V2 = mkV2 "อุบัติ" ; ---- | mkV "กล้ำกราย" | mkV "เกิดขึ้น" | mkV "เกิดขึ้นกับ" | mkV "เกิดขึ้น" | mkV "บังเกิดขึ้น" ; -- src=panlex
lin befitting_A = mkA "เหมาะ" | mkA "เหมาะสม" ; -- src=panlex
lin befogged_A = mkA "เมา" ; -- src=panlex
lin before_Adv = mkAdv "ก่อน" | mkAdv "อยู่หน้า" | mkAdv "กว่า" | mkAdv "ก่อน" | mkAdv "หน้า" | mkAdv "คอยอยู่" | mkAdv "ตรงหน้า" | mkAdv "ในอนาคต" | mkAdv "ก่อนหน้า" | mkAdv "อยู่หน้า" | mkAdv "ก่อนหน้านี้" | mkAdv "อยู่ข้างหน้า" | mkAdv "ภายใต้อิทธิพลของ" ; -- src=panlex
lin before_Prep = ss "ก่อน" | {-pan-} mkPrep "กว่า" | mkPrep "ก่อน" | mkPrep "หน้า" | mkPrep "คอยอยู่" | mkPrep "ตรงหน้า" | mkPrep "ในอนาคต" | mkPrep "ก่อนหน้า" | mkPrep "อยู่หน้า" | mkPrep "ภายใต้อิทธิพลของ" ; -- src=panlex
lin beforehand_A = mkA "ก่อน" | mkA "ไว้ก่อน" | mkA "ล่วงหน้า" ; -- src=panlex
lin beforehand_Adv = mkAdv "ล่วงหน้า" | mkAdv "ก่อน" | mkAdv "ไว้ก่อน" | mkAdv "ก่อนเวลา" | mkAdv "ล่วงหน้า" ; -- src=panlex
lin beg_V = mkV "ขอทาน" | mkV "ขอร้อง" | mkV "วิงวอน" | mkV "ขอ" | mkV "ขอทาน" | mkV "ขอร้อง" | mkV "หลบหลีก" | mkV "อ้อนวอน" | mkV "เพิกเฉย" | mkV "หลีกเลี่ยง" | mkV "ขอความกรุณา" ; -- src=panlex
lin beg_V2 = mkV2 "ขอทาน" ; ---- | mkV "ขอร้อง" | mkV "วิงวอน" | mkV "ขอ" | mkV "ขอทาน" | mkV "ขอร้อง" | mkV "หลบหลีก" | mkV "อ้อนวอน" | mkV "เพิกเฉย" | mkV "หลีกเลี่ยง" | mkV "ขอความกรุณา" ; -- src=panlex
lin beg_V2V = regV "ขอ" ** {c2 = [] ; c3 = "ให้"} ; --- hay as prep of VP
lin begetter_N = mkN "พ่อ" | mkN "บิดา" ; -- src=panlex
lin beggar_N = mkN "ขอทาน" | mkN "คนขอทาน" | mkN "คนจน" | mkN "ยาจก" | mkN "ขอทาน" | mkN "วนิพก" | mkN "คนขอทาน" ; -- src=panlex
lin beggarly_A = mkA "ไม่เคยพอ" | mkA "ขี้เหนียว" ; -- src=panlex
lin beggarman_N = mkN "ชายขอทาน" ; -- src=panlex
lin beggarweed_N = mkN "ต้นเบกการ์วีด" ; -- src=panlex
lin beggarwoman_N = mkN "หญิงขอทาน" ; -- src=panlex
lin beggary_N = mkN "ความยากจน" | mkN "คนขอทาน" | mkN "ความยากจน" | mkN "ชีวิตคนขอทาน" ; -- src=panlex
lin begin_V = mkV "เริ่ม" | mkV "เริ่มต้น" | mkV "เริ่มที่" | mkV "เริ่มขึ้น" | mkV "เริ่มด้วย" | mkV "เริ่ม" | mkV "ก่อตั้ง" | mkV "ขึ้นต้น" | mkV "ตั้งต้น" | mkV "เกิดขึ้น" | mkV "เริ่มต้น" ; -- src=panlex
lin begin_V2 = mkV2 "เริ่ม" ; ---- | mkV "เริ่มต้น" | mkV "เริ่มที่" | mkV "เริ่มขึ้น" | mkV "เริ่มด้วย" | mkV "เริ่ม" | mkV "ก่อตั้ง" | mkV "ขึ้นต้น" | mkV "ตั้งต้น" | mkV "เกิดขึ้น" | mkV "เริ่มต้น" ; -- src=panlex
lin beginner_N = mkN "บิดา" | mkN "เด็กใหม่" | mkN "ผู้ก่อตั้ง" | mkN "ผู้ที่เพิ่งจะเริ่มต้นทําสิ่งใดสิ่งหนึ่ง" ; -- src=panlex
lin beginning_N = mkN "ยุคแรก" | mkN "ส่วนต้น" | mkN "ครั้งแรก" | mkN "ต้นกำเนิด" | mkN "การเปิดฉาก" | mkN "การเริ่มต้น" | mkN "แหล่งกำเนิด" | mkN "ช่วงเริ่มต้น" | mkN "ตอนแรก" | mkN "การเริ่ม" | mkN "เริ่มแรก" | mkN "จุดกําเนิด" | mkN "จุดเริ่มต้น" | mkN "ระยะตั้งต้น" | mkN "การมีกําเนิดจาก" ; -- src=panlex
lin begonia_N = mkN "บีโกเนีย" | mkN "ต้นบีโกเนีย" | mkN "ต้นไม้มีดอกหลากหลายสี ปลูกในร่ม" ; -- src=panlex
lin beguilement_N = mkN "การหลอกล่อ" | mkN "การทําให้หลงกล" ; -- src=panlex
lin beguiling_A = mkA "ซึ่งตบตาหรือล่อลวง" ; -- src=panlex
lin beguine_N = mkN "เบกีน" | mkN "จังหวะบิกิน" | mkN "ชื่อการเต้นรําชนิดหนึ่งในอาฟริกาใต้" ; -- src=panlex
lin begum_N = mkN "บีกัม" | mkN "คําเรียกอย่างให้เกียรติหญิงมุสลิมสูงศักดิ์หรือแต่งงานแล้ว" ; -- src=panlex
lin behalf_N = mkN "ตัวแทน" | mkN "ประโยชน์" | mkN "ในนามของ" ; -- src=panlex
lin behave_V = mkV "ทำตัว" | mkV "ทำตัวดี" | mkV "ประพฤติตน" | mkV "ประพฤติตัว" | mkV "มีพฤติกรรม" | mkV "ประพฤติตัวดี" | mkV "มีความประพฤติ" | mkV "วางตัว" | mkV "ประพฤติ" | mkV "ปฏิบัติตัว" | mkV "ประพฤติตัว" ; -- src=panlex
lin behavior_N = mkN "กิริยา" | mkN "มารยาท" | mkN "พฤติกรรม" | mkN "ท่าที" | mkN "อาการ" | mkN "พฤติกรรม" | mkN "พฤติการณ์" | mkN "ความประพฤติ" | mkN "การกระทําตัว" | mkN "การแสดงอาการ" ; -- src=panlex
lin behavioral_A = mkA "แห่งพฤติกรรม" | mkA "เกี่ยวกับพฤติกรรม" | mkA "เกี่ยวกับบุคลิกภาพ" | mkA "เกี่ยวกับการทําตัวหรืออาการท่าทีของสัตว์" ; -- src=panlex
lin behavioristic_A = mkA "พฤติกรรมนิยม" ; -- src=panlex
lin behaviour_N = mkN "กิริยา" | mkN "มารยาท" | mkN "พฤติกรรม" | mkN "ท่าที" | mkN "อาการ" | mkN "พฤติกรรม" | mkN "พฤติการณ์" | mkN "ความประพฤติ" | mkN "การกระทําตัว" | mkN "การแสดงอาการ" ; -- src=panlex
lin behaviourism_N = mkN "พฤติกรรมนิยม" ; -- src=panlex
lin behaviourist_N = mkN "นักพฤติกรรมนิยม" ; -- src=panlex
lin behest_N = mkN "คำสั่ง" | mkN "คําสั่ง" | mkN "คําขอร้อง" | mkN "พระบรมราชโองการ" ; -- src=panlex
lin behind_Adv = mkAdv "ช้า" | mkAdv "ก้น" | mkAdv "หลัง" | mkAdv "ข้างหลัง" | mkAdv "ชําระเงิน" | mkAdv "ล้าหลังกว่า" | mkAdv "ที่เหลืออยู่" | mkAdv "ที่ค้างชําระเงิน" | mkAdv "เหตุการณ์ที่ผ่านมาแล้ว" ; -- src=panlex
lin behind_N = mkN "ก้น" | mkN "ตูด" | mkN "บั้นท้าย" ; -- src=panlex
lin behind_Prep = ss "หลัง" | {-pan-} mkPrep "ก้น" | mkPrep "แฝง" | mkPrep "หลัง" | mkPrep "ช้ากว่า" | mkPrep "ตามหลัง" | mkPrep "ข้างหลัง" | mkPrep "สนับสนุน" | mkPrep "ไม่เปิดเผย" | mkPrep "ล้าหลังกว่า" | mkPrep "อยู่เบื้องหลัง" | mkPrep "ซ่อนเร้นอยู่ภายใน" ; -- src=panlex
lin behindhand_A = mkA "ชักช้า" | mkA "ล้าหลัง" | mkA "ค้างชําระหนี้" | mkA "ค้างชําระเงิน" ; -- src=panlex
lin beholden_A = mkA "รู้สึกทราบซึ้ง" | mkA "เป็นหนี้บุญคุณ" | mkA "ได้รับความเมตตา" ; -- src=panlex
lin beholder_N = mkN "ผู้รับรู้" | mkN "ผู้สังเกตการณ์" | mkN "ผู้มองเห็น" ; -- src=panlex
lin beige_A = mkA "เบจ" ; -- src=panlex
lin beige_N = mkN "สีเบจ" | mkN "ชีวิต" | mkN "สีเทาอ่อน" | mkN "การดํารงอยู่" | mkN "สีน้ําตาลอ่อน" ; -- src=panlex
lin being_N = mkN "เป็น" | mkN "การเป็นอยู่" | mkN "สิ่งมีชีวิต" | mkN "คน" | mkN "สาร" | mkN "ชีวิต" | mkN "บุคคล" | mkN "มนุษย์" | mkN "ธาตุแท้" | mkN "พระเจ้า" | mkN "ธรรมชาติ" | mkN "การมีอยู่" | mkN "มีตัวมีตน" | mkN "การเป็นอยู่" | mkN "สิ่งมีชีวิต" | mkN "การดํารงอยู่" | mkN "การมีชีวิตอยู่" | mkN "ภาวะมีชีวิตอยู่" ; -- src=panlex
lin bejewelled_A = mkA "ประดับด้วยเครื่องเพชรหรือสวมเพชร" ; -- src=panlex
lin belated_A = mkA "ล่าช้า" | mkA "ยังค้างอยู่" ; -- src=panlex
lin belch_N = mkN "การเรอ" ; -- src=panlex
lin belch_V = mkV "พ่น" | mkV "เรอ" | mkV "เรอ" ; -- src=panlex
lin belch_V2 = mkV2 "พ่น" ; ---- | mkV "เรอ" | mkV "เรอ" ; -- src=panlex
lin belching_N = mkN "การเรอ" ; -- src=panlex
lin beldam_N = mkN "แม่มด" | mkN "ยายแก่" | mkN "ยายเฒ่า" | mkN "ยายแม่มด" ; -- src=panlex
lin beldame_N = mkN "แม่มด" | mkN "ยายแก่" | mkN "ยายเฒ่า" | mkN "ยายแม่มด" ; -- src=panlex
lin belemnite_N = mkN "เบเลมไนต์" ; -- src=panlex
lin belfry_N = mkN "หอระฆัง" | mkN "หอระฆัง" | mkN "โครงไม้สําหรับแขวนระฆัง" ; -- src=panlex
lin belgian_A = mkA (thword "เบล" "เยี่ยน") ;
lin belief_N = mkN "ความเชื่อ" | mkN "ศรัทธา" | mkN "ความเชื่อ" | mkN "ความมั่นใจ" | mkN "ความศรัทธา" | mkN "ความคิดเห็น" | mkN "ความเชื่อถือ" | mkN "ข้อบัญญัติทางศาสนา" ; -- src=panlex
lin believable_A = mkA "น่าเชื่อถือ" | mkA "เชื่อได้" | mkA "ไว้ใจได้" | mkA "น่าเชื่อถือ" | mkA "ที่น่าเชื่อถือ" ; -- src=panlex
lin believe_V = mkV "เชื่อ" | mkV "คิดว่า" | mkV "เห็นว่า" | mkV "เชื่อถือ" | mkV "เชื่อว่า" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อ" | mkV "ถือว่า" | mkV "มั่นใจ" | mkV "ศรัทธา" | mkV "เชื่อถือ" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อว่าพูดจริง" ; -- src=panlex
lin believe_V2 = mkV2 "เชื่อ" ; ---- | mkV "คิดว่า" | mkV "เห็นว่า" | mkV "เชื่อถือ" | mkV "เชื่อว่า" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อ" | mkV "ถือว่า" | mkV "มั่นใจ" | mkV "ศรัทธา" | mkV "เชื่อถือ" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อว่าพูดจริง" ; -- src=panlex
lin believe_VS = mmkVS "เชื่อ" ; ---- | mkV "คิดว่า" | mkV "เห็นว่า" | mkV "เชื่อถือ" | mkV "เชื่อว่า" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อ" | mkV "ถือว่า" | mkV "มั่นใจ" | mkV "ศรัทธา" | mkV "เชื่อถือ" | mkV "เลื่อมใส" | mkV "เชื่อมั่น" | mkV "เชื่อว่าพูดจริง" ; -- src=panlex
lin believer_N = mkN "ผู้บูชา" | mkN "ผู้นับถือ" | mkN "คนที่นับถือ" | mkN "ผู้มีศรัทธา" | mkN "ผู้มีความเชื่อ" | mkN "ผู้ที่สนับสนุน" | mkN "ผู้ที่เชื่อถือ" ; -- src=panlex
lin belike_Adv = mkAdv "น่าจะ" | mkAdv "อย่างเป็นไปได้" | mkAdv "บางที" | mkAdv "อาจจะ" | mkAdv "มีท่าทางว่า" ; -- src=panlex
lin belittling_N = mkN "การดูถูก" | mkN "คำวิจารณ์เชิงดูถูก" ; -- src=panlex
lin bell_N = mkN "ฆ้อง" | mkN "กริ่ง" | mkN "ระฆัง" | mkN "รูปกรวย" | mkN "รูประฆัง" | mkN "ระฆังเรือ" | mkN "รูปกระดิ่ง" | mkN "เสียงระฆัง" | mkN "ระฆัง" | mkN "กระดิ่ง" | mkN "ทรงระฆัง" | mkN "กริ่งประตู" | mkN "ทรงกระดิ่ง" | mkN "กริ่งสัญญาณ" | mkN "ของที่มีลักษณะคล้ายระฆัง" | mkN "เสียงร้องหรือเสียงหอนของสุนัขล่าเนื้อ" ; -- src=panlex
lin belladonna_N = mkN "เบลลาดอนนา" | mkN "ต้นเบลลาดอนนา" | mkN "พิษเบลลาดอนนา" | mkN "ต้นไม้มีพิษ" ; -- src=panlex
lin bellarmine_N = mkN "เหยือกเบลลาร์ไมน์" ; -- src=panlex
lin bellbird_N = mkN "นกเบลเบิร์ด" ; -- src=panlex
lin bellboy_N = mkN "พนักงานยกกระเป๋า" | mkN "พนักงานรับใช้ในโรงแรม" | mkN "พนักงานยกกระเป๋าในโรงแรม" ; -- src=panlex
lin belle_N = mkN "ดาว" | mkN "สาวสวย" | mkN "ดาวเด่น" | mkN "สาวสวย" | mkN "หญิงสวย" | mkN "คนสวยที่สุดในที่นั้น" ; -- src=panlex
lin bellhop_N = mkN "พนักงานยกกระเป๋า" ; -- src=panlex
lin bellicose_A = mkA "ชอบต่อสู้" | mkA "ชอบทะเลาะ" | mkA "พร้อมที่จะต่อสู้" | mkA "พร้อมที่จะทะเลาะวิวาท" ; -- src=panlex
lin belligerence_N = mkN "ความกระหายสงคราม" | mkN "การทําสงคราม" | mkN "ภาวะคล้ายสงคราม" | mkN "ลักษณะชอบต่อสู้" | mkN "ลักษณะกระหายสงคราม" ; -- src=panlex
lin belligerency_N = mkN "ความกระหายสงคราม" | mkN "ภาวะสงคราม" | mkN "ภาวะเข้าสู่การทําสงคราม" ; -- src=panlex
lin belligerent_A = mkA "คู่สงคราม" | mkA "ก้าวร้าว" | mkA "มุ่งร้าย" | mkA "ชอบสงคราม" | mkA "ทําสงคราม" | mkA "เป็นปฏิปักษ์" | mkA "ฝ่ายที่เข้าทําสงคราม" ; -- src=panlex
lin belligerent_N = mkN "นักสู้" ; -- src=panlex
lin bellow_N = mkN "เสียงอันดัง" | mkN "เสียงคําราม" ; -- src=panlex
lin bellow_V = mkV "คำราม" | mkV "ตะโกนสุดเสียง" | mkV "ตวาด" | mkV "ร้อง" | mkV "ตะคอก" | mkV "ตะโกน" | mkV "คําราม" | mkV "ตะเบ็ง" | mkV "แผดเสียง" | mkV "ส่งเสียงคํารามคล้ายวัวกระทิง" ; -- src=panlex
lin bellow_V2 = mkV2 "คำราม" ; ---- | mkV "ตะโกนสุดเสียง" | mkV "ตวาด" | mkV "ร้อง" | mkV "ตะคอก" | mkV "ตะโกน" | mkV "คําราม" | mkV "ตะเบ็ง" | mkV "แผดเสียง" | mkV "ส่งเสียงคํารามคล้ายวัวกระทิง" ; -- src=panlex
lin bellows_N = mkN "เครื่องสูบลม" | mkN "ปอด" | mkN "หีบลม" | mkN "เครื่องสูบลม" | mkN "ที่สูบลมที่ใช้มือ" | mkN "หนังหุ้มที่เป็นลูกคลื่น" ; -- src=panlex
lin bellpull_N = mkN "สายสั่นกระดิ่ง" ; -- src=panlex
lin bellwether_N = mkN "ผู้นำ" | mkN "แกนนำ" | mkN "แกะจ่าฝูงที่มีลูกกระพรวนผูกที่คอ" ; -- src=panlex
lin bellwort_N = mkN "ต้นเบลเวิร์ต" ; -- src=panlex
lin belly_N = mkN (thword "พุง") | {-pan-} mkN "พุง" | mkN "ท้อง" | mkN "พระอุทร" | mkN "พุงกะทิ" | mkN "โพรงภายใน" | mkN "ส่วนที่นูนโป่ง" | mkN "ท้องที่ป่องออกมา" | mkN "พุง" | mkN "กระเพาะ" | mkN "ส่วนนูน" | mkN "ช่องท้อง" | mkN "ส่วนท้อง" | mkN "ส่วนโป่ง" | mkN "ความอยากอาหาร" | mkN "ความปรารถนาที่จะมีหรือทําบางสิ่ง" ; -- src=panlex
lin belly_V = mkV "ป่อง" | mkV "โป่ง" | mkV "กางเต็มที่" | mkV "ทําให้โป่ง" ; -- src=panlex
lin belly_V2 = mkV2 "ป่อง" ; ---- | mkV "โป่ง" | mkV "กางเต็มที่" | mkV "ทําให้โป่ง" ; -- src=panlex
lin bellyache_N = mkN "อาการปวดท้อง" | mkN "อาการปวดท้อง" ; -- src=panlex
lin bellyache_V = mkV "บ่น" ; -- src=panlex
lin bellyflop_N = mkN "กระโดดน้ําแบบเอาด้านหน้าลง" ; -- src=panlex
lin bellyful_N = mkN "ปริมาณเท่าที่จะทนได้ที่สุด" | mkN "ปริมาณอาหารที่คนคนหนึ่งสามารถกินได้" ; -- src=panlex
lin bellylaugh_V = mkV "หัวเราะเสียงกึกก้อง" ; -- src=panlex
lin bellyless_A = mkA "ไม่มีพุง" ; -- src=panlex
lin belonging_N = mkN "ความเกี่ยวดอง" | mkN "ของประกอบ" | mkN "ญาติพี่น้อง" | mkN "ทรัพย์สมบัติ" | mkN "สิ่งของที่มีอยู่" | mkN "ความสัมพันธ์ระหว่างกัน" ; -- src=panlex
lin beloved_A = mkA "ที่รัก" | mkA "ที่รักมาก" | mkA "เป็นที่รัก" ; -- src=panlex
lin beloved_N = mkN "ที่รัก" | mkN "บุคคลอันเป็นที่รักยิ่ง" | mkN "ขวัญใจ" | mkN "ที่รัก" ; -- src=panlex
lin below_Adv = mkAdv "ใต้" | mkAdv "ต่ำกว่า" | mkAdv "ข้างล่าง" | mkAdv "ด้านล่าง" | mkAdv "ใต้" | mkAdv "ต่ํา" | mkAdv "บนนรก" | mkAdv "อยู่ใต้" | mkAdv "ข้างล่าง" | mkAdv "ต่ํากว่า" | mkAdv "อยู่ตอนใต้" | mkAdv "อยู่ข้างใต้" | mkAdv "อยู่ข้างล่าง" | mkAdv "อยู่เบื้องล่าง" | mkAdv "ไม่สมเกียรติของ" ; -- src=panlex
lin below_Prep = mkPrep "ใต้" | mkPrep "บนนรก" | mkPrep "ข้างล่าง" | mkPrep "ต่ํากว่า" | mkPrep "อยู่ข้างใต้" | mkPrep "ไม่สมเกียรติของ" ; -- src=panlex
lin belt_N = mkN "การทุบ" | mkN "การฟาด" | mkN "สายคาด" | mkN "สายพาน" | mkN "เข็มขัด" | mkN "การทุบตี" | mkN "สายกระสุน" | mkN "รัดพระองค์" | mkN "การชนอย่างแรง" | mkN "บริเวณที่ยื่นออกไป" | mkN "สายพาน" | mkN "เข็มขัด" | mkN "สายคาดเอว" | mkN "สายรัดที่นั่ง" | mkN "สายคาดแสดงตําแหน่ง" ; -- src=panlex
lin belting_N = mkN "ผ้าคาดเอว" | mkN "การตี" | mkN "วัตถุที่ใช้คาด" | mkN "สายคาดทั้งหลาย" | mkN "การหวดด้วยสายคาด" ; -- src=panlex
lin beltway_N = mkN "ถนนวงแหวน" | mkN "ถนนเลี่ยงเมือง" | mkN "ถนนวงแหวน" ; -- src=panlex
lin beluga_N = mkN "ปลาบีลูกา" ; -- src=panlex
lin belvedere_N = mkN "หอทัศนา" ; -- src=panlex
lin bemused_A = mkA "ซึ่งสับสน" ; -- src=panlex
lin ben_N = mkN "ภูเขาสูง" ; -- src=panlex
lin bench_N = mkN "ตัวสำรอง" | mkN "โต๊ะช่าง" | mkN "คณะตุลาการ" | mkN "ม้านั่งยาว" | mkN "เก้าอี้ยาว" | mkN "ผู้เล่นสำรอง" | mkN "คณะผู้พิพากษา" | mkN "โต๊ะทำงานของช่าง" | mkN "บังลังก์ผู้พิพากษา" | mkN "ม้านั่ง" | mkN "กระดานนั่ง" | mkN "ผู้พิพากษา" | mkN "โต๊ะทํางาน" | mkN "แนวหินที่นูนขึ้น" | mkN "บัลลังก์ของตุลาการ" | mkN "ที่นั่งสําหรับนักกีฬาตัวสํารอง" | mkN "แท่นที่ให้สัตว์ยืนเพื่อทําการแสดง" | mkN "ยกพื้นที่ให้สัตว์ยืนเพื่อทําการแสดง" ; -- src=panlex
lin benchmark_N = mkN "รอยสลัก" | mkN "เบ็นช์มาร์ก" | mkN "เกณฑ์มาตรฐาน" | mkN "เกณฑ์มาตรฐาน" ; -- src=panlex
lin bend_N = mkN "ลอน" | mkN "โค้ง" | mkN "การเอน" | mkN "รอยพับ" | mkN "ทางโค้ง" | mkN "ความโค้ง" | mkN "ส่วนโค้ง" | mkN "เส้นทแยงมุมจากมุมขวาบนลงซ้ายล่าง" | mkN "การโค้ง" | mkN "ทางโค้ง" ; -- src=panlex
lin bend_V = mkV "งอ" | mkV "ก้ม" | mkV "บิด" | mkV "หัก" | mkV "โค้ง" | mkV "ก้มตัว" | mkV "ค้อมตัว" | mkV "ทำให้งอ" | mkV "ทำให้โค้ง" | mkV "งอ" | mkV "ก้ม" | mkV "โค้ง" | mkV "โน้ม" | mkV "งอตัว" | mkV "หันเห" | mkV "ย่อตัว" | mkV "เหนี่ยว" | mkV "ทําให้ยอม" | mkV "ใจจดใจจ่อ" | mkV "ทําให้โค้ง" | mkV "ศิโรราบให้" | mkV "เปลี่ยนเส้นทาง" | mkV "ทําให้ค้อมหัวให้" | mkV "มีสมาธิต่องานที่ทํา" ; -- src=panlex
lin bend_V2 = mkV2 "งอ" ; ---- | mkV "ก้ม" | mkV "บิด" | mkV "หัก" | mkV "โค้ง" | mkV "ก้มตัว" | mkV "ค้อมตัว" | mkV "ทำให้งอ" | mkV "ทำให้โค้ง" | mkV "งอ" | mkV "ก้ม" | mkV "โค้ง" | mkV "โน้ม" | mkV "งอตัว" | mkV "หันเห" | mkV "ย่อตัว" | mkV "เหนี่ยว" | mkV "ทําให้ยอม" | mkV "ใจจดใจจ่อ" | mkV "ทําให้โค้ง" | mkV "ศิโรราบให้" | mkV "เปลี่ยนเส้นทาง" | mkV "ทําให้ค้อมหัวให้" | mkV "มีสมาธิต่องานที่ทํา" ; -- src=panlex
lin bend_down_V = advV OP_bend_V OP_down_Adv ; -- guess-p-verb
lin bend_over_V = advV OP_bend_V OP_over_Adv ; -- guess-p-verb
lin bend_over_backwards_V = variants {} ; -- guess-p-verb
lin bender_N = mkN "ที่ดัด" | mkN "เครื่องมือดัด" | mkN "การขว้างลูกโค้ง" | mkN "ช่วงของการดื่มอัลกอฮอล์หรือกินยามาก" ; -- src=panlex
lin bending_N = mkN "การเอน" | mkN "การทำให้โค้ง" ; -- src=panlex
lin beneath_Adv = mkAdv "ใต้" | mkAdv "ต่ำกว่า" | mkAdv "อยู่ข้างใต้" | mkAdv "อยู่ข้างล่าง" ; -- src=panlex
lin beneath_Prep = mkPrep "ภายใต้" | mkPrep "ข้างใต้" | mkPrep "อยู่ใต้" | mkPrep "เลวกว่า" | mkPrep "ข้างล่าง" | mkPrep "ต่ํากว่า" | mkPrep "ต่ําลงไป" | mkPrep "ไม่สมควร" | mkPrep "ไม่เหมาะ" | mkPrep "เสื่อมเสีย" | mkPrep "เสียศักดิ์ศร’" ; -- src=panlex
lin benedick_N = mkN "ผู้ชายที่เพิ่งสละโสด" | mkN "ผู้ชายที่เพิ่งแต่งงาน" ; -- src=panlex
lin benedictine_N = mkN "เบเนดิคไทน์" | mkN "เหล้าเบเนดิคไทน์" ; -- src=panlex
lin benediction_N = mkN "การสวดให้พร" | mkN "การขอพร" | mkN "การอวยพร" | mkN "การให้พร" | mkN "การขอบคุณ" | mkN "พิธีอวยพร" | mkN "การขอพรในตอนท้ายพิธีสวด" ; -- src=panlex
lin benedictory_A = mkA "ที่แสดงการขอพร" ; -- src=panlex
lin benefaction_N = mkN "เงินบริจาค" | mkN "กุศล" | mkN "กุศลกรรม" | mkN "การบริจาค" | mkN "การทําความดี" | mkN "คุณความดีที่ทํา" ; -- src=panlex
lin benefactor_N = mkN "ผู้อุปถัมภ์" | mkN "ผู้ช่วยเหลือ" | mkN "คนให้ความช่วยเหลือ" | mkN "ผู้ให้ความช่วยเหลือ" | mkN "ผู้สนับสนุนทางการเงิน" | mkN "อุปการี" | mkN "ผู้บริจาค" | mkN "ผู้ทํากุศล" | mkN "ผู้มีพระคุณ" | mkN "ผู้ทําความดี" | mkN "ผู้ที่สนับสนุนทางการเงิน" ; -- src=panlex
lin benefactress_N = mkN "หญิงผู้สนับสนุนทางการเงิน" ; -- src=panlex
lin benefic_A = mkA "เป็นการกุศล" | mkA "เป็นการทําความดี" | mkA "เกี่ยวกับคุณงามความดี" ; -- src=panlex
lin benefice_N = mkN "ตําแหน่งที่มีรายได้" | mkN "ตําแหน่งพระสอนศาสนา" | mkN "ที่ดินที่ให้ครอบครอง" | mkN "ตําแหน่งบาทหลวงที่มีเงินเดือน" ; -- src=panlex
lin beneficed_A = mkA "ที่มีตำแหน่งพระสอนศาสนา" ; -- src=panlex
lin beneficence_N = mkN "การกุศล" | mkN "การบริจาค" | mkN "คุณความดี" | mkN "เงินบริจาค" | mkN "การทําความดี" | mkN "สิ่งของที่บริจาค" ; -- src=panlex
lin beneficent_A = mkA "ที่ให้ความช่วยเหลือ" | mkA "ซึ่งทําความดี" | mkA "ซึ่งเป็นประโยชน์" ; -- src=panlex
lin beneficial_A = mkA "ดี" | mkA "ที่ดี" | mkA "ให้คุณ" | mkA "เป็นผลดี" | mkA "ให้ประโยชน์" | mkA "เป็นประโยชน์" | mkA "ซึ่งช่วยเหลือ" | mkA "มีสิทธิในการใช้สอย" | mkA "มีส่วนเสริมหรือช่วยเหลือ" ; -- src=panlex
lin beneficiary_N = mkN "ผู้รับประโยชน์" | mkN "ผู้ได้รับประโยชน์" | mkN "หน้าที่ผู้รับประโยชน์" | mkN "ผู้มีสิทธิพิเศษ" | mkN "ผู้รับผลประโยชน์" | mkN "ผู้รับเงินประกัน" | mkN "ผู้ได้รับประโยชน์" | mkN "ผู้รับเงินช่วยเหลือ" ; -- src=panlex
lin benefit_N = mkN "สวัสดิการ" | mkN "ผลประโยชน์" | mkN "คุณงามความดี" | mkN "ผลประโยชน์" | mkN "ข้อได้เปรียบ" | mkN "เงินช่วยเหลือ" | mkN "เงินสงเคราะห์" | mkN "เงินส่วนเพิ่ม" | mkN "เงินชดเชยการประกัน" | mkN "การแสดงเพื่อการกุศล" | mkN "การแข่งขันเพื่อการกุศล" | mkN "เงินที่ได้จากประกันชีวิต" ; -- src=panlex
lin benefit_V = mkV "ได้รับ" | mkV "มีประโยชน์" | mkV "มีผลดีต่อ" | mkV "ได้รับผลดี" | mkV "มีประโยชน์ต่อ" | mkV "ได้รับประโยชน์" ; -- src=panlex
lin benefit_V2 = mkV2 "ได้รับ" ; ---- | mkV "มีประโยชน์" | mkV "มีผลดีต่อ" | mkV "ได้รับผลดี" | mkV "มีประโยชน์ต่อ" | mkV "ได้รับประโยชน์" ; -- src=panlex
lin benevolence_N = mkN "การกุศล" | mkN "กุศลกรรม" | mkN "ความใจดี" | mkN "ของบริจาค" | mkN "เงินบริจาค" | mkN "คุณงามความดี" | mkN "ความเมตตากรุณา" ; -- src=panlex
lin benevolent_A = mkA "ที่ให้ความช่วยเหลือ" | mkA "กุศล" | mkA "กรุณา" | mkA "เมตตา" | mkA "ใจบุญ" | mkA "ชอบทําบุญ" ; -- src=panlex
lin benighted_A = mkA "มืดค่ํา" | mkA "ไม่ฉลาด" | mkA "ไม่รู้อะไร" | mkA "ซึ่งปราศจากความเข้าใจ" ; -- src=panlex
lin benign_A = mkA "ซึ่งไม่เป็นอันตรายต่อสุขภาพ" | mkA "ใจดี" | mkA "กรุณา" | mkA "ปรานี" | mkA "เมตตา" | mkA "ลักษณะดี" ; -- src=panlex
lin benignant_A = mkA "ใจดี" | mkA "กรุณาปรานี" | mkA "มีประโยชน์ต่อ" | mkA "มีอิทธิพลที่ดีต่อ" ; -- src=panlex
lin benignity_N = mkN "ความใจดี" | mkN "ความมีน้ำใจ" | mkN "กุศลกรรม" | mkN "ความใจดี" | mkN "ความกรุณา" | mkN "ความปรานี" ; -- src=panlex
lin benison_N = mkN "พร" ; -- src=panlex
lin bennet_N = mkN "ต้นเบนเน็ต" ; -- src=panlex
lin bent_A = mkA "งอ" | mkA "งอ" | mkA "คดงอ" | mkA "โค้ง" | mkA "คดโกง" | mkA "งองุ้ม" | mkA "ตกลงใจ" | mkA "โกงกิน" | mkA "จริงจัง" | mkA "แน่วแน่" | mkA "ความสนใจ" | mkA "ความโค้ง" | mkA "การเบี่ยงเบน" ; -- src=panlex
lin bent_N = mkN "หญ้า" | mkN "ทุ่งหญ้า" | mkN "ความชำนาญ" | mkN "ทักษะ" | mkN "หญ้าคา" | mkN "หญ้าแห้ง" | mkN "ความชํานาญ" | mkN "หญ้ากระด้างจําพวกหนึ่ง บางชนิดใช้เป็นอาหารสําหรับสัตว์" ; -- src=panlex
lin benthos_N = mkN "เขตเบนทอส" | mkN "สิ่งมีชีวิตใต้ทะเล" ; -- src=panlex
lin bentonite_N = mkN "เบนโทไนต์" | mkN "ดินเบนโทไนต์" ; -- src=panlex
lin bentwood_N = mkN "ไม้เบนต์วู้ด" | mkN "ไม้สําหรับทําเครื่องเรือน" ; -- src=panlex
lin benzene_N = mkN "เบนซีน" | mkN "น้ํามันเบนซิน" | mkN "น้ํามันติดไฟได้ง่ายชนิดหนึ่ง" ; -- src=panlex
lin benzine_N = mkN "เบนซีน" | mkN "น้ํามันเบนซิน" ; -- src=panlex
lin benzoate_N = mkN "เบนโซเอท" ; -- src=panlex
lin benzocaine_N = mkN "เบนโซเคน" ; -- src=panlex
lin benzodiazepine_N = mkN "เบนโซไดอะซีพีน" ; -- src=panlex
lin benzofuran_N = mkN "เบนโซฟูแรน" ; -- src=panlex
lin benzoin_N = mkN "ยาทาผิวหนังแก้อักเสบ" ; -- src=panlex
lin benzol_N = mkN "เบนซีน" ; -- src=panlex
lin benzyl_N = mkN "หมู่เบนซิล" ; -- src=panlex
lin bequest_N = mkN "มรดก" | mkN "มรดก" | mkN "การทําพินัยกรรมยกให้" | mkN "เงินหรือทรัพย์สินที่เป็นมรดก" ; -- src=panlex
lin bereaved_N = mkN "ผู้สูญเสีย" | mkN "ผู้สูญเสียคนที่ตนรัก" ; -- src=panlex
lin bereavement_N = mkN "ความโศกเศร้า" | mkN "การสูญเสียญาติหรือเพื่อสนิท" ; -- src=panlex
lin bereft_A = mkA "อกหัก" ; -- src=panlex
lin beret_N = mkN "หมวกทรงกลม" | mkN "หมวกเบเรต์" | mkN "หมวกกลม" | mkN "หมวกบาเรท์" | mkN "หมวกผ้าสักหลาดที่ไม่มีปีก" ; -- src=panlex
lin berg_N = mkN "ก้อนน้ำแข็ง" | mkN "ภูเขาน้ำแข็ง" ; -- src=panlex
lin bergamot_N = mkN "มะกรูด" | mkN "ต้นมะกรูด" | mkN "ต้นมะกรูด" ; -- src=panlex
lin beri_beri_N = mkN "โรคเหน็บชา" | mkN "โรคเหน็บชา เนื่องจากขาดแคลนวิตามินบี1" ; -- src=panlex
lin berk_N = mkN "คนโง่" | mkN "คนโง่" ; -- src=panlex
lin berkelium_N = mkN "เ่บอร์คีเลียม" | mkN "ธาตุเบอร์คีเลียม" | mkN "เลขอะตอม 97" ; -- src=panlex
lin berlin_N = mkN "รถเบอร์ลิน" | mkN "เมืองเบอร์ลินในเยอรมัน" ; -- src=panlex
lin berm_N = mkN "ชาน" | mkN "ไหล่" ; -- src=panlex
lin berry_N = mkN "เบอรี่" | mkN "เบอร์รี" | mkN "เบอร์รี่" | mkN "ลูกเบอรี่" | mkN "ผลเบอร์รี่" | mkN "ลูกเบอร์รี่" | mkN "ผลเบอร์รี่" ; -- src=panlex
lin berserk_A = mkA "โกรธมาก" ; -- src=panlex
lin berserker_N = mkN "ผู้บ้าบิ่น" ; -- src=panlex
lin berth_N = mkN "เตียง" | mkN "ตำแหน่ง" | mkN "หน้าที่" | mkN "เตียงเรือ" | mkN "ตำแหน่งหน้าที่" | mkN "ที่นอน" | mkN "ที่นอนในเรือหรือรถไฟ" ; -- src=panlex
lin berth_V = mkV "จอดเรือ" | mkV "เทียบท่า" | mkV "มัดให้แน่น" ; -- src=panlex
lin berth_V2 = mkV2 "จอดเรือ" ; ---- | mkV "เทียบท่า" | mkV "มัดให้แน่น" ; -- src=panlex
lin beryl_N = mkN "เบอรีล" | mkN "แร่เบอรีล" ; -- src=panlex
lin beryllium_N = mkN "เบริลเลียม" | mkN "ธาตุเบริลิเลียม" | mkN "เลขอะตอม 4" ; -- src=panlex
lin beseeching_A = mkA "ซึ่งอ้อนวอน" ; -- src=panlex
lin beside_Prep = mkPrep "นอกจาก" | mkPrep "ห่างจาก" | mkPrep "อยู่นอก" | mkPrep "อยู่ข้าง" | mkPrep "อยู่ใกล้" | mkPrep "เทียบกับ" | mkPrep "นอกจากนี้" | mkPrep "ไม่เกี่ยวกับ" | mkPrep "นอกเหนือไปจาก" | mkPrep "เมื่อเทียบกับ" ; -- src=panlex
lin besides_Adv = mkAdv "เช่นกัน" | mkAdv "นอกจากนี้" | mkAdv "นอกจาก" | mkAdv "อีกด้วย" | mkAdv "นอกจากนี้" | mkAdv "นอกจากนี้...แล้วยังมี" | mkAdv "มิหนําซ้ํา" | mkAdv "ยิ่งไปกว่านี้" ; -- src=panlex
lin besides_Prep = mkPrep "นอกจาก" | mkPrep "อีกด้วย" ; -- src=panlex
lin besieger_N = mkN "ผู้ห้อมล้อม" ; -- src=panlex
lin besom_N = mkN "ไม้กวาด" ; -- src=panlex
lin besotted_A = mkA "เมาหนัก" | mkA "เมาปลิ้น" | mkA "เมาหัวราน้ำ" | mkA "ซึ่งหลงใหล" ; -- src=panlex
lin bespectacled_A = mkA "ซึ่งสวมแว่นตา" | mkA "สวมแว่นตา" | mkA "ซึ่งสวมแว่นตา" ; -- src=panlex
lin bespoke_A = mkA "ซึ่งทําตามความต้องการลูกค้า" ; -- src=panlex
lin besprent_A = mkA "ซึ่งพรมหรือโรยไป ทั่วไป" ; -- src=panlex
lin best_Adv = mkAdv "ดี" | mkAdv "เหมาะสมที่สุด" ; -- src=panlex
lin best_N = mkN "ผลดีที่สุด" | mkN "การทำดีที่สุด" | mkN "คนที่ดีที่สุด" | mkN "สิ่งที่ดีที่สุด" | mkN "บุคคลที่ดีที่สุด" ; -- src=panlex
lin bestial_A = mkA "ทารุณ" | mkA "โหดร้าย" | mkA "ไร้ปัญญา" | mkA "ซึ่งไร้เหตุผล" | mkA "เหมือนสัตว์ป่า" | mkA "เกี่ยวกับสัตว์ป่า" | mkA "โหดร้ายและน่าขยะแขยง" ; -- src=panlex
lin bestiality_N = mkN "การร่วมเพศกับสัตว์" | mkN "กา่รร่วมเพศกับสัตว์" | mkN "ลักษณะสัตว์ป่า" | mkN "ความหื่นกระหายของสัตว์ป่า" | mkN "การร่วมเพศระหว่างคนกับสัตว์" | mkN "การสมสู่ระหว่างมนุษย์และสัตว์" ; -- src=panlex
lin bestowal_N = mkN "การมอบบรรดาศักดิ์" ; -- src=panlex
lin best_seller_N = mkN "หนังสือขายดี" ; -- src=panlex
lin bet_N = mkN "การพนัน" | mkN "เงินพนัน" | mkN "เงินเดิมพัน" | mkN "การพนันขันต่อ" | mkN "เงินเล่นการพนัน" | mkN "การเดา" | mkN "การพนัน" | mkN "เงินพนัน" | mkN "การคาดคะเน" | mkN "วางเดิมพัน" ; -- src=panlex
lin bet_V = mkV "พนัน" | mkV "พึ่งพา" | mkV "ท้าพนัน" | mkV "วางเดิมพัน" | mkV "พนัน" | mkV "พนันกับ" | mkV "เดิมพัน" ; -- src=panlex
lin bet_V2 = mkV2 "พนัน" ; ---- | mkV "พึ่งพา" | mkV "ท้าพนัน" | mkV "วางเดิมพัน" | mkV "พนัน" | mkV "พนันกับ" | mkV "เดิมพัน" ; -- src=panlex
lin bet_VS = mmkVS "พนัน" ; ---- | mkV "พึ่งพา" | mkV "ท้าพนัน" | mkV "วางเดิมพัน" | mkV "พนัน" | mkV "พนันกับ" | mkV "เดิมพัน" ; -- src=panlex
lin beta_N = mkN "บีตา" | mkN "อักษรตัวที่สองของพยัญชนะกรีก" ; -- src=panlex
lin betaine_N = mkN "เบทาอีน" ; -- src=panlex
lin betatron_N = mkN "เครื่องบีตาตรอน" ; -- src=panlex
lin betel_N = mkN "ใบพลู" | mkN "ใบพลู" ; -- src=panlex
lin beth_N = mkN "เบท" ; -- src=panlex
lin betimes_Adv = mkAdv "เป็นช่วงเวลาที่ดี" | mkAdv "เช้า" | mkAdv "ไม่ช้า" | mkAdv "ตรงเวลา" | mkAdv "ทันเวลา" | mkAdv "แต่แรกเริ่ม" | mkAdv "ภายในเวลาอันสั้น" ; -- src=panlex
lin betrayal_N = mkN "การทรยศ" | mkN "การคิดคดทรยศ" | mkN "การคิดไม่ซื่อ" | mkN "ซึ่งทรยศ" ; -- src=panlex
lin betrayer_N = mkN "สาย" | mkN "คนทรยศ" | mkN "คนสับปลับ" | mkN "คนกลับกลอก" | mkN "คนตลบตะแลง" | mkN "คนพูดกลับกลอก" | mkN "คนไม่รักษาคำพูด" | mkN "คนพูดอย่างทำอย่าง" ; -- src=panlex
lin betrothal_N = mkN "การหมั้น" | mkN "การสบฟันผิดปรกติ" | mkN "การหมั้น" | mkN "พิธีหมั้น" | mkN "การหมั้นหมาย" ; -- src=panlex
lin betrothedFem_N = variants {} ; ---- sense to be split
lin betrothedMasc_N = variants {} ; ---- sense to be split
lin better_A = mkA "ดีกว่า" | mkA "ดีขึ้น" | mkA "ทุเลา" | mkA "ดีกว่า" | mkA "ฟื้นตัว" | mkA "คลี่คลาย" | mkA "กระเตื้อง" | mkA "เหนือกว่า" | mkA "ค่อยยังชั่ว" | mkA "พัฒนาคุณภาพให้ดีขึ้น" | mkA "ปรับปรุงให้ดียิ่งขึ้น" ; -- src=panlex
lin better_Adv = mkAdv "ดี" | mkAdv "มาตรฐานหรือคุณภาพที่ดีกว่า" | mkAdv "เป็นที่ชอบหรือพึงพอใจมากกว่า" ; -- src=panlex
lin better_N = mkN "ดีกว่า" | mkN "นักพนัน" | mkN "คนที่มีอำนาจเหนือกว่า" | mkN "ผู้ที่ดีกว่า" | mkN "ผู้ที่เหนือกว่า" ; -- src=panlex
lin betterment_N = mkN "การเยียวยา" | mkN "การปรับปรุง" | mkN "การปรับปรุง" | mkN "สิ่งที่ดีขึ้น" | mkN "การทําให้ดีขึ้น" ; -- src=panlex
lin bettor_N = mkN "นักพนัน" | mkN "ผู้พนัน" | mkN "ผู้ขันต่อ" ; -- src=panlex
lin between_Adv = mkAdv "ในช่วง" | mkAdv "ระหว่าง" | mkAdv "ระคน" | mkAdv "เชื่อม" | mkAdv "ระหว่าง" | mkAdv "คั่นกลาง" | mkAdv "อยู่กลาง" | mkAdv "ในระหว่าง" | mkAdv "ระหว่างระยะ" | mkAdv "สัมพันธ์กับ" | mkAdv "ในระหว่างนั้น" ; -- src=panlex
lin between_Prep = ss (thword "ระ" "หว่าง") | {-pan-} mkPrep "ระคน" | mkPrep "เชื่อม" | mkPrep "ระหว่าง" | mkPrep "คั่นกลาง" | mkPrep "อยู่กลาง" | mkPrep "ในระหว่าง" | mkPrep "ระหว่างระยะ" | mkPrep "สัมพันธ์กับ" | mkPrep "สิ่งที่รวมกัน" | mkPrep "อยู่ในระหว่าง" | mkPrep "อยู่ระหว่างสิ่งสองสิ่ง" | mkPrep "กําหนดตัวเลือกระหว่างสิ่งสองสิ่ง" | mkPrep "เปรียบเทียบระหว่างสิ่งหนึ่งกับอีกสิ่งหนึ่ง" ; -- src=panlex
lin betwixt_Prep = mkPrep "ระหว่าง" ; -- src=panlex
lin bevel_N = mkN "มุมเอียง" | mkN "ไม้ทีปรับมุม" | mkN "ด้านอียง" | mkN "มุมเอียง" ; -- src=panlex
lin beverage_N = mkN "เครื่องดื่ม" | mkN "เครื่องดื่ม" | mkN "ของเหลวที่ดื่มได้" ; -- src=panlex
lin bevy_N = mkN "ฝูงนก" | mkN "กลุ่มเด็กสาว" | mkN "กลุ่ม" | mkN "ฝูงนก" | mkN "กลุ่มสตรี" | mkN "กลุ่มคนกลุ่มใหญ่" ; -- src=panlex
lin beware_V = mkV "ระวัง" | mkV "ระวัง" | mkV "ระมัดระวัง" ; -- src=panlex
lin beware_V2 = mkV2 "ระวัง" ; ---- | mkV "ระวัง" | mkV "ระมัดระวัง" ; -- src=panlex
lin bewildering_A = mkA "ทําให้สับสนงุนงง" ; -- src=panlex
lin bewilderment_N = mkN "ความงง" | mkN "ความงุนงง" | mkN "ความฉงนสนเท่ห์" ; -- src=panlex
lin bewitching_A = mkA "ซึ่งชวนให้หลงใหล" | mkA "จับใจ" | mkA "อย่างหลงใหล" ; -- src=panlex
lin bey_N = mkN "เบย์" ; -- src=panlex
lin beyond_Adv = mkAdv "ยังไกลออกไป" | mkAdv "ที่อยู่ไกลออกไป" ; -- src=panlex
lin beyond_Prep = mkPrep "พ้น" | mkPrep "หลัง" | mkPrep "โพ้น" | mkPrep "ถัดไป" | mkPrep "เหนือ" | mkPrep "ไกลจาก" | mkPrep "มากกว่า" | mkPrep "ถัดออกไป" | mkPrep "เลยออกไป" | mkPrep "เหนือกว่า" | mkPrep "อยู่ทางนั้น" ; -- src=panlex
lin bezant_N = mkN "เหรียญบีซานต์" ; -- src=panlex
lin bezel_N = mkN "กระเปาะ" | mkN "หนามเตย" | mkN "หนามเตยที่ยึดเพชรพลอย" ; -- src=panlex
lin bezique_N = mkN "พินูเคิล" ; -- src=panlex
lin bhakti_N = mkN "ภักติ" ; -- src=panlex
lin bhang_N = mkN "แบง" ; -- src=panlex
lin bialy_N = mkN "ขนมเบียลี" ; -- src=panlex
lin biannually_Adv = mkAdv "อย่างปีละ 2 ครั้ง" ; -- src=panlex
lin bias_N = mkN "เส้นเฉียง" | mkN "อคติ" | mkN "เฉียง" | mkN "ฉันทาคติ" | mkN "ลําเอียง" | mkN "เส้นทแยง" | mkN "เส้นเฉียง" | mkN "เส้นเอียง" | mkN "มีอิทธิพลต่อ" | mkN "ความโน้มเอียง" ; -- src=panlex
lin bib_N = mkN "ผ้ากันเปื้อน" | mkN "ผ้าผืนเล็กๆ ใช้ผูกใต้คางเด็กเพื่อกันเปื้อน" | mkN "ที่กันเปี้อน" | mkN "ผ้ากันเปื้อนของเด็ก" | mkN "ผ้าผูกใต้คางเด็กเพื่อกันเปื้อน" | mkN "ส่วนของผ้ากันเปื้อนที่ปกคลุมหน้าอก" ; -- src=panlex
lin bib_V = mkV "ติดเหล้า" ; -- src=panlex
lin bible_N = mkN "ไบเบิล" | mkN "คัมภีร์" | mkN "พระคัมภีร์ไบเบิล" ; -- src=panlex
lin biblical_A = mkA "เกี่ยวกับคัมภีร์ศาสนาคริสต์" | mkA "เกี่ยวกับหรือในพระคัมภีร์ไบเบิ้ล" ; -- src=panlex
lin bibliographer_N = mkN "ผู้จัดบรรณานุกรม" | mkN "ผู้เชี่ยวชาญเกี่ยวกับบรรณานุกรม" ; -- src=panlex
lin bibliography_N = mkN "บรรณานุกรม" | mkN "รายชื่อหนังสืออ้างอิง" | mkN "บรรณานุกรม" | mkN "รายชื่อหนังสือโดยสังเขป" ; -- src=panlex
lin bibliolatry_N = mkN "การบูชาคัมภีร์ไบเบิล" ; -- src=panlex
lin bibliophile_N = mkN "คนรักหนังสือ" | mkN "คนสะสมหนังสือ" | mkN "ผู้ชอบหนังสือ" | mkN "ผู้ชอบสะสมหนังสือ" | mkN "คนรักหรือสะสมหนังสือ" ; -- src=panlex
lin bibliopole_N = mkN "คนขายหนังสือมือสอง" ; -- src=panlex
lin bibulous_A = mkA "ดื่มเหล้ามากเกินไป" ; -- src=panlex
lin bicameral_A = mkA "มีสองบ้าน" | mkA "มีสองห้อง" | mkA "มี 2 กิ่งก้าน" ; -- src=panlex
lin bicarbonate_N = mkN "ไบคาร์บอเนต" | mkN "โซดาไฟ" | mkN "สารไบคาร์บอเนต" | mkN "สารโซเดียมไบคาร์บอเนต" | mkN "เกลือของคาร์บอนิคแอซิด" ; -- src=panlex
lin bicentenary_N = mkN "วาระครบรอบ 200 ปี" | mkN "ครบรอบสองร้อยปี" ; -- src=panlex
lin bicentennial_A = mkA "กินเวลาสองร้อยปี" | mkA "เกี่ยวกับหรือบรรจบครบสองร้อยปี" ; -- src=panlex
lin bicentennial_N = mkN "วาระครบรอบ 200 ปี" | mkN "ครบรอบสองร้อยปี" ; -- src=panlex
lin bicephalous_A = mkA "ที่มีสองหัว" ; -- src=panlex
lin biceps_N = mkN "กล้ามเนื้อสองหัว" | mkN "กล้ามเนื้อลูกหนูที่โคนแขน" | mkN "กล้ามเนื้อด้านหน้าของแขนส่วนบน" ; -- src=panlex
lin bichromate_N = mkN "ไดโครเมต" | mkN "ไบโครเมต" ; -- src=panlex
lin bicker_N = mkN "การโต้เถียง" ; -- src=panlex
lin bicker_V = mkV "ต่อล้อต่อเถียง" | mkV "โต้เถียง" ; -- src=panlex
lin bicolor_A = mkA "ที่มีสองสี" ; -- src=panlex
lin biconvex_A = mkA "รูปเลนส์นูนสองด้าน" ; -- src=panlex
lin bicorn_A = mkA "ที่มีสองเขา" ; -- src=panlex
lin bicycle_N = mkN "รถถีบ" | mkN "จักรยาน" | mkN "รถจักรยาน" | mkN "จักรยาน" | mkN "รถถีบสองล้อ" | mkN "รถจักรยานสองล้อ" ; -- src=panlex
lin bicycle_V = mkV "ถีบ" | mkV "ปั่น" | mkV "ขี่จักรยาน" | mkV "ถีบจักรยาน" | mkV "ปั่นจักรยาน" | mkV "ขี่รถจักรยาน" | mkV "ถีบรถจักรยาน" ; -- src=panlex
lin bicycling_N = mkN "การขี่จักรยาน" | mkN "การปั่นจักรยาน" ; -- src=panlex
lin bid_N = mkN "คำสั่ง" | mkN "การสั่ง" | mkN "การประมูล" | mkN "คำสั่งการ" | mkN "ความพยายาม" | mkN "การประกวดราคา" | mkN "การประมูล" | mkN "การให้ราคา" | mkN "การเสนอราคา" | mkN "การเรียกราคา" | mkN "จํานวนที่ให้ราคา" | mkN "ความพยายามที่จะทําบางสิ่ง" ; -- src=panlex
lin bid_V = mkV "สั่ง" | mkV "เชิญ" | mkV "เน้น" | mkV "อวยพร" | mkV "ให้พร" | mkV "ขอร้อง" | mkV "วิงวอน" | mkV "เชิญชวน" | mkV "ประสาทพร" | mkV "เรียกไพ่" | mkV "เรียกร้อง" | mkV "ประกวดราคา" | mkV "ประมูลราคา" | mkV "ประมูล ให้ราคา" | mkV "สั่งให้กระทํา" | mkV "พยายามที่จะทําให้สําเร็จ" ; -- src=panlex
lin bid_V2 = mkV2 "สั่ง" ; ---- | mkV "เชิญ" | mkV "เน้น" | mkV "อวยพร" | mkV "ให้พร" | mkV "ขอร้อง" | mkV "วิงวอน" | mkV "เชิญชวน" | mkV "ประสาทพร" | mkV "เรียกไพ่" | mkV "เรียกร้อง" | mkV "ประกวดราคา" | mkV "ประมูลราคา" | mkV "ประมูล ให้ราคา" | mkV "สั่งให้กระทํา" | mkV "พยายามที่จะทําให้สําเร็จ" ; -- src=panlex
lin biddable_A = mkA "เชื่อฟัง" | mkA "เต็มใจเชื่อฟัง" | mkA "พอที่จะสู้ราคาได้" ; -- src=panlex
lin bidder_N = mkN "ผู้ประมูล" | mkN "ผู้เสนอราคา" | mkN "ผู้ประมูล" | mkN "ผู้ให้ราคา" ; -- src=panlex
lin bidding_N = mkN "คำสั่ง" | mkN "การสั่ง" | mkN "คำสั่งการ" | mkN "หมายเรียก" | mkN "การเรียกตัว" | mkN "คําสั่ง" | mkN "การประมูล" | mkN "การเรียกมา" | mkN "การเรียกไพ่" | mkN "การเชื้อเชิญ" | mkN "การประกวดราคา" | mkN "การประมูลราคา" | mkN "การออกคําสั่ง" | mkN "ราคาที่ประมูล" ; -- src=panlex
lin bidet_N = mkN "อ่างล้างก้น" | mkN "อ่างใส่น้ําและล้างก้น" ; -- src=panlex
lin biennial_A = mkA "ในทุกสองปี" | mkA "ที่อายุสองปี" | mkA "ทุกสองปี" | mkA "อยู่ได้สองปี" | mkA "เกิดขึ้นทุกๆสองปี" ; -- src=panlex
lin biennial_N = mkN "พืชสองปี" | mkN "เหตุการณ์ที่เกิดขึ้นทุกๆสองปี" ; -- src=panlex
lin bier_N = mkN "แท่นวางโลงศพ" | mkN "ที่ตั้งศพ" | mkN "เชิงตะกอน" | mkN "โครงโลงศพ" | mkN "ที่ตั้งโลงศพ" ; -- src=panlex
lin biff_N = mkN "การชก" | mkN "การต่อย" | mkN "ตี" | mkN "ต่อย" | mkN "การชก" | mkN "การต่อย" ; -- src=panlex
lin bifilar_A = mkA "ที่มีสองเส้นใย" ; -- src=panlex
lin bifocal_A = mkA "มีสองโฟกัส" | mkA "ที่มีสองเลนส์ เลนส์หนึ่งมองใกล้ อีกเลนส์มองไกล" ; -- src=panlex
lin bifocals_N = mkN "แว่นสองเลนส์" | mkN "แว่นสองเลนส์" ; -- src=panlex
lin bifoliate_A = mkA "ที่มีสองใบ" ; -- src=panlex
lin biform_A = mkA "ซึ่งมีสองรูปทรง" ; -- src=panlex
lin bifurcate_V = mkV "แบ่งเป็นสองส่วน" ; -- src=panlex
lin bifurcate_V2 = mkV2 "แบ่งเป็นสองส่วน" ; ---- ; -- src=panlex
lin big_A = mkA (thword "ใหญ่") | {-pan-} mkA "ใหญ่" | mkA "ซึ่งโตเต็มวัย" | mkA "โต" | mkA "มาก" | mkA "ใจดี" | mkA "ใหญ่" | mkA "ขี้คุย" | mkA "ขี้โม้" | mkA "มีชื่อ" | mkA "ทรงพลัง" | mkA "ใจกว้าง" | mkA "ขึ้นชื่อ" | mkA "ยิ่งใหญ่" | mkA "ร่างใหญ่" | mkA "มีพลังมาก" | mkA "เติบโตแล้ว" | mkA "มีอํานาจสูง" | mkA "เป็นผู้ใหญ่" | mkA "มีความสําคัญหรือมีอิทธิพล" ; -- src=panlex
lin bigamist_N = mkN "ผู้จดทะเบียนสมรสซ้อน" | mkN "ผู้มีสามีหรือภรรยาสองคน" | mkN "ผู้ที่ทําผิดในฐานมีภรรยาหรือสามีสองคน" ; -- src=panlex
lin bigamous_A = variants {} ;
lin bigamy_N = mkN "การมีคู่ครองทีเดียวสองคน" ; -- src=panlex
lin bigeye_N = mkN "ปลาบิจียี" ; -- src=panlex
lin biggin_N = mkN "หมวกบิกกิน" ; -- src=panlex
lin bighead_N = mkN "ความยโส" | mkN "การถือดี" ; -- src=panlex
lin bigheaded_A = mkA "หัวสูง" | mkA "ยโส" | mkA "ถือดี" | mkA "อวดดี" ; -- src=panlex
lin bight_N = mkN "อ่าว" | mkN "เวิ้ง" | mkN "ห่วงเชือก" | mkN "อ่าวเล็ก ๆ" | mkN "ส่วนเวิ้ง" | mkN "โค้งยาวตามชายฝั่ง" | mkN "ใช้ห่วงเชือกผูกมัดไว้" ; -- src=panlex
lin bigos_N = mkN "บิกอส" ; -- src=panlex
lin bigot_N = mkN "คนหัวดื้อ" | mkN "คนหัวรั้น" | mkN "คนดื้อรั้น" | mkN "คนที่มีทิฐิมานะ" ; -- src=panlex
lin bigoted_A = mkA "มานะ" | mkA "มีทิฐิ" | mkA "หัวดื้อ" | mkA "ดื้อรั้น" | mkA "ซึ่งหัวดื้อ" ; -- src=panlex
lin bigotry_N = mkN "การดันทุรัง" | mkN "ความหัวดื้อ" | mkN "ความมีทิฐิมานะ" | mkN "การแสดงความรู้สึกหรือความเชื่อที่ไม่มีเหตุผล" ; -- src=panlex
lin bigram_N = mkN "คำอักษรสองตัว" ; -- src=panlex
lin bigwig_N = mkN "ตัวพ่อ" | mkN "ตัวแม่" | mkN "คนสําคัญมาก" | mkN "บุคคลสําคัญ" ; -- src=panlex
lin bijou_N = mkN "เพชร" | mkN "สิ่งที่เล็กๆ บอบบางและสวยงาม" ; -- src=panlex
lin bike_N = mkN (thword "จักร" "ยาน") "คัน" | {-pan-} mkN "จยย." | mkN "รถถีบ" | mkN "จักรยาน" | mkN "รถจักรยาน" | mkN "รถเครื่อง" | mkN "แมงกาไซค์" | mkN "จักรยานยนต์" | mkN "มอเตอร์ไซค์" | mkN "รถจักรยานยนต์" | mkN "รถมอเตอร์ไซค์" | mkN "จักรยานยนต์" | mkN "จักรยานสองล้อ" | mkN "จักรยานหรือรถมอเตอร์ไซค์" | mkN "ขี่จักรยานสองล้อหรือจักรยานยนต์" ; -- src=panlex
lin bike_V = mkV "ถีบ" | mkV "ปั่น" | mkV "ขี่จักรยาน" | mkV "ถีบจักรยาน" | mkV "ปั่นจักรยาน" ; -- src=panlex
lin bikini_N = mkN "ทูพีซ" | mkN "ชุดบิกินี" | mkN "ชุดอาบน้ําบิกินี" | mkN "ชุดอาบน้ําสองชิ้นของผู้หญิง" | mkN "ชุดว่ายน้ําแบบสองชิ้นของผู้หญิง" ; -- src=panlex
lin bilabial_A = mkA "ที่ใช้ริมฝีปากพูด" | mkA "เสียงที่เกิดจากการใช้ริมฝีปากทั้งสอง" ; -- src=panlex
lin bilabial_N = mkN "เสียงที่เกิดจากการใช้ริมฝีปากทั้งสอง" ; -- src=panlex
lin bilateral_A = mkA "ที่มีสองด้าน" | mkA "ทั้งคู่" | mkA "สองข้าง" | mkA "ทั้งสองด้าน" | mkA "เกี่ยวกับกลุ่มทางการเมืองสองกลุ่ม" ; -- src=panlex
lin bilateralism_N = mkN "สมมาตรด้านข้าง" ; -- src=panlex
lin bilaterality_N = mkN "สมมาตรด้านข้าง" ; -- src=panlex
lin bilberry_N = mkN "บิลเบอร์รี่" | mkN "ต้นบิลเบอร์รี่" | mkN "ยูโรเปียนบลูเบอร์รี่" | mkN "ต้นเมาน์เทนบลูเบอร์รี่" | mkN "ผลเบอร์รี่สีฟ้าเข้มทางยุโรปเหนือ" ; -- src=panlex
lin bile_N = mkN "น้ำดี" | mkN "น้ําดี" | mkN "ความโกรธ" | mkN "อารมณ์ร้าย" ; -- src=panlex
lin bilge_N = mkN "ส่วนใต้ท้องเรือ" | mkN "น้ำที่อยู่ในใต้ท้องเรือ" | mkN "ความเหลวไหล" | mkN "ส่วนที่ต่ําที่สุดของเรือ" ; -- src=panlex
lin bilgy_A = mkA "มีกลิ่นเหม็นคล้ายน้ําสกปรกใต้ท้องเรือ" ; -- src=panlex
lin bilharzia_N = mkN "โรคพยาธิ" ; -- src=panlex
lin biliary_A = mkA "ซึ่งบรรจุน้ำดี" | mkA "ส่งน้ําดี" | mkA "เกี่ยวกับน้ําดี" ; -- src=panlex
lin bilimbi_N = mkN "ตะลิงปลิง" | mkN "ต้นตะลิงปลิง" ; -- src=panlex
lin bilingual_A = mkA "ที่รู้สองภาษา" | mkA "พูดเป็นสองภาษา" | mkA "เขียนเป็นสองภาษา" | mkA "สามารถพูดหรือเขียนได้สองภาษา" ; -- src=panlex
lin bilingual_N = mkN "คนที่พูด 2 ภาษา" | mkN "คนที่สามารถพูดหรือเขียนได้สองภาษา" ; -- src=panlex
lin bilingualism_N = mkN "ความสามารถในการพูดสองภาษา" ; -- src=panlex
lin bilious_A = mkA "ซึ่งบรรจุน้ำดี" | mkA "อยากอาเจียน" | mkA "มีอารมณ์ร้าย" | mkA "เกี่ยวกับน้ําดี" | mkA "เป็นโรคตับหรือน้ําดี" | mkA "ซึ่งมีน้ําดีออกมากผิดปกติ" ; -- src=panlex
lin biliousness_N = mkN "ความบึ้งตึง" | mkN "ความหงุดหงิด" ; -- src=panlex
lin bilirubin_N = mkN "บิลิรูบิน" ; -- src=panlex
lin bill_N = mkN "บิล" | mkN "ง้าว" | mkN "จะงอย" | mkN "แบงค์" | mkN "ธนบัตร" | mkN "ประกาศ" | mkN "พร้าขอ" | mkN "ใบปลิว" | mkN "ใบเสร็จ" | mkN "การโฆษณา" | mkN "จะงอยปาก" | mkN "แฮนด์บิล" | mkN "โปสเตอร์" | mkN "ใบประกาศ" | mkN "ป้ายโฆษณา" | mkN "ร่างกฎหมาย" | mkN "เงินกระดาษ" | mkN "ใบเก็บเงิน" | mkN "ใบแจ้งหนี้" | mkN "จงอยปากของนก" | mkN "ใบเสร็จรับเงิน" | mkN "ร่างพระราชบัญญัติ" | mkN "ใบแจ้งราคาสินค้าที่ขายให้" | mkN "บิล" | mkN "ปากนก" | mkN "ธนบัตร" | mkN "ปากไก่" | mkN "รายการ" | mkN "ใบปลิว" | mkN "ปากเป็ด" | mkN "โปรแกรม" | mkN "ใบโฆษณา" | mkN "ร่างกฎหมาย" | mkN "ใบแจ้งหนี้" | mkN "ร่างรัฐธรรมนูญ" | mkN "ใบสําคัญเก็บเงิน" | mkN "ร่างพระราชบัญญัติ" ; -- src=panlex
lin bill_V = mkV "เก็บเงิน" | mkV "ติดป้ายประกาศ" | mkV "วางบิล" | mkV "แจ้งหนี้" | mkV "อธิบายหรือให้รายละเอียด" ; -- src=panlex
lin bill_V2 = mkV2 "เก็บเงิน" ; ---- | mkV "ติดป้ายประกาศ" | mkV "วางบิล" | mkV "แจ้งหนี้" | mkV "อธิบายหรือให้รายละเอียด" ; -- src=panlex
lin billabong_N = mkN "บิลลาบอง" ; -- src=panlex
lin billboard_N = mkN "แผ่นไม้" | mkN "แผ่นป้ายโฆษณา" | mkN "กระดานป้าย" | mkN "ป้ายหรือกระดานใช้สําหรับโฆษณา" ; -- src=panlex
lin billet_N = mkN "ตำแหน่ง" | mkN "หน้าที่" | mkN "โน้ตย่อ" | mkN "จดหมายสั้นๆ" | mkN "ที่พักของทหาร" | mkN "ตำแหน่งหน้าที่" | mkN "ตําแหน่งงาน" | mkN "ท่อนไม้ชิ้นเล็กๆ" | mkN "ท่อนเหล็กหรือโลหะ" | mkN "คําสั่งทางทหารเกี่ยวกับสถานที่พักชั่วคราว" ; -- src=panlex
lin billfish_N = mkN "ปลาเข็ม" | mkN "ปลาบิลล์ฟิช" | mkN "ปลานีดเดิลฟิช" ; -- src=panlex
lin billfold_N = mkN "กระเป๋าเงิน" | mkN "กระเป๋าสตางค์" | mkN "กระเป๋าใส่ธนบัตร" | mkN "กระเป๋าสตางค์" ; -- src=panlex
lin billhook_N = mkN "ง้าว" | mkN "พร้าขอ" | mkN "มีดที่ปลายเป็นตะขอคม" ; -- src=panlex
lin billiards_N = mkN "บิลเลียด" | mkN "บิลเลียด" ; -- src=panlex
lin billion_A = mkA "หนึ่งพันล้าน" | mkA "หนึ่งล้านล้าน" | mkA "พันล้าน" | mkA "หนึ่งพันล้าน" | mkA "หนึ่งล้านล้าน" ; -- src=panlex
lin billion_N = mkN "พันล้าน" | mkN "ล้านล้าน" | mkN "๑๐๐๐๐๐๐๐๐๐" | mkN "หนึ่งพันล้าน" | mkN "หนึ่งล้านล้าน" | mkN "๑๐๐๐๐๐๐๐๐๐๐๐๐" | mkN "จำนวนมากนับไม่ถ้วน" | mkN "1000000000" | mkN "1000000000000" | mkN "หนึ่งพันล้าน" | mkN "หนึ่งล้านล้าน" ; -- src=panlex
lin billionaire_N = mkN "เศรษฐีพันล้าน" | mkN "คนที่รวยมากๆ มีทรัพย์สินพันล้านดอลล่าร์หรือปอนด์" | mkN "ผู้มีเงินพันล้าน" ; -- src=panlex
lin billionth_A = mkA "ที่หนึ่งพันล้าน" ; -- src=panlex
lin billionth_N = mkN "ที่หนึ่งพันล้าน" | mkN "อันดับหนึ่งพันล้าน" | mkN "หนึ่งส่วนหนึ่งพันล้าน" ; -- src=panlex
lin billow_N = mkN "คลื่น" ; -- src=panlex
lin billow_V = mkV "รุกคืบ" | mkV "พวยพุ่ง" | mkV "พองขึ้น" | mkV "ทําให้พอง" ; -- src=panlex
lin billowy_A = mkA "เต็มไปด้วยลูกคลื่น" ; -- src=panlex
lin billy_N = mkN "แพะตัวผู้" | mkN "กระบองตำรวจ" | mkN "ตะบองของตำรวจ" | mkN "ไม้กระบองตำรวจ" | mkN "ไม้ตะบองของตำรวจ" | mkN "กระบอง" | mkN "เพื่อน" | mkN "เพื่อนทหาร" | mkN "กระบองของตํารวจ" | mkN "ไม้ตะบองของตํารวจ" ; -- src=panlex
lin bilobate_A = mkA "มีสองพู" | mkA "มีสองหยัก" ; -- src=panlex
lin bilocation_N = mkN "สองสถานที่ในเวลาเดียวกัน" ; -- src=panlex
lin biltong_N = mkN "บิลตอง" ; -- src=panlex
lin bimbo_N = mkN "หญิงสาวที่มีเสน่ห์ทางเพศแต่ไม่ฉลาด" ; -- src=panlex
lin bimester_N = mkN "ระยะเวลา 2 เดือน" | mkN "ระยะเวลา2เดือน" ; -- src=panlex
lin bimestrial_A = mkA "ในสองเดือน" | mkA "ในทุกสองเดือน" ; -- src=panlex
lin bimetal_N = mkN "โลหะคู่" ; -- src=panlex
lin bimetallic_A = mkA "โลหะคู่" ; -- src=panlex
lin bimetallism_N = mkN "มาตรฐานทวิโลหะ" ; -- src=panlex
lin bimetallistic_A = mkA "โลหะคู่" ; -- src=panlex
lin bimillennium_N = mkN "เวลาสองพันปี" | mkN "ช่วงเวลาสองพันปี" | mkN "วาระครบรอบสองพันปี" | mkN "วาระครบรอบ 2000 ปี" ; -- src=panlex
lin bimodal_A = mkA "ที่มีสองโหมด" ; -- src=panlex
lin bimolecular_A = mkA "โมเลกุลคู่" ; -- src=panlex
lin bimonthly_A = mkA "ในทุกสองเดือน" | mkA "ในทุกครึ่งเดือน" | mkA "ทุกสองสัปดาห์" | mkA "เดือนละสองครั้ง" | mkA "เกิดขึ้นทุกสองเดือน" ; -- src=panlex
lin bimonthly_Adv = mkAdv "เดือนละสองครั้ง" | mkAdv "เกิดขึ้นทุกสองเดือน" ; -- src=panlex
lin bimonthly_N = mkN "วาสารรายสองเดือน" | mkN "หนังสือรายสองเดือน" | mkN "เดือนละสองครั้ง" | mkN "เกิดขึ้นทุกสองเดือน" ; -- src=panlex
lin bimorphemic_A = mkA "ที่มีสองหน่วยคำ" ; -- src=panlex
lin bimotored_A = mkA "ซึ่งมีสองมอเตอร์" ; -- src=panlex
lin bin_N = mkN "ถัง" | mkN "เต็มถัง" | mkN "ถัง" | mkN "ลัง" | mkN "กล่อง" | mkN "ถังขยะ" ; -- src=panlex
lin binary_A = mkA "ฐานสอง" | mkA "เลขคู่" | mkA "ใช่กับไม่ใช่" | mkA "เกี่ยวกับหรือมีคู่" | mkA "เกี่ยวกับ 2" ; -- src=panlex
lin binary_N = mkN "ดาวคู่" | mkN "ดาวแฝด" | mkN "ทวิภาค" | mkN "เลขคู่" | mkN "เลขฐานสอง" | mkN "ระบบฐานสอง" ; -- src=panlex
lin binate_A = mkA "เป็นคู่" ; -- src=panlex
lin binaural_A = mkA "ซึ่งได้ยินด้วยหู" ; -- src=panlex
lin bind_N = mkN "สิ่งกีดขวาง" | mkN "สิ่งที่น่ารําคาญ" | mkN "สิ่งที่ก่อให้เกิดความไม่สะดวกสบาย" ; -- src=panlex
lin bind_V = mkV "ผูก" | mkV "พัน" | mkV "มัด" | mkV "มัีด" | mkV "ผูกพัน" | mkV "ผูกมัด" | mkV "หุ้มปก" | mkV "ติดแน่น" | mkV "สร้างพันธะ" | mkV "ทำให้ท้องผูก" | mkV "สร้างพันธะเคมี" | mkV "คาด" | mkV "ผูก" | mkV "มัด" | mkV "รัด" ; -- src=panlex
lin bind_V2 = mkV2 "ผูก" ; ---- | mkV "พัน" | mkV "มัด" | mkV "มัีด" | mkV "ผูกพัน" | mkV "ผูกมัด" | mkV "หุ้มปก" | mkV "ติดแน่น" | mkV "สร้างพันธะ" | mkV "ทำให้ท้องผูก" | mkV "สร้างพันธะเคมี" | mkV "คาด" | mkV "ผูก" | mkV "มัด" | mkV "รัด" ; -- src=panlex
lin bindable_A = mkA "ซึ่งใช้เชือกผูกได้" ; -- src=panlex
lin binder_N = mkN "แฟ้ม" | mkN "เชือก" | mkN "แฟ้มห่วงเหล็ก" | mkN "แฟ้ม" | mkN "เชือก" | mkN "ผู้ผูก" | mkN "ผู้มัด" | mkN "สายมัด" | mkN "การเย็บปก" | mkN "ยาเกาะติด" | mkN "เงินมัดจํา" | mkN "สิ่งที่ผูกมัด" | mkN "เครื่องเข้าปก" | mkN "เครื่องเย็บเล่ม" | mkN "แผ่นปะหน้าหนังสือ" | mkN "สิ่งที่ใช้ผูกหรือมัด" ; -- src=panlex
lin bindery_N = mkN "โรงงานเข้าเล่ม" | mkN "ร้านหรือโรงเข้าปกหนังสือ" | mkN "ร้านหรือโรงเย็บเล่มหนังสือ" ; -- src=panlex
lin binding_A = mkA "ที่สัมพันธ์" ; -- src=panlex
lin binding_N = mkN "ปก" | mkN "การพันแผล" | mkN "การเข้าปกหนังสือ" | mkN "ตัวล็อกรองเท้าสกี" | mkN "การผูก" | mkN "การมัด" | mkN "ผูกพัน" | mkN "สายพัน" | mkN "สายมัด" | mkN "สิ่งผูกมัด" | mkN "การทําให้ท้องผูก" | mkN "การเข้าปกหนังสือ" | mkN "การเย็บเล่มหนังสือ" ; -- src=panlex
lin bindweed_N = mkN "ไม้เลื้อย" | mkN "ต้นไม้ป่า" ; -- src=panlex
lin bine_N = mkN "ต้นฮ็อปธรรมดา" ; -- src=panlex
lin binge_N = mkN "การกินดื่ม" | mkN "ช่วงที่กินดื่มมากเกินไป" | mkN "ช่วงที่ทํากิจกรรมบางอย่างมากไป" ; -- src=panlex
lin bingo_N = mkN "เกมบิงโก" | mkN "เกมบิงโก" ; -- src=panlex
lin binnacle_N = mkN "ที่ตั้งเข็มทิศ" ; -- src=panlex
lin binocular_A = mkA "ที่ใช้สองตา" | mkA "เกี่ยวกับหรือมีสองตา" ; -- src=panlex
lin binoculars_N = mkN "กล้องสองตา" | mkN "กล้องส่องทางไกล" | mkN "กล้องส่องดูอุปรากร" | mkN "กล้องสองตา" | mkN "กล้องส่องทางไกล" ; -- src=panlex
lin binomial_A = mkA "ที่มีสองชื่อ" ; -- src=panlex
lin binomial_N = mkN "สองชื่อ" | mkN "การแสดงค่าผลบวกหรือผลต่างของสองจํานวน" ; -- src=panlex
lin binucleate_A = mkA "ที่มีสองนิวเคลียส" ; -- src=panlex
lin bioassay_N = mkN "การหาปริมาณโดยชีววิธี" ; -- src=panlex
lin biocatalyst_N = mkN "ตัวเร่งปฏิกิริยาทางชีวภาพ" ; -- src=panlex
lin biochemical_A = mkA "เกี่ยวกับชีวเคมี" | mkA "เกี่ยวกับชีวเคมี" ; -- src=panlex
lin biochemist_N = mkN "นักชีวเคมี" | mkN "นักชีวเคมี" ; -- src=panlex
lin biochemistry_N = mkN "ชีวเคมี" | mkN "ชีวเคมี" ; -- src=panlex
lin biochip_N = mkN "ไบโอชิป" ; -- src=panlex
lin bioclimatic_A = mkA "เกี่ยวกับสภาพอากาศและสิ่งมีชีวิต" ; -- src=panlex
lin biodegradable_A = mkA "สารที่" ; -- src=panlex
lin biodiversity_N = mkN "ความหลากหลายทางชีวภาพ" | mkN "การมีจํานวนสัตว์และพืชหลากหลายและจํานวนมาก" ; -- src=panlex
lin bioelectricity_N = mkN "ไฟฟ้าชีวภาพ" ; -- src=panlex
lin bioethics_N = mkN "หลักคุณธรรมทางชีวภาพ" ; -- src=panlex
lin biogenesis_N = mkN "ไบโอเจเนซิส" | mkN "ชีวสังเคราะห์" | mkN "การสร้างสิ่งมีชีวิตจากสิ่งมีชีวิตอื่น" ; -- src=panlex
lin biogeography_N = mkN "ชีวภูมิศาสตร์" ; -- src=panlex
lin biographer_N = mkN "นักเขียนชีวประวัติ" | mkN "ผู้เขียนชีวประวัติ’" | mkN "ผู้เขียนชีวประวัติของผู้อื่น" ; -- src=panlex
lin biographic_A = mkA "วรรณคดีชีวประวัติ’" | mkA "เกี่ยวกับชีวิตของบุคคล" ; -- src=panlex
lin biography_N = mkN "ประวัติ" | mkN "ชีวประวัติ" | mkN "ประวัติชีวิต" | mkN "ชีวประวัติ" | mkN "ประวัติชีวิต" | mkN "อัตชีวประวัติ" | mkN "ประวัติส่วนตัว" ; -- src=panlex
lin biohazard_N = mkN "ชีวสาร" | mkN "ความเสี่ยงทางชีวภาพ" ; -- src=panlex
lin biological_A = mkA "ทางชีววิทยา" | mkA "ทางชีววิทยา" ; -- src=panlex
lin biologism_N = mkN "ชีววิทยานิยม" | mkN "ลัทธิชีววิทยา" ; -- src=panlex
lin biologist_N = mkN "นักชีววิทยา" | mkN "นักชีววิทยา" ; -- src=panlex
lin biology_N = mkN "ชีวะ" | mkN "ชีวชาติ" | mkN "ชีววิทยา" | mkN "วิชาชีวะ" | mkN "วิทยาศาสตร์ชีวภาพ" | mkN "ชีววิทยา" ; -- src=panlex
lin bioluminescence_N = mkN "การเปล่งแสงของสิ่งมีชีวิต" ; -- src=panlex
lin biomass_N = mkN "ชีวมวล" | mkN "มวลชีวภาพ" | mkN "จํานวนสิ่งมีชีวิตต่อหน่วยพื้นที่" ; -- src=panlex
lin biome_N = mkN "ชีวนิเวศ" ; -- src=panlex
lin biomedicine_N = mkN "ชีวการแพทย์" ; -- src=panlex
lin biometrics_N = mkN "ชีวมิติ" | mkN "ชีวสถิติศาสตร์" ; -- src=panlex
lin bionic_A = mkA "ซึ่งมีส่วนของร่างกายที่เป็นอิเล็กทรอนิกส์" ; -- src=panlex
lin biophysicist_N = mkN "นักฟิสิกส์ชีววิทยา" ; -- src=panlex
lin biophysics_N = mkN "ชีวฟิสิกส์" | mkN "ศาสตร์ที่ศึกษาเกี่ยวกับการใช้วิธีการทางฟิสิกส์ศึกษาชีววิทยา" ; -- src=panlex
lin biopsy_N = mkN "การตัดเนื้อออกตรวจ" | mkN "การตัดเนื้อเยื่อไปตรวจ" | mkN "การตัดเนื้อเยื่อไปตรวจ" ; -- src=panlex
lin bioscope_N = mkN "ไบโอสโคป" | mkN "เครื่องไบโอสโคป" | mkN "โรงภาพยนตร์ไบโอสโคป" ; -- src=panlex
lin biosphere_N = mkN "ชีวภาค" | mkN "ส่วนของพื้นผิวและบรรยากาศของโลกที่มีสิ่งมีชีวิตอาศัยอยู่" ; -- src=panlex
lin biosynthesis_N = mkN "ชีวสังเคราะห์" ; -- src=panlex
lin biosystematics_N = mkN "ชีวานุกรมวิธาน" ; -- src=panlex
lin biota_N = mkN "ชีวชาติ" | mkN "ชีววิทยา" ; -- src=panlex
lin biotechnology_N = mkN "ไบโอเทค" | mkN "การยศาสตร์" | mkN "เทคโนโลยีชีวภาพ" | mkN "เทคโนโลยีชีวภาพศาสตร์" | mkN "เทคโนโลยีชีวภาพ" ; -- src=panlex
lin bioterrorism_N = mkN "การก่อการร้ายด้วยอาวุธชีวภาพ" | mkN "การก่อการร้ายโดยใช้อาวุธชีวภาพ" ; -- src=panlex
lin biotin_N = mkN "วิตามิน เอช" ; -- src=panlex
lin biotite_N = mkN "ไบโอไทต์" ; -- src=panlex
lin biotype_N = mkN "ไบโอไทป์" ; -- src=panlex
lin bioweapon_N = mkN "อาวุธชีวภาพ" ; -- src=panlex
lin bipartisan_A = mkA "ประกอบด้วยสมาชิกของสองพรรคหรือกลุ่ม" | mkA "ซึ่งรวมพรรค2พรรค" ; -- src=panlex
lin bipartite_A = mkA "ที่มีสองส่วน" | mkA "หยักลึกเป็นสองแฉก" | mkA "ที่แบ่งเป็นสองส่วน" | mkA "ประกอบด้วย หรือแบ่งออกเป็นสองส่วน" | mkA "แบบเดียวกัน 2 ฉบับ" ; -- src=panlex
lin biped_N = mkN "สัตว์สองเท้า" | mkN "สิ่งที่มีเท้า2ข้าง" ; -- src=panlex
lin bipedal_A = mkA "ซึ่งมีสองเท้า" | mkA "มีสองเท้า" ; -- src=panlex
lin bipedalism_N = mkN "การมีสองเท้า" ; -- src=panlex
lin bipinnate_A = mkA "แบบขนนกสองชั้น" ; -- src=panlex
lin bipinnatifid_A = mkA "หยักเว้าแบบขนนกสองชั้น" ; -- src=panlex
lin biplane_N = mkN "เครื่องบินปีกสองชั้น" | mkN "เครื่องบินแบบ2ปีกที่มีปีกหนึ่งอยู่เหนืออีกปีกหนึ่ง" ; -- src=panlex
lin bipolar_A = mkA "มีสองขั้ว" | mkA "เกี่ยวกับสองขั้ว" ; -- src=panlex
lin biprism_N = mkN "ปริซึมคู่" ; -- src=panlex
lin biquadrate_N = mkN "กำลังสี่" ; -- src=panlex
lin biquadratic_A = mkA "กำลังสี่" ; -- src=panlex
lin biquadratic_N = mkN "กำลังสี่" | mkN "สมการกำลังสี่" | mkN "ฟังก์ชันพหุนามกำลังสี่" ; -- src=panlex
lin birch_A = mkA "ไม้เบิร์ช" ; -- src=panlex
lin birch_N = mkN "ต้นเบิร์ช" | mkN "ไม้เบิร์ช" | mkN "ไม้เรียวต้นเบิร์ช" | mkN "ต้นไม้ชนิดหนึ่ง" ; -- src=panlex
lin bird_N = mkN (thword "นก") "ตัว" | {-pan-} mkN "นก" | mkN "วิหค" | mkN "ปักษา" | mkN "สกุณา" | mkN "ลูกแบด" | mkN "น้องนาง" | mkN "สาวน้อย" | mkN "เนื้อนก" | mkN "ลูกขนไก่" | mkN "ลูกแบดมินตัน" | mkN "เสียงโห่ร้อง" | mkN "เสียงร้องแสดงความโกรธ" | mkN "นก" | mkN "วิหค" | mkN "บุหรง" | mkN "สกุณา" | mkN "ลูกขนไก่" | mkN "สัตว์จําพวกมีปีก" | mkN "สัตว์จําพวกไก่และเป็ด" | mkN "สัตว์ปีกที่ใช้กินเป็นอาหาร" ; -- src=panlex
lin birdbath_N = mkN "อ่างนก" ; -- src=panlex
lin birdcage_N = mkN "กรงนก" | mkN "กรงนก" ; -- src=panlex
lin birdcall_N = mkN "เสียงนกร้อง" | mkN "อุปกรณ์เลียนเสียงนก" ; -- src=panlex
lin birdhouse_N = mkN "บ้านนก" ; -- src=panlex
lin birdie_N = mkN "ลูกแบด" | mkN "ลูกขนไก่" | mkN "เบอร์ดี้" | mkN "ลูกแบดมินตัน" | mkN "การได้คะแนนในกีฬากอล์ฟ" ; -- src=panlex
lin birdwatcher_N = mkN "คนดูนก" ; -- src=panlex
lin biretta_N = mkN "หมวกบาทหลวง" | mkN "หมวกเบอร์เร็ตต้า" ; -- src=panlex
lin birr_N = mkN "เบียร์" | mkN "แรง" | mkN "กําลัง" | mkN "พลังงาน" ; -- src=panlex
lin birth_N = mkN "การเกิด" | mkN "เวลาเกิด" | mkN "เด็กแรกเกิด" | mkN "การให้กำเนิด" | mkN "ความเป็นพ่อแม่" | mkN "การคลอด" | mkN "การเกิด" | mkN "การออกลูก" | mkN "ต้นกําเนิด" | mkN "จุดเริ่มต้น" | mkN "การสืบสายเลือด" ; -- src=panlex
lin birthday_N = mkN "ชาตะ" | mkN "วันเกิด" | mkN "เวลาตกฟาก" | mkN "วันประสูติ" | mkN "วันพระราชสมภพ" | mkN "วันคล้ายวันเกิด" | mkN "วันที่ลืมตาดูโลก" | mkN "วันเกิด" | mkN "วันครบรอบ" | mkN "วันคล้ายวันเกิด" ; -- src=panlex
lin birthmark_N = mkN "ปาน" | mkN "ไฝ" | mkN "ปาน" | mkN "ตําหนิบนผิวหนังแต่กําเนิด" | mkN "ปานแดงหรือน้ําตาลตั้งแต่เกิด" ; -- src=panlex
lin birthplace_N = mkN "บ้านเกิด" | mkN "สถานที่เกิด" | mkN "แหล่งกำเนิด" | mkN "ถิ่นฐานบ้านเกิด" | mkN "บ้านเกิด" | mkN "สถานที่เกิด" | mkN "แหล่งกําเนิด" ; -- src=panlex
lin birthrate_N = mkN "อัตราเกิด" | mkN "อัตราเจริญพันธุ์" ; -- src=panlex
lin birthright_N = mkN "สิทธิที่ได้รับตั้งแต่เกิด" | mkN "สิทธิที่มีมาแต่กําเนิด" | mkN "สิทธิที่ได้รับตั้งแต่เกิด" ; -- src=panlex
lin birthwort_N = mkN "ต้นเบิร์ทวอร์ต" ; -- src=panlex
lin biryani_N = mkN "บริยานี" ; -- src=panlex
lin biscuit_N = mkN "คุกกี้" | mkN "บิสกิต" | mkN "ขนมคุกกี้" | mkN "ขนมปังกรอบ" | mkN "ขนมปังกรอบ" | mkN "ขนมปังอ่อน" | mkN "ขนมปังกรอบมีรูปร่างกลมๆ" | mkN "ขนมปังชนิดหนึ่งก้อนกลมเล็ก" ; -- src=panlex
lin bise_N = mkN "ลมบีส" ; -- src=panlex
lin bisection_N = mkN "การแบ่งครึ่ง" | mkN "การแบ่งเป็นสองส่วนเท่ากัน" ; -- src=panlex
lin bisexual_A = mkA "สองเพศ" | mkA "รักสองเพศ" | mkA "กะเทย" | mkA "มีสองเพศ" | mkA "ที่มีลักษณะของทั้งสองเพศ" | mkA "ที่มีสองเพศในตัวเดียวกัน" | mkA "ที่ตอบสนองต่อทั้งเพศหญิงและเพศชาย" ; -- src=panlex
lin bisexual_N = mkN "คนรักสองเพศ" | mkN "กะเทย" | mkN "มีสองเพศ" | mkN "คนที่ตอบสนองต่อทั้งเพศหญิงและเพศชาย" ; -- src=panlex
lin bisexuality_N = mkN "การรักสองเพศ" | mkN "ไบเซ็กชวลลิตี้" ; -- src=panlex
lin bishop_N = mkN "บิชอป" | mkN "บิชอพ" | mkN "ไวน์ที่มีส่วนผสมของส้มและกานพลู" | mkN "สังฆนายก" | mkN "หัวหน้าบาทหลวง" | mkN "ตัวหมากรุกที่มีวิธีเดินทแยงมุม" | mkN "ตําแหน่งบาทหลวงที่มีอํานาจปกครองบาทหลวงอื่นๆ" ; -- src=panlex
lin bishopric_N = mkN "เขตการปกครองของเจ้าคณะ" ; -- src=panlex
lin bishopry_N = mkN "ตำแหน่งบิชอป" ; -- src=panlex
lin bismuth_N = mkN "บิสมัท" | mkN "ธาตุบิสมัท" | mkN "เลขอะตอม 83" | mkN "ธาตุบิสมัท" | mkN "ธาตุโลหะชนิดหนึ่ง" ; -- src=panlex
lin bison_N = mkN "ไบสัน" | mkN "กระทิง" | mkN "วัวกระทิง" | mkN "วัวกระทิงอเมริกา" ; -- src=panlex
lin bisque_N = mkN "บิสค์" | mkN "ซุปบิสค์" | mkN "น้ําซุปข้น" ; -- src=panlex
lin bistro_N = mkN "ร้านอาหาร" | mkN "ร้านอาหารขนาดเล็ก" ; -- src=panlex
lin bit_N = mkN "บิต" | mkN "เศษ" | mkN "ชั่วครู่" | mkN "ดอกสว่าน" | mkN "ฟันกุญแจ" | mkN "เข็มเจาะ" | mkN "ชิ้นเล็กๆ" | mkN "การแกะสลัก" | mkN "เล็กๆน้อยๆ" | mkN "อาหารคำหนึ่ง" | mkN "อาหารหนึ่งคำ" | mkN "ชิ้นส่วนเล็กๆ" | mkN "บิต" | mkN "ดอกสว่าน" | mkN "ชิ้นส่วนเล็กๆน้อยๆ" | mkN "หน่วยวัดความจุข้อมูล" | mkN "เหล็กที่ขวางปากม้าสําหรับดึงบังเหียน" ; -- src=panlex
lin bitartrate_N = mkN "ไบทาร์เตรต" ; -- src=panlex
lin bitch_N = mkN "การบ่น" | mkN "ความไม่พอใจ" | mkN "สุนัขตัวเมีย" | mkN "สุนัขเพศเมีย" | mkN "การบ่นไม่หยุด" | mkN "ผู้หญิงน่ารังเกียจ" | mkN "หญิงเลว" | mkN "แม่สุนัข" | mkN "หญิงสําส่อน" | mkN "สุนัขตัวเมีย" | mkN "หญิงร้ายที่เห็นแก่ตัว" ; -- src=panlex
lin bitch_V = mkV "บ่น" | mkV "นินทา" | mkV "บ่นว่าอย่างต่อเนื่อง" ; -- src=panlex
lin bitchy_A = mkA "ร้าย" | mkA "ซึ่งพูดให้ร้ายคนอื่น" | mkA "เกี่ยวกับสุนัขตัวเมียหรือแม่สุนัข" ; -- src=panlex
lin bite_N = mkN "การกัด" | mkN "รอยกัด" | mkN "รอยแผล" | mkN "ของว่าง" | mkN "อาหารว่าง" | mkN "ของกินเล่น" | mkN "ปลาติดเบ็ด" | mkN "แผลแมลงกัด" | mkN "การแบ่งส่วน" | mkN "ของขบเคี้ยว" | mkN "ความแสบร้อน" | mkN "การติดเหยื่อ" | mkN "ปลาฮุบเหยื่อ" | mkN "อาหารคำหนึ่ง" | mkN "อาหารหนึ่งคำ" | mkN "คำพูดอันเจ็บแสบ" | mkN "รอยกัด" | mkN "แผลที่ถูกกัด" | mkN "หนึ่งคําอาหาร" ; -- src=panlex
lin bite_V = mkV "กัด" | mkV "ต่อย" | mkV "แผดเผา" | mkV "ขบ" | mkV "กัด" | mkV "งับ" ; -- src=panlex
lin bite_V2 = mkV2 (thword "กัด") ;
lin biter_N = mkN "คนกัด" | mkN "ผู้กัด" | mkN "คนโกง" | mkN "ผู้กัด" | mkN "คนหลอกลวง" | mkN "การหลอกลวง" | mkN "สิ่งที่กัด" | mkN "สัตว์ที่ชอบกัดคน" ; -- src=panlex
lin biting_A = mkA "แสบ" | mkA "ปวดแสบ" | mkA "เผ็ดร้อน" | mkA "เสียดแทง" | mkA "เหน็บแนม" | mkA "ประชดประชัน" | mkA "กระทบกระเทียบ" | mkA "เจ็บปวดเพราะหนาวมาก" ; -- src=panlex
lin bitmap_N = mkN "ภาพบิตแมป" | mkN "การเกิดภาพจากจุดเล็กๆ" ; -- src=panlex
lin bitok_N = mkN "ไบท็อก" ; -- src=panlex
lin bitter_A = mkA "ขม" | mkA "ที่แสบสัน" | mkA "ขม" | mkA "ขมขื่น" | mkA "ขื่นขม" | mkA "ระทมใจ" | mkA "ชอกช้ํา" | mkA "ตรอมตรม" | mkA "ทุกข์ใจ" | mkA "หนาวจัด" | mkA "หนาวมาก" ; -- src=panlex
lin bitter_N = mkN "รสขม" | mkN "ความขม" | mkN "ความขื่น" | mkN "บิตเตอร์" ; -- src=panlex
lin bittercress_N = mkN "ต้นบิตเตอร์เครส" ; -- src=panlex
lin bitterish_A = mkA "ที่ค่อนข้างขม" ; -- src=panlex
lin bittern_N = mkN "นกบิตเทิร์น" | mkN "นกยาง" | mkN "ยกกาน้ํา" ; -- src=panlex
lin bitterness_N = mkN "รสขม" | mkN "ความขม" | mkN "ความขื่น" | mkN "ความขมขื่น" | mkN "ความเจ็บใจ" | mkN "อารมณ์รุนแรง" | mkN "ความแค้น" | mkN "ความขมขื่น" | mkN "ความชอกช้ํา" | mkN "ความตรอมตรม" | mkN "ความโกรธแค้น" | mkN "ความทุกข์ระทม" | mkN "ความเคียดแค้น" ; -- src=panlex
lin bitterroot_N = mkN "ต้นบิตเตอร์รูต" ; -- src=panlex
lin bitters_N = mkN "บิตเตอร์" | mkN "ยาขม" | mkN "ยาบํารุงรสขม" | mkN "ยาเจริญอาหาร" ; -- src=panlex
lin bitter_sweet_A = mkA "หวานขม" ; -- src=panlex
lin bittersweet_N = mkN "ต้นบิตเตอร์สวีต" | mkN "ต้นบิตเตอร์สวีท" ; -- src=panlex
lin bitty_A = mkA "ซึ่งเป็นชิ้นเล็กๆ" ; -- src=panlex
lin bitumastic_N = mkN "บิทูมาสติก" ; -- src=panlex
lin bitumen_N = mkN "น้ำมันดิน" | mkN "น้ํามันดิน" ; -- src=panlex
lin bituminous_A = mkA "ซึ่งบรรจุน้ํามันดิน" ; -- src=panlex
lin bivalve_A = mkA "มีสองกลีบ" | mkA "มีสองลิ้น" ; -- src=panlex
lin bivalve_N = mkN "หอยสองฝา" | mkN "หอยกาบคู่" | mkN "สัตว์ที่มีเปลือกสองส่วนแยกจากกันได้" ; -- src=panlex
lin bivouac_N = mkN "ค่าย" | mkN "ค่ายพัก" | mkN "ที่ตั้งแคมป์" | mkN "ค่ายพรรคชั่วคราว" ; -- src=panlex
lin bivouac_V = mkV "พักอยู่ในเต็นท์" ; -- src=panlex
lin biweekly_N = mkN "วารสารรายปักษ์" | mkN "หนังสือรายปักษ์" | mkN "รายปักษ์" ; -- src=panlex
lin biz_N = mkN "ธุรกิจ" ; -- src=panlex
lin bizarre_A = mkA "แปลกประหลาดมาก" ; -- src=panlex
lin blab_V = mkV "คุยจ้อ" | mkV "เผยไต๋" | mkV "เปิดเผย" | mkV "พูดไร้สาระ" | mkV "พูดเพ้อเจ้อ" | mkV "เผยเคล็ดลับ" | mkV "พูดเืพ้อเจ้อ" | mkV "พูดเรื่อยเปื่อย" | mkV "ปากบอน" | mkV "ปากพล่อย" | mkV "ปากเปราะ" | mkV "พูดพล่าม" | mkV "พูดโพล่ง" | mkV "ปากเปราะเราะราย" ; -- src=panlex
lin blab_V2 = mkV2 "คุยจ้อ" ; ---- | mkV "เผยไต๋" | mkV "เปิดเผย" | mkV "พูดไร้สาระ" | mkV "พูดเพ้อเจ้อ" | mkV "เผยเคล็ดลับ" | mkV "พูดเืพ้อเจ้อ" | mkV "พูดเรื่อยเปื่อย" | mkV "ปากบอน" | mkV "ปากพล่อย" | mkV "ปากเปราะ" | mkV "พูดพล่าม" | mkV "พูดโพล่ง" | mkV "ปากเปราะเราะราย" ; -- src=panlex
lin blabber_V = mkV "คุยจ้อ" | mkV "พูดไร้สาระ" | mkV "พูดเพ้อเจ้อ" | mkV "พูดเืพ้อเจ้อ" | mkV "พูดเรื่อยเปื่อย" ; -- src=panlex
lin blabber_V2 = mkV2 "คุยจ้อ" ; ---- | mkV "พูดไร้สาระ" | mkV "พูดเพ้อเจ้อ" | mkV "พูดเืพ้อเจ้อ" | mkV "พูดเรื่อยเปื่อย" ; -- src=panlex
lin blabbermouth_N = mkN "คนปากโป้ง" | mkN "คนปากพล่อย" | mkN "คนปากเปราะ" | mkN "คนปากพล่อย" | mkN "คนปากสว่าง" ; -- src=panlex
lin black_A = mkA (thword "ดำ") | {-pan-} mkA "สีดำ" | mkA "ผิวดำ" | mkA "ซึ่งมืดมน" | mkA "ดำ" | mkA "ดํา" | mkA "มืด" | mkA "มืดมน" | mkA "สีดํา" | mkA "ผิวดํา" | mkA "มืดมัว" | mkA "ชั่วร้าย" | mkA "สิ้นหวัง" | mkA "ไม่สว่าง" | mkA "ไร้ความหวัง" ; -- src=panlex
lin black_N = mkN "สีดำ" | mkN "ชุดดำ" | mkN "หมากดำ" | mkN "ความมืด" | mkN "ชุดสีดำ" | mkN "หมากสีดำ" | mkN "ความมืดดำ" | mkN "หมากตัวสีดำ" | mkN "สีดํา" | mkN "คนผิวดํา" ; -- src=panlex
lin blackamoor_N = mkN "นิโกร" | mkN "คนนิโกร" | mkN "คนผิวดำ" | mkN "ชาวนิโกร" | mkN "ชาวผิวดำ" | mkN "คนผิวหมึก" | mkN "นิโกร" ; -- src=panlex
lin blackberry_N = mkN "แบล็คเบอร์รี่" | mkN "ต้นแบล็กเบอร์รี่" | mkN "พืชดังกล่าว" | mkN "ผลไม้สีดําขนาดเล็ก" ; -- src=panlex
lin blackbird_N = mkN "นกกาเหว่า" | mkN "นกเดินดงสีดำ" | mkN "นกแบล็กเบิร์ด" | mkN "นกแบล็คเบิร์ด" | mkN "นกยุโรปชนิดหนึ่ง" ; -- src=panlex
lin blackboard_N = mkN "กระดานดำ" | mkN "กระดานดํา" ; -- src=panlex
lin blackbuck_N = mkN "แบล็คบัค" ; -- src=panlex
lin blackcap_N = mkN "นกแบล็คแคป" | mkN "นกแบล็กแค็ป" | mkN "นกนางนวลขอบปีกขาว" ; -- src=panlex
lin blacken_V = mkV "กลายเป็นสีดำ" | mkV "ย่างจนเกรียม" | mkV "กลายเป็นสีคล้ำ" | mkV "ทําให้เป็นสีดํา" ; -- src=panlex
lin blacken_V2 = mkV2 "กลายเป็นสีดำ" ; ---- | mkV "ย่างจนเกรียม" | mkV "กลายเป็นสีคล้ำ" | mkV "ทําให้เป็นสีดํา" ; -- src=panlex
lin blackening_N = mkN "การทำสีคล้ำ" | mkN "การเปลี่ยนเป็นสีดำ" ; -- src=panlex
lin blackface_N = mkN "ถ่านทาหน้า" ; -- src=panlex
lin blackfish_N = mkN "ปลาทอตอก" | mkN "ปลาแบล็คฟิช" ; -- src=panlex
lin blackfly_N = mkN "คุ่น" | mkN "ริ้นดำ" | mkN "แบล็คฟลาย" ; -- src=panlex
lin blackguard_N = mkN "คนเลว" | mkN "คนถ่อย" | mkN "อันธพาล" | mkN "คนไร้สกุลรุนชาติ" | mkN "ผู้ไม่ซื่อสัตย์และเลวทราม" ; -- src=panlex
lin blackhead_N = mkN "สิวหัวดำ" | mkN "รอยหรือสิวหัวดําเล็กๆ บนผิว" ; -- src=panlex
lin blackheart_N = mkN "แบล็กฮาร์ต" | mkN "แบล็กฮาร์ตเชอร์รี่" ; -- src=panlex
lin blacking_N = mkN "ครีมขัดรองเท้า" | mkN "น้ำยาขัดรองเท้า" | mkN "สิ่งที่ใช้เคลือบให้เป็นสีดํา" ; -- src=panlex
lin blackish_A = mkA "ดำ" | mkA "ดํา" | mkA "หม่น" | mkA "ค่อนข้างดํา" ; -- src=panlex
lin blackjack_N = mkN "ธงสีดำ" | mkN "ธงโจรสลัด" | mkN "แบล็กแจ็ก" | mkN "ตะบองเหล็ก" | mkN "กระบองเหล็ก" | mkN "ต้นแบล็คแจ็ค" | mkN "เกมส์ไพ่แบล็คแจ็ค" | mkN "เกมไพ่ชนิดหนึ่ง" ; -- src=panlex
lin blackleg_N = mkN "คนงานที่ไม่หยุดงานประท้วง" | mkN "คนโกง" | mkN "คนทรยศ" | mkN "คนหลอกลวง" | mkN "ผู้ยังคงทํางาน ขณะที่คนอื่นหยุดงานประท้วง" | mkN "ผู้ทําให้การสไตรค์ไร้ผลหรือหยุด" ; -- src=panlex
lin blacklist_N = mkN "บัญชีดำ" | mkN "แบล็กลิสต์" | mkN "รายชื่อคนทําผิด" | mkN "รายชื่อผู้ที่รัฐบาลไม่ยอมรับหรือต้องถูกหลีกเลี่ยง" ; -- src=panlex
lin blackmail_N = mkN "การแบล็กเมล์" | mkN "การขู่ว่าจะเปิดโปงความลับ" ; -- src=panlex
lin blackmailer_N = mkN "โจรแบล็กเมล์" | mkN "โจรขู่กรรโชกทรัพย์" | mkN "คนร้ายที่ขู่กรรโชกทรัพย์" | mkN "ผู้ขู่ว่าจะเปิดโปงความลับ" ; -- src=panlex
lin blackness_N = mkN "สีดำ" | mkN "ความมืด" | mkN "ความมืดดำ" | mkN "ความดํา" | mkN "ความมืดมน" | mkN "ความดํามืด" ; -- src=panlex
lin blackout_N = mkN "ไฟดับ" | mkN "การมืดลง" | mkN "ความมืดมน" | mkN "การสูญเงิน" | mkN "ภาวะเสียความจำ" | mkN "การหยุดออกอากาศรายการวิทยุหรือโทรทัศน์" | mkN "ไฟดับ" | mkN "การหมดสติ" | mkN "การเป็นลม" | mkN "ความมืดมน" | mkN "การปิดข่าว" | mkN "ภาวะหมดสติ" | mkN "การปิดไฟทั้งหมด" ; -- src=panlex
lin blackpoll_N = mkN "นกแบล็กโพล" ; -- src=panlex
lin blacksmith_N = mkN "ช่างเหล็ก" | mkN "ช่างตีเหล็ก" | mkN "ช่างเหล็ก" | mkN "ช่างตีเหล็ก" | mkN "คนทําเกือกม้าและใส่เกือกม้า" ; -- src=panlex
lin blacksnake_N = mkN "งูแบล็กสเน็ก" ; -- src=panlex
lin blackthorn_N = mkN "ต้นแบล็กทอร์น" | mkN "พุ่มไม้มีหนาม" ; -- src=panlex
lin blacktop_N = mkN "วัสดุราดผิวถนน" ; -- src=panlex
lin blackwater_N = mkN "ไข้น้ำดำ" | mkN "ไข้ปัสสาวะดำ" | mkN "อาการปัสสาวะเป็นสีดำ" ; -- src=panlex
lin blackwood_N = mkN "ต้นแบล็ควู้ด" | mkN "ไม้แบล็กวู้ด" ; -- src=panlex
lin bladder_N = mkN "ถุง" | mkN "ถุงลม" | mkN "ถุง" | mkN "ยางใน" | mkN "กระเพาะปัสสาวะ" ; -- src=panlex
lin bladderpod_N = mkN "ต้นอินเดียนโทแบ็กโก" ; -- src=panlex
lin bladderwort_N = mkN "ต้นแบลดเดอร์เวิร์ต" ; -- src=panlex
lin bladdery_A = mkA "เหมือนกระเพาะปัสสาวะ" ; -- src=panlex
lin blade_N = mkN "ดาบ" | mkN "ใบพัด" | mkN "ใบมีด" | mkN "กระบี่" | mkN "แผ่นใบ" | mkN "ใบหญ้า" | mkN "พระขรรค์" | mkN "เนื้อวัวช่วงบ่า" | mkN "อวัยวะที่มัลักษณะแบน" | mkN "ใบมีดของรองเท้าสเก็ต" | mkN "ชายหนุ่มผู้มีความมั่นใจในตนเอง" | mkN "ใบ" | mkN "ดาบ" | mkN "คมมีด" | mkN "ใบพัด" | mkN "ใบมีด" | mkN "นักเลง" | mkN "ใบจักร" | mkN "ใบพายุ" | mkN "ใบหญ้า" | mkN "ใบพัดลม" | mkN "ใบกังหัน" | mkN "กระดูกหัวไหล่" | mkN "ใบไม้ที่มีลักษณะเรียวยาว โดยเฉพาะใบหญ้า" ; -- src=panlex
lin bladed_A = mkA "ใบ" | mkA "คมบาง" | mkA "คล้ายใบมีด" ; -- src=panlex
lin blae_A = mkA "ที่มีสีเบล" ; -- src=panlex
lin blaeberry_N = mkN "ต้นบิลเบอร์รี่" ; -- src=panlex
lin blah_N = mkN "คำพูดสวยหรู" | mkN "คำพูดไร้สาระ" | mkN "การกล่าวเยินยอ" ; -- src=panlex
lin blahs_N = mkN "คำพูดเหลวไหล" ; -- src=panlex
lin blame_N = mkN "การตำหนิ" | mkN "การกล่าวโทษ" | mkN "การตำหนิติเตียน" | mkN "หา" | mkN "โทษ" | mkN "คำกล่าวหา" | mkN "การรับผิดชอบต่อสิ่งไม่ดีที่เกิดขึ้น" ; -- src=panlex
lin blame_V = mkV "ตำหนิ" | mkV "จับผิด" | mkV "ตําหนิ" | mkV "ว่ากล่าว" | mkV "รับผิดชอบต่อสิ่งไม่ดีที่เกิดขึ้น" ; -- src=panlex
lin blame_V2 = mkV2 "ตำหนิ" ; ---- | mkV "จับผิด" | mkV "ตําหนิ" | mkV "ว่ากล่าว" | mkV "รับผิดชอบต่อสิ่งไม่ดีที่เกิดขึ้น" ; -- src=panlex
lin blameless_A = mkA "ซึ่งไร้มลทิน" ; -- src=panlex
lin blameworthiness_N = mkN "การมีความผิด" ; -- src=panlex
lin blameworthy_A = mkA "ควรถูกตําหนิ" | mkA "ซึ่งควรตําหนิ" ; -- src=panlex
lin blanc_N = mkN "ซอสขาว" ; -- src=panlex
lin blanch_V = mkV "หัวหด" | mkV "ลวกผัก" | mkV "หน้าซีด" | mkV "หน้าซีดเผือด" | mkV "ซีดสลด" ; -- src=panlex
lin blanch_V2 = mkV2 "หัวหด" ; ---- | mkV "ลวกผัก" | mkV "หน้าซีด" | mkV "หน้าซีดเผือด" | mkV "ซีดสลด" ; -- src=panlex
lin blancmange_N = mkN "เบลอมองจ์" | mkN "ขนมหวานเย็นเหมือนเยลลี่" ; -- src=panlex
lin bland_A = mkA "จืด" | mkA "น่าเบื่อ" | mkA "ซึ่งไม่มีรสชาติ" | mkA "บรรเทา" | mkA "ธรรมดา ๆ" | mkA "นิ่มนวล" | mkA "อุเบกขา" | mkA "อ่อนโยน" | mkA "ขาดรสชาติ" | mkA "ไร้อารมณ์" | mkA "ไม่กระตุ้น" | mkA "ไม่มีรสชาติ" | mkA "ที่ไม่น่าสนใจ" | mkA "ไม่ระคายเคือง" ; -- src=panlex
lin blandishment_N = mkN "การเจรจา" | mkN "การพูดจาหลอกล่อ" | mkN "การประจบเอาใจ" ; -- src=panlex
lin blandness_N = mkN "ความนุ่มนวล" | mkN "ความขาดรสชาติ" | mkN "การไม่มีอารมณ์ความรู้สึก" | mkN "การไม่มีอารมณ์ความรู้สึก" ; -- src=panlex
lin blank_A = mkA "ว่าง" | mkA "เปล่า" | mkA "ซึ่งว่างเปล่า" | mkA "เฉย" | mkA "ว่าง" | mkA "เปล่า" | mkA "ว่างเปล่า" | mkA "ไม่แสดงความรู้สึก" ; -- src=panlex
lin blank_N = mkN "ช่องไฟ" | mkN "ปืนหลอก" | mkN "ช่องว่าง" | mkN "เว้นวรรค" | mkN "ชิ้นส่วนเต็มเติม" | mkN "ที่ว่าง" | mkN "ช่องว่าง" | mkN "ความว่างเปล่าของจิตใจ" ; -- src=panlex
lin blanket_N = mkN "ผ้าห่ม" | mkN "สิ่งปกคลุม" | mkN "พรม" | mkN "คลุม" | mkN "ยุ่ง" | mkN "ดับไฟ" | mkN "ผ้านวม" | mkN "ผ้าผวย" | mkN "ผ้าห่ม" | mkN "ขัดขวาง" | mkN "ผ้าไหมพรม" | mkN "ผ้าขนสัตว์" | mkN "ผ้าห่มขนสัตว์" | mkN "สิ่งที่ปกคลุม" ; -- src=panlex
lin blanquillo_N = mkN "ปลาแบลนควิลโล" ; -- src=panlex
lin blare_N = mkN "การแผดเสียง" | mkN "เสียงร้องดังๆ" | mkN "เสียงแตรในพิธี" | mkN "เสียงดัง" ; -- src=panlex
lin blare_V = mkV "แผดเสียง" | mkV "ส่งเสียงดัง" | mkV "ส่งเสียงหวูด" | mkV "แผดเสียงก้อง" | mkV "ส่งเสียงดัง" ; -- src=panlex
lin blare_V2 = mkV2 "แผดเสียง" ; ---- | mkV "ส่งเสียงดัง" | mkV "ส่งเสียงหวูด" | mkV "แผดเสียงก้อง" | mkV "ส่งเสียงดัง" ; -- src=panlex
lin blarney_N = mkN "การประจบ" | mkN "ประจบสอพลอ" | mkN "การพูดยกยออย่างไม่จริงใจ" ; -- src=panlex
lin blase_A = mkA "เบื่อหน่ายต่อชีวิต" | mkA "เบื่อหน่ายในการเสพย์ความสุข" ; -- src=panlex
lin blaspheme_V = mkV "สบถ" | mkV "กล่าวถ้อยคําหยาบคาย" | mkV "พูดดูหมิ่นหรือสบประมาทศาสนา" | mkV "พูดดูหมิ่นศาสนาหรือสิ่งศักดิ์สิทธ์" ; -- src=panlex
lin blaspheme_V2 = mkV2 "สบถ" ; ---- | mkV "กล่าวถ้อยคําหยาบคาย" | mkV "พูดดูหมิ่นหรือสบประมาทศาสนา" | mkV "พูดดูหมิ่นศาสนาหรือสิ่งศักดิ์สิทธ์" ; -- src=panlex
lin blasphemer_N = mkN "คนพูดลบหลู่" ; -- src=panlex
lin blasphemous_A = mkA "หยาบคาย" | mkA "อัปมงคล" | mkA "อันหยาบคาย" | mkA "ซึ่งดูหมิ่น" | mkA "ซึ่งสบประมาทหรือดูหมิ่นศาสนา" | mkA "เกี่ยวกับการดูหมิ่นเหยียดหยาม" ; -- src=panlex
lin blasphemy_N = mkN "การลบหลู่" | mkN "การดูหมิ่นศาสนา" | mkN "การดูหมิ่น" | mkN "การสบประมาท" | mkN "การสบประมาทศาสนา" | mkN "การสบประมาทหรือการดูหมิ่น" ; -- src=panlex
lin blast_N = mkN "การโจมตี" | mkN "ลมพัดแรง" | mkN "ลูกยิงนก" | mkN "การระเบิด" | mkN "เสียงโครม" | mkN "การแผดเสียง" | mkN "ช่วงเวลาดีๆ" | mkN "เสียงดังมาก" | mkN "ช่วงเวลาที่ดี" | mkN "เสียงดังระเบิด" | mkN "ประสบการณ์ที่ดี" | mkN "การระเบิด" ; -- src=panlex
lin blast_V = mkV "ยิง" | mkV "ระเบิด" | mkV "ตีเต็มแรง" | mkV "ตีสุดแรงเกิด" | mkV "ทำให้หมดประโยชน์" | mkV "วิจารณ์อย่างหยาบคาย" | mkV "วิจารณ์อย่างสาดเสียเทเสีย" | mkV "ระเบิด" ; -- src=panlex
lin blast_V2 = mkV2 "ยิง" ; ---- | mkV "ระเบิด" | mkV "ตีเต็มแรง" | mkV "ตีสุดแรงเกิด" | mkV "ทำให้หมดประโยชน์" | mkV "วิจารณ์อย่างหยาบคาย" | mkV "วิจารณ์อย่างสาดเสียเทเสีย" | mkV "ระเบิด" ; -- src=panlex
lin blastema_N = mkN "เซลล์บลาสทีมา" ; -- src=panlex
lin blastocyst_N = mkN "บลาสโทซิสต์" ; -- src=panlex
lin blastocyte_N = mkN "บลาสโตซีต" ; -- src=panlex
lin blastoderm_N = mkN "บลาสโทเดิร์ม" ; -- src=panlex
lin blast_off_N = mkN "การปล่อยยานอวกาศ" ; -- src=panlex
lin blastomere_N = mkN "บลาสโทเมียร์" | mkN "เซลล์บลาสโทเมียร์" ; -- src=panlex
lin blastopore_N = mkN "บลาสโทพอร์" ; -- src=panlex
lin blastula_N = mkN "บลาสทูลา" ; -- src=panlex
lin blatancy_N = mkN "ความชัดแจ้ง" | mkN "ความโจ่งแจ้ง" ; -- src=panlex
lin blatant_A = mkA "ห้าว" | mkA "บาดตา" | mkA "โออวด" | mkA "ชัดเจน" | mkA "ชัดแจ้ง" | mkA "ครึกโครม" | mkA "โจ่งแจ้ง" ; -- src=panlex
lin blather_V = mkV "พูดไร้สาระ" | mkV "พูดเรื่อยเปื่อย" | mkV "พูดโง่ๆ หรือเรื่อยเจื้อย" ; -- src=panlex
lin blaze_N = mkN "นรก" | mkN "ความร้อน" | mkN "ความสว่าง" | mkN "เครื่องหมาย" | mkN "ความปั่นป่วน" | mkN "ความสว่างสุกใส" | mkN "เปลวไฟ" ; -- src=panlex
lin blaze_V = mkV "ยิงซ้ำ" | mkV "ลุกโพลง" | mkV "สว่างโร่" | mkV "เร็วเหมือนไฟลุก" | mkV "รวดเร็วเหมือนไฟลุก" | mkV "ลุก" | mkV "พลุ่ง" | mkV "ลุกโพลง" | mkV "ส่องแสงจ้า" ; -- src=panlex
lin blaze_V2 = mkV2 "ยิงซ้ำ" ; ---- | mkV "ลุกโพลง" | mkV "สว่างโร่" | mkV "เร็วเหมือนไฟลุก" | mkV "รวดเร็วเหมือนไฟลุก" | mkV "ลุก" | mkV "พลุ่ง" | mkV "ลุกโพลง" | mkV "ส่องแสงจ้า" ; -- src=panlex
lin blazer_N = mkN "เสื้อกีฬา" | mkN "เสื้อแจ็กเก็ต" | mkN "ผู้ประกาศ" | mkN "ผู้แพร่กระจาย" | mkN "สิ่งที่ลุกโพลง" | mkN "สิ่งที่ลุกสว่างโชติช่วง" ; -- src=panlex
lin blazon_N = mkN "อาร์ม" | mkN "อาร์มแขน" | mkN "ธง" | mkN "ตรา" ; -- src=panlex
lin blazonry_N = mkN "อาร์ม" | mkN "อาร์มแขน" | mkN "ตรา" | mkN "เครื่องตรา" | mkN "วิธีการทําเครื่องหมาย" | mkN "การประดับประดาอย่างฉูดฉาด" ; -- src=panlex
lin bleach_N = mkN "การฟอก" | mkN "สารฟอกสี" | mkN "ความขาวซีด" ; -- src=panlex
lin bleach_V = mkV "ฟอก" | mkV "ฟอกขาว" | mkV "ฟอก" | mkV "ฟอกสี" | mkV "ฟอกขาว" ; -- src=panlex
lin bleach_V2 = mkV2 "ฟอก" ; ---- | mkV "ฟอกขาว" | mkV "ฟอก" | mkV "ฟอกสี" | mkV "ฟอกขาว" ; -- src=panlex
lin bleacher_N = mkN "พนักงานซักฟอก" | mkN "คนฟอกให้ขาว" | mkN "เครื่องฟอกให้ขาว" | mkN "อัฒจันทร์กลางแจ้ง" | mkN "ภาชนะที่ใช้ในการฟอกให้ขาว" ; -- src=panlex
lin bleachers_N = mkN "ที่นั่งราคาถูกในการดูกีฬา" ; -- src=panlex
lin bleak_A = mkA "ซึ่งมืดมน" | mkA "มืดมัว" | mkA "ไม่ชัด" | mkA "มีลมพัด" | mkA "ยะเยือก" | mkA "หนาวเย็น" | mkA "อ้างว้าง" | mkA "เดียวดาย" | mkA "เลือนลาง" | mkA "เศร้าระทม" | mkA "โดยหมดหวัง" | mkA "โดยสิ้นหวัง" | mkA "ไร้ความหวัง" | mkA "เปล่าเปลี่ยว" ; -- src=panlex
lin bleakness_N = mkN "ความสิ้นหวัง" ; -- src=panlex
lin bleary_A = mkA "ไม่ชัด" | mkA "พร่ามัว" | mkA "ไม่ชัดเจน" | mkA "เหนื่อยอ่อน" | mkA "มองเห็นไม่ชัดเจนเพราะง่วง" ; -- src=panlex
lin bleat_N = mkN "เสียงแกะ" | mkN "เสียงแพะ" | mkN "แกะหรือลูกวัว" | mkN "เสียงร้องของแพะ" | mkN "เสียงพูดหรือบ่นเบาๆ" ; -- src=panlex
lin bleat_V = mkV "ร้องแบะๆ" | mkV "พูดหรือบ่นเบาๆ" ; -- src=panlex
lin bleat_V2 = mkV2 "ร้องแบะๆ" ; ---- | mkV "พูดหรือบ่นเบาๆ" ; -- src=panlex
lin bleed_V = mkV "ถ่าย" | mkV "รีดไถ" | mkV "ตกเลือด" | mkV "เลือดออก" | mkV "เลือดไหล" | mkV "ถ่ายเลือด" | mkV "เลือดตกยางออก" | mkV "ตกใน" | mkV "ตกเลือด" | mkV "เลือดออก" | mkV "ถ่ายเลือด" | mkV "นําเงินจํานวนมากไปใช้อย่างไม่ถูกต้อง" ; -- src=panlex
lin bleed_V2 = mkV2 "ถ่าย" ; ---- | mkV "รีดไถ" | mkV "ตกเลือด" | mkV "เลือดออก" | mkV "เลือดไหล" | mkV "ถ่ายเลือด" | mkV "เลือดตกยางออก" | mkV "ตกใน" | mkV "ตกเลือด" | mkV "เลือดออก" | mkV "ถ่ายเลือด" | mkV "นําเงินจํานวนมากไปใช้อย่างไม่ถูกต้อง" ; -- src=panlex
lin bleed_VS = mmkVS "ถ่าย" ; ---- | mkV "รีดไถ" | mkV "ตกเลือด" | mkV "เลือดออก" | mkV "เลือดไหล" | mkV "ถ่ายเลือด" | mkV "เลือดตกยางออก" | mkV "ตกใน" | mkV "ตกเลือด" | mkV "เลือดออก" | mkV "ถ่ายเลือด" | mkV "นําเงินจํานวนมากไปใช้อย่างไม่ถูกต้อง" ; -- src=panlex
lin bleeding_N = mkN "การตกเลือด" | mkN "อาการตกเลือด" | mkN "การมีเลือดออกมาก" | mkN "การหลั่งเลือด" ; -- src=panlex
lin bleep_N = mkN "เสียงบี๊บ" | mkN "เสียงตี๊ดๆ" | mkN "เสียงบี๊ปๆ" | mkN "เสียงสูงสั้นๆ เกิดจากเครื่องอิเลกทรอนิกส์" ; -- src=panlex
lin bleep_V = mkV "ทําเสียงแหลมสั้นๆ" ; -- src=panlex
lin blemish_N = mkN "รอย" | mkN "ตำหนิ" | mkN "รอยตำหนิ" | mkN "รอย" | mkN "ราคี" | mkN "มลทิน" | mkN "ตําหนิ" | mkN "ความมัวหมอง" ; -- src=panlex
lin blench_V = mkV "หัวหด" | mkV "หน้าซีด" | mkV "หน้าซีดเผือด" | mkV "ถอยหนีเพราะความกลัว" | mkV "ถอยหลังเพราะความกลัว" ; -- src=panlex
lin blend_N = mkN "การผสม" | mkN "คำประสม" | mkN "การผสมผสาน" | mkN "การผสม" | mkN "ส่วนผสม" | mkN "คําประสม" | mkN "การรวมตัว" ; -- src=panlex
lin blend_V = mkV "ผสม" | mkV "มิกซ์" | mkV "ผสมผสาน" | mkV "ผสมกลมกลืน" | mkV "ผสมเข้าด้วยกัน" | mkV "ผสม" | mkV "รวมกัน" | mkV "ผสมให้เข้ากัน" ; -- src=panlex
lin blend_V2 = mkV2 "ผสม" ; ---- | mkV "มิกซ์" | mkV "ผสมผสาน" | mkV "ผสมกลมกลืน" | mkV "ผสมเข้าด้วยกัน" | mkV "ผสม" | mkV "รวมกัน" | mkV "ผสมให้เข้ากัน" ; -- src=panlex
lin blender_N = mkN "เบลนเดอร์" | mkN "เครื่องปั่น" | mkN "ผู้ผสม" | mkN "สิ่งเจือปน" | mkN "เครื่องปั่นผสม" | mkN "ตัวผสมเครื่องผสม" | mkN "ผู้ผสมหรือเครื่องปั่น" ; -- src=panlex
lin blenny_N = mkN "ปลาเบลนนี" ; -- src=panlex
lin blepharospasm_N = mkN "ตาปิดเกร็ง" ; -- src=panlex
lin blessedly_Adv = mkAdv "อย่างมีโชค" ; -- src=panlex
lin blessedness_N = mkN "ความสุข" ; -- src=panlex
lin blessing_N = mkN "บุญกุศล" | mkN "การอนุมัติ" | mkN "การสวดให้พร" | mkN "การเห็นด้วย" | mkN "คุณประโยชน์" | mkN "การสวดขอบคุณ" | mkN "การขอบคุณพระเจ้า" | mkN "การบูชา" | mkN "ของขวัญ" | mkN "การให้พร" | mkN "ความกรุณา" | mkN "ผลประโยชน์" | mkN "การสวดให้พร" | mkN "การเห็นด้วย" | mkN "การสรรเสริญบารมี" | mkN "สิ่งที่ทําให้ดีใจ" | mkN "การทําให้ศักดิ์สิทธิ์" | mkN "สิ่งทําให้โชคดีหรือมีความสุข" | mkN "สิ่งที่ทําให้ผ่อนคลายหรือบรรเทาเบาบาง" ; -- src=panlex
lin blether_N = mkN "การพูดจาเหลวไหล" ; -- src=panlex
lin bleu_N = mkN "บลูชีส" ; -- src=panlex
lin blewits_N = mkN "เ้ห็ดบลิววิตส์" ; -- src=panlex
lin blight_N = mkN "โรคพืช" | mkN "การเสื่อมสลาย" | mkN "การผุพัง" | mkN "การพังทลาย" | mkN "ความเสียหาย" | mkN "การเสื่อมสลาย" | mkN "ความยากลําบาก" ; -- src=panlex
lin blighter_N = mkN "พ่อ" | mkN "หนุ่ม" | mkN "พ่อหนุ่ม" | mkN "เจ้าหนุ่ม" | mkN "คําเรียกคนน่าเห็นใจหรือน่าอิจฉา" ; -- src=panlex
lin blimp_N = mkN "เครื่องบินเล็ก" | mkN "เรือเหาะ" | mkN "ผู้ที่แก่กว่า โดยเฉพาะในกองทัพ" | mkN "เรือเหาะลําเล็ก" ; -- src=panlex
lin blind_A = mkA "ซึ่งมองไม่เห็น" | mkA "ตัน" | mkA "บอด" | mkA "ปิด" | mkA "มองไม่เห็น" | mkA "ขาดการเตรียมพร้อม" ; -- src=panlex
lin blind_N = mkN "ฉาก" | mkN "บังตา" | mkN "คนตาบอด" | mkN "ฉากกั้น" | mkN "ที่ซ่อน" | mkN "กลุ่มคนตาบอด" | mkN "ผู้มีดวงตาพิการ" | mkN "ผู้พิการทางสายตา" | mkN "บังตา" | mkN "ที่ซ่อน" | mkN "ม่านบังตา" ; -- src=panlex
lin blindfold_N = mkN "ผ้าปิดตา" | mkN "ผ้าผูกตา" | mkN "ผ้าปิดตา" | mkN "สิ่งที่ใช้ปิดตา" ; -- src=panlex
lin blindness_N = mkN "ความบอด" | mkN "การมองไม่เห็น" | mkN "การสูญเสียสายตา" ; -- src=panlex
lin blini_N = mkN "แพนเค้กแบบรัสเซีย" ; -- src=panlex
lin blink_N = mkN "การกะพริบตา" | mkN "การกะพริบตา" ; -- src=panlex
lin blink_V = mkV "บีบน้ำตา" | mkV "กระพริบตา" | mkV "เป็นประกาย" | mkV "เปล่งประกาย" | mkV "พริบ" | mkV "กะพริบตา" | mkV "กะพริบไล่น้ําตา" | mkV "กระพริบตาเพื่อเอาบางสิ่งออกมา" ; -- src=panlex
lin blink_V2 = mkV2 "บีบน้ำตา" ; ---- | mkV "กระพริบตา" | mkV "เป็นประกาย" | mkV "เปล่งประกาย" | mkV "พริบ" | mkV "กะพริบตา" | mkV "กะพริบไล่น้ําตา" | mkV "กระพริบตาเพื่อเอาบางสิ่งออกมา" ; -- src=panlex
lin blinker_N = mkN "ไฟกะพริบ" | mkN "ไฟเลี้ยว" | mkN "เครื่องปิดตาม้า" | mkN "แว่นตา" | mkN "กลบเกลื่อน" | mkN "ผู้กะพริบตา" | mkN "ผู้ปิดตาม้า" | mkN "ผู้กระพริบตา" | mkN "ตะเกียงสัญญาณ" | mkN "สัญญาณบอกเหตุ" | mkN "เครื่องปิดตาม้า" | mkN "ไฟกะพริบให้สัญญาณว่าจะเลี้ยวรถ" ; -- src=panlex
lin blinks_N = mkN "ต้นชิกวีดน้ำ" ; -- src=panlex
lin blintz_N = mkN "บลินซ์" ; -- src=panlex
lin blip_N = mkN "การชะงัก" | mkN "ภาพบนจอเรดาร์" | mkN "สัญลักษณ์" | mkN "เสียงสั้นที่ดังชัด" | mkN "เสียงขาดหายไประหว่างรายการโทรทัศน์" | mkN "ปัญหาที่เกิดขึ้นชั่วคราวก่อนจะดีขึ้น" | mkN "จุดและเสียงบนจอเรดาร์เพื่อบอกตําแหน่งบางสิ่ง" | mkN "เสียงแหลมสั้นที่เกิดจากเครื่องมือทางอิเล็กโทรนิกส์" ; -- src=panlex
lin bliss_N = mkN "ความสุข" | mkN "สวรรค์" | mkN "ความสุขบนสวรรค์" | mkN "ความสุขอันล้นพ้น" | mkN "ความสุขสําราญอันสุดยอด" ; -- src=panlex
lin blissful_A = mkA "ผาสุก" | mkA "มีความสุข" ; -- src=panlex
lin blister_N = mkN "ตุ่มพอง" | mkN "ฟอง" | mkN "เป็นฟอง" | mkN "แผลผุพอง" | mkN "เม็ดพุพอง" | mkN "ทําให้เม็ดพุพอง" | mkN "ยารักษาโรคผิวหนังพุพอง" ; -- src=panlex
lin blister_V = mkV "พอง" | mkV "ขึ้นตุ่มพอง" | mkV "บวม" | mkV "ปูด" | mkV "พอง" | mkV "โป่ง" | mkV "เป็นตุ่ม" | mkV "ทําให้เกิดฟองอากาศที่เกิดบนสีที่ทาหรือบนยาง" ; -- src=panlex
lin blister_V2 = mkV2 "พอง" ; ---- | mkV "ขึ้นตุ่มพอง" | mkV "บวม" | mkV "ปูด" | mkV "พอง" | mkV "โป่ง" | mkV "เป็นตุ่ม" | mkV "ทําให้เกิดฟองอากาศที่เกิดบนสีที่ทาหรือบนยาง" ; -- src=panlex
lin blithe_A = mkA "ร่าเริง" | mkA "สะเพร่า" | mkA "รื่นเริง" | mkA "สนุกสนาน" | mkA "แช่มชื่น" | mkA "ไม่ระวัง" | mkA "บันเทิงใจ" | mkA "อิสระเสรี" | mkA "ปราศจากสติ" | mkA "ไม่ไตร่ตรอง" ; -- src=panlex
lin blitz_N = mkN "ตำแหน่งบลิทซ์" | mkN "ยุทธการสายฟ้าแลบ" | mkN "การทำสงครามแบบสายฟ้าแลบ" | mkN "การโจมตีทางอากาศอย่างรวดเร็วและรุนแรง" ; -- src=panlex
lin blizzard_N = mkN "พายุหิมะ" | mkN "พายุหิมะ" ; -- src=panlex
lin bloated_A = mkA "ซึ่งขยายตัวเพราะเต็มไปด้วยก๊าซหรือของเหลว" ; -- src=panlex
lin bloater_N = mkN "ปลาโบลเตอร์" ; -- src=panlex
lin blob_N = mkN "กอง" | mkN "หยด" | mkN "หยดสี" | mkN "ก้อนกลุ่ม" | mkN "รอยเปื้อน" | mkN "ทําให้เปื้อน" | mkN "ใส่ลงหยดหนึ่ง" ; -- src=panlex
lin bloc_N = mkN "สันนิบาต" | mkN "กลุ่มประเทศ" | mkN "หมู่คน" | mkN "กลุ่มคน" | mkN "กลุ่มสมาชิกพรรคการเมือง" ; -- src=panlex
lin block_N = mkN "รอก" | mkN "บล็อก" | mkN "มู่เล่" | mkN "การหยุด" | mkN "ห้องแถว" | mkN "ทั้งก้อน" | mkN "ลูกบาศก์" | mkN "เสื้อสูบ" | mkN "การกีดขวาง" | mkN "แท่นประมูล" | mkN "รอกขนาดใหญ่" | mkN "สิ่งกีดขวาง" | mkN "ก้อนสี่เหลี่ยม" | mkN "แท่งสี่เหลี่ยม" | mkN "รูปทรงสี่เหลี่ยม" | mkN "ของที่เป็นก้อนสี่เหลี่ยม" | mkN "การหยุดชะงักทางกระบวนการทางความคิด" | mkN "ช่วงตึก" | mkN "ตึกใหญ่" | mkN "สิ่งกีดขวาง" | mkN "ที่วางของโชว์ในการประมูล" | mkN "ชิ้นของวัสดุที่เป็นของแข็งและมีลักษณะแบนราบ" | mkN "การหยุดชะงักของพัฒนาการของกระบวนการทางความคิดหยุดชะงัก" ; -- src=panlex
lin block_in_V2 = prepV2 (lin V OP_block_V2) OP_in_Prep ; -- guess-p-verb
lin block_off_V2 = prepV2 (lin V OP_block_V2) OP_off_Prep ; -- guess-p-verb
lin block_out_V2 = prepV2 (lin V OP_block_V2) OP_out_Prep ; -- guess-p-verb
lin block_up_V2 = prepV2 (lin V OP_block_V2) OP_up_Prep ; -- guess-p-verb
lin blockade_N = mkN "การปิดกั้น" | mkN "การขัดขวาง" | mkN "การปิดกั้น" | mkN "การปิดล้อม" ; -- src=panlex
lin blockage_N = mkN "การหยุด" | mkN "การอุดตัน" | mkN "การขัดขวาง" | mkN "สิ่งกีดขวาง" | mkN "การอุด" | mkN "การขัดขวาง" | mkN "การปิดกั้น" | mkN "การปิดล้อม" | mkN "ภาวะที่ถูกปิด" | mkN "ภาวะที่ถูกขัดขวาง" ; -- src=panlex
lin blockbuster_N = mkN "ระเบิดขนาดใหญ่" | mkN "สิ่งที่เป็นที่ยอดนิยม" | mkN "ลูกระเบิดที่ปล่อยจากเครื่องบิน" ; -- src=panlex
lin blocker_N = mkN "บล็อกเกอร์" | mkN "สารยับยั้ง" | mkN "ผู้เล่นที่เป็นตัวกัน" ; -- src=panlex
lin blockhead_N = mkN "คนโง่" | mkN "ไอ้ควาย" | mkN "คนสมองทึบ" | mkN "หัวขี้เลื่อย" | mkN "คนโง่เง่า" | mkN "หัวหุ่นไม้" | mkN "คนที่ไม่ฉลาด" ; -- src=panlex
lin blockheaded_A = mkA "ทึบ" | mkA "หัวขี้เลื่อย" ; -- src=panlex
lin blocking_N = mkN "การกีดขวาง" ; -- src=panlex
lin blockish_A = mkA "โง่" | mkA "คล้ายท่อนไม้" ; -- src=panlex
lin blog_N = mkN "บล็อก" | mkN "เว็บบล็อก" ; -- src=panlex
lin blogger_N = mkN "ผู้ดูแลบล็อก" ; -- src=panlex
lin bloke_N = mkN "พ่อ" | mkN "หนุ่ม" | mkN "พ่อหนุ่ม" | mkN "เจ้าหนุ่ม" | mkN "คน" | mkN "คนโง่" | mkN "ขี้เมา" | mkN "มนุษย์" | mkN "อ้ายหมอนี่" ; -- src=panlex
lin blolly_N = mkN "ต้นบลอลลี่" ; -- src=panlex
lin blond_A = mkA "บลอนด์" | mkA "สีทอง" | mkA "สีบลอนด์" | mkA "สีเหลืองอ่อนๆ" ; -- src=panlex
lin blonde_A = mkA "บลอนด์" | mkA "เป็นสีทอง" ; -- src=panlex
lin blonde_N = mkN "บลอนด์" | mkN "สีบลอนด์" | mkN "คนผิวสวยผมสวย" | mkN "สีน้ำเงินเข้ม" | mkN "สีอ่อน" | mkN "สีบลอนด์" | mkN "สีเหลืองอ่อน" ; -- src=panlex
lin blood_N = mkN (thword "เลือด") | {-pan-} mkN "กำพืด" | mkN "นิสัย" | mkN "เลือด" | mkN "โลหิต" | mkN "ตระกูล" | mkN "พระโลหิต" | mkN "สายเลือด" | mkN "เชื้อสาย" | mkN "สายตระกูล" | mkN "ผู้สืบสกุล" | mkN "ผู้ชายเจ้าชู้" | mkN "เทือกเถาเหล่ากอ" | mkN "คนที่ใช้จ่ายสุรุ่ยสุร่าย" | mkN "ชีวิต" | mkN "เลือด" | mkN "โลหิต" | mkN "การฆ่า" | mkN "กําลัง" | mkN "ชนชาติ" | mkN "อารมณ์" | mkN "ฆาตกรรม" | mkN "ภาวะจิต" | mkN "ชายหนุ่ม" | mkN "สายเลือด" | mkN "สายโลหิต" | mkN "พลังชีวิต" | mkN "น้ําต้นไม้" | mkN "วงศ์ตระกูล" | mkN "ส่วนสําคัญ" | mkN "การนองเลือด" | mkN "การหลั่งเลือด" | mkN "การเสียเลือดเนื้อ" | mkN "หนุ่มที่ชอบผจญภัย" ; -- src=panlex
lin blood_bath_N = mkN "การนองเลือด" | mkN "การฆ่าฟันอย่างบ้าคลั่ง" | mkN "การสังหารหมู่อย่างป่าเถื่อน" | mkN "การฆาตกรรมหมู่" ; -- src=panlex
lin bloodberry_N = mkN "ต้นบลัดเบอร์รี่" ; -- src=panlex
lin bloodcurdling_A = mkA "ที่เป็นฝันร้าย" | mkA "ขนพอง" | mkA "สยองเกล้า" | mkA "น่ากลัวมาก" ; -- src=panlex
lin bloodhound_N = mkN "บลัดเฮานด์" | mkN "สุนัขพันธุ์บลัดเฮานด์" | mkN "สุนัขพันธุ์หนึ่งมีหูยาว" ; -- src=panlex
lin bloodleaf_N = mkN "ต้นบลัดลีฟ" ; -- src=panlex
lin bloodless_A = mkA "ซึ่งไม่เสียเลือดเนื้อ" | mkA "ไร้เลือด" ; -- src=panlex
lin blood_letting_N = mkN "การนองเลือด" | mkN "การผ่าให้เลือดออก" | mkN "การฆ่าฟันอย่างบ้าคลั่ง" | mkN "การสังหารหมู่อย่างป่าเถื่อน" | mkN "การผ่าเอาเลือดออก" | mkN "การผ่าหลอดเลือดดํา" ; -- src=panlex
lin bloodlust_N = mkN "ความกระหายเลือด" | mkN "การผ่าหลอดเลือดดํา" ; -- src=panlex
lin bloodmobile_N = mkN "รถรับบริจาคเลือด" | mkN "รถรับบริจาคโลหิต" ; -- src=panlex
lin bloodroot_N = mkN "ต้นบลัดรูต" ; -- src=panlex
lin bloodshed_N = mkN "การนองเลือด" | mkN "การฆ่าฟันอย่างบ้าคลั่ง" | mkN "การสังหารหมู่อย่างป่าเถื่อน" | mkN "การฆ่าฟัน" | mkN "การนองเลือด" | mkN "การฆ่ากันตาย" | mkN "การทําลายชีวิต" ; -- src=panlex
lin bloodshot_A = mkA "ตาแดงก่ําเพราะเส้นเลือดฝอยแตก" ; -- src=panlex
lin bloodstain_N = mkN "คราบเลือด" | mkN "รอยเลือด" | mkN "จุดที่เปื้อนเลือด" ; -- src=panlex
lin bloodstained_A = mkA "ซึ่งเป็นรอยเลือด" | mkA "ซึ่งเป็นรอยเลือด" ; -- src=panlex
lin bloodstock_N = mkN "ม้าพันธุ์ที่ใช้วิ่งแข่งขัน" ; -- src=panlex
lin bloodstone_N = mkN "หินบลัดสโตน" | mkN "หินเลือดพระลักษณ์" | mkN "ดอกไม้ที่หันเข้าหาแสงอาทิตย์" ; -- src=panlex
lin bloodstream_N = mkN "กระแสเลือด" | mkN "กระแสเลือด" ; -- src=panlex
lin bloodsucker_N = mkN "ทาก" | mkN "ปลิง" ; -- src=panlex
lin bloodsucking_A = mkA "ซึ่งดูดเลือด" ; -- src=panlex
lin bloodthirsty_A = mkA "ซึ่งกระหายเลือด" | mkA "โหดร้าย" | mkA "กระหายเลือด" | mkA "เป็นฆาตกรรม" ; -- src=panlex
lin bloodworm_N = mkN "หนอนหรือไส้เดือนที่ใช้เป็นเหยื่อปลา" ; -- src=panlex
lin bloodwort_N = mkN "ต้นบลัดเวิร์ต" | mkN "พืชที่รากสีแดง" ; -- src=panlex
lin bloody_A = mkA "ที่เต็มไปด้วยเลือด" | mkA "ระยํา" | mkA "แดงฉาน" | mkA "อัปรีย์" | mkA "คล้ายเลือด" | mkA "หลั่งเลือด" | mkA "กระหายเลือด" | mkA "เปื้อนเลือด" | mkA "เต็มไปด้วยเลือด" ; -- src=panlex
lin bloody_Adv = mkAdv "อย่างรุนแรง" | mkAdv "อย่างสุดขีด" ; -- src=panlex
lin bloom_N = mkN "ดอก" | mkN "มาลี" | mkN "บุปผา" | mkN "ดอกไม้" | mkN "การเบ่งบาน" | mkN "วัยแรกแย้ม" | mkN "สีแดงระเรื่อ" | mkN "ความอ่อนเยาว์" | mkN "ความเปล่งปลั่ง" | mkN "ช่วงเวลาออกดอกออกผล" | mkN "ช่วงเวลาที่ออกดอกสะพรั่ง" | mkN "ดอก" | mkN "ดอกไม้" | mkN "การออกดอก" | mkN "ดอกไม้บาน" | mkN "การเบ่งบาน" | mkN "ทําให้สดสวย" | mkN "ความเปล่งปลั่ง" | mkN "ความแดงของแก้ม" | mkN "สู่วัยหนุ่มสาว" | mkN "ดอกไม้ทั้งหมดที่เห็น" | mkN "ผิวพรรณที่มีสุขภาพดี" | mkN "ความเบ่งบานของวัยเยาว์" ; -- src=panlex
lin bloom_V = mkV "มีดอก" | mkV "ผลิดอก" | mkV "ออกดอก" | mkV "บาน" | mkV "คลี่" | mkV "แย้ม" | mkV "เบ่งบาน" | mkV "ดูมีสุขภาพดี" | mkV "อยู่ในระยะเวลาที่เจริญเติบโตถึงที่สุด" ; -- src=panlex
lin bloomer_N = mkN "การทำผิดพลาด" | mkN "ความผิดที่น่าอับอาย" | mkN "ความผิดพลาด" ; -- src=panlex
lin bloomers_N = mkN "กางเกงใน" | mkN "กางเกงชั้นในสตรี" | mkN "ชุดชั้นในแบบเก่าของผู้หญิง" ; -- src=panlex
lin blooming_N = mkN "การเบ่งบาน" ; -- src=panlex
lin blossom_N = mkN "ดอก" | mkN "มาลี" | mkN "บุปผา" | mkN "ดอกไม้" | mkN "ช่วงเวลาออกดอกออกผล" | mkN "ช่วงเวลาที่ออกดอกสะพรั่ง" | mkN "ดอก" | mkN "พัฒนา" | mkN "ดอกบาน" | mkN "ดอกไม้" | mkN "การออกดอก" | mkN "เจริญเติบโต" | mkN "ช่วงที่ออกดอก" ; -- src=panlex
lin blossom_V = mkV "มีดอก" | mkV "ผลิดอก" | mkV "ออกดอก" | mkV "มีพัฒนาการ" | mkV "พัฒนา" | mkV "ออกดอก" | mkV "เติบโต" ; -- src=panlex
lin blossoming_N = mkN "ช่วงออกดอก" ; -- src=panlex
lin blot_N = mkN "การทำให้เสื่อมเสีย" | mkN "รอยเปื้อน" ; -- src=panlex
lin blotch_N = mkN "รอยเปื้อน" | mkN "รอยจุดด่าง" | mkN "จุดหรือแต้ม" ; -- src=panlex
lin blotchy_A = mkA "เป็นจุด" | mkA "เป็นดวง" | mkA "เป็นตุ่มแผล" | mkA "คล้ายรอยเปื้อน" | mkA "ซึ่งเป็นจุดหรือแต้ม" ; -- src=panlex
lin blotter_N = mkN "สมุดบันทึก" | mkN "กระดาษซับหมึก" | mkN "กระดาษซับ" | mkN "บันทึกประจําวันของตํารวจ" ; -- src=panlex
lin blotto_A = mkA "เมาหนัก" | mkA "เมาปลิ้น" | mkA "เมาหัวราน้ำ" | mkA "เมา" | mkA "เมามาก" ; -- src=panlex
lin blouse_N = mkN "เสื้อผู้หญิง" | mkN "เสื้อคลุมที่สั้น" | mkN "เสื้อครึ่งตัวของสตรี" ; -- src=panlex
lin blow_N = mkN "โค้ก" | mkN "สโนว์" | mkN "การตกใจ" | mkN "การกระทบ" | mkN "การหายใจ" | mkN "ลมพัดแรง" | mkN "การกระแทก" | mkN "การถอยกลับ" | mkN "การตีเต็มแรง" | mkN "การตี" | mkN "การต่อย" | mkN "การเป่า" ; -- src=panlex
lin blow_V = mkV (thword "พัด") | {-pan-} mkV "อม" | mkV "ขาด" | mkV "ดูด" | mkV "พัด" | mkV "พ่น" | mkV "ปลิว" | mkV "เป่า" | mkV "เลีย" | mkV "โม้ก" | mkV "คุยโว" | mkV "ไสหัว" | mkV "ทำลวกๆ" | mkV "วางไข่" | mkV "เงอะงะ" | mkV "โอ้อวด" | mkV "ล่องลอย" | mkV "โ้อ้อวด" | mkV "ถอนหายใจ" | mkV "เป่าแรงๆ" | mkV "ทำงานชุ่ย" | mkV "ทำงานลวกๆ" | mkV "ทำมักง่าย" | mkV "ทำงานมักง่าย" | mkV "ทำงานสะเพร่า" | mkV "ทำให้เสียหาย" | mkV "ลอยไปตามกระแส" | mkV "ใช้จ่ายสุรุ่ยสุร่าย" | mkV "ขาด" | mkV "บาน" | mkV "พัด" | mkV "โชย" | mkV "เป่า" | mkV "ไหม้" | mkV "พ่นลม" | mkV "ระเบิด" | mkV "รําเพย" | mkV "ส่งจูบ" | mkV "เป่าลม" | mkV "สูดจมูก" | mkV "ทําให้บาน" | mkV "ใช้อย่างสุรุ่ยสุร่าย" ; -- src=panlex
lin blow_V2 = mkV2 (thword "พัด") ; ---- | {-pan-} mkV "อม" | mkV "ขาด" | mkV "ดูด" | mkV "พัด" | mkV "พ่น" | mkV "ปลิว" | mkV "เป่า" | mkV "เลีย" | mkV "โม้ก" | mkV "คุยโว" | mkV "ไสหัว" | mkV "ทำลวกๆ" | mkV "วางไข่" | mkV "เงอะงะ" | mkV "โอ้อวด" | mkV "ล่องลอย" | mkV "โ้อ้อวด" | mkV "ถอนหายใจ" | mkV "เป่าแรงๆ" | mkV "ทำงานชุ่ย" | mkV "ทำงานลวกๆ" | mkV "ทำมักง่าย" | mkV "ทำงานมักง่าย" | mkV "ทำงานสะเพร่า" | mkV "ทำให้เสียหาย" | mkV "ลอยไปตามกระแส" | mkV "ใช้จ่ายสุรุ่ยสุร่าย" | mkV "ขาด" | mkV "บาน" | mkV "พัด" | mkV "โชย" | mkV "เป่า" | mkV "ไหม้" | mkV "พ่นลม" | mkV "ระเบิด" | mkV "รําเพย" | mkV "ส่งจูบ" | mkV "เป่าลม" | mkV "สูดจมูก" | mkV "ทําให้บาน" | mkV "ใช้อย่างสุรุ่ยสุร่าย" ; -- src=panlex
lin blow_away_V = advV OP_blow_V OP_away_Adv ; -- guess-p-verb
lin blow_away_V2 = mkV2 (advV OP_blow_V OP_away_Adv ) ; -- guess-p-verb
lin blow_down_V2 = prepV2 OP_blow_V OP_down_Prep ; -- guess-p-verb
lin blow_dry_V2 = variants {} ; -- guess-p-verb
lin blow_in_V = advV OP_blow_V OP_in_Adv ; -- guess-p-verb
lin blow_off_V = advV OP_blow_V OP_off_Adv ; -- guess-p-verb
lin blow_off_V2 = prepV2 OP_blow_V OP_off_Prep ; -- guess-p-verb
lin blow_out_V2 = prepV2 OP_blow_V OP_out_Prep ; -- guess-p-verb
lin blow_over_V = advV OP_blow_V OP_over_Adv ; -- guess-p-verb
lin blow_up_V = advV OP_blow_V OP_up_Adv ; -- guess-p-verb
lin blow_up_V2 = prepV2 OP_blow_V OP_up_Prep ; -- guess-p-verb
lin blower_N = mkN "พัดลม" | mkN "พัดลมไฟฟ้า" | mkN "เครื่องเป่าลม" | mkN "สัตว์ทะเลเลี้ยงลูกด้วยน้ำนม" | mkN "หีบลม" | mkN "ผู้เป่า" | mkN "โทรศัพท์" | mkN "สิ่งที่เป่า" | mkN "เครื่องเป่า" | mkN "เครื่องเพิ่มความกดดัน" ; -- src=panlex
lin blowfish_N = mkN "ปลาปักเป้า" | mkN "เนื้อปลาปักเป้า" | mkN "ปลาที่สามารถพองตัวเองได้" ; -- src=panlex
lin blowfly_N = mkN "แมลงวัน" ; -- src=panlex
lin blowgun_N = mkN "กล้องเป่าลูกดอก" | mkN "หลอดเป่ากระสุนอาวุธ" ; -- src=panlex
lin blowhole_N = mkN "รูพ่น" | mkN "ช่องปล่อยก๊าซ" | mkN "ช่องหายใจของปลาวาฬ" ; -- src=panlex
lin blowlamp_N = mkN "เครื่องพ่นไฟ" | mkN "ตะเกียงเตาฟู่" | mkN "เครื่องพ่นความร้อนเพื่อล้างสีออก" ; -- src=panlex
lin blowout_N = mkN "งานรื่นเริง" | mkN "การได้รับชัยชนะอย่างง่ายดาย" | mkN "การระเบิดออก" | mkN "การระเบิดของยางรถ" | mkN "การระเบิดออกของยางรถ" | mkN "ฟิวส์ไฟฟ้าที่หลอมละลาย" | mkN "การทะลักออกของน้ําหรือแก๊ส" | mkN "งานเลี้ยงหรืองานรื่นเริงขนาดใหญ่" | mkN "การทะลักของน้ํามันหรือแก๊ซออกมาจากบ่อ" ; -- src=panlex
lin blowpipe_N = mkN "กล้องเป่าลูกดอก" | mkN "หลอดเป่ากระสุนอาวุธ" | mkN "เครื่องทําความสะอาดโพรง" | mkN "ท่ออากาศหรือแก๊สที่พุ่งเข้าสู่เปลวไฟ" ; -- src=panlex
lin blowsy_A = mkA "หน้าแดงและผิวหยาบ" ; -- src=panlex
lin blowtorch_N = mkN "เครื่องพ่นไฟ" | mkN "ตะเกียงเตาฟู่" | mkN "เครื่องพ่นไฟ" | mkN "เครื่องพ่นความร้อนเพื่อล้างสีออก" ; -- src=panlex
lin blowtube_N = mkN "กล้องเป่าลูกดอก" | mkN "หลอดเป่ากระสุนอาวุธเหล่าเป่า" ; -- src=panlex
lin blowy_A = mkA "เบามาก" | mkA "มีลมพัด" | mkA "ปลิวได้ง่าย" ; -- src=panlex
lin blowzy_A = mkA "ยุ่งเหยิง" | mkA "มีผิวพรรณที่หยาบ" | mkA "หน้าแดงและผิวหยาบ" ; -- src=panlex
lin blubber_N = mkN "ชั้นไข" | mkN "ความอ้วน" | mkN "เป็นมัน" | mkN "โป่งออก" | mkN "ชั้นไขมันที่อยู่ระหว่างชั้นกล้ามเนื้อและหนังของปลาวาฬ" ; -- src=panlex
lin blubber_V = mkV "สะอื้นไห้" | mkV "ร้องไห้สะอึกสะอื้น" | mkV "ร้องไห้ฟูมฟาย" | mkV "พูดขณะร้องไห้ ทําให้คําพูดขาดเป็นช่วงๆ" ; -- src=panlex
lin blubber_V2 = mkV2 "สะอื้นไห้" ; ---- | mkV "ร้องไห้สะอึกสะอื้น" | mkV "ร้องไห้ฟูมฟาย" | mkV "พูดขณะร้องไห้ ทําให้คําพูดขาดเป็นช่วงๆ" ; -- src=panlex
lin blubbery_A = mkA "มีมัมมาก" | mkA "มีไขมันมาก" ; -- src=panlex
lin bludgeon_N = mkN "กระบองบลูเจิน" | mkN "กระบองสั้น" ; -- src=panlex
lin blue_A = mkA (thword "น้ำ" "เงิน") | {-pan-} mkA "ทะลึ่ง" | mkA "น้ำเงิน" | mkA "สองแง่สามง่าม" | mkA "ฟ้า" | mkA "ลามก" | mkA "สีฟ้า" | mkA "เคร่ง" | mkA "เสียใจ" | mkA "หยาบโลน" | mkA "เศร้าใจ" | mkA "เคร่งครัด" | mkA "สีน้ําเงิน" ; -- src=panlex --- (thword "สี" "น้ำ" "เงิน") ;
lin blue_N = mkN "คราม" | mkN "น้ำเงิน" | mkN "แอมมีทอล" | mkN "ฟ้าสีคราม" | mkN "สีน้ำเงิน" | mkN "ยาแอมมีทอล" | mkN "ชุดสีกรมท่า" | mkN "ท้องฟ้าสีคราม" | mkN "เสื้อผ้าสีฟ้า" | mkN "ผีเสื้อชนิดหนึ่ง" | mkN "หน่วยงานชุดน้ำเงิน" | mkN "แอมโมบาร์บิทอลโซเดียม" | mkN "ยาแอมโมบาร์บิทอลโซเดียม" | mkN "สีฟ้า" | mkN "สีน้ําเงิน" ; -- src=panlex
lin bluebell_N = mkN "ต้นแพรรี่เจนเทียน" | mkN "ต้นไม้ป่ามีดอกสีฟ้ารูปร่างเหมือนระฆัง" ; -- src=panlex
lin blueberry_N = mkN "บลูเบอร์รี่" | mkN "ต้นบลูเบอร์ีรี่" | mkN "ผลบลูเบอร์รี่" ; -- src=panlex
lin bluebird_N = mkN "นกบลูเบิร์ด" | mkN "นกเขียวคราม" | mkN "นกสีน้ําเงินในอเมริกาเหนือ" ; -- src=panlex
lin bluebonnet_N = mkN "ต้นบลูบอนเน็ต" ; -- src=panlex
lin bluebottle_N = mkN "ดอกข้าวโพด" | mkN "ดอกคอร์นฟลาวเวอร์" | mkN "แมลงวันสีฟ้าตัวใหญ่" ; -- src=panlex
lin bluecoat_N = mkN "ผู้สวมชุดสีกรมท่า" ; -- src=panlex
lin bluefin_N = mkN "ปลาบลูฟิน" | mkN "ปลาบลูฟินทูน่า" | mkN "เนื้อปลาบลูฟิน" | mkN "เนื้อปลาบลูฟินทูน่า" ; -- src=panlex
lin bluefish_N = mkN "ปลาบลูฟิช" | mkN "เนื้อปลาบลูฟิช" ; -- src=panlex
lin bluegill_N = mkN "ปลาบลูกิลล์" ; -- src=panlex
lin bluegrass_N = mkN "หญ้าบลูแกรส" | mkN "ดนตรีบลูกราส" | mkN "เพลงคันทรี่ของอเมริกัน" ; -- src=panlex
lin bluehead_N = mkN "ปลาบลูเฮด" ; -- src=panlex
lin blue_jacket_N = mkN "ทหารเรือ" ; -- src=panlex
lin bluepoint_N = mkN "บลูพอยต์" | mkN "หอยนางรมบลูพอยต์" ; -- src=panlex
lin blueprint_N = mkN "แม่แบบ" | mkN "พิมพ์เขียว" | mkN "แบบสร้าง" | mkN "พิมพ์เขียว" | mkN "ร่างแผนอย่างละเอียด" ; -- src=panlex
lin blues_N = mkN "บลูส์" | mkN "เพลงบลูส์" | mkN "ดนตรีบลูส์" | mkN "ความเศร้าโศก" | mkN "ความเศร้าหมอง" | mkN "เพลงบลูของคนผิวดําในอเมริกา" ; -- src=panlex
lin bluestem_N = mkN "หญ้าบลูสตีม" ; -- src=panlex
lin bluestocking_N = mkN "หญิงที่มีการศึกษาดี" ; -- src=panlex
lin bluethroat_N = mkN "นกคอมรกต" ; -- src=panlex
lin bluetick_N = mkN "บลูติก" | mkN "สุนัขพันธุ์บลูติก" ; -- src=panlex
lin bluewing_N = mkN "เป็ดบลูวิง" ; -- src=panlex
lin bluff_A = mkA "กว้างและสูงชัน" | mkA "เป็นมิตรแต่โผงผาง" | mkA "เป็นมิตรแต่พูดตรงโดยไม่สนใจความรู้สึกของคนอื่น" ; -- src=panlex
lin bluff_N = mkN "ตลิ่ง" | mkN "การเกทับ" | mkN "การแกล้งทำเป็น" | mkN "ตลิ่งกว้างและชัน" | mkN "หน้าผาที่กว้างและสูงชัน" | mkN "การแกล้งตั้งใจทําบางสิ่ง" ; -- src=panlex
lin bluff_V = mkV "บลัฟ" | mkV "เกทับ" | mkV "ข่มขวัญ" | mkV "แกล้งตั้งใจทําบางสิ่งเพื่อหลอกคนอื่น" ; -- src=panlex
lin bluff_V2 = mkV2 "บลัฟ" ; ---- | mkV "เกทับ" | mkV "ข่มขวัญ" | mkV "แกล้งตั้งใจทําบางสิ่งเพื่อหลอกคนอื่น" ; -- src=panlex
lin bluffness_N = mkN "ความตรงไปตรงมา" ; -- src=panlex
lin bluing_N = mkN "คราม" | mkN "การทำให้เป็นสีน้ำเงิน" ; -- src=panlex
lin bluish_A = mkA "น้ำเงิน" | mkA "ค่อนข้างสีน้ําเงิน" | mkA "ซึ่งเป็นสีน้ําเงิน" ; -- src=panlex
lin blunder_N = mkN "การทำผิดพลาด" | mkN "ความผิดที่น่าอับอาย" | mkN "การทําผิดพลาดอย่างร้ายแรงเนื่องจากความสะเพร่า" ; -- src=panlex
lin blunder_V = mkV "พูดโพล่งออกมา" | mkV "ทำผิดพลาดร้ายแรง" | mkV "เดินงุ่มง่าม" ; -- src=panlex
lin blunder_V2 = mkV2 "พูดโพล่งออกมา" ; ---- | mkV "ทำผิดพลาดร้ายแรง" | mkV "เดินงุ่มง่าม" ; -- src=panlex
lin blunderbuss_N = mkN "ปืนสั้นที่มีปากกระบอกใหญ่" ; -- src=panlex
lin blunderer_N = mkN "คนผิด" | mkN "คนระยำ" | mkN "คนมักง่าย" | mkN "คนสะเพร่า" | mkN "คนโง่เง่า" | mkN "คนงุ่มง่าม" | mkN "คนซุ่มซ่าม" ; -- src=panlex
lin blunt_A = mkA "ทู่" | mkA "ทื่อ" | mkA "ทู่" | mkA "ทื่อ" | mkA "ไม่คม" ; -- src=panlex
lin bluntness_N = mkN "ความทื่อ" ; -- src=panlex
lin blur_N = mkN "ความพร่ามัว" | mkN "ความมัว" | mkN "ความพร่ามัว" | mkN "ความเลือนราง" | mkN "ความไม่ชัดเจน" ; -- src=panlex
lin blur_V = mkV "พร่า" | mkV "คลุมเครือ" | mkV "ทำให้เปื้อน" | mkV "ทำให้พร่ามัว" | mkV "ทําให้มัว" | mkV "ทําให้พร่ามัว" | mkV "ทําให้เลือนลาง" | mkV "ทําให้คลุมเคลือ" | mkV "ทําให้ไม่ชัดเจน" ; -- src=panlex
lin blur_V2 = mkV2 "พร่า" ; ---- | mkV "คลุมเครือ" | mkV "ทำให้เปื้อน" | mkV "ทำให้พร่ามัว" | mkV "ทําให้มัว" | mkV "ทําให้พร่ามัว" | mkV "ทําให้เลือนลาง" | mkV "ทําให้คลุมเคลือ" | mkV "ทําให้ไม่ชัดเจน" ; -- src=panlex
lin blurb_N = mkN "คำสรรเสริญ" | mkN "คําโฆษณาสั้น" ; -- src=panlex
lin blush_N = mkN "หน้าแดง" | mkN "สีแดงระเรื่อ" | mkN "ความเปล่งปลั่ง" | mkN "การหน้าแดงเพราะเขินอาย" ; -- src=panlex
lin blush_V = mkV "หน้าแดง" | mkV "แดงระเรื่อ" | mkV "กลายเป็นสีแดง" | mkV "เปลี่ยนเป็นสีแดง" | mkV "เป็นสีแดงระเรื่อ" | mkV "ละอาย" | mkV "เขินอาย" | mkV "อาการหน้าแดงเพราะเขินอาย" ; -- src=panlex
lin bluster_N = mkN "ความองอาจ" ; -- src=panlex
lin bluster_V = mkV "คุยโว" | mkV "โอ้อวด" | mkV "โ้อ้อวด" | mkV "ทำตัวกร่าง" | mkV "พัดอย่างรุนแรง" | mkV "ตวาด" | mkV "คุยโต" | mkV "ตะคอก" | mkV "คําราม" | mkV "แผดเสียง" ; -- src=panlex
lin bluster_V2 = mkV2 "คุยโว" ; ---- | mkV "โอ้อวด" | mkV "โ้อ้อวด" | mkV "ทำตัวกร่าง" | mkV "พัดอย่างรุนแรง" | mkV "ตวาด" | mkV "คุยโต" | mkV "ตะคอก" | mkV "คําราม" | mkV "แผดเสียง" ; -- src=panlex
lin blustery_A = mkA "ซึ่งมีลมพัดแรง" ; -- src=panlex
lin boa_N = mkN "หนังงู" | mkN "งูเหลือม" | mkN "ผ้าพันคอขนนก" | mkN "งูหลาม" | mkN "งูเหลือม" ; -- src=panlex
lin boar_N = mkN "หมูป่า" | mkN "หมูตัวผู้" | mkN "หมูเถื่อน" | mkN "หมูเพศผู้" | mkN "หมูป่า" | mkN "หมูป่าตัวผู้" | mkN "หมูตัวผู้ที่ไม่ได้ตอน" ; -- src=panlex
lin board_1_N = variants {} ; ---- sense to be split
lin board_2_N = variants {} ; ---- sense to be split
lin boarder_N = mkN "ต้นหน" | mkN "ผู้เช่าห้อง" | mkN "นักเรียนประจำ" | mkN "นักเรียนกินนอน" | mkN "ผู้มาพักและได้รับบริการอาหารด้วย" ; -- src=panlex
lin boarding_N = mkN "การขึ้นเครื่อง" | mkN "การขึ้นเครื่องบิน" | mkN "เครื่องบิน รถไฟหรือยานพาหนะอื่น" | mkN "การขึ้นเรือ" | mkN "ไม้กระดานยาว" | mkN "ผิวหน้าไม้กระดาน" | mkN "ไม้กระดานทั้งหมด" ; -- src=panlex
lin boardroom_N = mkN "ห้องประชุม" | mkN "ห้องประชุมคณะกรรมการ" ; -- src=panlex
lin boardwalk_N = mkN "ทางเดินไม้กระดาน" | mkN "ทางไม้กระดาน โดยเฉพาะแถวชายหาด" ; -- src=panlex
lin boarfish_N = mkN "ปลาบอร์ฟิช" | mkN "ปลาโบอาร์ฟิช" | mkN "ปลาที่มีจมูกออกเป็นหนาม" ; -- src=panlex
lin boarhound_N = mkN "โบร์เฮานด์" | mkN "สุนัขพันธุ์โบร์เฮานด์" ; -- src=panlex
lin boast_N = mkN "ยกย่อง" | mkN "การคุยโม้" | mkN "การโอ้อวด" | mkN "ยกย่องตนเอง" | mkN "การคุยโม้" | mkN "การโอ้อวด" ; -- src=panlex
lin boast_V = mkV "คุยโว" | mkV "โอ้อวด" | mkV "โ้อ้อวด" | mkV "โว" | mkV "อวด" | mkV "โม้" | mkV "คุยโว" | mkV "โอ้อวด" ; -- src=panlex
lin boast_V2 = mkV2 "คุยโว" ; ---- | mkV "โอ้อวด" | mkV "โ้อ้อวด" | mkV "โว" | mkV "อวด" | mkV "โม้" | mkV "คุยโว" | mkV "โอ้อวด" ; -- src=panlex
lin boast_VS = mmkVS "คุยโว" ; ---- | mkV "โอ้อวด" | mkV "โ้อ้อวด" | mkV "โว" | mkV "อวด" | mkV "โม้" | mkV "คุยโว" | mkV "โอ้อวด" ; -- src=panlex
lin boaster_N = mkN "คนขี้คุย" ; -- src=panlex
lin boastful_A = mkA "คุยโว" | mkA "อวดดี" | mkA "ขี้คุย" | mkA "คุยโม้" | mkA "โอ้อวด" | mkA "ยกตนข่มท่าน" ; -- src=panlex
lin boastfulness_N = mkN "การคุยโม้" | mkN "การโอ้อวด" ; -- src=panlex
lin boat_N = mkN (thword "เรือ") "ลำ" | {-pan-} mkN "ชาม" | mkN "นาวา" | mkN "เรือ" | mkN "เภตรา" | mkN "เหยือกน้ำเกรวี่" | mkN "เรือ" ; -- src=panlex
lin boat_V = mkV "ขี่เรือ" | mkV "ขึ้นเรือ" | mkV "นั่งเรือ" | mkV "โดยสารเรือ" | mkV "เดินทางทางน้ํา" | mkV "เดินทางโดยเรือ" ; -- src=panlex
lin boatbill_N = mkN "นกโบตบิล" ; -- src=panlex
lin boater_N = mkN "เรือจ้าง" | mkN "คนขับเรือ" | mkN "หมวกปานามา" | mkN "คนขับเรือจ้าง" | mkN "หมวกฟางยอดแบน" | mkN "หมวกฟางที่มียอดแบน" ; -- src=panlex
lin boat_house_N = mkN "โรงเก็บเรือ" ; -- src=panlex
lin boating_N = mkN "การพายเรือแล่น" | mkN "การแล่นเรือเล่น" | mkN "การพายหรือแล่นเรือเล่น" ; -- src=panlex
lin boatload_N = mkN "ระวาง" | mkN "ระวาง" | mkN "สินค้าบนเรือ" ; -- src=panlex
lin boatman_N = mkN "เรือจ้าง" | mkN "คนขับเรือ" | mkN "คนขับเรือจ้าง" | mkN "คนเรือ" | mkN "ผู้ชํานาญทางเรือ" | mkN "ผู้ค้าขายเกี่ยวกับเรือ" ; -- src=panlex
lin boatmanship_N = mkN "ทักษะการบังคับเรือ" ; -- src=panlex
lin boatswain_N = mkN "สรั่งเรือ" | mkN "จ่ายามเรือ" | mkN "หัวหน้ากะลาสีเรือ" | mkN "พันจ่าเรือที่มีหน้าที่ดูแลเรือ" | mkN "เจ้าหน้าที่บนเรือคอยบํารุงรักษาเรือหรือเครื่องใช้ในเรือ" ; -- src=panlex
lin boatyard_N = mkN "บริเวณท่าเรือ" | mkN "อู่ซ่อมหรือเก็บเรือ" ; -- src=panlex
lin bob_N = mkN "หาง" | mkN "ทุ่น" | mkN "บ็อบ" | mkN "ชิลลิง" | mkN "ผมบ็อบ" | mkN "ทรงบ๊อบ" | mkN "ลูกตุ้ม" | mkN "หางสั้น" | mkN "บ็อบสเลด" | mkN "ทรงผมบ็อบ" | mkN "ทุ่นตกปลา" | mkN "เลื่อนหิมะ" | mkN "การผงกขึ้นๆลงๆ" | mkN "ผมบ๊อบ" | mkN "การผงกศีรษะ" | mkN "สิบสองเพนนี" | mkN "ทรงผมแบบหนึ่ง" | mkN "ผมทรงสั้นที่ตัดตรงแค่คาง" | mkN "สิ่งที่ถูกตัดให้สั้นเช่น หางม้า หูสุนัข" | mkN "สิ่งที่ห้อยอยู่และเด้งขึ้นเด้งลงเช่น ปอยผม" ; -- src=panlex
lin bob_V = mkV "ตัดหาง" | mkV "ตัดผมบ็อบ" | mkV "ถอนสายบัว" | mkV "ขี่บ็อบสเลด" | mkV "ตัดผมทรงบ็อบ" | mkV "ผลุบๆ โผล่ๆในน้ํา" | mkV "ผงกหัว" | mkV "ผงกศีรษะ" | mkV "เคาะเบาๆ เร็วๆ" ; -- src=panlex
lin bob_V2 = mkV2 "ตัดหาง" ; ---- | mkV "ตัดผมบ็อบ" | mkV "ถอนสายบัว" | mkV "ขี่บ็อบสเลด" | mkV "ตัดผมทรงบ็อบ" | mkV "ผลุบๆ โผล่ๆในน้ํา" | mkV "ผงกหัว" | mkV "ผงกศีรษะ" | mkV "เคาะเบาๆ เร็วๆ" ; -- src=panlex
lin bobbin_N = mkN "หลอดเก็บสาย" | mkN "กระสวย" | mkN "หลอดด้าย" | mkN "หลอดสายไฟ" | mkN "กระสวยด้าย" | mkN "โครงสายม้วน" ; -- src=panlex
lin bobble_N = mkN "รับพลาด" | mkN "เตะพลาด" | mkN "การกระโดดขึ้นลง" | mkN "ลูกกลมเล็กทําด้วยขนสัตว์สําหรับตกแต่งเสื้อผ้า" ; -- src=panlex
lin bobby_N = mkN "บ็อบบี" | mkN "เจ้าหน้าที่ตํารวจ" | mkN "ถุงเท้าสั้นของผู้หญิง" ; -- src=panlex
lin bobcat_N = mkN "แมวป่าแถบอเมริกาเหนือ" ; -- src=panlex
lin bobolink_N = mkN "นกไรซ์เบิร์ด" ; -- src=panlex
lin bobsled_N = mkN "บ็อบสเลด" | mkN "เลื่อนหิมะ" | mkN "แคร่เลื่อนหิมะ" ; -- src=panlex
lin bobsleigh_N = mkN "บ็อบสเลด" | mkN "เลื่อนหิมะ" | mkN "รถเลื่อนหิมะ" | mkN "แคร่เลื่อนหิมะ" ; -- src=panlex
lin bobtail_A = mkA "ที่มีหางสั้น" ; -- src=panlex
lin bobtail_N = mkN "หาง" | mkN "หางสั้น" | mkN "สุนัขพันธุ์บ็อบเทล" | mkN "หางสัตว์ที่ตัดสั้น" ; -- src=panlex
lin bocconia_N = mkN "ต้นบ็อกโคเนีย" | mkN "ต้นพลูมป๊อปปี้" ; -- src=panlex
lin bock_N = mkN "บ็อคเบียร์" | mkN "เบียร์เข้มข้น" ; -- src=panlex
lin bode_V = mkV "เป็นลาง" | mkV "เป็นลางบอกเหตุ" | mkV "เป็นลาง" | mkV "เป็นลางบอกเหตุ" ; -- src=panlex
lin bode_V2 = mkV2 "เป็นลาง" ; ---- | mkV "เป็นลางบอกเหตุ" | mkV "เป็นลาง" | mkV "เป็นลางบอกเหตุ" ; -- src=panlex
lin bodega_N = mkN "ร้านของคนสเปนขายไวน์" | mkN "ร้านของชํา" | mkN "โรงเก็บของโกดัง" ; -- src=panlex
lin bodice_N = mkN "เสื้อชั้นในของสตรี" | mkN "เสื้อท่อนบนของสตรี" ; -- src=panlex
lin bodied_A = mkA "ที่มีร่างกาย" | mkA "ซึ่งเป็นตัวเป็นตน" ; -- src=panlex
lin bodiless_A = mkA "ที่ไม่มีตัว" ; -- src=panlex
lin bodily_A = mkA "ในร่างกาย" | mkA "ทางร่างกาย" | mkA "กาย" | mkA "ร่าง" | mkA "ทั้งกาย" | mkA "ทั้งมวล" | mkA "ทั้งหมด" | mkA "ด้วยตนเอง" | mkA "เกี่ยวกับกาย" | mkA "เกี่ยวกับหน่วยทางกายภาพ" ; -- src=panlex
lin bodily_Adv = mkAdv "กาย" | mkAdv "ร่าง" | mkAdv "ทั้งกาย" | mkAdv "ทั้งมวล" | mkAdv "ทั้งหมด" | mkAdv "ด้วยตนเอง" | mkAdv "เกี่ยวกับกาย" | mkAdv "เกี่ยวกับร่างกาย" | mkAdv "เกี่ยวกับหน่วยทางกายภาพ" ; -- src=panlex
lin boding_N = mkN "ลางสังหรณ์" | mkN "ความสังหรณ์" | mkN "ลางร้าย" | mkN "ลางสังหรณ์" | mkN "เป็นลางสังหรณ์" | mkN "ซึ่งบอกเหตุล่วงหน้า" ; -- src=panlex
lin bodkin_N = mkN "เข็ม" | mkN "ปิ่นปักผม" | mkN "เหล็กหมาด" | mkN "ดาบพอนเยิร์ด" | mkN "สว่าน" | mkN "คีมหนีบ" | mkN "เข็มใหญ่" | mkN "กริชเล่มเล็ก" | mkN "กิ๊บผมที่ยาว" | mkN "เครื่องเจาะรู" | mkN "เครื่องคล้ายเข็มสําหรับสอดรู" ; -- src=panlex
lin body_N = mkN "ศพ" | mkN "กาย" | mkN "ซาก" | mkN "ตัว" | mkN "ร่าง" | mkN "หมู่" | mkN "กลุ่ม" | mkN "บอดี้" | mkN "ลำตัว" | mkN "เหล่า" | mkN "ร่างกาย" | mkN "องค์รวม" | mkN "เรือนกาย" | mkN "เนื้อความ" | mkN "เรือนร่าง" | mkN "กล่องเสียง" | mkN "ความเหนียวข้น" | mkN "ร่างไร้วิญญาณ" | mkN "ส่วนประกอบหลัก" | mkN "โครงสร้างของรถ" | mkN "ร่างที่ปราศจากลมหายใจ" | mkN "ศพ" | mkN "ตัว" | mkN "มวล" | mkN "ร่าง" | mkN "ซากศพ" | mkN "วัตถุ" | mkN "สรีระ" | mkN "ลําตัว" | mkN "ลําต้น" | mkN "กลุ่มคน" | mkN "ข้อสรุป" | mkN "ทั้งตัว" | mkN "ร่างกาย" | mkN "ส่วนใหญ่" | mkN "เนื้อแท้" | mkN "เนื้อเรื่อง" | mkN "ทําให้เป็นรูปร่าง" | mkN "ใจความสําคัญของงานเขียน" | mkN "ส่วนประกอบหลักของยานพาหนะ" | mkN "ส่วนประกอบหลักของสิ่งต่าง ๆ" ; -- src=panlex
lin bodybuilder_N = mkN "นักเพาะกาย" | mkN "นักเพาะกล้าม" ; -- src=panlex
lin bodybuilding_N = mkN "การเพาะกาย" | mkN "การสร้างกล้ามเนื้อให้ใหญ่และแข็งแรงด้วยการออกกําลัง" ; -- src=panlex
lin bodyguard_N = mkN "องครักษ์" | mkN "บอดี้การ์ด" | mkN "ผู้คุ้มกัน" | mkN "ผู้อารักขา" | mkN "คณะผู้คุ้มกัน" | mkN "องครักษ์" | mkN "คนคุ้มกัน" | mkN "ราชองครักษ์" | mkN "มือปืนผู้คอยป้องกัน" ; -- src=panlex
lin bodywork_N = mkN "ตัวถัง" | mkN "โครงด้านนอกของรถ" ; -- src=panlex
lin boffin_N = mkN "นักวิจัยด้านวิทยาศาสตร์๋" | mkN "นักวิทยาศาสตร์" ; -- src=panlex
lin boffo_A = mkA "ประสบความสําเร็จมาก" ; -- src=panlex
lin bog_N = mkN "พรุ" | mkN "ห้วยหนอง" | mkN "บึง" | mkN "ห้วย" | mkN "หนองน้ํา" ; -- src=panlex
lin bog_V = mkV "เหนี่ยวรั้ง" | mkV "พบกับความยุ่งยาก" ; -- src=panlex
lin bog_V2 = mkV2 "เหนี่ยวรั้ง" ; ---- | mkV "พบกับความยุ่งยาก" ; -- src=panlex
lin bogey_N = mkN "โบกี้" | mkN "วิญญาณชั่วร้าย" | mkN "เครื่องบินไม่ทราบสัญชาติ" | mkN "ผี" | mkN "ปีศาจ" | mkN "คนที่น่ากลัว" | mkN "สิ่งที่ทําให้คนเดือดร้อน รําคาญหรือเกรงกลัว" ; -- src=panlex
lin bogeyman_N = mkN "โบกี้แมน" | mkN "ปีศาจในจินตนาการที่ใช้ขู่เด็กๆ" ; -- src=panlex
lin boggle_V = mkV "ลังเลใจ" | mkV "ตื่นตระหนก" | mkV "ประหลาดใจมาก" | mkV "ทําให้งุนงง" | mkV "ทําให้สับสน" | mkV "ทําให้เสียหาย" | mkV "ทําผิดพลาดเล็กๆ น้อยๆ" | mkV "รีรอที่จะทําสิ่งหนึ่งเพราะกลัวหรือกังวล" ; -- src=panlex
lin boggy_A = mkA "ซึ่งเป็นโคลน" | mkA "นิ่ม เปียกเหมือนกับ" ; -- src=panlex
lin bogie_N = mkN "วิญญาณชั่วร้าย" | mkN "เครื่องบินไม่ทราบสัญชาติ" | mkN "ผี" | mkN "ปีศาจ" | mkN "โบกี้" | mkN "ตู้รถไฟ" | mkN "คนที่น่ากลัว" ; -- src=panlex
lin bogus_A = mkA "ปลอม" | mkA "หลอก" | mkA "ไม่แท้" ; -- src=panlex
lin bogy_N = mkN "วิญญาณชั่วร้าย" | mkN "เครื่องบินไม่ทราบสัญชาติ" | mkN "สิ่งที่ทําให้คนเดือดร้อน รําคาญหรือเกรงกลัว" ; -- src=panlex
lin bohemian_N = mkN "โบฮีเมียน" ; -- src=panlex
lin bohrium_N = mkN "โบห์เรียม" | mkN "ธาตุโบห์เรียม" | mkN "เลขอะตอม 107" ; -- src=panlex
lin boil_N = mkN "ฝี" | mkN "พระยอด" | mkN "จุดเดือด" | mkN "เดือด" ; -- src=panlex
lin boil_V = mkV "ต้ม" | mkV "เดือด" | mkV "เดือดปุดๆ" | mkV "ต้มให้เดือด" | mkV "ต้ม" | mkV "ทําให้เดือด" ; -- src=panlex
lin boil_V2 = mkV2 "ต้ม" ; ---- | mkV "เดือด" | mkV "เดือดปุดๆ" | mkV "ต้มให้เดือด" | mkV "ต้ม" | mkV "ทําให้เดือด" ; -- src=panlex
lin boiler_N = mkN "กาต้มน้ำ" | mkN "บอยเลอร์" | mkN "หม้อตุ๋น" | mkN "หม้อต้มน้ำ" | mkN "ภาชนะหุงต้ม" | mkN "กาน้ํา" | mkN "เตาหม้อ" | mkN "หม้อน้ํา" | mkN "ภาชนะหุงต้ม" ; -- src=panlex
lin boilerplate_N = mkN "แผ่นโลหะภาชนะหุงต้ม" ; -- src=panlex
lin boiling_N = mkN "การต้ม" ; -- src=panlex
lin boisterous_A = mkA "อึง" | mkA "แซด" | mkA "หยาบ" | mkA "พล่าน" | mkA "เอะอะ" | mkA "ตูมตาม" | mkA "ปึงปัง" | mkA "หนวกหู" | mkA "อึกทึก" | mkA "เอ็ดอึง" | mkA "ครืนครั่น" | mkA "พลุกพล่าน" | mkA "เอิกเกริก" ; -- src=panlex
lin boisterousness_N = mkN "เสียงดัง" | mkN "ความอึกทึก" ; -- src=panlex
lin bola_N = mkN "โบลา" | mkN "โบโลไท" | mkN "เชือกโบลา" | mkN "เชือกโบล่า" ; -- src=panlex
lin bold_1_A = mkA "ที่กล้าหาญ" | mkA "กล้า" | mkA "ชั้น" | mkA "ถนัด" | mkA "ห้าว" | mkA "เด่น" | mkA "ชัดเจน" | mkA "ใจกล้า" | mkA "กล้าหาญ" | mkA "เห็นชัด" | mkA "หน้าด้าน" | mkA "หยาบใหญ่" ; -- src=panlex
lin bold_2_A = mkA "ที่กล้าหาญ" | mkA "กล้า" | mkA "ชั้น" | mkA "ถนัด" | mkA "ห้าว" | mkA "เด่น" | mkA "ชัดเจน" | mkA "ใจกล้า" | mkA "กล้าหาญ" | mkA "เห็นชัด" | mkA "หน้าด้าน" | mkA "หยาบใหญ่" ; -- src=panlex
lin boldface_N = mkN "ตัวหนา" | mkN "อักษรหนา" ; -- src=panlex
lin boldness_N = mkN "ความกล้า" | mkN "ความทรหด" | mkN "ความอาจหาญ" | mkN "กล้า" | mkN "ความกล้าหาญ" ; -- src=panlex
lin bole_N = mkN "ต้น" | mkN "ลำต้น" | mkN "ดินน้ำมัน" | mkN "ลําต้น" | mkN "ดินเหนียวที่มีสีต่าง ๆ" | mkN "ท่อหรือลําต้นของต้นไม้" ; -- src=panlex
lin bolero_N = mkN "โบเลโร" | mkN "ระบำสเปน" | mkN "เสื้อนอกเอวลอยไม่มีกระดุม" | mkN "การเต้นรําแบบสเปน" ; -- src=panlex
lin bolete_N = mkN "โบลีต" ; -- src=panlex
lin bolide_N = mkN "ลูกไฟ" ; -- src=panlex
lin bolivar_N = mkN "โบลิวาร์" ; -- src=panlex
lin bolivia_N = mkN "โบลิเวีย" ; -- src=panlex
lin boliviano_N = mkN "โบลิเวียโน" ; -- src=panlex
lin boll_N = mkN "สมอป่าน" | mkN "ส่วนของต้นฝ้ายที่มีเมล็ด" ; -- src=panlex
lin bollard_N = mkN "เสาผูกเรือ" | mkN "เสาที่ใช้ผูกเชือกเรือ" ; -- src=panlex
lin bollock_N = mkN "อัณฑะ" | mkN "เล็ดไข่" | mkN "พระอัณฑะ" | mkN "ลูกอัณฑะ" | mkN "ลูกกระแป๋ง" ; -- src=panlex
lin bolo_N = mkN "โบโลไท" | mkN "มีดโบโล" ; -- src=panlex
lin bologna_N = mkN "ไส้กรอก" | mkN "ไส้กรอกโบโลนญา" | mkN "ไส้กรอกขนาดใหญ่" | mkN "ไส้กรอกสําหรับทําแซนด์วิช" ; -- src=panlex
lin bologram_N = mkN "โบโลกราฟ" | mkN "โบโลแกรม" ; -- src=panlex
lin bolometer_N = mkN "โบโลมิเตอร์" | mkN "มาตรรังสีความร้อน" | mkN "เครื่องวัดรังสีความร้อน" | mkN "เครื่องมือวัดความต้านทานของตัวนําไฟฟ้า" ; -- src=panlex
lin boloney_N = mkN "เรื่องเหลวไหล" | mkN "เรื่องไร้สาระ" | mkN "คําพูดไร้สาระ คําพูดเหลวไหล" ; -- src=panlex
lin bolshevik_N = mkN "ผู้ที่มีหัวรุนแรง" | mkN "สมาชิกพรรคคอมมิวนิสต์" | mkN "สมาชิกพรรคคอมมิวนิสต์ของรัสเซีย" ; -- src=panlex
lin bolster_N = mkN "หมอนข้าง" | mkN "พระเขนยข้าง" | mkN "พระเขนยเคียง" | mkN "หมอนยาวทรงกระบอกที่ใช้เสริมหมอนใบอื่น" ; -- src=panlex
lin bolster_V = mkV "สนับสนุน" | mkV "เสริมเบาะ" | mkV "เสริม" | mkV "ค้ําจุน" | mkV "สนับสนุน" | mkV "หนุนให้สูง" ; -- src=panlex
lin bolster_V2 = mkV2 "สนับสนุน" ; ---- | mkV "เสริมเบาะ" | mkV "เสริม" | mkV "ค้ําจุน" | mkV "สนับสนุน" | mkV "หนุนให้สูง" ; -- src=panlex
lin bolt_Adv = mkAdv "ตรง" | mkAdv "อย่างแข็งแกร่ง" ; -- src=panlex
lin bolt_N = mkN "กลอน" | mkN "การโผ" | mkN "ม้วนผม" | mkN "สายฟ้า" | mkN "การละทิ้ง" | mkN "สายฟ้าฟาด" | mkN "การเผ่นหนี" | mkN "สลัก" | mkN "ม้วนผ้า" | mkN "กลอนประตู" | mkN "แสงแปลบปลาบของฟ้าแล็บ" ; -- src=panlex
lin bolt_V = mkV "ลงกลอน" | mkV "รีบกลืน" | mkV "เผ่นหนี" | mkV "ใส่กลอน" | mkV "รีบเดินออก" | mkV "กลืนพรวดเดียว" | mkV "วิ่งหนี" | mkV "ไม่สนับสนุน" | mkV "ใส่กลอนประตู" | mkV "รีบกลืนอาหารโดยไม่ได้เคี้ยว" ; -- src=panlex
lin bolt_V2 = mkV2 "ลงกลอน" ; ---- | mkV "รีบกลืน" | mkV "เผ่นหนี" | mkV "ใส่กลอน" | mkV "รีบเดินออก" | mkV "กลืนพรวดเดียว" | mkV "วิ่งหนี" | mkV "ไม่สนับสนุน" | mkV "ใส่กลอนประตู" | mkV "รีบกลืนอาหารโดยไม่ได้เคี้ยว" ; -- src=panlex
lin bolti_N = mkN "ปลาโบลติ" ; -- src=panlex
lin bolus_N = mkN "เม็ดยาขนาดใหญ่" ; -- src=panlex
lin bomb_N = mkN "ระเบิด" | mkN "ลูกระเบิด" | mkN "ความล้มเหลว" | mkN "ระเบิด" | mkN "ลูกระเบิด" ; -- src=panlex
lin bomb_V = mkV "สอบตก" | mkV "ซ้ำชั้น" | mkV "ทิ้งระเบิด" | mkV "ทิ้งระเบิดทําลาย" ; -- src=panlex
lin bomb_V2 = mkV2 "สอบตก" ; ---- | mkV "ซ้ำชั้น" | mkV "ทิ้งระเบิด" | mkV "ทิ้งระเบิดทําลาย" ; -- src=panlex
lin bombardier_N = mkN "ทหารชั้นประทวน" | mkN "ปืนใหญ่" | mkN "ทหารปืนใหญ่" | mkN "พลทิ้งลูกระเบิด" | mkN "มือทิ้งระเบิดบนเครื่องบิน" ; -- src=panlex
lin bombardment_N = mkN "การระดมยิง" | mkN "การทิ้งบอมบ์" | mkN "การทิ้งระเบิด" | mkN "การใช้ปืนใหญ่ระดมยิง" | mkN "การโจมตีโดยการใช้ระเบิดหรือปืนที่มีอานุภาพร้ายแรง" ; -- src=panlex
lin bombardon_N = mkN "บอมบาดอน" ; -- src=panlex
lin bombast_N = mkN "คำพูดสวยหรู" | mkN "คำพูดไร้สาระ" | mkN "การกล่าวเยินยอ" | mkN "คนโว" | mkN "นุ่นยัด" | mkN "คําพูดโว" | mkN "เครื่องรอง" | mkN "คําพูดยาวๆที่พูดเพื่อเอาใจคนอื่น" ; -- src=panlex
lin bombastic_A = mkA "ที่คุยโว" | mkA "ซึ่งคุยโว" | mkA "ซึ่งคุยเขื่อง" ; -- src=panlex
lin bombazine_N = mkN "ผ้าไหมลายสอง" ; -- src=panlex
lin bomber_N = mkN "แซนด์วิชยักษ์" | mkN "แซนด์วิชอิตาลี" | mkN "เครื่องบินทิ้งระเบิด" | mkN "ผู้วางแผนการทิ้งระเบิด" | mkN "เครื่องบินทิ้งระเบิด" ; -- src=panlex
lin bombie_N = mkN "บอมบี" | mkN "ระเบิดลูกเล็กๆ" ; -- src=panlex
lin bombing_N = mkN "การทิ้งบอมบ์" | mkN "การทิ้งระเบิด" | mkN "การใช้ระเบิดก่อการร้าย" | mkN "การทิ้งระเบิด" ; -- src=panlex
lin bomblet_N = mkN "ลูกปราย" ; -- src=panlex
lin bombshell_N = mkN "การตกตะลึง" | mkN "บอมบ์เชลล์" | mkN "ลูกระเบิด" | mkN "สิ่งที่น่าตกใจ" | mkN "ผู้ที่น่าตกใจกลัว" | mkN "ข่าวไม่ค่อยดีที่ได้รับรู้อย่างปัจจุบันทันด่วน" ; -- src=panlex
lin bomb_sight_N = mkN "ศูนย์เล็งทิ้งระเบิด" | mkN "เครื่องเล็งเป้าการยิงหรือทิ้งระเบิด" ; -- src=panlex
lin bonanza_N = mkN "นาทีทอง" | mkN "ลูกฟลุ้ก" | mkN "โอกาสทอง" | mkN "ความร่ำรวย" | mkN "ปาฏิหาริย์" | mkN "ลูกส้มหล่น" | mkN "ขุมแร่ใหญ่" | mkN "ขุมแร่มีค่า" | mkN "ขุมทรัพย์มหาศาล" | mkN "โชคลาภที่ยิ่งใหญ่" | mkN "สินแร่จํานวนมหาศาล" | mkN "ทรัพย์สมบัติที่ปรากฎขึ้นอย่างกะทันหัน" | mkN "แหล่งหรือสิ่งที่ทําให้ร่ํารวยขึ้นในพริบตา" ; -- src=panlex
lin bonbon_N = mkN "บ็อนบ็อน" | mkN "ขนมหวาน" | mkN "ขนมหวานที่นิ่มตรงกลาง" ; -- src=panlex
lin bond_N = mkN "พันธะ" | mkN "กรมธรรม์" | mkN "พันธบัตร" | mkN "การผูกติด" | mkN "การผูกมัด" | mkN "การยึดติด" | mkN "พันธนาการ" | mkN "พันธะเคมี" | mkN "การเกี่ยวดอง" | mkN "ใบแทนพันธบัตร" | mkN "กระดาษคุณภาพดี" | mkN "ข้อผูกมัด" | mkN "พันธนาการ" ; -- src=panlex
lin bondable_A = mkA "ซึ่งใช้เชือกผูกได้" | mkA "ซึ่งยึดเหนี่ยวกันได้" ; -- src=panlex
lin bondage_N = mkN "ความเป็นทาส" | mkN "การตกเป็นทาส" | mkN "การผูกมัด" | mkN "ความเป็นทาส" | mkN "ภาวะที่เป็นทาส" ; -- src=panlex
lin bond_holder_N = mkN "ผู้ถือกรมธรรม์" | mkN "ผู้มีพันธบัตรหรือใบหุ้นกู้" ; -- src=panlex
lin bonding_N = mkN "พันธะ" | mkN "การบัดกรี" | mkN "ความผูกพัน" | mkN "การผนึก" | mkN "การบัดกรี" | mkN "การเชื่อม" | mkN "การเชื่อมกําบัง" ; -- src=panlex
lin bondman_N = mkN "ทาสชาย" | mkN "ทาส" | mkN "บ่าว" | mkN "ขี้ข้า" | mkN "ข้าทาส" | mkN "ทาสชาย" | mkN "คนรับใช้" | mkN "ข้ารับใช้" ; -- src=panlex
lin bondsman_N = mkN "ทาสชาย" | mkN "ทาส" | mkN "ผู้ค้ําประกัน" ; -- src=panlex
lin bonduc_N = mkN "ต้นบอนดัก" | mkN "ต้นเคนตักกี้คอฟฟี่ทรี" ; -- src=panlex
lin bondwoman_N = mkN "นางทาส" | mkN "ทาสหญิง" | mkN "ทาส" | mkN "ทาสี" | mkN "ทาสผู้หญิง" ; -- src=panlex
lin bone_A = mkA "ที่ทำด้วยกระดูก" ; -- src=panlex
lin bone_N = mkN (thword "กระ" "ดูก") | {-pan-} mkN "สีนวล" | mkN "กระดูก" | mkN "พระอัฐิ" | mkN "สีงาช้าง" | mkN "กระดูกกระเดี้ยว" | mkN "ก้าง" | mkN "กระดูก" | mkN "วัตถุหรือสารสีขาวจากร่างกายสัตว์" ; -- src=panlex
lin bonefish_N = mkN "ปลาโบนฟิช" ; -- src=panlex
lin boneless_A = mkA "ที่ไร้กระดูก" | mkA "ที่ไม่มีกระดูก" ; -- src=panlex
lin bonelike_A = mkA "ที่คล้ายกระดูก" | mkA "ที่เหมือนกระดูก" ; -- src=panlex
lin bonemeal_N = mkN "กระดูกป่น" | mkN "ปุ๋ยที่ได้จากกระดูกสัตว์ป่น" ; -- src=panlex
lin boner_N = mkN "การทำผิดพลาด" | mkN "ความผิดที่น่าอับอาย" | mkN "ความผิดที่น่าอับอาย" ; -- src=panlex
lin bones_N = mkN "กรับ" | mkN "กรับมือ" ; -- src=panlex
lin boneset_N = mkN "ต้นโบนเซต" ; -- src=panlex
lin bone_setter_N = mkN "หมอกระดูก" | mkN "แพทย์กระดูก" ; -- src=panlex
lin bonfire_N = mkN "กองไฟ" | mkN "กองไฟ" | mkN "กองไฟที่จุดขึ้นกลางแจ้ง" | mkN "กองไฟขนาดใหญ่ที่สุมอยู่กลางแจ้ง" ; -- src=panlex
lin bong_N = mkN "เสียงเหง่งหง่าง" ; -- src=panlex
lin bongo_N = mkN "บองโก" | mkN "กลองเล็ก" | mkN "กลองบองโก" | mkN "กลองเล็ก" | mkN "ละมั่งมีสีแดงน้ําตาล" ; -- src=panlex
lin bonhomie_N = mkN "ความเป็นมิตร" | mkN "มิตร ไมตรี" | mkN "ความมีมิตรไมตรี" | mkN "ความร่าเริงชื่นบาน" ; -- src=panlex
lin bonito_N = mkN "ปลาโบนิโต" | mkN "เนื้อปลาโบนิโต" ; -- src=panlex
lin bonkers_A = mkA "บ้าคลั่ง" ; -- src=panlex
lin bonnet_N = mkN "ฝากระโปรงรถ" | mkN "หมวกที่มีผ้าผูกใต้คาง" | mkN "หมวกสตรี" ; -- src=panlex
lin bonny_A = mkA "ดี" | mkA "สบายใจ" | mkA "สวยงาม" | mkA "ร่าเริง" | mkA "เจริญตา" | mkA "เงียบสงบ" | mkA "น่าดึงดูด" | mkA "สุขภาพแข็งแรง" | mkA "น่ารักและมีสุขภาพดี" ; -- src=panlex
lin bonsai_N = mkN "บอนไซ" | mkN "ต้นไม้แคระ" | mkN "ต้นไม้แคระ" | mkN "ศิลปะการปลูกต้นไม้แคระ" ; -- src=panlex
lin bonus_N = mkN "โบนัส" | mkN "รางวัล" | mkN "เงินโบนัส" | mkN "เงิน" | mkN "โบนัส" | mkN "เงินแถม" | mkN "สินน้ําใจ" | mkN "เงินเพิ่ม" | mkN "เงินโบนัส" | mkN "รางวัลพิเศษ" | mkN "สิ่งกระตุ้น" | mkN "รางวัลสมนาคุณ" | mkN "เครื่องกระตุ้น" | mkN "เงินปันผลกําไร" | mkN "เงินที่ได้พิเศษนอกเหนือจากเงินเดือน" ; -- src=panlex
lin bony_A = mkA "ที่มีแต่กระดูก" | mkA "ผอมเห็นซี่โครง" | mkA "เหลือแต่กระดูก" | mkA "ผอมเหลือแต่ซี่โครง" | mkA "คล้ายกระดูก" | mkA "มีกระดูกใหญ่" | mkA "เกี่ยวกับกระดูก" | mkA "เต็มไปด้วยกระดูก" ; -- src=panlex
lin boo_N = mkN "เสียงโห่ร้อง" | mkN "เสียงร้องแสดงความโกรธ" ; -- src=panlex
lin boo_V = mkV "โห่" ; -- src=panlex
lin boo_V2 = mkV2 "โห่" ; ---- ; -- src=panlex
lin boob_N = mkN "นม" | mkN "ถัน" | mkN "เต้า" | mkN "พระถัน" | mkN "หน้าอก" | mkN "เต้านม" | mkN "คนเปิ่น" | mkN "พระเต้า" | mkN "คนปล่อยไก่" | mkN "หน้าอกหน้าใจ" | mkN "หน้าอกของผู้หญิง" | mkN "หน้าอกผู้หญิง" ; -- src=panlex
lin boob_V = mkV "ทำผิดพลาดร้ายแรง" ; -- src=panlex
lin booboisie_N = mkN "ชนชันที่ไร้การศึกษา" ; -- src=panlex
lin booby_N = mkN "นกบูบี" | mkN "คนเปิ่น" | mkN "คนปล่อยไก่" | mkN "คนโง่" | mkN "คนเซ่อ" | mkN "คนที่เล่นเลวที่สุดในทีม" | mkN "คนที่ได้คะแนนน้อยที่สุด" ; -- src=panlex
lin boodle_N = mkN "ตังค์" | mkN "ชิคาโก" | mkN "ปัจจัย" | mkN "สตางค์" | mkN "มิชิแกน" | mkN "สะตุ้งสตางค์" ; -- src=panlex
lin booger_N = mkN "ขี้มูก" | mkN "โบกี้แมน" | mkN "ขี้มูกแห้ง" ; -- src=panlex
lin boogie_N = mkN "บูกี" | mkN "บูกี-วูกี" | mkN "เพลงแบบหนึ่งที่เล่นกับเปียนโน" ; -- src=panlex
lin book_N = mkN (thword nag_s svv_s) lem_s | {-pan-} mkN "สมุด" | mkN "เล่ม" | mkN "บัญชี" | mkN "บันทึก" | mkN "สคริปต์" | mkN "หนังสือ" | mkN "การบันทึก" | mkN "สมุดบัญชี" | mkN "สมุดบันทึก" | mkN "ประมวลกฏเกณฑ์" | mkN "หนังสือหนังหา" | mkN "หนังสือกฏระเบียบ" | mkN "การจอง" | mkN "หนังสือ" ; -- src=panlex
lin bookable_A = mkA "ซึ่งจองล่วงหน้าได้" ; -- src=panlex
lin bookbinder_N = mkN "ช่างทำหนังสือ" | mkN "คนเข้าเล่มหนังสือ" | mkN "คนเย็บเล่มหนังสือ" | mkN "คนเย็บเล่มหนังสือ" ; -- src=panlex
lin bookbindery_N = mkN "โรงงานเข้าเล่มหนังสือ" | mkN "ร้านทําปกหนังสือ" | mkN "ร้านเข้าปกหนังสือ" ; -- src=panlex
lin bookbinding_N = mkN "งานเข้าเล่มหนังสือ" | mkN "การทําปกหนังสือ" | mkN "การเข้าปกหนังสือ" ; -- src=panlex
lin bookcase_N = mkN "ตู้หนังสือ" | mkN "ชั้นวางหนังสือ" | mkN "ตู้หนังสือ" | mkN "ตู้หรือชั้นสําหรับใส่หนังสือ" ; -- src=panlex
lin bookclub_N = mkN "ชมรมคนรักหนังสือ" | mkN "กลุ่มคนรักหนังสือ" ; -- src=panlex
lin bookdealer_N = mkN "คนขายหนังสือ" ; -- src=panlex
lin book_end_N = mkN "ที่หนีบค้ําแถวหนังสือให้ตั้งตรง" ; -- src=panlex
lin bookie_N = mkN "เจ้ามือ" | mkN "คนรับแทง" | mkN "เจ้ามือรับแทง" | mkN "เจ้ามือรับแทงม้า" | mkN "คนรับแทงม้า" | mkN "คนทําหนังสือ" | mkN "เจ้ามือรับแทงม้า" ; -- src=panlex
lin booking_N = mkN "การจอง" | mkN "การจ้างนักแสดง" | mkN "สัญญา" | mkN "การจอง" | mkN "การตกลง" | mkN "การจองล่วงหน้า" ; -- src=panlex
lin bookish_A = mkA "ชอบศึกษา" | mkA "หนอนหนังสือ" | mkA "ชอบอ่านหนังสือ" | mkA "เกี่ยวกับหนังสือ" | mkA "เกี่ยวกับอักษรศาสตร์" ; -- src=panlex
lin book_keeper_N = mkN "คนทำบัญชี" | mkN "คนทําบัญชี" ; -- src=panlex
lin bookkeeping_N = mkN "การทำบัญชี" | mkN "การทําบัญชี" | mkN "วิชาการทําบัญชี" ; -- src=panlex
lin booklet_N = mkN "แผ่นพับ" | mkN "โบรชัวร์" | mkN "หนังสือเล่มเล็กๆ" | mkN "หนังสือเล่มเล็ก" | mkN "หนังสือเล่มเล็ก ๆ" ; -- src=panlex
lin bookmaker_N = mkN "เจ้ามือ" | mkN "คนรับแทง" | mkN "คนทำหนังสือ" | mkN "ช่างหนังสือ" | mkN "ช่างทำหนังสือ" | mkN "เจ้ามือรับแทง" | mkN "เจ้ามือรับแทงม้า" | mkN "คนรับแทงม้า" | mkN "คนทําหนังสือ" | mkN "เจ้ามือรับแทงม้า" ; -- src=panlex
lin bookmark_N = mkN "บุ๊คมาร์ค" | mkN "ที่คั่นหนังสือ" | mkN "ที่คั่นหนังสือ" ; -- src=panlex
lin bookmarker_N = mkN "บุ๊คมาร์ค" | mkN "ที่คั่นหนังสือ" ; -- src=panlex
lin bookmobile_N = mkN "ห้องสมุดเคลื่อนที่" | mkN "รถห้องสมุดเคลื่อนที่" | mkN "ห้องสมุดเคลื่อนที่" ; -- src=panlex
lin bookplate_N = mkN "ป้ายแสดงชื่อ" ; -- src=panlex
lin bookseller_N = mkN "คนขายหนังสือ" | mkN "คนขายหนังสือ" ; -- src=panlex
lin bookshelf_N = mkN "ชั้นวางหนังสือ" | mkN "ชั้นหนังสือ" | mkN "หิ้งหนังสือ" | mkN "ที่ตั้งหนังสือ" ; -- src=panlex
lin bookshop_N = mkN "แผงหนังสือ" | mkN "ร้านหนังสือ" | mkN "แผงขายหนังสือ" | mkN "ร้านขายหนังสือ" ; -- src=panlex
lin bookstall_N = mkN "แผงหนังสือ" | mkN "ร้านหนังสือ" | mkN "แผงขายหนังสือ" | mkN "ร้านขายหนังสือ" | mkN "ร้านหนังสือเล็ก" | mkN "ที่สําหรับตั้งหนังสืออ่าน" ; -- src=panlex
lin bookstore_N = mkN "แผงหนังสือ" | mkN "ร้านหนังสือ" | mkN "แผงขายหนังสือ" | mkN "ร้านขายหนังสือ" | mkN "ร้านหนังสือ" | mkN "ร้านขายหนังสือ" ; -- src=panlex
lin bookworm_N = mkN "นักอ่าน" | mkN "หนอนหนังสือ" | mkN "คนรักการอ่าน" | mkN "คนชอบอ่านหนังสือ" | mkN "ปลวกหนังสือ" | mkN "หนอนหนังสือ" | mkN "หนอนกัดกินหนังสือ" | mkN "คนที่ชอบเรียนหนังสือมาก" | mkN "ผู้ที่ชอบอ่านหนังสือมาก" ; -- src=panlex
lin boom_N = mkN "นาทีทอง" | mkN "ลูกฟลุ้ก" | mkN "โอกาสทอง" | mkN "ปาฏิหาริย์" | mkN "ลูกส้มหล่น" | mkN "เศรษฐกิจบูม" | mkN "ความรุ่งโรจน์" | mkN "เสียงโครมคราม" | mkN "คันชักไม้แขวนไมโครโฟน" | mkN "ความเจริญรุ่งเรืองทางเศรษฐกิจ" | mkN "ขุมทอง" | mkN "เสียงดัง" | mkN "เสียงตูม" | mkN "โอกาสทอง" | mkN "เสียงตึงตัง" | mkN "เสียงตูมตาม" | mkN "ขาตั้งไมโครโฟน" | mkN "ความเจริญรุ่งเรือง" | mkN "ไม้ขวางที่ผูกข้างเรือ" | mkN "ความเจริญรุ่งเรืองทางเศรษฐกิจ" ; -- src=panlex
lin boom_V = mkV "บูม" | mkV "เติบโต" | mkV "ตีเต็มแรง" | mkV "รุ่งเรือง" | mkV "เกิดฟ้าร้อง" | mkV "ตีสุดแรงเกิด" | mkV "ทำเสียงทุ้มต่ำ" | mkV "ส่งเสียงดังกึกก้อง" | mkV "ตี" | mkV "ตีอย่างแรง" | mkV "เปล่งเสียง" | mkV "เปล่งเสียงดัง" | mkV "เจริญรุ่งเรือง" ; -- src=panlex
lin boom_V2 = mkV2 "บูม" ; ---- | mkV "เติบโต" | mkV "ตีเต็มแรง" | mkV "รุ่งเรือง" | mkV "เกิดฟ้าร้อง" | mkV "ตีสุดแรงเกิด" | mkV "ทำเสียงทุ้มต่ำ" | mkV "ส่งเสียงดังกึกก้อง" | mkV "ตี" | mkV "ตีอย่างแรง" | mkV "เปล่งเสียง" | mkV "เปล่งเสียงดัง" | mkV "เจริญรุ่งเรือง" ; -- src=panlex
lin boomerang_N = mkN "บูมเมอแรง" | mkN "บูมเมอแรง" | mkN "สิ่งที่ให้ผลร้ายแบบไม่คาดคิดแก่ผู้ที่ทําหรือพูดออกไป" ; -- src=panlex
lin boon_A = mkA "มีความกรุณา" | mkA "ที่สนุกสนานร่าเริง" ; -- src=panlex
lin boon_N = mkN "บุญกุศล" | mkN "คุณประโยชน์" | mkN "กรุณา" | mkN "บุญคุณ" | mkN "สนุกเฮฮา" | mkN "คุณานุปการ" | mkN "โอบอ้อมอารี" | mkN "ผลประโยชน์ที่ได้รับ" | mkN "สิ่งที่เป็นประโยชน์" | mkN "สิ่งที่ช่วยอํานวยความสะดวก" | mkN "สิ่งที่เรียกร้องหรือต้องการ" ; -- src=panlex
lin boondoggle_N = mkN "งานที่ไม่ค่อยมีค่า" | mkN "งานที่สูญเสียเวลาและ/หรือเงิน" ; -- src=panlex
lin boor_N = mkN "คนเถื่อน" | mkN "คนชั้นต่ำ" | mkN "คนงุ่มง่าม" | mkN "คนไร้การศึกษา" | mkN "ชาวนา" | mkN "ตาสีตาสา" | mkN "คนบ้านนอก" | mkN "คนหยาบคาย" | mkN "คนชั้นต่ํา" ; -- src=panlex
lin boorish_A = mkA "หยาบคาย" | mkA "คล้ายคนบ้านนอก" ; -- src=panlex
lin boorishness_N = mkN "ความหยาบคาย" ; -- src=panlex
lin boost_N = mkN "การขึ้นราคา" | mkN "การส่งเสริม" | mkN "การให้กำลังใจ" ; -- src=panlex
lin booster_N = mkN "บูสเตอร์" | mkN "คนจิ๊กของ" | mkN "จรวดช่วยส่ง" | mkN "ผู้สนับสนุน" | mkN "ผู้หนุนหลัง" | mkN "คนขโมยของในร้าน" | mkN "ผู้ให้การสนับสนุน" | mkN "เครื่องเพิ่มกำลัง" | mkN "เครื่องส่งจรวดขึ้นท้องฟ้า" | mkN "ผู้ยก" | mkN "ผู้เลื่อน" | mkN "การส่งเสริม" | mkN "ผู้สนับสนุน" | mkN "สิ่งกระตุ้น" | mkN "สิ่งที่สนับสนุน" | mkN "เครื่องเพิ่มกําลัง" | mkN "ท่อนแรกของจรวดหลายท่อน" ; -- src=panlex
lin boot_N = mkN (thword "รอง" "เท้า" "บูท") "คู่" | {-pan-} mkN "บูท" | mkN "การเตะ" | mkN "เกือกบูท" | mkN "การจู่โจม" | mkN "รองเท้าบูท" | mkN "ช่องหยอดเหรียญ" | mkN "เครื่องบีบทรมานเท้า" | mkN "เท้าที่ถูกเครื่องทรมานบีบ" | mkN "บู๊ต" | mkN "รองเท้าบูท" | mkN "รองเท้าหุ้มข้อเท้า" ; -- src=panlex
lin bootblack_N = mkN "คนขัดรองเท้า" ; -- src=panlex
lin bootee_N = mkN "รองเท้าไหมพรม" | mkN "รองเท้าถักไหมพรม" | mkN "ถุงเท้าทารก" ; -- src=panlex
lin booth_N = mkN "บูท" | mkN "บูธ" | mkN "ซุ้ม" | mkN "ซุ้มขายสินค้า" | mkN "บูธในร้านอาหาร" | mkN "ซุ้มสำหรับออกร้าน" | mkN "พื้นที่เล็กที่จัดไว้" | mkN "ศอก" | mkN "แผงลอย" | mkN "ห้องเล็ก ต่างหาก" | mkN "โต๊ะแยกเฉพาะส่วน" | mkN "หน่วยลงบัตรเลือกตั้ง" ; -- src=panlex
lin bootjack_N = mkN "ที่ถอดรองเท้าบูต" ; -- src=panlex
lin bootlace_N = mkN "เชือกผูกรองเท้าบูท" | mkN "เชือกผูกรองเท้า" | mkN "สายผูกเชือกรองเท้า" | mkN "เชือกผูกรองเท้าบู๊ท" ; -- src=panlex
lin bootleg_A = mkA "เถื่อน" ; -- src=panlex
lin bootleg_N = mkN "เหล้าเถื่อน" | mkN "ส่วนบนของรองเท้าบูท" ; -- src=panlex
lin bootlegger_N = mkN "คนขายเหล้าเถื่อน" ; -- src=panlex
lin bootlegging_N = mkN "การขายสุราเถื่อน" | mkN "การขายสินค้าละเมิดลิขสิทธิ์" ; -- src=panlex
lin bootless_A = mkA "ที่ไม่ประสบผล" | mkA "ซึ่งไร้ประโยชน์" | mkA "ไร้ประโยชน์" ; -- src=panlex
lin bootmaker_N = mkN "ช่างรองเท้าบูท" | mkN "ช่างทำรองเท้าบูท" ; -- src=panlex
lin bootstrap_N = mkN "สายรัดรองเท้าบูท" | mkN "ห่วงหลังรองเท้าบูต" ; -- src=panlex
lin booty_N = mkN "ของโจร" | mkN "ทรัพย์สินที่ปล้นมา" | mkN "ของโจร" | mkN "ของขโมย" | mkN "ของที่ปล้นสะดมมา" ; -- src=panlex
lin booze_N = mkN "สุรา" | mkN "เหล้า" | mkN "น้ำจัณฑ์" | mkN "สุราเมรัย" | mkN "เครื่องดื่มสีอัมพัน" ; -- src=panlex
lin booze_V = mkV "กิน" | mkV "ดื่ม" | mkV "กินเหล้า" | mkV "ดื่มเหล้า" | mkV "ดื่มแอลกอฮอล์อย่างมาก" ; -- src=panlex
lin boozer_N = mkN "ขี้เมา" | mkN "ขี้เหล้า" | mkN "คนขี้เมา" | mkN "คนขี้เหล้า" | mkN "ผู้ติดสุราเรื้อรัง" | mkN "ผู้ป่วยสุราเรื้อรัง" | mkN "ผับ" | mkN "คนดื่มเหล้ามาก" ; -- src=panlex
lin boozy_A = mkA "เมา" | mkA "ติดเหล้า" | mkA "ชอบดื่มเหล้า" | mkA "ซึ่งดื่มเหล้า" ; -- src=panlex
lin bop_N = mkN "บ๊อป" | mkN "บีบ็อป" | mkN "การเต้นเพลงป็อบ" ; -- src=panlex
lin bopeep_N = mkN "การเล่นจ๊ะเอ๋" ; -- src=panlex
lin borage_N = mkN "โบราจ" | mkN "ต้นไม้มีดอกสีฟ้าแถบเมดิเตอร์เรเนียน" ; -- src=panlex
lin borate_N = mkN "บอเรต" ; -- src=panlex
lin borax_N = mkN "บอแรกซ์" | mkN "แร่บอแรกซ์" | mkN "ยากันบูด" | mkN "ยาโรยแผล" | mkN "สารบอแรกซ์" | mkN "น้ําประสานทอง" ; -- src=panlex
lin bordeaux_N = mkN "ชื่อเหล้าองุ่น" | mkN "ชื่อเมืองในฝรั่งเศส" ; -- src=panlex
lin bordelaise_N = mkN "ซอสโบร์เดอเลส" ; -- src=panlex
lin border_N = mkN "ขอบ" | mkN "ขอทาน" | mkN "เส้นแบ่งเขต" | mkN "ขอบ" | mkN "กรอบ" | mkN "ขอบนอก" | mkN "ขอบเขต" | mkN "ชายแดน" | mkN "พรมแดน" | mkN "เขตแดน" | mkN "เส้นรอบวง" ; -- src=panlex
lin border_V = mkV "ติด" | mkV "ล้อม" | mkV "ประชิด" | mkV "ล้อมรอบ" | mkV "ใส่กรอบ" | mkV "ขีดเส้นแบ่งเขต" | mkV "สร้างขอบเขต" ; -- src=panlex
lin border_V2 = mkV2 "ติด" ; ---- | mkV "ล้อม" | mkV "ประชิด" | mkV "ล้อมรอบ" | mkV "ใส่กรอบ" | mkV "ขีดเส้นแบ่งเขต" | mkV "สร้างขอบเขต" ; -- src=panlex
lin borderland_N = mkN "พรมแดน" | mkN "พรมแดน" | mkN "ความก้ํากึ่ง" | mkN "ภาวะที่ไม่แน่นอน" | mkN "เขตแดนที่คลุมเครือ" ; -- src=panlex
lin borderline_A = mkA "ก้ํากึ่ง" | mkA "ตามชายแดน" | mkA "ตามพรมแดนตามชายแดน" ; -- src=panlex
lin borderline_N = mkN "เส้นเขตแดน" | mkN "เส้นแสดงเขต" | mkN "เส้นแบ่งขอบเขต" ; -- src=panlex
lin bore_N = mkN "รู" | mkN "คลื่น" | mkN "รูเจาะ" | mkN "รอยเจาะ" | mkN "คนขี้เบื่อ" | mkN "ความกว้างของลำกล้องปืน" | mkN "เส้นผ่าศูนย์กลางลำกล้อง" | mkN "เส้นผ่าศูนย์กลางของปากลำกล้อง" ; -- src=panlex
lin bore_V = mkV "เจาะ" | mkV "ทำให้เบื่อ" | mkV "ไช" | mkV "ด้น" | mkV "ทะลุ" | mkV "ระอา" | mkV "เจาะ" | mkV "ไชชอน" | mkV "เบื่อหน่าย" ; -- src=panlex
lin bore_V2 = mkV2 "เจาะ" ; ---- | mkV "ทำให้เบื่อ" | mkV "ไช" | mkV "ด้น" | mkV "ทะลุ" | mkV "ระอา" | mkV "เจาะ" | mkV "ไชชอน" | mkV "เบื่อหน่าย" ; -- src=panlex
lin boreal_A = mkA "ลม เหนือ" | mkA "เหนือ" | mkA "ทางเหนือ" ; -- src=panlex
lin bored_A = mkA "ซึ่งรู้สึกเบื่อหน่าย" | mkA "ที่น่าเบื่อ" ; -- src=panlex
lin boredom_N = mkN "ความเบื่อหน่าย" | mkN "ระอา" | mkN "ความเบื่อหน่าย" | mkN "ความเหนื่อยหน่าย" | mkN "ความน่าเบื่อหน่าย" | mkN "ภาวะน่าเบื่อหน่าย" ; -- src=panlex
lin borer_N = mkN "ดอกสว่าน" | mkN "สว่านเจาะหิน" | mkN "สัตว์จำพวกเจาะเนื้อไม้" | mkN "สว่าน" | mkN "ผู้เจาะรู" | mkN "หนอนเจาะรู" | mkN "สิ่งที่เจาะรู" | mkN "เครื่องเจาะรู" | mkN "แมลงที่เจาะรูต้นไม้หรือผลไม้" ; -- src=panlex
lin boring_A = mkA "น่าเบื่อ" ; -- src=panlex
lin boring_N = mkN "การเจาะ" | mkN "การขุดเจาะน้ำมัน" | mkN "การขุด" | mkN "การเจาะ" | mkN "การเจาะรู" | mkN "การขุดน้ํามัน" | mkN "การเจาะน้ํามัน" ; -- src=panlex
lin bornite_N = mkN "บอร์ไนต์" | mkN "แร่บอร์ไนต์" | mkN "สินแร่สีนกยูง" ; -- src=panlex
lin boron_N = mkN "โบรอน" | mkN "ธาตุโบรอน" | mkN "เลขอะตอม 5" | mkN "โบรอน" | mkN "ธาตุชนิดหนึ่ง" ; -- src=panlex
lin borosilicate_N = mkN "บอโรซิลิเกต" ; -- src=panlex
lin borough_N = mkN "เขตบูโรฮ์" | mkN "เมืองบูโรฮ์" | mkN "เมืองเล็กๆ ที่ปกครองตนเอง" | mkN "เขตเลือกตั้ง" | mkN "เขตเทศบาลที่เล็กกว่าเมือง" ; -- src=panlex
lin borrelia_N = mkN "เชื้อบอร์รีเลีย" ; -- src=panlex
lin borrow_V = mkV "ยืม" | mkV "ขอยืม" | mkV "รับมาใช้" | mkV "กู้" | mkV "ยืม" | mkV "เข้า" | mkV "ขอยืม" | mkV "กู้ยืม" | mkV "รับเอา" | mkV "หยิบยืม" ; -- src=panlex
lin borrow_V2 = mkV2 "ยืม" ;
lin borrow_VV = mkVV "ยืม" ;
lin borrower_N = mkN "ผู้ยืม" | mkN "ผู้ขอยืม" ; -- src=panlex
lin borrowing_N = mkN "การยืม" | mkN "เงินหรือสิ่งที่ให้ยืม" ; -- src=panlex
lin borsch_N = mkN "ซุปเนื้อ" | mkN "ซุปหัวบีตแดงเนื้อ" ; -- src=panlex
lin borstal_N = mkN "สถานดัดสันดาน" | mkN "สถานกักกันเยาวชน" ; -- src=panlex
lin borzoi_N = mkN "สุนัขพันธุ์บอร์ซอย" | mkN "สุนัขพันธุ์รัสเซียน วูลฟ์เฮานด์" | mkN "สุนัขสูงพันธุ์หนึ่ง" ; -- src=panlex
lin bosh_N = mkN "เรื่องเหลวไหล" | mkN "เรื่องไร้สาระ" ; -- src=panlex
lin bosom_N = mkN "นม" | mkN "ใจ" | mkN "จิต" | mkN "ถัน" | mkN "เต้า" | mkN "จิตใจ" | mkN "พระถัน" | mkN "หน้าอก" | mkN "เต้านม" | mkN "พระเต้า" | mkN "อกเสื้อ" | mkN "หน้าอกหน้าใจ" | mkN "ความรักแนบแน่น" | mkN "หน้าอกของผู้หญิง" | mkN "การสวมกอดอย่างรักใคร่" | mkN "อก" | mkN "ถัน" | mkN "สันอก" | mkN "น้ําใจ" | mkN "หน้าอก" | mkN "อกเสิ้อ" | mkN "อกเสื้อ" | mkN "เต้านมสตรี" | mkN "สถานที่อบอุ่นใจและน่าอยู่" ; -- src=panlex
lin bosomed_A = mkA "มีหน้าอก" | mkA "ปิดบังไว้" ; -- src=panlex
lin bosomy_A = mkA "มีหน้าอกใหญ่" ; -- src=panlex
lin boson_N = mkN "โบซอน" ; -- src=panlex
lin boss_N = mkN (thword "เจ้า" "นาย")" คน" | {-pan-} mkN "นาย" | mkN "บอส" | mkN "ปุ่ม" | mkN "นายจ้าง" | mkN "หัวหน้า" | mkN "เจ้านาย" | mkN "โฟร์แมน" | mkN "หัวหน้าพรรค" | mkN "หัวหน้าคนงาน" | mkN "หัวหน้าพรรคการเมือง" | mkN "นาย" | mkN "นายจ้าง" | mkN "หัวหน้า" | mkN "เจ้านาย" | mkN "ผู้เป็นใหญ่" ; -- src=panlex
lin bossy_A = mkA "ลูกวัว" | mkA "ซึ่งบงการ" | mkA "ซึ่งสั่งการ" | mkA "ซึ่งสั่งให้ทํา" ; -- src=panlex
lin bot_N = mkN "ไข่แมลง" | mkN "คนขี้โกง" | mkN "ไข่ของแมลงชนิดหนึ่ง" ; -- src=panlex
lin bota_N = mkN "ขวดโบตา" ; -- src=panlex
lin botanic_A = mkA "สมุนไพร" | mkA "ยาสมุนไพร" | mkA "เกี่ยวกับพืช" ; -- src=panlex
lin botanical_A = mkA "สมุนไพร" | mkA "ยาสมุนไพร" | mkA "เกี่ยวกับพืช" ; -- src=panlex
lin botanical_N = mkN "ยาที่มีส่วนผสมของพืช" ; -- src=panlex
lin botanist_N = mkN "นักพฤกษศาสตร์" | mkN "นักพฤกษศาสตร์" ; -- src=panlex
lin botanize_V = mkV "เรียนพฤษศาสตร์" | mkV "เรียนพฤกษศาสตร์" ; -- src=panlex
lin botany_N = mkN "พรรณพืช" | mkN "พฤกษชาติ" | mkN "พืชพันธุ์" | mkN "พฤกษศาสตร์" | mkN "พฤกษศาสตร์" | mkN "วิชาว่าด้วยต้นไม้" ; -- src=panlex
lin botch_N = mkN "การทำผิดพลาด" | mkN "ความผิดที่น่าอับอาย" | mkN "ผลงานที่แย่" | mkN "ผลงานที่ล้มเหลว" ; -- src=panlex
lin botcher_N = mkN "คนผิด" | mkN "คนระยำ" | mkN "คนมักง่าย" | mkN "คนสะเพร่า" | mkN "คนโง่เง่า" | mkN "คนงุ่มง่าม" | mkN "คนซุ่มซ่าม" ; -- src=panlex
lin botchy_A = mkA "ซึ่งไม่ชำนาญ" ; -- src=panlex
lin both7and_DConj = {s1 = "ทั้ง" ; s2 = "และ"} ;
lin both_Adv = mkAdv "คล้ายกัน" ; -- src=panlex
lin bother_N = mkN "การรบกวน" | mkN "สิ่งกวนใจ" | mkN "การรบกวน" | mkN "ตัวปัญหา" | mkN "ตัวก่อปัญหา" ; -- src=panlex
lin bother_V = mkV "ยั่ว" | mkV "กวนใจ" | mkV "รบกวน" | mkV "ก่อปัญหา" | mkV "กวนประสาท" | mkV "ซึ่งสับสน" | mkV "ทำให้ไม่สะดวก" | mkV "ทําให้ยุ่งยาก" | mkV "ทําให้เกิดปัญหา" | mkV "ทําให้ตัวเองยุ่งยาก" ; -- src=panlex
lin bother_V2 = mkV2 "ยั่ว" ; ---- | mkV "กวนใจ" | mkV "รบกวน" | mkV "ก่อปัญหา" | mkV "กวนประสาท" | mkV "ซึ่งสับสน" | mkV "ทำให้ไม่สะดวก" | mkV "ทําให้ยุ่งยาก" | mkV "ทําให้เกิดปัญหา" | mkV "ทําให้ตัวเองยุ่งยาก" ; -- src=panlex
lin bother_V2V = mmkV2V "ยั่ว" ; ---- | mkV "กวนใจ" | mkV "รบกวน" | mkV "ก่อปัญหา" | mkV "กวนประสาท" | mkV "ซึ่งสับสน" | mkV "ทำให้ไม่สะดวก" | mkV "ทําให้ยุ่งยาก" | mkV "ทําให้เกิดปัญหา" | mkV "ทําให้ตัวเองยุ่งยาก" ; -- src=panlex
lin bother_VV = mkVV "ยั่ว" ; ---- | mkV "กวนใจ" | mkV "รบกวน" | mkV "ก่อปัญหา" | mkV "กวนประสาท" | mkV "ซึ่งสับสน" | mkV "ทำให้ไม่สะดวก" | mkV "ทําให้ยุ่งยาก" | mkV "ทําให้เกิดปัญหา" | mkV "ทําให้ตัวเองยุ่งยาก" ; -- src=panlex
lin bothersome_A = mkA "น่ารำคาญ" | mkA "ยุ่ง" | mkA "ลําบาก" | mkA "ที่รบกวน" | mkA "น่าเบื่อ" | mkA "น่ารําคาญ" ; -- src=panlex
lin bottle_N = mkN "ขวด" | mkN "ขวดนม" | mkN "ปริมาณเต็มขวด" | mkN "ขวด" ; -- src=panlex
lin bottlebrush_N = mkN "แปรงล้างขวด" ; -- src=panlex
lin bottlecap_N = mkN "ฝาขวด" | mkN "จุกขวด" ; -- src=panlex
lin bottleneck_N = mkN "คอขวด" | mkN "อยู่ในภาวะที่ลําบาก" | mkN "ถนนส่วนที่มีการจราจรติดขัด" ; -- src=panlex
lin bottler_N = mkN "ผู้ผลิตขวด" ; -- src=panlex
lin bottom_A = mkA "ล่างสุด" | mkA "ชั้นล่าง" | mkA "ต่ําสุด" ; -- src=panlex
lin bottom_N = mkN "ก้น" | mkN "ตูด" | mkN "เชิง" | mkN "พื้นดิน" | mkN "ด้านล่าง" | mkN "บั้นท้าย" | mkN "ส่วนล่าง" | mkN "ครึ่งหลัง" | mkN "พื้นดินใต้ทะเลลึก" | mkN "เรือสินค้าพาณิชย์" | mkN "ก้น" | mkN "ฐาน" | mkN "ตูด" | mkN "ท้าย" | mkN "ปลาย" | mkN "ส่วนต่ําที่สุด" | mkN "ส่วนที่ลึกที่สุด" ; -- src=panlex
lin bottom_V = mkV "กระจ่าง" | mkV "ตาสว่าง" | mkV "มองทะลุ" | mkV "รองที่นั่ง" | mkV "เข้าใจทะลุปรุโปร่ง" ; -- src=panlex
lin bottomland_N = mkN "พื้นดิน" ; -- src=panlex
lin bottomless_A = mkA "ปราศจากก้น" | mkA "สุดหยั่งลึก" | mkA "เปลือยท่อนล่าง" | mkA "ลึกมาก" | mkA "ลึกลับ" | mkA "ไม่มีก้น" | mkA "วัดไม่ได้" | mkA "ไร้ขอบเขต" | mkA "สุดที่หยั่งถึง" | mkA "ลึกจนไม่อาจหยั่งได้" ; -- src=panlex
lin bottommost_A = mkA "ก้น" | mkA "ลึกที่สุด" | mkA "ต่ําที่สุด" | mkA "เกี่ยวกับพื้น" ; -- src=panlex
lin botuliform_A = mkA "ซึ่งเป็นรูปไส้กรอก" ; -- src=panlex
lin botulin_N = mkN "โบทูลินัมทอกซิน" | mkN "สารพิษ" ; -- src=panlex
lin botulinus_N = mkN "โบทูลินัม" ; -- src=panlex
lin botulism_N = mkN "อาหารเป็นพิษ" | mkN "โรคที่เกิดจากอาหารเป็นพิษ" ; -- src=panlex
lin boucle_N = mkN "ผ้าบูกล์" ; -- src=panlex
lin boudoir_N = mkN "ห้องนอนสตรี" | mkN "ห้องนอนผู้หญิง" | mkN "ห้องส่วนตัวของหญิง" | mkN "ห้องส่วนตัวหรือห้องนอนของผู้หญิง" ; -- src=panlex
lin bouffant_A = mkA "เต็ม" | mkA "ทรงผม" ; -- src=panlex
lin bouffant_N = mkN "ทรงผมบาน" ; -- src=panlex
lin bougainvillea_N = mkN "ต้นไม้เขตร้อน" ; -- src=panlex
lin bough_N = mkN "กิ่ง" | mkN "กิ่ง" | mkN "กิ่งไม้" | mkN "กิ่งก้าน" | mkN "กิ่งก้านสาขา" | mkN "กิ่งต้นไม้ขนาดใหญ่" ; -- src=panlex
lin bouillabaisse_N = mkN "บุยยาเบส" | mkN "ซุปบุยยาเบส" | mkN "ซุปปลารสจัดของทางใต้ของฝรั่งเศส" ; -- src=panlex
lin bouillon_N = mkN "บูวียอง" | mkN "ซุปบูวียอง" | mkN "น้ําซุป" ; -- src=panlex
lin boulder_N = mkN "ก้อนหินมนใหญ่" | mkN "หินก้อนกลมๆ ใหญ่ๆ" | mkN "หินขนาดใหญ่เปลี่ยนเป็นรูปร่างต่างๆ เพราะน้ํา/อากาศ" ; -- src=panlex
lin boulevard_N = mkN "ถนนใหญ่" | mkN "ถนน" | mkN "ถนนหลวง" | mkN "ถนนใหญ่" | mkN "ถนนสายสําคัญในเมือง" ; -- src=panlex
lin bounce_N = mkN "การกระเด้ง" | mkN "การสะท้อนกลับ" | mkN "ความสามารถในการสะท้อน" ; -- src=panlex
lin bounce_V = mkV "เด้ง" | mkV "กระเด้ง" | mkV "เด้ง" ; -- src=panlex
lin bounce_V2 = mkV2 "เด้ง" ; ---- | mkV "กระเด้ง" | mkV "เด้ง" ; -- src=panlex
lin bouncer_N = mkN "คนโกหก" | mkN "ใหญ่และแข็งแรง" | mkN "คนเฝ้าหน้าร้านที่คอยโยนผู้ไม่ได้รับอนุญาตเข้าออกมา" ; -- src=panlex
lin bouncy_A = mkA "สปริงตัว" | mkA "ร่าเริง" | mkA "เด้งได้" | mkA "ชอบคุยโว" | mkA "มีชีวิตชีวา" | mkA "กระฉับกระเฉง" | mkA "มีลักษณะเด้ง" | mkA "ชอบยกยอตัวเอง" | mkA "ซึ่งทําให้กระเด้งหรือกระโดด" ; -- src=panlex
lin bound_N = mkN "ขอบ" | mkN "ขอบเขต" | mkN "ขีดจำกัด" | mkN "การกระเด้ง" | mkN "เส้นบอกเขต" | mkN "แนวแบ่งเขต" | mkN "เส้นแบ่งเขต" | mkN "ขอบเขต" | mkN "การกระโดด" | mkN "ข้อจํากัด" | mkN "เส้นขอบเขต" | mkN "เส้นแบ่งเขต" | mkN "เส้นแบ่งเขตแดน" ; -- src=panlex
lin bound_V = mkV "เด้ง" | mkV "กระโจน" | mkV "กระโดด" | mkV "กระเด้ง" | mkV "กีดขวาง" | mkV "ขีดเส้นแบ่งเขต" | mkV "มุ่ง" | mkV "กระโดด" | mkV "จํากัด" | mkV "ตรงไปยัง" | mkV "มุ่งหน้า" | mkV "จํากัดขอบเขต" ; -- src=panlex
lin bound_V2 = mkV2 "เด้ง" ; ---- | mkV "กระโจน" | mkV "กระโดด" | mkV "กระเด้ง" | mkV "กีดขวาง" | mkV "ขีดเส้นแบ่งเขต" | mkV "มุ่ง" | mkV "กระโดด" | mkV "จํากัด" | mkV "ตรงไปยัง" | mkV "มุ่งหน้า" | mkV "จํากัดขอบเขต" ; -- src=panlex
lin bound_V2V = mmkV2V "เด้ง" ; ---- | mkV "กระโจน" | mkV "กระโดด" | mkV "กระเด้ง" | mkV "กีดขวาง" | mkV "ขีดเส้นแบ่งเขต" | mkV "มุ่ง" | mkV "กระโดด" | mkV "จํากัด" | mkV "ตรงไปยัง" | mkV "มุ่งหน้า" | mkV "จํากัดขอบเขต" ; -- src=panlex
lin boundary_N = mkN "ขอบ" | mkN "ขอบเขต" | mkN "ขีดจำกัด" | mkN "เส้นบอกเขต" | mkN "แนวแบ่งเขต" | mkN "เส้นแบ่งเขต" | mkN "เขต" | mkN "แดน" | mkN "ขัณฑ์" | mkN "ขอบเขต" | mkN "เขตแดน" | mkN "อาณาเขต" | mkN "เส้นแบ่งเขต" ; -- src=panlex
lin bounden_A = mkA "จําต้อง" | mkA "มีภาระหน้าที่" | mkA "ซึ่งผู้มัดหรือเป็นภาระรับผิดชอบ" ; -- src=panlex
lin bounder_N = mkN "คนเลว" | mkN "คนถ่อย" | mkN "อันธพาล" | mkN "คนไร้สกุลรุนชาติ" | mkN "คนจัญไร" | mkN "คนเฮงซวย" ; -- src=panlex
lin boundless_A = mkA "มากมาย" | mkA "สุดขีด" | mkA "สุดสายตา" | mkA "กว้างใหญ่" | mkA "ไร้ขอบเขต" | mkA "ไม่มีที่สิ้นสุด" ; -- src=panlex
lin bounteous_A = mkA "ใจดี" | mkA "ใจบุญ" | mkA "มากมาย" | mkA "ใจกว้าง" | mkA "เหลือหลาย" | mkA "อุดมสมบูรณ์" ; -- src=panlex
lin bountiful_A = mkA "อารี" | mkA "อุดม" | mkA "ใจบุญ" | mkA "มากมาย" | mkA "สมบูรณ์" | mkA "ใจกว้าง" | mkA "เหลือหลาย" | mkA "เอื้อเฟื้อ" | mkA "อุดมสมบูรณ์" ; -- src=panlex
lin bounty_N = mkN "ค่าหัว" | mkN "จำนวนมาก" | mkN "ความกรุณา" | mkN "เงินค่าหัว" | mkN "รางวัล" | mkN "ของขวัญ" | mkN "ความอารี" | mkN "ความใจบุญ" | mkN "ปริมาณมาก" | mkN "สิ่งที่มอบให้" | mkN "เงินสงเคราะห์" ; -- src=panlex
lin bouquet_N = mkN "ความหอม" | mkN "ช่อดอกไม้" | mkN "ช่อ" | mkN "อุบะ" | mkN "การยกย่อง" | mkN "ช่อดอกไม้" | mkN "พวงดอกไม้" | mkN "คําสรรเสริญ -" | mkN "กลิ่นหอมของเหล้า" ; -- src=panlex
lin bourbon_N = mkN "วิสกี้เบอร์เบิน" | mkN "ราชวงศ์บัวบัน" | mkN "ราชวงศ์ของประเทศฝรั่งเศส" | mkN "เหล้าชนิดหนึ่งของอเมริกัน" ; -- src=panlex
lin bourgeois_N = mkN "คนชั้นกลาง" | mkN "คนทำธุรกิจ" | mkN "คนทำมาหากิน" | mkN "ผู้ทำธุรกิจ" | mkN "คนทำมาค้าขาย" | mkN "ผู้ประกอบการ" | mkN "ผู้ประกอบธุรกิจ" | mkN "พ่อค้า" | mkN "นักธุรกิจ" | mkN "พื้นธรรมดา" | mkN "เจ้าของร้าน" | mkN "คนที่เป็นชั้นกลาง" | mkN "เสรีชนในสมัยโบราณ" ; -- src=panlex
lin bourgeoisie_N = mkN "กระฎุมพี" | mkN "ชนชั้นกลาง" | mkN "ชนชั้นกระฎุมพี" | mkN "ชนชั้นกลาง" | mkN "ชนชั้นกลางของสังคม" ; -- src=panlex
lin bourguignon_N = mkN "ซอสเบอร์กันดี" ; -- src=panlex
lin bourn_N = mkN "เป้าหมาย" | mkN "ขอบเขต" | mkN "เป้าหมาย" | mkN "ลําธารสายเล็ก" ; -- src=panlex
lin bourne_N = mkN "เป้าหมาย" | mkN "ขอบเขต" | mkN "เป้าหมาย" | mkN "ลําธารสายเล็ก" ; -- src=panlex
lin bourse_N = mkN "การซื้อขายหุ้น" ; -- src=panlex
lin bourtree_N = mkN "แบล็กเอลเดอร์" ; -- src=panlex
lin bout_N = mkN "รอบ" | mkN "การกินดื่ม" | mkN "ช่วงเจ็บป่วย" | mkN "ช่วงที่กินดื่มมากเกินไป" | mkN "ยกหนึ่ง" | mkN "พักหนึ่ง" | mkN "การแข่งขัน" | mkN "การประลองฝีมือ" | mkN "กิจกรรมระยะสั้นๆ" | mkN "การเจ็บป่วยช่วงเวลาสั้นๆ" ; -- src=panlex
lin boutique_N = mkN "ร้านบูติก" | mkN "ร้านเสื้อผ้า" | mkN "ร้านขายเสื้อผ้า" | mkN "ร้านขายเครื่องแต่งกายที่นําสมัย" | mkN "ดอกไม้ที่ติดอยู่ที่รังดุมหรือปกเสื้อ" ; -- src=panlex
lin boutonniere_N = mkN "ดอกไม้ดอกเล็กที่ใส่ในรูกระดุม" | mkN "ดอกไม้ที่ติดอยู่ที่รังดุมหรือปกเสื้อ" ; -- src=panlex
lin bovid_N = mkN "โบวิด" ; -- src=panlex
lin bovine_A = mkA "เบาปัญญา" | mkA "เชื่องช้า" | mkA "เหมือนวัว" | mkA "โง่และช้า" | mkA "เกี่ยวกับวัว" ; -- src=panlex
lin bovine_N = mkN "โบไวน์" ; -- src=panlex
lin bow_N = mkN "ธนู" | mkN "โค้ง" | mkN "โบว์" | mkN "การสี" | mkN "คันศร" | mkN "คันสี" | mkN "คันชัก" | mkN "คันธนู" | mkN "หัวเรือ" | mkN "การคารวะ" | mkN "เกาทัณฑ์" | mkN "การค้อมตัวลง" | mkN "การโค้งคำนับ" | mkN "วัตถุรูปโค้ง" | mkN "เงื่อนบ่วงสายธนู" | mkN "การสีเครื่องดนตรี" | mkN "ศร" | mkN "ธนู" | mkN "โบว์" | mkN "คันซอ" | mkN "คันศร" | mkN "คันธนู" | mkN "การน้อม" | mkN "หน้าไม้" | mkN "หัวเรือ" | mkN "หูกระต่าย" | mkN "การก้มศีรษะ" | mkN "คันเกาทัณฑ์" | mkN "การโค้งคํานับ" | mkN "สิ่งที่มีลักษณะโค้ง" ; -- src=panlex
lin bow_V = mkV "สี" | mkV "ก้ม" | mkV "โค้ง" | mkV "คำนับ" | mkV "ก้มตัว" | mkV "ค้อมตัว" | mkV "ถวายคำนับ" | mkV "โค้งคำนับ" | mkV "โอนอ่อนผ่อนตาม" | mkV "สีซอ" | mkV "คํานับ" | mkV "น้อมศรีษะ" ; -- src=panlex
lin bow_V2 = mkV2 "สี" ; ---- | mkV "ก้ม" | mkV "โค้ง" | mkV "คำนับ" | mkV "ก้มตัว" | mkV "ค้อมตัว" | mkV "ถวายคำนับ" | mkV "โค้งคำนับ" | mkV "โอนอ่อนผ่อนตาม" | mkV "สีซอ" | mkV "คํานับ" | mkV "น้อมศรีษะ" ; -- src=panlex
lin bowdlerization_N = mkN "งานเขียนที่ตัดทอน" ; -- src=panlex
lin bowel_N = mkN "ลำไส้" | mkN "ส่วนใน" | mkN "ความสงสาร" | mkN "ส่วนของลําไส้" ; -- src=panlex
lin bower_N = mkN "ซุ้ม" | mkN "ซุ้มไม้" | mkN "ร่มไม้" | mkN "กระท่อม" | mkN "ซุ้มไม้ในสวน" | mkN "ซุ้มใต้ต้นไม้ในสวนหรือสนาม" ; -- src=panlex
lin bowerbird_N = mkN "นกโบเวอร์เบิร์ด" ; -- src=panlex
lin bowfin_N = mkN "ปลาโบว์์ฟิช" ; -- src=panlex
lin bowhead_N = mkN "วาฬหัวบาตร" | mkN "ปลาวาฬหัวบาตร" ; -- src=panlex
lin bowing_N = mkN "การสี" | mkN "การคารวะ" | mkN "การค้อมตัวลง" | mkN "การคารวะ" | mkN "การคํานับ" | mkN "การยอมรับ" ; -- src=panlex
lin bowl_N = mkN "ชาม" | mkN "การกลิ้ง" | mkN "สนามกีฬา" | mkN "สเตเดียม" | mkN "ลูกโบวลิ่ง" | mkN "ที่ใส่ยาสูบ" | mkN "ลูกโบว์ลิ่ง" | mkN "โถ" | mkN "ขัน" | mkN "ชาม" | mkN "ถ้วย" | mkN "บาตร" | mkN "สนาม" | mkN "เล่น" | mkN "เวที" | mkN "กระปุก" | mkN "ชามกลม" | mkN "เหยือก" | mkN "กระเปาะ" | mkN "ลูกโบว์ลิ่ง" | mkN "เล่นโบว์ลิ่ง" | mkN "ส่วนกลมของกล้องสูบยาเส้นสําหรับบรรจุยา" ; -- src=panlex
lin bowl_V = mkV "โยนโบล์" | mkV "โยนโบลลิ่ง" ; -- src=panlex
lin bowl_V2 = mkV2 "โยนโบล์" ; ---- | mkV "โยนโบลลิ่ง" ; -- src=panlex
lin bowleg_N = mkN "ขาโก่ง" | mkN "ภาวะขาโก่ง" | mkN "ขาที่โก่งงอ" ; -- src=panlex
lin bowler_N = mkN "นักทอยแก่น" | mkN "นักโบว์ลิ่ง" | mkN "ผู้ขว้างลูก" | mkN "หมวกสักหลาด" | mkN "หมวกทรงแตงโม" | mkN "นักกีฬาโบว์ลิ่ง" | mkN "หมวกทรงกลมปีกแข็ง" | mkN "ค คนเล่นโบว์ลิ่ง" | mkN "หมวกทรงกลมสีดํามีขอบโค้ง" ; -- src=panlex
lin bowling_N = mkN "โบว์ลิ่ง" | mkN "การส่งลูก" | mkN "การโยนโบว์ลิ่ง" | mkN "การเล่นโบว์ลิ่ง" | mkN "กีฬาโบว์ลิ่ง" ; -- src=panlex
lin bowls_N = mkN "โบว์ลิง" ; -- src=panlex
lin bowman_N = mkN "นักยิงธนู" | mkN "โรบินฮู้ด" | mkN "นายธนู" | mkN "นักยิงธนู" | mkN "นายขมังธนู" | mkN "สมอหัวเรือ" ; -- src=panlex
lin bowsprit_N = mkN "กระโดงเรือ" | mkN "เครื่องเสาหัวเรือขนาดใหญ่" ; -- src=panlex
lin bowstring_N = mkN "สายธนู" | mkN "สายเกาทัณฑ์" ; -- src=panlex
lin box_N = mkN "คอก" | mkN "กล่อง" | mkN "บ็อกซ์" | mkN "ต้นบ็อกซ์" | mkN "การตบบ้องหู" | mkN "ที่นั่งคนขับ" | mkN "เก้าอี้คนขับ" | mkN "ต้นบ็อกซ์วู้ด" | mkN "จำนวนเต็มกล่อง" | mkN "ที่นั่งของคนขับ" | mkN "รูปกล่องสี่เหลี่ยม" | mkN "คอก" | mkN "ลัง" | mkN "หีบ" | mkN "กลัก" | mkN "กล่อง" | mkN "การตบ" | mkN "การตี" | mkN "การต่อย" | mkN "ช่องสี่เหลี่ยม" | mkN "ต้นไม้ชนิดหนึ่ง" | mkN "ที่นั่งคนขับรถม้า" | mkN "คอกสําหรับคนดูในโรงละคร" | mkN "ต้นไม้ชนิดหนึ่งใช้ทําเครื่องแกะสลักและไม้บรรทัด" ; -- src=panlex
lin box_V = mkV "ชก" | mkV "ซัด" | mkV "ต่อย" | mkV "ชกมวย" | mkV "บรรจุ" | mkV "ขึ้นชก" | mkV "ต่อยมวย" | mkV "ดวลกำปั้น" | mkV "ขึ้นสังเวียน" | mkV "ตบ" | mkV "ตี" | mkV "ต่อยมวย" | mkV "ใส่กล่อง" | mkV "ต่อยที่หู" ; -- src=panlex
lin box_V2 = mkV2 "ชก" ; ---- | mkV "ซัด" | mkV "ต่อย" | mkV "ชกมวย" | mkV "บรรจุ" | mkV "ขึ้นชก" | mkV "ต่อยมวย" | mkV "ดวลกำปั้น" | mkV "ขึ้นสังเวียน" | mkV "ตบ" | mkV "ตี" | mkV "ต่อยมวย" | mkV "ใส่กล่อง" | mkV "ต่อยที่หู" ; -- src=panlex
lin boxcar_N = mkN "รถไฟบรรทุกสินค้า" | mkN "รถไฟบรรทุกสัมภาระ" ; -- src=panlex
lin boxer_N = mkN "นักมวย" | mkN "พนักงานบรรจุกล่อง" | mkN "พนักงานบรรจุหีบห่อ" | mkN "สุนัขพันธุ์บอกเซอร์" | mkN "นักมวย" | mkN "คนบรรจุกล่อง" | mkN "คนทํากล่องหรือหีบ" | mkN "สุนัขพันธุ์บอกเซอร์" | mkN "สุนัขพันธุ์บ๊อคเซอะ" ; -- src=panlex
lin boxfish_N = mkN "ปลาบ็อกซ์ฟิช" ; -- src=panlex
lin boxful_N = mkN "กล่อง" | mkN "จำนวนเต็มกล่อง" | mkN "กล่องที่มีของอยู่เต็ม" ; -- src=panlex
lin boxing_N = mkN "มวย" | mkN "กีฬามวย" | mkN "กีฬาชกมวย" | mkN "การแพ็คของ" | mkN "การบรรจุกล่อง" | mkN "การบรรจุหีบห่อ" | mkN "การชกมวย" | mkN "การต่อยมวย" | mkN "หีบหรือลัง" | mkN "การใส่กล่อง" | mkN "การบรรจุกล่อง" | mkN "การบรรจุลงกล่อง" | mkN "วัตถุที่ใช้ทํากล่องหีบหรือลัง" ; -- src=panlex
lin boxlike_A = mkA "ที่มีรูปทรงเหมือนกล่อง" ; -- src=panlex
lin boxwood_N = mkN "ต้นบ็อกซ์" | mkN "ไม้บอกซ์วู้ด" | mkN "ต้นบ็อกซ์วู้ด" | mkN "ไม้เนื้อแข็งของต้นไม้ที่เขียวชอุ่มตลอดปี" ; -- src=panlex
lin boy_N = mkN (thword "เด็ก" "ผู้" "ชาย")" คน" | {-pan-} mkN "โอรส" | mkN "ลูกชาย" | mkN "ไอ้หนู" | mkN "กุลบุตร" | mkN "บุตรชาย" | mkN "พระโอรส" | mkN "ราชบุตร" | mkN "ราชโอรส" | mkN "เด็กชาย" | mkN "หนุ่มน้อย" | mkN "เด็กผู้ชาย" | mkN "บ๋อย" | mkN "เด็ก" | mkN "บริกร" | mkN "พ่อหนู" | mkN "น้องชาย" | mkN "เด็กชาย" | mkN "พ่อหนุ่ม" | mkN "เด็กผู้ชาย" | mkN "เด็กฝึกงาน" | mkN "กะลาสีเรือฝึกใหม่" ; -- src=panlex
lin boycott_N = mkN "การคว่ำบาตร" | mkN "การคว่ําบาตร" ; -- src=panlex
lin boyfriend_N = mkN "แฟนหนุ่ม" | mkN "เพื่อนชาย" | mkN "เพื่อนผู้ชาย" | mkN "แฟน" | mkN "คู่รัก" | mkN "เพื่อนชาย" ; -- src=panlex
lin boyhood_N = mkN "วัยเด็กชาย" | mkN "ช่วงวัยของเด็กชาย" | mkN "วัยเด็ก" ; -- src=panlex
lin boyish_A = mkA "เหมือนเด็กผู้ชาย" | mkA "คล้ายเด็ก" | mkA "เหมือนเด็ก" | mkA "ทําตัวเหมือนเด็ก" | mkA "มีนิสัยเหมือนเด็ก" ; -- src=panlex
lin boyishness_N = mkN "ความเป็นเด็กชาย" | mkN "ความเป็นเด็กผู้ชาย" ; -- src=panlex
lin boysenberry_N = mkN "บอยเซนเบอร์รี่" | mkN "ต้นบอยเซนเบอร์รี่" ; -- src=panlex
lin bra_N = mkN "บรา" | mkN "ยกทรง" | mkN "เสื้อใน" | mkN "บราเซียร์" | mkN "เสื้อชั้นในสตรี" | mkN "เสื้อชั้นในสตรี’" ; -- src=panlex
lin brace_N = mkN "คู่" | mkN "ปีกกา" | mkN "ไม้ค้ำ" | mkN "สายแขวน" | mkN "ลวดดัดฟัน" | mkN "วงเล็บปีกกา" | mkN "เหล็กยึดฟัน" | mkN "คู่เหมือนกัน" | mkN "สายรั้งถุงน่อง" | mkN "เครื่องหมายปีกกา" | mkN "เครื่องหมายวงเล็บปีกกา" | mkN "หนุน" | mkN "เฝือก" | mkN "ที่พาด" | mkN "กระตุ้น" | mkN "ค้ําไว้" | mkN "ที่รั้ง" | mkN "มัดแน่น" | mkN "รั้งไว้" | mkN "เสาค้ํา" | mkN "สายหนึ่ง" | mkN "เชือกโยงเสา" | mkN "เครื่องค้ําจุน" | mkN "ตัดสินใจแน่วแน่" | mkN "เครื่องเหนี่ยวรั้ง" ; -- src=panlex
lin brace_V = mkV "ทรงตัว" | mkV "กระตุ้น" | mkV "ทำให้สดชื่น" | mkV "จับให้มั่นคง" | mkV "มัด" | mkV "ยึด" | mkV "รัด" | mkV "ค้ํา" ; -- src=panlex
lin brace_V2 = mkV2 "ทรงตัว" ; ---- | mkV "กระตุ้น" | mkV "ทำให้สดชื่น" | mkV "จับให้มั่นคง" | mkV "มัด" | mkV "ยึด" | mkV "รัด" | mkV "ค้ํา" ; -- src=panlex
lin bracelet_N = mkN "กำไล" | mkN "สร้อย" | mkN "สายนาฬิกา" | mkN "สายนาฬิืกา" | mkN "สายนาฬิกาข้อมือ" | mkN "วลัย" | mkN "ทองกร" | mkN "พาหุรัด" | mkN "กุญแจมือ" | mkN "กําไลมือ" | mkN "ทองปลายแขน" | mkN "กําไลข้อมือ" | mkN "สร้อยข้อมือ" ; -- src=panlex
lin bracer_N = mkN "โทนิค" | mkN "ยาบำรุงกำลัง" | mkN "สิ่งค้ํา" | mkN "ผู้สนับสนุน" | mkN "ยาบํารุงกําลัง" | mkN "เครื่องดื่มที่กระตุ้น" ; -- src=panlex
lin bracero_N = mkN "เบรอซาโร" ; -- src=panlex
lin brachial_A = mkA "เกี่ยวกับแขน" | mkA "ปีก" | mkA "ขาหน้า" | mkA "แขนท่อนบน" | mkA "เกี่ยวกับแขน" ; -- src=panlex
lin brachiation_N = mkN "การแกว่งแขน" ; -- src=panlex
lin brachium_N = mkN "ต้นแขน" ; -- src=panlex
lin brachycephalic_A = mkA "ที่มีศีรษะแบบบราคีเซอฟาลิก" ; -- src=panlex
lin brachycephalic_N = mkN "ผู้มีศีรษะสั้นกว้าง" | mkN "ผู้มีศีรษะแบบบราคีเซอฟาลิก" ; -- src=panlex
lin brachypterous_A = mkA "ที่มีปีกสั้นมาก" ; -- src=panlex
lin bracken_N = mkN "ต้นเฟิร์น" | mkN "เฟิร์นแบร็กเคน" | mkN "ต้นไม้ป่า" ; -- src=panlex
lin bracket_N = mkN "วงเล็บเหลี่ยม" | mkN "วงเล็บสามเหลี่ยม" | mkN "เครื่องหมายวงเล็บเหลี่ยม" | mkN "เครื่องหมายวงเล็บสามเหลี่ยม" | mkN "ชนิด" | mkN "ประเภท" | mkN "วงเล็บ" ; -- src=panlex
lin brackish_A = mkA "กร่อย" | mkA "มีรสเค็ม" | mkA "มีรสกร่อย" | mkA "ค่อนข้างเค็ม" ; -- src=panlex
lin bract_N = mkN "กลีบฐานของดอกไม้" ; -- src=panlex
lin bracteate_A = mkA "มีกลีบ" ; -- src=panlex
lin brad_N = mkN "ตะปูหัวแบน" ; -- src=panlex
lin bradawl_N = mkN "เหล็กหมาด" | mkN "เหล็กหมาดสําหรับเจาะรูเพื่อตอกตะปูไร้หัว" ; -- src=panlex
lin bradycardia_N = mkN "หัวใจเต้นช้า" ; -- src=panlex
lin brae_N = mkN "ไหล่เขา" | mkN "เนิน" | mkN "ไหล่เขา" | mkN "ส่วนไหล่เขา" | mkN "ข้างฝั่งแม่น้ํา" | mkN "ตลิ่งที่ลาดเอียง" ; -- src=panlex
lin brag_N = mkN "การคุยโม้" | mkN "การพูดโอ้อวด" | mkN "การพูดอวดดี" | mkN "คําพูดอวดดี" ; -- src=panlex
lin brag_V = mkV "คุยโว" | mkV "โอ้อวด" | mkV "โ้อ้อวด" | mkV "ฝอย" | mkV "พูดอวดดี" ; -- src=panlex
lin braggadocio_N = mkN "คนคุยโว" | mkN "คําพูดที่คุยโว" | mkN "การคุยโม้การคุยโว" ; -- src=panlex
lin braggart_N = mkN "คนขี้คุย" | mkN "คนคุยโม้" ; -- src=panlex
lin bragger_N = mkN "คนขี้คุย" ; -- src=panlex
lin bragging_N = mkN "การคุยโม้" | mkN "การพูดโอ้อวด" ; -- src=panlex
lin brahman_N = mkN "บรามัน" | mkN "พราหมณ์" | mkN "วรรณะพราหมณ์" | mkN "คนวรรณะพราหมณ์" ; -- src=panlex
lin brahmin_N = mkN "บรามัน" | mkN "พราหมณ์" | mkN "วรรณะพราหมณ์" | mkN "คนวรรณะพราหมณ์" | mkN "พราหมณ์" | mkN "ผู้ที่มีความรู้และวัฒนธรรมสูง" ; -- src=panlex
lin braid_N = mkN "เปีย" | mkN "ผมเปีย" | mkN "ดิ้นทอง" | mkN "เปีย" | mkN "ผมเปีย" | mkN "เกลียว" | mkN "เกลียวทอง" ; -- src=panlex
lin braille_N = mkN "อักษรเบรลล์" | mkN "อักษรสำหรับคนตาบอด" | mkN "ตัวหนังสือนูนสําหรับคนตาพิการ" | mkN "ระบบการพิมพ์อักษรเบลล์สําหรับคนตาบอด" ; -- src=panlex
lin brain_N = mkN "หัว" | mkN "สมอง" | mkN "หัวคิด" | mkN "ความคิด" | mkN "จีเนียส" | mkN "อัจฉริยะ" | mkN "อัจฉริยบุคคล" | mkN "ความสามารถในการเรียนรู้" | mkN "สมอง" | mkN "สมอง ขมอง" | mkN "มันสมอง" | mkN "ความฉลาด" | mkN "สติปัญญา" ; -- src=panlex
lin brainchild_N = mkN "ผลงานสร้างสรรค์" | mkN "ความคิดหรือสิ่งประดิษฐ์" ; -- src=panlex
lin brainless_A = mkA "ไร้สมอง" | mkA "โง่" | mkA "ไม่มีสมอง" ; -- src=panlex
lin brainstem_N = mkN "ก้านสมอง" ; -- src=panlex
lin brainstorm_N = mkN "ความคิด" | mkN "กระแสประสาท" | mkN "การถกเถียงอย่างเปิดเผย" ; -- src=panlex
lin brainstorming_N = mkN "การระดมความคิด" | mkN "การระดมความคิด" | mkN "การถกเถียงอย่างเปิดเผยเพื่อแก้ปัญหา" ; -- src=panlex
lin brainwashing_N = mkN "การล้างสมอง" ; -- src=panlex
lin brainwave_N = mkN "คลื่นสมอง" | mkN "ความคิดดีที่นึกได้ทันที" ; -- src=panlex
lin brainy_A = mkA "ฉลาด" | mkA "ฉลาดมาก" | mkA "มีปัญญา" ; -- src=panlex
lin braising_N = mkN "การเคี่ยว" ; -- src=panlex
lin brake_N = mkN "เบรก" | mkN "ห้ามล้อ" | mkN "ต้นเฟิร์น" | mkN "ป่าละเมาะ" | mkN "เบรก" | mkN "พุ่มไม้" | mkN "ต้นเฟิร์น" | mkN "ป่าละเมาะ" | mkN "เครื่องห้ามล้อ" | mkN "ไม้ประเภทเฟิร์น" | mkN "สิ่งที่มีผลยับยั้งทําให้ช้า" ; -- src=panlex
lin brake_V = mkV "เบรค" | mkV "หยุด" | mkV "เบรค" | mkV "ห้ามล้อ" ; -- src=panlex
lin brake_V2 = mkV2 "เบรค" ; ---- | mkV "หยุด" | mkV "เบรค" | mkV "ห้ามล้อ" ; -- src=panlex
lin brakeman_N = mkN "พนักงานหยุดรถไฟ" ; -- src=panlex
lin bramble_N = mkN "ไม้พุ่มมีหนาม" | mkN "พุ่มไม้มีหนาม" | mkN "พุ่มไม้ป่ามีหนาม" ; -- src=panlex
lin brambling_N = mkN "นกจาบปีกอ่อนอกส้ม" ; -- src=panlex
lin bran_N = mkN "รำข้าว" | mkN "อาหารจากธัญพืช" | mkN "รําข้าว" | mkN "อาหารที่ได้จากรําข้าวและเมล็ดธัญพืช" ; -- src=panlex
lin branch_N = mkN "แขน" | mkN "กิ่ง" | mkN "สาขา" | mkN "ลำน้ำสาขา" | mkN "หน่วยงานย่อย" | mkN "แขน" | mkN "กิ่ง" | mkN "สาขา" | mkN "แผนก" | mkN "ที่เท้าแขน" | mkN "กิ่งก้านสาขา" ; -- src=panlex
lin branch_V = mkV "แตกเป็นสาขา" | mkV "แตกกิ่ง" | mkV "แตกแขนง" ; -- src=panlex
lin branched_A = mkA "ที่มีกิ่ง" ; -- src=panlex
lin branching_N = mkN "การแยกจากสาขาใหญ่" ; -- src=panlex
lin branchless_A = mkA "ที่ไม่มีกิ่ง" ; -- src=panlex
lin branchy_A = mkA "ที่มีกิ่งก้านสาขา" ; -- src=panlex
lin brand_N = mkN "ดาบ" | mkN "ตรา" | mkN "ถ่าน" | mkN "กระบี่" | mkN "ยี่ห้อ" | mkN "แบรนด์" | mkN "พระขรรค์" | mkN "รอยเปื้อน" | mkN "สัญลักษณ์" | mkN "ชื่อทางการค้า" | mkN "ชื่อสัญลักษณ์" | mkN "เครื่องหมายการค้า" | mkN "ดาบ" | mkN "ตรา" | mkN "ถ่านไฟ" | mkN "ยี่ห้อ" | mkN "ตราสินค้า" | mkN "เครื่องหมายการค้า" ; -- src=panlex
lin brandy_N = mkN "บรั่นดี" | mkN "บรั่นดี" | mkN "เหล้ากลั่นมาจากเหล้าองุ่น" ; -- src=panlex
lin brandy_ball_N = mkN "แบรนดี้บอล" ; -- src=panlex
lin brandy_snap_N = mkN "บรั่นดีสแนป" ; -- src=panlex
lin brant_N = mkN "ห่าน" | mkN "ห่านเบรนท์" ; -- src=panlex
lin brash_A = mkA "เปราะ" | mkA "ทะลึ่ง" | mkA "ก๋ากั่น" | mkA "สะเพร่า" | mkA "ไม่ไตร่ตรอง" | mkA "หุนหันพลันแล่น" ; -- src=panlex
lin brass_N = mkN "ความกล้า" | mkN "ทองเหลือง" | mkN "ผู้ก่อตั้ง" | mkN "แผ่นสลักภาพ" | mkN "เครื่องทองเหลือง" | mkN "เครื่องลมทองเหลือง" | mkN "เครื่องเป่าทองเหลือง" | mkN "ความกล้า" | mkN "ทองเหลือง" | mkN "ความทะลึ่ง" | mkN "ความใจกล้า" | mkN "ความหน้าด้าน" | mkN "กลุ่มคนใหญ่คนโต" | mkN "ผลิตภัณฑ์ทองเหลือง" | mkN "ข้าราชการชั้นผู้ใหญ่" | mkN "เครื่องเป่าทองเหลือง" | mkN "แผ่นทองเหลืองที่จารึกนามหน้าประตู" ; -- src=panlex
lin brassard_N = mkN "เกราะป้องกันแขน" ; -- src=panlex
lin brasserie_N = mkN "ยกทรง" ; -- src=panlex
lin brassiere_N = variants {} ;
lin brassy_A = mkA "ดังและแหบ" ; -- src=panlex
lin brat_N = mkN "เด็กเลว" | mkN "เด็กสารเลว" | mkN "ไส้กรอกอันเล็ก" | mkN "คนเลว" | mkN "เด็กสารเลว" | mkN "เด็กเหลือขอ" ; -- src=panlex
lin bratwurst_N = mkN "ไส้กรอกอันเล็ก" ; -- src=panlex
lin bravado_N = mkN "ความองอาจ" | mkN "การแสดงความกล้าหาญที่ไม่จริง" ; -- src=panlex
lin brave_A = mkA "หาญ" | mkA "กล้า" | mkA "กล้าหาญ" | mkA "หาญ" | mkA "กล้า" | mkA "อาจหาญ" | mkA "กล้าหาญ" ; -- src=panlex
lin brave_N = mkN "เบรฟ" | mkN "นักรบ" | mkN "วีรชน" | mkN "ผู้กล้า" | mkN "ผู้กล้าหาญ" | mkN "กลุ่มผู้กล้า" ; -- src=panlex
lin bravery_N = mkN "ความกล้า" | mkN "ความอาจหาญ" | mkN "ความกล้าหาญ" | mkN "ความกล้าหาญ" ; -- src=panlex
lin bravo_N = mkN "บราโว" | mkN "ผู้ลอบสังหาร" | mkN "ฆาตกรลอบสังหาร" | mkN "นักฆ่าลอบสังหาร" ; -- src=panlex
lin bravura_N = mkN "ทักษะและความกระตือร้นจะทําในเชิงศิลปะ" ; -- src=panlex
lin brawl_N = mkN "ความอึกทึก" | mkN "การทะเลาะวิวาท" | mkN "งานเลี้ยงเสียงดัง" | mkN "การวิวาท" | mkN "การทุ่มเถียง" | mkN "การทะเลาะวิวาท" | mkN "การทะเลาะเบาะแว้ง" ; -- src=panlex
lin brawl_V = mkV "ทะเลาะวิวาท" | mkV "ทุ่มเถียง" | mkV "ทะเลาะวิวาท" | mkV "ทะเลาะเบาะแว้ง" ; -- src=panlex
lin brawler_N = mkN "นักสู้" ; -- src=panlex
lin brawn_N = mkN "ความล่ำบึก" | mkN "ความมีกล้ามเนื้อ" | mkN "นื้อสุกร" | mkN "เนื้อสุกร" | mkN "กล้ามเนื้อ" | mkN "เนื้อหมูป่าเค็ม" | mkN "กําลังกล้ามเนื้อ" ; -- src=panlex
lin brawny_A = mkA "แข็งแรง" | mkA "กล้ามเนื้อเป็นมัด" | mkA "ซึ่งมีกล้ามเนื้อแข็งแรง" ; -- src=panlex
lin bray_N = mkN "เสียงลา" ; -- src=panlex
lin brazen_A = mkA "หน้าด้าน" | mkA "หน้าไม่อาย" ; -- src=panlex
lin brazier_N = mkN "เตาเหล็ก" | mkN "เตาถ่าน" | mkN "เตาอั้งโล่" | mkN "ช่างทองเหลือง" | mkN "ช่างทําเครื่องทองเหลือง" ; -- src=panlex
lin brazilwood_N = mkN "ต้นพิชวู้ด" | mkN "ต้นบราซิลวู้ด" | mkN "ไม้บราซิลวู้ด" | mkN "ต้นเปอร์แนมบูโกวู้ด" ; -- src=panlex
lin breach_N = mkN "การเปิด" | mkN "การฝ่าฝืน" | mkN "การแตกแยก" | mkN "ความแตกแยก" | mkN "ความแปลกแยก" | mkN "การทะเลาะเบาะแว้ง" | mkN "รอยแตก" ; -- src=panlex
lin bread_N = mkN (thword "ขนม" "ปัง") "ห่อ" ;
lin breadbasket_N = mkN "กระเพาะ" | mkN "กระเพาะอาหาร" | mkN "ตะกร้าขนมปัง" | mkN "เขตที่ผลิตอาหาร" | mkN "ท้อง" | mkN "ตะกร้าใส่ขนมปัง" | mkN "ที่ดินเกษตรที่อุดมสมบูรณ์ด้วยต้นข้าว" | mkN "ดินแดนส่วนที่ผิดอาหารจํานวนมากให้ประเทศ" ; -- src=panlex
lin breadboard_N = mkN "เขียงหั่นขนมปัง" | mkN "กระดานนวดแป้งและหันขนมปัง" | mkN "เขียงหรือกระดานหั่นขนมปัง" ; -- src=panlex
lin breadcrumb_N = mkN "เศษขนมปัง" ; -- src=panlex
lin breadfruit_N = mkN "สาเก" | mkN "ผลสาเก" | mkN "ต้นสาเก" | mkN "ลูกสาเก" | mkN "ผลไม้ขนาดใหญ่เขตร้อน" ; -- src=panlex
lin breadline_N = mkN "แถวรับแจกอาหาร" | mkN "แถวที่รอคอยรับแจกอาหาร" | mkN "ระดับรายได้ของคนที่จนมาก" ; -- src=panlex
lin breadroot_N = mkN "รากที่กินได้" ; -- src=panlex
lin breadstick_N = mkN "ขนมปังแท่ง" ; -- src=panlex
lin breadstuff_N = mkN "ขนมปัง" | mkN "หนมปัง" | mkN "ธัญพืชที่ใช้ทำขนมปัง" | mkN "แป้งทําขนมปัง" | mkN "วัตถุที่ทําขนมปัง" ; -- src=panlex
lin breadth_N = mkN "ความกว้าง" | mkN "ความรอบรู้" | mkN "ความกว้าง" ; -- src=panlex
lin breadthways_Adv = mkAdv "ตามขวาง" | mkAdv "ตามกว้าง" ; -- src=panlex
lin breadthwise_Adv = mkAdv "ตามขวาง" ; -- src=panlex
lin breadwinner_N = mkN "ผู้หาเลี้ยงครอบครัว" | mkN "ผู้หาเลี้ยงครอบครัว" | mkN "ผู้ที่เป็นหลักในการหาเงินเลี้ยงครอบครัว" ; -- src=panlex
lin break_N = mkN "เบรก" | mkN "การหัก" | mkN "การหยุด" | mkN "ช่วงพัก" | mkN "กระดูกแตก" | mkN "การแตกแยก" | mkN "การแหกคุก" | mkN "ความโชคดี" | mkN "ความแตกแยก" | mkN "โอเพ่นเฟรม" | mkN "การทำให้หัก" | mkN "ความแปลกแยก" | mkN "การขัดจังหวะ" | mkN "การหนีออกจาก" | mkN "การเบรกเกมเสิร์ฟ" | mkN "การทะเลาะเบาะแว้ง" | mkN "รอยเลื่อนของเปลือกโลก" | mkN "พัก" | mkN "การแยก" | mkN "การหยุด" | mkN "การแตกหัก" | mkN "การหยุดพัก" | mkN "การเปลี่ยนแปลงอย่างกระทันหัน" ; -- src=panlex
lin break_V = mkV "งัด" | mkV "พัก" | mkV "หัก" | mkV "แตก" | mkV "ถล่ม" | mkV "ทรุด" | mkV "ทลาย" | mkV "ยุติ" | mkV "เลิก" | mkV "เสีย" | mkV "ทำลาย" | mkV "ทุเลา" | mkV "ผิดกฎ" | mkV "กระจาย" | mkV "ฝ่าฝืน" | mkV "ยุบตัว" | mkV "ระเบิด" | mkV "ลดขั้น" | mkV "ละเมิด" | mkV "แตกหัก" | mkV "แยกทาง" | mkV "แหกคุก" | mkV "ดิ่งเหว" | mkV "พังทลาย" | mkV "หล่นวูบ" | mkV "เปิดเผย" | mkV "แตกร้าว" | mkV "ทำให้แตก" | mkV "เกิดขึ้น" | mkV "เสียงแตก" | mkV "แหกตาราง" | mkV "ขัดจังหวะ" | mkV "ลดผลกระทบ" | mkV "เลิกนิสัย" | mkV "แหกกรงขัง" | mkV "ทำให้แตกออก" | mkV "ทำให้แยกออก" | mkV "ทำให้สิ้นสุด" | mkV "ทำให้ล้มละลาย" | mkV "ทำให้เชื่อฟัง" | mkV "เต้นเบรคแดนซ์" | mkV "แตกเป็นเสี่ยง" | mkV "ทำให้กระดูกหัก" | mkV "ทำได้ยอดเยี่ยม" | mkV "ย่างกรายเข้ามา" | mkV "ดิ่งลงอย่างหนัก" | mkV "ทำให้ไม่สมบูรณ์" | mkV "ทำให้ใช้การไม่ได้" | mkV "อ่อนแอทั้งกายและใจ" | mkV "ทุบ" | mkV "ฝ่า" | mkV "หัก" | mkV "แตก" | mkV "แยก" | mkV "แหก" | mkV "หยุด" | mkV "แหวก" | mkV "ล่มจม" | mkV "ขัดขืน" | mkV "ทําลาย" | mkV "ฝ่าฝืน" | mkV "ละเมิด" | mkV "แตกหัก" | mkV "ล้มละลาย" | mkV "เกิดขึ้น" | mkV "ล่วงละเมิด" | mkV "กระจัดกระจาย" ; -- src=panlex
lin break_V2 = mkV2 "แตกหัก" ;
lin break_apart_V = advV OP_break_V OP_apart_Adv ; -- guess-p-verb
lin break_away_V = advV OP_break_V OP_away_Adv ; -- guess-p-verb
lin break_down_V = advV OP_break_V OP_down_Adv ; -- guess-p-verb
lin break_down_V2 = prepV2 OP_break_V OP_down_Prep ; -- guess-p-verb
lin break_in_V = advV OP_break_V OP_in_Adv ; -- guess-p-verb
lin break_in_V2 = prepV2 OP_break_V OP_in_Prep ; -- guess-p-verb
lin break_in_on_V2 = prepV2 (advV OP_break_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin break_into_V2 = prepV2 OP_break_V OP_into_Prep ; -- guess-p-verb
lin break_off_V2 = prepV2 OP_break_V OP_off_Prep ; -- guess-p-verb
lin break_out_V = advV OP_break_V OP_out_Adv ; -- guess-p-verb
lin break_out_V2 = prepV2 OP_break_V OP_out_Prep ; -- guess-p-verb
lin break_out_in_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin break_out_of_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin break_through_V2 = prepV2 OP_break_V OP_through_Prep ; -- guess-p-verb
lin break_up_V = advV OP_break_V OP_up_Adv ; -- guess-p-verb
lin break_up_V2 = prepV2 OP_break_V OP_up_Prep ; -- guess-p-verb
lin breakable_N = mkN "ของแตกง่าย" ; -- src=panlex
lin breakage_N = mkN "การหัก" | mkN "การทำให้หัก" | mkN "การแตก" | mkN "รอยแตก" | mkN "การแตกออก" | mkN "ค่าชํารุด" | mkN "ภาวะที่แตกออก" | mkN "เงินค่าเสื่อมหรือสึกหรอ" ; -- src=panlex
lin breakaway_A = mkA "ซึ่งแยกตัวออกมา" ; -- src=panlex
lin breakax_N = mkN "ต้นเบรคแอกซ์" ; -- src=panlex
lin breakdown_N = mkN "การหยุด" | mkN "การเสีย" | mkN "การแบ่ง" | mkN "การหมดกำลังใจ" | mkN "อาการสติฟั่นเฟือน" | mkN "การหยุดลง" | mkN "การล้มเจ็บ" | mkN "การสลายตัว" | mkN "การไม่สบาย" | mkN "ความล้มเหลว" | mkN "การวิเคราะห์" ; -- src=panlex
lin breaker_N = mkN "คลื่น" | mkN "คนตัดหิน" | mkN "เบรกเกอร์" | mkN "คลื่นกระทบฝั่ง" | mkN "เครื่องตัดวงจร" | mkN "ผู้หัก" | mkN "ผู้ทําลาย" | mkN "เครื่องบด" | mkN "ผู้บุกเบิก" | mkN "ยางในรถยนตร์" | mkN "คลื่นขนาดใหญ่" | mkN "ผู้ทําให้เชื่อง" | mkN "ตัวแยกทางเดินไฟฟ้า" | mkN "คลื่นแยกเส้นใยผ้าจากสิ่งแปลกปลอม" ; -- src=panlex
lin breakfast_N = mkN "ข้าวเช้า" | mkN "มื้อเช้า" | mkN "อาหารเช้า" | mkN "เบรกฟาสต์" | mkN "อาหารมื้อเช้า" | mkN "อาหารเบรกฟาสต์" | mkN "อาหารเช้า" | mkN "อาหารมื้อเช้า" ; -- src=panlex
lin breakfast_V = mkV "กินข้าวเช้า" | mkV "กินมื้อเช้า" | mkV "จัดอาหารเช้า" | mkV "รับประทานอาหารเช้า" | mkV "กินอาหารเช้า" | mkV "ทานอาหารเช้า" ; -- src=panlex
lin breakneck_A = mkA "อันตรายมาก" | mkA "เร็วและอันตรายมาก" ; -- src=panlex
lin breakout_N = mkN "การแหกคุก" | mkN "การหนีออกจาก" | mkN "การแหกคุก" | mkN "การฝ่าวงล้อม" | mkN "การระบาดของโรค" ; -- src=panlex
lin breakthrough_N = mkN "การค้นพบ" | mkN "การบุกทะลวง" | mkN "การฝ่าอุปสรรค" | mkN "การพัฒนาอย่างมากมายยิ่ง" | mkN "การบุกเข้าไปในแนวเขตของข้าศึก" | mkN "การพัฒนาหรือการค้นพบที่ยิ่งใหญ่" | mkN "การก้าวหน้าทางวิทยาศาสตร์ครั้งสําคัญยิ่ง" | mkN "เหตุการณ์หรือการกระทําที่ทําให้อุปสรรคหมดไป" ; -- src=panlex
lin break_up_N = mkN "การแยก" | mkN "การแยกตัว" ; -- src=panlex
lin breakwater_N = mkN "พนัง" | mkN "เขื่อนกันคลื่น" | mkN "เขื่อนกั้นทะเล" | mkN "เขื่อนกันชายฝั่งหรือท่าเรือจากคลื่นของน้ําทะเล" ; -- src=panlex
lin bream_N = mkN "ปลาบรีม" | mkN "ปลาซีบรีม" | mkN "เนื้อปลาบรีม" | mkN "ปลาบรีมน้ำจืด" | mkN "เนื้อปลาซีบรีม" | mkN "เนื้อปลาบรีมน้ำจืด" | mkN "ปลาน้ําจืด ซึ่งคล้ายปลาตะเพียน" | mkN "ปลาทะเลชนิดหนึ่ง" ; -- src=panlex
lin breast_N = mkN (thword "หน้า" "อก") | {-pan-} mkN "นม" | mkN "อก" | mkN "ถัน" | mkN "เต้า" | mkN "ทรวงอก" | mkN "พระถัน" | mkN "หน้าอก" | mkN "เต้านม" | mkN "พระทรวง" | mkN "พระอุระ" | mkN "พระเต้า" | mkN "เนื้อหน้าอก" | mkN "หน้าอกหน้าใจ" | mkN "หน้าอกของผู้หญิง" | mkN "นม" | mkN "ถัน" | mkN "หน้าอก" ; -- src=panlex
lin breastfeed_V = mkV "ให้ดูดนม" | mkV "ให้ลูกดูดนมจากอก" ; -- src=panlex
lin breastfeed_V2 = mkV2 "ให้ดูดนม" ; ---- | mkV "ให้ลูกดูดนมจากอก" ; -- src=panlex
lin breast_plate_N = mkN "เกราะเเผ่นอก" | mkN "เกราะป้องกันหน้าอก" | mkN "เกราะหน้าอก" | mkN "เสื้อเกราะทหารป้องกันส่วนบนของร่างกาย" ; -- src=panlex
lin breaststroke_N = mkN "ท่ากบ" | mkN "การว่ายกบ" | mkN "การว่ายน้ําท่าผีเสื้อ" ; -- src=panlex
lin breaststroker_N = mkN "นักว่ายน้ำท่ากบ" ; -- src=panlex
lin breath_N = mkN "กระแสลม" | mkN "คำแนะนำ" | mkN "ลมหายใจ" | mkN "การหายใจ" | mkN "การชี้แนะ" | mkN "การบอกใบ้" | mkN "ช่วงพักหายใจ" | mkN "ลมหายใจเข้าออก" | mkN "กลิ่น" | mkN "ชีวิต" | mkN "ร่องรอย" | mkN "ลมหายใจ" | mkN "กลิ่นปาก" | mkN "การหายใจ" | mkN "พลังชีวิต" | mkN "กระแสลมอ่อน" | mkN "การพูดเป็นนัยๆ" | mkN "การหายใจเข้าครั้งหนึ่ง" | mkN "การแสดงข้อคิดเห็นเล็กน้อย" ; -- src=panlex
lin breathalyser_N = mkN "เครื่องตรวจวัดปริมาณแอลกอฮอล์" | mkN "เครื่องวัดปริมาณแอลกอฮอล์แบบเป่า" | mkN "เครื่องวัดปริมาณแอลกอฮอล์จากลมหายใจ" | mkN "เครื่องวัดปริมาณอัลกอฮอล์จากลมหายใจ" ; -- src=panlex
lin breathalyzer_N = mkN "เครื่องตรวจวัดปริมาณแอลกอฮอล์" | mkN "เครื่องวัดปริมาณแอลกอฮอล์แบบเป่า" | mkN "เครื่องวัดปริมาณแอลกอฮอล์จากลมหายใจ" | mkN "เครื่องวัดปริมาณอัลกอฮอล์จากลมหายใจ" ; -- src=panlex
lin breathe_V = mkV (thword "หาย" "ใจ") | {-pan-} mkV "พัก" | mkV "หายใจ" | mkV "ขับกลิ่น" | mkV "มีลมหายใจ" | mkV "ปล่อยกลิ่น" | mkV "หายใจเข้าออก" | mkV "หายใจ" | mkV "พักผ่อน" | mkV "คลายเครียด" | mkV "พักเหนื่อย" | mkV "หยุดชั่วหายเหนื่อย" ; -- src=panlex
lin breathe_V2 = mkV2 (thword "หาย" "ใจ") ; ---- | {-pan-} mkV "พัก" | mkV "หายใจ" | mkV "ขับกลิ่น" | mkV "มีลมหายใจ" | mkV "ปล่อยกลิ่น" | mkV "หายใจเข้าออก" | mkV "หายใจ" | mkV "พักผ่อน" | mkV "คลายเครียด" | mkV "พักเหนื่อย" | mkV "หยุดชั่วหายเหนื่อย" ; -- src=panlex
lin breather_N = mkN "ช่วงพักหายใจ" | mkN "ท่อช่วยหายใจ" | mkN "ผู้หายใจ" | mkN "หลอดหายใจ" | mkN "การหยุดพัก" | mkN "คนที่ชีวิต" | mkN "หลอดระบายอากาศ" | mkN "การพักผ่อนระยะสั้น" ; -- src=panlex
lin breathing_N = mkN "การหายใจ" | mkN "การหายใจ" | mkN "การเอ่ยคํา" | mkN "ความปรารถนา" | mkN "การโชยพัดเบา" | mkN "ชั่วแวบเดียว" | mkN "กระบวนการหายใจ" | mkN "การหยุดพักหายใจ" | mkN "การหายใจอึดหนึ่ง" ; -- src=panlex
lin breathless_A = mkA "กระหืดกระหอบ" | mkA "ซึ่งไม่หายใจ" | mkA "ซึ่งชีพจรไม่เต้น" | mkA "หอบ" | mkA "ไม่มีลม" | mkA "ขาดใจตาย" | mkA "อยู่นิ่ง" | mkA "ขาดลมหายใจ" | mkA "หายใจลําบาก" | mkA "ไม่เคลื่อนไหว" | mkA "ทําให้หายใจขัด" ; -- src=panlex
lin breathtaking_A = mkA "ซึ่งตื่นเต้นยินดีอย่างมาก" | mkA "ทําให้ยินดีตื่นเต้นหรือน่ากลัวมาก" ; -- src=panlex
lin breccia_N = mkN "หินกรวดเหลี่ยม" ; -- src=panlex
lin breech_N = mkN "พานท้ายปืน" | mkN "ก้น" | mkN "ตะโพก" | mkN "สะโพก" ; -- src=panlex
lin breech_block_N = mkN "เครื่องปืน" | mkN "ส่วนหุ้มท้ายของกระบอกปืน" ; -- src=panlex
lin breechcloth_N = mkN "ผ้าเตี่ยว" | mkN "ผ้าคาดเอว" ; -- src=panlex
lin breeched_A = mkA "ซึ่งสวมกางเกง" ; -- src=panlex
lin breeches_N = mkN "กางเกงสั้นแค่เข่า" | mkN "กางเกง" | mkN "กางเกงขี่ม้า" | mkN "กางเกงขายาวแค่เข่า" ; -- src=panlex
lin breechloader_N = mkN "ปืนบรรจุกระสุนท้ายลำกล้อง" | mkN "ปืนที่บรรจุทางท้ายปืน" ; -- src=panlex
lin breed_N = mkN "พันธุ์" | mkN "พันธุ์" ; -- src=panlex
lin breed_V = mkV "ตกลูก" | mkV "ผสมพันธุ์" | mkV "ก่อให้เกิด" | mkV "เพาะพันธุ์" | mkV "เพาะเลี้ยง" | mkV "เลี้ยง" | mkV "ต่อพันธุ์" | mkV "ผสมพันธุ์" | mkV "ให้กําเนิด" ; -- src=panlex
lin breed_V2 = mkV2 "ตกลูก" ; ---- | mkV "ผสมพันธุ์" | mkV "ก่อให้เกิด" | mkV "เพาะพันธุ์" | mkV "เพาะเลี้ยง" | mkV "เลี้ยง" | mkV "ต่อพันธุ์" | mkV "ผสมพันธุ์" | mkV "ให้กําเนิด" ; -- src=panlex
lin breeder_N = mkN "คนให้อาหารสัตว์" | mkN "คนอบรม" | mkN "คนเลี้ยง" | mkN "ผผสมพันธุ์สัตว์" | mkN "สัตว์หรือพืชที่ออกลูก" | mkN "คนผสมพันธุ์พืชหรือสัตว์" ; -- src=panlex
lin breeding_N = mkN "การอบรม" | mkN "การศึกษา" | mkN "ความสุภาพ" | mkN "การเลี้ยงดู" | mkN "การตั้งครรภ์" | mkN "การผสมพันธุ์สัตว์" | mkN "การออกลูก" | mkN "การเพาะพันธ์" | mkN "การผสมพันธุ์สัตว์เพื่อขยายพันธุ์" ; -- src=panlex
lin breeze_N = mkN "ลม" | mkN "ลมโชย" | mkN "งานเบา" | mkN "งานง่ายๆ" | mkN "ของกล้วยๆ" | mkN "สายลมอ่อนๆ" | mkN "เรื่องกล้วยๆ" | mkN "สายลมที่พัดเบาๆ" ; -- src=panlex
lin breeze_V = mkV "พัดโชย" | mkV "เคลื่อนที่อย่างรวดเร็ว" ; -- src=panlex
lin breezy_A = mkA "สดชื่น" | mkA "สบายใจ" | mkA "มีลมพัด" | mkA "มีลมพัดอ่อน" | mkA "ที่พัดอย่างเบาๆ" ; -- src=panlex
lin bregma_N = mkN "เบรกมา" ; -- src=panlex
lin brethren_N = mkN "พี่น้อง" ; -- src=panlex
lin breve_N = mkN "ตัวสี่เหลี่ยม" | mkN "พระราชโองการแรกเริ่ม" | mkN "เครื่องหมายเน้นเสียง" | mkN "เครื่องหมายการออกเสียงสั้น" ; -- src=panlex
lin breviary_N = mkN "ใจความสําคัญ" ; -- src=panlex
lin brevity_N = mkN "ความกระชับ" | mkN "ระยะเวลาสั้นๆ" | mkN "ระยะเวลาที่สั้น" | mkN "การใช้คําที่สั้นกระชับ" ; -- src=panlex
lin brew_N = mkN "เหล้า" ; -- src=panlex
lin brew_V = mkV "ชง" | mkV "บ่ม" | mkV "หมัก" | mkV "หมักบ่ม" | mkV "ชง" | mkV "ตั้งเค้า" | mkV "ทําเหล้า" | mkV "ทําเบียร์" ; -- src=panlex
lin brew_V2 = mkV2 "ชง" ; ---- | mkV "บ่ม" | mkV "หมัก" | mkV "หมักบ่ม" | mkV "ชง" | mkV "ตั้งเค้า" | mkV "ทําเหล้า" | mkV "ทําเบียร์" ; -- src=panlex
lin brewer_N = mkN "คนต้มเหล้า" | mkN "คนต้มเบียร์" | mkN "เจ้าของโรงเหล้า" | mkN "ผู้ต้มเหล้า" ; -- src=panlex
lin brewery_N = mkN "โรงงานทำเหล้า" | mkN "โรงงานต้มเหล้า" | mkN "โรงงานต้มเบียร์)" ; -- src=panlex
lin brewing_N = mkN "ผลิตภัณฑ์เหล้า" | mkN "การตั้งเค้า" | mkN "การต้มหรือกลั่นเหล้าเบียร์" ; -- src=panlex
lin brewpub_N = mkN "ร้านเบียร์" ; -- src=panlex
lin briar_N = mkN "กุหลาบป่า" | mkN "ต้นทรีฮีท" | mkN "ต้นกรีนไบรเออร์" | mkN "พุ่มไม้มีหนามเช่น กุหลาบป่า" ; -- src=panlex
lin briarwood_N = mkN "ไม้เบรียร์วู้ด" ; -- src=panlex
lin bribable_A = mkA "ที่ทุจริต" | mkA "ที่ซื้อได้" | mkA "ที่ไม่สุจริต" ; -- src=panlex
lin bribe_N = mkN "สินบน" | mkN "สินบน" ; -- src=panlex
lin bribe_V = mkV "ซื้อ" | mkV "ติดสินบน" | mkV "จ่ายใต้โต๊ะ" | mkV "ติดสินบน" | mkV "ให้สินบน" ; -- src=panlex
lin bribe_V2 = mkV2 "ซื้อ" ; ---- | mkV "ติดสินบน" | mkV "จ่ายใต้โต๊ะ" | mkV "ติดสินบน" | mkV "ให้สินบน" ; -- src=panlex
lin briber_N = mkN "ผู้ให้สินบน" ; -- src=panlex
lin bribery_N = mkN "การติดสินบน" | mkN "การติดสินบน" | mkN "การให้สินบน" ; -- src=panlex
lin brick_N = mkN "อิฐ" | mkN "อิฐ" | mkN "คนดี" | mkN "ิอิฐ" | mkN "ดินเผา" | mkN "ก้อนอิฐ" | mkN "คล้ายอิฐ" | mkN "สิ่งที่คล้ายอิฐ" ; -- src=panlex
lin brickbat_N = mkN "เศษอิฐ" | mkN "คําตําหนิ" | mkN "เศษที่ใช้เหวี่ยงขว้าง" ; -- src=panlex
lin brickkiln_N = mkN "เตาเผาอิฐ" | mkN "เตาเผาอิฐ" ; -- src=panlex
lin bricklayer_N = mkN "ช่างก่ออิฐ" | mkN "ช่างปูน" ; -- src=panlex
lin bricklaying_N = mkN "การก่ออิฐ" ; -- src=panlex
lin brickwork_N = mkN "งานก่ออิฐ" | mkN "งานก่ออิฐ" | mkN "สิ่งก่อสร้างที่ทําด้วยอิฐ" ; -- src=panlex
lin brickyard_N = mkN "โรงอิฐ" | mkN "สถานที่ทําอิฐ" ; -- src=panlex
lin bridal_A = mkA "งานเลี้ยงแต่งงาน" | mkA "เกี่ยวกับเจ้าสาว" | mkA "เกี่ยวกับงานแต่งงาน" ; -- src=panlex
lin bridal_N = mkN "การสมรส" | mkN "งานวิวาห์" ; -- src=panlex
lin bride_N = mkN "เจ้าสาว" | mkN "เจ้าสาว" | mkN "หญิงที่เพิ่งแต่งงาน" ; -- src=panlex
lin bridecake_N = mkN "เค้กแต่งงาน" | mkN "ขนมเค้กแต่งงาน" | mkN "เค้กงานแต่งงาน" ; -- src=panlex
lin bridegroom_N = mkN "เจ้าบ่าว" | mkN "เจ้าบ่าว" | mkN "ชายที่เพิ่งแต่งงาน" ; -- src=panlex
lin bridesmaid_N = mkN "เพื่อนเจ้าสาว" | mkN "เพื่อนเจ้าสาว" ; -- src=panlex
lin bridge_N = mkN "สะพาน" | mkN "บริดจ์" | mkN "ดั้งจมูก" | mkN "ไพ่บริดจ์" | mkN "ดาดฟ้าเรือ" | mkN "วงจรบริดจ์" | mkN "ที่ยึดฟันปลอม" | mkN "ข้าม" | mkN "ดั้ง" | mkN "สะพาน" | mkN "ทอดข้าม" | mkN "ผ่านพ้น" | mkN "ดั้งจมูก" | mkN "ตัวเชื่อม" | mkN "สะพานเรือ" | mkN "ไพ่บริดจ์" | mkN "ดั้งแว่นตา" | mkN "ที่ยึดฟันปลอม" | mkN "หอบังคับการเรือ" | mkN "สิ่งเชื่อมประสาน" | mkN "เครื่องวัดความฝืดของกระแสไฟฟ้า" ; -- src=panlex
lin bridgeable_A = mkA "ที่เชื่อมโยงได้" ; -- src=panlex
lin bridgehead_N = mkN "หัวหาด" | mkN "หัวสะพาน" | mkN "ที่มั่นริมแม่น้ําทางฝั่งข้าศึก" | mkN "ที่มั่นของกองทัพที่อยู่ในดินแดนข้าศึก" ; -- src=panlex
lin bridle_N = mkN "บังเหียน" | mkN "การควบคุม" | mkN "ควบคุม" | mkN "สายรั้ง" | mkN "บังเหียน" | mkN "สิ่งรั้ง" | mkN "เชิดหน้า" | mkN "สิ่งควบคุม" | mkN "บังเหียนม้า" | mkN "สายบังเหียน" | mkN "เครื่องบังคับม้า" | mkN "สิ่งบังคับการหมุน" | mkN "เชือกหรือโซ่ผูกเรือ" ; -- src=panlex
lin bridle_V = mkV "บังเหียน" | mkV "สวมบังเหียน" ; -- src=panlex
lin bridle_V2 = mkV2 "บังเหียน" ; ---- | mkV "สวมบังเหียน" ; -- src=panlex
lin bridoon_N = mkN "เชือกบังเหียน" ; -- src=panlex
lin brief_A = mkA "ย่อๆ" | mkA "สรุป" | mkA "สั้นๆ" | mkA "โดยย่อ" | mkA "โดยสรุป" | mkA "อย่างย่อ" | mkA "โดยสังเขป" | mkA "อย่างสั้นๆ" ; -- src=panlex
lin brief_N = mkN "เรื่องย่อ" ; -- src=panlex
lin briefcase_N = mkN "กระเป๋าใส่เอกสาร" | mkN "กระเป๋าหิ้ว" | mkN "กระเป๋าเอกสาร" | mkN "กระเป๋าหิ้วใส่เอกสาร" ; -- src=panlex
lin briefing_N = mkN "ข้อสรุป" | mkN "คําสั่งสั้น" | mkN "สรุปแบบสั้นๆ" | mkN "คําแถลงการณ์สั้น" ; -- src=panlex
lin briefless_A = mkA "ซึ่งไม่มีใครจ้างไปว่าความ" ; -- src=panlex
lin briefness_N = mkN "ความสั้น" | mkN "ความกระชับ" ; -- src=panlex
lin brier_N = mkN "ไบรเออร์" | mkN "กุหลาบป่า" | mkN "ต้นทรีฮีท" | mkN "ต้นกรีนไบรเออร์" | mkN "พุ่มไม้ที่มีหนาม" | mkN "พุ่มไม้มีหนามเช่น กุหลาบป่า" | mkN "ต้นไม้ที่มีหนามมาก" ; -- src=panlex
lin brig_N = mkN "คุกเรือรบ" | mkN "เรือใบสองเสา" | mkN "เรือใบสองเสา" | mkN "สถานที่กักขัง" | mkN "ห้องคุกในเรือ" | mkN "เรือที่มีเสากระโดง 2 เสา" ; -- src=panlex
lin brigade_N = mkN "กองพลน้อย" ; -- src=panlex
lin brigadier_N = mkN "พล.จ." | mkN "พลจัตวา" | mkN "นายพลจัตวา" | mkN "นายพลจัตวากองทัพบก" ; -- src=panlex
lin brigand_N = mkN "โจรร่วมขบวนการ" | mkN "โจร" | mkN "โจรผู้ร้าย" | mkN "อาชญากรที่ปล้นของคนเดินทาง" ; -- src=panlex
lin brigandine_N = mkN "ชุดเกราะบริเกินดีน" ; -- src=panlex
lin brigantine_N = mkN "เรือใบสองเสากระโดง" ; -- src=panlex
lin bright_A = mkA "จ้า" | mkA "สว่าง" | mkA "เจิดจ้า" | mkA "ซึ่งมีความหวัง" | mkA "ใส" | mkA "จ้า" | mkA "ฉาน" | mkA "ฉลาด" | mkA "สดใส" | mkA "เร็ว" | mkA "สว่าง" | mkA "หัวไว" | mkA "ฉูดฉาด" | mkA "สีสดใส" | mkA "แจ่มใส" | mkA "ร่าเริง" | mkA "หลักแหลม" | mkA "โชติช่วง" | mkA "สีเจิดจ้า" | mkA "เฉียบแหลม" | mkA "มีชีวิตชีวา" | mkA "มีชื่อเสียงโด่งดัง" ; -- src=panlex
lin bright_Adv = mkAdv "อย่างร่าเริงแจ่มใส" ; -- src=panlex
lin brighten_V = mkV "เปิด" | mkV "ทำให้สว่าง" | mkV "สดใส" | mkV "สว่าง" | mkV "ทําให้สว่าง" ; -- src=panlex
lin brighten_V2 = mkV2 "เปิด" ; ---- | mkV "ทำให้สว่าง" | mkV "สดใส" | mkV "สว่าง" | mkV "ทําให้สว่าง" ; -- src=panlex
lin brightness_N = mkN "ปฏิภาณ" | mkN "ไหวพริบ" | mkN "ความสว่าง" | mkN "เชาว์ปัญญา" | mkN "ไหวพริบปฏิภาณ" | mkN "ความสดใส" | mkN "ความสว่าง" | mkN "ความผ่องใส" | mkN "ความแจ่มใส" | mkN "ภาวะที่สว่าง" ; -- src=panlex
lin brill_N = mkN "ปลาบริล" | mkN "ปลาทะเลแบนในยุโรปชนิดหนึ่ง" ; -- src=panlex
lin brilliance_N = mkN "จีเนียส" | mkN "ความงดงาม" | mkN "ความสว่าง" | mkN "ความโอ่อ่า" | mkN "ความเจิดจรัส" | mkN "ความสว่างสุกใส" | mkN "ความฉลาดหลักแหลม" | mkN "ความฉลาดปราดเปรื่อง" | mkN "ความฉลาด" | mkN "ความสุกใส" | mkN "ความแวววาว" | mkN "ความฉลาดมาก" | mkN "ความสุกใสมาก" | mkN "ความหลักแหลม" | mkN "ความโชติช่วง" | mkN "ความเป็นประกาย" | mkN "ความหลักแหลมมาก" ; -- src=panlex
lin brilliancy_N = mkN "สุกใส" | mkN "ส่องสว่าง" ; -- src=panlex
lin brilliant_A = mkA "สว่าง" | mkA "เจิดจ้า" | mkA "งดงาม" | mkA "สุกใส" | mkA "สวยงาม" | mkA "ฉลาดมาก" | mkA "พรายแสง" | mkA "ส่องแสง" | mkA "แพรวพราย" | mkA "แพรวพราว" | mkA "โชติช่วง" | mkA "พริ้งพราย" | mkA "หลักแหลมมาก" ; -- src=panlex
lin brilliantine_N = mkN "น้ำมันใส่ผม" | mkN "น้ํามันใส่ผม" ; -- src=panlex
lin brim_N = mkN "ปาก" | mkN "ปากขวด" | mkN "ปีกหมวก" | mkN "ขอบ" | mkN "ปาก" | mkN "ริม" | mkN "ปีกหมวก" ; -- src=panlex
lin brim_V = mkV "คลอ" | mkV "เติมจนปริ่ม" | mkV "เติม" | mkV "เต็ม" | mkV "ปริ่ม" | mkV "เปี่ยม" ; -- src=panlex
lin brimful_A = mkA "ปริ่ม" | mkA "เต็มเปี่ยม" ; -- src=panlex
lin brimless_A = mkA "ไม่มีขอบ" ; -- src=panlex
lin brimstone_N = mkN "กํามะถัน" | mkN "สารกํามะถัน" | mkN "หญิงที่มีอารมณ์ร้าย" | mkN "หญิงที่กล้าและแข็งแรงอย่างผู้ชาย" ; -- src=panlex
lin brindled_A = mkA "ซึ่งมีลาย" ; -- src=panlex
lin brine_N = mkN "น้ำเกลือ" | mkN "ทะเล" | mkN "น้ําทะเล" | mkN "น้ําเค็ม" | mkN "มหาสมุทร" | mkN "น้ํามหาสมุทร" | mkN "ใส่ลงในน้ําเกลือ" ; -- src=panlex
lin bring_about_V2 = prepV2 (lin V OP_bring_V2) OP_about_Prep ; -- guess-p-verb
lin bring_along_V2 = prepV2 (lin V OP_bring_V2) OP_along_Prep ; -- guess-p-verb
lin bring_around_V2 = prepV2 (lin V OP_bring_V2) OP_around_Prep ; -- guess-p-verb
lin bring_away_V2 = mkV2 (advV (lin V OP_bring_V2) OP_away_Adv ) ; -- guess-p-verb
lin bring_back_V2 = mkV2 (advV (lin V OP_bring_V2) OP_back_Adv ) ; -- guess-p-verb
lin bring_down_V2 = prepV2 (lin V OP_bring_V2) OP_down_Prep ; -- guess-p-verb
lin bring_forth_V = advV (lin V OP_bring_V2) OP_forth_Adv ; -- guess-p-verb
lin bring_forth_V2 = mkV2 (advV (lin V OP_bring_V2) OP_forth_Adv ) ; -- guess-p-verb
lin bring_forward_V2 = mkV2 (advV (lin V OP_bring_V2) OP_forward_Adv ) ; -- guess-p-verb
lin bring_in_V2 = prepV2 (lin V OP_bring_V2) OP_in_Prep ; -- guess-p-verb
lin bring_off_V2 = prepV2 (lin V OP_bring_V2) OP_off_Prep ; -- guess-p-verb
lin bring_on_V2 = prepV2 (lin V OP_bring_V2) OP_on_Prep ; -- guess-p-verb
lin bring_out_V2 = prepV2 (lin V OP_bring_V2) OP_out_Prep ; -- guess-p-verb
lin bring_out_in_V3 = variants {} ; -- guess-p-verb
lin bring_over_V2 = prepV2 (lin V OP_bring_V2) OP_over_Prep ; -- guess-p-verb
lin bring_round_V2 = prepV2 (lin V OP_bring_V2) OP_round_Prep ; -- guess-p-verb
lin bring_to_V2 = prepV2 (lin V OP_bring_V2) OP_to_Prep ; -- guess-p-verb
lin bring_up_V2 = prepV2 (lin V OP_bring_V2) OP_up_Prep ; -- guess-p-verb
lin brininess_N = mkN "ระดับความเค็ม" ; -- src=panlex
lin brink_N = mkN "ปากเหว" | mkN "เส้นขอบ" | mkN "ขีดจำกัด" | mkN "ขอบ" | mkN "ริม" ; -- src=panlex
lin brinkmanship_N = mkN "สถานการณ์เสี่ยงภัย" ; -- src=panlex
lin brioche_N = mkN "บริโอเช่" | mkN "ยีสต์และเนย" | mkN "ขนมปังที่ผสมด้วยไข่" ; -- src=panlex
lin briquette_N = mkN "ถ่านหินกลมที่ใช้เป็นเชื้อเพลิง" ; -- src=panlex
lin brisance_N = mkN "อํานาจทําลายของดินระเบิดแรงสูง" ; -- src=panlex
lin brisk_A = mkA "ที่ไปได้ดี" | mkA "ที่ไปได้สวย" | mkA "ไว" | mkA "รวดเร็ว" | mkA "ปราดเปรียว" | mkA "กระวีกระวาด" | mkA "กระฉับกระเฉง" ; -- src=panlex
lin brisket_N = mkN "เนื้อส่วนอก" | mkN "เนื้อหน้าอก" | mkN "หน้าอกของสัตว์" | mkN "เนื้อส่วนอกสัตว์ โดยเฉพาะวัว" ; -- src=panlex
lin brisling_N = mkN "ปลาบริสลิง" | mkN "ปลาเฮอร์ริ่งกระป๋อง" ; -- src=panlex
lin bristle_N = mkN "ขนแข็ง" | mkN "ขนแข็งของสัตว์" ; -- src=panlex
lin bristle_V = mkV "ขนลุก" | mkV "อลเวง" ; -- src=panlex
lin bristlelike_A = mkA "ที่คล้ายขนแข็ง" ; -- src=panlex
lin bristly_A = mkA "ซึ่งมีหนาม" | mkA "ฉุนเฉียว" | mkA "มีขนแข็ง" | mkA "โกรธง่าย" | mkA "โกรธเร็ว" | mkA "มีหนามแหลม" ; -- src=panlex
lin brit_N = mkN "ลูกปลาแฮร์ริ่ง" ; -- src=panlex
lin britannic_A = mkA "เกี่ยวกับบริเทน" | mkA "เกี่ยวกับอังกฤษ" ; -- src=panlex
lin briton_N = mkN "ชาวอังกฤษ" | mkN "ชาวเครือจักรภพอังกฤษ" ; -- src=panlex
lin brittle_A = mkA "เปราะ" | mkA "บอบบาง" | mkA "หักง่าย" | mkA "แตกง่าย" | mkA "งอไม่ได้" ; -- src=panlex
lin brittle_N = mkN "ลูกอม" | mkN "ทอฟฟี่" | mkN "ขนมหวานชนิดหนึ่ง" ; -- src=panlex
lin brittlebush_N = mkN "ต้นบริตเทิลบุช" ; -- src=panlex
lin brittleness_N = mkN "ความกรอบ" | mkN "ความเปราะ" | mkN "เปราะบาง" ; -- src=panlex
lin broach_V = mkV "เสนอประเด็น" | mkV "เริ่มพูดคุยในเรื่องที่น่าอับอายหรือคนอื่นไม่ยอมรับ" ; -- src=panlex
lin broach_V2 = mkV2 "เสนอประเด็น" ; ---- | mkV "เริ่มพูดคุยในเรื่องที่น่าอับอายหรือคนอื่นไม่ยอมรับ" ; -- src=panlex
lin broad_A = mkA "กว้าง" | {-pan-} mkA "กว้างๆ" | mkA "กว้างสุดลูกหูลูกตา" | mkA "ซึ่งเปิดกว้างทางความคิด" | mkA "หยาบ" | mkA "หลวมๆ" | mkA "ทั่วๆ ไป" | mkA "กว้างๆ" | mkA "ทั่วโลก" | mkA "ครอบคลุม" | mkA "กว้างขวาง" | mkA "ไม่จํากัด" ; -- src=panlex
lin broad_N = mkN "ผู้หญิง" | mkN "แสก" | mkN "หยาบ" | mkN "กว้าง" | mkN "ผู้หญิง" | mkN "โจ่งแจ้ง" | mkN "กว้างขวาง" | mkN "เวิ้งว้าง" | mkN "หญิงสําส่อน" | mkN "ไม่ถูกจํากัด" | mkN "ไม่เกลี้ยงเกลา" ; -- src=panlex
lin broadax_N = mkN "ขวานใหญ่" | mkN "ขวานตัดไม้ซุง" ; -- src=panlex
lin broadbill_N = mkN "นกโบตบิล" | mkN "นกบรอดบิล" | mkN "เป็ดปากพลั่ว" | mkN "เป็ดสกอปดั๊ก" ; -- src=panlex
lin broadcast_N = mkN "รายการ" | mkN "การถ่ายทอด" | mkN "รายการออกอากาศ" | mkN "รายการออกอากาศ" | mkN "ข้อความที่ออกอากาศ" ; -- src=panlex
lin broadcast_V = mkV "ถ่ายทอด" | mkV "ออกอากาศ" | mkV "กระจายเสียง" | mkV "ทำให้แพร่หลาย" | mkV "แจ้ง" | mkV "กระจาย" | mkV "เผยแพร่" ; -- src=panlex
lin broadcast_V2 = mkV2 "ถ่ายทอด" ; ---- | mkV "ออกอากาศ" | mkV "กระจายเสียง" | mkV "ทำให้แพร่หลาย" | mkV "แจ้ง" | mkV "กระจาย" | mkV "เผยแพร่" ; -- src=panlex
lin broadcaster_N = mkN "เครื่องหว่าน" | mkN "ผู้กระจายเสียงทางวิทยุโทรทัศน์" | mkN "ผู้กระจายเสียงทางวิทยุหรือโทรทัศน์" ; -- src=panlex
lin broadcasting_N = mkN "การออกอากาศ" | mkN "การกระจายเสียง" | mkN "การแพร่ภาพ" | mkN "การออกอากาศ" | mkN "การกระจายเสียง" ; -- src=panlex
lin broaden_V = mkV "ขยาย" | mkV "ขยายสาขา" | mkV "กว้างขึ้น" | mkV "กว้างขวางขึ้น" | mkV "ขยาย" | mkV "ขยับขยาย" | mkV "ทําให้กว้าง" | mkV "เปิดหูเปิดตา" ; -- src=panlex
lin broaden_V2 = mkV2 "ขยาย" ; ---- | mkV "ขยายสาขา" | mkV "กว้างขึ้น" | mkV "กว้างขวางขึ้น" | mkV "ขยาย" | mkV "ขยับขยาย" | mkV "ทําให้กว้าง" | mkV "เปิดหูเปิดตา" ; -- src=panlex
lin broadening_N = mkN "การทำให้กว้าง" | mkN "การขยายให้กว้าง" ; -- src=panlex
lin broadleaf_A = mkA "ที่มีใบกว้าง" ; -- src=panlex
lin broadness_N = mkN "ความกว้าง" | mkN "ความกว้าง" ; -- src=panlex
lin broadsheet_N = mkN "ใบปลิว" | mkN "การโฆษณา" | mkN "แฮนด์บิล" | mkN "หนังสือพิมพ์ขนาดใหญ่" ; -- src=panlex
lin broadside_N = mkN "ใบปลิว" | mkN "การโฆษณา" | mkN "แฮนด์บิล" | mkN "กระสุนปืน" | mkN "การประณาม" | mkN "คำพูดโจมตี" | mkN "การยิงจากเรือ" | mkN "การยิงจากด้านข้างเรือรบ" | mkN "การกล่าวโจมตี" | mkN "ข้างเรือทั้งหมด" | mkN "การโจมตีหรือวิจารณ์อย่างรุนแรง" | mkN "ปืนเรือทั้งหมดของข้างหนึ่งของเรือ" ; -- src=panlex
lin broadsword_N = mkN "ดาบใหญ่และใบมีดแบนกว้าง" ; -- src=panlex
lin broadwise_Adv = mkAdv "ตามขวาง" ; -- src=panlex
lin brocade_N = mkN "ผ้าหนาและหนักทอจากเส้นไหมทองหรือเงิน" ; -- src=panlex
lin broccoli_N = mkN "บร็อคเคอลี่" | mkN "ต้นบร็อคโคลี่ซึ่งคล้ายกะหล่ําปลี" ; -- src=panlex
lin brochette_N = mkN "ไม้เสียบลูกชิ้น" | mkN "ไม้เสียบหมูปิ้ง" | mkN "ไม้เสียบปลาหรือเนื้อ" ; -- src=panlex
lin brochure_N = mkN "แผ่นพับ" | mkN "โบรชัวร์" | mkN "หนังสือเล่มเล็กๆ" | mkN "หนังสือเล่มเล็ก" | mkN "แผ่นพับสําหรับโฆษณา" | mkN "สมุดหรือหนังสือที่ให้ข้อมูลเกี่ยวกับสินค้า มีภาพประกอบ" ; -- src=panlex
lin brodiaea_N = mkN "พืชสกุลโบรดิเอีย" ; -- src=panlex
lin brogan_N = mkN "รองเท้าหนังหยาบ" ; -- src=panlex
lin brogue_N = mkN "รองเท้าหนังหยาบ" | mkN "กล" | mkN "อุบาย" | mkN "รองเท้าแบบหนึ่ง" | mkN "สําเนียงบ้านนอก" | mkN "สําเนียงท้องถิ่น" | mkN "สําเนียงพื้นบ้าน" | mkN "รองเท้าทํางานที่มีรูเจาะเป็นสิ่งประดับ" ; -- src=panlex
lin broil_N = mkN "การย่าง" ; -- src=panlex
lin broil_V = mkV "ร้อนตับแตก" | mkV "ร้อนตับแลบ" | mkV "ร้อนอบอ้าว" | mkV "ร้อนอย่างกับเตาอบ" | mkV "ปิ้ง" | mkV "ย่าง" | mkV "โกรธ" | mkV "อังไฟ" ; -- src=panlex
lin broil_V2 = mkV2 "ร้อนตับแตก" ; ---- | mkV "ร้อนตับแลบ" | mkV "ร้อนอบอ้าว" | mkV "ร้อนอย่างกับเตาอบ" | mkV "ปิ้ง" | mkV "ย่าง" | mkV "โกรธ" | mkV "อังไฟ" ; -- src=panlex
lin broiler_N = mkN "เตาอบ" | mkN "ไก่อ่อน" | mkN "เนื้อไก่สำหรับต้ม" | mkN "ที่ย่าง" | mkN "เครื่องอบ" | mkN "คนย่างเนื้อ" | mkN "เครื่องย่างหรือปิ้งหรือเผาเนื้อ" ; -- src=panlex
lin broken_A = mkA "หัก" | mkA "ซึ่งตกต่ำ" | mkA "ขาด" | mkA "แตก" | mkA "หยาบ" | mkA "เสีย" | mkA "วิกฤต" | mkA "ขรุขระ" | mkA "แตกหัก" | mkA "ไม่ครบ" | mkA "แตกสลาย" | mkA "ต่ําต้อย" | mkA "ไม่ติดต่อ" | mkA "ไม่ถูกต้อง" | mkA "ไม่สมบูรณ์" | mkA "ไม่สมบูรณ์แบบ" ; -- src=panlex
lin broken_hearted_A = mkA "ช้ำใจ" ; -- src=panlex
lin broker_N = mkN "นายหน้า" | mkN "เอเยนต์" | mkN "นายหน้า" | mkN "ตัวแทนซื้อขาย" | mkN "นายหน้าซื้อขาย" ; -- src=panlex
lin brokerage_N = mkN "ค่านายหน้า" | mkN "สำนักงานนายหน้า" | mkN "ค่านายหน้า" | mkN "เงินปากถุง" | mkN "ค่าธรรมเนียม" | mkN "กิจการนายหน้า" ; -- src=panlex
lin brolly_N = mkN "ร่ม" | mkN "ร่ม" ; -- src=panlex
lin brome_N = mkN "หญ้าโบรมแกรส" ; -- src=panlex
lin bromic_A = mkA "ประกอบด้วยโบรมีน" ; -- src=panlex
lin bromide_N = mkN "โบรไมด์" | mkN "คำพูดซ้ำซาก" | mkN "สำนวนประดาษ" | mkN "ยาที่ทําให้สงบ" | mkN "สารประกอบโบรมีน" | mkN "คนที่น่าเบื่อหน่าย" | mkN "คําที่พูดเรื่องซ้ํา ซาก" ; -- src=panlex
lin bromine_N = mkN "โบรมีน" | mkN "ธาตุโบรมีน" | mkN "เลขอะตอม 35" | mkN "ธาตุโบรมีน" ; -- src=panlex
lin bromoform_N = mkN "โบรโมฟอร์ม" ; -- src=panlex
lin bronchial_A = mkA "เกี่ยวกับหลอดลม" ; -- src=panlex
lin bronchiole_N = mkN "ท่อลมฝอย" | mkN "กิ่งก้านของหลอดลมใหญ่" ; -- src=panlex
lin bronchiolitis_N = mkN "หลอดลมฝอยอักเสบ" ; -- src=panlex
lin bronchitic_A = mkA "เกี่ยวกับหลอดลม" ; -- src=panlex
lin bronchitis_N = mkN "หลอดลมอักเสบ" | mkN "หลอดลมอักเสบ" | mkN "โรคหลอดลมอักเสบ" ; -- src=panlex
lin bronchodilator_N = mkN "ยาขยายหลอดลม" ; -- src=panlex
lin bronchopneumonia_N = mkN "ภาวะหลอดลมใหญ่และปอดอักเสบ" ; -- src=panlex
lin bronchoscope_N = mkN "บรอนโคสโคป" | mkN "เครื่องมือตรวจสอบหลอดลม" ; -- src=panlex
lin bronchus_N = mkN "ขั้วปอด" | mkN "หลอดลม" | mkN "หลอดลมใหญ่" ; -- src=panlex
lin bronco_N = mkN "ม้าป่า" | mkN "ม้าบรองโก" | mkN "ม้าป่า" | mkN "ชาวอังกฤษ" | mkN "ม้าป่าทางอเมริกาตะวันตก" ; -- src=panlex
lin bronze_A = mkA "บรอนซ์" | mkA "ที่เป็นทองสัมฤทธิ์" ; -- src=panlex
lin bronze_N = mkN "สัมฤทธิ์" | mkN "รูปหล่อสำริด" | mkN "ทองสัมฤทธ์" ; -- src=panlex
lin bronze_V = mkV "เป็นสีแทน" | mkV "ทำให้เป็นสีบรอนซ์" | mkV "ทําให้เป็นสีทองแดง" | mkV "ทําให้เป็นสีบรอนซ์" ; -- src=panlex
lin bronze_V2 = mkV2 "เป็นสีแทน" ; ---- | mkV "ทำให้เป็นสีบรอนซ์" | mkV "ทําให้เป็นสีทองแดง" | mkV "ทําให้เป็นสีบรอนซ์" ; -- src=panlex
lin brooch_N = mkN "เข็มกลัด" | mkN "เข็มกลัดผู้หญิง" | mkN "เข็มกลัด" ; -- src=panlex
lin brood_N = mkN "คลอก" | mkN "ลูก" | mkN "ลูกอ่อน" ; -- src=panlex
lin brood_V = mkV "กก" | mkV "งอน" | mkV "ฟัก" | mkV "กกไข่" | mkV "คุกคาม" | mkV "ฟักไข่" | mkV "คิดวิตก" | mkV "ครุ่นคิด" | mkV "เข้ามาคุกคาม" | mkV "กก" | mkV "ฟัก" | mkV "กกไข่" | mkV "กังวล" | mkV "ฟักไข่" | mkV "หน้างอ" | mkV "ครุ่นคิด" | mkV "ทําหน้าบึ้ง" ; -- src=panlex
lin brooding_N = mkN "การกก" | mkN "การฟัก" | mkN "การกกไข่" | mkN "การฟักไข่" ; -- src=panlex
lin brood_mare_N = mkN "ม้าตัวเมีย" | mkN "แม่พันธุ์ม้า" | mkN "ม้าตัวเมียสําหรับผสมพันธุ์" ; -- src=panlex
lin broody_A = mkA "รําพึง" | mkA "ครุ่นคิด" | mkA "มีอารมณ์" | mkA "ซึ่งต้องการที่จะมีลูกมากเกินไป" ; -- src=panlex
lin brook_N = mkN "ลำธาร" | mkN "ห้วย" | mkN "ลําธาร" | mkN "ลําห้วย" ; -- src=panlex
lin brooklet_N = mkN "ลําธารเล็ก" ; -- src=panlex
lin brooklime_N = mkN "ต้นบรูกไลม์" ; -- src=panlex
lin brookweed_N = mkN "ต้นบรูกวีด" ; -- src=panlex
lin broom_N = mkN "ไม้กวาด" | mkN "ต้นฮีเทอร์" | mkN "ต้นนกกระจอกทอง" | mkN "ไม้กวาด" | mkN "ข้าวฟ่าง" ; -- src=panlex
lin broomcorn_N = mkN "ข้าวฟ่างไม้กวาด" | mkN "ต้นที่มีใบยาว ใช้ทําไม้กวาด" ; -- src=panlex
lin broomstick_N = mkN "ด้ามไม้กวาด" | mkN "ด้ามไม้กวาด" | mkN "ไม้กวาดด้ามยาว" ; -- src=panlex
lin broomweed_N = mkN "ต้นบรูมวีด" ; -- src=panlex
lin broth_N = mkN "น้ำซุป" | mkN "น้ำสต็อก" | mkN "ซุป" | mkN "น้ําซุบ" | mkN "น้ําซุป" | mkN "น้ําแกง" | mkN "น้ําซุปเนื้อ" ; -- src=panlex
lin brothel_N = mkN "ซ่อง" | mkN "หอนางโลม" | mkN "โคมเขียว" | mkN "ซ่องโสเภณี" | mkN "ซ่อง" | mkN "โรงโสเภณี" ; -- src=panlex
lin brother_N = mkN "คู่หู" | mkN "พี่ชาย" | mkN "บั๊ดดี้" | mkN "เพื่อนคู่หู" | mkN "ภราดร" | mkN "พี่ชาย" | mkN "น้องชาย" | mkN "บาทหลวง" | mkN "เจษฎาจารย์" | mkN "เพื่อนร่วมงาน" | mkN "บุคคลร่วมอาชีพ" | mkN "พี่น้องร่วมชาติ" | mkN "พี่ชายหรือน้องชาย" ; -- src=panlex
lin brother_N2 = mkN2 (personN (thword "พี่" "ชาย")) poss ;
lin brotherhood_N = mkN "สหภาพ" | mkN "สหภาพแรงงาน" | mkN "ความเป็นพี่น้อง" | mkN "ความรู้สึกฉันพี่น้อง" | mkN "ภราดรภาพ" | mkN "พวกพ้องเดียวกัน" ; -- src=panlex
lin brotherly_A = mkA "ฉันพี่น้อง" | mkA "แบบพี่น้อง" | mkA "พี่น้อง" | mkA "เป็นพี่เป็นน้อง" | mkA "เหมือนพี่เหมือนน้องกัน" ; -- src=panlex
lin brotherly_Adv = mkAdv "พี่น้อง" | mkAdv "เหมือนพี่เหมือนน้องกัน" ; -- src=panlex
lin brotula_N = mkN "ปลาโบรทูลา" ; -- src=panlex
lin brougham_N = mkN "รถม้าบรูม" | mkN "รถม้า" | mkN "รถม้าสี่ล้อชนิดหนึ่ง" ; -- src=panlex
lin brouhaha_N = mkN "เสียงอึกทึก" ; -- src=panlex
lin brow_N = mkN "คิ้ว" | mkN "ขนคิ้ว" | mkN "พระขนง" | mkN "พระนลาฏ" | mkN "ยอดเนิน" | mkN "หน้าผาก" | mkN "คิ้ว" | mkN "ขนคิ้ว" | mkN "หน้าตา" | mkN "หน้าผา" | mkN "หน้าผาก" ; -- src=panlex
lin brown_A = mkA (thword "สี" "น้ำ" "ตาล") | {-pan-} mkA "น้ำตาล" | mkA "สีน้ำตาล" | mkA "สีน้ําตาล" ; -- src=panlex
lin brown_N = mkN "น้ำตาล" | mkN "สีน้ำตาล" | mkN "สีน้ําตาล" | mkN "มีผิวหนังผมขนเป็นสีน้ําตาล" | mkN "ม้าสีดําที่มีแต้มสีน้ําตาล" ; -- src=panlex
lin brown_V = mkV "ทอดจนเหลือง" | mkV "ทอดให้เหลือง" ; -- src=panlex
lin brown_V2 = mkV2 "ทอดจนเหลือง" ; ---- | mkV "ทอดให้เหลือง" ; -- src=panlex
lin brownie_N = mkN "เอลฟ์" | mkN "บราวนี" | mkN "เกรมลิน" | mkN "ตัวเอลฟ์" | mkN "เค้กบราวนี" | mkN "เค้กบราวนี่" | mkN "เจ้าพระภูมิ" | mkN "ขนมช็อกโกแลตเล็ก" ; -- src=panlex
lin brownish_A = mkA "น้ำตาล" | mkA "ที่เป็นสีน้ําตาล" ; -- src=panlex
lin brownstone_N = mkN "บ้านที่สร้างด้วยหินแดงน้ําตาล" ; -- src=panlex
lin browse_N = mkN "การป้อน" | mkN "การอ่าน" | mkN "การอ่านคร่าวๆ" | mkN "การป้อนทีละน้อย" | mkN "การเล็ม" | mkN "การและเล็ม" | mkN "การอ่านคร่าวๆ" ; -- src=panlex
lin browse_V = mkV "ชอปปิ้ง" | mkV "แทะเล็ม" | mkV "เล็ม" | mkV "ดูผ่านๆ" | mkV "และเล็ม" | mkV "มองไปรอบ ๆ" ; -- src=panlex
lin browser_N = mkN "เบราว์เซอร์" | mkN "โปรแกรมค้นดู" | mkN "เว็บเบราว์เซอร์" | mkN "โปรแกรมเบราเซอร์" | mkN "โปรแกรมที่ช่วยค้นหาหรืออ่านเอกสารบนอินเตอร์เนต" ; -- src=panlex
lin brucellosis_N = mkN "ไข้อันดูแลนต์" ; -- src=panlex
lin brucine_N = mkN "บรูซีน" ; -- src=panlex
lin bruin_N = mkN "หมีสีน้ำตาล" | mkN "หมี" ; -- src=panlex
lin bruise_N = mkN "รอยฟกช้ำ" | mkN "แผลฟกช้ำ" | mkN "บาดแผลฟกช้ำ" | mkN "รอยฟกช้ำดำเขียว" | mkN "ช้ำ" | mkN "รอยฟกช้ํา" | mkN "แผลฟกช้ํา" ; -- src=panlex
lin bruise_V = mkV "ทำให้เละ" | mkV "ทำให้ปวดใจ" | mkV "ทำให้เจ็บใจ" | mkV "ทำร้ายความรู้สึก" | mkV "ทำให้ฟกช้ำดำเขียว" | mkV "ทำให้เสียความรู้สึก" | mkV "ต่อย" | mkV "ทําให้เป็นรอยช้ํา" ; -- src=panlex
lin bruise_V2 = mkV2 "ทำให้เละ" ; ---- | mkV "ทำให้ปวดใจ" | mkV "ทำให้เจ็บใจ" | mkV "ทำร้ายความรู้สึก" | mkV "ทำให้ฟกช้ำดำเขียว" | mkV "ทำให้เสียความรู้สึก" | mkV "ต่อย" | mkV "ทําให้เป็นรอยช้ํา" ; -- src=panlex
lin bruiser_N = mkN "ยักษ์" | mkN "นักเลง" | mkN "ชายร่างใหญ่แข็งแรง" | mkN "คนที่ชอบตีรันฟันแทง" | mkN "คนที่แข็งแรงสูงใหญ่" ; -- src=panlex
lin brumal_A = mkA "ในฤดูหนาว" | mkA "เกี่ยวกับฤดูหนาว" ; -- src=panlex
lin brunch_N = mkN "อาหารเช้าและกลางวัน" | mkN "อาหารที่เป็นทั้งอาหารมื้อเช้าและกลางวันรวมกัน" ; -- src=panlex
lin brunet_A = mkA "คนที่ มีผมดําตาดําหรือผิวคล้ํา" ; -- src=panlex
lin brunet_N = mkN "ผู้หญิงผมสีน้ำตาล" | mkN "คนที่ มีผมดําตาดําหรือผิวคล้ํา" ; -- src=panlex
lin brunetteFem_N = variants {} ; ---- sense to be split
lin brunetteMasc_N = variants {} ; ---- sense to be split
lin brunt_N = mkN "ความหนัก" | mkN "ความรุนแรง" | mkN "ความหนักหน่วง" | mkN "ผลกระทบที่รุนแรง" | mkN "การโจมตีอย่างรุนแรง" | mkN "แรงกดดันที่หนักที่สุด" | mkN "ส่วนหนักที่สุดที่ได้รับหรือกระทบ" ; -- src=panlex
lin brush_N = mkN "แปรง" | mkN "หางพวง" | mkN "การปะทะ" | mkN "การสีฟัน" | mkN "การแปรงผม" | mkN "การแปรงฟัน" | mkN "ถ่านเก็บไฟ" | mkN "พุ่มไม้หนา" | mkN "การสัมผัสเบาๆ" | mkN "หมู่ไม้เตี้ยๆ" | mkN "การกระทบกระทั่ง" | mkN "แปรง" | mkN "ไม้พุ่ม" | mkN "การสัมผัสเบาๆ" | mkN "หมู่ไม้เตี้ยๆ" | mkN "ถ่านเก็บไฟในไดนาโมและมอเตอร์ไฟฟ้า" ; -- src=panlex
lin brush_V = mkV "ระ" | mkV "แปรง" | mkV "ทาด้วยแปรง" | mkV "ปัดด้วยแปรง" | mkV "ปัด" | mkV "กวาด" | mkV "แปรง" ; -- src=panlex
lin brush_V2 = mkV2 "ระ" ; ---- | mkV "แปรง" | mkV "ทาด้วยแปรง" | mkV "ปัดด้วยแปรง" | mkV "ปัด" | mkV "กวาด" | mkV "แปรง" ; -- src=panlex
lin brushlike_A = mkA "คล้ายแปรง" ; -- src=panlex
lin brushwood_N = mkN "กิ่งไม้" | mkN "พุ่มไม้หนา" | mkN "หมู่ไม้เตี้ยๆ" | mkN "ป่าละเมาะ" | mkN "พุ่มไม้หนา" | mkN "กิ่งไม้ที่ถูกตัดออก" | mkN "กิ่งไม้หักหรือตายแห้ง" ; -- src=panlex
lin brushwork_N = mkN "การใช้พู่กัน" | mkN "งานวาด" | mkN "งานกวาด" | mkN "งานทาสี" | mkN "งานใช้ฝีแปรงในการวาดภาพ" ; -- src=panlex
lin brusque_A = mkA "รับ" | mkA "หยาบ" | mkA "ห้วน" | mkA "ตึงตัง" | mkA "หุนหัน" | mkA "พูดน้อยคําและไม่สุภาพ" ; -- src=panlex
lin brusqueness_N = mkN "ความไม่มีมารยาท" ; -- src=panlex
lin brut_A = mkA "แห้งมาก" ; -- src=panlex
lin brutal_A = mkA "หยาบ" | mkA "ทารุณ" | mkA "รุนแรง" | mkA "หยาบคาย" | mkA "โหดร้าย" | mkA "โหดเหี้ยม" | mkA "ไร้เหตุผล" | mkA "คล้ายสัตว์" ; -- src=panlex
lin brutality_N = mkN "ความโหดเหี้ยม" | mkN "ความโหด" | mkN "ความทารุณ" | mkN "ความอํามหิต" | mkN "ความโหดร้าย" | mkN "ความเหี้ยมโหด" | mkN "การกระทําที่ทารุณ" | mkN "การกระทําที่โหดร้าย" ; -- src=panlex
lin brutalization_N = mkN "การกระทำอย่างป่าเถื่อน" ; -- src=panlex
lin brute_N = mkN "สัตว์" | mkN "สัตว์ป่า" | mkN "คนโหดร้าย" | mkN "เดียรัจฉาน" | mkN "สิ่งมีชีวิต" | mkN "สัตว์เดียรัจฉาน" | mkN "คนดุร้ายเหมือนสัตว์" | mkN "สัตว์ป่า" | mkN "สัตว์เดรัจฉาน" | mkN "มนุษย์ที่ดุร้ายเยี่ยงสัตว์ป่า" ; -- src=panlex
lin brutish_A = mkA "ทารุณ" | mkA "โหดร้าย" | mkA "ไร้เหตุผล" | mkA "คล้ายสัตว์" | mkA "เยี่ยงสัตว์เดรัจฉาน" ; -- src=panlex
lin bruxism_N = mkN "การนอนกัดฟัน" ; -- src=panlex
lin bryanthus_N = mkN "ต้นไบรแอนทัส" ; -- src=panlex
lin bryony_N = mkN "ต้นไบรโอนี" ; -- src=panlex
lin bryophyte_N = mkN "พืชไม่มีท่อลำเลียง" ; -- src=panlex
lin bryozoan_N = mkN "ไบรโอโซแอน" ; -- src=panlex
lin bubble_N = mkN "ฟองก๊าซ" | mkN "ฟองสบู่" | mkN "เรื่องเหลวไหล" | mkN "ฟอง" ; -- src=panlex
lin bubble_V = mkV "เรอ" | mkV "พึมพำ" | mkV "เกิดฟอง" | mkV "เรอ" | mkV "ผุดเป็นฟอง" | mkV "ทําให้เกิดฟอง" | mkV "ทําให้เป็นฟอง" ; -- src=panlex
lin bubbler_N = mkN "น้ำพุสำหรับดื่ม" | mkN "เครื่องพ่นแก๊สผ่านของเหลว" ; -- src=panlex
lin bubbly_A = mkA "เป็นฟอง" ; -- src=panlex
lin bubbly_N = mkN "แชมเปญ" | mkN "แชมเปน" ; -- src=panlex
lin buccal_A = mkA "ทางปาก" | mkA "เกี่ยวกับปาก" | mkA "เกี่ยวกับแก้ม" ; -- src=panlex
lin buccaneer_N = mkN "โจรสลัด" | mkN "โจรสลัด" ; -- src=panlex
lin buck_N = mkN "ม้ายาว" | mkN "ดอลลาร์" | mkN "ม้ากระโดด" | mkN "ม้าเลื่อย" | mkN "หนึ่งดอลล่าร์" | mkN "แบงค์หนึ่งดอลลาร์" | mkN "ธนบัตรหนึ่งดอลลาร์" | mkN "สัตว์เลี้ยงลูกด้วยนมตัวผู้" | mkN "สัตว์เลี้ยงลูกด้วยนมเพศผู้" | mkN "ชาย" | mkN "แกะ" | mkN "แพะ" | mkN "กรอบ" | mkN "โครง" | mkN "เหรียญ" | mkN "กระต่าย" | mkN "เจ้าชู้" | mkN "ชายหนุ่ม" | mkN "นิโกรชาย" | mkN "ม้าตัวผู้" | mkN "หนังสัตว์" | mkN "เพื่อนยาก" | mkN "แกะตัวผู้" | mkN "แพะตัวผู้" | mkN "กวางตัวผู้" | mkN "จําพวกกวาง" | mkN "มั่งตัวผู้" | mkN "สัตว์ตัวผู้" | mkN "อย่างสมบูรณ์" | mkN "กระต่ายตัวผู้" | mkN "อินเดียแดงชาย" | mkN "ผู้ชายรุ่นหนุ่ม" | mkN "ผ้าที่ซักในน้ํายาเคมี" | mkN "สิ่งที่ทําจากหนังสัตว์" | mkN "น้ํายาเคมีที่ใช้ในการซักผ้า" | mkN "โครงที่ใช้สําหรับยึดไม้ที่เลื่อย" ; -- src=panlex
lin buck_V = mkV "ต่อต้าน" | mkV "กระโดดสี่ขา" | mkV "พนัน" | mkV "เลื่อย" | mkV "ต่อต้าน" | mkV "ฝ่าเข้าไป" | mkV "สู้โดยใช้หัวชน" | mkV "ซักในน้ํายาเคมี" ; -- src=panlex
lin buck_V2 = mkV2 "ต่อต้าน" ; ---- | mkV "กระโดดสี่ขา" | mkV "พนัน" | mkV "เลื่อย" | mkV "ต่อต้าน" | mkV "ฝ่าเข้าไป" | mkV "สู้โดยใช้หัวชน" | mkV "ซักในน้ํายาเคมี" ; -- src=panlex
lin buckboard_N = mkN "รถม้าบักบอร์ด" ; -- src=panlex
lin bucket_N = mkN "ถัง" | mkN "ถังเล็ก" | mkN "ถัง" | mkN "ปี๊บ" | mkN "ถังน้ํา" | mkN "ในกังหัน" | mkN "ใบเครื่องจักร" ; -- src=panlex
lin bucket_V = mkV "ใส่ถัง" | mkV "หิ้วถัง" | mkV "ใส่ถัง" ; -- src=panlex
lin bucketful_N = mkN "ถังเล็ก" ; -- src=panlex
lin buckeye_N = mkN "ต้นบัคอาย" | mkN "ต้นฮอร์สเชสนัท" ; -- src=panlex
lin buckle_N = mkN "การบิดงอ" | mkN "ที่รัดสาย" | mkN "ที่รัดเข็มขัด" | mkN "งอ" | mkN "ยอม" | mkN "โค้ง" | mkN "รัดแน่น" | mkN "ยอมจํานน" | mkN "ติดกระดุม" | mkN "หัวเข็มขัด" ; -- src=panlex
lin buckle_V = mkV "งอ" | mkV "รัดเข็มขัด" | mkV "ยอม" | mkV "พังทลาย" | mkV "รัดเข็มขัด" | mkV "ทําให้โค้งงอ" | mkV "ทําให้โค้งหรืองอ" | mkV "ทําให้แน่นด้วยวัสดุคล้ายหัวเข็มขัด" ; -- src=panlex
lin buckle_V2 = mkV2 "งอ" ; ---- | mkV "รัดเข็มขัด" | mkV "ยอม" | mkV "พังทลาย" | mkV "รัดเข็มขัด" | mkV "ทําให้โค้งงอ" | mkV "ทําให้โค้งหรืองอ" | mkV "ทําให้แน่นด้วยวัสดุคล้ายหัวเข็มขัด" ; -- src=panlex
lin buckler_N = mkN "โล่" | mkN "โล่กลม" ; -- src=panlex
lin buckminsterfullerene_N = mkN "บัคกี้บอล" | mkN "บัคมินสเตอร์ฟูลเลอรีน" ; -- src=panlex
lin buckram_N = mkN "หลอก" | mkN "ผ้าเนื้อหยาบทําจากฝ้ายหรือลินิน" ; -- src=panlex
lin bucksaw_N = mkN "เลื่อย" | mkN "เลื่อยสองมือสําหรับตัดไม้" ; -- src=panlex
lin buckshot_N = mkN "ลูกตะกั่วที่ยิงจากปืนสั้น" | mkN "กระสุนหัวตะกั่วขนาดใหญ่สําหรับล่าสัตว์" ; -- src=panlex
lin buckskin_N = mkN "ทําด้วยหนังสัตว์" | mkN "หนังนิ่มทําด้วยหนังกวางหรือแพะ" ; -- src=panlex
lin buckthorn_N = mkN "ริบเวอร์ต" | mkN "ต้นบัคทอร์น" ; -- src=panlex
lin bucktooth_N = mkN "ฟันยื่น" ; -- src=panlex
lin buckwheat_N = mkN "ต้นบักวีต" | mkN "เมล็ดพืชขนาดเล็กสีเข้ม" | mkN "พืชจําพวกหนึ่ง ให้เมล็ดรูป 3 เหลี่ยม" ; -- src=panlex
lin bucolic_A = mkA "ที่เป็นชีวิตในชนบท" | mkA "บ้านนอก" | mkA "เกี่ยวกับคนเลี้ยงแกะ" ; -- src=panlex
lin bud_N = mkN "ดอกตูม" | mkN "พี่ชาย" | mkN "ต้นอ่อน" | mkN "เพื่อนยาก" | mkN "เป็นหนุ่มเป็นสาว" | mkN "แตกเนื้อหนุ่มสาว" ; -- src=panlex
lin bud_V = mkV "เติบโต" | mkV "แตกยอด" | mkV "แตกตา" | mkV "แตกยอด" | mkV "ตอนหน่อ" | mkV "แตกหน่อ" | mkV "ทําให้แตกหน่อ" ; -- src=panlex
lin buddhism_N = mkN "ศาสนาพุทธ" ; -- src=panlex
lin buddhistFem_N = variants {} ; ---- sense to be split
lin buddhistMasc_N = variants {} ; ---- sense to be split
lin budding_N = mkN "การแตกตัว" | mkN "แตกใบ" | mkN "เริ่มผลิ" | mkN "การผลิดอก" ; -- src=panlex
lin buddy_N = mkN "คู่หู" | mkN "บั๊ดดี้" | mkN "เพื่อนคู่หู" | mkN "สหาย" | mkN "คู่ขา" | mkN "เพื่อน" | mkN "เพื่อนรัก" | mkN "เพื่อนคู่หู" ; -- src=panlex
lin budge_V = mkV "เขยิบ" | mkV "กระเถิบ" | mkV "ถด" | mkV "เขยิบ" | mkV "ขยับตัว" | mkV "เคลื่อน" | mkV "ขยับเขยื้อน" ; -- src=panlex
lin budge_V2 = mkV2 "เขยิบ" ; ---- | mkV "กระเถิบ" | mkV "ถด" | mkV "เขยิบ" | mkV "ขยับตัว" | mkV "เคลื่อน" | mkV "ขยับเขยื้อน" ; -- src=panlex
lin budgerigar_N = mkN "นกหงส์หยก" | mkN "นกขนาดเล็กตระกูลเดียวกับนกแก้ว" ; -- src=panlex
lin budget_N = mkN "งบประมาณ" | mkN "ทุน" | mkN "เงิน" | mkN "กองทุน" | mkN "เงินตรา" | mkN "งบประมาณ" | mkN "เงินสะสม" ; -- src=panlex
lin budget_V = mkV "ทำงบประมาณ" ; -- src=panlex
lin budget_V2 = mkV2 "ทำงบประมาณ" ; ---- ; -- src=panlex
lin budgetary_A = mkA "เกี่ยวกับงบประมาณ" ; -- src=panlex
lin budgie_N = mkN "นกหงส์หยก" | mkN "นกขนาดเล็กตระกูลเดียวกับนกแก้ว" ; -- src=panlex
lin buff_A = mkA "ที่ทําจากหนังควาย" | mkA "ที่มีสีน้ําตาลอมเหลือง" ; -- src=panlex
lin buff_N = mkN "แฟน" | mkN "สาวก" | mkN "แปรงขัด" | mkN "ผู้นับถือ" | mkN "หนังวัวอ่อน" | mkN "สีน้ำตาลอ่อน" | mkN "การเปลื่อยกาย" | mkN "สีน้ำตาลคาราเมล" | mkN "สีน้ำตาลอมเหลือง" | mkN "สีแทน" | mkN "สีน้ําตาลอมเหลือง" | mkN "หนังที่ไม่ได้ย้อม มีลักษณะหนานุ่ม มักจะทําจากหนังควาย" | mkN "คนที่รู้หรือสนใจเรื่องใดเป็นพิเศษ" | mkN "เกราะที่ป้องกันใบหน้าส่วนล่างและลําคอ" ; -- src=panlex
lin buffalo_N = mkN "ควาย" | mkN "เนื้อควาย" | mkN "อเมริกันไบสัน" | mkN "ทุย" | mkN "กาสร" | mkN "ควาย" | mkN "กระบือ" ; -- src=panlex
lin buffalofish_N = mkN "ปลาบัฟฟาโลฟิช" | mkN "เนื้อปลาบัฟฟาโลฟิช" ; -- src=panlex
lin buffer_N = mkN "กันชน" | mkN "แปรงขัด" | mkN "บัฟเฟอร์" | mkN "เขตกันชน" | mkN "ที่พักข้อมูล" | mkN "เครื่องขัดเงา" | mkN "หน่วยเก็บที่พัก" | mkN "สารละลายบัฟเฟอร์" | mkN "เครื่องกันกระแทก" | mkN "เครื่องขัดเงา" | mkN "เครื่องรับแรงปะทะ" | mkN "เครื่องรับน้ําหนักกระแทก" | mkN "สารผ่อนความเป็นกรดหรือความเป็นด่าง" | mkN "แป้นปะทะที่หัวท้ายรถพ่วงในขบวนรถไฟ" ; -- src=panlex
lin buffet_N = mkN "บุฟเฟต์" | mkN "เคาน์เตอร์" | mkN "อาหารบุฟเฟต์" | mkN "โต๊ะวางอาหาร" | mkN "ร้านของกินเล่น" | mkN "ร้านขายอาหารว่าง" | mkN "อาหารที่ลูกค้าต้องบริการตัวเอง" ; -- src=panlex
lin buffet_V = mkV "ตี" ; -- src=panlex
lin buffet_V2 = mkV2 "ตี" ; ---- ; -- src=panlex
lin bufflehead_N = mkN "เป็ดบัฟเฟิลเฮด" ; -- src=panlex
lin buffoon_N = mkN "จำอวด" | mkN "ตัวตลก" | mkN "ความตลกลามก" | mkN "ตัวตลกหยาบคาย" | mkN "ตัวตลก" | mkN "คนเล่นตลกหยาบๆ" | mkN "ตัวตลกโปกฮาอย่างหยาบ" ; -- src=panlex
lin buffoonery_N = mkN "การแสดงจำอวด" ; -- src=panlex
lin bug_N = mkN "แมลง" | mkN "การรวน" | mkN "ความติดขัด" | mkN "จุลินทรีย์" | mkN "เครื่องดักฟัง" | mkN "ไมโครโฟนดักฟัง" | mkN "เชื้อจุลินทรีย์" | mkN "แมลง" | mkN "เชื้อโรค" | mkN "ข้อผิดพลาด" | mkN "ความบกพร่อง" | mkN "จุดด่างพร้อย" | mkN "เชื้อจุลินทรีย์" | mkN "สัตว์ที่คล้ายแมลง" | mkN "คนที่คลั่งไคล้ในสิ่งใดสิ่งหนึ่งมากๆ" | mkN "คนที่หมกหมุ่นเอาใจจดจ่อสิ่งใดสิ่งหนึ่ง" ; -- src=panlex
lin bugaboo_N = mkN "โบกี้แมน" ; -- src=panlex
lin bugbane_N = mkN "ต้นบักเบน" | mkN "ต้นอเมริกัีนเฮลเลอบอร์" ; -- src=panlex
lin bugbear_N = mkN "โบกี้แมน" | mkN "แหล่งความกลัว" | mkN "ผีที่กินเด็กซุกซน" | mkN "สิ่งที่ทําให้รําคาญและกังวล" ; -- src=panlex
lin bugger_N = mkN "หนู" | mkN "อ้ายหนู" | mkN "อ้ายหนุ่ม" | mkN "ผู้ร่วมเพศกับสัตว์" | mkN "ผู้กระทําการสังวาสทางทวารหนัก" | mkN "คําเรียกแบบดูถูกและแสดงถึงอารมณ์โกรธ" ; -- src=panlex
lin bugger_V = mkV "ตุ๋ย" | mkV "อัดตูด" | mkV "อัดถั่วดำ" | mkV "ร่วมเพศทางทวารหนัก" | mkV "ร่วมเพศทางเว็จมรรค" ; -- src=panlex
lin bugger_V2 = mkV2 "ตุ๋ย" ; ---- | mkV "อัดตูด" | mkV "อัดถั่วดำ" | mkV "ร่วมเพศทางทวารหนัก" | mkV "ร่วมเพศทางเว็จมรรค" ; -- src=panlex
lin buggery_N = mkN "การสมสู่วัจมรรค" | mkN "การเอาประตูหลัง" | mkN "การร่วมเพศทางทวารหนัก" | mkN "การ่วมเพศกับสัตว์" | mkN "การร่วมเพศทางทวารหนัก" ; -- src=panlex
lin buggy_A = mkA "ที่ถูกรบกวนด้วยแมลง" ; -- src=panlex
lin buggy_N = mkN "รถม้าบักกี" | mkN "พิกล" | mkN "บ้าคลั่ง" | mkN "รถเล็กไม่มีหลังคาและประตู" ; -- src=panlex
lin bugle_N = mkN "บูเกิล" | mkN "แตรเดี่ยว" | mkN "แตรสัญญาณทหาร" ; -- src=panlex
lin bugler_N = mkN "นักเป่าแตรเดี่ยว" ; -- src=panlex
lin bugloss_N = mkN "ต้นลิ้นวัว" ; -- src=panlex
lin buhl_N = mkN "เครื่องเลื่อยตกแต่ง" ; -- src=panlex
lin build_N = mkN "กาย" | mkN "สังขาร" | mkN "รูปร่าง" | mkN "ร่างกาย" | mkN "พระวรกาย" | mkN "ร่างกายมนุษย์" | mkN "ร่างกายของมนุษย์" | mkN "โครงสร้างร่างกาย" ; -- src=panlex
lin build_V = mkV "สะสม" | mkV "สร้าง" | mkV "เสริม" | mkV "ก่อสร้าง" | mkV "ก่อ" | mkV "รัง" | mkV "ตั้ง" | mkV "ปลูก" | mkV "สร้าง" | mkV "สถาปนา" ; -- src=panlex
lin build_V2 = mkV2 "สะสม" ; ---- | mkV "สร้าง" | mkV "เสริม" | mkV "ก่อสร้าง" | mkV "ก่อ" | mkV "รัง" | mkV "ตั้ง" | mkV "ปลูก" | mkV "สร้าง" | mkV "สถาปนา" ; -- src=panlex
lin build_up_V2 = prepV2 OP_build_V OP_up_Prep ; -- guess-p-verb
lin builder_N = mkN "ผงซักฟอก" | mkN "ผู้สร้าง" | mkN "ผู้ก่อตั้ง" | mkN "ผู้รับเหมา" | mkN "บริษัทรับเหมา" | mkN "บริษัทก่อสร้าง" | mkN "ผู้รับเหมาก่อสร้าง" | mkN "บริษัทรับเหมาก่อสร้าง" | mkN "คนก่อสร้าง" | mkN "ผู้รับเหมา" | mkN "ช่างก่อสร้าง" ; -- src=panlex
lin building_N = mkN "ตึก" | mkN "อาคาร" | mkN "การสร้าง" | mkN "การก่อสร้าง" | mkN "สิ่งปลูกสร้าง" | mkN "ธุรกิจรับเหมาก่อสร้าง" | mkN "กลุ่มผู้อยู่อาศัยในอาคาร" | mkN "กลุ่มผู้อยู่อาศัยในตึกที่พัก" | mkN "ตึก" | mkN "โรง" | mkN "อาคาร" | mkN "เรือน" | mkN "สํานักงาน" | mkN "การก่อสร้าง" | mkN "สิ่งก่อสร้าง" | mkN "สิ่งปลูกสร้าง" | mkN "ธุรกิจก่อสร้าง" | mkN "การก่อสร้างอาคาร" ; -- src=panlex
lin build_up_N = mkN "การเสริมกำลัง" | mkN "การฝึกฝน" | mkN "การพัฒนา" | mkN "การรวมพล" | mkN "การเตรียมการ" | mkN "การเสริมกําลัง" | mkN "กระบวนการเจริญเติบโต" | mkN "การสร้างเสียงสนับสนุน" ; -- src=panlex
lin bulb_N = mkN "หลอดไฟ" | mkN "กระเปาะ" | mkN "ส่วนป่อง" | mkN "หลอดไฟฟ้า" | mkN "สมองส่วนต้น" | mkN "รูปทรงหยดน้ำ" | mkN "สมองส่วนเมดูลลา" | mkN "หัว" | mkN "ก้อน" | mkN "เหง้า" | mkN "หลอดไฟฟ้า" | mkN "หัวใต้ดิน" ; -- src=panlex
lin bulbed_A = mkA "ที่มีหลอดไฟ" ; -- src=panlex
lin bulbil_N = mkN "หน่อย่อย" | mkN "หัว น้อย ๆ" | mkN "ส่วนหัวที่แกนใบ" ; -- src=panlex
lin bulblike_A = mkA "ซึ่งเป็นรูปหยดน้ำ" | mkA "ซึ่งเป็นรูปหลอดไฟ" ; -- src=panlex
lin bulbous_A = mkA "ซึ่งเป็นรูปหยดน้ำ" | mkA "ซึ่งเป็นรูปหลอดไฟ" | mkA "เป็นรูปกระเปาะ" | mkA "ซึ่งมีรูปร่างเป็นกระเปาะกลม" ; -- src=panlex
lin bulbul_N = mkN "นกบุลบุล" ; -- src=panlex
lin bulgarianFem_N = variants {} ;
lin bulgarianMasc_N = variants {} ;
lin bulgarian_A = mkA (thword "บัล" "แก" "เรียน") ;
lin bulge_N = mkN "รอยนูน" | mkN "ส่วนนูน" | mkN "ส่วนที่นูน" | mkN "ส่วนที่พอง" | mkN "ส่วนที่โปน" ; -- src=panlex
lin bulge_V = mkV "นูน" | mkV "ถลึง" | mkV "บวมปูด" | mkV "พุงกาง" | mkV "ทำให้นูน" | mkV "ตุง" | mkV "ถลน" | mkV "นูน" | mkV "ปูน" | mkV "พอง" | mkV "โปง" | mkV "โปน" ; -- src=panlex
lin bulge_V2 = mkV2 "นูน" ; ---- | mkV "ถลึง" | mkV "บวมปูด" | mkV "พุงกาง" | mkV "ทำให้นูน" | mkV "ตุง" | mkV "ถลน" | mkV "นูน" | mkV "ปูน" | mkV "พอง" | mkV "โปง" | mkV "โปน" ; -- src=panlex
lin bulimia_N = mkN "โรคหิว" | mkN "ความอยากอาหารมากผิดปกติ" | mkN "โรคผิดปกติทางอารมณ์ทําให้กินมากเกินไปแล้วอาเจียนออก" ; -- src=panlex
lin bulimic_N = mkN "ผู้ป่วยโรคบูลิเมีย" ; -- src=panlex
lin bulk_N = mkN "ความจุ" | mkN "ขนาดใหญ่" | mkN "ความใหญ่" | mkN "ส่วนใหญ่" | mkN "กอง" | mkN "ความจุ" | mkN "ความหนา" | mkN "ทั้งก้อน" | mkN "เพิ่มขึ้น" | mkN "ส่วนสําคัญ" | mkN "ขนาดสามมิติ" | mkN "ส่วนที่ใหญ่กว่าหรือมากกว่า" | mkN "อาหารที่จะเป็นกากอาหารส่วนใหญ่" ; -- src=panlex
lin bulk_V = mkV "ทำให้นูน" ; -- src=panlex
lin bulkhead_N = mkN "ผนังกั้น" | mkN "ฝากั้น" | mkN "ส่วนกั้น" | mkN "กําแพงกั้น" | mkN "ผนังที่แบ่งเรือ/เครื่องบินออกเป็นส่วนๆ" ; -- src=panlex
lin bulkiness_N = mkN "ความเทอะทะ" | mkN "ความอุ้ยอ้าย" ; -- src=panlex
lin bulky_A = mkA "เทอะทะ" | mkA "ค่อนข้างใหญ่โต" | mkA "ค่อนข้างใหญ่และเทอะทะ" ; -- src=panlex
lin bull_N = mkN "คำด่า" | mkN "ตำรวจ" | mkN "ยักษ์" | mkN "คำหยาบ" | mkN "นักเลง" | mkN "พ่อวัว" | mkN "วัวตัวผู้" | mkN "วัวเพศผู้" | mkN "ใจกลางเป้า" | mkN "ไอ้หัวปิงปอง" | mkN "สาส์นจากพระสันตะปาปา" | mkN "โค" | mkN "วัว" | mkN "วัวตัวผู้" | mkN "สัตว์ตัวผู้" | mkN "คนที่รูปร่างบึกบึน" ; -- src=panlex
lin bulla_N = mkN "ตุ่มพอง" ; -- src=panlex
lin bullbrier_N = mkN "ต้นกรีนไบรเออร์" ; -- src=panlex
lin bulldozer_N = mkN "รถไถ" | mkN "รถปราบหน้าดิน" | mkN "รถแทรกเตอร์เกลี่ยดิน" ; -- src=panlex
lin bullet_N = mkN "กระสุน" | mkN "ลูกปืน" | mkN "ลูกกระสุน" | mkN "ลูกตะกั่ว" | mkN "การขว้างบอลเร็ว" | mkN "รถไฟความเร็วสูง" | mkN "รถไฟฟ้าความเร็วสูง" | mkN "ลูกปืน" | mkN "กระสุนปืน" | mkN "ลูกกระสุน" | mkN "ลูกกระสุนปืน" ; -- src=panlex
lin bullethead_N = mkN "หัวกระสุน" | mkN "คนโง่" | mkN "คนรั้น" | mkN "คนหัวดื้อ" ; -- src=panlex
lin bulletin_N = mkN "แถลงการณ์" | mkN "ประกาศ" | mkN "แถลงการณ์" | mkN "รายงานข่าว" | mkN "สิ่งตีพิมพ์ที่ออกมาเป็นระยะ" ; -- src=panlex
lin bulletproof_A = mkA "กันกระสุน" | mkA "กันกระสุน" | mkA "ป้องกันกระสุน" | mkA "ลูกกระสุนยิงไม่เข้า" ; -- src=panlex
lin bullfight_N = mkN "กีฬาสู้วัวในสเปน" | mkN "กีฬาการต่อสู้กับวัวในสเปน" ; -- src=panlex
lin bullfighter_N = mkN "นักสู้วัว" | mkN "นักสู้วัวกระทิง" | mkN "นักสู้วัว" ; -- src=panlex
lin bullfighting_N = mkN "การสู้วัว" | mkN "กีฬาสู้วัว" | mkN "การสู้วัว" ; -- src=panlex
lin bullfinch_N = mkN "นกบุลฟินช์" ; -- src=panlex
lin bullfrog_N = mkN "กบขนาดใหญ่" | mkN "กบอเมริกันตัวใหญ่" ; -- src=panlex
lin bullhead_N = mkN "ปลาบูลเฮด" ; -- src=panlex
lin bull_headed_A = mkA "รั้น" | mkA "หัวดื้อ" ; -- src=panlex
lin bullhorn_N = mkN "โทรโข่ง" | mkN "สปีกเกอร์" | mkN "เครื่องกระจายเสียง" ; -- src=panlex
lin bullion_N = mkN "ทองแท่ง" | mkN "โลหะล้ำค่า" | mkN "ทองแท่ง" | mkN "เงินแท่ง" | mkN "ขอบลายทองหรือลายเงิน" | mkN "แท่งเงินหรือทองจํานวนมาก" ; -- src=panlex
lin bullish_A = mkA "โง่" | mkA "คล้ายวัว" | mkA "ดื้อรั้น" | mkA "มั่นใจและมีความหวังในอนาคต" ; -- src=panlex
lin bullock_N = mkN "วัวหนุ่ม" | mkN "วัวตัวผู้ที่ถูกตอน" | mkN "กลาง" | mkN "วัวตอน" | mkN "วัวหนุ่ม" ; -- src=panlex
lin bullpen_N = mkN "ห้องขังชั่วคราว" ; -- src=panlex
lin bullring_N = mkN "สนามสู้วัวกระทิง" | mkN "สนามกีฬาชนวัว" ; -- src=panlex
lin bullshit_N = mkN "คำด่า" | mkN "คำหยาบ" | mkN "ความไร้สาระ" ; -- src=panlex
lin bullshit_V = mkV "พูดโง่ๆ" | mkV "ไม่จริงหรือโง่เง่ามาก" ; -- src=panlex
lin bullshot_N = mkN "บูลชอต" ; -- src=panlex
lin bull_terrier_N = mkN "สุนัขพันธุ์บูล เทอร์เรีย" | mkN "สุนัขพันธุ์บูลเทอร์เรีย" ; -- src=panlex
lin bully_A = mkA "ดีมาก" | mkA "ดีเลิศ" ; -- src=panlex
lin bully_N = mkN "อันธพาล" | mkN "ฮูลิแกน" | mkN "อันธพาลรับจ้าง" | mkN "อันธพาล" ; -- src=panlex
lin bully_V = mkV "บงการ" | mkV "ข่มขู่" | mkV "บังคับ" | mkV "ขู่ให้กลัว" | mkV "พาล" | mkV "กดขี่" | mkV "ระราน" | mkV "รังแก" | mkV "วิวาท" | mkV "ข่มเหง" | mkV "หาเรื่อง" | mkV "กลั่นแกล้ง" ; -- src=panlex
lin bully_V2 = mkV2 "บงการ" ; ---- | mkV "ข่มขู่" | mkV "บังคับ" | mkV "ขู่ให้กลัว" | mkV "พาล" | mkV "กดขี่" | mkV "ระราน" | mkV "รังแก" | mkV "วิวาท" | mkV "ข่มเหง" | mkV "หาเรื่อง" | mkV "กลั่นแกล้ง" ; -- src=panlex
lin bulrush_N = mkN "ต้นรัชธรรมดา" ; -- src=panlex
lin bulwark_N = mkN "พนัง" | mkN "กำแพง" | mkN "ป้อมปราการ" | mkN "เขื่อนกันคลื่น" | mkN "เขื่อนกั้นทะเล" | mkN "ป้อมปราการ" | mkN "กําแพงต้านศัตรู" ; -- src=panlex
lin bum_A = mkA "ห่วย" | mkA "ห่วยแตก" | mkA "ซังกะบ๊วย" | mkA "ไม่มีคุณค่า" | mkA "ไร้ประโยชน์" ; -- src=panlex
lin bum_N = mkN "ก้น" | mkN "ตูด" | mkN "คนโง่" | mkN "คนจรจัด" | mkN "คนไร้ค่า" | mkN "บั้นท้าย" | mkN "คนขี้เกียจ" | mkN "คนไม่เอาไหน" | mkN "คนเกียจคร้าน" | mkN "คนน่ารังเกียจ" | mkN "คนไม่ชอบทำงาน" | mkN "คนไม่ทำงานทำการ" | mkN "ก้น" | mkN "สะโพก" | mkN "คนพเนจร" | mkN "พวกขอทาน" | mkN "คนเกียจคร้าน" ; -- src=panlex
lin bum_V = mkV "ขอ" | mkV "เกาะ" | mkV "เกียจคร้าน" ; -- src=panlex
lin bum_V2 = mkV2 "ขอ" ; ---- | mkV "เกาะ" | mkV "เกียจคร้าน" ; -- src=panlex
lin bumblebee_N = mkN "แมลงภู่" | mkN "ผึ้ง ใหญ่ชนิดหนึ่ง" | mkN "ผึ้งมีขนตัวใหญ่ที่ส่งเสียงหึ่งๆ" ; -- src=panlex
lin bumbling_A = mkA "ซึ่งไม่ถนัดใช้มือ" | mkA "ซึ่งทําผิดพลาด" ; -- src=panlex
lin bumboat_N = mkN "เรือบัมโบท" | mkN "เรือบั๊มโบ๊ท" ; -- src=panlex
lin bumf_N = mkN "ข้อเขียน" | mkN "ข้อมเขียน" | mkN "กระดาษร่าง" | mkN "หนังสือราชการ" ; -- src=panlex
lin bummer_N = mkN "สถานการณ์ที่น่าผิดหวังหรือไม่พอใจ" ; -- src=panlex
lin bump_N = mkN "การปูด" | mkN "รอยนูน" | mkN "ส่วนนูน" | mkN "การกระทบ" | mkN "การกระแทก" ; -- src=panlex
lin bump_V = mkV "พบ" | mkV "บั๊มพ์" | mkV "ลดขั้น" | mkV "ชนอย่างแรง" | mkV "เต้นบั๊มพ์" | mkV "เอาออกจากที่เดิม" | mkV "ชน" | mkV "กระทบ" | mkV "กระแทก" ; -- src=panlex
lin bump_V2 = mkV2 "พบ" ; ---- | mkV "บั๊มพ์" | mkV "ลดขั้น" | mkV "ชนอย่างแรง" | mkV "เต้นบั๊มพ์" | mkV "เอาออกจากที่เดิม" | mkV "ชน" | mkV "กระทบ" | mkV "กระแทก" ; -- src=panlex
lin bumper_N = mkN "กันชน" | mkN "กันชนรถ" | mkN "แก้วที่มีเครื่องดื่มเต็ม" | mkN "กันชน" | mkN "เครื่องกันชน" ; -- src=panlex
lin bumpkin_N = mkN "คนบ้านนอก" | mkN "คนบ้านนอก" | mkN "คนเซ่อซ่า" ; -- src=panlex
lin bumptious_A = mkA "อวดดี" | mkA "ทะลึ่ง" | mkA "หยิ่งโอหัง" | mkA "ซึ่งคิดว่าตนเองสําคัญมาก" ; -- src=panlex
lin bumptiousness_N = mkN "ความโอหัง" | mkN "ความเย่อหยิ่งถือดี" ; -- src=panlex
lin bumpy_A = mkA "ขรุขระ" | mkA "ขรุขระ" | mkA "ไม่แน่นอน" | mkA "เปลี่ยนแปลง" | mkA "เป็นหลุมเป็นบ่อ" ; -- src=panlex
lin bun_N = mkN "โรล" | mkN "มวยผม" | mkN "กระรอก" | mkN "กระต่าย" | mkN "อาการเมา" | mkN "หางของกระต่าย" | mkN "ขนมปังนุ่มรสหวาน" | mkN "ขนมปังนุ่มและค่อนข้างหวาน" ; -- src=panlex
lin buna_N = mkN "ยางเทียม" ; -- src=panlex
lin bunch_N = mkN "พวง" | mkN "แก๊ง" | mkN "กลุ่ม" | mkN "เพื่อนฝูง" | mkN "ดง" | mkN "พวก" | mkN "พวง" | mkN "รวง" | mkN "กลุ่ม" | mkN "เครือ" | mkN "หมู่คน" ; -- src=panlex
lin bunch_V = mkV "มัด" | mkV "จับกลุ่ม" | mkV "มัด" | mkV "จับกันเป็นก้อน" | mkV "รวมกันเป็นกลุ่ม" ; -- src=panlex
lin bunch_V2 = mkV2 "มัด" ; ---- | mkV "จับกลุ่ม" | mkV "มัด" | mkV "จับกันเป็นก้อน" | mkV "รวมกันเป็นกลุ่ม" ; -- src=panlex
lin bunchberry_N = mkN "ต้นบันช์เบอร์รี่" ; -- src=panlex
lin bunchy_A = mkA "ช่อ" | mkA "เครือ" | mkA "เป็นพวง" | mkA "เป็นช่อ ๆ" | mkA "เป็นกลุ่ม" | mkA "ซึ่งยื่นออกมา" ; -- src=panlex
lin bunco_N = mkN "การโกง" | mkN "การฉ้อโกง" ; -- src=panlex
lin bundle_N = mkN "ห่อ" | mkN "หีบห่อ" | mkN "เงินก้อน" | mkN "มัด" | mkN "ห่อ" | mkN "มัดหรือห่อ" ; -- src=panlex
lin bundle_V = mkV "มัด" | mkV "อัดให้เป็นก้อน" ; -- src=panlex
lin bundle_V2 = mkV2 "มัด" ; ---- | mkV "อัดให้เป็นก้อน" ; -- src=panlex
lin bung_N = mkN "จุก" | mkN "จุกหรือที่อุด" ; -- src=panlex
lin bungalow_N = mkN "กระท่อม" | mkN "บังกะโล" | mkN "บังกะโล" | mkN "บ้านชั้นเดียว" | mkN "เรือนไม้ชั้นเดียว" ; -- src=panlex
lin bungee_N = mkN "เชือกบันจี้จั๊ม" ; -- src=panlex
lin bung_hole_N = mkN "รู" | mkN "ตูด" | mkN "รูตูด" | mkN "ประตูหลัง" | mkN "บังกะโล" | mkN "บ้านชั้นเดียว" ; -- src=panlex
lin bungle_N = mkN "การทำผิดพลาด" | mkN "ความผิดที่น่าอับอาย" | mkN "พลาด" | mkN "เสียที" | mkN "งุ่มง่าม" ; -- src=panlex
lin bungle_V = mkV "ทำลวกๆ" | mkV "เงอะงะ" | mkV "ทำงานชุ่ย" | mkV "ทำงานลวกๆ" | mkV "ทำมักง่าย" | mkV "ทำงานมักง่าย" | mkV "ทำงานสะเพร่า" | mkV "ทำให้เสียหาย" | mkV "ทำพลาดอย่างโง่ๆ" ; -- src=panlex
lin bungle_V2 = mkV2 "ทำลวกๆ" ; ---- | mkV "เงอะงะ" | mkV "ทำงานชุ่ย" | mkV "ทำงานลวกๆ" | mkV "ทำมักง่าย" | mkV "ทำงานมักง่าย" | mkV "ทำงานสะเพร่า" | mkV "ทำให้เสียหาย" | mkV "ทำพลาดอย่างโง่ๆ" ; -- src=panlex
lin bungler_N = mkN "คนผิด" | mkN "คนระยำ" | mkN "คนมักง่าย" | mkN "คนสะเพร่า" | mkN "คนโง่เง่า" | mkN "คนงุ่มง่าม" | mkN "คนซุ่มซ่าม" | mkN "ผู้ที่ทําเสียหาย" ; -- src=panlex
lin bunion_N = mkN "อาการเท้าบวม" | mkN "ตาปลาบนนิ้วเท้า" | mkN "โรคตาปลาบนนิ้วเท้า" | mkN "อาการเท้าบวมเนื่องจากถุงไขข้ออักเสบ" ; -- src=panlex
lin bunk_N = mkN "เตียง" | mkN "เตียงเรือ" | mkN "รางอาหารวัว" | mkN "การพูดเหลวไหล" | mkN "เรื่องไร้สาระ" | mkN "เตียงนอนสองชั้น" | mkN "เตียงนอน" | mkN "ความไร้สาระ" | mkN "ที่นอนในเรือหรือกลไฟ" | mkN "ที่ทําเป็นรูปคล้ายหีบ" ; -- src=panlex
lin bunk_V = mkV "เลี่ยง" | mkV "วิ่งหนี" | mkV "เผ่นหนี" ; -- src=panlex
lin bunker_N = mkN "มูนดิน" | mkN "ที่กำบัง" | mkN "บังเกอร์" | mkN "หลุมทราย" | mkN "ถังน้ำมัน" | mkN "อุปสรรคทราย" | mkN "ที่กําบัง" | mkN "หลุมหลบภัย" ; -- src=panlex
lin bunkum_N = mkN "การพูดเหลวไหล" | mkN "การพูดหรือเขียนไร้สาระ" ; -- src=panlex
lin bunny_N = mkN "บันนี่" | mkN "กระต่ายน้อย" | mkN "สาวชุดกระต่าย" | mkN "กระต่าย" | mkN "ลูกกระต่าย" ; -- src=panlex
lin bunsen_N = mkN "ตะเกียงบุนเซน" ; -- src=panlex
lin bunt_N = mkN "การตี" | mkN "เชื้อรา" | mkN "โรคพืชในข้าว" | mkN "โรคเชื้อราในข้าว" ; -- src=panlex
lin bunter_N = mkN "บันเตอร์" ; -- src=panlex
lin bunting_N = mkN "ผ้าทำธง" | mkN "นกบันติ้ง" | mkN "ตอม่อ" | mkN "ธงทิว" | mkN "ผ้าทําธง" | mkN "สิ่งทอเนื้อหยาบ" | mkN "ธงหรือกระดาษสีประดับถนนหรืออาคารในเทศกาลฉลอง" ; -- src=panlex
lin bunyavirus_N = mkN "ไวรัสบันยา" ; -- src=panlex
lin buoy_N = mkN "ทุ่น" | mkN "ทุ่นลอย" | mkN "ทุ่น" | mkN "ชูชีพ" ; -- src=panlex
lin buoy_V = mkV "ลอยตัว" | mkV "วางทุ่น" | mkV "ทำให้ลอยตัว" | mkV "ลอยตัว" ; -- src=panlex
lin buoy_V2 = mkV2 "ลอยตัว" ; ---- | mkV "วางทุ่น" | mkV "ทำให้ลอยตัว" | mkV "ลอยตัว" ; -- src=panlex
lin buoyancy_N = mkN "การลอย" | mkN "การลอยตัว" | mkN "ความร่าเริง" | mkN "ความเฟื่องฟู" | mkN "ทุ่นลอยน้ํา" ; -- src=panlex
lin buoyant_A = mkA "ซึ่งลอยได้" | mkA "ลอยตัว" | mkA "ร่าเริง" | mkA "ลดแล้วขึ้นสูง" | mkA "ซึ่งลอยน้ําขึ้น" | mkA "สามารถทําให้วัตถุลอยน้ํา" ; -- src=panlex
lin bur_N = mkN "เข็ม" | mkN "ผลหนามรูปตะขอ" | mkN "เมล็ดพืชมีหนาม" | mkN "เมล็ดพืชมีหนามมักติดตามเสื้อผ้า" ; -- src=panlex
lin burble_V = mkV "พึมพำ" ; -- src=panlex
lin burble_VS = mmkVS "พึมพำ" ; ---- ; -- src=panlex
lin burbot_N = mkN "ปลาเบอร์บอต" | mkN "ปลาน้ําจืดจําพวกหนึ่ง" ; -- src=panlex
lin burden_N = mkN "ภาระ" | mkN "ระวาง" | mkN "หน้าที่" | mkN "แก่นเรื่อง" | mkN "ใจความสำคัญ" | mkN "น้ำหนักบรรทุก" | mkN "ภาระ" | mkN "ระวาง" | mkN "ทําให้ยุ่งยาก" ; -- src=panlex
lin burdensome_A = mkA "ยุ่งยาก" | mkA "เป็นภาระ" | mkA "ยากลําบาก" | mkA "ที่เป็นภาระ" ; -- src=panlex
lin burdock_N = mkN "หญ้าเจ้าชู้" | mkN "หญ้าเจ้าชู้" ; -- src=panlex
lin bureau_N = mkN "กรม" | mkN "ทบวง" | mkN "หน่วยงาน" | mkN "ตู้มีลิ้นชัก" | mkN "หน่วยงานราชการ" | mkN "ลิ้นชักใส่เสื้อผ้า" | mkN "ตู้ลิ้นชักใส่เสื้อผ้า" | mkN "ทบวง" | mkN "สํานักงาน" | mkN "สํานักข่าว" ; -- src=panlex
lin bureaucracy_N = mkN "รัฐบาลอำมาตยาธิปไตย" | mkN "การปกครองโดยข้าราชการ" | mkN "ระบบบริหารที่มีพิธีรีตอง" | mkN "กลุ่มของข้าราชการ" | mkN "กลุ่มของนักบริหาร" | mkN "ระบบบริหารที่มีพิธีรีตรอง" | mkN "การปกครองระบบเจ้าขุนมูลนาย" | mkN "ระบบบริหารที่มีพิธีรีตองมากเกินไป" ; -- src=panlex
lin bureaucrat_N = mkN "ข้าราชการ" | mkN "ข้าราชการ" | mkN "เจ้าหน้าที่ในระบบเจ้าขุนมูลนาย" | mkN "เจ้าหน้าที่ที่มีพิธีรีตรองมากเกินไป" ; -- src=panlex
lin bureaucratic_A = mkA "เกี่ยวกับระบบราชการ" | mkA "เกี่ยวกับข้าราชการและกฎระเบียบต่างๆ" ; -- src=panlex
lin burette_N = mkN "บิวเรต" | mkN "บิวเรตต์" | mkN "หลอดแก้ว" ; -- src=panlex
lin burg_N = mkN "เมือง" | mkN "เมือง" | mkN "หัวเมือง" | mkN "เมืองป้อมปราการ" ; -- src=panlex
lin burgeon_V = mkV "ออกหน่อ" ; -- src=panlex
lin burgess_N = mkN "ชาวเมือง" | mkN "ประชากร" | mkN "พลเมือง" | mkN "ผู้อยู่อาศัย" ; -- src=panlex
lin burgh_N = mkN "เทศบาลเมือง" | mkN "เมืองหรือตําบล" ; -- src=panlex
lin burgher_N = mkN "ชาวเมือง" | mkN "คนชั้นกลาง" | mkN "ชาวเมือง" | mkN "ประชากรของเมือง" ; -- src=panlex
lin burglar_N = mkN "โจรงัดแงะ" | mkN "โจรยกเค้า" | mkN "คนลักขโมยของ" | mkN "ผู้ร้ายย่องเบา" ; -- src=panlex
lin burglar_proof_A = mkA "ซึ่งกันขโมย" ; -- src=panlex
lin burglary_N = mkN "การขโมย" | mkN "การย่องเบา" | mkN "การขโมยย่องเบา" | mkN "การบุกเข้ามาขโมยของในอาคาร/บ้าน" ; -- src=panlex
lin burgle_V = mkV "งัด" | mkV "งัดแงะ" | mkV "ยกเค้า" | mkV "โจรกรรม" | mkV "ขึ้นบ้าน" | mkV "ย่องเบา" | mkV "บุกเข้ามาขโมยของในอาคาร/บ้าน" ; -- src=panlex
lin burgle_V2 = mkV2 "งัด" ; ---- | mkV "งัดแงะ" | mkV "ยกเค้า" | mkV "โจรกรรม" | mkV "ขึ้นบ้าน" | mkV "ย่องเบา" | mkV "บุกเข้ามาขโมยของในอาคาร/บ้าน" ; -- src=panlex
lin burgomaster_N = mkN "เบอเกอแมสเตอร์" ; -- src=panlex
lin burgoo_N = mkN "เบอร์กู" | mkN "ข้าวโอ๊ต" | mkN "สตูเบอร์กู" ; -- src=panlex
lin burgrass_N = mkN "หญ้าเบอร์แกรส" ; -- src=panlex
lin burgrave_N = mkN "เบอร์เกรฟ" ; -- src=panlex
lin burgundy_N = mkN "สีแดงแก่อมม่วง" | mkN "สีม่วงแดง" | mkN "เหล้าองุ่นแดงหรือขาว" | mkN "ไวน์แดงหรือขาวจากฝรั่งเศส" ; -- src=panlex
lin burial_N = mkN "การฝัง" | mkN "การฝังดิน" | mkN "พิธีฝังศพ" | mkN "งานศพ" | mkN "การฝังศพ" | mkN "พิธีฝังศพ" | mkN "สถานที่ฝังศพ" ; -- src=panlex
lin burin_N = mkN "สิ่วแท่ง" ; -- src=panlex
lin burl_N = mkN "ปุ่มไม้" | mkN "ไม้เบิร์ล" ; -- src=panlex
lin burlap_N = mkN "ผ้ากระสอบ" | mkN "ผ้าป่านหยาบ" | mkN "ผ้าที่ถักหรือทอแบบหยาบ" | mkN "ผ้าหนาหยาบใช้ทํากระสอบ" ; -- src=panlex
lin burlesque_N = mkN "การล้อ" | mkN "การยั่วล้อ" | mkN "การล้อเลียน" | mkN "ภาพตลกล้อเลียน" | mkN "การล้อเลียนที่ตลก" ; -- src=panlex
lin burly_A = mkA "กํายํา" | mkA "โผงผาง" | mkA "ล่ําสัน" | mkA "ขวานผ่าซาก" | mkA "กํายําล่ําสัน" | mkA "ซึ่งมีขนาดใหญ่" ; -- src=panlex
lin burmese_A = mkA "ชาวพม่า" | mkA "ภาษาพม่า" ; -- src=panlex
lin burmese_N = mkN "ชาวพม่า" | mkN "ภาษาพม่า" ; -- src=panlex
lin burn_N = mkN "การไหม้" | mkN "การอาบแดด" | mkN "แผลไฟไหม้" | mkN "ผิวคล้ำแดด" | mkN "รอยแผลไหม้" | mkN "ที่โดนไฟไหม้" | mkN "รอยแผลไฟไหม้" | mkN "ความปวดแสบปวดร้อน" | mkN "การเผาผลาญ" | mkN "บริเวณที่ไหม้" | mkN "บริเวณที่ถูกเผา" ; -- src=panlex
lin burn_V = mkV (thword "เผา") | {-pan-} mkV "เผา" | mkV "ไหม้" | mkV "เบิร์น" | mkV "แผดเผา" | mkV "เผาผลาญ" | mkV "เผาไหม้" | mkV "แสบร้อน" | mkV "จุดไฟเผา" | mkV "ถลุงเงิน" | mkV "ผลาญเงิน" | mkV "ร้อนรุ่ม" | mkV "เปล่งแสง" | mkV "ใช้ไฟจี้" | mkV "เผาทั้งเป็น" | mkV "คัดลอกข้อมูล" | mkV "ปวดแสบปวดร้อน" | mkV "เผา" | mkV "ไหม้" | mkV "แดดเผา" | mkV "เผาไหม้" | mkV "ไหม้แดด" | mkV "เกรียมแดด" | mkV "ทําให้ไหม้" ; -- src=panlex
lin burn_V2 = mkV2 (thword "เผา") ; ---- | {-pan-} mkV "เผา" | mkV "ไหม้" | mkV "เบิร์น" | mkV "แผดเผา" | mkV "เผาผลาญ" | mkV "เผาไหม้" | mkV "แสบร้อน" | mkV "จุดไฟเผา" | mkV "ถลุงเงิน" | mkV "ผลาญเงิน" | mkV "ร้อนรุ่ม" | mkV "เปล่งแสง" | mkV "ใช้ไฟจี้" | mkV "เผาทั้งเป็น" | mkV "คัดลอกข้อมูล" | mkV "ปวดแสบปวดร้อน" | mkV "เผา" | mkV "ไหม้" | mkV "แดดเผา" | mkV "เผาไหม้" | mkV "ไหม้แดด" | mkV "เกรียมแดด" | mkV "ทําให้ไหม้" ; -- src=panlex
lin burn_down_V = advV OP_burn_V OP_down_Adv ; -- guess-p-verb
lin burn_down_V2 = prepV2 OP_burn_V OP_down_Prep ; -- guess-p-verb
lin burn_off_V2 = prepV2 OP_burn_V OP_off_Prep ; -- guess-p-verb
lin burn_out_V = advV OP_burn_V OP_out_Adv ; -- guess-p-verb
lin burn_up_V = advV OP_burn_V OP_up_Adv ; -- guess-p-verb
lin burn_up_V2 = prepV2 OP_burn_V OP_up_Prep ; -- guess-p-verb
lin burner_N = mkN "หัวเตา" | mkN "อุปกรณ์เผาเชื้อเพลิง" | mkN "คนเผา" | mkN "ตะเกียง" | mkN "สิ่งที่เผา" | mkN "หัวตะเกียง" | mkN "อุปกรณ์เผาไหม้" | mkN "ภาชนะสําหรับเผาเครื่องหอม" ; -- src=panlex
lin burning_A = mkA "สําคัญ" | mkA "ร้อนจัด" | mkA "ลุกช่วง" | mkA "ลุกไหม้" | mkA "เผาไหม้" | mkA "สว่างมาก" | mkA "เร่าร้อน" | mkA "ปัญหาสําคัญ" | mkA "ที่ถูกเผาผลาญ" | mkA "ความเลวร้ายมาก" ; -- src=panlex
lin burning_N = mkN "การเผา" | mkN "การเผาไหม้" | mkN "การจี้ด้วยไฟ" | mkN "กระบวนการเผาไหม้" | mkN "ความปวดแสบปวดร้อน" | mkN "การประหารชีวิตด้วยการเผา" | mkN "การประหารชีวิตด้วยกระแสไฟฟ้า" ; -- src=panlex
lin burnish_V = mkV "ขัดสี" | mkV "ขัดเงา" | mkV "ขัด" | mkV "ขัดเงา" | mkV "ขัดให้วาว" ; -- src=panlex
lin burnish_V2 = mkV2 "ขัดสี" ; ---- | mkV "ขัดเงา" | mkV "ขัด" | mkV "ขัดเงา" | mkV "ขัดให้วาว" ; -- src=panlex
lin burnous_N = mkN "เสื้อคลุมที่มีผ้าโพกศีรษะ" | mkN "เสื้อคลุมที่มีผ้าโพกหัวเช่นของชาวอาหรับ" ; -- src=panlex
lin burnouse_N = mkN "เสื้อคลุมที่มีผ้าโพกศีรษะ" ; -- src=panlex
lin burn_up_N = mkN "การแข่งขันจักรยานยนต์" ; -- src=panlex
lin burp_N = mkN "การเรอ" ; -- src=panlex
lin burp_V = mkV "เรอ" | mkV "เรอ" ; -- src=panlex
lin burp_V2 = mkV2 "เรอ" ; ---- | mkV "เรอ" ; -- src=panlex
lin burqa_N = mkN "ชุดบุรกา" ; -- src=panlex
lin burr_N = mkN "เข็ม" | mkN "การตะไบ" | mkN "ความขรุขระ" | mkN "เครื่องตะไบ" | mkN "ผลหนามรูปตะขอ" | mkN "เมล็ดพืชมีหนาม" | mkN "มีดตัด" | mkN "เสี้ยน" | mkN "เครื่องขูดแงะฟัน" | mkN "ส่วนที่ยื่นที่หยาบ หัวที่เป็นขนปัด" | mkN "เครื่องขูดแงะกระดูก" | mkN "เมล็ดพืชมีหนามมักติดตามเสื้อผ้า" ; -- src=panlex
lin burrawong_N = mkN "ต้นเบอร์ราวอง" ; -- src=panlex
lin burrfish_N = mkN "ปลาเบอร์ฟิช" ; -- src=panlex
lin burrito_N = mkN "เบอร์ริโต" | mkN "เบอร์ริโต้" ; -- src=panlex
lin burro_N = mkN "ลา" | mkN "ลาเล็ก" | mkN "ลาตัวเล็ก" ; -- src=panlex
lin burrow_N = mkN "โพรง" | mkN "ีรู" ; -- src=panlex
lin burrow_V = mkV "ขุดอุโมงค์" | mkV "ซุก" | mkV "มุด" | mkV "หลบ" | mkV "แอบ" | mkV "ซ่อน" | mkV "ทําให้เป็นรูหรือโพรง" ; -- src=panlex
lin burrow_V2 = mkV2 "ขุดอุโมงค์" ; ---- | mkV "ซุก" | mkV "มุด" | mkV "หลบ" | mkV "แอบ" | mkV "ซ่อน" | mkV "ทําให้เป็นรูหรือโพรง" ; -- src=panlex
lin bursa_N = mkN "ถุงหล่อลื่น" | mkN "ถุง" | mkN "หอพัก" | mkN "นักศึกษา" ; -- src=panlex
lin bursar_N = mkN "เหรัญญิก" | mkN "เจ้าหน้าที่การเงินในมหาวิทยาลัย" | mkN "เหรัญญิก" | mkN "เหรัญญิกโรงเรียนหรือวิทยาลัย" ; -- src=panlex
lin bursary_N = mkN "ทุนการศึกษา" | mkN "ฝ่ายคลังของโบสถ์" | mkN "เงินทุนสําหรับนักศึกษา" ; -- src=panlex
lin bursiform_A = mkA "เป็นรูปถุงหรือกระเปา" ; -- src=panlex
lin burst_N = mkN "การระบาด" | mkN "การระเบิด" | mkN "การระดมยิง" | mkN "การรัวกระสุน" | mkN "การทำให้ระเบิด" | mkN "การระเบิด" ; -- src=panlex
lin burst_V = mkV "แตก" | mkV "โผล่" | mkV "อลเวง" | mkV "ระเบิด" | mkV "ทำให้แตก" | mkV "ทำให้ระเบิด" | mkV "ระเบิดเสียงดัง" | mkV "แตก" | mkV "ปะทุ" | mkV "โพล่ง" | mkV "ระเบิด" ; -- src=panlex
lin burst_V2 = mkV2 "แตก" ; ---- | mkV "โผล่" | mkV "อลเวง" | mkV "ระเบิด" | mkV "ทำให้แตก" | mkV "ทำให้ระเบิด" | mkV "ระเบิดเสียงดัง" | mkV "แตก" | mkV "ปะทุ" | mkV "โพล่ง" | mkV "ระเบิด" ; -- src=panlex
lin burst_into_V2 = prepV2 OP_burst_V OP_into_Prep ; -- guess-p-verb
lin burton_N = mkN "เครื่องชักรอกเบาแบบเดี่ยวหรือคู่" ; -- src=panlex
lin bury_V = mkV "ฝัง" | mkV "ฝังศพ" | mkV "กลืนกิน" | mkV "หมกหมุ่น" | mkV "ไม่นึกถึง" | mkV "จม" | mkV "บัง" | mkV "ฝัง" | mkV "ฝังศพ" ; -- src=panlex
lin bury_V2 = mkV2 "ฝัง" ; ---- | mkV "ฝังศพ" | mkV "กลืนกิน" | mkV "หมกหมุ่น" | mkV "ไม่นึกถึง" | mkV "จม" | mkV "บัง" | mkV "ฝัง" | mkV "ฝังศพ" ; -- src=panlex
lin burying_N = mkN "การฝัง" | mkN "การฝังดิน" | mkN "การฝัง" ; -- src=panlex
lin bus_N = mkN "ซากรถ" | mkN "รถบัส" | mkN "รถเก่า" | mkN "รถเมล์" | mkN "รถประจำทาง" | mkN "สะพานไฟฟ้า" | mkN "บัสโทโพโลจี" | mkN "สายไฟฟ้าใหญ่" | mkN "รถโดยสารสาธารณะ" | mkN "รถโดยสารประจำทาง" | mkN "รถบัส" | mkN "รถเมล์" | mkN "รถโดยสารประจําทาง" ; -- src=panlex
lin bus_V = mkV "ขึ้นรถบัส" | mkV "นั่งรถบัส" | mkV "ขึ้นรถเมล์" | mkV "ที่เก็บจาน" | mkV "นั่งรถเมล์" | mkV "ขึ้นรถประจำทาง" | mkV "นั่งรถประจำทาง" | mkV "ขึ้นรถโดยสารประจำทาง" | mkV "นั่งรถโดยสารประจำทาง" | mkV "เดินทางโดยรถบัส" | mkV "เดินทางโดยรถสารประจําทาง" ; -- src=panlex
lin bus_V2 = mkV2 "ขึ้นรถบัส" ; ---- | mkV "นั่งรถบัส" | mkV "ขึ้นรถเมล์" | mkV "ที่เก็บจาน" | mkV "นั่งรถเมล์" | mkV "ขึ้นรถประจำทาง" | mkV "นั่งรถประจำทาง" | mkV "ขึ้นรถโดยสารประจำทาง" | mkV "นั่งรถโดยสารประจำทาง" | mkV "เดินทางโดยรถบัส" | mkV "เดินทางโดยรถสารประจําทาง" ; -- src=panlex
lin busbar_N = mkN "สะพานไฟฟ้า" | mkN "สายไฟฟ้าใหญ่" ; -- src=panlex
lin busboy_N = mkN "ผู้ช่วยพนักงานเสิร์ฟ" | mkN "บริกรชาย" | mkN "ผู้ช่วยบริการในร้านอาหาร" ; -- src=panlex
lin busby_N = mkN "หมวกบัสบี" ; -- src=panlex
lin bush_N = mkN "ป่า" | mkN "ไม้พุ่ม" | mkN "ป่าละเมาะ" | mkN "พระโลมะชาติ" | mkN "ขนตรงหัวเหน่า" | mkN "สุมทุมพุ่มไม้" | mkN "พุ่มไม้" ; -- src=panlex
lin bushel_N = mkN "บูเชิล" | mkN "หน่วงตวงวัดข้าว" | mkN "หน่วยตวงวัดข้าว" ; -- src=panlex
lin bushing_N = mkN "ปลอก" ; -- src=panlex
lin bushman_N = mkN "บุชแมน" | mkN "คนป่า" | mkN "คนที่ชอบอาศัยอยู่ในป่า" ; -- src=panlex
lin bushtit_N = mkN "นกทิชพุ่มไม้" ; -- src=panlex
lin bushwhacker_N = mkN "คนหลังเขา" ; -- src=panlex
lin bushy_A = mkA "ที่เป็นพุ่ม" | mkA "คล้ายพุ่มไม้" | mkA "เป็นป่าละเมาะ" | mkA "เต็มไปด้วยพุ่มไม้" ; -- src=panlex
lin business_N = mkN "งาน" | mkN "อาชีพ" | mkN "การงาน" | mkN "กิจการ" | mkN "ธุรกิจ" | mkN "สายงาน" | mkN "ภาคธุรกิจ" | mkN "กลุ่มลูกค้า" | mkN "องค์กรธุรกิจ" | mkN "ลูกค้าทั้งหมด" | mkN "หน้าที่การงาน" | mkN "เป้าหมายโดยตรง" | mkN "กิจ" | mkN "งาน" | mkN "ธุระ" | mkN "การค้า" | mkN "ธุรกิจ" | mkN "ภารกิจ" | mkN "กิจธุระ" | mkN "หน้าที่" | mkN "สถานการณ์" | mkN "ผู้สนับสนุน" | mkN "ภาระหน้าที่" | mkN "หน้าที่การงาน" | mkN "เรื่องที่ยากลําบาก" | mkN "เรื่องที่ถือว่าสําคัญและเอาจริงเอาจัง" ; -- src=panlex
lin businesslike_A = mkA "เหมือนธุรกิจ" | mkA "มีประสิทธิภาพ" | mkA "เอาจริงเอาจัง" | mkA "เกี่ยวกับธุรกิจ" ; -- src=panlex
lin businessman_N = mkN "นักธุรกิจ" | mkN "นักธุรกิจ" | mkN "นักธุรกิจชาย" ; -- src=panlex
lin businessperson_N = mkN "คนทำธุรกิจ" | mkN "คนทำมาหากิน" | mkN "ผู้ทำธุรกิจ" | mkN "คนทำมาค้าขาย" | mkN "ผู้ประกอบการ" | mkN "ผู้ประกอบธุรกิจ" ; -- src=panlex
lin businesswoman_N = mkN "นักธุรกิจหญิง" | mkN "นักธุรกิจหญิง" | mkN "หญิงนักธุรกิจ" ; -- src=panlex
lin busker_N = mkN "วณิพก" ; -- src=panlex
lin buskin_N = mkN "รองเท้าบูทครึ่งเข่า" ; -- src=panlex
lin busload_N = mkN "ความจุ" | mkN "ผู้โดยสารจํานวนมากบนรถโดยสาร" ; -- src=panlex
lin busman_N = mkN "คนขับรถบัส" | mkN "คนขับรถโดยสาร" | mkN "คนขับรถประจำทาง" | mkN "พนักงานขับรถบัส" | mkN "พนักงานขับรถประจำทาง" ; -- src=panlex
lin buspirone_N = mkN "ยาบัสไปโรน" ; -- src=panlex
lin bust_N = mkN "นม" | mkN "หน้าอก" | mkN "การกินดื่ม" | mkN "ความล้มเหลว" | mkN "ช่วงที่กินดื่มมากเกินไป" | mkN "นม" | mkN "หน้าอก" ; -- src=panlex
lin bust_V = mkV "ฉีก" | mkV "แตก" | mkV "ทำลาย" | mkV "ระเบิด" | mkV "แตกเป็นเสี่ยง" ; -- src=panlex
lin bust_V2 = mkV2 "ฉีก" ; ---- | mkV "แตก" | mkV "ทำลาย" | mkV "ระเบิด" | mkV "แตกเป็นเสี่ยง" ; -- src=panlex
lin bustard_N = mkN "นกบัสตาร์ด" ; -- src=panlex
lin buster_N = mkN "เบบี้ ดอก" | mkN "บัสเตอร์" | mkN "พ่อหนุ่ม" | mkN "ไอ้หนุ่ม" | mkN "เด็กแกร่ง" | mkN "ผู้ทรงอำนาจ" | mkN "เด็กจอมพลัง" | mkN "เด็กแข็งแรง" | mkN "คนกุมบังเหียน" | mkN "ผู้ทําลาย" | mkN "การดื่มจนเมา" | mkN "คําเรียกชายที่ไม่ชอบ" | mkN "สิ่งที่ใหญ่มากผิดปกติ" ; -- src=panlex
lin bustier_N = mkN "เสื้อไร้สายรัดอกและเอวของสตรี" ; -- src=panlex
lin bustle_N = mkN "ความวุ่นวาย" | mkN "ความพลุกพล่าน" | mkN "ฟองน้ำเสริมก้น" ; -- src=panlex
lin bustle_V = mkV "กระวีกระวาด" | mkV "จอแจ" | mkV "วุ่นวาย" | mkV "กุลีกุจอ" | mkV "พลุกพล่าน" | mkV "กระวีกระวาด" ; -- src=panlex
lin bustle_V2 = mkV2 "กระวีกระวาด" ; ---- | mkV "จอแจ" | mkV "วุ่นวาย" | mkV "กุลีกุจอ" | mkV "พลุกพล่าน" | mkV "กระวีกระวาด" ; -- src=panlex
lin busy_A = mkA "ที่วุ่นวาย" | mkA "ขยัน" | mkA "ยุ่ง" | mkA "สับสน" | mkA "อลเวง" | mkA "อลหม่าน" | mkA "ไม่อยู่เฉย" | mkA "ยุ่งวุ่นวาย" ; -- src=panlex
lin busybody_N = mkN "คนสอดรู้สอดเห็น" | mkN "คนที่ชอบยุ่งเรื่องคนอื่น" | mkN "คนสอดรู้สอดเห็นเรื่องคนอื่น" ; -- src=panlex
lin busyness_N = mkN "งานที่ยุ่ง" | mkN "ภาวะที่ยุ่ง" ; -- src=panlex
lin busywork_N = mkN "งานที่ทําให้ยุ่งและไม่มีประโยชน์" ; -- src=panlex
lin but_Adv = mkAdv "เพียง" | mkAdv "เท่านั้น" | mkAdv "เพียงแค่" | mkAdv "เพียงแต่" | mkAdv "เป็นแต่เพียง" ; -- src=panlex
lin but_PConj = ss "แต่" ;
lin but_Prep = mkPrep "นอกจาก" | mkPrep "ยกเว้น" | mkPrep "เว้นแต่" ; -- src=panlex
lin butadiene_N = mkN "ก๊าซบูทาเดียน" | mkN "ก๊าซบูทาไดอีน" | mkN "ก๊าซบิวตะไดอีน" ; -- src=panlex
lin butane_N = mkN "บิวเทน" | mkN "ก๊าซบิวเทน" | mkN "แก๊สติดไฟที่ไร้สีชนิดหนึ่ง" | mkN "ก๊าซที่กลั่นจากน้ํามันปิโตรเลียม" ; -- src=panlex
lin butanone_N = mkN "บิวทาโนน" ; -- src=panlex
lin butch_N = mkN "ทอม" | mkN "อีทอม" | mkN "คนร่วมเพศเดียวกันและมีบทบาทมากกว่า" ; -- src=panlex
lin butcher_N = mkN "คนผิด" | mkN "คนระยำ" | mkN "ฆาตกรโหด" | mkN "คนมักง่าย" | mkN "คนสะเพร่า" | mkN "คนโง่เง่า" | mkN "คนขายเนื้อ" | mkN "คนฆ่าสัตว์" | mkN "คนงุ่มง่าม" | mkN "คนซุ่มซ่าม" | mkN "พ่อค้าเนื้อสัตว์" | mkN "คนขายเนื้อ" | mkN "คนฆ่าสัตว์ขาย" | mkN "คนชําแหละเนื้อสัตว์" ; -- src=panlex
lin butcherbird_N = mkN "นกบัตเชอร์เบิร์ด" | mkN "นกบุตเชอร์เบิร์ด" ; -- src=panlex
lin butchery_N = mkN "การฆ่าฟัน" | mkN "โรงชำแหละ" | mkN "โรงฆ่าสัตว์" | mkN "การสังหารหมู่" | mkN "การฆาตกรรมหมู่" | mkN "ธุรกิจค้าเนื้อสัตว์" | mkN "การทําลาย" | mkN "การฆาตกรรม" | mkN "โรงฆ่าสัตว์" | mkN "ความยุ่งเหยิง" | mkN "การฆ่าสัตว์ขาย" | mkN "การฆ่าอย่างโหดร้ายทารุณ" | mkN "คนฆ่าคนตายอย่างทารุณโหดร้าย" ; -- src=panlex
lin buteonine_N = mkN "เหยี่ยวบิวเทียวนีน" ; -- src=panlex
lin butler_N = mkN "พ่อบ้าน" | mkN "หัวหน้าคนใช้" | mkN "พ่อบ้าน" | mkN "หัวหน้าคนใช้" ; -- src=panlex
lin butt_N = mkN "ก้น" | mkN "ตูด" | mkN "เป้า" | mkN "ยาสูบ" | mkN "การต่อ" | mkN "ตัวตลก" | mkN "บุหรี่" | mkN "ก้นกรอง" | mkN "ซิกาแรต" | mkN "ส่วนก้น" | mkN "ถังบัตต์" | mkN "บั้นท้าย" | mkN "ยาซิกาแรต" | mkN "ปลายด้ามจับ" | mkN "สะโพก" | mkN "ตัวตลก" | mkN "ส่วนก้น" | mkN "ถังขนาดใหญ่" | mkN "ถังใส่เหล้าองุ่น" | mkN "ด้านปลายที่ใหญ่ของที่จับ" ; -- src=panlex
lin butt_V = mkV "ติด" | mkV "ขวิด" | mkV "ประชิด" | mkV "ขวิด" ; -- src=panlex
lin butt_V2 = mkV2 "ติด" ; ---- | mkV "ขวิด" | mkV "ประชิด" | mkV "ขวิด" ; -- src=panlex
lin butte_N = mkN "เนิน" ; -- src=panlex
lin butter_N = mkN (thword "เนย") "สด" | {-pan-} mkN "เนย" | mkN "เนย" ; -- src=panlex ----?
lin butterbur_N = mkN "ต้นบัตเตอร์เบอร์" ; -- src=panlex
lin buttercup_N = mkN "ต้นบัตเตอร์คัพ" | mkN "ต้นไม้ป่ามีดอกเล็กสีเหลือง รูปร่างเหมือนถ้วย" ; -- src=panlex
lin butterfat_N = mkN "ไขมันเนย" ; -- src=panlex
lin butterfingers_N = mkN "คนงุ่มง่าม" | mkN "คนส่งต่อลูกบอล" | mkN "คนที่ทําของตกหล่นบ่อย" ; -- src=panlex
lin butterfish_N = mkN "ปลาร็อกกันเนล" | mkN "ปลาบัตเตอร์ฟิช" | mkN "เนื้อปลาบัตเตอร์ฟิช" | mkN "ปลาจาระเม็ด" | mkN "ปลาจาละเม็ด" ; -- src=panlex
lin butterfly_N = mkN "ผีเสื้อ" | mkN "ท่าผีเสื้อ" | mkN "ท่าว่ายผีเสื้อ" | mkN "ผีเสื้อ" | mkN "คนที่มีใจคอไม่แน่นอน" | mkN "การว่ายน้ําท่าผีเสื้อ" | mkN "การว่ายน้ําแบบผีเสื้อ" | mkN "คนโง่หรือคนที่ไม่ใส่ใจในเรื่องใดๆ" ; -- src=panlex
lin buttermilk_N = mkN "บัตเตอร์มิลค์" | mkN "นมเปรี้ยวชนิดหนึ่ง" ; -- src=panlex
lin butternut_N = mkN "ไวต์วอลนัต" | mkN "บัตเตอร์นัต" | mkN "บัตเตอร์นัท" | mkN "ต้นไวต์วอลนัต" | mkN "ต้นบัตเตอร์นัต" ; -- src=panlex
lin butterscotch_N = mkN "บัตเตอร์สก็อตช์" | mkN "ซอสชนิดหนึ่ง" | mkN "ขนมหวานชนิดหนึ่ง" ; -- src=panlex
lin butterweed_N = mkN "ต้นบัตเตอร์วีด" ; -- src=panlex
lin butterwort_N = mkN "ต้นบัตเตอร์เวิร์ต" ; -- src=panlex
lin buttery_A = mkA "คล้ายเนย" | mkA "ทําด้วยเนย" | mkA "ห้องขายอาหาร" ; -- src=panlex
lin buttery_N = mkN "ห้องเก็บอาหาร" ; -- src=panlex
lin buttock_N = mkN "ก้น" | mkN "สะโพก" | mkN "ท้ายเรือ" | mkN "ส่วนท้าย" | mkN "ตะโพกข้างหนึ่ง" ; -- src=panlex
lin buttocks_N = mkN "ก้น" | mkN "ตูด" | mkN "บั้นท้าย" | mkN "ก้น" | mkN "ตะโพก" | mkN "บั้นท้าย" | mkN "ส่วนท้ายของเรือ" ; -- src=panlex
lin button_N = mkN "ปุ่ม" | mkN "กระดุม" | mkN "ปุ่มกด" | mkN "คลิตอริส" | mkN "ปุ่มเปิด-ปิด" | mkN "กระดุมเห็ด" | mkN "ปุ่มกระสัน" | mkN "ปุ่มคลิตอริส" | mkN "ช่อ" | mkN "ดุม" | mkN "ปุ่ม" | mkN "กระดุม" | mkN "ลูกดุม" | mkN "สวิตช์" | mkN "หน่อไม้" | mkN "เห็ดตูม" | mkN "หน่ออ่อน" | mkN "ติดกระดุม" | mkN "กระดุมเสื้อ" | mkN "ประสาทที่ดี" | mkN "พนักงานบริการ" | mkN "ปุ่มกระดิ่งไฟฟ้า" ; -- src=panlex
lin button_V = mkV "ติดกระดุม" | mkV "กลัดกระดุม" | mkV "กลัด" | mkV "ติดกระดุม" | mkV "ใส่กระดุม" | mkV "กลัดกระดุม" ; -- src=panlex
lin button_V2 = mkV2 "ติดกระดุม" ; ---- | mkV "กลัดกระดุม" | mkV "กลัด" | mkV "ติดกระดุม" | mkV "ใส่กระดุม" | mkV "กลัดกระดุม" ; -- src=panlex
lin buttonhole_N = mkN "รังดุม" | mkN "รังกระดุม" | mkN "ชวนคุย" | mkN "รังดุม" | mkN "จับตัวได้" | mkN "รังดุมเสื้อผ้า" ; -- src=panlex
lin buttonhook_N = mkN "ตะขอดึงกระดุม" | mkN "ดุมตะขอเกี่ยว" ; -- src=panlex
lin buttonwood_N = mkN "ต้นอเมริกันไซคามอร์" ; -- src=panlex
lin buttony_A = mkA "เหมือนลูกปัด" | mkA "ซึ่งประดับกระดุมหลายเม็ด" ; -- src=panlex
lin buttress_N = mkN "ครีบยัน" | mkN "ส่วนที่ค้ำ" | mkN "โครงสร้างที่เป็นส่วนค้ําจุน" ; -- src=panlex
lin butty_N = mkN "แซนด์วิช" | mkN "แซนด์วิช" ; -- src=panlex
lin butut_N = mkN "บูทุต" | mkN "บูแทต" ; -- src=panlex
lin butyl_N = mkN "บูทิล" ; -- src=panlex
lin butylene_N = mkN "บูทีลีน" | mkN "บิวทิลีน" ; -- src=panlex
lin butyrin_N = mkN "บูทีริน" ; -- src=panlex
lin buxom_A = mkA "ท้วม" | mkA "อวบอัด" | mkA "อ้วนท้วน" | mkA "มีหน้าอกใหญ่" ; -- src=panlex
lin buy_N = mkN "สินค้าราคาต่อ" | mkN "การซื้อ" | mkN "การต่อรอง" | mkN "การแลกเปลี่ยน" ; -- src=panlex
lin buy_V = mkV "รับ" | mkV "ซื้อ" | mkV "ติดสินบน" | mkV "จ่ายใต้โต๊ะ" | mkV "ซื้อ" ; -- src=panlex
lin buy_V2 = mkV2 "ซื้อ" ;
lin buy_back_V2 = mkV2 (advV OP_buy_V OP_back_Adv ) ; -- guess-p-verb
lin buy_in_V2 = prepV2 OP_buy_V OP_in_Prep ; -- guess-p-verb
lin buy_into_V2 = prepV2 OP_buy_V OP_into_Prep ; -- guess-p-verb
lin buy_off_V2 = prepV2 OP_buy_V OP_off_Prep ; -- guess-p-verb
lin buy_out_V2 = prepV2 OP_buy_V OP_out_Prep ; -- guess-p-verb
lin buy_up_V2 = prepV2 OP_buy_V OP_up_Prep ; -- guess-p-verb
lin buyerFem_N = variants {} ; ---- sense to be split
lin buyerMasc_N = variants {} ; ---- sense to be split
lin buying_N = mkN "การซื้อ" ; -- src=panlex
lin buyout_N = mkN "การซื้อขายหุ้นของบริษัท" ; -- src=panlex
lin buzz_N = mkN "เสียงหึ่งๆ" | mkN "การซุบซิบนินทา" | mkN "เสียงพึมพํา" | mkN "กระซิบกระซาบ" | mkN "เสียงเหมือนผึ้งร้องหึ่งๆ" ; -- src=panlex
lin buzz_V = mkV "บินต่ำ" | mkV "วุ่นวาย" | mkV "กดกริ่งเรียก" | mkV "ทำเสียงหึ่งๆ" ; -- src=panlex
lin buzz_V2 = mkV2 "บินต่ำ" ; ---- | mkV "วุ่นวาย" | mkV "กดกริ่งเรียก" | mkV "ทำเสียงหึ่งๆ" ; -- src=panlex
lin buzzard_N = mkN "เหยี่ยวทะเลทราย" | mkN "อีแร้ง" | mkN "คนระยํา" | mkN "คนละโมบ" ; -- src=panlex
lin buzzer_N = mkN "กริ่ง" | mkN "กริ่งไฟฟ้า" | mkN "กริ่ง" | mkN "ออดเสียง" | mkN "คนที่พึมพํา" | mkN "สิ่งที่ทําเสียงหึ่ง" | mkN "เครื่องไฟฟ้าที่ให้สัญญาณเรียก" ; -- src=panlex
lin buzzword_N = mkN "คำพูดติดปาก" | mkN "คำพูดหรูหรา" | mkN "คําหรือวลีที่นิยมมาก" ; -- src=panlex
lin by8agent_Prep = ss [] ;
lin by8means_Prep = ss "ผ่าน" ;
lin by_Adv = mkAdv "ผ่าน" | mkAdv "สำรอง" | mkAdv "ก่อนเวลาที่กําหนด" ; -- src=panlex
lin by_Prep = mkPrep "ของ" | mkPrep "จาก" | mkPrep "ตาม" | mkPrep "ต่อ" | mkPrep "ทาง" | mkPrep "ที่" | mkPrep "ทุก" | mkPrep "โดย" | mkPrep "ใช้" | mkPrep "ข้าง" | mkPrep "ช่วง" | mkPrep "ด้วย" | mkPrep "ทีละ" | mkPrep "ผ่าน" | mkPrep "ใกล้" | mkPrep "อาศัย" | mkPrep "ไปทาง" | mkPrep "ไปยัง" | mkPrep "ติดตัว" | mkPrep "ผ่านไป" | mkPrep "ระหว่าง" | mkPrep "ผ่านข้าง" | mkPrep "หันไปทาง" | mkPrep "อยู่ข้าง" | mkPrep "เป็นไปตาม" | mkPrep "โดยประมาณ" | mkPrep "เป็นผลเนื่องจาก" ; -- src=panlex
lin bye_Interj = mkInterj (thword "ลา" "ก่อน") ;
lin bye_N = mkN "ตัวสํารอง" | mkN "สิ่งสํารอง" | mkN "สิ่งที่เป็นรอง" | mkN "การผ่านข้ามไปเล่นในรอบต่อไป" | mkN "การผ่านเข้าไปเล่นในรอบต่อไป" ; -- src=panlex
lin bygone_A = mkA "อดีต" | mkA "แต่ก่อน" | mkA "ซึ่งผ่านไปแล้ว" | mkA "ซึ่งเกิดขึ้นนานมาแล้ว" ; -- src=panlex
lin bygone_N = mkN "สิ่งที่ผ่านไป" | mkN "อดีต" | mkN "สิ่งที่ผ่านไปแล้ว" ; -- src=panlex
lin bylaw_N = mkN "กฎเทศบาล" | mkN "กฎหมายประกอบ" | mkN "กฎหมายท้องถิ่น" ; -- src=panlex
lin bypass_N = mkN "ถนนวงแหวน" | mkN "ทางเลี่ยง" | mkN "ถนนเลี่ยงเมือง" | mkN "อุปกรณ์สับเปลี่ยนกระแสไฟฟ้า" | mkN "ทางอ้อม" | mkN "ทางแยกวน" | mkN "ไปทางอ้อม" | mkN "ถนนรอบเมือง" | mkN "ไม่สนใจข้อคิดเห็นหรือคําตัดสิน" ; -- src=panlex
lin bypath_N = mkN "ถนนบายพาท" | mkN "ทางบายพาท" | mkN "ถนนเลี่ยงเมือง" | mkN "ทางรอง" | mkN "ทางย่อย" | mkN "ทางอ้อม" ; -- src=panlex
lin byproduct_N = mkN "ผลพลอยได้" | mkN "บายโปรดักท์" | mkN "ผลิตภัณฑ์พลอยได้" ; -- src=panlex
lin byroad_N = mkN "ถนนบายพาท" | mkN "ทางบายพาท" | mkN "ถนนเลี่ยงเมือง" | mkN "ถนนรอง" | mkN "ถนนอ้อม" | mkN "ทางอ้อม" ; -- src=panlex
lin byssus_N = mkN "รากหอย" ; -- src=panlex
lin bystander_N = mkN "ผู้เห็นเหตุการณ์" | mkN "คนมุง" | mkN "คนยืนมอง" | mkN "ผู้สังเกตการณ์" | mkN "ผู้เห็นเหตุการณ์" ; -- src=panlex
lin byte_N = mkN "ไบต์" | mkN "048" | mkN "073" | mkN "เมกะไบต์ เท่ากับประมาณ 1 ล้านไบต์" | mkN "741" | mkN "ข้อมูลจํานวน 8 บิต" ; -- src=panlex
lin byway_N = mkN "ถนนบายพาท" | mkN "ทางบายพาท" | mkN "ถนนเลี่ยงเมือง" | mkN "ถนนเล็กๆ ที่ไม่ค่อยมีรถแล่นผ่าน" | mkN "ถนนลี้ภัย" | mkN "ถนนส่วนตัว" | mkN "ถนนสายเปลี่ยว" | mkN "การวิจัยที่ปิดบัง" | mkN "ความพยายามที่ปิดบัง" ; -- src=panlex
lin byword_N = mkN "สุภาษิต" | mkN "ภาษิต" | mkN "สุภาษิต" | mkN "คําพูดที่พูดกันบ่อย" | mkN "สุภาษิตหรือคําคมที่รู้จักกันดี" ; -- src=panlex
lin cab_N = mkN "รถม้า" | mkN "แท็กซี่" | mkN "รถแท็กซี่" | mkN "ห้องคนขับ" | mkN "ห้องโดยสาร" | mkN "รถม้า" | mkN "รถเช่า" | mkN "รถรับจ้าง" | mkN "รถแท็กซี่" | mkN "ห้องคนขับในรถ" ; -- src=panlex
lin cabal_N = mkN "แผนชั่วร้าย" | mkN "แผนก่อการร้าย" | mkN "กลุ่มคนที่รวมกลุ่มกันอย่างลับๆ เพื่อจุดประสงค์ทางการเมือง" ; -- src=panlex
lin cabala_N = mkN "คับบาล่าห์" | mkN "คําสอนที่เป็นความลับ" ; -- src=panlex
lin cabana_N = mkN "เต็นท์คาบานา" ; -- src=panlex
lin cabaret_N = mkN "ไนท์คลับ" | mkN "คาบาเร่ต์" | mkN "ฟลอร์โชว์" | mkN "การแสดงคาบาเร่ต์" | mkN "การแสดงฟลอร์โชว์" | mkN "ภัตตาคารขนาดใหญ่ที่มีดนตรีและการแสดง" ; -- src=panlex
lin cabbage_N = mkN "ตังค์" | mkN "ปัจจัย" | mkN "สตางค์" | mkN "กะหล่ำปลี" | mkN "สะตุ้งสตางค์" | mkN "ผักจําพวกกะหล่ําปลี" ; -- src=panlex
lin cabbageworm_N = mkN "หนอนผักกาด" ; -- src=panlex
lin cabby_N = mkN "คนขับแท็กซี่" | mkN "คนขับรถเท็กซี่" | mkN "คนขับรถแท็กซี่" ; -- src=panlex
lin cabin_N = mkN "เคบิน" | mkN "ห้องพักผู้โดยสาร" ; -- src=panlex
lin cabinet_N = mkN "ตู้" | mkN "ครม." | mkN "ตู้เก็บของ" | mkN "คณะรัฐมนตรี" | mkN "ตู้เสื้อผ้า" | mkN "ตู้โทรทัศน์" | mkN "ตู้" | mkN "ห้องเล็ก" | mkN "โทรทัศน์" | mkN "คณะรัฐมนตรี" | mkN "ตู้มีลิ้นชัก" | mkN "ชั้นหรือตู้วางของ" | mkN "เกี่ยวกับห้องส่วนตัว" | mkN "ตู้เฟอร์นิเจอร์ที่มีชั้นวางวิทยุ" ; -- src=panlex
lin cabinet_maker_N = mkN "คนทำเฟอร์นิเจอร์" | mkN "ช่างเฟอร์นิเจอร์" | mkN "ช่างทำเฟอร์นิเจอร์" | mkN "คนที่มีอาชีพทําเกี่ยวกับงานไม้" ; -- src=panlex
lin cabinetwork_N = mkN "ตู้" | mkN "ตู้ไม้" ; -- src=panlex
lin cable_N = mkN "สายส่ง" | mkN "โทรเลข" | mkN "ความยาว" | mkN "สายเคเบิล" | mkN "เคเบิลทีวี" | mkN "ระบบส่งสัญญาณ" | mkN "การแพร่ภาพทางเคเบิลทีวี" | mkN "โทรเลข" | mkN "สายเคเบิ้ล" | mkN "เชือกหรือเหล็กเส้นขนาดใหญ่" | mkN "ระบบโทรทัศน์ที่ส่งสัญญาณผ่านสายเคเบิ้ล" ; -- src=panlex
lin cable_V = mkV "โทรเลข" | mkV "ส่งโทรเลข" | mkV "ยึดด้วยสายเคเบิล" | mkV "ส่งโทรเลข" ; -- src=panlex
lin cable_V2 = mkV2 "โทรเลข" ; ---- | mkV "ส่งโทรเลข" | mkV "ยึดด้วยสายเคเบิล" | mkV "ส่งโทรเลข" ; -- src=panlex
lin cablegram_N = mkN "โทรเลข" ; -- src=panlex
lin cabman_N = mkN "คนขับแท็กซี่" | mkN "คนขับรถเท็กซี่" | mkN "คนขับรถแท็กซี่" ; -- src=panlex
lin cabochon_N = mkN "หลังเบี้ย" | mkN "หินมีค่าขัดเป็นวาวแต่ยังไม่ได้เจียระไน" ; -- src=panlex
lin caboodle_N = mkN "พวง" | mkN "กอง" | mkN "ก้อน" | mkN "โขลง" | mkN "กลุ่ม" | mkN "จํานวนทั้งหมด" ; -- src=panlex
lin caboose_N = mkN "ห้องครัวบนเรือโดยสาร" | mkN "ตู้รถไฟสินค้าคันสุดท้ายสําหรับพนักงานรถไฟ" ; -- src=panlex
lin cabotage_N = mkN "กาโบตาจ" | mkN "สิทธิการบิน" ; -- src=panlex
lin cabstand_N = mkN "จุดจอดแท็กซี่" | mkN "ที่จอดรถแท็กซี่สําหรับรอผู้โดยสาร" ; -- src=panlex
lin cacao_N = mkN "ต้นโกโก้" | mkN "ผลโกโก้" | mkN "ต้นโกโก้" | mkN "เมล็ดโกโก้" | mkN "เมล็ดของต้นโกโก้" | mkN "ต้นไม้ชนิดหนึ่งเมล็ดใช้ทําโกโก้หรือชอคโกแลต" ; -- src=panlex
lin cache_N = mkN "แคช" | mkN "ที่ซ่อน" | mkN "สถานที่เก็บซ่อนสิ่งของ" ; -- src=panlex
lin cachet_N = mkN "การเซ็นอนุมัติ" | mkN "ตราประทับจดหมาย" | mkN "ตราประทับไปรษณีย์" | mkN "ที่ปั๊มตราไปรษณีย์" | mkN "ตราประทับ" | mkN "สัญลักษณ์" | mkN "เกียรติคุณ" | mkN "คําขวัญที่พิมพ์บนซองหรือจดหมาย" | mkN "คุณสมบัติพิเศษที่ได้รับการชื่นชมและเป็นที่ยอมรับ" ; -- src=panlex
lin cachexia_N = mkN "โรคผอมแห้ง" ; -- src=panlex
lin cachou_N = mkN "แคชู" ; -- src=panlex
lin cacique_N = mkN "นกคาซิก" ; -- src=panlex
lin cackle_N = mkN "เสียงกระต๊าก" | mkN "เสียงจ้อกแจ้ก" ; -- src=panlex
lin cackle_V = mkV "ร้องกระต๊าก" | mkV "หัวเราะก๊าก" | mkV "คุยเสียงจ็อกแจ็ก" | mkV "หัวเราะเสียงดังแหลม" ; -- src=panlex
lin cackler_N = mkN "นกแบ็บเบลอร์" | mkN "แม่ไก่กระต๊าก" ; -- src=panlex
lin cacodemon_N = mkN "คาโคดีมอน" ; -- src=panlex
lin cacodyl_N = mkN "คาโคดิล" | mkN "หมู่คาโคดิล" ; -- src=panlex
lin cacophonous_A = mkA "ดังรบกวน" | mkA "ที่มีเสียงดังมาก" | mkA "ที่เป็นเสียงรบกวน" | mkA "มีเสียงแหบหรือห้าว" | mkA "ซึ่งออกเสียงไม่ประสานกัน" ; -- src=panlex
lin cacophony_N = mkN "การแผดเสียง" | mkN "เสียงดังสับสน" | mkN "เสียงร้องดังๆ" | mkN "เสียงแตรในพิธี" | mkN "เสียงแหบ" | mkN "เสียงห้าว" | mkN "เสียงที่ไม่ประสานกัน" ; -- src=panlex
lin cactus_N = mkN "แค็กตัส" | mkN "กระบองเพชร" | mkN "ตะบองเพชร" | mkN "พืชจําพวกหนึ่งไม่มีใบพบมากในแถบทะเลทราย" ; -- src=panlex
lin cacuminal_A = mkA "ออกเสียงโดยลิ้น" ; -- src=panlex
lin cad_N = mkN "คนเลว" | mkN "คนถ่อย" | mkN "อันธพาล" | mkN "คนไร้สกุลรุนชาติ" | mkN "ผู้ชายที่มีความประพฤติไม่ดี" ; -- src=panlex
lin cadaster_N = mkN "เจ้าหน้าที่สํานักงานที่ดิน" ; -- src=panlex
lin cadaver_N = mkN "ศพ" | mkN "ซากผี" | mkN "ซากศพ" | mkN "พระศพ" | mkN "ศพคนตาย" | mkN "พระบรมศพ" | mkN "ศพผู้เสียชีวิต" | mkN "ซากศพ" ; -- src=panlex
lin cadaverine_N = mkN "คาดาเวอรีน" ; -- src=panlex
lin cadaverous_A = mkA "ซีดเผือด" | mkA "ผอมเห็นซี่โครง" | mkA "เหลือแต่กระดูก" | mkA "ผอมเหลือแต่ซี่โครง" | mkA "ซีดผอมเหมือนไม่สบาย" ; -- src=panlex
lin caddie_N = mkN "แคดดี้" | mkN "คนรับใช้เรื่องเล็ก ๆ น้อย ๆ ทั่วไป" | mkN "ผู้รับจ้างแบกถุงไม้ตีกอล์ฟ" | mkN "ผู้ที่ถือถุงกอล์ฟให้ผู้เล่นกอล์ฟ" ; -- src=panlex
lin caddish_A = mkA "หยาบคาย" | mkA "ไม่สุภาพ" ; -- src=panlex
lin caddy_N = mkN "กระป๋องชา" | mkN "กล่องชา" | mkN "กล่องใส่ใบชา" | mkN "ผู้ที่ถือถุงกอล์ฟให้ผู้เล่นกอล์ฟ" ; -- src=panlex
lin cadence_N = mkN "จังหวะในฉันทลักษณ์" | mkN "จังหวะ" | mkN "ทํานองเสียงในการพูด" ; -- src=panlex
lin cadenza_N = mkN "จุดพักแสดงเม็ดพราย" | mkN "เสียงดนตรีที่แผ่วเบาก่อนจบ" | mkN "การแสดงเครื่องดนตรีหรือร้องเดี่ยวสั้นๆ" ; -- src=panlex
lin cadet_N = mkN "นักเรียนนายร้อย" | mkN "น้องชาย" | mkN "เด็กฝึกงาน" | mkN "นักเรียนทหาร" | mkN "นักเรียนโรงเรียนนายร้อย" ; -- src=panlex
lin cadge_V = mkV "ขอ" | mkV "เกาะ" | mkV "ขอ" ; -- src=panlex
lin cadge_V2 = mkV2 "ขอ" ; ---- | mkV "เกาะ" | mkV "ขอ" ; -- src=panlex
lin cadger_N = mkN "ขอทาน" | mkN "คนลักเล็กขโมยน้อย" ; -- src=panlex
lin cadmium_N = mkN "แคดเมียม" | mkN "ธาตุแคดเมียม" | mkN "เลขอะตอม 48" | mkN "แคดเมียม" | mkN "ชื่อธาตุชนิดหนึ่ง" ; -- src=panlex
lin cadre_N = mkN "หน่วยย่อย" | mkN "โครงงาน" | mkN "ฝ่ายบริหาร" | mkN "ขอบข่ายของงาน" | mkN "นายทหารฝ่ายเสนาธิการ" | mkN "กลุ่มคนที่ได้รับการฝึกเพื่อจุดประสงค์เฉพาะอย่าง" ; -- src=panlex
lin caesar_N = mkN "จักรพรรดิ" | mkN "ผู้เผด็จการ" | mkN "จูเลียสซีซาร์" | mkN "เจ้าหน้าที่พลเรือน" | mkN "ชื่อตําแหน่งของจักรพรรดิโรมัน" ; -- src=panlex
lin caesarian_A = mkA "เกี่ยวกับซีซาร์" ; -- src=panlex
lin caespitose_A = mkA "เป็นกอ" ; -- src=panlex
lin cafe_N = mkN "คาเฟ" | mkN "ร้านกาแฟ" | mkN "คอฟฟี่ชอป" ; -- src=panlex
lin cafeteria_N = mkN (thword "โรง" "อา" "หาร") ;
lin caff_N = mkN "ร้านกาแฟ" ; -- src=panlex
lin caffeine_N = mkN "คาเฟอีน" | mkN "สารคาเฟอีน" | mkN "คาเฟอีน" | mkN "สารชนิดหนึ่งพบในชาและกาแฟ" ; -- src=panlex
lin caffeinism_N = mkN "ภาวะพิษคาเฟอีน" | mkN "สภาวะมีคาเฟอีนมาเกินไปในร่างกาย" ; -- src=panlex
lin caftan_N = mkN "คาฟตาน" | mkN "ชุดแคฟแทน" ; -- src=panlex
lin cage_N = mkN "กรง" | mkN "กรงขัง" | mkN "ประตูฮอกกี้น้ำแข็ง" | mkN "กรง" ; -- src=panlex
lin cagey_A = mkA "ที่ไม่ต้องการให้ผู้อื่นรู้ข้อมูลบางอย่าง" ; -- src=panlex
lin cagily_Adv = mkAdv "อย่างรอบคอบ" | mkAdv "อย่างระแวดระวัง" ; -- src=panlex
lin cagoule_N = mkN "เสื้อกันลม" | mkN "เสื้อแจ๊คเกตมีหมวกคลุมหัวและสามารถกันลมและฝนได้" ; -- src=panlex
lin caiman_N = mkN "จระเข้เคแมน" ; -- src=panlex
lin cairn_N = mkN "สุนัขพันธุ์เคร์น" | mkN "สุนัขพันธุ์เคร์น เทอร์เรียร์" | mkN "กองหินที่ทําไว้เพื่อเป็นเครื่องหมาย" ; -- src=panlex
lin cairngorm_N = mkN "สโมกกี้ควอร์ต" ; -- src=panlex
lin caisson_N = mkN "รถลากปืนใหญ่" | mkN "หีบเครื่องกระสุน" | mkN "กระเบื้องประดับเพดาน" | mkN "หีบลม" | mkN "รังกระสุน" | mkN "หีบกระสุน" | mkN "รถใส่กระสุน" | mkN "กระบอกลอยอัดอากาศสําหรับยกเรือที่จม" | mkN "ห้องใต้น้ํามีอากาศสําหรับสร้างสะพาน" ; -- src=panlex
lin cajolery_N = mkN "การเจรจา" | mkN "การพูดจาหลอกล่อ" | mkN "การล่อใจ" | mkN "การล่อลวง" | mkN "การหลอกลวง" ; -- src=panlex
lin cake_N = mkN "ก้อน" | mkN "เค้ก" | mkN "แท่ง" | mkN "ขนมเค้ก" | mkN "พายชิ้นเล็กๆ" | mkN "เค้ก" | mkN "ส่วนแบ่ง" ; -- src=panlex
lin cake_V = mkV "ห่อหุ้ม" ; -- src=panlex
lin cake_V2 = mkV2 "ห่อหุ้ม" ; ---- ; -- src=panlex
lin cakewalk_N = mkN "ของกล้วยๆ" | mkN "เรื่องง่ายๆ" ; -- src=panlex
lin calaba_N = mkN "ต้นซานตามาเรียทรี" ; -- src=panlex
lin calabash_N = mkN "น้ำเต้า" | mkN "ต้นน้ำเต้า" | mkN "น้ำเต้าญี่ปุ่น" | mkN "พืชน้ําเต้า" | mkN "น้ําเต้าต้นน้ําเต้า" | mkN "พืชชนิดหนึ่งผลมีเปลือกแข็งหนาใช้เป็นภาชนะใส่น้ําได้" ; -- src=panlex
lin caladenia_N = mkN "คาลาดีเนีย" ; -- src=panlex
lin calamitous_A = mkA "เคราะห์ร้าย" | mkA "ที่เป็นหายนะ" | mkA "ที่โชคร้ายอย่างมาก" | mkA "เกี่ยวกับภัยวิบัติ" | mkA "ทําให้เกิดความหายนะ" ; -- src=panlex
lin calamity_N = mkN "กลียุค" | mkN "ความหายนะ" | mkN "เหตุการณ์เลวร้าย" | mkN "ความหายนะ" | mkN "ภัยพิบัติ" | mkN "เคราะห์ร้าย" | mkN "เหตุการณ์ที่เลวร้าย" ; -- src=panlex
lin calamus_N = mkN "คาลามัส" | mkN "ว่านน้ำ" | mkN "ก้านขนนก" ; -- src=panlex
lin calanthe_N = mkN "คาลันเท" ; -- src=panlex
lin calash_N = mkN "ประทุนรถม้า" ; -- src=panlex
lin calcareous_A = mkA "คล้ายหินปูน" | mkA "ประกอบด้วยแคลเซี่ยมคาร์บอเนต" ; -- src=panlex
lin calceolaria_N = mkN "คอลซีโอลาเรีย" ; -- src=panlex
lin calceus_N = mkN "รองเท้าแคลเซียส" ; -- src=panlex
lin calcicolous_A = mkA "ที่เติบโตในดินเป็นด่าง" ; -- src=panlex
lin calcification_N = mkN "การกลายเป็นหินปูน" | mkN "การไม่พัฒนา" | mkN "การกลายเป็นกระดูก" ; -- src=panlex
lin calcifugous_A = mkA "ที่เติบโตในดินเป็นกรด" ; -- src=panlex
lin calcify_V = mkV "แข็งตัว" | mkV "กลายเป็นหินปูน" | mkV "ทำให้เป็นปูนขาว" | mkV "เปลี่ยนเป็นปูนขาว" | mkV "้แข็งตัวโดยการเติมเกลือแคลเซียม" | mkV "ทําให้แข็งตัวโดยการเติมเกลือแคลเซียม" ; -- src=panlex
lin calcify_V2 = mkV2 "แข็งตัว" ; ---- | mkV "กลายเป็นหินปูน" | mkV "ทำให้เป็นปูนขาว" | mkV "เปลี่ยนเป็นปูนขาว" | mkV "้แข็งตัวโดยการเติมเกลือแคลเซียม" | mkV "ทําให้แข็งตัวโดยการเติมเกลือแคลเซียม" ; -- src=panlex
lin calcination_N = mkN "การเผาให้แตกตัว" ; -- src=panlex
lin calcine_V = mkV "แคลไซน์" ; -- src=panlex
lin calcine_V2 = mkV2 "แคลไซน์" ; ---- ; -- src=panlex
lin calcite_N = mkN "แคลไซต์" | mkN "แร่แคลไซต์" ; -- src=panlex
lin calcitonin_N = mkN "ไทโรคอลซิโตนิน" ; -- src=panlex
lin calcium_N = mkN "แคลเซียม" | mkN "ธาตุแคลเซียม" | mkN "เลขอะตอม 20" ; -- src=panlex
lin calculable_A = mkA "ไว้ใจได้" | mkA "ซึ่งคํานวณได้" | mkA "ที่สามารถคํานวณได้" | mkA "ที่สามารถคาดการณ์ได้" ; -- src=panlex
lin calculate_V = mkV "กะ" | mkV "คำนวณ" | mkV "คิดเลข" | mkV "ประมาณ" | mkV "พึ่งพา" | mkV "คาดคะเน" | mkV "คิดคำนวณ" | mkV "จัดโครงการ" | mkV "คํานวณ" | mkV "คาดการณ์ว่า" ; -- src=panlex
lin calculate_V2 = mkV2 "กะ" ; ---- | mkV "คำนวณ" | mkV "คิดเลข" | mkV "ประมาณ" | mkV "พึ่งพา" | mkV "คาดคะเน" | mkV "คิดคำนวณ" | mkV "จัดโครงการ" | mkV "คํานวณ" | mkV "คาดการณ์ว่า" ; -- src=panlex
lin calculate_VS = mmkVS "กะ" ; ---- | mkV "คำนวณ" | mkV "คิดเลข" | mkV "ประมาณ" | mkV "พึ่งพา" | mkV "คาดคะเน" | mkV "คิดคำนวณ" | mkV "จัดโครงการ" | mkV "คํานวณ" | mkV "คาดการณ์ว่า" ; -- src=panlex
lin calculation_N = mkN "การคำนวณ" | mkN "ความรอบคอบ" | mkN "การคิดคำนวณ" | mkN "การคิดพิจารณา" | mkN "การคํานวณ" | mkN "การคาดการณ์" | mkN "การประมาณการณ์" | mkN "ผลจากการคํานวณ" ; -- src=panlex
lin calculator_N = mkN "นักคำนวณ" | mkN "นักคิดเลข" | mkN "เครื่องคำนวณ" | mkN "เครื่องคิดเลข" | mkN "คนคํานวณ" | mkN "เครื่องคิดเลข" | mkN "เครื่องคํานวณ" ; -- src=panlex
lin calculous_A = mkA "เป็นหิน" | mkA "เป็นนิ่ว" | mkA "ที่เกี่ยวกับก้อนนิ่ว" | mkA "มีลักษณะเป็นก้อนแข็ง" ; -- src=panlex
lin calculus_N = mkN "หินปูน" | mkN "แคลคูลัส" | mkN "ก้อนหินปูน" | mkN "นิ่ว" | mkN "ก้อนนิ่ว" | mkN "แคลคูลัส" | mkN "แคลคิวลัส" ; -- src=panlex
lin caldera_N = mkN "แอ่งยุบปากปล่อง" ; -- src=panlex
lin caldron_N = mkN "คอลเดรน" | mkN "หม้อต้มขนาดใหญ่" ; -- src=panlex
lin calendar_N = mkN "ปฏิทิน" | mkN "ตารางปฏิทิน" | mkN "เวลาตามปฏิทิน" | mkN "ปฎิทิน" | mkN "ปฏิทิน" | mkN "กาลันเดอร์" | mkN "รายการนัดหมาย" | mkN "หนังสือปฏิทิน" | mkN "บันทึกประจําวัน" | mkN "รายการแสดงเวลานัด" ; -- src=panlex
lin calender_N = mkN "เครื่องรีด" | mkN "เครื่องที่ใช้สําหรับรีดผ้าหรือกระดาษ" ; -- src=panlex
lin calendula_N = mkN "คาเลนดูล่า" ; -- src=panlex
lin calf_N = mkN "น่อง" | mkN "ลูกวัว" | mkN "ลูกช้าง" | mkN "หนังลูกวัว" | mkN "ลูกวัว" | mkN "ลูกวัวลูกควาย" ; -- src=panlex
lin caliber_N = mkN "คุณภาพ" | mkN "ความกว้างของลำกล้องปืน" | mkN "เส้นผ่าศูนย์กลางลำกล้อง" | mkN "เส้นผ่าศูนย์กลางของปากลำกล้อง" | mkN "ความสามารถ" | mkN "ขนาดลํากล้องปืน" | mkN "ขนาดลํากล้องของปืน" | mkN "ขนาดเส้นผ่าศูนย์กลาง" | mkN "ขนาดของสติปัญญาความสามารถหรือความสําคัญ" ; -- src=panlex
lin calibration_N = mkN "การเทียบมาตรฐาน" ; -- src=panlex
lin calibre_N = mkN "คุณภาพ" | mkN "ความกว้างของลำกล้องปืน" | mkN "เส้นผ่าศูนย์กลางลำกล้อง" | mkN "เส้นผ่าศูนย์กลางของปากลำกล้อง" | mkN "ขนาดลํากล้องปืน" | mkN "ขนาดเส้นผ่าศูนย์กลาง" | mkN "ขนาดของสติปัญญาความสามารถหรือความสําคัญ" ; -- src=panlex
lin caliche_N = mkN "คาลิเช" ; -- src=panlex
lin calico_A = mkA "ที่มีหลากสี" | mkA "ที่มีหลายสี" ; -- src=panlex
lin calico_N = mkN "ผ้าดิบ" | mkN "ผ้าฝ้ายแบบหนามักมีสีขาวไม่มีลาย" ; -- src=panlex
lin calif_N = mkN "กาลิฟ" | mkN "กาหลิบ" ; -- src=panlex
lin californium_N = mkN "แคลิฟอร์เนียม" | mkN "ธาตุแคลิฟอร์เนียม" | mkN "เลขอะตอม 98" ; -- src=panlex
lin caliper_N = mkN "คาลิเปอร์" | mkN "เครื่องมือชนิดหนึ่งสําหรับวัดขนาดวัตถุ" ; -- src=panlex
lin caliph_N = mkN "กาลิฟ" | mkN "กาหลิบ" | mkN "กาหลีบ" | mkN "ผู้นําทางศาสนาของประเทศมุสลิม" | mkN "ผู้นําฝ่ายปกครองและศาสนาในประเทศอิสลาม" ; -- src=panlex
lin calisaya_N = mkN "ต้นคาลิซายา" ; -- src=panlex
lin calisthenics_N = mkN "การเพาะกาย" | mkN "การออกกําลังที่ตั้งใจให้ร่างกายแข็งแรงและได้สัดส่วน" ; -- src=panlex
lin calk_N = mkN "ปุ่มกันลื่น" ; -- src=panlex
lin call_N = mkN "การโทร" | mkN "การเรียก" | mkN "คำตัดสิน" | mkN "เสียงร้อง" | mkN "คอลออปชั่น" | mkN "การเรียกไพ่" | mkN "การโทรศัพท์" | mkN "เสียงนกร้อง" | mkN "การเรียกร้อง" | mkN "เสียงร้องตะโกน" | mkN "สัญญาณ" | mkN "การเรียก" | mkN "การมาเยี่ยม" | mkN "ความต้องการ" | mkN "การตะโกนเรียก" | mkN "การสนทนาทางโทรศัพท์" ; -- src=panlex
lin call_V = mkV "ทาย" | mkV "นัด" | mkV "โทร" | mkV "เห็น" | mkV "ตะโกน" | mkV "ทำนาย" | mkV "เรียก" | mkV "โทรหา" | mkV "เยี่ยม" | mkV "เลื่อน" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "ตั้งชื่อ" | mkV "ร้องลั่น" | mkV "เช็คชื่อ" | mkV "เรียกตัว" | mkV "เรียกไพ่" | mkV "โทรศัพท์" | mkV "บอกจังหวะ" | mkV "ร้องตะโกน" | mkV "ร้องเรียก" | mkV "สังหรณ์ใจ" | mkV "เรียกชื่อ" | mkV "เรียกร้อง" | mkV "ให้จังหวะ" | mkV "โทรศัพท์หา" | mkV "จอดเทียบท่า" | mkV "เรียกประชุม" | mkV "แจ้งให้ชำระ" | mkV "ทำเสียงเรียก" | mkV "เรียกให้ตื่น" | mkV "ประกาศผลการตัดสิน" | mkV "เรียกร้องความซื่อสัตย์" | mkV "เรียก" | mkV "เรียกว่า" | mkV "ร้องเรียก" | mkV "ตะโกนเรียก" | mkV "โทรศัพท์ไปหา" ; -- src=panlex
lin call_V2 = mkV2 "ทาย" ; ---- | mkV "นัด" | mkV "โทร" | mkV "เห็น" | mkV "ตะโกน" | mkV "ทำนาย" | mkV "เรียก" | mkV "โทรหา" | mkV "เยี่ยม" | mkV "เลื่อน" | mkV "พยากรณ์" | mkV "คาดการณ์" | mkV "ตั้งชื่อ" | mkV "ร้องลั่น" | mkV "เช็คชื่อ" | mkV "เรียกตัว" | mkV "เรียกไพ่" | mkV "โทรศัพท์" | mkV "บอกจังหวะ" | mkV "ร้องตะโกน" | mkV "ร้องเรียก" | mkV "สังหรณ์ใจ" | mkV "เรียกชื่อ" | mkV "เรียกร้อง" | mkV "ให้จังหวะ" | mkV "โทรศัพท์หา" | mkV "จอดเทียบท่า" | mkV "เรียกประชุม" | mkV "แจ้งให้ชำระ" | mkV "ทำเสียงเรียก" | mkV "เรียกให้ตื่น" | mkV "ประกาศผลการตัดสิน" | mkV "เรียกร้องความซื่อสัตย์" | mkV "เรียก" | mkV "เรียกว่า" | mkV "ร้องเรียก" | mkV "ตะโกนเรียก" | mkV "โทรศัพท์ไปหา" ; -- src=panlex
lin call_after_V2 = prepV2 OP_call_V OP_after_Prep ; -- guess-p-verb
lin call_around_V = advV OP_call_V OP_around_Adv ; -- guess-p-verb
lin call_back_V2 = mkV2 (advV OP_call_V OP_back_Adv ) ; -- guess-p-verb
lin call_for_V2V = variants {} ; -- guess-p-verb
lin call_forth_V2 = mkV2 (advV OP_call_V OP_forth_Adv ) ; -- guess-p-verb
lin call_in_V = advV OP_call_V OP_in_Adv ; -- guess-p-verb
lin call_in_V2 = prepV2 OP_call_V OP_in_Prep ; -- guess-p-verb
lin call_off_V2 = prepV2 OP_call_V OP_off_Prep ; -- guess-p-verb
lin call_on_V = advV OP_call_V OP_on_Adv ; -- guess-p-verb
lin call_on_V2 = prepV2 OP_call_V OP_on_Prep ; -- guess-p-verb
lin call_out_V2 = prepV2 OP_call_V OP_out_Prep ; -- guess-p-verb
lin call_over_V = advV OP_call_V OP_over_Adv ; -- guess-p-verb
lin call_round_V = advV OP_call_V OP_round_Adv ; -- guess-p-verb
lin call_up_V2 = prepV2 OP_call_V OP_up_Prep ; -- guess-p-verb
lin caller_A = mkA "สด" ; -- src=panlex
lin caller_N = mkN "แขก" | mkN "คนโทร" | mkN "ผู้โทร" | mkN "ผู้ร้อง" | mkN "คนโทรศัพท์" | mkN "ผู้โทรศัพท์" | mkN "ผู้เรียกประชุม" | mkN "ผู้ประกาศ" | mkN "สิ่งเรียก" | mkN "คนร้องเรียก" | mkN "ผู้โทรศัพท์" | mkN "ผู้ไปเยี่ยม" | mkN "ผู้เรียกประชุม" | mkN "สิ่งที่เรียกร้อง" ; -- src=panlex
lin calliandra_N = mkN "ต้นคัลเลียนดรา" ; -- src=panlex
lin calligrapher_N = mkN "ช่างเขียนอักษร" ; -- src=panlex
lin calligraphy_N = mkN "อักษรศิลป์" | mkN "อักษรวิจิตร" | mkN "ศิลปะการเขียนตัวอักษร" | mkN "ลายมือดี" | mkN "ลายมือสวย" | mkN "การคัดลายมือ" | mkN "ศิลปะการคัดลายมือ" | mkN "ศิลปในการคัดลายมือ" ; -- src=panlex
lin calling_N = mkN "อาชีพ" | mkN "อาชีพ" | mkN "สิ่งดลใจ" | mkN "การประชุม" | mkN "การเยี่ยม" | mkN "การร้องเรียก" | mkN "การเรียกร้อง" ; -- src=panlex
lin calliope_N = mkN "เครื่องดนตรีชุดนกหวีด" | mkN "เครื่องดนตรีชุดนกหวีด" ; -- src=panlex
lin calliopsis_N = mkN "ดอกตาเสือ" | mkN "ดอกไม้ไหว" ; -- src=panlex
lin callisthenics_N = mkN "การเพาะกาย" ; -- src=panlex
lin callosity_N = mkN "ผิวกร้าน" | mkN "ความตายด้าน" | mkN "ภาวะแข็งด้าน" | mkN "ความไม่รู้สึก" | mkN "ส่วนที่แข็งด้าน" | mkN "ผิวหนังที่ด้านหนา" ; -- src=panlex
lin callosotomy_N = mkN "การผ่าตัดเส้นประสาทเชื่อมสมอง" ; -- src=panlex
lin callous_A = mkA "ด้าน" | mkA "แข็ง" | mkA "ใจดํา" | mkA "ตายด้าน" | mkA "เมินเฉย" | mkA "ไม่สนใจ" | mkA "ไม่รู้สึก" | mkA "ไม่เห็นอกเห็นใจ" ; -- src=panlex
lin callow_A = mkA "ไก่อ่อน" | mkA "อ่อนหัด" | mkA "ยังบินไม่ได้" | mkA "ไร้ประสบการณ์" | mkA "ที่เด็กและขาดประสบการณ์" ; -- src=panlex
lin callus_N = mkN "ผิวกร้าน" | mkN "ผิวหนังที่ด้านหนา" ; -- src=panlex
lin calm_A = mkA "สงบ" | mkA "ที่คลื่นลมสงบ" | mkA "เรียบ" | mkA "ที่สงบเงียบ" | mkA "ที่มีอารมณ์สงบ" | mkA "ที่ไม่มีคลื่นลม" | mkA "ที่มีสถานการณ์สงบ" ; -- src=panlex
lin calm_N = mkN "ลมสงบ" | mkN "ความสุขุม" | mkN "ความใจเย็น" | mkN "ความสงบ" ; -- src=panlex
lin calm_V = mkV "กล่อม" | mkV "ทำให้สงบ" | mkV "ผ่อนคลาย" | mkV "วางยาสลบ" | mkV "ทําให้สงบ" ; -- src=panlex
lin calm_V2 = mkV2 "กล่อม" ; ---- | mkV "ทำให้สงบ" | mkV "ผ่อนคลาย" | mkV "วางยาสลบ" | mkV "ทําให้สงบ" ; -- src=panlex
lin calmness_N = mkN "ความสงบ" | mkN "ความสุขุม" | mkN "ความใจเย็น" ; -- src=panlex
lin calomel_N = mkN "เมอร์คิวโรอัสคลอไรด์" | mkN "ผงสีขาวที่ใช้เป็นยาถ่ายและยาฆ่าเชื้อรา" ; -- src=panlex
lin caloric_A = mkA "เกี่ยวกับแคลอรี่" | mkA "ที่เกี่ยวกับพลังงาน" | mkA "ที่เกี่ยวกับแคลอรี่" ; -- src=panlex
lin calorie_N = mkN "แคลอรี" | mkN "แคลอรี่" | mkN "หน่วยพลังงานความร้อน" ; -- src=panlex
lin calorific_A = mkA "ที่เกี่ยวกับความร้อน" ; -- src=panlex
lin calorimeter_N = mkN "แคลอริมิเตอร์" | mkN "เครื่องมือวัดปริมาณความร้อน" ; -- src=panlex
lin calorimetry_N = mkN "การวัดปริมาณความร้อน" ; -- src=panlex
lin calpac_N = mkN "หมวกคอลแพ็ค" ; -- src=panlex
lin caltrop_N = mkN "ต้นกระจับ" | mkN "ต้นโคกกระสุน" ; -- src=panlex
lin calumny_N = mkN "การป้ายสี" | mkN "การกล่าวหา" | mkN "การใส่ร้าย" | mkN "การใส่ร้ายป้ายสี" | mkN "การป้ายสี" | mkN "การใส่ร้าย" | mkN "การกล่าวร้าย" | mkN "การทําให้เสื่อมเสียชื่อเสียง" ; -- src=panlex
lin calvaria_N = mkN "ฝากะโหลก" ; -- src=panlex
lin calve_V = mkV "ตกลูก" | mkV "เลื่อนไหล" | mkV "ให้กําเนิดลูกวัว" ; -- src=panlex
lin calving_N = mkN "การออกลูกของโค" ; -- src=panlex
lin calyculus_N = mkN "ริ้วประดับ" | mkN "โครงสร้างรูปถ้วย" ; -- src=panlex
lin calypso_N = mkN "จังหวะคาลิพโซ" | mkN "นางฟ้าในนวนิยาย" ; -- src=panlex
lin calyptra_N = mkN "แคลิปทรา" ; -- src=panlex
lin calyx_N = mkN "ไตส่วนเคลิกซ์" | mkN "กลีบใบหุ้มดอก" ; -- src=panlex
lin cam_N = mkN "ลูกเบี้ยว" ; -- src=panlex
lin camaraderie_N = mkN "ความเป็นมิตร" | mkN "ความเป็นเพื่อน" | mkN "ความเป็นมิตร" | mkN "มิตรภาพที่ดี" | mkN "ความสัมพันธ์ที่ดี" ; -- src=panlex
lin camas_N = mkN "ต้นคาแมส" ; -- src=panlex
lin camber_N = mkN "ความลาด" | mkN "การลาดเอียง" | mkN "ลักษณะโค้งหลังเต่า" | mkN "ลักษณะที่โค้งเป็นหลังเต่าของถนน" ; -- src=panlex
lin camber_V = mkV "ทำให้โค้งขึ้น" ; -- src=panlex
lin camber_V2 = mkV2 "ทำให้โค้งขึ้น" ; ---- ; -- src=panlex
lin cambium_N = mkN "แคมเบียม" ; -- src=panlex
lin cambodian_N = mkN "ชาวเขมร" ; -- src=panlex
lin cambric_N = mkN "ผ้าลินินขาว" | mkN "ผ้าเนื้อบางสีขาวทําจากฝ้ายหรือลินิน" ; -- src=panlex
lin camcorder_N = mkN "แคมคอร์เดอร์" | mkN "กล้องบันทึกภาพ" | mkN "กล้องถ่ายวีดีโอที่สามารถพกพาไปได้" ; -- src=panlex
lin camel_N = mkN "อูฐ" | mkN "อูฐ" | mkN "ทุ่นกู้เรือ" ; -- src=panlex
lin camellia_N = mkN "ต้นคาเมลเลีย" | mkN "ไม้พุ่มชนิดหนึ่งมีดอกสีขาว สีแดงหรือสีชมพู" ; -- src=panlex
lin cameo_N = mkN "หินประดับที่ออกแบบให้นูนขึ้นจากพื้นสีเข้ม" ; -- src=panlex
lin camera_N = mkN "กล้อง" "ตัว" | {-pan-} mkN "กล้อง" | mkN "กล้องทีวี" | mkN "กล้องถ่ายรูป" | mkN "กล้องโทรทัศน์" | mkN "กล้องถ่ายภาพ" | mkN "กล้องถ่ายรูป" ; -- src=panlex
lin cameraman_N = mkN "ตากล้อง" | mkN "ช่างกล้องภาพยนตร์" | mkN "ช่างภาพ" | mkN "ช่างกล้อง" ; -- src=panlex
lin camion_N = mkN "เกวียน" | mkN "รถบรรทุก" ; -- src=panlex
lin camisole_N = mkN "เสื้อใน" | mkN "ชุดชั้นใน" | mkN "เสื้อชั้นใน" | mkN "เสื้อชั้นในผู้หญิง" | mkN "ชุดชั้นในท่อนบนของผู้หญิง" ; -- src=panlex
lin camlet_N = mkN "ผ้ากำมะหลิด" ; -- src=panlex
lin camomile_N = mkN "ต้นคาโมมายล์" | mkN "ต้นคา์โมมายล์" | mkN "พืชสมุนไพรชนิดหนึ่ง" ; -- src=panlex
lin camouflage_N = mkN "ผ้าพราง" | mkN "ภาพลวงตา" | mkN "การอำพราง" | mkN "การพรางตัว" | mkN "ผ้าลายทหาร" | mkN "ผ้าลายพราง" | mkN "การอําพราง" | mkN "การอําพรางตัวให้เข้ากับธรรมชาติเพื่อการหลบซ่อน" ; -- src=panlex
lin camp_N = mkN "ค่าย" | mkN "หมู่" | mkN "กลุ่ม" | mkN "แคมป์" | mkN "ค่ายพัก" | mkN "กลุ่มภายใน" | mkN "ค่ายกักกัน" | mkN "ค่ายพักแรม" | mkN "ค่ายฤดูร้อน" | mkN "ค่ายผู้ลี้ภัย" | mkN "กลุ่มผลประโยชน์ร่วม" | mkN "ค่าย" | mkN "ค่ายพัก" | mkN "ที่พักชั่วคราว" ; -- src=panlex
lin camp_V = mkV "ตั้งแคมป์" | mkV "พักอยู่ในเต็นท์" | mkV "พักอยู่ชั่วคราว" ; -- src=panlex
lin camp_V2 = mkV2 "ตั้งแคมป์" ; ---- | mkV "พักอยู่ในเต็นท์" | mkV "พักอยู่ชั่วคราว" ; -- src=panlex
lin campaign_N = mkN "การรณรงค์" | mkN "การเดินป่า" | mkN "การล่าสัตว์" | mkN "การรณรงค์หาเสียง" | mkN "การแข่งขันหาเสียง" | mkN "การสู้ศึกเลือกตั้ง" | mkN "การแข่งขันหาเสียงเลือกตั้ง" | mkN "การรณรงค์" | mkN "การหาเสียง" | mkN "การหาเสียงของพรรคการเมือง" | mkN "การกระทําการหรือวางแผนเพื่อให้บรรลุตามเป้าหมาย" ; -- src=panlex
lin campaign_V = mkV "รณรงค์" | mkV "ลงชิงตำแหน่ง" ; -- src=panlex
lin campaigner_N = mkN "นอมินี" | mkN "ผู้สมัคร" | mkN "ผู้สมัครรับเลือกตั้ง" | mkN "ผู้ลงสมัครรับเลือกตั้ง" ; -- src=panlex
lin campaigning_N = mkN "การรณรงค์หาเสียง" | mkN "การสมัครรับเลือก" | mkN "การรณรงค์ของผู้สมัคร" ; -- src=panlex
lin campanile_N = mkN "หอระฆัง" | mkN "หอระฆัง" ; -- src=panlex
lin camper_N = mkN "รถบ้าน" | mkN "ผู้ที่ตั้งแคมป์" ; -- src=panlex
lin camp_fire_N = mkN "แคมป์ไฟ" | mkN "ค่ายกองไฟกลางสนาม" | mkN "กองไฟที่ก่อขึ้นกลางแจ้งโดยผู้ตั้งแคมป์" ; -- src=panlex
lin camphor_N = mkN "การบูร" | mkN "สารสีขาวมีกลิ่นฉุน" ; -- src=panlex
lin camping_N = mkN "การพักแรม" ; -- src=panlex
lin campion_N = mkN "ต้นไซลีน" | mkN "ต้นแคมเปียน" ; -- src=panlex
lin campsite_N = mkN "ที่ตั้งแคมป์" | mkN "สถานที่ตั้งค่าย" | mkN "ที่สําหรับตั้งแคมป์" ; -- src=panlex
lin camp_stool_N = mkN "ม้านั่งพับได้" | mkN "เก้าอี้เล็กๆ พับได้สําหรับใช้สําหรับไปตั้งแคมป์" | mkN "ม้านั่งพับได้" ; -- src=panlex
lin campus_N = mkN "แคมปัส" | mkN "วิทยาเขต" | mkN "วิทยาลัย" | mkN "บริเวณมหาวิทยาลัยหรือโรงเรียน" | mkN "พื้นที่ที่เป็นที่ตั้งของมหาวิทยาลัย" ; -- src=panlex
lin camshaft_N = mkN "เพลาลูกเบี้ยว" ; -- src=panlex
lin camwood_N = mkN "ต้นแคมวู้ด" ; -- src=panlex
lin can_1_VV = {s = "ได้" ; typ = VVPost} ;
lin can_2_VV = {s = pen_s ; typ = VVPost} ;
lin can_N = mkN "ก้น" | mkN "ตูด" | mkN "ป๋อง" | mkN "สุขา" | mkN "ส้วม" | mkN "โถส้วม" | mkN "กระป๋อง" | mkN "ห้องน้ำ" | mkN "บั้นท้าย" | mkN "ห้องสุขา" | mkN "ห้องส้วม" | mkN "ทุ่นกระป๋อง" | mkN "ห้องพระบังคน" | mkN "กระป๋อง" | mkN "ปริมาณหนึ่งกระป๋อง" ; -- src=panlex
lin canadian_A = mkA "กับแคนาดา" ; -- src=panlex
lin canadian_N = mkN "กับแคนาดา" ; -- src=panlex
lin canal_N = mkN "คลอง" | mkN "ช่อง" | mkN "หลอด" | mkN "ลำคลอง" | mkN "คลอง" ; -- src=panlex
lin canaliculus_N = mkN "ท่อคานาลิคูลัส" ; -- src=panlex
lin canalization_N = mkN "การขุดคลอง" ; -- src=panlex
lin canape_N = mkN "คานาเป้" | mkN "ขนมปังหรือขนมชิ้นบางทาเนยและอื่น ๆ" ; -- src=panlex
lin canard_N = mkN "ข่าวโคมลอย" | mkN "ข่าวเท็จ" | mkN "รายงานเท็จ" | mkN "เรื่องเท็จ" ; -- src=panlex
lin canary_A = mkA "เหลืองคานารี" ; -- src=panlex
lin canary_N = mkN "นักร้องหญิง" | mkN "สีเหลืองสดใส" | mkN "ผู้แจ้งเบาะแส" | mkN "สีเหลืองคานารี" | mkN "นกคีรีบูนสีเหลืองอ่อน" | mkN "นกขมิ้น" | mkN "นกคีรีบูน" | mkN "สีเหลืองอ่อน" | mkN "สีเหลืองสว่าง" ; -- src=panlex
lin canavanine_N = mkN "คานาวานีน" | mkN "กรดอะมิโนคานาวานีน" ; -- src=panlex
lin cancan_N = mkN "ระบำแคนแคน" | mkN "การเต้นระบําเตะขาขึ้นสูง" | mkN "การเต้นรําที่ผู้หญิงยืนเรียงหน้ากระดานและเตะเท้าสูง" ; -- src=panlex
lin cancel_V = mkV "งด" | mkV "ลบ" | mkV "ดีลีต" | mkV "ยกเลิก" | mkV "แคนเซิล" | mkV "ประกาศยกเลิก" | mkV "ยกเลิก" | mkV "ลบทิ้ง" | mkV "ตัดทิ้ง" ; -- src=panlex
lin cancel_V2 = mkV2 "งด" ; ---- | mkV "ลบ" | mkV "ดีลีต" | mkV "ยกเลิก" | mkV "แคนเซิล" | mkV "ประกาศยกเลิก" | mkV "ยกเลิก" | mkV "ลบทิ้ง" | mkV "ตัดทิ้ง" ; -- src=panlex
lin cancellate_A = mkA "พรุน" | mkA "เป็นร่างแห" | mkA "คล้ายฟองน้ํา" ; -- src=panlex
lin cancellation_N = mkN "การยกเลิก" | mkN "การขีดฆ่า" | mkN "การยกเลิก" | mkN "สิ่งที่ถูกยกเลิก" ; -- src=panlex
lin cancer_N = mkN "มะเร็ง" | mkN "โรคมะเร็ง" | mkN "มะเร็ง" | mkN "ความหายนะ" | mkN "เนื้อร้าย" | mkN "โรคมะเร็ง" | mkN "ชื่อกลุ่มดาวร" | mkN "เส้นที่ขนานกับเส้นศูนย์สูตร" ; -- src=panlex
lin cancerous_A = mkA "ของมะเร็ง" | mkA "เป็นมะเร็ง" | mkA "เกี่ยวกับมะเร็ง" ; -- src=panlex
lin cancerweed_N = mkN "ต้นแคนเซอร์วี้ด" ; -- src=panlex
lin cancroid_A = mkA "คล้ายมะเร็ง" ; -- src=panlex
lin candelabrum_N = mkN "เชิงเทียนใหญ่" | mkN "เชิงเทียนหลายกิ่ง" | mkN "เชิงเทียนที่มีแขนหลายอันสําหรับใส่เทียน" ; -- src=panlex
lin candelilla_N = mkN "ต้นแคนเดลิลลา" | mkN "ต้นแคนเดอเลีย" ; -- src=panlex
lin candid_A = mkA "ใส" | mkA "ขาว" | mkA "ซื่อตรง" | mkA "เปิดเผย" | mkA "เป็นธรรม" | mkA "ซื่อสัตย์" | mkA "ตรงไปตรงมา" | mkA "ปราศจากอคติ" ; -- src=panlex
lin candidacy_N = mkN "การรณรงค์หาเสียง" | mkN "การสมัครรับเลือก" | mkN "การรณรงค์ของผู้สมัคร" ; -- src=panlex
lin candidateFem_N = variants {} ; ---- sense to be split
lin candidateMasc_N = variants {} ; ---- sense to be split
lin candidature_N = mkN "การรณรงค์หาเสียง" | mkN "การสมัครรับเลือก" | mkN "การรณรงค์ของผู้สมัคร" ; -- src=panlex
lin candidiasis_N = mkN "โรคราแคนดิดา" ; -- src=panlex
lin candle_N = mkN "เทียน" | mkN "แคนเดลา" | mkN "กำลังแรงเทียน" | mkN "เทียน" ; -- src=panlex
lin candlelight_N = mkN "แสงเทียน" | mkN "สายัณห์" | mkN "แสงเทียน" | mkN "แสงสว่างจากเทียนไข" ; -- src=panlex
lin candlenut_N = mkN "แคนเดิลนัท" | mkN "ต้นแคนเดิลนัต" ; -- src=panlex
lin candlepin_N = mkN "พินเทียน" ; -- src=panlex
lin candle_power_N = mkN "แรงเทียน" | mkN "ความเข้มของแสง" | mkN "ระดับความเข้มของแสง" | mkN "กําลังสว่างของแสงเทียน" ; -- src=panlex
lin candlesnuffer_N = mkN "ที่ดับเทียน" ; -- src=panlex
lin candlestick_N = mkN "เชิงเทียน" | mkN "เชิงเทียน" ; -- src=panlex
lin candlewick_N = mkN "ไส้เทียน" | mkN "ไส้เทียน" ; -- src=panlex
lin candlewood_N = mkN "ต้นแคนเดิลวู้ด" ; -- src=panlex
lin candor_N = mkN "ความยุติธรรม" | mkN "ความตรงไปตรงมา" | mkN "สีขาว" | mkN "ความใจดี" | mkN "ภาวะเปิดเผย" | mkN "ความยุติธรรม" | mkN "ความบริสุทธิ์" | mkN "ความตรงไปตรงมา" | mkN "ภาวะตรงไปตรงมา" ; -- src=panlex
lin candour_N = mkN "ความยุติธรรม" | mkN "ความตรงไปตรงมา" | mkN "สีขาว" | mkN "ความใจดี" | mkN "ภาวะเปิดเผย" | mkN "ความยุติธรรม" | mkN "ความบริสุทธิ์" | mkN "ความตรงไปตรงมา" | mkN "ภาวะตรงไปตรงมา" ; -- src=panlex
lin candy_N = mkN "แคนดี้" | mkN "ลูกกวาด" ; -- src=panlex
lin candy_V = mkV "เคลือบน้ำตาล" ; -- src=panlex
lin candy_V2 = mkV2 "เคลือบน้ำตาล" ; ---- ; -- src=panlex
lin candytuft_N = mkN "ต้นแคนดี้ทัฟท์" ; -- src=panlex
lin cane_N = mkN "ไม้" | mkN "ไม้เท้า" | mkN "ธารพระกร" | mkN "ไม้เรียว" | mkN "ไม้ไผ่" | mkN "ไม้เท้า" | mkN "ไม้เรียว" ; -- src=panlex
lin canella_N = mkN "เปลือกคาเนลลา" ; -- src=panlex
lin canfield_N = mkN "แคนฟีลด์" ; -- src=panlex
lin cangue_N = mkN "ขื่อคาที่สวมคอนักโทษ" ; -- src=panlex
lin canine_A = mkA "เขี้ยว" | mkA "ฟันสุนัข" | mkA "ที่เกี่ยวกับสุนัข" ; -- src=panlex
lin canine_N = mkN "สุนัข" | mkN "เขี้ยว" | mkN "พระทาฒะ" | mkN "ฟันเขี้ยว" | mkN "สุนัข" | mkN "เขี้ยว" ; -- src=panlex
lin canistel_N = mkN "ผลท้อ" | mkN "ลูกท้อ" | mkN "ต้นแคนนิสเทล" ; -- src=panlex
lin canister_N = mkN "กระป๋อง" | mkN "กล่อง" | mkN "กระป๋องสเปรย์" | mkN "กล่องบรรจุอาหาร" ; -- src=panlex
lin canker_N = mkN "โรคแคงเกอร์" | mkN "โรคปากนกกระจอก" | mkN "สัตว์ร้าย" ; -- src=panlex
lin cankerworm_N = mkN "แคงเกอร์วอร์ม" ; -- src=panlex
lin cannabin_N = mkN "แคนนาบิสเรซิน" ; -- src=panlex
lin cannabis_N = mkN "กัญชา" | mkN "มาลีฮวนน่า" | mkN "ต้นแคนนาบิส" | mkN "กัญชา" ; -- src=panlex
lin cannelloni_N = mkN "กันเนลโลนี" ; -- src=panlex
lin cannery_N = mkN "โรงงานอาหารกระป๋อง" | mkN "โรงงานผลิตอาหารกระป๋อง" | mkN "คุก" | mkN "ที่คุมขัง" | mkN "โรงงานอัดกระป๋อง" | mkN "โรงงานเครื่องกระป๋อง" | mkN "โรงงานบรรจุอาหารกระป๋อง" ; -- src=panlex
lin cannibal_N = mkN "มนุษย์กินคน" | mkN "มนุษย์กินคน" | mkN "คนกินเนื้อคน" | mkN "ผู้ที่กินเนื้อคนสดๆ" | mkN "สัตว์ที่กินสัตว์จําพวกเดียวกัน" ; -- src=panlex
lin cannibalism_N = mkN "การกินเนื้อพวกเดียวกัน" ; -- src=panlex
lin cannikin_N = mkN "ถังไม้" | mkN "กระป๋องเล็ก" ; -- src=panlex
lin cannon_1_N = mkN "แคนนอน" | mkN "ปืนใหญ่" | mkN "ปืนรถถัง" | mkN "ปืนแคนนอน" | mkN "ปืนบนรถถัง" ; -- src=panlex
lin cannon_2_N = mkN "แคนนอน" | mkN "ปืนใหญ่" | mkN "ปืนรถถัง" | mkN "ปืนแคนนอน" | mkN "ปืนบนรถถัง" ; -- src=panlex
lin cannonade_N = mkN "การระดมยิงปืนใหญ่" | mkN "การยิงต่อเนื่องของปืนใหญ่" ; -- src=panlex
lin cannonball_N = mkN "กระสุนปืนใหญ่" | mkN "ลูกกระสุนเหล็กขนาดใหญ่" ; -- src=panlex
lin cannula_N = mkN "สายยาง" | mkN "ท่อกลวงสําหรับสอดเข้าไปในโพรงร่างกาย" ; -- src=panlex
lin cannulation_N = mkN "การสอดสายยาง" ; -- src=panlex
lin canny_A = mkA "ฉลาด" | mkA "สบาย" | mkA "น่ารัก" | mkA "สวยงาม" | mkA "ประหยัด" | mkA "อ่อนโยน" | mkA "มัธยัสถ์" | mkA "สงบเงียบ" | mkA "หลักแหลม" | mkA "คล่องแคล่ว" | mkA "ระมัดระวัง" | mkA "มีไหวพริบดี" | mkA "ฉลาดหลักแหลม" ; -- src=panlex
lin canoe_N = mkN "เรือแคนู" | mkN "แคนู" | mkN "เรือชนิดหนึ่งทรงเรียวแหลม" ; -- src=panlex
lin canoeist_N = mkN "คนพายเรือแคนู" ; -- src=panlex
lin canon_N = variants {} ; ---- sense to be split
lin canonic_A = mkA "แท้จริง" | mkA "เป็นที่ยอมรับ" | mkA "ซึ่งเป็นที่ยอมรับ" | mkA "เกี่ยวกับวินัยศาสนา" | mkA "ที่เกี่ยวกับหลักทางศาสนา" | mkA "เกี่ยวกับแบบที่ง่ายที่สุดหรือได้มาตรฐาน" ; -- src=panlex
lin canonical_A = mkA "แท้จริง" | mkA "เป็นที่ยอมรับ" | mkA "ซึ่งเป็นที่ยอมรับ" | mkA "เกี่ยวกับวินัยศาสนา" | mkA "ที่เกี่ยวกับหลักทางศาสนา" | mkA "เกี่ยวกับแบบที่ง่ายที่สุดหรือได้มาตรฐาน" ; -- src=panlex
lin canonist_N = mkN "นักกฎหมายของพระศาสนจักร" ; -- src=panlex
lin canopy_N = mkN "พิดาน" | mkN "คาโนปี" | mkN "ท้องฟ้า" | mkN "สิ่งที่ใช้คลุมเพื่อปกป้องสิ่งอื่น" ; -- src=panlex
lin cant_N = mkN "ความลาด" | mkN "ภาษาแสลง" | mkN "มุมเอียง" | mkN "การลาดเอียง" | mkN "คำพูดติดปาก" | mkN "คำพูดหรูหรา" | mkN "ภาษาเฉพาะกลุ่ม" | mkN "ภาษาเฉพาะวงการ" | mkN "ศัพท์เฉพาะกลุ่ม" | mkN "มือถือสากปากถือศีล" | mkN "คําพูดเท็จ" | mkN "ข้อความเท็จ" | mkN "พูดเป็นเพลง" | mkN "ภาษาวิชาชีพ" | mkN "ความลาดเอียง" | mkN "การพูดเป็นเพลง" | mkN "คําพูดปากหวานก้นเปรี้ยว" | mkN "ถ้อยคําพิเศษที่ใช้เฉพาะในหมู่ชนหนึ่ง ๆ" ; -- src=panlex
lin cant_V = mkV "เอียง" | mkV "เอียงกะเท่เร่" | mkV "เอียง" ; -- src=panlex
lin cant_V2 = mkV2 "เอียง" ; ---- | mkV "เอียงกะเท่เร่" | mkV "เอียง" ; -- src=panlex
lin cantala_N = mkN "ต้นแคนตาลา" ; -- src=panlex
lin cantaloupe_N = mkN "แคนตาลูป" | mkN "ผลแคนตาลูป" | mkN "ต้นแคนตาลูป" | mkN "ลูกแคนตาลูป" | mkN "แคนตาลูป" | mkN "ผลไม้ชนิดหนึ่งมีเนื้อสีส้ม" ; -- src=panlex
lin cantankerous_A = mkA "ขี้บ่น" | mkA "ชอบทะเลาะ" | mkA "อารมณ์ร้าย" | mkA "เจ้าอารมณ์" | mkA "ขี้หงุดหงิดและเอาใจยาก" ; -- src=panlex
lin cantata_N = mkN "คันตาตา" | mkN "การร้องประสานเสียง" | mkN "การเล่นดนตรีและร้องเพลงที่มีเนื้อหาทางศาสนา" ; -- src=panlex
lin canteen_N = mkN "โรงอาหาร" | mkN "กระติกน้ำทหาร" | mkN "ห้องสันทนาการ" | mkN "ร้านค้าในโรงอาหาร" | mkN "โรงอาหาร" | mkN "กระติกน้ํา" | mkN "กล่องหีบใส่มีดช้อนซ่อมและอื่น ๆ" | mkN "ร้านอาหารในค่ายทหารหรือโรงเรียน" ; -- src=panlex
lin canter_N = mkN "การขี่ม้ากึ่งวิ่ง" ; -- src=panlex
lin canter_V = mkV "วิ่งเหยาะๆ" ; -- src=panlex
lin canter_V2 = mkV2 "วิ่งเหยาะๆ" ; ---- ; -- src=panlex
lin canthus_N = mkN "แคนทัส" ; -- src=panlex
lin canticle_N = mkN "เพลงทางศาสนาสั้นๆ เนื้อร้องนํามาจากคัมภีร์ไบเบิ้ล" ; -- src=panlex
lin cantilever_N = mkN "คานยื่น" ; -- src=panlex
lin cantle_N = mkN "พนักพิงอานม้า" ; -- src=panlex
lin canto_N = mkN "บทสำคัญ" | mkN "ตอนหนึ่งของบทกวี" | mkN "ส่วนที่สําคัญของโคลง" ; -- src=panlex
lin canton_N = mkN "ตำบล" ; -- src=panlex
lin cantonment_N = mkN "ค่าย" | mkN "ค่ายพัก" | mkN "ค่ายทหารชั่วคราว" ; -- src=panlex
lin cantor_N = mkN "นักร้องนำ" | mkN "นักร้องนำในโบสถ์" | mkN "ผู้นำกลุ่มนักร้องประสานเสียง" | mkN "ผู้ที่เป็นนักร้องนําในโบสถ์ยิว" ; -- src=panlex
lin canvas_N = mkN "ฉาก" | mkN "เต็นท์" | mkN "ใบเรือ" | mkN "ผืนผ้าใบ" | mkN "ผ้าใบเรือ" | mkN "ภาพบนผ้าใบ" | mkN "กระโจมผ้าใบ" | mkN "เต้นท์แคนวาส" | mkN "เส้นใยแคนวาส" | mkN "เต้นท์ผ้าแคนวาส" | mkN "ภาพสีน้ำมันบนผ้าใบ" | mkN "ผ้าใบ" | mkN "เต๊นท์" | mkN "ใบเรือ" | mkN "ผ้าใบของเรือ" | mkN "ภาพเขียนน้ํามันบนผ้าใบ" | mkN "ผ้าที่มีลักษณะหนาและหยาบ" ; -- src=panlex
lin canvasback_N = mkN "เป็ดแคนแวสแบ็ก" ; -- src=panlex
lin canvass_N = mkN "ฉาก" | mkN "เต็นท์" | mkN "ใบเรือ" | mkN "ผืนผ้าใบ" | mkN "ผ้าใบเรือ" | mkN "ภาพบนผ้าใบ" | mkN "กระโจมผ้าใบ" | mkN "เต้นท์แคนวาส" | mkN "เส้นใยแคนวาส" | mkN "เต้นท์ผ้าแคนวาส" | mkN "การสำรวจความเห็น" | mkN "การสำรวจประชามติ" | mkN "ภาพสีน้ำมันบนผ้าใบ" | mkN "การสํารวจความคิดเห็น" ; -- src=panlex
lin canvass_V = mkV "ทำโพล" | mkV "หาอาหาร" | mkV "หาเสียง" | mkV "วิเคราะห์" | mkV "สำรวจความคิดเห็น" | mkV "ตรวจสอบอย่างละเอียด" | mkV "เดินทางไปเพื่อถามผู้คนเกี่ยวกับบางสิ่งบางอย่าง" ; -- src=panlex
lin canvass_V2 = mkV2 "ทำโพล" ; ---- | mkV "หาอาหาร" | mkV "หาเสียง" | mkV "วิเคราะห์" | mkV "สำรวจความคิดเห็น" | mkV "ตรวจสอบอย่างละเอียด" | mkV "เดินทางไปเพื่อถามผู้คนเกี่ยวกับบางสิ่งบางอย่าง" ; -- src=panlex
lin canvasser_N = mkN "คนนับคะแนนเลือกตั้ง" ; -- src=panlex
lin canyon_N = mkN "หุบเขา" | mkN "แคนยอน" | mkN "หุบผาชัน" | mkN "หุบเขาลึก" | mkN "หุบเขาลึก" ; -- src=panlex
lin cap_1_N = mkN "หมวก" | {-pan-} mkN "ฝา" | mkN "จุก" | mkN "แก็ป" | mkN "ฝาจุก" | mkN "ส่วนบน" | mkN "ครอบฟัน" | mkN "หมวกเห็ด" | mkN "หมวกแก็ป" | mkN "ขีดสูงสุด" | mkN "ชนวนระเบิด" | mkN "เชื้อระเบิด" | mkN "เพดานสูงสุด" | mkN "มาลา" | mkN "แก๊บ" | mkN "ฝาครอบ" | mkN "อักษรตัวใหญ่" | mkN "หมวกที่มีกระบังหน้า" ; -- src=panlex
lin cap_2_N = mkN "หมวก" | {-pan-} mkN "ฝา" | mkN "จุก" | mkN "แก็ป" | mkN "ฝาจุก" | mkN "ส่วนบน" | mkN "ครอบฟัน" | mkN "หมวกเห็ด" | mkN "หมวกแก็ป" | mkN "ขีดสูงสุด" | mkN "ชนวนระเบิด" | mkN "เชื้อระเบิด" | mkN "เพดานสูงสุด" | mkN "มาลา" | mkN "แก๊บ" | mkN "ฝาครอบ" | mkN "อักษรตัวใหญ่" | mkN "หมวกที่มีกระบังหน้า" ; -- src=panlex
lin capability_N = mkN "ความสามารถ" | mkN "สมรรถนะ" | mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "ประสิทธิภาพ" | mkN "ปริมาณบรรจุ" ; -- src=panlex
lin capable_of_A2 = variants {} ;
lin capacious_A = mkA "จุมาก" | mkA "ใหญ่มาก" | mkA "กว้างขวาง" | mkA "มีเนื้อที่มาก" | mkA "ที่สามารถบรรจุได้มาก" ; -- src=panlex
lin capaciousness_N = mkN "ความกว้าง" | mkN "ความรอบรู้กว้างขวาง" ; -- src=panlex
lin capacitance_N = mkN "กำลังไฟ" | mkN "ตัวเก็บไฟ" | mkN "คาปาซิเตอร์" | mkN "ความจุำไฟฟ้า" | mkN "คอนเด็นเซอร์" | mkN "ปริมาณความจุไฟฟ้า" | mkN "ความสามารถในการประจุกระแสไฟฟ้า" ; -- src=panlex
lin capacitor_N = mkN "ตัวเก็บไฟ" | mkN "คาปาซิเตอร์" | mkN "คอนเด็นเซอร์" | mkN "อุปกรณ์ชนิดหนึ่งใช้ในการเก็บสะสมไฟชั่วคราว" ; -- src=panlex
lin capacity_N = mkN "ความจุ" | mkN "คอแข็ง" | mkN "กำลังไฟ" | mkN "สติปัญญา" | mkN "ความสามารถ" | mkN "ความจุำไฟฟ้า" | mkN "ปริมาณความจุไฟฟ้า" | mkN "ความสามารถทางสติปัญญา" | mkN "ความจุ" | mkN "ปริมาณ" | mkN "สติปัญญา" | mkN "สมรรถภาพ" | mkN "ความสามารถ" | mkN "รับเต็มที่" | mkN "ประสิทธิภาพ" | mkN "การปฎิบัติหน้าที่" | mkN "ความสามารถที่จะรับ" | mkN "ปริมาณสูงสุดที่จะรับได้" | mkN "ความสามารถทางร่างกายหรือจิตใจ" ; -- src=panlex
lin caparison_N = mkN "เครื่องประดับม้า" | mkN "เครื่องแต่งกายสําหรับม้าสงครามในสมัยก่อน" ; -- src=panlex
lin cape_N = mkN "แหลม" | mkN "เสื้อคลุม" | mkN "แหลม" | mkN "ผ้าคลุมไหล่" | mkN "เสื้อคลุมไม่มีแขน" | mkN "ส่วนของผืนดินที่ยื่นเข้าไปในน้ํา" ; -- src=panlex
lin capelin_N = mkN "ปลาเคปลิน" ; -- src=panlex
lin caper_N = mkN "ต้นคาเปอร์" | mkN "การกระโดดกระต่ายขาเดียว" | mkN "การกระโดดอย่างสนุกสนาน" ; -- src=panlex
lin caper_V = mkV "กระโดดไปรอบๆ อย่างสนุกสนาน" ; -- src=panlex
lin capful_N = mkN "แก๊ป" | mkN "ปริมาณเต็มถ้วย" ; -- src=panlex
lin capillarity_N = mkN "การซึมตามรูเล็ก" ; -- src=panlex
lin capillary_A = mkA "ที่เหมือนเส้นผม" ; -- src=panlex
lin capillary_N = mkN "หลอดรูเล็ก" | mkN "หลอดเลือดฝอย" | mkN "เส้นเลือดฝอย" | mkN "เส้นฝอย" | mkN "เส้นโลหิตฝอย" ; -- src=panlex
lin capital_1_N = variants {} ;
lin capital_2_N = variants {} ;
lin capital_3_N = variants {} ;
lin capital_A = mkA "ดีเยี่ยม" | mkA "ที่เป็นหลัก" | mkA "ที่เป็นส่วนสําคัญ" ; -- src=panlex
lin capitalism_N = mkN "ทุนนิยม" | mkN "ระบบทุนนิยม" | mkN "ระบบนายทุน" | mkN "ระบบทุนนิยม" ; -- src=panlex
lin capitalist_N = mkN "นายทุน" | mkN "พวกทุนนิยม" | mkN "นายทุนหัวอนุรักษ์" | mkN "นายทุน" | mkN "ผู้ลงทุน" | mkN "คนร่ํารวย" | mkN "นักทุนนิยม" | mkN "เศรษฐีที่ลงทุนในกิจการ" ; -- src=panlex
lin capitalistic_A = mkA "เกี่ยวกับทุนหรือนายทุนหรือระบบทุนนิยม" ; -- src=panlex
lin capitalization_N = mkN "การประเมินมูลค่า" | mkN "การเขียนพิมพ์ใหญ่" | mkN "การขายทรัพย์สมบัติ" | mkN "ใช้ให้เกิดประโยชน์" | mkN "การเขียนตัวพิมพ์ใหญ่" | mkN "การเขียนอักษรตัวใหญ่" | mkN "การเขียนอักษรพิมพ์ใหญ่" ; -- src=panlex
lin capitalize_V = mkV "ลงทุน" | mkV "คิดจากรายจ่าย" | mkV "ได้ผลประโยชน์" | mkV "เปลี่ยนเป็นทุน" | mkV "คิดรายได้ปัจจุบัน" | mkV "เขียนตัวพิมพ์ใหญ่" | mkV "ได้ผลประโยชน์" | mkV "ใช้อักษรตัวพิมพ์ใหญ่" ; -- src=panlex
lin capitalize_V2 = mkV2 "ลงทุน" ; ---- | mkV "คิดจากรายจ่าย" | mkV "ได้ผลประโยชน์" | mkV "เปลี่ยนเป็นทุน" | mkV "คิดรายได้ปัจจุบัน" | mkV "เขียนตัวพิมพ์ใหญ่" | mkV "ได้ผลประโยชน์" | mkV "ใช้อักษรตัวพิมพ์ใหญ่" ; -- src=panlex
lin capitate_A = mkA "มีหัวกลม" ; -- src=panlex
lin capitation_N = mkN "ภาษีรายหัว" | mkN "ภาษีรายบุคคล" | mkN "ภาษีรายหัว" | mkN "ภาษีรายบุคคล" | mkN "ค่าธรรมเนียมต่อคน" ; -- src=panlex
lin capitol_N = mkN "อาคารสภานิติบัญญัติ" | mkN "ศาลากลาง" | mkN "อาคารหน่วยงานของรัฐ" | mkN "อาคารนิติบัญญัติของรัฐ" | mkN "อาคารรัฐสภาของสหรัฐอเมริกา" ; -- src=panlex
lin capitular_A = mkA "มีลักษณะของหัว" | mkA "เกี่ยวกับคณะบาทหลวง" ; -- src=panlex
lin capitulate_V = mkV "ยอมรับเงื่อนไข" | mkV "ยอมทําตาม" ; -- src=panlex
lin capitulate_V2 = mkV2 "ยอมรับเงื่อนไข" ; ---- | mkV "ยอมทําตาม" ; -- src=panlex
lin capitulation_N = mkN "การยอม" | mkN "การยอมแพ้" | mkN "บทสรุป" | mkN "การยอมแพ้" | mkN "การยอมจํานน" | mkN "การยอมทําตาม" ; -- src=panlex
lin capitulum_N = mkN "ฝัก" | mkN "รวง" | mkN "ยอดไม้" | mkN "ช่อกระจุกแน่น" | mkN "ยอดดอก" ; -- src=panlex
lin capo_N = mkN "คาโป" | mkN "คาโป้" | mkN "หัวหน้ากลุ่มมาเฟีย" | mkN "ที่บีบตรึงสายกีตาร์" | mkN "ไม้ขวางสายกีตาร์ที่ทําให้เสียงสูงขึ้น" ; -- src=panlex
lin capon_N = mkN "ไก่ตอน" | mkN "เนื้อไก่ตอน" | mkN "ไก่ตอน" ; -- src=panlex
lin capote_N = mkN "เสื้อคลุมมีหมวก" | mkN "ประทุนรถ" | mkN "เสื้อคลุมยาวที่มีหมวกคลุมติดอยู่" ; -- src=panlex
lin cappuccino_N = mkN "คาปูชิโน" | mkN "กาแฟคาปูชิโน" ; -- src=panlex
lin caprice_N = mkN "การเปลี่ยนใจกะทันหัน" | mkN "อําเภอใจ" | mkN "เพลงที่คิดตามอําเภอใจ" | mkN "แนวโน้มที่จะเปลี่ยนใจ" | mkN "การเปลี่ยนใจอย่างกะทันหัน" | mkN "การเปลี่ยนแปลงที่ไม่แน่นอน" ; -- src=panlex
lin capricious_A = mkA "ไม่แน่นอน" | mkA "ที่มีแนวโน้มจะเปลี่ยนใจอย่างกะทันหัน" ; -- src=panlex
lin capriciousness_N = mkN "การกระทำตามอำเภอใจ" | mkN "การเปลี่ยนใจกะทันหัน" | mkN "ความไม่อยู่กับร่องกับรอย" ; -- src=panlex
lin caprifig_N = mkN "ต้นแคปริฟิก" ; -- src=panlex
lin capriole_N = mkN "การกระโดดกระต่ายขาเดียว" ; -- src=panlex
lin capsaicin_N = mkN "แ่คปไซซิน" ; -- src=panlex
lin capsicum_N = mkN "ต้นเปปเปอร์" | mkN "พริก" | mkN "พืชจําพวก พริก" ; -- src=panlex
lin capsid_N = mkN "แคปซิด" ; -- src=panlex
lin capsize_V = mkV "พลิกคว่ำ" | mkV "คว่ํา" | mkV "พลิกคว่ํา" | mkV "ทําให้พลิกคว่ํา" | mkV "ทําให้เรือคว่ํา" ; -- src=panlex
lin capsize_V2 = mkV2 "พลิกคว่ำ" ; ---- | mkV "คว่ํา" | mkV "พลิกคว่ํา" | mkV "ทําให้พลิกคว่ํา" | mkV "ทําให้เรือคว่ํา" ; -- src=panlex
lin capstan_N = mkN "กว้านสมอเรือ" | mkN "กว้าน" | mkN "เครื่องถอนสมอเรือ" | mkN "เครื่องสําหรับฉุดดึงของหนัก" ; -- src=panlex
lin capstone_N = mkN "หินยอดกำแพง" | mkN "จุดสูงสุด" | mkN "หินที่วางอยู่บนกําแพง" ; -- src=panlex
lin capsulate_A = mkA "ซึ่งห่อหุ้มอยู่" | mkA "ซึ่งมีถุงห่อหุ้มอยู่" ; -- src=panlex
lin capsule_N = mkN "บทย่อ" | mkN "แคปซูล" | mkN "ฉบับย่อ" | mkN "ถุงหุ้ม" | mkN "ยานแคปซูล" | mkN "ที่นั่งดีดตัว" | mkN "ที่นั่งนักบิน" | mkN "ถุง" | mkN "ย่อ" | mkN "แคปซูล" | mkN "ถุงหุ้ม" | mkN "ยาแคปซูล" | mkN "สิ่งปิดผนึก" | mkN "ข้อสรุปสั้นๆ" | mkN "สั้นและจุความ" | mkN "ถุงกําเนิดสปอร์" | mkN "ยาที่อยู่ในหลอดเล็กๆ" ; -- src=panlex
lin captain_N = mkN "น.อ." | mkN "ร.อ." | mkN "กัปตัน" | mkN "นาวาเอก" | mkN "ร้อยเอก" | mkN "สารวัตร" | mkN "กัปตันเรือ" | mkN "นักบินอาวุโส" | mkN "หัวหน้ากลุ่ม" | mkN "หัวหน้าบริกร" | mkN "กัปตันเรือสินค้า" | mkN "หัวหน้าพนักงานเสิร์ฟ" | mkN "กัปตัน" | mkN "หัวหน้าทีม" | mkN "หัวหน้าผู้ควบคุมเรือ" ; -- src=panlex
lin captainship_N = mkN "ตำแหน่งกัปตัน" ; -- src=panlex
lin caption_N = mkN "คำบรรยายใต้ภาพ" | mkN "คำแปลบทภาพยนต์" | mkN "คําบรรยายใต้ภาพ" ; -- src=panlex
lin captious_A = mkA "ขี้บ่น" | mkA "จับผิด" | mkA "แคะได้" | mkA "หาเรื่อง" | mkA "คอยจับผิด" | mkA "ที่บ่นกับเรื่องไร้สาระ" ; -- src=panlex
lin captivation_N = mkN "ความหลงใหล" ; -- src=panlex
lin captiveFem_N = variants {} ; ---- sense to be split
lin captiveMasc_N = variants {} ; ---- sense to be split
lin captive_A = mkA "ที่ไม่สามารถหนีได้" ; -- src=panlex
lin captivity_N = mkN "การกักขัง" | mkN "การเป็นทาส" | mkN "การคุมขัง" | mkN "การผูกมัด" | mkN "การถูกกักขัง" | mkN "การถูกจองจํา" | mkN "ภาวะที่หลงไหล" | mkN "ภาวะที่เป็นเชลย" ; -- src=panlex
lin captopril_N = mkN "ยาแคโปเทน" ; -- src=panlex
lin captor_N = mkN "ผู้เข้ายึด" | mkN "ผู้จับ" | mkN "ผู้จับกุม" | mkN "ผู้ยืดได้" | mkN "ผู้ที่จับกุมผู้อื่นหรือสัตว์อื่น" ; -- src=panlex
lin capture_N = mkN "การกิน" | mkN "เข้ายึด" | mkN "การจับกุม" | mkN "การยึดทรัพย์" | mkN "ตีได้" | mkN "ยืดได้" | mkN "การจับได้" | mkN "การยืดได้" | mkN "ทําให้สนใจ" | mkN "เข้ายึดได้" | mkN "คนที่ถูกจับ" | mkN "ทําให้หลงไหล" | mkN "สิ่งที่ถูกยึด" ; -- src=panlex
lin capuchin_N = mkN "ลิงคาปูชิน" | mkN "เสื้อคลุมคาปูชิน" ; -- src=panlex
lin capulin_N = mkN "เม็กซิกันแบล็กเชอร์รี่" ; -- src=panlex
lin caput_N = mkN "หัว" | mkN "ศีรษะ" | mkN "เศียร" | mkN "พระเศียร" | mkN "ศีรษะ" | mkN "ส่วนหัว" ; -- src=panlex
lin capybara_N = mkN "แคปเออบารา" | mkN "สัตว์คล้ายหนูที่ใช้ฟันแทะ ไม่มีหาง" ; -- src=panlex
lin car_N = mkN "รถ" "คัน" | {-pan-} mkN "รถ" | mkN "รถราง" | mkN "ลิฟต์" | mkN "รถยนต์" | mkN "เคเบิลคาร์" | mkN "รถ" | mkN "ตู้รถ" | mkN "พาหนะ" | mkN "รถยนต์" ; -- src=panlex
lin carabao_N = mkN "ควาย" | mkN "ควาย" | mkN "กระบือที่มีต้นกําเนิดทางเอเชียตะวันตกเฉียงใต้" ; -- src=panlex
lin carabiner_N = mkN "ห่วงเชื่อมนิรภัย" ; -- src=panlex
lin caracal_N = mkN "แมวแคราเคิล" | mkN "ลีนซ์ทะเลทราย" | mkN "ลีนซ์แคราเคิล" ; -- src=panlex
lin caracara_N = mkN "เหยี่ยวแคแรแคร่า" | mkN "เหยี่ยวขายาวที่กินซากสัตว์เป็นอาหาร" ; -- src=panlex
lin carafe_N = mkN "เหยือกแก้ว" | mkN "ขวดแก้วไวน์" | mkN "ขวดชนิดหนึ่งใช้ใส่น้ําดื่มหรือไวน์เพื่อเสิร์ฟที่โต๊ะอาหาร" ; -- src=panlex
lin carambola_N = mkN "มะเฟือง" | mkN "ผลมะเฟือง" | mkN "ต้นมะเฟือง" | mkN "ลูกมะเฟือง" ; -- src=panlex
lin caramel_A = mkA "น้ำตาลคาราเมล" | mkA "ที่มีสีน้ําตาลอมเหลือง" ; -- src=panlex
lin caramel_N = mkN "คาราเมล" | mkN "สีน้ำตาลอ่อน" | mkN "สีน้ำตาลคาราเมล" | mkN "สีน้ำตาลอมเหลือง" | mkN "คาราเมล" | mkN "น้ําตาลต้ม" | mkN "น้ําตาลไหม้" | mkN "สีน้ําตาลอมเหลือง" ; -- src=panlex
lin carancha_N = mkN "เหยี่ยวแคแรนชา" ; -- src=panlex
lin carapace_N = mkN "กระดอง" | mkN "ฝา" | mkN "กระดอง" | mkN "ส่วนที่หุ้มหลังของสัตว์" | mkN "กระดองหรือเปลือกแข็งที่หุ้มตัวสัตว์" ; -- src=panlex
lin carat_N = mkN "กะรัต" | mkN "กะรัต" | mkN "หน่วยน้ําหนักของเพชรเท่ากับ 200 มิลลิกรัม" ; -- src=panlex
lin caravan_N = mkN "คาราวาน" | mkN "กองคาราวาน" | mkN "กองคาราวาน" | mkN "กลุ่มคนเดินทาง" | mkN "ขบวนนักเดินทาง" ; -- src=panlex
lin caravanning_N = mkN "การเดินทางท่องเที่ยวในวันหยุด" ; -- src=panlex
lin caravanserai_N = mkN "โรงแรมขนาดใหญ่" | mkN "โรงแรมที่มีพื้นที่จอดรถคาราวาน" ; -- src=panlex
lin caraway_N = mkN "คาราเวย์" | mkN "ต้นคาราเวย์" | mkN "เครื่องเทศคล้ายยี่หร่า" | mkN "เครื่องเทศชนิดหนึ่งใช้ปรุงอาหารได้" ; -- src=panlex
lin carbamate_N = mkN "คาร์บาเมต" ; -- src=panlex
lin carbide_N = mkN "สารประกอบธาตุคาร์บอน" | mkN "สารประกอบของธาตุคาร์บอน" ; -- src=panlex
lin carbine_N = mkN "ปืนคาร์บิน" | mkN "ปืนไรเฟิลสั้นชนิดหนึ่ง" | mkN "ปืนไรเฟิลชนิดหนึ่งมีน้ําหนักเบาและสั้น" ; -- src=panlex
lin carbineer_N = mkN "พลปืนคาร์บิน" | mkN "ทหารปืนคาร์บิน" ; -- src=panlex
lin carbohydrate_N = mkN "คาร์โบไฮเดรต" | mkN "เเป้งและน้ำตาล" | mkN "คาร์โบไฮเดรต" ; -- src=panlex
lin carbomycin_N = mkN "คาร์โบไมซิน" ; -- src=panlex
lin carbon_N = mkN "คาร์บอน" | mkN "ธาตุคาร์บอน" | mkN "กระดาษก๊อปปี้" | mkN "กระดาษคาร์บอน" | mkN "ก็อปปี้กระดาษคาร์บอน" | mkN "เลขอะตอม 6" | mkN "คาร์บอน" | mkN "ธาตุคาร์บอน" ; -- src=panlex
lin carbonaceous_A = mkA "ที่ประกอบด้วยคาร์บอน" ; -- src=panlex
lin carbonado_N = mkN "หินเพชรดำ" | mkN "คาร์บอนาโด" | mkN "เนื้อคาร์โบนาโด" ; -- src=panlex
lin carbonara_N = mkN "คาร์โบนาร่า" ; -- src=panlex
lin carbonate_N = mkN "คาร์บอเนต" | mkN "เกลือหรือ" | mkN "เกลือของกรดคาร์บอน" | mkN "ที่เติมคาร์บอนไดออกไซด์เข้าไป" ; -- src=panlex
lin carbonated_A = mkA "ที่มีก๊าซคาร์บอนไดออกไซด์" ; -- src=panlex
lin carbonation_N = mkN "คาร์บอเนชัน" | mkN "การเกิดคาร์บอเนต" ; -- src=panlex
lin carbonyl_N = mkN "คาร์บอนิล" ; -- src=panlex
lin carborundum_N = mkN "คาร์โบรันดัม" ; -- src=panlex
lin carboxyl_N = mkN "หมู่คาร์บอกซิล" ; -- src=panlex
lin carboy_N = mkN "ขวดแก้ว" | mkN "ขวดขนาดใหญ่ใช้ใส่ของเหลวอันตราย เช่น น้ํากรด" ; -- src=panlex
lin carbuncle_N = mkN "คาร์บังเคิล" | mkN "โกเมน" | mkN "พลอยแดง" | mkN "สิวหัวใหญ่" | mkN "โรคฝีฝักบัว" ; -- src=panlex
lin carbuncled_A = mkA "ซึ่งประดับคาร์บังเคิล" ; -- src=panlex
lin carburettor_N = mkN "คาร์บูเรเตอร์" | mkN "คาร์บูเรเตอร์" ; -- src=panlex
lin carcase_N = mkN "เนื้อ" | mkN "เนื้อชำแหละ" | mkN "ซากศพ" | mkN "ซากสัตว์" | mkN "ร่างกายคน" ; -- src=panlex
lin carcass_N = mkN "เนื้อ" | mkN "เนื้อชำแหละ" | mkN "ซาก" | mkN "ซากศพ" | mkN "ซากสัตว์" | mkN "ร่างกายคน" | mkN "ร่างกายมนุษย์" | mkN "สิ่งที่ไร้ค่า" ; -- src=panlex
lin carcinogen_N = mkN "สารก่อมะเร็ง" | mkN "สารที่ก่อให้เกิดมะเร็ง" | mkN "สารที่ทําให้เกิดมะเร็ง" ; -- src=panlex
lin carcinogenic_A = mkA "ที่ทําให้เกิดมะเร็ง" | mkA "ที่เป็นสาเหตุให้เกิดมะเร็ง" ; -- src=panlex
lin carcinoid_N = mkN "คาร์ซินอยด์" | mkN "มะเร็งชนิดคาร์ซินอยด์" ; -- src=panlex
lin carcinoma_N = mkN "มะเร็ง" ; -- src=panlex
lin carcinosarcoma_N = mkN "คาร์ซิโนซาร์โคมา" ; -- src=panlex
lin card_1_N = mkN "เมนู" | mkN "การ์ด" | mkN "คนตลก" | mkN "ประกาศ" | mkN "แผงวงจร" | mkN "บัตรเชิญ" | mkN "แผ่นวงจร" | mkN "โปสเตอร์" | mkN "ใบประกาศ" | mkN "ป้ายโฆษณา" | mkN "เทียบเชิญ" | mkN "เมนูอาหาร" | mkN "แผ่นการ์ด" | mkN "กระดาษการ์ด" | mkN "บัตรจดคะแนน" | mkN "รายการอาหาร" | mkN "บัตรประจำตัว" | mkN "บัตรบันทึกคะแนน" | mkN "ไพ่" | mkN "บัตร" | mkN "เมนู" | mkN "การ์ด" | mkN "คนตลก" | mkN "แผนการ" | mkN "ให้บัตร" | mkN "โปสการ์ด" | mkN "ติดบนบัตร" | mkN "บัตรอวยพร" | mkN "แผ่นการ์ด" | mkN "บัตรรายการ" | mkN "รายการอาหาร" | mkN "บัตรประจําตัว" | mkN "เขียนลงบนบัตร" | mkN "บัตรเรียงดรรชนี" | mkN "อุปกรณ์แปรงขนสักหลาด" | mkN "แปรงสําหรับแปรงเส้นใยให้เรียบ" | mkN "บัตรที่บรรจุข้อมูลทางตัวเลขหรือการเงิน" ; -- src=panlex
lin card_2_N = mkN "เมนู" | mkN "การ์ด" | mkN "คนตลก" | mkN "ประกาศ" | mkN "แผงวงจร" | mkN "บัตรเชิญ" | mkN "แผ่นวงจร" | mkN "โปสเตอร์" | mkN "ใบประกาศ" | mkN "ป้ายโฆษณา" | mkN "เทียบเชิญ" | mkN "เมนูอาหาร" | mkN "แผ่นการ์ด" | mkN "กระดาษการ์ด" | mkN "บัตรจดคะแนน" | mkN "รายการอาหาร" | mkN "บัตรประจำตัว" | mkN "บัตรบันทึกคะแนน" | mkN "ไพ่" | mkN "บัตร" | mkN "เมนู" | mkN "การ์ด" | mkN "คนตลก" | mkN "แผนการ" | mkN "ให้บัตร" | mkN "โปสการ์ด" | mkN "ติดบนบัตร" | mkN "บัตรอวยพร" | mkN "แผ่นการ์ด" | mkN "บัตรรายการ" | mkN "รายการอาหาร" | mkN "บัตรประจําตัว" | mkN "เขียนลงบนบัตร" | mkN "บัตรเรียงดรรชนี" | mkN "อุปกรณ์แปรงขนสักหลาด" | mkN "แปรงสําหรับแปรงเส้นใยให้เรียบ" | mkN "บัตรที่บรรจุข้อมูลทางตัวเลขหรือการเงิน" ; -- src=panlex
lin cardamom_N = mkN "กระวาน" | mkN "ต้นกระวาน" | mkN "ลูกกระวาน" | mkN "กระวาน" | mkN "เครื่องเทศชนิดหนึ่ง" ; -- src=panlex
lin cardboard_N = mkN "กระดาษแข็ง" | mkN "กระดาษแข็ง" ; -- src=panlex
lin cardcase_N = mkN "กล่องใส่นามบัตร" ; -- src=panlex
lin cardholder_N = mkN "คนถือไพ่" | mkN "ผู้ถือไพ่" | mkN "ผู้ถือบัตร" | mkN "ผู้ถือบัตร" | mkN "ผู้ที่เป็นเจ้าของเครดิตการ์ด" ; -- src=panlex
lin cardia_N = mkN "ปากกระเพาะ" ; -- src=panlex
lin cardiac_A = mkA "เกี่ยวกับหัวใจ" | mkA "ที่เกี่ยวกับหัวใจ" ; -- src=panlex
lin cardigan_N = mkN "เสื้อถัก" | mkN "เสื้อแจ๊คเก็ทหรือสเวตเตอร์ถัก" | mkN "เสื้อไหมพรมไม่มีปกและผ่าติดกระดุมหน้า" ; -- src=panlex
lin cardinal_A = mkA "หลัก" | mkA "ใหญ่" | mkA "ที่เป็นจำนวนนับ" ; -- src=panlex
lin cardinal_N = mkN "จำนวนนับ" | mkN "สีแดงเข้ม" | mkN "นกคาร์ดินอล" | mkN "พื้นฐาน" | mkN "มีสีแดง" | mkN "พระราชาคณะของคาทอลิก" | mkN "นกจําพวกหนึ่งตัวผู้สีแดงจัด" | mkN "พระในศาสนาคริสต์ที่มีลําดับชั้นสูงสุด" ; -- src=panlex
lin cardinalfish_N = mkN "ปลาคาร์ดินอลฟิช" ; -- src=panlex
lin cardinality_N = mkN "คาร์ดินัลลิตี้" ; -- src=panlex
lin cardinalship_N = mkN "ตำแหน่งพระคาร์ดินัล" ; -- src=panlex
lin cardiograph_N = mkN "คาร์ดิโอกราฟ" | mkN "อุปกรณ์บันทึกการทำงานของหัวใจ" ; -- src=panlex
lin cardiography_N = mkN "การบันทึกคลื่นไฟฟ้าหัวใจ" ; -- src=panlex
lin cardioid_N = mkN "คาร์ดิออยด์" ; -- src=panlex
lin cardiologistFem_N = variants {} ; ---- sense to be split
lin cardiologistMasc_N = variants {} ; ---- sense to be split
lin cardiology_N = mkN "หทัยวิทยา" | mkN "หัวใจวิทยา" | mkN "การศึกษาศาสตร์ที่เกี่ยวกับหัวใจ" ; -- src=panlex
lin cardiovascular_A = mkA "เกี่ยวกับหัวใจและหลอดเลือดหัวใจ" ; -- src=panlex
lin carditis_N = mkN "หัวใจอักเสบ" ; -- src=panlex
lin cardoon_N = mkN "คาร์ดูน" | mkN "ต้นคาร์ดูน" ; -- src=panlex
lin cardroom_N = mkN "ห้องเล่นไพ่" ; -- src=panlex
lin cardsharp_N = mkN "คนจัดไพ่" | mkN "คนโกงไพ่" | mkN "เซียนไพ่" | mkN "คนโกงไพ่" | mkN "คนเล่นไพ่โกง" ; -- src=panlex
lin care_N = mkN "การดูแล" | mkN "ความดูแล" | mkN "ความระวัง" | mkN "การช่วยเหลือ" | mkN "การดูแลรักษา" | mkN "ความเอาใจใส่" | mkN "การบำรุงรักษา" | mkN "การระมัดระวัง" | mkN "การดูแลเอาใจใส่" | mkN "การดูแล" | mkN "การปกป้อง" | mkN "ความห่วงใย" | mkN "ความระมัดระวัง" ; -- src=panlex
lin care_V = mkV "อยาก" | mkV "กังวล" | mkV "ใส่ใจ" | mkV "จัดการ" | mkV "แมนเนจ" | mkV "ช่วยดูแล" | mkV "ให้การดูแล" | mkV "บริหารจัดการ" | mkV "ดูแล" | mkV "ปกป้อง" | mkV "ห่วงใย" ; -- src=panlex
lin care_for_V2 = prepV2 OP_care_V OP_for_Prep ; -- guess-p-verb
lin careen_V = mkV "เฉ" | mkV "เดินโซเซ" | mkV "เคลื่อนที่อย่างเอียงไปเอียงมาและควบคุมไม่ได้" ; -- src=panlex
lin careen_V2 = mkV2 "เฉ" ; ---- | mkV "เดินโซเซ" | mkV "เคลื่อนที่อย่างเอียงไปเอียงมาและควบคุมไม่ได้" ; -- src=panlex
lin career_N = mkN "อาชีพ" | mkN "อาชีพ" | mkN "การงาน" ; -- src=panlex
lin careerist_N = mkN "ผู้ที่เห็นความสําเร็จของงานเหนือสิ่งอื่นใด" ; -- src=panlex
lin carefree_A = mkA "ที่ไร้กังวล" | mkA "สนุกสนานเพลิดเพลิน" | mkA "ไร้กังวล" ; -- src=panlex
lin careful_A = mkA "ประณีต" | mkA "ถี่ถ้วน" | mkA "ละเอียด" | mkA "ระมัดระวัง" | mkA "ระวังรอบคอบ" ; -- src=panlex
lin carefulness_N = mkN "ความระมัดระวัง" | mkN "ความระมัดระวัง" ; -- src=panlex
lin caregiver_N = mkN "คนดูแลเด็ก" | mkN "ผู้ประกอบวิชาชีพด้านสุขภาพ" | mkN "ผู้ที่ดูแลคนป่วยหรือคนแก่ที่บ้าน" ; -- src=panlex
lin careless_A = mkA "ซึ่งไม่ระมัดระวัง" | mkA "หยาบ" | mkA "สะเพร่า" | mkA "ไม่วิตก" | mkA "ไม่กังวล" | mkA "ไร้กังวล" | mkA "ไม่ระมัดระวัง" ; -- src=panlex
lin carelessness_N = mkN "ความประมาท" | mkN "ความไม่กังวล" | mkN "ความไม่ระมัดระวัง" ; -- src=panlex
lin carer_N = mkN "ผู้ที่ดูแลคนป่วยหรือคนแก่ที่บ้าน" ; -- src=panlex
lin caress_N = mkN "การสัมผัสด้วยความรัก" ; -- src=panlex
lin caressing_A = mkA "ที่สัมผัสด้วยความรักใคร่" ; -- src=panlex
lin caressing_N = mkN "การกอดจูบ" ; -- src=panlex
lin caretaker_N = mkN "รักษาการ" | mkN "คนรักษาการ" | mkN "ผู้รักษาการ" | mkN "ผู้ที่รับจ้างดูแล" | mkN "เจ้าหน้าที่รักษาการ" | mkN "คนเฝ้า" | mkN "ภารโรง" | mkN "คนดูแลควบคุม" | mkN "ผู้ที่รับจ้างดูแล" ; -- src=panlex
lin careworn_A = mkA "มีอาการกังวล" | mkA "ที่ดูเหนื่อยเพราะมีเรื่องกังวลมาก" ; -- src=panlex
lin carful_N = mkN "คัน" | mkN "คันรถ" | mkN "ปริมาณเต็มคันรถ" ; -- src=panlex
lin cargo_N = mkN "สินค้าขนส่ง" | mkN "สินค้าบรรทุก" | mkN "สินค้า" | mkN "สินค้าที่บรรทุก" | mkN "สินค้าบรรทุกบนเรือ" ; -- src=panlex
lin carhop_N = mkN "พนักงานเสิร์ฟในร้านอาหารแบบขับรถเข้าไปได้" ; -- src=panlex
lin caribou_N = mkN "กวางคาริบู" | mkN "กวางแคริบู" | mkN "กวางเรนเดียร์" | mkN "กวางแคริบู" | mkN "กวางขนาดใหญ่ชนิดหนึ่ง" | mkN "กวางชนิดหนึ่งในแถบอเมริกาเหนือ" ; -- src=panlex
lin caricature_N = mkN "ภาพล้อ" | mkN "ภาพล้อเลียน" | mkN "ภาพล้อเลียนบุคคล" | mkN "ภาพการ์ตูนล้อเลียน" | mkN "ภาพล้อเลียนบุคคล" ; -- src=panlex
lin caricaturist_N = mkN "นักเขียนภาพล้อเลียน" | mkN "นักเสียดสี" | mkN "นักเขียนภาพล้อเลียน" ; -- src=panlex
lin caries_N = mkN "อาการฟันผุ" | mkN "การผุ" | mkN "ภาวะผุ" | mkN "การผุกร่อนของกระดูกโดยเฉพาะฟัน" ; -- src=panlex
lin carillon_N = mkN "ระฆังชุด" | mkN "การตีระฆังชุด" | mkN "ระฆังที่เป็นชุด" | mkN "ท่วงทํานองเพลงดังกล่าว" | mkN "ชุดระฆังหลายใบที่ตีเป็นทํานองได้" ; -- src=panlex
lin carillonneur_N = mkN "นักตีระฆังชุด" | mkN "คนตีชุดระฆังเป็นท่วงทํานองเพลง" ; -- src=panlex
lin carina_N = mkN "สันนูนกระดูกอก" | mkN "สันหลัง" | mkN "แผ่นหลัง" | mkN "ส่วนที่คล้ายกระดูกของเรือ" ; -- src=panlex
lin carinate_N = mkN "นกคาริเน็ต" ; -- src=panlex
lin carioca_N = mkN "แคริโอกา" ; -- src=panlex
lin carious_A = mkA "ผุ" | mkA "กร่อน" | mkA "ที่ผุกร่อน" ; -- src=panlex
lin carissa_N = mkN "ต้นแคริสซา" ; -- src=panlex
lin carjacking_N = mkN "การปล้นชิงรถ" | mkN "การจี้รถเพื่อให้ขับไปตามที่คนร้ายต้องการ" ; -- src=panlex
lin carload_N = mkN "คันรถ" | mkN "ระวาง" | mkN "จํานวนบรรทุกหนึ่งคันรถ" ; -- src=panlex
lin carminative_A = mkA "ที่ทําให้ก๊าซถูกขับออกจากกระเพาะอาหาร" ; -- src=panlex
lin carminative_N = mkN "ยาขับลม" | mkN "ยาขับลม" | mkN "ยาที่ช่วยให้ก๊าซถูกขับออกจากกระเพาะอาหาร" ; -- src=panlex
lin carmine_A = mkA "แดง" | mkA "ที่มีสีแดงม่วงเข้ม" ; -- src=panlex
lin carmine_N = mkN "สีแดงเข้ม" | mkN "สีแดงเลือดนก" | mkN "สารสีแดงเลือดนก" ; -- src=panlex
lin carnage_N = mkN "การฆ่าฟัน" | mkN "การสังหารหมู่" | mkN "การฆาตกรรมหมู่" | mkN "การฆ่าอย่างโหดร้าย" ; -- src=panlex
lin carnal_A = mkA "ในทางกาม" | mkA "ในทางโลก" | mkA "เกี่ยวกับมนุษย์" | mkA "ไม่ใช่จิตวิญญาณ" | mkA "เกี่ยวกับเนื้อหนังมังสา" | mkA "ที่เกี่ยวกับเนื้อหนังมังสา" ; -- src=panlex
lin carnallite_N = mkN "คาร์นัลไลต์" | mkN "แร่คาร์นัลไลต์" ; -- src=panlex
lin carnation_A = mkA "สีคาร์เนชั่น" ; -- src=panlex
lin carnation_N = mkN "สีคาร์เนชั่น" | mkN "ต้นคาร์เนชั่น" | mkN "คาร์เนชั่น" | mkN "ดอกคาร์เนชั่น" | mkN "ดอกคาร์เนชั่นซึ่งคล้ายดอกยี่โถ" ; -- src=panlex
lin carnelian_N = mkN "คาร์เนเลียน" | mkN "หินที่มีสีแดง สีน้ําตาลแดงหรือสีขาว" ; -- src=panlex
lin carnival_N = mkN "แฟร์" | mkN "คาร์นิวัล" | mkN "การเล่นสนุกสนาน" | mkN "เทศกาลคาร์นิวาล" | mkN "งานเฉลิมฉลองของมวลชน" ; -- src=panlex
lin carnivore_N = mkN "สัตว์กินเนื้อ" | mkN "พืชกินแมลง" | mkN "สัตว์กินเนื้อ" ; -- src=panlex
lin carnivorous_A = mkA "ซึ่งกินเนื้อ" | mkA "ที่กินเนื้อสัตว์อื่นเป็นอาหาร" ; -- src=panlex
lin carnosaur_N = mkN "คาร์โนซอร์" ; -- src=panlex
lin carnotite_N = mkN "คาร์โนไทต์" ; -- src=panlex
lin carob_N = mkN "ต้นคารอบ" | mkN "แป้งแคร็อบ" | mkN "ต้นไม้ชนิดหนึ่งผลกินได้" ; -- src=panlex
lin caroche_N = mkN "รถม้าคาโรช" ; -- src=panlex
lin carol_N = mkN "เพลง" | mkN "เพลงเทศกาล" | mkN "เพลงคริสต์มาสคาโรล" | mkN "เพลงสวดหรือเพลงที่ร้องเพื่อความสนุกสนาน" ; -- src=panlex
lin carom_N = mkN "แคนนอน" ; -- src=panlex
lin carotene_N = mkN "แคโรทีน" | mkN "สารแคโรทีน" | mkN "โปรวิตามินเอ" | mkN "ไฮโดรคาร์บอนสีแดงที่พบในพืชหลายชนิด" | mkN "สารชนิดหนึ่งมีสีแดงหรือส้มพบมาในแครอทและผักอื่นๆ" ; -- src=panlex
lin carotenemia_N = mkN "ภาวะเลือดมีแคโรทีนมาก" ; -- src=panlex
lin carotenoid_N = mkN "คาร์โรทีนอยด์" ; -- src=panlex
lin carotid_A = mkA "เกี่ยวกับหลอดเลือดแดงหลักของคอ" ; -- src=panlex
lin carousal_N = mkN "การดื่มเหล้ากันอย่างหนัก" | mkN "การดื่มเหล้ากันอย่างเต็มที่" | mkN "การดื่มฉลองกันอย่างอึกทึกและเมาเหล้า" ; -- src=panlex
lin carouse_N = mkN "การดื่มเหล้ากันอย่างหนัก" ; -- src=panlex
lin carousel_N = mkN "ม้าหมุน" | mkN "สายพานหมุนเป็นวงกลม" | mkN "ม้าหมุน" ; -- src=panlex
lin carp_N = mkN "ปลาคาร์พ" | mkN "เนื้อปลาคาร์พ" | mkN "ปลาคาร์พ" | mkN "การบ่นโดยใช้อารมณ์" ; -- src=panlex
lin carp_V = mkV "คัดค้าน" | mkV "บ่นถึงข้อผิดพลาด" | mkV "จับผิดและบ่นถึงข้อผิดพลาด" ; -- src=panlex
lin carp_V2 = mkV2 "คัดค้าน" ; ---- | mkV "บ่นถึงข้อผิดพลาด" | mkV "จับผิดและบ่นถึงข้อผิดพลาด" ; -- src=panlex
lin carpal_A = mkA "ข้อมือ" | mkA "ที่เกี่ยวกับกระดูกข้อมือ" | mkA "เกี่ยวกับข้อมือหรือกระดูกข้อมือ" ; -- src=panlex
lin carpal_N = mkN "กระดูกข้อมือ" ; -- src=panlex
lin carpel_N = mkN "คาร์เพล" | mkN "โพรงเกสรตัวเมีย" ; -- src=panlex
lin carpellate_A = mkA "ที่มีคาร์เพล" ; -- src=panlex
lin carpenter_N = mkN "ช่างไม้" | mkN "ช่างไม้" ; -- src=panlex
lin carpentry_N = mkN "งานไม้" | mkN "งานไม้" | mkN "งานช่างไม้" | mkN "กิจการช่างไม้" ; -- src=panlex
lin carpet_N = mkN "พรม" "ผืน" | {-pan-} mkN "พรม" | mkN "ลาดพระบาท" | mkN "พรม" | mkN "ลักษณะพื้นผิวที่นุ่มเหมือนพรม" ; -- src=panlex
lin carpetbag_N = mkN "กระเป๋าเดินทางกำมะหยี่" | mkN "กระเป๋าที่ทําจากพรมใช้ในการเดินทาง" ; -- src=panlex
lin carpetbagger_N = mkN "นักเดินทาง" ; -- src=panlex
lin carpetweed_N = mkN "ต้นคาร์เพ็ตวีด" ; -- src=panlex
lin carpophore_N = mkN "คาร์โปฟอร์" ; -- src=panlex
lin carport_N = mkN "โรงรถ" | mkN "ที่จอดรถซึ่งสร้างโดยการต่อหลังคาจากด้านข้างตึก" ; -- src=panlex
lin carpospore_N = mkN "คาร์โพสปอร์" ; -- src=panlex
lin carrageenin_N = mkN "แคร์ราจีนิน" ; -- src=panlex
lin carrel_N = mkN "ช่องหรือโต๊ะอ่านหนังสือเล็กเฉพาะบุคคล" ; -- src=panlex
lin carriage_N = mkN "รถเข็นทารก" | mkN "รถเข็นเด็ก" | mkN "รถไฟโดยสาร" | mkN "รถม้าโดยสาร" | mkN "ลักษณะท่าทาง" | mkN "รถม้า" | mkN "ท่าทาง" | mkN "การขนส่ง" | mkN "ค่าขนส่ง" | mkN "การบริหาร" | mkN "รถเข็นเด็ก" | mkN "รถม้าสี่ล้อ" | mkN "อากัปกิริยา" | mkN "ตู้โดยสารรถไฟ" | mkN "รถไฟตู้โดยสาร" | mkN "ที่ค้ําที่มีล้อ" | mkN "ส่วนที่เคลื่อนได้เพื่อแบกพาอีกส่วนหนึ่ง" ; -- src=panlex
lin carriageway_N = mkN "เลน" ; -- src=panlex
lin carrier_N = mkN "พาหะ" | mkN "คนยกของ" | mkN "คนแบกหาม" | mkN "คลื่นพาหะ" | mkN "พาหะนำโรค" | mkN "เด็กยกของ" | mkN "คุณไปรษณีย์" | mkN "บริษัทขนส่ง" | mkN "ชั้นหลังคารถ" | mkN "บุรุษไปรษณีย์" | mkN "พนักงานไปรษณีย์" | mkN "คนส่งหนังสือพิมพ์" | mkN "เด็กส่งหนังสือพิมพ์" | mkN "เรือบรรทุกเครื่องบิน" | mkN "เรือบรรทุกเครื่องบินรบ" | mkN "ผู้ส่ง" | mkN "ผู้ขนส่ง" | mkN "พาหะนําโรค" | mkN "คนส่งจดหมาย" | mkN "คนส่งเอกสาร" | mkN "ตัวนําเชื้อ" | mkN "บริษัทขนส่ง" | mkN "ขบวนการขนส่ง" | mkN "บุรุษไปรษณีย์" | mkN "เครื่องบินขนส่ง" | mkN "คนส่งหนังสือพิมพ์" | mkN "อุปกรณ์รับน้ําหนัก" | mkN "คนที่เป็นพาหะนําโรค" | mkN "เรือบรรทุกเครื่องบินรบ" | mkN "บุคคลหรือบริษัทที่ทําธุรกิจเกี่ยวกับการขนส่ง" ; -- src=panlex
lin carrion_N = mkN "ซากขึ้นอืด" | mkN "เนื้อเหม็นเน่า" | mkN "เนื้อเน่าเปื่อย" | mkN "ผุพัง" | mkN "สกปรกโสมม" | mkN "เน่าเปื่อย" | mkN "คล้ายซากสัตว์" | mkN "เนื้อตายและเน่า" | mkN "สิ่งที่น่ารังเกียจ" | mkN "เนื้อที่เน่าเปื่อย" ; -- src=panlex
lin carrot_N = mkN "แครอท" | mkN "การเพาะปลูกแครอท" | mkN "แครอท" | mkN "หัวผักกาดแดง" | mkN "พืชชนิดหนึ่งมีลักษณะคล้ายหัวผักกาด มีสีส้ม" ; -- src=panlex
lin carry_N = mkN "การแบก" | mkN "ระยะ" | mkN "การขนส่ง" ; -- src=panlex
lin carry_V = mkV "นำ" | mkV "พก" | mkV "มี" | mkV "ยก" | mkV "กุม" | mkV "ถือ" | mkV "ยืด" | mkV "แฝง" | mkV "ดื่ม" | mkV "ท้อง" | mkV "ป่อง" | mkV "เชิด" | mkV "ขนส่ง" | mkV "ชดเชย" | mkV "ชนะใจ" | mkV "บรรจุ" | mkV "มีรอย" | mkV "บรรทุก" | mkV "มีท้อง" | mkV "เลี้ยง" | mkV "แบกรับ" | mkV "ถ่ายโอน" | mkV "มีครรภ์" | mkV "รับภาระ" | mkV "เข้ายึด" | mkV "แสดงถึง" | mkV "ให้เงิน" | mkV "ออกอากาศ" | mkV "อุ้มท้อง" | mkV "ขยายไปสู่" | mkV "ตั้งครรภ์" | mkV "ประพฤติตน" | mkV "เป็นตัวนำ" | mkV "เอามาก่อน" | mkV "ประพฤติตัว" | mkV "รับน้ำหนัก" | mkV "มีอยู่ในมือ" | mkV "เก็บไว้ในใจ" | mkV "ชนะการเลือกตั้ง" | mkV "ให้เงินสนับสนุน" | mkV "สนับสนุนทางการเงิน" | mkV "พก" | mkV "รับ" | mkV "แบก" | mkV "ใส่" | mkV "ท้อง" | mkV "อุ้ม" | mkV "ขนส่ง" | mkV "บรรจุ" | mkV "ถือไว้" | mkV "บรรทุก" | mkV "หอบไว้" | mkV "แบกรับ" | mkV "ค้ําจุน" | mkV "นําพาไป" | mkV "บอกข่าว" | mkV "ประพฤติ" | mkV "เดินทาง" | mkV "สนับสนุน" | mkV "อุ้มท้อง" | mkV "แจ้งข่าว" | mkV "ขยายไปสู่" | mkV "จดทะเบียน" | mkV "ตั้งครรภ์" | mkV "ลงทะเบียน" | mkV "ปฎิบัติตัว" | mkV "แจ้งข้อมูล" | mkV "เป็นสื่อนํา" | mkV "ชักนําทางความรู้สึก" ; -- src=panlex
lin carry_V2 = mkV2 "นำ" ; ---- | mkV "พก" | mkV "มี" | mkV "ยก" | mkV "กุม" | mkV "ถือ" | mkV "ยืด" | mkV "แฝง" | mkV "ดื่ม" | mkV "ท้อง" | mkV "ป่อง" | mkV "เชิด" | mkV "ขนส่ง" | mkV "ชดเชย" | mkV "ชนะใจ" | mkV "บรรจุ" | mkV "มีรอย" | mkV "บรรทุก" | mkV "มีท้อง" | mkV "เลี้ยง" | mkV "แบกรับ" | mkV "ถ่ายโอน" | mkV "มีครรภ์" | mkV "รับภาระ" | mkV "เข้ายึด" | mkV "แสดงถึง" | mkV "ให้เงิน" | mkV "ออกอากาศ" | mkV "อุ้มท้อง" | mkV "ขยายไปสู่" | mkV "ตั้งครรภ์" | mkV "ประพฤติตน" | mkV "เป็นตัวนำ" | mkV "เอามาก่อน" | mkV "ประพฤติตัว" | mkV "รับน้ำหนัก" | mkV "มีอยู่ในมือ" | mkV "เก็บไว้ในใจ" | mkV "ชนะการเลือกตั้ง" | mkV "ให้เงินสนับสนุน" | mkV "สนับสนุนทางการเงิน" | mkV "พก" | mkV "รับ" | mkV "แบก" | mkV "ใส่" | mkV "ท้อง" | mkV "อุ้ม" | mkV "ขนส่ง" | mkV "บรรจุ" | mkV "ถือไว้" | mkV "บรรทุก" | mkV "หอบไว้" | mkV "แบกรับ" | mkV "ค้ําจุน" | mkV "นําพาไป" | mkV "บอกข่าว" | mkV "ประพฤติ" | mkV "เดินทาง" | mkV "สนับสนุน" | mkV "อุ้มท้อง" | mkV "แจ้งข่าว" | mkV "ขยายไปสู่" | mkV "จดทะเบียน" | mkV "ตั้งครรภ์" | mkV "ลงทะเบียน" | mkV "ปฎิบัติตัว" | mkV "แจ้งข้อมูล" | mkV "เป็นสื่อนํา" | mkV "ชักนําทางความรู้สึก" ; -- src=panlex
lin carry_forward_V2 = mkV2 (advV OP_carry_V OP_forward_Adv ) ; -- guess-p-verb
lin carry_off_V2 = prepV2 OP_carry_V OP_off_Prep ; -- guess-p-verb
lin carry_on_V = advV OP_carry_V OP_on_Adv ; -- guess-p-verb
lin carry_on_V2 = prepV2 OP_carry_V OP_on_Prep ; -- guess-p-verb
lin carry_on_about_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_about_Prep ; -- guess-p-verb
lin carry_on_with_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin carry_out_V = advV OP_carry_V OP_out_Adv ; -- guess-p-verb
lin carry_out_V2 = prepV2 OP_carry_V OP_out_Prep ; -- guess-p-verb
lin carry_over_V2 = prepV2 OP_carry_V OP_over_Prep ; -- guess-p-verb
lin carry_through_V2 = prepV2 OP_carry_V OP_through_Prep ; -- guess-p-verb
lin carryall_N = mkN "กระเป๋าหูรูด" | mkN "กระเป๋าหูหิ้ว" | mkN "กระเป๋าเป้" ; -- src=panlex
lin carrycot_N = mkN "ตะกร้าหิ้วเด็ก" ; -- src=panlex
lin carsick_A = mkA "เมารถ" | mkA "ที่ไม่สบายจากการเดินทางโดยรถยนต์" ; -- src=panlex
lin cart_N = mkN "รถเข็น" | mkN "เกวียน" | mkN "เกวียน" | mkN "รถเข็นหรือรถลาก" ; -- src=panlex
lin cartage_N = mkN "รถบรรทุกสินค้า" | mkN "ค่าบรรทุกของรถสินค้า" | mkN "การขับรถม้าหรือเกวียน" ; -- src=panlex
lin cartel_N = mkN "กลุ่มบริษัท" | mkN "การร่วมกลุ่มบริษัท" | mkN "ระบบผูกขาดทางการค้าชนิดหนึ่ง" | mkN "กลุ่มบริษัทที่ตกลงราคาขายร่วมกันเพื่อไม่ให้มีการแข่งขันกัน" ; -- src=panlex
lin carter_N = mkN "คนขับเกวียน" | mkN "คนขับเกวียน" ; -- src=panlex
lin carthorse_N = mkN "ม้าลากเกวียน" | mkN "ม้าเทียมเกวียน" ; -- src=panlex
lin cartilage_N = mkN "กระดูกอ่อน" | mkN "กระดูกอ่อน" ; -- src=panlex
lin cartilaginous_A = mkA "ที่เหนียวเคี้ยวยาก" | mkA "เกี่ยวกับกระดูกอ่อน" ; -- src=panlex
lin cartload_N = mkN "รถเข็น" | mkN "จํานวนมาก" | mkN "จํานวนเต็มหนึ่งคันเกวียน" | mkN "ปริมาณที่รถม้าหรือเกวียนสามารถบรรทุกได้" ; -- src=panlex
lin cartographer_N = mkN "คนทำแผนที่" ; -- src=panlex
lin cartography_N = mkN "วิชาการทำแผนที่" | mkN "การทําแผนที่" | mkN "การสร้างแผนที่" | mkN "วิชาการทําแผนที่หรือแผนภาพ" ; -- src=panlex
lin carton_N = mkN "ลัง" | mkN "กล่อง" | mkN "จำนวนหนึ่งกล่อง" | mkN "กระดาษแข็ง" | mkN "กล่องกระดาษ" | mkN "จุดขาวในกลางเป้า" | mkN "จํานวนหนึ่งกล่อง" | mkN "กล่องกระดาษหรือพลาสติก" | mkN "สิ่งที่บรรจุในกล่องกระดาษ" ; -- src=panlex
lin cartoon_N = mkN "การ์ตูน" | mkN "หนังการ์ตูน" | mkN "ภาพยนตร์การ์ตูน" | mkN "ภาพล้อ" | mkN "ภาพการ์ตูน" ; -- src=panlex
lin cartoonistFem_N = variants {} ; ---- sense to be split
lin cartoonistMasc_N = variants {} ; ---- sense to be split
lin cartridge_N = mkN "ปิกอัพ" | mkN "แมกกาซีน" | mkN "ปลอกกระสุนปืน" | mkN "ปลอกกระสุนปืน" | mkN "หลอดเล็กใส่ของเหลวหรือก๊าซเพื่อนําไปใส่เครื่องมืออื่น" ; -- src=panlex
lin cartroad_N = mkN "ทางเกวียน" ; -- src=panlex
lin cartwheel_N = mkN "การทำล้อเกวียน" | mkN "เหรียญเงินดอลลาร์" | mkN "เหรียญซิลเวอร์ดอลลาร์" | mkN "ล้อเกวียน" | mkN "การตีลังกาล้อเกวียน" ; -- src=panlex
lin cartwright_N = mkN "ช่างต่อเกวียน" | mkN "ช่างทํารถม้า" | mkN "ช่างทําเกวียน" ; -- src=panlex
lin caruncle_N = mkN "คารังเคิล" | mkN "หงอน" | mkN "หงอนไก่" | mkN "เนื้องอก" | mkN "ส่วนยื่นของเนื้อเยื่อ" ; -- src=panlex
lin carve_V = mkV "แกะ" | mkV "สลัก" | mkV "หั่น" | mkV "แกะสลัก" | mkV "สลักเสลา" | mkV "ตัด" | mkV "แกะ" | mkV "แล่" | mkV "สลัก" | mkV "แกะสลัก" ; -- src=panlex
lin carve_V2 = mkV2 "แกะ" ; ---- | mkV "สลัก" | mkV "หั่น" | mkV "แกะสลัก" | mkV "สลักเสลา" | mkV "ตัด" | mkV "แกะ" | mkV "แล่" | mkV "สลัก" | mkV "แกะสลัก" ; -- src=panlex
lin carver_N = mkN "ประติมากร" | mkN "คนแล่เนื้อ" | mkN "ช่างแกะไม้" | mkN "ช่างสลักไม้" | mkN "ช่างแกะสลัก" | mkN "ช่างแกะสลัก" ; -- src=panlex
lin carving_N = mkN "การตัด" | mkN "การแกะสลัก" | mkN "งานแกะสลัก" | mkN "รูปแกะสลัก" | mkN "การสร้างรูปลอยตัว" | mkN "การแกะสลัก" | mkN "งานแกะสลัก" | mkN "สิ่งของแกะสลัก" ; -- src=panlex
lin caryatid_N = mkN "เสาแกะสลัก" | mkN "รูปปั้นผู้หญิงที่เสา" ; -- src=panlex
lin casaba_N = mkN "คาซาบาเมลอน" ; -- src=panlex
lin cascade_N = mkN "น้ำตกเล็กๆ" | mkN "หลั่นน้ำตก" | mkN "การตกเหมือนน้ำ" | mkN "ลักษณะเหมือนน้ําตก" ; -- src=panlex
lin cascade_V = mkV "สยาย" | mkV "จัดเรียง" | mkV "ตกลงมาเหมือนน้ําตก" ; -- src=panlex
lin cascara_N = mkN "เปลือกชิตเตม" ; -- src=panlex
lin cascarilla_N = mkN "ต้นแคสคาริลลา" ; -- src=panlex
lin case_N = mkN "กาบ" | mkN "คดี" | mkN "หีบ" | mkN "เคส" | mkN "กรณี" | mkN "กรอบ" | mkN "การก" | mkN "ปลอก" | mkN "ฟอนต์" | mkN "อักษร" | mkN "ลักษณะ" | mkN "อักขระ" | mkN "เปลือก" | mkN "กระเป๋า" | mkN "คดีความ" | mkN "ตู้โชว์" | mkN "กรณศึกษา" | mkN "ตัวอย่าง" | mkN "ตัวอักษร" | mkN "ปลอกหมอน" | mkN "แบบอักษร" | mkN "กรณีศึกษา" | mkN "เหตุการณ์" | mkN "แบบอักขระ" | mkN "ข้อเท็จจริง" | mkN "ภาชนะแก้วใส" | mkN "กรอบหน้าต่าง" | mkN "การดำเนินคดี" | mkN "ปริมาณหนึ่งหีบ" | mkN "คดี" | mkN "กรอบ" | mkN "ปัญหา" | mkN "ข้อคดี" | mkN "คดีความ" | mkN "ปลอกหมอน" | mkN "สถานการณ์" | mkN "เรื่องราว" | mkN "เหตุการณ์" | mkN "กล่องเล็กๆ" | mkN "ข้อสนับสนุน" | mkN "คนที่ไม่ปกติ" | mkN "จํานวนคู่หนึ่ง" | mkN "เหตุผลสนับสนุน" | mkN "คนหรือสิ่งที่เป็นกรณีศึกษา" ; -- src=panlex
lin casebook_N = mkN "หนังสือรวบรวมคำพิพากษา" ; -- src=panlex
lin casein_N = mkN "เคซีน" ; -- src=panlex
lin casement_N = mkN "หน้าต่างบานพับ" | mkN "หน้าต่างบานพับ" ; -- src=panlex
lin caseous_A = mkA "เกี่ยวกับ" | mkA "ที่เหมือนชีส" ; -- src=panlex
lin casework_N = mkN "งานที่ช่วยเกี่ยวกับปัญหาสังคม" ; -- src=panlex
lin caseworm_N = mkN "ตัวหนอนที่สร้างเยื่อหุ้มล้อมรอบตัว" ; -- src=panlex
lin cash_N = mkN "เงินสด" | mkN "เงินสด" ; -- src=panlex
lin cash_V = mkV "ขึ้นเงิน" | mkV "รับหรือจ่ายเงิน" ; -- src=panlex
lin cash_V2 = mkV2 "ขึ้นเงิน" ; ---- | mkV "รับหรือจ่ายเงิน" ; -- src=panlex
lin cashbox_N = mkN "กล่องเงินสด" ; -- src=panlex
lin cashew_N = mkN "มะม่วงหิมพานต์" | mkN "มะม่วมหิมพานต์" | mkN "ต้นมะม่วงหิมพานต์" | mkN "เม็ดมะม่วงหิมพานต์" | mkN "มะม่วงหิมพานต์" | mkN "ต้นมะม่วงหิมพานต์" ; -- src=panlex
lin cashier_N = mkN "แคชเชียร์" | mkN "พนักงานธนาคาร" | mkN "พนักงานรับจ่ายเงิน" | mkN "เจ้าหน้าที่การเงิน" ; -- src=panlex
lin cashmere_N = mkN "ผ้าสักหลาดแคชเมียร์" | mkN "ขนแกะพันธุ์แคชเมียร์" | mkN "สิ่งทอที่ทําด้วยเส้นใยขนแกะแค็ชเมียร์" ; -- src=panlex
lin casing_N = mkN "กรอบ" | mkN "ปลอก" | mkN "เปลือก" | mkN "กรอบหน้าต่าง" | mkN "ท่อ" | mkN "หีบ" | mkN "โครง" | mkN "กล่อง" | mkN "ท่อเหล็ก" | mkN "กรอบภายนอก" | mkN "สิ่งหุ้มห่อ" | mkN "วัตถุสําหรับหุ้มห่อ" | mkN "ไส้วัวควายที่ใช้ทําไส้กรอก" ; -- src=panlex
lin casino_N = mkN "คาสิโน" | mkN "บ่อนคาสิโน" | mkN "โรงบ่อน" | mkN "บ่อนคาสิโน" | mkN "บ่อนการพนัน" ; -- src=panlex
lin cask_N = mkN "ถังไม้" | mkN "ถังใส่เหล้า" | mkN "ปริมาณหนึ่งถัง" | mkN "ถังไม้ขนาดใหญ่ใส่ของเหลว" | mkN "ปริมาณที่บรรจุได้ในถังไม้" ; -- src=panlex
lin casket_N = mkN "โกศ" | mkN "โลง" | mkN "หีบศพ" | mkN "โลงผี" | mkN "โลงศพ" | mkN "พระโกศ" | mkN "หีบพระศพ" | mkN "กล่องเครื่องเพชร" | mkN "กล่องใส่เครื่องเพชร" | mkN "ตลับ" | mkN "หีบศพ" | mkN "กล่องเล็กๆ" ; -- src=panlex
lin caspase_N = mkN "เอนไซม์คาสเพส" ; -- src=panlex
lin casque_N = mkN "หมวกเกราะแคสก์" ; -- src=panlex
lin cassareep_N = mkN "แคสซารีพ" ; -- src=panlex
lin cassava_N = mkN "มันสำปะหลัง" | mkN "ต้นมันสำปะหลัง" | mkN "แป้งมันสำปะหลัง" | mkN "มันสําปะหลัง" | mkN "แป้งมันสําปะหลัง" ; -- src=panlex
lin casserole_N = mkN "กระทะร้อน" | mkN "จานกระทะร้อน" ; -- src=panlex
lin cassette_N = mkN "คาสเซท" | mkN "ตลับเทป" ; -- src=panlex
lin cassia_N = mkN "ต้นแคสเชอ" | mkN "ต้นแคสเซีย" ; -- src=panlex
lin cassiri_N = mkN "แคสซิรี" ; -- src=panlex
lin cassiterite_N = mkN "แคสซิเทอไรต์" | mkN "แร่แคสซิเทอไรต์" | mkN "หินดีบุก" | mkN "แร่ดีบุก" ; -- src=panlex
lin cassock_N = mkN "บาทหลวง" | mkN "ตําแหน่งบาทหลวง" | mkN "เสื้อคลุมของบาทหลวง" | mkN "เสื้อคลุมสีดําของบาทหลวง" ; -- src=panlex
lin cassowary_N = mkN "นกคาสโซวารี" ; -- src=panlex
lin cast_N = mkN "พิมพ์" | mkN "รูปทรง" | mkN "ผู้แสดง" | mkN "รูปร่าง" | mkN "รูปหล่อ" | mkN "แม่พิมพ์" | mkN "ผ้าพันแผล" | mkN "การขว้างปา" | mkN "รูปทรงเฉพาะ" | mkN "การทอดลูกเต๋า" | mkN "การทอยลูกเต๋า" | mkN "การเหวี่ยงเบ็ด" | mkN "รายชื่อตัวละคร" | mkN "รูปแบบเฉพาะตัว" | mkN "แบบ" | mkN "ชนิด" | mkN "การโยน" | mkN "ประเภท" | mkN "โชคชะตา" | mkN "การขว้าง" | mkN "การคํานวณ" | mkN "การทํานาย" | mkN "สิ่งภายนอก" | mkN "สิ่งที่ได้จากการหลอม" ; -- src=panlex
lin cast_V = mkV "ราก" | mkV "อ้วก" | mkV "กำจัด" | mkV "คายออก" | mkV "รากแตก" | mkV "อาเจียน" | mkV "เขวี้ยง" | mkV "เร่ร่อน" | mkV "โยนทิ้ง" | mkV "เร่่ร่อน" | mkV "กำหนดลีลา" | mkV "เลือกสุ่ม" | mkV "เทพิมพ์หล่อ" | mkV "ลงคะแนนเสียง" | mkV "เทลงแม่พิมพ์" | mkV "คัดด้วยตัวเอง" | mkV "ส่งไปข้างหน้า" | mkV "โยน" | mkV "ทิ้ง" | mkV "หลอม" | mkV "หล่อ" | mkV "ขว้าง" | mkV "คํานวณ" | mkV "ทํานาย" | mkV "จับฉลาก" | mkV "มองตรงไปยัง" | mkV "เลือกตัวละคร" ; -- src=panlex
lin cast_V2 = mkV2 "ราก" ; ---- | mkV "อ้วก" | mkV "กำจัด" | mkV "คายออก" | mkV "รากแตก" | mkV "อาเจียน" | mkV "เขวี้ยง" | mkV "เร่ร่อน" | mkV "โยนทิ้ง" | mkV "เร่่ร่อน" | mkV "กำหนดลีลา" | mkV "เลือกสุ่ม" | mkV "เทพิมพ์หล่อ" | mkV "ลงคะแนนเสียง" | mkV "เทลงแม่พิมพ์" | mkV "คัดด้วยตัวเอง" | mkV "ส่งไปข้างหน้า" | mkV "โยน" | mkV "ทิ้ง" | mkV "หลอม" | mkV "หล่อ" | mkV "ขว้าง" | mkV "คํานวณ" | mkV "ทํานาย" | mkV "จับฉลาก" | mkV "มองตรงไปยัง" | mkV "เลือกตัวละคร" ; -- src=panlex
lin cast_about_for_V2 = prepV2 (advV OP_cast_V OP_about_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_around_V = advV OP_cast_V OP_around_Adv ; -- guess-p-verb
lin cast_around_for_V2 = prepV2 (advV OP_cast_V OP_around_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_aside_V2 = mkV2 (advV OP_cast_V OP_aside_Adv ) ; -- guess-p-verb
lin cast_off_V = advV OP_cast_V OP_off_Adv ; -- guess-p-verb
lin cast_off_V2 = prepV2 OP_cast_V OP_off_Prep ; -- guess-p-verb
lin cast_out_V2 = prepV2 OP_cast_V OP_out_Prep ; -- guess-p-verb
lin cast_round_for_V2 = prepV2 (advV OP_cast_V OP_round_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_up_V2 = prepV2 OP_cast_V OP_up_Prep ; -- guess-p-verb
lin castaway_N = mkN "ผู้รอดชีวิตจากเรืออับปาง" | mkN "เรือแตก" | mkN "คนเรือแตก" | mkN "ถูกทิ้งขว้าง" | mkN "คนที่เรืออับปาง" ; -- src=panlex
lin caste_N = mkN "วรรณะ" | mkN "ชนชั้น" | mkN "ฝูงแมลง" | mkN "ชั้น" | mkN "วรรณะ" | mkN "วงศ์ตระกูล" | mkN "กลุ่มของสังคม" | mkN "วรรณะในศาสนาฮินดู" | mkN "ชนชั้นในศาสนาฮินดู" | mkN "ชนชั้นหรือกลุ่มในสังคม" ; -- src=panlex
lin castellated_A = mkA "มีหลายปราสาท" | mkA "สร้างคล้ายปราสาท" | mkA "ที่มีลักษณะเหมือนปราสาท" ; -- src=panlex
lin caster_N = mkN "ขวด" | mkN "ลูกล้อ" | mkN "ล้อหมุน" | mkN "ช่างหล่อ" | mkN "คนขว้าง" | mkN "สิ่งขว้าง" | mkN "กระปุกเกลือ" | mkN "ล้อเลื่อนที่ติดที่ฐานเก้าอี้หรือเฟอร์นิเจอร์" ; -- src=panlex
lin castigation_N = mkN "การด่าทอ" | mkN "การลงโทษ" ; -- src=panlex
lin casting_N = mkN "การหล่อ" | mkN "รูปหล่อ" | mkN "แคสติ้ง" | mkN "การคัดตัว" | mkN "การหล่อโลหะ" | mkN "การเหวี่ยงเบ็ด" | mkN "การคัดตัวนักแสดง" | mkN "การคัดเลือกนักแสดง" | mkN "การโยน" | mkN "การขว้าง" | mkN "การกําหนดบท" | mkN "กระบวนการหล่อ" | mkN "การคัดเลือกนักแสดง" | mkN "สิ่งที่ถูกหล่อออกมา" | mkN "สิ่งที่ได้จากการหลอม" ; -- src=panlex
lin castle_N = mkN "เรือ" | mkN "ปราสาท" | mkN "ป้อมปราการ" | mkN "ปราสาท" | mkN "คฤหาสน์" | mkN "พระราชวัง" | mkN "ป้อมปราการ" | mkN "ตัวเรือในเกมหมากรุก" ; -- src=panlex
lin castle_V = mkV "เดินขุน" | mkV "เดินหมาก" | mkV "เดินตัวหมากรุก" ; -- src=panlex
lin castor_N = mkN "ขวด" | mkN "ลูกล้อ" | mkN "ล้อหมุน" | mkN "ต้นละหุ่ง" | mkN "ล้อเลื่อนที่ติดที่ฐานเก้าอี้หรือเฟอร์นิเจอร์" ; -- src=panlex
lin castration_N = mkN "การตอน" | mkN "การทำหมัน" | mkN "การตัดทอนแก้ไข" | mkN "การตัดทอนแก้ไ่ข" | mkN "การตอน" | mkN "การทําหมัน" ; -- src=panlex
lin castrato_N = mkN "นักร้องเสียงคัสตราโต" ; -- src=panlex
lin casual_A = mkA "ลำลอง" | mkA "สบายๆ" | mkA "จร" | mkA "ลําลอง" | mkA "ธรรมดา ๆ" | mkA "ตามอารมณ์" | mkA "ไม่แน่นอน" | mkA "ที่ไม่สนใจ" | mkA "โดยบังเอิญ" | mkA "ประจวบเหมาะ" | mkA "โดยไม่ตั้งใจ" | mkA "ไม่เป็นทางการ" | mkA "ที่ไม่ค่อยสนใจ" | mkA "ที่ทําไปเรื่อยๆ" | mkA "เป็นบางครั้งบางคราว" ; -- src=panlex
lin casualness_N = mkN "ความไม่ีเป็นทางการ" | mkN "ความเฉยๆ" | mkN "ความเรื่อยๆ" | mkN "ความไม่สนใจ" | mkN "ความไม่เป็นทางการ" | mkN "ความเป็นบางครั้งบางคราว" ; -- src=panlex
lin casualty_N = mkN "ผู้บาดเจ็บ" | mkN "ผู้ประสบอุบัติเหตุ" | mkN "อุบัติเหตุคร่าชีวิต" | mkN "ผู้ได้รับบาดเจ็บจากการปฏิบัติหน้าที่" | mkN "จํานวนคนตาย" | mkN "อุบัติเหตุร้ายแรง" | mkN "จํานวนคนตายหรือได้รับบาดเจ็บ" | mkN "คนที่ได้รับบาดเจ็บหรือตายในอุบัติเหตุ" ; -- src=panlex
lin casuarina_N = mkN "ต้นไม้สกุลแคชัวรินา" ; -- src=panlex
lin casuist_N = mkN "คนเจ้าคารม" | mkN "เจ้าคารม" | mkN "เจ้าโวหาร" | mkN "ผู้ศึกษาและถือหลักธรรมจริยา" | mkN "ผู้ตัดสินปัญหาในสถานการณ์เฉพาะอย่าง" | mkN "คนที่อ้างเหตุผลเพื่อทําให้เชื่ออย่างผิดๆ" ; -- src=panlex
lin casuistic_A = mkA "ซึ่งใช้หลักจริยธรรม" | mkA "ซึ่งทำให้เชื่ออย่างผิด" | mkA "ซึ่งทำให้เชื่ออย่างผิดๆ" | mkA "เจ้าคารม" | mkA "ซึ่งตัดสินปัญหาในสถานการณ์เฉพาะ" ; -- src=panlex
lin casuistical_A = mkA "ซึ่งใช้หลักจริยธรรม" | mkA "ซึ่งทำให้เชื่ออย่างผิด" | mkA "ซึ่งทำให้เชื่ออย่างผิดๆ" | mkA "เจ้าคารม" | mkA "ซึ่งตัดสินปัญหาในสถานการณ์เฉพาะ" ; -- src=panlex
lin casuistry_N = mkN "การยึดหลักธรรม" | mkN "การเล่นลิ้น" | mkN "การเล่นสํานวนโวหาร" | mkN "การใช้หลักศีลธรรมจรรยาที่ผิด" | mkN "การใช้หลักศีลธรรมจรรยาในการตัดสินปัญหา" ; -- src=panlex
lin cat_N = mkN "แมว" "ตัว" | {-pan-} mkN "แมว" | mkN "หนุ่ม" | mkN "ใบแคท" | mkN "แมวใหญ่" | mkN "การนินทา" | mkN "ชายหนุ่ม" | mkN "พ่อหนุ่ม" | mkN "รถตีนตะขาบ" | mkN "แส้แมวเก้าหาง" | mkN "แมว" | mkN "วิฬาร์" | mkN "หญิงที่ถูกว่าในแง่ร้าย" | mkN "แส้หนังที่มีสายหนังอยู่เก้าเส้น" ; -- src=panlex
lin catabiosis_N = mkN "การที่เซลล์เชื่อม" ; -- src=panlex
lin catabolic_A = mkA "คาตาโบลิซึม" ; -- src=panlex
lin catabolism_N = mkN "การเผาผลาญ" | mkN "การสันดาปที่เป็นการทําลาย" ; -- src=panlex
lin catachresis_N = mkN "การใช้คําผิด" | mkN "ศัพท์ที่ใช้ผิด" ; -- src=panlex
lin cataclinal_A = mkA "แห่งหุบเขา" ; -- src=panlex
lin cataclysm_N = mkN "กลียุค" | mkN "ความหายนะ" | mkN "เหตุการณ์เลวร้าย" | mkN "การเปลี่ยนแปลงของเปลือกโลก" | mkN "ความพินาศ" | mkN "ความหายนะ" | mkN "การเปลี่ยนแปลงที่รุนแรง" | mkN "การเปลี่ยนแปลงที่รุนแรงของเปลือกโลก" ; -- src=panlex
lin catacomb_N = mkN "สุลต่าน" | mkN "สุสานใต้ดิน" | mkN "ห้องสุสานใต้ดิน" | mkN "อุโมงค์เก็บเหล้า" | mkN "หลุมฝังศพใต้ดินที่มีหลายๆ ห้อง" ; -- src=panlex
lin catadromous_A = mkA "ที่อพยพไปวางไข่" ; -- src=panlex
lin catafalque_N = mkN "ที่ตั้งศพ" | mkN "รถบรรทุกศพ" | mkN "เชิงเทินตั่งศพ" | mkN "ที่ตั้งหีบศพที่มีการประดับตกแต่ง" ; -- src=panlex
lin catalanFem_N = variants {} ;
lin catalanMasc_N = variants {} ;
lin catalan_A = mkA (thword "คะ" "ตะ" "ลัน") ;
lin catalase_N = mkN "คะตะเลส" | mkN "เอนไซต์คะตะเลส" ; -- src=panlex
lin catalatic_A = mkA "เกี่ยวกับเอ็นไซม์คาตาลาส" ; -- src=panlex
lin catalepsy_N = mkN "โรคคาตาเลปซี่" | mkN "การเจ็บป่วยที่ผู้ป่วยไม่สามารถขยับเขยื้อนตนเองได้" ; -- src=panlex
lin cataleptic_A = mkA "ที่เป็นผลจากอัมพาต" ; -- src=panlex
lin cataleptic_N = mkN "ผู้ป่วยโรคคาตาเลปซี" ; -- src=panlex
lin catalog_N = mkN "แคตาล็อก" | mkN "รายชื่อ" | mkN "บัญชีรายชื่อ" ; -- src=panlex
lin cataloger_N = mkN "ผู้จัดทำแค็ตตาล็อก" ; -- src=panlex
lin catalogue_N = mkN "แคตาล็อก" | mkN "รายชื่อ" | mkN "แค็ตตาล็อก" | mkN "บัญชีรายชื่อ" ; -- src=panlex
lin catalufa_N = mkN "ปลาคาตาลูฟา" ; -- src=panlex
lin catalysis_N = mkN "การเร่งปฏิกิริยา" | mkN "การเร่งปฏิกิริยาเคมี" | mkN "การเพิ่มปฏิกิริยาทางเคมี" ; -- src=panlex
lin catalyst_N = mkN "ตัวเร่งปฎิกิริยา" | mkN "ตัวเร่งปฏิกิริยา" | mkN "ตัวเร่ง" | mkN "ตัวเร่งปฎิกิริยา" | mkN "ตัวเร่งปฏิกิริยา" | mkN "คนหรือสิ่งที่ทําให้เกิดการเปลี่ยนแปลง" ; -- src=panlex
lin catalytic_A = mkA "ซึ่งเร่งปฏิกิริยา" ; -- src=panlex
lin catamaran_N = mkN "เรือใบแฝด" | mkN "เรือใบที่มีลําเรือสองลํา" ; -- src=panlex
lin cataphatic_A = mkA "เกี่ยวกับศาสนาที่เชื่อพระเจ้า" ; -- src=panlex
lin cataphatism_N = mkN "คาทาฟาติสม์" ; -- src=panlex
lin cataphyll_N = mkN "เกล็ดหุ้มยอด" ; -- src=panlex
lin cataplasia_N = mkN "การเสื่อมของเนื้อเยื่อหรือเซลล์" ; -- src=panlex
lin catapult_N = mkN "ปืนใหญ่" | mkN "หนังสติ๊ก" | mkN "ตัวปล่อยจรวด" | mkN "เครื่องส่งอากาศยาน" | mkN "หนังสติ๊ก" | mkN "หนังสติ๊กรูปตัววี" | mkN "เครื่องยิงในสมัยโบราณ" | mkN "เครื่องเหวี่ยงขีปนาวุธ" ; -- src=panlex
lin catapultic_A = mkA "เหมือนเครื่องยิงก้อนหิน" ; -- src=panlex
lin cataract_N = mkN "โรคต้อ" | mkN "แก่งน้ำตก" | mkN "น้ำตกแก่งใหญ่" | mkN "ต้อ" | mkN "น้ําป่า" | mkN "ต้อกระจก" | mkN "ต้อแก้วตา" | mkN "แก่งในแม่น้ํา" | mkN "น้ําตกขนาดใหญ่" | mkN "น้ําตกที่สูงชัน" | mkN "การไหลเชี่ยวของน้ํา" | mkN "ฝนที่เทกระหน่ําลงมา" ; -- src=panlex
lin catarrh_N = mkN "เยื่อบุหลอดลมอักเสบ" | mkN "โรคหวัดที่มีน้ํามูกไหลออกมาก" ; -- src=panlex
lin catarrhine_A = mkA "เกี่ยวกับลิงคาตาร์ไรน์" | mkA "เกี่ยวกับลิงคาตาร์ริเนียน" ; -- src=panlex
lin catastrophe_N = mkN "กลียุค" | mkN "ความหายนะ" | mkN "เหตุการณ์เลวร้าย" | mkN "การเปลี่ยนแปลงของเปลือกโลก" | mkN "จุดจบ" | mkN "จุดอวสาน" | mkN "ความหายนะ" | mkN "ภัยพิบัติ" | mkN "ความล้มเหลว" | mkN "ตอนจบของละคร" | mkN "เหตุการณ์ที่ร้ายกาจ" | mkN "การเปลี่ยนแปลงอย่างรุนแรงของเปลือกโลก" ; -- src=panlex
lin catatonia_N = mkN "อาการชัก" | mkN "โรคประสาทหลอน" ; -- src=panlex
lin catbird_N = mkN "นก" | mkN "นกโบเวอร์เบิร์ด" ; -- src=panlex
lin catcall_N = mkN "เสียงผิวปาก" | mkN "เสียงร้องคล้ายแมว" ; -- src=panlex
lin catcall_V = mkV "ผิวปาก" ; -- src=panlex
lin catch_N = mkN "การจับ" | mkN "เงื่อนงำ" | mkN "การจับกุม" | mkN "ที่ล็อกประตู" | mkN "การลากคอเข้าคุก" | mkN "การหน่วงเหนี่ยว" | mkN "ปริมาณที่จับได้" | mkN "คนที่เหมาะจะแต่งงาน" | mkN "การจับ" | mkN "สิ่งที่จับได้" | mkN "สิ่งที่ทําทําติดอยู่ เช่น กลอนประตู" | mkN "อุปสรรคหรือปัญหาที่ซ่อนอยู่" ; -- src=panlex
lin catch_at_V2 = prepV2 (lin V OP_catch_V2) OP_at_Prep ; -- guess-p-verb
lin catch_on_V = advV (lin V OP_catch_V2) OP_on_Adv ; -- guess-p-verb
lin catch_out_V2 = prepV2 (lin V OP_catch_V2) OP_out_Prep ; -- guess-p-verb
lin catch_up_V = advV (lin V OP_catch_V2) OP_up_Adv ; -- guess-p-verb
lin catch_up_V2 = prepV2 (lin V OP_catch_V2) OP_up_Prep ; -- guess-p-verb
lin catch_up_in_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_in_Prep ; -- guess-p-verb
lin catch_up_on_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin catch_up_with_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin catcher_N = mkN "แคทเชอร์" | mkN "ตำแหน่งแคทเชอร์" | mkN "คนจับ" | mkN "สิ่งที่จับ" ; -- src=panlex
lin catching_N = mkN "การตรวจหา" | mkN "การติดโรค" | mkN "การตรวจค้น" | mkN "การติดเชื้อ" | mkN "การรับเชื้อ" | mkN "การได้รับเชื้อ" | mkN "การเล่นตำแหน่งแคตเชอร์" | mkN "การเล่นตำแหน่งผู้รับลูก" ; -- src=panlex
lin catchment_N = mkN "ที่กักน้ํา" | mkN "อ่างกักน้ํา" | mkN "น้ําที่กักไว้" | mkN "การเก็บกักน้ํา" | mkN "สิ่งที่ใช้เก็บกักน้ํา เช่น อ่างเก็บน้ํา" ; -- src=panlex
lin catchpenny_A = mkA "ที่มีราคาถูกทําให้ขายได้ง่าย" ; -- src=panlex
lin catchphrase_N = mkN "วลีที่พูดหรือใช้กันแพร่หลาย" ; -- src=panlex
lin catchup_N = mkN "ซอสมะเขือเทศ" ; -- src=panlex
lin catchword_N = mkN "คำขวัญ" | mkN "คําขวัญ" | mkN "คํานําหน้า" | mkN "คําอ้างอิง" | mkN "คําหัวข้อของพจนานุกรม" | mkN "คําพูดหรือวลีที่เป็นที่นิยมมักจะอยู่ในช่วงเวลาหนึ่ง" ; -- src=panlex
lin catchy_A = mkA "ซึ่งดึงดูดความสนใจ" | mkA "ที่โกง" | mkA "ล่อลวง" | mkA "มีเล่ห์" | mkA "ดึงดูดใจ" | mkA "เป็นพักๆ" | mkA "น่าดึงดูด" | mkA "จําได้ง่าย" | mkA "ที่หลอกลวง" | mkA "ที่จําได้ง่าย" | mkA "ไม่ปะติดปะต่อ" | mkA "ประเดี๋ยวเดียว" ; -- src=panlex
lin catechesis_N = mkN "การเทศนาสอน" | mkN "การเทศน์สอน" ; -- src=panlex
lin catechetical_A = mkA "เกี่ยวกับวิธีการสอนโดยการถามและการตอบ" ; -- src=panlex
lin catechin_N = mkN "คาเตชิน" ; -- src=panlex
lin catechism_N = mkN "ปุจฉาวิสัชนา" | mkN "วิธีการสอนแบบคําถามคําตอบ" | mkN "คําถามและคําตอบที่ใช้ในการสอนถึงหลักการของศาสนาคริสต์" ; -- src=panlex
lin catechismal_A = mkA "เกี่ยวกับคำถามตอบที่สรุปหลักคำสอน" ; -- src=panlex
lin catechistic_A = mkA "เกี่ยวกับคำถามตอบที่ใช้สอนศาสนา" ; -- src=panlex
lin catecholamine_N = mkN "แคทีโคลามีน" ; -- src=panlex
lin catechu_N = mkN "ต้นแบล็คแคทอีชู" ; -- src=panlex
lin categorial_A = mkA "สมบูรณ์" | mkA "แน่ชัด" | mkA "สมบูรณ์" | mkA "เด็ดขาด" | mkA "ไม่มีเงื่อนไข" ; -- src=panlex
lin categoric_A = mkA "เกี่ยวกับการจำแนกเป็นประเภท" ; -- src=panlex
lin categorical_A = mkA "เกี่ยวกับการจำแนกเป็นประเภท" ; -- src=panlex
lin categorization_N = mkN "ประเภท" | mkN "การจัดกลุ่ม" | mkN "การจำแนกประเภท" | mkN "การแบ่งนิวเคลียส" ; -- src=panlex
lin category_N = mkN "คลาส" | mkN "ประเภท" | mkN "หมวด" | mkN "หมู่" | mkN "ประเภท" | mkN "ปริมณฑล" | mkN "หมวดหมู่" | mkN "ลําดับขั้น" ; -- src=panlex
lin catena_N = mkN "แคทีนา" | mkN "อนุกรมที่ติดต่อกัน" ; -- src=panlex
lin catenary_N = mkN "แคทีนารี" ; -- src=panlex
lin catenulate_A = mkA "ที่เหมือนโซ่" ; -- src=panlex
lin cater_V = mkV "จัดให้" | mkV "จัดเตรียม" | mkV "เตรียมอาหารไว้เลี้ยง" | mkV "จัดหาให้" | mkV "จัดเตรียมให้" ; -- src=panlex
lin caterer_N = mkN "คนที่ขายหรือให้บริการด้านอาหาร" ; -- src=panlex
lin catering_N = mkN "การจัดเลี้ยงอาหาร" ; -- src=panlex
lin caterpillar_N = mkN "หนอนผีเสื้อ" | mkN "รถแทรกเตอร์" | mkN "หนอนผีเสื้อ" | mkN "หนอนผีเสื้อราตรี" | mkN "คนที่รีดไถจากผู้อื่น" ; -- src=panlex
lin caterwaul_N = mkN "เสียงหง่าวๆ" ; -- src=panlex
lin caterwaul_V = mkV "ร้องหง่าวๆ" | mkV "ส่งเสียงดังน่ารําคาญเหมือนแมว" ; -- src=panlex
lin catfish_N = mkN "ปลามัดแคช" | mkN "ปลาแคตฟิช" | mkN "ปลาวูลฟ์ฟิช" | mkN "เนื้อปลามัดแคช" | mkN "เนื้อปลาแคตฟิช" | mkN "ปลาดุก" | mkN "ปลาประเภทมีหนวดรอบปากและไร้เกล็ด" ; -- src=panlex
lin catgut_N = mkN "สายเอ็น" | mkN "เอ็นเย็บบาดแผล" | mkN "เอ็นที่ทําจากไส้แกะใช้ในเครื่องดนตรีประเภทสาย" ; -- src=panlex
lin catharsis_N = mkN "การถ่ายท้อง" | mkN "การปลดปล่อยอารมณ์" | mkN "การถ่าย" | mkN "การระบายท้อง" ; -- src=panlex
lin cathartic_N = mkN "ยาถ่าย" | mkN "ยาระบาย" ; -- src=panlex
lin cathedra_N = mkN "บัลลังก์บิชอป" ; -- src=panlex
lin cathedral_N = mkN "มหาวิหาร" | mkN "โบสถ์ใหญ่" | mkN "โบสถ์สำคัญ" | mkN "บารมี" | mkN "เกียรติคุณ" | mkN "เป็นทางการ" | mkN "โบสถ์ที่สําคัญ" ; -- src=panlex
lin catheter_N = mkN "สายสวน" | mkN "สายหรือท่อที่สอดเข้าไปในร่างกายเพื่อเอาของเหลวออกมา" ; -- src=panlex
lin catheterization_N = mkN "การใช้หลอดสวน" ; -- src=panlex
lin cathode_N = mkN "แคโทด" | mkN "ขั้วลบ" | mkN "ขั้วลบ" | mkN "ขั้วบวก" ; -- src=panlex
lin cathodic_A = mkA "ทางแคโทด" ; -- src=panlex
lin catholicFem_N = variants {} ; ---- sense to be split
lin catholicMasc_N = variants {} ; ---- sense to be split
lin catholic_A = mkA "ใจกว้าง" | mkA "กว้างขวาง" | mkA "โดยทั่วไป" | mkA "โอบอ้อมอารี" | mkA "ที่กว้างขวางทั่วไป" ; -- src=panlex
lin catholicism_N = mkN "การแพร่หลาย" | mkN "ความมีใจกว้าง" | mkN "การมีอยู่ทั่วไป" ; -- src=panlex
lin catholicity_N = mkN "ความเป็นคาธอลิก" ; -- src=panlex
lin cation_N = mkN "แคตไออน" | mkN "ไอออนบวก" | mkN "อะตอมหรือกลุ่มอะตอมที่มีประจุบวก" ; -- src=panlex
lin cationic_A = mkA "เกี่ยวกับไอออนบวก" ; -- src=panlex
lin catkinate_A = mkA "คล้ายดอกที่ช่อยาวลงมา" ; -- src=panlex
lin catmint_N = mkN "ต้นแคตมินต์" ; -- src=panlex
lin catoptric_A = mkA "เกี่ยวกับแสงสะท้อนหรือกระจก" ; -- src=panlex
lin catostomid_N = mkN "ปลาคาทอสโตมิด" ; -- src=panlex
lin catsup_N = mkN "ซอสมะเขือเทศ" | mkN "ซอสมะเขือเทศ" ; -- src=panlex
lin cattail_N = mkN "ต้นแคตเทล" | mkN "พืชคล้ายต้นอ้อ" ; -- src=panlex
lin cattalo_N = mkN "โคพันธุ์บีฟาโล" | mkN "โคเนื้อพันธุ์บีฟาโล" ; -- src=panlex
lin cattiness_N = mkN "การมุ่งร้าย" ; -- src=panlex
lin cattish_A = mkA "อํามหิต" | mkA "กลับกลอก" | mkA "คล้ายแมว" | mkA "โหดเหี้ยม" ; -- src=panlex
lin cattle_N = mkN "วัวควาย" | mkN "สัตว์" | mkN "คนชั่ว" | mkN "วัวควาย" | mkN "ปศุสัตว์" ; -- src=panlex
lin cattleman_N = mkN "โคบาล" | mkN "คาวบอย" | mkN "คนเลี้ยงวัว" | mkN "คนเลี้ยงวัวควาย" | mkN "คนเลี้ยงปศุสัตว์" | mkN "คนที่ทําอาชีพปศุสัตว์" ; -- src=panlex
lin cattleship_N = mkN "เรือปศุสัตว์" | mkN "เรือบรรทุกปศุสัตว์" ; -- src=panlex
lin cattleya_N = mkN "กล้วยไม้จําพวกคัทลียา" ; -- src=panlex
lin catty_A = mkA "อํามหิต" | mkA "กลับกลอก" | mkA "คล้ายแมว" | mkA "เหมือนแมว" | mkA "โหดเหี้ยม" | mkA "ปลิ้นปล้อน" ; -- src=panlex
lin catwalk_N = mkN "แคตวอล์ก" | mkN "ทางเดินที่แคบ" ; -- src=panlex
lin caucasianFem_N = variants {} ; ---- sense to be split
lin caucasianMasc_N = variants {} ; ---- sense to be split
lin caucasian_A = mkA "ชาวผิวขาว" | mkA "ภาษาคอเคเซียน" ; -- src=panlex
lin caucus_N = mkN "คอคัส" ; -- src=panlex
lin cauda_N = mkN "สิ่งคล้ายหาง" | mkN "หางหรือส่วนที่คล้ายหาง" ; -- src=panlex
lin caudal_A = mkA "ที่เหมือนหาง" | mkA "เกี่ยวกับหาง" | mkA "ที่เกี่ยวกับหาง" ; -- src=panlex
lin caudate_A = mkA "ที่มีหาง" | mkA "ยาวคล้ายหาง" | mkA "ซึ่งมีหาง" | mkA "ซึ่งมีส่วนยื่นคล้ายหาง" ; -- src=panlex
lin caul_N = mkN "เยื่อหุ้มเอ็มบริโอนิก" | mkN "ส่วนของถุงน้ําครําที่ปกคลุมศีรษะ" ; -- src=panlex
lin cauldron_N = mkN "คอลเดรน" | mkN "หม้อต้มขนาดใหญ่" ; -- src=panlex
lin caulescent_A = mkA "ซึ่งมีก้าน" ; -- src=panlex
lin cauliflower_N = mkN "ดอกกะหล่ำ" | mkN "ต้นกะหล่ําดอก" ; -- src=panlex
lin cauline_A = mkA "ซึ่งมีก้าน" | mkA "ซึ่งเติบโตบนต้น" ; -- src=panlex
lin caulk_N = mkN "สารอุดช่อง" | mkN "วัสดุที่ใช้อุดรอยรั่ว" ; -- src=panlex
lin causal_A = mkA "เป็นมูลเหตุ" | mkA "เกี่ยวกับที่มา" | mkA "เกี่ยวกับสาเหตุ" | mkA "เกี่ยวกับต้นเหตุ" ; -- src=panlex
lin causalgia_N = mkN "ความเจ็บแสบร้อนมาก" ; -- src=panlex
lin causality_N = mkN "ปัจจัยภาพ" | mkN "สิ่งที่เป็นสาเหตุ" | mkN "ความสัมพันธ์ระหว่างเหตุและผล" | mkN "คุณสมบัติที่ทําให้เป็นสาเหตุได้" ; -- src=panlex
lin causation_N = mkN "เหตุกรรม" | mkN "การทำให้เกิด" | mkN "สาเหตุ" | mkN "สิ่งทําให้เกิดผล" | mkN "การทําให้เกิดขึ้น" | mkN "ความสัมพันธ์ระหว่างเหตุผล" | mkN "การเป็นสาเหตุให้เกิดผลขึ้น" ; -- src=panlex
lin causative_A = mkA "ที่เป็นสาเหตุ" | mkA "เป็นเหตุ" | mkA "ทําให้เกิดผล" | mkA "กลายเป็นสาเหตุ" | mkA "ก่อให้เกิดขึ้น" ; -- src=panlex
lin cause_N = mkN "สาเหตุ" | mkN "คดีความ" | mkN "มูลเหตุ" | mkN "การรณรงค์" | mkN "การดำเนินคดี" | mkN "ผู้เป็นสาเหตุ" | mkN "ผู้กระทำเหตุการณ์" | mkN "ผู้ก่อให้เกิดเหตุการณ์" | mkN "สาเหตุ" | mkN "เหตุผลที่ดี" | mkN "เหตุผลที่เหมาะ" | mkN "หัวเรื่องของการอภิปราย" ; -- src=panlex
lin causeless_A = mkA "ที่ปราศจากเหตุผล" ; -- src=panlex
lin causerie_N = mkN "การพูดพร่ำ" | mkN "การพูดซุบซิบ" | mkN "การสนทนา" | mkN "การพูดคุย" | mkN "บทความสั้น ๆ" ; -- src=panlex
lin causeway_N = mkN "ถนนข้ามแหล่งน้ำ" | mkN "ถนนหรือทางที่ข้ามแหล่งน้ํา" ; -- src=panlex
lin causing_N = mkN "เหตุกรรม" | mkN "การทำให้เกิด" ; -- src=panlex
lin caustic_A = mkA "ที่แสบสัน" | mkA "กัดกร่อน" | mkA "ถากถางมาก" | mkA "ซึ่งถากถาง" | mkA "ทําให้ไหม้" | mkA "ซึ่งสามารถทําลายหรือกัดกร่อนได้" ; -- src=panlex
lin caustic_N = mkN "คอสติก" | mkN "สารละลาย" | mkN "สารที่ใช้ละลายสารอื่น" ; -- src=panlex
lin cautery_N = mkN "การห้ามเลือด" | mkN "สารกัดกร่อน" | mkN "กระบวนหรือสิ่งที่การทําให้เนื้อเยื่อไหม้" ; -- src=panlex
lin caution_N = mkN "คำเตือน" | mkN "การเตือน" | mkN "ความระวัง" | mkN "ความรอบคอบ" | mkN "การระมัดระวัง" | mkN "ความระมัดระวัง" | mkN "การตักเตือน" | mkN "ความระมัดระวัง" ; -- src=panlex
lin caution_V = mkV "เตือน" | mkV "เตือน" | mkV "แนะนํา" ; -- src=panlex
lin caution_V2 = mkV2 "เตือน" ; ---- | mkV "เตือน" | mkV "แนะนํา" ; -- src=panlex
lin caution_V2V = mmkV2V "เตือน" ; ---- | mkV "เตือน" | mkV "แนะนํา" ; -- src=panlex
lin caution_VS = mmkVS "เตือน" ; ---- | mkV "เตือน" | mkV "แนะนํา" ; -- src=panlex
lin cautionary_A = mkA "ที่ให้คําแนะนําหรือคําเตือน" ; -- src=panlex
lin cautious_A = mkA "รอบคอบ" | mkA "ระมัดระวัง" ; -- src=panlex
lin cavalcade_N = mkN "ริ้วขบวน" | mkN "ขบวน" | mkN "ขบวนแห่" | mkN "ขบวนคนขี่ม้า" | mkN "ขบวนม้าหรือยานพาหนะในพิธี" ; -- src=panlex
lin cavalier_N = mkN "สุภาพบุรุษ" | mkN "แคเวอเลียร์" | mkN "จองหอง" | mkN "ทหารม้า" | mkN "ขี้ประจบ" | mkN "คนขี่ม้า" | mkN "คนเจ้าชู้" | mkN "มีใจอิสระ" | mkN "หยิ่งยะโส" | mkN "มีใจนักเลง" | mkN "นักรบบนหลังม้า" | mkN "อัศวินที่ขี่ม้า" | mkN "สุภาพบุรุษที่ชอบเอาใจสตรี" ; -- src=panlex
lin cavalry_N = mkN "ทหารม้า" | mkN "กองทหารม้า" | mkN "ทหารม้า" | mkN "กองทหารม้า" | mkN "เหล่าทหารม้า" | mkN "กลุ่มคนขี่ม้า" | mkN "กองทหารยานเกราะ" ; -- src=panlex
lin cavalryman_N = mkN "ทหารม้า" | mkN "ทหารม้า" ; -- src=panlex
lin cave_N = mkN "ถ้ำ" | mkN "ถ้ำ" | mkN "ถ้ํา" | mkN "โพรง" | mkN "อุโมงค์" | mkN "ห้องเก็บของใต้ดิน" ; -- src=panlex
lin cave_V = mkV "สำรวจถ้ำ" | mkV "ขุดอุโมงค์" | mkV "ทําให้เป็นโพรง" ; -- src=panlex
lin cave_V2 = mkV2 "สำรวจถ้ำ" ; ---- | mkV "ขุดอุโมงค์" | mkV "ทําให้เป็นโพรง" ; -- src=panlex
lin caveat_N = mkN "คำเตือน" | mkN "การเตือน" | mkN "หมายเตือน" | mkN "คําเตือนเพื่อให้พิจารณาก่อนทําสิ่งใดสิ่งหนึ่งจะได้ไม่ผิดพลาด" ; -- src=panlex
lin caveman_N = mkN "มนุษย์ถ้ำ" | mkN "มนุษย์ในยุคหินที่อาศัยอยู่ในถ้ํา" ; -- src=panlex
lin cavern_N = mkN "ถ้ำหลวง" | mkN "คูหา" | mkN "ถ้ํา" ; -- src=panlex
lin cavernous_A = mkA "กลวง" | mkA "ผุมาก" | mkA "มีรูมาก" | mkA "เป็นโพรง" | mkA "มีถ้ํามาก" | mkA "ที่เป็นโพรงใหญ่และมืด" ; -- src=panlex
lin caviar_N = mkN "คาเวียร์" | mkN "น้ําปลา" | mkN "ไข่ปลาคาร์เวียร์" ; -- src=panlex
lin cavil_V = mkV "คัดค้าน" | mkV "พยายามจับผิด" | mkV "หาข้อผิดพลาดเล็กๆ น้อยๆ" ; -- src=panlex
lin cavity_N = mkN "ช่อง" | mkN "หลุม" | mkN "โพรง" | mkN "อาการฟันผุ" | mkN "รู" | mkN "ถ้ํา" | mkN "หลุม" | mkN "แอ่ง" | mkN "โพรง" ; -- src=panlex
lin cavort_V = mkV "กระโดดโลดเต้น" | mkV "กระโดดโลดเต้น" ; -- src=panlex
lin cavy_N = mkN "เควี" ; -- src=panlex
lin caw_N = mkN "เสียงกา" | mkN "เสียงร้องของอีกาหรือนกจําพวกอีกา" ; -- src=panlex
lin caw_V = mkV "ร้องกาๆ" | mkV "ร้องเสียงกาๆ" ; -- src=panlex
lin caw_V2 = mkV2 "ร้องกาๆ" ; ---- | mkV "ร้องเสียงกาๆ" ; -- src=panlex
lin cayenne_N = mkN "ต้นพริก" | mkN "พริกคาเยน" ; -- src=panlex
lin cayman_N = mkN "จระเข้เคแมน" ; -- src=panlex
lin cayuse_N = mkN "ม้าอินเดียนโพนี" ; -- src=panlex
lin cc_N = mkN "มล." | mkN "ซีซี" | mkN "มิลลิลิตร" ; -- src=panlex
lin cd_N = mkN "แคนเดลา" | mkN "กำลังแรงเทียน" ; -- src=panlex
lin cease_N = mkN "การสิ้นสุด" | mkN "การจบ" | mkN "การยุติ" | mkN "การหยุด" | mkN "การสิ้นสุด" ; -- src=panlex
lin cease_V = mkV "จบ" | mkV "ยุติ" | mkV "หยุด" | mkV "อวสาน" | mkV "สิ้นสุด" | mkV "จบ" | mkV "ยุติ" | mkV "หยุด" | mkV "เลิก" | mkV "สิ้นสุด" ; -- src=panlex
lin cease_V2 = mkV2 "จบ" ; ---- | mkV "ยุติ" | mkV "หยุด" | mkV "อวสาน" | mkV "สิ้นสุด" | mkV "จบ" | mkV "ยุติ" | mkV "หยุด" | mkV "เลิก" | mkV "สิ้นสุด" ; -- src=panlex
lin ceasefire_N = mkN "การหยุดรบ" | mkN "การหยุดนิ่ง" ; -- src=panlex
lin ceaseless_A = mkA "ที่ไม่หยุด" | mkA "ไม่สิ้นสุด" | mkA "ไม่รู้จักจบ" | mkA "ไม่มีที่สิ้นสุด" ; -- src=panlex
lin cecum_N = mkN "ลำไส้ใหญ่ส่วนต้น" ; -- src=panlex
lin cedar_N = mkN "ต้นซีดาร์" | mkN "ไม้ซีดาร์" ; -- src=panlex
lin cedarn_A = mkA "ไม้ซีดาร์" ; -- src=panlex
lin cedi_N = mkN "เซดิ" ; -- src=panlex
lin cefadroxil_N = mkN "เซฟาดรอกซิล" ; -- src=panlex
lin cefoperazone_N = mkN "เซโฟเพอราโซน" ; -- src=panlex
lin cefotaxime_N = mkN "เซโฟแทกซีม" ; -- src=panlex
lin ceftazidime_N = mkN "เซฟตาซิดีม" ; -- src=panlex
lin ceftriaxone_N = mkN "เซฟไตรอะโซน" ; -- src=panlex
lin cefuroxime_N = mkN "เซฟูรอกซิม" ; -- src=panlex
lin ceibo_N = mkN "ต้นเซย์โบ" ; -- src=panlex
lin ceilidh_N = mkN "การจับกลุ่มร้องเพลง" ; -- src=panlex
lin ceiling_N = mkN (thword "เพ" "ดาน") | {-pan-} mkN "เพดาน" | mkN "เพดานบิน" | mkN "เพดานเมฆ" | mkN "ขีดสูงสุด" | mkN "เพดานสูงสุด" | mkN "เพดาน" | mkN "ดาดฟ้า" | mkN "การกรุผนัง" | mkN "การกรุฝาผนัง" | mkN "สิ่งที่ใช้กรุผนัง" ; -- src=panlex ----?
lin ceilinged_A = mkA "ที่มีเพดาน" ; -- src=panlex
lin celandine_N = mkN "ต้นเซแลนดีน" ; -- src=panlex
lin celebrant_N = mkN "ผู้เฉลิมฉลอง" | mkN "ผู้ประกอบพิธีทางคริสต์ศาสนา" | mkN "ผู้ร่วมการฉลอง" | mkN "ผู้ร่วมพิธีศาสนา" | mkN "ผู้สรรเสริญคนที่ตายไปแล้ว" ; -- src=panlex
lin celebrated_A = mkA "ที่มีชื่อเสียง" | mkA "โด่งดัง" | mkA "ที่มีชื่อเสียง" | mkA "มีชื่อเสียงดัง" ; -- src=panlex
lin celebration_N = mkN "พิธีการ" | mkN "การเฉลิมฉลอง" | mkN "งานเฉลิมฉลอง" | mkN "การฉลอง" | mkN "งานฉลอง" | mkN "งานมงคล" | mkN "งานสมโภช" | mkN "งานเลี้ยง" | mkN "งานรื่นเริง" | mkN "งานสังสรรค์" | mkN "การเฉลิมฉลอง" | mkN "งานกินเลี้ยง" | mkN "งานเฉลิมฉลอง" | mkN "งานพบปะสังสรรค์" ; -- src=panlex
lin celebratory_A = mkA "ซึ่งใช้เฉลิมฉลอง" ; -- src=panlex
lin celebrity_N = mkN "ชื่อเสียง" | mkN "กิตติศัพท์" | mkN "คนมีชื่อเสียง" | mkN "ผู้มีชื่อเสียง" | mkN "ความมีชื่อเสียง" | mkN "ชื่อเสียง" | mkN "ความโด่งดัง" | mkN "ผู้โ่ด่งดัง" | mkN "ผู้มีชื่อเสียง" | mkN "ความมีชื่อเสียง" | mkN "บุคคลผู้มีชื่อเสียง" ; -- src=panlex
lin celecoxib_N = mkN "ซีลีค็อกซิบ" ; -- src=panlex
lin celeriac_N = mkN "ผักขึ้นฉ่าย" | mkN "หัวขึ้นฉ่ายฝรั่ง" ; -- src=panlex
lin celerity_N = mkN "ความเร็ว" | mkN "ความรวดเร็ว" | mkN "ความเร็ว" | mkN "ความว่องไว" ; -- src=panlex
lin celery_N = mkN "ขึ้นฉ่าย" | mkN "ผักขึ้นฉ่าย" | mkN "ผักชี" | mkN "ผักคึ่นช่าย" ; -- src=panlex
lin celesta_N = mkN "คีย์บอร์ด" ; -- src=panlex
lin celestial_A = mkA "สวรรค์" | mkA "แห่งสวรรค์" | mkA "แห่งท้องฟ้า" | mkA "เกี่ยวกับสวรรค์" | mkA "เกี่ยวกับท้องฟ้า" | mkA "ซึ่งมาจากสรวงสวรรค์" ; -- src=panlex
lin celestite_N = mkN "เซลีสไทต์" | mkN "แร่เซลีสไทต์" ; -- src=panlex
lin celiac_A = mkA "เกี่ยวกับโพรงหรือช่องท้อง" ; -- src=panlex
lin celibacy_N = mkN "การเป็นโสด" | mkN "การถือพรหมจรรย์" | mkN "ชีวิตโสด" | mkN "การเป็นโสด" | mkN "ความเป็นโสด" | mkN "การละเว้นจากการร่วมเพศ" | mkN "ภาวะที่ยังไม่ได้แต่งงาน" ; -- src=panlex
lin celibate_N = mkN "ผู้ถือพรหมจรรย์" | mkN "ผู้ประพฤติพรหมจรรย์" | mkN "เกี่ยวกับการให้คําสาบานว่าจะไม่แต่งงาน" ; -- src=panlex
lin celiocentesis_N = mkN "การเจาะท้อง" ; -- src=panlex
lin celioma_N = mkN "เนื้องอกในช่องท้อง" ; -- src=panlex
lin cell_N = mkN "คุก" | mkN "กุฏิ" | mkN "ซังเต" | mkN "เซลล์" | mkN "มือถือ" | mkN "ห้องขัง" | mkN "โมบายโฟน" | mkN "หน่วยย่อย" | mkN "มุ้งสายบัว" | mkN "ห้องคุมขัง" | mkN "เซลล์ไฟฟ้า" | mkN "โทรศัพท์มือถือ" | mkN "โทรศัพท์ติดตามตัว" | mkN "โทรศัพท์เคลื่อนที่" | mkN "กุฎิ" | mkN "ตลับ" | mkN "กล่อง" | mkN "เซลล์" | mkN "ห้องเล็ก ๆ" | mkN "ห้องเล็กๆ" | mkN "กลุ่มเล็ก ๆ" | mkN "ช่องหนึ่ง ๆ ในหม้อแบตเตอรี่" | mkN "เซลล์ไฟฟ้า" | mkN "ช่องในรังผึ้ง" | mkN "ห้องขังนักโทษ" | mkN "โพรงหรือช่องเล็กๆ" | mkN "อุปกรณ์กําเนิดไฟฟ้า" | mkN "หน่วยเล็กๆในหน่วยใหญ่ เช่น กลุ่มเล็กๆในพรรคการเมือง" | mkN "หน่วยพื้นฐานของสิ่งมีชีวิต" ; -- src=panlex
lin cellar_N = mkN "ชั้นใต้ดิน" | mkN "ห้องใต้ดิน" | mkN "ห้องเก็บไวน์" | mkN "หลุมใต้ดิน" | mkN "ห้องใต้ดิน" | mkN "ปริมาณเหล้าที่เก็บ" | mkN "ห้องเก็บเหล้าใต้ดิน" ; -- src=panlex
lin cellarage_N = mkN "หลุมใต้ดิน" | mkN "ห้องใต้ดิน" | mkN "ปริมาณเหล้าที่เก็บ" | mkN "ห้องเก็บเหล้าใต้ดิน" | mkN "ค่าธรรมเนียมสําหรับการเก็บของในห้องเก็บของ" ; -- src=panlex
lin cellblock_N = mkN "ตึกในคุกที่ประกอบด้วยห้องขังเป็นห้อง ๆ" ; -- src=panlex
lin cellistFem_N = variants {} ; ---- sense to be split
lin cellistMasc_N = variants {} ; ---- sense to be split
lin cello_N = mkN "เชลโล" ; -- src=panlex
lin cellophane_N = mkN "กระดาษแก้ว" | mkN "กระดาษใสใช้ห่อของหรืออาหาร" ; -- src=panlex
lin cellular_A = mkA "พรุน" | mkA "เกี่ยวกับเซลล์" | mkA "เกี่ยวกับเซลล์" | mkA "ที่ประกอบด้วยเซลล์" | mkA "เกี่ยวกับโทรศัพท์เซลลูล่าร์" ; -- src=panlex
lin cellulite_N = mkN "ไขมันใต้ผิวหนัง" | mkN "ประเภทของไขมันที่อยู่ใต้ผิวหนังทําให้ผิวหนังดูไม่เรียบ" ; -- src=panlex
lin cellulitis_N = mkN "การอักเสบของเนื้อเยื่อ" ; -- src=panlex
lin celluloid_A = mkA "เกี่ยวกับภาพยนตร์" ; -- src=panlex
lin celluloid_N = mkN "ฟิลม์" | mkN "แผ่นฟิลม์" | mkN "เซลลูลอยด์" | mkN "ภาพยนตร์" | mkN "พลาสติกชนิดหนึ่ง ใช้ในการทําฟิล์มหรือสิ่งของอื่นๆ" ; -- src=panlex
lin cellulose_N = mkN "เซลลูโลส" | mkN "เซลลูโลส" | mkN "สารประกอบคาร์โบไฮเดรตชนิดหนึ่ง" ; -- src=panlex
lin cellulosic_N = mkN "เซลลูโลสิก" ; -- src=panlex
lin cellulosid_A = mkA "ซึ่งทำจากเซลลูโลส" ; -- src=panlex
lin celom_N = mkN "ช่องในตัวอ่อน" | mkN "ช่องในตัวอ่อน" | mkN "ช่องในร่างกายระหว่างผนังร่างกายกับลําไส้" ; -- src=panlex
lin celt_N = mkN "ชาวเซลท์ที่อยู่ในหมู่เกาะอังกฤษ" ; -- src=panlex
lin celtuce_N = mkN "เซลทัส" ; -- src=panlex
lin cement_N = mkN "ปูน" | mkN "ซิเมนต์" | mkN "ซีเมนต์" | mkN "ปูนอุดฟัน" | mkN "ปูนซิเมนต์" | mkN "ปูนซีเมนต์" | mkN "วัตถุประสาน" | mkN "ปูนซีเมนต์" | mkN "ปูนสําหรับอุดฟัน" | mkN "สิ่งที่ทําให้ติดกัน" | mkN "สิ่งทําให้ผูกพันกัน" ; -- src=panlex
lin cementite_N = mkN "ไอรอนคาร์ไบด์" ; -- src=panlex
lin cementitious_A = mkA "ที่เป็นซีเมนต์" ; -- src=panlex
lin cemetery_N = mkN "สุสาน" | mkN "ป่าช้า" | mkN "ที่ฝังศพ" | mkN "สถานที่ฝังศพ" | mkN "สุสาน" ; -- src=panlex
lin cenotaph_N = mkN "อนุสาวรีย์" | mkN "อนุสาวรีย์" | mkN "อนุสาวรีย์ที่ระลึกถึงผู้ตายซึ่งเสียชีวิตในที่อื่น" ; -- src=panlex
lin censer_N = mkN "ภาชนะเผากำยาน" | mkN "กระถางธูป" | mkN "กระถางรูป" | mkN "ภาชนะเผาเครื่องกํายาน" ; -- src=panlex
lin censor_N = mkN "เซ็นเซอร์" | mkN "ฝ่ายตรวจสอบ" | mkN "กองเซ็นเซอร์" | mkN "ฝ่ายเซ็นเซอร์" | mkN "คนจับผิด" | mkN "เซนเซอร์" | mkN "ตัดตอนแก้ไข" | mkN "เจ้าหน้าที่จับผิด" | mkN "เจ้าหน้าที่ตรวจสอบ" | mkN "ผู้ควบคุมความประพฤติ" | mkN "เจ้าหน้าที่ดูแลมหาวิทยาลัย" ; -- src=panlex
lin censorial_A = mkA "ที่ทำหน้าที่เซ็นเซอร์" | mkA "ที่ตรวจสอบ" ; -- src=panlex
lin censoring_N = mkN "การตรวจสอบ" | mkN "การเซ็นเซอร์" ; -- src=panlex
lin censorious_A = mkA "จับผิด" | mkA "หาเรื่อง" | mkA "วิพากษ์วิารณ์อย่างรุนแรง" | mkA "ที่พยายามมองหาข้อผิดพลาดอยู่เสมอ" ; -- src=panlex
lin censorship_N = mkN "การตรวจสอบ" | mkN "การเซ็นเซอร์" | mkN "การตรวจสอบ" | mkN "การเซนเซอร์" | mkN "การเซ็นเซอร์" | mkN "อํานาจการตรวจสอบ" | mkN "การตรวจสอบสื่อต่างๆ เพื่อตัดส่วนที่ไม่เหมาะสมออก" | mkN "พลังจิตข่มซ่อนเร้นอยู่ในใจ" | mkN "ตําแหน่งเจ้าหน้าที่ตรวจสอบยับยั้ง" ; -- src=panlex
lin censure_N = mkN "การแยกออก" | mkN "การขับไล่ออก" | mkN "การวิพากษ์วิจารณ์" | mkN "การตําหนิ" | mkN "การติเตียน" ; -- src=panlex
lin census_N = mkN "การทำสำมะโนประชากร" | mkN "การสำรวจสำมะโนครัว" | mkN "การสำรวจสำมะโนประชากร" | mkN "การสํารวจจํานวนประชากร" ; -- src=panlex
lin cent_N = mkN "เซนต์" | mkN "เหรียญเพนนี" | mkN "เหรียญที่มีค่าหนึ่งในร้อยของหน่วยเงินตรา" | mkN "1/100 ของหน่วยเงินตราในหลายประเทศ" ; -- src=panlex
lin centas_N = mkN "เซนแทส" ; -- src=panlex
lin centaur_N = mkN "เซนทอร์" | mkN "มนุษย์ในเทพนิยายกรีกที่มีครึ่งบนเป็นคนส่วนครึ่งล่างเป็นม้า" ; -- src=panlex
lin centaury_N = mkN "เซ็นชัวรี่" | mkN "ต้นเซนทอรี่" ; -- src=panlex
lin centavo_N = mkN "เซนตาโว" ; -- src=panlex
lin centenarian_A = mkA "ที่มีอายุร้อยปี" ; -- src=panlex
lin centenarian_N = mkN "คนอายุ 100 ปีขึ้นไป" | mkN "ผู้ที่มีอายุตั้งแต่หนึ่งร้อยปีขึ้นไป" ; -- src=panlex
lin centenary_A = mkA "ครบร้อยปี" | mkA "ที่หนึ่งร้อย" | mkA "ครบหนึ่งร้อยปี" | mkA "เกี่ยวกับร้อยปี" | mkA "ที่เกี่ยวกับศตวรรษ" ; -- src=panlex
lin centenary_N = mkN "วันครบรอบหนึ่งร้อยปี" | mkN "วาระครบรอบหนึ่งร้อยปี" | mkN "วาระครบรอบ 100 ปี" | mkN "การครบรอบหนึ่งร้อยปี" ; -- src=panlex
lin centennial_A = mkA "ครบร้อยปี" | mkA "ที่หนึ่งร้อย" | mkA "ครบหนึ่งร้อยปี" | mkA "ที่ครบรอบร้อยปี" | mkA "ที่ยืนยาวหนึ่งร้อยปี" | mkA "เกี่ยวกับหนึ่งร้อยปี" | mkA "ที่เกิดครั้งเดียวในร้อยปี" ; -- src=panlex
lin centennial_N = mkN "วันครบรอบหนึ่งร้อยปี" | mkN "วาระครบรอบหนึ่งร้อยปี" | mkN "วาระครบรอบ 100 ปี" | mkN "การครบรอบหนึ่งร้อยปี" ; -- src=panlex
lin center_A = mkA "ซึ่งเป็นกลาง" | mkA "กลาง" ; -- src=panlex
lin centerfold_N = mkN "หน้าพับ" | mkN "หน้ากระดาษคู่ที่อยู่ตรงกลางหนังสือ" | mkN "รูปเปลือยของชายหรือหญิงที่อยู่ตรงกลางนิตยสาร" ; -- src=panlex
lin centering_N = mkN "การสแนป" | mkN "การจดจ่อ" | mkN "การโฟกัส" | mkN "การเพ่งสมาธิ" | mkN "การเพ่งความสนใจ" ; -- src=panlex
lin centerline_N = mkN "เซ็นเตอร์ไลน์" | mkN "เส้นเซ็นเตอร์ไลน์" ; -- src=panlex
lin centesimal_A = mkA "ที่หนึ่งร้อย" | mkA "ที่แบ่งเป็นร้อยส่วน" | mkA "ที่ 100" | mkA "ที่แบ่งเป็นหนึ่งร้อยส่วน" | mkA "ที่อยู่ในลําดับที่หนึ่งร้อย" ; -- src=panlex
lin centesimo_N = mkN "เซนตีซิโม" ; -- src=panlex
lin centigrade_A = mkA "เซนติเกรด" | mkA "เซนติเกรด" | mkA "หน่วยวัดอุณหภูมิความร้อน" ; -- src=panlex
lin centiliter_N = mkN "เซนติลิตร" | mkN "เซนติลิตร" | mkN "หน่วยวัดเท่ากับหนึ่งในร้อยของลิตร" | mkN "1/100 ลิตร" ; -- src=panlex
lin centime_N = mkN "เซนต์" | mkN "ซองตีม" | mkN "เหรียญเพนนี" | mkN "หน่วยเงินที่มีจํานวนหนึ่งในร้อยของหน่วยเงินพื้นฐาน" ; -- src=panlex
lin centimetre_N = mkN "ซม." | mkN "เซนติเมตร" | mkN "เซนติเมตร" | mkN "หน่วยวัดเท่ากับหนึ่งในร้อยของเมตร" ; -- src=panlex
lin centimo_N = mkN "เซนติโม" ; -- src=panlex
lin centipede_N = mkN "ตะขาบ" | mkN "ตะขาบ" | mkN "จะเข็บ" ; -- src=panlex
lin centner_N = mkN "เซนต์เนอร์" | mkN "หน่วยน้ําหนัก" ; -- src=panlex
lin central_A = mkA "หลัก" | mkA "ใหญ่" | mkA "เป็นศูนย์กลาง" | mkA "สําคัญ" | mkA "ใจกลาง" | mkA "ที่สําคัญ" | mkA "ที่เป็นศูนย์กลาง" | mkA "เกี่ยวกับระบบประสาทส่วนกลาง" | mkA "ซึ่งอยู่ตรงกลางหรือใกล้ตรงกลาง" ; -- src=panlex
lin central_N = mkN "ชุมสาย" | mkN "ชุมสายโทรศัพท์" | mkN "จุดศูนย์รวมของการเชื่อมต่อสายโทรศัพท์" ; -- src=panlex
lin centralism_N = mkN "นโยบายเป็นกลางทางการเมือง" | mkN "การปกครองหรือควบคุมจากศูนย์กลาง" ; -- src=panlex
lin centralist_A = mkA "ซึ่งสนับสนุนส่วนกลาง" ; -- src=panlex
lin centralization_N = mkN "การรวมศูนย์อำนาจ" | mkN "ภาวะรวมศูนย์อํานาจบริหาร" | mkN "การรวมอํานาจมาอยู่ส่วนกลาง" | mkN "การรวมอํานาจมาอยู่ที่ศูนย์กลาง" ; -- src=panlex
lin centralize_V = mkV "รวมศูนย์" | mkV "รวมอํานาจมาศูนย์กลาง" | mkV "ทําให้มารวมที่ศูนย์กลาง" ; -- src=panlex
lin centralize_V2 = mkV2 "รวมศูนย์" ; ---- | mkV "รวมอํานาจมาศูนย์กลาง" | mkV "ทําให้มารวมที่ศูนย์กลาง" ; -- src=panlex
lin centre_N = mkN (thword "ศูนย์" "กลาง") ;
lin centre_V = mkV "จดจ่อ" | mkV "โฟกัส" | mkV "ตั้งใจ" | mkV "อยู่กลาง" | mkV "ตั้งสมาธิ" | mkV "มีสมาธิจดจ่อ" | mkV "อยู่ตรงกลาง" | mkV "อยู่กึ่งกลาง" | mkV "มุ่งความสนใจไปยัง" ; -- src=panlex
lin centre_V2 = mkV2 "จดจ่อ" ; ---- | mkV "โฟกัส" | mkV "ตั้งใจ" | mkV "อยู่กลาง" | mkV "ตั้งสมาธิ" | mkV "มีสมาธิจดจ่อ" | mkV "อยู่ตรงกลาง" | mkV "อยู่กึ่งกลาง" | mkV "มุ่งความสนใจไปยัง" ; -- src=panlex
lin centrepiece_N = mkN "เครื่องประดับกลางโต๊ะ" ; -- src=panlex
lin centric_A = mkA "อยู่ตรงศูนย์กลาง" | mkA "เกี่ยวกับศูนย์กลาง" ; -- src=panlex
lin centrifugal_A = mkA "เคลื่อนออกจากจุดศูนย์กลาง" | mkA "ซึ่งเคลื่อนที่หนีศูนย์กลาง" ; -- src=panlex
lin centrifugation_N = mkN "การหมุนเหวี่ยง" ; -- src=panlex
lin centrifuge_N = mkN "เครื่องหมุนเหวี่ยง" | mkN "เครื่องมือหมุนเหวี่ยงดังกล่าว" ; -- src=panlex
lin centripetal_A = mkA "ที่เคลื่อนที่เข้าหาจุดศูนย์กลาง" ; -- src=panlex
lin centrism_N = mkN "แนวความคิดเป็นกลาง" ; -- src=panlex
lin centrist_N = mkN "ผู้เป็นกลาง" | mkN "ผู้ไม่ฝักใฝ่ฝ่ายใด" | mkN "ผู้ไม่ฝักใฝ่ีฝ่ายใด" | mkN "ผู้ที่มีความคิดทางการเมืองเป็นกลาง" ; -- src=panlex
lin centroid_N = mkN "เซนทรอยด์" ; -- src=panlex
lin centromere_N = mkN "เซนโทรเมียร์" ; -- src=panlex
lin centrosome_N = mkN "เซนโทรโซม" ; -- src=panlex
lin centrum_N = mkN "เซนทรัม" | mkN "ศูนย์กลาง" ; -- src=panlex
lin centurion_N = mkN "ผู้คุมนายทหาร" | mkN "ผู้บังคับการทางทหารที่ควบคุมทหารหนึ่งร้อยนาย" ; -- src=panlex
lin century_N = mkN "๑๐๐" | mkN "ร้อย" | mkN "ร้อยปี" | mkN "หนึ่งร้อย" | mkN "100" | mkN "ศตวรรษ" | mkN "หนึ่งร้อยปี" | mkN "หนึ่งร้อยชิ้น" | mkN "จํานวนหนึ่งร้อย" | mkN "กองร้อยทหารโรมัน" ; -- src=panlex
lin cephalexin_N = mkN "เซฟาเลกซิน" ; -- src=panlex
lin cephalic_A = mkA "ที่เกี่ยวกับศีรษะ" ; -- src=panlex
lin cephalochordate_N = mkN "เซฟาโลคอร์เดต" ; -- src=panlex
lin cephaloglycin_N = mkN "ซีฟาโลไกลซิน" ; -- src=panlex
lin cephalopod_A = mkA "เซฟาโลพอด" ; -- src=panlex
lin cephaloridine_N = mkN "เซฟาโลริดีน" ; -- src=panlex
lin cephalosporin_N = mkN "เซฟาโลสปอริน" ; -- src=panlex
lin cephalothin_N = mkN "เซฟาโลทิน" ; -- src=panlex
lin ceramic_N = mkN "เซรามิก" | mkN "ผลิตภัณฑ์เครื่องเคลือบ" | mkN "เกี่ยวกับเครื่องเคลือบ" ; -- src=panlex
lin ceramics_N = mkN "เซรามิกส์" | mkN "เครื่องปั้นดินเผา" | mkN "ซีแรมมิค" | mkN "เครื่องเคลือบดินเผา" | mkN "ศิลปะการทําเครื่องเคลือบดินเผา" | mkN "การทําเครื่องเคลือบดินเผาหรือซีแรมมิค" ; -- src=panlex
lin cerate_N = mkN "ขี้ผึ้ง" ; -- src=panlex
lin ceratodus_N = mkN "ปลาซีราโตดัส" ; -- src=panlex
lin ceratopsian_N = mkN "ซีราทอปเซียน" ; -- src=panlex
lin ceratosaur_N = mkN "ซีราโตซอร์" ; -- src=panlex
lin ceratozamia_N = mkN "ซีราโทซาเมีย" ; -- src=panlex
lin cereal_N = mkN "ธัญพืช" | mkN "ซีเรียล" | mkN "ธัญญาหาร" | mkN "อาหารเช้าธัญพืช" | mkN "ธัญพืช" | mkN "เมล็ดธัญพืช" ; -- src=panlex
lin cerebellum_N = mkN "สมองส่วนหลัง" | mkN "สมองน้อย" | mkN "ส่วนล่างของสมอง" | mkN "ส่วนของสมองที่ควบคุมเกี่ยวกับการเคลื่อนไหวของร่างกาย" ; -- src=panlex
lin cerebral_A = mkA "เกี่ยวกับสมอง" | mkA "ที่เกี่ยวกับสมอง" ; -- src=panlex
lin cerebration_N = mkN "การคิด" | mkN "ความคิด" | mkN "การคิด" ; -- src=panlex
lin cerebrospinal_A = mkA "เกี่ยวกับสมองและไขสันหลัง" ; -- src=panlex
lin cerebrum_N = mkN "สมองส่วนหน้า" | mkN "สมองส่วนที่ใหญ่ที่สุดของมนุษย์" ; -- src=panlex
lin cerecloth_N = mkN "ผ้าห่อศพ" | mkN "ผ้าเคลือบด้วยแว๊กซ์สําหรับห่อศพ" ; -- src=panlex
lin ceremonial_A = mkA "เป็นทางการ" | mkA "เป็นพิธีการ" ; -- src=panlex
lin ceremonial_N = mkN "งาน" | mkN "พิธี" | mkN "งานพิธี" | mkN "พิธีการ" | mkN "ระบบของพิธีการ" | mkN "พฤติกรรมที่เหมาะสมและถูกกาลเทศะ" ; -- src=panlex
lin ceremonious_A = mkA "โอ่อ่า" | mkA "คร่ําครึ" | mkA "เป็นทางการ" | mkA "เป็นพิธีการ" | mkA "เป็นพิธีรีตองมาก" ; -- src=panlex
lin ceremony_N = mkN "งาน" | mkN "พิธี" | mkN "งานพิธี" | mkN "พิธีการ" | mkN "พิธี" | mkN "พิธีการ" | mkN "พิธีรีตอง" | mkN "ระเบียบแบบแผน" | mkN "ความเป็นทางการ" | mkN "ความมีระเบียบแบบแผน" | mkN "พฤติกรรมที่เป็นทางการ" ; -- src=panlex
lin ceresin_N = mkN "เซรีซิน" ; -- src=panlex
lin ceriman_N = mkN "ต้นเซริแมน" | mkN "ลูกมอนสเตร่า" ; -- src=panlex
lin cerise_A = mkA "แดง" | mkA "ที่มีสีแดงอมชมพู" | mkA "แดงปานกลางจนถึงแดงเข้ม" ; -- src=panlex
lin cerise_N = mkN "สีแดง" | mkN "สีแดงเชอร์รี่" | mkN "แดงปานกลางจนถึงแดงเข้ม" ; -- src=panlex
lin cerium_N = mkN "ซีเรียม" | mkN "ธาตุซีเรียม" | mkN "เลขอะตอม 58" | mkN "ธาตุซีเรียม" ; -- src=panlex
lin cerivastatin_N = mkN "บาคอล" | mkN "ยาบาคอล" ; -- src=panlex
lin cernuous_A = mkA "โค้งลง" ; -- src=panlex
lin cero_N = mkN "ปลาซีโร" | mkN "ปลาคิงแมกคาเรล" ; -- src=panlex
lin certain_1_A = variants {} ; ---- sense to be split
lin certain_2_A = variants {} ; ---- sense to be split
lin certainty_N = mkN "สิ่งที่แน่นอน" | mkN "ความแน่ใจ" | mkN "ความแน่นอน" | mkN "สิ่งที่แน่นอน" ; -- src=panlex
lin certifiable_A = mkA "ซึ่งสามารถพิสูจน์ได้" | mkA "ที่มีการรับรองอย่างเป็นทางการว่าวิกลจริต" ; -- src=panlex
lin certificate_N = mkN "ใบรับรอง" | mkN "ประกาศนียบัตร" | mkN "หนังสือรับรอง" | mkN "ประกาศนียบัตร" | mkN "หนังสือรับรอง" | mkN "หลักฐานทางการเงิน" ; -- src=panlex
lin certification_N = mkN "ใบรับรอง" | mkN "ประกาศนียบัตร" | mkN "หนังสือรับรอง" | mkN "การยืนยันความจริง" | mkN "การให้หนังสือรับรอง" | mkN "การรับรอง" | mkN "เอกสารรับรอง" ; -- src=panlex
lin certified_A = mkA "ที่มีการรับรอง" | mkA "ซึ่งได้รับการรับรอง" | mkA "ซึ่งได้รับการพิสูจน์" | mkA "ซี่งได้รับการค้ําประกัน" | mkA "ซึ่งศาลได้สั่งให้เป็นคนวิกลจริต" ; -- src=panlex
lin certify_V = mkV "ให้ใบอนุญาต" | mkV "พิสูจน์ให้เห็น" | mkV "เป็นพยานหลักฐาน" | mkV "รับรอง" | mkV "พิสูจน์" | mkV "รับประกัน" | mkV "ลงนามเป็นพยาน" | mkV "พิสูจน์ให้เห็น" | mkV "ให้ประกาศนียบัตร" | mkV "ให้หนังสือรับรอง" | mkV "ประกาศว่าวิกลจริตตามกฎหมาย" ; -- src=panlex
lin certify_V2 = mkV2 "ให้ใบอนุญาต" ; ---- | mkV "พิสูจน์ให้เห็น" | mkV "เป็นพยานหลักฐาน" | mkV "รับรอง" | mkV "พิสูจน์" | mkV "รับประกัน" | mkV "ลงนามเป็นพยาน" | mkV "พิสูจน์ให้เห็น" | mkV "ให้ประกาศนียบัตร" | mkV "ให้หนังสือรับรอง" | mkV "ประกาศว่าวิกลจริตตามกฎหมาย" ; -- src=panlex
lin certiorari_N = mkN "หมายเรียกสํานวนคดีจากศาลชั้นต่ํากว่า" ; -- src=panlex
lin certitude_N = mkN "ความแน่นอน" | mkN "ความเชื่อมั่น" | mkN "ความมั่นใจ" | mkN "ความเชื่อมั่น" ; -- src=panlex
lin cerulean_A = mkA "ฟ้าคราม" | mkA "สีฟ้า" | mkA "สีคราม" | mkA "น้ําเงินเข้ม" | mkA "ที่มีสีฟ้าเข้ม" ; -- src=panlex
lin cerumen_N = mkN "ขี้หู" | mkN "ขี้หู" ; -- src=panlex
lin cerussite_N = mkN "เซรัสไซต์" | mkN "แร่ตะกั่วขาว" | mkN "แร่เซรัสไซต์" ; -- src=panlex
lin cervical_A = mkA "เกี่ยวกับคอ" | mkA "เกี่ยวกับปากมดลูก" ; -- src=panlex
lin cervine_A = mkA "คล้ายกวาง" | mkA "ที่เหมือนกวาง" ; -- src=panlex
lin cervix_N = mkN "คอ" | mkN "ศอ" | mkN "พระศอ" | mkN "คอมดลูก" | mkN "คอ" | mkN "ส่วนที่คล้ายคอ" ; -- src=panlex
lin cesium_N = mkN "ซีเซียม" | mkN "ธาตุซีเซียม" | mkN "เลขอะตอม 55" | mkN "ธาตุโลหะที่หายากชนิดหนึ่ง" ; -- src=panlex
lin cessation_N = mkN "การหยุด" | mkN "การหยุดชะงัก" | mkN "การหยุด" | mkN "การชะงัก" | mkN "การหยุดชะงัก" ; -- src=panlex
lin cession_N = mkN "การยอมมอบ" | mkN "การยกให้" | mkN "สิ่งที่ยกให้" ; -- src=panlex
lin cesspit_N = mkN "ถังส้วมซึม" | mkN "ถังปุ๋ยหมัก" | mkN "หลุมอุจราระ" | mkN "บ่อพักน้ําเสีย" | mkN "หลุมเก็บน้ําเสีย" ; -- src=panlex
lin cesspool_N = mkN "ถังส้วมซึม" | mkN "ถังปุ๋ยหมัก" | mkN "บ่อพักน้ําเสีย" ; -- src=panlex
lin cetacean_A = mkA "เกี่ยวกับสัตว์ทะเลเลี้นงลูกด้วยนม" ; -- src=panlex
lin cetacean_N = mkN "สัตว์ทะเลเลี้ยงลูกด้วยน้ำนม" ; -- src=panlex
lin cetrimide_N = mkN "เซตริไมด์" ; -- src=panlex
lin cgs_N = mkN "ซีจีเอส" | mkN "ระบบซีจีเอส" ; -- src=panlex
lin chabazite_N = mkN "แคบาไซต์" ; -- src=panlex
lin chachka_N = mkN "ชัชกา" ; -- src=panlex
lin chacma_N = mkN "ลิงบาบูน" | mkN "ลิงบาบูนขนาดใหญ่สําน้ําตาลเทา" ; -- src=panlex
lin chad_N = mkN "เศษปรุ" ; -- src=panlex
lin chador_N = mkN "ผ้าชาดอร์" ; -- src=panlex
lin chaeta_N = mkN "ขน" ; -- src=panlex
lin chaetodon_N = mkN "ปลาแคโตดอน" ; -- src=panlex
lin chafe_N = mkN "ความร้อน" | mkN "ความรำคาญ" | mkN "ความรู้สึกรำคาญ" | mkN "ความร้อนจากการเสียดสี" | mkN "การรบกวน" | mkN "รอยถลอกที่เกิดจาการขัดถู" | mkN "ความร้อนที่เกิดจากการขัดถู" ; -- src=panlex
lin chafe_V = mkV "ถลอก" | mkV "ยั่ว" | mkV "กวนใจ" | mkV "ถูมือ" | mkV "รบกวน" | mkV "กวนประสาท" | mkV "ทำให้ถลอก" | mkV "รู้สึกเคือง" | mkV "ทำให้เสียดสี" | mkV "รบกวน" | mkV "รําคาญ" | mkV "ทําให้รําคาญ" | mkV "ถลอกจากการขัดถู" | mkV "ทําให้อุ่นด้วยการถู" ; -- src=panlex
lin chafe_V2 = mkV2 "ถลอก" ; ---- | mkV "ยั่ว" | mkV "กวนใจ" | mkV "ถูมือ" | mkV "รบกวน" | mkV "กวนประสาท" | mkV "ทำให้ถลอก" | mkV "รู้สึกเคือง" | mkV "ทำให้เสียดสี" | mkV "รบกวน" | mkV "รําคาญ" | mkV "ทําให้รําคาญ" | mkV "ถลอกจากการขัดถู" | mkV "ทําให้อุ่นด้วยการถู" ; -- src=panlex
lin chafeweed_N = mkN "ต้นเชฟวีด" ; -- src=panlex
lin chaff_N = mkN "ฝัก" | mkN "ฟาง" | mkN "แกลบ" | mkN "การล้อเล่น" | mkN "การหยอกล้อ" | mkN "การเล่นหัว" | mkN "เปลือกข้าว" | mkN "เศษของไม่มีค่า" ; -- src=panlex
lin chaffinch_N = mkN "นกแชฟฟินช์" | mkN "นกจาบปีกอ่อนหัวเทาอกชมพู" | mkN "นกชนิดหนึ่งมีขนาดเล็กพบทางยุโรป" ; -- src=panlex
lin chaffweed_N = mkN "ต้นเชฟวีด" ; -- src=panlex
lin chaffy_A = mkA "เหมือนแกลบ" | mkA "ไร้ค่า" | mkA "มีแกลบมาก" | mkA "ใช้การไม่ได้" | mkA "มีลักษณะเป็นแกลบ" ; -- src=panlex
lin chagrin_N = mkN "การอับอาย" | mkN "ความอับอาย" | mkN "ความรําคาญใจจากการผิดหวังหรือความอาย" ; -- src=panlex
lin chain_N = mkN "พวง" | mkN "เชน" | mkN "โซ่" | mkN "สร้อย" | mkN "เทือก" | mkN "ลูกโซ่" | mkN "สายโซ่" | mkN "สายสร้อย" | mkN "เทือกเขา" | mkN "บริษัทในเครือ" | mkN "ทิว" | mkN "โซ่" | mkN "จํากัด" | mkN "ผูกมัด" | mkN "ลูกโซ่" | mkN "อนุกรม" | mkN "โซ่ตรวน" | mkN "สายสร้อย" | mkN "เทือกเขา" | mkN "เครื่องผูกมัด" | mkN "เหตุการณ์ที่เกิดต่อเนื่องกัน" | mkN "บริษัทต่างๆที่อยู่ในเครือเดียวกัน" ; -- src=panlex
lin chair_N = mkN (thword "เก้า" "อี้") "ตัว" | {-pan-} mkN "ประธาน" | mkN "ม้านั่ง" | mkN "เก้าอี้" | mkN "เก้าอี้ไฟฟ้า" | mkN "ตำแหน่งศาสตราจารย์" | mkN "ที่นั่ง" | mkN "ม้านั่ง" | mkN "เก้าอี้" | mkN "ตําแหน่งการงาน" | mkN "ตําแหน่งประธาน" | mkN "ตําแหน่งศาสตราจารย์" ; -- src=panlex
lin chair_lift_N = mkN "เก้าอี้กระเช้า" ; -- src=panlex
lin chairman_N = mkN "ประธาน" | mkN "ประธาน" | mkN "คนลากรถลาก" ; -- src=panlex
lin chairmanship_N = mkN "ตำแหน่งประธาน" | mkN "ความเป็นประธาน" | mkN "ความเป็นหัวหน้า" ; -- src=panlex
lin chaise_N = mkN "รถม้าเชส" | mkN "เก้าอี้นอน" | mkN "เก้าอี้นวมยาว" | mkN "รถม้าชนิดหนึ่งมีใช้ในอดีต" ; -- src=panlex
lin chalaza_N = mkN "ฐานออวุล" | mkN "เกลียวไข่ขาว" ; -- src=panlex
lin chalcedony_N = mkN "คาลซิโนนี" | mkN "หินควอร์ตซ์โปร่งใสชนิดหนึ่ง ๆ" ; -- src=panlex
lin chalcocite_N = mkN "ชาลโคไซต์" | mkN "แร่ชาลโคไซต์" | mkN "แร่ทองแดงซัลไฟด์" ; -- src=panlex
lin chalcopyrite_N = mkN "ชาลโคไพไรต์" | mkN "แร่ชาลโคไพไรต์" ; -- src=panlex
lin chaldron_N = mkN "ชัลดรอน" ; -- src=panlex
lin chalet_N = mkN "บ้านแบบชาเลท์" | mkN "กระท่อมเล็กๆ ส่วนใหญ่อยู่บนภูเขา" | mkN "กระท่อมไม้ของคนเลี้ยง" ; -- src=panlex
lin chalice_N = mkN "ถ้วยไวน์" | mkN "ถ้วยดื่ม" | mkN "ถ้วยดื่มเหล้าองุ่น" | mkN "ถ้วยเงินหรือทองสําหรับใส่ไวน์ในงานพิธีทางศาสนาคริสต์" ; -- src=panlex
lin chalk_N = mkN "ชอล์ก" | mkN "เมทแอมเฟตามีน" | mkN "ชอล์ก" | mkN "ได้รับ" ; -- src=panlex
lin chalkpit_N = mkN "เหมืองชอล์ก" ; -- src=panlex
lin chalky_A = mkA "สีชอล์ก" ; -- src=panlex
lin challenge_N = mkN "การท้า" | mkN "การท้าทาย" | mkN "การคัดค้าน" | mkN "คำถามท้าทาย" | mkN "การเรียกร้อง" | mkN "การท้าทาย" | mkN "สิ่งที่ท้าทาย" ; -- src=panlex
lin challenge_V = mkV "ท้า" | mkV "ท้าทาย" | mkV "คัดค้าน" | mkV "ขอดูบัตร" | mkV "ท้าทาย" | mkV "กระตุ้น" | mkV "เรียกร้อง" ; -- src=panlex
lin challenge_V2 = mkV2 "ท้า" ; ---- | mkV "ท้าทาย" | mkV "คัดค้าน" | mkV "ขอดูบัตร" | mkV "ท้าทาย" | mkV "กระตุ้น" | mkV "เรียกร้อง" ; -- src=panlex
lin challenger_N = mkN "คู่แข่ง" | mkN "คู่ต่อสู้" | mkN "ผู้ท้าชิง" | mkN "คู่แข่ง" | mkN "ผู้ท้าทาย" ; -- src=panlex
lin challis_N = mkN "ผ้าเนื้อบางเบา" ; -- src=panlex
lin chamber_N = mkN "สภา" | mkN "ห้อง" | mkN "ห้องนอน" | mkN "ห้องพิพากษา" | mkN "ห้องพระบรรทม" | mkN "ที่หลับที่นอน" | mkN "สภา" | mkN "ช่อง" | mkN "ห้อง" | mkN "โพรง" | mkN "สมาคม" | mkN "หอการค้า" | mkN "จัดห้องให้" | mkN "ห้องประชุม" | mkN "ลํากล้องปืน" | mkN "ห้องพักเดี่ยว" | mkN "ลํากล้องกระสุน" | mkN "สํานักงานทนายความ" | mkN "ห้องหรือช่องว่างในร่างกาย" ; -- src=panlex
lin chamberlain_N = mkN "ราชเลขานุการ" | mkN "เจ้าหน้าที่การเงินของเทศบาล" ; -- src=panlex
lin chambermaid_N = mkN "หญิงรับใช้" | mkN "คนทําที่นอน" ; -- src=panlex
lin chamberpot_N = mkN "กระโถน" ; -- src=panlex
lin chambray_N = mkN "ผ้าแชมแบรย์" ; -- src=panlex
lin chameleon_N = mkN "กิ้งก่าคะมีเลียน" | mkN "กิ้งก่า" | mkN "สัตว์จําพวกกิ้งก่า" | mkN "สัตว์จําพวกกิ้งก่า มันเปลี่ยนสีผิวได้" | mkN "คนที่ปรับเปลี่ยนได้ตามสถานการณ์" ; -- src=panlex
lin chamois_N = mkN "หนังชามัวส์" ; -- src=panlex
lin chamosite_N = mkN "คาโมไซต์" ; -- src=panlex
lin champ_N = mkN "แชมป์" | mkN "ผู้ชนะ" | mkN "แชมเปี้ยน" | mkN "แชมเปี้ยน" | mkN "การชนะเลิศ" | mkN "ผู้ชนะเลิศ" | mkN "แชมป์เปี้ยน" | mkN "การเคี้ยวเอื้อง" ; -- src=panlex
lin champ_V = mkV "เคี้ยวจั๊บๆ" | mkV "เคี้ยวเหมือนม้า" | mkV "บด" | mkV "เคี้ยว" | mkV "เคี้ยวเอื้อง" ; -- src=panlex
lin champ_V2 = mkV2 "เคี้ยวจั๊บๆ" ; ---- | mkV "เคี้ยวเหมือนม้า" | mkV "บด" | mkV "เคี้ยว" | mkV "เคี้ยวเอื้อง" ; -- src=panlex
lin champagne_N = mkN "แชมเปญ" | mkN "แชมเปน" | mkN "แชมเปญ" | mkN "สีเหลืองจางๆ" | mkN "เหล้าองุ่นขาวชนิดหนึ่ง" | mkN "เหล้าองุ่นขาวชนิดหนึ่งมาจากบริเวณแชมเปญของประเทศฝรั่งเศส" ; -- src=panlex
lin champion_A = mkA "ที่ได้แชมเปี้ยน" | mkA "ดีเยี่ยม" | mkA "ยอดเยี่ยม" | mkA "ซึ่งเป็นที่หนึ่งของผู้เข้าแข่งขันทั้งหมด" ; -- src=panlex
lin champion_Adv = mkAdv "อย่างดีเยี่ยม" | mkAdv "อย่างยอดเยี่ยม" ; -- src=panlex
lin champion_N = mkN "แชมป์" | mkN "นักสู้" | mkN "ผู้ชนะ" | mkN "ดาวรุ่ง" | mkN "อัจฉริยะ" | mkN "นักต่อสู้" | mkN "แชมเปี้ยน" | mkN "ผู้สนับสนุน" | mkN "ผู้หนุนหลัง" | mkN "ผู้เชี่ยวชาญ" | mkN "อัจฉริยบุคคล" | mkN "ซุปเปอร์สตาร์" | mkN "ผู้ให้การสนับสนุน" | mkN "ผู้เชี่ยวชาญเฉพาะด้าน" | mkN "นักรบ" | mkN "สนับสนุน" | mkN "นักต่อสู้" | mkN "ผู้ชนะเลิศ" | mkN "ผู้สนับสนุน" | mkN "นักสู้ในสนามรบ" | mkN "ผู้ให้ความช่วยเหลือ" | mkN "ผู้ที่ได้คะแนนสูงสุดในการแข่งขัน" ; -- src=panlex
lin championship_N = mkN "สนับสนุน" | mkN "การแข่งขัน" | mkN "การสนับสนุน" | mkN "การอุปถัมภ์" | mkN "แชมเปี้ยนชิป" | mkN "ความช่วยเหลือ" | mkN "ความเป็นผู้ชนะ" | mkN "ตำแหน่งชนะเลิศ" | mkN "การป้องกัน" | mkN "การสนับสนุน" | mkN "การเป็นทนาย" | mkN "ตําแหน่งชนะเลิศ" | mkN "การต่อสู้ป้องกัน" | mkN "ตําแหน่งผู้ชนะเลิศ" | mkN "ภาวะที่เป็นแชมเปี้ยน" | mkN "การแข่งขันเพื่อได้ตัวผู้ชนะเลิศ" ; -- src=panlex
lin chanar_N = mkN "ต้นชานาร์" ; -- src=panlex
lin chance_N = mkN "โชค" | mkN "โอกาส" | mkN "การเสี่ยง" | mkN "ความน่าจะเป็น" | mkN "ความเป็นไปได้" | mkN "โชค" | mkN "วาสนา" | mkN "หนทาง" | mkN "โอกาส" | mkN "ท่าทาง" | mkN "เสี่ยง" | mkN "ช่องทาง" | mkN "ยถากรรม" | mkN "เคราะห์" | mkN "การเสี่ยง" | mkN "ความเสี่ยง" | mkN "หนทางสําเร็จ" | mkN "ความน่าจะเป็น" | mkN "ความเป็นไปได้" | mkN "ลักษณะที่เป็นไปได้" ; -- src=panlex
lin chance_V = mkV "พบ" | mkV "มีโอกาส" | mkV "เสี่ยงดวง" | mkV "เสี่ยงโชค" | mkV "เกิดขึ้นโดยบังเอิญ" ; -- src=panlex
lin chance_V2 = mkV2 "พบ" ; ---- | mkV "มีโอกาส" | mkV "เสี่ยงดวง" | mkV "เสี่ยงโชค" | mkV "เกิดขึ้นโดยบังเอิญ" ; -- src=panlex
lin chancel_N = mkN "พลับพลา" | mkN "แท่นบูชา" | mkN "ส่วนของโบสถ์สําหรับทําพิธี" | mkN "พื้นที่ในโบสถ์สําหรับพระและนักร้องของโบสถ์นั่ง" ; -- src=panlex
lin chancellery_N = mkN "รัฐมนตรี" | mkN "นายกรัฐมนตรี" | mkN "สถานกงสุลใหญ่" | mkN "ตําแหน่งเสนาบดี" | mkN "สํานักงานเสนาบดี" | mkN "สถานเอกอัครราชฑูต" | mkN "เลขานุการเอกอัครราชทูต" | mkN "ตําแหน่งอัครมหาเสนาบดีของบางประเทศ" ; -- src=panlex
lin chancellor_N = mkN "นายก" | mkN "อธิการบดี" | mkN "นายกรัฐมนตรี" | mkN "หัวหน้ารัฐบาล" | mkN "เสนาบดี" | mkN "ตุลาการใหญ่" | mkN "นายกรัฐมนตรี" | mkN "เอกอัครราชทูต" | mkN "อัครมหาเสนาบดี" ; -- src=panlex
lin chancery_N = mkN "ศาลฎีกา" | mkN "ศาลตุลาการใหญ่" | mkN "ศาลฎีกา" | mkN "ที่ทําการของเสนาบดี" | mkN "ที่เก็บเอกสารทางราชการ" | mkN "ภาวะที่กลืนไม่เข้าคายไม่ออก" ; -- src=panlex
lin chancre_N = mkN "แผลกามโรค" | mkN "แผลซิฟิลิส" | mkN "แผลริมแข็ง" ; -- src=panlex
lin chancroid_N = mkN "แผลกามโรค" | mkN "แผลริมอ่อน" ; -- src=panlex
lin chancy_A = mkA "โชคดี" | mkA "เสี่ยง" | mkA "เป็นมงคล" | mkA "ไม่แน่นอน" | mkA "โดยการสุ่ม" | mkA "อย่างเสี่ยง" ; -- src=panlex
lin chandelier_N = mkN "โคมระย้า" | mkN "โคมกิ่ง" | mkN "โคมระย้า" | mkN "โคมไฟระย้า" ; -- src=panlex
lin chandler_N = mkN "คนขายของชำ" | mkN "คนขายเทียน" | mkN "พ่อค้าเทียนไข" ; -- src=panlex
lin chandlery_N = mkN "ห้องเก็บเทียนไข" | mkN "ห้องเก็บเทียนไข" | mkN "โกดังเก็บเทียนไข" | mkN "ห้องเก็บเทียนไขหรือของเล็กๆ" ; -- src=panlex
lin chanfron_N = mkN "เกราะป้องกันศีรษะม้า" ; -- src=panlex
lin change_N = mkN "เงินทอน" | mkN "เศษเหรียญ" | mkN "การแลกเงิน" | mkN "ชุดเปลี่ยน" | mkN "ของแปลกใหม่" | mkN "ความแตกต่าง" | mkN "การเปลี่ยนแปลง" | mkN "การเปลี่ยนเสื้อ" | mkN "ชุดที่ใช้เปลี่ยน" | mkN "การทำให้เปลี่ยนแปลง" | mkN "เงินทอน" | mkN "การแทนที่" | mkN "สิ่งทดแทน" | mkN "เศษสตางค์" | mkN "ความผันแปร" | mkN "ของแปลกใหม่" | mkN "ความเปลี่ยนแปลง" ; -- src=panlex
lin change_V = mkV "เปลี่ยน" | mkV "กลายสภาพ" | mkV "เปลี่ยนชุด" | mkV "แลกเปลี่ยน" | mkV "เปลี่ยนแปลง" | mkV "ทำให้เปลี่ยน" | mkV "เปลี่ยนผ้าอ้อม" | mkV "เปลี่ยนเส้นทาง" | mkV "เปลี่ยนเสื้อผ้า" | mkV "ทำให้เปลี่ยนแปลง" | mkV "เปลี่ยนเป็นเสียงทุ้ม" | mkV "แลก" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "แลกเงินย่อย" | mkV "เปลี่ยนเสื้อ" | mkV "ทําให้แตกต่าง" | mkV "เปลี่ยนความเร็ว" | mkV "แลกเปลี่ยนเงินตรา" ; -- src=panlex
lin change_V2 = mkV2 "เปลี่ยน" ; ---- | mkV "กลายสภาพ" | mkV "เปลี่ยนชุด" | mkV "แลกเปลี่ยน" | mkV "เปลี่ยนแปลง" | mkV "ทำให้เปลี่ยน" | mkV "เปลี่ยนผ้าอ้อม" | mkV "เปลี่ยนเส้นทาง" | mkV "เปลี่ยนเสื้อผ้า" | mkV "ทำให้เปลี่ยนแปลง" | mkV "เปลี่ยนเป็นเสียงทุ้ม" | mkV "แลก" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "แลกเงินย่อย" | mkV "เปลี่ยนเสื้อ" | mkV "ทําให้แตกต่าง" | mkV "เปลี่ยนความเร็ว" | mkV "แลกเปลี่ยนเงินตรา" ; -- src=panlex
lin change_over_V2 = prepV2 OP_change_V OP_over_Prep ; -- guess-p-verb
lin changeable_A = mkA "ซึ่งเปลี่ยนแปลงได้" | mkA "ไม่แน่นอน" | mkA "เปลี่ยนแปลงได้" | mkA "เปลี่ยนได้ง่าย" | mkA "ที่เปลี่ยนแปลงง่าย" ; -- src=panlex
lin changeableness_N = mkN "ความเปลี่ยนแปลงง่าย" ; -- src=panlex
lin changeful_A = mkA "ซึ่งเปลี่ยนแปลงได้" | mkA "ที่ผันแปร" | mkA "ไม่แน่นอน" | mkA "เปลี่ยนแปลง" | mkA "เปลี่ยนไปมาก" | mkA "เปลี่ยนได้ง่าย" ; -- src=panlex
lin changeless_A = mkA "ที่ไม่เปลี่ยนแปลง" ; -- src=panlex
lin changelessness_N = mkN "การไม่เปลี่ยนแปลง" | mkN "การไม่เปลี่ยนแปลง" ; -- src=panlex
lin changeling_N = mkN "คนปัญญาอ่อน" | mkN "คนสติไม่สมประกอบ" | mkN "เด็กที่ถูกสับเปลี่ยน" | mkN "คนโง่" | mkN "คนทรยศ" | mkN "เด็กหลงจากพ่อแม่" | mkN "เด็กถูกสับเปลี่ยน" | mkN "เด็กที่ถูกแอบสับเปลี่ยน" ; -- src=panlex
lin changeover_N = mkN "การเปลี่ยนแปลง" | mkN "การเปลี่ยนสภาวะ" | mkN "การเปลี่ยนแปลงจากภาวะหนึ่งสู่ภาวะหนึ่ง" ; -- src=panlex
lin changer_N = mkN "ผู้เปลี่ยนแปลง" ; -- src=panlex
lin changing_A = mkA "ที่เปลี่ยนแปลง" ; -- src=panlex
lin channel_N = mkN "ช่อง" | mkN "ร่อง" | mkN "หลอด" | mkN "ทางน้ำ" | mkN "แชนเนล" | mkN "ช่องแคบ" | mkN "ร่องน้ำ" | mkN "ช่องทีวี" | mkN "ช่องสัญญาณ" | mkN "ช่องโทรทัศน์" | mkN "ช่องทางสื่อสาร" | mkN "ช่องทางกระจายสินค้า" | mkN "ราง" | mkN "ช่อง" | mkN "ขุดทาง" | mkN "นําทาง" | mkN "แนวทาง" | mkN "ช่องทาง" | mkN "ช่องแคบ" | mkN "ทางผ่าน" | mkN "วิถีทาง" | mkN "ร่องน้ํา" | mkN "ขุดทางน้ํา" | mkN "ทางน้ําไหล" | mkN "บุกเบิกทาง" | mkN "ทางเดินเรือ" | mkN "ช่องทางสื่อสาร" | mkN "เส้นทางที่ใช้ลําเลียง" ; -- src=panlex
lin channels_N = mkN "ช่องทางการติดต่อสื่อสาร" ; -- src=panlex
lin chant_N = mkN "การสวดเป็นทำนอง" | mkN "ชม" | mkN "เพลง" | mkN "การท่อง" | mkN "สรรเสริญ" | mkN "การสวดมนต์" | mkN "การร้องเพลง" | mkN "ร้องสวดมนต์" | mkN "เพลงสวดมนต์" | mkN "ทํานองเสียงระดับเดียว" | mkN "เพลงที่ใช้ร้องในโบสถ์" ; -- src=panlex
lin chant_V = mkV "ท่อง" | mkV "สวดเป็นทำนอง" | mkV "สวดมนต์" | mkV "ร้องเพลง" | mkV "ท่องบทสวดเป็นทํานอง" | mkV "พูดด้วยทํานองเสียงระดับเดียว" ; -- src=panlex
lin chant_V2 = mkV2 "ท่อง" ; ---- | mkV "สวดเป็นทำนอง" | mkV "สวดมนต์" | mkV "ร้องเพลง" | mkV "ท่องบทสวดเป็นทํานอง" | mkV "พูดด้วยทํานองเสียงระดับเดียว" ; -- src=panlex
lin chanterelle_N = mkN "เห็ดชันเตอเร็ล" | mkN "เห็ดชัลเตอเร็ล" ; -- src=panlex
lin chantey_N = mkN "เพลงกะลาสี" | mkN "เพลงสาระพาเฮโล" ; -- src=panlex
lin chantry_N = mkN "โบสถ์เล็ก ๆ ในสังกัด" | mkN "ปัจจัยที่ถวายพระ" ; -- src=panlex
lin chaos_N = mkN "ความสับสน" | mkN "ความโกลาหล" | mkN "ความอลหม่าน" | mkN "ความวิกลจริต" | mkN "ความยุ่งเหยิง" | mkN "ความสับสน" | mkN "ความอลหม่าน" | mkN "ความยุ่งเหยิง" | mkN "ความสับสนวุ่นวาย" | mkN "ความไม่มีระเบียบ" ; -- src=panlex
lin chaotic_A = mkA "สับสน" | mkA "วุ่นวาย" | mkA "อลหม่าน" | mkA "คลุมเครือ" | mkA "ยุ่งเหยิง" | mkA "ไร้ระเบียบ" | mkA "ที่ไม่เป็นระเบียบ" ; -- src=panlex
lin chap_N = mkN "พ่อ" | mkN "หนุ่ม" | mkN "ปากแตก" | mkN "รอยแตก" | mkN "พ่อหนุ่ม" | mkN "รอยยุบตัว" | mkN "เจ้าหนุ่ม" | mkN "รอยแตกบนพื้นผิว" | mkN "รอย" | mkN "มิตร" | mkN "รอยแตก" | mkN "รอยแยก" | mkN "รอยกะเทาะ" ; -- src=panlex
lin chap_V = mkV "แตก" | mkV "แยก" | mkV "ทําให้แตก" | mkV "ทําให้แยก" ; -- src=panlex
lin chap_V2 = mkV2 "แตก" ; ---- | mkV "แยก" | mkV "ทําให้แตก" | mkV "ทําให้แยก" ; -- src=panlex
lin chapatti_N = mkN "จปาตี" ; -- src=panlex
lin chapel_N = mkN "โรงสวด" | mkN "โรงพิมพ์" | mkN "โบสถ์เล็ก" | mkN "โรงพยาบาล" | mkN "ห้องสวดมนต์" | mkN "พิธีทางศาสนา" | mkN "ห้องในโรงพิมพ์" | mkN "ห้องสวดมนต์ในโรงเรียน" | mkN "ที่ส่วนตัวในโบสถ์สําหรับผู้สวดมนต์" ; -- src=panlex
lin chaperon_N = mkN "หญิง" ; -- src=panlex
lin chapfallen_A = mkA "สลด" | mkA "คอตก" | mkA "ระทมทุกข์" | mkA "ขากรรไกรล่างห้อยย้อยลงมา" ; -- src=panlex
lin chaplain_N = mkN "โรงพยาบาล" | mkN "พระคริสเตียน" | mkN "คุกหรือกองทัพ" | mkN "อนุศาสนาจารย์" | mkN "บาทหลวงในโรงเรียน" ; -- src=panlex
lin chaplet_N = mkN "หรีด" | mkN "พวงมาลา" | mkN "พวงหรีด" | mkN "สร้อยคอ" | mkN "มงกุฎดอกไม้" | mkN "มาลัยบนศรีษะ" | mkN "สายลูกประคํา" ; -- src=panlex
lin chapman_N = mkN "พ่อค้าวาณิช" | mkN "บทกวี" | mkN "พ่อค้า" | mkN "คนเร่ขายของ" ; -- src=panlex
lin chapter_N = mkN "บท" | mkN "สาขา" | mkN "ตอนย่อย" | mkN "การประชุมสงฆ์" | mkN "ตอน" | mkN "สาขา" | mkN "คณะพระ" | mkN "เรื่อง" | mkN "ขั้นตอน" | mkN "คณะสงฆ์" | mkN "ช่วงเวลา" | mkN "ส่วนย่อย" | mkN "บทในหนังสือ" | mkN "ส่วนแบ่งที่สําคัญ" ; -- src=panlex
lin chapterhouse_N = mkN "สโมสรนิสิต" ; -- src=panlex
lin char_N = mkN "เมต" | mkN "ปลาชาร์" | mkN "แม่บ้าน" | mkN "ของไหม้เกรียม" | mkN "หญิงทำความสะอาด" | mkN "ถ่าน" | mkN "งานบ้าน" | mkN "ถ่านหิน" | mkN "คนทํางานบ้าน" | mkN "หญิงทํางานบ้าน" | mkN "งานเก็บกวาดบ้าน" | mkN "สิ่งที่ไหม้จนเกรียม" ; -- src=panlex
lin char_V = mkV "เผาถ่าน" | mkV "ย่างจนเกรียม" | mkV "ถ่าน" | mkV "งานบ้าน" | mkV "ถ่านไม้" | mkV "ทํางานบ้าน" | mkV "ภารโรงหญิง" | mkV "ทําความสะอาด" | mkV "ทํางานเช็ดถู" | mkV "ทํางานปัดกวาด" | mkV "เผาไม้จนเกรียม" | mkV "เผาจนไหม้เกรียม" | mkV "เผาไหม้จนเป็นถ่าน" ; -- src=panlex
lin char_V2 = mkV2 "เผาถ่าน" ; ---- | mkV "ย่างจนเกรียม" | mkV "ถ่าน" | mkV "งานบ้าน" | mkV "ถ่านไม้" | mkV "ทํางานบ้าน" | mkV "ภารโรงหญิง" | mkV "ทําความสะอาด" | mkV "ทํางานเช็ดถู" | mkV "ทํางานปัดกวาด" | mkV "เผาไม้จนเกรียม" | mkV "เผาจนไหม้เกรียม" | mkV "เผาไหม้จนเป็นถ่าน" ; -- src=panlex
lin charabanc_N = variants {} ;
lin characin_N = mkN "ปลาคาราซินฟิช" ; -- src=panlex
lin character_1_N = variants {} ; ---- sense to be split
lin character_2_N = variants {} ; ---- sense to be split
lin characteristic_A = mkA "ลักษณะเด่น" | mkA "ลักษณะพิเศษ" | mkA "ลักษณะเฉพาะ" ; -- src=panlex
lin characteristic_N = mkN "ลักษณะ" | mkN "คุณสมบัติเด่น" | mkN "ลักษณะนิสัย" ; -- src=panlex
lin characterization_N = mkN "รูปภาพ" | mkN "การแสดง" | mkN "การพรรณนา" | mkN "การแสดงลักษณะ" | mkN "การบรรยายลักษณะ" ; -- src=panlex
lin charade_N = mkN "คำใบ้" | mkN "การล้อ" | mkN "การยั่วล้อ" | mkN "การล้อเลียน" | mkN "ภาพตลกล้อเลียน" ; -- src=panlex
lin charades_N = mkN "คนใบ้คำ" ; -- src=panlex
lin charcoal_A = mkA "ที่มีสีเทาชาร์โคล" ; -- src=panlex
lin charcoal_N = mkN "ถ่าน" | mkN "ชาร์โคล" | mkN "ถ่านไม้" | mkN "สีเทาเข้ม" | mkN "ถ่านชาร์โคล" | mkN "ดินสอถ่านชาร์โคล" | mkN "ภาพวาดด้วยถ่านชาร์โคล" | mkN "ถ่าน" | mkN "ถ่านไม้" | mkN "ดินสอถ่าน" | mkN "ภาพวาดด้วยถ่านไม้" | mkN "ดินสอที่ทําจากถ่าน" | mkN "ภาพที่วาดด้วยดินสอถ่าน" | mkN "ถ่านที่เกิดจากการเผาไหม้ของคาร์บอน" ; -- src=panlex
lin chard_N = mkN "หัวบีต" ; -- src=panlex
lin charge_1_N = variants {} ; ---- sense to be split
lin charge_2_N = variants {} ; ---- sense to be split
lin charge_V = mkV "ใส่" | mkV "หมอบ" | mkV "ชาร์จ" | mkV "บรรจุ" | mkV "ประจุ" | mkV "หาว่า" | mkV "กล่าวหา" | mkV "ชาร์จไฟ" | mkV "ชาร์จแบต" | mkV "ปลุกปั่น" | mkV "เก็บเงิน" | mkV "แต่งตั้ง" | mkV "เข้าชาร์จ" | mkV "มอบหมายงาน" | mkV "เก็บค่าชาร์จ" | mkV "ชาร์แบตเตอรี่" | mkV "ใช้บัตรเครดิต" | mkV "ใช้บัตรสินเชื่อ" | mkV "มอบ" | mkV "ฟ้อง" | mkV "สั่ง" | mkV "อัดไฟ" | mkV "โจมตี" | mkV "จู่โจม" | mkV "ติดตรา" | mkV "ส่งมอบ" | mkV "กล่าวหา" | mkV "ชาร์จไฟ" | mkV "ติดหนี้" | mkV "ผัดหนี้" | mkV "รับภาระ" | mkV "สั่งให้" | mkV "อัดแน่น" | mkV "ใส่ความ" | mkV "กล่าวโทษ" | mkV "ฟ้องร้อง" | mkV "แต่งตั้ง" | mkV "ชําระเงิน" | mkV "ประทับตรา" | mkV "มากไปด้วย" | mkV "เรียกเก็บ" | mkV "ดําเนินคดี" | mkV "ปกคลุมด้วย" | mkV "มอบหมายให้" | mkV "เต็มไปด้วย" | mkV "เรียกเก็บเงิน" | mkV "ติดเงินไว้ก่อน" | mkV "ลงบันทึกการยืม" | mkV "อัดอยู่ในจิตใจ" | mkV "อัดแน่นอยู่ในใจ" | mkV "ทําให้รับหน้าที่" | mkV "เรียบเก็บค่าใช้จ่าย" | mkV "ยืมหนังสือจากห้องสมุด" | mkV "จ่ายเงินโดยตัดจากบัญชี" | mkV "ทําให้แบกรับภาระหน้าที่" | mkV "จ่ายเงินโดยใช้บัตรเครดิต" | mkV "ส่งเข้าองค์การหรือสถาบันเฉพาะกาล" ; -- src=panlex
lin charge_V2 = mkV2 "ใส่" ; ---- | mkV "หมอบ" | mkV "ชาร์จ" | mkV "บรรจุ" | mkV "ประจุ" | mkV "หาว่า" | mkV "กล่าวหา" | mkV "ชาร์จไฟ" | mkV "ชาร์จแบต" | mkV "ปลุกปั่น" | mkV "เก็บเงิน" | mkV "แต่งตั้ง" | mkV "เข้าชาร์จ" | mkV "มอบหมายงาน" | mkV "เก็บค่าชาร์จ" | mkV "ชาร์แบตเตอรี่" | mkV "ใช้บัตรเครดิต" | mkV "ใช้บัตรสินเชื่อ" | mkV "มอบ" | mkV "ฟ้อง" | mkV "สั่ง" | mkV "อัดไฟ" | mkV "โจมตี" | mkV "จู่โจม" | mkV "ติดตรา" | mkV "ส่งมอบ" | mkV "กล่าวหา" | mkV "ชาร์จไฟ" | mkV "ติดหนี้" | mkV "ผัดหนี้" | mkV "รับภาระ" | mkV "สั่งให้" | mkV "อัดแน่น" | mkV "ใส่ความ" | mkV "กล่าวโทษ" | mkV "ฟ้องร้อง" | mkV "แต่งตั้ง" | mkV "ชําระเงิน" | mkV "ประทับตรา" | mkV "มากไปด้วย" | mkV "เรียกเก็บ" | mkV "ดําเนินคดี" | mkV "ปกคลุมด้วย" | mkV "มอบหมายให้" | mkV "เต็มไปด้วย" | mkV "เรียกเก็บเงิน" | mkV "ติดเงินไว้ก่อน" | mkV "ลงบันทึกการยืม" | mkV "อัดอยู่ในจิตใจ" | mkV "อัดแน่นอยู่ในใจ" | mkV "ทําให้รับหน้าที่" | mkV "เรียบเก็บค่าใช้จ่าย" | mkV "ยืมหนังสือจากห้องสมุด" | mkV "จ่ายเงินโดยตัดจากบัญชี" | mkV "ทําให้แบกรับภาระหน้าที่" | mkV "จ่ายเงินโดยใช้บัตรเครดิต" | mkV "ส่งเข้าองค์การหรือสถาบันเฉพาะกาล" ; -- src=panlex
lin charge_off_V = advV OP_charge_V OP_off_Adv ; -- guess-p-verb
lin charge_up_V2 = prepV2 OP_charge_V OP_up_Prep ; -- guess-p-verb
lin charge_with_V3 = variants {} ; -- guess-p-verb
lin charger_N = mkN "ที่ชาร์จแบต" | mkN "เครื่องประจุไฟ" | mkN "เครื่องชาร์จแบต" | mkN "ที่ชาร์จแบตเตอร์รี่" | mkN "เครื่องชาร์จแบตเตอร์รี่" | mkN "เครื่องประจุเเบตเตอร์รี่" | mkN "ม้าศึก" | mkN "ผู้จู่โจม" | mkN "เครื่องอัดไฟ" | mkN "จานใส่ของเหลว" | mkN "เครื่องบรรจุไฟ" | mkN "ม้าที่ใช้ขี่ออกรบในสงคราม" ; -- src=panlex
lin chariot_N = mkN "รถศึก" | mkN "ราชรถ" | mkN "รถม้าศึก" | mkN "รถม้า" | mkN "รถเทียมม้า" | mkN "โดยสารรถม้า" | mkN "รถม้าศึกสองล้อ มักใช้ม้า 2 ตัวและยืนขับ" ; -- src=panlex
lin charioteer_N = mkN "สารถี" | mkN "คนขับรถศึก" | mkN "คนขับรถม้าศึก" | mkN "สารถี" | mkN "คนขับรถม้า" | mkN "คนขับรถม้าศึก 2 ล้อ" ; -- src=panlex
lin charisma_N = mkN "เสน่ห์" | mkN "เสน่ห์" | mkN "พรสวรรค์" | mkN "ความสามารถพิเศษ" | mkN "คุณสมบัติพิเศษเฉพาะคน" | mkN "คุณสมบัติพิเศษในการดึงดูดใจคนจํานวนมาก" ; -- src=panlex
lin charismatic_A = mkA "ที่มีเสน่ห์ดึงดูด" | mkA "ที่มีเสน่ห์ดึงดูด" ; -- src=panlex
lin charitable_A = mkA "ซึ่งใจบุญสุนทาน" | mkA "ซึ่งมีความใจบุญสุนทาน" | mkA "ใจบุญ" | mkA "เป็นกุศล" | mkA "กรุณาปรานี" | mkA "ที่เป็นกุศล" | mkA "โอบอ้อมอารี" | mkA "ที่เมตตากรุณา" | mkA "เอื้อเฟื้อเผื่อแผ่" ; -- src=panlex
lin charity_N = mkN "การกุศล" | mkN "มูลนิธิ" | mkN "ความใจบุญสุนทาน" | mkN "ต้นกรีกวาลีเรียน" | mkN "ต้นจาค็อบแลดเดอร์" | mkN "งานบุญ" | mkN "การกุศล" | mkN "งานกุศล" | mkN "มูลนิธิ" | mkN "กิจการกุศล" | mkN "เงินบริจาค" | mkN "การทําการกุศล" | mkN "การทําบุญสุนทาน" | mkN "ความโอบอ้อมอารี" | mkN "ความใจบุญสุนทาน" | mkN "สิ่งของที่บริจาค" | mkN "ความเอื้อเฟื้อเผื่อแผ่" ; -- src=panlex
lin charivari_N = mkN "คําเย้ย" | mkN "คําหยอกล้อ" ; -- src=panlex
lin charlady_N = mkN "หญิง" | mkN "คนใช้" | mkN "หญิงปัดกวาดบ้าน" | mkN "หญิงทําความสะอาด" ; -- src=panlex
lin charlatan_N = mkN "นักต้มตุ๋น" | mkN "นักต้ม" | mkN "กํามะลอ" | mkN "หมอเถื่อน" | mkN "นักต้มตุ๋น" | mkN "พวกกํามะลอ" | mkN "พวกสิบแปดมงกุฏ" ; -- src=panlex
lin charlock_N = mkN "ต้นมัสตาร์ดป่า" ; -- src=panlex
lin charlotte_N = mkN "ชาร์ลอต" ; -- src=panlex
lin charm_N = mkN "คาถา" | mkN "ของดี" | mkN "มนตร์" | mkN "เสน่ห์" | mkN "ของขลัง" | mkN "เวทมนตร์" | mkN "ความน่าสนใจ" | mkN "เวทมนตร์คาถา" | mkN "เครื่องรางของขลัง" | mkN "คาถา" | mkN "มนตร์" | mkN "เวทย์" | mkN "เสน่ห์" | mkN "เครื่องราง" | mkN "เวทย์มนตร์" | mkN "การร่ายคาถา" | mkN "ความเย้ายวนใจ" | mkN "การร่ายเวทย์มนตร์" | mkN "เครื่องรางของขลัง" ; -- src=panlex
lin charm_V = mkV "ดึงดูดใจ" | mkV "ทำเสน่ห์" | mkV "มีเสน่ห์" | mkV "ทำเสน่ห์ยาแฝด" | mkV "ใช้คาถาคุ้มครอง" | mkV "ใช้เสน่ห์ทำให้หลงใหล" | mkV "สะกดมนตร์" | mkV "ใช้เสน่ห์" | mkV "ทําให้หลงใหล" | mkV "สะกดด้วยเวทมนตร์คาถา" | mkV "ใช้เวทมนตร์คาถาหรือยันต์คุ้มครอง" ; -- src=panlex
lin charm_V2 = mkV2 "ดึงดูดใจ" ; ---- | mkV "ทำเสน่ห์" | mkV "มีเสน่ห์" | mkV "ทำเสน่ห์ยาแฝด" | mkV "ใช้คาถาคุ้มครอง" | mkV "ใช้เสน่ห์ทำให้หลงใหล" | mkV "สะกดมนตร์" | mkV "ใช้เสน่ห์" | mkV "ทําให้หลงใหล" | mkV "สะกดด้วยเวทมนตร์คาถา" | mkV "ใช้เวทมนตร์คาถาหรือยันต์คุ้มครอง" ; -- src=panlex
lin charmer_N = mkN "หญิงเจ้าเสน่ห์" ; -- src=panlex
lin charming_A = mkA "น่ารัก" | mkA "มีเสน่ห์" | mkA "น่าหลงใหล" | mkA "รัดรึงใจคน" | mkA "ที่ใช้พลังจิต" | mkA "ซึ่งทําให้หลงใหล" | mkA "ที่ใช้เวทย์มนตร์" | mkA "ซึ่งใช้อํานาจเวทมนตร์" | mkA "ซึ่งใช้คาถาหรือเวทย์มนตร์" ; -- src=panlex
lin chart_N = mkN "ชาร์ต" | mkN "แผนภูมิ" | mkN "ผัง" | mkN "กราฟ" | mkN "ตาราง" | mkN "แผนที่" | mkN "แผนผัง" | mkN "แผนภาพ" | mkN "แผนภูมิ" | mkN "ผังอากาศ" | mkN "วางแผนการ" | mkN "แผนที่ทะเล" | mkN "แผนที่การบิน" ; -- src=panlex
lin chartaceous_A = mkA "เหมือนกระดาษ" ; -- src=panlex
lin charter_N = mkN "ใบอนุญาต" | mkN "สัญญาเช่า" | mkN "กฎบัตร" | mkN "ตราตั้ง" | mkN "ใบอนุญาต" | mkN "สัญญาเช่า" | mkN "ใบทะเบียน" | mkN "รัฐธรรมนูญ" | mkN "สัญญารับเหมา" | mkN "หนังสือสัญญา" | mkN "เอกสารทางการ" | mkN "หนังสืออนุญาต" ; -- src=panlex
lin chartreuse_N = mkN "เขียวอมเหลือง" | mkN "สีเขียวอมเหลือง" ; -- src=panlex
lin charwoman_N = mkN "เมต" | mkN "แม่บ้าน" | mkN "หญิงทำความสะอาด" | mkN "หญิงทําความสะอาด" | mkN "หญิงทําความสะอาดบ้าน" ; -- src=panlex
lin chary_A = mkA "กังวล" | mkA "ระวัง" | mkA "จุกจิก" | mkA "จู้จี้" | mkA "ประหยัด" | mkA "ขี้เหนียว" | mkA "ช่างเลือก" | mkA "เหนียมอาย" | mkA "ระมัดระวัง" | mkA "อย่างรอบคอบ" ; -- src=panlex
lin chase_N = mkN "การไล่" | mkN "การติดตาม" | mkN "การไล่ตาม" | mkN "ร่องในกําแพงหรือพื้นสําหรับวางท่อน้ํา" ; -- src=panlex
lin chase_V = mkV "ตื้อ" | mkV "สลัก" | mkV "ตามจีบ" | mkV "ไล่จับ" | mkV "ตามตื้อ" | mkV "ตัดเป็นคอลัมน์" | mkV "กวด" | mkV "ตาม" | mkV "แกะ" | mkV "เร่ง" | mkV "ขับไล่" | mkV "ติดตาม" | mkV "ไล่กวด" | mkV "ไล่จับ" | mkV "ไล่ตาม" | mkV "วิ่งกวด" | mkV "วิ่งตาม" | mkV "วิ่งไล่" | mkV "สลักลาย" | mkV "เร่งรีบ" | mkV "ทําให้เป็นร่อง" | mkV "ประดับตกแต่งโดยการสลักหรือดุนลวดลาย" ; -- src=panlex
lin chase_V2 = mkV2 "ตื้อ" ; ---- | mkV "สลัก" | mkV "ตามจีบ" | mkV "ไล่จับ" | mkV "ตามตื้อ" | mkV "ตัดเป็นคอลัมน์" | mkV "กวด" | mkV "ตาม" | mkV "แกะ" | mkV "เร่ง" | mkV "ขับไล่" | mkV "ติดตาม" | mkV "ไล่กวด" | mkV "ไล่จับ" | mkV "ไล่ตาม" | mkV "วิ่งกวด" | mkV "วิ่งตาม" | mkV "วิ่งไล่" | mkV "สลักลาย" | mkV "เร่งรีบ" | mkV "ทําให้เป็นร่อง" | mkV "ประดับตกแต่งโดยการสลักหรือดุนลวดลาย" ; -- src=panlex
lin chaser_N = mkN "ผู้ตามล่า" | mkN "นักล่า" | mkN "ผู้ตามล่า" | mkN "ผู้ไล่ตาม" ; -- src=panlex
lin chasm_N = mkN "เหว" | mkN "ช่อง" | mkN "รอยแตก" | mkN "รอยแยก" | mkN "หุบเหว" | mkN "ส่วนแตก" | mkN "ส่วนแยก" | mkN "ช่องว่าง" | mkN "การขาดตอน" | mkN "ชั้นที่ขาด" | mkN "ช่วงที่ขาดตอน" | mkN "ช่องธารน้ําแข็ง" | mkN "ความแตกต่างกันมาก" | mkN "รอยแยกของพื้นผิวโลก" | mkN "ความแตกต่างทางความคิดหรือความรู้สึก" ; -- src=panlex
lin chassis_N = mkN "กาย" | mkN "สังขาร" | mkN "โครงรถ" | mkN "ร่างกาย" | mkN "พระวรกาย" | mkN "ร่างกายมนุษย์" | mkN "ร่างกายของมนุษย์" | mkN "ร่างกาย" | mkN "โครงช่วงล่าง" | mkN "ฐานะเครื่องวิทยุ" | mkN "โครงลําเครื่องบิน" | mkN "โครงรถยนต์ที่รวมทั้งเครื่องยนต์และล้อ" ; -- src=panlex
lin chaste_A = mkA "ซึ่งไม่มีประสบการณ์ทางเพศ" | mkA "ง่าย ๆ" | mkA "ดีงาม" | mkA "สุภาพ" | mkA "เรียบ ๆ" | mkA "ไม่ลามก" | mkA "พรหมจารี" | mkA "บริสุทธิ์" | mkA "ไม่หยาบโลน" | mkA "ปราศจากมลทิน" | mkA "ยังไม่แต่งงาน" | mkA "สะอาดบริสุทธิ์" | mkA "ซึ่งรักษาพรหมจารี" | mkA "ที่มีความคิดบริสุทธิ์" | mkA "ที่ไม่คิดในทางชั่วร้าย" ; -- src=panlex
lin chastisement_N = mkN "การลงโทษ" | mkN "การติเตียน" ; -- src=panlex
lin chastity_N = mkN "การถือพรหมจรรย์" | mkN "การไม่ประพฤติผิดในกาม" | mkN "พรหมจารี" | mkN "พรหมจรรย์" | mkN "ความบริสุทธิ์" | mkN "ความสะอาดหมดจด" | mkN "การถือพรหมจรรย์" | mkN "ความเป็นพรหมจรรย์" | mkN "การละเว้นเรื่องเพศ" | mkN "ความกะทัดรัดและเรียบ ๆ" ; -- src=panlex
lin chasuble_N = mkN "เสื้อคลุมบาทหลวง" ; -- src=panlex
lin chat_N = mkN "นกแชต" | mkN "นกแชท" | mkN "การคุย" | mkN "การพูดคุย" | mkN "การอภิปราย" | mkN "การพูดคุย" | mkN "การคุยเล่น" | mkN "การพูดคุยกันเล่นๆ" ; -- src=panlex
lin chat_V = mkV "จ้อ" | mkV "เมาท์" | mkV "ซุบซิบ" | mkV "พูดคุย" | mkV "พูดคุยสนุกๆ" | mkV "พูดคุยไร้สาระ" | mkV "พูดเรื่อยเปื่อย" | mkV "คุย" | mkV "จ้อ" | mkV "พูด" | mkV "พูดคุย" | mkV "โอภาปราศรัย" ; -- src=panlex
lin chateau_N = mkN "คฤหาสน์ในฝรั่งเศส" | mkN "ปราสาท" ; -- src=panlex
lin chattel_N = mkN "สังหาริมทรัพย์" | mkN "ทาส" | mkN "สังหาริมทรัพย์" | mkN "ทรัพย์สมบัติที่เคลื่อนย้ายได้" ; -- src=panlex
lin chatter_N = mkN "เสียงจ้อกแจ้ก" | mkN "เสียงสัตว์ร้อง" | mkN "เสียงเครื่องจักร" ; -- src=panlex
lin chatter_V = mkV "จ้อ" | mkV "เมาท์" | mkV "คุยจ้อ" | mkV "ซุบซิบ" | mkV "พูดคุย" | mkV "พูดไร้สาระ" | mkV "พูดคุยสนุกๆ" | mkV "พูดเพ้อเจ้อ" | mkV "พูดเืพ้อเจ้อ" | mkV "พูดคุยไร้สาระ" | mkV "พูดเรื่อยเปื่อย" | mkV "พล่าม" | mkV "พูดจ้อ" | mkV "พูดพล่าม" | mkV "เพ้อเจ้อ" | mkV "พูดไร้สาระ" | mkV "พูดเพ้อเจ้อ" | mkV "พูดไปเรื่อย" | mkV "พูดเรื่อยเปื่อย" | mkV "พูดเสียงสั่นกึกๆ" ; -- src=panlex
lin chatterbox_N = mkN "คนช่างพูด" | mkN "คนพูดไม่ชัด" | mkN "สตรีมออร์คิด" | mkN "คนปากจัด" | mkN "คนพูดมากเกินไป" | mkN "คนที่พูดไม่หยุด" ; -- src=panlex
lin chatterer_N = mkN "คนช่างพูด" | mkN "นกโคติงกา" | mkN "คนพูดไม่ชัด" ; -- src=panlex
lin chatty_A = mkA "คุยเก่ง" | mkA "ช่างคุย" | mkA "ช่างพูด" | mkA "พูดเก่ง" | mkA "ช่างเจรจา" | mkA "ชอบคุยเล่น" ; -- src=panlex
lin chauffeur_N = mkN "พ.ข.ร." | mkN "พขร." | mkN "พลขับ" | mkN "คนขับรถ" | mkN "โชเฟอร์" | mkN "พนักงานขับรถ" | mkN "โชเฟอร์" | mkN "คนขับรถยนต์" ; -- src=panlex
lin chauffeuse_N = mkN "โชเฟอร์หญิง" | mkN "พนักงานขับรถหญิง" ; -- src=panlex
lin chaulmoogra_N = mkN "ต้นกระเบา" | mkN "ต้นกระเบา" ; -- src=panlex
lin chauvinism_N = mkN "ความคลั่งชาติ" | mkN "การยึดถืออุดมการณ์อย่างอคติ" | mkN "การเชื่อว่าประเทศหรือเชื้อชาติของตนสําคัญที่สุด" ; -- src=panlex
lin chauvinist_N = mkN "คนคลั่งชาติ" ; -- src=panlex
lin chaw_N = mkN "ก้อน" | mkN "ก้อนยาฉุน" ; -- src=panlex
lin cheap_A = mkA "ถูก" | mkA "ห่วย" | mkA "ไม่แพง" | mkA "ประหยัด" | mkA "ย่อมเยา" | mkA "ห่วยแตก" | mkA "ซังกะบ๊วย" | mkA "ที่ราคาถูก" | mkA "ที่มีราคาถูก" | mkA "ถูก" | mkA "ขวยใจ" | mkA "ตระหนี่" | mkA "ย่อมเยา" | mkA "ราคาถูก" | mkA "หยาบคาย" | mkA "ขั้นต่ํา" | mkA "ราคาต่ํา" | mkA "ขี้เหนียว" | mkA "คุณภาพต่ํา" | mkA "ไร้ศีลธรรม" | mkA "ราคาประหยัด" | mkA "ราคาย่อมเยา" | mkA "ซึ่งได้มาง่าย" ; -- src=panlex
lin cheapen_V = mkV "ถูกลง" | mkV "ราคาถูกขึ้น" | mkV "ทําให้ราคาถูกขึ้น" ; -- src=panlex
lin cheapen_V2 = mkV2 "ถูกลง" ; ---- | mkV "ราคาถูกขึ้น" | mkV "ทําให้ราคาถูกขึ้น" ; -- src=panlex
lin cheapjack_N = mkN "คนขายของคุณภาพต่ำ" ; -- src=panlex
lin cheapness_N = mkN "ราคาถูก" | mkN "ราคาเซล" | mkN "ความไร้รสนิยม" | mkN "ราคาถูก" ; -- src=panlex
lin cheat_N = mkN "คนโกง" | mkN "การโกง" | mkN "คนคดโกง" | mkN "ข้าวสาลี" | mkN "การทุจริต" | mkN "คนหลอกลวง" | mkN "นักต้มตุ๋น" | mkN "คนโกง" | mkN "การโกง" | mkN "การคดโกง" | mkN "การทุจริต" | mkN "คนหลอกลวง" | mkN "การหลอกลวง" | mkN "สิ่งที่หลอกลวง" ; -- src=panlex
lin cheat_V = mkV "โกง" | mkV "คบชู้" | mkV "นอกใจ" | mkV "มีชู้" | mkV "สวมเขา" | mkV "เล่นโกง" | mkV "คบชู้สู่ชาย" | mkV "โกง" | mkV "นอกใจ" | mkV "มีชู้" | mkV "ทุจริต" | mkV "ต้มตุ๋น" | mkV "หลอกลวง" | mkV "ประพฤตินอกใจ" | mkV "ไม่ซื่อสัตย์" ; -- src=panlex
lin cheat_V2 = mkV2 "โกง" ; ---- | mkV "คบชู้" | mkV "นอกใจ" | mkV "มีชู้" | mkV "สวมเขา" | mkV "เล่นโกง" | mkV "คบชู้สู่ชาย" | mkV "โกง" | mkV "นอกใจ" | mkV "มีชู้" | mkV "ทุจริต" | mkV "ต้มตุ๋น" | mkV "หลอกลวง" | mkV "ประพฤตินอกใจ" | mkV "ไม่ซื่อสัตย์" ; -- src=panlex
lin chebab_N = mkN "เชอแบ็บ" ; -- src=panlex
lin check_N = mkN "รอย" | mkN "เช็ค" | mkN "การรุก" | mkN "การตรวจ" | mkN "การหยุด" | mkN "รอยสลัก" | mkN "ใบเสร็จ" | mkN "การควบคุม" | mkN "เช็คมาร์ค" | mkN "การตรวจจับ" | mkN "การพิสูจน์" | mkN "การเข้าสกัด" | mkN "สิ่งกีดขวาง" | mkN "การหยุดชะงัก" | mkN "ลายตารางหมากรุก" | mkN "รอย" | mkN "เช็ค" | mkN "การหยุด" | mkN "การเช็ค" | mkN "ใบเสร็จ" | mkN "การทดสอบ" | mkN "ตาหมากรุก" | mkN "การตรวจสอบ" | mkN "ลายหมากรุก" | mkN "การตรวจสภาพ" | mkN "การเข้าสกัด" | mkN "รอยร้าวเล็กๆ" | mkN "หนังสือตราสาร" | mkN "การเข้ากีดขวาง" | mkN "การหยุดอยู่กับที่" | mkN "สิ่งที่เหนี่ยวรั้งจิตใจ" ; -- src=panlex
lin check_V = mkV "ดู" | mkV "ฝึก" | mkV "หัก" | mkV "แตก" | mkV "ตรวจ" | mkV "ติ๊ก" | mkV "อบรม" | mkV "เช็ก" | mkV "เช็ค" | mkV "มาร์ค" | mkV "ควบคุม" | mkV "ตรงกัน" | mkV "ตรวจดู" | mkV "รุกฆาต" | mkV "แตกหัก" | mkV "กลมกลืน" | mkV "ค้นคว้า" | mkV "ตรวจสอบ" | mkV "แตกร้าว" | mkV "ตรวจเช็ก" | mkV "ตรวจเช็ค" | mkV "สกัดกั้น" | mkV "เห็นด้วย" | mkV "เขียนเช็ค" | mkV "เหมือนกัน" | mkV "ทำเครื่องหมาย" | mkV "ตรวจความถูกต้อง" | mkV "ฝาก" | mkV "แตก" | mkV "ตรวจ" | mkV "ร้าว" | mkV "เช็ค" | mkV "ควบคุม" | mkV "ฝากของ" | mkV "รุกฆาต" | mkV "ตรวจสอบ" | mkV "ยับยั้ง" | mkV "หยุดยั้ง" | mkV "ขีดกากบาท" | mkV "หยุดชะงัก" | mkV "ดูให้แน่ใจ" | mkV "ทําให้โตช้า" | mkV "ทําสัญลักษณ์" | mkV "หยุดกระทันหัน" | mkV "สํารวจให้แน่ใจ" | mkV "ทําให้เจริญเติบโตช้าลง" ; -- src=panlex
lin check_V2 = mkV2 "ดู" ; ---- | mkV "ฝึก" | mkV "หัก" | mkV "แตก" | mkV "ตรวจ" | mkV "ติ๊ก" | mkV "อบรม" | mkV "เช็ก" | mkV "เช็ค" | mkV "มาร์ค" | mkV "ควบคุม" | mkV "ตรงกัน" | mkV "ตรวจดู" | mkV "รุกฆาต" | mkV "แตกหัก" | mkV "กลมกลืน" | mkV "ค้นคว้า" | mkV "ตรวจสอบ" | mkV "แตกร้าว" | mkV "ตรวจเช็ก" | mkV "ตรวจเช็ค" | mkV "สกัดกั้น" | mkV "เห็นด้วย" | mkV "เขียนเช็ค" | mkV "เหมือนกัน" | mkV "ทำเครื่องหมาย" | mkV "ตรวจความถูกต้อง" | mkV "ฝาก" | mkV "แตก" | mkV "ตรวจ" | mkV "ร้าว" | mkV "เช็ค" | mkV "ควบคุม" | mkV "ฝากของ" | mkV "รุกฆาต" | mkV "ตรวจสอบ" | mkV "ยับยั้ง" | mkV "หยุดยั้ง" | mkV "ขีดกากบาท" | mkV "หยุดชะงัก" | mkV "ดูให้แน่ใจ" | mkV "ทําให้โตช้า" | mkV "ทําสัญลักษณ์" | mkV "หยุดกระทันหัน" | mkV "สํารวจให้แน่ใจ" | mkV "ทําให้เจริญเติบโตช้าลง" ; -- src=panlex
lin check_back_V = advV OP_check_V OP_back_Adv ; -- guess-p-verb
lin check_by_V2 = prepV2 OP_check_V OP_by_Prep ; -- guess-p-verb
lin check_for_V2 = prepV2 OP_check_V OP_for_Prep ; -- guess-p-verb
lin check_in_V = advV OP_check_V OP_in_Adv ; -- guess-p-verb
lin check_in_V2 = prepV2 OP_check_V OP_in_Prep ; -- guess-p-verb
lin check_into_V2 = prepV2 OP_check_V OP_into_Prep ; -- guess-p-verb
lin check_off_V2 = prepV2 OP_check_V OP_off_Prep ; -- guess-p-verb
lin check_on_V2 = prepV2 OP_check_V OP_on_Prep ; -- guess-p-verb
lin check_out_V = advV OP_check_V OP_out_Adv ; -- guess-p-verb
lin check_out_V2 = prepV2 OP_check_V OP_out_Prep ; -- guess-p-verb
lin check_out_of_V2 = prepV2 (advV OP_check_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin check_over_V2 = prepV2 OP_check_V OP_over_Prep ; -- guess-p-verb
lin check_through_V2 = prepV2 OP_check_V OP_through_Prep ; -- guess-p-verb
lin check_up_on_V2 = prepV2 (advV OP_check_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin check_with_V2 = prepV2 OP_check_V OP_with_Prep ; -- guess-p-verb
lin checkbook_N = mkN "สมุดเช็ค" | mkN "สมุดเช็ค" ; -- src=panlex
lin checker_N = mkN "เบี้ย" | mkN "ผู้ตรวจสอบ" | mkN "เบี้ยหมากฮอส" | mkN "คนดูแลสัมภาระ" | mkN "ผู้ดูแลสัมภาระ" | mkN "ตัวหมากรุก" | mkN "ตารางหมากรุก" | mkN "ผู้ที่ตรวจสอบ" ; -- src=panlex
lin checkerbloom_N = mkN "ต้นเช็คเกอร์บลูม" ; -- src=panlex
lin checkerboard_N = mkN "กระดานที่เป็นตาราง" | mkN "กระดานหมากรุกหรือหมากฮอส" ; -- src=panlex
lin checkers_N = mkN "หมากฮอส" ; -- src=panlex
lin checklist_N = mkN "รายชื่อ" | mkN "รายการสิ่งของ" ; -- src=panlex
lin checkmate_N = mkN "ชัยชนะที่ขาวสะอาด" | mkN "ชัยชนะที่สวยสดงดงาม" | mkN "การอยู่ในตําแหน่งชนะในการเล่นหมากรุก" ; -- src=panlex
lin checkout_N = mkN "การตรวจ" | mkN "เวลาออก" | mkN "การตรวจจับ" | mkN "เคาน์เตอร์" | mkN "เคาน์เตอร์ชำระเงิน" | mkN "การตรวจสอบก่อนออก" | mkN "การทดสอบความพร้อม" | mkN "จุดจ่ายเงินในห้างสรรพสินค้า" | mkN "การแจ้งออกจากที่พักหรือห้องของโรงแรม" ; -- src=panlex
lin checkpoint_N = mkN "จุดตรวจ" | mkN "ด่าน" | mkN "จุดตรวจ" | mkN "ด่านตรวจ" | mkN "จุดตรวจสอบ" ; -- src=panlex
lin checkroom_N = mkN "ห้องรับฝากของ" | mkN "ห้องฝากหมวก เสื้อคลุมและสิ่งของอื่น ๆ" | mkN "ห้องรับฝากวางหมวก กระเป๋าหรือสิ่งของไว้ชั่วคราว" ; -- src=panlex
lin checkup_N = mkN "การตรวจสุขภาพ" | mkN "การตรวจร่างกาย" | mkN "การตรวจสอบ" | mkN "การตรวจร่างกาย" | mkN "การตรวจสุขภาพร่างกายอย่างละเอียด" ; -- src=panlex
lin cheddar_N = mkN "เนยแข็ง" | mkN "เชดดาร์ชีส" | mkN "อเมริกันชีส" | mkN "เนยแข็งอเมริกัน" | mkN "เนยแข็งลื่นชนิดหนึ่ง" ; -- src=panlex
lin cheek_N = mkN "แก้ม" | mkN "พระปราง" | mkN "ความกล้า" | mkN "เครื่องกีดขวาง" | mkN "ปราง" | mkN "แก้ม" | mkN "ความทะลึ่ง" | mkN "พฤติกรรมที่ทะลึ่ง" ; -- src=panlex
lin cheekbone_N = mkN "โหนกแก้ม" | mkN "กระดูกโหนกแก้ม" | mkN "โหนกแก้ม" ; -- src=panlex
lin cheeky_A = mkA "ทะลึ่ง" | mkA "หน้าด้าน" | mkA "ไร้ยางอาย" | mkA "ที่ไม่เคารพ" ; -- src=panlex
lin cheep_N = mkN "เสียงจิ๊บๆ" | mkN "เสียงร้องแหลมสั้นๆ" ; -- src=panlex
lin cheep_V = mkV "ร้องจิ๊บๆ" | mkV "ร้องเสียงแหลมสั้นๆ" | mkV "ทําเสียงร้องแหลมสั้นๆ" ; -- src=panlex
lin cheer_N = mkN "ความเบิกบาน" | mkN "เสียงเชียร์" | mkN "เสียงโห่ร้อง" | mkN "การส่งเสียงเชียร์" | mkN "ความสดชื่นรื่นเริง" ; -- src=panlex
lin cheer_V = mkV "เชียร์" | mkV "โห่ร้อง" | mkV "ให้กำลังใจ" | mkV "ทำให้ใจกล้า" | mkV "ส่งเสียงเชียร์" | mkV "ส่งเสียงให้กำลังใจ" | mkV "เชียร์" | mkV "ให้กําลังใจ" | mkV "ทําให้สดชื่น" | mkV "รื่นเริงขึ้น" | mkV "ทําให้รื่นเริง" | mkV "มีกําลังใจขึ้น" | mkV "ทําให้มีกําลังใจ" | mkV "เปล่งเสียงแสดงความยินดี" ; -- src=panlex
lin cheer_V2 = mkV2 "เชียร์" ;
lin cheerer_N = mkN "คนเชียร์" | mkN "กองเชียร์" ; -- src=panlex
lin cheerful_A = mkA "สดใส" | mkA "สดชื่น" | mkA "ร่าเริง" | mkA "แช่มชื่น" | mkA "ที่ทําให้รู้สึกสดชื่น" | mkA "มีความสุขและมองโลกในแง่ดี" ; -- src=panlex
lin cheerfulness_N = mkN "ความเบิกบาน" | mkN "ความสดชื่น" | mkN "ความแจ่มใส" ; -- src=panlex
lin cheering_N = mkN "การส่งเสียงเชียร์" ; -- src=panlex
lin cheerleader_N = mkN "ผู้นำเชียร์" | mkN "เชียร์ลีดเดอร์" | mkN "คนที่ส่งเสียงเชียร์" | mkN "ประธานเชียร์" | mkN "เชียร์ลีดเดอร์" | mkN "คนที่เป็นผู้นําเชียร์" ; -- src=panlex
lin cheerless_A = mkA "หดหู่" | mkA "หดหู่ใจ" | mkA "เศร้าซึม" | mkA "ไม่แจ่มใส" | mkA "ไม่ร่าเริง" | mkA "ไม่รื่นเริง" | mkA "ไม่มีเสียงโห่ร้องสนับสนุน" ; -- src=panlex
lin cheers_Interj = mkInterj (thword "ไช" "โย") ;
lin cheery_A = mkA "สดชื่น" | mkA "แจ่มใส" | mkA "ร่าเริง" | mkA "เป็นสุข" | mkA "สนุกสนาน" | mkA "ที่มีความสุข" ; -- src=panlex
lin cheese_N = mkN (thword "เนย" "แข็ง") "ก้อน" ;
lin cheeseboard_N = mkN "ถาดชีส" ; -- src=panlex
lin cheeseburger_N = mkN "ชีสเบอร์เกอร์" | mkN "แฮมเบอร์เกอร์ใส่ชีส" | mkN "ขนมปังสอดไส้แผ่นเนยแข็ง" | mkN "แฮมเบอเกอร์ที่มีแผ่นเนยอยู่ข้างบน" ; -- src=panlex
lin cheesecake_N = mkN "ชีสเค้ก" | mkN "ภาพวาบหวิว" | mkN "ชีสเค้ก" | mkN "เค้กชนิดหนึ่งที่มีชีสเป็นส่วนผสม" ; -- src=panlex
lin cheesecloth_N = mkN "ผ้าห่อเนย" | mkN "ผ้าฝ้ายบางๆ และมีการทอหลวมๆ" | mkN "ผ้าฝ้ายหยาบและเบา" ; -- src=panlex
lin cheeselike_A = mkA "ที่เหมือนชีส" | mkA "ที่นุ่มเหมือนชีส" ; -- src=panlex
lin cheesemonger_N = mkN "คนขายชีส" | mkN "พ่อค้าเนย" ; -- src=panlex
lin cheeseparing_A = mkA "ใจแคบ" | mkA "ขี้เหนียว" ; -- src=panlex
lin cheetah_N = mkN "ชีต้า" | mkN "เสือชีต้า" | mkN "เสือชีตาฮ์" | mkN "เสือชีตาร์" | mkN "แมวป่าคล้ายเสือดาวและสุนัข" ; -- src=panlex
lin chef_N = mkN "เชฟ" | mkN "หัวหน้าครัว" | mkN "หัวหน้าพ่อครัว" | mkN "คนครัว" | mkN "หัวหน้าครัว" | mkN "หัวหน้าพ่อครัว" ; -- src=panlex
lin cheilitis_N = mkN "ริมฝีปากอักเสบ" ; -- src=panlex
lin chela_N = mkN "ก้าม" | mkN "คีลา" | mkN "สาวก" | mkN "สานุศิษย์" | mkN "ก้ามของกุ้งหรือปู" ; -- src=panlex
lin chelate_A = mkA "คีเลต" | mkA "คึเลต" | mkA "ที่คล้ายคีเลต" | mkA "คล้ายก้ามปูหรือกุ้ง" ; -- src=panlex
lin chelate_N = mkN "คีเลต" | mkN "สารประกอบคีเลต" ; -- src=panlex
lin chelation_N = mkN "คีเลชัน" | mkN "คีเลชั่น" ; -- src=panlex
lin chelicera_N = mkN "คีลิเซอรา" ; -- src=panlex
lin chelonian_N = mkN "คีโลเนียน" ; -- src=panlex
lin chemical_A = mkA "เคมี" | mkA "ทางเคมี" | mkA "ทางเคมี" ; -- src=panlex
lin chemical_N = mkN "สารเคมี" | mkN "สารเคมี" ; -- src=panlex
lin chemiluminescence_N = mkN "การเปล่งแสงทางเคมี" ; -- src=panlex
lin chemise_N = mkN "ชุดชั้นใน" | mkN "เสื้อตัวหลวมๆ ไม่มีแขนสําหรับใส่ชั้นในของผู้หญิง" ; -- src=panlex
lin chemisorption_N = mkN "การดูดซับทางเคมี" | mkN "การดูดแนบทางเคมี" ; -- src=panlex
lin chemistFem_N = variants {} ; ---- sense to be split
lin chemistMasc_N = variants {} ; ---- sense to be split
lin chemistry_N = mkN "เคมี" | mkN "วิชาเคมี" | mkN "การมีปฏิกิริยา" | mkN "วิทยาศาสตร์เคมี" | mkN "คุณสมบัติทางเคมี" | mkN "วิชาเคมี" | mkN "คุณสมบัติทางเคมี" | mkN "วิถีทางที่ทําให้เกิดความสัมพันธ์ระหว่างบุคคล" ; -- src=panlex
lin chemoreceptor_N = mkN "ตัวรับสัมผัสเคมี" ; -- src=panlex
lin chemosis_N = mkN "เยื่อตาบวมน้ำ" ; -- src=panlex
lin chemosurgery_N = mkN "การผ่าตัดด้วยสารเคมี" ; -- src=panlex
lin chemosynthesis_N = mkN "การสังเคราะห์ทางเคมี" ; -- src=panlex
lin chemotherapy_N = mkN "เคมีบำบัด" | mkN "เคมีบําบัด" ; -- src=panlex
lin chenille_N = mkN "ผ้าแชแนล" | mkN "ด้ายไหมกำมะหยี่" | mkN "สิ่งทอกํามะหยี่" | mkN "ด้ายไหมกํามะหยี่" ; -- src=panlex
lin cheque_N = mkN "เช็ค" | mkN "เช็ค" | mkN "ใบสั่งจ่ายเงิน" | mkN "เอกสารที่ผู้สั่งจ่ายเขียนเพื่อให้ธนาคารจ่ายเงินแก่ผู้ถือ" ; -- src=panlex
lin chequebook_N = mkN "สมุดเช็ค" ; -- src=panlex
lin cherimoya_N = mkN "เชอริโมยา" | mkN "ต้นเชอริโมยา" | mkN "ลูกเชอริโมยา" ; -- src=panlex
lin cheroot_N = mkN "ซิการ์เชอรูท" | mkN "บุหรี่พม่า" | mkN "บุหรี่ซิการ์หัวสี่เหลี่ยม" ; -- src=panlex
lin cherry_A = mkA "แดง" ; -- src=panlex
lin cherry_N = mkN "สีแดง" | mkN "เชอรี่" | mkN "ไม้เชอรี่" | mkN "ผลเชอร์รี่" | mkN "ต้นเชสต์นัต" | mkN "ต้นเชอร์รี่" | mkN "ลูกเชอร์รี่" | mkN "สีแดงเชอร์รี่" | mkN "ผลเชอรี่" | mkN "เชอร์รี่" | mkN "ต้นเชอรี่" | mkN "สีแดงสดใส" | mkN "ผลเชอร์รี่" | mkN "เยื่อพรหมจารี" | mkN "ความเป็นหญิงบริสุทธิ์" ; -- src=panlex
lin cherrystone_N = mkN "เมล็ดเชอร์รี่" | mkN "หอยเชอร์รี่สโตน" | mkN "เมล็ดเชอรี่" ; -- src=panlex
lin chert_N = mkN "หินควอตซ์แน่นชนิดหนึ่ง" ; -- src=panlex
lin cherub_N = mkN "เทวดาเด็ก" | mkN "เด็กน้อยน่ารัก" | mkN "เทวดาเด็ก" | mkN "เด็กที่น่ารัก" | mkN "เด็กที่ไร้เดียงสา" | mkN "ผู้ที่มีใบหน้าหวาน" | mkN "เด็กทูตสวรรค์ที่มีปีก" ; -- src=panlex
lin cherubic_A = mkA "แห่งเทพธิดา" ; -- src=panlex
lin chervil_N = mkN "ใบเชอร์วิล" | mkN "ต้นเชอร์วิล" | mkN "พืชตระกูลผักชีใบเรียวเล็ก" ; -- src=panlex
lin chess_N = mkN "หมากรุก" | mkN "ข้าวสาลี" | mkN "หมากรุก" | mkN "ข้าวสาลี" | mkN "เกมหมากรุก" ; -- src=panlex
lin chessboard_N = mkN "กระดานหมากรุก" | mkN "กระดานหมากรุก" ; -- src=panlex
lin chessman_N = mkN "ตัวหมากรุก" | mkN "เม็ดหมากรุก" | mkN "เบี้ยหมากรุก" ; -- src=panlex
lin chest_N = mkN "อก" | mkN "หีบ" | mkN "ทรวงอก" | mkN "หน้าอก" | mkN "พระทรวง" | mkN "พระอุระ" | mkN "ตู้มีลิ้นชัก" | mkN "ลิ้นชักใส่เสื้อผ้า" | mkN "ตู้ลิ้นชักใส่เสื้อผ้า" | mkN "อก" | mkN "ลัง" | mkN "หีบ" | mkN "คลัง" | mkN "กล่อง" | mkN "รอบอก" | mkN "ทรวงอก" | mkN "หน้าอก" | mkN "เต้านม" | mkN "กรมคลัง" | mkN "เงินทุน" | mkN "ลังขนาดใหญ่" | mkN "เงินแผ่นดิน" | mkN "กล่องขนาดใหญ่" | mkN "กระทรวงการคลัง" | mkN "สิ่งที่เก็บอยู่ในหีบ" | mkN "ชั้นที่มีลิ้นชักใส่เสื้อผ้า" ; -- src=panlex
lin chesterfield_N = mkN "เก้าอี้นวมใหญ่" | mkN "โซฟาขนาดใหญ่" ; -- src=panlex
lin chestnut_N = mkN "สีเชสนัท" | mkN "ต้นเชสต์นัต" | mkN "ลูกเชสต์นัท" | mkN "ไม้เชสต์นัต" | mkN "ม้าสีน้ำตาลแก่" | mkN "ต้น เกาลัด" | mkN "เกาลัด" | mkN "ลูกเกาลัด" | mkN "สีน้ําตาลแก่" | mkN "คําพูดที่ตลกโปกฮาเก่า ๆ" ; -- src=panlex
lin chetrum_N = mkN "เชอตรัม" ; -- src=panlex
lin chevron_N = mkN "บั้ง" | mkN "บั้งทหาร" | mkN "รูปตัววี" | mkN "บั้งตำรวจ" | mkN "บั้งนายสิบหรือนายจ่า" ; -- src=panlex
lin chevrotain_N = mkN "สัตว์เคี้ยวเอื้องตัวเล็กมากที่คล้ายกวาง" ; -- src=panlex
lin chew_N = mkN "ก้อน" | mkN "การเคี้ยว" | mkN "ก้อนยาฉุน" | mkN "การบดเคี้ยว" ; -- src=panlex
lin chew_V = mkV "เคี้ยว" | mkV "บด" | mkV "เคี้ยว" ; -- src=panlex
lin chew_V2 = mkV2 "เคี้ยว" ; ---- | mkV "บด" | mkV "เคี้ยว" ; -- src=panlex
lin chewable_A = mkA "ที่เคี้ยวได้ง่าย" ; -- src=panlex
lin chewer_N = mkN "คนเคี้ยว" | mkN "ผู้เคี้ยว" ; -- src=panlex
lin chewink_N = mkN "นกชีวิงค์" ; -- src=panlex
lin chewy_A = mkA "ที่ต้องเคี้ยวหลายครั้ง" | mkA "เคี้ยวไม่ได้ง่าย" ; -- src=panlex
lin chez_Prep = mkPrep "กับ" | mkPrep "ในบ้าน" ; -- src=panlex
lin chi_N = mkN "ไค" | mkN "ชี่" | mkN "ลมปราณ" | mkN "พลังชีวิต" | mkN "พลังของชีวิต" | mkN "พยัญชนะตัวที่ 22 ของภาษากรีก" ; -- src=panlex
lin chiasma_N = mkN "จุดไขว้" | mkN "การตัดสลับกัน" | mkN "การแลกเปลี่ยนส่วนของโครโมโซม" ; -- src=panlex
lin chic_A = mkA "เก๋" | mkA "ความงาม" | mkA "ทันสมัย" | mkA "แบบที่เก๋" ; -- src=panlex
lin chic_N = mkN "ความเท่" | mkN "ความทันสมัย" | mkN "ความสวยงามทันสมัย" ; -- src=panlex
lin chicane_N = mkN "การใช้กลลวง" | mkN "เล่ห์เหลี่ยม" | mkN "การทำให้หลงกล" | mkN "การทำให้เสียรู้" | mkN "เครื่องกีดขวางทาง" | mkN "การหลอก" | mkN "เพทุบาย" | mkN "การไม่มีไพ่สําคัญในมือ" ; -- src=panlex
lin chicanery_N = mkN "การใช้กลลวง" | mkN "เล่ห์เหลี่ยม" | mkN "การทำให้หลงกล" | mkN "การทำให้เสียรู้" | mkN "เล่ห์" | mkN "เพทุบาย" | mkN "เล่ห์กล" | mkN "การใช้กลลวง" | mkN "การใช่เล่ห์หลอก" ; -- src=panlex
lin chichi_A = mkA "เก๋" | mkA "โอ่อ่า" | mkA "ดูดีมาก" | mkA "ทันสมัย" | mkA "หล่อมาก" ; -- src=panlex
lin chichi_N = mkN "ความเท่" | mkN "ความทันสมัย" ; -- src=panlex
lin chichipe_N = mkN "ต้นชิชิป" ; -- src=panlex
lin chick_N = mkN "ลูกไก่" | mkN "น้องนาง" | mkN "สาวน้อย" | mkN "ลูกเจี๊ยบ" | mkN "เด็ก" | mkN "ลูกนก" | mkN "ลูกไก่" | mkN "ลูกเป็ด" | mkN "สาวน้อย" | mkN "หญิงสาว" | mkN "เด็กผู้หญิง" ; -- src=panlex
lin chickadee_N = mkN "นกชิกคาดี" ; -- src=panlex
lin chicken_A = mkA "ขี้ตกใจ" | mkA "ขี้ตื่น" | mkA "ขวัญหนีดีฝ่อ" | mkA "ขี้กลัว" | mkA "ขี้ขลาด" ; -- src=panlex
lin chicken_N = mkN "ไก่" ;
lin chickenpox_N = mkN "โรคอีสุกอีใส" | mkN "โรคอีสุกอีใส" | mkN "ไข้อีสุกอีใส" ; -- src=panlex
lin chickpea_N = mkN "ถั่วชิคพี" | mkN "ถั่วลูกไก่" | mkN "ต้นถั่วชิคพี" ; -- src=panlex
lin chickweed_N = mkN "ต้นหูหนู" | mkN "ต้นชิควีด" | mkN "ต้นชิควีดหูหนู" ; -- src=panlex
lin chicle_N = mkN "ชิเคิลกัม" | mkN "สารเหนียวที่ใช้ทําหมากฝรั่ง" ; -- src=panlex
lin chicory_N = mkN "ชิคอรี่" | mkN "ชิกคอรี่" | mkN "ต้นซักโครี่" | mkN "รากชิกคอรี่" | mkN "รากของพืชดังกล่าว" | mkN "ชื่อพืชดอกสีน้ําเงิน" ; -- src=panlex
lin chide_V = mkV "ดุ" | mkV "ด่า" | mkV "ด่่า" | mkV "ดุด่า" | mkV "ด่าว่า" | mkV "ดุด่า" ; -- src=panlex
lin chide_V2 = mkV2 "ดุ" ; ---- | mkV "ด่า" | mkV "ด่่า" | mkV "ดุด่า" | mkV "ด่าว่า" | mkV "ดุด่า" ; -- src=panlex
lin chief_A = mkA "หลัก" | mkA "สําคัญ" | mkA "มีอํานาจสูงสุด" ; -- src=panlex
lin chief_N = mkN "ห.น." | mkN "หน." | mkN "เฮด" | mkN "ลูกพี่" | mkN "หัวหน้า" | mkN "เจ้านาย" | mkN "โฟร์แมน" | mkN "หัวหน้าเผ่า" | mkN "หัวหน้าคนงาน" | mkN "ผู้นํา" | mkN "หัวหน้า" ; -- src=panlex
lin chieftainFem_N = variants {} ; ---- sense to be split
lin chieftainMasc_N = variants {} ; ---- sense to be split
lin chiffon_N = mkN "ผ้าชีฟอง" | mkN "ผ้าชีฟอง" | mkN "สิ่งทอบาง" ; -- src=panlex
lin chiffonier_N = mkN "ตู้ลิ้นชัก" ; -- src=panlex
lin chigetai_N = mkN "ลาป่าในมองโกเลีย" ; -- src=panlex
lin chignon_N = mkN "มวยผมสตรี" ; -- src=panlex
lin chilblain_N = mkN "ภาวะมือและเท้าอักเสบ" ; -- src=panlex
lin child_N = personN (thword "ลูก") | {-pan-} mkN "ลูก" | mkN "บุตร" | mkN "เด็ก" | mkN "พยานรัก" | mkN "บุตรธิดา" | mkN "ผู้เยาว์" | mkN "เลือดในอก" | mkN "สมาชิกกลุ่ม" | mkN "โซ่ทองคล้องใจ" | mkN "เลือดเนื้อเชื้อไข" | mkN "ลูก" | mkN "ศิศุ" | mkN "เด็ก" | mkN "ทายาท" | mkN "ผลิตผล" | mkN "คนที่มีพฤติกรรมเหมือนเด็ก" ; -- src=panlex --- personN (thword "เด็ก") ;
lin childbirth_N = mkN "การคลอดลูก" | mkN "การคลอดบุตร" | mkN "การคลอดลูก" | mkN "การคลอดบุตร" ; -- src=panlex
lin childcare_N = mkN "การดูแลเด็ก" ; -- src=panlex
lin childhood_N = mkN "วัยเด็ก" | mkN "ความเป็นเด็ก" | mkN "ช่วงเป็นเด็ก" | mkN "ปฐมวัย" | mkN "วัยต้น" | mkN "ช่วงต้น" | mkN "วัยเด็ก" | mkN "ระยะต้นๆ" | mkN "ความเป็นเด็ก" | mkN "ระยะแรกเริ่ม" ; -- src=panlex
lin childish_A = mkA "เด็กๆ" | mkA "ไม่ประสา" | mkA "ราวกับทารก" | mkA "อ่อนต่อโลก" | mkA "เหมือนเด็ก" | mkA "ี่ไร้เดียงสา" ; -- src=panlex
lin childishness_N = mkN "ความเป็นเด็ก" | mkN "ความเยาว์วัย" ; -- src=panlex
lin childless_A = mkA "ไร้บุตร" | mkA "ไม่มีลูก" | mkA "ไม่มีบุตร" ; -- src=panlex
lin childlike_A = mkA "เหมือนเด็ก" | mkA "คล้ายเด็ก" | mkA "ที่เหมาะกับเด็ก" | mkA "ที่มีลักษณะเหมือนเด็ก" ; -- src=panlex
lin chileanFem_N = variants {} ; ---- sense to be split
lin chileanMasc_N = variants {} ; ---- sense to be split
lin chili_N = mkN "ชิลี" | mkN "พริก" | mkN "ความเผ็ด" | mkN "ความเผ็ดร้อน" ; -- src=panlex
lin chill_A = mkA "หนาว" | mkA "มึนตึง" | mkA "เย็นชา" | mkA "หนาวเย็น" ; -- src=panlex
lin chill_N = mkN "ความหนาว" | mkN "ความหนาวสั่น" | mkN "ความหนาวเย็น" | mkN "ความกลัวจนหนาว" | mkN "อาการสั่นสะท้าน" | mkN "ความรู้สึกหนาวสะท้าน" | mkN "ความหนาวเย็น" ; -- src=panlex
lin chill_V = mkV "เย็นลง" | mkV "ทำให้เย็นลง" | mkV "ทำให้หมดกำลังใจ" | mkV "ทําให้เย็น" ; -- src=panlex
lin chill_V2 = mkV2 "เย็นลง" ; ---- | mkV "ทำให้เย็นลง" | mkV "ทำให้หมดกำลังใจ" | mkV "ทําให้เย็น" ; -- src=panlex
lin chilliness_N = mkN "ความเย็นชา" | mkN "ความหนาวเย็น" | mkN "ความเย็นชา" | mkN "ความเมินเฉย" | mkN "ความไม่เป็นมิตร" ; -- src=panlex
lin chilly_A = mkA "หนาว" | mkA "เย็นชา" | mkA "หนาวสั่น" | mkA "เยือกเย็น" | mkA "หนาวยะเยือก" | mkA "ไม่เป็นมิตร" ; -- src=panlex
lin chilly_N = mkN "พริก" | mkN "ความเผ็ด" | mkN "ความเผ็ดร้อน" ; -- src=panlex
lin chimaera_N = mkN "ปลาชิแมรา" ; -- src=panlex
lin chime_N = mkN "ฆ้อง" | mkN "ระฆัง" | mkN "เสียงระฆัง" | mkN "เสียงระฆัง" ; -- src=panlex
lin chime_V = mkV "ส่งเสียง" ; -- src=panlex
lin chime_V2 = mkV2 "ส่งเสียง" ; ---- ; -- src=panlex
lin chimera_N = mkN "ความเพ้อผัน" | mkN "ความเพ้อฝัน" | mkN "พันธุ์ต่อกิ่งผสม" | mkN "สัตว์ประหลาดน่ากลัว" | mkN "ความฝันหรือความหวังที่ยากจะเป็นจริง" ; -- src=panlex
lin chimeric_A = mkA "เพ้อฝัน" | mkA "ไม่จริง" | mkA "ที่ไม่เป็นจริง" | mkA "ที่เป็นจินตนาการ" ; -- src=panlex
lin chimerical_A = mkA "เพ้อฝัน" | mkA "ไม่จริง" | mkA "ที่ไม่เป็นจริง" | mkA "ที่เป็นจินตนาการ" ; -- src=panlex
lin chimney_N = mkN "ปล่อง" | mkN "ปล่องไฟ" | mkN "ตะเกียงน้ำมัน" | mkN "แก้วครอบตะเกียง" | mkN "ปล่อง" | mkN "เตาผิง" | mkN "ปล่องไฟ" | mkN "ปล่องควัน" | mkN "เตาฝาผนัง" | mkN "คนติดบุหรี่" | mkN "หลอดตะเกียง" | mkN "ฝาครอบกระจกตะเกียงน้ํามัน" ; -- src=panlex
lin chimneypiece_N = mkN "หิ้งเหนือเตาผิง" ; -- src=panlex
lin chimneypot_N = mkN "ยอดปล่องไฟ" ; -- src=panlex
lin chimney_sweep_N = mkN "คนทำความสะอาดปล่องไฟ" ; -- src=panlex
lin chimneysweeper_N = mkN "คนทำความสะอาดปล่องไฟ" ; -- src=panlex
lin chimp_N = mkN "ชิมแปนซี" | mkN "ลิงชิมแปนซี" ; -- src=panlex
lin chimpanzee_N = mkN "ชิมแปนซี" | mkN "ลิงชิมแปนซี" | mkN "ลิงชิมแปนซี" | mkN "ลิงชิมแพนซี" ; -- src=panlex
lin chin_N = mkN "คาง" | mkN "พระหนุ" | mkN "คาง" ; -- src=panlex
lin china_N = mkN "เครื่องถ้วยชามจีน" | mkN "เครื่องลายครามจีน" | mkN "เครื่องถ้วยชามจากจีน" | mkN "เครื่องลายคราม" | mkN "เครื่องเคลือบดินเผา" ; -- src=panlex
lin chinaberry_N = mkN "ต้นฟอลส์ด็อกวู้ด" ; -- src=panlex
lin chinaware_N = mkN "เครื่องถ้วยชามจีน" | mkN "เครื่องลายคราม" | mkN "เครื่องกระเบื้องถ้วยชาม" | mkN "สิ่งประดับเครื่องลายคราม" ; -- src=panlex
lin chincapin_N = mkN "ชินคาปิน" ; -- src=panlex
lin chinchilla_N = mkN "ชินชิลลา" | mkN "ขนชินชิลลา" | mkN "ผ้าชินชิลลา" | mkN "สัตว์คล้ายหนู" ; -- src=panlex
lin chine_N = mkN "กระดูกสันหลัง" | mkN "เนื้อติดกระดูก" | mkN "กระดูกสันหลัง" ; -- src=panlex
lin chineseFem_N = variants {} ; ---- sense to be split
lin chineseMasc_N = variants {} ; ---- sense to be split
lin chink_N = mkN "เจ๊ก" | mkN "รอยแตก" | mkN "เสียงคลิก" | mkN "เงิน" | mkN "รอยแยก" | mkN "รอยร้าว" | mkN "ช่องโหว่" | mkN "รอยประสาน" | mkN "รอยแยกเล็กๆ" | mkN "เสียงดังกริ๊ง" ; -- src=panlex
lin chink_V = mkV "มีเสียงดังกริ๊ง" | mkV "ทําเสียงดังกริ๊ง" ; -- src=panlex
lin chink_V2 = mkV2 "มีเสียงดังกริ๊ง" ; ---- | mkV "ทําเสียงดังกริ๊ง" ; -- src=panlex
lin chino_N = mkN "ผ้าชีโน" | mkN "กางเกงผ้าชีโน" | mkN "ผ้าเนื้อหนาสีกากี" ; -- src=panlex
lin chinoiserie_N = mkN "ศิลปะจีน" | mkN "ศิลปะแบบจีน" | mkN "ศิลปะลวดลายจีน" ; -- src=panlex
lin chinook_N = mkN "ลมชินุก" | mkN "ปลาชินุก" | mkN "ปลาคิงแซลมอน" | mkN "เนื้อปลาชินุก" | mkN "เนื้อปลาคิงแซลมอน" ; -- src=panlex
lin chintz_N = mkN "ผ้าชินซ์" | mkN "ผ้าที่มีสีสว่างเป็นเงามัน" | mkN "สิ่งทอผ้าฝ้ายที่มีลายดอกขัดมัน" ; -- src=panlex
lin chip_N = mkN "ชิป" | mkN "รอย" | mkN "เศษ" | mkN "เบี้ย" | mkN "สะเก็ด" | mkN "รอยสลัก" | mkN "ไมโครชิป" | mkN "การชิพลูก" | mkN "เบี้ยพนัน" | mkN "เศษขี้วัว" | mkN "การกระเทาะ" | mkN "การแกะสลัก" | mkN "ขี้วัวแห้ง" | mkN "มันฝรั่งกรอบ" | mkN "มันฝรั่งแผ่น" | mkN "การเล่นลูกชิพ" | mkN "ชิ้นส่วนเล็กๆ" | mkN "มันฝรั่งทอดกรอบ" | mkN "มันฝรั่งแผ่นทอดกรอบ" | mkN "ชิพ" | mkN "เบี้ย" | mkN "การถาก" | mkN "การแกะ" | mkN "รอยแตก" | mkN "การสลัก" | mkN "รอยแหว่ง" | mkN "ไมโครชิป" | mkN "เศษที่แตกออก" | mkN "แผ่นไมโครชิป" | mkN "เศษที่บิ่นออก" | mkN "มันฝรั่งทอดแผ่นบางๆ" | mkN "เบี้ยที่ใช้แทนเงินในการเล่นพนัน" ; -- src=panlex
lin chip_V = mkV "ชิป" | mkV "บิ่น" | mkV "หักออก" | mkV "ตัด" | mkV "ถาก" | mkV "แกะ" | mkV "แตก" | mkV "สกัด" | mkV "ตัดออก" | mkV "กระเทาะ" | mkV "ทําให้เป็นรอยแหว่ง" ; -- src=panlex
lin chip_V2 = mkV2 "ชิป" ; ---- | mkV "บิ่น" | mkV "หักออก" | mkV "ตัด" | mkV "ถาก" | mkV "แกะ" | mkV "แตก" | mkV "สกัด" | mkV "ตัดออก" | mkV "กระเทาะ" | mkV "ทําให้เป็นรอยแหว่ง" ; -- src=panlex
lin chipboard_N = mkN "แผ่นไม้อัด" | mkN "แผ่นกระดาน" | mkN "กระดานแข็งถูก ๆ" | mkN "กระดานที่ทําจากการอัดไม้ที่ไม่ใช้แล้วกับเรซิน" ; -- src=panlex
lin chipmunk_N = mkN "กระแต" ; -- src=panlex
lin chipolata_N = mkN "ไส้กรอก" ; -- src=panlex
lin chipotle_N = mkN "ชิโปตเล" | mkN "ชิโปทเล" ; -- src=panlex
lin chipper_A = mkA "ร่าเริง" ; -- src=panlex
lin chips_N = mkN "เฟรนช์ฟราย" | mkN "มันฝรั่งทอด" ; -- src=panlex
lin chiropodist_N = mkN "หมอรักษาโรคเท้า" | mkN "ผู้ชำนาญในทางรักษาโรคเท้า" | mkN "ผู้ชำนาญในทางรักษาโรคเ้ท้า" | mkN "หมอรักษาโรคมือและเท้า" | mkN "แพทย์รักษาโรคที่เกี่ยวกับมือหรือเท้า" ; -- src=panlex
lin chiropody_N = mkN "บาทาเวชศาสตร์" | mkN "การรักษาโรคที่เกี่ยวกับมือหรือเท้า" ; -- src=panlex
lin chiropractic_N = mkN "การรักษาโรคด้วยวิธีนวดกระดูกสันหลัง" | mkN "การบําบัดโรคโดยวิธีการจับกระดูกสันหลัง" ; -- src=panlex
lin chiropractor_N = mkN "หมอนวดกระดูกสันหลัง" ; -- src=panlex
lin chirp_N = mkN "เสียงจ๊อกแจ๊ก" | mkN "เสียงร้องจ๊อกแจ๊ก" | mkN "เสียงนกร้อง" | mkN "เสียงร้องจ๊อกแจ๊ก" ; -- src=panlex
lin chirp_V = mkV "ร้องจิ๊บๆ" ; -- src=panlex
lin chirp_V2 = mkV2 "ร้องจิ๊บๆ" ; ---- ; -- src=panlex
lin chirpy_A = mkA "แจ่มใส" | mkA "ร่าเริง" ; -- src=panlex
lin chirrup_V = mkV "ร้องจิ๊บๆ" ; -- src=panlex
lin chirrup_V2 = mkV2 "ร้องจิ๊บๆ" ; ---- ; -- src=panlex
lin chisel_N = mkN "สิ่ว" | mkN "สิ่ว" ; -- src=panlex
lin chiseller_N = mkN "คนโกง" ; -- src=panlex
lin chit_N = mkN "ใบเสร็จ" | mkN "เด็ก" | mkN "เด็กสาว" | mkN "ใบเสร็จ" | mkN "หน่ออ่อน" | mkN "เด็กเล็ก ๆ" | mkN "ใบเสร็จรับของ" | mkN "ใบเซ็นชื่อเชื่อ" | mkN "ใบสําคัญหลักฐานการจ่าย" | mkN "จดหมายที่มีข้อความเล็กน้อย" ; -- src=panlex
lin chitchat_N = mkN "การพูดพร่ำ" | mkN "การพูดซุบซิบ" | mkN "การคุยเล่น" | mkN "การพูดคุยกันเล่นๆ" ; -- src=panlex
lin chitin_N = mkN "ไคติน" ; -- src=panlex
lin chiton_N = mkN "ลิ่นทะเล" ; -- src=panlex
lin chitterlings_N = mkN "ไส้หมู" ; -- src=panlex
lin chivalrous_A = mkA "กล้าหาญ" | mkA "เอาใจสตรี" | mkA "ให้เกียรติสตรี" | mkA "เกี่ยวกับอัศวิน" | mkA "ที่ให้เกียรติสตรี" ; -- src=panlex
lin chivalry_N = mkN "คติอัศวิน" | mkN "ความสุภาพ" | mkN "คุณสมบัติของอัศวิน" ; -- src=panlex
lin chives_N = mkN "หอมเล็ก" ; -- src=panlex
lin chlamydeous_A = mkA "เกี่ยวกับหรือมีส่วนหุ้มดอก" ; -- src=panlex
lin chlamydia_N = mkN "คลาไมเดีย" | mkN "โรคติดเชื้อคลาไมเดีย" ; -- src=panlex
lin chlamydospore_N = mkN "แคลมิโดสปอร์" ; -- src=panlex
lin chlamys_N = mkN "วงกลีบรวม" ; -- src=panlex
lin chlorambucil_N = mkN "ยาคลอแรมบิวซิล" ; -- src=panlex
lin chloramine_N = mkN "โคลรามีน" ; -- src=panlex
lin chloramphenicol_N = mkN "คลอโรไมซีติน" ; -- src=panlex
lin chlorate_N = mkN "คลอเรต" ; -- src=panlex
lin chlordiazepoxide_N = mkN "โคลร์ไดอะซีพอกไซด์" ; -- src=panlex
lin chlorella_N = mkN "สาหร่ายคลอเรลลา" ; -- src=panlex
lin chlorenchyma_N = mkN "คลอเรนไคมา" ; -- src=panlex
lin chlorhexidine_N = mkN "โคลร์เฮกซิดีน" ; -- src=panlex
lin chloride_N = mkN "คลอไรด์" | mkN "คลอไรด์" | mkN "เกลือของกรดเกลือ" | mkN "สารประกอบที่มีคลอรีน" ; -- src=panlex
lin chlorination_N = mkN "การใส่คลอรีน" ; -- src=panlex
lin chlorine_N = mkN "คลอรีน" | mkN "ก๊าซคลอรีน" | mkN "เลขอะตอม 17" | mkN "คลอรีน" ; -- src=panlex
lin chlorinity_N = mkN "ปริมาณคลอไรด์" ; -- src=panlex
lin chlorite_N = mkN "คลอไรต์" | mkN "แร่คลอไรต์" ; -- src=panlex
lin chloroacetophenone_N = mkN "คลอโรอะซิโทฟีโนน" ; -- src=panlex
lin chlorobenzene_N = mkN "คลอโรเบนซีน" ; -- src=panlex
lin chlorobenzylidenemalononitrile_N = mkN "แก๊สน้ำตา" ; -- src=panlex
lin chlorofluorocarbon_N = mkN "สารซีเอฟซี" | mkN "คลอโรฟลูโรคาร์บอน" ; -- src=panlex
lin chloroform_N = mkN "คลอโรฟอร์ม" | mkN "ยาสลบหรือระงับความรู้สึกชนิดหนึ่ง" | mkN "ของเหลวไม่มีสีทําให้หมดสติเมื่อสูดดม" ; -- src=panlex
lin chlorophyll_N = mkN "คลอโรฟีลล์" | mkN "คลอโรฟีลล์" | mkN "สารสีเขียวที่พบในพืชหรือแบคทีเรียบางชนิด" ; -- src=panlex
lin chloropicrin_N = mkN "คลอโรพิคริน" ; -- src=panlex
lin chloroplast_N = mkN "คลอโรพลาสต์" ; -- src=panlex
lin chloroprene_N = mkN "คลอโรพรีน" ; -- src=panlex
lin chloroquine_N = mkN "ยารักษาไข้มาเลเรีย" ; -- src=panlex
lin chlorosis_N = mkN "ภาวะพร่องคลอโรฟิลล์" ; -- src=panlex
lin chlorothiazide_N = mkN "โคลโรไทเออไซด์" ; -- src=panlex
lin chlorpromazine_N = mkN "โคลร์โพรมาซีน" ; -- src=panlex
lin chlorpyrifos_N = mkN "คลอร์ไพริฟอส" ; -- src=panlex
lin chlortetracycline_N = mkN "คลอร์เตตราไซคลีน" ; -- src=panlex
lin chlorthalidone_N = mkN "ไฮโกรทอน" ; -- src=panlex
lin choanocyte_N = mkN "เซลล์ปลอกคอ" ; -- src=panlex
lin choc_N = mkN "ช็อค" ; -- src=panlex
lin chock_Adv = mkAdv "เป็นไปได้อย่างมาก" ; -- src=panlex
lin chock_N = mkN "ลิ่ม" | mkN "ลิ่มรองล้อ" | mkN "ไม้หรือโลหะที่ใช้หนุนไว้ไม่ให้เคลื่อนที่" ; -- src=panlex
lin chocolate_A = mkA "ที่มีช็อกโกแลตเป็นส่วนประกอบ" ; -- src=panlex
lin chocolate_N = mkN "โกโก้" | mkN "สีกาแฟ" | mkN "ช็อคโกแลต" | mkN "สีน้ำตาลเข้ม" | mkN "ช็อกโกเลต" | mkN "ช็อกโกแลต" | mkN "สีน้ําตาลเข้ม" ; -- src=panlex
lin choice_A = mkA "ที่คัดสรร" | mkA "ที่เลือกเฟ้น" | mkA "ชั้นดี" | mkA "ชั้นเยี่ยม" | mkA "ที่มีคุณภาพดี" ; -- src=panlex
lin choice_N = mkN "ชอยซ์" | mkN "ออปชั่น" | mkN "การเลือก" | mkN "ตัวเลือก" | mkN "ทางเลือก" | mkN "การเลือก" | mkN "คัดเลือก" | mkN "ตัวเลือก" | mkN "ทางเลือก" | mkN "เด่นที่สุด" | mkN "ความพิถีพิถัน" | mkN "ผู้ที่ถูกเลือก" | mkN "สิ่งที่ถูกเลือก" | mkN "ส่วนที่ดีที่สุด" | mkN "ซึ่งเลือกสรรแล้ว" | mkN "ส่วนประกอบที่ดีที่สุด" ; -- src=panlex
lin choir_N = mkN "คณะนักร้อง" | mkN "กลุ่มเครื่องดนตรี" | mkN "นักร้องประสานเสียง" | mkN "ที่สำหรับนักร้องในโบสถ์" | mkN "คณะประสานเสียง" ; -- src=panlex
lin choirboy_N = mkN "นักร้องเด็กชาย" | mkN "เด็กผู้ชายที่ร้องในวง" ; -- src=panlex
lin choirmaster_N = mkN "นักร้องนำ" | mkN "ผู้นำกลุ่มนักร้องประสานเสียง" | mkN "วาทยกร" | mkN "ผู้กํากับวงดนตรี" ; -- src=panlex
lin choke_N = mkN "โช้ก" | mkN "โช้คคอยล์" | mkN "อาการสําลัก" | mkN "กลไกชนิดหนึ่งที่ควบคุมเครื่องยนต์" ; -- src=panlex
lin choke_V = mkV "ซี้" | mkV "ดับ" | mkV "ตาย" | mkV "ล้ม" | mkV "จากไป" | mkV "ติดคอ" | mkV "ทิวงคต" | mkV "มรณภาพ" | mkV "สวรรคต" | mkV "สิ้นลม" | mkV "สิ้นใจ" | mkV "อุดตัน" | mkV "จบชีวิต" | mkV "รัดแน่น" | mkV "สิ้นชีพ" | mkV "เข้าโลง" | mkV "เสียชีวิต" | mkV "ถึงแก่กรรม" | mkV "ทำให้สำลัก" | mkV "สิ้นพระชนม์" | mkV "หายใจไม่ออก" | mkV "เสด็จสวรรคต" | mkV "ขาดอากาศหายใจ" | mkV "ถึงชีพิตักษัย" | mkV "ถึงแก่พิราลัย" | mkV "ถึงแก่อนิจกรรม" | mkV "ถึงแก่อสัญกรรม" | mkV "สิ้นชีพิตักษัย" | mkV "ทำให้หายใจไม่ออก" | mkV "สำลัก" | mkV "สําลัก" | mkV "เค้นคอ" | mkV "หายใจขัด" | mkV "ทําให้อุดตัน" | mkV "ทําให้ท่ออุดตัน" | mkV "ทําให้หายใจไม่ออก" | mkV "ควบคุมเครื่องยนต์ให้อากาศเข้าไปในคาบิวเรเตอร์น้อยลง" ; -- src=panlex
lin choke_V2 = mkV2 "ซี้" ; ---- | mkV "ดับ" | mkV "ตาย" | mkV "ล้ม" | mkV "จากไป" | mkV "ติดคอ" | mkV "ทิวงคต" | mkV "มรณภาพ" | mkV "สวรรคต" | mkV "สิ้นลม" | mkV "สิ้นใจ" | mkV "อุดตัน" | mkV "จบชีวิต" | mkV "รัดแน่น" | mkV "สิ้นชีพ" | mkV "เข้าโลง" | mkV "เสียชีวิต" | mkV "ถึงแก่กรรม" | mkV "ทำให้สำลัก" | mkV "สิ้นพระชนม์" | mkV "หายใจไม่ออก" | mkV "เสด็จสวรรคต" | mkV "ขาดอากาศหายใจ" | mkV "ถึงชีพิตักษัย" | mkV "ถึงแก่พิราลัย" | mkV "ถึงแก่อนิจกรรม" | mkV "ถึงแก่อสัญกรรม" | mkV "สิ้นชีพิตักษัย" | mkV "ทำให้หายใจไม่ออก" | mkV "สำลัก" | mkV "สําลัก" | mkV "เค้นคอ" | mkV "หายใจขัด" | mkV "ทําให้อุดตัน" | mkV "ทําให้ท่ออุดตัน" | mkV "ทําให้หายใจไม่ออก" | mkV "ควบคุมเครื่องยนต์ให้อากาศเข้าไปในคาบิวเรเตอร์น้อยลง" ; -- src=panlex
lin chokecherry_N = mkN "โชคเชอร์รี่" ; -- src=panlex
lin chokehold_N = mkN "การกอดคอ" ; -- src=panlex
lin chokepoint_N = mkN "คอขวด" ; -- src=panlex
lin choker_N = mkN "รัฟ" | mkN "ปลอกคอ" | mkN "ฆาตกรบีบคอ" | mkN "ผ้าที่พันรอบลําคอ" | mkN "สร้อยคอที่สวมติดรอบลําคอ" ; -- src=panlex
lin chokey_N = mkN "มุ้งสายบัว" ; -- src=panlex
lin choking_N = mkN "การบีบคอ" | mkN "การสำลัก" ; -- src=panlex
lin choky_N = mkN "มุ้งสายบัว" ; -- src=panlex
lin cholangitis_N = mkN "ท่อน้ำดีอักเสบ" ; -- src=panlex
lin cholecystectomy_N = mkN "การตัดถุงน้ำดีออก" | mkN "ศัลยกรรมตัดเอาถุงน้ําดีออก" ; -- src=panlex
lin cholecystitis_N = mkN "ถุงน้ำดีอักเสบ" ; -- src=panlex
lin cholecystokinin_N = mkN "โคลีซีสโตคินิน" ; -- src=panlex
lin cholelithiasis_N = mkN "โรคนิ่วน้ำดี" ; -- src=panlex
lin choler_N = mkN "ความโกรธ" | mkN "อารมณ์โกรธ" | mkN "ความฉุนเฉียว" | mkN "ความรู้สึกโกรธ" | mkN "น้ำย่อยสีเหลือง" ; -- src=panlex
lin cholera_N = mkN "อหิวาตกโรค" | mkN "อหิวา่ตกโรค" | mkN "อหิวาต์" | mkN "อหิวาตกโรค" ; -- src=panlex
lin choleric_A = mkA "ขี้โมโห" | mkA "ซึ่งโมโหง่าย" | mkA "ที่อารมณ์เสียง่าย" ; -- src=panlex
lin cholesterol_N = mkN "คลอเลสเตอรอล" | mkN "คอเลสเตอรอล" | mkN "คอลเลสเตอรอล" ; -- src=panlex
lin choline_N = mkN "โคลีน" ; -- src=panlex
lin cholinesterase_N = mkN "เอนไซม์โคลินเอสเตอเรส" ; -- src=panlex
lin cholla_N = mkN "ต้นคอลลา" ; -- src=panlex
lin chomping_N = mkN "การเคี้ยวเสียงดัง" ; -- src=panlex
lin chon_N = mkN "ชอน" ; -- src=panlex
lin chondrin_N = mkN "คอนดริน" ; -- src=panlex
lin chondrite_N = mkN "อุกกาบาตหินเนื้อเม็ด" ; -- src=panlex
lin chondroma_N = mkN "คอนโดรมา" ; -- src=panlex
lin chondrosarcoma_N = mkN "ชอนโดรซาร์โคมา" ; -- src=panlex
lin chondrule_N = mkN "เม็ดกลม" ; -- src=panlex
lin choose_up_V = advV (lin V OP_choose_V2) OP_up_Adv ; -- guess-p-verb
lin choose_up_V2 = prepV2 (lin V OP_choose_V2) OP_up_Prep ; -- guess-p-verb
lin choosey_A = mkA "จู้จี้" | mkA "เอาใจยาก" | mkA "ช่างเลือก" ; -- src=panlex
lin choosy_A = mkA "จู้จี้" | mkA "เอาใจยาก" | mkA "ช่างเลือก" | mkA "ที่พอใจได้ยาก" | mkA "ช่างเลือกช่างติ" | mkA "ยากที่จะทําให้พอใจ" ; -- src=panlex
lin chop_N = mkN "ตี" | mkN "ลูกตัด" | mkN "ขากรรไกร" | mkN "การกระดอน" | mkN "ระลอกคลื่น" ; -- src=panlex
lin chop_V = mkV "ผ่า" | mkV "ฟัน" | mkV "สับ" | mkV "หวดเต็มแรง" | mkV "เคลื่อนไหวอย่างรวดเร็ว" | mkV "ฟัน" | mkV "สับ" | mkV "ตีอย่างแรง" | mkV "ตัดเป็นชิ้น" | mkV "หวดอย่างแรง" | mkV "หั่นเป็นชิ้นๆ" | mkV "เคลื่อนไหวอย่างรวดเร็ว" | mkV "เคลื่อนไหวโดยทันทีทันใด" ; -- src=panlex
lin chop_V2 = mkV2 "ผ่า" ; ---- | mkV "ฟัน" | mkV "สับ" | mkV "หวดเต็มแรง" | mkV "เคลื่อนไหวอย่างรวดเร็ว" | mkV "ฟัน" | mkV "สับ" | mkV "ตีอย่างแรง" | mkV "ตัดเป็นชิ้น" | mkV "หวดอย่างแรง" | mkV "หั่นเป็นชิ้นๆ" | mkV "เคลื่อนไหวอย่างรวดเร็ว" | mkV "เคลื่อนไหวโดยทันทีทันใด" ; -- src=panlex
lin chopine_N = mkN "รองเท้าโชพีน" ; -- src=panlex
lin chopper_N = mkN "ฮ." | mkN "ฟัน" | mkN "ปังตอ" | mkN "มีดอีโต้" | mkN "การกระดอน" | mkN "มีดสับเนื้อ" | mkN "เฮลิคอปเตอร์" | mkN "มีดชำแหละเนื้อ" | mkN "คนสับ" | mkN "ปังตอ" | mkN "ปืนกล" | mkN "สิ่งสับ" | mkN "มือปืนกล" | mkN "คนตรวจบัตร" | mkN "มีดเพชฌฆาต" | mkN "มีดสับเนื้อ" | mkN "เฮลิคอปเตอร์" | mkN "เครื่องตัดต่อ" | mkN "เครื่องตัดทางรถไฟ" ; -- src=panlex
lin choppy_A = mkA "ไม่แน่นอน" | mkA "ที่มีคลื่นมาก" | mkA "ซึ่งมักเปลี่ยนทิศทาง" | mkA "เป็นคลื่นที่แตกชัดสาด" ; -- src=panlex
lin chopstick_N = mkN "ตะเกียบ" | mkN "ฉลองพระหัตถ์ตะเกียบ" | mkN "ตะเกียบ" ; -- src=panlex
lin choragus_N = mkN "เคอเรกัส" | mkN "คนทํางานรื่นเริง" | mkN "ผู้นําคณะนักร้องประสานเสียง" ; -- src=panlex
lin choral_A = mkA "ที่ร้องหมู่" | mkA "ซึ่งประสานเสียงหมู่" ; -- src=panlex
lin chorale_N = mkN "เพลงสวดสรรเสริญพระเจ้าในโบสถ์" | mkN "กลุ่มนักร้องประสานเสียงในโบสถ์" ; -- src=panlex
lin chord_N = mkN "คอร์ด" | mkN "เส้นคอร์ด" | mkN "เส้น" | mkN "เอ็น" | mkN "สายซอ" | mkN "อารมณ์" | mkN "ความรู้สึก" | mkN "คอร์ดดนตรี" | mkN "สายเครื่องดนตรีดีดสี" | mkN "เสียงที่คล้ายเส้นเชือก" | mkN "จํานวนโน้ตดนตรีที่เล่นในเวลาเดียวกัน" | mkN "เส้นตรงที่เชื่อมจุดสองจุดบนเส้นรอบวงของวงกลม" | mkN "เส้นตรงระหว่างจุด1จุดบนเส้นรอบวง" ; -- src=panlex
lin chordate_N = mkN "คอร์เดต" ; -- src=panlex
lin chordophone_N = mkN "เครื่องดนตรีประเภทสาย" ; -- src=panlex
lin chore_N = mkN "งาน" | mkN "งานบ้าน" | mkN "งานหยุมหยิม" | mkN "งานที่น่าเบื่อ" | mkN "งานเล็กงานน้อย" ; -- src=panlex
lin chorea_N = mkN "โรคประสาทชักกระตุก" ; -- src=panlex
lin choreographer_N = mkN "นักออกแบบท่าเต้น" ; -- src=panlex
lin choreography_N = mkN "นาฏศิลป์" | mkN "การร่ายรำบนเวที" | mkN "การเต้นรำบนเวที" | mkN "เครื่องหมายทางนาฏศิลป์" | mkN "การเต้น" | mkN "การออกแบบท่าเต้น" ; -- src=panlex
lin chorioallantois_N = mkN "โคริโออัลแลนโทอิส" ; -- src=panlex
lin chorion_N = mkN "โคริออน" | mkN "เยื้อหุ้มทารก" ; -- src=panlex
lin chorister_N = mkN "นักร้องในกลุ่ม" | mkN "นักร้องผู้ชายในโบสถ์" | mkN "นักร้องในคณะนักร้องประสานเสียงในโบสถ์" ; -- src=panlex
lin chorizo_N = mkN "เคอรีโซ" | mkN "ไส้กรอกเคอรีโซ" ; -- src=panlex
lin chortle_N = mkN "การหัวเราะเบาๆ" | mkN "เสียงกลั้นหัวเราะ" | mkN "หัวเราะฮะฮะ" ; -- src=panlex
lin chortle_V = mkV "กลั้นหัวเราะ" | mkV "หัวเราะร่าเริง" ; -- src=panlex
lin chorus_N = mkN "คอรัส" | mkN "คณะคอรัส" | mkN "เสียงคอรัส" | mkN "เสียงประสาน" | mkN "เพลงประสานเสียง" | mkN "นักร้องประสานเสียง" | mkN "วงขับร้องประสานเสียง" | mkN "คณะนักร้องประสานเสียง" | mkN "กลุ่มนักร้องประสานเสียง" | mkN "เนื้อเพลงท่อนที่ร้องซ้ำ" | mkN "คณะระบําเพลง" | mkN "คณะขับร้องหมู่" | mkN "คณะนักร้องประสานเสียง" | mkN "บทเพลงท่อนที่ร้องซ้ํา" ; -- src=panlex
lin chosen_N = mkN "ตัวเลือก" | mkN "กลุ่มผู้แทน" ; -- src=panlex
lin chough_N = mkN "นกชอฟ" ; -- src=panlex
lin chow_N = mkN "อาหาร" | mkN "ของกิน" | mkN "เชาเชา" | mkN "สุนัขพันธุ์เชาเชา" | mkN "อาหาร" | mkN "สุนัขพันธุ์เชาเชา" ; -- src=panlex
lin chowchow_N = mkN "โชว์โชว์" | mkN "สุนัขพันธุ์เชาเชา" ; -- src=panlex
lin chowder_N = mkN "ซุปโชว์เดอร์" | mkN "ชุปข้นใส่หอย ปลาและผักชนิดต่าง ๆ" ; -- src=panlex
lin chrestomathy_N = mkN "รวมวรรณคดีที่เลือกสรรแล้ว" ; -- src=panlex
lin chrism_N = mkN "น้ํามันมนต์ที่ใช้ในโบสถ์" | mkN "การเจิมหรือชโลมด้วยน้ํามนต์" ; -- src=panlex
lin christ_N = mkN "คริสต์" | mkN "เมสสิยาห์" | mkN "เมสไซยาห์" ; -- src=panlex
lin christella_N = mkN "เฟิร์นคริสเตลลา" ; -- src=panlex
lin christendom_N = mkN "ชาวคริส" ; -- src=panlex
lin christening_N = mkN "พิธีชําระล้าง" ; -- src=panlex
lin christian_A = mkA "นับถือศาสนาคริสต์" | mkA "เกี่ยวกับคริสเตียน" | mkA "เกี่ยวกับศาสนาคริสต์" | mkA "เกี่ยวกับพระเยซูคริสต์" ; -- src=panlex
lin christianity_N = mkN "ศาสนาคริสต์" ; -- src=panlex
lin christmas_N = mkN "วันคริสต์มาส" | mkN "เทศกาลคริสต์มาส" ; -- src=panlex
lin christmastide_N = mkN "เทศกาลคริสต์มาส" | mkN "เทศกาลตรุษฝรั่ง" ; -- src=panlex
lin christmastime_N = mkN "เทศกาลคริสต์มาส" | mkN "เทศกาลตรุษฝรั่ง" ; -- src=panlex
lin chromate_N = mkN "โครเมต" ; -- src=panlex
lin chromatic_A = mkA "ที่มีสี" | mkA "เกี่ยวกับสีหรือสารสี" | mkA "เกี่ยวกับระดับเสียงผันแปร" ; -- src=panlex
lin chromatid_N = mkN "โครมาทิด" ; -- src=panlex
lin chromatin_N = mkN "โครมาติน" ; -- src=panlex
lin chromatogram_N = mkN "โครมาโทแกรม" ; -- src=panlex
lin chromatography_N = mkN "โครมาโทกราฟี" ; -- src=panlex
lin chrome_N = mkN "โครม" | mkN "โครเมียม" ; -- src=panlex
lin chromite_N = mkN "โครไมต์" | mkN "แร่โครไมต์" ; -- src=panlex
lin chromium_N = mkN "โครเมียม" | mkN "ธาตุโครเมียม" | mkN "เลขอะตอม 24" | mkN "โครเมียม" | mkN "ธาตุโลหะโครเมียม" | mkN "วัตถุเป็นมันวาวชนิดหนึ่ง" ; -- src=panlex
lin chromogen_N = mkN "โครโมเจน" ; -- src=panlex
lin chromophore_N = mkN "ส่วนกำเนิดสี" ; -- src=panlex
lin chromoplast_N = mkN "โครโมพลาสต์" ; -- src=panlex
lin chromosome_N = mkN "โครโมโซม" | mkN "โครโมโซม" ; -- src=panlex
lin chromosphere_N = mkN "โครโมสเฟียร์" ; -- src=panlex
lin chronic_A = mkA "เรื้อรัง" | mkA "ซึ่งติดเป็นนิสัย" | mkA "ติด" | mkA "เรื้อรัง" | mkA "เป็นประจํา" | mkA "ทําเป็นประจํา" | mkA "ที่ติดเป็นนิสัย" | mkA "ติดต่อกันเป็นเวลานาน" ; -- src=panlex
lin chronicle_N = mkN "ประวัติศาสตร์" | mkN "เรื่องราวในอดีต" | mkN "เหตุการณ์ในอดีต" ; -- src=panlex
lin chronograph_N = mkN "เครื่องบันทึกเวลา" | mkN "นาฬิกาที่เที่ยงตรงมาก" ; -- src=panlex
lin chronological_A = mkA "ตามลําดับเวลา" | mkA "ตามลําดับเหตุการณ์" | mkA "ตามลําดับเวลาวันเดือนปี" ; -- src=panlex
lin chronology_N = mkN "พงศาวดาร" | mkN "ลำดับเวลาวิทยา" | mkN "วิชาลําดับวันเดือนปี" ; -- src=panlex
lin chronometer_N = mkN "นาฬิกาที่เที่ยงตรงมาก" ; -- src=panlex
lin chronoscope_N = mkN "โครโนสโคป" ; -- src=panlex
lin chrysalis_N = mkN "ดักแด้" | mkN "ด้วง" | mkN "ดักแด้" | mkN "ตัวแก้ว" | mkN "ตัวดักแด้" ; -- src=panlex
lin chrysanthemum_N = mkN "ดอกเบญจมาศ" | mkN "ดอกเก๊กฮวย" | mkN "ต้นเบญจมาศ" ; -- src=panlex
lin chrysoberyl_N = mkN "ครีโซเบรีล" | mkN "แร่ครีโซเบรีล" ; -- src=panlex
lin chrysolite_N = mkN "คริโซไลต์" ; -- src=panlex
lin chrysoprase_N = mkN "คริโซเพรส" ; -- src=panlex
lin chrysotile_N = mkN "ไครโซไตล์" ; -- src=panlex
lin chub_N = mkN "ปลาชับ" | mkN "ปลาน้ําจืดจําพวกหนึ่ง" ; -- src=panlex
lin chubbiness_N = mkN "ความอ้วนเตี้ย" ; -- src=panlex
lin chubby_A = mkA "จ้ำม่ำ" | mkA "กลม" | mkA "อ้วนกลม" ; -- src=panlex
lin chuck_N = mkN "อาหาร" | mkN "ของกิน" | mkN "ช่วงอก" | mkN "การตบที่คางเบาๆ" ; -- src=panlex
lin chuckle_N = mkN "การหัวเราะเบาๆ" | mkN "เสียงกลั้นหัวเราะ" | mkN "การหัวเราะเบาๆ" ; -- src=panlex
lin chuckle_V = mkV "กลั้นหัวเราะ" | mkV "หัวเราะเบาๆ" ; -- src=panlex
lin chuckle_VS = mmkVS "กลั้นหัวเราะ" ; ---- | mkV "หัวเราะเบาๆ" ; -- src=panlex
lin chuckwalla_N = mkN "ชัควอลลา" ; -- src=panlex
lin chufa_N = mkN "ต้นเยลโลว์นัตแกรส" ; -- src=panlex
lin chug_N = mkN "เสียงชั้กๆ" | mkN "เสียงระเบิดเบา ๆ และดื้อ ๆ" | mkN "เสียงเครื่องจักรดังซัก ๆ" ; -- src=panlex
lin chukka_N = mkN "ชักเกอร์" | mkN "รองเท้าทรงชักก้า" ; -- src=panlex
lin chukker_N = mkN "ชักเกอร์" ; -- src=panlex
lin chum_N = mkN "คู่หู" | mkN "บั๊ดดี้" | mkN "เพื่อนคู่หู" | mkN "เหยื่อตกปลา" | mkN "ปลาชัมแซลมอน" | mkN "เพื่อนสนิท" | mkN "เพื่อนร่วมห้อง" ; -- src=panlex
lin chum_V = mkV "ที่ไปด้วยกัน" ; -- src=panlex
lin chumminess_N = mkN "ความเป็นมิตร" | mkN "ความเป็นเพื่อน" ; -- src=panlex
lin chummy_A = mkA "สนิทสนม" | mkA "ที่สนิทสนมกัน" | mkA "เป็นเพื่อนกัน" | mkA "ที่คุ้นเคยกันดี" | mkA "มีมิตรไมตรีจิตเป็นมิตร" ; -- src=panlex
lin chump_N = mkN "คนซื่อ" | mkN "คนหลอกง่าย" | mkN "คนเชื่อคนง่าย" | mkN "คนโง่" | mkN "ก้อนเนื้อหนา" | mkN "ไม้ท่อนใหญ่ๆ" | mkN "ท่อนไม้สั้นและหนา" ; -- src=panlex
lin chunga_N = mkN "นกซีเรียมา" ; -- src=panlex
lin chunk_N = mkN "ก้อน" | mkN "ก้อนดิน" | mkN "ทั้งมวล" | mkN "กลุ่มก้อน" | mkN "ก้อนหนา" | mkN "ชายอ้วนเตี้ย" | mkN "ม้าที่แข็งแรง" | mkN "สัตว์ที่แข็งแรง" | mkN "ชายมะขามข้อเดียว" | mkN "ชายที่แข็งแรงล่ําสัน" | mkN "เนื้อหรือไม้ชิ้นหนาและสั้น" ; -- src=panlex
lin chunky_A = mkA "เตี้ยม่อต้อ" | mkA "อ้วนเตี้ย" | mkA "หนาและสั้น" | mkA "มะขามข้อเดียว" | mkA "แข็งแรงล่ําสัน" ; -- src=panlex
lin chunnel_N = mkN "อุโมงค์ลอดช่องแคบอังกฤษ" ; -- src=panlex
lin church_N = placeN "โบสถ์" ;
lin churchgoer_N = mkN "สมาชิกโบสถ์" | mkN "ผู้เข้าโบสถ์" | mkN "ผู้ที่ใช้โบสถ์เป็นประจํา" ; -- src=panlex
lin churchly_A = mkA "ทางธรรม" | mkA "เกี่ยวกับโบสถ์" | mkA "ที่เป็นของโบสถ์" | mkA "ที่เหมาะกับโบสถ์" | mkA "มีความศรัทธาในศาสนามาก" ; -- src=panlex
lin churchman_N = mkN "พระสอนศาสนา" | mkN "พระ" | mkN "บาทหลวง" | mkN "พระที่โบสถ์" | mkN "สมาชิกโบสถ์" | mkN "สมาชิกศาสนาประจําชาติ" | mkN "สมาชิกของโบสถ์ที่เป็นผู้ชาย" ; -- src=panlex
lin churchyard_N = mkN "บริเวณโบถส์" ; -- src=panlex
lin churl_N = mkN "คนเถื่อน" | mkN "คนชั้นต่ำ" | mkN "คนงุ่มง่าม" | mkN "คนอารมณ์ร้าย" | mkN "คนขี้หงุดหงิด" | mkN "คนไร้การศึกษา" | mkN "ชาวชนบท" | mkN "คนหยาบคาย" | mkN "คนขี้เหนียว" | mkN "คนที่หยาบคาย" | mkN "คนอารมณ์ร้าย" | mkN "ปู่โสมเฝ้าทรัพย์" | mkN "เสรีชนชั้นต่ําในสมัยศักดินา" ; -- src=panlex
lin churlish_A = mkA "หยาบคาย" | mkA "เอาใจยาก" | mkA "ขี้เหนียว" | mkA "จัดการยาก" | mkA "อารมณ์ร้าย" | mkA "คล้ายคนบ้านนอก" | mkA "ติดต่อด้วยได้ยาก" ; -- src=panlex
lin churn_N = mkN "เครื่องปั่นครีม" | mkN "เครื่องปั่น" ; -- src=panlex
lin churn_V = mkV "ปั่นครีม" ; -- src=panlex
lin churn_V2 = mkV2 "ปั่นครีม" ; ---- ; -- src=panlex
lin chute_N = mkN "ทางลาด" | mkN "ร่มชูชีพ" | mkN "น้ําตก" ; -- src=panlex
lin chutney_N = mkN "ชัตนีย์" ; -- src=panlex
lin chutzpa_N = mkN "ความทะลึ่ง" ; -- src=panlex
lin chyle_N = mkN "น้ำเหลืองไขมันปน" ; -- src=panlex
lin chylomicron_N = mkN "ไคโลไมครอน" ; -- src=panlex
lin chyme_N = mkN "ไคม์" ; -- src=panlex
lin cicada_N = mkN "จักจั่น" | mkN "จั๊กจั่น" ; -- src=panlex
lin cicala_N = mkN "จักจั่น" ; -- src=panlex
lin cicatrice_N = mkN "รอยแผล" | mkN "แผลเป็น" ; -- src=panlex
lin cicatrix_N = mkN "รอยแผล" | mkN "แผลเป็น" ; -- src=panlex
lin cicero_N = mkN "ซิเซโร" ; -- src=panlex
lin cicerone_N = mkN "คนนําเที่ยวที่อธิบายถึงประวัติของสถานที่" ; -- src=panlex
lin cichlid_N = mkN "ปลาหมอสี" ; -- src=panlex
lin cider_N = mkN "ไซเดอร์" | mkN "น้ําแอปเปิล" | mkN "เหล้าแอปเปิล" | mkN "น้ําผลไม้ใช้เป็นเครื่องดื่ม" ; -- src=panlex
lin ciderpress_N = mkN "เครื่องคั้นแอปเปิ้ล" ; -- src=panlex
lin cigar_N = mkN "ซิการ์" | mkN "ซิการ์" | mkN "บุหรี่ซิการ์" ; -- src=panlex
lin cigarette_N = mkN "ยาสูบ" | mkN "บุหรี่" | mkN "ซิกาแรต" | mkN "ยาซิกาแรต" | mkN "ยาสูบ" | mkN "บุหรี่" | mkN "ยากาแร็ต" ; -- src=panlex
lin cigarillo_N = mkN "ซิการ์ริลโล" | mkN "บุหรี่มวนเล็ก" ; -- src=panlex
lin ciliate_N = mkN "ซิลิเอต" | mkN "ซิลิเอตโปรโตซัว" | mkN "มีขน" ; -- src=panlex
lin cilium_N = mkN "ขนตา" | mkN "ซิเลียม" | mkN "ขนพระเนตร" | mkN "พระโลมจักษุ" | mkN "พระโลมะจักษุ" ; -- src=panlex
lin cimetidine_N = mkN "ซิมีไทดีน" ; -- src=panlex
lin cinch_N = mkN "งานเบา" | mkN "สายรัด" | mkN "งานง่ายๆ" | mkN "ของกล้วยๆ" | mkN "สายรัดอานม้า" | mkN "เรื่องกล้วยๆ" | mkN "สายคาด" | mkN "สายคาดท้อง" | mkN "สายคาดอานม้า" | mkN "ผู้ที่จะชนะแน่นอน" | mkN "สิ่งที่แน่นอนและง่าย" | mkN "สายรัดถุงหรือกระสอบบนหลังสัตว์" ; -- src=panlex
lin cinchona_N = mkN "ต้นควินิน" | mkN "ต้นซิงโคนา" | mkN "เปลือกซินโคนา" | mkN "เปลือกต้นซิงโคนา" | mkN "ต้นชิงโคนาที่เปลือกของมันมีควินิน" ; -- src=panlex
lin cinchonine_N = mkN "ซินโคนีน" ; -- src=panlex
lin cincture_N = mkN "การโอบ" | mkN "สายรัด" | mkN "สายรัดเอว" | mkN "สายเข็มขัด" | mkN "การทําให้ล้อมรอบ" | mkN "การทําให้เป็นวงรอบ" ; -- src=panlex
lin cinder_N = mkN "กาก" | mkN "คลิงเกอร์" | mkN "ถ่าน" | mkN "กากแร่" | mkN "ถ่านไฟ" | mkN "ขี้เถ้า" | mkN "เถ้าถ่าน" | mkN "กากถ่านหิน" ; -- src=panlex
lin cinderella_N = mkN "ลูกเมียน้อย" ; -- src=panlex
lin cinema_N = placeN (thword "โรง" "หนัง") ;
lin cinematographer_N = mkN "ตากล้อง" | mkN "ช่างกล้องภาพยนตร์" ; -- src=panlex
lin cinematography_N = mkN "การถ่ายทำหนัง" | mkN "การทำภาพยนตร์" | mkN "การสร้างภาพยนตร์" | mkN "การถ่ายทำภาพยนตร์" ; -- src=panlex
lin cineraria_N = mkN "ต้นซิเนอราเรีย" ; -- src=panlex
lin cingulum_N = mkN "ปุ่มคอฟัน" ; -- src=panlex
lin cinnabar_N = mkN "โลหะปรอท" | mkN "ซินนาบาร์" | mkN "แร่ซินนาบาร์" ; -- src=panlex
lin cinnamon_N = mkN "อบเชย" | mkN "ต้นอบเชย" | mkN "อบเชย" | mkN "สีอบเชย" | mkN "ซินนามอน" | mkN "เปลือกต้นอบเชย" | mkN "สีน้ําตาลเหลือง" | mkN "สีเหลืองน้ําตาลหรือแดงน้ําตาล" ; -- src=panlex
lin cipher_N = mkN "๐" | mkN "ศูนย์" | mkN "รหัสลับ" | mkN "ไข่เป็ด" | mkN "เลขศูนย์" | mkN "คนไม่สำคัญ" | mkN "เล็กๆน้อยๆ" | mkN "คนไม่สำคัุญ" | mkN "คนไม่มีเสน่ห์" | mkN "ความว่างเปล่า" | mkN "ข้อความรหัสลับ" | mkN "0" | mkN "ศูนย์" | mkN "ค่าเป็นศูนย์" | mkN "สิ่งที่ไม่มีค่า" | mkN "สิ่งที่ไม่สําคัญ" ; -- src=panlex
lin cipher_V = mkV "คำนวณ" | mkV "คิดเลข" | mkV "คิดคำนวณ" | mkV "เขียนรหัส" | mkV "เขียนเป็นรหัส" | mkV "เขียนเป็นโค้ด" ; -- src=panlex
lin cipher_V2 = mkV2 "คำนวณ" ; ---- | mkV "คิดเลข" | mkV "คิดคำนวณ" | mkV "เขียนรหัส" | mkV "เขียนเป็นรหัส" | mkV "เขียนเป็นโค้ด" ; -- src=panlex
lin ciprofloxacin_N = mkN "ซิโพรฟลอกซาซิน" ; -- src=panlex
lin circa_Prep = mkPrep "ในราว" | mkPrep "ประมาณ" ; -- src=panlex
lin circle_N = mkN "วง" | mkN "โรช" | mkN "วงกลม" | mkN "กลุ่มคน" | mkN "การหมุน" | mkN "วงเวียน" | mkN "รูปวงกลม" | mkN "การหมุนรอบ" | mkN "ถนนรอบเกาะ" | mkN "ที่นั่งชั้นลอย" | mkN "เม็กซิกันแวเลี่ยม" | mkN "อาร์-2" | mkN "กง" | mkN "วง" | mkN "วงกลม" | mkN "วงการ" | mkN "ขอบเขต" | mkN "บริเวณ" | mkN "วงแหวน" | mkN "ปริมณฑล" | mkN "วงเวียน" | mkN "วัฎจักร" | mkN "โคจรรอบ" | mkN "อาณาจักร" | mkN "เส้นวงกลม" | mkN "โรงละครสัตว์" | mkN "การหมุนเวียนครบรอบ" | mkN "ที่นั่งเป็นรูปวงกลม" | mkN "เส้นรอบวงที่แบ่งโลกออกเป็น2ส่วน" ; -- src=panlex
lin circle_V = mkV "วง" | mkV "วงกลม" | mkV "เดินทางรอบ" | mkV "เคลื่อนเป็นวงกลม" ; -- src=panlex
lin circle_V2 = mkV2 "วง" ; ---- | mkV "วงกลม" | mkV "เดินทางรอบ" | mkV "เคลื่อนเป็นวงกลม" ; -- src=panlex
lin circlet_N = mkN "วงกลมเล็ก" | mkN "วงกลเล็ก ๆ" | mkN "วงกลมวงเล็กๆ" ; -- src=panlex
lin circuit_N = mkN "วงจร" | mkN "ทัวร์" | mkN "วงจรไฟฟ้า" | mkN "การหมุนรอบ" | mkN "สนามแข่งรถ" | mkN "เขตอำนาจศาล" | mkN "สนามความเร็ว" | mkN "การท่องเที่ยว" | mkN "กำหนดการจัดงาน" | mkN "เรซซิ่งเซอร์กิต" | mkN "เขตอำนาจศาลในสหรัฐอเมริกา" | mkN "ขอบเขต" | mkN "การโคจรรอบ" | mkN "พื้นที่ที่จํากัดเขตไว้" ; -- src=panlex
lin circuitous_A = mkA "วกวน" | mkA "อ้อม" | mkA "วกเวียน" | mkA "โดยอ้อม" | mkA "อ้อมค้อม" ; -- src=panlex
lin circuitry_N = mkN "ระบบการหมุนเวียนกระแสไฟฟ้า" | mkN "วงจรไฟฟ้า" | mkN "วงจรในอุปกรณ์อิเล็กตรอน" ; -- src=panlex
lin circular_A = mkA "กลม" | mkA "กลม" | mkA "ไม่ตรง" | mkA "วกเวียน" | mkA "อ้อมค้อม" | mkA "ที่เป็นวงกลม" | mkA "ที่เกี่ยวกับวงกลม" | mkA "แจ้งให้ทราบทั่วไป" | mkA "ให้แพร่หลายไปทั่ว" | mkA "ซึ่งเคลื่อนเป็นวงกลม" | mkA "ที่เคลื่อนที่เป็นวงกลม" | mkA "เป็นรูปวงกลมหรือวงแหวน" ; -- src=panlex
lin circular_N = mkN "ใบปลิว" | mkN "การโฆษณา" | mkN "แฮนด์บิล" ; -- src=panlex
lin circulate_V = mkV "กระจาย" | mkV "วนเวียน" | mkV "แพร่หลาย" | mkV "ไหลเวียน" | mkV "ปล่อยข่าว" | mkV "ทำให้แพร่หลาย" | mkV "เคลื่อนเป็นวงกลม" | mkV "โคจรเป็นวงกลม" | mkV "เคลื่อนไหวอย่างอิสระ" | mkV "ทําให้เคลื่อนไหวอย่างอิสระ" | mkV "เคลื่อนที่จากที่หนึ่งไปอีกที่หนึ่งโดยอิสระ" ; -- src=panlex
lin circulate_V2 = mkV2 "กระจาย" ; ---- | mkV "วนเวียน" | mkV "แพร่หลาย" | mkV "ไหลเวียน" | mkV "ปล่อยข่าว" | mkV "ทำให้แพร่หลาย" | mkV "เคลื่อนเป็นวงกลม" | mkV "โคจรเป็นวงกลม" | mkV "เคลื่อนไหวอย่างอิสระ" | mkV "ทําให้เคลื่อนไหวอย่างอิสระ" | mkV "เคลื่อนที่จากที่หนึ่งไปอีกที่หนึ่งโดยอิสระ" ; -- src=panlex
lin circulation_N = mkN "การไหล" | mkN "การแพร่" | mkN "ยอดจำหน่าย" | mkN "การหมุนเวียน" | mkN "การวางแผงหนังสือ" | mkN "จำนวนหนังสือที่ยืม" | mkN "ธนบัตร" | mkN "การโคจร" | mkN "เงินตรา" | mkN "จํานวนขาย" | mkN "การจําหน่าย" | mkN "จํานวนพิมพ์" | mkN "การหมุนเวียน" | mkN "การแพร่กระจาย" | mkN "การไหลเวียนครบรอบ" | mkN "การเคลื่อนไหวโดยอิสระ" | mkN "การเคลื่อนที่ครบรอบวงโคจร" ; -- src=panlex
lin circumcision_N = mkN "การเข้าสุหนัด" | mkN "การขลิบหนังหุ้มปลายอวัยวะเพศชาย" | mkN "ชาวยิว" | mkN "การขลิบหนังหุ้มลึงค์ออก" | mkN "การชําระล้างจิตวิญญาณให้สะอาด" ; -- src=panlex
lin circumduction_N = mkN "การกลอกตา" | mkN "การหมุนเป็นวงกลม" ; -- src=panlex
lin circumference_N = mkN "เส้นรอบวง" | mkN "ความยาวของเส้นรอบวง" ; -- src=panlex
lin circumferential_A = mkA "รอบนอก" | mkA "วกเวียน" | mkA "อ้อมค้อม" | mkA "ซึ่งล้อมรอบ" | mkA "เกี่ยวกับเส้นรอบวง" ; -- src=panlex
lin circumflex_N = mkN "เครื่องหมายที่อยู่บนสระเพื่อแสดงการออกเสียงในบางภาษา" ; -- src=panlex
lin circumlocution_N = mkN "วิธีอ้อม" | mkN "การกล่าวอ้อม" | mkN "การพูดซ้ําซาก" | mkN "การไม่พูดตรงๆ" | mkN "การพูดอ้อมค้อม" | mkN "การอ้อมไปอ้อมมา" ; -- src=panlex
lin circumnavigation_N = mkN "การเดินทางรอบสถานที่" ; -- src=panlex
lin circumscription_N = mkN "ขอบเขต" | mkN "ลายริม" | mkN "คํานิยาม" | mkN "โครงร่าง" | mkN "เส้นรอบวง" | mkN "การจํากัดเขต" | mkN "คําจํากัดความ" | mkN "การเขียนวงกลมรอบ" ; -- src=panlex
lin circumspect_A = mkA "รอบคอบ" | mkA "ระมัดระวัง" | mkA "ที่คิดอย่างรอบคอบ" ; -- src=panlex
lin circumspection_N = mkN "ความรอบคอบ" | mkN "ความระมัดระวัง" ; -- src=panlex
lin circumstance_N = mkN "ปัจจัย" | mkN "พิธีการ" | mkN "เงื่อนไข" | mkN "สภาวะแวดล้อม" | mkN "ข้อมูลแวดล้อม" | mkN "สถานการณ์แวดล้อม" | mkN "เหตุการณ์แวดล้อม" | mkN "โชค" | mkN "โอกาส" | mkN "เหตุการณ์" | mkN "สภาวะแวดล้อม" ; -- src=panlex
lin circumstances_N = mkN "ชะตากรรม" | mkN "สถานะทางการเงิน" ; -- src=panlex
lin circumstantial_A = mkA "บังเอิญ" | mkA "ละเอียด" | mkA "เป็นรอง" | mkA "โดยเฉพาะ" | mkA "ไม่สําคัญ" | mkA "ตามสถานการณ์" | mkA "ทุกแง่ทุกมุม" | mkA "ตามสภาพแวดล้อม" | mkA "ที่มีรายละเอียด" | mkA "ที่ขึ้นอยู่กับสถานการณ์" | mkA "ที่ไม่ได้สําคัญเป็นอันดับแรก" ; -- src=panlex
lin circus_N = mkN "โรงมหรสพ" | mkN "ละครสัตว์" | mkN "คณะละครสัตว์" | mkN "การเล่นสนุกสนาน" | mkN "การแสดงละครสัตว์" | mkN "วงแหวน" | mkN "ละครสัตว์" | mkN "คณะละครสัตว์" | mkN "โรงละครสัตว์" | mkN "สนามกีฬารูปวงกลม" | mkN "ลานวงเวียนที่ทางแยก" ; -- src=panlex
lin cirque_N = mkN "ไหล่เขาชัน" ; -- src=panlex
lin cirrhosis_N = mkN "โรคตับแข็ง" | mkN "โรคตับแข็ง" ; -- src=panlex
lin cirrocumulus_N = mkN "เมฆซีร์โรคิวมูลัส" ; -- src=panlex
lin cirrostratus_N = mkN "เมฆซีร์โรสเตรตัส" | mkN "000 ฟุต" | mkN "000-40" ; -- src=panlex
lin cirrus_N = mkN "เมฆซีรัส" | mkN "ขน" | mkN "หนวดสัมผัส" ; -- src=panlex
lin cisco_N = mkN "ปลาซิสโก้" | mkN "เนื้อปลาซิสโก้" | mkN "ปลาเลคเฮอร์ริ่ง" | mkN "ปลาเฮอร์ริ่งทะเลสาบ" | mkN "เนื้อปลาเลคเฮอร์ริ่ง" | mkN "เนื้อปลาเฮอร์ริ่งทะเลสาบ" ; -- src=panlex
lin cistern_N = mkN "ถังใต้ดิน" | mkN "ถังน้ำใต้ดิน" | mkN "ถังน้ำชักโครก" | mkN "ถังน้ํา" | mkN "ที่เก็บน้ํา" ; -- src=panlex
lin citadel_N = mkN "ป้อมปราการ" | mkN "ป้อม" | mkN "ที่หลบภัย" | mkN "ป้อมปราการ" | mkN "ที่มั่นสุดท้าย" ; -- src=panlex
lin citation_N = mkN "เชิงอรรถ" | mkN "การยกย่อง" | mkN "การอ้างอิง" | mkN "ข้อความอ้างอิง" | mkN "หมายศาล" | mkN "คําสดุดี" | mkN "หมายเรียก" | mkN "การอ้างอิง" | mkN "จดหมายชมเชย" | mkN "การกล่าวอ้าง" | mkN "รางวัลหรือคําชมเชย" | mkN "ประโยคหรือสิ่งที่อ้างถึง" ; -- src=panlex
lin citified_A = mkA "ที่มีลักษณะเป็นคนเมือง" ; -- src=panlex
lin citizenFem_N = variants {} ; ---- sense to be split
lin citizenMasc_N = variants {} ; ---- sense to be split
lin citizenry_N = mkN "ปชช." | mkN "ประชาชน" | mkN "พลเมือง" | mkN "กลุ่มพลเมือง" | mkN "กลุ่มพลเมือง" | mkN "ประชากรทั้งหลาย" | mkN "พลเรือนทั้งหลาย" ; -- src=panlex
lin citizenship_N = mkN "ความเป็นพลเมือง" | mkN "สิทธิของพลเมือง" | mkN "สัญชาติ" | mkN "ฐานะประชากร" | mkN "ความเป็นพลเมือง" | mkN "คุณธรรมของประชากร" | mkN "สิทธิในความเป็นพลเมือง" ; -- src=panlex
lin citrange_N = mkN "ต้นซิเตรนจ์" | mkN "ส้มซิเทรนจ์" ; -- src=panlex
lin citrate_N = mkN "ซิเตรต" | mkN "เกลือซิเตรต" ; -- src=panlex
lin citrine_N = mkN "ซิทริน" ; -- src=panlex
lin citron_N = mkN "ซิตรอน" | mkN "ต้นมะงั่ว" | mkN "ส้มซิตรอน" | mkN "ผลไม้ คล้ายมะนาว แต่มีขนาดใหญ่กว่า" | mkN "มะงั่ว" ; -- src=panlex
lin citronwood_N = mkN "ไม้แซนดาแร็ก" | mkN "ไม้ซิตรอนวู้ด" ; -- src=panlex
lin citrulline_N = mkN "ซิตรูลลีน" | mkN "กรดอะมิโนซิตรูลลีน" ; -- src=panlex
lin citrus_N = mkN "ต้นไซตรัส" | mkN "ผลไม้จำพวกส้ม" | mkN "ต้นไม้จําพวกมะนาว ส้ม และอื่น ๆ -" ; -- src=panlex
lin cittern_N = mkN "ซิตเทิร์น" | mkN "กล่องเสียงเป็นรูปแพร" | mkN "กีตาร์แบบเก่าชนิดหนึ่ง" ; -- src=panlex
lin city_N = mkN "เมือง" "เมือง" | {-pan-} mkN "เมือง" | mkN "มหานคร" | mkN "เมือง" | mkN "นครรัฐ" | mkN "กรุงนคร" | mkN "หัวเมือง" | mkN "เมืองใหญ่" | mkN "พลเมืองทั้งหมด" ; -- src=panlex
lin cityscape_N = mkN "ภาพวาดเมือง" | mkN "ทิวทัศน์ของเมือง" | mkN "ภาพทิวทัศน์ของเมือง" ; -- src=panlex
lin citywide_A = mkA "ทั่วเมือง" ; -- src=panlex
lin civet_N = mkN "ชะมด" | mkN "ชะมด" ; -- src=panlex
lin civic_A = mkA "เมือง" | mkA "เทศบาล" | mkA "พลเรือน" | mkA "สัญชาติ" | mkA "ที่เกี่ยวกับเมือง" ; -- src=panlex
lin civics_N = mkN "วิชาหน้าที่พลเมือง" | mkN "วิชาหน้าที่พลเมือง" | mkN "วิชาที่ศึกษาเกี่ยวกับสิทธิหน้าที่ของพลเมือง" ; -- src=panlex
lin civies_N = mkN "ซิวีส" | mkN "ชุดซิวีส" ; -- src=panlex
lin civil_A = mkA "ที่มีวัฒนธรรม" | mkA "เกี่ยวกับพลเรือน" | mkA "ที่เกี่ยวกับพลเมือง" ; -- src=panlex
lin civilian_A = mkA "พลเรือน" ; -- src=panlex
lin civilian_N = mkN "พลเรือน" | mkN "พลเรือน" | mkN "นักศึกษากฎหมายแพ่ง" ; -- src=panlex
lin civilisation_N = mkN "สังคม" | mkN "อารยะ" | mkN "อารยธรรม" | mkN "สังคมอารยะ" | mkN "ความศิวิไลซ์" | mkN "การขัดเกลาเพื่ออารยะ" | mkN "อารยธรรม" | mkN "ความศิวิไลซ์" | mkN "การมีวัฒนธรรมประเพณี" ; -- src=panlex
lin civility_N = mkN "ความสุภาพ" | mkN "ความมีมารยาท" | mkN "การแสดงความสุภาพ" | mkN "มารยาท" | mkN "อัธยาศัย" | mkN "อารยธรรม" | mkN "ความสุภาพ" | mkN "ความเอื้อเฟื้อ" | mkN "วัฒนธรรมประเพณี" ; -- src=panlex
lin civilization_N = mkN "สังคม" | mkN "อารยะ" | mkN "อารยธรรม" | mkN "สังคมอารยะ" | mkN "ความศิวิไลซ์" | mkN "การขัดเกลาเพื่ออารยะ" | mkN "อารยธรรม" | mkN "ความศิวิไลซ์" | mkN "การมีวัฒนธรรมประเพณี" ; -- src=panlex
lin clabber_N = mkN "นมเปรี้ยวที่แข็งตัว" ; -- src=panlex
lin clack_N = mkN "เสียงกระทบ" ; -- src=panlex
lin clack_V = mkV "คุยจ้อ" | mkV "ร้องกุ๊กๆ" | mkV "พูดไร้สาระ" | mkV "พูดเพ้อเจ้อ" | mkV "พูดเืพ้อเจ้อ" | mkV "ทำเสียงอึกทึก" | mkV "พูดเรื่อยเปื่อย" | mkV "ทำให้เกิดเสียงอึกทึก" | mkV "พูดเร็ว" | mkV "เกิดเสียงแหลม" | mkV "ทําให้เกิดเสียงแหลมขึ้นทันที" ; -- src=panlex
lin clad_V = mkV "หุ้ม" | mkV "ปกคลุม" | mkV "หุ้มโลหะด้วยโลหะ" ; -- src=panlex
lin clad_V2 = mkV2 "หุ้ม" ; ---- | mkV "ปกคลุม" | mkV "หุ้มโลหะด้วยโลหะ" ; -- src=panlex
lin clade_N = mkN "กลุ่ม" ; -- src=panlex
lin cladistics_N = mkN "แคลดิสติกส์" ; -- src=panlex
lin claim_N = mkN "สิทธิ์" | mkN "การเรียกร้อง" | mkN "การแสดงสิทธิ์" | mkN "การเรียกร้องสิทธิ์" | mkN "การยืนยันข้อเท็จจริง" | mkN "การเรียกร้อง" ; -- src=panlex
lin claim_V = mkV "ได้รับ" | mkV "ถือสิทธิ์" | mkV "เีรียกร้อง" | mkV "นำความสูญเสีย" | mkV "อ้าง" | mkV "กล่าวอ้าง" | mkV "เรียกร้อง" ; -- src=panlex
lin claim_V2 = mkV2 "ได้รับ" ; ---- | mkV "ถือสิทธิ์" | mkV "เีรียกร้อง" | mkV "นำความสูญเสีย" | mkV "อ้าง" | mkV "กล่าวอ้าง" | mkV "เรียกร้อง" ; -- src=panlex
lin claim_VS = mmkVS "ได้รับ" ; ---- | mkV "ถือสิทธิ์" | mkV "เีรียกร้อง" | mkV "นำความสูญเสีย" | mkV "อ้าง" | mkV "กล่าวอ้าง" | mkV "เรียกร้อง" ; -- src=panlex
lin claimant_N = mkN "ผู้เรียกร้องสิทธิ" | mkN "ผู้อ้างสิทธิ" | mkN "ผู้เรียกร้อง" | mkN "ผู้ที่เรียกร้องสิทธิ" ; -- src=panlex
lin clairvoyance_N = mkN "อีเอสพี" | mkN "ประสาทที่หก" | mkN "ไหวพริบ" | mkN "การมีตาทิพย์" | mkN "การรู้ที่เหนือมนุษย์" ; -- src=panlex
lin clairvoyant_A = mkA "หมอดู" | mkA "ผู้วิเศษ" | mkA "มีตาทิพย์" | mkA "มีญาณทิพย์" ; -- src=panlex
lin clairvoyant_N = mkN "ผู้มีตาทิพย์" ; -- src=panlex
lin clam_N = mkN "หอย" | mkN "ดอลลาร์" | mkN "หอยแคลม" | mkN "หนึ่งดอลล่าร์" | mkN "แบงค์หนึ่งดอลลาร์" | mkN "ธนบัตรหนึ่งดอลลาร์" | mkN "หอยกาบ" | mkN "คนเงียบ" | mkN "คนไม่ค่อยพูด" | mkN "หอยชนิดหนึ่งกินได้" ; -- src=panlex
lin clamant_A = mkA "อึกทึก" | mkA "ฉุกเฉิน" | mkA "รีบด่วน" | mkA "เสียงดัง" | mkA "ที่มีเสียงดังหนวกหู" ; -- src=panlex
lin clambake_N = mkN "อาหารชายทะเล" ; -- src=panlex
lin clamber_N = mkN "การปีนอย่างลำบาก" ; -- src=panlex
lin clamber_V = mkV "ปีน" | mkV "ปีนขึ้นอย่างทุลักทุเล" | mkV "ปีนด้วยความลําบาก" ; -- src=panlex
lin clammy_A = mkA "ชื้น" | mkA "หมาด" | mkA "เย็นชื้น" | mkA "เหนียวเหนอะ" | mkA "เย็นชืดเหมือนคนตาย" ; -- src=panlex
lin clammyweed_N = mkN "ต้นแคลมมีวีด" ; -- src=panlex
lin clamor_N = mkN "การโห่ร้อง" | mkN "การแผดเสียง" | mkN "เสียงร้องดังๆ" | mkN "เสียงแตรในพิธี" | mkN "ผลักดัน" | mkN "ใช้เสียงดัง" | mkN "ร้องเสียงดัง" | mkN "เสียงอึกทึกครึกโครม" | mkN "การร้องออกมาอย่างดัง" | mkN "การแสดงความคิดเห็นของสาธารณะชน" ; -- src=panlex
lin clamorous_A = mkA "รุนแรง" | mkA "อึกทึก" | mkA "อลหม่าน" | mkA "เสียงดัง" | mkA "ที่มีเสียงดังวุ่นวาย" ; -- src=panlex
lin clamour_N = mkN "การโห่ร้อง" | mkN "ผลักดัน" | mkN "ใช้เสียงดัง" | mkN "ร้องเสียงดัง" | mkN "เสียงอึกทึกครึกโครม" ; -- src=panlex
lin clamour_V = mkV "ตะโกนเรียกร้อง" ; -- src=panlex
lin clamour_V2 = mkV2 "ตะโกนเรียกร้อง" ; ---- ; -- src=panlex
lin clamp_N = mkN "คีมหนีบ" | mkN "คีม" | mkN "บีบบังคับ" | mkN "เครื่องหนีบ" | mkN "เครื่องมือที่ทําให้ติดแน่นเข้าด้วยกัน" ; -- src=panlex
lin clamp_V = mkV "จำกัด" ; -- src=panlex
lin clamp_V2 = mkV2 "จำกัด" ; ---- ; -- src=panlex
lin clamshell_N = mkN "ตะขอ" | mkN "หอยกาบ" ; -- src=panlex
lin clan_N = mkN "กลุ่มญาติพี่น้อง" | mkN "พวก" | mkN "พ้อง" | mkN "วงศ์" | mkN "เผ่า" | mkN "โคตร" | mkN "เหง้า" | mkN "กลุ่มคน" | mkN "ครอบครัว" | mkN "ชาติวงศ์" | mkN "วงศ์ตะกูล" | mkN "เผ่าพันธุ์" | mkN "กลุ่มคนที่สนใจในเรื่องเดียวกัน" ; -- src=panlex
lin clandestine_A = mkA "ลับ ๆ" | mkA "ลี้ลับ" | mkA "ส่วนตัว" | mkA "ไม่เปิดเผย" | mkA "ที่เก็บไว้เป็นความลับ" ; -- src=panlex
lin clang_N = mkN "เสียงก้องกังวาน" | mkN "เสียงก้องสะท้อน" ; -- src=panlex
lin clangorous_A = mkA "ดังแกล๊ง ๆ" | mkA "ดังอึกทึก" ; -- src=panlex
lin clangour_N = mkN "เสียงก้องกังวาน" | mkN "เสียงก้องสะท้อน" ; -- src=panlex
lin clank_N = mkN "เสียงก้องกังวาน" | mkN "เสียงก้องสะท้อน" ; -- src=panlex
lin clank_V = mkV "เกิดเสียงดังแคร๊ง" | mkV "ทําให้เกิดเสียงดังแคร๊ง" ; -- src=panlex
lin clank_V2 = mkV2 "เกิดเสียงดังแคร๊ง" ; ---- | mkV "ทําให้เกิดเสียงดังแคร๊ง" ; -- src=panlex
lin clannish_A = mkA "เกี่ยวกับเผ่าพันธ์" | mkA "ที่รักแต่พวกพ้องตัวเอง" ; -- src=panlex
lin clansman_N = mkN "พรรคพวก" | mkN "พวกพ้อง" | mkN "สมาชิกของกลุ่ม" | mkN "สมาชิกของเผ่าพันธ์" ; -- src=panlex
lin clap_N = mkN "เสียงโครม" | mkN "โรคหนองใน" | mkN "เสียงกระทบ" | mkN "การแผดเสียง" | mkN "เสียงดังมาก" | mkN "เสียงดังระเบิด" | mkN "การปรบมือ" ; -- src=panlex
lin clap_V = mkV "ตบ" | mkV "ตบมือ" | mkV "ปรบมือ" | mkV "ปรบมือ" ; -- src=panlex
lin clap_V2 = mkV2 "ตบ" ; ---- | mkV "ตบมือ" | mkV "ปรบมือ" | mkV "ปรบมือ" ; -- src=panlex
lin clapboard_N = mkN "กระดานกั้นฝา" | mkN "แผ่นไม่กระดานที่ด้านหนึ่งหนากว่าอีกด้านหนึ่ง" ; -- src=panlex
lin clapper_N = mkN "ลิ้น" | mkN "ชิวหา" | mkN "พระชิวหา" | mkN "ลิ้นกระดิ่ง" | mkN "ผู้ที่ปรบมือ" | mkN "กระดิ่งในระฆัง" ; -- src=panlex
lin clapperboard_N = mkN "แคลปเปอร์บอร์ด" ; -- src=panlex
lin claptrap_N = mkN "คำพูดสวยหรู" | mkN "คำพูดไร้สาระ" | mkN "การกล่าวเยินยอ" | mkN "คําพูดที่ไม่จริงใจ" | mkN "การพูดหรือเขียนเพื่อยกยอ" ; -- src=panlex
lin claque_N = mkN "หน้าม้า" | mkN "คนที่ติดตามชื่นชม" ; -- src=panlex
lin clarence_N = mkN "รถม้าแคลเรนส์" ; -- src=panlex
lin claret_N = mkN "ไวน์ชนิดคลาเร็ท" | mkN "ไวน์แดงบอร์โดซ์" | mkN "สีแดงอมม่วง" | mkN "เหล้าองุ่นแดง" ; -- src=panlex
lin clarification_N = mkN "การกรอง" | mkN "การอธิบาย" | mkN "การทำให้ชัด" ; -- src=panlex
lin clarify_V = mkV "ทำให้เข้าใจง่าย" | mkV "ทําให้ใสสะอาด" | mkV "ทําให้เข้าใจง่าย" ; -- src=panlex
lin clarify_V2 = mkV2 "ทำให้เข้าใจง่าย" ; ---- | mkV "ทําให้ใสสะอาด" | mkV "ทําให้เข้าใจง่าย" ; -- src=panlex
lin clarinet_N = mkN "คลาริเน็ต" | mkN "ปี่" | mkN "แคริเน็ท" | mkN "ปี่ลิ้นเดียว" | mkN "เครื่องดนตรีประเภทเป่าชนิดหนึ่ง" ; -- src=panlex
lin clarinetistFem_N = variants {} ; ---- sense to be split
lin clarinetistMasc_N = variants {} ; ---- sense to be split
lin clarion_N = mkN "แตรแคลเรียน" | mkN "ดังโหยหวน" ; -- src=panlex
lin clarity_N = mkN "ความใส" | mkN "ความใส" | mkN "ความชัดเจน" ; -- src=panlex
lin claro_N = mkN "ซิการ์คลาโร" ; -- src=panlex
lin clary_N = mkN "ต้นแคลรี" ; -- src=panlex
lin clash_N = mkN "สีตัดกัน" | mkN "ความขัดแย้ง" | mkN "การกระทบกระทั่ง" | mkN "เสียงก้องกังวาน" | mkN "เสียงก้องสะท้อน" ; -- src=panlex
lin clash_V = mkV "ชนกัน" | mkV "ตัดกันรุนแรง" | mkV "ขัดแย้ง" ; -- src=panlex
lin clash_V2 = mkV2 "ชนกัน" ; ---- | mkV "ตัดกันรุนแรง" | mkV "ขัดแย้ง" ; -- src=panlex
lin clasp_N = mkN "การจับ" | mkN "ขอเกี่ยว" ; -- src=panlex
lin clasp_V = mkV "กลัด" | mkV "กอดแน่น" | mkV "ยึดแน่น" | mkV "จับไว้แน่น" | mkV "รัดเข็มขัด" | mkV "จับไว้แน่น" ; -- src=panlex
lin clasp_V2 = mkV2 "กลัด" ; ---- | mkV "กอดแน่น" | mkV "ยึดแน่น" | mkV "จับไว้แน่น" | mkV "รัดเข็มขัด" | mkV "จับไว้แน่น" ; -- src=panlex
lin class_N = mkN "ปี" | mkN "คลาส" | mkN "ชั้น" | mkN "คอร์ส" | mkN "ชนชั้น" | mkN "ประเภท" | mkN "ดิวิชัน" | mkN "หลักสูตร" | mkN "ระดับชั้น" | mkN "ความสวยหรู" | mkN "ชนชั้นทางสังคม" | mkN "หลักสูตรการศึกษา" | mkN "หลักสูตรการเรียน" | mkN "ชนชั้นทางเศรษฐกิจและสังคม" | mkN "ชนชั้น" | mkN "ชั้นเรียน" | mkN "ประเภทหรือชนิด" ; -- src=panlex
lin classic_A = mkA "อมตะ" | mkA "ดีเด่น" | mkA "ชั้นเอก" | mkA "นักวรรณค" | mkA "เป็นหลัก" | mkA "ชั้นหนึ่ง" | mkA "ดีถึงขนาด" | mkA "ยอดเยี่ยม" | mkA "เป็นประเพณี" | mkA "เป็นพื้นฐาน" | mkA "เป็นแบบอย่าง" | mkA "ที่มีคุณภาพสูง" | mkA "แบบกรีกและโรมัน" | mkA "ที่เป็นรูปแบบดั้งเดิม" | mkA "เกี่ยวกับภาษากรีกและลาติน" | mkA "มีชื่อเสียงทางประวัติศาสตร์หรือวรรณคดี" ; -- src=panlex
lin classic_N = mkN "งานคลาสสิค" | mkN "ผลงานคลาสสิค" | mkN "ศิลปินคลาสสิก" | mkN "ผลงานระดับคลาสสิค" ; -- src=panlex
lin classical_A = mkA "คลาสสิค" | mkA "ดีเด่น" | mkA "ชั้นหนึ่ง" | mkA "เป็นแนวหน้า" | mkA "ชื่อเสียงโด่งดัง" | mkA "ที่เป็นเพลงคลาสสิค" | mkA "ที่เป็นแบบดั้งเดิม" | mkA "เป็นมรดกตกทอดแต่โบราณ" | mkA "เป็นแบบฉบับที่เชื่อถือได้" | mkA "เกี่ยวกับวรรณคดีสมัยคลาสซิค" | mkA "เกี่ยวกับแบบกรีกและโรมันโบราณ" | mkA "ที่เกี่ยวกับกรีกหรือโรมันโบราณ" ; -- src=panlex
lin classicism_N = mkN "คตินิยมคลาสสิค" | mkN "ลัทธิคลาสซิค" | mkN "กฎเกณฑ์และลักษณะของคลาสซิค" ; -- src=panlex
lin classicist_N = mkN "ศิลปินแนวคลาสสิก" | mkN "ผู้ศึกษาวัฒนธรรมกรีกและโรมันโบราณ" | mkN "ผู้ศึกษาเกี่ยวกับคลาสซิค" | mkN "ผู้ที่ศึกษาวัฒนธรรมกรีกและโรมันโบราณ" | mkN "ผู้เลื่อมใสและยึดถือเอกลักษณ์ของคลาสซิค" ; -- src=panlex
lin classics_N = mkN "การศึกษาวรรณคดียุคคลาสสิค" ; -- src=panlex
lin classification_N = mkN "ประเภท" | mkN "การจัดกลุ่ม" | mkN "การจำแนกประเภท" | mkN "การแบ่งนิวเคลียส" | mkN "การจัดแบ่งประเภท" | mkN "การแบ่งออกเป็นหมวดหมู่" ; -- src=panlex
lin classificatory_A = mkA "ที่จัดแบ่งประเภท" ; -- src=panlex
lin classified_A = mkA "ซึ่งจัดเป็นหมวดหมู่" | mkA "ที่แบ่งเป็นประเภท" | mkA "ที่เป็นความลับทางราชการ" | mkA "ซึ่งแบ่งออกเป็นประเภทหรือหมวดหมู่" | mkA "ที่เปิดเผยเฉพาะเจ้าหน้าที่เท่านั้น" ; -- src=panlex
lin classifier_N = mkN "ลักษณะนาม" | mkN "คำลักษณนาม" ; -- src=panlex
lin classless_A = mkA "ที่ไร้ชนชั้น" | mkA "ที่ไม่มีชนชั้น" | mkA "ที่ไม่มีการแบ่งชนชั้น" ; -- src=panlex
lin classmate_N = mkN "เพื่อนร่วมชั้นเรียน" | mkN "เพื่อนร่วมชั้น" | mkN "เพื่อนร่วมชั้นเรียน" ; -- src=panlex
lin classroom_N = mkN "คลาสรูม" | mkN "ชั้นเรียน" | mkN "ห้องเรียน" | mkN "ห้องเรียน" ; -- src=panlex
lin classwork_N = mkN "คลาสเวิร์ก" | mkN "งานในห้องเรียน" | mkN "งานในห้องเรียน" ; -- src=panlex
lin classy_A = mkA "ชั้นหนึ่ง" | mkA "ยอดเยี่ยม" | mkA "ชั้นเยี่ยม" ; -- src=panlex
lin clast_N = mkN "เศษหิน" ; -- src=panlex
lin clathrate_A = mkA "คล้ายตารางก่ายกัน" ; -- src=panlex
lin clatter_V = mkV "ทำเสียงอึกทึก" | mkV "ทำให้เกิดเสียงอึกทึก" | mkV "เกิดเสียงกระทบกัน" | mkV "ทําให้เกิดเสียงกระทบกัน" ; -- src=panlex
lin clatter_V2 = mkV2 "ทำเสียงอึกทึก" ; ---- | mkV "ทำให้เกิดเสียงอึกทึก" | mkV "เกิดเสียงกระทบกัน" | mkV "ทําให้เกิดเสียงกระทบกัน" ; -- src=panlex
lin clause_N = mkN "มาตรา" | mkN "หัวข้อ" | mkN "อนุประโยค" | mkN "มาตรา" | mkN "ข้อย่อย" | mkN "อนุพากย์" | mkN "อนุประโยค" | mkN "ประโยคเล็ก" | mkN "ประโยคย่อยที่เป็นส่วนหนึ่งของประโยคใหญ่" ; -- src=panlex
lin claustrophobe_N = mkN "ผู้ป่วยโรคกลัวที่แคบ" ; -- src=panlex
lin claustrophobia_N = mkN "อาการกลัวการอยู่ที่แคบ" | mkN "โรคกลัวที่ปิดทึบ" ; -- src=panlex
lin claustrophobic_A = mkA "ซึ่งกลัวการอยู่ที่แคบ" ; -- src=panlex
lin clavichord_N = mkN "แคลฟวิคอร์ด" ; -- src=panlex
lin clavicle_N = mkN "ไหปลาร้า" | mkN "พระรากขวัญ" | mkN "กระดูกไหปลาร้า" | mkN "กระดูกไหปลาร้า" ; -- src=panlex
lin clavier_N = mkN "คีย์บอร์ด" | mkN "คีย์บอร์ดเปียโน" | mkN "คีย์บนเครื่องดนตรีประเภทเปียโน ออร์แกน" ; -- src=panlex
lin claw_N = mkN "ขอ" | mkN "ก้าม" | mkN "ตะขอ" | mkN "กรงเล็บ" | mkN "เล็บ" | mkN "กรงเล็บ" ; -- src=panlex
lin clawhammer_N = mkN "ค้อนหงอน" | mkN "ค้อนช่างไม้" ; -- src=panlex
lin clawlike_A = mkA "ที่คล้ายกรงเล็บ" ; -- src=panlex
lin clay_N = mkN "ศพ" | mkN "โคลน" | mkN "ซากผี" | mkN "ซากศพ" | mkN "พระศพ" | mkN "ศพคนตาย" | mkN "พระบรมศพ" | mkN "ดินเหนียว" | mkN "ศพผู้เสียชีวิต" | mkN "ดิน" | mkN "โคลน" | mkN "ดินเผา" | mkN "ดินเหนียว" | mkN "ร่ายกายมนุษย์" ; -- src=panlex
lin clayey_A = mkA "คล้ายดินเหนียว" ; -- src=panlex
lin claystone_N = mkN "หินเคลย์" | mkN "หินดินเหนียว" ; -- src=panlex
lin clean_A = mkA (thword "ทำ" "ความ" "สะ" "อาด") | {-pan-} mkA "ใส" | mkA "ว่าง" | mkA "สะอาด" | mkA "เปล่า" | mkA "บริสุทธิ์" | mkA "ที่ขาวสะอาด" | mkA "ซึ่งไม่เสพยา" | mkA "ซึ่งไม่พกอาวุธ" | mkA "ซึ่งไม่ติดเชื้อ" | mkA "ซึ่งไม่มีรอยแก้" | mkA "ที่มีน้ำใจนักกีฬา" | mkA "ซึ่งไม่มีรอยขีดแก้" | mkA "ซึ่งไม่มีความยุ่งยาก" | mkA "สะอาด" | mkA "หมดจด" | mkA "สุจริต" | mkA "ทั้งหมด" | mkA "สมบูรณ์" | mkA "เกลี้ยง" | mkA "ยุติธรรม" | mkA "รักสะอาด" | mkA "บริสุทธิ์" | mkA "ไม่มีมลทิน" | mkA "ไม่หยาบคาย" | mkA "ไร้เดียงสา" | mkA "ที่ไม่มีบาป" | mkA "ไม่มีรอยแก้" | mkA "ที่ไม่มีอาวุธ" | mkA "ไม่มีทั้งสิ้น" | mkA "ไม่มีอุปสรรค์" | mkA "เป็นระเบียบเรียบร้อย" | mkA "ไม่มีกัมมันตภาพรังสี" | mkA "ที่ไม่มีปัญหาเรื่องยาเสพย์ติด" ; -- src=panlex
lin clean_N = mkN "ท่าคลีน" | mkN "ท่าคลีนแอนด์เจิร์ก" ; -- src=panlex
lin clean_V = mkV "สี" | mkV "ขจัด" | mkV "ล้าง" | mkV "ถอนขน" | mkV "ชำระล้าง" | mkV "กวาดเรียบ" | mkV "ทำความสะอาด" | mkV "ล้างทำความสะอาด" | mkV "เอาสิ่งสกปรกออก" | mkV "สะอาด" | mkV "ทําความสะอาด" | mkV "ทําให้ว่างเปล่า" ; -- src=panlex
lin clean_V2 = mkV2 "สี" ; ---- | mkV "ขจัด" | mkV "ล้าง" | mkV "ถอนขน" | mkV "ชำระล้าง" | mkV "กวาดเรียบ" | mkV "ทำความสะอาด" | mkV "ล้างทำความสะอาด" | mkV "เอาสิ่งสกปรกออก" | mkV "สะอาด" | mkV "ทําความสะอาด" | mkV "ทําให้ว่างเปล่า" ; -- src=panlex
lin clean_out_V = advV OP_clean_V OP_out_Adv ; -- guess-p-verb
lin clean_out_V2 = prepV2 OP_clean_V OP_out_Prep ; -- guess-p-verb
lin clean_up_V = advV OP_clean_V OP_up_Adv ; -- guess-p-verb
lin clean_up_V2 = prepV2 OP_clean_V OP_up_Prep ; -- guess-p-verb
lin cleanable_A = mkA "ซึ่งทำให้สะอาดได้" | mkA "ที่ทําความสะอาดได้" ; -- src=panlex
lin cleaner_N = mkN "คนทำความสะอาด" | mkN "พนักงานซักแห้ง" | mkN "น้ำยาทำความสะอาด" | mkN "พนักงานทำความสะอาด" | mkN "คนทําความสะอาด" | mkN "ผู้ทําความสะอาด" | mkN "สิ่งที่ทําความสะอาด" ; -- src=panlex
lin cleaners_N = mkN "ร้านซักแห้ง" ; -- src=panlex
lin cleaning_N = mkN "การทำความสะอาด" ; -- src=panlex
lin cleanliness_N = mkN "การรักษาความสะอาด" ; -- src=panlex
lin cleanly_A = mkA "สะอาดสะอ้าน" | mkA "สะอาด" | mkA "รักสะอาด" | mkA "อย่างสะอาด" | mkA "อย่างเรียบร้อย" ; -- src=panlex
lin cleanness_N = mkN "ผ้าขาว" | mkN "ความสะอาด" ; -- src=panlex
lin cleanser_N = mkN "น้ำยาทำความสะอาด" | mkN "คนทําความสะอาด" | mkN "ของเหลวที่ใช้ทําความสะอาด" | mkN "สิ่งที่ใช้ทําความสะอาดผิวหน้า" | mkN "สิ่งหรือเครื่องมือทําความสะอาด" ; -- src=panlex
lin clean_up_N = mkN "กำไรมหาศาล" | mkN "การทำความสะอาด" | mkN "กำไรเป็นกอบเป็นกำ" | mkN "การชําระล้าง" | mkN "การทําความสะอาด" | mkN "กระบวนการชําระล้าง" | mkN "การเลิกทําสิ่งผิดกฎหมาย" ; -- src=panlex
lin clear_A = mkA "ใส" | mkA "ซึ่งอ่านง่าย" | mkA "ชัด" | mkA "ชัดเจน" | mkA "ที่เข้าใจง่าย" | mkA "ที่รับรู้ได้ดี" | mkA "ที่ไม่มีเมฆหรือหมอก" ; -- src=panlex
lin clear_Adv = mkAdv "อย่างเสร็จสมบูรณ์" | mkAdv "อย่างเสร็จสิ้นสมบูรณ์" | mkAdv "อย่างชัดเจน" | mkAdv "อย่างทั้งหมด" ; -- src=panlex
lin clear_N = mkN "ที่โล่ง" | mkN "การพ้นมลทิน" | mkN "การพ้นข้อกล่าวหา" | mkN "การเป็นผู้บริสุทธิ์" ; -- src=panlex
lin clear_V = mkV "ขาย" | mkV "กรอง" | mkV "เปิด" | mkV "ขายโละ" | mkV "จางหาย" | mkV "อนุญาต" | mkV "ได้รับ" | mkV "เคลียร์" | mkV "ไอออกมา" | mkV "ให้อำนาจ" | mkV "เคลื่อนย้าย" | mkV "ทำให้กระจ่าง" | mkV "ทำให้เป็นทาง" | mkV "ได้กำไรสุทธิ" | mkV "ไม่มีความผิด" | mkV "ผ่านการเห็นชอบ" | mkV "ทําให้สะอาด" | mkV "ทําให้ชัดเจน" | mkV "กลายเป็นชัดเจน" | mkV "เคลียร์ริ่งเช็ค" ; -- src=panlex
lin clear_V2 = mkV2 "ขาย" ; ---- | mkV "กรอง" | mkV "เปิด" | mkV "ขายโละ" | mkV "จางหาย" | mkV "อนุญาต" | mkV "ได้รับ" | mkV "เคลียร์" | mkV "ไอออกมา" | mkV "ให้อำนาจ" | mkV "เคลื่อนย้าย" | mkV "ทำให้กระจ่าง" | mkV "ทำให้เป็นทาง" | mkV "ได้กำไรสุทธิ" | mkV "ไม่มีความผิด" | mkV "ผ่านการเห็นชอบ" | mkV "ทําให้สะอาด" | mkV "ทําให้ชัดเจน" | mkV "กลายเป็นชัดเจน" | mkV "เคลียร์ริ่งเช็ค" ; -- src=panlex
lin clear_away_V = advV OP_clear_V OP_away_Adv ; -- guess-p-verb
lin clear_away_V2 = mkV2 (advV OP_clear_V OP_away_Adv ) ; -- guess-p-verb
lin clear_off_V = advV OP_clear_V OP_off_Adv ; -- guess-p-verb
lin clear_out_V = advV OP_clear_V OP_out_Adv ; -- guess-p-verb
lin clear_out_V2 = prepV2 OP_clear_V OP_out_Prep ; -- guess-p-verb
lin clear_up_V = advV OP_clear_V OP_up_Adv ; -- guess-p-verb
lin clear_up_V2 = prepV2 OP_clear_V OP_up_Prep ; -- guess-p-verb
lin clearance_N = mkN "การอนุมัติ" | mkN "บัตรอนุญาต" | mkN "การกวาดล้าง" | mkN "การเอาออกไป" | mkN "การขายรุสต๊อก" | mkN "การทําให้หมดไป" | mkN "การทําความสะอาด" | mkN "การแลกเปลี่ยนเอกสาร" | mkN "ช่องว่างระหว่างสองสิ่ง" | mkN "การผ่านการตรวจของศุลกากร" ; -- src=panlex
lin clear_headed_A = mkA "ซึ่งไม่สับสน" | mkA "ซึ่งไม่รู้สึกสับสน" | mkA "ที่ไม่สับสน" | mkA "หัวสมองแจ่มใส" ; -- src=panlex
lin clearing_N = mkN "การกรอง" | mkN "ที่โล่ง" | mkN "การทำให้ชัด" | mkN "ที่โล่ง" | mkN "การหักบัญชี" | mkN "การชําระล้าง" | mkN "การทําความสะอาด" | mkN "การแลกเปลี่ยนเอกสารธนาคาร" | mkN "พื้นที่ที่ไม่มีต้นไม้ขึ้น" | mkN "ยอดจํานวนเงินที่หักบัญชีกัน" ; -- src=panlex
lin clearness_N = mkN "ความใส" | mkN "ความสะอาด" | mkN "ความชัดเจน" | mkN "ความชัดแจ้ง" | mkN "ความเรียบร้อย" ; -- src=panlex
lin clearway_N = mkN "ถนนที่ห้ามหยุดรถ" | mkN "ทางสายด่วน" ; -- src=panlex
lin cleat_N = mkN "ปุ่มสตั๊ด" | mkN "ปุ่มสตั๊ด" ; -- src=panlex
lin cleats_N = mkN "สตั๊ด" | mkN "รองเท้าสตั๊ด" | mkN "รองเท้าฟุตบอล" ; -- src=panlex
lin cleavable_A = mkA "ซึ่งแยกออกได้" | mkA "ซึ่งเป็นร่องได้" ; -- src=panlex
lin cleavage_N = mkN "การแตก" | mkN "การแยก" | mkN "การแตกตัว" | mkN "การแบ่งแยก" | mkN "การแยกออก" | mkN "การแตกร้าว" | mkN "การแบ่งออก" ; -- src=panlex
lin cleave_V = mkV "ติด" | mkV "แนบ" | mkV "เซาะ" | mkV "แยกออก" | mkV "ทําให้แยกออก" ; -- src=panlex
lin cleave_V2 = mkV2 "ติด" ; ---- | mkV "แนบ" | mkV "เซาะ" | mkV "แยกออก" | mkV "ทําให้แยกออก" ; -- src=panlex
lin cleaver_N = mkN "ปังตอ" | mkN "มีดอีโต้" | mkN "มีดสับเนื้อ" | mkN "มีดชำแหละเนื้อ" | mkN "ขวาน" | mkN "คนที่ผ่า" | mkN "มีดขนาดใหญ่" | mkN "เครื่องมือผ่า" | mkN "เครื่องมือที่ใช้ในการตัดขนาดใหญ่" ; -- src=panlex
lin cleavers_N = mkN "ต้นคลีเวอร์ส" ; -- src=panlex
lin clef_N = mkN "กุญแจเสียง" | mkN "เครื่องหมายโน๊ตดนตรี" ; -- src=panlex
lin cleft_A = mkA "เว้าลึก" ; -- src=panlex
lin cleft_N = mkN "รอยแตก" | mkN "ร่อง" | mkN "รอยแตก" | mkN "รอยแยก" ; -- src=panlex
lin cleistothecium_N = mkN "คลิสโททีเซียม" ; -- src=panlex
lin clematis_N = mkN "ต้นเคลมาทิส" ; -- src=panlex
lin clemency_N = mkN "การผ่อนผัน" | mkN "ความอํานวย" | mkN "ภาวะเย็นสบาย" | mkN "ความไม่รุนแรง" | mkN "อากาศที่น่าสบาย" | mkN "ความมีใจเมตตากรุณาปรานี" ; -- src=panlex
lin clement_A = mkA "อํานวย" | mkA "ผ่อนผัน" | mkA "เย็นสบาย" | mkA "ไม่รุนแรง" | mkA "เมตตากรุณา" ; -- src=panlex
lin clerestory_N = mkN "หน้าต่างชั้นบน" ; -- src=panlex
lin clergy_N = mkN "มัคทายก" | mkN "พวกพระ" | mkN "ผู้ที่ทําเกี่ยวกับศาสนา" ; -- src=panlex
lin clergyman_N = mkN "บาทหลวง" | mkN "มัคทายก" | mkN "พระ" | mkN "สมาชิกพวกพระ" | mkN "ผู้ที่เป็นสมาชิกองค์กรทางศาสนา" ; -- src=panlex
lin cleric_N = mkN "พระสอนศาสนา" | mkN "อย่างพระ" | mkN "สมาชิกพวกพระ" ; -- src=panlex
lin clerical_A = mkA "เสมียน" | mkA "ซึ่งสอนศาสนา" | mkA "เกี่ยวกับพระ" | mkA "เกี่ยวกับเสมียน" | mkA "ที่เกี่ยวกับงานศาสนา" ; -- src=panlex
lin clericalist_N = mkN "ผู้นับถือลัทธิเคลริเคอลิสม์" ; -- src=panlex
lin clerk_N = mkN "เสมียน" | mkN "เด็กขายของ" | mkN "เสมียน" | mkN "พาแขกไปที่ห้องพัก" | mkN "พนักงานโรงแรมที่ทําหน้าที่เกี่ยวกับการลงทะเบียน" ; -- src=panlex
lin clerk_V = mkV "ทำงานเสมียน" ; -- src=panlex
lin clerkship_N = mkN "ตำแหน่งเสมียน" ; -- src=panlex
lin clever_A = mkA "ฉลาด" | {-pan-} mkA "ที่ชาญฉลาด" | mkA "เหมาะ" | mkA "ชํานาญ" | mkA "ประณีต" | mkA "ว่องไว" | mkA "น่าพอใจ" | mkA "สร้างสรรค์" | mkA "เฉลียวฉลาด" | mkA "ริเริ่มเก่ง" ; -- src=panlex
lin cleverness_N = mkN "ปฏิภาณ" | mkN "ไหวพริบ" | mkN "เชาว์ปัญญา" | mkN "ไหวพริบปฏิภาณ" | mkN "ความสร้างสรรค์" | mkN "ความฉลาดปราดเปรื่อง" ; -- src=panlex
lin clevis_N = mkN "เหล็กรูปตัวยูมีรูขันน๊อตที่ใช้ติดกับวัตถุอื่น" ; -- src=panlex
lin clew_N = mkN "ร่องรอย" | mkN "กลุ่มด้าย" | mkN "เงื่อนงํา" ; -- src=panlex
lin clews_N = mkN "เชือกผูกเปล" ; -- src=panlex
lin cliche_N = mkN "คำพูดซ้ำซาก" | mkN "สำนวนประดาษ" | mkN "เก่า" | mkN "ซ้ํา ๆ ซาก ๆ" | mkN "สํานวนซ้ํา ๆ ซาก ๆ น่าเบื่อ" ; -- src=panlex
lin click_N = mkN "บานพับ" | mkN "เสียงคลิก" | mkN "เสียงกดปุ่ม" | mkN "การคลิกเมาส์" | mkN "เสียงดูดลมเข้า" | mkN "พยัญชนะเสียงดูดลมเข้า" | mkN "เสียงดังกริ๊ก" ; -- src=panlex
lin click_V = mkV "จมจ่อม" | mkV "ดีดนิ้ว" | mkV "เดาะลิ้น" | mkV "ร้องกุ๊กๆ" | mkV "ทําเสียงดังกริ๊ก" | mkV "เกิดเสียงดังกริ๊ก" | mkV "เข้าใจขึ้นอย่างฉับพลัน" ; -- src=panlex
lin client_N = mkN "ลูกค้า" | mkN "ลูกข่าย" | mkN "ลูกความ" | mkN "ผู้ซื้อสินค้าและบริการ" | mkN "คนไข้" | mkN "ลูกค้า" | mkN "ลูกความ" | mkN "คนซื้อของ" | mkN "ผู้พึ่งคนอื่น" ; -- src=panlex
lin clientele_N = mkN "กลุ่มลูกค้า" | mkN "ลูกค้าทั้งหมด" | mkN "ลูกค้าทั้งหมด" | mkN "ลูกค้าทั้งหลาย" ; -- src=panlex
lin cliff_N = mkN "หน้าผา" | mkN "หน้าผา" | mkN "หน้าผาสูง" ; -- src=panlex
lin climacteric_N = mkN "วัยทอง" | mkN "วัยหมดระดู" | mkN "วัยรอบเดือน" | mkN "วัยหมดประจำเดือน" | mkN "ช่วงระยะหมดระดู" | mkN "ช่วงระยะที่เปลี่ยนวัย" | mkN "ช่วงวัยที่มีการเปลี่ยนแปลงทางสภาพจิตใจ" ; -- src=panlex
lin climactic_A = mkA "เกี่ยวกับจุดสุดยอด" | mkA "ที่เกี่ยวกับช่วงสําคัญสุดยอด" ; -- src=panlex
lin climate_N = mkN "สภาพอากาศ" | mkN "ภูมิสถาปัตย์" | mkN "สภาพอากาศ" | mkN "อากาศตามฤดูกาล" | mkN "แนวโน้มทั่วไปของสังคม" | mkN "ประเพณีนิยมที่เป็นอยู่" ; -- src=panlex
lin climatologist_N = mkN "นักภูมิอากาศ" ; -- src=panlex
lin climatology_N = mkN "ภูมิอากาศวิทยา" | mkN "กาลวิทยา" ; -- src=panlex
lin climax_N = mkN "ไคลแม็กซ์" | mkN "ระยะรุนแรง" | mkN "จุดไคลแม็กซ์" | mkN "จุดขมวดปมปัญหา" | mkN "การถึงจุดสุดยอด" | mkN "จุดสําคัญสูงสุดของเหตุการณ์" ; -- src=panlex
lin climax_V = mkV "มาถึงจุดสําคัญสูงสุดของเหตุการณ์" | mkV "ทําให้ถึงจุดสําคัญสูงสุดของเหตุการณ์" ; -- src=panlex
lin climax_V2 = mkV2 "มาถึงจุดสําคัญสูงสุดของเหตุการณ์" ; ---- | mkV "ทําให้ถึงจุดสําคัญสูงสุดของเหตุการณ์" ; -- src=panlex
lin climb_N = mkN "การปีน" | mkN "การไต่" | mkN "ชันขึ้น" | mkN "การเพิ่มขึ้น" | mkN "การค่อยๆเพิ่ม" ; -- src=panlex
lin climb_V = mkV "ไต่" | mkV "ขึ้น" | mkV "ชันขึ้น" | mkV "ไต่ขึ้น" | mkV "เพิ่มขี้น" | mkV "เพิ่มสูงขึ้น" | mkV "เลื่อนชั้นทางสังคม" | mkV "ปีน" | mkV "ค่อยๆ เพิ่มขึ้น" ; -- src=panlex
lin climb_V2 = mkV2 "ไต่" ; ---- | mkV "ขึ้น" | mkV "ชันขึ้น" | mkV "ไต่ขึ้น" | mkV "เพิ่มขี้น" | mkV "เพิ่มสูงขึ้น" | mkV "เลื่อนชั้นทางสังคม" | mkV "ปีน" | mkV "ค่อยๆ เพิ่มขึ้น" ; -- src=panlex
lin climb_down_V = advV OP_climb_V OP_down_Adv ; -- guess-p-verb
lin climber_N = mkN "นักปีน" | mkN "นักปีนเขา" | mkN "นักไต่เขา" | mkN "ไม้เลื้อย" | mkN "นักกีฬาปีนเขา" | mkN "นักปีนด้วยเท้า" | mkN "คนมักใหญ่ใฝ่สูง" | mkN "เหล็กติดรองเท้า" | mkN "คนปีน" | mkN "คนไต่" | mkN "คนใฝ่สูง" | mkN "ไม้เลื้อย" | mkN "อุปกรณ์ที่ช่วยในการปีนป่าย" | mkN "คนที่ต้องการก้าวหน้าในธุรกิจหรือในสังคม" | mkN "เครื่องมือสําหรับติดที่รองเท้าหรือขาเพื่อใช้ในการปีนเสา" ; -- src=panlex
lin clime_N = mkN "สภาพอากาศ" | mkN "ภูมิสถาปัตย์" | mkN "อากาศตามฤดูกาล" | mkN "ถิ่นหนึ่งหรือบริเวณหนึ่งของโลก" ; -- src=panlex
lin clinch_N = mkN "ซับใน" | mkN "การกอด" | mkN "คีมหนีบ" | mkN "การโอบกอด" | mkN "ส่วนที่แบนเรียบ" | mkN "การกอดกัน" ; -- src=panlex
lin clinch_V = mkV "กำ" ; -- src=panlex
lin clinch_V2 = mkV2 "กำ" ; ---- ; -- src=panlex
lin clincher_N = mkN "การตัดสินใจ" | mkN "ปัจจัยชี้ขาด" | mkN "ปัจจัยตัดสินหลัก" | mkN "เครื่องคลีนเชอร์" ; -- src=panlex
lin cling_N = mkN "ผลไม้เนื้อติดเม็ด" ; -- src=panlex
lin cling_V = mkV "ติด" | mkV "แนบ" | mkV "แขวน" | mkV "ทําให้ติดกัน" | mkV "ทําให้ติดแน่น" ; -- src=panlex
lin clingfish_N = mkN "ปลาคลิงฟิช" ; -- src=panlex
lin clinic_N = mkN "คลินิก" | mkN "ร้านหมอ" | mkN "การเข้ารับการรักษา" | mkN "คลินิก" | mkN "สถานรักษาพยาบาล" ; -- src=panlex
lin clinical_A = mkA "เกี่ยวกับคลินิก" | mkA "ที่เกี่ยวกับคลินิค" ; -- src=panlex
lin clinician_N = mkN "ผู้ปฏิบัติงานทางคลินิก" | mkN "ผู้เชี่ยวชาญในการรักษา" | mkN "นายแพทย์ที่ศึกษาโรคจากคนไข้จริง ๆ" ; -- src=panlex
lin clinid_N = mkN "ปลาคลินิด" ; -- src=panlex
lin clink_N = mkN "คุก" | mkN "เรือนจำ" | mkN "เสียงคลิก" ; -- src=panlex
lin clinker_N = mkN "กาก" | mkN "อิฐ" | mkN "คลิงเกอร์" | mkN "ความผิดพลาด" | mkN "อิฐแข็งเย็น" | mkN "ของชั้นหนึ่ง" | mkN "คนที่ชนแก้วกัน" | mkN "สิ่งที่กระทบดังกริ๊ง" ; -- src=panlex
lin clinometer_N = mkN "มาตรความเอียง" ; -- src=panlex
lin clinquant_A = mkA "สุกปลั่ง" ; -- src=panlex
lin clintonia_N = mkN "ต้นคลินโทเนีย" ; -- src=panlex
lin clip_N = mkN "คลิป" | mkN "ครั้ง" | mkN "ที่หนีบ" | mkN "คลิปหนีบ" | mkN "การตัดออก" | mkN "อัญมณีประดับ" | mkN "ปลอกกระสุนปืน" | mkN "คราว" | mkN "คลิป" | mkN "ครั้ง" | mkN "ตัดออก" | mkN "ที่ติดของอันเล็กๆ" ; -- src=panlex
lin clipboard_N = mkN "คลิปบอร์ด" | mkN "กระดานที่มีที่แขวนกระดาษแขวนอยู่" ; -- src=panlex
lin clipper_N = mkN "ลิมิเตอร์" | mkN "ที่ตัดเล็บ" | mkN "กรรไกรตัดหญ้า" | mkN "กรรไกรตัดเล็บ" | mkN "ผู้ตัด" | mkN "ม้าเร็ว" | mkN "ปัตตาเลี่ยน" | mkN "กรรไกรตัดผมหรือขน" | mkN "ผู้ที่ตัดหรือเล็ม" | mkN "อุปกรณ์สําหรับตัด" | mkN "เครื่องบินที่บินเร็ว" | mkN "เครื่องมือที่ใช้ในการตัด" | mkN "คนหรือสิ่งที่เคลื่อนที่อย่างรวดเร็ว" ; -- src=panlex
lin clipping_N = mkN "การตัด" | mkN "ข่าวตัด" | mkN "การตัดออก" | mkN "การตัดแต่ง" | mkN "ข่าวตัดจากหนังสือ" | mkN "การตัด" | mkN "ชั้นหนึ่ง" | mkN "ยอดเยี่ยม" | mkN "การเล็มออก" | mkN "สิ่งที่ใช้ตัดหรือเล็ม" | mkN "ข่าวสารที่ตัดจากหนังสือพิมพ์หรือนิตยาสาร" ; -- src=panlex
lin clique_N = mkN "หมู่" | mkN "กลุ่ม" | mkN "กลุ่มภายใน" | mkN "กลุ่มผลประโยชน์ร่วม" | mkN "ก๊ก" | mkN "คณะ" | mkN "พวก" | mkN "หมู่" | mkN "กลุ่ม" | mkN "กลุ่มคนที่สมาคมเฉพาะพวกของตน" ; -- src=panlex
lin clitoridectomy_N = mkN "การขลิบปุ่มกระสัน" ; -- src=panlex
lin clitoris_N = mkN "คลิตอริส" | mkN "ปุ่มกระสัน" | mkN "ปุ่มคลิตอริส" | mkN "คลิทอริส" | mkN "เม็ดละมุด" | mkN "ปุ่มกระสัน" ; -- src=panlex
lin cloaca_N = mkN "โคลเอกา" | mkN "ท่อน้ำทิ้ง" | mkN "ท่อโสโครก" | mkN "ท่อใต้ดิน" ; -- src=panlex
lin cloak_N = mkN "เสื้อคลุม" | mkN "สิ่งปกคลุม" | mkN "ปิดบัง" | mkN "ซ่อนเล้น" | mkN "เสื้อคลุม" | mkN "เสื้อคลุมหลวม ๆ" | mkN "เสื้อคลุมไม่มีปก" ; -- src=panlex
lin cloakmaker_N = mkN "ช่างเสื้อขนสัตว์" | mkN "ช่างตัดเสื้อขนสัตว์" ; -- src=panlex
lin cloakroom_N = mkN "ห้องฝากเสื้อ" | mkN "ห้องน้ํา" | mkN "ห้องฝากกระเป๋า" | mkN "ห้องฝากเก็บเสื้อคลุม" ; -- src=panlex
lin clobber_N = mkN "ของใช้ส่วนตัว" ; -- src=panlex
lin cloche_N = mkN "หมวกทรงระฆัง" | mkN "แก้วครอบ" | mkN "หมวกหญิง รูประฆัง" ; -- src=panlex
lin clock_N = mkN "นาฬิกา" | mkN "นาฬิกา" ; -- src=panlex
lin clock_V = mkV "จับเวลา" | mkV "จับเวลา" ; -- src=panlex
lin clock_V2 = mkV2 "จับเวลา" ; ---- | mkV "จับเวลา" ; -- src=panlex
lin clocking_N = mkN "เครื่องบันทึกเวลา" ; -- src=panlex
lin clocksmith_N = mkN "ช่างนาฬิกา" | mkN "ช่างทำนาฬิกา" | mkN "ช่างซ่อมนาฬิกา" ; -- src=panlex
lin clockwise_A = mkA "ตามเข็มนาฬิกา" | mkA "หมุนตามเข็มนาฬิกา" | mkA "ที่หมุนตามเข็มนาฬิกา" ; -- src=panlex
lin clockwise_Adv = mkAdv "ตามเข็มนาฬิกา" | mkAdv "หมุนตามเข็มนาฬิกา" | mkAdv "ที่หมุนตามเข็มนาฬิกา" ; -- src=panlex
lin clockwork_N = mkN "ลานนาฬิกา" | mkN "กลไกของนาฬิกา" | mkN "เครื่องกลไกของนาฬิกา" ; -- src=panlex
lin clod_N = mkN "ก้อน" | mkN "คนโง่" | mkN "ก้อนดิน" | mkN "กลุ่มก้อน" | mkN "คนเซ่อซ่า" | mkN "ดิน" | mkN "ก้อน" | mkN "คนโง่" | mkN "คนทึ่ม" | mkN "ก้อนดิน" | mkN "แผ่นดิน" ; -- src=panlex
lin clodhopper_N = mkN "รองเท้าหนังหยาบ" | mkN "คนบ้านนอก" | mkN "คนเซ่อซ่า" | mkN "คนที่งุ่มง่าม" ; -- src=panlex
lin clofibrate_N = mkN "ยาคลอไฟเบรต" ; -- src=panlex
lin clog_N = mkN "คลอจแดนซ์" | mkN "รองเท้าไม้" | mkN "รองเท้าไม้" ; -- src=panlex
lin clog_V = mkV "อุดตัน" | mkV "ขัดขวาง" | mkV "เต้นรำแบบคล๊อก" | mkV "บรรทุกเกินพิกัด" ; -- src=panlex
lin clog_V2 = mkV2 "อุดตัน" ; ---- | mkV "ขัดขวาง" | mkV "เต้นรำแบบคล๊อก" | mkV "บรรทุกเกินพิกัด" ; -- src=panlex
lin cloister_N = mkN "ชีวิตในวัดอาราม" | mkN "ทางเดินมีหลังคา" | mkN "อยู่อย่างสันโดษ" | mkN "สถานที่สันโดษทางศาสนา" ; -- src=panlex
lin clomiphene_N = mkN "คลอมิฟีน" ; -- src=panlex
lin clomipramine_N = mkN "โคลมิพรามีน" ; -- src=panlex
lin clone_N = mkN "แฝดคนละฝา" | mkN "สิ่งที่เกิดจากเซลล์เดียวกัน" | mkN "สิ่งมีชีวิตที่เกิดมาจากเซลล์เดียวกัน" | mkN "พวกสิ่งมีชีวิตที่สืบพันธุ์จากระบบไร้เพศ" ; -- src=panlex
lin clonic_A = mkA "เกี่ยวกับการกระตุกสั่นของกล้ามเนื้อ" ; -- src=panlex
lin clonidine_N = mkN "โคลนิดีน" ; -- src=panlex
lin cloning_N = mkN "โคลนนิ่ง" | mkN "การโคลนนิ่ง" ; -- src=panlex
lin clonus_N = mkN "อาการกระตุกสั่น" | mkN "การกระตุกสันของกล้ามเนื้อ" ; -- src=panlex
lin close_A = mkA "สั้น" | mkA "ใกล้" | mkA "ซึ่งหุบปาก" | mkA "ซึ่งไม่พูด" | mkA "ซึ่งรูดซิปปาก" | mkA "ซึ่งปิดปากเงียบ" | mkA "ที่เหมือนต้นฉบับ" | mkA "ที่ใกล้เคียงของเิดิม" | mkA "ใกล้" | mkA "ที่คล้ายกัน" | mkA "ที่มีความใกล้ชิดกัน" | mkA "ที่แตกต่างกันน้อยมาก" ; -- src=panlex
lin close_Adv = mkAdv "เกือบถึง" | mkAdv "อย่างใกล้ชิด" | mkAdv "ใกล้" ; -- src=panlex
lin close_N = mkN "ตอนจบ" | mkN "ตอนท้าย" | mkN "ตอนสุดท้าย" | mkN "ช่วงปิดการสนทนา" ; -- src=panlex
lin close_V = mkV "ปิด" | mkV "อุด" | mkV "โคลส" | mkV "ปิดฉาก" | mkV "ปิดเกม" | mkV "โอบกอด" | mkV "ปิดกิจการ" | mkV "ประจันหน้า" | mkV "นำเข้ามาใกล้" | mkV "จบ" | mkV "ปิด" | mkV "หับ" | mkV "ทําให้จบ" ; -- src=panlex
lin close_V2 = mkV2 (mkV "ปิด") ;
lin close_down_V = advV OP_close_V OP_down_Adv ; -- guess-p-verb
lin close_down_V2 = prepV2 OP_close_V OP_down_Prep ; -- guess-p-verb
lin close_in_V = advV OP_close_V OP_in_Adv ; -- guess-p-verb
lin close_in_on_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin close_in_upon_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_upon_Prep ; -- guess-p-verb
lin close_off_V2 = prepV2 OP_close_V OP_off_Prep ; -- guess-p-verb
lin close_on_V2 = prepV2 OP_close_V OP_on_Prep ; -- guess-p-verb
lin close_out_V2 = prepV2 OP_close_V OP_out_Prep ; -- guess-p-verb
lin close_up_V = advV OP_close_V OP_up_Adv ; -- guess-p-verb
lin close_up_V2 = prepV2 OP_close_V OP_up_Prep ; -- guess-p-verb
lin closed_A = mkA "ซึ่งปิดบานเกล็ด" | mkA "ปิด" | mkA "สงวน" | mkA "สรุป" | mkA "ห้ามเข้า" | mkA "ที่อยู่ได้ด้วยตัวเอง" | mkA "ที่ไม่เปิดรับสิ่งใหม่" | mkA "จํากัดเฉพาะกลุ่มหรือบุคคล" ; -- src=panlex
lin close_fisted_A = mkA "ตระหนี่" | mkA "ขี้เหนียว" ; -- src=panlex
lin closeness_N = mkN "การปกปิด" | mkN "ความใกล้" | mkN "ความคุ้นเคย" | mkN "ความสนิทสนม" | mkN "ความใกล้ชิด" | mkN "ความตระหนี่ถี่เหนียว" ; -- src=panlex
lin closeout_N = mkN "การขายสินค้าล้างสต็อก" | mkN "การขายสินค้าทั้งหมดเพื่อปิดกิจการ" ; -- src=panlex
lin closer_N = mkN "คนใกล้" | mkN "โคลเซอร์" | mkN "ฟินิสเชอร์" ; -- src=panlex
lin closet_A = mkA "ที่เป็นส่วนตัว" ; -- src=panlex
lin closet_N = mkN "ตู้" | mkN "สุขา" | mkN "ห้องน้ำ" | mkN "ห้องเล็ก" | mkN "ตู้เสื้อผ้า" | mkN "ห้องเก็บของ" | mkN "ตู้" | mkN "ชั้น" | mkN "ห้องลับ" | mkN "ลับเฉพาะ" | mkN "ห้องน้ํา" | mkN "ห้องส้วม" | mkN "ห้องเล็ก" | mkN "ห้องเล็กๆ" | mkN "เสี่ยงโชค" | mkN "ห้องส่วนตัว" ; -- src=panlex
lin close_up_N = mkN "ภาพโคลสอัพ" | mkN "ภาพระยะใกล้" | mkN "ภาพถ่ายระยะใกล้" ; -- src=panlex
lin closing_N = mkN "การจบ" | mkN "ตอนจบ" | mkN "การปิด" | mkN "การใกล้" | mkN "การลงเอย" | mkN "ตอนสุดท้าย" | mkN "การเสร็จสมบูรณ์" | mkN "ช่วงปิดการสนทนา" | mkN "ยุติ" | mkN "หมดเวลา" | mkN "การสิ้นสุด" ; -- src=panlex
lin clostridium_N = mkN "คลอสตริเดียม" ; -- src=panlex
lin closure_N = mkN "การจบ" | mkN "การปิด" | mkN "การหยุด" | mkN "การใกล้" | mkN "การขัดขวาง" | mkN "สิ่งกีดขวาง" | mkN "ผลการตัดสินใจ" | mkN "กฎแห่งความสมบูรณ์" | mkN "กฎแห่งความสิ้นสุด" | mkN "ยุติ" | mkN "การจบ" | mkN "ฝาปิด" | mkN "การปิด" | mkN "การยุติ" | mkN "การสิ้นสุด" | mkN "สิ่งที่ปิด" | mkN "กําแพงล้อมรอบ" ; -- src=panlex
lin clot_N = mkN "ขัดขวาง" | mkN "ก้อนเล็ก ๆ" | mkN "กลุ่มเล็ก ๆ" | mkN "ทําให้หยุด" | mkN "ก้อนเลือดที่แข็งตัว" | mkN "ปกคลุมไปด้วยก้อนเล็ก ๆ" ; -- src=panlex
lin clot_V = mkV "จับเป็นก้อน" | mkV "ทำให้เป็นลิ่ม" | mkV "จับตัวเป็นลิ่ม" ; -- src=panlex
lin clot_V2 = mkV2 "จับเป็นก้อน" ; ---- | mkV "ทำให้เป็นลิ่ม" | mkV "จับตัวเป็นลิ่ม" ; -- src=panlex
lin cloth_N = mkN "ผ้า" | mkN "สิ่งทอ" | mkN "ผ้า" | mkN "เสื้อผ้า" ; -- src=panlex
lin clothes_N = mkN "ชุด" | mkN "อาภรณ์" | mkN "ผ้านุ่ง" | mkN "ผ้าผ่อน" | mkN "เสื้อผ้า" | mkN "เสื้อผ้า" | mkN "เครื่องแต่งกาย" ; -- src=panlex
lin clothesbrush_N = mkN "แปรงปัดเสื้อผ้า" ; -- src=panlex
lin clotheshorse_N = mkN "คนขี้โอ่" | mkN "ราวตากผ้า" | mkN "หนุ่มสำรวย" | mkN "หนุ่มสำอาง" | mkN "ผู้ชายที่ช่างแต่งตัว" ; -- src=panlex
lin clothesline_N = mkN "เชือกราวตากผ้า" | mkN "ราวแขวนเสื้อ" ; -- src=panlex
lin clothes_pin_N = mkN "ที่หนีบผ้า" | mkN "ไม้หนีบผ้า" | mkN "ที่หนีบผ้า" | mkN "ไม้หนีบผ้า" ; -- src=panlex
lin clothier_N = mkN "คนขายเสื้อผ้าบุรุษ" | mkN "คนขายเสื้อผ้าผู้ชาย" | mkN "คนขายผ้า" | mkN "ช่างทําเสื้อ" | mkN "คนขายเสื้อผ้าผู้ชาย" | mkN "คนขายหรือตัดเย็บเสื้อผ้า" ; -- src=panlex
lin clothing_N = mkN "เครื่องนุ่งห่ม" | mkN "เครื่องแต่งกาย" | mkN "เสื้อผ้าเครื่องประดับ" | mkN "เสื้อผ้า" | mkN "เครื่องอาภรณ์" | mkN "เครื่องใบเรือ" | mkN "ที่นอนหมอนมุ้ง" | mkN "เครื่องนุ่งห่ม" ; -- src=panlex
lin cloud_N = mkN (thword "เมฆ") | {-pan-} mkN "ฝูง" | mkN "เมฆ" | mkN "มลทิน" | mkN "ขี้เมฆ" | mkN "ปุยเมฆ" | mkN "ก้อนเมฆ" | mkN "ฝูงห่าน" | mkN "ม่านหมอก" | mkN "กลุ่มหมอกควัน" | mkN "ความขุ่นข้องหมองมัว" | mkN "เมฆ" | mkN "หมอก" | mkN "กลุ่มควัน" | mkN "สิ่งของจํานวนมากที่อยู่รวมกัน" ; -- src=panlex
lin cloud_V = mkV "แต้ม" | mkV "มืดมัว" | mkV "ทำให้มัว" | mkV "มีเมฆครึ้ม" | mkV "ทำให้พร่าเลือน" | mkV "แต้มสีเป็นจุดๆ" | mkV "มีเมฆมาก" | mkV "ทําให้มัว" | mkV "ทําให้มืด" | mkV "เกิดปัญหา" | mkV "ปกคลุมด้วยเมฆ" | mkV "ก่อให้เกิดปัญหา" ; -- src=panlex
lin cloud_V2 = mkV2 "แต้ม" ; ---- | mkV "มืดมัว" | mkV "ทำให้มัว" | mkV "มีเมฆครึ้ม" | mkV "ทำให้พร่าเลือน" | mkV "แต้มสีเป็นจุดๆ" | mkV "มีเมฆมาก" | mkV "ทําให้มัว" | mkV "ทําให้มืด" | mkV "เกิดปัญหา" | mkV "ปกคลุมด้วยเมฆ" | mkV "ก่อให้เกิดปัญหา" ; -- src=panlex
lin cloudberry_N = mkN "ต้นคลาวด์เบอร์รี่" ; -- src=panlex
lin cloudburst_N = mkN "ฝนตกหนัก" | mkN "พายุฝน" | mkN "ฝนที่ตกหนักอย่างกะทันหัน" ; -- src=panlex
lin clouding_N = mkN "การเกิดเมฆ" ; -- src=panlex
lin cloudless_A = mkA "ที่ไม่มีเมฆ" ; -- src=panlex
lin cloudy_A = mkA "ขุ่น" | mkA "ขุ่น" | mkA "ไม่ใส" | mkA "กํากวม" | mkA "มืดมัว" | mkA "ไม่ชัด" | mkA "เลือนลาง" | mkA "เศร้าซึม" | mkA "ไม่ชัดเจน" | mkA "ที่เหมือนเมฆ" | mkA "เกี่ยวกับเมฆ" | mkA "ที่ปกคลุมด้วยเมฆ" | mkA "เต็มไปด้วยก้อนเมฆ" ; -- src=panlex
lin clout_N = mkN "การชก" | mkN "การต่อย" | mkN "อิทธิพล" | mkN "เป้าธนู" | mkN "ตะุปูสั้นหัวแบน" | mkN "การตบ" | mkN "การตี" | mkN "เศษผ้า" | mkN "การต่อย" | mkN "เศษผ้าที่ใช้ปะ" | mkN "เป้าที่ใช้ในการยิงธนู" ; -- src=panlex
lin clove_N = mkN "กานพลู" | mkN "ต้นกานพลู" | mkN "ต้นกานพูล" | mkN "กลีบกระเทียม" | mkN "กานพลู" | mkN "กลีบของหัวหอมหรือกระเทียม" | mkN "พืชสมุนไพรชนิดหนึ่งใช้ในการปรุงอาหาร" ; -- src=panlex
lin clover_N = mkN "ต้นโคลเวอร์" ; -- src=panlex
lin clowder_N = mkN "ฝูงแมว" ; -- src=panlex
lin clown_N = mkN "จำอวด" | mkN "ตัวตลก" | mkN "ความตลกลามก" | mkN "ตัวตลกหยาบคาย" | mkN "คนโง่" | mkN "ตัวตลก" | mkN "คนเซ่อซ่า" ; -- src=panlex
lin clown_V = mkV "แสดงเป็นตัวตลก" | mkV "แสดงเป็นตัวตลก" ; -- src=panlex
lin cloy_V = mkV "ให้กินมากเกิน" | mkV "ทำให้กินมากเกิน" | mkV "เอียน" | mkV "ทําให้เอียน" | mkV "เบื่อเนื่องจากมีมากเกินไป" | mkV "ทําให้เบื่อเนื่องจากมีมากเกินไป" ; -- src=panlex
lin cloy_V2 = mkV2 "ให้กินมากเกิน" ; ---- | mkV "ทำให้กินมากเกิน" | mkV "เอียน" | mkV "ทําให้เอียน" | mkV "เบื่อเนื่องจากมีมากเกินไป" | mkV "ทําให้เบื่อเนื่องจากมีมากเกินไป" ; -- src=panlex
lin clozapine_N = mkN "โคลซาพีน" ; -- src=panlex
lin club_1_N = variants {} ; ---- sense to be split
lin club_2_N = variants {} ; ---- sense to be split
lin club_V = mkV "รวมกลุ่ม" | mkV "ใช้เวลาร่วมกัน" | mkV "ตีด้วยกระบองสั้น" | mkV "รวมกัน" | mkV "รวมกลุ่ม" | mkV "ตีด้วยไม้กระบอง" | mkV "ช่วยกันออกค่าใช้จ่าย" | mkV "ช่วยกันเสียค่าใช้จ่าย" ; -- src=panlex
lin club_V2 = mkV2 "รวมกลุ่ม" ; ---- | mkV "ใช้เวลาร่วมกัน" | mkV "ตีด้วยกระบองสั้น" | mkV "รวมกัน" | mkV "รวมกลุ่ม" | mkV "ตีด้วยไม้กระบอง" | mkV "ช่วยกันออกค่าใช้จ่าย" | mkV "ช่วยกันเสียค่าใช้จ่าย" ; -- src=panlex
lin clubbing_N = mkN "ภาวะนิ้วปุ้ม" ; -- src=panlex
lin clubfoot_N = mkN "เท้าบิด" | mkN "เท้าผิดรูป" | mkN "ภาวะที่มีเท้าผิดรูป" | mkN "ลักษณะที่ผิดรูปของเท้า" ; -- src=panlex
lin clubhouse_N = mkN "คลับ" | mkN "สโมสร" | mkN "คลับเฮาส์" | mkN "สโมสร" | mkN "บ้านหรือตึกที่ใช้เป็นสโมสร" ; -- src=panlex
lin clubroom_N = mkN "ห้องสโมสร" ; -- src=panlex
lin cluck_N = mkN "เสียงกุ๊กๆ" ; -- src=panlex
lin cluck_V = mkV "ร้องกุ๊กๆ" ; -- src=panlex
lin clue_N = mkN "ร่องรอย" | mkN "เบาะแส" | mkN "ร่องรอย" | mkN "เงื่อนงํา" ; -- src=panlex
lin clumber_N = mkN "สุนัขพันธุ์คลัมเบอร์" | mkN "สุนัขพันธุ์คลัมเบอร์ สเปเนียล" ; -- src=panlex
lin clump_N = mkN "ก้อน" | mkN "กลุ่ม" | mkN "ก้อนดิน" | mkN "เสียงดัง" | mkN "กลุ่มก้อน" | mkN "ก้อน" | mkN "กลุ่มก้อน" | mkN "หมู่ต้นไม้" | mkN "เสียงเดินลงส้น" | mkN "การเดินกระแทกเท้า" | mkN "จับกันเป็นกลุ่มก้อน" | mkN "การจับตัวเป็นกลุ่มของเซลล์" ; -- src=panlex
lin clump_V = mkV "มัด" | mkV "เดินซุ่มซ่าม" | mkV "เดินลงส้น" | mkV "เดินลงเท้า" | mkV "เดินเท้าหนัก" | mkV "เดินกระแทกเท้า" | mkV "ปลูกไว้เป็นหมู่" | mkV "จับกันเป็นกลุ่มก้อน" | mkV "ทําให้รวมตัวกันเป็นกลุ่มก้อน" ; -- src=panlex
lin clump_V2 = mkV2 "มัด" ; ---- | mkV "เดินซุ่มซ่าม" | mkV "เดินลงส้น" | mkV "เดินลงเท้า" | mkV "เดินเท้าหนัก" | mkV "เดินกระแทกเท้า" | mkV "ปลูกไว้เป็นหมู่" | mkV "จับกันเป็นกลุ่มก้อน" | mkV "ทําให้รวมตัวกันเป็นกลุ่มก้อน" ; -- src=panlex
lin clumsiness_N = mkN "ความเปิ่น" | mkN "ความเงอะงะ" | mkN "ความเงอะงะ" | mkN "ความเซ่อซ่า" | mkN "ความงุ่มง่าม" | mkN "ความซุ่มซ่าม" | mkN "ความไม่ชํานาญในการใช้" ; -- src=panlex
lin clumsy_A = mkA "ซึ่งเทอะทะ" | mkA "เซอะ" | mkA "เงอะงะ" | mkA "เซ่อซ่า" | mkA "เร่อร่า" | mkA "งุ่มง่าม" | mkA "ซุ่มซ่าม" | mkA "ไม่คล่อง" | mkA "ไม่ชํานาญในการใช้" ; -- src=panlex
lin clunch_N = mkN "ดินเหนียวแข็ง" | mkN "ดินเหนียว" | mkN "ดินเหนียวทนไฟ" ; -- src=panlex
lin clunk_N = mkN "เสียงดัง" | mkN "คนทึ่ม" | mkN "เสียงโลหะกระทบ" | mkN "คนที่ไม่มีอารมณ์ขัน" | mkN "เสียงที่เกิดจากโลหะกระทบกัน" ; -- src=panlex
lin clusia_N = mkN "ต้นคลูเซีย" ; -- src=panlex
lin cluster_N = mkN "กลุ่ม" | mkN "ช่อ" | mkN "ฝูง" | mkN "พวง" | mkN "ก้อน" | mkN "กลุ่ม" | mkN "หย่อม" | mkN "กระจุก" | mkN "เป็นกลุ่มก้อน" ; -- src=panlex
lin cluster_V = mkV "มัด" | mkV "รวมเป็นกลุ่ม" | mkV "อยู่เป็นกลุ่ม" | mkV "ทําให้อยู่รวมเป็นกลุ่ม" ; -- src=panlex
lin cluster_V2 = mkV2 "มัด" ; ---- | mkV "รวมเป็นกลุ่ม" | mkV "อยู่เป็นกลุ่ม" | mkV "ทําให้อยู่รวมเป็นกลุ่ม" ; -- src=panlex
lin clutch_N = mkN "ครอก" | mkN "กลุ่ม" | mkN "การจับ" | mkN "คลัตช์" | mkN "กระเป๋าถือ" | mkN "ความตึงเครียด" | mkN "ลูกไก่ที่ฟักในคราวเดียวกัน" | mkN "การฉวย" | mkN "การยึด" | mkN "การคว้า" | mkN "การเกาะ" | mkN "การกําแน่น" | mkN "การเกาะแน่น" | mkN "มือที่อยู่ในรูปกํา" | mkN "เครื่องเกาะเพลาในรถยนต์" | mkN "จํานวนไข่ที่ฟักภายในครั้งหนึ่งๆ" | mkN "ลูกไก่ที่เกิดจากไข่ที่ฟักในคราวเดียวกัน" ; -- src=panlex
lin clutch_V = mkV "กุม" | mkV "จับไว้แน่น" | mkV "ยึดไว้แน่น" | mkV "เกาะกุมจิตใจ" | mkV "เกาะ" | mkV "ฉวยไว้" | mkV "กําแน่น" | mkV "คว้าไว้" | mkV "จับแน่น" | mkV "พยายามยึดไว้" ; -- src=panlex
lin clutch_V2 = mkV2 "กุม" ; ---- | mkV "จับไว้แน่น" | mkV "ยึดไว้แน่น" | mkV "เกาะกุมจิตใจ" | mkV "เกาะ" | mkV "ฉวยไว้" | mkV "กําแน่น" | mkV "คว้าไว้" | mkV "จับแน่น" | mkV "พยายามยึดไว้" ; -- src=panlex
lin clutter_N = mkN "เสียงรบกวน" | mkN "ความยุ่งเหยิง" | mkN "ความชุลมุน" | mkN "กองเรี่ยราด" | mkN "ความวุ่นวาย" | mkN "ความอลหม่าน" | mkN "กองระเกะระกะ" | mkN "ความยุ่งเหยิง" ; -- src=panlex
lin cm_N = mkN "ซม." | mkN "เซนติเมตร" ; -- src=panlex
lin coach_1_N = variants {} ; ---- sense to be split
lin coach_2_N = variants {} ; ---- sense to be split
lin coach_3_N = variants {} ; ---- sense to be split
lin coach_V = mkV "เทรน" | mkV "ฝึกซ้อม" | mkV "ขับรถโค้ช" | mkV "ฝึกกีฬาให้" | mkV "สอนกีฬาให้" | mkV "ทําหน้าที่เป็นครูฝึก" ; -- src=panlex
lin coach_V2 = mkV2 "เทรน" ; ---- | mkV "ฝึกซ้อม" | mkV "ขับรถโค้ช" | mkV "ฝึกกีฬาให้" | mkV "สอนกีฬาให้" | mkV "ทําหน้าที่เป็นครูฝึก" ; -- src=panlex
lin coach_builder_N = mkN "คนต่อตัวถังรถยนต์" | mkN "ช่างประกอบตัวถังรถ" | mkN "ช่างประกอบตัวถังรถยนต์" ; -- src=panlex
lin coaching_N = mkN "การเป็นโค้ช" | mkN "การฝึกสอน" ; -- src=panlex
lin coachman_N = mkN "คนขับรถม้า" | mkN "สารถี" | mkN "คนขับรถม้า" | mkN "สายเบ็ดตกปลา" ; -- src=panlex
lin coachwhip_N = mkN "ต้นโอโคติลโล" ; -- src=panlex
lin coadjutor_N = mkN "ผู้ช่วยพระสังฆราช" | mkN "ผู้ช่วย" ; -- src=panlex
lin coagulant_N = mkN "สารก่อการจับก้อน" ; -- src=panlex
lin coagulase_N = mkN "เอนไซม์โคแอกกูเลส" ; -- src=panlex
lin coagulate_V = mkV "จับเป็นก้อน" | mkV "ทำให้เป็นลิ่ม" | mkV "ทําให้จับตัวแข็งเป็นก้อนหนาและเหนียวหนืด" | mkV "ทําให้เปลี่ยนจากของเหลวเป็นก้อนหนาและหนืด" | mkV "เปลี่ยนจากของเหลวเป็นก้อนหนาและเหนียวหนืด" ; -- src=panlex
lin coagulate_V2 = mkV2 "จับเป็นก้อน" ; ---- | mkV "ทำให้เป็นลิ่ม" | mkV "ทําให้จับตัวแข็งเป็นก้อนหนาและเหนียวหนืด" | mkV "ทําให้เปลี่ยนจากของเหลวเป็นก้อนหนาและหนืด" | mkV "เปลี่ยนจากของเหลวเป็นก้อนหนาและเหนียวหนืด" ; -- src=panlex
lin coagulation_N = mkN "การจับก้อน" | mkN "การทำให้ข้นเป็นลิ่ม" ; -- src=panlex
lin coal_N = mkN "ถ่านหิน" | mkN "ถ่านแดง" | mkN "ถ่าน" | mkN "ถ่านหิน" | mkN "ก้อนถ่าน" ; -- src=panlex
lin coal_V = mkV "เผาถ่าน" | mkV "ใส่ถ่าน" | mkV "เติมถ่านหินใส่" | mkV "เผาให้เป็นถ่าน" | mkV "จัดหาถ่านหินให้" ; -- src=panlex
lin coal_V2 = mkV2 "เผาถ่าน" ; ---- | mkV "ใส่ถ่าน" | mkV "เติมถ่านหินใส่" | mkV "เผาให้เป็นถ่าน" | mkV "จัดหาถ่านหินให้" ; -- src=panlex
lin coalbin_N = mkN "ถังใส่ถ่านหิน" ; -- src=panlex
lin coalesce_V = mkV "ผสม" | mkV "มิกซ์" | mkV "ผสมเข้าด้วยกัน" | mkV "รวมตัว" ; -- src=panlex
lin coalescence_N = mkN "การรวมตัว" | mkN "การรวมตัว" ; -- src=panlex
lin coalescent_A = mkA "ที่รวมตัว" ; -- src=panlex
lin coalfield_N = mkN "แหล่งถ่านหิน" ; -- src=panlex
lin coalition_N = mkN "สหพันธ์" | mkN "การรวมตัว" | mkN "การประสานกัน" | mkN "รัฐบาลผสม" | mkN "การร่วมกัน" | mkN "รัฐบาลร่วม" | mkN "สัมพันธมิตร" | mkN "การประสานกัน" | mkN "การร่วมมือกัน" | mkN "การรวมเป็นหนึ่งเดียว" ; -- src=panlex
lin coalman_N = mkN "กรรมกรขนถ่านหิน" ; -- src=panlex
lin coalpit_N = mkN "เหมืองถ่านหิน" ; -- src=panlex
lin coarse_A = mkA "หยาบ" | mkA "เลว" | mkA "หยาบ" | mkA "ธรรมดา ๆ" | mkA "ธรรมดาๆ" | mkA "หยาบคาย" | mkA "หยาบช้า" | mkA "หยาบโลน" | mkA "ขาดรสนิยม" | mkA "ไม่ประณีต" | mkA "มีคุณภาพที่เลว" ; -- src=panlex
lin coarsen_V = mkV "ทำให้หยาบ" | mkV "ทำให้แห้งหยาบ" | mkV "แห้งหยาบ" | mkV "ทําให้แห้งหยาบ" ; -- src=panlex
lin coarsen_V2 = mkV2 "ทำให้หยาบ" ; ---- | mkV "ทำให้แห้งหยาบ" | mkV "แห้งหยาบ" | mkV "ทําให้แห้งหยาบ" ; -- src=panlex
lin coarseness_N = mkN "ความเลว" | mkN "ความธรรมดา" | mkN "ความหยาบคาย" | mkN "ความหยาบช้า" | mkN "ความหยาบโลน" | mkN "การขาดรสนิยม" | mkN "ความไม่ประณีต" ; -- src=panlex
lin coast_N = mkN "การสไลด์" | mkN "การเลื่อน" | mkN "ชายฝั่งทะเล" | mkN "ทางลาดเอียง" | mkN "ชายหาด" | mkN "ชายฝั่ง" | mkN "ริมฝั่ง" | mkN "ฝั่งทะเล" ; -- src=panlex
lin coast_V = mkV "สําเร็จอย่างง่ายดาย" ; -- src=panlex
lin coast_V2 = mkV2 "สําเร็จอย่างง่ายดาย" ; ---- ; -- src=panlex
lin coastal_A = mkA "ที่ใกล้ชายฝั่ง" ; -- src=panlex
lin coaster_N = mkN "แผ่นรอง" | mkN "คนแล่นเรือเลียบชายฝั่ง" | mkN "ผู้อยู่อาศัยใกล้ชายฝั่ง" | mkN "ถาดรองแก้ว" | mkN "เรือขนสินค้าหรือผู้โดยสารที่วิ่งตามชายฝั่ง" ; -- src=panlex
lin coastguardsman_N = mkN "ยามฝั่ง" ; -- src=panlex
lin coastland_N = mkN "ที่ดินตามชายฝั่งทะเล" ; -- src=panlex
lin coastline_N = mkN "แนวชายฝั่งทะเล" | mkN "แนวชายฝั่งทะเล" | mkN "เส้นแนวชายฝั่งทะเล" ; -- src=panlex
lin coastward_Adv = mkAdv "ไปทางชายฝั่ง" | mkAdv "ไปยังฝั่งทะเล" ; -- src=panlex
lin coastwise_A = mkA "ไปทางชายฝั่ง" | mkA "ที่ใกล้ชายฝั่ง" ; -- src=panlex
lin coastwise_Adv = mkAdv "ไปทางชายฝั่ง" | mkAdv "ที่ใกล้ชายฝั่ง" ; -- src=panlex
lin coat_N = mkN (thword "เสื้อ" "คลุม") "ตัว" | {-pan-} mkN "ขน" | mkN "โค้ต" | mkN "เสื้อโค้ต" | mkN "ระบบผมและขน" | mkN "สิ่งที่ใช้เคลือบ" | mkN "โค้ต" | mkN "เปลือก" | mkN "ขนสัตว์" | mkN "เสื้อนอก" | mkN "หนังสัตว์" | mkN "เสื้อคลุม" | mkN "สิ่งปกคลุม" | mkN "สิ่งที่ห่อหุ้ม" | mkN "สิ่งที่ปกคลุมผิวหน้าไว้บางๆ" ; -- src=panlex
lin coati_N = mkN "คูนแคท" ; -- src=panlex
lin coating_N = mkN "การตกแต่ง" | mkN "พรมประดับ" | mkN "ผ้ามีน้ำหนัก" | mkN "สิ่งที่ใช้เคลือบ" | mkN "ชั้นบางๆ ที่ใช้ปกคลุม" | mkN "ชั้นเหนือผิวหน้า" | mkN "สิ่งทอที่ใช้ทําเสื้อคลุม" ; -- src=panlex
lin coatrack_N = mkN "ที่แขวนเสื้อโค้ต" ; -- src=panlex
lin coattail_N = mkN "หางเสื้อ" | mkN "ส่วนหางของเสือโคร่งที่ต่อจากช่วงเอว" ; -- src=panlex
lin coauthorFem_N = variants {} ; ---- sense to be split
lin coauthorMasc_N = variants {} ; ---- sense to be split
lin coax_V = mkV "ออดอ้อน" | mkV "อ้อนวอน" | mkV "คะยั้นคะยอ" | mkV "ชักชวน" | mkV "โน้มน้าว" | mkV "คะยั้นคะยอ" | mkV "เกลี้ยกล่อม" ; -- src=panlex
lin coax_V2 = mkV2 "ออดอ้อน" ; ---- | mkV "อ้อนวอน" | mkV "คะยั้นคะยอ" | mkV "ชักชวน" | mkV "โน้มน้าว" | mkV "คะยั้นคะยอ" | mkV "เกลี้ยกล่อม" ; -- src=panlex
lin coaxial_A = mkA "ซึ่งมีแกนร่วม" | mkA "ที่มีแกนกลางร่วมกัน" ; -- src=panlex
lin coaxing_N = mkN "การประจบ" ; -- src=panlex
lin coaxingly_Adv = mkAdv "อย่างเชื้อเชิญ" ; -- src=panlex
lin cob_N = mkN "ม้าเตี้ย" | mkN "ถั่วเฮเซล" | mkN "ห่านตัวผู้" | mkN "พืชจำพวกถั่ว" | mkN "หงส์ขาวหลังดำ" | mkN "ก้อนกลม" | mkN "ซังข้าวโพด" | mkN "หงส์ตัวผู้" | mkN "ห่านตัวผู้" | mkN "แกนฝักข้าวโพด" | mkN "ม้าพันธุ์เตี้ย" ; -- src=panlex
lin cobalt_N = mkN "โคบอลต์" | mkN "ธาตุโคบอลต์" | mkN "เลขอะตอม 27" | mkN "โคบอลต์" | mkN "กัมมันตภาพรังสีโคบอลต์" | mkN "ธาตุโลหะสีขาวคล้ายเงิน" ; -- src=panlex
lin cobaltite_N = mkN "โคบอลไทต์" | mkN "แร่โคบอลไทต์" ; -- src=panlex
lin cobber_N = mkN "เพื่อน" ; -- src=panlex
lin cobble_N = mkN "หินปูถนน" ; -- src=panlex
lin cobbler_N = mkN "คอบเบลอร์" | mkN "ช่างรองเท้า" | mkN "คนซ่อมรองเท้า" | mkN "ช่างซ่อมรองเท้า" | mkN "ขนม" | mkN "ช่างปะรองเท้า" | mkN "ช่างฝีมืองุ่มง่าม" | mkN "ช่างซ่อมหรือทํารองเท้า" ; -- src=panlex
lin cobblestone_N = mkN "หินปูถนน" | mkN "หินกลม เล็ก ๆ ตามธรรมชาติ" | mkN "หินกรวด" | mkN "หินก้อนกลมๆ" | mkN "กรวดขนาดปานกลาง" ; -- src=panlex
lin cobia_N = mkN "ปลาโคเบีย" ; -- src=panlex
lin cob_nut_N = mkN "ต้นคอบนัต" | mkN "ถั่วเฮเซล" | mkN "พืชจำพวกถั่ว" ; -- src=panlex
lin cobra_N = mkN "งูเห่า" ; -- src=panlex
lin cobweb_N = mkN "ใยแมงมุม" | mkN "ผ้าทอใยแมงมุม" | mkN "แผนการ" | mkN "หยากไย่" | mkN "ใยแมงมุม" | mkN "เส้นใยแมงมุม" | mkN "สิ่งที่คล้ายใยแมงมุม" ; -- src=panlex
lin cobwebby_A = mkA "โปร่งบาง" | mkA "คล้ายใยแมงมุม" ; -- src=panlex
lin coca_N = mkN "ใบโคคา" | mkN "ต้นโคคา" | mkN "พืชชนิดหนึ่งที่ใบสามารถนํามาสกัดโคเคนได้" ; -- src=panlex
lin cocaine_N = mkN "โคเคน" | mkN "โคเคอีน" | mkN "โคเคน" | mkN "ยาชาเฉพาะที่ ได้มาจากใบโคคา" | mkN "ยาเสพย์ติดชนิดหนึ่ง" | mkN "ยาชาเฉพาะแห่งที่ได้จากใบโคคา" | mkN "ยาชาใช้ระงับความเจ็บปวดเฉพาะที่" ; -- src=panlex
lin cocarboxylase_N = mkN "ไทอะมีนไพโรฟอสเฟต" ; -- src=panlex
lin coccidium_N = mkN "ค็อกซิเดียม" ; -- src=panlex
lin coccobacillus_N = mkN "คอกโคบาซิลลัส" ; -- src=panlex
lin coccus_N = mkN "ค็อกคัส" | mkN "แบคทีเรียทรงกลม" | mkN "แบคทีเรียรูปทรงกลม" ; -- src=panlex
lin coccyx_N = mkN "ก้นกบ" | mkN "กระดูกก้นกบ" | mkN "กระดูกหาง" | mkN "กระดูกก้นกบ" | mkN "กระดูดก้นกบ" ; -- src=panlex
lin cochin_N = mkN "ไก่เอเซียพันธุ์หนึ่ง" ; -- src=panlex
lin cochineal_N = mkN "โคชินิล" | mkN "สีโคชินิล" | mkN "สีย้อมสีแดงชนิดหนึ่ง" ; -- src=panlex
lin cochlea_N = mkN "อวัยวะรูปหอยโข่ง" | mkN "คอเคีย" ; -- src=panlex
lin cock_N = mkN "ดอ" | mkN "นก" | mkN "ควย" | mkN "จู๋" | mkN "ไข่" | mkN "นกปืน" | mkN "นกเขา" | mkN "พ่อไก่" | mkN "เจี๊ยว" | mkN "จ้าวโลก" | mkN "ดอกจำปี" | mkN "น้องชาย" | mkN "ไก่โต้ง" | mkN "กระเจี๊ยว" | mkN "ไก่ตัวผู้" | mkN "ไก่เพศผู้" | mkN "ก๊อกแบบหมุน" | mkN "ผู้นํา" | mkN "หัวก๊อก" | mkN "หัวหน้า" | mkN "ก๊อกน้ํา" | mkN "นกตัวผู้" | mkN "ไก่ตัวผู้" | mkN "นกสับของปืน" ; -- src=panlex
lin cockade_N = mkN "โบหรือริบบิ้นประดับหมวก" | mkN "ตราหรือเครื่องหมายประดับหมวก" | mkN "ริบบิ้นหรือช่อดอกไม่ที่ติดบนหมวก" ; -- src=panlex
lin cockamamie_A = mkA "งี่เง่า" | mkA "ไร้สาระ" | mkA "น่าหัวเราะ" ; -- src=panlex
lin cockatoo_N = mkN "นกกระตั้ว" | mkN "นกแก้ว" | mkN "นกกระตั้ว" | mkN "นกแขกเต้า" | mkN "นกชนิดหนึ่งตระกูลเดียวกับนกแก้วมีถิ่นกําเนิดในออสเตรเลีย" ; -- src=panlex
lin cockatrice_N = mkN "มังกรไก่" | mkN "ครอกกาไทรส์" ; -- src=panlex
lin cocker_N = mkN "สุนัขพันธุ์อิงลิช คอกเกอร์ สเปเนียล" | mkN "สุนัขพันธุ์คอกเกอร์" | mkN "สุนัขพันธุ์คอกเกอร์ สเปเนียล" | mkN "ป้อยอ" | mkN "เอาอกเอาใจ" ; -- src=panlex
lin cockerel_N = mkN "ไก่ตัวผู้อายุไม่เกินหนึ่งปี" | mkN "วัยรุ่นที่ชอบหาเรื่อง" | mkN "ไก่ตัวผู้ที่มีอายุไม่ถึงปี" | mkN "ไก่ที่มีอายุน้อยกว่า 1 ปี" ; -- src=panlex
lin cockeyed_A = mkA "เมาหนัก" | mkA "เมาปลิ้น" | mkA "ที่ไร้สาระ" | mkA "เมาหัวราน้ำ" | mkA "โง่" | mkA "ที่ตาเข" | mkA "ผิดสิ้นเชิง" | mkA "ตาเขหรือเหล่" | mkA "เอียงไปหรือบิดไปด้านหนึ่ง" ; -- src=panlex
lin cockfight_N = mkN "การชนไก่" | mkN "การตีไก่" | mkN "การชนไก่" ; -- src=panlex
lin cockfighting_N = mkN "การชนไก่" | mkN "กีฬาชนไก่" ; -- src=panlex
lin cockhorse_N = mkN "ม้าโยก" ; -- src=panlex
lin cockle_N = mkN "หอยแครง" | mkN "หอยแครง" ; -- src=panlex
lin cocklebur_N = mkN "ต้นค็อกเคิลเบอร์" ; -- src=panlex
lin cockleshell_N = mkN "เปลือกหอยแครง" ; -- src=panlex
lin cockney_N = mkN "ภาษาค็อกนีย์" | mkN "ภาษาอังกฤษสำเนียงค็อกนีย์" | mkN "คนจนในย่านลอนดอนตะวันออก" ; -- src=panlex
lin cockpit_N = mkN "เวทีชนไก่" | mkN "ห้องนักบิน" | mkN "ที่นั่งคนขับ" | mkN "ที่นั่งนักบิน" | mkN "ห้องขับเครื่องบิน" | mkN "สนามรบ" | mkN "สนามแข่ง" | mkN "สนามชนไก่" | mkN "เวทีชนไก่" | mkN "ห้องคนขับเครื่องบิน" ; -- src=panlex
lin cockroach_N = mkN "แมลงสาบ" | mkN "แมงสาบ" | mkN "แมลงสาบ" ; -- src=panlex
lin cockscomb_N = mkN "หงอน" | mkN "คนขี้โ่อ่" | mkN "ต้นหงอนไก่" | mkN "หมวกหงอนไก่" | mkN "คนหยิ่ง" | mkN "หงอนไก่" | mkN "คนขี้โอ่" | mkN "ต้นหงอนไก่" ; -- src=panlex
lin cockspur_N = mkN "ต้นค็อกสเปอร์" | mkN "หญ้าออร์เชิร์ด" | mkN "เดือยไก่ตัวผู้" ; -- src=panlex
lin cocksucker_N = mkN "คนโง่" | mkN "คนชอบอม" | mkN "คนเลวทราม" | mkN "ไอ้สารเลว" | mkN "ผู้อมลึงค์" ; -- src=panlex
lin cocksure_A = mkA "แน่นอน" | mkA "มั่นใจที่สุด" | mkA "แน่นอนที่สุด" | mkA "แน่นอนเกินไป" | mkA "ปลอดภัยที่สุด" ; -- src=panlex
lin cocktail_N = mkN "ค็อกเทล" | mkN "ค็อกเทล" | mkN "อาหารเรียกน้ําย่อย" | mkN "เครื่องดื่มเหล้าผสมผลไม้" ; -- src=panlex
lin cockup_N = mkN "ความสับสน" | mkN "การงอขึ้นข้างบน" ; -- src=panlex
lin cocky_A = mkA "ยโส" | mkA "ทะนง" | mkA "หยิ่ง" | mkA "อวดดี" | mkA "ลําพอง" | mkA "หยิ่งยโส" | mkA "ที่มั่นใจในตนเองมากเกินไป" ; -- src=panlex
lin coco_N = mkN "ต้นมะพร้าว" | mkN "มะพร้าว" | mkN "ต้นมะพร้าว" | mkN "ลูกมะพร้าว" | mkN "เนื้อมะพร้าว" ; -- src=panlex
lin cocoa_N = mkN "โกโก้" | mkN "ผงโกโก้" | mkN "สีโกโก้" | mkN "ต้นโกโก้" | mkN "สีน้ําตาลอ่อน" | mkN "เมล็ดต้นโกโก้" | mkN "สีน้ําตาลโกโก้" | mkN "เครื่องดื่มโกโก้" | mkN "เครื่องดื่มใส่ผงโกโก้" ; -- src=panlex
lin coconut_N = mkN "มะพร้าว" | mkN "ต้นมะพร้าว" | mkN "เนื้อมะพร้าว" | mkN "มะพร้าว" | mkN "ต้นมะพร้าว" | mkN "ลูกมะพร้าว" | mkN "เนื้อมะพร้าว" ; -- src=panlex
lin cocoon_N = mkN "ปลอกไข่" | mkN "ดักแด้" | mkN "รังไหม" | mkN "รังไหมดิบ" | mkN "รังไข่แมลง" | mkN "รังไข่แมงมุม" | mkN "อุปกรณ์กันน้ํา" ; -- src=panlex
lin cocotte_N = mkN "ไก่" | mkN "อีตัว" | mkN "กะหรี่" | mkN "นางโลม" | mkN "โสเภณี" | mkN "นางคณิกา" | mkN "หญิงขายตัว" | mkN "หญิงบริการ" | mkN "นางกลางเมือง" | mkN "ผู้หญิงหากิน" | mkN "หญิงงามเมือง" | mkN "ผู้หญิงขายตัว" | mkN "หญิงขายบริการ" | mkN "หญิงขายบริการทางเพศ" | mkN "หญิงโสเภณี" ; -- src=panlex
lin cocozelle_N = mkN "โคโคเซล" | mkN "ต้นโคโคเซล" ; -- src=panlex
lin cocuswood_N = mkN "ไม้โคคัสวู้ด" ; -- src=panlex
lin cod_N = mkN "ปลาคอด" | mkN "เนื้อปลาคอด" | mkN "ถุง" | mkN "ปลาคอด" | mkN "ถุงอัณฑะ" ; -- src=panlex
lin cod_V = mkV "ล้อ" | mkV "ยั่ว" | mkV "แหย่" | mkV "ต้มตุ๋น" | mkV "หลอกลวง" | mkV "ยั่วเย้า" | mkV "ล้อเลียน" | mkV "เยาะเย้อ" | mkV "เย้าหยอก" ; -- src=panlex
lin cod_V2 = mkV2 "ล้อ" ; ---- | mkV "ยั่ว" | mkV "แหย่" | mkV "ต้มตุ๋น" | mkV "หลอกลวง" | mkV "ยั่วเย้า" | mkV "ล้อเลียน" | mkV "เยาะเย้อ" | mkV "เย้าหยอก" ; -- src=panlex
lin coda_N = mkN "ตอนสุดท้าย" | mkN "เสียงตอนจบ" ; -- src=panlex
lin code_N = mkN "รหัส" | mkN "โค้ด" | mkN "กฎระเบียบ" | mkN "กฏระเบียบ" | mkN "รหัสคอมพิวเตอร์" | mkN "รหัส" | mkN "กฎเกณฑ์" | mkN "มาตรการ" | mkN "ระเบียบ" | mkN "สัญลักษณ์" | mkN "หลักเกณฑ์" | mkN "เครื่องหมาย" | mkN "ประมวลกฎหมาย" | mkN "ระบบสัญลักษณ์" ; -- src=panlex
lin codefendant_N = mkN "จำเลยร่วม" ; -- src=panlex
lin codeine_N = mkN "โคดีอีน" | mkN "ยาโคดีอีน" ; -- src=panlex
lin codex_N = mkN "หนังสือโบราณที่เขียนด้วยลายมือ" ; -- src=panlex
lin codfish_N = mkN "ปลาคอด" | mkN "เนื้อปลาคอด" ; -- src=panlex
lin codger_N = mkN "คนขี้เหนียว" | mkN "คนที่มีนิสัยแปลก" | mkN "คนแก่ที่ทําตัวแปลกๆ" ; -- src=panlex
lin codicil_N = mkN "ภาคผนวก" | mkN "ส่วนต่อท้าย" | mkN "บันทึกเพิ่มเติมของพินัยกรรม" ; -- src=panlex
lin codification_N = mkN "กฎระเบียบ" | mkN "กฏระเบียบ" | mkN "ประมวล" | mkN "การประมวล" | mkN "การรวบรวม" | mkN "การเรียบเรียง" | mkN "การจัดระเบียบหมวดหมู่กฎหมายหรือกฎเกณฑ์ต่างๆ" ; -- src=panlex
lin codling_N = mkN "ปลาคอดลิง" | mkN "ลูกปลาคอดฟิช" | mkN "ลูกปลาคอด" ; -- src=panlex
lin codon_N = mkN "โคดอน" ; -- src=panlex
lin coeducation_N = mkN "สหศึกษา" | mkN "สหศึกษา" ; -- src=panlex
lin coefficient_N = mkN "สัมประสิทธิ์" | mkN "ค่าสัมประสิทธิ์" | mkN "ค่าสัมประสิทธิ์" | mkN "จํานวนจริงที่มีค่าคงที่ซึ่งคูณอยู่กับตัวแปร" ; -- src=panlex
lin coelacanth_N = mkN "ปลาซีลาแคนท์" | mkN "ปลาโบราณที่สูญพันธุ์" ; -- src=panlex
lin coeliac_A = mkA "เกี่ยวกับโพรงหรือช่องท้อง" ; -- src=panlex
lin coelophysis_N = mkN "โคโลไฟซิส" ; -- src=panlex
lin coenzyme_N = mkN "โคเอนไซม์" ; -- src=panlex
lin coequal_A = mkA "ที่เท่ากัน" ; -- src=panlex
lin coercion_N = mkN "การใช้กำลัง" | mkN "การบีบบังคับ" | mkN "การบังคับ" | mkN "การขู่เข็ญ" | mkN "การบีบบังคับ" ; -- src=panlex
lin coercive_A = mkA "ที่บีบบังคับ" | mkA "เกี่ยวกับการบีบบังคับ" ; -- src=panlex
lin coeval_A = mkA "ยุคเดียวกัน" | mkA "ที่เกิดขึ้นในช่วงเวลาเดียวกัน" ; -- src=panlex
lin coeval_N = mkN "คนรุ่นเดียวกัน" ; -- src=panlex
lin co_exist_V = mkV "อยู่ร่วมกัน" | mkV "อยู่ร่วมกันอย่างสันติ" | mkV "อยู่ด้วยกัน" | mkV "อยู่ร่วมกัน" | mkV "อยู่ในสมัยเดียวกัน" | mkV "อยู่ร่วมกันอย่างสงบ" ; -- src=panlex
lin coexistence_N = mkN "การอยู่รวมกัน" ; -- src=panlex
lin cofactor_N = mkN "โคแฟคเตอร์" | mkN "ปัจจัยร่วม" | mkN "ปัจจัยที่เกิดร่วม" ; -- src=panlex
lin coffee_N = mkN (thword "กา" "แฟ") ;
lin coffeeberry_N = mkN "ต้นคอฟฟี่เบอร์รี่" ; -- src=panlex
lin coffeecake_N = mkN "เค้กกาแฟ" ; -- src=panlex
lin coffeepot_N = mkN "หม้อต้มกาแฟ" | mkN "หม้อกาแฟ" ; -- src=panlex
lin coffer_N = mkN "หีบของมีค่า" | mkN "กระเบื้องประดับเพดาน" | mkN "กําปั่น" | mkN "หีบเงิน" | mkN "หีบสมบัติ" | mkN "หีบใส่เงิน" | mkN "กล่องใส่ของมีค่า" ; -- src=panlex
lin coffin_N = mkN "โกศ" | mkN "โลง" | mkN "หีบศพ" | mkN "โลงผี" | mkN "โลงศพ" | mkN "พระโกศ" | mkN "หีบพระศพ" | mkN "หีบศพ" | mkN "โลงศพ" ; -- src=panlex
lin cofounder_N = mkN "ผู้ร่วมก่อตั้ง" | mkN "ผู้ร่วมก่อตั้ง" ; -- src=panlex
lin cog_N = mkN "ฟันเฟือง" | mkN "ซี่ล้อ" | mkN "ฟันเฟือง" | mkN "เดือยไม้" | mkN "เดือยตัวผู้" | mkN "คนผู้น้อยในหน่วยงานใหญ่" ; -- src=panlex
lin cogency_N = mkN "ความน่าเชื่อถือ" | mkN "การชักจูง" | mkN "การโน้มน้าว" | mkN "ความน่าเชื่อ" | mkN "การโน้มน้าวจิตใจ" ; -- src=panlex
lin cogent_A = mkA "ถูกจุด" | mkA "น่าเชื่อ" | mkA "ที่ชักจูง" | mkA "ที่ชักชวน" | mkA "ตรงประเด็น" | mkA "ที่โน้มน้าวจิตใจ" | mkA "ซึ่งโน้มน้าวจิตใจ" ; -- src=panlex
lin cogitate_V = mkV "คิด" | mkV "ใช้หัว" | mkV "ใช้สมอง" | mkV "ใช้ความคิด" | mkV "พินิจพิเคราะห์" | mkV "ขบคิด" | mkV "พิจารณา" | mkV "ใคร่ครวญ" | mkV "ไตร่ตรอง" | mkV "พินิจพิเคราะห์" | mkV "พิจารณาอย่างรอบคอบ" ; -- src=panlex
lin cogitate_V2 = mkV2 "คิด" ; ---- | mkV "ใช้หัว" | mkV "ใช้สมอง" | mkV "ใช้ความคิด" | mkV "พินิจพิเคราะห์" | mkV "ขบคิด" | mkV "พิจารณา" | mkV "ใคร่ครวญ" | mkV "ไตร่ตรอง" | mkV "พินิจพิเคราะห์" | mkV "พิจารณาอย่างรอบคอบ" ; -- src=panlex
lin cogitation_N = mkN "แผนงาน" | mkN "โครงการ" | mkN "การรับรู้" | mkN "การพิจารณา" | mkN "สิ่งที่ถูกรับรู้" ; -- src=panlex
lin cogitative_A = mkA "ซึ่งรับรู้" | mkA "ซึ่งพิจารณา" | mkA "ซึ่งไตร่ตรอง" | mkA "ที่สามารถคิดได้ลึกซึ้ง" ; -- src=panlex
lin cognac_N = mkN "ชื่อเหล้าบรั่นดีจากฝรั่งเศส" ; -- src=panlex
lin cognate_A = mkA "สัมพัทธ์" | mkA "ภาษาตระกูลเดียวกัน" | mkA "ซึ่งมาจากภาษาเดียวกัน" | mkA "ซึ่งมีบรรพบุรุษเดียวกัน" | mkA "ซึ่งมาจากบรรพบุรุษเดียวกัน" | mkA "ซึ่งสัมพันธ์กันทางสายเลือด" | mkA "เกี่ยวกับการกําเนิดเดียวกัน" ; -- src=panlex
lin cognate_N = mkN "คำร่วมเชื้อสาย" | mkN "ผู้ร่วมสายโลหิต" | mkN "คําที่มาจากรากศัพท์เดียวกัน" | mkN "คนหรือสิ่งของที่มาจากต้นกําเนิดเดียวกัน" ; -- src=panlex
lin cognition_N = mkN "ความรู้" | mkN "การรับรู้" | mkN "กระบวนการรับรู้ สิ่งที่เข้าใจหรือรู้" | mkN "ความรู้ความเข้าใจ" ; -- src=panlex
lin cognitive_A = mkA "ที่เกี่ยวกับกระบวนการคิด" | mkA "เกี่ยวกับกระบวนการการรับรู้" ; -- src=panlex
lin cognizance_N = mkN "ความมีสติ" | mkN "ความตระหนัก" | mkN "ความตระหนักรู้" | mkN "การยอมรับ" | mkN "การรับรู้" | mkN "การสังเกต" | mkN "วงความรู้" | mkN "อํานาจศาล" | mkN "คําสั่งศาล" | mkN "การตระหนักรู้" | mkN "ความรู้ความเข้าใจ" | mkN "ขอบข่ายของการสังเกต" | mkN "อํานาจการพิจารณาคดี" ; -- src=panlex
lin cognizant_A = mkA "สำเหนียก" | mkA "ตะหนักถึง" | mkA "ซึ่งรับรู้" | mkA "ซึ่งรู้ถึง" | mkA "ที่ตระหนักรู้" | mkA "ซึ่งมีพิจารณญาณ" ; -- src=panlex
lin cognomen_N = mkN "นามสกุล" | mkN "ชื่อสกุล" | mkN "ชื่อเล่น" | mkN "ชื่อ" | mkN "ชื่อสกุล" ; -- src=panlex
lin cogwheel_N = mkN "ล้อเฟือง" | mkN "ล้อเฟือง" ; -- src=panlex
lin cohabit_V = mkV "อยู่กิน" | mkV "อยู่ด้วยกัน" | mkV "อยู่กินกันโดยไม่ได้แต่งงานกัน" ; -- src=panlex
lin cohabitation_N = mkN "การอยู่กินฉันสามีภรรยา" ; -- src=panlex
lin cohere_V = mkV "ติด" | mkV "แนบ" | mkV "หล่อมรวมเข้าด้วยกัน" | mkV "อยู่ติดกัน" | mkV "สอดคล้องกัน" | mkV "กลมกลืนกันได้" ; -- src=panlex
lin coherence_N = mkN "การเชื่อมโยงกัน" | mkN "การเกาะเกี่ยวกัน" | mkN "การเกาะกัน" | mkN "การเกาะติด" | mkN "การเกี่ยวพัน" | mkN "การเชื่อมโยง" | mkN "ความสอดคล้อง" | mkN "การอยู่ติดกัน" | mkN "ความสัมพันธ์เกี่ยวเนื่องกันของส่วนต่างๆ" ; -- src=panlex
lin coherency_N = mkN "การเชื่อมโยงกัน" | mkN "การเกาะเกี่ยวกัน" | mkN "ความสัมพันธ์เกี่ยวเนื่องกันของส่วนต่างๆ" ; -- src=panlex
lin coherent_A = mkA "ซึ่งติดกัน" | mkA "ติดแน่น" | mkA "มีเหตุผล" | mkA "เกาะติดกัน" | mkA "สอดคล้องกัน" | mkA "ซึ่งมีเหตุผล" | mkA "ซึ่งสอดคล้อง" | mkA "เชื่อมโยงกัน" | mkA "เกี่ยวข้องกัน" | mkA "ซึ่งเกาะติดกันแน่น" | mkA "ซึ่งเห็นพ้องตรงกัน" | mkA "ไม่ขัดแย้งในตัวเอง" ; -- src=panlex
lin cohesion_N = mkN "การเชื่อมติด" | mkN "การเชื่อมแน่น" | mkN "การเชื่อมโยงกัน" | mkN "การเกาะเกี่ยวกัน" | mkN "การร่วมกัน" | mkN "การเกาะกัน" | mkN "การเกาะติด" | mkN "การประสานกัน" | mkN "การสอดคล้องกัน" | mkN "การทํางานร่วมกัน" ; -- src=panlex
lin cohesive_A = mkA "ซึ่งทำให้ติดกัน" | mkA "ซึ่งยึดติด" | mkA "ซึ่งติดเกาะ" | mkA "ซึ่งเกาะกัน" | mkA "ที่ติดอยู่ด้วยกัน" | mkA "เกี่ยวกับโมเลกุลที่ยึดเกาะของสาร" ; -- src=panlex
lin cohesiveness_N = mkN "ความเหนียว" | mkN "การเชื่อมโยงกัน" | mkN "การเกาะเกี่ยวกัน" | mkN "ความเหนียวเหนอะหนะ" ; -- src=panlex
lin coho_N = mkN "ปลาโคโฮแซลมอน" | mkN "ปลาซิลเวอร์แซลมอน" | mkN "เนื้อปลาซิลเวอร์แซลมอน" ; -- src=panlex
lin cohort_N = mkN "กลุ่มอายุ" | mkN "กลุ่มนักรบ" | mkN "เพื่อนร่วมงาน" | mkN "คนร่วมกลุ่มอายุ" | mkN "หมู่" | mkN "กลุ่ม" | mkN "เพื่อน" | mkN "กลุ่มทหาร" | mkN "ผู้ติดตาม" | mkN "กลุ่มนักรบ" | mkN "ผู้ร่วมงาน" | mkN "เพื่อนร่วมงาน" ; -- src=panlex
lin coif_N = mkN "หมวก" | mkN "ทรงผม" | mkN "แฮร์สไตล์" | mkN "การจัดแต่งทรงผม" | mkN "หมวกชนิดหนึ่งที่ใส่แนบกับศีรษะ" ; -- src=panlex
lin coiffeur_N = mkN "ช่างแต่งผมบุรุษ" | mkN "ช่างแต่งผมที่ป็นผู้ชาย" | mkN "ช่างแต่งผมที่เป็นผู้ชาย" ; -- src=panlex
lin coiffeuse_N = mkN "ช่างแต่งผมสตรี" ; -- src=panlex
lin coiffure_N = mkN "ทรงผม" | mkN "แฮร์สไตล์" | mkN "การจัดแต่งทรงผม" | mkN "ทรงผม" ; -- src=panlex
lin coil_N = mkN "คอยด์" | mkN "คอยล์" | mkN "ความหยิก" | mkN "เกลียวสว่าน" | mkN "ความลําบาก" | mkN "ความยุ่งยาก" | mkN "ขดลวดเหนี่ยวนํา" | mkN "ความวุ่นวายเอะอะ" | mkN "สิ่งที่เป็นม้วนหรือขด" | mkN "ขดลวดซึ่งกระแสไฟไหลผ่าน" ; -- src=panlex
lin coil_V = mkV "ขด" | mkV "ทำกับมือ" | mkV "หมุนเวียน" | mkV "ม้วน" | mkV "ขดเป็นวง" | mkV "ทําให้ขด" | mkV "ทําให้ม้วน" | mkV "ทําให้เป็นม้วนหรือขด" ; -- src=panlex
lin coil_V2 = mkV2 "ขด" ; ---- | mkV "ทำกับมือ" | mkV "หมุนเวียน" | mkV "ม้วน" | mkV "ขดเป็นวง" | mkV "ทําให้ขด" | mkV "ทําให้ม้วน" | mkV "ทําให้เป็นม้วนหรือขด" ; -- src=panlex
lin coin_N = mkN "เหรียญ" | mkN "เงินเหรียญ" | mkN "เหรียญ" | mkN "เหรียญกษาปน์" ; -- src=panlex
lin coinage_N = mkN "เงินโลหะ" | mkN "การประดิษฐ์ถ้อยคำ" | mkN "ศัพท์ใหม่" | mkN "เงินเหรียญ" | mkN "การสร้างคํา" | mkN "การผลิตเหรียญ" | mkN "ระบบเงินเหรียญ" | mkN "การบัญญัติศัพท์" | mkN "ระบบเหรียญกษาปณ์" | mkN "การคิดคําขึ้นใหม่" | mkN "การทําเหรียญกษาปณ์" | mkN "คําที่สร้างขึ้นเอง" | mkN "คําที่คิดค้นขึ้นเอง" | mkN "สิ่งที่ประดิษฐ์หรือสร้างขึ้น" | mkN "ชนิดแบบหรือจํานวนเหรียญกษาปณ์" ; -- src=panlex
lin coincide_V = mkV "ตรงกัน" | mkV "สอดคล้องกัน" | mkV "เดินทางไปกับ" | mkV "เกิดขึ้นในเวลาเดียวกัน" | mkV "ตรงกัน" | mkV "ต้องกัน" | mkV "เหมือนกัน" ; -- src=panlex
lin coincidence_N = mkN "การพ้องกัน" | mkN "เหตุบังเอิญ" | mkN "การเกิดพร้อมกัน" | mkN "เหตุการณ์ประจวบกัน" | mkN "การเกิดขึ้นพร้อมกัน" | mkN "ภาวะบังเอิญ" | mkN "เหตุบังเอิญ" | mkN "ภาวะประจวบกัน" | mkN "เหตุการณ์บังเอิญ" | mkN "การสอดคล้องต้องกัน" | mkN "การเกิดขึ้นพร้อมกัน" ; -- src=panlex
lin coincident_A = mkA "ต้องกัน" | mkA "บังเอิญ" | mkA "พ้องกัน" | mkA "ประจวบกัน" | mkA "สอดคล้องกัน" | mkA "ซึ่งเกิดขึ้นพร้อมกัน" ; -- src=panlex
lin coincidental_A = mkA "บังเอิญ" | mkA "พ้องกัน" | mkA "พร้อมกัน" | mkA "ประจวบกัน" | mkA "ซึ่งเกิดขึ้นพร้อมกัน" ; -- src=panlex
lin coiner_N = mkN "ผู้ประดิษฐ์คำ" | mkN "คนทำเหรียญปลอม" | mkN "ผู้สร้างคำใหม่" | mkN "ช่างทำเงินเหรียญ" ; -- src=panlex
lin coir_N = mkN "กาบมะพร้าว" | mkN "ใยเปลือกมะพร้าว" ; -- src=panlex
lin coition_N = mkN "กามกิจ" | mkN "การร่วมเพศ" | mkN "การเสพเมถุน" | mkN "การเสพสังวาส" | mkN "การร่วมประเวณี" | mkN "การมีเพศสัมพันธ์" | mkN "การสังวาส" | mkN "การร่วมประเวณี" | mkN "การมีเพศสัมพันธ์" ; -- src=panlex
lin coitus_N = mkN "กามกิจ" | mkN "การร่วมเพศ" | mkN "การเสพเมถุน" | mkN "การเสพสังวาส" | mkN "การร่วมประเวณี" | mkN "การมีเพศสัมพันธ์" | mkN "การสังวาส" | mkN "การร่วมประเวณี" | mkN "การมีเพศสัมพันธ์" ; -- src=panlex
lin coke_N = mkN "โค้ก" | mkN "สโนว์" | mkN "ถ่านโค้ก" | mkN "ถ่านโค้ก" | mkN "ถ่านหินที่เผาจนหมดควัน" ; -- src=panlex
lin col_N = mkN "ช่องเขา" | mkN "ช่องเขา" | mkN "ช่องเทือกเขา" | mkN "แอ่งของเทือกเขา" | mkN "ทางหรือแอ่งของเทือกเขา" | mkN "บริเวณที่มีความกดอากาศต่ํา" ; -- src=panlex
lin cola_N = mkN "โดป" | mkN "โคล่า" | mkN "เครื่องดื่มโคลา" | mkN "น้ําโคล่า" | mkN "เครื่องดื่มชนิดหนึ่งมีรสหวาน" ; -- src=panlex
lin colander_N = mkN "กระชอน" | mkN "กระชอน" | mkN "ตะแกรง" | mkN "หม้อกรอง" | mkN "ภาชนะกรอง" | mkN "ภาชนะสําหรับทําให้อาหารสะเด็ดน้ํา" ; -- src=panlex
lin colchicine_N = mkN "คอลชิซีน" | mkN "ยาคอลชิซีน" ; -- src=panlex
lin cold_A = mkA (thword "หนาว") | {-pan-} mkA "หนาว" | mkA "เย็น" | mkA "เย็นชา" | mkA "หนาว" | mkA "เซ็ง" | mkA "เย็น" | mkA "เฉยเมย" | mkA "เย็นชา" | mkA "หนาวจัด" | mkA "ไม่แยแส" | mkA "เยือกเย็น" | mkA "เย็นยะเยือก" | mkA "ไร้ความรู้สึก" ; -- src=panlex
lin cold_N = mkN "หวัด" | mkN "ไข้หวัด" | mkN "ความหนาว" | mkN "ความเย็น" | mkN "อุณหภูมิต่ำ" | mkN "ตาย" | mkN "หนาว" | mkN "หวัด" | mkN "อ่อน" | mkN "เย็น" | mkN "เฉยเมย" | mkN "เย็นชา" | mkN "แน่ชัด" | mkN "ครบถ้วน" | mkN "โรคหวัด" | mkN "ไข้หวัด" | mkN "ไม่แยแส" | mkN "ความหนาว" | mkN "ความเย็น" | mkN "ไร้อารมณ์" | mkN "ความหนาวเย็น" | mkN "อุณหภูมิใต้ศูนย์องศา" ; -- src=panlex
lin cold_hearted_A = mkA "ที่ไม่เห็นใจ" | mkA "ที่ใจไม่รู้สึกรู้สา" ; -- src=panlex
lin coldness_N = mkN "ความหนาว" | mkN "ความเย็น" | mkN "ความเย็นชา" | mkN "อุณหภูมิต่ำ" | mkN "ความหนาว" | mkN "ความเย็น" | mkN "ความเฉยเมย" | mkN "ความเย็นชา" | mkN "ความหนาวเย็น" | mkN "ความเยือกเย็น" ; -- src=panlex
lin coleslaw_N = mkN "สลักกะหล่ำปลี" | mkN "สลัดกะหล่ำปลี" | mkN "สลัดกะหล่ําปลีหั่นใส่มายองเนส" ; -- src=panlex
lin colic_N = mkN "อาการเสียดท้อง" | mkN "อาการเสียดท้อง" ; -- src=panlex
lin colicroot_N = mkN "ต้นหญ้าดาว" ; -- src=panlex
lin coliphage_N = mkN "โคเลอเฟจ" ; -- src=panlex
lin collaborate_V = mkV "ร่วมงาน" | mkV "ร่วมมือ" | mkV "เป็นไส้ศึก" | mkV "สมคบกับศัตรู" | mkV "ทํางานร่วมกัน" ; -- src=panlex
lin collaboration_N = mkN "การร่วมมือกัน" | mkN "การเป็นไส้ศึก" | mkN "การร่วมมือ" | mkN "การร่วมมือกัน" | mkN "การเป็นไส้ศึก" | mkN "การสมรู้ร่วมคิด" | mkN "ผลิตผลของการร่วมมือกัน" ; -- src=panlex
lin collaborationist_N = mkN "คนทรยศ" | mkN "ไส้ศึก" ; -- src=panlex
lin collaborator_N = mkN "คนทรยศ" | mkN "ไส้ศึก" | mkN "ผู้ช่วย" | mkN "ผู้ติดตาม" | mkN "ผู้ร่วมงาน" ; -- src=panlex
lin collage_N = mkN "รูปภาพปะซ้อน" | mkN "ภาพปะติดปะต่อ" | mkN "ศิลปการสร้างภาพจากชิ้นส่วนเล็กๆ ที่นํามาปะติดปะต่อกัน" | mkN "เทคนิคการปะติดปะต่อเศษชิ้นวัตถุต่าง ๆ" ; -- src=panlex
lin collagen_N = mkN "คอลลาเจน" | mkN "คอลลาเจน" | mkN "สารที่พบในข้อต่อ" ; -- src=panlex
lin collagenase_N = mkN "เอนไซม์คอลลาจิเนส" ; -- src=panlex
lin collapse_N = mkN "การพัง" | mkN "การยุบ" | mkN "การล้ม" | mkN "การพังทลาย" | mkN "การล้มละลาย" | mkN "การพังทลาย" | mkN "การล้มป่วย" | mkN "ความล้มเหลว" ; -- src=panlex
lin collapse_V = mkV "หุบ" | mkV "ถล่ม" | mkV "ทรุด" | mkV "ทลาย" | mkV "ยุบตัว" | mkV "พังทลาย" | mkV "หมดสภาพ" | mkV "ทำให้แตก" | mkV "ทำให้ระเบิด" | mkV "ทนทุกข์จากการไร้ความรู้สึก" | mkV "พับ" | mkV "ทรุด" | mkV "ยุบลง" | mkV "พับได้" | mkV "พังครืน" | mkV "พังทลาย" | mkV "ล้มเจ็บ" | mkV "ล้มเหลว" | mkV "ทําให้ยุบลง" | mkV "หมดแรงล้มลง" | mkV "ทําให้พังครืน" | mkV "ทําให้พังทลาย" ; -- src=panlex
lin collapse_V2 = mkV2 "หุบ" ; ---- | mkV "ถล่ม" | mkV "ทรุด" | mkV "ทลาย" | mkV "ยุบตัว" | mkV "พังทลาย" | mkV "หมดสภาพ" | mkV "ทำให้แตก" | mkV "ทำให้ระเบิด" | mkV "ทนทุกข์จากการไร้ความรู้สึก" | mkV "พับ" | mkV "ทรุด" | mkV "ยุบลง" | mkV "พับได้" | mkV "พังครืน" | mkV "พังทลาย" | mkV "ล้มเจ็บ" | mkV "ล้มเหลว" | mkV "ทําให้ยุบลง" | mkV "หมดแรงล้มลง" | mkV "ทําให้พังครืน" | mkV "ทําให้พังทลาย" ; -- src=panlex
lin collar_N = mkN "ปก" | mkN "คอปก" | mkN "ปลอกคอ" | mkN "ปกเสื้อ" | mkN "การจับกุม" | mkN "ปากรองเท้า" | mkN "การลากคอเข้าคุก" | mkN "คอ" | mkN "ปก" | mkN "แอก" | mkN "ปลอกคอ" | mkN "คอเสื้อ" | mkN "ปกเสื้อ" | mkN "วงแหวนของเสา" | mkN "สิ่งที่คล้ายวงแหวน" | mkN "แถบหนังหรือโลหะที่ยึดรอบคอสัตว์" ; -- src=panlex
lin collarbone_N = mkN "ไหปลาร้า" | mkN "พระรากขวัญ" | mkN "กระดูกไหปลาร้า" | mkN "ไหปลาร้า" | mkN "กระดูกไหปลาร้า" ; -- src=panlex
lin collard_N = mkN "ต้นคอลลาร์ด" ; -- src=panlex
lin collateral_A = mkA "ห่าง ๆ" | mkA "ที่สอง" | mkA "ประกอบ" | mkA "สังกัด" | mkA "ขนานกัน" | mkA "เคียงข้าง" | mkA "เพิ่มเติม" | mkA "โดยทางอ้อม" | mkA "ไม่ใกล้ชิด" | mkA "เทียบเคียงกัน" | mkA "เป็นส่วนเสริม" ; -- src=panlex
lin collateral_N = mkN "การประกัน" ; -- src=panlex
lin collation_N = mkN "ของว่าง" | mkN "อาหารว่าง" | mkN "ของกินเล่น" | mkN "ของขบเคี้ยว" | mkN "อาหารว่าง" | mkN "การตรวจเทียบ" | mkN "ผลของการเทียบกัน" | mkN "การอ่านเรื่องนักบุญให้ฟังกัน" ; -- src=panlex
lin colleague_N = mkN "สมาชิก" | mkN "เพื่อนร่วมงาน" | mkN "คนระดับเดียวกัน" | mkN "ผู้ร่วมงาน" | mkN "เพื่อนร่วมงาน" ; -- src=panlex
lin collect_A = mkA "ซึ่งเก็บเงินปลายทาง" ; -- src=panlex
lin collect_Adv = mkAdv "โดยเก็บเงินปลายทาง" | mkAdv "โดยให้ผู้รับเป็นคนจ่ายเงิน" ; -- src=panlex
lin collect_N = mkN "คําสวดแบบย่อๆ" | mkN "คําสวดแบบสั้นๆ" | mkN "คําอธิษฐานแบบสั้นๆ" ; -- src=panlex
lin collect_V = mkV "สะสม" | mkV "รวบรวม" | mkV "รวบรวมเงิน" | mkV "ค่อยๆ เพิ่มขึ้น" | mkV "คุมสติ" | mkV "รวบรวม" | mkV "ไปนํามา" | mkV "ไปเอามา" | mkV "เก็บเงิน" | mkV "เพิ่มพูน" | mkV "รวบรวมสติ" | mkV "ไปพาตัวมา" | mkV "เก็บรวบรวม" | mkV "เก็บค่าเช่า" | mkV "เรี่ยไรเงิน" | mkV "ขอเงินเพื่อการกุศล" ; -- src=panlex
lin collect_V2 = mkV2 "สะสม" ; ---- | mkV "รวบรวม" | mkV "รวบรวมเงิน" | mkV "ค่อยๆ เพิ่มขึ้น" | mkV "คุมสติ" | mkV "รวบรวม" | mkV "ไปนํามา" | mkV "ไปเอามา" | mkV "เก็บเงิน" | mkV "เพิ่มพูน" | mkV "รวบรวมสติ" | mkV "ไปพาตัวมา" | mkV "เก็บรวบรวม" | mkV "เก็บค่าเช่า" | mkV "เรี่ยไรเงิน" | mkV "ขอเงินเพื่อการกุศล" ; -- src=panlex
lin collectedly_Adv = mkAdv "อย่างสุขุม" ; -- src=panlex
lin collectible_A = mkA "ซึ่งใช้ชำระเงินได้" | mkA "ซึ่งพอจะเก็บได้" | mkA "ซึ่งพอจะรวบรวมได้" | mkA "ที่สามารถรวบรวมได้" ; -- src=panlex
lin collectible_N = mkN "สิ่งที่สามารถรวบรวมได้" ; -- src=panlex
lin collection_N = mkN "ชุด" | mkN "การรวบรวม" | mkN "การรวมกัน" | mkN "ของที่สะสม" | mkN "คอลเลคชั่น" | mkN "การรวมกลุ่ม" | mkN "สิ่งที่รวมไว้" | mkN "การร้องขอยอดเงิน" | mkN "การสะสม" | mkN "ของสะสม" | mkN "เงินสะสม" | mkN "การชุมนุม" | mkN "การรวบรวม" | mkN "การรวมกัน" | mkN "การจัดเก็บ" | mkN "เงินบริจาค" | mkN "การรวมกลุ่ม" | mkN "การเก็บเงิน" | mkN "เงินเรี่ยไร" | mkN "การเรียกเก็บ" | mkN "การเก็บรวบรวม" | mkN "การเรี่ยไรเงิน" | mkN "สิ่งที่สะสมไว้" | mkN "การขอบริจาคเงิน" | mkN "เงินที่เรี่ยไรมา" | mkN "สิ่งของที่รวบรวมไว้" | mkN "งานศิลปะในพิพิธภัณฑ์" | mkN "สิ่งที่เก็บรวบรวมไว้" | mkN "สิ่งของที่นํามากองรวมกันไว้" | mkN "การรวมตัวกันเป็นกลุ่มเป็นกอง" ; -- src=panlex
lin collective_A = mkA "ก้อน" | mkA "กลุ่ม" | mkA "ส่วนรวม" | mkA "โดยส่วนรวม" | mkA "ซึ่งเป็นกอง" | mkA "ซึ่งเป็นกลุ่ม" | mkA "ซึ่งรวมกันเป็นหมู่" | mkA "ที่มีส่วนร่วมโดยทุกคน" ; -- src=panlex
lin collective_N = mkN "กอง" | mkN "กลุ่ม" | mkN "หมู่คณะ" ; -- src=panlex
lin collectivism_N = mkN "คติรวมหมู่" | mkN "ลัทธิกรรมสิทธิร่วมกัน" ; -- src=panlex
lin collectivist_N = mkN "ฝ่ายซ้าย" | mkN "พวกปีกซ้าย" ; -- src=panlex
lin collector_N = mkN "นักสะสม" | mkN "ผู้เก็บเงิน" | mkN "พนักงานจัดเก็บภาษี" | mkN "อุปกรณ์เก็บกระแสไฟฟ้า" | mkN "คนสะสม" | mkN "คนเก็บ" | mkN "นักสะสม" | mkN "ผู้เก็บ" | mkN "อุปกรณ์รวมตัว" | mkN "สิ่งหรือเครื่องมือเก็บ" ; -- src=panlex
lin colleen_N = mkN "คอลีน" | mkN "ผู้หญิงไอริช" ; -- src=panlex
lin college_N = mkN "คณะ" | mkN "วิทยาลัย" | mkN "อาคารเรียนรวม" | mkN "วิทยาลัย" | mkN "สมาคมหรือบริษัท" | mkN "โรงเรียนเฉพาะสาขาวิชา" ; -- src=panlex
lin collegial_A = mkA "ที่เกี่ยวกับนักศึกษา" | mkA "นักศึกษาของมหาวิทยาลัย" | mkA "เกี่ยวกับวิทยาลัยหรือมหาวิทยาลัย" ; -- src=panlex
lin collegian_N = mkN "นักศึกษาวิทยาลัย" | mkN "นักเรียนวิทยาลัย" | mkN "นิสิตมหาวิทยาลัย" | mkN "นักศึกษาของวิทยาลัย" ; -- src=panlex
lin collegiate_A = mkA "เกี่ยวกับวิทยาลัย" ; -- src=panlex
lin collet_N = mkN "ปลอกรัดหัวเหล็ก" | mkN "ปลอกคอ" | mkN "แถบหุ้มรอบ" ; -- src=panlex
lin collide_V = mkV "ชน" | mkV "ชนกัน" | mkV "ตัดกันรุนแรง" | mkV "ชนกัน" | mkV "ปะทะกัน" | mkV "ประสานงา" | mkV "ขัดแย้งกัน" | mkV "เป็นปรปักษ์" ; -- src=panlex
lin collider_N = mkN "เครื่องชนอนุภาค" ; -- src=panlex
lin collie_N = mkN "สุนัขพันธุ์คอลลี่" ; -- src=panlex
lin collier_N = mkN "กรรมกรขุดถ่านหิน" | mkN "คนงานเหมืองถ่านหิน" | mkN "กรรมกรเหมืองถ่านหิน" | mkN "คนขายถ่านหิน" | mkN "คนขุดถ่านหิน" | mkN "คนงานถ่านหิน" | mkN "เรือขนถ่านหิน" | mkN "เรือบรรทุกถ่านหิน" ; -- src=panlex
lin colliery_N = mkN "เหมืองถ่านหิน" | mkN "เหมืองถ่านหิน" ; -- src=panlex
lin colligation_N = mkN "การเชื่อมต่อ" ; -- src=panlex
lin collimator_N = mkN "คอลลิเมเตอร์" ; -- src=panlex
lin collins_N = mkN "เหล้าคอลลินส์" | mkN "เหล้าผลไม้" ; -- src=panlex
lin collision_N = mkN "การชน" | mkN "การชนกัน" | mkN "การชนกัน" | mkN "การขัดแย้ง" | mkN "การปะทะกัน" | mkN "การประสานงา" | mkN "การปะทะกันโครม" ; -- src=panlex
lin collocate_V = mkV "จัดวาง" | mkV "ปรากฏร่วมกัน" ; -- src=panlex
lin collocation_N = mkN "คำปรากฏร่วมเฉพาะ" | mkN "การเกิดร่วมกัน" | mkN "การวางเข้าด้วยกันให้เหมาะ" ; -- src=panlex
lin collodion_N = mkN "คอลโลเดียน" | mkN "สารละลายคอลโลเดียน" ; -- src=panlex
lin colloid_N = mkN "คอลลอยด์" | mkN "คอลลอยด์" | mkN "สารคล้ายกาว" | mkN "สารที่ละลายในของเหลว" ; -- src=panlex
lin colloquial_A = mkA "ที่เป็นภาษาพูด" | mkA "ไม่เป็นทางการ" | mkA "ซึ่งเป็นภาษาพูด" | mkA "เกี่ยวกับการสนทนา" ; -- src=panlex
lin colloquialism_N = mkN "คําสนทนา" | mkN "คําธรรมดา ๆ" | mkN "คําพูดที่เคยชิน" | mkN "คําหรือวลีที่ใช้ในการพูดที่ไม่เป็นทางการ" ; -- src=panlex
lin colloquium_N = mkN "การสัมมนา" | mkN "การสัมมนา" | mkN "การอภิปรายกลุ่ม" ; -- src=panlex
lin colloquy_N = mkN "บทประพันธ์สนทนา" | mkN "การสนทนาแลกเปลี่ยน" ; -- src=panlex
lin collusion_N = mkN "การสมรู้ร่วมคิด" | mkN "การรวมหัวกันคิดอุบาย" ; -- src=panlex
lin colobus_N = mkN "ลิงโคโลบัส" ; -- src=panlex
lin cologne_N = mkN "โคโลญ" | mkN "โคโลญ์น" | mkN "น้ำหอมโอดิโคโลญ" | mkN "น้ําหอม" | mkN "โคโลญจ์" | mkN "น้ําหอมประเภทโคโลญจ์" | mkN "น้ําหอมที่ใช้ในห้องน้ํา" ; -- src=panlex
lin colon_N = mkN "โคลอน" | mkN "ปลายลำไส้ใหญ่" | mkN "คอสตาริกันโคลอน" | mkN "เครื่องหมายโคลอน" | mkN "เอลซาวาดอรันโคลอน" | mkN "ลําไส้ใหญ่" | mkN "เครื่องหมาย" ; -- src=panlex
lin colonel_N = mkN "พ.อ." | mkN "พันเอก" | mkN "นายพัน" | mkN "พันเอก" | mkN "นาวาเอก" ; -- src=panlex
lin colonial_A = mkA "เกี่ยวกับอาณานิคม" ; -- src=panlex
lin colonial_N = mkN "ชาวอาณานิคม" | mkN "ผู้อยู่อาศัยในอาณานิคม" ; -- src=panlex
lin colonialism_N = mkN "การล่าอาณานิคม" | mkN "การล่าเมืองขึ้น" ; -- src=panlex
lin colonialist_N = mkN "ผู้ศรัทธาในลัทธิล่าอาณานิคม" ; -- src=panlex
lin colonic_A = mkA "เี่กี่ยวกับปลายลำไส้ใหญ่" ; -- src=panlex
lin colonist_N = mkN "ผู้อพยพ" | mkN "ชาวอาณานิคม" | mkN "ผู้ตั้งรกราก" | mkN "ผู้ที่ไปอาศัยในอาณานิคม" ; -- src=panlex
lin colonization_N = mkN "การก่อตั้งอาณานิคม" ; -- src=panlex
lin colonnade_N = mkN "ทางเดินที่มีหลังคาโค้ง" | mkN "แถวต้นไม้" | mkN "แนวต้นไม้" | mkN "แนวเสาหิน" | mkN "แถวเสาระเบียง" | mkN "แนวเสาระเบียง" ; -- src=panlex
lin colonoscope_N = mkN "โคโลโนสโคป" ; -- src=panlex
lin colony_N = mkN "ฝูงสัตว์" | mkN "อาณานิคม" | mkN "เมืองขึ้น" | mkN "กลุ่มสิ่งมีชีวิต" | mkN "พวก" | mkN "หมู่" | mkN "กลุ่ม" | mkN "เหล่า" | mkN "อาณานิคม" | mkN "ประเทศราช" | mkN "เมืองขึ้น" | mkN "ประเทศอาณานิคม" | mkN "กลุ่มคนในอาณานิคม" | mkN "ประชาชนในอาณานิคม" ; -- src=panlex
lin colophon_N = mkN "ตราสัญลักษณ์ของผู้จัดพิมพ์" ; -- src=panlex
lin colophony_N = mkN "ชันสน" ; -- src=panlex
lin coloration_N = mkN "การใช้สี" | mkN "เสียงดนตรี" | mkN "การเลือกใช้สี" | mkN "การใช้สี" ; -- src=panlex
lin coloratura_N = mkN "การร้องเพลงอย่างไพเราะ" | mkN "นักร้องโคโลราทูราโซปราโน" | mkN "่การร้องเพลงด้วยเสียงอันไพเราะ" ; -- src=panlex
lin colorfast_A = mkA "มีสีทนทาน" | mkA "ที่มีสีทนนาน" | mkA "ติดสีย้อมได้ดี" ; -- src=panlex
lin colorimeter_N = mkN "มาตรเทียบสี" | mkN "การเปรียบเทียบสี" ; -- src=panlex
lin colorist_N = mkN "ศิลปินคัลเลอริตส์" ; -- src=panlex
lin colorlessness_N = mkN "ความไม่มีสี" ; -- src=panlex
lin colossal_A = mkA "ใหญ่" | mkA "มหึมา" | mkA "มหาศาล" | mkA "ใหญ่โต" ; -- src=panlex
lin colossus_N = mkN "ยักษ์" | mkN "รุ่นใหญ่" | mkN "บุคคลสำคัญ" | mkN "ยักษ์มหึมา" | mkN "ผู้ยิ่งใหญ่" | mkN "มนุษย์ยักษ์" | mkN "สิ่งที่ใหญ่โต มหึมาหรือมีอํานาจมาก" | mkN "รูปปั้นที่ใหญ่มหึมา" | mkN "สิ่งที่มีความสําคัญมาก" | mkN "สิ่งที่ใหญ่โตหรือมีอํานาจมาก" ; -- src=panlex
lin colostrum_N = mkN "นมยกแรก" | mkN "โคลอสตรัม" | mkN "น้ำนมน้ำเหลือง" ; -- src=panlex
lin colour_A = mkA "สี" ; -- src=panlex
lin colour_N = mkN "สี" | mkN "สีสัน" | mkN "เสียงดนตรี" | mkN "ความมีสีสัน" | mkN "กลุ่มคนผิวสี" | mkN "วัตถุที่ให้สี" | mkN "ธง" | mkN "สี" | mkN "สารสี" | mkN "สีสัน" | mkN "สีย้อม" | mkN "เม็ดสี" | mkN "ข้ออ้าง" | mkN "ความสดใส" | mkN "รงควัตถุ" | mkN "คุณลักษณะ" | mkN "สีสันต่างๆ" | mkN "ความมีสีสัน" | mkN "คุณภาพเสียง" | mkN "คํากล่าวอ้าง" | mkN "ลักษณะภายนอก" | mkN "ศิลปะการใช้สี" | mkN "ความมีชีวิตชีวา" | mkN "คุณภาพที่เด่นชัด" | mkN "ใบหน้ามีเลือดฝาด" | mkN "สีผิวที่มีสุขภาพดี" | mkN "สีผิวของชนที่ไม่ใช่คนผิวขาว" | mkN "ใบหน้าที่มีสีแดงเพราะสุขภาพดี" ; -- src=panlex
lin colour_V = mkV "ลงสี" | mkV "สีตก" | mkV "ประดับ" | mkV "แก้ตัว" | mkV "ระบายสี" | mkV "มีผลกระทบ" | mkV "เปลี่ยนสี" | mkV "เป็นสีสัน" | mkV "ทำให้เกิดสี" | mkV "ประดับด้วยสี" | mkV "ทาสี" | mkV "ย้อมสี" | mkV "ระบายสี" | mkV "หน้าแดง" | mkV "เปลี่ยนสี" ; -- src=panlex
lin colour_V2 = mkV2 "ลงสี" ; ---- | mkV "สีตก" | mkV "ประดับ" | mkV "แก้ตัว" | mkV "ระบายสี" | mkV "มีผลกระทบ" | mkV "เปลี่ยนสี" | mkV "เป็นสีสัน" | mkV "ทำให้เกิดสี" | mkV "ประดับด้วยสี" | mkV "ทาสี" | mkV "ย้อมสี" | mkV "ระบายสี" | mkV "หน้าแดง" | mkV "เปลี่ยนสี" ; -- src=panlex
lin colour_V2A = mmkV2A "ลงสี" ; ---- | mkV "สีตก" | mkV "ประดับ" | mkV "แก้ตัว" | mkV "ระบายสี" | mkV "มีผลกระทบ" | mkV "เปลี่ยนสี" | mkV "เป็นสีสัน" | mkV "ทำให้เกิดสี" | mkV "ประดับด้วยสี" | mkV "ทาสี" | mkV "ย้อมสี" | mkV "ระบายสี" | mkV "หน้าแดง" | mkV "เปลี่ยนสี" ; -- src=panlex
lin coloured_A = mkA "ที่มีสี" | mkA "ที่ถูกย้อม" | mkA "ที่มีผิวสี" | mkA "ที่ย้อมขึ้น" | mkA "ลวง" | mkA "มีสี" | mkA "มีอคติ" | mkA "ต่อแต้ม" | mkA "ที่มีสี" | mkA "มีใจโอนเอียง" | mkA "เกี่ยวกับชนชาตินิโกร" | mkA "ของกลุ่มที่ไม่ใช่ชนผิวขาว" | mkA "เกี่ยวกับชนชาติที่สีผิวหนังไม่เป็นสีขาว" ; -- src=panlex
lin colourful_A = mkA "ซึ่งมีสีสัน" | mkA "มีสี" | mkA "ฉูดฉาด" | mkA "ตรึงใจ" | mkA "หลากสี" | mkA "พอฟังได้" | mkA "มีรสชาติ" | mkA "มีเสน่ห์" | mkA "สนุกสนาน" | mkA "มีสีสรรมาก" | mkA "น่าตื่นเต้น" | mkA "มีชีวิตชีวา" | mkA "มีสีสันสดใส" ; -- src=panlex
lin colouring_N = mkN "สี" | mkN "การทำสี" | mkN "สีผสมอาหาร" | mkN "การเปลี่ยนสี" | mkN "โฉมภายนอก" | mkN "สีผสมอาหาร" | mkN "สีผิวหรือสีผม" | mkN "การปรากฎเป็นสี" | mkN "การใส่หรือทาสี" | mkN "สีหน้าสารย้อมสี" | mkN "กระบวนการเปลี่ยนสี" | mkN "วิธีการใส่หรือทาสี" ; -- src=panlex
lin colourless_A = mkA "ไร้สี" | mkA "ซึ่งขาดสีสัน" | mkA "ที่ไม่มีสี" ; -- src=panlex
lin colpitis_N = mkN "ช่องคลอดอักเสบ" ; -- src=panlex
lin colpocele_N = mkN "ไส้เลื่อนลงช่องคลอด" ; -- src=panlex
lin colt_N = mkN "ลูกม้าตัวผู้" | mkN "ลูกม้าเพศผู้" | mkN "คนอ่อนหัด" | mkN "เด็กหนุ่ม" | mkN "ลูกม้าตัวผู้" | mkN "คนหนุ่มที่ไม่มีประสบการณ์" | mkN "ลูกม้าตัวผู้อายุไม่เกิน 4 ปี" ; -- src=panlex
lin colter_N = mkN "ผาล" ; -- src=panlex
lin coltish_A = mkA "ลูกม้าหรือลา" ; -- src=panlex
lin coltsfoot_N = mkN "โคล์ตส์ฟุต" | mkN "ต้นโคลส์ฟุต" ; -- src=panlex
lin columbarium_N = mkN "บ้านนกพิราบ" ; -- src=panlex
lin columbine_N = mkN "ดอกโคลัมไบน์" | mkN "ต้นโคลัมไบน์" ; -- src=panlex
lin columbium_N = mkN "โคลัมเบียม" ; -- src=panlex
lin columbo_N = mkN "ต้นโคลัมโบ" ; -- src=panlex
lin columella_N = mkN "แกนเปลือก" | mkN "แกน" | mkN "ส่วนที่เป็นลําเล็ก ๆ" ; -- src=panlex
lin column_N = mkN "เสา" | mkN "เสาค้ำ" | mkN "คอลัมน์" | mkN "แนวขบวนทหาร" | mkN "รูปทรงยาวบาง" | mkN "รูปร่างเหมือนเสา" | mkN "คอลัมน์หนังสือพิมพ์" | mkN "โครมาโทกราฟีแบบคอลัมน์" | mkN "เสา" | mkN "เสาค้ํา" | mkN "กองย่อยๆ" | mkN "แนวขบวนทหาร" | mkN "คอลัมน์ในหนังสือพิมพ์" | mkN "กองทหารที่ตั้งแถวตามยาว" | mkN "ขบวนเรือรบที่เป็นแนวตามยาว" | mkN "แถวหรือรายการที่เป็นแนวตรง" ; -- src=panlex
lin columnar_A = mkA "มีลักษณะเป็นลําเสา" | mkA "ซึ่งพิมพ์หรือจัดเป็นแนวตรง" ; -- src=panlex
lin columniation_N = variants {} ;
lin columnistFem_N = variants {} ; ---- sense to be split
lin columnistMasc_N = variants {} ; ---- sense to be split
lin coma_N = mkN "อาการหมดสติที่ยาวนาน" | mkN "สภาพไม่รู้สึกตัวของผู้ป่วย" | mkN "กลุ่มเมฆล้อมรอบส่วนหัวของดาวหาง" ; -- src=panlex
lin comatose_A = mkA "สลบ" | mkA "โคม่า" | mkA "หมดสติ" | mkA "ไร้พลัง" | mkA "เฉื่อยชา" | mkA "เซื่องซึม" | mkA "ไม่รู้สึกตัว" | mkA "ขาดความว่องไว" | mkA "ไร้การตอบสนอง" | mkA "ที่อยู่ในสภาพไม่รู้สึกตัว" ; -- src=panlex
lin comb_N = mkN "หวี" | mkN "หงอน" | mkN "พระสาง" | mkN "การสางผม" | mkN "การหวีผม" | mkN "เครื่องสางเส้นใย" | mkN "หวี" | mkN "แปรง" | mkN "รวงผึ้ง" | mkN "หงอนไก่" | mkN "เครื่องมือแยกเส้นใย" ; -- src=panlex
lin comb_V = mkV "หวี" | mkV "สะสาง" | mkV "สืบทั่ว" | mkV "ค้นหาทุกซอกทุกมุม" | mkV "ค้นหาอย่างละเอียด" | mkV "ทําความสะอาดหรือแยกเส้นใย" ; -- src=panlex
lin comb_V2 = mkV2 "หวี" ; ---- | mkV "สะสาง" | mkV "สืบทั่ว" | mkV "ค้นหาทุกซอกทุกมุม" | mkV "ค้นหาอย่างละเอียด" | mkV "ทําความสะอาดหรือแยกเส้นใย" ; -- src=panlex
lin combat_N = mkN "การต่อสู้" | mkN "การสู้รบตบมือ" | mkN "การสู้รบ" | mkN "การต่อสู้" | mkN "ความขัดแย้ง" | mkN "การประจัญบาน" ; -- src=panlex
lin combat_V = mkV "รบ" | mkV "สู้รบ" | mkV "รบ" | mkV "สู้" | mkV "สู้รบ" | mkV "ต่อสู้" | mkV "ต่อต้าน" ; -- src=panlex
lin combat_V2 = mkV2 "รบ" ; ---- | mkV "สู้รบ" | mkV "รบ" | mkV "สู้" | mkV "สู้รบ" | mkV "ต่อสู้" | mkV "ต่อต้าน" ; -- src=panlex
lin combatant_A = mkA "ชอบต่อสู้" | mkA "ที่พร้อมต่อสู้" ; -- src=panlex
lin combatant_N = mkN "นักสู้" | mkN "นักรบ" | mkN "นักสู้" | mkN "ผู้ต่อสู้" | mkN "ผู้ทําการรบ" | mkN "คนที่เถียงกัน" | mkN "เกี่ยวกับการรบ" | mkN "คนที่โต้แย้งกัน" ; -- src=panlex
lin combative_A = mkA "ชอบรบ" | mkA "พร้อมรบ" | mkA "ชอบต่อสู้" | mkA "ที่กระหายที่จะต่อสู้" ; -- src=panlex
lin combativeness_N = mkN "การรณรงค์เชิงรุก" ; -- src=panlex
lin comber_N = mkN "คนสางเส้นใย" | mkN "เกลียวคลื่น" | mkN "เครื่องสางเส้นใย" ; -- src=panlex
lin combination_N = mkN "การรวม" | mkN "กลุ่มคน" | mkN "การรวมกัน" | mkN "การจัดหมู่" | mkN "การประกอบขึ้นเป็นหน่วย" | mkN "กลุ่มคน" | mkN "พันธมิตร" | mkN "การผสมกัน" | mkN "การรวมกัน" | mkN "การผนึกกัน" | mkN "รหัสเปิดกุญแจ" | mkN "จํานวนสิ่งของที่รวมกัน" | mkN "สิ่งที่เกิดจากการรวมกัน" ; -- src=panlex
lin combine_N = mkN "ผลรวม" | mkN "กลุ่มบริษัท" | mkN "เครื่องนวดข้าว" | mkN "การร่วมกลุ่มบริษัท" | mkN "การรวมกัน" | mkN "การรวมกลุ่ม" | mkN "เครื่องจักรตัดและนวดเมล็ดข้าว" ; -- src=panlex
lin combine_V = mkV "ผสม" | mkV "มิกซ์" | mkV "รวบรวม" | mkV "การรวมกลุ่ม" | mkV "ผสมเข้าด้วยกัน" | mkV "รวมกัน" | mkV "้ประสานกัน" | mkV "นํามารวมกัน" | mkV "ทําให้รวมกัน" | mkV "นํามารวมเข้าด้วยกัน" | mkV "รวมเป็นอันหนึ่งอันเดียวกัน" ; -- src=panlex
lin combine_V2 = mkV2 "ผสม" ; ---- | mkV "มิกซ์" | mkV "รวบรวม" | mkV "การรวมกลุ่ม" | mkV "ผสมเข้าด้วยกัน" | mkV "รวมกัน" | mkV "้ประสานกัน" | mkV "นํามารวมกัน" | mkV "ทําให้รวมกัน" | mkV "นํามารวมเข้าด้วยกัน" | mkV "รวมเป็นอันหนึ่งอันเดียวกัน" ; -- src=panlex
lin combine_VV = mkVV "ผสม" ; ---- | mkV "มิกซ์" | mkV "รวบรวม" | mkV "การรวมกลุ่ม" | mkV "ผสมเข้าด้วยกัน" | mkV "รวมกัน" | mkV "้ประสานกัน" | mkV "นํามารวมกัน" | mkV "ทําให้รวมกัน" | mkV "นํามารวมเข้าด้วยกัน" | mkV "รวมเป็นอันหนึ่งอันเดียวกัน" ; -- src=panlex
lin combining_N = mkN "ผลรวม" | mkN "การรวม" | mkN "การประกอบขึ้นเป็นหน่วย" ; -- src=panlex
lin combo_N = mkN "วงดนตรีแจ๊ส" | mkN "วงดนตรีแจ๊สเล็กๆ" ; -- src=panlex
lin combustibility_N = mkN "การจุดไฟได้" ; -- src=panlex
lin combustible_A = mkA "ซึ่งติดไฟได้" | mkA "ที่ติดไฟได้ง่าย" ; -- src=panlex
lin combustion_N = mkN "การเผา" | mkN "การเผาไหม้" | mkN "ความวุ่นวาย" | mkN "กระบวนการเผาไหม้" | mkN "การสันดาป" | mkN "การลุกไหม้" | mkN "การเผาไหม้" | mkN "ความโกลาหล" | mkN "ความวุ่นวาย" | mkN "กระบวนการสันดาป" | mkN "กระบวนการเผาไหม้" | mkN "ความสับสนอลหม่าน" | mkN "ความอึกทึกครึกโครม" ; -- src=panlex
lin come_V = mkV (thword "มา") | {-pan-} mkV "มา" | mkV "ถึง" | mkV "รวม" | mkV "แวบ" | mkV "พัฒนา" | mkV "มาจาก" | mkV "มาถึง" | mkV "ออกมา" | mkV "เสร็จ" | mkV "คิดเป็น" | mkV "มีผลรวม" | mkV "เข้าสู่" | mkV "เกิดขึ้น" | mkV "ถัดมาเป็น" | mkV "ต้องมาก่อน" | mkV "อยู่ภายใต้" | mkV "ดำเนินต่อไป" | mkV "สืบเชื้อสาย" | mkV "ถึงจุดสุดยอด" | mkV "เป็นชาวพื้นเมือง" | mkV "มา" | mkV "เป็น" | mkV "ปรากฏ" | mkV "มาถึง" | mkV "มาแล้ว" | mkV "เกิดใน" | mkV "กลายเป็น" | mkV "เกิดขึ้น" ; -- src=panlex
lin come_about_V = advV OP_come_V OP_about_Adv ; -- guess-p-verb
lin come_across_V = advV OP_come_V OP_across_Adv ; -- guess-p-verb
lin come_across_V2 = prepV2 OP_come_V OP_across_Prep ; -- guess-p-verb
lin come_along_V = advV OP_come_V OP_along_Adv ; -- guess-p-verb
lin come_along_with_V2 = prepV2 (advV OP_come_V OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_apart_V = advV OP_come_V OP_apart_Adv ; -- guess-p-verb
lin come_around_V = advV OP_come_V OP_around_Adv ; -- guess-p-verb
lin come_around_to_V2 = prepV2 (advV OP_come_V OP_around_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_away_V = advV OP_come_V OP_away_Adv ; -- guess-p-verb
lin come_back_V = advV OP_come_V OP_back_Adv ; -- guess-p-verb
lin come_before_V2 = prepV2 OP_come_V OP_before_Prep ; -- guess-p-verb
lin come_by_V = advV OP_come_V OP_by_Adv ; -- guess-p-verb
lin come_by_V2 = prepV2 OP_come_V OP_by_Prep ; -- guess-p-verb
lin come_down_V = advV OP_come_V OP_down_Adv ; -- guess-p-verb
lin come_down_on_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin come_down_upon_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_upon_Prep ; -- guess-p-verb
lin come_down_with_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forth_V = advV OP_come_V OP_forth_Adv ; -- guess-p-verb
lin come_forth_with_V2 = prepV2 (advV OP_come_V OP_forth_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forward_V = advV OP_come_V OP_forward_Adv ; -- guess-p-verb
lin come_from_V2 = prepV2 OP_come_V OP_from_Prep ; -- guess-p-verb
lin come_in_V = advV OP_come_V OP_in_Adv ; -- guess-p-verb
lin come_in_V2 = prepV2 OP_come_V OP_in_Prep ; -- guess-p-verb
lin come_in_for_V2 = prepV2 (advV OP_come_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin come_into_V2 = prepV2 OP_come_V OP_into_Prep ; -- guess-p-verb
lin come_into_use_V = variants {} ; -- guess-p-verb
lin come_off_V = advV OP_come_V OP_off_Adv ; -- guess-p-verb
lin come_off_V2 = prepV2 OP_come_V OP_off_Prep ; -- guess-p-verb
lin come_off_it_V = variants {} ; -- guess-p-verb
lin come_on_V = advV OP_come_V OP_on_Adv ; -- guess-p-verb
lin come_out_V = advV OP_come_V OP_out_Adv ; -- guess-p-verb
lin come_out_in_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin come_out_of_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin come_out_with_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_over_V = advV OP_come_V OP_over_Adv ; -- guess-p-verb
lin come_over_V2 = prepV2 OP_come_V OP_over_Prep ; -- guess-p-verb
lin come_round_V = advV OP_come_V OP_round_Adv ; -- guess-p-verb
lin come_through_V = advV OP_come_V OP_through_Adv ; -- guess-p-verb
lin come_through_with_V2 = prepV2 (advV OP_come_V OP_through_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_to_V = advV OP_come_V OP_to_Adv ; -- guess-p-verb
lin come_to_V2 = prepV2 OP_come_V OP_to_Prep ; -- guess-p-verb
lin come_up_V = advV OP_come_V OP_up_Adv ; -- guess-p-verb
lin come_up_against_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_against_Prep ; -- guess-p-verb
lin come_up_to_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_up_with_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_upon_V2 = prepV2 OP_come_V OP_upon_Prep ; -- guess-p-verb
lin come_with_V2 = prepV2 OP_come_V OP_with_Prep ; -- guess-p-verb
lin comeback_N = mkN "คำโต้ตอบ" | mkN "การตอบโต้" | mkN "คำโต้แย้ง" | mkN "การตอบกลับ" | mkN "การกลับมาประสบความสำเร็จ" | mkN "การคืนชีพ" | mkN "การโต้ตอบทันควัน" | mkN "การพูดย้อนที่ฉลาด" | mkN "การกลับเข้าในวงการ" | mkN "การกลับมาสู่ความนิยมอีกครั้ง" | mkN "การกลับสู่ความสําเร็จอีกครั้ง" | mkN "การกลับสู่ตําแหน่งหรือฐานะเดิม" ; -- src=panlex
lin comedian_N = mkN "ดาวตลก" | mkN "ดาราตลก" | mkN "ศิลปินตลก" | mkN "นักแสดงตลก" | mkN "ตัวตลก" | mkN "ตัวละครตลก" | mkN "นักแสดงตลก" | mkN "ผู้ที่มีลักษณะตลก" ; -- src=panlex
lin comedic_A = mkA "ที่ตลกขบขัน" | mkA "เกี่ยวกับละครตลก" ; -- src=panlex
lin comedienne_N = mkN "ตัวตลกหญิง" | mkN "ดาราตลกหญิง" | mkN "ศิลปินตลกหญิง" | mkN "นักแสดงตลกหญิง" | mkN "ตัวตลกหญิง" | mkN "นักแสดงตลกหญิง" | mkN "นักแสดงละครตลกหญิง" ; -- src=panlex
lin comedown_N = mkN "การเสียหน้า" | mkN "การตกอับ" | mkN "การตกต่ํา" | mkN "การเสื่อมลงของฐานะ" ; -- src=panlex
lin comedy_N = mkN "หนังตลก" | mkN "เรื่องตลก" | mkN "ละครตลก" | mkN "ความขบขัน" | mkN "เรื่องตลก" | mkN "ฉากละครตลก" | mkN "ละครชวนหัว" | mkN "สุขนาฏกรรม" | mkN "หัสนาฏกรรม" | mkN "ความตลกขบขัน" ; -- src=panlex
lin comeliness_N = mkN "ความสะสวย" | mkN "ความน่ารัก" | mkN "ความสวยงาม" | mkN "ความสวย" | mkN "ความงดงาม" | mkN "ความน่ารัก" ; -- src=panlex
lin comely_A = mkA "สวย" | mkA "งดงาม" | mkA "น่ามอง" | mkA "น่ารัก" | mkA "สวยงาม" | mkA "เหมะสม" ; -- src=panlex
lin comer_N = mkN "ผู้มาถึง" | mkN "ผู้มีความหวัง" | mkN "ผู้ที่มา" | mkN "คนที่ไปได้ดี" | mkN "คนหรือสิ่งที่จะประสบความสําเร็จ" ; -- src=panlex
lin comestible_N = mkN "ของกินได้" | mkN "สิ่งหล่อเลี้ยง" | mkN "อาหาร" ; -- src=panlex
lin comet_N = mkN "ดาวหาง" | mkN "ดาวหาง" ; -- src=panlex
lin comfit_N = mkN "คอมฟิต" | mkN "ผลไม้เคลือบน้ําตาล" ; -- src=panlex
lin comfort_N = mkN "ความสบาย" | mkN "การปลอบใจ" | mkN "ความสะดวกสบาย" | mkN "การเปิดทางสะดวก" | mkN "ความรู้สึกสบายๆ" | mkN "ความสบาย" | mkN "คําปลอบใจ" | mkN "ความสบายใจ" | mkN "สิ่งปลอบใจ" | mkN "ความสบายกาย" | mkN "ความสุขสบาย" | mkN "ความอบอุ่นใจ" | mkN "ความรู้สึกสบาย" | mkN "เครื่องบรรเทาทุกข์" | mkN "คนหรือสิ่งอํานวยความสะดวก" ; -- src=panlex
lin comfortable_A = mkA "เพียงพอ" | mkA "มั่งคั่ง" | mkA "อบอุ่นใจ" | mkA "สะดวกสบาย" | mkA "สบาย" | mkA "ผาสุก" | mkA "สุขใจ" | mkA "สุขกาย" | mkA "กว้างพอ" | mkA "พอเพียง" | mkA "ร่ํารวย" | mkA "มั่งคั่ง" | mkA "อบอุ่นใจ" | mkA "กว้างขวาง" | mkA "กว้างใหญ่" | mkA "มีเงินมาก" | mkA "สะดวกสบาย" | mkA "สุขสบายใจ" | mkA "มีอันจะกิน" ; -- src=panlex
lin comfortableness_N = mkN "ความสบาย" ; -- src=panlex
lin comforter_N = mkN "หัวนมปลอม" | mkN "ผู้ปลอบโยน" | mkN "ผู้ที่ช่วยปลอบโยน" ; -- src=panlex
lin comforting_A = mkA "ซึ่งปลอบใจ" | mkA "ซึ่งปลอบโยน" | mkA "ที่สะดวกสบาย" | mkA "ให้ความสุขสบาย" ; -- src=panlex
lin comfortless_A = mkA "ที่ไม่สะดวกสบาย" ; -- src=panlex
lin comfrey_N = mkN "คอมเฟรย์" ; -- src=panlex
lin comfy_A = mkA "สะดวกสบาย" ; -- src=panlex
lin comic_A = mkA "ตลก" | mkA "ชวนหัว" | mkA "น่าขัน" | mkA "ตลกขบขัน" | mkA "น่าหัวเราะ" | mkA "เกี่ยวกับละครตลก" | mkA "เกี่ยวกับเรื่องตลก" | mkA "เกี่ยวกับสุขนาฏกรรม" | mkA "เกี่ยวกับหัสนาฏกรรม" ; -- src=panlex
lin comic_N = mkN "ศิลปินตลก" | mkN "นักแสดงตลก" | mkN "ตัวตลก" | mkN "ตัวละครตลก" | mkN "หนังสือการ์ตูน" ; -- src=panlex
lin comical_A = mkA "ตลก" | mkA "ตลก" | mkA "ขบขัน" | mkA "ชวนหัว" | mkA "น่าขัน" | mkA "ตลกขบขัน" | mkA "น่าหัวเราะ" ; -- src=panlex
lin coming_A = mkA "ที่ใกล้มาถึง" | mkA "ที่กำลังจะถึง" | mkA "ที่กําลังจะมาถึง" | mkA "ซึ่งใกล้จะสําเร็จ" | mkA "ซึ่งมีหวังจะสําเร็จ" ; -- src=panlex
lin coming_N = mkN "การดูด" | mkN "การมาถึง" | mkN "การเข้าใกล้" | mkN "การถึงจุดสุดยอด" | mkN "การมาถึง การปรากฏ" | mkN "การมาถึง" | mkN "ซึ่งมีหวังสําเร็จ" ; -- src=panlex
lin comity_N = mkN "ความสุภาพ" | mkN "ความสุภาพ" ; -- src=panlex
lin comma_N = mkN "คอมม่า" | mkN "ผีเสื้อธรรมดา" | mkN "เครื่องหมายคอมม่า" | mkN "เครื่องหมายจุลภาค" | mkN "เครื่องหมาย" | mkN "เครื่องหมายคอมม่า" | mkN "เครื่องหมายจุลภาค ใช้คั่นประโยคหรือคํา" | mkN "การหยุดพักชั่วคราว" | mkN "เครื่องหมายลูกน้ํา" | mkN "เครื่องหมายที่ใช้เพื่อแยกส่วนของประโยค" ; -- src=panlex
lin command_1_N = variants {} ; ---- sense to be split
lin command_2_N = variants {} ; ---- sense to be split
lin command_V = mkV "สั่ง" | mkV "ควบคุม" | mkV "คอนโทรล" | mkV "สั่งการ" | mkV "เรียกร้อง" | mkV "มองลงไปเห็น" | mkV "ควบคุม" | mkV "สั่งการ" | mkV "บัญชาการ" | mkV "ออกคําสั่ง" | mkV "บังคับบัญชา" | mkV "มีอํานาจเหนือ" ; -- src=panlex
lin command_V2 = mkV2 "สั่ง" ; ---- | mkV "ควบคุม" | mkV "คอนโทรล" | mkV "สั่งการ" | mkV "เรียกร้อง" | mkV "มองลงไปเห็น" | mkV "ควบคุม" | mkV "สั่งการ" | mkV "บัญชาการ" | mkV "ออกคําสั่ง" | mkV "บังคับบัญชา" | mkV "มีอํานาจเหนือ" ; -- src=panlex
lin commandant_N = mkN "ผู้บัญชาการ" | mkN "เจ้าหน้าที่หน่วยทหาร" | mkN "ผู้บัญชาการ" | mkN "ผู้บังคับบัญชา" ; -- src=panlex
lin commander_N = mkN "น.ท." | mkN "นาวาโท" | mkN "ผู้บัญชาการ" | mkN "ผู้บังคับบัญชา" | mkN "เจ้าหน้าที่หน่วยทหาร" | mkN "เจ้าหน้าที่บนเครื่องบิน" | mkN "นาวาโท" | mkN "ผู้นํา" | mkN "หัวหน้า" | mkN "นาวิกโยธิน" | mkN "ผู้สั่งการ" | mkN "ผู้บัญชาการ" | mkN "ผู้ออกคําสั่ง" | mkN "ทหารเรือฝ่ายบก" | mkN "ผู้บังคับบัญชา" | mkN "นายทหารผู้บังคับบัญชา" ; -- src=panlex
lin commandership_N = mkN "ตำแหน่งผู้บังคับบัญชา" ; -- src=panlex
lin commandment_N = mkN "คำสอน" | mkN "อํานาจ" | mkN "คําสั่ง" | mkN "บัญญัติ" | mkN "การออกคําสั่ง" | mkN "หนึ่งในบัญญัติ10ประการ" ; -- src=panlex
lin commando_N = mkN "คอมมานโด" | mkN "หน่วยคอมมานโด" | mkN "กองกำลังคอมมานโด" | mkN "สมาชิกหน่วยคอมมานโด" | mkN "หน่วยจู่โจม" | mkN "หน่วยคอมมานโด" | mkN "หน่วยรบเฉพาะกิจ" | mkN "สมาชิกหน่วนคอมมานโด" | mkN "สมาชิกของหน่วยจู่โจม" | mkN "สมาชิกของหน่วยรบเฉพาะกิจ" | mkN "หน่วยจู่โจมที่ได้รับการฝึกเป็นพิเศษ" ; -- src=panlex
lin commelina_N = mkN "พืชสกุลคอมมีลินา" ; -- src=panlex
lin commemoration_N = mkN "การฉลอง" | mkN "การระลึก" | mkN "ที่ระลึก" | mkN "พิธีฉลอง" | mkN "การระลึกถึง" | mkN "สิ่งที่เป็นอนุสรณ์" ; -- src=panlex
lin commemorative_A = mkA "ที่เป็นการระลึกถึง" ; -- src=panlex
lin commemorative_N = mkN "เหรียญตรา" ; -- src=panlex
lin commence_V = mkV "เริ่ม" | mkV "เริ่มต้น" | mkV "ขึ้นต้น" | mkV "ตั้งต้น" | mkV "เริ่มต้น" ; -- src=panlex
lin commence_V2 = mkV2 "เริ่ม" ; ---- | mkV "เริ่มต้น" | mkV "ขึ้นต้น" | mkV "ตั้งต้น" | mkV "เริ่มต้น" ; -- src=panlex
lin commencement_N = mkN "ยุคแรก" | mkN "ครั้งแรก" | mkN "การเปิดฉาก" | mkN "การเริ่มต้น" | mkN "ช่วงเริ่มต้น" | mkN "พิธีรับปริญญา" | mkN "พิธีมอบปริญญาบัตร" | mkN "พิธีประสาทปริญญาบัตร" | mkN "พิธีพระราชทานปริญญาบัตร" | mkN "การเริ่ม" | mkN "การเริ่มต้น" | mkN "วันรับปริญญา" | mkN "พิธีรับปริญญา" | mkN "การพบปะของผู้สําเร็จการศึกษา" ; -- src=panlex
lin commendable_A = mkA "ที่สมควรยกย่อง" | mkA "ที่ควรยกย่อง" ; -- src=panlex
lin commendation_N = mkN "ฉันทามติ" | mkN "การยกย่อง" | mkN "ความเห็นชอบ" | mkN "ความเห็นพ้อง" | mkN "การมอบ" | mkN "การฝากฝัง" | mkN "การยกย่อง" | mkN "การแนะนํา" | mkN "การสรรเสริญ" | mkN "สิ่งที่สรรเสริญ" ; -- src=panlex
lin commensal_A = mkA "ที่อยู่แบบพึ่งพาอาศัยกัน" ; -- src=panlex
lin commensalism_N = mkN "ภาวะอิงอาศัย" ; -- src=panlex
lin commensurable_A = mkA "เหมาะสม" | mkA "ซึ่งพอจะวัดกันได้" | mkA "ที่วัดจากมาตรฐานเดียวกัน" | mkA "ซึ่งพอจะถือเป็นเกณฑ์เดียวกันได้" ; -- src=panlex
lin commensurate_A = mkA "พอเพียง" | mkA "ซึ่งเทียบเท่า" | mkA "ที่มีขนาดเท่ากัน" | mkA "ซึ่งได้สัดส่วนกับ" ; -- src=panlex
lin comment_N = mkN "คำบรรยาย" | mkN "คำอธิบาย" | mkN "ข้อคิดเห็น" | mkN "เรื่องนินทา" | mkN "เรื่องซุบซิบ" | mkN "ข้อคิดเห็น" ; -- src=panlex
lin comment_V = mkV "ติชม" | mkV "คอมเมนต์" | mkV "คอมเม็นต์" | mkV "มีข้อติชม" | mkV "ตั้งข้อสังเกต" | mkV "เขียนคำอธิบาย" | mkV "แสดงความคิดเห็น" | mkV "แสดงความคิดเห็น" ; -- src=panlex
lin comment_V2 = mkV2 "ติชม" ; ---- | mkV "คอมเมนต์" | mkV "คอมเม็นต์" | mkV "มีข้อติชม" | mkV "ตั้งข้อสังเกต" | mkV "เขียนคำอธิบาย" | mkV "แสดงความคิดเห็น" | mkV "แสดงความคิดเห็น" ; -- src=panlex
lin comment_VS = mmkVS "ติชม" ; ---- | mkV "คอมเมนต์" | mkV "คอมเม็นต์" | mkV "มีข้อติชม" | mkV "ตั้งข้อสังเกต" | mkV "เขียนคำอธิบาย" | mkV "แสดงความคิดเห็น" | mkV "แสดงความคิดเห็น" ; -- src=panlex
lin commentary_N = mkN "คำบรรยาย" | mkN "คำอธิบาย" | mkN "ข้อคิดเห็น" | mkN "คําวิจารณ์" | mkN "สิ่งที่ใช้อธิบาย" | mkN "บทความแสดงข้อคิดเห็น" ; -- src=panlex
lin commentate_V = mkV "ออกความเห็น" | mkV "ออกความเห็น" ; -- src=panlex
lin commentator_N = mkN "ผู้ให้ทัศนะ" | mkN "ผู้สังเกตการณ์" | mkN "ผู้เขียนเหตุการณ์" | mkN "นักเขียนวิเ่คราะห์เหตุการณ์" | mkN "ผู้อธิบาย" | mkN "ผู้วิจารณ์" | mkN "ผู้บรรยายข่าว" | mkN "ผู้ออกความเห็น" ; -- src=panlex
lin commerce_N = mkN "การค้า" | mkN "การพาณิชย์" | mkN "พาณิชยกรรม" | mkN "การค้า" | mkN "การพาณิชย์" | mkN "ธุรกิจการค้า" | mkN "การแลกเปลี่ยน" | mkN "การค้าขายสินค้า" | mkN "การติดต่อสัมพันธ์ในสังคม" ; -- src=panlex
lin commercial_A = mkA "เป็นการค้า" | mkA "เกี่ยวกับการค้า" | mkA "สําหรับนักธุรกิจ" | mkA "ไม่บริสุทธิเต็มที่" | mkA "ซึ่งมีจุดประสงค์เพื่อหวังกําไร" | mkA "ซึ่งมีจุดประสงค์เพื่อหวังกําไรได้" ; -- src=panlex
lin commercial_N = mkN "ผู้สนับสนุนรายการ" | mkN "โฆษณาทางโทรทัศน์หรือวิทยุ" ; -- src=panlex
lin commercialism_N = mkN "การค้า" | mkN "การพาณิชย์" | mkN "พาณิชยกรรม" | mkN "ลักษณะพ่อค้า" | mkN "หลักการหรือวิธีการพานิชย์" | mkN "ลัทธิการค้าเพื่อหวังผลกําไร" ; -- src=panlex
lin commercialization_N = mkN "การทำธุรกิจ" ; -- src=panlex
lin commination_N = mkN "การขู่" ; -- src=panlex
lin commingle_V = mkV "ผสม" | mkV "มิกซ์" | mkV "ผสมเข้าด้วยกัน" | mkV "ผสมผสาน" ; -- src=panlex
lin commingle_V2 = mkV2 "ผสม" ; ---- | mkV "มิกซ์" | mkV "ผสมเข้าด้วยกัน" | mkV "ผสมผสาน" ; -- src=panlex
lin commiserate_V = mkV "เห็นอกเห็นใจ" | mkV "ทําให้รู้สึกเศร้าเสียใจ" ; -- src=panlex
lin commiseration_N = mkN "ความสงสาร" | mkN "ความเห็นใจ" | mkN "ความเห็นอกเห็นใจ" | mkN "การแสดงความเสียใจ" | mkN "การรู้สึกเศร้าเสียใจ" ; -- src=panlex
lin commiserative_A = mkA "เกี่ยวกับการสงสาร" | mkA "ที่รู้สึกเศร้าเสียใจ" ; -- src=panlex
lin commissar_N = mkN "เจ้าหน้าที่พรรคคอมมิวนิสต์" | mkN "ผู้บังคับการตํารวจ" | mkN "นายทหารฝ่ายเกียกกาย" | mkN "ผู้ตรวจการในรัสเซีย" | mkN "หัวหน้าหน่วยงานของรัสเซีย" ; -- src=panlex
lin commissariat_N = mkN "เสบียงอาหาร" | mkN "กรมตํารวจ" | mkN "กองเสบียง" | mkN "กองเกียกกาย" | mkN "กองตรวจงานในรัสเซีย" ; -- src=panlex
lin commissary_N = mkN "ร้านสวัสดิการทหาร" | mkN "ร้านค้าสวัสดิการทหาร" | mkN "รองหัวหน้า" | mkN "ที่จ่ายเสบียง" | mkN "รองนายกเทศมนตรี" | mkN "รองอธิบดีตํารวจ" | mkN "ร้านขายอาหารและเสบียง" ; -- src=panlex
lin commission_N = mkN "งาน" | mkN "คำสั่ง" | mkN "ภารกิจ" | mkN "มิสชั่น" | mkN "ประจำการ" | mkN "คณะผู้แทน" | mkN "คณะกรรมการ" | mkN "กลุ่มผู้แทน" | mkN "การปฎิบัติการ" | mkN "การก่ออาชญากรรม" | mkN "ค่านายหน้า" | mkN "ค่าคอมมิชชั่น" | mkN "อํานาจที่จะทํา" | mkN "งานที่รับผิดชอบ" ; -- src=panlex
lin commissionaire_N = mkN "ผู้กระทําหน้าที่เล็ก ๆ น้อย ๆ" | mkN "ผู้ที่รับจ้างทํางานเล็กๆ น้อยๆ" ; -- src=panlex
lin commissioner_N = mkN "กรรมการ" | mkN "อธิบดี" | mkN "กรรมการ" | mkN "กรรมาธิการ" | mkN "หัวหน้ากรม" | mkN "ผู้ตรวจการณ์" | mkN "ผู้ได้รับมอบหมายอํานาจหน้าที่" ; -- src=panlex
lin commissure_N = mkN "ข้อต่อ" | mkN "ตะเข็บ" | mkN "ส่วนต่อ" | mkN "รอยประสาน" ; -- src=panlex
lin commitment_N = mkN "คำอุทิศ" | mkN "ความภักดี" | mkN "พันธะสัญญา" | mkN "ความซื่อสัตย์" | mkN "การส่งตัวไปจองจำ" | mkN "การมอบ" | mkN "การมอบหมาย" | mkN "ความรับผิดชอบ" ; -- src=panlex
lin committedness_N = mkN "ความภักดี" ; -- src=panlex
lin committee_N = mkN "คณะกรรมการ" | mkN "ผู้ปกครอง" | mkN "ผู้อนุบาล" | mkN "คณะกรรมการ" ; -- src=panlex
lin committeeman_N = mkN "สมาชิกคณะกรรมการชาย" | mkN "กรรมการ" | mkN "กรรมการ กรรมาธิการ" ; -- src=panlex
lin committeewoman_N = mkN "สมาชิกคณะกรรมการหญิง" ; -- src=panlex
lin commode_1_N = mkN "โถส้วม" | mkN "ตู้ลิ้นชัก" | mkN "ห้องสุขา" | mkN "ตู้ลิ้นชัก" | mkN "แท่นหรือตู้ที่มีอ่างหรือที่ล้างหน้า" ; -- src=panlex
lin commode_2_N = mkN "โถส้วม" | mkN "ตู้ลิ้นชัก" | mkN "ห้องสุขา" | mkN "ตู้ลิ้นชัก" | mkN "แท่นหรือตู้ที่มีอ่างหรือที่ล้างหน้า" ; -- src=panlex
lin commodious_A = mkA "กว้างขวาง" | mkA "กว้างขวาง" ; -- src=panlex
lin commodity_N = mkN "สินค้า" | mkN "ข้าวของ" | mkN "ของซื้อขาย" | mkN "ของซื้อของขาย" | mkN "ของใช้" | mkN "สินค้า" | mkN "ปริมาณ หรือจํานวนหนึ่งของสินค้า" | mkN "ของซื้อขาย" | mkN "ของใช้ประจํา" | mkN "ผลิตภัณฑ์เกษตรหรือเหมืองแร่" ; -- src=panlex
lin commodore_N = mkN "พล.ร.จ." | mkN "พลเรือจัตวา" | mkN "พลเรือจัตวา" | mkN "นาวาเอกพิเศษ" | mkN "ประธานหรือหัวหน้าสโมสรเล่นเรือ" | mkN "ผู้บังคับการขบวนเรือพาณิชย์ขนาดใหญ่" ; -- src=panlex
lin common_1_A = variants {} ; ---- sense to be split
lin common_2_A = variants {} ; ---- sense to be split
lin common_N = mkN "ทุ่ง" | mkN "ทุ่งหญ้า" ; -- src=panlex
lin commonality_N = mkN "สามัญชน" | mkN "คนทั่วไป" | mkN "กลุ่มคนสามัญ" | mkN "คนธรรมดาสามัญ" | mkN "คนธรรมดาสามัญ" ; -- src=panlex
lin commonalty_N = mkN "สามัญชน" | mkN "คนทั่วไป" | mkN "กลุ่มคนสามัญ" | mkN "คนธรรมดาสามัญ" | mkN "คนสามัญ" | mkN "ประชาชน" | mkN "สามัญชน" | mkN "หมู่คณะ" | mkN "คนธรรมดาสามัญ" ; -- src=panlex
lin commoner_N = mkN "สามัญชน" | mkN "สามัญชน" | mkN "นักศึกษา" | mkN "คนธรรมดาสามัญ" | mkN "สมาชิกสภาล่าง" ; -- src=panlex
lin commonplace_A = mkA "จำเจ" | mkA "จืดชืด" | mkA "น่าเบื่อ" | mkA "สามัญ" | mkA "ธรรมดา" | mkA "น่าเบื่อ" | mkA "ไม่น่าสนใจ" | mkA "สิ่งธรรมดา ๆ" | mkA "ที่เกิดขึ้นทุกวัน" ; -- src=panlex
lin commonplace_N = mkN "คำพูดซ้ำซาก" | mkN "สำนวนประดาษ" | mkN "สิ่งที่เห็นได้บ่อยๆ" | mkN "สิ่งที่เห็นได้ทั่วไป" ; -- src=panlex
lin commons_N = mkN "ทุ่ง" | mkN "สามัญชน" | mkN "คนทั่วไป" | mkN "ทุ่งหญ้า" | mkN "กลุ่มคนสามัญ" | mkN "คนธรรมดาสามัญ" ; -- src=panlex
lin commonwealth_N = mkN "รัฐ" | mkN "ชาติ" | mkN "ประเทศ" | mkN "รัฐชาติ" | mkN "เครือรัฐ" | mkN "รัฐเอกราช" | mkN "ประเทศชาติ" | mkN "ประชาธิปไตย" | mkN "เครือจักรภพ" | mkN "ระบอบประชาธิปไตย" | mkN "การรวมกัน" | mkN "เครือประเทศ" | mkN "ประชาชนของชาติ" | mkN "ประเทศหรือรัฐที่ปกครองตนเอง" ; -- src=panlex
lin commotion_N = mkN "การก่อกวน" | mkN "ความชุลมุน" | mkN "ความโกลาหล" | mkN "ความวุ่นวาย" | mkN "การเอะอะโวยวาย" | mkN "ความสับสนวุ่นวาย" | mkN "ความสับสนอลหม่าน" | mkN "ความจลาจล" | mkN "ความสับสนวุ่นวาย" | mkN "ความชุลมุนวุ่นวาย" ; -- src=panlex
lin communal_A = mkA "ในท้องถิ่น" | mkA "ซึ่งเป็นกลุ่ม" | mkA "เกี่ยวกับชุมชน" | mkA "เกี่ยวกับสหภาพ" | mkA "ที่เป็นของสาธารณะ" ; -- src=panlex
lin commune_N = mkN "ประชาคม" | mkN "คนที่อยู่ร่วมกันเป็นสังคมเดียวกัน" ; -- src=panlex
lin commune_V = mkV "ติดต่อสื่อสาร" | mkV "คุยกันอย่างสนิทสนม" | mkV "คุยกันอย่างสนิทสนม" ; -- src=panlex
lin communicable_A = mkA "ช่างพูด" | mkA "ซึ่งสามารถติดต่อกันได้" | mkA "ที่สามารถสื่อสารกันได้" ; -- src=panlex
lin communicant_N = mkN "ผู้ติดต่อ" | mkN "ผู้ส่งข่าว" ; -- src=panlex
lin communicate_V = mkV "ส่ง" | mkV "ติดต่อ" | mkV "สื่อสาร" | mkV "แพร่เชื้อ" | mkV "ติดต่อสื่อสาร" | mkV "ส่งต่อ" | mkV "ส่งผ่าน" | mkV "เชื่อมติดกัน" | mkV "ติดต่อสื่อสาร" ; -- src=panlex
lin communicate_V2 = mkV2 "ส่ง" ; ---- | mkV "ติดต่อ" | mkV "สื่อสาร" | mkV "แพร่เชื้อ" | mkV "ติดต่อสื่อสาร" | mkV "ส่งต่อ" | mkV "ส่งผ่าน" | mkV "เชื่อมติดกัน" | mkV "ติดต่อสื่อสาร" ; -- src=panlex
lin communication_N = mkN "การติดต่อ" | mkN "การสื่อสาร" | mkN "การติดต่อสื่อสาร" | mkN "สิ่งที่ใช้ติดต่อสื่อสาร" | mkN "การคมนาคม" | mkN "การติดต่อ" | mkN "การส่งต่อ" | mkN "การสื่อสาร" | mkN "การติดต่อสื่อสาร" | mkN "วิธีการติดต่อสื่อสาร" | mkN "ความสัมพันธ์ที่ใกล้ชิด" ; -- src=panlex
lin communications_N = mkN "นิเทศศาสตร์" | mkN "ทฤษฎีการสื่อสาร" ; -- src=panlex
lin communicative_A = mkA "ซึ่งติดต่อสื่อสาร" | mkA "ชอบถ่ายทอด" | mkA "เกี่ยวกับการติดต่อ" | mkA "เกี่ยวกับการสื่อสาร" | mkA "ที่เกี่ยวกับการสื่อสาร" ; -- src=panlex
lin communicativeness_N = mkN "การติดต่อสื่อสาร" ; -- src=panlex
lin communicator_N = mkN "ผู้สื่อสาร" | mkN "ผู้ถ่ายทอด" | mkN "ผู้ส่งข่าวสาร" | mkN "เครื่องมือสื่อสาร" ; -- src=panlex
lin communion_N = mkN "แบ่งปันความรู้สึก" | mkN "การร่วมกัน" | mkN "นิกายศาสนา" | mkN "การเข้าร่วม" | mkN "การรับอาหาร จากพระเจ้าในพิธีศีลมหาสนิท" | mkN "การมีส่วนร่วม" | mkN "การแลกเปลี่ยนข้อคิดเห็น" | mkN "กลุ่มคนที่มิเชื่อในศาสนาเหมือนกัน" ; -- src=panlex
lin communique_N = mkN "รายงานด่วน" | mkN "รายงานทางราชการ" | mkN "แถลงการณ์ทางราชการ" ; -- src=panlex
lin communism_N = mkN "สังคมนิยม" | mkN "คอมมิวนิสม์" | mkN "ลัทธิคอมมิวนิสม์" | mkN "คอมมิวนิสต์" | mkN "ลัทธิคอมมิวนิสต์" ; -- src=panlex
lin communist_N = mkN "คอมมิวนิสต์" | mkN "พวกคอมมิวนิสต์" | mkN "สมาชิกพรรคคอมมิวนิสต์" | mkN "ผู้นิยมลัทธิคอมมิวนิสต์" | mkN "สมาชิกของพรรคคอมมิวนิสต์" ; -- src=panlex
lin community_N = mkN "ชุมชน" | mkN "สังคม" | mkN "ชุมชีวิน" | mkN "ย่านอยู่อาศัย" | mkN "เขตที่อยู่อาศัย" | mkN "ความเป็นเจ้าของร่วม" | mkN "คณะ" | mkN "กลุ่ม" | mkN "ชุมชน" | mkN "สหคาม" | mkN "สังคม" | mkN "ลักษณะร่วม" | mkN "ลักษณะที่เหมือนกัน" ; -- src=panlex
lin communization_N = mkN "การโอนเป็นของรัฐ" | mkN "การทำให้เป็นของชุมชน" | mkN "การทำให้เป็นสมบัติสาธารณะ" | mkN "การเปลี่ยนให้เป็นของชุมชน" ; -- src=panlex
lin commutation_N = mkN "การเดินทางไปกลับ" | mkN "เงินชดเชย" | mkN "การสับเปลี่ยน" | mkN "การแลกเปลี่ยน" | mkN "การเปลี่ยนแทนกัน" | mkN "การเปลี่ยนกระแสไฟฟ้า" ; -- src=panlex
lin commutative_A = mkA "เกี่ยวกับการเปลี่ยนแปลง" | mkA "ที่เกี่ยวกับการสับเปลี่ยน" | mkA "ที่เปลี่ยนที่ได้โดยผลลัพธ์ไม่เปลี่ยนแปลง" ; -- src=panlex
lin commutator_N = mkN "คอมมิวเทเตอร์" | mkN "เครื่อง สับเปลี่ยน" | mkN "เครื่องแลกเปลี่ยน" | mkN "กลไกในการสับเปลี่ยนกระแสไฟฟ้า" | mkN "เครื่องเปลี่ยนทิศทางของกระแสไฟฟ้า" ; -- src=panlex
lin commute_N = mkN "การไปทำงาน" ; -- src=panlex
lin commute_V = mkV "สลับที่" | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "เสียค่าปรับ" | mkV "ชดเชย" | mkV "ทดแทน" | mkV "แลกเปลี่ยน" ; -- src=panlex
lin commute_V2 = mkV2 "สลับที่" ; ---- | mkV "เปลี่ยน" | mkV "แลกเปลี่ยน" | mkV "เสียค่าปรับ" | mkV "ชดเชย" | mkV "ทดแทน" | mkV "แลกเปลี่ยน" ; -- src=panlex
lin commuter_N = mkN "รถไฟโดยสาร" | mkN "คนทำงานในเมือง" ; -- src=panlex
lin compact_A = mkA "กะทัดรัด" | mkA "กระชับ" | mkA "ที่อัดแน่น" | mkA "ที่ใช้คําพูดน้อย" | mkA "ที่ใช้เนื้อที่น้อย" ; -- src=panlex
lin compact_N = mkN "สัญญา" | mkN "รถเล็ก" | mkN "ตลับแป้ง" | mkN "การทำสัญญา" | mkN "คอมแพ็คคาร์" | mkN "ตลับแป้ง" | mkN "รถยนต์เล็กๆ" ; -- src=panlex
lin compaction_N = mkN "การบีบ" | mkN "การอัด" | mkN "ความแน่น" | mkN "การบีบอัด" ; -- src=panlex
lin compactness_N = mkN "ความหนาแน่น" | mkN "ความกะทัดรัด" ; -- src=panlex
lin companion_N = mkN "เพื่อน" | mkN "คนคุ้นเคย" | mkN "ผู้ร่วมทาง" | mkN "เพื่อนร่วมทาง" | mkN "เพื่อนเดินทาง" | mkN "ผู้ร่วมเดินทาง" | mkN "เพื่อน" | mkN "เพื่อนเดินทาง" ; -- src=panlex
lin companionable_A = mkA "น่าคบ" | mkA "ที่เป็นเพื่อนได้ดี" | mkA "ซึ่งเป็นเพื่อนที่ดีได้" ; -- src=panlex
lin companionship_N = mkN "ความเป็นเพื่อน" | mkN "ความเป็นเพื่อน" ; -- src=panlex
lin companionway_N = mkN "บันไดดาดฟ้าเรือ" | mkN "บันไดขึ้นดาดฟ้าเรือ" ; -- src=panlex
lin company_1_N = variants {} ; ---- sense to be split
lin company_2_N = variants {} ; ---- sense to be split
lin comparability_N = mkN "การเปรียบเทียบ" | mkN "การเปรียบเทียบได้" ; -- src=panlex
lin comparable_A = mkA "เทียบเคียงได้" | mkA "พอเปรียบเทียบได้" | mkA "ซึ่งเปรียบเทียบกันได้" | mkA "ที่สามารถเปรียบเทียบกันได้" ; -- src=panlex
lin comparative_A = mkA "เทียบเคียง" | mkA "พอสมควร" | mkA "ซึ่งเทียบเคียง" | mkA "ที่เปรียบเทียบกัน" | mkA "เกี่ยวการเปรียบเทียบ" ; -- src=panlex
lin comparative_N = mkN "การเปรียบเทียบขั้นกว่า" ; -- src=panlex
lin compare_N = mkN "การเปรียบเทียบ" | mkN "การเปรียบเทียบได้" ; -- src=panlex
lin compare_V = mkV "เทียบ" | mkV "เปรียบ" | mkV "เปรียบเทียบ" | mkV "เปรียบเทียบขั้นกว่า" | mkV "เปรียบเทียบ" ; -- src=panlex
lin comparison_N = mkN "การเปรียบเทียบ" | mkN "การเปรียบเทียบได้" | mkN "การเปรียบเทียบ" | mkN "การเปรียบเทียบ ภาวะที่ถูกเปรียบเทียบ" ; -- src=panlex
lin compartment_N = mkN "ห้องย่อย" | mkN "ห้องเก็บข้อง" | mkN "ห้องที่กั้นขึ้น" | mkN "ตอน" | mkN "ช่อง" | mkN "ห้อง" | mkN "การแบ่ง" | mkN "ส่วนแยก" ; -- src=panlex
lin compartmentalization_N = mkN "การจัดกลุ่ม" | mkN "การจำแนกประเภท" ; -- src=panlex
lin compass_N = mkN "ขอบเขต" | mkN "วงเวียน" | mkN "เข็มทิศ" | mkN "ขอบ" | mkN "เส้นขอบ" ; -- src=panlex
lin compassion_N = mkN "ความสงสาร" | mkN "ความเห็นอกเห็นใจ" | mkN "ความสงสาร" | mkN "ความเวทนา" | mkN "ความเห็นใจ" | mkN "ความเห็นอกเห็นใจ" | mkN "ความรู้สึกเศร้าใจไปกับความทุกข์ของผู้อื่น" ; -- src=panlex
lin compassionate_A = mkA "เห็นอกเห็นใจ" | mkA "มีความสงสาร" | mkA "มีความเวทนา" | mkA "ที่รู้สึกเห็นใจ" | mkA "มีความเห็นอกเห็นใจ" | mkA "ที่รู้สึกเศร้าใจไปกับความทุกข์ของผู้อื่น" ; -- src=panlex
lin compatibility_N = mkN "ความเห็นใจ" | mkN "ความเข้ากันได้" ; -- src=panlex
lin compatible_A = mkA "ซึ่งเข้ากันได้" | mkA "ที่อยู่รวมกันได้" | mkA "ซึ่งอยู่ด้วยกันได้" | mkA "ที่ทํางานร่วมกันได้" ; -- src=panlex
lin compatriotFem_N = variants {} ; ---- sense to be split
lin compatriotMasc_N = variants {} ; ---- sense to be split
lin compeer_N = mkN "ผู้ที่มีสถานภาพเดียวกัน" | mkN "เพื่อน" | mkN "เพื่อนสนิท" | mkN "ความเท่าเทียม" | mkN "ผู้ที่อยู่ในฐานะเดียวกัน" ; -- src=panlex
lin compelling_A = mkA "ที่บังคับ" | mkA "ซึ่งบีบบังคับ" | mkA "ที่กระตุ้นความสนใจ" | mkA "ซึ่งมีผลมากที่ต้านไม่อยู่" ; -- src=panlex
lin compendious_A = mkA "รัดกุม" | mkA "สั้นและชัดเจน" | mkA "สั้นกะทัดรัดและชัดเจน" ; -- src=panlex
lin compendium_N = mkN "บทสรุป" | mkN "บทคัดย่อ" ; -- src=panlex
lin compensable_A = mkA "ที่ควรได้รับการชดเชย" | mkA "ควรได้รับการชดเชยหรือตอบแทน" ; -- src=panlex
lin compensate_V = mkV "ชดเชย" | mkV "ชดใช้" | mkV "ตอบแทน" | mkV "ให้ผลตอบแทน" | mkV "ให้เงินชดเชย" | mkV "จ่ายเงินชดเชย" | mkV "ปรับให้พอเหมาะ" | mkV "ชดเชย" ; -- src=panlex
lin compensate_V2 = mkV2 "ชดเชย" ; ---- | mkV "ชดใช้" | mkV "ตอบแทน" | mkV "ให้ผลตอบแทน" | mkV "ให้เงินชดเชย" | mkV "จ่ายเงินชดเชย" | mkV "ปรับให้พอเหมาะ" | mkV "ชดเชย" ; -- src=panlex
lin compensation_N = mkN "การทดแทน" | mkN "การชดเชย" | mkN "การทดแทน" | mkN "การตอบแทน" | mkN "สิ่งที่ชดเชย" ; -- src=panlex
lin compensatory_A = mkA "เป็นการชดเชย" ; -- src=panlex
lin compere_N = mkN "โฆษก" ; -- src=panlex
lin compete_V = mkV "แข่ง" | mkV "แข่งขัน" | mkV "แข่งขัน" ; -- src=panlex
lin competence_N = mkN "ความสามารถ" | mkN "อํานาจ" | mkN "ความสามารถ" | mkN "ความพอเพียง" ; -- src=panlex
lin competent_A = mkA "เพียงพอ" | mkA "ที่มีความสามารถ" | mkA "เพียงพอต่อจุดประสงค์" | mkA "เก่ง" | mkA "เพียงพอ" | mkA "มีความสามารถ" | mkA "ที่มีความสามารถ" ; -- src=panlex
lin competition_N = mkN "การแข่ง" | mkN "คู่แข่ง" | mkN "คอนเทสต์" | mkN "การประกวด" | mkN "การประลอง" | mkN "คู่ต่อสู้" | mkN "ผู้ท้าชิง" | mkN "การแข่งขัน" | mkN "การแข่งขันทางธุรกิจ" | mkN "การชิงชัย" | mkN "การแข่งขัน" | mkN "ผู้แข่งขัน" | mkN "การดิ้นรนต่อสู้ในการดํารงชีพ" ; -- src=panlex
lin competitive_A = mkA "เกี่ยวกับการแข่งขัน" | mkA "ซึ่งสามารถแข่งขันได้" | mkA "ที่เกี่ยวกับการแข่งขัน" ; -- src=panlex
lin competitiveness_N = mkN "การแข่ง" ; -- src=panlex
lin competitor_N = mkN "คู่แข่ง" | mkN "คู่ต่อสู้" | mkN "ผู้ท้าชิง" | mkN "คู่แข่ง" | mkN "ผู้แข่ง" | mkN "คู่ต่อสู้" | mkN "ผู้แข่งขัน" ; -- src=panlex
lin compilation_N = mkN "การรวบรวม" | mkN "หนังสือรวมบทความ" | mkN "การรวบรวม" | mkN "ผู้เรียบเรียง" ; -- src=panlex
lin compiler_N = mkN "ผู้แปล" | mkN "ผู้รวบรวม" | mkN "คอมไพเลอร์" | mkN "ตัวแปลโปรแกรม" | mkN "ผู้แปล" | mkN "ผู้รวบรวม" ; -- src=panlex
lin complacence_N = mkN "ความอิ่มใจ" | mkN "ความพึงพอใจ" | mkN "ความพึงพอใจ" ; -- src=panlex
lin complacency_N = mkN "ความอิ่มใจ" | mkN "ความพึงพอใจ" | mkN "ความพึงพอใจ" | mkN "ความอิ่มอกอิ่มใจ" ; -- src=panlex
lin complacent_A = mkA "พึงพอใจ" | mkA "ที่พึงพอใจ" | mkA "อิ่มอกอิ่มใจ" ; -- src=panlex
lin complain_V = mkV "บ่น" | mkV "พร่ำบ่น" | mkV "คำร้องเรียน" | mkV "บ่น" | mkV "ร้องทุกข์" ; -- src=panlex
lin complain_VS = mmkVS "บ่น" ; ---- | mkV "พร่ำบ่น" | mkV "คำร้องเรียน" | mkV "บ่น" | mkV "ร้องทุกข์" ; -- src=panlex
lin complainant_N = mkN "โจทก์" | mkN "ผู้ฟ้องคดี" | mkN "ผู้ร้องทุกข์" | mkN "ผู้บ่น" | mkN "ผู้ฟ้องร้อง" | mkN "ผู้ร้องทุกข์" ; -- src=panlex
lin complaint_N = mkN "ข้อหา" | mkN "ความไม่พอใจ" | mkN "ความเจ็บป่วย" | mkN "โรคภัยไข้เจ็บ" | mkN "การร้องไห้คร่ำครวญ" | mkN "การบ่น" | mkN "ความไม่พอใจ" | mkN "การร้องทุกข์" | mkN "ข้อที่ไม่พอใจ" | mkN "การแสดงความข้องใจ" | mkN "มูลเหตุที่บ่นหรือร้องทุกข์" | mkN "การฟ้องร้องคดีแพ่งในระยะแรกของโจทก์" ; -- src=panlex
lin complaisance_N = mkN "ความอ่อนโยน" | mkN "การเอาใจ" | mkN "ความพึงพอใจ" | mkN "น้ําใสใจจริง" | mkN "การทําให้พอใจ" | mkN "การเอาอกเอาใจ" ; -- src=panlex
lin complaisant_A = mkA "ที่เอาอกเอาใจ" | mkA "ที่มีใจเอื้อเฟื้อ" | mkA "พอใจ" | mkA "ที่ทําให้พอใจ" | mkA "ซึ่งเอาอกเอาใจ" | mkA "มีน้ําใสใจจริง" ; -- src=panlex
lin complement_N = mkN "อัตราเต็ม" | mkN "คอมพลีเมนต์" | mkN "ส่วนเติมเต็ม" | mkN "หน่วยเสริมความ" | mkN "องค์ประกอบที่ทําให้สมบูรณ์" ; -- src=panlex
lin complemental_A = mkA "ซึ่งทำให้สมบูรณ์" ; -- src=panlex
lin complementary_A = mkA "ซึ่งทำให้สมบูรณ์" ; -- src=panlex
lin complementation_N = mkN "การเป็นส่วนเติมเต็ม" ; -- src=panlex
lin complete_A = mkA "ทั้งหมด" | mkA "ที่เสร็จสิ้น" ; -- src=panlex
lin complete_V = mkV "กรอก" | mkV "ทำเสร็จ" | mkV "ปฏิบัติหน้าที่" | mkV "เข้าสอบแข่งขัน" | mkV "จบ" | mkV "เสร็จ" | mkV "เสร็จสิ้น" | mkV "ทําทั้งหมด" ; -- src=panlex
lin complete_V2 = mkV2 "กรอก" ; ---- | mkV "ทำเสร็จ" | mkV "ปฏิบัติหน้าที่" | mkV "เข้าสอบแข่งขัน" | mkV "จบ" | mkV "เสร็จ" | mkV "เสร็จสิ้น" | mkV "ทําทั้งหมด" ; -- src=panlex
lin completeness_N = mkN "ความสมบูรณ์" ; -- src=panlex
lin completion_N = mkN "การจบ" | mkN "การลงเอย" | mkN "การเสร็จสมบูรณ์" | mkN "การสรุป" | mkN "การทําเสร็จ" | mkN "การทําให้เสร็จ" | mkN "การทําให้สมบูรณ์" | mkN "การสําเร็จลุล่วง" | mkN "การส่งลูกฟุตบอลไปข้างหน้าได้สําเร็จ" ; -- src=panlex
lin complex_A = mkA "ซับซ้อน" | mkA "ซับซ้อน" | mkA "เชิงซ้อน" | mkA "ประกอบด้วยส่วนต่าง ๆ" | mkA "ที่ประกอบด้วยสองส่วนขึ้นไป" | mkA "ซึ่งประกอบด้วย2ส่วน" ; -- src=panlex
lin complex_N = mkN "ปม" | mkN "คอมเพล็ก" | mkN "ความซับซ้อน" | mkN "สารประกอบโคออร์ดิเนชัน" | mkN "ความคิดหรือกิจกรรมที่สัมพันธ์กัน" ; -- src=panlex
lin complexifier_N = mkN "คนที่ทำสิ่งซับซ้อน" ; -- src=panlex
lin complexion_N = mkN "สีผิว" | mkN "สีเนื้อ" | mkN "เค้า" | mkN "สีผิว" | mkN "สีหน้า" | mkN "ความเชื่อ" | mkN "คุณลักษณะ" | mkN "ลักษณะผิว" | mkN "ความคิดเห็น" ; -- src=panlex
lin complexity_N = mkN "ความสลับซับซ้อน" | mkN "ความซับซ้อน" | mkN "ลักษณะเชิงซ้อน" | mkN "สิ่งที่ซับซ้อน" | mkN "ความสลับซับซ้อน" ; -- src=panlex
lin compliance_N = mkN "ความอ่อนโยน" | mkN "การยอมให้" | mkN "การยินยอม" | mkN "การร่วมมือ" | mkN "การเชื่อฟัง" | mkN "การยอมทําตาม" | mkN "การอ่อนข้อให้" ; -- src=panlex
lin compliant_A = mkA "เชื่อฟัง" | mkA "ซึ่งยอมตาม" | mkA "ซึ่งยินยอม" | mkA "ซึ่งเชื่อฟัง" | mkA "ที่ยอมทําตาม" | mkA "ที่พร้อมจะทําตาม" ; -- src=panlex
lin complicated_A = mkA "ซับซ้อน" | mkA "ยุ่งยาก" | mkA "ยุ่งเหยิง" | mkA "ยากที่จะแก้ไข" | mkA "ยากที่จะเข้าใจ" | mkA "ยากที่จะวิเคราะห์ เข้าใจหรืออธิบาย" ; -- src=panlex
lin complicatedness_N = mkN "ความสลับซับซ้อน" ; -- src=panlex
lin complication_N = mkN "โรคแทรกซ้อน" | mkN "ความสลับซับซ้อน" | mkN "สถานการณ์สลับซับซ้อน" | mkN "ความซับซ้อน" | mkN "โรคแทรกซ้อน" | mkN "การทําให้ยาก" | mkN "ความแทรกซ้อน" | mkN "สิ่งแทรกซ้อน" | mkN "การทําให้ยุ่ง" | mkN "ความยุ่งเหยิง" ; -- src=panlex
lin complicity_N = mkN "การเป็นผู้สมคบ" | mkN "การเป็นผู้ร่วมงาน" | mkN "การเป็นผู้ร่วมทําผิด" | mkN "ความสัมพันธ์ที่ร่วมกันกระทําความผิด" ; -- src=panlex
lin compliment_N = mkN "การชื่นชม" | mkN "การแสดงความชื่นชม" | mkN "ชมเชย" | mkN "อวยพร" | mkN "คําชมเชย" | mkN "คําอวยพร" | mkN "คําสรรเสริญ" | mkN "แสดงความปรารถนาดี" ; -- src=panlex
lin complimentary_A = mkA "อิสระ" | mkA "ซึ่งยกยอ" | mkA "ที่ชมเชย" | mkA "ซึ่งชมเชย" | mkA "ที่ชื่นชม" | mkA "ที่ยกย่อง" | mkA "ซึ่งสรรเสริญ" ; -- src=panlex
lin complin_N = mkN "คําอธิษฐานครั้งสุดท้าย" ; -- src=panlex
lin compline_N = mkN "คําอธิษฐานครั้งสุดท้าย" ; -- src=panlex
lin comply_V = mkV "ทำตาม" | mkV "ปฏิบัติตาม" | mkV "ทําตาม" | mkV "เชื่อฟัง" ; -- src=panlex
lin comply_V2 = mkV2 "ทำตาม" ; ---- | mkV "ปฏิบัติตาม" | mkV "ทําตาม" | mkV "เชื่อฟัง" ; -- src=panlex
lin component_N = mkN "ส่วนประกอบ" | mkN "องค์ประกอบ" | mkN "ส่วนประกอบ" ; -- src=panlex
lin comport_V = mkV "ทำตัวดี" | mkV "ประพฤติตน" | mkV "ประพฤติตัว" | mkV "ประพฤติตัวดี" | mkV "ประพฤติ" | mkV "เห็นด้วย" ; -- src=panlex
lin comport_V2 = mkV2 "ทำตัวดี" ; ---- | mkV "ประพฤติตน" | mkV "ประพฤติตัว" | mkV "ประพฤติตัวดี" | mkV "ประพฤติ" | mkV "เห็นด้วย" ; -- src=panlex
lin comportment_N = mkN "วิธีการวางตัว" | mkN "ความประพฤติ" ; -- src=panlex
lin compose_V = mkV "รจนา" | mkV "แต่ง" | mkV "สำรวม" | mkV "เขียน" | mkV "รวบรวม" | mkV "ประพันธ์" | mkV "แต่งเพลง" | mkV "จัดรวบรวม" | mkV "เขียนเพลง" | mkV "วางเค้าโครง" | mkV "ประพันธ์เพลง" | mkV "ประกอบขึ้นเป็น" | mkV "ประกอบด้วย" ; -- src=panlex
lin compose_V2 = mkV2 "รจนา" ; ---- | mkV "แต่ง" | mkV "สำรวม" | mkV "เขียน" | mkV "รวบรวม" | mkV "ประพันธ์" | mkV "แต่งเพลง" | mkV "จัดรวบรวม" | mkV "เขียนเพลง" | mkV "วางเค้าโครง" | mkV "ประพันธ์เพลง" | mkV "ประกอบขึ้นเป็น" | mkV "ประกอบด้วย" ; -- src=panlex
lin composer_N = mkN "นักประพันธ์เพลง" | mkN "ผู้ทํา" | mkN "ผู้แต่ง" | mkN "นักแต่งเพลง" | mkN "นักแต่งเพลงหรือดนตรี" ; -- src=panlex
lin composing_N = mkN "การแต่งเพลง" | mkN "การประพันธ์เพลง" | mkN "การแต่ง" | mkN "การเรียง" | mkN "การเรียงพิมพ์" ; -- src=panlex
lin composite_A = mkA "ผสมเป็น" | mkA "ประกอบขึ้น" | mkA "ประกอบด้วยส่วนต่าง ๆ" | mkA "ที่ประกอบขึ้นจากหลายส่วน" ; -- src=panlex
lin composite_N = mkN "ความซับซ้อน" | mkN "ต้นคอมโพซิตแพลนต์" | mkN "สิ่งที่ประกอบขึ้นจากหลายส่วน" ; -- src=panlex
lin composition_N = mkN "บทความ" | mkN "บทเพลง" | mkN "รายงาน" | mkN "เปเปอร์" | mkN "ไทโปกราฟี" | mkN "ส่วนประกอบ" | mkN "การประพันธ์" | mkN "การแต่งเพลง" | mkN "การประกอบขึ้น" | mkN "การแต่งหนังสือ" | mkN "สิ่งที่ผสมขึ้น" | mkN "การประพันธ์เพลง" | mkN "การเขียนหนังสือ" | mkN "ของผสม" | mkN "ผลิตผล" | mkN "ข้อตกลง" | mkN "อุปนิสัย" | mkN "คุณสมบัติ" | mkN "ภาพประกอบ" | mkN "การตกลงกัน" | mkN "ส่วนประกอบ" | mkN "องค์ประกอบ" | mkN "การประพันธ์" | mkN "การแต่งเพลง" | mkN "การประนีประนอม" | mkN "สิ่งที่ประกอบขึ้น" | mkN "การจัดวางองค์ประกอบ" | mkN "การจัดเรียงตัวพิมพ์" | mkN "การเกิดเป็นสารประกอบ" | mkN "การประกอบเป็นส่วนต่าง ๆ ทั้งหมด" ; -- src=panlex
lin compositor_N = mkN "ช่างเรียงพิมพ์" | mkN "ผู้เรียงพิมพ์" | mkN "ผู้จัดวางองค์ประกอบ" ; -- src=panlex
lin compost_N = mkN "ปุ๋ยหมัก" | mkN "ปุ๋ยผสม" | mkN "การผสมกัน" | mkN "การผสมผสาน" | mkN "เอามาทําเป็นปุ๋ยผสม" | mkN "ส่วนผสมของสารอินทรีย์สําหรับเป็นปุ๋ย" ; -- src=panlex
lin composure_N = mkN "ความสุขุม" | mkN "ความใจเย็น" | mkN "ความสงบ" | mkN "ความเงียบสงบ" | mkN "อารมณ์ที่สงบ" | mkN "ภาวะจิตที่ปกติ" | mkN "ความสงบของจิตใจ" ; -- src=panlex
lin compote_N = mkN "ผลไม้แช่อิ่ม" | mkN "จานผลไม้" | mkN "น้ําเชื่อมผลไม้" | mkN "ขนมหวานชนิดหนึ่งทําจากผลไม้" ; -- src=panlex
lin compound_A = mkA "ที่เกิดจากส่วนประกอบสองส่วนขึ้นไป" ; -- src=panlex
lin compound_N = mkN "สารประกอบ" | mkN "สารประกอบเคมี" | mkN "คําประสม" | mkN "สิ่งที่เกิดจากส่วนประกอบสองส่วนขึ้นไป" ; -- src=panlex
lin compound_V = mkV "การรวมกลุ่ม" | mkV "ทำให้เพิ่มขึ้น" | mkV "ผสม" | mkV "รวม" | mkV "ทําให้เพิ่มขึ้น" ; -- src=panlex
lin compound_V2 = mkV2 "การรวมกลุ่ม" ; ---- | mkV "ทำให้เพิ่มขึ้น" | mkV "ผสม" | mkV "รวม" | mkV "ทําให้เพิ่มขึ้น" ; -- src=panlex
lin comprehensible_A = mkA "ฉลาด" | mkA "ที่เข้าใจได้" | mkA "ซึ่งสามารถเข้าใจได้" ; -- src=panlex
lin comprehension_N = mkN "ความเข้าใจ" | mkN "การรวมอยู่ด้วยกัน" | mkN "ความเข้าใจ" | mkN "การครอบคลุม" | mkN "ภาวะที่เข้าใจ" | mkN "การกินความกว้าง" | mkN "ความสามารถเข้าใจ" | mkN "ความสามารถในการเรียนรู้" ; -- src=panlex
lin comprehensive_A = mkA "ครอบคลุม" | mkA "กว้างขวาง" | mkA "ที่ครอบคลุม" | mkA "ซึ่งหยั่งรู้" | mkA "เข้าใจได้กว้าง" | mkA "ที่มีเนื้อหาครอบคลุม" ; -- src=panlex
lin comprehensiveness_N = mkN "ความรอบรู้" | mkN "ความสมบูรณ์พร้อม" ; -- src=panlex
lin compress_N = mkN "ผ้าประคบแผล" ; -- src=panlex
lin compressibility_N = mkN "สภาพอัดได้" ; -- src=panlex
lin compression_N = mkN "ความแน่น" | mkN "การบีบอัด" | mkN "การลดขนาด" | mkN "การกด" | mkN "การบีบ" | mkN "การอัด" | mkN "การบีบอัด" | mkN "ความกดดัน" | mkN "ผลจากการถูกอัด" ; -- src=panlex
lin compressor_N = mkN "เครื่องคอมเพรสเซอร์" | mkN "ผู้อัด" | mkN "สิ่งอัด" | mkN "กล้ามเนื้อที่กดส่วนหนึ่งของร่างกาย" | mkN "เครื่องยนต์ที่มีลูกสูบหรือเครื่องปั๊ม" | mkN "เครื่องยนต์ที่มีการบีบอัดก๊าซหรืออากาศ" ; -- src=panlex
lin compromise_N = mkN "ยอม" | mkN "การยอมรับ" | mkN "เป็นภัยต่อ" | mkN "เป็นอันตราย" | mkN "การตกลงกันได้" | mkN "การประนีประนอม" | mkN "อ่อนข้อให้อย่างเสียเกียรติ" ; -- src=panlex
lin compromise_V = mkV "ประนีประนอม" ; -- src=panlex
lin compromise_V2 = mkV2 "ประนีประนอม" ; ---- ; -- src=panlex
lin compsognathus_N = mkN "คอมซอกนาทัส" ; -- src=panlex
lin comptroller_N = mkN "นักบัญชี" | mkN "สมุหบัญชี" | mkN "พนักงานบัญชี" ; -- src=panlex
lin compulsion_N = mkN "การบังคับ" | mkN "การใช้กำลัง" | mkN "การครอบงำจิตใจ" | mkN "การบังคับ" | mkN "การบีบบังคับ" | mkN "ภาวะที่ถูกบีบบังคับ" | mkN "แรงกดดันที่ต้านไม่ได้ทางจิต" ; -- src=panlex
lin compulsive_A = mkA "ซึ่งบีบบังคับ" | mkA "เป็นเชิงบังคับ" | mkA "ที่ต้องทําเพราะถูกบังคับ" ; -- src=panlex
lin compulsory_A = mkA "ที่บังคับ" | mkA "ใช้การบังคับ" | mkA "ซึ่งต้องกระทํา" | mkA "เป็นเชิงบังคับ" | mkA "ที่จําเป็นต้องทํา" | mkA "เป็นหน้าที่ต้องกระทํา" ; -- src=panlex
lin compunction_N = mkN "ความสำนึกผิด" | mkN "การมีจิตสำนึก" | mkN "ความรู้สึกสํานึกผิด" | mkN "ความเสียใจต่อการกระทํา" ; -- src=panlex
lin computable_A = mkA "ที่คำนวนได้" | mkA "ที่คิดคํานวณได้" ; -- src=panlex
lin computation_N = mkN "การคำนวณ" | mkN "การคิดคำนวณ" | mkN "การคํานวณ" | mkN "วิธีการคํานวณ" | mkN "ผลของการคํานวณ" | mkN "ค่าที่คํานวณได้" | mkN "ผลที่ได้จากการคํานวณ" ; -- src=panlex
lin compute_V = mkV "คำนวณ" | mkV "คิดเลข" | mkV "คิดคำนวณ" | mkV "คํานวณ" | mkV "ใช้คอมพิวเตอร์" ; -- src=panlex
lin compute_V2 = mkV2 "คำนวณ" ; ---- | mkV "คิดเลข" | mkV "คิดคำนวณ" | mkV "คํานวณ" | mkV "ใช้คอมพิวเตอร์" ; -- src=panlex
lin computer_N = mkN (thword "คอม" "พิว" "เตอร์") "เครื่อง" | {-pan-} mkN "คอม" | mkN "นักคำนวณ" | mkN "นักคิดเลข" | mkN "คอมพิวเตอร์" | mkN "เครื่องคอมพิวเตอร์" | mkN "ผู้คํานวณ" | mkN "คอมพิวเตอร์" | mkN "เครื่องคํานวณ" | mkN "เครื่องคอมพิวเตอร์" ; -- src=panlex
lin computerization_N = mkN "การเปลี่ยนมาใช้ระบบคอมพิวเตอร์" ; -- src=panlex
lin computing_N = mkN "การคำนวณ" | mkN "การคิดคำนวณ" | mkN "วิทยาการคอมพิวเตอร์" ; -- src=panlex
lin comrade_N = mkN "พี่ชาย" | mkN "เพื่อน" | mkN "คนคุ้นเคย" | mkN "สหาย" | mkN "เพื่อน" | mkN "มิตรสนิท" | mkN "เพื่อนสนิท" | mkN "สมาชิกพรรค คอมมิวนิสต์" | mkN "เพื่อนสมาชิกหรือพรรค" ; -- src=panlex
lin comradeship_N = mkN "ความเป็นมิตร" | mkN "ความเป็นเพื่อน" | mkN "ความเป็นเพื่อนสนิท" ; -- src=panlex
lin con_Adv = mkAdv "ในทางลบ" ; -- src=panlex
lin con_N = mkN "การโกง" | mkN "การฉ้อโกง" | mkN "ผู้ต้องขัง" | mkN "ผู้ถูกตัดสินจำคุก" | mkN "กลลวง" | mkN "การโกหก" | mkN "การหลองลวง" | mkN "ข้อโต้แย้ง" ; -- src=panlex
lin concatenation_N = mkN "ลูกโซ่" | mkN "สายโซ่" | mkN "การเชื่อมต่อ" | mkN "การเชื่อมโยง" | mkN "ความเชื่อมโยง" ; -- src=panlex
lin concave_A = mkA "เว้า" | mkA "โค้งเว้า" | mkA "เว้า" ; -- src=panlex
lin concavity_N = mkN "ความเว้า" | mkN "รูปทรงเว้า" | mkN "ทรงโค้งเว้า" | mkN "รูปโค้งเว้า" | mkN "ช่อง" | mkN "โพรง" | mkN "ความเว้า" | mkN "ผิวหน้าเว้า" | mkN "สิ่งที่มีผิวหน้าเว้า" | mkN "ภาวะหรือลักษณะที่เว้าเข้าข้างใน" ; -- src=panlex
lin concealment_N = mkN "การซ่อน" | mkN "การปกปิด" | mkN "การปิดบัง" | mkN "สิ่งปกคลุม" | mkN "การซ่อน" | mkN "การปกปิด" | mkN "การปิดบัง" | mkN "สถานที่ซ่อน" | mkN "วิธีการปิดบัง" | mkN "ภาวะที่ถูกปิดบัง" | mkN "การเก็บเป็นความลับ" ; -- src=panlex
lin concede_V = mkV "ให้" | mkV "ยอมรับ" | mkV "สารภาพผิด" | mkV "ยอมถูกกระทำ" | mkV "ยอมรับความพ่ายแพ้" | mkV "ยอมรับว่าถูก" ; -- src=panlex
lin concede_V2 = mkV2 "ให้" ; ---- | mkV "ยอมรับ" | mkV "สารภาพผิด" | mkV "ยอมถูกกระทำ" | mkV "ยอมรับความพ่ายแพ้" | mkV "ยอมรับว่าถูก" ; -- src=panlex
lin concede_VS = mmkVS "ให้" ; ---- | mkV "ยอมรับ" | mkV "สารภาพผิด" | mkV "ยอมถูกกระทำ" | mkV "ยอมรับความพ่ายแพ้" | mkV "ยอมรับว่าถูก" ; -- src=panlex
lin conceit_N = mkN "ความทรนง" | mkN "คำพูดที่คมคาย" | mkN "ความนึกเปรียบเทียบ" | mkN "การเปรียบเทียบอย่างพิศดาร" | mkN "ความคิด" | mkN "จินตนาการ" ; -- src=panlex
lin conceited_A = mkA "ถือดี" | mkA "หยิ่ง" | mkA "อวดดี" | mkA "เป็นจินตนาการ" | mkA "ที่ภูมิใจในตัวเองมากเกินไป" ; -- src=panlex
lin conceivable_A = mkA "เป็นไปได้" | mkA "นึกเห็นได้" | mkA "พอจะนึกภาพออก" | mkA "พอที่จะคิดออก" | mkA "ที่สามารถเข้าใจได้" ; -- src=panlex
lin conceive_V = mkV "คิดว่า" | mkV "เห็นว่า" | mkV "ตั้งท้อง" | mkV "มีแนวคิด" | mkV "เชื่อว่า" | mkV "คิด" | mkV "ติด" | mkV "เข้าใจ" | mkV "ตั้งครรภ์" ; -- src=panlex
lin conceive_V2 = mkV2 "คิดว่า" ; ---- | mkV "เห็นว่า" | mkV "ตั้งท้อง" | mkV "มีแนวคิด" | mkV "เชื่อว่า" | mkV "คิด" | mkV "ติด" | mkV "เข้าใจ" | mkV "ตั้งครรภ์" ; -- src=panlex
lin concentrate_N = mkN "แร่" | mkN "หัวอาหาร" | mkN "สิ่งที่ถูกทําให้มีความเข้มข้นขึ้น" ; -- src=panlex
lin concentrate_V = mkV "ย่อ" | mkV "จดจ่อ" | mkV "โฟกัส" | mkV "ตั้งใจ" | mkV "เคี่ยว" | mkV "รวมศูนย์" | mkV "ตั้งสมาธิ" | mkV "ทำให้น้อยลง" | mkV "ทำให้เข้มข้น" | mkV "มีสมาธิจดจ่อ" | mkV "เพ่งความสนใจ" | mkV "ทําให้เข้มข้นขึ้น" | mkV "ทําให้เพ่งความสนใจ" | mkV "ทําให้ตรงไปยังจุดศูนย์กลาง" ; -- src=panlex
lin concentrate_V2 = mkV2 "ย่อ" ; ---- | mkV "จดจ่อ" | mkV "โฟกัส" | mkV "ตั้งใจ" | mkV "เคี่ยว" | mkV "รวมศูนย์" | mkV "ตั้งสมาธิ" | mkV "ทำให้น้อยลง" | mkV "ทำให้เข้มข้น" | mkV "มีสมาธิจดจ่อ" | mkV "เพ่งความสนใจ" | mkV "ทําให้เข้มข้นขึ้น" | mkV "ทําให้เพ่งความสนใจ" | mkV "ทําให้ตรงไปยังจุดศูนย์กลาง" ; -- src=panlex
lin concentrated_A = mkA "ส่อง" | mkA "เข้มข้น" | mkA "ใจจดใจจ่อ" | mkA "ซึ่งตั้งอกตั้งใจ" | mkA "ซึ่งจับกลุ่มเข้าด้วยกัน" ; -- src=panlex
lin concentration_N = mkN "การรวบรวม" | mkN "ความหนาแน่น" | mkN "ความเข้มข้น" | mkN "การตั้งสมาธิ" | mkN "การรวบรวมสมาธิ" | mkN "การมีสมาธิจดจ่อ" | mkN "ความขยันหมั่นเพียร" | mkN "การรวมพล" | mkN "ความเข้มข้น" | mkN "การให้ความสนใจ" | mkN "ภาวะที่เข้มข้น" | mkN "สิ่งที่เข้มข้น" | mkN "ความตั้งอกตั้งใจ" | mkN "ระดับความเข้มข้น" | mkN "สารที่มีความเข้มข้น" | mkN "การมุ่งไปยังศูนย์กลาง" | mkN "ความใส่ใจในสาขาวิชาหนึ่ง" ; -- src=panlex
lin concentric_A = mkA "ร่วมศูนย์" | mkA "ที่มีศูนย์กลาง" | mkA "ซึ่งมีศูนย์เดียวกัน" ; -- src=panlex
lin concept_N = mkN "มโนภาพ" | mkN "แนวคิด" | mkN "คอนเซปต์" | mkN "มโนทัศน์" | mkN "มโนคติ" | mkN "มโนภาพ" | mkN "ความคิด" | mkN "ข้อคิดเห็น" | mkN "กรอบความคิด" | mkN "ความคิดรวบยอด" ; -- src=panlex
lin conception_N = mkN "การคิด" | mkN "มโนภาพ" | mkN "แนวคิด" | mkN "คอนเซปต์" | mkN "มโนทัศน์" | mkN "การเริ่มต้น" | mkN "การตั้งครรภ์" | mkN "การคิด" | mkN "แบบแผน" | mkN "ความคิด" | mkN "โครงการ" | mkN "การเข้าใจ" | mkN "การตั้งต้น" | mkN "การริเริ่ม" | mkN "กรอบความคิด" | mkN "การเริ่มต้น" | mkN "สร้างมโนคติ" | mkN "ภาวะตั้งครรภ์" | mkN "อํานาจความคิด" ; -- src=panlex
lin conceptual_A = mkA "ทางคอนเซ็ปต์" | mkA "เกี่ยวกับความคิด" | mkA "ที่เกี่ยวกับกรอบความคิด" | mkA "เกี่ยวกับการสร้างความคิด" ; -- src=panlex
lin conceptualism_N = mkN "คอนเซ็ปชัวลิสม์" ; -- src=panlex
lin concern_N = mkN "กิจการ" | mkN "ธุรกิจ" | mkN "สิ่งสำคัญ" | mkN "องค์กรธุรกิจ" | mkN "ความวิตกกังวล" | mkN "ความกังวล" | mkN "เรื่องราว" | mkN "ความสัมพันธ์" | mkN "เรื่องที่สําคัญกับบุคคลหนึ่ง" ; -- src=panlex
lin concerned_A = mkA "กังวล" | mkA "ซึ่งเป็นห่วง" | mkA "ที่เกี่ยวข้อง" | mkA "ที่สัมพันธ์กับ" | mkA "ซึ่งเป็นที่สนใจ" ; -- src=panlex
lin concerning_Prep = mkPrep "เกี่ยวกับ" ; -- src=panlex
lin concert_N = mkN "คอนเสิร์ต" | mkN "คอนเสิร์ต" | mkN "การแสดงดนตรี" | mkN "การเห็นพ้องร่วมกัน" ; -- src=panlex
lin concertina_N = mkN "คอนเซอร์ตินา" ; -- src=panlex
lin concerto_N = mkN "คอนแชร์โต" | mkN "เพลงเล่นประสานเสียง" ; -- src=panlex
lin concession_N = mkN "การยอมให้" | mkN "จุดผ่อนปรน" | mkN "สัมปทาน" | mkN "เขตเช่า" | mkN "การยอมให้" | mkN "การยินยอม" | mkN "สิ่งที่ยินยอม" | mkN "เรื่องที่ยินยอม" | mkN "การยอมอ่อนข้อให้" | mkN "สิ่งที่ยอมยกให้หรือโอนให้" ; -- src=panlex
lin concessionaire_N = mkN "ผู้ได้รับสัมปทาน" | mkN "ผู้รับโอน" | mkN "ผู้ได้รับสัมปทาน" | mkN "ผู้ได้รับการยกให้" ; -- src=panlex
lin concessive_A = mkA "ที่ยอมให้" | mkA "มักยินยอม" | mkA "ที่อ่อนข้อให้" | mkA "ซึ่งยอมอ่อนข้อให้" ; -- src=panlex
lin conch_N = mkN "สังข์" | mkN "หอยสังข์" | mkN "เปลือกหอยสังข์" ; -- src=panlex
lin concha_N = mkN "กระดูกก้นหอย" ; -- src=panlex
lin conchfish_N = mkN "ปลาคอนช์ฟิช" ; -- src=panlex
lin conchology_N = mkN "วิชาว่าด้วยสัตว์ประเภทหอย" ; -- src=panlex
lin concierge_N = mkN "คนเฝ้าประตู" | mkN "คนเฝ้าประตู" ; -- src=panlex
lin conciliation_N = mkN "การคืนดี" | mkN "การไกล่เกลี่ย" ; -- src=panlex
lin conciliator_N = mkN "ผู้ไกล่เกลี่ย" | mkN "ผู้ไกล่เกลี่ย" | mkN "ผู้ทําให้ปรองดองกันได้" | mkN "ผู้ประนีประนอมให้ยอมกัน" ; -- src=panlex
lin conciliatory_A = mkA "ประนีประนอม" | mkA "เป็นการไกล่เกลี่ย" | mkA "มีแนวโน้มที่เป็นมิตร" ; -- src=panlex
lin concise_A = mkA "รวบรัด" | mkA "รัดกุม" | mkA "สั้นกระชับ" | mkA "สั้นกะทัดรัด" | mkA "สั้นได้ใจความ" ; -- src=panlex
lin conciseness_N = mkN "ความกระชับ" | mkN "การกล่าวอย่างกระชับ" | mkN "ความรัดกุม" | mkN "ความสั้นกระชับ" | mkN "ความสั้นกะทัดรัด" ; -- src=panlex
lin conclave_N = mkN "การประชุมลับ" | mkN "การประชุมลับ" | mkN "การประชุมส่วนตัว" ; -- src=panlex
lin conclude_V = mkV "จบ" | mkV "สรุป" | mkV "ปิดฉาก" | mkV "เห็นด้วย" | mkV "ใช้เหตุผล" | mkV "จบ" | mkV "สรุป" | mkV "ตัดสินใจ" | mkV "ทําให้จบ" ; -- src=panlex
lin conclude_V2 = mkV2 "จบ" ; ---- | mkV "สรุป" | mkV "ปิดฉาก" | mkV "เห็นด้วย" | mkV "ใช้เหตุผล" | mkV "จบ" | mkV "สรุป" | mkV "ตัดสินใจ" | mkV "ทําให้จบ" ; -- src=panlex
lin conclude_VS = mmkVS "จบ" ; ---- | mkV "สรุป" | mkV "ปิดฉาก" | mkV "เห็นด้วย" | mkV "ใช้เหตุผล" | mkV "จบ" | mkV "สรุป" | mkV "ตัดสินใจ" | mkV "ทําให้จบ" ; -- src=panlex
lin conclusion_N = mkN "ตอนจบ" | mkN "บทสรุป" | mkN "ตอนท้าย" | mkN "คำตัดสิน" | mkN "ตอนสุดท้าย" | mkN "การตัดสินใจ" | mkN "ช่วงปิดท้าย" | mkN "เหตุการณ์ตอนจบ" | mkN "การทำให้สิ้นสุด" | mkN "ความเห็นต่อท้าย" | mkN "ช่วงปิดการสนทนา" | mkN "ข้อเสนอแนะที่มีเหตุผล" | mkN "ผล" | mkN "บทสรุป" | mkN "การสรุป" | mkN "การลงเอย" | mkN "ส่วนสุดท้าย" | mkN "การสิ้นสุดลง" | mkN "การตกลงขั้นสุดท้าย" | mkN "การตัดสินใจครั้งสุดท้าย" ; -- src=panlex
lin conclusive_A = mkA "แน่นอน" | mkA "สุดท้าย" | mkA "เป็นข้อสรุป" | mkA "เกี่ยวกับตอนจบ" | mkA "ที่เป็นส่วนสุดท้าย" ; -- src=panlex
lin concoction_N = mkN "การปรุง" | mkN "การจัดทำ" | mkN "อาหารผสม" | mkN "การปรุงแต่ง" | mkN "การปรุง" | mkN "การกุเรื่องขึ้น" | mkN "การประกอบขึ้นเป็น" ; -- src=panlex
lin concomitance_N = mkN "การอยู่ร่วมกัน" | mkN "การเกิดขึ้นพร้อมกัน" ; -- src=panlex
lin concomitant_A = mkA "ที่เกิดขึ้นด้วยกัน" | mkA "ซึ่งเกิดขึ้นพร้อมกัน" | mkA "คุณลักษณะที่เกิดขึ้นพร้อมกัน" ; -- src=panlex
lin concomitant_N = mkN "การเกิดพร้อมกัน" ; -- src=panlex
lin concord_N = mkN "ความกลมกลืน" | mkN "ความปรองดอง" | mkN "ความสอดคล้องกัน" | mkN "ความเห็นสอดคล้อง" | mkN "สัญญา" | mkN "ข้อตกลง" | mkN "ความสงบ" | mkN "มิตรภาพ" | mkN "การลงรอยกัน" | mkN "การปรองดองกัน" | mkN "ความกลมเกลียว" | mkN "ความสอดคล้องกัน" | mkN "ความเป็นมิตรภาพกัน" | mkN "เสียงที่กลมกลืนกัน" ; -- src=panlex
lin concordance_N = mkN "ความกลมกลืน" | mkN "ความปรองดอง" | mkN "คอนคอร์แดนซ์" | mkN "ความสอดคล้องกัน" | mkN "ความเห็นสอดคล้อง" | mkN "การตกลงกัน" | mkN "ความกลมเกลียว" | mkN "ความสอดคล้องกัน" | mkN "ดรรชนีเรื่องตามอักษร" ; -- src=panlex
lin concordant_A = mkA "สอดคล้องกัน" | mkA "ซึ่งลงรอยกัน" | mkA "ซึ่งสอดคล้องกัน" ; -- src=panlex
lin concordat_N = mkN "สัญญา" | mkN "การทำสัญญา" | mkN "สัญญา" | mkN "ข้อตกลง" | mkN "ข้อตกลงเป็นทางการ" ; -- src=panlex
lin concourse_N = mkN "ฝูงชน" | mkN "ฝูงชน" | mkN "ทางเดิน" | mkN "ชุมนุมชน" | mkN "ทางรถยนต์" | mkN "การรวมกลุ่ม" | mkN "ลานกว้างมาก" | mkN "การมาด้วยกัน" | mkN "บริเวณสําหรับแข่งขัน" | mkN "ถนนขนาดใหญ่ที่มีต้นไม้สองข้างทาง" ; -- src=panlex
lin concrete_A = mkA "เป็นรูปธรรม" | mkA "ที่เป็นรูปธรรม" | mkA "ที่กลายเป็นของแข็ง" | mkA "ที่ทําให้เป็นจริงได้" ; -- src=panlex
lin concrete_N = mkN "คอนกรีต" | mkN "คอนกรีต" | mkN "รูปธรรม" | mkN "ที่สัมผัสจับต้องได้" ; -- src=panlex
lin concrete_V = mkV "ฉาบปูน" | mkV "ฉาบซีเมนต์" | mkV "ฉาบด้วยซีเมนต์" | mkV "ทําจากคอนกรีต" ; -- src=panlex
lin concrete_V2 = mkV2 "ฉาบปูน" ; ---- | mkV "ฉาบซีเมนต์" | mkV "ฉาบด้วยซีเมนต์" | mkV "ทําจากคอนกรีต" ; -- src=panlex
lin concreteness_N = mkN "ความเป็นรูปธรรม" ; -- src=panlex
lin concretion_N = mkN "ความแน่น" | mkN "การรวมตัว" | mkN "ก้อนหินปูน" | mkN "ก้อนหรือเม็ดนิ่วในร่างกาย" | mkN "ของแข็ง" | mkN "การแข็งตัว" | mkN "สิ่งที่มีตัวตน" | mkN "สิ่งที่แข็งตัว" | mkN "สภาพที่เป็นของแข็ง" | mkN "สิ่งที่เกิดจากการเกาะกัน" | mkN "ก้อนหรือเม็ดนิ่วในร่างกาย" | mkN "ก้อนแข็งที่เกิดขึ้นในหินทรายหรือดิน" ; -- src=panlex
lin concubinage_N = mkN "การอยู่กินด้วยกันโดยไม่ได้สมรส" ; -- src=panlex
lin concubine_N = mkN "อีหนู" | mkN "บ้านเล็ก" | mkN "อนุภรรยา" | mkN "เมียน้อย" | mkN "อนุภรรยา" | mkN "เมียน้อย" | mkN "นางบําเรอ" | mkN "ภรรยาน้อย" | mkN "ภรรยาที่ไม่ได้สมรสด้วย" | mkN "หญิงที่อยู่กินกับผู้ชายโดยไม่ได้สมรส" ; -- src=panlex
lin concupiscence_N = mkN "กามารมณ์" | mkN "ความใคร่" | mkN "ความต้องการทางเพศ" | mkN "ความปรารถนาทางเพศ" | mkN "กําหนัด" | mkN "กามารมณ์" | mkN "ความใคร่ทางเพศ" ; -- src=panlex
lin concur_V = mkV "เห็นด้วย" | mkV "เห็นพ้อง" | mkV "เกิดขึ้นในเวลาเดียวกัน" | mkV "เห็นด้วย" | mkV "กระทําร่วมกัน" | mkV "เกิดขึ้นในเวลาเดียวกัน" ; -- src=panlex
lin concurrence_N = mkN "ความร่วมมือกัน" | mkN "การเกิดพร้อมกัน" | mkN "เหตุการณ์ประจวบกัน" | mkN "การเกิดขึ้นพร้อมกัน" | mkN "ความเห็นพ้องต้องกัน" | mkN "จุดบนเส้น ’เส้นหรือมากกว่านั้น" | mkN "การสนับสนุน" | mkN "การเห็นด้วย" | mkN "การเห็นพ้อง" | mkN "การประจวบกัน" | mkN "การเห็นพ้องด้วย" | mkN "การให้ความร่วมมือ" | mkN "การเกิดในเวลาเดียวกัน" | mkN "อํานาจร่วมหรือเท่ากัน" | mkN "การบังเกิดขึ้นพร้อมกัน" ; -- src=panlex
lin concurrent_A = mkA "คู่แข่ง" | mkA "พร้อมเพรียง" | mkA "ซึ่งเห็นด้วย" | mkA "สิ่งสนับสนุน" | mkA "ซึ่งมีจุดร่วม" | mkA "ที่กระทําร่วมกัน" | mkA "ที่เห็นพ้องต้องกัน" | mkA "ซึ่งมีอํานาจเท่ากัน" | mkA "ที่เกิดขึ้นพร้อมกัน" | mkA "ที่ไปยังจุดเดียวกัน" | mkA "ซึ่งเกิดขึ้นพร้อมกันหรือร่วมกัน" ; -- src=panlex
lin concussion_N = mkN "สมองกระทบกระเทือน" | mkN "การสั่นสะเทือน" | mkN "การปะทะอย่างแรง" | mkN "การสั่นอย่างแรง" | mkN "การกระเทือนที่เกิดจากการกระทบกระแทก" ; -- src=panlex
lin condemnation_N = mkN "คำสาบแช่ง" | mkN "การพิพากษา" | mkN "การสาปแช่ง" | mkN "การพิพากษาลงโทษ" | mkN "การวิพากวิจารณ์" | mkN "การประกาศว่าไม่ปลอดภัย" | mkN "การประณาม" | mkN "การวิจารณ์อย่างแรง" ; -- src=panlex
lin condensate_N = mkN "การกลั่นตัว" | mkN "สิ่งที่เกิดจากการรวมตัวกันแน่น" ; -- src=panlex
lin condensation_N = mkN "บทย่อ" | mkN "ฉบับย่อ" | mkN "การลดขนาด" | mkN "การควบแน่น" | mkN "การกลั่นตัว" | mkN "การอัดตัวกันแน่น" | mkN "การทําให้ลดลง" | mkN "การทําให้น้อยลง" | mkN "การรวมตัวกันแน่น" ; -- src=panlex
lin condense_V = mkV "ย่อ" | mkV "กลั่น" | mkV "พัฒนาการ" | mkV "ทำให้น้อยลง" | mkV "ย่อ" | mkV "ทําให้ลดลง" | mkV "ทําให้น้อยลง" ; -- src=panlex
lin condense_V2 = mkV2 "ย่อ" ; ---- | mkV "กลั่น" | mkV "พัฒนาการ" | mkV "ทำให้น้อยลง" | mkV "ย่อ" | mkV "ทําให้ลดลง" | mkV "ทําให้น้อยลง" ; -- src=panlex
lin condenser_N = mkN "ตัวเก็บไฟ" | mkN "คาปาซิเตอร์" | mkN "เลนส์รวมแสง" | mkN "คอนเด็นเซอร์" | mkN "เครื่องควบแน่น" | mkN "คนย่อ" | mkN "คนเดี่ยว" | mkN "เลนส์รวมแสง" | mkN "เครื่องสะสมประจุไฟฟ้า" | mkN "เครื่องที่เปลี่ยนก๊าซให้เป็นของเหลว" ; -- src=panlex
lin condescend_V = mkV "ลดตัว" | mkV "ลดคุณค่าของตัวเอง" | mkV "ลดตัวลงมา" ; -- src=panlex
lin condescendingly_Adv = mkAdv "อย่างวางโต" | mkAdv "อย่างวางท่า" | mkAdv "อย่างวางมาด" ; -- src=panlex
lin condescension_N = mkN "การดูถูกเหยียดหยาม" | mkN "การยอมรับ" | mkN "การก้มหัวลง" | mkN "ท่าทีที่กรุณา" | mkN "การถ่อมตัวลงมา" | mkN "ท่าทีที่เอื้อเฟื้อ" ; -- src=panlex
lin condign_A = mkA "สมควร" | mkA "พอเพียง" | mkA "เหมาะสม" ; -- src=panlex
lin condiment_N = mkN "เครื่องปรุงรส" | mkN "เครื่องปรุงรส" | mkN "เครื่องปรุงอาหาร" ; -- src=panlex
lin condition_1_N = variants {} ; ---- sense to be split
lin condition_2_N = variants {} ; ---- sense to be split
lin conditional_A = mkA "แล้วแต่" | mkA "ขึ้นอยู่กับ" | mkA "ที่เป็นเงื่อนไข" | mkA "ที่ต้องมีคุณสมบัติ" | mkA "เป็นเงื่อนไขหรือข้อแม้" ; -- src=panlex
lin conditionality_N = mkN "ความเป็นเงื่อนไข" ; -- src=panlex
lin conditioner_N = mkN "ครีมนว