--# -path=.:../finnish/stemmed:../finnish:../abstract:../common:../finnish/kotus:../api
---- checked by AR till beginning_N in the BNC order
concrete DictionaryFin of Dictionary = CatFin ** open ParadigmsFin,
  (S = StructuralFin),
  (Syntax = SyntaxFin),
  (L = LexiconFin),
  (R = ResFin),
  MorphoFin, ParadigmsFin, (E = ExtraFin), Kotus, WNKotus, StemFin, Prelude in {

flags coding=utf8 ; 

oper tehda_V = mkV (lin VK {s = c71 "tehdä"}) ; 
oper nahda_V = mkV (lin VK {s = c71 "nähdä"}) ; 
oper optProDrop : Pron -> Pron = \p -> p | E.ProDrop p ;
oper luokse_Prep : Prep = mkPrep "luokse" ; -- to enable (luo|luokse)-luokseni
oper adjAdv : A -> Adv = \a -> Syntax.mkAdv a ;

  mika_NForms : R.NForm => Str =
    let
      mi  = snoun2nounBind (mkN "mi")
    in
    table {
       NCase Sg Nom  => "mikä" ;
       NCase Pl Nom  => "mitkä" ;
       NCase _ Gen   => "minkä" ;
       NCase _ Part  => "mitä" ;
       NCase _ Illat => "mihin" ;
       c => mi.s ! c
       } ;
 
  year_alt_N = mkN "vuosi" "vuoden" "vuotta" "vuonna" "vuoteen" "vuosien" "vuosia" "vuosina" "vuosissa" "vuosiin" ; --alternative form of essive


lin a_fortiori_Adv = mkWAdv "suuremmalla" "syyllä" ; --UNCHK
lin a_la_carte_Adv = mkWAdv "a" "la" "carte" ; --UNCHK
lin a_la_mode_Adv = mkWAdv (k99 "kera") "jäätelön" ; --UNCHK
lin a_level_N = mkWN (compoundN "päättö" (k1A "tutkinto")) "lukion" ; --UNCHK
lin a_posteriori_A = mkWA (compoundA "posteri" (k48 "ori")) "a" ; --UNCHK
lin a_posteriori_Adv = mkWAdv (compoundAdv "posteri" (k48 "ori")) "a" ; --UNCHK
lin a_priori_A = mkWA (k38 "apriorinen") ; --UNCHK
lin a_priori_Adv = mkWAdv (k99 "ennalta") ; --UNCHK
lin aa_N = mkWN "AA" ; --UNCHK
lin aachen_PN = foreignPN "Aachen" ;
lin aalii_N = mkWN "aalii" ; --UNCHK
lin aardvark_N = mkWN (compoundN "muurahais" (k1 "karhu")) ; --UNCHK
lin aardwolf_N = mkWN (compoundN "maa" (k27 "susi")) ; --UNCHK
lin ab_initio_Adv = mkWAdv (k99 "aluksi") ; --UNCHK
lin aba_N = mkWN (k41A "vuohenvillakangas") ; --UNCHK
lin abaca_N = mkWN (k13 "manila") ; --UNCHK
lin aback_Adv = mkWAdv (compoundAdv "ällisty" (k99 "nyt")) ; --UNCHK
lin abactinal_A = mkWA (compoundA "abaktina" (k38 "alinen")) ; --UNCHK
lin abacus_N = mkWN (compoundN "helmi" (k1 "taulu")) ; --UNCHK
lin abaft_Adv = mkWAdv (k99 "taakse") ; --UNCHK
lin abalone_N = mkWN (compoundN "punameri" (k10 "korva")) ; --UNCHK
lin abandon_N = mkWN (k40 "estottomuus") ; --UNCHK
lin abandon_V2 = mkWV2 (k73A "hylätä") ; --f62
lin abandonment_N = mkWN "hylkääminen" ; --UNCHK
lin abarticulation_N = mkWN (compoundN "sijoiltaan" (k1 "meno")) ; --UNCHK
lin abase_V2 = mkWV2 (k54A "alentaa") ; --UNCHK
lin abasement_N = mkWN (k39 "nöyryytys") ; --UNCHK
lin abash_V2 = mkWV2 (k56A "saattaa") "häpeilemään" ; --UNCHK
lin abashment_N = mkWN (k40 "ujous") ; --UNCHK
lin abasia_N = mkWN (compoundN "kävely" (k40 "kyvyttömyys")) ; --UNCHK
lin abasic_A = mkWA (compoundA "kävely" (k34A "kyvytön")) ; --UNCHK
lin abatable_A = mkWA (k10 "oleva") "poistettavissa" ; --UNCHK
lin abate_V = mkWV (k52A "vähentyä") ;
lin abate_V2 = mkWV2 (k52A "vähentyä") ; --UNCHK
lin abatement_N = mkWN (compoundN "ale" (k38 "ntaminen")) ; --UNCHK
lin abator_N = mkWN "pienentäjä" ; --UNCHK
lin abattis_N = mkWN (k39 "murros") ; --UNCHK
lin abattoir_N = mkWN (k2 "teurastamo") ; --UNCHK
lin abaxial_A = mkWA (compoundA "selän" (k38 "puoleinen")) ; --UNCHK
lin abaya_N = mkWN "abaya" ; --UNCHK
lin abbacy_N = mkWN (compoundN "tuomio" (k9A "valta")) "apotin" ; --UNCHK
lin abbatial_A = mkWA "luostarin" ; --UNCHK
lin abbe_N = mkWN (k5A "pappi") ; --UNCHK
lin abbess_N = mkWN (k9 "abbedissa") ; --UNCHK
lin abbey_N = mkWN (k6 "luostari") ; --UNCHK
lin abbot_N = mkWN (k9A "arkkimandriitta") ; --UNCHK
lin abbreviate_V2 = mkWV2 (k54A "lyhentää") ; --UNCHK
lin abbreviation_N = mkWN "lyhentäminen" ; --UNCHK
lin abc_N = mkWN (k5A "rudimentti") ; --UNCHK
lin abcoulomb_N = mkWN "abcoulombi" ; --UNCHK
lin abdicable_A = mkWA (k10 "oleva") "luovutettavissa" ; --UNCHK
lin abdicate_V = mkWV (k52A "luopua") ; --UNCHK
lin abdicate_V2 = mkWV2 (k52A "luopua") ; --UNCHK
lin abdication_N = mkWN (compoundN "luo" (k38 "puminen")) ; --UNCHK
lin abdicator_N = mkWN "luopuja" ; --UNCHK
lin abdomen_N = mkWN (k9 "maha") ; --UNCHK
lin abdominal_A = mkWA (compoundA "abdomina" (k38 "alinen")) ; --UNCHK
lin abdominal_N = mkWN (compoundN "vatsa" (k39 "lihas")) ; --UNCHK
lin abdominocentesis_N = mkWN (compoundN "parasen" (k5 "teesi")) ; --UNCHK
lin abdominoplasty_N = mkWN (compoundN "muotoilu" (k39 "leikkaus")) "vatsan" ; --UNCHK
lin abdominous_A = mkWA (k41A "vatsakas") ; --UNCHK
lin abdominousness_N = mkWN (k40 "vatsakkuus") ; --UNCHK
lin abdominovesical_A = mkWA (compoundA "abdominaalivesika" (k38 "alinen")) ; --UNCHK
lin abducent_A = mkWA "loitontava" ; --UNCHK
lin abducent_N = mkWN (compoundN "aivo" (k1 "hermo")) "kuudes" ; --UNCHK
lin abduct_V2 = mkWV2 (k54A "loitontaa") ; --UNCHK
lin abduction_N = mkWN (k39 "loitonnus") ; --UNCHK
lin abeam_Adv = mkWAdv (k99 "kyljittäin") ; --UNCHK
lin abecedarian_A = mkWA (k38 "aakkosellinen") ; --UNCHK
lin abecedarian_N = mkWN (compoundN "ana" (k5 "baptisti")) ; --UNCHK
lin abecedarius_N = mkWN (compoundN "aakkos" (k1 "runo")) ; --UNCHK
lin abed_Adv = mkWAdv (k9 "vuoteenomana") ; --UNCHK
lin abelia_N = mkWN "abelia" ; --UNCHK
lin abelmosk_N = mkWN (compoundN "myski" (k9 "malva")) ; --UNCHK
lin abercarn_PN = foreignPN "Abercarn" ;
lin aberdare_PN = foreignPN "Aberdare" ;
lin aberdeen_PN = foreignPN "Aberdeen" ;
lin abergavenny_PN = foreignPN "Abergavenny" ;
lin abergele_PN = foreignPN "Abergele" ;
lin aberrance_N = mkWN (k48 "virhe") ; --UNCHK
lin aberrant_A = mkWA (k10 "poikkeava") ; --UNCHK
lin aberrant_N = mkWN (k10 "poikkeava") ; --UNCHK
lin aberration_N = mkWN (k10 "poikkeama") "optinen" ; --UNCHK
lin abertillery_PN = foreignPN "Abertillery" ;
lin aberystwyth_PN = foreignPN "Aberystwyth" ;
lin abet_V = mkWV (k53 "avustaa") ; --UNCHK
lin abet_V2 = mkWV2 (k53 "avustaa") ; --UNCHK
lin abetalipoproteinemia_N = mkWN "abeetalipoproteinemia" ; --UNCHK
lin abetment_N = mkWN (k39 "yllytys") ; --UNCHK
lin abettor_N = mkWN (k10 "yllyttäjä") ; --UNCHK
lin abeyance_N = mkWN (k39 "jäädytys") ; --UNCHK
lin abeyant_A = mkWA (compoundA "nuk" (k10 "kuva")) ; --UNCHK
lin abfarad_N = mkWN "abfaradi" ; --UNCHK
lin abhenry_N = mkWN "abhenry" ; --UNCHK
lin abhor_V2 = mkWV2 (k73 "vihata") ; --UNCHK
lin abhorrence_N = mkWN (k39 "iljetys") ; --UNCHK
lin abhorrent_A = mkWA (k10 "luotaantyöntävä") ; --UNCHK
lin abhorrer_N = mkWN "inhoaja" ; --UNCHK
lin abidance_N = mkWN "kestäminen" ; --UNCHK
lin abide_V = mkWV (k69 "suvaita") ; --UNCHK
lin abide_V2 = mkWV2 (k69 "suvaita") ; --UNCHK
lin abide_by_V2 = mkWV2 (k53A "kunnioittaa") ; --UNCHK
lin abience_N = mkWN "abienssi" ; --UNCHK
lin abient_A = mkWA (compoundA "abi" (k38 "enttinen")) ; --UNCHK
lin ability_N = mkN "kyky" ;
lin abingdon_PN = foreignPN "Abingdon" ;
lin abiogenesis_N = mkWN (compoundN "alku" (k1A "synty")) ; --UNCHK
lin abiogenetic_A = mkWA (compoundA "abio" (k38 "geneettinen")) ; --UNCHK
lin abiogenist_N = mkWN (k10 "uskova") "alkusyntyyn" ; --UNCHK
lin abiotrophy_N = mkWN "abiotrofia" ; --UNCHK
lin abject_A = mkWA (compoundA "nöyriste" (k10 "levä")) ; --UNCHK
lin abjection_N = mkWN (k3 "rappio") ; --UNCHK
lin abjuration_N = mkWN (compoundN "per" (k38 "uminen")) ; --UNCHK
lin abjure_V2 = mkWV2 (k53A "peruuttaa") ; --UNCHK
lin abjurer_N = mkWN (k10 "kieltäjä") ; --UNCHK
lin ablactation_N = mkWN (k39 "vieroitus") ; --UNCHK
lin ablated_A = mkWA (compoundA "sula" (k47 "nut")) ; --UNCHK
lin ablation_N = mkWN (compoundN "pois" (k38 "leikkaaminen")) ; --UNCHK
lin ablative_A = mkWA (compoundA "ablatiivi" (k38 "nen")) ; --UNCHK
lin ablative_N = mkWN (k5 "ablatiivi") ; --UNCHK
lin ablaut_N = mkWN "äänteenmukaus" ; --UNCHK
lin ablaze_A = mkWA (compoundA "heh" (k10 "kuva")) ; --UNCHK
lin able_A = mkA "kykenevä" ;
lin ableism_N = mkWN (k9A "syrjintä") "vammaisten" ; --UNCHK
lin ablepharia_N = mkWN (compoundN "puu" (k38 "ttuminen")) "silmäluomien" "synnynnäinen" ; --UNCHK
lin abloom_A = mkWA (compoundA "kuk" (k9 "kiva")) ; --UNCHK
lin ablution_N = mkWN "peseytyminen" ; --UNCHK
lin ablutionary_A = mkWA "puhdistautumis-" ; --UNCHK
lin abnegation_N = mkWN (k39 "kieltäymys") ; --UNCHK
lin abnegator_N = mkWN (k10 "luovuttaja") ; --UNCHK
lin abnormal_A = mkWA (k10 "poikkeava") ; --UNCHK
lin abnormality_N = mkWN (k40 "poikkeavuus") ; --UNCHK
lin abo_N = mkWN (k5 "aboriginaali") "Australian" ; --UNCHK
lin aboard_Adv = mkWAdv (k10 "pesässä") ; --UNCHK
lin aboard_Prep = mkPrep "kannella" ;
lin abocclusion_N = mkWN "abokkluusio" ; --UNCHK
lin abode_N = mkWN (k1A "asunto") ; --UNCHK
lin abohm_N = mkWN "abohmi" ; --UNCHK
lin abolish_V2 = mkWV2 (k53A "lopettaa") ; --UNCHK
lin abolishable_A = mkWA (k10 "oleva") "poistettavissa" ; --UNCHK
lin abolition_N = mkWN (compoundN "lakka" (k38 "uttaminen")) "orjuuden" ; --UNCHK
lin abolitionary_A = mkWA "lakkautus-" ; --UNCHK
lin abolitionism_N = mkWN (compoundN "abolition" (k5 "ismi")) ; --UNCHK
lin abolitionist_N = mkWN (k10 "kannattaja") "emansipaation" ; --UNCHK
lin abomasal_A = mkWA "juoksutusmahan" ; --UNCHK
lin abomasum_N = mkWN (k9 "vatsa") "neljäs" ; --UNCHK
lin abominable_A = mkWA (k38 "tuskallinen") ; --UNCHK
lin abominate_V2 = mkWV2 (k73 "vihata") ; --UNCHK
lin abomination_N = mkWN (k40 "inhottavuus") ; --UNCHK
lin abominator_N = mkWN (k10 "vihaaja") ; --UNCHK
lin aborad_Adv = mkWAdv "aboradisesti" ; --UNCHK
lin aboral_A = mkWA (compoundA "abora" (k38 "alinen")) ; --UNCHK
lin aboriginal_A = mkWA (k5 "aboriginaali") ; --UNCHK
lin aborigine_N = mkWN (compoundN "alku" (k41A "asukas")) ; --UNCHK
lin abort_N = mkWN (k39 "keskeytys") ; --UNCHK
lin abort_V = mkWV (k71 "tehdä") "abortti" ; --UNCHK
lin abort_V2 = mkWV2 (k71 "tehdä") "abortti" ; --UNCHK
lin aborticide_N = mkWN (compoundN "raskauden" (k39 "keskeytys")) ; --UNCHK
lin abortifacient_A = mkWA "keskenmenon" "aiheuttava" ; --UNCHK
lin abortifacient_N = mkWN (k48 "aine") "keskenmenon" "aiheuttava" ; --UNCHK
lin abortion_N = mkWN (k5A "abortti") ;
lin abortionistFem_N = mkWN "sikiönlähdettäjä" ; --UNCHK
lin abortionistMasc_N = mkWN "sikiönlähdettäjä" ; --UNCHK
lin abortive_A = mkWA (k10 "turha") ; --UNCHK
lin abortus_N = mkWN (k3 "sikiö") "abortoitu" ; --UNCHK
lin abound_V = caseV partitive (mkV vOlla "runsaasti") ;
lin about_AdN = mkAdN "noin" ;
lin about_Adv = mkAdv "suunnilleen" ;
lin about_Prep = casePrep elative ;
lin above_A = mkWA (compoundA "main" (k1 "ittu")) "edellä" ; --UNCHK
lin above_Adv = mkAdv "yläpuolella" ;
lin above_N = mkWN (compoundN "main" (k1 "ittu")) "yllä" ; --UNCHK
lin above_Prep = S.above_Prep ;
lin above_board_A = mkA "avoin" ;
lin aboveboard_A = mkWA (k34A "vilpitön") ; --UNCHK
lin aboveground_A = mkWA (k99 "päällä") "maan" ; --UNCHK
lin abracadabra_N = mkWN (compoundN "hölyn" (k1 "pöly")) ; --UNCHK
lin abrachia_N = mkWN "abrakia" ; --UNCHK
lin abrade_V2 = mkWV2 (k73A "hangata") ; --UNCHK
lin abrader_N = mkWN (compoundN "hioma-" (k48 "aine")) ; --UNCHK
lin abranchiate_A = mkWA "kidukseton" ; --UNCHK
lin abrasion_N = mkWN (compoundN "han" (k38 "kautuminen")) ; --UNCHK
lin abrasive_A = mkWA (k1 "tyly") ; --UNCHK
lin abrasive_N = mkWN (compoundN "hankaus" (k48 "aine")) ; --UNCHK
lin abrasiveness_N = mkWN (k40 "ikävyys") ; --UNCHK
lin abreast_Adv = mkWAdv (k99 "vierekkäin") ; --UNCHK
lin abridge_V2 = mkWV2 (k54A "vähentää") ; --UNCHK
lin abridgement_N = mkWN (k10 "lyhennelmä") ; --UNCHK
lin abridger_N = mkWN "lyhentäjä" ; --UNCHK
lin abroach_A = mkWA (k10 "oleva") "avattuna" ; --UNCHK
lin abroad_A = mkWA (k38 "ulkomainen") ; --UNCHK
lin abroad_Adv = mkWAdv "ulkomailla" ; --f56
lin abrocome_N = mkWN (compoundN "rotta" (k9 "chinchilla")) ; --UNCHK
lin abrogate_V2 = mkWV2 (k53A "lopettaa") ; --UNCHK
lin abrogation_N = mkWN (compoundN "pois" (k38 "taminen")) ; --UNCHK
lin abrogator_N = mkWN "poistaja" ; --UNCHK
lin abrupt_A = mkWA (k15 "karkea") ; --UNCHK
lin abruptness_N = mkWN (k40 "karkeus") ; --UNCHK
lin abscess_N = mkWN (k39 "ajos") ; --UNCHK
lin abscessed_A = mkWA "märkivä" ; --UNCHK
lin abscissa_N = mkWN (k9 "abskissa") ; --UNCHK
lin abscission_N = mkWN (compoundN "lei" (k38 "kkaaminen")) "irti" ; --UNCHK
lin abscond_V = mkWV (k60A "lähteä") "tiehensä" ; --UNCHK
lin absconder_N = mkWN (k38 "karkulainen") ; --UNCHK
lin abscondment_N = mkWN (k1A "pako") ; --UNCHK
lin abseiler_N = mkWN "laskeutuja" ; --UNCHK
lin absence_N = mkN "poissaolo" ; --WN (compoundN "jää" (k38 "minen")) "saapumatta" ;
lin absent_A = mkWA (compoundA "poissa" (k10 "oleva")) ; --UNCHK
lin absent_Prep = mkPrep "poissa" elative ;
lin absent_V2 = mkWV2 (k60A "lähteä") ; --UNCHK
lin absentee_N = mkWN (compoundN "poissa" (k12 "olija")) ; --UNCHK
lin absenteeism_N = mkWN (compoundN "poissa" (k1 "olo")) "toistuva" ; --UNCHK
lin absentmindedness_N = mkWN (compoundN "hajamiel" (k40 "isyys")) ; --UNCHK
lin absinthe_N = mkWN (k5A "absintti") ; --UNCHK
lin absolute_A = mkA "ehdoton" | mkA "absoluuttinen" ;
lin absolute_N = mkWN (k5A "absoluutti") ; --UNCHK
lin absoluteness_N = mkWN (k40 "ehdottomuus") ; --UNCHK
lin absolution_N = mkWN (compoundN "anteeksi" (k1A "anto")) "synnin" ; --UNCHK
lin absolutism_N = mkWN (k5 "absolutismi") ; --UNCHK
lin absolutist_A = mkWA (compoundA "yksin" (k38 "valtainen")) ; --UNCHK
lin absolutist_N = mkWN (k5 "absolutisti") ; --UNCHK
lin absolve_V2 = mkWV2 (k53 "päästää") "vapaaksi" ; --UNCHK
lin absolver_N = mkWN (k10 "antaja") "synninpäästön" ; --UNCHK
lin absolvitory_A = mkWA (k10 "anteeksiantava") ; --UNCHK
lin absorb_V2 = mkV2 "imeä" ;
lin absorbable_A = mkWA (k10 "oleva") "imeytettävissä" ; --UNCHK
lin absorbefacient_A = mkWA "sorptiota" "edistävä" ; --UNCHK
lin absorbency_N = mkWN (compoundN "imu" (k1A "kyky")) ; --UNCHK
lin absorbent_A = mkWA (compoundA "absorptioky" (k38 "kyinen")) ; --UNCHK
lin absorbent_N = mkWN (k48 "aine") "absorboiva" ; --UNCHK
lin absorbing_A = mkWA (k10 "mukaansatempaava") ; --UNCHK
lin absorption_N = mkWN (compoundN "päähän" (k10 "piintymä")) ; --UNCHK
lin absorptivity_N = mkWN (k33A "absorptiokerroin") ; --UNCHK
lin abstain_V = mkWV (k52A "pidättäytyä") ; --UNCHK
lin abstainer_N = mkWN (k38 "ihminen") "raitis" ; --UNCHK
lin abstemious_A = mkWA (k10 "pidättyvä") ; --UNCHK
lin abstemiousness_N = mkWN (k40 "kohtuullisuus") ; --UNCHK
lin abstention_N = mkWN (k40 "pidättyvyys") ; --UNCHK
lin abstinence_N = mkWN (k40 "pidättyvyys") ; --UNCHK
lin abstinent_A = mkWA (k10 "pidättyvä") ; --UNCHK
lin abstract_A = mkWA (k38 "käsitteellinen") ; --UNCHK
lin abstract_N = mkWN (k3 "abstraktio") ; --UNCHK
lin abstract_V2 = mkWV2 (k62 "abstrahoida") ; --UNCHK
lin abstractedness_N = mkWN (compoundN "keskittyne" (k40 "isyys")) ; --UNCHK
lin abstraction_N = mkWN (k5A "entiteetti") "abstrakti" ; --UNCHK
lin abstractionism_N = mkWN (k48A "taide") "abstrakti" ; --UNCHK
lin abstractionist_N = mkWN (k12 "taiteilija") "abstrakti" ; --UNCHK
lin abstractive_A = mkWA (compoundA "abstr" (k38 "aktiivinen")) ; --UNCHK
lin abstractness_N = mkWN (k40 "abstraktius") ; --UNCHK
lin abstractor_N = mkWN (k12 "laatija") "abstraktin" ; --UNCHK
lin abstruse_A = mkWA (k38 "vaikeaselkoinen") ; --UNCHK
lin abstruseness_N = mkWN (compoundN "vaikea" (k40 "tajuisuus")) ; --UNCHK
lin absurd_A = mkWA (k34A "mahdoton") ; --UNCHK
lin absurd_N = mkWN (k40 "absurdius") ; --UNCHK
lin absurdity_N = mkWN (k40 "mielettömyys") ; --UNCHK
lin abulia_N = mkWN (compoundN "tahdon" (k40 "heikkous")) ; --UNCHK
lin abulic_A = mkWA (k34A "tahdoton") ; --UNCHK
lin abundance_N = mkWN (k40 "paljous") ; --UNCHK
lin abundant_A = mkWA (k41 "runsas") ;
lin abuse_N = mkN "väärinkäyttö" ; --C "hyväksikäyttö" ;
lin abuse_V2 = mkWV2 (k53A "käyttää") "väärin" ; ---ARB --mkV2 "solvata" partitive ; --mkV2 (mkV (mkV "käyttää") "hyväkseen") partitive ;
lin abuser_N = mkWN (k12 "pahoinpitelijä") ; --UNCHK
lin abusive_A = mkWA "pahoin" "kohteleva" ; --UNCHK
lin abut_V = mkWV (k52A "liittyä") "päittäin" ; --UNCHK
lin abutment_N = mkWN (compoundN "tuki" (k10 "pohja")) ; --UNCHK
lin abutter_N = mkWN (compoundN "raja" (k6 "naapuri")) ; --UNCHK
lin abuzz_A = mkWA "suriseva" ; --UNCHK
lin abvolt_N = mkWN "abvoltti" ; --UNCHK
lin abwatt_N = mkWN "abwatti" ; --UNCHK
lin abysm_N = mkWN (k1 "kuilu") ; --UNCHK
lin abysmal_A = mkWA (k34A "mittaamaton") ; --UNCHK
lin abyss_N = mkWN (k1 "kuilu") ; --UNCHK
lin abyssal_A = mkWA (compoundA "abyssa" (k38 "alinen")) ; --UNCHK
lin acacia_N = mkWN (k12 "akasia") ; --UNCHK
lin academia_N = mkWN (k13 "maailma") "akateeminen" ; --UNCHK
lin academic_A = mkA (lin AK {s = d38 "akateeminen"}) ;
lin academic_N = mkN (mkN "akateeminen") (mkN "henkilö") ;
lin academicianFem_N = mkWN (k32 "jäsen") "tiedekunnan" ; --UNCHK
lin academicianMasc_N = mkWN (k32 "jäsen") "tiedekunnan" ; --UNCHK
lin academicianship_N = mkWN "kunniatohtorius" ; --UNCHK
lin academy_N = mkWN (k50 "korkeakoulu") ; --UNCHK
lin acanthion_N = mkWN "akantion" ; --UNCHK
lin acanthocephalan_N = mkWN (compoundN "väkä" (k1A "mato")) ; --UNCHK
lin acanthocyte_N = mkWN "akantosyytti" ; --UNCHK
lin acanthocytosis_N = mkWN "akantosytoosi" ; --UNCHK
lin acanthoid_A = mkWA (compoundA "oka" (k38 "mainen")) ; --UNCHK
lin acantholysis_N = mkWN (compoundN "akantoly" (k5 "ysi")) ; --UNCHK
lin acanthoma_N = mkWN (compoundN "iho" (k33 "kasvain")) ; --UNCHK
lin acanthosis_N = mkWN "akantoosi" ; --UNCHK
lin acanthotic_A = mkWA "akantoottinen" ; --UNCHK
lin acanthus_N = mkWN (k5A "akantti") ; --UNCHK
lin acapnic_A = mkWA "akapnoottinen" ; --UNCHK
lin acardia_N = mkWN (compoundN "akar" (k9 "dia")) ; --UNCHK
lin acariasis_N = mkWN (compoundN "punkki" (k5A "tauti")) ; --UNCHK
lin acaricide_N = mkWN (compoundN "punkkientorjunta-" (k48 "aine")) ; --UNCHK
lin acarid_N = mkWN "akaridi" ; --UNCHK
lin acarine_N = mkWN (kH1 "punkki") ; --UNCHK
lin acarophobia_N = mkWN (compoundN "akaro" (k12 "fobia")) ; --UNCHK
lin acarpelous_A = mkWA "emitön" ; --UNCHK
lin acarpous_A = mkWA (k34A "hedelmätön") ; --UNCHK
lin acarus_N = mkWN (kH1 "punkki") ; --UNCHK
lin acatalectic_A = mkWA "akatalektinen" ; --UNCHK
lin acatalectic_N = mkWN "akatalekti" ; --UNCHK
lin acathexia_N = mkWN "akateksia" ; --UNCHK
lin acathexis_N = mkWN "akateksis" ; --UNCHK
lin acaudate_A = mkWA (compoundA "akauda" (k38 "alinen")) ; --UNCHK
lin acaulescent_A = mkWA "varreton" ; --UNCHK
lin accede_V = mkWV (k52 "suostua") ; --UNCHK
lin accelerando_A = mkWA "nopeutuvatempoinen" ; --UNCHK
lin accelerando_Adv = mkWAdv "nopeutuvassa" "tempossa" ; --UNCHK
lin accelerando_N = mkWN (k1 "tempo") "nopeutuva" ; --UNCHK
lin accelerate_V = mkWV (k73 "lisätä") "vauhtia" ; --UNCHK
lin accelerate_V2 = mkV2 "kiihdyttää" ;
lin acceleration_N = mkWN (k39 "kiihdytys") ;
lin accelerative_A = mkWA "nopeuttava" ; --UNCHK
lin accelerator_N = mkWN (k6 "venttiili") "kaasuttimen" ; --UNCHK
lin accelerometer_N = mkWN (compoundN "mittaus" (k48A "laite")) "kiihtyvyyden" ; --UNCHK
lin accent_N = mkWN (k5A "aksentti") ; --UNCHK
lin accent_V2 = mkWV2 (k53A "painottaa") ; --UNCHK
lin accentor_N = mkWN (k38 "rautiainen") ; --UNCHK
lin accentual_A = mkWA "painotusta" "koskeva" ; --UNCHK
lin accentuate_V2 = mkWV2 (k53A "painottaa") ; --UNCHK
lin accentuation_N = mkWN (compoundN "tähde" (k38 "ntäminen")) ; --UNCHK
lin accept_V = mkV "hyväksyä" ;
lin accept_V2 = mkV2 "hyväksyä" ;
lin accept_VS = mkVS (mkV "hyväksyä") ;
lin acceptability_N = mkWN (k40 "hyväksyttävyys") ; --UNCHK
lin acceptable_A = mkWA (k10 "tyydyttävä") ; --UNCHK
lin acceptance_N = mkWN (compoundN "vastaan" (k1A "otto")) ; --UNCHK
lin acceptation_N = mkWN (k10A "hyväksyntä") ; --UNCHK
lin acceptive_A = mkWA (compoundA "hyväk" (k10 "syvä")) ; --UNCHK
lin acceptor_N = mkWN (k10 "tunnustaja") "vekselin" ; --UNCHK
lin access_N = mkWN (k1 "pääsy") ;
lin access_V2 = mkV2 (mkV "päästä") (casePrep illative) ;
lin accessary_A = mkWA (k38 "osallinen") ; --UNCHK
lin accessary_N = mkWN (k38 "osallinen") "rikokseen" ; --UNCHK
lin accessibility_N = mkWN (k40 "saavutettavuus") ; --UNCHK
lin accessible_A = mkWA "päästävä" ; --UNCHK
lin accession_N = mkWN (k1 "nousu") "valtaistuimelle" ; --UNCHK
lin accessional_A = mkWA "virkaanastumis-" ; --UNCHK
lin accessorial_A = mkWA "oheis-" ; --UNCHK
lin accessory_A = mkWA (k10 "kuuluva") ; --UNCHK
lin accessory_N = mkWN (k48 "varuste") ; --UNCHK
lin accidence_N = mkWN (compoundN "taivutus" (k5A "oppi")) ; --UNCHK
lin accident_N = mkN "onnettomuus" | mkN "sattuma" ; ---- split
lin accidental_A = mkWA (k34A "tahaton") ; --UNCHK
lin accidental_N = mkWN (compoundN "etu" (k5A "merkki")) "tilapäinen" ; --UNCHK
lin accipitrine_A = mkWA (compoundA "haukka" (k38 "mainen")) ; --UNCHK
lin acclaim_N = mkWN (k39 "menestys") "suuri" ; --UNCHK
lin acclaim_V2 = mkWV2 (k53 "julistaa") ; --UNCHK
lin acclamation_N = mkWN (k39 "menestys") "suuri" ; --UNCHK
lin acclimate_V = mkWV (k52A "tottua") "ilmastoon" ; --UNCHK
lin acclimate_V2 = mkWV2 (k52A "tottua") "ilmastoon" ; --UNCHK
lin acclimation_N = mkWN (k3 "akklimatisaatio") ; --UNCHK
lin acclimatization_N = mkWN (k3 "akklimatisaatio") ; --UNCHK
lin acclimatize_V = mkWV (k52A "tottua") "ilmastoon" ; --UNCHK
lin acclimatize_V2 = mkWV2 (k52A "tottua") "ilmastoon" ; --UNCHK
lin acclivitous_A = mkWA "ylöspäin" "viettävä" ; --UNCHK
lin acclivity_N = mkWN (k1 "nousu") ; --UNCHK
lin accolade_N = mkWN (k1A "palkinto") ; --UNCHK
lin accommodate_V = mkWV (k54A "soveltaa") ; --UNCHK
lin accommodate_V2 = mkWV2 (k54A "soveltaa") ; --UNCHK
lin accommodation_N = mkWN (k3 "akkommodaatio") ; --UNCHK
lin accommodational_A = mkWA "mukautumis-" ; --UNCHK
lin accommodative_A = mkWA (k41 "avulias") ; --UNCHK
lin accompaniment_N = mkWN "saattaminen" ; --UNCHK
lin accompanist_N = mkWN (k10 "säestäjä") ; --UNCHK
lin accompany_V2 = mkWV2 (k73 "seurata") ;
lin accomplice_N = mkWN (k38 "osallinen") ; --UNCHK
lin accomplish_V2 = mkWV2 (k56A "saattaa") "voimaan" ; --UNCHK
lin accomplishable_A = mkWA (k10 "oleva") "toteutettavissa" ; --UNCHK
lin accomplishment_N = mkN "saavutus" ; --mkWN (k1A "teko") ;
lin accord_N = mkWN (k12 "harmonia") ; --f65
lin accord_V = mkWV (k73 "määrätä") ; --UNCHK
lin accordance_N = mkWN (compoundN "suo" (k38 "minen")) ; --UNCHK
lin accordant_A = mkWA (k10 "vastaava") ; --UNCHK
lin according_to_Prep = postPrep genitive "mukaan" ;
lin accordingly_Adv = mkWAdv (k99 "asianmukaisesti") ;
lin accordion_N = mkWN (k1A "kurttu") ; --UNCHK
lin accordionist_N = mkWN (k5 "hanuristi") ; --UNCHK
lin accost_V2 = mkWV2 (k67 "ahdistella") ; --UNCHK
lin accouchement_N = mkWN (k39 "synnytys") ; --UNCHK
lin account_N = mkN "selvitys" ;
lin account_V = mkWV (k73 "vastata") ; --f163
lin account_V2 = mkWV2 (k73 "vastata") ; --UNCHK
lin account_for_V2 = mkWV2 (k53A "selittää") ; --UNCHK
lin accountability_N = mkWN (k17 "vastuu") ; --UNCHK
lin accountable_A = mkWA (k10 "oleva") "vastuussa" ; --UNCHK
lin accountancy_N = mkWN (compoundN "laskenta" (k25 "toimi")) ; --UNCHK
lin accountant_N = mkWN (k10 "valvoja") "varainhoidon" ; --UNCHK
lin accountantship_N = mkWN (k10 "asema") "kirjanpitäjän" ; --UNCHK
lin accounting_A = variants {} ; --
lin accounting_N = mkWN (compoundN "laskenta" (k25 "toimi")) ; --UNCHK
lin accoutered_A = mkWA (compoundA "varus" (k1 "tettu")) ; --UNCHK
lin accra_PN = foreignPN "Accra" ;
lin accredit_V2 = mkWV2 (k56A "antaa") "tunnustus" ; --UNCHK
lin accreditation_N = mkWN (k39 "valtuutus") ; --UNCHK
lin accretion_N = mkWN "akresenssi" ; --UNCHK
lin accretionary_A = mkWA "vesijättö-" ; --UNCHK
lin accretive_A = mkWA "yhteen" "kasvava" ; --UNCHK
lin accrington_PN = foreignPN "Accrington" ;
lin accrue_V = mkWV (k56 "kasvaa") ; --UNCHK
lin accrue_V2 = mkWV2 (k56 "kasvaa") ; --UNCHK
lin acculturation_N = mkWN (k3 "sosialisaatio") ; --UNCHK
lin acculturational_A = mkWA (compoundA "akku" (k38 "lturatiivinen")) ; --UNCHK
lin accumbent_A = mkWA (compoundA "mak" (k9 "aava")) ; --UNCHK
lin accumulate_V = mkWV (k52A "kertyä") ; --UNCHK
lin accumulate_V2 = mkV2 "kerryttää" partitive ;
lin accumulation_N = mkN "kertyminen" ;
lin accumulative_A = mkWA "kasautumis-" ; --UNCHK
lin accumulator_N = mkWN (k6 "rekisteri") ; --UNCHK
lin accuracy_N = mkWN (k40 "totuus") ; --UNCHK
lin accurate_A = mkWA (k34A "virheetön") ; --UNCHK
lin accursed_A = mkWA (k10 "mokoma") ; --UNCHK
lin accurst_A = mkWA (k10 "mokoma") ; --UNCHK
lin accusation_N = mkWN (k39 "syytös") ; --UNCHK
lin accusative_A = mkWA "akkusatiivi-" ; --UNCHK
lin accusative_N = mkWN (k9 "sija") "objektin" ; --UNCHK
lin accusatorial_A = mkWA (compoundA "syy" (k38 "tepohjainen")) ; --UNCHK
lin accuse_V2 = mkWV2 (k53A "syyttää") "rikoksesta" ; --f79
lin accused_A = mkA "syytetty" ;
lin accused_N = mkWN (k10 "vastaaja") ; --UNCHK
lin accuserFem_N = mkWN (k10 "syyttäjä") ; --UNCHK
lin accuserMasc_N = mkWN (k10 "syyttäjä") ; --UNCHK
lin accusingly_Adv = mkWAdv "syyttävästi" ; --UNCHK
lin accustom_V2 = mkWV2 (k53A "sopeuttaa") ; --UNCHK
lin ace_A = mkWA (k38 "erinomainen") ; --UNCHK
lin ace_N = mkWN (compoundN "läpi" (k1A "syöttö")) ; --UNCHK
lin acebutolol_N = mkWN "Sectral" ; --UNCHK
lin acentric_A = mkWA (compoundA "ase" (k38 "ntrinen")) ; --UNCHK
lin acephalia_N = mkWN "akefalia" ; --UNCHK
lin acephalous_A = mkWA (compoundA "akefa" (k38 "alinen")) ; --UNCHK
lin acerate_A = mkWA (compoundA "neulas" (k38 "mainen")) ; --UNCHK
lin acerb_A = mkWA (k38 "sarkastinen") ; --UNCHK
lin acerbity_N = mkWN (k40 "piikikkyys") ; --UNCHK
lin acerola_N = mkWN (compoundN "acerola" (k14A "kirsikka")) ; --UNCHK
lin acervate_A = mkWA "ryppäinä" "kasvava" ; --UNCHK
lin acervulus_N = mkWN "acervulus" ; --UNCHK
lin acetabulum_N = mkWN (compoundN "nivel" (k10A "kuoppa")) ; --UNCHK
lin acetaldol_N = mkWN "asetaldoli" ; --UNCHK
lin acetamide_N = mkWN (k5 "etaaniamidi") ; --UNCHK
lin acetaminophen_N = mkWN "parasetamoli" ; --UNCHK
lin acetanilide_N = mkWN (k5 "fenyyliasetamidi") ; --UNCHK
lin acetate_N = mkWN (k5A "asetaatti") ;
lin acetic_A = mkWA "etikkahappo-" ; --UNCHK
lin acetin_N = mkWN "asetiini" ; --UNCHK
lin acetone_N = mkWN (k5 "asetoni") ; --UNCHK
lin acetonic_A = mkWA "asetoni-" ; --UNCHK
lin acetophenetidin_N = mkWN "fenasetiini" ; --UNCHK
lin acetose_A = mkWA (compoundA "etikan" (k38 "hajuinen")) ; --UNCHK
lin acetum_N = mkWN (k14A "etikka") ; --UNCHK
lin acetyl_N = mkWN (compoundN "ase" (k5 "tyyli")) ; --UNCHK
lin acetylation_N = mkWN "asetylaatio" ; --UNCHK
lin acetylcholine_N = mkWN "asetyylikoliini" ; --UNCHK
lin acetylene_N = mkWN (k5 "asetyleeni") ; --UNCHK
lin acetylenic_A = mkWA "asetyleeni-" ; --UNCHK
lin acetylic_A = mkWA "asetyyli-" ; --UNCHK
lin ache_N = mkWN (k1A "särky") ; --UNCHK
lin ache_V = mkWV (k52A "riutua") "ikävästä" ; --UNCHK
lin achene_N = mkWN (k12 "pähkylä") ; --UNCHK
lin achenial_A = mkWA "pähkylä-" ; --UNCHK
lin achievability_N = mkWN (k40 "saavutettavuus") ; --UNCHK
lin achievable_A = mkWA (k10 "oleva") "toteutettavissa" ; --UNCHK
lin achieve_V2 = mkV2 "saavuttaa" ;
lin achievement_N = mkWN (k1A "teko") ; --UNCHK
lin achiever_N = mkWN "menestyjä" ; --UNCHK
lin achillea_N = mkWN (k2 "kärsämö") ; --UNCHK
lin achimenes_N = mkWN (k9A "hilkka") ; --UNCHK
lin achira_N = mkWN (k26 "nuolijuuri") ; --UNCHK
lin achlamydeous_A = mkWA "kehätön" ; --UNCHK
lin achlorhydria_N = mkWN "hapottomuus" ; --UNCHK
lin achlorhydric_A = mkWA "hapoton" ; --UNCHK
lin achondrite_N = mkWN (compoundN "akond" (k5A "riitti")) ; --UNCHK
lin achondritic_A = mkWA "akondriittinen" ; --UNCHK
lin achondroplasia_N = mkWN (compoundN "osteo" (k5 "skleroosi")) "synnynnäinen" ; --UNCHK
lin achondroplastic_A = mkWA (compoundA "akondrop" (k38 "lasinen")) ; --UNCHK
lin achromatic_A = mkWA (k6 "neutraali") ; --UNCHK
lin achromatin_N = mkWN "akromatiini" ; --UNCHK
lin achromatinic_A = mkWA "akromatiininen" ; --UNCHK
lin achromatous_A = mkWA "akromaattinen" ; --UNCHK
lin achromia_N = mkWN (k40 "värittömyys") ; --UNCHK
lin achromic_A = mkWA (k34A "väritön") ; --UNCHK
lin achylia_N = mkWN "mahanesteen" "hapottomuus" ; --UNCHK
lin acicula_N = mkWN (k38 "neulanen") ; --UNCHK
lin aciculate_A = mkWA "neulas-" ; --UNCHK
lin acid_A = mkWA (k33A "hapan") ; --UNCHK
lin acid_N = mkWN (k1A "happo") ;
lin acidemia_N = mkWN (compoundN "hapan" (k40 "verisyys")) ; --UNCHK
lin acidic_A = mkWA (k33A "hapan") ; --UNCHK
lin acidification_N = mkWN "asidifikaatio" ; --UNCHK
lin acidify_V = mkWV (k52A "happamoitua") ; --UNCHK
lin acidify_V2 = mkWV2 (k52A "happamoitua") ; --UNCHK
lin acidimetric_A = mkWA (compoundA "asidi" (k38 "metrinen")) ; --UNCHK
lin acidimetry_N = mkWN "happopitoisuuden" "määrittäminen" ; --UNCHK
lin acidity_N = mkWN (k40 "happamuus") ; --UNCHK
lin acidophil_N = mkWN "asidofiili" ; --UNCHK
lin acidophilic_A = mkWA "asidofiilinen" ; --UNCHK
lin acidophilus_N = mkWN "Lactobacillus" "acidophilus" ; --UNCHK
lin acidosis_N = mkWN (compoundN "happo" (k39 "myrkytys")) ; --UNCHK
lin acidotic_A = mkWA "asidoottinen" ; --UNCHK
lin acidulous_A = mkWA (k41A "hapokas") ; --UNCHK
lin acinar_A = mkWA "asinoosinen" ; --UNCHK
lin acinus_N = mkWN (compoundN "rauhas" (k12 "rakkula")) ; --UNCHK
lin ackee_N = mkWN (compoundN "aki" (k1 "luumu")) ; --UNCHK
lin acknowledge_V2 = mkWV2 (k54A "myöntää") ; --UNCHK
lin acknowledge_VS = mkWVS (k54A "myöntää") ;
lin acknowledgeable_A = mkWA (k10 "oleva") "tunnustettavissa" ; --UNCHK
lin acknowledgement_N = mkWN (k5A "merkki") "tunnistamisen" ; --UNCHK
lin acme_N = mkWN (k1A "huippu") ; --UNCHK
lin acne_N = mkWN (k8 "akne") ; --UNCHK
lin acned_A = mkWA (k38 "näppyläinen") ; --UNCHK
lin acneiform_A = mkWA (k38 "kaltainen") "aknen" ; --UNCHK
lin acold_A = mkWA "paleleva" ; --UNCHK
lin acolyte_N = mkWN (k5A "pappi") "avustava" ; --UNCHK
lin aconite_N = mkWN "aitoukonhattu" ; --UNCHK
lin acorea_N = mkWN "akorea" ; --UNCHK
lin acorn_N = mkWN (compoundN "tammen" (k1 "terho")) ; --UNCHK
lin acorn_cup_N = mkWN (k1A "kehto") "tammenterhon" ; --UNCHK
lin acoustic_A = mkWA (k38 "akustinen") ; --UNCHK
lin acoustic_N = mkWN (compoundN "kuulo" (k48A "laite")) ; --UNCHK
lin acoustician_N = mkWN "akustikko" ; --UNCHK
lin acoustics_N = mkWN (k9A "akustiikka") ; --UNCHK
lin acquaint_V2 = mkWV2 (k53A "tiedottaa") ; --UNCHK
lin acquaintance_N = mkWN (k40 "perehtyneisyys") ; --UNCHK
lin acquaintanceship_N = mkWN (k40 "tuttavuus") ; --UNCHK
lin acquiesce_V = mkWV (k52 "suostua") ; --UNCHK
lin acquiescence_N = mkWN (k40 "myöntyväisyys") ; --UNCHK
lin acquiescent_A = mkWA (k38 "tottelevainen") ; --UNCHK
lin acquirable_A = mkWA (k10 "oleva") "hankittavissa" ; --UNCHK
lin acquire_V2 = mkV2 "hankkia" ;
lin acquirement_N = mkWN (k39 "saavutus") ; --UNCHK
lin acquirer_N = mkWN (compoundN "yritys" (k5A "pankki")) ; --UNCHK
lin acquiring_N = mkWN (k38 "saaminen") ; --UNCHK
lin acquisition_N = mkN "hankinta" ;
lin acquisitive_A = mkWA (k10 "tekevä") "hankintoja" ; --UNCHK
lin acquisitiveness_N = mkWN (compoundN "omistus" (k1 "halu")) ; --UNCHK
lin acquit_V2 = mkWV2 (k53A "vapauttaa") ;
lin acquittal_N = mkWN (k3 "tuomio") "vapauttava" ; --UNCHK
lin acquittance_N = mkWN (k39 "vapautus") ; --UNCHK
lin acre_N = mkN "eekkeri" ;
lin acreage_N = mkWN (compoundN "pinta-" (k9 "ala")) ; --UNCHK
lin acrid_A = mkWA (k38 "sarkastinen") ; --UNCHK
lin acridity_N = mkWN (k40 "purevuus") ; --UNCHK
lin acrimonious_A = mkWA (k10 "katkera") ; --UNCHK
lin acrimony_N = mkWN (k40 "piikikkyys") ; --UNCHK
lin acritical_A = mkWA (compoundA "epä" (k38 "kriittinen")) ; --UNCHK
lin acroanesthesia_N = mkWN (compoundN "akro" (k12 "anestesia")) ; --UNCHK
lin acrobatFem_N = mkWN (k5A "akrobaatti") ; --UNCHK
lin acrobatMasc_N = mkWN (k5A "akrobaatti") ; --UNCHK
lin acrobatic_A = mkWA (k38 "urheilullinen") ; --UNCHK
lin acrobatics_N = mkWN (k38 "tekeminen") "temppujen" ; --UNCHK
lin acrocarp_N = mkWN (compoundN "akrokarppi" (k49 "sammal")) ; --UNCHK
lin acrocarpous_A = mkWA (compoundA "pesä" (k38 "kekärkinen")) ; --UNCHK
lin acrocentric_A = mkWA "akrosentrinen" ; --UNCHK
lin acrocyanosis_N = mkWN (compoundN "oire" (k10 "yhtymä")) "Raynaud'n" ; --UNCHK
lin acrodont_N = mkWN "akrodontti" ; --UNCHK
lin acrogen_N = mkWN (compoundN "akro" (k5 "geeni")) ; --UNCHK
lin acrogenic_A = mkWA "akrogeeninen" ; --UNCHK
lin acromegalic_A = mkWA (compoundA "akromega" (k38 "alinen")) ; --UNCHK
lin acromegaly_N = mkWN "kärkikasvuisuus" ; --UNCHK
lin acromicria_N = mkWN "akromikria" ; --UNCHK
lin acromion_N = mkWN (k5 "prosessi") "akromiaalinen" ; --UNCHK
lin acromphalus_N = mkWN (compoundN "akromf" (k39 "alus")) ; --UNCHK
lin acromyotonia_N = mkWN "akromyotonia" ; --UNCHK
lin acronym_N = mkWN (k48A "lyhenne") ; --UNCHK
lin acronymic_A = mkWA (compoundA "akronyymi" (k38 "nen")) ; --UNCHK
lin acropetal_A = mkWA (compoundA "kärki" (k38 "hakuinen")) ; --UNCHK
lin acrophobia_N = mkWN (k1 "kammo") "korkean" "paikan" ; --UNCHK
lin acrophobic_A = mkWA (compoundA "korkeanpaikank" (k38 "ammoinen")) ; --UNCHK
lin acrophony_N = mkWN "akrofonia" ; --UNCHK
lin acropolis_N = mkWN (k26 "linnavuori") ; --UNCHK
lin acroscopic_A = mkWA "akroskooppinen" ; --UNCHK
lin acrosome_N = mkWN "akrosomi" ; --UNCHK
lin across_Adv = mkWAdv (k99 "ristiin") ; --UNCHK
lin across_Prep = mkPrep "poikki" ;
lin acrostic_N = mkWN "akrostikon" ; --UNCHK
lin acrylamide_N = mkWN (k5 "akryyliamidi") ; --UNCHK
lin act_N = mkWN (k25 "toimi") | mkN "näytös" ; ---- split
lin act_V = mkV "toimia" ;
lin act_V2 = mkV2 "näytellä" partitive ;
lin act_on_V2 = mkWV2 (k62 "reagoida") ; --UNCHK
lin act_out_V2 = mkWV2 (k67A "näytellä") ; --UNCHK
lin act_up_V = mkWV (k67A "oikutella") ; --UNCHK
lin act_upon_V2 = mkWV2 (k63 "saada") "aikaan" ; --UNCHK
lin actable_A = mkWA (k10 "oleva") "näyteltävissä" ; --UNCHK
lin actin_N = mkWN "aktiini" ; --UNCHK
lin actinal_A = mkWA (compoundA "aktina" (k38 "alinen")) ; --UNCHK
lin acting_A = mkA (mkN "virkaa" (mkN "tekevä")) ;
lin acting_N = mkWN (compoundN "näyttelijän" (k19 "työ")) ; --UNCHK
lin actinia_N = mkWN (compoundN "meri" (k1A "vuokko")) ; --UNCHK
lin actinic_A = mkWA (compoundA "valo" (k38 "kemiallinen")) ; --UNCHK
lin actinism_N = mkWN (compoundN "aktin" (k5 "ismi")) ; --UNCHK
lin actinoid_A = mkWA (compoundA "akti" (k38 "noidinen")) ; --UNCHK
lin actinoid_N = mkWN "aktinidi" ; --UNCHK
lin actinolite_N = mkWN "aktinoliitti" ; --UNCHK
lin actinometer_N = mkWN (compoundN "aktino" (k5 "metri")) ; --UNCHK
lin actinometric_A = mkWA (compoundA "aktino" (k38 "metrinen")) ; --UNCHK
lin actinometry_N = mkWN "aktinometria" ; --UNCHK
lin actinomorphic_A = mkWA (compoundA "akti" (k38 "nomorfinen")) ; --UNCHK
lin actinomyces_N = mkWN (compoundN "säde" (k26 "sieni")) ; --UNCHK
lin actinomycetal_A = mkWA (compoundA "aktinomys" (k38 "eettinen")) ; --UNCHK
lin actinomycete_N = mkWN (compoundN "säde" (k26 "sieni")) ; --UNCHK
lin actinomycin_N = mkWN "aktinomysiini" ; --UNCHK
lin actinomycosis_N = mkWN (compoundN "sädesieni" (k5A "tauti")) ; --UNCHK
lin actinomycotic_A = mkWA (compoundA "akti" (k38 "nomykoottinen")) ; --UNCHK
lin actinomyxidian_N = mkWN "actinomyxidian" ; --UNCHK
lin actinopod_N = mkWN "aktinopodi" ; --UNCHK
lin action_N = mkN "toiminta" ;
lin actionable_A = mkWA (compoundA "haku" (k38 "kelpoinen")) ; --UNCHK
lin activate_V2 = mkWV2 (k53A "ottaa") "käyttöön" ; --UNCHK
lin activation_N = mkWN (k5A "aktivointi") ; --UNCHK
lin active_A = mkA "aktiivinen" ;
lin active_N = mkWN (k5 "aktiivi") ; --UNCHK
lin activeness_N = mkWN (k5A "aktiviteetti") ; --UNCHK
lin activism_N = mkWN (k5 "aktivismi") ; --UNCHK
lin activistFem_N = mkWN (k5 "aktivisti") ;
lin activistMasc_N = variants {} ; --
lin activist_A = mkWA (compoundA "akti" (k38 "vistinen")) ; --UNCHK
lin activity_N = mkWN (k9A "toiminta") ;
lin actomyosin_N = mkWN "aktomyosiini" ; --UNCHK
lin actor_1_N = mkWN (k12 "näyttelijä") ;
lin actor_2_N = mkWN (k12 "näyttelijä") ;
lin actor_N = mkWN (k12 "näyttelijä") ;
lin actress_N = mkWN (k32A "näyttelijätär") ;
lin actual_A = mkA "nykyinen" ;
lin actuality_N = mkWN (k40 "todellisuus") ; --UNCHK
lin actually_Adv = mkAdv "itse asiassa" | adjAdv actual_A ; -- derived
lin actuarial_A = mkWA (compoundA "vakuutus" (k38 "matemaattinen")) ; --UNCHK
lin actuary_N = mkWN (compoundN "tilasto" (k4A "matemaatikko")) ; --UNCHK
lin actuate_V2 = mkWV2 (k53A "aiheuttaa") ; --UNCHK
lin actuator_N = mkWN (compoundN "käyttö" (k48A "laite")) ; --UNCHK
lin acuate_A = mkWA (k1A "suippo") ; --UNCHK
lin acuity_N = mkWN (k40 "tarkkuus") ; --UNCHK
lin aculea_N = mkWN "akulea" ; --UNCHK
lin aculeate_A = mkWA "pistimellinen" ; --UNCHK
lin aculeus_N = mkWN (k33 "pistin") ; --UNCHK
lin acumen_N = mkWN (k1 "äly") ; --UNCHK
lin acuminate_A = mkWA (compoundA "suippo" (k38 "kärkinen")) ; --UNCHK
lin acupressure_N = mkWN (compoundN "shiatsu-" (k9A "hieronta")) ; --UNCHK
lin acupuncture_N = mkWN (k6 "akupunktuuri") ; --UNCHK
lin acute_A = mkWA (k38 "äkillinen") ; --UNCHK
lin acuteness_N = mkWN (k40 "terävyys") ; --UNCHK
lin acyclic_A = mkWA (compoundA "avo" (k38 "ketjuinen")) ; --UNCHK
lin acyclovir_N = mkWN (compoundN "asyklo" (k5 "viiri")) ; --UNCHK
lin acyl_N = mkWN (compoundN "asyyli" (k10 "ryhmä")) ; --UNCHK
lin acylation_N = mkWN "asylaatio" ; --UNCHK
lin ad_N = mkN "mainos" ;
lin ad_hoc_A = mkWA (k99 "vasten") "varta" ; --UNCHK
lin ad_hoc_Adv = mkWAdv (k99 "varten") "tätä" "tarkoitusta" ; --UNCHK
lin ad_infinitum_Adv = mkWAdv (k99 "ikuisesti") ; --UNCHK
lin ad_interim_Adv = mkWAdv "sillä" "aikaa" ; --UNCHK
lin ad_lib_Adv = mkWAdv (k99 "spontaanisti") ; --UNCHK
lin ad_libitum_Adv = mkWAdv (k99 "spontaanisti") ; --UNCHK
lin ad_nauseam_Adv = mkWAdv (k99 "asti") "pahoinvointiin" ; --UNCHK
lin ad_valorem_Adv = mkWAdv (k99 "mukaan") "arvon" ; --UNCHK
lin ada_PN = foreignPN "Ada" ;
lin adactylia_N = mkWN "adaktylia" ; --UNCHK
lin adactylous_A = mkWA (compoundA "adak" (k38 "tyylinen")) ; --UNCHK
lin adage_N = mkWN (k9A "sanonta") ; --UNCHK
lin adagio_A = mkWA (k99 "hitaasti") "kohtalaisen" ; --UNCHK
lin adagio_Adv = mkWAdv (k99 "hitaasti") "kohtalaisen" ; --UNCHK
lin adagio_N = mkWN "adagio" ; --UNCHK
lin adamance_N = mkWN (k40 "taipumattomuus") ; --UNCHK
lin adamant_A = mkWA (k34A "peräänantamaton") ; --UNCHK
lin adamant_N = mkWN (k5A "timantti") ; --UNCHK
lin adamantine_A = mkWA (compoundA "timantin" (k10 "kova")) ; --UNCHK
lin adapt_V = mkWV (k52A "tottua") ;
lin adapt_V2 = mkV2 "mukauttaa" ; --mkWV2 (k52A "tottua") ;
lin adaptability_N = mkWN (k40 "sopeutuvuus") ; --UNCHK
lin adaptable_A = mkWA (k10 "mukautuva") ; --UNCHK
lin adaptation_N = mkWN (k3 "adaptaatio") ; --UNCHK
lin adaptational_A = mkWA "sopeutumiseen" "liittyvä" ; --UNCHK
lin adapter_N = mkWN (k33A "liitin") ; --UNCHK
lin adaptive_A = mkWA (k10 "sopeutuva") ; --UNCHK
lin adaptor_N = mkWN (k33A "liitin") ; --UNCHK
lin adaxial_A = mkWA (compoundA "ventra" (k38 "alinen")) ; --UNCHK
lin add_V = mkV "lisätä" ;
lin add_V2 = mkV2 "lisätä" ;
lin add_V3 = L.add_V3 ;
lin add_VS = mkVS (mkV "lisätä") ;
lin add_in_V = advV OP_add_V OP_in_Adv ; -- guess-p-verb
lin add_on_to_V2 = mkWV2 (k71 "tehdä") "lisäys" ; --UNCHK
lin add_up_V = mkWV (k73 "ynnätä") ; --UNCHK
lin add_up_V2 = mkWV2 (k73 "ynnätä") ; --UNCHK
lin add_up_to_V2 = prepV2 (advV OP_add_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin addable_A = mkWA (k10 "oleva") "lisättävissä" ; --UNCHK
lin addax_N = mkWN (compoundN "saharan" (k5A "antilooppi")) ; --UNCHK
lin added_A = variants {} ; --
lin addend_N = mkWN "yhteenlaskettava" ; --UNCHK
lin addendum_N = mkWN (k48A "liite") ; --UNCHK
lin adder_N = mkWN (k18 "kyy") ; --UNCHK
lin addict_N = mkWN (k5 "narkomaani") ; --UNCHK
lin addict_V2 = mkWV2 (k71 "tehdä") "riippuvaiseksi" ; --UNCHK
lin addiction_N = mkWN (k2 "ratkaisu") ; --UNCHK
lin addictive_A = mkWA (compoundA "addikt" (k10 "oiva")) ; --UNCHK
lin adding_machine_N = mkWN (k33 "laskin") ; --UNCHK
lin addis_ababa_PN = foreignPN "Addis Abeba" ;
lin addition_N = mkWN (k39 "lisäys") ;
lin additional_A = mkA "lisätty" ;
lin additionally_Adv = adjAdv additional_A ; -- derived
lin additive_A = mkWA "lisäävä" ; --UNCHK
lin additive_N = mkWN (compoundN "lisä" (k48 "aine")) ; --UNCHK
lin addle_V = mkWV (k52A "pilaantua") ; --UNCHK
lin addle_V2 = mkWV2 (k52A "pilaantua") ; --UNCHK
lin address_N = mkN "osoite" ;
lin address_V2 = mkV2 (mkV (mkV "kohdistaa") "huomio") ;
lin addressable_A = mkWA (k10 "oleva") "osoitettavissa" ; --UNCHK
lin addressee_N = mkWN (compoundN "vastaan" (k10 "ottaja")) ; --UNCHK
lin addressograph_N = mkWN (compoundN "osoite" (k48 "kone")) ; --UNCHK
lin adduce_V2 = mkWV2 (k73 "siteerata") ; --UNCHK
lin adducent_A = mkWA "adduktiivinen" ; --UNCHK
lin adducer_N = mkWN (k10 "esittäjä") ; --UNCHK
lin adducing_N = mkWN (k38 "tuominen") "esiin" ; --UNCHK
lin adduct_N = mkWN (compoundN "additio" (k48A "tuote")) ; --UNCHK
lin adduction_N = mkWN "lähentäminen" ; --UNCHK
lin adductor_N = mkWN (k10 "lähentäjä") ; --UNCHK
lin adelaide_PN = foreignPN "Adelaide" ;
lin adelgid_N = mkWN "adelgid" ; --UNCHK
lin adenine_N = mkWN (compoundN "ade" (k26 "niini")) ; --UNCHK
lin adenitis_N = mkWN (compoundN "ade" (k5A "niitti")) ; --UNCHK
lin adenocarcinoma_N = mkWN (compoundN "rauhas" (k10A "syöpä")) ; --UNCHK
lin adenocarcinomatous_A = mkWA "adenokarsinoomaan" "liittyvä" ; --UNCHK
lin adenoidal_A = mkWA "kitarisaan" "liittyvä" ; --UNCHK
lin adenoidectomy_N = mkWN (compoundN "poisto" (k39 "leikkaus")) "kitarisan" ; --UNCHK
lin adenoma_N = mkWN (k10 "adenooma") ; --UNCHK
lin adenomegaly_N = mkWN "adenomegalia" ; --UNCHK
lin adenopathy_N = mkWN "adenopatia" ; --UNCHK
lin adenosine_N = mkWN "adenosiini" ; --UNCHK
lin adenovirus_N = mkWN (compoundN "adeno" (k39 "virus")) ; --UNCHK
lin adept_A = mkWA (k41A "taidokas") ; --UNCHK
lin adept_N = mkWN (k5A "ekspertti") ; --UNCHK
lin adeptness_N = mkWN (k40 "nopeus") ; --UNCHK
lin adequacy_N = mkWN (k40 "soveltuvuus") ; --UNCHK
lin adequate_A = mkA "tarkoituksenmukainen" ;
lin adesite_N = mkWN "adesiitti" ; --UNCHK
lin adhere_V = mkWV (k53A "pitää") "kiinni" ; --UNCHK
lin adherence_N = mkWN (compoundN "kii" (k38 "nnipysyminen")) ; --UNCHK
lin adherent_A = mkWA "tarttuva" ; --UNCHK
lin adherent_N = mkWN (k10 "kannattaja") ; --UNCHK
lin adhesion_N = mkWN (compoundN "kii" (k38 "nnipysyminen")) ; --UNCHK
lin adhesive_A = mkWA (k15 "tahmea") ; --UNCHK
lin adhesive_N = mkWN (k6 "liisteri") ; --UNCHK
lin adhesiveness_N = mkWN (k39 "sidos") ; --UNCHK
lin adhocracy_N = mkWN "adhokratia" ; --UNCHK
lin adiabatic_A = mkWA (compoundA "samalämpö" (k38 "määräinen")) ; --UNCHK
lin adience_N = mkWN "adienssi" ; --UNCHK
lin adient_A = mkWA "adientti" ; --UNCHK
lin adipose_A = mkWA (k38 "öljyinen") ; --UNCHK
lin adiposity_N = mkWN (k40 "rasvaisuus") ; --UNCHK
lin adit_N = mkWN (k6 "tunneli") ; --UNCHK
lin adjacency_N = mkWN (k40 "vierekkäisyys") ; --UNCHK
lin adjacent_A = mkWA (k38 "viereinen") ;
lin adjective_N = mkWN (k5 "adjektiivi") ;
lin adjoin_V = mkWV (k73 "lisätä") ; --UNCHK
lin adjoin_V2 = mkWV2 (k73 "lisätä") ; --UNCHK
lin adjourn_V = mkWV (k53A "päättää") ; --UNCHK
lin adjourn_V2 = mkWV2 (k53A "päättää") ; --UNCHK
lin adjournment_N = mkWN (k1A "siirto") ; --UNCHK
lin adjudge_V2 = mkWV2 (k52 "katsoa") ; --UNCHK
lin adjudicate_V = mkWV (k69 "tuomita") ; --UNCHK
lin adjudicate_V2 = mkWV2 (k69 "tuomita") ; --UNCHK
lin adjudication_N = mkWN (k3 "tuomio") ; --UNCHK
lin adjudicative_A = mkWA "tuomioon" "liittyvä" ; --UNCHK
lin adjudicator_N = mkWN (k10 "välittäjä") ; --UNCHK
lin adjunct_A = mkWA (k38 "apulainen") ; --UNCHK
lin adjunct_N = mkWN (k48 "määre") ; --UNCHK
lin adjunctive_A = mkWA "yhdistävä" ; --UNCHK
lin adjuration_N = mkWN (compoundN "valan" (k1A "teko")) ; --UNCHK
lin adjuratory_A = mkWA "vala-" ; --UNCHK
lin adjure_V2 = mkWV2 (k53A "velvoittaa") "valalla" ; --UNCHK
lin adjust_V = mkWV (k52A "tottua") ;
lin adjust_V2 = mkV2 "tottua" illative ;
lin adjustable_A = mkWA (k10 "oleva") "säädettävissä" ; --UNCHK
lin adjuster_N = mkWN (k10 "tarkastaja") ;
lin adjustive_A = mkWA "oikaiseva" ; --UNCHK
lin adjustment_N = mkN "säätö" ;
lin adjutant_N = mkWN (k5A "adjutantti") ; --UNCHK
lin adjuvant_A = mkWA "tehostava" ; --UNCHK
lin adjuvant_N = mkWN (compoundN "lisä" (k48 "aine")) ; --UNCHK
lin admass_N = mkWN (k2 "yleisö") "suuri" ; --UNCHK
lin administer_V = mkWV (k56A "jakaa") ; --UNCHK
lin administer_V2 = mkV2 "hallinnoida" partitive ; --mkWV2 (k56A "jakaa") ;
lin administrable_A = mkWA (k10 "oleva") "hallittavissa" ; --UNCHK
lin administration_N = mkN "hallinto" ;
lin administrative_A = mkWA (k38 "hallinnollinen") ;
lin administratorFem_N = mkN "administraattori" ;
lin administratorMasc_N = mkN "administraattori" ;
lin admirability_N = mkN "ihailtavuus" ;
lin admirable_A = mkA "ihailtava" ; 
lin admiral_N = mkWN (k5 "amiraali") ; 
lin admiration_N = mkN "ihailu" ;
lin admire_V2 = mkV2 (mkV "ihailla") partitive ;
lin admirer_N = mkN "ihailija" "ihailijoita" ;
lin admiringly_Adv = mkWAdv "ihaillen" ; --UNCHK
lin admissibility_N = mkWN (k40 "luvallisuus") ; --UNCHK
lin admissible_A = mkA "luvallinen" ;
lin admission_N = mkN "pääsy" ;
lin admissive_A = mkA "salliva" ;
lin admit_V = mkV "myöntää" | mkWV (k53 "tunnustaa") ;
lin admit_V2 = mkV2 "myöntää" | mkV2 "tunnustaa" ;
lin admit_VS = mkVS "myöntää" | mkWVS (k53 "tunnustaa") ;
lin admittance_N = mkN "pääsy" ;
lin admittedly_Adv = mkWAdv (k99 "tosiaan") ; --UNCHK
lin admix_V = mkV "sekoittaa" ;
lin admix_V2 = mkWV2 (k53A "sekoittaa") "joukkoon" ; --UNCHK
lin admixture_N = mkWN (k39 "seos") ; --UNCHK
lin admonish_V2 = mkWV2 (k61A "moittia") ; --UNCHK
lin admonisher_N = mkWN (k10 "neuvoja") ; --UNCHK
lin admonition_N = mkWN (k39 "kehotus") ; --UNCHK
lin admonitory_A = mkWA (k10 "arvosteleva") ; --UNCHK
lin adnate_A = mkWA (compoundA "yhteen" (k47 "kasvanut")) ; --UNCHK
lin adnexal_A = mkWA "sivuelin-" ; --UNCHK
lin adnoun_N = mkWN (k5 "adjektiivi") "substantiivisesti" "käytetty" ; --UNCHK
lin ado_N = mkWN (k39 "touhotus") ; --UNCHK
lin adobe_N = mkWN (compoundN "savi" (k23 "tiili")) ; --UNCHK
lin adobo_N = mkWN "adobo" ; --UNCHK
lin adolescence_N = mkWN (compoundN "nuoruus" (k10A "ikä")) ; --UNCHK
lin adolescent_A = mkWA (k26 "nuori") ; --UNCHK
lin adolescent_N = mkWN (k38 "nuorukainen") ; --UNCHK
lin adonis_N = mkWN "Adonis" ; --UNCHK
lin adopt_V2 = mkV2 "omaksua" ;
lin adoptable_A = mkWA (compoundA "adoptio" (k38 "kelpoinen")) ; --UNCHK
lin adoptee_N = mkWN (compoundN "otto" (k29 "lapsi")) ; --UNCHK
lin adoption_N = mkWN (compoundN "oma" (k38 "ksuminen")) ; ---ARB --mkN "adoptio" ;
lin adoptive_A = mkWA (compoundA "omak" (k1A "suttu")) ; --UNCHK
lin adorability_N = mkWN (k40 "ihanuus") ; --UNCHK
lin adorable_A = mkWA (k10 "hurmaava") ; --UNCHK
lin adoration_N = mkWN (k9A "palvonta") ; --UNCHK
lin adore_V2 = mkWV2 (k53 "rakastaa") ; --UNCHK
lin adorer_N = mkWN (k10 "palvoja") ; --UNCHK
lin adoring_A = mkWA (compoundA "juma" (k10 "loiva")) ; --UNCHK
lin adorn_V2 = mkWV2 (k53 "komistaa") ; --UNCHK
lin adornment_N = mkWN (compoundN "kori" (k38 "stautuminen")) ; --UNCHK
lin adoxography_N = mkWN "adoksografia" ; --UNCHK
lin adrenal_A = mkWA "lisämunuais-" ; --UNCHK
lin adrenalin_N = mkWN (k5 "adrenaliini") ; --UNCHK
lin adrenarche_N = mkWN "adrenarke" ; --UNCHK
lin adrenergic_A = mkWA (compoundA "sympatomim" (k38 "eettinen")) ; --UNCHK
lin adrenergic_N = mkWN (k48A "lääke") "adrenerginen" ; --UNCHK
lin adrenocortical_A = mkWA (compoundA "adrenokortika" (k38 "alinen")) ; --UNCHK
lin adrenocorticotropic_A = mkWA (compoundA "adrenokortiko" (k38 "trooppinen")) ; --UNCHK
lin adrenosterone_N = mkWN "adrenosteroni" ; --UNCHK
lin adrian_PN = foreignPN "Adrian" ;
lin adrift_A = mkWA (k99 "tuuliajolla") ; --UNCHK
lin adrift_Adv = mkWAdv (k99 "tuuliajolla") ; --UNCHK
lin adroit_A = mkWA (k10 "taitava") ; --UNCHK
lin adroitness_N = mkWN (k40 "nopeus") ; --UNCHK
lin adscititious_A = mkWA "täydentävä" ; --UNCHK
lin adscript_A = mkWA (k10 "seuraava") ; --UNCHK
lin adsorbable_A = mkWA "adsorboitunut" ; --UNCHK
lin adsorbate_N = mkWN (k48 "aine") "adsorboituva" ; --UNCHK
lin adsorbent_A = mkWA (compoundA "adsorb" (k10 "oiva")) ; --UNCHK
lin adsorbent_N = mkWN (k48 "aine") "absorboiva" ; --UNCHK
lin adsorption_N = mkWN (k3 "adsorptio") ; --UNCHK
lin adulation_N = mkWN (k2 "mielistely") ; --UNCHK
lin adulatory_A = mkWA (compoundA "mieliste" (k10 "levä")) ; --UNCHK
lin adult_A = mkWA (kH1 "iso") ; --UNCHK
lin adult_N = mkN "aikuinen" ;
lin adulterant_N = mkWN (k10 "väärentäjä") ; --UNCHK
lin adulterate_A = mkWA (compoundA "jat" (k1A "kettu")) ; --UNCHK
lin adulterate_V2 = mkWV2 (k53A "vesittää") ; --UNCHK
lin adulterating_A = mkWA "laimentava" ; --UNCHK
lin adulteration_N = mkWN (compoundN "huono" (k38 "ntaminen")) ; --UNCHK
lin adulterator_N = mkWN (k10 "väärentäjä") ; --UNCHK
lin adulterer_N = mkWN (k10 "harjoittaja") "haureuden" ; --UNCHK
lin adulteress_N = mkWN (k1A "narttu") ; --UNCHK
lin adulterine_A = mkWA (k34A "avioton") ; --UNCHK
lin adulterous_A = mkWA "pettävä" ; --UNCHK
lin adultery_N = mkWN (k40 "haureus") ; --UNCHK
lin adulthood_N = mkWN (k40 "aikuisuus") ; --UNCHK
lin adumbrate_V2 = mkWV2 (k67 "vihjailla") ; --UNCHK
lin adumbration_N = mkWN (k2 "luonnostelu") ; --UNCHK
lin adumbrative_A = mkWA (k38 "enteellinen") ; --UNCHK
lin advance_N = mkWN (compoundN "eteenpäin" (k1 "meno")) ; --f75
lin advance_V = mkV "edetä" ;
lin advance_V2 = mkV2 "edistää" ;
lin advanced_A = mkA "edistynyt" ;
lin advancement_N = mkWN (k39 "kehitys") ; --UNCHK
lin advancer_N = mkWN (k12 "etenijä") ; --UNCHK
lin advantage_N = mkN "etu" ;
lin advantage_V2 = mkWV2 (k61 "suosia") ; --UNCHK
lin advantageous_A = mkWA (k38 "hyödyllinen") ; --UNCHK
lin advection_N = mkWN "advektio" ; --UNCHK
lin advective_A = mkWA "advektiivinen" ; --UNCHK
lin advent_N = mkWN "saapuminen" ; --UNCHK
lin adventistFem_N = mkWN (k5 "adventisti") ; --UNCHK
lin adventistMasc_N = mkWN (k5 "adventisti") ; --UNCHK
lin adventitial_A = mkWA "ulkokerrokseen" "liittyvä" ; --UNCHK
lin adventitious_A = mkWA (k38 "tilapäinen") ; --UNCHK
lin adventive_A = mkWA "adventiivinen" ; --UNCHK
lin adventure_N = mkWN (k39 "yritys") "vaarallinen" ; --UNCHK
lin adventure_V2 = mkWV2 (k53A "ottaa") "riski" ; --UNCHK
lin adventurer_N = mkWN (k1A "uskalikko") ; --UNCHK
lin adventuresome_A = mkWA (k41 "uskalias") ; --UNCHK
lin adventuress_N = mkWN (k32A "seikkailijatar") ; --UNCHK
lin adventurism_N = mkWN (compoundN "seikkailun" (k1 "halu")) "poliittinen" ; --UNCHK
lin adventuristic_A = mkWA (compoundA "seikkailun" (k38 "haluinen")) ; --UNCHK
lin adventurous_A = mkWA (k41 "uskalias") ; --UNCHK
lin adventurousness_N = mkWN (k40 "uskaliaisuus") ; --UNCHK
lin adverb_N = mkWN (k5 "adverbi") ; --UNCHK
lin adverbial_A = mkWA (k38 "adverbiaalinen") ; --UNCHK
lin adverbial_N = mkWN (k5 "adverbiaali") ; --UNCHK
lin adversary_N = mkWN (k38 "vihollinen") ;
lin adversative_A = mkWA (k38 "adversatiivinen") ; --UNCHK
lin adverse_A = mkWA (k38 "vastakkainen") ;
lin adversity_N = mkWN (k40 "onnettomuus") ; --UNCHK
lin advert_N = mkWN (k39 "mainostus") ; --UNCHK
lin advert_V = mkWV (k75 "nimetä") ; --UNCHK
lin advertence_N = mkWN (k40 "tarkkaavaisuus") ; --UNCHK
lin advertent_A = mkWA (k38 "huolellinen") ; --UNCHK
lin advertise_V = mkWV (k53 "julkistaa") ; --UNCHK
lin advertise_V2 = mkWV2 (k53 "julkistaa") ; --UNCHK
lin advertisement_N = mkN "mainos" ; --WN (k39 "mainostus") ;
lin advertiser_N = mkN (lin NK {s = d10 "mainostaja"}) ;
lin advertising_N = mkWN (k9A "mainonta") ; --f170
lin advertorial_N = mkWN (k5 "puffi") ; --UNCHK
lin advice_N = mkWN (k1 "neuvo") ;
lin advisability_N = mkWN (k40 "viisaus") ; --UNCHK
lin advisable_A = mkWA (k10 "suotava") ; --UNCHK
lin advise_V = mkV "neuvoa" ;
lin advise_V2 = mkV2 "neuvoa" partitive ;
lin advise_VS = mkVS "neuvoa" ; --mkWVS (k73 "ohjata") ;
lin advisee_N = mkWN (k10 "ohjattava") ; --UNCHK
lin adviserFem_N = mkN "neuvonantaja" ;
lin adviserMasc_N = variants {} ; --
lin advisory_A = mkWA (k10 "neuvoa-antava") ; --UNCHK
lin advisory_N = mkWN (k39 "varoitus") ; --UNCHK
lin advocacy_N = mkWN (k39 "kannatus") ; --UNCHK
lin advocateFem_N = mkN "puolustaja" ;
lin advocateMasc_N = variants {} ; --
lin advocate_V2 = mkWV2 (k53A "kannattaa") ; --UNCHK
lin advocate_VS = mkWVS (k53A "kannattaa") ; --UNCHK
lin advowson_N = mkWN (compoundN "patronaatti" (k40 "oikeus")) ; --UNCHK
lin adynamia_N = mkWN (k40 "voimattomuus") ; --UNCHK
lin adynamic_A = mkWA (k34A "voimaton") ; --UNCHK
lin adz_N = mkWN (compoundN "talso" (k41 "kirves")) ; --UNCHK
lin adze_N = mkWN (compoundN "talso" (k41 "kirves")) ; --UNCHK
lin aecial_A = mkWA "itiövaiheeseen" "liittyvä" ; --UNCHK
lin aeciospore_N = mkWN (compoundN "helmi-" (k3 "itiö")) ; --UNCHK
lin aecium_N = mkWN (compoundN "itiö" (k48 "vaihe")) ; --UNCHK
lin aegis_N = mkWN (kH1 "suoja") ; --UNCHK
lin aeolotropic_A = mkWA (compoundA "eolo" (k38 "trooppinen")) ; --UNCHK
lin aeon_N = mkWN (k40 "iäisyys") ; --UNCHK
lin aerate_V2 = mkWV2 (k53A "tuulettaa") ; --UNCHK
lin aeration_N = mkWN (compoundN "hiilihap" (k39 "otus")) ; --UNCHK
lin aerator_N = mkWN (compoundN "ilmastus" (k48A "laite")) ; --UNCHK
lin aerial_A = mkWA (k10 "elävä") "ilmassa" ; --UNCHK
lin aerialist_N = mkWN (compoundN "trapetsi" (k12 "taiteilija")) ; --UNCHK
lin aerides_N = mkWN "aerides" ; --UNCHK
lin aerie_N = mkWN (k1A "asunto") "korkealla" "sijaitseva" ; --UNCHK
lin aeriferous_A = mkWA (k10 "johtava") "ilmaa" ; --UNCHK
lin aeriform_A = mkWA (k38 "eteerinen") ; --UNCHK
lin aerobatics_N = mkWN (k38 "tekeminen") "temppujen" ; --UNCHK
lin aerobe_N = mkWN "aerobi" ; --UNCHK
lin aerobic_A = mkWA (k38 "aerobinen") ; --UNCHK
lin aerobics_N = mkWN (k5 "aerobic") ; --UNCHK
lin aerobiosis_N = mkWN "aerobioosi" ; --UNCHK
lin aerobiotic_A = mkWA "aerobioottinen" ; --UNCHK
lin aerodontalgia_N = mkWN "aerodontalgia" ; --UNCHK
lin aerodrome_N = mkWN (compoundN "lento" (k10A "kenttä")) ; --UNCHK
lin aerodynamic_A = mkWA (k38 "aerodynaaminen") ; --UNCHK
lin aerodynamics_N = mkWN (k9A "aerodynamiikka") ; --UNCHK
lin aerolite_N = mkWN (k5A "meteoriitti") ; --UNCHK
lin aerolitic_A = mkWA (compoundA "meteori" (k38 "ittinen")) ; --UNCHK
lin aerological_A = mkWA "aerologinen" ; --UNCHK
lin aerology_N = mkWN "aerologia" ; --UNCHK
lin aeromechanic_A = mkWA (compoundA "aero" (k38 "mekaaninen")) ; --UNCHK
lin aeromechanics_N = mkWN (k9A "aerodynamiikka") ; --UNCHK
lin aeromedical_A = mkWA "ilmailulääketieteellinen" ; --UNCHK
lin aeromedicine_N = mkWN "avaruuslääketiede" ; --UNCHK
lin aeronaut_N = mkWN (k5A "pilotti") ; --UNCHK
lin aeronautical_A = mkWA "lentämiseen" "liittyvä" ; --UNCHK
lin aeronautics_N = mkWN (k9A "astronautiikka") ; --UNCHK
lin aerophagia_N = mkWN (compoundN "ilma" (k38 "nnieleminen")) ; --UNCHK
lin aerophilatelic_A = mkWA "lentopostimerkkeilyyn" "liittyvä" ; --UNCHK
lin aerophilately_N = mkWN (compoundN "lento" (k2 "postimerkkeily")) ; --UNCHK
lin aerophile_N = mkWN (k10 "harrastaja") "ilmailun" ; --UNCHK
lin aeroplane_N = mkWN (compoundN "lento" (k48 "kone")) ; --UNCHK
lin aerosol_N = mkWN (k5 "aerosoli") ; --UNCHK
lin aerosolized_A = mkWA (k10 "oleva") "aerosolimuodossa" ; --UNCHK
lin aerospace_A = mkA "ilmailullinen" ;
lin aerospace_N = mkWN (k40 "avaruus") "ilmakehä" "ja" ;
lin aertex_N = mkWN "Aertex" ; --UNCHK
lin aery_N = mkWN (k1A "asunto") "korkealla" "sijaitseva" ; --UNCHK
lin aesculapian_A = mkWA (k38 "lääkinnällinen") ; --UNCHK
lin aestheteFem_N = mkWN (k4A "esteetikko") ; --UNCHK
lin aestheteMasc_N = mkWN (k4A "esteetikko") ; --UNCHK
lin aesthetic_A = mkA "esteettinen" ;
lin aesthetic_N = mkWN (k14A "estetiikka") ; --UNCHK
lin aesthetical_A = mkWA (k38 "esteettinen") ; --UNCHK
lin aesthetics_N = mkWN (k14A "estetiikka") ; --UNCHK
lin aestival_A = mkWA (k38 "kesäinen") ; --UNCHK
lin aether_N = mkWN (k6 "eetteri") ; --UNCHK
lin aetiology_N = mkWN (k12 "etiologia") ; --UNCHK
lin afar_Adv = mkWAdv (k99 "kaukana") ; --UNCHK
lin afebrile_A = mkWA "afebriili" ; --UNCHK
lin affability_N = mkWN (k40 "sydämellisyys") ; --UNCHK
lin affable_A = mkWA (k10 "mukava") ; --UNCHK
lin affair_N = mkN "liiketoimi" | mkWN (k1A "juttu") ; --- split
lin affect_N = mkWN (k5 "affekti") ; --UNCHK
lin affect_V2 = mkV2 "vaikuttaa" illative ;
lin affectation_N = mkWN (k40 "teennäisyys") ; --UNCHK
lin affected_A = mkA "vaikutettu" ;
lin affectedness_N = mkWN (k40 "teennäisyys") ; --UNCHK
lin affecting_A = mkWA (k10 "liikuttava") ; --UNCHK
lin affection_N = mkWN (k1A "lämpö") ; --UNCHK
lin affectional_A = mkWA (compoundA "tunnepi" (k38 "toinen")) ; --UNCHK
lin affectionate_A = mkWA (k35A "lämmin") ; --UNCHK
lin affectionateness_N = mkWN (k1A "lämpö") ; --UNCHK
lin affenpinscher_N = mkWN (compoundN "apina" (k6 "pinseri")) ; --UNCHK
lin afferent_A = mkWA "tuova" ; --UNCHK
lin affiance_V2 = mkWV2 (k52A "kihlautua") ; --UNCHK
lin affiant_N = mkWN (k10 "antaja") "valallisen" "todistuksen" ; --UNCHK
lin affidavit_N = mkN (mkN "valaehtoinen") (mkN "todistus") ; ----sanaliitto
lin affiliate_N = mkWN (compoundN "tytär" (k3 "yhtiö")) ; --UNCHK
lin affiliate_V = mkWV (k52 "yhdistyä") ; --UNCHK
lin affiliate_V2 = mkV2 "yhdistää" ; --mkWV2 (k52 "yhdistyä") ;
lin affiliation_N = mkWN "yhtyminen" ; --UNCHK
lin affinal_A = mkWA (k10 "oleva") "lankoussuhteessa" ; --UNCHK
lin affine_A = mkWA "affiininen" ; --UNCHK
lin affine_N = mkWN (k40 "lankous") ; --UNCHK
lin affined_A = mkWA (compoundA "lähi" (k38 "sukuinen")) ; --UNCHK
lin affinity_N = mkWN (k39 "viehtymys") ; --UNCHK
lin affirm_V = mkWV (k53 "vahvistaa") ; --UNCHK
lin affirm_V2 = mkWV2 (k53 "vahvistaa") ; --UNCHK
lin affirm_VS = mkWVS (k53 "vahvistaa") ; --UNCHK
lin affirmable_A = mkWA (k10 "oleva") "vakuutettavissa" ; --UNCHK
lin affirmation_N = mkWN "vahvistaminen" ; --UNCHK
lin affirmative_A = mkWA "vahvistava" ; --UNCHK
lin affirmative_N = mkWN (k39 "vastaus") "myönteinen" ; --UNCHK
lin affirmativeness_N = mkWN (k40 "positiivisuus") ; --UNCHK
lin affix_N = mkWN (k48A "liite") ; --UNCHK
lin affix_V2 = mkWV2 (compoundV "affik" (k62 "soida")) ; --UNCHK
lin affixal_A = mkWA "liitteeseen" "liittyvä" ; --UNCHK
lin affixation_N = mkWN (k48A "liite") ; --UNCHK
lin afflatus_N = mkWN (k3 "inspiraatio") ; --UNCHK
lin afflict_V2 = mkWV2 (k73 "vaivata") ; --UNCHK
lin affliction_N = mkWN (k39 "koettelemus") ; --UNCHK
lin afflictive_A = mkWA (k41 "työläs") ; --UNCHK
lin affluence_N = mkWN (k40 "rikkaus") ; --UNCHK
lin affluent_A = mkWA (k41A "rikas") ; --UNCHK
lin affluent_N = mkWN (compoundN "sivu" (k7A "joki")) ; --UNCHK
lin afford_V2 = mkV2 (caseV adessive (mkV olla_V "varaa")) illative ;
lin afford_V2V = mkWV2V (k67 "olla") "varaa" ; --UNCHK
lin afforest_V2 = mkWV2 (k53A "metsittää") ; --UNCHK
lin afforestation_N = mkWN "muuttaminen" "metsämaaksi" ; --UNCHK
lin affranchise_V2 = mkWV2 (k56A "antaa") "äänioikeus" ; --UNCHK
lin affray_N = mkWN (k9A "riita") ; --UNCHK
lin affricate_N = mkWN "affrikaatta" ; --UNCHK
lin affrication_N = mkWN "affrikaatio" ; --UNCHK
lin affront_N = mkWN (k39 "solvaus") ; --UNCHK
lin affront_V2 = mkWV2 (k73 "parjata") ; --UNCHK
lin affusion_N = mkWN (k2 "valelu") "pään" ; --UNCHK
lin afghanFem_N = mkWN (k5 "afgaani") ; --UNCHK
lin afghanMasc_N = mkWN (k5 "afgaani") ; --UNCHK
lin afghan_A = mkWA (compoundA "afganistani" (k38 "lainen")) ;
lin afghani_N = mkWN (k5 "afgaani") ; --UNCHK
lin afghanistan_PN = foreignPN "Afganistan" ;
lin afghanistaniFem_N = mkWN (k3 "valtio") "Afganistaninen" "islamilainen" ; --UNCHK
lin afghanistaniMasc_N = mkWN (k3 "valtio") "Afganistaninen" "islamilainen" ; --UNCHK
lin afghanistani_A = mkWA (compoundA "afganistani" (k38 "lainen")) ; --UNCHK
lin afibrinogenemia_N = mkWN "afibrinogenemia" ; --UNCHK
lin aficionado_N = mkWN (k10 "harrastaja") "innokas" ; --UNCHK
lin afield_Adv = mkWAdv "kaukana" "aiheesta" ; --UNCHK
lin afire_A = mkWA (k10 "oleva") "liekeissä" ; --UNCHK
lin aflame_A = mkWA (k10 "oleva") "liekeissä" ; --UNCHK
lin aflare_A = mkWA (k10 "oleva") "liekeissä" ; --UNCHK
lin aflatoxin_N = mkWN (compoundN "afla" (k5 "toksiini")) ; --UNCHK
lin afloat_A = mkWA (k99 "varassa") "veden" ; --UNCHK
lin aflutter_A = mkWA (k47 "hermostunut") ; --UNCHK
lin afoot_A = mkWA (k99 "meneillään") ; --UNCHK
lin afoot_Adv = mkWAdv (k99 "jalkaisin") ; --UNCHK
lin aforesaid_A = mkWA (k10 "oleva") "kyseessä" ; --UNCHK
lin afraid_A = mkWA (k10 "oleva") "peloissaan" ; --UNCHK
lin afresh_Adv = mkWAdv (k99 "uudelleen") ; --UNCHK
lin africanFem_N = mkWN "Afrikka" ; --UNCHK
lin africanMasc_N = mkWN "Afrikka" ; --UNCHK
lin african_A = mkWA (k38 "afrikkalainen") ; --UNCHK
lin afrikanerFem_N = mkWN (k5 "buuri") ; --UNCHK
lin afrikanerMasc_N = mkWN (k5 "buuri") ; --UNCHK
lin afrikaner_A = mkWA (compoundA "buuri" (k38 "lainen")) ; --UNCHK
lin afro_americanFem_N = variants {} ; ---- sense to be split
lin afro_americanMasc_N = variants {} ; ---- sense to be split
lin aft_Adv = mkWAdv (k99 "taakse") ; --UNCHK
lin after_A = mkWA (k99 "takana") ; --UNCHK
lin after_Adv = mkWAdv (k99 "sittemmin") ; --UNCHK
lin after_Prep = S.after_Prep ;
lin after_Subj = lin Subj (ss "sen jälkeen kun") ;
lin afterburner_N = mkWN (compoundN "jälki" (k33A "poltin")) ; --UNCHK
lin aftercare_N = mkWN (compoundN "jälki" (k1A "hoito")) ; --UNCHK
lin afterdamp_N = mkWN (compoundN "kaivos" (k1 "kaasu")) ; --UNCHK
lin afterdeck_N = mkWN (compoundN "perä" (k28 "kansi")) ; --UNCHK
lin aftereffect_N = mkWN (k39 "seuraus") ; --UNCHK
lin afterglow_N = mkWN (compoundN "jälki" (k48 "loiste")) ; --UNCHK
lin afterimage_N = mkWN (compoundN "jälki" (k10 "kuva")) ; --UNCHK
lin afterlife_N = mkWN (k10 "elämä") "kuolemanjälkeinen" ; --UNCHK
lin aftermath_N = mkWN (k39 "seuraus") ; --UNCHK
lin aftermost_A = mkWA (k38 "takimmainen") ; --UNCHK
lin afternoon_N = mkN "ilta" (mkN "päivä") ;
lin afterpiece_N = mkWN (compoundN "jälki" (k39 "näytös")) ; --UNCHK
lin aftershaft_N = mkWN (compoundN "jälki" (k1A "ruoto")) ; --UNCHK
lin aftershafted_A = mkWA (compoundA "jälki" (k38 "ruotoinen")) ; --UNCHK
lin aftershock_N = mkWN (compoundN "jälki" (k39 "järistys")) ; --UNCHK
lin aftertaste_N = mkWN (compoundN "jälki" (k1A "maku")) ; --UNCHK
lin afterthought_N = mkWN (k10 "lisä") "myöhempi" ; --UNCHK
lin afterwards_Adv = mkWAdv (k99 "sittemmin") ; --UNCHK
lin afterworld_N = mkWN (k10 "elämä") "tuonpuoleinen" ; --UNCHK
lin again_Adv = mkAdv "taas" | mkAdv "uudelleen" ;
lin against_Prep = postPrep partitive "vastaan" ;
lin agal_N = mkWN "agal" ; --UNCHK
lin agalactia_N = mkWN (compoundN "puu" (k38 "ttuminen")) "maidonerityksen" ; --UNCHK
lin agama_N = mkWN (k1 "agamalisko") ; --UNCHK
lin agamete_N = mkWN "agameetti" ; --UNCHK
lin agamic_A = mkWA (k38 "partenogeneettinen") ; --UNCHK
lin agamid_N = mkWN (k1 "agamid-lisko") ; --UNCHK
lin agammaglobulinemia_N = mkWN "agammaglobulinemia" ; --UNCHK
lin agapanthus_N = mkWN (compoundN "sini" (k9 "sarja")) ; --UNCHK
lin agape_A = mkWA (k99 "ammollaan") ; --UNCHK
lin agape_N = mkWN (compoundN "rakkauden" (k12 "ateria")) ; --UNCHK
lin agar_N = mkWN (k6 "agar-agar") ; --UNCHK
lin agaric_N = mkWN (compoundN "heltta" (k26 "sieni")) ; --UNCHK
lin agate_N = mkWN (k5A "akaatti") ; --UNCHK
lin agateware_N = mkWN (compoundN "akaatti" (k9A "keramiikka")) ; --UNCHK
lin agave_N = mkWN (k8 "agaave") ; --UNCHK
lin agaze_A = mkWA (compoundA "tuij" (k10 "ottava")) ; --UNCHK
lin age_N = mkN "ikä" "iän" "ikää" "ikänä" "ikään" "ikien" "ikiä" "ikinä" "i'issä" "ikiin" ;
lin age_V = mkWV (k52A "vanhentua") ; --UNCHK
lin age_bracket_N = mkWN (k5A "kohortti") ; --UNCHK
lin age_group_N = mkWN (k5A "kohortti") ; --UNCHK
lin aged_Prep = variants {} ; --
lin agedness_N = mkWN (k40 "vanhuus") ; --UNCHK
lin ageing_N = mkWN (compoundN "ikä" (k38 "äntyminen")) ; --UNCHK
lin ageism_N = mkWN (compoundN "ikä" (k9A "syrjintä")) ; --UNCHK
lin ageless_A = mkWA (k34A "loputon") ; --UNCHK
lin agelessness_N = mkWN "iättömyys" ; --UNCHK
lin age_long_A = mkWA (compoundA "elin" (k38 "aikainen")) ; --UNCHK
lin agency_N = mkN "virasto" ;
lin agenda_N = mkN (lin NK {s = d10 "suunnitelma"}) ;
lin agenesis_N = mkWN "ageneesi" ; --UNCHK
lin agentFem_N = mkWN (k5A "agentti") ;
lin agentMasc_N = mkN "agentti" | mkN "edustaja" ;
lin agent_provocateur_N = mkWN (k6 "provokaattori") ;
lin agential_A = mkWA "agentuurin" ; --UNCHK
lin agerasia_N = mkWN (k40 "nuorekkuus") ; --UNCHK
lin ageratum_N = mkWN (compoundN "sini" (k38 "tähtönen")) ; --UNCHK
lin agglomerate_A = mkWA (compoundA "kas" (k47 "aantunut")) ; --UNCHK
lin agglomerate_N = mkWN (k1A "keko") ; --UNCHK
lin agglomerate_V = mkWV (k52A "kasaantua") "yhteen" ; --UNCHK
lin agglomerate_V2 = mkWV2 (k52A "kasaantua") "yhteen" ; --UNCHK
lin agglomeration_N = mkWN (compoundN "kas" (k38 "autuminen")) ; --UNCHK
lin agglutinate_A = mkWA (k15 "tahmea") ; --UNCHK
lin agglutinate_V2 = mkWV2 (k52A "liimautua") "yhteen" ; --UNCHK
lin agglutination_N = mkWN "agglutinaatio" ; --UNCHK
lin agglutinative_A = mkWA (k15 "tahmea") ; --UNCHK
lin agglutinin_N = mkWN (compoundN "aggluti" (k26 "niini")) ; --UNCHK
lin agglutinogen_N = mkWN (compoundN "agglutino" (k5 "geeni")) ; --UNCHK
lin aggrandize_V2 = mkWV2 (k53A "värittää") ; --UNCHK
lin aggrandizement_N = mkWN (compoundN "lisä" (k38 "äminen")) ; --UNCHK
lin aggravate_V2 = mkV2 "pahentaa" partitive ;
lin aggravating_A = mkWA (k10 "raskauttava") ; --UNCHK
lin aggravation_N = mkWN (compoundN "pahe" (k38 "neminen")) ; --UNCHK
lin aggravator_N = mkWN (k2 "henkilö") "ärsyttävä" ; --UNCHK
lin aggregate_A = mkWA "massa-" ; --UNCHK
lin aggregate_N = mkWN (k40 "kokonaisuus") ;
lin aggregate_V = mkWV (k74A "koota") ; --UNCHK
lin aggregate_V2 = mkWV2 (k74A "koota") ; --UNCHK
lin aggregation_N = mkWN (k2 "keräily") ; --UNCHK
lin aggression_N = mkWN (k39 "hyökkäys") ; --UNCHK
lin aggressive_A = mkA "aggressiivinen" ; --f86
lin aggressiveness_N = mkWN (k40 "sotaisuus") ; --UNCHK
lin aggressorFem_N = mkWN (k10 "alkaja") "riidan" ; --UNCHK
lin aggressorMasc_N = mkWN (k10 "alkaja") "riidan" ; --UNCHK
lin aggrieve_V2 = mkWV2 (k52 "pahastua") ; --UNCHK
lin aghast_A = mkWA (k10 "oleva") "shokissa" ; --UNCHK
lin agile_A = mkWA (k10 "sukkela") ; --UNCHK
lin agility_N = mkWN (k40 "vikkelyys") ; --UNCHK
lin aging_N = mkWN (compoundN "ikä" (k38 "äntyminen")) ; --UNCHK
lin agio_N = mkWN (k3 "preemio") ; --UNCHK
lin agitate_V = mkWV (k53A "muuttaa") ; --UNCHK
lin agitate_V2 = mkWV2 (k53A "muuttaa") ; --UNCHK
lin agitation_N = mkWN (k48A "liike") "raju" ; --UNCHK
lin agitative_A = mkWA (k34A "sietämätön") ; --UNCHK
lin agitator_N = mkWN (k10 "lietsoja") ; --UNCHK
lin agitprop_N = mkWN (compoundN "kiihotus" (k9 "propaganda")) ; --UNCHK
lin agleam_A = mkWA (k41A "kirkas") ; --UNCHK
lin aglet_N = mkWN (compoundN "yleisesikunta" (k39 "punos")) ; --UNCHK
lin aglow_A = mkWA (k10 "loistava") ; --UNCHK
lin agnail_N = mkWN (compoundN "kynsi" (k5 "valli")) ; --UNCHK
lin agnate_A = mkWA (compoundA "isän" (k38 "puoleinen")) ; --UNCHK
lin agnate_N = mkWN (k40 "sukulaisuus") "isänpuoleinen" ; --UNCHK
lin agnomen_N = mkWN (compoundN "lisä" (k7 "nimi")) ; --UNCHK
lin agnosia_N = mkWN "tajuamattomuus" ; --UNCHK
lin agnostic_A = mkWA (k38 "agnostinen") ; --UNCHK
lin agnostic_N = mkWN (k4A "agnostikko") ; --UNCHK
lin agnosticism_N = mkWN (k40 "epäileväisyys") ; --UNCHK
lin ago_A = mkWA (k99 "sitten") ; --UNCHK
lin ago_Adv = mkAdv "sitten" ;
lin ago_Prep = postPrep nominative "sitten" ;
lin agog_A = mkWA (k41A "innokas") ; --UNCHK
lin agon_N = mkWN "agon" ; --UNCHK
lin agonadal_A = mkWA (compoundA "agonada" (k38 "alinen")) ; --UNCHK
lin agonal_A = mkWA (compoundA "agona" (k38 "alinen")) ; --UNCHK
lin agonist_N = mkWN (compoundN "ago" (k5 "nisti")) ; --UNCHK
lin agonistic_A = mkWA "agonistinen" ; --UNCHK
lin agonize_V = mkWV (k67 "olla") "kuolemantuskassa" ; --UNCHK
lin agonized_A = mkWA (k38 "tuskainen") ; --UNCHK
lin agonizingly_Adv = mkWAdv (compoundAdv "piinaav" (k99 "asti")) ; --UNCHK
lin agony_N = mkWN (k39 "kidutus") ; --UNCHK
lin agora_N = mkWN (k5 "tori") ; --UNCHK
lin agoraphobia_N = mkWN (k1A "pelko") "julkisten" "paikkojen" ; --UNCHK
lin agouti_N = mkWN "aguti" ; --UNCHK
lin agra_PN = foreignPN "Agra" ;
lin agranulocytic_A = mkWA (compoundA "jyväsoluka" (k38 "toinen")) ; --UNCHK
lin agranulocytosis_N = mkWN (compoundN "jyvässolu" (k1A "kato")) ; --UNCHK
lin agraphia_N = mkWN (compoundN "kirjoitus" (k40 "kyvyttömyys")) ; --UNCHK
lin agraphic_A = mkWA (compoundA "kirjoittamis" (k34A "kyvytön")) ; --UNCHK
lin agrarian_A = mkWA (k38 "agraarinen") ; --UNCHK
lin agree_V = mkV olla_V "samaa mieltä" ;
lin agree_VS = mkVS (mkV "sopia") ;
lin agree_VV = mkVV (mkV "suostua") infIllat ;
lin agree_on_V = advV OP_agree_V OP_on_Adv ; -- guess-p-verb
lin agree_with_V2 = prepV2 OP_agree_V OP_with_Prep ; -- guess-p-verb
lin agreeable_A = mkWA (k10 "rakastettava") ; --UNCHK
lin agreeableness_N = mkWN (k40 "miellyttävyys") ; --UNCHK
lin agreed_A = variants {} ; --
lin agreement_N = mkN "sopimus" ;
lin agrestic_A = mkWA (k15 "karkea") ; --UNCHK
lin agribusiness_N = mkWN (compoundN "maa" (k40 "talous")) ; --UNCHK
lin agricultural_A = mkA (mkN "maan" (mkN "viljelyllinen")) ;
lin agriculture_N = mkWN (compoundN "maa" (k40 "talous")) ;
lin agriculturist_N = mkWN (k10 "tuottaja") ; --UNCHK
lin agrimonia_N = mkWN (compoundN "maarian" (k26 "verijuuri")) ; --UNCHK
lin agrobiologic_A = mkWA (compoundA "agro" (k38 "biologinen")) ; --UNCHK
lin agrobiology_N = mkWN (compoundN "maatalous" (k12 "biologia")) ; --UNCHK
lin agrologic_A = mkWA (compoundA "agrologi" (k38 "nen")) ; --UNCHK
lin agrology_N = mkWN "agrologia" ; --UNCHK
lin agromania_N = mkWN (compoundN "yksi" (k1 "nolo")) ; --UNCHK
lin agronomic_A = mkWA (compoundA "agronomi" (k38 "nen")) ; --UNCHK
lin agronomist_N = mkWN (k5 "agronomi") ; --UNCHK
lin agronomy_N = mkWN (k12 "agronomia") ; --UNCHK
lin aground_A = mkWA (k10 "oleva") "karilla" ; --UNCHK
lin aground_Adv = mkWAdv "karille" ; --UNCHK
lin agrypnia_N = mkWN (k12 "vigilia") ; --UNCHK
lin agrypnotic_A = mkWA "vigiliaan" "liittyvä" ; --UNCHK
lin agua_N = mkWN (compoundN "aga" (k10 "konna")) ; --UNCHK
lin ague_N = mkWN (k5A "akuutti") ; --UNCHK
lin agueweed_N = mkWN (compoundN "amerikanvalko" (k9 "latva")) ; --UNCHK
lin aguish_A = mkWA (compoundA "vilu" (k38 "tautinen")) ; --UNCHK
lin ah_Interj = mkInterj "aah" ;
lin ahead_Adv = mkWAdv (k99 "edellä") ;
lin ahead_of_Prep = mkPrep "edellä" ;
lin ahimsa_N = mkWN "ahimsa" ; --UNCHK
lin ahistorical_A = mkWA (compoundA "epä" (k38 "historiallinen")) ; --UNCHK
lin ahmedabad_PN = foreignPN "Ahmedabad" ;
lin aid_N = mkN (lin NK {s = d01A "apu"}) ;
lin aid_V = mkV vOlla "avuksi" ;
lin aid_V2 = mkWV2 (k67 "olla") "avuksi" ; --UNCHK
lin aide_N = mkWN (k10 "avustaja") ; --UNCHK
lin aids_N = mkWN (k5 "AIDS") ; --UNCHK
lin aigret_N = mkWN (compoundN "töyhtö" (k48 "koriste")) ; --UNCHK
lin aigrette_N = mkWN (compoundN "töyhtö" (k48 "koriste")) ; --UNCHK
lin aikido_N = mkWN (k2 "aikido") ; --UNCHK
lin ail_V = mkV "sairastaa" ;
lin ail_V2 = mkWV2 (k53A "satuttaa") ; --UNCHK
lin ailanthus_N = mkWN (compoundN "jumalten" (k18 "puu")) ; --UNCHK
lin aileron_N = mkWN (k48A "siiveke") ; --UNCHK
lin ailment_N = mkWN (k9 "vaiva") ;
lin ailurophobia_N = mkWN (compoundN "kissa" (k1 "kammo")) ; --UNCHK
lin aim_N = mkWN (k33 "tähtäin") ; --UNCHK
lin aim_V = mkV "tähdätä" ;
lin aim_V2 = mkV2 (mkV "tähdätä") (casePrep illative) ; --f71
lin aim_VV = mkVV (mkV "aikoa") ;
lin aim_at_V2 = prepV2 OP_aim_V OP_at_Prep ; -- guess-p-verb
lin aimless_A = mkWA (k34A "päämäärätön") ; --UNCHK
lin aioli_N = mkWN (compoundN "valkosipuli" (k48A "kastike")) ; --UNCHK
lin air_N = mkN "ilma" ;
lin air_V = mkV "tuulettua" ; --mkWV (k53A "tuulettaa") ;
lin air_V2 = mkWV2 (k53A "tuulettaa") partitive ;
lin air_bladder_N = mkWN (compoundN "uima" (k1A "rakko")) ; --UNCHK
lin air_conditioned_A = mkA "ilmastoitu" ;
lin air_conditioning_N = mkWN (k5A "ilmastointi") ; --UNCHK
lin air_pump_N = mkWN (compoundN "tyhjiö" (k1A "pumppu")) ; --UNCHK
lin air_raid_N = mkWN (compoundN "ilma" (k39 "hyökkäys")) ; --UNCHK
lin air_shaft_N = mkWN (compoundN "ilmanvaihto" (k1 "kuilu")) ; --UNCHK
lin air_sick_A = mkWA (compoundA "meri" (k41 "sairas")) ; --UNCHK
lin air_sickness_N = mkWN (compoundN "ilma" (k40 "sairaus")) ; --UNCHK
lin airborne_A = mkWA (k10 "oleva") "ilmassa" ; --UNCHK
lin airbrake_N = mkWN (compoundN "ilma" (k1 "jarru")) ; --UNCHK
lin airbrush_N = mkWN (compoundN "retussi" (k1 "ruisku")) ; --UNCHK
lin airburst_N = mkWN (compoundN "ilma" (k39 "räjähdys")) ; --UNCHK
lin airbus_N = mkWN (compoundN "lento" (k5 "bussi")) ; --UNCHK
lin aircraft_N = mkWN (compoundN "lento" (k48 "kone")) ; --f85
lin aircraftman_N = mkWN "lentosotamies" ; --UNCHK
lin aircraftsman_N = mkWN "lentosotamies" ; --UNCHK
lin aircrew_N = mkWN (k2 "miehistö") "lentokoneen" ; --UNCHK
lin aircrewman_N = mkWN (k32 "jäsen") "lentokoneen" "miehistön" ; --UNCHK
lin airdock_N = mkWN (k5 "lentokonehalli") ; --UNCHK
lin airdrie_PN = foreignPN "Airdrie" ;
lin airdrop_N = mkWN (compoundN "laskuvarjo" (k39 "pudotus")) ; --UNCHK
lin airedale_N = mkWN (compoundN "airedalen" (k5 "terrieri")) ; --UNCHK
lin airfare_N = mkWN (k9A "hinta") "lentolipun" ; --UNCHK
lin airfield_N = mkWN (k10A "kenttä") ; --UNCHK
lin airflow_N = mkWN (k39 "virtaus") "ilman" ; --UNCHK
lin airfoil_N = mkWN (k9A "pinta") ; --UNCHK
lin airframe_N = mkWN (k1A "runko") ; --UNCHK
lin airhead_N = mkWN "ilmasillanpää" ; --UNCHK
lin airheaded_A = mkWA (k10 "tyhmä") ; --UNCHK
lin airiness_N = mkWN (k40 "herkkyys") ; --UNCHK
lin airing_N = mkWN (k39 "tuuletus") ; --UNCHK
lin airing_cupboard_N = mkWN (compoundN "kuivaus" (k5A "kaappi")) ; --UNCHK
lin airless_A = mkWA (k38 "tunkkainen") ; --UNCHK
lin airlift_N = mkWN (compoundN "ilma" (k39 "kuljetus")) ; --UNCHK
lin airline_N = mkN "lento" (mkN "yhtiö" "yhtiöitä") ;
lin airliner_N = mkWN "matkustajalentokone" ; --UNCHK
lin airlock_N = mkWN (compoundN "ilma" (k1A "lukko")) ; --UNCHK
lin airmail_N = mkWN (k5 "lentoposti") ; --UNCHK
lin airmailer_N = mkWN "lentopostittaja" ; --UNCHK
lin airman_N = mkWN (k5A "pilotti") ; --UNCHK
lin airplane_N = L.airplane_N ;
lin airport_N = mkWN (compoundN "lento" (k10A "kenttä")) ;
lin airs_N = mkWN (k2 "tärkeily") ; --UNCHK
lin airscrew_N = mkWN (k6 "potkuri") ; --UNCHK
lin airship_N = mkWN (compoundN "ilma-" (k39 "alus")) ; --UNCHK
lin airspace_N = mkWN (compoundN "ilma" (k9 "tila")) ; --UNCHK
lin airspeed_N = mkWN (compoundN "lento" (k40 "nopeus")) ; --UNCHK
lin airstream_N = mkWN (k9A "virta") "voimakas" ; --UNCHK
lin airstrip_N = mkWN (compoundN "kiito" (k19 "tie")) ; --UNCHK
lin airtight_A = mkWA (k10 "pitävä") ; --UNCHK
lin airway_N = mkWN (k10 "harjoittaja") "lentoliikenteen" ; --UNCHK
lin airwoman_N = mkWN (compoundN "nais" (k10 "lentäjä")) ; --UNCHK
lin airworthiness_N = mkWN (compoundN "lento" (k40 "kelpoisuus")) ; --UNCHK
lin airworthy_A = mkWA (compoundA "lento" (k38 "kelpoinen")) ; --UNCHK
lin airy_A = mkWA (k38 "eteerinen") ; --UNCHK
lin aisle_N = mkWN (k10 "käytävä") ; --UNCHK
lin aitchbone_N = mkWN (compoundN "reisi" (k9 "pala")) ; --UNCHK
lin ajar_A = mkWA (k99 "raollaan") ; --UNCHK
lin akaa_PN = mkPN "Akaa" ;
lin akaryocyte_N = mkWN "akaryootti" ; --UNCHK
lin akimbo_Adv = mkWAdv (k99 "puuskassa") ; --UNCHK
lin akin_A = mkWA (k38 "sukulainen") ; --UNCHK
lin akinesis_N = mkWN "akinesia" ; --UNCHK
lin akron_PN = foreignPN "Akron" ;
lin ala_N = mkWN (k7A "siipi") ; --UNCHK
lin alabama_PN = mkPN "Alabama" ;
lin alabaster_A = mkWA (compoundA "alabasteri" (k38 "mainen")) ; --UNCHK
lin alabaster_N = mkWN (k6 "alabasteri") ; --UNCHK
lin alacritous_A = mkWA (k15 "ripeä") ; --UNCHK
lin alacrity_N = mkWN (k1A "into") ; --UNCHK
lin alahärmä_PN = mkPN "Alahärmä" ;
lin alajärvi_PN = mkPN (mkN "Alajärvi" "Alajärviä") ;
lin alalia_N = mkWN "alalia" ; --UNCHK
lin alanine_N = mkWN (compoundN "ala" (k26 "niini")) ; --UNCHK
lin alar_A = mkWA (compoundA "siipi" (k38 "mäinen")) ; --UNCHK
lin alarm_N = mkWN (k33A "hälytin") ; --UNCHK
lin alarm_V2 = mkV2 "hälyttää" ;
lin alarm_clock_N = mkWN (compoundN "herätys" (k1 "kello")) ; --UNCHK
lin alarming_A = mkWA (compoundA "huoles" (k10 "tuttava")) ; --UNCHK
lin alarmism_N = mkWN (compoundN "alarm" (k5 "ismi")) ; --UNCHK
lin alarmist_N = mkWN "alarmisti" ; --UNCHK
lin alas_Interj = mkInterj "voi voi" ;
lin alaska_PN = mkPN "Alaska" ;
lin alastaro_PN = mkPN "Alastaro" ;
lin alastrim_N = mkWN (k51 "isorokko") "Länsi-Intian" ; --UNCHK
lin alate_A = mkWA (k38 "siivellinen") ; --UNCHK
lin alavieska_PN = mkPN "Alavieska" ;
lin alavus_PN = mkPN "Alavus" ;
lin alb_N = mkWN (k9 "alba") ; --UNCHK
lin albacore_N = mkWN (compoundN "pitkäevätonni" (k9 "kala")) ; --UNCHK
lin albania_PN = foreignPN "Albania" ;
lin albanian_A = mkWA (k38 "albanialainen") ; --UNCHK
lin albanian_N = mkWN (k38 "albanialainen") ; --UNCHK
lin albatross_N = mkWN (k5 "albatrossi") ; --UNCHK
lin albedo_N = mkWN (compoundN "heijastus" (k1 "teho")) ; --UNCHK
lin albeit_Subj = mkSubj "vaikkakin" ; --
lin albert_PN = foreignPN "Albert" ;
lin albescent_A = mkWA (compoundA "valke" (k9 "neva")) ; --UNCHK
lin albinal_A = mkWA (compoundA "albina" (k38 "alinen")) ; --UNCHK
lin albinism_N = mkWN (k5 "albinismi") ; --UNCHK
lin albino_N = mkWN (k2 "albiino") ; --UNCHK
lin albite_N = mkWN "valkoinen" "maasälpä" ; --UNCHK
lin albitic_A = mkWA "albiittinen" ; --UNCHK
lin albizzia_N = mkWN (compoundN "aka" (k12 "asia")) ; --UNCHK
lin albuca_N = mkWN "albuca" ; --UNCHK
lin albuginea_N = mkWN "albuginea" ; --UNCHK
lin album_N = mkWN (k6 "albumi") ; --UNCHK
lin albumen_N = mkWN (k38 "valkuainen") ; --UNCHK
lin albumin_N = mkWN "albumiini" ; --UNCHK
lin albuminous_A = mkWA (compoundA "albumiini" (k38 "mainen")) ; --UNCHK
lin albuminuria_N = mkWN "proteinuria" ; --UNCHK
lin albuminuric_A = mkWA (compoundA "albumi" (k38 "nuurinen")) ; --UNCHK
lin albuterol_N = mkWN "Proventil" ; --UNCHK
lin alcalde_N = mkWN (k6 "pormestari") ; --UNCHK
lin alcazar_N = mkWN (k5 "palatsi") "arabityylinen" ; --UNCHK
lin alchemic_A = mkWA (compoundA "alkemia" (k38 "llinen")) ; --UNCHK
lin alchemist_N = mkWN (k5 "alkemisti") ; --UNCHK
lin alchemistic_A = mkWA (compoundA "alkemisti" (k38 "nen")) ; --UNCHK
lin alchemy_N = mkWN (k12 "alkemia") ; --UNCHK
lin alcohol_N = mkWN (k9 "viina") ; --UNCHK
lin alcoholic_A = mkWA (compoundA "alkoholipi" (k38 "toinen")) ; --UNCHK
lin alcoholic_N = mkWN (k6 "juomari") ; --UNCHK
lin alcoholism_N = mkWN (k5 "alkoholismi") ; --UNCHK
lin alcove_N = mkWN (k39 "syvennys") ; --UNCHK
lin aldehyde_N = mkWN "aldehydi" ; --UNCHK
lin aldehydic_A = mkWA "aldehydi-" ; --UNCHK
lin alder_N = mkWN (k10A "leppä") ; --UNCHK
lin alderfly_N = mkWN (compoundN "kaisla" (k1A "korento")) ; --UNCHK
lin alderman_N = mkWN (k5 "oltermanni") ; --UNCHK
lin aldershot_PN = foreignPN "Aldershot" ;
lin aldohexose_N = mkWN (compoundN "aldohek" (k5 "soosi")) ; --UNCHK
lin aldol_N = mkWN (compoundN "aldehydi" (k5 "alkoholi")) ; --UNCHK
lin aldose_N = mkWN "aldoosi" ; --UNCHK
lin aldosterone_N = mkWN "aldosteroni" ; --UNCHK
lin aldosteronism_N = mkWN (compoundN "hyperaldosteron" (k5 "ismi")) ; --UNCHK
lin aleatory_A = mkWA (compoundA "ale" (k38 "atorinen")) ; --UNCHK
lin alee_Adv = mkWAdv "suojapuolelle" ; --UNCHK
lin alembic_N = mkWN (k5A "retortti") ; --UNCHK
lin alendronate_N = mkWN (compoundN "alendro" (k5A "naatti")) ; --UNCHK
lin aleph_N = mkWN "aalef" ; --UNCHK
lin aleppo_PN = foreignPN "Aleppo" ;
lin alert_A = mkWA (k15 "virkeä") ; --UNCHK
lin alert_N = mkWN (k2 "koneisto") "merkinantolaitteen" ; --UNCHK
lin alert_V2 = mkV2 "varoittaa" partitive ;
lin alertness_N = mkWN (k40 "vireys") ; --UNCHK
lin alessandria_PN = foreignPN "Alessandria" ;
lin aleurone_N = mkWN "aleuroni" ; --UNCHK
lin aleuronic_A = mkWA (compoundA "ale" (k38 "uroninen")) ; --UNCHK
lin alewife_N = mkWN (compoundN "pilkku" (k5 "silli")) ; --UNCHK
lin alexander_PN = foreignPN "Alexander" ;
lin alexandra_PN = foreignPN "Alexandra" ;
lin alexandria_PN = foreignPN "Aleksandria" ;
lin alexandrine_N = mkWN (compoundN "aleksandri" (k38 "alainen")) ; --UNCHK
lin alexandrite_N = mkWN (compoundN "aleksand" (k5A "riitti")) ; --UNCHK
lin alexia_N = mkWN (k12 "afasia") "visuaalinen" ; --UNCHK
lin alexic_A = mkWA (compoundA "sana" (k15 "sokea")) ; --UNCHK
lin alexic_N = mkWN (compoundN "sana" (k15 "sokea")) ; --UNCHK
lin alf_PN = foreignPN "Alf" ;
lin alfalfa_N = mkWN (compoundN "sini" (k38 "mailanen")) ; --UNCHK
lin alfred_PN = foreignPN "Alfred" ;
lin alfresco_A = mkWA "ulko-" ; --UNCHK
lin alfresco_Adv = mkWAdv (k99 "ulkosalla") ; --UNCHK
lin alfreton_PN = foreignPN "Alfreton" ;
lin alga_N = mkWN (k10 "levä") ; --UNCHK
lin algal_A = mkWA (compoundA "levä" (k38 "mäinen")) ; --UNCHK
lin algarroba_N = mkWN (compoundN "juliifl" (k10 "ora")) "Prosopis" ; --UNCHK
lin algebra_N = mkWN (k11 "algebra") ; --UNCHK
lin algebraic_A = mkWA (k38 "algebrallinen") ; --UNCHK
lin algebraical_A = mkWA (k38 "algebrallinen") ; --UNCHK
lin algebraist_N = mkWN (compoundN "algeb" (k5 "risti")) ; --UNCHK
lin algeria_PN = foreignPN "Algeria" ;
lin algerian_A = mkWA (compoundA "algeri" (k38 "alainen")) ; --UNCHK
lin algerian_N = mkWN (compoundN "algeri" (k38 "alainen")) ; --UNCHK
lin algid_A = mkWA (compoundA "jää" (k10 "kylmä")) ; --UNCHK
lin algidity_N = mkWN (k40 "kylmyys") ; --UNCHK
lin algin_N = mkWN (compoundN "algiini" (k1A "happo")) ; --UNCHK
lin algoid_A = mkWA (compoundA "levä" (k38 "mäinen")) ; --UNCHK
lin algolagnia_N = mkWN "algofilia" ; --UNCHK
lin algolagnic_A = mkWA "algolagninen" ; --UNCHK
lin algometer_N = mkWN (compoundN "algo" (k5 "metri")) ; --UNCHK
lin algometric_A = mkWA (compoundA "algo" (k38 "metrinen")) ; --UNCHK
lin algometry_N = mkWN "algometria" ; --UNCHK
lin algophobia_N = mkWN (compoundN "algo" (k12 "fobia")) ; --UNCHK
lin algophobic_A = mkWA "algofobinen" ; --UNCHK
lin algorism_N = mkWN (compoundN "algor" (k5 "ismi")) ; --UNCHK
lin algorithm_N = mkWN (k10 "ohjelma") "algoritminen" ; --UNCHK
lin algorithmic_A = mkWA (compoundA "algoritmi" (k38 "nen")) ; --UNCHK
lin alias_Adv = mkWAdv (k99 "alias") ; --UNCHK
lin alias_N = mkWN (k7 "nimi") "väärä" ; --UNCHK
lin alibi_N = mkWN (k1 "olo") "muualla" ; --UNCHK
lin alicante_PN = foreignPN "Alicante" ;
lin alice_PN = foreignPN "Alice" ;
lin alidade_N = mkWN "alhidadi" ; --UNCHK
lin alienFem_N = mkN "muukalainen" ;
lin alienMasc_N = mkN "muukalainen" ;
lin alien_A = mkWA (k38 "eksoottinen") ; --UNCHK
lin alienable_A = mkWA (k10 "oleva") "siirrettävissä" ; --UNCHK
lin alienage_N = mkWN (k40 "muukalaisuus") ; --UNCHK
lin alienate_V2 = mkWV2 (k71 "tehdä") "tyytymättömäksi" ; --UNCHK
lin alienating_A = mkWA "vieraannuttava" ; --UNCHK
lin alienation_N = mkWN (compoundN "etä" (k38 "ännyttäminen")) ; --UNCHK
lin alienator_N = mkWN "vieraannuttaja" ; --UNCHK
lin alienee_N = mkWN (k10 "omistaja") "uusi" ; --UNCHK
lin alienism_N = mkWN (k40 "muukalaisuus") ; --UNCHK
lin alienist_N = mkWN (compoundN "alie" (k5 "nisti")) ; --UNCHK
lin alienor_N = mkWN (k10 "siirtäjä") ; --UNCHK
lin alight_A = mkWA (k10 "oleva") "liekeissä" ; --UNCHK
lin alight_V = mkWV (k52A "laskeutua") ; --UNCHK
lin align_V2 = mkV2 (mkV (mkV "asettaa") "rinnakkain") ;
lin alignment_N = mkWN (k39 "kohdistus") ; --UNCHK
lin alike_A = mkWA (k38 "samanlainen") ; --UNCHK
lin alike_Adv = mkWAdv (k99 "samoin") ; --UNCHK
lin alimentary_A = mkWA (k10 "ravitseva") ; --UNCHK
lin alimentative_A = mkWA "ylläpito-" ; --UNCHK
lin alimony_N = mkWN (compoundN "elatus" (k1A "apu")) ; --UNCHK
lin aliphatic_A = mkWA (compoundA "suo" (k38 "raketjuinen")) ; --UNCHK
lin aliquot_A = mkWA "alikvootti" ; --UNCHK
lin aliquot_N = mkWN (k1A "luku") "tasan" "menevä" ; --UNCHK
lin aliterate_N = mkWN (k2 "henkilö") "kirjallisesti" "sivistymätön" ; --UNCHK
lin alive_A = mkWA (k99 "hengissä") ; --UNCHK
lin aliyah_N = mkWN "alija" ; --UNCHK
lin alizarin_N = mkWN "alitsariini" ; --UNCHK
lin alkahest_N = mkWN (k33A "liuotin") "universaali" ; --UNCHK
lin alkahestic_A = mkWA "alkahestinen" ; --UNCHK
lin alkalemia_N = mkWN (compoundN "emäs" (k40 "verisyys")) ; --UNCHK
lin alkalescent_A = mkWA (k38 "emäksinen") "heikosti" ; --UNCHK
lin alkali_N = mkWN (k6 "alkali") ; --UNCHK
lin alkalimetry_N = mkWN "alkalimetria" ; --UNCHK
lin alkalinity_N = mkWN (k40 "emäksisyys") ; --UNCHK
lin alkalinuria_N = mkWN "alkaluria" ; --UNCHK
lin alkaloid_N = mkWN (k5 "alkaloidi") ; --UNCHK
lin alkaloidal_A = mkWA (compoundA "alkaloidi" (k38 "nen")) ; --UNCHK
lin alkalosis_N = mkWN (compoundN "alka" (k5 "loosi")) ; --UNCHK
lin alkalotic_A = mkWA "alkaloottinen" ; --UNCHK
lin alkapton_N = mkWN (compoundN "homogentisiini" (k1A "happo")) ; --UNCHK
lin alkaptonuria_N = mkWN "alkaptonuria" ; --UNCHK
lin alkene_N = mkWN (compoundN "ole" (k5 "fiini")) ; --UNCHK
lin alkyd_N = mkWN (k5 "alkydi") ; --UNCHK
lin alkyl_N = mkWN (compoundN "alkyyli" (k5 "radikaali")) ; --UNCHK
lin alkylbenzene_N = mkWN "alkyylibentseeni" ; --UNCHK
lin alkylbenzenesulfonate_N = mkWN (compoundN "alkyylibentseenisulfo" (k5A "naatti")) ; --UNCHK
lin alkylic_A = mkWA (compoundA "alky" (k38 "ylinen")) ; --UNCHK
lin all_A = mkWA (kH1 "koko") ; --UNCHK
lin all_Predet = S.all_Predet ;
lin allamanda_N = mkWN (compoundN "köynnöskustaan" (k10A "kukka")) ; --UNCHK
lin allan_PN = foreignPN "Allan" ;
lin allantoic_A = mkWA "allantoiskalvoon" "liittyvä" ; --UNCHK
lin allantoid_A = mkWA (compoundA "makkaran" (k38 "muotoinen")) ; --UNCHK
lin allantois_N = mkWN (compoundN "rakko" (k1 "kalvo")) ; --UNCHK
lin allay_V2 = mkWV2 (k53A "tyydyttää") ; --UNCHK
lin allegation_N = mkWN (k48A "väite") ;
lin allege_V2 = mkV2 "väittää" ;
lin allege_VS = mkVS (mkV "väittää") ;
lin alleged_A = mkA "väitetty" ;
lin allegedly_AdA = mkAdA "muka" ;
lin allegedly_AdV = mkAdV "väitetysti" ;
lin allegiance_N = mkWN (k5A "lojaliteetti") ; --UNCHK
lin allegiant_A = mkWA (k38 "uskollinen") ; --UNCHK
lin allegoric_A = mkWA (k38 "allegorinen") ; --UNCHK
lin allegorical_A = mkWA (k38 "allegorinen") ; --UNCHK
lin allegorizer_N = mkWN (compoundN "allegori" (k10 "soija")) ; --UNCHK
lin allegory_N = mkWN (k12 "allegoria") ; --UNCHK
lin allegretto_A = mkWA (k99 "nopeasti") "melko" ; --UNCHK
lin allegretto_Adv = mkWAdv (k99 "nopeasti") "melko" ; --UNCHK
lin allegretto_N = mkWN (k99 "nopeasti") "melko" ; --UNCHK
lin allegro_A = mkWA (k99 "nopeasti") ; --UNCHK
lin allegro_Adv = mkWAdv (k99 "nopeasti") ; --UNCHK
lin allegro_N = mkWN (k99 "nopeasti") ; --UNCHK
lin allele_N = mkWN (k5 "alleeli") ; --UNCHK
lin allelic_A = mkWA (compoundA "alle" (k38 "lomorfinen")) ; --UNCHK
lin allemande_N = mkWN (compoundN "muna" (k48A "kastike")) ; --UNCHK
lin allen_PN = foreignPN "Allen" ;
lin allergen_N = mkWN (k5 "allergeeni") ; --UNCHK
lin allergenic_A = mkWA (k38 "allergeeninen") ; --UNCHK
lin allergic_A = mkWA (k38 "allerginen") ; --UNCHK
lin allergist_N = mkWN "allergologi" ; --UNCHK
lin allergology_N = mkWN "allergologia" ; --UNCHK
lin allergy_N = mkWN (k3 "reaktio") "allerginen" ; --UNCHK
lin alleviate_V2 = mkV2 "lievittää" partitive ;
lin alleviation_N = mkWN (k39 "helpotus") ; --UNCHK
lin alleviative_A = mkWA (k38 "palliatiivinen") ; --UNCHK
lin alleviator_N = mkWN "lievittäjä" ; --UNCHK
lin alley_N = mkWN (k10 "käytävä") ; --UNCHK
lin alleyway_N = mkWN (k10 "käytävä") ; --UNCHK
lin alliaceous_A = mkWA "sipuli-" ; --UNCHK
lin alliance_N = mkN "allianssi" | mkN "liitto" ;
lin allied_A = variants {} ; --
lin alligator_N = mkWN (k6 "alligaattori") ; --UNCHK
lin alligatored_A = mkWA (compoundA "patino" (k1A "itu")) ; --UNCHK
lin alligatorfish_N = mkWN (compoundN "alligaattori" (k9 "kala")) ; --UNCHK
lin alliteration_N = mkWN (k3 "allitteraatio") ; --UNCHK
lin alliterative_A = mkWA (compoundA "alku" (k38 "soinnullinen")) ; --UNCHK
lin alliterator_N = mkWN (k10 "käyttäjä") "alkusoinnun" ; --UNCHK
lin alloa_PN = foreignPN "Alloa" ;
lin allocable_A = mkWA (k10 "oleva") "allokoitavissa" ; --UNCHK
lin allocate_V = mkWV (k67 "annostella") ; --UNCHK
lin allocate_V2 = mkWV2 (k67 "annostella") ; --UNCHK
lin allocation_N = mkWN (k39 "varaus") ; --UNCHK
lin allocator_N = mkWN (k12 "jakelija") ; --UNCHK
lin allochronic_A = mkWA "allokroninen" ; --UNCHK
lin allochthonous_A = mkWA "alloktoninen" ; --UNCHK
lin allocution_N = mkWN (k2 "puhuttelu") ; --UNCHK
lin allogamous_A = mkWA (compoundA "risti" (k38 "pölytteinen")) ; --UNCHK
lin allogamy_N = mkWN (compoundN "risti" (k39 "pölytys")) ; --UNCHK
lin allogeneic_A = mkWA "allogeeninen" ; --UNCHK
lin allographic_A = mkWA "allografinen" ; --UNCHK
lin allomerism_N = mkWN (compoundN "allomer" (k5 "ismi")) ; --UNCHK
lin allomerous_A = mkWA "allomerinen" ; --UNCHK
lin allometric_A = mkWA (compoundA "allo" (k38 "metrinen")) ; --UNCHK
lin allometry_N = mkWN "allometria" ; --UNCHK
lin allomorph_N = mkWN "allomorfi" ; --UNCHK
lin allomorphic_A = mkWA "allomorfinen" ; --UNCHK
lin allopathic_A = mkWA "allopaattinen" ; --UNCHK
lin allopathy_N = mkWN "allopatia" ; --UNCHK
lin allopatric_A = mkWA "allopatrinen" ; --UNCHK
lin allopatry_N = mkWN "allopatria" ; --UNCHK
lin allophone_N = mkWN "allofoni" ; --UNCHK
lin allophonic_A = mkWA "allofoninen" ; --UNCHK
lin allopurinol_N = mkWN "Zyloprim" ; --UNCHK
lin allosaur_N = mkWN "allosaurus" ; --UNCHK
lin allot_V2 = mkWV2 (k56A "jakaa") ; --UNCHK
lin allotment_N = mkN "jakaminen" ; --mkWN (k5A "allokointi") ;
lin allotrope_N = mkWN (compoundN "allotropia" (k1A "muoto")) ; --UNCHK
lin allotropic_A = mkWA (compoundA "allo" (k38 "trooppinen")) ; --UNCHK
lin allotropy_N = mkWN "allotropia" ; --UNCHK
lin allover_A = mkWA (k27 "täysi") ; --UNCHK
lin allow_V2 = mkV2 "hyväksyä" | mkV2 "sallia" ;
lin allow_V2V = mkV2Vf (mkV "sallia") (mkPrep genitive) infFirst ;
lin allow_for_V2 = mkWV2 (k56A "antaa") ; --UNCHK
lin allow_of_V2 = prepV2 (lin V OP_allow_V2) OP_of_Prep ; -- guess-p-verb
lin allowable_A = mkWA (k38 "luvallinen") ; --UNCHK
lin allowance_N = mkN "osuus" ; --WN (k10A "lupa") ;
lin alloy_N = mkWN (k39 "seostus") ; --UNCHK
lin alloy_V2 = mkWV2 (k53 "seostaa") ; --UNCHK
lin allspice_N = mkWN (compoundN "mauste" (k6 "pippuri")) ; --UNCHK
lin allude_V = mkWV (k73 "vihjata") ; --UNCHK
lin allure_N = mkWN (k39 "viehätys") ; --UNCHK
lin allure_V2 = mkWV2 (k53A "viehättää") ; --UNCHK
lin allurement_N = mkWN (k39 "houkutus") ; --UNCHK
lin alluring_A = mkWA (k10 "viehättävä") ; --UNCHK
lin allusion_N = mkWN (k39 "viittaus") ; --UNCHK
lin allusive_A = mkWA "vihjaileva" ; --UNCHK
lin allusiveness_N = mkWN "vihjailevuus" ; --UNCHK
lin alluvial_A = mkWA "alluviaali-" ; --UNCHK
lin alluvion_N = mkWN (k10 "liettymä") ; --UNCHK
lin ally_N = mkN "liittolainen" ;
lin ally_V2 = mkWV2 (k52A "liittoutua") ; --UNCHK
lin allyl_N = mkWN (compoundN "allyyli" (k5 "radikaali")) ; --UNCHK
lin allylic_A = mkWA (compoundA "ally" (k38 "ylinen")) ; --UNCHK
lin alma_mater_N = mkWN (compoundN "yli" (k2 "opisto")) ; --UNCHK
lin almanac_N = mkWN (k9A "almanakka") ; --UNCHK
lin almandine_N = mkWN (compoundN "jalo" (k5A "granaatti")) ; --UNCHK
lin almandite_N = mkWN (compoundN "jalo" (k5A "granaatti")) ; --UNCHK
lin almeria_PN = foreignPN "Almeria" ;
lin almighty_A = mkWA (compoundA "kaikki" (k41 "valtias")) ; --UNCHK
lin almighty_N = mkWN (compoundN "Kaikki" (k41 "valtias")) ; --UNCHK
lin almond_N = mkWN (k6 "manteli") ; --UNCHK
lin almoner_N = mkWN (compoundN "sosiaali" (k10 "hoitaja")) "sairaalan" ; --UNCHK
lin almost_AdA = S.almost_AdA ;
lin almost_AdN = S.almost_AdN ;
lin almost_Adv = mkAdv "melkein" | mkAdv "lähes" ;
lin alms_box_N = mkWN (compoundN "almu" (k4A "laatikko")) ; --UNCHK
lin almsgiver_N = mkWN (compoundN "almun" (k10 "antaja")) ; --UNCHK
lin alnwick_PN = foreignPN "Alnwick" ;
lin alocasia_N = mkWN (compoundN "alok" (k12 "asia")) ; --UNCHK
lin aloe_N = mkWN (k3 "aaloe") ; --UNCHK
lin aloft_Adv = mkWAdv (k10 "yläilmakehässä") ; --UNCHK
lin aloha_N = mkWN (k99 "moi") ; --UNCHK
lin alone_A = mkA "yksinäinen" ;
lin aloneness_N = mkWN (k40 "yksinäisyys") ; --UNCHK
lin along_Adv = mkAdv "mukana" | mkAdv "mukaan" ; ---- split be along ; go along
lin along_Prep = mkPrep "pitkin" ;
lin alongside_Adv = mkWAdv (k99 "vieressä") ; --UNCHK
lin alongside_Prep = mkPrep "rinnalla" ;
lin aloof_A = mkWA (k99 "olevinaan") ; --UNCHK
lin aloof_Adv = mkWAdv (k99 "syrjässä") ; --UNCHK
lin aloofness_N = mkWN (k40 "sulkeutuneisuus") ; --UNCHK
lin alopecia_N = mkWN (k40 "kaljupäisyys") ; --UNCHK
lin alopecic_A = mkWA "sulkasato-" ; --UNCHK
lin aloud_Adv = mkWAdv (k99 "ääneen") ; --UNCHK
lin alp_N = mkWN (kH1 "vuori") "korkea" ; --UNCHK
lin alpaca_N = mkWN (kH1 "alpakka") ; --UNCHK
lin alpenstock_N = mkWN (compoundN "alppi" (k9 "sauva")) ; --UNCHK
lin alpestrine_A = mkWA (compoundA "sub" (k38 "alpiininen")) ; --UNCHK
lin alpha_A = mkWA "alfa-" ; --UNCHK
lin alpha_N = mkWN (k9 "alfa") ; --UNCHK
lin alphabet_N = mkWN (k5A "rudimentti") ; --UNCHK
lin alphabetic_A = mkWA (k38 "aakkosellinen") ; --UNCHK
lin alphabetical_A = mkWA (k38 "aakkosellinen") ; --UNCHK
lin alphabetization_N = mkWN (k39 "aakkostus") ; --UNCHK
lin alphabetized_A = mkWA (compoundA "aakkos" (k1 "tettu")) ; --UNCHK
lin alphabetizer_N = mkWN (compoundN "aak" (k10 "kostaja")) ; --UNCHK
lin alphanumeric_A = mkWA (compoundA "alfa" (k38 "numeerinen")) ; --UNCHK
lin alphanumerics_N = mkWN (k1 "merkistö") "aakkosnumeerinen" ; --UNCHK
lin alphavirus_N = mkWN (compoundN "alfa" (k39 "virus")) ; --UNCHK
lin alpine_A = mkWA "vuoristo-" ; --UNCHK
lin alpinist_N = mkWN (compoundN "vuori" (k12 "kiipeilijä")) ; --UNCHK
lin alprazolam_N = mkWN "Xanax" ; --UNCHK
lin already_AdV = mkAdV "jo" ;
lin already_Adv = L.already_Adv ;
lin alright_A = mkWA (k99 "oikein") ; --UNCHK
lin alright_Adv = mkWAdv (k99 "mukavasti") ; --UNCHK
lin alsatianFem_N = mkWN (k1 "saku") ; --UNCHK
lin alsatianMasc_N = mkWN (k1 "saku") ; --UNCHK
lin also_AdV = lin AdV (ss "myös") ;
lin also_Adv = mkAdv "myös" | mkAdv "lisäksi" ;
lin alstroemeria_N = mkWN (compoundN "prinsessa" (k9 "lilja")) ; --UNCHK
lin altar_N = mkWN (k6 "alttari") ; --UNCHK
lin altar_piece_N = mkWN (compoundN "alttari" (k1 "taulu")) ; --UNCHK
lin altazimuth_N = mkWN (compoundN "universaali" (k48 "koje")) ; --UNCHK
lin alter_V = mkWV (k62 "steriloida") ; --UNCHK
lin alter_V2 = mkWV2 (k62 "steriloida") ; --UNCHK
lin alter_ego_N = mkWN (k101 "minä") "toinen" ; --UNCHK
lin alterability_N = mkWN (k40 "muuttuvuus") ; --UNCHK
lin alterable_A = mkWA (k10 "oleva") "muutettavissa" ; --UNCHK
lin alteration_N = mkWN (compoundN "muu" (k38 "ttaminen")) ; --UNCHK
lin altercation_N = mkWN (k14A "rytäkkä") ; --UNCHK
lin altered_A = mkA "muutettu" ;
lin alternate_A = mkWA (k38 "vuoroittainen") ; --UNCHK
lin alternate_V = mkWV (k67A "vuorotella") ; --UNCHK
lin alternate_V2 = mkWV2 (k67A "vuorotella") ; --UNCHK
lin alternation_N = mkWN (k2 "vuorottelu") ; --UNCHK
lin alternative_A = mkWA (compoundA "vaihtoeh" (k38 "toinen")) ; --UNCHK
lin alternative_N = mkN "vaihto" (mkN "ehto") ; --f79
lin alternator_N = mkWN (compoundN "lataus" (k6 "generaattori")) ; --UNCHK
lin althea_N = mkWN "rohtosalkoruusu" ; --UNCHK
lin although_Subj = S.although_Subj ;
lin altimeter_N = mkWN (compoundN "korkeus" (k6 "mittari")) ; --UNCHK
lin altissimo_A = mkWA (k15 "korkea") "erittäin" ; --UNCHK
lin altitude_N = mkWN (k40 "korkeus") ; --UNCHK
lin altitudinal_A = mkWA "korkeus-" ; --UNCHK
lin altitudinous_A = mkWA "korkeus-" ; --UNCHK
lin alto_A = mkWA "altto-" ; --UNCHK
lin alto_N = mkWN (k1A "altto") ; --UNCHK
lin altocumulus_N = mkWN (compoundN "hahtuva" (k7 "pilvi")) ; --UNCHK
lin altogether_Adv = mkWAdv (k99 "tyystin") ; --UNCHK
lin alton_PN = foreignPN "Alton" ;
lin altostratus_N = mkWN (compoundN "verho" (k7 "pilvi")) ; --UNCHK
lin altricial_A = mkWA (compoundA "altrikia" (k38 "alinen")) ; --UNCHK
lin altrincham_PN = foreignPN "Altrincham" ;
lin altruism_N = mkWN (k5 "altruismi") ; --UNCHK
lin altruist_N = mkWN (k5A "filantrooppi") ; --UNCHK
lin altruistic_A = mkWA (k34A "pyyteetön") ; --UNCHK
lin alula_N = mkWN (compoundN "pikku" (k7A "siipi")) ; --UNCHK
lin alular_A = mkWA "alulaarinen" ; --UNCHK
lin alum_N = mkWN (k13 "aluna") ; --UNCHK
lin alumina_N = mkWN (compoundN "alumiini" (k5 "oksidi")) ; --UNCHK
lin aluminate_N = mkWN (compoundN "alumi" (k5A "naatti")) ; --UNCHK
lin aluminiferous_A = mkWA (compoundA "alunapi" (k38 "toinen")) ; --UNCHK
lin aluminium_N = mkWN (k5 "alumiini") ; --UNCHK
lin aluminous_A = mkWA (compoundA "alunapi" (k38 "toinen")) ; --UNCHK
lin aluminum_N = mkWN (k5 "alumiini") ; --UNCHK
lin alumnus_N = mkN "alumni" ;
lin alumroot_N = mkWN (compoundN "amerikankeijun" (k10A "kukka")) ; --UNCHK
lin alundum_N = mkWN (compoundN "teko" (k5 "korundi")) ; --UNCHK
lin alvechurch_PN = foreignPN "Alvechurch" ;
lin alveolar_A = mkWA "keuhkorakkula-" ; --UNCHK
lin alveolar_N = mkWN (k5A "konsonantti") "dentaalinen" ; --UNCHK
lin alveolate_A = mkWA (k38 "kennomainen") ; --UNCHK
lin alveolitis_N = mkWN (compoundN "keuhkorakkula" (k39 "tulehdus")) ; --UNCHK
lin alveolus_N = mkWN (compoundN "hammas" (k10A "kuoppa")) ; --UNCHK
lin alvine_A = mkWA "alviininen" ; --UNCHK
lin always_AdV = S.always_AdV ;
lin always_Adv = mkAdv "aina" ;
lin alyssum_N = mkWN "suku" "Alyssum" ; --UNCHK
lin amah_N = mkWN (k32A "palvelijatar") ; --UNCHK
lin amain_Adv = mkWAdv "kaikin" "voimin" ; --UNCHK
lin amalgam_N = mkWN (k10 "yhdistelmä") ; --UNCHK
lin amalgamate_V = mkWV (k53A "sulauttaa") "yhteen" ; --UNCHK
lin amalgamate_V2 = mkWV2 (k53A "sulauttaa") "yhteen" ; --UNCHK
lin amalgamation_N = mkWN (k3 "fuusio") ; --UNCHK
lin amalgamative_A = mkWA "yhdistymis-" ; --UNCHK
lin amalgamator_N = mkWN "fuusioija" ; --UNCHK
lin amanuensis_N = mkWN (compoundN "pika" (k10 "kirjoittaja")) ; --UNCHK
lin amaranth_N = mkWN (compoundN "revon" (k10A "häntä")) ; --UNCHK
lin amaranthine_A = mkWA "amarantti-" ; --UNCHK
lin amarelle_N = mkWN (compoundN "hapan" (k14A "kirsikka")) ; --UNCHK
lin amaretto_N = mkWN "amaretto" ; --UNCHK
lin amaryllis_N = mkWN (k39 "amaryllis") ; --UNCHK
lin amass_V2 = mkV2 "kasata" ; --WV2 (k52A "kertyä") ;
lin amastia_N = mkWN "amastia" ; --UNCHK
lin amateurFem_N = mkWN (k12 "harrastelija") | mkN "ama" (mkN "tööri") ;
lin amateurMasc_N = variants {} ; --
lin amateur_A = mkWA "ei-ammattilais-" ; --UNCHK
lin amateurish_A = mkWA (k34A "taitamaton") ; --UNCHK
lin amateurishness_N = mkWN (compoundN "amatöörimä" (k40 "isyys")) ; --UNCHK
lin amateurism_N = mkWN (compoundN "kanna" (k38 "ttaminen")) "amatööriurheilun" ; --UNCHK
lin amative_A = mkWA (k41A "lemmekäs") ; --UNCHK
lin amatory_A = mkWA (k38 "romanttinen") ; --UNCHK
lin amaurosis_N = mkWN "amauroosi" ; --UNCHK
lin amaurotic_A = mkWA "amauroottinen" ; --UNCHK
lin amaze_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin amaze_V2V = mkWV2V (k53A "sekoittaa") ; --UNCHK
lin amazement_N = mkWN (k39 "ihmetys") ; --UNCHK
lin amazing_A = mkWA (k10 "vaikuttava") ; --UNCHK
lin amazon_N = mkWN (compoundN "amatsoni" (k9 "papukaija")) ; --UNCHK
lin ambassador_N = mkN "suur" (mkN "lähettiläs") ;
lin ambassadorial_A = mkWA "suurlähettilään" ; --UNCHK
lin ambassadorship_N = mkWN (k9A "virka") "suurlähettilään" ; --UNCHK
lin ambassadress_N = mkWN (k2 "puoliso") "suurlähettilään" ; --UNCHK
lin amber_A = mkWA (compoundA "ruskean" (k38 "keltainen")) ; --UNCHK
lin amber_N = mkWN (k38 "keltainen") ; --UNCHK
lin ambergris_N = mkWN (k9 "ambra") "harmaa" ; --UNCHK
lin amberjack_N = mkWN "amberfish" ; --UNCHK
lin ambidexterity_N = mkWN (compoundN "molempi" (k40 "kätisyys")) ; --UNCHK
lin ambidextrous_A = mkWA "molempikätinen" ; --UNCHK
lin ambience_N = mkWN (k1 "ympäristö") ; --UNCHK
lin ambient_A = mkWA "ympäröivä" ; --UNCHK
lin ambiguity_N = mkWN (compoundN "epä" (k40 "selvyys")) ; --UNCHK
lin ambiguous_A = mkWA (compoundA "epä" (k10 "selvä")) ; --UNCHK
lin ambit_N = mkWN (k40 "ulottuvuus") ; --UNCHK
lin ambition_N = mkWN (k39 "pyrkimys") ; --UNCHK
lin ambitious_A = mkWA (compoundA "kunnianhi" (k38 "moinen")) ;
lin ambivalence_N = mkWN (k5 "ambivalenssi") ; --UNCHK
lin ambivalent_A = mkWA (k38 "ambivalenttinen") ; --UNCHK
lin ambiversion_N = mkWN (compoundN "ambi" (k3 "versio")) ; --UNCHK
lin ambiversive_A = mkWA "ambivertti" ; --UNCHK
lin amble_N = mkWN (k2 "vaeltelu") ; --UNCHK
lin amble_V = mkWV (k67 "tallustella") ; --UNCHK
lin amblygonite_N = mkWN (compoundN "amblygo" (k5A "niitti")) ; --UNCHK
lin amblyopia_N = mkWN (compoundN "heikko" (k40 "näköisyys")) ; --UNCHK
lin amblyopic_A = mkWA (compoundA "heikko" (k38 "näköinen")) ; --UNCHK
lin amboyna_N = mkWN "Pterocarpus" "indicus" ; --UNCHK
lin ambrosia_N = mkWN (k6 "nektari") ; --UNCHK
lin ambrosial_A = mkWA "ambrosia-" ; --UNCHK
lin ambulacral_A = mkWA (compoundA "ambulakra" (k38 "alinen")) ; --UNCHK
lin ambulacrum_N = mkWN "ambulakrum" ; --UNCHK
lin ambulance_N = mkWN (k5 "ambulanssi") ; --UNCHK
lin ambulant_A = mkWA (k10 "oleva") "jalkeilla" ; --UNCHK
lin ambulation_N = mkWN (compoundN "liik" (k38 "kuminen")) ; --UNCHK
lin ambulatory_A = mkWA "kävely-" ; --UNCHK
lin ambulatory_N = mkWN (k10 "käytävä") "katettu" ; --UNCHK
lin ambuscade_N = mkWN (k9 "ansa") ; --UNCHK
lin ambuscade_V2 = mkWV2 (k53A "odottaa") "makuulla" ; --UNCHK
lin ambush_N = mkWN (k9 "ansa") ; --UNCHK
lin ambush_V2 = mkWV2 (k53A "odottaa") "makuulla" ; --UNCHK
lin ambusher_N = mkWN "väijyjä" ; --UNCHK
lin ambystomid_N = mkWN "aksolotli" ; --UNCHK
lin amebiasis_N = mkWN (k5A "tauti") "ameban" "aiheuttama" ; --UNCHK
lin ameboid_A = mkWA (compoundA "ameba" (k38 "mainen")) ; --UNCHK
lin ameer_N = mkWN (k6 "emiiri") ; --UNCHK
lin amelia_N = mkWN "amelia" ; --UNCHK
lin ameliorate_V = mkWV (k52A "parantua") ; --UNCHK
lin ameliorate_V2 = mkWV2 (k52A "parantua") ; --UNCHK
lin amelioration_N = mkWN (k39 "parannus") ; --UNCHK
lin ameloblast_N = mkWN (compoundN "amelob" (k5 "lasti")) ; --UNCHK
lin amelogenesis_N = mkWN "amelogeneesi" ; --UNCHK
lin amen_Interj = mkInterj "aamen" ;
lin amenability_N = mkWN (k40 "mukautuvuus") ; --UNCHK
lin amenable_A = mkWA (k38 "myöntyväinen") ; --UNCHK
lin amend_V = mkWV (k53A "muuttaa") ; --UNCHK
lin amend_V2 = mkWV2 (k53A "muuttaa") ; --UNCHK
lin amend_V2V = mkWV2V (k53A "muuttaa") ; --UNCHK
lin amendable_A = mkWA (k10 "oleva") "oikaistavissa" ; --UNCHK
lin amendatory_A = mkWA (compoundA "korj" (k9 "aava")) ; --UNCHK
lin amendment_N = mkWN (k2 "oikaisu") ; --f60
lin amenity_N = mkWN (k40 "mukavuus") ; --UNCHK
lin amenorrhea_N = mkWN (k12 "amenorrea") ; --UNCHK
lin amenorrheic_A = mkWA "amenorreeinen" ; --UNCHK
lin amentiferous_A = mkWA "urpu-" ; --UNCHK
lin amerciable_A = mkWA (k10 "oleva") "sakotettavissa" ; --UNCHK
lin america_PN = mkPN "Amerikka" ;
lin americanFem_N = mkWN (compoundN "Ame" (k9A "rikka")) ; --UNCHK
lin americanMasc_N = mkN "amerikkalainen" ;
lin american_A = mkA "amerikkalainen" ;
lin americanism_N = mkWN (k40 "amerikkalaisuus") ; --UNCHK
lin americanize_V2 = mkWV2 (k52 "amerikkalaistua") ; --UNCHK
lin amesbury_PN = foreignPN "Amesbury" ;
lin ametabolic_A = mkWA "ametabolinen" ; --UNCHK
lin amethyst_A = mkWA (compoundA "ametistin" (k38 "värinen")) ; --UNCHK
lin amethyst_N = mkWN (k5 "ametisti") ; --UNCHK
lin amethystine_A = mkWA (compoundA "ametisti" (k38 "mainen")) ; --UNCHK
lin ametria_N = mkWN "ametria" ; --UNCHK
lin ametropia_N = mkWN "ametropia" ; --UNCHK
lin ametropic_A = mkWA (compoundA "ame" (k38 "trooppinen")) ; --UNCHK
lin amiability_N = mkWN (k40 "sydämellisyys") ; --UNCHK
lin amiable_A = mkWA (k10 "mukava") ; --UNCHK
lin amicability_N = mkWN (k40 "sovinnollisuus") ; --UNCHK
lin amicable_A = mkWA (k10 "sopuisa") ; --UNCHK
lin amid_Prep = mkPrep "keskellä" ;
lin amide_N = mkWN "amidi" ; --UNCHK
lin amidship_A = mkWA (k99 "keskivaiheilla") ; --UNCHK
lin amidship_Adv = mkWAdv (compoundAdv "keskilai" (k99 "vaan")) ; --UNCHK
lin amidships_Adv = mkWAdv (k99 "keskivaiheille") ; --UNCHK
lin amidst_Prep = mkPrep "keskellä" ;
lin amiens_PN = foreignPN "Amiens" ;
lin amigo_N = mkWN (k6 "kaveri") ; --UNCHK
lin amino_A = mkWA "amiini-" ; --UNCHK
lin amino_N = mkWN (compoundN "amino" (k10 "ryhmä")) ; --UNCHK
lin aminoaciduria_N = mkWN "aminoasiduria" ; --UNCHK
lin aminomethane_N = mkWN (compoundN "amino" (k5 "metaani")) ; --UNCHK
lin aminophylline_N = mkWN "aminofylliini" ; --UNCHK
lin aminopyrine_N = mkWN "amidopyriini" ; --UNCHK
lin amiodarone_N = mkWN "Cordarone" ; --UNCHK
lin amir_N = mkWN (k6 "emiiri") ; --UNCHK
lin amiss_A = mkWA (k99 "sekaisin") ; --UNCHK
lin amiss_Adv = mkWAdv (k99 "huonosti") ; --UNCHK
lin amitosis_N = mkWN (k38 "solunjakautuminen") "välitön" ; --UNCHK
lin amitotic_A = mkWA "amitoottinen" ; --UNCHK
lin amitriptyline_N = mkWN "Elavil" ; --UNCHK
lin amity_N = mkWN (k40 "sydämellisyys") ; --UNCHK
lin ammanford_PN = foreignPN "Ammanford" ;
lin ammeter_N = mkWN (compoundN "virta" (k6 "mittari")) ; --UNCHK
lin ammine_N = mkWN "ammiini" ; --UNCHK
lin ammino_A = mkWA "ammiini-" ; --UNCHK
lin ammobium_N = mkWN (compoundN "iäisyyden" (k10A "kukka")) ; --UNCHK
lin ammonia_N = mkWN (k5A "ammoniakki") ; --UNCHK
lin ammoniac_A = mkWA (compoundA "ammoniaka" (k38 "alinen")) ; --UNCHK
lin ammoniac_N = mkWN (compoundN "ammoniakki" (k5 "kumi")) ; --UNCHK
lin ammoniated_A = mkWA "ammoniakilla" "käsitelty" ; --UNCHK
lin ammonification_N = mkWN (compoundN "ammoniakki" (k38 "utuminen")) ; --UNCHK
lin ammonite_N = mkWN (compoundN "ammo" (k5A "niitti")) ; --UNCHK
lin ammonitic_A = mkWA "ammoniittinen" ; --UNCHK
lin ammonium_N = mkWN (compoundN "ammonium" (k5 "ioni")) ; --UNCHK
lin ammoniuria_N = mkWN "ammoniuria" ; --UNCHK
lin ammunition_N = mkN "ampumatarvike" ;
lin amnesia_N = mkWN (k40 "muistamattomuus") ; --UNCHK
lin amnesic_A = mkWA "muistinmenetys-" ; --UNCHK
lin amnesic_N = mkWN (k2 "henkilö") "muistamaton" ; --UNCHK
lin amnestic_A = mkWA "muistinmenetys-" ; --UNCHK
lin amnesty_N = mkWN (k39 "armahdus") ; --UNCHK
lin amniocentesis_N = mkWN (k1A "otto") "lapsivesinäytteen" ; --UNCHK
lin amnion_N = mkWN (compoundN "vesi" (k1 "kalvo")) ; --UNCHK
lin amniote_N = mkWN (compoundN "vesi" (k38 "kalvollinen")) ; --UNCHK
lin amniotic_A = mkWA "sikiökalvo-" ; --UNCHK
lin amoeba_N = mkWN (k9 "ameba") ; --UNCHK
lin amoebic_A = mkWA (compoundA "ameba" (k38 "mainen")) ; --UNCHK
lin among_Prep = postPrep genitive "joukossa" ;
lin amongst_Prep = postPrep genitive "joukossa" ;
lin amora_N = mkWN "amora" ; --UNCHK
lin amoralism_N = mkWN "amoraalisuus" ; --UNCHK
lin amoralist_N = mkWN "amoralisti" ; --UNCHK
lin amorality_N = mkWN (compoundN "amoral" (k5 "ismi")) ; --UNCHK
lin amorist_N = mkWN (compoundN "amo" (k5 "risti")) ; --UNCHK
lin amoristic_A = mkWA "amoristinen" ; --UNCHK
lin amorous_A = mkWA (k41A "lemmekäs") ; --UNCHK
lin amorousness_N = mkWN (k40 "seksikkyys") ; --UNCHK
lin amorpha_N = mkWN (compoundN "sulkapensas" (k1A "suku")) ; --UNCHK
lin amorphous_A = mkWA (k38 "amorfinen") ; --UNCHK
lin amort_A = mkWA (k47 "kuollut") ; --UNCHK
lin amortization_N = mkWN (k39 "lyhennys") ; --UNCHK
lin amortize_V2 = mkWV2 (k54A "lyhentää") ; --UNCHK
lin amount_N = mkN "summa" ;
lin amount_V = mkWV (k66 "nousta") ;
lin amour_N = mkWN (k48A "suhde") "intiimi" ; --UNCHK
lin amour_propre_N = mkWN (k40 "turhamaisuus") ; --UNCHK
lin amoxicillin_N = mkWN "Augmentin" ; --UNCHK
lin amp_Conj = mkConj "&" ;
lin amp_N = mkWN (k6 "ampeeri") ; --UNCHK
lin amperage_N = mkWN (compoundN "ampeeri" (k10 "määrä")) ; --UNCHK
lin ampere_N = mkWN (k6 "ampeeri") ; --UNCHK
lin ampersand_N = mkWN (compoundN "et-" (k5A "merkki")) ; --UNCHK
lin amphetamine_N = mkWN (k5A "vauhti") ; --UNCHK
lin amphibia_N = mkWN "luokka" "Amphibia" ; --UNCHK
lin amphibian_N = mkWN (compoundN "sammakko" (k33 "eläin")) ; --UNCHK
lin amphibiotic_A = mkWA (compoundA "semi" (k38 "akvaattinen")) ; --UNCHK
lin amphibious_A = mkWA "amfibio-" ; --UNCHK
lin amphibole_N = mkWN "amfiboli" ; --UNCHK
lin amphibolite_N = mkWN "amfiboliitti" ; --UNCHK
lin amphibology_N = mkWN "amfibolia" ; --UNCHK
lin amphibrach_N = mkWN (compoundN "amfib" (k5 "raki")) ; --UNCHK
lin amphictyony_N = mkWN (compoundN "amfiktyoni" (k1A "liitto")) ; --UNCHK
lin amphidiploid_N = mkWN (compoundN "amfi" (k5 "diploidi")) ; --UNCHK
lin amphidiploidy_N = mkWN (compoundN "amfidiploi" (k9 "dia")) ; --UNCHK
lin amphigory_N = mkWN "hölynpölyrunomitta" ; --UNCHK
lin amphimixis_N = mkWN "amfimiksis" ; --UNCHK
lin amphipod_N = mkWN "amfipodi" ; --UNCHK
lin amphiprostylar_A = mkWA (compoundA "amfipros" (k38 "tyylinen")) ; --UNCHK
lin amphisbaena_N = mkWN "suku" "Amphisbaenia" ; --UNCHK
lin amphistylar_A = mkWA (compoundA "amfipros" (k38 "tyylinen")) ; --UNCHK
lin amphitheatre_N = mkWN (compoundN "amfi" (k6 "teatteri")) ; --UNCHK
lin amphitheatric_A = mkWA (compoundA "amfiteatteri" (k38 "mainen")) ; --UNCHK
lin amphitropous_A = mkWA (compoundA "amfi" (k38 "trooppinen")) ; --UNCHK
lin amphiuma_N = mkWN (compoundN "ankerias" (k6 "salamanteri")) ; --UNCHK
lin amphora_N = mkWN (k10 "amfora") ; --UNCHK
lin amphoric_A = mkWA (compoundA "amfora" (k38 "mainen")) ; --UNCHK
lin amphoteric_A = mkWA "amfiproottinen" ; --UNCHK
lin amphotericin_N = mkWN (compoundN "amfote" (k5 "risiini")) ; --UNCHK
lin ampicillin_N = mkWN "SK-Ampicillin" ; --UNCHK
lin ample_A = mkWA (k41 "runsas") ; --UNCHK
lin ampleness_N = mkWN "kookkaus" ; --UNCHK
lin amplification_N = mkWN "vahvistaminen" ; --UNCHK
lin amplifier_N = mkWN (k33 "vahvistin") ; --UNCHK
lin amplify_V2 = mkWV2 (k53 "voimistaa") ; --UNCHK
lin amplitude_N = mkWN (k5 "amplitudi") ; --UNCHK
lin ampoule_N = mkWN (k5 "ampulli") ; --UNCHK
lin ampulla_N = mkWN (k5 "ampulli") ; --UNCHK
lin ampullar_A = mkWA (compoundA "ampulli" (k38 "mainen")) ; --UNCHK
lin amputate_V2 = mkWV2 (k66 "katkaista") ; --UNCHK
lin amputation_N = mkWN (k5A "amputointi") ; --UNCHK
lin amputator_N = mkWN (k12 "katkaisija") ; --UNCHK
lin amputee_N = mkWN (compoundN "amputo" (k1A "itu")) ; --UNCHK
lin amrinone_N = mkWN "Inocor" ; --UNCHK
lin amsterdam_PN = foreignPN "Amsterdam" ;
lin amuck_A = mkWA (k1 "hullu") ; --UNCHK
lin amuck_Adv = mkWAdv (k99 "murhaavasti") ; --UNCHK
lin amulet_N = mkWN (k5 "talismaani") ; --UNCHK
lin amuse_V2 = mkWV2 (k53A "viihdyttää") ; --UNCHK
lin amusement_N = mkWN (k5 "huvi") ; --UNCHK
lin amusing_A = mkWA (k1 "hassu") ;
lin amygdala_N = mkWN (compoundN "manteli" (k48A "tumake")) ; --UNCHK
lin amygdalin_N = mkWN "amygdaliini" ; --UNCHK
lin amygdaline_A = mkWA (compoundA "manteli" (k38 "mainen")) ; --UNCHK
lin amygdaloid_N = mkWN (compoundN "manteli" (k7 "kivi")) ; --UNCHK
lin amylase_N = mkWN (compoundN "amyl" (k5 "aasi")) ; --UNCHK
lin amyloid_N = mkWN "amyloidi" ; --UNCHK
lin amyloidosis_N = mkWN "amyloidoosi" ; --UNCHK
lin amylolysis_N = mkWN (compoundN "amyloly" (k5 "ysi")) ; --UNCHK
lin amylolytic_A = mkWA "amylolyyttinen" ; --UNCHK
lin amyotrophia_N = mkWN "amyotrofia" ; --UNCHK
lin amyxia_N = mkWN "limattomuus" ; --UNCHK
lin ana_N = mkWN (compoundN "kasku" (k10 "kokoelma")) ; --UNCHK
lin anabatic_A = mkWA "anabaattinen" ; --UNCHK
lin anabiosis_N = mkWN "anabioosi" ; --UNCHK
lin anabolic_A = mkWA (k38 "anabolinen") ; --UNCHK
lin anabolism_N = mkWN (compoundN "metabol" (k5 "ismi")) "konstruktiivinen" ; --UNCHK
lin anachronic_A = mkWA (k34A "sopimaton") "aikaan" ; --UNCHK
lin anachronism_N = mkWN (k5 "anakronismi") ; --UNCHK
lin anachronistic_A = mkWA (k34A "sopimaton") "aikaan" ; --UNCHK
lin anachronistically_Adv = mkWAdv (k99 "anakronistisesti") ; --UNCHK
lin anaclinal_A = mkWA (compoundA "anaklina" (k38 "alinen")) ; --UNCHK
lin anaclisis_N = mkWN (compoundN "anakl" (k5 "iisi")) ; --UNCHK
lin anaclitic_A = mkWA "anakliittinen" ; --UNCHK
lin anacoluthia_N = mkWN "anakoluton" ; --UNCHK
lin anacoluthic_A = mkWA (k38 "anakoluuttinen") ; --UNCHK
lin anaconda_N = mkWN (k10 "anakonda") ; --UNCHK
lin anadiplosis_N = mkWN (compoundN "anadip" (k5 "loosi")) ; --UNCHK
lin anadromous_A = mkWA "anadrominen" ; --UNCHK
lin anaemia_N = mkWN (k12 "anemia") ; --UNCHK
lin anaemic_A = mkWA (k38 "aneeminen") ; --UNCHK
lin anaerobe_N = mkWN "anaerobi" ; --UNCHK
lin anaesthesia_N = mkWN (k12 "anestesia") ; --UNCHK
lin anaesthetic_A = mkWA (compoundA "anest" (k38 "eettinen")) ; --UNCHK
lin anaesthetic_N = mkWN (k48A "puudute") ; --UNCHK
lin anaesthetist_N = mkWN (k10 "antaja") "nukutuksen" ; --UNCHK
lin anaesthetize_V2 = mkWV2 (k53A "puuduttaa") ; --UNCHK
lin anaglyph_N = mkWN "anaglyfi" ; --UNCHK
lin anaglyphic_A = mkWA "anaglyptinen" ; --UNCHK
lin anaglyphy_N = mkWN "anaglyfia" ; --UNCHK
lin anagnost_N = mkWN (k12 "lukija") ; --UNCHK
lin anagoge_N = mkWN "anagogia" ; --UNCHK
lin anagogic_A = mkWA "anagoginen" ; --UNCHK
lin anagram_N = mkWN (k5 "anagrammi") ; --UNCHK
lin anagrammatic_A = mkWA (compoundA "ana" (k38 "grammaattinen")) ; --UNCHK
lin anal_A = mkWA (k38 "anaalinen") ; --UNCHK
lin analbuminemia_N = mkWN (k39 "puutos") "albumiinin" ; --UNCHK
lin analects_N = mkWN "analekti" ; --UNCHK
lin analeptic_A = mkWA "analeptinen" ; --UNCHK
lin analeptic_N = mkWN (compoundN "analepti" (k5 "kumi")) ; --UNCHK
lin analgesia_N = mkWN (k12 "analgesia") ; --UNCHK
lin analgesic_A = mkWA (k38 "analgeettinen") ; --UNCHK
lin analgesic_N = mkWN (k5A "analgeetti") ; --UNCHK
lin analog_N = mkWN (k12 "analogia") ; --UNCHK
lin analogical_A = mkWA (k38 "analoginen") ; --UNCHK
lin analogist_N = mkWN "analogi" ; --UNCHK
lin analogous_A = mkWA (k38 "analoginen") ; --UNCHK
lin analogue_A = mkWA (k38 "lineaarinen") ; --UNCHK
lin analogue_N = mkWN (k12 "analogia") ; --UNCHK
lin analogy_N = mkWN (k40 "vastaavuus") ; --UNCHK
lin analphabet_N = mkWN (k5A "analfabeetti") ; --UNCHK
lin analphabetic_A = mkWA (compoundA "luku" (k34A "taidoton")) ; --UNCHK
lin analysand_N = mkWN (k2 "henkilö") "psykoanalyysiä" "saava" ; --UNCHK
lin analysis_N = mkN "analyysi" | mkWN (k2 "tarkastelu") ;
lin analyst_N = mkN (lin NK {s = d04A "analyytikko"}) ;
lin analytic_A = mkWA (k38 "analyyttinen") ; --UNCHK
lin analytical_A = mkWA (k38 "analyyttinen") ; --UNCHK
lin analyticity_N = mkWN (k40 "analyyttisyys") ; --UNCHK
lin analyze_V2 = mkWV2 (k62 "analysoida") ; --UNCHK
lin analyzer_N = mkWN (k6 "analysaattori") ; --UNCHK
lin anamnestic_A = mkWA (k38 "anamnestinen") ; --UNCHK
lin anamorphic_A = mkWA "anamorfinen" ; --UNCHK
lin anamorphism_N = mkWN (compoundN "anamorf" (k5 "ismi")) ; --UNCHK
lin anamorphosis_N = mkWN (compoundN "anamorf" (k5 "ismi")) ; --UNCHK
lin anapaest_N = mkWN (compoundN "ana" (k5 "pesti")) ; --UNCHK
lin anapaestic_A = mkWA "anapestinen" ; --UNCHK
lin anapest_N = mkWN (compoundN "ana" (k5 "pesti")) ; --UNCHK
lin anapestic_A = mkWA "anapestinen" ; --UNCHK
lin anaphase_N = mkWN (compoundN "ana" (k5 "faasi")) ; --UNCHK
lin anaphasic_A = mkWA "anafaattinen" ; --UNCHK
lin anaphor_N = mkWN (compoundN "anaf" (k10 "ora")) ; --UNCHK
lin anaphora_N = mkWN (compoundN "anaf" (k10 "ora")) ; --UNCHK
lin anaphoric_A = mkWA "anaforinen" ; --UNCHK
lin anaphrodisia_N = mkWN (k48A "puute") "sukupuolivietin" ; --UNCHK
lin anaphrodisiac_A = mkWA "sukupuoliviettiä" "heikentävä" ; --UNCHK
lin anaphylactic_A = mkWA "anafylaktinen" ; --UNCHK
lin anaphylaxis_N = mkWN "anafylaksia" ; --UNCHK
lin anaplasia_N = mkWN (compoundN "anapl" (k12 "asia")) ; --UNCHK
lin anaplasmosis_N = mkWN "anaplasmoosi" ; --UNCHK
lin anaplastic_A = mkWA (compoundA "ana" (k38 "plastinen")) ; --UNCHK
lin anapsid_N = mkWN (compoundN "anapsidi" (k12 "matelija")) ; --UNCHK
lin anarchic_A = mkWA (k34A "laiton") ; --UNCHK
lin anarchism_N = mkWN (k5 "anarkismi") ; --UNCHK
lin anarchistFem_N = mkWN (k5 "syndikalisti") ; --UNCHK
lin anarchistMasc_N = mkWN (k5 "syndikalisti") ; --UNCHK
lin anarchistic_A = mkWA (k38 "anarkistinen") ; --UNCHK
lin anarchy_N = mkWN (k40 "laittomuus") ; --UNCHK
lin anarthria_N = mkWN "anartria" ; --UNCHK
lin anasarca_N = mkWN (compoundN "anas" (k9A "arka")) ; --UNCHK
lin anasarcous_A = mkWA "anasarkoottinen" ; --UNCHK
lin anaspid_N = mkWN "anaspidi" ; --UNCHK
lin anastigmat_N = mkWN (k5 "linssi") "anastigmaattinen" ; --UNCHK
lin anastigmatic_A = mkWA (compoundA "stigma" (k38 "attinen")) ; --UNCHK
lin anastomosis_N = mkWN "yhdyshaarojen" "muodostuminen" ; --UNCHK
lin anastomotic_A = mkWA "anastomoottinen" ; --UNCHK
lin anastrophe_N = mkWN (compoundN "sana" (k39 "järjestys")) "käänteinen" ; --UNCHK
lin anastylosis_N = mkWN (compoundN "anasty" (k5 "loosi")) ; --UNCHK
lin anathema_N = mkWN (compoundN "ana" (k9 "teema")) ; --UNCHK
lin anathematization_N = mkWN (k39 "karkotus") ; --UNCHK
lin anathematize_V = mkWV (k53 "julistaa") "pannaan" ; --UNCHK
lin anathematize_V2 = mkWV2 (k53 "julistaa") "pannaan" ; --UNCHK
lin anatomic_A = mkWA (k38 "anatominen") ; --UNCHK
lin anatomical_A = mkWA (k38 "anatominen") ; --UNCHK
lin anatomist_N = mkWN (k5 "anatomi") ; --UNCHK
lin anatomy_N = mkWN (k12 "anatomia") ; --UNCHK
lin anatotitan_N = mkWN (compoundN "jätti" (k9A "ankka")) ; --UNCHK
lin anatoxin_N = mkWN (compoundN "ana" (k5 "toksiini")) ; --UNCHK
lin anatropous_A = mkWA (k38 "käänteinen") ; --UNCHK
lin ancestor_N = mkWN (compoundN "kanta" (k10 "isä")) ; --UNCHK
lin ancestral_A = mkWA (compoundA "per" (k1 "itty")) "esi-isiltä" ; --UNCHK
lin ancestress_N = mkWN (compoundN "esi" (k5A "äiti")) ; --UNCHK
lin ancestry_N = mkWN (k40 "sukulaisuus") ; --UNCHK
lin anchor_N = mkWN (k6 "ankkuri") ; --UNCHK
lin anchor_V = mkWV (k53A "heittää") "ankkuri" ; --UNCHK
lin anchor_V2 = mkWV2 (k53A "heittää") "ankkuri" ; --UNCHK
lin anchorage_N = mkWN (k5A "ankkurointi") ; --UNCHK
lin anchorite_N = mkWN (k4A "erakko") ; --UNCHK
lin anchoritic_A = mkWA (compoundA "erakko" (k38 "mainen")) ; --UNCHK
lin anchorman_N = mkWN (k10 "juontaja") ; --UNCHK
lin anchovy_N = mkWN (k6 "sardelli") ; --UNCHK
lin anchusa_N = mkWN (k5 "rasti") ; --UNCHK
lin ancient_A = mkWA (compoundA "iki" (k9 "vanha")) ;
lin ancient_N = mkWN (k36 "vanhin") ; --UNCHK
lin ancientness_N = mkWN (k40 "muinaisuus") ; --UNCHK
lin ancillary_A = mkWA (k10 "kuuluva") ; --UNCHK
lin ancona_PN = foreignPN "Ancona" ;
lin and_Conj = S.and_Conj ;
lin andante_A = mkWA "andante" ; --UNCHK
lin andante_Adv = mkWAdv "andante" ; --UNCHK
lin andante_N = mkWN "käyden" ; --UNCHK
lin andantino_A = mkWA "andantino" ; --UNCHK
lin andesite_N = mkWN "andesiitti" ; --UNCHK
lin andiron_N = mkWN (k48 "teline") ; --UNCHK
lin andorra_PN = foreignPN "Andorra" ;
lin andorran_A = mkWA (compoundA "andorr" (k38 "alainen")) ; --UNCHK
lin andorran_N = mkWN (compoundN "andorr" (k38 "alainen")) ; --UNCHK
lin andover_PN = foreignPN "Andover" ;
lin andradite_N = mkWN "andradiitti" ; --UNCHK
lin andrena_N = mkWN (compoundN "maa" (k38 "mehiläinen")) ; --UNCHK
lin androecium_N = mkWN (k3 "hetiö") ; --UNCHK
lin androgen_N = mkWN (k5 "androgeeni") ; --UNCHK
lin androgenesis_N = mkWN "androgenia" ; --UNCHK
lin androgenetic_A = mkWA (k38 "androgeeninen") ; --UNCHK
lin androgenic_A = mkWA (k38 "androgeeninen") ; --UNCHK
lin androglossia_N = mkWN "androglossia" ; --UNCHK
lin androgynous_A = mkWA (k38 "androgyyninen") ; --UNCHK
lin androgyny_N = mkWN (k40 "biseksuaalisuus") ; --UNCHK
lin android_N = mkWN (k38 "ihminen") "mekaaninen" ; --UNCHK
lin andromeda_N = mkWN "Andromeda" ; --UNCHK
lin androphobia_N = mkWN (compoundN "mies" (k1 "kammo")) ; --UNCHK
lin androsterone_N = mkWN "androsteroni" ; --UNCHK
lin anecdotal_A = mkWA (compoundA "kasku" (k38 "mainen")) ; --UNCHK
lin anecdote_N = mkWN (k12 "tarina") ; --UNCHK
lin anecdotic_A = mkWA (compoundA "anekdootti" (k38 "mainen")) ; --UNCHK
lin anecdotist_N = mkWN (k10 "kertoja") ; --UNCHK
lin anechoic_A = mkWA (k34A "kaiuton") ; --UNCHK
lin anemia_N = mkWN "suku" "Anemia" ; --UNCHK
lin anemic_A = mkWA (k38 "aneeminen") ; --UNCHK
lin anemographic_A = mkWA (compoundA "ane" (k38 "mografinen")) ; --UNCHK
lin anemography_N = mkWN "anemografia" ; --UNCHK
lin anemometer_N = mkWN (compoundN "tuuli" (k6 "mittari")) ; --UNCHK
lin anemometric_A = mkWA (compoundA "anemo" (k38 "metrinen")) ; --UNCHK
lin anemometry_N = mkWN "anemometria" ; --UNCHK
lin anemone_N = mkWN (compoundN "meri" (k1A "vuokko")) ; --UNCHK
lin anemophilous_A = mkWA (compoundA "tuuli" (k38 "pölytteinen")) ; --UNCHK
lin anencephalic_A = mkWA "aivoton" ; --UNCHK
lin anencephaly_N = mkWN "aivottomuus" ; --UNCHK
lin anergy_N = mkWN "anergia" ; --UNCHK
lin aneroid_A = mkWA "aneroidi" ; --UNCHK
lin aneroid_N = mkWN (compoundN "aneroidi-ilma" (k6 "puntari")) ; --UNCHK
lin anesthesia_N = mkWN (k12 "anestesia") ; --UNCHK
lin anesthesiologist_N = mkWN (k10 "antaja") "nukutuksen" ; --UNCHK
lin anesthesiology_N = mkWN (k12 "anestesiologia") ; --UNCHK
lin anesthetic_A = mkWA (compoundA "anest" (k38 "eettinen")) ; --UNCHK
lin anesthetic_N = mkWN (k48A "puudute") ; --UNCHK
lin anesthetist_N = mkWN (k10 "antaja") "nukutuksen" ; --UNCHK
lin anesthetize_V2 = mkWV2 (k53A "puuduttaa") ; --UNCHK
lin anesthyl_N = mkWN (compoundN "anes" (k5 "tyyli")) ; --UNCHK
lin anestrus_N = mkWN (k9A "lepoaika") ; --UNCHK
lin aneuploid_A = mkWA (compoundA "ane" (k38 "uploidinen")) ; --UNCHK
lin aneuploidy_N = mkWN (compoundN "aneuploi" (k9 "dia")) ; --UNCHK
lin aneurysm_N = mkWN (k9 "aneurysma") ; --UNCHK
lin aneurysmal_A = mkWA (compoundA "ane" (k38 "urysmaattinen")) ; --UNCHK
lin anew_Adv = mkWAdv (k99 "uudelleen") ; --UNCHK
lin anfractuous_A = mkWA (k41A "mutkikas") ; --UNCHK
lin angel_N = mkN "enkeli" ;
lin angelfish_N = mkWN (compoundN "meri" (k6 "enkeli")) ; --UNCHK
lin angelic_A = mkWA (compoundA "enkeli" (k38 "mäinen")) ; --UNCHK
lin angelica_N = mkWN (compoundN "väinön" (k7 "putki")) ; --UNCHK
lin angelim_N = mkWN "andelmin" ; --UNCHK
lin angelology_N = mkWN (compoundN "enkeli" (k5A "oppi")) ; --UNCHK
lin angelus_N = mkWN "Angelus" ; --UNCHK
lin anger_N = mkWN (k39 "suuttumus") ; --UNCHK
lin anger_V2 = mkWV2 (k53A "vihastuttaa") ; --UNCHK
lin angers_PN = foreignPN "Angers" ;
lin angiitis_N = mkWN (compoundN "verisuoni" (k39 "tulehdus")) ; --UNCHK
lin angina_N = mkWN "rasitusrintakipu" ; --UNCHK
lin anginal_A = mkWA "angiina-" ; --UNCHK
lin angiocardiogram_N = mkWN "angiokardiogrammi" ; --UNCHK
lin angiocarp_N = mkWN (k5 "kasvi") "koppisiemeninen" ; --UNCHK
lin angiocarpic_A = mkWA "angiosperminen" ; --UNCHK
lin angioedema_N = mkWN "Quincken" "edeema" ; --UNCHK
lin angiogenesis_N = mkWN "angiogeneesi" ; --UNCHK
lin angiogram_N = mkWN "angiogrammi" ; --UNCHK
lin angiography_N = mkWN (k12 "angiografia") ; --UNCHK
lin angiologist_N = mkWN "angiologi" ; --UNCHK
lin angiology_N = mkWN (compoundN "verisuoni" (k5A "oppi")) ; --UNCHK
lin angioma_N = mkWN (compoundN "angio" (k10 "oma")) ; --UNCHK
lin angiomatous_A = mkWA "angiomatoosinen" ; --UNCHK
lin angiopathy_N = mkWN "angiopatia" ; --UNCHK
lin angioplasty_N = mkWN (compoundN "pallo" (k39 "laajennus")) ; --UNCHK
lin angiopteris_N = mkWN (compoundN "jättiläis" (k38 "saniainen")) ; --UNCHK
lin angiosarcoma_N = mkWN (compoundN "angio" (k10 "sarkooma")) ; --UNCHK
lin angioscope_N = mkWN (compoundN "angiosko" (k5A "oppi")) ; --UNCHK
lin angiosperm_N = mkWN (k5 "kasvi") "kukkiva" ; --UNCHK
lin angle_N = mkWN (k5 "perspektiivi") ; --UNCHK
lin angle_V = mkWV (k53A "painottaa") ; --UNCHK
lin angle_V2 = mkWV2 (k53A "painottaa") ; --UNCHK
lin angle_iron_N = mkWN (compoundN "kulma" (k39 "teräs")) ; --UNCHK
lin angle_dozer_N = mkWN (compoundN "pusku" (k6 "traktori")) ; --UNCHK
lin angler_N = mkWN "Lophius" "Americanus" ; --UNCHK
lin anglewing_N = mkWN "anglewing" ; --UNCHK
lin anglican_A = mkWA (k38 "anglikaaninen") ; --UNCHK
lin anglicism_N = mkWN (k40 "brittiläisyys") ; --UNCHK
lin anglicize_V2 = mkWV2 (compoundV "englanti" (k56 "laistaa")) ; --UNCHK
lin angling_N = mkWN (compoundN "onki" (k38 "minen")) ; --UNCHK
lin anglomania_N = mkWN (compoundN "anglo" (k12 "mania")) ; --UNCHK
lin anglophilFem_N = mkWN (compoundN "englantilais" (k38 "ystävällinen")) ; --UNCHK
lin anglophilMasc_N = mkWN (compoundN "englantilais" (k38 "ystävällinen")) ; --UNCHK
lin anglophileFem_N = mkWN (compoundN "englantilais" (k38 "ystävällinen")) ; --UNCHK
lin anglophileMasc_N = mkWN (compoundN "englantilais" (k38 "ystävällinen")) ; --UNCHK
lin anglophobe_N = mkWN (k38 "ihminen") "englantilaisvihamielinen" ; --UNCHK
lin anglophobia_N = mkWN (compoundN "anglo" (k12 "fobia")) ; --UNCHK
lin angola_PN = foreignPN "Angola" ;
lin angolan_A = mkWA "Angolan" ; --UNCHK
lin angolan_N = mkWN (compoundN "angol" (k38 "alainen")) ; --UNCHK
lin angora_N = mkWN (k12 "angora") ; --UNCHK
lin angostura_N = mkWN (kH1 "kuori") "angosturan" ; --UNCHK
lin angrecum_N = mkWN "angrecum" ; --UNCHK
lin angry_A = mkWA (k38 "vihainen") ;
lin angst_N = mkWN (k39 "ahdistus") ; --UNCHK
lin angstrom_N = mkWN (k4A "yksikkö") "Ångströmin" ; --UNCHK
lin anguilla_PN = foreignPN "Anguilla" ;
lin anguillan_A = mkWA (compoundA "anguill" (k38 "alainen")) ; --UNCHK
lin anguillan_N = mkWN (compoundN "anguill" (k38 "alainen")) ; --UNCHK
lin anguine_A = mkWA (k38 "käärmemäinen") ; --UNCHK
lin anguish_N = mkWN (k39 "kidutus") ; --UNCHK
lin anguished_A = mkWA (k38 "tuskainen") ; --UNCHK
lin angular_A = mkWA (k41A "kulmikas") ; --UNCHK
lin angularity_N = mkWN (k40 "kulmikkuus") ; --UNCHK
lin angulation_N = mkWN "kulmittaminen" ; --UNCHK
lin angus_PN = foreignPN "Angus" ;
lin angwantibo_N = mkWN (compoundN "pohjankarhul" (k48 "ori")) ; --UNCHK
lin anhedonia_N = mkWN (k48A "puute") "seksuaalisen" "nautinnon" ; --UNCHK
lin anhidrosis_N = mkWN (compoundN "hikoilu" (k40 "kyvyttömyys")) ; --UNCHK
lin anhydride_N = mkWN "anhydridi" ; --UNCHK
lin anhydrous_A = mkWA (k34A "vedetön") ; --UNCHK
lin ani_N = mkWN (k99 "ani") ; --UNCHK
lin anicteric_A = mkWA (compoundA "ani" (k38 "kteerinen")) ; --UNCHK
lin anil_N = mkWN (compoundN "suffrutic" (k10 "osa")) "Indigofera" ; --UNCHK
lin anile_A = mkWA (compoundA "vanhuuden" (k2 "höperö")) ; --UNCHK
lin aniline_N = mkWN (k5 "aniliini") ; --UNCHK
lin anima_N = mkWN "anima" ; --UNCHK
lin animadversion_N = mkWN (k48A "moite") ; --UNCHK
lin animadvert_V = mkWV (k67 "arvostella") ; --UNCHK
lin animal_A = mkA "eläimellinen" ;
lin animal_N = L.animal_N ;
lin animalcule_N = mkWN (k33 "eläin") "mikroskooppinen" ; --UNCHK
lin animalism_N = mkWN (k40 "fyysisyys") ; --UNCHK
lin animalistic_A = mkWA (compoundA "ani" (k38 "malistinen")) ; --UNCHK
lin animality_N = mkWN (k1A "luonto") "eläimellinen" ; --UNCHK
lin animalization_N = mkWN (compoundN "eläimellis" (k38 "tyminen")) ; --UNCHK
lin animate_A = mkWA (k10 "elävä") ; --UNCHK
lin animate_V2 = mkWV2 (k53 "virkistää") ; --UNCHK
lin animatedly_A = variants {} ;
lin animatedly_Adv = mkWAdv (k99 "vilkkaasti") | adjAdv animatedly_A ; --UNCHK -- derived
lin animateness_N = mkWN (k40 "elollisuus") ; --UNCHK
lin animating_A = mkWA "elähdyttävä" ; --UNCHK
lin animation_N = mkWN (k40 "eloisuus") ; --UNCHK
lin animatistic_A = mkWA (compoundA "ani" (k38 "matistinen")) ; --UNCHK
lin animator_N = mkWN (k12 "tekijä") "piirroselokuvan" ; --UNCHK
lin animatronics_N = mkWN (compoundN "animatron" (k9A "iikka")) ; --UNCHK
lin animism_N = mkWN (k3 "personifikaatio") ; --UNCHK
lin animist_A = mkWA (k38 "animistinen") ; --UNCHK
lin animist_N = mkWN "animisti" ; --UNCHK
lin animosity_N = mkWN (k26 "veri") "paha" ; --UNCHK
lin animus_N = mkWN (k26 "veri") "paha" ; --UNCHK
lin anion_N = mkWN (k5 "ioni") "negatiivinen" ; --UNCHK
lin anionic_A = mkWA (compoundA "ani" (k38 "oninen")) ; --UNCHK
lin anise_N = mkWN (k32 "siemen") "aniksen" ; --UNCHK
lin aniseed_N = mkWN (k32 "siemen") "aniksen" ; --UNCHK
lin aniseikonia_N = mkWN "aniseikonia" ; --UNCHK
lin aniseikonic_A = mkWA (compoundA "anise" (k38 "ikoninen")) ; --UNCHK
lin anisette_N = mkWN (compoundN "anis" (k6 "likööri")) ; --UNCHK
lin anisogamete_N = mkWN (compoundN "aniso" (k5A "gameetti")) ; --UNCHK
lin anisogametic_A = mkWA (compoundA "anisogam" (k38 "eettinen")) ; --UNCHK
lin anisogamic_A = mkWA (compoundA "ani" (k38 "sogaaminen")) ; --UNCHK
lin anisogamy_N = mkWN "anisogamia" ; --UNCHK
lin anisometric_A = mkWA (compoundA "epä" (k38 "symmetrinen")) ; --UNCHK
lin anisometropia_N = mkWN "anisometropia" ; --UNCHK
lin anisometropic_A = mkWA (compoundA "anisome" (k38 "trooppinen")) ; --UNCHK
lin anisotropic_A = mkWA (compoundA "aniso" (k38 "trooppinen")) ; --UNCHK
lin anisotropy_N = mkWN "anisotropia" ; --UNCHK
lin anjala_PN = mkPN "Anjala" ;
lin anjou_N = mkWN "anjou" ; --UNCHK
lin ankara_PN = foreignPN "Ankara" ;
lin ankle_N = mkWN (k9A "nilkka") ; --UNCHK
lin anklebone_N = mkWN (compoundN "tela" (k18 "luu")) ; --UNCHK
lin anklet_N = mkWN (compoundN "nilkka" (k41A "rengas")) ; --UNCHK
lin ankus_N = mkWN "ankus" ; --UNCHK
lin ankylosaur_N = mkWN "ankylosaurus" ; --UNCHK
lin ankylosis_N = mkWN (compoundN "nivel" (k10 "jäykistymä")) ; --UNCHK
lin ankylotic_A = mkWA "ankyloottinen" ; --UNCHK
lin anna_N = mkWN "anna" ; --UNCHK
lin anna_PN = mkPN "Anna" ;
lin annalist_N = mkWN "annalisti" ; --UNCHK
lin annalistic_A = mkWA "annalistinen" ; --UNCHK
lin annan_PN = foreignPN "Annan" ;
lin anne_PN = mkPN "Anne" ;
lin anneal_V2 = mkWV2 (k62 "normalisoida") ; --UNCHK
lin annealing_N = mkWN (k1 "päästö") ; --UNCHK
lin annelid_A = mkWA "nivelmatojen" ; --UNCHK
lin annelid_N = mkWN (compoundN "nivel" (k1A "mato")) ; --UNCHK
lin annex_N = mkWN (k7A "siipi") ; --UNCHK
lin annex_V2 = mkWV2 (k53 "yhdistää") ; --UNCHK
lin annexation_N = mkWN (compoundN "haltuun" (k1A "otto")) ; --UNCHK
lin annexational_A = mkWA "annektointi-" ; --UNCHK
lin annexe_N = mkWN (k7A "siipi") ; --UNCHK
lin annihilate_V2 = mkWV2 (k64 "viedä") "hautaan" ; --UNCHK
lin annihilating_A = mkWA (k10 "murskaava") ; --UNCHK
lin annihilation_N = mkWN (k39 "hävitys") ; --UNCHK
lin annihilative_A = mkWA (k10 "murskaava") ; --UNCHK
lin annihilator_N = mkWN (k10 "tuhoaja") ; --UNCHK
lin anniversary_N = mkN "merkkipäivä" ;
lin annotation_N = mkWN (compoundN "lisä" (k38 "äminen")) "selityksen" ; --UNCHK
lin annotator_N = mkWN (k6 "kommentaattori") ; --UNCHK
lin announce_V2 = mkV2 "julkistaa" ;
lin announce_VS = mkVS "julkistaa" | mkVS "tiedottaa" ;
lin announcement_N = mkWN (k39 "kuulutus") ; --f135
lin announcer_N = mkWN (k10 "kuuluttaja") ; --UNCHK
lin annoy_V2 = mkWV2 (k53A "ottaa") "päähän" ; --UNCHK
lin annoyance_N = mkWN (compoundN "kiusan" (k1A "teko")) ; --UNCHK
lin annoying_A = mkWA (k10 "rasittava") ; --UNCHK
lin annual_A = mkA "vuosittainen" ;
lin annual_N = mkWN (compoundN "vuosi" (k9 "kirja")) ; --UNCHK
lin annuitant_N = mkWN (k10 "saaja") "elinkoron" ; --UNCHK
lin annuity_N = mkWN (k1A "korko") ; --UNCHK
lin annul_V2 = mkWV2 (k74 "kumota") ; --UNCHK
lin annular_A = mkWA (compoundA "rengas" (k38 "mainen")) ; --UNCHK
lin annulet_N = mkWN (k41A "rengas") "pieni" ; --UNCHK
lin annulment_N = mkWN (compoundN "pois" (k38 "taminen")) ; --UNCHK
lin annulus_N = mkWN (k41A "rengas") ; --UNCHK
lin annum_N = mkWN (k27 "vuosi") ; --UNCHK
lin annunciate_V2 = mkWV2 (k62 "ennakoida") ; --UNCHK
lin annunciation_N = mkWN (k39 "kuulutus") ; --UNCHK
lin annunciator_N = mkWN (compoundN "merkinanto" (k48A "laite")) ; --UNCHK
lin annunciatory_A = mkWA "merkinanto-" ; --UNCHK
lin anode_N = mkWN (k5 "anodi") ; --UNCHK
lin anodic_A = mkWA (compoundA "anodi" (k38 "nen")) ; --UNCHK
lin anodyne_A = mkWA (k38 "analgeettinen") ; --UNCHK
lin anodyne_N = mkWN (k5A "analgeetti") ; --UNCHK
lin anoint_V2 = mkWV2 (k67A "voidella") "linimentillä" ; --UNCHK
lin anointer_N = mkWN "voitelija" ; --UNCHK
lin anointing_N = mkWN (k2 "voitelu") ; --UNCHK
lin anointment_N = mkWN (k2 "voitelu") ; --UNCHK
lin anomalist_N = mkWN "anomalisti" ; --UNCHK
lin anomalops_N = mkWN (compoundN "lyhty" (k9 "kala")) ; --UNCHK
lin anomalopteryx_N = mkWN "Anomalopteryx" "oweni" ; --UNCHK
lin anomalous_A = mkWA (k10 "poikkeava") ; --UNCHK
lin anomaly_N = mkWN (k12 "anomalia") ; --UNCHK
lin anomie_N = mkWN "normittomuus" ; --UNCHK
lin anon_Adv = mkWAdv (k99 "pian") ; --UNCHK
lin anonymity_N = mkWN (k40 "nimettömyys") ; --UNCHK
lin anonymous_A = mkWA (k34A "nimetön") ;
lin anoperineal_A = mkWA (compoundA "anoperinea" (k38 "alinen")) ; --UNCHK
lin anopheles_N = mkWN "suku" "Anopheles" ; --UNCHK
lin anopheline_A = mkWA "malariahyttyseen" "liittyvä" ; --UNCHK
lin anopheline_N = mkWN (k1A "moskiitto") ; --UNCHK
lin anopia_N = mkWN (k48A "puute") "silmän" ; --UNCHK
lin anorak_N = mkWN (k5A "anorakki") ; --UNCHK
lin anorchism_N = mkWN "kiveksettömyys" ; --UNCHK
lin anorectal_A = mkWA (compoundA "anorekta" (k38 "alinen")) ; --UNCHK
lin anorectic_A = mkWA "anorektinen" ; --UNCHK
lin anorexia_N = mkWN (k12 "anoreksia") ; --UNCHK
lin anorexic_A = mkWA "anorektinen" ; --UNCHK
lin anorexic_N = mkWN (k4A "anorektikko") ; --UNCHK
lin anorgasmia_N = mkWN (compoundN "orgasmi" (k40 "vaikeus")) ; --UNCHK
lin anorthite_N = mkWN "kalkkimaasälpä" ; --UNCHK
lin anorthitic_A = mkWA "anortiittinen" ; --UNCHK
lin anorthopia_N = mkWN "anortopia" ; --UNCHK
lin anosmia_N = mkWN (compoundN "haistamis" (k40 "kyvyttömyys")) ; --UNCHK
lin anosmic_A = mkWA (compoundA "haistamis" (k34A "kyvytön")) ; --UNCHK
lin another_Det = mkDet Sg (mkN "toinen") ;
lin another_Quant = heavyQuant {s1 = \\n,c => (snoun2nounBind (mkN "toinen")).s ! NCase n c ; s2 = \\_ => [] ; isNum,isPoss,isNeg,isDef = False} ;
lin anovulation_N = mkWN "ovuloimattomuus" ; --UNCHK
lin anoxemia_N = mkWN "anoksemia" ; --UNCHK
lin anoxemic_A = mkWA "anokseeminen" ; --UNCHK
lin anoxia_N = mkWN (compoundN "hapen" (k48A "puute")) ; --UNCHK
lin anoxic_A = mkWA "hapenpuutteesta" "kärsivä" ; --UNCHK
lin anserine_A = mkWA (compoundA "hanhi" (k38 "mainen")) ; --UNCHK
lin anshan_PN = foreignPN "Anshan" ;
lin answer_N = mkN "vastaus" ;
lin answer_V = mkV "vastata" ;
lin answer_V2 = mkV2 "vastata" illative ;
lin answer_V2S = L.answer_V2S ;
lin answer_back_V2 = mkV2 (advV OP_answer_V OP_back_Adv ) ; -- guess-p-verb
lin answer_for_V2 = mkWV2 (k73 "vastata") ; --UNCHK
lin answerable_A = mkWA (k10 "oleva") "vastuussa" ; --UNCHK
lin ant_N = mkWN (k38 "kusiainen") ; --UNCHK
lin ant_eater_N = mkWN (k5 "nokkasiili") ; --UNCHK
lin ant_hill_N = mkWN (compoundN "muurahais" (k10 "pesä")) ; --UNCHK
lin antacid_A = mkWA (compoundA "neutra" (k10 "loiva")) "happoa" ; --UNCHK
lin antagonism_N = mkWN (k40 "vastakkaisuus") ; --UNCHK
lin antagonist_N = mkWN (k5 "antagonisti") ; --UNCHK
lin antagonistic_A = mkWA (k38 "antagonistinen") ; --UNCHK
lin antagonize_V2 = mkWV2 (k53 "vastustaa") ; --UNCHK
lin antapex_N = mkWN "antapeksi" ; --UNCHK
lin antarctic_A = mkWA (k38 "antarktinen") ; --UNCHK
lin antbird_N = mkWN (compoundN "muurahais" (k1A "lintu")) ; --UNCHK
lin ante_N = mkWN (compoundN "aloitus" (k39 "panos")) ; --UNCHK
lin ante_meridiem_Adv = mkWAdv "ennen" "puoltapäivää" ; --UNCHK
lin antecedence_N = mkWN "aiemmuus" ; --UNCHK
lin antecedent_A = mkWA (k10 "käyvä") "edellä" ; --UNCHK
lin antecedent_N = mkWN (k48A "tarkoite") ; --UNCHK
lin antechamber_N = mkWN (k3 "lämpiö") ; --UNCHK
lin antecubital_A = mkWA (compoundA "esikubita" (k38 "alinen")) ; --UNCHK
lin antedate_V2 = mkWV2 (k54A "edeltää") ; --UNCHK
lin antediluvian_N = mkWN (k2 "henkilö") "hyvin" "vanhanaikainen" ; --UNCHK
lin antefix_N = mkWN "antefiksi" ; --UNCHK
lin antelope_N = mkWN (k5A "antilooppi") ; --UNCHK
lin antemeridian_A = mkWA "aamupäivä-" ; --UNCHK
lin antemortem_A = mkWA "kuolemaa" "edeltävä" ; --UNCHK
lin antenatal_A = mkWA (k38 "prenataalinen") ; --UNCHK
lin antenna_N = mkWN (k6 "antenni") ; --UNCHK
lin antennal_A = mkWA "tuntosarvi-" ; --UNCHK
lin antepenultimate_A = mkWA (k38 "viimeinen") "kolmanneksi" ; --UNCHK
lin anterior_A = mkWA (k38 "etummainen") ; --UNCHK
lin anteriority_N = mkWN "aiemmuus" ; --UNCHK
lin anterograde_A = mkWA "anterogradinen" ; --UNCHK
lin anteroom_N = mkWN (k3 "lämpiö") ; --UNCHK
lin anthelmintic_A = mkWA "loismyrkky-" ; --UNCHK
lin anthem_N = mkWN (k28 "virsi") ; --UNCHK
lin anther_N = mkWN (k28 "ponsi") ; --UNCHK
lin antheral_A = mkWA (compoundA "hete" (k38 "inen")) ; --UNCHK
lin antheridial_A = mkWA "siittiöpesäkkeen" ; --UNCHK
lin antheridiophore_N = mkWN (compoundN "anteridiof" (k48 "ori")) ; --UNCHK
lin antheridium_N = mkWN (compoundN "siittiö" (k48A "pesäke")) ; --UNCHK
lin antherozoid_N = mkWN "spermatotsoidi" ; --UNCHK
lin anthologist_N = mkWN "antologisti" ; --UNCHK
lin anthology_N = mkWN (k12 "antologia") ; --UNCHK
lin anthony_PN = foreignPN "Anthony" ;
lin anthophagous_A = mkWA (compoundA "anto" (k38 "fiilinen")) ; --UNCHK
lin anthophyllite_N = mkWN "antofylliitti" ; --UNCHK
lin anthozoan_N = mkWN (compoundN "koralli" (k33 "eläin")) ; --UNCHK
lin anthracite_N = mkWN (k5A "antrasiitti") ; --UNCHK
lin anthracitic_A = mkWA "kivihiili-" ; --UNCHK
lin anthracosis_N = mkWN (compoundN "hiilipöly" (k1 "keuhko")) ; --UNCHK
lin anthrax_N = mkWN (k48 "paise") "pahanlaatuinen" ; --UNCHK
lin anthropic_A = mkWA "antrooppinen" ; --UNCHK
lin anthropocentric_A = mkWA "antroposentrinen" ; --UNCHK
lin anthropocentrism_N = mkWN (compoundN "ihmis" (k40 "keskeisyys")) ; --UNCHK
lin anthropogenesis_N = mkWN "antropogenia" ; --UNCHK
lin anthropogenetic_A = mkWA (compoundA "antropo" (k38 "geneettinen")) ; --UNCHK
lin anthropoid_A = mkWA (k38 "ihmismäinen") ; --UNCHK
lin anthropoid_N = mkWN (compoundN "ihmis" (k12 "apina")) ; --UNCHK
lin anthropolatry_N = mkWN (compoundN "ihmisen" (k9A "palvonta")) ; --UNCHK
lin anthropological_A = mkWA (k38 "antropologinen") ; --UNCHK
lin anthropologistFem_N = mkWN (k5 "antropologi") ; --UNCHK
lin anthropologistMasc_N = mkWN (k5 "antropologi") ; --UNCHK
lin anthropology_N = mkWN (k12 "antropologia") ; --UNCHK
lin anthropometric_A = mkWA (compoundA "antropo" (k38 "metrinen")) ; --UNCHK
lin anthropometry_N = mkWN "antropometria" ; --UNCHK
lin anthropomorphic_A = mkWA (compoundA "ihmisen" (k38 "kaltainen")) ; --UNCHK
lin anthropomorphism_N = mkWN (compoundN "tean" (k5 "tropismi")) ; --UNCHK
lin anthropophagous_A = mkWA "antropofaginen" ; --UNCHK
lin anthropophagy_N = mkWN (compoundN "ihmis" (k5A "syönti")) ; --UNCHK
lin anthroposophy_N = mkWN (k12 "antroposofia") ; --UNCHK
lin anthurium_N = mkWN (compoundN "flamingo" (k10A "kukka")) ; --UNCHK
lin anti_A = mkWA (k10 "oleva") "vastaan" ; --UNCHK
lin anti_N = mkWN (k10 "vastustaja") ; --UNCHK
lin anti_Prep = mkPrep "anti" nominative ;
lin anti_semitic_A = mkA (mkN "anti" (mkN "semitistinen")) ;
lin antiadrenergic_A = mkWA (compoundA "antiadr" (k38 "energinen")) ; --UNCHK
lin anti_aircraft_A = mkWA "ilmatorjunta-" ; --UNCHK
lin anti_aircraft_N = mkWN (k5A "konetykki") ; --UNCHK
lin antialiasing_N = mkWN (k39 "korjaus") "vääristymien" ; --UNCHK
lin antiapartheid_A = mkWA (compoundA "apartheidin" (k38 "vastainen")) ; --UNCHK
lin antiarrhythmic_N = mkWN (compoundN "antiarytmia" (k39 "lääkitys")) ; --UNCHK
lin antiauthoritarian_A = mkWA (compoundA "anti" (k38 "autoritaarinen")) ; --UNCHK
lin antibacterial_A = mkWA (compoundA "anti" (k38 "bakteerinen")) ; --UNCHK
lin antibacterial_N = mkWN (k5A "antibiootti") ; --UNCHK
lin antibaryon_N = mkWN "antibaryoni" ; --UNCHK
lin antibiosis_N = mkWN "antibioosi" ; --UNCHK
lin antibiotic_A = mkWA (k38 "antibioottinen") ; --UNCHK
lin antibiotic_N = mkN "antibiootti" | mkWN (k48A "lääke") "antibioottinen" ;
lin antibody_N = mkWN (compoundN "vasta-" (k48 "aine")) ; --UNCHK
lin antic_A = mkWA (k41A "irvokas") ; --UNCHK
lin antic_N = mkWN (k2 "pelleily") ; --UNCHK
lin anticancer_A = mkWA (compoundA "ehkäis" (k10 "evä")) "kasvaimia" ; --UNCHK
lin anticatalyst_N = mkWN (compoundN "vasta" (k5A "katalyytti")) ; --UNCHK
lin anticholinergic_A = mkWA (compoundA "anti" (k38 "kolinerginen")) ; --UNCHK
lin anticholinergic_N = mkWN (k48A "lääke") "antikolinerginen" ; --UNCHK
lin anticholinesterase_N = mkWN (compoundN "antikoliiniester" (k5 "aasi")) ; --UNCHK
lin anticipant_A = mkWA "odottava" ; --UNCHK
lin anticipate_V = mkWV (k62 "ennakoida") ; --UNCHK
lin anticipate_V2 = mkWV2 (k62 "ennakoida") ; --f62
lin anticipate_VS = mkWVS (k62 "ennakoida") ;
lin anticipate_VV = mkWVV (k62 "ennakoida") ; --UNCHK
lin anticipation_N = mkWN (k39 "povaus") ; --UNCHK
lin anticipator_N = mkWN (k12 "näkijä") ; --UNCHK
lin anticipatory_A = mkWA (compoundA "edellä" (k10 "käyvä")) ; --UNCHK
lin anticlimactic_A = mkWA (k38 "jälkeinen") "huipennuksen" ; --UNCHK
lin anticlimax_N = mkWN (compoundN "anti" (k5 "kliimaksi")) ; --UNCHK
lin anticlinal_A = mkWA (compoundA "antiklina" (k38 "alinen")) ; --UNCHK
lin anticlockwise_Adv = mkWAdv (k99 "vastapäivään") ; --UNCHK
lin anticoagulant_N = mkWN (k48 "aine") "hyytymistä" "estävä" ; --UNCHK
lin anticoagulation_N = mkWN (compoundN "anti" (k3 "koagulaatio")) ; --UNCHK
lin anticoagulative_A = mkWA (compoundA "anti" (k38 "koagulatiivinen")) ; --UNCHK
lin anticonvulsant_N = mkWN (k48A "lääke") "kouristuksia" "estävä" ; --UNCHK
lin anticyclone_N = mkWN (k50 "korkeapaine") ; --UNCHK
lin antidepressant_N = mkWN (compoundN "masennus" (k48A "lääke")) ; --UNCHK
lin antidiabetic_N = mkWN (compoundN "diabetes" (k48A "lääke")) ; --UNCHK
lin antidiarrheal_N = mkWN (compoundN "ripuli" (k48A "lääke")) ; --UNCHK
lin antidiuretic_N = mkWN (k48 "aine") "virtsaneritystä" "vähentävä" ; --UNCHK
lin antidotal_A = mkWA "vastamyrkky-" ; --UNCHK
lin antidote_N = mkWN (compoundN "vasta" (k1A "myrkky")) ; --UNCHK
lin antidromic_A = mkWA (compoundA "anti" (k38 "drominen")) ; --UNCHK
lin antiemetic_N = mkWN (k48A "lääke") "antiemeettinen" ; --UNCHK
lin antiestablishmentarianism_N = mkWN (compoundN "antiestablishmentarian" (k5 "ismi")) ; --UNCHK
lin antifeminist_N = mkWN (compoundN "anti" (k5 "feministi")) ; --UNCHK
lin antiferromagnetic_A = mkWA (compoundA "antiferro" (k38 "magneettinen")) ; --UNCHK
lin antiferromagnetism_N = mkWN (compoundN "antiferro" (k5 "magnetismi")) ; --UNCHK
lin antiflatulent_N = mkWN (compoundN "ilmavaiva" (k48A "lääke")) ; --UNCHK
lin antifreeze_N = mkWN (compoundN "jäätymisenesto" (k48 "aine")) ; --UNCHK
lin antifungal_N = mkWN (k48 "aine") "sieniä" "tappava" ; --UNCHK
lin antigen_N = mkWN (k5 "antigeeni") ; --UNCHK
lin antigenic_A = mkWA (compoundA "anti" (k38 "geeninen")) ; --UNCHK
lin antigram_N = mkWN "antigrammi" ; --UNCHK
lin antigua_PN = foreignPN "Antigua" ;
lin antiguan_A = mkWA (compoundA "antigu" (k38 "alainen")) ; --UNCHK
lin antiguan_N = mkWN (compoundN "antigu" (k38 "alainen")) ; --UNCHK
lin antiheretical_A = mkWA (compoundA "kerettiläisyyden" (k38 "vastainen")) ; --UNCHK
lin anti_hero_N = mkWN (compoundN "anti" (k6 "sankari")) ; --UNCHK
lin antihistamine_N = mkWN (compoundN "anti" (k5 "histamiini")) ; --UNCHK
lin antihypertensive_N = mkWN (k48A "lääke") "antihypertensiivinen" ; --UNCHK
lin antiknock_A = mkWA "nakutuksenesto-" ; --UNCHK
lin antiknock_N = mkWN (compoundN "nakutuksenesto" (k48 "aine")) ; --UNCHK
lin antilepton_N = mkWN (compoundN "anti" (k6 "leptoni")) ; --UNCHK
lin antimacassar_N = mkWN (compoundN "antima" (k5 "kassi")) ; --UNCHK
lin antimagnetic_A = mkWA (compoundA "anti" (k38 "magneettinen")) ; --UNCHK
lin antimalarial_N = mkWN (compoundN "malaria" (k48A "lääke")) ; --UNCHK
lin antimatter_N = mkWN (compoundN "anti" (k48 "aine")) ; --UNCHK
lin antimeson_N = mkWN (compoundN "anti" (k5 "mesoni")) ; --UNCHK
lin antimetabolite_N = mkWN "antimetaboliitti" ; --UNCHK
lin antimicrobial_A = mkWA (compoundA "antimikrobia" (k38 "alinen")) ; --UNCHK
lin antimonial_A = mkWA (compoundA "antimonipi" (k38 "toinen")) ; --UNCHK
lin antimonic_A = mkWA "antimoni-" ; --UNCHK
lin antimonopoly_A = mkWA (k38 "vastainen") "kartellien" ; --UNCHK
lin antimony_N = mkWN (k5 "antimoni") ; --UNCHK
lin antimuon_N = mkWN "positiivinen" "myoni" ; --UNCHK
lin antimycin_N = mkWN "antimysiini" ; --UNCHK
lin antineoplastic_N = mkWN (k48A "lääke") "antineoplastinen" ; --UNCHK
lin antineutrino_N = mkWN (compoundN "anti" (k2 "neutriino")) ; --UNCHK
lin antineutron_N = mkWN (compoundN "anti" (k5 "neutroni")) ; --UNCHK
lin antinode_N = mkWN (k10A "maksimikohta") ; --UNCHK
lin antinomasia_N = mkWN (compoundN "antinom" (k12 "asia")) ; --UNCHK
lin antinomian_A = mkWA (compoundA "antinomi" (k38 "lainen")) ; --UNCHK
lin antinomian_N = mkWN (compoundN "antinomi" (k38 "lainen")) ; --UNCHK
lin antinomianism_N = mkWN (compoundN "antinom" (k5 "ismi")) ; --UNCHK
lin antinomy_N = mkWN (compoundN "risti" (k40 "riitaisuus")) ; --UNCHK
lin antioxidant_N = mkWN (k5A "antioksidantti") ; --UNCHK
lin antiparallel_A = mkWA (compoundA "vastakkais" (k38 "suuntainen")) ; --UNCHK
lin antiparticle_N = mkWN (compoundN "vasta" (k38 "hiukkanen")) ; --UNCHK
lin antipasto_N = mkWN (k1 "antipasto") ; --UNCHK
lin antipathetic_A = mkWA (k38 "antagonistinen") ; --UNCHK
lin antipathy_N = mkWN (k12 "antipatia") ; --UNCHK
lin anti_personnel_A = mkWA "sirpale-" ; --UNCHK
lin antiperspirant_N = mkWN (k5A "antiperspirantti") ; --UNCHK
lin antiphlogistic_A = mkWA (compoundA "anti" (k38 "flogistinen")) ; --UNCHK
lin antiphon_N = mkWN (compoundN "vuoro" (k1 "laulu")) ; --UNCHK
lin antiphonary_A = mkWA (compoundA "antifona" (k38 "alinen")) ; --UNCHK
lin antiphonary_N = mkWN (compoundN "antifo" (k5 "naali")) ; --UNCHK
lin antiphony_N = mkWN (compoundN "vuoro" (k1 "laulu")) ; --UNCHK
lin antiphrasis_N = mkWN (compoundN "anti" (k5 "fraasi")) ; --UNCHK
lin antipodal_A = mkWA (k38 "vastakkainen") ; --UNCHK
lin antipodal_N = mkWN (k3 "oppositio") "diametraalinen" ; --UNCHK
lin antipode_N = mkWN (k10A "vastakohta") ; --UNCHK
lin antipollution_A = mkWA (k10 "torjuva") "saastumista" ; --UNCHK
lin antipope_N = mkWN (compoundN "vasta" (k5 "paavi")) ; --UNCHK
lin antiproton_N = mkWN (compoundN "anti" (k5 "protoni")) ; --UNCHK
lin antiprotozoal_N = mkWN (compoundN "alkueläin" (k48A "lääke")) ; --UNCHK
lin antipruritic_N = mkWN (k48A "lääke") "kutinaa" "lievittävä" ; --UNCHK
lin antipyresis_N = mkWN (compoundN "kuume" (k48A "lääke")) ; --UNCHK
lin antipyretic_A = mkWA (compoundA "antipyr" (k38 "eettinen")) ; --UNCHK
lin antipyretic_N = mkWN (k48A "lääke") "kuumetta" "vähentävä" ; --UNCHK
lin antiquarian_A = mkWA (k38 "antikvaarinen") ; --UNCHK
lin antiquarian_N = mkWN (k12 "tuntija") "vanhojen" "esineiden" ; --UNCHK
lin antiquark_N = mkWN (k5A "antikvarkki") ; --UNCHK
lin antiquary_N = mkWN (k12 "tuntija") "vanhojen" "esineiden" ; --UNCHK
lin antiquated_A = mkWA (k10 "vanhahtava") ; --UNCHK
lin antique_A = mkA "antiikkinen" ;
lin antique_N = mkWN (k5A "antiikki") ; --UNCHK
lin antiquity_N = mkWN (compoundN "muinais" (k39 "jäännös")) ; --UNCHK
lin antiredeposition_N = mkWN (compoundN "harmaantumisenesto" (k48 "aine")) ; --UNCHK
lin antirrhinum_N = mkWN "suku" "Antirrhinum" ; --UNCHK
lin antisatellite_A = mkWA (compoundA "satelliittien" (k38 "vastainen")) ; --UNCHK
lin antiseptic_A = mkWA (k38 "antiseptinen") ; --UNCHK
lin antiseptic_N = mkWN (k48 "aine") "antiseptinen" ; --UNCHK
lin antiserum_N = mkWN (compoundN "anti" (k6 "seerumi")) ; --UNCHK
lin antisocial_A = mkWA (k34A "sopeutumaton") "yhteiskuntaan" ; --UNCHK
lin antispasmodic_N = mkWN (compoundN "kouristus" (k48A "lääke")) ; --UNCHK
lin antistrophe_N = mkWN (compoundN "vastaus" (k2 "säkeistö")) ; --UNCHK
lin antistrophic_A = mkWA (compoundA "antis" (k38 "trooppinen")) ; --UNCHK
lin antisubmarine_A = mkWA "sukellusveneidentorjunta-" ; --UNCHK
lin antisyphilitic_N = mkWN (compoundN "kuppa" (k48A "lääke")) ; --UNCHK
lin antitank_A = mkWA "panssarintorjunta-" ; --UNCHK
lin antitauon_N = mkWN (compoundN "anti" (k18 "tau")) ; --UNCHK
lin antithesis_N = mkWN (compoundN "anti" (k5 "teesi")) ; --UNCHK
lin antithetic_A = mkWA (k38 "vastakkainen") ; --UNCHK
lin antithetical_A = mkWA (k38 "vastakkainen") ; --UNCHK
lin antithyroid_A = mkWA (compoundA "tyreo" (k38 "staattinen")) ; --UNCHK
lin antitoxic_A = mkWA (compoundA "anti" (k38 "toksinen")) ; --UNCHK
lin antitoxin_N = mkWN (compoundN "anti" (k5 "toksiini")) ; --UNCHK
lin antitrade_N = mkWN (compoundN "vasta" (k5 "pasaati")) ; --UNCHK
lin antitussive_N = mkWN "antitussiivi" ; --UNCHK
lin antitype_N = mkWN (compoundN "vasta" (k5A "tyyppi")) ; --UNCHK
lin antitypic_A = mkWA (compoundA "vertaus" (k38 "kuvallinen")) ; --UNCHK
lin antivenin_N = mkWN (compoundN "vasta" (k1A "myrkky")) ; --UNCHK
lin antiviral_A = mkWA (compoundA "antivira" (k38 "alinen")) ; --UNCHK
lin antiviral_N = mkWN (k48 "aine") "antiviraalinen" ; --UNCHK
lin antler_N = mkWN (compoundN "peuran" (k7 "sarvi")) ; --UNCHK
lin antlered_A = mkWA (k41A "sarvekas") ; --UNCHK
lin antony_PN = foreignPN "Antony" ;
lin antonym_N = mkWN (k10A "vastakohta") ; --UNCHK
lin antonymous_A = mkWA (k38 "vastakkainen") "merkitykseltään" ; --UNCHK
lin antonymy_N = mkWN (k40 "vastakkaisuus") "merkitysten" ; --UNCHK
lin antrim_PN = foreignPN "Antrim" ;
lin antrum_N = mkWN (k2 "ontelo") ; --UNCHK
lin antsy_A = mkWA (k10 "ärtyisä") ; --UNCHK
lin antwerp_PN = foreignPN "Antwerpen" ;
lin anuran_A = mkWA "sammakkoeläin-" ; --UNCHK
lin anuresis_N = mkWN (compoundN "virtsaamis" (k40 "kyvyttömyys")) ; --UNCHK
lin anuretic_A = mkWA (compoundA "anur" (k38 "eettinen")) ; --UNCHK
lin anurous_A = mkWA "pyrstötön" ; --UNCHK
lin anus_N = mkWN (compoundN "perä" (k1A "aukko")) ; --UNCHK
lin anvil_N = mkWN (k33 "alasin") ; --UNCHK
lin anxiety_N = mkWN (k26 "huoli") ; --UNCHK
lin anxiolytic_A = mkWA "anksiolyyttinen" ; --UNCHK
lin anxious_A = mkWA (k41A "innokas") ; --UNCHK
lin anxiousness_N = mkWN (k40 "rauhattomuus") ; --UNCHK
lin anyPl_Det = {s1,sp = S.mikaanPron ! Pl ; s2 = \\_ => [] ; isNum,isPoss,isNeg,isDef = False ; n = Pl} ;
lin anySg_Det = {s1,sp = S.mikaanPron ! Sg ; s2 = \\_ => [] ; isNum,isPoss,isNeg,isDef = False ; n = Sg} ;
lin any_Adv = mkWAdv (k99 "yhtään") ; --UNCHK
lin anybody_NP = {s = table {NPAcc => "kenet" ++ "tahansa" ; c => S.kukaInt ! Sg ! npform2case Sg c ++ "tahansa"} ; a = agrP3 Sg ; isPron, isNeg = False} ;
lin anyhow_Adv = mkWAdv (k99 "ainakin") ; --UNCHK
lin anymore_Adv = mkWAdv (k99 "enää") ; --UNCHK
lin anyone_NP = {s = table {NPAcc => "kenet" ++ "tahansa" ; c => S.kukaInt ! Sg ! npform2case Sg c ++ "tahansa"} ; a = agrP3 Sg ; isPron, isNeg = False} ;
lin anyplace_Adv = mkWAdv (k99 "tahansa") "missä" ; --UNCHK
lin anything_NP = {s = \\c => S.mikaInt ! Sg ! (npform2case Sg c) ++ "tahansa" ; a = agrP3 Sg ; isPron, isNeg = False} ;
lin anyway_Adv = mkAdv "joka tapauksessa" ;
lin anywhere_Adv = mkWAdv (k99 "tahansa") "missä" ; --UNCHK
lin aorist_N = mkWN "aoristi" ; --UNCHK
lin aoristic_A = mkWA "aoristinen" ; --UNCHK
lin aorta_N = mkWN (k9A "aortta") ; --UNCHK
lin aortal_A = mkWA "aorttaan" "liittyvä" ; --UNCHK
lin aortitis_N = mkWN (compoundN "aortta" (k39 "tulehdus")) ; --UNCHK
lin aoudad_N = mkWN (compoundN "harja" (k41A "lammas")) ; --UNCHK
lin apace_Adv = mkWAdv (k99 "joutuin") ; --UNCHK
lin apache_N = mkWN (k5 "apassi") ; --UNCHK
lin apadana_N = mkWN "apadana" ; --UNCHK
lin apar_N = mkWN (compoundN "pallo" (k38 "vyötiäinen")) ; --UNCHK
lin apart_Adv = mkAdv "erillään" | mkAdv "erikseen" | mkAdv "syrjässä" | mkAdv "syrjään" ; ---- split
lin apart_from_Prep = mkPrep "lisäksi" ;
lin apartheid_N = mkWN (k5 "apartheid") ; --UNCHK
lin apartment_N = L.apartment_N ;
lin apathetic_A = mkWA (k34A "haluton") ; --UNCHK
lin apathy_N = mkWN (k40 "hengettömyys") ; --UNCHK
lin apatite_N = mkWN (k5A "apatiitti") ; --UNCHK
lin apatosaur_N = mkWN (k39 "brontosaurus") ; --UNCHK
lin ape_N = mkWN (k12 "apina") ; --UNCHK
lin ape_V2 = mkWV2 (k62 "apinoida") ; --UNCHK
lin apeldoorn_PN = foreignPN "Apeldoorn" ;
lin apercu_N = mkWN (k39 "luonnos") ; --UNCHK
lin aperea_N = mkWN (compoundN "villi" (k1 "marsu")) ; --UNCHK
lin aperient_A = mkWA "aperientti" ; --UNCHK
lin aperient_N = mkWN (k5 "laksatiivi") ; --UNCHK
lin aperiodic_A = mkWA (compoundA "epä" (k38 "jaksollinen")) ; --UNCHK
lin aperitif_N = mkWN (k5 "aperitiivi") ; --UNCHK
lin aperture_N = mkWN (k10A "reikä") ; --UNCHK
lin apery_N = mkWN (k2 "jäljittely") ; --UNCHK
lin apetalous_A = mkWA "terälehdetön" ; --UNCHK
lin apex_N = mkWN "auringon" "apeksi" ; --UNCHK
lin aphaeresis_N = mkWN "afereesi" ; --UNCHK
lin aphaeretic_A = mkWA (compoundA "afer" (k38 "eettinen")) ; --UNCHK
lin aphagia_N = mkWN "afagia" ; --UNCHK
lin aphakia_N = mkWN "mykiöttömyys" ; --UNCHK
lin aphakic_A = mkWA "afakia-" ; --UNCHK
lin aphakic_N = mkWN (k38 "ihminen") "mykiötön" ; --UNCHK
lin aphanite_N = mkWN (compoundN "afa" (k5A "niitti")) ; --UNCHK
lin aphanitic_A = mkWA "afaniittinen" ; --UNCHK
lin aphasia_N = mkWN (k12 "afasia") ; --UNCHK
lin aphasic_A = mkWA (k38 "afaattinen") ; --UNCHK
lin aphasic_N = mkWN (k4A "afaatikko") ; --UNCHK
lin apheresis_N = mkWN "fereesi" ; --UNCHK
lin aphesis_N = mkWN "afeesi" ; --UNCHK
lin aphetic_A = mkWA "afeettinen" ; --UNCHK
lin aphid_N = mkWN (k9 "kirva") ; --UNCHK
lin aphis_N = mkWN "suku" "Aphis" ; --UNCHK
lin aphonia_N = mkWN (compoundN "äänen" (k1A "kato")) ; --UNCHK
lin aphonic_A = mkWA (compoundA "äänenka" (k38 "toinen")) ; --UNCHK
lin aphorism_N = mkWN (k5 "aforismi") ; --UNCHK
lin aphorist_N = mkWN (compoundN "afo" (k4A "ristikko")) ; --UNCHK
lin aphoristic_A = mkWA (k38 "aforistinen") ; --UNCHK
lin aphotic_A = mkWA "valoton" ; --UNCHK
lin aphrodisia_N = mkWN "afrodisia" ; --UNCHK
lin aphrodisiac_A = mkWA (k41A "seksikäs") ; --UNCHK
lin aphrodisiac_N = mkWN (k48 "aine") "sukuviettiä" "kiihottava" ; --UNCHK
lin aphyllous_A = mkWA "lehdetön" ; --UNCHK
lin apian_A = mkWA "mehiläis-" ; --UNCHK
lin apiarian_A = mkWA "mehiläishoito-" ; --UNCHK
lin apiarist_N = mkWN (compoundN "mehiläis" (k10 "hoitaja")) ; --UNCHK
lin apiary_N = mkWN (compoundN "mehiläis" (k9 "tarha")) ; --UNCHK
lin apical_A = mkWA (compoundA "apika" (k38 "alinen")) ; --UNCHK
lin apiculate_A = mkWA (k38 "kärjellinen") ; --UNCHK
lin apicultural_A = mkWA "mehiläishoito-" ; --UNCHK
lin apiculture_N = mkWN (k1A "hoito") "mehiläisten" ; --UNCHK
lin apiece_Adv = mkAdv "kappale" ;
lin apish_A = mkWA (k10 "typerä") ; --UNCHK
lin apishamore_N = mkWN (compoundN "satu" (k25 "loimi")) "puhvelinnahkainen" ; --UNCHK
lin apivorous_A = mkWA "mehiläissyöjä-" ; --UNCHK
lin aplacental_A = mkWA "istukaton" ; --UNCHK
lin aplanatic_A = mkWA "aplanaattinen" ; --UNCHK
lin aplasia_N = mkWN (compoundN "apl" (k12 "asia")) ; --UNCHK
lin aplite_N = mkWN "apliitti" ; --UNCHK
lin aplitic_A = mkWA "apliittinen" ; --UNCHK
lin aplomb_N = mkWN (k40 "viileys") ; --UNCHK
lin apnea_N = mkWN (k12 "apnea") ; --UNCHK
lin apneic_A = mkWA "apnea-" ; --UNCHK
lin apoapsis_N = mkWN "apofocus" ; --UNCHK
lin apocalypse_N = mkWN (k39 "ilmestys") "Johanneksen" ; --UNCHK
lin apocalyptic_A = mkWA (k38 "apokalyptinen") ; --UNCHK
lin apocarpous_A = mkWA "apokarppinen" ; --UNCHK
lin apochromatic_A = mkWA (compoundA "apo" (k38 "kromaattinen")) ; --UNCHK
lin apocope_N = mkWN (compoundN "loppu" (k1A "heitto")) ; --UNCHK
lin apocrine_A = mkWA "apokriininen" ; --UNCHK
lin apocryphal_A = mkWA (k38 "apokryfinen") ; --UNCHK
lin apocynaceous_A = mkWA "oleanteri-" ; --UNCHK
lin apodal_A = mkWA "jalaton" ; --UNCHK
lin apodeme_N = mkWN (compoundN "apode" (k5 "emi")) ; --UNCHK
lin apodictic_A = mkWA (k34A "välttämätön") ; --UNCHK
lin apoenzyme_N = mkWN (compoundN "apo" (k6 "entsyymi")) ; --UNCHK
lin apogamic_A = mkWA (compoundA "apogam" (k38 "eettinen")) ; --UNCHK
lin apogamy_N = mkWN "apogamia" ; --UNCHK
lin apogean_A = mkWA "apogeum-" ; --UNCHK
lin apogee_N = mkWN "apogeum" ; --UNCHK
lin apojove_N = mkWN (compoundN "apoj" (k7 "ovi")) ; --UNCHK
lin apolemia_N = mkWN "apolemia" ; --UNCHK
lin apolitical_A = mkWA (compoundA "epä" (k38 "poliittinen")) ; --UNCHK
lin apologetic_A = mkWA "anteeksipyytävä" ; --UNCHK
lin apologetics_N = mkWN (compoundN "apolog" (k14A "etiikka")) ; --UNCHK
lin apologist_N = mkWN (k10 "puolustaja") ; --UNCHK
lin apologize_V = mkWV (k54A "pyytää") "anteeksi" ; --UNCHK
lin apology_N = mkWN (compoundN "anteeksi" (k1A "pyyntö")) ; --UNCHK
lin apomict_N = mkWN "apomikti" ; --UNCHK
lin apomictic_A = mkWA "apomiktinen" ; --UNCHK
lin apomixis_N = mkWN "apomiksis" ; --UNCHK
lin apomorphine_N = mkWN (compoundN "apo" (k5 "morfiini")) ; --UNCHK
lin aponeurosis_N = mkWN (compoundN "kalvo" (k48A "jänne")) ; --UNCHK
lin aponeurotic_A = mkWA (compoundA "apo" (k38 "neuroottinen")) ; --UNCHK
lin apopemptic_A = mkWA "apopemptinen" ; --UNCHK
lin apophasis_N = mkWN (compoundN "apo" (k5 "faasi")) ; --UNCHK
lin apophatic_A = mkWA "apofaattinen" ; --UNCHK
lin apophthegm_N = mkWN (k5 "aforismi") ; --UNCHK
lin apophyseal_A = mkWA (compoundA "apo" (k38 "fyysinen")) ; --UNCHK
lin apophysis_N = mkWN (compoundN "apofy" (k5 "ysi")) ; --UNCHK
lin apoplectic_A = mkWA "apoplektinen" ; --UNCHK
lin apoplectiform_A = mkWA (compoundA "apoplektin" (k38 "tapainen")) ; --UNCHK
lin apoplexy_N = mkWN (compoundN "aivo" (k39 "halvaus")) ; --UNCHK
lin apoptosis_N = mkWN (k5 "apoptoosi") ; --UNCHK
lin aposelene_N = mkWN (compoundN "apol" (k24 "uni")) ; --UNCHK
lin aposiopesis_N = mkWN (compoundN "aposio" (k39 "pesis")) ; --UNCHK
lin aposiopetic_A = mkWA (compoundA "aposiop" (k38 "eettinen")) ; --UNCHK
lin apostasy_N = mkWN (k40 "petturuus") ; --UNCHK
lin apostate_A = mkWA (k34A "uskoton") ; --UNCHK
lin apostate_N = mkWN (k6 "petturi") ; --UNCHK
lin apostle_N = mkWN (k5 "apostoli") ; --UNCHK
lin apostleship_N = mkWN "apostolisuus" ; --UNCHK
lin apostolic_A = mkWA (k38 "apostolinen") ; --UNCHK
lin apostrophe_N = mkWN "puolilainausmerkki" ; --UNCHK
lin apostrophic_A = mkWA "apostrofinen" ; --UNCHK
lin apostrophize_V2 = mkWV2 (compoundV "heitto" (k53A "merkittää")) ; --UNCHK
lin apothecary_N = mkWN (k6 "proviisori") ; --UNCHK
lin apothecial_A = mkWA "kotelomaljan" ; --UNCHK
lin apothecium_N = mkWN (compoundN "kotelo" (k9 "malja")) ; --UNCHK
lin apothegm_N = mkWN (k5 "aforismi") ; --UNCHK
lin apothegmatic_A = mkWA (compoundA "mietelauseen" (k38 "omainen")) ; --UNCHK
lin apotheosis_N = mkWN "apoteoosi" ; --UNCHK
lin apotropaic_A = mkWA (compoundA "kark" (k10 "ottava")) "pahan" ; --UNCHK
lin appal_V2 = mkWV2 (k53A "pelästyttää") ; --UNCHK
lin appalling_A = mkWA (compoundA "kauhis" (k10 "tuttava")) ; --UNCHK
lin appalling_N = mkWN (compoundN "kauhis" (k10 "tuttava")) ; --UNCHK
lin appanage_N = mkWN (compoundN "apan" (k5 "aasi")) ; --UNCHK
lin apparatchik_N = mkWN "apparatsikki" ; --UNCHK
lin apparatus_N = mkWN (k5A "aparaatti") ; --UNCHK
lin apparel_N = mkWN (k1A "puku") ; --UNCHK
lin apparel_V2 = mkWV2 (k53 "varustaa") ; --UNCHK
lin appareled_A = mkWA (compoundA "vaate" (k1 "tettu")) ; --UNCHK
lin apparent_A = mkA "ilmeinen" ;
lin apparentness_N = mkWN (compoundN "ilmi" (k1 "asu")) ; --UNCHK
lin apparition_N = mkWN (compoundN "ilme" (k38 "styminen")) ; --UNCHK
lin apparitional_A = mkWA (k38 "henkinen") ; --UNCHK
lin appeal_N = mkN "vetoomus" ;
lin appeal_V = mkV "vedota" ;
lin appeal_V2 = mkV2 "vedota" illative ; --mkWV2 (k67 "rukoilla") ;
lin appealable_A = mkWA (compoundA "valitus" (k38 "kelpoinen")) ; --UNCHK
lin appealing_A = variants {} ;
lin appear_V = mkV "ilmestyä" ;
lin appear_VA = mkVA (mkV "vaikuttaa") (casePrep ablative) ;
lin appear_VS = mkVS (mkV (mkV "näyttää") "siltä") ;
lin appear_VV = mkVV (mkV "näyttää") infPresPart ;
lin appearance_N = mkWN (compoundN "esi" (k38 "intyminen")) ; --UNCHK
lin appeasable_A = mkWA (k38 "sovinnollinen") ; --UNCHK
lin appease_V2 = mkWV2 (k53A "tyynnyttää") ; --UNCHK
lin appeasement_N = mkWN "tyynnyttäminen" ; --UNCHK
lin appeaser_N = mkWN (k12 "sovittelija") ; --UNCHK
lin appellant_A = mkWA "muutoksenhaku-" ; --UNCHK
lin appellant_N = mkWN (k10 "valittaja") ; --UNCHK
lin appellate_A = mkWA "muutoksenhaku-" ; --UNCHK
lin appellation_N = mkWN (k39 "nimitys") ; --UNCHK
lin appellative_A = mkWA (compoundA "appellatiivi" (k38 "nen")) ; --UNCHK
lin append_V2 = mkWV2 (k56 "jatkaa") ; --UNCHK
lin appendage_N = mkWN (k48A "liite") ; --UNCHK
lin appendaged_A = mkWA (k10 "oleva") "liitteenä" ; --UNCHK
lin appendant_A = mkWA (compoundA "liite" (k1 "tty")) ; --UNCHK
lin appendectomy_N = mkWN (k1 "poisto") "umpilisäkkeen" ; --UNCHK
lin appendicitis_N = mkWN (k39 "tulehdus") "umpilisäkkeen" ; --UNCHK
lin appendicle_N = mkWN (k48A "lisäke") "pieni" ; --UNCHK
lin appendicular_A = mkWA "lisäke-" ; --UNCHK
lin appendix_N = mkWN (k48A "lisäke") "sekaalinen" ; --UNCHK
lin appertain_V = mkWV (k58 "koskea") "jtk" ; --UNCHK
lin appetent_A = mkWA (k41A "himokas") ; --UNCHK
lin appetite_N = mkWN (k39 "viehtymys") ; --UNCHK
lin appetitive_A = mkWA (k41A "himokas") ; --UNCHK
lin appetizer_N = mkWN (compoundN "alku" (k9 "pala")) ; --UNCHK
lin appetizing_A = mkWA (k38 "herkullinen") ; --UNCHK
lin appetizingness_N = mkWN (k40 "herkullisuus") ; --UNCHK
lin applaud_V = mkWV (k53 "ylistää") ; --UNCHK
lin applaud_V2 = mkWV2 (k53 "ylistää") ;
lin applaudable_A = mkWA (k10 "kunnioitettava") ; --UNCHK
lin applause_N = mkN "suosionosoitus" ;
lin apple_N = L.apple_N ;
lin applejack_N = mkWN (compoundN "omena" (k1 "brandy")) ; --UNCHK
lin applesauce_N = mkWN (k6 "liirumlaarum") ; --UNCHK
lin applet_N = mkWN "sovelma" ; --UNCHK
lin applewood_N = mkWN (compoundN "omena" (k18 "puu")) ; --UNCHK
lin appliance_N = mkWN (k48A "laite") ; --UNCHK
lin applicability_N = mkWN (k5 "relevanssi") ; --UNCHK
lin applicable_A = mkWA (k10 "sopiva") ;
lin applicant_N = mkN (lin NK {s = d12 "hakija"}) ;
lin application_1_N = mkN "sovellus" ;
lin application_2_N = mkN "sovellus" ;
lin application_3_N = mkN "sovellus" ;
lin applicative_A = mkWA (k10 "oleva") "sovellettavissa" ; --UNCHK
lin applicator_N = mkWN (k33A "levitin") ; --UNCHK
lin applied_A = mkA "sovellettu" ;
lin applique_N = mkWN (k5A "applikointi") ; --UNCHK
lin applique_V2 = mkWV2 (k62 "applikoida") ; --UNCHK
lin apply_1_V2 = mkV2 "soveltaa" partitive ;
lin apply_2_V2 = mkV2 "hakea" partitive ;
lin apply_V = mkV "soveltua" ;
lin apply_V2 = mkV2 "soveltaa" partitive ;
lin apply_V2V = mkV2V (mkV "soveltaa") partitive infIllat ;
lin apply_VV = mkVV "hakea" infIllat ;
lin apply_for_V2 = prepV2 OP_apply_V OP_for_Prep ; -- guess-p-verb
lin appoint_V2 = mkV2 "nimittää" ; --WV2 (k53 "varustaa") ;
lin appoint_V2V = mkWV2V (k53 "varustaa") ; --UNCHK
lin appoint_V3 = mkWV3 (k53 "varustaa") ; --UNCHK
lin appointed_A = variants {} ; --
lin appointee_N = mkWN (k39 "nimitys") ; --UNCHK
lin appointive_A = mkWA (compoundA "määräyksen" (k38 "varainen")) ; --UNCHK
lin appointment_N = mkN "nimitys" ;
lin apportion_V2 = mkWV2 (k67 "annostella") ; --UNCHK
lin apportionment_N = mkWN (k5A "allokointi") ; --UNCHK
lin apposite_A = mkWA (k38 "olennainen") ; --UNCHK
lin apposition_N = mkWN (k2 "asettelu") "vierekkäin" ; --UNCHK
lin appositional_A = mkWA (compoundA "appositiona" (k38 "alinen")) ; --UNCHK
lin appositively_Adv = mkWAdv "appositiona" ; --UNCHK
lin appraisal_N = mkWN (k5A "arviointi") ;
lin appraise_V2 = mkWV2 (k62 "arvioida") ; --UNCHK
lin appraiser_N = mkWN (k10 "arvioija") ; --UNCHK
lin appreciable_A = mkWA (k10 "huomattava") ; --UNCHK
lin appreciate_V = mkV "arvostaa" ;
lin appreciate_V2 = mkV2 "arvostaa" partitive ;
lin appreciation_N = mkN "arvostus" ; ---ARB mkWN (compoundN "arvon" (k1 "nousu")) ;
lin appreciative_A = mkWA (k10 "ymmärtävä") ; --UNCHK
lin appreciator_N = mkWN (k2 "henkilö") "ymmärtävä" ; --UNCHK
lin apprehend_V2 = mkWV2 (k74 "tajuta") ; --UNCHK
lin apprehender_N = mkWN (compoundN "kiinni" (k10 "ottaja")) ; --UNCHK
lin apprehensible_A = mkWA (k10 "ymmärrettävä") ; --UNCHK
lin apprehension_N = mkWN (k99 "kiinni") "saada" ; --UNCHK
lin apprehensive_A = mkWA (k41A "pelokas") ; --UNCHK
lin apprentice_N = mkWN (k41 "oppilas") ; --UNCHK
lin apprentice_V2 = mkWV2 (k67 "olla") "opissa" ; --UNCHK
lin apprenticeship_N = mkWN (k9A "oppiaika") ; --UNCHK
lin appressed_A = mkWA (compoundA "pai" (k47 "nautunut")) "tiukasti" ; --UNCHK
lin appro_N = mkWN (k10A "hyväksyntä") ; --UNCHK
lin approach_N = mkN "lähestymis" (mkN "tapa") ;
lin approach_V = mkWV (k52A "lähentyä") ; --UNCHK
lin approach_V2 = mkV2 "lähestyä" partitive ;
lin approachability_N = mkWN (k40 "saavutettavuus") ; --UNCHK
lin approachable_A = mkWA "helposti" "lähestyttävä" ; --UNCHK
lin approbation_N = mkWN (k10A "hyväksyntä") ; --UNCHK
lin appropriable_A = mkWA (k10 "oleva") "myönnettävissä" ; --UNCHK
lin appropriate_A = mkA "sopiva" ;
lin appropriate_V2 = mkV2 (mkV "myöntää") (casePrep illative) ; ---ARB varastaa, anastaa, omia ; myöntää jhkin käyttötarkoitukseen. dir obj missing, should be a V3.
lin appropriateness_N = mkWN (k40 "soveltuvuus") ; --UNCHK
lin appropriation_N = mkWN (compoundN "omaksi" (k1A "otto")) ; --f59
lin appropriative_A = mkWA "omaksiotto-" ; --UNCHK
lin appropriator_N = mkWN (k10 "anastaja") ; --UNCHK
lin approval_N = mkN "hyväksyntä" ;
lin approve_V = mkWV (k52 "hyväksyä") ; --f63
lin approve_V2 = mkV2 "hyväksyä" ;
lin approved_A = mkA "hyväksytty" ;
lin approver_N = mkWN (k10 "hyväksyjä") ; --UNCHK
lin approvingly_Adv = mkWAdv (compoundAdv "hyväk" (k99 "syvästi")) ; --UNCHK
lin approximate_A = mkA "likimääräinen" ;
lin approximate_V = mkWV (k62 "estimoida") ; --UNCHK
lin approximate_V2 = mkWV2 (k62 "estimoida") ; --UNCHK
lin approximately_Adv = mkAdv "suunnilleen" ;
lin approximation_N = mkWN (k38 "tuominen") "yhteen" ; --UNCHK
lin appurtenance_N = mkWN (k48 "varuste") ; --UNCHK
lin apractic_A = mkWA "apraksinen" ; --UNCHK
lin apraxia_N = mkWN "haparoivuus" ; --UNCHK
lin apricot_N = mkWN (k5 "aprikoosi") ; --UNCHK
lin apron_N = mkWN (k1 "essu") ; --UNCHK
lin apropos_A = mkWA (k99 "sopivasti") ; --UNCHK
lin apropos_Adv = mkWAdv (k99 "muuten") ; --UNCHK
lin apropos_Prep = mkPrep elative "puheenollen" ;
lin apse_N = mkWN (compoundN "alttari" (k2 "komero")) ; --UNCHK
lin apsidal_A = mkWA "apsis-" ; --UNCHK
lin apt_A = mkA "osuva" ; --mkWA (k38 "olennainen") ;
lin apteral_A = mkWA (compoundA "aptera" (k38 "alinen")) ; --UNCHK
lin apterous_A = mkWA (k34A "siivetön") ; --UNCHK
lin aptitude_N = mkWN (k1A "taito") ; --UNCHK
lin aptitudinal_A = mkWA "taito-" ; --UNCHK
lin aptness_N = mkWN (k40 "sattuvuus") ; --UNCHK
lin apud_Prep = mkPrep "luona" ;
lin aquamarine_N = mkWN (k6 "turkoosi") ; --UNCHK
lin aquanaut_N = mkWN (k10 "sukeltaja") ; --UNCHK
lin aquaphobia_N = mkWN (compoundN "vesi" (k12 "fobia")) ; --UNCHK
lin aquaplane_N = mkWN (compoundN "laine" (k9A "lauta")) ; --UNCHK
lin aquaplane_V = mkWV (compoundV "laine" (k67 "lautailla")) ; --UNCHK
lin aquarium_N = mkWN (k3 "akvaario") ; --UNCHK
lin aquatic_A = mkWA "vesi-" ; --UNCHK
lin aquatic_N = mkWN (compoundN "vesi" (k5 "kasvi")) ; --UNCHK
lin aquatint_N = mkWN (k9 "akvatinta") ; --UNCHK
lin aquavit_N = mkWN (k5A "akvaviitti") ; --UNCHK
lin aqueduct_N = mkWN "akvedukti" ; --UNCHK
lin aqueous_A = mkWA (compoundA "kerros" (k47 "tunut")) ; --UNCHK
lin aquicultural_A = mkWA "hydroponinen" ; --UNCHK
lin aquifer_N = mkWN (k39 "kerros") "pohjavettä" "johtava" ; --UNCHK
lin aquiferous_A = mkWA "pohjavesivara-" ; --UNCHK
lin aquiline_A = mkWA (compoundA "koukku" (k38 "mainen")) ; --UNCHK
lin arab_N = mkWN (k38 "arabialainen") ; --UNCHK
lin arabesque_N = mkWN (k5 "arabeski") ; --UNCHK
lin arabianFem_N = mkWN (k38 "arabialainen") ; --UNCHK
lin arabianMasc_N = mkWN (k38 "arabialainen") ; --UNCHK
lin arabian_A = mkWA (k38 "arabialainen") ; --UNCHK
lin arabic_A = mkWA (k38 "arabialainen") ; --UNCHK
lin arability_N = mkWN (compoundN "viljelys" (k40 "kelpoisuus")) ; --UNCHK
lin arabist_N = mkWN (k5 "arabisti") ; --UNCHK
lin arable_A = mkWA (compoundA "viljely" (k38 "kelpoinen")) ; --UNCHK
lin arachnid_N = mkWN (compoundN "hämähäkki" (k33 "eläin")) ; --UNCHK
lin arachnoid_A = mkWA (compoundA "hämähäkki" (k38 "mäinen")) ; --UNCHK
lin arachnoid_N = mkWN (compoundN "hämähäkki" (k33 "eläin")) ; --UNCHK
lin arachnophobia_N = mkWN (compoundN "hämähäkki" (k1 "kammo")) ; --UNCHK
lin aragonite_N = mkWN (compoundN "arago" (k5A "niitti")) ; --UNCHK
lin aralia_N = mkWN (k12 "aralia") ; --UNCHK
lin arame_N = mkWN "arame" ; --UNCHK
lin araneidal_A = mkWA "hämähäkki-" ; --UNCHK
lin arariba_N = mkWN "Centrolobium" "robustum" ; --UNCHK
lin araroba_N = mkWN "araroba" ; --UNCHK
lin araucaria_N = mkWN (k12 "araukaria") ; --UNCHK
lin arbiter_N = mkWN (k6 "tuomari") ; --UNCHK
lin arbitrable_A = mkWA (k10 "oleva") "soviteltavissa" ; --UNCHK
lin arbitrage_N = mkWN (compoundN "arbitr" (k5 "aasi")) ; --UNCHK
lin arbitrageur_N = mkWN (k2 "henkilö") "arbitraasia" "harjoittava" ; --UNCHK
lin arbitral_A = mkWA "välitys-" ; --UNCHK
lin arbitrament_N = mkWN (k39 "päätös") "välitystuomarin" ; --UNCHK
lin arbitrary_A = mkWA (k38 "mielivaltainen") ;
lin arbitrate_V = mkWV (k61 "toimia") "välittäjänä" ; --UNCHK
lin arbitrate_V2 = mkWV2 (k61 "toimia") "välittäjänä" ; --UNCHK
lin arbitration_N = mkN "sovittelu" ; --mkWN (k39 "päätös") "välitystuomarin" ;
lin arbitrative_A = mkWA "välitys-" ; --UNCHK
lin arbitrator_N = mkWN (k6 "tuomari") ;
lin arbor_N = mkWN (k12 "pergola") ; --UNCHK
lin arboraceous_A = mkWA (k38 "metsäinen") ; --UNCHK
lin arboreal_A = mkWA (k10 "elävä") "puussa" ; --UNCHK
lin arboretum_N = mkWN (k1 "puisto") "kasvitieteellinen" ; --UNCHK
lin arborical_A = mkWA "puu-" ; --UNCHK
lin arboriculture_N = mkWN (compoundN "metsän" (k39 "kasvatus")) ; --UNCHK
lin arborolatry_N = mkWN (k9A "palvonta") "puiden" ; --UNCHK
lin arborvitae_N = mkWN (compoundN "havu" (k18 "puu")) ; --UNCHK
lin arbour_N = mkWN (k12 "pergola") ; --UNCHK
lin arbovirus_N = mkWN (compoundN "arbo" (k39 "virus")) ; --UNCHK
lin arbroath_PN = foreignPN "Arbroath" ;
lin arbutus_N = mkWN "arbutus" ; --UNCHK
lin arc_N = mkWN (kH1 "kaari") ; --UNCHK
lin arc_lamp_N = mkWN (compoundN "kaari" (k1A "lamppu")) ; --UNCHK
lin arc_light_N = mkWN (compoundN "kaari" (k1A "lamppu")) ; --UNCHK
lin arcade_N = mkWN (k4A "pylväikkö") ; --UNCHK
lin arcadian_A = mkWA (k38 "maaseutumainen") ; --UNCHK
lin arcadian_N = mkWN (compoundN "arkadi" (k38 "alainen")) ; --UNCHK
lin arcane_A = mkWA (k38 "vaikeaselkoinen") ; --UNCHK
lin arced_A = mkWA (k10 "kaareva") ; --UNCHK
lin arcella_N = mkWN (compoundN "kiekkokuori" (k9 "ameba")) ; --UNCHK
lin arch_A = mkWA (k10 "tuhma") ; --UNCHK
lin arch_N = mkWN (kH1 "kaari") ; --UNCHK
lin arch_V = mkWV (k52 "käyristyä") ; --UNCHK
lin arch_V2 = mkWV2 (k52 "käyristyä") ; --UNCHK
lin archaebacteria_N = mkWN (compoundN "arkki" (k6 "bakteeri")) ; --UNCHK
lin archaeological_A = mkWA (k38 "arkeologinen") ; --UNCHK
lin archaeologist_N = mkWN (k5 "arkeologi") ; --UNCHK
lin archaeology_N = mkWN (k12 "arkeologia") ; --UNCHK
lin archaeopteryx_N = mkWN (compoundN "muinais" (k38 "siipinen")) ; --UNCHK
lin archaeornis_N = mkWN "archaeornis" ; --UNCHK
lin archaic_A = mkWA (k38 "primitiivinen") ; --UNCHK
lin archaism_N = mkWN (k5 "arkaismi") ; --UNCHK
lin archaist_N = mkWN (k12 "tuntija") "vanhojen" "esineiden" ; --UNCHK
lin archaistic_A = mkWA (k10 "vanhastava") ; --UNCHK
lin archangel_N = mkWN (compoundN "arkki" (k6 "enkeli")) ; --UNCHK
lin archangelic_A = mkWA (compoundA "arkkienk" (k33 "elin")) ; --UNCHK
lin archbishop_N = mkWN (compoundN "arkki" (k9 "piispa")) ; --UNCHK
lin archbishopric_N = mkWN "arkkihiippakunta" ; --UNCHK
lin archdeacon_N = mkWN (compoundN "tuomio" (k5 "rovasti")) ; --UNCHK
lin archdeaconry_N = mkWN (compoundN "tuomiorovasti" (k10A "kunta")) ; --UNCHK
lin archdiocesan_A = mkWA "arkkihiippakunta-" ; --UNCHK
lin archdiocese_N = mkWN "arkkihiippakunta" ; --UNCHK
lin archducal_A = mkWA "arkkiherttuan" ; --UNCHK
lin archduchess_N = mkWN (compoundN "arkki" (k32A "herttuatar")) ; --UNCHK
lin archduchy_N = mkWN (compoundN "arkkiherttua" (k10A "kunta")) ; --UNCHK
lin archduke_N = mkWN (compoundN "arkki" (k12 "herttua")) ; --UNCHK
lin archean_A = mkWA (k38 "arkaainen") ; --UNCHK
lin archegonial_A = mkWA "arkegoninen" ; --UNCHK
lin archegonium_N = mkWN "arkegoni" ; --UNCHK
lin archenteron_N = mkWN (compoundN "alku" (k26 "suoli")) ; --UNCHK
lin archeozoic_A = mkWA "arkeotsooinen" ; --UNCHK
lin archer_N = mkWN (compoundN "Jousim" (k41A "ies")) ; --UNCHK
lin archerfish_N = mkWN (compoundN "ampuja" (k9 "kala")) ; --UNCHK
lin archery_N = mkWN (k9A "jousiammunta") ; --UNCHK
lin archespore_N = mkWN (compoundN "arkesp" (k48 "ori")) ; --UNCHK
lin archesporial_A = mkWA "arkespori-" ; --UNCHK
lin archetypal_A = mkWA (k38 "tyypillinen") ; --UNCHK
lin archetype_N = mkWN (k5 "originaali") ; --UNCHK
lin archiannelid_N = mkWN "arkiannelidi" ; --UNCHK
lin archidiaconal_A = mkWA "tuomiorovasti-" ; --UNCHK
lin archidiaconate_N = mkWN (compoundN "arkkidiako" (k5A "naatti")) ; --UNCHK
lin archiepiscopal_A = mkWA "arkkipiispan" ; --UNCHK
lin archil_N = mkWN (compoundN "lakmus" (k10 "jäkälä")) ; --UNCHK
lin archimandrite_N = mkWN (k9A "arkkimandriitta") ; --UNCHK
lin archine_N = mkWN "arsina" ; --UNCHK
lin archipallium_N = mkWN "paleokorteksi" ; --UNCHK
lin archipelagic_A = mkWA "saaristo-" ; --UNCHK
lin archipelago_N = mkWN (k2 "saaristo") ; --UNCHK
lin architectFem_N = mkWN (k12 "suunnittelija") ; --UNCHK
lin architectMasc_N = variants {} ; --
lin architectonics_N = mkWN (k9A "tektoniikka") ; --UNCHK
lin architectural_A = mkWA (k38 "arkkitehtoninen") ;
lin architecture_N = mkWN (k5 "arkkitehtuuri") ; --UNCHK
lin architrave_N = mkWN (compoundN "liitin" (k5A "palkki")) ; --UNCHK
lin archival_A = mkWA "arkisto-" ; --UNCHK
lin archive_N = mkWN (k2 "arkisto") ; --UNCHK
lin archives_N = mkWN (k2 "arkisto") ; --UNCHK
lin archivist_N = mkWN (compoundN "arkiston" (k10 "hoitaja")) ; --UNCHK
lin archosaur_N = mkWN "arkosaurus" ; --UNCHK
lin archosaurian_A = mkWA "arkosaurus-" ; --UNCHK
lin archpriest_N = mkWN (k39 "priimas") ; --UNCHK
lin archway_N = mkWN (kH1 "kaari") ; --UNCHK
lin arco_A = mkWA "jousella" ; --UNCHK
lin arctic_A = mkWA (k38 "arktinen") ; --UNCHK
lin arctic_N = mkWN (k5 "kalossi") ; --UNCHK
lin arctiid_N = mkWN (compoundN "tiikeri" (k10 "kehrääjä")) ; --UNCHK
lin arcus_N = mkWN (compoundN "vanhuudenk" (k5 "aari")) ; --UNCHK
lin ardeb_N = mkWN "ardeb" ; --UNCHK
lin ardent_A = mkWA (k10 "polttava") ; --UNCHK
lin ardor_N = mkWN (k39 "innostus") ; --UNCHK
lin ardour_N = mkWN (k39 "innostus") ; --UNCHK
lin ardrossan_PN = foreignPN "Ardrossan" ;
lin arduous_A = mkWA (k10 "vaativa") ; --UNCHK
lin arduousness_N = mkWN (k40 "vaativuus") ; --UNCHK
lin are_N = mkWN (k5 "aari") ;
lin area_1_N = mkN "alue" ;
lin area_2_N = mkN "ala" ;
lin area_3_N = mkN "alue" ;
lin area_4_N = mkN "ala" ;
lin area_5_N = mkN "alue" ;
lin area_6_N = mkN "pinta-" (mkN "ala") ;
lin area_N = mkWN (k48 "alue") ;
lin areal_A = mkWA (k38 "alueellinen") ; --UNCHK
lin areaway_N = mkWN (compoundN "etu" (k9 "piha")) ; --UNCHK
lin areca_N = mkWN (compoundN "betel" (k1 "palmu")) ; --UNCHK
lin areflexia_N = mkWN "refleksittömyys" ; --UNCHK
lin arena_N = mkWN (k13 "areena") ;
lin arenaceous_A = mkWA (k38 "hiekkainen") ; --UNCHK
lin arenavirus_N = mkWN (compoundN "areena" (k39 "virus")) ; --UNCHK
lin arenicolous_A = mkWA (k10 "elävä") "hiekassa" ; --UNCHK
lin areola_N = mkWN (k48 "alue") "värillinen" ; --UNCHK
lin areolar_A = mkWA (k10 "kuuluva") "nänninpihaan" ; --UNCHK
lin arete_N = mkWN (compoundN "vuoren" (k9 "harja")) ; --UNCHK
lin arethusa_N = mkWN "arethusa" ; --UNCHK
lin argali_N = mkWN (compoundN "villi" (k41A "lammas")) ; --UNCHK
lin argent_A = mkWA (k38 "hopeainen") ; --UNCHK
lin argent_N = mkWN (k15 "hopea") ; --UNCHK
lin argentic_A = mkWA (compoundA "hopeapi" (k38 "toinen")) ; --UNCHK
lin argentiferous_A = mkWA (compoundA "hopeapi" (k38 "toinen")) ; --UNCHK
lin argentina_PN = foreignPN "Argentiina" ;
lin argentine_N = mkWN (compoundN "kulta" (k48 "kuore")) ; --UNCHK
lin argentine_PN = foreignPN "Argentine" ;
lin argentinian_A = mkWA (compoundA "argentiin" (k38 "alainen")) ; --UNCHK
lin argentinian_N = mkWN (compoundN "argentiin" (k38 "alainen")) ; --UNCHK
lin argentinosaur_N = mkWN "argentinosaurus" ; --UNCHK
lin argentite_N = mkWN (compoundN "hopea" (k48A "hohde")) ; --UNCHK
lin argentous_A = mkWA "hopea-" ; --UNCHK
lin argil_N = mkWN (k7 "savi") "savenvalajan" ; --UNCHK
lin argillaceous_A = mkWA (k38 "savinen") ; --UNCHK
lin argillite_N = mkWN (compoundN "savi" (k7 "kivi")) "tiivis" ; --UNCHK
lin arginine_N = mkWN (compoundN "argi" (k26 "niini")) ; --UNCHK
lin argon_N = mkWN (k5 "argon") ; --UNCHK
lin argonaut_N = mkWN (compoundN "paperi" (k48 "vene")) ; --UNCHK
lin argosy_N = mkWN (k2 "laivasto") ; --UNCHK
lin argot_N = mkWN (k48A "murre") ; --UNCHK
lin arguable_A = mkWA (k34A "ratkaisematon") ; --UNCHK
lin argue_V = mkV "riidellä" | mkV "kiistellä" ;
lin argue_V2 = mkV2 "perustella" ;
lin argue_VS = mkVS (mkV "väittää") ;
lin argue_down_V2 = prepV2 OP_argue_V OP_down_Prep ; -- guess-p-verb
lin argue_out_V2 = prepV2 OP_argue_V OP_out_Prep ; -- guess-p-verb
lin argument_N = mkN "argumentti" ;
lin argumentation_N = mkWN (k48 "peruste") ; --UNCHK
lin argumentative_A = mkWA (compoundA "väittelyn" (k38 "haluinen")) ; --UNCHK
lin argus_N = mkWN (compoundN "argus" (k6 "fasaani")) ; --UNCHK
lin argyle_N = mkWN (k10A "sukka") "ruutukuvioinen" ; --UNCHK
lin argyll_N = mkWN (k10A "sukka") "ruutukuvioinen" ; --UNCHK
lin argyrodite_N = mkWN "argyrodiitti" ; --UNCHK
lin aria_N = mkWN (k12 "aaria") ; --UNCHK
lin arianist_N = mkWN (compoundN "aria" (k5 "nisti")) ; --UNCHK
lin arid_A = mkWA (k10 "kuiva") ; --UNCHK
lin aridity_N = mkWN (k40 "tuottamattomuus") ; --UNCHK
lin aright_Adv = mkWAdv (k99 "oikein") ; --UNCHK
lin aril_N = mkWN (compoundN "siemen" (k9A "vaippa")) ; --UNCHK
lin ariled_A = mkWA (compoundA "siemen" (k38 "vaipallinen")) ; --UNCHK
lin ariose_A = mkWA (k38 "melodinen") ; --UNCHK
lin arioso_N = mkWN (compoundN "laulu" (k1 "soolo")) "lyhyehkö" ; --UNCHK
lin arise_V = mkV (lin VK {s = c66 "nousta"}) ;
lin arista_N = mkWN "arista" ; --UNCHK
lin aristocracy_N = mkWN (k1 "ylimystö") ; --UNCHK
lin aristocrat_N = mkWN (k5 "patriisi") ; --UNCHK
lin aristocratic_A = mkWA (k39 "ylimys") ; --UNCHK
lin arithmancy_N = mkWN (k12 "numerologia") ; --UNCHK
lin arithmetic_N = mkWN (k9A "aritmetiikka") ; --UNCHK
lin arithmetical_A = mkWA (k38 "laskennallinen") ; --UNCHK
lin arithmetician_N = mkWN "aritmeetikko" ; --UNCHK
lin arity_N = mkWN (k10 "määrä") "funktion" "parametrien" ; --UNCHK
lin arizona_PN = foreignPN "Arizona" ;
lin ark_N = mkWN (kH1 "arkki") ; --UNCHK
lin arkansas_PN = mkPN "Arkansas" ;
lin arm_1_N = mkN "käsivarsi" | mkN "käsi" ;
lin arm_2_N = mkN "ase" ;
lin arm_N = mkN "käsi" ;
lin arm_V = mkWV (k54A "rakentaa") "linnakkeita" ; --UNCHK
lin arm_V2 = mkWV2 (k54A "rakentaa") "linnakkeita" ; --UNCHK
lin armada_N = mkWN (k9 "armada") ; --UNCHK
lin armadale_PN = foreignPN "Armadale" ;
lin armadillo_N = mkWN (k38 "vyötiäinen") ; --UNCHK
lin armagh_PN = foreignPN "Armagh" ;
lin armament_N = mkWN (k39 "varustus") ; --UNCHK
lin armamentarium_N = mkWN (k1 "välineistö") ; --UNCHK
lin armature_N = mkWN (k6 "ankkuri") ; --UNCHK
lin armband_N = mkWN (compoundN "käsivarsi" (k9 "nauha")) ; --UNCHK
lin armchair_N = mkWN (compoundN "noja" (k5 "tuoli")) ; --UNCHK
lin armed_A = mkA "aseistettu" ;
lin armenian_N = mkWN (k2 "aakkosto") "armenialainen" ; --UNCHK
lin armful_N = mkWN (k39 "sylys") ; --UNCHK
lin arm_hole_N = mkWN (compoundN "hihan" (k10A "reikä")) ; --UNCHK
lin armiger_N = mkWN (compoundN "aseen" (k10 "kantaja")) ; --UNCHK
lin armilla_N = mkWN (compoundN "ranne" (k41A "rengas")) ; --UNCHK
lin armillary_A = mkWA "rannerenkaiden" ; --UNCHK
lin arming_N = mkWN (k39 "varustus") ; --UNCHK
lin armistice_N = mkWN (compoundN "väli" (k9 "rauha")) ; --UNCHK
lin armless_A = mkWA (k34A "kädetön") ; --UNCHK
lin armlet_N = mkWN (compoundN "käsivarsi" (k9 "nauha")) ; --UNCHK
lin armlike_A = mkWA (compoundA "käsivarsi" (k38 "mainen")) ; --UNCHK
lin armoire_N = mkWN "liinavaatekaappi" ; --UNCHK
lin armored_A = mkWA (compoundA "panssaro" (k1A "itu")) ; --UNCHK
lin armorial_A = mkWA "vaakuna-" ; --UNCHK
lin armour_N = mkWN (k6 "panssari") ; --UNCHK
lin armour_plate_N = mkWN (k13 "haarniska") ; --UNCHK
lin armoured_A = mkWA (compoundA "panssaro" (k1A "itu")) ; --UNCHK
lin armourer_N = mkWN (compoundN "ase" (k10 "valmistaja")) ; --UNCHK
lin armoury_N = mkWN (compoundN "ase" (k9 "paja")) ; --UNCHK
lin armpit_N = mkWN (k2 "kainalo") ; --UNCHK
lin armrest_N = mkWN (compoundN "käsi" (k10 "noja")) ; --UNCHK
lin arms_race_N = mkWN (compoundN "kilpa" (k2 "varustelu")) ; --UNCHK
lin army_N = mkN "armeija" ;
lin armyworm_N = mkWN (k38 "yökkönen") ; --UNCHK
lin arnhem_PN = foreignPN "Arnhem" ;
lin arnica_N = mkWN "arnikki" ; --UNCHK
lin arnold_PN = foreignPN "Arnold" ;
lin aroid_A = mkWA "vehkakasvi-" ; --UNCHK
lin aroma_N = mkWN (k1 "tuoksu") ; --UNCHK
lin aromatherapy_N = mkWN (compoundN "aroma" (k12 "terapia")) ; --UNCHK
lin aromatic_A = mkWA (k38 "aromaattinen") ; --UNCHK
lin around_AdN = mkAdN "suunnilleen" ;
lin around_Adv = mkAdv "suunnilleen" | mkAdv "lähes" ;
lin around_Prep = mkPrep "ympärillä" ;
lin arousal_N = mkWN (k39 "kiihotus") ; --UNCHK
lin arouse_V2 = mkV2 "herättää" ; --mkWV2 (k52A "havahtua") ;
lin arouse_V2V = mkWV2V (k52A "havahtua") ; --UNCHK
lin arpeggio_N = mkWN "arpeggio" ; --UNCHK
lin arquebus_N = mkWN (compoundN "haka" (k1 "pyssy")) ; --UNCHK
lin arrack_N = mkWN (k5A "arrakki") ; --UNCHK
lin arraign_V2 = mkWV2 (k53A "syyttää") ; --UNCHK
lin arraignment_N = mkWN (compoundN "haaste" (k48 "kirje")) ; --UNCHK
lin arrange_V = mkWV (k67A "asetella") ; --UNCHK
lin arrange_V2 = mkV2 "järjestää" | mkWV2 (k67A "asetella") ;
lin arrangement_N = mkN "järjestely" ;
lin arranger_N = mkWN (k10 "muokkaaja") ; --UNCHK
lin arrant_A = mkWA (k10 "syvä") ; --UNCHK
lin arras_N = mkWN (k5 "gobeliini") ; --UNCHK
lin array_N = mkWN "antenni-" ; --UNCHK
lin arrest_N = mkWN (k99 "kiinni") "saada" ; --UNCHK
lin arrest_V2 = mkWV2 (k67A "pidätellä") ; --UNCHK
lin arrester_N = mkWN (k33A "pidätin") ; --UNCHK
lin arresting_A = mkWA (k15 "upea") ; --UNCHK
lin arrhythmic_A = mkWA "rytmittä" ; --UNCHK
lin arriere_pensee_N = mkWN (k39 "epäilys") ; --UNCHK
lin arrival_N = mkN "saapuminen" ;
lin arrive_V = mkV "saapua" | mkV (mkV "tulla") "perille" ;
lin arroba_N = mkWN "arroba" ; --UNCHK
lin arrogance_N = mkWN (k40 "röyhkeys") ; --UNCHK
lin arrogant_A = mkWA (k15 "röyhkeä") ; --UNCHK
lin arrogate_V2 = mkWV2 (k53A "valloittaa") ; --UNCHK
lin arrogator_N = mkWN (k6 "huijari") ; --UNCHK
lin arrow_N = mkWN (k26 "nuoli") ; --UNCHK
lin arrowhead_N = mkWN (compoundN "nuolen" (k18 "pää")) ; --UNCHK
lin arrowroot_N = mkWN (k26 "nuolijuuri") ; --UNCHK
lin arrowsmith_N = mkWN (compoundN "nuoli" (k10A "seppä")) ; --UNCHK
lin arrowworm_N = mkWN (compoundN "nuoli" (k1A "mato")) ; --UNCHK
lin arroyo_N = mkWN (k10 "uoma") ; --UNCHK
lin arse_N = mkWN (k48 "perse") ; --UNCHK
lin arsehole_N = mkWN (k48 "perse") ; --UNCHK
lin arsenal_N = mkN "arsenaali" ; --mkWN (compoundN "ase" (k9 "paja")) ;
lin arsenate_N = mkWN (compoundN "arse" (k5A "naatti")) ; --UNCHK
lin arsenic_N = mkWN (k6 "arseeni") ; --UNCHK
lin arsenical_A = mkWA "arsenikki-" ; --UNCHK
lin arsenical_N = mkWN "arsenikki-" ; --UNCHK
lin arsenide_N = mkWN "arsenidi" ; --UNCHK
lin arsenious_A = mkWA "arsenikki-" ; --UNCHK
lin arsenopyrite_N = mkWN (compoundN "arseeni" (k1 "kiisu")) ; --UNCHK
lin arsine_N = mkWN (compoundN "arseeni" (k5 "hybridi")) ; --UNCHK
lin arson_N = mkWN (compoundN "murha" (k1A "poltto")) ; --UNCHK
lin arsonist_N = mkWN (k5 "pyromaani") ; --UNCHK
lin art_N = L.art_N ;
lin art_PN = mkPN "Art" ;
lin artefact_N = mkWN (k48 "esine") ; --UNCHK
lin artemisia_N = mkWN (k11 "maruna") ; --UNCHK
lin arterial_A = mkWA "valtimo-" ; --UNCHK
lin arteriectasis_N = mkWN (k10 "laajentuma") "valtimon" ; --UNCHK
lin arteriogram_N = mkWN (compoundN "röntgen" (k10 "kuva")) "valtimon" ; --UNCHK
lin arteriolar_A = mkWA "pikkuvaltimo-" ; --UNCHK
lin arteriole_N = mkWN (compoundN "hiussuoni" (k2 "valtimo")) ; --UNCHK
lin arteriosclerosis_N = mkWN (k5 "arterioskleroosi") ; --UNCHK
lin arteritis_N = mkWN (k39 "tulehdus") "valtimon" ; --UNCHK
lin artery_N = mkWN (compoundN "valta" (k10 "väylä")) ; --UNCHK
lin artesian_A = mkWA (k38 "arteesinen") ; --UNCHK
lin artful_A = mkWA (k41A "viekas") ; --UNCHK
lin artfulness_N = mkWN (k40 "viekkaus") ; --UNCHK
lin arthralgia_N = mkWN (compoundN "nivel" (k1A "särky")) ; --UNCHK
lin arthralgic_A = mkWA "nivelsärkyyn" "liittyvä" ; --UNCHK
lin arthritic_A = mkWA (k38 "reumaattinen") ; --UNCHK
lin arthritic_N = mkWN "niveltulehduksesta" "kärsivä" ; --UNCHK
lin arthritis_N = mkWN (compoundN "nivel" (k39 "tulehdus")) ; --UNCHK
lin arthrodesis_N = mkWN (compoundN "luudutus" (k39 "leikkaus")) ; --UNCHK
lin arthrogram_N = mkWN (compoundN "nive" (k66 "lestä")) "röntgenkuva" ; --UNCHK
lin arthrography_N = mkWN (compoundN "röntgen" (k39 "kuvaus")) "nivelen" ; --UNCHK
lin arthromere_N = mkWN (k48A "jaoke") ; --UNCHK
lin arthromeric_A = mkWA "jaokkeisiin" "liittyvä" ; --UNCHK
lin arthropathy_N = mkWN (compoundN "nivel" (k40 "sairaus")) ; --UNCHK
lin arthroplasty_N = mkWN (compoundN "muovaus" (k39 "leikkaus")) "nivelen" ; --UNCHK
lin arthropod_N = mkWN (compoundN "nivel" (k38 "jalkainen")) ; --UNCHK
lin arthropodal_A = mkWA "niveljalkaisia" "koskeva" ; --UNCHK
lin arthroscope_N = mkWN (k33 "tähystin") "nivelen" ; --UNCHK
lin arthroscopy_N = mkWN (compoundN "nivel" (k39 "tähystys")) ; --UNCHK
lin arthrospore_N = mkWN (compoundN "artrosp" (k48 "ori")) ; --UNCHK
lin arthrosporic_A = mkWA "artrosporeihin" "liittyvä" ; --UNCHK
lin arthur_PN = foreignPN "Arthur" ;
lin artichoke_N = mkWN (k10A "artisokka") ; --UNCHK
lin article_N = mkN "artikkeli" ;
lin article_V2 = mkWV2 (k71 "tehdä") "oppisopimus" ; --UNCHK
lin articular_A = mkWA "niveliä" "koskeva" ; --UNCHK
lin articulate_A = mkWA (k10 "ymmärrettävä") ; --UNCHK
lin articulate_V = mkWV (k52 "lausua") ; --UNCHK
lin articulate_V2 = mkWV2 (k52 "lausua") ; --UNCHK
lin articulation_N = mkWN (compoundN "nivel" (k39 "liitos")) ; --UNCHK
lin articulator_N = mkWN (compoundN "puhe" (k48A "laite")) ; --UNCHK
lin articulatory_A = mkWA "ääntämiseen" "liittyvä" ; --UNCHK
lin artifact_N = mkWN (k48 "esine") ; --UNCHK
lin artifactual_A = mkWA "artefakteihin" "liittyvä" ; --UNCHK
lin artifice_N = mkWN (k1A "temppu") ; --UNCHK
lin artificer_N = mkWN (k4A "mekaanikko") ; --UNCHK
lin artificial_A = mkA "keinotekoinen" ;
lin artificiality_N = mkWN "keinotekoisuus" ; --UNCHK
lin artillery_N = mkWN (kH1 "tykki") ; --UNCHK
lin artilleryman_N = mkWN (compoundN "tykki" (k42 "mies")) ; --UNCHK
lin artiodactyl_A = mkWA (compoundA "sorkka" (k33 "eläin")) ; --UNCHK
lin artisan_N = mkWN (k5 "artesaani") ; --UNCHK
lin artist_N = mkN "taiteilija" | mkWN (k5 "artisti") ;
lin artiste_N = mkWN (compoundN "viihde" (k12 "taiteilija")) ; --UNCHK
lin artistic_A = mkA "taiteellinen" ;
lin artistry_N = mkWN (k40 "kyvykkyys") ; --UNCHK
lin artjärvi_PN = mkPN (mkN "Artjärvi" "Artjärviä") ;
lin artlessness_N = mkWN (k40 "vilpittömyys") ; --UNCHK
lin artwork_N = mkWN (k14A "grafiikka") ; --UNCHK
lin arty_A = mkWA (k38 "teennäinen") ; --UNCHK
lin arum_N = mkWN (compoundN "vehka" (k5 "kasvi")) ; --UNCHK
lin arundinaceous_A = mkWA (compoundA "muis" (k10 "tuttava")) "ruokokasveja" ; --UNCHK
lin aryanFem_N = mkWN (k38 "indoiranilainen") ; --UNCHK
lin aryanMasc_N = mkWN (k38 "indoiranilainen") ; --UNCHK
lin aryan_A = mkWA (k38 "arjalainen") ; --UNCHK
lin arytenoid_N = mkWN (compoundN "kannu" (k1 "rusto")) ; --UNCHK
lin as_CAdv = S.as_CAdv ;
lin as_Prep = casePrep essive ;
lin as_Subj = mkSubj "kun" ;
lin as_for_Prep = mkPrep "mitä tulee" elative ;
lin as_long_as_Subj = mkSubj "niin kauan kun" ;
lin as_of_Prep = mkPrep "koskien" partitive ;
lin as_opposed_to_Prep = mkPrep "toisin kuin" nominative ;
lin as_regards_Prep = mkPrep "mitä tulee" illative ;
lin as_well_Adv = mkAdv "samoin" ;
lin as_well_as_Conj = mkConj "yhtä hyvin kuin" ;
lin asafetida_N = mkWN (compoundN "haju" (k9 "pihka")) ; --UNCHK
lin asana_N = mkWN (k1A "asento") ; --UNCHK
lin asarabacca_N = mkWN (compoundN "tapon" (k7A "lehti")) ; --UNCHK
lin asbestos_N = mkWN (k5 "asbesti") ;
lin asbestosis_N = mkWN (k5 "asbestoosi") ; --UNCHK
lin ascariasis_N = mkWN (k40 "sairaus") "suolinkaisten" "aiheuttama" ; --UNCHK
lin ascend_V = mkWV (k66 "nousta") ; --UNCHK
lin ascend_V2 = mkWV2 (k66 "nousta") ; --UNCHK
lin ascendable_A = mkWA (k10 "oleva") "noustavissa" ; --UNCHK
lin ascendancy_N = mkWN (k9A "valta") ; --UNCHK
lin ascendant_A = mkWA (k10 "hallitseva") ; --UNCHK
lin ascendant_N = mkWN (compoundN "kanta" (k10 "isä")) ; --UNCHK
lin ascendency_N = mkWN (k9A "valta") ; --UNCHK
lin ascendent_N = mkWN (compoundN "kanta" (k10 "isä")) ; --UNCHK
lin ascender_N = mkWN (compoundN "ylä" (k40 "pituus")) ; --UNCHK
lin ascension_N = mkWN (k1 "nousu") ; --UNCHK
lin ascensional_A = mkWA "nousu-" ; --UNCHK
lin ascent_N = mkWN (k1 "nousu") ; --UNCHK
lin ascertain_V2 = variants {} ; --
lin ascertainable_A = mkWA (k10 "oleva") "havaittavissa" ; --UNCHK
lin ascetic_A = mkWA (k38 "askeettinen") ; --UNCHK
lin ascetic_N = mkWN (k5A "askeetti") ; --UNCHK
lin asceticism_N = mkWN (k5 "askeesi") ; --UNCHK
lin ascidian_N = mkWN (compoundN "meri" (k7A "tuppi")) ; --UNCHK
lin ascites_N = mkWN (k39 "askites") ; --UNCHK
lin asclepiad_N = mkWN (compoundN "silkki" (k5A "yrtti")) ; --UNCHK
lin asclepiadaceous_A = mkWA "käärmeenpistonyrttikasveihin" "liittyvä" ; --UNCHK
lin ascocarp_N = mkWN (compoundN "asko" (k5A "karppi")) ; --UNCHK
lin ascocarpous_A = mkWA "askokarppiin" "liittyvä" ; --UNCHK
lin ascoma_N = mkWN (compoundN "asc" (k10 "oma")) ; --UNCHK
lin ascomycete_N = mkWN (compoundN "kotelo" (k26 "sieni")) ; --UNCHK
lin ascomycetous_A = mkWA "kotelosieniin" "liittyvä" ; --UNCHK
lin ascospore_N = mkWN (compoundN "kotelo" (k3 "itiö")) ; --UNCHK
lin ascosporic_A = mkWA "koteloitiöitä" "koskeva" ; --UNCHK
lin ascot_N = mkWN "plastron" ; --UNCHK
lin ascot_PN = foreignPN "Ascot" ;
lin ascribable_A = mkWA (k99 "takia") "jnk" ; --UNCHK
lin ascribe_V2 = mkWV2 (k53 "yhdistää") ; --UNCHK
lin ascription_N = mkWN (k38 "lukeminen") "ansioksi" ; --UNCHK
lin ascus_N = mkWN (compoundN "itiö" (k2 "kotelo")) ; --UNCHK
lin asdic_N = mkWN (compoundN "kaiku" (k33 "luotain")) ; --UNCHK
lin aseptic_A = mkWA (k6 "steriili") ; --UNCHK
lin asexual_A = mkWA (k34A "suvuton") ; --UNCHK
lin asexuality_N = mkWN "sukupuolettomuus" ; --UNCHK
lin ash_N = mkWN (k7 "saarni") ; --UNCHK
lin ash_bin_N = mkWN (k39 "roskis") ; --UNCHK
lin ash_can_N = mkWN (compoundN "Ashcan-koulu" (k10A "kunta")) | mkWN (k39 "roskis") ; --UNCHK --UNCHK
lin ashamed_A = mkWA (k1 "nolo") ; --UNCHK
lin ashbourne_PN = foreignPN "Ashbourne" ;
lin ashby_PN = foreignPN "Ashby" ;
lin ashby_de_la_zouch_PN = foreignPN "Ashby de la Zouch" ;
lin ashcake_N = mkWN (compoundN "maissi" (k1 "tasku")) ; --UNCHK
lin ashen_A = mkWA (k15 "valkea") ; --UNCHK
lin ashes_N = L.ashes_N ;
lin ashford_PN = foreignPN "Ashford" ;
lin ashington_PN = foreignPN "Ashington" ;
lin ashlar_N = mkWN (k1A "harkko") ; --UNCHK
lin ashore_Adv = mkWAdv (k99 "maissa") ; --UNCHK
lin ashram_N = mkWN "asrama" ; --UNCHK
lin ashtray_N = mkWN (compoundN "tuhka" (k5A "kuppi")) ; --UNCHK
lin ashy_A = mkWA (compoundA "tuhkan" (k17 "harmaa")) ; --UNCHK
lin asian_A = mkWA (k38 "aasialainen") ; --UNCHK
lin asian_N = mkWN (k38 "aasialainen") ; --UNCHK
lin asiatic_A = mkWA (k38 "aasialainen") ; --UNCHK
lin asiatic_N = mkWN (k38 "aasialainen") ; --UNCHK
lin aside_Adv = mkWAdv (k99 "syrjään") ; --UNCHK
lin aside_N = mkWN (compoundN "reuna" (k39 "huomautus")) ; --UNCHK
lin aside_from_Prep = mkPrep "syrjässä" elative ;
lin asikkala_PN = mkPN "Asikkala" ;
lin asinine_A = mkWA (k10 "tyhjä") ; --UNCHK
lin asininity_N = mkWN (k40 "uppiniskaisuus") ; --UNCHK
lin ask_V = mkV "kysyä" ;
lin ask_V2 = mkV2 (mkV "kysyä") ;
lin ask_V2Q = L.ask_V2Q ;
lin ask_V2V = mkV2V (mkV "pyytää" "pyysi") ;
lin ask_VQ = mkVQ (mkV "kysyä") ;
lin ask_about_V2 = prepV2 OP_ask_V OP_about_Prep ; -- guess-p-verb
lin ask_after_V2 = prepV2 OP_ask_V OP_after_Prep ; -- guess-p-verb
lin ask_around_V = advV OP_ask_V OP_around_Adv ; -- guess-p-verb
lin ask_around_V2 = prepV2 OP_ask_V OP_around_Prep ; -- guess-p-verb
lin ask_for_V2 = mkV2 (mkV "pyytää" "pyysi") partitive ;
lin ask_for_V3 = mkV3 (mkV "pyytää" "pyysi") (mkPrep ablative) (mkPrep partitive) ;
lin ask_in_V2 = mkWV2 (k54A "pyytää") "sisään" ; --UNCHK
lin ask_out_V2 = mkWV2 (k54A "pyytää") "ulos" ; --UNCHK
lin ask_over_V2 = mkWV2 (k54A "pyytää") "käymään" ; --UNCHK
lin ask_round_V2 = mkWV2 (k54A "pyytää") "käymään" ; --UNCHK
lin askainen_PN = mkPN "Askainen" ;
lin askance_A = mkWA (k99 "sirrillään") ; --UNCHK
lin askance_Adv = mkWAdv (k99 "karsaasti") ; --UNCHK
lin askern_PN = foreignPN "Askern" ;
lin askew_A = mkWA (k10 "oleva") "kiemurassa" ; --UNCHK
lin askew_Adv = mkWAdv (k99 "sekaisin") ; --UNCHK
lin asking_N = mkWN (k1A "pyyntö") ; --UNCHK
lin askola_PN = mkPN "Askola" ;
lin aslant_A = mkWA (k1 "vino") ; --UNCHK
lin aslant_Adv = mkWAdv (k99 "viistoon") ; --UNCHK
lin asleep_A = mkA "nukkuva" ; ---?? different POS
lin asleep_Adv = mkWAdv (k99 "nukuksissa") ; --UNCHK
lin asocial_A = mkA "asosiaalinen" ;
lin asp_N = mkN "aspis" (mkN "kyy") ;
lin asparaginase_N = mkWN (compoundN "Els" (k5 "par")) ; --UNCHK
lin asparagine_N = mkWN "asparagiini" ; --UNCHK
lin asparagus_N = mkWN (k9 "parsa") ; --UNCHK
lin aspartame_N = mkWN (k5 "aspartaami") ; --UNCHK
lin aspect_N = mkN "aspekti" ;
lin aspectual_A = mkWA (compoundA "aspektua" (k38 "alinen")) ; --UNCHK
lin aspen_N = mkWN (k9A "haapa") ; --UNCHK
lin asper_N = mkWN "Akçe" ; --UNCHK
lin aspergill_N = mkWN "aspergillium" ; --UNCHK
lin aspergillosis_N = mkWN (compoundN "aspergil" (k5 "loosi")) ; --UNCHK
lin asperity_N = mkWN (k40 "purevuus") ; --UNCHK
lin asperse_V2 = mkWV2 (k73A "liata") ; --UNCHK
lin aspersion_N = mkWN "pirskottaminen" ; --UNCHK
lin aspersorium_N = mkWN "aspergillium" ; --UNCHK
lin asphalt_N = mkWN (k5A "asfaltti") ; --UNCHK
lin asphalt_V2 = mkWV2 (k62 "asfaltoida") ; --UNCHK
lin asphaltic_A = mkWA (k38 "asfalttinen") ; --UNCHK
lin aspheric_A = mkWA "asfäärinen" ; --UNCHK
lin asphodel_N = mkWN (compoundN "kelta" (k1A "soihtu")) ; --UNCHK
lin asphyxia_N = mkWN (compoundN "hapen" (k48A "puute")) ; --UNCHK
lin asphyxiate_V2 = mkWV2 (k52A "tukehtua") ; --UNCHK
lin asphyxiating_A = mkWA "tukahduttava" ; --UNCHK
lin asphyxiation_N = mkWN (compoundN "tuke" (k38 "hduttaminen")) ; --UNCHK
lin aspic_N = mkWN (k2 "hyytelö") ; --UNCHK
lin aspidistra_N = mkWN (compoundN "tuonen" (k1 "kielo")) ; --UNCHK
lin aspirant_A = mkWA (k41A "toiveikas") ; --UNCHK
lin aspirant_N = mkWN (k12 "havittelija") ; --UNCHK
lin aspirate_N = mkWN "aspiraatta" ; --UNCHK
lin aspirate_V2 = mkWV2 "aspiroida" ; --UNCHK
lin aspiration_N = mkWN (k3 "inhalaatio") ; --UNCHK
lin aspirator_N = mkWN (k6 "imuri") ; --UNCHK
lin aspire_V = mkWV (k73A "tähdätä") "jhk" ; --UNCHK
lin aspire_VV = mkWVV (k73A "tähdätä") "jhk" ; --UNCHK
lin aspirin_N = mkWN (compoundN "asetyylisalisyyli" (k1A "happo")) ; --UNCHK
lin assagai_N = mkWN (k41 "keihäs") ; --UNCHK
lin assail_V2 = mkWV2 (k67A "piikitellä") ; --UNCHK
lin assailability_N = mkWN (k40 "haavoittuvuus") ; --UNCHK
lin assailable_A = mkWA (k34A "suojaton") ; --UNCHK
lin assailant_N = mkWN (k10 "ahdistaja") ; --UNCHK
lin assassin_N = mkWN (compoundN "palkka" (k10 "murhaaja")) ; --UNCHK
lin assassinate_V2 = mkWV2 (k74 "tuhota") ; --UNCHK
lin assassination_N = mkWN (compoundN "sala" (k10 "murha")) ; --UNCHK
lin assault_N = mkWN (k4A "rynnäkkö") ;
lin assault_V2 = mkWV2 (k67A "piikitellä") ; --UNCHK
lin assaultive_A = mkWA (k10 "hyökkäävä") ; --UNCHK
lin assay_N = mkWN (k39 "määritys") ; --UNCHK
lin assay_V2 = mkWV2 (k53A "määrittää") ; --UNCHK
lin assayer_N = mkWN (k12 "tekijä") "analyysin" ; --UNCHK
lin assegai_N = mkWN (k41 "keihäs") ; --UNCHK
lin assemblage_N = mkWN (compoundN "koko" (k38 "ontuminen")) ; --UNCHK
lin assemble_V = mkV "kokoontua" ; --mkWV (k61 "kursia") ;
lin assemble_V2 = mkWV2 (k61 "kursia") ; --UNCHK
lin assembler_N = mkWN (k10 "kääntäjä") ; --UNCHK
lin assembly_N = mkN (lin NK {s = d39 "kokous"}) ;
lin assemblyman_N = mkWN (k32 "jäsen") "lakiasäätävän" "kokouksen" ; --UNCHK
lin assemblywoman_N = mkWN (k32 "jäsen") "lakiasäätävän" "kokouksen" ; --UNCHK
lin assent_N = mkWN (k40 "myöntyväisyys") ; --UNCHK
lin assent_V = mkWV (k52 "suostua") ; --UNCHK
lin assenter_N = mkWN (k10 "hyväksyjä") ; --UNCHK
lin assentient_A = mkWA (k10 "myöntyvä") ; --UNCHK
lin assert_V = mkWV (k53A "vakuuttaa") ; --UNCHK
lin assert_V2 = mkWV2 (k53A "vakuuttaa") ;
lin assert_VS = mkWVS (k53A "vakuuttaa") ; --UNCHK
lin asserter_N = mkWN (k10 "vahvistaja") ; --UNCHK
lin assertion_N = mkWN (k39 "julistus") ;
lin assertive_A = mkWA (k10 "vakuuttava") ; --UNCHK
lin assertiveness_N = mkWN (k40 "vakuuttavuus") ; --UNCHK
lin assess_V2 = mkV2 "arvioida" ;
lin assessable_A = mkWA (k10 "oleva") "arvioitavissa" ; --UNCHK
lin assessee_N = mkWN (k10 "arvioija") ; --UNCHK
lin assessment_N = mkWN (k3 "arvio") ;
lin assessor_N = mkWN (k10 "arvioija") ; --UNCHK
lin asset_N = mkN "vara" ;
lin assets_N = mkWN (k40 "varallisuus") ; --UNCHK
lin asseveration_N = mkWN (k39 "julistus") ; --UNCHK
lin asshole_N = mkWN (k48 "perse") ; --UNCHK
lin assibilation_N = mkWN "suhauttaminen" ; --UNCHK
lin assiduity_N = mkWN (k40 "uutteruus") ; --UNCHK
lin assiduous_A = mkWA (k10 "uuttera") ; --UNCHK
lin assign_V2 = mkWV2 (k73 "varata") ; --UNCHK
lin assign_V2V = mkWV2V (k73 "varata") ; --UNCHK
lin assignable_A = mkWA (k10 "vaihdettava") ; --UNCHK
lin assignation_N = mkWN (k5A "allokointi") ; --UNCHK
lin assignee_N = mkWN (compoundN "siirron" (k10 "saaja")) ; --UNCHK
lin assignment_N = mkWN (compoundN "nimi" (k38 "ttäminen")) ; --UNCHK
lin assignor_N = mkWN (k10 "valtuuttaja") ; --UNCHK
lin assimilable_A = mkWA (k10 "oleva") "sulautettavissa" ; --UNCHK
lin assimilate_V = mkWV (k52A "sulautua") ; --UNCHK
lin assimilate_V2 = mkWV2 (k52A "sulautua") ; --UNCHK
lin assimilation_N = mkWN (k3 "assimilaatio") ; --UNCHK
lin assimilative_A = mkWA (compoundA "assimi" (k10 "loiva")) ; --UNCHK
lin assist_N = mkWN (k1A "syöttö") ; --UNCHK
lin assist_V = mkWV (k53 "avustaa") ; --UNCHK
lin assist_V2 = mkWV2 (k53 "avustaa") ; --UNCHK
lin assistance_N = mkWN (k7A "tuki") ; --f56
lin assistantFem_N = mkN "apulainen" ;
lin assistantMasc_N = mkN "apulainen" ;
lin assistant_A = mkA "avustava" ;
lin assistant_N = mkWN (k10 "avustaja") ;
lin assistive_A = mkWA "avustava" ; --UNCHK
lin assize_N = mkWN "käräjä-" ; --UNCHK
lin associability_N = mkWN "assosioituvuus" ; --UNCHK
lin associable_A = mkWA "assosioitava" ; --UNCHK
lin associate_A = mkWA "vara-" ; --UNCHK
lin associate_N = mkN "liittolainen" ;
lin associate_V = mkV "assosioitua" ;
lin associate_V2 = mkWV2 (k62 "assosioida") ;
lin associated_A = mkA "liitännäinen" ;
lin associateship_N = mkWN "kumppani-" ; --UNCHK
lin association_N = mkN "järjestö" | mkN "assosiaatio" ; ---- split
lin associational_A = mkWA "assosiaatioon" "liittyvä" ; --UNCHK
lin associationism_N = mkWN (compoundN "assosiaatio" (k12 "teoria")) ; --UNCHK
lin associative_A = mkWA (k38 "assosiatiivinen") ; --UNCHK
lin assonance_N = mkWN (compoundN "vokaali" (k1A "sointu")) ; --UNCHK
lin assonant_A = mkWA "assonantti" ; --UNCHK
lin assorted_A = mkWA (k38 "sekalainen") ; --UNCHK
lin assortment_N = mkWN (k2 "lajittelu") ; --UNCHK
lin assuage_V2 = mkWV2 (k53A "lievittää") ; --UNCHK
lin assuasive_A = mkWA (compoundA "help" (k10 "ottava")) ; --UNCHK
lin assume_V2 = mkV2 "olettaa" ;
lin assume_VS = mkVS (mkV "olettaa") ;
lin assumption_N = mkN "oletus" ;
lin assumptive_A = mkWA "oletettava" ; --UNCHK
lin assurance_N = mkWN (k40 "varmuus") ; --UNCHK
lin assure_V2 = mkV2 "varmistaa" ;
lin assure_V2S = mkV2S (mkV "vakuuttaa") (casePrep allative) ;
lin assuredly_Adv = mkWAdv (k99 "varmasti") ; --UNCHK
lin assuredness_N = mkWN (k40 "viileys") ; --UNCHK
lin assurgent_A = mkWA "nouseva" ; --UNCHK
lin assuring_A = mkWA (k10 "vakuuttava") ; --UNCHK
lin astasia_N = mkWN (compoundN "seisomis" (k40 "kyvyttömyys")) ; --UNCHK
lin astatic_A = mkWA (compoundA "epä" (k17 "vakaa")) ; --UNCHK
lin astatine_N = mkWN (k5 "astatiini") ; --UNCHK
lin aster_N = mkWN (k7A "tähti") ; --UNCHK
lin asteriated_A = mkWA "tähti-" ; --UNCHK
lin asterion_N = mkWN "asterion" ; --UNCHK
lin asterisk_N = mkWN (k7A "tähti") ; --UNCHK
lin asterisked_A = mkWA "tähdellä" "merkitty" ; --UNCHK
lin asterism_N = mkWN (compoundN "aster" (k5 "ismi")) ; --UNCHK
lin asterismal_A = mkWA "asterismiin" "liittyvä" ; --UNCHK
lin astern_Adv = mkWAdv (k99 "perällä") ; --UNCHK
lin asternal_A = mkWA "rintalastaan" "liittymätön" ; --UNCHK
lin asteroid_A = mkWA (k38 "tähtimäinen") ; --UNCHK
lin asteroid_N = mkWN (k5 "asteroidi") ; --UNCHK
lin asteroidal_A = mkWA (compoundA "muis" (k10 "tuttava")) "asteroidia" ; --UNCHK
lin asthenia_N = mkWN (k12 "astenia") ; --UNCHK
lin asthenic_A = mkWA (k10 "hintelä") ; --UNCHK
lin asthenosphere_N = mkWN (compoundN "astenosf" (k26 "ääri")) ; --UNCHK
lin asthma_N = mkWN (k9 "astma") ; --UNCHK
lin asthmatic_A = mkWA (k38 "astmaattinen") ; --UNCHK
lin asthmatic_N = mkWN (k4A "astmaatikko") ; --UNCHK
lin astigmatic_A = mkWA (compoundA "hajatait" (k38 "toinen")) ; --UNCHK
lin astilbe_N = mkWN (k50 "jaloangervo") ; --UNCHK
lin astir_A = mkWA (k99 "liikkeellä") ; --UNCHK
lin astomatal_A = mkWA (compoundA "suu" (k34A "aukoton")) ; --UNCHK
lin astomatous_A = mkWA (compoundA "suu" (k34A "aukoton")) ; --UNCHK
lin astonish_V2 = mkWV2 (k53A "tyrmistyttää") ; --UNCHK
lin astonishing_A = mkWA "ällistyttävä" ; --UNCHK
lin astonishment_N = mkWN (k39 "ihmetys") ; --UNCHK
lin astound_V2 = mkWV2 (k53A "tyrmistyttää") ; --UNCHK
lin astounding_A = mkWA "mykistävä" ; --UNCHK
lin astragalar_A = mkWA "talukseen" "liittyvä" ; --UNCHK
lin astrakhan_N = mkWN "Astrahan" ; --UNCHK
lin astral_A = mkWA "astraali-" ; --UNCHK
lin astrantia_N = mkWN "rohtosuoputki" ; --UNCHK
lin astray_Adv = mkWAdv (k99 "harhateillä") ; --UNCHK
lin astride_Adv = mkWAdv (k99 "hajareisin") ; --UNCHK
lin astride_Prep = mkPrep "varrella" ;
lin astringency_N = mkWN (k40 "kutistuvuus") ; --UNCHK
lin astringent_A = mkWA (compoundA "yhteen" (k10 "vetävä")) ; --UNCHK
lin astringent_N = mkWN (k48A "lääke") "verenvuodon" "lakkauttava" ; --UNCHK
lin astrocyte_N = mkWN (compoundN "tähti" (k1 "solu")) ; --UNCHK
lin astrocytic_A = mkWA "astrosyyttinen" ; --UNCHK
lin astrodome_N = mkWN (compoundN "havaintojenteko" (k1A "kupu")) ; --UNCHK
lin astrodynamics_N = mkWN (compoundN "astro" (k9A "dynamiikka")) ; --UNCHK
lin astrogator_N = mkWN (compoundN "avaruus" (k10 "suunnistaja")) ; --UNCHK
lin astrolabe_N = mkWN (compoundN "astrol" (k5 "abi")) ; --UNCHK
lin astrolatry_N = mkWN "taivaankappaleiden" "palvominen" ; --UNCHK
lin astrologer_N = mkWN (k5 "astrologi") ; --UNCHK
lin astrological_A = mkWA (k38 "astrologinen") ; --UNCHK
lin astrology_N = mkWN (k12 "astrologia") ; --UNCHK
lin astrometry_N = mkWN "astrometria" ; --UNCHK
lin astronaut_N = mkWN (k5A "kosmonautti") ; --UNCHK
lin astronautic_A = mkWA (compoundA "astronautti" (k38 "nen")) ; --UNCHK
lin astronautics_N = mkWN (k9A "astronautiikka") ; --UNCHK
lin astronomer_N = mkWN (k12 "tutkija") "tähtien" ; --UNCHK
lin astronomic_A = mkWA (k38 "astronominen") ; --UNCHK
lin astronomical_A = mkWA (k38 "astronominen") ; --UNCHK
lin astronomy_N = mkWN (k12 "astronomia") ; --UNCHK
lin astrophysical_A = mkWA (compoundA "astro" (k38 "fysikaalinen")) ; --UNCHK
lin astrophysicist_N = mkWN (compoundN "astro" (k4A "fyysikko")) ; --UNCHK
lin astrophysics_N = mkWN (compoundN "astro" (k14A "fysiikka")) ; --UNCHK
lin astute_A = mkWA (k10 "näppärä") ; --UNCHK
lin astuteness_N = mkWN (k40 "perusteellisuus") ; --UNCHK
lin astylar_A = mkWA "pilariton" ; --UNCHK
lin asylum_N = mkWN (k13 "sairaala") "psykiatrinen" ; --UNCHK
lin asymmetric_A = mkWA (compoundA "epä" (k38 "symmetrinen")) ; --UNCHK
lin asymmetrical_A = mkWA (compoundA "epä" (k38 "symmetrinen")) ; --UNCHK
lin asymmetry_N = mkWN "epätasapaino" ; --UNCHK
lin asymptomatic_A = mkWA (k34A "oireeton") ; --UNCHK
lin asymptote_N = mkWN "asymptootti" ; --UNCHK
lin asymptotic_A = mkWA "asymptoottinen" ; --UNCHK
lin asynchronism_N = mkWN (compoundN "eri" (k40 "aikaisuus")) ; --UNCHK
lin asynchronous_A = mkWA (compoundA "epä" (k38 "tahtinen")) ; --UNCHK
lin asynclitism_N = mkWN (k40 "vinous") ; --UNCHK
lin asyndetic_A = mkWA (compoundA "asynd" (k38 "eettinen")) ; --UNCHK
lin asyndeton_N = mkWN (k39 "rinnastus") "sidesanaton" ; --UNCHK
lin asynergic_A = mkWA "asynerginen" ; --UNCHK
lin asynergy_N = mkWN "asynergia" ; --UNCHK
lin asystole_N = mkWN (compoundN "sydän" (k39 "pysähdys")) ; --UNCHK
lin at_N = mkWN "kip" ; --UNCHK
lin at_Prep = casePrep adessive | casePrep inessive ; ---- | mkPrep "luona" | mkPrep "tykönä" ; ---- split
lin at_all_Adv = mkAdv "ollenkaan" ;
lin at_home_Adv = mkAdv "kotona" ;
lin at_home_N = mkWN (compoundN "vastaan" (k1A "otto")) ; --UNCHK
lin at_least_AdN = S.at_least_AdN ;
lin at_most_AdN = S.at_most_AdN ;
lin at_the_behest_of_Prep = mkPrep "käskystä" ;
lin atabrine_N = mkWN "Atabrine" ; --UNCHK
lin ataractic_A = mkWA (compoundA "sedatiivi" (k38 "nen")) ; --UNCHK
lin ataraxia_N = mkWN (k40 "tyyneys") ; --UNCHK
lin atavism_N = mkWN (k10 "takauma") ; --UNCHK
lin atavist_N = mkWN (k38 "atavistinen") ; --UNCHK
lin atavistic_A = mkWA (k38 "atavistinen") ; --UNCHK
lin ataxia_N = mkWN (compoundN "yhteistoiminta" (k3 "häiriö")) "lihasten" ; --UNCHK
lin ataxic_A = mkWA "hapuileva" ; --UNCHK
lin ateleiosis_N = mkWN "atelioosi" ; --UNCHK
lin ateleiotic_A = mkWA "ateleioosiin" "liittyvä" ; --UNCHK
lin atelier_N = mkWN (k20 "ateljee") ; --UNCHK
lin atenolol_N = mkWN "Tenormin" ; --UNCHK
lin athanor_N = mkWN (compoundN "athanor-u" (k24 "uni")) ; --UNCHK
lin atheism_N = mkWN (k5 "ateismi") ; --UNCHK
lin atheist_A = mkWA (k38 "ateistinen") ; --UNCHK
lin atheist_N = mkWN (k5 "ateisti") ; --UNCHK
lin atheistic_A = mkWA (k38 "ateistinen") ; --UNCHK
lin athenaeum_N = mkWN (k2 "kirjasto") ; --UNCHK
lin athenianFem_N = mkWN (compoundN "ateen" (k38 "alainen")) ; --UNCHK
lin athenianMasc_N = mkWN (compoundN "ateen" (k38 "alainen")) ; --UNCHK
lin athenian_A = mkWA (compoundA "ateen" (k38 "alainen")) ; --UNCHK
lin athens_1_PN = foreignPN "Ateena" ;
lin athens_2_PN = foreignPN "Ateena" ;
lin athens_PN = mkPN "Ateena" ;
lin atherogenesis_N = mkWN "aterogeneesi" ; --UNCHK
lin atheromatous_A = mkWA (compoundA "atero" (k38 "omainen")) ; --UNCHK
lin atherosclerosis_N = mkWN (compoundN "sepelvaltimo" (k5A "tauti")) ; --UNCHK
lin atherosclerotic_A = mkWA (compoundA "ateroskl" (k38 "eroottinen")) ; --UNCHK
lin atherstone_PN = foreignPN "Atherstone" ;
lin athetosis_N = mkWN "atetoosi" ; --UNCHK
lin athirst_A = mkWA (k38 "-himoinen") ; --UNCHK
lin athlete_N = mkWN (k5A "atleetti") ; --UNCHK
lin athletic_A = mkA "atleettinen" ;
lin athleticism_N = mkWN (k40 "voimakkuus") ; --UNCHK
lin athletics_N = mkWN (k2 "urheilu") ;
lin athlone_PN = foreignPN "Athlone" ;
lin athwart_Adv = mkWAdv (k99 "viistoon") ; --UNCHK
lin atilt_A = mkWA (compoundA "kallis" (k47 "tunut")) ; --UNCHK
lin atlanta_PN = foreignPN "Atlanta" ;
lin atlantic_PN = foreignPN "Atlantic" ;
lin atlas_N = mkWN (k39 "atlas") ; --UNCHK
lin atmometer_N = mkWN (compoundN "haihtumis" (k6 "mittari")) ; --UNCHK
lin atmosphere_N = mkWN (k39 "tuulahdus") ; --UNCHK
lin atmospheric_A = mkA "ilmakehällinen" ; ---
lin atmospherics_N = mkWN (k13 "kohina") ; --UNCHK
lin atole_N = mkWN (k5 "velli") ; --UNCHK
lin atoll_N = mkWN (k6 "atolli") ; --UNCHK
lin atom_N = mkWN (k38 "hitunen") ; --UNCHK
lin atomic_A = mkWA "ydin-" ; --UNCHK
lin atomism_N = mkWN (k5 "atomismi") ; --UNCHK
lin atomistic_A = mkWA (k38 "atomistinen") ; --UNCHK
lin atomization_N = mkWN (compoundN "atomi" (k5A "sointi")) ; --UNCHK
lin atomize_V2 = mkWV2 (k53A "hajottaa") ; --UNCHK
lin atomizer_N = mkWN (k33A "suutin") ; --UNCHK
lin atonal_A = mkWA (k38 "atonaalinen") ; --UNCHK
lin atonalistic_A = mkWA "atonaalisuuteen" "liittyvä" ; --UNCHK
lin atonality_N = mkWN (k40 "atonaalisuus") ; --UNCHK
lin atone_V = mkWV (k71 "tehdä") "parannus" ; --UNCHK
lin atonement_N = mkWN (k39 "sovitus") ; --UNCHK
lin atonic_A = mkWA (k34A "painoton") ; --UNCHK
lin atonicity_N = mkWN (k40 "velttous") ; --UNCHK
lin atop_Adv = mkWAdv (k99 "päälle") ; --UNCHK
lin atop_Prep = mkPrep "huipulla" ;
lin atopognosia_N = mkWN "atopognosia" ; --UNCHK
lin atorvastatin_N = mkWN (compoundN "atorv" (k5 "astatiini")) ; --UNCHK
lin atrabilious_A = mkWA (k10 "pahoinvoiva") ; --UNCHK
lin atrazine_N = mkWN "atrasiini" ; --UNCHK
lin atresia_N = mkWN "atresia" ; --UNCHK
lin atrium_N = mkWN (k5 "atrium") ; --UNCHK
lin atrocious_A = mkWA (k10 "karmiva") ; --UNCHK
lin atrocity_N = mkWN (k40 "julmuus") ; --UNCHK
lin atrophic_A = mkWA "surkastunut" ; --UNCHK
lin atrophy_N = mkWN "surkastuminen" ; --UNCHK
lin atrophy_V = mkWV (k52A "näivettyä") ; --UNCHK
lin atrophy_V2 = mkWV2 (k52A "näivettyä") ; --UNCHK
lin atropine_N = mkWN "atropiini" ; --UNCHK
lin attach_V = mkWV (k53A "liittää") ; --UNCHK
lin attach_V2 = mkWV2 (k53A "liittää") ;
lin attachable_A = mkWA (k10 "oleva") "sidottavissa" ; --UNCHK
lin attache_N = mkWN (compoundN "attasea" (k1A "salkku")) ; --UNCHK
lin attachment_N = mkWN (k39 "kiinnitys") ; --UNCHK
lin attack_N = mkN "hyökkäys" ;
lin attack_V2 = mkV2 "hyökätä" ;
lin attacker_N = mkWN (k10 "ahdistaja") ; --UNCHK
lin attain_V = mkWV (k56 "kasvaa") ; --UNCHK
lin attain_V2 = mkWV2 (k56 "kasvaa") ; --UNCHK
lin attainable_A = mkWA (k10 "oleva") "saatavilla" ; --UNCHK
lin attainder_N = mkWN (compoundN "kansalais" (k10 "kuolema")) ; --UNCHK
lin attainment_N = mkWN (compoundN "pää" (k38 "seminen")) ; --UNCHK
lin attar_N = mkWN (compoundN "ruusu" (k1 "öljy")) ; --UNCHK
lin attempt_1_N = mkN "yritys" ;
lin attempt_2_N = mkN "yritys" ;
lin attempt_N = mkN (lin NK {s = d39 "yritys"}) ;
lin attempt_V2 = mkV2 "yrittää" partitive ;
lin attempt_VV = mkVV (mkV "yrittää") ;
lin attempted_A = variants {} ; --
lin attend_V = mkV "osallistua" ;
lin attend_V2 = mkV2 "osallistua" elative ;
lin attendance_N = mkWN (compoundN "läsnä" (k1A "olo")) ;
lin attendant_A = mkA "liittyvä" ; ---ARB ; jonkin seurassa oleva
lin attendant_N = mkWN (k10 "sattuma") ; --UNCHK
lin attention_N = mkN (lin NK {s = d03 "huomio"}) ;
lin attentional_A = mkWA "huomioon" "liittyvä" ; --UNCHK
lin attentive_A = mkWA (k41A "valpas") ; --UNCHK
lin attentiveness_N = mkWN (k40 "tarkkaavaisuus") ; --UNCHK
lin attenuate_A = mkWA (k15 "vaimea") ; --UNCHK
lin attenuate_V2 = mkWV2 (k52A "vaimentua") ; --UNCHK
lin attenuation_N = mkWN (compoundN "vai" (k38 "mentuminen")) ; --UNCHK
lin attenuator_N = mkWN (k33A "vaimennin") ; --UNCHK
lin attest_V = mkWV (k53 "todistaa") ; --UNCHK
lin attest_V2 = mkWV2 (k53 "todistaa") ; --UNCHK
lin attest_VS = mkWVS (k53 "todistaa") ; --UNCHK
lin attestation_N = mkWN (k48 "todiste") ; --UNCHK
lin attester_N = mkWN (k10 "todistaja") ; --UNCHK
lin attic_A = mkWA (compoundA "atti" (k38 "kalainen")) ; --UNCHK
lin attic_N = mkWN "attika" ; --UNCHK
lin attire_N = mkWN (k1A "puku") ; --UNCHK
lin attire_V2 = mkWV2 (k52A "pukeutua") ; --UNCHK
lin attitude_N = mkN "asenne" ;
lin attitudinal_A = mkWA "suhtautumis-" ; --UNCHK
lin attitudinize_V = mkWV (k73 "poseerata") ; --UNCHK
lin attorney_N = mkWN (k5 "juristi") ; --f193
lin attorneyship_N = mkWN (compoundN "asian" (k10 "ajaja")) ; --UNCHK
lin attosecond_N = mkWN (compoundN "atto" (k5A "sekunti")) ; --UNCHK
lin attract_V2 = mkV2 (mkWV (k53A "vetää") "puoleensa") partitive ;
lin attractable_A = mkWA (k38 "magneettinen") ; --UNCHK
lin attraction_N = mkN "viehätys" ; --WN (k40 "viehättävyys") ;
lin attractive_A = mkWA (k10 "viehättävä") ;
lin attractiveness_N = mkWN (k40 "viehättävyys") ; --UNCHK
lin attractor_N = mkWN (k5A "magneetti") ; --UNCHK
lin attributable_A = mkWA (k10 "luettava") "syyksi" ; --UNCHK
lin attribute_N = mkWN (k5A "attribuutti") ; --UNCHK
lin attribute_V2 = mkV2 "nimittää" ;
lin attribution_N = mkWN (k38 "lukeminen") "ansioksi" ; --UNCHK
lin attributive_A = mkWA "attributiivinen" ; --UNCHK
lin attrited_A = mkWA (compoundA "kulu" (k47 "nut")) ; --UNCHK
lin attrition_N = mkWN (compoundN "hie" (k38 "rtyminen")) ; --UNCHK
lin attritional_A = mkWA "kulumiseen" "liittyvä" ; --UNCHK
lin attune_V2 = mkWV2 (k53A "virittää") ; --UNCHK
lin atypical_A = mkWA (k10 "poikkeava") ; --UNCHK
lin atypicality_N = mkWN (k40 "poikkeavuus") ; --UNCHK
lin au_fait_A = mkWA (k99 "tasalla") ; --UNCHK
lin au_pair_N = mkWN "au" "pair" ; --UNCHK
lin aubergine_N = mkWN (compoundN "muna" (k1 "koiso")) ; --UNCHK
lin auburn_A = mkWA (compoundA "kastanjan" (k15 "ruskea")) ; --UNCHK
lin auckland_PN = foreignPN "Auckland" ;
lin auction_N = mkWN (compoundN "huuto" (k9A "kauppa")) ;
lin auction_V2 = mkV2 "huutokaupata" ;
lin auctioneer_N = mkWN (k10 "toimittaja") "huutokaupan" ; --UNCHK
lin audacious_A = mkWA (k41 "uskalias") ; --UNCHK
lin audacity_N = mkWN (k40 "röyhkeys") ; --UNCHK
lin audibility_N = mkWN (k40 "kuuluvuus") ; --UNCHK
lin audible_A = mkWA (k10 "kuuluva") ; --UNCHK
lin audible_N = mkWN "pelikuvion" "ilmoittaminen" ; --UNCHK
lin audience_N = mkN "yleisö" ;
lin audile_N = mkWN (compoundN "kuulo" (k38 "ihminen")) ; --UNCHK
lin audio_N = mkWN (k26 "ääni") ; --UNCHK
lin audiocassette_N = mkWN (compoundN "ääni" (k5A "kasetti")) ; --UNCHK
lin audiogram_N = mkWN "audiogrammi" ; --UNCHK
lin audiology_N = mkWN (compoundN "audio" (k5 "metri")) ; --UNCHK
lin audiometer_N = mkWN (compoundN "sono" (k5 "metri")) ; --UNCHK
lin audiometric_A = mkWA (compoundA "audio" (k38 "metrinen")) ; --UNCHK
lin audiometry_N = mkWN (compoundN "audio" (k5 "metri")) ; --UNCHK
lin audiotape_N = mkWN (compoundN "ääni" (k9 "nauha")) ; --UNCHK
lin audiovisual_A = mkWA (compoundA "audio" (k38 "visuaalinen")) ; --UNCHK
lin audiovisual_N = mkWN (compoundN "apu" (k48 "väline")) "audiovisuaalinen" ; --UNCHK
lin audit_N = mkWN (k39 "tarkastus") ; --UNCHK
lin audit_V2 = mkV2 "tarkastaa" ; --mkWV2 (k67 "olla") "kuunteluoppilaana" ;
lin audition_N = mkWN (compoundN "koe-" (k38 "esiintyminen")) ; --UNCHK
lin audition_V = mkWV (k52 "osallistua") "koe-esiintymiseen" ; --UNCHK
lin audition_V2 = mkWV2 (k52 "osallistua") "koe-esiintymiseen" ; --UNCHK
lin auditor_N = mkWN (compoundN "tilin" (k10 "tarkastaja")) ; --UNCHK
lin auditorium_N = mkWN (k2 "katsomo") ; --UNCHK
lin auditory_A = mkWA (k38 "auditiivinen") ; --UNCHK
lin audley_PN = foreignPN "Audley" ;
lin aug_PN = mkPN "Aug" ;
lin augend_N = mkWN "yhteenlaskettava" ; --UNCHK
lin auger_N = mkWN (k6 "näveri") ; --UNCHK
lin aught_N = mkWN (k101 "mikään") "ei" ; --UNCHK
lin augite_N = mkWN "augiitti" ; --UNCHK
lin augitic_A = mkWA "augiittinen" ; --UNCHK
lin augment_V = mkWV (k54A "laajentaa") ; --UNCHK
lin augment_V2 = mkWV2 (k54A "laajentaa") ; --UNCHK
lin augmentation_N = mkWN (compoundN "suu" (k38 "rentaminen")) ; --UNCHK
lin augsburg_PN = foreignPN "Augsburg" ;
lin augur_N = mkWN "auguuri" ; --UNCHK
lin augur_V = mkWV (k69 "merkitä") ; --UNCHK
lin augur_V2 = mkWV2 (k69 "merkitä") ; --UNCHK
lin augury_N = mkWN (k48A "enne") ; --UNCHK
lin august_A = mkWA (compoundA "kunnian" (k10 "arvoisa")) ; --UNCHK
lin auk_N = mkWN (k5A "ruokki") ; --UNCHK
lin auklet_N = mkWN (compoundN "pikku" (k5A "ruokki")) ; --UNCHK
lin auld_A = mkWA "wanha" ; --UNCHK
lin aunt_N = mkWN (k5A "täti") ; --UNCHK
lin auntie_N = mkWN (k5A "täti") ; --UNCHK
lin aunty_N = mkWN (k5A "täti") ; --UNCHK
lin aura_N = mkWN (k39 "tuulahdus") ; --UNCHK
lin aura_PN = mkPN "Aura" ;
lin aural_A = mkWA (compoundA "aura" (k38 "alinen")) ; --UNCHK
lin aureate_A = mkWA (k38 "kultainen") ; --UNCHK
lin aureole_N = mkWN (kH1 "aura") ; --UNCHK
lin auricle_N = mkWN (compoundN "ulko" (k10 "korva")) ; --UNCHK
lin auricula_N = mkWN (k48A "korvake") "sydämen" ; --UNCHK
lin auriculare_N = mkWN (compoundN "keski" (k48 "piste")) "korvakäytävän" "ulkoaukon" ; --UNCHK
lin auriculate_A = mkWA (compoundA "korva" (k38 "kkeellinen")) ; --UNCHK
lin auriferous_A = mkWA (compoundA "kultapi" (k38 "toinen")) ; --UNCHK
lin auriform_A = mkWA (k38 "muotoinen") "korvan" ; --UNCHK
lin aurochs_N = mkWN (compoundN "alku" (k10A "härkä")) ; --UNCHK
lin aurora_N = mkWN (compoundN "Aur" (k10 "ora")) ; --UNCHK
lin auroral_A = mkWA "aamuruskon" ; --UNCHK
lin aurous_A = mkWA "kulta-" ; --UNCHK
lin auscultation_N = mkWN (k2 "kuuntelu") ; --UNCHK
lin auscultatory_A = mkWA "kuunteluun" "liittyvä" ; --UNCHK
lin auspice_N = mkWN (k48A "enne") ; --UNCHK
lin auspices_N = mkWN (kH1 "suoja") ; --UNCHK
lin auspicious_A = mkWA (k38 "otollinen") ; --UNCHK
lin auspiciousness_N = mkWN (k40 "suotuisuus") ; --UNCHK
lin aussie_N = mkWN (k5 "aussi") ; --UNCHK
lin austenite_N = mkWN (compoundN "auste" (k5A "niitti")) ; --UNCHK
lin austenitic_A = mkWA "austeniittinen" ; --UNCHK
lin austere_A = mkWA (k38 "spartalainen") ; --UNCHK
lin austereness_N = mkWN (k40 "karuus") ; --UNCHK
lin austerity_N = mkWN (k40 "karuus") ;
lin austral_A = mkWA (k38 "eteläinen") ; --UNCHK
lin austral_N = mkWN "austral" ; --UNCHK
lin australia_PN = foreignPN "Australia" ;
lin australianFem_N = variants {} ; ---- sense to be split
lin australianMasc_N = variants {} ; ---- sense to be split
lin australian_A = mkA "australialainen" ;
lin australopithecine_A = mkWA "Australopithecusiin" "liittyvä" ; --UNCHK
lin australopithecine_N = mkWN "Australopithecus" ; --UNCHK
lin austria_PN = mkPN "Itävalta" ;
lin austrianFem_N = mkWN (k38 "itävaltalainen") ; --UNCHK
lin austrianMasc_N = mkWN (k38 "itävaltalainen") ; --UNCHK
lin austrian_A = mkWA (k38 "itävaltalainen") ; --UNCHK
lin autacoid_N = mkWN "autakoidi" ; --UNCHK
lin autacoidal_A = mkWA "autakoidiin" "liittyvä" ; --UNCHK
lin autarchic_A = mkWA (compoundA "oma" (k38 "varainen")) ; --UNCHK
lin autarchy_N = mkWN (k40 "riippumattomuus") "taloudellinen" ; --UNCHK
lin autarkic_A = mkWA (compoundA "oma" (k38 "varainen")) ; --UNCHK
lin autarky_N = mkWN (k40 "riippumattomuus") "taloudellinen" ; --UNCHK
lin auteur_N = mkWN "auteur" ; --UNCHK
lin authentic_A = mkWA (k38 "varsinainen") ; --UNCHK
lin authenticate_V2 = mkWV2 (k54A "todentaa") ; --UNCHK
lin authentication_N = mkWN (k39 "todennus") ; --UNCHK
lin authenticity_N = mkWN (k40 "oikeellisuus") ; --UNCHK
lin author_N = mkWN (k12 "tekijä") ; --f57
lin authoress_N = mkWN (compoundN "nais" (k12 "kirjailija")) ; --UNCHK
lin authoritarian_A = mkWA (k38 "tyrannimainen") ; --UNCHK
lin authoritarian_N = mkWN (k6 "diktaattori") ; --UNCHK
lin authoritarianism_N = mkWN (k12 "tyrannia") ; --UNCHK
lin authoritative_A = mkWA (k1A "valtuutettu") ; --UNCHK
lin authority_1_N = mkN "auktoriteetti" ;
lin authority_2_N = mkN "viranomainen" ;
lin authority_N = mkN "viranomainen" ;
lin authorization_N = mkWN (k39 "oikeutus") ; --UNCHK
lin authorize_V2 = mkV2 "valtuuttaa" ;
lin authorize_V2V = mkV2V (mkV "valtuuttaa") accusative infIllat ;
lin authorizer_N = mkWN (k10 "valtuuttaja") ; --UNCHK
lin authorship_N = mkWN (k40 "henkilöllisyys") "kirjoittajan" ; --UNCHK
lin autism_N = mkWN (k5 "autismi") ; --UNCHK
lin autistic_A = mkWA (k38 "autistinen") ; --UNCHK
lin auto_N = mkN (lin NK {s = d01 "auto"}) ;
lin autobahn_N = mkWN "autobahn" ; --UNCHK
lin autobiographer_N = mkWN (k10 "kirjoittaja") "omaelämäkerran" ; --UNCHK
lin autobiographic_A = mkWA "omaelämäkerrallinen" ; --UNCHK
lin autobiographical_A = mkWA "omaelämäkerrallinen" ; --UNCHK
lin autobiography_N = mkWN (k50 "omaelämäkerta") ; --UNCHK
lin autocatalysis_N = mkWN (k3 "reaktio") "itseään" "kiihdyttävä" ; --UNCHK
lin autocatalytic_A = mkWA (compoundA "auto" (k38 "katalyyttinen")) ; --UNCHK
lin autochthon_N = mkWN "autoktoni" ; --UNCHK
lin autochthonal_A = mkWA (k38 "kotimainen") ; --UNCHK
lin autochthonous_A = mkWA (compoundA "auto" (k38 "ktoninen")) ; --UNCHK
lin autoclave_N = mkWN (k6 "sterilisaattori") ; --UNCHK
lin autocracy_N = mkWN (k40 "itsevaltius") ; --UNCHK
lin autocrat_N = mkWN (k5A "despootti") ; --UNCHK
lin autocratic_A = mkWA (k38 "tyrannimainen") ; --UNCHK
lin autodidactic_A = mkWA (compoundA "itse" (k47 "oppinut")) ; --UNCHK
lin autoerotic_A = mkWA (compoundA "auto" (k38 "eroottinen")) ; --UNCHK
lin autoeroticism_N = mkWN (k5A "masturbointi") ; --UNCHK
lin autofluorescence_N = mkWN (compoundN "autofluor" (k5 "esanssi")) ; --UNCHK
lin autofluorescent_A = mkWA (compoundA "autofluores" (k10 "oiva")) ; --UNCHK
lin autofocus_N = mkWN (compoundN "automaatti" (k39 "tarkennus")) ; --UNCHK
lin autogamous_A = mkWA (compoundA "itsesiit" (k38 "toinen")) ; --UNCHK
lin autogamy_N = mkWN "autogamia" ; --UNCHK
lin autogenetic_A = mkWA (compoundA "auto" (k38 "geeninen")) ; --UNCHK
lin autogenous_A = mkWA (compoundA "auto" (k38 "geeninen")) ; --UNCHK
lin autogiro_N = mkWN (k1 "autogiro") ; --UNCHK
lin autograft_N = mkWN (compoundN "autopl" (k12 "astia")) ; --UNCHK
lin autograph_N = mkWN (compoundN "nimi" (k39 "kirjoitus")) ; --UNCHK
lin autograph_V2 = mkWV2 (k56A "antaa") "nimikirjoitus" ; --UNCHK
lin autographic_A = mkWA (compoundA "auto" (k38 "grafinen")) ; --UNCHK
lin autogyro_N = mkWN (k1 "autogiro") ; --UNCHK
lin autoicous_A = mkWA "itsepölyttyvä" ; --UNCHK
lin autoimmune_A = mkWA "autoimmuuni-" ; --UNCHK
lin autoimmunity_N = mkWN (compoundN "auto" (k5A "immuniteetti")) ; --UNCHK
lin autoinjector_N = mkWN (compoundN "automaatti" (k1 "ruisku")) ; --UNCHK
lin autoloader_N = mkWN (k48 "ase") "itselataava" ; --UNCHK
lin autologous_A = mkWA (compoundA "auto" (k38 "loginen")) ; --UNCHK
lin autolysis_N = mkWN (compoundN "autoly" (k5 "ysi")) ; --UNCHK
lin autolytic_A = mkWA (compoundA "auto" (k38 "lyyttinen")) ; --UNCHK
lin automat_N = mkWN (compoundN "automaatti" (k12 "kahvila")) ; --UNCHK
lin automate_V2 = mkWV2 (k71 "tehdä") "automaattiseksi" ; --UNCHK
lin automated_A = mkA "automatisoitu" ;
lin automatic_A = mkWA (k38 "automaattinen") ; --UNCHK
lin automatic_N = mkWN (compoundN "automaatti" (k6 "pistooli")) ; --UNCHK
lin automation_N = mkWN (k3 "automaatio") ; --UNCHK
lin automaton_N = mkWN (k5A "robotti") ; --UNCHK
lin automobile_N = mkWN (k1 "auto") ;
lin automotive_A = mkWA "auto-" ; --UNCHK
lin automysophobia_N = mkWN (compoundN "automyso" (k12 "fobia")) ; --UNCHK
lin autonomic_A = mkWA (k34A "riippumaton") "tahdosta" ; --UNCHK
lin autonomous_A = mkWA (k38 "itsenäinen") ; --UNCHK
lin autonomy_N = mkWN (k40 "vapaus") ; --UNCHK
lin autophyte_N = mkWN (k3 "eliö") "omavarainen" ; --UNCHK
lin autopilot_N = mkWN (compoundN "auto" (k5A "pilotti")) ; --UNCHK
lin autoplastic_A = mkWA (compoundA "auto" (k38 "plastinen")) ; --UNCHK
lin autoplasty_N = mkWN (compoundN "autopl" (k12 "astia")) ; --UNCHK
lin autopsy_N = mkWN (compoundN "ruumiin" (k39 "avaus")) ; --UNCHK
lin autoradiograph_N = mkWN "autoradiografi" ; --UNCHK
lin autoradiographic_A = mkWA (compoundA "auto" (k38 "radiografinen")) ; --UNCHK
lin autoradiography_N = mkWN "autoradiografia" ; --UNCHK
lin autoregulation_N = mkWN (compoundN "itse" (k2 "säätely")) ; --UNCHK
lin autosemantic_A = mkWA (compoundA "auto" (k38 "semanttinen")) ; --UNCHK
lin autosexing_N = mkWN (compoundN "itse" (k39 "jalostus")) ; --UNCHK
lin autosomal_A = mkWA (compoundA "auto" (k38 "sominen")) ; --UNCHK
lin autosome_N = mkWN (k5 "kromosomi") "somaattinen" ; --UNCHK
lin autostrada_N = mkWN "autostrada" ; --UNCHK
lin autosuggestion_N = mkWN (compoundN "itse" (k3 "suggestio")) ; --UNCHK
lin autotelic_A = mkWA (compoundA "auto" (k38 "telinen")) ; --UNCHK
lin autotelism_N = mkWN (compoundN "autotel" (k5 "ismi")) ; --UNCHK
lin autotomic_A = mkWA (compoundA "auto" (k38 "tominen")) ; --UNCHK
lin autotomy_N = mkWN (compoundN "itsetypistymis" (k1A "kyky")) ; --UNCHK
lin autotrophic_A = mkWA (compoundA "oma" (k38 "varainen")) ; --UNCHK
lin autotype_N = mkWN (k12 "autotypia") ; --UNCHK
lin autotypic_A = mkWA (compoundA "auto" (k38 "tyyppinen")) ; --UNCHK
lin auttoinen_PN = mkPN "Auttoinen" ;
lin autumn_N = mkWN (k1 "syksy") ; --UNCHK
lin autumnal_A = mkWA (k38 "syksyinen") ; --UNCHK
lin auxesis_N = mkWN (k1 "kasvu") ; --UNCHK
lin auxetic_A = mkWA "kasvuun" "liittyvä" ; --UNCHK
lin auxiliary_A = mkWA "täydentävä" ; --UNCHK
lin auxiliary_N = mkWN (k38 "apulainen") ; --UNCHK
lin auxin_N = mkWN "auksiini" ; --UNCHK
lin auxinic_A = mkWA "auksiiniin" "liittyvä" ; --UNCHK
lin avadavat_N = mkWN (compoundN "punatiikeri" (k1A "peippo")) ; --UNCHK
lin avail_N = mkWN (k2 "palvelu") ; --UNCHK
lin avail_V = mkWV (k53A "tuottaa") "etua" ; --UNCHK
lin avail_V2 = mkWV2 (k53A "tuottaa") "etua" ; --UNCHK
lin availability_N = mkWN (k5A "saanti") ; --UNCHK
lin available_A = mkA "saatavillaoleva" | mkA "vapaa" ;
lin avalanche_N = mkWN (k1 "vyöry") ; --UNCHK
lin avaram_N = mkWN (compoundN "auricu" (k9A "lata")) "Cassia" ; --UNCHK
lin avarice_N = mkWN (k40 "kyltymättömyys") ; --UNCHK
lin avaricious_A = mkWA (k1 "perso") ; --UNCHK
lin avascular_A = mkWA "verisuoneton" ; --UNCHK
lin avatar_N = mkWN "avatar" ; --UNCHK
lin aveley_PN = foreignPN "Aveley" ;
lin avellan_A = mkWA (compoundA "pähkinä" (k38 "inen")) ; --UNCHK
lin avenge_V2 = mkWV2 (k53 "kostaa") ; --UNCHK
lin avenger_N = mkWN (k10 "kostaja") ; --UNCHK
lin avens_N = mkWN (k14A "kellukka") ; --UNCHK
lin avenue_N = mkWN (k19 "tie") ; --UNCHK
lin aver_V2 = mkWV2 (k52 "vannoa") ; --UNCHK
lin average_A = mkA "keskimääräinen" ;
lin average_N = mkN "keskiarvo" ;
lin average_V = mkWV (k58 "laskea") "keskiarvo" ; --UNCHK
lin average_V2 = mkWV2 (k58 "laskea") "keskiarvo" ; --UNCHK
lin averageness_N = mkWN (k40 "keskinkertaisuus") ; --UNCHK
lin averse_A = mkWA (k34A "haluton") ; --UNCHK
lin aversion_N = mkWN "pois" "nostaminen" ; --UNCHK
lin aversive_A = mkWA (compoundA "vaste" (k38 "nmielinen")) ; --UNCHK
lin avert_V2 = mkV2 "välttää" partitive ; --mkWV2 (k53 "nostaa") "pois" ;
lin averting_N = mkWN "pois" "nostaminen" ; --UNCHK
lin avian_A = mkWA "lintu-" ; --UNCHK
lin aviary_N = mkWN (compoundN "lintu" (k9 "tarha")) ; --UNCHK
lin aviation_N = mkWN (k2 "ilmailu") ; --UNCHK
lin aviatorFem_N = mkWN (k5A "pilotti") ; --UNCHK
lin aviatorMasc_N = mkWN (k5A "pilotti") ; --UNCHK
lin aviatrix_N = mkWN (compoundN "nais" (k10 "lentäjä")) ; --UNCHK
lin avid_A = mkWA (k38 "intohimoinen") ; --UNCHK
lin avidity_N = mkWN (k40 "kiihkeys") ; --UNCHK
lin avifauna_N = mkWN (k2 "linnusto") ; --UNCHK
lin avifaunal_A = mkWA "linnustoon" "liittyvä" ; --UNCHK
lin avignon_PN = foreignPN "Avignon" ;
lin avionic_A = mkWA "avioniikkaan" "liittyvä" ; --UNCHK
lin avionics_N = mkWN (k9A "avioniikka") ; --UNCHK
lin avirulent_A = mkWA (k34A "myrkytön") ; --UNCHK
lin avitaminosis_N = mkWN (k39 "puutos") "vitamiinin" ; --UNCHK
lin avitaminotic_A = mkWA "vitamiinipuutokseen" "liittyvä" ; --UNCHK
lin avo_N = mkWN (k99 "avo") ; --UNCHK
lin avocado_N = mkWN (k1 "avokado") ; --UNCHK
lin avocation_N = mkWN (k9A "toiminta") "vapaa-ajan" ; --UNCHK
lin avocational_A = mkWA "sivutyöhön" "liittyvä" ; --UNCHK
lin avocet_N = mkWN (k5A "avosetti") ; --UNCHK
lin avoid_V2 = mkWV2 (k53A "välttää") partitive ;
lin avoid_VV = mkVV (mkV "välttää") infElat ;
lin avoidable_A = mkWA (k10 "oleva") "vältettävissä" ; --UNCHK
lin avoidance_N = mkWN (k99 "pois") "kääntyminen" ; --UNCHK
lin avoirdupois_N = mkWN (k5 "läski") ; --UNCHK
lin avon_PN = foreignPN "Avon" ;
lin avouch_V = mkWV (k54A "myöntää") "avoimesti" ; --UNCHK
lin avouch_V2 = mkWV2 (k54A "myöntää") "avoimesti" ; --UNCHK
lin avow_V2 = mkWV2 (k54A "myöntää") "avoimesti" ; --UNCHK
lin avowal_N = mkWN (k39 "tunnustus") ; --UNCHK
lin avowedly_Adv = mkWAdv (k99 "tosiaan") ; --UNCHK
lin avower_N = mkWN (k10 "vahvistaja") ; --UNCHK
lin avulsion_N = mkWN (compoundN "irti" (k38 "repeäminen")) ; --UNCHK
lin avuncular_A = mkWA (k38 "setämäinen") ; --UNCHK
lin await_V2 = mkV2 "varautua" illative ;
lin awake_A = mkWA (k99 "valveilla") ; --UNCHK
lin awake_V = mkWV (k52A "havahtua") ; --UNCHK
lin awaken_V2 = mkWV2 (k52A "havahtua") ; --UNCHK
lin awakening_N = mkWN (k39 "herätys") ; --UNCHK
lin award_N = mkN "palkinto" ;
lin award_V2 = mkV2 "myöntää" ;
lin award_V3 = mkWV3 (k54A "ojentaa") ; --UNCHK
lin aware_A = mkA "tietoinen" ;
lin aware_of_A2 = mkA2 (mkA "tietoinen") (mkPrep elative) ;
lin awareness_N = mkN "tietoisuus" ;
lin away_1_Adv = mkAdv "poissa" ;
lin away_2_Adv = mkAdv "pois" ;
lin away_A = mkWA "vieras-" ; --UNCHK
lin away_Adv = mkAdv "pois" ;
lin awayness_N = mkWN "poissaolevuus" ; --UNCHK
lin awe_N = mkWN (k1A "pelko") "kunnioittava" ; --UNCHK
lin awe_V2 = mkWV2 (k53A "herättää") "kunnioitusta" ; --UNCHK
lin aweary_A = mkWA (k47 "väsynyt") ; --UNCHK
lin aweigh_A = mkWA (k99 "ylhäällä") "ankkuri" ; --UNCHK
lin aweless_A = mkWA (compoundA "epä" (k10 "kunnioittava")) ; --UNCHK
lin awesome_A = mkWA (k10 "vaikuttava") ; --UNCHK
lin awful_A = mkWA (k9 "paha") ; --UNCHK
lin awfulness_N = mkWN (k40 "hirveys") ; --UNCHK
lin awheel_A = mkWA "pyörillä" ; --UNCHK
lin awhile_Adv = mkWAdv (compoundAdv "het" (k101 "ken")) ; --UNCHK
lin awkward_A = mkWA (k2 "kömpelö") ; --UNCHK
lin awkwardness_N = mkWN (k40 "vaivalloisuus") ; --UNCHK
lin awl_N = mkWN (kH1 "naskali") ; --UNCHK
lin awlwort_N = mkWN (compoundN "äimä" (k1 "ruoho")) ; --UNCHK
lin awn_N = mkWN (k48 "vihne") ; --UNCHK
lin awned_A = mkWA (compoundA "vihne" (k38 "ellinen")) ; --UNCHK
lin awning_N = mkWN (k5 "markiisi") ; --UNCHK
lin awninged_A = mkWA "markiisin" "suojaama" ; --UNCHK
lin awnless_A = mkWA "vihneetön" ; --UNCHK
lin awry_A = mkWA (k99 "sekaisin") ; --UNCHK
lin awry_Adv = mkWAdv (k99 "väärin") ; --UNCHK
lin ax_N = mkWN (k41 "kirves") ; --UNCHK
lin ax_V2 = mkWV2 (k54A "vähentää") ; --UNCHK
lin axe_N = mkWN (k41 "kirves") ; --UNCHK
lin axe_V2 = mkWV2 (k54A "vähentää") ; --UNCHK
lin axenic_A = mkWA "mikrobiton" ; --UNCHK
lin axial_A = mkWA (k38 "pitkittäinen") ; --UNCHK
lin axil_N = mkWN (compoundN "hanka" (k10 "kulma")) ; --UNCHK
lin axile_A = mkWA "hanka-" ; --UNCHK
lin axillary_A = mkWA "kainalon" ; --UNCHK
lin axiological_A = mkWA "aksiologinen" ; --UNCHK
lin axiology_N = mkWN (compoundN "arvo" (k12 "filosofia")) ; --UNCHK
lin axiom_N = mkWN (k10 "aksiooma") ; --UNCHK
lin axiomatic_A = mkWA (k38 "aksiomaattinen") ; --UNCHK
lin axis_N = variants {} ; --
lin axle_N = mkWN (k6 "akseli") ; --UNCHK
lin axletree_N = mkWN (k6 "akseli") "pyörän" ; --UNCHK
lin axolemma_N = mkWN "aksolemma" ; --UNCHK
lin axolotl_N = mkWN "Ambystoma" "mexicanum" ; --UNCHK
lin axon_N = mkWN (compoundN "viejä" (k48A "haarake")) ; --UNCHK
lin axonal_A = mkWA (compoundA "aksona" (k38 "alinen")) ; --UNCHK
lin axseed_N = mkWN (compoundN "kirjonivel" (k9 "virna")) ; --UNCHK
lin ayah_N = mkWN (k10 "imettäjä") ; --UNCHK
lin ayapana_N = mkWN "Eupatorium" "ayapana" ; --UNCHK
lin ayatollah_N = mkWN (k5 "ajatollah") ; --UNCHK
lin aye_Interj = variants {} ; --
lin ayin_N = mkWN "ajin" ; --UNCHK
lin aylesbury_PN = foreignPN "Aylesbury" ;
lin aylesford_PN = foreignPN "Aylesford" ;
lin ayr_PN = foreignPN "Ayr" ;
lin azadirachtin_N = mkWN "atsadiraktiini" ; --UNCHK
lin azalea_N = mkWN (k13 "atsalea") ; --UNCHK
lin azathioprine_N = mkWN "Imuran" ; --UNCHK
lin azide_N = mkWN "atsidi" ; --UNCHK
lin azido_A = mkWA "atsidi" ; --UNCHK
lin azimuth_N = mkWN (compoundN "vaakasuunta" (k10 "kulma")) ; --UNCHK
lin azimuthal_A = mkWA (compoundA "atsimuta" (k38 "alinen")) ; --UNCHK
lin azithromycin_N = mkWN "Zithromax" ; --UNCHK
lin azo_A = mkWA "typpi-" ; --UNCHK
lin azoic_A = mkWA (k34A "eloton") ; --UNCHK
lin azonal_A = mkWA (k34A "jakamaton") "vyöhykkeisiin" ; --UNCHK
lin azonic_A = mkWA (k34A "jakamaton") "vyöhykkeisiin" ; --UNCHK
lin azote_N = mkWN (k7A "typpi") ; --UNCHK
lin azotemic_A = mkWA "virtsamyrkytykseen" "liittyvä" ; --UNCHK
lin azotic_A = mkWA "nitraatti-" ; --UNCHK
lin azoturia_N = mkWN "atsoturia" ; --UNCHK
lin aztreonam_N = mkWN "Azactam" ; --UNCHK
lin azure_A = mkWA (k38 "sininen") ; --UNCHK
lin azure_N = mkWN (k38 "sininen") ; --UNCHK
lin azurite_N = mkWN (compoundN "kuparila" (k26 "suuri")) ; --UNCHK
lin azygous_A = mkWA (k38 "yksittäinen") ; --UNCHK
lin azymia_N = mkWN (compoundN "entsyymi" (k39 "puutos")) ; --UNCHK
lin b_ed_N = mkN "kasvatustieteiden" (mkN "kandidaatti") ; ----sanaliitto
lin ba_N = mkWN (k5A "kandidaatti") "humanististen" "tieteiden" ; --UNCHK
lin baa_N = mkWN "mää" ; --UNCHK
lin baa_V = mkWV (k61A "määkiä") ; --UNCHK
lin baas_N = mkWN (k1 "pomo") ; --UNCHK
lin baba_N = mkWN (k1A "kakku") ; --UNCHK
lin babassu_N = mkWN (compoundN "speci" (k10 "osa")) "Orbignya" ; --UNCHK
lin babbitting_N = mkWN (compoundN "vala" (k38 "minen")) "laakerimetallin" ; --UNCHK
lin babble_N = mkWN (compoundN "sian" (k9 "saksa")) ; --UNCHK
lin babble_V = mkWV (k62 "vasikoida") ; --UNCHK
lin babble_V2 = mkWV2 (k62 "vasikoida") ; --UNCHK
lin babe_N = mkWN (k1 "sisko") ; --UNCHK
lin babel_N = mkWN (k9 "sekamelska") ; --UNCHK
lin babelike_A = mkWA (k41A "lapsekas") ; --UNCHK
lin babirusa_N = mkWN (compoundN "hirvi" (k9A "sika")) ; --UNCHK
lin babka_N = mkWN (k9 "baba") ; --UNCHK
lin baboo_N = mkWN (k9 "herra") ; --UNCHK
lin baboon_N = mkWN (k5 "paviaani") ; --UNCHK
lin baboonish_A = mkWA (compoundA "paviaani" (k38 "mainen")) ; --UNCHK
lin babu_N = mkWN (k9 "herra") ; --UNCHK
lin babushka_N = mkWN (compoundN "pää" (k9 "liina")) ; --UNCHK
lin baby_N = L.baby_N ;
lin baby_V2 = mkWV2 (k61 "helliä") ; --UNCHK
lin baby_farmer_N = mkWN (k10 "pitäjä") "lastentarhan" ; --UNCHK
lin baby_minder_N = mkWN (k12 "kaitsija") ; --UNCHK
lin baby_talk_N = mkWN (compoundN "vauvan" (k26 "kieli")) ; --UNCHK
lin babyhood_N = mkWN (compoundN "vauva" (k10A "ikä")) ; --UNCHK
lin babyish_A = mkWA (k38 "lapsellinen") ; --UNCHK
lin babysitter_N = mkWN (compoundN "lapsen" (k12 "kaitsija")) ; --UNCHK
lin babysitting_N = mkWN "lastenvahtiminen" ; --UNCHK
lin baccalaureate_N = mkWN (k1A "tutkinto") "kandidaatin" ; --UNCHK
lin baccate_A = mkWA (compoundA "marja" (k38 "mainen")) ; --UNCHK
lin bacchanal_A = mkWA (k38 "hekumallinen") ; --UNCHK
lin bacchanalian_A = mkWA (k38 "hekumallinen") ; --UNCHK
lin bacchant_N = mkWN (compoundN "bak" (k5A "kantti")) ; --UNCHK
lin bacchante_N = mkWN (k32A "papitar") "Bacchuksen" ; --UNCHK
lin bacchantic_A = mkWA (compoundA "bakk" (k38 "anaalinen")) ; --UNCHK
lin baccivorous_A = mkWA "marjoja" "syövä" ; --UNCHK
lin baccy_N = mkWN (k14A "tupakka") ; --UNCHK
lin bachelor_N = mkWN (k51 "vanhapoika") ; --UNCHK
lin bachelorhood_N = mkWN (k1 "olo") "poikamiehenä" ; --UNCHK
lin bacillar_A = mkWA "basilli-" ; --UNCHK
lin bacillus_N = mkWN (k6 "basilli") ; --UNCHK
lin bacitracin_N = mkWN (k5A "antibiootti") ; --UNCHK
lin back_A = mkA (mkN "taaempi" "taaemman" "taaempia") ;
lin back_Adv = mkAdv "takaisin" ;
lin back_N = L.back_N ;
lin back_V = mkWV (k52A "perääntyä") ;
lin back_away_V = mkWV (k53A "peruuttaa") ; --UNCHK
lin back_down_V = mkWV (k52A "luopua") ; --UNCHK
lin back_into_V3 = variants {} ; -- guess-p-verb
lin back_off_V = mkWV (k52A "luopua") ; --UNCHK
lin back_out_V = mkWV (k53A "peruuttaa") ; --UNCHK
lin back_out_of_V2 = prepV2 (advV OP_back_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin back_out_of_V3 = variants {} ; -- guess-p-verb
lin back_to_Prep = mkPrep "takaisin" elative ;
lin back_up_V = mkV "varmistaa" ;
lin back_up_1_V2 = mkV2 "varmistaa" ;
lin back_up_2_V2 = mkV2 "varmistaa" ;
lin backache_N = mkWN (compoundN "selkä" (k1A "kipu")) ; --UNCHK
lin backbeat_N = mkWN (k1 "takapotku") ; --UNCHK
lin backbench_N = mkWN (k9A "paikka") "riviparlamentaarikon" ; --UNCHK
lin backbencher_N = mkWN (compoundN "rivi" (k4A "parlamentaarikko")) ; --UNCHK
lin backbend_N = mkWN (k9A "silta") ; --UNCHK
lin backbite_V = mkWV (k53A "valittaa") ; --UNCHK
lin backbite_V2 = mkWV2 (k53A "valittaa") ; --UNCHK
lin backbiter_N = mkWN (k10 "parjaaja") ; --UNCHK
lin backblast_N = mkWN (compoundN "vasta" (k10 "voima")) ; --UNCHK
lin backboard_N = mkWN (compoundN "perä" (k9A "lauta")) ; --UNCHK
lin backbone_N = mkWN (compoundN "runko" (k1A "verkko")) ; --UNCHK
lin backchat_N = mkWN (k2 "pilailu") ; --UNCHK
lin backcloth_N = mkWN (k9 "tausta") ; --UNCHK
lin backdoor_N = mkWN (k99 "kautta") "takaoven" ; --UNCHK
lin backdrop_N = mkWN (k9 "tausta") ;
lin backerFem_N = mkWN (k10 "kannattaja") ; --UNCHK
lin backerMasc_N = mkWN (k10 "kannattaja") ; --UNCHK
lin backfield_N = mkWN (compoundN "taka" (k10A "kenttä")) ; --UNCHK
lin backfire_N = mkWN (compoundN "taka" (k1 "isku")) ; --UNCHK
lin backfire_V = mkV "kostautua" ; --mkWV (k53A "sytyttää") "vastatuli" ;
lin backflow_N = mkWN (compoundN "takaisin" (k39 "virtaus")) ; --UNCHK
lin backgammon_N = mkWN (k6 "backgammon") ; --UNCHK
lin background_N = mkWN (k9 "tausta") ;
lin backgrounder_N = mkWN (k39 "taustoitus") ; --UNCHK
lin backhand_A = mkWA "rysty-" ; --UNCHK
lin backhand_N = mkWN (compoundN "rysty" (k5A "lyönti")) ; --UNCHK
lin backhanded_A = mkWA "rysty-" ; --UNCHK
lin backhander_N = mkWN (k5A "lyönti") "kämmenselällä" "sivallettu" ; --UNCHK
lin backhoe_N = mkWN (compoundN "kaivin" (k48 "kone")) ; --UNCHK
lin backing_N = mkWN (k39 "kannatus") ; --UNCHK
lin backlash_N = mkWN (k39 "vastustus") ; --UNCHK
lin backless_A = mkWA "selkänojaton" ; --UNCHK
lin backlighting_N = mkWN (compoundN "tausta" (k39 "valaistus")) ; --UNCHK
lin backlog_N = mkWN (k10 "suma") ; --UNCHK
lin backmost_A = mkWA (k38 "viimeinen") ; --UNCHK
lin backpack_N = mkWN (k9A "rinkka") ; --UNCHK
lin backpacker_N = mkWN (k10 "vaeltaja") ; --UNCHK
lin backpedal_V = mkWV (k52A "perääntyä") "jstak" ; --UNCHK
lin backplate_N = mkWN (compoundN "selkä" (k6 "panssari")) ; --UNCHK
lin backroom_N = mkWN (compoundN "taka" (k48 "huone")) ; --UNCHK
lin backsaw_N = mkWN (compoundN "selkä" (k9 "saha")) ; --UNCHK
lin backscratcher_N = mkWN (compoundN "selän" (k33A "raaputin")) ; --UNCHK
lin backseat_N = mkWN (compoundN "taka" (k5A "penkki")) ; --UNCHK
lin backsheesh_N = mkWN (k5A "tippi") ; --UNCHK
lin backside_N = mkWN (k1 "takalisto") ; --UNCHK
lin backslapper_N = mkWN (k10 "kannustaja") ; --UNCHK
lin backslide_V = mkWV (k52 "lipsua") "periaatteistaan" ; --UNCHK
lin backsliding_N = mkWN (k99 "uudelleen") "sortuminen" ; --UNCHK
lin backspace_V = mkWV (k53A "peruuttaa") ; --UNCHK
lin backspin_N = mkWN (compoundN "taka" (k48A "kierre")) ; --UNCHK
lin backstage_Adv = mkWAdv (k99 "takana") "näyttämön" ; --UNCHK
lin backstair_A = mkWA (k38 "vaivihkainen") ; --UNCHK
lin backstay_N = mkWN (k7A "tuki") ; --UNCHK
lin backstitch_N = mkWN (compoundN "taka" (k1 "pisto")) ; --UNCHK
lin backstop_N = mkWN (k48 "vaste") ; --UNCHK
lin backstroke_N = mkWN (compoundN "selkä" (k5A "uinti")) ; --UNCHK
lin backstroker_N = mkWN (compoundN "selkä" (k10 "uija")) ; --UNCHK
lin backswimmer_N = mkWN (compoundN "undu" (k9A "lata")) "Notonecta" ; --UNCHK
lin backsword_N = mkWN (k9A "miekka") ; --UNCHK
lin backtalk_N = mkWN (k9A "suunpieksentä") ; --UNCHK
lin back_up_N = mkWN (k39 "kannatus") ; --UNCHK
lin backward_A = mkWA (compoundA "taa" (k38 "ksepäinen")) ; --UNCHK
lin backward_Adv = mkWAdv (k99 "taakse") ; --UNCHK
lin backwards_Adv = mkWAdv (k99 "taemmaksi") ; --UNCHK
lin backwash_N = mkWN (compoundN "vana" (k27 "vesi")) ; --UNCHK
lin backwater_N = mkWN (k12 "takapajula") ; --UNCHK
lin backwoods_N = mkWN (k8 "lande") ; --UNCHK
lin backwoodsman_N = mkWN (k42 "mies") "takametsien" ; --UNCHK
lin backworth_PN = foreignPN "Backworth" ;
lin backyard_N = mkWN (compoundN "taka" (k9 "piha")) ; --UNCHK
lin bacon_N = mkWN (k6 "pekoni") ; --UNCHK
lin bacteremia_N = mkWN "bakteremia" ; --UNCHK
lin bacteremic_A = mkWA "baktereeminen" ; --UNCHK
lin bacteria_N = mkWN (k6 "bakteeri") ; --UNCHK
lin bacterial_A = mkWA "bakteeri-" ; --UNCHK
lin bactericidal_A = mkWA (compoundA "desinfi" (k10 "oiva")) ; --UNCHK
lin bactericide_N = mkWN (k5A "antibiootti") ; --UNCHK
lin bacteriochlorophyll_N = mkWN (compoundN "bakteeri" (k5 "klorofylli")) ; --UNCHK
lin bacteriological_A = mkWA (k38 "bakteriologinen") ; --UNCHK
lin bacteriologist_N = mkWN "bakteriologi" ; --UNCHK
lin bacteriology_N = mkWN (k12 "bakteriologia") ; --UNCHK
lin bacteriolysis_N = mkWN (compoundN "bakterioly" (k5 "ysi")) ; --UNCHK
lin bacteriolytic_A = mkWA "bakteriolyyttinen" ; --UNCHK
lin bacteriophage_N = mkWN "fagi" ; --UNCHK
lin bacteriophagic_A = mkWA "bakteriofaginen" ; --UNCHK
lin bacteriostat_N = mkWN "bakteriostaatti" ; --UNCHK
lin bacteriostatic_A = mkWA (compoundA "bakterio" (k38 "staattinen")) ; --UNCHK
lin bacterium_N = mkWN (k6 "bakteeri") ;
lin bacteroid_N = mkWN "bakteroidi" ; --UNCHK
lin bacteroidal_A = mkWA (compoundA "muis" (k10 "tuttava")) "bakteeria" ; --UNCHK
lin bacup_PN = foreignPN "Bacup" ;
lin bad_A = L.bad_A ;
lin bad_N = mkWN (k40 "pahuus") ; --UNCHK
lin badajoz_PN = foreignPN "Badajoz" ;
lin badalona_PN = foreignPN "Badalona" ;
lin baddeleyite_N = mkWN "baddeleyiitti" ; --UNCHK
lin badge_N = mkWN (k39 "tunnus") ; --UNCHK
lin badger_N = mkWN (k10 "mäyrä") ; --UNCHK
lin badger_V2 = mkWV2 (k67A "maanitella") ; --UNCHK
lin badgering_N = mkWN (k9 "piina") ; --UNCHK
lin badlands_N = mkWN "Badlands" ; --UNCHK
lin badminton_N = mkWN (compoundN "sulka" (k1 "pallo")) ; --UNCHK
lin badness_N = mkWN (k40 "tottelemattomuus") ; --UNCHK
lin baedeker_N = mkWN (compoundN "opas" (k9 "kirja")) ; --UNCHK
lin baffle_N = mkWN (kH1 "läppä") ; --UNCHK
lin baffle_V2 = mkWV2 (k53A "säätää") "äänenpainetta" ; --UNCHK
lin baffled_N = mkWN (k99 "ymmällä") ; --UNCHK
lin baffling_A = mkWA (k10 "hankala") ; --UNCHK
lin bag_N = mkWN (k1A "juttu") ; --UNCHK
lin bag_V = mkWV (k63 "saada") ; --UNCHK
lin bag_V2 = mkWV2 (k63 "saada") ; --UNCHK
lin bagasse_N = mkWN (compoundN "sokeriruoko" (k48A "jäte")) ; --UNCHK
lin bagassosis_N = mkWN (compoundN "bagas" (k5 "soosi")) ; --UNCHK
lin bagatelle_N = mkWN (k12 "fortuna") ; --UNCHK
lin bagel_N = mkWN (k6 "rinkeli") ; --UNCHK
lin baggage_N = mkN "painolasti" ; ---ARB ; matkatavarat
lin baggageman_N = mkWN (compoundN "matkatavara" (k12 "palvelija")) ; --UNCHK
lin bagger_N = mkWN (compoundN "pakkaus" (k48 "kone")) ; --UNCHK
lin baggy_A = mkWA (k10 "väljä") ; --UNCHK
lin baghdad_PN = foreignPN "Bagdad" ;
lin bagman_N = mkWN (k38 "rikollinen") ; --UNCHK
lin bagnio_N = mkWN (k12 "kylpylä") ; --UNCHK
lin bagpipe_N = mkWN (compoundN "säkki" (k5 "pilli")) ; --UNCHK
lin baguet_N = mkWN (k5A "patonki") ; --UNCHK
lin bahamas_PN = foreignPN "Bahama" ;
lin bahamian_A = mkWA (compoundA "baham" (k38 "alainen")) ; --UNCHK
lin bahamian_N = mkWN (compoundN "baham" (k38 "alainen")) ; --UNCHK
lin bahasa_N = mkWN "Bahasa" ; --UNCHK
lin bahrain_PN = foreignPN "Bahrain" ;
lin bahraini_A = mkWA (compoundA "bahraini" (k38 "lainen")) ; --UNCHK
lin bahraini_N = mkWN (compoundN "bahraini" (k38 "lainen")) ; --UNCHK
lin baht_N = mkWN "tical" ; --UNCHK
lin bail_N = mkWN (k17 "takuu") ; --UNCHK
lin bail_V = mkV (mkV "vapautua") "takuita vastaan" ; --mkWV (k62 "äyskäröidä") ;
lin bail_V2 = mkWV2 (k62 "äyskäröidä") ; --UNCHK
lin bail_out_V = mkWV (k62 "äyskäröidä") ; --UNCHK
lin bail_out_V2 = mkWV2 (k62 "äyskäröidä") ; --UNCHK
lin bailable_A = mkWA (k99 "vastaan") "takuuta" ; --UNCHK
lin bailee_N = mkWN (compoundN "vastaan" (k10 "ottaja")) "uskotun" "tavaran" ; --UNCHK
lin bailey_N = mkWN (compoundN "ulko" (k5 "muuri")) ; --UNCHK
lin bailiff_N = mkWN (compoundN "oikeuden" (k12 "palvelija")) ; --UNCHK
lin bailiffship_N = mkWN (k9A "virka") "oikeudenpalvelijan" ; --UNCHK
lin bailiwick_N = mkWN (k48 "aine") ; --UNCHK
lin bailment_N = mkWN "takauksen" "antaminen" ; --UNCHK
lin bailor_N = mkWN (k10 "tallettaja") ; --UNCHK
lin bairn_N = mkWN (k29 "lapsi") ; --UNCHK
lin bait_N = mkWN (k33A "houkutin") ; --UNCHK
lin bait_V = mkWV (k53A "ärsyttää") ; --UNCHK
lin bait_V2 = mkWV2 (k53A "ärsyttää") ; --UNCHK
lin baiting_N = mkWN "rääkkääminen" ; --UNCHK
lin baiza_N = mkWN "baisa" ; --UNCHK
lin baize_N = mkWN "boiji" ; --UNCHK
lin bake_V = mkWV (k56 "paistaa") ; --UNCHK
lin bake_V2 = mkWV2 (k56 "paistaa") ; --UNCHK
lin bakelite_N = mkWN (compoundN "bak" (k5A "eliitti")) ; --UNCHK
lin baker_N = mkWN (k6 "paakari") ; --UNCHK
lin bakery_N = mkWN (k2 "leipomo") ; --UNCHK
lin baking_N = mkWN (k9A "leivonta") ; --UNCHK
lin baking_hot_A = mkWA (compoundA "tuli" (k10 "kuuma")) ; --UNCHK
lin baking_powder_N = mkWN (compoundN "leivin" (k48 "jauhe")) ; --UNCHK
lin baklava_N = mkWN (compoundN "bak" (k9 "lava")) ; --UNCHK
lin baksheesh_N = mkWN (k5A "tippi") ; --UNCHK
lin baku_PN = foreignPN "Baku" ;
lin balaclava_N = mkWN (compoundN "villa" (k10 "kypärä")) ; --UNCHK
lin balagan_N = mkWN (k39 "kaaos") ; --UNCHK
lin balalaika_N = mkWN (k9A "balalaikka") ; --UNCHK
lin balance_N = mkN "tasapaino" | mkN "balanssi" ;
lin balance_V = mkWV (k53A "pitää") "tasapainossa" ; --UNCHK
lin balance_V2 = mkV2 "tasapainottaa" partitive ; --mkWV2 (k53A "pitää") "tasapainossa" ;
lin balance_sheet_N = mkWN (k48 "tase") ; --UNCHK
lin balance_wheel_N = mkWN (k33A "liipotin") "taskukellon" ; --UNCHK
lin balanced_A = variants {} ; --
lin balanitis_N = mkWN (k39 "tulehdus") "terskan" ; --UNCHK
lin balas_N = mkWN "spinelli" ; --UNCHK
lin balata_N = mkWN "Manilkara" "bidentata" ; --UNCHK
lin balbriggan_N = mkWN (k39 "neulos") "sileä" ; --UNCHK
lin balconied_A = mkWA (compoundA "par" (k38 "vekkeellinen")) ; --UNCHK
lin balcony_N = mkWN (k48A "parveke") ; --UNCHK
lin bald_A = mkWA (k1 "kalju") ; --UNCHK
lin baldachin_N = mkWN (k39 "katos") ; --UNCHK
lin balderdash_N = mkWN (k99 "soopa") ; --UNCHK
lin bald_head_N = mkWN (k50 "kaljupää") ; --UNCHK
lin balding_A = mkWA (compoundA "kalju" (k10 "untuva")) ; --UNCHK
lin baldness_N = mkWN (k40 "kaljuus") ; --UNCHK
lin baldock_PN = foreignPN "Baldock" ;
lin baldric_N = mkWN (compoundN "miekka" (k19 "vyö")) ; --UNCHK
lin bale_N = mkWN (k5 "paali") ; --UNCHK
lin bale_V2 = mkWV2 (k53A "paalittaa") ; --UNCHK
lin baleful_A = mkWA (k10 "uhkaava") ; --UNCHK
lin balk_N = mkWN (compoundN "teko" (k1A "syöttö")) ; --UNCHK
lin balk_V = mkWV (k71 "tehdä") "tenä" ; --UNCHK
lin balk_V2 = mkWV2 (k71 "tehdä") "tenä" ; --UNCHK
lin balker_N = mkWN (k38 "ihminen") "tottelematon" ; --UNCHK
lin balkiness_N = mkWN (compoundN "vastus" (k38 "taminen")) ; --UNCHK
lin balkline_N = mkWN (k9 "viiva") ; --UNCHK
lin ball_N = mkN "pallo" ;
lin ball_V = mkWV (k61 "kääriä") "kerälle" ; --UNCHK
lin ball_V2 = mkWV2 (k61 "kääriä") "kerälle" ; --UNCHK
lin ball_cartridge_N = mkWN (kH1 "patruuna") "terävä" ; --UNCHK
lin ball_up_V2 = mkWV2 (k71 "tehdä") "virhe" ; --UNCHK
lin ballad_N = mkWN (k5 "balladi") ; --UNCHK
lin ballade_N = mkWN (k5 "balladi") ; --UNCHK
lin ballast_N = mkWN (compoundN "pohja" (k5 "lasti")) ; --UNCHK
lin ballast_V2 = mkWV2 (k53 "varustaa") "painolastilla" ; --UNCHK
lin ballcock_N = mkWN (compoundN "kuulauimur" (k10 "ihana")) ; --UNCHK
lin ball_dress_N = mkWN (compoundN "ilta" (k1A "puku")) ; --UNCHK
lin ballerina_N = mkWN (k9 "ballerina") ; --UNCHK
lin ballet_N = mkWN (k5A "baletti") ; --UNCHK
lin ballet_dancer_N = mkWN (compoundN "baletti" (k12 "tanssija")) ; --UNCHK
lin ballet_skirt_N = mkWN (compoundN "baletti" (k48 "hame")) ; --UNCHK
lin balletic_A = mkWA (k10 "sulava") ; --UNCHK
lin balletomane_N = mkWN (compoundN "baletti" (k5 "fani")) ; --UNCHK
lin balletomania_N = mkWN (compoundN "balleto" (k12 "mania")) ; --UNCHK
lin ballgame_N = mkWN (compoundN "pallo" (k5 "peli")) ; --UNCHK
lin ballistic_A = mkWA (k38 "ballistinen") ; --UNCHK
lin ballistics_N = mkWN (k9A "ballistiikka") ; --UNCHK
lin ballistocardiogram_N = mkWN "ballistokardiogrammi" ; --UNCHK
lin ballistocardiograph_N = mkWN "kardiografi" ; --UNCHK
lin ballock_N = mkWN (k39 "kives") ; --UNCHK
lin balloon_N = mkWN (k50 "kuumailmapallo") ; --UNCHK
lin balloon_V = mkWV (k52A "täyttyä") ; --UNCHK
lin balloon_V2 = mkWV2 (k52A "täyttyä") ; --UNCHK
lin ballooning_N = mkWN (compoundN "ilmapallo" (k39 "purjehdus")) ; --UNCHK
lin balloonist_N = mkWN (k10 "lentäjä") "kuumailmapallon" ; --UNCHK
lin ballot_N = mkWN (k26 "ääni") ; --UNCHK
lin ballot_V = mkWV (k53 "äänestää") ; --UNCHK
lin ballot_box_N = mkWN (compoundN "vaali" (k10 "uurna")) ; --UNCHK
lin ballottement_N = mkWN (compoundN "pallo" (k38 "aminen")) ; --UNCHK
lin ballpark_N = mkWN (k10A "kenttä") ; --UNCHK
lin ballpen_N = mkWN (compoundN "kuula" (k10 "kynä")) ; --UNCHK
lin ballplayer_N = mkWN (k10 "pelaaja") "baseballin" ; --UNCHK
lin ballpoint_N = mkWN (compoundN "kuula" (k10 "kynä")) ; --UNCHK
lin ballpoint_pen_N = mkWN (compoundN "kuula" (k10 "kynä")) ; --UNCHK
lin ballroom_N = mkWN (compoundN "tanssi" (k9 "lava")) ; --UNCHK
lin ballup_N = mkWN (k1 "sotku") ; --UNCHK
lin bally_A = variants {} ;
lin bally_Adv = adjAdv bally_A ; -- derived
lin ballyhoo_N = mkWN (k39 "mainos") ; --UNCHK
lin balm_N = mkWN (k9 "salva") ; --UNCHK
lin balminess_N = mkWN (k40 "lempeys") ; --UNCHK
lin balmoral_N = mkWN (k1A "hattu") "sininen" ; --UNCHK
lin balmy_A = mkWA (k10 "leppoisa") ; --UNCHK
lin baloney_N = mkWN (k5 "humpuuki") ; --UNCHK
lin balsa_N = mkWN (k9 "balsa") ; --UNCHK
lin balsam_N = mkWN (k5 "palsami") ; --UNCHK
lin balsamic_A = mkWA "palsamin" ; --UNCHK
lin balsamroot_N = mkWN (k26 "palsamijuuri") ; --UNCHK
lin baltic_sea_PN = mkPN (mkN "Itämeri" "Itämeren" "Itämeriä" "Itämerta") ;
lin baltimore_PN = foreignPN "Baltimore" ;
lin baluster_N = mkWN (kH1 "puola") ; --UNCHK
lin balustrade_N = mkWN (k48A "kaide") ; --UNCHK
lin bambino_N = mkWN (k2 "napero") ; --UNCHK
lin bamboo_N = mkWN (k1 "bambu") ; --UNCHK
lin bamboozle_V2 = mkWV2 (k73 "puliveivata") ; --UNCHK
lin ban_N = mkWN (k1A "kielto") ; --f52
lin ban_V2 = mkWV2 (k54A "kieltää") ; --f58
lin banal_A = mkWA (k38 "tavallinen") ; --UNCHK
lin banality_N = mkWN (k5A "trivialiteetti") ; --UNCHK
lin banana_N = mkWN (k6 "banaani") ; --UNCHK
lin banausic_A = mkWA (k38 "materialistinen") ; --UNCHK
lin banbury_PN = foreignPN "Banbury" ;
lin band_N = mkWN (k9A "panta") ;
lin band_V = mkWV (k53 "rengastaa") ; --UNCHK
lin band_V2 = mkWV2 (k53 "rengastaa") ; --UNCHK
lin band_saw_N = mkWN (compoundN "vanne" (k9 "saha")) ; --UNCHK
lin bandage_N = mkWN (k6 "laastari") ; --UNCHK
lin bandage_V2 = mkWV2 (k62 "laastaroida") ; --UNCHK
lin bandanna_N = mkWN (k9 "liina") ; --UNCHK
lin bandbox_N = mkWN (compoundN "hattu" (k12 "rasia")) ; --UNCHK
lin banderilla_N = mkWN "banderilla" ; --UNCHK
lin banderillero_N = mkWN (k12 "iskijä") "banderillan" ; --UNCHK
lin bandicoot_N = mkWN (compoundN "pussi" (k10 "mäyrä")) ; --UNCHK
lin bandit_N = mkWN (k5A "bandiitti") ; --UNCHK
lin banditry_N = mkWN (k39 "rosvous") ; --UNCHK
lin bandleader_N = mkWN (k10 "johtaja") "yhtyeen" ; --UNCHK
lin bandmaster_N = mkWN (compoundN "kapelli" (k6 "mestari")) ; --UNCHK
lin bandoleer_N = mkWN (compoundN "patruuna" (k19 "vyö")) ; --UNCHK
lin bandolier_N = mkWN (compoundN "patruuna" (k19 "vyö")) ; --UNCHK
lin bandoneon_N = mkWN "Bandoneón" ; --UNCHK
lin bandsman_N = mkWN (k10 "soittaja") ; --UNCHK
lin bandstand_N = mkWN (k9 "lava") ; --UNCHK
lin bandung_PN = foreignPN "Bandung" ;
lin bandwagon_N = mkWN (compoundN "paraati" (k1 "vaunu")) ; --UNCHK
lin bandwidth_N = mkWN (k9 "kaista") ; --UNCHK
lin bandy_A = mkWA (compoundA "väärä" (k38 "säärinen")) ; --UNCHK
lin bandy_V2 = mkWV2 (k61A "pohtia") ; --UNCHK
lin bane_N = mkWN (k40 "vaikeus") ; --UNCHK
lin baneberry_N = mkWN (compoundN "konnan" (k9 "marja")) ; --UNCHK
lin baneful_A = mkWA (k41A "kohtalokas") ; --UNCHK
lin bang_Adv = mkWAdv (k99 "päistikkaa") ; --UNCHK
lin bang_N = mkN "isku" ; --mkWN (k39 "menestys") ;
lin bang_V = mkWV (k53A "paukahtaa") ; --UNCHK
lin bang_V2 = mkWV2 (k53A "paukahtaa") ; --UNCHK
lin bang_out_V2 = mkWV2 (k53A "pimputtaa") ; --UNCHK
lin bang_up_V2 = mkWV2 (k53A "siittää") ; --UNCHK
lin bangalore_PN = foreignPN "Bangalore" ;
lin banger_N = mkWN (k38 "sähikäinen") ; --UNCHK
lin banging_N = mkWN (compoundN "pahoin" (k2 "pitely")) ; --UNCHK
lin bangkok_PN = foreignPN "Bangkok" ;
lin bangladesh_PN = foreignPN "Bangladesh" ;
lin bangladeshi_A = mkWA (compoundA "bangladeshi" (k38 "lainen")) ; --UNCHK
lin bangladeshi_N = mkWN (compoundN "bangladeshi" (k38 "lainen")) ; --UNCHK
lin bangle_N = mkWN (k1 "koru") ; --UNCHK
lin bangor_PN = foreignPN "Bangor" ;
lin banian_N = mkWN "banian" ; --UNCHK
lin banian_tree_N = mkWN (compoundN "banian" (k12 "viikuna")) ; --UNCHK
lin banish_V2 = mkWV2 (k56 "ajaa") "tiehensä" ; --UNCHK
lin banishment_N = mkWN (k3 "tuomio") ; --UNCHK
lin banister_N = mkWN (k48A "kaide") ; --UNCHK
lin banjo_N = mkWN (k1 "banjo") ; --UNCHK
lin bank_1_N = mkN (lin NK {s = d09A "penkka"}) ;
lin bank_2_N = L.bank_N ;
lin bank_V = mkWV (k53A "luottaa") ; --UNCHK
lin bank_V2 = mkWV2 (k53A "luottaa") ; --UNCHK
lin bank_bill_N = mkWN (k6 "seteli") "dollarin" ; --UNCHK
lin bank_draft_N = mkWN (compoundN "pankki" (k6 "vekseli")) ; --UNCHK
lin bank_rate_N = mkWN (compoundN "korko" (k9A "kanta")) ; --UNCHK
lin bankable_A = mkWA (compoundA "pankki" (k38 "kelpoinen")) ; --UNCHK
lin bank_book_N = mkWN (compoundN "pankki" (k9 "kirja")) ; --UNCHK
lin banker_N = mkWN (k6 "pankkiiri") ;
lin banking_N = mkN "pankkitoiminta" ;
lin banknote_N = mkWN (k6 "seteli") "dollarin" ; --UNCHK
lin bankroll_N = mkWN (compoundN "seteli" (k1A "nippu")) ; --UNCHK
lin bankrupt_A = mkA (mkN "konkurssi" (mkN "kypsä")) ;
lin bankrupt_N = mkWN (compoundN "tyrsky" (k10 "kahlaaja")) ; --UNCHK
lin bankrupt_V2 = mkWV2 (k57A "kaataa") ; --UNCHK
lin bankruptcy_N = mkWN (k5 "konkurssi") ;
lin banksia_N = mkWN (k10 "kuusama") ; --UNCHK
lin banner_A = mkWA (k38 "oivallinen") ; --UNCHK
lin banner_N = mkWN (k5 "viiri") ; --UNCHK
lin bannerlike_Adv = mkWAdv "lippumaisesti" ; --UNCHK
lin bannister_N = mkWN (k48A "kaide") ; --UNCHK
lin bannock_N = mkWN (k10A "leipä") ; --UNCHK
lin bannockburn_PN = foreignPN "Bannockburn" ;
lin banns_N = mkWN (compoundN "avioliitto" (k39 "kuulutus")) ; --UNCHK
lin banquet_N = mkN "juhla" ;
lin banquet_V = mkWV (k52 "osallistua") "juhliin" ; --UNCHK
lin banquet_V2 = mkWV2 (k52 "osallistua") "juhliin" ; --UNCHK
lin banquette_N = mkWN (k5A "penkki") ; --UNCHK
lin banshee_N = mkWN "banshee" ; --UNCHK
lin bantam_A = mkWA (k10 "sorja") ; --UNCHK
lin bantam_N = mkWN (compoundN "kääpiö" (k9 "kana")) ; --UNCHK
lin bantamweight_N = mkWN (compoundN "kääpiösarja" (k38 "lainen")) ; --UNCHK
lin banteng_N = mkWN (compoundN "balin" (k9A "nauta")) ; --UNCHK
lin banter_N = mkWN (k2 "pilailu") ; --UNCHK
lin banter_V = mkWV (k67 "pilailla") ; --UNCHK
lin banter_V2 = mkWV2 (k67 "pilailla") ; --UNCHK
lin banteringly_Adv = mkWAdv "leikkimielisesti" ; --UNCHK
lin banting_N = mkWN (compoundN "balin" (k9A "nauta")) ; --UNCHK
lin bantry_PN = foreignPN "Bantry" ;
lin bantu_A = mkWA "bantu-" ; --UNCHK
lin bantu_N = mkWN (k1 "bantu") ; --UNCHK
lin banyan_N = mkWN "banian" ; --UNCHK
lin banzai_N = mkWN "banzai" ; --UNCHK
lin baobab_N = mkWN "apinanleipäpuu" ; --UNCHK
lin bap_N = mkWN (k12 "sämpylä") ; --UNCHK
lin baptism_N = mkWN (k48 "kaste") ; --UNCHK
lin baptismal_A = mkWA "kaste-" ; --UNCHK
lin baptist_N = mkWN (k5 "baptisti") ; --UNCHK
lin baptize_V2 = mkWV2 (k61 "ristiä") ; --UNCHK
lin bar_1_N = mkN "baari" ;
lin bar_2_N = mkN "tanko" ;
lin bar_N = mkN "baari" ;
lin bar_V2 = mkWV2 (k58A "sulkea") "pois" ;
lin barb_N = mkN (lin NK {s = d05A "piikki"}) ;
lin barbadian_A = mkWA (compoundA "barbados" (k38 "lainen")) ; --UNCHK
lin barbadian_N = mkWN (compoundN "barbados" (k38 "lainen")) ; --UNCHK
lin barbados_PN = foreignPN "Barbados" ;
lin barbara_PN = foreignPN "Barbara" ;
lin barbarian_A = mkWA (k5 "villi") ; --UNCHK
lin barbarian_N = mkWN (k38 "raakalainen") ; --UNCHK
lin barbaric_A = mkWA (k5 "villi") ; --UNCHK
lin barbarism_N = mkWN (k40 "brutaalius") ; --UNCHK
lin barbarity_N = mkWN (k40 "brutaalius") ; --UNCHK
lin barbarization_N = mkWN (compoundN "raaka" (k38 "laistuminen")) ; --UNCHK
lin barbarize_V2 = mkWV2 (k71 "tehdä") "raaemmaksi" ; --UNCHK
lin barbarous_A = mkWA (k34A "sivistymätön") ; --UNCHK
lin barbasco_N = mkWN "Jacquinia" "keyensis" ; --UNCHK
lin barbecue_N = mkWN (k12 "parila") ; --UNCHK
lin barbecue_V2 = mkWV2 (k62 "pariloida") ; --UNCHK
lin barbecuing_N = mkWN "grillaaminen" ; --UNCHK
lin barbed_A = mkWA (k38 "piikkinen") ; --UNCHK
lin barbel_N = mkWN (compoundN "tunto" (k7 "sarvi")) ; --UNCHK
lin barbell_N = mkWN (compoundN "levy" (k1A "tanko")) ; --UNCHK
lin barber_N = mkWN (k6 "parturi") ; --UNCHK
lin barberry_N = mkWN (compoundN "happo" (k9 "marja")) ; --UNCHK
lin barbershop_N = mkWN (k6 "parturi") ; --UNCHK
lin barbet_N = mkWN (compoundN "turkoosi" (k10A "seppä")) ; --UNCHK
lin barbette_N = mkWN (compoundN "tykki" (k49A "penger")) ; --UNCHK
lin barbican_N = mkWN (compoundN "vartio" (k5 "torni")) ; --UNCHK
lin barbital_N = mkWN (compoundN "vero" (k5 "naali")) ; --UNCHK
lin barbitone_N = mkWN (compoundN "vero" (k5 "naali")) ; --UNCHK
lin barbiturate_N = mkWN (k5A "barbituraatti") ; --UNCHK
lin barbu_N = mkWN (k9 "kala") ; --UNCHK
lin barcarole_N = mkWN "barkaroli" ; --UNCHK
lin barcarolle_N = mkWN "barkaroli" ; --UNCHK
lin barcelona_PN = foreignPN "Barcelona" ;
lin bard_N = mkWN (k25 "loimi") ; --UNCHK
lin bardic_A = mkWA (compoundA "bardi" (k38 "nen")) ; --UNCHK
lin bardolatry_N = mkWN (k9A "palvonta") "William" "Shakespearen" ; --UNCHK
lin bare_A = mkA "paljas" ;
lin bare_V2 = mkWV2 (k52A "koaguloitua") ; --UNCHK
lin bareback_A = mkWA (k10 "oleva") "satulatta" ; --UNCHK
lin bareback_Adv = mkWAdv (compoundAdv "satu" (k9A "latta")) ; --UNCHK
lin barebacked_A = mkWA (k10 "oleva") "satulatta" ; --UNCHK
lin barebacked_Adv = mkWAdv (compoundAdv "satu" (k9A "latta")) ; --UNCHK
lin barefaced_A = mkWA (k15 "röyhkeä") ; --UNCHK
lin barefoot_A = mkWA (compoundA "paljas" (k38 "jalkainen")) ; --UNCHK
lin barefoot_Adv = mkWAdv (k99 "avojaloin") ; --UNCHK
lin barefooted_A = mkWA (compoundA "paljas" (k38 "jalkainen")) ; --UNCHK
lin barefooted_Adv = mkWAdv (k99 "avojaloin") ; --UNCHK
lin barehanded_A = mkWA (k99 "käsin") "paljain" ; --UNCHK
lin bareheaded_A = mkWA (k99 "päin") "paljain" ; --UNCHK
lin barelegged_A = mkWA (compoundA "paljas" (k38 "jalkainen")) ; --UNCHK
lin barely_Adv = adjAdv bare_A ; -- -- derived
lin bareness_N = mkWN (k40 "koruttomuus") ; --UNCHK
lin bargain_N = mkN "kauppa" ; --WN (k39 "sopimus") ;
lin bargain_V = mkWV (k67A "neuvotella") ; --UNCHK
lin bargain_V2 = mkWV2 (k67A "neuvotella") ; --UNCHK
lin bargain_down_V2 = mkWV2 (k52 "hieroa") "kauppoja" ; --UNCHK
lin bargainer_N = mkWN (k12 "neuvottelija") ; --UNCHK
lin bargaining_N = mkWN (k2 "neuvottelu") ; --UNCHK
lin barge_N = mkN "proomu" ; --mkWN (k10 "lotja") "raskas" ;
lin barge_V = mkWV (k53A "kuljettaa") "proomulla" ; --UNCHK
lin barge_in_V = mkWV (k52A "sekaantua") ; --UNCHK
lin bargee_N = mkWN (k10 "kuljettaja") "proomun" ; --UNCHK
lin bargello_N = mkWN (compoundN "Bargello-" (k39 "tikkaus")) ; --UNCHK
lin bargoed_PN = foreignPN "Bargoed" ;
lin bari_PN = foreignPN "Bari" ;
lin baric_A = mkWA "barium-" ; --UNCHK
lin barilla_N = mkWN "Halogeton" "souda" ; --UNCHK
lin baritone_A = mkWA "baritoni-" ; --UNCHK
lin baritone_N = mkWN (k5 "barytoni") ; --UNCHK
lin barium_N = mkWN (k5 "barium") ; --UNCHK
lin bark_N = L.bark_N ;
lin bark_V = mkWV (k69 "parkita") ; --UNCHK
lin bark_V2 = mkWV2 (k69 "parkita") ; --UNCHK
lin barker_N = mkWN (k5A "rakki") ; --UNCHK
lin barking_PN = foreignPN "Barking" ;
lin barky_A = mkWA (compoundA "kaarna" (k38 "mainen")) ; --UNCHK
lin barley_N = mkWN (k10 "ohra") ; --UNCHK
lin barley_water_N = mkWN (compoundN "ohra" (k27 "vesi")) ; --UNCHK
lin barleycorn_N = mkWN (k10 "ohra") ; --UNCHK
lin barm_N = mkWN (k9 "hiiva") ; --UNCHK
lin barmaid_N = mkWN (k12 "tarjoilija") ; --UNCHK
lin barman_N = mkWN (k1A "baarimikko") ; --UNCHK
lin barmbrack_N = mkWN (k10A "leipä") ; --UNCHK
lin barmy_A = mkWA (k1 "pöllö") ; --UNCHK
lin barn_N = mkWN (k9A "aitta") ; --UNCHK
lin barn_door_N = mkWN (k7 "ovi") "ladon" | mkWN (k33 "varjostin") ; --UNCHK
lin barnacle_N = mkWN (compoundN "valkoposki" (k7 "hanhi")) ; --UNCHK
lin barnburner_N = mkWN (compoundN "jymy" (k39 "menestys")) ; --UNCHK
lin barnet_PN = foreignPN "Barnet" ;
lin barnful_N = mkWN "ladollinen" ; --UNCHK
lin barnoldswick_PN = foreignPN "Barnoldswick" ;
lin barnsley_PN = foreignPN "Barnsley" ;
lin barnstaple_PN = foreignPN "Barnstaple" ;
lin barnstorm_V = mkWV (k67 "olla") "vaalikiertueella" ; --UNCHK
lin barnstormer_N = mkWN (compoundN "taito" (k10 "lentäjä")) ; --UNCHK
lin barnyard_N = mkWN (k9 "piha") ; --UNCHK
lin barograph_N = mkWN "barografi" ; --UNCHK
lin barographic_A = mkWA "barografinen" ; --UNCHK
lin barometer_N = mkWN (k5 "barometri") ; --UNCHK
lin barometric_A = mkWA (compoundA "baro" (k38 "metrinen")) ; --UNCHK
lin baron_N = mkWN (k5 "moguli") ; --UNCHK
lin baronage_N = mkWN (compoundN "paroni" (k10A "kunta")) ; --UNCHK
lin baronduki_N = mkWN (k10 "orava") ; --UNCHK
lin baroness_N = mkWN (k32A "paronitar") ; --UNCHK
lin baronet_N = mkWN "baronetti" ; --UNCHK
lin baronetcy_N = mkWN (k1 "arvo") "baronetin" ; --UNCHK
lin barong_N = mkWN (k30 "veitsi") ; --UNCHK
lin baronial_A = mkWA (k41 "ylväs") ; --UNCHK
lin barony_N = mkWN (k1 "arvo") "paronin" ; --UNCHK
lin baroque_A = mkWA (compoundA "barokki" (k38 "tyylinen")) ; --UNCHK
lin baroque_N = mkWN (k9A "barokkiaika") ; --UNCHK
lin barosaur_N = mkWN "barosaurus" ; --UNCHK
lin barque_N = mkWN (kH1 "parkki") ; --UNCHK
lin barrack_N = mkWN (k5A "parakki") ; --UNCHK
lin barrack_V = mkWV (k67A "piikitellä") ; --UNCHK
lin barrack_V2 = mkWV2 (k67A "piikitellä") ; --UNCHK
lin barracking_N = mkWN (k39 "buuaus") ; --UNCHK
lin barracks_N = mkN "kasarmi" ;
lin barracouta_N = mkWN (k10 "barrakuda") ; --UNCHK
lin barracuda_N = mkWN (k10 "barrakuda") ; --UNCHK
lin barrage_N = mkWN (k39 "pommitus") ; --UNCHK
lin barramundi_N = mkWN "Lates" "calcarifer" ; --UNCHK
lin barranquilla_PN = foreignPN "Barranquilla" ;
lin barrator_N = mkWN (compoundN "meri" (k41A "varas")) ; --UNCHK
lin barratry_N = mkWN (k5A "käräjöinti") "tarpeeton" ; --UNCHK
lin barrel_N = mkN "tynnyri" ;
lin barreled_A = mkWA "tynnyreihin" "pakattu" ; --UNCHK
lin barrelfish_N = mkWN (k9 "kala") ; --UNCHK
lin barrelhouse_N = mkWN (k14A "kapakka") ; --UNCHK
lin barrels_N = mkWN (k6 "tynnyri") ; --UNCHK
lin barren_A = mkWA (k99 "ilman") ; --UNCHK
lin barren_N = mkWN (k18 "maa") "hedelmätön" ; --UNCHK
lin barrenness_N = mkWN (k40 "tuottamattomuus") ; --UNCHK
lin barrenwort_N = mkWN (compoundN "japaninvarjo" (k9A "hiippa")) ; --UNCHK
lin barrette_N = mkWN (compoundN "hius" (k7A "solki")) ; --UNCHK
lin barrhead_PN = foreignPN "Barrhead" ;
lin barricade_N = mkWN (k5 "barrikadi") ; --UNCHK
lin barricade_V2 = mkWV2 (k58A "sulkea") "esteellä" ; --UNCHK
lin barrier_N = mkN "este" ; --WN (k5 "puomi") ;
lin barring_N = mkWN (k99 "vastaan") "äänestäminen" ; --UNCHK
lin barrio_N = mkWN (compoundN "esi" (k5A "kaupunki")) ; --UNCHK
lin barrister_N = mkWN (compoundN "asian" (k10 "ajaja")) ; --UNCHK
lin barroom_N = mkWN (k13 "saluuna") ; --UNCHK
lin barry_PN = foreignPN "Barry" ;
lin bart_PN = foreignPN "Bart" ;
lin bartender_N = mkWN (k1A "baarimikko") ; --UNCHK
lin barter_N = mkWN (k1A "vaihto") ; --UNCHK
lin barter_V = mkWV (k71 "tehdä") "vaihtokauppa" ; --UNCHK
lin barter_V2 = mkWV2 (k71 "tehdä") "vaihtokauppa" ; --UNCHK
lin barterer_N = mkWN (compoundN "vaihtokaupan" (k12 "tekijä")) ; --UNCHK
lin bartlett_N = mkWN (k12 "päärynä") ; --UNCHK
lin bartonia_N = mkWN (compoundN "kulta" (k1 "tupsu")) ; --UNCHK
lin barycenter_N = mkWN "massakeskipiste" ; --UNCHK
lin barye_N = mkWN (k5 "mikrobaari") ; --UNCHK
lin baryon_N = mkWN (k5 "nukleoni") ; --UNCHK
lin baryta_N = mkWN "baryytti" ; --UNCHK
lin barytic_A = mkWA "baryyttinen" ; --UNCHK
lin bas_relief_N = mkWN (compoundN "koho" (k10 "kuva")) ; --UNCHK
lin basal_A = mkWA "tyvi-" ; --UNCHK
lin basalt_N = mkWN (k5A "basaltti") ; --UNCHK
lin basaltic_A = mkWA "basaltti-" ; --UNCHK
lin bascule_N = mkWN (compoundN "lasku" (k9A "salpa")) ; --UNCHK
lin base_A = mkWA (k10 "väärä") ; --UNCHK
lin base_N = mkN "perusta" | mkN "kanta" ;
lin base_V = mkV "pohjautua" ;
lin base_V2 = mkV2 "perustaa" ;
lin baseball_N = mkWN (k5 "baseball") ; --f60
lin baseboard_N = mkWN (compoundN "jalka" (k9 "lista")) ; --UNCHK
lin basel_PN = foreignPN "Basel" ;
lin baseless_A = mkWA (k10 "joutava") ; --UNCHK
lin baseline_N = mkWN (k9 "takaraja") ; --UNCHK
lin basement_N = mkN "pohjakerros" ; --WN (k6 "kellari") ;
lin baseness_N = mkWN (k40 "kurjuus") ; --UNCHK
lin basenji_N = mkWN (k6 "basenji") ; --UNCHK
lin bash_N = mkWN (k39 "täräys") ; --UNCHK
lin bash_V2 = mkWV2 (k64 "lyödä") ; --UNCHK
lin bashful_A = mkWA (k41A "pelokas") ; --UNCHK
lin basic_A = mkA "perustava" ; --WA (k38 "perimmäinen") ;
lin basic_N = mkWN "peruselintarvike" ; --UNCHK
lin basically_Adv = mkWAdv (k99 "sisimmältään") ; --UNCHK
lin basics_N = mkWN (k10 "pohja") ; --UNCHK
lin basidial_A = mkWA "itiökantaan" "liittyvä" ; --UNCHK
lin basidiocarp_N = mkWN (k26 "sieni") ; --UNCHK
lin basidiolichen_N = mkWN (k10 "jäkälä") "itiökantainen" ; --UNCHK
lin basidiomycete_N = mkWN (k26 "sieni") "itiökantainen" ; --UNCHK
lin basidiomycetous_A = mkWA (compoundA "itiö" (k38 "kantainen")) ; --UNCHK
lin basidiospore_N = mkWN (compoundN "kanta" (k3 "itiö")) ; --UNCHK
lin basidiosporous_A = mkWA "basidiosporinen" ; --UNCHK
lin basidium_N = mkWN (compoundN "itiö" (k9A "kanta")) ; --UNCHK
lin basil_N = mkWN (kH1 "basilika") ; --UNCHK
lin basilar_A = mkWA "tyveen" "liittyvä" ; --UNCHK
lin basildon_PN = foreignPN "Basildon" ;
lin basileus_N = mkWN (k41A "kuningas") ; --UNCHK
lin basilica_N = mkWN (kH1 "basilika") "Rooman" ; --UNCHK
lin basilican_A = mkWA "basilika-" ; --UNCHK
lin basilisk_N = mkWN "basiliski" ; --UNCHK
lin basin_N = mkWN (k10A "vuoka") ; --UNCHK
lin basinal_A = mkWA "vuoka-" ; --UNCHK
lin basined_A = mkWA (k10 "oleva") "vuoassa" ; --UNCHK
lin basinet_N = mkWN "basinetti" ; --UNCHK
lin basingstoke_PN = foreignPN "Basingstoke" ;
lin basipetal_A = mkWA "lehdellinen" ; --UNCHK
lin basis_N = mkN "perusta" ;
lin basiscopic_A = mkWA "tyvi-" ; --UNCHK
lin bask_V = mkWV (k67A "paistatella") ; --UNCHK
lin basket_N = mkWN (k5 "kori") ; --f55
lin basketball_N = mkWN (k39 "koris") ; --UNCHK
lin basketry_N = mkWN (compoundN "kori" (k19 "työ")) ; --UNCHK
lin basketweaver_N = mkWN (compoundN "korin" (k12 "tekijä")) ; --UNCHK
lin basophil_N = mkWN "basofiili" ; --UNCHK
lin basophilia_N = mkWN "basofilia" ; --UNCHK
lin basophilic_A = mkWA "basofiilinen" ; --UNCHK
lin bass_A = mkWA (k10 "tumma") ; --UNCHK
lin bass_N = mkWN (k32 "ahven") ; --UNCHK
lin bassarisk_N = mkWN (k39 "astutus") "Bassariscus" ; --UNCHK
lin bassine_N = mkWN (k1A "kuitu") ; --UNCHK
lin bassist_N = mkWN (k5 "basisti") ; --UNCHK
lin bassoon_N = mkWN (k5A "fagotti") ; --UNCHK
lin bassoonist_N = mkWN (k5 "fagotisti") ; --UNCHK
lin basswood_N = mkWN (k39 "lehmus") ; --UNCHK
lin bastard_N = mkWN (compoundN "seka" (k3 "sikiö")) ; --UNCHK
lin bastardization_N = mkWN "vääristyminen" ; --UNCHK
lin bastardize_V2 = mkWV2 (k53 "julistaa") "aviottomaksi" ; --UNCHK
lin bastardly_A = mkWA (k38 "viheliäinen") ; --UNCHK
lin bastardy_N = mkWN (compoundN "synty" (k10 "perä")) "avioton" ; --UNCHK
lin baste_N = mkWN "kursiminen" ; --UNCHK
lin baste_V2 = mkWV2 (k67 "valella") ; --UNCHK
lin bastille_N = mkWN (k12 "vankila") ; --UNCHK
lin bastinado_N = mkWN "jalkapohjien" "ruoskinta" ; --UNCHK
lin bastinado_V2 = mkWV2 (k61 "ruoskia") "jalkapohjia" ; --UNCHK
lin basting_N = mkWN (compoundN "vale" (k38 "leminen")) ; --UNCHK
lin bastion_N = mkWN (k5 "bastioni") ; --UNCHK
lin bastioned_A = mkWA (compoundA "linnoite" (k1 "ttu")) ; --UNCHK
lin bastnasite_N = mkWN "bastnäsiitti" ; --UNCHK
lin basuco_N = mkWN (compoundN "kokaiini" (k9 "suola")) ; --UNCHK
lin bat_N = mkN "maila" ; ---ARB --mkN "lepakko" ; --mkWN (k1 "vuoro") ;
lin bat_V = mkWV (k53A "rökittää") ; --UNCHK
lin bat_V2 = mkWV2 (k53A "rökittää") ; --UNCHK
lin batch_N = mkN "erä" ; --mkWN (k10 "ryhmä") ;
lin bate_V2 = mkWV2 (k73A "peitata") ; --UNCHK
lin batfish_N = mkWN "peikkokrotti" ; --UNCHK
lin bath_N = mkWN (k1A "kylpy") ; --UNCHK
lin bath_PN = foreignPN "Bath" ;
lin bath_chair_N = mkWN (compoundN "pyörä" (k5 "tuoli")) ; --UNCHK
lin bathe_N = mkWN (k5A "uinti") ; --UNCHK
lin bathe_V = mkWV (k52A "peseytyä") ; --UNCHK
lin bathe_V2 = mkWV2 (k52A "peseytyä") ; --UNCHK
lin bather_N = mkWN (k12 "kylpijä") ; --UNCHK
lin bathetic_A = mkWA (k38 "tunteellinen") ; --UNCHK
lin bathgate_PN = foreignPN "Bathgate" ;
lin bathhouse_N = mkWN (k12 "kylpylä") ; --UNCHK
lin bathing_N = mkWN "peseytyminen" ; --UNCHK
lin bathing_cap_N = mkWN (compoundN "uima" (k5A "lakki")) ; --UNCHK
lin bathing_costume_N = mkWN (compoundN "uima" (k1A "puku")) ; --UNCHK
lin bathing_machine_N = mkWN (k5A "pukukoppi") ; --UNCHK
lin bathing_suit_N = mkWN (compoundN "uima" (k1A "puku")) ; --UNCHK
lin batholith_N = mkWN (k50 "syväkivilaji") ; --UNCHK
lin batholithic_A = mkWA "batoliittinen" ; --UNCHK
lin bathos_N = mkWN (compoundN "anti" (k5 "kliimaksi")) ; --UNCHK
lin bathrobe_N = mkWN (compoundN "kylpy" (k5A "takki")) ; --UNCHK
lin bathroom_N = mkWN (k99 "WC") ; --UNCHK
lin bathtub_N = mkWN (k41A "allas") ; --UNCHK
lin bathyal_A = mkWA (compoundA "batya" (k38 "alinen")) ; --UNCHK
lin bathymeter_N = mkWN (compoundN "syvyys" (k6 "mittari")) ; --UNCHK
lin bathymetric_A = mkWA "syvyysmittariin" "liittyvä" ; --UNCHK
lin bathymetry_N = mkWN (k39 "luotaus") ; --UNCHK
lin bathyscaphe_N = mkWN (compoundN "tutkimus" (k39 "alus")) "syvänmeren" ; --UNCHK
lin bathysphere_N = mkWN (compoundN "batysf" (k26 "ääri")) ; --UNCHK
lin batik_N = mkWN "batiikki" ; --UNCHK
lin batiste_N = mkWN (k5 "batisti") ; --UNCHK
lin batley_PN = foreignPN "Batley" ;
lin batman_N = mkWN (compoundN "sotilas" (k12 "palvelija")) ; --UNCHK
lin baton_N = mkWN (compoundN "tahti" (k1A "puikko")) ; --UNCHK
lin batrachomyomachia_N = mkWN (k9 "kiista") "hölmö" ; --UNCHK
lin bats_A = mkWA (k1 "pöllö") ; --UNCHK
lin batsman_N = mkWN (k10 "lyöjä") ; --UNCHK
lin battalion_N = mkWN (k10 "pataljoona") ; --UNCHK
lin batten_N = mkWN (k9 "piena") ; --UNCHK
lin batten_V = mkWV (k53A "listoittaa") ; --UNCHK
lin batten_V2 = mkWV2 (k53A "listoittaa") ; --UNCHK
lin batter_N = mkWN (k12 "taikina") ; --UNCHK
lin batter_V = mkWV (k71 "tehdä") "syvennys" ; --UNCHK
lin batter_V2 = mkV2 "mukiloida" ; --WV2 (k71 "tehdä") "syvennys" ;
lin battering_N = mkWN (compoundN "pahoin" (k2 "pitely")) ; --UNCHK
lin battery_1_N = mkWN (compoundN "pahoin" (k2 "pitely")) ; --UNCHK
lin battery_2_N = mkWN (compoundN "pahoin" (k2 "pitely")) ; --UNCHK
lin batting_N = mkWN (k5A "lyönti") ; --UNCHK
lin battle_N = mkN "taistelu" ;
lin battle_V = mkWV (k67 "taistella") ; --UNCHK
lin battle_V2 = mkV2 (mkV "taistella") (mkPrep "vastaan" partitive) ;
lin battle_cruiser_N = mkWN (compoundN "taistelu" (k12 "risteilijä")) ; --UNCHK
lin battledore_N = mkWN (compoundN "sulka" (k1 "pallo")) ; --UNCHK
lin battlefield_N = mkWN (k10A "kenttä") ; --UNCHK
lin battlefront_N = mkWN (k10 "rintama") ; --UNCHK
lin battleful_A = mkWA (k10 "sotaisa") ; --UNCHK
lin battleground_N = mkWN (k10A "kenttä") ; --UNCHK
lin battlement_N = mkWN (compoundN "rinta" (k39 "varustus")) ; --UNCHK
lin battlemented_A = mkWA (k38 "sakarainen") ; --UNCHK
lin battleship_N = mkWN (compoundN "taistelu" (k9 "laiva")) ; --UNCHK
lin battue_N = mkWN (compoundN "veri" (k1 "löyly")) ; --UNCHK
lin batty_A = mkWA (k1 "pöllö") ; --UNCHK
lin batwing_A = mkWA "lepakonsiipi-" ; --UNCHK
lin batwing_N = mkWN (compoundN "heiluri" (k7 "ovi")) ; --UNCHK
lin bauble_N = mkWN (k1 "koru") ; --UNCHK
lin baud_N = mkWN (k5 "baudi") ; --UNCHK
lin baulk_N = mkWN (compoundN "selkä" (k18 "puu")) ; --UNCHK
lin baulk_V = mkWV (k71 "tehdä") "tenä" ; --UNCHK
lin baulk_V2 = mkWV2 (k71 "tehdä") "tenä" ; --UNCHK
lin bauxite_N = mkWN (k5A "bauksiitti") ; --UNCHK
lin bauxitic_A = mkWA (compoundA "bauksiitti" (k38 "nen")) ; --UNCHK
lin bawbee_N = mkWN (k4A "kolikko") "puolen" "pennyn" ; --UNCHK
lin bawd_N = mkWN (k1A "lumppu") ; --UNCHK
lin bawdry_N = mkWN (k40 "säädyttömyys") ; --UNCHK
lin bawdy_A = mkWA (k34A "ruokoton") ; --UNCHK
lin bawdy_N = mkWN (k40 "säädyttömyys") ; --UNCHK
lin bawl_V = mkWV (k52 "karjua") ; --UNCHK
lin bawl_V2 = mkWV2 (k52 "karjua") ; --UNCHK
lin bawl_out_V2 = mkWV2 (k73 "saarnata") ; --UNCHK
lin bawler_N = mkWN (compoundN "itku" (k5 "pilli")) ; --UNCHK
lin bay_A = mkWA (compoundA "puna" (k15 "ruskea")) ; --UNCHK
lin bay_N = mkWN (k4A "ruunikko") ; --UNCHK
lin bay_V = mkWV (k52 "ulvoa") ; --UNCHK
lin bay_wreath_N = mkWN (compoundN "laakeri" (k49 "seppele")) ; --UNCHK
lin baya_N = mkWN (compoundN "riisi" (k10 "kutoja")) ; --UNCHK
lin bayat_N = mkWN (compoundN "uskollisuuden" (k9 "vala")) ; --UNCHK
lin bayberry_N = mkWN (compoundN "suo" (k5A "myrtti")) ; --UNCHK
lin bayonet_V2 = mkWV2 (k53 "lävistää") "pistimellä" ; --UNCHK
lin bayou_N = mkWN (compoundN "suo" (k7 "järvi")) ; --UNCHK
lin bazooka_N = mkWN (k1A "sinko") ; --UNCHK
lin bbc_PN = mkPN "BBC" ;
lin bdellium_N = mkWN (compoundN "kumi" (k5 "hartsi")) "aromaattinen" ; --UNCHK
lin beach_N = mkWN (k9A "ranta") ; --UNCHK
lin beach_V2 = mkWV2 (k52A "rantautua") ; --UNCHK
lin beachcomber_N = mkWN (k42 "mies") "rantojen" ; --UNCHK
lin beachfront_N = mkWN (k9A "ranta") ; --UNCHK
lin beachhead_N = mkWN (compoundN "jalan" (k9 "sija")) ; --UNCHK
lin beacon_N = mkWN (k14A "majakka") ; --UNCHK
lin beacon_fire_N = mkWN (compoundN "merkki" (k1 "valo")) ; --UNCHK
lin beacon_light_N = mkWN (k14A "majakka") ; --UNCHK
lin beaconsfield_PN = foreignPN "Beaconsfield" ;
lin bead_N = mkWN (k7 "helmi") ; --UNCHK
lin beaded_A = mkWA (compoundA "pisar" (k10 "oiva")) ; --UNCHK
lin beading_N = mkWN (compoundN "helmi" (k48 "koriste")) ; --UNCHK
lin beadle_N = mkWN (k3 "suntio") ; --UNCHK
lin beads_N = mkWN (compoundN "helmi" (k9 "nauha")) ; --UNCHK
lin beadsman_N = mkWN (k12 "rukoilija") ; --UNCHK
lin beady_A = mkWA (compoundA "jalo" (k38 "kivikoristeinen")) ; --UNCHK
lin beagle_N = mkWN (k8 "beagle") ; --UNCHK
lin beagling_N = mkWN (compoundN "koira" (k39 "metsästys")) ; --UNCHK
lin beak_N = mkWN (k1 "kuono") ; --UNCHK
lin beaked_A = mkWA (k10 "terävä") ; --UNCHK
lin beaker_N = mkWN (compoundN "juoma" (k5 "lasi")) ; --UNCHK
lin beakless_A = mkWA "nokaton" ; --UNCHK
lin beaklike_A = mkWA (compoundA "nokka" (k38 "mainen")) ; --UNCHK
lin beam_N = mkWN (k5 "puomi") ; --UNCHK
lin beam_V = mkWV (k53 "loistaa") ; --UNCHK
lin beam_V2 = mkWV2 (k53 "loistaa") ; --UNCHK
lin beamish_A = mkWA (compoundA "hymy" (k38 "ileväinen")) ; --UNCHK
lin beamy_A = mkWA (k41A "kirkas") ; --UNCHK
lin bean_N = mkWN (k7A "päälaki") ; --UNCHK
lin beanbag_N = mkWN (compoundN "herne" (k5 "pussi")) ; --UNCHK
lin beanball_N = mkWN (compoundN "pää" (k1 "pallo")) ; --UNCHK
lin beanie_N = mkWN (k1 "pipo") ; --UNCHK
lin beano_N = mkWN (k1 "bingo") ; --UNCHK
lin beanstalk_N = mkWN (compoundN "pavun" (k28 "varsi")) ; --UNCHK
lin bear_N = mkN "karhu" ;
lin bear_V = mkV "kantaa" ;
lin bear_V2 = mkV2 "kantaa" | mkV2 "sietää" partitive ; ---- split
lin bear_down_on_V2 = mkWV2 (k53A "rasittaa") "painollaan" ; --UNCHK
lin bear_on_V2 = mkWV2 (k52A "liittyä") ; --UNCHK
lin bear_out_V2 = mkWV2 (k53A "kannattaa") ; --UNCHK
lin bear_up_V = mkWV (k52A "selviytyä") ; --UNCHK
lin bear_up_under_V2 = prepV2 (advV OP_bear_V OP_up_Adv ) OP_under_Prep ; -- guess-p-verb
lin bear_with_V2 = prepV2 OP_bear_V OP_with_Prep ; -- guess-p-verb
lin bearable_A = mkWA (k10 "siedettävä") ; --UNCHK
lin bearberry_N = mkWN (compoundN "sian" (k14A "puolukka")) ; --UNCHK
lin beard_N = mkWN (compoundN "kiinnitys" (k2 "rihmasto")) ; --UNCHK
lin beard_V2 = mkWV2 (k62 "ympäröidä") ; --UNCHK
lin beardless_A = mkWA (k34A "parraton") ; --UNCHK
lin bearer_N = mkWN (k10 "kantaja") ; --UNCHK
lin bearing_N = mkWN (kH1 "laakeri") ; --UNCHK
lin bearish_A = mkWA (compoundA "lasku" (k38 "suuntainen")) ; --UNCHK
lin bearnaise_N = mkWN (compoundN "Béarnaise-" (k48A "kastike")) ; --UNCHK
lin bearsden_PN = foreignPN "Bearsden" ;
lin bearskin_N = mkWN (compoundN "karhunnahka" (k5A "lakki")) ; --UNCHK
lin beast_N = mkWN (k3 "olio") ; --UNCHK
lin beastliness_N = mkWN (k40 "kurjuus") ; --UNCHK
lin beastly_A = mkWA (k38 "petomainen") ; --UNCHK
lin beastly_Adv = mkWAdv (k99 "ilkeästi") | adjAdv beastly_A ; --UNCHK -- derived
lin beat_N = mkN "isku" ;
lin beat_V = mkWV (k52A "takoa") ;
lin beat_V2 = mkV2 "hakata" partitive | mkV2 "lyödä" partitive ;
lin beat_back_V = mkWV (k53A "tukahduttaa") ; --UNCHK
lin beat_down_V = mkWV (k61A "tinkiä") ; --UNCHK
lin beat_down_V2 = mkWV2 (k61A "tinkiä") ; --UNCHK
lin beat_out_V2 = mkWV2 (k53A "päihittää") ; --UNCHK
lin beat_up_V2 = mkWV2 (k74A "koota") ; --UNCHK
lin beatable_A = mkWA (k10 "oleva") "voitettavissa" ; --UNCHK
lin beaten_A = mkWA "taottu" ; --UNCHK
lin beater_N = mkWN (k12 "pahoinpitelijä") ; --UNCHK
lin beatific_A = mkWA (k10 "pyhä") ; --UNCHK
lin beatification_N = mkWN "beatifikaatio" ; --UNCHK
lin beatify_V2 = mkWV2 (k53 "julistaa") "autuaaksi" ; --UNCHK
lin beating_N = mkWN (k39 "löylytys") ; --UNCHK
lin beatnik_N = mkWN "beatnikki" ; --UNCHK
lin beatrice_PN = foreignPN "Beatrice" ;
lin beau_N = mkWN (k4A "nuorikko") ; --UNCHK
lin beaugregory_N = mkWN (k9 "kala") ; --UNCHK
lin beaujolais_N = mkWN "Beaujolais" ; --UNCHK
lin beaumaris_PN = foreignPN "Beaumaris" ;
lin beauteous_A = mkWA (k41 "kaunis") ; --UNCHK
lin beautician_N = mkWN (k5 "kosmetologi") ; --UNCHK
lin beautification_N = mkWN (compoundN "kaunis" (k38 "taminen")) ; --UNCHK
lin beautiful_A = L.beautiful_A ;
lin beautify_V2 = mkWV2 (k67 "kaunistella") ; --UNCHK
lin beauty_N = mkWN (k40 "kauneus") ; --UNCHK
lin beauty_parlour_N = mkWN (k5A "salonki") ; --UNCHK
lin beauty_salon_N = mkWN (k5A "salonki") ; --UNCHK
lin beauty_spot_N = mkWN (compoundN "kauneus" (k1A "pilkku")) ; --UNCHK
lin beaver_N = mkWN (k10 "majava") ; --UNCHK
lin beaver_V = mkWV (k53 "uurastaa") ; --UNCHK
lin beaver_away_V = mkWV (k53 "uurastaa") ; --UNCHK
lin bebington_PN = foreignPN "Bebington" ;
lin becalmed_A = mkWA "tyveneen" "joutunut" ; --UNCHK
lin because_Subj = S.because_Subj ;
lin because_of_Prep = mkPrep "vuoksi" ;
lin beccles_PN = foreignPN "Beccles" ;
lin beck_N = mkWN (k39 "viittaus") ; --UNCHK
lin becket_N = mkWN (k5A "lenkki") ; --UNCHK
lin beckon_V = mkWV (k53A "vilkuttaa") ; --UNCHK
lin beckon_V2 = mkWV2 (k53A "vilkuttaa") ; --UNCHK
lin become_V = caseV elative (mkV "tulla") ; --hänestä tuli
lin become_V2 = mkV2 "tulla" translative ;
lin become_VA = L.become_VA ;
lin becomingly_Adv = mkWAdv (k99 "säädyllisesti") ; --UNCHK
lin becomingness_N = mkWN (k40 "säädyllisyys") ; --UNCHK
lin bed_N = mkN "sänky" | mkN "vuode" ;
lin bed_V2 = mkWV2 (k67 "mennä") "sänkyyn" ; --UNCHK
lin bed_down_V = mkWV (k65 "käydä") "makuulle" ; --UNCHK
lin bedaubed_A = mkWA "töhritty" ; --UNCHK
lin bedbug_N = mkWN (k14A "lutikka") ; --UNCHK
lin beddau_PN = foreignPN "Beddau" ;
lin bedder_N = mkWN (k5 "kasvi") "yksivuotinen" ; --UNCHK
lin bedevil_V2 = mkWV2 (k53A "hämmästyttää") ; --UNCHK
lin bedevilment_N = mkWN (k9 "piina") ; --UNCHK
lin bedewed_A = mkWA (k38 "kasteinen") ; --UNCHK
lin bedfast_A = mkWA (compoundA "vuoteen" (k10 "oma")) ; --UNCHK
lin bedfellow_N = mkWN (compoundN "vuode" (k6 "toveri")) ; --UNCHK
lin bedford_PN = foreignPN "Bedford" ;
lin bedlam_N = mkWN (k3 "sanatorio") ; --UNCHK
lin bedlamite_N = mkWN (compoundN "mieli" (k26 "puoli")) ; --UNCHK
lin bedless_A = mkWA "vuoteeton" ; --UNCHK
lin bedlington_PN = foreignPN "Bedlington" ;
lin bedouin_N = mkWN (k5 "beduiini") ; --UNCHK
lin bedpan_N = mkWN (compoundN "alus" (k12 "astia")) ; --UNCHK
lin bedpost_N = mkWN (compoundN "sängyn" (k41 "pylväs")) ; --UNCHK
lin bedraggled_A = mkWA (k38 "sotkuinen") ; --UNCHK
lin bedrest_N = mkWN (compoundN "vuode" (k1A "lepo")) ; --UNCHK
lin bedridden_A = mkWA (compoundA "vuoteen" (k10 "oma")) ; --UNCHK
lin bedrock_N = mkWN (k10 "pohja") ; --UNCHK
lin bedroll_N = mkWN (compoundN "makuu" (k5 "pussi")) ; --UNCHK
lin bedroom_N = mkWN (k6 "kamari") ; --UNCHK
lin bedside_N = mkWN (k26 "vieri") "vuoteen" ; --UNCHK
lin bedsit_N = mkWN (k3 "yksiö") ; --UNCHK
lin bedsitter_N = mkWN (k3 "yksiö") ; --UNCHK
lin bedsitting_room_N = mkWN (k3 "yksiö") ; --UNCHK
lin bedsore_N = mkWN (k9 "makuuhaava") ; --UNCHK
lin bedspread_N = mkWN (k48A "peite") ; --UNCHK
lin bedstead_N = mkWN (k1A "runko") "sängyn" ; --UNCHK
lin bedstraw_N = mkWN (k13 "matara") ; --UNCHK
lin bedtime_N = mkWN (k9A "nukkumaanmenoaika") ; --UNCHK
lin bedwas_PN = foreignPN "Bedwas" ;
lin bedwetter_N = mkWN "yökastelija" ; --UNCHK
lin bee_N = mkWN (k38 "mehiläinen") ; --UNCHK
lin beebread_N = mkWN (compoundN "mehiläis" (k10A "leipä")) ; --UNCHK
lin beech_N = mkWN (k5A "pyökki") ; --UNCHK
lin beechen_A = mkWA (compoundA "pyökki" (k38 "puinen")) ; --UNCHK
lin beechnut_N = mkWN (k1 "terho") "pyökin" ; --UNCHK
lin beef_1_N = mkWN (compoundN "liha" (k9 "karja")) ; --UNCHK
lin beef_2_N = mkWN (compoundN "liha" (k9 "karja")) ; --UNCHK
lin beef_V = mkWV (k53A "valittaa") ;
lin beef_up_V2 = mkWV2 (k53 "voimistaa") ; --UNCHK
lin beefeater_N = mkWN (k12 "vartija") ; --UNCHK
lin beefsteak_N = mkWN (k5 "pihvi") ; --UNCHK
lin beefwood_N = mkWN "Grevillea" "striata" ; --UNCHK
lin beefy_A = mkWA (k9 "vahva") ; --UNCHK
lin beehive_N = mkWN (compoundN "mehiläis" (k10 "pesä")) ; --UNCHK
lin beekeeper_N = mkWN (compoundN "mehiläis" (k10 "hoitaja")) ; --UNCHK
lin beekeeping_N = mkWN (k1A "hoito") "mehiläisten" ; --UNCHK
lin beeline_N = mkWN (k19 "tie") "suorin" ; --UNCHK
lin beep_N = mkWN (k39 "piipitys") ; --UNCHK
lin beeper_N = mkWN (compoundN "henkilöhaku" (k48A "laite")) ; --UNCHK
lin beer_N = L.beer_N ;
lin beery_A = mkWA (compoundA "oluen" (k38 "huuruinen")) ; --UNCHK
lin beeswax_N = mkWN (compoundN "mehiläis" (k9 "vaha")) ; --UNCHK
lin beeswax_V2 = mkWV2 (k73 "vahata") "mehiläisvahalla" ; --UNCHK
lin beet_N = mkWN (k26 "punajuuri") ; --UNCHK
lin beetle_A = mkWA (k15 "tuuhea") ; --UNCHK
lin beetle_N = mkWN (k38 "kuoriainen") ; --UNCHK
lin beetle_V = mkWV (k52 "survoa") ; --UNCHK
lin beetroot_N = mkWN (k26 "punajuuri") ; --UNCHK
lin befall_V = mkWV (k73A "kohdata") "jotakuta" ; --UNCHK
lin befall_V2 = mkWV2 (k73A "kohdata") "jotakuta" ; --UNCHK
lin befit_V2 = mkWV2 (k58A "pukea") ; --UNCHK
lin befitting_A = mkWA (k41 "sovelias") ; --UNCHK
lin befogged_A = mkWA (k10 "sekava") ; --UNCHK
lin before_Adv = mkAdv "ennen" ;
lin before_Prep = S.before_Prep ;
lin before_Subj = lin Subj (ss "ennen kuin") ;
lin beforehand_Adv = mkWAdv (k99 "etukäteen") ; --UNCHK
lin befoul_V2 = mkWV2 (k73A "liata") ; --UNCHK
lin befoulment_N = mkWN (k2 "häpäisy") ; --UNCHK
lin beg_V = mkWV (k54A "pyytää") ; --UNCHK
lin beg_V2 = mkWV2 (k54A "pyytää") ; --UNCHK
lin beg_V2V = L.beg_V2V ;
lin beget_V2 = mkWV2 (k53A "siittää") ; --UNCHK
lin begetter_N = mkWN (k10 "siittäjä") ; --UNCHK
lin beggar_N = mkWN (k38 "kerjäläinen") ; --UNCHK
lin beggarly_A = mkWA (k10 "katala") ; --UNCHK
lin beggarman_N = mkWN (compoundN "mies" (k38 "kerjäläinen")) ; --UNCHK
lin beggarweed_N = mkWN (compoundN "lennätin" (k5 "kasvi")) ; --UNCHK
lin beggarwoman_N = mkWN (compoundN "nais" (k38 "kerjäläinen")) ; --UNCHK
lin beggary_N = mkWN (k40 "kerjäläisyys") ; --UNCHK
lin begin_V = mkV "alkaa" "alkoi" ;
lin begin_V2 = mkV2 "aloittaa" ;
lin begin_VV = mkVV (mkV "alkaa" "alkoi") ;
lin begin_ing_VV = mkVV (mkV "alkaa" "alkoi") ;
lin begin_to_VV = mkVV (mkV "alkaa" "alkoi") ;
lin begin_with_V = mkV "alkaa" "alkoi" ;
lin beginner_N = mkWN (k10 "aloittelija") ; --UNCHK
lin beginning_N = mkN "alku" ; ---- END checked AR
lin begonia_N = mkWN (k12 "begonia") ; --UNCHK
lin begrimed_A = mkWA (k34A "siivoton") ; --UNCHK
lin begrudge_V2 = mkWV2 (k67 "olla") "pahoillaan" ; --UNCHK
lin beguile_V2 = mkWV2 (k53A "petkuttaa") ; --UNCHK
lin beguilement_N = mkWN (k39 "huvitus") ; --UNCHK
lin beguiling_A = mkWA (k10 "valloittava") ; --UNCHK
lin beguine_N = mkWN (k8 "beguine") ; --UNCHK
lin begum_N = mkWN (k38 "nainen") "korkea-arvoinen" ; --UNCHK
lin behalf_N = mkWN (k99 "puolesta") ; --UNCHK
lin behave_V = mkWV (k67A "menetellä") ; --UNCHK
lin behavior_N = mkWN (k9A "toiminta") ; --UNCHK
lin behavioral_A = mkWA "käytös-" ; --UNCHK
lin behaviorism_N = mkWN (k12 "psykologia") "behavioristinen" ; --UNCHK
lin behaviorist_N = mkWN (k5 "behavioristi") ; --UNCHK
lin behavioristic_A = mkWA (k38 "behavioristinen") ; --UNCHK
lin behaviour_N = mkN "käyttäytyminen" | mkN "käytös" ; ---- split
lin behaviourism_N = mkWN (k12 "psykologia") "behavioristinen" ; --UNCHK
lin behaviourist_N = mkWN (k5 "behavioristi") ; --UNCHK
lin behest_N = mkWN (k1 "käsky") ; --UNCHK
lin behind_Adv = mkWAdv (k99 "takana") ; --UNCHK
lin behind_N = mkWN (k1 "takalisto") ; --UNCHK
lin behind_Prep = S.behind_Prep ;
lin behindhand_A = mkWA (k99 "myöhässä") ; --UNCHK
lin behold_V2 = mkWV2 (k71 "nähdä") ; --UNCHK
lin beholden_A = mkWA (compoundA "kiitollisuuden" (k38 "velkainen")) ; --UNCHK
lin beholder_N = mkWN (k10 "havainnoija") ; --UNCHK
lin behove_V2 = mkWV2 (k67 "olla") "velvollisuus" ; --UNCHK
lin beige_A = mkWA (k8 "beige") ; --UNCHK
lin beige_N = mkWN (k34A "valkaisematon") ; --UNCHK
lin beijing_PN = mkPN "Beijing" ;
lin being_A = mkA "oleva" ;
lin being_N = mkWN (k1A "olento") ; --UNCHK
lin beirut_PN = foreignPN "Beirut" ;
lin beith_PN = foreignPN "Beith" ;
lin belabour_V2 = mkWV2 (k52A "haukkua") ; --UNCHK
lin belated_A = mkWA (k99 "myöhässä") ; --UNCHK
lin belay_N = mkWN (k9 "vaarna") ; --UNCHK
lin belay_V2 = mkWV2 (k53A "kiinnittää") "vene" ; --UNCHK
lin belaying_pin_N = mkWN (k9 "vaarna") ; --UNCHK
lin belch_N = mkWN (k2 "röyhtäily") ; --UNCHK
lin belch_V = mkWV (k66 "röyhtäistä") ; --UNCHK
lin belch_V2 = mkWV2 (k66 "röyhtäistä") ; --UNCHK
lin belching_N = mkWN (k2 "röyhtäily") ; --UNCHK
lin beldam_N = mkWN (k1A "harppu") ; --UNCHK
lin beldame_N = mkWN (k1A "harppu") ; --UNCHK
lin beleaguer_V2 = mkWV2 (k53A "motittaa") ; --UNCHK
lin belemnite_N = mkWN (compoundN "belem" (k5A "niitti")) ; --UNCHK
lin belemnitic_A = mkWA "belemniittinen" ; --UNCHK
lin belfast_PN = foreignPN "Belfast" ;
lin belfry_N = mkWN (compoundN "kello" (k5 "torni")) ; --UNCHK
lin belgian_A = mkA "belgialainen" ;
lin belgian_N = mkWN (compoundN "belgi" (k38 "alainen")) ; --UNCHK
lin belgium_PN = foreignPN "Belgia" ;
lin belgrade_PN = foreignPN "Belgrad" ;
lin belie_V2 = mkV2 (mkV vOlla "ristiriidassa") (mkPrep "kanssa") ;
lin belief_N = mkWN (k48A "mielipide") ; --UNCHK
lin believable_A = mkWA (k10 "uskottava") ; --UNCHK
lin believe_V = mkV "uskoa" ;
lin believe_V2 = mkV2 "uskoa" illative ;
lin believe_VS = mkVS (mkV "uskoa") ;
lin believer_N = mkWN (k38 "uskovainen") ; --UNCHK
lin believing_N = mkWN (compoundN "usko" (k38 "minen")) ; --UNCHK
lin belike_Adv = mkWAdv (k99 "kaiketi") ; --UNCHK
lin belittle_V2 = mkWV2 (k52 "väheksyä") ; --UNCHK
lin belittling_A = mkWA (compoundA "halveks" (k9 "iva")) ; --UNCHK
lin belittling_N = mkWN (compoundN "ali" (k38 "arvioiminen")) ; --UNCHK
lin bell_N = mkN "soittokello" ; --WN (k1A "tiuku") ;
lin bell_V2 = mkWV2 (k56A "laittaa") "kello" ; --UNCHK
lin bell_buoy_N = mkWN (compoundN "kello" (k1 "poiju")) ; --UNCHK
lin bell_founder_N = mkWN (compoundN "kellon" (k10 "valaja")) ; --UNCHK
lin bell_foundry_N = mkWN (compoundN "kello" (k2 "valimo")) ; --UNCHK
lin bell_metal_N = mkWN (compoundN "kello" (k5 "metalli")) ; --UNCHK
lin bell_push_N = mkWN (compoundN "soitto" (k5A "nappi")) ; --UNCHK
lin bell_ringer_N = mkWN (k39 "menestys") ; --UNCHK
lin bell_tent_N = mkWN (compoundN "kupoli" (k9A "teltta")) ; --UNCHK
lin bella_PN = foreignPN "Bella" ;
lin belladonna_N = mkWN (k10 "belladonna") ; --UNCHK
lin bellarmine_N = mkWN (k1 "kannu") ; --UNCHK
lin bellbird_N = mkWN "etelänseppäkotinga" ; --UNCHK
lin bellboy_N = mkWN (k2 "pikkolo") ; --UNCHK
lin belle_N = mkWN (k32A "kaunotar") ; --UNCHK
lin belle_PN = foreignPN "Belle" ;
lin belletristic_A = mkWA (compoundA "kauno" (k38 "kirjallinen")) ; --UNCHK
lin bellhop_N = mkWN (k2 "pikkolo") ; --UNCHK
lin bellicose_A = mkWA (k10 "sotaisa") ; --UNCHK
lin bellicosity_N = mkWN (k40 "sotaisuus") ; --UNCHK
lin belligerence_N = mkWN (k40 "sotaisuus") ; --UNCHK
lin belligerency_N = mkWN (compoundN "vihamiel" (k40 "isyys")) ; --UNCHK
lin belligerent_A = mkWA (k10 "riitaisa") ; --UNCHK
lin belligerent_N = mkWN (k12 "ottelija") ; --UNCHK
lin bellow_N = mkWN (k9A "ärjyntä") ; --UNCHK
lin bellow_V = mkWV (k66 "ölistä") ; --UNCHK
lin bellow_V2 = mkWV2 (k66 "ölistä") ; --UNCHK
lin bellpull_N = mkWN (k33A "vedin") ; --UNCHK
lin bellshill_PN = foreignPN "Bellshill" ;
lin bellwether_N = mkWN (k41A "kellokas") ; --UNCHK
lin bellwort_N = mkWN (compoundN "kello" (k10A "kukka")) ; --UNCHK
lin belly_N = L.belly_N ;
lin belly_V = mkWV (k52 "pullistua") ; --UNCHK
lin belly_V2 = mkWV2 (k52 "pullistua") ; --UNCHK
lin bellyache_N = mkWN (compoundN "vatsa" (k1A "kipu")) ; --UNCHK
lin bellyache_V = mkWV (k53A "valittaa") ; --UNCHK
lin bellyband_N = mkWN (compoundN "maha" (k19 "vyö")) ; --UNCHK
lin bellylaugh_V = mkWV (compoundV "hörö" (k56 "nauraa")) ; --UNCHK
lin bellyless_A = mkWA (compoundA "litteä" (k38 "vatsainen")) ; --UNCHK
lin belo_horizonte_PN = foreignPN "Belo Horizonte" ;
lin belong_to_V2 = mkWV2 (k52 "kuulua") ; --UNCHK
lin belonging_N = mkWN (compoundN "yhteen" (k40 "kuuluvuus")) ; --UNCHK
lin beloved_A = mkWA (k1A "rakastettu") ; --UNCHK
lin beloved_N = mkWN (k1A "rakastettu") ; --UNCHK
lin below_Adv = mkAdv "alapuolella" ;
lin below_Prep = mkPrep "alapuolella" ;
lin belowground_A = mkWA (k99 "alta") "maan" ; --UNCHK
lin belper_PN = foreignPN "Belper" ;
lin belt_N = mkWN (k39 "läimäys") ; --UNCHK
lin belt_V2 = mkWV2 (k53A "vyöttää") ; --UNCHK
lin belt_out_V2 = mkWV2 (k56 "laulaa") ; --UNCHK
lin belt_up_V = mkWV (k72 "hiljetä") ; --UNCHK
lin belting_N = mkWN (compoundN "hihna" (k5 "materiaali")) ; --UNCHK
lin beltlike_A = mkWA (compoundA "vyö" (k38 "mäinen")) ; --UNCHK
lin beltway_N = mkWN (compoundN "ohikulku" (k19 "tie")) ; --UNCHK
lin beluga_N = mkWN (compoundN "maito" (k41 "valas")) ; --UNCHK
lin belvedere_N = mkWN (compoundN "näkö" (k5 "torni")) ; --UNCHK
lin bemoan_V2 = mkWV2 (k58 "itkeä") ; --UNCHK
lin bemused_A = mkWA (k10 "oleva") "pihalla" ; --UNCHK
lin ben_N = mkWN (kH1 "vuori") ; --UNCHK
lin bench_N = mkWN (k5A "penkki") ; --UNCHK
lin benchmark_N = mkWN (compoundN "kiinto" (k48 "piste")) ; --UNCHK
lin bend_N = mkWN (k5 "kurvi") ; --UNCHK
lin bend_V = mkWV (k54A "vääntää") "mutkalle" ; --UNCHK
lin bend_V2 = mkWV2 (k54A "vääntää") "mutkalle" ; --UNCHK
lin bend_down_V = advV OP_bend_V OP_down_Adv ; -- guess-p-verb
lin bend_over_V = advV OP_bend_V OP_over_Adv ; -- guess-p-verb
lin bend_over_backwards_V = mkWV (k71 "tehdä") "kaikkensa" ; --UNCHK
lin bendability_N = mkWN (k40 "taipuisuus") ; --UNCHK
lin bendable_A = mkWA (k15 "notkea") ; --UNCHK
lin bender_N = mkWN (k48A "kierre") ; --UNCHK
lin bending_N = mkWN (compoundN "tai" (k38 "vuttaminen")) ; --UNCHK
lin beneath_Adv = mkWAdv (k99 "alle") ; --UNCHK
lin beneath_Prep = mkPrep "alapuolella" ;
lin benedick_N = mkWN (compoundN "avio" (k42 "mies")) ; --UNCHK
lin benedictine_A = mkWA (compoundA "benediktiini" (k38 "läinen")) ; --UNCHK
lin benedictine_N = mkWN (compoundN "munkki" (k6 "likööri")) ; --UNCHK
lin benediction_N = mkWN (k39 "siunaus") ; --UNCHK
lin benedictory_A = mkWA (k38 "siunauksellinen") ; --UNCHK
lin benefaction_N = mkWN (k39 "lahjoitus") ; --UNCHK
lin benefactor_N = mkWN (k10 "lahjoittaja") ; --UNCHK
lin benefactress_N = mkWN (compoundN "hyvän" (k12 "tekijä")) ; --UNCHK
lin benefic_A = mkWA (k10 "suotuisa") ; --UNCHK
lin benefice_N = mkWN (compoundN "kirkkoherran" (k9A "virka")) ; --UNCHK
lin beneficed_A = mkWA (k10 "toimiva") "papinvirassa" ; --UNCHK
lin beneficence_N = mkWN (compoundN "hyväsydäm" (k40 "isyys")) ; --UNCHK
lin beneficent_A = mkWA (k10 "suotuisa") ; --UNCHK
lin beneficial_A = mkWA (k38 "hyödyllinen") ; --UNCHK
lin beneficiary_A = mkWA (compoundA "eduns" (k9 "aava")) ; --UNCHK
lin beneficiary_N = mkWN (compoundN "testamentin" (k10 "saaja")) ; --UNCHK
lin benefit_N = mkWN (k1A "hyöty") ;
lin benefit_V = mkV "hyötyä" ;
lin benefit_V2 = mkV2 "hyödyttää" partitive ;
lin benevolence_N = mkWN (k39 "lahjoitus") ; --UNCHK
lin benevolent_A = mkWA (compoundA "hyväntah" (k38 "toinen")) ; --UNCHK
lin bengali_A = mkWA (compoundA "bengali" (k38 "lainen")) ; --UNCHK
lin benighted_A = mkWA (k34A "sivistymätön") ; --UNCHK
lin benign_A = mkA "hyväntahtoinen" ; --mkWA (k10 "tekevä") "hyvää" ;
lin benignant_A = mkWA (k10 "tekevä") "hyvää" ; --UNCHK
lin benignity_N = mkWN (k1A "teko") "hyväntahtoinen" ; --UNCHK
lin benin_PN = foreignPN "Benin" ;
lin beninese_A = mkWA "beniniläinen" ; --UNCHK
lin beninese_N = mkWN "beniniläinen" ; --UNCHK
lin benison_N = mkWN (k39 "siunaus") ; --UNCHK
lin benjamin_PN = foreignPN "Benjamin" ;
lin bennet_N = mkWN (compoundN "kanadan" (k14A "kellukka")) ; --UNCHK
lin bennäs_PN = mkPN "Bennäs" ;
lin bent_A = mkWA (k38 "lommoinen") ; --UNCHK
lin bent_N = mkWN (k1A "taito") ; --UNCHK
lin benthos_N = mkWN (compoundN "pohja" (k1 "eliöstö")) ; --UNCHK
lin bentonite_N = mkWN (compoundN "bento" (k5A "niitti")) ; --UNCHK
lin bentonitic_A = mkWA "bentoniittinen" ; --UNCHK
lin bentwood_N = mkWN (k18 "puu") "taivutettu" ; --UNCHK
lin benzedrine_N = mkWN (k5 "amfetamiini") ; --UNCHK
lin benzene_N = mkWN (k6 "bensiini") ; --UNCHK
lin benzenoid_A = mkWA (compoundA "bentseeni" (k38 "rakenteinen")) ; --UNCHK
lin benzine_N = mkWN (k6 "bensiini") ; --UNCHK
lin benzoate_N = mkWN "bentsoaatti" ; --UNCHK
lin benzocaine_N = mkWN "benzokaiini" ; --UNCHK
lin benzodiazepine_N = mkWN "bentsodiatsepiini" ; --UNCHK
lin benzofuran_N = mkWN (compoundN "bentsofu" (k5 "raani")) ; --UNCHK
lin benzoic_A = mkWA "bentsyyli-" ; --UNCHK
lin benzoin_N = mkWN "suku" "Benzoin" ; --UNCHK
lin benzol_N = mkWN (k6 "bensiini") ; --UNCHK
lin benzyl_N = mkWN (compoundN "bentsyyli" (k5 "radikaali")) ; --UNCHK
lin benzylic_A = mkWA (compoundA "bentsy" (k38 "ylinen")) ; --UNCHK
lin bequeath_V2 = mkWV2 (k53A "jättää") "perinnöksi" ;
lin bequest_N = mkWN (k5A "testamentti") ; --UNCHK
lin berate_V2 = mkWV2 (k73 "saarnata") ; --UNCHK
lin berating_N = mkWN (compoundN "hauk" (k38 "kuminen")) ; --UNCHK
lin bereave_V2 = mkWV2 (k53 "ryöstää") ; --UNCHK
lin bereaved_N = mkWN (k38 "omainen") "sureva" ; --UNCHK
lin bereavement_N = mkWN (k39 "menetys") ; --UNCHK
lin bereft_A = mkWA (k38 "surullinen") ; --UNCHK
lin beret_N = mkWN (k6 "baskeri") ; --UNCHK
lin berg_N = mkWN (k26 "jäävuori") ; --UNCHK
lin bergamo_PN = foreignPN "Bergamo" ;
lin bergamot_N = mkWN (compoundN "väri" (k1A "minttu")) ; --UNCHK
lin bergen_PN = foreignPN "Bergen" ;
lin bergenia_N = mkWN (compoundN "vuoren" (k7A "kilpi")) ; --UNCHK
lin berk_N = mkWN (k3 "ääliö") ; --UNCHK
lin berkelium_N = mkWN "järjestysluku" "97" ; --UNCHK
lin berkhamsted_PN = foreignPN "Berkhamsted" ;
lin berlin_N = mkWN (k5 "limusiini") ; --UNCHK
lin berlin_PN = mkPN "Berliini" ;
lin berm_N = mkWN (k49A "piennar") ; --UNCHK
lin bermuda_PN = foreignPN "Bermuda" ;
lin bermudan_A = mkWA (compoundA "bermud" (k38 "alainen")) ; --UNCHK
lin bermudan_N = mkWN (compoundN "bermud" (k38 "alainen")) ; --UNCHK
lin bern_PN = foreignPN "Bern" ;
lin bernie_PN = foreignPN "Bernie" ;
lin beroe_N = mkWN "beroe" ; --UNCHK
lin berried_A = mkWA (k38 "marjainen") ; --UNCHK
lin berry_N = mkWN (k9 "marja") ; --UNCHK
lin berserk_A = mkWA (k1 "hullu") ; --UNCHK
lin berserker_N = mkWN (k1 "hullu") ; --UNCHK
lin berth_N = mkWN (k10 "tehtävä") ; --UNCHK
lin berth_V = mkWV (k52A "kiinnittyä") ; --UNCHK
lin berth_V2 = mkWV2 (k52A "kiinnittyä") ; --UNCHK
lin beryl_N = mkWN (k5 "berylli") ; --UNCHK
lin beryllium_N = mkWN (k5 "beryllium") ; --UNCHK
lin beseech_V2 = mkWV2 (k74A "vedota") ; --UNCHK
lin beseeching_A = mkWA "aneleva" ; --UNCHK
lin beseem_V2 = mkWV2 (k58A "pukea") ; --UNCHK
lin beset_V2 = mkV2 "vaivata" ; ---ARB
lin beshrew_V2 = mkWV2 (k74 "kirota") ; --UNCHK
lin beside_Prep = mkPrep "vieressä" ;
lin besides_Adv = mkWAdv (k99 "toisekseen") ; --UNCHK
lin besides_Prep = mkPrep "rinnalla" ;
lin besiege_V2 = mkV2 "piirittää" partitive ; --mkWV2 (k53A "pommittaa") "kysymyksillä" ;
lin besieger_N = mkWN (k10 "piirittäjä") ; --UNCHK
lin besmear_V2 = mkWV2 (k61 "tuhria") ; --UNCHK
lin besmirch_V2 = mkWV2 (k73A "liata") ; --UNCHK
lin besom_N = mkWN (k10A "luuta") ; --UNCHK
lin besotted_A = mkWA (k10 "oleva") "tillin-tallin" ; --UNCHK
lin bespeak_V2 = mkWV2 (k52 "anoa") ; --UNCHK
lin bespectacled_A = mkWA (compoundA "silmä" (k38 "lasipäinen")) ; --UNCHK
lin bespoke_A = mkWA (compoundA "tek" (k10 "emä")) "räätälin" ; --UNCHK
lin besprent_A = mkWA "ripoteltu" ; --UNCHK
lin best_Adv = mkWAdv (k99 "parhaiten") ;
lin best_V2 = mkWV2 (k58 "kytkeä") ; --UNCHK
lin best_seller_N = mkWN (k6 "bestseller") ; --UNCHK
lin bestial_A = mkWA (k38 "petomainen") ; --UNCHK
lin bestiary_N = mkWN (compoundN "eläin" (k9 "kirja")) ; --UNCHK
lin bestir_V2 = mkWV2 (k73 "herätä") ; --UNCHK
lin bestow_V2 = mkWV2 (k64 "suoda") ; --UNCHK
lin bestowal_N = mkWN "lahjoittaminen" ; --UNCHK
lin bestrew_V2 = mkWV2 (k67A "sirotella") ; --UNCHK
lin bestride_V2 = mkWV2 (k73A "harpata") ; --UNCHK
lin bestubbled_A = mkWA (compoundA "sän" (k38 "kinen")) ; --UNCHK
lin bet_N = mkN "vedon" (mkN "lyönti") ;
lin bet_V = mkV (mkV "lyödä") "vetoa" ; --mkWV (k73 "nojata") ;
lin bet_V2 = mkWV2 (k73 "nojata") ; --UNCHK
lin bet_VS = mkWVS (k73 "nojata") ; --UNCHK
lin beta_A = mkWA "beeta-" ; --UNCHK
lin beta_N = mkWN (k9 "beeta") ; --UNCHK
lin betaine_N = mkWN "betaiini" ; --UNCHK
lin betatron_N = mkWN (compoundN "elektroni" (k1A "linko")) ; --UNCHK
lin bete_noire_N = mkWN (k2 "henkilö") "kirottu" ; --UNCHK
lin betel_N = mkWN "Piper" "betel" ; --UNCHK
lin betel_nut_N = mkWN (compoundN "beetel" (k12 "pähkinä")) ; --UNCHK
lin bethel_N = mkWN (k1A "kirkko") ; --UNCHK
lin bethink_V2 = mkWV2 (k61A "miettiä") "jtak" ; --UNCHK
lin betide_V2 = mkWV2 (k52A "tapahtua") ; --UNCHK
lin betimes_Adv = mkWAdv (k99 "ajoissa") ; --UNCHK
lin betoken_V2 = mkWV2 (k69 "merkitä") ; --UNCHK
lin betray_V2 = mkWV2 (k62 "vasikoida") ; --UNCHK
lin betrayal_N = mkWN (k39 "petos") ; --UNCHK
lin betrayer_N = mkWN (k10 "kavaltaja") ; --UNCHK
lin betroth_V2 = mkWV2 (k52A "kihlautua") ; --UNCHK
lin betrothal_N = mkWN (k39 "kihlaus") ; --UNCHK
lin betrothedFem_N = mkWN (k1A "kihlattu") ; --UNCHK ---- sense to be split
lin betrothedMasc_N = mkWN (k1A "kihlattu") ; --UNCHK ---- sense to be split
lin betrothed_N = mkWN (k1A "kihlattu") ; --UNCHK
lin better_A = mkWA (k16A "parempi") ; --UNCHK
lin better_Adv = mkAdv "paremmin" ;
lin better_V2 = mkWV2 (k52A "parantua") ; --UNCHK
lin bettering_A = mkWA "paremmaksi" "muuttuva" ; --UNCHK
lin betterment_N = mkWN (k39 "parannus") ; --UNCHK
lin bettong_N = mkWN (compoundN "rotta" (k2 "kenguru")) ; --UNCHK
lin bettor_N = mkWN (k10 "pelaaja") ; --UNCHK
lin betulaceous_A = mkWA (compoundA "koivu" (k38 "mainen")) ; --UNCHK
lin between_Adv = mkWAdv (k99 "välissä") ; --UNCHK
lin between_Prep = S.between_Prep ;
lin bevatron_N = mkWN "bevatroni" ; --UNCHK
lin bevel_N = mkWN (compoundN "kulma" (k9A "mitta")) ; --UNCHK
lin bevel_V2 = mkWV2 (k53 "viistää") ; --UNCHK
lin beverage_N = mkWN (k10 "juotava") ;
lin beverley_PN = foreignPN "Beverley" ;
lin bevy_N = mkWN (k7 "parvi") ; --UNCHK
lin bewail_V2 = mkWV2 (k58 "itkeä") ; --UNCHK
lin beware_V = mkWV (k53A "välttää") ; --UNCHK
lin beware_V2 = mkWV2 (k53A "välttää") ; --UNCHK
lin bewdley_PN = foreignPN "Bewdley" ;
lin bewilder_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin bewilderedly_Adv = mkWAdv (compoundAdv "hämmentyn" (k5 "eesti")) ; --UNCHK
lin bewilderment_N = mkWN (k1 "olo") "ymmällään" ; --UNCHK
lin bewitch_V2 = mkWV2 (k61 "loitsia") ; --UNCHK
lin bewitchery_N = mkWN (compoundN "veto" (k10 "voima")) "eläimellinen" ; --UNCHK
lin bewitching_A = mkWA (k10 "hurmaava") ; --UNCHK
lin bexley_PN = foreignPN "Bexley" ;
lin bey_N = mkWN "bei" ; --UNCHK
lin beyond_Adv = mkWAdv (k99 "yli") "jnk" ; --UNCHK
lin beyond_Prep = mkPrep "saavuttamattomissa" ;
lin bezant_N = mkWN "solidus" ; --UNCHK
lin bezel_N = mkWN (compoundN "vino" (k10 "terä")) ; --UNCHK
lin bezique_N = mkWN "bezique" ; --UNCHK
lin bhakti_N = mkWN "bhakti" ; --UNCHK
lin bhang_N = mkWN "bhang" ; --UNCHK
lin bhutan_PN = foreignPN "Bhutan" ;
lin bhutani_N = mkWN (compoundN "bhutani" (k38 "lainen")) ; --UNCHK
lin bialy_N = mkWN (compoundN "sipuli" (k41A "rengas")) ; --UNCHK
lin biannually_Adv = mkWAdv (compoundAdv "puoli" (k38 "vuosittainen")) ; --UNCHK
lin bias_A = mkWA (compoundA "lei" (k1 "kattu")) "vinoon" ; --UNCHK
lin bias_N = mkWN (compoundN "ennakko" (k39 "käsitys")) ; --UNCHK
lin bias_V2 = mkWV2 (k73 "määrätä") "ennalta" ; --UNCHK
lin biauricular_A = mkWA "biaurikulaarinen" ; --UNCHK
lin biaxial_A = mkWA (compoundA "biaksia" (k38 "alinen")) ; --UNCHK
lin bib_N = mkWN (compoundN "ruoka" (k1A "lappu")) ; --UNCHK
lin bib_V = mkWV (k67A "tissutella") ; --UNCHK
lin bibbed_A = mkWA (compoundA "rinta" (k38 "lapullinen")) ; --UNCHK
lin bible_N = mkWN "raamattu" ; --UNCHK
lin bibless_A = mkWA "ruokalaputon" ; --UNCHK
lin biblical_A = mkWA (k38 "raamatullinen") ; --UNCHK
lin bibliographer_N = mkWN (k5 "bibliografi") ; --UNCHK
lin bibliographic_A = mkWA (k38 "bibliografinen") ; --UNCHK
lin bibliography_N = mkWN (k12 "bibliografia") ; --UNCHK
lin bibliolatrous_A = mkWA "Raamattua" "palvova" ; --UNCHK
lin bibliolatry_N = mkWN (k9A "palvonta") "Raamatun" ; --UNCHK
lin bibliomania_N = mkWN (compoundN "kirjojenkeräily" (k1 "himo")) ; --UNCHK
lin bibliomaniacal_A = mkWA (compoundA "biblio" (k38 "maaninen")) ; --UNCHK
lin bibliophile_N = mkWN (k12 "keräilijä") "kirjojen" ; --UNCHK
lin bibliophilic_A = mkWA (compoundA "bibliofiili" (k38 "nen")) ; --UNCHK
lin bibliopole_N = mkWN (k5A "antikvariaatti") ; --UNCHK
lin bibliopolic_A = mkWA "aktikvariaatti-" ; --UNCHK
lin bibliotheca_N = mkWN (k2 "kirjasto") ; --UNCHK
lin bibliothecal_A = mkWA (compoundA "kirja" (k38 "stollinen")) ; --UNCHK
lin bibliotic_A = mkWA "biblioottinen" ; --UNCHK
lin bibliotist_N = mkWN "bibliotisti" ; --UNCHK
lin bibulous_A = mkWA (k38 "humalainen") ; --UNCHK
lin bicameral_A = mkWA (compoundA "kaks" (k38 "ikamarinen")) ; --UNCHK
lin bicapsular_A = mkWA (compoundA "kaksikote" (k38 "loinen")) ; --UNCHK
lin bicarbonate_N = mkWN (k5A "bikarbonaatti") ; --UNCHK
lin bicentenary_N = mkWN (compoundN "kaksisataavuotis" (k10 "juhla")) ; --UNCHK
lin bicentennial_A = mkWA "kaksisataavuotis-" ; --UNCHK
lin bicentennial_N = mkWN (compoundN "kaksisataavuotis" (k10 "juhla")) ; --UNCHK
lin bicentric_A = mkWA (compoundA "kaks" (k38 "ikeskustainen")) ; --UNCHK
lin bicephalous_A = mkWA (compoundA "kaks" (k38 "ipäinen")) ; --UNCHK
lin biceps_N = mkWN (k39 "hauis") ; --UNCHK
lin bicester_PN = foreignPN "Bicester" ;
lin bichromate_N = mkWN "dikromaatti" ; --UNCHK
lin bichromated_A = mkWA "dikromaattinen" ; --UNCHK
lin bicipital_A = mkWA (compoundA "kaks" (k38 "ipäinen")) ; --UNCHK
lin bicker_N = mkWN (k13 "kahina") ; --UNCHK
lin bicker_V = mkWV (k66 "kitistä") ; --UNCHK
lin bicolor_A = mkWA (compoundA "kaksi" (k38 "värinen")) ; --UNCHK
lin biconcave_A = mkWA (compoundA "kaksois" (k10 "kovera")) ; --UNCHK
lin biconvex_A = mkWA (k38 "muotoinen") "linssin" ; --UNCHK
lin bicorn_A = mkWA (compoundA "kaks" (k38 "isarvinen")) ; --UNCHK
lin bicorn_N = mkWN "bicorne" ; --UNCHK
lin bicuspid_A = mkWA (compoundA "kaksi" (k38 "lehtinen")) ; --UNCHK
lin bicycle_N = mkWN (k10 "pyörä") ;
lin bicycle_V = mkWV (k58A "polkea") ; --UNCHK
lin bicyclic_A = mkWA (compoundA "kaks" (k38 "irenkainen")) ; --UNCHK
lin bicycling_N = mkWN (k2 "pyöräily") ; --UNCHK
lin bicylindrical_A = mkWA (compoundA "kaks" (k38 "isylinterinen")) ; --UNCHK
lin bid_N = mkN "tarjous" ;
lin bid_V = mkV "tarjota" ;
lin bid_V2 = mkWV2 (k74A "vedota") ; --UNCHK
lin biddable_A = mkWA (k38 "tottelevainen") ; --UNCHK
lin bidder_N = mkWN (k10 "tarjoaja") ;
lin bidding_N = mkWN (k39 "tarjous") ; --UNCHK
lin biddulph_PN = foreignPN "Biddulph" ;
lin bide_V2 = mkWV2 (k52A "viipyä") ; --UNCHK
lin bideford_PN = foreignPN "Bideford" ;
lin bidentate_A = mkWA (compoundA "kaks" (k38 "ihampainen")) ; --UNCHK
lin bidet_N = mkWN (k20 "bidee") ; --UNCHK
lin bidirectional_A = mkWA (compoundA "kaksi" (k38 "suuntainen")) ; --UNCHK
lin bielefeld_PN = foreignPN "Bielefeld" ;
lin biennial_A = mkWA (compoundA "kaks" (k38 "ivuotinen")) ; --UNCHK
lin biennial_N = mkWN (k5 "kasvi") "kaksivuotinen" ; --UNCHK
lin biface_A = mkWA (compoundA "kaks" (k38 "isivuinen")) ; --UNCHK
lin biff_N = mkWN (k5 "tälli") ; --UNCHK
lin biff_V2 = mkWV2 (k73A "hakata") ; --UNCHK
lin bifid_A = mkWA (compoundA "kaksi" (k38 "halkoinen")) ; --UNCHK
lin bifilar_A = mkWA (compoundA "kaksi" (k38 "säikeinen")) ; --UNCHK
lin biflagellate_A = mkWA (compoundA "kaksisii" (k38 "mainen")) ; --UNCHK
lin bifocal_A = mkWA "kaksiteho-" ; --UNCHK
lin bifoliate_A = mkWA (compoundA "kaksi" (k38 "lehtinen")) ; --UNCHK
lin biform_A = mkWA (compoundA "kaksi" (k38 "muotoinen")) ; --UNCHK
lin bifurcate_A = mkWA (k38 "haarainen") ; --UNCHK
lin bifurcate_V = mkWV (k52A "haarautua") "kahdeksi" ; --UNCHK
lin bifurcate_V2 = mkWV2 (k52A "haarautua") "kahdeksi" ; --UNCHK
lin bifurcation_N = mkWN (k99 "kahtia") "haarautuminen" ; --UNCHK
lin big_A = L.big_A ;
lin bigamist_N = mkWN (k2 "henkilö") "kaksiavioinen" ; --UNCHK
lin bigamous_A = mkWA (k38 "bigaaminen") ; --UNCHK
lin bigamy_N = mkWN (k38 "kaksinnaiminen") ; --UNCHK
lin bigeminal_A = mkWA (k38 "pareittainen") ; --UNCHK
lin bigeneric_A = mkWA (compoundA "kaksi" (k38 "sukuinen")) ; --UNCHK
lin bigeye_N = mkWN (compoundN "iso" (k10 "silmä")) ; --UNCHK
lin biggin_N = mkWN (k1A "hattu") "vauvan" ; --UNCHK
lin biggish_A = mkWA "suurehko" ; --UNCHK
lin biggleswade_PN = foreignPN "Biggleswade" ;
lin bighead_N = mkWN "isopää-" ; --UNCHK
lin bigheartedness_N = mkWN (compoundN "laajasydäm" (k40 "isyys")) ; --UNCHK
lin bighorn_N = mkWN (compoundN "paksusarvi" (k41A "lammas")) ; --UNCHK
lin bight_N = mkWN (k14A "silmukka") ; --UNCHK
lin bigmouthed_A = mkWA (k41 "puhelias") ; --UNCHK
lin bignoniaceous_A = mkWA "Bignoniaceae-heimoon" "liittyvä" ; --UNCHK
lin bignoniad_N = mkWN "bignoniadi" ; --UNCHK
lin bigos_N = mkWN (kH1 "pata") ; --UNCHK
lin bigot_N = mkWN (k12 "kiihkoilija") ; --UNCHK
lin bigoted_A = mkWA (k38 "fanaattinen") ; --UNCHK
lin bigotry_N = mkWN (k40 "dogmaattisuus") ; --UNCHK
lin bigram_N = mkWN "bigrammi" ; --UNCHK
lin bigwig_N = mkWN (kH1 "pamppu") ; --UNCHK
lin bijou_N = mkWN (k1 "koru") ; --UNCHK
lin bike_N = L.bike_N ;
lin bike_V = mkWV (k58A "polkea") ; --UNCHK
lin bikini_N = mkWN (compoundN "uima" (k1A "puku")) "kaksiosainen" ; --UNCHK
lin bilabial_A = mkWA (compoundA "bilabia" (k38 "alinen")) ; --UNCHK
lin bilabiate_A = mkWA (compoundA "kaks" (k38 "ihuulinen")) ; --UNCHK
lin bilateral_A = mkWA (compoundA "kaksi" (k38 "puolinen")) ; --UNCHK
lin bilateralism_N = mkWN (k12 "symmetria") "molemminpuolinen" ; --UNCHK
lin bilaterality_N = mkWN (k12 "symmetria") "molemminpuolinen" ; --UNCHK
lin bilbao_PN = foreignPN "Bilbao" ;
lin bilberry_N = mkWN (k14A "mustikka") ; --UNCHK
lin bile_N = mkWN (k7A "sappi") ; --UNCHK
lin bile_duct_N = mkWN (compoundN "sappi" (k19 "tie")) ; --UNCHK
lin bilge_N = mkWN (kH1 "palle") ; --UNCHK
lin bilge_water_N = mkWN (k5 "pilssi") ; --UNCHK
lin bilges_N = mkWN (k5 "pilssi") ; --UNCHK
lin bilgy_A = mkWA (compoundA "pilssi" (k38 "mäinen")) ; --UNCHK
lin bilharzia_N = mkWN (k5A "tauti") "bilhartsia-madon" "aiheuttama" ; --UNCHK
lin biliary_A = mkWA "sappi-" ; --UNCHK
lin bilimbi_N = mkWN (compoundN "tähti" (k10 "hedelmä")) ; --UNCHK
lin bilingual_A = mkWA (compoundA "kaks" (k38 "ikielinen")) ; --UNCHK
lin bilingual_N = mkWN (k2 "henkilö") "kaksikielinen" ; --UNCHK
lin bilingualism_N = mkWN (compoundN "kaksikiel" (k40 "isyys")) ; --UNCHK
lin bilious_A = mkWA (compoundA "sappi" (k38 "tautinen")) ; --UNCHK
lin biliousness_N = mkWN (k40 "äreys") ; --UNCHK
lin bilirubin_N = mkWN (compoundN "bili" (k6 "rubiini")) ; --UNCHK
lin bilk_V2 = mkWV2 (k53A "livahtaa") ; --UNCHK
lin bill_N = mkN "lasku" | mkN "seteli" ; ---- split
lin bill_PN = mkPN "Bill" ;
lin bill_V = mkWV (k53 "mainostaa") ; --UNCHK
lin bill_V2 = mkV2 "laskuttaa" ; --mkWV2 (k53 "mainostaa") ;
lin bill_poster_N = mkWN "julisteiden" "kiinnittäjä" ; --UNCHK
lin bill_sticker_N = mkWN "julisteiden" "kiinnittäjä" ; --UNCHK
lin billabong_N = mkWN (k9 "haara") ; --UNCHK
lin billboard_N = mkWN (compoundN "tienvarsi" (k39 "mainos")) ; --UNCHK
lin billericay_PN = foreignPN "Billericay" ;
lin billet_N = mkWN (k10 "tehtävä") ; --UNCHK
lin billet_V2 = mkWV2 (k53A "majoittaa") ; --UNCHK
lin billet_doux_N = mkWN (compoundN "rakkaus" (k48 "kirje")) ; --UNCHK
lin billfish_N = mkWN (compoundN "purje" (k9 "kala")) ; --UNCHK
lin billfold_N = mkWN (k4A "lompakko") ; --UNCHK
lin billhook_N = mkWN (k12 "kassara") ; --UNCHK
lin billiard_A = mkWA "biljardi-" ; --UNCHK
lin billiard_marker_N = mkWN (compoundN "piste" (k6 "laskuri")) "biljardin" ; --UNCHK
lin billiard_player_N = mkWN (k10 "pelaaja") "biljardin" ; --UNCHK
lin billiard_room_N = mkWN (compoundN "biljardi" (k5 "sali")) ; --UNCHK
lin billiard_table_N = mkWN (compoundN "biljardi" (k10A "pöytä")) ; --UNCHK
lin billiards_N = mkWN (k6 "biljardi") ; --UNCHK
lin billingsgate_N = mkWN (k39 "solvaus") ; --UNCHK
lin billington_PN = foreignPN "Billington" ;
lin billion_A = mkWA (k5 "miljardi") ;
lin billion_N = mkWN (k5 "miljardi") ;
lin billionaire_N = mkWN (k5 "miljardööri") ; --UNCHK
lin billionth_A = mkWA "miljardis" ; --UNCHK
lin billionth_N = mkWN (compoundN "miljardis" (k10 "osa")) ; --UNCHK
lin billow_N = mkWN (k1A "aalto") "suuri" ; --UNCHK
lin billow_V = mkWV (k52A "täyttyä") ; --UNCHK
lin billowy_A = mkWA (k38 "hyrskyinen") ; --UNCHK
lin billy_N = mkWN (kH1 "pukki") ; --UNCHK
lin billy_goat_N = mkWN (kH1 "pukki") ; --UNCHK
lin billy_o_N = mkWN (k99 "vimmatusti") ; --UNCHK
lin bilobate_A = mkWA (compoundA "kaksi" (k38 "lohkoinen")) ; --UNCHK
lin bilocation_N = mkWN "bilokaatio" ; --UNCHK
lin bilocular_A = mkWA (compoundA "kaks" (k38 "ipesäinen")) ; --UNCHK
lin biltong_N = mkWN (compoundN "kuiva" (k9 "liha")) ; --UNCHK
lin bimbo_N = mkWN "bimbo" ; --UNCHK
lin bimestrial_A = mkWA (compoundA "kaksi" (k38 "kuukautinen")) ; --UNCHK
lin bimetal_A = mkWA (compoundA "kaksois" (k38 "metallinen")) ; --UNCHK
lin bimetal_N = mkWN (compoundN "kaksois" (k5 "metalli")) ; --UNCHK
lin bimetallic_A = mkWA (compoundA "kaks" (k38 "imetallikantainen")) ; --UNCHK
lin bimetallism_N = mkWN (k5 "bimetallismi") ; --UNCHK
lin bimetallist_N = mkWN (compoundN "puolesta" (k10 "puhuja")) "kaksimetallikannan" ; --UNCHK
lin bimetallistic_A = mkWA (compoundA "kaks" (k38 "imetallikantainen")) ; --UNCHK
lin bimillenial_A = mkWA "kaksituhatvuotis-" ; --UNCHK
lin bimillennium_N = mkWN "kaksituhatvuotis-" ; --UNCHK
lin bimodal_A = mkWA (compoundA "kaksi" (k38 "muotoinen")) ; --UNCHK
lin bimolecular_A = mkWA (compoundA "kaksimoleky" (k38 "ylinen")) ; --UNCHK
lin bimorphemic_A = mkWA "bimorfeeminen" ; --UNCHK
lin bimotored_A = mkWA (compoundA "kaks" (k38 "imoottorinen")) ; --UNCHK
lin bin_N = mkWN (k3 "säiliö") ;
lin binary_A = mkWA (k38 "binaarinen") ; --UNCHK
lin binary_N = mkWN (compoundN "binaari" (k10 "ohjelma")) ; --UNCHK
lin binate_A = mkWA "kaksois-" ; --UNCHK
lin bind_N = mkWN (k39 "rasitus") ; --UNCHK
lin bind_V = mkWV (k53A "aiheuttaa") "ummetusta" ; --UNCHK
lin bind_V2 = mkV2 "sitoa" ; --WV2 (k53A "aiheuttaa") "ummetusta" ;
lin bindable_A = mkWA (k10 "oleva") "sidottavissa" ; --UNCHK
lin binder_N = mkWN (k39 "sidos") ; --UNCHK
lin bindery_N = mkWN (k2 "sitomo") ; --UNCHK
lin binding_A = variants {} ; --
lin binding_N = mkWN (k39 "sidos") ; --UNCHK
lin bindweed_N = mkWN (k1A "kierto") ; --UNCHK
lin bine_N = mkWN (k10 "humala") ; --UNCHK
lin binge_N = mkN "villitys" ; ---ARB --mkWN (compoundN "juoma" (k27 "kausi")) ;
lin bingley_PN = foreignPN "Bingley" ;
lin bingo_N = mkWN (k1 "bingo") ; --UNCHK
lin binnacle_N = mkWN (compoundN "kompassin" (k39 "suojus")) ; --UNCHK
lin binocular_A = mkWA (compoundA "kaks" (k38 "isilmäinen")) ; --UNCHK
lin binoculars_N = mkWN (k6 "kiikari") ; --UNCHK
lin binomial_A = mkWA (compoundA "kaks" (k38 "ijäseninen")) ; --UNCHK
lin binomial_N = mkWN (k5 "binomi") ; --UNCHK
lin binturong_N = mkWN (compoundN "karhu" (k10A "näätä")) ; --UNCHK
lin binucleate_A = mkWA (compoundA "kaksitu" (k38 "mainen")) ; --UNCHK
lin bioassay_N = mkWN (k5 "analyysi") "biologinen" ; --UNCHK
lin biocatalyst_N = mkWN (k6 "entsyymi") ; --UNCHK
lin biocatalytic_A = mkWA (compoundA "bio" (k38 "katalyyttinen")) ; --UNCHK
lin biochemical_A = mkWA (compoundA "bio" (k38 "kemiallinen")) ; --UNCHK
lin biochemist_N = mkWN (compoundN "bio" (k5 "kemisti")) ; --UNCHK
lin biochemistry_N = mkWN (compoundN "bio" (k12 "kemia")) ; --UNCHK
lin biochip_N = mkWN (compoundN "elo" (k1 "siru")) ; --UNCHK
lin bioclimatic_A = mkWA (compoundA "bio" (k38 "ilmastollinen")) ; --UNCHK
lin bioclimatology_N = mkWN (compoundN "bio" (k12 "klimatologia")) ; --UNCHK
lin biodegradable_A = mkWA "luonnossa" "hajoava" ; --UNCHK
lin biodiversity_N = mkWN (k5A "biodiversiteetti") ; --UNCHK
lin bioelectricity_N = mkWN (compoundN "bio" (k1 "sähkö")) ; --UNCHK
lin bioethics_N = mkWN (compoundN "bio" (k14A "etiikka")) ; --UNCHK
lin biofeedback_N = mkWN (compoundN "bio" (k48A "palaute")) ; --UNCHK
lin biogenesis_N = mkWN "biogeneesi" ; --UNCHK
lin biogenetic_A = mkWA (compoundA "bio" (k38 "geneettinen")) ; --UNCHK
lin biogenic_A = mkWA (k38 "biogeeninen") ; --UNCHK
lin biogenous_A = mkWA (k38 "biogeeninen") ; --UNCHK
lin biogeographic_A = mkWA "eliömaantieteellinen" ; --UNCHK
lin biogeography_N = mkWN "eliömaantiede" ; --UNCHK
lin biographer_N = mkWN (k10 "kirjoittaja") "elämäkertojen" ; --UNCHK
lin biographic_A = mkWA (k38 "biografinen") ; --UNCHK
lin biographical_A = mkWA (k38 "biografinen") ; --UNCHK
lin biography_N = mkWN (k10 "elämä") ; --UNCHK
lin biohazard_N = mkWN (k48 "aine") "biologinen" ; --UNCHK
lin biological_A = mkWA (k38 "biologinen") ; --UNCHK
lin biologism_N = mkWN (compoundN "biolog" (k5 "ismi")) ; --UNCHK
lin biologist_N = mkWN (k5 "biologi") ; --UNCHK
lin biologistic_A = mkWA (compoundA "biologi" (k38 "stinen")) ; --UNCHK
lin biology_N = mkWN (k12 "biologia") ; --UNCHK
lin bioluminescence_N = mkWN (compoundN "bio" (k5 "luminesenssi")) ; --UNCHK
lin bioluminescent_A = mkWA (compoundA "biolumin" (k10 "oiva")) ; --UNCHK
lin biomass_N = mkWN (compoundN "bio" (k9 "massa")) ; --UNCHK
lin biome_N = mkWN (compoundN "elo" (k2 "yhteisö")) ; --UNCHK
lin biomedicine_N = mkWN (compoundN "biolääke" (k48A "tiede")) ; --UNCHK
lin biometrics_N = mkWN (k9A "statistiikka") "biologinen" ; --UNCHK
lin bionic_A = mkWA "bioninen" ; --UNCHK
lin bionics_N = mkWN (compoundN "bion" (k9A "iikka")) ; --UNCHK
lin biophysicist_N = mkWN (compoundN "bio" (k4A "fyysikko")) ; --UNCHK
lin biophysics_N = mkWN (compoundN "bio" (k14A "fysiikka")) ; --UNCHK
lin biopiracy_N = mkWN (compoundN "bio" (k5 "piratismi")) ; --UNCHK
lin biopsy_N = mkWN (k12 "biopsia") ; --UNCHK
lin bioremediation_N = mkWN (compoundN "bio" (k39 "puhdistus")) ; --UNCHK
lin biosafety_N = mkWN (compoundN "bio" (k40 "turvallisuus")) ; --UNCHK
lin bioscope_N = mkWN (compoundN "biosko" (k5A "oppi")) ; --UNCHK
lin biosphere_N = mkWN (k5 "biosfääri") ; --UNCHK
lin biosynthesis_N = mkWN (compoundN "bio" (k5 "synteesi")) ; --UNCHK
lin biosynthetic_A = mkWA (compoundA "bio" (k38 "synteettinen")) ; --UNCHK
lin biosystematic_A = mkWA (compoundA "bio" (k38 "systemaattinen")) ; --UNCHK
lin biosystematics_N = mkWN (compoundN "bio" (k9A "systematiikka")) ; --UNCHK
lin biota_N = mkWN (k12 "biologia") ; --UNCHK
lin biotechnology_N = mkWN (k12 "ergonomia") ; --UNCHK
lin bioterrorism_N = mkWN (k5 "terrorismi") "biologinen" ; --UNCHK
lin biotic_A = mkWA (k10 "elävä") ; --UNCHK
lin biotin_N = mkWN "H-vitamiini" ; --UNCHK
lin biotite_N = mkWN (compoundN "musta" (k48A "kiille")) ; --UNCHK
lin biotitic_A = mkWA "biotiittinen" ; --UNCHK
lin biotype_N = mkWN (compoundN "bio" (k5A "tyyppi")) ; --UNCHK
lin biotypic_A = mkWA (compoundA "bio" (k38 "tyyppinen")) ; --UNCHK
lin bioweapon_N = mkWN (k48 "ase") "biologinen" ; --UNCHK
lin biparous_A = mkWA (k10 "tuottava") "kaksosia" ; --UNCHK
lin bipartisan_A = mkWA (compoundA "vasta" (k38 "vuoroinen")) ; --UNCHK
lin bipartite_A = mkWA (compoundA "kaksi" (k38 "puolinen")) ; --UNCHK
lin biped_N = mkWN (compoundN "kaks" (k38 "ijalkainen")) ; --UNCHK
lin bipedal_A = mkWA (compoundA "kaks" (k38 "ijalkainen")) ; --UNCHK
lin bipedalism_N = mkWN "kaksijalkaisuus" ; --UNCHK
lin bipinnate_A = mkWA (compoundA "kaks" (k38 "ilehdykkäinen")) ; --UNCHK
lin bipinnatifid_A = mkWA (compoundA "kaks" (k38 "ilehdykkäinen")) ; --UNCHK
lin biplane_N = mkWN (compoundN "lento" (k48 "kone")) "kaksitasoinen" ; --UNCHK
lin bipolar_A = mkWA (compoundA "kaks" (k38 "inapainen")) ; --UNCHK
lin biprism_N = mkWN "biprisma" ; --UNCHK
lin biquadrate_N = mkWN (k48 "aste") "neljäs" ; --UNCHK
lin biquadratic_A = mkWA "neljännen" "asteen" ; --UNCHK
lin biquadratic_N = mkWN (k5 "polynomi") "neljännen" "asteen" ; --UNCHK
lin biracial_A = mkWA (compoundA "kaksi" (k38 "rotuinen")) ; --UNCHK
lin biradial_A = mkWA (k38 "elliptinen") ; --UNCHK
lin birch_A = mkWA (k38 "koivuinen") ; --UNCHK
lin birch_N = mkWN (k9 "vitsa") ; --UNCHK
lin birch_V2 = mkWV2 (k73 "piiskata") ; --UNCHK
lin birch_rod_N = mkWN (k9 "vitsa") ; --UNCHK
lin bird_N = L.bird_N ;
lin bird_fancier_N = mkWN (compoundN "lintu" (k6 "bongari")) ; --UNCHK
lin birdbath_N = mkWN (compoundN "lintu" (k41A "allas")) ; --UNCHK
lin birdcage_N = mkWN (compoundN "lintu" (k5A "häkki")) ; --UNCHK
lin birdcall_N = mkWN (compoundN "linnunlaulu" (k48A "laite")) ; --UNCHK
lin birdhouse_N = mkWN (compoundN "lintu" (k9 "tarha")) ; --UNCHK
lin birdie_N = mkWN (compoundN "sulka" (k1 "pallo")) ; --UNCHK
lin birdlime_N = mkWN (compoundN "linnun" (k9 "liima")) ; --UNCHK
lin birdnesting_N = mkWN "linnunpesien" "etsiminen" ; --UNCHK
lin birefringent_A = mkWA (compoundA "kahtais" (k38 "taitteinen")) ; --UNCHK
lin biretta_N = mkWN "biretta" ; --UNCHK
lin birkenhead_PN = foreignPN "Birkenhead" ;
lin birling_N = mkWN (compoundN "tukin" (k39 "pyöritys")) ; --UNCHK
lin biro_N = mkWN (compoundN "kuula" (k10 "kynä")) ; --UNCHK
lin birr_N = mkWN (k12 "humina") ; --UNCHK
lin birth_N = mkWN (k10 "syntymä") ; --UNCHK
lin birth_control_N = mkWN (k2 "säännöstely") "syntyvyyden" ; --UNCHK
lin birthday_N = mkWN (compoundN "syntymä" (k10 "päivä")) ;
lin birthmark_N = mkWN (kH1 "luomi") ; --UNCHK
lin birthplace_N = mkWN (compoundN "syntymä" (k9A "paikka")) ; --UNCHK
lin birthrate_N = mkWN (k40 "fertiiliys") ; --UNCHK
lin birthwort_N = mkWN (compoundN "piippu" (k1 "ruoho")) ; --UNCHK
lin birtley_PN = foreignPN "Birtley" ;
lin biscuit_N = mkWN (kH1 "keksi") ; --UNCHK
lin bise_N = mkWN (k9 "viima") ; --UNCHK
lin bisect_V2 = mkWV2 (k53A "puolittaa") ; --UNCHK
lin bisection_N = mkWN (k99 "kahtia") "jakaminen" ; --UNCHK
lin biserrate_A = mkWA (compoundA "kaks" (k38 "ihampainen")) ; --UNCHK
lin bisexual_A = mkWA (compoundA "biseksua" (k38 "alinen")) ; --UNCHK
lin bisexuality_N = mkWN (k40 "biseksuaalisuus") ; --UNCHK
lin bishop_N = mkWN (k5A "lähetti") ; --UNCHK
lin bishopbriggs_PN = foreignPN "Bishopbriggs" ;
lin bishopric_N = mkWN (compoundN "piispan" (k9A "virka")) ; --UNCHK
lin bishopry_N = mkWN (k9A "virka") "piispan" ; --UNCHK
lin bismuth_N = mkWN (k5A "vismutti") ; --UNCHK
lin bismuthal_A = mkWA (compoundA "vismutti" (k38 "nen")) ; --UNCHK
lin bismuthic_A = mkWA "vismutti-" ; --UNCHK
lin bison_N = mkWN (k6 "biisoni") ; --UNCHK
lin bisontine_A = mkWA "biisonin" ; --UNCHK
lin bisque_N = mkWN (k1A "keitto") ; --UNCHK
lin bister_N = mkWN (compoundN "maali" (k5 "väri")) "ruskea" ; --UNCHK
lin bistered_A = mkWA (k15 "ruskea") ; --UNCHK
lin bistro_N = mkWN (k1 "bistro") ; --UNCHK
lin bistroic_A = mkWA "bistron" ; --UNCHK
lin bit_N = mkN "palanen" | mkN "bitti" ; ---- split
lin bitartrate_N = mkWN "vetytartraatti" ; --UNCHK
lin bitch_N = mkWN (k1A "narttu") ; --UNCHK
lin bitch_V = mkWV (k53A "valittaa") ; --UNCHK
lin bitchery_N = mkWN "narttumaisuus" ; --UNCHK
lin bitchy_A = mkWA (k15 "ilkeä") ; --UNCHK
lin bite_N = mkWN (k9 "pala") ; --UNCHK
lin bite_V = mkV "purra" ; --UNCHK
lin bite_V2 = L.bite_V2 ;
lin biter_N = mkWN (k12 "purija") ; --UNCHK
lin bitewing_N = mkWN (compoundN "hammas" (k5 "röntgen")) ; --UNCHK
lin biting_A = mkWA (k10 "pureva") ; --UNCHK
lin bitmap_N = mkWN (k10 "kuva") "elektroninen" ; --UNCHK
lin bitok_N = mkWN "bitok" ; --UNCHK
lin bitter_A = mkWA (k10 "katkera") ; --UNCHK
lin bitter_N = mkWN (k40 "kitkeryys") ; --UNCHK
lin bittercress_N = mkWN (compoundN "puro" (k14A "litukka")) ; --UNCHK
lin bitterish_A = mkWA "kitkerähkö" ; --UNCHK
lin bittern_N = mkWN (compoundN "kaulus" (k12 "haikara")) ; --UNCHK
lin bitterness_N = mkWN (k40 "piikikkyys") ; --UNCHK
lin bitternut_N = mkWN (compoundN "karvas" (k6 "hikkori")) ; --UNCHK
lin bitterroot_N = mkWN (compoundN "rediv" (k9 "iva")) "Lewisia" ; --UNCHK
lin bitters_N = mkWN (k2 "katkero") ; --UNCHK
lin bitter_sweet_A = mkWA (compoundA "katkeran" (k38 "suloinen")) ; --UNCHK
lin bittersweet_N = mkWN (compoundN "amerikankelas" (k39 "köynnös")) ; --UNCHK
lin bitthead_N = mkWN (k18 "pää") "pollarin" ; --UNCHK
lin bitty_A = mkWA (k38 "pikkuriikkinen") ; --UNCHK
lin bitumastic_N = mkWN "bitumi-" ; --UNCHK
lin bitumen_N = mkWN (k6 "bitumi") ; --UNCHK
lin bituminoid_A = mkWA "bituminoidi" ; --UNCHK
lin bituminous_A = mkWA (compoundA "bitumipi" (k38 "toinen")) ; --UNCHK
lin bivalent_A = mkWA (compoundA "kahden" (k38 "arvoinen")) ; --UNCHK
lin bivalve_A = mkWA (compoundA "kaks" (k38 "ikuorinen")) ; --UNCHK
lin bivalve_N = mkWN (k38 "nilviäinen") "kaksikuorinen" ; --UNCHK
lin bivariate_A = mkWA "kahden" "muuttujan" ; --UNCHK
lin bivouac_N = mkWN (k5 "leiri") ; --UNCHK
lin bivouac_V = mkWV (k52A "leiriytyä") ; --UNCHK
lin biz_N = mkWN (k39 "bisnes") ; --UNCHK
lin bizarre_A = mkWA (k38 "merkillinen") ; --UNCHK
lin bizonal_A = mkWA (compoundA "kaksi" (k38 "vyöhykkeinen")) ; --UNCHK
lin blab_V = mkWV (k62 "vasikoida") ; --UNCHK
lin blab_V2 = mkWV2 (k62 "vasikoida") ; --UNCHK
lin blabber_V = mkWV (k53A "pälättää") ; --UNCHK
lin blabber_V2 = mkWV2 (k53A "pälättää") ; --UNCHK
lin blabbermouth_N = mkWN (k1A "lörppö") ; --UNCHK
lin blabbermouthed_A = mkWA (k1A "lörppö") ; --UNCHK
lin black_A = L.black_A ;
lin black_N = mkWN (k10 "musta") ; --f69
lin black_V2 = mkWV2 (k52 "mustua") ; --UNCHK
lin black_lead_N = mkWN (k5A "grafiitti") ; --UNCHK
lin black_out_V = mkWV (k52A "pyörtyä") ; --UNCHK
lin blackamoor_N = mkWN (k6 "neekeri") ; --UNCHK
lin blackball_V2 = mkWV2 (k53A "käyttää") "veto-oikeutta" ; --UNCHK
lin blackberry_N = mkWN (compoundN "karhun" (k14A "vatukka")) ; --UNCHK
lin blackbird_N = mkWN (k50 "mustarastas") ; --UNCHK
lin blackboard_N = mkWN (k1 "taulu") ; --UNCHK
lin blackbuck_N = mkWN (compoundN "besoaari" (k5A "antilooppi")) ; --UNCHK
lin blackburn_PN = foreignPN "Blackburn" ;
lin blackcap_N = mkWN (compoundN "mustapää" (k1A "kerttu")) ; --UNCHK
lin blackcock_N = mkWN (k26 "teeri") ; --UNCHK
lin blacken_V = mkWV (k52 "mustua") ; --UNCHK
lin blacken_V2 = mkWV2 (k52 "mustua") ; --UNCHK
lin blackface_N = mkWN (compoundN "musta" (k9 "naama")) ; --UNCHK
lin blackfish_N = mkWN (compoundN "pitkäeväpallo" (k18 "pää")) ; --UNCHK
lin blackfly_N = mkWN (k38 "mäkäräinen") ; --UNCHK
lin blackguard_N = mkWN (k1 "roisto") ; --UNCHK
lin blackguard_V2 = mkWV2 (k73A "loukata") ; --UNCHK
lin blackguardly_A = mkWA (k38 "konnamainen") ; --UNCHK
lin blackhead_N = mkWN (compoundN "musta" (k18 "pää")) ; --UNCHK
lin blackheart_N = mkWN (k14A "kirsikka") ; --UNCHK
lin blacking_N = mkWN (compoundN "kenkä" (k48A "voide")) ; --UNCHK
lin blackish_A = mkWA (k10 "tumma") ; --UNCHK
lin blackjack_N = mkWN (k5A "ventti") ; --UNCHK
lin blackleg_N = mkWN (k10A "rotta") ; --UNCHK
lin blackleg_V = mkWV (k52A "rikkoa") "lakkoa" ; --UNCHK
lin blackleg_V2 = mkWV2 (k52A "rikkoa") "lakkoa" ; --UNCHK
lin blacklist_N = mkWN (k9 "lista") "musta" ; --UNCHK
lin blackmail_N = mkWN (k39 "kiristys") ; --UNCHK
lin blackmail_V2 = mkWV2 (k53 "kiristää") ; --UNCHK
lin blackmailer_N = mkWN (k10 "kiristäjä") ; --UNCHK
lin blackness_N = mkWN (k40 "mustuus") ; --UNCHK
lin blackout_N = mkWN (k40 "muistamattomuus") ; --UNCHK
lin blackpool_PN = foreignPN "Blackpool" ;
lin blackshirt_N = mkWN (k50 "mustapaita") ; --UNCHK
lin blacksmith_N = mkWN (k10A "seppä") ; --UNCHK
lin blacksnake_N = mkWN (compoundN "nuoli" (k48 "käärme")) ; --UNCHK
lin blackthorn_N = mkWN (compoundN "ora" (k10 "pihlaja")) ; --UNCHK
lin blacktop_N = mkWN (k5A "asfaltti") ; --UNCHK
lin blackwash_N = mkWN (compoundN "kengän" (k48 "muste")) ; --UNCHK
lin blackwater_N = mkWN (compoundN "mustavesi" (k48 "kuume")) ; --UNCHK
lin blackwood_N = mkWN (compoundN "musta" (k18 "puu")) ; --UNCHK
lin blackwood_PN = foreignPN "Blackwood" ;
lin bladder_N = mkWN (compoundN "sisä" (k5 "kumi")) ; --UNCHK
lin bladderpod_N = mkWN (compoundN "yrtti" (k5 "kasvi")) ; --UNCHK
lin bladderwort_N = mkWN (compoundN "vesi" (k48 "herne")) ; --UNCHK
lin bladderwrack_N = mkWN (compoundN "rakko" (k10 "levä")) ; --UNCHK
lin bladdery_A = mkWA (k38 "rakkulamainen") ; --UNCHK
lin blade_N = mkWN (k10 "terä") ; --UNCHK
lin bladed_A = mkWA (compoundA "terä" (k38 "inen")) ; --UNCHK
lin blae_A = mkWA (compoundA "harmaan" (k38 "sininen")) ; --UNCHK
lin blaeberry_N = mkWN (k14A "mustikka") ; --UNCHK
lin blaenavon_PN = foreignPN "Blaenavon" ;
lin blah_N = mkWN (k5 "humpuuki") ; --UNCHK
lin blahs_N = mkWN "plääh" ; --UNCHK
lin blain_N = mkWN (k12 "rakkula") ; --UNCHK
lin blairgowrie_PN = foreignPN "Blairgowrie" ;
lin blame_N = mkWN (k48A "moite") ; --UNCHK
lin blame_V = mkV "syyttää" ;
lin blame_V2 = mkV2 "syyttää" partitive ;
lin blameless_A = mkWA (k10 "luotettava") ; --UNCHK
lin blamelessness_N = mkWN (k40 "viattomuus") ; --UNCHK
lin blameworthiness_N = mkWN (k40 "syyllisyys") ; --UNCHK
lin blameworthy_A = mkWA (k38 "rikollinen") ; --UNCHK
lin blanc_N = mkWN (k48A "kastike") ; --UNCHK
lin blanch_V = mkWV (k72 "vaaleta") ; --UNCHK
lin blanch_V2 = mkWV2 (k72 "vaaleta") ; --UNCHK
lin blancmange_N = mkWN (compoundN "maito" (k2 "hyytelö")) ; --UNCHK
lin bland_A = mkA "mieto" ;
lin blandishment_N = mkWN (k2 "houkuttelu") ; --UNCHK
lin blandness_N = mkWN (k40 "värittömyys") ; --UNCHK
lin blank_A = mkWA (k34A "ilmeetön") ;
lin blank_N = mkWN (k13 "paukkupatruuna") ; --UNCHK
lin blank_out_V = mkWV (k53 "poistaa") ; --UNCHK
lin blank_out_V2 = mkWV2 (k53 "poistaa") ; --UNCHK
lin blanket_N = mkWN (k1A "peitto") ;
lin blanket_V2 = mkWV2 (k53A "peittää") ; --UNCHK
lin blankness_N = mkWN (k40 "tyhjyys") ; --UNCHK
lin blanquillo_N = mkWN (k9 "kala") ; --UNCHK
lin blantyre_PN = foreignPN "Blantyre" ;
lin blare_N = mkWN (k1 "melu") ; --UNCHK
lin blare_V = mkWV (k52 "ulvoa") ; --UNCHK
lin blare_V2 = mkWV2 (k52 "ulvoa") ; --UNCHK
lin blare_out_V = mkWV (k53 "julistaa") "äänekkäästi" ; --UNCHK
lin blarney_N = mkWN (k2 "suostuttelu") ; --UNCHK
lin blase_A = mkWA (compoundA "välin" (k34A "pitämätön")) ; --UNCHK
lin blaspheme_V = mkWV (k73A "pilkata") "Jumalaa" ; --UNCHK
lin blaspheme_V2 = mkWV2 (k73A "pilkata") "Jumalaa" ; --UNCHK
lin blasphemer_N = mkWN (k10 "rienaaja") ; --UNCHK
lin blasphemous_A = mkWA (k1 "rivo") ; --UNCHK
lin blasphemy_N = mkWN (k39 "häväistys") ; --UNCHK
lin blast_N = mkN "purkaus" ; --mkWN (k5A "lyönti") "pitkä" ;
lin blast_V = mkWV (k67 "turmella") ; --UNCHK
lin blast_V2 = mkWV2 (k67 "turmella") ; --UNCHK
lin blast_furnace_N = mkWN (k5 "masuuni") ; --UNCHK
lin blast_off_V = mkWV (k66 "nousta") "ilmaan" ; --UNCHK
lin blastema_N = mkWN (compoundN "blas" (k9 "teema")) ; --UNCHK
lin blastemal_A = mkWA (compoundA "blastema" (k38 "alinen")) ; --UNCHK
lin blaster_N = mkWN (k10 "panostaja") ; --UNCHK
lin blastocoel_N = mkWN (k2 "ontelo") "blastulan" ; --UNCHK
lin blastocyst_N = mkWN (compoundN "alkio" (k12 "rakkula")) ; --UNCHK
lin blastocyte_N = mkWN (k1 "solu") "erilaistumaton" "sikiökautinen" ; --UNCHK
lin blastoderm_N = mkWN (compoundN "ulko" (k39 "kerros")) "blastulan" ; --UNCHK
lin blastodermatic_A = mkWA "blastodermi-" ; --UNCHK
lin blast_off_N = mkWN (k1A "lähtö") ; --UNCHK
lin blastogenesis_N = mkWN "blastogeneesi" ; --UNCHK
lin blastogenetic_A = mkWA (compoundA "blasto" (k38 "geneettinen")) ; --UNCHK
lin blastomeric_A = mkWA "blastomeeri-" ; --UNCHK
lin blastomycete_N = mkWN (compoundN "rakkula" (k26 "sieni")) ; --UNCHK
lin blastomycosis_N = mkWN "rakkulasienitauti" ; --UNCHK
lin blastomycotic_A = mkWA "blastomykoottinen" ; --UNCHK
lin blastopore_N = mkWN (k1A "aukko") "blastulan" "keskusontelon" ; --UNCHK
lin blastospheric_A = mkWA "blastulaan" "liittyvä" ; --UNCHK
lin blatancy_N = mkWN (k40 "räikeys") ; --UNCHK
lin blatant_A = mkWA (k10 "meluisa") ; --UNCHK
lin blather_N = mkWN (k1A "pöty") ; --UNCHK
lin blather_V = mkWV (k53A "lässyttää") ; --UNCHK
lin blaxploitation_N = mkWN (compoundN "hyvä" (k38 "ksikäyttäminen")) "mustien" ; --UNCHK
lin blaze_V = mkWV (k53 "loistaa") ; --UNCHK
lin blaze_V2 = mkWV2 (k53 "loistaa") ; --UNCHK
lin blaze_away_V = mkWV (k52 "puhua") ; --UNCHK
lin blazer_N = mkWN (k6 "bleiseri") ; --UNCHK
lin blazon_N = mkWN (k12 "vaakuna") ; --UNCHK
lin blazon_V2 = mkWV2 (k67 "koristella") ; --UNCHK
lin blazonry_N = mkWN (k12 "vaakuna") ; --UNCHK
lin bleach_N = mkWN (k2 "valkaisu") ; --UNCHK
lin bleach_V = mkWV (k66 "valkaista") ; --UNCHK
lin bleach_V2 = mkWV2 (k66 "valkaista") ; --UNCHK
lin bleacher_N = mkWN (compoundN "valkai" (k9 "sija")) ; --UNCHK
lin bleachers_N = mkWN (compoundN "avo" (k2 "katsomo")) ; --UNCHK
lin bleaching_powder_N = mkWN (kH1 "kalkki") "kloorattu" ; --UNCHK
lin bleak_A = mkWA (k1A "kolkko") ; --UNCHK
lin bleakness_N = mkWN (k40 "karuus") ; --UNCHK
lin bleary_A = mkWA (k10 "hämärä") ; --UNCHK
lin bleat_N = mkWN (k9A "määintä") ; --UNCHK
lin bleat_V = mkWV (k61A "määkiä") ; --UNCHK
lin bleat_V2 = mkWV2 (k61A "määkiä") ; --UNCHK
lin blebbed_A = mkWA (k38 "rakkulainen") ; --UNCHK
lin blebby_A = mkWA (k38 "rakkulainen") ; --UNCHK
lin bleed_V = mkV (mkV "vuotaa") "verta" ;
lin bleed_V2 = variants {} ; -- mkV (mkV "vuotaa") "verta" ;
lin bleed_VS = variants {} ; -- mkV (mkV "vuotaa") "verta" ;
lin bleeding_N = mkWN (k1A "vuoto") ; --UNCHK
lin bleep_N = mkWN (k39 "piipitys") ; --UNCHK
lin bleep_V = mkWV (k53A "piipittää") ; --UNCHK
lin blemish_N = mkWN (kH1 "vika") ; --UNCHK
lin blemish_V2 = mkWV2 (k73 "tahrata") ; --UNCHK
lin blench_V = mkWV (k72 "vaaleta") ; --UNCHK
lin blend_N = mkWN "yhdistäminen" ; --UNCHK
lin blend_V = mkWV (k52A "sulautua") ; --UNCHK
lin blend_V2 = mkWV2 (k52A "sulautua") ; --UNCHK
lin blender_N = mkWN (compoundN "teho" (k33A "sekoitin")) ; --UNCHK
lin blenny_N = mkWN (k9 "kala") "suomuton" ; --UNCHK
lin blepharism_N = mkWN (k39 "räpytys") "silmän" ; --UNCHK
lin blepharitis_N = mkWN (compoundN "luomi" (k39 "tulehdus")) ; --UNCHK
lin blepharospasm_N = mkWN (compoundN "blefaro" (k5 "spasmi")) ; --UNCHK
lin bless_V2 = mkWV2 (k73 "siunata") ; --UNCHK
lin blessedly_Adv = mkWAdv "siunatusti" ; --UNCHK
lin blessedness_N = mkWN (k7 "onni") "ylenpalttinen" ; --UNCHK
lin blessing_N = mkWN (k39 "siunaus") ;
lin bletchley_PN = foreignPN "Bletchley" ;
lin blether_N = mkWN (k12 "höpinä") ; --UNCHK
lin bletia_N = mkWN (k13 "orkidea") ; --UNCHK
lin bleu_N = mkWN (kH1 "aura") ; --UNCHK
lin blewits_N = mkWN (k13 "valmuska") ; --UNCHK
lin blidworth_PN = foreignPN "Blidworth" ;
lin blight_N = mkWN (compoundN "ruoste" (k26 "sieni")) ; --UNCHK
lin blight_V2 = mkWV2 (k67 "turmella") ; --UNCHK
lin blighter_N = mkWN (k5 "kundi") ; --UNCHK
lin blighty_N = mkWN (compoundN "koti" (k18 "maa")) ; --UNCHK
lin blimp_N = mkWN (compoundN "ilma" (k9 "laiva")) ; --UNCHK
lin blimpish_A = mkWA (k38 "taantumuksellinen") ; --UNCHK
lin blind_A = mkA "sokea" ; --mkWA (k34A "varaukseton") ;
lin blind_N = mkWN (k1 "verho") ; --UNCHK
lin blind_V2 = mkWV2 (k54A "hämärtää") ; --UNCHK
lin blindman's_buff_N = mkWN (k1A "sokko") ; --UNCHK
lin blindness_N = mkWN (k40 "sokeus") ; --UNCHK
lin blindworm_N = mkWN (k13 "vaskitsa") ; --UNCHK
lin bling_N = mkWN (k1 "koru") ; --UNCHK
lin blini_N = mkWN (k5 "blini") ; --UNCHK
lin blink_N = mkN "silmänräpäys" ; ---ARB
lin blink_V = mkWV (k53A "räpyttää") ; --UNCHK
lin blink_V2 = mkWV2 (k53A "räpyttää") ; --UNCHK
lin blinker_N = mkWN (k1A "vilkku") ; --UNCHK
lin blinks_N = mkWN (compoundN "hete" (k5 "kaali")) ; --UNCHK
lin blintz_N = mkWN "blintze" ; --UNCHK
lin blip_N = mkWN (kH1 "maali") "tutkan" ; --UNCHK
lin bliss_N = mkWN (k41 "taivas") "seitsemäs" ; --UNCHK
lin blissful_A = mkWA (k38 "onnellinen") ; --UNCHK
lin blister_N = mkWN (k12 "rakkula") ; --UNCHK
lin blister_V = mkWV (k66 "nousta") "rakkuloille" ; --UNCHK
lin blister_V2 = mkWV2 (k66 "nousta") "rakkuloille" ; --UNCHK
lin blithe_A = mkWA (k41A "riemukas") ; --UNCHK
lin blithesome_A = mkWA (k41A "riemukas") ; --UNCHK
lin blitz_N = mkWN (compoundN "salama" (k10A "sota")) ; --UNCHK
lin blizzard_N = mkWN (k1 "vyöry") ; --UNCHK
lin bloat_N = mkWN (k1 "ähky") ; --UNCHK
lin bloated_A = mkA "paisuteltu" ;
lin bloater_N = mkWN (compoundN "savu" (k5 "silli")) ; --UNCHK
lin blob_N = mkWN (k1A "möykky") ; --UNCHK
lin bloc_N = mkWN (k10 "ryhmittymä") ; --UNCHK
lin block_N = mkN "blokki" ;
lin block_V2 = mkWV2 (k58A "sulkea") ; --f88
lin block_in_V2 = prepV2 (lin V OP_block_V2) OP_in_Prep ; -- guess-p-verb
lin block_off_V2 = mkWV2 (k61A "tukkia") "kulku" ; --UNCHK
lin block_out_V2 = mkWV2 (k67A "suunnitella") ; --UNCHK
lin block_up_V2 = mkWV2 (k74A "teljetä") ; --UNCHK
lin blockade_N = mkWN (k39 "piiritys") ; --UNCHK
lin blockade_V2 = mkWV2 (k58A "sulkea") ; --UNCHK
lin blockading_A = mkWA "saartava" ; --UNCHK
lin blockage_N = mkWN (k10 "tukkeutuma") ; --UNCHK
lin blockbuster_N = mkWN (k5A "hitti") ; --UNCHK
lin blocker_N = mkWN (k10 "salpaaja") ; --UNCHK
lin blockhead_N = mkWN (k1 "tollo") ; --UNCHK
lin blockheaded_A = mkWA (kH1 "mäntti") ; --UNCHK
lin blockhouse_N = mkWN (k10A "tukikohta") ; --UNCHK
lin blocking_N = mkWN "torjuminen" ; --UNCHK
lin blockish_A = mkWA (k38 "kuutiomainen") ; --UNCHK
lin blogger_N = mkWN (k10 "kirjoittaja") "verkkopäiväkirjan" ; --UNCHK
lin bloke_N = mkWN (k5 "kundi") ; --UNCHK
lin blolly_N = mkWN (k9 "alba") "Chiococca" ; --UNCHK
lin blond_A = mkWA (k15 "vaalea") ; --UNCHK
lin blond_N = mkWN (k15 "vaalea") ; --UNCHK
lin blonde_A = mkWA (k15 "vaalea") ; --UNCHK
lin blonde_N = mkWN (k15 "vaalea") ; --UNCHK
lin blood_N = L.blood_N ;
lin blood_V2 = mkWV2 (k61 "tuhria") "verellä" ;
lin blood_donor_N = mkWN (compoundN "veren" (k10 "luovuttaja")) ; --UNCHK
lin blood_group_N = mkWN (compoundN "veri" (k10 "ryhmä")) ; --UNCHK
lin blood_heat_N = mkWN (compoundN "ruumiinlämpö" (k9 "tila")) ; --UNCHK
lin blood_money_N = mkWN (k3 "palkkio") "palkkamurhaajan" ; --UNCHK
lin blood_poisoning_N = mkWN (compoundN "veren" (k39 "myrkytys")) ; --UNCHK
lin blood_pressure_N = mkWN (compoundN "veren" (k48 "paine")) ; --UNCHK
lin blood_relation_N = mkWN (k38 "sukulainen") ; --UNCHK
lin blood_transfusion_N = mkWN (compoundN "veren" (k1A "siirto")) ; --UNCHK
lin blood_type_N = mkWN (compoundN "veri" (k10 "ryhmä")) ; --UNCHK
lin blood_vessel_N = mkWN (compoundN "veri" (k26 "suoni")) ; --UNCHK
lin blood_bath_N = mkWN (compoundN "veri" (k1 "löyly")) ; --UNCHK
lin bloodberry_N = mkWN (compoundN "huone" (k5 "kasvi")) ; --UNCHK
lin bloodcurdling_A = mkWA (k38 "painajaismainen") ; --UNCHK
lin bloodguilt_N = mkWN "syyllinen" "verenvuodatukseen" ; --UNCHK
lin bloodguilty_A = mkWA (k38 "syyllinen") "verenvuodatukseen" ; --UNCHK
lin bloodhound_N = mkWN (compoundN "vihi" (k10 "koira")) ; --UNCHK
lin bloodiness_N = mkWN (k40 "verenhimoisuus") ; --UNCHK
lin bloodleaf_N = mkWN (compoundN "puna" (k7A "lehti")) ; --UNCHK
lin bloodless_A = mkWA (k34A "veretön") ; --UNCHK
lin blood_letting_N = mkWN (compoundN "veri" (k1 "löyly")) ; --UNCHK
lin bloodlust_N = mkWN (k1 "halu") "tappamisen" ; --UNCHK
lin bloodmobile_N = mkWN (compoundN "verenluovutus" (k1 "auto")) ; --UNCHK
lin bloodroot_N = mkWN (k26 "verijuuri") ; --UNCHK
lin bloodshed_N = mkWN (k26 "veri") ; --UNCHK
lin bloodshot_A = mkWA "verestävä" ; --UNCHK
lin bloodstain_N = mkWN (compoundN "veri" (k9 "tahra")) ; --UNCHK
lin bloodstained_A = mkWA (k10 "kammottava") ; --UNCHK
lin bloodstone_N = mkWN (k5A "heliotrooppi") ; --UNCHK
lin bloodstream_N = mkWN (compoundN "veren" (k1A "kierto")) ; --UNCHK
lin bloodsucker_N = mkWN (k12 "verenimijä") ; --UNCHK
lin bloodsucking_A = mkWA "verta" "imevä" ; --UNCHK
lin bloodthirstiness_N = mkWN (k40 "verenhimoisuus") ; --UNCHK
lin bloodthirsty_A = mkWA (k38 "verinen") ; --UNCHK
lin bloodworm_N = mkWN (compoundN "surviais" (k7 "sääski")) ; --UNCHK
lin bloodwort_N = mkWN (compoundN "ranta" (k7A "sappi")) ; --UNCHK
lin bloody_A = mkA "verinen" ;
lin bloody_Adv = mkWAdv (compoundAdv "pahuk" (k99 "sen")) ; --UNCHK
lin bloom_N = mkWN (k10 "härmä") ; --UNCHK
lin bloom_V = mkWV (k67 "olla") "kukassa" ; --UNCHK
lin bloomer_N = mkWN (k48 "virhe") ; --UNCHK
lin blooming_N = mkWN (k10A "kukka") ; --UNCHK
lin blossom_N = mkWN (k9A "kukinta") ; --UNCHK
lin blossom_V = mkWV (k53 "kukoistaa") ; --UNCHK
lin blossoming_N = mkWN (k9A "kukinta") ; --UNCHK
lin blot_N = mkWN (k10A "läikkä") ; --UNCHK
lin blot_V2 = mkWV2 (k61 "tahria") ; --UNCHK
lin blot_out_V = mkWV (k74 "verhota") ; --UNCHK
lin blotch_N = mkWN (k10A "läikkä") ; --UNCHK
lin blotched_A = mkWA (k41A "läikikäs") ; --UNCHK
lin blotchy_A = mkWA (k41A "läikikäs") ; --UNCHK
lin blotter_N = mkWN (compoundN "rikos" (k6 "rekisteri")) ; --UNCHK
lin blotting_paper_N = mkWN (compoundN "imu" (k6 "paperi")) ; --UNCHK
lin blotto_A = mkWA (k10 "oleva") "tillin-tallin" ; --UNCHK
lin blouse_N = mkWN (k2 "pusero") ; --UNCHK
lin blow_N = mkWN (k7A "henki") ;
lin blow_V = L.blow_V ;
lin blow_V2 = mkWV2 (k54A "puhaltaa") ; --UNCHK
lin blow_away_V = advV OP_blow_V OP_away_Adv ; -- guess-p-verb
lin blow_away_V2 = mkV2 (advV OP_blow_V OP_away_Adv ) ; -- guess-p-verb
lin blow_down_V2 = prepV2 OP_blow_V OP_down_Prep ; -- guess-p-verb
lin blow_dry_V2 = variants {} ; -- guess-p-verb
lin blow_in_V = advV OP_blow_V OP_in_Adv ; -- guess-p-verb
lin blow_off_V = advV OP_blow_V OP_off_Adv ; -- guess-p-verb
lin blow_off_V2 = prepV2 OP_blow_V OP_off_Prep ; -- guess-p-verb
lin blow_out_V2 = mkWV2 (k52A "särkyä") ; --UNCHK
lin blow_over_V = mkWV (k72A "heiketä") ; --UNCHK
lin blow_up_V = mkWV (k54A "suurentaa") ; --UNCHK
lin blow_up_V2 = mkWV2 (k54A "suurentaa") ; --UNCHK
lin blowback_N = mkWN (compoundN "taka" (k1 "isku")) ; --UNCHK
lin blower_N = mkWN (k41A "nisäkäs") "valaansukuinen" ; --UNCHK
lin blowfish_N = mkWN (compoundN "pallo" (k9 "kala")) ; --UNCHK
lin blowfly_N = mkWN (compoundN "raato" (k38 "kärpänen")) ; --UNCHK
lin blowgun_N = mkWN (compoundN "puhallus" (k7 "putki")) ; --UNCHK
lin blowhole_N = mkWN (k1A "aukko") ; --UNCHK
lin blowing_N = mkWN (k39 "puhallus") ; --UNCHK
lin blowing_up_N = mkWN (compoundN "hauk" (k38 "kuminen")) ; --UNCHK
lin blowlamp_N = mkWN (compoundN "puhallus" (k1A "lamppu")) ; --UNCHK
lin blowpipe_N = mkWN (compoundN "puhallus" (k7 "putki")) ; --UNCHK
lin blowsy_A = mkWA (k14A "pönäkkä") ; --UNCHK
lin blowtorch_N = mkWN (compoundN "puhallus" (k1A "lamppu")) ; --UNCHK
lin blowtube_N = mkWN (compoundN "puhallus" (k7 "putki")) ; --UNCHK
lin blowy_A = mkWA (k38 "tuulinen") ; --UNCHK
lin blowzy_A = mkWA (k14A "pönäkkä") ; --UNCHK
lin blubber_N = mkWN (k5 "läski") ; --UNCHK
lin blubber_V = mkWV (k61 "nyyhkiä") ; --UNCHK
lin blubber_V2 = mkWV2 (k61 "nyyhkiä") ; --UNCHK
lin blubberer_N = mkWN (k10 "ruikuttaja") ; --UNCHK
lin blubbery_A = mkWA (k5 "läski") ; --UNCHK
lin blucher_N = mkWN (k10A "kenkä") ; --UNCHK
lin bludgeon_N = mkWN (k10 "nuija") ; --UNCHK
lin bludgeon_V2 = mkWV2 (k61 "nuijia") ; --UNCHK
lin bludgeoner_N = mkWN (k10 "hakkaaja") ; --UNCHK
lin blue_A = L.blue_A ;
lin blue_N = mkN "sinisyys" ;
lin blue_V2 = mkWV2 (k52A "värjäytyä") "siniseksi" ; --UNCHK
lin blue_collar_A = mkA "työläishenkinen" ;
lin bluebell_N = mkWN (compoundN "sini" (k1 "kello")) ; --UNCHK
lin blueberry_N = mkWN (k14A "mustikka") ; --UNCHK
lin bluebird_N = mkWN "sinikka" ; --UNCHK
lin bluebonnet_N = mkWN (k1A "hattu") "sininen" ; --UNCHK
lin bluebottle_N = mkWN (compoundN "raato" (k38 "kärpänen")) ; --UNCHK
lin bluecoat_N = mkWN (compoundN "sotilas" (k2 "henkilö")) ; --UNCHK
lin bluefin_N = mkWN (compoundN "tonni" (k9 "kala")) ; --UNCHK
lin bluefish_N = mkWN (compoundN "sini" (k9 "kala")) ; --UNCHK
lin bluegill_N = mkWN (compoundN "isoaurinko" (k32 "ahven")) ; --UNCHK
lin bluegrass_N = mkWN "bluegrass" ; --UNCHK
lin bluehead_N = mkWN (compoundN "sinipäähuuli" (k9 "kala")) ; --UNCHK
lin blue_jacket_N = mkWN (k42 "mies") "laivaston" ; --UNCHK
lin blueprint_N = mkWN (compoundN "sini" (k3 "kopio")) ;
lin blues_N = mkWN (k5 "blues") ; --UNCHK
lin bluestem_N = mkWN "Andropogon" "gerardii" ; --UNCHK
lin bluestocking_N = mkWN (compoundN "sini" (k10A "sukka")) ; --UNCHK
lin bluestone_N = mkWN "bluestone" ; --UNCHK
lin bluethroat_N = mkWN (compoundN "sini" (k9A "rinta")) ; --UNCHK
lin bluetick_N = mkWN (compoundN "pesukarhu" (k10 "koira")) "sininen" ; --UNCHK
lin bluetongue_N = mkWN (compoundN "sinikieli" (k5A "tauti")) ; --UNCHK
lin blueweed_N = mkWN (compoundN "neidon" (k26 "kieli")) ; --UNCHK
lin bluewing_N = mkWN (compoundN "sinisiipi" (k5 "tavi")) ; --UNCHK
lin bluff_A = mkWA (compoundA "suo" (k38 "rapuheinen")) ; --UNCHK
lin bluff_N = mkWN (k39 "bluffaus") ; --UNCHK
lin bluff_V = mkWV (k73 "hämätä") ; --UNCHK
lin bluff_V2 = mkWV2 (k73 "hämätä") ; --UNCHK
lin bluffer_N = mkWN "bluffaaja" ; --UNCHK
lin bluffness_N = mkWN "suorapuheisuus" ; --UNCHK
lin bluing_N = mkWN (compoundN "sini" (k5 "seksi")) "värjäys" ; --UNCHK
lin bluish_A = mkWA (k10 "sinertävä") ; --UNCHK
lin blunder_N = mkN "kömmähdys" ;
lin blunder_V = mkWV (k53A "täräyttää") ; --UNCHK
lin blunder_V2 = mkWV2 (k53A "täräyttää") ; --UNCHK
lin blunderbuss_N = mkWN (compoundN "väki" (k1 "pyssy")) ; --UNCHK
lin blunderer_N = mkWN (k10 "hutiloija") ; --UNCHK
lin blunt_A = mkWA (k1 "karu") ; --UNCHK
lin blunt_V2 = mkWV2 (k53 "latistaa") ;
lin bluntness_N = mkWN (k40 "tylsyys") ; --UNCHK
lin blur_N = mkWN (k40 "sumeus") ; --UNCHK
lin blur_V = mkWV (k52A "hämärtyä") ; --UNCHK
lin blur_V2 = mkV2 "hämärtää" ; --WV2 (k52A "hämärtyä") ;
lin blurb_N = mkWN (compoundN "mainos" (k5 "teksti")) ; --UNCHK
lin blurt_V2 = mkWV2 (k53A "täräyttää") ; --UNCHK
lin blurt_out_V2 = mkWV2 (k53A "täräyttää") ; --UNCHK
lin blush_N = mkWN (k39 "punastus") ; --UNCHK
lin blush_V = mkWV (k52 "punastua") ; --UNCHK
lin blushful_A = mkWA (k38 "punainen") ; --UNCHK
lin bluster_N = mkWN (k2 "mahtailu") ; --UNCHK
lin bluster_V = mkWV (k67 "ylvästellä") ; --UNCHK
lin bluster_V2 = mkWV2 (k67 "ylvästellä") ; --UNCHK
lin blustery_A = mkWA (k10 "myrskyisä") ; --UNCHK
lin blyth_PN = foreignPN "Blyth" ;
lin bmus_N = mkWN (k5A "kandidaatti") "musiikkitieteen" ; --UNCHK
lin bo'sun_N = mkWN (k1 "puosu") ; --UNCHK
lin boa_N = mkWN (compoundN "boa" (k48 "käärme")) ; --UNCHK
lin boa_constrictor_N = mkWN (compoundN "kuningas" (k10 "boa")) ; --UNCHK
lin boar_N = mkWN (k1 "karju") ; --UNCHK
lin board_1_N = mkN "taulu" ;
lin board_2_N = mkN "hallitus" | mkN "lautakunta" ;
lin board_N = mkN "hallitus" ;
lin board_V2 = mkWV2 (k53A "majoittaa") ; --UNCHK
lin board_up_V2 = mkWV2 (k53A "laudoittaa") ; --UNCHK
lin boarder_N = mkWN (k41 "oppilas") "sisäoppilaitoksen" ; --UNCHK
lin boarding_N = mkWN (k1 "nousu") ; --UNCHK
lin boarding_card_N = mkWN (compoundN "maihinnousu" (k5A "kortti")) ; --UNCHK
lin boarding_house_N = mkWN (k12 "asuntola") ; --UNCHK
lin boarding_school_N = mkWN "sisäoppilaitos" ; --UNCHK
lin boardroom_N = mkWN (compoundN "kokous" (k48 "huone")) ; --UNCHK
lin boards_N = mkWN (k5 "ränni") ; --UNCHK
lin boardwalk_N = mkWN (compoundN "kävely" (k19 "tie")) ; --UNCHK
lin boarfish_N = mkWN (compoundN "karju" (k9 "kala")) ; --UNCHK
lin boarhound_N = mkWN "mastiffi" ; --UNCHK
lin boast_N = mkWN (k50 "omakehu") ; --UNCHK
lin boast_V = mkWV (k67A "rehennellä") ;
lin boast_V2 = mkWV2 (k67A "rehennellä") ; --UNCHK
lin boast_VS = mkWVS (k67A "rehennellä") ;
lin boaster_N = mkWN (k6 "öykkäri") ; --UNCHK
lin boastful_A = mkWA (compoundA "itse" (k15 "tärkeä")) ; --UNCHK
lin boastfulness_N = mkWN (k40 "omahyväisyys") ; --UNCHK
lin boat_N = L.boat_N ;
lin boat_V = mkWV (k67 "veneillä") ; --UNCHK
lin boat_hook_N = mkWN (k5 "venekeksi") ; --UNCHK
lin boat_race_N = mkWN (compoundN "vene" (k2 "kilpailu")) ; --UNCHK
lin boat_train_N = mkWN (compoundN "laiva" (k10 "juna")) ; --UNCHK
lin boatbill_N = mkWN (compoundN "ruuhi" (k10A "nokka")) ; --UNCHK
lin boatbuilder_N = mkWN (compoundN "veneen" (k10 "rakentaja")) ; --UNCHK
lin boater_N = mkWN (compoundN "panama" (k1A "hattu")) ; --UNCHK
lin boat_house_N = mkWN (compoundN "vene" (k9 "vaja")) ; --UNCHK
lin boating_N = mkWN (k2 "veneily") ; --UNCHK
lin boatload_N = mkWN (compoundN "vaunu" (k5 "lasti")) ; --UNCHK
lin boatman_N = mkWN (k12 "purjehtija") ; --UNCHK
lin boatmanship_N = mkWN (compoundN "veneily" (k1A "taito")) ; --UNCHK
lin boatswain_N = mkWN (k1 "puosu") ; --UNCHK
lin boatyard_N = mkWN (compoundN "vene" (k2 "veistämö")) ; --UNCHK
lin bob_N = mkWN (k39 "nyökkäys") ; --UNCHK
lin bob_V = mkWV (k73A "leikata") "polkkatukka" ; --UNCHK
lin bob_V2 = mkWV2 (k73A "leikata") "polkkatukka" ; --UNCHK
lin bobbin_N = mkWN (k10 "rulla") ; --UNCHK
lin bobble_N = mkWN (k5A "haparointi") ; --UNCHK
lin bobby_N = mkWN (k6 "poliisi") ; --UNCHK
lin bobby_soxer_N = mkWN (k10 "käyttäjä") "nilkkasukkien" ; --UNCHK
lin bobcat_N = mkWN (compoundN "puna" (k39 "ilves")) ; --UNCHK
lin bobolink_N = mkWN (compoundN "riisi" (k38 "varpunen")) ; --UNCHK
lin bobsled_N = mkWN (compoundN "ratti" (k9A "kelkka")) ; --UNCHK
lin bobsledding_N = mkWN (k2 "kelkkailu") ; --UNCHK
lin bobsleigh_N = mkWN (compoundN "ratti" (k9A "kelkka")) ; --UNCHK
lin bobtail_A = mkWA (compoundA "töpö" (k38 "häntäinen")) ; --UNCHK
lin bobtail_N = mkWN (compoundN "töpö" (k10A "häntä")) ; --UNCHK
lin bobwhite_N = mkWN (compoundN "pelto" (k18 "pyy")) ; --UNCHK
lin bocce_N = mkWN "bocci" ; --UNCHK
lin bocconia_N = mkWN "Bocconia" "frutescens" ; --UNCHK
lin bochum_PN = foreignPN "Bochum" ;
lin bodacious_A = mkWA (k15 "röyhkeä") ; --UNCHK
lin bode_V = mkWV (k69 "merkitä") ; --UNCHK
lin bode_V2 = mkWV2 (k69 "merkitä") ; --UNCHK
lin bodega_N = mkWN (compoundN "lähi" (k9A "kauppa")) ; --UNCHK
lin bodice_N = mkWN (compoundN "ylä" (k10 "osa")) "puvun" ; --UNCHK
lin bodiless_A = mkWA (k34A "ruumiiton") ; --UNCHK
lin bodily_A = mkWA (k38 "ruumiillinen") ; --UNCHK
lin bodily_Adv = mkWAdv (k99 "ruumiillisesti") | adjAdv bodily_A ; --UNCHK -- derived
lin boding_N = mkWN (k39 "aavistus") ; --UNCHK
lin bodkin_N = mkWN (kH1 "naskali") ; --UNCHK
lin bodmin_PN = foreignPN "Bodmin" ;
lin body_N = mkN "ruumis" ;
lin body_servant_N = mkWN (compoundN "henki" (k12 "palvelija")) ; --UNCHK
lin body_snatcher_N = mkWN (compoundN "ruumiin" (k10 "ryöstäjä")) ; --UNCHK
lin bodybuilder_N = mkWN (compoundN "kehon" (k10 "rakentaja")) ; --UNCHK
lin bodybuilding_N = mkWN (k39 "harjoitus") "anaerobinen" ; --UNCHK
lin bodyguard_N = mkWN (compoundN "henki" (k1 "vartiosto")) ; --UNCHK
lin bodywork_N = mkWN (compoundN "kori" (k19 "työ")) ; --UNCHK
lin boer_N = mkWN (k5 "buuri") ; --UNCHK
lin boffin_N = mkWN (k12 "tutkija") ; --UNCHK
lin boffo_A = mkWA "menestyvä" ; --UNCHK
lin bog_N = mkWN (k9 "neva") ; --UNCHK
lin bog_V = mkWV (k52A "juuttua") "paikoilleen" ; --UNCHK
lin bog_V2 = mkWV2 (k52A "juuttua") "paikoilleen" ; --UNCHK
lin bog_down_V = mkWV (k52A "juuttua") "paikoilleen" ; --UNCHK
lin bogey_N = mkWN (compoundN "vihollis" (k48 "kone")) ; --UNCHK
lin bogeyman_N = mkWN (k1A "peikko") ; --UNCHK
lin boggle_V = mkWV (k53A "tyrmistyttää") ; --UNCHK
lin boggy_A = mkWA (k10 "vetelä") ; --UNCHK
lin bogie_N = mkWN (compoundN "vihollis" (k48 "kone")) ; --UNCHK
lin bogota_PN = foreignPN "Bogota" ;
lin bogus_A = mkWA (k10 "väärä") ; --UNCHK
lin bogy_N = mkWN (compoundN "vihollis" (k48 "kone")) ; --UNCHK
lin bohemian_A = mkWA "böömiläinen" ; --UNCHK
lin bohemian_N = mkWN (k5 "boheemi") ; --UNCHK
lin bohemianism_N = mkWN (compoundN "boheemi" (k10 "elämä")) ; --UNCHK
lin bohrium_N = mkWN "järjestysluku" "107" ; --UNCHK
lin boil_N = mkWN (compoundN "kiehumis" (k48 "piste")) ; --UNCHK
lin boil_V = mkWV (k53A "keittää") ; --UNCHK
lin boil_V2 = mkWV2 (k53A "keittää") ; --UNCHK
lin boil_down_V2 = mkWV2 (k53A "kiehuttaa") "vähiin" ; --UNCHK
lin boil_over_V = mkWV (k52 "kiehua") "yli" ; --UNCHK
lin boiler_N = mkWN (compoundN "höyry" (k12 "kattila")) ; --UNCHK
lin boilerplate_N = mkWN (compoundN "teräs" (k1 "levy")) ; --UNCHK
lin boilersuit_N = mkWN (compoundN "työ" (k5A "takki")) ; --UNCHK
lin boiling_Adv = mkWAdv "raivoisan" ; --UNCHK
lin boiling_N = mkWN (k1A "keitto") ; --UNCHK
lin boiling_point_N = mkWN (compoundN "kiehumis" (k48 "piste")) ; --UNCHK
lin boisterous_A = mkWA (k10 "kova") ; --UNCHK
lin boisterousness_N = mkWN (k40 "riehakkuus") ; --UNCHK
lin bola_N = mkWN "bola" ; --UNCHK
lin bold_1_A = mkWA (k41 "uskalias") ; --UNCHK
lin bold_2_A = mkWA (k41 "uskalias") ; --UNCHK
lin boldface_N = mkWN (k5A "lihavointi") ; --UNCHK
lin boldness_N = mkWN (k40 "uskaliaisuus") ; --UNCHK
lin bole_N = mkWN "bolanci" ; --UNCHK
lin bolero_N = mkWN (k2 "bolero") ; --UNCHK
lin bolete_N = mkWN (k5A "tatti") ; --UNCHK
lin bolide_N = mkWN (compoundN "tuli" (k1 "pallo")) ; --UNCHK
lin bolivar_N = mkWN "El" "Libertador" ; --UNCHK
lin bolivia_PN = foreignPN "Bolivia" ;
lin bolivian_A = mkWA (compoundA "bolivi" (k38 "alainen")) ; --UNCHK
lin bolivian_N = mkWN (compoundN "bolivi" (k38 "alainen")) ; --UNCHK
lin boliviano_N = mkWN "boliviano" ; --UNCHK
lin boll_N = mkWN "boll" ; --UNCHK
lin bollard_N = mkWN (kH1 "pollari") ; --UNCHK
lin bollington_PN = foreignPN "Bollington" ;
lin bollock_N = mkWN "bullock" "block" ; --UNCHK
lin bollworm_N = mkWN "bollworm" ; --UNCHK
lin bolo_N = mkWN (compoundN "bolo-" (k30 "veitsi")) ; --UNCHK
lin bologna_N = mkWN (k12 "makkara") "Bolognan" ; --UNCHK
lin bologna_PN = foreignPN "Bologna" ;
lin bologram_N = mkWN "bologrammi" ; --UNCHK
lin bolographic_A = mkWA "bolografinen" ; --UNCHK
lin bolometer_N = mkWN (compoundN "bolo" (k5 "metri")) ; --UNCHK
lin bolometric_A = mkWA (compoundA "bolo" (k38 "metrinen")) ; --UNCHK
lin boloney_N = mkWN (k5 "humpuuki") ; --UNCHK
lin bolshevik_N = mkWN (k5A "punikki") ; --UNCHK
lin bolshy_A = mkWA (k10 "hankala") ; --UNCHK
lin bolsover_PN = foreignPN "Bolsover" ;
lin bolster_N = mkWN (k1 "tyyny") ; --UNCHK
lin bolster_V = mkWV (k53 "vahvistaa") ; --UNCHK
lin bolster_V2 = mkWV2 (k53 "vahvistaa") ;
lin bolster_up_V2 = mkWV2 (k53 "vahvistaa") ; --UNCHK
lin bolt_Adv = mkWAdv (k99 "kankeasti") ; --UNCHK
lin bolt_N = mkN "pultti" ;
lin bolti_N = mkWN "Tilapia" "nilotica" ; --UNCHK
lin bolton_PN = foreignPN "Bolton" ;
lin bolus_N = mkWN "bolus" ; --UNCHK
lin bolzano_PN = foreignPN "Bolzano" ;
lin bomb_N = mkWN (kH1 "pommi") ;
lin bomb_V = mkWV (k53A "pommittaa") ; --UNCHK
lin bomb_V2 = mkV2 (mkV (lin VK {s = c53A "pommittaa"})) partitive ;
lin bomb_site_N = mkWN (compoundN "pommitus" (k48A "kohde")) ; --UNCHK
lin bombard_V2 = mkWV2 (k53A "pommittaa") ; --UNCHK
lin bombardier_N = mkWN (k10 "pommittaja") ; --UNCHK
lin bombardment_N = mkWN (k39 "pommitus") ; --UNCHK
lin bombardon_N = mkWN "bombard" ; --UNCHK
lin bombast_N = mkWN (k5 "humpuuki") ; --UNCHK
lin bombastic_A = mkWA (k38 "korkealentoinen") ; --UNCHK
lin bombazine_N = mkWN (k5 "pumasiini") ; --UNCHK
lin bomber_N = mkWN (compoundN "pommi" (k48 "kone")) ;
lin bombie_N = mkWN (k6 "suutari") ; --UNCHK
lin bombing_N = mkWN (k39 "pommitus") ; --UNCHK
lin bomblet_N = mkWN (k5 "rypälepommi") ; --UNCHK
lin bomb_proof_A = mkWA (compoundA "pommin" (k10 "kestävä")) ; --UNCHK
lin bombshell_N = mkWN (kH1 "pommi") ; --UNCHK
lin bomb_sight_N = mkWN (compoundN "tähtäys" (k48A "laite")) ; --UNCHK
lin bombycid_N = mkWN (compoundN "silkki" (k38 "perhonen")) ; --UNCHK
lin bon_mot_N = mkWN (k40 "sukkeluus") ; --UNCHK
lin bona_fide_A = mkWA (k38 "varsinainen") ; --UNCHK
lin bonanza_N = mkWN (k5A "jättipotti") ; --UNCHK
lin bonbon_N = mkWN (k5 "karamelli") ; --UNCHK
lin bond_N = mkN "sidos" ;
lin bond_V2 = mkWV2 (k52A "takertua") "jhk" ; --UNCHK
lin bondable_A = mkWA "liitettävä" ; --UNCHK
lin bond_holder_N = mkWN (k12 "haltija") "velkakirjan" ; --UNCHK
lin bonding_N = mkWN "liittäminen" ; --UNCHK
lin bondman_N = mkWN (k10 "orja") ; --UNCHK
lin bondsman_N = mkWN (k10 "orja") ; --UNCHK
lin bonduc_N = mkWN "Caesalpinia" "bonducella" ; --UNCHK
lin bondwoman_N = mkWN (compoundN "nais" (k10 "orja")) ; --UNCHK
lin bone_A = mkWA (k38 "luinen") ; --UNCHK
lin bone_N = L.bone_N ;
lin bone_V2 = mkWV2 (k53 "poistaa") "luut" ; --UNCHK
lin bone_dry_A = mkWA (compoundA "ruti" (k10 "kuiva")) ; --UNCHK
lin bone_up_V = mkWV (k56A "ahtaa") "päähänsä" ; --UNCHK
lin bonefish_N = mkWN (compoundN "nais" (k9 "kala")) ; --UNCHK
lin boneless_A = mkWA (k34A "luuton") ; --UNCHK
lin bonelike_A = mkWA (compoundA "luu" (k38 "mainen")) ; --UNCHK
lin bonemeal_N = mkWN (compoundN "luu" (k1 "jauho")) ; --UNCHK
lin boner_N = mkWN (k48 "virhe") ; --UNCHK
lin boneset_N = mkWN (compoundN "amerikanvalko" (k9 "latva")) ; --UNCHK
lin bone_setter_N = mkWN (k10 "niksauttaja") "luiden" ; --UNCHK
lin boneshaker_N = mkWN "kosla" ; --UNCHK
lin bonfire_N = mkWN (k1A "juhannuskokko") ; --UNCHK
lin bong_N = mkWN (k39 "kumahdus") ; --UNCHK
lin bongo_N = mkWN (k1 "bongo") ; --UNCHK
lin bonheur_N = mkWN (k7 "onni") ; --UNCHK
lin bonhomie_N = mkWN (k40 "sydämellisyys") ; --UNCHK
lin bonito_N = mkWN "juovaselkäsarda" ; --UNCHK
lin bonkers_A = mkWA (k1 "pöllö") ; --UNCHK
lin bonn_PN = foreignPN "Bonn" ;
lin bonnet_N = mkWN (k9A "hilkka") ; --UNCHK
lin bonny_A = mkWA (k15 "komea") ; --UNCHK
lin bonnybridge_PN = foreignPN "Bonnybridge" ;
lin bonnyrigg_PN = foreignPN "Bonnyrigg" ;
lin bonsai_N = mkWN "bonsai" ; --UNCHK
lin bonus_N = mkWN (k39 "bonus") ;
lin bony_A = mkWA (k38 "ruotoinen") ; --UNCHK
lin bonyness_N = mkWN (k40 "laihuus") ; --UNCHK
lin bonzer_A = mkWA (k10 "merkittävä") ; --UNCHK
lin boo_N = mkWN (k39 "tuhahdus") ; --UNCHK
lin boo_V = mkWV (k54A "viheltää") ; --UNCHK
lin boo_V2 = mkWV2 (k54A "viheltää") ; --UNCHK
lin boob_N = mkWN (k5 "nänni") ; --UNCHK
lin boob_V = mkWV (k73A "töpätä") ; --UNCHK
lin booby_N = mkWN (k10 "suula") ; --UNCHK
lin booby_trap_N = mkWN (k9 "miina") ; --UNCHK
lin boodle_N = mkWN (compoundN "kortti" (k5 "peli")) ; --UNCHK
lin booger_N = mkWN (k10A "räkä") ; --UNCHK
lin boogie_N = mkWN "boogie" "woogie" ; --UNCHK
lin book_N = L.book_N ;
lin book_V2 = mkV2 "varata" ; --mkWV2 (k53 "järjestää") ;
lin book_up_V = mkWV (k73 "varata") ; --UNCHK
lin bookable_A = mkWA (k10 "oleva") "varattavissa" ; --UNCHK
lin bookbinder_N = mkWN (compoundN "kirjan" (k10 "sitoja")) ; --UNCHK
lin bookbindery_N = mkWN (compoundN "kirjan" (k2 "sitomo")) ; --UNCHK
lin bookbinding_N = mkWN (compoundN "kirjan" (k9A "sidonta")) ; --UNCHK
lin bookcase_N = mkWN (compoundN "kirja" (k5A "kaappi")) ; --UNCHK
lin bookclub_N = mkWN (compoundN "kirja" (k1 "kerho")) ; --UNCHK
lin bookdealer_N = mkWN (compoundN "kirja" (k10 "myyjä")) ; --UNCHK
lin book_end_N = mkWN (compoundN "kirja" (k7A "tuki")) ; --UNCHK
lin booker_N = mkWN (compoundN "ohjelma" (k10 "myyjä")) ; --UNCHK
lin bookie_N = mkWN (compoundN "vedon" (k10 "välittäjä")) ; --UNCHK
lin booking_N = mkWN (k39 "varaus") ;
lin bookish_A = mkWA (compoundA "opin" (k38 "haluinen")) ; --UNCHK
lin bookishness_N = mkWN (compoundN "kirja" (k40 "viisaus")) ; --UNCHK
lin book_keeper_N = mkWN (compoundN "kirjan" (k10 "pitäjä")) ; --UNCHK
lin bookkeeping_N = mkWN (compoundN "kirjan" (k1A "pito")) ; --UNCHK
lin booklet_N = mkWN (k48A "esite") ;
lin booklouse_N = mkWN (compoundN "kirja" (k18 "täi")) ; --UNCHK
lin bookmaker_N = mkWN (compoundN "vedon" (k10 "välittäjä")) ; --UNCHK
lin bookmark_N = mkWN (compoundN "kirjan" (k5A "merkki")) ; --UNCHK
lin bookmarker_N = mkWN (compoundN "kirjan" (k5A "merkki")) ; --UNCHK
lin bookmobile_N = mkWN (compoundN "kirjasto" (k1 "auto")) ; --UNCHK
lin bookplate_N = mkWN (k39 "exlibris") ; --UNCHK
lin bookseller_N = mkWN (compoundN "kirja" (k41 "kauppias")) ; --UNCHK
lin bookshelf_N = mkWN (compoundN "kirja" (k1 "hylly")) ; --UNCHK
lin bookshop_N = mkWN (compoundN "kirja" (k9A "kauppa")) ; --UNCHK
lin bookstall_N = mkWN (compoundN "kirja" (k9A "kauppa")) ; --UNCHK
lin bookworm_N = mkWN (compoundN "kirja" (k10A "toukka")) ; --UNCHK
lin boom_N = mkN "buumi" ; --WN (k5 "puomi") ; ----ARB
lin boom_V = mkWV (k53 "kukoistaa") ; --UNCHK
lin boom_V2 = mkWV2 (k53 "kukoistaa") ; --UNCHK
lin boomerang_N = mkWN (compoundN "taka" (k1 "isku")) ; --UNCHK
lin boon_A = mkWA (k38 "läheinen") ; --UNCHK
lin boon_N = mkWN (k7 "onni") ; --UNCHK
lin boondoggle_N = mkWN (k39 "haaskaus") ; --UNCHK
lin boor_N = mkWN (k38 "raakalainen") ; --UNCHK
lin boorish_A = mkWA (k38 "sikamainen") ; --UNCHK
lin boorishness_N = mkWN (k40 "sivistymättömyys") ; --UNCHK
lin boost_N = mkN (lin NK {s = d07A "tuki"}) ;
lin boost_V2 = mkV2 "vahvistaa" partitive ;
lin booster_N = mkWN (k48 "tehoste") ; --UNCHK
lin boot_N = L.boot_N ;
lin boot_V2 = mkWV2 (k53 "käynnistää") "uudelleen" ; --UNCHK
lin bootblack_N = mkWN (k10 "kengänkiillottaja") ; --UNCHK
lin bootee_N = mkWN (k38 "töppönen") ; --UNCHK
lin booth_N = mkWN (kH1 "koppi") ;
lin boothose_N = mkWN (k10A "sukka") ; --UNCHK
lin bootjack_N = mkWN (compoundN "saapas" (k5A "renki")) ; --UNCHK
lin bootlace_N = mkWN (compoundN "kengän" (k9 "nauha")) ; --UNCHK
lin bootle_PN = foreignPN "Bootle" ;
lin bootleg_A = mkWA (k5 "pörssi") "musta" ; --UNCHK
lin bootleg_N = mkWN (compoundN "kengän" (k28 "varsi")) ; --UNCHK
lin bootleg_V2 = mkWV2 (k62 "kopioida") ; --UNCHK
lin bootlegger_N = mkWN (k6 "trokari") ; --UNCHK
lin bootlegging_N = mkWN "trokaaminen" ; --UNCHK
lin bootless_A = mkWA (k10 "tyhjä") ; --UNCHK
lin bootlicking_A = mkWA (compoundA "mieliste" (k10 "levä")) ; --UNCHK
lin bootmaker_N = mkWN (k6 "suutari") ; --UNCHK
lin bootstrap_N = mkWN (compoundN "saappaan" (k5 "raksi")) ; --UNCHK
lin booty_N = mkWN (k41 "saalis") ; --UNCHK
lin booze_N = mkWN (k10 "juoma") "vahva" ; --UNCHK
lin booze_V = mkWV (k73A "ryypätä") ; --UNCHK
lin boozer_N = mkWN (k6 "juomari") ; --UNCHK
lin boozy_A = mkWA (k38 "humalainen") ; --UNCHK
lin bop_N = mkWN (k5 "bebop") ; --UNCHK
lin bopeep_N = mkWN (compoundN "kurkistus" (k5A "leikki")) ; --UNCHK
lin boracic_A = mkWA "boori-" ; --UNCHK
lin borage_N = mkWN (compoundN "kurkku" (k5A "yrtti")) ; --UNCHK
lin borate_N = mkWN "boraatti" ; --UNCHK
lin borated_A = mkWA "borated" ; --UNCHK
lin borax_N = mkWN (compoundN "boo" (k5 "raksi")) ; --UNCHK
lin bordeaux_N = mkWN (k5 "bordeauxviini") ; --UNCHK
lin bordeaux_PN = foreignPN "Bordeaux" ;
lin bordelaise_N = mkWN (compoundN "bordelaise" (k48A "kastike")) ; --UNCHK
lin border_N = mkN "raja" ;
lin border_V = mkWV (k52A "liittyä") "päittäin" ; --UNCHK
lin border_V2 = mkWV2 (k52A "liittyä") "päittäin" ; --UNCHK
lin border_on_V2 = mkWV2 (k52 "lähestyä") ; --UNCHK
lin borderer_N = mkWN (compoundN "rajaseutu" (k38 "lainen")) ; --UNCHK
lin borderland_N = mkWN (compoundN "raja" (k18 "maa")) ; --UNCHK
lin borderline_A = mkWA (k38 "marginaalinen") ; --UNCHK
lin borderline_N = mkWN (kH1 "raja") ; --UNCHK
lin bordon_PN = foreignPN "Bordon" ;
lin bore_N = mkWN (compoundN "poraus" (k1A "aukko")) ; --UNCHK
lin bore_V = mkWV (k73 "kairata") ; ---ARB --mkV "ikävystyä" ;
lin bore_V2 = mkWV2 (k73 "kairata") ; --UNCHK
lin boreal_A = mkWA (compoundA "borea" (k38 "alinen")) ; --UNCHK
lin bored_A = variants {} ; --
lin boredom_N = mkWN (k40 "ikävystyttävyys") ; --UNCHK
lin borer_N = mkWN (k34A "selkärangaton") ; --UNCHK
lin boric_A = mkWA "boori-" ; --UNCHK
lin boring_A = mkA "ikävystyttävä" ;
lin boring_N = mkWN (k39 "poraus") ; --UNCHK
lin boringness_N = mkWN (k40 "ikävystyttävyys") ; --UNCHK
lin bornite_N = mkWN (compoundN "kupari" (k1 "kiisu")) "kirjava" ; --UNCHK
lin boron_N = mkWN (k5 "boori") ; --UNCHK
lin boronic_A = mkWA "boori-" ; --UNCHK
lin borosilicate_N = mkWN (compoundN "boro" (k5A "silikaatti")) ; --UNCHK
lin borough_N = mkN "kauppala" ; --UNCHK
lin borrelia_N = mkWN "Borrelia" ; --UNCHK
lin borrow_V = mkWV (k53A "ottaa") "lainaksi" ; --f59
lin borrow_V2 = mkV2 "lainata" | mkWV2 (k53A "ottaa") "lainaksi" ;
lin borrow_VV = mkWVV (k53A "ottaa") "lainaksi" ; --UNCHK
lin borrower_N = mkWN (k10 "lainaaja") ; --UNCHK
lin borrowing_N = mkWN (compoundN "oma" (k38 "ksuminen")) ; --UNCHK
lin borsch_N = mkWN (k5 "borštš") ; --UNCHK
lin borstal_N = mkWN (compoundN "koulu" (k5A "koti")) ; --UNCHK
lin borzoi_N = mkWN "venäjänvinttikoira" ; --UNCHK
lin bosc_N = mkWN "bosc" ; --UNCHK
lin bosh_N = mkWN (k5 "humpuuki") ; --UNCHK
lin bosk_N = mkWN (k4A "metsikkö") ; --UNCHK
lin boskopoid_A = mkWA "boskopoidi" ; --UNCHK
lin bosky_A = mkWA (k38 "pensaikkoinen") ; --UNCHK
lin bosom_N = mkWN (k10 "hoiva") ; --UNCHK
lin bosomed_A = mkWA (k41A "kurvikas") ; --UNCHK
lin bosomy_A = mkWA (k38 "täyteläinen") ; --UNCHK
lin boson_N = mkWN (k6 "bosoni") ; --UNCHK
lin boss_A = mkWA (k38 "erinomainen") ; --UNCHK
lin boss_N = L.boss_N | mkWN (compoundN "esi" (k42 "mies")) ;
lin boss_V2 = mkWV2 (k73 "leimata") ; --UNCHK
lin boss_around_V2 = mkWV2 (k67A "komennella") ; --UNCHK
lin bossism_N = mkWN "bossism" ; --UNCHK
lin bossy_A = mkWA (k15 "pöyhkeä") ; --UNCHK
lin boston_PN = foreignPN "Boston" ;
lin bot_N = mkWN (compoundN "nauta" (k38 "kiiliäinen")) ; --UNCHK
lin bota_N = mkWN "bota" ; --UNCHK
lin botanic_A = mkWA (k38 "botaaninen") ; --UNCHK
lin botanical_A = mkWA (k38 "botaaninen") ; --UNCHK
lin botanical_N = mkWN (k48A "lääke") "kasviperäinen" ; --UNCHK
lin botanist_N = mkWN (k5 "botanisti") ; --UNCHK
lin botanize_V = mkWV (k61 "tutkia") "kasveja" ; --UNCHK
lin botany_N = mkWN (k9A "botaniikka") ; --UNCHK
lin botch_N = mkWN (k48 "virhe") ; --UNCHK
lin botch_V2 = mkWV2 (k71 "tehdä") "virhe" ; --UNCHK
lin botch_up_V2 = mkWV2 (k71 "tehdä") "virhe" ; --UNCHK
lin botcher_N = mkWN (k10 "hutiloija") ; --UNCHK
lin botchy_A = mkWA (k34A "taidoton") ; --UNCHK
lin botfly_N = mkWN (k38 "kiiliäinen") ; --UNCHK
lin both7and_DConj = S.both7and_DConj ;
lin both_Adv = mkAdv "molemmat" ; ---- cat
lin both_Det = mkDet Pl (mkN "molempi" "molemman" "molempia") ;
lin bother_N = mkWN (k9 "riesa") ; --UNCHK
lin bother_V = mkV "vaivautua" ; --mkWV (k53A "ottaa") "päähän" ;
lin bother_V2 = mkV2 "vaivata" partitive ; --mkWV2 (k53A "ottaa") "päähän" ;
lin bother_V2V = mkWV2V (k53A "ottaa") "päähän" ; --UNCHK
lin bother_VV = variants {} ; -- mkWV2V (k53A "ottaa") "päähän" ; --UNCHK
lin bothersome_A = mkWA (k10 "rasittava") ; --UNCHK
lin botonee_A = mkWA "botonnee" ; --UNCHK
lin botryoid_A = mkWA (compoundA "viini" (k38 "rypälemäinen")) ; --UNCHK
lin botswana_PN = foreignPN "Botswana" ;
lin bottle_N = mkWN (k1 "pullo") ; --UNCHK
lin bottle_V2 = mkV2 "pullottaa" partitive ;
lin bottle_up_V2 = mkWV2 (k53A "tukahduttaa") ; --UNCHK
lin bottlebrush_N = mkWN (compoundN "pullo" (k9 "harja")) ; --UNCHK
lin bottlecap_N = mkWN (compoundN "pullon" (k5A "korkki")) ; --UNCHK
lin bottleneck_N = mkWN (compoundN "pullon" (k9 "kaula")) ; --UNCHK
lin bottler_N = mkWN (compoundN "pull" (k10 "ottaja")) ; --UNCHK
lin bottom_A = mkWA (k36 "alin") ; --UNCHK
lin bottom_N = mkN "pohja" ;
lin bottom_V = mkWV (k53A "käsittää") ; --UNCHK
lin bottom_out_V = mkWV (k73 "törmätä") ; --UNCHK
lin bottomed_A = mkWA (k38 "-pohjainen") ; --UNCHK
lin bottomland_N = mkWN (compoundN "joki" (k1 "laakso")) ; --UNCHK
lin bottomless_A = mkWA (compoundA "ala" (k34A "osaton")) ; --UNCHK
lin bottomlessness_N = mkWN "pohjattomuus" ; --UNCHK
lin bottommost_A = mkWA (k36 "alin") ; --UNCHK
lin bottrop_PN = foreignPN "Bottrop" ;
lin botuliform_A = mkWA (compoundA "makkaran" (k38 "muotoinen")) ; --UNCHK
lin botulin_N = mkWN (k5 "botuliini") ; --UNCHK
lin botulinal_A = mkWA "botuliini-" ; --UNCHK
lin botulinus_N = mkWN (compoundN "botulinus-bak" (k26 "teeri")) ; --UNCHK
lin botulism_N = mkWN (k5 "botulismi") ; --UNCHK
lin boucle_N = mkWN (k20 "buklee") ; --UNCHK
lin boudoir_N = mkWN (compoundN "budo" (k5 "aari")) ; --UNCHK
lin bouffant_A = mkWA (k15 "pullea") ; --UNCHK
lin bough_N = mkWN (k10 "oksa") ; --UNCHK
lin boughed_A = mkWA (k38 "oksainen") ; --UNCHK
lin boughless_A = mkWA "oksaton" ; --UNCHK
lin boughten_A = mkWA "ostettu" ; --UNCHK
lin bouillabaisse_N = mkWN (k8 "bouillabaisse") ; --UNCHK
lin bouillon_N = mkWN (compoundN "liha" (k25 "liemi")) ; --UNCHK
lin boulder_N = mkWN "Boulder" ; --UNCHK
lin boulevard_N = mkWN (k5 "bulevardi") ; --UNCHK
lin boulevardier_N = mkWN (k12 "kävelijä") ; --UNCHK
lin boulle_N = mkWN (compoundN "boulle-" (k39 "upotus")) ; --UNCHK
lin bounce_N = mkWN (k39 "hyppäys") ; --UNCHK
lin bounce_V = mkWV (k53A "hyppäyttää") ; --UNCHK
lin bounce_V2 = mkWV2 (k53A "hyppäyttää") ; --UNCHK
lin bounce_back_V = mkWV (k52A "toipua") ; --UNCHK
lin bouncer_N = mkWN (k6 "portsari") ; --UNCHK
lin bouncy_A = mkWA (k14A "terhakka") ; --UNCHK
lin bound_N = mkWN (k39 "hyppäys") ; --UNCHK
lin bound_V = mkWV (k54A "vähentää") ; --UNCHK
lin bound_V2 = mkWV2 (k54A "vähentää") ; --UNCHK
lin bound_V2V = mkWV2V (k54A "vähentää") ; --UNCHK
lin boundary_N = mkWN (kH1 "raja") ; --UNCHK
lin bounden_A = mkWA (k38 "moraalinen") ; --UNCHK
lin bounder_N = mkWN (k10 "hyppääjä") ; --UNCHK
lin boundless_A = mkWA (k34A "ääretön") ; --UNCHK
lin bounteous_A = mkWA (k10 "lukuisa") ; --UNCHK
lin bountied_A = mkWA "palkittu" ; --UNCHK
lin bountiful_A = mkWA (k41 "runsas") ; --UNCHK
lin bounty_N = mkWN "H.M.S." "Bounty" ;
lin bouquet_N = mkWN (compoundN "kukka" (k1 "vihko")) ; --UNCHK
lin bourbon_N = mkWN (k6 "bourbon") ; --UNCHK
lin bourgeois_A = mkWA (k38 "porvarillinen") ; --UNCHK
lin bourgeois_N = mkWN (k32 "jäsen") "keskiluokan" ; --UNCHK
lin bourgeoisie_N = mkWN (k1 "porvaristo") ; --UNCHK
lin bourguignon_N = mkWN (compoundN "burgundin" (k48A "kastike")) ; --UNCHK
lin bourn_N = mkWN (k48A "kohde") ; --UNCHK
lin bourne_N = mkWN (k48A "kohde") ; --UNCHK
lin bourne_PN = foreignPN "Bourne" ;
lin bournemouth_PN = foreignPN "Bournemouth" ;
lin bourse_N = mkWN "Bourse" ; --UNCHK
lin bourtree_N = mkWN (compoundN "seljan" (k9 "marja")) ; --UNCHK
lin boustrophedon_N = mkWN "bustrofedon" ; --UNCHK
lin boustrophedonic_A = mkWA "boustrofedoninen" ; --UNCHK
lin bout_N = mkN "kausi" ; --mkWN (compoundN "juoma" (k27 "kausi")) ;
lin boutique_N = mkWN (k5A "putiikki") ; --UNCHK
lin boutonniere_N = mkWN (compoundN "napinläpi" (k10A "kukka")) ; --UNCHK
lin bovid_N = mkWN (compoundN "ontto" (k38 "sarvinen")) ; --UNCHK
lin bovine_A = mkWA "karja-" ; --UNCHK
lin bovine_N = mkWN (k9A "nauta") ; --UNCHK
lin bovril_N = mkWN (compoundN "liha" (k48A "uute")) ; --UNCHK
lin bow_N = mkWN "bow" ; --UNCHK
lin bow_V = mkWV (k56A "antaa") "myöten" ; --UNCHK
lin bow_V2 = mkWV2 (k56A "antaa") "myöten" ; --UNCHK
lin bowdlerization_N = mkWN (k5A "sensurointi") ; --UNCHK
lin bowdlerize_V2 = mkWV2 (k54A "lyhentää") ; --UNCHK
lin bowel_N = mkWN (k2 "suolisto") ; --UNCHK
lin bower_N = mkWN (k12 "pergola") ; --UNCHK
lin bowerbird_N = mkWN (k10 "lavastaja") ; --UNCHK
lin bowery_A = mkWA (k10 "lehtevä") ; --UNCHK
lin bowfin_N = mkWN "Amia" "calva" ; --UNCHK
lin bowfront_A = mkWA (k10 "kupera") ; --UNCHK
lin bowhead_N = mkWN (compoundN "grönlannin" (k41 "valas")) ; --UNCHK
lin bowie_knife_N = mkWN (compoundN "bowie-" (k30 "veitsi")) ; --UNCHK
lin bowing_N = mkWN (k1A "soitto") ; --UNCHK
lin bowl_N = mkWN (k39 "vieritys") ; --UNCHK
lin bowl_V = mkWV (k73 "keilata") ; --UNCHK
lin bowl_V2 = mkWV2 (k73 "keilata") ; --UNCHK
lin bowl_over_V2 = mkWV2 (k53A "tyrmistyttää") ; --UNCHK
lin bowleg_N = mkWN (k9 "vara") "tibia" ; --UNCHK
lin bowler_N = mkWN (k5 "knalli") ; --UNCHK
lin bowline_N = mkWN (compoundN "paalu" (k1 "solmu")) ; --UNCHK
lin bowling_N = mkWN (k2 "keilailu") ; --UNCHK
lin bowling_green_N = mkWN (k10A "kenttä") ; --UNCHK
lin bowls_N = mkWN (compoundN "nurmi" (k2 "keilailu")) ; --UNCHK
lin bowman_N = mkWN (compoundN "jousi" (k42 "mies")) ; --UNCHK
lin bowsprit_N = mkWN (compoundN "kokka" (k18 "puu")) ; --UNCHK
lin bowstring_N = mkWN (k48A "jänne") ; --UNCHK
lin box_N = mkN "laatikko" | mkWN (k41A "lipas") ;
lin box_V = mkWV (k67 "nyrkkeillä") ; --UNCHK
lin box_V2 = mkWV2 (k67 "nyrkkeillä") ; --UNCHK
lin box_in_V2 = mkWV2 (k53 "ahdistaa") "nurkkaan" ; --UNCHK
lin box_kite_N = mkWN (compoundN "laatikko" (k9 "leija")) ; --UNCHK
lin box_number_N = mkWN (compoundN "postilokero-" (k48A "osoite")) ; --UNCHK
lin box_office_N = mkWN (compoundN "lippu" (k1A "luukku")) ; --UNCHK
lin box_up_V2 = mkWV2 (k53 "ahdistaa") "nurkkaan" ; --UNCHK
lin boxcar_N = mkWN (compoundN "boksi" (k9 "nahka")) ; --UNCHK
lin boxcars_N = mkWN (k12 "tusina") ; --UNCHK
lin boxer_N = mkWN (k6 "bokseri") ; --UNCHK
lin boxfish_N = mkWN (compoundN "lossero" (k9 "kala")) ; --UNCHK
lin boxful_N = mkWN (k38 "rasiallinen") ; --UNCHK
lin boxing_N = mkWN (compoundN "pakka" (k38 "aminen")) ; --UNCHK
lin boxing_day_N = mkWN (k5 "tapani") ; --UNCHK
lin boxing_glove_N = mkWN (k9 "hanska") ; --UNCHK
lin boxing_match_N = mkWN (compoundN "nyrkkeily" (k2 "ottelu")) ; --UNCHK
lin boxlike_A = mkWA (compoundA "laatikko" (k38 "mainen")) ; --UNCHK
lin boxwood_N = mkWN (compoundN "puksi" (k18 "puu")) ; --UNCHK
lin boy_N = L.boy_N ;
lin boycott_N = mkWN (k5A "boikotti") ; --UNCHK
lin boycott_V2 = mkWV2 (k62 "boikotoida") ; --UNCHK
lin boyfriend_N = mkWN (k4A "nuorikko") ; --UNCHK
lin boyhood_N = mkWN (k40 "poikuus") ; --UNCHK
lin boyish_A = mkWA (k38 "poikamainen") ; --UNCHK
lin boyishness_N = mkWN (k40 "poikamaisuus") ; --UNCHK
lin boysenberry_N = mkWN (compoundN "boysen" (k9 "marja")) ; --UNCHK
lin bra_N = mkN "rinta" (mkN "liivi") ;
lin brace_N = mkWN (k50 "vinotuki") ; --UNCHK
lin brace_V = mkV "valmistautua" ;
lin brace_V2 = mkWV2 (k62 "stimuloida") ; --UNCHK
lin brace_up_V = mkWV (k58A "tukea") ; --UNCHK
lin bracelet_N = mkWN (compoundN "ranne" (k41A "rengas")) ; --UNCHK
lin bracer_N = mkWN (compoundN "krapula" (k1A "ryyppy")) ; --UNCHK
lin bracero_N = mkWN (compoundN "siirto" (k38 "työläinen")) ; --UNCHK
lin brachial_A = mkWA "olkavarsi-" ; --UNCHK
lin brachiate_A = mkWA (compoundA "käsi" (k38 "varrellinen")) ; --UNCHK
lin brachiation_N = mkWN (compoundN "roik" (k38 "kuminen")) ; --UNCHK
lin brachiopod_A = mkWA (compoundA "lonkero" (k38 "jalkainen")) ; --UNCHK
lin brachiopod_N = mkWN (compoundN "lonkero" (k38 "jalkainen")) ; --UNCHK
lin brachium_N = mkWN (compoundN "olka" (k28 "varsi")) ; --UNCHK
lin brachycephalic_A = mkWA (compoundA "brakykefa" (k38 "alinen")) ; --UNCHK
lin brachycephalic_N = mkWN (compoundN "lyhytkal" (k38 "loinen")) ; --UNCHK
lin brachycephaly_N = mkWN "brakykefalia" ; --UNCHK
lin brachydactylic_A = mkWA (compoundA "lyhyt" (k38 "varpainen")) ; --UNCHK
lin brachydactyly_N = mkWN "brakydaktylia" ; --UNCHK
lin brachypterous_A = mkWA (compoundA "lyhyt" (k38 "siipinen")) ; --UNCHK
lin brachyurous_A = mkWA "taskuravut" ; --UNCHK
lin bracken_N = mkWN (compoundN "sanan" (k9A "jalka")) ; --UNCHK
lin bracket_N = mkWN (k33A "pidin") ; --UNCHK
lin bracket_V2 = mkWV2 (k67A "ryhmitellä") ; --UNCHK
lin brackish_A = mkWA (k38 "suolainen") ; --UNCHK
lin brackishness_N = mkWN (k40 "suolaisuus") ; --UNCHK
lin bracknell_PN = foreignPN "Bracknell" ;
lin bract_N = mkWN (compoundN "suoja" (k7A "lehti")) ; --UNCHK
lin bracteal_A = mkWA (compoundA "suo" (k38 "juslehtimäinen")) ; --UNCHK
lin bracteate_A = mkWA (compoundA "suojus" (k38 "lehtinen")) ; --UNCHK
lin bracteolate_A = mkWA (compoundA "suojus" (k38 "lehtinen")) ; --UNCHK
lin bracteole_N = mkWN (compoundN "suojus" (k7A "lehti")) ; --UNCHK
lin brad_N = mkWN (k9 "naula") ; --UNCHK
lin bradawl_N = mkWN (k33 "purasin") ; --UNCHK
lin bradford_PN = foreignPN "Bradford" ;
lin bradycardia_N = mkWN (compoundN "bradykar" (k9 "dia")) ; --UNCHK
lin brae_N = mkWN (k48A "rinne") ; --UNCHK
lin brag_N = mkWN (k2 "mahtailu") ; --UNCHK
lin brag_V = mkWV (k67A "rehennellä") ; --UNCHK
lin braggadocio_N = mkWN (k2 "mahtailu") ; --UNCHK
lin braggart_N = mkWN (k6 "öykkäri") ; --UNCHK
lin bragger_N = mkWN (k6 "öykkäri") ; --UNCHK
lin bragging_N = mkWN (k2 "mahtailu") ; --UNCHK
lin brahman_N = mkWN (compoundN "ryhä" (k10A "härkä")) ; --UNCHK
lin brahmin_N = mkWN (compoundN "ryhä" (k10A "härkä")) ; --UNCHK
lin brahminic_A = mkWA (compoundA "brah" (k38 "maaninen")) ; --UNCHK
lin braid_N = mkWN (k5 "nyöri") ; --UNCHK
lin braid_V2 = mkWV2 (k62 "palmikoida") ; --UNCHK
lin brail_N = mkWN "supistin" ; --UNCHK
lin braille_N = mkWN (compoundN "piste" (k39 "kirjoitus")) ; --UNCHK
lin brain_N = mkN "aivo" ;
lin brain_V2 = mkWV2 (k73 "murskata") "kallo" ; --UNCHK
lin brainchild_N = mkWN (k39 "luomus") ; --UNCHK
lin brainless_A = mkWA (k10 "typerä") ; --UNCHK
lin brainsick_A = mkWA (k99 "tolaltaan") "poissa" ; --UNCHK
lin brainstem_N = mkWN (compoundN "aivo" (k1A "runko")) ; --UNCHK
lin brainstorm_N = mkWN (k39 "neronleimaus") ; --UNCHK
lin brainstorming_N = mkWN (compoundN "aivo" (k23 "riihi")) ; --UNCHK
lin braintree_PN = foreignPN "Braintree" ;
lin brainwash_V2 = mkWV2 (compoundV "aivo" (k66 "pestä")) ; --UNCHK
lin brainwashing_N = mkWN (compoundN "aivo" (k1 "pesu")) ; --UNCHK
lin brainwave_N = mkWN (k39 "neronleimaus") ; --UNCHK
lin brainworker_N = mkWN "aivotyöskentelijä" ; --UNCHK
lin brainy_A = mkWA (k10 "terävä") ; --UNCHK
lin braise_V2 = mkWV2 (k54A "muhentaa") ; --UNCHK
lin braising_N = mkWN (compoundN "hau" (k38 "duttaminen")) ; --UNCHK
lin brake_N = mkWN (k1 "jarru") ;
lin brake_V = mkWV (k53A "jarruttaa") ; --UNCHK
lin brake_V2 = mkWV2 (k53A "jarruttaa") ; --UNCHK
lin brakeman_N = mkWN (compoundN "jarru" (k42 "mies")) ; --UNCHK
lin braky_A = mkWA (k41 "vehmas") ; --UNCHK
lin bramble_N = mkWN (k14A "vatukka") ; --UNCHK
lin brambling_N = mkWN (compoundN "järri" (k1A "peippo")) ; --UNCHK
lin bran_N = mkWN (k48 "lese") ;
lin branch_N = mkWN (k9 "haara") | mkN "oksa" ; ---- split
lin branch_V = mkWV (k52A "erkaantua") ; --UNCHK
lin branch_out_V = mkWV (k52A "laajentua") ; --UNCHK
lin branched_A = mkWA (k41A "haarakas") ; --UNCHK
lin branchial_A = mkWA (compoundA "brankia" (k38 "alinen")) ; --UNCHK
lin branchiate_A = mkWA "kiduksellinen" ; --UNCHK
lin branching_N = mkWN (compoundN "haa" (k38 "roittuminen")) ; --UNCHK
lin branchiopod_A = mkWA "kidusjalkainen" ; --UNCHK
lin branchless_A = mkWA "oksaton" ; --UNCHK
lin branchlet_N = mkWN (k1 "verso") ; --UNCHK
lin branchy_A = mkWA (k38 "oksainen") ; --UNCHK
lin brand_N = mkN "tavaramerkki" ;
lin brand_V2 = mkWV2 (k73 "leimata") ; --UNCHK
lin branding_iron_N = mkWN (compoundN "poltin" (k9A "rauta")) ; --UNCHK
lin brandish_V2 = mkWV2 (k53 "heristää") ; --UNCHK
lin brandy_N = mkWN (k1 "brandy") ; --UNCHK
lin brandy_ball_N = mkWN (compoundN "likööri" (k5A "konvehti")) ; --UNCHK
lin brandy_snap_N = mkWN (compoundN "brandy" (k38 "leivonnainen")) ; --UNCHK
lin brant_N = mkWN (compoundN "sepel" (k7 "hanhi")) ; --UNCHK
lin brash_A = mkWA (k10 "tunkeileva") ; --UNCHK
lin brashness_N = mkWN (k40 "harkitsemattomuus") ; --UNCHK
lin brass_N = mkWN (k7 "torvi") ; --UNCHK
lin brassard_N = mkWN (compoundN "käsivarsi" (k39 "suojus")) ; --UNCHK
lin brassavola_N = mkWN "brassavola" ; --UNCHK
lin brassbound_A = mkWA (k38 "messinkinen") ; --UNCHK
lin brasserie_N = mkWN (k12 "kuppila") ; --UNCHK
lin brassie_N = mkWN "brassie" ; --UNCHK
lin brassiere_N = variants {} ;
lin brassy_A = mkWA (k38 "metallinen") ; --UNCHK
lin brat_N = mkWN (k5 "braatvursti") ; --UNCHK
lin bratislava_PN = foreignPN "Bratislava" ;
lin brattice_N = mkWN (compoundN "väli" (k39 "laudoitus")) ; --UNCHK
lin bratty_A = mkWA (k34A "kuriton") ; --UNCHK
lin bratwurst_N = mkWN (k5 "braatvursti") ; --UNCHK
lin braunschweig_PN = foreignPN "Braunschweig" ;
lin braunton_PN = foreignPN "Braunton" ;
lin bravado_N = mkWN (k2 "mahtailu") ; --UNCHK
lin brave_A = mkWA (k38 "urhoollinen") ; --UNCHK
lin brave_V2 = mkWV2 (k73A "kohdata") "rohkeasti" ; --UNCHK
lin bravery_N = mkWN (k40 "urhoollisuus") ; --UNCHK
lin bravo_N = mkWN (compoundN "bravo-" (k1A "huuto")) ; --UNCHK
lin bravura_N = mkWN (k40 "taituruus") ; --UNCHK
lin brawl_N = mkWN (k2 "tappelu") ; --UNCHK
lin brawl_V = mkWV (k62 "nujakoida") ; --UNCHK
lin brawler_N = mkWN (k12 "rähinöitsijä") ; --UNCHK
lin brawn_N = mkWN (k10 "voima") ; --UNCHK
lin brawny_A = mkWA (k11 "vanttera") ; --UNCHK
lin bray_N = mkWN (k2 "kiljaisu") ; --UNCHK
lin bray_V2 = mkWV2 (k52 "ulvoa") ; --UNCHK
lin braze_V2 = mkWV2 (k53A "juottaa") ; --UNCHK
lin brazen_A = mkWA (k38 "messinkinen") ; --UNCHK
lin brazier_N = mkWN (compoundN "hiili" (k1 "pannu")) ; --UNCHK
lin brazil_PN = foreignPN "Brasilia" ;
lin brazilian_A = mkWA (compoundA "brasili" (k38 "alainen")) ; --UNCHK
lin brazilian_N = mkWN (compoundN "brasili" (k38 "alainen")) ; --UNCHK
lin brazilwood_N = mkWN (compoundN "echi" (k9A "nata")) "Caesalpinia" ; --UNCHK
lin breach_N = mkWN (k39 "rikkomus") ; --UNCHK
lin breach_V2 = mkV2 "rikkoa" partitive ; --mkWV2 (k71 "tehdä") "aukko" ;
lin bread_N = L.bread_N ;
lin breadbasket_N = mkWN (compoundN "leipä" (k5 "kori")) ; --UNCHK
lin breadboard_N = mkWN (compoundN "leikkuu" (k9A "lauta")) ; --UNCHK
lin breadcrumb_N = mkWN (compoundN "korppu" (k1 "jauho")) ; --UNCHK
lin breadfruit_N = mkWN (k10 "hedelmä") "leipäpuun" ; --UNCHK
lin breadline_N = mkWN (compoundN "leipä" (k1 "jono")) ; --UNCHK
lin breadroot_N = mkWN "Psoralea" "esculenta" ; --UNCHK
lin breadstick_N = mkWN (compoundN "leipä" (k1A "tikku")) ; --UNCHK
lin breadth_N = mkWN (k40 "laajuus") ; --UNCHK
lin breadthways_Adv = mkWAdv (compoundAdv "leveys" (k99 "suuntaisesti")) ; --UNCHK
lin breadthwise_Adv = mkWAdv (compoundAdv "leveys" (k99 "suuntaisesti")) ; --UNCHK
lin breadwinner_N = mkWN (k10 "elättäjä") "perheen" ; --UNCHK
lin break_N = mkN "tauko" ;
lin break_V = mkV "murtua" ;
lin break_V2 = L.break_V2 ;
lin break_apart_V = mkWV (k74 "hajota") ; --UNCHK
lin break_away_V = mkWV (k74 "katketa") ; --UNCHK
lin break_down_V = mkWV (k52 "lyyhistyä") ; --UNCHK
lin break_down_V2 = mkWV2 (k52 "lyyhistyä") ; --UNCHK
lin break_in_V = mkWV (k56 "ajaa") "sisään" ; --UNCHK
lin break_in_V2 = mkWV2 (k56 "ajaa") "sisään" ; --UNCHK
lin break_in_on_V2 = prepV2 (advV OP_break_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin break_into_V2 = mkWV2 (k74A "ruveta") ; --UNCHK
lin break_off_V2 = mkWV2 (k53A "keskeyttää") ; --UNCHK
lin break_out_V = mkWV (k52A "ilmaantua") ; --UNCHK
lin break_out_V2 = mkWV2 (k52A "ilmaantua") ; --UNCHK
lin break_out_in_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin break_out_of_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin break_through_V2 = mkWV2 (k67 "tulla") "esiin" ; --UNCHK
lin break_up_V = mkWV (k53A "hohottaa") ; --UNCHK
lin break_up_V2 = mkWV2 (k53A "hohottaa") ; --UNCHK
lin breakable_A = mkWA (k41 "hauras") ; --UNCHK
lin breakable_N = mkWN (k12 "tavara") "hauras" ; --UNCHK
lin breakableness_N = mkWN (k40 "hauraus") ; --UNCHK
lin breakage_N = mkWN (compoundN "rikko" (k38 "utuminen")) ; --UNCHK
lin breakaway_A = mkWA (k38 "separatistinen") ; --UNCHK
lin breakaway_N = mkWN (compoundN "irti" (k1A "otto")) ; --UNCHK
lin breakax_N = mkWN "Sloanea" "jamaicensis" ; --UNCHK
lin breakdown_N = mkWN (k3 "häiriö") ; --UNCHK
lin breaker_N = mkN "tyrsky" ; --WN (compoundN "automaatti" (k48A "sulake")) ; ----ARB
lin breakfast_N = mkWN (k38 "aamiainen") ; --UNCHK
lin breakneck_A = mkWA (k10 "hurja") ; --UNCHK
lin breakthrough_N = mkWN (compoundN "läpi" (k1A "murto")) ;
lin breakwater_N = mkWN (compoundN "ranta" (k49A "penger")) ; --UNCHK
lin bream_N = mkWN (k9 "lahna") ; --UNCHK
lin breast_N = L.breast_N ;
lin breast_V2 = mkWV2 (k73A "kohdata") ; --UNCHK
lin breastfeed_V = mkWV (k53A "imettää") ; --UNCHK
lin breastfeed_V2 = mkWV2 (k53A "imettää") ; --UNCHK
lin breastless_A = mkWA "rinnaton" ; --UNCHK
lin breast_plate_N = mkWN (compoundN "rinta" (k39 "suojus")) ; --UNCHK
lin breaststroke_N = mkWN (compoundN "rinta" (k5A "uinti")) ; --UNCHK
lin breaststroker_N = mkWN (compoundN "rinta" (k6 "uimari")) ; --UNCHK
lin breastwork_N = mkWN (k48A "kaide") ; --UNCHK
lin breath_N = mkWN (k2 "henkäisy") ;
lin breathalyser_N = mkWN (k5 "alkometri") ; --UNCHK
lin breathalyzer_N = mkWN (k5 "alkometri") ; --UNCHK
lin breathe_V = L.breathe_V ;
lin breathe_V2 = mkWV2 (k66 "henkäistä") ; --UNCHK
lin breather_N = mkWN (k6 "snorkkeli") ;
lin breathing_N = mkWN (k39 "hengitys") ; --UNCHK
lin breathing_space_N = mkWN (compoundN "hengitys" (k9 "tila")) ; --UNCHK
lin breathtaking_A = mkWA (k15 "huikea") ; --UNCHK
lin breccia_N = mkWN "breksia" ; --UNCHK
lin breda_PN = foreignPN "Breda" ;
lin breech_N = mkWN (compoundN "patruuna" (k10 "pesä")) ; --UNCHK
lin breech_block_N = mkWN (k1A "lukko") ; --UNCHK
lin breechcloth_N = mkWN (compoundN "lanne" (k48A "vaate")) ; --UNCHK
lin breeched_A = mkWA "housullinen" ; --UNCHK
lin breeches_buoy_N = mkWN (compoundN "pelastus" (k5 "tuoli")) ; --UNCHK
lin breechloader_N = mkWN (k48 "ase") "takaaladattava" ; --UNCHK
lin breed_N = mkN "rotu" ; --WN (k5A "tyyppi") ;
lin breed_V = mkWV (k52A "lisääntyä") ; --UNCHK
lin breed_V2 = mkWV2 (k52A "lisääntyä") ; --UNCHK
lin breeder_N = mkWN (k10 "kasvattaja") ; --UNCHK
lin breeding_N = mkWN (compoundN "lisä" (k38 "äntyminen")) ; --UNCHK
lin breeze_N = mkN "tuulen" (mkN "vire") ;
lin breeze_V = mkWV (k55A "liitää") ; --UNCHK
lin breeziness_N = mkWN (k40 "reippaus") ; --UNCHK
lin breezy_A = mkWA (k38 "tuulinen") ; --UNCHK
lin bregma_N = mkWN (compoundN "päälaki" (k48 "piste")) ; --UNCHK
lin bregmatic_A = mkWA "päälakipiste-" ; --UNCHK
lin bremen_PN = foreignPN "Bremen" ;
lin bremerhaven_PN = foreignPN "Bremerhaven" ;
lin bren_N = mkWN (compoundN "Bren-pikakiv" (k26 "ääri")) ; --UNCHK
lin bren_gun_N = mkWN (compoundN "Bren-pikakiv" (k26 "ääri")) ; --UNCHK
lin brent_PN = foreignPN "Brent" ;
lin brentwood_PN = foreignPN "Brentwood" ;
lin brescia_PN = foreignPN "Brescia" ;
lin brest_PN = foreignPN "Brest" ;
lin breve_N = mkWN (compoundN "lyhyys" (k5A "merkki")) ; --UNCHK
lin brevet_N = mkWN (k39 "nimitys") ; --UNCHK
lin breviary_N = mkWN (compoundN "rukous" (k9 "kirja")) ; --UNCHK
lin brevity_N = mkWN (k40 "suppeus") ; --UNCHK
lin brew_N = mkN "käymis_tuote" ;
lin brew_V = mkWV (k53A "hauduttaa") ; --UNCHK
lin brew_V2 = mkWV2 (k53A "hauduttaa") ; --UNCHK
lin brewer_N = mkN "oluen" (mkN "panija") ; --mkWN (compoundN "panimo" (k6 "mestari")) ;
lin brewery_N = mkWN (k2 "panimo") ; --UNCHK
lin brewing_N = mkWN (k1 "pano") ; --UNCHK
lin brewpub_N = mkWN (compoundN "panimo" (k12 "ravintola")) ; --UNCHK
lin brian_PN = mkPN "Brian" ;
lin briar_N = mkWN (compoundN "briar" (k1A "piippu")) ; --UNCHK
lin briard_N = mkWN "brienpaimenkoira" ; --UNCHK
lin briarroot_N = mkWN (compoundN "puu" (k10 "kanerva")) ; --UNCHK
lin briarwood_N = mkWN (compoundN "puu" (k10 "kanerva")) ; --UNCHK
lin bribable_A = mkWA (k10 "oleva") "ostettavissa" ; --UNCHK
lin bribe_N = mkWN (k39 "lahjus") ; --UNCHK
lin bribe_V = mkV "lahjoa" ; --mkWV (k53 "ostaa") ;
lin bribe_V2 = mkWV2 (k53 "ostaa") ; --UNCHK
lin briber_N = mkWN (compoundN "lahjuksen" (k10 "antaja")) ; --UNCHK
lin bribery_N = mkWN (k9A "lahjonta") ;
lin brick_N = mkWN (k23 "tiili") ; --UNCHK
lin brick_in_V2 = mkWV2 (k73 "muurata") ; --UNCHK
lin brick_up_V2 = mkWV2 (k73 "muurata") ; --UNCHK
lin brickbat_N = mkWN (k39 "herjaus") ; --UNCHK
lin brickkiln_N = mkWN (compoundN "tiili" (k5 "uuni")) ; --UNCHK
lin bricklayer_N = mkWN (k6 "muurari") ; --UNCHK
lin bricklaying_N = mkWN (k39 "muuraus") ; --UNCHK
lin brickwork_N = mkWN (k39 "muuraus") ; --UNCHK
lin brickyard_N = mkWN (compoundN "tiili" (k41A "tehdas")) ; --UNCHK
lin bridal_A = mkWA "morsius-" ; --UNCHK
lin bride_N = mkWN (k33 "morsian") ; --UNCHK
lin bridecake_N = mkWN (compoundN "morsius" (k1A "kakku")) ; --UNCHK
lin bridegroom_N = mkWN (k38 "sulhanen") ; --UNCHK
lin bridesmaid_N = mkWN (k1 "kaaso") ; --UNCHK
lin bridge_N = mkN "silta" ;
lin bridge_V2 = mkWV2 (k53A "silloittaa") ; --UNCHK
lin bridgeable_A = mkWA "silloitettava" ; --UNCHK
lin bridgehead_N = mkWN (compoundN "sillanpää" (k10 "asema")) ; --UNCHK
lin bridgend_PN = foreignPN "Bridgend" ;
lin bridgnorth_PN = foreignPN "Bridgnorth" ;
lin bridgwater_PN = foreignPN "Bridgwater" ;
lin bridle_N = mkWN (k33A "pidätin") ; --UNCHK
lin bridle_V = mkWV (k53 "hidastaa") ; --UNCHK
lin bridle_V2 = mkWV2 (k53 "hidastaa") ; --UNCHK
lin bridle_path_N = mkWN (compoundN "ratsastus" (k1A "polku")) ; --UNCHK
lin bridle_road_N = mkWN (compoundN "ratsastus" (k1A "polku")) ; --UNCHK
lin bridlington_PN = foreignPN "Bridlington" ;
lin bridoon_N = mkWN "bridongi" ; --UNCHK
lin bridport_PN = foreignPN "Bridport" ;
lin brief_A = mkWA (k43 "lyhyt") ;
lin brief_N = mkWN (k3 "muistio") ; --UNCHK
lin brief_V2 = mkWV2 (k53A "tiedottaa") ; --UNCHK
lin briefcase_N = mkWN (k1A "salkku") ; --UNCHK
lin briefing_N = mkN "opastus" ; --mkWN (compoundN "käskyn" (k1A "jako")) ;
lin briefless_A = mkWA "toimeksiannoton" ; --UNCHK
lin briefness_N = mkWN (k40 "suppeus") ; --UNCHK
lin brier_N = mkWN (compoundN "puu" (k10 "kanerva")) ; --UNCHK
lin brig_N = mkWN (k12 "vankila") ; --UNCHK
lin brig_PN = foreignPN "Brig" ;
lin brigade_N = mkWN (k5 "prikaati") ; --UNCHK
lin brigadier_N = mkWN (compoundN "prikaatin" (k10 "komentaja")) ; --UNCHK
lin brigand_N = mkWN (k5A "bandiitti") ; --UNCHK
lin brigandine_N = mkWN (compoundN "rauta" (k9A "paita")) ; --UNCHK
lin brigantine_N = mkWN (k6 "kuunari") ; --UNCHK
lin brighouse_PN = foreignPN "Brighouse" ;
lin bright_A = mkWA (k10 "loistava") ;
lin bright_Adv = mkWAdv (k99 "kirkkaasti") ; --UNCHK
lin brighten_V = mkWV (k53 "piristää") ; --UNCHK
lin brighten_V2 = mkWV2 (k53 "piristää") ; --UNCHK
lin brightlingsea_PN = foreignPN "Brightlingsea" ;
lin brightness_N = mkWN (k40 "kirkkaus") ; --UNCHK
lin brighton_PN = foreignPN "Brighton" ;
lin brill_N = mkWN (compoundN "silo" (k13 "kampela")) ; --UNCHK
lin brilliance_N = mkWN (k40 "suuruus") ; --UNCHK
lin brilliancy_N = mkWN (k48 "loiste") ; --UNCHK
lin brilliant_A = mkWA (k10 "loistava") ;
lin brilliantine_N = mkWN (compoundN "hius" (k48A "voide")) ; --UNCHK
lin brim_N = mkWN (k5 "lieri") ; --UNCHK
lin brim_V = mkWV (k53A "täyttää") "piripintaan" ; --UNCHK
lin brimful_A = mkWA (k99 "piripinnassa") ; --UNCHK
lin brimfull_A = mkWA (k99 "piripinnassa") ; --UNCHK
lin brimless_A = mkWA "lieritön" ; --UNCHK
lin brimstone_N = mkWN (kH1 "rikki") ; --UNCHK
lin brindled_A = mkWA (k41A "juovikas") ; --UNCHK
lin brine_N = mkWN (compoundN "suola" (k27 "vesi")) ; --UNCHK
lin bring_V2 = mkV2 "tuoda" ;
lin bring_V3 = mkV3 (mkV "saattaa") accusative (mkPrep illative) ; --saattaa hänet vankilaan
lin bring_about_V2 = mkWV2 (k63 "saada") "aikaan" ; --UNCHK
lin bring_along_V2 = prepV2 (lin V OP_bring_V2) OP_along_Prep ; -- guess-p-verb
lin bring_around_V2 = mkWV2 (k53A "herättää") ; --UNCHK
lin bring_away_V2 = mkV2 (advV (lin V OP_bring_V2) OP_away_Adv ) ; -- guess-p-verb
lin bring_back_V2 = mkWV2 (k53A "herättää") ; --UNCHK
lin bring_down_V2 = mkWV2 (k54A "madaltaa") ; --UNCHK
lin bring_forth_V = mkWV (k53A "siittää") ; --UNCHK
lin bring_forth_V2 = mkWV2 (k53A "siittää") ; --UNCHK
lin bring_forward_V2 = mkWV2 (k67A "esitellä") ; --UNCHK
lin bring_in_V2 = mkWV2 (k64 "tuoda") ; --UNCHK
lin bring_off_V2 = mkWV2 (k52A "suoriutua") ; --UNCHK
lin bring_on_V2 = mkWV2 (k63 "saada") "aikaan" ; --UNCHK
lin bring_out_V2 = mkWV2 (k64 "tuoda") "esille" ; --UNCHK
lin bring_out_in_V3 = variants {} ; -- guess-p-verb
lin bring_over_V2 = prepV2 (lin V OP_bring_V2) OP_over_Prep ; -- guess-p-verb
lin bring_round_V2 = mkWV2 (k53A "herättää") ; --UNCHK
lin bring_to_V2 = mkWV2 (k53A "herättää") ; --UNCHK
lin bring_up_V2 = mkWV2 (k53 "käynnistää") "uudelleen" ; --UNCHK
lin brininess_N = mkWN (k40 "suolaisuus") ; --UNCHK
lin brink_N = mkWN (k41A "parras") ; --UNCHK
lin brinkmanship_N = mkWN (k2 "tasapainoilu") ; --UNCHK
lin briny_A = mkWA (k38 "suolainen") ; --UNCHK
lin brioche_N = mkWN (k5 "briossi") ; --UNCHK
lin briquet_N = mkWN (k5A "briketti") ; --UNCHK
lin briquette_N = mkWN (k5A "briketti") ; --UNCHK
lin brisance_N = mkWN "sirpaloituminen" ; --UNCHK
lin brisant_A = mkWA "sirpaloituva" ; --UNCHK
lin brisbane_PN = foreignPN "Brisbane" ;
lin brisk_A = mkWA (k41A "vilkas") ; --UNCHK
lin brisket_N = mkWN (k9A "rinta") ; --UNCHK
lin brisling_N = mkWN (compoundN "kiho" (k5 "haili")) ; --UNCHK
lin bristle_N = mkWN (k9 "karva") ; --UNCHK
lin bristle_V = mkWV (k52 "kiukustua") ; --UNCHK
lin bristlegrass_N = mkWN (compoundN "panta" (k10 "heinä")) ; --UNCHK
lin bristlelike_A = mkWA (compoundA "jouhi" (k38 "mainen")) ; --UNCHK
lin bristletail_N = mkWN (compoundN "kolmi" (k38 "sukahäntäinen")) ; --UNCHK
lin bristly_A = mkWA (k38 "piikkinen") ; --UNCHK
lin bristol_PN = foreignPN "Bristol" ;
lin brit_N = mkWN "ruijanhankajalkainen" ; --UNCHK
lin britain_PN = mkPN "Britannia" ;
lin britannic_A = mkWA (k38 "brittiläinen") ; --UNCHK
lin british_A = mkA "brittiläinen" ;
lin britisher_N = mkWN (k5A "britti") ; --UNCHK
lin briton_A = mkWA (k38 "brittiläinen") ; --UNCHK
lin briton_N = mkWN (k5A "britti") ; --UNCHK
lin brittle_A = mkWA (k11 "hapera") ; --UNCHK
lin brittle_N = mkWN (k20 "toffee") ; --UNCHK
lin brittlebush_N = mkWN (compoundN "farin" (k10 "osa")) "Encelia" ; --UNCHK
lin brittleness_N = mkWN (k40 "hauraus") ; --UNCHK
lin brixham_PN = foreignPN "Brixham" ;
lin brno_PN = foreignPN "Brno" ;
lin broach_V = mkWV (k53A "aloittaa") ; --UNCHK
lin broach_V2 = mkWV2 (k53A "aloittaa") ; --UNCHK
lin broad_A = L.broad_A ;
lin broad_N = mkWN (k38 "naikkonen") ; --UNCHK
lin broadax_N = mkWN (k41 "kirves") ; --UNCHK
lin broadband_A = mkWA (compoundA "laaja" (k38 "kaistainen")) ; --UNCHK
lin broadbill_N = mkWN (k5 "harlekiini") ; --UNCHK
lin broadcast_N = mkWN (k39 "lähetys") ; --UNCHK
lin broadcast_V = mkV (mkV "lähettää") "ohjelmaa" ; --mkWV (k74 "juoruta") ;
lin broadcast_V2 = mkWV2 (k74 "juoruta") ; --UNCHK
lin broadcaster_N = mkWN (k33A "lähetin") ; --UNCHK
lin broadcasting_N = mkN "radiointi" ; --WN (compoundN "tiedotus" (k48 "väline")) ;
lin broadcloth_N = mkWN (k9A "verka") ; --UNCHK
lin broaden_V = mkWV (k72 "levetä") ; --UNCHK
lin broaden_V2 = mkV2 "laajentaa" partitive ;
lin broadening_N = mkWN "avartaminen" ; --UNCHK
lin broadleaf_A = mkWA (compoundA "iso" (k38 "lehtinen")) ; --UNCHK
lin broadloom_A = mkWA "kudottu" ; --UNCHK
lin broadloom_N = mkWN (k1A "matto") "kudottu" ; --UNCHK
lin broadness_N = mkWN (k40 "leveys") ; --UNCHK
lin broadsheet_N = mkWN (k38 "lehtinen") ; --UNCHK
lin broadside_A = mkWA (k99 "vasten") "kylkeä" ; --UNCHK
lin broadside_Adv = mkWAdv (k99 "kyljittäin") ; --UNCHK
lin broadside_N = mkWN (compoundN "täys" (k38 "laidallinen")) ; --UNCHK
lin broadsword_N = mkWN (compoundN "lyömä" (k9A "miekka")) ; --UNCHK
lin broadtail_N = mkWN (compoundN "karakul" (k41A "lammas")) ; --UNCHK
lin broadwise_Adv = mkWAdv (compoundAdv "leveys" (k99 "suuntaisesti")) ; --UNCHK
lin broby_PN = mkPN "Broby" ;
lin brocade_N = mkWN (k5 "brokadi") ; --UNCHK
lin brocade_V2 = mkWV2 (k52A "kutoa") "brokadia" ; --UNCHK
lin broccoli_N = mkWN (compoundN "parsa" (k5 "kaali")) ; --UNCHK
lin brochette_N = mkWN (k41A "varras") ; --UNCHK
lin brochure_N = mkWN (k48A "esite") ; --UNCHK
lin brocket_N = mkWN (compoundN "puna" (k9 "peura")) ; --UNCHK
lin brodiaea_N = mkWN (compoundN "Brodiaea-" (k1A "suku")) ; --UNCHK
lin brogan_N = mkWN (k10A "kenkä") "tukeva" ; --UNCHK
lin brogue_N = mkWN (k10A "kenkä") "tukeva" ; --UNCHK
lin broil_N = mkWN (k39 "grillaus") ; --UNCHK
lin broil_V = mkWV (k73 "grillata") ; --UNCHK
lin broil_V2 = mkWV2 (k73 "grillata") ; --UNCHK
lin broiler_N = mkWN (k12 "parila") ; --UNCHK
lin broke_A = mkWA (k38 "persaukinen") ; --UNCHK
lin broken_A = variants {} ; --
lin broken_hearted_A = mkWA (k34A "lohduton") ; --UNCHK
lin broker_N = mkN "välittäjä" ;
lin brokerage_N = mkWN (compoundN "pankkiiri" (k48A "liike")) ;
lin brolly_N = mkWN (k10 "sontsa") ; --UNCHK
lin brome_N = mkWN (k12 "kattara") ; --UNCHK
lin bromic_A = mkWA "bromi-" ; --UNCHK
lin bromide_N = mkWN (k5A "trivialiteetti") ; --UNCHK
lin bromidic_A = mkWA "bromidi-" ; --UNCHK
lin bromine_N = mkWN (k5 "bromi") ; --UNCHK
lin bromley_PN = foreignPN "Bromley" ;
lin bromoform_N = mkWN (compoundN "tribromi" (k5 "metaani")) ; --UNCHK
lin bromsgrove_PN = foreignPN "Bromsgrove" ;
lin bronchial_A = mkWA (compoundA "bronkia" (k38 "alinen")) ; --UNCHK
lin bronchiolar_A = mkWA "bronkioli-" ; --UNCHK
lin bronchitic_A = mkWA (compoundA "bronkiitti" (k38 "nen")) ; --UNCHK
lin bronchitis_N = mkWN (k5A "bronkiitti") ; --UNCHK
lin bronchopneumonia_N = mkWN "pesäkekeuhkokuume" ; --UNCHK
lin bronchoscope_N = mkWN (compoundN "bronkosko" (k5A "oppi")) ; --UNCHK
lin bronchoscopic_A = mkWA "bronkoskooppinen" ; --UNCHK
lin bronchospasm_N = mkWN (compoundN "bronko" (k5 "spasmi")) ; --UNCHK
lin bronchus_N = mkWN (compoundN "keuhko" (k7 "putki")) ; --UNCHK
lin bronco_N = mkWN (k50 "villihevonen") ; --UNCHK
lin bronze_A = mkWA (k38 "pronssinen") ; --UNCHK
lin bronze_N = mkWN (compoundN "pronssi" (k41 "patsas")) ; --UNCHK
lin bronze_V = mkWV (k52A "päivettyä") ; --UNCHK
lin bronze_V2 = mkWV2 (k52A "päivettyä") ; --UNCHK
lin brooch_N = mkWN (compoundN "rinta" (k9 "neula")) ; --UNCHK
lin brood_N = mkWN (k41 "katras") ; --UNCHK
lin brood_V = mkWV (k73 "suojata") ; --UNCHK
lin brood_hen_N = mkWN (k9 "kana") "hautomahaluinen" ; --UNCHK
lin brooding_N = mkWN (k40 "mietteliäisyys") ; --UNCHK
lin brood_mare_N = mkWN (compoundN "siitos" (k9 "tamma")) ; --UNCHK
lin broody_A = mkWA (k10 "harkitseva") ; --UNCHK
lin brook_N = mkWN (k1 "puro") ; --UNCHK
lin brook_V2 = mkWV2 (k69 "suvaita") ; --UNCHK
lin brooklet_N = mkWN (compoundN "puro" (k38 "nen")) ; --UNCHK
lin brooklime_N = mkWN (k48A "tädyke") ; --UNCHK
lin brookweed_N = mkWN (compoundN "suola" (k10A "punka")) ; --UNCHK
lin broom_N = mkWN (k9 "harja") ; --UNCHK
lin broomcorn_N = mkWN (compoundN "luuta" (k10 "durra")) ; --UNCHK
lin broomstick_N = mkWN (compoundN "luudan" (k28 "varsi")) ; --UNCHK
lin broomweed_N = mkWN "Gutierrezia" "texana" ; --UNCHK
lin broth_N = mkWN (k25 "liemi") ; --UNCHK
lin brothel_N = mkWN (k12 "porttola") ; --UNCHK
lin brother_N = exceptNomN (mkN "velji" "veljen" "veljiä") "veli" ;
lin brother_N2 = L.brother_N2 ;
lin brotherhood_N = mkWN (k40 "veljeys") ; --UNCHK
lin brotherly_A = mkWA (k38 "veljellinen") ; --UNCHK
lin brotherly_Adv = mkWAdv (k99 "veljellisesti") | adjAdv brotherly_A ; --UNCHK -- derived
lin brotula_N = mkWN (compoundN "Bythitidae-ala" (k1 "lahko")) ; --UNCHK
lin brougham_N = mkWN "brougham" ; --UNCHK
lin broughton_PN = foreignPN "Broughton" ;
lin brouhaha_N = mkWN (k39 "touhotus") ; --UNCHK
lin brow_N = mkWN (compoundN "kulma" (k9 "karva")) ; --UNCHK
lin browbeat_V2 = mkWV2 (k67A "pelotella") ; --UNCHK
lin brown_A = L.brown_A ;
lin brown_N = mkWN (compoundN "yli" (k2 "opisto")) "Brownin" ; --UNCHK
lin brown_V = mkWV (k73 "värjätä") "ruskeaksi" ; --UNCHK
lin brown_V2 = mkWV2 (k73 "värjätä") "ruskeaksi" ; --UNCHK
lin brownie_N = mkWN (compoundN "suklaa" (k39 "leivos")) ; --UNCHK
lin brownish_A = mkWA (k10 "ruskehtava") ; --UNCHK
lin brownstone_N = mkWN (compoundN "rivi" (k1 "talo")) ; --UNCHK
lin browntail_N = mkWN "Euproctis" "phaeorrhoea" ; --UNCHK
lin browse_N = mkWN (k38 "syöminen") ; --UNCHK
lin browse_V = mkWV (k67 "maistella") ; --UNCHK
lin broxburn_PN = foreignPN "Broxburn" ;
lin bruce_PN = foreignPN "Bruce" ;
lin brucellosis_N = mkWN (compoundN "luoma" (k5A "tauti")) ; --UNCHK
lin brucine_N = mkWN "brusiini" ; --UNCHK
lin bruges_PN = foreignPN "Bruges" ;
lin bruin_N = mkWN (k1 "karhu") ; --UNCHK
lin bruise_N = mkWN (k10 "mustelma") ; --UNCHK
lin bruise_V = mkWV (k61 "kolhia") ; --UNCHK
lin bruise_V2 = mkWV2 (k61 "kolhia") ; --UNCHK
lin bruiser_N = mkWN (k38 "jättiläinen") ; --UNCHK
lin bruit_V2 = mkWV2 (k74 "juoruta") ; --UNCHK
lin brumal_A = mkWA (k38 "talvinen") ; --UNCHK
lin brumous_A = mkWA (k38 "sumuinen") ; --UNCHK
lin brunch_N = mkWN (k5 "brunssi") ; --UNCHK
lin brunei_PN = foreignPN "Brunei" ;
lin bruneian_A = mkWA (compoundA "brunei" (k38 "lainen")) ; --UNCHK
lin bruneian_N = mkWN (compoundN "brunei" (k38 "lainen")) ; --UNCHK
lin brunet_A = mkWA (compoundA "risti" (k38 "verinen")) ; --UNCHK
lin brunet_N = mkWN (k4A "tummaverikkö") ; --UNCHK
lin brunetteFem_N = mkWN (k4A "tummaverikkö") ; --UNCHK
lin brunetteMasc_N = mkWN (k4A "tummaverikkö") ; --UNCHK
lin brunswick_PN = foreignPN "Brunswick" ;
lin brunt_N = mkN "haittavaikutus" ;
lin brush_N = mkWN (compoundN "yhteen" (k1A "otto")) ; --UNCHK
lin brush_V = mkWV (k61A "pyyhkiä") ;
lin brush_V2 = mkWV2 (k61A "pyyhkiä") ; --UNCHK
lin brush_aside_V = mkWV (k73 "tyrmätä") ; --UNCHK
lin brush_off_V2 = mkWV2 (k73 "tyrmätä") ; --UNCHK
lin brush_up_V2 = mkWV2 (k53A "kehittää") ; --UNCHK
lin brushlike_A = mkWA (compoundA "harja" (k38 "mainen")) ; --UNCHK
lin brushwood_N = mkWN (k4A "pöheikkö") ; --UNCHK
lin brushwork_N = mkWN (compoundN "maalaus" (k9A "tapa")) ; --UNCHK
lin brusque_A = mkWA (k15 "töykeä") ; --UNCHK
lin brusqueness_N = mkWN (k40 "karkeus") ; --UNCHK
lin brussels_PN = foreignPN "Bryssel" ;
lin brut_A = mkWA (k10 "kuiva") ; --UNCHK
lin brutal_A = mkWA (k34A "säälimätön") ; --UNCHK
lin brutality_N = mkWN (k40 "brutaalius") ; --UNCHK
lin brutalization_N = mkWN (compoundN "eläimellis" (k38 "tyminen")) ; --UNCHK
lin brutalize_V2 = mkWV2 (k52 "raaistua") ; --UNCHK
lin brute_N = mkWN (k3 "olio") ; --UNCHK
lin brutish_A = mkWA (k38 "petomainen") ; --UNCHK
lin bruxism_N = mkWN (compoundN "bruks" (k5 "ismi")) ; --UNCHK
lin bryan_PN = foreignPN "Bryan" ;
lin bryanthus_N = mkWN (compoundN "kanerva" (k5 "kasvi")) ; --UNCHK
lin bryony_N = mkWN (compoundN "koiran" (k39 "köynnös")) ; --UNCHK
lin bryophyte_N = mkWN (k5 "kasvi") "juureton" ; --UNCHK
lin bryophytic_A = mkWA "sammal-" ; --UNCHK
lin bryozoan_N = mkWN (compoundN "sammal" (k33 "eläin")) ; --UNCHK
lin bubaline_A = mkWA "puhveli-" ; --UNCHK
lin bubble_N = mkWN (k1A "kupu") ; --UNCHK
lin bubble_V = mkWV (k66 "röyhtäistä") ; --UNCHK
lin bubble_over_V = mkWV (k74 "pursuta") ; --UNCHK
lin bubbler_N = mkWN (compoundN "juoma" (k1 "suihku")) ; --UNCHK
lin bubbliness_N = mkWN "poreilevuus" ; --UNCHK
lin bubbly_A = mkWA (k41A "vilkas") ; --UNCHK
lin bubbly_N = mkWN (k5 "kuohuviini") ; --UNCHK
lin bubo_N = mkWN (compoundN "Bubo-" (k1A "suku")) ; --UNCHK
lin bubonic_A = mkWA "paise-" ; --UNCHK
lin buccal_A = mkWA (compoundA "bukka" (k38 "alinen")) ; --UNCHK
lin buccaneer_N = mkWN (k5A "piraatti") ; --UNCHK
lin buck_N = mkN "taala" ; ---ARB --mkWN (k41 "koiras") ; --mkN "pukki" ;
lin buck_V = mkWV (k62 "vikuroida") ; --UNCHK
lin buck_V2 = mkV2 "vastustaa" partitive ; --mkWV2 (k62 "vikuroida") ;
lin buck_up_V2 = mkWV2 (k66 "rohkaista") "mielensä" ; --UNCHK
lin bucket_N = mkWN (k1A "sanko") ; --UNCHK
lin bucket_V = mkWV (k53A "kuljettaa") ; --UNCHK
lin bucketful_N = mkWN (k38 "sangollinen") ; --UNCHK
lin buckeye_N = mkWN (compoundN "ohio" (k38 "lainen")) ; --UNCHK
lin buckhaven_PN = foreignPN "Buckhaven" ;
lin buckie_PN = foreignPN "Buckie" ;
lin buckingham_PN = foreignPN "Buckingham" ;
lin buckle_N = mkWN (k7A "solki") ; --UNCHK
lin buckle_V = mkWV (k52A "vääntyä") ; --UNCHK
lin buckle_V2 = mkWV2 (k52A "vääntyä") ; --UNCHK
lin buckle_down_V = mkWV (k67 "ponnistella") ; --UNCHK
lin buckle_under_V = mkWV (k53A "luovuttaa") ; --UNCHK
lin buckler_N = mkWN (k6 "panssari") ; --UNCHK
lin buckley_PN = foreignPN "Buckley" ;
lin buckleya_N = mkWN "Buckleya" "distichophylla" ; --UNCHK
lin buckminsterfullerene_N = mkWN "pallofulleriini" ; --UNCHK
lin buckram_N = mkWN (k41A "tukikangas") ; --UNCHK
lin bucksaw_N = mkWN (compoundN "poka" (k9 "saha")) ; --UNCHK
lin buckshee_A = mkWA (k38 "ilmainen") ; --UNCHK
lin buckskin_N = mkWN "ruunivoikko" ; --UNCHK
lin buckthorn_N = mkWN (k2 "ratamo") "suikealehtinen" ; --UNCHK
lin bucktooth_N = mkWN (compoundN "etu" (k41A "hammas")) ; --UNCHK
lin buckwheat_N = mkWN (kH1 "tattari") ; --UNCHK
lin bucolic_A = mkWA "laidun-" ; --UNCHK
lin bud_N = mkWN (k1A "nuppu") ; --UNCHK
lin bud_V = mkWV (k53 "orastaa") ; --UNCHK
lin budapest_PN = foreignPN "Budapest" ;
lin buddhism_N = mkWN (k40 "buddhalaisuus") ; --UNCHK
lin buddhistFem_N = mkWN "buddhisti" ; --UNCHK
lin buddhistMasc_N = mkWN "buddhisti" ; --UNCHK
lin budding_N = mkWN "budding" ; --UNCHK
lin buddy_N = mkWN (k10 "tuttava") ; --UNCHK
lin budge_V = mkWV (k52A "myöntyä") ;
lin budge_V2 = mkWV2 (k52A "myöntyä") ; --UNCHK
lin budgerigar_N = mkWN (k5A "undulaatti") ; --UNCHK
lin budget_N = mkWN (k5A "budjetti") ;
lin budget_V = mkWV (k62 "budjetoida") ; --UNCHK
lin budget_V2 = mkWV2 (k62 "budjetoida") ; --UNCHK
lin budgetary_A = mkA (separateN "budjettiin" (mkN "liittyvä")) ;
lin budgie_N = mkWN (k5A "undulaatti") ; --UNCHK
lin buff_A = mkWA (compoundA "ruskean" (k38 "keltainen")) ; --UNCHK
lin buff_N = mkWN (kH1 "suoja") ; --UNCHK
lin buff_V2 = mkWV2 (k53A "kiillottaa") ; --UNCHK
lin buffalo_N = mkWN (k6 "puhveli") "vanhan" "maailman" ; --UNCHK
lin buffalo_PN = foreignPN "Buffalo" ;
lin buffalofish_N = mkWN (compoundN "Ictiobus-" (k1A "suku")) ; --UNCHK
lin buffer_N = mkWN (kH1 "suoja") ; --UNCHK
lin buffer_V2 = mkWV2 (k62 "puskuroida") ; --UNCHK
lin buffet_N = mkWN (k5A "senkki") ; --UNCHK
lin buffet_V = mkWV (k73 "piiskata") ; --UNCHK
lin buffet_V2 = mkV2 "kolhia" ; --WV2 (k73 "piiskata") ;
lin bufflehead_N = mkWN (compoundN "pikku" (k10A "telkkä")) ; --UNCHK
lin buffoon_N = mkWN (k5 "narri") ; --UNCHK
lin buffoonery_N = mkWN (k2 "kujeilu") ; --UNCHK
lin buffoonish_A = mkWA (compoundA "klovni" (k38 "mainen")) ; --UNCHK
lin bufo_N = mkWN (compoundN "rupi" (k4A "sammakko")) ; --UNCHK
lin bug_N = mkWN (k6 "bakteeri") ; --UNCHK
lin bug_V2 = mkWV2 (k69 "häiritä") ; --UNCHK
lin bug_out_V = mkWV (k53A "revähtää") "auki" ; --UNCHK
lin bugaboo_N = mkWN (k10 "uhka") ; --UNCHK
lin bugbane_N = mkWN "kimikki" ; --UNCHK
lin bugbear_N = mkWN (k1A "mörkö") ; --UNCHK
lin bugger_N = mkWN (k1 "homo") ; --UNCHK
lin bugger_V = mkWV (k53 "harrastaa") "anaaliseksiä" ; --UNCHK
lin bugger_V2 = mkWV2 (k53 "harrastaa") "anaaliseksiä" ; --UNCHK
lin bugger_all_N = mkWN (k99 "yhtään") "ei" ; --UNCHK
lin buggery_N = mkWN (k12 "sodomia") ; --UNCHK
lin bugginess_N = mkWN (k40 "virheellisyys") ; --UNCHK
lin buggy_A = mkWA (compoundA "ötökkä" (k38 "inen")) ; --UNCHK
lin bugle_N = mkWN (k7 "torvi") ; --UNCHK
lin bugler_N = mkWN (compoundN "torven" (k10 "soittaja")) ; --UNCHK
lin bugleweed_N = mkWN (compoundN "akan" (k5 "kaali")) ; --UNCHK
lin bugloss_N = mkWN (compoundN "keltano" (k2 "kitkerö")) ; --UNCHK
lin buhl_N = mkWN (compoundN "boulle-" (k39 "upotus")) ; --UNCHK
lin build_N = mkWN (k48A "rakenne") ; --UNCHK
lin build_V = mkV "rakentaa" ;
lin build_V2 = mkV2 "rakentaa" | mkV2 (mkV "rakentaa") partitive ;
lin build_up_V2 = mkWV2 (k53A "kehittää") ; --UNCHK
lin builder_N = mkWN (k10 "rakentaja") ; --UNCHK
lin building_N = mkN "rakennus" ;
lin building_society_N = mkWN (compoundN "asuntolaina" (k2 "rahasto")) ; --UNCHK
lin build_up_N = mkWN (k39 "lisäys") ; --UNCHK
lin built_in_A = mkA "sisäänrakennettu" ;
lin bulb_N = mkWN (k1A "kupu") ; --UNCHK
lin bulbaceous_A = mkWA "sipuli-" ; --UNCHK
lin bulbar_A = mkWA "ydinjatke-" ; --UNCHK
lin bulbed_A = mkWA (compoundA "polttimo" (k38 "llinen")) ; --UNCHK
lin bulbil_N = mkWN (k12 "mukula") ; --UNCHK
lin bulblike_A = mkWA (compoundA "sipulin" (k38 "muotoinen")) ; --UNCHK
lin bulbous_A = mkWA (compoundA "kupu" (k38 "mainen")) ; --UNCHK
lin bulbul_N = mkWN "bulbuli" ; --UNCHK
lin bulgaria_PN = foreignPN "Bulgaria" ;
lin bulgarianFem_N = mkN "bulgaari" | mkN "bulgarialainen" ;
lin bulgarianMasc_N = mkN "bulgaari" | mkN "bulgarialainen" ;
lin bulgarian_A = mkWA (k38 "bulgarialainen") ;
lin bulge_N = mkWN (k48A "uloke") ; --UNCHK
lin bulge_V = mkWV (k54A "suurentaa") ; --UNCHK
lin bulge_V2 = mkWV2 (k54A "suurentaa") ; --UNCHK
lin bulgur_N = mkWN (compoundN "bulgur" (k10 "vehnä")) ; --UNCHK
lin bulimarexia_N = mkWN (compoundN "nerv" (k10 "osa")) "bulimia" ; --UNCHK
lin bulimia_N = mkWN (k12 "bulimia") ; --UNCHK
lin bulimic_A = mkWA "buliminen" ; --UNCHK
lin bulimic_N = mkWN "bulimikko" ; --UNCHK
lin bulk_N = mkWN (compoundN "aine" (k10 "määrä")) ; --UNCHK
lin bulk_V = mkWV (k54A "suurentaa") ; --UNCHK
lin bulkhead_N = mkWN (k3 "laipio") ; --UNCHK
lin bulkiness_N = mkWN (k40 "massiivisuus") ; --UNCHK
lin bulkington_PN = foreignPN "Bulkington" ;
lin bulky_A = mkWA (kH1 "iso") ; --UNCHK
lin bull's_eye_N = mkWN (k39 "menestys") ; --UNCHK
lin bull_N = mkN "härkä" ; ---ARB --mkWN (k39 "munaus") ;
lin bull_neck_N = mkWN (k9 "niska") "paksu" ; --UNCHK
lin bull_terrier_N = mkWN (compoundN "bull" (k5 "terrieri")) ; --UNCHK
lin bulla_N = mkWN (k10 "bulla") ; --UNCHK
lin bullace_N = mkWN (k12 "kriikuna") ; --UNCHK
lin bullbrier_N = mkWN "Smilax" "rotundifolia" ; --UNCHK
lin bulldog_N = mkWN (k5 "bulldoggi") ; --UNCHK
lin bulldoze_V2 = mkWV2 (k73 "raivata") ; --UNCHK
lin bulldozer_N = mkWN (compoundN "raivaus" (k6 "traktori")) ; --UNCHK
lin bullet_N = mkN "luoti" ; --WN (k1A "syöttö") "nopea" ;
lin bullethead_N = mkWN (k7A "kärki") "suippo" ; --UNCHK
lin bulletin_N = mkWN (k48A "tiedote") ; --UNCHK
lin bulletproof_A = mkWA (compoundA "luodin" (k10 "kestävä")) ; --UNCHK
lin bullfight_N = mkWN (compoundN "härkä" (k2 "taistelu")) ; --UNCHK
lin bullfighter_N = mkWN (k5 "toreadori") ; --UNCHK
lin bullfighting_N = mkWN (compoundN "härkä" (k2 "taistelu")) ; --UNCHK
lin bullfinch_N = mkWN (k1A "punatulkku") ; --UNCHK
lin bullfrog_N = mkWN (compoundN "härkä" (k4A "sammakko")) ; --UNCHK
lin bullhead_N = mkWN (compoundN "monni" (k9 "kala")) ; --UNCHK
lin bull_headed_A = mkWA (compoundA "jää" (k38 "räpäinen")) ; --UNCHK
lin bullhorn_N = mkWN (k5 "megafoni") ; --UNCHK
lin bullion_N = mkWN (compoundN "kulta" (k1A "harkko")) ; --UNCHK
lin bullish_A = mkWA (compoundA "nousu" (k38 "suuntainen")) ; --UNCHK
lin bullnecked_A = mkWA (compoundA "paksu" (k38 "niskainen")) ; --UNCHK
lin bullnose_N = mkWN (compoundN "nokkaolka" (k10 "höylä")) ; --UNCHK
lin bullock_N = mkWN (k10A "härkä") ; --UNCHK
lin bullocky_A = mkWA (compoundA "härkä" (k38 "mäinen")) ; --UNCHK
lin bullpen_N = mkWN (compoundN "yhteis" (k5 "selli")) ; --UNCHK
lin bullring_N = mkWN (compoundN "härkätaistelu" (k13 "areena")) ; --UNCHK
lin bullshit_N = mkWN (k1 "fusku") ; --UNCHK
lin bullshit_V = mkWV (k67A "teeskennellä") ; --UNCHK
lin bully_A = mkWA (k3 "mainio") ; --UNCHK
lin bully_N = mkWN (k10 "rettelöijä") ; --UNCHK
lin bully_V = mkWV (k67A "pelotella") ; --UNCHK
lin bully_V2 = mkWV2 (k67A "pelotella") ; --UNCHK
lin bullyboy_N = mkWN (k6 "päällepäsmäri") ; --UNCHK
lin bullying_N = mkWN (k2 "uhkailu") ; --UNCHK
lin bulrush_N = mkWN (compoundN "röyhy" (k12 "vihvilä")) ; --UNCHK
lin bulwark_N = mkWN (compoundN "ranta" (k49A "penger")) ; --UNCHK
lin bum_A = mkWA (k2 "tökerö") ; --UNCHK
lin bum_N = mkWN (k1 "takalisto") ; --UNCHK
lin bum_V = mkWV (k67 "siipeillä") ; --UNCHK
lin bum_V2 = mkWV2 (k67 "siipeillä") ; --UNCHK
lin bumblebee_N = mkWN (k38 "kimalainen") ; --UNCHK
lin bumbling_A = mkWA (k10A "jäykkä") "liikkeissään" ; --UNCHK
lin bumboat_N = mkWN (compoundN "kauppa" (k48 "vene")) ; --UNCHK
lin bumf_N = mkWN (compoundN "paperi" (k48 "saaste")) ; --UNCHK
lin bummer_N = mkWN (k5A "trippi") "huono" ; --UNCHK
lin bump_N = mkWN (k39 "törmäys") ; --UNCHK
lin bump_V = mkWV (k73 "törmätä") ; --UNCHK
lin bump_V2 = mkWV2 (k73 "törmätä") ; --UNCHK
lin bump_into_V2 = mkWV2 (k52A "iskeytyä") "jhkin" ; --UNCHK
lin bump_off_V2 = mkWV2 (k73 "raivata") "tieltään" ; --UNCHK
lin bump_up_V2 = mkWV2 (k53 "nostaa") ; --UNCHK
lin bumper_N = mkWN (k6 "puskuri") ; --UNCHK
lin bumpiness_N = mkWN (compoundN "epä" (k40 "tasaisuus")) ; --UNCHK
lin bumpkin_N = mkWN (k6 "öykkäri") ; --UNCHK
lin bumpkinly_A = mkWA (k34A "sivistymätön") ; --UNCHK
lin bumptious_A = mkWA (k10 "koppava") ; --UNCHK
lin bumptiousness_N = mkWN (k40 "pöyhkeys") ; --UNCHK
lin bumpy_A = mkWA (k38 "kuoppainen") ; --UNCHK
lin bun_N = mkWN (k10 "pulla") ; --UNCHK
lin buna_N = mkWN (compoundN "buna-" (k5 "kumi")) ; --UNCHK
lin bunch_N = mkWN (k1A "nippu") ;
lin bunch_V = mkWV (k74A "koota") "rykelmäksi" ; --UNCHK
lin bunch_V2 = mkWV2 (k74A "koota") "rykelmäksi" ; --UNCHK
lin bunchberry_N = mkWN (compoundN "kanadanruohokan" (k10A "nukka")) ; --UNCHK
lin bunchgrass_N = mkWN (k10 "heinä") ; --UNCHK
lin bunchy_A = mkWA (compoundA "terttu" (k38 "mainen")) ; --UNCHK
lin bunco_N = mkWN (k39 "huijaus") ; --UNCHK
lin bundle_N = mkWN (k1A "kimppu") ; --UNCHK
lin bundle_V = mkWV (k52A "nukkua") "yhdessä" ; --UNCHK
lin bundle_V2 = mkWV2 (k52A "nukkua") "yhdessä" ; --UNCHK
lin bundle_off_V2 = mkWV2 (k53A "passittaa") ; --UNCHK
lin bundle_up_V = mkWV (k52A "pukeutua") ; --UNCHK
lin bundle_up_V2 = mkWV2 (k52A "pukeutua") ; --UNCHK
lin bundling_N = mkWN "sysääminen" ; --UNCHK
lin bung_N = mkWN (k5A "tappi") ; --UNCHK
lin bung_V2 = mkWV2 (k73A "tulpata") ; --UNCHK
lin bungaloid_A = mkWA (compoundA "rakenne" (k1 "ttu")) "matalaan" ; --UNCHK
lin bungalow_N = mkWN (k9 "maja") ; --UNCHK
lin bungee_N = mkWN (compoundN "benji" (k27 "köysi")) ; --UNCHK
lin bung_hole_N = mkWN (compoundN "tapin" (k10A "reikä")) ; --UNCHK
lin bungle_N = mkWN (k48 "virhe") ; --UNCHK
lin bungle_V = mkWV (k62 "hutiloida") ; --UNCHK
lin bungle_V2 = mkWV2 (k62 "hutiloida") ; --UNCHK
lin bungler_N = mkWN (k10 "hutiloija") ; --UNCHK
lin bunion_N = mkWN (compoundN "vaivaisen" (k18 "luu")) ; --UNCHK
lin bunk_N = mkWN (kH1 "punkka") ; --UNCHK
lin bunk_V = mkWV (k52A "häipyä") ; --UNCHK
lin bunk_off_V = mkWV (k73 "pinnata") ; --UNCHK
lin bunker_N = mkWN (k6 "bunkkeri") ; --UNCHK
lin bunker_V = mkWV (k64 "lyödä") "hiekkaesteeseen" ; --UNCHK
lin bunker_V2 = mkWV2 (k64 "lyödä") "hiekkaesteeseen" ; --UNCHK
lin bunkmate_N = mkWN (compoundN "tupa" (k6 "kaveri")) ; --UNCHK
lin bunkum_N = mkWN (k99 "soopa") ; --UNCHK
lin bunny_N = mkWN (kH1 "kani") ; --UNCHK
lin bunsen_N = mkWN (compoundN "bunsen" (k1A "lamppu")) ; --UNCHK
lin bunt_N = mkWN (k39 "näpäytys") ; --UNCHK
lin buntal_N = mkWN "buntal" ; --UNCHK
lin bunter_N = mkWN "näpäyttäjä" ; --UNCHK
lin bunting_N = mkWN (k1A "sirkku") ; --UNCHK
lin bunyavirus_N = mkWN (compoundN "bunya" (k39 "virus")) ; --UNCHK
lin buoy_N = mkWN (k1 "poiju") ; --UNCHK
lin buoy_V = mkWV (k53A "poijuttaa") ; --UNCHK
lin buoy_V2 = mkWV2 (k53A "poijuttaa") ; --UNCHK
lin buoy_up_V2 = mkWV2 (k52 "piristyä") ; --UNCHK
lin buoyancy_N = mkWN (k40 "iloisuus") ; --UNCHK
lin buoyant_A = mkWA (k15 "virkeä") ; --UNCHK
lin bur_N = mkWN (k10 "pora") ; --UNCHK
lin burberry_N = mkWN "Burberry" ; --UNCHK
lin burble_V = mkWV (k66 "solista") ; --UNCHK
lin burble_VS = mkWVS (k66 "solista") ; --UNCHK
lin burbot_N = mkWN (kH1 "matikka") ; --UNCHK
lin burden_N = mkN "taakka" ;
lin burden_V2 = mkWV2 (k53A "sälyttää") ; --UNCHK
lin burdenless_A = mkWA "taakaton" ; --UNCHK
lin burdensome_A = mkWA (k10 "vaativa") ; --UNCHK
lin burdensomeness_N = mkWN (k40 "rasittavuus") ; --UNCHK
lin burdock_N = mkWN (k38 "takiainen") ; --UNCHK
lin bureau_N = mkN "virasto" ; ---ARB mkWN (k5A "piironki") ;
lin bureaucracy_N = mkWN (k12 "byrokratia") ; --UNCHK
lin bureaucrat_N = mkWN (k5A "byrokraatti") ; --UNCHK
lin bureaucratic_A = mkWA (k38 "byrokraattinen") ; --UNCHK
lin burette_N = mkWN "byretti" ; --UNCHK
lin burg_N = mkWN (k5A "kaupunki") ; --UNCHK
lin burgeon_V = mkWV (k56 "kasvaa") ; --UNCHK
lin burgess_N = mkWN (k38 "kaupunkilainen") ; --UNCHK
lin burgh_N = mkWN (compoundN "kaupunki" (k10A "kunta")) ; --UNCHK
lin burgher_N = mkWN (k32 "jäsen") "keskiluokan" ; --UNCHK
lin burglar_N = mkWN (compoundN "murto" (k41A "varas")) ; --UNCHK
lin burglar_alarm_N = mkWN (compoundN "varas" (k33A "hälytin")) ; --UNCHK
lin burglarious_A = mkWA "murto-" ; --UNCHK
lin burglar_proof_A = mkWA (compoundA "murto" (k9 "varma")) ; --UNCHK
lin burglary_N = mkWN (k1A "murto") ;
lin burgle_V = mkWV (k53 "ryöstää") ; --UNCHK
lin burgle_V2 = mkWV2 (k53 "ryöstää") ; --UNCHK
lin burgomaster_N = mkWN (k6 "pormestari") ; --UNCHK
lin burgoo_N = mkWN (compoundN "liha" (k39 "muhennos")) ; --UNCHK
lin burgos_PN = foreignPN "Burgos" ;
lin burgrass_N = mkWN (compoundN "piikki" (k10 "heinä")) ; --UNCHK
lin burgrave_N = mkWN (compoundN "linnan" (k9 "herra")) ; --UNCHK
lin burgundy_N = mkWN (compoundN "viinin" (k38 "punainen")) ; --UNCHK
lin burial_N = mkWN (k39 "hautaus") ; --UNCHK
lin burial_ground_N = mkWN (k2 "kalmisto") ; --UNCHK
lin burin_N = mkWN (k33A "kaiverrin") ; --UNCHK
lin burke_V2 = mkWV2 (k66 "lakaista") ; --UNCHK
lin burl_N = mkWN (k1A "nyppy") ; --UNCHK
lin burlap_N = mkWN (k41A "juuttikangas") ;
lin burled_A = mkWA (k38 "pahkainen") ; --UNCHK
lin burlesque_A = mkWA "burleski-" ; --UNCHK
lin burlesque_N = mkWN (k39 "huijaus") ; --UNCHK
lin burlesque_V2 = mkWV2 (k62 "parodioida") ; --UNCHK
lin burley_PN = foreignPN "Burley" ;
lin burly_A = mkWA (k9 "vahva") ; --UNCHK
lin burmese_A = mkWA (compoundA "burm" (k38 "alainen")) ; --UNCHK
lin burmese_N = mkWN "burma" ; --UNCHK
lin burn_N = mkN "palo" ;
lin burn_V = L.burn_V ;
lin burn_V2 = mkV2 "polttaa" ;
lin burn_down_V = advV OP_burn_V OP_down_Adv ; -- guess-p-verb
lin burn_down_V2 = prepV2 OP_burn_V OP_down_Prep ; -- guess-p-verb
lin burn_off_V2 = mkWV2 (k53A "polttaa") ; --UNCHK
lin burn_out_V = mkWV (k52A "särkyä") ; --UNCHK
lin burn_up_V = advV OP_burn_V OP_up_Adv ; -- guess-p-verb
lin burn_up_V2 = prepV2 OP_burn_V OP_up_Prep ; -- guess-p-verb
lin burnable_A = mkWA (k10 "palava") ; --UNCHK
lin burner_N = mkWN (k33A "poltin") ; --UNCHK
lin burning_A = variants {} ; --
lin burning_N = mkWN (k1A "poltto") ; --UNCHK
lin burnish_V = mkWV (k53A "kiillottaa") ; --UNCHK
lin burnish_V2 = mkWV2 (k53A "kiillottaa") ; --UNCHK
lin burnley_PN = foreignPN "Burnley" ;
lin burnous_N = mkWN (k1A "kaapu") ; --UNCHK
lin burnouse_N = mkWN (k1A "kaapu") ; --UNCHK
lin burntisland_PN = foreignPN "Burntisland" ;
lin burntwood_PN = foreignPN "Burntwood" ;
lin burn_up_N = mkWN (k39 "kulutus") ; --UNCHK
lin burp_N = mkWN (k2 "röyhtäily") ; --UNCHK
lin burp_V = mkWV (k66 "röyhtäistä") ; --UNCHK
lin burp_V2 = mkWV2 (k66 "röyhtäistä") ; --UNCHK
lin burqa_N = mkWN "burka" ; --UNCHK
lin burr_N = mkWN (k10 "pora") ; --UNCHK
lin burr_drill_N = mkWN (k10 "pora") "hammaslääkärin" ; --UNCHK
lin burrawong_N = mkWN (compoundN "käpy" (k1 "palmu")) ; --UNCHK
lin burrfish_N = mkWN (compoundN "siili" (k9 "kala")) ; --UNCHK
lin burrito_N = mkWN "burrito" ; --UNCHK
lin burrlike_A = mkWA (compoundA "takiais" (k38 "mainen")) ; --UNCHK
lin burro_N = mkWN (compoundN "kuorma-" (k5 "aasi")) ; --UNCHK
lin burrow_N = mkWN (k10 "käytävä") ; --UNCHK
lin burrow_V = mkWV (k52A "kaivautua") ; --UNCHK
lin burrow_V2 = mkWV2 (k52A "kaivautua") ; --UNCHK
lin bursa_N = mkWN (compoundN "nivelvoide" (k5 "pussi")) ; --UNCHK
lin bursal_A = mkWA "bursa-" ; --UNCHK
lin bursar_N = mkWN (compoundN "rahaston" (k10 "hoitaja")) ; --UNCHK
lin bursary_N = mkWN (k2 "rahasto") ; --UNCHK
lin bursitis_N = mkWN "bursiitti" ; --UNCHK
lin burst_N = mkWN (k10 "puuska") ; --UNCHK
lin burst_V = mkWV (k53A "syöksähtää") ; --UNCHK
lin burst_V2 = mkWV2 (k53A "syöksähtää") ; --UNCHK
lin burst_into_V2 = prepV2 OP_burst_V OP_into_Prep ; -- guess-p-verb
lin burthen_N = mkWN (k9A "taakka") ; --UNCHK
lin burthen_V2 = mkWV2 (k67 "olla") "painona" ; --UNCHK
lin burton_N = mkWN "Burton" ; --UNCHK
lin burundi_PN = foreignPN "Burundi" ;
lin burundian_A = mkWA (compoundA "burundi" (k38 "lainen")) ; --UNCHK
lin burundian_N = mkWN (compoundN "burundi" (k38 "lainen")) ; --UNCHK
lin bury_PN = foreignPN "Bury" ;
lin bury_V = mkWV (k53A "unohtaa") ; --UNCHK
lin bury_V2 = mkWV2 (k53A "unohtaa") ; --UNCHK
lin burying_N = mkWN (k39 "hautaus") ; --UNCHK
lin burying_ground_N = mkWN (k2 "kalmisto") ; --UNCHK
lin bus_N = mkN (lin NK {s = d05 "bussi"}) ;
lin bus_V = mkWV (k73 "kerätä") ; --UNCHK
lin bus_V2 = mkWV2 (k73 "kerätä") ; --UNCHK
lin busbar_N = mkWN (compoundN "virta" (k1 "kisko")) ; --UNCHK
lin busboy_N = mkWN (compoundN "astioiden" (k10 "kerääjä")) ; --UNCHK
lin busby_N = mkWN (compoundN "karhunnahka" (k5A "lakki")) ; --UNCHK
lin bush_N = mkWN (k10 "puska") ; --UNCHK
lin bushbuck_N = mkWN (compoundN "kirjo" (k5A "antilooppi")) ; --UNCHK
lin bushel_N = mkN "busheli" ;
lin bushing_N = mkWN (k1 "hylsy") ; --UNCHK
lin bushman_N = mkWN (compoundN "uudis" (k10 "raivaaja")) ; --UNCHK
lin bushtit_N = mkWN (compoundN "pensas" (k38 "tiainen")) ; --UNCHK
lin bushwhacker_N = mkWN (k5 "sissi") ; --UNCHK
lin bushwhacking_A = mkWA (compoundA "piileske" (k10 "levä")) ; --UNCHK
lin bushy_A = mkWA (k15 "tuuhea") ; --UNCHK
lin business_N = mkN "liikeasia" ;
lin businesslike_A = mkWA (k38 "järjestelmällinen") ; --UNCHK
lin businessman_N = mkN "liike" L.man_N ;
lin businessperson_N = mkWN (k6 "porvari") ; --UNCHK
lin businesswoman_N = mkWN (compoundN "liike" (k38 "nainen")) ; --UNCHK
lin busker_N = mkWN (compoundN "katu" (k10 "soittaja")) ; --UNCHK
lin buskin_N = mkWN (compoundN "maihinnousu" (k10A "kenkä")) ; --UNCHK
lin busload_N = mkWN (compoundN "linja-" (k38 "autollinen")) ; --UNCHK
lin busman_N = mkWN (compoundN "linja-auton" (k10 "kuljettaja")) ; --UNCHK
lin buspirone_N = mkWN (compoundN "BuS" (k5 "par")) ; --UNCHK
lin bust_N = mkN "epä" (mkN "onnistuminen") ; ---ARB --mkN "rintakuva" ; --mkWN (k5 "pysti") ;
lin bust_V = mkWV (k74A "haljeta") ; --UNCHK
lin bust_V2 = mkWV2 (k74A "haljeta") ; --UNCHK
lin bust_up_V = mkWV (k58A "särkeä") ; --UNCHK
lin bustard_N = mkWN "trappi" ; --UNCHK
lin bustier_N = mkWN (kH1 "toppi") "olkaimeton" ; --UNCHK
lin bustle_N = mkWN (k39 "touhotus") ; --UNCHK
lin bustle_V = mkWV (k66 "kihistä") ; --UNCHK
lin bustle_V2 = mkWV2 (k66 "kihistä") ; --UNCHK
lin busy_A = mkWA (k38 "kiireinen") ;
lin busy_V2 = mkWV2 (k53 "työllistää") ; --UNCHK
lin busybody_N = mkWN (k12 "utelija") ; --UNCHK
lin busyness_N = mkWN (k12 "hyörinä") ; --UNCHK
lin busywork_N = mkWN (k2 "puuhastelu") ; --UNCHK
lin but_Adv = mkWAdv (k99 "vain") ;
lin but_Conj = mkConj "mutta" ;
lin but_N = mkN "mutta" ;
lin but_PConj = S.but_PConj ;
lin but_Prep = mkPrep "paitsi" nominative ;
lin but_Subj = mkSubj "mutta" ;
lin butacaine_N = mkWN (compoundN "butakaiini" (k5A "sulfaatti")) ; --UNCHK
lin butadiene_N = mkWN "butadieeni" ; --UNCHK
lin butane_N = mkWN (k5 "butaani") ; --UNCHK
lin butanone_N = mkWN (compoundN "metyylietyyli" (k5 "ketoni")) ; --UNCHK
lin butch_A = mkWA (k38 "miesmäinen") ; --UNCHK
lin butch_N = mkWN (k4A "lepakko") ; --UNCHK
lin butcher_N = mkWN (k10 "hutiloija") ; --UNCHK
lin butcher_V2 = mkWV2 (k73A "lahdata") ; --UNCHK
lin butcherbird_N = mkWN (compoundN "huilu" (k39 "varis")) ; --UNCHK
lin butchery_N = mkWN (k39 "teurastus") ; --UNCHK
lin buteonine_A = mkWA (compoundA "hiirihaukka" (k38 "mainen")) ; --UNCHK
lin buteonine_N = mkWN (compoundN "hiiri" (k9A "haukka")) ; --UNCHK
lin butler_N = mkWN (compoundN "hovi" (k6 "mestari")) ;
lin butt_N = mkWN (k10 "perä") ; --UNCHK
lin butt_V = mkWV (k66 "töytäistä") ; --UNCHK
lin butt_V2 = mkWV2 (k66 "töytäistä") ; --UNCHK
lin butt_in_V = mkWV (k52A "sekaantua") ; --UNCHK
lin butte_N = mkWN "Butte" ; --UNCHK
lin butter_N = L.butter_N ;
lin butter_V2 = mkWV2 (k67A "voidella") ; --UNCHK
lin butter_up_V2 = mkWV2 (k67A "imarrella") ; --UNCHK
lin butterbean_N = mkWN (k1A "papu") ; --UNCHK
lin butterbur_N = mkWN (compoundN "etelän" (k26 "ruttojuuri")) ; --UNCHK
lin buttercrunch_N = mkWN (compoundN "jäävuori" (k5A "salaatti")) ; --UNCHK
lin buttercup_N = mkWN (k5A "leinikki") ; --UNCHK
lin butterfat_N = mkWN (compoundN "voi" (k9 "rasva")) ; --UNCHK
lin butterfingers_N = mkWN (compoundN "mämmi" (k10 "koura")) ; --UNCHK
lin butterfish_N = mkWN "Pholis" "gunnellus" ; --UNCHK
lin butterfly_N = mkWN (compoundN "perhos" (k5A "uinti")) ; --UNCHK
lin buttermilk_N = mkWN (compoundN "kirnu" (k10 "piimä")) ; --UNCHK
lin butternut_N = mkWN (compoundN "amerikanjalo" (k12 "pähkinä")) ; --UNCHK
lin butterscotch_N = mkWN (compoundN "kerma" (k20 "toffee")) ; --UNCHK
lin butterweed_N = mkWN (k4A "villakko") ; --UNCHK
lin butterwort_N = mkWN (compoundN "siniyökön" (k7A "lehti")) ; --UNCHK
lin buttery_A = mkWA (k38 "voinen") ; --UNCHK
lin buttery_N = mkWN (k6 "kanttiini") ; --UNCHK
lin buttinsky_N = mkWN "asioihin" "sekaantuja" ; --UNCHK
lin buttock_N = mkWN (k1A "kankku") ; --UNCHK
lin buttocks_N = mkWN (k1 "takalisto") ; --UNCHK
lin button_N = mkWN (k5A "nappi") ;
lin button_V = mkWV (k53A "kiinnittää") "napilla" ; --UNCHK
lin button_V2 = mkWV2 (k53A "kiinnittää") "napilla" ; --UNCHK
lin buttonhole_N = mkWN (k7A "napinläpi") ; --UNCHK
lin buttonhole_V2 = mkWV2 (k73 "lobata") ; --UNCHK
lin buttonhook_N = mkWN (compoundN "nappi" (k1A "koukku")) ; --UNCHK
lin buttonwood_N = mkWN (compoundN "Amerikan" (k6 "plataani")) ; --UNCHK
lin buttony_A = mkWA (k38 "napillinen") ; --UNCHK
lin buttress_N = mkWN (compoundN "tuki" (k41 "pylväs")) ; --UNCHK
lin buttress_V2 = mkWV2 (k58A "tukea") ; --UNCHK
lin butty_N = mkWN "kerrosvoileipä" ; --UNCHK
lin butylene_N = mkWN "buteeni" ; --UNCHK
lin butyraceous_A = mkWA (compoundA "voi" (k38 "mainen")) ; --UNCHK
lin butyric_A = mkWA "butaanihappo-" ; --UNCHK
lin butyrin_N = mkWN "butyriini" ; --UNCHK
lin buxom_A = mkWA (k10 "rehevä") ; --UNCHK
lin buxomness_N = mkWN "muodokkuus" ; --UNCHK
lin buxton_PN = foreignPN "Buxton" ;
lin buy_N = mkN "ostos" ;
lin buy_V = mkV "ostaa" ;
lin buy_V2 = L.buy_V2 ;
lin buy_back_V = mkWV (k53 "lunastaa") ; --UNCHK
lin buy_back_V2 = mkV2 (advV OP_buy_V OP_back_Adv ) ; -- guess-p-verb
lin buy_in_V2 = mkWV2 (k61A "hankkia") "varastoon" ; --UNCHK
lin buy_into_V2 = mkWV2 (k53 "ostaa") "osakkeita" ; --UNCHK
lin buy_off_V2 = mkWV2 (k52 "lahjoa") ; --UNCHK
lin buy_out_V2 = mkWV2 (k53A "ottaa") "haltuunsa" ; --UNCHK
lin buy_up_V2 = mkWV2 (k53A "ottaa") "haltuunsa" ; --UNCHK
lin buyerFem_N = mkWN (k10 "ostaja") ; --f235
lin buyerMasc_N = mkN "ostaja" ;
lin buying_N = mkWN (k1 "osto") ; --UNCHK
lin buyout_N = mkWN (compoundN "yritys" (k39 "valtaus")) ; --UNCHK
lin buzz_N = mkWN (k12 "suhina") ; --UNCHK
lin buzz_V = mkWV (k53A "soittaa") "summeria" ; --UNCHK
lin buzz_V2 = mkWV2 (k53A "soittaa") "summeria" ; --UNCHK
lin buzz_off_V = mkWV (k53A "ottaa") "hatkat" ; --UNCHK
lin buzzard_N = mkWN (compoundN "hiiri" (k9A "haukka")) ; --UNCHK
lin buzzer_N = mkWN (k6 "summeri") ; --UNCHK
lin buzzword_N = mkWN (compoundN "muoti" (k9 "sana")) ; --UNCHK
lin by8agent_Prep = S.by8agent_Prep ;
lin by8means_Prep = S.by8means_Prep ;
lin by_Adv = mkWAdv (k99 "talteen") ; --UNCHK
lin by_Prep = postPrep genitive "kautta" ;
lin by_means_of_Prep = mkPrep "avulla" ;
lin by_virtue_of_Prep = mkPrep "takia" ;
lin bye_Interj = mkInterj "hei sitten" ;
lin bye_bye_Interj = mkInterj "hei hei" ;
lin bygone_A = mkWA (k38 "entinen") ; --UNCHK
lin bylaw_N = mkWN (compoundN "ohje" (k1A "sääntö")) ; --UNCHK
lin bypass_N = mkWN (compoundN "ohikulku" (k19 "tie")) ; --UNCHK
lin bypass_V2 = mkWV2 (k53A "sivuuttaa") ; --UNCHK
lin bypath_N = mkWN (compoundN "sivu" (k19 "tie")) ; --UNCHK
lin byplay_N = mkWN (k14A "mimiikka") ; --UNCHK
lin byproduct_N = mkWN (compoundN "sivu" (k48A "tuote")) ; --UNCHK
lin byroad_N = mkWN (compoundN "sivu" (k19 "tie")) ; --UNCHK
lin byssus_N = mkWN (compoundN "kiinnitys" (k2 "rihmasto")) ; --UNCHK
lin bystander_N = mkWN (k38 "sivullinen") ; --UNCHK
lin byte_N = mkWN (k1 "tavu") ; --UNCHK
lin byway_N = mkWN (compoundN "sivu" (k19 "tie")) ; --UNCHK
lin byword_N = mkWN (k9A "sanonta") ; --UNCHK
lin c_of_e_N = mkN "Englannin " (mkN "kirkko") ; ----sanaliitto
lin cab_N = mkWN (k5 "pirssi") ; --UNCHK
lin cabal_N = mkWN (compoundN "sala" (k48A "hanke")) ; --UNCHK
lin cabala_N = mkWN (compoundN "Qabb" (k9 "ala")) ; --UNCHK
lin cabalist_N = mkWN "kabbalisti" ; --UNCHK
lin cabalistic_A = mkWA (k38 "arvoituksellinen") ; --UNCHK
lin cabana_N = mkWN (compoundN "pukeutumis" (k9A "teltta")) ; --UNCHK
lin cabaret_N = mkWN (k20 "kabaree") ; --UNCHK
lin cabbage_N = mkWN (k5 "kaali") ; --UNCHK
lin cabbageworm_N = mkWN (compoundN "nauris" (k38 "perhonen")) ; --UNCHK
lin cabby_N = mkWN (k14A "vossikka") ; --UNCHK
lin caber_N = mkWN (k5A "tukki") ; --UNCHK
lin cabin_N = mkWN (k2 "matkustamo") ; --UNCHK
lin cabinet_N = mkWN (k2 "kaapisto") ; --UNCHK
lin cabinet_maker_N = mkWN "huonekalupuuseppä" ; --UNCHK
lin cabinetmaking_N = mkWN (compoundN "puusepän" (k19 "työ")) ; --UNCHK
lin cabinetwork_N = mkWN (compoundN "huonekalupuusepän" (k19 "työ")) ; --UNCHK
lin cable's_length_N = mkWN (compoundN "kaapelin" (k9A "mitta")) ; --UNCHK
lin cable_N = mkN "kaapeli" "kaapeleita" ;
lin cable_V = mkWV (k53A "sähköttää") ; --UNCHK
lin cable_V2 = mkWV2 (k53A "sähköttää") ; --UNCHK
lin cable_car_N = mkWN (k1 "vaunu") ; --UNCHK
lin cable_length_N = mkWN (compoundN "kaapelin" (k9A "mitta")) ; --UNCHK
lin cable_railway_N = mkWN (compoundN "köysi" (k9A "rata")) ; --UNCHK
lin cablegram_N = mkWN (k48 "sähke") ; --UNCHK
lin cabman_N = mkWN (k14A "vossikka") ; --UNCHK
lin cabochon_N = mkWN "cabochon" ; --UNCHK
lin caboodle_N = mkWN (k1A "nippu") ; --UNCHK
lin caboose_N = mkWN (compoundN "konduktöörin" (k1 "vaunu")) ; --UNCHK
lin cabotage_N = mkWN (compoundN "rannikko" (k48A "liikenne")) ; --UNCHK
lin cabstand_N = mkWN (compoundN "taksi" (k10 "asema")) ; --UNCHK
lin cacao_N = mkWN (compoundN "kaakao" (k18 "puu")) ; --UNCHK
lin cacao_bean_N = mkWN (compoundN "kaakao" (k1A "papu")) ; --UNCHK
lin cacao_tree_N = mkWN (compoundN "kaakao" (k18 "puu")) ; --UNCHK
lin cache_N = mkWN (k1 "kätkö") ; --UNCHK
lin cache_V2 = mkWV2 (k62 "varastoida") ; --UNCHK
lin cachectic_A = mkWA "kuihtunut" ; --UNCHK
lin cachet_N = mkWN (k5A "sinetti") ; --UNCHK
lin cachexia_N = mkWN "kakeksia" ; --UNCHK
lin cachinnation_N = mkWN (k39 "hekotus") ; --UNCHK
lin cachou_N = mkWN (k5 "pastilli") ; --UNCHK
lin cacique_N = mkWN "kasikki" ; --UNCHK
lin cackle_N = mkWN (k39 "käkätys") ; --UNCHK
lin cackle_V = mkWV (k53A "käkättää") ; --UNCHK
lin cackly_A = mkWA (compoundA "kaakatus" (k38 "mainen")) ; --UNCHK
lin cacodemon_N = mkWN (k38 "paholainen") ; --UNCHK
lin cacodemonic_A = mkWA (compoundA "paholais" (k38 "mainen")) ; --UNCHK
lin cacodyl_N = mkWN (compoundN "arsenikki" (k10 "ryhmä")) ; --UNCHK
lin cacodylic_A = mkWA "kakodyyli-" ; --UNCHK
lin cacogenesis_N = mkWN "cacogenesis" ; --UNCHK
lin cacophonous_A = mkWA (k38 "kakofoninen") ; --UNCHK
lin cacophony_N = mkWN (k12 "kakofonia") ; --UNCHK
lin cactus_N = mkWN (k39 "kaktus") ; --UNCHK
lin cacuminal_A = mkWA (compoundA "kakumina" (k38 "alinen")) ; --UNCHK
lin cad_N = mkWN (k2 "suunnittelu") "tietokoneavusteinen" ; --UNCHK
lin cadaster_N = mkWN (compoundN "maa" (k6 "rekisteri")) ; --UNCHK
lin cadastral_A = mkWA "maarekisteriin" "liittyvä" ; --UNCHK
lin cadaver_N = mkWN (k1A "raato") ; --UNCHK
lin cadaverine_N = mkWN "kadaveriini" ; --UNCHK
lin cadaverous_A = mkWA (compoundA "kalman" (k15 "kalpea")) ; --UNCHK
lin caddie_N = mkWN (k8 "caddie") ; --UNCHK
lin caddish_A = mkWA (k1 "tyly") ; --UNCHK
lin caddisworm_N = mkWN "sirvi" ; --UNCHK
lin caddy_N = mkWN (compoundN "teenlehti" (k12 "rasia")) ; --UNCHK
lin cadence_N = mkWN (k5A "tahti") ; --UNCHK
lin cadenced_A = mkWA "tahditettu" ; --UNCHK
lin cadenza_N = mkWN (k5 "kadenssi") ; --UNCHK
lin cadet_N = mkWN (k5A "kadetti") ; --UNCHK
lin cadetship_N = mkWN "kadettius" ; --UNCHK
lin cadger_N = mkWN (k12 "siipeilijä") ; --UNCHK
lin cadiz_PN = foreignPN "Cádiz" ;
lin cadmium_N = mkWN (k5 "kadmium") ; --UNCHK
lin cadre_N = mkWN "kantahenkilökunta" ; --UNCHK
lin caducean_A = mkWA "caduceus-" ; --UNCHK
lin caduceus_N = mkWN "caduceus" ; --UNCHK
lin caducous_A = mkWA "shed" ; --UNCHK
lin caecilian_A = mkWA "matosammakoiden" ; --UNCHK
lin caecilian_N = mkWN (k13 "vaskitsa") ; --UNCHK
lin caen_PN = foreignPN "Caen" ;
lin caerleon_PN = foreignPN "Caerleon" ;
lin caernarfon_PN = foreignPN "Caernarfon" ;
lin caerphilly_PN = foreignPN "Caerphilly" ;
lin caesarian_A = mkWA "Caesarin" ; --UNCHK
lin caespitose_A = mkWA "tufted" ; --UNCHK
lin caesura_N = mkWN (k1A "tauko") ; --UNCHK
lin caesural_A = mkWA "tauko-" ; --UNCHK
lin cafe_N = mkWN (k12 "kuppila") ; --UNCHK
lin cafe_au_lait_N = mkWN (compoundN "maito" (k5 "kahvi")) ; --UNCHK
lin cafeteria_N = mkN "kahvila" ;
lin caff_N = mkWN (k12 "kahvila") ; --UNCHK
lin caffeine_N = mkWN (k5 "kofeiini") ; --UNCHK
lin caffeinic_A = mkWA (compoundA "kofeiinipi" (k38 "toinen")) ; --UNCHK
lin caffeinism_N = mkWN (compoundN "kofeiini" (k39 "myrkytys")) ; --UNCHK
lin caftan_N = mkWN (k6 "kaftaani") ; --UNCHK
lin cage_N = mkWN (compoundN "lyönti" (k5A "häkki")) ; --UNCHK
lin cage_V2 = mkWV2 (k69 "vangita") ; --UNCHK
lin cagey_A = mkWA (k38 "harkitsevainen") ; --UNCHK
lin cagily_Adv = mkWAdv (k99 "varovasti") ; --UNCHK
lin cagliari_PN = foreignPN "Cagliari" ;
lin cagoule_N = mkWN (k5A "anorakki") ; --UNCHK
lin cahoot_N = mkWN "yhteistoiminnassa" ; --UNCHK
lin caiman_N = mkWN (k5 "kaimaani") ; --UNCHK
lin cairn_N = mkWN (compoundN "cairn" (k5 "terrieri")) ; --UNCHK
lin cairned_A = mkWA "merkitty" ; --UNCHK
lin cairngorm_N = mkWN (compoundN "savu" (k5 "kvartsi")) ; --UNCHK
lin cairo_PN = foreignPN "Kairo" ;
lin caisson_N = mkWN (k5 "kasuuni") ; --UNCHK
lin caitiff_A = mkWA (k38 "raukkamainen") ; --UNCHK
lin caitiff_N = mkWN (k9A "raukka") ; --UNCHK
lin cajole_V2 = mkWV2 (k67A "viekoitella") ; --UNCHK
lin cajolery_N = mkWN (k2 "jaarittelu") ; --UNCHK
lin cake_N = mkWN (k14A "patukka") ; --UNCHK
lin cake_V = mkWV (k53A "peittää") ; --UNCHK
lin cake_V2 = mkWV2 (k53A "peittää") ; --UNCHK
lin cakewalk_N = mkWN (kH1 "nakki") "helppo" ; --UNCHK
lin calaba_N = mkWN "Calophyllum" "calaba" ; --UNCHK
lin calabash_N = mkWN (compoundN "kalebassi" (k1A "piippu")) ; --UNCHK
lin caladenia_N = mkWN "caladenia" ; --UNCHK
lin caladium_N = mkWN (compoundN "kirjo" (k7A "lehti")) ; --UNCHK
lin calamint_N = mkWN (compoundN "käen" (k1A "minttu")) ; --UNCHK
lin calamitous_A = mkWA (k38 "katastrofaalinen") ; --UNCHK
lin calamity_N = mkWN (k12 "tragedia") ; --UNCHK
lin calamus_N = mkWN (k1A "ruoto") ; --UNCHK
lin calando_A = mkWA "calando" ; --UNCHK
lin calanthe_N = mkWN "kalante" ; --UNCHK
lin calash_N = mkWN (compoundN "taitto" (k1A "katto")) ; --UNCHK
lin calcaneal_A = mkWA "kantaluu-" ; --UNCHK
lin calcareous_A = mkWA (compoundA "kalkki" (k38 "nen")) ; --UNCHK
lin calced_A = mkWA (compoundA "ken" (k1 "gitetty")) ; --UNCHK
lin calceolaria_N = mkWN (compoundN "tohveli" (k10A "kukka")) ; --UNCHK
lin calceolate_A = mkWA (compoundA "tohveli" (k38 "mainen")) ; --UNCHK
lin calceus_N = mkWN (compoundN "varsi" (k6 "sandaali")) ; --UNCHK
lin calcic_A = mkWA "kalkki-" ; --UNCHK
lin calcicolous_A = mkWA "calcicolous" ; --UNCHK
lin calciferous_A = mkWA (compoundA "kalkkipi" (k38 "toinen")) ; --UNCHK
lin calcific_A = mkWA "kalkkeutuva" ; --UNCHK
lin calcification_N = mkWN "kalkkeutuminen" ; --UNCHK
lin calcifugous_A = mkWA "calcifugous" ; --UNCHK
lin calcify_V = mkWV (k69 "kalkita") ; --UNCHK
lin calcify_V2 = mkWV2 (k69 "kalkita") ; --UNCHK
lin calcimine_N = mkWN (k5 "kalkkimaali") ; --UNCHK
lin calcination_N = mkWN (k39 "pasutus") ; --UNCHK
lin calcine_V = mkWV (k54A "kuumentaa") ; --UNCHK
lin calcine_V2 = mkWV2 (k54A "kuumentaa") ; --UNCHK
lin calcite_N = mkWN "kalsiitti" ; --UNCHK
lin calcitic_A = mkWA "kalsiitti-" ; --UNCHK
lin calcitonin_N = mkWN (compoundN "kalsito" (k26 "niini")) ; --UNCHK
lin calcium_N = mkWN (k5 "kalsium") ; --UNCHK
lin calculable_A = mkWA "laskettava" ; --UNCHK
lin calculate_V = mkWV (k58 "laskea") ;
lin calculate_V2 = mkWV2 (k58 "laskea") ;
lin calculate_VS = mkWVS (k58 "laskea") ;
lin calculatingly_Adv = mkWAdv (compoundAdv "laskelmoiv" (k99 "asti")) ; --UNCHK
lin calculation_N = mkWN (k9A "laskenta") ; --UNCHK
lin calculator_N = mkWN (k33 "laskin") ; --UNCHK
lin calculous_A = mkWA "kivi-" ; --UNCHK
lin calculus_N = mkWN (compoundN "differentiaali" (k9A "laskenta")) ; --UNCHK
lin calcutta_PN = foreignPN "Calcutta" ;
lin caldera_N = mkWN "kaldera" ; --UNCHK
lin caldicot_PN = foreignPN "Caldicot" ;
lin caldron_N = mkWN (kH1 "pata") ; --UNCHK
lin calefacient_A = mkWA "lämmittävä" ; --UNCHK
lin calefaction_N = mkWN "lämmittävyys" ; --UNCHK
lin calefactory_A = mkWA "lämmittävä" ; --UNCHK
lin calendar_N = mkWN (k6 "kalenteri") ;
lin calender_N = mkWN (k6 "kalanteri") ; --UNCHK
lin calender_V2 = mkWV2 (k62 "kalanteroida") ; --UNCHK
lin calendric_A = mkWA (k38 "kalendaarinen") ; --UNCHK
lin calendula_N = mkWN (compoundN "kalend" (k10 "ula")) ; --UNCHK
lin calf_N = mkWN (k14A "vasikka") ; --UNCHK
lin calf_love_N = mkWN (k7A "lempi") "nuori" ; --UNCHK
lin cali_PN = foreignPN "Cali" ;
lin calibrate_V2 = mkWV2 (k62 "kalibroida") ; --UNCHK
lin calibration_N = mkWN (k39 "normitus") ; --UNCHK
lin calibre_N = mkWN (k1 "taso") ; --UNCHK
lin caliche_N = mkWN (compoundN "chilen" (k6 "salpietari")) ; --UNCHK
lin calico_A = mkWA "kalikoo-" ; --UNCHK
lin calico_N = mkWN "kalikoo-" ; --UNCHK
lin calif_N = mkWN (k5 "kalifi") ; --UNCHK
lin california_PN = foreignPN "Kalifornia" ;
lin californian_A = mkWA (compoundA "kaliforni" (k38 "alainen")) ; --UNCHK
lin californian_N = mkWN (compoundN "kaliforni" (k38 "alainen")) ; --UNCHK
lin californium_N = mkWN "järjestysluku" "98" ; --UNCHK
lin caliginous_A = mkWA (k10A "synkkä") ; --UNCHK
lin caliper_N = mkWN (compoundN "mitta" (k5A "harppi")) ; --UNCHK
lin caliph_N = mkWN (k5 "kalifi") ; --UNCHK
lin caliphate_N = mkWN "kalifaatti" ; --UNCHK
lin calisaya_N = mkWN (compoundN "kiinan" (k18 "puu")) ; --UNCHK
lin calisthenic_A = mkWA "voimistelu-" ; --UNCHK
lin calisthenics_N = mkWN (k2 "voimistelu") ; --UNCHK
lin calk_N = mkWN "hokki" ; --UNCHK
lin calk_V2 = mkWV2 (k53A "vammauttaa") ; --UNCHK
lin call_N = mkN "kutsu" ;
lin call_V = mkV "soittaa" ; --mkV "kutsua" ;
lin call_V2 = mkV2 (mkV "soittaa") (casePrep allative) ;
lin call_VS = mkVS "kutsua" ; ---??
lin call_after_V2 = prepV2 OP_call_V OP_after_Prep ; -- guess-p-verb
lin call_around_V = advV OP_call_V OP_around_Adv ; -- guess-p-verb
lin call_back_V2 = mkWV2 (k64 "tuoda") "mieleen" ; --UNCHK
lin call_box_N = mkWN (compoundN "posti" (k2 "lokero")) ; --UNCHK
lin call_for_V2 = mkWV2 (k52 "anoa") ; --UNCHK
lin call_for_V2V = variants {} ; -- guess-p-verb
lin call_forth_V2 = mkWV2 (k64 "tuoda") "esiin" ; --UNCHK
lin call_girl_N = mkWN (compoundN "ilo" (k1A "tyttö")) ; --UNCHK
lin call_in_V = mkWV (k53A "soittaa") ; --UNCHK
lin call_in_V2 = mkWV2 (k53A "soittaa") ; --UNCHK
lin call_off_V2 = mkWV2 (k53A "kuuluttaa") ; --UNCHK
lin call_on_V = mkWV (k74A "vedota") ; --UNCHK
lin call_on_V2 = mkWV2 (k74A "vedota") ; --UNCHK
lin call_out_V2 = mkWV2 (k56 "haastaa") ; --UNCHK
lin call_over_V = advV OP_call_V OP_over_Adv ; -- guess-p-verb
lin call_round_V = advV OP_call_V OP_round_Adv ; -- guess-p-verb
lin call_up_N = mkWN (k9A "kutsunta") ; --UNCHK
lin call_up_V2 = mkWV2 (k64 "tuoda") "mieleen" ; --UNCHK
lin callable_A = mkWA "callable" ; --UNCHK
lin called_A = mkA "kutsuttu" ;
lin caller_N = mkWN (k39 "jarrutus") ; --UNCHK
lin calliandra_N = mkWN "kalliandra" ; --UNCHK
lin calligrapher_N = mkWN (k10 "tekstaaja") ; --UNCHK
lin calligraphic_A = mkWA "kalligrafinen" ; --UNCHK
lin calligraphy_N = mkWN (compoundN "kauno" (k39 "kirjoitus")) ; --UNCHK
lin calling_N = mkWN (k5A "ammatti") ; --UNCHK
lin calliopsis_N = mkWN "tiikerikaunosilmä" ; --UNCHK
lin callipygian_A = mkWA (k41A "muodokas") ; --UNCHK
lin callisthenics_N = mkWN (k2 "voimistelu") ; --UNCHK
lin callithump_N = mkWN (k5 "charivari") ; --UNCHK
lin callithumpian_A = mkWA "paraati-" ; --UNCHK
lin callosity_N = mkWN (k40 "piittaamattomuus") ; --UNCHK
lin callous_A = mkWA (k34A "sydämetön") ; --UNCHK
lin calloused_A = mkWA (k38 "känsäinen") ; --UNCHK
lin callousness_N = mkWN (k40 "piittaamattomuus") ; --UNCHK
lin callow_A = mkWA (k15 "vihreä") ; --UNCHK
lin callowness_N = mkWN (k40 "nuoruus") ; --UNCHK
lin callus_N = mkWN (k10 "kovettuma") ; --UNCHK
lin calm_A = mkWA (k26 "tyyni") ;
lin calm_N = mkWN (k40 "rauhallisuus") ; --UNCHK
lin calm_V = mkWV (k56A "antaa") "rauhoittavia" ; --UNCHK
lin calm_V2 = mkV2 "rauhoittaa" partitive ;
lin calm_down_V2 = mkWV2 (k52A "rauhoittua") ; --UNCHK
lin calmness_N = mkWN (k40 "rauhallisuus") ; --UNCHK
lin calne_PN = foreignPN "Calne" ;
lin caloric_A = mkWA "kalori-" ; --UNCHK
lin calorie_N = mkWN (k6 "kalori") ; --UNCHK
lin calorifacient_A = mkWA (k10 "tuottava") "lämpöä" ; --UNCHK
lin calorific_A = mkWA "lämmittävä" ; --UNCHK
lin calorimeter_N = mkWN (k5 "kalorimetri") ; --UNCHK
lin calorimetric_A = mkWA (compoundA "kalori" (k38 "metrinen")) ; --UNCHK
lin calorimetry_N = mkWN "kalorimetria" ; --UNCHK
lin calosoma_N = mkWN (compoundN "kaunokiitä" (k38 "jäinen")) ; --UNCHK
lin calpac_N = mkWN (k5A "kalpakki") ; --UNCHK
lin calque_N = mkWN (compoundN "käännös" (k9 "laina")) ; --UNCHK
lin caltrop_N = mkWN (compoundN "piikki" (k5A "kaunokki")) ; --UNCHK
lin calumet_N = mkWN (compoundN "rauhan" (k1A "piippu")) ; --UNCHK
lin calumniate_V2 = mkWV2 (k73A "liata") ; --UNCHK
lin calumniatory_A = mkWA (compoundA "must" (k9 "aava")) ; --UNCHK
lin calumny_N = mkWN (k39 "mustamaalaus") ; --UNCHK
lin calvaria_N = mkWN (kH1 "laki") "pääkallon" ; --UNCHK
lin calvary_N = mkWN (k40 "marttyyrius") ; --UNCHK
lin calve_V = mkWV (k61A "poikia") ; --UNCHK
lin calverton_PN = foreignPN "Calverton" ;
lin calving_N = mkWN (k5A "vasikointi") ; --UNCHK
lin calvinism_N = mkWN (compoundN "Kalvin" (k5 "ismi")) ; --UNCHK
lin calvinist_N = mkWN (k5 "kalvinisti") ; --UNCHK
lin calyceal_A = mkWA (compoundA "pikari" (k38 "mainen")) ; --UNCHK
lin calycular_A = mkWA (k38 "maljamainen") ; --UNCHK
lin calyculate_A = mkWA "pikari-" ; --UNCHK
lin calyculus_N = mkWN (k9 "malja") ; --UNCHK
lin calypso_N = mkWN "Kalypso" ; --UNCHK
lin calyptra_N = mkWN (compoundN "juuri" (k1A "huntu")) ; --UNCHK
lin calyptrate_A = mkWA (compoundA "juu" (k38 "rihuntuinen")) ; --UNCHK
lin calyx_N = mkWN (k3 "verhiö") ; --UNCHK
lin cam_N = mkWN (compoundN "nokka" (k10 "pyörä")) ; --UNCHK
lin camail_N = mkWN (compoundN "rengaspanssari" (k1A "huppu")) ; --UNCHK
lin camaraderie_N = mkWN (k40 "ystävyys") ; --UNCHK
lin camas_N = mkWN (compoundN "tähti" (k5A "hyasintti")) ; --UNCHK
lin camber_N = mkWN (compoundN "pysty" (k10 "kallistuma")) ; --UNCHK
lin camber_V = mkWV (k52A "kaareutua") ; --UNCHK
lin camber_V2 = mkWV2 (k52A "kaareutua") ; --UNCHK
lin cambial_A = mkWA "jälsi-" ; --UNCHK
lin cambium_N = mkWN (k28A "jälsi") ; --UNCHK
lin cambodia_PN = foreignPN "Kambodza" ;
lin cambodian_A = mkWA (compoundA "kamputse" (k38 "alainen")) ; --UNCHK
lin cambodian_N = mkWN (compoundN "kamputse" (k38 "alainen")) ; --UNCHK
lin cambric_N = mkWN (k5 "batisti") ; --UNCHK
lin cambridge_PN = foreignPN "Cambridge" ;
lin camcorder_N = mkWN (compoundN "video" (k12 "kamera")) ; --UNCHK
lin camden_PN = foreignPN "Camden" ;
lin camel_N = mkWN (k6 "kameli") ; --UNCHK
lin camellia_N = mkWN (k12 "kamelia") ; --UNCHK
lin camelpox_N = mkWN (compoundN "kameli" (k1A "rokko")) ; --UNCHK
lin cameo_N = mkWN (k20 "kamee") ; --UNCHK
lin camera_N = L.camera_N ;
lin cameraman_N = mkWN (k10 "kuvaaja") ;
lin cameroon_PN = foreignPN "Kamerun" ;
lin cameroonian_A = mkWA (compoundA "kameruni" (k38 "lainen")) ; --UNCHK
lin cameroonian_N = mkWN (compoundN "kameruni" (k38 "lainen")) ; --UNCHK
lin camise_N = mkWN (k2 "pusero") ; --UNCHK
lin camisole_N = mkWN (compoundN "aamu" (k5A "takki")) ; --UNCHK
lin camlet_N = mkWN (k41A "silkkikangas") ; --UNCHK
lin camomile_N = mkWN (k2 "sauramo") ; --UNCHK
lin camouflage_N = mkWN (k5A "naamiointi") ; --UNCHK
lin camouflage_V2 = mkWV2 (k62 "naamioida") ; --UNCHK
lin camp_A = mkWA (k10 "huvittava") ; --UNCHK
lin camp_N = mkWN (k5 "leiri") ; --UNCHK
lin camp_V = mkWV (k67A "liioitella") ; --UNCHK
lin camp_V2 = mkWV2 (k67A "liioitella") ; --UNCHK
lin camp_bed_N = mkWN (compoundN "kenttä" (k48A "vuode")) ; --UNCHK
lin camp_chair_N = mkWN (compoundN "teltta" (k5 "tuoli")) ; --UNCHK
lin camp_follower_N = mkWN (k12 "myötäilijä") ; --UNCHK
lin camp_out_V = mkWV (k52A "leiriytyä") ; --UNCHK
lin campaign_N = mkN "kampanja" ;
lin campaign_V = mkWV (k60A "lähteä") "sotaan" ; --UNCHK
lin campaigner_N = mkWN (k5A "kandidaatti") ; --UNCHK
lin campaigning_N = mkWN (k5A "kampanjointi") ; --UNCHK
lin campanile_N = mkWN (compoundN "kello" (k5 "torni")) ; --UNCHK
lin campanula_N = mkWN (k1 "kello") ; --UNCHK
lin campanulate_A = mkWA (k38 "kellomainen") ; --UNCHK
lin campbeltown_PN = foreignPN "Campbeltown" ;
lin camper_N = mkWN (compoundN "asunto" (k1 "auto")) ; --UNCHK
lin campestral_A = mkWA "pelto-" ; --UNCHK
lin camp_fire_N = mkWN (k3 "nuotio") ; --UNCHK
lin camphor_N = mkWN (k6 "kamferi") ; --UNCHK
lin camphoraceous_A = mkWA (compoundA "kamferi" (k38 "mainen")) ; --UNCHK
lin camphorated_A = mkWA "kamferi-" ; --UNCHK
lin camphoric_A = mkWA "kamferi-" ; --UNCHK
lin camping_N = mkWN (k2 "telttailu") ; --UNCHK
lin campion_N = mkWN (k5A "kohokki") ; --UNCHK
lin campmate_N = mkWN (compoundN "leiri" (k6 "toveri")) ; --UNCHK
lin campsite_N = mkWN (k5 "leiri") ; --UNCHK
lin camp_stool_N = mkWN (compoundN "retki" (k5 "tuoli")) ; --UNCHK
lin campus_N = mkWN (k39 "kampus") ; --UNCHK
lin campylotropous_A = mkWA "campylotropous" ; --UNCHK
lin camshaft_N = mkWN (compoundN "nokka-" (k6 "akseli")) ; --UNCHK
lin camwood_N = mkWN "Baphia" "nitida" ; --UNCHK
lin can8know_VV = S.can8know_VV ;
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_N = mkWN (k5A "tölkki") ; --UNCHK
lin can_V2 = mkWV2 (k53A "purkittaa") ; --UNCHK
lin canada_PN = foreignPN "Kanada" ;
lin canadian_A = mkWA (k38 "kanadalainen") ; --UNCHK
lin canadian_N = mkWN (compoundN "Canadian-" (k7A "joki")) ; --UNCHK
lin canal_N = mkWN (k10 "kanava") ; --UNCHK
lin canalicular_A = mkWA (compoundA "kana" (k38 "likulaarinen")) ; --UNCHK
lin canaliculate_A = mkWA (compoundA "kana" (k38 "vallinen")) ; --UNCHK
lin canaliculus_N = mkWN (compoundN "pikku" (k10 "kanava")) ; --UNCHK
lin canalization_N = mkWN (k5A "kanavointi") ; --UNCHK
lin canalize_V2 = mkWV2 (k73A "suunnata") ; --UNCHK
lin canape_N = mkWN (k18 "kanapee") ; --UNCHK
lin canard_N = mkWN (k1A "tieto") "perätön" ; --UNCHK
lin canary_A = mkWA (compoundA "kanarian" (k38 "keltainen")) ; --UNCHK
lin canary_N = mkWN (compoundN "kanaria" (k1A "lintu")) ; --UNCHK
lin canary_bird_N = mkWN (compoundN "kanaria" (k1A "lintu")) ; --UNCHK
lin canary_wine_N = mkWN (kH1 "viini") "Kanarian" ; --UNCHK
lin canasta_N = mkWN (k9 "canasta") ; --UNCHK
lin canavanine_N = mkWN (compoundN "kanava" (k26 "niini")) ; --UNCHK
lin canberra_PN = foreignPN "Canberra" ;
lin cancan_N = mkWN (k5 "cancan") ; --UNCHK
lin cancel_V = mkV "peruuttaa" ; --UNCHK
lin cancel_V2 = mkV2 "peruuttaa" ;
lin cancel_out_V2 = mkWV2 (k62 "neutraloida") ; --UNCHK
lin cancellate_A = mkWA (k38 "hohkainen") ; --UNCHK
lin cancellation_N = mkWN (k39 "peruutus") ;
lin cancer_N = mkN "syöpä" ; --f112
lin cancerous_A = mkWA (k38 "syöpäinen") ; --UNCHK
lin cancerweed_N = mkWN (compoundN "lyyra" (k12 "salvia")) ; --UNCHK
lin cancroid_A = mkWA (compoundA "syöpä" (k38 "mäinen")) ; --UNCHK
lin cancroid_N = mkWN (compoundN "levyepiteeli" (k10A "syöpä")) ; --UNCHK
lin candelabrum_N = mkWN (k4A "kynttelikkö") ; --UNCHK
lin candelilla_N = mkWN (compoundN "kandedilla" (k5 "kasvi")) ; --UNCHK
lin candescent_A = mkWA (compoundA "heh" (k10 "kuva")) ; --UNCHK
lin candid_A = mkWA (k34A "kursailematon") ; --UNCHK
lin candida_N = mkWN "candida" ; --UNCHK
lin candidacy_N = mkWN (k5A "kampanjointi") ; --UNCHK
lin candidateFem_N = mkWN (k5A "kandidaatti") ; --f88
lin candidateMasc_N = mkN "ehdokas" ;
lin candidature_N = mkWN (k5A "kampanjointi") ; --UNCHK
lin candidiasis_N = mkWN (compoundN "hiivasieni" (k39 "tulehdus")) ; --UNCHK
lin candle_N = mkWN (k12 "kynttilä") ; --UNCHK
lin candlelight_N = mkWN (compoundN "kynttilän" (k1 "valo")) ; --UNCHK
lin candlemaker_N = mkWN (compoundN "kynttilän" (k12 "tekijä")) ; --UNCHK
lin candlenut_N = mkWN (compoundN "bankul" (k12 "pähkinä")) ; --UNCHK
lin candlepin_N = mkWN (k9 "keila") ; --UNCHK
lin candlepins_N = mkWN (compoundN "candlepin-" (k2 "keilailu")) ; --UNCHK
lin candle_power_N = mkWN (k5A "intensiteetti") "valon" ; --UNCHK
lin candlesnuffer_N = mkWN (compoundN "kynttilän" (k33A "sammutin")) ; --UNCHK
lin candlestick_N = mkWN (compoundN "kynttilän" (k9A "jalka")) ; --UNCHK
lin candlewick_N = mkWN (compoundN "kynttilän" (k33 "sydän")) ; --UNCHK
lin candlewood_N = mkWN (compoundN "poltto" (k18 "puu")) ; --UNCHK
lin candor_N = mkWN (k40 "avoimuus") ; --UNCHK
lin candour_N = mkWN (k40 "avoimuus") ; --UNCHK
lin candy_N = mkWN (k38 "makeinen") ; --UNCHK
lin candy_V = mkWV (k53A "kuorruttaa") "sokerilla" ; --UNCHK
lin candy_V2 = mkWV2 (k53A "kuorruttaa") "sokerilla" ; --UNCHK
lin candytuft_N = mkWN (k1A "saippo") ; --UNCHK
lin cane_N = mkWN (k5A "keppi") ; --UNCHK
lin cane_V2 = mkWV2 (k53A "kurittaa") ; --UNCHK
lin canebrake_N = mkWN (k4A "ruoikko") ; --UNCHK
lin canella_N = mkWN (k6 "kaneli") "valkoinen" ; --UNCHK
lin canescent_A = mkWA (compoundA "harmaan" (k15 "valkea")) ; --UNCHK
lin canfield_N = mkWN (compoundN "Canfield-" (k5 "pasianssi")) ; --UNCHK
lin cangue_N = mkWN (compoundN "kaula" (k9A "panta")) ; --UNCHK
lin canine_A = mkWA (compoundA "koira" (k38 "mainen")) ; --UNCHK
lin canine_N = mkWN (compoundN "koira" (k33 "eläin")) ; --UNCHK
lin canistel_N = mkWN "Pouteria" "campechiana" ; --UNCHK
lin canister_N = mkWN (k5A "purkki") ; --UNCHK
lin canker_N = mkWN (k10A "syöpä") ; --UNCHK
lin canker_V2 = mkWV2 (k53A "tartuttaa") ; --UNCHK
lin cankerous_A = mkWA (k38 "haavainen") ; --UNCHK
lin cankerworm_N = mkWN (k10A "toukka") ; --UNCHK
lin canna_N = mkWN (kH1 "kanna") ; --UNCHK
lin cannabin_N = mkWN (compoundN "kannabis" (k5 "hartsi")) ; --UNCHK
lin cannabis_N = mkWN (k11 "marihuana") ; --UNCHK
lin cannelloni_N = mkWN (k5 "cannelloni") ; --UNCHK
lin cannery_N = mkWN (compoundN "säilyke" (k41A "tehdas")) ; --UNCHK
lin cannes_PN = foreignPN "Cannes" ;
lin cannibal_N = mkWN (k5 "kannibaali") ; --UNCHK
lin cannibalic_A = mkWA (k38 "kannibaalinen") ; --UNCHK
lin cannibalism_N = mkWN (k5 "kannibalismi") ; --UNCHK
lin cannibalistic_A = mkWA "kannibalistinen" ; --UNCHK
lin cannibalize_V2 = mkWV2 (k53A "purkaa") "varaosiksi" ; --UNCHK
lin cannikin_N = mkWN (k5A "purkki") ; --UNCHK
lin cannock_PN = foreignPN "Cannock" ;
lin cannon_1_N = mkWN (k9 "kanuuna") ; --UNCHK
lin cannon_2_N = variants {} ; --UNCHK
lin cannon_fodder_N = mkWN (compoundN "tykin" (k10A "ruoka")) ; --UNCHK
lin cannonade_N = mkWN (compoundN "tykistö" (k23 "tuli")) ; --UNCHK
lin cannonball_N = mkWN (k10 "kuula") ; --UNCHK
lin cannula_N = mkWN (k5 "kanyyli") ; --UNCHK
lin cannulation_N = mkWN (compoundN "ase" (k38 "ttaminen")) "johtoputken" ; --UNCHK
lin canny_A = mkWA (k10 "ovela") ; --UNCHK
lin canoe_N = mkWN (k5A "kanootti") ; --UNCHK
lin canoe_V2 = mkWV2 (k52 "meloa") ; --UNCHK
lin canoeist_N = mkWN (k10 "meloja") ; --UNCHK
lin canon_N = mkWN (k6 "kaanon") ; --UNCHK
lin canonic_A = mkWA (k38 "kanoninen") ; --UNCHK
lin canonical_A = mkWA (k38 "kanoninen") ; --UNCHK
lin canonist_A = mkWA (compoundA "kanonis" (k38 "tinen")) ; --UNCHK
lin canonist_N = mkWN (k12 "tuntija") "kirkko-oikeuden" ; --UNCHK
lin canonization_N = mkWN (compoundN "kanoni" (k5A "sointi")) ; --UNCHK
lin canonize_V2 = mkWV2 (k53 "kanonistaa") ; --UNCHK
lin canopied_A = mkWA (compoundA "kate" (k1 "ttu")) ; --UNCHK
lin canopy_N = mkWN (k1 "varjo") ; --UNCHK
lin canorous_A = mkWA (k38 "laulullinen") ; --UNCHK
lin cant_N = mkWN (k40 "vinous") ; --UNCHK
lin cant_V = mkWV (k53A "viettää") ; --UNCHK
lin cant_V2 = mkWV2 (k53A "viettää") ; --UNCHK
lin cantabile_A = mkWA "laulaen" ; --UNCHK
lin cantaloupe_N = mkWN (compoundN "cantaloupe" (k6 "meloni")) ; --UNCHK
lin cantankerous_A = mkWA (k1 "häijy") ; --UNCHK
lin cantata_N = mkWN (k3 "oratorio") ; --UNCHK
lin canteen_N = mkWN (compoundN "kenttä" (k1 "pullo")) ; --UNCHK
lin canter_N = mkWN (kH1 "laukka") ; --UNCHK
lin canter_V = mkWV (k73A "laukata") ; --UNCHK
lin canter_V2 = mkWV2 (k73A "laukata") ; --UNCHK
lin canterbury_PN = foreignPN "Canterbury" ;
lin canthus_N = mkWN (compoundN "silmä" (k10 "kulma")) ; --UNCHK
lin canticle_N = mkWN (k5 "psalmi") ; --UNCHK
lin cantilever_N = mkWN (compoundN "tuki" (k5A "palkki")) ; --UNCHK
lin cantillation_N = mkWN "kantillaatio" ; --UNCHK
lin cantle_N = mkWN (k26 "takakaari") ; --UNCHK
lin canto_N = mkWN (k1A "luku") ; --UNCHK
lin canton_N = mkWN (k6 "kantoni") ; --UNCHK
lin canton_PN = foreignPN "Canton" ;
lin cantonal_A = mkWA "piirikunta-" ; --UNCHK
lin cantonment_N = mkWN (k5 "leiri") ; --UNCHK
lin cantor_N = mkWN (k6 "kanttori") ; --UNCHK
lin canty_A = mkWA (k41A "reipas") ; --UNCHK
lin canuck_N = mkWN (k38 "kanadalainen") ; --UNCHK
lin canvas_N = mkWN (k41A "telttakangas") ; --UNCHK
lin canvasback_N = mkWN "isopunasotka" ; --UNCHK
lin canvass_N = mkWN (k41A "telttakangas") ; --UNCHK
lin canvass_V = mkWV (k67 "tarkastella") ; --UNCHK
lin canvass_V2 = mkWV2 (k67 "tarkastella") ; --UNCHK
lin canvasser_N = mkWN (compoundN "vaali" (k12 "toimitsija")) ; --UNCHK
lin canyon_N = mkWN (k1 "kuru") ; --UNCHK
lin canyonside_N = mkWN (compoundN "kanjonin" (k9 "reuna")) ; --UNCHK
lin cap_1_N = L.cap_N ;
lin cap_2_N = L.cap_N ;
lin cap_V2 = mkWV2 (k53A "rajoittaa") ;
lin cap_off_V2 = mkWV2 (k53A "päättää") ; --UNCHK
lin capability_N = mkN (lin NK {s = d01A "kyky"}) ;
lin capable_of_A2 = mkA2 (mkWA (k10 "pystyvä")) (mkPrep illative) ; --UNCHK
lin capacious_A = mkWA (k10 "tilava") ; --UNCHK
lin capaciousness_N = mkWN (k40 "avaruus") ; --UNCHK
lin capacitance_N = mkWN (k6 "kondensaattori") ; --UNCHK
lin capacitive_A = mkWA "kapasitanssi-" ; --UNCHK
lin capacitor_N = mkWN (k6 "kondensaattori") ; --UNCHK
lin capacity_N = mkN "kapasiteetti" ;
lin caparison_N = mkWN (k25 "loimi") ; --UNCHK
lin caparison_V2 = mkWV2 (k53 "valjastaa") ; --UNCHK
lin cape_N = mkWN (k5A "keeppi") ; --UNCHK
lin capelin_N = mkWN (compoundN "villa" (k48 "kuore")) ; --UNCHK
lin caper_N = mkWN (k2 "pelleily") ; --UNCHK
lin caper_V = mkWV (k67A "hypähdellä") ; --UNCHK
lin capercaillie_N = mkWN (k1 "metso") ; --UNCHK
lin capful_N = mkWN (k38 "korkillinen") ; --UNCHK
lin capillarity_N = mkWN (k40 "kapillaarisuus") ; --UNCHK
lin capillary_A = mkWA (k38 "kapillaarinen") ; --UNCHK
lin capillary_N = mkWN (k5 "kapillaari") ; --UNCHK
lin capital_1_N = mkN "pää" (mkN "kaupunki") ;
lin capital_2_N = mkN "pää" (mkN "oma") ;
lin capital_3_N = mkN "isokirjain" ; ---- iso kirjain : CN
lin capital_A = mkA (mkN "pää" (mkN "asiallinen")) ; --mkWA (k6 "versaali") ;
lin capital_N = mkN "pää" (mkN "oma") ;
lin capitalism_N = mkWN (k5 "kapitalismi") ;
lin capitalist_A = mkWA (k38 "kapitalistinen") ; --UNCHK
lin capitalist_N = mkWN (k5 "kapitalisti") ; --UNCHK
lin capitalistic_A = mkWA (k38 "kapitalistinen") ; --UNCHK
lin capitalization_N = mkWN (k5A "kapitalointi") ; --UNCHK
lin capitalize_V = mkV "kapitalisoida" ;
lin capitalize_V2 = mkWV2 (k53A "pääomittaa") ;
lin capitate_A = mkWA (compoundA "ranneluu" (k38 "mainen")) ; --UNCHK
lin capitate_N = mkWN (compoundN "ranne" (k18 "luu")) "iso" ; --UNCHK
lin capitation_N = mkWN (compoundN "henki" (k1 "vero")) ; --UNCHK
lin capitol_N = mkWN "Capitol" "Building" ; --UNCHK
lin capitular_A = mkWA (k38 "kirkollinen") ; --UNCHK
lin capitulate_V = mkWV (k53A "luovuttaa") ; --UNCHK
lin capitulate_V2 = mkWV2 (k53A "luovuttaa") ; --UNCHK
lin capitulation_N = mkWN "antautuminen" ; --UNCHK
lin capitulum_N = mkWN (k2 "lehvistö") ; --UNCHK
lin capo_N = mkWN (k10 "johtaja") ; --UNCHK
lin capon_N = mkWN (compoundN "syöttö" (k1A "kukko")) ; --UNCHK
lin capote_N = mkWN (k12 "kauhtana") "hupullinen" ; --UNCHK
lin cappuccino_N = mkWN (k1 "cappuccino") ; --UNCHK
lin capriccio_N = mkWN (k5 "kapriisi") ; --UNCHK
lin caprice_N = mkWN (compoundN "päähän" (k1 "pisto")) ; --UNCHK
lin capricious_A = mkWA (k38 "äkillinen") ; --UNCHK
lin capriciousness_N = mkWN (k2 "oikuttelu") ; --UNCHK
lin caprifig_N = mkWN (compoundN "aito" (k12 "viikuna")) ; --UNCHK
lin caprine_A = mkWA (compoundA "vuohi" (k38 "mainen")) ; --UNCHK
lin capriole_N = mkWN (k1A "hyppy") ; --UNCHK
lin capsaicin_N = mkWN "kapsaisiini" ; --UNCHK
lin capsid_N = mkWN "kapsidi" ; --UNCHK
lin capsize_V = mkWV (k52A "kääntyä") "ympäri" ; --UNCHK
lin capsize_V2 = mkWV2 (k52A "kääntyä") "ympäri" ; --UNCHK
lin capsizing_N = mkWN "kaatuminen" ; --UNCHK
lin capstan_N = mkWN (compoundN "ankkuri" (k5 "vinssi")) ; --UNCHK
lin capstone_N = mkWN (compoundN "kansi" (k7 "kivi")) ; --UNCHK
lin capsular_A = mkWA "kapseli-" ; --UNCHK
lin capsulate_A = mkWA "kota-" ; --UNCHK
lin capsule_N = mkWN (k6 "kapseli") ; --UNCHK
lin captain_N = mkWN (compoundN "hovi" (k6 "mestari")) ; --UNCHK
lin captain_V2 = mkWV2 (k61 "toimia") "kapteenina" ; --UNCHK
lin captainship_N = mkWN (k40 "päällikkyys") ; --UNCHK
lin caption_N = mkWN (k48 "seloste") ; --UNCHK
lin captious_A = mkWA (k38 "pikkumainen") ; --UNCHK
lin captivate_V2 = mkWV2 (k53A "houkuttaa") ; --UNCHK
lin captivation_N = mkWN (k39 "viehätys") ; --UNCHK
lin captiveFem_N = mkWN (k33 "eläin") "vangittu" ; --UNCHK ---- sense to be split
lin captiveMasc_N = mkWN (k33 "eläin") "vangittu" ; --UNCHK ---- sense to be split
lin captive_N = mkWN (k33 "eläin") "vangittu" ; --UNCHK
lin captivity_N = mkWN (k40 "orjuus") ; --UNCHK
lin captopril_N = mkWN "Capoten" ; --UNCHK
lin captor_N = mkWN (k12 "vangitsija") ; --UNCHK
lin capture_N = mkWN (k39 "kaappaus") ; --UNCHK
lin capture_V2 = mkWV2 (k73A "napata") ;
lin capuchin_N = mkWN (k5 "kapusiini") ; --UNCHK
lin capulin_N = mkWN "Prunus" "salicifolia" ; --UNCHK
lin caput_N = mkWN (k1 "kallo") ; --UNCHK
lin capybara_N = mkWN (compoundN "vesi" (k9A "sika")) ; --UNCHK
lin car_N = L.car_N ;
lin car_V = variants {} ; --
lin carabao_N = mkWN (compoundN "vesi" (k6 "puhveli")) ; --UNCHK
lin carabiner_N = mkWN (k9A "karbiinihaka") ; --UNCHK
lin caracal_N = mkWN (compoundN "aavikko" (k39 "ilves")) ; --UNCHK
lin caracara_N = mkWN (compoundN "kara" (k9 "kara")) ; --UNCHK
lin caracas_PN = foreignPN "Caracas" ;
lin caracolito_N = mkWN (compoundN "caraco" (k1 "lito")) "Ruptiliocarpon" ; --UNCHK
lin carafe_N = mkN "karahvi" ;
lin carambola_N = mkWN (k10 "karambola") ; --UNCHK
lin caramel_A = mkWA (compoundA "karamellin" (k15 "ruskea")) ; --UNCHK
lin caramel_N = mkWN (compoundN "ruskean" (k38 "keltainen")) ; --UNCHK
lin carancha_N = mkWN (compoundN "töyhtökara" (k9 "kara")) ; --UNCHK
lin caranday_N = mkWN (k9 "alba") "Copernicia" ; --UNCHK
lin carat_N = mkWN (k5A "karaatti") ; --UNCHK
lin caravan_N = mkN "karavaani" ;
lin caravanning_N = mkWN (compoundN "asuntovaunu" (k2 "matkailu")) ; --UNCHK
lin caravanserai_N = mkWN (compoundN "maja" (k1 "talo")) ; --UNCHK
lin caraway_N = mkWN (kH1 "kumina") ; --UNCHK
lin carbamate_N = mkWN "karbamaatti" ; --UNCHK
lin carbide_N = mkWN (k5 "karbidi") ; --UNCHK
lin carbine_N = mkWN (k5 "karbiini") ; --UNCHK
lin carbineer_N = mkWN (k5 "karabinieeri") ; --UNCHK
lin carbocyclic_A = mkWA (compoundA "karbo" (k38 "syklinen")) ; --UNCHK
lin carbohydrate_N = mkWN (k6 "sokeri") ; --UNCHK
lin carbolated_A = mkWA "fenoli-" ; --UNCHK
lin carbomycin_N = mkWN "karbomysiini" ; --UNCHK
lin carbon_N = mkN "hiili" "hiilen" "hiiliä" ;
lin carbon_paper_N = mkWN (compoundN "hiili" (k6 "paperi")) ; --UNCHK
lin carbonaceous_A = mkWA (compoundA "hiilipi" (k38 "toinen")) ; --UNCHK
lin carbonado_N = mkWN "karbonado" ; --UNCHK
lin carbonara_N = mkWN "carbonara" ; --UNCHK
lin carbonate_N = mkWN (k5A "karbonaatti") ; --UNCHK
lin carbonated_A = mkWA (compoundA "hiili" (k38 "happoinen")) ; --UNCHK
lin carbonation_N = mkWN (compoundN "hiili" (k38 "hapottaminen")) ; --UNCHK
lin carbonic_A = mkWA (compoundA "hiilipi" (k38 "toinen")) ; --UNCHK
lin carboniferous_A = mkWA (compoundA "hiilipi" (k38 "toinen")) ; --UNCHK
lin carbonization_N = mkWN (k1A "hiilto") ; --UNCHK
lin carbonize_V2 = mkWV2 (k53A "hiillyttää") ; --UNCHK
lin carbonyl_A = mkWA "karbonyyli-" ; --UNCHK
lin carborundum_N = mkWN (compoundN "pii" (k5 "karbidi")) ; --UNCHK
lin carboxyl_A = mkWA "karboksyyli-" ; --UNCHK
lin carboxyl_N = mkWN (compoundN "karboksyyli" (k10 "ryhmä")) ; --UNCHK
lin carboy_N = mkWN (compoundN "happo" (k1 "pullo")) ; --UNCHK
lin carbuncle_N = mkWN (compoundN "ajos" (k9 "pahka")) ; --UNCHK
lin carburettor_N = mkWN (k33A "kaasutin") ; --UNCHK
lin carcase_N = mkWN (k1A "raato") ; --UNCHK
lin carcass_N = mkWN (k1A "raato") ; --UNCHK
lin carcinogen_N = mkWN (k48 "aine") "syöpää" "aiheuttava" ; --UNCHK
lin carcinogenic_A = mkWA (k38 "karsinogeeninen") ; --UNCHK
lin carcinoid_N = mkWN "karsinoidi" ; --UNCHK
lin carcinoma_N = mkWN (k10A "syöpä") ; --UNCHK
lin carcinomatous_A = mkWA "karsinooma-" ; --UNCHK
lin carcinosarcoma_N = mkWN (compoundN "karsino" (k10 "sarkooma")) ; --UNCHK
lin card_1_N = mkWN (k5A "kortti") ;
lin card_2_N = mkWN (k5A "kortti") ;
lin card_V2 = mkWV2 (k53 "tarkistaa") "henkilöllisyys" ; --UNCHK
lin card_sharper_N = mkWN (k6 "huijari") ; --UNCHK
lin cardamom_N = mkWN (k10 "kardemumma") ; --UNCHK
lin cardboard_A = mkWA (k34A "hengetön") ; --UNCHK
lin cardboard_N = mkWN (k5A "kartonki") ; --UNCHK
lin cardcase_N = mkWN (compoundN "kortti" (k12 "rasia")) ; --UNCHK
lin cardenden_PN = foreignPN "Cardenden" ;
lin cardholder_N = mkWN (compoundN "kortin" (k12 "haltija")) ; --UNCHK
lin cardia_N = mkWN (compoundN "mahan" (k18 "suu")) ; --UNCHK
lin cardiac_A = mkWA (compoundA "kardia" (k38 "alinen")) ; --UNCHK
lin cardiff_PN = foreignPN "Cardiff" ;
lin cardigan_PN = foreignPN "Cardigan" ;
lin cardinal_A = mkWA "kardinaali-" ; --UNCHK
lin cardinal_N = mkWN (compoundN "puna" (k5 "kardinaali")) ; --UNCHK
lin cardinalfish_N = mkWN (compoundN "kardinaali" (k9 "kala")) ; --UNCHK
lin cardinality_N = mkWN (k40 "mahtavuus") ; --UNCHK
lin cardinalship_N = mkWN (k9A "virka") "kardinaalin" ; --UNCHK
lin cardiograph_N = mkWN "kardiografi" ; --UNCHK
lin cardiographic_A = mkWA "kardiografinen" ; --UNCHK
lin cardiography_N = mkWN (compoundN "sydänsähkö" (k10 "käyrä")) ; --UNCHK
lin cardioid_N = mkWN "kardioidi" ; --UNCHK
lin cardiologic_A = mkWA (k38 "kardiologinen") ; --UNCHK
lin cardiologistFem_N = variants {} ; ---- sense to be split
lin cardiologistMasc_N = mkWN (k5 "kardiologi") ; --UNCHK
lin cardiology_N = mkWN (k12 "kardiologia") ; --UNCHK
lin cardiomegaly_N = mkWN (compoundN "suurisydäm" (k40 "isyys")) ; --UNCHK
lin cardiomyopathy_N = mkWN (compoundN "sydänlihas" (k40 "sairaus")) ; --UNCHK
lin cardiopulmonary_A = mkWA "kardiopulmonaarinen" ; --UNCHK
lin cardiospasm_N = mkWN (compoundN "kardio" (k5 "spasmi")) ; --UNCHK
lin cardiovascular_A = mkWA (compoundA "kardio" (k38 "vaskulaarinen")) ; --UNCHK
lin carditis_N = mkWN (compoundN "sydän" (k39 "tulehdus")) ; --UNCHK
lin cardoon_N = mkWN (k6 "kardoni") ; --UNCHK
lin cardroom_N = mkWN (compoundN "peli" (k48 "huone")) ; --UNCHK
lin cardsharp_N = mkWN (k6 "huijari") ; --UNCHK
lin care_N = mkN "hoito" ;
lin care_V = mkV "välittää" ;
lin care_for_V2 = mkWV2 (k53A "hoitaa") ; --UNCHK
lin careen_V = mkWV (k52 "heilua") ; --UNCHK
lin careen_V2 = mkWV2 (k52 "heilua") ; --UNCHK
lin career_N = mkWN (k10 "ura") ;
lin career_V = mkWV (k53A "viilettää") ; --UNCHK
lin careerism_N = mkWN (compoundN "karrier" (k5 "ismi")) ; --UNCHK
lin careerist_N = mkWN (k5 "karrieristi") ; --UNCHK
lin carefree_A = mkWA (k34A "piittaamaton") ; --UNCHK
lin carefreeness_N = mkWN (k40 "huolettomuus") ; --UNCHK
lin careful_A = mkWA (k38 "varovainen") ;
lin carefulness_N = mkWN (k40 "tarkkaavaisuus") ; --UNCHK
lin caregiver_N = mkWN (k10 "huoltaja") ; --UNCHK
lin careless_A = mkWA (k34A "piittaamaton") ; --UNCHK
lin carelessness_N = mkWN (k40 "huolimattomuus") ; --UNCHK
lin carer_N = variants {} ; --
lin caress_N = mkWN (k2 "hyväily") ; --UNCHK
lin caress_V2 = mkWV2 (k67A "kosketella") ; --UNCHK
lin caressing_N = mkWN (k5 "petting") ; --UNCHK
lin caret_N = mkWN (k39 "huomautus") ; --UNCHK
lin caretaker_N = mkWN (k10 "hoitaja") ; --UNCHK
lin careworn_A = mkWA (k38 "näköinen") "sairaalloisen" ; --UNCHK
lin carful_N = mkWN (compoundN "auto" (k38 "llinen")) ; --UNCHK
lin cargo_N = mkWN (k39 "lähetys") ; --UNCHK
lin carhop_N = mkWN (k12 "tarjoilija") ; --UNCHK
lin caribou_N = mkWN (kH1 "poro") ; --UNCHK
lin caricature_N = mkWN (k3 "imitaatio") ; --UNCHK
lin caricature_V2 = mkWV2 (k62 "apinoida") ; --UNCHK
lin caricaturist_N = mkWN (compoundN "pila" (k10 "piirtäjä")) ; --UNCHK
lin caries_N = mkWN (k39 "karies") ; --UNCHK
lin carillon_N = mkWN (k1A "soitto") "kellosoittimen" ; --UNCHK
lin carillonneur_N = mkWN (compoundN "kellopelin" (k10 "soittaja")) ; --UNCHK
lin carina_N = mkWN (k1 "harju") ; --UNCHK
lin carinal_A = mkWA (compoundA "harju" (k38 "mainen")) ; --UNCHK
lin carinate_N = mkWN (k1A "lintu") "lentokykyinen" ; --UNCHK
lin carioca_N = mkWN "carioca" ; --UNCHK
lin carious_A = mkWA (k38 "reikäinen") ; --UNCHK
lin carissa_N = mkWN (compoundN "kapmaan" (k1 "luumu")) ; --UNCHK
lin carjacking_N = mkWN "auton" "ryöstäminen" ; --UNCHK
lin carlisle_PN = foreignPN "Carlisle" ;
lin carload_N = mkWN (compoundN "auto" (k38 "lastillinen")) ; --UNCHK
lin carlow_PN = foreignPN "Carlow" ;
lin carluke_PN = foreignPN "Carluke" ;
lin carmarthen_PN = foreignPN "Carmarthen" ;
lin carmelite_A = mkWA "karmeliitta-" ; --UNCHK
lin carmelite_N = mkWN (k5A "munkki") "valkoinen" ; --UNCHK
lin carminative_A = mkWA "ilmavaivoja" "lievittävä" ; --UNCHK
lin carminative_N = mkWN "karminatiivi" ; --UNCHK
lin carmine_A = mkWA (k10 "punertava") ; --UNCHK
lin carmine_N = mkWN (k6 "karmiini") ; --UNCHK
lin carnage_N = mkWN (k39 "teurastus") ; --UNCHK
lin carnal_A = mkWA (k38 "lihallinen") ; --UNCHK
lin carnallite_N = mkWN "karnalliitti" ; --UNCHK
lin carnassial_A = mkWA "raatelu-" ; --UNCHK
lin carnation_A = mkWA (compoundA "heleän" (k38 "punainen")) ; --UNCHK
lin carnation_N = mkWN (compoundN "heleän" (k38 "punainen")) ; --UNCHK
lin carnauba_N = mkWN (compoundN "karnauba-" (k1 "palmu")) ; --UNCHK
lin carnelian_N = mkWN (k5 "karneoli") ; --UNCHK
lin carnforth_PN = foreignPN "Carnforth" ;
lin carnival_N = mkWN (k5 "karnevaali") ; --UNCHK
lin carnivore_N = mkWN (compoundN "lihan" (k10 "syöjä")) ; --UNCHK
lin carnivorous_A = mkWA "lihaa" "syövä" ; --UNCHK
lin carnosaur_N = mkWN "karnosauri" ; --UNCHK
lin carnotite_N = mkWN "karnotiitti" ; --UNCHK
lin carnoustie_PN = foreignPN "Carnoustie" ;
lin carob_N = mkWN (compoundN "johanneksenleipä" (k18 "puu")) ; --UNCHK
lin carol_N = mkWN (compoundN "joulu" (k1 "laulu")) ; --UNCHK
lin carol_V2 = mkWV2 (k56 "laulaa") ; --UNCHK
lin caroler_N = mkWN (k10 "laulaja") ; --UNCHK
lin carolina_PN = foreignPN "Carolina" ;
lin caroling_N = mkWN "laulaminen" ; --UNCHK
lin caroller_N = mkWN (k10 "laulaja") ; --UNCHK
lin carom_N = mkWN (k9 "kara") ; --UNCHK
lin carotene_N = mkWN (k5 "karoteeni") ; --UNCHK
lin carotenemia_N = mkWN "karotinemia" ; --UNCHK
lin carotenoid_N = mkWN "karotenoidi" ; --UNCHK
lin carotid_A = mkWA "kaulavaltimo-" ; --UNCHK
lin carouse_V2 = mkWV2 (k73A "ryypätä") ; --UNCHK
lin carousel_N = mkWN (k5 "karuselli") ; --UNCHK
lin carp_N = mkWN (k5A "karppi") ; --UNCHK
lin carp_V = mkWV (k67A "juonitella") ; --UNCHK
lin carp_V2 = mkWV2 (k67A "juonitella") ; --UNCHK
lin carpal_A = mkWA "ranne-" ; --UNCHK
lin carpal_N = mkWN (compoundN "ranne" (k18 "luu")) ; --UNCHK
lin carpel_N = mkWN (compoundN "emi" (k7A "lehti")) ; --UNCHK
lin carpellary_A = mkWA "emi-" ; --UNCHK
lin carpellate_A = mkWA "emi-" ; --UNCHK
lin carpenter_N = mkWN (k6 "timpuri") ; --UNCHK
lin carpenteria_N = mkWN "Carpenteria" "californica" ; --UNCHK
lin carpentry_N = mkWN (compoundN "puun" (k1 "työstö")) ; --UNCHK
lin carper_N = mkWN (k10 "niuhottaja") ; --UNCHK
lin carpet_N = L.carpet_N ;
lin carpet_V2 = mkWV2 (k53A "peittää") ; --UNCHK
lin carpet_beater_N = mkWN (compoundN "matto" (k9 "piiska")) ; --UNCHK
lin carpet_knight_N = mkWN (k6 "ritari") ; --UNCHK
lin carpet_sweeper_N = mkWN (k12 "lakaisija") ; --UNCHK
lin carpetbag_A = mkWA "keinotteleva" ; --UNCHK
lin carpetbag_N = mkWN (compoundN "matto" (k1A "laukku")) ; --UNCHK
lin carpetbagger_N = mkWN (compoundN "onnen" (k12 "onkija")) ; --UNCHK
lin carpetweed_N = mkWN (compoundN "verticil" (k9A "lata")) "Molluga" ; --UNCHK
lin carpophagous_A = mkWA (compoundA "hedelmän" (k10 "syöjä")) ; --UNCHK
lin carpophore_N = mkWN (compoundN "karpof" (k48 "ori")) ; --UNCHK
lin carport_N = mkWN (compoundN "auto" (k39 "katos")) ; --UNCHK
lin carpospore_N = mkWN (k3 "itiö") ; --UNCHK
lin carposporic_A = mkWA "karpospori-" ; --UNCHK
lin carposporous_A = mkWA "karpospori-" ; --UNCHK
lin carrack_N = mkWN "karakki" ; --UNCHK
lin carrageenin_N = mkWN (compoundN "karra" (k5 "geeni")) ; --UNCHK
lin carrel_N = mkWN (compoundN "luku" (k39 "syvennys")) ; --UNCHK
lin carriage_N = variants {} ; --
lin carriageway_N = mkWN (compoundN "ajo" (k9A "rata")) ; --UNCHK
lin carrier_N = mkWN (k10 "kantaja") ; --f135
lin carrier_bag_N = mkWN (k5 "pussi") ; --UNCHK
lin carrier_pigeon_N = mkWN (compoundN "kirje" (k1 "kyyhky")) ; --UNCHK
lin carrion_N = mkWN (k1A "raato") ; --UNCHK
lin carrion_crow_N = mkWN (compoundN "musta" (k6 "kondori")) ; --UNCHK
lin carrot_N = mkWN (k12 "porkkana") ; --UNCHK
lin carroty_A = mkWA (compoundA "puna" (k38 "päinen")) ; --UNCHK
lin carry_N = mkN "ote" | mkN "muistibitti" ; ---- split
lin carry_V = mkV "kantaa" ;
lin carry_V2 = mkV2 (mkV "kantaa") partitive ;
lin carry_forward_V2 = mkWV2 (k54A "siirtää") ; --UNCHK
lin carry_off_V2 = mkWV2 (k64 "viedä") "hautaan" ; --UNCHK
lin carry_on_V = mkWV (k56 "jatkaa") ; --UNCHK
lin carry_on_V2 = mkWV2 (k56 "jatkaa") ; --UNCHK
lin carry_on_about_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_about_Prep ; -- guess-p-verb
lin carry_on_with_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin carry_out_V = mkWV (k65 "käydä") "läpi" ; --UNCHK
lin carry_out_V2 = mkWV2 (k65 "käydä") "läpi" ; --UNCHK
lin carry_over_V2 = mkWV2 (k54A "siirtää") ; --UNCHK
lin carry_through_V2 = mkWV2 (k56A "saattaa") "voimaan" ; --UNCHK
lin carryall_N = mkWN (k5 "kori") ; --UNCHK
lin carrycot_N = mkWN (compoundN "kanto" (k5 "kassi")) ; --UNCHK
lin carsick_A = mkWA (compoundA "meri" (k41 "sairas")) ; --UNCHK
lin cart_N = mkWN (k1 "vaunu") ; --UNCHK
lin cart_V2 = mkWV2 (k73 "kärrätä") ; --UNCHK
lin cart_off_V2 = mkWV2 (k64 "viedä") "pois" ; --UNCHK
lin cart_track_N = mkWN (k1A "polku") ; --UNCHK
lin cartage_N = mkWN "kärrääminen" ; --UNCHK
lin cartagena_PN = foreignPN "Cartagena" ;
lin carte_blanche_N = mkWN (compoundN "valta" (k9 "kirja")) "avoin" ; --UNCHK
lin cartel_N = mkWN (k5 "kartelli") ; --UNCHK
lin carter_N = mkWN (k10 "kärrääjä") ; --UNCHK
lin carthorse_N = mkWN (compoundN "työ" (k38 "hevonen")) ; --UNCHK
lin cartilage_N = mkWN (k1 "rusto") ; --UNCHK
lin cartilaginification_N = mkWN (compoundN "rusto" (k38 "utuminen")) ; --UNCHK
lin cartilaginous_A = mkWA "rusto-" ; --UNCHK
lin cartload_N = mkWN (compoundN "kärry" (k38 "llinen")) ; --UNCHK
lin cartographer_N = mkWN (compoundN "kartan" (k10 "valmistaja")) ; --UNCHK
lin cartographic_A = mkWA (k38 "kartografinen") ; --UNCHK
lin cartography_N = mkWN (k12 "kartografia") ; --UNCHK
lin carton_N = mkWN (k4A "laatikko") ; --UNCHK
lin cartoon_N = mkN "piirros" (mkN "elokuva") ;
lin cartoon_V2 = mkWV2 (k54A "piirtää") ; --UNCHK
lin cartoonistFem_N = mkWN (compoundN "pila" (k10 "piirtäjä")) ; --UNCHK
lin cartoonistMasc_N = mkWN (compoundN "pila" (k10 "piirtäjä")) ; --UNCHK
lin cartouche_N = mkWN (compoundN "kar" (k5 "tussi")) ; --UNCHK
lin cartridge_N = mkWN (kH1 "patruuna") ; --UNCHK
lin cartridge_belt_N = mkWN (compoundN "patruuna" (k19 "vyö")) ; --UNCHK
lin cartridge_paper_N = mkWN (compoundN "kartuusi" (k6 "paperi")) ; --UNCHK
lin cartroad_N = mkWN (k1A "polku") ; --UNCHK
lin cartwheel_N = mkWN (compoundN "kärryn" (k10 "pyörä")) ; --UNCHK
lin cartwright_N = mkWN (compoundN "kärryn" (k12 "tekijä")) ; --UNCHK
lin caruncle_N = mkWN (k9A "heltta") ; --UNCHK
lin caruncular_A = mkWA (compoundA "heltta" (k38 "mainen")) ; --UNCHK
lin carunculate_A = mkWA "heltallinen" ; --UNCHK
lin carve_V = mkV "kaivertaa" ;
lin carve_V2 = mkWV2 (k73A "leikata") ; --UNCHK
lin carve_out_V2 = mkWV2 (k53A "ottaa") "haltuun" ; --UNCHK
lin carve_up_V2 = mkWV2 (k56A "jakaa") ; --UNCHK
lin carvedilol_N = mkWN "karvediloli" ; --UNCHK
lin carver_N = mkWN (k10 "leikkaaja") "paistin" ; --UNCHK
lin carving_N = mkWN (compoundN "kuvanveisto" (k48A "taide")) ; --UNCHK
lin carving_fork_N = mkWN (compoundN "paisti" (k14A "haarukka")) ; --UNCHK
lin carving_knife_N = mkWN (compoundN "paisti" (k30 "veitsi")) ; --UNCHK
lin caryatid_N = mkWN "karyatidi" ; --UNCHK
lin caryophyllaceous_A = mkWA "kohokki-" ; --UNCHK
lin casaba_N = mkWN (compoundN "casaba" (k6 "meloni")) ; --UNCHK
lin casablanca_PN = foreignPN "Casablanca" ;
lin cascade_N = mkWN (k7 "pilvi") ; --UNCHK
lin cascade_V = mkWV (k53A "limittää") ; --UNCHK
lin cascara_N = mkWN (compoundN "rohto" (k11 "paatsama")) ; --UNCHK
lin cascarilla_N = mkWN "Croton" "eluteria" ; --UNCHK
lin case_N = mkN "tapaus" ;
lin case_V2 = mkWV2 (k53A "peittää") ; --UNCHK
lin case_history_N = mkWN (compoundN "tapaus" (k39 "kertomus")) ; --UNCHK
lin case_law_N = mkWN (k5A "prejudikaatti") ; --UNCHK
lin casebook_A = mkWA (compoundA "oppikirja" (k38 "mainen")) ; --UNCHK
lin casebook_N = mkWN (compoundN "työpäivä" (k9 "kirja")) ; --UNCHK
lin casein_N = mkWN (k5 "kaseiini") ; --UNCHK
lin casement_N = mkWN (k12 "ikkuna") ; --UNCHK
lin caseous_A = mkWA "kaseaatio-" ; --UNCHK
lin casern_N = mkWN (k5 "kasarmi") ; --UNCHK
lin casework_N = mkWN (compoundN "sosiaali" (k19 "työ")) ; --UNCHK
lin caseworm_N = mkWN (compoundN "kotelo" (k10A "toukka")) ; --UNCHK
lin cash_N = mkN "käteinen" ;
lin cash_V = mkWV (k53A "muuttaa") "rahaksi" ; --UNCHK
lin cash_V2 = mkWV2 (k53A "muuttaa") "rahaksi" ; --UNCHK
lin cash_in_V2 = mkWV2 (k53A "muuttaa") "rahaksi" ; --UNCHK
lin cash_in_on_V2 = mkWV2 (k53A "käyttää") "hyväkseen" ; --UNCHK
lin cash_out_V2 = mkWV2 (k56A "vaihtaa") "vapaalle" ; --UNCHK
lin cashable_A = mkWA (k10 "vaihdettava") "rahaksi" ; --UNCHK
lin cashbox_N = mkWN (k9 "kassa") ; --UNCHK
lin cashew_N = mkWN (compoundN "cashew" (k12 "pähkinä")) ; --UNCHK
lin cashier_N = mkWN (k9 "kassa") ; --UNCHK
lin cashier_V2 = mkWV2 (k53A "erottaa") ; --UNCHK
lin cashmere_N = mkWN (k5 "kašmir") ; --UNCHK
lin casing_N = mkWN (k39 "kehys") ; --UNCHK
lin casino_N = mkWN (k2 "kasino") ;
lin cask_N = mkWN (k1A "pönttö") ; --UNCHK
lin casket_N = mkWN (k41A "lipas") ; --UNCHK
lin caspase_N = mkWN (compoundN "kas" (k27 "paasi")) ; --UNCHK
lin casque_N = mkWN (k7 "kaski") ; --UNCHK
lin casquet_N = mkWN (compoundN "suoja" (k10 "kypärä")) ; --UNCHK
lin cassareep_N = mkWN (compoundN "maniokki" (k48A "kastike")) ; --UNCHK
lin cassava_N = mkWN "maniokki" ; --UNCHK
lin casserole_N = mkWN (k10A "vuoka") ; --UNCHK
lin cassette_N = mkWN (k5A "kasetti") ; --UNCHK
lin cassia_N = mkWN (compoundN "kiinan" (k6 "kaneli")) ; --UNCHK
lin cassiri_N = mkWN "cassiri" ; --UNCHK
lin cassiterite_N = mkWN (compoundN "kassite" (k5A "riitti")) ; --UNCHK
lin cassock_N = mkWN (k14A "kasukka") ; --UNCHK
lin cassocked_A = mkWA "kasukkaan" "pukeutunut" ; --UNCHK
lin cassowary_N = mkWN (k5 "kasuaari") ; --UNCHK
lin cast_N = mkWN (k1A "heitto") ; --UNCHK
lin cast_V = mkV (mkV "saada") "rooli" ; ---ARB --mkV (mkV "antaa") "ääni") ; --mkWV (k53A "heittää") "laattaa" ;
lin cast_V2 = mkV2 "heittää" ;
lin cast_about_for_V2 = prepV2 (advV OP_cast_V OP_about_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_around_V = mkWV (k61 "etsiä") ; --UNCHK
lin cast_around_for_V2 = prepV2 (advV OP_cast_V OP_around_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_aside_V2 = mkWV2 (k73A "hylätä") ; --UNCHK
lin cast_iron_A = mkA (mkN "valu" (mkN "rautainen")) ;
lin cast_off_V = mkWV (k52A "hankkiutua") "eroon" ; --UNCHK
lin cast_off_V2 = mkWV2 (k52A "hankkiutua") "eroon" ; --UNCHK
lin cast_out_V2 = mkWV2 (k73A "hylätä") ; --UNCHK
lin cast_round_for_V2 = prepV2 (advV OP_cast_V OP_round_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_up_V2 = prepV2 OP_cast_V OP_up_Prep ; -- guess-p-verb
lin castaway_N = mkWN (k38 "haaksirikkoinen") ; --UNCHK
lin caste_N = mkWN (kH1 "kasti") ; --UNCHK
lin castellated_A = mkWA (k38 "sakarainen") ; --UNCHK
lin caster_N = mkWN (k10 "pyörä") ; --UNCHK
lin castigate_V2 = mkWV2 (k53A "kurittaa") ; --UNCHK
lin castigation_N = mkWN (k2 "nuhtelu") ; --UNCHK
lin casting_N = mkWN "roolitus" ;
lin castle_N = mkWN (k39 "linnoitus") ; --UNCHK
lin castle_V = mkWV (k53A "tornittaa") ; --UNCHK
lin castleford_PN = foreignPN "Castleford" ;
lin castor_N = mkWN (compoundN "Castor-" (k1A "suku")) ; --UNCHK
lin castor_oil_N = mkWN (compoundN "risiini" (k1 "öljy")) ; --UNCHK
lin castrate_V2 = mkWV2 (k62 "steriloida") ; --UNCHK
lin castration_N = mkWN (compoundN "siivo" (k38 "aminen")) ; --UNCHK
lin castrato_N = mkWN (k5A "kastraatti") ; --UNCHK
lin casual_A = mkA "epäformaali" ;
lin casualness_N = mkWN (k40 "tuttuus") ; --UNCHK
lin casualty_N = mkWN (k3 "tappio") ; --UNCHK
lin casuarina_N = mkWN "kasuariina" ; --UNCHK
lin casuist_N = mkWN (k5 "sofisti") ; --UNCHK
lin casuistic_A = mkWA (k38 "kasuistinen") ; --UNCHK
lin casuistical_A = mkWA (k38 "kasuistinen") ; --UNCHK
lin casuistry_N = mkWN (k9A "kasuistiikka") ; --UNCHK
lin casus_belli_N = mkWN (k39 "oikeutus") "sodan" ; --UNCHK
lin cat_N = L.cat_N ;
lin catabiosis_N = mkWN "solujen" "surkastuminen" ; --UNCHK
lin catabolism_N = mkWN (compoundN "aineen" (k9A "vaihdunta")) "hajottava" ; --UNCHK
lin catachresis_N = mkWN "katakreesi" ; --UNCHK
lin catachrestic_A = mkWA "katakreesi-" ; --UNCHK
lin cataclinal_A = mkWA (compoundA "myötäi" (k10 "levä")) "maastoa" ; --UNCHK
lin cataclysm_N = mkWN (k12 "tragedia") ; --UNCHK
lin cataclysmal_A = mkWA (k38 "turmiollinen") ; --UNCHK
lin cataclysmic_A = mkWA (k38 "turmiollinen") ; --UNCHK
lin catacomb_N = mkWN (k5 "katakombi") ; --UNCHK
lin catacorner_A = mkWA (k99 "viistosti") ; --UNCHK
lin catadromous_A = mkWA "katadrominen" ; --UNCHK
lin catafalque_N = mkWN (k5A "katafalkki") ; --UNCHK
lin catalanFem_N = mkWN (k5 "katalaani") ; --UNCHK
lin catalanMasc_N = mkWN (k5 "katalaani") ; --UNCHK
lin catalan_A = mkA "katalonialainen" ;
lin catalase_N = mkWN (compoundN "katal" (k5 "aasi")) ; --UNCHK
lin catalatic_A = mkWA "katalaasi-" ; --UNCHK
lin catalectic_A = mkWA "katalektinen" ; --UNCHK
lin catalectic_N = mkWN (k48A "säe") "katalektinen" ; --UNCHK
lin catalepsy_N = mkWN "katalepsia" ; --UNCHK
lin cataleptic_A = mkWA "kataleptinen" ; --UNCHK
lin cataleptic_N = mkWN (k2 "henkilö") "kataleptinen" ; --UNCHK
lin catalexis_N = mkWN "kataleksi" ; --UNCHK
lin catalog_N = mkWN (k2 "luettelo") ; --UNCHK
lin catalog_V2 = mkWV2 (k67A "luokitella") ; --UNCHK
lin cataloger_N = mkWN "luetteloija" ; --UNCHK
lin catalogue_N = mkWN (k2 "luettelo") ; --UNCHK
lin catalogue_V2 = mkWV2 (k67A "luokitella") ; --UNCHK
lin catalpa_N = mkWN (compoundN "trumpetti" (k18 "puu")) ; --UNCHK
lin catalufa_N = mkWN (compoundN "suuri" (k10 "silmä")) ; --UNCHK
lin catalysis_N = mkWN (k5 "katalyysi") ; --UNCHK
lin catalyst_N = mkWN (k10 "käynnistäjä") ; --UNCHK
lin catalytic_A = mkWA (k38 "katalyyttinen") ; --UNCHK
lin catamaran_N = mkWN (k5 "katamaraani") ; --UNCHK
lin catamite_N = mkWN "katamiitti" ; --UNCHK
lin catananche_N = mkWN "katana" ; --UNCHK
lin catania_PN = foreignPN "Catania" ;
lin cataphasia_N = mkWN (compoundN "sanan" (k1 "toisto")) ; --UNCHK
lin cataphatic_A = mkWA (compoundA "kat" (k38 "afaattinen")) ; --UNCHK
lin cataphyll_N = mkWN (compoundN "sirkka" (k7A "lehti")) ; --UNCHK
lin cataplasia_N = mkWN (compoundN "rap" (k38 "peutuminen")) ; --UNCHK
lin cataplastic_A = mkWA "rappeutuva" ; --UNCHK
lin catapult_N = mkWN (k1A "linko") ; --UNCHK
lin catapult_V2 = mkWV2 (k53A "sinkauttaa") ; --UNCHK
lin catapultic_A = mkWA (compoundA "katapultti" (k38 "mainen")) ; --UNCHK
lin cataract_N = mkWN (compoundN "vesi" (k39 "putous")) ; --UNCHK
lin catarrh_N = mkWN (k5 "katarri") ; --UNCHK
lin catarrhal_A = mkWA "katarri-" ; --UNCHK
lin catarrhine_A = mkWA (compoundA "itäapina" (k38 "mainen")) ; --UNCHK
lin catastrophe_N = mkWN (k12 "tragedia") ; --UNCHK
lin catastrophic_A = mkA "katastrofaalinen" ;
lin catatonia_N = mkWN (k12 "skitsofrenia") "katatoninen" ; --UNCHK
lin catatonic_A = mkWA "katatoninen" ; --UNCHK
lin catbird_N = mkWN (compoundN "kissa" (k41 "rastas")) ; --UNCHK
lin catboat_N = mkWN (k5A "katti") ; --UNCHK
lin catcall_N = mkWN (k39 "vihellys") ; --UNCHK
lin catcall_V = mkWV (k54A "viheltää") ; --UNCHK
lin catch_N = mkWN (k99 "kiinni") "saada" ; --UNCHK
lin catch_V2 = mkV2 (mkV (mkV "saada") "kiinni") | mkV2 (mkV (mkV "ottaa") "kiinni") ;
lin catch_at_V2 = prepV2 (lin V OP_catch_V2) OP_at_Prep ; -- guess-p-verb
lin catch_crop_N = mkWN (compoundN "väli" (k1A "sato")) ; --UNCHK
lin catch_on_V = mkWV (k52 "menestyä") ; --UNCHK
lin catch_out_V2 = prepV2 (lin V OP_catch_V2) OP_out_Prep ; -- guess-p-verb
lin catch_up_V = mkWV (k53A "saavuttaa") ; --UNCHK
lin catch_up_V2 = mkWV2 (k53A "saavuttaa") ; --UNCHK
lin catch_up_in_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_in_Prep ; -- guess-p-verb
lin catch_up_on_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin catch_up_with_V2 = mkWV2 (k53A "tavoittaa") ; --UNCHK
lin catchall_N = mkWN (compoundN "säilytys" (k12 "astia")) ; --UNCHK
lin catcher_N = mkWN (k10 "sieppaaja") ; --UNCHK
lin catching_N = mkWN (k38 "saaminen") "sairauden" ; --UNCHK
lin catchment_N = mkWN (compoundN "valuma-" (k48 "alue")) ; --UNCHK
lin catchment_area_N = mkWN (k41A "allas") ; --UNCHK
lin catchment_basin_N = mkWN (k41A "allas") ; --UNCHK
lin catchpenny_A = mkWA (compoundA "halpa" (k48A "tuote")) ; --UNCHK
lin catchphrase_N = mkWN (compoundN "isku" (k48 "lause")) ; --UNCHK
lin catchword_N = mkWN (compoundN "opas" (k9 "sana")) ; --UNCHK
lin catchy_A = mkWA "tarttuva" ; --UNCHK
lin catechesis_N = mkWN "katekeesi" ; --UNCHK
lin catechetical_A = mkWA (compoundA "katek" (k38 "eettinen")) ; --UNCHK
lin catechin_N = mkWN "katekiini" ; --UNCHK
lin catechism_N = mkWN (k39 "katekismus") ; --UNCHK
lin catechismal_A = mkWA "katekismus-" ; --UNCHK
lin catechist_N = mkWN (k9A "katekeetta") ; --UNCHK
lin catechistic_A = mkWA (compoundA "katek" (k38 "eettinen")) ; --UNCHK
lin catechize_V2 = mkWV2 (k67 "kuulustella") ; --UNCHK
lin catecholamine_N = mkWN "katekoliamiini" ; --UNCHK
lin catechu_N = mkWN "Acacia" "catechu" ; --UNCHK
lin catechumen_N = mkWN (k38 "käännynnäinen") "uusi" ; --UNCHK
lin categorem_N = mkWN (compoundN "kategore" (k5 "emi")) ; --UNCHK
lin categorematic_A = mkWA (compoundA "kate" (k38 "goremaattinen")) ; --UNCHK
lin categorial_A = mkWA (k38 "kategorinen") ; --UNCHK
lin categoric_A = mkWA (k38 "kategorinen") ; --UNCHK
lin categorical_A = mkWA (k38 "kategorinen") ; --UNCHK
lin categorization_N = mkWN (k2 "lajittelu") ; --UNCHK
lin categorize_V2 = mkWV2 (k62 "lokeroida") ; --UNCHK
lin category_N = mkN "kategoria" ; --f53
lin catena_N = mkWN "kateeni" ; --UNCHK
lin catenary_N = mkWN (compoundN "ketju" (k10 "käyrä")) ; --UNCHK
lin catenulate_A = mkWA (compoundA "ketju" (k38 "mainen")) ; --UNCHK
lin cater_V = mkWV (k53A "toimittaa") "ruokaa" ; --UNCHK
lin caterer_N = mkWN (compoundN "pito" (k2 "palvelu")) ; --UNCHK
lin catering_N = mkWN (compoundN "pito" (k2 "palvelu")) ; --UNCHK
lin caterpillar_N = mkWN (k10A "toukka") ; --UNCHK
lin caterwaul_N = mkWN "mouku" ; --UNCHK
lin caterwaul_V = mkWV (k52A "monkua") ; --UNCHK
lin catfish_N = mkWN (compoundN "monni" (k9 "kala")) ; --UNCHK
lin catgut_N = mkWN (k5A "katgutti") ; --UNCHK
lin catharsis_N = mkWN (k39 "katarsis") ; --UNCHK
lin cathartic_A = mkWA (k10 "aikaansaava") "ulostuksen" ; --UNCHK
lin cathartic_N = mkWN (k5 "laksatiivi") ; --UNCHK
lin cathectic_A = mkWA (compoundA "kate" (k38 "ktinen")) ; --UNCHK
lin cathedra_N = mkWN (k33 "istuin") "piispan" ; --UNCHK
lin cathedral_A = mkWA "katedraali-" ; --UNCHK
lin cathedral_N = mkWN (k5 "katedraali") ; --UNCHK
lin catheter_N = mkWN (k5 "katetri") ; --UNCHK
lin catheterization_N = mkWN (k5A "katetrointi") ; --UNCHK
lin cathexis_N = mkWN (compoundN "viettienergia" (k39 "varaus")) ; --UNCHK
lin cathode_N = mkWN (k5 "katodi") ; --UNCHK
lin cathodic_A = mkWA (compoundA "kato" (k38 "dinen")) ; --UNCHK
lin catholicFem_N = mkWN (k38 "katolilainen") ; --UNCHK
lin catholicMasc_N = mkWN (k38 "katolilainen") ; --UNCHK
lin catholic_A = mkWA (k38 "katolilainen") ; --UNCHK
lin catholicism_N = mkWN (k40 "katolisuus") ; --UNCHK
lin catholicity_N = mkWN (compoundN "yleis" (k40 "maailmallisuus")) ; --UNCHK
lin cation_N = mkWN (k5 "kationi") ; --UNCHK
lin cationic_A = mkWA (compoundA "kationi" (k38 "nen")) ; --UNCHK
lin catkin_N = mkWN (k1A "norkko") ; --UNCHK
lin catkinate_A = mkWA (compoundA "urpu" (k38 "mainen")) ; --UNCHK
lin catling_N = mkWN (compoundN "leikkaus" (k30 "veitsi")) ; --UNCHK
lin catmint_N = mkWN "aitokissanminttu" ; --UNCHK
lin catoptric_A = mkWA "peilioptiikka-" ; --UNCHK
lin catoptrics_N = mkWN (compoundN "peili" (k14A "optiikka")) ; --UNCHK
lin catostomid_N = mkWN (compoundN "imu" (k5A "karppi")) ; --UNCHK
lin catsup_N = mkWN (k5A "ketsuppi") ; --UNCHK
lin cattail_N = mkWN (compoundN "osman" (k5 "käämi")) ; --UNCHK
lin cattalo_N = mkWN "beefalo" ; --UNCHK
lin cattiness_N = mkWN (k9 "kauna") ; --UNCHK
lin cattish_A = mkWA (k15 "ilkeä") ; --UNCHK
lin cattle_N = mkWN (k9A "nauta") ; --UNCHK
lin cattle_cake_N = mkWN (compoundN "väki" (k1 "rehu")) ; --UNCHK
lin cattleman_N = mkWN (compoundN "karjan" (k10 "kasvattaja")) ; --UNCHK
lin cattleship_N = mkWN (compoundN "karja" (k9 "laiva")) ; --UNCHK
lin catty_A = mkWA (k15 "ilkeä") ; --UNCHK
lin catty_N = mkWN (k9 "pauna") ; --UNCHK
lin catwalk_N = mkWN (k9A "silta") ; --UNCHK
lin caucasianFem_N = mkN "kaukasialainen" ;
lin caucasianMasc_N = mkN "kaukasialainen" ;
lin caucasian_A = mkWA (k38 "kaukasialainen") ; --UNCHK
lin caucus_N = mkWN (compoundN "puolue" (k39 "kokous")) ; --UNCHK
lin cauda_N = mkWN (k10A "häntä") ; --UNCHK
lin caudal_A = mkWA (compoundA "kauda" (k38 "alinen")) ; --UNCHK
lin caudate_A = mkWA (compoundA "kauda" (k38 "alinen")) ; --UNCHK
lin caudex_N = mkWN (compoundN "varsi" (k12 "mukula")) ; --UNCHK
lin caul_N = mkWN (compoundN "sikiö" (k1 "kalvo")) ; --UNCHK
lin cauldron_N = mkWN (kH1 "pata") ; --UNCHK
lin caulescent_A = mkWA (k38 "varrellinen") ; --UNCHK
lin cauliflower_N = mkWN (compoundN "kukka" (k5 "kaali")) ; --UNCHK
lin cauline_A = mkWA "varsi-" ; --UNCHK
lin caulk_N = mkWN (k48 "tiiviste") ; --UNCHK
lin caulk_V2 = mkWV2 (k69 "tilkitä") ; --UNCHK
lin causal_A = mkWA (k38 "kausaalinen") ; --UNCHK
lin causalgia_N = mkWN "kausalgia" ; --UNCHK
lin causality_N = mkWN (k5A "kausaliteetti") ; --UNCHK
lin causation_N = mkWN (compoundN "aihe" (k38 "uttaminen")) ; --UNCHK
lin causative_A = mkWA (k38 "kausaalinen") ; --UNCHK
lin cause_N = mkN "syy" ;
lin cause_V2 = mkV2 "aiheuttaa" ;
lin cause_V2V = mkV2V (mkV "saada") accusative infIllat ;
lin causeless_A = mkWA (k10 "yllättävä") ; --UNCHK
lin causerie_N = mkWN (k39 "pälpätys") ; --UNCHK
lin causeway_N = mkWN (compoundN "penger" (k19 "tie")) ; --UNCHK
lin causing_N = mkWN (compoundN "aihe" (k38 "uttaminen")) ; --UNCHK
lin caustic_A = mkWA "erittäin" "syövyttävä" ; --UNCHK
lin caustic_N = mkWN (k39 "emäs") "syövyttävä" ; --UNCHK
lin cautery_N = mkWN "kauterisaatio" ; --UNCHK
lin caution_N = mkWN (k40 "tarkkaavaisuus") ; --UNCHK
lin caution_V = mkV "varoittaa" ; --mkWV (k53A "kehottaa") ;
lin caution_V2 = mkWV2 (k53A "kehottaa") ; --UNCHK
lin caution_V2V = mkWV2V (k53A "kehottaa") ; --UNCHK
lin caution_VS = mkWVS (k53A "kehottaa") ; --UNCHK
lin cautionary_A = mkWA "varoitukseksi" "annettu" ; --UNCHK
lin cautious_A = mkA "harkitsevainen" ;
lin cavalcade_N = mkWN (k48 "kulkue") ; --UNCHK
lin cavalier_A = mkA "piittaamaton" ;
lin cavalier_N = mkWN (k5 "rojalisti") ; --UNCHK
lin cavalryman_N = mkWN (compoundN "ratsu" (k41 "sotilas")) ; --UNCHK
lin cavan_PN = foreignPN "Cavan" ;
lin cave_N = mkWN (k2 "luolasto") ; --UNCHK
lin cave_V = mkWV (k61 "tutkia") "luolia" ; --UNCHK
lin cave_V2 = mkWV2 (k61 "tutkia") "luolia" ; --UNCHK
lin cave_dweller_N = mkWN (compoundN "luola" (k38 "ihminen")) ; --UNCHK
lin cave_in_N = mkWN "romahtaminen" ; --UNCHK
lin cave_in_V = mkWV (k52A "murtua") ; --UNCHK
lin caveat_N = mkWN (compoundN "vasta" (k48 "lause")) ; --UNCHK
lin caveman_N = mkWN (compoundN "luola" (k38 "ihminen")) ; --UNCHK
lin cavern_N = mkWN (k2 "onkalo") ; --UNCHK
lin cavernous_A = mkWA (compoundA "erek" (k23 "tiili")) ; --UNCHK
lin cavetto_N = mkWN (k1 "kouru") ; --UNCHK
lin caviar_N = mkWN (k5A "mäti") ; --UNCHK
lin cavil_V = mkWV (k67A "juonitella") ; --UNCHK
lin cavity_N = mkWN (k2 "ontelo") ; --UNCHK
lin cavort_V = mkWV (k68 "karkeloida") ; --UNCHK
lin cavy_N = mkWN (k1 "marsu") ; --UNCHK
lin caw_N = mkWN (compoundN "vaak" (k38 "kuminen")) ; --UNCHK
lin caw_V = mkWV (k52A "vaakkua") ; --UNCHK
lin caw_V2 = mkWV2 (k52A "vaakkua") ; --UNCHK
lin cayenne_N = mkWN (compoundN "cayennen" (k6 "pippuri")) ; --UNCHK
lin cayenne_pepper_N = mkWN (compoundN "cayennen" (k6 "pippuri")) ; --UNCHK
lin cayman_N = mkWN (k5 "kaimaani") ; --UNCHK
lin cayuse_N = mkWN (compoundN "intiaani" (k5 "poni")) ; --UNCHK
lin cc_N = mkWN (compoundN "kuutiosentti" (k5 "metri")) ; --UNCHK
lin cd_N = mkWN (k99 "CD") ; --f65
lin cease_N = mkWN (k1A "tauko") ;
lin cease_V = mkWV (k52A "loppua") ; --UNCHK
lin cease_V2 = mkWV2 (k52A "loppua") ; --UNCHK
lin cease_VS = mkWVS (k52A "loppua") ; --UNCHK
lin cease_fire_N = mkN "tulitauko" ;
lin ceasefire_N = mkN "tulitauko" ;
lin ceaseless_A = mkWA (k38 "alituinen") ; --UNCHK
lin cecal_A = mkWA "umpisuoli-" ; --UNCHK
lin cecilia_PN = foreignPN "Cecilia" ;
lin cecropia_N = mkWN "Hyalophora" "cecropia" ; --UNCHK
lin cecum_N = mkWN (compoundN "umpi" (k26 "suoli")) ; --UNCHK
lin cedar_N = mkWN (k5 "setri") ; --UNCHK
lin cedarn_A = mkWA "seetri-" ; --UNCHK
lin cede_V2 = mkWV2 (k52A "luopua") ; --UNCHK
lin cedi_N = mkWN "cedi" ; --UNCHK
lin cedilla_N = mkWN "sedilji" ; --UNCHK
lin cefadroxil_N = mkWN (k5 "kefadroksiili") ; --UNCHK
lin cefoperazone_N = mkWN "Cefobid" ; --UNCHK
lin cefotaxime_N = mkWN "Claforan" ; --UNCHK
lin ceftazidime_N = mkWN "Tazicef" ; --UNCHK
lin ceftriaxone_N = mkWN "Rocephin" ; --UNCHK
lin cefuroxime_N = mkWN "Zinacef" ; --UNCHK
lin ceibo_N = mkWN (k5 "crista-galli") "Erythrina" ; --UNCHK
lin ceiling_N = L.ceiling_N ;
lin ceilinged_A = mkWA (compoundA "kate" (k1 "ttu")) ; --UNCHK
lin celandine_N = mkWN (k2 "keltamo") ; --UNCHK
lin celebrant_N = mkWN (compoundN "messu" (k5A "pappi")) ; --UNCHK
lin celebrate_V2 = mkV2 "juhlia" partitive ; --WV2 (k53 "ylistää") ;
lin celebrated_A = mkWA (k41A "värikäs") ; --UNCHK
lin celebration_N = mkN "juhlinta" ;
lin celebratory_A = mkWA "juhla-" ; --UNCHK
lin celebrity_N = mkWN (k2 "henkilö") "julkisuuden" ;
lin celecoxib_N = mkWN "Celebrex" ; --UNCHK
lin celeriac_N = mkWN (k6 "selleri") ; --UNCHK
lin celerity_N = mkWN (k40 "ripeys") ; --UNCHK
lin celery_N = mkWN (k6 "selleri") ; --UNCHK
lin celesta_N = mkWN "celesta" ; --UNCHK
lin celestial_A = mkWA (k38 "taivaallinen") ; --UNCHK
lin celestite_N = mkWN "selestiitti" ; --UNCHK
lin celiac_A = mkWA "vatsaontelon" ; --UNCHK
lin celibacy_N = mkWN (k5A "selibaatti") ; --UNCHK
lin celibate_A = mkWA (k38 "pidättyväinen") ; --UNCHK
lin celibate_N = mkWN (k5A "selibaatti") ; --UNCHK
lin celiocentesis_N = mkWN (compoundN "laparosen" (k5 "teesi")) ; --UNCHK
lin celioma_N = mkWN (compoundN "vatsa" (k33 "kasvain")) ; --UNCHK
lin celioscopy_N = mkWN (k12 "laparoskopia") ; --UNCHK
lin cell_N = mkN "solu" ;
lin cellar_N = mkWN (k6 "kellari") ; --UNCHK
lin cellarage_N = mkWN (compoundN "kellari" (k9 "tila")) ; --UNCHK
lin cellblock_N = mkWN (compoundN "vanki" (k2 "osasto")) ; --UNCHK
lin cellistFem_N = mkWN (k5 "sellisti") ; --UNCHK
lin cellistMasc_N = mkWN (k5 "sellisti") ; --UNCHK
lin cello_N = mkWN (k1 "sello") ; --UNCHK
lin cellophane_N = mkWN (k5 "sellofaani") ; --UNCHK
lin cellular_A = mkWA (compoundA "solu" (k38 "mainen")) ;
lin cellularity_N = mkWN "solullisuus" ; --UNCHK
lin cellulite_N = mkWN (k5A "selluliitti") ; --UNCHK
lin cellulitis_N = mkWN (k5A "selluliitti") ; --UNCHK
lin celluloid_A = mkWA (k38 "teennäinen") ; --UNCHK
lin celluloid_N = mkWN (k5 "filmi") ; --UNCHK
lin cellulose_N = mkWN (k10 "selluloosa") ; --UNCHK
lin cellulosic_N = mkWN "selluloosa-" ; --UNCHK
lin cellulosid_A = mkWA "selluloosa-" ; --UNCHK
lin celom_N = mkWN (compoundN "coe" (k10 "loma")) ; --UNCHK
lin celt_N = mkWN (k5A "keltti") ; --UNCHK
lin celtic_A = mkWA (k38 "kelttiläinen") ; --UNCHK
lin celtic_N = mkN "kelttiläinen" ;
lin celtuce_N = mkWN (compoundN "parsa" (k5A "salaatti")) ; --UNCHK
lin cement_N = mkWN (compoundN "juuri" (k5A "sementti")) ; --UNCHK
lin cement_V2 = mkWV2 (k53 "vahvistaa") ; --UNCHK
lin cement_mixer_N = mkWN (compoundN "betoni" (k1 "mylly")) ; --UNCHK
lin cementite_N = mkWN (compoundN "rauta" (k5 "karbidi")) ; --UNCHK
lin cementitious_A = mkWA (compoundA "sementti" (k38 "mäinen")) ; --UNCHK
lin cementum_N = mkWN (compoundN "juuri" (k5A "sementti")) ; --UNCHK
lin cemetery_N = mkWN (k2 "kalmisto") ; --UNCHK
lin cenobite_N = mkWN (compoundN "keno" (k5A "biitti")) ; --UNCHK
lin cenobitic_A = mkWA (compoundA "ken" (k38 "obioottinen")) ; --UNCHK
lin cenogenesis_N = mkWN "kenogeneesi" ; --UNCHK
lin cenogenetic_A = mkWA (compoundA "keno" (k38 "geneettinen")) ; --UNCHK
lin cenotaph_N = mkWN (compoundN "muisto" (k5A "merkki")) "sankarivainajien" ; --UNCHK
lin censer_N = mkWN (compoundN "suitsutus" (k12 "astia")) ; --UNCHK
lin censor_N = mkWN (k10 "tarkastaja") ; --UNCHK
lin censor_V2 = mkWV2 (k62 "sensuroida") ; --UNCHK
lin censorial_A = mkWA "sensuuri-" ; --UNCHK
lin censoring_N = mkWN (k5A "sensurointi") ; --UNCHK
lin censorious_A = mkWA (k38 "kriittinen") ; --UNCHK
lin censorship_N = mkWN (k5A "sensurointi") ;
lin censure_N = mkWN (k48A "moite") ; --UNCHK
lin censure_V2 = mkWV2 (k67 "arvostella") ; --UNCHK
lin census_N = mkWN (compoundN "väestön" (k9A "laskenta")) ; --UNCHK
lin cent_N = mkN (lin NK {s = d05A "sentti"}) ;
lin centas_N = mkWN "centas" ; --UNCHK
lin centaur_N = mkWN "Kentauri" ; --UNCHK
lin centaury_N = mkWN (k5A "kaunokki") ; --UNCHK
lin centenarian_A = mkWA (compoundA "sata" (k38 "vuotinen")) ; --UNCHK
lin centenarian_N = mkWN "satavuotias" ; --UNCHK
lin centenary_A = mkWA (compoundA "sata" (k38 "vuotinen")) ; --UNCHK
lin centenary_N = mkWN (compoundN "satavuotis" (k10 "juhla")) ; --UNCHK
lin centennial_A = mkWA (compoundA "sata" (k38 "vuotinen")) ; --UNCHK
lin centennial_N = mkWN (compoundN "satavuotis" (k10 "juhla")) ; --UNCHK
lin center_A = mkWA (k38 "keskustalainen") ; --UNCHK
lin centered_A = mkA "keskitetty" ; --WA (k99 "keskellä") ;
lin centerfold_N = mkWN (compoundN "keski" (k10 "aukeama")) ; --UNCHK
lin centering_N = mkWN (compoundN "aloitus" (k1A "syöttö")) ; --UNCHK
lin centerline_N = mkWN (compoundN "keski" (k9 "viiva")) ; --UNCHK
lin centesimal_A = mkWA "sadasosan" ; --UNCHK
lin centesimo_N = mkWN "centesimo" ; --UNCHK
lin centesis_N = mkWN (compoundN "imu" (k1 "pisto")) ; --UNCHK
lin centigrade_A = mkWA "celsiusastetta" ; --UNCHK
lin centiliter_N = mkWN (compoundN "sentti" (k9 "litra")) ; --UNCHK
lin centime_N = mkWN (k5A "sentti") ; --UNCHK
lin centimetre_N = mkWN (k5A "sentti") ; --UNCHK
lin centimo_N = mkWN "centimo" ; --UNCHK
lin centipede_N = mkWN (compoundN "juoksu" (k38 "jalkainen")) ; --UNCHK
lin central_A = mkA "keskeinen" ;
lin central_N = mkWN (k39 "keskus") ; --UNCHK
lin centralism_N = mkWN (compoundN "keskittämis" (k9A "politiikka")) ; --UNCHK
lin centralist_A = mkWA (k10 "tukeva") "keskittämispolitiikkaa" ; --UNCHK
lin centrality_N = mkWN (k40 "keskeisyys") ; --UNCHK
lin centralization_N = mkWN (k39 "keskitys") ; --UNCHK
lin centralize_V = mkWV (k53A "keskittää") ; --UNCHK
lin centralize_V2 = mkWV2 (k53A "keskittää") ; --UNCHK
lin centre_N = mkN "keskusta" ;
lin centre_V = mkWV (k53 "kohdistaa") "huomionsa" ; --UNCHK
lin centre_V2 = mkWV2 (k53 "kohdistaa") "huomionsa" ; --UNCHK
lin centre_bit_N = mkWN (compoundN "puu" (k10 "terä")) ; --UNCHK
lin centre_board_N = mkWN (compoundN "nosto" (k5 "köli")) ; --UNCHK
lin centrepiece_N = mkWN (compoundN "pöytä" (k48 "koriste")) ; --UNCHK
lin centrex_N = mkWN (compoundN "vaihde" (k2 "palvelu")) ; --UNCHK
lin centric_A = mkWA (k38 "keskinen") ; --UNCHK
lin centrifugal_A = mkWA (k38 "keskipakoinen") ; --UNCHK
lin centrifugation_N = mkWN (compoundN "linko" (k38 "aminen")) ; --UNCHK
lin centrifuge_N = mkWN (k33A "erotin") ; --UNCHK
lin centriole_N = mkWN (compoundN "sen" (k6 "trioli")) ; --UNCHK
lin centripetal_A = mkWA (compoundA "keski" (k38 "hakuinen")) ; --UNCHK
lin centrism_N = mkWN (k40 "maltillisuus") ; --UNCHK
lin centrist_A = mkWA (k38 "maltillinen") ; --UNCHK
lin centrist_N = mkWN (k38 "maltillinen") ; --UNCHK
lin centroid_N = mkWN (compoundN "keski" (k48 "piste")) "massan" ; --UNCHK
lin centroidal_A = mkWA "massan" "keskipisteen" ; --UNCHK
lin centromere_N = mkWN (compoundN "kinetok" (k48 "ori")) ; --UNCHK
lin centromeric_A = mkWA (compoundA "sen" (k38 "tromeerinen")) ; --UNCHK
lin centrosome_N = mkWN (compoundN "keskus" (k38 "jyvänen")) ; --UNCHK
lin centrosomic_A = mkWA "sentrosomin" ; --UNCHK
lin centrum_N = mkWN (compoundN "runko-" (k10 "osa")) "nikaman" ; --UNCHK
lin centurion_N = mkWN (compoundN "sadanpääm" (k41A "ies")) ; --UNCHK
lin century_N = mkN "vuosi" (mkN "sata") ;
lin cephalexin_N = mkWN "Keftab" ; --UNCHK
lin cephalhematoma_N = mkWN (compoundN "veri" (k9 "pahka")) ; --UNCHK
lin cephalic_A = mkWA (compoundA "kefa" (k38 "alinen")) ; --UNCHK
lin cephalochordate_N = mkWN (compoundN "Cephalochor" (k9 "data")) ; --UNCHK
lin cephaloglycin_N = mkWN "Kafocin" ; --UNCHK
lin cephalometry_N = mkWN (k39 "mittaus") "pään" ; --UNCHK
lin cephalopod_A = mkWA (k10 "kuuluva") "pääjalkaisiin" ; --UNCHK
lin cephalopod_N = mkWN (compoundN "pää" (k38 "jalkainen")) ; --UNCHK
lin cephaloridine_N = mkWN "kefaloridiini" ; --UNCHK
lin cephalosporin_N = mkWN (k5 "kefalosporiini") ; --UNCHK
lin cephalothin_N = mkWN "kefalotiini" ; --UNCHK
lin ceramic_A = mkWA (k38 "keraaminen") ;
lin ceramic_N = mkWN (k9A "keramiikka") ; --UNCHK
lin ceramics_N = mkWN (k9A "keramiikka") ; --UNCHK
lin ceras_N = mkWN "sarvimainen" "kidus" ; --UNCHK
lin cerate_N = mkWN (compoundN "vaha" (k9 "salva")) ; --UNCHK
lin ceratodus_N = mkWN "Ceratodus" ; --UNCHK
lin ceratopsian_N = mkWN (k10 "kuuluva") "Ceratopsia-alalahkoon" ; --UNCHK
lin ceratosaur_N = mkWN "Ceratosaurus" ; --UNCHK
lin ceratozamia_N = mkWN "Ceratozamia" ; --UNCHK
lin cercaria_N = mkWN "Cercaria" ; --UNCHK
lin cercarial_A = mkWA (k10 "kuuluva") "Cercaria-toukkiin" ; --UNCHK
lin cere_N = mkWN (compoundN "vaha" (k9 "nahka")) ; --UNCHK
lin cereal_A = mkWA "vilja-" ; --UNCHK
lin cereal_N = mkWN (k5 "velli") ; --UNCHK
lin cerebellar_A = mkWA "pikkuaivojen" ; --UNCHK
lin cerebral_A = mkWA (k38 "älyllinen") ; --UNCHK
lin cerebration_N = mkWN (k2 "ajattelu") ; --UNCHK
lin cerebrospinal_A = mkWA "aivoselkäydin-" ; --UNCHK
lin cerebrovascular_A = mkWA "aivoverisuoni-" ; --UNCHK
lin cerecloth_N = mkWN (compoundN "vaha" (k48 "kääre")) ; --UNCHK
lin ceremonial_A = mkWA (k38 "seremoniaalinen") ; --UNCHK
lin ceremonial_N = mkWN (k5A "riitti") ; --UNCHK
lin ceremonious_A = mkWA (k38 "juhlallinen") ; --UNCHK
lin ceremoniousness_N = mkWN (k40 "muodollisuus") ; --UNCHK
lin ceremony_N = mkWN (k12 "seremonia") ; --UNCHK
lin ceresin_N = mkWN "seresiini" ; --UNCHK
lin ceric_A = mkWA "cerium-" ; --UNCHK
lin ceriman_N = mkWN (k10 "hedelmä") "Monstera" "deliciosan" ; --UNCHK
lin cerise_A = mkWA (k10 "punertava") ; --UNCHK
lin cerise_N = mkWN (compoundN "kirsikan" (k38 "punainen")) ; --UNCHK
lin cerium_N = mkWN "järjestysluku" "58" ; --UNCHK
lin cerivastatin_N = mkWN (compoundN "seriv" (k5 "astatiini")) ; --UNCHK
lin cernuous_A = mkWA (k10 "riippuva") ; --UNCHK
lin cero_N = mkWN (compoundN "kuningas" (k5 "makrilli")) ; --UNCHK
lin cerous_A = mkWA "cerium-" ; --UNCHK
lin cert_N = mkWN (k12 "asia") "varma" ; --UNCHK
lin certain_1_A = mkA (mkN "varma") "varmempi" "varmin" ;
lin certain_2_A = mkA "tietty" ;
lin certain_A = mkA (mkN "varma") "varmempi" "varmin" ;
lin certainty_N = mkWN (k1A "juttu") "varma" ; --UNCHK
lin certifiable_A = mkWA (k10 "oleva") "todistettavissa" ; --UNCHK
lin certificate_N = mkN (lin NK {s = d39 "todistus"}) ;
lin certificate_V2 = mkWV2 (k56A "antaa") "todistus" ; --UNCHK
lin certification_N = mkWN (k39 "todennus") ; --UNCHK
lin certificatory_A = mkWA "todistus-" ; --UNCHK
lin certified_A = mkA "valtuutettu" ;
lin certify_V = mkWV (k53 "todistaa") ; --UNCHK
lin certify_V2 = mkV2 "varmentaa" ; --WV2 (k53 "todistaa") ;
lin certiorari_N = mkWN (compoundN "certiorari-" (k39 "määräys")) ; --UNCHK
lin certitude_N = mkWN (k40 "varmuus") "liiallinen" ; --UNCHK
lin cerulean_A = mkWA (k38 "sininen") ; --UNCHK
lin cerumen_N = mkWN (k1A "vaikku") ; --UNCHK
lin ceruminous_A = mkWA "korvavaha-" ; --UNCHK
lin cerussite_N = mkWN (compoundN "lyijy" (k38 "valkoinen")) ; --UNCHK
lin cervical_A = mkWA (compoundA "servika" (k38 "alinen")) ; --UNCHK
lin cervicitis_N = mkWN (k39 "tulehdus") "kohdunkaulan" ; --UNCHK
lin cervine_A = mkWA "hirvi-" ; --UNCHK
lin cervix_N = mkWN (compoundN "kohdunka" (k10 "ula")) ; --UNCHK
lin cesarean_A = mkWA "keisari-" ; --UNCHK
lin cesium_N = mkWN (k5 "cesium") ; --UNCHK
lin cessation_N = mkWN (compoundN "loppu" (k38 "minen")) ; --UNCHK
lin cession_N = mkWN (k39 "luovutus") ; --UNCHK
lin cesspit_N = mkWN (compoundN "saostus" (k1 "kaivo")) ; --UNCHK
lin cesspool_N = mkWN (compoundN "saostus" (k1 "kaivo")) ; --UNCHK
lin cetacean_A = mkWA (compoundA "valaan" (k38 "sukuinen")) ; --UNCHK
lin cetacean_N = mkWN (k41A "nisäkäs") "valaansukuinen" ; --UNCHK
lin cetrimide_N = mkWN (k5 "setrimidi") ; --UNCHK
lin cgs_N = mkWN (compoundN "cgs-" (k10 "järjestelmä")) ; --UNCHK
lin chabazite_N = mkWN "kabasiitti" ; --UNCHK
lin chachalaca_N = mkWN "kaklattaja" ; --UNCHK
lin chachka_N = mkWN (k1 "hely") ; --UNCHK
lin chacma_N = mkWN (compoundN "karhu" (k5 "paviaani")) ; --UNCHK
lin chad_N = mkN "tšadilainen" ;
lin chad_PN = foreignPN "Tsad" ;
lin chadian_A = mkWA (compoundA "tsadi" (k38 "lainen")) ; --UNCHK
lin chadian_N = mkWN (compoundN "tsadi" (k38 "lainen")) ; --UNCHK
lin chador_N = mkWN "burka" ; --UNCHK
lin chaenactis_N = mkWN "Chaenactis" ; --UNCHK
lin chaeta_N = mkWN (k38 "sukanen") ; --UNCHK
lin chaetodon_N = mkWN "Chaetodon" ; --UNCHK
lin chafe_N = mkWN (k9 "vaiva") ; --UNCHK
lin chafe_V = mkWV (k73A "hangata") ; --UNCHK
lin chafe_V2 = mkWV2 (k73A "hangata") ; --UNCHK
lin chafeweed_N = mkWN (compoundN "aho" (k12 "jäkkärä")) ; --UNCHK
lin chaff_N = mkWN (compoundN "tutkanhäirintä" (k1A "silppu")) ; --UNCHK
lin chaff_V2 = mkWV2 (k67 "pilailla") ; --UNCHK
lin chaffinch_N = mkWN (k1A "peippo") ; --UNCHK
lin chaffweed_N = mkWN (compoundN "pikku" (k10A "punka")) ; --UNCHK
lin chaffy_A = mkWA (k10 "oleva") "silppuna" ; --UNCHK
lin chafing_N = mkWN (k10 "hiertymä") ; --UNCHK
lin chafing_dish_N = mkWN (compoundN "lämpö" (k13 "alusta")) ; --UNCHK
lin chagrin_N = mkWN (k15 "häpeä") ; --UNCHK
lin chagrin_V2 = mkWV2 (k54A "alentaa") ; --UNCHK
lin chain_N = mkN "ketju" ;
lin chain_V2 = mkWV2 (k53A "kiinnittää") "ketjulla" ; --UNCHK
lin chain_armour_N = mkWN (compoundN "silmukka" (k6 "panssari")) ; --UNCHK
lin chain_letter_N = mkWN (compoundN "ketju" (k48 "kirje")) ; --UNCHK
lin chain_mail_N = mkWN (compoundN "silmukka" (k6 "panssari")) ; --UNCHK
lin chain_stitch_N = mkWN (compoundN "ketju" (k1 "pisto")) ; --UNCHK
lin chain_store_N = mkWN (compoundN "ketju" (k12 "myymälä")) ; --UNCHK
lin chair_N = L.chair_N ;
lin chair_V2 = mkWV2 (k53A "johtaa") "puhetta" ;
lin chair_lift_N = mkWN (compoundN "tuoli" (k5 "hissi")) ; --UNCHK
lin chairman_N = mkN "puheenjohtaja" | mkN "puhe" L.man_N ;
lin chairmanship_N = mkWN (compoundN "puheen" (k40 "johtajuus")) ; --UNCHK
lin chaise_longue_N = mkWN (k6 "divaani") ; --UNCHK
lin chaja_N = mkWN "Chauna" "torquata" ; --UNCHK
lin chalazion_N = mkWN (compoundN "luomi" (k12 "rakkula")) ; --UNCHK
lin chalcedony_N = mkWN "kalsedoni" ; --UNCHK
lin chalcocite_N = mkWN (compoundN "kupari" (k48A "hohde")) ; --UNCHK
lin chalcopyrite_N = mkWN (compoundN "kupari" (k1 "kiisu")) ; --UNCHK
lin chaldron_N = mkWN "chaldron" ; --UNCHK
lin chalet_N = mkWN (compoundN "alppi" (k9 "maja")) ; --UNCHK
lin chalfont_PN = foreignPN "Chalfont" ;
lin chalice_N = mkWN (k6 "pikari") ; --UNCHK
lin chalk_N = mkWN (k1A "liitu") ; --UNCHK
lin chalk_V2 = mkWV2 (k69 "merkitä") "liidulla" ; --UNCHK
lin chalk_out_V2 = mkWV2 (k67A "hahmotella") ; --UNCHK
lin chalk_up_V2 = mkWV2 (k53A "pitää") "kirjaa" ; --UNCHK
lin chalkpit_N = mkWN (compoundN "liitu" (k39 "louhos")) ; --UNCHK
lin chalky_A = mkWA (compoundA "kalkki" (k38 "nen")) ; --UNCHK
lin challah_N = mkWN (compoundN "chale-" (k10A "leipä")) ; --UNCHK
lin challenge_N = mkN "haaste" ; --f56
lin challenge_V = mkV (mkV "joutua") "kyseenalaiseksi" ; --mkWV (k61A "moittia") ;
lin challenge_V2 = mkV2 "haastaa" ;
lin challengeable_A = mkWA (k5 "jäävi") ; --UNCHK
lin challenger_N = mkWN (k10 "haastaja") ; --UNCHK
lin chalybeate_A = mkWA (compoundA "rautapi" (k38 "toinen")) ; --UNCHK
lin chamber_N = mkWN (k6 "kamari") ; --UNCHK
lin chambered_A = mkWA (compoundA "ontelo" (k38 "rakenteinen")) ; --UNCHK
lin chamberlain_N = mkWN (compoundN "kamari" (k9 "herra")) ; --UNCHK
lin chambermaid_N = mkWN (compoundN "huone" (k12 "palvelija")) ; --UNCHK
lin chamberpot_N = mkWN (k10A "potta") ; --UNCHK
lin chambray_N = mkWN (k5 "batisti") ; --UNCHK
lin chameleon_N = mkWN (k5A "kameleontti") ; --UNCHK
lin chammy_leather_N = mkWN (k13 "säämiskä") ; --UNCHK
lin chamois_N = mkWN "Rupicapra" "rupicapra" ; --UNCHK
lin chamois_leather_N = mkWN (k13 "säämiskä") ; --UNCHK
lin chamosite_N = mkWN "chamosiitti" ; --UNCHK
lin champ_N = mkWN (k6 "mestari") ; --UNCHK
lin champ_V = mkWV (k67 "pureskella") ; --UNCHK
lin champ_V2 = mkWV2 (k67 "pureskella") ; --UNCHK
lin champagne_N = mkWN (k5 "kuohuviini") ; --UNCHK
lin champerty_N = mkWN "champerty" ; --UNCHK
lin champion_A = mkWA (k6 "mestari") ; --UNCHK
lin champion_N = mkWN (k5A "ekspertti") ; --UNCHK
lin champion_V2 = mkV2 "hallita" ;
lin championship_N = mkN "mestaruus" ; --mkWN (k39 "kannatus") ;
lin champleve_A = mkWA (compoundA "soluem" (k38 "alinen")) ; --UNCHK
lin chanar_N = mkWN (compoundN "spin" (k10 "osa")) "Lucuma" ; --UNCHK
lin chance_N = mkN (lin NK {s = d40 "mahdollisuus"}) ;
lin chance_V = mkWV (k73A "kohdata") "sattumalta" ; --UNCHK
lin chance_V2 = mkWV2 (k73A "kohdata") "sattumalta" ; --UNCHK
lin chance_VS = mkWVS (k73A "kohdata") "sattumalta" ; --UNCHK
lin chance_upon_V2 = mkWV2 (k61 "keksiä") ; --UNCHK
lin chancel_N = mkWN (kH1 "kuori") ; --UNCHK
lin chancellery_N = mkWN (compoundN "kanslerin" (k1 "virasto")) ; --UNCHK
lin chancellor_N = mkWN (k6 "kansleri") ;
lin chancellorship_N = mkWN (compoundN "kanslerin" (k9A "virka")) ; --UNCHK
lin chancery_N = mkWN (k2 "arkisto") ; --UNCHK
lin chancre_N = mkWN (k6 "sankkeri") ; --UNCHK
lin chancroid_N = mkWN (k6 "sankkeri") "pehmeä" ; --UNCHK
lin chancrous_A = mkWA (compoundA "sankkeri" (k38 "mainen")) ; --UNCHK
lin chancy_A = mkWA (compoundA "epä" (k9 "varma")) ; --UNCHK
lin chandelier_N = mkN "katto" (mkN "kruunu") ;
lin chandler_N = mkWN (compoundN "kynttilän" (k12 "tekijä")) ; --UNCHK
lin chandlery_N = mkWN (compoundN "kynttilä" (k2 "varasto")) ; --UNCHK
lin chanfron_N = mkWN (compoundN "otsa" (k13 "haarniska")) "hevosen" ; --UNCHK
lin changchun_PN = foreignPN "Changchun" ;
lin change_N = mkN "muutos" ;
lin change_V = mkV "muuttua" ;
lin change_V2 = mkV2 "muuttaa" ;
lin change_over_V2 = mkWV2 (k56A "vaihtaa") ; --UNCHK
lin changeable_A = mkWA (k38 "epävakainen") ; --UNCHK
lin changeableness_N = mkWN (k40 "epävakaisuus") ; --UNCHK
lin changeful_A = mkWA (k38 "epävakainen") ; --UNCHK
lin changeless_A = mkWA (k10 "pysyvä") ; --UNCHK
lin changelessness_N = mkWN (k40 "muuttumattomuus") ; --UNCHK
lin changeling_N = mkWN (k41A "vaihdokas") ; --UNCHK
lin changeover_N = mkWN (k39 "muutos") ; --UNCHK
lin changer_N = mkWN (compoundN "levyn" (k10 "vaihtaja")) ; --UNCHK
lin changing_A = mkA "vaihteleva" ;
lin changsha_PN = foreignPN "Changsha" ;
lin channel_N = mkWN (k10 "kanava") ; --UNCHK
lin channel_V2 = mkWV2 (k53A "lähettää") ; --UNCHK
lin channelization_N = mkWN (k5A "kanavointi") ; --UNCHK
lin channels_N = mkWN (compoundN "virka" (k19 "tie")) ; --UNCHK
lin chant_N = mkWN (k5 "resitatiivi") ; --UNCHK
lin chant_V = mkWV (k74 "messuta") ; --UNCHK
lin chant_V2 = mkWV2 (k74 "messuta") ; --UNCHK
lin chanter_N = mkWN (k33A "puhallin") "säkkipillin" ; --UNCHK
lin chanterelle_N = mkWN (k5 "kantarelli") ; --UNCHK
lin chantey_N = mkWN (compoundN "merimies" (k1 "laulu")) ; --UNCHK
lin chantlike_A = mkWA (compoundA "loitsu" (k38 "mainen")) ; --UNCHK
lin chantry_N = mkWN (compoundN "sielumessu" (k6 "kappeli")) ; --UNCHK
lin chaos_N = mkWN (k39 "kaaos") ; --UNCHK
lin chaotic_A = mkWA (k38 "kaoottinen") ;
lin chap_N = mkN "poika" "pojan" "poikia" ;
lin chap_V = mkWV (k67 "halkeilla") ; --UNCHK
lin chap_V2 = mkWV2 (k67 "halkeilla") ; --UNCHK
lin chapatti_N = mkWN (k5A "chapatti") ; --UNCHK
lin chapel_N = mkWN (compoundN "jumalan" (k39 "palvelus")) ; --UNCHK
lin chapelgoer_N = mkWN (k5A "protestantti") ; --UNCHK
lin chaperon_N = mkWN (k12 "kaitsija") ; --UNCHK
lin chaperon_V2 = mkWV2 (k61 "toimia") "esiliinana" ; --UNCHK
lin chapfallen_A = mkWA (k38 "alakuloinen") ; --UNCHK
lin chaplain_N = mkWN (k38 "kappalainen") ; --UNCHK
lin chaplaincy_N = mkWN (k9A "virka") "kappalaisen" ; --UNCHK
lin chaplet_N = mkWN (k5 "kranssi") ; --UNCHK
lin chapleted_A = mkWA "seppelöity" ; --UNCHK
lin chapman_N = mkWN (compoundN "kulku" (k41 "kauppias")) ; --UNCHK
lin chapter_N = mkWN (k1A "luku") ;
lin chapterhouse_N = mkWN (k12 "asuntola") "opiskelijayhdistyksen" ; --UNCHK
lin char_N = mkWN (k12 "nieriä") ; --UNCHK
lin char_V = mkWV (k53 "ruskistaa") ; --UNCHK
lin char_V2 = mkWV2 (k53 "ruskistaa") ; --UNCHK
lin charabanc_N = variants {} ; ---- sense to be split
lin characin_N = mkWN (compoundN "karppi" (k23 "lohi")) ; --UNCHK
lin character_1_N = mkN "luonne" ; ---- sense ?
lin character_2_N = mkN "merkki" ; ---- sense ?
lin characteristic_A = mkWA (k38 "ominainen") ; --UNCHK
lin characteristic_N = mkWN (compoundN "tunto" (k5A "merkki")) ; --UNCHK
lin characterization_N = mkWN (k9A "tulkinta") ; --UNCHK
lin characterize_V2 = mkWV2 (k61A "luonnehtia") ; --UNCHK
lin characterless_A = mkWA (k10 "tylsä") ; --UNCHK
lin charade_N = mkWN (k39 "arvoitus") "miiminen" ; --UNCHK
lin charades_N = mkWN (compoundN "arvoitus" (k5A "leikki")) "miiminen" ; --UNCHK
lin charcoal_A = mkWA (k5A "antrasiitti") ; --UNCHK
lin charcoal_N = mkWN (compoundN "hiili" (k10 "kynä")) ; --UNCHK
lin charcoal_burner_N = mkWN (compoundN "hiili" (k33A "poltin")) ; --UNCHK
lin chard_N = mkWN (compoundN "lehti" (k5 "mangoldi")) ; --UNCHK
lin chard_PN = foreignPN "Chard" ;
lin charge_1_N = mkN "varaus" ;
lin charge_2_N = mkN "syytös" ;
lin charge_N = mkN "varaus" ;
lin charge_V = mkV "latautua" ;
lin charge_V2 = mkV2 "kuormittaa" partitive ;
lin charge_account_N = mkWN (compoundN "asiakas" (k5 "tili")) ; --UNCHK
lin charge_d'affaires_N = mkWN (compoundN "asiain" (k10 "hoitaja")) ; --UNCHK
lin charge_off_V = advV OP_charge_V OP_off_Adv ; -- guess-p-verb
lin charge_sheet_N = mkWN (compoundN "rikos" (k6 "rekisteri")) ; --UNCHK
lin charge_up_V2 = mkWV2 (k63 "saada") "innostumaan" ; --UNCHK
lin charge_with_V3 = variants {} ; -- guess-p-verb
lin chargeable_A = mkWA (k38 "alainen") "syytteen" ; --UNCHK
lin charger_N = mkWN (compoundN "sota" (k1 "ratsu")) ; --UNCHK
lin charioteer_N = mkWN (compoundN "Ajom" (k41A "ies")) ; --UNCHK
lin charisma_N = mkWN (k13 "karisma") ; --UNCHK
lin charismatic_A = mkWA (k38 "karismaattinen") ; --UNCHK
lin charitable_A = mkA (mkN "hyvän" (mkN "tahtoinen")) ; --mkWA (k41 "armelias") ;
lin charitableness_N = mkWN (k40 "hyväntekeväisyys") ; --UNCHK
lin charity_N = mkWN (k40 "hyväntekeväisyys") ;
lin charivari_N = mkWN (k5 "charivari") ; --UNCHK
lin charlatan_N = mkWN (k6 "huijari") ; --UNCHK
lin charlatanism_N = mkWN (k5A "puoskarointi") ; --UNCHK
lin charleston_N = mkWN "Charleston" ; --UNCHK
lin charlock_N = mkWN (compoundN "rikka" (k5A "sinappi")) ; --UNCHK
lin charlotte_N = mkWN (compoundN "charlotte-" (k41A "vanukas")) ; --UNCHK
lin charlotte_PN = foreignPN "Charlotte" ;
lin charm_N = mkWN (k5A "amuletti") ; --UNCHK
lin charm_V = mkWV (k67A "vietellä") ; --UNCHK
lin charm_V2 = mkWV2 (k67A "vietellä") ; --UNCHK
lin charmer_N = mkWN (k10 "lumooja") ; --UNCHK
lin charming_A = variants {} ; --
lin charnel_A = mkWA (compoundA "hauta" (k38 "mainen")) ; --UNCHK
lin charnel_house_N = mkWN (compoundN "ruumis" (k48 "huone")) ; --UNCHK
lin chart_N = mkWN (compoundN "meri" (k5A "kortti")) ; --UNCHK
lin chart_V2 = mkV2 "kartoittaa" ;
lin chartaceous_A = mkWA (k38 "paperinen") ; --UNCHK
lin charter_N = mkWN (compoundN "perustamis" (k9 "kirja")) ; --UNCHK
lin charter_V2 = mkV2 "vuokrata" ; --mkWV2 (k53A "ottaa") "vuokralle" ;
lin charterhouse_N = mkWN (compoundN "kartusiaani" (k6 "luostari")) ; --UNCHK
lin chartist_N = mkWN (k4A "analyytikko") "tekninen" ; --UNCHK
lin chartless_A = mkWA "kartoittamaton" ; --UNCHK
lin chartreuse_A = mkWA (compoundA "keltaisen" (k15 "vihreä")) ; --UNCHK
lin chartreuse_N = mkWN (compoundN "kelta" (k15 "vihreä")) "kirkkaan" ; --UNCHK
lin charwoman_N = mkWN (k10 "siivooja") ; --UNCHK
lin chary_A = mkWA (k38 "harkitsevainen") ; --UNCHK
lin chase_N = mkWN (kH1 "jahti") ; --UNCHK
lin chase_V = mkWV (k54A "kaivertaa") ; --UNCHK
lin chase_V2 = mkV2 (mkV (mkV "ajaa") "takaa") partitive ; --mkWV2 (k54A "kaivertaa") ;
lin chaser_N = mkWN "chaser" ; --UNCHK
lin chasm_N = mkWN (k1 "kuilu") ; --UNCHK
lin chasse_N = mkWN "chassé" ; --UNCHK
lin chassis_N = mkWN (k13 "alusta") ; --UNCHK
lin chasten_V2 = mkWV2 (k53 "alistaa") ; --UNCHK
lin chasteness_N = mkWN (k40 "vaatimattomuus") ; --UNCHK
lin chastise_V2 = mkWV2 (k54A "ojentaa") ; --UNCHK
lin chastisement_N = mkWN (k2 "nuhtelu") ; --UNCHK
lin chastity_N = mkWN (k5A "selibaatti") ; --UNCHK
lin chasuble_N = mkWN (compoundN "messu" (k14A "kasukka")) ; --UNCHK
lin chat_N = mkWN (k1A "sieppo") ; --UNCHK
lin chat_V = mkWV (k66 "horista") ; --UNCHK
lin chat_up_V2 = mkWV2 (k67A "suostutella") ; --UNCHK
lin chateau_N = mkWN (k9 "linna") ; --UNCHK
lin chatham_PN = foreignPN "Chatham" ;
lin chattel_N = mkWN (k48 "esine") "irtain" ; --UNCHK
lin chatter_N = mkWN (k39 "pälpätys") ; --UNCHK
lin chatter_V = mkWV (k53A "pälättää") ; --UNCHK
lin chatterbox_N = mkWN (k5A "suupaltti") ; --UNCHK
lin chatterer_N = mkWN "kotinga" ; --UNCHK
lin chatty_A = mkWA (k41 "suulas") ; --UNCHK
lin chauffeur_N = mkWN (k10 "kuljettaja") ; --UNCHK
lin chauffeur_V2 = mkWV2 (k56 "ajaa") ; --UNCHK
lin chauffeuse_N = mkWN (compoundN "auton" (k10 "kuljettaja")) ; --UNCHK
lin chaulmoogra_N = mkWN "Taraktogenos" "kurzii" ; --UNCHK
lin chauvinism_N = mkWN (k5 "sovinismi") ; --UNCHK
lin chauvinist_N = mkWN (k38 "ihminen") "kiihkoisänmaallinen" ; --UNCHK
lin chauvinistic_A = mkWA "šovinistinen" ; --UNCHK
lin chaw_N = mkWN (kH1 "mälli") ; --UNCHK
lin chaw_V2 = mkWV2 (k61 "pureksia") ; --UNCHK
lin cheadle_PN = foreignPN "Cheadle" ;
lin cheap_A = mkWA (k38 "edullinen") ; --f84
lin cheapen_V = mkWV (k58 "laskea") "hintaa" ; --UNCHK
lin cheapen_V2 = mkWV2 (k58 "laskea") "hintaa" ; --UNCHK
lin cheapjack_A = mkWA (k15 "surkea") ; --UNCHK
lin cheapjack_N = mkWN (k5A "helppoheikki") ; --UNCHK
lin cheapness_N = mkWN (k10 "roska") ; --UNCHK
lin cheapskate_N = mkWN (k6 "saituri") ; --UNCHK
lin cheat_N = mkWN (k5A "vilppi") ; --UNCHK
lin cheat_V = mkWV (k73 "huijata") ; --UNCHK
lin cheat_V2 = mkWV2 (k73 "huijata") ; --UNCHK
lin cheat_on_V2 = mkWV2 (k53A "pettää") ; --UNCHK
lin chebab_N = mkWN "chebab" ; --UNCHK
lin check_N = mkN "tarkistus" ;
lin check_V = mkV "tarkastaa" ; ---- subcat
lin check_V2 = mkV2 "tarkastaa" | mkV2 "tarkistaa" | mkV2 "estää" ; ---- split
lin check_back_V = advV OP_check_V OP_back_Adv ; -- guess-p-verb
lin check_by_V2 = prepV2 OP_check_V OP_by_Prep ; -- guess-p-verb
lin check_for_V2 = prepV2 OP_check_V OP_for_Prep ; -- guess-p-verb
lin check_in_V = mkWV (k71 "tehdä") "lähtöselvitys" ; --UNCHK
lin check_in_V2 = mkWV2 (k71 "tehdä") "lähtöselvitys" ; --UNCHK
lin check_into_V2 = mkWV2 (k73A "tsekata") ; --UNCHK
lin check_off_V2 = mkWV2 (k69 "merkitä") "rastilla" ; --UNCHK
lin check_on_V2 = prepV2 OP_check_V OP_on_Prep ; -- guess-p-verb
lin check_out_V = mkWV (k73A "tsekata") ; --UNCHK
lin check_out_V2 = mkWV2 (k73A "tsekata") ; --UNCHK
lin check_out_of_V2 = prepV2 (advV OP_check_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin check_over_V2 = mkWV2 (k73A "tsekata") ; --UNCHK
lin check_through_V2 = prepV2 OP_check_V OP_through_Prep ; -- guess-p-verb
lin check_up_on_V2 = mkWV2 (k73A "tsekata") ; --UNCHK
lin check_with_V2 = prepV2 OP_check_V OP_with_Prep ; -- guess-p-verb
lin checkbook_N = mkWN (compoundN "sekki" (k1 "vihko")) ; --UNCHK
lin checker_N = mkWN (compoundN "šakki" (k12 "nappula")) ; --UNCHK
lin checker_V2 = mkWV2 (k62 "kuvioida") ; --UNCHK
lin checkerbloom_N = mkWN (compoundN "jalo" (k9 "malva")) ; --UNCHK
lin checkerboard_N = mkWN (compoundN "šakki" (k9A "lauta")) ; --UNCHK
lin checkers_N = mkWN (kH1 "tammi") ; --UNCHK
lin checklist_N = mkWN (compoundN "muisti" (k9 "lista")) ; --UNCHK
lin checkmate_N = mkWN (kH1 "matti") ; --UNCHK
lin checkmate_V2 = mkWV2 (k71 "tehdä") "matti" ; --UNCHK
lin checkout_N = mkWN (k39 "varmistus") ; --UNCHK
lin checkpoint_N = mkWN (compoundN "tarkastus" (k48 "piste")) ; --UNCHK
lin checkroom_N = mkWN (compoundN "matkatavara" (k1 "säilö")) ; --UNCHK
lin checksum_N = mkWN (compoundN "tarkistus" (k10 "summa")) ; --UNCHK
lin checkup_N = mkWN (compoundN "lääkärin" (k39 "tarkastus")) ; --UNCHK
lin cheddar_N = mkWN (k5 "cheddar") ; --UNCHK
lin cheek_N = mkWN (k40 "hävyttömyys") ; --UNCHK
lin cheek_V2 = mkWV2 (k52 "puhua") "röyhkeästi" ; --UNCHK
lin cheekbone_N = mkWN (compoundN "poski" (k18 "pää")) ; --UNCHK
lin cheekpiece_N = mkWN (compoundN "poski" (k9 "hihna")) ; --UNCHK
lin cheeky_A = mkWA (k10 "tunkeileva") ; --UNCHK
lin cheep_N = mkWN (k39 "piipitys") ; --UNCHK
lin cheep_V = mkWV (k53A "sirittää") ; --UNCHK
lin cheer_N = mkWN (k40 "hilpeys") ; --UNCHK
lin cheer_V = mkV (lin VK {s = c53 "kannustaa"}) ;
lin cheer_V2 = mkWV2 (k73 "hurrata") ; --UNCHK
lin cheer_up_V = mkWV (k52A "ilahtua") ; --UNCHK
lin cheer_up_V2 = mkWV2 (k52A "ilahtua") ; --UNCHK
lin cheerer_N = mkWN (k5 "fani") ; --UNCHK
lin cheerful_A = mkWA (k15 "hilpeä") ; --UNCHK
lin cheerfulness_N = mkWN (k40 "hilpeys") ; --UNCHK
lin cheerleader_N = mkWN (k5 "cheerleader") ; --UNCHK
lin cheerless_A = mkWA (k34A "iloton") ; --UNCHK
lin cheerlessness_N = mkWN (k40 "lohduttomuus") ; --UNCHK
lin cheers_Interj = mkInterj "terveydeksi" ;
lin cheery_A = mkWA (k38 "aurinkoinen") ; --UNCHK
lin cheese_N = L.cheese_N ;
lin cheeseboard_N = mkWN (compoundN "juusto" (k33A "tarjotin")) ; --UNCHK
lin cheeseburger_N = mkWN (compoundN "juusto" (k38 "hampurilainen")) ; --UNCHK
lin cheesecake_N = mkWN (compoundN "kansikuva" (k1A "tyttö")) ; --UNCHK
lin cheesecloth_N = mkWN (k41A "juustokangas") ; --UNCHK
lin cheeselike_A = mkWA (compoundA "juusto" (k38 "mainen")) ; --UNCHK
lin cheesemonger_N = mkWN (compoundN "juusto" (k41 "kauppias")) ; --UNCHK
lin cheeseparing_A = mkWA (k9A "saita") ; --UNCHK
lin cheetah_N = mkWN (k5 "gepardi") ; --UNCHK
lin chef_N = mkWN (kH1 "kokki") ; --UNCHK
lin cheilitis_N = mkWN (compoundN "huuli" (k39 "tulehdus")) ; --UNCHK
lin cheilosis_N = mkWN (compoundN "huuli" (k10 "sierettymä")) ; --UNCHK
lin chela_N = mkWN "saksi" ; --UNCHK
lin chelate_A = mkWA (compoundA "saksi" (k38 "mainen")) ; --UNCHK
lin chelate_N = mkWN (compoundN "kelaatti" (k48 "yhdiste")) ; --UNCHK
lin chelation_N = mkWN (compoundN "kela" (k38 "toituminen")) ; --UNCHK
lin chelicera_N = mkWN (compoundN "leuka" (k1A "koukku")) ; --UNCHK
lin cheliceral_A = mkWA (compoundA "leukakoukku" (k38 "mainen")) ; --UNCHK
lin chelicerous_A = mkWA (compoundA "leuka" (k38 "koukullinen")) ; --UNCHK
lin cheliferous_A = mkWA "saksellinen" ; --UNCHK
lin chelmsford_PN = foreignPN "Chelmsford" ;
lin chelonian_A = mkWA (compoundA "kilpi" (k38 "konnamainen")) ; --UNCHK
lin chelonian_N = mkWN (k12 "matelija") "Chelonia-lahkoon" "kuuluva" ; --UNCHK
lin chelsea_PN = foreignPN "Chelsea" ;
lin cheltenham_PN = foreignPN "Cheltenham" ;
lin chelyabinsk_PN = foreignPN "Tšeljabinsk" ;
lin chemical_A = mkWA (k38 "kemiallinen") ; --UNCHK
lin chemical_N = mkN "kemikaali" ;
lin chemiluminescence_N = mkWN (compoundN "kemi" (k5 "luminesenssi")) ; --UNCHK
lin chemiluminescent_A = mkWA "kemiluminesenssi-" ; --UNCHK
lin chemise_N = mkWN (k1A "mekko") "suora" ; --UNCHK
lin chemisorption_N = mkWN (k3 "adsorptio") "kemiallinen" ; --UNCHK
lin chemisorptive_A = mkWA "kemiallisesti" "adsorboituva" ; --UNCHK
lin chemistFem_N = mkWN (k5 "kemisti") ;
lin chemistMasc_N = mkN "kemisti" ;
lin chemistry_N = mkWN (k12 "kemia") ;
lin chemoreceptive_A = mkWA "kemoreseptorin" ; --UNCHK
lin chemosis_N = mkWN "kemoosi" ; --UNCHK
lin chemosurgery_N = mkWN (k12 "kirurgia") "Mohsin" ; --UNCHK
lin chemosynthesis_N = mkWN (compoundN "kemo" (k5 "synteesi")) ; --UNCHK
lin chemotaxis_N = mkWN "kemotaksis" ; --UNCHK
lin chemotherapeutic_A = mkWA (compoundA "kemo" (k38 "terapeuttinen")) ; --UNCHK
lin chemotherapy_N = mkWN (compoundN "kemo" (k12 "terapia")) ; --UNCHK
lin chenille_N = mkWN (k8 "chenille") ; --UNCHK
lin chepstow_PN = foreignPN "Chepstow" ;
lin cheque_N = mkWN (k5A "šekki") ; --UNCHK
lin chequebook_N = mkWN (compoundN "sekki" (k1 "vihko")) ; --UNCHK
lin chequer_V2 = mkWV2 (k62 "kuvioida") ; --UNCHK
lin cherimoya_N = mkWN (k10 "annoona") ; --UNCHK
lin cherish_V2 = mkWV2 (k61 "vaalia") ; --UNCHK
lin cheroot_N = mkWN (compoundN "pikku" (k6 "sikari")) "tasapaksu" ; --UNCHK
lin cherry_A = mkWA (k10 "punertava") ; --UNCHK
lin cherry_N = mkWN (compoundN "kirsikan" (k38 "punainen")) ; --UNCHK
lin cherrystone_N = mkWN (compoundN "kauppavenus" (k14A "simpukka")) "pieni" ; --UNCHK
lin chert_N = mkWN "sertti" ; --UNCHK
lin cherty_A = mkWA "serttimäinen" ; --UNCHK
lin cherub_N = mkWN (k5 "kerubi") ; --UNCHK
lin cherubic_A = mkWA (k10 "ihana") ; --UNCHK
lin chervil_N = mkWN (k6 "kirveli") ; --UNCHK
lin chesham_PN = foreignPN "Chesham" ;
lin cheshire_PN = foreignPN "Cheshire" ;
lin chess_N = mkWN (k5A "shakki") ; --UNCHK
lin chessboard_N = mkWN (compoundN "šakki" (k9A "lauta")) ; --UNCHK
lin chessman_N = mkWN (compoundN "šakki" (k12 "nappula")) ; --UNCHK
lin chest_N = mkWN (k1 "kirstu") ; --UNCHK
lin chester_PN = foreignPN "Chester" ;
lin chesterfield_PN = foreignPN "Chesterfield" ;
lin chestnut_A = mkWA (compoundA "kastanjan" (k15 "ruskea")) ; --UNCHK
lin chestnut_N = mkWN (k41 "rautias") ; --UNCHK
lin chetrum_N = mkWN "chetrum" ; --UNCHK
lin cheval_glass_N = mkWN (compoundN "kääntö" (k5 "peili")) "iso" ; --UNCHK
lin chevron_N = mkWN (compoundN "polvi" (k28 "orsi")) ; --UNCHK
lin chevrotain_N = mkWN (compoundN "kääpiö" (k41 "kauris")) ; --UNCHK
lin chew_N = mkWN (k2 "pureskelu") ; --UNCHK
lin chew_V = mkWV (k61 "pureksia") ; --UNCHK
lin chew_V2 = mkWV2 (k61 "pureksia") ; --UNCHK
lin chew_out_V2 = mkWV2 (k73 "saarnata") ; --UNCHK
lin chew_over_V2 = mkWV2 (k61 "tuumia") ; --UNCHK
lin chew_up_V2 = mkWV2 (k73 "saarnata") ; --UNCHK
lin chewable_A = mkWA "helposti" "leikattava" ; --UNCHK
lin chewer_N = mkWN "jauhaja" ; --UNCHK
lin chewing_gum_N = mkWN (k10A "purkka") ; --UNCHK
lin chewink_N = mkWN (compoundN "loistopip" (k1 "ilo")) ; --UNCHK
lin chewy_A = mkWA (k15 "sitkeä") ; --UNCHK
lin chez_Prep = mkPrep "luona" ;
lin chi_N = mkWN (k18 "khii") ; --UNCHK
lin chianti_N = mkWN (compoundN "Chi" (k5A "anti")) ; --UNCHK
lin chiaroscuro_N = mkWN "chiaroscuro" ; --UNCHK
lin chiasma_N = mkWN (k5 "risti") ; --UNCHK
lin chiasmus_N = mkWN "kiasmi" ; --UNCHK
lin chic_A = mkWA (k5A "elegantti") ; --UNCHK
lin chic_N = mkWN (k40 "upeus") ; --UNCHK
lin chicago_PN = foreignPN "Chicago" ;
lin chicane_N = mkWN (k39 "petos") ; --UNCHK
lin chicanery_N = mkWN (k39 "petos") ; --UNCHK
lin chichester_PN = foreignPN "Chichester" ;
lin chichi_A = mkWA "hienosteleva" ; --UNCHK
lin chichi_N = mkWN (k40 "upeus") ; --UNCHK
lin chichipe_N = mkWN "Lemaireocereus" "chichipe" ; --UNCHK
lin chick_N = mkWN (k4A "nuorikko") ; --UNCHK
lin chickadee_N = mkWN (k38 "tiainen") ; --UNCHK
lin chicken_A = mkWA (k38 "pelkurimainen") ; --UNCHK
lin chicken_N = mkN "kana" ;
lin chicken_out_V = mkWV (k53 "jänistää") ; --UNCHK
lin chicken_run_N = mkWN (compoundN "ulkoilu" (k48 "alue")) "kanojen" ; --UNCHK
lin chickenfeed_N = mkWN (k39 "korvaus") "mitätön" ; --UNCHK
lin chickenpox_N = mkWN (compoundN "vesi" (k1A "rokko")) ; --UNCHK
lin chickenshit_N = mkWN (compoundN "hätä" (k48 "vale")) ; --UNCHK
lin chickeree_N = mkWN (compoundN "lännenpuna" (k10 "orava")) ; --UNCHK
lin chickpea_N = mkWN (compoundN "kahvi" (k48 "herne")) ; --UNCHK
lin chickweed_N = mkWN (k5A "härkki") ; --UNCHK
lin chicle_N = mkWN (compoundN "chicle" (k5 "kumi")) ; --UNCHK
lin chicory_N = mkWN (k6 "sikuri") ; --UNCHK
lin chide_V = mkWV (k73 "saarnata") ; --UNCHK
lin chide_V2 = mkWV2 (k73 "saarnata") ; --UNCHK
lin chiding_N = mkWN (k2 "nuhtelu") ; --UNCHK
lin chief_A = mkA "johtava" ;
lin chief_N = mkN "päällikkö" ;
lin chieftainFem_N = mkWN (k4A "päällikkö") ; --UNCHK
lin chieftainMasc_N = mkWN (k4A "päällikkö") ; --UNCHK
lin chieftaincy_N = mkWN (k40 "päällikkyys") ; --UNCHK
lin chiffon_N = mkWN (k5A "sifonki") ; --UNCHK
lin chiffonier_N = mkWN (k2 "lipasto") ; --UNCHK
lin chignon_N = mkWN (k12 "nuttura") ; --UNCHK
lin chigoe_N = mkWN (compoundN "hieta" (k1A "kirppu")) ; --UNCHK
lin chilblain_N = mkWN (compoundN "kylmän" (k1 "kyhmy")) ; --UNCHK
lin chilblained_A = mkWA "kylmänkyhmy-" ; --UNCHK
lin child's_play_N = mkWN (k5A "leikki") ; --UNCHK
lin child_N = L.child_N ;
lin childbearing_A = mkWA (k38 "hedelmällinen") ; --UNCHK
lin childbirth_N = mkWN (k39 "synnytys") ; --UNCHK
lin childcare_N = mkWN (compoundN "lasten" (k1A "hoito")) ; --UNCHK
lin childhood_N = mkWN (k40 "lapseus") ; --UNCHK
lin childish_A = mkWA (k41A "lapsekas") ; --UNCHK
lin childishness_N = mkWN (k40 "lapsellisuus") ; --UNCHK
lin childless_A = mkWA (k34A "lapseton") ; --UNCHK
lin childlessness_N = mkWN (k40 "lapsettomuus") ; --UNCHK
lin childlike_A = mkWA (compoundA "lapsen" (k38 "omainen")) ; --UNCHK
lin chile_PN = foreignPN "Chile" ;
lin chileanFem_N = mkWN "chileläinen" ; --UNCHK
lin chileanMasc_N = mkWN "chileläinen" ; --UNCHK
lin chilean_A = mkWA "chileläinen" ; --UNCHK
lin chili_N = mkWN (k5 "chili") ; --UNCHK
lin chill_N = mkWN (k40 "kylmyys") ; --UNCHK
lin chill_V = mkWV (k52A "kylmentyä") ; --UNCHK
lin chill_V2 = mkWV2 (k52A "kylmentyä") ; --UNCHK
lin chill_out_V = mkWV (k52A "rentoutua") ; --UNCHK
lin chilliness_N = mkWN (k40 "etäisyys") ; --UNCHK
lin chilly_A = mkA "viileä" ;
lin chilly_N = mkWN (compoundN "asu" (k38 "ttaminen")) "uudelleen" ; --UNCHK
lin chimaera_N = mkWN "Chimaera" ; --UNCHK
lin chime_N = mkWN (k1 "kello") ; --UNCHK
lin chime_V = mkWV (k62 "soida") ; --UNCHK
lin chime_V2 = mkWV2 (k62 "soida") ; --UNCHK
lin chime_in_V = mkWV (k52A "sekaantua") ; --UNCHK
lin chimera_N = mkWN (compoundN "kauhu" (k10 "kuva")) ; --UNCHK
lin chimeric_A = mkWA (k38 "mielikuvituksellinen") ; --UNCHK
lin chimerical_A = mkWA (k38 "mielikuvituksellinen") ; --UNCHK
lin chimney_N = mkWN (compoundN "savu" (k1A "piippu")) ; --UNCHK
lin chimneypiece_N = mkWN (compoundN "takka" (k1 "hylly")) ; --UNCHK
lin chimneypot_N = mkWN (k39 "jatkos") "savupiipun" ; --UNCHK
lin chimneystack_N = mkWN (compoundN "savupiippu" (k10 "ryhmä")) ; --UNCHK
lin chimney_sweep_N = mkWN (k10 "nuohooja") ; --UNCHK
lin chimneysweeper_N = mkWN (k10 "nuohooja") ; --UNCHK
lin chimp_N = mkWN (k5 "simpanssi") ; --UNCHK
lin chimpanzee_N = mkWN (k5 "simpanssi") ; --UNCHK
lin chin_N = mkWN (k9A "leuka") ; --UNCHK
lin chin_strap_N = mkWN (compoundN "leuka" (k9 "hihna")) ; --UNCHK
lin chin_wagging_N = mkWN (k39 "pälpätys") ; --UNCHK
lin china_N = mkWN (k6 "posliini") ; --UNCHK
lin china_PN = mkPN "Kiina" ;
lin china_closet_N = mkWN (compoundN "astia" (k5A "kaappi")) ; --UNCHK
lin chinaberry_N = mkWN "Melia" "azedarach" ; --UNCHK
lin chinaware_N = mkWN (k6 "posliini") ; --UNCHK
lin chincapin_N = mkWN (compoundN "kääpiö" (k12 "kastanja")) ; --UNCHK
lin chincherinchee_N = mkWN (compoundN "afrikan" (k9 "lilja")) ; --UNCHK
lin chinchilla_N = mkWN (k9 "sinsilla") ; --UNCHK
lin chine_N = mkWN (compoundN "selkä" (k9A "ranka")) ; --UNCHK
lin chineseFem_N = mkN "kiinalainen" | mkN "kiinatar" ;
lin chineseMasc_N = mkN "kiinalainen" ;
lin chinese_A = mkWA (k38 "kiinalainen") ;
lin chink_N = mkWN (k39 "kilahdus") ; --UNCHK
lin chink_V = mkWV (k53A "aiheuttaa") "halkeama" ; --UNCHK
lin chink_V2 = mkWV2 (k53A "aiheuttaa") "halkeama" ; --UNCHK
lin chinless_A = mkWA "leuaton" ; --UNCHK
lin chino_N = mkWN (k41A "tvillikangas") "vahva" ; --UNCHK
lin chinoiserie_N = mkWN "chinoiserie" ; --UNCHK
lin chinook_N = mkWN (compoundN "kuningas" (k23 "lohi")) ; --UNCHK
lin chintz_N = mkWN (k5 "sintsi") ; --UNCHK
lin chip_N = mkN "hippu" ;
lin chip_V = mkWV (k74 "loveta") ; --UNCHK
lin chip_V2 = mkWV2 (k74 "loveta") ; --UNCHK
lin chip_away_V = mkWV (k56 "kalvaa") ; --UNCHK
lin chip_away_at_V2 = mkWV2 (k56 "kalvaa") ; --UNCHK
lin chipboard_N = mkWN (k50 "kovalevy") ; --UNCHK
lin chipmunk_N = mkWN (compoundN "maa" (k10 "orava")) ; --UNCHK
lin chipolata_N = mkWN (compoundN "chipo" (k9A "lata")) ; --UNCHK
lin chipotle_N = mkWN "chipotle" ; --UNCHK
lin chippendale_N = mkWN (k8 "Chippendale") "Thomas" ; --UNCHK
lin chippenham_PN = foreignPN "Chippenham" ;
lin chipper_A = mkWA (k38 "herttainen") ; --UNCHK
lin chiralgia_N = mkWN (compoundN "käsi" (k1A "kipu")) ; --UNCHK
lin chiromantic_A = mkWA "kädestäennustamiseen" "liittyvä" ; --UNCHK
lin chiropodist_N = mkWN (compoundN "jalka" (k10 "hoitaja")) ; --UNCHK
lin chiropody_N = mkWN (compoundN "jalkojen" (k1A "hoito")) ; --UNCHK
lin chiropractic_N = mkWN (k9A "kiropraktiikka") ; --UNCHK
lin chiropractor_N = mkWN (k4A "kiropraktikko") ; --UNCHK
lin chirp_N = mkWN (k39 "siritys") ; --UNCHK
lin chirp_V = mkWV (k53A "sirittää") ; --UNCHK
lin chirp_V2 = mkWV2 (k53A "sirittää") ; --UNCHK
lin chirpiness_N = mkWN (k40 "hilpeys") ; --UNCHK
lin chirpy_A = mkWA (compoundA "viserte" (k10 "levä")) ; --UNCHK
lin chirrup_N = mkWN (k39 "sirkutus") ; --UNCHK
lin chirrup_V = mkWV (k53A "sirittää") ; --UNCHK
lin chirrup_V2 = mkWV2 (k53A "sirittää") ; --UNCHK
lin chisel_N = mkWN (k9A "taltta") ; --UNCHK
lin chisel_V2 = mkWV2 (k54A "kaivertaa") ; --UNCHK
lin chiseled_A = mkWA (compoundA "selkeä" (k38 "piirteinen")) ; --UNCHK
lin chiseller_N = mkWN (k6 "petturi") ; --UNCHK
lin chit_N = mkWN (k5A "piikki") ; --UNCHK
lin chit_chat_N = mkWN (k39 "pälpätys") ; --UNCHK
lin chitchat_N = mkWN (k39 "pälpätys") ; --UNCHK
lin chitin_N = mkWN (k6 "kitiini") ; --UNCHK
lin chitinous_A = mkWA (compoundA "kitiini" (k38 "mäinen")) ; --UNCHK
lin chiton_N = mkWN (compoundN "nivel" (k2 "kotilo")) ; --UNCHK
lin chivalric_A = mkWA (k38 "ritarillinen") ; --UNCHK
lin chivalrous_A = mkWA (k41 "kohtelias") ; --UNCHK
lin chivalry_N = mkWN (k40 "huomaavaisuus") ; --UNCHK
lin chive_N = mkWN (k9A "ruoholaukka") ; --UNCHK
lin chives_N = mkWN (compoundN "ruoho" (k6 "sipuli")) ; --UNCHK
lin chivvy_V2 = mkWV2 (k53A "hätyyttää") ; --UNCHK
lin chlamydeous_A = mkWA (compoundA "kehä" (k38 "mäinen")) ; --UNCHK
lin chlamydia_N = mkWN (k12 "klamydia") ; --UNCHK
lin chlamydial_A = mkWA "klamydian" ; --UNCHK
lin chlamydospore_N = mkWN (compoundN "kätkö" (k3 "itiö")) ; --UNCHK
lin chlamys_N = mkWN (k10 "stoola") ; --UNCHK
lin chloasma_N = mkWN (compoundN "maksa" (k10A "läikkä")) ; --UNCHK
lin chlorambucil_N = mkWN (k5 "klorambusiili") ; --UNCHK
lin chloramine_N = mkWN "kloramiini-T" ; --UNCHK
lin chloramphenicol_N = mkWN "Chloromycetin" ; --UNCHK
lin chlorate_N = mkWN "kloraatti" ; --UNCHK
lin chlordiazepoxide_N = mkWN (compoundN "klooridiatsep" (k5 "oksidi")) ; --UNCHK
lin chlorella_N = mkWN "Chlorella" ; --UNCHK
lin chlorenchyma_N = mkWN "fotosynteettinen" "parenkyymi" ; --UNCHK
lin chlorhexidine_N = mkWN "klooriheksidiini" ; --UNCHK
lin chloride_N = mkWN "kloridi" ; --UNCHK
lin chlorinate_V2 = mkWV2 (k73 "kloorata") ; --UNCHK
lin chlorination_N = mkWN (k39 "klooraus") ; --UNCHK
lin chlorine_N = mkWN (k5 "kloori") ; --UNCHK
lin chlorinity_N = mkWN (compoundN "kloridi" (k40 "pitoisuus")) ; --UNCHK
lin chlorite_N = mkWN (compoundN "klo" (k5A "riitti")) ; --UNCHK
lin chloroacetophenone_N = mkWN (compoundN "CN-" (k1 "kaasu")) ; --UNCHK
lin chlorobenzene_N = mkWN "klooribentseeni" ; --UNCHK
lin chlorobenzylidenemalononitrile_N = mkWN (compoundN "CS-" (k1 "kaasu")) ; --UNCHK
lin chlorofluorocarbon_N = mkWN (k5 "freoni") ; --UNCHK
lin chloroform_N = mkWN (compoundN "trikloro" (k5 "metaani")) ; --UNCHK
lin chlorophyll_N = mkWN (k5 "klorofylli") ; --UNCHK
lin chlorophyllose_A = mkWA "klorofylli-" ; --UNCHK
lin chloropicrin_N = mkWN (compoundN "trikloorinitro" (k5 "metaani")) ; --UNCHK
lin chloroplast_N = mkWN (compoundN "viher" (k38 "hiukkanen")) ; --UNCHK
lin chloroprene_N = mkWN "kloropreeni" ; --UNCHK
lin chloroquine_N = mkWN (compoundN "kloroki" (k26 "niini")) ; --UNCHK
lin chlorosis_N = mkWN (compoundN "kalvetus" (k5A "tauti")) ; --UNCHK
lin chlorothiazide_N = mkWN "Diuril" ; --UNCHK
lin chlorotic_A = mkWA (k38 "aneeminen") ; --UNCHK
lin chlorpromazine_N = mkWN "Thorazine" ; --UNCHK
lin chlorpyrifos_N = mkWN (compoundN "klorpyrif" (k5 "ossi")) ; --UNCHK
lin chlortetracycline_N = mkWN (compoundN "kloori" (k5 "tetrasykliini")) ; --UNCHK
lin chlorthalidone_N = mkWN "Thalidone" ; --UNCHK
lin choanocyte_N = mkWN (compoundN "kaulussiima" (k1 "solu")) ; --UNCHK
lin choc_N = mkWN (k17 "suklaa") ; --UNCHK
lin chock_Adv = mkWAdv (k99 "kukkuroillaan") ; --UNCHK
lin chock_N = mkWN (k9 "kiila") ; --UNCHK
lin chock_V2 = mkWV2 (k53A "pönkittää") ; --UNCHK
lin chocolate_N = mkN "suklaa" ;
lin choice_A = mkWA (k38 "erinomainen") ; --UNCHK
lin choice_N = mkN "valinta" ;
lin choir_N = mkN "kuoro" ; ---ARB mkWN (kH1 "kuori") ; --UNCHK
lin choir_school_N = mkWN (compoundN "katedraali" (k1 "koulu")) ; --UNCHK
lin choirboy_N = mkWN (compoundN "kuori" (k10A "poika")) ; --UNCHK
lin choirmaster_N = mkWN (k6 "kanttori") ; --UNCHK
lin choke_N = mkWN (compoundN "kuristus" (k6 "venttiili")) ; --UNCHK
lin choke_V = mkWV (k52A "tukahtua") ; --UNCHK
lin choke_V2 = mkWV2 (k52A "tukahtua") ; --UNCHK
lin choke_off_V2 = mkWV2 (k53A "laannuttaa") ; --UNCHK
lin choke_up_V = mkWV (k61A "tukkia") ; --UNCHK
lin choke_up_V2 = mkWV2 (k61A "tukkia") ; --UNCHK
lin chokecherry_N = mkWN (compoundN "virginian" (k25 "tuomi")) ; --UNCHK
lin choke_damp_N = mkWN (compoundN "kaivos" (k1 "kaasu")) ; --UNCHK
lin chokehold_N = mkWN (compoundN "kuristus" (k48A "ote")) ; --UNCHK
lin chokepoint_N = mkWN (compoundN "pullon" (k9 "kaula")) ; --UNCHK
lin choker_N = mkWN (k39 "kaulus") "korkea" ; --UNCHK
lin chokey_N = mkWN (k10 "tyrmä") ; --UNCHK
lin choking_N = mkWN (compoundN "kuri" (k38 "staminen")) ; --UNCHK
lin choky_A = mkWA "kuristava" ; --UNCHK
lin choky_N = mkWN (k10 "tyrmä") ; --UNCHK
lin cholangiography_N = mkWN (compoundN "kol" (k12 "angiografia")) ; --UNCHK
lin cholangitis_N = mkWN (compoundN "sappitie" (k39 "tulehdus")) ; --UNCHK
lin cholecystectomy_N = mkWN (k1 "poisto") "sappirakon" ; --UNCHK
lin cholecystitis_N = mkWN (compoundN "kole" (k5A "kystiitti")) ; --UNCHK
lin cholecystokinin_N = mkWN (compoundN "kolekystoki" (k26 "niini")) ; --UNCHK
lin cholelithiasis_N = mkWN (compoundN "sappikivi" (k5A "tauti")) ; --UNCHK
lin cholelithotomy_N = mkWN (k1 "poisto") "sappikiven" ; --UNCHK
lin choler_N = mkWN (k7A "sappi") ; --UNCHK
lin cholera_N = mkWN (k12 "kolera") ; --UNCHK
lin choleraic_A = mkWA "koleran" ; --UNCHK
lin choleric_A = mkWA (k14A "ärhäkkä") ; --UNCHK
lin cholesterol_N = mkWN (k5 "kolesteroli") ; --UNCHK
lin choline_N = mkWN "koliini" ; --UNCHK
lin cholinergic_A = mkWA "kolinerginen" ; --UNCHK
lin cholinesterase_N = mkWN (compoundN "koliiniester" (k5 "aasi")) ; --UNCHK
lin cholla_N = mkWN "Opuntia" "cholla" ; --UNCHK
lin chomping_N = mkWN (k39 "rouskutus") ; --UNCHK
lin chon_N = mkWN "chon" ; --UNCHK
lin chondrin_N = mkWN "kondriini" ; --UNCHK
lin chondrite_N = mkWN (compoundN "kond" (k5A "riitti")) ; --UNCHK
lin chondritic_A = mkWA (k38 "rakeinen") ; --UNCHK
lin chondroma_N = mkWN (compoundN "rusto" (k33 "kasvain")) ; --UNCHK
lin chondrosarcoma_N = mkWN (compoundN "kondro" (k10 "sarkooma")) ; --UNCHK
lin chondrule_N = mkWN "kondri" ; --UNCHK
lin choose_V2 = mkV2 "valita" ;
lin choose_VV = mkVV "päättää" ;
lin choose_up_V = mkWV (k69 "valita") "joukkueet" ; --UNCHK
lin choose_up_V2 = mkWV2 (k69 "valita") "joukkueet" ; --UNCHK
lin choosey_A = mkWA (k6 "ronkeli") ; --UNCHK
lin choosy_A = mkWA (k6 "ronkeli") ; --UNCHK
lin chop_V = mkWV (k58 "iskeä") ; --UNCHK
lin chop_V2 = mkWV2 (k58 "iskeä") ; --UNCHK
lin chop_down_V2 = mkWV2 (k57A "kaataa") ; --UNCHK
lin chop_off_V = mkWV (k52 "katkoa") ; --UNCHK
lin chop_suey_N = mkWN "chop" "suey" ; --UNCHK
lin chop_up_V2 = mkWV2 (k52A "pilkkoa") ; --UNCHK
lin chopine_N = mkWN (k10A "kenkä") "korokepohjainen" ; --UNCHK
lin choppiness_N = mkWN (k24 "meri") "myrskyinen" ; --UNCHK
lin choppy_A = mkWA "vellova" ; --UNCHK
lin chopstick_N = mkWN (k1A "puikko") ; --UNCHK
lin choragic_A = mkWA "kuoronjohtajan" ; --UNCHK
lin choragus_N = mkWN (compoundN "kuoron" (k10 "johtaja")) ; --UNCHK
lin choral_A = mkWA "kuorolaulu-" ; --UNCHK
lin chorale_N = mkWN (k5 "koraali") ; --UNCHK
lin chord_N = mkWN (k1A "sointu") ; --UNCHK
lin chordal_A = mkWA (k41A "soinnukas") ; --UNCHK
lin chordamesoderm_N = mkWN (compoundN "selkä" (k48A "jänne")) ; --UNCHK
lin chordate_N = mkWN (compoundN "selkä" (k38 "jänteinen")) ; --UNCHK
lin chorditis_N = mkWN (k39 "tulehdus") "äänijänteiden" ; --UNCHK
lin chordophone_N = mkWN "kordofoni" ; --UNCHK
lin chore_N = mkWN (k25 "toimi") ;
lin chorea_N = mkWN (compoundN "tanssi" (k5A "tauti")) ; --UNCHK
lin choreographer_N = mkWN (k5 "koreografi") ; --UNCHK
lin choreographic_A = mkWA (k38 "koreografinen") ; --UNCHK
lin choreography_N = mkWN (k12 "koreografia") ; --UNCHK
lin choric_A = mkWA "kuorolausunta-" ; --UNCHK
lin chorioallantois_N = mkWN (k1 "kalvo") "korioallantoinen" ; --UNCHK
lin choriomeningitis_N = mkWN "koriomeningiitti" ; --UNCHK
lin chorion_N = mkWN (compoundN "suoni" (k1 "kalvo")) "sikiön" ; --UNCHK
lin chorionic_A = mkWA "korionin" ; --UNCHK
lin chorister_N = mkWN (k38 "kuorolainen") ; --UNCHK
lin chorizo_N = mkWN "chorizo" ; --UNCHK
lin chorley_PN = foreignPN "Chorley" ;
lin choroid_N = mkWN (compoundN "suoni" (k1 "kalvo")) ; --UNCHK
lin chortle_N = mkWN (k39 "hihitys") ; --UNCHK
lin chortle_V = mkWV (k67A "myhähdellä") ; --UNCHK
lin chorus_N = mkN "kuoro" ; ---ARB --mkWN (compoundN "kerto" (k48A "säe")) ;
lin chorus_V2 = mkWV2 (k52 "lausua") "kuorossa" ; --UNCHK
lin chorus_girl_N = mkWN (compoundN "tanssi" (k1A "tyttö")) ; --UNCHK
lin chosen_A = variants {} ; --
lin chough_N = mkWN (compoundN "alppi" (k39 "varis")) ; --UNCHK
lin chow_N = mkWN "kiinanpystykorva" ; --UNCHK
lin chowchow_N = mkWN (compoundN "hedelmä" (k1 "hillo")) "kiinalainen" ; --UNCHK
lin chowder_N = mkWN (compoundN "kala" (k1A "keitto")) "suurustettu" ; --UNCHK
lin chrestomathy_N = mkWN "krestomatia" ; --UNCHK
lin chrism_N = mkWN (k6 "mirhami") ; --UNCHK
lin christchurch_PN = foreignPN "Christchurch" ;
lin christella_N = mkWN "Christella" ; --UNCHK
lin christen_V2 = mkWV2 (k61 "ristiä") ; --UNCHK
lin christendom_N = mkWN (k40 "kristillisyys") ; --UNCHK
lin christening_N = mkWN (k48 "kaste") ; --UNCHK
lin christian_A = mkWA (k1A "kristitty") ;
lin christian_N = mkWN (k1A "kristitty") ; --UNCHK
lin christianity_N = mkWN (k1 "usko") "kristillinen" ; --UNCHK
lin christianly_A = mkWA (k38 "kristillinen") ; --UNCHK
lin christless_A = mkWA (compoundA "ei-" (k1A "kristitty")) ; --UNCHK
lin christlike_A = mkWA (k38 "kaltainen") "Kristuksen" ; --UNCHK
lin christmas_N = mkWN (k1 "joulu") ; --UNCHK
lin christmas_PN = foreignPN "Christmas" ;
lin christmas_box_N = mkWN (compoundN "joulu" (k9 "raha")) ; --UNCHK
lin christmas_tree_N = mkWN (k24 "joulukuusi") ; --UNCHK
lin christmastide_N = mkWN (k9A "joulunaika") ; --UNCHK
lin christmastime_N = mkWN (k9A "joulunaika") ; --UNCHK
lin christopher_PN = foreignPN "Christopher" ;
lin chromate_N = mkWN "kromaatti" ; --UNCHK
lin chromatic_A = mkWA "väri-" ; --UNCHK
lin chromatid_N = mkWN "kromatidi" ; --UNCHK
lin chromatin_N = mkWN "kromatiini" ; --UNCHK
lin chromatinic_A = mkWA "kromatiininen" ; --UNCHK
lin chromatogram_N = mkWN "kromatogrammi" ; --UNCHK
lin chromatographic_A = mkWA "kromatografian" ; --UNCHK
lin chromatography_N = mkWN "kromatografia" ; --UNCHK
lin chrome_N = mkWN (k5 "kromi") ; --UNCHK
lin chromesthesia_N = mkWN "chromaesthesia" ; --UNCHK
lin chromite_N = mkWN "kromiitti" ; --UNCHK
lin chromium_N = mkWN (k5 "kromi") ; --UNCHK
lin chromoblastomycosis_N = mkWN "kromoblastomykoosi" ; --UNCHK
lin chromogen_N = mkWN (compoundN "kromo" (k5 "geeni")) ; --UNCHK
lin chromolithography_N = mkWN (compoundN "väri" (k12 "litografia")) ; --UNCHK
lin chromophore_N = mkWN (compoundN "kromof" (k48 "ori")) ; --UNCHK
lin chromoplast_N = mkWN (compoundN "kromop" (k5 "lasti")) ; --UNCHK
lin chromosomal_A = mkWA "kromosomin" ; --UNCHK
lin chromosome_N = mkWN (k5 "kromosomi") ; --UNCHK
lin chromosphere_N = mkWN (compoundN "kromosf" (k26 "ääri")) ; --UNCHK
lin chronic_A = mkWA (k38 "krooninen") ; --UNCHK
lin chronicle_N = mkWN (k39 "selostus") ; --UNCHK
lin chronicle_V2 = mkWV2 (k69 "merkitä") "aikakirjoihin" ; --UNCHK
lin chronicler_N = mkWN (k12 "kronikoitsija") ; --UNCHK
lin chronograph_N = mkWN "kronografi" ; --UNCHK
lin chronological_A = mkWA (k38 "kronologinen") ; --UNCHK
lin chronology_N = mkWN (k12 "kronologia") ; --UNCHK
lin chronometer_N = mkWN (k5 "kronometri") ; --UNCHK
lin chronoscope_N = mkWN (compoundN "kronosko" (k5A "oppi")) ; --UNCHK
lin chrysalis_N = mkWN (k2 "kotelo") ; --UNCHK
lin chrysoberyl_N = mkWN (compoundN "kryso" (k5 "berylli")) ; --UNCHK
lin chrysolite_N = mkWN "krysoliitti" ; --UNCHK
lin chrysoprase_N = mkWN (compoundN "krysopr" (k5 "aasi")) ; --UNCHK
lin chrysotherapy_N = mkWN (compoundN "kulta" (k1A "hoito")) ; --UNCHK
lin chrysotile_N = mkWN (compoundN "kryso" (k23 "tiili")) ; --UNCHK
lin chthonian_A = mkWA (compoundA "maan" (k38 "alainen")) ; --UNCHK
lin chub_N = mkWN (kH1 "turpa") ; --UNCHK
lin chubbiness_N = mkWN (k40 "pyylevyys") ; --UNCHK
lin chubby_A = mkWA (k10 "pulska") ; --UNCHK
lin chuck_N = mkWN (compoundN "leuka" (k14A "istukka")) ; --UNCHK
lin chuck_V2 = mkWV2 (k53A "heittää") "laattaa" ; --UNCHK
lin chuck_out_V2 = mkWV2 (k53 "poistaa") ; --UNCHK
lin chuckle_N = mkWN (k39 "hihitys") ; --UNCHK
lin chuckle_V = mkWV (k67A "myhähdellä") ; --UNCHK
lin chuckle_VS = mkWVS (k67A "myhähdellä") ; --UNCHK
lin chufa_N = mkWN (compoundN "maa" (k6 "manteli")) ; --UNCHK
lin chuffed_A = mkWA (k99 "mielissään") ; --UNCHK
lin chug_N = mkWN (k39 "sätkätys") ; --UNCHK
lin chug_V = mkWV (k53A "puksuttaa") ; --UNCHK
lin chukka_N = mkWN (compoundN "chukka-" (k48 "jalkine")) ; --UNCHK
lin chukker_N = mkWN (k10 "erä") "poolopelin" ; --UNCHK
lin chum_N = mkWN (compoundN "koira" (k23 "lohi")) ; --UNCHK
lin chumminess_N = mkWN (k40 "ystävyys") ; --UNCHK
lin chump_N = mkWN (k6 "tomppeli") ; --UNCHK
lin chunk_N = mkN "palanen" ;
lin chunky_A = mkWA (k38 "paakkuinen") ; --UNCHK
lin chunnel_N = mkWN (k6 "tunneli") "Kanaalin" ; --UNCHK
lin church_N = L.church_N ;
lin churchgoer_N = mkWN (k32 "jäsen") "kirkon" ; --UNCHK
lin churchgoing_A = mkWA (k10 "käyvä") "kirkossa" ; --UNCHK
lin churchly_A = mkWA (k38 "kirkollinen") ; --UNCHK
lin churchman_N = mkWN (k5A "pappi") ; --UNCHK
lin churchwarden_N = mkWN (compoundN "kirkon" (k10A "isäntä")) ; --UNCHK
lin churchyard_N = mkWN (compoundN "hautaus" (k18 "maa")) ; --UNCHK
lin churl_N = mkWN (k12 "kiukuttelija") ; --UNCHK
lin churlish_A = mkWA (k15 "äreä") ; --UNCHK
lin churn_N = mkWN (k1 "kirnu") ; --UNCHK
lin churn_V = mkWV (k54A "hämmentää") ; --UNCHK
lin churn_V2 = mkWV2 (k54A "hämmentää") ; --UNCHK
lin churn_out_V2 = mkWV2 (k53A "syytää") "ulos" ; --UNCHK
lin chute_N = mkWN (k10 "kuurna") ; --UNCHK
lin chutney_N = mkWN "Indian" "relish" ; --UNCHK
lin chutzpa_N = mkWN "hutzpah" ; --UNCHK
lin chutzpanik_N = mkWN (k6 "öykkäri") ; --UNCHK
lin chylaceous_A = mkWA "maitiaisnesteen" ; --UNCHK
lin chyle_N = mkWN (compoundN "maitiais" (k48 "neste")) ; --UNCHK
lin chyliferous_A = mkWA "maitiaisnestettä" "kuljettava" ; --UNCHK
lin chylific_A = mkWA (k10 "tuottava") "maitiaisnestettä" ; --UNCHK
lin chylomicron_N = mkWN (compoundN "kylo" (k5 "mikroni")) ; --UNCHK
lin chyme_N = mkWN (compoundN "ruoka" (k10 "sula")) ; --UNCHK
lin cia_N = mkWN (compoundN "tiedustelu" (k2 "palvelu")) "Yhdysvaltain" ; --UNCHK
lin cicatrice_N = mkWN (k7A "arpi") ; --UNCHK
lin cicatrix_N = mkWN (k7A "arpi") ; --UNCHK
lin cicero_N = mkWN (compoundN "Cic" (k1 "ero")) "Marcus" "Tullius" ; --UNCHK
lin cicerone_N = mkWN (compoundN "matkailu" (k41A "opas")) ; --UNCHK
lin cichlid_N = mkWN (compoundN "kirjo" (k32 "ahven")) ; --UNCHK
lin cid_N = mkWN "CID" ; --UNCHK
lin cider_N = mkWN (k6 "siideri") ; --UNCHK
lin ciderpress_N = mkWN "omenapuristamo" ; --UNCHK
lin cigar_N = mkWN (k6 "sikari") ; --UNCHK
lin cigarette_N = mkN "savuke" ;
lin cigarette_case_N = mkWN (compoundN "savuke" (k2 "kotelo")) ; --UNCHK
lin cigarette_holder_N = mkWN (k48A "imuke") ; --UNCHK
lin cigarette_paper_N = mkWN (compoundN "savuke" (k6 "paperi")) ; --UNCHK
lin cigarillo_N = mkWN (compoundN "pikku" (k6 "sikari")) ; --UNCHK
lin ciliate_N = mkWN (compoundN "alku" (k33 "eläin")) "värekarvallinen" ; --UNCHK
lin cilium_N = mkWN (compoundN "väre" (k9 "karva")) ; --UNCHK
lin cinch_N = mkWN "cinch" ; --UNCHK
lin cinch_V2 = mkWV2 (k69 "hallita") ; --UNCHK
lin cinchona_N = mkWN (compoundN "kiina" (k18 "puu")) ; --UNCHK
lin cinchonine_N = mkWN (compoundN "kinko" (k26 "niini")) ; --UNCHK
lin cincinnati_PN = foreignPN "Cincinnati" ;
lin cincture_N = mkWN (k19 "vyö") ; --UNCHK
lin cinder_N = mkWN (k10 "kuona") ; --UNCHK
lin cinder_track_N = mkWN (compoundN "hiilimurska" (k9A "rata")) ; --UNCHK
lin cinderella_N = mkWN (compoundN "Tuh" (k1 "kimo")) ; --UNCHK
lin cinderford_PN = foreignPN "Cinderford" ;
lin cine_projector_N = mkWN (compoundN "filmi" (k6 "projektori")) ; --UNCHK
lin cinema_N = mkWN (compoundN "elokuva" (k6 "teatteri")) ;
lin cinematic_A = mkWA "filmi-" ; --UNCHK
lin cinematography_N = mkWN (k39 "kuvaus") ; --UNCHK
lin cineraria_N = mkWN (k12 "sineraria") ; --UNCHK
lin cinerary_A = mkWA "tuhka-" ; --UNCHK
lin cingulum_N = mkWN "cingulum" ; --UNCHK
lin cinnabar_N = mkWN "Callimorpha" "jacobeae" ; --UNCHK
lin cinnamon_N = mkWN (k6 "kaneli") ; --UNCHK
lin cinquefoil_N = mkWN (k48A "ruusuke") ; --UNCHK
lin cipher_N = mkWN (compoundN "salakirjoitus" (k5 "viesti")) ; --UNCHK
lin cipher_V = mkWV (k58 "laskea") ; --UNCHK
lin cipher_V2 = mkWV2 (k58 "laskea") ; --UNCHK
lin ciprofloxacin_N = mkWN "Cipro" ; --UNCHK
lin circa_Prep = mkPrep "noin" nominative ;
lin circadian_A = mkWA "vuorokausi-" ; --UNCHK
lin circle_N = mkWN (k39 "kierros") ; --UNCHK
lin circle_V = mkWV (k62 "ympyröidä") ; --UNCHK
lin circle_V2 = mkWV2 (k62 "ympyröidä") ; --UNCHK
lin circlet_N = mkWN (k9A "otsaripa") ; --UNCHK
lin circuit_N = mkWN (k39 "kierros") ; --f57
lin circuitous_A = mkWA (k10 "poikkeava") ; --UNCHK
lin circuitry_N = mkWN (k5 "piiri") ; --UNCHK
lin circular_A = mkWA (k15 "pyöreä") ; --UNCHK
lin circular_N = mkWN (k38 "lehtinen") ; --UNCHK
lin circularity_N = mkWN (compoundN "ympyrän" (k40 "muotoisuus")) ; --UNCHK
lin circularization_N = mkWN (compoundN "joukko" (k39 "postitus")) ; --UNCHK
lin circularize_V2 = mkWV2 (k53 "pyöristää") ; --UNCHK
lin circulate_V = mkV "kiertää" ;
lin circulate_V2 = mkV2 "levittää" partitive ; --mkWV2 (k53A "kierrättää") ;
lin circulation_N = mkWN (k2 "jakelu") ;
lin circulative_A = mkWA "kierron" ; --UNCHK
lin circulatory_A = mkWA "verenkierto-" ; --UNCHK
lin circumcise_V2 = mkWV2 (compoundV "ympäri" (k73A "leikata")) ; --UNCHK
lin circumcision_N = mkWN (compoundN "ympäri" (k39 "leikkaus")) ; --UNCHK
lin circumduction_N = mkWN "sirkumduktio" ; --UNCHK
lin circumference_N = mkWN (k10 "kehä") ; --UNCHK
lin circumferential_A = mkWA "ympärys-" ; --UNCHK
lin circumflex_N = mkWN (k5 "sirkumfleksi") ; --UNCHK
lin circumlocution_N = mkWN (k39 "ilmaus") "epäsuora" ; --UNCHK
lin circumlocutious_A = mkWA (k10 "kiertelevä") ; --UNCHK
lin circumnavigate_V2 = mkWV2 (k54A "kiertää") ; --UNCHK
lin circumnavigation_N = mkWN (compoundN "ympäri" (k39 "purjehdus")) ; --UNCHK
lin circumpolar_A = mkWA (k99 "ympärillä") "navan" ; --UNCHK
lin circumscribe_V2 = mkWV2 (k53A "rajoittaa") ; --UNCHK
lin circumscription_N = mkWN "rajoittaminen" ; --UNCHK
lin circumspect_A = mkWA (k38 "varovainen") ; --UNCHK
lin circumspection_N = mkWN (k40 "tarkkaavaisuus") ; --UNCHK
lin circumstance_N = mkN "olosuhde" ;
lin circumstances_N = mkWN (k10 "asema") "taloudellinen" ; --UNCHK
lin circumstantial_A = mkWA (compoundA "sei" (k38 "kkaperäinen")) ; --UNCHK
lin circumvent_V2 = mkWV2 (k67A "luikerrella") ; --UNCHK
lin circumvention_N = mkWN "kiertäminen" ; --UNCHK
lin circumvolution_N = mkWN "pyöriminen" ; --UNCHK
lin circus_N = mkWN (k39 "sirkus") ; --UNCHK
lin cirencester_PN = foreignPN "Cirencester" ;
lin cirque_N = mkWN (compoundN "kattila" (k1 "laakso")) ; --UNCHK
lin cirrhosis_N = mkWN (k5 "kirroosi") ; --UNCHK
lin cirrocumulus_N = mkWN (compoundN "pallero" (k7 "pilvi")) ; --UNCHK
lin cirrostratus_N = mkWN (compoundN "harso" (k7 "pilvi")) ; --UNCHK
lin cirrus_N = mkWN (k9 "siima") ; --UNCHK
lin cisalpine_A = mkWA (compoundA "etelä" (k38 "puolinen")) "Alppien" ; --UNCHK
lin cisco_N = mkWN (k9A "siika") ; --UNCHK
lin cissy_A = mkWA (k38 "feminiininen") ; --UNCHK
lin cistern_N = mkWN (compoundN "vesi" (k3 "säiliö")) ; --UNCHK
lin cisterna_N = mkWN (k3 "säiliö") ; --UNCHK
lin citadel_N = mkWN (k39 "linnoitus") ; --UNCHK
lin citation_N = mkWN "Citation" ; --UNCHK
lin cite_V2 = mkV2 "lainata" partitive ;
lin citified_A = mkWA (k38 "kaupunkilainen") ; --UNCHK
lin citizenFem_N = mkN "kansalainen" ;
lin citizenMasc_N = mkN "kansalainen" ;
lin citizenry_N = mkWN (k2 "väestö") ; --UNCHK
lin citizenship_N = mkWN (compoundN "kansalais" (k7A "henki")) ; --UNCHK
lin citrate_N = mkWN "sitraatti" ; --UNCHK
lin citric_A = mkWA "sitruunahappo-" ; --UNCHK
lin citrine_N = mkWN "sitriini" ; --UNCHK
lin citron_N = mkWN (compoundN "sukaatti" (k13 "sitruuna")) ; --UNCHK
lin citronwood_N = mkWN (compoundN "sanda" (k5A "rakki")) ; --UNCHK
lin citrous_A = mkWA "sitrus-" ; --UNCHK
lin citrulline_N = mkWN "sitrulliini" ; --UNCHK
lin citrus_N = mkWN (compoundN "sitrus" (k10 "hedelmä")) ; --UNCHK
lin cittern_N = mkWN (k9 "sitra") ; --UNCHK
lin city_N = L.city_N ;
lin cityscape_N = mkWN (compoundN "kaupunki" (k10 "maisema")) ; --UNCHK
lin citywide_A = mkWA (k38 "laajuinen") "kaupungin" ; --UNCHK
lin civet_N = mkWN (compoundN "sivetti" (k33 "eläin")) ; --UNCHK
lin civet_cat_N = mkWN (compoundN "sivetti" (k33 "eläin")) ; --UNCHK
lin civic_A = mkWA "kansalais-" ; --UNCHK
lin civics_N = mkWN (compoundN "yhteiskunta" (k5A "oppi")) ; --UNCHK
lin civil_A = mkA "siviili" ; ---
lin civilian_A = mkWA "siviili-" ; --UNCHK
lin civilian_N = mkWN (k6 "siviili") ; --UNCHK
lin civility_N = mkWN (k40 "kohteliaisuus") ; --UNCHK
lin civilization_N = mkWN (k40 "sivistyneisyys") ; --UNCHK
lin civilize_V2 = mkWV2 (k53 "sivistää") ; --UNCHK
lin clabber_N = mkWN (k10 "piimä") ; --UNCHK
lin clack_N = mkWN (compoundN "läppä" (k6 "venttiili")) ; --UNCHK
lin clack_V = mkWV (k53A "pälättää") ; --UNCHK
lin clad_V2 = mkV2 "päällystää" ;
lin clade_N = mkWN "kladi" ; --UNCHK
lin cladode_N = mkWN (compoundN "laaka" (k28 "varsi")) ; --UNCHK
lin cladogram_N = mkWN "kladogrammi" ; --UNCHK
lin claim_N = mkN "vaatimus" ;
lin claim_V = mkV (mkV "hakea") "korvausta" ; --mkWV (k61 "periä") ;
lin claim_V2 = mkV2 "vaatia" ;
lin claim_VS = mkVS (mkV "väittää") ;
lin claimant_N = mkWN (k12 "vaatija") ;
lin clairvoyance_N = mkWN (k1A "havainto") "yliaistillinen" ; --UNCHK
lin clairvoyant_A = mkWA (k10 "povaaja") ; --UNCHK
lin clairvoyant_N = mkWN (k10 "ennustaja") ; --UNCHK
lin clam_N = mkWN (k14A "simpukka") ; --UNCHK
lin clam_V = mkWV (k73 "kerätä") "simpukoita" ; --UNCHK
lin clam_up_V = mkWV (k72 "hiljetä") ; --UNCHK
lin clamant_A = mkWA (k10 "pakottava") ; --UNCHK
lin clamatorial_A = mkWA "clamatores-" ; --UNCHK
lin clamber_N = mkWN "kapuaminen" ; --UNCHK
lin clamber_V = mkWV (k74 "könytä") ; --UNCHK
lin clammy_A = mkWA (k15 "kostea") ; --UNCHK
lin clammyweed_N = mkWN "Polanisia" "dodecandra" ; --UNCHK
lin clamor_N = mkWN (k14A "metakka") ; --UNCHK
lin clamorous_A = mkWA (k10 "meluisa") ; --UNCHK
lin clamour_N = mkWN (k14A "metakka") ; --UNCHK
lin clamour_V = mkWV (k54A "huutaa") ; --UNCHK
lin clamour_V2 = mkWV2 (k54A "huutaa") ; --UNCHK
lin clamp_N = mkWN (k33 "kiristin") ; --UNCHK
lin clamp_V = mkWV (k53A "pakottaa") ; --UNCHK
lin clamp_V2 = mkWV2 (k53A "pakottaa") ; --UNCHK
lin clamp_down_N = mkWN (k39 "rajoitus") ; --UNCHK
lin clamshell_N = mkWN (k26 "simpukankuori") ; --UNCHK
lin clan_N = mkWN (k1 "heimo") ; --UNCHK
lin clandestine_A = mkWA (k38 "salainen") ; --UNCHK
lin clang_N = mkWN (k12 "kalina") ; --UNCHK
lin clang_V = mkWV (k53A "kilahtaa") ; --UNCHK
lin clang_V2 = mkWV2 (k53A "kilahtaa") ; --UNCHK
lin clanger_N = mkWN (k39 "munaus") ; --UNCHK
lin clangorous_A = mkWA (compoundA "kalk" (k10 "kuva")) ; --UNCHK
lin clangour_N = mkWN (k12 "kalina") ; --UNCHK
lin clank_N = mkWN (k12 "kalina") ; --UNCHK
lin clank_V = mkWV (k67A "kalahdella") ; --UNCHK
lin clank_V2 = mkWV2 (k67A "kalahdella") ; --UNCHK
lin clannish_A = mkWA (k38 "nurkkakuntainen") ; --UNCHK
lin clannishness_N = mkWN (compoundN "heimo" (k7A "henki")) ; --UNCHK
lin clansman_N = mkWN (k32 "jäsen") "heimon" ; --UNCHK
lin clap_N = mkWN (k39 "töräys") ; --UNCHK
lin clap_V = mkWV (k53A "läimäyttää") ; --UNCHK
lin clap_V2 = mkWV2 (k53A "läimäyttää") ; --UNCHK
lin clapboard_N = mkWN (compoundN "ulko" (k9A "lauta")) ; --UNCHK
lin clapper_N = mkWN (k26 "kieli") ; --UNCHK
lin clapperboard_N = mkWN (k5 "klaffi") ; --UNCHK
lin claptrap_N = mkWN (k5 "humpuuki") ; --UNCHK
lin clare_PN = foreignPN "Clare" ;
lin claret_N = mkWN (compoundN "purppuran" (k38 "punainen")) ; --UNCHK
lin clarification_N = mkWN (compoundN "selven" (k38 "täminen")) ;
lin clarify_V = mkWV (k53 "kirkastaa") ; --UNCHK
lin clarify_V2 = mkWV2 (k53 "kirkastaa") ; --UNCHK
lin clarinet_N = mkWN (k5A "klarinetti") ; --UNCHK
lin clarinetistFem_N = mkWN (k5 "klarinetisti") ;
lin clarinetistMasc_N = mkWN (k5 "klarinetisti") ;
lin clarion_A = mkWA "herätys-" ; --UNCHK
lin clarion_N = mkWN "klarino" ; --UNCHK
lin clarity_N = mkWN (k40 "kirkkaus") ; --UNCHK
lin clarkston_PN = foreignPN "Clarkston" ;
lin claro_N = mkWN (compoundN "claro-si" (k5 "kari")) ; --UNCHK
lin clary_N = mkWN (compoundN "muskatelli" (k12 "salvia")) ; --UNCHK
lin clash_N = mkN "yhteen" (mkN "törmäys") ; --mkWN (k1A "suukopu") ;
lin clash_V = mkWV (k53A "ottaa") "yhteen" ; --UNCHK
lin clash_V2 = mkWV2 (k53A "ottaa") "yhteen" ; --UNCHK
lin clasp_N = mkWN (k48A "ote") ; --UNCHK
lin clasp_V = mkWV (k52A "tarrautua") ; --UNCHK
lin clasp_V2 = mkWV2 (k52A "tarrautua") ; --UNCHK
lin clasp_knife_N = mkWN (compoundN "kääntö" (k30 "veitsi")) ; --UNCHK
lin class_N = mkN "luokka" ;
lin class_V2 = mkWV2 (k53A "ryhmittää") ; --UNCHK
lin class_feeling_N = mkWN (compoundN "luokka" (k48A "tunne")) ; --UNCHK
lin class_fellow_N = mkWN (compoundN "luokka" (k6 "toveri")) ; --UNCHK
lin class_list_N = mkWN (compoundN "arvosana" (k2 "luettelo")) ; --UNCHK
lin class_warfare_N = mkWN (compoundN "luokka" (k10A "sota")) ; --UNCHK
lin classic_A = mkWA (k38 "klassinen") ; --UNCHK
lin classic_N = mkWN (k4A "klassikko") ; --UNCHK
lin classical_A = mkWA (k38 "klassinen") ; --UNCHK
lin classicism_N = mkWN (k5 "tyyli") "klassinen" ; --UNCHK
lin classicist_N = mkWN (k12 "taiteilija") "klassinen" ; --UNCHK
lin classicistic_A = mkWA (k38 "klassinen") ; --UNCHK
lin classics_N = mkWN (k40 "kirjallisuus") "klassinen" ; --UNCHK
lin classifiable_A = mkWA (k10 "oleva") "luokiteltavissa" ; --UNCHK
lin classification_N = mkWN (k2 "lajittelu") ; --UNCHK
lin classificatory_A = mkWA "luokitus-" ; --UNCHK
lin classifier_N = mkWN (k5 "morfeemi") "luokitteleva" ; --UNCHK
lin classify_V2 = mkWV2 (k53A "ryhmittää") ; --UNCHK
lin classless_A = mkWA (k34A "luokaton") ; --UNCHK
lin classmate_N = mkWN (compoundN "luokka" (k6 "toveri")) ; --UNCHK
lin classroom_N = mkWN (kH1 "luokka") ; --UNCHK
lin classwork_N = mkWN (compoundN "luokka" (k2 "työskentely")) ; --UNCHK
lin classy_A = mkWA (k47 "hienostunut") ; --UNCHK
lin clast_N = mkWN "klasti" ; --UNCHK
lin clastic_A = mkWA "osiin" "irrotettava" ; --UNCHK
lin clathrate_A = mkWA "klatraatti-" ; --UNCHK
lin clatter_N = mkWN (k12 "kalina") ; --UNCHK
lin clatter_V = mkWV (k52A "paukkua") ; --UNCHK
lin clatter_V2 = mkWV2 (k52A "paukkua") ; --UNCHK
lin clattery_A = mkWA (compoundA "rämis" (k10 "evä")) ; --UNCHK
lin claude_PN = foreignPN "Claude" ;
lin clausal_A = mkWA "lause-" ; --UNCHK
lin clause_N = mkWN (k48 "lause") ;
lin claustrophobe_N = mkWN (k2 "henkilö") "klaustrofobinen" ; --UNCHK
lin claustrophobia_N = mkWN (k1 "kammo") "suljetun" "paikan" ; --UNCHK
lin claustrophobic_A = mkWA "klaustrofobinen" ; --UNCHK
lin claustrum_N = mkWN (compoundN "aivo" (k5 "muuri")) ; --UNCHK
lin clavichord_N = mkWN "klavikordi" ; --UNCHK
lin clavicle_N = mkWN (compoundN "solis" (k18 "luu")) ; --UNCHK
lin clavier_N = mkWN (compoundN "kosketin" (k33A "soitin")) ; --UNCHK
lin claw_N = mkWN (k28 "kynsi") ; --UNCHK
lin claw_V2 = mkWV2 (k67A "raadella") ; --UNCHK
lin clawback_N = mkWN (compoundN "taka" (k38 "isinnyhtäminen")) ; --UNCHK
lin clawfoot_N = mkWN (compoundN "kaari" (k9A "jalka")) ; --UNCHK
lin clawhammer_N = mkWN (compoundN "kirvesmiehen" (k12 "vasara")) ; --UNCHK
lin clawlike_A = mkWA (compoundA "kynsi" (k38 "mäinen")) ; --UNCHK
lin clay_N = mkWN (k1A "raato") ; --UNCHK
lin clayey_A = mkWA (k38 "savinen") ; --UNCHK
lin claymore_N = mkWN (compoundN "jalkaväki" (k9 "miina")) ; --UNCHK
lin claystone_N = mkWN (compoundN "savi" (k7 "kivi")) ; --UNCHK
lin clean_A = L.clean_A ;
lin clean_Adv = mkWAdv (k99 "täysin") ; --UNCHK
lin clean_N = mkWN (k1A "työntö") ; --UNCHK
lin clean_V = mkWV (k53 "puhdistaa") ; --UNCHK
lin clean_V2 = mkWV2 (k53 "puhdistaa") ; --UNCHK
lin clean_out_V = mkWV (k73 "putsata") ; --UNCHK
lin clean_out_V2 = mkWV2 (k73 "putsata") ; --UNCHK
lin clean_up_V = mkWV (k52A "siistiytyä") ; --UNCHK
lin clean_up_V2 = mkWV2 (k52A "siistiytyä") ; --UNCHK
lin cleanable_A = mkWA (k10 "oleva") "puhdistettavissa" ; --UNCHK
lin cleaner_N = mkWN (k33 "puhdistin") ; --UNCHK
lin cleaners_N = mkWN (k12 "pesula") ; --UNCHK
lin cleaning_N = mkWN (k40 "siivous") ; --UNCHK
lin cleanliness_N = mkWN "siistiys" ; --UNCHK
lin cleanly_A = mkWA (k5 "siisti") ; --UNCHK
lin cleanness_N = mkWN (k40 "siveys") ; --UNCHK
lin cleanse_V2 = mkWV2 (k53 "puhdistaa") ; --UNCHK
lin cleanser_N = mkWN (k33 "puhdistin") ; --UNCHK
lin cleansing_A = mkWA "puhdistus-" ; --UNCHK
lin clean_up_N = mkWN (k40 "siivous") ; --UNCHK
lin clear_A = mkA (mkN "selvä") "selvempi" "selvin" ;
lin clear_Adv = mkAdv "selvästi" ;
lin clear_N = mkWN (k9 "aava") ; --UNCHK
lin clear_V = mkV "selkeytyä" ;
lin clear_V2 = mkWV2 (k53 "puhdistaa") ;
lin clear_away_V = mkWV (k72 "hälvetä") ; --UNCHK
lin clear_away_V2 = mkWV2 (k72 "hälvetä") ; --UNCHK
lin clear_off_V = mkWV (k72 "hälvetä") ; --UNCHK
lin clear_out_V = mkWV (k73 "putsata") ; --UNCHK
lin clear_out_V2 = mkWV2 (k73 "putsata") ; --UNCHK
lin clear_up_V = mkWV (k67 "kakistella") ; --UNCHK
lin clear_up_V2 = mkWV2 (k67 "kakistella") ; --UNCHK
lin clearance_N = mkWN (k10A "lupa") ; --UNCHK
lin clearing_N = mkWN (compoundN "kirkas" (k38 "taminen")) ; --UNCHK
lin clearing_house_N = mkWN (compoundN "selvitys" (k3 "yhtiö")) ; --UNCHK
lin clearness_N = mkWN (k40 "kirkkaus") ; --UNCHK
lin clearway_N = mkWN (k19 "tie") "pysähtymiskiellon" "alainen" ; --UNCHK
lin cleat_N = mkWN (k9 "lista") ; --UNCHK
lin cleavable_A = mkWA "halkaistava" ; --UNCHK
lin cleavage_N = mkWN (k38 "halkeaminen") ; --UNCHK
lin cleave_V = mkWV (k52A "tarttua") "yhteen" ; --UNCHK
lin cleave_V2 = mkWV2 (k52A "tarttua") "yhteen" ; --UNCHK
lin cleaver_N = mkWN (compoundN "liha" (k41 "kirves")) ; --UNCHK
lin cleavers_N = mkWN (compoundN "kieru" (k13 "matara")) ; --UNCHK
lin cleethorpes_PN = foreignPN "Cleethorpes" ;
lin clef_N = mkWN (compoundN "nuotti" (k33 "avain")) ; --UNCHK
lin cleft_A = mkWA "leikelty" ; --UNCHK
lin cleft_N = mkWN (k1A "rako") ; --UNCHK
lin cleistogamous_A = mkWA (compoundA "umpi" (k38 "pölytteinen")) ; --UNCHK
lin cleistogamy_N = mkWN "kleistogamia" ; --UNCHK
lin cleistothecium_N = mkWN (compoundN "kotelo" (k1A "rakko")) ; --UNCHK
lin clemency_N = mkWN (k1 "armo") ; --UNCHK
lin clement_A = mkWA (k41 "armelias") ; --UNCHK
lin clementine_N = mkWN (k5 "klementiini") ; --UNCHK
lin clerestory_N = mkWN "klerestorio" ; --UNCHK
lin clergy_N = mkWN (k2 "papisto") ; --UNCHK
lin clergyman_N = mkWN (k6 "pastori") ; --UNCHK
lin cleric_N = mkWN (k5A "pappi") ; --UNCHK
lin clerical_A = mkWA "papin" ; --UNCHK
lin clericalism_N = mkWN (compoundN "pappis" (k40 "valtaisuus")) ; --UNCHK
lin clericalist_N = mkWN (k10 "kannattaja") "pappisvaltaisuuden" ; --UNCHK
lin clerihew_N = mkWN (k1 "runo") "humoristinen" ; --UNCHK
lin clerk_N = mkWN (k5 "konttoristi") ; --UNCHK
lin clerk_V = mkWV (k71 "tehdä") "konttorityötä" ; --UNCHK
lin clerkship_N = mkWN (k19 "työ") "konttoristin" ; --UNCHK
lin clevedon_PN = foreignPN "Clevedon" ;
lin cleveland_PN = foreignPN "Cleveland" ;
lin clever_A = L.clever_A ;
lin cleverness_N = mkWN (k40 "nokkeluus") ; --UNCHK
lin clevis_N = mkWN (compoundN "ketju" (k32 "nivel")) ; --UNCHK
lin clew_N = mkWN (k48 "vihje") ; --UNCHK
lin clew_V2 = mkWV2 (k61 "pyöriä") ; --UNCHK
lin cliche_N = mkWN (k5A "trivialiteetti") ; --UNCHK
lin cliched_A = mkWA (compoundA "joka" (k38 "päiväinen")) ; --UNCHK
lin click_N = mkWN "napsautus" "hiirellä" ; --UNCHK
lin click_V = mkWV (k52 "paljastua") ; --UNCHK
lin client_N = mkN (lin NK {s = d41A "asiakas"}) ;
lin clientage_N = mkWN (k40 "asiakkuus") ; --UNCHK
lin clientele_N = mkWN (compoundN "asiakas" (k10A "kunta")) ; --UNCHK
lin cliff_N = mkWN (k48A "jyrkänne") ; --UNCHK
lin cliff_hanger_N = mkWN (compoundN "loppu" (k39 "huipennus")) ; --UNCHK
lin clifford_PN = foreignPN "Clifford" ;
lin climacteric_N = mkWN (k5 "menopaussi") ; --UNCHK
lin climactic_A = mkWA (k10 "oleva") "huipussaan" ; --UNCHK
lin climate_N = mkWN (k2 "ilmasto") ;
lin climatic_A = mkWA (k38 "ilmastollinen") ; --UNCHK
lin climatologist_N = mkWN "klimatologi" ; --UNCHK
lin climatology_N = mkWN (k12 "klimatologia") ; --UNCHK
lin climax_N = mkWN (k10 "huipentuma") ; --UNCHK
lin climax_V = mkWV (k52A "huipentua") ; --UNCHK
lin climax_V2 = mkWV2 (k52A "huipentua") ; --UNCHK
lin climb_N = mkWN (compoundN "koho" (k38 "aminen")) ; --UNCHK
lin climb_V = mkWV (k74A "kiivetä") ; --f63
lin climb_V2 = mkV2 (mkV "kiivetä") partitive ; --f56
lin climb_down_V = mkWV (k52A "laskeutua") ; --UNCHK
lin climber_N = mkWN (k9 "nasta") ; --UNCHK
lin clime_N = mkWN (k2 "ilmasto") ; --UNCHK
lin clinch_N = mkWN "sitominen" ; --UNCHK
lin clinch_V = mkWV (k64 "lyödä") "lukkoon" ; --UNCHK
lin clinch_V2 = mkWV2 (k64 "lyödä") "lukkoon" ; --UNCHK
lin clincher_N = mkWN (k10 "nitoja") ; --UNCHK
lin cling_V = mkWV (k52A "roikkua") ; --UNCHK
lin cling_to_V2 = mkWV2 (k52A "takertua") ; --UNCHK
lin clingfish_N = mkWN (compoundN "imulevy" (k9 "kala")) ; --UNCHK
lin clinic_N = mkWN (k14A "klinikka") ; --UNCHK
lin clinical_A = mkWA (k38 "kliininen") ;
lin clinician_N = mkWN (k4A "kliinikko") ; --UNCHK
lin clinid_N = mkWN "Clinidae" ; --UNCHK
lin clink_N = mkWN (k10 "putka") ; --UNCHK
lin clink_V = mkWV (k53A "kilahtaa") ; --UNCHK
lin clink_V2 = mkWV2 (k53A "kilahtaa") ; --UNCHK
lin clinker_N = mkWN (k6 "klinkkeri") ; --UNCHK
lin clinocephaly_N = mkWN (compoundN "satulapä" (k40 "isyys")) ; --UNCHK
lin clinodactyly_N = mkWN "klinodaktylia" ; --UNCHK
lin clinometer_N = mkWN (compoundN "kaltevuus" (k6 "mittari")) ; --UNCHK
lin clinquant_A = mkWA (k10 "kiiltävä") ; --UNCHK
lin clintonia_N = mkWN "Clintonia" ; --UNCHK
lin clip_N = mkWN "läimäytys" ; --UNCHK
lin clip_V2 = mkWV2 (k53A "keskeyttää") ; --UNCHK
lin clip_joint_N = mkWN (compoundN "nylky" (k9 "mesta")) ; --UNCHK
lin clipboard_N = mkWN (compoundN "kirjoitus" (k1 "levy")) ; --UNCHK
lin clipper_N = mkWN (compoundN "kynsi" (k6 "leikkuri")) ; --UNCHK
lin clipping_N = mkWN (compoundN "lei" (k38 "kkaaminen")) ; --UNCHK
lin clique_N = mkWN (k10 "ryhmittymä") ; --UNCHK
lin cliquish_A = mkWA (k38 "nurkkakuntainen") ; --UNCHK
lin clitheroe_PN = foreignPN "Clitheroe" ;
lin clitoris_N = mkWN (k39 "klitoris") ; --UNCHK
lin clive_PN = foreignPN "Clive" ;
lin cloaca_N = mkWN (k5A "kloaakki") ; --UNCHK
lin cloak_N = mkWN (kH1 "viitta") ; --UNCHK
lin cloak_V2 = mkWV2 (k53A "peittää") "kaavulla" ; --UNCHK
lin cloakmaker_N = mkWN (k6 "turkkuri") ; --UNCHK
lin cloakroom_N = mkWN (k14A "narikka") ; --UNCHK
lin clobber_V2 = mkV2 "murskata" ; --mkWV2 (k53A "rökittää") ;
lin cloche_N = mkWN (compoundN "kupu" (k1A "hattu")) ; --UNCHK
lin clock_N = mkWN (k1 "kello") ;
lin clock_dial_N = mkWN (compoundN "kello" (k1 "taulu")) ; --UNCHK
lin clock_face_N = mkWN (compoundN "kello" (k1 "taulu")) ; --UNCHK
lin clock_golf_N = mkWN (compoundN "kello" (k5 "golf")) ; --UNCHK
lin clock_tower_N = mkWN (compoundN "kello" (k5 "torni")) ; --UNCHK
lin clocking_N = mkWN (kH1 "aika") ; --UNCHK
lin clocksmith_N = mkWN (compoundN "kello" (k10A "seppä")) ; --UNCHK
lin clockwise_A = mkWA (compoundA "myötä" (k38 "päiväinen")) ; --UNCHK
lin clockwise_Adv = mkWAdv (k99 "myötäpäivään") ; --UNCHK
lin clockwork_N = mkWN (compoundN "jousi" (k2 "koneisto")) ; --UNCHK
lin clod_N = mkWN (k5A "klöntti") ; --UNCHK
lin cloddish_A = mkWA (k38 "moukkamainen") ; --UNCHK
lin clodhopper_N = mkWN (k10A "kenkä") "tukeva" ; --UNCHK
lin clofibrate_N = mkWN "Atromid-S" ; --UNCHK
lin clog_N = mkWN (compoundN "puukenkä" (k5 "tanssi")) ; --UNCHK
lin clog_V = mkWV (k53A "rasittaa") ; --UNCHK
lin clog_V2 = mkWV2 (k53A "rasittaa") ; --UNCHK
lin clog_dance_N = mkWN (compoundN "puukenkä" (k5 "tanssi")) ; --UNCHK
lin clog_up_V2 = mkWV2 (k53A "ruuhkauttaa") ; --UNCHK
lin cloggy_A = mkWA (k41 "tiivis") ; --UNCHK
lin cloisonne_N = mkWN (compoundN "solu" (k5A "emalointi")) ; --UNCHK
lin cloister_V2 = mkWV2 (k52A "eristäytyä") ; --UNCHK
lin clomiphene_N = mkWN "Clomid" ; --UNCHK
lin clomipramine_N = mkWN "klomipramiini" ; --UNCHK
lin clonal_A = mkWA "klooni-" ; --UNCHK
lin clone_N = mkWN (k10 "jäljitelmä") ; --UNCHK
lin clone_V2 = mkWV2 (k73 "kloonata") ; --UNCHK
lin clonic_A = mkWA (compoundA "klooni" (k38 "nen")) ; --UNCHK
lin clonidine_N = mkWN "Catapres" ; --UNCHK
lin cloning_N = mkWN (compoundN "klooni" (k39 "tutkimus")) ; --UNCHK
lin clonus_N = mkWN (compoundN "nykimä" (k39 "kouristus")) ; --UNCHK
lin close_A = mkA "läheinen" ;
lin close_Adv = mkWAdv (k99 "lähettyvillä") ; --f74
lin close_N = mkWN (k1A "loppu") ; --f109
lin close_V = mkV "sulkea" ;
lin close_V2 = L.close_V2 ;
lin close_down_V = advV OP_close_V OP_down_Adv ; -- guess-p-verb
lin close_down_V2 = prepV2 OP_close_V OP_down_Prep ; -- guess-p-verb
lin close_in_V = mkWV (k58A "sulkea") "sisään" ; --UNCHK
lin close_in_on_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin close_in_upon_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_upon_Prep ; -- guess-p-verb
lin close_off_V2 = mkWV2 (k58A "sulkea") ; --UNCHK
lin close_on_V2 = prepV2 OP_close_V OP_on_Prep ; -- guess-p-verb
lin close_out_V2 = mkWV2 (k53A "lopettaa") ; --UNCHK
lin close_set_A = mkWA (k99 "kiinni") "tiukasti" ; --UNCHK
lin close_to_Prep = mkPrep "lähellä" ;
lin close_up_V = mkWV (k72 "hiljetä") ; --UNCHK
lin close_up_V2 = mkWV2 (k72 "hiljetä") ; --UNCHK
lin closed_A = mkA "suljettu" ;
lin close_fisted_A = mkWA (k5 "pihi") ; --UNCHK
lin closeness_N = mkWN (k40 "läheisyys") ; --UNCHK
lin closeout_N = mkWN (compoundN "loppuun" (k5A "myynti")) ; --UNCHK
lin closer_N = mkWN (compoundN "sulkija" (k10 "syöttäjä")) ; --UNCHK
lin closet_N = mkWN (k6 "kamari") ; --UNCHK
lin closet_V2 = mkWV2 (k52A "sulkeutua") ; --UNCHK
lin close_up_N = mkWN (compoundN "lähi" (k10 "kuva")) ; --UNCHK
lin closing_N = mkWN (k1A "loppu") ; --UNCHK
lin clostridium_N = mkWN (compoundN "clostri" (k9 "dia")) ; --UNCHK
lin closure_N = mkWN (compoundN "lakka" (k38 "uttaminen")) ; --UNCHK
lin clot_N = mkWN (k10 "hyytymä") ; --UNCHK
lin clot_V = mkWV (k52A "koaguloitua") ; --UNCHK
lin clot_V2 = mkWV2 (k52A "koaguloitua") ; --UNCHK
lin cloth_N = mkWN (k48A "vaate") ; --UNCHK
lin clothe_V2 = mkWV2 (k53 "varustaa") ; --UNCHK
lin clothes_N = mkN "asu" | mkN "vaate" ; ---- plural only
lin clothes_basket_N = mkWN (compoundN "pyykki" (k5 "kori")) ; --UNCHK
lin clothes_hanger_N = mkWN (k6 "henkari") ; --UNCHK
lin clothes_moth_N = mkWN (k18 "vaatekoi") ; --UNCHK
lin clothes_peg_N = mkWN (compoundN "pyykki" (k10A "poika")) ; --UNCHK
lin clothes_pin_N = mkWN (compoundN "pyykki" (k10A "poika")) ; --UNCHK
lin clothesbrush_N = mkWN (compoundN "vaate" (k9 "harja")) ; --UNCHK
lin clotheshorse_N = mkWN (compoundN "kuivaus" (k48 "teline")) ; --UNCHK
lin clothesless_A = mkWA (k10 "oleva") "vaatteitta" ; --UNCHK
lin clothesline_N = mkWN (compoundN "pyykki" (k1 "naru")) ; --UNCHK
lin clothier_N = mkWN (compoundN "miestenvaate" (k41 "kauppias")) ; --UNCHK
lin clothing_N = mkWN (k1A "puku") ; --UNCHK
lin cloud_N = L.cloud_N ;
lin cloud_V = mkWV (k54A "synkentää") ; --UNCHK
lin cloud_V2 = mkWV2 (k54A "synkentää") ; --UNCHK
lin cloud_bank_N = mkWN (compoundN "pilvi" (k1 "verho")) ; --UNCHK
lin cloud_over_V = mkWV (k52 "pilvistyä") ; --UNCHK
lin cloudberry_N = mkWN (k33 "muurain") ; --UNCHK
lin cloudburst_N = mkWN (k10 "tulva") ; --UNCHK
lin cloudiness_N = mkWN (k40 "hämäryys") ; --UNCHK
lin clouding_N = mkWN (compoundN "pilvi" (k38 "styminen")) ; --UNCHK
lin cloudless_A = mkWA (k34A "pilvetön") ; --UNCHK
lin cloudlessness_N = mkWN "pilvettömyys" ; --UNCHK
lin cloudlike_A = mkWA (compoundA "pilvi" (k38 "mäinen")) ; --UNCHK
lin cloudy_A = mkWA (k38 "pilvinen") ; --UNCHK
lin clout_N = mkWN (k5 "tälli") ; --UNCHK
lin clout_V2 = mkWV2 (k64 "lyödä") ; --UNCHK
lin clove_N = mkWN (compoundN "mauste" (k14A "neilikka")) ; --UNCHK
lin clove_hitch_N = mkWN (compoundN "kaksois" (k7 "polvi")) ; --UNCHK
lin cloven_A = mkWA "sorkka-" ; --UNCHK
lin clover_N = mkWN (k13 "apila") ; --UNCHK
lin cloverleaf_N = mkWN (compoundN "apilanlehti" (k39 "risteys")) ; --UNCHK
lin clowder_N = mkWN (compoundN "kissa" (k9 "lauma")) ; --UNCHK
lin clown_N = mkWN (k5 "narri") ; --UNCHK
lin clown_V = mkWV (k67 "ilveillä") ; --UNCHK
lin clown_around_V = mkWV (k67 "ilveillä") ; --UNCHK
lin clowne_PN = foreignPN "Clowne" ;
lin clownish_A = mkWA (compoundA "klovni" (k38 "mainen")) ; --UNCHK
lin cloy_V = mkWV (k53A "kyllästyttää") ; --UNCHK
lin cloy_V2 = mkWV2 (k53A "kyllästyttää") ; --UNCHK
lin cloyingly_Adv = mkWAdv (compoundAdv "yli" (k99 "makeasti")) ; --UNCHK
lin clozapine_N = mkWN "Clozaril" ; --UNCHK
lin cloze_A = mkWA "täydennys-" ; --UNCHK
lin club_1_N = mkN "kerho" | mkN "klubi" ;
lin club_2_N = mkN "maila" ;
lin club_N = mkN "klubi" ;
lin club_V = mkWV (k73 "kerätä") "yhteen" ; --UNCHK
lin club_V2 = mkWV2 (k73 "kerätä") "yhteen" ; --UNCHK
lin clubbable_A = mkWA (k38 "sosiaalinen") ; --UNCHK
lin clubbish_A = mkWA (k38 "sosiaalinen") ; --UNCHK
lin clubfoot_N = mkWN (compoundN "kampura" (k9A "jalka")) ; --UNCHK
lin club_footed_A = mkWA (compoundA "kampura" (k38 "jalkainen")) ; --UNCHK
lin clubhouse_N = mkWN (k5 "klubi") ; --UNCHK
lin clubroom_N = mkWN (compoundN "kerho" (k48 "huone")) ; --UNCHK
lin cluck_N = mkWN (k39 "kaakatus") ; --UNCHK
lin cluck_V = mkWV (k53A "kalkattaa") ; --UNCHK
lin clue_N = mkWN (k48 "vihje") ; --UNCHK
lin clueless_A = mkWA (k34A "tietämätön") "täysin" ; --UNCHK
lin clumber_N = mkWN (compoundN "clumberin" (k5 "spanieli")) ; --UNCHK
lin clump_N = mkWN (k39 "mätkähdys") ; --UNCHK
lin clump_V = mkWV (k74A "koota") "rykelmäksi" ; --UNCHK
lin clump_V2 = mkWV2 (k74A "koota") "rykelmäksi" ; --UNCHK
lin clumsiness_N = mkWN (k40 "jäykkyys") ; --UNCHK
lin clumsy_A = mkWA (k2 "tökerö") ; --UNCHK
lin clunk_N = mkWN (k39 "mätkähdys") ; --UNCHK
lin clunk_V = mkWV (k66 "tömistä") ; --UNCHK
lin clunky_A = mkWA "jysähtävä" ; --UNCHK
lin clusia_N = mkWN "klusia" ; --UNCHK
lin cluster_N = mkWN (k1A "terttu") ; --UNCHK
lin cluster_V = mkWV (k74A "koota") "rykelmäksi" ; --UNCHK
lin cluster_V2 = mkWV2 (k74A "koota") "rykelmäksi" ; --UNCHK
lin clutch_N = mkWN (k48A "ote") ; --UNCHK
lin clutch_V = mkWV (k58 "iskeä") ; --UNCHK
lin clutch_V2 = mkWV2 (k58 "iskeä") ; --UNCHK
lin clutter_N = mkN "epä" (mkN "järjestys") ; --mkWN (compoundN "tutka" (k3 "häiriö")) ;
lin clutter_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin clydach_PN = foreignPN "Clydach" ;
lin clydebank_PN = foreignPN "Clydebank" ;
lin clypeus_N = mkWN (compoundN "suu" (k7A "kilpi")) ; --UNCHK
lin cm_N = mkWN (k5A "sentti") ; --UNCHK
lin co_N = mkN "kumppani" ;
lin co_found_V2 = mkV2 (mkV olla_V "mukana perustamassa") partitive ;
lin co_manage_V2 = mkV2 (mkV (mkV "johtaa") "yhdessä") ;
lin coach_1_N = variants {} ; --
lin coach_2_N = variants {} ; --
lin coach_3_N = mkN "valmentaja" ;
lin coach_N = mkWN (k5 "bussi") ; --UNCHK
lin coach_V = mkWV (k54A "valmentaa") ; --UNCHK
lin coach_V2 = mkWV2 (k54A "valmentaa") ; --UNCHK
lin coach_builder_N = mkWN (compoundN "korin" (k10 "rakentaja")) ; --UNCHK
lin coaching_N = mkWN (k19 "työ") "valmentajan" ; --UNCHK
lin coachman_N = mkWN (k10 "ajaja") ; --UNCHK
lin coachwhip_N = mkWN "Masticophis" "flagellum" ; --UNCHK
lin coadjutor_N = mkWN (compoundN "apulais" (k9 "piispa")) ; --UNCHK
lin coagulable_A = mkWA "hyytyvä" ; --UNCHK
lin coagulant_N = mkWN (k48A "hyydyte") ; --UNCHK
lin coagulase_N = mkWN (compoundN "koagul" (k5 "aasi")) ; --UNCHK
lin coagulate_V = mkWV (k52A "koaguloitua") ; --UNCHK
lin coagulate_V2 = mkWV2 (k52A "koaguloitua") ; --UNCHK
lin coagulation_N = mkWN (k3 "koagulaatio") ; --UNCHK
lin coal_N = mkN "hiili" "hiiliä" ; --WN (k48 "kekäle") ;
lin coal_gas_N = mkWN (compoundN "hiili" (k1 "kaasu")) ; --UNCHK
lin coal_house_N = mkWN (compoundN "hiili" (k9 "vaja")) ; --UNCHK
lin coal_scuttle_N = mkWN (k1A "sanko") ; --UNCHK
lin coal_seam_N = mkWN (compoundN "kivihiili" (k48A "juonne")) ; --UNCHK
lin coal_tar_N = mkWN (compoundN "kivihiili" (k9 "terva")) ; --UNCHK
lin coalbin_N = mkWN (compoundN "hiili" (k12 "astia")) ; --UNCHK
lin coalesce_V = mkWV (k52A "sulautua") ; --UNCHK
lin coalescence_N = mkWN (compoundN "yhteen" (k38 "liityminen")) ; --UNCHK
lin coalface_N = mkWN (compoundN "rin" (k39 "taus")) "hiilikaivoksen" ; --UNCHK
lin coalfield_N = mkWN (compoundN "hiili" (k10A "kenttä")) ; --UNCHK
lin coaling_station_N = mkWN (compoundN "hiili" (k10 "asema")) ; --UNCHK
lin coalition_N = mkWN (compoundN "yhteen" (k38 "liityminen")) ; --UNCHK
lin coalman_N = mkWN (compoundN "hiili" (k42 "mies")) ; --UNCHK
lin coalpit_N = mkWN (compoundN "hiili" (k39 "kaivos")) ; --UNCHK
lin coalville_PN = foreignPN "Coalville" ;
lin coaming_N = mkWN (compoundN "roiske" (k9 "reuna")) ; --UNCHK
lin coarctate_A = mkWA (compoundA "kotelo" (k47 "itunut")) ; --UNCHK
lin coarctation_N = mkWN (k10 "ahtauma") ; --UNCHK
lin coarse_A = mkWA (k15 "karhea") ; --UNCHK
lin coarsen_V = mkWV (k53 "raaistaa") ; --UNCHK
lin coarsen_V2 = mkWV2 (k53 "raaistaa") ; --UNCHK
lin coarseness_N = mkWN (k40 "rivous") ; --UNCHK
lin coast_N = mkN "rannikko" ;
lin coast_V = mkWV (k52A "liukua") ; --UNCHK
lin coast_V2 = mkWV2 (k52A "liukua") ; --UNCHK
lin coastal_A = mkWA "rannikko-" ; --UNCHK
lin coaster_N = mkWN (k38 "alunen") ; --UNCHK
lin coastguard_N = mkWN (compoundN "rannikko" (k1 "vartiosto")) ; --UNCHK
lin coastguardsman_N = mkWN (compoundN "rannikko" (k12 "vartija")) ; --UNCHK
lin coastland_N = mkWN (k4A "rannikko") ; --UNCHK
lin coastline_N = mkWN (compoundN "ranta" (k9 "viiva")) ; --UNCHK
lin coastward_Adv = mkWAdv "rannikon" "suuntaan" ; --UNCHK
lin coastwise_A = mkWA "rannikko-" ; --UNCHK
lin coastwise_Adv = mkWAdv (k99 "suuntaisesti") "rannikon" ; --UNCHK
lin coat_N = L.coat_N ;
lin coat_V2 = mkWV2 (k58A "pukea") "takkiin" ; --UNCHK
lin coat_hanger_N = mkWN (k6 "henkari") ; --UNCHK
lin coatbridge_PN = foreignPN "Coatbridge" ;
lin coati_N = mkWN (compoundN "valkonenä" (k1 "karhu")) ; --UNCHK
lin coating_N = mkWN (k2 "sively") ; --UNCHK
lin coatrack_N = mkWN (compoundN "vaate" (k4A "naulakko")) "seisova" ; --UNCHK
lin coattail_N = mkWN (compoundN "takin" (k48A "lieve")) ; --UNCHK
lin coauthorFem_N = mkWN (k12 "tekijä") "toinen" ; --UNCHK
lin coauthorMasc_N = mkWN (k12 "tekijä") "toinen" ; --UNCHK
lin coax_V = mkWV (k67A "viekoitella") ; --UNCHK
lin coax_V2 = mkWV2 (k67A "viekoitella") ; --UNCHK
lin coaxial_A = mkWA (compoundA "sama" (k38 "keskinen")) ; --UNCHK
lin coaxing_N = mkWN (k2 "suostuttelu") ; --UNCHK
lin coaxingly_Adv = mkWAdv (compoundAdv "houkuttelev" (k99 "asti")) ; --UNCHK
lin cob_N = mkWN (k32 "joutsen") ; --UNCHK
lin cobalt_N = mkWN (k5A "koboltti") ; --UNCHK
lin cobaltite_N = mkWN (compoundN "koboltti" (k48A "hohde")) ; --UNCHK
lin cobber_N = mkWN (k6 "kaveri") ; --UNCHK
lin cobble_N = mkWN (compoundN "mukula" (k7 "kivi")) ; --UNCHK
lin cobble_V2 = mkWV2 (k61 "kursia") "kasaan" ; --UNCHK
lin cobble_together_V2 = mkWV2 (k54A "tuhertaa") ; --UNCHK
lin cobbler_N = mkWN (compoundN "hedelmä" (k1A "torttu")) ; --UNCHK
lin cobblestone_N = mkWN (compoundN "mukula" (k7 "kivi")) ; --UNCHK
lin cobham_PN = foreignPN "Cobham" ;
lin cobia_N = mkWN (compoundN "oka" (k9 "kala")) ; --UNCHK
lin cob_nut_N = mkWN (k12 "pähkinä") ; --UNCHK
lin cobra_N = mkWN (k10 "kobra") ; --UNCHK
lin cobweb_N = mkWN (k5A "seitti") ; --UNCHK
lin cobwebby_A = mkWA (k99 "peitossa") "hämähäkinverkkojen" ; --UNCHK
lin coca_cola_N = mkWN "kokis" ; --UNCHK
lin cocaine_N = mkWN (k5 "kokaiini") ; --UNCHK
lin cocarboxylase_N = mkWN (compoundN "tiamiinipyro" (k5A "fosfaatti")) ; --UNCHK
lin coccal_A = mkWA (compoundA "pallo" (k38 "mainen")) ; --UNCHK
lin coccidioidomycosis_N = mkWN "koksidioidomykoosi" ; --UNCHK
lin coccidiosis_N = mkWN "kokkidioosi" ; --UNCHK
lin coccidium_N = mkWN "Eimeria" ; --UNCHK
lin coccoid_A = mkWA (compoundA "kokki" (k38 "mainen")) ; --UNCHK
lin coccus_N = mkWN (kH1 "kokki") ; --UNCHK
lin coccygeal_A = mkWA "häntäluun" ; --UNCHK
lin coccyx_N = mkWN (compoundN "häntä" (k18 "luu")) ; --UNCHK
lin cochin_N = mkWN (compoundN "kochin-" (k9 "kana")) ; --UNCHK
lin cochineal_N = mkWN (compoundN "karmiini" (k9 "kirva")) ; --UNCHK
lin cochlea_N = mkWN (k14A "simpukka") ; --UNCHK
lin cochlear_A = mkWA "simpukka-" ; --UNCHK
lin cock_N = mkWN (k1A "ukko") ; --UNCHK
lin cock_V2 = mkWV2 (k53A "virittää") ; --UNCHK
lin cock_up_V2 = mkWV2 (k67 "olla") "höröllä" ; --UNCHK
lin cockade_N = mkWN (k5 "kokardi") ; --UNCHK
lin cockamamie_A = mkWA (k38 "hullunkurinen") ; --UNCHK
lin cockateel_N = mkWN (compoundN "neito" (k2 "kakadu")) ; --UNCHK
lin cockatoo_N = mkWN (k2 "kakadu") ; --UNCHK
lin cockatrice_N = mkWN "basiliski" ; --UNCHK
lin cockchafer_N = mkWN (compoundN "saksan" (k41 "turilas")) ; --UNCHK
lin cocker_N = mkWN (compoundN "cocker" (k5 "spanieli")) ; --UNCHK
lin cockerel_N = mkWN (compoundN "kukon" (k10A "poika")) ; --UNCHK
lin cockermouth_PN = foreignPN "Cockermouth" ;
lin cockeyed_A = mkWA (k10 "oleva") "tillin-tallin" ; --UNCHK
lin cockfight_N = mkWN (compoundN "kukko" (k2 "tappelu")) ; --UNCHK
lin cockfighting_N = mkWN (compoundN "kukko" (k2 "tappelu")) ; --UNCHK
lin cockhorse_N = mkWN (compoundN "keppi" (k38 "hevonen")) ; --UNCHK
lin cockle_N = mkWN (compoundN "sydän" (k14A "simpukka")) ; --UNCHK
lin cocklebur_N = mkWN (compoundN "iso" (k38 "takiainen")) ; --UNCHK
lin cockleshell_N = mkWN (k48 "vene") "pieni" "kiikkerä" ; --UNCHK
lin cockloft_N = mkWN (compoundN "ullakko" (k6 "kamari")) ; --UNCHK
lin cockney_A = mkWA "Cockneyn" ; --UNCHK
lin cockney_N = mkWN "cockney" ; --UNCHK
lin cockpit_N = mkWN (k2 "ohjaamo") ; --UNCHK
lin cockroach_N = mkWN (k14A "russakka") ; --UNCHK
lin cockscomb_N = mkWN (k9 "harja") ; --UNCHK
lin cockspur_N = mkWN "Pisonia" "aculeata" ; --UNCHK
lin cocksucker_N = mkWN (k1 "roisto") ; --UNCHK
lin cocksure_A = mkWA (k9 "varma") "aivan" ; --UNCHK
lin cocktail_N = mkWN (compoundN "ruoka" (k1A "ryyppy")) ; --UNCHK
lin cockup_N = mkWN (k1 "sotku") ; --UNCHK
lin cocky_A = mkWA (k15 "pöyhkeä") ; --UNCHK
lin coco_N = mkWN (compoundN "kookos" (k12 "pähkinä")) ; --UNCHK
lin cocoa_N = mkWN (compoundN "kaakao" (k48 "jauhe")) ; --UNCHK
lin cocobolo_N = mkWN (compoundN "ruusu" (k18 "puu")) ; --UNCHK
lin coconut_N = mkWN (compoundN "kookos" (k12 "pähkinä")) ; --UNCHK
lin cocoon_N = mkWN (k2 "kotelo") ; --UNCHK
lin cocoon_V2 = mkWV2 (k62 "koteloida") ; --UNCHK
lin cocooning_N = mkWN (compoundN "kotelo" (k38 "ituminen")) ; --UNCHK
lin cocotte_N = mkWN (compoundN "annos" (k10A "vuoka")) ; --UNCHK
lin cocozelle_N = mkWN (compoundN "cocozelle-kesäkurpitsa" (k48A "lajike")) ; --UNCHK
lin cocuswood_N = mkWN "Aspalathus" "ebenus" ; --UNCHK
lin cod_N = mkWN (k10 "turska") ; --UNCHK
lin cod_V = mkWV (k53A "ärsyttää") ; --UNCHK
lin cod_V2 = mkWV2 (k53A "ärsyttää") ; --UNCHK
lin cod_liver_oil_N = mkWN (compoundN "kalanmaksa" (k1 "öljy")) ; --UNCHK
lin coda_N = mkWN (k10 "osa") "viimeinen" ; --UNCHK
lin code_N = mkN "koodi" ;
lin code_V2 = mkV2 "koodata" ;
lin codefendant_N = mkWN (compoundN "kanssa" (k10 "vastaaja")) ; --UNCHK
lin codeine_N = mkWN (k5 "kodeiini") ; --UNCHK
lin codetalker_N = mkWN (compoundN "navajo-salakielen" (k10 "käyttäjä")) ; --UNCHK
lin codex_N = mkWN (k5 "koodeksi") ; --UNCHK
lin codfish_N = mkWN (k10 "turska") ; --UNCHK
lin codger_N = mkWN (k6 "ukkeli") "vanha" ; --UNCHK
lin codicil_N = mkWN (compoundN "lisä" (k5A "testamentti")) ; --UNCHK
lin codification_N = mkWN (k3 "kodifikaatio") ; --UNCHK
lin codify_V2 = mkWV2 (k62 "kodifioida") ; --UNCHK
lin codling_N = mkWN (k10 "turska") "nuori" ; --UNCHK
lin codon_N = mkWN "kodoni" ; --UNCHK
lin codpiece_N = mkWN (compoundN "kalu" (k2 "kukkaro")) ; --UNCHK
lin codsall_PN = foreignPN "Codsall" ;
lin coeducation_N = mkWN (compoundN "yhteis" (k39 "opetus")) ; --UNCHK
lin coeducational_A = mkWA "yhteis-" ; --UNCHK
lin coefficient_N = mkWN (kH1 "kerroin") ; --UNCHK
lin coelacanth_N = mkWN "Latimeria" "chalumnae" ; --UNCHK
lin coelenterate_N = mkWN "Cnidaria" ; --UNCHK
lin coelenteron_N = mkWN (k2 "ontelo") ; --UNCHK
lin coeliac_A = mkWA "vatsaontelon" ; --UNCHK
lin coelophysis_N = mkWN "Coelophysis" ; --UNCHK
lin coelostat_N = mkWN (compoundN "aurinko" (k5A "teleskooppi")) ; --UNCHK
lin coenzyme_N = mkWN "koentsyymi" ; --UNCHK
lin coequal_A = mkWA (compoundA "yhden" (k38 "vertainen")) ; --UNCHK
lin coerce_V2 = mkWV2 (k53 "painostaa") ; --UNCHK
lin coercion_N = mkWN (k1A "pakko") ; --UNCHK
lin coercive_A = mkWA (k10 "pakottava") ; --UNCHK
lin coetaneous_A = mkWA (k38 "aikalainen") ; --UNCHK
lin coeval_A = mkWA (k38 "aikalainen") ; --UNCHK
lin coeval_N = mkWN (k38 "aikalainen") ; --UNCHK
lin co_exist_V = mkWV (k52A "esiintyä") "yhtaikaisesti" ; --UNCHK
lin coexistence_N = mkWN (compoundN "yhteis" (k1 "elo")) ; --UNCHK
lin coexistent_A = mkWA (compoundA "saman" (k38 "aikainen")) ; --UNCHK
lin coextension_N = mkWN (compoundN "samank" (k40 "estoisuus")) ; --UNCHK
lin coextensive_A = mkWA (compoundA "saman" (k38 "laajuinen")) ; --UNCHK
lin coffee_N = mkN "kahvi" ;
lin coffee_mill_N = mkWN (compoundN "kahvi" (k1 "mylly")) ; --UNCHK
lin coffee_stall_N = mkWN (compoundN "kahvi" (k5 "kioski")) ; --UNCHK
lin coffeeberry_N = mkWN "Rhamnus" "californicus" ; --UNCHK
lin coffeecake_N = mkWN (compoundN "kahvi" (k1A "kakku")) ; --UNCHK
lin coffeepot_N = mkWN (compoundN "kahvi" (k1 "pannu")) ; --UNCHK
lin coffer_N = mkWN (k41A "lipas") ; --UNCHK
lin coffin_N = mkWN (k1A "arkku") ; --UNCHK
lin cofounder_N = mkWN (k10 "perustaja") "toinen" ; --UNCHK
lin cog_N = mkWN (k41A "hammas") ; --UNCHK
lin cogency_N = mkWN (k40 "oikeellisuus") ; --UNCHK
lin cogent_A = mkWA (k10 "painava") ; --UNCHK
lin cogged_A = mkWA (compoundA "hammas" (k1 "tettu")) ; --UNCHK
lin cogitable_A = mkWA (k38 "arvoinen") "harkitsemisen" ; --UNCHK
lin cogitate_V = mkWV (k61A "miettiä") ; --UNCHK
lin cogitate_V2 = mkWV2 (k61A "miettiä") ; --UNCHK
lin cogitation_N = mkWN (k2 "pohdiskelu") ; --UNCHK
lin cogitative_A = mkWA "ajattelu-" ; --UNCHK
lin cognac_N = mkWN (k5A "konjakki") ; --UNCHK
lin cognate_A = mkWA (k38 "sukulainen") ; --UNCHK
lin cognate_N = mkWN (compoundN "sukulais" (k9 "sana")) ; --UNCHK
lin cognition_N = mkWN (k9A "tajunta") ; --UNCHK
lin cognitive_A = mkWA (k38 "kognitiivinen") ; --UNCHK
lin cognizance_N = mkWN (k9A "tajunta") ; --UNCHK
lin cognizant_A = mkWA (k10 "tietävä") ; --UNCHK
lin cognomen_N = mkWN (compoundN "suku" (k7 "nimi")) ; --UNCHK
lin cogwheel_N = mkWN (k41A "ratas") ; --UNCHK
lin cohabitation_N = mkWN (compoundN "avo" (k1A "liitto")) ; --UNCHK
lin cohere_V = mkWV (k52A "tarttua") "yhteen" ; --UNCHK
lin coherence_N = mkWN (k40 "yhtenäisyys") ; --UNCHK
lin coherency_N = mkWN (k40 "yhtenäisyys") ; --UNCHK
lin coherent_A = mkWA (k5A "koherentti") ; --UNCHK
lin cohesion_N = mkWN (k3 "koheesio") ; --UNCHK
lin cohesive_A = mkWA "koheesio-" ; --UNCHK
lin cohesiveness_N = mkWN (k40 "tahmeus") ; --UNCHK
lin coho_N = mkWN (compoundN "hopea" (k23 "lohi")) ; --UNCHK
lin cohort_N = mkWN (k5A "kohortti") ; --UNCHK
lin coif_N = mkWN (k48 "päähine") ; --UNCHK
lin coiffeur_N = mkWN (k10 "kampaaja") ; --UNCHK
lin coiffeuse_N = mkWN (k10 "kampaaja") ; --UNCHK
lin coiffure_N = mkWN (k39 "kampaus") ; --UNCHK
lin coign_N = mkWN (compoundN "laki" (k7 "kivi")) ; --UNCHK
lin coil_N = mkWN (k6 "spiraali") ; --UNCHK
lin coil_V = mkWV (k61 "keriä") ; --UNCHK
lin coil_V2 = mkWV2 (k61 "keriä") ; --UNCHK
lin coimbatore_PN = foreignPN "Coimbatore" ;
lin coin_N = mkN "kolikko" ; --WN (k5A "lantti") ;
lin coin_V2 = mkWV2 (k64 "lyödä") "rahaa" ; --UNCHK
lin coinage_N = mkWN (k1A "käyttö") "uudissanojen" ; --UNCHK
lin coincide_V = mkV (mkV "sattua") "samaan aikaan" ;
lin coincidence_N = mkWN (k10 "tapahtuma") "samanaikainen" ; --UNCHK
lin coincident_A = mkWA (compoundA "yhtä" (k10 "pitävä")) ; --UNCHK
lin coincidental_A = mkWA (k38 "rinnakkainen") ; --UNCHK
lin coiner_N = mkWN (compoundN "rahan" (k10 "lyöjä")) ; --UNCHK
lin coinsurance_N = mkWN (compoundN "rinnakkais" (k39 "vakuutus")) ; --UNCHK
lin coir_N = mkWN (compoundN "kookos" (k1A "kuitu")) ; --UNCHK
lin coital_A = mkWA "parittelu-" ; --UNCHK
lin coition_N = mkWN (k38 "kanssakäyminen") "seksuaalinen" ; --UNCHK
lin coitus_N = mkWN (k38 "kanssakäyminen") "seksuaalinen" ; --UNCHK
lin coke_N = mkWN (k5 "kokaiini") ; --UNCHK
lin coke_V2 = mkWV2 (k52A "koksiintua") ; --UNCHK
lin col_N = mkWN (k1 "rotko") ; --UNCHK
lin cola_N = mkWN (k10 "kola") ; --UNCHK
lin colander_N = mkWN (k4A "lävikkö") ; --UNCHK
lin colchester_PN = foreignPN "Colchester" ;
lin colchicine_N = mkWN "kolkisiini" ; --UNCHK
lin cold_A = L.cold_A ;
lin cold_N = mkWN (k38 "vilustuminen") ;
lin cold_hearted_A = mkWA (compoundA "kylmä" (k38 "sydäminen")) ; --UNCHK
lin coldness_N = mkWN (k40 "etäisyys") ; --UNCHK
lin coleslaw_N = mkWN (compoundN "kaali" (k5A "salaatti")) ; --UNCHK
lin coleus_N = mkWN (compoundN "väri" (k38 "nokkonen")) ; --UNCHK
lin colic_N = mkWN (k9 "vatsa") "akuutti" ; --UNCHK
lin colicky_A = mkWA "kaasu-" ; --UNCHK
lin colicroot_N = mkWN (compoundN "farin" (k10 "osa")) "Aletris" ; --UNCHK
lin coliphage_N = mkWN "koolifagi" ; --UNCHK
lin colitis_N = mkWN (k39 "tulehdus") "paksunsuolen" ; --UNCHK
lin collaborate_V = mkWV (k61 "toimia") "yhteistyössä" ;
lin collaboration_N = mkN "yhteis" (mkN "työ") ;
lin collaborationist_N = mkWN (k5 "quisling") ; --UNCHK
lin collaborative_A = mkWA "yhteistyö-" ; --UNCHK
lin collaborator_N = mkWN (k6 "partneri") ; --UNCHK
lin collage_N = mkWN (k5 "montaasi") ; --UNCHK
lin collagen_N = mkWN (k5 "kollageeni") ; --UNCHK
lin collagenase_N = mkWN (compoundN "kollagen" (k5 "aasi")) ; --UNCHK
lin collagenous_A = mkWA (compoundA "kollage" (k36 "enin")) ; --UNCHK
lin collapsable_A = mkWA "kokoon" "taitettava" ; --UNCHK
lin collapse_N = mkWN (k39 "romahdus") ; --f74
lin collapse_V = mkV (lin VK {s = c53A "romahtaa"}) ;
lin collapse_V2 = mkWV2 (k52 "lyyhistyä") ; --UNCHK
lin collapsible_A = mkWA "kokoon" "taitettava" ; --UNCHK
lin collar_N = mkWN (k99 "kiinni") "saada" ; --UNCHK
lin collar_V2 = mkWV2 (k69 "vangita") ; --UNCHK
lin collarbone_N = mkWN (compoundN "solis" (k18 "luu")) ; --UNCHK
lin collard_N = mkWN (compoundN "lehti" (k5 "kaali")) ; --UNCHK
lin collards_N = mkWN (compoundN "lehti" (k5 "kaali")) ; --UNCHK
lin collarless_A = mkWA "kaulukseton" ; --UNCHK
lin collate_V2 = mkWV2 (k67 "vertailla") ; --UNCHK
lin collateral_A = mkWA (k10 "oleva") "sivusukua" ; --UNCHK
lin collateral_N = mkWN (k40 "vakuus") ; --UNCHK
lin collation_N = mkWN (k2 "vertailu") ; --UNCHK
lin colleague_N = mkWN (k13 "kollega") ; --f55
lin collect_A = mkWA "vasta-" ; --UNCHK
lin collect_Adv = mkWAdv "vasta-" ; --UNCHK
lin collect_N = mkWN (compoundN "kollehta" (k39 "rukous")) ; --UNCHK
lin collect_V = mkWV (k53 "yhdistää") ; --UNCHK
lin collect_V2 = mkV2 "kerätä" partitive ;
lin collectedly_Adv = mkWAdv (k99 "hillitysti") ; --UNCHK
lin collectible_A = mkWA "maksettava" ; --UNCHK
lin collectible_N = mkWN (compoundN "keräily" (k48 "esine")) ; --UNCHK
lin collection_N = mkN "kokoelma" ;
lin collective_A = mkA "kollektiivinen" ;
lin collective_N = mkWN (k5 "kollektiivi") ; --UNCHK
lin collectivism_N = mkWN (k5 "kollektivismi") ; --UNCHK
lin collectivist_A = mkWA (k38 "kollektivistinen") ; --UNCHK
lin collectivist_N = mkWN (k38 "vasemmistolainen") ; --UNCHK
lin collectivization_N = mkWN (compoundN "kollekti" (k5A "vointi")) ; --UNCHK
lin collectivize_V2 = mkWV2 (k62 "kollektivoida") ; --UNCHK
lin collector_N = mkWN (k5 "kollektori") ; --UNCHK
lin colleen_N = mkWN (compoundN "irkku" (k1A "tyttö")) ; --UNCHK
lin college_N = mkWN (k8 "college") ; ---- yliopisto
lin collegial_A = mkWA "collegen" ; --UNCHK
lin collegian_N = mkWN (k41 "oppilas") "collegen" ; --UNCHK
lin collegiate_A = mkWA "collegen" ; --UNCHK
lin collembolan_N = mkWN (compoundN "hyppy" (k38 "häntäinen")) ; --UNCHK
lin collet_N = mkWN (k39 "kehys") "jalokiven" ; --UNCHK
lin collide_V = mkWV (k73 "törmätä") ; --UNCHK
lin collider_N = mkWN (k33A "törmäytin") ; --UNCHK
lin collie_N = mkWN (k3 "collie") ; --UNCHK
lin collier_N = mkWN (compoundN "kaivos" (k38 "työläinen")) ; --UNCHK
lin colliery_N = mkWN (k39 "kaivos") ; --UNCHK
lin colligation_N = mkWN "looginen" "yhdistäminen" ; --UNCHK
lin collimation_N = mkWN "kollimaatio" ; --UNCHK
lin collinear_A = mkWA (compoundA "kol" (k38 "lineaarinen")) ; --UNCHK
lin collins_N = mkWN "Tom" "Collins" ; --UNCHK
lin collision_N = mkWN (compoundN "risti" (k9A "riita")) ; --UNCHK
lin collocate_V = mkWV (k56A "laittaa") "rinnakkain" ; --UNCHK
lin collocation_N = mkWN (k2 "asettelu") "vierekkäin" ; --UNCHK
lin collodion_N = mkWN "kollodi" ; --UNCHK
lin colloid_N = mkWN (k5 "kolloidi") ; --UNCHK
lin colloidal_A = mkWA (k38 "kolloidinen") ; --UNCHK
lin colloquial_A = mkWA (compoundA "arki" (k38 "kielinen")) ; --UNCHK
lin colloquialism_N = mkWN (k39 "ilmaus") "arkikielen" ; --UNCHK
lin colloquium_N = mkWN (k10 "esitelmä") ; --UNCHK
lin colloquy_N = mkWN (k2 "keskustelu") ; --UNCHK
lin collotype_N = mkWN (compoundN "valo" (k1 "paino")) ; --UNCHK
lin collusion_N = mkWN (k39 "sopimus") "salainen" ; --UNCHK
lin collusive_A = mkWA (k38 "vilpillinen") ; --UNCHK
lin colne_PN = foreignPN "Colne" ;
lin colobus_N = mkWN (compoundN "Colobus-" (k12 "apina")) ; --UNCHK
lin cologne_N = mkWN (compoundN "kölnin" (k27 "vesi")) ; --UNCHK
lin cologne_PN = foreignPN "Cologne" ;
lin colombia_PN = foreignPN "Kolumbia" ;
lin colombian_A = mkWA (compoundA "kolumbi" (k38 "alainen")) ; --UNCHK
lin colombian_N = mkWN (compoundN "kolumbi" (k38 "alainen")) ; --UNCHK
lin colombo_PN = foreignPN "Colombo" ;
lin colon_N = mkWN (k50 "paksusuoli") ; --UNCHK
lin colonel_N = mkWN (k5 "eversti") ; --UNCHK
lin colonial_A = mkWA "siirtomaa-" ; --UNCHK
lin colonial_N = mkWN (k41A "asukas") "siirtomaan" ; --UNCHK
lin colonialism_N = mkWN (k5 "kolonialismi") ; --UNCHK
lin colonialist_N = mkWN (k5 "kolonialisti") ; --UNCHK
lin colonic_A = mkWA "paksusuoli-" ; --UNCHK
lin colonist_N = mkWN (compoundN "uudis" (k10 "raivaaja")) ; --UNCHK
lin colonization_N = mkWN (k39 "asutus") ; --UNCHK
lin colonize_V2 = mkWV2 (k53A "asuttaa") ; --UNCHK
lin colonizer_N = mkWN (k10 "perustaja") "siirtokunnan" ; --UNCHK
lin colonnade_N = mkWN (k4A "pylväikkö") ; --UNCHK
lin colonnaded_A = mkWA "pylväikkö-" ; --UNCHK
lin colonoscope_N = mkWN (compoundN "kolonosko" (k5A "oppi")) ; --UNCHK
lin colonoscopy_N = mkWN "kolonoskopia" ; --UNCHK
lin colony_N = mkN "siirtokunta" ; --WN (compoundN "yhdys" (k10A "kunta")) ;
lin colophon_N = mkWN "kolofoni" ; --UNCHK
lin colophony_N = mkWN (compoundN "jousi" (k5 "hartsi")) ; --UNCHK
lin color_A = mkWA (k38 "värillinen") ; --UNCHK
lin colorado_PN = foreignPN "Colorado" ;
lin coloration_N = mkWN (compoundN "värien" (k1A "käyttö")) ; --UNCHK
lin coloratura_N = mkWN (k5 "koloratuuri") ; --UNCHK
lin colorcast_N = mkWN (compoundN "väri" (k39 "lähetys")) ; --UNCHK
lin colorectal_A = mkWA (compoundA "kolorekta" (k38 "alinen")) ; --UNCHK
lin colorfast_A = mkWA (compoundA "värin" (k10 "pitävä")) ; --UNCHK
lin colorimeter_N = mkWN (compoundN "värisävy" (k6 "mittari")) ; --UNCHK
lin colorimetric_A = mkWA "värinmittaukseen" "liittyvä" ; --UNCHK
lin colorimetry_N = mkWN (compoundN "värin" (k39 "mittaus")) ; --UNCHK
lin colorist_N = mkWN (k5 "koloristi") ; --UNCHK
lin colorless_A = mkWA (k34A "väritön") ; --UNCHK
lin colorlessness_N = mkWN (k40 "värittömyys") ; --UNCHK
lin colossal_A = mkWA (k38 "jättiläismäinen") ; --UNCHK
lin colossus_N = mkWN (k6 "titaani") ; --UNCHK
lin colostomy_N = mkWN (k1A "teko") "paksusuoliavanteen" ; --UNCHK
lin colostrum_N = mkWN (compoundN "terni" (k1A "maito")) ; --UNCHK
lin colour_N = mkN "väri" ;
lin colour_V = mkWV (k52A "värjääntyä") ; --UNCHK
lin colour_V2 = mkWV2 (k52A "värjääntyä") ; --UNCHK
lin colour_V2A = mkWV2A (k52A "värjääntyä") ; --UNCHK
lin colour_bar_N = mkWN (compoundN "rotu" (k2 "erottelu")) ; --UNCHK
lin colour_code_V2 = mkV2 "värikoodata" ;
lin colour_wash_N = mkWN (compoundN "pesu" (k39 "värjäys")) ; --UNCHK
lin coloured_A = mkWA (k38 "sävyinen") ; --UNCHK
lin colourful_A = mkWA (k41A "värikäs") | mkWA (k38 "sävyinen") ; --UNCHK
lin colouring_N = mkWN (compoundN "väri" (k38 "ttäminen")) ; --UNCHK
lin colourless_A = mkWA (k34A "väritön") ; --UNCHK
lin colpitis_N = mkWN (compoundN "emätin" (k39 "tulehdus")) ; --UNCHK
lin colpocele_N = mkWN (compoundN "emätin" (k10 "tyrä")) ; --UNCHK
lin colpoxerosis_N = mkWN (k33A "emätin") "kuiva" ; --UNCHK
lin colt_N = mkWN (k9 "varsa") ; --UNCHK
lin colter_N = mkWN (k10 "terä") "auran" ; --UNCHK
lin coltish_A = mkWA (k10 "leikkisä") ; --UNCHK
lin coltsfoot_N = mkWN (compoundN "lesken" (k7A "lehti")) ; --UNCHK
lin columbarium_N = mkWN (compoundN "uurna" (k5 "holvi")) ; --UNCHK
lin columbia_PN = foreignPN "Columbia" ;
lin columbine_N = mkWN (k9 "akileija") ; --UNCHK
lin columbium_N = mkWN (k5 "niobium") ; --UNCHK
lin columbo_N = mkWN (k26 "kolumbojuuri") ; --UNCHK
lin columbus_PN = foreignPN "Columbus" ;
lin columella_N = mkWN "kolumella" ; --UNCHK
lin column_N = mkN "kolumni" ;
lin columnar_A = mkWA (compoundA "pylväs" (k38 "mäinen")) ; --UNCHK
lin columnea_N = mkWN (compoundN "tuli" (k39 "köynnös")) ; --UNCHK
lin columned_A = mkWA (compoundA "pylväs" (k38 "mäinen")) ; --UNCHK
lin columniation_N = mkWN (k2 "sommittelu") "pylväiden" ; --UNCHK
lin columniform_A = mkWA (k38 "muotoinen") "pylvään" ; --UNCHK
lin columnistFem_N = mkWN (k5 "kolumnisti") ; --UNCHK
lin columnistMasc_N = mkWN (k5 "kolumnisti") ; --UNCHK
lin coma_N = mkWN (k40 "tajuttomuus") ; --UNCHK
lin comate_A = mkWA (compoundA "siemen" (k38 "karvallinen")) ; --UNCHK
lin comatose_A = mkWA "kooma-" ; --UNCHK
lin comb_N = mkWN (compoundN "kampa" (k38 "aminen")) ; --UNCHK
lin comb_V = mkWV (k53A "selvittää") ; --UNCHK
lin comb_V2 = mkWV2 (k53A "selvittää") ; --UNCHK
lin combat_N = mkWN (k2 "taistelu") "aseellinen" ; --UNCHK
lin combat_V = mkWV (k67 "taistella") ; --UNCHK
lin combat_V2 = mkV2 (mkV "taistella") (mkPrep "vastaan" partitive) ;
lin combatant_A = mkWA "valmis" "taisteluun" ; --UNCHK
lin combatant_N = mkWN (k12 "ottelija") ; --UNCHK
lin combative_A = mkWA (k10 "sotaisa") ; --UNCHK
lin combativeness_N = mkWN (k40 "sotaisuus") ; --UNCHK
lin comber_N = mkWN (compoundN "kampaus" (k48 "kone")) ; --UNCHK
lin combinable_A = mkWA "yhtyvä" ; --UNCHK
lin combination_N = mkN "yhdistelmä" ; --WN (k3 "kombinaatio") ;
lin combination_lock_N = mkWN (compoundN "numero" (k1A "lukko")) ; --UNCHK
lin combinative_A = mkWA "yhtymä-" ; --UNCHK
lin combinatorial_A = mkWA "kombinatorinen" ; --UNCHK
lin combine_N = mkWN (k6 "puimuri") ; --UNCHK
lin combine_V = mkWV (k53 "yhdistää") ;
lin combine_V2 = mkWV2 (k53 "yhdistää") ;
lin combine_VV = mkWVV (k53 "yhdistää") ; ---- subcat
lin combined_A = variants {} ; --
lin combining_N = mkWN (k3 "kombinaatio") ; --UNCHK
lin combretum_N = mkWN "Combretum" ; --UNCHK
lin comburent_A = mkWA (k10 "palava") ; --UNCHK
lin combustibility_N = mkWN (compoundN "palamis" (k40 "kelpoisuus")) ; --UNCHK
lin combustible_A = mkWA "syttyvä" ; --UNCHK
lin combustible_N = mkWN (k48 "aine") "syttyvä" ; --UNCHK
lin combustion_N = mkWN (k1A "poltto") ; --UNCHK
lin come_V = L.come_V ;
lin come_about_V = mkWV (k65 "käydä") ; --UNCHK
lin come_across_V = mkWV (k63 "saada") "vastakaikua" ; --UNCHK
lin come_across_V2 = mkWV2 (k63 "saada") "vastakaikua" ; --UNCHK
lin come_along_V = mkWV (k52A "kehittyä") ; --UNCHK
lin come_along_with_V2 = prepV2 (advV OP_come_V OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_apart_V = mkWV (k67 "mennä") "rikki" ; --UNCHK
lin come_around_V = mkWV (k52A "saapua") "ajallaan" ; --UNCHK
lin come_around_to_V2 = prepV2 (advV OP_come_V OP_around_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_away_V = mkWV (k52A "irtaantua") ; --UNCHK
lin come_back_V = mkWV (k73 "palata") ; --UNCHK
lin come_before_V2 = mkWV2 (k54A "edeltää") ; --UNCHK
lin come_by_V = mkWV (k54A "löytää") ; --UNCHK
lin come_by_V2 = mkWV2 (k54A "löytää") ; --UNCHK
lin come_down_V = mkWV (k52 "sairastua") ; --UNCHK
lin come_down_on_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin come_down_upon_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_upon_Prep ; -- guess-p-verb
lin come_down_with_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forth_V = mkWV (k67 "tulla") "näkyviin" ; --UNCHK
lin come_forth_with_V2 = prepV2 (advV OP_come_V OP_forth_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forward_V = mkWV (k67 "tulla") "julkisuuteen" ; --UNCHK
lin come_from_V2 = prepV2 OP_come_V OP_from_Prep ; -- guess-p-verb
lin come_in_V = mkWV (k67 "tulla") ; --UNCHK
lin come_in_V2 = mkWV2 (k67 "tulla") ; --UNCHK
lin come_in_for_V2 = mkWV2 (k52A "joutua") "kohteeksi" ; --UNCHK
lin come_into_V2 = mkV2 (mkV (mkV "tulla") "mukaan") illative ;
lin come_into_use_V = variants {} ; -- guess-p-verb
lin come_off_V = mkWV (k67 "tulla") "ymmärretyksi" ; --UNCHK
lin come_off_V2 = mkWV2 (k67 "tulla") "ymmärretyksi" ; --UNCHK
lin come_off_it_V = variants {} ; -- guess-p-verb
lin come_on_V = mkWV (k52A "kehittyä") ; --UNCHK
lin come_out_V = mkWV (k52A "näyttäytyä") ; --UNCHK
lin come_out_in_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin come_out_of_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin come_out_with_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_over_V = mkWV (k71 "tehdä") "tiettäväksi" ; --UNCHK
lin come_over_V2 = mkWV2 (k71 "tehdä") "tiettäväksi" ; --UNCHK
lin come_round_V = advV OP_come_V OP_round_Adv ; -- guess-p-verb
lin come_through_V = mkV (mkV "päästä") "läpi" ; --UNCHK
lin come_through_with_V2 = prepV2 (advV OP_come_V OP_through_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_to_V = mkWV (k67 "tulla") "tajuihinsa" ; --UNCHK
lin come_to_V2 = mkV2 (mkV "tulla") illative ;
lin come_up_V = mkV "ilmaantua" ;
lin come_up_against_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_against_Prep ; -- guess-p-verb
lin come_up_to_V2 = mkWV2 (k52 "lähestyä") ; --UNCHK
lin come_up_with_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_upon_V2 = mkWV2 (k63 "saada") "tuurilla" ; --UNCHK
lin come_with_V2 = mkWV2 (k65 "käydä") ; --UNCHK
lin comeback_N = mkWN (k17 "paluu") ; --UNCHK
lin comedian_N = mkWN (k4A "koomikko") ;
lin comedienne_N = mkWN (k8 "komedienne") ; --UNCHK
lin comedown_N = mkWN (compoundN "arvon" (k39 "alennus")) ; --UNCHK
lin comedy_N = mkN "komedia" ;
lin comeliness_N = mkWN (k40 "ihanuus") ; --UNCHK
lin comely_A = mkWA (k15 "komea") ; --UNCHK
lin comer_N = mkWN (k12 "tulija") ; --UNCHK
lin comestible_N = mkWN (k10 "muona") ; --UNCHK
lin comet_N = mkWN (k9A "komeetta") ; --UNCHK
lin cometary_A = mkWA (compoundA "pyrstö" (k38 "tähtimäinen")) ; --UNCHK
lin comfit_N = mkWN (k12 "pähkinä") "sokeroitu" ; --UNCHK
lin comfort_N = mkWN (k7A "tuki") ; --UNCHK
lin comfort_V2 = mkWV2 (k53A "lievittää") ; --UNCHK
lin comfortable_A = mkA "mukava" ;
lin comfortableness_N = mkWN (compoundN "hyvin" (k5A "vointi")) ; --UNCHK
lin comforter_N = mkWN (k5A "huvitutti") ; --UNCHK
lin comforting_A = mkWA (k38 "lohdullinen") ; --UNCHK
lin comfortless_A = mkWA (compoundA "epä" (k41A "kodikas")) ; --UNCHK
lin comfrey_N = mkWN (compoundN "raunio" (k5A "yrtti")) ; --UNCHK
lin comfy_A = mkWA (k10 "lokoisa") ; --UNCHK
lin comic_A = mkWA (k38 "koominen") ; --UNCHK
lin comic_N = mkWN (k4A "koomikko") ; --UNCHK
lin comical_A = mkWA (k1 "hassu") ; --UNCHK
lin comicality_N = mkWN (k40 "koomisuus") ; --UNCHK
lin coming_A = mkA "tuleva" ;
lin coming_N = mkWN "saapuminen" ; --UNCHK
lin comity_N = mkWN (k1A "sopu") ; --UNCHK
lin comma_N = mkWN (compoundN "herukka" (k38 "perhonen")) ; --UNCHK
lin command_1_N = variants {} ; --
lin command_2_N = variants {} ; --
lin command_N = mkWN (k9A "hallinta") ; --UNCHK
lin command_V = mkWV (k58 "käskeä") ; --UNCHK
lin command_V2 = mkWV2 (k58 "käskeä") ; --UNCHK
lin commandant_N = mkWN (k10 "komentaja") ; --UNCHK
lin commandeer_V2 = mkWV2 (k53 "ryöstää") ; --UNCHK
lin commander_N = mkWN (k10 "komentaja") ;
lin commandership_N = mkWN (k40 "päällikkyys") ; --UNCHK
lin commandment_N = mkWN (k5A "oppi") ; --UNCHK
lin commando_N = mkWN (compoundN "isku" (k1A "joukko")) ; --UNCHK
lin commelina_N = mkWN "soljo" ; --UNCHK
lin commemorate_V2 = mkV2 (mkV "muistella") partitive ;
lin commemoration_N = mkWN (k2 "muistelu") ; --UNCHK
lin commemorative_A = mkWA "muisto-" ; --UNCHK
lin commemorative_N = mkWN "muisto-" ; --UNCHK
lin commence_V = variants {} ; -- mkV2 "aloittaa" ;
lin commence_V2 = mkV2 "aloittaa" ;
lin commencement_N = mkWN (k39 "aloitus") ; --UNCHK
lin commend_V2 = mkWV2 (k53 "ylistää") ; --UNCHK
lin commendable_A = mkWA (k10 "kunnioitettava") ; --UNCHK
lin commendation_N = mkWN (k39 "suositus") ; --UNCHK
lin commensal_A = mkWA (compoundA "kommensa" (k38 "alinen")) ; --UNCHK
lin commensal_N = mkWN (compoundN "pöytä" (k41 "vieras")) ; --UNCHK
lin commensalism_N = mkWN (compoundN "pöytävieras" (k48A "suhde")) ; --UNCHK
lin commensurable_A = mkWA (compoundA "yhteis" (k38 "mitallinen")) ; --UNCHK
lin commensurateness_N = mkWN (k40 "suhteellisuus") ; --UNCHK
lin comment_N = mkN "kommentti" ;
lin comment_V = mkV "kommentoida" ;
lin comment_V2 = variants {} ; -- mkV "kommentoida" ;
lin comment_VS = mkVS "kommentoida" ;
lin commentary_N = mkWN (k39 "selitys") ; --UNCHK
lin commentate_V = mkWV (k53 "selostaa") ; --UNCHK
lin commentator_N = mkN (lin NK {s = d06 "kommentaattori"}) ;
lin commerce_N = mkN "kauppa" ; --mkWN (k40 "kaupallisuus") ;
lin commercial_A = mkWA (k38 "kaupallinen") ;
lin commercial_N = mkWN (k39 "mainos") ;
lin commercialism_N = mkWN (k40 "kaupallisuus") ; --UNCHK
lin commercialization_N = mkWN (compoundN "kaupallis" (k38 "taminen")) ; --UNCHK
lin commercialize_V2 = mkV2 "kaupallistaa" ; --WV2 (k62 "markkinoida") ;
lin commination_N = mkWN (k10 "uhka") "Jumalan" "koston" ; --UNCHK
lin comminatory_A = mkWA (k10 "arvosteleva") "ankarasti" ; --UNCHK
lin commingle_V = mkWV (k52A "sulautua") ; --UNCHK
lin commingle_V2 = mkWV2 (k52A "sulautua") ; --UNCHK
lin commiserate_V = mkWV (k53A "osoittaa") "sympatiaa" ; --UNCHK
lin commiseration_N = mkWN (compoundN "osan" (k1A "otto")) ; --UNCHK
lin commiserative_A = mkWA (compoundA "myötätun" (k38 "toinen")) ; --UNCHK
lin commissar_N = mkWN (k5 "komissaari") ; --UNCHK
lin commissariat_N = mkWN (k10A "ruoka") ; --UNCHK
lin commissary_N = mkWN (k6 "kanttiini") ; --UNCHK
lin commission_N = mkN (lin NK {s = d03 "komissio"}) ;
lin commission_V2 = mkWV2 (k56A "antaa") "tehtäväksi" ;
lin commission_V2V = mkWV2V (k56A "antaa") "tehtäväksi" ; --UNCHK
lin commissionaire_N = mkWN (compoundN "vahti" (k6 "mestari")) ; --UNCHK
lin commissioner_N = mkWN "hallintovirkamies" ; --UNCHK
lin commissure_N = mkWN (k9 "sauma") ; --UNCHK
lin commit_V2 = mkV2 "harjoittaa" ; --f59 ---ARB ; tehdä ; velvoittaa , sitouttaa
lin commitment_N = mkN "sitoumus" ;
lin committedness_N = mkWN (k39 "vakaumus") ; --UNCHK
lin committee_N = mkN "komitea" "komiteoita" ;
lin committeeman_N = mkWN (k32 "jäsen") "valiokunnan" ; --UNCHK
lin committeewoman_N = mkWN (k32 "jäsen") "valiokunnan" ; --UNCHK
lin commode_1_N = mkWN (k2 "lipasto") ; --UNCHK
lin commode_2_N = mkWN (k2 "lipasto") ; --UNCHK
lin commodious_A = mkWA (k10 "sopiva") ; --UNCHK
lin commodity_N = mkN "hyödyke" ;
lin commodore_N = mkWN (k5 "kommodori") ; --UNCHK
lin common_1_A = mkA "tavallinen" ;
lin common_2_A = mkA "yhteinen" ;
lin common_A = mkA "tavallinen" ;
lin common_N = mkWN (k10A "kenttä") ; --UNCHK
lin common_room_N = mkWN (compoundN "olo" (k48 "huone")) ; --UNCHK
lin commonage_N = mkWN (compoundN "yhteis" (k18 "maa")) ; --UNCHK
lin commonality_N = mkWN (k48A "piirre") "yhteinen" ; --UNCHK
lin commonalty_N = mkWN (k1A "sääty") "kolmas" ; --UNCHK
lin commoner_N = mkWN (k38 "ihminen") "tavallinen" ; --UNCHK
lin commonness_N = mkWN (k48A "piirre") "yhteinen" ; --UNCHK
lin commonplace_A = mkWA (k38 "yksitoikkoinen") ; --UNCHK
lin commonplace_N = mkN "tavanomainen" ;
lin commons_N = mkWN (k1A "sääty") "kolmas" ; --UNCHK
lin commonsense_A = mkWA (k7A "järki") "terve" ; --UNCHK
lin commonwealth_N = mkWN (k33 "elin") "poliittinen" ; --UNCHK
lin commotion_N = mkWN (k12 "rähinä") ; --UNCHK
lin communal_A = mkWA (k38 "kunnallinen") ; --UNCHK
lin communalism_N = mkWN (compoundN "etnosentr" (k40 "isyys")) ; --UNCHK
lin commune_N = mkWN (k6 "kommuuni") ; --UNCHK
lin communicable_A = mkWA "helposti" "välitettävä" ; --UNCHK
lin communicant_N = mkWN (compoundN "ehtoollis" (k41 "vieras")) ; --UNCHK
lin communicate_V = mkWV (k67 "olla") "vuorovaikutuksessa" ; --UNCHK
lin communicate_V2 = mkWV2 (k67 "olla") "vuorovaikutuksessa" ; --UNCHK
lin communication_N = mkN "kommunikaatio" | mkN "tiedon" (mkN "välitys") ;
lin communicational_A = mkWA "viesti-" ; --UNCHK
lin communications_N = mkWN (compoundN "informaatio" (k12 "teoria")) ; --UNCHK
lin communicative_A = mkWA (k41 "puhelias") ; --UNCHK
lin communicativeness_N = mkWN (k40 "puheliaisuus") ; --UNCHK
lin communicator_N = mkWN "viestijä" ; --UNCHK
lin communion_N = mkWN (k12 "ateria") "pyhä" ; --UNCHK
lin communique_N = mkWN (k12 "kommunikea") ; --UNCHK
lin communism_N = mkWN (k5 "kommunismi") ; --UNCHK
lin communist_A = mkA "kommunistinen" ;
lin communist_N = mkWN (compoundN "Bordeaux-" (k39 "seos")) ; --UNCHK
lin community_N = mkN "yhteisö" ;
lin communization_N = mkWN (k38 "tekeminen") "kommunistiseksi" ; --UNCHK
lin commutability_N = mkWN (k40 "vaihdettavuus") ; --UNCHK
lin commutable_A = mkWA (k10 "oleva") "muunnettavissa" ; --UNCHK
lin commutation_N = mkWN (k1A "vaihto") ; --UNCHK
lin commutator_N = mkWN (k6 "kommutaattori") ; --UNCHK
lin commute_N = mkWN (compoundN "työ" (k9 "matka")) ; --UNCHK
lin commute_V = mkWV (k54A "muuntaa") ; --UNCHK
lin commute_V2 = mkWV2 (k54A "muuntaa") ; --UNCHK
lin commuter_N = mkWN (compoundN "työmatka" (k10 "juna")) ; --UNCHK
lin compact_A = mkWA (k41 "tiivis") ;
lin compact_N = mkWN (compoundN "puuteri" (k12 "rasia")) ; --UNCHK
lin compact_V2 = mkWV2 (k56A "ahtaa") ; --UNCHK
lin compaction_N = mkWN (k39 "puristus") ; --UNCHK
lin compactness_N = mkWN (k40 "tiiviys") ; --UNCHK
lin companion_N = mkWN (k38 "seuralainen") ;
lin companionability_N = mkWN (k40 "sosiaalisuus") ; --UNCHK
lin companionable_A = mkWA (k38 "seurallinen") ; --UNCHK
lin companionate_A = mkWA (k38 "toverillinen") ; --UNCHK
lin companionship_N = mkWN (k40 "kumppanuus") ; --UNCHK
lin company_1_N = mkN "yhtiö" ;
lin company_2_N = mkN "seura" ;
lin comparability_N = mkWN (k40 "vastaavuus") ; --UNCHK
lin comparable_A = mkWA (k10 "oleva") "verrattavissa" ; --f60
lin comparative_A = mkWA (k38 "relatiivinen") ; --UNCHK
lin comparative_N = mkWN (k5 "komparatiivi") ; --UNCHK
lin compare_N = mkWN (k40 "vastaavuus") ; --UNCHK
lin compare_V = mkV "verrata" ;
lin comparison_N = mkWN (k2 "vertailu") ;
lin compartment_N = mkWN (k2 "osasto") ; --UNCHK
lin compartmental_A = mkWA (compoundA "lokero" (k1A "itu")) ; --UNCHK
lin compartmentalization_N = mkWN (k2 "lajittelu") ; --UNCHK
lin compartmentalize_V2 = mkWV2 (k67A "jaotella") ; --UNCHK
lin compartmented_A = mkWA (compoundA "lokero" (k1A "itu")) ; --UNCHK
lin compass_N = mkWN (k5 "kompassi") ; --UNCHK
lin compass_V2 = mkWV2 (k74 "tajuta") ; --UNCHK
lin compassion_N = mkWN (k5 "sääli") ; --UNCHK
lin compassionate_A = mkWA (k38 "ymmärtäväinen") ; --UNCHK
lin compatibility_N = mkWN (k40 "soveltuvuus") "yhteen" ; --UNCHK
lin compatible_A = mkA (mkN "yhteen" (mkN "sopiva")) ; --mkWA (compoundA "sopu" (k38 "sointuinen")) ;
lin compatriotFem_N = mkWN (compoundN "maan" (k42 "mies")) ; --UNCHK
lin compatriotMasc_N = mkWN (compoundN "maan" (k42 "mies")) ; --UNCHK
lin compeer_N = mkWN (k38 "vertainen") ; --UNCHK
lin compel_V2 = mkWV2 (k53A "edellyttää") ; --UNCHK
lin compel_V2V = mkWV2V (k53A "edellyttää") ; --UNCHK
lin compel_VV = mkWVV (k53A "edellyttää") ; --UNCHK
lin compelling_A = mkWA (k10 "vakuuttava") ; --UNCHK
lin compendious_A = mkWA (k5 "kompakti") ; --UNCHK
lin compendium_N = mkWN (k10 "tiivistelmä") ; --UNCHK
lin compensable_A = mkWA (k10 "tuottoisa") ; --UNCHK
lin compensate_V = mkWV (k62 "kompensoida") ;
lin compensate_V2 = mkWV2 (k62 "kompensoida") ; --UNCHK
lin compensation_N = mkN "korvaus" ;
lin compensatory_A = mkA "korvaava" ;
lin compere_N = mkWN (k10 "juontaja") ; --UNCHK
lin compere_V2 = mkWV2 (k53A "kuuluttaa") ; --UNCHK
lin compete_V = mkV (lin VK {s = c67 "kilpailla"}) ;
lin competence_N = mkWN (k40 "pätevyys") ; --UNCHK
lin competent_A = mkA "kompetentti" ;
lin competition_N = mkWN (k2 "kilpailu") ;
lin competitive_A = mkWA "kilpailu-" ; --f77
lin competitiveness_N = mkN "kilpailu" (mkN "kyky") ;
lin competitor_N = mkN "kilpailija" ;
lin compilation_N = mkWN (compoundN "toi" (k38 "mittaminen")) "kokoomateoksen" ; --UNCHK
lin compile_V2 = mkWV2 (k53 "koostaa") ; --UNCHK
lin compiler_N = mkWN (k10 "kääntäjä") "ohjelmointikielen" ; --UNCHK
lin complacence_N = mkWN (k40 "omahyväisyys") ; --UNCHK
lin complacency_N = mkWN (k40 "omahyväisyys") ; --UNCHK
lin complacent_A = mkWA (k38 "itseriittoinen") ; --UNCHK
lin complain_V = mkV "valittaa" ;
lin complain_VS = mkVS "valittaa" ; --WVS (k53 "nostaa") "kanne" ;
lin complainant_N = mkWN (k10 "kantaja") ; --UNCHK
lin complainingly_Adv = mkWAdv "valittaen" ; --UNCHK
lin complaint_N = mkWN (k48A "kanne") ; --f61
lin complaisance_N = mkWN (k39 "kunnioitus") ; --UNCHK
lin complaisant_A = mkWA (k38 "ystävällinen") ; --UNCHK
lin complement_N = mkWN (k48A "lisäke") ; --UNCHK
lin complement_V2 = mkWV2 (k54A "täydentää") ;
lin complemental_A = mkWA (k38 "komplementaarinen") ; --UNCHK
lin complementarity_N = mkWN "toisiaan" "täydentävyys" ; --UNCHK
lin complementary_A = mkWA (k38 "komplementaarinen") ; --UNCHK
lin complementation_N = mkWN (k3 "distribuutio") "komplementaarinen" ; --UNCHK
lin complete_A = mkA "täydellinen" ;
lin complete_V = mkWV (k54A "täydentää") ;
lin complete_V2 = mkV2 (mkV "täydentää") partitive ;
lin completeness_N = mkWN (k40 "täydellisyys") ;
lin completion_N = mkWN (k1A "loppu") ; --UNCHK
lin complex_A = mkA "monimutkainen" ;
lin complex_N = mkWN (k5 "kompleksi") ;
lin complexifier_N = mkWN "mutkistaja" ; --UNCHK
lin complexion_N = mkWN (k5A "temperamentti") ; --UNCHK
lin complexity_N = mkWN (k40 "mutkikkuus") ; --UNCHK
lin compliance_N = mkWN (compoundN "ali" (k38 "stuminen")) ; --UNCHK
lin compliant_A = mkWA (k38 "suostuvainen") ; --UNCHK
lin complicate_V2 = mkV2 "monimutkaistaa" partitive ;
lin complicated_A = variants {} ; --
lin complicatedness_N = mkWN (compoundN "kiemu" (k40 "raisuus")) ; --UNCHK
lin complication_N = mkN "komplikaatio" ;
lin complicity_N = mkWN (compoundN "rikos" (k40 "kumppanuus")) ; --UNCHK
lin compliment_N = mkWN (k40 "kohteliaisuus") ; --UNCHK
lin compliment_V2 = mkWV2 (k52 "lausua") "kohteliaisuus" ; --UNCHK
lin complimentary_A = mkWA "mairitteleva" ; --UNCHK
lin complin_N = mkWN "kompletorio" ; --UNCHK
lin compline_N = mkWN "kompletorio" ; --UNCHK
lin comply_V = mkWV (k52A "taipua") ; --UNCHK
lin comply_V2 = mkWV2 (k52A "taipua") ; --UNCHK
lin component_N = mkWN (k5A "komponentti") ;
lin comport_V = mkWV (k52A "liikkua") ; --UNCHK
lin comport_V2 = mkWV2 (k52A "liikkua") ; --UNCHK
lin comportment_N = mkWN (k39 "olemus") ; --UNCHK
lin compos_mentis_A = mkWA (k38 "syyntakeinen") ; --UNCHK
lin compose_V = mkWV (k61A "laatia") ; --UNCHK
lin compose_V2 = mkWV2 (k61A "laatia") ;
lin composer_N = mkWN (k10 "säveltäjä") ;
lin composing_N = mkWN (compoundN "sävel" (k38 "täminen")) ; --UNCHK
lin composite_A = mkA "yhdistetty" ;
lin composite_N = mkWN (k10 "yhdistelmä") ; --UNCHK
lin compositeness_N = mkWN (k1A "luku") "yhdistetty" ; --UNCHK
lin composition_N = mkWN (k2 "kynäily") ; --UNCHK
lin compositional_A = mkWA "koostumus-" ; --UNCHK
lin compositor_N = mkWN (k10 "latoja") ; --UNCHK
lin compost_N = mkWN (k5 "komposti") ; --UNCHK
lin compost_V2 = mkWV2 (k62 "kompostoida") ; --UNCHK
lin composure_N = mkWN (k40 "rauhallisuus") ; --UNCHK
lin compote_N = mkWN (k5A "kompotti") ; --UNCHK
lin compound_A = mkWA (k38 "kerrannainen") ; --UNCHK
lin compound_N = mkWN "kampong" ; --UNCHK
lin compound_V = mkWV (k53 "yhdistää") ; --UNCHK
lin compound_V2 = mkWV2 (k53 "yhdistää") ;
lin comprehend_V2 = mkWV2 (k74 "tajuta") ; --UNCHK
lin comprehensibility_N = mkWN (k40 "ymmärrettävyys") ; --UNCHK
lin comprehensible_A = mkWA (k10 "ymmärrettävä") ; --UNCHK
lin comprehension_N = mkWN (k39 "ymmärrys") ; --UNCHK
lin comprehensive_A = mkWA "kattava" ;
lin comprehensiveness_N = mkWN (k40 "monipuolisuus") ; --UNCHK
lin compress_N = mkWN (k5 "kompressi") ; --UNCHK
lin compress_V2 = mkWV2 (k56A "ahtaa") ; --UNCHK
lin compressibility_N = mkWN (k40 "huokoisuus") ; --UNCHK
lin compression_N = mkWN (compoundN "pai" (k38 "neistaminen")) ; --UNCHK
lin compressor_N = mkWN (k6 "kompressori") ; --UNCHK
lin comprise_V2 = mkWV2 (k54A "sisältää") ; --UNCHK
lin compromise_N = mkWN (k5 "kompromissi") ; --f56
lin compromise_V = mkWV (k67A "sovitella") ;
lin compromise_V2 = mkWV2 (k67A "sovitella") ; --UNCHK
lin compromiser_N = mkWN (k12 "sovittelija") ; --UNCHK
lin comptroller_N = mkWN (k10 "valvoja") "varainhoidon" ; --UNCHK
lin comptrollership_N = mkWN (k9A "virka") "valtion" "tilintarkastajan" ; --UNCHK
lin compulsion_N = mkWN (k1A "pakko") ; --UNCHK
lin compulsive_A = mkWA (k41A "tarmokas") ; --UNCHK
lin compulsive_N = mkWN (compoundN "pakko" (k4A "neurootikko")) ; --UNCHK
lin compulsiveness_N = mkWN (compoundN "pakkomielte" (k40 "isyys")) ; --UNCHK
lin compulsory_A = mkA "pakollinen" ;
lin compunction_N = mkWN (k39 "katumus") ; --UNCHK
lin computable_A = mkWA (k10 "oleva") "arvioitavissa" ; --UNCHK
lin computation_N = mkWN (k9A "laskenta") ; --UNCHK
lin computational_A = mkWA "tietokone-" ; --UNCHK
lin compute_V = mkWV (k58 "laskea") ;
lin compute_V2 = mkWV2 (k58 "laskea") ; --UNCHK
lin computer_N = L.computer_N ;
lin computer_science_N = mkN "tietojenkäsittelyoppi" ;
lin computerization_N = mkWN (compoundN "tietojen" (k2 "käsittely")) "automaattinen" ; --UNCHK
lin computerize_V2 = mkV2 "tietokoneistaa" ;
lin computing_N = variants {} ; --
lin comrade_N = mkWN (k6 "toveri") ; --UNCHK
lin comradely_A = mkWA (k99 "toverillisesti") ; --UNCHK
lin comradely_Adv = adjAdv comradely_A ; -- derived
lin comradeship_N = mkWN (k40 "ystävyys") ; --UNCHK
lin con_Adv = mkWAdv (k99 "vastaan") ; --UNCHK
lin con_N = mkWN (k39 "huijaus") ; --UNCHK
lin con_V2 = mkWV2 (k56 "painaa") "muistiin" ; --UNCHK
lin con_man_N = mkWN (k10 "petkuttaja") ; --UNCHK
lin conacaste_N = mkWN (compoundN "cycloc" (k9A "arpa")) "Enterolobium" ; --UNCHK
lin concatenation_N = mkWN (k39 "ketjutus") ; --UNCHK
lin concave_A = mkWA (k10 "kovera") ; --UNCHK
lin concavity_N = mkWN (k40 "koveruus") ; --UNCHK
lin conceal_V2 = mkWV2 (k53A "peittää") ;
lin conceale_V = mkV "salata" ;
lin concealment_N = mkWN (k2 "salailu") ; --UNCHK
lin concede_V = mkV (mkV "antaa") "myöten" ; --mkWV (k54A "myöntää") ;
lin concede_V2 = mkWV2 (k54A "myöntää") ; --UNCHK
lin concede_VS = mkVS (mkV "tunnustaa") ; --f56
lin conceit_N = mkWN (k40 "turhamaisuus") ; --UNCHK
lin conceited_A = mkWA (k38 "turhamainen") ; --UNCHK
lin conceivable_A = mkWA (k10 "oleva") "kuviteltavissa" ; --UNCHK
lin conceivableness_N = mkWN (k40 "mahdollisuus") ; --UNCHK
lin conceive_V = mkWV (k67 "tulla") "raskaaksi" ; --UNCHK
lin conceive_V2 = mkWV2 (k67 "tulla") "raskaaksi" ; --UNCHK
lin concentrate_N = mkWN "malliesimerkki" ; --UNCHK
lin concentrate_V = mkV "keskittyä" ; --WV (k53A "kiehuttaa") "vähiin" ;
lin concentrate_V2 = mkWV2 (k53A "kiehuttaa") "vähiin" ; --UNCHK
lin concentrated_A = mkA "keskittynyt" ;
lin concentration_N = mkN "keskittyminen" ;
lin concentric_A = mkWA (compoundA "saman" (k38 "keskinen")) ; --UNCHK
lin concentricity_N = mkWN (k40 "samankeskisyys") ; --UNCHK
lin concept_N = mkN "käsite" | mkN "konsepti" ;
lin conception_N = mkN "käsitys" ; ---ARB --mkWN (compoundN "hede" (k38 "lmöittyminen")) ;
lin conceptional_A = mkWA (k38 "teoreettinen") ; --UNCHK
lin conceptive_A = mkWA (k38 "hedelmällinen") ; --UNCHK
lin conceptual_A = mkWA (k38 "käsitteellinen") ; --UNCHK
lin conceptualism_N = mkWN (compoundN "konseptual" (k5 "ismi")) ; --UNCHK
lin conceptualistic_A = mkWA "konseptualistinen" ; --UNCHK
lin conceptualization_N = mkWN (k2 "muotoilu") ; --UNCHK
lin concern_N = mkN "konserni" ;
lin concern_V2 = mkV2 (mkV vOlla "tekemistä") (mkPrep "kanssa") ; --f65
lin concerned_A = mkA "tarkoitettu" ;
lin concerning_Prep = mkPrep "mitä tulee" illative ; --
lin concert_N = mkWN (k5A "konsertti") ;
lin concert_V2 = mkWV2 (k61A "sopia") ; --UNCHK
lin concert_hall_N = mkWN (compoundN "konsertti" (k5 "sali")) ; --UNCHK
lin concertina_N = mkWN (compoundN "käsi" (k9A "harmonikka")) ; --UNCHK
lin concerto_N = mkWN (k1A "konsertto") ; --UNCHK
lin concession_N = mkWN (compoundN "toimi" (k10A "lupa")) ; --UNCHK
lin concessionaire_N = mkWN (compoundN "toimiluvan" (k12 "haltija")) ; --UNCHK
lin conch_N = mkWN (k2 "kotilo") ; --UNCHK
lin concha_N = mkWN (k4A "kuorikko") ; --UNCHK
lin conchfish_N = mkWN "Astrapogon" "stellatus" ; --UNCHK
lin conchologist_N = mkWN (k12 "tutkija") "näkinkenkien" ; --UNCHK
lin conchology_N = mkWN (compoundN "kerä" (k38 "ileminen")) "näkinkuorien" ; --UNCHK
lin concierge_N = mkWN (compoundN "oven" (k12 "vartija")) ; --UNCHK
lin conciliate_V2 = mkWV2 (k63 "saada") "sopimaan" ; --UNCHK
lin conciliation_N = mkWN (k2 "sovittelu") ; --UNCHK
lin conciliator_N = mkWN (k12 "sovittelija") ; --UNCHK
lin conciliatory_A = mkWA (k38 "sovinnollinen") ; --UNCHK
lin concise_A = mkWA (k41A "ytimekäs") ; --UNCHK
lin conciseness_N = mkWN (k40 "ytimekkyys") ; --UNCHK
lin conclave_N = mkWN (k2 "neuvottelu") "salainen" ; --UNCHK
lin conclude_V = mkWV (k67A "päätellä") ; --UNCHK
lin conclude_V2 = mkWV2 (k67A "päätellä") ; --UNCHK
lin conclude_VS = mkWVS (k67A "päätellä") ; --f52
lin conclusion_N = mkWN (compoundN "pää" (k38 "ttäminen")) ; --UNCHK
lin conclusive_A = mkWA (k10 "ratkaiseva") ; --UNCHK
lin concoct_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin concoction_N = mkWN (compoundN "valmis" (k38 "taminen")) ; --UNCHK
lin concomitance_N = mkWN (compoundN "saman" (k40 "aikaisuus")) ; --UNCHK
lin concomitant_A = mkA "liittyvä" ;
lin concomitant_N = mkWN (k10 "sattuma") ; --UNCHK
lin concordance_N = mkWN (k1 "hakemisto") ; --UNCHK
lin concordat_N = mkWN (k39 "sopimus") ; --UNCHK
lin concourse_N = mkWN (compoundN "väen" (k39 "tungos")) ; --UNCHK
lin concrete_A = mkWA (k38 "konkreettinen") ; --UNCHK
lin concrete_N = mkWN (k6 "betoni") ; --UNCHK
lin concreteness_N = mkWN (k40 "konkreettisuus") ; --UNCHK
lin concretion_N = mkWN (compoundN "yhteen" (k38 "liityminen")) ; --UNCHK
lin concretism_N = mkWN (k39 "esitys") "konkreettinen" ; --UNCHK
lin concretistic_A = mkWA (k38 "konkreettinen") ; --UNCHK
lin concubinage_N = mkWN (compoundN "konkubi" (k5A "naatti")) ; --UNCHK
lin concubine_N = mkWN (k32A "rakastajatar") ; --UNCHK
lin concupiscence_N = mkWN (k40 "himokkuus") ; --UNCHK
lin concur_V = mkV "yhtyä" ;
lin concurrence_N = mkWN (compoundN "myötä" (k39 "vaikutus")) ; --UNCHK
lin concurrent_A = mkWA (k38 "rinnakkainen") ; --UNCHK
lin concuss_V2 = mkWV2 (k53A "aiheuttaa") "aivotärähdys" ; --UNCHK
lin concussion_N = mkWN (k1 "isku") ; --UNCHK
lin condemn_V2 = mkWV2 (k69 "tuomita") ; --UNCHK
lin condemnable_A = mkWA (k38 "paheellinen") ; --UNCHK
lin condemnation_N = mkWN (k3 "tuomio") ; --UNCHK
lin condemnatory_A = mkWA "langettava" ; --UNCHK
lin condensate_N = mkWN (k3 "kondensaatio") ; --UNCHK
lin condensation_N = mkWN (k39 "tiivistys") ; --UNCHK
lin condense_V = mkWV (k53 "tiivistää") ; --UNCHK
lin condense_V2 = mkWV2 (k53 "tiivistää") ; --UNCHK
lin condenser_N = mkWN (k6 "kondensaattori") ; --UNCHK
lin condensing_N = mkWN (k39 "tiivistys") ; --UNCHK
lin condescend_V = mkWV (k52A "suhtautua") "alentuvasti" ; --UNCHK
lin condescendingly_Adv = mkWAdv (k99 "alentuvasti") ; --UNCHK
lin condescension_N = mkWN (k40 "armollisuus") ; --UNCHK
lin condign_A = mkWA (compoundA "ansa" (k1 "ittu")) ; --UNCHK
lin condiment_N = mkWN (k48 "mauste") ; --UNCHK
lin condition_1_N = mkN "ehto" ;
lin condition_2_N = mkN "olosuhde" ;
lin condition_N = mkN "ehto" ;
lin condition_V2 = mkWV2 (k53A "käyttää") "hoitoainetta" ; --UNCHK
lin conditional_A = mkA "ehdollinen" ;
lin conditionality_N = mkWN (k40 "ehdollisuus") ; --UNCHK
lin conditioner_N = mkWN (k2 "kuntoilu") ; --UNCHK
lin conditioning_N = mkWN (compoundN "ehdollis" (k38 "taminen")) ; --UNCHK
lin conditions_N = mkWN (k18 "sää") ; --UNCHK
lin condole_V = mkWV (k53A "valittaa") "surua" ; --UNCHK
lin condolence_N = mkWN (compoundN "osan" (k1A "otto")) ; --UNCHK
lin condolent_A = mkWA "surua" "valittava" ; --UNCHK
lin condom_N = mkWN (k5A "kortonki") ; --UNCHK
lin condominium_N = mkWN (compoundN "asunto-osake" (k3 "yhtiö")) ; --UNCHK
lin condonation_N = mkWN (compoundN "anteeksi" (k1A "anto")) ; --UNCHK
lin condone_V2 = mkWV2 (k69 "suvaita") ; --UNCHK
lin condor_N = mkWN (compoundN "korppi" (k10 "kotka")) ; --UNCHK
lin conduce_V = mkWV (k67 "olla") "osallisena" ; --UNCHK
lin conducive_A = mkWA (compoundA "myötä" (k10 "vaikuttava")) ; --UNCHK
lin conduct_N = mkWN (k9A "toiminta") ; --UNCHK
lin conduct_V = mkWV (k53A "johtaa") ; --UNCHK
lin conduct_V2 = mkWV2 (k53A "johtaa") ; --f57
lin conductance_N = mkWN (k40 "johtavuus") ; --UNCHK
lin conducting_N = mkWN "johtaminen" ; --UNCHK
lin conduction_N = mkWN (k40 "johtavuus") ; --UNCHK
lin conductive_A = mkWA (k10 "johtava") ; --UNCHK
lin conductivity_N = mkWN (k40 "johtavuus") ; --UNCHK
lin conductor_N = mkN "johdin" ; ---ARB ; rahastaja ; kapellimestari
lin conductress_N = mkWN (k10 "johtaja") ; --UNCHK
lin conduit_N = mkWN (k7 "putki") ;
lin condylar_A = mkWA "nivelnastan" ; --UNCHK
lin condyle_N = mkWN (compoundN "nivel" (k9 "nasta")) ; --UNCHK
lin cone_N = mkWN (k3 "kartio") ; --UNCHK
lin cone_V2 = mkWV2 (k54A "suipentaa") ; --UNCHK
lin coneflower_N = mkWN (compoundN "päivän" (k1A "hattu")) ; --UNCHK
lin conenose_N = mkWN "Triatominae" ; --UNCHK
lin coney_N = mkWN (kH1 "kani") ; --UNCHK
lin confab_N = mkWN (k2 "keskustelu") ; --UNCHK
lin confab_V = mkWV (k67A "neuvotella") ; --UNCHK
lin confabulate_V = mkWV (k67A "neuvotella") ; --UNCHK
lin confabulation_N = mkWN (k2 "satuilu") ; --UNCHK
lin confection_N = mkWN (compoundN "valmis" (k38 "taminen")) ; --UNCHK
lin confectioner_N = mkWN (k6 "kondiittori") ; --UNCHK
lin confectionery_N = mkWN (k19 "työ") "sokerileipurin" ; --UNCHK
lin confederacy_N = mkWN (compoundN "sala" (k1A "liitto")) ; --UNCHK
lin confederate_A = mkWA "etelävaltioiden" ; --UNCHK
lin confederate_N = mkWN (k38 "osallinen") ; --UNCHK
lin confederate_V = mkWV (k53 "muodostaa") "valtioliitto" ; --UNCHK
lin confederate_V2 = mkWV2 (k53 "muodostaa") "valtioliitto" ; --UNCHK
lin confederation_N = mkWN (compoundN "liitto" (k38 "utuminen")) ; --UNCHK
lin confer_V = mkWV (k67A "neuvotella") ; --UNCHK
lin conferee_N = mkWN (compoundN "osan" (k10 "ottaja")) ; --UNCHK
lin conference_N = mkN "konferenssi" ;
lin conferment_N = mkWN "lahjoittaminen" ; --UNCHK
lin conferrer_N = mkWN (k12 "neuvottelija") ; --UNCHK
lin conferva_N = mkWN (compoundN "lanka" (k10 "levä")) ; --UNCHK
lin confess_V = mkWV (k54A "myöntää") ; --UNCHK
lin confess_V2 = mkWV2 (k54A "myöntää") ; --UNCHK
lin confess_VS = mkWVS (k54A "myöntää") ; --UNCHK
lin confessedly_Adv = mkWAdv (k99 "tosiaan") ; --UNCHK
lin confession_N = mkWN (k5A "rippi") ; --UNCHK
lin confessional_N = mkWN (compoundN "rippi" (k5 "tuoli")) ; --UNCHK
lin confessor_N = mkWN (compoundN "rippi-" (k10 "isä")) ; --UNCHK
lin confidantFem_N = mkWN (k10 "ystävä") "läheinen" ; --UNCHK
lin confidantMasc_N = mkWN (k10 "ystävä") "läheinen" ; --UNCHK
lin confidante_N = mkWN (k1A "uskottu") ; --UNCHK
lin confide_V = mkWV (k52A "uskoutua") ; --UNCHK
lin confide_V2 = mkWV2 (k52A "uskoutua") ; --UNCHK
lin confide_VS = mkWVS (k52A "uskoutua") ; --UNCHK
lin confidence_N = mkN "luottamus" ;
lin confident_A = mkA "luottavainen" ;
lin confidential_A = mkWA (k38 "luottamuksellinen") ;
lin confidentiality_N = mkWN (k40 "luottamuksellisuus") ; --UNCHK
lin configuration_N = mkWN (k10 "asetelma") ; --UNCHK
lin configurational_A = mkWA "muoto-" ; --UNCHK
lin configure_V2 = mkWV2 "konfiguroida" ; --UNCHK
lin confine_N = mkN "rajoite" ; --plurale tantum
lin confine_V2 = mkV2 "rajoittaa" partitive ; --mkWV2 (k54A "vähentää") ;
lin confinement_N = mkWN "vangitseminen" ; --UNCHK
lin confining_A = mkWA (k38 "rajallinen") ; --UNCHK
lin confirm_V2 = mkV2 "vahvistaa" | mkV2 "varmistaa" ;
lin confirm_VS = mkVS (mkV "vahvistaa") ;
lin confirmable_A = mkWA (k10 "oleva") "tarkistettavissa" ; --UNCHK
lin confirmation_N = mkWN (k3 "konfirmaatio") ; --UNCHK
lin confiscate_A = mkWA (compoundA "takavariko" (k1A "itu")) ; --UNCHK
lin confiscate_V2 = mkWV2 (k53A "ottaa") "haltuun" ; --UNCHK
lin confiscation_N = mkWN (k39 "lunastus") ; --UNCHK
lin confit_N = mkWN (kH1 "pata") ; --UNCHK
lin confiture_N = mkWN (compoundN "hedelmä" (k1 "hillo")) ; --UNCHK
lin conflagration_N = mkWN (k5 "pätsi") ; --UNCHK
lin conflict_N = mkN "konflikti" ; --WN (k14A "kahakka") ;
lin conflict_V = mkWV (k73A "loukata") ; --UNCHK
lin confluence_N = mkWN (compoundN "väen" (k39 "tungos")) ; --UNCHK
lin confluent_A = mkWA "sulautuva" ; --UNCHK
lin conform_V = mkWV (k52A "tottua") ; --UNCHK
lin conform_V2 = mkWV2 (k52A "tottua") ; --UNCHK
lin conformable_A = mkWA (k10 "vastaava") ; --UNCHK
lin conformation_N = mkWN (k40 "mukautuvuus") ; --UNCHK
lin conformist_A = mkWA (k38 "konservatiivinen") ; --UNCHK
lin conformist_N = mkWN "konformisti" ; --UNCHK
lin conformity_N = mkWN (k40 "mukautuvuus") ; --UNCHK
lin confound_V2 = mkWV2 (k52A "erehtyä") ; --UNCHK
lin confounding_A = mkWA (compoundA "risti" (k38 "riitainen")) ; --UNCHK
lin confrere_N = mkWN (k13 "kollega") ; --UNCHK
lin confront_V2 = mkWV2 (k73A "kohdata") ; --UNCHK
lin confrontation_N = mkN "vastakkainasettaminen" ;
lin confrontational_A = mkWA "konfrontaatio-" ; --UNCHK
lin confucian_A = mkWA (k38 "konfutselainen") ; --UNCHK
lin confucian_N = mkWN (k38 "konfutselainen") ; --UNCHK
lin confuse_V2 = mkWV2 (k52A "erehtyä") ; --UNCHK
lin confused_A = mkA "sekava" ;
lin confusing_A = mkWA (k10 "sekava") ; --UNCHK
lin confusion_N = mkWN (compoundN "seka" (k38 "antuminen")) ; --UNCHK
lin confutation_N = mkWN (k48 "todiste") "kumoava" ; --UNCHK
lin confute_V2 = mkWV2 (k53A "osoittaa") "vääräksi" ; --UNCHK
lin conga_N = mkWN (compoundN "konga-" (k5 "tanssi")) ; --UNCHK
lin conge_N = mkWN (compoundN "ero" (k38 "ttaminen")) ; --UNCHK
lin congeal_V = mkWV (k52A "asettua") ; --UNCHK
lin congeal_V2 = mkWV2 (k52A "asettua") ; --UNCHK
lin congealment_N = mkWN (compoundN "jää" (k38 "dyttäminen")) ; --UNCHK
lin congee_N = mkWN (compoundN "ero" (k38 "ttaminen")) ; --UNCHK
lin congener_N = mkWN (k38 "samanlainen") ; --UNCHK
lin congenial_A = mkWA (k38 "mieluinen") ; --UNCHK
lin congeniality_N = mkWN (compoundN "hengen" (k40 "heimolaisuus")) ; --UNCHK
lin congenialness_N = mkWN (compoundN "saman" (k40 "henkisyys")) ; --UNCHK
lin congenital_A = mkWA (k38 "synnynnäinen") ; --UNCHK
lin conger_N = mkWN (compoundN "meri" (k41 "ankerias")) ; --UNCHK
lin conger_eel_N = mkWN (compoundN "meri" (k41 "ankerias")) ; --UNCHK
lin congested_A = mkWA "tukkeutunut" ; --UNCHK
lin congestion_N = mkWN (k39 "tungos") ; --UNCHK
lin congestive_A = mkWA "kongestiivinen" ; --UNCHK
lin congleton_PN = foreignPN "Congleton" ;
lin conglomerate_A = mkWA (compoundA "sula" (k47 "utunut")) "yhteen" ; --UNCHK
lin conglomerate_N = mkWN (compoundN "moniala" (k10 "yhtymä")) ; --UNCHK
lin conglomerate_V = mkWV (k52A "kertyä") ; --UNCHK
lin conglomerate_V2 = mkWV2 (k52A "kertyä") ; --UNCHK
lin conglomeration_N = mkWN (compoundN "kas" (k38 "aantuminen")) ; --UNCHK
lin congolese_A = mkWA (compoundA "kongo" (k38 "lainen")) ; --UNCHK
lin congolese_N = mkWN (compoundN "kongo" (k38 "lainen")) ; --UNCHK
lin congou_N = mkWN (compoundN "congou-" (k18 "tee")) ; --UNCHK
lin congratulate_V2 = mkWV2 (k52 "lausua") "kohteliaisuus" ; --UNCHK
lin congratulation_N = mkWN (k2 "onnittelu") ; --UNCHK
lin congratulatory_A = mkWA "onnittelu-" ; --UNCHK
lin congregant_N = mkWN (k32 "jäsen") "seurakunnan" ; --UNCHK
lin congregate_V = mkWV (k52A "kerääntyä") ; --UNCHK
lin congregate_V2 = mkWV2 (k52A "kerääntyä") ; --UNCHK
lin congregation_N = mkWN (compoundN "koko" (k38 "ontuminen")) ; --UNCHK
lin congregational_A = mkWA (compoundA "seura" (k38 "kunnallinen")) ; --UNCHK
lin congress_N = mkN "kongressi" ;
lin congressional_A = mkA "kongressionaalinen" ;
lin congressman_N = mkN "kongressi" (mkWN (k10 "edustaja")) ;
lin congresswoman_N = mkWN (k10 "edustaja") ; --UNCHK
lin congruent_A = mkWA (compoundA "yhtenevä" (k38 "inen")) ; --UNCHK
lin congruity_N = mkWN (k40 "soveliaisuus") ; --UNCHK
lin congruous_A = mkWA (k10 "vastaava") ; --UNCHK
lin conic_A = mkWA (compoundA "keila" (k38 "mainen")) ; --UNCHK
lin conical_A = mkWA (compoundA "keila" (k38 "mainen")) ; --UNCHK
lin conidiophore_N = mkWN (compoundN "konidiof" (k48 "ori")) ; --UNCHK
lin conidium_N = mkWN (compoundN "kur" (k10 "oma")) ; --UNCHK
lin conifer_N = mkWN (compoundN "havu" (k18 "puu")) ; --UNCHK
lin coniferous_A = mkWA "havupuun" ; --UNCHK
lin conima_N = mkWN (compoundN "kumi" (k5 "hartsi")) ; --UNCHK
lin conjectural_A = mkWA (k38 "hypoteettinen") ; --UNCHK
lin conjecture_N = mkWN (k10 "otaksuma") ; --UNCHK
lin conjecture_V = mkWV (k52 "otaksua") ; --UNCHK
lin conjecture_V2 = mkWV2 (k52 "otaksua") ; --UNCHK
lin conjoin_V = mkWV (k53 "yhdistää") ; --UNCHK
lin conjoin_V2 = mkWV2 (k53 "yhdistää") ; --UNCHK
lin conjugal_A = mkWA (k38 "aviollinen") ; --UNCHK
lin conjugate_A = mkWA (compoundA "konjugo" (k1A "itu")) ; --UNCHK
lin conjugate_V = mkWV (k62 "konjugoida") ; --UNCHK
lin conjugate_V2 = mkWV2 (k62 "konjugoida") ; --UNCHK
lin conjugation_N = mkWN (compoundN "liitto" (k38 "utuminen")) ; --UNCHK
lin conjunct_A = mkWA "sävelkulku-" ; --UNCHK
lin conjunction_N = mkWN (k48 "yhdiste") ; --UNCHK
lin conjunctiva_N = mkWN (compoundN "side" (k1 "kalvo")) ; --UNCHK
lin conjunctival_A = mkWA "sidekalvon" ; --UNCHK
lin conjunctive_A = mkWA "yhdistävä" ; --UNCHK
lin conjunctive_N = mkWN (k3 "konjunktio") ; --UNCHK
lin conjunctivitis_N = mkWN (compoundN "sidekalvon" (k39 "tulehdus")) ; --UNCHK
lin conjuncture_N = mkWN (k10A "käännekohta") ; --UNCHK
lin conjuration_N = mkWN (k3 "illuusio") ; --UNCHK
lin conjure_V = mkWV (k67A "juonitella") ; --UNCHK
lin conjure_V2 = mkWV2 (k67A "juonitella") ; --UNCHK
lin conjure_up_V2 = mkWV2 (k64 "tuoda") "esiin" ; --UNCHK
lin conjurer_N = mkWN (k6 "puoskari") ; --UNCHK
lin conjuring_N = mkWN (k39 "kirous") ; --UNCHK
lin conjuror_N = mkWN (k6 "puoskari") ; --UNCHK
lin conk_N = mkWN (k10A "nokka") ; --UNCHK
lin conk_V = mkWV (k53A "menettää") "tajuntansa" ; --UNCHK
lin conk_out_V = mkWV (k52 "väsyä") ; --UNCHK
lin conker_N = mkWN (compoundN "hevos" (k12 "kastanja")) ; --UNCHK
lin connate_A = mkWA (compoundA "yhteen" (k47 "kasvanut")) ; --UNCHK
lin connatural_A = mkWA (k38 "luontainen") ; --UNCHK
lin connect_V = mkWV (k63 "saada") "yhteys" ; --UNCHK
lin connect_V2 = mkWV2 (k63 "saada") "yhteys" ; --UNCHK
lin connected_A = mkA "yhdistetty" ;
lin connecticut_PN = mkPN "Connecticut" ;
lin connection_N = mkWN (k40 "yhteys") ;
lin connective_A = mkWA "yhdistävä" ; --UNCHK
lin connective_N = mkWN (k33A "liitin") ; --UNCHK
lin connectivity_N = mkWN (k40 "yhteys") ; --UNCHK
lin connexion_N = mkWN (k40 "yhteys") ; --UNCHK
lin connivance_N = mkWN (compoundN "hyvä" (k38 "ksyminen")) "äänetön" ; --UNCHK
lin connive_V = mkWV (k67A "suunnitella") ; --UNCHK
lin connoisseur_N = mkWN (k12 "tuntija") ; --UNCHK
lin connotation_N = mkWN (compoundN "lisä" (k39 "merkitys")) ; --UNCHK
lin connotational_A = mkWA "konnotaation" ; --UNCHK
lin connotative_A = mkWA (k38 "viitteellinen") ; --UNCHK
lin connote_V2 = mkWV2 (k73 "vihjata") ; --UNCHK
lin connubial_A = mkWA (k38 "aviollinen") ; --UNCHK
lin conodont_N = mkWN "Conodon" ; --UNCHK
lin conquer_V2 = mkWV2 (k53A "taltuttaa") ; --UNCHK
lin conquerable_A = mkWA (k10 "oleva") "voitettavissa" ; --UNCHK
lin conqueror_N = mkWN (k10 "valloittaja") ; --UNCHK
lin conquest_N = mkWN (k39 "valloitus") ; --UNCHK
lin conquistador_N = mkWN (k5 "konkistadori") ; --UNCHK
lin consanguinity_N = mkWN (k40 "sukulaisuus") ; --UNCHK
lin conscience_N = mkWN (k51 "omatunto") ; --UNCHK
lin conscienceless_A = mkWA (k34A "häikäilemätön") ; --UNCHK
lin conscientious_A = mkWA "omantunnontarkka" ; --UNCHK
lin conscientiousness_N = mkWN (k40 "huolellisuus") ; --UNCHK
lin conscionable_A = mkWA (k10 "hyväksyttävä") "moraalisesti" ; --UNCHK
lin conscious_A = mkWA (k38 "tietoinen") ; --UNCHK
lin consciousness_N = mkWN (k1 "taju") ; --UNCHK
lin conscript_N = mkWN (compoundN "ase" (k38 "velvollinen")) ; --UNCHK
lin conscript_V2 = mkWV2 (k73 "värvätä") ; --UNCHK
lin conscription_N = mkWN (k9A "kutsunta") ; --UNCHK
lin consecrate_V2 = mkWV2 (k61A "vihkiä") ; --UNCHK
lin consecration_N = mkWN (compoundN "pyh" (k38 "ittäminen")) ; --UNCHK
lin consecutive_A = mkWA (k38 "peräkkäinen") ;
lin consecutive_Adv = mkWAdv (k99 "peräkkäisesti") ; --UNCHK
lin consensual_A = mkWA (compoundA "kon" (k38 "sensuaalinen")) ; --UNCHK
lin consensus_N = mkWN (k39 "konsensus") ;
lin consent_N = mkWN (k39 "suostumus") ;
lin consent_V = mkWV (k52A "taipua") ; --UNCHK
lin consent_V2V = mkWV2V (k52A "taipua") ; --UNCHK
lin consentaneous_A = mkWA (compoundA "yks" (k38 "imielinen")) ; --UNCHK
lin consequence_N = mkN "seuraus" ;
lin consequent_A = mkA "johdonmukainen" ;
lin consequential_A = mkWA (k10 "muistettava") ; --UNCHK
lin conservancy_N = mkWN (compoundN "luonnon" (k2 "suojelu")) ; --UNCHK
lin conservation_N = mkWN (compoundN "ympäristön" (k2 "suojelu")) ; --UNCHK
lin conservatism_N = mkWN (k40 "vanhoillisuus") ; --UNCHK
lin conservative_1_N = mkN "konservatiivi" ;
lin conservative_2_N = mkN "säilöntäaine" ;
lin conservative_A = mkWA (k38 "konservatiivinen") ; --f85
lin conservatoire_N = mkWN (k3 "konservatorio") ; --UNCHK
lin conservator_N = mkWN (compoundN "edun" (k10 "valvoja")) ; --UNCHK
lin conservatory_N = mkWN "talvipuutarha" ; --UNCHK
lin conserve_N = mkWN (k48A "hilloke") ; --UNCHK
lin conserve_V2 = mkWV2 (k52 "säilöä") ; --UNCHK
lin consett_PN = foreignPN "Consett" ;
lin consider_V = mkV vOlla "mieltä" ;
lin consider_V2 = mkV2 "harkita" partitive ;
lin consider_V2A = mkV2A (mkV "pitää") (mkPrep partitive) (mkPrep essive) ;
lin consider_V2V = mkV2V (mkV "arvella" "alveli") genitive infPresPart ;
lin consider_V3 = mkV3 (mkV "pitää") (mkPrep partitive) (mkPrep essive) ;
lin consider_VS = mkVS (mkV "arvella" "arveli") ;
lin consider_VV = mkVV "harkita" infPresPart ;
lin considerable_A = mkA "huomattava" | mkWA (k10 "varteenotettava") ;
lin considerate_A = mkWA (k38 "huomaavainen") ; --UNCHK
lin considerateness_N = mkWN (k40 "ystävällisyys") ; --UNCHK
lin consideration_N = mkWN (k40 "huomaavaisuus") ;
lin considering_Prep = mkPrep "huomioonottaen" ;
lin considering_Subj = mkSubj "huomioonottaen" ;
lin consign_V2 = mkWV2 (k52 "uskoa") "haltuun" ; --UNCHK
lin consignee_N = mkWN (k10 "saaja") ; --UNCHK
lin consigner_N = mkWN (k10 "lähettäjä") ; --UNCHK
lin consignment_N = mkWN (compoundN "tavara" (k39 "lähetys")) ; --UNCHK
lin consignor_N = mkWN (k10 "lähettäjä") ; --UNCHK
lin consist_V = mkV "koostua" ;
lin consistence_N = mkWN (k40 "loogisuus") ; --UNCHK
lin consistency_N = mkWN (k40 "loogisuus") ; --UNCHK
lin consistent_A = mkA "johdonmukainen" ;
lin consistory_N = mkWN (k6 "konsistori") ; --UNCHK
lin consolable_A = mkWA (k10 "oleva") "lohdutettavissa" ; --UNCHK
lin consolation_N = mkWN (k39 "helpotus") ; --UNCHK
lin consolatory_A = mkWA (k38 "lohdullinen") ; --UNCHK
lin console_N = mkWN (k6 "konsoli") ; --UNCHK
lin console_V2 = mkWV2 (k53A "lievittää") ; --UNCHK
lin consolidate_V = mkWV (k53 "vahvistaa") ; --UNCHK
lin consolidate_V2 = mkWV2 (k53 "vahvistaa") ;
lin consolidation_N = mkWN (compoundN "yhteen" (k38 "sovittaminen")) ; --UNCHK
lin consolidative_A = mkWA (compoundA "integr" (k10 "oiva")) ; --UNCHK
lin consomme_N = mkWN (compoundN "liha" (k25 "liemi")) ; --UNCHK
lin consonance_N = mkWN (k12 "harmonia") ; --UNCHK
lin consonant_A = mkWA (k10 "vastaava") ; --UNCHK
lin consonant_N = mkWN (k48A "kerake") ; --UNCHK
lin consonantal_A = mkWA "konsonantti-" ; --UNCHK
lin consort_N = mkWN (compoundN "soitin" (k10 "ryhmä")) ; --UNCHK
lin consort_V = mkWV (k52A "liikkua") "yhdessä" ; --UNCHK
lin consortium_N = mkN "konsortio" ;
lin conspecific_N = mkWN (k10 "kuuluva") "samaan" "lajiin" ; --UNCHK
lin conspectus_N = mkWN (compoundN "yleis" (k39 "katsaus")) ; --UNCHK
lin conspicuous_A = mkWA (k10 "näkyvä") ; --UNCHK
lin conspicuousness_N = mkWN (k40 "näkyvyys") ; --UNCHK
lin conspiracy_N = mkWN (compoundN "sala" (k48A "hanke")) ; --UNCHK
lin conspirator_N = mkWN (k12 "juonittelija") ; --UNCHK
lin conspiratorial_A = mkWA "vehkeily-" ; --UNCHK
lin conspire_V = mkWV (k67A "juonitella") ; --UNCHK
lin conspire_V2 = mkWV2 (k67A "juonitella") ; --UNCHK
lin conspire_V2V = mkWV2V (k67A "juonitella") ; --UNCHK
lin constable_N = mkWN (k6 "konstaapeli") ; --UNCHK
lin constabulary_N = mkWN (k6 "poliisi") ; --UNCHK
lin constancy_N = mkWN (k40 "muuttumattomuus") ; --UNCHK
lin constant_A = mkA "jatkuva" ;
lin constant_N = mkN "vakio" "vakioita" ;
lin constellation_N = mkWN (k10 "asetelma") ; --UNCHK
lin consternation_N = mkWN (k39 "tyrmistys") ; --UNCHK
lin constipate_1_V2 = mkWV2 (k53A "aiheuttaa") "ummetusta" ; --UNCHK
lin constipate_2_V2 = mkWV2 (k53A "aiheuttaa") "ummetusta" ; --UNCHK
lin constipation_N = mkWN (k5A "mitätöinti") ; --UNCHK
lin constituency_N = mkWN (compoundN "valitsija" (k10A "kunta")) ; --UNCHK
lin constituent_A = mkWA (k10 "osa") "olennainen" ; --UNCHK
lin constituent_N = mkWN (k5A "komponentti") ; --UNCHK
lin constitute_V2 = mkV2 "muodostaa" ;
lin constitution_N = mkN "perustus" (mkN "laki") | mkN "koostumus" ; ---- split
lin constitutional_A = mkWA (compoundA "perustus" (k38 "laillinen")) ;
lin constitutional_N = mkWN (compoundN "kävely" (k5A "lenkki")) ; --UNCHK
lin constitutionalism_N = mkWN (compoundN "perustus" (k40 "laillisuus")) ; --UNCHK
lin constitutionalist_N = mkWN (k10 "kannattaja") "perustuslaillisuuden" ; --UNCHK
lin constitutionalize_V2 = mkWV2 (k53A "ottaa") "perustuslakiin" ; --UNCHK
lin constitutive_A = mkA "perustava" ;
lin constrain_V2 = mkV2 "rajoittaa" ;
lin constrainedly_Adv = mkWAdv (k99 "väkinäisesti") ; --UNCHK
lin constraint_N = mkN "rajoite" ;
lin constrict_V2 = mkWV2 (k52A "kaventua") ; --UNCHK
lin constriction_N = mkWN "kokoon" "vetäminen" ; --UNCHK
lin constrictor_N = mkWN (compoundN "kuristaja" (k48 "käärme")) ; --UNCHK
lin construal_N = mkWN (k39 "selitys") ; --UNCHK
lin construct_V2 = mkWV2 (k54A "jäljentää") ; --UNCHK
lin construction_N = mkN "konstruktio" "konstruktioita" ;
lin constructive_A = mkWA (k10 "rakentava") | mkA "konstruktiivinen" ;
lin constructiveness_N = mkN "rakentavuus" ;
lin constructivism_N = mkWN (k5 "konstruktivismi") ; --UNCHK
lin constructivist_N = mkWN (compoundN "konstrukti" (k5 "visti")) ; --UNCHK
lin constructor_N = mkWN (k10 "rakentaja") ; --UNCHK
lin construe_V = mkWV (k53A "käsittää") ; --UNCHK
lin construe_V2 = mkWV2 (k53A "käsittää") ; --UNCHK
lin construe_V2V = mkWV2V (k53A "käsittää") ; --UNCHK
lin consubstantiation_N = mkWN "konsubstantiaatio" ; --UNCHK
lin consuetude_N = mkWN (compoundN "tapa" (k40 "oikeus")) ; --UNCHK
lin consuetudinary_N = mkWN "consuetudinarius" ; --UNCHK
lin consul_N = mkWN (k6 "konsuli") ; --UNCHK
lin consular_A = mkWA "konsuli-" ; --UNCHK
lin consulate_N = mkWN (k5A "konsulaatti") ; --UNCHK
lin consulship_N = mkWN (k10 "asema") "konsulin" ; --UNCHK
lin consult_V = mkV (mkV "pyytää") "neuvoa" ;
lin consult_V2 = mkV2 "konsultoida" partitive ; --WV2 (k61 "toimia") "neuvonantajana" ;
lin consultancy_N = mkWN (k5A "konsultointi") ;
lin consultant_N = mkWN (k5A "konsultti") ;
lin consultation_N = mkWN (k5A "konsultointi") ; --UNCHK
lin consultative_A = mkWA (k10 "neuvoa-antava") ; --UNCHK
lin consumable_A = mkWA "kuluva" ; --UNCHK
lin consume_V = mkWV (k53A "kuluttaa") ; --UNCHK
lin consume_V2 = mkWV2 (k53A "kuluttaa") ; --UNCHK
lin consumer_N = mkWN (k10 "kuluttaja") ;
lin consumerism_N = mkWN (k10 "kuluttajansuoja") ; --UNCHK
lin consummate_A = mkWA (k10 "syvä") ; --UNCHK
lin consummate_V2 = mkWV2 (k56A "saattaa") "täydelliseksi" ; --UNCHK
lin consummation_N = mkWN (compoundN "täydellis" (k38 "täminen")) ; --UNCHK
lin consumption_N = mkWN (k39 "kulutus") ;
lin consumptive_A = mkA "kuluttava" ;
lin consumptive_N = mkWN (k38 "ihminen") "tuberkuloottinen" ; --UNCHK
lin contact_N = mkN "kontakti" | mkWN (k40 "yhteys") ;
lin contact_V2 = mkV2 (mkV (mkV "ottaa") "yhteyttä") illative ;
lin contadino_N = mkWN "contadino" ; --UNCHK
lin contagion_N = mkWN (k9A "tartunta") ; --UNCHK
lin contagious_A = mkA "tarttuva" ; --WA (compoundA "tartunta" (k38 "vaarallinen")) ;
lin contain_V2 = mkV2 "sisältää" | mkV2 "pidätellä" ; ---- split
lin container_N = mkWN (k3 "säiliö") ; --UNCHK
lin containerful_N = mkN "säiliöllinen" | mkWN "kontillinen" ;
lin containment_N = mkWN "tukahduttaminen" ; --UNCHK
lin contaminant_N = mkWN (k48 "saaste") ; --UNCHK
lin contaminate_V2 = mkWV2 (k53A "saastuttaa") ; --UNCHK
lin contamination_N = mkWN (compoundN "pila" (k38 "aminen")) ; --UNCHK
lin contaminative_A = mkWA (compoundA "saas" (k10 "tuttava")) ; --UNCHK
lin contemn_V2 = mkWV2 (k52 "halveksua") ; --UNCHK
lin contemplate_V = mkWV (k61 "tuumia") ; --UNCHK
lin contemplate_V2 = mkWV2 (k61 "tuumia") ; --UNCHK
lin contemplate_VS = mkWVS (k61 "tuumia") ; --UNCHK
lin contemplation_N = mkWN (k2 "tutkiskelu") ; --UNCHK
lin contemplative_A = mkWA (k10 "harkitseva") ; --UNCHK
lin contemplative_N = mkWN (k12 "mietiskelijä") ; --UNCHK
lin contemporaneity_N = mkWN (compoundN "saman" (k40 "aikaisuus")) ; --UNCHK
lin contemporaneous_A = mkWA (k38 "aikalainen") ; --UNCHK
lin contemporary_A = mkWA (k38 "nykyinen") ; --UNCHK
lin contemporary_N = mkWN (k38 "aikalainen") ; --UNCHK
lin contempt_N = mkWN "oikeuden" "halventaminen" ; --UNCHK
lin contemptible_A = mkWA (k38 "alhainen") ; --UNCHK
lin contemptuousness_N = mkWN (k10A "halveksunta") ; --UNCHK
lin contend_V = mkWV (k53A "pitää") "selviönä" ; --UNCHK
lin contend_VS = mkVS (mkV (mkV "pitää") "selviönä") ; --f93
lin contender_N = mkWN (k10 "haastaja") ; --UNCHK
lin content_A = mkWA (k38 "tyytyväinen") ; --UNCHK
lin content_N = mkWN (k48 "aihe") ; --UNCHK
lin content_V2 = mkWV2 (k52A "tyytyä") ; --UNCHK
lin contentedly_Adv = mkWAdv (k99 "tyynesti") ; --UNCHK
lin contentedness_N = mkWN (k40 "tyytyväisyys") ; --UNCHK
lin contention_N = mkN "kiista" ; ---ARB --mkN "väite" ; --mkWN (k2 "kilpailu") ;
lin contentious_A = mkWA (compoundA "kiistan" (k38 "alainen")) ;
lin contentment_N = mkWN (k40 "tyytyväisyys") ; --UNCHK
lin contents_N = mkWN (k39 "sisällys") ; --UNCHK
lin conterminous_A = mkWA (compoundA "saman" (k38 "laajuinen")) ; --UNCHK
lin contest_N = mkN (lin NK {s = d02 "kilpailu"}) ;
lin contest_V = mkWV (k53 "kyseenalaistaa") ; --UNCHK
lin contest_V2 = mkWV2 (k53 "kyseenalaistaa") ; --UNCHK
lin contestable_A = mkWA (compoundA "kiistan" (k38 "alainen")) ; --UNCHK
lin contestant_N = mkWN (k12 "kilpailija") ; --UNCHK
lin contestee_N = mkWN (k10 "voittaja") "kiistanalainen" ; --UNCHK
lin context_N = mkN "konteksti" | mkWN (k40 "yhteys") ;
lin contextual_A = mkWA (compoundA "kontekstua" (k38 "alinen")) ; --UNCHK
lin contextualism_N = mkWN (compoundN "kontekstual" (k5 "ismi")) ; --UNCHK
lin contiguity_N = mkWN (k40 "vierekkäisyys") ; --UNCHK
lin contiguous_A = mkWA (k34A "välitön") ; --UNCHK
lin continence_N = mkWN (k40 "pidättyvyys") ; --UNCHK
lin continent_A = mkWA (compoundA "pidätysky" (k38 "kyinen")) ; --UNCHK
lin continent_N = mkWN "Manner-Eurooppa" ; --UNCHK
lin continental_A = mkA "mannermainen" ;
lin contingency_N = mkN "riippuvuus" ; --mkWN (k10 "sattuma") "mahdollinen" ;
lin contingent_A = mkA "riippuva" ; --mkWA (compoundA "sattuman" (k38 "varainen")) ;
lin contingent_N = mkWN (k48 "joukkue") ; --UNCHK
lin continual_A = mkWA (kH1 "lakkaamaton") ;
lin continuance_N = mkWN "jatkaminen" ; --UNCHK
lin continuation_N = mkWN "jatkaminen" ; --UNCHK
lin continue_V = mkV "jatkua" ;
lin continue_V2 = mkV2 (mkV "jatkaa") partitive ;
lin continue_VV = mkVV (mkV "jatkaa") ; --- add more Inf3 forms *jatkaa kulkea
lin continue_on_V = advV OP_continue_V OP_on_Adv ; -- guess-p-verb
lin continued_A = variants {} ; --
lin continuing_A = variants {} ; --
lin continuity_N = mkWN (k40 "yhtäjaksoisuus") ; --UNCHK
lin continuous_A = mkWA (k34A "keskeytymätön") ; --UNCHK
lin continuousness_N = mkWN (k40 "yhtäjaksoisuus") ; --UNCHK
lin continuum_N = mkWN (k2 "jatkumo") ; --UNCHK
lin conto_N = mkWN "conto" ; --UNCHK
lin contort_V2 = mkWV2 (k67 "turmella") ; --UNCHK
lin contortion_N = mkWN (k2 "vääristely") ; --UNCHK
lin contortionist_N = mkWN (compoundN "käärme" (k38 "ihminen")) ; --UNCHK
lin contour_N = mkWN (k10 "asetelma") ; --UNCHK
lin contour_V2 = mkWV2 (k53 "muodostaa") "ääriviivat" ; --UNCHK
lin contra_Prep = mkPrep partitive "vastaan" ;
lin contraband_N = mkWN (compoundN "salakuljetus" (k12 "tavara")) ; --UNCHK
lin contrabass_A = mkWA "basso-" ; --UNCHK
lin contrabass_N = mkWN (compoundN "basso" (k1 "viulu")) ; --UNCHK
lin contrabassoon_N = mkWN (compoundN "kontra" (k5A "fagotti")) ; --UNCHK
lin contraception_N = mkWN (k2 "säännöstely") "syntyvyyden" ; --UNCHK
lin contraceptive_A = mkWA "ehkäisy-" ; --UNCHK
lin contraceptive_N = mkWN (compoundN "ehkäisy" (k48 "väline")) ; --UNCHK
lin contract_N = mkN "sopimus" ;
lin contract_V = mkWV (k63 "saada") ; --UNCHK
lin contract_V2 = mkV2 (mkV (mkV "ottaa") "palvelukseen") ; --mkWV2 (k63 "saada") ;
lin contract_V2V = mkWV2V (k63 "saada") ; --UNCHK
lin contractile_A = mkWA (compoundA "supistumisky" (k38 "kyinen")) ; --UNCHK
lin contractility_N = mkWN (compoundN "supistumis" (k1A "kyky")) ; --UNCHK
lin contraction_N = mkWN (k39 "supistus") ;
lin contractor_N = mkN "osapuoli" ;
lin contractual_A = mkWA "sopimus-" ; --UNCHK
lin contracture_N = mkWN (compoundN "kontrak" (k10 "tuura")) ; --UNCHK
lin contradict_V2 = mkWV2 (k54A "kieltää") ; --UNCHK
lin contradiction_N = mkWN (compoundN "kii" (k38 "stäminen")) ; --UNCHK
lin contradictoriness_N = mkWN "kontradiktorisuus" ; --UNCHK
lin contradictory_A = mkWA "toisensa" "poissulkevat" ; --UNCHK
lin contradictory_N = mkWN (k3 "propositio") "vastakkainen" ; --UNCHK
lin contradistinction_N = mkWN "vastakohtaisuus" ; --UNCHK
lin contradistinguish_V2 = mkWV2 (k53A "erottaa") "vastakohtana" ; --UNCHK
lin contrail_N = mkWN (k9 "vana") ; --UNCHK
lin contraindication_N = mkWN (compoundN "vasta-" (k48 "aihe")) ; --UNCHK
lin contralateral_A = mkWA (compoundA "vasta" (k38 "puolinen")) ; --UNCHK
lin contralto_N = mkWN (k1A "altto") ; --UNCHK
lin contraption_N = mkWN (k5A "värkki") ; --UNCHK
lin contrapuntal_A = mkWA (k38 "kontrapunktinen") ; --UNCHK
lin contrapuntist_N = mkWN "kontrapunktikko" ; --UNCHK
lin contrariety_N = mkWN "vastakohtaisuus" ; --UNCHK
lin contrariness_N = mkWN (k40 "uppiniskaisuus") ; --UNCHK
lin contrarious_A = mkWA (k1 "häijy") ; --UNCHK
lin contrariwise_Adv = mkWAdv (k99 "vastakkain") ; --UNCHK
lin contrary_A = mkWA (k38 "vastakkainen") ; --UNCHK
lin contrary_N = mkWN (k10A "vastakohta") ; --UNCHK
lin contrast_N = mkWN (k2 "vertailu") ; --f59
lin contrast_V = mkWV (k73A "verrata") ; --UNCHK
lin contrast_V2 = mkWV2 (k73A "verrata") ; --UNCHK
lin contrastingly_Adv = mkWAdv "vastakohtana" ; --UNCHK
lin contrastive_A = mkWA (compoundA "kontrasti" (k38 "ivinen")) ; --UNCHK
lin contrasty_A = mkWA (compoundA "kontrasti" (k38 "ivinen")) ; --UNCHK
lin contravene_V2 = mkWV2 (k53 "vastustaa") ; --UNCHK
lin contravention_N = mkWN (k2 "väittely") ; --UNCHK
lin contretemps_N = mkWN (k39 "kömmähdys") ; --UNCHK
lin contribute_V = mkV "osallistua" ;
lin contribute_V2 = mkWV2 (k56 "maksaa") "osansa" ; --UNCHK
lin contribution_N = mkN "kontribuutio" ;
lin contributor_N = mkWN (k10 "avustaja") ; --UNCHK
lin contributory_A = mkWA (compoundA "myötä" (k10 "vaikuttava")) ; --UNCHK
lin contrite_A = mkWA (k15 "surkea") ; --UNCHK
lin contrition_N = mkWN (k39 "katumus") ; --UNCHK
lin contrivance_N = mkWN (compoundN "keksi" (k38 "minen")) ; --UNCHK
lin contrive_V = mkWV (k73A "kekata") ; --UNCHK
lin contrive_V2 = mkWV2 (k73A "kekata") ; --UNCHK
lin contriver_N = mkWN (k12 "keksijä") ; --UNCHK
lin control_N = mkN "kontrolli" ;
lin control_V2 = mkV2 "kontrolloida" partitive ;
lin controllable_A = mkWA (k10 "ohjattava") ; --UNCHK
lin controlled_A = variants {} ; --
lin controller_N = mkWN (k33A "säädin") ;
lin controllership_N = mkWN (k10 "asema") "varainhoidon" "valvojan" ; --UNCHK
lin controlling_A = mkWA (k10 "määräävä") ; --UNCHK
lin controversial_A = mkWA (compoundA "kiistan" (k38 "alainen")) ;
lin controversialist_N = mkWN (k1A "poleemikko") ; --UNCHK
lin controversy_N = mkN "kiista" ;
lin controvert_V2 = mkWV2 (k53A "osoittaa") ; --UNCHK
lin contumacious_A = mkWA (compoundA "epä" (k38 "kuuliainen")) ; --UNCHK
lin contumacy_N = mkWN (k2 "niskoittelu") ; --UNCHK
lin contumelious_A = mkWA (k15 "julkea") ; --UNCHK
lin contumely_N = mkWN (k2 "panettelu") ; --UNCHK
lin contuse_V2 = mkWV2 (k61 "kolhia") "mustelmille" ; --UNCHK
lin contusion_N = mkWN (k48 "ruhje") ; --UNCHK
lin conundrum_N = mkWN (k10 "pulma") ; --UNCHK
lin conurbation_N = mkWN (compoundN "asutus" (k1 "ketju")) ; --UNCHK
lin convalesce_V = mkWV (k52A "tervehtyä") ; --UNCHK
lin convalescence_N = mkWN (compoundN "pala" (k38 "utuminen")) ; --UNCHK
lin convalescent_A = mkWA "toipilas-" ; --UNCHK
lin convalescent_N = mkWN (k41 "toipilas") ; --UNCHK
lin convection_N = mkWN (k39 "virtaus") "lämmön" ; --UNCHK
lin convector_N = mkWN (compoundN "lämpö" (k6 "patteri")) ; --UNCHK
lin convene_V = mkWV (k52 "kutsua") "kokoon" ; --UNCHK
lin convene_V2 = mkWV2 (k52 "kutsua") "kokoon" ;
lin convener_N = mkWN (compoundN "kokoon" (k10 "kutsuja")) ; --UNCHK
lin convenience_N = mkN "mukavuus" ; --WN (k5A "värkki") ;
lin convenient_A = mkWA (k10 "sopiva") ;
lin convent_N = mkWN (k6 "luostari") ; --UNCHK
lin conventicle_N = mkWN (compoundN "kokous" (k48 "huone")) ; --UNCHK
lin convention_N = mkWN (compoundN "koko" (k38 "ontuminen")) ; --UNCHK
lin conventional_A = mkWA (k38 "sovinnainen") ; --f60
lin conventionality_N = mkWN (k40 "sovinnaisuus") ; --UNCHK
lin conventionalized_A = mkWA "tyylitelty" ; --UNCHK
lin conventioneer_N = mkWN (k10 "osallistuja") "konventin" ; --UNCHK
lin converge_V = mkWV (k52A "lähentyä") ; --UNCHK
lin convergence_N = mkWN "läheneminen" ; --UNCHK
lin convergent_A = mkWA (compoundA "lähen" (k10 "evä")) ; --UNCHK
lin conversation_N = mkWN (k2 "keskustelu") ;
lin conversational_A = mkWA (compoundA "arki" (k38 "kielinen")) ; --UNCHK
lin conversationalist_N = mkWN (k12 "keskustelija") "taitava" ; --UNCHK
lin converse_A = mkWA (k38 "käänteinen") ; --UNCHK
lin converse_N = mkWN (k2 "keskustelu") ; --UNCHK
lin converse_V = mkWV (k56A "vaihtaa") "mielipiteitä" ; --UNCHK
lin conversion_N = mkWN (k38 "uudestisyntyminen") ; --UNCHK
lin convert_N = mkWN (k38 "käännynnäinen") ; --UNCHK
lin convert_V = mkWV (k52A "muuntua") ; --UNCHK
lin convert_V2 = mkV2 "muuntaa" ; --f56
lin converter_N = mkWN (k33A "muunnin") ;
lin convertibility_N = mkWN (k40 "vaihdettavuus") ; --UNCHK
lin convertible_A = mkWA (k10 "vaihdettava") ; --f109
lin convertible_N = separateN "vaihdettava" (mkN "arvopaperi") ; ---ARB --mkWN (compoundN "avo" (k1 "auto")) ;
lin convex_A = mkWA (k10 "kupera") ; --UNCHK
lin convexity_N = mkWN "kuperuus" ; --UNCHK
lin convey_V2 = mkWV2 (k53A "välittää") ;
lin conveyance_N = mkWN (k1A "siirto") ; --UNCHK
lin conveyancer_N = mkWN (k6 "notaari") "luovutuskirjoja" "laativa" ; --UNCHK
lin conveyer_N = mkWN (k33A "kuljetin") ; --UNCHK
lin conveyer_belt_N = mkWN (k33A "kuljetin") ; --UNCHK
lin conveyor_N = mkWN (k33A "kuljetin") ; --UNCHK
lin convict_N = mkWN (k5A "vanki") ; --UNCHK
lin convict_V2 = mkWV2 (k69 "tuomita") ;
lin conviction_N = mkN "vakaumus" ; ---ARB mkWN (k3 "tuomio") ;
lin convince_V2 = mkWV2 (k53A "vakuuttaa") ;
lin convince_V2V = mkWV2V (k53A "vakuuttaa") ; --UNCHK
lin convincible_A = mkWA (k38 "vastaanottavainen") ; --UNCHK
lin convincing_A = mkWA (k10 "vakuuttava") ; --UNCHK
lin convincingness_N = mkWN (k40 "vakuuttavuus") ; --UNCHK
lin convivial_A = mkWA (k15 "hilpeä") ; --UNCHK
lin convocation_N = mkWN (compoundN "kutsu" (k38 "minen")) "kokoon" ; --UNCHK
lin convoke_V2 = mkWV2 (k52 "kutsua") "kokoon" ; --UNCHK
lin convolute_A = mkWA (k38 "kierteinen") ; --UNCHK
lin convoluted_A = mkWA (k41A "mutkikas") ; --UNCHK
lin convolution_N = mkWN "kiertyminen" ; --UNCHK
lin convolvulus_N = mkWN (k1A "kierto") ; --UNCHK
lin convoy_N = mkWN "saattaminen" ; --UNCHK
lin convoy_V2 = mkWV2 (k56A "saattaa") ; --UNCHK
lin convulse_V2 = mkWV2 (k56 "nauraa") "kippurassa" ; --UNCHK
lin convulsion_N = mkWN (k39 "mullistus") ; --UNCHK
lin convulsive_A = mkWA (k38 "spastinen") ; --UNCHK
lin conwy_PN = foreignPN "Conwy" ;
lin cony_N = mkWN (kH1 "kani") ; --UNCHK
lin coo_N = mkWN (k39 "kujerrus") ; --UNCHK
lin coo_V = mkWV (k54A "kujertaa") ; --UNCHK
lin coo_V2 = mkWV2 (k54A "kujertaa") ; --UNCHK
lin cook_N = mkWN (k10 "keittäjä") ; --UNCHK
lin cook_V = mkWV (k52 "kypsyä") ; --UNCHK
lin cook_V2 = mkWV2 (k52 "kypsyä") ; --UNCHK
lin cookbook_N = mkWN (compoundN "keitto" (k9 "kirja")) ; --UNCHK
lin cooker_N = mkWN (compoundN "keitto" (k12 "astia")) ; --UNCHK
lin cookery_N = mkWN (compoundN "ruuan" (k39 "valmistus")) ; --UNCHK
lin cookery_book_N = mkWN (compoundN "keitto" (k9 "kirja")) ; --UNCHK
lin cookfire_N = mkWN (k23 "tuli") ; --UNCHK
lin cookham_PN = foreignPN "Cookham" ;
lin cookhouse_N = mkWN (compoundN "kenttä" (k3 "keittiö")) ; --UNCHK
lin cookie_N = mkWN "eväste" ; --UNCHK
lin cooking_N = mkWN (compoundN "ruuan" (k39 "valmistus")) ; --UNCHK
lin cookout_N = mkWN (compoundN "ulkoilma-" (k12 "ateria")) ; --UNCHK
lin cookstove_N = mkWN (compoundN "keitto" (k27 "liesi")) ; --UNCHK
lin cooky_N = mkWN (kH1 "keksi") ; --UNCHK
lin cool_A = mkWA (k15 "viileä") ; --UNCHK
lin cool_N = mkWN (k40 "viileys") ; --UNCHK
lin cool_V = mkWV (k52A "kylmentyä") ; --UNCHK
lin cool_V2 = mkV2 "viilentää" partitive ;
lin cool_down_V = mkWV (k52A "kylmentyä") ; --UNCHK
lin cool_down_V2 = mkWV2 (k52A "kylmentyä") ; --UNCHK
lin cool_off_V = mkWV (k52A "viilentyä") ; --UNCHK
lin coolant_N = mkWN (compoundN "jäähdytys" (k48 "neste")) ; --UNCHK
lin cooler_N = mkWN (k5 "jääboksi") ; --UNCHK
lin coolie_N = mkWN (k5 "kuli") ; --UNCHK
lin cooling_N = mkWN (compoundN "jäähdytys" (k10 "järjestelmä")) ; --UNCHK
lin cooling_tower_N = mkWN (compoundN "jäähdytys" (k5 "torni")) ; --UNCHK
lin coolness_N = mkWN (k40 "etäisyys") ; --UNCHK
lin coon_N = mkWN (k5 "supi") ; --UNCHK
lin coondog_N = mkWN (compoundN "metsästys" (k10 "koira")) "supijahdissa" "käytettävä" ; --UNCHK
lin coonhound_N = mkWN (compoundN "metsästyskoira" (k1A "rotu")) "supijahtiin" "kehitetty" ; --UNCHK
lin coontie_N = mkWN (compoundN "käpy" (k1 "palmu")) ; --UNCHK
lin coop_N = mkWN (k5A "häkki") ; --UNCHK
lin coop_up_V2 = mkWV2 (k58A "sulkea") ; --UNCHK
lin cooper_N = mkWN (compoundN "tynnyrin" (k12 "tekijä")) ; --UNCHK
lin cooperate_V = mkWV (k61 "toimia") "yhteistyössä" ; --UNCHK
lin cooperation_N = mkWN (compoundN "yhteis" (k19 "työ")) ;
lin cooperative_A = mkWA (compoundA "yhteis" (k38 "toiminnallinen")) ; --UNCHK
lin cooperative_N = mkWN (compoundN "osuus" (k10A "kunta")) ; --UNCHK
lin cooperator_N = mkWN (k6 "partneri") ; --UNCHK
lin coordinate_A = mkWA (compoundA "tasa" (k38 "vertainen")) ; --UNCHK
lin coordinate_N = mkWN (k5A "koordinaatti") ; --UNCHK
lin coordinate_V = mkWV (k53 "järjestää") ; --UNCHK
lin coordinate_V2 = mkV2 "koordinoida" ; --WV2 (k53 "järjestää") ;
lin coordination_N = mkWN (k5A "koordinointi") ; --UNCHK
lin coordinator_N = mkN (lin NK {s = d06 "koordinaattori"}) ;
lin coot_N = mkWN (compoundN "noki" (k9 "kana")) ; --UNCHK
lin cooter_N = mkWN "Pseudemys" "concinna" ; --UNCHK
lin cop_N = mkWN (kH1 "pollari") ; --UNCHK
lin cop_V2 = mkWV2 (k69 "vangita") ; --UNCHK
lin cop_out_V = mkWV (k53 "luistaa") ; --UNCHK
lin copacetic_A = mkWA (k34A "verraton") ; --UNCHK
lin copaiba_N = mkWN (compoundN "kopaiva" (k6 "balsami")) ; --UNCHK
lin copartner_N = mkWN (compoundN "yhtiö" (k6 "toveri")) ; --UNCHK
lin copartnership_N = mkWN (k40 "osakkuus") ; --UNCHK
lin cope_N = mkWN (compoundN "papin" (k1A "kaapu")) ; --UNCHK
lin cope_V = mkWV (k53 "kestää") ; --UNCHK
lin copeck_N = mkWN (k14A "kopeekka") ; --UNCHK
lin copenhagen_PN = foreignPN "Kööpenhamina" ;
lin copepod_N = mkWN (compoundN "han" (k38 "kajalkainen")) ; --UNCHK
lin copilot_N = mkWN (k10 "lentäjä") "toinen" ; --UNCHK
lin coping_N = mkWN (k48A "peite") ; --UNCHK
lin coping_stone_N = mkWN (compoundN "kansi" (k7 "kivi")) ; --UNCHK
lin copious_A = mkWA (k99 "paljon") ; --UNCHK
lin cop_out_N = mkWN "livistäminen" ; --UNCHK
lin copper_N = mkN (lin NK {s = d06 "kupari"}) ;
lin copper_V2 = mkWV2 (k53A "pinnoittaa") "kuparilla" ; --UNCHK
lin copperhead_N = mkWN "Denisonia" "superba" ; --UNCHK
lin copperplate_N = mkWN (compoundN "kupari" (k39 "piirros")) ; --UNCHK
lin coppersmith_N = mkWN (compoundN "kupari" (k10A "seppä")) ; --UNCHK
lin coppery_A = mkWA (compoundA "kuparin" (k15 "ruskea")) ; --UNCHK
lin coppice_N = mkWN (k4A "pöheikkö") ; --UNCHK
lin coppull_PN = foreignPN "Coppull" ;
lin copra_N = mkWN (k10 "kopra") ; --UNCHK
lin coprolalia_N = mkWN "rivopuheisuus" ; --UNCHK
lin coprolite_N = mkWN "koproliitti" ; --UNCHK
lin coprolith_N = mkWN (compoundN "uloste" (k7 "kivi")) ; --UNCHK
lin coprophagy_N = mkWN "koprofagia" ; --UNCHK
lin copse_N = mkWN (k4A "pöheikkö") ; --UNCHK
lin copt_N = mkWN (k38 "koptilainen") ; --UNCHK
lin coptic_N = mkWN (k5 "kopti") ; --UNCHK
lin copula_N = mkWN (k5 "verbi") "vaillinainen" ; --UNCHK
lin copular_A = mkWA "kopula-" ; --UNCHK
lin copulate_V = mkWV (k52A "pariutua") ; --UNCHK
lin copulation_N = mkWN (k38 "kanssakäyminen") "seksuaalinen" ; --UNCHK
lin copulative_A = mkWA (compoundA "kop" (k38 "ulatiivinen")) ; --UNCHK
lin copulative_N = mkWN (k5 "verbi") "vaillinainen" ; --UNCHK
lin copy_N = mkN "kopio" | mkN "jäljennös" ;
lin copy_V = mkV "kopioida" ;
lin copy_V2 = mkWV2 (k73 "kopsata") ; --UNCHK
lin copybook_N = mkWN (compoundN "käsiala" (k1 "vihko")) ; --UNCHK
lin copycat_N = mkWN (k12 "apina") ; --UNCHK
lin copyhold_N = mkWN (compoundN "asukas" (k40 "oikeus")) ; --UNCHK
lin copyholder_N = mkWN (k33A "pidin") "käsikirjoituksen" ; --UNCHK
lin copying_N = mkWN "jäljentäminen" ; --UNCHK
lin copyist_N = mkWN (k6 "kirjuri") ; --UNCHK
lin copyright_N = mkWN (compoundN "tekijän" (k40 "oikeus")) ;
lin copyright_V2 = mkWV2 (k73 "suojata") "tekijänoikeus" ; --UNCHK
lin copywriter_N = mkWN (k12 "laatija") "mainostekstien" ; --UNCHK
lin coquetry_N = mkWN (k2 "flirttailu") ; --UNCHK
lin coquette_N = mkWN (k5A "koketti") ; --UNCHK
lin coquettish_A = mkWA "flirttaileva" ; --UNCHK
lin coquille_N = mkWN (k12 "astia") "simpukankuoren" "muotoinen" ; --UNCHK
lin cor_anglais_N = mkWN (compoundN "englannin" (k7 "torvi")) ; --UNCHK
lin coral_A = mkWA (compoundA "korallin" (k38 "punainen")) ; --UNCHK
lin coral_N = mkWN (k5 "koralli") ; --UNCHK
lin coral_reef_N = mkWN (compoundN "koralli" (k9A "riutta")) ; --UNCHK
lin coralbells_N = mkWN (compoundN "keijun" (k10A "kukka")) ; --UNCHK
lin coralberry_N = mkWN (compoundN "cre" (k9A "nata")) "Ardisia" ; --UNCHK
lin coralwood_N = mkWN "Adenanthera" "pavonina" ; --UNCHK
lin corbel_N = mkWN (k41 "ansas") ; --UNCHK
lin corbelled_A = mkWA "olkakivin" "tuettu" ; --UNCHK
lin corbina_N = mkWN "Menticirrhus" "undulatus" ; --UNCHK
lin corby_PN = foreignPN "Corby" ;
lin corchorus_N = mkWN (compoundN "Corchorus-" (k1A "suku")) ; --UNCHK
lin cord_N = mkWN (k1 "naru") ; --UNCHK
lin cord_V2 = mkWV2 (k53A "köyttää") ; --UNCHK
lin cordage_N = mkWN (k2 "köysistö") ; --UNCHK
lin cordate_A = mkWA (k38 "muotoinen") "sydämen" ; --UNCHK
lin cordgrass_N = mkWN (compoundN "aro" (k10 "heinä")) ; --UNCHK
lin cordial_A = mkWA (k10 "mukava") ; --UNCHK
lin cordial_N = mkWN (k6 "likööri") ; --UNCHK
lin cordiality_N = mkWN (k40 "sydämellisyys") ; --UNCHK
lin cordierite_N = mkWN (compoundN "kordie" (k5A "riitti")) ; --UNCHK
lin cordite_N = mkWN "kordiitti" ; --UNCHK
lin corditis_N = mkWN (k39 "tulehdus") "siemenjohtimen" ; --UNCHK
lin cordless_A = mkWA (k34A "langaton") ; --UNCHK
lin cordoba_N = mkWN "Cordova" ; --UNCHK
lin cordon_N = mkWN (compoundN "koriste" (k39 "punos")) ; --UNCHK
lin cordovan_N = mkWN (compoundN "karduaani" (k9 "nahka")) ; --UNCHK
lin corduroy_N = mkWN (compoundN "vako" (k5A "sametti")) ; --UNCHK
lin cordwood_N = mkWN (compoundN "poltto" (k18 "puu")) ; --UNCHK
lin core_N = mkN "ydin" ;
lin core_V2 = mkWV2 (k53 "poistaa") "sisus" ; --UNCHK
lin coreference_N = mkWN (compoundN "samaviitte" (k40 "isyys")) ; --UNCHK
lin coreferent_A = mkWA (compoundA "sama" (k38 "viitteinen")) ; --UNCHK
lin coreferential_A = mkWA (compoundA "sama" (k38 "viitteinen")) ; --UNCHK
lin coreligionist_N = mkWN (compoundN "uskon" (k7 "veli")) ; --UNCHK
lin coreopsis_N = mkWN (compoundN "kauno" (k10 "silmä")) ; --UNCHK
lin corer_N = mkWN (k9 "omenakaira") ; --UNCHK
lin corgi_N = mkWN "walesincorgi" ; --UNCHK
lin coriaceous_A = mkWA (k38 "nahkainen") ; --UNCHK
lin coriander_N = mkWN (k6 "korianteri") ; --UNCHK
lin corinthian_A = mkWA (k38 "korinttilainen") ; --UNCHK
lin corinthian_N = mkWN (k38 "korinttilainen") ; --UNCHK
lin cork_N = mkWN (k1 "koho") ; --UNCHK
lin cork_PN = foreignPN "Cork" ;
lin cork_V2 = mkWV2 (k53A "täyttää") "korkilla" ; --UNCHK
lin corkage_N = mkWN (compoundN "korkki" (k9 "raha")) ; --UNCHK
lin corkboard_N = mkWN (compoundN "korkki" (k1 "levy")) ; --UNCHK
lin corker_N = mkWN (compoundN "korkitus" (k48 "kone")) ; --UNCHK
lin corkscrew_N = mkWN (compoundN "korkki" (k5 "ruuvi")) ; --UNCHK
lin corkwood_N = mkWN "Leitneria" "floridana" ; --UNCHK
lin corm_N = mkWN (compoundN "varsi" (k12 "mukula")) ; --UNCHK
lin cormorant_N = mkWN (compoundN "meri" (k1 "metso")) ; --UNCHK
lin cormous_A = mkWA "varsimukuloita" "kasvattava" ; --UNCHK
lin corn_N = mkN "maissi" ; --f63
lin corn_V2 = mkWV2 (k73 "suolata") ; --UNCHK
lin corn_exchange_N = mkWN (compoundN "vilja" (k5 "pörssi")) ; --UNCHK
lin cornbread_N = mkWN (compoundN "maissi" (k10A "leipä")) ; --UNCHK
lin corncob_N = mkWN (compoundN "maissin" (k10 "tähkä")) ; --UNCHK
lin corncrake_N = mkWN (k10A "ruisrääkkä") ; --UNCHK
lin corncrib_N = mkWN (compoundN "maissin" (k2 "kuivaamo")) ; --UNCHK
lin cornea_N = mkWN (compoundN "sarveis" (k1 "kalvo")) ; --UNCHK
lin corneal_A = mkWA "sarveiskalvon" ; --UNCHK
lin cornelian_N = mkWN (k5 "karneoli") ; --UNCHK
lin corneous_A = mkWA (compoundA "sarvi" (k38 "mainen")) ; --UNCHK
lin corner_N = mkWN (k10 "kulma") ;
lin corner_V = mkV (lin VK {s = c73A "vallata"}) ;
lin corner_V2 = mkWV2 (k52A "kääntyä") "kulmasta" ; --UNCHK
lin corner_kick_N = mkWN (k1 "kulmapotku") ; --UNCHK
lin cornerback_N = mkWN (compoundN "laita" (k10 "puolustaja")) ; --UNCHK
lin cornerstone_N = mkWN (compoundN "kulma" (k7 "kivi")) ; --UNCHK
lin cornet_N = mkWN (k5A "trumpetti") ; --UNCHK
lin cornetfish_N = mkWN (compoundN "kornetti" (k9 "kala")) ; --UNCHK
lin cornfield_N = mkWN (compoundN "maissi" (k1A "pelto")) ; --UNCHK
lin cornflour_N = mkWN (compoundN "maissi" (k1 "jauho")) ; --UNCHK
lin cornflower_N = mkWN (compoundN "ruis" (k5A "kaunokki")) ; --UNCHK
lin cornhusk_N = mkWN (kH1 "kuori") ; --UNCHK
lin cornhusker_N = mkWN (compoundN "nebras" (k38 "kalainen")) ; --UNCHK
lin cornhusking_N = mkWN (compoundN "kuori" (k38 "minen")) "maissintähkien" ; --UNCHK
lin cornice_N = mkWN (compoundN "korni" (k5 "isi")) ; --UNCHK
lin cornmeal_N = mkWN (compoundN "maissi" (k1 "jauho")) ; --UNCHK
lin cornpone_N = mkWN (compoundN "maissi" (k10A "leipä")) ; --UNCHK
lin cornsmut_N = mkWN (compoundN "noki" (k26 "sieni")) "maissin" ; --UNCHK
lin cornstalk_N = mkWN (compoundN "maissin" (k28 "korsi")) ; --UNCHK
lin cornstarch_N = mkWN (compoundN "maissi" (k1 "jauho")) ; --UNCHK
lin cornu_N = mkWN (k7 "sarvi") ; --UNCHK
lin cornucopia_N = mkWN (k40 "runsaus") ; --UNCHK
lin cornwall_PN = foreignPN "Cornwall" ;
lin corny_A = mkWA (k15 "lattea") ; --UNCHK
lin corolla_N = mkWN (k3 "teriö") ; --UNCHK
lin corollary_N = mkWN (compoundN "korol" (k5 "laari")) ; --UNCHK
lin corona_N = mkWN "corona" ; --UNCHK
lin coronary_A = mkWA (compoundA "korona" (k38 "arinen")) ; --UNCHK
lin coronary_N = mkWN (compoundN "sepelvaltimo" (k39 "tukos")) ; --UNCHK
lin coroner_N = mkWN (compoundN "kuolemansyyn" (k12 "tutkija")) ; --UNCHK
lin coronet_N = mkWN (k10 "kehä") ; --UNCHK
lin coroneted_A = mkWA (k38 "aatelinen") ; --UNCHK
lin coronilla_N = mkWN (compoundN "nivel" (k9 "virna")) ; --UNCHK
lin corozo_N = mkWN "Attalea" "cohune" ; --UNCHK
lin corporal_A = mkWA (k38 "lihallinen") ; --UNCHK
lin corporal_N = mkWN (k5 "korpraali") ; --UNCHK
lin corporate_A = mkA "yhtiönlaajuinen" ;
lin corporation_N = mkN "korporaatio" ;
lin corporatism_N = mkWN (k5 "korporativismi") ; --UNCHK
lin corporatist_A = mkWA "korporatistinen" ; --UNCHK
lin corporatist_N = mkWN "korporatisti" ; --UNCHK
lin corporeal_A = mkWA (k38 "aineellinen") ; --UNCHK
lin corps_N = mkWN (compoundN "armeija" (k10A "kunta")) ; --UNCHK
lin corps_de_ballet_N = mkWN (compoundN "baletti" (k10A "kunta")) ; --UNCHK
lin corps_diplomatique_N = mkWN (compoundN "diplomaatti" (k10A "kunta")) ; --UNCHK
lin corpse_N = mkWN (k1A "raato") ; --UNCHK
lin corpulence_N = mkWN (k40 "paksuus") ; --UNCHK
lin corpulent_A = mkWA (k15 "pullea") ; --UNCHK
lin corpus_N = mkWN (k1A "runko") ; --UNCHK
lin corpuscle_N = mkWN (k1 "solu") ; --UNCHK
lin corpuscular_A = mkWA "hiukkas-" ; --UNCHK
lin corral_N = mkWN (k39 "aitaus") ; --UNCHK
lin corral_V2 = mkWV2 (k61 "haalia") ; --UNCHK
lin correct_A = L.correct_A ;
lin correct_V = mkWV (k73 "korjata") ; --UNCHK
lin correct_V2 = mkWV2 (k73 "korjata") ; --UNCHK
lin correct_VS = mkWVS (k73 "korjata") ; --UNCHK
lin correctable_A = mkWA (k10 "oleva") "oikaistavissa" ; --UNCHK
lin correction_1_N = mkWN (k2 "oikaisu") ; --UNCH
lin correction_2_N = mkWN (compoundN "seuraamus" (k10 "järjestelmä")) ; --UNCHKK
lin correctional_A = mkWA "parannus-" ; --UNCHK
lin correctitude_N = mkWN (k40 "säädyllisyys") ; --UNCHK
lin corrective_A = mkWA (compoundA "korj" (k9 "aava")) ; --UNCHK
lin corrective_N = mkWN (compoundN "parannus" (k1 "keino")) ; --UNCHK
lin correctness_N = mkWN (k40 "oikeellisuus") ; --UNCHK
lin correlate_N = mkWN (k5A "korrelaatti") ; --UNCHK
lin correlate_V = mkWV (k56A "saattaa") "vastaavuussuhteeseen" ; --UNCHK
lin correlate_V2 = mkWV2 (k56A "saattaa") "vastaavuussuhteeseen" ; --UNCHK
lin correlation_N = mkWN (k40 "vastaavuus") "tilastollinen" ; --UNCHK
lin correlational_A = mkWA (compoundA "kor" (k38 "relatiivinen")) ; --UNCHK
lin correlative_A = mkA "korreloiva" ;
lin correlative_N = mkWN (k5A "korrelaatti") ; --UNCHK
lin correspond_V = mkV vOlla "kirjeenvaihdossa" ;
lin correspond_V2 = mkV2 (mkV "vastata") partitive ;
lin correspondence_N = mkWN (k40 "vastaavuus") ; --UNCHK
lin correspondent_N = mkN "kirjeenvaihtaja" ; --mkWN (k10 "kirjoittaja") "kirjeiden" ;
lin corresponding_A = variants {} ; --
lin corridor_N = mkWN (k10 "käytävä") ; --UNCHK
lin corrie_N = mkWN (compoundN "kattila" (k1 "laakso")) ; --UNCHK
lin corrigenda_N = mkWN (compoundN "oikaisu" (k2 "luettelo")) ; --UNCHK
lin corrigendum_N = mkWN (compoundN "paino" (k48 "virhe")) ; --UNCHK
lin corrigible_A = mkWA (k10 "oleva") "parannettavissa" ; --UNCHK
lin corroborant_A = mkWA "vahvistava" ; --UNCHK
lin corroborate_V2 = mkWV2 (k53 "vahvistaa") ; --UNCHK
lin corroboration_N = mkWN "vahvistaminen" ; --UNCHK
lin corroborative_A = mkWA "sivu-" ; --UNCHK
lin corrode_V = mkWV (k52 "kulua") ; --UNCHK
lin corrode_V2 = mkWV2 (k52 "kulua") ; --UNCHK
lin corrosion_N = mkWN (k3 "korroosio") ; --UNCHK
lin corrosive_A = mkWA "erittäin" "syövyttävä" ; --UNCHK
lin corrosive_N = mkWN (k48 "aine") "syövyttävä" ; --UNCHK
lin corrugate_V = mkWV (k53A "poimuttaa") ; --UNCHK
lin corrugate_V2 = mkWV2 (k53A "poimuttaa") ; --UNCHK
lin corrugation_N = mkWN (compoundN "poimu" (k38 "ttaminen")) ; --UNCHK
lin corrupt_A = mkWA "turmeltunut" ; --UNCHK
lin corrupt_V = mkWV (k73 "pilata") ; --UNCHK
lin corrupt_V2 = mkWV2 (k73 "pilata") ; --UNCHK
lin corruptibility_N = mkWN (k40 "lahjottavuus") ; --UNCHK
lin corruptible_A = mkWA (k10 "oleva") "ostettavissa" ; --UNCHK
lin corruption_N = mkN "korruptio" ;
lin corruptive_A = mkWA (k38 "turmiollinen") ; --UNCHK
lin corruptness_N = mkWN (k3 "korruptio") ; --UNCHK
lin corsage_N = mkWN (compoundN "kukka" (k1 "vihko")) ; --UNCHK
lin corsair_N = mkWN (compoundN "kaappari" (k9 "laiva")) ; --UNCHK
lin corse_N = mkWN (compoundN "Kor" (k9A "sika")) ; --UNCHK
lin corselet_N = mkWN (k13 "haarniska") ; --UNCHK
lin corset_N = mkWN (k5 "kureliivi") ; --UNCHK
lin corsham_PN = foreignPN "Corsham" ;
lin corslet_N = mkWN (k13 "haarniska") ; --UNCHK
lin cortege_1_N = mkWN (k48 "seurue") ; --UNCHK
lin cortege_2_N = variants {} ; --UNCHK
lin cortege_N = mkWN (k48 "seurue") ; --UNCHK
lin cortex_N = mkWN (compoundN "kuori" (k39 "kerros")) ; --UNCHK
lin cortical_A = mkWA (compoundA "kortika" (k38 "alinen")) ; --UNCHK
lin corticoafferent_A = mkWA "aivokuoreen" "tuova" ; --UNCHK
lin corticoefferent_A = mkWA "aivokuoresta" "tuova" ; --UNCHK
lin corticosteroid_N = mkWN (compoundN "kortiko" (k5 "steroidi")) ; --UNCHK
lin corticosterone_N = mkWN "kortikosteroni" ; --UNCHK
lin cortina_N = mkWN (k41A "rengas") "sienen" "harsomainen" ; --UNCHK
lin cortisone_N = mkWN (k5 "kortisoni") ; --UNCHK
lin corundom_N = mkWN (k5 "korundi") ; --UNCHK
lin corundum_N = mkWN (k5 "korundi") ; --UNCHK
lin corunna_PN = foreignPN "Corunna" ;
lin coruscate_V = mkWV (k52 "säihkyä") ; --UNCHK
lin coruscation_N = mkWN (k48 "säihke") ; --UNCHK
lin corvee_N = mkWN (k5A "taksvärkki") ; --UNCHK
lin corvette_N = mkWN (k5A "korvetti") ; --UNCHK
lin corvine_A = mkWA (compoundA "varis" (k38 "mainen")) ; --UNCHK
lin corydalis_N = mkWN (compoundN "Corydalus-" (k1A "suku")) ; --UNCHK
lin corymb_N = mkWN (k2 "huiskilo") ; --UNCHK
lin corymbose_A = mkWA (compoundA "huiskilo" (k38 "mainen")) ; --UNCHK
lin corynebacterium_N = mkWN (compoundN "korynebak" (k26 "teeri")) ; --UNCHK
lin coryphantha_N = mkWN "Coryphantha" ; --UNCHK
lin corythosaur_N = mkWN (k1 "kypärälisko") ; --UNCHK
lin cos_N = mkWN (compoundN "side" (k5A "salaatti")) ; --UNCHK
lin coscoroba_N = mkWN (compoundN "ankka" (k32 "joutsen")) ; --UNCHK
lin cosecant_N = mkWN (k5A "kosekantti") ; --UNCHK
lin coseismic_A = mkWA "koseisminen" ; --UNCHK
lin cosenza_PN = foreignPN "Cosenza" ;
lin cosh_N = mkWN (k14A "pulikka") ; --UNCHK
lin cosh_V2 = mkWV2 (k58 "iskeä") "lyijypatukalla" ; --UNCHK
lin cosher_A = mkWA (k5 "košer") ; --UNCHK
lin cosignatory_N = mkWN (compoundN "allekirjoittaja" (k6 "kumppani")) ; --UNCHK
lin cosigner_N = mkWN (compoundN "allekirjoittaja" (k6 "kumppani")) ; --UNCHK
lin cosine_N = mkWN (k5 "kosini") ; --UNCHK
lin cosiness_N = mkWN (k40 "mukavuus") ; --UNCHK
lin cosmetic_A = mkWA (k38 "kosmeettinen") ; --UNCHK
lin cosmetic_N = mkWN (k9A "kosmetiikka") ;
lin cosmetician_N = mkWN (k5 "kosmetologi") ; --UNCHK
lin cosmetologist_N = mkWN (k5 "kosmetologi") ; --UNCHK
lin cosmetology_N = mkWN (k12 "kosmetologia") ; --UNCHK
lin cosmic_A = mkWA (k38 "kosminen") ; --UNCHK
lin cosmid_N = mkWN (k5 "kosmidi") ; --UNCHK
lin cosmogony_N = mkWN (k12 "kosmogonia") ; --UNCHK
lin cosmographer_N = mkWN "kosmografi" ; --UNCHK
lin cosmography_N = mkWN "kosmografia" ; --UNCHK
lin cosmolatry_N = mkWN "kosmolatria" ; --UNCHK
lin cosmologic_A = mkWA (k38 "kosmologinen") ; --UNCHK
lin cosmologist_N = mkWN "kosmologi" ; --UNCHK
lin cosmology_N = mkWN (k12 "kosmogonia") ; --UNCHK
lin cosmonaut_N = mkWN (k5A "kosmonautti") ; --UNCHK
lin cosmopolitan_A = mkWA (k38 "kosmopoliittinen") ; --UNCHK
lin cosmopolitan_N = mkWN (k5A "kosmopoliitti") ; --UNCHK
lin cosmos_N = mkWN (k40 "avaruus") ; --UNCHK
lin cosmotron_N = mkWN (compoundN "Cosmotron-hiukkas" (k33A "kiihdytin")) ; --UNCHK
lin cosset_V2 = mkWV2 (k61 "helliä") ; --UNCHK
lin cost_N = mkN "kustannus" ;
lin cost_V = mkWV (k56 "maksaa") ;
lin cost_V2 = mkWV2 (k56 "maksaa") ;
lin cost_up_V2 = prepV2 OP_cost_V OP_up_Prep ; -- guess-p-verb
lin costa_N = mkWN (compoundN "kylki" (k18 "luu")) ; --UNCHK
lin costa_rican_A = mkWA (compoundA "costaric" (k38 "alainen")) ; --UNCHK
lin costa_rican_N = mkWN (compoundN "costaric" (k38 "alainen")) ; --UNCHK
lin costal_A = mkWA "kylkiluun" ; --UNCHK
lin costermonger_N = mkWN (compoundN "katu" (k41 "kauppias")) ; --UNCHK
lin costia_N = mkWN "Costia" "necatrix" ; --UNCHK
lin costiasis_N = mkWN "costiasis" ; --UNCHK
lin costing_N = mkWN (compoundN "kustannus" (k9A "laskenta")) ; --UNCHK
lin costive_A = mkWA (compoundA "ummetus" (k38 "tautinen")) ; --UNCHK
lin costliness_N = mkWN (k40 "arvokkuus") ; --UNCHK
lin costly_A = mkA "hintava" ;
lin costmary_N = mkWN "Chrysanthemum" "majus" ; --UNCHK
lin costochondritis_N = mkWN (compoundN "oire" (k10 "yhtymä")) "Tietzen" ; --UNCHK
lin costs_N = mkWN "korvaus" "oikeudenkäyntikuluista" ; --UNCHK
lin costume_N = mkWN (k1 "asu") ; --UNCHK
lin costumed_A = mkWA "pukeutunut" ; --UNCHK
lin costumier_N = mkWN (k10 "puvustaja") ; --UNCHK
lin costusroot_N = mkWN "Saussurea" "lappa" ; --UNCHK
lin cosy_A = mkWA (k10 "kotoisa") ; --UNCHK
lin cosy_N = mkWN (compoundN "tee" (k1 "myssy")) ; --UNCHK
lin cot_N = mkWN (compoundN "kenttä" (k48A "vuode")) ; --UNCHK
lin cotangent_N = mkWN (k5A "kotangentti") ; --UNCHK
lin cote_N = mkWN (kH1 "suoja") ; --UNCHK
lin cotenant_N = mkWN (compoundN "yhteis" (k10 "vuokraaja")) ; --UNCHK
lin coterie_N = mkWN (k10 "ryhmittymä") ; --UNCHK
lin coterminous_A = mkWA (compoundA "saman" (k38 "laajuinen")) ; --UNCHK
lin cotilion_N = mkWN (compoundN "kotilj" (k7A "onki")) ; --UNCHK
lin cotillion_N = mkWN (compoundN "kotilj" (k7A "onki")) ; --UNCHK
lin cotinga_N = mkWN "kotinga" ; --UNCHK
lin cotoneaster_N = mkWN (compoundN "tuhka" (k41 "pensas")) ; --UNCHK
lin cottage_N = mkWN (k9 "maja") ; --UNCHK
lin cottager_N = mkWN (k38 "mäkitupalainen") ; --UNCHK
lin cottar_N = mkWN (k5A "tappi") ; --UNCHK
lin cotter_N = mkWN (k5A "tappi") ; --UNCHK
lin cotton_N = mkWN (k9 "puuvilla") ;
lin cotton_V = mkWV (k52 "tykästyä") ; --UNCHK
lin cotton_cake_N = mkWN "puuvillansiemenkakku" ; --UNCHK
lin cotton_on_V = mkWV (k74 "älytä") ; --UNCHK
lin cotton_plant_N = mkWN (k9 "puuvilla") ; --UNCHK
lin cotton_wool_N = mkWN (k9 "puuvilla") ; --UNCHK
lin cottonseed_N = mkWN (compoundN "puuvillan" (k32 "siemen")) ; --UNCHK
lin cottontail_N = mkWN (compoundN "pumpulihäntäka" (k26 "niini")) ; --UNCHK
lin cottonweed_N = mkWN "Froelichia" ; --UNCHK
lin cottonwick_N = mkWN "Haemulon" "melanurum" ; --UNCHK
lin cottonwood_N = mkWN "Tilia" "heterophylla" ; --UNCHK
lin cottony_A = mkWA (compoundA "pumpuli" (k38 "mainen")) ; --UNCHK
lin cotyledon_N = mkWN (compoundN "sirkka" (k7A "lehti")) ; --UNCHK
lin coucal_N = mkWN (compoundN "kannus" (k7A "käki")) ; --UNCHK
lin couch_N = mkWN (k10 "sohva") "psykiatrin" ; --UNCHK
lin couch_V = mkWV (k53A "esittää") ; --UNCHK
lin couch_V2 = mkWV2 (k53A "esittää") ; --UNCHK
lin couch_grass_N = mkWN (compoundN "juola" (k10 "vehnä")) ; --UNCHK
lin couchant_A = mkWA (compoundA "mak" (k9 "aava")) ; --UNCHK
lin couchette_N = mkWN (compoundN "makuu" (k1 "vaunu")) ; --UNCHK
lin cougar_N = mkWN (k10 "puuma") ; --UNCHK
lin cough_N = mkWN (k39 "yskähdys") ;
lin cough_V = mkWV (k61 "köhiä") ; --UNCHK
lin cough_up_V2 = mkWV2 (k58A "sylkeä") ; --UNCHK
lin coulisse_N = mkWN (k1 "kouru") ; --UNCHK
lin coulter_N = mkWN (k10 "terä") "auran" ; --UNCHK
lin council_N = mkN "neuvosto" ;
lin council_board_N = mkWN (compoundN "neuvottelu" (k10A "pöytä")) ; --UNCHK
lin council_chamber_N = mkWN (compoundN "kokous" (k48 "huone")) ; --UNCHK
lin councillor_N = mkWN (k32 "jäsen") "neuvoston" ; --UNCHK
lin councillorship_N = mkWN (k40 "jäsenyys") "neuvoston" ; --UNCHK
lin councilman_N = mkWN (k32 "jäsen") "neuvoston" ; --UNCHK
lin councilwoman_N = mkWN (k32 "jäsen") "valtuuston" ; --UNCHK
lin counsel_N = mkWN (k39 "ohjaus") ;
lin counsel_V2 = mkWV2 (k73 "ohjata") ; --UNCHK
lin counselling_N = variants {} ; --
lin counsellor_N = mkWN (compoundN "oikeus" (k10 "avustaja")) ; --UNCHK
lin counselorship_N = mkWN (k25 "toimi") "asianajajan" ; --UNCHK
lin count_1_N = mkWN (k38 "lukeminen") "numeroiden" ; --UNCHK
lin count_2_N = mkWN (k38 "lukeminen") "numeroiden" ; --UNCHK
lin count_V = mkWV (k53A "ottaa") "lukuun" ;
lin count_V2 = L.count_V2 ;
lin count_against_V2 = prepV2 OP_count_V OP_against_Prep ; -- guess-p-verb
lin count_among_V2 = prepV2 OP_count_V OP_among_Prep ; -- guess-p-verb
lin count_down_V2 = mkWV2 (k58 "laskea") "taaksepäin" ; --UNCHK
lin count_for_V2 = prepV2 OP_count_V OP_for_Prep ; -- guess-p-verb
lin count_in_V2 = prepV2 OP_count_V OP_in_Prep ; -- guess-p-verb
lin count_off_V2 = mkWV2 (k67A "luetella") "numeroita" ; --UNCHK
lin count_on_V2 = mkWV2 (k53 "ennustaa") ; --UNCHK
lin count_out_V2 = mkWV2 (k53 "julistaa") "häviäjä" ; --UNCHK
lin count_towards_V2 = prepV2 OP_count_V OP_towards_Prep ; -- guess-p-verb
lin count_up_V2 = prepV2 OP_count_V OP_up_Prep ; -- guess-p-verb
lin count_upon_V2 = prepV2 OP_count_V OP_upon_Prep ; -- guess-p-verb
lin countable_A = mkWA (k10 "oleva") "laskettavissa" ; --UNCHK
lin countdown_N = mkWN (compoundN "lähtö" (k9A "laskenta")) ; --UNCHK
lin countenance_N = mkWN (k48 "ilme") ; --UNCHK
lin countenance_V2 = mkWV2 (k53 "päästää") ; --UNCHK
lin counter_Adv = mkWAdv "päinvastaiseen" "suuntaan" ; --UNCHK
lin counter_N = mkWN (compoundN "vasta" (k1 "isku")) ; --UNCHK
lin counter_V = mkWV (k73 "vastata") ; --UNCHK
lin counter_VS = mkWVS (k73 "vastata") ;
lin counteract_V2 = mkWV2 (k62 "sabotoida") ; --UNCHK
lin counteraction_N = mkWN (compoundN "vasta" (k1 "isku")) ; --UNCHK
lin counteractive_A = mkWA (k10 "vaikuttava") "vastaan" ; --UNCHK
lin counterargument_N = mkWN (compoundN "vasta" (k48A "väite")) ; --UNCHK
lin counterattack_N = mkN "vasta" (mkN "hyökkäys") ;
lin counterattack_V = mkV (mkV "hyökätä") "takaisin" ;
lin counterattack_V2 = mkV2 (mkV (mkV "hyökätä") "takaisin") (mkPrep "kimppuun") ;
lin counterattraction_N = mkWN (compoundN "veto" (k2 "numero")) "kilpaileva" ; --UNCHK
lin counterbalance_N = mkWN (compoundN "vasta" (k1 "paino")) ; --UNCHK
lin counterbalance_V2 = mkWV2 (k62 "mitätöidä") ; --UNCHK
lin counterblast_N = mkWN (k39 "vastustus") "voimakas" ; --UNCHK
lin counterblow_N = mkWN (compoundN "vasta" (k1 "isku")) ; --UNCHK
lin counterbombardment_N = mkWN (compoundN "vasta" (k39 "pommitus")) ; --UNCHK
lin counterbore_N = mkWN "kartioupotuspora" ; --UNCHK
lin countercharge_N = mkWN (compoundN "vasta" (k39 "hyökkäys")) ; --UNCHK
lin countercheck_N = mkWN (k39 "varmistus") ; --UNCHK
lin counterclaim_N = mkWN (compoundN "vasta" (k48A "kanne")) ; --UNCHK
lin counterclockwise_A = mkWA (k38 "suuntainen") "vastapäivän" ; --UNCHK
lin counterclockwise_Adv = mkWAdv (k99 "vastapäivään") ; --UNCHK
lin countercoup_N = mkWN "vastavallankaappaus" ; --UNCHK
lin counterculture_N = mkWN (compoundN "vasta" (k6 "kulttuuri")) ; --UNCHK
lin countercurrent_N = mkWN (compoundN "vasta" (k39 "virtaus")) ; --UNCHK
lin counterdemonstration_N = mkWN "vastamielenosoitus" ; --UNCHK
lin counterdemonstrator_N = mkWN "vastamielenosoittaja" ; --UNCHK
lin counterespionage_N = mkWN (compoundN "vasta" (k2 "vakoilu")) ; --UNCHK
lin counter_example_N = mkWN "vastaesimerkki" ; --UNCHK
lin counterfactual_A = mkWA (k38 "vastainen") "tosiasioiden" ; --UNCHK
lin counterfactuality_N = mkWN (k40 "vastaisuus") "tosiasioiden" ; --UNCHK
lin counterfeit_A = mkWA (k10 "väärä") ; --UNCHK
lin counterfeit_N = mkWN (k10 "jäljitelmä") ; --UNCHK
lin counterfeit_V2 = mkWV2 (k54A "väärentää") ; --UNCHK
lin counterfeiter_N = mkWN (k10 "väärentäjä") ; --UNCHK
lin counterfire_N = mkWN (compoundN "vasta" (k23 "tuli")) ; --UNCHK
lin counterfoil_N = mkWN (k9A "kanta") "shekin" ; --UNCHK
lin counterglow_N = mkWN (compoundN "vasta" (k1 "valo")) ; --UNCHK
lin counterinsurgent_A = mkWA (compoundA "vasta" (k38 "kumouksellinen")) ; --UNCHK
lin counterintelligence_N = mkWN (compoundN "vasta" (k2 "vakoilu")) ; --UNCHK
lin counterirritant_N = mkWN (compoundN "vasta" (k48A "ärsyke")) ; --UNCHK
lin countermand_N = mkWN (k39 "peruutus") ; --UNCHK
lin countermand_V2 = mkWV2 (k74 "kumota") ; --UNCHK
lin countermarch_N = mkWN (compoundN "paluu" (k5 "marssi")) ; --UNCHK
lin countermeasure_N = mkWN (compoundN "vasta" (k25 "toimi")) ; --UNCHK
lin countermine_N = mkWN (k6 "tunneli") "vastatoimena" "kaivettu" ; --UNCHK
lin countermine_V = mkWV (k73 "raivata") "miinoja" ; --UNCHK
lin countermine_V2 = mkWV2 (k73 "raivata") "miinoja" ; --UNCHK
lin counteroffensive_N = mkWN (compoundN "vasta" (k5 "offensiivi")) ; --UNCHK
lin counteroffer_N = mkWN (compoundN "vasta" (k39 "tarjous")) ; --UNCHK
lin counterpane_N = mkWN (k48A "peite") ; --UNCHK
lin counterpart_N = mkN "vastine" ;
lin counterperson_N = mkWN (k12 "tarjoilija") ; --UNCHK
lin counterplea_N = mkWN (compoundN "vasta" (k48A "väite")) ; --UNCHK
lin counterplot_N = mkWN (compoundN "vasta" (k10 "suunnitelma")) ; --UNCHK
lin counterplot_V = mkWV (k61A "laatia") "vastajuoni" ; --UNCHK
lin counterplot_V2 = mkWV2 (k61A "laatia") "vastajuoni" ; --UNCHK
lin counterpoint_N = mkWN (k5 "kontrapunkti") ; --UNCHK
lin counterpoise_N = mkWN (compoundN "vasta" (k1 "paino")) ; --UNCHK
lin counterpoise_V2 = mkWV2 (k61 "toimia") "vastapainona" ; --UNCHK
lin counterproductive_A = mkWA (k38 "haitallinen") ; --UNCHK
lin counterproposal_N = mkWN (compoundN "vasta" (k39 "ehdotus")) ; --UNCHK
lin counterpunch_N = mkWN (compoundN "vasta" (k1 "isku")) ; --UNCHK
lin counterreformation_N = mkWN "vastauskonpuhdistus" ; --UNCHK
lin counter_revolution_N = mkWN "vastavallankumous" ; --UNCHK
lin counter_revolutionary_A = mkWA "vastavallankumouksellinen" ; --UNCHK
lin counterrevolutionist_N = mkWN "vastavallankumouksellinen" ; --UNCHK
lin countershot_N = mkWN (compoundN "vasta" (k39 "laukaus")) ; --UNCHK
lin countersign_N = mkWN (k39 "varmennus") ; --UNCHK
lin countersign_V2 = mkWV2 (k54A "varmentaa") "nimikirjoituksella" ; --UNCHK
lin countersignature_N = mkWN (k39 "varmennus") ; --UNCHK
lin countersink_N = mkWN "kartioupotuspora" ; --UNCHK
lin countersink_V2 = mkWV2 (k53A "upottaa") ; --UNCHK
lin counterspy_N = mkWN (k10 "vakooja") ; --UNCHK
lin counterstain_N = mkWN (compoundN "vastaväri" (k1A "laikku")) ; --UNCHK
lin countersubversion_N = mkWN (k9A "toiminta") "vastakumouksellinen" ; --UNCHK
lin countersuit_N = mkWN (compoundN "vasta" (k48A "kanne")) ; --UNCHK
lin countertenor_A = mkWA (compoundA "kontraten" (k48 "ori")) ; --UNCHK
lin countertenor_N = mkWN (k1A "altto") ; --UNCHK
lin counterterror_A = mkWA "terrorismin" "torjunta-" ; --UNCHK
lin counterterrorism_N = mkWN (compoundN "torjunta" (k12 "strategia")) "terrorismin" ; --UNCHK
lin counterterrorist_N = mkWN "terrorismintorjuja" ; --UNCHK
lin countertop_N = mkWN (compoundN "tiskin" (k38 "päällinen")) ; --UNCHK
lin countertransference_N = mkWN (compoundN "vasta" (k5 "transferenssi")) ; --UNCHK
lin countervail_V = mkWV (k62 "mitätöidä") ; --UNCHK
lin countervail_V2 = mkWV2 (k62 "mitätöidä") ; --UNCHK
lin counterweight_N = mkWN (compoundN "vasta" (k1 "paino")) ; --UNCHK
lin countess_N = mkWN (k32A "kreivitär") ; --UNCHK
lin counting_house_N = mkWN (k6 "konttori") ; --UNCHK
lin countless_A = mkWA (k34A "rajaton") ; --UNCHK
lin countrified_A = mkWA (k38 "maaseutumainen") ; --UNCHK
lin country_N = L.country_N ;
lin country_house_N = mkWN (k2 "kartano") ; --UNCHK
lin countryman_N = mkWN (compoundN "maan" (k42 "mies")) ; --UNCHK
lin country_seat_N = mkWN (compoundN "suur" (k9 "tila")) ; --UNCHK
lin countryside_N = mkWN (k18 "maa") ; --UNCHK
lin countrywide_A = mkWA (compoundA "maan" (k38 "laajuinen")) ; --UNCHK
lin countrywoman_N = mkWN (compoundN "maan" (k42 "mies")) ; --UNCHK
lin county_N = mkWN (compoundN "maa" (k10A "kunta")) | mkWN (compoundN "kreivi" (k10A "kunta")) ;
lin countywide_A = mkWA (k38 "laajuinen") "piirikunnan" ; --UNCHK
lin coup_N = mkWN (k39 "menestys") ; ---ARB --mkN "vallankaappaus" ;
lin coup_d'etat_N = mkWN (compoundN "vallan" (k39 "kaappaus")) ; --UNCHK
lin coup_de_grace_N = mkWN (compoundN "armon" (k1 "isku")) ;
lin coupe_N = mkWN "kupee" ; --UNCHK
lin couple_N = mkN "pari" ;
lin couple_V = mkWV (k53 "yhdistää") ; --UNCHK
lin couple_V2 = mkWV2 (k53 "yhdistää") ;
lin couplet_N = mkWN (k5 "säepari") ; --UNCHK
lin coupling_N = mkWN (k38 "kanssakäyminen") "seksuaalinen" ; --UNCHK
lin coupon_N = mkN "kuponki" ; --f80
lin courage_N = mkWN (k40 "urhoollisuus") ; --UNCHK
lin courageous_A = mkWA (k38 "urhoollinen") ; --UNCHK
lin courante_N = mkWN "courante" ; --UNCHK
lin courbaril_N = mkWN "Hymenaea" "courbaril" ; --UNCHK
lin courgette_N = mkWN (compoundN "kesä" (k13 "kurpitsa")) ; --UNCHK
lin courier_N = mkWN (k6 "kuriiri") ;
lin courlan_N = mkWN (compoundN "kotilo" (k7A "kurki")) ; --UNCHK
lin course_N = mkN "kurssi" ;
lin course_V = mkWV (k56 "ajaa") ; --UNCHK
lin course_V2 = mkWV2 (k56 "ajaa") ; --UNCHK
lin courser_N = mkWN (compoundN "pääsky" (k10 "kahlaaja")) ; --UNCHK
lin coursework_N = mkWN (compoundN "opinto" (k10 "tehtävä")) ; --UNCHK
lin coursing_N = mkWN (compoundN "koira" (k39 "metsästys")) ; --UNCHK
lin court_1_N = mkN "hovi" ;
lin court_2_N = mkN "tuomioistuin" ;
lin court_N = mkN "tuomioistuin" ;
lin court_V = mkWV (k67A "vokotella") ; --UNCHK
lin court_V2 = mkV2 "kosiskella" partitive ;
lin court_card_N = mkWN (compoundN "kuva" (k5A "kortti")) ; --UNCHK
lin courteous_A = mkWA (k41 "kohtelias") ; --UNCHK
lin courtesan_N = mkWN (k32A "rakastajatar") ; --UNCHK
lin courtesy_N = mkWN (k40 "kohteliaisuus") ; --UNCHK
lin courthouse_N = mkWN (compoundN "oikeus" (k1 "talo")) ; --UNCHK
lin courtier_N = mkWN (compoundN "hovi" (k9 "herra")) ; --UNCHK
lin courtliness_N = mkWN (k40 "hienostuneisuus") ; --UNCHK
lin courtly_A = mkWA (k41A "arvokas") ; --UNCHK
lin courtroom_N = mkWN (compoundN "oikeus" (k5 "sali")) ; --UNCHK
lin courtship_N = mkWN (k17 "riiuu") ; --UNCHK
lin courtyard_N = mkWN (k9 "piha") ; --UNCHK
lin couscous_N = mkWN (k5 "kuskus") ; --UNCHK
lin cousin_N = L.cousin_N ;
lin couth_A = mkWA (k47 "hienostunut") ; --UNCHK
lin couthie_A = mkWA (k38 "ystävällinen") ; --UNCHK
lin couture_N = mkWN "haute" "couture" ; --UNCHK
lin couturier_N = mkWN (k12 "suunnittelija") ; --UNCHK
lin couvade_N = mkWN (compoundN "lapsi" (k48A "vuode")) "miehen" ; --UNCHK
lin couverture_N = mkWN (compoundN "kuorrute" (k17 "suklaa")) ; --UNCHK
lin covalence_N = mkWN "kovalenssi" ; --UNCHK
lin covalent_A = mkWA (compoundA "kova" (k38 "lenttinen")) ; --UNCHK
lin covariance_N = mkWN "kovarianssi" ; --UNCHK
lin covariant_A = mkWA "kovariantti" ; --UNCHK
lin covariation_N = mkWN (compoundN "yhteis" (k2 "vaihtelu")) ; --UNCHK
lin cove_N = mkWN (k7A "merenlahti") ; --UNCHK
lin coven_N = mkWN (k39 "kokous") "noitien" ; --UNCHK
lin covenant_N = mkWN (k1A "liitto") ; --UNCHK
lin covenant_V = mkWV (k52A "sitoutua") ; --UNCHK
lin covenant_V2 = mkWV2 (k52A "sitoutua") ; --UNCHK
lin coventry_PN = foreignPN "Coventry" ;
lin cover_N = mkN "kansi" "kannen" "kansia" ;
lin cover_V2 = mkV2 "peittää" ;
lin cover_for_V2 = mkWV2 (k61 "keksiä") "verukkeita" ; --UNCHK
lin cover_up_V2 = mkWV2 (k67A "peitellä") ; --UNCHK
lin coverage_N = mkN "kattavuus" ;
lin coverall_N = mkWN (k6 "haalari") ; --UNCHK
lin covering_N = mkN "peite" ; --WN (k2 "sively") ;
lin coverlet_N = mkWN (compoundN "päivä" (k48A "peite")) ; --UNCHK
lin covert_A = mkWA (k38 "salainen") ; --UNCHK
lin covert_N = mkWN (k1 "piilo") ; --UNCHK
lin covet_V2 = mkWV2 (k75 "haluta") ; --UNCHK
lin covetous_A = mkWA (k1 "perso") ; --UNCHK
lin covetousness_N = mkWN (k40 "kyltymättömyys") ; --UNCHK
lin covey_N = mkWN (k7 "peltopyyparvi") "pieni" ; --UNCHK
lin cow_N = L.cow_N ;
lin cow_V2 = mkWV2 (k53A "pelottaa") ; --UNCHK
lin coward_N = mkWN (k6 "pelkuri") ; --UNCHK
lin cowardice_N = mkWN (k40 "pelkuruus") ; --UNCHK
lin cowardly_A = mkWA (k41A "pelokas") ; --UNCHK
lin cowbarn_N = mkWN (k10 "läävä") ; --UNCHK
lin cowbell_N = mkWN (compoundN "lehmän" (k1 "kello")) ; --UNCHK
lin cowberry_N = mkWN (k14A "puolukka") ; --UNCHK
lin cowboy_N = mkWN (k21 "cowboy") ; --UNCHK
lin cowcatcher_N = mkWN (k6 "puskuri") ; --UNCHK
lin cowdenbeath_PN = foreignPN "Cowdenbeath" ;
lin cower_V = mkWV (k52 "kyyristyä") "peloissaan" ; --UNCHK
lin cowes_PN = foreignPN "Cowes" ;
lin cowfish_N = mkWN "Lactophrys" "quadricornis" ; --UNCHK
lin cowgirl_N = mkWN (compoundN "karja" (k32 "paimen")) ; --UNCHK
lin cowhand_N = mkWN (k21 "cowboy") ; --UNCHK
lin cowherb_N = mkWN (compoundN "touko" (k10A "kukka")) ; --UNCHK
lin cowherd_N = mkWN (k21 "cowboy") ; --UNCHK
lin cowhide_N = mkWN (compoundN "nahka" (k9 "piiska")) ; --UNCHK
lin cowhouse_N = mkWN (k10 "läävä") ; --UNCHK
lin cowl_N = mkWN (k1A "huppu") ; --UNCHK
lin cowled_A = mkWA "kaapuun" "puettu" ; --UNCHK
lin cowlick_N = mkWN (compoundN "hius" (k1 "tupsu")) ; --UNCHK
lin cowling_N = mkWN (k39 "suojus") "moottorin" ; --UNCHK
lin cowman_N = mkWN (k21 "cowboy") ; --UNCHK
lin cowpea_N = mkWN (compoundN "lehmän" (k1A "papu")) ; --UNCHK
lin cowpox_N = mkWN (compoundN "lehmä" (k1A "rokko")) ; --UNCHK
lin cowshed_N = mkWN (k10 "läävä") ; --UNCHK
lin cowskin_N = mkWN (compoundN "naudan" (k9 "nahka")) ; --UNCHK
lin cowslip_N = mkWN (k14A "rentukka") ; --UNCHK
lin cox_N = mkWN (compoundN "perän" (k10 "pitäjä")) ; --UNCHK
lin coxcomb_N = mkWN (k9 "harja") ; --UNCHK
lin coxsackievirus_N = mkWN (compoundN "coxsackie" (k39 "virus")) ; --UNCHK
lin coxswain_N = mkWN (compoundN "perän" (k10 "pitäjä")) ; --UNCHK
lin coy_A = mkWA (k1 "kaino") ; --UNCHK
lin coyness_N = mkWN (k40 "siveys") "teennäinen" ; --UNCHK
lin coyol_N = mkWN "Acrocomia" "vinifera" ; --UNCHK
lin coyote_N = mkWN (k5A "kojootti") ; --UNCHK
lin coypu_N = mkWN (k12 "nutria") ; --UNCHK
lin cozen_V2 = mkWV2 (k53A "pettää") ; --UNCHK
lin coziness_N = mkWN (k40 "mukavuus") ; --UNCHK
lin cozy_A = mkWA (k10 "kätevä") ; --UNCHK
lin cozy_up_V = mkWV (k67 "nuoleskella") ; --UNCHK
lin crab_N = mkWN (kH1 "veto") "tyhjä" ; --UNCHK
lin crab_V = mkWV (k53A "valittaa") ; --UNCHK
lin crab_V2 = mkWV2 (k53A "valittaa") ; --UNCHK
lin crab_apple_N = mkWN (compoundN "metsä" (k11 "omena")) ; --UNCHK
lin crabbiness_N = mkWN (k40 "äreys") ; --UNCHK
lin crabgrass_N = mkWN (compoundN "veri" (k5 "hirssi")) ; --UNCHK
lin crabwise_A = mkWA (k38 "sivuttainen") ; --UNCHK
lin crack_N = mkWN (compoundN "rikko" (k38 "minen")) ; --UNCHK
lin crack_V2 = mkV2 "murtaa" ; --WV2 "krakkautua" ;
lin crack_up_V = mkWV (k53A "hohottaa") ; --UNCHK
lin crack_up_V2 = mkWV2 (k53A "hohottaa") ; --UNCHK
lin crackbrained_A = mkWA (k38 "idioottimainen") ; --UNCHK
lin crack_down_N = mkWN (k12 "ratsia") ; --UNCHK
lin cracker_N = mkWN (compoundN "paukku" (k5 "karamelli")) ; --UNCHK
lin crackers_A = mkWA (k1 "pöllö") ; --UNCHK
lin cracking_N = mkWN (compoundN "rikko" (k38 "minen")) ; --UNCHK
lin crackle_A = mkWA (compoundA "särö" (k38 "lasitteinen")) ; --UNCHK
lin crackle_N = mkWN (k6 "posliini") "särölasitteinen" ; --UNCHK
lin crackle_china_N = mkWN (k6 "posliini") "särölasitteinen" ; --UNCHK
lin crackleware_N = mkWN (k6 "posliini") "särölasitteinen" ; --UNCHK
lin crackling_N = mkWN (k39 "risahdus") ; --UNCHK
lin cracklings_N = mkWN (kH1 "kuori") "kinkun" ; --UNCHK
lin crackpot_N = mkWN (k10 "pöljä") ; --UNCHK
lin cracksman_N = mkWN (k10 "murtautuja") ; --UNCHK
lin cradle_N = mkWN (k1A "kehto") ; --UNCHK
lin craft_N = mkWN (k1A "taito") ; --UNCHK
lin craft_V2 = mkV2 "valmistella" ; --mkWV2 (k53 "valmistaa") "käsin" ;
lin craftiness_N = mkWN (k40 "juonikkuus") ; --UNCHK
lin craftsman_N = mkWN (k5 "artesaani") ; --UNCHK
lin craftsmanship_N = mkWN (compoundN "ammatti" (k1A "taito")) ; --UNCHK
lin crafty_A = mkWA (k10 "näppärä") ; --UNCHK
lin crag_N = mkWN (k3 "kallio") "jyrkkä" "rosoinen" ; --UNCHK
lin cragfast_A = mkWA (k99 "jumissa") ; --UNCHK
lin cragged_A = mkWA (k38 "kukkulainen") ; --UNCHK
lin craggy_A = mkWA (k38 "kukkulainen") ; --UNCHK
lin cragsman_N = mkWN (compoundN "vuori" (k12 "kiipeilijä")) ; --UNCHK
lin crake_N = mkWN (compoundN "ranta" (k9 "kana")) ; --UNCHK
lin cram_V = mkWV (k56A "ahtaa") "päähänsä" ; --UNCHK
lin cram_V2 = mkWV2 (k56A "ahtaa") "päähänsä" ; --UNCHK
lin cram_full_A = mkWA (k99 "täynnä") "tupaten" ; --UNCHK
lin cramlington_PN = foreignPN "Cramlington" ;
lin crammer_N = mkWN (compoundN "preppaus" (k9 "kirja")) ; --UNCHK
lin cramp_N = mkWN (k1 "määrly") ; --UNCHK
lin cramp_V2 = mkWV2 (k53A "vetää") "suonta" ; --UNCHK
lin cramp_iron_N = mkWN (k1 "määrly") ; --UNCHK
lin crampon_N = mkWN (k9 "nasta") ; --UNCHK
lin cran_N = mkWN "cran" ; --UNCHK
lin cranberry_N = mkWN (k2 "karpalo") ; --UNCHK
lin crane_N = mkWN (k7A "kurki") ;
lin crane_V = mkWV (k52A "kurkottautua") ; --UNCHK
lin crane_V2 = mkWV2 (k52A "kurkottautua") ; --UNCHK
lin crane_fly_N = mkWN (k38 "vaaksiainen") ; --UNCHK
lin cranesbill_N = mkWN (compoundN "kurjenp" (k5 "olvi")) ; --UNCHK
lin cranial_A = mkWA "kallon" ; --UNCHK
lin craniology_N = mkWN (compoundN "kallo-" (k5A "oppi")) ; --UNCHK
lin craniometer_N = mkWN (compoundN "mittaus" (k48A "laite")) "kallon" ; --UNCHK
lin craniometric_A = mkWA (compoundA "kranio" (k38 "metrinen")) ; --UNCHK
lin craniometry_N = mkWN "kraniometria" ; --UNCHK
lin craniotomy_N = mkWN (k39 "avaus") "kallon" ; --UNCHK
lin cranium_N = mkWN (k1 "kallo") ; --UNCHK
lin crank_A = mkWA (k11 "hutera") ; --UNCHK
lin crank_N = mkWN (k5 "veivi") ; --UNCHK
lin crank_V2 = mkWV2 (k53A "taivuttaa") "polvelle" ; --UNCHK
lin crank_up_V2 = mkWV2 (k73 "veivata") ; --UNCHK
lin crankcase_N = mkWN (compoundN "kampi" (k3 "kammio")) ; --UNCHK
lin crankiness_N = mkWN (k40 "uppiniskaisuus") ; --UNCHK
lin crankshaft_N = mkWN (compoundN "kampi" (k6 "akseli")) ; --UNCHK
lin cranky_A = mkWA (k34A "kärsimätön") ; --UNCHK
lin crannied_A = mkWA (k38 "koloinen") ; --UNCHK
lin cranny_N = mkWN (k1 "kolo") ; --UNCHK
lin crap_N = mkWN (k1 "fusku") ; --UNCHK
lin crap_V = mkWV (k73A "kakata") ; --UNCHK
lin crap_shooting_N = mkWN "crapsin" "pelaaminen" ; --UNCHK
lin crapaud_N = mkWN "Leptodactylus" "pentadactylus" ; --UNCHK
lin crape_N = mkWN (k5A "kreppi") ; --UNCHK
lin crappie_N = mkWN "Pomoxis" ; --UNCHK
lin craps_N = mkWN "craps" ; --UNCHK
lin crapshoot_N = mkWN "crapsin" "pelaaminen" ; --UNCHK
lin crapshooter_N = mkWN (k10 "pelaaja") "crapsin" ; --UNCHK
lin crapulent_A = mkWA (k38 "humalainen") ; --UNCHK
lin crapulous_A = mkWA (k38 "humalainen") ; --UNCHK
lin crash_N = mkN "törmays" ;
lin crash_V = mkWV (k52A "nukkua") ; --UNCHK
lin crash_dive_N = mkWN (k39 "sukellus") "nopea" ; --UNCHK
lin crash_dive_V = variants {} ; -- guess-p-verb
lin crash_helmet_N = mkWN (compoundN "suoja" (k10 "kypärä")) ; --UNCHK
lin crash_land_V = mkWV (k71 "tehdä") "pakkolasku" ; --UNCHK
lin crash_land_V2 = mkWV2 (k71 "tehdä") "pakkolasku" ; --UNCHK
lin crash_landing_N = mkWN (compoundN "maahan" (k1 "syöksy")) ; --UNCHK
lin crash_out_V = advV OP_crash_V OP_out_Adv ; -- guess-p-verb
lin crass_A = mkWA (k15 "röyhkeä") ; --UNCHK
lin crassness_N = mkWN (k40 "karkeus") ; --UNCHK
lin crate_N = mkWN (k4A "laatikko") ; --UNCHK
lin crater_N = mkWN (k6 "kraatteri") ; --UNCHK
lin craton_N = mkWN (compoundN "manner" (k33A "ydin")) ; --UNCHK
lin cravat_N = mkWN (k3 "solmio") ; --UNCHK
lin crave_V = mkWV (k54A "pyytää") "hartaasti" ; --UNCHK
lin crave_V2 = mkWV2 (k54A "pyytää") "hartaasti" ; --UNCHK
lin craven_A = mkWA (k38 "raukkamainen") ; --UNCHK
lin craven_N = mkWN (k9A "raukka") ; --UNCHK
lin cravenness_N = mkWN "pelkurimaisuus" ; --UNCHK
lin craving_N = mkWN (k1 "jano") ; --UNCHK
lin craw_N = mkWN (k1A "kupu") ; --UNCHK
lin crawfish_N = mkWN (k5 "langusti") ; --UNCHK
lin crawl_N = mkWN (k39 "konttaus") ; --UNCHK
lin crawl_V = mkWV (k61A "mönkiä") ; --UNCHK
lin crawler_N = mkWN (k1 "liero") ; --UNCHK
lin crawley_PN = foreignPN "Crawley" ;
lin crawlspace_N = mkWN (compoundN "ryömintä" (k9 "tila")) ; --UNCHK
lin crayfish_N = mkWN (k5 "langusti") ; --UNCHK
lin crayon_N = mkWN (compoundN "vaha" (k1A "liitu")) ; --UNCHK
lin crayon_V2 = mkWV2 (k54A "piirtää") "väriliidulla" ; --UNCHK
lin craze_N = mkWN (k1 "särö") ; --UNCHK
lin crazed_A = mkWA (k47 "häiriintynyt") ; --UNCHK
lin craziness_N = mkWN (k39 "hullutus") ; --UNCHK
lin crazy_A = mkWA (k47 "höpsähtänyt") ; --UNCHK
lin crazy_N = mkWN (k6 "kaheli") ; --UNCHK
lin creak_N = mkWN (k12 "kitinä") ; --UNCHK
lin creak_V = mkWV (k66 "natista") ; --UNCHK
lin creaky_A = mkWA (k38 "reumaattinen") ; --UNCHK
lin cream_N = mkWN (k48A "voide") ; --UNCHK
lin cream_V2 = mkWV2 (k53A "rökittää") ; --UNCHK
lin creamcups_N = mkWN "Platystemon" "californicus" ; --UNCHK
lin creamery_N = mkWN (k6 "meijeri") ; --UNCHK
lin creaminess_N = mkWN "sakeus" ; --UNCHK
lin creamy_A = mkWA (compoundA "kerman" (k38 "valkoinen")) ; --UNCHK
lin crease_N = mkWN "kris" ; --UNCHK
lin crease_V = mkWV (k52A "poimuttua") ; --UNCHK
lin crease_V2 = mkWV2 (k52A "poimuttua") ; --UNCHK
lin creaseless_A = mkWA "rypytön" ; --UNCHK
lin creaseproof_A = mkWA (k34A "rypistymätön") ; --UNCHK
lin create_V = mkV "luoda" ;
lin create_V2 = mkV2 "luoda" ;
lin creatine_N = mkWN "kreatiini" ; --UNCHK
lin creation_N = mkWN (compoundN "luoma" (k10A "kunta")) ; --UNCHK
lin creationism_N = mkWN (k5 "kreationismi") ; --UNCHK
lin creative_A = mkWA (k10 "luova") ;
lin creativeness_N = mkWN (k2 "ajattelu") "luova" ; --UNCHK
lin creativity_N = mkWN (k2 "ajattelu") "luova" ; --UNCHK
lin creator_N = mkN "luoja" ; --mkWN (compoundN "Kaikki" (k41 "valtias")) ;
lin creature_N = mkWN (k3 "olio") ; --UNCHK
lin creche_N = mkWN "löytölastenkoti" ; --UNCHK
lin credence_N = mkWN (compoundN "sivu" (k10A "pöytä")) ; --UNCHK
lin credenza_N = mkWN (compoundN "sivu" (k10A "pöytä")) ; --UNCHK
lin credibility_N = mkN "uskottavuus" | mkWN (k40 "luotettavuus") ;
lin credible_A = mkWA (k10 "uskottava") ;
lin credit_N = mkN "luotto" ;
lin credit_V2 = mkWV2 (k52 "uskoa") ; --UNCHK
lin credit_side_N = mkWN (compoundN "credit-" (k26 "puoli")) ; --UNCHK
lin creditable_A = mkWA (k41A "kunniakas") ; --UNCHK
lin creditor_N = mkWN (k10 "velkoja") ; --f140
lin credits_N = mkWN (compoundN "tekijä" (k2 "luettelo")) ; --UNCHK
lin credit_worthiness_N = mkWN (compoundN "luotto" (k40 "kelpoisuus")) ; --UNCHK
lin credit_worthy_A = mkWA (k10 "luotettava") ; --UNCHK
lin credo_N = mkWN (k5A "oppi") ; --UNCHK
lin credulity_N = mkWN "herkkäuskoisuus" ; --UNCHK
lin credulous_A = mkWA (compoundA "sini" (k38 "silmäinen")) ; --UNCHK
lin credulousness_N = mkWN "hyväuskoisuus" ; --UNCHK
lin creed_N = mkWN (k5A "oppi") ; --UNCHK
lin creedal_A = mkWA "uskon" ; --UNCHK
lin creek_N = mkWN (k1 "puro") ; --UNCHK
lin creel_N = mkWN (compoundN "kala" (k5 "kori")) ; --UNCHK
lin creep_N = mkWN (k39 "konttaus") ; --UNCHK
lin creep_V = mkV "madella" ;
lin creep_in_V = mkWV (k53A "pujahtaa") ; --UNCHK
lin creep_up_V = mkWV (k61A "hiipiä") ; --UNCHK
lin creeper_N = mkWN (compoundN "puu" (k12 "kiipijä")) ; --UNCHK
lin creepy_A = mkWA (k10 "karmiva") ; --UNCHK
lin cremains_N = mkWN (k10 "tuhka") "vainajan" ; --UNCHK
lin cremate_V2 = mkWV2 (k53A "polttaa") "tuhkaksi" ; --UNCHK
lin cremation_N = mkWN (k39 "tuhkaus") ; --UNCHK
lin crematorium_N = mkWN (k3 "krematorio") ; --UNCHK
lin crematory_N = mkWN (k3 "krematorio") ; --UNCHK
lin crenate_A = mkWA (compoundA "hammas" (k1 "tettu")) ; --UNCHK
lin crenel_N = mkWN (compoundN "ampuma-" (k1A "aukko")) ; --UNCHK
lin crenulate_A = mkWA (compoundA "nyhä" (k38 "laitainen")) ; --UNCHK
lin creole_A = mkWA (compoundA "kreoli" (k38 "lainen")) ; --UNCHK
lin creole_N = mkWN (k5 "kreoli") ; --UNCHK
lin creosol_N = mkWN "kreosoli" ; --UNCHK
lin creosote_N = mkWN (compoundN "kreosootti" (k1 "öljy")) ; --UNCHK
lin crepe_1_N = mkWN (k5A "kreppi") ; --UNCHK ---- sense to be split
lin crepe_2_N = mkWN (k5A "kreppi") ; --UNCHK ---- sense to be split
lin crepe_N = mkWN (k5A "kreppi") ; --UNCHK
lin crepitate_V = mkWV (k66 "ratista") ; --UNCHK
lin crepitation_N = mkWN (k39 "risahdus") ; --UNCHK
lin crepuscular_A = mkWA "hämärä-" ; --UNCHK
lin cres_PN = foreignPN "Cres" ;
lin crescendo_A = mkWA "voimistuva" ; --UNCHK
lin crescendo_N = mkWN "crescendo" ; --UNCHK
lin crescent_N = mkWN (k5A "sirppi") ; --UNCHK
lin cresol_N = mkWN (compoundN "butyyli" (k5 "fenoli")) ; --UNCHK
lin cress_N = mkWN (k5 "krassi") ; --UNCHK
lin crest_N = mkWN (k1A "töyhtö") ; --UNCHK
lin crest_V = mkWV (k66 "nousta") "korkeimmilleen" ; --UNCHK
lin crest_V2 = mkWV2 (k66 "nousta") "korkeimmilleen" ; --UNCHK
lin crestfallen_A = mkWA (k38 "alakuloinen") ; --UNCHK
lin creswell_PN = foreignPN "Creswell" ;
lin cretaceous_A = mkWA "liitukauden" ; --UNCHK
lin cretin_N = mkWN (k1 "tollo") ; --UNCHK
lin cretinism_N = mkWN (compoundN "kretin" (k5 "ismi")) ; --UNCHK
lin cretinous_A = mkWA "kretinismistä" "kärsivä" ; --UNCHK
lin cretonne_N = mkWN (k5A "kretonki") ; --UNCHK
lin crevasse_N = mkWN (k1 "railo") ; --UNCHK
lin crevice_N = mkWN (k1A "rako") ; --UNCHK
lin crew_N = mkWN (k2 "miehistö") ; --UNCHK
lin crew_V = mkWV (k52 "kuulua") "miehistöön" ; --UNCHK
lin crew_cut_N = mkWN (compoundN "pysty" (k10A "tukka")) ; --UNCHK
lin crew_neck_N = mkWN (compoundN "pään" (k19 "tie")) "pyöreä" ; --UNCHK
lin crewe_PN = foreignPN "Crewe" ;
lin crewelwork_N = mkWN (compoundN "kirjonta" (k19 "työ")) ; --UNCHK
lin crewman_N = mkWN (k32 "jäsen") "miehistön" ; --UNCHK
lin crib_N = mkWN "cribbage" ; --UNCHK
lin crib_V = mkWV (k53 "vahvistaa") "salvoksella" ; --UNCHK
lin crib_V2 = mkWV2 (k53 "vahvistaa") "salvoksella" ; --UNCHK
lin cribbage_N = mkWN "cribbage" ; --UNCHK
lin cribbage_board_N = mkWN (compoundN "cribbage-" (k9A "lauta")) ; --UNCHK
lin crick_V2 = mkWV2 (k54A "vääntää") ; --UNCHK
lin cricket_N = mkWN (k5A "kriketti") ; --UNCHK
lin cricketer_N = mkWN (compoundN "kriketin" (k10 "pelaaja")) ; --UNCHK
lin crieff_PN = foreignPN "Crieff" ;
lin crier_N = mkWN (k12 "kaupustelija") ; --UNCHK
lin crime_N = mkWN (k39 "rikos") ;
lin criminal_A = mkA (lin AK {s = d38 "rikollinen"}) ;
lin criminal_N = mkWN (k10 "konna") ; --UNCHK
lin criminalism_N = mkWN (k40 "rikollisuus") ; --UNCHK
lin criminalization_N = mkWN (k5A "kriminalisointi") ; --UNCHK
lin criminalize_V2 = mkWV2 (k53 "julistaa") "laittomaksi" ; --UNCHK
lin criminative_A = mkWA (k10 "raskauttava") ; --UNCHK
lin criminological_A = mkWA (compoundA "rikos" (k38 "opillinen")) ; --UNCHK
lin criminologist_N = mkWN (k5 "kriminologi") ; --UNCHK
lin criminology_N = mkWN (k12 "kriminologia") ; --UNCHK
lin crimp_N = mkWN (k11 "kihara") "käherretty" ; --UNCHK
lin crimp_V2 = mkWV2 (k54A "sykertää") ; --UNCHK
lin crimson_A = mkWA (k38 "verinen") ; --UNCHK
lin crimson_N = mkWN (compoundN "rubiinin" (k38 "punainen")) ; --UNCHK
lin crimson_V = mkWV (k52 "punastua") ; --UNCHK
lin crimson_V2 = mkWV2 (k52 "punastua") ; --UNCHK
lin cringe_V = mkWV (k53A "säpsähtää") ; --UNCHK
lin cringle_N = mkWN (k14A "silmukka") ; --UNCHK
lin crinkle_N = mkWN (k1A "kurttu") ; --UNCHK
lin crinkle_V = mkWV (k52A "poimuttua") ; --UNCHK
lin crinkle_V2 = mkWV2 (k52A "poimuttua") ; --UNCHK
lin crinkleroot_N = mkWN (k26 "hammasjuuri") ; --UNCHK
lin crinkly_A = mkWA (k38 "ryppyinen") ; --UNCHK
lin crinoid_A = mkWA (k10 "kuuluva") "merililjoihin" ; --UNCHK
lin crinoid_N = mkWN (compoundN "meri" (k9 "lilja")) ; --UNCHK
lin crinoline_N = mkWN (k5 "krinoliini") ; --UNCHK
lin criollo_N = mkWN "criollo" ; --UNCHK
lin cripple_N = mkWN (k38 "vammainen") ; --UNCHK
lin cripple_V2 = mkWV2 (k53A "vammauttaa") ; --UNCHK
lin crippling_A = mkWA (compoundA "ramp" (k10 "auttava")) ; --UNCHK
lin crisis_N = mkN (lin NK {s = d05 "kriisi"}) ;
lin crisp_A = mkWA (k15 "selkeä") ; --UNCHK
lin crisp_N = mkWN (k5 "sipsi") ; --UNCHK
lin crisp_V = mkWV (k56A "paahtaa") ; --UNCHK
lin crisp_V2 = mkWV2 (k56A "paahtaa") ; --UNCHK
lin crispate_A = mkWA (k10 "kähärä") ; --UNCHK
lin crispness_N = mkWN (k40 "tuoreus") ; --UNCHK
lin crisscross_A = mkWA "ristikko-" ; --UNCHK
lin crisscross_Adv = mkWAdv (k99 "ristikkäin") ; --UNCHK
lin crisscross_N = mkWN (k5 "kruksi") ; --UNCHK
lin cristobalite_N = mkWN "kristobaliitti" ; --UNCHK
lin criterial_A = mkWA "kriteeri-" ; --UNCHK
lin criterion_N = mkWN (k6 "standardi") ; --UNCHK
lin crith_N = mkWN (k1 "paino") "vetylitran" ; --UNCHK
lin critic_N = mkN (lin NK {s = d04A "kriitikko"}) ;
lin critical_1_A = mkA "kriittinen" ;
lin critical_2_A = mkA "kriittinen" ;
lin critical_A = mkA "kriittinen" ;
lin criticality_N = mkWN (k9 "tila") "kriittinen" ; --UNCHK
lin criticism_N = mkN "kritiikki" ; --f56
lin criticize_V = mkWV (k61A "moittia") ;
lin criticize_V2 = mkV2 (mkV "kritisoida") partitive ;
lin critique_N = mkWN (k2 "tarkastelu") ; --UNCHK
lin critter_N = mkWN (k14A "elukka") ; --UNCHK
lin croak_N = mkWN "kurnutus" ; --UNCHK
lin croak_V = mkWV (k67 "kuolla") "äkillisesti" ; --UNCHK
lin croak_V2 = mkWV2 (k67 "kuolla") "äkillisesti" ; --UNCHK
lin croaker_N = mkWN (compoundN "rumpu" (k9 "kala")) ; --UNCHK
lin croaky_A = mkWA (compoundA "kähis" (k10 "evä")) ; --UNCHK
lin crochet_N = mkWN (k39 "virkkaus") ; --UNCHK
lin crochet_V = mkWV (k73A "virkata") ; --UNCHK
lin crochet_V2 = mkWV2 (k73A "virkata") ; --UNCHK
lin crochet_hook_N = mkWN (compoundN "virkkaus" (k1A "koukku")) ; --UNCHK
lin crocheting_N = mkWN (compoundN "virkkaa" (k38 "minen")) ; --UNCHK
lin crock_N = mkWN (compoundN "savi" (k12 "astia")) ; --UNCHK
lin crock_V = mkWV (k74A "noeta") ; --UNCHK
lin crock_V2 = mkWV2 (k74A "noeta") ; --UNCHK
lin crocket_N = mkWN (compoundN "lehti" (k48 "koriste")) ; --UNCHK
lin crocketed_A = mkWA "varustettu" "lehtikoristeella" ; --UNCHK
lin crocodile_N = mkWN (k5 "krokotiili") ; --UNCHK
lin crocolite_N = mkWN "krokoiitti" ; --UNCHK
lin crocus_N = mkWN (k39 "krookus") ; --UNCHK
lin croft_N = mkWN (compoundN "pien" (k9 "tila")) ; --UNCHK
lin crofter_N = mkWN (compoundN "pien" (k38 "tilallinen")) ; --UNCHK
lin cromer_PN = foreignPN "Cromer" ;
lin cromlech_N = mkWN (k9A "hauta") "kivikautinen" ; --UNCHK
lin crone_N = mkWN (k1A "harppu") ; --UNCHK
lin crony_N = mkWN (k10 "tuttava") ; --UNCHK
lin cronyism_N = mkWN (compoundN "suo" (k38 "siminen")) "ystävien" ; --UNCHK
lin crook_N = mkWN (compoundN "paimen" (k9 "sauva")) ; --UNCHK
lin crook_PN = foreignPN "Crook" ;
lin crook_V = mkWV (k53 "käyristää") ; --UNCHK
lin crook_V2 = mkWV2 (k53 "käyristää") ; --UNCHK
lin crook_back_A = mkWA (compoundA "koukku" (k38 "selkäinen")) ; --UNCHK
lin crookedness_N = mkWN (k40 "kieroutuneisuus") ; --UNCHK
lin crookneck_N = mkWN (compoundN "jättiläis" (k13 "kurpitsa")) ; --UNCHK
lin croon_V = mkWV (k67 "hyräillä") ; --UNCHK
lin croon_V2 = mkWV2 (k67 "hyräillä") ; --UNCHK
lin crooner_N = mkWN (k10 "laulaja") "viisujen" ; --UNCHK
lin crooning_N = mkWN (compoundN "lau" (k1 "lelu")) "iskelmien" ; --UNCHK
lin crop_N = mkWN (k1A "sato") ; --f65
lin crop_V = mkWV (k61 "oksia") ; --UNCHK
lin crop_V2 = mkWV2 (k61 "oksia") ; --UNCHK
lin crop_up_V = mkWV (k53A "putkahtaa") ; --UNCHK
lin cropper_N = mkWN (compoundN "maan" (k10 "vuokraaja")) ; --UNCHK
lin croquet_N = mkWN (k5A "kroketti") ; --UNCHK
lin croquette_N = mkWN (k14A "kuorukka") ; --UNCHK
lin crore_N = mkWN "kymmenen" "miljoonaa" ; --UNCHK
lin crosby_PN = foreignPN "Crosby" ;
lin crosier_N = mkWN (compoundN "piispan" (k9 "sauva")) ; --UNCHK
lin cross_A = mkWA (k10 "ärtyisä") ; --UNCHK
lin cross_N = mkWN (k39 "risteytys") ;
lin cross_V = mkWV (k53A "risteyttää") ; --UNCHK
lin cross_V2 = mkWV2 (k53A "risteyttää") ; --UNCHK
lin cross_examine_V2 = mkWV2 (compoundV "risti" (k67 "kuulustella")) ; --UNCHK
lin cross_fertilize_V2 = variants {} ; -- guess-p-verb
lin cross_index_V2 = variants {} ; -- guess-p-verb
lin cross_off_V2 = mkWV2 (k53 "poistaa") ; --UNCHK
lin cross_out_V2 = mkWV2 (k53 "poistaa") ; --UNCHK
lin cross_question_V2 = mkWV2 (compoundV "risti" (k67 "kuulustella")) ; --UNCHK
lin cross_section_N = mkWN (compoundN "vaikutus" (k9 "ala")) ; --UNCHK
lin cross_up_V2 = prepV2 OP_cross_V OP_up_Prep ; -- guess-p-verb
lin crossbar_N = mkWN (compoundN "poikki" (k18 "puu")) ; --UNCHK
lin crossbeam_N = mkWN (compoundN "poikki" (k5A "palkki")) ; --UNCHK
lin cross_bench_N = mkWN (k5A "penkki") "puolueettomien" ; --UNCHK
lin cross_bencher_N = mkWN (k32 "jäsen") "riippumaton" "alahuoneen" ; --UNCHK
lin crossbill_N = mkWN "pikkukäpylintu" ; --UNCHK
lin crossbow_N = mkWN (compoundN "varsi" (k26 "jousi")) ; --UNCHK
lin crossbreed_N = mkWN (k39 "risteytys") ; --UNCHK
lin crossbreed_V2 = mkWV2 (k53A "risteyttää") ; --UNCHK
lin crosscheck_N = mkWN (k9 "maila") "poikittainen" ; --UNCHK
lin crosscurrent_N = mkWN (compoundN "vasta" (k39 "virtaus")) ; --UNCHK
lin crosscut_N = mkWN (k2 "oikaisu") ; --UNCHK
lin crosse_N = mkWN (compoundN "haavipallo" (k9 "maila")) ; --UNCHK
lin crossfire_N = mkWN (compoundN "risti" (k23 "tuli")) ; --UNCHK
lin crosshairs_N = mkWN (compoundN "keski" (k48 "piste")) ; --UNCHK
lin crosshead_N = mkWN (compoundN "risti" (k48 "kappale")) ; --UNCHK
lin cross_heading_N = mkWN (compoundN "väli" (k4A "otsikko")) ; --UNCHK
lin crossing_N = mkWN (k39 "ylitys") ; --UNCHK
lin crossjack_N = mkWN (compoundN "mesaani" (k48 "purje")) ; --UNCHK
lin crossness_N = mkWN (k40 "äreys") ; --UNCHK
lin crossopterygian_N = mkWN (compoundN "varsi" (k38 "eväinen")) ; --UNCHK
lin crossover_N = mkWN (compoundN "suoja" (k19 "tie")) ; --UNCHK
lin crosspatch_N = mkWN (k12 "kiukuttelija") ; --UNCHK
lin crosspiece_N = mkWN (compoundN "risti" (k48 "kappale")) ; --UNCHK
lin crossroad_N = mkWN (k39 "risteys") ; --UNCHK
lin crossroads_N = mkWN (k10A "risteyskohta") ; --UNCHK
lin crosstalk_N = mkWN (compoundN "keskinäis" (k3 "häiriö")) ; --UNCHK
lin crosstown_A = mkWA (k99 "poikki") "kaupungin" ; --UNCHK
lin crosstown_Adv = mkWAdv (k99 "poikki") "kaupungin" ; --UNCHK
lin crosswalk_N = mkWN (compoundN "suoja" (k19 "tie")) ; --UNCHK
lin crosswind_N = mkWN (compoundN "sivu" (k26 "tuuli")) ; --UNCHK
lin crosswise_A = mkWA (k38 "poikittainen") ; --UNCHK
lin crosswise_Adv = mkWAdv (k99 "ristiin") ; --UNCHK
lin crossword_N = mkWN (compoundN "sana" (k4A "ristikko")) ; --UNCHK
lin crotalaria_N = mkWN (compoundN "kuitu" (k48 "herne")) ; --UNCHK
lin crotaphion_N = mkWN (k7A "kärki") "kitaluun" "isosiiven" ; --UNCHK
lin crotchet_N = mkWN (k1A "koukku") ; --UNCHK
lin crotchety_A = mkWA (k1 "häijy") ; --UNCHK
lin croton_N = mkWN (compoundN "ihme" (k41 "pensas")) ; --UNCHK
lin crottle_N = mkWN (compoundN "iso" (k48A "karve")) ; --UNCHK
lin crouch_N = mkWN (k1A "kyykky") ; --UNCHK
lin crouch_V = mkWV (k52 "kyykistyä") ; --UNCHK
lin croup_N = mkWN (k10 "perä") ; --UNCHK
lin croupier_N = mkWN (k5 "krupieeri") ; --UNCHK
lin croupy_A = mkWA (compoundA "muis" (k10 "tuttava")) "kuristustautia" ; --UNCHK
lin crouton_N = mkWN (compoundN "leipä" (k3 "kuutio")) "paistettu" ; --UNCHK
lin crow's_nest_N = mkWN (compoundN "märssy" (k5 "kori")) ; --UNCHK
lin crow_N = mkWN (k39 "varis") ; --UNCHK
lin crow_V = mkWV (k67A "kiljahdella") "ilosta" ; --UNCHK
lin crow_VS = mkWVS (k67A "kiljahdella") "ilosta" ; --UNCHK
lin crowbait_N = mkWN (k10 "luuska") ; --UNCHK
lin crowbar_N = mkWN (compoundN "sorkka" (k9A "rauta")) ; --UNCHK
lin crowberry_N = mkWN (compoundN "variksen" (k9 "marja")) ; --UNCHK
lin crowborough_PN = foreignPN "Crowborough" ;
lin crowd_N = mkWN (k1A "joukko") ;
lin crowd_V = mkWV (k61 "tungeksia") ;
lin crowd_V2 = mkWV2 (k61 "tungeksia") ; --UNCHK
lin crowded_A = mkA "kansoitettu" ;
lin crowding_N = mkWN (k39 "tungos") ; --UNCHK
lin crown_N = mkWN (k1A "kupu") ; --UNCHK
lin crown_V2 = mkWV2 (k67 "olla") "huippukohta" ; --UNCHK
lin crown_land_N = mkWN (compoundN "valtion" (k18 "maa")) ; --UNCHK
lin crownbeard_N = mkWN (compoundN "kulta" (k1 "kruunu")) ; --UNCHK
lin crowning_A = mkWA "huippu-" ; --UNCHK
lin crowthorne_PN = foreignPN "Crowthorne" ;
lin croydon_PN = foreignPN "Croydon" ;
lin crozier_N = mkWN (compoundN "piispan" (k9 "sauva")) ; --UNCHK
lin crucial_A = mkA "ratkaiseva" ;
lin cruciate_A = mkWA (k38 "muotoinen") "ristin" ; --UNCHK
lin crucible_N = mkWN (k41A "upokas") ; --UNCHK
lin crucifer_N = mkWN (compoundN "ristikukkais" (k5 "kasvi")) ; --UNCHK
lin cruciferous_A = mkWA "ristikukkaiskasvin" ; --UNCHK
lin crucifix_N = mkWN (compoundN "risti" (k9A "riipunta")) ; --UNCHK
lin crucifixion_N = mkWN (k39 "kidutus") ; --UNCHK
lin cruciform_A = mkWA (k38 "muotoinen") "ristin" ; --UNCHK
lin crucify_V2 = mkWV2 (k61A "sättiä") ; --UNCHK
lin crud_N = mkWN (k5A "tauti") "epämääräinen" ; --UNCHK
lin cruddy_A = mkWA (k10 "ruma") ; --UNCHK
lin crude_A = mkWA (kH1 "raaka") ;
lin crudeness_N = mkWN (k40 "karkeus") ; --UNCHK
lin crudity_N = mkWN (k40 "tahdittomuus") ; --UNCHK
lin cruel_A = mkWA (kH1 "raaka") ; --UNCHK
lin cruelty_N = mkWN (k2 "kohtelu") "epäinhimillinen" ; --UNCHK
lin cruet_N = mkWN (compoundN "öljy" (k1 "kannu")) ; --UNCHK
lin cruise_N = mkN (lin NK {s = d02 "risteily"}) ;
lin cruise_V = mkWV (k67 "risteillä") ; --UNCHK
lin cruiser_N = mkWN (compoundN "huvi" (k28 "pursi")) ; --UNCHK
lin cruller_N = mkWN (k12 "rinkilä") "rasvassa" "kypsennetty" ; --UNCHK
lin crumb_N = mkWN (k1 "muru") ; --UNCHK
lin crumble_V = mkWV (k74 "lahota") ; --UNCHK
lin crumble_V2 = mkWV2 (k74 "lahota") ; --UNCHK
lin crumbliness_N = mkWN (k40 "hauraus") ; --UNCHK
lin crumbly_A = mkWA (k41 "hauras") ; --UNCHK
lin crumpet_N = mkWN (compoundN "tee" (k10A "leipä")) "murea" ; --UNCHK
lin crumple_V = mkWV (k52A "poimuttua") ; --UNCHK
lin crumple_V2 = mkWV2 (k52A "poimuttua") ; --UNCHK
lin crunch_N = mkWN (k39 "puristus") ; --UNCHK
lin crunch_V = mkWV (k73 "muusata") ; --UNCHK
lin crunch_V2 = mkWV2 (k73 "muusata") ; --UNCHK
lin crupper_N = mkWN (compoundN "häntä" (k19 "vyö")) ; --UNCHK
lin crural_A = mkWA "sääri-" ; --UNCHK
lin crus_N = mkWN (k26 "sääri") ; --UNCHK
lin crusade_N = mkN "kampanja" ; --mkWN (k39 "pyrkimys") ;
lin crusade_V = mkWV (k67 "olla") "ristiretkellä" ; --UNCHK
lin crusader_N = mkWN (compoundN "risti" (k38 "retkeläinen")) ; --UNCHK
lin cruse_N = mkWN (k1A "ruukku") "pieni" ; --UNCHK
lin crush_N = mkN "murska" ;
lin crush_V = mkWV (k71 "tehdä") "loppu" ; --UNCHK
lin crush_V2 = mkV2 "murskata" ;
lin crusher_N = mkWN (k33 "rouhin") ; --UNCHK
lin crushingly_Adv = mkWAdv (k99 "murskaavasti") ; --UNCHK
lin crust_N = mkWN (k10A "pokka") ; --UNCHK
lin crust_V = mkWV (k52 "muodostua") "kuori" ; --UNCHK
lin crust_V2 = mkWV2 (k52 "muodostua") "kuori" ; --UNCHK
lin crustacean_N = mkWN (k38 "äyriäinen") ; --UNCHK
lin crustaceous_A = mkWA (compoundA "kuori" (k38 "mainen")) ; --UNCHK
lin crustal_A = mkWA "maankuoren" ; --UNCHK
lin crustose_A = mkWA "rupi-" ; --UNCHK
lin crusty_A = mkWA (k15 "töykeä") ; --UNCHK
lin crutch_N = mkWN (compoundN "kainalo" (k9 "sauva")) ; --UNCHK
lin crux_N = mkWN (k33A "ydin") "asian" ; --UNCHK
lin cry_N = mkWN (k1A "parku") ;
lin cry_V = mkV "itkeä" ;
lin cry_V2 = mkV2 (mkV "itkeä") partitive ;
lin cry_off_V2 = prepV2 OP_cry_V OP_off_Prep ; -- guess-p-verb
lin cry_out_V = mkWV (k52A "parkua") ; --UNCHK
lin crybaby_N = mkWN (k12 "marisija") ; --UNCHK
lin cryesthesia_N = mkWN (compoundN "kylmän" (k40 "herkkyys")) ; --UNCHK
lin crying_N = mkWN (k1 "itku") ; --UNCHK
lin cryoanesthesia_N = mkWN (compoundN "kylmä" (k12 "anestesia")) ; --UNCHK
lin cryobiology_N = mkWN (compoundN "kryo" (k12 "biologia")) ; --UNCHK
lin cryocautery_N = mkWN (k39 "jäädytys") ; --UNCHK
lin cryogen_N = mkWN (compoundN "kylmä" (k48 "aine")) "kryogeeninen" ; --UNCHK
lin cryogenic_A = mkWA "kryogeeninen" ; --UNCHK
lin cryogenics_N = mkWN (compoundN "kryogen" (k9A "iikka")) ; --UNCHK
lin cryolite_N = mkWN (compoundN "trinatriumheksafluorialumi" (k5A "naatti")) ; --UNCHK
lin cryometer_N = mkWN (compoundN "kryo" (k5 "metri")) ; --UNCHK
lin cryonics_N = mkWN (compoundN "syvä" (k39 "jäädytys")) ; --UNCHK
lin cryophobia_N = mkWN (compoundN "kryo" (k12 "fobia")) ; --UNCHK
lin cryoscope_N = mkWN (compoundN "kryosko" (k5A "oppi")) ; --UNCHK
lin cryostat_N = mkWN "kryostaatti" ; --UNCHK
lin cryosurgery_N = mkWN (compoundN "jäädytys" (k12 "kirurgia")) ; --UNCHK
lin crypt_N = mkWN (k9 "krypta") ; --UNCHK
lin cryptanalysis_N = mkWN (compoundN "krypto" (k5 "analyysi")) ; --UNCHK
lin cryptanalyst_N = mkWN (compoundN "krypto" (k4A "analyytikko")) ; --UNCHK
lin cryptanalytic_A = mkWA (compoundA "krypto" (k38 "analyyttinen")) ; --UNCHK
lin cryptic_A = mkWA "kryptinen" ; --UNCHK
lin cryptobiosis_N = mkWN "kryptobioosi" ; --UNCHK
lin cryptobiotic_A = mkWA (compoundA "krypto" (k38 "bioottinen")) ; --UNCHK
lin cryptococcosis_N = mkWN "kryptokokkoosi" ; --UNCHK
lin cryptocoryne_N = mkWN (compoundN "mela" (k7A "lehti")) ; --UNCHK
lin cryptogam_N = mkWN (compoundN "itiö" (k5 "kasvi")) ; --UNCHK
lin cryptogamic_A = mkWA "itiökasveihin" "liittyvä" ; --UNCHK
lin cryptogram_N = mkWN (compoundN "sala" (k39 "kirjoitus")) ; --UNCHK
lin cryptograph_N = mkWN (k5A "salakirjoitustulkki") ; --UNCHK
lin cryptography_N = mkWN (k5A "ohjelmointi") ; --UNCHK
lin cryptomonad_N = mkWN "kryptofyytti" ; --UNCHK
lin cryptorchidy_N = mkWN (k40 "piilokiveksisyys") ; --UNCHK
lin crystal_N = mkWN (compoundN "kellon" (k5 "lasi")) ; --UNCHK
lin crystal_gazing_N = mkWN "krystallomantia" ; --UNCHK
lin crystalline_A = mkA "kiteinen" ;
lin crystallite_N = mkWN "kristalliitti" ; --UNCHK
lin crystallization_N = mkWN "kiteytyminen" ; --UNCHK
lin crystallize_V = mkWV (k53A "kiteyttää") ; --UNCHK
lin crystallize_V2 = mkWV2 (k53A "kiteyttää") ; --UNCHK
lin crystallographer_N = mkWN "kristallografi" ; --UNCHK
lin crystallography_N = mkWN (compoundN "kide" (k48A "tiede")) ; --UNCHK
lin ctene_N = mkWN (compoundN "kampa" (k1 "levy")) ; --UNCHK
lin ctenidium_N = mkWN (compoundN "mikrosukas" (k9A "kampa")) ; --UNCHK
lin ctenoid_A = mkWA (compoundA "kampa" (k38 "mainen")) ; --UNCHK
lin ctenophore_N = mkWN (compoundN "kampa" (k5A "maneetti")) ; --UNCHK
lin cub_N = mkWN (k38 "poikanen") ; --UNCHK
lin cuba_PN = foreignPN "Kuuba" ;
lin cuban_A = mkWA (compoundA "kuub" (k38 "alainen")) ;
lin cuban_N = mkWN (compoundN "kuub" (k38 "alainen")) ; --UNCHK
lin cubby_N = mkWN (k9A "paikka") "mukava" ; --UNCHK
lin cubbyhole_N = mkWN (k9A "paikka") "mukava" ; --UNCHK
lin cube_N = mkWN (k3 "kuutio") ; --UNCHK
lin cubeb_N = mkWN (k48A "savuke") "kubebapippuria" "sisältävä" ; --UNCHK
lin cubelike_A = mkWA (k38 "muotoinen") "kuution" ; --UNCHK
lin cubic_A = mkWA (compoundA "kolmi" (k38 "ulotteinen")) ; --UNCHK
lin cubical_A = mkWA (k38 "muotoinen") "kuution" ; --UNCHK
lin cubicity_N = mkWN (k40 "kuutiomaisuus") ; --UNCHK
lin cubicle_N = mkWN (kH1 "koppi") ; --UNCHK
lin cubism_N = mkWN (k5 "kubismi") ; --UNCHK
lin cubist_A = mkWA (k38 "kubistinen") ; --UNCHK
lin cubist_N = mkWN (k5 "kubisti") ; --UNCHK
lin cubit_N = mkWN (k10 "kyynärä") ; --UNCHK
lin cubitiere_N = mkWN (compoundN "kyynärsu" (k10 "oja")) ; --UNCHK
lin cubitus_N = mkWN (compoundN "käsi" (k28 "varsi")) ; --UNCHK
lin cuboid_N = mkWN (k3 "särmiö") "suorakulmainen" ; --UNCHK
lin cuckold_N = mkWN (compoundN "aisan" (k10 "kannattaja")) ; --UNCHK
lin cuckold_V2 = mkWV2 (k53A "pettää") ; --UNCHK
lin cuckoldom_N = mkWN "aisankannattajuus" ; --UNCHK
lin cuckoldry_N = mkWN (k38 "tekeminen") "aisankannattajaksi" ; --UNCHK
lin cuckoo_N = mkWN (k7A "käki") ; --UNCHK
lin cuckoo_clock_N = mkWN (compoundN "käki" (k1 "kello")) ; --UNCHK
lin cuckoopint_N = mkWN (compoundN "munkin" (k1A "huppu")) ; --UNCHK
lin cucumber_N = mkWN (kH1 "kurkku") ; --UNCHK
lin cucurbit_N = mkWN (k13 "kurpitsa") ; --UNCHK
lin cucurbitaceous_A = mkWA "kurkkukasveihin" "liittyvä" ; --UNCHK
lin cud_N = mkWN (kH1 "mälli") ; --UNCHK
lin cuddle_N = mkWN (k39 "halaus") ; --UNCHK
lin cuddlesome_A = mkWA "paijattava" ; --UNCHK
lin cuddly_A = mkWA "paijattava" ; --UNCHK
lin cuddy_N = mkWN (k3 "keittiö") ; --UNCHK
lin cudgel_N = mkWN (k10 "nuija") ; --UNCHK
lin cudgel_V2 = mkWV2 (k64 "lyödä") "nuijalla" ; --UNCHK
lin cudweed_N = mkWN (compoundN "hopea" (k11 "maruna")) ; --UNCHK
lin cudworth_PN = foreignPN "Cudworth" ;
lin cue_N = mkWN (k18 "köö") ; --UNCHK
lin cuff_N = mkWN (k33 "kalvosin") ; --UNCHK
lin cuff_V2 = mkWV2 (k56A "laittaa") "käsiraudat" ; --UNCHK
lin cuffley_PN = foreignPN "Cuffley" ;
lin cufflink_N = mkWN (compoundN "kalvosin" (k5A "nappi")) ; --UNCHK
lin cuirass_N = mkWN (compoundN "rinta" (k13 "haarniska")) ; --UNCHK
lin cuisine_N = mkWN (compoundN "keitto" (k1A "taito")) ; --UNCHK
lin cuisse_N = mkWN (compoundN "reisi" (k13 "haarniska")) ; --UNCHK
lin cul_N = mkWN (compoundN "umpi" (k10 "kuja")) ; --UNCHK
lin cul_de_sac_N = mkWN (compoundN "umpi" (k1A "katu")) ; --UNCHK
lin culcheth_PN = foreignPN "Culcheth" ;
lin culdoscope_N = mkWN (compoundN "kuldosko" (k5A "oppi")) ; --UNCHK
lin culdoscopy_N = mkWN "kuldoskopia" ; --UNCHK
lin culinary_A = mkWA (k38 "kulinaarinen") ; --UNCHK
lin cull_N = mkWN (k1A "hylky") ; --UNCHK
lin cull_V2 = mkWV2 (k61 "poimia") ; --UNCHK
lin cullender_N = mkWN (k4A "lävikkö") ; --UNCHK
lin cullis_N = mkWN (compoundN "katto" (k1 "kouru")) ; --UNCHK
lin culm_N = mkWN (k7A "olki") ; --UNCHK
lin culminate_V = mkWV (k53A "saavuttaa") "huippunsa" ; --UNCHK
lin culminate_V2 = mkWV2 (k53A "saavuttaa") "huippunsa" ; --UNCHK
lin culmination_N = mkWN (k1A "loppu") ; --UNCHK
lin culotte_N = mkWN (compoundN "housu" (k48 "hame")) ; --UNCHK
lin culpability_N = mkWN (k40 "syyllisyys") ; --UNCHK
lin culpable_A = mkWA (k38 "rikollinen") ; --UNCHK
lin culprit_N = mkWN (k12 "tekijä") ;
lin cult_N = mkWN (k5A "muoti") ; --UNCHK
lin cultism_N = mkWN (k40 "hartaus") ; --UNCHK
lin cultist_N = mkWN (k10 "palvoja") ; --UNCHK
lin cultivable_A = mkWA (compoundA "viljely" (k38 "kelpoinen")) ; --UNCHK
lin cultivar_N = mkWN (k48A "lajike") ; --UNCHK
lin cultivate_V2 = mkWV2 (k67 "viljellä") ; --UNCHK
lin cultivation_N = mkWN (k2 "viljely") ; --UNCHK
lin cultivator_N = mkWN (k9 "hara") ; --UNCHK
lin cultural_A = mkA "kultturelli" ;
lin culture_N = mkN "kulttuuri" ; ---- WN (k2 "viljely") ;
lin cultured_A = mkWA (k1 "hieno") ; --UNCHK
lin culverin_N = mkWN "kulevriini" ; --UNCHK
lin culvert_N = mkWN (compoundN "silta" (k1A "rumpu")) ; --UNCHK
lin cum_Prep = mkPrep "kanssa" ;
lin cumber_V2 = mkWV2 (k73A "haitata") ; --UNCHK
lin cumberland_PN = foreignPN "Cumberland" ;
lin cumbernauld_PN = foreignPN "Cumbernauld" ;
lin cumbersome_A = mkWA (k2 "tökerö") ; --UNCHK
lin cumbrous_A = mkWA (k38 "vaivalloinen") ; --UNCHK
lin cumin_N = mkWN (kH1 "kumina") ; --UNCHK
lin cummerbund_N = mkWN (compoundN "smokki" (k19 "vyö")) ; --UNCHK
lin cumnock_PN = foreignPN "Cumnock" ;
lin cumulative_A = mkWA (k38 "kumulatiivinen") ; --UNCHK
lin cumuliform_A = mkWA (k38 "muotoinen") "kumpupilven" ; --UNCHK
lin cumulonimbus_N = mkWN (compoundN "ukkos" (k7 "pilvi")) ; --UNCHK
lin cumulous_A = mkWA (k10 "oleva") "kasassa" ; --UNCHK
lin cumulus_N = mkWN (k1A "keko") ; --UNCHK
lin cuneate_A = mkWA (compoundA "kiilan" (k38 "muotoinen")) ; --UNCHK
lin cuneiform_A = mkWA "vaajaluun" ; --UNCHK
lin cuneiform_N = mkWN (compoundN "nuolenpää" (k39 "kirjoitus")) ; --UNCHK
lin cunner_N = mkWN "kuparihuulikala" ; --UNCHK
lin cunnilingus_N = mkWN "kunnilingus" ; --UNCHK
lin cunning_N = mkWN (k1A "vaihto") ; --UNCHK
lin cunt_N = mkN "vittu" ;
lin cup_N = mkWN (k5A "kuppi") ;
lin cup_V2 = mkWV2 (k58 "laskea") "verta" ; --UNCHK
lin cup_final_N = mkWN (compoundN "cup-" (k6 "finaali")) ; --UNCHK
lin cup_tie_N = mkWN (compoundN "karsinta" (k2 "ottelu")) "cupin" ; --UNCHK
lin cupar_PN = foreignPN "Cupar" ;
lin cup_bearer_N = mkWN (compoundN "juoman" (k12 "laskija")) ; --UNCHK
lin cupboard_N = mkWN (k2 "komero") ; --UNCHK
lin cupboard_love_N = mkWN (k40 "rakkaus") "omanvoitonpyyntöinen" ; --UNCHK
lin cupcake_N = mkWN (compoundN "vuoka" (k39 "leivos")) ; --UNCHK
lin cupflower_N = mkWN "Nierembergia" ; --UNCHK
lin cupful_N = mkWN (k38 "kupillinen") ; --UNCHK
lin cupid_N = mkWN (k5 "amoriini") ; --UNCHK
lin cupidity_N = mkWN (k40 "ahneus") ; --UNCHK
lin cuplike_A = mkWA (compoundA "kuppi" (k38 "mainen")) ; --UNCHK
lin cupola_N = mkWN (k6 "kupoli") ; --UNCHK
lin cuppa_N = mkWN (k38 "kupponen") ; --UNCHK
lin cupping_N = mkWN (k39 "kuppaus") ; --UNCHK
lin cupric_A = mkWA (compoundA "kuparipi" (k38 "toinen")) ; --UNCHK
lin cuprite_N = mkWN (k5A "kupriitti") ; --UNCHK
lin cupro_nickel_N = mkWN (compoundN "nikkeli" (k6 "kupari")) ; --UNCHK
lin cupule_N = mkWN (compoundN "imu" (k5A "kuppi")) ; --UNCHK
lin cur_N = mkWN (k10A "hurtta") ; --UNCHK
lin curability_N = mkWN "parannettavuus" ; --UNCHK
lin curable_A = mkWA (k10 "oleva") "parannettavissa" ; --UNCHK
lin curacao_N = mkWN (compoundN "pomeranssi" (k6 "likööri")) ; --UNCHK
lin curacoa_N = mkWN (compoundN "pomeranssi" (k6 "likööri")) ; --UNCHK
lin curacy_N = mkWN (k9A "virka") "kappalaisen" ; --UNCHK
lin curandera_N = mkWN "curandera" ; --UNCHK
lin curandero_N = mkWN (compoundN "curand" (k1 "ero")) ; --UNCHK
lin curassow_N = mkWN (compoundN "hokko" (k9 "kana")) ; --UNCHK
lin curate_N = mkWN (k6 "pastori") ; --UNCHK
lin curative_A = mkWA (k38 "terapeuttinen") ; --UNCHK
lin curator_N = mkWN (k6 "kuraattori") ; --UNCHK
lin curatorial_A = mkWA "intendentti-" ; --UNCHK
lin curatorship_N = mkWN (k9A "virka") "intendentin" ; --UNCHK
lin curb_N = mkWN (k33A "pidätin") ; --UNCHK
lin curb_V2 = mkV2 "hillitä" partitive ; --WV2 (k73A "leikata") ;
lin curbside_N = mkWN (k26 "puoli") "reunakiveyksen" ; --UNCHK
lin curbstone_N = mkWN (compoundN "reuna" (k7 "kivi")) ; --UNCHK
lin curdle_V = mkWV (k52A "hyytyä") ; --UNCHK
lin curdle_V2 = mkWV2 (k52A "hyytyä") ; --UNCHK
lin curdling_N = mkWN (k3 "koagulaatio") ; --UNCHK
lin cure_N = mkN "hoito" ;
lin cure_V = mkWV (k53A "hoitaa") ; --UNCHK
lin cure_V2 = mkV2 "parantaa" ; --mkWV2 (k53A "hoitaa") ;
lin curettage_N = mkWN (k9A "kaavinta") ; --UNCHK
lin curette_N = mkWN (k33A "kaavin") ; --UNCHK
lin curfew_N = mkWN (compoundN "ulkonaliikkumis" (k1A "kielto")) ; --UNCHK
lin curie_N = mkWN "Marya" "Sklodowska" ; --UNCHK
lin curio_N = mkWN (k40 "erikoisuus") ; --UNCHK
lin curiosity_N = mkWN (k40 "erikoisuus") ; --UNCHK
lin curious_A = mkWA (compoundA "tiedon" (k38 "haluinen")) ; --UNCHK
lin curiousness_N = mkWN (k40 "outous") ; --UNCHK
lin curitiba_PN = foreignPN "Curitiba" ;
lin curium_N = mkWN "järjestysluku" "96" ; --UNCHK
lin curl_N = mkWN (k12 "kiehkura") ; --UNCHK
lin curl_V = mkWV (k52A "kiertyä") ; --UNCHK
lin curl_up_V = mkWV (k52 "käpristyä") ; --UNCHK
lin curler_N = mkWN (k5A "papiljotti") ; --UNCHK
lin curlew_N = mkWN (k5 "kuovi") ; --UNCHK
lin curliness_N = mkWN (compoundN "kiha" (k40 "raisuus")) ; --UNCHK
lin curling_N = mkWN "curling" ; --UNCHK
lin curly_A = mkWA (k11 "kihara") ; --UNCHK
lin curmudgeon_N = mkWN (compoundN "äkä" (k5 "pussi")) ; --UNCHK
lin currant_N = mkWN (compoundN "viini" (k9 "marja")) ; --UNCHK
lin currawong_N = mkWN (k5A "huilukorppi") ; --UNCHK
lin currency_N = mkN "valuutta" ;
lin current_A = mkA "nykyinen" ;
lin current_1_N = mkWN (k9A "virta") ; --UNCHK
lin current_2_N = mkWN (k9A "virta") ; --UNCHK
lin currentness_N = mkWN (k40 "ajanmukaisuus") ; --UNCHK
lin curricular_A = mkWA "oppikurssin" ; --UNCHK
lin curriculum_N = mkWN (compoundN "opetus" (k10 "suunnitelma")) ; --UNCHK
lin curriculum_vitae_N = mkWN (compoundN "ansio" (k2 "luettelo")) ; --UNCHK
lin currie_PN = foreignPN "Currie" ;
lin currier_N = mkWN (k6 "nahkuri") ; --UNCHK
lin currish_A = mkWA (compoundA "rakkikoira" (k38 "mainen")) ; --UNCHK
lin curry_N = mkWN (k1 "curry") ; --UNCHK
lin curry_V2 = mkWV2 (k61 "siistiä") ; --UNCHK
lin curry_powder_N = mkWN (k1 "curry") ; --UNCHK
lin currycomb_N = mkWN (k10A "suka") ; --UNCHK
lin curse_N = mkWN (k2 "sadattelu") ; --UNCHK
lin curse_V = mkWV (k74 "kirota") ; --UNCHK
lin curse_V2 = mkWV2 (k74 "kirota") ; --UNCHK
lin cursive_A = mkWA (compoundA "kirjo" (k1 "itettu")) "käsin" ; --UNCHK
lin cursor_N = mkWN (k33A "osoitin") ; --UNCHK
lin cursorial_A = mkWA "juoksu-" ; --UNCHK
lin cursory_A = mkWA (k38 "kursorinen") ; --UNCHK
lin curst_A = mkWA (k1A "kirottu") ; --UNCHK
lin curt_A = mkWA (k15 "selkeä") ; --UNCHK
lin curtail_V2 = mkWV2 (k73A "leikata") ; --UNCHK
lin curtailment_N = mkWN (compoundN "säästö" (k25 "toimi")) ; --UNCHK
lin curtain_N = mkN "esirippu" ;
lin curtain_V2 = mkWV2 (k74 "verhota") ; --UNCHK
lin curtain_call_N = mkWN (compoundN "esiin" (k1A "huuto")) ; --UNCHK
lin curtain_lecture_N = mkWN (compoundN "koti" (k39 "ripitys")) ; --UNCHK
lin curtain_raiser_N = mkWN (compoundN "esi" (k2 "valmistelu")) ; --UNCHK
lin curtainless_A = mkWA "verhoton" ; --UNCHK
lin curtal_A = mkWA "typistetty" ; --UNCHK
lin curtness_N = mkWN (k40 "karkeus") ; --UNCHK
lin curtsey_N = mkWN (k39 "niiaus") ; --UNCHK
lin curtsey_V = mkWV (k73 "niiata") ; --UNCHK
lin curtsy_N = mkWN (k39 "niiaus") ; --UNCHK
lin curtsy_V = mkWV (k73 "niiata") ; --UNCHK
lin curvaceously_Adv = mkWAdv (k99 "rehevästi") ; --UNCHK
lin curvaceousness_N = mkWN (k40 "uhkeus") ; --UNCHK
lin curvature_N = mkWN (k40 "käyryys") ; --UNCHK
lin curve_N = mkN "käyrä" ; ---ARB --mkWN (k48A "kierre") ;
lin curve_V = mkWV (k52A "kiertyä") ; --UNCHK
lin curve_V2 = mkWV2 (k52A "kiertyä") ; --UNCHK
lin curvet_N = mkWN (k1A "hyppy") ; --UNCHK
lin curvilineal_A = mkWA (k10 "kaareva") ; --UNCHK
lin curvy_A = mkWA (k38 "täyteläinen") ; --UNCHK
lin cuscus_N = mkWN (k5 "kuskus") ; --UNCHK
lin cushaw_N = mkWN (compoundN "myski" (k13 "kurpitsa")) ; --UNCHK
lin cushion_N = mkWN (k1 "tyyny") ;
lin cushion_V2 = mkV2 "pehmentää" partitive ;
lin cushy_A = mkWA (k10 "mukava") ; --UNCHK
lin cusk_N = mkWN (kH1 "matikka") ; --UNCHK
lin cusp_N = mkWN (k7A "kärki") ; --UNCHK
lin cuspate_A = mkWA (compoundA "terä" (k38 "väkärkinen")) ; --UNCHK
lin cuspidation_N = mkWN (compoundN "teräväkärk" (k40 "isyys")) ; --UNCHK
lin cuspidor_N = mkWN (compoundN "sylky" (k5A "kuppi")) ; --UNCHK
lin cuss_N = mkWN (k2 "sadattelu") ; --UNCHK
lin cussed_A = mkWA (k47 "paatunut") ; --UNCHK
lin cussedness_N = mkWN (k40 "häijyys") ; --UNCHK
lin custard_N = mkWN (compoundN "maito" (k6 "kiisseli")) ; --UNCHK
lin custodial_A = mkWA "holhous-" ; --UNCHK
lin custodian_N = mkWN (k6 "pehtori") ; --UNCHK
lin custodianship_N = mkWN (k9A "virka") "vartijan" ; --UNCHK
lin custody_N = mkWN "huoltajuus" ; --UNCHK
lin custom_N = mkWN (k1A "käytäntö") ; --UNCHK
lin customary_A = mkWA (k38 "totunnainen") ;
lin customerFem_N = variants {} ; ---- sense to be split
lin customerMasc_N = mkN "asiakas" ;
lin customhouse_N = mkWN (k5 "tulli") ; --UNCHK
lin customize_V2 = mkV2 "räätälöidä" ;
lin customs_N = mkWN (k5 "tulli") ; --UNCHK
lin cut_N = mkN "leikkaus" ;
lin cut_V = mkV "leikata" ;
lin cut_V2 = L.cut_V2 ;
lin cut_across_V2 = mkWV2 (k73A "leikata") "poikki" ; --UNCHK
lin cut_back_V2 = mkWV2 (k73A "leikata") ; --UNCHK
lin cut_back_on_V2 = prepV2 (advV OP_cut_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_down_V = mkWV (k53A "vetää") "maahan" ; --UNCHK
lin cut_down_V2 = mkWV2 (k53A "vetää") "maahan" ; --UNCHK
lin cut_down_on_V2 = prepV2 (advV OP_cut_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_in_V = mkWV (k73 "lisätä") ; --UNCHK
lin cut_in_V2 = mkWV2 (k73 "lisätä") ; --UNCHK
lin cut_in_on_V2 = prepV2 (advV OP_cut_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_it_out_V2 = variants {} ; -- guess-p-verb
lin cut_off_V = mkWV (k53A "lopettaa") ; --UNCHK
lin cut_off_V2 = mkWV2 (k53A "lopettaa") ; --UNCHK
lin cut_out_V = mkWV (k52 "sammua") ; --UNCHK
lin cut_out_V2 = mkWV2 (k52 "sammua") ; --UNCHK
lin cut_out_on_V2 = prepV2 (advV OP_cut_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_up_V = mkWV (k73A "muokata") "pilkkomalla" ; --UNCHK
lin cut_up_V2 = mkWV2 (k73A "muokata") "pilkkomalla" ; --UNCHK
lin cutaneous_A = mkWA (compoundA "kuta" (k38 "aninen")) ; --UNCHK
lin cutaway_N = mkWN (k5A "saketti") ; --UNCHK
lin cutback_N = mkWN (k39 "supistus") ; --UNCHK
lin cutch_N = mkWN "kateku" ; --UNCHK
lin cute_A = mkA "suloinen" ;
lin cuteness_N = mkWN (k40 "sievyys") ; --UNCHK
lin cuticula_N = mkWN (k26 "kitiinikuori") ; --UNCHK
lin cuticular_A = mkWA "orvaskesi-" ; --UNCHK
lin cutin_N = mkWN "kutiini" ; --UNCHK
lin cutlassfish_N = mkWN (compoundN "huotra" (k9 "kala")) ; --UNCHK
lin cutler_N = mkWN (compoundN "aterin" (k41 "kauppias")) ; --UNCHK
lin cutlet_N = mkWN (k48A "leike") ; --UNCHK
lin cutoff_N = mkWN (k10A "sulkuläppä") ; --UNCHK
lin cut_out_N = mkWN (k48A "leike") ; --UNCHK
lin cutpurse_N = mkWN (compoundN "tasku" (k41A "varas")) ; --UNCHK
lin cutter_N = mkWN (compoundN "leikkuu" (k48 "väline")) ; --UNCHK
lin cut_throat_A = mkWA (kH1 "raaka") ; --UNCHK
lin cut_throat_N = mkWN (k10 "murhaaja") ; --UNCHK
lin cutting_N = mkWN (k17 "leikkuu") ; --UNCHK
lin cutting_room_N = mkWN (k2 "leikkaamo") ; --UNCHK
lin cuttingly_Adv = mkWAdv "pistävästi" ; --UNCHK
lin cuttlefish_N = mkWN (k12 "seepia") ; --UNCHK
lin cutwork_N = mkWN (k2 "ompelu") "venetsialainen" ; --UNCHK
lin cutworm_N = mkWN (k10A "toukka") "yökkösen" ; --UNCHK
lin cwmbran_PN = foreignPN "Cwmbran" ;
lin cyan_N = mkWN (k5 "syaani") ; --UNCHK
lin cyanamide_N = mkWN (k5 "syanamidi") ; --UNCHK
lin cyanide_N = mkWN (k5 "syanidi") ; --UNCHK
lin cyanobacterial_A = mkWA "syanobakteeri-" ; --UNCHK
lin cyanogen_N = mkWN (k5 "syaani") ; --UNCHK
lin cyanogenetic_A = mkWA (k10 "tuottava") "syaania" ; --UNCHK
lin cyanohydrin_N = mkWN "syanohydriini" ; --UNCHK
lin cyanosis_N = mkWN (k39 "sinerrys") ; --UNCHK
lin cyberart_N = mkWN (k48A "taide") "sähköinen" ; --UNCHK
lin cybercrime_N = mkWN (compoundN "tietoverkko" (k40 "rikollisuus")) ; --UNCHK
lin cyberculture_N = mkWN (k6 "kulttuuri") "sähköinen" ; --UNCHK
lin cybernaut_N = mkWN (k10 "käyttäjä") "tietokoneen" ; --UNCHK
lin cybernetic_A = mkWA (k38 "kyberneettinen") ; --UNCHK
lin cybernetics_N = mkWN (k9A "kybernetiikka") ; --UNCHK
lin cyberphobia_N = mkWN (compoundN "tietokone" (k1 "kammo")) ; --UNCHK
lin cyberpunk_N = mkWN (compoundN "kyber" (k5 "punk")) ; --UNCHK
lin cybersex_N = mkWN (compoundN "verkko" (k5 "seksi")) ; --UNCHK
lin cyborg_N = mkWN (k5 "kyborgi") ; --UNCHK
lin cycad_N = mkWN (compoundN "käpy" (k1 "palmu")) ; --UNCHK
lin cyclamen_N = mkWN (k6 "syklaami") ; --UNCHK
lin cycle_N = mkN "sykli" ;
lin cycle_V = mkWV (k52 "toistua") ; --UNCHK
lin cyclic_A = mkWA (k38 "jaksoittainen") ; --UNCHK
lin cyclical_A = mkWA (k38 "jaksoittainen") ; --UNCHK
lin cyclicity_N = mkWN (k40 "jaksoittaisuus") ; --UNCHK
lin cycling_N = mkWN (k2 "pyöräily") ; --UNCHK
lin cyclist_N = mkWN (k12 "pyöräilijä") ; --UNCHK
lin cyclobenzaprine_N = mkWN "Flexeril" ; --UNCHK
lin cyclohexanol_N = mkWN "sykloheksanoli" ; --UNCHK
lin cycloid_A = mkWA "sykloidinen" ; --UNCHK
lin cycloid_N = mkWN "sykloidi" ; --UNCHK
lin cyclone_N = mkWN (k5 "sykloni") ; --UNCHK
lin cyclonic_A = mkWA (compoundA "sykloni" (k38 "nen")) ; --UNCHK
lin cyclooxygenase_N = mkWN (compoundN "syklo-oksygen" (k5 "aasi")) ; --UNCHK
lin cyclopaedia_N = mkWN (k12 "ensyklopedia") ; --UNCHK
lin cyclopean_A = mkWA (compoundA "kyklooppi" (k38 "nen")) ; --UNCHK
lin cyclopia_N = mkWN (compoundN "yksisilmäepä" (k10 "muodostuma")) ; --UNCHK
lin cyclopropane_N = mkWN (compoundN "syklo" (k5 "propaani")) ; --UNCHK
lin cycloserine_N = mkWN "sykloseriini" ; --UNCHK
lin cyclosis_N = mkWN (compoundN "sol" (k10 "ussa")) "soluliman" "kierto" ; --UNCHK
lin cyclostome_N = mkWN (compoundN "ympyrä" (k38 "suinen")) ; --UNCHK
lin cyclostyle_N = mkWN (compoundN "kirjoitus" (k9A "laita")) "vahapaperille" ; --UNCHK
lin cyclothymia_N = mkWN (compoundN "persoonallisuus" (k3 "häiriö")) "affektiivinen" ; --UNCHK
lin cyclothymic_A = mkWA (compoundA "aalto" (k38 "iluhäiriöllinen")) "mielialan" ; --UNCHK
lin cyclotron_N = mkWN "syklotroni" ; --UNCHK
lin cyder_N = mkWN (k6 "siideri") ; --UNCHK
lin cygnet_N = mkWN (k32 "joutsen") ; --UNCHK
lin cylinder_N = mkWN (k1 "pullo") ; --UNCHK
lin cylindrical_A = mkWA (k38 "muotoinen") "lieriön" ; --UNCHK
lin cylindricality_N = mkWN (compoundN "sylinterimä" (k40 "isyys")) ; --UNCHK
lin cyma_N = mkWN "kyma" ; --UNCHK
lin cymbal_N = mkWN (k38 "lautanen") ; --UNCHK
lin cymbalist_N = mkWN (k10 "soittaja") "symbaalin" ; --UNCHK
lin cymbid_N = mkWN "Cymbidium" ; --UNCHK
lin cyme_N = mkWN (k1 "viuhko") ; --UNCHK
lin cymene_N = mkWN "symeeni" ; --UNCHK
lin cymose_A = mkWA (compoundA "viuhko" (k38 "mainen")) ; --UNCHK
lin cymule_N = mkWN (k1 "viuhko") "pieni" ; --UNCHK
lin cynancum_N = mkWN "Cynanchum" ; --UNCHK
lin cynic_N = mkWN (k4A "kyynikko") ; --UNCHK
lin cynical_A = mkWA (k38 "kyyninen") ; --UNCHK
lin cynicism_N = mkWN (k40 "kyynisyys") ; --UNCHK
lin cynodont_N = mkWN "kynodontti" ; --UNCHK
lin cynophobia_N = mkWN (compoundN "koira" (k1 "kammo")) ; --UNCHK
lin cynosure_N = mkWN (k48A "kohde") "huomion" ; --UNCHK
lin cypher_N = mkWN (compoundN "salakirjoitus" (k5 "viesti")) ; --UNCHK
lin cypher_V = mkWV (k58 "laskea") ; --UNCHK
lin cypher_V2 = mkWV2 (k58 "laskea") ; --UNCHK
lin cypress_N = mkWN (k6 "sypressi") ; --UNCHK
lin cyprian_A = mkWA (compoundA "kypros" (k38 "lainen")) ; --UNCHK
lin cyprinid_A = mkWA "särkikala-" ; --UNCHK
lin cyprinid_N = mkWN (compoundN "särki" (k9 "kala")) ; --UNCHK
lin cyprinodont_N = mkWN "hammaskilli" ; --UNCHK
lin cypriot_A = mkWA (compoundA "kypros" (k38 "lainen")) ; --UNCHK
lin cypripedia_N = mkWN (k5A "tikankontti") ; --UNCHK
lin cyproheptadine_N = mkWN "Periactin" ; --UNCHK
lin cyprus_PN = foreignPN "Kypros" ;
lin cyril_PN = foreignPN "Cyril" ;
lin cyrilla_N = mkWN (compoundN "racemifl" (k10 "ora")) "Cyrilla" ; --UNCHK
lin cyrillic_A = mkWA (k38 "kyrillinen") ; --UNCHK
lin cyst_N = mkWN (k12 "rakkula") ; --UNCHK
lin cysteine_N = mkWN (compoundN "kys" (k5 "teiini")) ; --UNCHK
lin cystic_A = mkWA "kystinen" ; --UNCHK
lin cystine_N = mkWN "systiini" ; --UNCHK
lin cystitis_N = mkWN (compoundN "virtsarakon" (k39 "tulehdus")) ; --UNCHK
lin cystocele_N = mkWN (compoundN "kystose" (k48 "ele")) ; --UNCHK
lin cystoplegia_N = mkWN (k39 "halvaus") "virtsarakon" ; --UNCHK
lin cytoarchitecture_N = mkWN (k48A "rakenne") "solujen" "muodostama" ; --UNCHK
lin cytochrome_N = mkWN (compoundN "syto" (k5 "kromi")) ; --UNCHK
lin cytogenesis_N = mkWN "sytogeneesi" ; --UNCHK
lin cytogenetic_A = mkWA (compoundA "syto" (k38 "geneettinen")) ; --UNCHK
lin cytogeneticist_N = mkWN (k12 "tuntija") "sytogenetiikan" ; --UNCHK
lin cytogenetics_N = mkWN (compoundN "sytogen" (k14A "etiikka")) ; --UNCHK
lin cytokine_N = mkWN "sytokiini" ; --UNCHK
lin cytokinesis_N = mkWN (k38 "solunjakautuminen") ; --UNCHK
lin cytokinetic_A = mkWA (compoundA "syto" (k38 "kineettinen")) ; --UNCHK
lin cytological_A = mkWA (compoundA "solu" (k38 "opillinen")) ; --UNCHK
lin cytologist_N = mkWN "sytologi" ; --UNCHK
lin cytology_N = mkWN (k12 "sytologia") ; --UNCHK
lin cytolysin_N = mkWN "sytolysiini" ; --UNCHK
lin cytolysis_N = mkWN (compoundN "sytoly" (k5 "ysi")) ; --UNCHK
lin cytolytic_A = mkWA "sytolyyttinen" ; --UNCHK
lin cytomegalic_A = mkWA "sytomegalia-" ; --UNCHK
lin cytomegalovirus_N = mkWN (compoundN "sytomegalo" (k39 "virus")) ; --UNCHK
lin cytopathogenic_A = mkWA (compoundA "syto" (k38 "patogeeninen")) ; --UNCHK
lin cytopenia_N = mkWN (k40 "niukkuus") "veren" "solujen" ; --UNCHK
lin cytophotometer_N = mkWN (compoundN "sytofoto" (k5 "metri")) ; --UNCHK
lin cytophotometric_A = mkWA (compoundA "sytofoto" (k38 "metrinen")) ; --UNCHK
lin cytophotometry_N = mkWN "sytofotometria" ; --UNCHK
lin cytoplasm_N = mkWN (compoundN "solu" (k9 "lima")) ; --UNCHK
lin cytoplasmic_A = mkWA "soluplasman" ; --UNCHK
lin cytoplast_N = mkWN (compoundN "solu" (k9 "lima")) ; --UNCHK
lin cytoplastic_A = mkWA (compoundA "syto" (k38 "plastinen")) ; --UNCHK
lin cytosine_N = mkWN "C" ; --UNCHK
lin cytoskeleton_N = mkWN (compoundN "tuki" (k9A "ranka")) "solun" ; --UNCHK
lin cytosol_N = mkWN "sytosoli" ; --UNCHK
lin cytostome_N = mkWN (k18 "suu") "alkueläimen" ; --UNCHK
lin cytotoxic_A = mkWA (k38 "sytotoksinen") ; --UNCHK
lin cytotoxicity_N = mkWN "sytotoksisuus" ; --UNCHK
lin cytotoxin_N = mkWN (compoundN "solu" (k1A "myrkky")) ; --UNCHK
lin czar_N = mkWN (compoundN "yksin" (k41 "valtias")) ; --UNCHK
lin czarina_N = mkWN (k32A "tsaaritar") ; --UNCHK
lin czarist_A = mkWA (k38 "tsaristinen") ; --UNCHK
lin czech_A = mkWA (k38 "tšekkiläinen") ; --UNCHK
lin czech_N = mkWN (k5A "tšekki") ; --UNCHK
lin czechoslovak_N = mkWN (k38 "tšekkiläinen") ; --UNCHK
lin czechoslovakian_A = mkWA (k38 "tšekkiläinen") ; --UNCHK
lin czechoslovakian_N = mkWN (k38 "tšekkiläinen") ; --UNCHK
lin dab_V = mkWV (k53A "taputtaa") ; --UNCHK
lin dab_V2 = mkWV2 (k53A "taputtaa") ; --UNCHK
lin dabble_V = mkWV (k54A "sukeltaa") ; --UNCHK
lin dabble_V2 = mkWV2 (k54A "sukeltaa") ; --UNCHK
lin dabbler_N = mkWN (compoundN "puolisukeltaja" (k10 "sorsa")) ; --UNCHK
lin dabchick_N = mkWN (compoundN "pikku-" (k1A "uikku")) ; --UNCHK
lin dace_N = mkWN (k5 "seipi") ; --UNCHK
lin dacha_N = mkWN (k9 "datša") ; --UNCHK
lin dachshund_N = mkWN (compoundN "mäyrä" (k10 "koira")) ; --UNCHK
lin dacite_N = mkWN "dasiitti" ; --UNCHK
lin dacitic_A = mkWA "dasiitti-" ; --UNCHK
lin dacoit_N = mkWN (k1 "rosvo") ; --UNCHK
lin dacoity_N = mkWN (k2 "rosvoilu") ; --UNCHK
lin dacryocystitis_N = mkWN (compoundN "kyynelpussi" (k39 "tulehdus")) ; --UNCHK
lin dacryon_N = mkWN (compoundN "kallonmittaus" (k48 "piste")) ; --UNCHK
lin dactyl_N = mkWN (k41A "varvas") ; --UNCHK
lin dactylic_A = mkWA (compoundA "dak" (k38 "tyylinen")) ; --UNCHK
lin dactylomegaly_N = mkWN "makrodaktylia" ; --UNCHK
lin dad_N = mkWN (k9A "pappa") ; --UNCHK
lin dada_N = mkWN (k5 "dadaismi") ; --UNCHK
lin daddy_N = mkWN (k9A "pappa") ; --UNCHK
lin daddy_longlegs_N = mkWN (k5A "lukki") ; --UNCHK
lin daedal_A = mkWA (k41A "nerokas") ; --UNCHK
lin daemon_N = mkWN (k5 "demoni") ; --UNCHK
lin daffodil_N = mkWN (k5 "narsissi") ; --UNCHK
lin daft_A = mkWA (k1 "pöllö") ; --UNCHK
lin dagame_N = mkWN "Calycophyllum" "candidissimum" ; --UNCHK
lin dagga_N = mkWN (compoundN "leijonan" (k10 "korva")) ; --UNCHK
lin dagger_N = mkWN (k1A "puukko") ; --UNCHK
lin daggerboard_N = mkWN (compoundN "nosto" (k5 "köli")) ; --UNCHK
lin dago_N = mkWN (k39 "ilmaus") "halventava" ; --UNCHK
lin daguerreotype_N = mkWN "dagerrotypia" ; --UNCHK
lin dail_eireann_N = mkWN "Dail" ; --UNCHK
lin daily_A = mkA "päivittäinen" ;
lin daily_Adv = mkWAdv (k99 "päivittäin") ; --UNCHK
lin daily_N = mkWN (compoundN "päivä" (k7A "lehti")) ;
lin daintiness_N = mkWN (k40 "hienostuneisuus") ; --UNCHK
lin dainty_A = mkWA (k10 "ihastuttava") ; --UNCHK
lin dainty_N = mkWN (k5 "nami") ; --UNCHK
lin daiquiri_N = mkWN (compoundN "rommi" (k5 "cocktail")) ; --UNCHK
lin dairy_N = mkWN (k6 "meijeri") ;
lin dairy_farm_N = mkWN (k6 "meijeri") ; --UNCHK
lin dairy_farming_N = mkWN "maitotilan" "pitäminen" ; --UNCHK
lin dairying_N = mkWN "maitotilan" "pitäminen" ; --UNCHK
lin dairymaid_N = mkWN (k4A "karjakko") ; --UNCHK
lin dairyman_N = mkWN (k4A "karjakko") ; --UNCHK
lin dais_N = mkWN (k48A "koroke") ; --UNCHK
lin daisy_N = mkWN (k38 "kaunokainen") ; --UNCHK
lin daisybush_N = mkWN "Olearia" ; --UNCHK
lin daisylike_A = mkWA (k38 "kaltainen") "kaunokaisen" ; --UNCHK
lin dakar_PN = foreignPN "Dakar" ;
lin dalasi_N = mkWN "dalasi" ; --UNCHK
lin dale_N = mkWN (k1 "laakso") ; --UNCHK
lin dalesman_N = mkWN (compoundN "laakso" (k38 "lainen")) ; --UNCHK
lin dalkeith_PN = foreignPN "Dalkeith" ;
lin dallas_PN = foreignPN "Dallas" ;
lin dalliance_N = mkWN (k2 "flirttailu") ; --UNCHK
lin dallier_N = mkWN (k12 "kuhnailija") ; --UNCHK
lin dallisgrass_N = mkWN (compoundN "helmi" (k5 "hirssi")) ; --UNCHK
lin dally_V = mkWV (k61A "leikkiä") ; --UNCHK
lin dalmatian_N = mkWN (compoundN "dalmatian" (k10 "koira")) ; --UNCHK
lin dalry_PN = foreignPN "Dalry" ;
lin dalton_PN = foreignPN "Dalton" ;
lin dam_N = mkN "pato" ;
lin dam_V2 = mkWV2 (k74A "padota") ; --UNCHK
lin damage_N = mkN "vahinko" ;
lin damage_V2 = mkV2 (lin VK {s = c53A "vahingoittaa"}) ;
lin damages_N = mkWN (k39 "korvaus") ; --UNCHK
lin damaging_A = mkWA (k38 "kielteinen") ; --UNCHK
lin damascene_N = mkWN (k48 "esine") "damaskoitu" ; --UNCHK
lin damascene_V2 = mkWV2 "damaskoida" ; --UNCHK
lin damascus_PN = foreignPN "Damaskos" ;
lin damask_A = mkWA "damasti-" ; --UNCHK
lin damask_N = mkWN (k5 "damasti") ; --UNCHK
lin dame_N = mkWN (k9 "kissa") ; --UNCHK
lin dammar_N = mkWN (compoundN "dammar" (k5 "hartsi")) ; --UNCHK
lin damn_A = mkWA (k38 "pirunmoinen") ; --UNCHK
lin damn_Adv = mkWAdv (compoundAdv "pahuk" (k99 "sen")) ; --UNCHK
lin damn_Interj = mkInterj "hitto" ;
lin damn_V2 = mkWV2 (k74 "kirota") ; --UNCHK
lin damnable_A = mkWA (k10 "katala") ; --UNCHK
lin damnation_N = mkWN (compoundN "kiro" (k38 "aminen")) ; --UNCHK
lin damnatory_A = mkWA "hylkäävä" ; --UNCHK
lin damned_Adv = mkWAdv "kirotun" ; --UNCHK
lin damourite_N = mkWN (compoundN "damou" (k5A "riitti")) ; --UNCHK
lin damp_A = mkWA (k15 "kostea") ; --UNCHK
lin damp_N = mkWN (k40 "kosteus") ; --UNCHK
lin damp_V = mkWV (k53A "pehmittää") ; --UNCHK
lin damp_V2 = mkWV2 (k53A "pehmittää") ; --UNCHK
lin dampen_V = mkWV (k53A "kostuttaa") ; --UNCHK
lin dampen_V2 = mkWV2 (k53A "kostuttaa") ; --UNCHK
lin dampener_N = mkWN (k33A "kostutin") ; --UNCHK
lin damper_N = mkWN (k1 "suihku") "kylmä" ; --UNCHK
lin dampish_A = mkWA (k15 "kostea") ; --UNCHK
lin dampness_N = mkWN (k40 "kosteus") ; --UNCHK
lin damsel_N = mkWN (k5A "neiti") ; --UNCHK
lin damselfish_N = mkWN "demoiselle" ; --UNCHK
lin damselfly_N = mkWN "hentosudenkorento" ; --UNCHK
lin damson_N = mkWN (k1 "luumu") ; --UNCHK
lin danaid_N = mkWN "Danainae" ; --UNCHK
lin dance_N = mkWN (k5 "tanssi") ; --UNCHK
lin dance_V = mkWV (k73 "jorata") ; --UNCHK
lin dance_V2 = mkWV2 (k73 "jorata") ; --UNCHK
lin dance_band_N = mkWN (k1A "pumppu") ; --UNCHK
lin dance_hall_N = mkWN (compoundN "tanssi" (k9 "lava")) ; --UNCHK
lin dance_orchestra_N = mkWN (k1A "pumppu") ; --UNCHK
lin danceable_A = mkWA "tanssittava" ; --UNCHK
lin dancer_N = mkWN (k12 "tanssija") ; --UNCHK
lin dancing_N = mkWN (k5 "tanssi") ; --UNCHK
lin dandelion_N = mkWN (compoundN "voi" (k10A "kukka")) ; --UNCHK
lin dander_N = mkWN (k39 "ärtymys") ; --UNCHK
lin dandified_A = mkWA (compoundA "keikari" (k38 "mainen")) ; --UNCHK
lin dandle_V2 = mkWV2 (k67 "hyväillä") ; --UNCHK
lin dandruff_N = mkWN (k48 "hilse") ; --UNCHK
lin dandy_A = mkWA (k3 "mainio") ; --UNCHK
lin dandy_N = mkWN (k5 "jooli") ; --UNCHK
lin dane_N = mkWN (k38 "tanskalainen") ; --UNCHK
lin danger_N = mkWN (kH1 "vaara") ;
lin dangerous_A = mkA (lin AK {s = d38 "vaarallinen"}) ;
lin dangerousness_N = mkWN (k40 "vaarallisuus") ; --UNCHK
lin dangle_V = mkWV (k53 "ripustaa") ; --UNCHK
lin dangle_V2 = mkWV2 (k53 "ripustaa") ; --UNCHK
lin dangleberry_N = mkWN (compoundN "frond" (k10 "osa")) "Gaylussacia" ; --UNCHK
lin daniel_N = mkWN (k9 "kirja") "profeetta" "Danielin" ; --UNCHK
lin danishFem_N = mkN "tanskalainen" ;
lin danishMasc_N = mkN "tanskalainen" ;
lin danish_A = mkA "tanskalainen" ;
lin dank_A = mkWA (k15 "kostea") ; --UNCHK
lin dankness_N = mkWN (k40 "nihkeys") ; --UNCHK
lin danse_macabre_N = mkWN (compoundN "kuoleman" (k5 "tanssi")) ; --UNCHK
lin danseur_N = mkWN (compoundN "baletti" (k12 "tanssija")) ; --UNCHK
lin daphne_N = mkWN "Dafne" ; --UNCHK
lin daphne_PN = foreignPN "Daphne" ;
lin daphnia_N = mkWN (compoundN "vesi" (k1A "kirppu")) ; --UNCHK
lin dapper_A = mkWA (k15 "upea") ; --UNCHK
lin dapple_V2 = mkWV2 (k53 "varjostaa") ; --UNCHK
lin dapsone_N = mkWN "dapsoni" ; --UNCHK
lin daraf_N = mkWN "daraf" ; --UNCHK
lin darby_PN = foreignPN "Darby" ;
lin dare_N = mkWN (k48 "haaste") ; --UNCHK
lin dare_V2 = mkWV2 (k56 "haastaa") ; --UNCHK
lin dare_VV = mkWVV (k56 "haastaa") ; --UNCHK
lin daredevil_A = mkWA (k1A "uskalikko") ; --UNCHK
lin daredevil_N = mkWN (k1A "uskalikko") ; --UNCHK
lin daredevilry_N = mkWN (k40 "uskaliaisuus") ; --UNCHK
lin darfield_PN = foreignPN "Darfield" ;
lin daring_N = mkWN (k39 "uskallus") ; --UNCHK
lin daringly_Adv = mkWAdv (k99 "huimapäisesti") ; --UNCHK
lin dark_A = mkA "pimeä" | mkA "tumma" ; ---- split
lin dark_N = mkWN (k40 "tietämättömyys") ; --UNCHK
lin darken_V = mkWV (k54A "tummentaa") ; --UNCHK
lin darken_V2 = mkWV2 (k54A "tummentaa") ; --UNCHK
lin darkey_N = mkWN (k6 "neekeri") ; --UNCHK
lin darkie_N = mkWN (k6 "neekeri") ; --UNCHK
lin darkish_A = mkWA "tummahko" ; --UNCHK
lin darkling_A = mkWA (k10 "pimeässä") ; --UNCHK
lin darkness_N = mkWN "tummaihoisuus" ; --UNCHK
lin darkroom_N = mkWN (k3 "pimiö") ; --UNCHK
lin darky_N = mkWN (k6 "neekeri") ; --UNCHK
lin darling_N = mkWN (compoundN "Darling-" (k7A "joki")) ; --UNCHK
lin darlington_PN = foreignPN "Darlington" ;
lin darmstadt_PN = foreignPN "Darmstadt" ;
lin darmstadtium_N = mkWN "järjestysluku" "110" ; --UNCHK
lin darn_N = mkWN (kH1 "kohta") "parsittu" ; --UNCHK
lin darn_V = mkWV (k61 "parsia") ; --UNCHK
lin darn_V2 = mkWV2 (k61 "parsia") ; --UNCHK
lin darnel_N = mkWN "myrkkyraiheinä" ; --UNCHK
lin darner_N = mkWN (compoundN "par" (k9 "sija")) ; --UNCHK
lin darning_N = mkWN (compoundN "par" (k38 "siminen")) ; --UNCHK
lin darning_needle_N = mkWN (compoundN "pirun" (k6 "puntari")) ; --UNCHK
lin dart_N = mkWN (k39 "syöksähdys") ; --UNCHK
lin dart_V = mkWV (k52A "sinkoutua") ; --UNCHK
lin dart_V2 = mkWV2 (k52A "sinkoutua") ; --UNCHK
lin dartboard_N = mkWN (compoundN "tikka" (k1 "taulu")) ; --UNCHK
lin darter_N = mkWN "syöksähtelijä" ; --UNCHK
lin dartford_PN = foreignPN "Dartford" ;
lin dartmouth_PN = foreignPN "Dartmouth" ;
lin darts_N = mkWN (compoundN "tikka" (k5 "peli")) ; --UNCHK
lin darwen_PN = foreignPN "Darwen" ;
lin dash_N = mkWN (k5A "spurtti") ; --UNCHK
lin dash_V = mkWV (k53A "pirskauttaa") ; --UNCHK
lin dash_down_V2 = mkWV2 (k53 "raapustaa") ; --UNCHK
lin dash_off_V = mkWV (k53 "raapustaa") ; --UNCHK
lin dash_off_V2 = mkWV2 (k53 "raapustaa") ; --UNCHK
lin dashboard_N = mkWN (compoundN "koje" (k9A "lauta")) ; --UNCHK
lin dashiki_N = mkWN (compoundN "dais" (k7A "hiki")) ; --UNCHK
lin dashingly_Adv = mkWAdv (compoundAdv "huippu" (k99 "tyylikkäästi")) ; --UNCHK
lin dastard_N = mkWN (k1 "roisto") "pelkurimainen" ; --UNCHK
lin dastardliness_N = mkWN "pelkurimaisuus" ; --UNCHK
lin dastardly_A = mkWA (k38 "raukkamainen") ; --UNCHK
lin dasymeter_N = mkWN (compoundN "dasy" (k5 "metri")) ; --UNCHK
lin dasyure_N = mkWN (compoundN "pussi" (k10A "näätä")) ; --UNCHK
lin data_N = mkN "data" ;
lin database_N = mkWN (compoundN "tieto" (k9A "kanta")) ; --UNCHK
lin datable_A = mkWA (k10 "oleva") "päivättävissä" ; --UNCHK
lin date_1_N = mkN "päivä" (mkN "määrä") ;
lin date_3_N = mkN "tapaaminen" ;
lin date_7_N = mkN "taateli" ;
lin date_N = mkN "päivämäärä" ; --- already split
lin date_V = mkWV (k53A "määrittää") "ikä" ; --UNCHK
lin date_V2 = mkWV2 (k53A "määrittää") "ikä" ; --UNCHK
lin dateless_A = mkWA (k34A "ajaton") ; --UNCHK
lin dateline_N = mkWN (compoundN "päiväys" (k5 "rivi")) ; --UNCHK
lin dating_N = mkWN (compoundN "ajo" (k38 "ittaminen")) "geologinen" ; --UNCHK
lin dative_N = mkWN (k5 "datiivi") ; --UNCHK
lin datum_N = mkWN (k1A "tieto") ; --f142
lin daub_N = mkWN (k39 "töherrys") ; --UNCHK
lin daub_V = mkWV (k67 "sivellä") ; --UNCHK
lin daub_V2 = mkWV2 (k67 "sivellä") ; --UNCHK
lin dauber_N = mkWN (k12 "töhrijä") ; --UNCHK
lin daughter_N = mkN "tytär" ;
lin daughterly_A = mkWA "tyttären" ; --UNCHK
lin daunt_V2 = mkWV2 (k53A "pelottaa") ; --UNCHK
lin daunting_A = mkWA (k10 "musertava") ; --UNCHK
lin dauntless_A = mkWA (k15 "urhea") ; --UNCHK
lin dauntlessness_N = mkWN (k40 "urheus") ; --UNCHK
lin dauphin_N = mkWN "dauphin" ; --UNCHK
lin davallia_N = mkWN "Davallia" ; --UNCHK
lin davenport_N = mkWN (compoundN "vuode" (k10 "sohva")) ; --UNCHK
lin daventry_PN = foreignPN "Daventry" ;
lin david_PN = foreignPN "David" ;
lin davit_N = mkWN (k5A "taavetti") ; --UNCHK
lin daw_N = mkWN (k9A "naakka") ; --UNCHK
lin dawah_N = mkWN "da’wa" ; --UNCHK
lin dawdle_V = mkWV (k74A "pudota") ; --UNCHK
lin dawdle_V2 = mkWV2 (k74A "pudota") ; --UNCHK
lin dawdler_N = mkWN (k12 "kuhnailija") ; --UNCHK
lin dawlish_PN = foreignPN "Dawlish" ;
lin dawn_N = mkWN (k39 "sarastus") ; --UNCHK
lin dawn_V = mkWV (k53 "sarastaa") ; --UNCHK
lin day_N = L.day_N ;
lin day_boarder_N = mkWN (compoundN "päivä" (k41 "oppilas")) ; --UNCHK
lin day_labourer_N = mkWN (compoundN "päivä" (k38 "työläinen")) ; --UNCHK
lin day_return_N = mkWN (compoundN "päivä" (k1A "lippu")) ; --UNCHK
lin day_school_N = mkWN (compoundN "päivä" (k1 "koulu")) ; --UNCHK
lin daybed_N = mkWN (k6 "divaani") ; --UNCHK
lin daybook_N = mkWN (compoundN "tili" (k9 "kirja")) ; --UNCHK
lin dayboy_N = mkWN (compoundN "päivä" (k41 "oppilas")) ; --UNCHK
lin daybreak_N = mkWN (k1A "koitto") ; --UNCHK
lin daycare_N = mkWN (compoundN "päivä" (k1A "hoito")) "lasten" ; --UNCHK
lin daydream_N = mkWN (k24 "uni") ; --UNCHK
lin daydream_V = mkWV (k67 "haaveilla") ; --UNCHK
lin daydreamer_N = mkWN (k12 "haihattelija") ; --UNCHK
lin daygirl_N = mkWN (compoundN "päivä" (k41 "oppilas")) ; --UNCHK
lin daylight_N = mkWN (compoundN "päivän" (k1 "valo")) ; --UNCHK
lin daylight_saving_N = mkWN (k9A "kesäaika") ; --UNCHK
lin daylong_A = mkWA (k10 "kestävä") "päivän" ; --UNCHK
lin daylong_Adv = mkWAdv "koko" "päivän" ; --UNCHK
lin days_N = mkWN (k9A "elinaika") ; --UNCHK
lin dayspring_N = mkWN (k1A "koitto") ; --UNCHK
lin daytime_N = mkWN (kH1 "aika") "valoisa" ; --UNCHK
lin dayton_PN = foreignPN "Dayton" ;
lin daze_N = mkWN (k40 "sameus") ; --UNCHK
lin daze_V2 = mkWV2 (k53A "pökerryttää") ; --UNCHK
lin dazedly_Adv = mkWAdv (k99 "apaattisesti") ; --UNCHK
lin dazzle_N = mkWN (k39 "kimallus") ; --UNCHK
lin dazzle_V2 = mkWV2 (k54A "hämmentää") ; --UNCHK
lin dazzling_A = mkWA (k15 "räikeä") ; --UNCHK
lin ddt_N = mkWN (compoundN "diklooridifenyylitrikloori" (k5 "etaani")) ; --UNCHK
lin de_emphasize_V2 = mkV2 "häivyttää" ; ---ARB
lin de_facto_A = mkWA (compoundA "tosi" (k38 "asiallinen")) ; --UNCHK
lin de_facto_Adv = mkWAdv "tosiasiassa" ; --UNCHK
lin de_jure_A = mkWA (k38 "mukainen") "lain" ; --UNCHK
lin de_jure_Adv = mkWAdv (k99 "laillisesti") ; --UNCHK
lin de_luxe_A = mkWA (k10 "loistava") ; --UNCHK
lin deacon_N = mkWN (k6 "diakoni") ; --UNCHK
lin deaconess_N = mkWN (k9 "diakonissa") ; --UNCHK
lin deactivate_V2 = mkWV2 (k58 "kytkeä") "pois" ; --UNCHK
lin deactivation_N = mkWN (compoundN "deakti" (k5A "vointi")) ; --UNCHK
lin dead_A = mkWA (k47 "kuollut") ;
lin dead_Adv = mkWAdv (k99 "kaikkiaan") "kerta" ; --UNCHK
lin dead_N = mkN "vainaja" | mkWN (k47 "kuollut") ;
lin deadeye_N = mkWN (k6 "silmuri") ; --UNCHK
lin deadhead_N = mkWN (compoundN "ajo" (k1 "neuvo")) "tyhjä" ; --UNCHK
lin deadlight_N = mkWN (compoundN "sokko" (k1A "luukku")) ; --UNCHK
lin deadline_N = mkN "määräaika" ;
lin deadliness_N = mkWN (k40 "kuolettavuus") ; --UNCHK
lin deadlock_N = mkWN (k39 "pysähdys") ; --UNCHK
lin deadlock_V = mkV vOlla "umpikujassa" ;
lin deadlocked_A = mkWA (k10 "oleva") "pattitilanteessa" ; --UNCHK
lin deadly_A = mkWA "tappava" ;
lin deadness_N = mkWN (k40 "elottomuus") ; --UNCHK
lin deadpan_A = mkWA (k34A "eleetön") ; --UNCHK
lin deadpan_Adv = mkWAdv (compoundAdv "pokerinaam" (k99 "alla")) ; --UNCHK
lin deadwood_N = mkWN (k12 "tavara") "tarpeeton" ; --UNCHK
lin deaf_A = mkWA (compoundA "kuulo" (k38 "vammainen")) ; --UNCHK
lin deaf_N = mkWN (kH1 "kuuro") ; --UNCHK
lin deafen_V2 = mkWV2 (compoundV "ääni" (k53 "eristää")) ; --UNCHK
lin deafening_A = mkWA (k10 "korviasärkevä") ; --UNCHK
lin deafness_N = mkWN (k40 "kuurous") ; --UNCHK
lin deal_N = mkN "jako" ;
lin deal_PN = foreignPN "Deal" ;
lin deal_V = mkV (mkV "käydä") "kauppaa" ;
lin deal_V2 = mkV2 "käsitellä" partitive | mkV2 "jakaa" ; ---- split
lin dealer_N = mkWN (k41 "kauppias") ; --f226
lin dealfish_N = mkWN "Trachipterus" "arcticus" ; --UNCHK
lin dealignment_N = mkWN "puoluerajojen" "hämärtyminen" ; --UNCHK
lin dealing_N = mkWN (k39 "toimitus") ;
lin dealings_N = mkWN (k38 "kanssakäyminen") ; --UNCHK
lin deamination_N = mkWN "deaminaatio" ; --UNCHK
lin dean_N = mkWN (kH1 "dekaani") ; --UNCHK
lin deanery_N = mkWN (k9A "virka") "tuomiorovastin" ; --UNCHK
lin deanship_N = mkWN (k9A "virka") "tuomiorovastin" ; --UNCHK
lin dear_A = mkWA (k38 "läheinen") ; --UNCHK
lin dear_Adv = mkWAdv "kalliiksi" ; --UNCHK
lin dear_Interj = variants {} ; --
lin dear_N = mkWN (k1A "rakastettu") ; --UNCHK
lin dearest_N = mkWN (k1A "rakastettu") ; --UNCHK
lin dearie_N = mkWN (k41A "rakas") ; --UNCHK
lin dearness_N = mkWN (k40 "arvokkuus") ; --UNCHK
lin dearth_N = mkWN (k40 "niukkuus") ; --UNCHK
lin deary_N = mkWN (k41A "rakas") ; --UNCHK
lin death_N = mkN "kuolema" ;
lin death_mask_N = mkWN (compoundN "kuolin" (k3 "naamio")) ; --UNCHK
lin death_rate_N = mkWN (k40 "kuolleisuus") ; --UNCHK
lin death_warrant_N = mkWN (compoundN "kuoleman" (k3 "tuomio")) ; --UNCHK
lin deathbed_N = mkWN (compoundN "kuolin" (k48A "vuode")) ; --UNCHK
lin deathblow_N = mkWN (compoundN "armon" (k1 "isku")) ; --UNCHK
lin deathless_A = mkWA (k38 "ikuinen") ; --UNCHK
lin deathlike_A = mkWA (k38 "kaltainen") "kuoleman" ; --UNCHK
lin deathly_A = mkWA (k38 "kaltainen") "kuoleman" ; --UNCHK
lin deathly_Adv = mkWAdv "kuoleman-" | adjAdv deathly_A ; --UNCHK -- derived
lin deathtrap_N = mkWN (compoundN "kuoleman" (k1A "loukku")) ; --UNCHK
lin deb_N = mkWN (k5A "debytantti") ; --UNCHK
lin debacle_N = mkWN (k2 "fiasko") ; --UNCHK
lin debar_V2 = mkWV2 (k58A "sulkea") "pois" ; --UNCHK
lin debark_V = mkWV (k52 "astua") "maihin" ; --UNCHK
lin debark_V2 = mkWV2 (k52 "astua") "maihin" ; --UNCHK
lin debarkation_N = mkWN (compoundN "maihin" (k1 "nousu")) ; --UNCHK
lin debarment_N = mkWN (compoundN "pois" (k38 "sulkeminen")) ; --UNCHK
lin debase_V2 = mkWV2 (k53A "vesittää") ; --UNCHK
lin debasement_N = mkWN (compoundN "arvon" (k39 "alennus")) ; --UNCHK
lin debaser_N = mkWN "arvon" "alentaja" ; --UNCHK
lin debasing_A = mkWA (k10 "alentava") ; --UNCHK
lin debatable_A = mkWA (k34A "selvittämätön") ; --UNCHK
lin debate_N = mkN "debatti" ;
lin debate_V = mkWV (k67A "väitellä") ; --UNCHK
lin debate_V2 = mkWV2 (k67A "väitellä") ; --UNCHK
lin debater_N = mkWN (k12 "keskustelija") ; --UNCHK
lin debauch_V2 = mkWV2 (k53A "johtaa") "harhaan" ; --UNCHK
lin debaucheeFem_N = mkWN (k12 "irstailija") ; --UNCHK ---- sense to be split
lin debaucheeMasc_N = mkWN (k12 "irstailija") ; --UNCHK ---- sense to be split
lin debauchee_N = mkWN (k12 "irstailija") ; --UNCHK
lin debenture_N = mkWN (compoundN "velka" (k39 "sitoumus")) ; --f99
lin debilitate_V2 = mkWV2 (k64 "viedä") "voimat" ; --UNCHK
lin debilitating_A = mkWA "heikentävä" ; --UNCHK
lin debilitation_N = mkWN (k39 "väsymys") ; --UNCHK
lin debilitative_A = mkWA "heikentävä" ; --UNCHK
lin debility_N = mkWN (k40 "sairaalloisuus") ; --UNCHK
lin debit_V2 = mkWV2 (k53A "veloittaa") ; --UNCHK
lin debonair_A = mkWA (k38 "herttainen") ; --UNCHK
lin debouch_V = mkWV (k58 "laskea") ; --UNCHK
lin debouch_V2 = mkWV2 (k58 "laskea") ; --UNCHK
lin debridement_N = mkWN "avaaminen" ; --UNCHK
lin debrief_V2 = mkWV2 (k54A "pyytää") "selvitystä" ; --UNCHK
lin debriefing_N = mkWN (k39 "selvitys") ; --UNCHK
lin debris_N = mkWN (k1 "romu") ; --UNCHK
lin debt_N = mkN (lin NK {s = d09A "velka"}) ;
lin debtor_N = mkWN (k38 "velallinen") ; --UNCHK
lin debugger_N = mkWN (compoundN "tarkastus" (k10 "ohjelma")) "virheiden" ; --UNCHK
lin debunk_V2 = mkWV2 (k53A "romuttaa") ; --UNCHK
lin debut_1_N = mkN "debyytti" ;
lin debut_2_N = mkWN (k38 "ensiesiintyminen") ; --
lin debut_V2 = mkWV2 (k62 "debytoida") ; --UNCHK
lin debutante_N = mkWN (k5A "debytantti") ; --UNCHK
lin decade_N = mkN "vuosi" (mkN "kymmen" "kymmenen" "kymmeniä") ;
lin decadence_N = mkWN (k5 "dekadenssi") ; --UNCHK
lin decadent_A = mkWA "turmeltunut" ; --UNCHK
lin decadent_N = mkWN (k5A "dekadentti") ; --UNCHK
lin decagon_N = mkWN "kymmenkulmio" ; --UNCHK
lin decahedron_N = mkWN (compoundN "kymmen" (k41A "tahokas")) ; --UNCHK
lin decal_N = mkWN "siirtopainokuva" ; --UNCHK
lin decalcification_N = mkWN (compoundN "kalkki" (k1A "kato")) ; --UNCHK
lin decalcomania_N = mkWN (compoundN "siirtopainokuva" (k10 "menetelmä")) ; --UNCHK
lin decalescence_N = mkWN (compoundN "hidas" (k38 "tuminen")) "lämpötilan" "nousun" ; --UNCHK
lin decalescent_A = mkWA "lämpöä" "imevä" ; --UNCHK
lin decalogue_N = mkWN "Kymmenen" "käskyä" ; --UNCHK
lin decameter_N = mkWN (compoundN "deka" (k5 "metri")) ; --UNCHK
lin decamp_V = mkWV (k52A "häipyä") ; --UNCHK
lin decampment_N = mkWN "leirin" "purkaminen" ; --UNCHK
lin decant_V2 = mkWV2 (k57A "kaataa") ; --UNCHK
lin decantation_N = mkWN (k5A "dekantointi") ; --UNCHK
lin decanter_N = mkWN (k6 "dekantteri") ; --UNCHK
lin decapitation_N = mkWN (k39 "mestaus") ; --UNCHK
lin decapod_N = mkWN (compoundN "kymmen" (k38 "jalkainen")) ; --UNCHK
lin decarbonize_V2 = mkWV2 (k53 "poistaa") "karsta" ; --UNCHK
lin decarboxylase_N = mkWN (compoundN "dekarboksyl" (k5 "aasi")) ; --UNCHK
lin decarboxylation_N = mkWN (compoundN "pois" (k38 "taminen")) "karboksyylien" ; --UNCHK
lin decasyllabic_A = mkWA (compoundA "kymmen" (k38 "tavuinen")) ; --UNCHK
lin decasyllable_N = mkWN (k48A "säe") "kymmentavuinen" ; --UNCHK
lin decathlon_N = mkWN (compoundN "kymmen" (k2 "ottelu")) ; --UNCHK
lin decay_N = mkWN (compoundN "mätä" (k38 "neminen")) ; --UNCHK
lin decay_V = mkWV (k74 "lahota") ; --UNCHK
lin decayable_A = mkWA (compoundA "mätän" (k10 "evä")) ; --UNCHK
lin decayed_A = mkWA (k1 "laho") ; --UNCHK
lin decease_N = mkWN (k1A "hengenveto") "viimeinen" ; --UNCHK
lin decease_V = mkWV (k67 "kuolla") "äkillisesti" ; --UNCHK
lin deceased_A = mkA (mkN "kuollut" "kuolleen" "kuolleita") ;
lin deceit_N = mkWN (k39 "huiputus") ; --UNCHK
lin deceitful_A = mkWA (k38 "valheellinen") ; --UNCHK
lin deceitfulness_N = mkWN (k40 "juonikkuus") ; --UNCHK
lin deceive_V2 = mkWV2 (k53A "johtaa") "harhaan" ; --UNCHK
lin deceiver_N = mkWN (k10 "petkuttaja") ; --UNCHK
lin deceivingly_Adv = mkWAdv (k99 "valheellisesti") ; --UNCHK
lin decelerate_V = mkWV (k53 "hidastaa") ; --UNCHK
lin decelerate_V2 = mkWV2 (k53 "hidastaa") ; --UNCHK
lin deceleration_N = mkWN (compoundN "hidas" (k38 "taminen")) ; --UNCHK
lin decency_N = mkWN (k40 "säädyllisyys") ; --UNCHK
lin decent_A = mkWA (k38 "säädyllinen") ; --UNCHK
lin decentralization_N = mkWN (compoundN "haja" (k38 "uttaminen")) ; --UNCHK
lin decentralize_V2 = mkWV2 (k53A "hajauttaa") ; --UNCHK
lin deception_N = mkWN (k3 "illuusio") ; --UNCHK
lin deceptive_A = mkWA (k38 "petollinen") ;
lin deceptiveness_N = mkWN (k40 "kieroutuneisuus") ; --UNCHK
lin decibel_N = mkWN (k5 "desibeli") ; --UNCHK
lin decide_V = mkV "päättää" ;
lin decide_V2 = mkV2 (mkV "päättää") ;
lin decide_VS = mkVS (mkV "päättää") ;
lin decide_VV = mkVV "päättää" ;
lin decide_on_V2 = prepV2 OP_decide_V OP_on_Prep ; -- guess-p-verb
lin decide_upon_V2 = prepV2 OP_decide_V OP_upon_Prep ; -- guess-p-verb
lin decided_A = mkWA (k10 "selvä") ; --UNCHK
lin decidua_N = mkWN (compoundN "kato" (k1 "kalvo")) ; --UNCHK
lin deciduous_A = mkWA (compoundA "kesä" (k9A "vihanta")) ; --UNCHK
lin decigram_N = mkWN (compoundN "desi" (k9 "gramma")) ; --UNCHK
lin decile_N = mkWN "desiili" ; --UNCHK
lin deciliter_N = mkWN (compoundN "desi" (k9 "litra")) ; --UNCHK
lin decimal_A = mkWA "desimaali-" ; --UNCHK
lin decimal_N = mkWN (compoundN "desimaali" (k1A "luku")) ; --UNCHK
lin decimalization_N = mkWN "kymmenlukujärjestelmään" "siirtyminen" ; --UNCHK
lin decimalize_V2 = mkWV2 (k52A "siirtyä") "kymmenlukujärjestelmään" ; --UNCHK
lin decimate_V2 = mkWV2 (k64 "viedä") "hautaan" ; --UNCHK
lin decimation_N = mkWN (compoundN "joukko" (k1 "tuho")) ; --UNCHK
lin decimeter_N = mkWN (compoundN "desi" (k5 "metri")) ; --UNCHK
lin decipherable_A = mkWA (k10 "luettava") ; --UNCHK
lin decipherer_N = mkWN (k10 "purkaja") "salakirjoituksen" ; --UNCHK
lin decision_N = mkN "päätös" ;
lin decision_making_N = mkN "päätöksenteko" ;
lin decisive_A = mkWA (k10 "ratkaiseva") ;
lin decisiveness_N = mkWN (k40 "lopullisuus") ; --UNCHK
lin deck_N = mkN (lin NK {s = d28 "kansi"}) ;
lin deck_V2 = mkWV2 (k73 "tyrmätä") ; --UNCHK
lin deck_out_V = mkWV (k52A "pukeutua") ; --UNCHK
lin decker_N = mkWN "-kerroksinen" ; --UNCHK
lin deckhand_N = mkWN (compoundN "kansi" (k42 "mies")) ; --UNCHK
lin deckle_N = mkWN (compoundN "dek" (k5 "keli")) ; --UNCHK
lin deckled_A = mkWA (compoundA "rosoreu" (k38 "nainen")) ; --UNCHK
lin declaim_V = mkWV (k61A "sättiä") ; --UNCHK
lin declaim_V2 = mkWV2 (k61A "sättiä") ; --UNCHK
lin declamation_N = mkWN (k48 "puhe") "kiivas" ; --UNCHK
lin declamatory_A = mkWA (k38 "korkealentoinen") ; --UNCHK
lin declarable_A = mkWA "ilmoitettava" ; --UNCHK
lin declaration_N = mkN (lin NK {s = d39 "julistus"}) ;
lin declarative_A = mkWA "selittävä" ; --UNCHK
lin declare_V = mkWV (k53A "ilmoittaa") ; --UNCHK
lin declare_V2 = mkWV2 (k53A "ilmoittaa") ; --UNCHK
lin declare_VS = mkVS (mkV "julistaa") ;
lin declassification_N = mkWN "salassapitomääräyksen" "kumoaminen" ; --UNCHK
lin declension_N = mkWN (k3 "deklinaatio") ; --UNCHK
lin declination_N = mkWN "kohtelias" "kieltäytyminen" ; --UNCHK
lin decline_N = mkN "rappio" ;
lin decline_V = mkV (lin VK {s = c58 "laskea"}) ;
lin decline_V2 = mkV2 (mkV "hylätä" "hylkäsi") ;
lin decline_VV = mkVV (mkV "pidättäytyä") infElat ;
lin declivitous_A = mkWA (k10A "jyrkkä") ; --UNCHK
lin declivity_N = mkWN (k1 "lasku") ; --UNCHK
lin declutch_V = mkWV (k53 "nostaa") "kytkin" ; --UNCHK
lin decoction_N = mkWN (k39 "valmistus") "dekoktin" ; --UNCHK
lin decode_V2 = mkWV2 (k66 "ratkaista") ; --UNCHK
lin decoder_N = mkWN (k6 "dekooderi") ; --UNCHK
lin decoding_N = mkWN (k1A "purku") "salauksen" ; --UNCHK
lin decoke_V2 = mkWV2 (k53 "poistaa") "karsta" ; --UNCHK
lin decolletage_N = mkWN (compoundN "pään" (k19 "tie")) "syvään" "uurrettu" ; --UNCHK
lin decollete_A = mkWA (compoundA "uurre" (k1 "ttu")) "syvään" ; --UNCHK
lin decolonization_N = mkWN (compoundN "itse" (k38 "näistyminen")) "siirtomaiden" ; --UNCHK
lin decolonize_V2 = mkWV2 (k53 "itsenäistää") ; --UNCHK
lin decompose_V = mkWV (k53A "hajottaa") ; --UNCHK
lin decompose_V2 = mkWV2 (k53A "hajottaa") ; --UNCHK
lin decomposition_N = mkWN (compoundN "dekom" (k3 "positio")) ; --UNCHK
lin decompositional_A = mkWA "mädättävä" ; --UNCHK
lin decompound_A = mkWA (k38 "kerrannainen") "kahdesti" ; --UNCHK
lin decompress_V2 = mkWV2 (k52A "rauhoittua") ; --UNCHK
lin decompression_N = mkWN (compoundN "ale" (k38 "ntaminen")) "paineen" ; --UNCHK
lin decongestant_N = mkWN (compoundN "dekonges" (k5A "tantti")) ; --UNCHK
lin deconsecrated_A = mkWA (compoundA "sekulariso" (k1A "itu")) ; --UNCHK
lin deconstruction_N = mkWN (compoundN "dekonstruktion" (k5 "ismi")) ; --UNCHK
lin deconstructionist_A = mkWA (k10 "kannattava") "dekonstruktiota" ; --UNCHK
lin deconstructivism_N = mkWN (compoundN "dekonstruktiv" (k5 "ismi")) ; --UNCHK
lin decontaminate_V2 = mkWV2 (k53 "puhdistaa") "saasteesta" ; --UNCHK
lin decontamination_N = mkWN "dekontaminaatio" ; --UNCHK
lin decontrol_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin decor_N = mkWN (k39 "sisustus") ; --UNCHK
lin decorate_V2 = mkWV2 (k53 "somistaa") ; --UNCHK
lin decoration_N = mkWN (k2 "koristelu") ;
lin decorative_A = mkWA (k38 "koristeellinen") ; --UNCHK
lin decorativeness_N = mkWN (k40 "koristeellisuus") ; --UNCHK
lin decorator_N = mkWN (k10 "somistaja") ; --UNCHK
lin decorous_A = mkWA (k34A "moitteeton") ; --UNCHK
lin decortication_N = mkWN (compoundN "pois" (k38 "taminen")) "kuoren" ; --UNCHK
lin decorum_N = mkWN (k40 "säädyllisyys") ; --UNCHK
lin decoupage_N = mkWN "decoupage" ; --UNCHK
lin decoy_N = mkWN (k33A "houkutin") ; --UNCHK
lin decoy_V2 = mkWV2 (k67A "houkutella") "ansaan" ; --UNCHK
lin decrease_N = mkWN (k39 "vähennys") ; --UNCHK
lin decrease_V = mkWV (k58 "laskea") ; --UNCHK
lin decrease_V2 = mkWV2 (k58 "laskea") ;
lin decree_N = mkWN (k39 "asetus") ; --UNCHK
lin decree_V2 = mkWV2 (k53A "säätää") ; --UNCHK
lin decree_nisi_N = mkWN (compoundN "asumusero" (k39 "päätös")) ; --UNCHK
lin decrepit_A = mkWA (k41 "hauras") ; --UNCHK
lin decrepitation_N = mkWN (k12 "rätinä") ; --UNCHK
lin decrepitude_N = mkWN (k40 "raihnaisuus") ; --UNCHK
lin decrescendo_A = mkWA "diminuendo" ; --UNCHK
lin decrescendo_N = mkWN "diminuendo" ; --UNCHK
lin decriminalization_N = mkWN (compoundN "dekriminali" (k5A "sointi")) ; --UNCHK
lin decry_V2 = mkWV2 (k61A "sättiä") ; --UNCHK
lin decubitus_N = mkWN (compoundN "makuu" (k1A "asento")) ; --UNCHK
lin decumary_N = mkWN "Decumaria" "barbara" ; --UNCHK
lin decurved_A = mkWA "alaspäin" "kaartuva" ; --UNCHK
lin decussate_A = mkWA (k38 "ristimäinen") ; --UNCHK
lin dedicate_V2 = mkV2 "omistaa" ; --mkWV2 (k53A "pyhittää") ;
lin dedication_N = mkWN (k5A "lojaliteetti") ; --UNCHK
lin dedifferentiated_A = mkWA (compoundA "taa" (k47 "ntunut")) "erilaistumisessa" ; --UNCHK
lin dedifferentiation_N = mkWN "dedifferentiaatio" ; --UNCHK
lin deduce_V2 = mkWV2 (k53A "johtaa") ; --UNCHK
lin deducible_A = mkWA (k10 "oleva") "johdettavissa" ; --UNCHK
lin deduct_V2 = mkV2 "vähentää" ; --mkWV2 (k53A "johtaa") ;
lin deductible_A = mkWA (compoundA "vähennys" (k38 "kelpoinen")) ;
lin deductible_N = mkWN (k50 "omavastuu") ; --UNCHK
lin deduction_N = mkWN (k39 "vähennys") ; --UNCHK
lin deductive_A = mkWA (k38 "deduktiivinen") ; --UNCHK
lin deed_N = mkWN (k25 "toimi") ; --UNCHK
lin deem_V2 = mkWV2 (k53A "olettaa") ; --UNCHK
lin deem_V2A = mkWV2A (k53A "olettaa") ; --UNCHK
lin deem_V2V = mkWV2V (k53A "olettaa") ; --UNCHK
lin deep_A = mkWA (k10 "syvä") | mkA "syvällinen" ; ---- split ?
lin deep_Adv = mkWAdv (k99 "syvälle") ; --UNCHK
lin deep_N = mkWN (k24 "meri") ; --UNCHK
lin deep_freeze_N = mkWN (compoundN "jää" (k38 "dyttäminen")) ; --UNCHK
lin deep_freeze_V2 = mkWV2 (k53 "pakastaa") ; --UNCHK
lin deepen_V = mkWV (k54A "syventää") ; --UNCHK
lin deepen_V2 = mkWV2 (k54A "syventää") ; --UNCHK
lin deepening_N = mkWN "syveneminen" ; --UNCHK
lin deepness_N = mkWN (k26 "ääni") "matala" ; --UNCHK
lin deer_N = mkWN (k41 "kauris") ; --UNCHK
lin deerberry_N = mkWN "Vaccinium" "stamineum" ; --UNCHK
lin deerskin_N = mkWN (compoundN "hirven" (k9 "nahka")) ; --UNCHK
lin deerstalker_N = mkWN (compoundN "metsästäjän" (k1A "hattu")) ; --UNCHK
lin deerstalking_N = mkWN (compoundN "hirven" (k39 "metsästys")) ; --UNCHK
lin deface_V2 = mkWV2 (k53A "vahingoittaa") ; --UNCHK
lin defacement_N = mkWN (compoundN "pila" (k38 "aminen")) ; --UNCHK
lin defalcation_N = mkWN (k39 "anastus") ; --UNCHK
lin defamation_N = mkWN (k39 "mustamaalaus") ; --UNCHK
lin defamatory_A = mkWA (compoundA "must" (k9 "aava")) ; --UNCHK
lin defame_V2 = mkWV2 (k73A "liata") ; --UNCHK
lin defamer_N = mkWN (k10 "parjaaja") ; --UNCHK
lin default_N = mkN "laimin" (mkN "lyönti") ; --f56
lin default_V = mkV "laiminlyödä" ;
lin defeasible_A = mkWA (k10 "oleva") "kumottavissa" ; --UNCHK
lin defeat_N = mkWN (k3 "häviö") ;
lin defeat_V2 = mkWV2 (k64 "lyödä") ;
lin defeatism_N = mkWN "tappiomieliala" ; --UNCHK
lin defeatist_N = mkWN (k5 "pessimisti") ; --UNCHK
lin defecate_V = mkWV (k73A "kakata") ; --UNCHK
lin defecation_N = mkWN (compoundN "pas" (k38 "kantaminen")) ; --UNCHK
lin defecator_N = mkWN (compoundN "pask" (k10 "oja")) ; --UNCHK
lin defect_N = mkWN (kH1 "vika") ; --UNCHK
lin defect_V = mkWV (k60A "lähteä") "paikaltaan" ; --UNCHK
lin defection_N = mkWN "hylkääminen" ; --UNCHK
lin defective_A = mkWA (k38 "rikkinäinen") ;
lin defectiveness_N = mkWN (k40 "viallisuus") ; --UNCHK
lin defector_N = mkWN (k6 "loikkari") ; --UNCHK
lin defence_N = mkN "puolustus" ;
lin defenceless_A = mkWA (k34A "aseeton") ; --UNCHK
lin defencelessness_N = mkWN (compoundN "puolustus" (k40 "kyvyttömyys")) ; --UNCHK
lin defend_V2 = mkV2 "puolustaa" partitive ;
lin defendable_A = mkWA (k10 "oleva") "puolustettavissa" ; --UNCHK
lin defendant_N = mkN (lin NK {s = d10 "vastaaja"}) ;
lin defenderFem_N = mkWN (k5A "vahti") ;
lin defenderMasc_N = variants {} ; --
lin defenestration_N = mkWN (compoundN "ikku" (k9 "nasta")) "heittäminen" "ulos" ; --UNCHK
lin defense_N = mkN "puolustus" ;
lin defenseless_A = mkWA (k34A "aseeton") ; --UNCHK
lin defenseless_Adv = mkWAdv "puolustuskyvyttömänä" ; --UNCHK
lin defenselessness_N = mkWN (compoundN "puolustus" (k40 "kyvyttömyys")) ; --UNCHK
lin defensibility_N = mkWN "puolustettavuus" ; --UNCHK
lin defensible_A = mkWA (k10 "oleva") "puolustettavissa" ; --UNCHK
lin defensive_A = mkA "defensiivinen" ; ---ARB WA "puolustus-" ;
lin defensive_N = mkWN (compoundN "puolustus" (k48A "asenne")) ; --UNCHK
lin defensiveness_N = mkWN "puolustelevuus" ; --UNCHK
lin defer_V = mkWV (k56A "antaa") "myöten" ; --UNCHK
lin defer_V2 = mkWV2 (k56A "antaa") "myöten" ; --UNCHK
lin deference_N = mkWN (k39 "kunnioitus") ; --UNCHK
lin deferent_A = mkWA (k38 "huomaavainen") ; --UNCHK
lin deferential_A = mkWA (k38 "huomaavainen") ; --UNCHK
lin deferment_N = mkWN (k39 "lykkäys") ; --UNCHK
lin deferral_N = mkWN (k39 "lykkäys") ; --UNCHK
lin defervescence_N = mkWN "kuumeen" "laskeminen" ; --UNCHK
lin defiance_N = mkWN (compoundN "uhma" (k38 "aminen")) ; --UNCHK
lin defiant_A = mkWA (k34A "taipumaton") ; --UNCHK
lin defibrillation_N = mkWN (compoundN "rytmin" (k1A "siirto")) "sähköinen" ; --UNCHK
lin deficiency_N = mkWN (k39 "vajaus") ; --UNCHK
lin deficit_N = mkWN (k48 "vaje") ; --f197
lin defile_N = mkWN (k1 "rotko") ; --UNCHK
lin defile_V = mkWV (k73A "liata") ; --UNCHK
lin defile_V2 = mkWV2 (k73A "liata") ; --UNCHK
lin defilement_N = mkWN (k2 "häpäisy") ; --UNCHK
lin definable_A = mkWA (k10 "oleva") "määriteltävissä" ; --UNCHK
lin define_V = mkV "määritellä" ;
lin define_V2 = mkV2 "määritellä" ;
lin definite_A = mkA (lin AK {s = d09 "varma"}) ;
lin definition_N = mkWN (k39 "rajaus") ; --UNCHK
lin definitive_A = mkWA (k38 "lopullinen") ;
lin deflagration_N = mkWN (compoundN "pala" (k38 "minen")) "nopea" ; --UNCHK
lin deflate_V2 = mkWV2 (k52A "tyhjentyä") ; --UNCHK
lin deflation_N = mkWN (k39 "tyhjennys") ; --UNCHK
lin deflationary_A = mkWA "deflatorinen" ; --UNCHK
lin deflect_V = mkWV (k53 "estää") ; --UNCHK
lin deflect_V2 = mkWV2 (k53 "estää") ; --UNCHK
lin deflection_N = mkWN (compoundN "kierto" (k19 "tie")) ; --UNCHK
lin deflective_A = mkWA "taittava" ; --UNCHK
lin defloration_N = mkWN (k38 "vieminen") "neitsyyden" ; --UNCHK
lin deflower_V2 = mkWV2 (k53A "vesittää") ; --UNCHK
lin defoliant_N = mkWN (compoundN "vesakko" (k1A "myrkky")) ; --UNCHK
lin defoliate_A = mkWA "lehtensä" "pudottanut" ; --UNCHK
lin defoliation_N = mkWN "lehtien" "riistäminen" ; --UNCHK
lin defoliator_N = mkWN (k38 "hyönteinen") "lehtikatoa" "aiheuttava" ; --UNCHK
lin deforest_V2 = mkWV2 (k53 "poistaa") "metsä" ; --UNCHK
lin deforestation_N = mkWN "metsän" "hävittäminen" ; --UNCHK
lin deform_V2 = mkWV2 (k53A "muuttaa") "muotoa" ; --UNCHK
lin deformation_N = mkWN (k2 "vääristely") ; --UNCHK
lin deformational_A = mkWA "vääristävä" ; --UNCHK
lin deformity_N = mkWN (k9 "vamma") "näkyvä" ; --UNCHK
lin defraud_V2 = mkWV2 (k53A "vedättää") ; --UNCHK
lin defray_V2 = mkWV2 (k54A "kustantaa") ; --UNCHK
lin defrayal_N = mkWN (k39 "suoritus") "maksun" ; --UNCHK
lin defrayment_N = mkWN (k39 "suoritus") "maksun" ; --UNCHK
lin defrost_V2 = mkWV2 (k53A "sulattaa") ; --UNCHK
lin defroster_N = mkWN (k33A "lämmitin") ; --UNCHK
lin deft_A = mkWA (k10 "kätevä") ; --UNCHK
lin deftness_N = mkWN (k40 "nopeus") ; --UNCHK
lin defunct_A = mkWA (k47 "kuollut") ;
lin defuse_V2 = mkWV2 (k71 "tehdä") "vaarattomaksi" ; --UNCHK
lin defy_V2 = mkWV2 (k56 "haastaa") ;
lin defy_V2V = mkWV2V (k56 "haastaa") ; --UNCHK
lin degage_A = mkWA (k34A "puolueeton") ; --UNCHK
lin degauss_V2 = mkWV2 (k62 "demagnetoida") ; --UNCHK
lin degaussing_N = mkWN (compoundN "pois" (k38 "taminen")) "magneettisuuden" ; --UNCHK
lin degeneracy_N = mkWN (k39 "turmelus") ; --UNCHK
lin degenerate_A = mkWA (k38 "paheellinen") ; --UNCHK
lin degenerate_N = mkWN (k1 "pervo") ; --UNCHK
lin degenerate_V = mkWV (k72A "heiketä") ; --UNCHK
lin degeneration_N = mkWN (k3 "regressio") ; --UNCHK
lin degenerative_A = mkWA "rappeutumis-" ; --UNCHK
lin degradation_N = mkWN (compoundN "arvon" (k39 "alennus")) ; --UNCHK
lin degrade_V2 = mkWV2 (k58 "laskea") "hintaa" ; --UNCHK
lin degree_1_N = mkN "aste" ;
lin degree_2_N = mkN "oppiarvo" ;
lin degree_3_N = mkN "aste" ;
lin degree_N = mkN "aste" ; ---- already split
lin degressive_A = mkWA (k10 "aleneva") ; --UNCHK
lin dehiscence_N = mkWN (compoundN "vari" (k38 "staminen")) "siementen" ; --UNCHK
lin dehorn_V2 = mkWV2 (k53 "poistaa") "sarvet" ; --UNCHK
lin dehumanization_N = mkWN (compoundN "epä" (k38 "inhimillistäminen")) ; --UNCHK
lin dehumanize_V2 = mkWV2 (k53 "koneistaa") ; --UNCHK
lin dehydrate_V2 = mkWV2 (k52 "kuivua") ; --UNCHK
lin dehydration_N = mkWN (k39 "haihdutus") ; --UNCHK
lin deictic_A = mkWA "deiktinen" ; --UNCHK
lin deictic_N = mkWN (k9 "sana") "deiktinen" ; --UNCHK
lin deific_A = mkWA (k38 "jumalainen") ; --UNCHK
lin deification_N = mkWN "apoteoosi" ; --UNCHK
lin deify_V2 = mkWV2 (k53A "korottaa") "jumalaksi" ; --UNCHK
lin deign_V = mkWV (k74 "vajota") ; --UNCHK
lin deinocheirus_N = mkWN "Deinocheirus" ; --UNCHK
lin deipnosophist_N = mkWN "taitava" "jutustelija" ; --UNCHK
lin deism_N = mkWN (k50 "vapaa-ajattelu") ; --UNCHK
lin deist_A = mkWA (k38 "deistinen") ; --UNCHK
lin deist_N = mkWN (k50 "vapaa-ajattelija") ; --UNCHK
lin deity_N = mkWN (k34A "kuolematon") ; --UNCHK
lin deixis_N = mkWN "deiksis" ; --UNCHK
lin deject_V2 = mkWV2 (k53 "ahdistaa") ; --UNCHK
lin dejectedly_Adv = mkWAdv (k99 "alakuloisesti") ; --UNCHK
lin dejection_N = mkWN (k40 "masentuneisuus") ; --UNCHK
lin dekagram_N = mkWN (compoundN "deka" (k9 "gramma")) ; --UNCHK
lin dekaliter_N = mkWN (compoundN "deka" (k9 "litra")) ; --UNCHK
lin dekko_N = mkWN (k2 "vilkaisu") ; --UNCHK
lin delavirdine_N = mkWN "Rescriptor" ; --UNCHK
lin delaware_PN = foreignPN "Delaware" ;
lin delay_N = mkWN (k39 "viivästys") ; --f72
lin delay_V = mkWV (k53A "viivyttää") ; --UNCHK
lin delay_V2 = mkWV2 (k53A "viivyttää") ; --f56
lin delay_VS = mkWVS (k53A "viivyttää") ; --UNCHK
lin delayed_action_N = mkWN (k9A "toiminta") "hidastettu" ; --UNCHK
lin delayer_N = mkWN "viivyttäjä" ; --UNCHK
lin delectability_N = mkWN (k40 "herkullisuus") ; --UNCHK
lin delectable_A = mkWA (k10 "viehättävä") "seksuaalisesti" ; --UNCHK
lin delectation_N = mkWN (k1 "ilo") ; --UNCHK
lin delegacy_N = mkWN (compoundN "nimi" (k38 "ttäminen")) "edustajan" ; --UNCHK
lin delegate_N = mkWN (k10 "edustaja") ;
lin delegate_V2 = mkWV2 (k73 "määrätä") "tehtävään" ; --UNCHK
lin delegating_N = mkWN "valtuuttaminen" ; --UNCHK
lin delegation_N = mkWN "valtuuttaminen" ; --UNCHK
lin delete_V2 = mkV2 "hävittää" ;
lin deleterious_A = mkWA (k38 "turmiollinen") ; --UNCHK
lin deletion_N = mkWN (compoundN "pois" (k38 "taminen")) ; --UNCHK
lin delf_N = mkWN (k1A "kaivanto") ; --UNCHK
lin delft_N = mkWN (k5 "fajanssi") "Delftin" ; --UNCHK
lin delhi_PN = foreignPN "Delhi" ;
lin deliberate_A = mkWA (k38 "verkkainen") ; --UNCHK
lin deliberate_V = mkWV (k62 "puntaroida") ; --UNCHK
lin deliberate_V2 = mkWV2 (k62 "puntaroida") ; --UNCHK
lin deliberation_N = mkWN (k40 "varovaisuus") ;
lin deliberative_A = mkWA (k10 "harkitseva") ; --UNCHK
lin delible_A = mkWA "poistettavissa" ; --UNCHK
lin delicacy_N = mkWN (k40 "herkkyys") ; --UNCHK
lin delicate_A = mkWA (k41 "hauras") ;
lin delicatessen_N = mkWN (compoundN "ruoka" (k9A "kauppa")) ; --UNCHK
lin delicious_A = mkWA (k10 "miellyttävä") ; --UNCHK
lin delight_N = mkWN (k1 "ilo") ; --UNCHK
lin delight_V = mkV "nauttia" ; --intransitive
lin delight_V2 = mkV2 "ilahduttaa" ;
lin delighted_A = variants {} ; --
lin delightful_A = mkWA (k10 "miellyttävä") ; --UNCHK
lin delimit_V2 = mkWV2 (k53A "määrittää") "rajat" ; --UNCHK
lin delimitate_V2 = mkWV2 (k53A "määrittää") "rajat" ; --UNCHK
lin delimitation_N = mkWN (kH1 "raja") ; --UNCHK
lin delineate_V2 = mkWV2 (k73 "kuvata") ; --UNCHK
lin delineation_N = mkWN (k10 "kuva") ; --UNCHK
lin delineative_A = mkWA "hahmoteltu" ; --UNCHK
lin delinquency_N = mkWN (k39 "rikos") "nuoren" "tekemä" ; --UNCHK
lin delinquent_A = mkWA (k10 "oleva") "myöhässä" ; --UNCHK
lin delinquent_N = mkWN (compoundN "nuoriso" (k38 "rikollinen")) ; --UNCHK
lin deliquescent_A = mkWA (compoundA "liuke" (k9 "neva")) ; --UNCHK
lin delirious_A = mkWA (k41A "riehakas") ; --UNCHK
lin delirium_N = mkWN (compoundN "houre" (k9 "tila")) ; --UNCHK
lin delirium_tremens_N = mkWN (compoundN "juoppo" (k40 "hulluus")) ; --UNCHK
lin deliver_V = mkV (mkV "tuottaa") "tulosta" ; ---ARB mkWV (k63 "saada") "lapsi" ;
lin deliver_V2 = mkV2 "toimittaa" ; --f64
lin deliverable_A = mkWA (k10 "oleva") "toimitettavissa" ; --UNCHK
lin deliverable_N = mkWN (k48A "tuote") ; --UNCHK
lin deliverance_N = mkWN (k39 "vapahdus") ; --UNCHK
lin deliverer_N = mkWN (k10 "toimittaja") ; --UNCHK
lin delivery_N = mkWN (k39 "synnytys") ; --f140
lin deliveryman_N = mkWN (k10 "jakaja") ; --UNCHK
lin dell_N = mkWN (k1 "laakso") "metsäinen" ; --UNCHK
lin delouse_V2 = mkWV2 (k53 "puhdistaa") "syöpäläisistä" ; --UNCHK
lin delphic_A = mkWA (compoundA "delfoi" (k38 "lainen")) ; --UNCHK
lin delphinium_N = mkWN (k39 "ritarinkannus") ; --UNCHK
lin delta_N = mkWN (k9 "delta") ;
lin deltoid_A = mkWA (compoundA "kolmi" (k38 "omainen")) ; --UNCHK
lin deltoid_N = mkWN (compoundN "hartia" (k39 "lihas")) "kolmipäinen" ; --UNCHK
lin delude_V2 = mkWV2 (k73 "huijata") ; --UNCHK
lin deluge_N = mkWN (k39 "vedenpaisumus") ; --UNCHK
lin deluge_V2 = mkWV2 (k53A "hukuttaa") ; --UNCHK
lin delusion_N = mkWN (k9 "harha") ; --UNCHK
lin delusional_A = mkWA (k38 "harhainen") ; --UNCHK
lin delusive_A = mkWA (k38 "valheellinen") ; --UNCHK
lin deluxe_A = mkWA (k10 "loistava") ; --UNCHK
lin delve_V = mkWV (k61A "tonkia") ; --UNCHK
lin delve_V2 = mkWV2 (k61A "tonkia") ; --UNCHK
lin demagnetization_N = mkWN (compoundN "demagneti" (k5A "sointi")) ; --UNCHK
lin demagnetize_V2 = mkWV2 (k62 "demagnetoida") ; --UNCHK
lin demagogic_A = mkWA (k38 "demagoginen") ; --UNCHK
lin demagogue_N = mkWN (k5 "demagogi") ; --UNCHK
lin demagoguery_N = mkWN (k12 "demagogia") ; --UNCHK
lin demagogy_N = mkWN (k12 "demagogia") ; --UNCHK
lin demand_N = mkN "kysyntä" ;
lin demand_V2 = mkWV2 (k61A "vaatia") ; --f52
lin demand_VS = mkWVS (k61A "vaatia") ;
lin demander_N = mkWN (k12 "vaatija") ; --UNCHK
lin demanding_A = mkWA (k10 "vaativa") ; --UNCHK
lin demantoid_N = mkWN "demantoidi" ; --UNCHK
lin demarcate_V2 = mkWV2 (k53A "määrittää") "rajat" ; --UNCHK
lin demarcation_N = mkWN (kH1 "raja") ; --UNCHK
lin demarche_N = mkWN "demarssi" ; --UNCHK
lin demean_V2 = mkWV2 (k52 "väheksyä") ; --UNCHK
lin demeaning_A = mkWA (k38 "häpeällinen") ; --UNCHK
lin demeanor_N = mkWN (k9A "toiminta") ; --UNCHK
lin demeanour_N = mkWN (k9A "toiminta") ; --UNCHK
lin demented_A = mkWA (k99 "tolaltaan") "poissa" ; --UNCHK
lin dementia_N = mkWN (k12 "dementia") ; --UNCHK
lin demerara_N = mkWN (compoundN "demerara" (k6 "sokeri")) ; --UNCHK
lin demerit_N = mkWN (kH1 "vika") ; --UNCHK
lin demesne_N = mkWN (k18 "maa") ; --UNCHK
lin demiglace_N = mkWN (compoundN "liha" (k25 "liemi")) "kokoon" "keitetty" ; --UNCHK
lin demigod_N = mkWN (k5 "demoni") ; --UNCHK
lin demijohn_N = mkWN (compoundN "kori" (k1 "pullo")) ; --UNCHK
lin demilitarize_V2 = mkWV2 (k62 "demilitarisoida") ; --UNCHK
lin demimondaine_N = mkWN (k38 "nainen") "puolimaailman" ; --UNCHK
lin demimonde_N = mkWN (k38 "nainen") "puolimaailman" ; --UNCHK
lin demineralization_N = mkWN (compoundN "pois" (k38 "taminen")) "suolojen" ; --UNCHK
lin demise_N = mkWN (k10 "kuolema") ; --UNCHK
lin demist_V2 = mkWV2 (k53 "poistaa") "huuru" ; --UNCHK
lin demister_N = mkWN (compoundN "tuulilasin" (k33A "lämmitin")) ; --UNCHK
lin demitasse_N = mkWN (compoundN "mokka" (k5A "kuppi")) ; --UNCHK
lin demiurge_N = mkWN "demiurgi" ; --UNCHK
lin demo_N = mkWN (k5A "demonstrointi") ; --UNCHK
lin demob_V2 = mkWV2 (k52A "kotiutua") "sotapalveluksesta" ; --UNCHK
lin demobilization_N = mkWN (k5A "demobilisointi") ; --UNCHK
lin demobilize_V2 = mkWV2 (k52A "kotiutua") "sotapalveluksesta" ; --UNCHK
lin democracy_N = mkN (lin NK {s = d12 "demokratia"}) ;
lin democrat_N = mkWN (k5 "populisti") ; --UNCHK
lin democratic_A = mkA (lin AK {s = d38 "demokraattinen"}) ;
lin democratization_N = mkN (lin NK {s = d05A "demokratisointi"}) ;
lin democratize_V2 = mkWV2 (k62 "demokratisoida") ; --UNCHK
lin demodulation_N = mkWN "demodulaatio" ; --UNCHK
lin demographer_N = mkWN (k5 "demografi") ; --UNCHK
lin demographic_A = mkWA (k38 "demografinen") ; --UNCHK
lin demographic_N = mkWN (compoundN "väestö" (k2 "tilasto")) ; --UNCHK
lin demography_N = mkWN (k12 "demografia") ; --UNCHK
lin demolish_V2 = mkWV2 (k71 "tehdä") "loppu" ; --UNCHK
lin demolition_N = mkWN (compoundN "romu" (k38 "ttaminen")) ; --UNCHK
lin demon_N = mkWN (k5 "demoni") ;
lin demonetization_N = mkWN (compoundN "demonetari" (k5A "sointi")) ; --UNCHK
lin demonetize_V2 = mkWV2 (compoundV "demoneti" (k62 "soida")) ; --UNCHK
lin demoniac_A = mkWA (k1 "hullu") ; --UNCHK
lin demoniac_N = mkWN (k1A "riivattu") ; --UNCHK
lin demoniacal_A = mkWA (k1 "hullu") ; --UNCHK
lin demonic_A = mkWA (k34A "jumalaton") ; --UNCHK
lin demonization_N = mkWN (compoundN "demoni" (k5A "sointi")) ; --UNCHK
lin demonize_V2 = mkWV2 (k53A "muuttaa") "paholaiseksi" ; --UNCHK
lin demonstrability_N = mkWN "todistettavuus" ; --UNCHK
lin demonstrable_A = mkWA (k34A "kiistämätön") ; --UNCHK
lin demonstrate_V = mkV (mkV "osoittaa") "mieltä" ;
lin demonstrate_V2 = mkWV2 (k53 "havainnollistaa") ;
lin demonstrate_VS = mkWVS (k53 "vahvistaa") ; --UNCHK
lin demonstration_N = mkN "demonstraatio" ;
lin demonstrative_A = mkWA (k33 "avoin") ; --UNCHK
lin demonstrativeness_N = mkWN (k40 "avoimuus") ; --UNCHK
lin demonstrator_N = mkWN (compoundN "mielen" (k10 "osoittaja")) ; --UNCHK
lin demoralization_N = mkWN (k5A "demoralisointi") ; --UNCHK
lin demoralize_V2 = mkWV2 (k62 "demoralisoida") ; --UNCHK
lin demoralizing_A = mkWA (k10 "masentava") ; --UNCHK
lin demote_V2 = mkWV2 (k66 "potkaista") "alas" ; --UNCHK
lin demotic_A = mkWA (k38 "arkinen") ; --UNCHK
lin demotion_N = mkWN (compoundN "arvon" (k39 "alennus")) ; --UNCHK
lin demulcent_A = mkWA "rauhoittava" ; --UNCHK
lin demulcent_N = mkWN (k48A "lääke") "ärsytystä" "lievittävä" ; --UNCHK
lin demur_N = mkWN (k48A "väite") ; --UNCHK
lin demur_V = mkWV (k53A "esittää") "vastalause" ; --UNCHK
lin demur_VS = mkWVS (k53A "esittää") "vastalause" ; --UNCHK
lin demure_A = mkWA (k1 "kaino") ; --UNCHK
lin demureness_N = mkWN (k40 "siveys") "teennäinen" ; --UNCHK
lin demurrage_N = mkWN (compoundN "lisä" (k9A "seisonta-aika")) ; --UNCHK
lin demurrer_N = mkWN (k39 "puolustus") ; --UNCHK
lin demyelination_N = mkWN "demyelinaatio" ; --UNCHK
lin demythologization_N = mkWN (compoundN "demytologi" (k5A "sointi")) ; --UNCHK
lin demythologized_A = mkWA (compoundA "demytologiso" (k1A "itu")) ; --UNCHK
lin den_N = mkWN (k7A "soppi") "rauhallinen" ; --UNCHK
lin denain_PN = foreignPN "Denain" ;
lin denary_A = mkWA "desimaali-" ; --UNCHK
lin denationalization_N = mkWN (compoundN "yks" (k38 "ityistäminen")) ; --UNCHK
lin denationalize_V2 = mkWV2 (k53 "yksityistää") ; --UNCHK
lin denaturant_N = mkWN (compoundN "denaturoimis" (k48 "aine")) ; --UNCHK
lin denatured_A = mkWA (compoundA "denaturo" (k1A "itu")) ; --UNCHK
lin denazification_N = mkWN "natsilaisuuden" "hävittäminen" ; --UNCHK
lin denbigh_PN = foreignPN "Denbigh" ;
lin dendrite_N = mkWN (compoundN "tuoja" (k48A "haarake")) ; --UNCHK
lin dendritic_A = mkWA "dendriittinen" ; --UNCHK
lin dendrobium_N = mkWN "Dendrobium" ; --UNCHK
lin dengue_N = mkWN (compoundN "dengue-verenvuoto" (k48 "kuume")) ; --UNCHK
lin deniable_A = mkWA (k10 "oleva") "kiellettävissä" ; --UNCHK
lin denial_N = mkWN (k39 "kieltäymys") ; --UNCHK
lin denier_N = mkWN (k10 "kieltäjä") ; --UNCHK
lin denigrate_V2 = mkWV2 (k73A "liata") ; --UNCHK
lin denigration_N = mkWN (k9A "paheksunta") ; --UNCHK
lin denim_N = mkWN (k41A "farkkukangas") ; --UNCHK
lin denizen_N = mkN "asukas" ;
lin denmark_PN = foreignPN "Tanska" ;
lin dennis_PN = foreignPN "Dennis" ;
lin denny_PN = foreignPN "Denny" ;
lin denominate_V2 = mkWV2 (k75 "nimetä") ; --UNCHK
lin denomination_N = mkWN (k39 "nimitys") ; --UNCHK
lin denominationalism_N = mkWN (k40 "lahkolaisuus") ; --UNCHK
lin denominator_N = mkWN (k10 "nimittäjä") ; --UNCHK
lin denotative_A = mkWA "osoittava" ; --UNCHK
lin denotatum_N = mkWN "denotaatio" ; --UNCHK
lin denote_V2 = mkWV2 (k53A "tarkoittaa") ; --UNCHK
lin denouement_N = mkWN (compoundN "loppu" (k2 "ratkaisu")) ; --UNCHK
lin denounce_V2 = mkWV2 (k62 "kritisoida") ; --UNCHK
lin dense_A = mkWA (k38 "idioottimainen") ; --UNCHK
lin denseness_N = mkWN (k40 "tiiviys") ; --UNCHK
lin densimeter_N = mkWN (compoundN "tiheys" (k6 "mittari")) ; --UNCHK
lin densitometer_N = mkWN (compoundN "tiheys" (k6 "mittari")) ; --UNCHK
lin densitometry_N = mkWN "densitometria" ; --UNCHK
lin density_N = mkWN (k40 "tiiviys") ; --UNCHK
lin dent_N = mkWN (k1 "naarmu") ; --UNCHK
lin dent_V = mkWV (k71 "tehdä") "lommo" ; --UNCHK
lin dent_V2 = mkWV2 (k71 "tehdä") "lommo" ; --UNCHK
lin dental_A = mkWA "hammas-" ; --UNCHK
lin dentate_A = mkWA (compoundA "saha" (k38 "laitainen")) ; --UNCHK
lin denticle_N = mkWN (k10A "pykä") ; --UNCHK
lin denticulate_A = mkWA (compoundA "nirha" (k38 "laitainen")) ; --UNCHK
lin dentifrice_N = mkWN (compoundN "hammas" (k9 "tahna")) ; --UNCHK
lin dentine_N = mkWN (compoundN "hammas" (k18 "luu")) ; --UNCHK
lin dentist_N = mkWN (compoundN "hammas" (k6 "lääkäri")) ; --UNCHK
lin dentistry_N = mkWN (k12 "odontologia") ; --UNCHK
lin dentition_N = mkWN (k1 "hampaisto") ; --UNCHK
lin denture_N = mkWN (compoundN "hammas" (k6 "proteesi")) ; --UNCHK
lin denudation_N = mkWN (compoundN "paljas" (k38 "taminen")) ; --UNCHK
lin denude_V2 = mkWV2 (k73A "hakata") "paljaaksi" ; --UNCHK
lin denunciation_N = mkWN (k9A "paheksunta") "julkinen" ; --UNCHK
lin denver_PN = foreignPN "Denver" ;
lin deny_V2 = mkWV2 (k53 "kiistää") ; --f84
lin deny_V3 = mkWV3 (k53 "kiistää") ; --UNCHK
lin deodar_N = mkWN (compoundN "himalajan" (k5 "setri")) ; --UNCHK
lin deodorant_N = mkWN (k5A "deodorantti") ; --UNCHK
lin deodorize_V2 = mkWV2 (k53 "poistaa") "haju" ; --UNCHK
lin deossification_N = mkWN (compoundN "luu" (k1A "kato")) ; --UNCHK
lin deoxyadenosine_N = mkWN "deoksiadenosiini" ; --UNCHK
lin deoxycytidine_N = mkWN "deoksisytidiini" ; --UNCHK
lin deoxyguanosine_N = mkWN "deoksiguanosiini" ; --UNCHK
lin deoxyribose_N = mkWN "deoksiriboosi" ; --UNCHK
lin deoxythymidine_N = mkWN "tymidiini" ; --UNCHK
lin depart_V = mkWV (k52 "poistua") ;
lin departed_N = mkWN (k39 "vapautus") ; --UNCHK
lin departer_N = mkWN (k12 "lähtijä") ; --UNCHK
lin department_N = mkN "osasto" | mkN "laitos" ; ---- split
lin departmental_A = mkWA "osaston" ; --UNCHK
lin departure_N = mkN "lähtö" ;
lin depend_V = mkV "riippua" ;
lin dependability_N = mkWN (k40 "luotettavuus") ; --UNCHK
lin dependable_A = mkWA (k10 "luotettava") ; --UNCHK
lin dependant_N = mkWN (k10 "oleva") "riippuvuussuhteessa" ; --UNCHK
lin dependence_N = mkWN (k40 "riippuvuus") ;
lin dependency_N = mkWN (compoundN "alus" (k18 "maa")) ; --UNCHK
lin dependent_A = mkWA (k10 "oleva") "riippuvuussuhteessa" ; --UNCHK
lin dependent_N = mkWN (k10 "oleva") "riippuvuussuhteessa" ; --UNCHK
lin depending_A = variants {} ; --
lin depersonalization_N = mkWN "yksilöllisyyden" "riistäminen" ; --UNCHK
lin depict_V2 = mkWV2 (k53A "hahmottaa") ; --UNCHK
lin depicting_N = mkWN (k10 "kuva") ; --UNCHK
lin depiction_N = mkWN (k10 "kuva") ; --UNCHK
lin depigmentation_N = mkWN (compoundN "pigmentin" (k1A "kato")) ; --UNCHK
lin depilation_N = mkWN (compoundN "karvan" (k1 "poisto")) ; --UNCHK
lin depilatory_A = mkWA "ihokarvoja" "poistava" ; --UNCHK
lin depilatory_N = mkWN (compoundN "karvanpoisto" (k48 "aine")) ; --UNCHK
lin depilous_A = mkWA "karvaton" ; --UNCHK
lin deplane_V = mkWV (k66 "nousta") "lentokoneesta" ; --UNCHK
lin depletable_A = mkWA (k10 "oleva") "hävitettävissä" ; --UNCHK
lin deplete_V2 = mkWV2 (k53A "kuluttaa") "loppuun" ; --UNCHK
lin depletion_N = mkWN "tyhjentäminen" ;
lin deplorable_A = mkWA (k38 "surullinen") ; --UNCHK
lin deplore_V2 = mkWV2 (k52 "paheksua") ; --UNCHK
lin deploy_V = mkWV (k53A "sijoittaa") ; --UNCHK
lin deploy_V2 = mkWV2 (k53A "sijoittaa") ; --UNCHK
lin deployment_N = mkWN (k2 "asettelu") "joukkojen" ; --UNCHK
lin depolarization_N = mkWN "depolarisaatio" ; --UNCHK
lin deponent_N = mkWN (k10 "todistaja") ; --UNCHK
lin depopulate_V2 = mkWV2 (k53A "hävittää") "asukkaat" ; --UNCHK
lin depopulation_N = mkWN (compoundN "autio" (k38 "ituminen")) ; --UNCHK
lin deport_V2 = mkWV2 (k53A "karkottaa") ; --UNCHK
lin deportation_N = mkWN (k39 "karkotus") ; --UNCHK
lin deportee_N = mkWN (k2 "henkilö") "karkotettu" ; --UNCHK
lin deportment_N = mkWN (k9A "toiminta") ; --UNCHK
lin depose_V = mkWV (k53 "todistaa") "valaehtoisesti" ; --UNCHK
lin depose_V2 = mkWV2 (k53 "todistaa") "valaehtoisesti" ; --UNCHK
lin deposit_N = mkN "takuusumma" ; ---??
lin deposit_V2 = mkWV2 (k56A "laittaa") ; --UNCHK
lin deposition_N = mkWN (compoundN "viralta" (k1 "pano")) ; --UNCHK
lin depositor_N = mkWN (k10 "tallettaja") ; --UNCHK
lin depository_N = mkN (lin NK {s = d02 "varasto"}) ;
lin depot_N = mkWN (k2 "varasto") ; --UNCHK
lin deprave_V2 = mkWV2 (k53A "johtaa") "harhaan" ; --UNCHK
lin depravity_N = mkWN (k40 "halpamaisuus") ; --UNCHK
lin deprecate_V2 = mkWV2 (k67A "kohdella") "halveksivasti" ; --UNCHK
lin deprecation_N = mkWN (k9A "paheksunta") ; --UNCHK
lin deprecative_A = mkWA "paheksuva" ; --UNCHK
lin depreciate_V = mkWV (k52A "devalvoitua") ; --UNCHK
lin depreciate_V2 = mkWV2 (k52A "devalvoitua") ; --UNCHK
lin depreciation_N = mkWN (k1 "lasku") "arvon" ; --UNCHK
lin depreciatory_A = mkWA (compoundA "halveks" (k9 "iva")) ; --UNCHK
lin depredation_N = mkWN (compoundN "rosvo" (k38 "aminen")) ; --UNCHK
lin depress_V2 = mkV2 (mkV (mkV "painaa") "alaspäin") ;
lin depressant_A = mkWA "ruumiintoimintoja" "hidastava" ; --UNCHK
lin depressed_A = variants {} ; --
lin depressing_A = mkWA (k34A "iloton") ; --UNCHK
lin depression_N = mkWN (compoundN "pai" (k38 "naminen")) ; --UNCHK
lin depressor_N = mkWN (k48A "laite") "alas" "painava" ; --UNCHK
lin deprivation_N = mkWN (k48A "puute") ; --UNCHK
lin deprive_V2 = mkWV2 (k53A "köyhdyttää") ; --UNCHK
lin depth_N = mkWN (k40 "syvyys") ;
lin depth_bomb_N = mkWN (k5 "syvyyspommi") ; --UNCHK
lin depth_charge_N = mkWN (k5 "syvyyspommi") ; --UNCHK
lin deputation_N = mkWN "valtuuttaminen" ; --UNCHK
lin depute_V2 = mkWV2 (k73 "määrätä") "tehtävään" ; --UNCHK
lin deputize_V = mkWV (k73 "määrätä") "sijaiseksi" ; --UNCHK
lin deputy_N = mkN "sijainen" ;
lin derail_V2 = mkWV2 (k52 "suistua") "[raiteilta]" ; --UNCHK
lin derailment_N = mkWN "raiteilta" "suistuminen" ; --UNCHK
lin derange_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin derangement_N = mkWN (k39 "järkytys") ; --UNCHK
lin derby_N = mkWN (k5 "knalli") ; --UNCHK
lin derby_PN = foreignPN "Derby" ;
lin deregulate_V2 = mkWV2 (k53 "poistaa") "sääntely" ; --UNCHK
lin deregulation_N = mkWN (compoundN "pois" (k38 "taminen")) "sääntelyn" ; --UNCHK
lin derelict_A = mkWA (k38 "rähjäinen") ; --UNCHK
lin derelict_N = mkWN (k1A "hylky") ; --UNCHK
lin dereliction_N = mkWN (compoundN "laimin" (k5A "lyönti")) ; --UNCHK
lin derestrict_V2 = mkWV2 (k53 "poistaa") "rajoitukset" ; --UNCHK
lin deride_V2 = mkWV2 (k73A "pilkata") ; --UNCHK
lin derision_N = mkWN (kH1 "pilkka") ; --UNCHK
lin derisive_A = mkWA (k38 "pilkallinen") ; --UNCHK
lin derisory_A = mkWA (k34A "posketon") ; --UNCHK
lin derivable_A = mkWA (k10 "oleva") "johdettavissa" ; --UNCHK
lin derivation_N = mkWN "johtuminen" ; --UNCHK
lin derivational_A = mkWA (compoundA "johde" (k1 "ttu")) ; --UNCHK
lin derivative_A = mkWA (compoundA "johde" (k1 "ttu")) ; --UNCHK
lin derivative_N = mkWN (k9A "derivaatta") ; --UNCHK
lin derive_V = mkWV (k52A "kehittyä") ; --UNCHK
lin derive_V2 = mkV2 "johtaa" ;
lin dermabrasion_N = mkWN (k9A "hionta") "ihon" ; --UNCHK
lin dermal_A = mkWA (compoundA "kuta" (k38 "aninen")) ; --UNCHK
lin dermatitis_N = mkWN (k10 "ihottuma") ; --UNCHK
lin dermatoglyphic_N = mkWN (compoundN "iho" (k9 "piena")) ; --UNCHK
lin dermatoglyphics_N = mkWN (k39 "tutkimus") "ihopienojen" ; --UNCHK
lin dermatologic_A = mkWA "ihotauti-" ; --UNCHK
lin dermatologistFem_N = variants {} ; ---- sense to be split
lin dermatologistMasc_N = mkWN (compoundN "ihotauti" (k6 "lääkäri")) ; --UNCHK
lin dermatology_N = mkWN (k12 "dermatologia") ; --UNCHK
lin dermatome_N = mkWN (compoundN "ihonsiirto" (k48 "koje")) ; --UNCHK
lin dermatomycosis_N = mkWN "dermatofytoosi" ; --UNCHK
lin dermatomyositis_N = mkWN "dermatomyosiitti" ; --UNCHK
lin dermatosis_N = mkWN (compoundN "iho" (k5A "tauti")) ; --UNCHK
lin dermis_N = mkWN (compoundN "veri" (k9 "nahka")) ; --UNCHK
lin derogate_V = mkWV (k54A "halventaa") ; --UNCHK
lin derogation_N = mkWN (k39 "poikkeus") ; --UNCHK
lin derogative_A = mkWA (compoundA "halveks" (k9 "iva")) ; --UNCHK
lin derogatory_A = mkWA (compoundA "halveks" (k9 "iva")) ; --UNCHK
lin derrick_N = mkWN (k6 "nosturi") ; --UNCHK
lin derringer_N = mkWN (compoundN "tasku" (k6 "pistooli")) ; --UNCHK
lin derris_N = mkWN "Derris" ; --UNCHK
lin derv_N = mkWN (compoundN "diesel" (k1 "öljy")) ; --UNCHK
lin dervish_N = mkWN (compoundN "der" (k5 "vissi")) ; --UNCHK
lin des_N = mkWN "DES" ; --UNCHK
lin desalinate_V2 = mkWV2 (k53 "poistaa") "suola" ; --UNCHK
lin desalination_N = mkWN (compoundN "suolan" (k1 "poisto")) ; --UNCHK
lin desalinization_N = mkWN (compoundN "suolan" (k1 "poisto")) ; --UNCHK
lin desalinize_V2 = mkWV2 (k53 "poistaa") "suola" ; --UNCHK
lin desalt_V2 = mkWV2 (k53 "poistaa") "suola" ; --UNCHK
lin descale_V2 = mkWV2 (k53 "suomustaa") ; --UNCHK
lin descant_N = mkWN (k39 "säestys") "improvisoitu" ; --UNCHK
lin descend_V = mkWV (k52A "laskeutua") ; --UNCHK
lin descend_V2 = mkWV2 (k52A "laskeutua") ; --UNCHK
lin descendant_A = mkWA "periytyvä" ; --UNCHK
lin descendant_N = mkWN (k29 "lapsi") ; --UNCHK
lin descender_N = mkWN (compoundN "ala" (k14A "silmukka")) ; --UNCHK
lin descent_N = mkWN (k1 "lasku") ; --UNCHK
lin describable_A = mkWA (k10 "oleva") "kuvattavissa" ; --UNCHK
lin describe_V2 = mkV2 (mkV "kuvailla") partitive ;
lin describe_VS = mkVS (mkV "kuvailla") ;
lin description_N = mkWN (k5 "laji") ; --UNCHK
lin descriptive_A = mkWA (k38 "deskriptiivinen") ; --UNCHK
lin descriptivism_N = mkWN (compoundN "deskriptiv" (k5 "ismi")) ; --UNCHK
lin descriptor_N = mkWN "määrittelijä" ; --UNCHK
lin descry_V2 = mkWV2 (k73 "bongata") ; --UNCHK
lin desecrate_V2 = mkWV2 (k62 "sekularisoida") ; --UNCHK
lin desecration_N = mkWN (k39 "häväistys") ; --UNCHK
lin desegrated_A = mkWA "ilman" "rotuerottelua" ; --UNCHK
lin desegregate_V2 = mkWV2 (k53 "yhdistää") ; --UNCHK
lin desegregation_N = mkWN (k3 "integraatio") ; --UNCHK
lin desensitization_N = mkWN "siedättäminen" ; --UNCHK
lin desensitize_V2 = mkWV2 (k53A "turruttaa") ; --UNCHK
lin desensitizing_A = mkWA (k10 "tekevä") "tunnottomaksi" ; --UNCHK
lin desert_N = mkWN (k4A "aavikko") ; --UNCHK
lin desert_V = mkWV (k53A "jättää") "heitteille" ; --UNCHK
lin desert_V2 = mkWV2 (k53A "jättää") "heitteille" ; --UNCHK
lin deserter_N = mkWN (k6 "loikkari") ; --UNCHK
lin desertification_N = mkWN "aavikoituminen" ; --UNCHK
lin desertion_N = mkWN "hylkääminen" ; --UNCHK
lin deserts_N = mkWN (k39 "seuraus") "ansaittu" ; --UNCHK
lin deserve_V = mkWV (k69 "ansaita") ; --UNCHK
lin deserve_V2 = mkWV2 (k69 "ansaita") ; --UNCHK
lin deserve_VV = mkWVV (k69 "ansaita") ; --UNCHK
lin deservedly_Adv = mkWAdv (k99 "ansaitusti") ; --UNCHK
lin deservingness_N = mkWN (k3 "ansio") ; --UNCHK
lin deshabille_N = mkWN (k99 "puolipukeissa") ; --UNCHK
lin desiccant_N = mkWN (k5 "sikkatiivi") ; --UNCHK
lin desiccate_V2 = mkWV2 (k52 "kuivua") ; --UNCHK
lin desideratum_N = mkWN (k48 "toive") ; --UNCHK
lin design_N = mkN "muotoilu" | mkN "design" "designin" "designia" "designina" "designiin" "designien" "designeja" "designeina" "designeissa" "designeihin" ;
lin design_V = mkV "muotoilla" ;
lin design_V2 = mkV2 "muotoilla" ;
lin designate_A = mkWA (compoundA "nimi" (k1 "tetty")) "tehtävään" ; --UNCHK
lin designate_V = mkWV (k54A "täsmentää") ; --UNCHK
lin designate_V2 = mkV2 "nimittää" ; --mkWV2 (k54A "täsmentää") ;
lin designate_V2V = mkV2V (mkV "osoittaa") accusative infIness ; --mkWV2V (k54A "täsmentää")
lin designate_VS = mkWVS (k54A "täsmentää") ; --UNCHK
lin designation_N = mkN (lin NK {s = d39 "nimitys"}) ;
lin designative_A = mkWA "osoittava" ; --UNCHK
lin designatum_N = mkWN (k48A "kohde") "nimeämisen" ; --UNCHK
lin designedly_Adv = mkWAdv (k99 "vasten") "varta" ; --UNCHK
lin designer_N = mkWN (k12 "suunnittelija") ; --UNCHK
lin designing_N = mkWN (compoundN "suu" (k38 "nnitteleminen")) ; --UNCHK
lin desipramine_N = mkWN "desipramiini" ; --UNCHK
lin desirability_N = mkWN (k40 "seksikkyys") ; --UNCHK
lin desirable_A = mkWA (k10 "toivottava") ;
lin desire_N = mkWN (k1 "himo") ;
lin desire_V2 = mkV2 "haluta" partitive ; --mkWV2 (k61 "mieliä") ;
lin desired_A = mkA "haluttu" ;
lin desirous_A = mkWA (k41A "toiveikas") ; --UNCHK
lin desist_V = mkWV (k52A "pidättäytyä") ; --UNCHK
lin desk_N = mkWN (compoundN "työ" (k10A "pöytä")) ;
lin desktop_N = mkWN (k9 "tausta") ; --UNCHK
lin desmid_N = mkWN (compoundN "koru" (k10 "levä")) ; --UNCHK
lin desolate_A = mkWA (k34A "lohduton") ; --UNCHK
lin desolate_V2 = mkWV2 (k53 "kylvää") "tuhoa" ; --UNCHK
lin desolation_N = mkWN (k39 "hävitys") ; --UNCHK
lin desorption_N = mkWN "desorptio" ; --UNCHK
lin despair_N = mkWN (compoundN "epä" (k1 "toivo")) ; --UNCHK
lin despair_V = mkWV (k53A "menettää") "toivonsa" ; --UNCHK
lin despairingly_Adv = mkWAdv (k99 "toivottomasti") ; --UNCHK
lin despatch_N = mkWN (k39 "toimitus") ; --UNCHK
lin desperate_A = mkA "epätoivoinen" ;
lin desperate_N = mkWN (k38 "ihminen") "epätoivoinen" ; --UNCHK
lin desperation_N = mkWN (k40 "rämäpäisyys") ; --UNCHK
lin despicable_A = mkWA (k10 "katala") ; --UNCHK
lin despisal_N = mkWN (k10A "halveksunta") ; --UNCHK
lin despise_V2 = mkWV2 (k52 "halveksua") ; --UNCHK
lin despite_N = mkWN (k10A "halveksunta") ; --UNCHK
lin despite_Prep = postPrep elative "huolimatta" ;
lin despiteful_A = mkWA (k15 "ilkeä") ; --UNCHK
lin despoil_V2 = mkWV2 (k73 "ryövätä") ; --UNCHK
lin despondency_N = mkWN (k40 "lohduttomuus") ; --UNCHK
lin despondent_A = mkWA (k38 "epätoivoinen") ; --UNCHK
lin despot_N = mkWN (k5A "despootti") ; --UNCHK
lin despotic_A = mkWA (k38 "despoottinen") ; --UNCHK
lin despotism_N = mkWN (k12 "tyrannia") ; --UNCHK
lin desquamation_N = mkWN (k2 "hilseily") ; --UNCHK
lin dessau_PN = foreignPN "Dessau" ;
lin dessert_N = mkWN (compoundN "jälki" (k10A "ruoka")) ; --UNCHK
lin dessertspoon_N = mkWN (compoundN "jälkiruoka" (k38 "lusikallinen")) ; --UNCHK
lin dessertspoonful_N = mkWN (compoundN "jälkiruoka" (k38 "lusikallinen")) ; --UNCHK
lin dessiatine_N = mkWN "desjatiina" ; --UNCHK
lin destabilization_N = mkWN "horjuttaminen" ; --UNCHK
lin destalinization_N = mkWN (compoundN "destalini" (k5A "sointi")) ; --UNCHK
lin destination_N = mkWN (k48A "tavoite") ;
lin destine_V2 = mkWV2 (k54A "täsmentää") ; --UNCHK
lin destine_V2V = mkWV2V (k54A "täsmentää") ; --UNCHK
lin destiny_N = mkWN (k2 "kohtalo") ; --UNCHK
lin destitute_A = mkWA (k99 "ilman") ; --UNCHK
lin destitution_N = mkWN (k40 "varattomuus") ; --UNCHK
lin destroy_V2 = mkV2 "hävittää" ;
lin destroyable_A = mkWA (k10 "oleva") "tuhottavissa" ; --UNCHK
lin destroyer_N = mkWN (k10 "hävittäjä") ; --UNCHK
lin destructibility_N = mkWN "hävitettävyys" ; --UNCHK
lin destruction_N = mkWN (compoundN "tuho" (k38 "aminen")) ; --UNCHK
lin destructive_A = mkWA (k10 "tuhoisa") ; --UNCHK
lin destructiveness_N = mkWN (k40 "tuhoisuus") ; --UNCHK
lin desuetude_N = mkWN "käyttämättömyys" ; --UNCHK
lin desultory_A = mkWA "hyppelehtivä" ; --UNCHK
lin detach_V2 = mkWV2 (k53A "irrottaa") ; --UNCHK
lin detachable_A = mkWA "irrotettava" ; --UNCHK
lin detachment_N = mkWN (compoundN "ero" (k38 "ttaminen")) ; --UNCHK
lin detail_N = mkN "yksityiskohta" ;
lin detail_V2 = mkV2 "eritellä" ;
lin detailed_A = mkA "yksityiskohtainen" ;
lin details_N = mkWN (k1A "tieto") "sisäpiirin" ; --UNCHK
lin detain_V2 = mkWV2 (k53A "viivästyttää") ; --UNCHK
lin detainee_N = mkWN (k5A "vanki") "poliittinen" ; --UNCHK
lin detect_V2 = mkWV2 (k73 "huomata") ; --UNCHK
lin detectable_A = mkWA (k10 "oleva") "havaittavissa" ; --UNCHK
lin detection_N = mkWN "löytäminen" ; --UNCHK
lin detective_N = mkWN (k10 "etsivä") ;
lin detector_N = mkWN (k33 "aistin") ; --UNCHK
lin detente_N = mkWN (k39 "liennytys") ; --UNCHK
lin detention_N = mkWN (compoundN "jälki-" (k1A "istunto")) ; --UNCHK
lin deter_V2 = mkWV2 (k63 "saada") "luopumaan" ; --UNCHK
lin detergency_N = mkWN (compoundN "puhdistus" (k1A "kyky")) ; --UNCHK
lin detergent_A = mkWA "puhdistava" ; --UNCHK
lin detergent_N = mkWN (compoundN "pesu" (k48 "aine")) ; --UNCHK
lin deteriorate_V = mkWV (k72A "heiketä") ; --UNCHK
lin deteriorate_V2 = mkWV2 (k72A "heiketä") ; --UNCHK
lin deterioration_N = mkWN (k3 "rappio") ; --UNCHK
lin determent_N = mkWN (k2 "uhkailu") ; --UNCHK
lin determinable_A = mkWA (k10 "oleva") "rajattavissa" ; --UNCHK
lin determinant_A = mkWA (k10 "ratkaiseva") ; --UNCHK
lin determinant_N = mkWN (k12 "tekijä") "syynä" "oleva" ; --UNCHK
lin determinate_A = mkWA (k1A "määrätty") ; --UNCHK
lin determinateness_N = mkWN (k40 "ehdottomuus") ; --UNCHK
lin determination_N = mkN "päättäväisyys" ;
lin determinative_A = mkWA (k10 "ratkaiseva") ; --UNCHK
lin determinative_N = mkWN (k12 "tekijä") "syynä" "oleva" ; --UNCHK
lin determine_V = mkV "määrätä" | mkV "päättää" ;
lin determine_V2 = mkV2 "päättää" | mkV2 "määrätä" ;
lin determine_V2V = mkV2V (mkV "päättää") genitive infPresPart ;
lin determine_VS = mkVS (mkV "päättää") ;
lin determine_VV = mkVV "päättää" ;
lin determined_A = variants {} ; --
lin determiner_N = mkWN (k12 "tekijä") "syynä" "oleva" ; --UNCHK
lin determinism_N = mkWN (k5 "determinismi") ; --UNCHK
lin deterministic_A = mkWA (k38 "deterministinen") ; --UNCHK
lin deterrence_N = mkWN (k2 "pelottelu") ; --UNCHK
lin deterrent_A = mkWA "estävä" ; --UNCHK
lin deterrent_N = mkWN (k48A "rasite") ; --UNCHK
lin detest_V2 = mkWV2 (k74 "inhota") ; --UNCHK
lin detestable_A = mkWA (k15 "kauhea") ; --UNCHK
lin detestation_N = mkWN (k39 "iljetys") ; --UNCHK
lin dethrone_V2 = mkWV2 (k70 "syöstä") "vallasta" ; --UNCHK
lin dethronement_N = mkWN (compoundN "viralta" (k1 "pano")) ; --UNCHK
lin detonate_V = mkWV (k53A "pamahtaa") ; --UNCHK
lin detonate_V2 = mkWV2 (k53A "pamahtaa") ; --UNCHK
lin detonation_N = mkWN "räjäyttäminen" ; --UNCHK
lin detonative_A = mkWA "räjähtävä" ; --UNCHK
lin detonator_N = mkWN (k33A "sytytin") ; --UNCHK
lin detour_N = mkWN (compoundN "kierto" (k19 "tie")) ; --UNCHK
lin detour_V2 = mkWV2 (k53A "käyttää") "kiertotietä" ; --UNCHK
lin detox_N = mkWN (compoundN "päihde" (k2 "osasto")) ; --UNCHK
lin detoxification_N = mkWN (compoundN "pois" (k38 "taminen")) "myrkyn" ; --UNCHK
lin detract_V = mkWV (k54A "vähentää") ; --UNCHK
lin detraction_N = mkWN (k39 "parjaus") ; --UNCHK
lin detractive_A = mkWA "vähentävä" ; --UNCHK
lin detractor_N = mkWN (k12 "panettelija") ; --UNCHK
lin detrain_V = mkWV (k66 "nousta") "junasta" ; --UNCHK
lin detrain_V2 = mkWV2 (k66 "nousta") "junasta" ; --UNCHK
lin detribalization_N = mkWN "heimojärjestelmän" "hajoaminen" ; --UNCHK
lin detribalize_V2 = mkWV2 (k53A "hävittää") "heimoidentiteetti" ; --UNCHK
lin detriment_N = mkWN (k9A "haitta") ; --UNCHK
lin detrimental_A = mkWA (k38 "haitallinen") ; --UNCHK
lin detritus_N = mkWN "detritus" ; --UNCHK
lin detroit_PN = foreignPN "Detroit" ;
lin detumescence_N = mkWN (compoundN "lie" (k38 "veneminen")) "turvotuksen" ; --UNCHK
lin deuce_N = mkWN (k38 "kakkonen") ; --UNCHK
lin deuced_A = mkWA (k38 "pirunmoinen") ; --UNCHK
lin deuteranopia_N = mkWN (compoundN "viher" (k40 "sokeus")) ; --UNCHK
lin deuteranopic_A = mkWA (compoundA "viher" (k15 "sokea")) ; --UNCHK
lin deuterium_N = mkWN (k1A "vety") "raskas" ; --UNCHK
lin deuteron_N = mkWN "deuteroni" ; --UNCHK
lin deutschmark_N = mkWN (k9A "markka") "Saksan" ; --UNCHK
lin deutzia_N = mkWN (compoundN "nietos" (k41 "pensas")) ; --UNCHK
lin devaluate_V2 = mkWV2 (k52A "devalvoitua") ; --UNCHK
lin devaluation_N = mkN "devalvaatio" ; --WN (compoundN "ale" (k38 "neminen")) "arvon" ;
lin devalue_V2 = mkWV2 (k52A "devalvoitua") ; --UNCHK
lin devastate_V2 = mkV2 "musertaa" ; --mkWV2 (k52A "musertua") ;
lin devastation_N = mkN "tuho" ; --mkWN (compoundN "tuho" (k38 "aminen")) ;
lin develop_V = mkV "kehittyä" ;
lin develop_V2 = mkV2 "kehittää" ;
lin developed_A = mkA "kehittynyt" ;
lin developer_N = mkN "kehittäjä" ;
lin developing_A = mkA "kehittyvä" ;
lin development_N = mkN "kehitys" ;
lin developmental_A = mkWA "kehitys-" ; --UNCHK
lin deviant_A = mkWA (k10 "poikkeava") ; --UNCHK
lin deviant_N = mkWN (k1 "pervo") ; --UNCHK
lin deviate_V = mkWV (k52A "kääntyä") "toisaalle" ; --UNCHK
lin deviation_N = mkN "poikkeama" ; --mkWN (compoundN "kierto" (k19 "tie")) ;
lin deviationist_N = mkWN (compoundN "toisin" (k12 "ajattelija")) ; --UNCHK
lin device_N = mkN "laite" ;
lin devil_N = mkWN (k48 "perkele") ; --UNCHK
lin devil_V = mkWV (k56 "maustaa") "voimakkaasti" ; --UNCHK
lin devil_V2 = mkWV2 (k56 "maustaa") "voimakkaasti" ; --UNCHK
lin devilish_A = mkWA (k38 "saatanallinen") ; --UNCHK
lin devilish_Adv = mkWAdv (compoundAdv "pahuk" (k99 "sen")) ; --UNCHK
lin devilment_N = mkWN (k10 "jäynä") ; --UNCHK
lin devilry_N = mkWN (k10 "jäynä") ; --UNCHK
lin deviltry_N = mkWN (k10 "jäynä") ; --UNCHK
lin devilwood_N = mkWN (compoundN "tuoksu" (k41 "pensas")) ; --UNCHK
lin devious_A = mkWA (k10 "poikkeava") ; --UNCHK
lin deviousness_N = mkWN (k40 "kieroutuneisuus") ; --UNCHK
lin devisal_N = mkWN (compoundN "keksi" (k38 "minen")) ; --UNCHK
lin devise_N = mkWN (k39 "testamenttaus") ; --UNCHK
lin devise_V2 = mkV2 "keksiä" ; --WV2 (k73A "kekata") ;
lin devisee_N = mkWN (compoundN "testamentin" (k10 "saaja")) ; --UNCHK
lin devising_N = mkWN (k1A "tuotanto") ; --UNCHK
lin devisor_N = mkWN (k12 "tekijä") "testamentin" ; --UNCHK
lin devitalization_N = mkWN "näivettäminen" ; --UNCHK
lin devitalize_V2 = mkWV2 (k54A "heikentää") ; --UNCHK
lin devizes_PN = foreignPN "Devizes" ;
lin devoid_A = mkWA (k99 "ilman") ; --UNCHK
lin devoir_N = mkWN (compoundN "kohteliaisuuden" (k39 "osoitus")) ; --UNCHK
lin devolution_N = mkWN (k1A "siirto") "tehtävien" ; --UNCHK
lin devolve_V = mkWV (k72A "heiketä") ; --UNCHK
lin devolve_V2 = mkWV2 (k72A "heiketä") ; --UNCHK
lin devon_PN = foreignPN "Devon" ;
lin devote_V2 = mkV2 "omistaa" ;
lin devoted_A = variants {} ; --
lin devotee_N = mkWN (k5A "friikki") ; --UNCHK
lin devotion_N = mkWN (compoundN "hartauden" (k39 "harjoitus")) ; --UNCHK
lin devotional_A = mkWA (k41A "harras") ; --UNCHK
lin devotional_N = mkWN (compoundN "hartaus" (k7 "hetki")) ; --UNCHK
lin devour_V2 = mkWV2 (k64 "syödä") ; --UNCHK
lin devourer_N = mkWN (k5A "ahmatti") ; --UNCHK
lin devout_A = mkWA (k10 "jumalaapelkäävä") ; --UNCHK
lin devoutness_N = mkWN (k40 "hengellisyys") ; --UNCHK
lin devries_N = mkWN (compoundN "deVr" (k41A "ies")) "Hugo" ; --UNCHK
lin dew_N = mkWN (k48 "kaste") ; --UNCHK
lin dewberry_N = mkWN (compoundN "sini" (k14A "vatukka")) ; --UNCHK
lin dewdrop_N = mkWN (compoundN "kaste" (k12 "pisara")) ; --UNCHK
lin dewlap_N = mkWN (compoundN "kaula" (k9 "nahka")) ; --UNCHK
lin dewsbury_PN = foreignPN "Dewsbury" ;
lin dewy_A = mkWA (k38 "kasteinen") ; --UNCHK
lin dexamethasone_N = mkWN "Oradexon" ; --UNCHK
lin dexter_A = mkWA (compoundA "oikean" (k38 "puoleinen")) ; --UNCHK
lin dexterity_N = mkWN (k40 "taitavuus") ; --UNCHK
lin dexterous_A = mkWA (k10 "kätevä") ; --UNCHK
lin dextral_A = mkWA (compoundA "oikean" (k38 "puoleinen")) ; --UNCHK
lin dextrin_N = mkWN "dekstriini" ; --UNCHK
lin dextrorotary_A = mkWA "oikealle" "kääntyvä" ; --UNCHK
lin dextrorotation_N = mkWN "myötäpäivään" "kiertäminen" ; --UNCHK
lin dextrorse_A = mkWA (compoundA "oikea" (k38 "kierteinen")) ; --UNCHK
lin dextrose_N = mkWN (compoundN "rypäle" (k6 "sokeri")) ; --UNCHK
lin dextrous_A = mkWA (k10 "kätevä") ; --UNCHK
lin dhak_N = mkWN (compoundN "mono" (k9 "sperma")) "Butea" ; --UNCHK
lin dhawa_N = mkWN "dhava" ; --UNCHK
lin dhole_N = mkWN (compoundN "vuori" (k27 "susi")) ; --UNCHK
lin dhoti_N = mkWN "dhoti" ; --UNCHK
lin dhow_N = mkWN (compoundN "rannikko" (k39 "alus")) ; --UNCHK
lin diabatic_A = mkWA (compoundA "dia" (k38 "baattinen")) ; --UNCHK
lin diabetes_N = mkWN (k39 "diabetes") ; --UNCHK
lin diabetic_A = mkWA (compoundA "diab" (k38 "eettinen")) ; --UNCHK
lin diabetic_N = mkWN (k4A "diabeetikko") ;
lin diabolatry_N = mkWN (k5 "satanismi") ; --UNCHK
lin diabolic_A = mkWA (k34A "jumalaton") ; --UNCHK
lin diabolical_A = mkWA (k34A "jumalaton") ; --UNCHK
lin diabolism_N = mkWN (k5 "satanismi") ; --UNCHK
lin diachronic_A = mkWA (k38 "historiallinen") ; --UNCHK
lin diacritic_A = mkWA (compoundA "dia" (k38 "kriittinen")) ; --UNCHK
lin diacritic_N = mkWN (k48A "tarke") ; --UNCHK
lin diacritical_A = mkWA (compoundA "dia" (k38 "kriittinen")) ; --UNCHK
lin diadem_N = mkWN (k5 "diadeemi") ; --UNCHK
lin diadromous_A = mkWA (compoundA "dia" (k38 "drominen")) ; --UNCHK
lin diaeresis_N = mkWN (k9 "treema") ; --UNCHK
lin diagnosable_A = mkWA "diagnosoitava" ; --UNCHK
lin diagnose_V2 = mkWV2 (k53A "määrittää") "tauti" ; --UNCHK
lin diagnosis_N = mkWN (k5 "diagnoosi") ; --UNCHK
lin diagnostic_A = mkWA (k38 "diagnostinen") ;
lin diagnostician_N = mkWN (k5 "patologi") ; --UNCHK
lin diagonal_A = mkWA (k1 "vino") ; --UNCHK
lin diagonal_N = mkWN (k50 "vinoviiva") ; --UNCHK
lin diagonalizable_A = mkWA "diagonalisoitava" ; --UNCHK
lin diagonalization_N = mkWN (compoundN "diagonali" (k5A "sointi")) ; --UNCHK
lin diagram_N = mkWN (k3 "kaavio") ; --UNCHK
lin diakinesis_N = mkWN "diakineesi" ; --UNCHK
lin dial_N = mkWN (compoundN "kello" (k1 "taulu")) ; --UNCHK
lin dial_V2 = mkWV2 (k69 "valita") ; --UNCHK
lin dialect_N = mkWN (k39 "korostus") ; --UNCHK
lin dialectal_A = mkWA (k38 "murteellinen") ; --UNCHK
lin dialectic_A = mkWA (k38 "dialektinen") ; --UNCHK
lin dialectic_N = mkWN (k2 "väittely") ; --UNCHK
lin dialectical_A = mkWA (k38 "dialektinen") ; --UNCHK
lin dialectician_N = mkWN "dialektikko" ; --UNCHK
lin dialectics_N = mkWN (k9A "dialektiikka") ; --UNCHK
lin dialectology_N = mkWN (compoundN "murre" (k39 "tutkimus")) ; --UNCHK
lin dialogue_N = mkWN (k5 "dialogi") ; --UNCHK
lin dialysis_N = mkWN (k5 "dialyysi") ; --UNCHK
lin dialyzer_N = mkWN (compoundN "dialyysi" (k48A "laite")) ; --UNCHK
lin diamagnet_N = mkWN (k48 "aine") "diamagneettinen" ; --UNCHK
lin diamagnetic_A = mkWA (compoundA "dia" (k38 "magneettinen")) ; --UNCHK
lin diamagnetism_N = mkWN (compoundN "dia" (k5 "magnetismi")) ; --UNCHK
lin diamante_N = mkWN "strassikoristeltu" ; --UNCHK
lin diamantine_A = mkWA (k38 "timanttinen") ; --UNCHK
lin diameter_N = mkWN (k12 "halkaisija") ; --UNCHK
lin diametral_A = mkWA (compoundA "dia" (k38 "metrinen")) ; --UNCHK
lin diametric_A = mkWA (compoundA "dia" (k38 "metrinen")) ; --UNCHK
lin diamine_N = mkWN "diamiini" ; --UNCHK
lin diamond_N = mkWN (compoundN "sisä" (k10A "kenttä")) ; --UNCHK
lin diamondback_N = mkWN "timanttikalkkarokäärme" ; --UNCHK
lin dianoetic_A = mkWA (compoundA "eritte" (k10 "levä")) ; --UNCHK
lin diapason_N = mkWN (k6 "rekisteri") ; --UNCHK
lin diapedesis_N = mkWN "diapedeesi" ; --UNCHK
lin diapensia_N = mkWN "uuvana" ; --UNCHK
lin diaper_N = mkWN (k9A "vaippa") ; --UNCHK
lin diaphanous_A = mkWA (k43 "ohut") ; --UNCHK
lin diapheromera_N = mkWN (k9A "sauvasirkka") ; --UNCHK
lin diaphone_N = mkWN (k6 "sumusireeni") "kaksiääninen" ; --UNCHK
lin diaphoretic_N = mkWN "hikoilua" "edistävä" ; --UNCHK
lin diaphragm_N = mkWN (k33A "himmennin") ; --UNCHK
lin diaphyseal_A = mkWA (compoundA "dia" (k38 "fyysinen")) ; --UNCHK
lin diaphysis_N = mkWN (compoundN "luun" (k28 "varsi")) ; --UNCHK
lin diapir_N = mkWN (compoundN "dia" (k5 "piiri")) ; --UNCHK
lin diapsid_N = mkWN (k12 "matelija") ; --UNCHK
lin diarchy_N = mkWN (compoundN "kaksin" (k9A "valta")) ; --UNCHK
lin diarist_N = mkWN (k10 "pitäjä") "päiväkirjan" ; --UNCHK
lin diarrhea_N = mkWN (k6 "ripuli") ; --UNCHK
lin diarrheal_A = mkWA (k38 "ripulinen") ; --UNCHK
lin diarrhoea_N = mkWN (k6 "ripuli") ; --UNCHK
lin diary_N = mkWN (k6 "päivyri") ; --UNCHK
lin diaspora_N = mkWN (k10 "diaspora") ; --UNCHK
lin diastema_N = mkWN (compoundN "hammas" (k10 "loma")) ; --UNCHK
lin diastole_N = mkWN (compoundN "lepo" (k48 "vaihe")) ; --UNCHK
lin diastolic_A = mkWA (k38 "diastolinen") ; --UNCHK
lin diastrophism_N = mkWN (compoundN "deformaatio" (k5 "prosessi")) "maan" "kuoren" ; --UNCHK
lin diathermy_N = mkWN "diatermia" ; --UNCHK
lin diathesis_N = mkWN (k39 "taipumus") ; --UNCHK
lin diatom_N = mkWN (kH1 "piilevä") ; --UNCHK
lin diatomic_A = mkWA (compoundA "kaks" (k38 "iatominen")) ; --UNCHK
lin diatonic_A = mkWA (k38 "diatoninen") ; --UNCHK
lin diatribe_N = mkWN (k39 "hyökkäys") "kiivas" "sanallinen" ; --UNCHK
lin diazepam_N = mkWN (k5 "diatsepaami") ; --UNCHK
lin diazo_A = mkWA "diatso-" ; --UNCHK
lin diazonium_N = mkWN "diatsonium" ; --UNCHK
lin diazoxide_N = mkWN (compoundN "diats" (k5 "oksidi")) ; --UNCHK
lin dibber_N = mkWN (compoundN "istutus" (k1A "puikko")) ; --UNCHK
lin dibble_N = mkWN (compoundN "istutus" (k1A "puikko")) ; --UNCHK
lin dibble_V2 = mkWV2 (k53A "rei'ittää") ; --UNCHK
lin dibranchiate_N = mkWN (k38 "nilviäinen") "kaksikiduksinen" ; --UNCHK
lin dibs_N = mkWN (k39 "varaus") ; --UNCHK
lin dibucaine_N = mkWN "dibukaiini" ; --UNCHK
lin dicamptodon_N = mkWN (k6 "salamanteri") ; --UNCHK
lin dicarboxylic_A = mkWA "dikarboksyyli-" ; --UNCHK
lin dice_N = mkWN (k10A "noppa") ; --UNCHK
lin dice_V = mkWV (k53A "heittää") "noppaa" ; --UNCHK
lin dice_V2 = mkWV2 (k53A "heittää") "noppaa" ; --UNCHK
lin dice_box_N = mkWN (compoundN "noppa" (k6 "pikari")) ; --UNCHK
lin dicer_N = mkWN (k6 "leikkuri") ; --UNCHK
lin dicey_A = mkWA (k38 "vaarallinen") ; --UNCHK
lin dichloride_N = mkWN "dikloridi" ; --UNCHK
lin dichlorodiphenyltrichloroethane_N = mkWN (compoundN "diklooridifenyylitrikloori" (k5 "etaani")) ; --UNCHK
lin dichondra_N = mkWN (compoundN "pikku" (k9 "vitja")) ; --UNCHK
lin dichotomization_N = mkWN (compoundN "kahtia" (k1A "jako")) ; --UNCHK
lin dichotomous_A = mkWA (compoundA "kaks" (k38 "ijakoinen")) ; --UNCHK
lin dichotomy_N = mkWN (k40 "kaksijakoisuus") ; --UNCHK
lin dichroism_N = mkWN (compoundN "kaksi" (k40 "värisyys")) ; --UNCHK
lin dichromacy_N = mkWN (compoundN "väri" (k40 "sokeus")) "osittainen" ; --UNCHK
lin dichromat_N = mkWN "osittaisvärisokea" ; --UNCHK
lin dichromatic_A = mkWA (compoundA "kaksiväri" (k38 "näköinen")) ; --UNCHK
lin dick_N = mkN "kulli" ;
lin dickens_N = mkWN (k48 "perkele") ; --UNCHK
lin dicker_V = mkWV (k52 "hieroa") "kauppoja" ; --UNCHK
lin dickey_N = mkWN (compoundN "irto" (k39 "etumus")) ; --UNCHK
lin dickeybird_N = mkWN (k1 "tipu") ; --UNCHK
lin dicky_A = mkWA (k1A "heikko") ; --UNCHK
lin dicky_N = mkWN (compoundN "irto" (k39 "etumus")) ; --UNCHK
lin dickybird_N = mkWN (k1 "tipu") ; --UNCHK
lin diclinous_A = mkWA (compoundA "yksineu" (k38 "voinen")) ; --UNCHK
lin dicloxacillin_N = mkWN "Dynapen" ; --UNCHK
lin dicot_N = mkWN (compoundN "kaks" (k38 "isirkkainen")) ; --UNCHK
lin dicotyledonous_A = mkWA (compoundA "kaks" (k38 "isirkkainen")) ; --UNCHK
lin dictaphone_N = mkWN (compoundN "sanelu" (k48 "kone")) ; --UNCHK
lin dictate_N = mkWN (compoundN "ohje" (k10 "nuora")) ; --UNCHK
lin dictate_V = mkWV (k67 "sanella") ; --UNCHK
lin dictate_V2 = mkWV2 (k67 "sanella") ; --UNCHK
lin dictate_VS = mkWVS (k67 "sanella") ; --UNCHK
lin dictation_N = mkWN (k2 "sanelu") ; --UNCHK
lin dictator_N = mkWN (k6 "diktaattori") ; --UNCHK
lin dictatorial_A = mkWA (k38 "diktatorinen") ; --UNCHK
lin dictatorship_N = mkWN (k12 "tyrannia") ; --UNCHK
lin diction_N = mkWN (k12 "fraseologia") ; --UNCHK
lin dictionary_N = mkWN (k2 "sanasto") ; --UNCHK
lin dictostylium_N = mkWN (compoundN "lima" (k26 "sieni")) ; --UNCHK
lin dictum_N = mkWN (k10A "lupa") ; --UNCHK
lin dictyopteran_A = mkWA "torakoihin" "liittyvä" ; --UNCHK
lin dicumarol_N = mkWN "dikumariini" ; --UNCHK
lin dicynodont_N = mkWN "dicynodontti" ; --UNCHK
lin didactic_A = mkWA (k38 "didaktinen") ; --UNCHK
lin didacticism_N = mkWN "didaktisuus" ; --UNCHK
lin didcot_PN = foreignPN "Didcot" ;
lin diddle_V2 = mkWV2 (k62 "näpelöidä") ; --UNCHK
lin dideoxycytosine_N = mkWN "DDC" ; --UNCHK
lin dideoxyinosine_N = mkWN "DDI" ; --UNCHK
lin die_N = mkWN (k10A "noppa") ; --UNCHK
lin die_V = L.die_V ;
lin die_away_V = mkWV (k52A "vähentyä") ; --UNCHK
lin die_back_V = mkWV (k67 "kuolla") ; --UNCHK
lin die_down_V = mkWV (k52A "hiipua") ; --UNCHK
lin die_for_V2 = prepV2 OP_die_V OP_for_Prep ; -- guess-p-verb
lin die_off_V = mkWV (k75 "hävitä") ; --UNCHK
lin die_out_V = mkWV (k75 "hävitä") ; --UNCHK
lin dieback_N = mkWN (compoundN "verso" (k5A "tauti")) ; --UNCHK
lin diemaker_N = mkWN "meistäjä" ; --UNCHK
lin dieresis_N = mkWN (k9 "treema") ; --UNCHK
lin diesel_N = mkWN (compoundN "diesel" (k6 "moottori")) ; --UNCHK
lin diestock_N = mkWN (compoundN "kierre" (k10A "sorkka")) ; --UNCHK
lin diestrous_A = mkWA (k10 "oleva") "diestruksessa" ; --UNCHK
lin diestrus_N = mkWN "diestrus" ; --UNCHK
lin diet_N = mkN "ravinto" ; --mkWN (k5 "laihdutuskuuri") ;
lin diet_V = mkWV (k67 "olla") "dieetillä" ; --UNCHK
lin diet_V2 = mkWV2 (k67 "olla") "dieetillä" ; --UNCHK
lin dietary_A = mkWA "ruokavalio-" ; --UNCHK
lin dietary_N = mkWN "ruokavalio-" ; --UNCHK
lin dieter_N = mkWN (k2 "henkilö") "ruokavaliota" "noudattava" ; --UNCHK
lin dietetics_N = mkWN (k9A "dietetiikka") ; --UNCHK
lin diethylstilbesterol_N = mkWN "DES" ; --UNCHK
lin diethylstilbestrol_N = mkWN "DES" ; --UNCHK
lin dietician_N = mkWN (k4A "dieteetikko") ; --UNCHK
lin dietitian_N = mkWN (k4A "dieteetikko") ; --UNCHK
lin differ_V = mkV "erota" ;
lin difference_N = mkN "ero" ;
lin different_A = mkA "erilainen" ;
lin differentiable_A = mkWA "differentioituva" ; --UNCHK
lin differential_A = mkWA (k38 "erilainen") ; --UNCHK
lin differential_N = mkN "erotus" ; --WN (compoundN "tasaus" (k2 "pyörästö")) ;
lin differentiate_V = mkWV (k52 "erilaistua") ; --UNCHK
lin differentiate_V2 = mkWV2 (k52 "erilaistua") ; --UNCHK
lin differentiation_N = mkWN "differentaatio" ; --UNCHK
lin differentiator_N = mkWN "erottelija" ; --UNCHK
lin difficult_A = mkA "vaikea" ;
lin difficulty_N = mkN "ongelma" ;
lin diffidence_N = mkWN (k48A "puute") "itseluottamuksen" ; --UNCHK
lin diffident_A = mkWA (k41A "pelokas") ; --UNCHK
lin difflugia_N = mkWN (compoundN "alku" (k33 "eläin")) ; --UNCHK
lin diffract_V2 = mkWV2 (k53A "taivuttaa") ; --UNCHK
lin diffraction_N = mkWN (k3 "diffraktio") ; --UNCHK
lin diffuse_A = mkWA (k5 "diffuusi") ; --UNCHK
lin diffuse_V = mkWV (k74 "juoruta") ; --UNCHK
lin diffuse_V2 = mkWV2 (k74 "juoruta") ; --UNCHK
lin diffuseness_N = mkWN (k40 "hajanaisuus") ; --UNCHK
lin diffuser_N = mkWN (compoundN "diffuus" (k48 "ori")) ; --UNCHK
lin diffusion_N = mkWN (k39 "levitys") ; --UNCHK
lin diflunisal_N = mkWN (compoundN "difluni" (k5 "saali")) ; --UNCHK
lin dig_N = mkWN (k2 "tönäisy") ; --UNCHK
lin dig_V = L.dig_V ;
lin dig_V2 = mkWV2 (k74 "tajuta") ; --UNCHK
lin dig_in_V = advV OP_dig_V OP_in_Adv ; -- guess-p-verb
lin dig_into_V2 = mkWV2 (k67 "tunnustella") ; --UNCHK
lin dig_out_V2 = mkWV2 (k56 "kaivaa") ; --UNCHK
lin dig_up_V2 = mkWV2 (k56 "kaivaa") "esiin" ; --UNCHK
lin digest_N = mkWN (k48 "kooste") ; --UNCHK
lin digest_V = mkWV (k53A "sulattaa") ; --UNCHK
lin digest_V2 = mkWV2 (k53A "sulattaa") ; --UNCHK
lin digester_N = mkWN (compoundN "paine" (k33A "keitin")) ; --UNCHK
lin digestibility_N = mkWN (k40 "sulavuus") ; --UNCHK
lin digestible_A = mkWA (k10 "sulava") ; --UNCHK
lin digestion_N = mkWN (compoundN "oma" (k38 "ksuminen")) ; --UNCHK
lin digestive_A = mkWA "ruoansulatus-" ; --UNCHK
lin digestive_N = mkWN (k48 "aine") "ruoansulatusta" "edistävä" ; --UNCHK
lin digger_N = mkWN (k6 "kaivuri") ; --UNCHK
lin digging_N = mkWN (k39 "kaivaus") ; --UNCHK
lin diggings_N = mkWN (k1A "luukku") ; --UNCHK
lin dighted_A = mkWA (compoundA "varus" (k1 "tettu")) ; --UNCHK
lin digit_N = mkWN (k41A "varvas") ; --UNCHK
lin digital_A = mkWA (k38 "digitaalinen") ;
lin digitalis_N = mkWN (compoundN "sormustin" (k10A "kukka")) ; --UNCHK
lin digitalization_N = mkWN (k5A "digitalisointi") ; --UNCHK
lin digitigrade_A = mkWA (compoundA "varvas" (k10 "astuja")) ; --UNCHK
lin digitization_N = mkWN (k5A "digitalisointi") ; --UNCHK
lin digitizer_N = mkWN (compoundN "analogia-digitaali" (k33A "muunnin")) ; --UNCHK
lin digitoxin_N = mkWN (compoundN "digi" (k5 "toksiini")) ; --UNCHK
lin dignify_V2 = mkWV2 (k53A "kunnioittaa") ; --UNCHK
lin dignifying_A = mkWA (compoundA "kor" (k10 "ottava")) ; --UNCHK
lin dignitary_N = mkWN (k9 "herra") "suuri" ; --UNCHK
lin dignity_N = mkN "arvokkuus" ;
lin digoxin_N = mkWN "Lanoxin" ; --UNCHK
lin digraph_N = mkWN (compoundN "kaksois" (k33 "kirjain")) ; --UNCHK
lin digress_V = mkWV (k74A "poiketa") ; --UNCHK
lin digression_N = mkWN "aiheesta" "eksyminen" ; --UNCHK
lin digressive_A = mkWA (k10 "poikkeava") "aiheesta" ; --UNCHK
lin dihybrid_N = mkWN "dihybridi" ; --UNCHK
lin dihydrostreptomycin_N = mkWN "dihydrostreptomysiini" ; --UNCHK
lin dijon_PN = foreignPN "Dijon" ;
lin dike_N = mkWN (k1A "pato") ; --UNCHK
lin dike_V = mkWV (k62 "ympäröidä") "vallilla" ; --UNCHK
lin dike_V2 = mkWV2 (k62 "ympäröidä") "vallilla" ; --UNCHK
lin dilapidated_A = mkWA (k38 "rähjäinen") ; --UNCHK
lin dilapidation_N = mkWN (k3 "rappio") ; --UNCHK
lin dilatation_N = mkWN "dilataatio" ; --UNCHK
lin dilate_V = mkWV (k52A "laajentua") ; --UNCHK
lin dilate_V2 = mkWV2 (k52A "laajentua") ; --UNCHK
lin dilation_N = mkWN "dilataatio" ; --UNCHK
lin dilator_N = mkWN "laajennin" ; --UNCHK
lin dilatoriness_N = mkWN (k2 "vitkastelu") ; --UNCHK
lin dilatory_A = mkWA (k41A "hidas") ; --UNCHK
lin dildo_N = mkWN (compoundN "hieroma" (k9 "sauva")) ; --UNCHK
lin dilemma_N = mkWN (k10 "pulma") ;
lin dilettante_A = mkWA (k38 "pinnallinen") ; --UNCHK
lin dilettante_N = mkWN (k5A "diletantti") ; --UNCHK
lin diligence_N = mkWN (k40 "uutteruus") ; --UNCHK
lin diligent_A = mkWA (k10 "ahkera") ; --UNCHK
lin dill_N = mkWN (k5 "tilli") ; --UNCHK
lin diltiazem_N = mkWN (compoundN "diltiatse" (k5 "emi")) ; --UNCHK
lin dilutant_N = mkWN (k48A "ohenne") ; --UNCHK
lin dilute_A = mkWA (k1A "mieto") ; --UNCHK
lin dilute_V = mkWV (k53A "vesittää") ; --UNCHK
lin dilute_V2 = mkWV2 (k53A "vesittää") ; --UNCHK
lin dilution_N = mkWN (k39 "laimennus") ; --UNCHK
lin diluvian_A = mkWA "diluviaali-" ; --UNCHK
lin dim_A = mkWA (k15 "himmeä") ; --UNCHK
lin dim_V = mkWV (k52A "hämärtyä") ; --UNCHK
lin dim_V2 = mkWV2 (k52A "hämärtyä") ; --UNCHK
lin dime_N = mkWN (compoundN "huume" (k5A "paketti")) ; --UNCHK
lin dimenhydrinate_N = mkWN (compoundN "dimenhydri" (k5A "naatti")) ; --UNCHK
lin dimension_N = mkWN (k40 "laajuus") ; --UNCHK
lin dimensional_A = mkWA (k38 "-ulotteinen") ; --UNCHK
lin dimensionality_N = mkWN (k40 "ulotteisuus") ; --UNCHK
lin dimensioning_A = mkWA "mitoittava" ; --UNCHK
lin dimethylglyoxime_N = mkWN "dimetyyliglyoksiimi" ; --UNCHK
lin dimetrodon_N = mkWN "dimetrodon" ; --UNCHK
lin diminish_V = mkWV (k58 "laskea") ; --UNCHK
lin diminish_V2 = mkWV2 (k58 "laskea") ; --UNCHK
lin diminuendo_N = mkWN "diminuendo" ; --UNCHK
lin diminution_N = mkWN (k39 "vähennys") ; --UNCHK
lin diminutive_A = mkWA (k10 "sorja") ; --UNCHK
lin diminutive_N = mkWN (k5 "deminutiivi") ; --UNCHK
lin diminutiveness_N = mkWN (k40 "pienuus") ; --UNCHK
lin dimity_N = mkWN (compoundN "park" (k5 "kumi")) ; --UNCHK
lin dimmer_N = mkWN (k33A "himmennin") ; --UNCHK
lin dimness_N = mkWN (k40 "hämäryys") ; --UNCHK
lin dimorphic_A = mkWA (compoundA "kaksi" (k38 "muotoinen")) ; --UNCHK
lin dimorphism_N = mkWN (compoundN "dimorf" (k5 "ismi")) ; --UNCHK
lin dimple_N = mkWN (compoundN "hymy" (k10A "kuoppa")) ; --UNCHK
lin dimple_V = mkWV (k53 "paljastaa") "hymykuopat" ; --UNCHK
lin dimple_V2 = mkWV2 (k53 "paljastaa") "hymykuopat" ; --UNCHK
lin dimwit_N = mkWN (k6 "tomppeli") ; --UNCHK
lin din_N = mkWN (k12 "rähinä") ; --UNCHK
lin din_V = mkWV (k58A "hokea") ; --UNCHK
lin din_V2 = mkWV2 (k58A "hokea") ; --UNCHK
lin dinar_N = mkWN (compoundN "din" (k5 "aari")) ; --UNCHK
lin dine_V = mkV (mkV "syödä") "päivällistä" ; --UNCHK
lin dine_out_V = mkWV (k64 "syödä") "ravintolassa" ; --UNCHK
lin diner_N = mkWN "tienvarsiruokapaikka" ; --UNCHK
lin dinette_N = mkWN (compoundN "ruokailu" (k9 "tila")) ; --UNCHK
lin ding_N = mkWN (k1 "naarmu") ; --UNCHK
lin dingbat_N = mkWN (k39 "typerys") ; --UNCHK
lin dingdong_Adv = mkWAdv (k99 "tarmokkaasti") ; --UNCHK
lin dinghy_N = mkWN (k48 "vene") ; --UNCHK
lin dinginess_N = mkWN "nuhruisuus" ; --UNCHK
lin dingle_N = mkWN (k1 "laakso") "metsäinen" ; --UNCHK
lin dingle_PN = foreignPN "Dingle" ;
lin dingo_N = mkWN (compoundN "villi" (k10 "koira")) ; --UNCHK
lin dingy_A = mkWA (k15 "synkeä") ; --UNCHK
lin dining_N = mkWN (k38 "syöminen") "päivällisen" ; --UNCHK
lin dining_car_N = mkWN (compoundN "ravintola" (k1 "vaunu")) ; --UNCHK
lin dining_room_N = mkWN (compoundN "ruoka" (k5 "sali")) ; --UNCHK
lin dining_table_N = mkWN (compoundN "ruoka" (k10A "pöytä")) ; --UNCHK
lin dinky_A = mkWA (k10 "soma") ; --UNCHK
lin dinky_N = mkWN (k6 "veturi") "pieni" ; --UNCHK
lin dinner_N = mkWN (k38 "päivällinen") ; --UNCHK
lin dinner_jacket_N = mkWN (k5A "smokki") ; --UNCHK
lin dinner_service_N = mkWN (compoundN "pöytä" (k1 "astiasto")) ; --UNCHK
lin dinner_set_N = mkWN (compoundN "pöytä" (k1 "astiasto")) ; --UNCHK
lin dinnertime_N = mkWN (k9A "päivällisaika") ; --UNCHK
lin dinnerware_N = mkWN (compoundN "pöytä" (k1 "kalusto")) ; --UNCHK
lin dinnington_PN = foreignPN "Dinnington" ;
lin dinocerate_N = mkWN "dinocerate" ; --UNCHK
lin dinosaur_N = mkWN (k39 "dinosaurus") ; --UNCHK
lin dint_N = mkWN "avulla" ; --UNCHK
lin diocesan_A = mkWA "hiippakunnan-" ; --UNCHK
lin diocesan_N = mkWN (k9 "piispa") ; --UNCHK
lin diocese_N = mkWN (compoundN "piispan" (k9A "virka")) ; --UNCHK
lin diode_N = mkWN (k5 "diodi") ; --UNCHK
lin dioecious_A = mkWA (k38 "kaksikotinen") ; --UNCHK
lin diol_N = mkWN (compoundN "dihydro" (k5 "alkoholi")) ; --UNCHK
lin diopter_N = mkWN (k6 "diopteri") ; --UNCHK
lin diorite_N = mkWN (compoundN "dio" (k5A "riitti")) ; --UNCHK
lin dioxide_N = mkWN "dioksidi" ; --UNCHK
lin dioxin_N = mkWN (k5 "dioksiini") ; --UNCHK
lin dip_N = mkWN (k5A "dippi") ; --UNCHK
lin dip_V = mkWV (k52A "hyytyä") ; --UNCHK
lin dip_V2 = mkWV2 (k52A "hyytyä") ; --UNCHK
lin dip_ed_N = mkN "kasvatustieteiden" (mkN "maisteri") ; ----sanaliitto
lin dip_into_V2 = mkWV2 (k58A "lukea") "kursorisesti" ; --UNCHK
lin diphenhydramine_N = mkWN "Benadryl" ; --UNCHK
lin diphenylhydantoin_N = mkWN "Dilantin" ; --UNCHK
lin diphtheria_N = mkWN (compoundN "kurkku" (k10A "mätä")) ; --UNCHK
lin diphthong_N = mkWN (k5 "diftongi") ; --UNCHK
lin diplegia_N = mkWN (compoundN "kaksois" (k39 "halvaus")) ; --UNCHK
lin diplococcus_N = mkWN (k5A "diplokokki") ; --UNCHK
lin diplodocus_N = mkWN "diplodocus" ; --UNCHK
lin diploid_A = mkWA (k5 "diploidi") ; --UNCHK
lin diploid_N = mkWN (k5 "diploidi") ; --UNCHK
lin diploidy_N = mkWN "diploidisuus" ; --UNCHK
lin diploma_N = mkWN (k5 "diplomi") ; --UNCHK
lin diplomacy_N = mkWN (k40 "tahdikkuus") ; --UNCHK
lin diplomat_N = mkWN (k5A "diplomaatti") ;
lin diplomate_N = mkWN (compoundN "erikois" (k6 "lääkäri")) ; --UNCHK
lin diplomatic_A = mkA "diplomaattinen" ;
lin diplomatically_Adv = mkWAdv "diplomaattisesti" ; --UNCHK
lin diplomatist_N = mkWN (k5A "diplomaatti") ; --UNCHK
lin diplopia_N = mkWN "kahtena" "näkeminen" ; --UNCHK
lin diplotene_N = mkWN "diploteeni" ; --UNCHK
lin dipolar_A = mkWA (compoundA "kaks" (k38 "inapainen")) ; --UNCHK
lin dipole_N = mkWN (k5 "dipoli") ; --UNCHK
lin dipper_N = mkWN (compoundN "koski" (k9 "kara")) ; --UNCHK
lin dipsomania_N = mkWN (k5 "alkoholismi") ; --UNCHK
lin dipsomaniac_N = mkWN (k6 "juomari") ; --UNCHK
lin dipstick_N = mkWN (compoundN "mitta" (k1A "tikku")) ; --UNCHK
lin dipterous_A = mkWA (compoundA "kaks" (k38 "isiipinen")) ; --UNCHK
lin diptych_N = mkWN "diptyykki" ; --UNCHK
lin dire_A = mkA "vakava" ; --mkWA (k38 "hirmuinen") ;
lin direct_A = mkWA (k10 "suora") ;
lin direct_Adv = mkWAdv (k99 "suoraan") ; --UNCHK
lin direct_V = mkWV (k53A "toteuttaa") ; --UNCHK
lin direct_V2 = mkWV2 (k53A "toteuttaa") ; --UNCHK
lin direction_N = mkWN (k39 "ohjaus") ;
lin direction_finder_N = mkWN (compoundN "radio" (k33A "suunnin")) ; --UNCHK
lin directional_A = mkWA (compoundA "suu" (k1 "nnattu")) ; --UNCHK
lin directionality_N = mkWN (k40 "suuntaisuus") ; --UNCHK
lin directive_N = mkWN (k5 "direktiivi") ;
lin directivity_N = mkWN (compoundN "suunta" (k40 "herkkyys")) ; --UNCHK
lin directness_N = mkWN (k40 "avoimuus") ; --UNCHK
lin director_N = mkN "johtaja" ;
lin directorate_N = mkWN (k39 "hallitus") ; --UNCHK
lin directorship_N = mkWN (k40 "johtajuus") ; --UNCHK
lin directory_N = mkN "hakemisto" ; --mkWN (k2 "luettelo") ;
lin direful_A = mkWA (k38 "hirmuinen") ; --UNCHK
lin dirge_N = mkWN (compoundN "sielu" (k1 "messu")) ; --UNCHK
lin dirigible_N = mkWN (compoundN "ilma-" (k39 "alus")) ; --UNCHK
lin dirk_N = mkWN (k6 "tikari") ; --UNCHK
lin dirndl_N = mkWN (compoundN "tirolilais" (k1A "puku")) ; --UNCHK
lin dirt_A = mkWA "päällystämätön" ; --UNCHK
lin dirt_N = mkWN (k1A "törky") ; --UNCHK
lin dirt_cheap_A = mkWA (k9A "halpa") "hyvin" ; --UNCHK
lin dirt_track_N = mkWN (compoundN "maa" (k9A "rata")) ; --UNCHK
lin dirtiness_N = mkWN (k40 "hävyttömyys") ; --UNCHK
lin dirty_A = L.dirty_A ;
lin dirty_V = mkWV (k58 "iskeä") ; --UNCHK
lin dirty_V2 = mkWV2 (k58 "iskeä") ; --UNCHK
lin disa_N = mkWN "DISA" ; --UNCHK
lin disability_N = mkN "kykenemättömyys" ; --mkWN (k40 "vammaisuus") ;
lin disable_V2 = mkV2 (mkV (mkV "poistaa") "toiminnasta") ; --WV2 (k52A "vammautua") ;
lin disabled_A = variants {} ; --
lin disablement_N = mkWN (k40 "vammaisuus") ; --UNCHK
lin disabling_A = mkWA (k10 "tekevä") "esteelliseksi" ; --UNCHK
lin disabuse_V2 = mkWV2 (k53 "poistaa") "harhaluulot" ; --UNCHK
lin disaccharidase_N = mkWN (compoundN "disakkarid" (k5 "aasi")) ; --UNCHK
lin disaccharide_N = mkWN "disakkaridi" ; --UNCHK
lin disadvantage_N = mkWN (k10 "asema") "epäedullinen" ; --UNCHK
lin disadvantageous_A = mkWA (k38 "haitallinen") ; --UNCHK
lin disaffected_A = mkWA (k38 "kapinallinen") ; --UNCHK
lin disaffection_N = mkWN (k40 "tyytymättömyys") ; --UNCHK
lin disafforest_V2 = mkWV2 (k53 "poistaa") "metsä" ; --UNCHK
lin disagree_V = mkV vOlla "eri mieltä" ;
lin disagree_V2 = variants {} ; -- mkV vOlla "eri mieltä" ;
lin disagree_VS = variants {} ; -- mkV vOlla "eri mieltä" ;
lin disagree_with_V2 = mkWV2 (k67 "olla") "sopimaton" ; --UNCHK
lin disagreeable_A = mkWA (compoundA "epä" (k10 "miellyttävä")) ; --UNCHK
lin disagreeableness_N = mkWN (compoundN "epä" (k40 "miellyttävyys")) ; --UNCHK
lin disagreement_N = mkN (lin NK {s = d09 "kiista"}) ;
lin disallow_V2 = mkWV2 (k53A "käyttää") "veto-oikeuttaan" ; --UNCHK
lin disambiguation_N = mkWN (k39 "selvennys") ; --UNCHK
lin disambiguator_N = mkWN "yksiselitteistäjä" ; --UNCHK
lin disappear_V = mkV "kadota" ;
lin disappearance_N = mkWN (compoundN "kato" (k38 "aminen")) ;
lin disappoint_V2 = mkWV2 (k53A "pettää") ;
lin disappointedly_Adv = mkWAdv "pettyneenä" ; --UNCHK
lin disappointing_A = mkWA (k10 "tuottava") "pettymyksen" ;
lin disappointment_N = mkWN (compoundN "aihe" (k38 "uttaminen")) "pettymyksen" ; --UNCHK
lin disapprobation_N = mkWN (k9A "paheksunta") ; --UNCHK
lin disapproval_N = mkWN (k9A "paheksunta") ; --UNCHK
lin disapprove_V = mkWV (k69 "tuomita") ; --UNCHK
lin disapprove_V2 = mkWV2 (k69 "tuomita") ; --UNCHK
lin disapprovingly_Adv = mkWAdv "paheksuen" ; --UNCHK
lin disarm_V = mkWV (k62 "demilitarisoida") ; --UNCHK
lin disarm_V2 = mkWV2 (k62 "demilitarisoida") ; --UNCHK
lin disarmament_N = mkWN (compoundN "aseiden" (k9A "riisunta")) ; --UNCHK
lin disarming_N = mkWN (compoundN "aseiden" (k9A "riisunta")) ; --UNCHK
lin disarrange_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin disarrangement_N = mkWN (k39 "hajaannus") ; --UNCHK
lin disarray_N = mkWN (k40 "sekaisuus") ; --UNCHK
lin disassociate_V2 = mkWV2 (k52A "erottautua") ; --UNCHK
lin disassociation_N = mkWN "persoonallisuuden" "jakautuminen" ; --UNCHK
lin disaster_N = mkWN (k5 "katastrofi") ; --f107
lin disastrous_A = mkWA (k38 "katastrofaalinen") ; --UNCHK
lin disavow_V2 = mkWV2 (k53 "kiistää") ; --UNCHK
lin disavowable_A = mkWA "kiistettävä" ; --UNCHK
lin disavowal_N = mkWN (compoundN "kii" (k38 "stäminen")) ; --UNCHK
lin disband_V = mkWV (k52A "hajaantua") ; --UNCHK
lin disband_V2 = mkWV2 (k52A "hajaantua") ; --UNCHK
lin disbandment_N = mkWN "hajottaminen" ; --UNCHK
lin disbarment_N = mkWN (compoundN "ero" (k38 "ttaminen")) "asianajajaliitosta" ; --UNCHK
lin disbelief_N = mkWN (k39 "epäilys") ; --UNCHK
lin disbelieve_V = mkWV (k67 "epäillä") ; --UNCHK
lin disbelieve_V2 = mkWV2 (k67 "epäillä") ; --UNCHK
lin disbeliever_N = mkWN (k4A "skeptikko") ; --UNCHK
lin disbelievingly_Adv = mkWAdv (k99 "epäuskoisesti") ; --UNCHK
lin disbud_V2 = mkWV2 (k71 "tehdä") "sarvettomaksi" ; --UNCHK
lin disburden_V2 = mkWV2 (k53 "poistaa") ; --UNCHK
lin disburse_V = mkWV (k53A "suorittaa") "maksu" ; --UNCHK
lin disburse_V2 = mkWV2 (k53A "suorittaa") "maksu" ; --UNCHK
lin disbursement_N = mkWN (compoundN "rahan" (k1A "käyttö")) ; --UNCHK
lin disc_N = mkWN (k38 "lautanen") ; --UNCHK
lin discalced_A = mkWA (compoundA "paljas" (k38 "jalkainen")) ; --UNCHK
lin discard_N = mkWN (compoundN "hei" (k38 "ttäminen")) "pois" ; --UNCHK
lin discard_V2 = mkWV2 (k73A "hylätä") ;
lin discern_V2 = mkWV2 (k74 "tajuta") ; --UNCHK
lin discernability_N = mkWN (k40 "luettavuus") ; --UNCHK
lin discernible_A = mkWA (k10 "näkyvä") ; --UNCHK
lin discerning_A = mkWA (compoundA "tarkka" (k38 "näköinen")) ; --UNCHK
lin discernment_N = mkWN (compoundN "harkinta" (k1A "kyky")) ; --UNCHK
lin discharge_N = mkWN (k2 "laukaisu") ; --UNCHK
lin discharge_V = mkWV (k53A "vapauttaa") ; --UNCHK
lin discharge_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin disciform_A = mkWA (compoundA "kiekko" (k38 "mainen")) ; --UNCHK
lin disciple_N = mkWN (k10 "kannattaja") ; --UNCHK
lin discipleship_N = mkWN (k41 "oppilas") ; --UNCHK
lin disciplinarian_N = mkWN (k5 "moralisti") ; --UNCHK
lin disciplinary_A = mkWA "oppisuunnan" ; --UNCHK
lin discipline_N = mkWN (k39 "harjoitus") ; --UNCHK
lin discipline_V2 = mkWV2 (k54A "ojentaa") ; --UNCHK
lin disclaim_V2 = mkWV2 (k52A "vetäytyä") "jstk" ; --UNCHK
lin disclaim_VS = mkWVS (k52A "vetäytyä") "jstk" ; --UNCHK
lin disclaimer_N = mkWN (compoundN "kii" (k38 "stäminen")) ; --UNCHK
lin disclose_V = mkWV (k52A "kertoa") ;
lin disclose_V2 = mkV2 (lin VK {s = c53 "paljastaa"}) ;
lin disclose_VS = mkWVS (k52A "kertoa") ; --UNCHK
lin disclosure_N = mkN "paljastaminen" ;
lin disco_1_N = mkN "disko" ;
lin disco_2_N = mkN "disko" ;
lin discography_N = mkWN (k12 "diskografia") ; --UNCHK
lin discoid_A = mkWA (k38 "muotoinen") "kiekon" ; --UNCHK
lin discoloration_N = mkWN (compoundN "haa" (k38 "listuminen")) ; --UNCHK
lin discolour_V = mkWV (k52A "värjääntyä") ; --UNCHK
lin discolour_V2 = mkWV2 (k52A "värjääntyä") ; --UNCHK
lin discolouration_N = mkWN (compoundN "haa" (k38 "listuminen")) ; --UNCHK
lin discombobulated_A = mkWA (k10 "oleva") "hämillään" ; --UNCHK
lin discomfit_V2 = mkWV2 (k53A "hermostuttaa") ; --UNCHK
lin discomfiture_N = mkWN (k40 "nolous") ; --UNCHK
lin discomfort_N = mkWN (k1A "ahdinko") ; --UNCHK
lin discompose_V2 = mkWV2 (k53A "hermostuttaa") ; --UNCHK
lin discomposure_N = mkWN (k40 "levottomuus") ; --UNCHK
lin discomycete_N = mkWN (compoundN "kotelo" (k38 "maljainen")) ; --UNCHK
lin discomycetous_A = mkWA "kotelomaljaisiin" "liittyvä" ; --UNCHK
lin disconcert_V2 = mkWV2 (k53A "hermostuttaa") ; --UNCHK
lin disconcerting_A = mkWA (k38 "kiusallinen") ; --UNCHK
lin disconfirming_A = mkWA (k38 "negatiivinen") ; --UNCHK
lin disconnect_V2 = mkV2 (mkV (mkV "katkaista") "yhteys") illative ;
lin disconnection_N = mkWN (compoundN "katka" (k38 "iseminen")) "yhteyden" ; --UNCHK
lin disconsolate_A = mkWA (k38 "murheellinen") ; --UNCHK
lin discontent_N = mkWN (k40 "tyytymättömyys") ; --UNCHK
lin discontent_V2 = mkWV2 (k71 "tehdä") "tyytymättömäksi" ; --UNCHK
lin discontentedly_Adv = mkWAdv (k99 "tyytymättömästi") ; --UNCHK
lin discontentment_N = mkWN (k40 "tyytymättömyys") ; --UNCHK
lin discontinuance_N = mkWN (k39 "keskeytys") ; --UNCHK
lin discontinue_V = mkWV (k53A "keskeyttää") ; --UNCHK
lin discontinue_V2 = mkWV2 (k53A "keskeyttää") ;
lin discontinuity_N = mkWN (k39 "keskeytys") ; --UNCHK
lin discontinuous_A = mkWA (k38 "katkonainen") ; --UNCHK
lin discord_N = mkWN (k10 "eripura") ; --UNCHK
lin discordance_N = mkWN (k10 "eripura") ; --UNCHK
lin discordant_A = mkWA (compoundA "sora" (k38 "ääninen")) ; --UNCHK
lin discorporate_A = mkWA (k34A "aineeton") ; --UNCHK
lin discotheque_N = mkWN (k5A "diskoteekki") ; --UNCHK
lin discount_N = mkN "alennus" ;
lin discount_V = mkWV (k73 "tyrmätä") ; --UNCHK
lin discount_V2 = mkWV2 (k73 "tyrmätä") ; --UNCHK
lin discountenance_V2 = mkWV2 (k52 "paheksua") ; --UNCHK
lin discourage_V2 = mkV2 "lannistaa" ;
lin discouragement_N = mkWN (compoundN "ehkä" (k38 "iseminen")) ; --UNCHK
lin discouraging_A = mkWA "lannistava" ; --UNCHK
lin discourse_N = mkWN (k10 "tutkielma") ; --UNCHK
lin discourse_V = mkWV (k52 "puhua") "paljon" ; --UNCHK
lin discourteous_A = mkWA (compoundA "epä" (k41 "kohtelias")) ; --UNCHK
lin discourtesy_N = mkWN (k38 "käyttäytyminen") "loukkaava" ; --UNCHK
lin discover_V = mkV "löytää" ;
lin discover_V2 = mkV2 "löytää" ;
lin discover_VS = mkWVS (k63 "saada") "tietää" ;
lin discovererFem_N = mkWN (k12 "tarkkailija") ; --UNCHK
lin discovererMasc_N = mkWN (k12 "tarkkailija") ; --UNCHK
lin discovery_N = mkN "löytö" ;
lin discredit_N = mkWN (k15 "häpeä") ; --UNCHK
lin discredit_V2 = mkV2 (mkV (mkV "saattaa") "huonoon valoon") ; --mkWV2 (k67 "epäillä") ;
lin discreditable_A = mkWA (k10 "alentava") ; --UNCHK
lin discreet_A = mkWA (k1A "hillitty") ; --UNCHK
lin discrepancy_N = mkWN (k40 "eroavuus") ;
lin discrepant_A = mkWA (k10 "poikkeava") "jstak" ; --UNCHK
lin discrete_A = mkWA (k38 "itsenäinen") ; --UNCHK
lin discreteness_N = mkWN (k40 "irrallisuus") ; --UNCHK
lin discretion_N = mkWN (compoundN "harkinta" (k1A "kyky")) ;
lin discretionary_A = mkA "harkinnanvarainen" ;
lin discriminable_A = mkWA "erottuva" ; --UNCHK
lin discriminate_A = mkWA (compoundA "arvosteluky" (k38 "kyinen")) ; --UNCHK
lin discriminate_V = mkWV (k71 "tehdä") "ero" ; --UNCHK
lin discriminate_V2 = mkWV2 (k71 "tehdä") "ero" ; --UNCHK
lin discrimination_N = mkWN (k9A "syrjintä") ; --UNCHK
lin discriminative_A = mkWA (k9A "tarkka") ; --UNCHK
lin discriminatory_A = mkA "erotteleva" ;
lin discursive_A = mkWA (k10 "poikkeava") "aiheesta" ; --UNCHK
lin discursiveness_N = mkWN (k2 "kiertely") ; --UNCHK
lin discus_N = mkWN (k1A "kiekko") ; --UNCHK
lin discuss_V2 = mkV2 "keskustella" elative ;
lin discuss_VS = mkVS "keskustella" ;
lin discussant_N = mkWN (k12 "keskustelija") ; --UNCHK
lin discussion_N = mkN "keskustelu" ;
lin disdain_N = mkWN (k40 "alentuvuus") ; --UNCHK
lin disdain_V2 = mkWV2 (k67 "olla") "hyväksymättä" ; --UNCHK
lin disdainful_A = mkWA (k15 "ylpeä") ; --UNCHK
lin disease_N = mkWN (k5A "tauti") ;
lin diseased_A = mkWA (k38 "patologinen") ; --UNCHK
lin disembark_V = mkWV (k52 "astua") "maihin" ; --UNCHK
lin disembark_V2 = mkWV2 (k52 "astua") "maihin" ; --UNCHK
lin disembarkation_N = mkWN (compoundN "maihin" (k1 "nousu")) ; --UNCHK
lin disembarrass_V2 = mkWV2 (k53 "päästää") ; --UNCHK
lin disembarrassment_N = mkWN "helpottaa" "hämmennystä" ; --UNCHK
lin disembody_V2 = mkWV2 (k53A "vapauttaa") "jstk" ; --UNCHK
lin disembowel_V2 = mkWV2 (k53 "poistaa") "sisälmykset" ; --UNCHK
lin disembowelment_N = mkWN (k1 "poisto") "sisusten" ; --UNCHK
lin disenchant_V2 = mkV2 (mkV (mkV "rikkoa") "lumous") ;
lin disenchanting_A = mkWA "harhakuvitelmista" "herättävä" ; --UNCHK
lin disenchantment_N = mkWN (compoundN "pois" (k38 "taminen")) "harhakuvitelmien" ; --UNCHK
lin disencumber_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin disenfranchise_V2 = mkWV2 (k73A "evätä") "äänioikeus" ; --UNCHK
lin disenfranchisement_N = mkWN (compoundN "irti" (k38 "sanominen")) "toimiluvan" ; --UNCHK
lin disengage_V = mkWV (k53A "vapauttaa") ; --UNCHK
lin disengage_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin disengagement_N = mkWN (compoundN "per" (k38 "ääntyminen")) ; --UNCHK
lin disentangle_V = mkWV (k53A "selvittää") ; --UNCHK
lin disentangle_V2 = mkWV2 (k53A "selvittää") ; --UNCHK
lin disentanglement_N = mkWN (compoundN "vapa" (k38 "uttaminen")) ; --UNCHK
lin disentangler_N = mkWN (k10 "selvittäjä") ; --UNCHK
lin disequilibrium_N = mkWN "epätasapaino" ; --UNCHK
lin disesteem_N = mkWN (k10 "asema") "halveksittu" ; --UNCHK
lin disfavor_N = mkWN (k9A "paheksunta") ; --UNCHK
lin disfavour_N = mkWN (k9A "paheksunta") ; --UNCHK
lin disfavour_V2 = mkWV2 (k67 "olla") "haitaksi" ; --UNCHK
lin disfigure_V2 = mkWV2 (k53A "vahingoittaa") ; --UNCHK
lin disfigurement_N = mkWN (compoundN "pila" (k38 "aminen")) ; --UNCHK
lin disfluency_N = mkWN (k40 "taitamattomuus") ; --UNCHK
lin disforest_V2 = mkWV2 (k53 "poistaa") "metsä" ; --UNCHK
lin disfranchise_V2 = mkWV2 (k73A "evätä") "äänioikeus" ; --UNCHK
lin disfranchisement_N = mkWN (compoundN "epä" (k38 "äminen")) ; --UNCHK
lin disgorge_V2 = mkWV2 (k53A "heittää") "laattaa" ; --UNCHK
lin disgrace_N = mkWN (k39 "nöyryytys") ; --UNCHK
lin disgrace_V2 = mkWV2 (k66 "häpäistä") ; --UNCHK
lin disgraceful_A = mkWA (k34A "kunniaton") ; --UNCHK
lin disgruntled_A = mkWA (k34A "tyytymätön") ; --UNCHK
lin disgruntlement_N = mkWN (k40 "tyytymättömyys") ; --UNCHK
lin disguise_N = mkWN (k5A "naamiointi") ; --UNCHK
lin disguise_V2 = mkWV2 (k73 "salata") ; --UNCHK
lin disgust_N = mkWN (k1 "inho") ; --UNCHK
lin disgust_V2 = mkWV2 (k53A "kuvottaa") ; --UNCHK
lin disgustedly_Adv = mkWAdv "inhoten" ; --UNCHK
lin disgusting_A = mkWA (k15 "törkeä") ; --UNCHK
lin disgustingness_N = mkWN (k40 "inhottavuus") ; --UNCHK
lin dish_N = mkN "annos" ; ---ARB --mkWN (k1A "juttu") ;
lin dish_V2 = mkWV2 (k54A "kovertaa") ; --UNCHK
lin dish_out_V2 = mkWV2 (k73 "pilata") ; --UNCHK
lin dish_up_V2 = mkWV2 (k73 "pilata") ; --UNCHK
lin dishabille_N = mkWN (k99 "puolipukeissa") ; --UNCHK
lin disharmonious_A = mkWA (compoundA "riita" (k38 "sointuinen")) ; --UNCHK
lin disharmony_N = mkWN (compoundN "epä" (k1A "sointu")) ; --UNCHK
lin dishcloth_N = mkWN (compoundN "tiski" (k5A "rätti")) ; --UNCHK
lin dishearten_V2 = mkWV2 (k54A "masentaa") ; --UNCHK
lin disheartenment_N = mkWN (k39 "vastustus") ; --UNCHK
lin disheveled_A = mkWA (k38 "ryppyinen") ; --UNCHK
lin dishevelled_A = mkWA (k38 "ryppyinen") ; --UNCHK
lin dishful_N = mkWN (k38 "vadillinen") ; --UNCHK
lin dishonest_A = mkWA (k38 "häpeällinen") ; --UNCHK
lin dishonesty_N = mkWN (compoundN "epä" (k40 "rehellisyys")) ; --UNCHK
lin dishonorable_A = mkWA (k38 "häpeällinen") ; --UNCHK
lin dishonorableness_N = mkWN (compoundN "häpeäll" (k40 "isyys")) ; --UNCHK
lin dishonour_N = mkWN (k15 "häpeä") ; --UNCHK
lin dishonour_V2 = mkWV2 (k73A "hylätä") ; --UNCHK
lin dishonourable_A = mkWA (k38 "valheellinen") ; --UNCHK
lin dishpan_N = mkWN (compoundN "tiski" (k1A "soikko")) ; --UNCHK
lin dishrag_N = mkWN (compoundN "tiski" (k5A "rätti")) ; --UNCHK
lin dishtowel_N = mkWN (compoundN "astia" (k48A "pyyhe")) ; --UNCHK
lin dishwasher_N = mkWN (compoundN "tiski" (k48 "kone")) ;
lin dishwashing_N = mkWN (k1 "pesu") "astioiden" ; --UNCHK
lin dishwater_N = mkWN (compoundN "tiski" (k27 "vesi")) ; --UNCHK
lin dishy_A = mkWA (compoundA "hyvän" (k38 "näköinen")) ; --UNCHK
lin disillusion_N = mkWN (compoundN "pois" (k38 "taminen")) "harhakuvitelmien" ; --UNCHK
lin disillusionment_N = mkWN (compoundN "pois" (k38 "taminen")) "harhakuvitelmien" ; --UNCHK
lin disincentive_N = mkWN (k48 "este") ; --UNCHK
lin disinclination_N = mkWN (k40 "innottomuus") ; --UNCHK
lin disincline_V2 = mkWV2 (k67 "olla") "vastahakoinen" ; --UNCHK
lin disincline_V2V = mkWV2V (k67 "olla") "vastahakoinen" ; --UNCHK
lin disinfect_V2 = mkWV2 (k62 "desinfioida") ; --UNCHK
lin disinfectant_A = mkWA (compoundA "desinfi" (k10 "oiva")) ; --UNCHK
lin disinfectant_N = mkWN (compoundN "mikrobi" (k48A "lääke")) ; --UNCHK
lin disinfection_N = mkWN (k5A "desinfiointi") ; --UNCHK
lin disinfest_V2 = mkWV2 (k74 "tuhota") "syöpäläiset" ; --UNCHK
lin disinfestation_N = mkWN (k9A "torjunta") "syöpäläisten" ; --UNCHK
lin disinflation_N = mkWN (k3 "deflaatio") ; --UNCHK
lin disinformation_N = mkWN (k1A "tieto") "tarkoituksellisen" "harhaanjohtava" ; --UNCHK
lin disingenuous_A = mkWA (k38 "teennäinen") ; --UNCHK
lin disingenuousness_N = mkWN (k40 "petollisuus") ; --UNCHK
lin disinherit_V2 = mkWV2 (k71 "tehdä") "perinnöttömäksi" ; --UNCHK
lin disinheritance_N = mkWN (k38 "tekeminen") "perinnöttömäksi" ; --UNCHK
lin disintegrate_V = mkWV (k74 "hajota") ; --UNCHK
lin disintegrate_V2 = mkWV2 (k74 "hajota") ; --UNCHK
lin disintegration_N = mkWN (compoundN "dis" (k3 "integraatio")) ; --UNCHK
lin disintegrative_A = mkWA (compoundA "haj" (k10 "ottava")) ; --UNCHK
lin disinter_V2 = mkWV2 (k56 "kaivaa") "haudasta" ; --UNCHK
lin disinterest_N = mkWN (k40 "puolueettomuus") ; --UNCHK
lin disinterested_A = mkWA (compoundA "epä" (k41A "itsekäs")) ; --UNCHK
lin disinterestedness_N = mkWN (compoundN "epä" (k40 "itsekkyys")) ; --UNCHK
lin disinterment_N = mkWN (compoundN "kai" (k38 "vaminen")) "esiin" ; --UNCHK
lin disinvestment_N = mkWN (compoundN "des" (k5A "investointi")) ; --UNCHK
lin disjoined_A = mkWA (compoundA "ero" (k1 "tettu")) ; --UNCHK
lin disjoint_A = mkWA (k38 "irrallinen") ; --UNCHK
lin disjoint_V2 = mkWV2 (k53A "irrottaa") ; --UNCHK
lin disjointedly_Adv = mkWAdv (k99 "sekavasti") ; --UNCHK
lin disjointedness_N = mkWN (k40 "sekavuus") ; --UNCHK
lin disjunct_A = mkWA (k38 "hyppäyksittäinen") ; --UNCHK
lin disjunction_N = mkWN (compoundN "katka" (k38 "iseminen")) "yhteyden" ; --UNCHK
lin disjunctive_A = mkWA "erottava" ; --UNCHK
lin disk_N = mkN (lin NK {s = d01 "levy"}) ;
lin diskette_N = mkWN (k1A "korppu") ; --UNCHK
lin dislikable_A = mkWA (compoundA "epä" (k10 "miellyttävä")) ; --UNCHK
lin dislike_N = mkWN (k9A "paheksunta") ; --UNCHK
lin dislike_V2 = mkV2 "inhota" partitive ; --WV2 (k53A "pitää") "vastenmielisenä" ;
lin dislocate_V2 = mkWV2 (k54A "siirtää") ; --UNCHK
lin dislocation_N = mkWN (k3 "häiriö") ; --UNCHK
lin dislodge_V2 = mkWV2 (k54A "työntää") "syrjään" ; --UNCHK
lin dislodgement_N = mkWN (compoundN "syrjä" (k38 "yttäminen")) ; --UNCHK
lin dislodgment_N = mkWN (compoundN "syrjä" (k38 "yttäminen")) ; --UNCHK
lin disloyal_A = mkWA (k38 "petollinen") ; --UNCHK
lin disloyalty_N = mkWN (compoundN "epä" (k40 "lojaalius")) ; --UNCHK
lin dismal_A = mkWA (k15 "synkeä") ; --UNCHK
lin dismantle_V2 = mkV2 "purkaa" ; --mkWV2 (k61A "repiä") ;
lin dismantlement_N = mkWN (k1A "purku") ; --UNCHK
lin dismantling_N = mkWN (k1A "purku") ; --UNCHK
lin dismay_N = mkWN (k39 "tyrmistys") ; --UNCHK
lin dismay_V = mkWV (k53A "pelästyttää") ; --UNCHK
lin dismay_V2 = mkWV2 (k53A "pelästyttää") ; --UNCHK
lin dismember_V2 = mkWV2 (k53A "irrottaa") "raajat" ; --UNCHK
lin dismemberment_N = mkWN (k2 "paloittelu") ; --UNCHK
lin dismiss_V2 = mkV2 (mkV "hylätä" "hylkäsi") ;
lin dismissal_N = mkWN (k39 "vapautus") ; --UNCHK
lin dismissible_A = mkWA "erotettava" ; --UNCHK
lin dismissive_A = mkWA "viraltapano-" ; --UNCHK
lin dismount_N = mkWN (compoundN "alas" (k1 "tulo")) ; --UNCHK
lin disobedience_N = mkN "itsepäisyys" ;
lin disobedient_A = mkWA (k34A "tottelematon") ; --UNCHK
lin disobey_V2 = mkWV2 (k67 "olla") "tottelematon" ; --UNCHK
lin disobliging_A = mkWA (k15 "töykeä") ; --UNCHK
lin disorder_N = mkN "epäjärjestys" ;
lin disorderliness_N = mkWN (k40 "sekaisuus") ; --UNCHK
lin disorderly_A = mkWA (k10 "tuottava") "häiriötä" ; --UNCHK
lin disorganization_N = mkWN (compoundN "aihe" (k38 "uttaminen")) "hajaannuksen" ; --UNCHK
lin disorganize_V2 = mkWV2 (k58 "sotkea") ; --UNCHK
lin disorient_V2 = mkWV2 (k53A "harhauttaa") ; --UNCHK
lin disorientate_V2 = mkWV2 (k53A "harhauttaa") ; --UNCHK
lin disorientation_N = mkWN (k39 "hämmennys") ; --UNCHK
lin disorienting_A = mkWA "hämmentävä" ; --UNCHK
lin disown_V2 = mkWV2 (k73A "hylätä") ; --UNCHK
lin disownment_N = mkWN "kieltäminen" ; --UNCHK
lin disparage_V2 = mkWV2 (k54A "halventaa") ; --UNCHK
lin disparagement_N = mkWN (k10A "väheksyntä") ; --UNCHK
lin disparagingly_Adv = mkWAdv (k99 "halventavasti") ; --UNCHK
lin disparate_A = mkWA (k38 "erilainen") ; --UNCHK
lin disparateness_N = mkWN (k40 "erilaisuus") ; --UNCHK
lin disparity_N = mkWN (k40 "eroavuus") ; --UNCHK
lin dispassion_N = mkWN (k40 "arkipäiväisyys") ; --UNCHK
lin dispassionate_A = mkWA (k38 "maltillinen") ; --UNCHK
lin dispassionateness_N = mkWN (k40 "arkipäiväisyys") ; --UNCHK
lin dispatch_N = mkWN (k39 "toimitus") ; --UNCHK
lin dispatch_V2 = mkWV2 (k56A "tappaa") ; --UNCHK
lin dispatch_V2V = mkWV2V (k56A "tappaa") ; --UNCHK
lin dispatch_box_N = mkWN (compoundN "asiakirja" (k2 "kotelo")) ; --UNCHK
lin dispatch_rider_N = mkWN (compoundN "pika" (k5A "lähetti")) ; --UNCHK
lin dispatcher_N = mkWN (k10 "lähettäjä") ; --UNCHK
lin dispel_V2 = mkWV2 (k54A "hälventää") ; --UNCHK
lin dispensability_N = mkWN (k40 "tarpeettomuus") ; --UNCHK
lin dispensable_A = mkWA (k10 "turha") ; --UNCHK
lin dispensary_N = mkWN (k12 "neuvola") ; --UNCHK
lin dispensation_N = mkWN (k2 "jakelu") ; --UNCHK
lin dispense_V = mkWV (k56A "jakaa") ; --UNCHK
lin dispense_V2 = mkWV2 (k56A "jakaa") ; --UNCHK
lin dispenser_N = mkWN (compoundN "jakelu" (k48A "laite")) ; --UNCHK
lin dispersal_N = mkWN (k39 "levitys") ; --UNCHK
lin disperse_V = mkWV (k53A "hajottaa") ; --UNCHK
lin disperse_V2 = mkWV2 (k53A "hajottaa") ; --UNCHK
lin dispersion_N = mkWN (k39 "levitys") ; --UNCHK
lin dispirit_V2 = mkWV2 (k53 "ahdistaa") ; --UNCHK
lin dispiritedly_Adv = mkWAdv (k99 "toivottomasti") ; --UNCHK
lin displace_V2 = mkWV2 (k64 "viedä") ; --UNCHK
lin displacement_N = mkWN (compoundN "syrjä" (k38 "yttäminen")) ; --UNCHK
lin display_N = mkN "näyttö" ; ---ARB mkWN (k2 "näyttely") ;
lin display_V2 = mkV2 "näyttää" ;
lin display_VS = variants {} ; -- mkV2 "näyttää" ;
lin displease_V2 = mkWV2 (k53A "pahastuttaa") ; --UNCHK
lin displeasing_A = mkWA (compoundA "epä" (k10 "mieluisa")) ; --UNCHK
lin displeasure_N = mkWN (k40 "tyytymättömyys") ; --UNCHK
lin disport_V2 = mkWV2 (k68 "karkeloida") ; --UNCHK
lin disposable_A = mkWA (compoundA "kertakäytt" (k38 "öinen")) ; --UNCHK
lin disposable_N = mkWN (compoundN "kertakäyttö" (k12 "tavara")) ; --UNCHK
lin disposal_N = mkWN (compoundN "hei" (k38 "ttäminen")) "pois" ; --UNCHK
lin dispose_V = mkWV (k53A "kelpuuttaa") ; --UNCHK
lin dispose_V2 = mkWV2 (k53A "kelpuuttaa") ; --UNCHK
lin disposition_N = mkWN (compoundN "hei" (k38 "ttäminen")) "pois" ; --UNCHK
lin dispossess_V2 = mkWV2 (k53 "riistää") ; --UNCHK
lin dispossession_N = mkWN (k1A "häätö") ; --UNCHK
lin disproof_N = mkWN "vääräksi" "osoittaminen" ; --UNCHK
lin disproportion_N = mkWN "epäsuhtaisuus" ; --UNCHK
lin disproportionate_A = mkWA (k34A "suhteeton") ;
lin disprove_V2 = mkWV2 (k53A "osoittaa") "vääräksi" ; --UNCHK
lin disprove_VS = mkWVS (k53A "osoittaa") "vääräksi" ; --UNCHK
lin disputable_A = mkWA (k34A "selvittämätön") ; --UNCHK
lin disputant_N = mkWN (k1A "poleemikko") ; --UNCHK
lin disputation_N = mkWN (k2 "keskustelu") ; --UNCHK
lin disputatious_A = mkWA (k10 "riitaisa") ; --UNCHK
lin dispute_N = mkWN (k2 "väittely") ;
lin dispute_V = mkWV (k67A "väitellä") ; --UNCHK
lin dispute_V2 = mkWV2 (k67A "väitellä") ; --UNCHK
lin disqualification_N = mkWN (k5A "diskvalifiointi") ; --UNCHK
lin disqualify_V2 = mkV2 "diskvalifioida" ; --WV2 (k73 "jäävätä") ;
lin disquiet_N = mkWN (k40 "huolestuneisuus") ; --UNCHK
lin disquiet_V2 = mkWV2 (k52 "huolestua") ; --UNCHK
lin disquieting_A = mkWA "levottomuutta" "herättävä" ; --UNCHK
lin disquietude_N = mkWN (k40 "rauhattomuus") ; --UNCHK
lin disquisition_N = mkWN (k10 "tutkielma") ; --UNCHK
lin disregard_N = mkWN (k40 "välinpitämättömyys") ; --UNCHK
lin disregard_V2 = mkWV2 (k67 "olla") "piittaamatta" ; --UNCHK
lin disrepair_N = mkWN (k1A "kunto") "huono" ; --UNCHK
lin disreputable_A = mkWA (compoundA "huono" (k38 "maineinen")) ; --UNCHK
lin disrepute_N = mkWN (k15 "häpeä") ; --UNCHK
lin disrespect_N = mkWN (k10A "halveksunta") ; --UNCHK
lin disrespectful_A = mkWA (compoundA "epä" (k10 "kunnioittava")) ; --UNCHK
lin disrobe_V = mkWV (k52A "riisuuntua") ; --UNCHK
lin disrobe_V2 = mkWV2 (k52A "riisuuntua") ; --UNCHK
lin disrupt_V = mkWV (k66 "katkaista") ; --UNCHK
lin disrupt_V2 = mkWV2 (k66 "katkaista") ; --UNCHK
lin disruption_N = mkWN (k5 "väli") ; --UNCHK
lin disruptive_A = mkWA (k15 "kiihkeä") ; --UNCHK
lin dissatisfaction_N = mkWN (k40 "tyytymättömyys") ; --UNCHK
lin dissatisfy_V2 = mkWV2 (k71 "tehdä") "tyytymättömäksi" ; --UNCHK
lin dissect_V2 = mkWV2 (k52 "ratkoa") ; --UNCHK
lin dissection_N = mkWN (compoundN "dis" (k3 "sektio")) ; --UNCHK
lin dissemble_V = mkWV (k53A "esittää") ; --UNCHK
lin dissemble_V2 = mkWV2 (k53A "esittää") ; --UNCHK
lin dissembler_N = mkWN (k10 "petkuttaja") ; --UNCHK
lin disseminate_V = mkWV (k74 "juoruta") ; --UNCHK
lin disseminate_V2 = mkWV2 (k74 "juoruta") ; --UNCHK
lin dissemination_N = mkWN (k39 "levitys") ; --UNCHK
lin dissension_N = mkWN (k10 "eripura") ; --UNCHK
lin dissent_N = mkWN (k39 "vastustus") ; --UNCHK
lin dissent_V = mkV vOlla "eri mieltä" ;
lin dissenter_N = mkN "toisin" (mkN "ajattelija") ; --mkWN (k5A "dissidentti") ;
lin dissentient_A = mkWA (k10 "toisinajatteleva") ; --UNCHK
lin dissentious_A = mkWA (compoundA "ryhmä" (k38 "kuntainen")) ; --UNCHK
lin dissertation_N = mkWN (k10 "tutkielma") "tieteellinen" ; --UNCHK
lin disservice_N = mkWN (compoundN "karhun" (k39 "palvelus")) ; --UNCHK
lin dissever_V2 = mkWV2 (k56A "jakaa") ; --UNCHK
lin dissidence_N = mkWN (compoundN "mielipide-" (k1 "ero")) ; --UNCHK
lin dissident_A = mkWA (k10 "toisinajatteleva") ; --UNCHK
lin dissident_N = mkWN (k5A "dissidentti") ;
lin dissilience_N = mkWN (compoundN "esiin" (k1 "tulo")) "siementen" ; --UNCHK
lin dissilient_A = mkWA "lohkeava" ; --UNCHK
lin dissimilar_A = mkWA (k38 "erilainen") ; --UNCHK
lin dissimilarity_N = mkWN (k40 "poikkeavuus") ; --UNCHK
lin dissimilation_N = mkWN (compoundN "aineen" (k9A "vaihdunta")) "hajottava" ; --UNCHK
lin dissimilitude_N = mkWN (k40 "erilaisuus") ; --UNCHK
lin dissimulate_V = mkWV (k73 "salata") ; --UNCHK
lin dissimulate_V2 = mkWV2 (k73 "salata") ; --UNCHK
lin dissimulation_N = mkWN (k39 "huiputus") ; --UNCHK
lin dissimulative_A = mkWA (compoundA "peite" (k1 "tty")) ; --UNCHK
lin dissipate_V = mkWV (k53A "kuluttaa") ; --UNCHK
lin dissipate_V2 = mkWV2 (k53A "kuluttaa") ; --UNCHK
lin dissipation_N = mkWN (k10A "hukka") ; --UNCHK
lin dissociable_A = mkWA (k10 "oleva") "erotettavissa" ; --UNCHK
lin dissociate_V2 = mkWV2 (k74 "hajota") ; --UNCHK
lin dissociation_N = mkWN "jakautuminen" ; --UNCHK
lin dissociative_A = mkWA (compoundA "dissosi" (k10 "oiva")) ; --UNCHK
lin dissolubility_N = mkWN (k40 "liukenevuus") ; --UNCHK
lin dissoluble_A = mkWA (compoundA "liuke" (k9 "neva")) ; --UNCHK
lin dissolute_A = mkWA (k38 "paheellinen") ; --UNCHK
lin dissoluteness_N = mkWN (k40 "huikentelevuus") ; --UNCHK
lin dissolution_N = mkWN (compoundN "ero" (k38 "aminen")) ; --UNCHK
lin dissolvable_A = mkWA (compoundA "liuke" (k9 "neva")) ; --UNCHK
lin dissolve_N = mkWN (compoundN "risti" (k10 "kuva")) ; --UNCHK
lin dissolve_V = mkWV (k53A "hajottaa") ; --UNCHK
lin dissolve_V2 = mkWV2 (k53A "hajottaa") ; --UNCHK
lin dissolving_N = mkWN (k39 "liuotus") ; --UNCHK
lin dissonance_N = mkWN (k5 "dissonanssi") ; --UNCHK
lin dissonant_A = mkWA (k10 "poikkeava") "jstak" ; --UNCHK
lin dissuade_V2 = mkWV2 (k63 "saada") "luopumaan" ; --UNCHK
lin dissuasion_N = mkWN (k39 "varoitus") ; --UNCHK
lin dissuasive_A = mkWA (k10 "kieltävä") ; --UNCHK
lin dissyllable_N = mkWN (k9 "sana") "kaksitavuinen" ; --UNCHK
lin distaff_N = mkWN (k12 "värttinä") ; --UNCHK
lin distal_A = mkWA (k36 "uloin") ; --UNCHK
lin distance_N = mkWN (compoundN "väli" (k9 "matka")) ; --UNCHK
lin distance_N3 = L.distance_N3 ;
lin distance_V2 = mkWV2 (k53A "jättää") "jälkeensä" ; --UNCHK
lin distant_A = mkWA (k38 "kaukainen") ;
lin distaste_N = mkWN (k1 "inho") ; --UNCHK
lin distasteful_A = mkWA (k15 "törkeä") ; --UNCHK
lin distastefulness_N = mkWN (k40 "inhottavuus") ; --UNCHK
lin distemper_N = mkWN (k39 "temperamaalaus") ; --UNCHK
lin distend_V = mkWV (k52 "pullistua") ; --UNCHK
lin distend_V2 = mkWV2 (k52 "pullistua") ; --UNCHK
lin distensible_A = mkWA (compoundA "laaje" (k9 "neva")) ; --UNCHK
lin distension_N = mkWN (k10 "laajentuma") ; --UNCHK
lin distention_N = mkWN (k10 "laajentuma") ; --UNCHK
lin distil_V = mkWV (k53A "tiputtaa") ; --UNCHK
lin distil_V2 = mkWV2 (k53A "tiputtaa") ; --UNCHK
lin distillate_N = mkWN (k48 "tisle") ; --UNCHK
lin distillation_N = mkWN (k39 "tislaus") ; --UNCHK
lin distiller_N = mkWN (k2 "tislaamo") ; --UNCHK
lin distillery_N = mkWN (k2 "tislaamo") ; --UNCHK
lin distinct_A = mkWA "erottuva" ;
lin distinction_N = mkWN (k1 "ero") ;
lin distinctive_A = mkWA (k38 "tyypillinen") ; --UNCHK
lin distinctiveness_N = mkWN (k40 "erilaisuus") ; --UNCHK
lin distinctness_N = mkWN (k40 "tarkkuus") ; --UNCHK
lin distinguish_V = mkWV (k73 "huomata") "ero" ; --UNCHK
lin distinguish_V2 = mkV2 "erottaa" partitive ; --mkWV2 (k73 "huomata") "ero" ;
lin distinguishable_A = mkWA "erottuva" ; --UNCHK
lin distinguished_A = variants {} ; --
lin distort_V2 = mkV2 "vääristää" ; --mkWV2 (k54A "rumentaa") ;
lin distortable_A = mkWA "vääristeltävä" ; --UNCHK
lin distortion_N = mkWN (k10 "vääristymä") ; --UNCHK
lin distortionist_N = mkWN (kH1 "maalari") "vääristymiä" "käyttävä" ; --UNCHK
lin distract_V = mkWV (k52 "huolestua") ; --UNCHK
lin distract_V2 = mkWV2 (k52 "huolestua") ; --UNCHK
lin distractedly_Adv = mkWAdv (compoundAdv "poissaolev" (k99 "asti")) ; --UNCHK
lin distraction_N = mkWN "harhaan" "johtaminen" ; --UNCHK
lin distrain_V = mkWV (k62 "takavarikoida") ; --UNCHK
lin distraint_N = mkWN (compoundN "ulos" (k1A "otto")) ; --UNCHK
lin distraught_A = mkWA (k99 "sekaisin") ; --UNCHK
lin distress_N = mkWN (compoundN "ulos" (k1A "otto")) ; --UNCHK
lin distress_V2 = mkWV2 (k53 "ahdistaa") ; --UNCHK
lin distressful_A = mkWA (compoundA "hermos" (k10 "tuttava")) ; --UNCHK
lin distressing_A = mkWA (k38 "surullinen") ; --UNCHK
lin distributary_N = mkWN (compoundN "suu" (k9 "haara")) ; --UNCHK
lin distribute_V2 = mkV2 "levittää" ; --f63
lin distributed_A = variants {} ; --
lin distribution_N = mkN (lin NK {s = d02 "jakelu"}) ;
lin distributional_A = mkWA "jakelu-" ; --UNCHK
lin distributive_A = mkWA "jakelu-" ; --UNCHK
lin distributor_N = mkN "jakelija" ;
lin district_N = mkN "piiri" ;
lin distrust_N = mkWN (k39 "epäilys") ; --UNCHK
lin distrust_V2 = mkWV2 (k67 "epäillä") ; --UNCHK
lin distrustful_A = mkWA (k10 "epäilevä") ; --UNCHK
lin distrustfulness_N = mkWN (k39 "epäilys") ; --UNCHK
lin disturb_V2 = mkWV2 (k53A "vahingoittaa") ; --UNCHK
lin disturbance_N = mkWN (k9A "häirintä") ; --UNCHK
lin disturber_N = mkWN (k4A "häirikkö") ; --UNCHK
lin disturbing_A = variants {} ;
lin disulfiram_N = mkWN "Antabus" ; --UNCHK
lin disunion_N = mkWN (k39 "hajotus") ; --UNCHK
lin disunite_V = mkWV (k56A "jakaa") ; --UNCHK
lin disunite_V2 = mkWV2 (k56A "jakaa") ; --UNCHK
lin disunity_N = mkWN (k40 "eripuraisuus") ; --UNCHK
lin disuse_N = mkWN (compoundN "laimin" (k5A "lyönti")) ; --UNCHK
lin disused_A = mkWA (compoundA "pois" (k1 "tettu")) "käytöstä" ; --UNCHK
lin disyllabic_A = mkWA (compoundA "kaks" (k38 "itavuinen")) ; --UNCHK
lin disyllable_N = mkWN (k9 "sana") "kaksitavuinen" ; --UNCHK
lin dita_N = mkWN (compoundN "aasiansaitan" (k18 "puu")) ; --UNCHK
lin ditch_N = mkWN (k10 "oja") ; --UNCHK
lin ditch_V = mkWV (k53A "ojittaa") ; --UNCHK
lin ditch_V2 = mkWV2 (k53A "ojittaa") ; --UNCHK
lin dither_N = mkWN (k39 "kiihtymys") ; --UNCHK
lin dither_V = mkWV (k53 "nostaa") "meteli" ; --UNCHK
lin dithering_N = mkWN (k2 "sirottelu") ; --UNCHK
lin dithyramb_N = mkWN (compoundN "ylistys" (k1 "runo")) ; --UNCHK
lin dithyrambic_A = mkWA (k10 "mukaansatempaava") ; --UNCHK
lin ditto_N = mkWN (compoundN "edellä" (k1A "sanottu")) ; --UNCHK
lin ditty_N = mkWN (k1 "laulu") ; --UNCHK
lin diurnal_A = mkWA (compoundA "päivä" (k38 "aikainen")) ; --UNCHK
lin divagate_V = mkWV (k74A "poiketa") ; --UNCHK
lin divagation_N = mkWN (compoundN "kierto" (k19 "tie")) ; --UNCHK
lin divan_N = mkWN (k6 "divaani") ; --UNCHK
lin divan_bed_N = mkWN (k6 "divaani") ; --UNCHK
lin divarication_N = mkWN (compoundN "kas" (k38 "vaminen")) "hajalleen" ; --UNCHK
lin dive_N = mkWN (k1 "syöksy") ; --UNCHK
lin dive_V = mkWV (k54A "sukeltaa") ;
lin dive_bomber_N = mkWN (compoundN "syöksy" (k10 "pommittaja")) ; --UNCHK
lin diver_N = mkWN (k10A "kuikka") ; --UNCHK
lin diverge_V = mkWV (k52A "erkaantua") ; --UNCHK
lin divergence_N = mkWN (compoundN "haa" (k38 "rautuminen")) ; --UNCHK
lin divergency_N = mkWN (compoundN "haa" (k38 "rautuminen")) ; --UNCHK
lin divergent_A = mkWA (k10 "menevä") "erilleen" ; --UNCHK
lin divers_A = mkWA (k38 "erilainen") ; --UNCHK
lin diverse_A = mkWA (k38 "erilainen") ;
lin diverseness_N = mkWN (k40 "moninaisuus") ; --UNCHK
lin diversification_N = mkWN (compoundN "moni" (k38 "puolistaminen")) ; --UNCHK
lin diversify_V = mkWV (k52A "laajentua") ; --UNCHK
lin diversify_V2 = mkWV2 (k52A "laajentua") ; --UNCHK
lin diversion_N = mkWN (compoundN "kierto" (k19 "tie")) ; ---ARB --mkN "huvitus" ;
lin diversionary_A = mkWA (compoundA "harh" (k10 "auttava")) ; --UNCHK
lin diversionist_N = mkWN (k10 "tuhoaja") ; --UNCHK
lin diversity_N = mkN "moni" (mkN "puolisuus") ; --mkWN "vaihtelevuus" ;
lin divert_V = mkWV (k53A "harhauttaa") ; --UNCHK
lin diverticulitis_N = mkWN (k39 "tulehdus") "umpipussin" ; --UNCHK
lin diverticulosis_N = mkWN (compoundN "divertiku" (k5 "loosi")) ; --UNCHK
lin diverticulum_N = mkWN (compoundN "umpi" (k5 "pussi")) ; --UNCHK
lin divertimento_N = mkWN (k5 "serenadi") ; --UNCHK
lin divest_V2 = mkWV2 (k52A "riisuuntua") ; --UNCHK
lin divestiture_N = mkWN (k5A "myynti") "toimintojen" ; --UNCHK
lin dividable_A = mkWA (k38 "jaollinen") ; --UNCHK
lin divide_N = mkWN (compoundN "veden" (k10 "jakaja")) ; --UNCHK
lin divide_V = mkV "jakautua" ; --WV (k56A "jakaa") ;
lin divide_V2 = mkWV2 (k56A "jakaa") ;
lin divide_up_V2 = prepV2 OP_divide_V OP_up_Prep ; -- guess-p-verb
lin dividend_N = mkWN (k1A "osinko") ;
lin dividend_warrant_N = mkWN (compoundN "osinko" (k1A "lippu")) ; --UNCHK
lin divider_N = mkWN (k10 "jakaja") ; --UNCHK
lin divination_N = mkWN "divinaatio" ; --UNCHK
lin divinatory_A = mkWA (k38 "hypoteettinen") ; --UNCHK
lin divine_A = mkWA (k38 "taivaallinen") ; --UNCHK
lin divine_N = mkWN (compoundN "Kaikki" (k41 "valtias")) ; --UNCHK
lin diviner_N = mkWN (k10 "tietäjä") ; --UNCHK
lin diving_N = mkWN (k39 "sukellus") ; --UNCHK
lin diving_bell_N = mkWN (compoundN "sukellus" (k1 "kello")) ; --UNCHK
lin diving_board_N = mkWN (compoundN "ponnahdus" (k9A "lauta")) ; --UNCHK
lin diving_dress_N = mkWN (compoundN "sukellus" (k1A "puku")) ; --UNCHK
lin diving_suit_N = mkWN (compoundN "sukellus" (k1A "puku")) ; --UNCHK
lin divinity_N = mkWN (k40 "jumaluus") ; --UNCHK
lin divisibility_N = mkWN (k40 "jaollisuus") ; --UNCHK
lin divisible_A = mkWA (k10 "jaettava") ; --UNCHK
lin division_1_N = mkN "osasto" ;
lin division_2_N = mkN "divisioona" ;
lin division_3_N = mkN "jako" (mkN "lasku") ;
lin division_N = mkN "osasto" ;
lin divisional_A = mkWA "divisioonan" ; --UNCHK
lin divisor_N = mkWN (k10 "jakaja") ; --UNCHK
lin divorce_N = mkWN (k1 "ero") ; --UNCHK
lin divorce_V2 = mkWV2 (k52A "erottautua") ; --UNCHK
lin divot_N = mkWN (compoundN "turpeen" (k9 "pala")) ; --UNCHK
lin divulge_V2 = mkWV2 (k52A "kertoa") ; --UNCHK
lin divulgence_N = mkWN (k39 "paljastus") ; --UNCHK
lin divvy_N = mkWN (k40 "osuus") ; --UNCHK
lin divvy_up_V2 = mkWV2 (k67 "annostella") ; --UNCHK
lin dixie_N = mkWN (compoundN "kenttä" (k12 "kattila")) ; --UNCHK
lin dizygotic_A = mkWA "erimunaiset" ; --UNCHK
lin dizziness_N = mkWN (k39 "pyörrytys") ; --UNCHK
lin dizzy_A = mkWA (k10 "tyhmä") ; --UNCHK
lin dizzy_V2 = mkWV2 (k73 "huimata") ; --UNCHK
lin dj_N = mkWN (k10A "tiskijukka") ; --UNCHK
lin djibouti_PN = foreignPN "Djibouti" ;
lin djiboutian_A = mkWA (compoundA "djibouti" (k38 "lainen")) ; --UNCHK
lin djiboutian_N = mkWN (compoundN "djibouti" (k38 "lainen")) ; --UNCHK
lin djinn_N = mkWN (k7A "henki") ; --UNCHK
lin dm_N = mkWN (compoundN "desi" (k5 "metri")) ; --UNCHK
lin dna_N = mkWN (k99 "DNA") ; --UNCHK
lin do_N = mkN "teko" ;
lin do_V2 = mkV2 tehda_V ;
lin dobbin_N = mkWN (compoundN "työ" (k38 "hevonen")) ; --UNCHK
lin dobra_N = mkWN "dobra" ; --UNCHK
lin dobson_N = mkWN (compoundN "kaisla" (k1A "korento")) ; --UNCHK
lin docent_N = mkWN (k5A "dosentti") ; --UNCHK
lin docile_A = mkWA (k10 "mukautuva") ; --UNCHK
lin docility_N = mkWN (k40 "mukautuvaisuus") ; --UNCHK
lin dock_N = mkWN (compoundN "töpö" (k10A "häntä")) ; --UNCHK
lin dock_V = mkWV (k62 "telakoida") ; --UNCHK
lin dock_V2 = mkWV2 (k62 "telakoida") ; --UNCHK
lin dockage_N = mkWN (k5A "ankkurointi") ; --UNCHK
lin docker_N = mkWN (k10 "lastaaja") ; --UNCHK
lin docket_N = mkWN (k10 "ohjelma") ; --UNCHK
lin docking_N = mkWN (k5A "ankkurointi") ; --UNCHK
lin dockside_N = mkWN (compoundN "satama-" (k48 "alue")) ; --UNCHK
lin dockyard_N = mkWN (k14A "telakka") ; --UNCHK
lin doctor_N = L.doctor_N ;
lin doctor_V2 = mkWV2 (k53A "hoitaa") ; --UNCHK
lin doctoral_A = mkWA "tohtorin" ; --UNCHK
lin doctorate_N = mkWN (compoundN "tohtorin" (k1 "arvo")) ; --UNCHK
lin doctorfish_N = mkWN (compoundN "tohtori" (k9 "kala")) ; --UNCHK
lin doctorspeak_N = mkWN (compoundN "ammatti" (k26 "kieli")) "lääkäreiden" ; --UNCHK
lin doctrinaire_A = mkWA (k38 "teoreettinen") ; --UNCHK
lin doctrinaire_N = mkWN (k4A "teoreetikko") ; --UNCHK
lin doctrinal_A = mkWA (k38 "dogmaattinen") ; --UNCHK
lin doctrine_N = mkWN (k5A "oppi") ;
lin document_N = mkN "dokumentti" | mkN "asia" (mkN "kirja") ;
lin document_V2 = mkV2 "dokumentoida" partitive ; --mkWV2 (k53 "vahvistaa") ;
lin documentary_A = mkWA (k38 "dokumentaarinen") ; --UNCHK
lin documentary_N = mkWN (k5A "dokumentti") ; --UNCHK
lin documentation_N = mkWN (k39 "vahvistus") ; --UNCHK
lin dodder_N = mkWN (compoundN "humala" (k41 "vieras")) ; --UNCHK
lin dodder_V = mkWV (k52A "vaappua") ; --UNCHK
lin dodderer_N = mkWN (compoundN "vanhuuden" (k1A "heikko")) ; --UNCHK
lin doddery_A = mkWA (k6 "seniili") ; --UNCHK
lin doddle_N = mkWN (compoundN "lasten" (k61A "leikkiä")) ; --UNCHK
lin dodecagon_N = mkWN "kaksitoistakulmio" ; --UNCHK
lin dodecahedron_N = mkWN (compoundN "kaksitoista" (k41A "tahokas")) ; --UNCHK
lin dodge_N = mkWN (compoundN "väistö" (k48A "liike")) ; --UNCHK
lin dodge_V = mkWV (k67A "luikerrella") ; --UNCHK
lin dodge_V2 = mkWV2 (k67A "luikerrella") ; --UNCHK
lin dodgem_N = mkWN (compoundN "sähkö" (k1 "auto")) ; --UNCHK
lin dodger_N = mkWN (compoundN "maissi" (k1A "kakku")) ; --UNCHK
lin dodgy_A = mkWA (k10 "näppärä") ; --UNCHK
lin dodo_N = mkWN "Raphus" "cucullatus" ; --UNCHK
lin doe_N = mkWN (k33A "vaadin") ; --UNCHK
lin doer_N = mkWN (k42 "mies") "toiminnan" ; --UNCHK
lin doeskin_N = mkWN (compoundN "villa" (k6 "satiini")) ; --UNCHK
lin doff_V2 = mkWV2 (k52 "riisua") ; --UNCHK
lin dog_N = L.dog_N ;
lin dog_V2 = mkV2 "seurata" partitive ; --mkWV2 (k56 "ajaa") ;
lin dog_biscuit_N = mkWN (k5 "koirankeksi") ; --UNCHK
lin dog_collar_N = mkWN (k9A "panta") ; --UNCHK
lin dogbane_N = mkWN (compoundN "oleanteri" (k5 "kasvi")) ; --UNCHK
lin doge_N = mkWN "dogi" ; --UNCHK
lin dogfight_N = mkWN (compoundN "koira" (k2 "tappelu")) ; --UNCHK
lin dogfighter_N = mkWN (compoundN "taistelu" (k10 "lentäjä")) ; --UNCHK
lin dogfish_N = mkWN (compoundN "piste" (k18 "hai")) ; --UNCHK
lin doggedly_Adv = mkWAdv (k99 "lujasti") ; --UNCHK
lin doggedness_N = mkWN (k40 "sinnikkyys") ; --UNCHK
lin doggerel_N = mkWN (kH1 "ralli") ; --UNCHK
lin doggie_N = mkWN (k5A "rakki") ; --UNCHK
lin dogging_A = mkWA (k41A "sinnikäs") ; --UNCHK
lin doggo_Adv = mkWAdv (k99 "näkyvistä") "poissa" ; --UNCHK
lin doggy_N = mkWN (k5A "rakki") ; --UNCHK
lin doghouse_N = mkWN (k5A "koirankoppi") ; --UNCHK
lin dogleg_N = mkWN (k48A "polveke") ; --UNCHK
lin dog_like_A = mkWA (compoundA "koira" (k38 "mainen")) ; --UNCHK
lin dogma_N = mkWN (k5 "dogmi") ; --UNCHK
lin dogmatic_A = mkWA (k38 "dogmaattinen") ; --UNCHK
lin dogmatism_N = mkWN (k40 "dogmaattisuus") ; --UNCHK
lin dogmatist_N = mkWN (k4A "teoreetikko") ; --UNCHK
lin dogmatize_V = mkWV (k74A "vedota") "opinkappaleisiin" ; --UNCHK
lin dogmatize_V2 = mkWV2 (k74A "vedota") "opinkappaleisiin" ; --UNCHK
lin dogsbody_N = mkWN (k38 "käskyläinen") ; --UNCHK
lin dogsled_N = mkWN (compoundN "koira" (k4A "valjakko")) ; --UNCHK
lin dogtooth_N = mkWN (compoundN "hammas" (k5A "ornamentti")) ; --UNCHK
lin dogtrot_N = mkWN (k10A "hölkkä") "tasainen" ; --UNCHK
lin dogwatch_N = mkWN (compoundN "koiran" (k5A "vahti")) ; --UNCHK
lin dogwood_N = mkWN (k14A "kanukka") ; --UNCHK
lin doh_N = mkWN "do" ; --UNCHK
lin doily_N = mkWN (compoundN "kakku" (k6 "paperi")) ; --UNCHK
lin doing_N = mkN "tekeminen" ;
lin dol_N = mkWN (compoundN "työ" (k3 "ministeriö")) ; --UNCHK
lin dolabriform_A = mkWA (k10 "kaareva") ; --UNCHK
lin dolce_Adv = mkWAdv (k99 "suloisesti") ; --UNCHK
lin dole_N = mkWN (k39 "avustus") ; --UNCHK
lin dole_V2 = mkV2 (mkV "jakaa") partitive ;
lin dole_out_V2 = mkWV2 (k56A "jakaa") ; --UNCHK
lin doleful_A = mkWA (k10 "sureva") ; --UNCHK
lin dolefulness_N = mkWN (k40 "surullisuus") ; --UNCHK
lin dolichocephalic_A = mkWA (compoundA "pitkäkal" (k38 "loinen")) ; --UNCHK
lin dolichocephalic_N = mkWN (compoundN "pitkäkal" (k38 "loinen")) ; --UNCHK
lin dolichocephaly_N = mkWN "pitkäkalloisuus" ; --UNCHK
lin doliolum_N = mkWN (compoundN "vaippa" (k33 "eläin")) ; --UNCHK
lin doll_N = mkWN (k8A "nukke") ; --UNCHK
lin dollar_N = mkN "dollari" ;
lin dollarfish_N = mkWN "Selene" "setapinnis" ; --UNCHK
lin dollhouse_N = mkWN (compoundN "nukke" (k5A "koti")) ; --UNCHK
lin dollop_N = mkWN (k38 "lusikallinen") ; --UNCHK
lin dolly_N = mkWN (k8A "nukke") ; --UNCHK
lin dolman_N = mkWN (kH1 "viitta") ; --UNCHK
lin dolmen_N = mkWN (k9A "hauta") "kivikautinen" ; --UNCHK
lin dolomite_N = mkWN (k5A "dolomiitti") ; --UNCHK
lin dolomitic_A = mkWA (compoundA "dolomiitti" (k38 "nen")) ; --UNCHK
lin dolor_N = mkWN (k10 "tuska") ; --UNCHK
lin dolorous_A = mkWA (k38 "itkuinen") ; --UNCHK
lin dolour_N = mkWN (k10 "tuska") ; --UNCHK
lin dolourous_A = mkWA (k38 "itkuinen") ; --UNCHK
lin dolphin_N = mkWN (k6 "delfiini") ;
lin dolphinfish_N = mkWN (compoundN "kulta" (k5 "makrilli")) ; --UNCHK
lin dolt_N = mkWN (k5 "pahvi") ; --UNCHK
lin doltish_A = mkWA (k38 "moukkamainen") ; --UNCHK
lin domain_N = mkWN (k39 "tietämys") ; --UNCHK
lin domatium_N = mkWN (k10 "osa") "kaareutuva" "kasvin" ; --UNCHK
lin dombeya_N = mkWN "dombeija" ; --UNCHK
lin dome_N = mkWN (k6 "kupoli") ; --UNCHK
lin domed_A = mkWA (compoundA "hol" (k1A "vattu")) ; --UNCHK
lin domestic_A = mkWA (k38 "kotimainen") ; --f191
lin domestic_N = mkWN (k9A "piika") ; --UNCHK
lin domesticate_V2 = mkWV2 (k53A "kesyttää") ; --UNCHK
lin domestication_N = mkWN (compoundN "kesy" (k38 "ttäminen")) ; --UNCHK
lin domesticity_N = mkWN (compoundN "perhe-" (k10 "elämä")) ; --UNCHK
lin domicile_N = mkWN (k1A "asunto") ; --UNCHK
lin domiciliary_A = mkWA "koti-" ; --UNCHK
lin dominance_N = mkN "valta-" (mkN "asema") ; --mkWN (k5 "dominanssi") ;
lin dominant_A = mkWA (k10 "hallitseva") ; --UNCHK
lin dominant_N = mkWN (k5A "dominantti") ; --UNCHK
lin dominate_V = mkV vOlla "hallitseva" ; --mkWV (k53A "ylittää") ;
lin dominate_V2 = mkV2 (mkV "dominoida") partitive ;
lin domination_N = mkWN (k40 "herruus") ;
lin dominatrix_N = mkWN "dominatrix" ; --UNCHK
lin domineer_V = mkWV (k69 "hallita") "tyrannimaisesti" ; --UNCHK
lin domineeringly_Adv = mkWAdv (k99 "määräävästi") ; --UNCHK
lin dominica_PN = foreignPN "Dominica" ;
lin dominical_A = mkWA "pyhä-" ; --UNCHK
lin dominican_A = mkWA "dominikaani-" ; --UNCHK
lin dominican_N = mkWN (k5 "dominikaani") ; --UNCHK
lin dominie_N = mkWN (k5A "pappi") ; --UNCHK
lin dominion_N = mkWN "Dominion" ; --UNCHK
lin domino_N = mkWN (k2 "domino") ; --UNCHK
lin dominoes_N = mkWN (k2 "domino") ; --UNCHK
lin dominus_N = mkWN (k5A "pappi") ; --UNCHK
lin don_N = mkWN "Don" ; --UNCHK
lin don_PN = foreignPN "Don" ;
lin don_V2 = mkWV2 (k52A "sonnustautua") ; --UNCHK
lin donate_V = mkWV (k53A "lahjoittaa") ; --UNCHK
lin donate_V2 = mkWV2 (k53A "lahjoittaa") ; --UNCHK
lin donation_N = mkWN (k39 "lahjoitus") ;
lin doncaster_PN = foreignPN "Doncaster" ;
lin donegal_PN = foreignPN "Donegal" ;
lin donetsk_PN = foreignPN "Donetsk" ;
lin dong_N = mkWN "dong" ; --UNCHK
lin dongle_N = mkWN (compoundN "suojaus" (k33 "avain")) ; --UNCHK
lin donjon_N = mkWN (k5 "torni") ; --UNCHK
lin donkey_N = mkWN (k5 "aasi") ; --UNCHK
lin donna_N = mkWN (k10 "rouva") ; --UNCHK
lin donnish_A = mkWA (k38 "pikkumainen") ; --UNCHK
lin donor_N = mkWN (k10 "lahjoittaja") ;
lin doodad_N = mkWN (k33A "hilavitkutin") ; --UNCHK
lin doodia_N = mkWN (compoundN "Doo" (k9 "dia")) ; --UNCHK
lin doodle_V = mkWV (k67A "piirrellä") ; --UNCHK
lin doodlebug_N = mkWN (k10A "toukka") "muurahaisleijonan" ; --UNCHK
lin doom_N = mkWN (k1A "loppu") ; --UNCHK
lin doom_V2 = mkV2 "tuomita" ; --mkWV2 (k67 "olla") "määrätty" ;
lin doomed_N = mkWN (k10 "oma") "tuhon" ; --UNCHK
lin door_N = L.door_N ;
lin door_to_door_A = mkA "ovelta ovelle" ;
lin doorbell_N = mkWN (compoundN "ovi" (k6 "summeri")) ; --UNCHK
lin doorcase_N = mkWN (compoundN "oven" (k5 "karmi")) ; --UNCHK
lin doorframe_N = mkWN (compoundN "oven" (k5 "karmi")) ; --UNCHK
lin doorhandle_N = mkWN (compoundN "oven" (k9 "kahva")) ; --UNCHK
lin doorjamb_N = mkWN (compoundN "pihti" (k26 "pieli")) ; --UNCHK
lin doorkeeper_N = mkWN (compoundN "portti" (k5A "vahti")) ; --UNCHK
lin doorknob_N = mkWN (compoundN "oven" (k9 "kahva")) ; --UNCHK
lin doorknocker_N = mkWN (k33A "kolkutin") ; --UNCHK
lin doorlock_N = mkWN (k1A "lukko") "ulko-oven" ; --UNCHK
lin doorman_N = mkWN (compoundN "portti" (k5A "vahti")) ; --UNCHK
lin doormat_N = mkWN (compoundN "kynnys" (k1A "matto")) ; --UNCHK
lin doornail_N = mkWN (k9 "naula") ; --UNCHK
lin doorplate_N = mkWN (compoundN "nimi" (k9A "laatta")) ; --UNCHK
lin doorpost_N = mkWN (compoundN "pihti" (k26 "pieli")) ; --UNCHK
lin doorsill_N = mkWN (k39 "kynnys") ; --UNCHK
lin doorstep_N = mkWN (k39 "kynnys") ; --UNCHK
lin doorstop_N = mkWN (k33A "pidätin") "oven" ; --UNCHK
lin doorstopper_N = mkWN (k33A "pidätin") "oven" ; --UNCHK
lin doorway_N = mkWN (compoundN "ovi" (k1A "aukko")) ; --UNCHK
lin dooryard_N = mkWN (compoundN "taka" (k9 "piha")) ; --UNCHK
lin dopa_N = mkWN (compoundN "dihydroksifenyyliala" (k26 "niini")) ; --UNCHK
lin dopamine_N = mkWN "Intropin" ; --UNCHK
lin dope_N = mkWN (k7 "pilvi") ; --UNCHK
lin dopey_A = mkWA (k34A "älytön") ; --UNCHK
lin doppelganger_N = mkWN (k1 "haamu") ; --UNCHK
lin dora_PN = foreignPN "Dora" ;
lin dorbeetle_N = mkWN (k38 "sontiainen") ; --UNCHK
lin dorchester_PN = foreignPN "Dorchester" ;
lin dordrecht_PN = foreignPN "Dordrecht" ;
lin doric_A = mkWA (k38 "doorilainen") ; --UNCHK
lin dorking_PN = foreignPN "Dorking" ;
lin dormancy_N = mkWN (k40 "liikkumattomuus") ; --UNCHK
lin dormant_A = mkWA "toimimaton" ; --UNCHK
lin dormer_N = mkWN (compoundN "pysty" (k12 "ikkuna")) "vinokaton" ; --UNCHK
lin dormer_window_N = mkWN (compoundN "pysty" (k12 "ikkuna")) "vinokaton" ; --UNCHK
lin dormitory_N = mkWN (k12 "asuntola") ; --UNCHK
lin dormouse_N = mkWN (compoundN "pähkinä" (k24 "hiiri")) ; --UNCHK
lin dorsal_A = mkWA (compoundA "selän" (k38 "puoleinen")) ; --UNCHK
lin dorsiflexion_N = mkWN "taakse" "kääntyminen" ; --UNCHK
lin dorsoventral_A = mkWA (compoundA "pystyaks" (k33 "elin")) ; --UNCHK
lin dorsum_N = mkWN (compoundN "selkä" (k26 "puoli")) ; --UNCHK
lin dortmund_PN = foreignPN "Dortmund" ;
lin dory_N = mkWN (compoundN "pietarin" (k9 "kala")) ; --UNCHK
lin dosage_N = mkWN (k39 "annos") ; --UNCHK
lin dose_N = mkN "annos" ; --mkWN (k1A "lappu") ;
lin dose_V2 = mkWV2 (k73 "huumata") ; --UNCHK
lin dosemeter_N = mkWN (k5 "dosimetri") ; --UNCHK
lin dosimetry_N = mkWN (compoundN "annos" (k39 "mittaus")) ; --UNCHK
lin doss_V = mkWV (k52A "nukkua") ; --UNCHK
lin doss_down_V = mkWV (k52A "nukkua") ; --UNCHK
lin dossal_N = mkWN (k48A "vaate") "alttarin" "peräseinän" ; --UNCHK
lin dosser_N = mkWN (k34A "koditon") ; --UNCHK
lin dot_N = mkWN (k1A "lappu") ; --UNCHK
lin dot_V2 = mkWV2 (k69 "merkitä") "piste" ; --UNCHK
lin dotage_N = mkWN (k5A "seniliteetti") ; --UNCHK
lin dotard_N = mkWN (compoundN "vanhuuden" (k2 "höperö")) ; --UNCHK
lin dote_V = mkWV (k62 "jumaloida") ; --UNCHK
lin dotterel_N = mkWN (compoundN "kerä" (k13 "kurmitsa")) ; --UNCHK
lin dotty_A = mkWA (k47 "höpsähtänyt") ; --UNCHK
lin douai_PN = foreignPN "Douai" ;
lin double_A = mkA "kaksinkertainen" ; --WA (compoundA "kahden" (k38 "arvoinen")) ;
lin double_Adv = mkWAdv (k99 "kaksinkertaisesti") ; --UNCHK
lin double_N = mkWN (k5A "lyönti") "kahden" "pesän" ; --UNCHK
lin double_V = mkWV (k52 "kaksinkertaistua") ;
lin double_V2 = mkWV2 (k52 "kaksinkertaistua") ; --UNCHK
lin double_as_V2 = prepV2 OP_double_V OP_as_Prep ; -- guess-p-verb
lin double_back_V = mkWV (k71 "tehdä") "täyskäännös" ; --UNCHK
lin double_bass_N = mkWN (compoundN "basso" (k1 "viulu")) ; --UNCHK
lin double_check_V2 = variants {} ; -- guess-p-verb
lin double_cross_N = mkWN (k39 "petkutus") ; --UNCHK
lin double_cross_V2 = mkWV2 (k53A "pettää") ; --UNCHK
lin double_edged_A = mkA "kaksiteräinen" ;
lin double_entry_N = mkWN (compoundN "kirjan" (k1A "pito")) "kaksinkertainen" ; --UNCHK
lin double_over_V = mkWV (k67 "mennä") "kaksinkerroin" ; --UNCHK
lin double_park_V = variants {} ; -- guess-p-verb
lin double_park_V2 = variants {} ; -- guess-p-verb
lin double_talk_N = mkWN (compoundN "sian" (k9 "saksa")) ; --UNCHK
lin double_up_V = mkWV (k56A "jakaa") ; --UNCHK
lin double_up_as_V2 = prepV2 (advV OP_double_V OP_up_Adv ) OP_as_Prep ; -- guess-p-verb
lin doubler_N = mkWN (compoundN "kertaus" (k48 "kone")) ; --UNCHK
lin doubles_N = mkWN (compoundN "nelin" (k5 "peli")) ; --UNCHK
lin doublespeak_N = mkWN (compoundN "kaksois" (k9A "viestintä")) ; --UNCHK
lin doublet_N = mkWN (k1A "jakku") "miehen" ; --UNCHK
lin double_think_N = mkWN (compoundN "kaksois" (k2 "ajattelu")) ; --UNCHK
lin doubletree_N = mkWN (compoundN "poikki" (k18 "puu")) ; --UNCHK
lin doubling_N = mkWN (compoundN "tupla" (k38 "aminen")) ; --UNCHK
lin doubloon_N = mkWN "dubloni" ; --UNCHK
lin doubt_N = mkN "epäilys" ;
lin doubt_V2 = mkV2 "epäillä" partitive ;
lin doubt_VS = mkWVS (k67 "epäillä") ; --UNCHK
lin doubtful_A = mkWA (k10 "epäilevä") ;
lin doubting_A = mkWA (k38 "skeptinen") ; --UNCHK
lin doubtless_Adv = mkWAdv (k99 "varmaan") ; --UNCHK
lin douche_N = mkWN (k2 "huuhtelu") ; --UNCHK
lin dough_N = mkWN (k12 "taikina") ; --UNCHK
lin doughboy_N = mkWN (k5 "donitsi") ; --UNCHK
lin doughnut_N = mkWN (k5A "munkki") ; --UNCHK
lin doughy_A = mkWA (k38 "taikinainen") ; --UNCHK
lin douglas_PN = foreignPN "Douglas" ;
lin dour_A = mkWA (k15 "äreä") ; --UNCHK
lin douroucouli_N = mkWN "Aotus" "trivirgatus" ; --UNCHK
lin douse_V2 = mkWV2 (k56 "kastaa") ; --UNCHK
lin dove_N = mkWN (k38 "kyyhkynen") ; --UNCHK
lin dovecote_N = mkWN (k9A "kyyhkyslakka") ; --UNCHK
lin dover_PN = foreignPN "Dover" ;
lin dovetail_N = mkWN (k39 "sinkkaus") ; --UNCHK
lin dovetail_V = mkWV (k73A "sinkata") ; --UNCHK
lin dovetail_V2 = mkWV2 (k73A "sinkata") ; --UNCHK
lin dovishness_N = mkWN (compoundN "sodan" (k40 "vastaisuus")) ; --UNCHK
lin dowager_N = mkWN (k7 "leski") ; --UNCHK
lin dowdiness_N = mkWN (compoundN "epä" (k40 "siisteys")) ; --UNCHK
lin dowdy_A = mkWA (compoundA "vanhan" (k38 "aikainen")) ; --UNCHK
lin dowdy_N = mkWN (k41 "piiras") ; --UNCHK
lin dowel_N = mkWN (k1A "proppu") ; --UNCHK
lin doweling_N = mkWN (k39 "vaarnaus") ; --UNCHK
lin dower_N = mkWN (k40 "osuus") "lesken" ; --UNCHK
lin dower_V2 = mkWV2 (k53 "varustaa") "myötäjäisillä" ; --UNCHK
lin dowerless_A = mkWA "vailla" "myötäjäisiä" ; --UNCHK
lin dowitcher_N = mkWN (k10 "kahlaaja") ; --UNCHK
lin down_Adv = mkAdv "alhaalla" | mkAdv "alas" ;
lin down_N = mkN "taka" (mkN "isku") ; --mkWN (k39 "yritys") ;
lin down_Prep = mkPrep "alas" partitive ;
lin down_V2 = mkWV2 (k53A "vetää") "maahan" ; --UNCHK
lin downbeat_N = mkWN (compoundN "alas" (k5A "lyönti")) ; --UNCHK
lin downbound_A = mkWA (compoundA "suunt" (k9 "aava")) "alas" ; --UNCHK
lin downcast_A = mkWA (k15 "synkeä") ; --UNCHK
lin downcast_N = mkWN (compoundN "raitisilma" (k1 "kuilu")) ; --UNCHK
lin downdraft_N = mkWN (k1A "alaveto") ; --UNCHK
lin downfall_N = mkWN (k39 "romahdus") ; --UNCHK
lin downfield_A = mkWA "alakentän" ; --UNCHK
lin downfield_Adv = mkWAdv (k99 "alas") "kenttää" ; --UNCHK
lin downgrade_N = mkWN (k40 "kaltevuus") ; --UNCHK
lin downgrade_V2 = mkWV2 (k54A "huonontaa") ; --UNCHK
lin downhearted_A = mkWA (k15 "synkeä") ; --UNCHK
lin downheartedness_N = mkWN (k1 "alakulo") ; --UNCHK
lin downhill_Adv = mkWAdv (k99 "alas") ; --UNCHK
lin downhill_N = mkWN (k5 "slalom") ; --UNCHK
lin downiness_N = mkWN (k40 "pehmeys") ; --UNCHK
lin download_N = mkN "lataus" ;
lin down_market_A = mkWA (k9A "halpa") ; --UNCHK
lin downplay_V2 = mkWV2 (k52 "väheksyä") ; --UNCHK
lin downpour_N = mkWN (k10 "tulva") ; --UNCHK
lin downright_A = mkWA (k9A "silkka") ; --UNCHK
lin downright_Adv = mkWAdv (k99 "läpeensä") ; --UNCHK
lin downrightness_N = mkWN (k40 "rehellisyys") ; --UNCHK
lin downriver_Adv = mkWAdv (k99 "alas") ; --UNCHK
lin downscale_A = mkWA "halpatuotanto-" ; --UNCHK
lin downside_N = mkWN (k26 "puoli") "huono" ; --UNCHK
lin downsize_V2 = mkWV2 (k54A "vähentää") ; --UNCHK
lin downspin_N = mkWN (compoundN "alas" (k1 "syöksy")) ; --UNCHK
lin downstage_A = mkWA "etunäyttämön" ; --UNCHK
lin downstage_Adv = mkWAdv "kohti" "etunäyttämöä" ; --UNCHK
lin downstage_N = mkWN (compoundN "etu" (k2 "näyttämö")) ; --UNCHK
lin downstairs_Adv = mkWAdv (k99 "alhaalla") ; --UNCHK
lin downstream_A = mkWA "myötävirtaan" ; --UNCHK
lin downstream_Adv = mkWAdv (k99 "alas") ; --UNCHK
lin downstroke_N = mkWN (k1A "alasveto") ; --UNCHK
lin downswing_N = mkWN (k1 "lasku") ; --UNCHK
lin downtime_N = mkWN (k9A "seisonta-aika") ; --UNCHK
lin downtown_A = mkWA (k10 "oleva") "keskustassa" ; --UNCHK
lin downtown_Adv = mkWAdv "keskustassa" ; --UNCHK
lin downtrodden_A = mkWA "poljettu" ; --UNCHK
lin downturn_N = mkWN (k1 "lasku") ; --UNCHK
lin downward_A = mkA (mkN "alaspäin" (mkN "viettävä")) ;
lin downward_Adv = mkWAdv (k99 "alas") ; --UNCHK
lin downwards_Adv = mkWAdv (k99 "alas") ; --UNCHK
lin downwind_A = mkWA (compoundA "suojan" (k38 "puoleinen")) ; --UNCHK
lin downwind_Adv = mkWAdv "myötätuuleen" ; --UNCHK
lin downy_A = mkWA (k38 "silkkinen") ; --UNCHK
lin dowse_N = mkWN "taikavarvulla" "etsiminen" ; --UNCHK
lin dowse_V2 = mkWV2 (k56 "kastaa") ; --UNCHK
lin dowser_N = mkWN (compoundN "taika" (k1A "varpu")) ; --UNCHK
lin dowsing_N = mkWN "taikavarvulla" "etsiminen" ; --UNCHK
lin doxazosin_N = mkWN (compoundN "Card" (k10 "ura")) ; --UNCHK
lin doxepin_N = mkWN "Sinequan" ; --UNCHK
lin doxology_N = mkWN "doksologia" ; --UNCHK
lin doxorubicin_N = mkWN "doksorubisiini" ; --UNCHK
lin doxycycline_N = mkWN "doksisykliini" ; --UNCHK
lin doyen_N = mkWN (k36 "vanhin") ; --UNCHK
lin doyenne_N = mkWN (k36 "vanhin") ; --UNCHK
lin doyley_N = mkWN (compoundN "kakku" (k6 "paperi")) ; --UNCHK
lin doyly_N = mkWN (compoundN "kakku" (k6 "paperi")) ; --UNCHK
lin doze_N = mkWN (k2 "torkahtelu") ; --UNCHK
lin doze_V = mkWV (k52A "nuokkua") ; --UNCHK
lin doze_off_V = mkWV (k61A "pilkkiä") ; --UNCHK
lin dozen_N = mkWN (k12 "tusina") ; --f72
lin dphil_N = mkWN "DPhil" ; --UNCHK
lin drab_A = mkWA (k15 "synkeä") ; --UNCHK
lin draba_N = mkWN (k2 "kynsimö") ; --UNCHK
lin drabness_N = mkWN (compoundN "epä" (k40 "siisteys")) ; --UNCHK
lin dracaena_N = mkWN (compoundN "traakki" (k18 "puu")) ; --UNCHK
lin drachma_N = mkWN (k9 "drakma") ; --UNCHK
lin draconian_A = mkWA "drakoninen" ; --UNCHK
lin dracontium_N = mkWN (compoundN "kärsä" (k9 "kalla")) ; --UNCHK
lin draft_N = mkWN (kH1 "veto") ; --UNCHK
lin draft_V2 = mkWV2 (k52 "kutsua") "palvelukseen" ; --UNCHK
lin draftee_N = mkWN (compoundN "ase" (k38 "velvollinen")) ; --UNCHK
lin drafter_N = mkWN "luonnostelija" ; --UNCHK
lin drafting_N = mkWN (k39 "piirustus") "mekaaninen" ; --UNCHK
lin draftsman_N = mkWN (k12 "suunnittelija") ; --UNCHK
lin drafty_A = mkWA (k38 "vetoinen") ; --UNCHK
lin drag_N = mkN "hidaste" ; ---ARB --mkWN (kH1 "veto") ;
lin drag_V = mkWV (k52A "pitkittyä") ; --UNCHK
lin drag_V2 = mkV2 "vetää" ; ---ARB --mkV2 "raahata" ; --mkV2 "pitkittää" ;
lin drag_down_A = mkWV (k53A "rasittaa") "painollaan" ; --UNCHK
lin drag_down_V = advV OP_drag_V OP_down_Adv ; -- guess-p-verb
lin drag_in_V = mkWV (k58 "sotkea") ; --UNCHK
lin drag_on_V = mkWV (k52A "pitkittyä") ; --UNCHK
lin dragee_N = mkWN (compoundN "lääke" (k48A "rae")) ; --UNCHK
lin draggingly_Adv = mkWAdv (compoundAdv "laahaav" (k99 "asti")) ; --UNCHK
lin draggled_A = mkWA (k38 "sotkuinen") ; --UNCHK
lin dragnet_N = mkWN (k5 "trooli") ; --UNCHK
lin dragoman_N = mkWN (kH1 "tulkki") ; --UNCHK
lin dragon_N = mkWN (k1 "liitolisko") ; --UNCHK
lin dragonet_N = mkWN (k5A "merikokki") ; --UNCHK
lin dragonfly_N = mkWN (compoundN "pirun" (k6 "puntari")) ; --UNCHK
lin dragonhead_N = mkWN (compoundN "amerikanampiais" (k5A "yrtti")) ; --UNCHK
lin dragoon_N = mkWN (compoundN "rakuuna" (k5A "rykmentti")) ; --UNCHK
lin dragoon_V2 = mkWV2 (k53A "pakottaa") ; --UNCHK
lin dragsfjärd_PN = mkPN "Dragsfjärd" ;
lin drain_N = mkWN (k39 "kuivatus") ;
lin drain_V = mkWV (k64 "viedä") "voimat" ; --UNCHK
lin drain_V2 = mkV2 "kuluttaa" partitive ; --mkWV2 (k64 "viedä") "voimat" ;
lin drainage_N = mkWN (k39 "kuivatus") ; --UNCHK
lin drainage_basin_N = mkWN (k41A "allas") ; --UNCHK
lin drainboard_N = mkWN (compoundN "tiski" (k10A "pöytä")) ; --UNCHK
lin draining_board_N = mkWN (compoundN "tiski" (k10A "pöytä")) ; --UNCHK
lin drainpipe_N = mkWN (k6 "viemäri") ; --UNCHK
lin drainplug_N = mkWN (k10A "tulppa") ; --UNCHK
lin drake_N = mkWN (compoundN "uros" (k10 "sorsa")) ; --UNCHK
lin dram_N = mkWN "dram" ; --UNCHK
lin drama_N = mkWN (k40 "dramaattisuus") ; --UNCHK
lin dramatic_A = mkWA (k38 "dramaattinen") ;
lin dramatics_N = mkWN (k9 "draama") ; --UNCHK
lin dramatist_N = mkWN (k5 "dramaturgi") ; --UNCHK
lin dramatization_N = mkWN (k5A "dramatisointi") ; --UNCHK
lin dramatize_V2 = mkWV2 (k53A "värittää") ; --UNCHK
lin dramaturgic_A = mkWA (compoundA "dramaturgi" (k38 "nen")) ; --UNCHK
lin dramaturgy_N = mkWN (k6 "teatteri") ; --UNCHK
lin drape_N = mkN "verho" ; ---ARB ; laskeutuminen. plurale tantum.
lin drape_V2 = mkWV2 (k53 "laskostaa") ; --UNCHK
lin draper_N = mkWN (compoundN "kangas" (k41 "kauppias")) ; --UNCHK
lin drastic_A = mkWA (k38 "äärimmäinen") ; --UNCHK
lin draught_N = mkWN (kH1 "veto") ; --UNCHK
lin draught_V2 = mkWV2 (k67A "hahmotella") ; --UNCHK
lin draught_horse_N = mkWN (compoundN "kylmä" (k38 "verinen")) ; --UNCHK
lin draughts_N = mkWN (kH1 "tammi") ; --UNCHK
lin draughtsman_N = mkWN (k12 "suunnittelija") ; --UNCHK
lin draughty_A = mkWA (k38 "vetoinen") ; --UNCHK
lin draw_1_V2 = mkV2 "piirtää" ;
lin draw_2_V2 = mkV2 "vetää" ;
lin draw_N = mkN "tasapeli" ; ---ARB ; arvonta
lin draw_V = mkV "vetää" ;
lin draw_V2 = mkV2 "vetää" ;
lin draw_back_V2 = mkWV2 (k53A "vetää") ; --UNCHK
lin draw_down_V2 = prepV2 OP_draw_V OP_down_Prep ; -- guess-p-verb
lin draw_even_V = advV OP_draw_V OP_even_Adv ; -- guess-p-verb
lin draw_in_V = mkWV (k58 "imeä") ; --UNCHK
lin draw_into_V2 = prepV2 OP_draw_V OP_into_Prep ; -- guess-p-verb
lin draw_off_V = mkWV (k53A "vetää") "pois" ; --UNCHK
lin draw_on_V = advV OP_draw_V OP_on_Adv ; -- guess-p-verb
lin draw_on_V2 = prepV2 OP_draw_V OP_on_Prep ; -- guess-p-verb
lin draw_out_V2 = mkWV2 (k53A "vetää") "ulos" ; --UNCHK
lin draw_up_V = mkWV (k61A "laatia") ; --UNCHK
lin draw_up_V2 = mkWV2 (k61A "laatia") ; --UNCHK
lin drawback_N = mkWN (k9A "haitta") ; --UNCHK
lin drawbar_N = mkWN (compoundN "veto" (k1A "tanko")) ; --UNCHK
lin drawbridge_N = mkWN (compoundN "läppä" (k9A "silta")) ; --UNCHK
lin drawee_N = mkWN (k5A "trassaatti") ; --UNCHK
lin drawer_N = mkWN (k4A "laatikko") ; --UNCHK
lin drawing_N = mkN "piirustus" ; --WN (k1A "otto") ;
lin drawing_board_N = mkWN (compoundN "piirustus" (k9A "lauta")) ; --UNCHK
lin drawing_pin_N = mkWN (k9 "nasta") ; --UNCHK
lin drawing_room_N = mkWN (k5A "salonki") ; --UNCHK
lin drawknife_N = mkWN (compoundN "vuolin" (k30 "veitsi")) ; --UNCHK
lin drawl_N = mkWN (compoundN "puhe" (k9A "tapa")) "venyttelevä" ; --UNCHK
lin drawl_V = mkWV (k53A "venyttää") ; --UNCHK
lin drawl_V2 = mkWV2 (k53A "venyttää") ; --UNCHK
lin drawnwork_N = mkWN (compoundN "revinnäis" (k2 "ompelu")) ; --UNCHK
lin drawstring_N = mkWN (compoundN "kure" (k9 "nauha")) ; --UNCHK
lin dread_N = mkWN (k39 "aavistus") ; --UNCHK
lin dread_V = mkWV (k53A "odottaa") "pelolla" ; --UNCHK
lin dread_V2 = mkWV2 (k53A "odottaa") "pelolla" ; --UNCHK
lin dreadful_A = mkWA (k38 "hirmuinen") ; --UNCHK
lin dreadfulness_N = mkWN (k40 "hirveys") ; --UNCHK
lin dreadlock_N = mkWN (compoundN "rasta" (k5A "letti")) ; --UNCHK
lin dreadnought_N = mkWN (compoundN "panssari" (k9 "laiva")) ; --UNCHK
lin dream_N = mkWN (k10 "unelma") ; --UNCHK
lin dream_V = mkWV (k67 "haaveilla") ;
lin dream_V2 = mkWV2 (k67 "haaveilla") ; --UNCHK
lin dream_of_V2 = prepV2 OP_dream_V OP_of_Prep ; -- guess-p-verb
lin dream_up_V2 = mkWV2 (k53A "kehittää") ; --UNCHK
lin dreamer_N = mkWN (compoundN "unen" (k12 "näkijä")) ; --UNCHK
lin dreamland_N = mkWN (k18 "maa") "unelmien" ; --UNCHK
lin dreamless_A = mkWA (k34A "näkemätön") "unia" ; --UNCHK
lin dreamlike_A = mkWA (compoundA "epä" (k38 "todellinen")) ; --UNCHK
lin dreamworld_N = mkWN (k18 "maa") "unelmien" ; --UNCHK
lin dreamy_A = mkWA (compoundA "haaveks" (k9 "iva")) ; --UNCHK
lin drear_A = mkWA (k15 "synkeä") ; --UNCHK
lin dreariness_N = mkWN (k40 "ikävystyttävyys") ; --UNCHK
lin dreary_A = mkWA (k15 "synkeä") ; --UNCHK
lin dredge_N = mkWN (compoundN "ruoppaus" (k48 "kone")) ; --UNCHK
lin dredge_V = mkWV (k73A "ruopata") ; --UNCHK
lin dredge_V2 = mkWV2 (k73A "ruopata") ; --UNCHK
lin dredge_up_V2 = mkWV2 (k56 "kaivaa") "esiin" ; --UNCHK
lin dredger_N = mkWN (k10 "ruoppaaja") ; --UNCHK
lin dreg_N = mkWN (k9A "sakka") ; --UNCHK
lin dregs_N = mkWN (k9A "sakka") ; --UNCHK
lin drench_V2 = mkWV2 (k56 "kastaa") ; --UNCHK
lin drenching_N = mkWN (k39 "upotus") ; --UNCHK
lin dresden_PN = foreignPN "Dresden" ;
lin dress_A = mkWA "juhla-" ; --UNCHK
lin dress_N = mkWN (k1A "puku") ; --UNCHK
lin dress_V = mkV "pukeutua" ;
lin dress_V2 = mkV2 "pukea" ;
lin dress_down_V = mkWV (k52A "pukeutua") "rennosti" ; --UNCHK
lin dress_down_V2 = mkWV2 (k52A "pukeutua") "rennosti" ; --UNCHK
lin dress_hanger_N = mkWN (k6 "henkari") ; --UNCHK
lin dress_up_V = mkWV (k52A "pukeutua") ; --UNCHK
lin dress_up_V2 = mkWV2 (k52A "pukeutua") ; --UNCHK
lin dressage_N = mkWN (compoundN "koulu" (k39 "ratsastus")) ; --UNCHK
lin dresser_N = mkWN (k5A "piironki") ; --UNCHK
lin dressing_N = mkWN (k39 "sidos") ; --UNCHK
lin dressing_case_N = mkWN (k5 "nesessääri") ; --UNCHK
lin dressing_down_N = mkWN (k39 "läksytys") ; --UNCHK
lin dressing_gown_N = mkWN (compoundN "kylpy" (k5A "takki")) ; --UNCHK
lin dressing_table_N = mkWN (compoundN "pukeutumis" (k10A "pöytä")) ; --UNCHK
lin dressmaker_N = mkWN (k5 "modisti") ; --UNCHK
lin dressmaking_N = mkWN (compoundN "puku" (k2 "ompelu")) ; --UNCHK
lin dressy_A = mkWA "pyntätty" ; --UNCHK
lin drey_N = mkWN (compoundN "oravan" (k10 "pesä")) ; --UNCHK
lin dribble_N = mkWN (k39 "kuljetus") "pallon" ; --UNCHK
lin dribble_V = mkWV (k73 "kuolata") ; --UNCHK
lin dribble_V2 = mkWV2 (k73 "kuolata") ; --UNCHK
lin dribbler_N = mkWN (compoundN "sotta" (k1A "pytty")) ; --UNCHK
lin driblet_N = mkWN (k12 "pisara") ; --UNCHK
lin drier_N = mkWN (k6 "kuivuri") ; --UNCHK
lin driffield_PN = foreignPN "Driffield" ;
lin drift_N = mkWN (k10 "perä") ; --UNCHK
lin drift_V = mkWV (k52 "kinostua") ; --UNCHK
lin drift_V2 = mkWV2 (k52 "kinostua") ; --UNCHK
lin drift_apart_V = mkWV (k72A "loitota") ; --UNCHK
lin drift_ice_N = mkWN (compoundN "ajo" (k18 "jää")) ; --UNCHK
lin drift_net_N = mkWN (compoundN "ajo" (k1A "verkko")) ; --UNCHK
lin drift_off_V = mkWV (k61A "pilkkiä") ; --UNCHK
lin driftage_N = mkWN (k1A "sorto") ; --UNCHK
lin drifter_N = mkWN (k38 "irtolainen") ; --UNCHK
lin driftfish_N = mkWN (compoundN "polyyppi" (k9 "kala")) ; --UNCHK
lin drifting_N = mkWN "ajelehtiminen" ; --UNCHK
lin drill_N = mkWN (k39 "harjoitus") ; --UNCHK
lin drill_V = mkWV (k53A "harjoituttaa") ;
lin drill_V2 = mkWV2 (k53A "harjoituttaa") ;
lin drilling_N = mkWN (k39 "poraus") ; --UNCHK
lin drink_N = mkN "juoma" ;
lin drink_V = mkV "juoda" ;
lin drink_V2 = L.drink_V2 ;
lin drink_up_V2 = mkWV2 (k64 "juoda") "loppuun" ; --UNCHK
lin drinkable_A = mkWA (k10 "juotava") ; --UNCHK
lin drinker_N = mkWN (k1A "juoppo") ; --UNCHK
lin drinking_N = mkWN (k38 "juominen") ; --UNCHK
lin drinking_bout_N = mkWN (compoundN "juoma" (k27 "kausi")) ; --UNCHK
lin drinking_fountain_N = mkWN (compoundN "juoma" (k1 "suihku")) ; --UNCHK
lin drinking_song_N = mkWN (compoundN "juoma" (k1 "laulu")) ; --UNCHK
lin drinking_water_N = mkWN (compoundN "juoma" (k27 "vesi")) ; --UNCHK
lin drip_N = mkWN (compoundN "tippa" (k10A "nokka")) ; --UNCHK
lin drip_V = mkWV (k57A "kaataa") "tipotellen" ; --UNCHK
lin drip_V2 = mkWV2 (k57A "kaataa") "tipotellen" ; --UNCHK
lin dripless_A = mkWA (k34A "vuotamaton") ; --UNCHK
lin drippiness_N = mkWN (k40 "tunteellisuus") ; --UNCHK
lin dripping_N = mkWN "tiputtelu" ; --UNCHK
lin dripping_pan_N = mkWN (compoundN "uuni" (k1 "pannu")) ; --UNCHK
lin drippings_N = mkWN (compoundN "paistin" (k9 "rasva")) ; --UNCHK
lin drippy_A = mkWA (k38 "tunteellinen") ; --UNCHK
lin dripstone_N = mkWN (compoundN "vesi" (k9 "lista")) ; --UNCHK
lin drive_N = mkN "ajomatka" ;
lin drive_V = mkV "ajaa" ;
lin drive_V2 = mkV2 "ajaa" partitive ;
lin drive_V2V = mkV2V "ajaa" ;
lin drive_away_V2 = mkWV2 (k54A "hälventää") ; --UNCHK
lin drive_back_V2 = mkWV2 (k52 "torjua") ; --UNCHK
lin drive_by_V = advV OP_drive_V OP_by_Adv ; -- guess-p-verb
lin drive_down_V = advV OP_drive_V OP_down_Adv ; -- guess-p-verb
lin drive_off_V = mkWV (k54A "hälventää") ; --UNCHK
lin drive_out_V2 = mkWV2 (k53 "poistaa") ; --UNCHK
lin drive_up_V = mkWV (k52 "lähestyä") ; --UNCHK
lin drive_up_V2 = mkWV2 (k52 "lähestyä") ; --UNCHK
lin drivel_N = mkWN (k7A "sylki") ; --UNCHK
lin drivel_V = mkWV (k73 "kuolata") ; --UNCHK
lin driveller_N = mkWN (compoundN "sotta" (k1A "pytty")) ; --UNCHK
lin driverFem_N = mkWN (compoundN "puuykkös" (k9 "maila")) ; --UNCHK
lin driverMasc_N = mkN "ajaja" ;
lin driveshaft_N = mkWN (compoundN "käyttö" (k6 "akseli")) ; --UNCHK
lin driveway_N = mkWN (k19 "tie") ; --UNCHK
lin driving_A = mkA "ajava" ;
lin driving_N = mkWN "ajaminen" ; --UNCHK
lin driving_belt_N = mkWN (compoundN "käyttö" (k9 "hihna")) ; --UNCHK
lin driving_wheel_N = mkWN (compoundN "ohjaus" (k10 "pyörä")) ; --UNCHK
lin drizzle_N = mkWN (k1 "tihku") ; --UNCHK
lin drizzle_V = mkWV (k67 "valella") ; --UNCHK
lin drizzly_A = mkWA (k38 "tihkuinen") ; --UNCHK
lin drogheda_PN = foreignPN "Drogheda" ;
lin drogue_N = mkWN "hidastuslaskuvarjo" ; --UNCHK
lin droitwich_PN = foreignPN "Droitwich" ;
lin droll_A = mkWA (k38 "hassunkurinen") ; --UNCHK
lin drollery_N = mkWN (k9 "pila") ; --UNCHK
lin dromaeosaur_N = mkWN "dromaeosauri" ; --UNCHK
lin dromedary_N = mkWN (k6 "kameli") "yksikyttyräinen" ; --UNCHK
lin dronabinol_N = mkWN "dronabinoli" ; --UNCHK
lin drone_N = mkWN (k38 "työläinen") ; --UNCHK
lin dronfield_PN = foreignPN "Dronfield" ;
lin drool_N = mkWN (k7A "sylki") ; --UNCHK
lin drool_V = mkWV (k73 "kuolata") ; --UNCHK
lin droop_N = mkWN (k10 "painauma") ; --UNCHK
lin droop_V = mkWV (k53A "väsähtää") ; --UNCHK
lin droop_V2 = mkWV2 (k53A "väsähtää") ; --UNCHK
lin droopingly_Adv = mkWAdv (compoundAdv "nuokkuv" (k99 "asti")) ; --UNCHK
lin drop_N = mkN "putoaminen" ;
lin drop_V = mkV "pudota" ;
lin drop_V2 = mkWV2 (k53A "pudottaa") ;
lin drop_around_V = advV OP_drop_V OP_around_Adv ; -- guess-p-verb
lin drop_around_V2 = prepV2 OP_drop_V OP_around_Prep ; -- guess-p-verb
lin drop_away_V = mkWV (k74A "pudota") ; --UNCHK
lin drop_back_V = mkWV (k52A "vetäytyä") "taakse" ; --UNCHK
lin drop_by_V = mkWV (k74A "poiketa") ; --UNCHK
lin drop_curtain_N = mkWN (compoundN "väli" (k1 "verho")) ; --UNCHK
lin drop_in_V = mkWV (k74A "poiketa") ; --UNCHK
lin drop_in_on_V2 = prepV2 (advV OP_drop_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin drop_off_V = mkWV (k61A "pilkkiä") ; --UNCHK
lin drop_off_V2 = mkWV2 (k61A "pilkkiä") ; --UNCHK
lin drop_out_V = mkWV (k53A "keskeyttää") ; --UNCHK
lin drop_out_of_V2 = prepV2 (advV OP_drop_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin drop_over_V = advV OP_drop_V OP_over_Adv ; -- guess-p-verb
lin drop_round_V = advV OP_drop_V OP_round_Adv ; -- guess-p-verb
lin drop_round_V2 = prepV2 OP_drop_V OP_round_Prep ; -- guess-p-verb
lin drop_someone_in_it_V2 = variants {} ; -- guess-p-verb
lin drop_through_V = advV OP_drop_V OP_through_Adv ; -- guess-p-verb
lin dropkick_N = mkWN (k1 "pudotuspotku") ; --UNCHK
lin dropkicker_N = mkWN (compoundN "pudotuspotkai" (k9 "sija")) ; --UNCHK
lin droplet_N = mkWN (k9A "tippa") ; --UNCHK
lin dropline_N = mkWN (compoundN "porras" (k9 "viiva")) ; --UNCHK
lin dropout_N = mkN "keskeyttänyt" ;
lin dropper_N = mkWN (k5A "pipetti") ; --UNCHK
lin dropping_zone_N = mkWN (compoundN "pudotus" (k48 "alue")) ; --UNCHK
lin droppings_N = mkWN (k10A "sonta") ; --UNCHK
lin dropseed_N = mkWN (k10 "heinä") ; --UNCHK
lin dropsical_A = mkWA (compoundA "vesi" (k38 "pöhöinen")) ; --UNCHK
lin dropsy_N = mkWN (k39 "turvotus") ; --UNCHK
lin drosophila_N = mkWN (compoundN "banaani" (k38 "kärpänen")) ; --UNCHK
lin dross_N = mkWN (k10 "kuona") ; --UNCHK
lin drought_N = mkN (lin NK {s = d40 "kuivuus"}) ;
lin drove_N = mkWN (compoundN "kivi" (k9A "taltta")) ; --UNCHK
lin drover_N = mkWN (k32 "paimen") ; --UNCHK
lin drown_V = mkWV (k52A "hukkua") ; --UNCHK
lin drown_V2 = mkWV2 (k52A "hukkua") ; --UNCHK
lin drown_out_V2 = mkWV2 (k53A "peittää") ; --UNCHK
lin drowse_N = mkWN (k2 "torkahtelu") ; --UNCHK
lin drowse_V = mkWV (k52A "nuokkua") ; --UNCHK
lin drowse_V2 = mkWV2 (k52A "nuokkua") ; --UNCHK
lin drowsiness_N = mkWN (k40 "raukeus") ; --UNCHK
lin drowsy_A = mkWA (k41 "unelias") ; --UNCHK
lin drub_V2 = mkWV2 (k53A "rökittää") ; --UNCHK
lin drubbing_N = mkWN (k39 "löylytys") ; --UNCHK
lin drudge_N = mkWN (kH1 "peoni") ; --UNCHK
lin drudge_V = mkWV (k53 "uurastaa") ; --UNCHK
lin drudgery_N = mkWN (k39 "uurastus") ; --UNCHK
lin drug_N = mkWN (k48 "huume") | mkN "lääke" ; ---- split
lin drug_V2 = mkWV2 (k73 "huumata") ; --UNCHK
lin drugget_N = mkWN (k41A "huopakangas") ; --UNCHK
lin druggist_N = mkWN (k6 "proviisori") ; --UNCHK
lin drugless_A = mkWA "lääkkeetön" ; --UNCHK
lin drugstore_N = mkWN (k5A "apteekki") ;
lin druid_N = mkWN (k5 "druidi") ; --UNCHK
lin druidism_N = mkWN (compoundN "druid" (k5 "ismi")) ; --UNCHK
lin drum_N = mkWN (compoundN "rumpu" (k9 "kala")) ; --UNCHK
lin drum_V = mkV "rummuttaa" ; --mkWV (k56A "ahtaa") "päähänsä" ;
lin drum_V2 = mkWV2 (k56A "ahtaa") "päähänsä" ; --UNCHK
lin drum_major_N = mkWN (k10 "johtaja") "soittokunnan" ; --UNCHK
lin drum_majorette_N = mkWN (k10 "johtaja") "paraatisoittokunnan" ; --UNCHK
lin drum_out_V2 = mkWV2 (k56A "antaa") "potkut" ; --UNCHK
lin drum_up_V2 = mkWV2 (k74A "koota") ; --UNCHK
lin drumbeat_N = mkWN (k39 "rummutus") ; --UNCHK
lin drumfire_N = mkWN (compoundN "tykistö" (k23 "tuli")) ; --UNCHK
lin drumhead_A = mkWA "pika-" ; --UNCHK
lin drumhead_N = mkWN (k1 "kalvo") ; --UNCHK
lin drumlin_N = mkWN (compoundN "pitkittäis" (k6 "moreeni")) ; --UNCHK
lin drummer_N = mkWN (k6 "rumpali") ; --UNCHK
lin drumming_N = mkWN (k1A "soitto") "rumpujen" ; --UNCHK
lin drumstick_N = mkWN (compoundN "rumpu" (k12 "kapula")) ; --UNCHK
lin drunk_A = mkWA (k38 "humalainen") ; --UNCHK
lin drunk_N = mkWN (k1A "juoppo") ; --UNCHK
lin drunkard_N = mkWN (k38 "humalainen") ; --UNCHK
lin drunken_A = mkWA (k38 "humalainen") ; --UNCHK
lin drunkenness_N = mkWN (k38 "juominen") ; --UNCHK
lin drupaceous_A = mkWA (compoundA "luu" (k38 "marjainen")) ; --UNCHK
lin drupe_N = mkWN (compoundN "luu" (k9 "marja")) ; --UNCHK
lin drupelet_N = mkWN (compoundN "luu" (k9 "marja")) "pieni" ; --UNCHK
lin dry_A = L.dry_A ;
lin dry_N = mkWN (k10 "kannattaja") "kieltolain" ; --UNCHK
lin dry_V = mkWV (k53A "kuivattaa") ; --UNCHK
lin dry_V2 = mkWV2 (k53A "kuivattaa") ; --UNCHK
lin dry_clean_V2 = mkWV2 (compoundV "kuiva" (k66 "pestä")) ; --UNCHK
lin dry_cleaner_N = mkWN (compoundN "pesulan" (k10 "pitäjä")) ; --UNCHK
lin dry_cleaning_N = mkWN (k50 "kuivapesu") ; --UNCHK
lin dry_off_V2 = prepV2 OP_dry_V OP_off_Prep ; -- guess-p-verb
lin dry_out_V = mkWV (k53A "kuivattaa") ; --UNCHK
lin dry_out_V2 = mkWV2 (k53A "kuivattaa") ; --UNCHK
lin dry_up_V = mkWV (k52 "kuivua") ; --UNCHK
lin dry_up_V2 = mkWV2 (k52 "kuivua") ; --UNCHK
lin dry_walling_N = mkWN "kivimuurin" "rakentaminen" ; --UNCHK
lin dryad_N = mkWN (compoundN "metsän" (k1A "neito")) ; --UNCHK
lin dryer_N = mkWN (k6 "kuivuri") ; --UNCHK
lin drygoods_N = mkWN (k50 "lyhyttavara") ; --UNCHK
lin dryness_N = mkWN (k40 "arkipäiväisyys") ; --UNCHK
lin dryopithecine_N = mkWN (k5 "hominidi") ; --UNCHK
lin drypis_N = mkWN (k5A "yrtti") ; --UNCHK
lin dual_A = mkA "duaalinen" ;
lin dualism_N = mkWN (k5 "dualismi") ; --UNCHK
lin dualist_N = mkWN "dualisti" ; --UNCHK
lin dualistic_A = mkWA (k38 "dualistinen") ; --UNCHK
lin duality_N = mkWN (k40 "kahtalaisuus") ; --UNCHK
lin dub_N = mkWN (k39 "dubbaus") ; --UNCHK
lin dub_V2 = mkWV2 (k73 "dubata") ; --UNCHK
lin dub_V3 = mkWV3 (k73 "dubata") ; --UNCHK
lin dubbin_N = mkWN (compoundN "nahka" (k48A "voide")) ; --UNCHK
lin dubbing_N = mkWN (k39 "dubbaus") ; --UNCHK
lin dubiety_N = mkWN (k2 "epäily") ; --UNCHK
lin dubious_A = mkA (mkN "kyseen" (mkN "alainen")) ; --mkWA (k10 "epäilevä") ;
lin dubiousness_N = mkWN (k39 "kysymys") ; --UNCHK
lin dublin_PN = foreignPN "Dublin" ;
lin dubliner_N = mkWN (compoundN "dublini" (k38 "lainen")) ; --UNCHK
lin dubnium_N = mkWN "järjestysluku" "105" ; --UNCHK
lin ducal_A = mkWA (compoundA "herttua" (k38 "llinen")) ; --UNCHK
lin ducat_N = mkWN "dukaatti" ; --UNCHK
lin duce_N = mkWN (k10 "johtaja") ; --UNCHK
lin duchess_N = mkWN (k32A "herttuatar") ; --UNCHK
lin duchy_N = mkWN (compoundN "herttua" (k10A "kunta")) ; --UNCHK
lin duck_N = mkWN (k10 "sorsa") ; --UNCHK
lin duck_V = mkWV (k67A "luikerrella") ; --UNCHK
lin duck_V2 = mkWV2 (k67A "luikerrella") ; --UNCHK
lin duckbill_A = mkWA "nokka-" ; --UNCHK
lin ducking_N = mkWN (compoundN "kas" (k38 "taminen")) ; --UNCHK
lin ducking_stool_N = mkWN (compoundN "rangaistus" (k5 "tuoli")) ; --UNCHK
lin duckling_N = mkWN (compoundN "ankan" (k38 "poikanen")) ; --UNCHK
lin duckpin_N = mkWN (k9 "keila") "matala" ; --UNCHK
lin duckpins_N = mkWN (compoundN "keila" (k5 "peli")) ; --UNCHK
lin duckweed_N = mkWN (k13 "limaska") ; --UNCHK
lin ducky_N = mkWN (k41A "rakas") ; --UNCHK
lin duct_N = mkWN (k7 "putki") ; --UNCHK
lin ductile_A = mkWA (k38 "mukautuvainen") ; --UNCHK
lin ductility_N = mkWN (k40 "taottavuus") ; --UNCHK
lin ductless_A = mkWA "umpi-" ; --UNCHK
lin dud_A = mkWA (k6 "suutari") ; --UNCHK
lin dud_N = mkWN (k5A "floppi") ; --UNCHK
lin dude_N = mkWN (k12 "hienostelija") ; --UNCHK
lin dudgeon_N = mkWN (k9 "vimma") "vihan" ; --UNCHK
lin dudley_PN = foreignPN "Dudley" ;
lin due_A = mkA "asianmukainen" ;
lin due_Adv = mkWAdv (k99 "suoraan") ; --UNCHK
lin due_N = mkN "oikeus" ; ---ARB --mkN "maksu" ; --mkWN (k10 "osa") ;
lin due_to_Prep = mkPrep "johdosta" ;
lin duel_N = mkWN (compoundN "kaksin" (k2 "kamppailu")) ; --UNCHK
lin duel_V = mkWV (k67 "olla") "kaksintaistelussa" ; --UNCHK
lin dueler_N = mkWN (compoundN "kaksin" (k12 "taistelija")) ; --UNCHK
lin duellist_N = mkWN (compoundN "kaksin" (k12 "taistelija")) ; --UNCHK
lin duenna_N = mkWN (compoundN "seura" (k38 "nainen")) ; --UNCHK
lin duet_N = mkWN (compoundN "kaksin" (k5 "tanssi")) ; --UNCHK
lin duff_N = mkWN (compoundN "luumu" (k41A "vanukas")) ; --UNCHK
lin duffel_N = mkWN (k41A "duffelikangas") ; --UNCHK
lin duffer_N = mkWN (k6 "tunari") ; --UNCHK
lin duffle_N = mkWN (k41A "duffelikangas") ; --UNCHK
lin dug_N = mkWN (k49 "utare") ; --UNCHK
lin dugong_N = mkWN (compoundN "meri" (k10 "lehmä")) ; --UNCHK
lin dugout_N = mkWN (k6 "bunkkeri") ; --UNCHK
lin duisburg_PN = foreignPN "Duisburg" ;
lin duke_N = mkWN (k12 "herttua") ; --UNCHK
lin dukedom_N = mkWN (compoundN "herttua" (k10A "kunta")) ; --UNCHK
lin dukinfield_PN = foreignPN "Dukinfield" ;
lin dulcet_A = mkWA (k10 "miellyttävä") ; --UNCHK
lin dulciana_N = mkWN "huuliäänikerta" ; --UNCHK
lin dulcimer_N = mkWN "dulcimer" ; --UNCHK
lin dull_A = L.dull_A ;
lin dull_V = mkWV (k54A "heikentää") ; --UNCHK
lin dull_V2 = mkWV2 (k54A "heikentää") ; --UNCHK
lin dullard_N = mkWN (k39 "typerys") ; --UNCHK
lin dullness_N = mkWN (k40 "tylsyys") ; --UNCHK
lin dulse_N = mkWN (compoundN "puna" (k10 "levä")) ; --UNCHK
lin duly_AdV = mkAdV "odotetusti" ;
lin duly_Adv = variants {} ; -- mkAdV "odotetusti" ;
lin dumb_A = mkWA (k10A "mykkä") ;
lin dumbarton_PN = foreignPN "Dumbarton" ;
lin dumbbell_N = mkWN (k1 "paino") ; --UNCHK
lin dumbfound_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin dumbness_N = mkWN (k40 "typeryys") ; --UNCHK
lin dumbwaiter_N = mkWN (compoundN "ruoka" (k5 "hissi")) ; --UNCHK
lin dumdum_N = mkWN (k5A "luoti") "räjähtävä" ; --UNCHK
lin dumfries_PN = foreignPN "Dumfries" ;
lin dummy_A = mkWA "vale-" ; --UNCHK
lin dummy_N = mkWN (k13 "paukkupatruuna") ; --UNCHK
lin dump_N = mkWN (k2 "varasto") ; --UNCHK
lin dump_V = mkWV (k73 "tyrmätä") ; --UNCHK
lin dump_V2 = mkV2 (mkV (mkV "heittää") "pois") ; --WV2 (k73 "tyrmätä") ;
lin dumpcart_N = mkWN (compoundN "kotti" (k1 "kärry")) ; --UNCHK
lin dumper_N = mkWN (compoundN "kuorma-" (k1 "auto")) "kääntyvälavainen" ; --UNCHK
lin dumpiness_N = mkWN (k40 "tanakkuus") ; --UNCHK
lin dumping_N = mkWN (k39 "dumppaus") ; --UNCHK
lin dumpling_N = mkWN (k41 "piiras") ; --UNCHK
lin dumps_N = mkWN (k40 "synkkyys") ; --UNCHK
lin dumpy_A = mkWA (k38 "sotkuinen") ; --UNCHK
lin dun_A = mkWA (compoundA "harmaan" (k15 "ruskea")) ; --UNCHK
lin dun_N = mkWN (k38 "hevonen") "harmaanruskea" ; --UNCHK
lin dun_V2 = mkWV2 (k53A "harmaannuttaa") ; --UNCHK
lin duncan_PN = foreignPN "Duncan" ;
lin dunce_N = mkWN (k1 "tollo") ; --UNCHK
lin dundalk_PN = foreignPN "Dundalk" ;
lin dundee_PN = foreignPN "Dundee" ;
lin dunderhead_N = mkWN (k1 "tollo") ; --UNCHK
lin dune_N = mkWN (k5 "dyyni") ;
lin dunfermline_PN = foreignPN "Dunfermline" ;
lin dung_N = mkWN (k10A "sonta") ; --UNCHK
lin dungeon_N = mkWN (compoundN "vanki" (k10 "tyrmä")) ; --UNCHK
lin dunghill_N = mkWN (k3 "tunkio") ; --UNCHK
lin dunk_N = mkWN (k39 "donkkaus") ; --UNCHK
lin dunk_V2 = mkWV2 (k73A "dipata") ; --UNCHK
lin dunker_N = mkWN "kastaja" ; --UNCHK
lin dunkirk_PN = foreignPN "Dunkirk" ;
lin dunoon_PN = foreignPN "Dunoon" ;
lin dunstable_PN = foreignPN "Dunstable" ;
lin duo_N = mkN "duo" ;
lin duodecimal_A = mkWA (compoundA "kaks" (k38 "itoistakantainen")) ; --UNCHK
lin duodenal_A = mkWA "pohjukaissuolen" ; --UNCHK
lin duodenum_N = mkWN (compoundN "pohjukais" (k26 "suoli")) ; --UNCHK
lin duologue_N = mkWN (compoundN "kaksin" (k2 "puhelu")) ; --UNCHK
lin dupe_N = mkWN (k1 "hölmö") "hyväuskoinen" ; --UNCHK
lin dupe_V2 = mkWV2 (k73 "narrata") ; --UNCHK
lin duplex_A = mkWA (compoundA "kaksi" (k38 "suuntainen")) ; --UNCHK
lin duplicable_A = mkWA "kopioitava" ; --UNCHK
lin duplicate_A = mkWA (kH1 "pari") ; --UNCHK
lin duplicate_N = mkWN (k39 "jäljennös") ; --UNCHK
lin duplicate_V2 = mkWV2 (k52 "kaksinkertaistua") ; --UNCHK
lin duplication_N = mkWN (k5A "kopiointi") ; --UNCHK
lin duplicator_N = mkWN (compoundN "kopio" (k48 "kone")) ; --UNCHK
lin duplicity_N = mkWN (k40 "petollisuus") ; --UNCHK
lin durability_N = mkWN (k1 "kesto") ; --UNCHK
lin durable_A = mkA "kestävä" ;
lin durable_N = mkN "kestokulutus" (mkN "hyödyke") ;
lin dural_A = mkWA "kovakalvon" ; --UNCHK
lin durance_N = mkWN (k40 "vankeus") ; --UNCHK
lin duration_N = mkWN (k40 "pituus") ; --UNCHK
lin durative_N = mkWN (k5 "aspekti") "duratiivinen" ; --UNCHK
lin durban_PN = foreignPN "Durban" ;
lin durbar_N = mkWN (compoundN "vastaanotto" (k5 "sali")) ; --UNCHK
lin duress_N = mkWN (k1A "pakko") ; --UNCHK
lin durham_PN = foreignPN "Durham" ;
lin durian_N = mkWN "durio" ; --UNCHK
lin during_Prep = S.during_Prep | postGenPrep "kuluessa" ;
lin durmast_N = mkWN (k7 "talvitammi") ; --UNCHK
lin durra_N = mkWN (k10 "durra") ; --UNCHK
lin durrington_PN = foreignPN "Durrington" ;
lin dursley_PN = foreignPN "Dursley" ;
lin durum_N = mkWN (compoundN "durum" (k10 "vehnä")) ; --UNCHK
lin dusk_N = mkWN (k1 "hämy") ; --UNCHK
lin dusky_A = mkWA (k10 "tumma") ; --UNCHK
lin dust_N = L.dust_N ;
lin dust_V2 = mkWV2 (k53A "tomuttaa") ; --UNCHK
lin dust_bowl_N = mkWN "tomumyrskyalue" ; --UNCHK
lin dust_coat_N = mkWN (k12 "kauhtana") ; --UNCHK
lin dust_jacket_N = mkWN (compoundN "kirjan" (k39 "päällys")) ; --UNCHK
lin dust_sheet_N = mkWN (compoundN "irto" (k38 "päällinen")) ; --UNCHK
lin dust_wrapper_N = mkWN (compoundN "kirjan" (k39 "päällys")) ; --UNCHK
lin dustbin_N = mkWN (k39 "roskis") ; --UNCHK
lin dustcart_N = mkWN (compoundN "jäte" (k1 "auto")) ; --UNCHK
lin dustcloth_N = mkWN (compoundN "tomu" (k1A "riepu")) ; --UNCHK
lin duster_N = mkWN (k1A "syöttö") ; --UNCHK
lin dustiness_N = mkWN (k40 "pölyisyys") ; --UNCHK
lin dustlike_A = mkWA (compoundA "pöly" (k38 "mäinen")) ; --UNCHK
lin dustman_N = mkWN (compoundN "roska" (k5 "kuski")) ; --UNCHK
lin dustmop_N = mkWN (compoundN "pöly" (k5A "moppi")) ; --UNCHK
lin dustpan_N = mkWN (k6 "kihveli") ; --UNCHK
lin dusty_A = mkWA (k10 "koinsyömä") ; --UNCHK
lin dutchFem_N = mkN "hollantilainen" ;
lin dutchMasc_N = mkN "hollantilainen" ;
lin dutch_A = mkA "hollantilainen" ;
lin dutchman_N = mkWN (k38 "hollantilainen") ; --UNCHK
lin duteous_A = mkWA (k38 "kuuliainen") ; --UNCHK
lin dutiable_A = mkWA (compoundA "tullin" (k38 "alainen")) ; --UNCHK
lin dutiful_A = mkWA (k38 "kuuliainen") ; --UNCHK
lin dutifulness_N = mkWN (k40 "kuuliaisuus") ; --UNCHK
lin duty_N = mkN (lin NK {s = d40 "velvollisuus"}) ;
lin duty_free_A = mkA "verovapaa" ;
lin duvet_N = mkWN (kH1 "täkki") ; --UNCHK
lin dwarf_N = mkWN (k3 "kääpiö") ; --UNCHK
lin dwarf_V2 = mkWV2 (k53A "jättää") "pienikokoiseksi" ; --UNCHK
lin dwarfish_A = mkWA (compoundA "kääpiö" (k38 "mäinen")) ; --UNCHK
lin dwarfishness_N = mkWN (compoundN "kääpiömä" (k40 "isyys")) ; --UNCHK
lin dwarfism_N = mkWN (compoundN "kääpiö" (k1 "kasvu")) ; --UNCHK
lin dwell_V = mkWV (k52A "hautoa") ; --UNCHK
lin dwell_on_V2 = mkWV2 (k52A "viipyä") ; --UNCHK
lin dweller_N = mkN "asukas" ;
lin dwelling_N = mkWN (k1A "asunto") ; --UNCHK
lin dwelling_house_N = mkWN (k1A "asunto") ; --UNCHK
lin dwindle_V = mkWV (k72 "vähetä") ; --UNCHK
lin dwindling_N = mkWN "pieneneminen" ; --UNCHK
lin dyarchy_N = mkWN (compoundN "kaksin" (k9A "valta")) ; --UNCHK
lin dybbuk_N = mkWN "dibbuk" ; --UNCHK
lin dye_N = mkWN (k5 "väri") ; --UNCHK
lin dye_V = mkWV (k53A "sävyttää") ;
lin dye_V2 = mkWV2 (k53A "sävyttää") ; --UNCHK
lin dyeing_N = mkWN (k39 "värjäys") ; --UNCHK
lin dyer_N = mkWN (k6 "värjäri") ; --UNCHK
lin dyestuff_N = mkWN (k5 "väri") ; --UNCHK
lin dyewood_N = mkWN (compoundN "väri" (k18 "puu")) ; --UNCHK
lin dyke_N = mkWN (k1A "pato") ; --UNCHK
lin dyke_V = mkWV (k62 "ympäröidä") "vallilla" ; --UNCHK
lin dyke_V2 = mkWV2 (k62 "ympäröidä") "vallilla" ; --UNCHK
lin dynamic_A = mkWA (k38 "dynaaminen") ;
lin dynamic_N = mkWN (k33 "kannustin") ; --UNCHK
lin dynamics_N = mkWN (k9A "kinetiikka") ; --UNCHK
lin dynamism_N = mkWN (k1 "tarmo") ; --UNCHK
lin dynamite_N = mkWN (k5A "dynamiitti") ; --UNCHK
lin dynamite_V2 = mkWV2 (k53A "räjäyttää") "dynamiitilla" ; --UNCHK
lin dynamiter_N = mkWN (compoundN "dynamiitti" (k6 "sankari")) ; --UNCHK
lin dynamo_N = mkWN (k2 "dynamo") ; --UNCHK
lin dynamometer_N = mkWN (k5 "ergometri") ; --UNCHK
lin dynast_N = mkWN (k41 "ruhtinas") ; --UNCHK
lin dynastic_A = mkWA "dynastinen" ; --UNCHK
lin dynasty_N = mkWN (k12 "dynastia") ; --UNCHK
lin dyne_N = mkWN "dyne" ; --UNCHK
lin dysaphia_N = mkWN "kosketustunnon" "häiriintyminen" ; --UNCHK
lin dysarthria_N = mkWN "dysartria" ; --UNCHK
lin dyscalculia_N = mkWN "dyskalkulia" ; --UNCHK
lin dyschezia_N = mkWN (compoundN "ulostamis" (k40 "vaikeus")) ; --UNCHK
lin dyscrasia_N = mkWN (compoundN "dysk" (k12 "rasia")) ; --UNCHK
lin dysentery_N = mkWN (compoundN "puna" (k5A "tauti")) ; --UNCHK
lin dysfunction_N = mkWN (compoundN "toiminta" (k3 "häiriö")) ; --UNCHK
lin dysfunctional_A = mkWA "mukautumaton" ; --UNCHK
lin dysgenesis_N = mkWN "dysgeneesi" ; --UNCHK
lin dysgenic_A = mkWA "rappeuttava" ; --UNCHK
lin dysgenics_N = mkWN (compoundN "rappeutumis" (k5A "oppi")) ; --UNCHK
lin dysgraphia_N = mkWN (compoundN "kirjoitus" (k3 "häiriö")) ; --UNCHK
lin dyskinesia_N = mkWN (compoundN "liikunta" (k3 "häiriö")) ; --UNCHK
lin dyslectic_A = mkWA (compoundA "lukihäiri" (k38 "öinen")) ; --UNCHK
lin dyslectic_N = mkWN (compoundN "kirjoitushäiri" (k38 "öinen")) "luku-" "ja" ; --UNCHK
lin dyslexia_N = mkWN (compoundN "luku" (k3 "häiriö")) ; --UNCHK
lin dyslexic_A = mkWA "dysleksinen" ; --UNCHK
lin dyslogia_N = mkWN "aivosyntyinen" "sekavapuheisuus" ; --UNCHK
lin dyslogistic_A = mkWA (k10 "alentava") ; --UNCHK
lin dysmenorrhea_N = mkWN "dysmenorrea" ; --UNCHK
lin dysomia_N = mkWN (k3 "häiriö") "hajuaistin" ; --UNCHK
lin dysosmia_N = mkWN (k3 "häiriö") "hajuaistin" ; --UNCHK
lin dyspepsia_N = mkWN (compoundN "maha" (k5A "tauti")) ; --UNCHK
lin dyspeptic_A = mkWA (k10 "pahoinvoiva") ; --UNCHK
lin dyspeptic_N = mkWN (k38 "ihminen") "ruoansulatushäiriöinen" ; --UNCHK
lin dysphagia_N = mkWN (compoundN "nielemis" (k3 "häiriö")) ; --UNCHK
lin dysphasia_N = mkWN (k12 "dysfasia") ; --UNCHK
lin dysphemism_N = mkWN (compoundN "kierto" (k39 "ilmaus")) "alkuperäistä" "karkeampi" ; --UNCHK
lin dysphemistic_A = mkWA (k10 "alentava") ; --UNCHK
lin dysphonia_N = mkWN (compoundN "ääntö" (k3 "häiriö")) ; --UNCHK
lin dysphoria_N = mkWN (k1 "olo") "epämiellyttävä" ; --UNCHK
lin dysphoric_A = mkWA (k34A "onneton") ; --UNCHK
lin dysplasia_N = mkWN (compoundN "kasvu" (k3 "häiriö")) ; --UNCHK
lin dysplastic_A = mkWA "kasvuhäiriöön" "liittyvä" ; --UNCHK
lin dyspnea_N = mkWN (compoundN "hengen" (k39 "ahdistus")) ; --UNCHK
lin dysprosium_N = mkWN "järjestysluku" "66" ; --UNCHK
lin dysthymia_N = mkWN (k40 "masentuneisuus") "pitkäaikainen" ; --UNCHK
lin dystopia_N = mkWN "dystopia" ; --UNCHK
lin dystopian_A = mkWA "dystopinen" ; --UNCHK
lin dystrophy_N = mkWN (k10 "surkastuma") ; --UNCHK
lin dysuria_N = mkWN (compoundN "virtsaamis" (k3 "häiriö")) ; --UNCHK
lin e'en_Adv = mkWAdv (k99 "tasan") ; --UNCHK
lin e'er_Adv = mkWAdv (k99 "alati") ; --UNCHK
lin e_N = mkWN "e" ; --UNCHK
lin each_Det = mkDet Sg (mkN "jokainen") ;
lin eager_A = mkA "innokas" ;
lin eagerness_N = mkWN (k40 "innokkuus") ;
lin eagle_N = mkWN (k10 "kotka") ; --UNCHK
lin eaglescliffe_PN = foreignPN "Eaglescliffe" ;
lin eaglet_N = mkWN (compoundN "kotkan" (k38 "poikanen")) ; --UNCHK
lin ealing_PN = foreignPN "Ealing" ;
lin ear_N = L.ear_N ;
lin ear_trumpet_N = mkWN (compoundN "kuulo" (k7 "torvi")) ; --UNCHK
lin earache_N = mkWN (compoundN "korva" (k1A "kipu")) ; --UNCHK
lin eardrop_N = mkWN (compoundN "korva" (k41A "rengas")) ; --UNCHK
lin eardrum_N = mkWN (compoundN "täry" (k1 "kalvo")) ; --UNCHK
lin eared_A = mkWA (k38 "-korvainen") ; --UNCHK
lin earflap_N = mkWN (compoundN "korvan" (k39 "suojus")) ; --UNCHK
lin earful_N = mkWN (k39 "läksytys") ; --UNCHK
lin earl_N = mkWN (k5 "kreivi") ; --UNCHK
lin earless_A = mkWA "korvaton" ; --UNCHK
lin earlier_A = mkWA (k16A "aiempi") ; --UNCHK
lin earlier_Adv = mkWAdv (k99 "aiemmin") ;
lin earliness_N = mkWN (k40 "aikaisuus") ; --UNCHK
lin earlobe_N = mkWN (compoundN "korvan" (k14A "nipukka")) ; --UNCHK
lin early_A = mkA "aikainen" ;
lin early_Adv = mkAdv "aikaisin" ;
lin early_on_Adv = mkWAdv (k99 "varhain") ; --UNCHK
lin earlyish_A = mkWA (k99 "aikaisin") "melko" ; --UNCHK
lin earmark_N = mkWN (compoundN "korva" (k5A "merkki")) ; --UNCHK
lin earmark_V2 = mkV2 (mkV "korva" (mkV "merkitä")) ;
lin earmuff_N = mkWN (compoundN "korva" (k1A "lappu")) ; --UNCHK
lin earn_V = mkWV (k53A "tuottaa") ; --f64
lin earn_V2 = mkV2 "ansaita" ;
lin earner_N = mkWN (compoundN "palkan" (k10 "saaja")) ; --UNCHK
lin earnest_A = mkWA (k38 "asiallinen") ; --UNCHK
lin earnest_N = mkWN (k40 "vakuus") ; --UNCHK
lin earnest_money_N = mkWN (compoundN "käsi" (k9 "raha")) ; --UNCHK
lin earnestness_N = mkWN (k40 "vilpittömyys") ; --UNCHK
lin earning_N = mkN "ansio" ;
lin earphone_N = mkWN (k48A "kuuloke") ; --UNCHK
lin earpiece_N = mkWN (k48A "kuuloke") ; --UNCHK
lin earplug_N = mkWN (compoundN "korva" (k10A "tulppa")) ; --UNCHK
lin earring_N = mkWN (compoundN "korva" (k41A "rengas")) ; --UNCHK
lin earshot_N = mkWN (compoundN "kuulo" (k9 "matka")) ; --UNCHK
lin earth_N = L.earth_N ;
lin earth_V2 = mkWV2 (k56A "maattaa") ; --UNCHK
lin earthball_N = mkWN (k2 "tuhkelo") ; --UNCHK
lin earthborn_A = mkWA (k38 "kuolevainen") ; --UNCHK
lin earthbound_A = mkWA "maahan" "sidottu" ; --UNCHK
lin earthen_A = mkWA "savi-" ; --UNCHK
lin earthenware_N = mkWN (k9A "keramiikka") ; --UNCHK
lin earthlike_A = mkWA "maan" ; --UNCHK
lin earthly_A = mkWA (k38 "maallinen") ; --UNCHK
lin earthnut_N = mkWN (k6 "tryffeli") ; --UNCHK
lin earthquake_N = mkWN (compoundN "maan" (k39 "järistys")) ; --f263
lin earthshaking_A = mkWA (k10 "mullistava") "maailmaa" ; --UNCHK
lin earthstar_N = mkWN (compoundN "maa" (k7A "tähti")) ; --UNCHK
lin earthtongue_N = mkWN (k26 "sieni") ; --UNCHK
lin earthwork_N = mkWN (compoundN "maa" (k5 "valli")) ; --UNCHK
lin earthworm_N = mkWN (k1 "liero") ; --UNCHK
lin earthy_A = mkWA "maa-" ; --UNCHK
lin earwax_N = mkWN (k1A "vaikku") ; --UNCHK
lin earwig_N = mkWN (compoundN "isopihti" (k10A "häntä")) ; --UNCHK
lin ease_N = mkWN (k1A "lepo") ; --UNCHK
lin ease_V = mkV "lievittyä" ; --f55
lin ease_V2 = mkWV2 (k53A "lievittää") partitive ;
lin ease_off_V2 = mkWV2 (k53A "hellittää") ; --UNCHK
lin ease_up_V = mkWV (k53A "hellittää") ; --UNCHK
lin easel_N = mkWN (compoundN "maalaus" (k48 "teline")) ; --UNCHK
lin easement_N = mkWN (k39 "helpotus") ; --UNCHK
lin easiness_N = mkWN (k40 "mukavuus") ; --UNCHK
lin easing_N = mkWN (k39 "helpotus") ; --UNCHK
lin easington_PN = foreignPN "Easington" ;
lin east_A = mkWA (k38 "itäinen") ;
lin east_Adv = mkWAdv (k99 "päin") "itään" ; --UNCHK
lin east_N = mkWN (k10A "itä") ; --UNCHK
lin eastbourne_PN = foreignPN "Eastbourne" ;
lin easter_N = mkWN (compoundN "itä" (k26 "tuuli")) ; --UNCHK
lin easterly_A = mkWA (k38 "itäinen") ; --UNCHK
lin easterly_Adv = mkWAdv "idästä" | adjAdv easterly_A ; --UNCHK -- derived
lin eastern_A = mkA "itäinen" ;
lin easterner_N = mkWN (k41A "asukas") "itäosan" ; --UNCHK
lin easternmost_A = mkWA "itäisin" ; --UNCHK
lin eastleigh_PN = foreignPN "Eastleigh" ;
lin eastside_A = mkWA (compoundA "itä" (k38 "puolinen")) ; --UNCHK
lin eastward_Adv = mkWAdv (k99 "päin") "itään" ; --UNCHK
lin eastwards_Adv = mkWAdv (k99 "päin") "itään" ; --UNCHK
lin easy_A = mkA "helppo" ;
lin easy_A2V = L.easy_A2V ;
lin easy_Adv = mkWAdv (k99 "helposti") ;
lin easygoing_A = mkWA (k1A "rento") ; --UNCHK
lin easygoingness_N = mkWN (k40 "rentous") ; --UNCHK
lin eat_V = mkV "syödä" ;
lin eat_V2 = L.eat_V2 ;
lin eat_away_V = mkWV (k53A "rapauttaa") ; --UNCHK
lin eat_away_V2 = mkWV2 (k53A "rapauttaa") ; --UNCHK
lin eat_in_V = mkWV (k64 "syödä") "kotona" ; --UNCHK
lin eat_into_V2 = mkWV2 (k53A "jäytää") ; --UNCHK
lin eat_out_V = mkWV (k64 "syödä") "ravintolassa" ; --UNCHK
lin eat_up_V2 = mkWV2 (k53A "kuluttaa") "loppuun" ; --UNCHK
lin eatable_A = mkWA (k10 "syötävä") ; --UNCHK
lin eatable_N = mkWN (k10 "muona") ; --UNCHK
lin eatage_N = mkWN (k4A "nurmikko") ; --UNCHK
lin eater_N = mkWN "syönti-" ; --UNCHK
lin eating_N = mkWN (k2 "ruokailu") ; --UNCHK
lin eating_apple_N = mkWN (compoundN "syönti" (k11 "omena")) ; --UNCHK
lin eating_house_N = mkWN (k12 "ruokala") ; --UNCHK
lin eau_de_cologne_N = mkWN (compoundN "kölnin" (k27 "vesi")) ; --UNCHK
lin eau_de_vie_N = mkWN (k5A "konjakki") ; --UNCHK
lin eaves_N = mkWN (k41 "räystäs") ; --UNCHK
lin eavesdrop_V = mkWV (k67A "kuunnella") "salaa" ; --UNCHK
lin eavesdropper_N = mkWN (compoundN "sala" (k12 "kuuntelija")) ; --UNCHK
lin ebb_N = mkWN (kH1 "luode") ; --UNCHK
lin ebb_V = mkWV (k72A "heiketä") ; --UNCHK
lin ebb_away_V = mkWV (k73A "virrata") "ulos" ; --UNCHK
lin ebbtide_N = mkWN (kH1 "luode") ; --UNCHK
lin eblis_N = mkWN "eblis" ; --UNCHK
lin ebon_A = mkWA (compoundA "sysi" (k10 "musta")) ; --UNCHK
lin ebonite_N = mkWN (k5A "eboniitti") ; --UNCHK
lin ebony_A = mkWA (compoundA "sysi" (k10 "musta")) ; --UNCHK
lin ebony_N = mkWN (k10 "musta") ; --UNCHK
lin ebracteate_A = mkWA "suojuslehdetön" ; --UNCHK
lin ebullience_N = mkWN (k1A "into") ; --UNCHK
lin ebullient_A = mkWA (k41 "uskalias") ; --UNCHK
lin eburnation_N = mkWN "kovettuminen" ; --UNCHK
lin ec_N = mkWN (k2 "yhteisö") "Euroopan" ; --UNCHK
lin ecarte_N = mkWN "ecarte" ; --UNCHK
lin eccentric_A = mkWA (compoundA "epä" (k38 "keskinen")) ; --UNCHK
lin eccentric_N = mkWN (k5A "tyyppi") "outo" ; --UNCHK
lin eccentricity_N = mkWN (k40 "omituisuus") ; --UNCHK
lin ecchymosis_N = mkWN (k10 "mustelma") ; --UNCHK
lin eccles_PN = foreignPN "Eccles" ;
lin ecclesiastic_N = mkWN (k5A "pappi") ; --UNCHK
lin ecclesiastical_A = mkWA (k38 "hengellinen") ; --UNCHK
lin ecclesiasticism_N = mkWN (k40 "kirkollisuus") ; --UNCHK
lin ecclesiology_N = mkWN (compoundN "kirkko-" (k5A "oppi")) ; --UNCHK
lin eccrine_A = mkWA (compoundA "avo" (k38 "eritteinen")) ; --UNCHK
lin ecdemic_A = mkWA "ekdeeminen" ; --UNCHK
lin echelon_N = mkWN (k39 "porrastus") ; --UNCHK
lin echidna_N = mkWN (k5 "nokkasiili") ; --UNCHK
lin echinocactus_N = mkWN (compoundN "siili" (k39 "kaktus")) ; --UNCHK
lin echinococcosis_N = mkWN "ekinokokkoosi" ; --UNCHK
lin echinococcus_N = mkWN (k5A "ekinokokki") ; --UNCHK
lin echinoderm_N = mkWN (compoundN "piikki" (k38 "nahkainen")) ; --UNCHK
lin echinus_N = mkWN "ekinus" ; --UNCHK
lin echo_N = mkWN (k10 "jäljitelmä") ; --UNCHK
lin echo_V = mkWV (k67A "jäljitellä") ; --UNCHK
lin echo_V2 = mkWV2 (k67A "jäljitellä") ; --UNCHK
lin echo_sounder_N = mkWN (compoundN "kaiku" (k33 "luotain")) ; --UNCHK
lin echo_sounding_N = mkWN (compoundN "kaiku" (k39 "luotaus")) ; --UNCHK
lin echocardiogram_N = mkWN (compoundN "kaiku" (k10 "käyrä")) ; --UNCHK
lin echocardiograph_N = mkWN (compoundN "kaikukuvaus" (k48A "laite")) "sydämen" ; --UNCHK
lin echocardiography_N = mkWN (compoundN "kaiku" (k39 "kuvaus")) "sydämen" ; --UNCHK
lin echoencephalogram_N = mkWN (compoundN "röntgen" (k10 "kuva")) "aivojen" ; --UNCHK
lin echoencephalograph_N = mkWN (compoundN "enkefalografia" (k48A "laite")) ; --UNCHK
lin echoencephalography_N = mkWN "enkefalografia" ; --UNCHK
lin echoic_A = mkWA (k38 "onomatopoeettinen") ; --UNCHK
lin echolalia_N = mkWN (compoundN "kaiku" (k1A "hoku")) ; --UNCHK
lin echoless_A = mkWA (k34A "kaiuton") ; --UNCHK
lin echolocation_N = mkWN (compoundN "kaiku" (k39 "luotaus")) ; --UNCHK
lin echovirus_N = mkWN (compoundN "echo" (k39 "virus")) ; --UNCHK
lin eclair_N = mkWN (compoundN "tuuli" (k1A "hattu")) ; --UNCHK
lin eclampsia_N = mkWN (compoundN "kouristus" (k5A "tauti")) ; --UNCHK
lin eclat_N = mkWN (k39 "menestys") "suuri" ; --UNCHK
lin eclectic_A = mkWA (compoundA "valik" (k10 "oiva")) ; --UNCHK
lin eclectic_N = mkWN (k2 "henkilö") "valikoiva" ; --UNCHK
lin eclecticism_N = mkWN (compoundN "eklektis" (k5 "ismi")) ; --UNCHK
lin eclipse_N = mkWN (k39 "pimennys") ; --UNCHK
lin eclipse_V2 = mkWV2 (k53A "peittää") ; --UNCHK
lin ecliptic_N = mkWN (k12 "ekliptika") ; --UNCHK
lin eclogue_N = mkWN (k10 "runoelma") "pieni" ; --UNCHK
lin ecobabble_N = mkWN "ekologinen" "jargon" ; --UNCHK
lin ecological_A = mkWA (k38 "ekologinen") ;
lin ecologist_N = mkWN (k5 "ekologi") ; --UNCHK
lin ecology_N = mkWN (k12 "ekologia") ; --UNCHK
lin econometric_A = mkWA (k38 "ekonometrinen") ; --UNCHK
lin econometrics_N = mkWN (k12 "ekonometria") ; --UNCHK
lin economic_A = mkA "taloudellinen" ;
lin economical_A = mkWA (k38 "ekonominen") ; --UNCHK
lin economics_N = mkWN (k12 "ekonomia") ; --UNCHK
lin economist_N = mkWN (k5 "ekonomisti") ; --f211
lin economize_V = mkWV (k53A "käyttää") "säästäväisesti" ; --UNCHK
lin economize_V2 = mkWV2 (k53A "käyttää") "säästäväisesti" ; --UNCHK
lin economizer_N = mkWN (k10 "säästäjä") ; --UNCHK
lin economy_1_N = mkN "talous" ;
lin economy_2_N = mkN "säästö" ;
lin economy_N = mkN "talous" "talouden" "talouksia" ;
lin ecosystem_N = mkWN (compoundN "ekosyste" (k5 "emi")) ; --UNCHK
lin ecoterrorism_N = mkWN (compoundN "sodan" (k5A "käynti")) "ekologinen" ; --UNCHK
lin ecotourism_N = mkWN (compoundN "eko" (k2 "matkailu")) ; --UNCHK
lin ecphonesis_N = mkWN (k39 "huudahdus") ; --UNCHK
lin ecstasy_N = mkWN (k5 "ekstaasi") ; --UNCHK
lin ecstatic_A = mkWA (compoundA "hurmio" (k47 "itunut")) ; --UNCHK
lin ectasia_N = mkWN (k10 "pullistuma") ; --UNCHK
lin ectoderm_N = mkWN (compoundN "ulkoalkio" (k7A "lehti")) ; --UNCHK
lin ectodermal_A = mkWA "ulkoalkiolehteen" "liittyvä" ; --UNCHK
lin ectomorph_N = mkWN "ektomorfi" ; --UNCHK
lin ectomorphic_A = mkWA (compoundA "hintelä" (k38 "rakenteinen")) ; --UNCHK
lin ectoparasite_N = mkWN (compoundN "pinta" (k38 "loinen")) ; --UNCHK
lin ectopia_N = mkWN (k10 "siirtymä") ; --UNCHK
lin ectopic_A = mkWA (compoundA "virhe" (k38 "sijaintinen")) ; --UNCHK
lin ectoplasm_N = mkWN (compoundN "ulko" (k9 "lima")) ; --UNCHK
lin ectoproct_N = mkWN (compoundN "sammal" (k33 "eläin")) ; --UNCHK
lin ectrodactyly_N = mkWN "ektrodaktylia" ; --UNCHK
lin ecuador_PN = foreignPN "Ecuador" ;
lin ecuadorian_A = mkWA (compoundA "ecuadori" (k38 "lainen")) ; --UNCHK
lin ecuadorian_N = mkWN (compoundN "ecuadori" (k38 "lainen")) ; --UNCHK
lin ecumenic_A = mkWA (k38 "ekumeeninen") ; --UNCHK
lin ecumenical_A = mkWA (k5 "universaali") ; --UNCHK
lin ecumenism_N = mkWN (k40 "ekumeenisuus") ; --UNCHK
lin eczema_N = mkWN (k10 "rohtuma") ; --UNCHK
lin ed_PN = foreignPN "Ed" ;
lin edacious_A = mkWA (k34A "kyltymätön") ; --UNCHK
lin edacity_N = mkWN (k40 "ahnaus") ; --UNCHK
lin edaphosaurus_N = mkWN "edaphosaurus" ; --UNCHK
lin eddy_N = mkWN (compoundN "vesi" (k48A "pyörre")) "pieni" ; --UNCHK
lin eddy_V = mkWV (k67A "pyörähdellä") ; --UNCHK
lin edelweiss_N = mkWN (compoundN "alppi" (k7A "tähti")) ; --UNCHK
lin edema_N = mkWN (k39 "turvotus") ; --UNCHK
lin edematous_A = mkWA (compoundA "vesi" (k38 "pöhöinen")) ; --UNCHK
lin eden_PN = foreignPN "Eden" ;
lin edenbridge_PN = foreignPN "Edenbridge" ;
lin edental_A = mkWA (k34A "hampaaton") ; --UNCHK
lin edentate_N = mkWN (k34A "hampaaton") ; --UNCHK
lin edentulous_A = mkWA (k34A "hampaaton") ; --UNCHK
lin edgar_PN = foreignPN "Edgar" ;
lin edge_N = mkN "terä" | mkWN (k10 "särmä") | mkN "reuna" ; ---- split
lin edge_V = mkWV (k53A "teroittaa") ;
lin edge_V2 = mkWV2 (k53A "teroittaa") ; --UNCHK
lin edge_up_V = mkWV (k52A "tunkeutua") ; --UNCHK
lin edgeless_A = mkWA "terätön" ; --UNCHK
lin edger_N = mkWN (compoundN "reuna" (k6 "leikkuri")) ; --UNCHK
lin edgeways_Adv = mkWAdv (k99 "syrjittäin") ; --UNCHK
lin edgewise_Adv = mkWAdv (k99 "syrjittäin") ; --UNCHK
lin edginess_N = mkWN (k40 "rauhattomuus") ; --UNCHK
lin edging_N = mkWN (k39 "reunus") ; --UNCHK
lin edgy_A = mkWA (k15 "kireä") ; --UNCHK
lin edibility_N = mkWN (compoundN "syömä" (k40 "kelpoisuus")) ; --UNCHK
lin edible_A = mkWA (k10 "syötävä") ; --UNCHK
lin edible_N = mkWN (k10 "muona") ; --UNCHK
lin edict_N = mkWN (k39 "asetus") ; --UNCHK
lin edification_N = mkWN (k39 "valistus") ; --UNCHK
lin edifice_N = mkWN (k39 "rakennus") ; --UNCHK
lin edify_V2 = mkWV2 (k53 "valistaa") ; --UNCHK
lin edifying_A = mkWA "valaiseva" ; --UNCHK
lin edinburgh_PN = foreignPN "Edinburgh" ;
lin edit_V2 = mkWV2 (k62 "editoida") ; --UNCHK
lin editing_N = mkWN (k39 "toimitus") ; --UNCHK
lin edition_N = mkWN (k39 "painos") ;
lin editor_N = mkWN (k5 "editori") ; --f80
lin editorial_A = mkA "toimituksellinen" ;
lin editorial_N = mkWN (k5 "kolumni") ;
lin editorship_N = mkWN "päätoimittajuus" ; --UNCHK
lin edmontosaurus_N = mkWN "edmontosaurus" ; --UNCHK
lin edp_N = mkWN (compoundN "tietojen" (k2 "käsittely")) "automaattinen" ; --UNCHK
lin educate_V2 = mkWV2 (k53A "opettaa") ; --UNCHK
lin education_N = mkN "koulutus" | mkN "sivistys" ;
lin educational_A = mkA "kasvatuksellinen" ;
lin educationalist_N = mkWN (k10 "kasvattaja") ; --UNCHK
lin educationist_N = mkWN (k10 "kasvattaja") ; --UNCHK
lin educative_A = mkWA (k38 "opettavainen") ; --UNCHK
lin educator_N = mkN "kouluttaja" ; --kWN (k5 "pedagogi") ;
lin educe_V2 = mkWV2 (k52A "kehittyä") ; --UNCHK
lin edutainment_N = mkWN (compoundN "opetus" (k48A "viihde")) ; --UNCHK
lin edwardian_N = mkWN (k38 "aikalainen") "Edvard" "VII:n" ; --UNCHK
lin eec_N = mkWN (k2 "yhteisö") "Euroopan" ; --UNCHK
lin eeg_N = mkWN (k5 "elektroenkefalogrammi") ; --UNCHK
lin eel_N = mkWN (k41 "ankerias") ; --UNCHK
lin eelblenny_N = mkWN (k41 "ankerias") ; --UNCHK
lin eelgrass_N = mkWN (compoundN "kierre" (k10 "heinä")) "tavallinen" ; --UNCHK
lin eellike_A = mkWA (compoundA "ankerias" (k38 "mainen")) ; --UNCHK
lin eelpout_N = mkWN (kH1 "matikka") ; --UNCHK
lin eelworm_N = mkWN (k38 "ankeroinen") ; --UNCHK
lin eerie_A = mkWA (k10 "pelottava") ; --UNCHK
lin eeriness_N = mkWN (k40 "aavemaisuus") ; --UNCHK
lin eery_A = mkWA (k10 "pelottava") ; --UNCHK
lin eff_V = mkWV (k63 "saada") ; --UNCHK
lin efface_V2 = mkWV2 (k61A "pyyhkiä") "pois" ; --UNCHK
lin effaceable_A = mkWA "poistettava" ; --UNCHK
lin effacement_N = mkWN (k40 "vaatimattomuus") ; --UNCHK
lin effect_N = mkN "vaikutus" ;
lin effect_V2 = mkV2 "toteuttaa" ;
lin effecter_N = mkWN (k10 "suorittaja") ; --UNCHK
lin effective_A = mkA "toimiva" ;
lin effectiveness_N = mkWN (k1 "teho") ;
lin effects_N = mkWN (k40 "omaisuus") ; --UNCHK
lin effectual_A = mkWA (k41A "tehokas") ; --UNCHK
lin effectuality_N = mkWN (k1 "teho") ; --UNCHK
lin effectualness_N = mkWN (k1 "teho") ; --UNCHK
lin effeminacy_N = mkWN (k40 "pehmeys") ; --UNCHK
lin effeminate_A = mkWA (k38 "feminiininen") ; --UNCHK
lin effendi_N = mkWN (k9 "herra") ; --UNCHK
lin efferent_A = mkWA "vievä" ; --UNCHK
lin effervesce_V = mkWV (k61 "kuplia") ; --UNCHK
lin effervescence_N = mkWN "poreilevuus" ; --UNCHK
lin effervescent_A = mkWA "kuohuva" ; --UNCHK
lin effete_A = mkWA "turmeltunut" ; --UNCHK
lin efficacious_A = mkWA (k41A "tehokas") ; --UNCHK
lin efficacy_N = mkWN (k39 "vaikutus") ; --UNCHK
lin efficiency_N = mkWN (k40 "tehokkuus") ; --UNCHK
lin efficient_A = mkWA (k41A "tehokas") ;
lin effigy_N = mkWN (k10 "kuva") ; --UNCHK
lin effleurage_N = mkWN "hively" ; --UNCHK
lin efflorescence_N = mkWN (k10 "härmä") ; --UNCHK
lin efflorescent_A = mkWA (compoundA "kuk" (k9 "kiva")) ; --UNCHK
lin effluent_A = mkWA (compoundA "ulosvirt" (k9 "aava")) ; --UNCHK
lin effluent_N = mkWN (compoundN "jäte" (k27 "vesi")) ; --UNCHK
lin effluvium_N = mkWN (k1A "vuoto") "vahingollinen" "höyryn" ; --UNCHK
lin efflux_N = mkWN (compoundN "ulos" (k39 "virtaus")) ; --UNCHK
lin effort_N = mkN "ponnistus" ;
lin effortful_A = mkWA (k10 "vaativa") ; --UNCHK
lin effortfulness_N = mkWN (k40 "vaativuus") ; --UNCHK
lin effortless_A = mkWA (k34A "vaivaton") ; --UNCHK
lin effortlessness_N = mkWN (k40 "vaivattomuus") ; --UNCHK
lin effrontery_N = mkWN (k40 "pöyhkeys") ; --UNCHK
lin effulgence_N = mkWN (k48 "loiste") ; --UNCHK
lin effulgent_A = mkWA (k41A "kirkas") ; --UNCHK
lin effusion_N = mkWN "purkautuminen" ; --UNCHK
lin effusive_A = mkWA (k41 "vuolas") ; --UNCHK
lin effusiveness_N = mkWN (k40 "avoimuus") ; --UNCHK
lin eft_N = mkWN (k1 "vesilisko") ; --UNCHK
lin eg_PN = foreignPN "Eg" ;
lin egad_Interj = mkInterj "voi veljet" ;
lin egalitarian_A = mkWA (k34A "luokaton") ; --UNCHK
lin egalitarian_N = mkWN (k10 "kannattava") "tasa-arvoisuutta" ; --UNCHK
lin egalitarianism_N = mkWN (compoundN "egalitar" (k5 "ismi")) ; --UNCHK
lin egality_N = mkWN (compoundN "tasa-" (k1 "arvo")) ; --UNCHK
lin egg_N = L.egg_N ;
lin egg_V2 = mkWV2 (k67A "voidella") "kananmunalla" ; --UNCHK
lin egg_cup_N = mkWN (compoundN "muna" (k5A "kuppi")) ; --UNCHK
lin egg_on_V2 = mkWV2 (k53A "yllyttää") ; --UNCHK
lin eggar_N = mkWN (compoundN "tammi" (k10 "kehrääjä")) ; --UNCHK
lin egg_beater_N = mkWN (k12 "vispilä") ; --UNCHK
lin egghead_N = mkWN "älyniekka" ; --UNCHK
lin eggnog_N = mkWN (compoundN "muna" (k5 "toti")) ; --UNCHK
lin eggplant_N = mkWN (compoundN "muna" (k1 "koiso")) ; --UNCHK
lin eggshake_N = mkWN (k2 "pirtelö") ; --UNCHK
lin eggshell_N = mkWN (k26 "munankuori") ; --UNCHK
lin eglantine_N = mkWN (compoundN "orjan" (k1 "ruusu")) ; --UNCHK
lin ego_N = mkWN (k1 "ego") ; --UNCHK
lin egocentric_A = mkWA (k41A "itsekäs") ; --UNCHK
lin egocentric_N = mkWN (k5 "egoisti") ; --UNCHK
lin egoism_N = mkWN (k40 "itsekkyys") ; --UNCHK
lin egoist_N = mkWN (k5 "egoisti") ; --UNCHK
lin egoistic_A = mkWA (k41A "itsekäs") ; --UNCHK
lin egoistical_A = mkWA (k41A "itsekäs") ; --UNCHK
lin egomania_N = mkWN (compoundN "itse" (k40 "keskeisyys")) "sairaalloinen" ; --UNCHK
lin egomaniac_N = mkWN (k2 "henkilö") "sairaalloisen" "itsekeskeinen" ; --UNCHK
lin egotism_N = mkWN (compoundN "itse" (k40 "keskeisyys")) ; --UNCHK
lin egotist_N = mkWN (k5 "egoisti") ; --UNCHK
lin egotistic_A = mkWA (k38 "turhamainen") ; --UNCHK
lin egotrip_V = mkWV (k53A "käyttää") "itsetehostusta" ; --UNCHK
lin egregious_A = mkWA (k10 "vakava") ; --UNCHK
lin egremont_PN = foreignPN "Egremont" ;
lin egress_N = mkWN (compoundN "ulos" (k1 "tulo")) ; --UNCHK
lin egret_N = mkWN (compoundN "jalo" (k12 "haikara")) ; --UNCHK
lin egypt_PN = foreignPN "Egypti" ;
lin egyptian_A = mkWA (k38 "egyptiläinen") ;
lin egyptian_N = mkWN "Egyptian" ; --UNCHK
lin eider_N = mkWN (k9 "haahka") ; --UNCHK
lin eiderdown_N = mkWN (compoundN "haahkan" (k10 "untuva")) ; --UNCHK
lin eidetic_A = mkWA (k38 "eideettinen") ; --UNCHK
lin eidos_N = mkWN (k1A "muoto") ; --UNCHK
lin eigenvalue_N = mkWN (compoundN "ominais" (k1 "arvo")) "neliömatriisin" ; --UNCHK
lin eightpence_N = mkWN (compoundN "kahdeksan" (k38 "penninen")) ; --UNCHK
lin eightpenny_A = mkWA (compoundA "6,4-sentti" (k38 "metrinen")) ; --UNCHK
lin eindhoven_PN = foreignPN "Eindhoven" ;
lin einsteinium_N = mkWN "järjestysluku" "99" ; --UNCHK
lin eisegesis_N = mkWN "eisegeesi" ; --UNCHK
lin either7or_DConj = S.either7or_DConj ;
lin either_Adv = mkAdv "myöskään" ;
lin either_Det = MorphoFin.mkDetPol False Sg {s = table NForm {nf => (snoun2nounBind (nforms2snoun (dSuurempi "kumpi"))).s ! nf ++ "tahansa"} ; h = Back} ;
lin ejaculate_V2 = mkWV2 "ejakuloida" ; --UNCHK
lin ejaculation_N = mkWN (k39 "huudahdus") ; --UNCHK
lin ejaculator_N = mkWN "huudahtaja" ; --UNCHK
lin eject_V = mkWV (k53A "vapauttaa") ; --UNCHK
lin eject_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin ejection_N = mkWN (compoundN "ulos" (k1A "työntö")) ; --UNCHK
lin ejector_N = mkWN (compoundN "ulos" (k10 "heittäjä")) ; --UNCHK
lin ejector_seat_N = mkWN (compoundN "heitto" (k33 "istuin")) ; --UNCHK
lin eke_V2 = mkV2 (mkV (mkV "saada") "riittämään") ;
lin eke_out_V2 = mkWV2 (k53 "puristaa") ; --UNCHK
lin ekenäs_PN = mkPN "Ekenäs" ;
lin el_dorado_N = mkWN (k1 "eldorado") ; --UNCHK
lin el_salvador_PN = foreignPN "El Salvador" ;
lin elaborate_A = mkWA (k9A "tarkka") ; --UNCHK
lin elaborate_V = mkV (mkV "kehittää") "pidemmälle" ;
lin elaborate_V2 = mkV2 "kehitellä" partitive ; --WV2 (k67A "neuvotella") ;
lin elaborateness_N = mkWN (k40 "taidokkuus") ; --UNCHK
lin elaboration_N = mkWN (k9A "laadinta") "huolellinen" ; --UNCHK
lin elan_N = mkWN (k40 "lennokkuus") ; --UNCHK
lin eland_N = mkWN (compoundN "hirvi" (k5A "antilooppi")) ; --UNCHK
lin elapid_N = mkWN "myrkkytarhakäärme" ; --UNCHK
lin elapse_V = mkWV (k53A "hurahtaa") ; --UNCHK
lin elapsed_A = mkWA (compoundA "kulu" (k47 "nut")) ; --UNCHK
lin elasmobranch_N = mkWN (compoundN "rusto" (k9 "kala")) "leveäsuinen" ; --UNCHK
lin elastance_N = mkWN (compoundN "käänteis" (k1 "arvo")) "kapasitanssin" ; --UNCHK
lin elastic_A = mkWA (k10 "joustava") ; --UNCHK
lin elastic_N = mkWN (k5 "materiaali") "kimmoisa" ; --UNCHK
lin elasticity_N = mkWN (k40 "elastisuus") ; --UNCHK
lin elasticized_A = mkWA "jousto-" ; --UNCHK
lin elastin_N = mkWN "elastiini" ; --UNCHK
lin elastosis_N = mkWN "elastoosi" ; --UNCHK
lin elate_V2 = mkWV2 (k53A "päihdyttää") ; --UNCHK
lin elating_A = mkWA (compoundA "riemas" (k10 "tuttava")) ; --UNCHK
lin elation_N = mkWN (k1 "riemu") ; --UNCHK
lin elbow_N = mkWN (compoundN "kyynär" (k18 "pää")) ; --UNCHK
lin elbowing_N = mkWN (compoundN "työ" (k38 "ntäminen")) "kyynärpäillä" ; --UNCHK
lin elder_A = mkWA (k16A "vanhempi") ; --UNCHK
lin elder_1_N = mkWN (k2 "henkilö") "vanhempi" ; --UNCHK
lin elder_2_N = mkWN (k2 "henkilö") "vanhempi" ; --UNCHK
lin elderberry_N = mkWN (k9 "marja") "seljapensaan" ; --UNCHK
lin elderly_A = mkWA (k41A "iäkäs") ; --UNCHK
lin eldership_N = mkWN (k10 "asema") "vanhimman" ; --UNCHK
lin elderslie_PN = foreignPN "Elderslie" ;
lin eldritch_A = mkWA (k34A "selittämätön") ; --UNCHK
lin eleanor_PN = foreignPN "Eleanor" ;
lin elecampane_N = mkWN (compoundN "iso" (k26 "hirvenjuuri")) ; --UNCHK
lin elect_A = mkWA (k10 "tuleva") ; --UNCHK
lin elect_V = mkV "valita" ;
lin elect_V2 = mkV2 (lin VK {s = c69 "valita"}) ;
lin elect_V2V = mkWV2V (k53A "päättää") ; --UNCHK
lin elect_V3 = mkV3 (mkV "valita") accusative (mkPrep translative) ;
lin elected_A = mkA "valittu" ;
lin election_N = mkN "äänestys" ;
lin electioneering_N = mkWN (k5A "kampanjointi") ; --UNCHK
lin elective_A = mkWA "vaali-" ; --UNCHK
lin elector_N = mkWN (compoundN "vaali" (k41 "ruhtinas")) ; --UNCHK
lin electoral_A = mkA (separateN "vaaleja" (mkN "koskeva" "koskevia")) ; ---?? --WA "valitsija-" ;
lin electorate_N = mkWN (compoundN "valitsija" (k10A "kunta")) ; --UNCHK
lin electric_A = mkA "sähköinen" ; ---ARB WA "sähkö-" ;
lin electric_N = mkWN (compoundN "sähkö" (k1 "auto")) ; --UNCHK
lin electrical_A = mkWA "sähkö-" ; --UNCHK
lin electrician_N = mkWN (compoundN "sähkö" (k42 "mies")) ; --UNCHK
lin electricity_N = mkN "sähkö" ;
lin electrification_N = mkWN (k39 "sähköistys") ; --UNCHK
lin electrify_V2 = mkWV2 (k53 "sähköistää") ; --UNCHK
lin electrifying_A = mkWA (k10 "jännittävä") ; --UNCHK
lin electrocardiogram_N = mkWN (k5 "elektrokardiogrammi") ; --UNCHK
lin electrocardiograph_N = mkWN "sähkökardiografi" ; --UNCHK
lin electrocardiographic_A = mkWA "sähkökardiografiin" "liittyvä" ; --UNCHK
lin electrocautery_N = mkWN (compoundN "sähkö" (k1A "poltto")) ; --UNCHK
lin electrochemical_A = mkWA (compoundA "sähkö" (k38 "kemiallinen")) ; --UNCHK
lin electrochemistry_N = mkWN (compoundN "sähkö" (k12 "kemia")) ; --UNCHK
lin electrocute_V2 = mkWV2 (k53A "teloittaa") "sähkötuolissa" ; --UNCHK
lin electrocution_N = mkWN (compoundN "sähkö" (k39 "teurastus")) ; --UNCHK
lin electrocutioner_N = mkWN (k10 "teloittaja") "sähköllä" ; --UNCHK
lin electrode_N = mkWN (k9A "napa") ; --UNCHK
lin electrodeposition_N = mkWN (compoundN "sähkö" (k38 "saostaminen")) ; --UNCHK
lin electrodynamometer_N = mkWN (compoundN "sähkö" (k5 "dynamometri")) ; --UNCHK
lin electroencephalogram_N = mkWN (k5 "elektroenkefalogrammi") ; --UNCHK
lin electroencephalograph_N = mkWN (compoundN "EEG-" (k48A "laite")) ; --UNCHK
lin electroencephalographic_A = mkWA "EEG-laitteeseen" "liittyvä" ; --UNCHK
lin electrograph_N = mkWN "electrograph" ; --UNCHK
lin electrologist_N = mkWN (k10 "hoitaja") "elektrolyysiä" "käyttävä" ; --UNCHK
lin electrolysis_N = mkWN (k5 "elektrolyysi") ; --UNCHK
lin electrolyte_N = mkWN (k5A "elektrolyytti") ; --UNCHK
lin electrolytic_A = mkWA (k38 "elektrolyyttinen") ; --UNCHK
lin electrolytic_N = mkWN (k6 "kondensaattori") "elektrolyyttinen" ; --UNCHK
lin electromagnet_N = mkWN (compoundN "sähkö" (k5A "magneetti")) ; --UNCHK
lin electromagnetic_A = mkWA (compoundA "sähkö" (k38 "magneettinen")) ; --UNCHK
lin electromagnetism_N = mkWN (compoundN "sähkö" (k5 "magnetismi")) ; --UNCHK
lin electromechanical_A = mkWA (compoundA "sähkö" (k38 "mekaaninen")) ; --UNCHK
lin electrometer_N = mkWN (compoundN "elektro" (k5 "metri")) ; --UNCHK
lin electromotive_A = mkWA (compoundA "sähkö" (k38 "motorinen")) ; --UNCHK
lin electromyogram_N = mkWN (compoundN "lihassähkö" (k10 "käyrä")) ; --UNCHK
lin electromyograph_N = mkWN "elektromyografi" ; --UNCHK
lin electromyography_N = mkWN "elektromyografia" ; --UNCHK
lin electron_N = mkWN (k5 "elektroni") ; --UNCHK
lin electronegativity_N = mkWN (k40 "negatiivisuus") ; --UNCHK
lin electronic_A = mkWA (k38 "elektroninen") ; --f82
lin electronics_N = mkWN (k9A "elektroniikka") ;
lin electrophoresis_N = mkWN "sähköforeesi" ; --UNCHK
lin electrophoretic_A = mkWA (compoundA "katafor" (k38 "eettinen")) ; --UNCHK
lin electrophorus_N = mkWN (compoundN "Electrophorus-" (k1A "suku")) ; --UNCHK
lin electroplate_N = mkWN (k48 "esine") "hopeoitu" ; --UNCHK
lin electroplate_V2 = mkWV2 (k62 "hopeoida") ; --UNCHK
lin electroplater_N = mkWN "galvanoija" ; --UNCHK
lin electroretinogram_N = mkWN "elektroretinogrammi" ; --UNCHK
lin electroscope_N = mkWN (compoundN "elektrosko" (k5A "oppi")) ; --UNCHK
lin electrosleep_N = mkWN (k40 "tajuttomuus") ; --UNCHK
lin electrostatic_A = mkWA (k38 "staattinen") ; --UNCHK
lin electrostatics_N = mkWN (compoundN "sähkö" (k14A "statiikka")) ; --UNCHK
lin electrosurgery_N = mkWN (compoundN "sähkö" (k12 "kirurgia")) ; --UNCHK
lin electrotherapist_N = mkWN (compoundN "asian" (k12 "tuntija")) "sähköhoidon" ; --UNCHK
lin electrotherapy_N = mkWN (compoundN "sähkö" (k1A "hoito")) ; --UNCHK
lin electrum_N = mkWN (k10A "kulta") "hopeapitoinen" ; --UNCHK
lin eleemosynary_A = mkWA (compoundA "hyväntah" (k38 "toinen")) ; --UNCHK
lin elegance_N = mkWN (k5 "tyyli") ; --UNCHK
lin elegant_A = mkA "elegantti" | mkWA (k41A "tyylikäs") ;
lin elegiac_A = mkWA (k38 "eleginen") ; --UNCHK
lin elegist_N = mkWN "elegikko" ; --UNCHK
lin elegy_N = mkWN (k12 "elegia") ; --UNCHK
lin element_N = mkN "alku" (mkN "aine") ;
lin elemental_A = mkWA (compoundA "elementt" (k32A "ien")) ; --UNCHK
lin elementary_A = mkWA "perus-" ; --UNCHK
lin elemi_N = mkWN (compoundN "elemi" (k5 "hartsi")) ; --UNCHK
lin elephant_N = mkWN (k1 "norsu") ;
lin elephantiasis_N = mkWN (compoundN "elefantti" (k5A "tauti")) ; --UNCHK
lin elephantine_A = mkWA (k10 "valtava") ; --UNCHK
lin elevate_V2 = mkWV2 (k53 "nostaa") ; --UNCHK
lin elevation_N = mkWN (compoundN "lisä" (k38 "äminen")) ; --UNCHK
lin elevator_N = mkWN (k5 "hissi") ; --UNCHK
lin elf_N = mkWN (k40 "taajuus") "erittäin" "pieni" ; --UNCHK
lin elfin_A = mkWA "keijukais-" ; --UNCHK
lin elfish_A = mkWA (compoundA "vekkuli" (k38 "mainen")) ; --UNCHK
lin elgin_PN = foreignPN "Elgin" ;
lin elicit_V2 = mkWV2 (k53A "johtaa") ; --UNCHK
lin elicitation_N = mkWN (k38 "tuominen") "esiin" ; --UNCHK
lin elide_V2 = mkWV2 (k53A "jättää") "lausumatta" ; --UNCHK
lin eligibility_N = mkWN (k40 "kelpoisuus") ; --UNCHK
lin eligible_A = mkWA (k41 "sovelias") ; --UNCHK
lin eliminate_V2 = mkV2 (lin VK {s = c53 "poistaa"}) ;
lin elimination_N = mkWN (k5A "eliminointi") ;
lin eliminator_N = mkWN (compoundN "hävitys" (k48 "aine")) ; --UNCHK
lin elimäki_PN = mkPN (mkN "Elimäki" "Elimäkiä") ;
lin elision_N = mkWN (k1 "poisto") ; --UNCHK
lin elite_N = mkWN (k1 "parhaimmisto") ; --UNCHK
lin elitism_N = mkWN (k5 "elitismi") ; --UNCHK
lin elitistFem_N = mkWN "elitisti" ; --UNCHK
lin elitistMasc_N = mkWN "elitisti" ; --UNCHK
lin elixir_N = mkWN (k5 "eliksiiri") ; --UNCHK
lin elizabeth_PN = foreignPN "Elizabeth" ;
lin elizabethan_A = mkWA (k38 "aikainen") "Elisabetin" ; --UNCHK
lin elk_N = mkWN (compoundN "saksan" (k7 "hirvi")) ; --UNCHK
lin ell_N = mkWN (k7A "siipi") ; --UNCHK
lin elland_PN = foreignPN "Elland" ;
lin ellesmere_PN = foreignPN "Ellesmere" ;
lin ellipse_N = mkWN (k6 "ovaali") ; --UNCHK
lin ellipsis_N = mkWN (k5 "ellipsi") ; --UNCHK
lin ellipsoid_A = mkWA (k38 "elliptinen") ; --UNCHK
lin ellipsoid_N = mkWN "ellipsoidi" ; --UNCHK
lin elliptic_A = mkWA (k38 "elliptinen") ; --UNCHK
lin elliptical_A = mkWA (k38 "elliptinen") ; --UNCHK
lin elm_N = mkWN (k10 "jalava") ; --UNCHK
lin elocution_N = mkWN (compoundN "puhe" (k14A "tekniikka")) ; --UNCHK
lin elocutionary_A = mkWA "lausunnallinen" ; --UNCHK
lin elocutionistFem_N = mkWN (k10 "lausuja") ; --UNCHK
lin elocutionistMasc_N = mkWN (k10 "lausuja") ; --UNCHK
lin elongate_V = mkWV (k54A "pidentää") ; --UNCHK
lin elongate_V2 = mkWV2 (k54A "pidentää") ; --UNCHK
lin elongation_N = mkWN "pidentäminen" ; --UNCHK
lin elope_V = mkWV (k73A "karata") ; --UNCHK
lin elopement_N = mkWN "karkaaminen" ; --UNCHK
lin eloquence_N = mkWN (k40 "kaunopuheisuus") ; --UNCHK
lin eloquent_A = mkWA (k10 "puhuva") "miellyttävästi" ; --UNCHK
lin else_Adv = mkAdv "muutoin" ;
lin elsewhere_Adv = mkAdv "muualla" | mkWAdv (k99 "toisaalla") ;
lin elstree_PN = foreignPN "Elstree" ;
lin eluate_N = mkWN "eluaatti" ; --UNCHK
lin elucidate_V2 = mkWV2 (k53 "havainnollistaa") ; --UNCHK
lin elucidation_N = mkWN (k2 "valaisu") ; --UNCHK
lin elude_V2 = mkWV2 (k67A "luikerrella") ; --UNCHK
lin elusive_A = mkA "saavuttamaton" ;
lin elusiveness_N = mkWN (k40 "vaikeaselkoisuus") ; --UNCHK
lin elution_N = mkWN "eluusio" ; --UNCHK
lin elver_N = mkWN (k41 "ankerias") "nuori" ; --UNCHK
lin elves_N = mkWN (compoundN "ilma" (k1 "sähkö")) ; --UNCHK
lin elvish_A = mkWA (compoundA "vekkuli" (k38 "mainen")) ; --UNCHK
lin ely_PN = foreignPN "Ely" ;
lin elysian_A = mkWA (compoundA "elysio" (k38 "lainen")) ; --UNCHK
lin em_N = mkWN (k3 "neliö") ; --UNCHK
lin emaciate_V2 = mkWV2 (k52A "riutua") ; --UNCHK
lin emaciation_N = mkWN (k40 "laihuus") ; --UNCHK
lin email_N = mkN "sähköposti" ;
lin emanate_V = mkWV (k52A "kantautua") ; --UNCHK
lin emanation_N = mkWN (k1A "vuoto") ; --UNCHK
lin emancipate_V2 = mkWV2 (k53A "vapauttaa") ; --UNCHK
lin emancipation_N = mkWN (k3 "emansipaatio") ; --UNCHK
lin emancipative_A = mkWA (compoundA "vap" (k10 "auttava")) ; --UNCHK
lin emancipator_N = mkWN (k10 "vapauttaja") ; --UNCHK
lin emarginate_A = mkWA (compoundA "lantto" (k38 "päinen")) ; --UNCHK
lin emasculate_V2 = mkWV2 (k62 "kastroida") ; --UNCHK
lin emasculation_N = mkWN (k9A "kuohinta") ; --UNCHK
lin embalm_V2 = mkWV2 (k62 "palsamoida") ; --UNCHK
lin embalmer_N = mkWN "palsamoija" ; --UNCHK
lin embalmment_N = mkWN (k5A "palsamointi") ; --UNCHK
lin embankment_N = mkWN (k5 "valli") ; --UNCHK
lin embargo_N = mkWN (compoundN "talous" (k1A "saarto")) ;
lin embargo_V2 = mkWV2 (k53 "julistaa") "kauppasaartoon" ; --UNCHK
lin embark_V = mkWV (k52A "uskaltautua") ; --UNCHK
lin embark_V2 = mkWV2 (k52A "uskaltautua") ; --UNCHK
lin embark_on_V2 = mkWV2 (k53 "perustaa") ; --UNCHK
lin embarkation_N = mkWN (k1 "nousu") ; --UNCHK
lin embarrass_V2 = mkV2 "nolata" ; --mkWV2 (k56A "saattaa") "häpeilemään" ;
lin embarrassed_A = mkA "hämmentynyt" ;
lin embarrassing_A = mkWA (k38 "kiusallinen") ;
lin embarrassment_N = mkWN (k10 "määrä") "yletön" ; --UNCHK
lin embassy_N = mkWN (compoundN "suur" (k1 "lähetystö")) ; --UNCHK
lin embattled_A = mkWA (k38 "sakarainen") ; --UNCHK
lin embed_V2 = mkWV2 (k53A "sijoittaa") ; --UNCHK
lin embellish_V2 = mkWV2 (k67 "kaunistella") ; --UNCHK
lin embellishment_N = mkWN (k2 "kaunistelu") ; --UNCHK
lin ember_N = mkWN (k48 "kekäle") ; --UNCHK
lin embezzle_V2 = mkWV2 (k71 "tehdä") "virkarikos" ; --UNCHK
lin embezzlement_N = mkWN (k39 "anastus") ; --UNCHK
lin embezzler_N = mkWN (k10 "kavaltaja") ; --UNCHK
lin embitter_V2 = mkWV2 (k53A "suututtaa") ; --UNCHK
lin embitterment_N = mkWN (k40 "katkeruus") ; --UNCHK
lin emblazon_V2 = mkWV2 (k67 "koristella") ; --UNCHK
lin emblem_N = mkWN (k6 "symboli") ; --UNCHK
lin emblematic_A = mkWA (k38 "symbolinen") ; --UNCHK
lin embodiment_N = mkWN (k10 "ruumiillistuma") ; --UNCHK
lin embody_V2 = mkWV2 (k62 "personoida") ; --UNCHK
lin embolden_V2 = mkWV2 (k53 "kannustaa") ; --UNCHK
lin embolectomy_N = mkWN (k1 "poisto") "veritulpan" ; --UNCHK
lin embolic_A = mkWA "veritulppa-" ; --UNCHK
lin embolism_N = mkWN (compoundN "veri" (k10A "tulppa")) ; --UNCHK
lin embolus_N = mkWN (compoundN "veri" (k10A "tulppa")) ; --UNCHK
lin embonpoint_A = mkWA (k10 "pulska") ; --UNCHK
lin embonpoint_N = mkWN (k40 "pyöreys") ; --UNCHK
lin emboss_V2 = mkWV2 (k73 "leimata") ; --UNCHK
lin embrace_V = mkWV (k52A "liittyä") "jhk" ; --UNCHK
lin embrace_V2 = mkWV2 (k52A "liittyä") "jhk" ; --UNCHK
lin embrasure_N = mkWN (compoundN "ampuma-" (k1A "aukko")) ; --UNCHK
lin embrocation_N = mkWN (k5A "linimentti") ; --UNCHK
lin embroider_V = mkWV (k53A "värittää") ; --UNCHK
lin embroider_V2 = mkWV2 (k53A "värittää") ; --UNCHK
lin embroiderer_N = mkWN (compoundN "koru" (k12 "ompelija")) ; --UNCHK
lin embroideress_N = mkWN (compoundN "koru" (k12 "ompelija")) ; --UNCHK
lin embroidery_N = mkWN (k9A "kirjonta") ; --UNCHK
lin embroil_V = mkWV (k58 "sotkea") ; --UNCHK
lin embroil_V2 = mkWV2 (k58 "sotkea") ; --UNCHK
lin embryo_N = mkWN (k3 "alkio") ;
lin embryologist_N = mkWN (k5 "embryologi") ; --UNCHK
lin embryology_N = mkWN (k12 "embryologia") ; --UNCHK
lin embryonic_A = mkWA (k10 "tuleva") ; --UNCHK
lin emeer_N = mkWN (k6 "emiiri") ; --UNCHK
lin emend_V2 = mkWV2 (k67A "parannella") ; --UNCHK
lin emendation_N = mkWN (k39 "parannus") ; --UNCHK
lin emerald_N = mkWN (compoundN "smaragdin" (k15 "vihreä")) ; --UNCHK
lin emerge_V = mkWV (k67 "tulla") "näkyviin" ; --f71
lin emergence_N = mkN "ilmaantuminen" ; ---ARB --mkN "nousu" ; --mkWN (compoundN "ulos" (k1 "tulo")) ;
lin emergency_N = mkN "hätä" (mkN "jarru") ; --f96
lin emeritus_A = mkWA (k47 "täysinpalvellut") ; --UNCHK
lin emeritus_N = mkN "emeritus" ;
lin emery_N = mkWN (k6 "smirgeli") ; --UNCHK
lin emetic_N = mkWN (compoundN "oksetus" (k48 "aine")) ; --UNCHK
lin emigrant_N = mkWN (k5A "emigrantti") ; --UNCHK
lin emigrate_V = mkWV (k52A "emigroitua") ; --UNCHK
lin emigrate_V2V = mkWV2V (k52A "emigroitua") ; --UNCHK
lin emigration_N = mkWN (k39 "karkotus") ; --UNCHK
lin emigre_N = mkWN (k5A "emigrantti") ; --UNCHK
lin eminence_N = mkWN (k12 "nystyrä") ; --UNCHK
lin eminent_A = mkWA (k15 "huikea") ; --UNCHK
lin emir_N = mkWN (k6 "emiiri") ; --UNCHK
lin emirate_N = mkWN (k1 "arvo") "emiirin" ; --UNCHK
lin emissary_N = mkWN (k41 "lähettiläs") ; --UNCHK
lin emission_N = mkN "päästö" ;
lin emit_V2 = mkWV2 (k53 "poistaa") ; --UNCHK
lin emitter_N = mkN "lähettäjä" ;
lin emmenagogue_N = mkWN (k48A "lääke") "kuukautisia" "edistävä" ; --UNCHK
lin emmer_N = mkWN (compoundN "kaksijyväis" (k10 "vehnä")) ; --UNCHK
lin emmetropia_N = mkWN "oikeataittoisuus" ; --UNCHK
lin emmetropic_A = mkWA (compoundA "emme" (k38 "trooppinen")) ; --UNCHK
lin emoticon_N = mkWN (k3 "hymiö") ; --UNCHK
lin emotion_N = mkWN (k48A "tunne") ; --UNCHK
lin emotional_A = mkA "emotionaalinen" ;
lin emotionality_N = mkWN (k40 "tunteellisuus") ; --UNCHK
lin emotionless_A = mkWA (k34A "kiihkoton") ; --UNCHK
lin emotionlessness_N = mkWN (k40 "tunteettomuus") ; --UNCHK
lin emotive_A = mkWA (compoundA "tunnepi" (k38 "toinen")) ; --UNCHK
lin empale_V2 = mkWV2 (k73 "naulata") ; --UNCHK
lin empanel_V2 = mkWV2 (k75 "nimetä") ; --UNCHK
lin empathic_A = mkWA (k38 "empaattinen") ; --UNCHK
lin empathize_V = mkWV (k54A "ymmärtää") ; --UNCHK
lin empathy_N = mkWN (k12 "empatia") ; --UNCHK
lin emperor_N = mkWN (compoundN "häive" (k38 "perhonen")) ; --UNCHK
lin emphasis_N = mkWN (k39 "painotus") ;
lin emphasize_V2 = mkWV2 (k54A "tähdentää") ; --UNCHK
lin emphasize_VS = mkWVS (k54A "tähdentää") ; --UNCHK
lin emphasizing_N = mkWN (compoundN "tähde" (k38 "ntäminen")) ; --UNCHK
lin emphatic_A = mkWA (k41A "voimakas") ; --UNCHK
lin emphysema_N = mkWN (compoundN "keuhko" (k10 "laajentuma")) ; --UNCHK
lin emphysematous_A = mkWA (compoundA "ilma" (k38 "pöhöinen")) ; --UNCHK
lin empire_N = mkWN "Empire" ; --UNCHK
lin empiric_A = mkWA (k38 "kokeellinen") ; --UNCHK
lin empirical_A = mkWA (k38 "kokeellinen") ; --UNCHK
lin empiricism_N = mkWN (k5 "empirismi") ; --UNCHK
lin empiricist_N = mkWN (k5 "empiristi") ; --UNCHK
lin emplacement_N = mkWN (k39 "sijoitus") ; --UNCHK
lin emplane_V = mkWV (k66 "nousta") "lentokoneeseen" ; --UNCHK
lin emplane_V2 = mkWV2 (k66 "nousta") "lentokoneeseen" ; --UNCHK
lin employ_N = mkWN (k25 "toimi") ; --UNCHK
lin employ_V2 = mkV2 "työllistää" ;
lin employable_A = mkWA "työllistettävä" ; --UNCHK
lin employable_N = mkWN "työllistettävä" ; --UNCHK
lin employee_N = mkN "työntekijä" ;
lin employer_N = mkWN (compoundN "työn" (k10 "antaja")) ;
lin employment_N = mkN "työllisyys" ; ---- split
lin emporium_N = mkWN (compoundN "tavara" (k1 "talo")) ; --UNCHK
lin empower_V2 = mkWV2 (k53A "valtuuttaa") ; --UNCHK
lin empower_V2V = mkWV2V (k53A "valtuuttaa") ; --UNCHK
lin empress_N = mkWN (k9 "keisarinna") ; --UNCHK
lin emptiness_N = mkWN (k40 "tyhjänpäiväisyys") ; --UNCHK
lin empty_A = L.empty_A ;
lin empty_N = mkWN (k12 "astia") "tyhjä" ; --UNCHK
lin empty_V = mkWV (k53A "miehittää") ; --UNCHK
lin empty_V2 = mkWV2 (k53A "miehittää") ; --UNCHK
lin emptying_N = mkWN (k5A "evakuointi") ; --UNCHK
lin empurpled_A = mkWA (k38 "mahtipontinen") ; --UNCHK
lin empyema_N = mkWN "ontelomärkimä" ; --UNCHK
lin empyreal_A = mkWA (k38 "taivaallinen") ; --UNCHK
lin empyrean_A = mkWA (k38 "taivaallinen") ; --UNCHK
lin empyrean_N = mkWN (k40 "avaruus") ; --UNCHK
lin emsworth_PN = foreignPN "Emsworth" ;
lin emu_N = mkWN (k1 "emu") ; --UNCHK
lin emulate_V2 = mkWV2 (k55A "yltää") "samaan" ; --UNCHK
lin emulation_N = mkWN (k2 "kilpailu") ; --UNCHK
lin emulous_A = mkWA "kilpaileva" ; --UNCHK
lin emulsifier_N = mkWN (compoundN "emulgointi" (k48 "aine")) ; --UNCHK
lin emulsify_V2 = mkWV2 "maidostua" ; --UNCHK
lin emulsion_N = mkWN (k1 "kalvo") "valonherkkä" ; --UNCHK
lin en_N = mkWN (k41A "puolikas") ; --UNCHK
lin en_clair_Adv = mkWAdv (k99 "selväkielisesti") ; --UNCHK
lin en_famille_Adv = mkWAdv (k99 "kesken") "perheen" ; --UNCHK
lin en_masse_Adv = mkWAdv "ryhmänä" ; --UNCHK
lin en_route_Adv = mkWAdv (compoundAdv "mat" (k9 "kalla")) ; --UNCHK
lin enable_V2 = mkV2 "mahdollistaa" ;
lin enable_V2V = mkWV2V (k71 "tehdä") "kykeneväksi" ;
lin enable_VS = mkVS (mkV "mahdollistaa") ;
lin enabling_A = mkWA "valtuutus-" ; --UNCHK
lin enact_V2 = mkWV2 (k67A "näytellä") partitive ;
lin enact_V2V = mkWV2V (k67A "näytellä") ; --UNCHK
lin enactment_N = mkWN (k9A "tulkinta") ; --UNCHK
lin enalapril_N = mkWN "Vasotec" ; --UNCHK
lin enallage_N = mkWN (k39 "korvaus") ; --UNCHK
lin enamel_N = mkWN (k39 "lasitus") ; --UNCHK
lin enamel_V2 = mkWV2 (k53A "lasittaa") ; --UNCHK
lin enamelware_N = mkWN (compoundN "emali" (k12 "tavara")) ; --UNCHK
lin enamine_N = mkWN "enamiini" ; --UNCHK
lin enamored_A = mkWA (k47 "innostunut") ; --UNCHK
lin enamour_V2 = mkWV2 (k53A "houkuttaa") ; --UNCHK
lin enantiomorph_N = mkWN (k41A "puolikas") "kiteen" "peilikuvamainen" ; --UNCHK
lin enantiomorphism_N = mkWN (k48A "suhde") "peilikuvien" ; --UNCHK
lin enate_A = mkWA (compoundA "äidin" (k38 "puoleinen")) ; --UNCHK
lin enate_N = mkWN (k38 "sukulainen") "äidinpuoleinen" ; --UNCHK
lin encainide_N = mkWN "Enkaid" ; --UNCHK
lin encamp_V = mkWV (k52A "leiriytyä") ; --UNCHK
lin encamp_V2 = mkWV2 (k52A "leiriytyä") ; --UNCHK
lin encampment_N = mkWN (k2 "telttailu") ; --UNCHK
lin encapsulation_N = mkWN "kotelointi" ; --UNCHK
lin encase_V2 = mkWV2 (k53A "peittää") ; --UNCHK
lin encasement_N = mkWN (compoundN "kotelo" (k38 "iminen")) ; --UNCHK
lin encaustic_N = mkWN (compoundN "vaha" (k5 "väri")) ; --UNCHK
lin encephalartos_N = mkWN (compoundN "käpy" (k1 "palmu")) ; --UNCHK
lin encephalitis_N = mkWN (compoundN "aivo" (k48 "kuume")) ; --UNCHK
lin encephalocele_N = mkWN (k10 "pullistuma") "aivojen" ; --UNCHK
lin encephalogram_N = mkWN (compoundN "röntgen" (k10 "kuva")) "aivojen" ; --UNCHK
lin encephalography_N = mkWN "enkefalografia" ; --UNCHK
lin encephalomyelitis_N = mkWN (compoundN "aivo-selkäydin" (k39 "tulehdus")) ; --UNCHK
lin enchain_V2 = mkWV2 (k61A "kahlehtia") ; --UNCHK
lin enchant_V2 = mkWV2 (k61 "loitsia") ; --UNCHK
lin enchanter_N = mkWN (k1 "velho") ; --UNCHK
lin enchantingly_Adv = mkWAdv (k99 "ihastuttavasti") ; --UNCHK
lin enchantment_N = mkWN (k40 "taikuus") ; --UNCHK
lin enchantress_N = mkWN (k10A "noita") ; --UNCHK
lin enchilada_N = mkWN (k9 "enchilada") ; --UNCHK
lin enchondroma_N = mkWN (compoundN "rusto" (k33 "kasvain")) ; --UNCHK
lin encircle_V2 = mkWV2 (k52A "sitoa") ; --UNCHK
lin encirclement_N = mkWN (k39 "piiritys") ; --UNCHK
lin enclave_N = mkWN (compoundN "erillis" (k48 "alue")) ; --UNCHK
lin enclose_V2 = mkWV2 (k56A "laittaa") ; --UNCHK
lin enclosure_1_N = mkWN (k5A "ympäröinti") ; --UNCHK
lin enclosure_2_N = mkWN (k5A "ympäröinti") ; --UNCHK
lin enclosure_3_N = mkWN (k5A "ympäröinti") ; --UNCHK
lin encode_V2 = mkWV2 (k54A "muuntaa") "koodimuotoon" ; --UNCHK
lin encoding_N = mkWN (k39 "salaus") ; --UNCHK
lin encolure_N = mkWN (k9 "harja") ; --UNCHK
lin encomiastic_A = mkWA "kiittävä" ; --UNCHK
lin encomium_N = mkWN (k39 "ylistys") ; --UNCHK
lin encompass_V2 = mkWV2 (k53A "käsittää") ; --UNCHK
lin encompassment_N = mkWN (compoundN "sisä" (k38 "ltäminen")) ; --UNCHK
lin encopresis_N = mkWN (compoundN "ulosteenpidätys" (k40 "kyvyttömyys")) ; --UNCHK
lin encore_N = mkWN (k2 "numero") "ylimääräinen" ; --UNCHK
lin encounter_N = mkN "kohtaaminen" ;
lin encounter_V2 = mkV2 "kohdata" partitive ; --WV2 (k53A "ottaa") "yhteen" ;
lin encourage_V2 = mkWV2 (k66 "rohkaista") ;
lin encourage_V2V = mkV2V (mkWV (k66 "rohkaista")) (mkPrep partitive) ;
lin encouragement_N = mkN "rohkaisu" ;
lin encouraging_A = mkWA (k10 "lupaava") ; --UNCHK
lin encroach_V = mkWV (k73A "loukata") ; --UNCHK
lin encroachment_N = mkWN (k39 "vaikutus") ; --UNCHK
lin encrust_V = mkWV (k53A "kuorruttaa") ; --UNCHK
lin encrust_V2 = mkWV2 (k53A "kuorruttaa") ; --UNCHK
lin encrypt_V2 = mkWV2 (k73 "kryptata") ; --UNCHK
lin encumber_V2 = mkWV2 (k73A "haitata") ; --UNCHK
lin encumbrance_N = mkWN (k2 "koukero") ; --UNCHK
lin encyclical_A = mkWA (compoundA "tarkoite" (k1 "ttu")) "jakoon" ; --UNCHK
lin encyclical_N = mkWN (compoundN "kierto" (k48 "kirje")) "paavin" ; --UNCHK
lin encyclopaedia_N = mkWN (k12 "ensyklopedia") ; --UNCHK
lin encyclopaedic_A = mkWA (compoundA "tietosanakirja" (k38 "mainen")) ; --UNCHK
lin encyclopedia_N = mkWN (k12 "ensyklopedia") ; --UNCHK
lin encyclopedic_A = mkWA (compoundA "tietosanakirja" (k38 "mainen")) ; --UNCHK
lin encyclopedist_N = mkWN (compoundN "tietosanakirjan" (k10 "toimittaja")) ; --UNCHK
lin encysted_A = mkWA (compoundA "kotelo" (k47 "itunut")) ; --UNCHK
lin end_1_N = mkN "loppu" ;
lin end_2_N = mkN "pää" | mkN "perä" ;
lin end_N = mkN "loppu" ;
lin end_V = mkV "loppua" ;
lin end_V2 = mkV2 "lopettaa" ;
lin end_VS = mkWVS (k53A "päättää") ; --UNCHK
lin end_in_V2 = prepV2 OP_end_V OP_in_Prep ; -- guess-p-verb
lin end_tail_V2 = variants {} ; -- guess-p-verb
lin end_up_V2 = mkV2 "päätyä" illative ;
lin end_up_with_V2 = prepV2 (advV OP_end_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin endameba_N = mkWN (k9 "ameba") ; --UNCHK
lin endanger_V2 = mkWV2 (k53 "altistaa") ; --UNCHK
lin endarteritis_N = mkWN (k39 "tulehdus") "valtimon" "sisäkalvon" ; --UNCHK
lin endear_V2 = mkWV2 (k71 "tehdä") "rakkaaksi" ; --UNCHK
lin endearingly_Adv = mkWAdv (k99 "rakastettavasti") ; --UNCHK
lin endearment_N = mkWN (compoundN "hellyyden" (k39 "osoitus")) ; --UNCHK
lin endeavour_N = mkWN (k2 "kokeilu") ; --UNCHK
lin endeavour_V = mkWV (k53A "yrittää") ; --UNCHK
lin endemic_A = mkWA (k38 "endeeminen") ; --UNCHK
lin endemic_N = mkWN (k5 "laji") "kotoperäinen" ; --UNCHK
lin endergonic_A = mkWA "endergoninen" ; --UNCHK
lin endermic_A = mkWA (compoundA "ihon" (k38 "sisäinen")) ; --UNCHK
lin endgame_N = mkWN (k1A "loppu") "pelin" ; --UNCHK
lin ending_N = mkWN (k39 "lopetus") ; --UNCHK
lin endive_N = mkWN (k5 "endiivi") ; --UNCHK
lin endless_A = mkWA (k34A "päättymätön") ;
lin endlessness_N = mkWN (k40 "rajattomuus") ; --UNCHK
lin endocarditis_N = mkWN (k39 "tulehdus") "sydämen" "sisäkalvon" ; --UNCHK
lin endocardium_N = mkWN (compoundN "sisä" (k1 "kalvo")) "sydämen" ; --UNCHK
lin endocentric_A = mkWA "endosentrinen" ; --UNCHK
lin endocervicitis_N = mkWN (compoundN "endoser" (k5A "visiitti")) ; --UNCHK
lin endocranium_N = mkWN (k50 "kovakalvo") ; --UNCHK
lin endocrine_A = mkWA (k38 "umpieritteinen") ; --UNCHK
lin endocrinologist_N = mkWN "endokrinologi" ; --UNCHK
lin endocrinology_N = mkWN (k12 "endokrinologia") ; --UNCHK
lin endoderm_N = mkWN (compoundN "hypob" (k5 "lasti")) ; --UNCHK
lin endodontic_A = mkWA "endodontian" ; --UNCHK
lin endodontics_N = mkWN "endodontia" ; --UNCHK
lin endodontist_N = mkWN "endodontti" ; --UNCHK
lin endoergic_A = mkWA "energiaa" "sitova" ; --UNCHK
lin endogamous_A = mkWA "endogaminen" ; --UNCHK
lin endogamy_N = mkWN (compoundN "sisäryhmäavio" (k1A "liitto")) ; --UNCHK
lin endogenic_A = mkWA (k38 "endogeeninen") ; --UNCHK
lin endogenous_A = mkWA (k38 "endogeeninen") ; --UNCHK
lin endogeny_N = mkWN "endogenia" ; --UNCHK
lin endolymph_N = mkWN (compoundN "sisä" (k48 "neste")) "sisäkorvan" ; --UNCHK
lin endometrial_A = mkWA "endometriumin" ; --UNCHK
lin endometriosis_N = mkWN (k5 "endometrioosi") ; --UNCHK
lin endometrium_N = mkWN (compoundN "lima" (k1 "kalvo")) "kohdun" ; --UNCHK
lin endomorph_N = mkWN "endomorfi" ; --UNCHK
lin endomorphic_A = mkWA (k38 "pykninen") ; --UNCHK
lin endomorphy_N = mkWN (k4A "pyknikko") ; --UNCHK
lin endoneurium_N = mkWN "endoneurium" ; --UNCHK
lin endonuclease_N = mkWN (compoundN "endonukle" (k5 "aasi")) ; --UNCHK
lin endoparasite_N = mkWN (compoundN "sisä" (k38 "loinen")) ; --UNCHK
lin endoparasitic_A = mkWA "sisäloisiin" "liittyvä" ; --UNCHK
lin endoplasm_N = mkWN (compoundN "endo" (k9 "plasma")) ; --UNCHK
lin endorphin_N = mkWN (k5 "endorfiini") ; --UNCHK
lin endorse_V2 = mkWV2 (k52 "hyväksyä") ; --UNCHK
lin endorsement_N = mkWN (k7A "tuki") ; --UNCHK
lin endorser_N = mkWN (k10 "siirtäjä") ; --UNCHK
lin endoscope_N = mkWN (k5A "endoskooppi") ; --UNCHK
lin endoscopic_A = mkWA (compoundA "endoskooppi" (k38 "nen")) ; --UNCHK
lin endoscopy_N = mkWN (k39 "tähystys") ; --UNCHK
lin endoskeleton_N = mkWN (compoundN "tuki" (k9A "ranka")) "sisäinen" ; --UNCHK
lin endosperm_N = mkWN (compoundN "siemen" (k38 "valkuainen")) ; --UNCHK
lin endospore_N = mkWN (compoundN "sisä" (k3 "itiö")) ; --UNCHK
lin endosteum_N = mkWN (compoundN "sisä" (k1 "kalvo")) "luun" ; --UNCHK
lin endothelial_A = mkWA "endoteelinen" ; --UNCHK
lin endothermic_A = mkWA (compoundA "endo" (k38 "terminen")) ; --UNCHK
lin endotoxin_N = mkWN (compoundN "endo" (k5 "toksiini")) ; --UNCHK
lin endow_V2 = mkWV2 (k53 "varustaa") "myötäjäisillä" ; --UNCHK
lin endowment_N = mkWN (k39 "lahjoitus") ; --UNCHK
lin endue_V2 = mkWV2 (k53 "varustaa") ; --UNCHK
lin endurable_A = mkWA (k10 "siedettävä") ; --UNCHK
lin endurance_N = mkWN (k40 "kestävyys") ; --UNCHK
lin endure_V = mkWV (k52 "pysyä") "järkähtämättömänä" ; --UNCHK
lin endure_V2 = mkV2 (mkV "kestää") partitive ; --mkWV2 (k52 "pysyä") "järkähtämättömänä" ;
lin enduring_A = variants {} ;
lin endways_Adv = mkWAdv (k99 "päittäin") ; --UNCHK
lin endwise_Adv = mkWAdv (k99 "päittäin") ; --UNCHK
lin enema_N = mkWN (compoundN "perä" (k48 "ruiske")) ; --UNCHK
lin enemy_N = L.enemy_N ;
lin energetic_A = mkA "energinen" ; --mkWA (k41 "toimelias") ;
lin energid_N = mkWN (compoundN "protop" (k5 "lasti")) ; --UNCHK
lin energizer_N = mkWN (compoundN "aktivointi" (k48A "laite")) ; --UNCHK
lin energizing_A = mkWA (compoundA "energis" (k10 "oiva")) ; --UNCHK
lin energizing_N = mkWN (k5A "aktivointi") ; --UNCHK
lin energy_N = mkN "energia" ;
lin enervate_V2 = mkWV2 (k54A "heikentää") ; --UNCHK
lin enervation_N = mkWN (k1 "poisto") "hermon" ; --UNCHK
lin enfant_terrible_N = mkWN (compoundN "kauhu" (k12 "kakara")) ; --UNCHK
lin enfeeble_V2 = mkWV2 (k64 "viedä") "voimat" ; --UNCHK
lin enfeoffment_N = mkWN (compoundN "läänitys" (k9 "kirja")) ; --UNCHK
lin enfield_PN = foreignPN "Enfield" ;
lin enfilade_N = mkWN (compoundN "sivusta" (k23 "tuli")) ; --UNCHK
lin enflurane_N = mkWN (compoundN "Ethr" (k48 "ane")) ; --UNCHK
lin enfold_V2 = mkWV2 (k62 "ympäröidä") ; --UNCHK
lin enforce_V2 = mkV2 "pakottaa" ;
lin enforceable_A = mkWA (compoundA "täytäntöönpano" (k38 "kelpoinen")) ; --UNCHK
lin enforcement_N = mkN "pakottaminen" ; ---ARB mkWN (compoundN "pakko" (k1 "keino")) ;
lin enfranchisement_N = mkWN "edustusoikeuden" "myöntäminen" ; --UNCHK
lin engage_V = mkWV (k58 "kytkeä") ;
lin engage_V2 = mkWV2 (k58 "kytkeä") ; --UNCHK
lin engagement_N = mkWN (k39 "kiinnitys") ; --UNCHK
lin engelmannia_N = mkWN "engelmannia" ; --UNCHK
lin engender_V2 = mkWV2 (k53A "siittää") ; --UNCHK
lin engine_N = mkWN (k6 "moottori") ; --f57
lin engine_driver_N = mkWN (compoundN "veturin" (k10 "kuljettaja")) ; --UNCHK
lin engineer_N = mkWN (k5 "insinööri") ;
lin engineer_V = mkWV (k53A "toteuttaa") ; --UNCHK
lin engineer_V2 = mkWV2 (k53A "toteuttaa") ; --UNCHK
lin engineering_N = mkWN (k12 "teknologia") ; --f64
lin enginery_N = mkWN (k2 "koneisto") ; --UNCHK
lin england_PN = mkPN "Englanti" ;
lin englishFem_N = mkN "englantilainen" ;
lin englishMasc_N = mkWN (k38 "englantilainen") ;
lin english_A = mkWA (k38 "englantilainen") ;
lin engorgement_N = mkWN (k9A "ahminta") ; --UNCHK
lin engraft_V2 = mkWV2 (k53A "asettaa") ; --UNCHK
lin engram_N = mkWN (compoundN "muisti" (k7A "jälki")) ; --UNCHK
lin engrave_V2 = mkWV2 (k54A "kaivertaa") ; --UNCHK
lin engraver_N = mkWN (k10 "kaivertaja") ; --UNCHK
lin engraving_N = mkWN (compoundN "kai" (k38 "vertaminen")) ; --UNCHK
lin engulf_V2 = mkWV2 (k52A "hautautua") ; --UNCHK
lin enhance_V2 = mkWV2 (k53 "tehostaa") ;
lin enhanced_A = variants {} ; --
lin enhancement_N = mkWN (k39 "kohennus") ;
lin enigma_N = mkWN (k12 "asia") "tuntematon" ; --UNCHK
lin enigmatic_A = mkWA (k38 "oraakkelimainen") ; --UNCHK
lin enjambment_N = mkWN (compoundN "säkeen" (k39 "ylitys")) ; --UNCHK
lin enjoin_V2 = mkV2 "kieltää" partitive ; ---ARB --mkWV2 (k73 "määrätä") ;
lin enjoy_V2 = mkV2 (mkV "nauttia") partitive ;
lin enjoy_VV = mkVV "pitää" infElat ; --- tekemisestä ; add more Inf3s in ParadigmsFin
lin enjoyable_A = mkWA (k10 "miellyttävä") ; --UNCHK
lin enjoyableness_N = mkWN (k40 "nautittavuus") ; --UNCHK
lin enjoyer_N = mkWN (k12 "nautiskelija") ; --UNCHK
lin enjoyment_N = mkWN (k1 "ilo") ; --UNCHK
lin enkephalin_N = mkWN "enkefaliini" ; --UNCHK
lin enkindle_V2 = mkWV2 (k53A "synnyttää") ; --UNCHK
lin enlarge_V = mkWV (k54A "laajentaa") ; --UNCHK
lin enlarge_V2 = mkWV2 (k54A "laajentaa") ; --UNCHK
lin enlargement_N = mkWN "laajentuminen" ; --UNCHK
lin enlarger_N = mkWN (compoundN "suurennus" (k48 "kone")) ; --UNCHK
lin enlighten_V2 = mkWV2 (k53 "havainnollistaa") ; --UNCHK
lin enlightening_A = mkWA "valaiseva" ; --UNCHK
lin enlightenment_N = mkWN (k39 "valistus") ; --UNCHK
lin enlist_V = mkWV (k52A "värväytyä") ; --UNCHK
lin enlist_V2 = mkWV2 (k52A "värväytyä") ; --UNCHK
lin enlistment_N = mkWN (k39 "värväys") ; --UNCHK
lin enliven_V2 = mkWV2 (k53A "elähdyttää") ; --UNCHK
lin enmesh_V2 = mkWV2 (k63 "saada") "satimeen" ; --UNCHK
lin enmity_N = mkWN (k40 "pahansuopuus") ; --UNCHK
lin ennoble_V2 = mkWV2 (k62 "aateloida") ; --UNCHK
lin ennoblement_N = mkWN (k5A "aatelointi") ; --UNCHK
lin ennobling_A = mkWA "jalostava" ; --UNCHK
lin ennui_N = mkWN (k40 "ikävystyttävyys") ; --UNCHK
lin eno_PN = mkPN "Eno" ;
lin enoch_PN = foreignPN "Enoch" ;
lin enol_N = mkWN "enoli" ; --UNCHK
lin enolic_A = mkWA "enoli-" ; --UNCHK
lin enologist_N = mkWN (compoundN "viini" (k12 "tieteilijä")) ; --UNCHK
lin enology_N = mkWN (compoundN "viini" (k5A "oppi")) ; --UNCHK
lin enonkoski_PN = mkPN (mkN "Enonkoski" "Enonkoskia") ;
lin enontekiö_PN = mkPN "Enontekiö" ;
lin enophile_N = mkWN (compoundN "viinin" (k12 "tuntija")) ; --UNCHK
lin enormity_N = mkWN (compoundN "hirmu" (k19 "työ")) ; --UNCHK
lin enormous_A = mkA "suunnaton" ;
lin enormousness_N = mkWN (k40 "laajuus") ; --UNCHK
lin enosis_N = mkWN "enosis" ; --UNCHK
lin enough_A = mkA "riittävä" ;
lin enough_N = mkWN (k99 "riittävästi") ;
lin enough_Predet = {s = \\_,_ => "tarpeeksi"} ; ---- cat
lin enplane_V = mkWV (k66 "nousta") "lentokoneeseen" ; --UNCHK
lin enplane_V2 = mkWV2 (k66 "nousta") "lentokoneeseen" ; --UNCHK
lin enquire_V = mkWV (k67 "tiedustella") ; --UNCHK
lin enquire_V2 = mkWV2 (k67 "tiedustella") ; --UNCHK
lin enquirer_N = mkWN (k10 "kysyjä") ; --UNCHK
lin enquiringly_Adv = mkWAdv (k99 "kysyvästi") ; --UNCHK
lin enquiry_N = mkWN (k39 "tutkimus") ; --UNCHK
lin enrage_V2 = mkWV2 (k53A "raivostuttaa") ; --UNCHK
lin enrapture_V2 = mkWV2 (k61 "loitsia") ; --UNCHK
lin enrich_V2 = mkWV2 (k53 "rikastaa") ; --UNCHK
lin enrichment_N = mkWN (compoundN "rikas" (k38 "tuttaminen")) ; --UNCHK
lin enrol_V = mkWV (k62 "rekrytoida") ; --UNCHK
lin enrol_V2 = mkWV2 (k62 "rekrytoida") ; --UNCHK
lin enroll_V = mkWV (k62 "rekrytoida") ; --UNCHK
lin enroll_V2 = mkWV2 (k62 "rekrytoida") ; --UNCHK
lin enrollee_N = mkWN (k10 "osallistuja") ; --UNCHK
lin enrolment_N = mkWN (compoundN "kirjo" (k38 "ittautuminen")) ; --UNCHK
lin enschede_PN = foreignPN "Enschede" ;
lin ensconce_V2 = mkWV2 (k52A "asettautua") ; --UNCHK
lin ensemble_N = mkWN (compoundN "asu" (k40 "kokonaisuus")) ; --UNCHK
lin enshrine_V2 = mkWV2 (k53A "säilyttää") ; --UNCHK
lin enshroud_V2 = mkWV2 (k53A "peittää") ; --UNCHK
lin ensiform_A = mkWA (compoundA "miekka" (k38 "mainen")) ; --UNCHK
lin ensign_N = mkWN (compoundN "kansallis" (k1A "lippu")) ; --UNCHK
lin ensilage_N = mkWN (compoundN "säilö" (k1 "rehu")) ; --UNCHK
lin enslave_V2 = mkWV2 (k53A "orjuuttaa") ; --UNCHK
lin enslavement_N = mkWN (k39 "orjuutus") ; --UNCHK
lin ensnare_V2 = mkWV2 (k56 "ajaa") "ansaan" ; --UNCHK
lin ensue_V = mkWV (k73 "seurata") ; --UNCHK
lin ensure_V = mkV "varmistaa" ;
lin ensure_V2 = mkV2 "varmistaa" ;
lin ensure_VS = mkVS "varmistaa" ;
lin entablature_N = mkWN (k2 "palkisto") ; --UNCHK
lin entail_N = mkWN (compoundN "määrä" (k38 "äminen")) "sääntöperinnöksi" ; --UNCHK
lin entail_V2 = mkWV2 (k53A "rajoittaa") "perintöä" ; --UNCHK
lin entangle_V2 = mkWV2 (k53A "sekoittaa") ; --UNCHK
lin entanglement_N = mkWN (k5A "seitti") ; --UNCHK
lin entasis_N = mkWN "pullistuminen" ; --UNCHK
lin entelechy_N = mkWN (k40 "todellisuus") ; --UNCHK
lin entente_N = mkWN (compoundN "yhteis" (k39 "ymmärrys")) ; --UNCHK
lin entente_cordiale_N = mkWN (compoundN "yhteis" (k39 "ymmärrys")) ; --UNCHK
lin enter_V = mkV L.go_V "sisään" ;
lin enter_V2 = mkV2 (mkV L.go_V "sisään") illative ;
lin enter_for_V2 = prepV2 OP_enter_V OP_for_Prep ; -- guess-p-verb
lin enter_into_V2 = prepV2 OP_enter_V OP_into_Prep ; -- guess-p-verb
lin enteric_A = mkWA "suolisto-" ; --UNCHK
lin enteritis_N = mkWN (compoundN "suoli" (k39 "tulehdus")) ; --UNCHK
lin enterobiasis_N = mkWN (compoundN "kihomato" (k5A "tauti")) ; --UNCHK
lin enterokinase_N = mkWN (compoundN "enterokin" (k5 "aasi")) ; --UNCHK
lin enterolith_N = mkWN "enteroliitti" ; --UNCHK
lin enterolithiasis_N = mkWN (compoundN "liti" (k5 "aasi")) ; --UNCHK
lin enteron_N = mkWN (compoundN "ruoansulatus" (k10 "kanava")) ; --UNCHK
lin enteropathy_N = mkWN "enteropatia" ; --UNCHK
lin enteroptosis_N = mkWN (compoundN "suolen" (k10 "laskeuma")) ; --UNCHK
lin enterostenosis_N = mkWN (compoundN "suoli" (k10 "ahtauma")) ; --UNCHK
lin enterostomy_N = mkWN (k1A "teko") "suoliavanteen" ; --UNCHK
lin enterotoxemia_N = mkWN (compoundN "entero" (k12 "toksemia")) ; --UNCHK
lin enterotoxin_N = mkWN (compoundN "suolisto" (k1A "myrkky")) ; --UNCHK
lin enterovirus_N = mkWN (compoundN "entero" (k39 "virus")) ; --UNCHK
lin enterprise_N = mkWN (k48A "hanke") ; --UNCHK
lin enterprising_A = mkWA (k41 "yritteliäs") ; --UNCHK
lin entertain_V2 = mkWV2 (k69 "harkita") ; --UNCHK
lin entertainer_N = mkWN (k10 "viihdyttäjä") ; --UNCHK
lin entertaining_A = mkWA "viihdyttävä" ; --UNCHK
lin entertainment_N = mkN "viihde" ;
lin enthral_V2 = mkWV2 (k61 "loitsia") ; --UNCHK
lin enthrall_V2 = mkWV2 (k61 "loitsia") ; --UNCHK
lin enthrone_V2 = mkWV2 (k75 "nimetä") "joksikin" ; --UNCHK
lin enthuse_V = mkWV (k67 "intoilla") ; --UNCHK
lin enthusiasm_N = mkWN (k1A "into") ; --UNCHK
lin enthusiast_N = mkN "intoilija" ; --mkWN (k10 "kannattaja") ;
lin enthusiastic_A = mkWA (k47 "innostunut") ;
lin enthusiastically_Adv = mkWAdv (k99 "innostuneesti") ; --UNCHK
lin entice_V2 = mkWV2 (k67A "houkutella") ;
lin enticement_N = mkWN (k2 "viettely") ; --UNCHK
lin entire_A = mkA "kokonainen" ;
lin entirety_N = mkWN (k40 "täydellisyys") ; --UNCHK
lin entitle_V2V = mkV2V (mkV "oikeuttaa") accusative infIllat ; --mkWV2V (k75 "nimetä") ;
lin entitle_VS = mkWVS (k75 "nimetä") ; --UNCHK
lin entitlement_N = mkWN (compoundN "tuki" (k40 "oikeus")) ; --UNCHK
lin entity_N = mkN "olio" ;
lin entomb_V2 = mkWV2 (k73A "haudata") ; --UNCHK
lin entomion_N = mkWN "entomion" ; --UNCHK
lin entomological_A = mkWA (compoundA "hyönteis" (k38 "tieteellinen")) ; --UNCHK
lin entomologist_N = mkWN (compoundN "hyönteis" (k12 "tutkija")) ; --UNCHK
lin entomology_N = mkWN (compoundN "hyönteis" (k48A "tiede")) ; --UNCHK
lin entomophilous_A = mkWA (compoundA "hyönteis" (k12 "suosija")) ; --UNCHK
lin entomophobia_N = mkWN (compoundN "hyönteis" (k1 "kammo")) ; --UNCHK
lin entoproct_N = mkWN (compoundN "pikari" (k1A "mato")) ; --UNCHK
lin entourage_N = mkWN (k48 "seurue") ; --UNCHK
lin entozoan_A = mkWA (k10 "elävä") "sisäloisena" ; --UNCHK
lin entozoic_A = mkWA (k10 "elävä") "sisäloisena" ; --UNCHK
lin entr'acte_N = mkWN (k9A "väliaika") ; --UNCHK
lin entrain_V = mkWV (k66 "nousta") "junaan" ; --UNCHK
lin entrain_V2 = mkWV2 (k66 "nousta") "junaan" ; --UNCHK
lin entrance_N = mkWN (compoundN "sisään" (k1 "tulo")) ; --UNCHK
lin entrance_V2 = mkWV2 (k74 "lumota") ; --UNCHK
lin entrance_fee_N = mkWN (compoundN "sisäänpääsy" (k1 "maksu")) ; --UNCHK
lin entrance_money_N = mkWN (compoundN "sisäänpääsy" (k1 "maksu")) ; --UNCHK
lin entrancement_N = mkWN (k39 "ihastus") ; --UNCHK
lin entrant_N = mkWN (compoundN "osan" (k10 "ottaja")) ; --UNCHK
lin entrap_V2 = mkWV2 (k56 "ajaa") "ansaan" ; --UNCHK
lin entrapment_N = mkWN "rikokseen" "yllyttäminen" ; --UNCHK
lin entreat_V2 = mkWV2 (k74A "vedota") ; --UNCHK
lin entreatingly_Adv = mkWAdv (k99 "itsepintaisesti") ; --UNCHK
lin entreaty_N = mkWN (k39 "vetoomus") ; --UNCHK
lin entrecote_N = mkWN (compoundN "väli" (k39 "kyljys")) ; --UNCHK
lin entree_N = mkWN (compoundN "sisään" (k1 "tulo")) ; --UNCHK
lin entrench_V2 = mkWV2 (k53A "juurruttaa") ; ---ARB
lin entrenchment_N = mkWN (compoundN "taistelu" (k9A "hauta")) ; --UNCHK
lin entrepot_N = mkWN (k2 "varasto") ; --UNCHK
lin entrepreneur_N = mkWN (k10 "yrittäjä") ;
lin entrepreneurial_A = mkWA "yrittäjän" ; --UNCHK
lin entrust_V2 = mkWV2 (k52 "uskoa") ; --UNCHK
lin entry_1_N = mkN "pääsy" ;
lin entry_2_N = mkN "haku" (mkN "sana") ;
lin entry_N = mkWN (compoundN "sisään" (k1 "tulo")) ;
lin entwine_V2 = mkWV2 (k52 "punoa") "yhteen" ; --UNCHK
lin enumerate_V2 = mkWV2 (k67A "eritellä") ; --UNCHK
lin enumeration_N = mkWN (k38 "lukeminen") "numeroiden" ; --UNCHK
lin enunciate_V = mkWV (k52 "lausua") ; --UNCHK
lin enunciate_V2 = mkWV2 (k52 "lausua") ; --UNCHK
lin enunciation_N = mkWN (k39 "esitys") ; --UNCHK
lin enured_A = mkWA (compoundA "kara" (k47 "istunut")) ; --UNCHK
lin enuresis_N = mkWN (k5 "inkontinenssi") ; --UNCHK
lin envelop_V2 = mkWV2 (k62 "ympäröidä") ; --UNCHK
lin envelope_N = mkWN (k39 "päällys") ; --UNCHK
lin envelopment_N = mkWN (k5A "ympäröinti") ; --UNCHK
lin envenom_V2 = mkWV2 (k53A "myrkyttää") ; --UNCHK
lin enviable_A = mkWA "kadehdittava" ; --UNCHK
lin envious_A = mkWA (k38 "mustasukkainen") ; --UNCHK
lin environ_V2 = mkWV2 (k53 "reunustaa") ; --UNCHK
lin environment_N = mkN "ympäristö" ;
lin environmental_A = mkA (separateN "ympäristöä" (mkN "koskeva")) ;
lin environmentalism_N = mkWN (compoundN "ympäristön" (k2 "suojelu")) ; --UNCHK
lin environmentalist_N = mkWN (compoundN "ympäristön" (k12 "suojelija")) ; --UNCHK
lin environs_N = mkWN (compoundN "lähi" (k1A "seutu")) ; --UNCHK
lin envisage_V2 = mkWV2 (k71 "nähdä") "mielessään" ; --UNCHK
lin envision_V2 = mkWV2 (k62 "visioida") ; --UNCHK
lin envision_VS = mkWVS (k62 "visioida") ; --UNCHK
lin envisioned_A = mkWA "kuviteltu" ; --UNCHK
lin envoi_N = mkWN (compoundN "loppu" (k48A "säe")) ; --UNCHK
lin envoy_N = mkWN (compoundN "loppu" (k48A "säe")) ; --UNCHK
lin envy_N = mkWN (k40 "kateus") ; --UNCHK
lin envy_V2 = mkWV2 (k61A "kadehtia") ; --UNCHK
lin enwrap_V2 = mkWV2 (k62 "ympäröidä") ; --UNCHK
lin enzootic_A = mkWA "paikallistauti-" ; --UNCHK
lin enzymatic_A = mkWA "entsymaattinen" ; --UNCHK
lin enzyme_N = mkWN (k6 "entsyymi") ; --UNCHK
lin enzymologist_N = mkWN "entsymologi" ; --UNCHK
lin enzymology_N = mkWN "entsymologia" ; --UNCHK
lin eolith_N = mkWN "eoliitti" ; --UNCHK
lin eolithic_A = mkWA "eoliittinen" ; --UNCHK
lin eon_N = mkWN (k40 "iäisyys") ; --UNCHK
lin eonian_A = mkWA "maailmankauden" ; --UNCHK
lin eoraptor_N = mkWN "eoraptor" ; --UNCHK
lin eosin_N = mkWN "bromeosiini" ; --UNCHK
lin eosinopenia_N = mkWN (k40 "niukkuus") "eosinofiilien" ; --UNCHK
lin eosinophil_N = mkWN "eosinofiili" ; --UNCHK
lin eosinophilia_N = mkWN (k40 "runsaus") "eosinofiilien" ; --UNCHK
lin eosinophilic_A = mkWA "eosinifilian" ; --UNCHK
lin epacris_N = mkWN "epacris" ; --UNCHK
lin epanalepsis_N = mkWN "epanalepsis" ; --UNCHK
lin epanaphora_N = mkWN (compoundN "anaf" (k10 "ora")) ; --UNCHK
lin epanodos_N = mkWN "epanodos" ; --UNCHK
lin epanorthosis_N = mkWN "epanorthosis" ; --UNCHK
lin eparch_N = mkWN (compoundN "käskyn" (k12 "haltija")) ; --UNCHK
lin eparchial_A = mkWA "eparkhiaan" "liittyvä" ; --UNCHK
lin eparchy_N = mkWN (compoundN "hallinto" (k48 "alue")) ; --UNCHK
lin epaulet_N = mkWN (k5A "epoletti") ; --UNCHK
lin epaulette_N = mkWN (k5A "epoletti") ; --UNCHK
lin epauliere_N = mkWN (compoundN "olka" (k33 "suojain")) ; --UNCHK
lin epee_N = mkWN (k9A "miekka") ; --UNCHK
lin ependyma_N = mkWN "ependyymi" ; --UNCHK
lin epenthesis_N = mkWN (compoundN "epen" (k5 "teesi")) ; --UNCHK
lin epenthetic_A = mkWA (compoundA "epent" (k38 "eettinen")) ; --UNCHK
lin epergne_N = mkWN (compoundN "pöytä" (k48 "koriste")) ; --UNCHK
lin ephah_N = mkWN (k9A "vakka") ; --UNCHK
lin ephedra_N = mkWN "efedra" ; --UNCHK
lin ephedrine_N = mkWN "efedriini" ; --UNCHK
lin ephemera_N = mkWN (k3 "ilmiö") "ohimenevä" ; --UNCHK
lin ephemeral_A = mkWA (k38 "katoavainen") ; --UNCHK
lin ephemerality_N = mkWN (k40 "katoavuus") ; --UNCHK
lin ephemerid_N = mkWN (compoundN "päivän" (k1A "korento")) ; --UNCHK
lin ephemeris_N = mkWN (k4A "taulukko") "tähtitieteellinen" ; --UNCHK
lin ephemeron_N = mkWN (compoundN "päivän" (k1A "korento")) ; --UNCHK
lin epic_A = mkWA (k38 "eeppinen") ; --UNCHK
lin epic_N = mkWN (k39 "eepos") ; --UNCHK
lin epicalyx_N = mkWN (compoundN "ulko" (k3 "verhiö")) ; --UNCHK
lin epicanthus_N = mkWN (compoundN "mongolin" (k1 "poimu")) ; --UNCHK
lin epicardia_N = mkWN (compoundN "mahansuu" (k10 "osa")) ; --UNCHK
lin epicardium_N = mkWN (compoundN "sisä" (k7A "lehti")) "sydänpussin" ; --UNCHK
lin epicarp_N = mkWN (compoundN "ekso" (k5A "karppi")) ; --UNCHK
lin epicarpal_A = mkWA "epikarpin" ; --UNCHK
lin epicondyle_N = mkWN (compoundN "sivu" (k9 "nasta")) ; --UNCHK
lin epicondylitis_N = mkWN "epikondyliitti" ; --UNCHK
lin epicranium_N = mkWN "epikranium" ; --UNCHK
lin epicure_N = mkWN (k12 "herkuttelija") ; --UNCHK
lin epicurean_A = mkWA (k38 "epikurolainen") ; --UNCHK
lin epicurean_N = mkWN (k12 "herkuttelija") ; --UNCHK
lin epicureanism_N = mkWN (k40 "epikurolaisuus") ; --UNCHK
lin epicurism_N = mkWN (k40 "epikurolaisuus") ; --UNCHK
lin epicycle_N = mkWN (compoundN "epi" (k5 "sykli")) ; --UNCHK
lin epicyclic_A = mkWA (compoundA "epi" (k38 "syklinen")) ; --UNCHK
lin epicycloid_N = mkWN "episykloidi" ; --UNCHK
lin epideictic_A = mkWA "epideiktinen" ; --UNCHK
lin epidemic_A = mkWA (k38 "epideeminen") ; --UNCHK
lin epidemic_N = mkWN (k12 "epidemia") ; --UNCHK
lin epidemiologic_A = mkWA (k38 "epidemiologinen") ; --UNCHK
lin epidemiologist_N = mkWN (k5 "epidemiologi") ; --UNCHK
lin epidemiology_N = mkWN (k12 "epidemiologia") ; --UNCHK
lin epidendron_N = mkWN (k13 "orkidea") ; --UNCHK
lin epidermis_N = mkWN (k5 "epidermi") ; --UNCHK
lin epidiascope_N = mkWN (compoundN "kuultokuva" (k33A "heitin")) ; --UNCHK
lin epididymis_N = mkWN (compoundN "lisä" (k39 "kives")) ; --UNCHK
lin epididymitis_N = mkWN (compoundN "lisäkives" (k39 "tulehdus")) ; --UNCHK
lin epidural_A = mkWA "ekstraduraali-" ; --UNCHK
lin epigastric_A = mkWA "epigastrinen" ; --UNCHK
lin epigastrium_N = mkWN (compoundN "sydän" (k9 "ala")) ; --UNCHK
lin epigenesis_N = mkWN "epigeneesi" ; --UNCHK
lin epiglottis_N = mkWN (compoundN "kurkun" (k28 "kansi")) ; --UNCHK
lin epiglottitis_N = mkWN (compoundN "kurkunkansi" (k39 "tulehdus")) ; --UNCHK
lin epigone_N = mkWN "jäljittelijä" ; --UNCHK
lin epigram_N = mkWN (k10A "kompa") ; --UNCHK
lin epigrammatic_A = mkWA (k10 "osuva") ; --UNCHK
lin epigraph_N = mkWN (compoundN "piirto" (k39 "kirjoitus")) ; --UNCHK
lin epigraphy_N = mkWN (compoundN "epi" (k14A "grafiikka")) ; --UNCHK
lin epikeratophakia_N = mkWN "epikeratofakia" ; --UNCHK
lin epilation_N = mkWN (compoundN "karvan" (k1 "poisto")) ; --UNCHK
lin epilepsy_N = mkWN (k12 "epilepsia") ;
lin epilepticFem_N = mkWN (k4A "epileptikko") ; --UNCHK
lin epilepticMasc_N = mkWN (k4A "epileptikko") ; --UNCHK
lin epileptic_A = mkWA (k38 "epileptinen") ; --UNCHK
lin epilithic_A = mkWA "epiliittinen" ; --UNCHK
lin epilogue_N = mkWN (k5 "epilogi") ; --UNCHK
lin epimorphic_A = mkWA "epimorfinen" ; --UNCHK
lin epinephrine_N = mkWN (k5 "adrenaliini") ; --UNCHK
lin epiphany_N = mkWN (k39 "ilmestys") ; --UNCHK
lin epiphenomenon_N = mkWN (compoundN "seurannais" (k3 "ilmiö")) ; --UNCHK
lin epiphora_N = mkWN (k1 "toisto") "lauseen" "lopun" ; --UNCHK
lin epiphyllum_N = mkWN (k39 "kaktus") ; --UNCHK
lin epiphyseal_A = mkWA (compoundA "epifysia" (k38 "alinen")) ; --UNCHK
lin epiphysis_N = mkWN (compoundN "käpy" (k38 "rauhanen")) ; --UNCHK
lin epiphytic_A = mkWA "epifyyttinen" ; --UNCHK
lin epiphytotic_A = mkWA (compoundA "epiphyto" (k5 "tic")) ; --UNCHK
lin epiplexis_N = mkWN "epiplexis" ; --UNCHK
lin episcia_N = mkWN (compoundN "kupari" (k7A "lehti")) ; --UNCHK
lin episcleritis_N = mkWN (compoundN "pinta" (k39 "tulehdus")) "silmän" "kovankalvon" ; --UNCHK
lin episcopacy_N = mkWN (k1A "hallinto") "episkopaalinen" ; --UNCHK
lin episcopal_A = mkWA (k38 "papillinen") ; --UNCHK
lin episcopalian_A = mkWA (k38 "episkopaalinen") ; --UNCHK
lin episcopalian_N = mkWN (k32 "jäsen") "episkopaalisen" "kirkon" ; --UNCHK
lin episcopate_N = mkWN (k9A "virka") "piispan" ; --UNCHK
lin episiotomy_N = mkWN (k39 "leikkaus") "välilihan" ; --UNCHK
lin episode_N = mkWN (k5 "episodi") ;
lin episodic_A = mkWA (compoundA "ohi" (k10 "menevä")) ; --UNCHK
lin episome_N = mkWN "episomi" ; --UNCHK
lin epispadias_N = mkWN (compoundN "epispa" (k9 "dia")) ; --UNCHK
lin episteme_N = mkWN (compoundN "alku" (k1A "tieto")) ; --UNCHK
lin epistemic_A = mkWA "tietoa" "koskeva" ; --UNCHK
lin epistemologist_N = mkWN "epistemologi" ; --UNCHK
lin epistemology_N = mkWN (compoundN "tieto" (k12 "teoria")) ; --UNCHK
lin epistle_N = mkWN (k12 "epistola") ; --UNCHK
lin epitaph_N = mkWN (compoundN "hauta" (k39 "kirjoitus")) ; --UNCHK
lin epitaxy_N = mkWN (compoundN "epi" (k12 "taksia")) ; --UNCHK
lin epithalamium_N = mkWN (compoundN "hää" (k1 "runo")) ; --UNCHK
lin epithelial_A = mkWA "epiteeli-" ; --UNCHK
lin epitheliod_A = mkWA (compoundA "epiteeli" (k38 "mäinen")) ; --UNCHK
lin epithelioma_N = mkWN (compoundN "epiteeli" (k33 "kasvain")) ; --UNCHK
lin epithelium_N = mkWN (k5 "epiteeli") ; --UNCHK
lin epithet_N = mkWN (k5A "epiteetti") ; --UNCHK
lin epitome_N = mkWN (k10 "ruumiillistuma") ; --UNCHK
lin epizoan_A = mkWA "ulkolois-" ; --UNCHK
lin epizoic_A = mkWA "ulkoloisena" ; --UNCHK
lin epizootic_A = mkWA (k38 "epideeminen") ; --UNCHK
lin epoch_N = mkWN (k27 "kausi") ; --UNCHK
lin epochal_A = mkWA (k10 "mullistava") ; --UNCHK
lin eponym_N = mkWN "eponyymi" ; --UNCHK
lin eponymous_A = mkWA (compoundA "saman" (k38 "niminen")) ; --UNCHK
lin eponymy_N = mkWN "eponymia" ; --UNCHK
lin epos_N = mkWN (k39 "eepos") ; --UNCHK
lin epoxy_N = mkWN (compoundN "epoksi" (k9 "liima")) ; --UNCHK
lin epping_PN = foreignPN "Epping" ;
lin epsilon_N = mkWN "epsilon" ; --UNCHK
lin epsom_PN = foreignPN "Epsom" ;
lin eptatretus_N = mkWN "eptatretus" ; --UNCHK
lin equable_A = mkWA (k26 "tyyni") ; --UNCHK
lin equal_A = mkA "samanarvoinen" ;
lin equal_N = mkWN (k38 "vertainen") ; --UNCHK
lin equal_V2 = mkV2 (mkV olla_V "sama") (mkPrep "kuin" nominative) ; ----
lin equalitarian_N = mkWN (k10 "kannattava") "tasa-arvoisuutta" ; --UNCHK
lin equality_N = mkWN (compoundN "yhtä" (k40 "suuruus")) ; --UNCHK
lin equalization_N = mkWN (k39 "tasoitus") ; --UNCHK
lin equalize_V2 = mkWV2 (k56A "saattaa") "samanarvoiseksi" ; --UNCHK
lin equalizer_N = mkWN (k5 "tasoitusmaali") ; --UNCHK
lin equanimity_N = mkWN (k40 "rauhallisuus") ; --UNCHK
lin equatability_N = mkWN "rinnastettavuus" ; --UNCHK
lin equate_V2 = mkWV2 (k56A "saattaa") "samanarvoiseksi" ; --UNCHK
lin equation_N = mkN "yhtälö" ;
lin equator_N = mkWN (compoundN "päivän" (k10 "tasaaja")) ; --UNCHK
lin equatorial_A = mkWA "päiväntasaajan" ; --UNCHK
lin equerry_N = mkWN (compoundN "talli" (k6 "mestari")) ; --UNCHK
lin equestrian_A = mkWA "ratsastaja-" ; --UNCHK
lin equestrian_N = mkWN (k10 "ratsastaja") ; --UNCHK
lin equiangular_A = mkWA (compoundA "tasakul" (k38 "mainen")) ; --UNCHK
lin equidistribution_N = mkWN "tasainen" "jakautuminen" ; --UNCHK
lin equilateral_A = mkWA "tasasivuinen" ; --UNCHK
lin equilateral_N = mkWN (k3 "kuvio") "tasasivuinen" ; --UNCHK
lin equilibration_N = mkWN (compoundN "tasa" (k39 "painotus")) ; --UNCHK
lin equilibrium_N = mkWN (compoundN "tasapaino" (k5 "aisti")) ; --UNCHK
lin equine_A = mkWA "hevoseläimiä" "koskeva" ; --UNCHK
lin equine_N = mkWN (compoundN "hevos" (k33 "eläin")) ; --UNCHK
lin equinoctial_A = mkWA "päiväntasaus-" ; --UNCHK
lin equinox_N = mkWN (compoundN "päiväntasaus" (k48 "piste")) ; --UNCHK
lin equip_V2 = mkV2 "varustaa" ;
lin equipment_N = mkWN (k1 "kalusto") | mkN "varuste" ;
lin equipoise_N = mkWN (compoundN "vasta" (k1 "paino")) ; --UNCHK
lin equipoised_A = mkWA "molempikätinen" ; --UNCHK
lin equipotent_A = mkWA (k41A "voimakas") "yhtä" ; --UNCHK
lin equiprobable_A = mkWA (compoundA "toden" (k38 "näköinen")) "yhtä" ; --UNCHK
lin equitable_A = mkWA (compoundA "oikeuden" (k38 "mukainen")) ; --UNCHK
lin equity_N = mkN "osakkuus" ;
lin equivalence_N = mkWN (k40 "vastaavuus") ; --UNCHK
lin equivalent_A = mkWA (k38 "samanlainen") ; --UNCHK
lin equivalent_N = mkN "samanarvoinen" ; --WN (k5A "ekvivalentti") ;
lin equivocal_A = mkWA (compoundA "epä" (k10 "selvä")) ; --UNCHK
lin equivocation_N = mkWN (compoundN "kaksiselitte" (k40 "isyys")) ; --UNCHK
lin er_Interj = mkInterj "öh" ;
lin era_N = mkN "aikakausi" "aikakauden" "aikakausia" ;
lin eradicate_V2 = mkWV2 (k64 "viedä") "hautaan" ; --UNCHK
lin eradication_N = mkWN (k39 "hävitys") ; --UNCHK
lin erase_V2 = mkWV2 (k53A "hävittää") ; --UNCHK
lin eraser_N = mkWN (k5 "kumi") ; --UNCHK
lin erasure_N = mkWN (compoundN "pyy" (k38 "hkiminen")) ; --UNCHK
lin erbium_N = mkWN "järjestysluku" "68" ; --UNCHK
lin erect_A = mkWA (k10 "oleva") "pystyasennossa" ; --UNCHK
lin erect_V2 = mkWV2 (k53A "pystyttää") ; --UNCHK
lin erectile_A = mkWA (compoundA "erek" (k23 "tiili")) ; --UNCHK
lin erecting_N = mkWN (k39 "pystytys") ; --UNCHK
lin erection_N = mkWN (k39 "pystytys") ; --UNCHK
lin erectness_N = mkWN (compoundN "pysty" (k40 "suoruus")) ; --UNCHK
lin eremite_N = mkWN (k4A "erakko") ; --UNCHK
lin eremitic_A = mkWA "erakko-" ; --UNCHK
lin eremitism_N = mkWN "erakkous" ; --UNCHK
lin erfurt_PN = foreignPN "Erfurt" ;
lin erg_N = mkWN "ergi" ; --UNCHK
lin ergo_Adv = mkWAdv (k99 "siis") ; --UNCHK
lin ergodic_A = mkWA "ergodinen" ; --UNCHK
lin ergodicity_N = mkWN "ergodisuus" ; --UNCHK
lin ergonomic_A = mkWA (k38 "ergonominen") ; --UNCHK
lin ergonomics_N = mkWN (k12 "ergonomia") ; --UNCHK
lin ergonovine_N = mkWN (k5 "ergonoviini") ; --UNCHK
lin ergosterol_N = mkWN "ergosteroli" ; --UNCHK
lin ergot_N = mkWN (compoundN "tora" (k10 "jyvä")) ; --UNCHK
lin ergotamine_N = mkWN "ergotamiini" ; --UNCHK
lin ergotic_A = mkWA "torajyvä-" ; --UNCHK
lin ergotism_N = mkWN (compoundN "torajyvä" (k39 "myrkytys")) ; --UNCHK
lin ergotropic_A = mkWA (compoundA "ergo" (k38 "trooppinen")) ; --UNCHK
lin ergotropism_N = mkWN (compoundN "ergo" (k5 "tropismi")) ; --UNCHK
lin erica_N = mkWN (compoundN "kello" (k10 "kanerva")) ; --UNCHK
lin erin_PN = foreignPN "Erin" ;
lin eriogonum_N = mkWN "pumissi" ; --UNCHK
lin eristic_A = mkWA (compoundA "kiistelyn" (k38 "haluinen")) ; --UNCHK
lin eristic_N = mkWN (k2 "väittely") ; --UNCHK
lin eritrea_PN = foreignPN "Eritrea" ;
lin eritrean_A = mkWA (compoundA "eritre" (k38 "alainen")) ; --UNCHK
lin eritrean_N = mkWN (compoundN "eritre" (k38 "alainen")) ; --UNCHK
lin erlangen_PN = foreignPN "Erlangen" ;
lin ermine_N = mkWN (k10A "kärppä") ; --UNCHK
lin ern_N = mkWN (compoundN "meri" (k10 "kotka")) ; --UNCHK
lin erode_V = mkWV (k53A "rapauttaa") ; --UNCHK
lin erode_V2 = mkWV2 (k53A "rapauttaa") ;
lin erogenous_A = mkWA (k38 "erogeeninen") ; --UNCHK
lin erose_A = mkWA (k41A "särmikäs") ; --UNCHK
lin erosion_N = mkWN (k3 "eroosio") ;
lin erosive_A = mkWA "erittäin" "syövyttävä" ; --UNCHK
lin erotic_A = mkWA (k38 "eroottinen") ; --UNCHK
lin erotic_N = mkWN (k2 "henkilö") "eroottinen" ; --UNCHK
lin eroticism_N = mkWN (k40 "seksikkyys") ; --UNCHK
lin err_V = mkWV (k71 "tehdä") "virhe" ; --UNCHK
lin errancy_N = mkWN (k40 "erehtyväisyys") ; --UNCHK
lin errand_N = mkWN (k10 "tehtävä") ; --UNCHK
lin errant_A = mkWA "harhaileva" ; --UNCHK
lin erratic_A = mkWA (k10 "häilyvä") ; --UNCHK
lin erratum_N = mkWN (k48 "virhe") "typografinen" ; --UNCHK
lin erroneous_A = mkWA (k10 "väärä") ; --UNCHK
lin erroneousness_N = mkWN (k48 "virhe") ; --UNCHK
lin error_N = mkN "virhe" ;
lin errorless_A = mkWA (k34A "virheetön") ; --UNCHK
lin ersatz_A = mkWA (compoundA "keino" (k38 "tekoinen")) ; --UNCHK
lin ersatz_N = mkWN "korvike-" ; --UNCHK
lin erse_N = mkWN (k38 "kelttiläinen") ; --UNCHK
lin eructation_N = mkWN (k2 "röyhtäily") ; --UNCHK
lin erudite_A = mkWA (k47 "oppinut") ; --UNCHK
lin eruditeness_N = mkWN (k39 "tietämys") ; --UNCHK
lin erudition_N = mkWN (k39 "tietämys") ; --UNCHK
lin erupt_V = mkWV (k52A "purkautua") ;
lin eruption_N = mkWN "puhkeaminen" ; --UNCHK
lin eruptive_A = mkWA (k38 "eruptiivinen") ; --UNCHK
lin erwinia_N = mkWN "erwinia" ; --UNCHK
lin eryngo_N = mkWN (compoundN "jalo-" (k48A "ohdake")) ; --UNCHK
lin erysipelas_N = mkWN (k1 "ruusu") ; --UNCHK
lin erythema_N = mkWN (k39 "punoitus") ; --UNCHK
lin erythematous_A = mkWA "eryteemaan" "liittyvä" ; --UNCHK
lin erythroblast_N = mkWN "varhaispunasolu" ; --UNCHK
lin erythroblastosis_N = mkWN (compoundN "liika" (k40 "runsaus")) "varhaispunasolujen" ; --UNCHK
lin erythroderma_N = mkWN (k39 "punoitus") "ihon" "sairaalloinen" ; --UNCHK
lin erythroid_A = mkWA "punasoluihin" "liittyvä" ; --UNCHK
lin erythromycin_N = mkWN "Pediamycin" ; --UNCHK
lin erythropoiesis_N = mkWN (k39 "muodostus") "punasolujen" ; --UNCHK
lin erythropoietic_A = mkWA (compoundA "erytropoi" (k38 "eettinen")) ; --UNCHK
lin erythropoietin_N = mkWN (k5 "erytropoietiini") ; --UNCHK
lin escadrille_N = mkWN (k48 "laivue") ; --UNCHK
lin escalade_N = mkWN (k4A "rynnäkkö") ; --UNCHK
lin escalader_N = mkWN "kiipeäjä" ; --UNCHK
lin escalate_V = mkWV (k52A "eskaloitua") ; --UNCHK
lin escalate_V2 = mkWV2 (k52A "eskaloitua") ; --UNCHK
lin escalation_N = mkWN (k1 "nousu") ; --UNCHK
lin escapade_N = mkWN (k9 "pila") ; --UNCHK
lin escape_N = mkWN (k1A "pako") ; --UNCHK
lin escape_V = mkV (mkV "lähteä") "pakoon" ;
lin escape_V2 = mkV2 (mkWV (k72A "paeta")) partitive ;
lin escape_VS = variants {} ; -- mkV2 "paeta" partitive ;
lin escapee_N = mkWN (k6 "karkuri") ; --UNCHK
lin escapement_N = mkWN (k48A "pidäke") ; --UNCHK
lin escapism_N = mkWN (k5 "eskapismi") ; --UNCHK
lin escapist_N = mkWN (k12 "haaveilija") ; --UNCHK
lin escapologist_N = mkWN (compoundN "kahle" (k41A "kuningas")) ; --UNCHK
lin escapology_N = mkWN "pakojen" "tutkiminen" ; --UNCHK
lin escargot_N = mkWN (k12 "etana") ; --UNCHK
lin escarpment_N = mkWN (k10 "luiska") "kaivannon" ; --UNCHK
lin eschar_N = mkWN (k7A "rupi") ; --UNCHK
lin eschatological_A = mkWA (k38 "eskatologinen") ; --UNCHK
lin eschatologist_N = mkWN "eskatologi" ; --UNCHK
lin eschatology_N = mkWN (k12 "eskatologia") ; --UNCHK
lin escherichia_N = mkWN "escherichia" ; --UNCHK
lin eschew_V2 = mkWV2 (k53A "välttää") ; --UNCHK
lin escolar_N = mkWN (compoundN "esko" (k5 "laari")) ; --UNCHK
lin escort_N = mkWN "saattaminen" ; --UNCHK
lin escort_V2 = mkWV2 (k61 "toimia") "seuralaisena" ; --UNCHK
lin escritoire_N = mkWN (compoundN "kirjoitus" (k10A "pöytä")) ; --UNCHK
lin escudo_N = mkWN "escudo" ; --UNCHK
lin escutcheon_N = mkWN (compoundN "vaakuna" (k7A "kilpi")) ; --UNCHK
lin esker_N = mkWN (compoundN "pitkittäis" (k1 "harju")) ; --UNCHK
lin eskimo_N = mkWN (k2 "eskimo") ; --UNCHK
lin esmolol_N = mkWN "Brevibloc" ; --UNCHK
lin esophageal_A = mkWA "ruokatorven" ; --UNCHK
lin esophagitis_N = mkWN "esofagiitti" ; --UNCHK
lin esophagoscope_N = mkWN (compoundN "esofagosko" (k5A "oppi")) ; --UNCHK
lin esophagus_N = mkWN (k1 "nielu") ; --UNCHK
lin esoteric_A = mkWA (k38 "esoteerinen") ; --UNCHK
lin esoterica_N = mkWN (compoundN "esoter" (k9A "iikka")) ; --UNCHK
lin esp_N = mkWN (k1A "havainto") "yliaistillinen" ; --UNCHK
lin espadrille_N = mkWN (k6 "sandaali") "punospohjainen" ; --UNCHK
lin espalier_N = mkWN (k4A "säleikkö") ; --UNCHK
lin especial_A = mkWA (k38 "erikoinen") ;
lin esperanto_N = mkWN (k1 "esperanto") ; --UNCHK
lin espionage_N = mkWN (k2 "vakoilu") ; --UNCHK
lin esplanade_N = mkWN (k5 "esplanadi") ; --UNCHK
lin espoo_PN = mkPN "Espoo" ;
lin espousal_N = mkWN (k10A "hyväksyntä") ; --UNCHK
lin espouse_V2 = mkWV2 (k52A "liittyä") "jhk" ; --UNCHK
lin espresso_N = mkWN (k2 "espresso") ; --UNCHK
lin esprit_N = mkWN (k40 "älykkyys") ; --UNCHK
lin esprit_de_corps_N = mkWN (k7A "henki") ; --UNCHK
lin espy_V2 = mkWV2 (k73 "bongata") ; --UNCHK
lin esquire_N = mkWN (k9 "herra") ; --UNCHK
lin essay_N = mkN "essee" ;
lin essay_V = mkWV (k61 "tutkia") ; --UNCHK
lin essay_V2 = mkWV2 (k61 "tutkia") ; --UNCHK
lin essayist_N = mkWN (k5 "esseisti") ; --UNCHK
lin essen_PN = foreignPN "Essen" ;
lin essence_N = mkWN (k1 "tuoksu") ; --UNCHK
lin essential_A = mkA "olennainen" ;
lin essential_N = mkWN (k48A "tarve") ; --UNCHK
lin essentiality_N = mkWN (k40 "olennaisuus") ; --UNCHK
lin essex_PN = foreignPN "Essex" ;
lin establish_V2 = mkWV2 (mkV "perustaa") ;
lin established_A = variants {} ; --
lin establishment_N = mkN "perustaminen" ; --WN (compoundN "koko" (k38 "aminen")) ;
lin establishmentarianism_N = mkWN (compoundN "kanna" (k38 "ttaminen")) "vallitsevan" "järjestelmän" ; --UNCHK
lin estaminet_N = mkWN (k12 "kuppila") ; --UNCHK
lin estate_N = mkN (lin NK {s = d09 "tila"}) ;
lin estazolam_N = mkWN "ProSom" ; --UNCHK
lin esteem_N = mkWN (k39 "luottamus") ; --UNCHK
lin esteem_V2 = mkWV2 (k52 "katsoa") ; --UNCHK
lin ester_N = mkWN (k6 "esteri") ; --UNCHK
lin esther_PN = foreignPN "Esther" ;
lin esthete_N = mkWN (k4A "esteetikko") ; --UNCHK
lin esthetic_N = mkWN (k14A "estetiikka") ; --UNCHK
lin esthetical_A = mkWA (k38 "esteettinen") ; --UNCHK
lin esthetician_N = mkWN (k4A "esteetikko") ; --UNCHK
lin esthetics_N = mkWN (k14A "estetiikka") ; --UNCHK
lin estimable_A = mkWA (k10 "kunnioitettava") ; --UNCHK
lin estimate_N = mkWN (k3 "arvio") ; --f218
lin estimate_V = mkWV (k62 "estimoida") ; --f77
lin estimate_V2 = mkV2 (mkV (lin VK {s = c62 "arvioida"})) partitive ;
lin estimate_V2V = mkWV2V (k62 "estimoida") ; --UNCHK
lin estimate_VS = mkVS "arvioida" ;
lin estimated_A = variants {} ; --
lin estimation_N = mkWN (k3 "arvio") ; --UNCHK
lin estivation_N = mkWN (compoundN "lehti" (k1A "asento")) "silmun" ; --UNCHK
lin estoppel_N = mkWN (compoundN "estoppel-peri" (k48A "aate")) ; --UNCHK
lin estradiol_N = mkWN "estradioli" ; --UNCHK
lin estrange_V2 = mkWV2 (k71 "tehdä") "tyytymättömäksi" ; --UNCHK
lin estrangement_N = mkWN (k40 "tyytymättömyys") ; --UNCHK
lin estranging_A = mkWA "vieraannuttava" ; --UNCHK
lin estriol_N = mkWN "estrioli" ; --UNCHK
lin estrogen_N = mkWN (k5 "estrogeeni") ; --UNCHK
lin estrogenic_A = mkWA (compoundA "estrogeeni" (k38 "nen")) ; --UNCHK
lin estrone_N = mkWN "Estronol" ; --UNCHK
lin estrous_A = mkWA "kiima-" ; --UNCHK
lin estrus_N = mkWN (k9 "kiima") ; --UNCHK
lin estuarine_A = mkWA "estuaarinen" ; --UNCHK
lin estuary_N = mkWN (compoundN "joen" (k18 "suu")) ; --UNCHK
lin eta_N = mkWN "eeta" ; --UNCHK
lin etagere_N = mkWN (k4A "hyllykkö") ; --UNCHK
lin etamine_N = mkWN "etamiini" ; --UNCHK
lin etanercept_N = mkWN "Enbrel" ; --UNCHK
lin etcetera_N = mkWN (compoundN "epä" (k40 "määräisyys")) ; --UNCHK
lin etch_V = mkWV (k53A "syövyttää") ; --UNCHK
lin etch_V2 = mkWV2 (k53A "syövyttää") ; --UNCHK
lin etcher_N = mkWN (k10 "etsaaja") ; --UNCHK
lin etching_N = mkWN (compoundN "kai" (k38 "vertaminen")) ; --UNCHK
lin etd_N = mkWN (compoundN "räjähdysainejäämä" (k33 "ilmaisin")) ; --UNCHK
lin eternal_A = mkWA (k34A "päättymätön") ; --UNCHK
lin eternity_N = mkWN (k40 "iäisyys") ; --UNCHK
lin ethane_N = mkWN (k5 "etaani") ; --UNCHK
lin ethchlorvynol_N = mkWN "Placidyl" ; --UNCHK
lin ether_N = mkWN (k6 "eetteri") ; --UNCHK
lin ethereal_A = mkWA "eetteri-" ; --UNCHK
lin ethic_N = mkWN (k14A "etiikka") ; --UNCHK
lin ethical_A = mkWA (k38 "eettinen") ; --UNCHK
lin ethicism_N = mkWN (compoundN "etis" (k5 "ismi")) ; --UNCHK
lin ethicist_N = mkWN "eetikko" ; --UNCHK
lin ethics_N = mkWN (k14A "etiikka") ; --UNCHK
lin ethiopia_PN = foreignPN "Etiopia" ;
lin ethiopian_A = mkWA (compoundA "etiopi" (k38 "alainen")) ; --UNCHK
lin ethiopian_N = mkWN (compoundN "etiopi" (k38 "alainen")) ; --UNCHK
lin ethmoid_N = mkWN (compoundN "seula" (k18 "luu")) ; --UNCHK
lin ethnarch_N = mkWN (compoundN "käskyn" (k12 "haltija")) ; --UNCHK
lin ethnic_A = mkWA (k38 "etninen") ; --UNCHK
lin ethnic_N = mkWN (k38 "etninen") ; --UNCHK
lin ethnicity_N = mkWN (compoundN "etn" (k40 "isyys")) ; --UNCHK
lin ethnocentric_A = mkWA (compoundA "ryhmä" (k38 "keskeinen")) ; --UNCHK
lin ethnocentrism_N = mkWN (compoundN "ryhmä" (k40 "keskeisyys")) ; --UNCHK
lin ethnographer_N = mkWN (k5 "etnografi") ; --UNCHK
lin ethnographic_A = mkWA (k38 "etnografinen") ; --UNCHK
lin ethnography_N = mkWN (k12 "etnografia") ; --UNCHK
lin ethnological_A = mkWA (k38 "etnologinen") ; --UNCHK
lin ethnologist_N = mkWN (k5 "etnologi") ; --UNCHK
lin ethnology_N = mkWN (k12 "etnologia") ; --UNCHK
lin ethologist_N = mkWN "etologi" ; --UNCHK
lin ethology_N = mkWN "etologia" ; --UNCHK
lin ethos_N = mkWN "eetos" ; --UNCHK
lin ethosuximide_N = mkWN (compoundN "Eme" (k48A "side")) ; --UNCHK
lin ethyl_N = mkWN (compoundN "etyyli" (k5 "radikaali")) ; --UNCHK
lin ethylene_N = mkWN (k5 "eteeni") ; --UNCHK
lin etiolate_A = mkWA (k34A "väritön") ; --UNCHK
lin etiolation_N = mkWN (k38 "tekeminen") "värittömäksi" ; --UNCHK
lin etiological_A = mkWA (k38 "etiologinen") ; --UNCHK
lin etiologist_N = mkWN "etiologi" ; --UNCHK
lin etiology_N = mkWN (k12 "etiologia") ; --UNCHK
lin etiquette_N = mkWN (k5A "etiketti") ; --UNCHK
lin etodolac_N = mkWN "Lodine" ; --UNCHK
lin etude_N = mkWN (k5 "etydi") ; --UNCHK
lin etui_N = mkWN (k12 "rasia") ; --UNCHK
lin etymological_A = mkWA (k38 "etymologinen") ; --UNCHK
lin etymologist_N = mkWN "etymologi" ; --UNCHK
lin etymology_N = mkWN (k12 "etymologia") ; --UNCHK
lin etymon_N = mkWN (compoundN "kanta" (k9 "sana")) ; --UNCHK
lin eucalyptus_N = mkWN (k39 "eukalyptus") ; --UNCHK
lin eucharist_N = mkWN (k38 "ehtoollinen") "pyhä" ; --UNCHK
lin euchre_N = mkWN "euchre" ; --UNCHK
lin euclidean_A = mkWA (k38 "euklidinen") ; --UNCHK
lin euclidian_A = mkWA (k38 "euklidinen") ; --UNCHK
lin eudemon_N = mkWN "eudaimon" ; --UNCHK
lin eudemonic_A = mkWA "eudaimoninen" ; --UNCHK
lin eudemonism_N = mkWN (compoundN "onnellisuus" (k5A "oppi")) ; --UNCHK
lin eudiometer_N = mkWN (compoundN "eudio" (k5 "metri")) ; --UNCHK
lin eugene_PN = foreignPN "Eugene" ;
lin eugenic_A = mkWA (compoundA "rotu" (k38 "hygieeninen")) ; --UNCHK
lin eugenics_N = mkWN (compoundN "rotu" (k12 "hygienia")) ; --UNCHK
lin euglena_N = mkWN (compoundN "vihersiima" (k3 "eliö")) ; --UNCHK
lin euglenoid_N = mkWN (k10 "levä") ; --UNCHK
lin eukaryote_N = mkWN (k50 "aitotumallinen") ; --UNCHK
lin eukaryotic_A = mkWA (k50 "aitotumallinen") ; --UNCHK
lin eulogist_N = mkWN (k10 "pitäjä") "ylistyspuheen" ; --UNCHK
lin eulogistic_A = mkWA "kiittävä" ; --UNCHK
lin eulogize_V2 = mkWV2 (k53A "kiittää") ; --UNCHK
lin eulogy_N = mkWN (k39 "ylistys") ; --UNCHK
lin eunice_PN = foreignPN "Eunice" ;
lin eunuch_N = mkWN (k41 "kuohilas") ; --UNCHK
lin euphemism_N = mkWN (k5 "eufemismi") ; --UNCHK
lin euphemistic_A = mkWA (k38 "eufemistinen") ; --UNCHK
lin euphonic_A = mkWA (k41A "soinnukas") ; --UNCHK
lin euphonious_A = mkWA (k41A "soinnukas") ; --UNCHK
lin euphonium_N = mkWN (k5 "barytoni") ; --UNCHK
lin euphony_N = mkWN (k5A "musiikki") ; --UNCHK
lin euphorbium_N = mkWN "euforbia" ; --UNCHK
lin euphoria_N = mkWN (k12 "euforia") ;
lin euphoriant_A = mkWA (compoundA "euforis" (k10 "oiva")) ; --UNCHK
lin euphoriant_N = mkWN (k48A "lääke") "euforisoiva" ; --UNCHK
lin euphoric_A = mkWA (k38 "euforinen") ; --UNCHK
lin euphuism_N = mkWN (compoundN "eufu" (k5 "ismi")) ; --UNCHK
lin eupnea_N = mkWN (k39 "hengitys") "normaali" ; --UNCHK
lin eura_PN = mkPN "Eura" ;
lin eurajoki_PN = mkPN (mkN "Eurajoki" "Eurajokia") ;
lin eurasian_A = mkWA (k38 "euraasialainen") ; --UNCHK
lin eurasian_N = mkWN (k38 "euraasialainen") ; --UNCHK
lin eurhythmics_N = mkWN (k40 "sopusointuisuus") "rytminen" ; --UNCHK
lin euro_N = mkN "euro" ;
lin eurodollar_N = mkWN (compoundN "euro" (k6 "dollari")) ; --UNCHK
lin europe_PN = mkPN "Eurooppa" ;
lin european_A = mkWA (k38 "eurooppalainen") ;
lin european_N = mkWN (k38 "eurooppalainen") ; --UNCHK
lin european_union_NP = Syntax.mkNP (mkPN "Euroopan Unioni") ;
lin europium_N = mkWN "järjestysluku" "63" ; --UNCHK
lin eurypterid_N = mkWN (compoundN "järvi" (k5 "skorpioni")) ; --UNCHK
lin eurythmics_N = mkWN (k40 "sopusointuisuus") "rytminen" ; --UNCHK
lin eurythmy_N = mkWN (k40 "sopusointuisuus") "rytminen" ; --UNCHK
lin eusporangiate_A = mkWA "itiöpesäkkeelliset" ; --UNCHK
lin eusporangium_N = mkWN (compoundN "itiö" (k48A "pesäke")) ; --UNCHK
lin eutectic_N = mkWN (k39 "seos") "eutektinen" ; --UNCHK
lin euthanasia_N = mkWN (k12 "eutanasia") ; --UNCHK
lin euthenics_N = mkWN (k12 "ergonomia") ; --UNCHK
lin eutherian_A = mkWA "istukkanisäkäs-" ; --UNCHK
lin eutrophic_A = mkWA (k10 "rehevä") ; --UNCHK
lin eutrophication_N = mkWN "rehevöityminen" ; --UNCHK
lin evacuate_V2 = mkWV2 (k54A "tyhjentää") ; --UNCHK
lin evacuation_N = mkWN (k5A "evakuointi") ; --UNCHK
lin evacuee_N = mkWN (k2 "henkilö") "evakuoitu" ; --UNCHK
lin evade_V2 = mkWV2 (k67A "luikerrella") ; --UNCHK
lin evaluate_V = mkWV (k67 "arvostella") ; --UNCHK
lin evaluate_V2 = mkWV2 (k67 "arvostella") ; --UNCHK
lin evaluation_N = mkWN (k5A "evaluointi") ; --UNCHK
lin evaluative_A = mkWA (compoundA "arvio" (k9 "iva")) ; --UNCHK
lin evaluator_N = mkWN (k6 "tuomari") ; --UNCHK
lin evanescence_N = mkWN (compoundN "kato" (k38 "aminen")) ; --UNCHK
lin evanescent_A = mkWA (k10 "katoava") ; --UNCHK
lin evangelical_A = mkWA (k38 "evankelinen") ; --UNCHK
lin evangelicalism_N = mkWN (k5 "pietismi") ; --UNCHK
lin evangelism_N = mkWN "evankeliumin" "levittäminen" ; --UNCHK
lin evangelist_N = mkWN (k12 "lukija") "evankeliumitekstin" ; --UNCHK
lin evangelistic_A = mkWA (k38 "evankelinen") ; --UNCHK
lin evaporable_A = mkWA "höyrystyvä" ; --UNCHK
lin evaporate_V = mkWV (k52A "haihtua") ; --UNCHK
lin evaporate_V2 = mkWV2 (k52A "haihtua") ; --UNCHK
lin evaporate_VS = mkWVS (k52A "haihtua") ; --UNCHK
lin evaporation_N = mkWN (k39 "haihdutus") ; --UNCHK
lin evaporative_A = mkWA "höyrytys-" ; --UNCHK
lin evaporite_N = mkWN (compoundN "evapo" (k5A "riitti")) ; --UNCHK
lin evasion_N = mkWN "välttely" ;
lin evasive_A = mkWA (k10 "kiertelevä") ; --UNCHK
lin evasiveness_N = mkWN (k2 "karttelu") ; --UNCHK
lin eve_N = mkWN "Eeva" ; --UNCHK
lin even_1_A = mkWA (k99 "tasan") ; --UNCHK
lin even_2_A = mkWA (k99 "tasan") ; --UNCHK
lin even_AdA = mkAdA "jopa" ; --WAdA (k99 "tasan") ;
lin even_AdV = mkAdV "jopa" ;
lin even_Adv = mkAdv "jopa" ;
lin even_N = mkWN (k9A "ilta") ; --UNCHK
lin even_V2 = mkWV2 (k53A "tasoittaa") ; --UNCHK
lin even_out_V = mkWV (k53A "tasoittaa") ; --UNCHK
lin even_though_Subj = mkSubj "vaikka" ;
lin even_handed_A = mkWA (k34A "puolueeton") ; --UNCHK
lin evening_N = mkWN (k9A "ilta") ;
lin evenness_N = mkWN (k40 "tasapuolisuus") ; --UNCHK
lin evensong_N = mkWN (compoundN "ilta" (k40 "hartaus")) ; --UNCHK
lin event_N = mkN "tapahtuma" ;
lin eventful_A = mkWA (k41A "vauhdikas") ; --UNCHK
lin eventide_N = mkWN (k9A "ilta") ; --UNCHK
lin eventration_N = mkWN (compoundN "vatsa" (k10 "tyrä")) "suuri" ; --UNCHK
lin eventual_A = mkA (mkN "lopulta" (mkN "tapahtuva")) ;
lin eventuality_N = mkWN (k10 "sattuma") "mahdollinen" ; --UNCHK
lin ever_AdV = mkAdV "koskaan" ;
lin ever_Adv = mkAdv "aina" ;
lin evergreen_A = mkWA (compoundA "iki" (k15 "vihreä")) ; --UNCHK
lin evergreen_N = mkWN (k5 "kasvi") "ainavihanta" ; --UNCHK
lin everlasting_A = mkWA (k10 "syvä") ; --UNCHK
lin everlasting_N = mkWN (compoundN "iki" (k10A "kukka")) ; --UNCHK
lin everlastingness_N = mkWN (k40 "iankaikkisuus") ; --UNCHK
lin evermore_Adv = mkWAdv (k99 "ikuisesti") ; --UNCHK
lin eversion_N = mkWN "ulospäin" "kääntyminen" ; --UNCHK
lin every_Det = S.every_Det ;
lin everybody_NP = S.everybody_NP ;
lin everyday_A = mkWA (compoundA "joka" (k38 "päiväinen")) ;
lin everyman_N = mkWN (compoundN "joka" (k42 "mies")) ; --UNCHK
lin everyone_NP = S.everybody_NP ;
lin everyplace_Adv = mkWAdv (k99 "kaikkialle") ; --UNCHK
lin everything_NP = S.everything_NP ;
lin everywhere_Adv = S.everywhere_Adv ;
lin evesham_PN = foreignPN "Evesham" ;
lin evict_V2 = mkWV2 (k55A "häätää") ; --UNCHK
lin eviction_N = mkWN (k1A "häätö") ; --UNCHK
lin evidence_1_N = mkN "todiste" | mkN "evidenssi" ;
lin evidence_2_N = mkN "evidenssi" ;
lin evidence_N = mkN "evidenssi" ;
lin evidence_V2 = mkWV2 (k53 "todistaa") ; --UNCHK
lin evident_A = mkWA (kH1 "ilmeinen") ; --UNCHK
lin evidential_A = mkWA (k38 "todisteellinen") ; --UNCHK
lin evidentiary_A = mkWA (k38 "todisteellinen") ; --UNCHK
lin evijärvi_PN = mkPN (mkN "Evijärvi" "Evijärviä") ;
lin evil_A = mkWA (k9 "paha") ;
lin evil_N = mkWN (k40 "häijyys") ; --UNCHK
lin evince_V2 = mkWV2 (k53A "osoittaa") ; --UNCHK
lin eviscerate_V2 = mkWV2 (k61 "tutkia") ; --UNCHK
lin evisceration_N = mkWN (compoundN "vesi" (k38 "ttäminen")) ; --UNCHK
lin evitable_A = mkWA (k10 "oleva") "vältettävissä" ; --UNCHK
lin evocation_N = mkWN "esiin" "herättäminen" ; --UNCHK
lin evocative_A = mkWA (compoundA "muis" (k10 "tuttava")) "jstk" ; --UNCHK
lin evoke_V2 = mkWV2 (k64 "tuoda") "mieleen" ; --UNCHK
lin evolution_N = mkN "evoluutio" ; --mkWN "kehittyminen" ;
lin evolutionary_A = mkWA (compoundA "kehitys" (k38 "opillinen")) ; --UNCHK
lin evolutionistFem_N = mkWN (k10 "kannattaja") "kehitysopin" ; --UNCHK
lin evolutionistMasc_N = mkWN (k10 "kannattaja") "kehitysopin" ; --UNCHK
lin evolve_V = mkWV (k52A "kehittyä") ;
lin evolve_V2 = mkWV2 (k52A "kehittyä") ; --UNCHK
lin ewe_N = mkWN (k23 "uuhi") ; --UNCHK
lin ewell_PN = foreignPN "Ewell" ;
lin ewer_N = mkWN (k33A "kaadin") ; --UNCHK
lin ex_gratia_A = mkWA (compoundA "vapaaeh" (k38 "toinen")) ; --UNCHK
lin ex_officio_A = mkWA (k99 "puolesta") "viran" ; --UNCHK
lin ex_officio_Adv = mkWAdv (k99 "puolesta") "viran" ; --UNCHK
lin exabit_N = mkWN (compoundN "eksa" (k5A "bitti")) ; --UNCHK
lin exabyte_N = mkWN (compoundN "eksa" (k1 "tavu")) ; --UNCHK
lin exacerbate_V2 = mkWV2 (k73 "lisätä") partitive ;
lin exacerbation_N = mkWN (compoundN "pahe" (k38 "neminen")) ; --UNCHK
lin exact_A = mkA "eksaksi" ;
lin exact_V2 = mkWV2 (k61 "periä") ; --UNCHK
lin exacta_N = mkWN "kaksoisvedonlyönti" ; --UNCHK
lin exacting_A = mkWA (k10 "vaativa") ; --UNCHK
lin exaction_N = mkWN (kH1 "kanto") ; --UNCHK
lin exactitude_N = mkWN (k40 "tarkkuus") ; --UNCHK
lin exactness_N = mkWN (k40 "tarkkuus") ; --UNCHK
lin exaggerate_V = mkWV (k52A "ampua") "yli" ; --UNCHK
lin exaggerate_V2 = mkV2 "liioitella" partitive ; --mkWV2 (k52A "ampua") "yli" ;
lin exaggeration_N = mkWN (k2 "liioittelu") ; --UNCHK
lin exalt_V2 = mkWV2 (k54A "ylentää") ; --UNCHK
lin exaltation_N = mkWN "apoteoosi" ; --UNCHK
lin exam_N = mkWN (k5A "tentti") ; --UNCHK
lin examen_N = mkWN (k39 "tarkastus") ; --UNCHK
lin examination_N = mkWN (k2 "tarkastelu") ; --UNCHK
lin examine_V2 = mkV2 (lin VK {s = c61 "tutkia"}) ;
lin examiner_N = mkWN (k10 "tarkastaja") ; --UNCHK
lin example_N = mkN "esimerkki" ;
lin exanthem_N = mkWN (k10 "ihottuma") ; --UNCHK
lin exarch_N = mkWN (k5A "eksarkki") ; --UNCHK
lin exasperate_V2 = mkWV2 (k73 "lisätä") ; --UNCHK
lin exasperating_A = mkWA (k10 "raskauttava") ; --UNCHK
lin exasperation_N = mkWN "ärsyttäminen" ; --UNCHK
lin exaugural_A = mkWA (k10 "päättävä") "virkakauden" ; --UNCHK
lin exbibit_N = mkWN (compoundN "eksbi" (k5A "bitti")) ; --UNCHK
lin excavate_V = mkWV (k56 "kaivaa") ; --UNCHK
lin excavate_V2 = mkWV2 (k56 "kaivaa") ; --UNCHK
lin excavation_N = mkWN (k9A "louhinta") ; --UNCHK
lin excavator_N = mkWN (k6 "kaivuri") ; --UNCHK
lin exceed_V2 = mkV2 "ylittää" ;
lin exceedance_N = mkWN (k40 "pysyvyys") ; --UNCHK
lin exceeding_A = mkWA (k34A "tavaton") ; --UNCHK
lin excel_V = mkWV (k67 "olla") "parempi" ; --UNCHK
lin excel_V2 = mkWV2 (k67 "olla") "parempi" ; --UNCHK
lin excellence_N = mkWN (k40 "erinomaisuus") ; --UNCHK
lin excellency_N = mkWN (k40 "taidokkuus") ; --UNCHK
lin excellent_A = mkA "erinomainen" ;
lin excelsior_N = mkWN (k9 "lastuvilla") ; --UNCHK
lin except_Conj = mkConj "paitsi" ;
lin except_Prep = S.except_Prep ;
lin except_V2 = mkWV2 (k53A "jättää") "pois" ; --UNCHK
lin except_for_Prep = mkPrep "lukuunottamatta" partitive ;
lin exception_N = mkN "poikkeus" ;
lin exceptionable_A = mkWA (compoundA "ki