concrete DictionaryChi of Dictionary = CatChi ** open ParadigmsChi,
(S = SyntaxChi),
(L = LexiconChi),
(R = ResChi),
Prelude in {

flags coding=utf8 ;

oper mkNPword : Str -> NP = \s -> lin NP (ss (R.word s)) ; -- to be used in lexicon building only

oper adjAdv : A -> CatChi.Adv = \a -> lin Adv {s = a.s ; advType = R.ATManner} ;

oper prepV2 : V -> Prep -> V2 = \v,p -> mkV2 v p ;
oper advV : V -> Adv -> V = \v,a -> mkV v.s a.s ;

lin a_priori_A = mkA "先验" ;
lin aachen_PN = mkPN "亚琛" ; -- comment=src=geonames status=guess
lin aalii_N = mkN "坡柳" | mkN "车桑子" ; -- open-multilingual-wordnet
lin aardvark_N = mkN "土豚" ; -- status=guess
lin aardwolf_N = mkN "土狼" ; -- status=guess
lin aarhus_PN = foreignPN "Aarhus" ; -- comment=src=eng status=guess
lin abaca_N = mkN "蕉麻" | mkN "马尼拉麻" ; -- status=guess -- status=guess
lin aback_Adv = mkAdv "向后" ;
lin abactinal_A = mkA "反口方" | mkA "反口" | mkA "离辐" ; -- open-multilingual-wordnet
lin abacus_N = mkN "算盘" ;
lin abalone_N = mkN "鮑魚" | mkN "鲍鱼" | {-mwn-} mkN "大鲍" | mkN "鲍" | mkN "鲍贝" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin abandon_V2 = mkV2 "捐" | mkV2 "放弃" ;
lin abandonment_N = mkN "放弃" ;
lin abarticulation_N = mkN "动关节" ; -- open-multilingual-wordnet
lin abash_V2 = mkV2 "使+困窘" ;
lin abashment_N = mkN "羞愧" ; -- open-multilingual-wordnet
lin abasia_N = mkN "失步症" | mkN "步履艰难症" | mkN "步行不能" ; -- open-multilingual-wordnet
lin abasic_A = mkA "不能步行" | mkA "不能行走" ; -- open-multilingual-wordnet
lin abatable_A = mkA "可减轻" ; -- open-multilingual-wordnet
lin abate_V = mkV "缓和" ;
lin abate_V2 = mkV2 "减轻" ;
lin abatement_N = mkN "减少" ;
lin abattis_N = mkN "拒木" | mkN "有刺铁丝网" | mkN "铁丝网" | mkN "鹿柴" | mkN "鹿砦" | mkN "鹿角栅" ; -- open-multilingual-wordnet
lin abattoir_N = mkN "屠宰場" | mkN "屠宰场" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin abaxial_A = mkA "离开轴心" | mkA "轴外" | mkA "远轴" ; -- open-multilingual-wordnet
lin abaya_N = mkN "长袍" ; -- open-multilingual-wordnet
lin abbacy_N = mkN "修道院院长辖区" ; -- open-multilingual-wordnet
lin abbess_N = mkN "女修道院院长" ; -- open-multilingual-wordnet
lin abbey_N = mkN "僧院" "座" ;
lin abbot_N = mkN "修道院院长" ; -- open-multilingual-wordnet
lin abbreviation_N = mkN "縮寫" | mkN "缩写" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin abcoulomb_N = mkN "电磁库仑" | mkN "绝对库伦" ; -- open-multilingual-wordnet
lin abdicable_A = mkA "可放弃" | mkA "可辞职" ; -- open-multilingual-wordnet
lin abdicate_V = mkV "辭職" | mkV "辞职" | {-mwn-} mkV "放弃" | mkV "禅让" | mkV "让出" | mkV "退位" | mkV "退出" ; -- status=guess, src=wikt -- status=guess, src=wikt -- open-multilingual-wordnet
lin abdicate_V2 = mkV2 "放弃" ;
lin abdication_N = mkN "退位" ; -- status=guess
lin abdicator_N = mkN "放弃者" | mkN "让位者" ; -- open-multilingual-wordnet
lin abdomen_N = mkN "肚子" "個" | {-HSK-} mkN "腹部" | mkN "腹" | {-mwn-} mkN "肚子" | mkN "胃" | mkN "腹部" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin abdominal_N = mkN "腹腔" | {-mwn-} mkN "腹肌" | mkN "腹部的" ; -- status=guess -- open-multilingual-wordnet
lin abdominocentesis_N = mkN "腹腔穿刺术" ; -- open-multilingual-wordnet
lin abdominous_A = mkA "大肚子" | mkA "大腹便便" ; -- open-multilingual-wordnet
lin abdominovesical_A = mkA "腹膀胱" ; -- open-multilingual-wordnet
lin abducent_A = mkA "使外展" | mkA "向外扩展" ; -- open-multilingual-wordnet
lin abduction_N = mkN "绑架" ;
lin abductor_N = mkN "誘拐者" | mkN "诱拐者" | mkN "綁架者" | mkN "绑架者" | mkN "劫持者" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin abe_PN = foreignPN "Abe" ; -- comment=src=eng status=guess
lin abelia_N = mkN "交翅" | mkN "六条木" | mkN "六道木" | mkN "双花六道木" ; -- open-multilingual-wordnet
lin abercarn_PN = foreignPN "Abercarn" ; -- comment=src=geonames status=guess
lin aberdare_PN = foreignPN "Aberdare" ; -- comment=src=geonames status=guess
lin aberdeen_PN = mkPN "阿伯丁" ; -- comment=src=geonames status=guess
lin abergavenny_PN = foreignPN "Abergavenny" ; -- comment=src=geonames status=guess
lin abergele_PN = foreignPN "Abergele" ; -- comment=src=geonames status=guess
lin aberrant_A = mkA "畸变" | {-mwn-} mkA "异常" ; -- status=guess -- open-multilingual-wordnet
lin aberrant_N = mkN "脱离常轨者" ; -- open-multilingual-wordnet
lin aberration_N = mkN "光行差" ;
lin abertillery_PN = foreignPN "Abertillery" ; -- comment=src=geonames status=guess
lin aberystwyth_PN = mkPN "阿伯里斯特威斯" ; -- comment=src=geonames status=guess
lin abet_V = mkV "煽动" ;
lin abet_V2 = mkV2 "煽动" ;
lin abetalipoproteinemia_N = mkN "血症" ; -- open-multilingual-wordnet
lin abetment_N = mkN "唆使" | mkN "教唆" | mkN "煽动" ; -- open-multilingual-wordnet
lin abettor_N = mkN "唆使者" | mkN "煽动者" ; -- open-multilingual-wordnet
lin abfarad_N = mkN "电磁法拉" | mkN "绝对法拉" ; -- open-multilingual-wordnet
lin abhenry_N = mkN "电磁亨利" | mkN "绝对亨利" ; -- open-multilingual-wordnet
lin abhor_V2 = mkV2 (mkV "痛恨") ; -- status=guess, src=wikt
lin abhorrent_A = mkA "厌恶" | mkA "可恶" ; -- open-multilingual-wordnet
lin abhorrer_N = mkN "厌恶者" ; -- open-multilingual-wordnet
lin abidance_N = mkN "依从" | mkN "遵守" ; -- open-multilingual-wordnet
lin abide_V = mkV "忍受" ;
lin abide_V2 = mkV2 (mkV "遵循") | mkV2 (mkV "遵守") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin abide_by_V2 = mkV2 "遵守" ;
lin abience_N = mkN "避开" ; -- open-multilingual-wordnet
lin abient_A = mkA "回避" | mkA "背向" | mkA "避开" ; -- open-multilingual-wordnet
lin ability_N = mkN "才" | mkN "本领" "項" | mkN "能" | mkN "能力" "個" | {-HSK-} mkN "能力" ;
lin abingdon_PN = mkPN "阿宾登" ; -- comment=src=geonames status=guess
lin abiogenesis_N = mkN "单性生殖" | mkN "无生源论" | mkN "无生源说" | mkN "自然发生" | mkN "自然发生论" | mkN "自生" ; -- open-multilingual-wordnet
lin abiogenetic_A = mkA "偶发" | mkA "自然发生" | mkA "非生源说" ; -- open-multilingual-wordnet
lin abiogenist_N = mkN "偶发论者" | mkN "自然发生论者" ; -- open-multilingual-wordnet
lin abiotrophy_N = mkN "生活力缺失" | mkN "营养性衰竭" ; -- open-multilingual-wordnet
lin abject_A = mkA "卑劣" ;
lin abjection_N = mkN "谦卑" ; -- open-multilingual-wordnet
lin ablated_A = mkA "消融" | mkA "腐蚀" | mkA "融化" ; -- open-multilingual-wordnet
lin ablation_N = mkN "切掉" | mkN "切除" ; -- open-multilingual-wordnet
lin ablative_A = mkA "离格" ; -- open-multilingual-wordnet
lin ablative_N = mkN "奪格" | mkN "夺格" | {-mwn-} mkN "离格" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ablaut_N = mkN "元音变换" ; -- open-multilingual-wordnet
lin ablaze_A = mkA "燃燒" | mkA "燃烧" | mkA "起火" | mkA "著火" | mkA "着火" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin able_A = mkA "硬" | mkA "能" | mkA "能力" | {-HSK-} mkA "能够" ;
lin ablepharia_N = mkN "没有眼睑" ; -- open-multilingual-wordnet
lin abloom_A = mkA "开花" ; -- open-multilingual-wordnet
lin ablution_N = mkN "沐浴" ; -- status=guess
lin ablutionary_A = mkA "斋戒沐浴" ; -- open-multilingual-wordnet
lin abnegator_N = mkN "克制者" | mkN "放弃者" ; -- open-multilingual-wordnet
lin abnormal_A = mkA "异常" ;
lin aboard_Adv = mkAdv "在船上" ;
lin aboard_Prep = mkPrep "船上" ;
lin abocclusion_N = mkN "咬合不全" ; -- open-multilingual-wordnet
lin abode_N = mkN "住处" | mkN "住宅" | mkN "住所" ; -- open-multilingual-wordnet
lin abohm_N = mkN "电磁欧" | mkN "绝对单位欧姆" | mkN "绝对欧姆" ; -- open-multilingual-wordnet
lin abolish_V2 = mkV2 "取消" ;
lin abolishable_A = mkA "可取消" | mkA "可废止" ; -- open-multilingual-wordnet
lin abolition_N = mkN "废止" ;
lin abolitionary_A = mkA "斋戒沐浴" ; -- open-multilingual-wordnet
lin abolitionism_N = mkN "废奴主义" ; -- open-multilingual-wordnet
lin abolitionist_N = mkN "廢除主義者" | {-mwn-} mkN "废奴主义者" ; -- status=guess -- open-multilingual-wordnet
lin abomasal_A = mkA "皱胃" ; -- open-multilingual-wordnet
lin abomasum_N = mkN "皱胃" | mkN "真胃" | mkN "第四胃" ; -- open-multilingual-wordnet
lin abominable_A = mkA "可恶" ;
lin abomination_N = mkN "憎恨" ;
lin abominator_N = mkN "厌恶者" ; -- open-multilingual-wordnet
lin aboral_A = mkA "反口" ; -- open-multilingual-wordnet
lin aboriginal_A = mkA "土著" ; -- status=guess
lin aborigine_N = mkN "原住民" | mkN "土著" ; -- status=guess -- status=guess
lin abort_N = mkN "中斷" | mkN "放棄" ; -- status=guess -- status=guess
lin abort_V = mkV "流产" ;
lin abort_V2 = mkV2 "使+流产" ;
lin abortion_N = mkN "流产" ;
lin abortionistFem_N = mkN "非法为人堕胎者" ;
lin abortionistMasc_N = mkN "非法为人堕胎者" ;
lin abortive_A = mkA "流产" ;
lin abortus_N = mkN "流产胎" ; -- open-multilingual-wordnet
lin abound_V = mkV "充满" ;
lin about_AdN = mkAdN "关于" ;
lin about_Adv = mkAdv "关于" | {-HSK-} mkAdv "大概" | mkAdv "大约" ;
lin about_Prep = mkPrep "关于" ;
lin above_A = mkA "上" | mkA "前面" | {-HSK-} mkA "以上" ;
lin above_Adv = mkAdv "上" | mkAdv "前面" | {-HSK-} mkAdv "以上" ;
lin above_N = mkN "上" | mkN "前面" | {-HSK-} mkN "上文""" ;
lin above_Prep = S.above_Prep ;
lin above_board_A = mkA "光明正大" ;
lin aboveboard_A = mkA "光明正大" | mkA "光明磊落" | mkA "率直" | mkA "直截了当" ; -- open-multilingual-wordnet
lin abracadabra_N = mkN "胡言乱语" ; -- open-multilingual-wordnet
lin abrachia_N = mkN "无臂" ; -- open-multilingual-wordnet
lin abrader_N = mkN "磨光机" ; -- open-multilingual-wordnet
lin abraham_PN = foreignPN "Abraham" ; -- comment=src=eng status=guess
lin abranchiate_A = mkA "无腮" | mkA "无鳃动物" ; -- open-multilingual-wordnet
lin abrasive_A = mkA "磨碎" ;
lin abrasive_N = mkN "磨料" ;
lin abreast_Adv = mkAdv "並排" | mkAdv "并排" ; -- status=guess -- status=guess
lin abridge_V2 = mkV2 "删节" | {-HSK-} mkV2 "节" ;
lin abridger_N = mkN "缩写者" ; -- open-multilingual-wordnet
lin abroad_Adv = mkAdv "国外" ;
lin abrocome_N = mkN "鼠" ; -- open-multilingual-wordnet
lin abrupt_A = mkA "突兀" | {-HSK-} mkA "突然" ;
lin abscess_N = mkN "膿腫" | mkN "脓肿" ; -- status=guess -- status=guess
lin abscessed_A = mkA "成溃疡" | mkA "长脓疮" ; -- open-multilingual-wordnet
lin abscissa_N = mkN "横坐标" ; -- open-multilingual-wordnet
lin abscission_N = mkN "切断" | mkN "切除" ; -- open-multilingual-wordnet
lin abscond_V = mkV "潜逃" | mkV "跑掉" | mkV "逃亡" | mkV "逃走" ; -- open-multilingual-wordnet
lin absconder_N = mkN "潜逃者" | mkN "逃匿者" ; -- open-multilingual-wordnet
lin abseiler_N = mkN "沿绳滑下的人" ; -- open-multilingual-wordnet
lin absence_N = mkN "缺席" "次" ;
lin absent_A = mkA "缺席" ;
lin absent_Prep = mkPrep "缺席" ;
lin absentee_N = mkN "不在者" | mkN "缺席者" ; -- open-multilingual-wordnet
lin absenteeism_N = mkN "旷课" "次" ;
lin absinthe_N = mkN "苦艾" | {-mwn-} mkN "苦艾酒" ; -- status=guess -- open-multilingual-wordnet
lin absolute_A = mkA "绝对" ;
lin absolute_N = mkN "君主專制" | mkN "君主专制" | mkN "絕對君主制" | mkN "绝对君主制" | {-HSK-} mkN "绝对" | {-mwn-} mkN "绝对事物" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin absolutism_N = mkN "专制主义" ;
lin absolutist_A = mkA "专制主义者" | mkA "专制政治论者" | mkA "极权主义" ; -- open-multilingual-wordnet
lin absolve_V2 = mkV2 "免除" ;
lin absolver_N = mkN "宣布免除的人" ; -- open-multilingual-wordnet
lin absolvitory_A = mkA "免罪" | mkA "免除" ; -- open-multilingual-wordnet
lin absorb_V2 = mkV2 "吃" | mkV2 "吸收" ;
lin absorbefacient_A = mkA "促进吸收" | mkA "导致或造成吸收" ; -- open-multilingual-wordnet
lin absorbent_A = mkA "能吸收" ;
lin absorbent_N = mkN "吸收剂" ; -- open-multilingual-wordnet
lin absorber_N = mkN "减震器" "个" ;
lin absorption_N = mkN "专心" | {-HSK-} mkN "吸收" ;
lin abstain_V = mkV "戒除" ;
lin abstainer_N = mkN "戒酒者" ; -- open-multilingual-wordnet
lin abstention_N = mkN "弃权" ;
lin abstinence_N = mkN "节制" ;
lin abstract_A = mkA "抽象" ;
lin abstract_N = mkN "抽象" | {-HSK-} mkN "摘要" "篇" ;
lin abstractedness_N = mkN "出神" | mkN "心不在焉" ; -- open-multilingual-wordnet
lin abstraction_N = mkN "抽象化" | mkN "抽象派作品" ; -- open-multilingual-wordnet
lin abstractionism_N = mkN "抽象主義" | mkN "抽象主义" | {-mwn-} mkN "抽象派艺术" | mkN "抽象艺术" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin abstractionist_N = mkN "抽象派艺术家" ; -- open-multilingual-wordnet
lin abstractive_A = mkA "抽象" ; -- open-multilingual-wordnet
lin abstractor_N = mkN "抽象者" | mkN "概括者" ; -- open-multilingual-wordnet
lin absurd_A = mkA "荒谬" | {-HSK-} mkA "岂有此理" ;
lin absurdity_N = mkN "荒谬" ;
lin abulia_N = mkN "丧志症" | mkN "意志力丧失" | mkN "意志缺失" ; -- open-multilingual-wordnet
lin abulic_A = mkA "意志缺失" ; -- open-multilingual-wordnet
lin abundant_A = mkA "丰富" | {-HSK-} mkA "充分" ;
lin abuse_N = mkN "滥用" | {-HSK-} mkN "骂" "通" ;
lin abuse_V2 = mkV2 "虐待" ;
lin abuser_N = mkN "滥用权利者" | mkN "虐待者" ; -- open-multilingual-wordnet
lin abusive_A = mkA "滥用" ;
lin abutment_N = mkN "拱座" | mkN "支墩" | mkN "支座" | mkN "桥台" | mkN "桥礅" ; -- open-multilingual-wordnet
lin abutter_N = mkN "相邻房地产的业主" ; -- open-multilingual-wordnet
lin abuzz_A = mkA "嗡嗡" ; -- open-multilingual-wordnet
lin abvolt_N = mkN "电磁伏特" ; -- open-multilingual-wordnet
lin abwatt_N = mkN "电瓷瓦" | mkN "电磁瓦特" ; -- open-multilingual-wordnet
lin abysm_N = mkN "无底洞" | mkN "深渊" ; -- open-multilingual-wordnet
lin abysmal_A = mkA "无底" | mkA "深不可测" ; -- open-multilingual-wordnet
lin abyss_N = mkN "深淵" | mkN "深渊" | {-mwn-} mkN "无底洞" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin academia_N = mkN "学术界" ; -- open-multilingual-wordnet
lin academic_A = mkA "学术" | {-HSK-} mkA "学者" ;
lin academic_N = mkN "学术" "個" | {-HSK-} mkN "学者" "位" ;
lin academicianFem_N = mkN "专科院校的" | mkN "专科院校的教育者" | mkN "学会会员" ; -- open-multilingual-wordnet
lin academicianMasc_N = mkN "专科院校的" | mkN "专科院校的教育者" | mkN "学会会员" ; -- open-multilingual-wordnet
lin academy_N = mkN "学院" ;
lin acanthocephalan_N = mkN "棘头虫" | mkN "棘头虫纲" ; -- open-multilingual-wordnet
lin acanthocytosis_N = mkN "棘形红细胞症" ; -- open-multilingual-wordnet
lin acanthoid_A = mkA "刺状" ; -- open-multilingual-wordnet
lin acantholysis_N = mkN "棘层松解" ; -- open-multilingual-wordnet
lin acanthoma_N = mkN "棘质瘤" ; -- open-multilingual-wordnet
lin acanthosis_N = mkN "棘层肥厚" ; -- open-multilingual-wordnet
lin acanthotic_A = mkA "棘皮症" ; -- open-multilingual-wordnet
lin acanthus_N = mkN "六角英" | mkN "大鸭草" | mkN "孩儿草" | mkN "小青草" | mkN "毛泽兰" | mkN "爵床" | mkN "节节寒" | mkN "茛苕" | mkN "赤眼老母草" | mkN "野万年青" | mkN "麦穗癀" | mkN "鼠尾癀" ; -- open-multilingual-wordnet
lin acapnic_A = mkA "缺碳酸血" ; -- open-multilingual-wordnet
lin acardia_N = mkN "无心畸形" ; -- open-multilingual-wordnet
lin acariasis_N = mkN "壁虱病" | mkN "螨病" ; -- open-multilingual-wordnet
lin acaricide_N = mkN "对二氯苯" | mkN "杀螨剂" ; -- open-multilingual-wordnet
lin acarid_N = mkN "螨" ; -- open-multilingual-wordnet
lin acarine_N = mkN "螨" ; -- open-multilingual-wordnet
lin acarophobia_N = mkN "螨恐怖" | mkN "螨虫恐怖症" ; -- open-multilingual-wordnet
lin acarpous_A = mkA "不结实" | mkA "无果实" ; -- open-multilingual-wordnet
lin acarus_N = mkN "壁虱" ; -- open-multilingual-wordnet
lin acathexia_N = mkN "排泄失禁" ; -- open-multilingual-wordnet
lin acathexis_N = mkN "不贯注" ; -- open-multilingual-wordnet
lin accede_V = mkV "加入" ;
lin accelerando_A = mkA "渐速" | mkA "逐渐加快" | mkA "速度渐快" ; -- open-multilingual-wordnet
lin accelerando_N = mkN "渐速乐段" | mkN "渐速音" | mkN "渐速音乐段" ; -- open-multilingual-wordnet
lin accelerate_V = mkV "加快" ;
lin accelerate_V2 = mkV2 "加速" ;
lin acceleration_N = mkN "加速" ;
lin accelerative_A = mkA "加快" | mkA "加速" ; -- open-multilingual-wordnet
lin accelerator_N = mkN "油门" ;
lin accelerometer_N = mkN "加速度测量仪" | mkN "加速计" ; -- open-multilingual-wordnet
lin accent_N = mkN "口音" "" ;
lin accentor_N = mkN "鸣禽" ; -- open-multilingual-wordnet
lin accentual_A = mkA "重音" ; -- open-multilingual-wordnet
lin accept_V = mkV "接受" | {-HSK-} mkV "收" ;
lin accept_V2 = mkV2 "接受" | {-HSK-} mkV2 "收" ;
lin accept_VS = mkVS "接受" | {-HSK-} mkVS "收" ;
lin acceptable_A = mkA "合适" ;
lin acceptance_N = mkN "接受" [] ;
lin acceptor_N = mkN "承兑人" ; -- open-multilingual-wordnet
lin access_N = mkN "接触" | {-HSK-} mkN "访问" ;
lin access_V2 = mkV2 "存取" ;
lin accessary_N = mkN "从犯" | mkN "同谋" ; -- open-multilingual-wordnet
lin accessible_A = mkA "易接近" ;
lin accessional_A = mkA "另外" | mkA "附加" ; -- open-multilingual-wordnet
lin accessorial_A = mkA "增补" | mkA "补充" | mkA "辅助" | mkA "附属" ; -- open-multilingual-wordnet
lin accessory_A = mkA "补助" | mkA "辅助" | mkA "附件" | mkA "附属" ; -- open-multilingual-wordnet
lin accessory_N = mkN "附件" ;
lin accident_N = mkN "事故" | {-HSK-} mkN "意外" "個" ;
lin accidental_A = mkA "意外" ;
lin accidental_N = mkN "临时记号的音符" | mkN "临时音调" ; -- open-multilingual-wordnet
lin accipitrine_A = mkA "鹰科" ; -- open-multilingual-wordnet
lin acclaim_N = mkN "欢呼" [] ;
lin acclaim_V2 = mkV2 "称赞" ;
lin acclamation_N = mkN "喝彩" | mkN "拍手喝采" | mkN "欢呼" | mkN "称赞" | mkN "赞美" ; -- open-multilingual-wordnet
lin acclimation_N = mkN "服习" | mkN "服水土" | mkN "环境适应性" | mkN "适应气候" | mkN "适应环境" | mkN "顺应" ; -- open-multilingual-wordnet
lin acclimatization_N = mkN "服习" | mkN "服水土" | mkN "环境适应性" | mkN "适应气候" | mkN "适应环境" | mkN "顺应" ; -- open-multilingual-wordnet
lin acclivitous_A = mkA "上坡" | mkA "上斜" ; -- open-multilingual-wordnet
lin acclivity_N = mkN "向上的斜坡" | mkN "斜坡" | mkN "高地" ; -- open-multilingual-wordnet
lin accolade_N = mkN "荣誉" ;
lin accommodate_V = mkV "容纳" ;
lin accommodate_V2 = mkV2 "容纳" ;
lin accommodation_N = mkN "住处" ; -- comment="膳宿" ;
lin accommodational_A = mkA "适应性调节" ; -- open-multilingual-wordnet
lin accompaniment_N = mkN "伴奏" "次" ;
lin accompanist_N = mkN "伴奏者" ;
lin accompany_V2 = mkV2 "陪" | {-HSK-} mkV2 "陪伴" ;
lin accomplice_N = mkN "幫兇" | mkN "帮凶" | {-mwn-} mkN "共犯" | mkN "同谋" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin accomplish_V2 = mkV2 "完成" | {-HSK-} mkV2 "就" ;
lin accomplishable_A = mkA "可达成" ;
lin accomplishment_N = mkN "作为" | mkN "成就" "個" | {-HSK-} mkN "成就" ;
lin accord_N = mkN "和谐" ;
lin accord_V = mkV "符合" ;
lin accordance_N = {-mwn-} mkN "授予权利" ; -- open-multilingual-wordnet
lin according_to_Prep = mkPrep "根据" ;
lin accordingly_Adv = mkAdv "因此" ;
lin accordion_N = mkN "手風琴" | mkN "手风琴" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin accordionist_N = mkN "手风琴师" ; -- open-multilingual-wordnet
lin accouchement_N = mkN "出生" | mkN "分娩" | mkN "娩" | mkN "生产" ; -- open-multilingual-wordnet
lin account_N = mkN "叙述" | {-HSK-} mkN "账户" ;
lin account_V = mkV "认为" ;
lin account_V2 = mkV2 "报账" ;
lin account_for_V2 = mkV2 "解释" ;
lin accountability_N = mkN "问责" "项" ;
lin accountable_A = mkA "有责任" ;
lin accountancy_N = mkN "会计" | {-mwn-} mkN "会计工作" | mkN "会计职业" ; -- open-multilingual-wordnet
lin accountant_N = mkN "会计" ;
lin accountantship_N = mkN "会计职务" ; -- open-multilingual-wordnet
lin accounting_A = {-HSK-} mkA "会计" ;
lin accounting_N = mkN "会计" ;
lin accoutered_A = mkA "供以军用品" | mkA "供以服装" | mkA "装备" | mkA "配备" ; -- open-multilingual-wordnet
lin accra_PN = mkPN "阿克拉" ; -- comment=src=geonames status=guess
lin accreditation_N = mkN "鉴定" ; -- open-multilingual-wordnet
lin accretionary_A = mkA "生长" ; -- open-multilingual-wordnet
lin accretive_A = mkA "生长" ; -- open-multilingual-wordnet
lin accrington_PN = mkPN "阿克寧頓" ; -- comment=src=geonames status=guess
lin accrue_V = mkV "累计" ;
lin accrue_V2 = mkV2 "累计" ;
lin acculturational_A = mkA "文化适应" ; -- open-multilingual-wordnet
lin accumbent_A = mkA "横卧" ; -- open-multilingual-wordnet
lin accumulate_V = mkV "积累" ;
lin accumulate_V2 = mkV2 "积累" | {-HSK-} mkV2 "攒" ;
lin accumulation_N = mkN "积累" | {-HSK-} mkN "积聚" ; -- comment="累积" ;
lin accumulator_N = mkN "储蓄器" | mkN "加法器" | mkN "累加器" ; -- open-multilingual-wordnet
lin accuracy_N = mkN "精度" "" ;
lin accurate_A = mkA "准确" ;
lin accusation_N = mkN "指控" ;
lin accusative_A = mkA "宾格" ; -- open-multilingual-wordnet
lin accusative_N = mkN "賓格" | mkN "宾格" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin accusatorial_A = mkA "控告" ; -- open-multilingual-wordnet
lin accuse_V2 = mkV2 "指控" ;
lin accused_A = variants {} ;
lin accused_N = mkN "被告" ; -- open-multilingual-wordnet
lin accuserFem_N = mkN "原告" ;
lin accuserMasc_N = mkN "原告" ;
lin accustom_V2 = mkV2 "习惯于" ; -- comment=[mark]使习惯于
lin ace_N = mkN "高手" ;
lin acephalia_N = mkN "无头亚目" ; -- open-multilingual-wordnet
lin acephalous_A = mkA "无头" | mkA "群龙无首" ; -- open-multilingual-wordnet
lin acerate_A = mkA "针状" ; -- open-multilingual-wordnet
lin acerola_N = mkN "西印度櫻桃" | mkN "西印度樱桃" | mkN "阿西羅拉" | mkN "阿西罗拉" | mkN "巴貝多櫻桃" | mkN "巴贝多樱桃" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin acervate_A = mkA "丛生" | mkA "成串密生" | mkA "成堆生长" | mkA "簇生" | mkA "聚生" ; -- open-multilingual-wordnet
lin acervulus_N = mkN "分生孢子层" | mkN "分生孢子盘" ; -- open-multilingual-wordnet
lin acetabulum_N = mkN "关节窝" | mkN "髋臼" ; -- open-multilingual-wordnet
lin acetaldehyde_N = mkN "乙醛" ; -- status=guess
lin acetaldol_N = mkN "醋酰胺胂" ; -- open-multilingual-wordnet
lin acetamide_N = mkN "乙酰胺" ; -- open-multilingual-wordnet
lin acetanilide_N = mkN "乙酰苯胺" | mkN "止痛或退热剂" | mkN "退热冰" ; -- open-multilingual-wordnet
lin acetate_N = mkN "醋酸盐" ;
lin acetic_A = mkA "醋酸" ; -- open-multilingual-wordnet
lin acetone_N = mkN "丙酮" ; -- status=guess -- open-multilingual-wordnet
lin acetonic_A = mkA "丙酮" ; -- open-multilingual-wordnet
lin acetophenetidin_N = mkN "乙酰氧乙苯胺" | mkN "非那西丁" ; -- open-multilingual-wordnet
lin acetose_A = mkA "似醋" | mkA "像醋" | mkA "像醋一样酸" | mkA "酸" ; -- open-multilingual-wordnet
lin acetyl_N = mkN "乙酰基" | mkN "醋酸基" ; -- open-multilingual-wordnet
lin acetylation_N = mkN "乙酰化作用" | mkN "乙酰取代作用" ; -- open-multilingual-wordnet
lin acetylcholine_N = mkN "乙酰胆碱" | mkN "醋胆素" ; -- open-multilingual-wordnet
lin acetylene_N = mkN "乙炔" ;
lin acetylenic_A = mkA "炔" | mkA "炔属" ; -- open-multilingual-wordnet
lin acetylic_A = mkA "乙酰基群" ; -- open-multilingual-wordnet
lin ache_N = mkN "疼" | mkN "酸" | {-HSK-} mkN "疼痛""" ;
lin ache_V = mkV "渴望" ;
lin achene_N = mkN "瘦果" ; -- open-multilingual-wordnet
lin achenial_A = mkA "瘦果" ; -- open-multilingual-wordnet
lin achievability_N = mkN "可达到" | mkN "成就感" | mkN "所及" ; -- open-multilingual-wordnet
lin achievable_A = mkA "实现" ;
lin achieve_V2 = mkV2 "实现" | mkV2 "达到" ;
lin achievement_N = mkN "作为" | mkN "成就" "個" | mkN "成果" "個" | mkN "成绩" "項" | {-HSK-} mkN "成就" ;
lin achiever_N = mkN "成功人士" | mkN "有成就的人" ; -- open-multilingual-wordnet
lin achillea_N = mkN "蓍草属" ; -- open-multilingual-wordnet
lin achilles_PN = foreignPN "Achilles" ; -- comment=src=eng status=guess
lin achimenes_N = mkN "长筒花" ; -- open-multilingual-wordnet
lin achlamydeous_A = mkA "无花被" ; -- open-multilingual-wordnet
lin achlorhydria_N = mkN "胃酸缺乏" | mkN "胃酸缺乏症" ; -- open-multilingual-wordnet
lin achlorhydric_A = mkA "盐酸缺乏" ; -- open-multilingual-wordnet
lin achondrite_N = mkN "无球粒陨石" ; -- open-multilingual-wordnet
lin achondroplasia_N = mkN "软骨发育不全" ; -- open-multilingual-wordnet
lin achondroplastic_A = mkA "软骨发育不全" ; -- open-multilingual-wordnet
lin achromatic_A = mkA "无色" | mkA "无色彩" | mkA "非彩色" ; -- open-multilingual-wordnet
lin achromatinic_A = mkA "非染色质" ; -- open-multilingual-wordnet
lin achromatous_A = mkA "无色" | mkA "淡色" ; -- open-multilingual-wordnet
lin achromic_A = mkA "无色" | mkA "色素缺乏" | mkA "色素缺少" ; -- open-multilingual-wordnet
lin achylia_N = mkN "消化液缺乏" | mkN "胃液缺乏" ; -- open-multilingual-wordnet
lin acicula_N = mkN "刺" | mkN "针" ; -- open-multilingual-wordnet
lin aciculate_A = mkA "有刺" ; -- open-multilingual-wordnet
lin acid_A = mkA "酸" ;
lin acid_N = mkN "酸" ;
lin acidemia_N = mkN "酸血" | mkN "酸血症" ; -- open-multilingual-wordnet
lin acidification_N = mkN "酸化" ; -- status=guess
lin acidify_V = mkV "使+成酸" ;
lin acidify_V2 = mkV2 (mkV "酸化") ; -- status=guess, src=wikt
lin acidimetric_A = mkA "酸量滴定" ; -- open-multilingual-wordnet
lin acidimetry_N = mkN "酸定量法" | mkN "酸量滴定法" ; -- open-multilingual-wordnet
lin acidity_N = mkN "酸性" | mkN "酸度" ; -- status=guess -- status=guess
lin acidophil_N = mkN "嗜酸菌" ; -- open-multilingual-wordnet
lin acidotic_A = mkA "酸中毒" ;
lin ackee_N = mkN "西非荔枝果" | mkN "阿开木果" ; -- open-multilingual-wordnet
lin acknowledge_V2 = mkV2 "承认" ;
lin acknowledge_VS = mkVS "确认" ;
lin acknowledgeable_A = mkA "有知识" ; -- open-multilingual-wordnet
lin acknowledgement_N = mkN "承认" | mkN "感谢" | mkN "致謝" ; -- open-multilingual-wordnet
lin acne_N = mkN "痤疮" ;
lin acneiform_A = mkA "痤疮样" ; -- open-multilingual-wordnet
lin acold_A = mkA "寒冷" ; -- open-multilingual-wordnet
lin acolyte_N = mkN "侍僧" ; -- open-multilingual-wordnet
lin aconite_N = mkN "乌头" ; -- open-multilingual-wordnet
lin acorea_N = mkN "无瞳" | mkN "无瞳孔" ; -- open-multilingual-wordnet
lin acorn_N = mkN "橡子" ;
lin acoustic_A = mkA "听觉" | mkA "声学" | mkA "音质" ; -- open-multilingual-wordnet
lin acoustic_N = mkN "原聲吉他" | mkN "原声吉他" | mkN "木吉他" | {-mwn-} mkN "医治耳聋的药" | mkN "听觉的治疗" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin acoustician_N = mkN "声学家" ; -- open-multilingual-wordnet
lin acoustics_N = mkN "声学" ; -- open-multilingual-wordnet
lin acquaint_V2 = mkV2 "告知" ;
lin acquaintance_N = {-mwn-} mkN "了解" | mkN "熟悉" | mkN "精通" | mkN "认识" ; -- open-multilingual-wordnet
lin acquaintanceship_N = mkN "了解" | mkN "相识" | mkN "知道" | mkN "认识" ; -- open-multilingual-wordnet
lin acquiesce_V = mkV "默许" ;
lin acquiescence_N = mkN "赞同" ; -- open-multilingual-wordnet
lin acquiescent_A = mkA "服从" | mkA "顺从" | mkA "驯服" ; -- open-multilingual-wordnet
lin acquire_V2 = mkV2 "养成" | {-HSK-} mkV2 "获得" ;
lin acquirement_N = mkN "成就" | mkN "技能" | mkN "技艺" ; -- open-multilingual-wordnet
lin acquisition_N = mkN "获得" ;
lin acquisitive_A = mkA "贪得" ;
lin acquit_V2 = mkV2 "无罪释放" ;
lin acquittal_N = mkN "无罪" ;
lin acquittance_N = mkN "清还证明书" ; -- open-multilingual-wordnet
lin acre_N = mkN "英亩" ;
lin acrimonious_A = mkA "严厉" ;
lin acrimony_N = mkN "严苛" ;
lin acritical_A = mkA "不危急" | mkA "不危险" ; -- open-multilingual-wordnet
lin acroanesthesia_N = mkN "冷觉缺失" ; -- open-multilingual-wordnet
lin acrobatFem_N = mkN "杂技演员" | mkN "表演特技者" | mkN "马戏演员" ; -- open-multilingual-wordnet
lin acrobatMasc_N = mkN "杂技演员" | mkN "表演特技者" | mkN "马戏演员" ; -- open-multilingual-wordnet
lin acrobatics_N = mkN "雜技" | mkN "杂技" ; -- status=guess -- status=guess
lin acrocarp_N = mkN "顶苞苔" ; -- open-multilingual-wordnet
lin acrocarpous_A = mkA "茎端结实" | mkA "顶生蒴" | mkA "顶苞" ; -- open-multilingual-wordnet
lin acrocentric_A = mkA "近端着丝" ; -- open-multilingual-wordnet
lin acrodont_N = mkN "端生齿的动物" | mkN "边齿的动物" | mkN "颌缘牙" ; -- open-multilingual-wordnet
lin acrogen_N = mkN "頂生植物" | {-mwn-} mkN "顶生植物" ; -- status=guess -- open-multilingual-wordnet
lin acrogenic_A = mkA "顶生" ; -- open-multilingual-wordnet
lin acromegalic_A = mkA "肢端肥大" | mkA "肢端肥大症" ; -- open-multilingual-wordnet
lin acromegaly_N = mkN "肢端肥大癥" | mkN "肢端肥大症" | mkN "zhī duān féi dà zhèng" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin acromicria_N = mkN "肢端过小症" ; -- open-multilingual-wordnet
lin acromion_N = mkN "肩峰" ; -- status=guess
lin acromphalus_N = mkN "脐膨出" ; -- open-multilingual-wordnet
lin acromyotonia_N = mkN "肢肌强直" ; -- open-multilingual-wordnet
lin acronym_N = mkN "缩写" ;
lin acronymic_A = mkA "首字母缩写" ; -- open-multilingual-wordnet
lin acrophobia_N = mkN "懼高症" | {-mwn-} mkN "恐高症" ; -- status=guess -- open-multilingual-wordnet
lin acrophony_N = mkN "截头表音法" | mkN "顶音法" ; -- open-multilingual-wordnet
lin acropolis_N = mkN "卫城" ; -- open-multilingual-wordnet
lin acroscopic_A = mkA "上侧" ; -- open-multilingual-wordnet
lin across_Adv = mkAdv "横" | {-HSK-} mkAdv "横过" ;
lin across_Prep = mkPrep "穿过" ;
lin acrostic_N = mkN "离合诗" | mkN "藏头诗" ; -- open-multilingual-wordnet
lin acrylamide_N = mkN "丙烯醯胺" | {-mwn-} mkN "丙烯酰胺" ; -- status=guess -- open-multilingual-wordnet
lin acrylic_N = mkN "腈纶" ; -- status=guess
lin act_N = mkN "法案" ;
lin act_V = mkV "举" | mkV "表演" | {-HSK-} mkV "作为" ;
lin act_V2 = mkV2 "举" | mkV2 "表演" | {-HSK-} mkV2 "作为" ;
lin act_on_V2 = mkV2 "作用" | mkV2 "批" ;
lin act_out_V2 = prepV2 OP_act_V OP_out_Prep ; -- guess-p-verb
lin act_up_V = advV OP_act_V OP_up_Adv ; -- guess-p-verb
lin act_upon_V2 = prepV2 OP_act_V OP_upon_Prep ; -- guess-p-verb
lin actable_A = mkA "能演出" ; -- open-multilingual-wordnet
lin actin_N = mkN "肌动蛋白" ; -- open-multilingual-wordnet
lin actinal_A = mkA "口侧" ; -- open-multilingual-wordnet
lin acting_A = mkA "代理" | mkA "代-" ; -- status=guess -- status=guess
lin actinia_N = mkN "海葵" | mkN "海葵目" ; -- open-multilingual-wordnet
lin actinic_A = mkA "光化学" ; -- open-multilingual-wordnet
lin actinium_N = mkN "錒" | mkN "锕" ; -- status=guess -- status=guess
lin actinoid_A = mkA "放射线状" ; -- open-multilingual-wordnet
lin actinoid_N = mkN "锕类" ; -- open-multilingual-wordnet
lin actinolite_N = mkN "阳起石" ; -- open-multilingual-wordnet
lin actinometer_N = mkN "光化线强度计" | mkN "光能测定仪" | mkN "日射强度表" | mkN "暴光表" | mkN "暴光计" | mkN "露光计" ; -- open-multilingual-wordnet
lin actinometric_A = mkA "光量测定" ; -- open-multilingual-wordnet
lin actinometry_N = mkN "光量测定" | mkN "辐射测量学" ; -- open-multilingual-wordnet
lin actinomorphic_A = mkA "放射状" ; -- open-multilingual-wordnet
lin actinomyces_N = mkN "放线菌" ; -- open-multilingual-wordnet
lin actinomycetal_A = mkA "放线菌类" ; -- open-multilingual-wordnet
lin actinomycete_N = mkN "放线菌" ; -- open-multilingual-wordnet
lin actinomycin_N = mkN "放线菌素" ; -- open-multilingual-wordnet
lin actinomycosis_N = mkN "放线菌病" ; -- open-multilingual-wordnet
lin actinomycotic_A = mkA "放射菌病" ; -- open-multilingual-wordnet
lin actinomyxidian_N = mkN "放射孢子目" | mkN "放射孢子虫" ; -- open-multilingual-wordnet
lin action_N = mkN "了" | mkN "作用" | mkN "动作" "個" | mkN "行为" | mkN "行动" "個" | mkN "过" ;
lin actionable_A = mkA "可控告" ;
lin activate_V2 = mkV2 "激活" ;
lin active_A = mkA "主动" | mkA "活动" | mkA "活泼" | mkA "活跃" | mkA "积极" ;
lin active_N = mkN "主动" | mkN "活动" "項" | mkN "活泼" | mkN "活跃" | mkN "积极" | {-HSK-} mkN "活動星系核" | mkN "活动星系核" ; -- status=guess -- status=guess
lin activeness_N = mkN "活跃性" | mkN "积极性" ; -- open-multilingual-wordnet
lin activism_N = mkN "激进主义" ; -- open-multilingual-wordnet
lin activistFem_N = mkN "活动家" ;
lin activistMasc_N = mkN "活动家" ;
lin activity_N = mkN "作为" | mkN "作用" | mkN "活动" "項" | mkN "生活" | mkN "行为" | {-HSK-} mkN "活动" ;
lin actomyosin_N = mkN "肌动球蛋白" | mkN "肌纤凝蛋白" ; -- open-multilingual-wordnet
lin actor_1_N = {-mwn-} mkN "演员" | mkN "演奏者" | mkN "艺人" ; -- open-multilingual-wordnet
lin actor_2_N = {-mwn-} mkN "演员" | mkN "演奏者" | mkN "艺人" ; -- open-multilingual-wordnet
lin actor_N = mkN "演员" ;
lin actress_N = mkN "女演员" "位" ;
lin actual_A = mkA "实际" | {-HSK-} mkA "现实" ;
lin actuality_N = mkN "现实" | {-HSK-} mkN "现实" "個" ;
lin actually_Adv = mkAdv "其实" | mkAdv "原来" | mkAdv "所" | mkAdv "究竟" | mkAdv "竟然" | {-HSK-} mkAdv "实际" mannerAdvType | adjAdv actual_A ; -- derived
lin actuarial_A = mkA "保险精算" ;
lin actuary_N = mkN "保险精算师" ;
lin actuate_V2 = mkV2 "促使" ;
lin actuator_N = mkN "致动器" ; -- status=guess
lin acuate_A = mkA "敏锐" | mkA "机警" | mkA "针状" ; -- open-multilingual-wordnet
lin acuity_N = mkN "敏锐" | mkN "激烈" | mkN "锐利" ; -- open-multilingual-wordnet
lin aculea_N = mkN "微刺" ; -- open-multilingual-wordnet
lin aculeate_A = mkA "有刺" ; -- open-multilingual-wordnet
lin aculeus_N = mkN "刺" | mkN "螫刺" ; -- open-multilingual-wordnet
lin acumen_N = mkN "慧眼" | mkN "精明" | mkN "敏銳" | mkN "敏锐" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin acuminate_A = mkA "尖形" | mkA "渐尖" ; -- open-multilingual-wordnet
lin acupuncture_N = mkN "針灸" | mkN "针灸" | mkN "針術" | mkN "针术" | {-mwn-} mkN "针刺疗法" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin acute_A = mkA "尖锐" | mkA "激烈" | {-HSK-} mkA "急性" ;
lin acyclic_A = mkA "无环" ; -- open-multilingual-wordnet
lin acyl_N = mkN "酰基" ; -- open-multilingual-wordnet
lin acylation_N = mkN "酰化" | mkN "酰化作用" ; -- open-multilingual-wordnet
lin ad_N = mkN "广告" ;
lin ad_PN = foreignPN "Ad" ; -- comment=src=eng status=guess
lin ad_hoc_A = mkA "临时" ;
lin ad_hoc_Adv = mkAdv "临时" ;
lin ada_PN = mkPN "阿達" ; -- comment=src=geonames status=guess
lin adactylia_N = mkN "缺指" ; -- open-multilingual-wordnet
lin adactylous_A = mkA "无指" | mkA "无指无趾" | mkA "无趾" ; -- open-multilingual-wordnet
lin adam_PN = foreignPN "Adam" ; -- comment=src=eng status=guess
lin adamant_A = mkA "固执" ;
lin adamant_N = mkN "金刚石" | mkN "钻石" ; -- open-multilingual-wordnet
lin adapt_V = mkV "适应" ;
lin adapt_V2 = mkV2 "适应" ;
lin adaptable_A = mkA "能适应" ;
lin adaptation_N = mkN "适应" ;
lin adapter_N = mkN "适配器" ;
lin adaptor_N = mkN "適配器" | mkN "适配器" | {-mwn-} mkN "接合器" | mkN "转接器" | mkN "适应物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin adaxial_A = mkA "近轴" ; -- open-multilingual-wordnet
lin add_V = mkV "添加" ;
lin add_V2 = mkV2 "添加" ;
lin add_V3 = L.add_V3 ;
lin add_VS = mkVS "添加" ;
lin add_in_V = advV OP_add_V OP_in_Adv ; -- guess-p-verb
lin add_on_to_V2 = prepV2 OP_add_V OP_on_Prep ; -- guess-p-verb
lin add_up_V = advV OP_add_V OP_up_Adv ; -- guess-p-verb
lin add_up_V2 = prepV2 OP_add_V OP_up_Prep ; -- guess-p-verb
lin add_up_to_V2 = prepV2 (advV OP_add_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin added_A = variants {} ;
lin addend_N = mkN "加數" | mkN "加数" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin addendum_N = mkN "附录" ; -- open-multilingual-wordnet
lin adder_N = mkN "毒蛇" | mkN "蝰蛇" ; -- status=guess -- status=guess
lin addict_N = mkN "瘾君子" ;
lin addict_V2 = mkV2 "上瘾" ;
lin addiction_N = mkN "瘾" ;
lin addictive_A = mkA "上瘾" ;
lin addis_ababa_PN = foreignPN "Addis Ababa" ; -- comment=src=geonames status=guess
lin addition_N = mkN "增加" ;
lin additional_A = mkA "另外" | mkA "补充" | {-HSK-} mkA "额外" ;
lin additionally_Adv = mkAdv "並且" | mkAdv "并且" | mkAdv "而且" | mkAdv "還有" | mkAdv "还有" | mkAdv "況且" | mkAdv "况且" | adjAdv additional_A ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- derived -- derived
lin additive_N = mkN "附加剂" ;
lin address_N = mkN "地址" | {-HSK-} mkN "地址" "個" ;
lin address_V2 = mkV2 "地址" ;
lin addressee_N = mkN "收件人" | {-mwn-} mkN "受信人" ; -- status=guess -- open-multilingual-wordnet
lin adducent_A = mkA "使内收" | mkA "使并拢" | mkA "内敛" ; -- open-multilingual-wordnet
lin adducer_N = mkN "论证者" ; -- open-multilingual-wordnet
lin adducing_N = mkN "引证" ; -- open-multilingual-wordnet
lin adduct_N = mkN "加合物" ; -- open-multilingual-wordnet
lin adelaide_PN = mkPN "阿德莱德" ; -- comment=src=geonames status=guess
lin adelgid_N = mkN "球蚜" ; -- open-multilingual-wordnet
lin adenine_N = mkN "腺嘌呤" ; -- status=guess
lin adenitis_N = mkN "淋巴腺炎" | mkN "腺炎" ; -- open-multilingual-wordnet
lin adenocarcinoma_N = mkN "腺癌" ; -- open-multilingual-wordnet
lin adenocarcinomatous_A = mkA "腺癌" ; -- open-multilingual-wordnet
lin adenoidal_A = mkA "腺状" | mkA "腺状肿" ; -- open-multilingual-wordnet
lin adenoidectomy_N = mkN "增殖腺切除术" ; -- open-multilingual-wordnet
lin adenoma_N = mkN "腺瘤" ; -- status=guess -- open-multilingual-wordnet
lin adenomegaly_N = mkN "腺体增大" | mkN "腺节" ; -- open-multilingual-wordnet
lin adenopathy_N = mkN "腺病" ; -- open-multilingual-wordnet
lin adenosine_N = mkN "腺嘌呤核苷" | mkN "腺苷" ; -- open-multilingual-wordnet
lin adenovirus_N = mkN "腺病毒" ; -- open-multilingual-wordnet
lin adept_A = mkA "娴熟" ;
lin adept_N = mkN "内行" ;
lin adeptness_N = mkN "灵巧" | mkN "熟练" ; -- open-multilingual-wordnet
lin adequacy_N = mkN "足够" ;
lin adequate_A = mkA "充足" ;
lin adhere_V = mkV "粘贴" | {-HSK-} mkV "遵守" ;
lin adhesive_A = mkA "胶粘剂" ;
lin adhesive_N = mkN "胶粘剂" ;
lin adiabatic_A = mkA "絕熱" | {-mwn-} mkA "绝热" | mkA "隔热" ; -- status=guess -- open-multilingual-wordnet
lin adience_N = mkN "接近" | mkN "趋向" ; -- open-multilingual-wordnet
lin adient_A = mkA "趋近" ; -- open-multilingual-wordnet
lin adieu_N = mkN "告别" "次" ;
lin adipose_A = mkA "动物脂肪" ; -- open-multilingual-wordnet
lin adit_N = mkN "平峒" | mkN "排水平峒" ; -- open-multilingual-wordnet
lin adjacent_A = mkA "相邻" ;
lin adjective_N = mkN "形容词" ;
lin adjoin_V = mkV "毗临" ;
lin adjourn_V = mkV "休会" | mkV "休庭" ; -- open-multilingual-wordnet
lin adjourn_V2 = mkV2 "休会" ;
lin adjournment_N = mkN "休会期" "" ;
lin adjudication_N = mkN "裁定" ; -- open-multilingual-wordnet
lin adjudicative_A = mkA "判决" | mkA "审判" | mkA "裁决" ; -- open-multilingual-wordnet
lin adjudicator_N = mkN "评判员" ;
lin adjunct_N = mkN "修饰成分" | mkN "修饰语" ; -- open-multilingual-wordnet
lin adjunctive_A = mkA "附属" ; -- open-multilingual-wordnet
lin adjuration_N = mkN "恳请" ; -- open-multilingual-wordnet
lin adjust_V = mkV "调整" ;
lin adjust_V2 = mkV2 "调整" ;
lin adjustable_A = mkA "可调整" ;
lin adjuster_N = mkN "调节器" ;
lin adjustment_N = mkN "调整" | {-HSK-} mkN "调整" "個" ;
lin adjutant_N = mkN "副官" | mkN "助手" ; -- open-multilingual-wordnet
lin adjuvant_A = mkA "辅助" | mkA "辅药" ; -- open-multilingual-wordnet
lin adjuvant_N = mkN "佐剂" ; -- open-multilingual-wordnet
lin admass_N = mkN "易受大众传播影响的群众" ; -- open-multilingual-wordnet
lin administer_V = mkV "管理" | {-HSK-} mkV "给予帮助" ;
lin administer_V2 = mkV2 "管理" ;
lin administrable_A = mkA "可管理" ; -- open-multilingual-wordnet
lin administration_N = mkN "管理" | {-HSK-} mkN "管理" "個" ;
lin administrative_A = mkA "行政" ;
lin administratorFem_N = mkN "管理员" ;
lin administratorMasc_N = mkN "管理员" ;
lin admirable_A = mkA "令人钦佩" ;
lin admiral_N = mkN "海军上将" ;
lin admiralty_N = mkN "海商法" ; -- status=guess -- status=guess
lin admiration_N = {-mwn-} mkN "赞赏" ; -- open-multilingual-wordnet
lin admire_V2 = mkV2 "欣赏" | mkV2 "羡慕" ;
lin admirer_N = mkN "崇拜者" ;
lin admissible_A = mkA "可容许" ;
lin admission_N = mkN "承认" [] ;
lin admit_V = mkV "承认" ;
lin admit_V2 = mkV2 "承认" ;
lin admit_VS = mkVS "承认" ;
lin admittance_N = mkN "招收" | mkN "接受" | mkN "接纳" ; -- open-multilingual-wordnet
lin admittedly_Adv = mkAdv "固然" ;
lin admix_V = mkV "掺和" | mkV "混合" ; -- open-multilingual-wordnet
lin admixture_N = mkN "混合" | mkN "混合物" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin admonish_V2 = mkV2 (mkV "告誡") | mkV2 (mkV "告诫") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin admonisher_N = mkN "告诫者" | mkN "提醒者" ; -- open-multilingual-wordnet
lin admonition_N = mkN "训诫" ;
lin admonitory_A = mkA "训诫" | mkA "责备" ; -- open-multilingual-wordnet
lin adnate_A = mkA "并生" | mkA "联生" | mkA "贴生" ; -- open-multilingual-wordnet
lin adnexal_A = mkA "附件" | mkA "附属" ; -- open-multilingual-wordnet
lin adnoun_N = mkN "名形词" ; -- open-multilingual-wordnet
lin ado_N = mkN "忙乱" ;
lin adobe_N = mkN "泥砖" | mkN "风干土坯" | mkN "风干砖坯" ; -- open-multilingual-wordnet
lin adolescent_A = mkA "青少年" ;
lin adolescent_N = mkN "青少年" ;
lin adopt_V2 = mkV2 "通过" | {-HSK-} mkV2 "采用" ;
lin adoptee_N = mkN "养子" | {-mwn-} mkN "被收养者" ; -- status=guess -- open-multilingual-wordnet
lin adoption_N = mkN "采纳" [] ;
lin adoptive_A = mkA "收养" ;
lin adorable_A = mkA "可愛" | mkA "可爱" ; -- status=guess -- status=guess
lin adore_V2 = mkV2 "热爱" | {-HSK-} mkV2 (mkV "熱愛") | mkV2 (mkV "热爱") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin adorer_N = mkN "仰慕者" | mkN "爱慕者" ; -- open-multilingual-wordnet
lin adorn_V2 = mkV2 "打扮" | mkV2 "装" | {-HSK-} mkV2 "装饰" ;
lin adornment_N = mkN "装" ;
lin adrenarche_N = mkN "肾上腺功能初现" ; -- open-multilingual-wordnet
lin adrenergic_A = mkA "肾上腺素能" ; -- open-multilingual-wordnet
lin adrenocortical_A = mkA "促肾上腺皮质激素" ; -- open-multilingual-wordnet
lin adrenocorticotropic_A = mkA "促肾上腺皮质" ; -- open-multilingual-wordnet
lin adrenosterone_N = mkN "肾上腺甾酮" ; -- open-multilingual-wordnet
lin adrian_PN = foreignPN "Adrian" ; -- comment=src=geonames status=guess
lin adroit_A = mkA "敏捷" ;
lin adroitness_N = mkN "灵巧" | mkN "熟练" ; -- open-multilingual-wordnet
lin adscript_A = mkA "后记" ; -- open-multilingual-wordnet
lin adsorbate_N = mkN "吸附物" | mkN "被吸附物" ; -- open-multilingual-wordnet
lin adsorbent_A = mkA "易吸附" | mkA "能吸附" | mkA "表面易吸附" ; -- open-multilingual-wordnet
lin adsorbent_N = mkN "吸附剂" | mkN "吸附物质" ; -- open-multilingual-wordnet
lin adsorption_N = mkN "吸附" | mkN "吸附作用" | mkN "表面吸收" ; -- open-multilingual-wordnet
lin adulation_N = mkN "谄媚" ; -- open-multilingual-wordnet
lin adulatory_A = mkA "谄媚" | mkA "阿谀" ; -- open-multilingual-wordnet
lin adult_A = mkA "成人" ;
lin adult_N = mkN "成人" ;
lin adulterant_N = mkN "掺杂剂" | mkN "掺杂物" ; -- open-multilingual-wordnet
lin adulterate_A = mkA "搀杂" ; -- open-multilingual-wordnet
lin adulterating_A = mkA "掺杂" ; -- open-multilingual-wordnet
lin adulterer_N = mkN "奸夫" | mkN "奸妇" | mkN "私通者" ; -- open-multilingual-wordnet
lin adulterine_A = mkA "私生子" | mkA "私通而生" ; -- open-multilingual-wordnet
lin adulterous_A = mkA "不贞" | mkA "通奸" ; -- open-multilingual-wordnet
lin adultery_N = mkN "通姦" | mkN "通奸" | mkN "奸情" | mkN "姦淫" | mkN "奸淫" | mkN "私通" | mkN "外遇" | mkN "不論之戀" | mkN "不论之恋" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin adulthood_N = mkN "成年" ; -- status=guess
lin adumbration_N = mkN "草图" | mkN "轮廓" ; -- open-multilingual-wordnet
lin adumbrative_A = mkA "伏笔" | mkA "预示" ; -- open-multilingual-wordnet
lin advance_N = mkN "推进" ;
lin advance_V = mkV "促进" | mkV "提前" | mkV "进" | mkV "进行" | {-HSK-} mkV "推进" ;
lin advance_V2 = mkV2 "促进" | mkV2 "提前" | mkV2 "进" | mkV2 "进行" | {-HSK-} mkV2 "推进" ;
lin advanced_A = {-HSK-} mkA "高级" ;
lin advancement_N = mkN "进步" ;
lin advancer_N = mkN "前进者" "个" ;
lin advantage_N = mkN "优势" | mkN "优点" "個" | mkN "好处" "個" | {-HSK-} mkN "优点" ;
lin advantage_V2 = mkV2 "使+处于优势" ;
lin advantageous_A = mkA "有利" ;
lin advection_N = mkN "平流" | mkN "水平对流" | mkN "移流" ; -- open-multilingual-wordnet
lin advective_A = mkA "平流" ; -- open-multilingual-wordnet
lin advent_N = mkN "出现" "" ;
lin adventistFem_N = variants {} ; ---- sense to be split
lin adventistMasc_N = variants {} ; ---- sense to be split
lin adventitial_A = mkA "外膜" ; -- open-multilingual-wordnet
lin adventitious_A = mkA "偶然" ; -- open-multilingual-wordnet
lin adventive_A = mkA "外来" | mkA "非土长" ; -- open-multilingual-wordnet
lin adventure_N = mkN "冒险" ;
lin adventurer_N = mkN "冒险者" ; -- open-multilingual-wordnet
lin adventuress_N = mkN "女冒险家" ; -- open-multilingual-wordnet
lin adventuristic_A = mkA "冒险主义" ; -- open-multilingual-wordnet
lin adverb_N = mkN "副詞" | mkN "副词" ; -- status=guess -- status=guess
lin adverbial_A = mkA "副词" ; -- open-multilingual-wordnet
lin adverbial_N = mkN "狀語" | mkN "状语" | mkN "副詞" | mkN "副词" | {-mwn-} mkN "副词的" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin adversary_N = mkN "对手" ;
lin adversative_A = mkA "反义" | mkA "相反" ; -- open-multilingual-wordnet
lin adverse_A = mkA "不利" ;
lin adversity_N = mkN "不幸" ; -- open-multilingual-wordnet
lin advert_N = mkN "广告" ;
lin advert_V = mkV "指" | mkV "提" | mkV "提到" | mkV "提及" | mkV "言及" ; -- open-multilingual-wordnet
lin advertence_N = mkN "注意" | mkN "留意" ; -- open-multilingual-wordnet
lin advertise_V = mkV "广告" ;
lin advertise_V2 = mkV2 "广告" ;
lin advertisement_N = mkN "广告" | {-HSK-} mkN "广告" "項" ;
lin advertiser_N = mkN "广告客户" ;
lin advertising_N = mkN "广告" ;
lin advertorial_N = mkN "社论式广告" ; -- open-multilingual-wordnet
lin advice_N = mkN "忠告" ;
lin advisable_A = mkA "明智" ; -- comment="可取" ;--"适当" ;
lin advise_V = mkV "劝" | {-HSK-} mkV "劝告" ;
lin advise_V2 = mkV2 "劝" | {-HSK-} mkV2 "劝告" ;
lin advise_VS = mkVS "劝" | {-HSK-} mkVS "建议" ;
lin advisee_N = mkN "被劝告者" ; -- open-multilingual-wordnet
lin adviserFem_N = mkN "顾问" ;
lin adviserMasc_N = mkN "顾问" ;
lin advisor_N = mkN "顧問" | mkN "顾问" ; -- status=guess -- status=guess
lin advisory_A = mkA "咨询" ;
lin advocacy_N = mkN "主张" ;
lin advocateFem_N = mkN "主张" ;
lin advocateMasc_N = mkN "主张" ;
lin advocate_V2 = mkV2 "主张" | {-HSK-} mkV2 "提倡" ;
lin advocate_VS = mkVS "主张" | {-HSK-} mkVS "提倡" ;
lin adz_N = mkN "扁斧" | mkN "手斧" | mkN "锛子" ; -- open-multilingual-wordnet
lin adze_N = mkN "錛子" | mkN "锛子" | {-mwn-} mkN "扁斧" | mkN "手斧" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aecial_A = mkA "孢子" ; -- open-multilingual-wordnet
lin aeciospore_N = mkN "锈孢子" ; -- open-multilingual-wordnet
lin aecium_N = mkN "锈子器" | mkN "锈孢子器" ; -- open-multilingual-wordnet
lin aegis_N = mkN "庇护" ;
lin aeolotropic_A = mkA "各向异性" | mkA "有方向性" ; -- open-multilingual-wordnet
lin aerate_V2 = mkV2 "使+充气" ;
lin aerator_N = mkN "充气器" | mkN "通气设备" ; -- open-multilingual-wordnet
lin aerial_A = mkA "空中" ;
lin aerial_N = mkN "天線" | mkN "天线" ; -- status=guess -- status=guess
lin aerialist_N = mkN "高空杂技师" ; -- open-multilingual-wordnet
lin aerides_N = mkN "指甲兰" ; -- open-multilingual-wordnet
lin aerie_N = mkN "巢" | mkN "雏" | mkN "高处的城堡" | mkN "高处的房子" ; -- open-multilingual-wordnet
lin aeriferous_A = mkA "传气" | mkA "输送空气" | mkA "送气" | mkA "通气" ; -- open-multilingual-wordnet
lin aeriform_A = mkA "幻想" | mkA "无实体" | mkA "空气状" | mkA "象空气" ; -- open-multilingual-wordnet
lin aerobe_N = mkN "好氧性生物" ; -- open-multilingual-wordnet
lin aerobiosis_N = mkN "好氧生活" | mkN "需氧生活" ; -- open-multilingual-wordnet
lin aerodontalgia_N = mkN "高空牙痛症" ; -- open-multilingual-wordnet
lin aerodrome_N = mkN "机场" | mkN "飞机场" ; -- open-multilingual-wordnet
lin aerodynamic_A = mkA "空气动力学" ;
lin aerodynamics_N = mkN "空气动力学" ; -- open-multilingual-wordnet
lin aerolite_N = mkN "陨石" ; -- open-multilingual-wordnet
lin aerolitic_A = mkA "陨石学" ; -- open-multilingual-wordnet
lin aerological_A = mkA "高空气象" ; -- open-multilingual-wordnet
lin aerology_N = mkN "高空气象学" ; -- open-multilingual-wordnet
lin aeromechanic_A = mkA "航空力学" ; -- open-multilingual-wordnet
lin aeromechanics_N = mkN "空气动力学" ; -- open-multilingual-wordnet
lin aeromedical_A = mkA "航空医学" ; -- open-multilingual-wordnet
lin aeromedicine_N = mkN "航空医学" ; -- open-multilingual-wordnet
lin aeronautical_A = mkA "航空" | mkA "航空学" ; -- open-multilingual-wordnet
lin aeronautics_N = mkN "航空學" | mkN "航空学" | mkN "航空術" | mkN "航空术" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin aerophagia_N = mkN "吞气症" ; -- open-multilingual-wordnet
lin aerophilatelic_A = mkA "航空邮票" | mkA "航空集邮" ; -- open-multilingual-wordnet
lin aerophilately_N = mkN "集航寄邮票" ; -- open-multilingual-wordnet
lin aerophile_N = mkN "热爱飞行者" ; -- open-multilingual-wordnet
lin aeroplane_N = mkN "飞机" ; -- open-multilingual-wordnet
lin aerosol_N = mkN "氣霧劑" | mkN "气雾剂" | mkN "氣溶膠" | mkN "气溶胶" | mkN "煙霧質" | mkN "烟雾质" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin aerosolized_A = mkA "雾化" ; -- open-multilingual-wordnet
lin aerospace_N = mkN "航天" ;
lin aery_N = mkN "巢" | mkN "雏" | mkN "高处的城堡" | mkN "高处的房子" ; -- open-multilingual-wordnet
lin aesculapian_A = mkA "内科" ; -- open-multilingual-wordnet
lin aestheteFem_N = variants {} ; ---- sense to be split
lin aestheteMasc_N = variants {} ; ---- sense to be split
lin aesthetic_A = mkA "美学" | {-HSK-} mkA "讲究" ;
lin aesthetic_N = mkN "审美特质" | {-HSK-} mkN "讲究" ;
lin aesthetical_A = mkA "审美" | mkA "富美感" | mkA "有美感" | mkA "美" | mkA "美学" ; -- open-multilingual-wordnet
lin aesthetics_N = mkN "美學" | mkN "美学" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aestival_A = mkA "发生在夏季" | mkA "夏季" ; -- open-multilingual-wordnet
lin aetiology_N = mkN "病原學" | mkN "病原学" | mkN "病因學" | mkN "病因学" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin afebrile_A = mkA "不发烧" | mkA "无热" ; -- open-multilingual-wordnet
lin affable_A = mkA "和蔼可亲" ;
lin affair_N = mkN "事件" | {-HSK-} mkN "事情" "件" ;
lin affect_N = mkN "情感""" ;
lin affect_V2 = mkV2 "作用" | mkV2 "关系" | mkV2 "影响" ;
lin affectation_N = mkN "假裝" | mkN "假装" | {-mwn-} mkN "虚饰" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin affected_A = variants {} ;
lin affectedness_N = mkN "假装" | mkN "虚饰" ; -- open-multilingual-wordnet
lin affecting_A = mkA "动人" ; -- open-multilingual-wordnet
lin affection_N = mkN "喜爱" "种" | {-HSK-} mkN "爱" ;
lin affectional_A = mkA "情感" | mkA "感情" ; -- open-multilingual-wordnet
lin affectionate_A = mkA "充满深情" ;
lin affenpinscher_N = mkN "艾芬品猴梗" ; -- open-multilingual-wordnet
lin affiant_N = mkN "宣誓者" "个" ;
lin affidavit_N = mkN "宣誓书" ;
lin affiliate_N = mkN "联号" [] ;
lin affiliate_V = mkV "子公司" ;
lin affiliate_V2 = mkV2 "子公司" ;
lin affiliation_N = mkN "联盟" ;
lin affinal_A = mkA "姻亲" | mkA "有婚姻关系" ; -- open-multilingual-wordnet
lin affine_A = mkA "仿射" | {-mwn-} mkA "仿射" ; -- status=guess -- open-multilingual-wordnet
lin affine_N = mkN "姻亲" ; -- open-multilingual-wordnet
lin affined_A = mkA "有密切关系" ; -- open-multilingual-wordnet
lin affinity_N = mkN "密切关系" "种" ;
lin affirm_V = mkV "肯定" ;
lin affirm_V2 = mkV2 "肯定" ;
lin affirm_VS = mkVS "肯定" ;
lin affirmable_A = mkA "可断言" ; -- open-multilingual-wordnet
lin affirmation_N = mkN "认定" ;
lin affirmative_A = mkA "肯定" ;
lin affirmative_N = mkN "肯定" ;
lin affix_N = mkN "詞綴" | mkN "词缀" ; -- status=guess -- status=guess
lin affix_V2 = mkV2 "粘贴" ;
lin affixal_A = mkA "词缀" ; -- open-multilingual-wordnet
lin affixation_N = mkN "附加" | mkN "附着" ; -- open-multilingual-wordnet
lin afflatus_N = mkN "灵感" ; -- open-multilingual-wordnet
lin afflict_V2 = mkV2 "折磨" ;
lin affliction_N = mkN "苦难" ;
lin affluence_N = mkN "富裕" ; -- open-multilingual-wordnet
lin affluent_A = mkA "富裕" ;
lin affluent_N = mkN "富人" ;
lin afford_V2 = mkV2 "给予" ;
lin afford_V2V = mkV2V "给予" ;
lin affordable_A = mkA "支付得起" | mkA "付得起" | mkA "買得起" | mkA "买得起" | mkA "實惠價格" | mkA "实惠价格" | mkA "優惠價格" | mkA "优惠价格" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin afforest_V2 = mkV2 (mkV "綠化") | mkV2 (mkV "绿化") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin afforestation_N = mkN "造林" ; -- open-multilingual-wordnet
lin affray_N = mkN "激烈的争吵" ; -- open-multilingual-wordnet
lin affricate_N = mkN "塞擦音" | mkN "破擦音" | mkN "破裂摩擦音" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin affrication_N = mkN "塞擦" ; -- open-multilingual-wordnet
lin afghanFem_N = variants {} ; ---- sense to be split
lin afghanMasc_N = variants {} ; ---- sense to be split
lin afghan_A = mkA "阿富汗人" ;
lin afghanistan_PN = mkPN "阿富汗" ; -- comment=src=geonames status=guess
lin afghanistaniFem_N = variants {} ; ---- sense to be split
lin afghanistaniMasc_N = variants {} ; ---- sense to be split
lin afield_Adv = mkAdv "在远处" ;
lin afire_A = mkA "点燃" | mkA "炽燃" | mkA "燃烧" ; -- open-multilingual-wordnet
lin aflame_A = mkA "点燃" | mkA "炽燃" | mkA "燃烧" ; -- open-multilingual-wordnet
lin aflare_A = mkA "点燃" | mkA "炽燃" | mkA "燃烧" ; -- open-multilingual-wordnet
lin aflutter_A = mkA "激动" ; -- open-multilingual-wordnet
lin aforementioned_A = mkA "上述" ; -- status=guess
lin afraid_A = mkA "怕" | {-HSK-} mkA "恐怕" ;
lin afresh_Adv = mkAdv "再" | mkAdv "又" | mkAdv "再...一遍" | mkAdv "重新" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin africa_PN = foreignPN "Africa" ; -- comment=src=eng status=guess
lin africanFem_N = variants {} ; ---- sense to be split
lin africanMasc_N = variants {} ; ---- sense to be split
lin african_A = mkA "非洲" ;
lin afrikanerFem_N = variants {} ; ---- sense to be split
lin afrikanerMasc_N = variants {} ; ---- sense to be split
lin afro_americanFem_N = variants {} ; ---- sense to be split
lin afro_americanMasc_N = variants {} ; ---- sense to be split
lin after_A = mkA "以后" | {-HSK-} mkA "然后" | mkA "等" ;
lin after_Adv = mkAdv "以后" | {-HSK-} mkAdv "然后" | mkAdv "等" ;
lin after_Prep = S.after_Prep ;
lin after_Subj = mkSubj "后" ;
lin afterburner_N = mkN "加力燃烧室" | mkN "复燃室" ; -- open-multilingual-wordnet
lin afterdamp_N = mkN "爆后气体" ; -- open-multilingual-wordnet
lin afterdeck_N = mkN "后甲板" ; -- open-multilingual-wordnet
lin aftereffect_N = mkN "后果" ;
lin afterglow_N = mkN "事后愉快的回忆" | mkN "余味" | mkN "回味" ; -- open-multilingual-wordnet
lin afterimage_N = mkN "余象" | mkN "残影" ; -- open-multilingual-wordnet
lin afterlife_N = mkN "來世" | mkN "来世" | mkN "後世" | mkN "后世" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin aftermath_N = mkN "后果" ;
lin aftermost_A = mkA "最后部" | mkA "近船尾" ; -- open-multilingual-wordnet
lin afternoon_N = mkN "下午" | {-HSK-} mkN "下午" "個" ;
lin afterpiece_N = mkN "余兴节目" | mkN "最后一幕短喜剧" ; -- open-multilingual-wordnet
lin aftershaft_N = mkN "副羽" ; -- open-multilingual-wordnet
lin aftershafted_A = mkA "副羽" | mkA "后羽" ; -- open-multilingual-wordnet
lin aftershock_N = mkN "余震" ;
lin aftertaste_N = mkN "余味" | mkN "回味" ; -- open-multilingual-wordnet
lin afterthought_N = mkN "事后补记" ; -- open-multilingual-wordnet
lin afterwards_Adv = mkAdv "事后" | {-HSK-} mkAdv "以后" | mkAdv "后来" | mkAdv "后面" | mkAdv "然后" ;
lin afterworld_N = mkN "墓地" ; -- open-multilingual-wordnet
lin again_Adv = mkAdv "再" | mkAdv "又" | mkAdv "重新" | {-HSK-} mkAdv "再次" ;
lin against_Prep = mkPrep "针对" ;
lin agal_N = mkN "头巾绳" ; -- open-multilingual-wordnet
lin agalactia_N = mkN "乳泌缺乏" | mkN "无乳" ; -- open-multilingual-wordnet
lin agama_N = mkN "飞龙科蜥蜴" ; -- open-multilingual-wordnet
lin agamic_A = mkA "单性生殖" | mkA "无性" | mkA "无性生殖" | mkA "裂殖生殖" ; -- open-multilingual-wordnet
lin agamid_N = mkN "鬣蜥属" ; -- open-multilingual-wordnet
lin agapanthus_N = mkN "非洲白莲" ; -- open-multilingual-wordnet
lin agape_N = mkN "友好聚餐" | mkN "爱筵" ; -- open-multilingual-wordnet
lin agar_N = mkN "洋菜" | {-mwn-} mkN "琼脂" ; -- status=guess -- open-multilingual-wordnet
lin agaric_N = mkN "伞菌" ; -- open-multilingual-wordnet
lin agate_N = mkN "玛瑙" ; -- open-multilingual-wordnet
lin agateware_N = mkN "玛瑙纹饰陶器" ; -- open-multilingual-wordnet
lin agatha_PN = foreignPN "Agatha" ; -- comment=src=eng status=guess
lin agave_N = mkN "龍舌蘭" | mkN "龙舌兰" ; -- status=guess -- status=guess
lin agaze_A = mkA "凝视" | mkA "瞪着眼" ; -- open-multilingual-wordnet
lin age_N = mkN "年代" "個" | mkN "年纪" "把" | mkN "年龄" "把" | mkN "时代" "個" | {-HSK-} mkN "年龄" ;
lin age_V = mkV "年龄" ;
lin aged_N = mkN "老年人""位" ;
lin aged_Prep = variants {} ;
lin agedness_N = mkN "老年" "个" ;
lin ageing_N = mkN "成熟的过程" | mkN "老龄化" ; -- open-multilingual-wordnet
lin ageism_N = mkN "年龄歧视" ; -- open-multilingual-wordnet
lin ageless_A = mkA "不停" | mkA "不断" | mkA "持久" | mkA "无止境" | mkA "无穷" | mkA "无穷尽" | mkA "永久" | mkA "永恒" | mkA "永远" ; -- open-multilingual-wordnet
lin age_long_A = mkA "持久" ; -- open-multilingual-wordnet
lin agency_N = mkN "中介" | {-HSK-} mkN "机构" ;
lin agenda_N = mkN "议程" ;
lin agenesis_N = mkN "发育不全" | mkN "无生殖力" ; -- open-multilingual-wordnet
lin agentFem_N = mkN "代理人" ;
lin agentMasc_N = mkN "代理人" ;
lin agent_provocateur_N = mkN "密探" ;
lin agential_A = mkA "代理人" | mkA "代理商" ; -- open-multilingual-wordnet
lin ageratum_N = mkN "霍香" ; -- open-multilingual-wordnet
lin aggie_PN = foreignPN "Aggie" ; -- comment=src=eng status=guess
lin agglomerate_A = mkA "会凝聚" | mkA "使成块" | mkA "团集" | mkA "密集成球" | mkA "成团" | mkA "成块" ; -- open-multilingual-wordnet
lin agglomerate_V = mkV "使成团" ; -- open-multilingual-wordnet
lin agglomeration_N = mkN "凝聚" | mkN "结块" ; -- open-multilingual-wordnet
lin agglutinin_N = mkN "凝集素" ; -- open-multilingual-wordnet
lin agglutinogen_N = mkN "凝集原" ; -- open-multilingual-wordnet
lin aggrandizement_N = mkN "增大" | mkN "强化" | mkN "扩大" ; -- open-multilingual-wordnet
lin aggravate_V2 = mkV2 "加剧" ;
lin aggravating_A = mkA "使更恶化" | mkA "恶化" ; -- open-multilingual-wordnet
lin aggravation_N = mkN "加剧" | mkN "加重" | mkN "增剧" | mkN "恶化" | mkN "更恶化" ; -- open-multilingual-wordnet
lin aggravator_N = mkN "讨厌的人" ; -- open-multilingual-wordnet
lin aggregate_A = mkA "合计" ;
lin aggregate_N = mkN "合计" ;
lin aggression_N = mkN "侵略" "次" ;
lin aggressive_A = mkA "侵略性" ;
lin aggressiveness_N = mkN "侵犯" ;
lin aggressorFem_N = mkN "侵略者" | mkN "挑衅者" | mkN "攻击者" ; -- open-multilingual-wordnet
lin aggressorMasc_N = mkN "侵略者" | mkN "挑衅者" | mkN "攻击者" ; -- open-multilingual-wordnet
lin aghast_A = mkA "吓呆" ;
lin agile_A = mkA "敏捷" | {-HSK-} mkA "灵活" ; -- status=guess
lin agility_N = mkN "敏捷" ;
lin aging_N = mkN "老化" ;
lin agio_N = mkN "汇水" | mkN "贴水" | mkN "贴现" ; -- open-multilingual-wordnet
lin agitate_V = mkV "激动" | {-mwn-} mkV "使重新组合" | mkV "改组" ; -- open-multilingual-wordnet
lin agitate_V2 = mkV2 "搅拌" | {-HSK-} mkV2 "激动" ;
lin agitation_N = mkN "鼓动" ;
lin agitative_A = mkA "令人生气" | mkA "煽动性" ; -- open-multilingual-wordnet
lin agitator_N = mkN "煽动者" ; -- open-multilingual-wordnet
lin agitprop_N = mkN "政治宣传" ; -- open-multilingual-wordnet
lin aglet_N = mkN "肩带" ; -- open-multilingual-wordnet
lin agnate_A = mkA "父亲" | mkA "父系" | mkA "父系亲属" | mkA "男方亲属" | mkA "男系亲属" ; -- open-multilingual-wordnet
lin agnate_N = mkN "父方的人" ; -- open-multilingual-wordnet
lin agnes_PN = foreignPN "Agnes" ; -- comment=src=eng status=guess
lin agnosia_N = mkN "认识不能" ; -- open-multilingual-wordnet
lin agnosticism_N = mkN "不可知論" | mkN "不可知论" | {-mwn-} mkN "怀疑主义" | mkN "怀疑论" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ago_Adv = mkAdv "之前" | {-HSK-} mkAdv "以前" ;
lin ago_Prep = mkPrep "在" "之前" ;
lin agog_A = mkA "极度兴奋" ; -- open-multilingual-wordnet
lin agonadal_A = mkA "没有性腺" ; -- open-multilingual-wordnet
lin agonal_A = mkA "呻吟待毙" | mkA "濒死" | mkA "濒死痛苦" ; -- open-multilingual-wordnet
lin agonize_V = mkV "折磨" ;
lin agonized_A = mkA "感到痛苦" ; -- open-multilingual-wordnet
lin agony_N = mkN "烦恼" | {-HSK-} mkN "痛苦" ;
lin agoraphobia_N = mkN "廣場恐懼症" | mkN "广场恐惧症" | {-mwn-} mkN "广场恐怖症" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin agra_PN = foreignPN "Agra" ; -- comment=src=geonames status=guess
lin agranulocytic_A = mkA "无颗粒白细胞" ; -- open-multilingual-wordnet
lin agranulocytosis_N = mkN "粒细胞缺乏" ; -- open-multilingual-wordnet
lin agraphia_N = mkN "运动性失写" ; -- open-multilingual-wordnet
lin agraphic_A = mkA "书写不能" | mkA "失写" ; -- open-multilingual-wordnet
lin agrarian_A = mkA "土地" | {-mwn-} mkA "农业" | mkA "农村" | mkA "务农" ; -- status=guess -- open-multilingual-wordnet
lin agree_V = mkV "同意" | {-HSK-} mkV "答应" ;
lin agree_VS = mkVS "同意" | {-HSK-} mkVS "答应" ;
lin agree_VV = mkVV "同意" | {-HSK-} mkVV "答应" ;
lin agree_on_V = advV OP_agree_V OP_on_Adv ; -- guess-p-verb
lin agree_with_V2 = mkV2 "符合" ;
lin agreeable_A = mkA "令人愉快" ;
lin agreed_A = variants {} ;
lin agreement_N = mkN "协议" ;
lin agrestic_A = mkA "乡土" | mkA "乡土气" | mkA "土气" | mkA "粗俗" | mkA "粗野" ; -- open-multilingual-wordnet
lin agribusiness_N = mkN "农业综合企业" ; -- open-multilingual-wordnet
lin agricultural_A = mkA "农业" ;
lin agriculture_N = mkN "农业" | {-HSK-} mkN "农业" [] ;
lin agriculturist_N = mkN "农业家" ; -- open-multilingual-wordnet
lin agrimonia_N = mkN "仙鹤草" | mkN "西洋龙芽草" | mkN "龙芽草" ; -- open-multilingual-wordnet
lin agrobiologic_A = mkA "农业生物学" ; -- open-multilingual-wordnet
lin agrobiology_N = mkN "农业生物学" | mkN "土壤生物学" ; -- status=guess -- status=guess
lin agrologic_A = mkA "农业土壤学" ; -- open-multilingual-wordnet
lin agrology_N = mkN "土壤学" ; -- open-multilingual-wordnet
lin agromania_N = mkN "旷野独处症" | mkN "野居癖" | mkN "隐居癖" ; -- open-multilingual-wordnet
lin agronomic_A = mkA "农艺学" ; -- open-multilingual-wordnet
lin agronomist_N = mkN "農業家" | mkN "农业家" | {-mwn-} mkN "农学家" | mkN "农艺学家" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin agronomy_N = mkN "農學" | mkN "农学" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin agrypnia_N = mkN "守夜" ; -- open-multilingual-wordnet
lin agrypnotic_A = mkA "使失眠" ; -- open-multilingual-wordnet
lin ague_N = mkN "寒顫" | mkN "寒颤" | {-mwn-} mkN "尖音符" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aguish_A = mkA "患了疟疾" ; -- open-multilingual-wordnet
lin ah_Interj = mkInterj "啊" ;
lin ahead_Adv = mkAdv "前面" | {-HSK-} mkAdv "向前" ;
lin ahead_of_Prep = mkPrep "在" "之前" ;
lin ahimsa_N = mkN "不杀生" | mkN "不杀生论" ; -- open-multilingual-wordnet
lin ahistorical_A = mkA "非历史" ; -- open-multilingual-wordnet
lin ahmedabad_PN = mkPN "艾哈迈达巴德" ; -- comment=src=geonames status=guess
lin aid_N = mkN "帮助" ;
lin aid_V = mkV "援助" ;
lin aid_V2 = mkV2 "帮助" ;
lin aide_N = mkN "助手" ;
lin aids_N = variants {} ;
lin aigret_N = mkN "冠毛" | mkN "冠羽" | mkN "羽饰" | mkN "鹭鸶毛帽饰" ; -- open-multilingual-wordnet
lin aigrette_N = mkN "冠毛" | mkN "冠羽" | mkN "羽饰" | mkN "鹭鸶毛帽饰" ; -- open-multilingual-wordnet
lin aikido_N = mkN "合氣道" | mkN "合气道" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ail_V = mkV "麻烦" ;
lin ailanthus_N = mkN "樗" | mkN "臭椿" ; -- open-multilingual-wordnet
lin aileron_N = mkN "副翼" | mkN "飞机的副翼" ; -- open-multilingual-wordnet
lin ailment_N = mkN "病" [] ;
lin ailurophobia_N = mkN "惧猫症" ; -- open-multilingual-wordnet
lin aim_N = mkN "目的" "個" | {-HSK-} mkN "瞄准" ;
lin aim_V = mkV "瞄准" ;
lin aim_V2 = mkV2 "瞄准" ;
lin aim_VV = mkVV "瞄准" ;
lin aim_at_V2 = prepV2 OP_aim_V OP_at_Prep ; -- guess-p-verb
lin aimless_A = mkA "漫无目" ;
lin aioli_N = mkN "蒜泥蛋黄酱" ; -- open-multilingual-wordnet
lin air_N = mkN "样子" | mkN "空气" ;
lin air_V = mkV "通风" ;
lin air_V2 = mkV2 "播送" ;
lin air_conditioned_A = mkA "有空调" ;
lin air_conditioning_N = mkN "空调" ;
lin airborne_A = mkA "空运" ;
lin airbrush_N = mkN "油漆喷雾器" ; -- open-multilingual-wordnet
lin airburst_N = mkN "空中爆炸" | mkN "空炸" ; -- open-multilingual-wordnet
lin airbus_N = mkN "空中公共汽车" | mkN "空中巴士" ; -- open-multilingual-wordnet
lin aircraft_N = mkN "飞机" ;
lin aircraftman_N = mkN "空军新兵" ; -- open-multilingual-wordnet
lin aircraftsman_N = mkN "空军新兵" ; -- open-multilingual-wordnet
lin aircrew_N = mkN "全体机员" ; -- open-multilingual-wordnet
lin aircrewman_N = mkN "机组人员" ; -- open-multilingual-wordnet
lin airdock_N = mkN "机库" | mkN "飞机库" | mkN "飞机棚" ; -- open-multilingual-wordnet
lin airdrie_PN = mkPN "艾尔德里" ; -- comment=src=geonames status=guess
lin aireborough_PN = foreignPN "Aireborough" ; -- comment=src=eng status=guess
lin airfare_N = mkN "机票价格" | mkN "飞机票价" | mkN "飞机费用" ; -- open-multilingual-wordnet
lin airfield_N = mkN "机场" | {-HSK-} mkN "机场" "家" ;
lin airflow_N = mkN "气流" ; -- open-multilingual-wordnet
lin airfoil_N = mkN "操纵台面" | mkN "机翼控制面" | mkN "翼面" ; -- open-multilingual-wordnet
lin airframe_N = mkN "弹体" | mkN "机体" | mkN "机身" | mkN "航空器构架" ; -- open-multilingual-wordnet
lin airhead_N = mkN "空降场" ; -- open-multilingual-wordnet
lin airing_N = mkN "兜风" ;
lin airless_A = mkA "不通气" | mkA "不通风" | mkA "没有风" | mkA "缺少空气" ; -- open-multilingual-wordnet
lin airlift_N = mkN "空運" | mkN "空运" ; -- status=guess -- status=guess
lin airline_N = mkN "航空公司" ;
lin airliner_N = mkN "客机" ;
lin airlock_N = mkN "氣塞" | mkN "气塞" | {-mwn-} mkN "气压过渡舱" | mkN "气闸" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin airmail_N = mkN "航空信" ; -- status=guess
lin airmailer_N = mkN "航空邮件" ; -- open-multilingual-wordnet
lin airman_N = mkN "空军" ;
lin airplane_N = L.airplane_N | {-HSK-} mkN "飞机" " " ;
lin airport_N = mkN "机场" "家" ;
lin airscrew_N = mkN "空气螺旋桨" | mkN "螺旋桨" ; -- open-multilingual-wordnet
lin airship_N = mkN "飞船" | mkN "飞艇" ; -- open-multilingual-wordnet
lin air_sick_A = mkA "晕机" | mkA "晕船" | mkA "晕车" | mkA "空晕病" ; -- open-multilingual-wordnet
lin air_sickness_N = mkN "晕机" ; -- open-multilingual-wordnet
lin airspace_N = mkN "領空" | mkN "空域" | mkN "上空" | {-mwn-} mkN "领空" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin airspeed_N = mkN "空速" ; -- open-multilingual-wordnet
lin airway_N = mkN "导气管" "条" ;
lin airworthiness_N = mkN "耐飞性" | mkN "适航" | mkN "适航性" ; -- open-multilingual-wordnet
lin airworthy_A = mkA "适宜航空" ; -- open-multilingual-wordnet
lin airy_A = mkA "幻想" | mkA "无实体" | mkA "空气状" | mkA "象空气" ; -- open-multilingual-wordnet
lin aisle_N = mkN "通道" "条" ;
lin aitchbone_N = mkN "牛的臀骨肉" ; -- open-multilingual-wordnet
lin akin_A = mkA "类似" ;
lin akinesis_N = mkN "无动力" | mkN "运动不能" ; -- open-multilingual-wordnet
lin akron_PN = mkPN "阿克伦" ; -- comment=src=geonames status=guess
lin al_PN = foreignPN "Al" ; -- comment=src=eng status=guess
lin alabama_PN = mkPN "阿拉巴马州" ;
lin alabaster_A = mkA "光洁美白" | mkA "光滑" | mkA "雪花石膏制" ; -- open-multilingual-wordnet
lin alacritous_A = mkA "快活" | mkA "活泼" ; -- open-multilingual-wordnet
lin alalia_N = mkN "哑" ; -- open-multilingual-wordnet
lin alan_PN = foreignPN "Alan" ; -- comment=src=eng status=guess
lin alanine_N = mkN "丙氨酸" ; -- open-multilingual-wordnet
lin alarm_N = mkN "警报" ;
lin alarm_V2 = mkV2 "报警" ;
lin alarming_A = mkA "恐吓" ;
lin alarmism_N = mkN "危言耸听" ; -- open-multilingual-wordnet
lin alarmist_N = mkN "大惊小怪者" | mkN "杞人忧天者" ; -- open-multilingual-wordnet
lin alas_Interj = mkInterj "唉" ;
lin alaska_PN = mkPN "阿拉斯加州" ;
lin alate_A = mkA "有翅" | mkA "有翼" | mkA "有翼状物" ; -- open-multilingual-wordnet
lin alb_N = mkN "白长袍" | mkN "白麻布僧衣" | mkN "白麻布圣职衣" ; -- open-multilingual-wordnet
lin albania_PN = mkPN "阿尔巴尼亚" ;
lin albanian_N = mkN " 阿尔巴尼亚人" ;
lin albatross_N = mkN "信天翁" ; -- status=guess -- open-multilingual-wordnet
lin albedo_N = mkN "反照率" ; -- open-multilingual-wordnet
lin albeit_Subj = mkSubj "尽管" ;
lin albert_PN = foreignPN "Albert" ; -- comment=src=geonames status=guess
lin alberta_PN = foreignPN "Alberta" ; -- comment=src=eng status=guess
lin albescent_A = mkA "变白" | mkA "带白" | mkA "带白色" | mkA "微白" | mkA "漂白" ; -- open-multilingual-wordnet
lin albinal_A = mkA "白化病" ; -- open-multilingual-wordnet
lin albinism_N = mkN "白化病" ; -- status=guess -- open-multilingual-wordnet
lin albino_N = mkN "患白化病的人" | mkN "患白化病的動植物" | {-mwn-} mkN "白化病者" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin albite_N = mkN "纳长石" ; -- open-multilingual-wordnet
lin albizzia_N = mkN "合欢树" ; -- open-multilingual-wordnet
lin albuca_N = mkN "弹簧草属植物" ; -- open-multilingual-wordnet
lin albuginea_N = mkN "白膜" ; -- open-multilingual-wordnet
lin album_N = mkN "相簿" ;
lin albumen_N = mkN "蛋白" ; -- status=guess
lin albumin_N = mkN "白蛋白" | {-mwn-} mkN "清蛋白" ; -- status=guess -- open-multilingual-wordnet
lin albuminous_A = mkA "蛋白质" ; -- open-multilingual-wordnet
lin albuminuria_N = mkN "蛋白尿" | mkN "蛋白尿症" ; -- open-multilingual-wordnet
lin albuminuric_A = mkA "蛋白尿" ; -- open-multilingual-wordnet
lin alcazar_N = mkN "城堡" | mkN "宫殿" | mkN "摩尔人的王宫" | mkN "要塞" ; -- open-multilingual-wordnet
lin alchemic_A = mkA "炼金术" ; -- open-multilingual-wordnet
lin alchemist_N = mkN "炼金术士" ;
lin alchemistic_A = mkA "炼金术" ; -- open-multilingual-wordnet
lin alchemy_N = mkN "煉金術" | mkN "炼金术" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin alcohol_N = mkN "酒精" [] ;
lin alcoholic_A = mkA "酒精" ;
lin alcoholic_N = mkN "酒精" ;
lin alcoholism_N = mkN "酗酒" ;
lin alcove_N = mkN "壁龛" | mkN "壁橱" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin aldehyde_N = mkN "醛" | {-mwn-} mkN "乙醛" ; -- status=guess -- open-multilingual-wordnet
lin aldehydic_A = mkA "醛式" ; -- open-multilingual-wordnet
lin aldershot_PN = mkPN "奧爾德肖特" ; -- comment=src=geonames status=guess
lin aldohexose_N = mkN "己醛糖" ; -- open-multilingual-wordnet
lin aldol_N = mkN "类醛" ; -- open-multilingual-wordnet
lin aldose_N = mkN "醛式糖" | mkN "醛糖" ; -- open-multilingual-wordnet
lin aldosterone_N = mkN "醛固酮" | mkN "醛甾酮" ; -- open-multilingual-wordnet
lin ale_N = mkN "麦芽酒" ;
lin aleatory_A = mkA "偶然" ; -- open-multilingual-wordnet
lin alembic_N = mkN "蒸馏器" | mkN "蒸馏罐" | mkN "蒸馏釜" ; -- open-multilingual-wordnet
lin aleppo_PN = mkPN "阿勒颇" ; -- comment=src=geonames status=guess
lin alert_A = mkA "警惕" ;
lin alert_N = mkN "警报" ;
lin alert_V2 = mkV2 "警惕" ;
lin alessandria_PN = foreignPN "Alessandria" ; -- comment=src=geonames status=guess
lin aleurone_N = mkN "糊粉" | mkN "蛋白质微粒" ; -- open-multilingual-wordnet
lin aleuronic_A = mkA "糊粉" ; -- open-multilingual-wordnet
lin alewife_N = mkN "拟西鲱" ; -- open-multilingual-wordnet
lin alex_PN = foreignPN "Alex" ; -- comment=src=eng status=guess
lin alexander_PN = foreignPN "Alexander" ; -- comment=src=geonames status=guess
lin alexandra_PN = foreignPN "Alexandra" ; -- comment=src=geonames status=guess
lin alexandria_PN = mkPN ("亚历山德里亚" | "亚历山大港") ; -- comment=src=geonames status=guess
lin alexandrite_N = mkN "变石" | mkN "紫翠玉" ; -- open-multilingual-wordnet
lin alexia_N = mkN "视觉性失语症" ; -- open-multilingual-wordnet
lin alexic_A = mkA "失读症" ; -- open-multilingual-wordnet
lin alexic_N = mkN "失读症患者" ; -- open-multilingual-wordnet
lin alf_PN = foreignPN "Alf" ; -- comment=src=geonames status=guess
lin alfalfa_N = mkN "苜蓿" "棵" ;
lin alfred_PN = foreignPN "Alfred" ; -- comment=src=geonames status=guess
lin alfresco_Adv = mkAdv "露天" ;
lin alfreton_PN = foreignPN "Alfreton" ; -- comment=src=geonames status=guess
lin alga_N = mkN "水藻" | mkN "藻類" | mkN "藻类" | {-mwn-} mkN "海藻" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin algal_A = mkA "海藻" ; -- open-multilingual-wordnet
lin algebra_N = mkN "代數式" | mkN "代数式" | {-mwn-} mkN "代数" | mkN "代数学" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin algebraic_A = mkA "代数" | mkA "代数学" | mkA "代数学上" ; -- open-multilingual-wordnet
lin algebraical_A = mkA "代数" | mkA "代数学" | mkA "代数学上" ; -- open-multilingual-wordnet
lin algebraist_N = mkN "代数学者" ; -- open-multilingual-wordnet
lin alger_PN = foreignPN "Alger" ; -- comment=src=eng status=guess
lin algeria_PN = mkPN "阿尔及利亚" ; -- comment=src=geonames status=guess
lin algid_A = mkA "发冷" ; -- open-multilingual-wordnet
lin algin_N = mkN "褐藻胶" | mkN "褐藻酸" ; -- open-multilingual-wordnet
lin algoid_A = mkA "水藻般" | mkA "海藻般" ; -- open-multilingual-wordnet
lin algometer_N = mkN "痛觉测验计" | mkN "痛觉计" ; -- open-multilingual-wordnet
lin algometric_A = mkA "痛觉测验计" ; -- open-multilingual-wordnet
lin algometry_N = mkN "痛觉测量法" ; -- open-multilingual-wordnet
lin algophobia_N = mkN "疼痛恐怖" | mkN "疼痛恐怖症" ; -- open-multilingual-wordnet
lin algorithm_N = mkN "算法" | {-mwn-} mkN "算法规则" | mkN "规则系统" ; -- status=guess -- open-multilingual-wordnet
lin ali_PN = foreignPN "Ali" ; -- comment=src=eng status=guess
lin alias_N = mkN "別名" | mkN "别名" | mkN "化名" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin alibi_N = mkN "不在場證明" | mkN "不在场证明" | mkN "不在犯罪現場" | mkN "不在犯罪现场" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin alicante_PN = mkPN "阿利坎特" ; -- comment=src=geonames status=guess
lin alice_PN = foreignPN "Alice" ; -- comment=src=geonames status=guess
lin alienFem_N = variants {} ; ---- sense to be split
lin alienMasc_N = variants {} ; ---- sense to be split
lin alien_A = mkA "外国" ;
lin alienate_V2 = mkV2 "疏远" ;
lin alienating_A = mkA "使不和" | mkA "挑拨" ; -- open-multilingual-wordnet
lin alienation_N = mkN "异化" "次" ;
lin alienator_N = mkN "疏远者" | mkN "让人疏远者" ; -- open-multilingual-wordnet
lin alienist_N = mkN "精神病医生" ; -- open-multilingual-wordnet
lin alight_A = mkA "点燃" | mkA "炽燃" | mkA "燃烧" ; -- open-multilingual-wordnet
lin align_V2 = mkV2 "使+结盟" ;
lin alike_A = mkA "仿佛" | {-HSK-} mkA "相似" ;
lin alike_Adv = mkAdv "一样" | {-HSK-} mkAdv "仿佛" ;
lin alimentary_A = mkA "有营养" | mkA "有营养成分" | mkA "滋养" | mkA "营养" ; -- open-multilingual-wordnet
lin alimentative_A = mkA "富于营养" | mkA "提供营养" | mkA "滋养" ; -- open-multilingual-wordnet
lin alimony_N = mkN "生活费" ;
lin aliphatic_A = mkA "脂肪族" ; -- open-multilingual-wordnet
lin aliquot_A = mkA "能整除" | {-mwn-} mkA "能整除" ; -- status=guess -- open-multilingual-wordnet
lin aliquot_N = mkN "等份" | mkN "小份" | {-mwn-} mkN "整除数" | mkN "约数" | mkN "除得尽数" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin alison_PN = foreignPN "Alison" ; -- comment=src=eng status=guess
lin aliterate_N = variants {} ; -- mkN "对阅读或文学不感兴趣的人" | mkN "能够阅读但对阅读没有兴趣的人" ; -- open-multilingual-wordnet
lin alive_A = mkA "活着" ;
lin aliyah_N = mkN "阿利亚" ; -- status=guess
lin alizarin_N = mkN "茜素" ; -- open-multilingual-wordnet
lin alkahest_N = mkN "万能溶剂" ; -- open-multilingual-wordnet
lin alkahestic_A = mkA "万能溶剂" ; -- open-multilingual-wordnet
lin alkalemia_N = mkN "碱血症" ; -- open-multilingual-wordnet
lin alkali_N = mkN "鹼" | mkN "碱" ; -- status=guess -- status=guess
lin alkalimetry_N = mkN "碱量测定法" ; -- open-multilingual-wordnet
lin alkaline_A = mkA "碱性" ; -- status=guess
lin alkalinuria_N = mkN "碱尿" ; -- open-multilingual-wordnet
lin alkaloid_N = mkN "生物碱" ; -- open-multilingual-wordnet
lin alkaloidal_A = mkA "含碱" | mkA "生物碱" ; -- open-multilingual-wordnet
lin alkalosis_N = mkN "碱中毒" ; -- open-multilingual-wordnet
lin alkalotic_A = mkA "碱中毒" ; -- open-multilingual-wordnet
lin alkapton_N = mkN "尿黑酸" | mkN "黑尿酸" ; -- open-multilingual-wordnet
lin alkaptonuria_N = mkN "尿黑酸尿" | mkN "黑尿酸尿症" ; -- open-multilingual-wordnet
lin alkene_N = mkN "烯" | mkN "烯烴" | mkN "烯烃" | {-mwn-} mkN "链烯" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin alkyd_N = mkN "醇酸树脂" ; -- open-multilingual-wordnet
lin alkyl_N = mkN "烷基亞硝酸鹽" | mkN "烷基亚硝酸盐" | {-mwn-} mkN "烃基" | mkN "烷基" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin alkylbenzene_N = mkN "烷基苯" | mkN "芳烃" ; -- open-multilingual-wordnet
lin alkylbenzenesulfonate_N = mkN "磺酸钙" ; -- open-multilingual-wordnet
lin alkylic_A = mkA "基属" ; -- open-multilingual-wordnet
lin all_A = mkA "一" | mkA "一切" | mkA "凡是" | mkA "所有" | mkA "都" | {-HSK-} mkA "全部" ;
lin all_Predet = S.all_Predet ;
lin allah_PN = foreignPN "Allah" ; -- comment=src=eng status=guess
lin allahabad_PN = foreignPN "Allahabad" ; -- comment=src=eng status=guess
lin allamanda_N = mkN "黄蔓" ; -- open-multilingual-wordnet
lin allan_PN = foreignPN "Allan" ; -- comment=src=geonames status=guess
lin allantoic_A = mkA "尿囊" ; -- open-multilingual-wordnet
lin allantoid_A = mkA "香肠样" ; -- open-multilingual-wordnet
lin allantois_N = mkN "尿模" | mkN "尿膜" ; -- open-multilingual-wordnet
lin allay_V2 = mkV2 "使+缓和" ;
lin allegation_N = mkN "断言" ;
lin allege_V2 = mkV2 "断言" ;
lin allege_VS = mkVS "断言" ;
lin alleged_A = variants {} ;
lin allegedly_AdA = mkAdA "据说" ;
lin allegedly_AdV = mkAdV "据称" ;
lin allegiance_N = mkN "忠贞" ;
lin allegiant_A = mkA "忠实" | mkA "忠心" ; -- open-multilingual-wordnet
lin allegoric_A = mkA "寓意" | mkA "寓言" | mkA "讽喻" ; -- open-multilingual-wordnet
lin allegorical_A = mkA "寓意" | mkA "寓言" | mkA "讽喻" ; -- open-multilingual-wordnet
lin allegorizer_N = mkN "以寓言诠释的人" ; -- open-multilingual-wordnet
lin allegory_N = mkN "寓言" ;
lin allegretto_Adv = mkAdv "小快板" ; -- status=guess
lin allelic_A = mkA "等位基因" ; -- open-multilingual-wordnet
lin allemande_N = mkN "阿勒曼德调味汁" ; -- open-multilingual-wordnet
lin allen_PN = foreignPN "Allen" ; -- comment=src=geonames status=guess
lin allergen_N = mkN "过敏原" ; -- open-multilingual-wordnet
lin allergenic_A = mkA "引起过敏症" ; -- open-multilingual-wordnet
lin allergic_A = mkA "过敏" ;
lin allergist_N = mkN "过敏症专治医师" ; -- open-multilingual-wordnet
lin allergology_N = mkN "变应性学" ; -- open-multilingual-wordnet
lin allergy_N = mkN "过敏" ;
lin alleviate_V2 = mkV2 "减轻" ;
lin alleviation_N = mkN "減輕" | mkN "减轻" | mkN "緩和" | mkN "缓和" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin alleviative_A = mkA "使缓和" | mkA "减轻" | mkA "止痛性" | mkA "缓和" | mkA "缓和性" ; -- open-multilingual-wordnet
lin alley_N = mkN "小路" | {-HSK-} mkN "胡同" "條" ;
lin alleyway_N = mkN "偏僻街道" | mkN "后巷" | mkN "小巷" | mkN "弄" | mkN "穷街陋巷" | mkN "背街" | mkN "背街深巷" | mkN "胡同" | mkN "里弄" ; -- open-multilingual-wordnet
lin alliaceous_A = mkA "有葱蒜味" ; -- open-multilingual-wordnet
lin alliance_N = mkN "联合" | {-HSK-} mkN "联盟" ;
lin allied_A = variants {} ;
lin alligator_N = mkN "短吻鳄" "只" ;
lin alligatored_A = mkA "有裂缝" ; -- open-multilingual-wordnet
lin alliteration_N = mkN "頭韻" | mkN "头韵" | mkN "雙聲" | mkN "双声" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin alliterative_A = mkA "头韵" | mkA "头韵体" ; -- open-multilingual-wordnet
lin alliterator_N = mkN "诗人" ; -- open-multilingual-wordnet
lin alloa_PN = foreignPN "Alloa" ; -- comment=src=geonames status=guess
lin allocable_A = mkA "可分发" | mkA "可分配" ; -- open-multilingual-wordnet
lin allocate_V = mkV "分" | mkV "分配" ;
lin allocate_V2 = mkV2 "分" | mkV2 "分配" ;
lin allocation_N = mkN "分配" ;
lin allocator_N = mkN "分配者" ; -- open-multilingual-wordnet
lin allochronic_A = mkA "异时" ; -- open-multilingual-wordnet
lin allocution_N = mkN "训谕" ; -- open-multilingual-wordnet
lin allogamous_A = mkA "异体交配" | mkA "异体受精" | mkA "异花受粉" ; -- open-multilingual-wordnet
lin allogamy_N = mkN "异花受精" ; -- open-multilingual-wordnet
lin allographic_A = mkA "代书" | mkA "代签名" ; -- open-multilingual-wordnet
lin allomerism_N = mkN "异质同形现象" ; -- open-multilingual-wordnet
lin allomerous_A = mkA "异体同晶" ; -- open-multilingual-wordnet
lin allometric_A = mkA "异速生长" ; -- open-multilingual-wordnet
lin allometry_N = mkN "异率研究" ; -- open-multilingual-wordnet
lin allomorphic_A = mkA "同质异晶" ;
lin allopathic_A = mkA "对抗疗法" | mkA "对症疗法" ; -- open-multilingual-wordnet
lin allopathy_N = mkN "对抗疗法" | mkN "对症疗法" ; -- open-multilingual-wordnet
lin allopatric_A = mkA "单独地发生" ; -- open-multilingual-wordnet
lin allopatry_N = mkN "异域性" ; -- open-multilingual-wordnet
lin allophone_N = mkN "同位異音" | mkN "同位异音" | {-mwn-} mkN "音位变体" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin allophonic_A = mkA "音位变体" ; -- open-multilingual-wordnet
lin allosaur_N = mkN "异特龙" ; -- open-multilingual-wordnet
lin allotment_N = mkN "配给" ;
lin allotrope_N = mkN "同素体" | mkN "同素异形体" ; -- open-multilingual-wordnet
lin allotropic_A = mkA "同素异形" | {-mwn-} mkA "同素异形" ; -- status=guess -- open-multilingual-wordnet
lin allotropy_N = mkN "同素" | mkN "同素异形" | mkN "同素异形现象" ; -- open-multilingual-wordnet
lin allover_A = mkA "全幅" | mkA "布满全面" ; -- open-multilingual-wordnet
lin allow_V2 = mkV2 "允许" | {-HSK-} mkV2 "给" ;
lin allow_V2V = mkV2V "允许" | {-HSK-} mkV2V "给" ;
lin allow_for_V2 = prepV2 (lin V OP_allow_V2) OP_for_Prep ; -- guess-p-verb
lin allow_of_V2 = prepV2 (lin V OP_allow_V2) OP_of_Prep ; -- guess-p-verb
lin allowable_A = mkA "许可" ;
lin allowance_N = mkN "津贴" ;
lin alloy_N = mkN "合金" ;
lin allude_V = mkV "暗指" ;
lin allure_N = mkN "诱惑力" ;
lin allure_V2 = mkV2 (mkV "引诱") ; -- status=guess, src=wikt
lin alluring_A = mkA "诱人" ;
lin allusion_N = mkN "暗示" ;
lin allusive_A = mkA "暗指" | mkA "隐喻" ; -- open-multilingual-wordnet
lin alluvial_A = mkA "冲积" ;
lin alluvion_N = mkN "冲积层" ; -- open-multilingual-wordnet
lin ally_N = mkN "盟友" ;
lin ally_V2 = mkV2 "使+联盟" ;
lin allyl_N = mkN "烯丙基" ; -- open-multilingual-wordnet
lin allylic_A = mkA "烯丙基" ; -- open-multilingual-wordnet
lin alma_ata_PN = foreignPN "Alma-ata" ; -- comment=src=eng status=guess
lin alma_mater_N = mkN "母校" ;
lin almanac_N = mkN "历书" ;
lin almandite_N = mkN "贵榴石" | mkN "铁矾石榴石" | mkN "铁铝榴石" ; -- open-multilingual-wordnet
lin almeria_PN = foreignPN "Almeria" ; -- comment=src=geonames status=guess
lin almighty_A = mkA "全能" | {-mwn-} mkA "万能" | mkA "全能" ; -- status=guess -- open-multilingual-wordnet
lin almond_N = mkN "扁桃浆" | {-mwn-} mkN "杏仁" ; -- status=guess -- open-multilingual-wordnet
lin almoner_N = mkN "施赈人员" ; -- open-multilingual-wordnet
lin almost_AdA = S.almost_AdA ;
lin almost_AdN = S.almost_AdN ;
lin almost_Adv = mkAdv "几乎" | {-HSK-} mkAdv "差不多" | mkAdv "快" ;
lin almost_Predet = mkPredet "差不多" ; -- comment="几乎" ;
lin alms_N = mkN "施捨" | mkN "施舍" | mkN "施捨物" | mkN "施舍物" | mkN "救濟金" | mkN "救济金" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin almsgiver_N = mkN "施舍者" ; -- open-multilingual-wordnet
lin alnwick_PN = foreignPN "Alnwick" ; -- comment=src=geonames status=guess
lin alocasia_N = mkN "海芋" ; -- open-multilingual-wordnet
lin aloft_Adv = mkAdv "高空" ;
lin alone_A = mkA "单独" | mkA "单纯" | {-HSK-} mkA "寂寞" ;
lin along_Adv = mkAdv "沿着" ;
lin along_Prep = mkPrep "沿着" ;
lin alongside_Adv = mkAdv "在旁边" ;
lin alongside_Prep = mkPrep "在旁边" ;
lin alopecia_N = mkN "秃头症" | mkN "秃顶" | mkN "脱发" ; -- open-multilingual-wordnet
lin alopecic_A = mkA "秃头症" | mkA "脱发" ; -- open-multilingual-wordnet
lin aloud_Adv = mkAdv "大声地" ;
lin alp_N = mkN "高山" ; -- open-multilingual-wordnet
lin alpaca_N = mkN "羊駝" | mkN "羊驼" | mkN "美洲駝" | mkN "美洲驼" | mkN "無峰駝" | mkN "无峰驼" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin alpenstock_N = mkN "游山杖" | mkN "登山杖" | mkN "铁头登山杖" ; -- open-multilingual-wordnet
lin alpestrine_A = mkA "亚高山带" ; -- open-multilingual-wordnet
lin alpha_N = mkN "开端" ;
lin alphabet_N = mkN "字母表" ;
lin alphabetical_A = variants {} ;
lin alphabetizer_N = mkN "识字的人" ; -- open-multilingual-wordnet
lin alphanumeric_A = mkA "字母数字混合编制" ; -- open-multilingual-wordnet
lin alphanumerics_N = mkN "字母数字" ; -- open-multilingual-wordnet
lin alphavirus_N = mkN "甲病毒属" ; -- open-multilingual-wordnet
lin alpinist_N = mkN "登山家" ; -- open-multilingual-wordnet
lin already_AdV = mkAdV "已经" ;
lin already_Adv = L.already_Adv | {-HSK-} mkAdv "尝" | mkAdv "就" | mkAdv "已经" | mkAdv "曾经" ;
lin alright_A = variants {} ;
lin alright_Adv = variants {} ;
lin alsatianFem_N = variants {} ; ---- sense to be split
lin alsatianMasc_N = variants {} ; ---- sense to be split
lin also_AdV = mkAdV "也" ;
lin also_Adv = mkAdv "下载" | mkAdv "也" | mkAdv "又" | mkAdv "痛快" | mkAdv "血" | mkAdv "还" ;
lin altar_N = mkN "祭坛" ;
lin altar_piece_N = mkN "圣坛装饰画" ; -- open-multilingual-wordnet
lin altazimuth_N = mkN "地平经纬仪" | mkN "经纬仪" ; -- open-multilingual-wordnet
lin alter_V = mkV "修改" | mkV "改变" ;
lin alter_V2 = mkV2 "修改" | mkV2 "改变" ;
lin alteration_N = mkN "改造" "次" ;
lin alternate_A = mkA "轮流" ;
lin alternate_V = mkV "交流" | mkV "轮流" ;
lin alternate_V2 = mkV2 "交流" | mkV2 "轮流" | {-HSK-} mkV2 "使+交替" ;
lin alternation_N = mkN "交替" ; -- open-multilingual-wordnet
lin alternative_A = mkA "替代" | {-HSK-} mkA "选择" ;
lin alternative_N = mkN "替代" | {-HSK-} mkN "选择" ;
lin alternator_N = mkN "交流發電機" ; -- status=guess
lin althea_N = mkN "蜀葵" ; -- open-multilingual-wordnet
lin although_Subj = S.although_Subj ;
lin altimeter_N = mkN "测高仪" | {-mwn-} mkN "高度计" | mkN "高程计" ; -- status=guess -- open-multilingual-wordnet
lin altissimo_A = mkA "很高" ; -- open-multilingual-wordnet
lin altitude_N = mkN "高度" "" ;
lin altitudinal_A = mkA "高度" ; -- open-multilingual-wordnet
lin altitudinous_A = mkA "高高" ; -- open-multilingual-wordnet
lin alto_N = mkN "中音" ; -- status=guess
lin altocumulus_N = mkN "高积云" ; -- open-multilingual-wordnet
lin altogether_Adv = mkAdv "一共" | mkAdv "一起" | mkAdv "总共" ;
lin alton_PN = foreignPN "Alton" ; -- comment=src=geonames status=guess
lin altostratus_N = mkN "高层云" ; -- open-multilingual-wordnet
lin altrincham_PN = mkPN "奥尔特灵厄姆" ; -- comment=src=geonames status=guess
lin altruism_N = mkN "利他主义" ;
lin altruistic_A = mkA "利他性" ;
lin alular_A = mkA "翅瓣" ; -- open-multilingual-wordnet
lin alum_N = mkN "明礬" | mkN "明矾" ; -- status=guess -- status=guess
lin alumina_N = mkN "氧化铝" | mkN "矾土" ; -- open-multilingual-wordnet
lin aluminate_N = mkN "铝" "块" ;
lin aluminiferous_A = mkA "铝" ; -- open-multilingual-wordnet
lin aluminium_N = mkN "铝" "块" ;
lin aluminous_A = mkA "含铝" | mkA "铝" ; -- open-multilingual-wordnet
lin alumnus_N = mkN "校友" ;
lin alumroot_N = mkN "矾根草" | mkN "老牛筋" | mkN "老贯筋" | mkN "老鸦嘴" | mkN "老鹳嘴" | mkN "老鹳草" | mkN "贯筋" ; -- open-multilingual-wordnet
lin alundum_N = mkN "氧化铝" ; -- open-multilingual-wordnet
lin alvechurch_PN = foreignPN "Alvechurch" ; -- comment=src=geonames status=guess
lin alveolar_A = mkA "肺泡" ; -- open-multilingual-wordnet
lin alveolar_N = mkN "齿槽音" ; -- open-multilingual-wordnet
lin alveolitis_N = mkN "干槽症" ; -- open-multilingual-wordnet
lin alvine_A = mkA "肠" | mkA "腹" ; -- open-multilingual-wordnet
lin always_AdV = S.always_AdV ;
lin always_Adv = mkAdv "一直" | mkAdv "从来" | mkAdv "总是" | mkAdv "时刻" | mkAdv "老" | mkAdv "长" | {-HSK-} mkAdv S.always_AdV.s timeAdvType ;
lin amah_N = mkN "保姆" ;
lin amalgamate_V2 = mkV2 "合并" ;
lin amalgamation_N = mkN "合并" "" ;
lin amalgamative_A = mkA "合并" ; -- open-multilingual-wordnet
lin amalgamator_N = mkN "收购人" ; -- open-multilingual-wordnet
lin amanda_PN = foreignPN "Amanda" ; -- comment=src=eng status=guess
lin amaranth_N = mkN "白莧" | mkN "白苋" | {-mwn-} mkN "苋属植物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin amaranthine_A = mkA "紫红" | mkA "苋属植物" ; -- open-multilingual-wordnet
lin amarelle_N = mkN "酸味很强的樱桃" | mkN "酸樱桃" ; -- open-multilingual-wordnet
lin amaryllis_N = mkN "孤挺花" | {-mwn-} mkN "宫人草" ; -- status=guess -- open-multilingual-wordnet
lin amass_V2 = mkV2 "聚敛" ;
lin amastia_N = mkN "无乳房" ; -- open-multilingual-wordnet
lin amateurFem_N = mkN "爱好者" "名" ;
lin amateurMasc_N = mkN "爱好者" "名" ;
lin amateur_A = mkA "业余" ;
lin amateurish_A = mkA "业余" ;
lin amateurishness_N = mkN "证明缺乏职业资格的事" ; -- open-multilingual-wordnet
lin amative_A = mkA "恋爱" ; -- open-multilingual-wordnet
lin amatory_A = mkA "恋爱" | mkA "罗曼蒂克" | mkA "色情" ; -- open-multilingual-wordnet
lin amaurosis_N = mkN "黑内障" | mkN "黑朦" ; -- open-multilingual-wordnet
lin amaurotic_A = mkA "黑内障" | mkA "黑朦" | mkA "黑蒙" ; -- open-multilingual-wordnet
lin amaze_V2 = mkV2 "惊讶" ;
lin amazement_N = mkN "惊异" ;
lin amazing_A = mkA "了不起" | {-HSK-} mkA "惊人" ;
lin amazon_N = mkN "亚马逊河" | mkN "亚马逊鹦鹉" ; -- open-multilingual-wordnet
lin ambassador_N = mkN "大使" ;
lin ambassadorial_A = mkA "大使" ; -- open-multilingual-wordnet
lin ambassadorship_N = mkN "大使的职位" ; -- open-multilingual-wordnet
lin ambassadress_N = mkN "女大使" ; -- open-multilingual-wordnet
lin amber_A = mkA "棕黄色" | mkA "琥珀色" | mkA "褐黄色" | mkA "黄褐色" ; -- open-multilingual-wordnet
lin amber_N = mkN "琥珀色" | mkN "淡黃色" ; -- status=guess -- status=guess
lin ambergris_N = mkN "龍涎香" | mkN "龙涎香" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin amberjack_N = mkN "大頭魚" | mkN "大头鱼" | {-mwn-} mkN "鰤" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ambidextrous_A = mkA "雙手靈巧" | {-mwn-} mkA "双手灵巧" ; -- status=guess -- open-multilingual-wordnet
lin ambience_N = mkN "格调" | mkN "环境" | mkN "氣氛" ; -- open-multilingual-wordnet
lin ambient_A = mkA "环境" | {-mwn-} mkA "四周" | mkA "环抱" ; -- open-multilingual-wordnet
lin ambiguity_N = mkN "双关" ;
lin ambiguous_A = mkA "模糊不清" | {-HSK-} mkA "暧昧" ;
lin ambition_N = mkN "志向" ;
lin ambitious_A = mkA "有雄心" ;
lin ambivalence_N = mkN "矛盾" ;
lin ambivalent_A = mkA "模棱两可" ;
lin ambiversive_A = mkA "两向性格" ; -- open-multilingual-wordnet
lin amble_V = mkV "缓行" ;
lin amblygonite_N = mkN "磷铝锂石" | mkN "锂磷铝石" ; -- open-multilingual-wordnet
lin amblyopia_N = mkN "弱視" | mkN "弱视" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin amblyopic_A = mkA "弱视" ; -- open-multilingual-wordnet
lin ambrosia_N = mkN "神食" | mkN "神的食物" | {-mwn-} mkN "众神饮的酒" | mkN "甘露" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ambulacral_A = mkA "步带" | mkA "步行足" | mkA "步足带" ; -- open-multilingual-wordnet
lin ambulacrum_N = mkN "步带" | mkN "步行足" ; -- open-multilingual-wordnet
lin ambulance_N = mkN "救护车" | {-HSK-} mkN "救护车" "輛" ;
lin ambulant_A = mkA "不需卧床" | mkA "可走动" ; -- open-multilingual-wordnet
lin ambuscade_N = mkN "伏击" | mkN "埋伏" ; -- open-multilingual-wordnet
lin ambush_N = mkN "埋伏" | mkN "伏擊" | mkN "伏击" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin ambush_V2 = mkV2 "埋伏" ;
lin ambusher_N = mkN "伏兵" ; -- open-multilingual-wordnet
lin ambystomid_N = mkN "钝口螈属" ; -- open-multilingual-wordnet
lin amebiasis_N = mkN "阿米巴病" ; -- open-multilingual-wordnet
lin ameboid_A = mkA "似变形虫" ; -- open-multilingual-wordnet
lin amelia_N = mkN "无肢" | mkN "缺肢" ; -- open-multilingual-wordnet
lin ameliorate_V = mkV "改善" ; -- status=guess, src=wikt
lin ameliorate_V2 = mkV2 (mkV "改善") ; -- status=guess, src=wikt
lin amelogenesis_N = mkN "釉质发生" ; -- open-multilingual-wordnet
lin amen_Interj = mkInterj "阿门" ;
lin amenable_A = mkA "会接纳" ;
lin amend_V = mkV "修改" | {-HSK-} mkV "改正" ;
lin amend_V2 = mkV2 "修改" | {-HSK-} mkV2 "改正" ;
lin amend_V2V = mkV2V "修改" | {-HSK-} mkV2V "改正" ;
lin amendable_A = mkA "修正" | mkA "改正" | mkA "纠正" ; -- open-multilingual-wordnet
lin amendment_N = mkN "修订" ;
lin amenity_N = mkN "舒适" ;
lin amenorrhea_N = mkN "不正常经闭" | mkN "无月经" | mkN "闭经" ; -- open-multilingual-wordnet
lin amenorrheic_A = mkA "无月经" ; -- open-multilingual-wordnet
lin amerciable_A = mkA "应罚款" ; -- open-multilingual-wordnet
lin america_PN = mkPN "美国" ;
lin americanFem_N = variants {} ; ---- sense to be split
lin americanMasc_N = mkN "美国人" ;
lin american_A = mkA "美国" ;
lin americanize_V2 = mkV2 "美国化" ;
lin americium_N = mkN "鎇" | mkN "镅" | mkN "鋂" ; -- status=guess -- status=guess -- status=guess
lin amesbury_PN = foreignPN "Amesbury" ; -- comment=src=geonames status=guess
lin amethyst_A = mkA "紫" ;
lin amethyst_N = mkN "紫" | {-HSK-} mkN "紫水晶" | {-mwn-} mkN "紫水晶" | mkN "紫蓝色宝石" ; -- status=guess -- open-multilingual-wordnet
lin amethystine_A = mkA "紫水晶" ; -- open-multilingual-wordnet
lin ametria_N = mkN "无子宫" ; -- open-multilingual-wordnet
lin ametropia_N = mkN "屈光不正" ;
lin amiable_A = mkA "亲切" | mkA "可爱" | {-HSK-} mkA "和蔼可亲" ; -- comment="亲切" ;
lin amicable_A = mkA "友好" ;
lin amid_Prep = mkPrep "在" "之中" ;
lin amide_N = mkN "酰胺" | {-mwn-} mkN "氨基化合物" ; -- status=guess -- open-multilingual-wordnet
lin amidships_Adv = mkAdv "在船中央部" | mkAdv "在船中部" | mkAdv "在船腹" | mkAdv "在船身中部+地" ; -- open-multilingual-wordnet
lin amiens_PN = mkPN "亞眠" ; -- comment=src=geonames status=guess
lin amigo_N = mkN "朋友" ; -- open-multilingual-wordnet
lin amine_N = mkN "胺" ; -- status=guess
lin amino_A = mkA "氨基" ; -- open-multilingual-wordnet
lin amino_N = mkN "氨基酸" | {-mwn-} mkN "氨基" ; -- status=guess -- open-multilingual-wordnet
lin aminoaciduria_N = mkN "氨基酸尿" | mkN "胺基酸尿症" | mkN "蛋白尿" ; -- open-multilingual-wordnet
lin aminomethane_N = mkN "甲胺" ; -- open-multilingual-wordnet
lin aminopyrine_N = mkN "匹拉米洞" | mkN "氨基比林" ; -- open-multilingual-wordnet
lin amiss_A = mkA "有毛病" ;
lin amitosis_N = mkN "无丝分裂" | mkN "直接分裂" | mkN "直接核分裂" ; -- open-multilingual-wordnet
lin amitotic_A = mkA "无丝分裂" ; -- open-multilingual-wordnet
lin ammanford_PN = foreignPN "Ammanford" ; -- comment=src=geonames status=guess
lin ammeter_N = mkN "安培计" | mkN "电表" ; -- open-multilingual-wordnet
lin ammine_N = mkN "氨络物" ; -- open-multilingual-wordnet
lin ammino_A = mkA "氨合" | mkA "氨络" | mkA "氨络物" ; -- open-multilingual-wordnet
lin ammobium_N = mkN "银苞菊" ; -- open-multilingual-wordnet
lin ammonia_N = mkN "氨" ;
lin ammoniac_A = mkA "含氨" | mkA "氨" | mkA "氨性" ; -- open-multilingual-wordnet
lin ammoniac_N = mkN "氨树胶" | mkN "氨草胶" ; -- open-multilingual-wordnet
lin ammoniated_A = mkA "与氨化合了" ; -- open-multilingual-wordnet
lin ammonification_N = mkN "加氨作用" | mkN "成氨作用" | mkN "氨化" | mkN "氨化作用" ; -- open-multilingual-wordnet
lin ammonite_N = mkN "菊石" ; -- open-multilingual-wordnet
lin ammonium_N = mkN "氨盐基" | mkN "铵" ; -- open-multilingual-wordnet
lin ammoniuria_N = mkN "氨尿" ; -- open-multilingual-wordnet
lin ammunition_N = mkN "弹药" ;
lin amnesia_N = mkN "失憶症" | mkN "失忆症" | {-mwn-} mkN "记忆缺失" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin amnesic_A = mkA "引起遗忘" ; -- open-multilingual-wordnet
lin amnesic_N = mkN "健忘症患者" ; -- open-multilingual-wordnet
lin amnestic_A = mkA "引起遗忘" ; -- open-multilingual-wordnet
lin amnesty_N = mkN "大赦" ;
lin amniocentesis_N = mkN "羊膜穿刺術" | mkN "羊膜穿刺术" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin amnion_N = mkN "初蜕" | mkN "羊膜" ; -- open-multilingual-wordnet
lin amniote_N = mkN "羊膜动物" | mkN "羊膜的" | mkN "脊椎动物" ; -- open-multilingual-wordnet
lin amniotic_A = mkA "有羊膜" | mkA "羊膜" ; -- open-multilingual-wordnet
lin amoeba_N = mkN "變形蟲" | mkN "变形虫" | mkN "阿米巴" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin amoebic_A = mkA "阿米巴" | mkA "阿米巴性" ; -- open-multilingual-wordnet
lin amuck_Adv = mkAdv "疯狂地" ;
lin among_Prep = mkPrep "在" "其中" ;
lin amongst_Prep = mkPrep "在之中" ;
lin amoralism_N = mkN "非道德论" ; -- open-multilingual-wordnet
lin amoralist_N = mkN "无道德观的人" ; -- open-multilingual-wordnet
lin amorist_N = mkN "爱情小说作者" ; -- open-multilingual-wordnet
lin amoristic_A = mkA "浪漫" ; -- open-multilingual-wordnet
lin amorous_A = mkA "恋爱" ; -- open-multilingual-wordnet
lin amorousness_N = mkN "好色" | mkN "性的兴奋" ; -- open-multilingual-wordnet
lin amorpha_N = mkN "棉条" | mkN "棉槐" | mkN "椒条" | mkN "穗花槐" | mkN "紫穗槐" ; -- open-multilingual-wordnet
lin amort_A = mkA "意志消沉" | mkA "无生气" ; -- open-multilingual-wordnet
lin amortization_N = mkN "分期偿还" ;
lin amortize_V2 = mkV2 "摊还" ;
lin amount_N = mkN "多少" | mkN "数字" "個" | mkN "数码" | mkN "数量" "個" | {-HSK-} mkN "数量" ;
lin amount_V = mkV "量" ;
lin amour_N = mkN "偷情" | mkN "婚外情" | mkN "私通" ; -- open-multilingual-wordnet
lin amp_Conj = mkConj "&" ; -- comment=NOT SURE
lin amp_N = mkN "放大器" ;
lin amperage_N = mkN "安培数" | mkN "电流强度" ; -- open-multilingual-wordnet
lin ampere_N = mkN "安培" ; -- status=guess -- open-multilingual-wordnet
lin ampersand_N = mkN "和號" | mkN "和号" ; -- status=guess -- status=guess
lin amphetamine_N = mkN "安非他明" | {-mwn-} mkN "右旋硫酸苯丙胺" | mkN "硫酸苯丙胺" | mkN "苯丙胺" | mkN "苯齐巨林" ; -- status=guess -- open-multilingual-wordnet
lin amphibia_N = mkN "两栖纲" | mkN "两箩类" ; -- open-multilingual-wordnet
lin amphibian_N = mkN "兩棲動物" | mkN "两栖动物" ; -- status=guess -- status=guess
lin amphibious_A = mkA "兩棲" | mkA "两栖" ; -- status=guess -- status=guess
lin amphibole_N = mkN "閃石" | mkN "闪石" | mkN "角閃石" | mkN "角闪石" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin amphibolite_N = mkN "角闪岩" ; -- open-multilingual-wordnet
lin amphibology_N = mkN "模棱两可的言词" ; -- open-multilingual-wordnet
lin amphibrach_N = mkN "抑扬抑格" ; -- open-multilingual-wordnet
lin amphictyony_N = mkN "近邻同盟" ; -- open-multilingual-wordnet
lin amphidiploid_N = mkN "双二倍体" | mkN "双二倍体的个体" ; -- open-multilingual-wordnet
lin amphidiploidy_N = mkN "双二倍体" ; -- open-multilingual-wordnet
lin amphigory_N = mkN "无意义之诗文" | mkN "无意义而滑稽的文章" ; -- open-multilingual-wordnet
lin amphimixis_N = mkN "两性融合" ; -- open-multilingual-wordnet
lin amphipod_N = mkN "异脚类" | mkN "片脚类动物" | mkN "端足目动物" ; -- open-multilingual-wordnet
lin amphitheatric_A = mkA "圆剧场" | mkA "圆剧场式" ; -- open-multilingual-wordnet
lin amphitropous_A = mkA "植物横生" | mkA "横生" ; -- open-multilingual-wordnet
lin amphiuma_N = mkN "两栖鲵" | mkN "海鳗之类" ; -- open-multilingual-wordnet
lin amphora_N = mkN "双耳瓶" | mkN "双耳陶瓶" ; -- open-multilingual-wordnet
lin amphoric_A = mkA "瓮音" | mkA "瓮音" | mkA "空洞音" | mkA "空瓮性" ; -- open-multilingual-wordnet
lin amphotericin_N = mkN "两性霉素" ; -- open-multilingual-wordnet
lin ample_A = mkA "充足" ;
lin amplification_N = mkN "扩大" | mkN "放大" ; -- open-multilingual-wordnet
lin amplifier_N = mkN "扩音器" ;
lin amplify_V2 = mkV2 "增强" ;
lin amplitude_N = mkN "調幅" | mkN "调幅" ; -- status=guess -- status=guess
lin ampoule_N = mkN "安瓿" ;
lin ampulla_N = mkN "双耳细颈瓶" ; -- open-multilingual-wordnet
lin ampullar_A = mkA "壶腹" | mkA "壶腹状" ; -- open-multilingual-wordnet
lin amputation_N = mkN "截肢" ;
lin amputator_N = mkN "截肢医生" ; -- open-multilingual-wordnet
lin amputee_N = mkN "受切断手术的人" | mkN "被截肢者" ; -- open-multilingual-wordnet
lin amsterdam_PN = mkPN "阿姆斯特丹" ;
lin amulet_N = mkN "護身符" | mkN "护身符" | mkN "護符" | mkN "护符" | mkN "護身符子" | mkN "护身符子" | {-mwn-} mkN "避邪物" | mkN "驱邪符" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin amuse_V2 = mkV2 "娱乐" ;
lin amusement_N = mkN "娱乐" | {-HSK-} mkN "娱乐" "种" ;
lin amusing_A = mkA "有趣" ;
lin amy_PN = foreignPN "Amy" ; -- comment=src=eng status=guess
lin amygdala_N = mkN "杏仁體" | mkN "杏仁体" ; -- status=guess -- status=guess
lin amygdalin_N = mkN "扁桃苷" | mkN "杏苷" | mkN "苦杏仁甙" | mkN "苦杏苷" ; -- open-multilingual-wordnet
lin amygdaline_A = mkA "似杏仁" | mkA "扁桃形" | mkA "杏形" ; -- open-multilingual-wordnet
lin amyl_N = mkN "硝酸戊酯" ; -- status=guess
lin amylase_N = mkN "淀粉酶" ; -- status=guess -- open-multilingual-wordnet
lin amyloid_N = mkN "淀粉状蛋白" ; -- open-multilingual-wordnet
lin amyloidosis_N = mkN "淀粉样变性" | mkN "淀粉样变性病" ; -- open-multilingual-wordnet
lin amylolysis_N = mkN "淀粉分解" ; -- open-multilingual-wordnet
lin amylolytic_A = mkA "使淀粉分解" | mkA "淀粉分解" ; -- open-multilingual-wordnet
lin amyotrophia_N = mkN "肌肉萎缩" ; -- open-multilingual-wordnet
lin amyxia_N = mkN "粘液缺乏" ; -- open-multilingual-wordnet
lin ana_N = mkN "丛谈" | mkN "杂话" | mkN "轶事" | mkN "逸话" ; -- open-multilingual-wordnet
lin anabiosis_N = mkN "暂时休眠" | {-mwn-} mkN "复苏" | mkN "失水休眠" ; -- status=guess -- open-multilingual-wordnet
lin anabolism_N = mkN "同化作用" | {-mwn-} mkN "合成代谢" ; -- status=guess -- open-multilingual-wordnet
lin anachronism_N = mkN "时代错误" ;
lin anachronistic_A = mkA "不合時代" | mkA "不合时代" | mkA "不合時宜" | mkA "不合时宜" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin anaclisis_N = mkN "情感依附" | mkN "情绪依附" ; -- open-multilingual-wordnet
lin anaclitic_A = mkA "依赖" | mkA "依靠" | mkA "情感依附" ; -- open-multilingual-wordnet
lin anacoluthia_N = mkN "破格文体" ; -- open-multilingual-wordnet
lin anaconda_N = mkN "安納康達" | mkN "安纳康达" | mkN "大水蟒" | mkN "森蚺" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin anadiplosis_N = mkN "前词递接法" | mkN "联珠法" | mkN "蝉联法" ; -- open-multilingual-wordnet
lin anaerobe_N = mkN "厌氧性生物" | mkN "厌氧菌" ; -- open-multilingual-wordnet
lin anaerobic_A = mkA "厌氧" ; -- status=guess
lin anaesthesia_N = mkN "麻醉" | {-mwn-} mkN "感觉缺失" | mkN "麻木" | mkN "麻痹" ; -- status=guess -- open-multilingual-wordnet
lin anaesthetic_N = mkN "麻药" | mkN "麻醉剂" ; -- open-multilingual-wordnet
lin anaesthetist_N = mkN "麻醉学者" | mkN "麻醉师" ; -- open-multilingual-wordnet
lin anaglyphic_A = mkA "浮雕" ; -- open-multilingual-wordnet
lin anaglyphy_N = mkN "浮雕艺术" ; -- open-multilingual-wordnet
lin anagoge_N = mkN "神秘解释" ; -- open-multilingual-wordnet
lin anagogic_A = mkA "有神秘解释" | mkA "神秘解释" ; -- open-multilingual-wordnet
lin anagram_N = mkN "變形詞" | mkN "变形词" ; -- status=guess -- status=guess
lin anagrammatic_A = mkA "字谜" | mkA "改缀文字" ; -- open-multilingual-wordnet
lin anal_A = mkA "肛門" | mkA "肛门" ; -- status=guess -- status=guess
lin analbuminemia_N = mkN "无清蛋白血" | mkN "缺白蛋白血" ; -- open-multilingual-wordnet
lin analects_N = mkN "语录" | mkN "选集" ; -- open-multilingual-wordnet
lin analeptic_A = mkA "提神" ; -- open-multilingual-wordnet
lin analeptic_N = mkN "兴奋剂" | mkN "回苏剂" | mkN "苏醒剂" ; -- open-multilingual-wordnet
lin analgesia_N = mkN "痛觉缺失" ; -- open-multilingual-wordnet
lin analgesic_A = mkA "鎮痛劑" | mkA "镇痛剂" | mkA "止痛藥" | mkA "止痛药" | {-mwn-} mkA "不痛" | mkA "止痛" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin analgesic_N = mkN "鎮痛劑" | mkN "镇痛剂" | mkN "止痛藥" | mkN "止痛药" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin analog_N = mkN "模拟" ;
lin analogical_A = mkA "类比" ; -- open-multilingual-wordnet
lin analogist_N = mkN "类推者" | mkN "类推论者" | mkN "类比推理者" ; -- open-multilingual-wordnet
lin analogous_A = mkA "类似" ;
lin analogy_N = mkN "比喻" ;
lin analphabet_N = mkN "文盲" | mkN "目不识丁者" ; -- open-multilingual-wordnet
lin analysand_N = mkN "接受精神分析的人" ; -- open-multilingual-wordnet
lin analysis_N = mkN "分析" | {-HSK-} mkN "分析" "個" ;
lin analyst_N = mkN "分析人士" ;
lin analytic_A = mkA "分析" ;
lin analytical_A = mkA "分析" ;
lin analyze_V2 = mkV2 "分析" ;
lin analyzer_N = mkN "分析器" ; -- open-multilingual-wordnet
lin anamnestic_A = mkA "回忆反应" | mkA "回忆性" | mkA "既往症" | mkA "病历" ; -- open-multilingual-wordnet
lin anapaest_N = mkN "抑抑扬格" | mkN "短短长格" ; -- open-multilingual-wordnet
lin anapaestic_A = mkA "抑抑扬格" | mkA "短短长格" ; -- open-multilingual-wordnet
lin anapest_N = mkN "抑抑扬格" | mkN "短短长格" ; -- open-multilingual-wordnet
lin anapestic_A = mkA "抑抑扬格" | mkA "短短长格" ; -- open-multilingual-wordnet
lin anaphase_N = mkN "减数分裂" | mkN "成熟分裂" | mkN "细胞分裂后期" ; -- open-multilingual-wordnet
lin anaphasic_A = mkA "细胞分裂后期" ; -- open-multilingual-wordnet
lin anaphor_N = mkN "照应语" ; -- open-multilingual-wordnet
lin anaphoric_A = mkA "首语重复法" ; -- open-multilingual-wordnet
lin anaphrodisiac_A = mkA "抑制性欲" ; -- open-multilingual-wordnet
lin anaphylactic_A = mkA "导致过敏" | mkA "过敏" | mkA "过敏性" ; -- open-multilingual-wordnet
lin anaphylaxis_N = mkN "過敏性反應" | mkN "过敏性反应" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anaplasia_N = mkN "退行发育" ; -- open-multilingual-wordnet
lin anaplasmosis_N = mkN "边虫病" ; -- open-multilingual-wordnet
lin anaplastic_A = mkA "还原成形术" | mkA "退行发育术" ; -- open-multilingual-wordnet
lin anapsid_N = mkN "缺弓爬行动物" ; -- open-multilingual-wordnet
lin anarchic_A = mkA "无政府" | mkA "无法" | mkA "无秩序" ; -- open-multilingual-wordnet
lin anarchism_N = mkN "無政府主義" | mkN "无政府主义" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anarchistFem_N = mkN "无政府主义者" ; -- open-multilingual-wordnet
lin anarchistMasc_N = mkN "无政府主义者" ; -- open-multilingual-wordnet
lin anarchistic_A = mkA "无政府主义" ; -- open-multilingual-wordnet
lin anarchy_N = mkN "无政府状态" ;
lin anarthria_N = mkN "构音障碍" | mkN "言语讷吃" ; -- open-multilingual-wordnet
lin anasarca_N = mkN "全身水肿" ; -- open-multilingual-wordnet
lin anasarcous_A = mkA "全身水肿" ; -- open-multilingual-wordnet
lin anaspid_N = mkN "缺甲鱼" ; -- open-multilingual-wordnet
lin anastigmat_N = mkN "去像散透镜" | mkN "无象散透镜" | mkN "消像散透镜" ; -- open-multilingual-wordnet
lin anastomotic_A = mkA "吻合" ; -- open-multilingual-wordnet
lin anathema_N = mkN "诅咒" ;
lin anathematize_V = mkV "咒诅" | mkV "咒逐" | mkV "诅咒" ; -- open-multilingual-wordnet
lin anatomical_A = mkA "解剖" ;
lin anatomist_N = mkN "解剖学家" ; -- open-multilingual-wordnet
lin anatomy_N = mkN "解剖學" | mkN "解剖学" | mkN "解剖" ; -- status=guess -- status=guess -- status=guess
lin anatotitan_N = mkN "巨鸭龙" ; -- open-multilingual-wordnet
lin anatoxin_N = mkN "去毒毒素" | mkN "变性毒素" | mkN "类毒素" ; -- open-multilingual-wordnet
lin anatropous_A = mkA "倒生" ; -- open-multilingual-wordnet
lin ancestor_N = mkN "祖先" | {-HSK-} mkN "祖先" "位" ;
lin ancestral_A = mkA "祖先" ;
lin ancestress_N = mkN "女祖先" ; -- open-multilingual-wordnet
lin ancestry_N = mkN "祖先" ;
lin anchor_N = mkN "锚" ;
lin anchor_V = mkV "抛锚" ;
lin anchor_V2 = mkV2 "抛锚" ;
lin anchorite_N = mkN "隐士" | mkN "隐居者" | mkN "隐者" ; -- open-multilingual-wordnet
lin anchoritic_A = mkA "隐士" | mkA "隐士般" ; -- open-multilingual-wordnet
lin anchorman_N = mkN "主持人" ;
lin anchovy_N = mkN "鳳尾魚" | mkN "凤尾鱼" ; -- status=guess -- status=guess
lin anchusa_N = mkN "华丽景天" | mkN "牛舌草" | mkN "蝎子草" | mkN "长药景天" ; -- open-multilingual-wordnet
lin ancient_A = mkA "古代" | {-HSK-} mkA "古老" ;
lin ancient_N = mkN "古老" ;
lin ancillary_A = mkA "辅助" ;
lin ancona_PN = mkPN "安科纳" ; -- comment=src=geonames status=guess
lin and_Conj = S.and_Conj ;
lin andante_A = mkA "徐缓" | mkA "缓慢" ; -- open-multilingual-wordnet
lin andantino_A = mkA "微速" | mkA "节拍或曲子微急" ; -- open-multilingual-wordnet
lin andesite_N = mkN "安山岩" | mkN "安山石" ; -- open-multilingual-wordnet
lin andiron_N = mkN "柴架" | mkN "薪架" ; -- open-multilingual-wordnet
lin andorra_PN = mkPN "安道爾" ; -- comment=src=geonames status=guess
lin andover_PN = mkPN "安多佛" ; -- comment=src=geonames status=guess
lin andradite_N = mkN "钙铁榴石" ; -- open-multilingual-wordnet
lin andrew_PN = foreignPN "Andrew" ; -- comment=src=eng status=guess
lin androecium_N = mkN "雄蕊" ; -- open-multilingual-wordnet
lin androgen_N = mkN "雄激素" | mkN "雄性激素" | mkN "男性激素" | mkN "男性荷爾蒙" | mkN "男性荷尔蒙" | {-mwn-} mkN "男性素" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin androgenesis_N = mkN "雄性单性生殖" | mkN "雄核发育" ; -- open-multilingual-wordnet
lin androgenetic_A = mkA "雄性单性生殖" ; -- open-multilingual-wordnet
lin androgenic_A = mkA "雄性激素" | mkA "雄激素" ; -- open-multilingual-wordnet
lin androgynous_A = mkA "不男不女" ; -- status=guess
lin android_N = mkN "機器人" | mkN "机器人" | mkN "人形的機器人" | mkN "人形的机器人" | mkN "仿生人" | {-mwn-} mkN "人形自动机" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin androphobia_N = mkN "恐男症" ; -- open-multilingual-wordnet
lin androsterone_N = mkN "雄甾酮" ; -- open-multilingual-wordnet
lin andy_PN = foreignPN "Andy" ; -- comment=src=eng status=guess
lin anecdotal_A = mkA "传闻" ;
lin anecdote_N = mkN "逸事" | mkN "軼事" | mkN "轶事" ; -- status=guess -- status=guess -- status=guess
lin anecdotic_A = mkA "多逸事趣闻" | mkA "轶事" | mkA "逸话" ; -- open-multilingual-wordnet
lin anecdotist_N = mkN "健谈者" | mkN "讲逸事的人" ; -- open-multilingual-wordnet
lin anechoic_A = mkA "无反响" | mkA "无回声" | mkA "消声" ; -- open-multilingual-wordnet
lin anemia_N = mkN "貧血" | mkN "贫血" ; -- status=guess -- status=guess
lin anemic_A = mkA "贫血" ; -- status=guess
lin anemographic_A = mkA "风力自记曲线" ; -- open-multilingual-wordnet
lin anemography_N = mkN "记风法" | mkN "风速测定法" ; -- open-multilingual-wordnet
lin anemometer_N = mkN "风力计" | mkN "风速计" | {-mwn-} mkN "风速测定仪" | mkN "风速表" | mkN "风速记录仪" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anemometric_A = mkA "测定风力" ; -- open-multilingual-wordnet
lin anencephalic_A = mkA "无脑" ; -- open-multilingual-wordnet
lin anencephaly_N = mkN "无脑畸形" ; -- open-multilingual-wordnet
lin aneroid_A = mkA "不用液体" | mkA "无液" ; -- open-multilingual-wordnet
lin aneroid_N = mkN "无液晴雨表" | mkN "无液气压计" | mkN "空盒气压表" | mkN "膜盒气压计" ; -- open-multilingual-wordnet
lin anesthesia_N = mkN "麻醉" | {-mwn-} mkN "感觉缺失" | mkN "麻木" | mkN "麻痹" ; -- status=guess -- open-multilingual-wordnet
lin anesthesiologist_N = mkN "麻醉学者" | mkN "麻醉师" ; -- open-multilingual-wordnet
lin anesthesiology_N = mkN "麻醉学" ; -- open-multilingual-wordnet
lin anesthetic_N = mkN "麻药" | mkN "麻醉剂" ; -- open-multilingual-wordnet
lin anesthetist_N = mkN "麻醉学者" | mkN "麻醉师" ; -- open-multilingual-wordnet
lin anesthetize_V2 = mkV2 "使+麻醉" ;
lin anestrus_N = mkN "不动情期" | {-mwn-} mkN "无动情期" | mkN "无情欲期" | mkN "非求偶期" ; -- status=guess -- open-multilingual-wordnet
lin aneuploid_A = mkA "非整倍" ; -- open-multilingual-wordnet
lin aneuploidy_N = mkN "非整倍性" ; -- open-multilingual-wordnet
lin aneurysm_N = mkN "动脉瘤" ; -- open-multilingual-wordnet
lin aneurysmal_A = mkA "动脉瘤" ; -- open-multilingual-wordnet
lin anew_Adv = mkAdv "重新" ;
lin anfractuous_A = mkA "多弯曲" | mkA "曲折" ; -- open-multilingual-wordnet
lin angel_N = mkN "天使" ;
lin angela_PN = foreignPN "Angela" ; -- comment=src=eng status=guess
lin angelim_N = mkN "瓣豆" ; -- open-multilingual-wordnet
lin angelology_N = mkN "天使学" ; -- open-multilingual-wordnet
lin anger_N = mkN "愤怒" [] ;
lin anger_V2 = mkV2 "激怒" ;
lin angers_PN = mkPN "昂热" ; -- comment=src=geonames status=guess
lin angie_PN = foreignPN "Angie" ; -- comment=src=eng status=guess
lin angiitis_N = mkN "脉管炎" ; -- open-multilingual-wordnet
lin angina_N = mkN "心绞痛" ;
lin anginal_A = mkA "心绞痛" ; -- open-multilingual-wordnet
lin angiocardiogram_N = mkN "心血X光照片" | mkN "心血管照片" ; -- open-multilingual-wordnet
lin angiocarp_N = mkN "果实有壳的植物" ; -- open-multilingual-wordnet
lin angiocarpic_A = mkA "果实有壳" | mkA "被子实体" ; -- open-multilingual-wordnet
lin angiogenesis_N = mkN "血管再生术" | mkN "血管形成" ; -- open-multilingual-wordnet
lin angiogram_N = mkN "血管造影照片" ; -- open-multilingual-wordnet
lin angiography_N = mkN "血管造影术" ; -- open-multilingual-wordnet
lin angiologist_N = mkN "心血管疾病专家" ; -- open-multilingual-wordnet
lin angiology_N = mkN "脉管学" ; -- open-multilingual-wordnet
lin angioma_N = mkN "血管瘤" ; -- open-multilingual-wordnet
lin angiomatous_A = mkA "血管瘤" ; -- open-multilingual-wordnet
lin angiopathy_N = mkN "血管疾病" ; -- open-multilingual-wordnet
lin angiosarcoma_N = mkN "血管肉瘤" ; -- open-multilingual-wordnet
lin angiosperm_N = mkN "被子植物" ; -- open-multilingual-wordnet
lin angle_N = mkN "天使" | {-HSK-} mkN "角" "個" | mkN "角度" ;
lin angle_dozer_N = mkN "一种推土机" | mkN "万能推土机" | mkN "侧推式推土机" | mkN "侧铲推土机" | mkN "斜角推土机" ; -- open-multilingual-wordnet
lin anglicism_N = mkN "英國英語" | mkN "英国英语" | mkN "英式用語" | mkN "英式用语" | mkN "英國特色" | mkN "英国特色" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin angling_N = mkN "钓鱼" ;
lin anglophilFem_N = mkN "亲英派的人" ; -- open-multilingual-wordnet
lin anglophilMasc_N = mkN "亲英派的人" ; -- open-multilingual-wordnet
lin anglophileFem_N = mkN "亲英派的人" ; -- open-multilingual-wordnet
lin anglophileMasc_N = mkN "亲英派的人" ; -- open-multilingual-wordnet
lin anglophobe_N = mkN "反英份子" ; -- open-multilingual-wordnet
lin angola_PN = mkPN "安哥拉" ; -- comment=src=geonames status=guess
lin angolan_A = mkA "安哥拉" ;
lin angora_N = mkN "安哥拉" ;
lin angrecum_N = mkN "风兰" ; -- open-multilingual-wordnet
lin angry_A = mkA "愤怒" | {-HSK-} mkA "生气" ;
lin angst_N = mkN "焦虑" [] ;
lin angstrom_N = mkN "埃格斯特朗" | mkN "埃" ; -- status=guess -- status=guess
lin anguilla_PN = mkPN "安圭拉" ; -- comment=src=geonames status=guess
lin anguine_A = mkA "似蛇" | mkA "蛇" ; -- open-multilingual-wordnet
lin anguish_N = mkN "痛苦" ;
lin anguished_A = mkA "苦涩" ;
lin angular_A = mkA "有尖角" | mkA "有角" ; -- open-multilingual-wordnet
lin angulation_N = mkN "使成角" | mkN "成角" ; -- open-multilingual-wordnet
lin angus_PN = foreignPN "Angus" ; -- comment=src=geonames status=guess
lin anhedonia_N = mkN "快感缺乏" ; -- open-multilingual-wordnet
lin anhidrosis_N = mkN "无汗症" | mkN "闭汗症" ; -- open-multilingual-wordnet
lin anhydride_N = mkN "酐" | mkN "酸酐" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anhydrous_A = mkA "无水" | mkA "贫水" ; -- open-multilingual-wordnet
lin ani_N = mkN "美洲黑杜鹃" ; -- open-multilingual-wordnet
lin anile_A = mkA "似老妪" ; -- open-multilingual-wordnet
lin aniline_N = mkN "苯胺" ; -- open-multilingual-wordnet
lin anima_N = mkN "灵魂" ; -- open-multilingual-wordnet
lin animadvert_V = mkV "批评" | mkV "谴责" ; -- open-multilingual-wordnet
lin animal_A = mkA "动物" ;
lin animal_N = L.animal_N | {-HSK-} mkN "动物" "隻" ;
lin animalcule_N = mkN "微动物" | mkN "微生物" ; -- open-multilingual-wordnet
lin animalistic_A = mkA "兽性" ; -- open-multilingual-wordnet
lin animate_A = mkA "有活力" ; -- status=guess
lin animate_V2 = mkV2 "使+有生气" ;
lin animatedly_A = variants {} ;
lin animatedly_Adv = adjAdv animatedly_A ; -- derived
lin animating_A = mkA "有生气" | mkA "活泼" ; -- open-multilingual-wordnet
lin animation_N = mkN "动画" | {-HSK-} mkN "动画片" | mkN "生气" ;
lin animatistic_A = mkA "万物有灵论" ; -- open-multilingual-wordnet
lin animator_N = mkN "動畫製作者" | mkN "动画制作者" | {-mwn-} mkN "漫画制作者" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin animatronics_N = mkN "动画电子学" ; -- open-multilingual-wordnet
lin anime_N = mkN "日本動畫" | mkN "日本动画" | mkN "動畫" | mkN "动画" | mkN "日本卡通" | mkN "日式動畫" | mkN "日式动画" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin animism_N = mkN "万物有灵论" ; -- open-multilingual-wordnet
lin animist_A = mkA "万物有灵论" ; -- open-multilingual-wordnet
lin animist_N = mkN "万物有灵论者" ; -- open-multilingual-wordnet
lin animosity_N = mkN "憎恶" ;
lin animus_N = mkN "敌意" ; -- open-multilingual-wordnet
lin anion_N = mkN "陰離子" | mkN "阴离子" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anionic_A = mkA "阴离子" ; -- open-multilingual-wordnet
lin anise_N = mkN "八角" "个" ;
lin aniseed_N = mkN "八角" | {-mwn-} mkN "大茴香" | mkN "大茴香籽" ; -- status=guess -- open-multilingual-wordnet
lin aniseikonia_N = mkN "异像" ; -- open-multilingual-wordnet
lin aniseikonic_A = mkA "两眼物像不等症" | mkA "左右异像症" ; -- open-multilingual-wordnet
lin anisette_N = mkN "茴香酒" ; -- open-multilingual-wordnet
lin anisogametic_A = mkA "异型配子" ; -- open-multilingual-wordnet
lin anisogamic_A = mkA "异形配子" ; -- open-multilingual-wordnet
lin anisogamy_N = mkN "异配生植" | mkN "配子异型" ; -- open-multilingual-wordnet
lin anisometric_A = mkA "不均匀" | mkA "不调和" | mkA "非对称" ; -- open-multilingual-wordnet
lin anisometropia_N = mkN "两眼屈光不等" | mkN "屈光参差" ; -- open-multilingual-wordnet
lin anisometropic_A = mkA "屈光参差" ; -- open-multilingual-wordnet
lin anisotropic_A = mkA "各向异性" ; -- open-multilingual-wordnet
lin anisotropy_N = mkN "各项异性" ; -- status=guess
lin anita_PN = foreignPN "Anita" ; -- comment=src=eng status=guess
lin anjou_N = mkN "安茹梨" ; -- open-multilingual-wordnet
lin ankara_PN = mkPN "安卡拉" ; -- comment=src=geonames status=guess
lin ankle_N = mkN "患关节" ;
lin anklebone_N = mkN "距骨" ; -- status=guess
lin anklet_N = mkN "腳鐲" | mkN "脚镯" | {-mwn-} mkN "踝环" | mkN "踝饰" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ankylosaur_N = mkN "甲龙亚目" ; -- open-multilingual-wordnet
lin ankylosis_N = mkN "关节僵硬" ; -- open-multilingual-wordnet
lin ankylotic_A = mkA "关节强硬" ; -- open-multilingual-wordnet
lin ann_PN = foreignPN "Ann" ; -- comment=src=eng status=guess
lin anna_N = mkN "安娜" ; -- open-multilingual-wordnet
lin annabel_PN = foreignPN "Annabel" ; -- comment=src=eng status=guess
lin annalist_N = mkN "纪年表编者" | mkN "编年史作者" ; -- open-multilingual-wordnet
lin annalistic_A = mkA "有编年史特点" | mkA "编年史" ; -- open-multilingual-wordnet
lin annan_PN = mkPN "安南乡" ; -- comment=src=geonames status=guess
lin anne_PN = foreignPN "Anne" ; -- comment=src=eng status=guess
lin annealing_N = mkN "低温退火" | mkN "回火" | mkN "回火硬化" | mkN "淬硬" | mkN "热处理" | mkN "退火" | mkN "退火处理" ; -- open-multilingual-wordnet
lin annelid_A = mkA "环节动物" ; -- open-multilingual-wordnet
lin annelid_N = mkN "环节动物" ; -- open-multilingual-wordnet
lin annex_N = mkN "附件" ;
lin annexation_N = mkN "併吞" | mkN "并吞" | mkN "合併" | mkN "合并" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin annexational_A = mkA "合并" ; -- open-multilingual-wordnet
lin annexe_N = mkN "附属建筑" | mkN "附属建筑物" ; -- open-multilingual-wordnet
lin annfield_PN = foreignPN "Annfield" ; -- comment=src=eng status=guess
lin annfield_plain_PN = foreignPN "Annfield plain" ; -- comment=src=eng status=guess
lin annie_PN = foreignPN "Annie" ; -- comment=src=eng status=guess
lin annihilate_V2 = mkV2 "使+歼灭" | {-HSK-} mkV2 "消灭" ;
lin annihilator_N = mkN "歼灭者" | mkN "破坏者" ; -- open-multilingual-wordnet
lin anniversary_N = mkN "周年" ;
lin annotation_N = mkN "註解" | mkN "注解" | {-mwn-} mkN "注释" | mkN "评注" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin annotator_N = mkN "注解者" | mkN "注释者" | mkN "评注者" ; -- open-multilingual-wordnet
lin announce_V2 = mkV2 "公布" | mkV2 "宣布" | mkV2 "布" ;
lin announce_VS = mkVS "公布" | mkVS "宣布" | mkVS "布" ;
lin announcement_N = mkN "公告" ;
lin announcer_N = mkN "播音员" ;
lin annoy_V2 = mkV2 "惹恼" ;
lin annoyance_N = mkN "烦恼" | {-mwn-} mkN "恼怒" | mkN "恼火" ; -- open-multilingual-wordnet
lin annoying_A = mkA "恼人" ;
lin annual_A = mkA "周年" ;
lin annual_N = mkN "年度報告" | mkN "年度报告" | mkN "年報" | mkN "年报" | {-mwn-} mkN "年刊" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin annuitant_N = mkN "领受养老金者" | mkN "领年金者" ; -- open-multilingual-wordnet
lin annuity_N = mkN "年金" ;
lin annul_V2 = mkV2 (mkV "廢除") | mkV2 (mkV "废除") | mkV2 (mkV "取消") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin annular_A = mkA "圆形" | mkA "有环" | mkA "环形" | mkA "轮状" ; -- open-multilingual-wordnet
lin annulet_N = mkN "小环" | mkN "小轮" ; -- open-multilingual-wordnet
lin annum_N = mkN "岁" | mkN "年" ; -- open-multilingual-wordnet
lin annunciation_N = mkN "公告" | mkN "声明" | mkN "宣言" | mkN "布告" ; -- open-multilingual-wordnet
lin annunciator_N = mkN "信号器" | mkN "指示器" | mkN "示号器" ; -- open-multilingual-wordnet
lin annunciatory_A = mkA "可预告作用" | mkA "预告" ; -- open-multilingual-wordnet
lin anoa_N = mkN "倭水牛" ; -- status=guess
lin anode_N = mkN "陽極" | mkN "阳极" ; -- status=guess -- status=guess
lin anodic_A = mkA "阳极" ; -- open-multilingual-wordnet
lin anodyne_A = mkA "不痛" | mkA "止痛" ; -- open-multilingual-wordnet
lin anoint_V2 = mkV2 "涂油于" ;
lin anointer_N = mkN "涂油的人" ; -- open-multilingual-wordnet
lin anointing_N = mkN "涂油" ; -- open-multilingual-wordnet
lin anointment_N = mkN "涂油" ; -- open-multilingual-wordnet
lin anomalous_A = mkA "异常" ;
lin anomaly_N = mkN "异常" ;
lin anon_PN = foreignPN "Anon" ; -- comment=src=eng status=guess
lin anonymity_N = mkN "匿名" ;
lin anonymous_A = mkA "匿名" ;
lin anoperineal_A = mkA "肛门会阴" ; -- open-multilingual-wordnet
lin anopheles_N = mkN "按蚊" | mkN "瘧蚊" | mkN "疟蚊" ; -- status=guess -- status=guess -- status=guess
lin anopheline_A = mkA "按蚊" ; -- open-multilingual-wordnet
lin anopheline_N = mkN "疟蚊" ; -- open-multilingual-wordnet
lin anopia_N = mkN "色盲" ; -- open-multilingual-wordnet
lin anorak_N = mkN "皮猴兒" | mkN "皮猴儿" ; -- status=guess -- status=guess
lin anorchism_N = mkN "无睾" ; -- open-multilingual-wordnet
lin anorectal_A = mkA "肛门直肠" ; -- open-multilingual-wordnet
lin anorexia_N = mkN "厭食症" | mkN "厌食症" | {-mwn-} mkN "厌食" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anorexic_A = mkA "厭食症患者" | mkA "厌食症患者" | {-mwn-} mkA "厌食" | mkA "食欲缺乏" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anorexic_N = mkN "厌食症患者" ; -- open-multilingual-wordnet
lin anorgasmia_N = mkN "性快感缺失" | mkN "性感缺失病" ; -- open-multilingual-wordnet
lin anorthite_N = mkN "钙长石" ; -- open-multilingual-wordnet
lin anorthitic_A = mkA "钙长石" ; -- open-multilingual-wordnet
lin anorthopia_N = mkN "不正视" ; -- open-multilingual-wordnet
lin anosmia_N = mkN "嗅觉丧失症" | mkN "嗅觉缺失" ; -- open-multilingual-wordnet
lin another_Det = mkpDet "他" | mkpDet "再" | mkpDet "别" | {-HSK-} mkpDet "其他" ;
lin another_Quant = mkQuant "另一" ;
lin anovulation_N = mkN "停止排卵" | mkN "排卵停止" | mkN "排卵抑制" ; -- open-multilingual-wordnet
lin anoxemia_N = mkN "缺氧血症" | mkN "血缺氧" ; -- open-multilingual-wordnet
lin anoxemic_A = mkA "缺氧血症" | mkA "血缺氧" ; -- open-multilingual-wordnet
lin anoxia_N = mkN "氧不足" | mkN "缺氧症" ; -- open-multilingual-wordnet
lin anoxic_A = mkA "缺氧" ;
lin anserine_A = mkA "像鹅" | mkA "鹅似" ; -- open-multilingual-wordnet
lin anshan_PN = mkPN ("鞍山市" | "安山镇") ; -- comment=src=geonames status=guess
lin answer_N = mkN "回答" | {-HSK-} mkN "答案" "個" ;
lin answer_V = mkV "回" | mkV "回答" | mkV "对" | mkV "接" ;
lin answer_V2 = mkV2 "回" | mkV2 "回答" | mkV2 "对" | mkV2 "接" ;
lin answer_V2S = L.answer_V2S ;
lin answer_back_V2 = mkV2 (advV OP_answer_V OP_back_Adv ) ; -- guess-p-verb
lin answer_for_V2 = prepV2 OP_answer_V OP_for_Prep ; -- guess-p-verb
lin answerable_A = mkA "应负责任" ;
lin ant_N = mkN "蚂蚁" ;
lin antacid_A = mkA "中和酸性" | mkA "抗酸性" ; -- open-multilingual-wordnet
lin antacid_N = mkN "抑酸劑" | mkN "抑酸剂" ; -- status=guess -- status=guess
lin antagonism_N = mkN "對抗" | mkN "对抗" | {-mwn-} mkN "对抗作用" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin antagonist_N = mkN "敌手" ;
lin antagonistic_A = mkA "抵抗" ;
lin antagonize_V2 = mkV2 "对抗" ;
lin antapex_N = mkN "背点" ; -- open-multilingual-wordnet
lin antbird_N = mkN "蚁鸟" ; -- open-multilingual-wordnet
lin ante_N = mkN "赌注" ;
lin ant_eater_N = mkN "食蟻獸" | mkN "食蚁兽" ; -- status=guess -- status=guess
lin antecedent_N = mkN "前情" ;
lin antechamber_N = mkN "休息室" | mkN "前厅" | mkN "前庭" | mkN "大厅" | mkN "接待室" | mkN "门厅" ; -- open-multilingual-wordnet
lin antecubital_A = mkA "肘前" ; -- open-multilingual-wordnet
lin antediluvian_N = mkN "年迈的人" | mkN "很老的人" ; -- open-multilingual-wordnet
lin antefix_N = mkN "檐口饰" | mkN "瓦檐饰" ; -- open-multilingual-wordnet
lin antelope_N = mkN "羚羊" ;
lin antenna_N = mkN "觸角" | mkN "触角" ; -- status=guess -- status=guess
lin antennal_A = mkA "天线" | mkA "触角" ; -- open-multilingual-wordnet
lin antepenultimate_A = mkA "倒数第三" ; -- open-multilingual-wordnet
lin anterior_A = mkA "前面" ; -- status=guess
lin anteroom_N = mkN "休息室" | mkN "前厅" | mkN "前庭" | mkN "大厅" | mkN "接待室" | mkN "门厅" ; -- open-multilingual-wordnet
lin anthea_PN = foreignPN "Anthea" ; -- comment=src=eng status=guess
lin anthelmintic_A = mkA "可驱除肠内虫子" | mkA "驱虫" ; -- open-multilingual-wordnet
lin anthem_N = mkN "圣歌" ;
lin anther_N = mkN "花药" " " ;
lin antheral_A = mkA "有雄性花蕊" ; -- open-multilingual-wordnet
lin antheridial_A = mkA "精子囊" ; -- open-multilingual-wordnet
lin antheridiophore_N = mkN "精子器柄" ; -- open-multilingual-wordnet
lin antherozoid_N = mkN "游动精子" ; -- open-multilingual-wordnet
lin ant_hill_N = mkN "蟻丘" | mkN "蚁丘" | {-mwn-} mkN "蚁窝" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anthologist_N = mkN "选集的编者" ; -- open-multilingual-wordnet
lin anthology_N = mkN "选集" ;
lin anthony_PN = foreignPN "Anthony" ; -- comment=src=geonames status=guess
lin anthophyllite_N = mkN "直闪石" ; -- open-multilingual-wordnet
lin anthozoan_N = mkN "珊瑚虫" ; -- open-multilingual-wordnet
lin anthracite_N = mkN "無煙煤" | mkN "无烟煤" | {-mwn-} mkN "硬煤" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anthracitic_A = mkA "似无烟煤" | mkA "无烟煤" ; -- open-multilingual-wordnet
lin anthracosis_N = mkN "煤肺病" ; -- open-multilingual-wordnet
lin anthrax_N = mkN "炭疽" ;
lin anthropic_A = mkA "人类" | mkA "有关人类" ; -- open-multilingual-wordnet
lin anthropocentric_A = mkA "以人类为中心" | mkA "以人类为中心" ; -- open-multilingual-wordnet
lin anthropogenesis_N = mkN "人类起源" ; -- open-multilingual-wordnet
lin anthropogenetic_A = mkA "人类起源" ; -- open-multilingual-wordnet
lin anthropoid_A = mkA "似人" | mkA "似人类" | mkA "类人" ; -- open-multilingual-wordnet
lin anthropolatry_N = mkN "人类崇拜" ; -- open-multilingual-wordnet
lin anthropological_A = mkA "人类学" ; -- open-multilingual-wordnet
lin anthropologistFem_N = mkN "人类学家" ; -- open-multilingual-wordnet
lin anthropologistMasc_N = mkN "人类学家" ; -- open-multilingual-wordnet
lin anthropology_N = mkN "人類學" | mkN "人类学" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anthropometric_A = mkA "人体测量" ; -- open-multilingual-wordnet
lin anthropometry_N = mkN "人体测量学" ; -- open-multilingual-wordnet
lin anthropomorphic_A = mkA "赋予人性" ; -- open-multilingual-wordnet
lin anthropomorphism_N = mkN "擬人論" | mkN "拟人论" | {-mwn-} mkN "拟人" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anthropophagous_A = mkA "食人" ; -- open-multilingual-wordnet
lin anthurium_N = mkN "球心花饰" | mkN "白星海" ; -- open-multilingual-wordnet
lin anti_A = mkA "反戰" | mkA "反战" | {-mwn-} mkA "反" | mkA "反对" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin anti_N = mkN "反美" | mkN "反美勢力" | mkN "反美势力" ; -- status=guess -- status=guess -- status=guess
lin anti_aircraft_A = mkA "反飞机" | mkA "防空" ; -- open-multilingual-wordnet
lin anti_aircraft_N = mkN "防空兵器" | mkN "高射炮" ; -- open-multilingual-wordnet
lin anti_semitic_A = mkA "反犹主义" ;
lin antiadrenergic_A = mkA "抗肾上腺素能" ; -- open-multilingual-wordnet
lin antialiasing_N = mkN "反图像失真" | mkN "反混淆" ; -- open-multilingual-wordnet
lin antiapartheid_A = mkA "反种族隔离" ; -- open-multilingual-wordnet
lin antibacterial_A = mkA "抗菌" ; -- open-multilingual-wordnet
lin antibaryon_N = mkN "反重子" ; -- open-multilingual-wordnet
lin antibiosis_N = mkN "抗生" | mkN "抗生作用" | mkN "抗菌作用" ; -- open-multilingual-wordnet
lin antibiotic_A = mkA "抗菌" ;
lin antibiotic_N = mkN "抗生素" ;
lin antibody_N = mkN "抗体" ;
lin antic_A = mkA "滑稽" | mkA "荒诞不经" ; -- open-multilingual-wordnet
lin antic_N = mkN "滑稽" "" ;
lin anticancer_A = mkA "抗癌" | mkA "抗癌抗菌素" ; -- open-multilingual-wordnet
lin anticatalyst_N = mkN "反催化剂" ; -- open-multilingual-wordnet
lin anticholinergic_N = mkN "抗胆碱能药物" ; -- open-multilingual-wordnet
lin anticholinesterase_N = mkN "抗胆碱酯酶" ; -- open-multilingual-wordnet
lin anticipant_A = mkA "预期" ; -- open-multilingual-wordnet
lin anticipate_V = mkV "预料" ;
lin anticipate_V2 = mkV2 "预料" ;
lin anticipate_VS = mkVS "预料" ;
lin anticipate_VV = mkVV "预期" ;
lin anticipation_N = mkN "预期" ;
lin anticipator_N = mkN "先发制人者" | mkN "占先者" | mkN "预期者" ; -- open-multilingual-wordnet
lin anticlimactic_A = mkA "虎头蛇尾" ;
lin anticlimax_N = mkN "令人泄气的转变" | mkN "突降法" ; -- open-multilingual-wordnet
lin anticlockwise_Adv = mkAdv "反時針方向的" | mkAdv "反时针方向的" | mkAdv "逆時針的" | mkAdv "逆时针的" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin anticoagulant_N = mkN "抗凝血剂" ; -- open-multilingual-wordnet
lin anticoagulation_N = mkN "抗凝血" | mkN "防止凝血的" ; -- open-multilingual-wordnet
lin anticoagulative_A = mkA "防止凝血" ; -- open-multilingual-wordnet
lin anticonvulsant_N = mkN "抗惊厥的药物" | mkN "抗痉挛剂" | mkN "抗痉挛的药物" ; -- open-multilingual-wordnet
lin anticyclone_N = mkN "反氣旋" | mkN "反气旋" | mkN "高氣壓" | mkN "高气压" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin antidepressant_N = mkN "抗抑鬱藥" | mkN "抗抑郁药" | {-mwn-} mkN "抗抑郁剂" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin antidiabetic_N = mkN "抗糖尿病药" | mkN "抗糖尿病药物" ; -- open-multilingual-wordnet
lin antidiarrheal_N = mkN "抗腹泻药剂" | mkN "止泻药" ; -- open-multilingual-wordnet
lin antidiuretic_N = mkN "尿分泌抑制剂" | mkN "抗利尿剂" ; -- open-multilingual-wordnet
lin antidotal_A = mkA "解毒" ; -- open-multilingual-wordnet
lin antidote_N = mkN "解药" ;
lin antidromic_A = mkA "逆向" ; -- open-multilingual-wordnet
lin antiemetic_N = mkN "止吐剂" | mkN "止呕吐的药" ; -- open-multilingual-wordnet
lin antifeminist_N = mkN "反女权主义" ; -- open-multilingual-wordnet
lin antiferromagnetic_A = mkA "反铁磁性" ; -- open-multilingual-wordnet
lin antiferromagnetism_N = mkN "反铁磁性" ; -- open-multilingual-wordnet
lin antiflatulent_N = mkN "抗气胀药" | mkN "抗肠胃气胀药" | mkN "抗胃肠药" ; -- open-multilingual-wordnet
lin antifreeze_N = mkN "防冻剂" "瓶" ;
lin antifungal_N = mkN "抗真菌药" | mkN "抗霉菌药" | mkN "杀真菌药" | mkN "杀菌剂" ; -- open-multilingual-wordnet
lin antigen_N = mkN "抗原" ; -- open-multilingual-wordnet
lin antigenic_A = mkA "抗原" | mkA "抗原性" ; -- open-multilingual-wordnet
lin antigua_PN = foreignPN "Antigua" ; -- comment=src=geonames status=guess
lin anti_hero_N = mkN "反英雄" ; -- open-multilingual-wordnet
lin antihistamine_N = mkN "抗組織胺藥" | mkN "抗组织胺药" | {-mwn-} mkN "抗组织胺剂" | mkN "抗组胺剂" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin antihypertensive_N = mkN "抗高血压的药" | mkN "抗高血压药" | mkN "降压药" ; -- open-multilingual-wordnet
lin antiknock_A = mkA "抗爆" | mkA "抗震" ; -- open-multilingual-wordnet
lin antiknock_N = mkN "抗爆剂" | mkN "抗震剂" ; -- open-multilingual-wordnet
lin antilepton_N = mkN "反轻子" ; -- open-multilingual-wordnet
lin antimacassar_N = mkN "椅子罩子" | mkN "椅背套" | mkN "防污方巾" | mkN "靠垫花边" ; -- open-multilingual-wordnet
lin antimagnetic_A = mkA "反磁性" ; -- open-multilingual-wordnet
lin antimalarial_N = mkN "抗疟药" | mkN "防治疟疾药" ; -- open-multilingual-wordnet
lin antimatter_N = mkN "反物質" | mkN "反物质" ; -- status=guess -- status=guess
lin antimeson_N = mkN "反介子" ; -- open-multilingual-wordnet
lin antimetabolite_N = mkN "代谢拮抗物" | mkN "抗代谢物" | mkN "抗代谢药" ; -- open-multilingual-wordnet
lin antimicrobial_A = mkA "抗微生物" ; -- open-multilingual-wordnet
lin antimonial_A = mkA "含锑" ; -- open-multilingual-wordnet
lin antimonic_A = mkA "亚锑" | mkA "含锑" ; -- open-multilingual-wordnet
lin antimony_N = mkN "銻" | mkN "锑" ; -- status=guess -- status=guess
lin antimycin_N = mkN "抗霉素" ; -- open-multilingual-wordnet
lin antineoplastic_N = mkN "抗肿瘤药" ; -- open-multilingual-wordnet
lin antineutrino_N = mkN "反中微子" ; -- open-multilingual-wordnet
lin antineutron_N = mkN "反中子" ; -- open-multilingual-wordnet
lin antinode_N = mkN "波腹" | mkN "腹点" ; -- open-multilingual-wordnet
lin antinomasia_N = mkN "换称" ; -- open-multilingual-wordnet
lin antinomian_A = mkA "主张废弃道德律" | mkA "反对遵从道德" | mkA "唯信仰主义" | mkA "唯信仰论" ; -- open-multilingual-wordnet
lin antinomian_N = mkN "主张废弃道德律的人" | mkN "反律法主义者" | mkN "持惟信仰论者" ; -- open-multilingual-wordnet
lin antinomy_N = mkN "二律相悖" | mkN "二律背反" ; -- open-multilingual-wordnet
lin antioxidant_N = mkN "抗氧化劑" | mkN "抗氧化剂" | {-mwn-} mkN "阻氧化剂" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin antiparallel_A = mkA "反平行" ; -- open-multilingual-wordnet
lin antiparticle_N = mkN "反粒子" ; -- open-multilingual-wordnet
lin antipasto_N = mkN "意大利式餐前小吃" | mkN "拼盤" | mkN "拼盘 ， 冷盤" | mkN "冷盘" | {-mwn-} mkN "前菜" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin antipathetic_A = mkA "厌恶" | mkA "反感" ; -- open-multilingual-wordnet
lin anti_personnel_A = mkA "杀伤性" ; -- open-multilingual-wordnet
lin antiperspirant_N = mkN "止汗剂" | mkN "腋下除汗剂" ; -- open-multilingual-wordnet
lin antiphlogistic_A = mkA "抗发炎" | mkA "消炎" ; -- open-multilingual-wordnet
lin antiphon_N = mkN "交互轮唱的歌" | mkN "唱和" ; -- open-multilingual-wordnet
lin antiphonary_A = mkA "交互轮唱" | mkA "启应轮流吟唱" | mkA "应答轮唱" ; -- open-multilingual-wordnet
lin antiphonary_N = mkN "唱和圣歌诗集" ; -- open-multilingual-wordnet
lin antiphrasis_N = mkN "反用法" | mkN "反语法" ; -- open-multilingual-wordnet
lin antipodal_A = mkA "处于正相对位置" | mkA "对跖" | mkA "对踵" | mkA "正相反" ; -- open-multilingual-wordnet
lin antipodal_N = mkN "正对" ; -- open-multilingual-wordnet
lin antipode_N = mkN "恰恰相反者" | mkN "正相反的事物" ; -- open-multilingual-wordnet
lin antipollution_A = mkA "反污染" ; -- open-multilingual-wordnet
lin antiproton_N = mkN "反质子" ; -- open-multilingual-wordnet
lin antiprotozoal_N = mkN "抗原生动物剂" | mkN "抗原生动物药" ; -- open-multilingual-wordnet
lin antipruritic_N = mkN "止痒剂" | mkN "止痒药" ; -- open-multilingual-wordnet
lin antipyresis_N = mkN "退热法" ; -- open-multilingual-wordnet
lin antipyretic_A = mkA "退热" ; -- open-multilingual-wordnet
lin antipyretic_N = mkN "解热药" | mkN "解热药剂" | mkN "退烧药" | mkN "退热药" | mkN "退热药剂" ; -- open-multilingual-wordnet
lin antiquarian_N = mkN "古物研究者" | mkN "收集古物者" ; -- open-multilingual-wordnet
lin antiquark_N = mkN "反夸克" ; -- open-multilingual-wordnet
lin antiquary_N = mkN "古物研究者" | mkN "收集古物者" ; -- open-multilingual-wordnet
lin antiquated_A = mkA "废弃" ;
lin antique_A = mkA "古老" ;
lin antique_N = mkN "古董" ;
lin antiquity_N = mkN "古物" ;
lin antiseptic_N = mkN "抗菌剂" | mkN "防腐剂" ; -- open-multilingual-wordnet
lin antisocial_A = mkA "反社会" ;
lin antispasmodic_N = mkN "止痉挛的药" | mkN "解痉药" | mkN "解痉药剂" | mkN "镇痉药剂" ; -- open-multilingual-wordnet
lin antistrophic_A = mkA "对唱" ; -- open-multilingual-wordnet
lin antisyphilitic_N = mkN "驱梅" "次" ;
lin antitank_A = mkA "反坦克" | mkA "对抗战车用" | mkA "防坦克" ; -- open-multilingual-wordnet
lin antitauon_N = mkN "反轻子" ; -- open-multilingual-wordnet
lin antithesis_N = mkN "對照" | mkN "对照" | mkN "對立" | mkN "对立" | mkN "對偶" | mkN "对偶" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin antithetic_A = mkA "对照" | mkA "对立" | mkA "正相反" ; -- open-multilingual-wordnet
lin antithetical_A = mkA "正相反" ;
lin antithyroid_A = mkA "抗甲状腺" ; -- open-multilingual-wordnet
lin antitoxic_A = mkA "抗毒素" ; -- open-multilingual-wordnet
lin antitoxin_N = mkN "抗毒素" ; -- open-multilingual-wordnet
lin antitrade_N = mkN "反信风" ; -- open-multilingual-wordnet
lin antitussive_N = mkN "止咳剂" | mkN "止咳药" | mkN "镇咳药" | mkN "镇咳药剂" ; -- open-multilingual-wordnet
lin antitype_N = mkN "反式" | mkN "对型" ; -- open-multilingual-wordnet
lin antitypic_A = mkA "反式" ; -- open-multilingual-wordnet
lin antivenin_N = mkN "抗蛇毒素" | mkN "抗蛇毒血清" ; -- open-multilingual-wordnet
lin antiviral_A = mkA "抗病毒" ; -- open-multilingual-wordnet
lin antiviral_N = mkN "抗病毒物质" | mkN "抗病毒素" | mkN "抗病毒药" ; -- open-multilingual-wordnet
lin antler_N = mkN "鹿角" | mkN "角" ; -- status=guess -- status=guess
lin antlered_A = mkA "带鹿角" | mkA "有鹿角" ; -- open-multilingual-wordnet
lin antony_PN = foreignPN "Antony" ; -- comment=src=geonames status=guess
lin antonym_N = mkN "反義詞" | mkN "反义词" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin antonymous_A = mkA "反义" ; -- open-multilingual-wordnet
lin antonymy_N = mkN "反义" ; -- open-multilingual-wordnet
lin antrim_PN = foreignPN "Antrim" ; -- comment=src=geonames status=guess
lin antwerp_PN = foreignPN "Antwerp" ; -- comment=src=geonames status=guess
lin anuran_A = mkA "无尾两栖类" | mkA "蛙类" | mkA "蟾蜍类" ; -- open-multilingual-wordnet
lin anuresis_N = mkN "无尿" ; -- open-multilingual-wordnet
lin anuretic_A = mkA "尿闭" | mkA "无尿" | mkA "无尿症" ; -- open-multilingual-wordnet
lin anus_N = mkN "肛門" | mkN "肛门" | mkN "糞門" | mkN "粪门" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin anvil_N = mkN "铁砧" ; -- status=guess
lin anxiety_N = mkN "焦虑" [] ;
lin anxiolytic_A = mkA "抗焦虑" ; -- open-multilingual-wordnet
lin anxious_A = mkA "担心" | {-HSK-} mkA "焦急" ;
lin anxiousness_N = mkN "不安" | mkN "忧虑" | mkN "焦虑" ; -- open-multilingual-wordnet
lin anyPl_Det = mkpDet "任意" ;
lin anySg_Det = mkpDet "任一个" ;
lin any_Adv = mkAdv "任何" ;
lin anybody_NP = mkNPword "任何人" ;
lin anyhow_Adv = mkAdv "无论如何" ;
lin anymore_Adv = mkAdv "不再" ;
lin anyone_NP = mkNPword "任何人" ;
lin anything_NP = mkNPword "任何事情" ;
lin anyway_Adv = mkAdv "反正" | {-HSK-} mkAdv "无论如何" ;
lin anywhere_Adv = mkAdv "哪儿" | {-HSK-} mkAdv "随地" ;
lin aorist_N = mkN "不定過去時" | mkN "不定过去时" | {-mwn-} mkN "不定过去式" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aoristic_A = mkA "不定过去时" ; -- open-multilingual-wordnet
lin aorta_N = mkN "大動脈" | mkN "大动脉" ; -- status=guess -- status=guess
lin aortal_A = mkA "主动脉" | mkA "大动脉" ; -- open-multilingual-wordnet
lin aortitis_N = mkN "主动脉动脉炎" ; -- open-multilingual-wordnet
lin apart_Adv = mkAdv "隔开" ;
lin apart_from_Prep = mkPrep "除了" ;
lin apartheid_N = mkN "种族隔离" [] ;
lin apartment_N = L.apartment_N ;
lin apathetic_A = mkA "冷漠" ;
lin apathy_N = mkN "冷漠" "种" ;
lin apatite_N = mkN "磷灰石" ; -- open-multilingual-wordnet
lin ape_N = mkN "無尾猿" | mkN "无尾猿" | mkN "類人猿" | mkN "类人猿" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin apeldoorn_PN = mkPN "阿珀尔多伦" ; -- comment=src=geonames status=guess
lin apercu_N = mkN "梗概" ; -- open-multilingual-wordnet
lin aperient_A = mkA "轻泻" ; -- open-multilingual-wordnet
lin aperiodic_A = mkA "非周期" | mkA "非周期性" ; -- open-multilingual-wordnet
lin aperitif_N = mkN "开胃酒" ; -- open-multilingual-wordnet
lin aperture_N = mkN "光圈" ; -- status=guess
lin apery_N = mkN "模仿" ; -- open-multilingual-wordnet
lin apetalous_A = mkA "无花瓣" ; -- open-multilingual-wordnet
lin apex_N = mkN "葉尖" | mkN "叶尖" | {-HSK-} mkN "顶" | {-mwn-} mkN "向点" | mkN "奔赴点" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aphaeresis_N = mkN "字首音省略" | mkN "词首省略" ; -- open-multilingual-wordnet
lin aphagia_N = mkN "吞咽不能" ; -- open-multilingual-wordnet
lin aphakia_N = mkN "少晶状体" ; -- open-multilingual-wordnet
lin aphakic_A = mkA "无晶状体" ; -- open-multilingual-wordnet
lin aphakic_N = mkN "无晶状体" | mkN "盲人" ; -- open-multilingual-wordnet
lin aphanite_N = mkN "隐晶岩" | mkN "非显晶岩" ; -- open-multilingual-wordnet
lin aphanitic_A = mkA "隐晶" | mkA "隐晶岩" | mkA "非显晶" | mkA "非显晶岩" | mkA "非显晶质" ; -- open-multilingual-wordnet
lin aphasia_N = mkN "失语症" ; -- open-multilingual-wordnet
lin aphasic_N = mkN "失语症患者" ; -- open-multilingual-wordnet
lin aphelion_N = mkN "遠日點" | mkN "远日点" ; -- status=guess -- status=guess
lin apheresis_N = mkN "单采血液成分法" ; -- open-multilingual-wordnet
lin aphesis_N = mkN "字首音省略" | mkN "词首脱落" ; -- open-multilingual-wordnet
lin aphetic_A = mkA "脱落词首轻元音" | mkA "非重读字首之消失" ; -- open-multilingual-wordnet
lin aphid_N = mkN "蚜" | mkN "蚜蟲" | mkN "蚜虫" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin aphonia_N = mkN "发音不能" | mkN "失声" ; -- open-multilingual-wordnet
lin aphorism_N = mkN "格言" | {-mwn-} mkN "箴言" ; -- status=guess -- open-multilingual-wordnet
lin aphorist_N = mkN "格言家" | mkN "警句家" ; -- open-multilingual-wordnet
lin aphrodisiac_A = mkA "催欲" | mkA "催淫" | mkA "激发性欲" ; -- open-multilingual-wordnet
lin aphrodisiac_N = mkN "春藥" | mkN "春药" | {-mwn-} mkN "催情剂" | mkN "催欲剂" | mkN "性欲亢奋剂" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aphyllous_A = mkA "无叶" ; -- open-multilingual-wordnet
lin apian_A = mkA "蜜蜂" ; -- open-multilingual-wordnet
lin apiarian_A = mkA "养蜂" ; -- open-multilingual-wordnet
lin apiary_N = mkN "養蜂場" | mkN "养蜂场" ; -- status=guess -- status=guess
lin apical_A = mkA "顶上" | mkA "顶点" ; -- open-multilingual-wordnet
lin apiculate_A = mkA "顶端成尖形" ; -- open-multilingual-wordnet
lin apiece_Adv = mkAdv "各自" | {-HSK-} mkAdv "每个" ;
lin apish_A = mkA "像猴子" ;
lin apishamore_N = mkN "马鞍座毯" ; -- open-multilingual-wordnet
lin aplacental_A = mkA "无胎盘" ; -- open-multilingual-wordnet
lin aplanatic_A = mkA "等光程" ; -- open-multilingual-wordnet
lin aplasia_N = mkN "先天萎缩" | mkN "发育不全" | mkN "成形不全" ; -- open-multilingual-wordnet
lin aplite_N = mkN "半花岗岩" | mkN "细晶岩" ; -- open-multilingual-wordnet
lin aplitic_A = mkA "细晶岩质" | mkA "细晶状" ; -- open-multilingual-wordnet
lin aplomb_N = mkN "泰然自若" [] ;
lin apnea_N = mkN "呼吸停止" | mkN "呼吸暂停" | mkN "无呼吸" ; -- open-multilingual-wordnet
lin apneic_A = mkA "呼吸暂停" | mkA "窒息" ; -- open-multilingual-wordnet
lin apoapsis_N = mkN "最远点" | mkN "远拱点" ; -- open-multilingual-wordnet
lin apocalypse_N = mkN "大災難" | mkN "大灾难" ; -- status=guess -- status=guess
lin apocalyptic_A = mkA "世界末日" ;
lin apochromatic_A = mkA "复消色差" ; -- open-multilingual-wordnet
lin apocope_N = mkN "字尾音消失" ; -- open-multilingual-wordnet
lin apocryphal_A = mkA "杜撰" | {-mwn-} mkA "真实性可疑" ; -- status=guess -- open-multilingual-wordnet
lin apocynaceous_A = mkA "夹竹桃科" ; -- open-multilingual-wordnet
lin apodal_A = mkA "无腹鳍" | mkA "无足动物" ; -- open-multilingual-wordnet
lin apodeme_N = mkN "表皮内突" ; -- open-multilingual-wordnet
lin apodictic_A = mkA "无可置疑" | mkA "绝对真理" ; -- open-multilingual-wordnet
lin apoenzyme_N = mkN "脱辅基酶蛋白" ; -- open-multilingual-wordnet
lin apogamic_A = mkA "无配子生殖" ; -- open-multilingual-wordnet
lin apogamy_N = mkN "无受精生殖" | mkN "无配子生殖" ; -- open-multilingual-wordnet
lin apogean_A = mkA "远地点" ; -- open-multilingual-wordnet
lin apogee_N = mkN "遠地點" | mkN "远地点" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin apojove_N = mkN "远木星点" ; -- open-multilingual-wordnet
lin apolemia_N = mkN "管水母" ; -- open-multilingual-wordnet
lin apolitical_A = mkA "与政治无关" ; -- open-multilingual-wordnet
lin apologetic_A = mkA "道歉" ; -- open-multilingual-wordnet
lin apologetics_N = mkN "护教学" | mkN "辨惑学" ; -- open-multilingual-wordnet
lin apologist_N = mkN "辩护者" "位" ;
lin apologize_V = mkV "道歉" ;
lin apology_N = mkN "歉意" "份" ;
lin apomict_N = mkN "无融合生殖植物" | mkN "无配生殖植物" ; -- open-multilingual-wordnet
lin apomixis_N = mkN "单性生殖" | mkN "孤雌生殖" | mkN "无融合生殖" | mkN "无配生殖" ; -- open-multilingual-wordnet
lin apomorphine_N = mkN "脱水吗啡" | mkN "阿朴吗啡" ; -- open-multilingual-wordnet
lin aponeurosis_N = mkN "筋膜" | mkN "腱膜" ; -- open-multilingual-wordnet
lin aponeurotic_A = mkA "腱膜" ; -- open-multilingual-wordnet
lin apopemptic_A = mkA "告别" | mkA "告辞" | mkA "辞别" | mkA "送别" ; -- open-multilingual-wordnet
lin apophasis_N = mkN "阳否阴述" ; -- open-multilingual-wordnet
lin apophatic_A = mkA "用否定方法所得" ; -- open-multilingual-wordnet
lin apophthegm_N = mkN "格言" | mkN "箴言" ; -- open-multilingual-wordnet
lin apophyseal_A = mkA "骨突" ; -- open-multilingual-wordnet
lin apoplectic_A = mkA "中风" | mkA "患中风病" | mkA "易患中风" | mkA "有中风迹象" ; -- open-multilingual-wordnet
lin apoplectiform_A = mkA "类中风" ; -- open-multilingual-wordnet
lin apoptosis_N = mkN "程序性细胞死亡" ; -- open-multilingual-wordnet
lin aposelene_N = mkN "远月点" ; -- open-multilingual-wordnet
lin aposiopesis_N = mkN "頓絕句" | mkN "顿绝句" | {-mwn-} mkN "说话中断法" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aposiopetic_A = mkA "说话中断法" ; -- open-multilingual-wordnet
lin apostasy_N = mkN "變節" | mkN "变节" | mkN "叛教" ; -- status=guess -- status=guess -- status=guess
lin apostate_A = mkA "背教" | mkA "脱党" ; -- open-multilingual-wordnet
lin apostate_N = mkN "變節者" | mkN "变节者" ; -- status=guess -- status=guess
lin apostle_N = mkN "使徒" | {-mwn-} mkN "改革家" ; -- status=guess -- open-multilingual-wordnet
lin apostleship_N = mkN "使徒的地位" ; -- open-multilingual-wordnet
lin apostolic_A = mkA "使徒" | mkA "使徒时代" ; -- open-multilingual-wordnet
lin apostrophe_N = mkN "省略符號" | mkN "省略符号" | mkN "隔音符號" | mkN "隔音符号" | mkN "省字符" | mkN "單引號" | mkN "单引号" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin apostrophic_A = mkA "使用撇号" | mkA "顿呼法" ; -- open-multilingual-wordnet
lin apothecial_A = mkA "子囊盘" ; -- open-multilingual-wordnet
lin apothecium_N = mkN "子囊盘" | mkN "裸子器" ; -- open-multilingual-wordnet
lin apothegm_N = mkN "格言" | mkN "箴言" ; -- open-multilingual-wordnet
lin apotropaic_A = mkA "辟邪用" ; -- open-multilingual-wordnet
lin appal_V2 = mkV2 "恐吓" ;
lin appalling_A = mkA "骇人听闻" ;
lin appanage_N = mkN "俸禄" | mkN "封禄" ; -- open-multilingual-wordnet
lin apparatchik_N = mkN "官僚" ; -- status=guess
lin apparatus_N = mkN "设备" "台" ;
lin apparel_N = mkN "服饰" ;
lin appareled_A = mkA "打扮" | mkA "装扮" ; -- open-multilingual-wordnet
lin apparent_A = mkA "明显" ;
lin apparition_N = mkN "幻影" ;
lin apparitional_A = mkA "像鬼一样" | mkA "幽灵" ; -- open-multilingual-wordnet
lin appeal_N = mkN "上诉" ;
lin appeal_V = mkV "上诉" ;
lin appeal_V2 = mkV2 "上诉" ;
lin appealing_A = variants {} ;
lin appear_V = mkV "产生" | mkV "似乎" | mkV "像" | mkV "出现" | mkV "显得" ;
lin appear_VA = mkVA "产生" | mkVA "似乎" | mkVA "像" | mkVA "出现" | mkVA "显得" ;
lin appear_VS = mkVS "产生" | mkVS "似乎" | mkVS "像" | mkVS "出现" | mkVS "显得" ;
lin appear_VV = mkVV "产生" | mkVV "似乎" | mkVV "像" | mkVV "出现" | mkVV "显得" ;
lin appearance_N = mkN "产生" | mkN "像" | mkN "形容" | mkN "现象" "個" | mkN "表面" | {-HSK-} mkN "外形" "种" ;
lin appeasable_A = mkA "可安抚" | mkA "可平息" | mkA "缓和得了" ; -- open-multilingual-wordnet
lin appease_V2 = mkV2 "安抚" ;
lin appeasement_N = mkN "平息" ; -- open-multilingual-wordnet
lin appeaser_N = mkN "劝解人" ; -- open-multilingual-wordnet
lin appellant_A = mkA "上诉" | mkA "有权受理上诉" ; -- open-multilingual-wordnet
lin appellant_N = mkN "上诉人" ; -- open-multilingual-wordnet
lin appellate_A = mkA "上诉" | mkA "有权受理上诉" ; -- open-multilingual-wordnet
lin appellation_N = mkN "称" | mkN "称呼" | {-mwn-} mkN "名称" ; -- open-multilingual-wordnet
lin appellative_A = mkA "名称" | mkA "称呼" | mkA "通称" ; -- open-multilingual-wordnet
lin append_V2 = mkV2 "附加" ;
lin appendage_N = mkN "附加物" ;
lin appendectomy_N = mkN "闌尾切除術" | mkN "阑尾切除术" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin appendicitis_N = mkN "闌尾炎" | mkN "阑尾炎" | mkN "盲腸炎" | mkN "盲肠炎" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin appendicle_N = mkN "小附器" | mkN "小附属物" ; -- open-multilingual-wordnet
lin appendicular_A = mkA "四肢" | mkA "附属物" ; -- open-multilingual-wordnet
lin appendix_N = mkN "附录" "页" ;
lin appertain_V = mkV "从属" | mkV "属于" | mkV "附属" ; -- open-multilingual-wordnet
lin appetent_A = mkA "切望" | mkA "意欲" | mkA "渴望" | mkA "热望" ; -- open-multilingual-wordnet
lin appetite_N = mkN "食欲" [] ;
lin appetitive_A = mkA "食欲" ; -- open-multilingual-wordnet
lin appetizer_N = mkN "開胃" | mkN "开胃" | mkN "開胃菜" | mkN "开胃菜" | mkN "前菜" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin appetizing_A = mkA "开胃" ;
lin appetizingness_N = mkN "促进食欲" ;
lin applaud_V = mkV "喝彩" | {-HSK-} mkV "鼓掌" ;
lin applaud_V2 = mkV2 "鼓掌" ;
lin applause_N = mkN "赞美" | {-HSK-} mkN "鼓掌" ;
lin apple_N = L.apple_N ;
lin applejack_N = mkN "苹果白兰地" ; -- open-multilingual-wordnet
lin applet_N = mkN "小應用程序" | mkN "小应用程序" | mkN "小程序" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin applewood_N = mkN "苹果木" ; -- open-multilingual-wordnet
lin appliance_N = mkN "器具" ;
lin applicability_N = mkN "适用性" ;
lin applicable_A = mkA "应用" | {-HSK-} mkA "适用" ;
lin applicant_N = mkN "申请人" ;
lin application_1_N = mkN "应用" | mkN "用途" | mkN "申请" "份" ;
lin application_2_N = mkN "应用" | mkN "用途" | mkN "申请" "份" ;
lin application_3_N = mkN "应用" | mkN "用途" | mkN "申请" "份" ;
lin applicative_A = mkA "可适用" ; -- open-multilingual-wordnet
lin applicator_N = mkN "敷抹器" | mkN "敷料器" | mkN "涂抹器" ; -- open-multilingual-wordnet
lin applied_A = {-HSK-} mkA "实用" ;
lin apply_1_V2 = mkV2 "申请" ;
lin apply_2_V2 = mkV2 "申请" ;
lin apply_V = mkV "使用" | mkV "应用" | mkV "报名" | {-HSK-} mkV "申请" ;
lin apply_V2 = mkV2 "使用" | mkV2 "应用" | mkV2 "报名" | {-HSK-} mkV2 "申请" ;
lin apply_V2V = mkV2V "使用" | mkV2V "应用" | mkV2V "报名" | {-HSK-} mkV2V "申请" ;
lin apply_VV = mkVV "使用" | mkVV "应用" | mkVV "报名" | {-HSK-} mkVV "申请" ;
lin apply_for_V2 = prepV2 OP_apply_V OP_for_Prep ; -- guess-p-verb
lin appoint_V2 = mkV2 "委任" | {-HSK-} mkV2 "派" ;
lin appoint_V2V = mkV2V "委任" | {-HSK-} mkV2V "派" ;
lin appoint_V3 = mkV3 "委任" | {-HSK-} mkV3 "派" ;
lin appointed_A = variants {} ;
lin appointee_N = mkN "被任命人" ;
lin appointive_A = mkA "由任命而充当" ; -- open-multilingual-wordnet
lin appointment_N = mkN "任命" | {-HSK-} mkN "约会" "次" ;
lin apportionment_N = mkN "分摊" | mkN "分派" | mkN "分配" ; -- open-multilingual-wordnet
lin appositional_A = mkA "同位格" ; -- open-multilingual-wordnet
lin appraisal_N = mkN "评价" ;
lin appraise_V2 = mkV2 "评价" ;
lin appreciable_A = mkA "可感知" ;
lin appreciate_V = mkV "欣赏" ;
lin appreciate_V2 = mkV2 "欣赏" ;
lin appreciation_N = mkN "升值" ; -- comment=NOT SURE "升值" or "感激"
lin appreciative_A = mkA "欣赏" ; -- open-multilingual-wordnet
lin appreciator_N = mkN "了解真正价值的人" | mkN "评价者" | mkN "赏识者" | mkN "鉴赏者" ; -- open-multilingual-wordnet
lin apprehend_V2 = mkV2 "拿" | {-HSK-} mkV2 (mkV "捕捉") ; -- status=guess, src=wikt
lin apprehender_N = mkN "逮捕者" ; -- open-multilingual-wordnet
lin apprehensible_A = mkA "可了解" | mkA "可以理解" | mkA "可理解" | mkA "易理解" | mkA "能理解" ; -- open-multilingual-wordnet
lin apprehension_N = mkN "理解" ;
lin apprehensive_A = mkA "惴惴不安" ;
lin apprentice_N = mkN "學徒" | mkN "学徒" | {-mwn-} mkN "徒弟" | mkN "见习生" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin apprenticeship_N = mkN "学徒的身分" ; -- open-multilingual-wordnet
lin appressed_A = mkA "紧贴" | mkA "紧靠" ; -- open-multilingual-wordnet
lin apprise_V2 = mkV2 "通知" ;
lin appro_N = mkN "同意" | mkN "认可" ; -- open-multilingual-wordnet
lin approach_N = mkN "态度" "個" | {-HSK-} mkN "途径" ;
lin approach_V = mkV "就" | {-HSK-} mkV "途径" ;
lin approach_V2 = mkV2 "就" | {-HSK-} mkV2 "接近" ;
lin approachable_A = mkA "容易接近" ; -- status=guess
lin appropriate_A = mkA "相当" | {-HSK-} mkA "适当" ;
lin appropriate_V2 = mkV2 "占用" ;
lin appropriation_N = mkN "拨款" ;
lin appropriative_A = mkA "专用" ; -- open-multilingual-wordnet
lin appropriator_N = mkN "侵占者;" | mkN "占用者" | mkN "挪用者" | mkN "擅用者" | mkN "盗用者" ; -- open-multilingual-wordnet
lin approval_N = mkN "赞同" ;
lin approve_V = mkV "同意" | mkV "批准" ;
lin approve_V2 = mkV2 "同意" | mkV2 "批准" ;
lin approved_A = variants {} ;
lin approver_N = mkN "批准者" ; -- open-multilingual-wordnet
lin approx_PN = foreignPN "Approx" ; -- comment=src=eng status=guess
lin approximate_A = mkA "大概" ;
lin approximate_V2 = mkV2 "近似" ;
lin approximation_N = mkN "近似算法" ; -- status=guess
lin apr_PN = foreignPN "Apr" ; -- comment=src=eng status=guess
lin apractic_A = mkA "运用不能症" ; -- open-multilingual-wordnet
lin apricot_N = mkN "杏色" ; -- status=guess
lin apron_N = mkN "圍裙" | mkN "围裙" ; -- status=guess -- status=guess
lin apse_N = mkN "半圆壁龛" | mkN "环形殿" ; -- open-multilingual-wordnet
lin apsidal_A = mkA "拱点" | mkA "拱点" ; -- open-multilingual-wordnet
lin apt_A = mkA "贴切" ;
lin apterous_A = mkA "无翅" | mkA "无翼" ; -- open-multilingual-wordnet
lin aptitude_N = mkN "才能" | mkN "才幹" | mkN "才干" | mkN "資質" | mkN "资质" | {-mwn-} mkN "天赋" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin aptitudinal_A = mkA "有倾向" ; -- open-multilingual-wordnet
lin aquamarine_N = mkN "蓝绿色" ;
lin aquanaut_N = mkN "水下作业员" | mkN "海底工作人" | mkN "深水操作人员" ; -- open-multilingual-wordnet
lin aquaphobia_N = mkN "恐水症" | mkN "水恐怖" ; -- open-multilingual-wordnet
lin aquaplane_N = mkN "滑水板" ; -- open-multilingual-wordnet
lin aquarium_N = mkN "水族馆" "座" ;
lin aquarius_PN = foreignPN "Aquarius" ; -- comment=src=eng status=guess
lin aquatic_A = mkA "水生" ; -- status=guess
lin aquatic_N = mkN "水生植物" ; -- open-multilingual-wordnet
lin aquavit_N = mkN "生命之水" ; -- open-multilingual-wordnet
lin aqueduct_N = mkN "水道" | mkN "水路" | {-mwn-} mkN "导水管" | mkN "导管" | mkN "桥管" | mkN "水渠" | mkN "沟渠" | mkN "渡槽" | mkN "高架渠" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aquicultural_A = mkA "水产养殖" ; -- open-multilingual-wordnet
lin aquifer_N = mkN "含水層" | mkN "含水层" | {-mwn-} mkN "地下水含水层" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aquiferous_A = mkA "含水" | mkA "蓄水" ; -- open-multilingual-wordnet
lin aquiline_A = mkA "鹰钩状" ; -- open-multilingual-wordnet
lin arab_N = mkN "阿拉伯人" ;
lin arabianFem_N = variants {} ; ---- sense to be split
lin arabianMasc_N = variants {} ; ---- sense to be split
lin arable_A = mkA "耕地" ;
lin arachnid_N = mkN "蛛性動物" | mkN "蛛性动物" | mkN "蜘蛛類" | mkN "蜘蛛类" | {-mwn-} mkN "蜘蛛纲动物" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin arachnoid_A = mkA "蛛网状" ; -- open-multilingual-wordnet
lin arachnoid_N = mkN "蛛性动物" | mkN "蜘蛛类" | mkN "蜘蛛纲动物" ; -- open-multilingual-wordnet
lin arachnophobia_N = mkN "蜘蛛恐懼症" | mkN "蜘蛛恐惧症" ; -- status=guess -- status=guess
lin aragonite_N = mkN "文石" | mkN "霰石" ; -- open-multilingual-wordnet
lin aralia_N = mkN "木属植物" ; -- open-multilingual-wordnet
lin arame_N = mkN "可食海草" ; -- open-multilingual-wordnet
lin araneidal_A = mkA "类似蜘蛛" | mkA "蜘蛛" ; -- open-multilingual-wordnet
lin araucaria_N = mkN "南洋杉" ; -- open-multilingual-wordnet
lin arbiter_N = mkN "仲裁人" ; -- open-multilingual-wordnet
lin arbitrage_N = mkN "套利" | mkN "套购" ; -- open-multilingual-wordnet
lin arbitrageur_N = mkN "套利" "次" ;
lin arbitral_A = mkA "仲裁" ; -- open-multilingual-wordnet
lin arbitrament_N = mkN "仲裁" | mkN "仲裁行为" | mkN "公断" | mkN "裁决" | mkN "裁判" ; -- open-multilingual-wordnet
lin arbitrary_A = mkA "乱" | {-HSK-} mkA "武断" ;
lin arbitrate_V2 = mkV2 "仲裁" ;
lin arbitration_N = mkN "仲裁" ;
lin arbitrative_A = mkA "有权仲裁" ; -- open-multilingual-wordnet
lin arbitrator_N = mkN "仲裁人" ;
lin arbor_N = mkN "凉亭" | mkN "藤架" ; -- open-multilingual-wordnet
lin arboraceous_A = mkA "多树木" | mkA "树木茂盛" | mkA "森林" | mkA "长满树木" ; -- open-multilingual-wordnet
lin arboretum_N = mkN "树木园" | mkN "植物园" ; -- open-multilingual-wordnet
lin arborical_A = mkA "树" | mkA "树木茂盛" ; -- open-multilingual-wordnet
lin arboriculture_N = mkN "树木栽培" ; -- open-multilingual-wordnet
lin arborolatry_N = mkN "树崇拜" ; -- open-multilingual-wordnet
lin arborvitae_N = mkN "侧柏" | mkN "金钟柏" ; -- open-multilingual-wordnet
lin arbour_N = mkN "凉亭" | mkN "藤架" ; -- open-multilingual-wordnet
lin arbovirus_N = mkN "节肢动物媒介病毒" ; -- open-multilingual-wordnet
lin arbroath_PN = foreignPN "Arbroath" ; -- comment=src=geonames status=guess
lin arbutus_N = mkN "杨梅属" ; -- open-multilingual-wordnet
lin arc_N = variants {} ;
lin arcade_N = mkN "拱廊" ;
lin arcadian_A = mkA "乡村" | mkA "牧人" | mkA "田园生活" ; -- open-multilingual-wordnet
lin arcane_A = mkA "神秘" ;
lin arced_A = mkA "弓形" ; -- open-multilingual-wordnet
lin arcella_N = mkN "蕈状变形虫属" ; -- open-multilingual-wordnet
lin arch_A = mkA "恶作剧" | mkA "淘气" | mkA "顽皮" ; -- open-multilingual-wordnet
lin arch_N = mkN "拱门" "扇" ; -- comment="拱形" ;
lin arch_V = mkV "拱起" ;
lin arch_V2 = mkV2 "使+弯成弓形" ; -- comment="拱形" ;
lin archaebacteria_N = mkN "原始细菌" ; -- open-multilingual-wordnet
lin archaeological_A = mkA "考古学" ;
lin archaeologist_N = mkN "考古學家" | mkN "考古学家" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin archaeology_N = mkN "考古學" | mkN "考古学" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin archaeornis_N = mkN "古鸟" ; -- open-multilingual-wordnet
lin archaic_A = mkA "陈旧" ;
lin archaism_N = mkN "古詞" | mkN "古词" | mkN "古語" | mkN "古语" | {-mwn-} mkN "古体" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin archaist_N = mkN "古物研究者" | mkN "收集古物者" ; -- open-multilingual-wordnet
lin archaistic_A = mkA "仿古" | mkA "古风" ; -- open-multilingual-wordnet
lin archangel_N = mkN "大天使" | {-mwn-} mkN "天使长" ; -- status=guess -- open-multilingual-wordnet
lin archangelic_A = mkA "大天使" ; -- open-multilingual-wordnet
lin archbishop_N = mkN "大主教" "位" ;
lin archbishopric_N = mkN "大主教之职" | mkN "大主教教区" | mkN "大主教职务" ; -- open-multilingual-wordnet
lin archdeacon_N = mkN "会吏总" | mkN "大助祭" ; -- open-multilingual-wordnet
lin archdeaconry_N = mkN "会吏总的职位" ; -- open-multilingual-wordnet
lin archdiocesan_A = mkA "大主教之管区" ; -- open-multilingual-wordnet
lin archdiocese_N = mkN "大主教管區" | mkN "大主教管区" | {-mwn-} mkN "大主教区" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin archducal_A = mkA "大公" | mkA "大公爵" ; -- open-multilingual-wordnet
lin archduchess_N = mkN "大公夫人" ; -- open-multilingual-wordnet
lin archduchy_N = mkN "大公国" ; -- open-multilingual-wordnet
lin archduke_N = mkN "大公" ; -- open-multilingual-wordnet
lin archean_A = mkA "太古代" | mkA "太古化" ; -- open-multilingual-wordnet
lin archegonial_A = mkA "有颈卵器" | mkA "颈卵器" ; -- open-multilingual-wordnet
lin archegonium_N = mkN "造卵器" | mkN "颈卵器" ; -- open-multilingual-wordnet
lin archenteron_N = mkN "原肠" ; -- open-multilingual-wordnet
lin archeozoic_A = mkA "始生代" ; -- open-multilingual-wordnet
lin archer_N = mkN "射手" | mkN "弓箭手" ; -- status=guess -- status=guess
lin archery_N = mkN "箭術" | mkN "箭术" | mkN "射箭" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin archespore_N = mkN "孢原" | mkN "孢原组织" ; -- open-multilingual-wordnet
lin archesporial_A = mkA "孢子细胞" ; -- open-multilingual-wordnet
lin archetypal_A = mkA "原型" ; -- open-multilingual-wordnet
lin archetype_N = mkN "典范" ; -- status=guess
lin archiannelid_N = mkN "原环虫类" ; -- open-multilingual-wordnet
lin archidiaconal_A = mkA "副主教" | mkA "副监督" ; -- open-multilingual-wordnet
lin archidiaconate_N = mkN "副主教的职位" ; -- open-multilingual-wordnet
lin archiepiscopal_A = mkA "大主教" ; -- open-multilingual-wordnet
lin archimandrite_N = mkN "修道院院长" ; -- open-multilingual-wordnet
lin archine_N = mkN "阿尔申" ; -- open-multilingual-wordnet
lin archipelagic_A = mkA "在群岛上" | mkA "群岛" ; -- open-multilingual-wordnet
lin archipelago_N = mkN "群島" | mkN "群岛" | {-mwn-} mkN "多岛海" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin architectFem_N = mkN "建筑师" ;
lin architectMasc_N = mkN "建筑师" ;
lin architectonics_N = mkN "建筑学" ; -- open-multilingual-wordnet
lin architectural_A = mkA "建筑" ;
lin architecture_N = mkN "建筑" | {-HSK-} mkN "结构" "座" ;
lin architrave_N = mkN "柱顶过梁" | mkN "楣梁" ; -- open-multilingual-wordnet
lin archival_A = mkA "关于档案" | mkA "存档" | mkA "案卷" | mkA "档案" | mkA "档案中" | mkA "记录在案" ; -- open-multilingual-wordnet
lin archive_N = mkN "存档" "次" ;
lin archives_N = mkN "档案集" ; -- open-multilingual-wordnet
lin archivist_N = mkN "案卷保管人" ; -- open-multilingual-wordnet
lin archosaur_N = mkN "初龙" | mkN "祖龙" ; -- open-multilingual-wordnet
lin archosaurian_A = mkA "初龙类" ; -- open-multilingual-wordnet
lin archpriest_N = mkN "主牧师" | mkN "大主教" | mkN "教主" | mkN "高僧" | mkN "高级教士" ; -- open-multilingual-wordnet
lin archway_N = mkN "拱道" | {-mwn-} mkN "拱门" ; -- status=guess -- open-multilingual-wordnet
lin arctic_N = mkN "北極狐" | mkN "北极狐" | mkN "藍狐" | mkN "蓝狐" | mkN "白狐" | {-mwn-} mkN "套鞋" | mkN "橡胶套鞋" | mkN "胶鞋" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin arctiid_N = mkN "灯蛾" ; -- open-multilingual-wordnet
lin ardeb_N = mkN "阿戴布" ; -- open-multilingual-wordnet
lin ardent_A = mkA "热心" ;
lin ardor_N = mkN "熱情" | mkN "热情" ; -- status=guess -- status=guess
lin ardrossan_PN = foreignPN "Ardrossan" ; -- comment=src=geonames status=guess
lin arduous_A = mkA "艰巨" | mkA "艰苦" | {-HSK-} mkA "艱苦" ; -- status=guess -- status=guess
lin are_N = mkN "公亩" | {-HSK-} mkN "是" ;
lin area_1_N = mkN "区域" ;
lin area_2_N = mkN "区域" ;
lin area_3_N = mkN "区域" "块" ;
lin area_4_N = mkN "区域" ;
lin area_5_N = mkN "区域" ;
lin area_6_N = mkN "区域" ;
lin area_N = mkN "区域" ;
lin areal_A = mkA "区域" | mkA "地区" | mkA "来自一个地区" ; -- open-multilingual-wordnet
lin areca_N = mkN "仁榔" | mkN "仁频" | mkN "仙瘴丹" | mkN "宾门" | mkN "槟榔" | mkN "洗瘴丹" | mkN "螺果" ; -- open-multilingual-wordnet
lin areflexia_N = mkN "反射消失" | mkN "无反射" ; -- open-multilingual-wordnet
lin arena_N = mkN "舞台" ;
lin arenavirus_N = mkN "沙粒病毒" ; -- open-multilingual-wordnet
lin arenicolous_A = mkA "生长在沙中" ;
lin areola_N = mkN "乳暈" | mkN "乳晕" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin areolar_A = mkA "网眼状" ; -- open-multilingual-wordnet
lin arethusa_N = mkN "兰科植物" ; -- open-multilingual-wordnet
lin argent_N = mkN "銀" | mkN "银" | mkN "Characters: 銀" | {-mwn-} mkN "银白色" | mkN "银色" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin argentic_A = mkA "含银" ; -- open-multilingual-wordnet
lin argentiferous_A = mkA "含银" ; -- open-multilingual-wordnet
lin argentina_PN = mkPN "阿根廷" ;
lin argentine_N = mkN "水珍鱼" ; -- open-multilingual-wordnet
lin argentine_PN = foreignPN "Argentine" ; -- comment=src=geonames status=guess
lin argentinian_A = mkA "阿根廷" ;
lin argentinosaur_N = mkN "阿根廷龙" ; -- open-multilingual-wordnet
lin argentite_N = mkN "辉银矿" ; -- open-multilingual-wordnet
lin argentous_A = mkA "含亚银" ; -- open-multilingual-wordnet
lin argil_N = mkN "白粘土" | mkN "陶土" ; -- open-multilingual-wordnet
lin argillite_N = mkN "矽质粘土岩" | mkN "粘板岩" ; -- open-multilingual-wordnet
lin arginine_N = mkN "精氨酸" ; -- open-multilingual-wordnet
lin argon_N = mkN "氬" | mkN "氩" ; -- status=guess -- status=guess
lin argosy_N = mkN "大商船" ; -- open-multilingual-wordnet
lin argot_N = mkN "行话" ; -- status=guess
lin arguable_A = mkA "值得商榷" ;
lin argue_V = mkV "争论" ;
lin argue_V2 = mkV2 "争论" ;
lin argue_VS = mkVS "争论" ;
lin argue_down_V2 = prepV2 OP_argue_V OP_down_Prep ; -- guess-p-verb
lin argue_out_V2 = prepV2 OP_argue_V OP_out_Prep ; -- guess-p-verb
lin argument_N = mkN "争论" "次" | mkN "辩论" "場" | mkN "道理" "個" | {-HSK-} mkN "论据" ;
lin argumentation_N = mkN "推理" ; -- open-multilingual-wordnet
lin argumentative_A = mkA "好争论" | mkA "好辩" ; -- open-multilingual-wordnet
lin argus_N = mkN "眼斑雉" ; -- open-multilingual-wordnet
lin argyrodite_N = mkN "硫银锗矿" ; -- open-multilingual-wordnet
lin aria_N = mkN "咏叹调" "首" ;
lin arianist_N = mkN "阿里乌斯教徒" ; -- open-multilingual-wordnet
lin aries_PN = foreignPN "Aries" ; -- comment=src=eng status=guess
lin aril_N = mkN "假种皮" ; -- open-multilingual-wordnet
lin ariled_A = mkA "假种皮" ; -- open-multilingual-wordnet
lin ariose_A = mkA "如歌" | mkA "旋律一般" ; -- open-multilingual-wordnet
lin arioso_N = mkN "咏叙唱" ; -- open-multilingual-wordnet
lin arise_V = mkV "产生" | mkV "出现" ;
lin arista_N = mkN "刺" | mkN "芒" | mkN "触角芒" ; -- open-multilingual-wordnet
lin aristocracy_N = mkN "贵族" ;
lin aristocrat_N = mkN "貴族" | mkN "贵族" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aristocratic_A = mkA "贵族" ;
lin arithmetic_N = mkN "算术" ;
lin arithmetical_A = mkA "算术" | mkA "算术上" ; -- open-multilingual-wordnet
lin arithmetician_N = mkN "算术家" ; -- open-multilingual-wordnet
lin arizona_PN = mkPN "亚利桑那" ;
lin ark_N = mkN "方舟" ; -- status=guess -- open-multilingual-wordnet
lin arkansas_PN = mkPN "阿肯色" ;
lin arm_1_N = mkN "胳膊" ;
lin arm_2_N = mkN "胳膊" ;
lin arm_N = mkN "胳膊" ;
lin arm_V = mkV "武装" ;
lin arm_V2 = mkV2 "胳膊" ;
lin armada_N = mkN "舰队" ; -- open-multilingual-wordnet
lin armadale_PN = foreignPN "Armadale" ; -- comment=src=geonames status=guess
lin armadillo_N = mkN "犰狳" ;
lin armageddon_PN = foreignPN "Armageddon" ; -- comment=src=eng status=guess
lin armagh_PN = mkPN "阿馬" ; -- comment=src=geonames status=guess
lin armament_N = mkN "武器" | mkN "武裝" | mkN "武装" | mkN "軍備" | mkN "军备" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin armamentarium_N = mkN "全套设备" ; -- open-multilingual-wordnet
lin armature_N = mkN "电枢" ; -- open-multilingual-wordnet
lin armchair_N = {-mwn-} mkN "扶手椅" | mkN "扶手椅子" ; -- open-multilingual-wordnet
lin armed_A = variants {} ;
lin armful_N = mkN "抱" | mkN "滿懷的" | mkN "满怀的" ; -- status=guess -- status=guess -- status=guess
lin arm_hole_N = mkN "袖孔" | mkN "袖窿" | mkN "袖笼" ; -- open-multilingual-wordnet
lin armilla_N = mkN "腕带" | mkN "腕环" ; -- open-multilingual-wordnet
lin armillary_A = mkA "手镯" ; -- open-multilingual-wordnet
lin armistice_N = mkN "停戰協定" | mkN "停战协定" | {-mwn-} mkN "缓和" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin armlet_N = mkN "臂环" | mkN "臂章" | mkN "袖章" ; -- open-multilingual-wordnet
lin armoire_N = mkN "大型衣橱" ; -- open-multilingual-wordnet
lin armour_N = mkN "鎧甲" | mkN "铠甲" ; -- status=guess -- status=guess
lin armorial_A = mkA "纹章学" | mkA "纹章盾徽" ; -- open-multilingual-wordnet
lin armourer_N = mkN "武器制造者" ; -- open-multilingual-wordnet
lin armoury_N = mkN "兵工厂" | mkN "军械厂" | mkN "军械库" | mkN "军火库" ; -- open-multilingual-wordnet
lin armpit_N = mkN "腋窝" ;
lin armrest_N = mkN "椅子上的扶手" | mkN "肘靠" | {-mwn-} mkN "扶手" | mkN "把手" | mkN "靠手" | mkN "靠臂" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin army_N = mkN "军队" "支" ;
lin armyworm_N = mkN "粘虫" | mkN "粟蚕蛾幼虫" ; -- open-multilingual-wordnet
lin arnhem_PN = mkPN "阿纳姆" ; -- comment=src=geonames status=guess
lin arnold_PN = foreignPN "Arnold" ; -- comment=src=geonames status=guess
lin aroid_A = mkA "天南星科" ; -- open-multilingual-wordnet
lin aroma_N = mkN "香气" ;
lin aromatic_A = mkA "芳香" | mkA "芬芳" | mkA "芬香" | {-HSK-} mkA "香" | {-mwn-} mkA "芳香族" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin around_AdN = mkAdN "周围" ;
lin around_Adv = mkAdv "周围" ;
lin around_Prep = mkPrep "围绕" ;
lin arousal_N = mkN "激發" | mkN "激发" | mkN "興奮" | mkN "兴奋" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin arouse_V2 = mkV2 "引起" ;
lin arouse_V2V = mkV2V "引起" ;
lin arpeggio_N = mkN "琶音" ;
lin arquebus_N = mkN "火绳枪" | mkN "火绳钩枪" ; -- open-multilingual-wordnet
lin arr_PN = foreignPN "Arr" ; -- comment=src=eng status=guess
lin arrack_N = mkN "亚力酒" | mkN "烧酒" ; -- open-multilingual-wordnet
lin arraign_V2 = mkV2 "讯问" ;
lin arraignment_N = mkN "责难" ;
lin arrange_V = mkV "安排" | {-HSK-} mkV "摆" | mkV "整理" | mkV "顿" ;
lin arrange_V2 = mkV2 "安排" | {-HSK-} mkV2 "摆" | mkV2 "整理" | mkV2 "顿" ;
lin arrangement_N = mkN "安排" | {-HSK-} mkN "排列" ;
lin arranger_N = mkN "乐曲改编者" ; -- open-multilingual-wordnet
lin array_N = mkN "排列" ;
lin arrest_N = mkN "逮捕" [] ;
lin arrest_V2 = mkV2 "逮捕" ;
lin arrester_N = mkN "制动器" | mkN "制动装置" ; -- open-multilingual-wordnet
lin arrival_N = mkN "到来" ;
lin arrive_V = mkV "到" | {-HSK-} mkV "到达" | mkV "来" | {-HSK-} mkV "届" ;
lin arrogance_N = mkN "自大" ;
lin arrogant_A = mkA "自大" | {-HSK-} mkA "骄傲" ;
lin arrow_N = mkN "箭" ;
lin arrowhead_N = mkN "慈姑" | {-mwn-} mkN "箭头" | mkN "箭镞" ; -- status=guess -- open-multilingual-wordnet
lin arrowroot_N = mkN "竹芋粉" | mkN "葛粉" ; -- open-multilingual-wordnet
lin arrowsmith_N = mkN "箭匠" ; -- open-multilingual-wordnet
lin arrowworm_N = mkN "毛颚类海虫" | mkN "荚蓬植物" ; -- open-multilingual-wordnet
lin arroyo_N = mkN "小河" | mkN "溪" ; -- open-multilingual-wordnet
lin arsehole_N = mkN "屁眼" ; -- open-multilingual-wordnet
lin arsenal_N = mkN "兵工厂" "家" ;
lin arsenate_N = mkN "砷酸盐" | mkN "砷酸酯" ; -- open-multilingual-wordnet
lin arsenic_N = mkN "砷" ;
lin arsenical_A = mkA "含砷" ; -- open-multilingual-wordnet
lin arsenide_N = mkN "砷化物" ;
lin arsenious_A = mkA "含亚砷" ; -- open-multilingual-wordnet
lin arsenopyrite_N = mkN "毒砂" ; -- open-multilingual-wordnet
lin arsine_N = mkN "砷" | mkN "砷化氢" ; -- open-multilingual-wordnet
lin arson_N = mkN "纵火""次" ;
lin arsonist_N = mkN "縱火犯" | mkN "纵火犯" | {-mwn-} mkN "放火者" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin art_N = L.art_N | {-HSK-} mkN "功夫" | mkN "美术" "種" | mkN "艺术" "種" ;
lin art_PN = foreignPN "Art" ; -- comment=src=eng status=guess
lin artemisia_N = mkN "艾" | mkN "蒿" | {-mwn-} mkN "蒿属植物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin arterial_A = mkA "动脉" ; -- open-multilingual-wordnet
lin arteriectasis_N = mkN "动脉扩张" ; -- open-multilingual-wordnet
lin arteriogram_N = mkN "动脉X光照片" | mkN "动脉造影照片" ; -- open-multilingual-wordnet
lin arteriolar_A = mkA "小动脉" ; -- open-multilingual-wordnet
lin arteritis_N = mkN "动脉炎" ; -- open-multilingual-wordnet
lin artery_N = mkN "动脉" ;
lin artful_A = mkA "巧妙" ;
lin arthralgia_N = mkN "关节痛" ; -- open-multilingual-wordnet
lin arthralgic_A = mkA "关节痛" ; -- open-multilingual-wordnet
lin arthritic_A = mkA "关节炎" ;
lin arthritis_N = mkN "关节炎" "" ;
lin arthrogram_N = mkN "关节X线照片" | mkN "关节造影片" ; -- open-multilingual-wordnet
lin arthrography_N = mkN "关节造影术" ; -- open-multilingual-wordnet
lin arthromeric_A = mkA "体节" ; -- open-multilingual-wordnet
lin arthroplasty_N = mkN "关节成形术" ; -- open-multilingual-wordnet
lin arthropod_N = mkN "節肢動物" | mkN "节肢动物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin arthropodal_A = mkA "节肢动物" ; -- open-multilingual-wordnet
lin arthroscope_N = mkN "关节内窥镜" | mkN "关节镜" ; -- open-multilingual-wordnet
lin arthroscopy_N = mkN "关节内窥镜检查" ; -- open-multilingual-wordnet
lin arthrosporic_A = mkA "分节孢子" ; -- open-multilingual-wordnet
lin arthur_PN = foreignPN "Arthur" ; -- comment=src=geonames status=guess
lin artichoke_N = mkN "洋薊" | mkN "洋蓟" | {-mwn-} mkN "朝鲜蓟" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin article_N = mkN "文章" | {-HSK-} mkN "文章" "篇" | mkN "条" ;
lin article_V2 = mkV2 "使+受协议条款约束" ;
lin articular_A = mkA "关节" ; -- open-multilingual-wordnet
lin articulate_V = variants {} ; -- comment=mkV2 "说出" ;
lin articulate_V2 = mkV2 "说出" ;
lin articulatory_A = mkA "关节" | mkA "分节" ; -- open-multilingual-wordnet
lin artie_PN = foreignPN "Artie" ; -- comment=src=eng status=guess
lin artifact_N = mkN "神器" ;
lin artifactual_A = mkA "人工制造" | mkA "人造" | mkA "人造制品" | mkA "加工" ; -- open-multilingual-wordnet
lin artificer_N = mkN "军械修护员" ; -- open-multilingual-wordnet
lin artificial_A = mkA "人造" | {-HSK-} mkA "假" ;
lin artillery_N = mkN "火炮" "门" ;
lin artilleryman_N = mkN "砲兵" | mkN "炮兵" | {-mwn-} mkN "炮手" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin artisan_N = mkN "工匠" | mkN "匠人" ; -- status=guess -- status=guess
lin artist_N = mkN "艺术家" ;
lin artiste_N = mkN "技艺家" ; -- open-multilingual-wordnet
lin artistic_A = mkA "艺术" ;
lin artistry_N = mkN "艺术性" "" ;
lin artless_A = mkA "天真" ;
lin artwork_N = mkN "插图" ; -- open-multilingual-wordnet
lin arty_A = mkA "装艺术" ; -- open-multilingual-wordnet
lin arum_N = mkN "海芋植物" ; -- open-multilingual-wordnet
lin arundinaceous_A = mkA "芦苇" ; -- open-multilingual-wordnet
lin aryanFem_N = variants {} ; ---- sense to be split
lin aryanMasc_N = variants {} ; ---- sense to be split
lin arytenoid_N = mkN "杓状软骨" | mkN "鱼藤酮类" ; -- open-multilingual-wordnet
lin as_CAdv = S.as_CAdv ;
lin as_Prep = mkPrep "与" "一样" ;
lin as_Subj = mkSubj "如" ;
lin as_for_Prep = mkPrep "至于" ;
lin as_long_as_Subj = mkSubj "只要" ;
lin as_of_Prep = mkPrep "截至" ;
lin as_opposed_to_Prep = mkPrep "与之前相反是" ;
lin as_well_Adv = mkAdv "同样地" ;
lin as_well_as_Conj = mkConj "以及" ;
lin asafetida_N = mkN "阿魏" | mkN "阿魏胶" ; -- open-multilingual-wordnet
lin asana_N = mkN "姿勢" | mkN "姿势" ; -- status=guess -- status=guess
lin asap_PN = foreignPN "Asap" ; -- comment=src=eng status=guess
lin asbestos_N = mkN "石棉" ;
lin asbestosis_N = mkN "石棉肺" ;
lin ascariasis_N = mkN "蛔虫病" ; -- open-multilingual-wordnet
lin ascend_V = mkV "上升" ;
lin ascendable_A = mkA "可上升" | mkA "可攀登" | mkA "爬得上去" ; -- open-multilingual-wordnet
lin ascendancy_N = mkN "優勢" | mkN "优势" | {-mwn-} mkN "优越" | mkN "俯视" | mkN "支配" | mkN "权势" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ascendant_A = mkA "上升" | mkA "优势" | mkA "优越" | mkA "占优势" | mkA "有支配力" | mkA "有权势" ; -- open-multilingual-wordnet
lin ascendant_N = mkN "优势" "项" ;
lin ascendency_N = mkN "优势" ;
lin ascendent_N = mkN "祖先" | mkN "祖宗" ; -- open-multilingual-wordnet
lin ascensional_A = mkA "上升" ; -- open-multilingual-wordnet
lin ascent_N = mkN "上升" ;
lin ascertain_V2 = {-HSK-} mkV2 "批" | mkV2 "确定" ;
lin ascertainable_A = mkA "可确定" ; -- open-multilingual-wordnet
lin ascetic_N = mkN "禁欲者" ; -- open-multilingual-wordnet
lin asceticism_N = mkN "禁慾主義" | mkN "禁欲主义" | mkN "苦行主義" | mkN "苦行主义" | {-mwn-} mkN "禁欲" | mkN "苦行" | mkN "苦行生活" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin ascidian_N = mkN "海鞘类" ; -- open-multilingual-wordnet
lin asclepiad_N = mkN "马利筋" ; -- open-multilingual-wordnet
lin asclepiadaceous_A = mkA "萝摩科" ; -- open-multilingual-wordnet
lin ascocarp_N = mkN "子囊果" ; -- open-multilingual-wordnet
lin ascocarpous_A = mkA "子囊果" ; -- open-multilingual-wordnet
lin ascomycete_N = mkN "子囊菌" ; -- open-multilingual-wordnet
lin ascomycetous_A = mkA "子囊菌纲" ; -- open-multilingual-wordnet
lin ascospore_N = mkN "子囊孢子" ; -- open-multilingual-wordnet
lin ascosporic_A = mkA "囊孢子" ; -- open-multilingual-wordnet
lin ascot_N = mkN "领巾式领带" ; -- open-multilingual-wordnet
lin ascot_PN = foreignPN "Ascot" ; -- comment=src=geonames status=guess
lin ascribe_V2 = mkV2 "归因于" ;
lin aseptic_A = mkA "无菌" | mkA "消过毒" ; -- open-multilingual-wordnet
lin ash_N = mkN "灰" ;
lin ashamed_A = mkA "惭愧" ;
lin ashbourne_PN = foreignPN "Ashbourne" ; -- comment=src=geonames status=guess
lin ashby_PN = foreignPN "Ashby" ; -- comment=src=geonames status=guess
lin ashby_de_la_zouch_PN = foreignPN "Ashby de la Zouch" ; -- comment=src=geonames status=guess
lin ashby_woulds_PN = foreignPN "Ashby Woulds" ; -- comment=src=eng status=guess
lin ashcake_N = mkN "玉米饼" ; -- open-multilingual-wordnet
lin ashen_A = mkA "无血色" | mkA "没有精神" | mkA "苍白" | mkA "铁青" ; -- open-multilingual-wordnet
lin ashes_N = L.ashes_N ;
lin ashford_PN = mkPN "阿什福德" ; -- comment=src=geonames status=guess
lin ashington_PN = foreignPN "Ashington" ; -- comment=src=geonames status=guess
lin ashlar_N = mkN "料石" ; -- open-multilingual-wordnet
lin ashore_Adv = mkAdv "上岸" ;
lin ashton_in_makerfield_PN = foreignPN "Ashton-in-makerfield" ; -- comment=src=eng status=guess
lin ashton_under_lyne_PN = foreignPN "Ashton-under-lyne" ; -- comment=src=eng status=guess
lin ashtray_N = mkN "烟灰缸" ;
lin ashy_A = mkA "灰白色" | mkA "灰色" ; -- open-multilingual-wordnet
lin asian_A = mkA "亚洲人" ;
lin asian_N = mkN "亚洲人" "位" ;
lin aside_Adv = mkAdv "旁白" ;
lin aside_from_Prep = mkPrep "除了" ;
lin ask_V = mkV "叫" | mkV "要求" | mkV "请" | mkV "问" ;
lin ask_V2 = mkV2 "叫" | mkV2 "要求" | mkV2 "请" | mkV2 "问" ;
lin ask_V2Q = L.ask_V2Q ;
lin ask_V2V = mkV2V "叫" | mkV2V "要求" | mkV2V "请" | mkV2V "问" ;
lin ask_VQ = mkVQ (mkV "问") ;
lin ask_about_V2 = mkV2 "打听" ;
lin ask_after_V2 = prepV2 OP_ask_V OP_after_Prep ; -- guess-p-verb
lin ask_around_V = advV OP_ask_V OP_around_Adv ; -- guess-p-verb
lin ask_around_V2 = prepV2 OP_ask_V OP_around_Prep ; -- guess-p-verb
lin ask_for_V2 = mkV2 "请求" ;
lin ask_for_V3 = variants {} ; -- guess-p-verb
lin ask_in_V2 = prepV2 OP_ask_V OP_in_Prep ; -- guess-p-verb
lin ask_out_V2 = prepV2 OP_ask_V OP_out_Prep ; -- guess-p-verb
lin ask_over_V2 = prepV2 OP_ask_V OP_over_Prep ; -- guess-p-verb
lin ask_round_V2 = prepV2 OP_ask_V OP_round_Prep ; -- guess-p-verb
lin askance_Adv = mkAdv "不贊成地" | mkAdv "不赞成地" | mkAdv "懷疑地" | mkAdv "怀疑地" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin askern_PN = foreignPN "Askern" ; -- comment=src=geonames status=guess
lin askew_A = mkA "歪" | {-mwn-} mkA "歪" | mkA "歪斜" ; -- open-multilingual-wordnet
lin askew_Adv = mkAdv "歪" ;
lin asking_N = mkN "请求" ;
lin aslant_A = mkA "倾斜" | mkA "歪" ; -- open-multilingual-wordnet
lin asleep_A = mkA "睡着" ;
lin asocial_A = mkA "反社会" ; -- open-multilingual-wordnet
lin asparagine_N = mkN "天门冬酰胺" ; -- open-multilingual-wordnet
lin asparagus_N = mkN "蘆筍" | mkN "芦笋" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aspartame_N = mkN "阿斯巴特" | mkN "阿斯巴甜糖" ; -- open-multilingual-wordnet
lin aspect_N = mkN "方面" | {-HSK-} mkN "方面" "個" | mkN "样子" ;
lin aspectual_A = mkA "体" ; -- open-multilingual-wordnet
lin aspen_N = mkN "白杨" ;
lin aspergill_N = mkN "洒水器" ; -- open-multilingual-wordnet
lin aspersion_N = mkN "诽谤" ;
lin aspersorium_N = mkN "洒水器" ; -- open-multilingual-wordnet
lin asphalt_N = mkN "沥青" "吨" ;
lin asphaltic_A = mkA "柏油" | mkA "沥青" ; -- open-multilingual-wordnet
lin aspheric_A = mkA "非球面" ; -- open-multilingual-wordnet
lin asphyxia_N = mkN "窒息" | mkN "血液中缺氧" ; -- open-multilingual-wordnet
lin aspic_N = mkN "肉凍" | mkN "肉冻" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aspirant_N = mkN "怀抱大志者" | mkN "野心家" ; -- open-multilingual-wordnet
lin aspirate_N = mkN "送气发辅音" ; -- open-multilingual-wordnet
lin aspirate_V2 = mkV2 "吸气" ;
lin aspiration_N = mkN "抱负" ;
lin aspirator_N = mkN "抽吸装置" | mkN "水流抽气机" ; -- open-multilingual-wordnet
lin aspire_V = mkV "渴望" ;
lin aspire_VV = mkVV "向往" ;
lin aspirin_N = mkN "阿司匹林" ;
lin aspull_PN = foreignPN "Aspull" ; -- comment=src=eng status=guess
lin asronished_A = mkA "诧异" ;
lin ass_N = mkN "屁股" ;
lin assail_V2 = mkV2 "攻击" ;
lin assailable_A = mkA "无法防御" | mkA "无防备" ; -- open-multilingual-wordnet
lin assailant_N = mkN "攻击者" ;
lin assassin_N = mkN "刺客" ;
lin assassinate_V2 = mkV2 "暗杀" ;
lin assassination_N = mkN "暗杀" "次" ;
lin assault_N = mkN "攻击" ;
lin assault_V2 = variants {} ;
lin assaultive_A = mkA "喜好攻击" ; -- open-multilingual-wordnet
lin assay_N = mkN "化验" | mkN "测定" ; -- open-multilingual-wordnet
lin assayer_N = mkN "分析者" | mkN "试验者" ; -- open-multilingual-wordnet
lin assemblage_N = mkN "集合" ;
lin assemble_V = mkV "会" | mkV "组合" | {-HSK-} mkV "聚集" ;
lin assemble_V2 = mkV2 "会" | mkV2 "组合" | {-HSK-} mkV2 "聚集" ;
lin assembler_N = mkN "汇编程序" ; -- open-multilingual-wordnet
lin assembly_N = mkN "集成" ;
lin assemblyman_N = mkN "议员" ; -- open-multilingual-wordnet
lin assemblywoman_N = mkN "女议员" ; -- open-multilingual-wordnet
lin assent_N = mkN "赞成" ;
lin assent_V = mkV "同意" | mkV "应允" | mkV "答应" | mkV "赞成" ; -- open-multilingual-wordnet
lin assert_V = mkV "断言" ;
lin assert_V2 = mkV2 "断言" ;
lin assert_VS = mkVS "断言" ;
lin asserter_N = mkN "断言者" ; -- open-multilingual-wordnet
lin assertion_N = mkN "主张" "個" | {-HSK-} mkN "断言" ;
lin assertive_A = mkA "肯定" ;
lin assess_V2 = mkV2 "评价" | {-HSK-} mkV2 "评估" ;
lin assessable_A = mkA "可估价" ; -- open-multilingual-wordnet
lin assessment_N = mkN "评定" "次" ;
lin asset_N = mkN "资产" ;
lin assets_N = mkN "财产" | mkN "资产" ; -- open-multilingual-wordnet
lin asseveration_N = mkN "主张" | mkN "断言" ; -- open-multilingual-wordnet
lin asshole_N = mkN "屁眼" ; -- status=guess -- open-multilingual-wordnet
lin assiduous_A = mkA "刻苦" ;
lin assign_V2 = mkV2 "分配" | {-HSK-} mkV2 "派" ;
lin assign_V2V = mkV2V "分配" | {-HSK-} mkV2V "派" ;
lin assignation_N = mkN "分摊" | mkN "分派" | mkN "分配" ; -- open-multilingual-wordnet
lin assignee_N = mkN "代理人" | mkN "委托者" ; -- open-multilingual-wordnet
lin assignment_N = mkN "任务" "項" | {-HSK-} mkN "分配" ;
lin assignor_N = mkN "分配者" | mkN "委派者" ; -- open-multilingual-wordnet
lin assimilable_A = mkA "可同化" ; -- open-multilingual-wordnet
lin assimilate_V = mkV "同化" | {-HSK-} mkV "吸收" ;
lin assimilate_V2 = mkV2 "吸收" ;
lin assimilation_N = mkN "同化" ; -- status=guess
lin assimilative_A = mkA "使同化" | mkA "同化" | mkA "同化力" ; -- open-multilingual-wordnet
lin assist_N = mkN "帮助""" ;
lin assist_V = mkV "协助" | {-HSK-} mkV "帮助" | mkV "救" ;
lin assist_V2 = mkV2 "协助" | {-HSK-} mkV2 "帮助" | mkV2 "救" ;
lin assistance_N = mkN "协助" | {-HSK-} mkN "帮助" ;
lin assistantFem_N = mkN "助理" ; ---- sense to be split
lin assistantMasc_N = mkN "助理" ; ---- sense to be split
lin assistant_A = variants {} ;
lin assistant_N = mkN "助理" ;
lin assistive_A = mkA "帮助" | mkA "援助" ; -- open-multilingual-wordnet
lin associate_A = mkA "副" ;
lin associate_N = mkN "关联" ;
lin associate_V = mkV "关联" ;
lin associate_V2 = mkV2 "关联" ;
lin associated_A = variants {} ;
lin association_N = mkN "会" "個" | {-HSK-} mkN "协会" ;
lin associational_A = mkA "联想" ; -- open-multilingual-wordnet
lin associationism_N = mkN "联想主义" ; -- open-multilingual-wordnet
lin assonance_N = mkN "类韵" | mkN "谐音" ; -- open-multilingual-wordnet
lin assorted_A = mkA "各种各样" ;
lin assortment_N = mkN "品种" ;
lin assuage_V2 = mkV2 "缓和" ;
lin assume_V2 = mkV2 "假设" | {-HSK-} mkV2 "承担" ;
lin assume_VS = mkVS "假设" | {-HSK-} mkVS "承担" ;
lin assumption_N = mkN "假设" ;
lin assurance_N = mkN "保证" | {-HSK-} mkN "把握" ;
lin assure_V2 = mkV2 "保证" ;
lin assure_V2S = mkV2S "保证" ;
lin astasia_N = mkN "站立不能" | mkN "起立不能" ; -- open-multilingual-wordnet
lin astatic_A = mkA "不安定" | mkA "不稳定" | mkA "无定向" ; -- open-multilingual-wordnet
lin astatine_N = mkN "砹" ; -- status=guess
lin aster_N = mkN "翠菊" | mkN "紫菀" ; -- status=guess -- status=guess
lin asteriated_A = mkA "星彩性" | mkA "星状" | mkA "显出星形" | mkA "有星彩" | mkA "有星芒" ; -- open-multilingual-wordnet
lin asterisk_N = mkN "星號" | mkN "星号" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin asterisked_A = mkA "星号标记" ; -- open-multilingual-wordnet
lin asterism_N = mkN "星群" ; -- status=guess
lin asterismal_A = mkA "星群" ; -- open-multilingual-wordnet
lin asternal_A = mkA "不连胸骨" ; -- open-multilingual-wordnet
lin asteroid_A = mkA "似星" | mkA "星形" | mkA "星状" ; -- open-multilingual-wordnet
lin asteroid_N = mkN "小行星" ;
lin asteroidal_A = mkA "星状" ; -- open-multilingual-wordnet
lin asthenic_A = mkA "瘦长" ; -- open-multilingual-wordnet
lin asthenosphere_N = mkN "岩流圈" ; -- open-multilingual-wordnet
lin asthma_N = mkN "哮喘" ;
lin asthmatic_A = mkA "哮喘" | mkA "气喘声" ; -- open-multilingual-wordnet
lin asthmatic_N = mkN "哮喘患者" ; -- status=guess
lin astigmatism_N = mkN "散光" | mkN "亂視" | mkN "乱视" ; -- status=guess -- status=guess -- status=guess
lin astilbe_N = mkN "红升麻属植物" | mkN "落新妇属植物" ; -- open-multilingual-wordnet
lin astomatal_A = mkA "没有气孔" ; -- open-multilingual-wordnet
lin astomatous_A = mkA "无口" | mkA "无孔" ; -- open-multilingual-wordnet
lin aston_PN = foreignPN "Aston" ; -- comment=src=eng status=guess
lin astonish_V2 = mkV2 (mkV "震驚") | mkV2 (mkV "震惊") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin astonishing_A = mkA "惊人" ;
lin astonishment_N = mkN "惊讶" ;
lin astound_V2 = mkV2 "使+大吃一惊" ;
lin astounding_A = mkA "令人惊骇" | mkA "发愣" | mkA "哑然失声" | mkA "惊呆" ; -- open-multilingual-wordnet
lin astragalar_A = mkA "与距骨有关" ; -- open-multilingual-wordnet
lin astral_A = mkA "星" ; -- open-multilingual-wordnet
lin astrantia_N = mkN "羊角芹" ; -- open-multilingual-wordnet
lin astray_Adv = mkAdv "误入歧途" ;
lin astride_Prep = mkPrep "横跨" ;
lin astringency_N = mkN "涩味" "" ;
lin astringent_N = mkN "爽膚水" | mkN "爽肤水" | {-mwn-} mkN "收敛剂" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin astrocytic_A = mkA "星细胞" ; -- open-multilingual-wordnet
lin astrodome_N = mkN "天体观测室" | mkN "天体观测窗" | mkN "天文航行舱" | mkN "天文观测舱" | mkN "领航舱" ; -- open-multilingual-wordnet
lin astrodynamics_N = mkN "航天动力学" ;
lin astrogator_N = mkN "宇航员" ; -- open-multilingual-wordnet
lin astrolabe_N = mkN "星盘" ; -- open-multilingual-wordnet
lin astrolatry_N = mkN "天体崇拜" ; -- open-multilingual-wordnet
lin astrologer_N = mkN "占星家" ; -- status=guess -- open-multilingual-wordnet
lin astrological_A = mkA "占星" | mkA "占星术" ; -- open-multilingual-wordnet
lin astrology_N = mkN "占星學" | mkN "占星学" | {-mwn-} mkN "占星术" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin astrometry_N = mkN "天体测量学" ; -- open-multilingual-wordnet
lin astronaut_N = mkN "宇航员" "位" ;
lin astronautic_A = mkA "太空航行学" | mkA "宇航" ; -- open-multilingual-wordnet
lin astronautics_N = mkN "航空学" | mkN "航空术" ; -- open-multilingual-wordnet
lin astronomer_N = mkN "天文学家" ;
lin astronomic_A = mkA "天文学" ; -- open-multilingual-wordnet
lin astronomical_A = mkA "天文" ;
lin astronomy_N = mkN "天文學" | mkN "天文学" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin astrophysical_A = mkA "天体物理学" ; -- open-multilingual-wordnet
lin astrophysicist_N = mkN "天体物理学家" ; -- open-multilingual-wordnet
lin astrophysics_N = mkN "天體物理學" | mkN "天体物理学" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin astute_A = mkA "精明" ;
lin astuteness_N = mkN "敏锐" | mkN "明智" | mkN "渊博" ; -- open-multilingual-wordnet
lin asunder_Adv = mkAdv "四分五裂" ; -- status=guess
lin asylum_N = mkN "庇护" ;
lin asymmetric_A = mkA "不均匀" | mkA "不对称" ; -- open-multilingual-wordnet
lin asymptomatic_A = mkA "无临床症状" | mkA "无症状" ; -- open-multilingual-wordnet
lin asymptote_N = mkN "渐近线" ; -- open-multilingual-wordnet
lin asymptotic_A = mkA "渐近" | mkA "渐近线" ; -- open-multilingual-wordnet
lin asynchronism_N = mkN "不同时性" | mkN "去同步化作用" | mkN "失步" | mkN "非同时性" ; -- open-multilingual-wordnet
lin asynclitism_N = mkN "头盆倾度不均" ; -- open-multilingual-wordnet
lin asyndetic_A = mkA "接续词省略" ; -- open-multilingual-wordnet
lin asynergic_A = mkA "不协调" ; -- open-multilingual-wordnet
lin asynergy_N = mkN "不能协同" | mkN "协同不能" ; -- open-multilingual-wordnet
lin asystole_N = mkN "心搏停止" | mkN "心脏停搏" ; -- open-multilingual-wordnet
lin at_N = mkN "在" | {-HSK-} mkN "阿特""" ;
lin at_Prep = mkPrep "在" "" (R.ATPlace True) ;
lin at_all_Adv = mkAdv "根本" | mkAdv "简直" ;
lin at_home_Adv = mkAdv "在家里" ;
lin at_least_AdN = S.at_least_AdN ;
lin at_most_AdN = S.at_most_AdN ;
lin at_the_behest_of_Prep = mkPrep "按照命令" ;
lin ataractic_A = mkA "使安静" | mkA "使镇静" | mkA "心气和平" ; -- open-multilingual-wordnet
lin atavism_N = mkN "先前特征的重现" ; -- open-multilingual-wordnet
lin atavistic_A = mkA "隔代遗传" | {-mwn-} mkA "返祖现象" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ataxia_N = mkN "运动失调" ; -- open-multilingual-wordnet
lin ataxic_A = mkA "运动失调" ; -- open-multilingual-wordnet
lin ateleiosis_N = mkN "发育不完全" | mkN "垂体性幼稚病" ; -- open-multilingual-wordnet
lin ateleiotic_A = mkA "发育不全" ; -- open-multilingual-wordnet
lin atelier_N = mkN "工作室" | mkN "画室" | mkN "雕塑室" ; -- open-multilingual-wordnet
lin atheism_N = mkN "無神論" | mkN "无神论" ; -- status=guess -- status=guess
lin atheist_A = mkA "无神论" | mkA "无神论者" ; -- open-multilingual-wordnet
lin atheist_N = mkN "無神論者" | mkN "无神论者" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin atheistic_A = mkA "無神論" | mkA "无神论" ; -- status=guess -- status=guess
lin athenaeum_N = mkN "图书馆" | mkN "阅览室" ; -- open-multilingual-wordnet
lin athenianFem_N = variants {} ; ---- sense to be split
lin athenianMasc_N = variants {} ; ---- sense to be split
lin athenian_A = mkA "雅典" ;
lin athens_1_PN = mkPN ("阿森斯" | "雅典") ; -- comment=src=geonames status=guess
lin athens_2_PN = mkPN ("阿森斯" | "雅典") ; -- comment=src=geonames status=guess
lin athens_PN = mkPN "雅典" ;
lin atheroma_N = mkN "粥樣化" | mkN "粥样化" ; -- status=guess -- status=guess
lin atheromatous_A = mkA "动脉粥样化" | mkA "粉瘤" ; -- open-multilingual-wordnet
lin atherosclerosis_N = mkN "动脉粥样硬化" ; -- open-multilingual-wordnet
lin atherosclerotic_A = mkA "动脉硬化" | mkA "动脉粥样硬化" ; -- open-multilingual-wordnet
lin atherstone_PN = foreignPN "Atherstone" ; -- comment=src=geonames status=guess
lin athetosis_N = mkN "哈蒙德氏病" | mkN "手足徐动症" | mkN "指痉病" ; -- open-multilingual-wordnet
lin athirst_A = mkA "渴望" | mkA "热望" ; -- open-multilingual-wordnet
lin athlete_N = mkN "运动员" ;
lin athletic_A = mkA "运动" ;
lin athletics_N = mkN "田径运动" "种" ;
lin athlone_PN = foreignPN "Athlone" ; -- comment=src=geonames status=guess
lin atilt_A = mkA "倾斜" ; -- open-multilingual-wordnet
lin atlanta_PN = mkPN "亚特兰大" ; -- comment=src=geonames status=guess
lin atlantic_PN = foreignPN "Atlantic" ; -- comment=src=geonames status=guess
lin atlas_N = mkN "地图集" "本" ;
lin atmometer_N = mkN "汽化计" | mkN "蒸发计" ; -- open-multilingual-wordnet
lin atmosphere_N = mkN "气候" "種" | mkN "气氛" | mkN "空气" | {-HSK-} mkN "气氛" [] ;
lin atmospheric_A = mkA "大气" ;
lin atole_N = mkN "粥" ; -- open-multilingual-wordnet
lin atoll_N = mkN "环礁" ;
lin atom_N = mkN "原子" "个" ;
lin atomic_A = mkA "原子" ;
lin atomizer_N = mkN "噴霧器" | mkN "喷雾器" ; -- status=guess -- status=guess
lin atonal_A = mkA "无调" ;
lin atonalistic_A = mkA "不成调" ; -- open-multilingual-wordnet
lin atonality_N = mkN "无调性" ; -- open-multilingual-wordnet
lin atone_V = mkV "弥补" ;
lin atonement_N = mkN "補償" | mkN "贖罪" ; -- status=guess -- status=guess
lin atonic_A = mkA "无重音" ; -- open-multilingual-wordnet
lin atonicity_N = mkN "张力缺乏" | mkN "张力缺乏性" | mkN "肌弛缓" ; -- open-multilingual-wordnet
lin atop_Prep = mkPrep "在" ;
lin atopognosia_N = mkN "疾病感缺失" ; -- open-multilingual-wordnet
lin atrabilious_A = mkA "消化不良" | mkA "胃弱" ; -- open-multilingual-wordnet
lin atrazine_N = mkN "阿特拉津" ; -- open-multilingual-wordnet
lin atresia_N = mkN "闭锁" | mkN "闭锁畸形" ; -- open-multilingual-wordnet
lin atrium_N = mkN "心房" | {-mwn-} mkN "天井" | mkN "门廊" ; -- status=guess -- open-multilingual-wordnet
lin atrocious_A = mkA "穷凶极恶" ;
lin atrocity_N = mkN "暴行" ;
lin atrophic_A = mkA "萎缩" | mkA "萎缩性" ; -- open-multilingual-wordnet
lin atropine_N = mkN "阿托品" | mkN "颠茄碱" ; -- open-multilingual-wordnet
lin attach_V = mkV "附加" ;
lin attach_V2 = mkV2 "连接" ;
lin attache_N = mkN "随员" "个" ;
lin attachment_N = mkN "附件" ;
lin attack_N = mkN "攻击" ;
lin attack_V2 = mkV2 "攻击" ;
lin attacker_N = mkN "攻击者" ;
lin attain_V = mkV "达到" ;
lin attain_V2 = mkV2 "达到" ;
lin attainable_A = mkA "可达到" ;
lin attainment_N = variants {} ;
lin attar_N = mkN "玫瑰油" | mkN "香精油" ; -- open-multilingual-wordnet
lin attempt_1_N = mkN "尝试" ; ---- sense to be split
lin attempt_2_N = mkN "尝试" ; ---- sense to be split
lin attempt_N = mkN "尝试" ;
lin attempt_V2 = mkV2 "尝试" ;
lin attempt_VV = mkVV "尝试" ;
lin attempted_A = variants {} ;
lin attend_V = mkV "出席" ;
lin attend_V2 = mkV2 "出席" ;
lin attendance_N = mkN "护理" [] ;
lin attendant_A = mkA "伴随" | {-HSK-} mkA "服务员" ;
lin attendant_N = mkN "服务员" | {-HSK-} mkN "服务员" "個" ;
lin attention_N = mkN "注意" ;
lin attentional_A = mkA "注意" ; -- open-multilingual-wordnet
lin attentive_A = mkA "仔细" | mkA "周到" ;
lin attenuate_A = mkA "减弱" | mkA "减轻" | mkA "削弱" | mkA "变弱" | mkA "稀薄" ; -- open-multilingual-wordnet
lin attenuator_N = mkN "减压器" | mkN "衰减器" ; -- open-multilingual-wordnet
lin attest_V = mkV "证明" ;
lin attest_VS = mkVS "证明" ;
lin attester_N = mkN "作证人" | mkN "证明人" ; -- open-multilingual-wordnet
lin attic_A = mkA "阁楼" ;
lin attic_N = mkN "阁楼" ;
lin attire_N = mkN "打扮" | mkN "服装" | mkN "穿衣" | mkN "衣着" ; -- open-multilingual-wordnet
lin attitude_N = mkN "态度" | {-HSK-} mkN "态度" "個" ;
lin attitudinize_V = mkV "摆架子" | mkV "装模作样" | mkV "装腔作势" ; -- open-multilingual-wordnet
lin attorney_N = mkN "律师" ;
lin attorneyship_N = mkN "代理人之职" ; -- open-multilingual-wordnet
lin attosecond_N = mkN "阿托秒" | mkN "阿秒" ; -- open-multilingual-wordnet
lin attract_V2 = mkV2 "吸引" ;
lin attractable_A = mkA "可被吸引" ; -- open-multilingual-wordnet
lin attraction_N = mkN "吸引力" [] ;
lin attractive_A = mkA "引人注意" ;
lin attractor_N = mkN "吸引" | mkN "吸引力" | mkN "吸引物" | mkN "诱惑物" ; -- open-multilingual-wordnet
lin attributable_A = mkA "归属" ;
lin attribute_N = mkN "属性" ;
lin attribute_V2 = mkV2 "归于" ;
lin attrited_A = mkA "磨损" ; -- open-multilingual-wordnet
lin attrition_N = mkN "摩擦" ;
lin attritional_A = mkA "磨损" ; -- open-multilingual-wordnet
lin atypicality_N = mkN "不典型" | mkN "不特别" ; -- open-multilingual-wordnet
lin au_pair_N = mkN "互惠生" | mkN "互裨青年" ; -- open-multilingual-wordnet -- | mkN "以帮做家务换取食宿的年轻佣工" ??
lin auburn_A = mkA "茶褐色" | mkA "赤褐色" | mkA "赭色" | mkA "金棕色" ; -- open-multilingual-wordnet
lin auckland_PN = mkPN "奧克蘭都會區" ; -- comment=src=geonames status=guess
lin auction_N = mkN "拍卖" ;
lin auction_V2 = mkV2 "拍卖" ;
lin auctioneer_N = mkN "拍卖师" ;
lin audacious_A = mkA "大胆" ;
lin audacity_N = mkN "大胆" [] ;
lin audible_A = mkA "听得见" ;
lin audience_N = mkN "听众" | {-HSK-} mkN "观众" ;
lin audile_N = mkN "听觉型的人" ; -- open-multilingual-wordnet
lin audio_A = mkA "音頻" | mkA "音频" | mkA "伴音" ; -- status=guess -- status=guess -- status=guess
lin audiocassette_N = mkN "盒式录音磁带" ; -- open-multilingual-wordnet
lin audiogram_N = mkN "听力图" | mkN "声波图" ; -- open-multilingual-wordnet
lin audiology_N = mkN "聽力學" | mkN "听力学" | {-mwn-} mkN "测听术" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin audiometer_N = mkN "听力计" | mkN "听度计" ; -- open-multilingual-wordnet
lin audiometric_A = mkA "听力测定" ; -- open-multilingual-wordnet
lin audiovisual_A = mkA "視聽" | mkA "视听" | {-mwn-} mkA "视听" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin audiovisual_N = mkN "直观教具" | mkN "视听教具" ; -- open-multilingual-wordnet
lin audit_N = mkN "审计" "次" ;
lin audit_V2 = mkV2 "旁听" ;
lin audition_N = mkN "听" ;
lin audition_V = mkV "试音" ;
lin audition_V2 = mkV2 (mkV "面試") | mkV2 (mkV "面试") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin auditor_N = mkN "稽核员" ;
lin auditorium_N = mkN "禮堂" | mkN "礼堂" | mkN "會堂" | mkN "会堂" | {-mwn-} mkN "听众席" | mkN "观众席" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin auditory_A = mkA "聽覺" | mkA "听觉" | mkA "耳朵" | {-mwn-} mkA "听" | mkA "听觉" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin audley_PN = foreignPN "Audley" ; -- comment=src=geonames status=guess
lin audrey_PN = foreignPN "Audrey" ; -- comment=src=eng status=guess
lin aug_PN = foreignPN "Aug" ; -- comment=src=eng status=guess
lin augend_N = mkN "被加數" | mkN "被加数" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin augite_N = mkN "斜辉石" | mkN "普通辉石" | mkN "辉石" ; -- open-multilingual-wordnet
lin augitic_A = mkA "普通辉石" ; -- open-multilingual-wordnet
lin augment_V = mkV "增大" ;
lin augment_V2 = mkV2 "增加" ;
lin augmentation_N = mkN "增加" | mkN "增大" ; -- open-multilingual-wordnet
lin augsburg_PN = mkPN "奥格斯堡" ; -- comment=src=geonames status=guess
lin augur_N = mkN "占兆官" | mkN "占卜官" | mkN "占卜师" | mkN "占卜祭司" ; -- open-multilingual-wordnet
lin augury_N = mkN "预兆" ; -- open-multilingual-wordnet
lin august_A = mkA "八月" ;
lin auk_N = mkN "海雀科" | {-mwn-} mkN "海雀" ; -- status=guess -- open-multilingual-wordnet
lin auklet_N = mkN "小海雀" | mkN "小种海雀" ; -- open-multilingual-wordnet
lin aunt_N = mkN "阿姨" ;
lin auntie_N = mkN "阿姨" | mkN "老大媽" | mkN "老大妈" | {-mwn-} mkN "伯母" | mkN "叔母" | mkN "妗" | mkN "妗母" | mkN "姑" | mkN "姑妈" | mkN "姑姑" | mkN "姑母" | mkN "姨" | mkN "姨妈" | mkN "姨母" | mkN "婶婶" | mkN "婶子" | mkN "婶母" | mkN "舅妈" | mkN "舅母" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin aunty_N = mkN "伯母" | mkN "叔母" | mkN "妗" | mkN "妗母" | mkN "姑" | mkN "姑妈" | mkN "姑姑" | mkN "姑母" | mkN "姨" | mkN "姨妈" | mkN "姨母" | mkN "婶婶" | mkN "婶子" | mkN "婶母" | mkN "老大妈" | mkN "舅妈" | mkN "舅母" | mkN "阿姨" ; -- open-multilingual-wordnet
lin aura_N = mkN "氛围" ;
lin aural_A = mkA "听觉" ;
lin aureate_A = mkA "金" | mkA "金光闪闪" | mkA "金色" | mkA "金黄色" ; -- open-multilingual-wordnet
lin aureole_N = mkN "圓光" | mkN "圆光" ; -- status=guess -- status=guess
lin auriculate_A = mkA "有耳" ; -- open-multilingual-wordnet
lin auriferous_A = mkA "含金" ; -- open-multilingual-wordnet
lin auriform_A = mkA "耳状" ; -- open-multilingual-wordnet
lin aurora_N = mkN "極光" | mkN "极光" ; -- status=guess -- status=guess
lin auroral_A = mkA "曙光" ; -- open-multilingual-wordnet
lin aurous_A = mkA "含金" | mkA "金" ; -- open-multilingual-wordnet
lin auscultation_N = mkN "聽診" | mkN "听诊" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin auscultatory_A = mkA "听诊" ; -- open-multilingual-wordnet
lin auspice_N = mkN "吉兆" ; -- open-multilingual-wordnet
lin auspices_N = mkN "主办" | mkN "保护" | mkN "赞助" ; -- open-multilingual-wordnet
lin auspicious_A = mkA "吉祥" ;
lin austenite_N = mkN "奥氏体" ; -- open-multilingual-wordnet
lin austenitic_A = mkA "奥氏体" ; -- open-multilingual-wordnet
lin austere_A = mkA "严峻" ;
lin austerity_N = mkN "朴素" [] ;
lin austral_A = mkA "南国" ;
lin austral_N = mkN "奥斯特拉尔" ; -- open-multilingual-wordnet
lin australia_PN = mkPN "澳大利亚" ;
lin australianFem_N = variants {} ; ---- sense to be split
lin australianMasc_N = variants {} ; ---- sense to be split
lin australian_A = mkA "澳大利亚" ;
lin australopithecine_A = mkA "南方古猿" | mkA "南猿亚科" ; -- open-multilingual-wordnet
lin australopithecine_N = mkN "南方古猿" | mkN "南猿亚科" ; -- open-multilingual-wordnet
lin austria_PN = mkPN "奥地利" ;
lin austrianFem_N = variants {} ; ---- sense to be split
lin austrianMasc_N = variants {} ; ---- sense to be split
lin austrian_A = mkA "奥地利" ;
lin autacoidal_A = mkA "内分泌物" ; -- open-multilingual-wordnet
lin autarchic_A = mkA "专制" | mkA "独裁" | mkA "自给自足" ; -- open-multilingual-wordnet
lin autarchy_N = mkN "專制" | mkN "专制" ; -- status=guess -- status=guess
lin autarkic_A = mkA "自给自足" ; -- open-multilingual-wordnet
lin autarky_N = mkN "自给自足" ; -- open-multilingual-wordnet
lin auteur_N = mkN "著者" | {-mwn-} mkN "个人风格导演" ; -- status=guess -- open-multilingual-wordnet
lin authentic_A = mkA "可信" | {-HSK-} mkA "地道" ;
lin authenticity_N = mkN "真实性" ;
lin author_N = mkN "作者" | {-HSK-} mkN "作者" "個" ;
lin authore_V2 = mkV2 "创作出版" ;
lin authoritarian_A = mkA "独裁主义" ;
lin authoritarianism_N = mkN "威權主義" | mkN "威权主义" ; -- status=guess -- status=guess
lin authoritative_A = mkA "权威" ;
lin authority_1_N = mkN "权威" ;
lin authority_2_N = mkN "权威" ;
lin authority_N = mkN "权威" ;
lin authorization_N = mkN "授权" ;
lin authorize_V2 = mkV2 "授权" ;
lin authorize_V2V = mkV2V "授权" ;
lin authorship_N = mkN "著作权" ;
lin autism_N = mkN "自閉症" | mkN "自闭症" | mkN "孤獨症" | mkN "孤独症" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin autistic_A = mkA "孤僻" | mkA "孤独" | mkA "孤独病" | mkA "自闭" ; -- open-multilingual-wordnet
lin auto_N = mkN "汽车" ;
lin autobahn_N = mkN "超级公路" | mkN "高速公路" ; -- open-multilingual-wordnet
lin autobiography_N = mkN "自传" "本" ;
lin autocatalysis_N = mkN "自动催化" | mkN "自身催化" ; -- open-multilingual-wordnet
lin autocatalytic_A = mkA "自动催化" ; -- open-multilingual-wordnet
lin autochthonal_A = mkA "土生" | mkA "土著" | mkA "本土" ; -- open-multilingual-wordnet
lin autoclave_N = mkN "高压消毒锅" | mkN "高压灭菌器" | mkN "高压锅" ; -- open-multilingual-wordnet
lin autocracy_N = mkN "專制" | mkN "专制" | mkN "獨裁" | mkN "独裁" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin autocrat_N = mkN "独裁者" "名" ; -- comment="专制君主" ;
lin autocratic_A = mkA "专制" ;
lin autodidact_N = mkN "自修者" | mkN "自學者" | mkN "自学者" ; -- status=guess -- status=guess -- status=guess
lin autodidactic_A = mkA "自学者" ; -- open-multilingual-wordnet
lin autoerotic_A = mkA "手淫" | mkA "自体性行为" ; -- open-multilingual-wordnet
lin autofocus_N = mkN "自动对光装置" | mkN "自动聚焦装置" ; -- open-multilingual-wordnet
lin autogenetic_A = mkA "无生源说" | mkA "自发发生说" | mkA "自然发生" | mkA "自然发生说" | mkA "自生" ; -- open-multilingual-wordnet
lin autogiro_N = mkN "旋翼机" | mkN "旋翼飞机" ; -- open-multilingual-wordnet
lin autograph_N = mkN "手稿" "份" ;
lin autograph_V2 = mkV2 "亲笔写" ;
lin autographic_A = mkA "亲笔" | mkA "亲笔写成" ; -- open-multilingual-wordnet
lin autogyro_N = mkN "旋翼机" | mkN "旋翼飞机" ; -- open-multilingual-wordnet
lin autoimmune_A = mkA "自体免疫" | mkA "自身免疫" ; -- open-multilingual-wordnet
lin autoimmunity_N = mkN "自体免疫" | mkN "自身免疫" ; -- open-multilingual-wordnet
lin autoinjector_N = mkN "自我注射器" ; -- open-multilingual-wordnet
lin autoloader_N = mkN "半自动枪炮" | mkN "半自动步枪" ; -- open-multilingual-wordnet
lin autolysis_N = mkN "自我分解" | mkN "自溶" | mkN "自身溶解" ; -- open-multilingual-wordnet
lin autolytic_A = mkA "自溶" ; -- open-multilingual-wordnet
lin automate_V2 = mkV2 "自动化" ;
lin automatic_A = mkA "自动" ;
lin automatic_N = mkN "自动" | {-mwn-} mkN "自动手枪" ; -- open-multilingual-wordnet
lin automation_N = mkN "自动化" [] ;
lin automobile_N = mkN "汽车" ;
lin automotive_A = mkA "汽车" ;
lin automysophobia_N = mkN "自秽恐怖" ; -- open-multilingual-wordnet
lin autonomic_A = mkA "自主" ; -- open-multilingual-wordnet
lin autonomous_A = mkA "自治" ;
lin autonomy_N = mkN "自治" "" ;
lin autophyte_N = mkN "自养植物" ; -- open-multilingual-wordnet
lin autoplastic_A = mkA "自体成形术" | mkA "自体移植" ; -- open-multilingual-wordnet
lin autopsy_N = mkN "屍檢" | mkN "尸检" | mkN "驗屍" | mkN "验尸" | mkN "屍體解剖" | mkN "尸体解剖" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin autoradiograph_N = mkN "放射能照像" | mkN "放射能照相" | mkN "自动射线照相" ; -- open-multilingual-wordnet
lin autoradiographic_A = mkA "放射能照像" ; -- open-multilingual-wordnet
lin autoradiography_N = mkN "射线自显迹法" | mkN "放射能照像" ; -- open-multilingual-wordnet
lin autoregulation_N = mkN "自体调节" | mkN "自动调整" | mkN "自身调节" ; -- open-multilingual-wordnet
lin autosemantic_A = mkA "实义" | mkA "本身具有意义" | mkA "述意" ; -- open-multilingual-wordnet
lin autosomal_A = mkA "常染色体" ; -- open-multilingual-wordnet
lin autotelic_A = mkA "为其自身" | mkA "自有其目" ; -- open-multilingual-wordnet
lin autotomic_A = mkA "自断" | mkA "自身分裂" ; -- open-multilingual-wordnet
lin autotomy_N = mkN "自切" | mkN "自割" ; -- open-multilingual-wordnet
lin autotrophic_A = mkA "自养植物" ; -- open-multilingual-wordnet
lin autumn_N = mkN "秋" ;
lin auxesis_N = mkN "细胞增大" ; -- open-multilingual-wordnet
lin auxetic_A = mkA "促诱" | mkA "促进细胞增大" | mkA "增大" ; -- open-multilingual-wordnet
lin auxiliary_A = mkA "辅助" ;
lin auxiliary_N = mkN "助動詞" | mkN "助动词" ; -- status=guess -- status=guess
lin auxin_N = mkN "植物激素" | mkN "生长素" | mkN "茁长素" ; -- open-multilingual-wordnet
lin auxinic_A = mkA "含茁长素" ; -- open-multilingual-wordnet
lin avail_N = mkN "利益" ;
lin avail_V2 = mkV2 "趁" ;
lin availability_N = mkN "可用性" ;
lin available_A = mkA "可用" ;
lin avalanche_N = mkN "雪崩" ;
lin avaram_N = mkN "肯尼" "个" ;
lin avaricious_A = mkA "贪婪" ;
lin avascular_A = mkA "无血管" ; -- open-multilingual-wordnet
lin avatar_N = mkN "紙娃娃" | mkN "纸娃娃" | mkN "頭像" | mkN "头像" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin ave_PN = foreignPN "Ave" ; -- comment=src=eng status=guess
lin aveley_PN = foreignPN "Aveley" ; -- comment=src=geonames status=guess
lin avellan_A = mkA "四臂榛果形" ; -- open-multilingual-wordnet
lin avenge_V2 = mkV2 "报复" ;
lin avenue_N = mkN "大街" ;
lin aver_VS = mkVS "断言" ;
lin average_A = mkA "平均" ;
lin average_N = mkN "平均" ;
lin average_V = mkV "平均" ;
lin average_V2 = mkV2 "平均" ;
lin averse_A = mkA "厌恶" | mkA "反感" | mkA "格格不入" ; -- open-multilingual-wordnet
lin aversion_N = mkN "厭惡" | mkN "厌恶" ; -- status=guess -- status=guess
lin aversive_A = mkA "令人嫌恶" ; -- open-multilingual-wordnet
lin avert_V2 = mkV2 "避免" ;
lin avian_A = mkA "鸟类" ; -- open-multilingual-wordnet
lin aviary_N = mkN "鳥舍" | mkN "鸟舍" | {-mwn-} mkN "大型鸟舍" | mkN "大鸟笼" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin aviation_N = mkN "航空" [] ;
lin aviatorFem_N = variants {} ; ---- sense to be split
lin aviatorMasc_N = variants {} ; ---- sense to be split
lin avid_A = mkA "渴望" ;
lin avifaunal_A = mkA "某鸟类" ; -- open-multilingual-wordnet
lin avignon_PN = mkPN "亞維農" ; -- comment=src=geonames status=guess
lin avionic_A = mkA "航空电子学" ; -- open-multilingual-wordnet
lin avitaminosis_N = mkN "维生素缺乏症" ; -- open-multilingual-wordnet
lin avitaminotic_A = mkA "维他命缺乏症" ; -- open-multilingual-wordnet
lin avo_N = mkN "阿沃" ; -- open-multilingual-wordnet
lin avocado_N = mkN "鱷梨" | mkN "鳄梨" | mkN "酪梨" | mkN "Taiwan luòlí)" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin avocation_N = mkN "娛樂" | mkN "娱乐" | {-mwn-} mkN "业余爱好" | mkN "副业" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin avocational_A = mkA "业余爱好" | mkA "副业" ; -- open-multilingual-wordnet
lin avocet_N = mkN "反嘴鹬" ; -- open-multilingual-wordnet
lin avoid_V2 = mkV2 "逃避" | mkV2 "避免" ;
lin avoid_VV = mkVV "逃避" | mkVV "避免" ;
lin avoidable_A = mkA "可避免" | mkA "可避开" | mkA "可防止" ; -- open-multilingual-wordnet
lin avoidance_N = mkN "避免" ;
lin avon_PN = foreignPN "Avon" ; -- comment=src=geonames status=guess
lin avow_V2 = mkV2 (mkV "公开说") ; -- status=guess, src=wikt
lin avower_N = mkN "断言者" ; -- open-multilingual-wordnet
lin avulsion_N = mkN "扯开" | mkN "撕脱" | mkN "撕裂" ; -- open-multilingual-wordnet
lin avuncular_A = mkA "慈祥" ;
lin await_V2 = mkV2 "期待" | mkV2 "等" | {-HSK-} mkV2 "等待" ;
lin awake_A = mkA "醒着" ; -- comment="意识到" ;
lin awake_V = mkV "醒来" ;
lin awaken_V2 = mkV2 "醒" ;
lin award_N = mkN "奖" ;
lin award_V2 = mkV2 "奖励" ;
lin award_V3 = mkV3 "授予" ;
lin aware_A = mkA "意识到" | {-HSK-} mkA "自觉" ;
lin aware_of_A2 = mkA2 "注意" ;
lin awareness_N = mkN "意识" "个" | {-HSK-} mkN "认识" ;
lin awash_A = mkA "泛滥" ;
lin away_1_Adv = mkAdv "远离" ;
lin away_2_Adv = mkAdv "远离" ;
lin away_A = mkA "离开" ;
lin away_Adv = mkAdv "远离" ;
lin aweary_A = mkA "疲倦" ; -- open-multilingual-wordnet
lin aweless_A = mkA "不恭敬" | mkA "不敬" | mkA "无敬畏心" | mkA "无礼" ; -- open-multilingual-wordnet
lin awesome_A = mkA "厉害" | {-HSK-} mkA "真棒" | mkA "可敬畏" ;
lin awful_A = mkA "可怕" | {-HSK-} mkA "吓人" ;
lin awhile_Adv = mkAdv "一会儿" ;
lin awkward_A = mkA "尴尬" ;
lin awl_N = mkN "錐子" | mkN "锥子" | {-mwn-} mkN "尖钻" | mkN "尖锥" | mkN "钻子" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin awn_N = mkN "芒" | mkN "谷刺" ; -- open-multilingual-wordnet
lin awning_N = mkN "遮篷" | mkN "雨篷" | mkN "天幕" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin awol_PN = foreignPN "Awol" ; -- comment=src=eng status=guess
lin awry_A = mkA "曲解" ;
lin awry_Adv = mkAdv "歪斜地" ;
lin ax_N = mkN "斧头" "把" ;
lin axe_N = mkN "斧頭" | mkN "斧头" | mkN "斧" | mkN "斧" | mkN "斧子" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin axial_A = mkA "轴" ; -- open-multilingual-wordnet
lin axil_N = mkN "叶腋" | mkN "枝腋" | mkN "腋" ; -- open-multilingual-wordnet
lin axile_A = mkA "轴" ; -- open-multilingual-wordnet
lin axillary_A = mkA "腋窝" ; -- open-multilingual-wordnet
lin axiological_A = mkA "价值论" ; -- open-multilingual-wordnet
lin axiom_N = mkN "公理" ;
lin axiomatic_A = mkA "不言自明" ;
lin axis_N = mkN "轴" "根" ;
lin axle_N = mkN "轴" ;
lin axolotl_N = mkN "墨西哥鈍口螈" | mkN "墨西哥钝口螈" | mkN "美西螈" | mkN "六角恐龍" | mkN "六角恐龙" | mkN "六角龍" | mkN "六角龙" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin axon_N = mkN "轴突" ; -- status=guess
lin axonal_A = mkA "轴突" | mkA "轴突性" | mkA "轴索" ; -- open-multilingual-wordnet
lin ayatollah_N = mkN "阿亞圖拉" | mkN "阿亚图拉" ; -- status=guess -- status=guess
lin aycliffe_PN = foreignPN "Aycliffe" ; -- comment=src=eng status=guess
lin aye_Interj = variants {} ;
lin aylesbury_PN = mkPN "艾爾斯伯里" ; -- comment=src=geonames status=guess
lin aylesford_PN = foreignPN "Aylesford" ; -- comment=src=geonames status=guess
lin ayr_PN = foreignPN "Ayr" ; -- comment=src=geonames status=guess
lin azadirachtin_N = mkN "印楝素" ; -- open-multilingual-wordnet
lin azalea_N = mkN "杜鵑花" | mkN "杜鹃花" ; -- status=guess -- status=guess
lin azide_N = mkN "叠氮化物" | mkN "连叠氮化物" ; -- open-multilingual-wordnet
lin azido_A = mkA "叠氮" ;
lin azimuth_N = mkN "方位角" ; -- status=guess
lin azimuthal_A = mkA "方位角" ; -- open-multilingual-wordnet
lin azo_A = mkA "偶氮" ; -- open-multilingual-wordnet
lin azonal_A = mkA "不分地区" | mkA "泛域" ; -- open-multilingual-wordnet
lin azonic_A = mkA "不限于一地方" | mkA "不限于地区" | mkA "非地方性" ; -- open-multilingual-wordnet
lin azote_N = mkN "氨" | mkN "氮" ; -- open-multilingual-wordnet
lin azotemic_A = mkA "尿毒症" ; -- open-multilingual-wordnet
lin azotic_A = mkA "含氮" | mkA "氮" | mkA "硝石" | mkA "硝酸" ; -- open-multilingual-wordnet
lin azoturia_N = mkN "氮尿" ; -- open-multilingual-wordnet
lin azure_A = mkA "蔚蓝" ;
lin azure_N = mkN "蔚藍" | mkN "蔚蓝" | mkN "天藍色" | mkN "天蓝色" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin azygous_A = mkA "不成对" | mkA "单一" | mkA "非一对中之一" | mkA "非对偶" ; -- open-multilingual-wordnet
lin azymia_N = mkN "酶缺乏" ; -- open-multilingual-wordnet
lin b_ed_N = mkN "乙等" ;
lin ba_N = mkN "肉圓" | mkN "肉圆" ; -- status=guess -- status=guess
lin baa_N = mkN "發咩聲" | mkN "发咩声" ; -- status=guess -- status=guess
lin babble_N = mkN "廢話" | mkN "废话" | mkN "閑話" | mkN "闲话" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin babel_N = mkN "巴贝尔" ;
lin baboon_N = mkN "狒狒" ; -- status=guess -- open-multilingual-wordnet
lin baboonish_A = mkA "像狒狒" ; -- open-multilingual-wordnet
lin babs_PN = foreignPN "Babs" ; -- comment=src=eng status=guess
lin babushka_N = mkN "头巾" ; -- open-multilingual-wordnet
lin baby_N = L.baby_N | {-HSK-} mkN "宝贝" ;
lin baby_faced_A = mkA "娃娃脸" ; -- comment="婴孩" ;
lin babysit_V = mkV "代人照看孩子" | mkV "照看嬰兒" | mkV "照看婴儿" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin babysitter_N = mkN "保姆" ; -- status=guess
lin baccalaureate_N = mkN "学士学位" ;
lin baccate_A = mkA "浆果状" ; -- open-multilingual-wordnet
lin bacchanal_A = mkA "狂欢" | mkA "狂饮作乐" | mkA "狂饮闹宴" | mkA "纵酒宴乐" ; -- open-multilingual-wordnet
lin bacchanalian_A = mkA "狂欢" | mkA "狂饮作乐" | mkA "狂饮闹宴" | mkA "纵酒宴乐" ; -- open-multilingual-wordnet
lin bacchantic_A = mkA "狂饮作乐" ; -- open-multilingual-wordnet
lin bachelor_N = mkN "学士" ;
lin bacillus_N = mkN "芽孢杆菌" ;
lin bacitracin_N = mkN "杆菌肽" | mkN "杆菌肽素" ; -- open-multilingual-wordnet
lin back_A = {-HSK-} mkA "后面" | mkA "背" ;
lin back_Adv = mkAdv "后面" | {-HSK-} mkAdv "背" ;
lin back_N = L.back_N | {-HSK-} mkN "后面" | mkN "背" ;
lin back_V = mkV "支持" ;
lin back_away_V = advV OP_back_V OP_away_Adv ; -- guess-p-verb
lin back_down_V = mkV "后退" | mkV "向后退缩" | mkV "让步" | mkV "退让" ; -- open-multilingual-wordnet
lin back_into_V3 = variants {} ; -- guess-p-verb
lin back_off_V = mkV "后退" | mkV "向后退缩" | mkV "让步" | mkV "退让" ; -- open-multilingual-wordnet
lin back_out_V = mkV "退出" ; -- open-multilingual-wordnet
lin back_out_of_V2 = prepV2 (advV OP_back_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin back_out_of_V3 = variants {} ; -- guess-p-verb
lin back_to_Prep = mkPrep "回到" ;
lin back_up_V = advV OP_back_V OP_up_Adv ; -- guess-p-verb
lin back_up_1_V2 = mkV2 "支持" ;
lin back_up_2_V2 = mkV2 "支持" ;
lin backache_N = mkN "背疼" | mkN "腰痛" ; -- status=guess -- status=guess
lin backbench_N = mkN "后座议员席" ; -- open-multilingual-wordnet
lin backbencher_N = mkN "後坐議員" | mkN "后坐议员" ; -- status=guess -- status=guess
lin backbite_V = mkV "戳脊梁骨" | mkV "戳脊梁" | mkV "誹謗" | mkV "诽谤" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin backbite_V2 = mkV2 (mkV "戳脊梁骨") | mkV2 (mkV "戳脊梁") | mkV2 (mkV "誹謗") | mkV2 (mkV "诽谤") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin backboard_N = mkN "籃板" | mkN "篮板" | {-mwn-} mkN "后板" | mkN "靠背板" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin backbone_N = mkN "支柱" ;
lin backcloth_N = mkN "背景" | mkN "背景幕" ; -- open-multilingual-wordnet
lin backdrop_N = mkN "背景" | {-HSK-} mkN "背景" "種" ;
lin backerFem_N = mkN "靠山" ;
lin backerMasc_N = mkN "靠山" ;
lin backfire_V = mkV "事与愿违" ;
lin backgammon_N = mkN "雙陸棋" | mkN "双陆棋" ; -- status=guess -- status=guess
lin background_N = mkN "底" | mkN "背景" "種" | {-HSK-} mkN "背景" ;
lin backing_N = mkN "后盾" | {-HSK-} mkN "支持" "個" ;
lin backlash_N = mkN "反冲" ;
lin backlighting_N = mkN "背光" ;
lin backlog_N = mkN "积压" [] ;
lin backpack_N = mkN "背包" | mkN "背囊" | {-mwn-} mkN "帆布背包" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin backplate_N = mkN "后挡板" ; -- open-multilingual-wordnet
lin backroom_N = mkN "密室" ; -- open-multilingual-wordnet
lin backsaw_N = mkN "平背锯" | mkN "短锯" | mkN "背锯" | mkN "镶边手锯" ; -- open-multilingual-wordnet
lin backscratcher_N = mkN "抓耙子" | mkN "癢癢撓" | mkN "痒痒挠" | mkN "笑刷兒" | mkN "笑刷儿" | mkN "爪仗" | {-mwn-} mkN "不求人" | mkN "佛手" | mkN "老头乐" | mkN "长柄扒" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin backseat_N = mkN "后座" ;
lin backside_N = mkN "背部" ;
lin backstage_Adv = mkAdv "在后台" ;
lin backstay_N = mkN "后支条" | mkN "后部撑物" ; -- open-multilingual-wordnet
lin backstitch_N = mkN "回式针迹" | mkN "回针缝" | mkN "扣针脚倒缝" | mkN "来回针脚" | mkN "返针" ; -- open-multilingual-wordnet
lin backstroke_N = mkN "仰泳" ; -- status=guess
lin backsword_N = mkN "单刃剑" ; -- open-multilingual-wordnet
lin back_up_N = mkN "備份" | mkN "备份" ; -- status=guess -- status=guess
lin backward_A = mkA "落后" | {-HSK-} mkA "逆向" ; -- status=guess
lin backward_Adv = mkAdv "向后" | {-HSK-} mkAdv "落后" ;
lin backwards_Adv = mkAdv "向后" ;
lin backwater_N = mkN "穷乡僻壤" ;
lin backworth_PN = foreignPN "Backworth" ; -- comment=src=geonames status=guess
lin backyard_N = mkN "後院" | mkN "后院" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bacon_N = mkN "熏肉" "块" ;
lin bacteremia_N = mkN "菌血病症" | mkN "菌血症" ; -- open-multilingual-wordnet
lin bacteremic_A = mkA "菌血症" ; -- open-multilingual-wordnet
lin bacteria_N = variants {} ;
lin bacterial_A = mkA "细菌" ;
lin bactericidal_A = mkA "杀菌" | mkA "杀菌性" | mkA "消毒" ; -- open-multilingual-wordnet
lin bacteriological_A = mkA "细菌学" ; -- open-multilingual-wordnet
lin bacteriologist_N = mkN "細菌學家" | mkN "细菌学家" ; -- status=guess -- status=guess
lin bacteriology_N = mkN "細菌學" | mkN "细菌学" ; -- status=guess -- status=guess
lin bacteriolysis_N = mkN "溶菌作用" ; -- open-multilingual-wordnet
lin bacteriolytic_A = mkA "溶菌" ; -- open-multilingual-wordnet
lin bacteriophagic_A = mkA "噬菌体" ; -- open-multilingual-wordnet
lin bacteriostat_N = mkN "制菌剂" | mkN "抑菌剂" | mkN "细菌抑制剂" ; -- open-multilingual-wordnet
lin bacteriostatic_A = mkA "抑制细菌" | mkA "抑菌" ; -- open-multilingual-wordnet
lin bacterium_N = mkN "细菌" ;
lin bacteroidal_A = mkA "假细菌" | mkA "细菌性" | mkA "细菌状" ; -- open-multilingual-wordnet
lin bacup_PN = foreignPN "Bacup" ; -- comment=src=geonames status=guess
lin bad_A = L.bad_A | {-HSK-} mkA "坏" | mkA "糟糕" ;
lin bad_N = mkN "坏" | {-HSK-} mkN "糟糕" ;
lin badajoz_PN = foreignPN "Badajoz" ; -- comment=src=geonames status=guess
lin badalona_PN = mkPN "巴达洛纳" ; -- comment=src=geonames status=guess
lin baddeleyite_N = mkN "二氧化锆矿" | mkN "斜锆石" ; -- open-multilingual-wordnet
lin badge_N = mkN "徽章" | {-HSK-} mkN "象征" ;
lin badger_N = mkN "獾" ; -- status=guess -- open-multilingual-wordnet
lin badgering_N = mkN "纠缠" | mkN "骚扰" ; -- open-multilingual-wordnet
lin badminton_N = mkN "羽毛球" | {-HSK-} mkN "羽毛球" "個" ; -- status=guess
lin baffle_N = mkN "反射板" | mkN "折流板" | mkN "挡板" | mkN "隔板" ; -- open-multilingual-wordnet
lin baffle_V2 = mkV2 (mkV "迷惑") | mkV2 (mkV "使困惑") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin bag_N = mkN "包" "個" | {-HSK-} mkN "袋" ;
lin bagasse_N = mkN "甘蔗渣" | mkN "甜菜渣" ; -- open-multilingual-wordnet
lin bagassosis_N = mkN "甘蔗渣肺" | mkN "蔗渣尘肺" ; -- open-multilingual-wordnet
lin bagel_N = mkN "貝果" | mkN "贝果" | mkN "培果" | mkN "焙果" | mkN "百吉圈" | mkN "百吉" | mkN "麵包圈" | mkN "面包圈" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin baggage_N = mkN "行李" ;
lin bagger_N = mkN "装袋机" ; -- open-multilingual-wordnet
lin baghdad_PN = foreignPN "Baghdad" ; -- comment=src=geonames status=guess
lin bagnio_N = mkN "浴场" | mkN "澡堂" ; -- open-multilingual-wordnet
lin bagpipe_N = mkN "风笛" ;
lin bahamas_PN = mkPN "巴哈马" ; -- comment=src=geonames status=guess
lin bahrain_PN = mkPN "巴林" ; -- comment=src=geonames status=guess
lin baht_N = mkN "泰銖" | mkN "泰铢" | {-mwn-} mkN "铢" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bail_N = mkN "保释" ;
lin bail_V = mkV "保释" ;
lin bail_V2 = mkV2 "保释" ;
lin bailey_N = mkN "城廓" ; -- open-multilingual-wordnet
lin bailey_PN = foreignPN "Bailey" ; -- comment=src=eng status=guess
lin bailiff_N = mkN "法警" ;
lin bait_N = mkN "诱饵" ;
lin baiting_N = mkN "下料" | mkN "诱饵" ; -- open-multilingual-wordnet
lin baiza_N = mkN "拜萨" ; -- open-multilingual-wordnet
lin baize_N = mkN "厚羊毛毯" ; -- open-multilingual-wordnet
lin bake_V = variants {} ; -- comment=mkV2 "烤" ;
lin bake_V2 = mkV2 "烤" ;
lin baker_N = mkN "面包师" ;
lin bakery_N = mkN "面包店" ;
lin baking_N = mkN "烤" | mkN "烘" | mkN "焙燒" | mkN "焙烧" | mkN "烘烤" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin baklava_N = mkN "果仁蜜餅" | mkN "果仁蜜饼" ; -- status=guess -- status=guess
lin baksheesh_N = mkN "津贴" ;
lin baku_PN = foreignPN "Baku" ; -- comment=src=geonames status=guess
lin balaclava_N = mkN "巴拉克拉瓦" | mkN "頭套" | mkN "头套" | {-mwn-} mkN "巴拉克拉瓦头盔" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin balagan_N = mkN "混乱" ; -- open-multilingual-wordnet
lin balalaika_N = mkN "巴拉萊卡琴" | mkN "巴拉莱卡琴" ; -- status=guess -- status=guess
lin balance_N = mkN "对比" "個" | mkN "平衡" ;
lin balance_V = mkV "使平衡" ;
lin balance_V2 = mkV2 "平衡" ;
lin balanced_A = variants {} ;
lin balanitis_N = mkN "阴茎头炎" | mkN "龟头炎" ; -- open-multilingual-wordnet
lin balas_N = mkN "玫红尖晶石" ; -- open-multilingual-wordnet
lin balcony_N = mkN "阳台" ;
lin bald_A = mkA "秃" ;
lin baldachin_N = mkN "华盖" ; -- open-multilingual-wordnet
lin balderdash_N = mkN "胡說八道" | mkN "胡说八道" ; -- status=guess -- status=guess
lin baldness_N = mkN "禿頭" | mkN "秃头" | {-mwn-} mkN "光秃" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin baldock_PN = foreignPN "Baldock" ; -- comment=src=geonames status=guess
lin baldric_N = mkN "佩饰" | mkN "肩带" | mkN "饰带" ; -- open-multilingual-wordnet
lin bale_N = mkN "大包" ;
lin balk_V = mkV "阻碍" ;
lin ball_N = mkN "球" ;
lin ball_V = mkV "成团快" ;
lin ball_V2 = mkV2 "使+成球形" ;
lin ballad_N = mkN "民謠" | mkN "民谣" | mkN "歌謠" | mkN "歌谣" | mkN "短歌" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin ballast_N = mkN "壓載" | mkN "压载" | {-mwn-} mkN "压舱物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ballcock_N = mkN "浮球旋塞" | mkN "浮球阀" ; -- open-multilingual-wordnet
lin ball_dress_N = mkN "舞会礼服" ; -- open-multilingual-wordnet
lin ballerina_N = mkN "芭蕾舞演員" | mkN "芭蕾舞演员" | mkN "芭蕾舞女演員" | mkN "芭蕾舞女演员" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin ballet_N = mkN "芭蕾舞" "次" ;
lin balletic_A = mkA "像芭蕾舞" | mkA "芭蕾舞" ; -- open-multilingual-wordnet
lin ballistic_A = mkA "弹道" ;
lin ballistics_N = mkN "彈道學" | mkN "弹道学" ; -- status=guess -- status=guess
lin balloon_N = mkN "气球" ;
lin balloon_V = mkV "气球" ;
lin balloon_V2 = mkV2 "使+成气球状" ;
lin balloonist_N = mkN "气球驾驶者" ;
lin ballot_N = mkN "抽签" | {-HSK-} mkN "票" "張" ;
lin ballot_V = mkV "投票" ;
lin ballpark_N = mkN "球场" ; -- open-multilingual-wordnet
lin ballplayer_N = mkN "棒球手" "名" ;
lin ballpoint_N = mkN "原子笔" | mkN "原子筆" | mkN "圓珠筆" | mkN "圆珠笔" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin ballroom_N = mkN "舞厅" ;
lin bally_A = variants {} ;
lin bally_Adv = adjAdv bally_A ; -- derived
lin balm_N = mkN "香脂" [] ;
lin balmy_A = mkA "芳香" ;
lin baloney_N = mkN "胡扯" ;
lin balsam_N = mkN "香脂" | mkN "香膏" | mkN "香油" ; -- status=guess -- status=guess -- status=guess
lin balsamic_A = mkA "如香油" ; -- open-multilingual-wordnet
lin baltimore_PN = mkPN "巴爾的摩" ; -- comment=src=geonames status=guess
lin baluster_N = mkN "扶栏支柱" ; -- open-multilingual-wordnet
lin balustrade_N = mkN "扶手" | mkN "栏杆" | mkN "栏杆的支柱" | mkN "楼梯栏杆小柱" ; -- open-multilingual-wordnet
lin bamboo_N = mkN "竹子" | {-HSK-} mkN "竹子" "棵" ; -- status=guess
lin ban_N = mkN "禁令" ;
lin ban_V2 = mkV2 "禁止" ;
lin banal_A = mkA "平庸" ;
lin banana_N = mkN "香蕉" | {-HSK-} mkN "香蕉" "枝" ;
lin banbury_PN = foreignPN "Banbury" ; -- comment=src=geonames status=guess
lin band_N = mkN "乐队" | {-HSK-} mkN "带" "條" ;
lin band_V = mkV "用带绑扎" ;
lin band_V2 = mkV2 "乐队" ;
lin bandage_N = mkN "绷带" ;
lin bandanna_N = mkN "印花丝巾" | mkN "印花大手帕" | mkN "大手帕" | mkN "头巾" ; -- open-multilingual-wordnet
lin bandbox_N = mkN "圆筒形纸板盒" | mkN "硬纸盒" ; -- open-multilingual-wordnet
lin bandicoot_N = mkN "袋狸" ; -- status=guess
lin bandit_N = mkN "匪徒" | mkN "土匪" ; -- status=guess -- status=guess
lin band_saw_N = mkN "带锯" | mkN "锯" ; -- open-multilingual-wordnet
lin bandstand_N = mkN "露天音乐台" ; -- open-multilingual-wordnet
lin bandung_PN = mkPN "萬隆" ; -- comment=src=geonames status=guess
lin bandwagon_N = mkN "花车" ;
lin bandwidth_N = mkN "帶寬" | mkN "带宽" | mkN "頻帶" | mkN "频带" | mkN "頻寬" | mkN "频宽" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin bandy_V2 = mkV2 "打来打去" ;
lin bane_N = mkN "毒药" ;
lin bang_N = mkN "重击" ;
lin bang_V = mkV "重击" ;
lin bang_V2 = mkV2 "砰" ;
lin bangalore_PN = mkPN "班加羅爾" ; -- comment=src=geonames status=guess
lin banger_N = mkN "爆竹" | mkN "鞭炮" ; -- open-multilingual-wordnet
lin bangkok_PN = mkPN "曼谷" ;
lin bangladesh_PN = mkPN "孟加拉" ; -- comment=src=geonames status=guess
lin bangor_PN = mkPN "班戈" ; -- comment=src=geonames status=guess
lin banian_N = mkN "宽松的衬衫" ; -- open-multilingual-wordnet
lin banish_V2 = mkV2 "放逐" ;
lin banishment_N = mkN "流放" ; -- comment="充军" ;
lin banister_N = mkN "欄杆" | mkN "栏杆" | {-mwn-} mkN "扶手" | mkN "栏杆的支柱" | mkN "楼梯栏杆小柱" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin banjo_N = mkN "班卓琴" ; -- status=guess -- open-multilingual-wordnet
lin bank_1_N = mkN "岸" "個" ;
lin bank_2_N = L.bank_N ;
lin bank_V = mkV "银行" "家" ;
lin bank_V2 = mkV2 "将+存入银行" ;
lin bank_book_N = mkN "银行存折" ; -- open-multilingual-wordnet
lin banker_N = mkN "银行家" ;
lin banking_N = mkN "银行业" ;
lin banknote_N = mkN "鈔票" | mkN "钞票" | mkN "莊票" | mkN "庄票" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bankroll_N = mkN "一卷钞票" | mkN "手头的现金" | mkN "手头的钱" | mkN "现钞" ; -- open-multilingual-wordnet
lin bankrupt_A = mkA "破产" ;
lin bankrupt_V2 = mkV2 "破产" ;
lin bankruptcy_N = mkN "破产" ;
lin banner_A = mkA "一流" | mkA "优越" | mkA "杰出" | mkA "领先" ; -- open-multilingual-wordnet
lin banner_N = mkN "旗帜" "面" ;
lin bannister_N = mkN "扶手" | mkN "栏杆" | mkN "栏杆的支柱" | mkN "楼梯栏杆小柱" ; -- open-multilingual-wordnet
lin bannockburn_PN = foreignPN "Bannockburn" ; -- comment=src=geonames status=guess
lin banquet_N = mkN "宴会" | {-HSK-} mkN "宴会" "席" ;
lin banquet_V = mkV "参加宴会" ;
lin banquet_V2 = mkV2 "使+款待" ;
lin banquette_N = mkN "窗口凳" | mkN "软长椅" | mkN "长条形软座" ; -- open-multilingual-wordnet
lin banshee_N = mkN "女妖" ;
lin banter_N = mkN "戏谑" ;
lin bantry_PN = foreignPN "Bantry" ; -- comment=src=geonames status=guess
lin banyan_N = mkN "榕" | {-mwn-} mkN "宽松的衬衫" ; -- status=guess -- open-multilingual-wordnet
lin baobab_N = mkN "猴麵包樹" | mkN "猴面包树" | mkN "猢猻樹" | mkN "猢狲树" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin baptism_N = mkN "洗礼" "场" ;
lin baptismal_A = mkA "洗礼" ; -- open-multilingual-wordnet
lin bar_1_N = mkN "酒吧" ;
lin bar_2_N = variants {} ;
lin bar_V2 = mkV2 "阻挡" ;
lin baracaldo_PN = foreignPN "Baracaldo" ; -- comment=src=eng status=guess
lin barb_N = mkN "倒钩" ;
lin barbados_PN = mkPN "巴巴多斯" ; -- comment=src=geonames status=guess
lin barbara_PN = foreignPN "Barbara" ; -- comment=src=geonames status=guess
lin barbarian_A = mkA "蠻" | mkA "蛮" | mkA "野蠻" | mkA "野蛮" | {-mwn-} mkA "不文明" | mkA "原始" | mkA "未开化" | mkA "残暴" | mkA "残酷" | mkA "粗野" | mkA "野蛮" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin barbarian_N = mkN "野蠻人" | mkN "野蛮人" | mkN "番子" | mkN "蠻人" | mkN "蛮人" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin barbaric_A = mkA "野蠻" | mkA "野蛮" | mkA "殘暴" | mkA "残暴" | mkA "粗野" | {-mwn-} mkA "不文明" | mkA "原始" | mkA "未开化" | mkA "残暴" | mkA "残酷" | mkA "粗野" | mkA "野蛮" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin barbarism_N = mkN "暴虐" | mkN "暴行" | mkN "残忍" | mkN "残暴" | mkN "残酷" | mkN "野性" | mkN "野蛮" ; -- open-multilingual-wordnet
lin barbarity_N = mkN "暴虐" | mkN "暴行" | mkN "残忍" | mkN "残暴" | mkN "残酷" | mkN "野性" | mkN "野蛮" ; -- open-multilingual-wordnet
lin barbarous_A = mkA "不开化" | mkA "不文明" | mkA "原始" | mkA "未开化" | mkA "野蛮" ; -- open-multilingual-wordnet
lin barbasco_N = mkN "多花薯蓣" "个" ;
lin barbecue_N = mkN "烧烤" ;
lin barbecue_V2 = mkV2 (mkV "燒烤") | mkV2 (mkV "烧烤") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin barbel_N = mkN "触须" ; -- open-multilingual-wordnet
lin barbell_N = mkN "槓鈴" | mkN "杠铃" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin barber_N = mkN "理发师" ;
lin barberry_N = mkN "小檗" ; -- status=guess -- status=guess
lin barbershop_N = mkN "理发店" ; -- open-multilingual-wordnet
lin barbette_N = mkN "炮台" | mkN "炮墩" ; -- open-multilingual-wordnet
lin barbital_N = mkN "巴比妥" ; -- open-multilingual-wordnet
lin barbitone_N = mkN "巴比妥" ; -- open-multilingual-wordnet
lin barbiturate_N = mkN "巴比土酸鹽" | mkN "巴比土酸盐" | {-mwn-} mkN "巴比妥类药物" | mkN "巴比妥酸盐" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin barcelona_PN = mkPN "巴塞罗那" ;
lin bard_N = mkN "詩人" | mkN "诗人" | mkN "吟遊詩人" | mkN "吟游诗人" | {-mwn-} mkN "铠甲" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bardic_A = mkA "吟游诗人" ; -- open-multilingual-wordnet
lin bare_A = mkA "裸" ;
lin bare_V2 = mkV2 "裸露" ;
lin barefoot_A = mkA "赤腳" | mkA "赤脚" | mkA "光腳" | mkA "光脚" | {-mwn-} mkA "不穿鞋袜" | mkA "赤脚" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin barefoot_Adv = mkAdv "赤腳" | mkAdv "赤脚" ; -- status=guess -- status=guess
lin barefooted_A = mkA "赤腳" | mkA "赤脚" | {-mwn-} mkA "不穿鞋袜" | mkA "赤脚" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin barefooted_Adv = mkAdv "赤腳" | mkAdv "赤脚" ; -- status=guess -- status=guess
lin barely_Adv = adjAdv bare_A ; -- derived
lin bargain_N = mkN "议价" ;
lin bargain_V = mkV "讨价还价" "次" ;
lin bargain_V2 = variants {} ; -- comment=mkV "讨价还价" "次" ;
lin bargaining_N = mkN "议价" "次" ;
lin barge_N = mkN "驳船" "只" ;
lin barge_V = mkV "驳船" ;
lin barge_in_V = mkV "插嘴" | mkV "插话" ; -- open-multilingual-wordnet
lin bargello_N = mkN "巴杰洛线迹" | mkN "锯齿形针织法" ; -- open-multilingual-wordnet
lin bargoed_PN = foreignPN "Bargoed" ; -- comment=src=geonames status=guess
lin bari_PN = mkPN "巴里" ; -- comment=src=geonames status=guess
lin baric_A = mkA "含有钡" ; -- open-multilingual-wordnet
lin baritone_N = mkN "男中音" ;
lin barium_N = mkN "鋇" ; -- status=guess
lin bark_N = L.bark_N ;
lin bark_V = mkV "吠" ;
lin bark_V2 = mkV2 (mkV "汪汪叫") | mkV2 (mkV "吠") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin barking_PN = foreignPN "Barking" ; -- comment=src=geonames status=guess
lin barky_A = mkA "树皮" ; -- open-multilingual-wordnet
lin barley_N = mkN "大麦" ;
lin barn_N = mkN "谷仓" "个" ;
lin barnacle_N = mkN "藤壶" ;
lin barnard_castle_PN = foreignPN "Barnard castle" ; -- comment=src=eng status=guess
lin barn_door_N = mkN "挡光板" ; -- open-multilingual-wordnet
lin barnet_PN = mkPN "巴尼特區" ; -- comment=src=geonames status=guess
lin barnful_N = mkN "仓库存储量" ; -- open-multilingual-wordnet
lin barnoldswick_PN = foreignPN "Barnoldswick" ; -- comment=src=geonames status=guess
lin barnsley_PN = mkPN "巴恩斯利" ; -- comment=src=geonames status=guess
lin barnstaple_PN = foreignPN "Barnstaple" ; -- comment=src=geonames status=guess
lin barnyard_N = mkN "谷仓前的院地" ;
lin barographic_A = mkA "气压自记器" ; -- open-multilingual-wordnet
lin barometer_N = mkN "晴雨表" ;
lin barometric_A = mkA "气压" | mkA "气压表" | mkA "气压表表示" ; -- open-multilingual-wordnet
lin baron_N = mkN "男爵" ;
lin baroness_N = mkN "男爵夫人" | mkN "女性男爵" ; -- status=guess -- status=guess
lin barong_N = mkN "厚背薄刃刀" ; -- open-multilingual-wordnet
lin baroque_A = mkA "巴洛克式" ;
lin barque_N = mkN "三桅帆船" ; -- open-multilingual-wordnet
lin barrack_N = mkN "營房" | mkN "营房" | mkN "兵營" | mkN "兵营" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin barracuda_N = mkN "梭鱼" | mkN "梭鱼类" ; -- open-multilingual-wordnet
lin barrage_N = mkN "弹幕" ;
lin barramundi_N = mkN "尖吻鱸" | mkN "尖吻鲈" | mkN "巴拉曼底魚" | mkN "巴拉曼底鱼" | mkN "盲鰽" | mkN "盲鰽" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin barranquilla_PN = mkPN "巴兰基亚" ; -- comment=src=geonames status=guess
lin barrator_N = mkN "赃官" "个" ;
lin barrel_N = mkN "桶" ;
lin barrels_N = mkN "一桶的量" ; -- open-multilingual-wordnet
lin barren_A = mkA "荒芜" ;
lin barrette_N = mkN "发夹" | mkN "夹子的一种" ; -- open-multilingual-wordnet
lin barrhead_PN = foreignPN "Barrhead" ; -- comment=src=geonames status=guess
lin barricade_N = mkN "障碍" ;
lin barrier_N = mkN "屏障" ;
lin barrister_N = mkN "讼务律师" | mkN "大律师" | mkN "大状" ; -- status=guess -- status=guess -- status=guess
lin barroom_N = mkN "酒吧" | mkN "酒吧间" | mkN "酒馆" ; -- open-multilingual-wordnet
lin barrow_N = mkN "阉公猪" ; -- status=guess
lin barrow_in_furness_PN = foreignPN "Barrow-in-furness" ; -- comment=src=eng status=guess
lin barry_PN = mkPN "巴里" ; -- comment=src=geonames status=guess
lin bart_PN = foreignPN "Bart" ; -- comment=src=geonames status=guess
lin bartender_N = mkN "酒保" ;
lin barter_N = mkN "易货贸易""场" ;
lin barter_V = mkV "物物交换" ;
lin barter_V2 = mkV2 "易货" ;
lin bartholomew_PN = foreignPN "Bartholomew" ; -- comment=src=eng status=guess
lin barton_upon_humber_PN = foreignPN "Barton-upon-humber" ; -- comment=src=eng status=guess
lin barye_N = mkN "微巴" ; -- open-multilingual-wordnet
lin baryta_N = mkN "氧化钡" ; -- open-multilingual-wordnet
lin barytic_A = mkA "重土" ; -- open-multilingual-wordnet
lin basalt_N = mkN "玄武岩" ; -- status=guess -- open-multilingual-wordnet
lin basaltic_A = mkA "玄武岩" ; -- open-multilingual-wordnet
lin bascule_N = mkN "平衡装置" | mkN "活动结构" ; -- open-multilingual-wordnet
lin base_A = mkA "基地" | {-HSK-} mkA "基础" | mkA "底" | mkA "座" | mkA "脚" ;
lin base_N = mkN "基地" | {-HSK-} mkN "基础" "個" | mkN "底" | mkN "座" "個" | mkN "脚" "雙" ;
lin base_V = mkV "基于" ;
lin base_V2 = mkV2 "基于" ;
lin baseball_N = mkN "棒球" ;
lin baseboard_N = mkN "护壁板" | mkN "脚板" | mkN "踢脚板" ; -- open-multilingual-wordnet
lin basel_PN = mkPN "巴塞尔" ; -- comment=src=geonames status=guess
lin baseless_A = mkA "毫无根据" ;
lin baseline_N = mkN "底线" ; -- status=guess
lin basement_N = mkN "地下室" "间" ;
lin basenji_N = mkN "巴申纪狗" | mkN "巴辛吉狗" | mkN "猴面犬" ; -- open-multilingual-wordnet
lin bash_N = mkN "痛击" ;
lin bash_V2 = mkV2 "痛击" ;
lin bashful_A = mkA "害羞" ; -- status=guess
lin basic_A = mkA "元" | mkA "基本" | mkA "根本" ;
lin basic_N = mkN "元" | mkN "基本" | mkN "根本" "個" | {-HSK-} mkN "基础""" ;
lin basically_Adv = mkAdv "基本上" ;
lin basidial_A = mkA "担子" ; -- open-multilingual-wordnet
lin basidiolichen_N = mkN "担子菌地衣" ; -- open-multilingual-wordnet
lin basidiomycete_N = mkN "担子菌" ; -- open-multilingual-wordnet
lin basidiomycetous_A = mkA "担子菌类" | mkA "担子菌纲" ; -- open-multilingual-wordnet
lin basidium_N = mkN "担子" ; -- open-multilingual-wordnet
lin basil_N = mkN "羅勒" | mkN "罗勒" ; -- status=guess -- status=guess
lin basil_PN = foreignPN "Basil" ; -- comment=src=eng status=guess
lin basilar_A = mkA "基部" ; -- open-multilingual-wordnet
lin basildon_PN = mkPN "巴西爾登" ; -- comment=src=geonames status=guess
lin basilican_A = mkA "长方形建筑物" ; -- open-multilingual-wordnet
lin basin_N = mkN "盆" | {-HSK-} mkN "盆地" "个" ;
lin basinal_A = mkA "盆地相" ; -- open-multilingual-wordnet
lin basinet_N = mkN "一种轻钢盔" | mkN "带面甲的钢盔" | mkN "钢盔" ; -- open-multilingual-wordnet
lin basingstoke_PN = mkPN "貝辛斯托克" ; -- comment=src=geonames status=guess
lin basis_N = mkN "基础" | {-HSK-} mkN "基础" "個" | mkN "本" | mkN "根" | mkN "根据" "個" | mkN "道理" "個" ;
lin basiscopic_A = mkA "下侧" ; -- open-multilingual-wordnet
lin bask_V = mkV "沾光" ;
lin basket_N = mkN "篮" | {-HSK-} mkN "筐" ;
lin basketball_N = mkN "篮球" ;
lin basophilic_A = mkA "嗜碱" ; -- open-multilingual-wordnet
lin bass_N = mkN "低音" ;
lin bassine_N = mkN "柏辛纤维" ; -- open-multilingual-wordnet
lin bassoon_N = mkN "巴松管" ;
lin bast_N = mkN "韌皮" | mkN "韧皮" ; -- status=guess -- status=guess
lin bastard_N = mkN "混帐" "个" ;
lin bastardy_N = mkN "私生子" ; -- open-multilingual-wordnet
lin baste_N = mkN "假缝" | mkN "用长针脚疏缝" | mkN "疏缝" ; -- open-multilingual-wordnet
lin bastille_N = mkN "监狱" ; -- open-multilingual-wordnet
lin bastinado_V2 = mkV2 "杖" ;
lin bastion_N = mkN "阵地工事" ;
lin bastnasite_N = mkN "氟碳铈矿" ; -- open-multilingual-wordnet
lin bat_N = mkN "蝙蝠" ;
lin bat_V = mkV "击球" ;
lin bat_V2 = mkV2 "蝙蝠" ;
lin batch_N = mkN "批量" [] ;
lin bate_V2 = mkV2 "缓和" ;
lin batfish_N = mkN "蝙蝠鱼" ; -- open-multilingual-wordnet
lin bath_N = mkN "浴" ;
lin bath_PN = mkPN "巴斯" ; -- comment=src=geonames status=guess
lin bathe_N = mkN "沐浴""" ;
lin bathe_V = mkV "洗" | mkV "洗澡" ;
lin bathe_V2 = mkV2 "使+被水洗" | {-HSK-} mkV2 "洗" | mkV2 "洗澡" ;
lin bathgate_PN = foreignPN "Bathgate" ; -- comment=src=geonames status=guess
lin bathhouse_N = mkN "澡堂" | mkN "浴堂" | {-mwn-} mkN "浴场" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bathing_N = mkN "沐浴" ;
lin batholithic_A = mkA "岩基" ; -- open-multilingual-wordnet
lin bathrobe_N = mkN "浴衣" ; -- status=guess -- open-multilingual-wordnet
lin bathroom_N = mkN "卫生间" "間" | {-HSK-} mkN "浴室" ;
lin bathtub_N = mkN "浴缸" ;
lin bathyal_A = mkA "半深海" | mkA "次深海" ; -- open-multilingual-wordnet
lin bathymetric_A = mkA "海洋测深学" ; -- open-multilingual-wordnet
lin bathyscaphe_N = mkN "深潛器" | mkN "深潜器" | {-mwn-} mkN "深海潜水器" | mkN "深海潜测艇" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bathysphere_N = mkN "潛水球" | mkN "潜水球" | {-mwn-} mkN "海潜球" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin batik_N = mkN "巴蒂克印花布" | mkN "蜡染花布" | mkN "蜡防印花布" ; -- open-multilingual-wordnet
lin batiste_N = mkN "上等亚麻布" | mkN "细棉布" | mkN "细薄毛织物" | mkN "薄织的麻布" ; -- open-multilingual-wordnet
lin batley_PN = mkPN "巴特利" ; -- comment=src=geonames status=guess
lin baton_N = mkN "指揮棒" | mkN "指挥棒" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin battalion_N = mkN "营" ;
lin batten_N = mkN "压条" | mkN "固定板条" | mkN "板条" ; -- open-multilingual-wordnet
lin batter_N = mkN "击球手" | mkN "糊状物" "" | mkN "墙面向后倾斜" "" ;
lin batter_V = mkV "猛击" ;
lin batter_V2 = mkV2 "连击" ;
lin battering_N = mkN "破城槌" ; -- status=guess
lin battery_1_N = mkN "电池" | {-HSK-} mkN "电池" "節" ;
lin battery_2_N = mkN "电池" | {-HSK-} mkN "电池" "節" ;
lin batting_N = mkN "打击" ;
lin battle_N = mkN "战斗" ;
lin battle_V = mkV "战斗" ;
lin battle_V2 = mkV2 "战斗" ;
lin battlefield_N = mkN "战场" ;
lin battlefront_N = mkN "前线" ; -- open-multilingual-wordnet
lin battleground_N = mkN "战地" ;
lin battlement_N = mkN "城垛" | mkN "枪眼设备" ; -- open-multilingual-wordnet
lin battleship_N = mkN "戰艦" | mkN "战舰" | {-mwn-} mkN "战列舰" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin batwing_A = mkA "似蝙蝠翼" | mkA "状似蝙蝠之翼" ; -- open-multilingual-wordnet
lin baud_N = mkN "波特" ; -- status=guess -- open-multilingual-wordnet
lin baulk_V = mkV "不愿接受" | mkV "反抗" | mkV "抵制" ; -- open-multilingual-wordnet
lin bauxite_N = mkN "鋁土礦" | mkN "铝土矿" | {-mwn-} mkN "铁矾土" | mkN "铁铝氧石" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bauxitic_A = mkA "铁矾土" | mkA "铁铝氧石" ; -- open-multilingual-wordnet
lin bawbee_N = mkN "半便士" ; -- open-multilingual-wordnet
lin bawdy_A = mkA "下流" | mkA "卖淫" | mkA "猥亵" | mkA "说下流话" | mkA "说话猥亵" ; -- open-multilingual-wordnet
lin bay_A = mkA "枣色" | mkA "红棕色" | mkA "赤褐色" ; -- open-multilingual-wordnet
lin bay_N = mkN "海湾" ;
lin bayonet_N = mkN "刺刀" ; -- status=guess
lin bazooka_N = mkN "巴祖卡" | mkN "火箭筒" ; -- status=guess -- status=guess
lin bbc_PN = foreignPN "BBC" ; -- comment=src=eng status=guess
lin beach_N = mkN "岸" "個" | mkN "沙滩" "片" | {-HSK-} mkN "海滩" ;
lin beach_V2 = mkV2 "拖+上岸" ;
lin beacon_N = mkN "烽" | mkN "狼烟" | {-mwn-} mkN "灯塔" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin beaconsfield_PN = mkPN "比肯斯菲尔德" ; -- comment=src=geonames status=guess
lin bead_N = mkN "珠子" ; -- status=guess
lin beading_N = mkN "圆圈" | mkN "珠细工" | mkN "珠饰" | mkN "珠饰细工" ; -- open-multilingual-wordnet
lin beads_N = mkN "念珠" ; -- open-multilingual-wordnet
lin beady_A = mkA "明眸" ;
lin beagle_N = mkN "比哥猎狗" | mkN "毕尔格猎犬" ; -- open-multilingual-wordnet
lin beak_N = mkN "嘴" "張" | {-HSK-} mkN "鳥嘴" | mkN "鸟嘴" | mkN "嘴" | mkN "喙" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin beaker_N = mkN "大杯" | mkN "高脚杯" ; -- open-multilingual-wordnet
lin beam_N = mkN "横梁" ;
lin beam_V = mkV "束缚" ;
lin beam_V2 = mkV2 "光束" ;
lin beamish_A = mkA "微笑" | mkA "春风得意" | mkA "满面春风" ; -- open-multilingual-wordnet
lin bean_N = mkN "豆" ;
lin beanbag_N = mkN "豆袋沙发" | {-mwn-} mkN "小布袋" ; -- status=guess -- open-multilingual-wordnet
lin beanie_N = mkN "无檐小便帽" ; -- open-multilingual-wordnet
lin beanstalk_N = mkN "豆的主茎" | mkN "豆茎" ; -- open-multilingual-wordnet
lin bear_N = mkN "熊" "只" ;
lin bear_V = mkV "承受" | {-HSK-} mkV "承担" ;
lin bear_V2 = mkV2 "承受" | {-HSK-} mkV2 "承担" ;
lin bear_down_on_V2 = prepV2 (advV OP_bear_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin bear_on_V2 = prepV2 OP_bear_V OP_on_Prep ; -- guess-p-verb
lin bear_out_V2 = prepV2 OP_bear_V OP_out_Prep ; -- guess-p-verb
lin bear_up_V = advV OP_bear_V OP_up_Adv ; -- guess-p-verb
lin bear_up_under_V2 = prepV2 (advV OP_bear_V OP_up_Adv ) OP_under_Prep ; -- guess-p-verb
lin bear_with_V2 = prepV2 OP_bear_V OP_with_Prep ; -- guess-p-verb
lin bearable_A = mkA "可以忍受" ; -- comment=1
lin beard_N = {-HSK-} mkN "胡须" "根" | {-mwn-} mkN "足丝" ; -- open-multilingual-wordnet
lin beard_V2 = mkV2 "公然反对" ;
lin bearer_N = mkN "持票者" ;
lin bearing_N = mkN "态度" "個" | {-HSK-} mkN "轴承" ;
lin bearish_A = mkA "无礼" ;
lin bearsden_PN = foreignPN "Bearsden" ; -- comment=src=geonames status=guess
lin bearskin_N = mkN "大礼帽" | mkN "高帽" | mkN "高帽子" ; -- open-multilingual-wordnet
lin beast_N = mkN "兽" ;
lin beastly_A = variants {} ;
lin beastly_Adv = adjAdv beastly_A ; -- derived -- derived
lin beat_N = mkN "节拍" ;
lin beat_V = mkV "击败" | {-HSK-} mkV "赢" ;
lin beat_V2 = mkV2 "击败" | {-HSK-} mkV2 "赢" ;
lin beat_back_V = advV OP_beat_V OP_back_Adv ; -- guess-p-verb
lin beat_down_V = advV OP_beat_V OP_down_Adv ; -- guess-p-verb
lin beat_down_V2 = prepV2 OP_beat_V OP_down_Prep ; -- guess-p-verb
lin beat_out_V2 = prepV2 OP_beat_V OP_out_Prep ; -- guess-p-verb
lin beat_up_V2 = mkV2 "揍" ;
lin beaten_A = mkA "精疲力竭" ;
lin beater_N = mkN "攪拌器" | mkN "搅拌器" | {-mwn-} mkN "打的工具" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin beatific_A = mkA "祝福" ;
lin beating_N = mkN "跳动" ;
lin beatrice_PN = foreignPN "Beatrice" ; -- comment=src=geonames status=guess
lin beau_N = mkN "男朋友" | mkN "對象" | mkN "对象" ; -- status=guess -- status=guess -- status=guess
lin beaumaris_PN = foreignPN "Beaumaris" ; -- comment=src=geonames status=guess
lin beautician_N = mkN "美容師" | mkN "美容师" ; -- status=guess -- status=guess
lin beautiful_A = L.beautiful_A | {-HSK-} mkA "漂亮" | mkA "美丽" ;
lin beauty_N = mkN "美好" [] ;
lin beaver_N = mkN "海狸" | mkN "河狸" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin beaver_V = mkV "卖力工作" ; -- open-multilingual-wordnet
lin beaver_away_V = mkV "卖力工作" ; -- open-multilingual-wordnet
lin bebington_PN = foreignPN "Bebington" ; -- comment=src=geonames status=guess
lin because_Subj = S.because_Subj ;
lin because_of_Prep = mkPrep "因为" ;
lin beccles_PN = foreignPN "Beccles" ; -- comment=src=geonames status=guess
lin become_V = mkV "做" | mkV "成为" ;
lin become_V2 = mkV2 "做" | mkV2 "成为" ;
lin become_VA = L.become_VA | {-HSK-} mkVA "做" | mkVA "成为" ;
lin bed_N = mkN "床" ;
lin bed_V2 = mkV2 "床+张" ;
lin bedbug_N = mkN "臭蟲" | mkN "臭虫" | mkN "壁虱" ; -- status=guess -- status=guess -- status=guess
lin beddau_PN = foreignPN "Beddau" ; -- comment=src=geonames status=guess
lin bedder_N = mkN "花坛植物" ; -- open-multilingual-wordnet
lin bedding_N = mkN "寝具" "套" ;
lin bedevil_V2 = mkV2 "使+痛苦" ;
lin bedevilment_N = mkN "纠缠" | mkN "骚扰" ; -- open-multilingual-wordnet
lin bedewed_A = mkA "露湿" ; -- open-multilingual-wordnet
lin bedfast_A = mkA "卧床不起" ; -- open-multilingual-wordnet
lin bedfellow_N = mkN "伙伴" ;
lin bedford_PN = mkPN "貝德福" ; -- comment=src=geonames status=guess
lin bedfordshire_PN = foreignPN "Bedfordshire" ; -- comment=src=eng status=guess
lin bedlam_N = mkN "混乱" "处" ;
lin bedlington_PN = foreignPN "Bedlington" ; -- comment=src=geonames status=guess
lin bedouin_N = mkN "貝都因人" | mkN "贝都因人" ; -- status=guess -- status=guess
lin bedpan_N = mkN "便盆" ;
lin bedpost_N = mkN "床柱" | mkN "底柱" ; -- open-multilingual-wordnet
lin bedraggled_A = mkA "全身泥污" | mkA "被泥弄脏" ; -- open-multilingual-wordnet
lin bedridden_A = mkA "卧床不起" ;
lin bedrock_N = mkN "牢固基础" [] ;
lin bedroll_N = mkN "携带用铺盖" | mkN "睡袋" | mkN "铺盖" ; -- open-multilingual-wordnet
lin bedroom_N = mkN "卧室" "間" | {-HSK-} mkN "卧室" "间" ;
lin bedside_N = mkN "床头" ;
lin bedsit_N = mkN "卧室兼起居室" ; -- open-multilingual-wordnet
lin bedsitter_N = mkN "卧室兼起居室" ; -- open-multilingual-wordnet
lin bedsore_N = mkN "褥疮" ; -- open-multilingual-wordnet
lin bedspread_N = mkN "床單" | mkN "床单" | mkN "床罩" ; -- status=guess -- status=guess -- status=guess
lin bedstead_N = mkN "床架" | mkN "床的框架" ; -- open-multilingual-wordnet
lin bedstraw_N = mkN "活血草" | mkN "猪殃殃" | mkN "锯锯草" ; -- open-multilingual-wordnet
lin bedtime_N = mkN "就寝时间" "次" ;
lin bedwas_PN = foreignPN "Bedwas" ; -- comment=src=geonames status=guess
lin bee_N = mkN "蜜蜂" | {-HSK-} mkN "蜜蜂" "隻" ;
lin beebread_N = mkN "蜂的幼虫食料" | mkN "蜜蜂食料" ; -- open-multilingual-wordnet
lin beech_N = mkN "山毛櫸" | mkN "山毛榉" ; -- status=guess -- status=guess
lin beef_1_N = mkN "牛肉" [] ;
lin beef_2_N = mkN "牛肉" [] ;
lin beef_V = mkV "抱怨" ;
lin beefsteak_N = mkN "牛排" ; -- status=guess
lin beefy_A = mkA "结实" ;
lin beehive_N = mkN "蜂箱" | mkN "蜂巢" ; -- status=guess -- status=guess
lin beekeeping_N = mkN "養蜂" | mkN "养蜂" | mkN "養蜂業" | mkN "养蜂业" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin beep_N = mkN "哔哔" ;
lin beeper_N = mkN "BP机" | mkN "呼叫器" | mkN "蜂鸣器" ; -- open-multilingual-wordnet
lin beer_N = L.beer_N ;
lin beery_A = mkA "啤酒味" ; -- open-multilingual-wordnet
lin beeswax_N = mkN "蜂蜡" ;
lin beet_N = mkN "甜菜" ;
lin beetle_N = mkN "甲蟲" | mkN "甲虫" ; -- status=guess -- status=guess
lin beetroot_N = mkN "紅菜頭" | mkN "红菜头" | mkN "甜菜根" | mkN "甜菜" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin befall_V = mkV "偶然发生或出现" | mkV "碰巧发生或出现" ; -- open-multilingual-wordnet
lin befall_V2 = mkV2 "降临" ;
lin befitting_A = mkA "适合" ;
lin befogged_A = mkA "使酒醉昏迷" | mkA "烂醉" | mkA "酒醉" ; -- open-multilingual-wordnet
lin before_Adv = mkAdv "以前" ;
lin before_Prep = S.before_Prep ;
lin before_Subj = mkSubj "前" ;
lin beforehand_A = mkA "事先" ;
lin beforehand_Adv = mkAdv "事先" ;
lin befoulment_N = mkN "弄脏" | mkN "污染" | mkN "污秽" ; -- open-multilingual-wordnet
lin befriend_V2 = mkV2 "帮助" ;
lin beg_V = mkV "求" ;
lin beg_V2 = mkV2 "求" ;
lin beg_V2V = L.beg_V2V ;
lin beget_V2 = mkV2 "产生" ;
lin begetter_N = mkN "父" | mkN "父亲" | mkN "爸爸" | mkN "爹" ; -- open-multilingual-wordnet
lin beggar_N = mkN "乞丐" ;
lin begin_V = mkV "开始" ;
lin begin_V2 = mkV2 "开始" ;
lin begin_VV = mkVV "开始" ;
lin beginner_N = mkN "初學者" | mkN "初学者" ; -- status=guess -- status=guess
lin beginning_N = mkN "开始" | {-HSK-} mkN "开始" "個" ;
lin begrimed_A = mkA "污秽" | mkA "肮脏" ; -- open-multilingual-wordnet
lin begrudge_V2 = mkV2 "舍不得" | {-HSK-} mkV2 (mkV "妒忌") ; -- status=guess, src=wikt
lin beguine_N = mkN "比根" | mkN "比根舞" ; -- status=guess -- status=guess
lin behalf_N = mkN "代表" ;
lin behave_V = mkV "表现" ;
lin behavior_N = mkN "行为" | {-HSK-} mkN "行為" ; -- status=guess -- status=guess
lin behavioral_A = mkA "动作" | mkA "行为方面" ; -- open-multilingual-wordnet
lin behavioristic_A = mkA "行为主义" | mkA "行动主义" ; -- open-multilingual-wordnet
lin behaviour_N = mkN "行为" ;
lin behead_V2 = mkV2 "砍头" ;
lin behind_Adv = mkAdv "后面" | {-HSK-} mkAdv "背后" ;
lin behind_N = mkN "后面" | {-HSK-} mkN "屁股" ;
lin behind_Prep = S.behind_Prep ;
lin behold_V2 = mkV2 (mkV "看") ; -- status=guess, src=wikt
lin beholden_A = mkA "感激" ;
lin beige_A = mkA "米黃" | mkA "米黄" | mkA "米色" | {-mwn-} mkA "浅褐色" | mkA "米色" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin beige_N = mkN "米黃" | mkN "米黄" | mkN "米色" ; -- status=guess -- status=guess -- status=guess
lin being_N = mkN "存在" ;
lin beirut_PN = mkPN "贝鲁特" ;
lin beith_PN = foreignPN "Beith" ; -- comment=src=geonames status=guess
lin belated_A = mkA "迟到" ;
lin belch_N = mkN "嗝" ;
lin belch_V = mkV "打嗝" | mkV "噯氣" | mkV "嗳气" | mkV "飽嗝" | mkV "饱嗝" | mkV "嗝" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- open-multilingual-wordnet
lin belch_V2 = mkV2 (mkV "打嗝") | mkV2 (mkV "噯氣") | mkV2 (mkV "嗳气") | mkV2 (mkV "飽嗝") | mkV2 (mkV "饱嗝") | mkV2 (mkV "嗝") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin beleaguer_V2 = mkV2 "围攻" ;
lin belem_PN = foreignPN "Belem" ; -- comment=src=eng status=guess
lin belemnite_N = mkN "箭石" ; -- open-multilingual-wordnet
lin belemnitic_A = mkA "箭石" ; -- open-multilingual-wordnet
lin belfast_PN = mkPN ("贝尔法斯特" | "貝爾法斯特") ; -- comment=src=geonames status=guess
lin belfry_N = mkN "钟楼" ;
lin belgian_A = mkA "比利时" ;
lin belgium_PN = mkPN "比利时" ;
lin belgrade_PN = foreignPN "Belgrade" ; -- comment=src=geonames status=guess
lin belie_V2 = mkV2 "掩饰" ;
lin belief_N = mkN "信念" ;
lin believable_A = mkA "可信" ;
lin believe_V = mkV "以为" | mkV "信" | mkV "想" | mkV "认为" | {-HSK-} mkV "相信" ;
lin believe_V2 = mkV2 "以为" | mkV2 "信" | mkV2 "想" | mkV2 "认为" | {-HSK-} mkV2 "相信" ;
lin believe_VS = mkVS "以为" | mkVS "信" | mkVS "想" | mkVS "认为" | {-HSK-} mkVS "相信" ;
lin believer_N = mkN "信徒" "名" ;
lin belinda_PN = foreignPN "Belinda" ; -- comment=src=eng status=guess
lin belittle_V2 = mkV2 "轻视" ;
lin bell_N = mkN "钟" | {-HSK-} mkN "铃" "隻" ;
lin bell_V2 = mkV2 "使+装钟" ;
lin bella_PN = foreignPN "Bella" ; -- comment=src=geonames status=guess
lin belladonna_N = mkN "阿托品" | mkN "颠茄碱" ; -- open-multilingual-wordnet
lin bellarmine_N = mkN "贝拉明" "个" ;
lin bellboy_N = mkN "服務生" | mkN "服务生" ; -- status=guess -- status=guess
lin belle_PN = foreignPN "Belle" ; -- comment=src=geonames status=guess
lin belligerent_A = mkA "参战" | mkA "交战中" ; -- status=guess -- status=guess
lin bellows_N = mkN "風箱" | mkN "风箱" ; -- status=guess -- status=guess
lin bellpull_N = mkN "拉铃索" | mkN "钟的拉索" | mkN "钟绳" ; -- open-multilingual-wordnet
lin bellshill_PN = foreignPN "Bellshill" ; -- comment=src=geonames status=guess
lin bellwether_N = mkN "头羊" ;
lin belly_N = L.belly_N | {-HSK-} mkN "肚子" "個" ;
lin bellyache_N = mkN "肚子痛" | mkN "胃痛" | mkN "胃痛或肚痛" ; -- open-multilingual-wordnet
lin belo_horizonte_PN = mkPN "贝洛奥里藏特" ; -- comment=src=geonames status=guess
lin belong_to_V2 = mkV2 "属于" ;
lin beloved_A = mkA "亲爱" ;
lin beloved_N = mkN "心愛的人" | mkN "心爱的人" ; -- status=guess -- status=guess
lin below_Adv = mkAdv "下" | {-HSK-} mkAdv "下面" ;
lin below_Prep = mkPrep "在" "下面" ;
lin belper_PN = foreignPN "Belper" ; -- comment=src=geonames status=guess
lin belt_N = mkN "带" "條" | {-HSK-} mkN "带子" ;
lin belting_N = mkN "带料" ; -- open-multilingual-wordnet
lin beltway_N = mkN "环城高速公路" | mkN "环形公路" | mkN "环形路" | mkN "环路" ; -- open-multilingual-wordnet
lin beluga_N = mkN "白鯨" | mkN "白鲸" | mkN "貝魯卡鯨" | mkN "贝鲁卡鲸" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin belvedere_N = mkN "望景楼" | mkN "眺远亭" | mkN "瞭望台" | mkN "观景房" | mkN "观景楼" ; -- open-multilingual-wordnet
lin bemoan_V2 = mkV2 "哀叹" ;
lin bemused_A = mkA "困惑" ;
lin ben_PN = foreignPN "Ben" ; -- comment=src=eng status=guess
lin bench_N = mkN "台阶" | {-HSK-} mkN "长椅" ;
lin bend_N = {-HSK-} mkN "弯" "道" | {-mwn-} mkN "弯子" | mkN "弯曲" | mkN "曲线" ; -- open-multilingual-wordnet
lin bend_V = mkV "掰弯" ;
lin bend_V2 = mkV2 "弯曲" ;
lin bend_down_V = advV OP_bend_V OP_down_Adv ; -- guess-p-verb
lin bend_over_V = advV OP_bend_V OP_over_Adv ; -- guess-p-verb
lin bend_over_backwards_V = variants {} ; -- guess-p-verb
lin beneath_Adv = mkAdv "低" ;
lin beneath_Prep = mkPrep "下面" ;
lin benedictory_A = mkA "祝福" ; -- open-multilingual-wordnet
lin benefactor_N = mkN "恩人" ;
lin benefice_N = mkN "僧侣之禄" | mkN "圣俸" ; -- open-multilingual-wordnet
lin beneficent_A = mkA "仁慈" | mkA "慈善" | mkA "善行" ; -- status=guess -- status=guess -- status=guess
lin beneficial_A = mkA "有利" ;
lin beneficiary_A = mkA "受封" | mkA "受益" ; -- open-multilingual-wordnet
lin beneficiary_N = mkN "受益人" ;
lin benefit_N = mkN "优点" "個" | mkN "利益" "個" | mkN "好处" "個" | mkN "收获" | {-HSK-} mkN "得益" ;
lin benefit_V = mkV "得益" ;
lin benefit_V2 = mkV2 "得益" ;
lin benevolent_A = mkA "慈善" ;
lin benighted_A = mkA "愚昧" ;
lin benign_A = mkA "良性" ;
lin benin_PN = mkPN "贝宁" ; -- comment=src=geonames status=guess
lin benjamin_PN = foreignPN "Benjamin" ; -- comment=src=geonames status=guess
lin benny_PN = foreignPN "Benny" ; -- comment=src=eng status=guess
lin bent_A = mkA "弯" | {-HSK-} mkA "弯曲" ;
lin bent_N = mkN "弯" "道" | {-HSK-} mkN "爱好" ;
lin benthos_N = mkN "海底生物" | mkN "海底的动植物群" ; -- open-multilingual-wordnet
lin bentonite_N = mkN "膨润土" ; -- open-multilingual-wordnet
lin bentwood_N = mkN "曲木" ; -- open-multilingual-wordnet
lin benzene_N = mkN "苯" ; -- status=guess -- open-multilingual-wordnet
lin benzenoid_A = mkA "苯环型" ; -- open-multilingual-wordnet
lin benzine_N = mkN "石油醚" | {-mwn-} mkN "苯" ; -- status=guess -- open-multilingual-wordnet
lin benzoate_N = mkN "安息香酸盐" | mkN "甲苯酸盐" | mkN "苯甲酸盐" | mkN "苯甲酸酯" ; -- open-multilingual-wordnet
lin benzocaine_N = mkN "对氨基苯甲酸乙酯" ; -- status=guess
lin benzodiazepine_N = mkN "苯并二嗪" ; -- open-multilingual-wordnet
lin benzoic_A = mkA "安息香" ; -- open-multilingual-wordnet
lin benzol_N = mkN "苯" ; -- open-multilingual-wordnet
lin benzyl_N = mkN "苄" "个" ;
lin benzylic_A = mkA "苄型" | mkA "苄基" ; -- open-multilingual-wordnet
lin beograd_PN = foreignPN "Beograd" ; -- comment=src=eng status=guess
lin bequeath_V2 = mkV2 "遗赠" ;
lin bequest_N = mkN "遗产" ;
lin berate_V2 = mkV2 "严厉责备" ;
lin bereavement_N = mkN "喪親" | mkN "丧亲" | {-mwn-} mkN "悲哀" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin beret_N = mkN "贝雷帽" ;
lin bergamo_PN = mkPN "贝尔加莫" ; -- comment=src=geonames status=guess
lin bergen_PN = mkPN ("卑爾根" | "伯根") ; -- comment=src=geonames status=guess
lin bergenia_N = mkN "岩白菜属植物" ; -- open-multilingual-wordnet
lin berkelium_N = mkN "锫" ; -- status=guess
lin berkhamsted_PN = mkPN "伯克翰斯德" ; -- comment=src=geonames status=guess
lin berkshire_PN = foreignPN "Berkshire" ; -- comment=src=eng status=guess
lin berlin_PN = mkPN "柏林" ; -- comment=src=geonames status=guess
lin bermuda_PN = mkPN "百慕大" ; -- comment=src=geonames status=guess
lin bern_PN = mkPN "伯恩" ; -- comment=src=geonames status=guess
lin bernard_PN = foreignPN "Bernard" ; -- comment=src=eng status=guess
lin bernie_PN = foreignPN "Bernie" ; -- comment=src=geonames status=guess
lin berry_N = mkN "浆果" "颗" ;
lin berserk_A = mkA "狂暴" ; -- status=guess
lin bert_PN = foreignPN "Bert" ; -- comment=src=eng status=guess
lin berth_N = mkN "床位" ; -- status=guess
lin bertha_PN = foreignPN "Bertha" ; -- comment=src=eng status=guess
lin bertie_PN = foreignPN "Bertie" ; -- comment=src=eng status=guess
lin berwick_upon_tweed_PN = foreignPN "Berwick-upon-tweed" ; -- comment=src=eng status=guess
lin beryl_N = mkN "绿宝石" ; -- open-multilingual-wordnet
lin beryl_PN = foreignPN "Beryl" ; -- comment=src=eng status=guess
lin beryllium_N = mkN "鈹" | mkN "铍" ; -- status=guess -- status=guess
lin beset_V2 = mkV2 "困扰" ;
lin beside_Prep = mkPrep "旁边" ;
lin besides_Adv = mkAdv "另外" | mkAdv "并且" | mkAdv "此外" | mkAdv "除了" ;
lin besides_Prep = mkPrep "除了" "以外" ;
lin besiege_V2 = mkV2 "围攻" ;
lin besmirch_V2 = mkV2 (mkV "弄髒") | mkV2 (mkV "弄脏") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin besom_N = mkN "长柄细枝扫帚" ; -- open-multilingual-wordnet
lin besotted_A = mkA "喝醉" | mkA "喝醉了" | mkA "喝醉酒" | mkA "烂醉" | mkA "酒醉" | mkA "醉" | mkA "醉醺醺" ; -- open-multilingual-wordnet
lin bespoke_A = mkA "定制" ; -- status=guess
lin besprent_A = mkA "撒满" | mkA "洒满" | mkA "被撒满" | mkA "被洒满" | mkA "被铺满" | mkA "铺满" ; -- open-multilingual-wordnet
lin bess_PN = foreignPN "Bess" ; -- comment=src=eng status=guess
lin bessie_PN = foreignPN "Bessie" ; -- comment=src=eng status=guess
lin best_Adv = mkAdv "最好" ;
lin best_N = mkN "最好" | {-HSK-} mkN "最好的朋友" ; -- status=guess
lin best_V2 = mkV2 "胜过" ;
lin bestir_V2 = mkV2 (mkV "振作") ; -- status=guess, src=wikt
lin bestow_V2 = mkV2 "赐给" ;
lin best_seller_N = mkN "暢銷書" | mkN "畅销书" | mkN "熱門書籍" | mkN "热门书籍" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bestubbled_A = mkA "满是茬" ; -- open-multilingual-wordnet
lin bet_N = mkN "赌注" ;
lin bet_V = mkV "打赌" ;
lin bet_V2 = mkV2 "打赌" ;
lin bet_VS = mkVS "打赌" ;
lin beta_N = mkN "贝塔" ;
lin betaine_N = mkN "甜菜碱" ; -- open-multilingual-wordnet
lin bethel_N = mkN "水手的教堂" ; -- open-multilingual-wordnet
lin bethune_PN = foreignPN "Bethune" ; -- comment=src=eng status=guess
lin betray_V2 = mkV2 "卖" | mkV2 "露" | {-HSK-} mkV2 "背叛" ;
lin betrayer_N = mkN "背叛者" ;
lin betrothedFem_N = variants {} ; ---- sense to be split
lin betrothedMasc_N = variants {} ; ---- sense to be split
lin betsy_PN = foreignPN "Betsy" ; -- comment=src=eng status=guess
lin better_A = mkA "比較好" | mkA "比较好" | mkA "更好" | mkA "較好" | mkA "较好" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin better_Adv = mkAdv "更好" ;
lin better_N = mkN "长辈" ;
lin better_V2 = mkV2 "长辈" ;
lin betterment_N = mkN "改善" ;
lin betty_PN = foreignPN "Betty" ; -- comment=src=eng status=guess
lin betulaceous_A = mkA "桦属" ; -- open-multilingual-wordnet
lin between_Adv = mkAdv "中间" | {-HSK-} mkAdv "介于" ;
lin between_Prep = S.between_Prep ;
lin bevatron_N = mkN "质子加速器" ; -- open-multilingual-wordnet
lin bevel_N = mkN "斜角" | {-mwn-} mkN "斜角规" ; -- status=guess -- open-multilingual-wordnet
lin beverage_N = mkN "水" | mkN "饮料" | {-HSK-} mkN "饮料" "杯" ;
lin beverley_PN = foreignPN "Beverley" ; -- comment=src=geonames status=guess
lin bevy_N = mkN "一群" ;
lin beware_V = mkV "提防" ;
lin beware_V2 = mkV2 "提防" ;
lin bewdley_PN = mkPN "比尤德利" ; -- comment=src=geonames status=guess
lin bewilder_V2 = mkV2 "困惑" ;
lin bewitch_V2 = mkV2 "蛊惑" ;
lin bexhill_PN = foreignPN "Bexhill" ; -- comment=src=eng status=guess
lin bexley_PN = foreignPN "Bexley" ; -- comment=src=geonames status=guess
lin bey_N = mkN "巴依" ; -- status=guess
lin beyond_Adv = mkAdv "超越" ;
lin beyond_Prep = mkPrep "超出" "以外" ;
lin bezant_N = mkN "古代罗马金币" ; -- open-multilingual-wordnet
lin bezel_N = mkN "盤座" | mkN "盘座" | {-mwn-} mkN "凿子的刃角" | mkN "刀具的斜刃面" | mkN "刃角" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bhang_N = mkN "印度大麻" ; -- open-multilingual-wordnet
lin bhutan_PN = mkPN "不丹" ; -- comment=src=geonames status=guess
lin bias_N = mkN "偏见" "种" ;
lin bias_V2 = mkV2 "偏置" ;
lin biauricular_A = mkA "双耳" ; -- open-multilingual-wordnet
lin biaxial_A = mkA "二轴" | mkA "双轴" ; -- open-multilingual-wordnet
lin bib_N = mkN "圍兜" | mkN "围兜" | {-mwn-} mkN "围嘴" | mkN "围涎" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bible_N = mkN "圣经" ;
lin biblical_A = mkA "聖經" | mkA "圣经" ; -- status=guess -- status=guess
lin bibliographic_A = mkA "书籍解题" | mkA "著书目录" ; -- open-multilingual-wordnet
lin bibliography_N = mkN "目錄學" | mkN "目录学" ; -- status=guess -- status=guess
lin bibliolatrous_A = mkA "圣经崇拜" ; -- open-multilingual-wordnet
lin bibliomaniacal_A = mkA "有藏书癖" ; -- open-multilingual-wordnet
lin bibliophilic_A = mkA "藏书家" ; -- open-multilingual-wordnet
lin bibliopolic_A = mkA "书籍商" ; -- open-multilingual-wordnet
lin bibliothecal_A = mkA "属于图书馆" ; -- open-multilingual-wordnet
lin bibliotic_A = mkA "文献鉴定学" | mkA "笔迹鉴定学" ; -- open-multilingual-wordnet
lin bicameral_A = mkA "两院制" ;
lin bicapsular_A = mkA "两蒴" | mkA "二囊" ; -- open-multilingual-wordnet
lin bicarbonate_N = mkN "碳酸氢盐" ; -- open-multilingual-wordnet
lin bicentennial_A = mkA "二百周年" ;
lin bicentennial_N = mkN "两百周年纪念" ;
lin bicephalous_A = mkA "雙頭" | mkA "双头" | mkA "兩頭" | mkA "两头" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin biceps_N = mkN "二頭肌" | mkN "二头肌" | mkN "肱二頭肌" | mkN "肱二头肌" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bicester_PN = foreignPN "Bicester" ; -- comment=src=geonames status=guess
lin bichromate_N = mkN "重铬酸盐" ; -- open-multilingual-wordnet
lin bichromated_A = mkA "重铬酸盐" ; -- open-multilingual-wordnet
lin bicipital_A = mkA "具二头" | mkA "双头" | mkA "有两头" ; -- open-multilingual-wordnet
lin bicker_V = mkV "斗嘴" ;
lin bicolor_A = mkA "二色" | mkA "二色性" | mkA "双色" ; -- open-multilingual-wordnet
lin bicorn_A = mkA "双角" | mkA "新月状" ; -- open-multilingual-wordnet
lin bicorn_N = mkN "双角帽" ; -- open-multilingual-wordnet
lin bicuspid_A = mkA "有两个尖头" ; -- open-multilingual-wordnet
lin bicycle_N = mkN "自行车" "輛" | {-HSK-} mkN "自行车" "辆" ;
lin bicycle_V = mkV "骑自行车" ;
lin bicylindrical_A = mkA "双圆柱" | mkA "双柱面" | mkA "有两个筒面" ; -- open-multilingual-wordnet
lin bid_N = mkN "出价" ;
lin bid_V = mkV "出价" ; -- comment=NOT SURE "出价" or "投标"
lin bid_V2 = mkV2 "出价" ;
lin biddable_A = mkA "服从" | mkA "顺从" | mkA "驯服" ; -- open-multilingual-wordnet
lin bidder_N = mkN "投标人" ;
lin biddulph_PN = foreignPN "Biddulph" ; -- comment=src=geonames status=guess
lin bide_V2 = mkV2 (mkV "等待时机") | mkV2 (mkV "等机会") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin bideford_PN = foreignPN "Bideford" ; -- comment=src=geonames status=guess
lin bidentate_A = mkA "有二齿" ; -- open-multilingual-wordnet
lin bidet_N = mkN "坐浴桶" | mkN "坐浴盤" | mkN "智能廁板" | mkN "智能厕板" | {-mwn-} mkN "净身盆" | mkN "坐浴盘" | mkN "清洗盆" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bielefeld_PN = mkPN "比勒费尔德" ; -- comment=src=geonames status=guess
lin biennial_A = mkA "两年一次" ;
lin biff_N = mkN "以拳重击" | mkN "打" | mkN "拳" | mkN "拳打" ; -- open-multilingual-wordnet
lin bifid_A = mkA "两半" ; -- open-multilingual-wordnet
lin bifilar_A = mkA "双丝" | mkA "双线" | mkA "双股" ; -- open-multilingual-wordnet
lin biflagellate_A = mkA "双鞭毛" ; -- open-multilingual-wordnet
lin biform_A = mkA "二形" | mkA "二形结合" | mkA "有两形体" ; -- open-multilingual-wordnet
lin bifurcate_A = mkA "叉状" ; -- open-multilingual-wordnet
lin bifurcate_V2 = mkV2 "使+分叉" ;
lin big_A = L.big_A | {-HSK-} mkA "大" ;
lin bigamy_N = mkN "重婚" ; -- status=guess
lin bigeminal_A = mkA "二联" | mkA "成对" ; -- open-multilingual-wordnet
lin bigeye_N = mkN "大眼鲷" ; -- open-multilingual-wordnet
lin biggin_N = mkN "童帽" ; -- open-multilingual-wordnet
lin biggish_A = mkA "较大" ;
lin biggleswade_PN = foreignPN "Biggleswade" ; -- comment=src=geonames status=guess
lin bighead_N = mkN "大骨头病" ; -- open-multilingual-wordnet
lin bignoniaceous_A = mkA "紫葳属的植物" ; -- open-multilingual-wordnet
lin bignoniad_N = mkN "凌霄花" | mkN "紫葳" ; -- open-multilingual-wordnet
lin bigoted_A = mkA "固执己见" | mkA "顽固" ; -- open-multilingual-wordnet
lin bigotry_N = mkN "偏执" ;
lin bijou_N = mkN "宝石" | mkN "珠宝" | mkN "首饰" ; -- open-multilingual-wordnet
lin bike_N = L.bike_N | {-HSK-} mkN "自行车" "輛" ;
lin bike_V = mkV "自行车" ;
lin bikini_N = mkN "比基尼" "件" ;
lin bilabial_A = mkA "二唇" | mkA "双唇" ; -- open-multilingual-wordnet
lin bilateral_A = mkA "双方" | {-HSK-} mkA "双边" ;
lin bilbao_PN = mkPN "毕尔巴鄂" ; -- comment=src=geonames status=guess
lin bile_N = mkN "胆汁" "滴" ;
lin bilge_N = mkN "舱底" ;
lin bilharzia_N = mkN "血吸虫病" ; -- open-multilingual-wordnet
lin bilingual_A = mkA "两种语言" ;
lin bilingual_N = mkN "會雙語的人" | mkN "会双语的人" ; -- status=guess -- status=guess
lin bilingualism_N = mkN "双语" ; -- status=guess
lin bilious_A = mkA "坏脾气" ;
lin bilirubin_N = mkN "膽紅素" | mkN "胆红素" | {-mwn-} mkN "类胆红素" | mkN "血棕晶质" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bill_N = mkN "帐单" ;
lin bill_PN = foreignPN "Bill" ; -- comment=src=eng status=guess
lin bill_V = mkV "开账单" ;
lin bill_V2 = mkV2 "法案" ;
lin billboard_N = mkN "看板" | mkN "廣告牌" | mkN "广告牌" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin billericay_PN = foreignPN "Billericay" ; -- comment=src=geonames status=guess
lin billet_N = mkN "钢坯" ;
lin billfish_N = mkN "尖颚鱼" | mkN "长颚鱼" ; -- open-multilingual-wordnet
lin billhook_N = mkN "鉤鐮" | mkN "钩镰" ; -- status=guess -- status=guess
lin billiard_A = mkA "台球" ; -- open-multilingual-wordnet
lin billiards_N = mkN "台球" | mkN "撞球" | mkN "彈子" | mkN "弹子" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin billington_PN = foreignPN "Billington" ; -- comment=src=geonames status=guess
lin billion_N = mkN "十亿" ;
lin billionaire_N = mkN "億萬富翁" | mkN "亿万富翁" ; -- status=guess -- status=guess
lin billionth_N = mkN "十亿分之一" ; -- open-multilingual-wordnet
lin billow_V = mkV "翻腾" ;
lin billy_N = mkN "雄山羊" ; -- status=guess -- open-multilingual-wordnet
lin billy_PN = foreignPN "Billy" ; -- comment=src=eng status=guess
lin bilobate_A = mkA "两裂" | mkA "两裂片" | mkA "二裂片" | mkA "具两叶" | mkA "分为两裂片" ; -- open-multilingual-wordnet
lin bilocular_A = mkA "二格" ; -- open-multilingual-wordnet
lin bimetal_N = mkN "双金属材料" | mkN "复合金属" ; -- open-multilingual-wordnet
lin bimetallic_A = mkA "双金属" | mkA "复本位制" ; -- open-multilingual-wordnet
lin bimetallism_N = mkN "复本位制" | mkN "复本位币制" ; -- open-multilingual-wordnet
lin bimetallistic_A = mkA "双金属" | mkA "复本位制" ; -- open-multilingual-wordnet
lin bimillenial_A = mkA "两千年" ; -- open-multilingual-wordnet
lin bimolecular_A = mkA "双分子" | mkA "有两个分子" ; -- open-multilingual-wordnet
lin bin_N = mkN "箱子" ;
lin binary_A = mkA "二进制" | {-mwn-} mkA "二进位" ; -- status=guess -- open-multilingual-wordnet
lin binate_A = mkA "双生" | mkA "成对" ; -- open-multilingual-wordnet
lin bind_N = mkN "绑定" "种" ;
lin bind_V = mkV "系" | {-HSK-} mkV "结合" ;
lin bind_V2 = mkV2 "系" | {-HSK-} mkV2 "绑定" ;
lin binder_N = mkN "粘合剂" ;
lin bindery_N = mkN "装订所" ; -- open-multilingual-wordnet
lin binding_A = {-HSK-} mkA "结合" ;
lin binding_N = mkN "结合" "次" | {-HSK-} mkN "裝訂" | mkN "装订" ; -- status=guess -- status=guess
lin bindweed_N = mkN "旋花类的植物" ; -- open-multilingual-wordnet
lin binge_N = mkN "狂欢" ;
lin bingley_PN = mkPN "彬格莱" ;
lin binnacle_N = mkN "罗盘箱" | mkN "罗盘针柜" | mkN "罗盘针箱" | mkN "罗经座" | mkN "罗经柜" ; -- open-multilingual-wordnet
lin binocular_A = mkA "双目" | mkA "双目并用" | mkA "同时用双目" | mkA "用两眼" ; -- open-multilingual-wordnet
lin binoculars_N = mkN "望远镜" | {-mwn-} mkN "双目望远镜" | mkN "双目镜" | mkN "双眼望远镜" | mkN "观剧镜" | mkN "野外双筒望远镜" ; -- status=guess -- open-multilingual-wordnet
lin binomial_N = mkN "双名法" ; -- status=guess
lin biocatalyst_N = mkN "生物催化剂" ; -- open-multilingual-wordnet
lin biocatalytic_A = mkA "生物催化" ; -- open-multilingual-wordnet
lin biochemical_A = mkA "生化" | mkA "生物化学" ; -- open-multilingual-wordnet
lin biochemistry_N = mkN "生物化學" | mkN "生物化学" ; -- status=guess -- status=guess
lin biochip_N = mkN "生物晶片" | mkN "生物芯片" ; -- open-multilingual-wordnet
lin bioclimatic_A = mkA "生物气候学" ; -- open-multilingual-wordnet
lin biodegradable_A = mkA "可生物降解" ;
lin biogenetic_A = mkA "生物发生" | mkA "生物成因" | mkA "生物起源" ; -- open-multilingual-wordnet
lin biogenous_A = mkA "产生生命" ; -- open-multilingual-wordnet
lin biogeographic_A = mkA "生物地理" ; -- open-multilingual-wordnet
lin biographer_N = mkN "传记作者" ;
lin biographic_A = mkA "传记" | mkA "传记体" ; -- open-multilingual-wordnet
lin biographical_A = mkA "传记" | mkA "传记体" ; -- open-multilingual-wordnet
lin biography_N = mkN "传记" ;
lin biohazard_N = mkN "生物灾害" ; -- status=guess
lin biological_A = mkA "生命" | {-HSK-} mkA "生物" ;
lin biologism_N = mkN "生物主义" | mkN "生物学主义" ; -- open-multilingual-wordnet
lin biologist_N = mkN "生物学家" ;
lin biologistic_A = mkA "生物学家" ; -- open-multilingual-wordnet
lin biology_N = mkN "生物学" [] ;
lin biomass_N = mkN "生物量" ; -- status=guess
lin biophysics_N = mkN "生物物理学" ; -- status=guess
lin biopiracy_N = mkN "生物侵权" | mkN "生物剽窃" | mkN "生物掠夺" ; -- open-multilingual-wordnet
lin biosafety_N = mkN "生物安全" ; -- open-multilingual-wordnet
lin bioscope_N = mkN "放映机" ; -- open-multilingual-wordnet
lin biosphere_N = mkN "生物圈" ; -- status=guess
lin biosynthesis_N = mkN "生化合成" | mkN "生物合成" ; -- open-multilingual-wordnet
lin biosynthetic_A = mkA "生物合成" ; -- open-multilingual-wordnet
lin biosystematic_A = mkA "生物系统学" ; -- open-multilingual-wordnet
lin biota_N = mkN "生物区系" | mkN "生物群落" ; -- open-multilingual-wordnet
lin biotechnology_N = mkN "生物技术" ;
lin biotic_A = mkA "生物" ; -- open-multilingual-wordnet
lin biotite_N = mkN "黑云母" ; -- open-multilingual-wordnet
lin biotitic_A = mkA "黑云母" ; -- open-multilingual-wordnet
lin biotypic_A = mkA "生物型" ; -- open-multilingual-wordnet
lin bioweapon_N = mkN "生化武器" | mkN "生物武器" ; -- open-multilingual-wordnet
lin biparous_A = mkA "产双胎" ; -- open-multilingual-wordnet
lin bipartisan_A = mkA "两党" ;
lin biped_N = mkN "两足动物" ;
lin bipinnate_A = mkA "两羽状" ; -- open-multilingual-wordnet
lin bipolar_A = mkA "双极" ; -- open-multilingual-wordnet
lin biprism_N = mkN "双棱镜" ; -- open-multilingual-wordnet
lin biquadrate_N = mkN "四乘幂" ; -- open-multilingual-wordnet
lin biradial_A = mkA "两侧辐射对称" ; -- open-multilingual-wordnet
lin birch_A = mkA "桦木制" | mkA "桦木" | mkA "桦树" ; -- open-multilingual-wordnet
lin birch_N = mkN "樺木" | mkN "桦木" | mkN "樺" | mkN "桦" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bird's_eye_A = mkA "FOO" ;
lin bird_N = L.bird_N | {-HSK-} mkN "鸟" "隻" ;
lin birdbath_N = mkN "水盆" | mkN "鸟浴池" | mkN "鸟澡盆" ; -- open-multilingual-wordnet
lin birdcage_N = mkN "鸟笼" ;
lin birdcall_N = mkN "仿鸟声的器具" | mkN "鸟声模仿器" | mkN "鸟笛" ; -- open-multilingual-wordnet
lin birdhouse_N = mkN "禽舍" | mkN "小鳥舍" | mkN "小鸟舍" ; -- status=guess -- status=guess -- status=guess
lin birdie_N = mkN "小鳥" | mkN "小鸟" ; -- status=guess -- status=guess
lin birdlime_N = mkN "粘鸟胶" ; -- open-multilingual-wordnet
lin birefringent_A = mkA "双折射" ; -- open-multilingual-wordnet
lin biretta_N = mkN "四角帽" | mkN "法冠" ; -- open-multilingual-wordnet
lin birkenhead_PN = foreignPN "Birkenhead" ; -- comment=src=geonames status=guess
lin birling_N = mkN "水上踩滚木" | mkN "滚木材" | mkN "转木比赛" ; -- open-multilingual-wordnet
lin birstall_PN = foreignPN "Birstall" ; -- comment=src=eng status=guess
lin birth_N = mkN "分娩" "次" ;
lin birthday_N = mkN "生日" | {-HSK-} mkN "生日" "個" | {-HSK-} mkN "诞辰" ;
lin birthmark_N = mkN "痣" | mkN "胎記" | mkN "胎记" | mkN "Characters: 痣" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin birthplace_N = mkN "出生地" "处" ;
lin birthrate_N = mkN "出生率" ;
lin birthright_N = mkN "传家宝" ; -- status=guess -- status=guess
lin birtley_PN = foreignPN "Birtley" ; -- comment=src=geonames status=guess
lin biryani_N = mkN "印度香飯" | mkN "印度香饭" ; -- status=guess -- status=guess
lin biscuit_N = mkN "饼干" "份" | {-HSK-} mkN "饼干" "片" ;
lin biserrate_A = mkA "重锯齿状" ; -- open-multilingual-wordnet
lin bisexual_A = mkA "兩性" | mkA "两性" | mkA "雙性" | mkA "双性" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bisexual_N = mkN "雙性戀者" | mkN "双性恋者" ; -- status=guess -- status=guess
lin bishop's_cleeve_PN = foreignPN "Bishop's cleeve" ; -- comment=src=eng status=guess
lin bishop's_stortford_PN = foreignPN "Bishop's stortford" ; -- comment=src=eng status=guess
lin bishop_N = mkN "主教" ;
lin bishop_auckland_PN = foreignPN "Bishop auckland" ; -- comment=src=eng status=guess
lin bishopbriggs_PN = foreignPN "Bishopbriggs" ; -- comment=src=geonames status=guess
lin bismuth_N = mkN "鉍" | mkN "铋" ; -- status=guess -- status=guess
lin bismuthal_A = mkA "铋" ; -- open-multilingual-wordnet
lin bismuthic_A = mkA "含五价铋" | mkA "铋" ; -- open-multilingual-wordnet
lin bison_N = mkN "野牛" | {-mwn-} mkN "美洲野牛" ; -- status=guess -- open-multilingual-wordnet
lin bisontine_A = mkA "野牛般" ; -- open-multilingual-wordnet
lin bister_N = mkN "褐色颜料" ; -- open-multilingual-wordnet
lin bistro_N = mkN "小酒馆" ; -- open-multilingual-wordnet
lin bistroic_A = mkA "小酒馆" ; -- open-multilingual-wordnet
lin bit_N = mkN "位" ;
lin bitch_N = mkN "母狗" ;
lin bitchy_A = mkA "贱" ;
lin bite_N = mkN "咬伤" ;
lin bite_V = mkV "咬" ;
lin bite_V2 = L.bite_V2 | {-HSK-} mkV2 "咬" ;
lin bitewing_N = mkN "咬翼片" ; -- open-multilingual-wordnet
lin biting_A = mkA "刺骨" ;
lin bitmap_N = mkN "电位起伏象" | mkN "电子图象" ; -- open-multilingual-wordnet
lin bitter_A = mkA "苦" | {-HSK-} mkA "辛酸" ;
lin bitter_N = mkN "苦" | {-HSK-} mkN "苦味""" ;
lin bitterish_A = mkA "稍苦" ; -- open-multilingual-wordnet
lin bittern_N = mkN "鹭鸶" | mkN "麻鸭" ; -- open-multilingual-wordnet
lin bitterness_N = mkN "苦" "种" ;
lin bitthead_N = mkN "缆柱头" ; -- open-multilingual-wordnet
lin bitumastic_N = mkN "沥青砂胶" ; -- open-multilingual-wordnet
lin bitumen_N = mkN "瀝青" | mkN "沥青" ; -- status=guess -- status=guess
lin bituminoid_A = mkA "像沥青" ; -- open-multilingual-wordnet
lin bituminous_A = mkA "含沥青" | mkA "沥青" ; -- open-multilingual-wordnet
lin bivalve_A = mkA "双壳贝" ; -- open-multilingual-wordnet
lin bivalve_N = mkN "双壳类动物" | mkN "双壳贝" | mkN "瓣鳃" | mkN "瓣鳃动物" | mkN "瓣鳃纲软体动物" ; -- open-multilingual-wordnet
lin bivariate_A = mkA "二变量" | mkA "双变数" ; -- open-multilingual-wordnet
lin bivouac_N = mkN "宿营地" | mkN "营地" | mkN "露营" ; -- open-multilingual-wordnet
lin bivouac_V = mkV "宿营" | mkV "扎营" | mkV "露营" ; -- open-multilingual-wordnet
lin biz_N = mkN "商业" ;
lin bizarre_A = mkA "奇异" ;
lin blab_V = mkV "多嘴" ;
lin black_A = L.black_A | {-HSK-} mkA "黑" ;
lin black_N = mkN "黑" | {-HSK-} mkN "黑色" ;
lin black_V2 = mkV2 "黑色" ;
lin blackberry_N = mkN "黑莓" ; -- status=guess
lin blackbird_N = mkN "山鳥" | mkN "山鸟" | mkN "烏鶇" | mkN "乌鸫" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin blackboard_N = mkN "黑板" "块" | {-HSK-} mkN "黑板" "塊" ;
lin blackburn_PN = mkPN "布萊克本" ; -- comment=src=geonames status=guess
lin blackcurrant_N = mkN "黑醋栗" ; -- status=guess
lin blacken_V = mkV "变黑" ;
lin blacken_V2 = mkV2 "使+变黑" ;
lin blackfly_N = mkN "蚋" | mkN "黑蝇" ; -- open-multilingual-wordnet
lin blackhall_PN = foreignPN "Blackhall" ; -- comment=src=eng status=guess
lin blacking_N = mkN "鞋油" | mkN "黑色涂料" ; -- open-multilingual-wordnet
lin blackish_A = mkA "带黑色" ; -- open-multilingual-wordnet
lin blackjack_N = mkN "二十一點" | mkN "二十一点" ; -- status=guess -- status=guess
lin blackleg_N = mkN "工贼" | mkN "破坏罢工的工人" | mkN "破坏罢工者" ; -- open-multilingual-wordnet
lin blackleg_V = mkV "变节" | mkV "当工贼" ; -- open-multilingual-wordnet
lin blacklist_N = mkN "黑名單" | mkN "黑名单" ; -- status=guess -- status=guess
lin blackmail_N = mkN "勒索" | mkN "敲詐" | mkN "敲诈" | mkN "誅求" | mkN "诛求" | mkN "逼勒" | mkN "要挾" | mkN "要挟" | mkN "訛詐" | mkN "讹诈" | {-mwn-} mkN "敲诈函" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin blackmail_V2 = mkV2 "敲诈" ;
lin blackmailer_N = mkN "敲詐者" | mkN "敲诈者" | mkN "勒索者" ; -- status=guess -- status=guess -- status=guess
lin blackout_N = mkN "眩晕" ;
lin blackpoll_N = mkN "黑顶白颊林莺" "只" ;
lin blackpool_PN = mkPN "黑潭" ; -- comment=src=geonames status=guess
lin blacksmith_N = mkN "鐵匠" | mkN "铁匠" ; -- status=guess -- status=guess
lin blackwash_N = mkN "黑涂料" | mkN "黑色涂料" | mkN "黑颜料" ; -- open-multilingual-wordnet
lin blackwater_N = mkN "黑尿病" ; -- open-multilingual-wordnet
lin blackwood_PN = foreignPN "Blackwood" ; -- comment=src=geonames status=guess
lin bladder_N = mkN "膀胱" ;
lin bladderwort_N = mkN "狸藻属植物" | mkN "狸藻类的植物" ; -- open-multilingual-wordnet
lin bladdery_A = mkA "似或象囊状" | mkA "像气泡" | mkA "囊状" ; -- open-multilingual-wordnet
lin blade_N = mkN "叶片" ;
lin blae_A = mkA "深蓝色" | mkA "青灰色" ; -- open-multilingual-wordnet
lin blaenau_ffestiniog_PN = foreignPN "Blaenau-ffestiniog" ; -- comment=src=eng status=guess
lin blaenavon_PN = foreignPN "Blaenavon" ; -- comment=src=geonames status=guess
lin blaengwrach_PN = foreignPN "Blaengwrach" ; -- comment=src=eng status=guess
lin blain_N = mkN "水疱" | mkN "脓疱" ; -- open-multilingual-wordnet
lin blaina_PN = foreignPN "Blaina" ; -- comment=src=eng status=guess
lin blairgowrie_PN = foreignPN "Blairgowrie" ; -- comment=src=geonames status=guess
lin blame_N = mkN "责任" | {-HSK-} mkN "责任" "個" ;
lin blame_V = mkV "责备" ;
lin blame_V2 = mkV2 "责备" | {-HSK-} mkV2 "责怪" ;
lin blamelessness_N = mkN "无罪" ; -- open-multilingual-wordnet
lin blameworthiness_N = mkN "有罪" | mkN "有过失" ; -- open-multilingual-wordnet
lin bland_A = mkA "乏味" ;
lin blandness_N = mkN "温柔" ;
lin blank_A = mkA "呆" | mkA "白" | {-HSK-} mkA "空白" | {-HSK-} mkA "愣" ;
lin blank_N = mkN "呆" | mkN "白" | {-HSK-} mkN "空白" "块" ;
lin blanket_N = mkN "毯子" ;
lin blanket_V2 = mkV2 "覆盖" ;
lin blankness_N = mkN "空白" ; -- open-multilingual-wordnet
lin blanquillo_N = mkN "嵴颈方头鱼" | mkN "方头鱼" | mkN "瓦片鱼" ; -- open-multilingual-wordnet
lin blantyre_PN = mkPN "布兰太尔" ; -- comment=src=geonames status=guess
lin blare_V = mkV "高声发出" ;
lin blarney_N = mkN "谄媚" ;
lin blasphemous_A = mkA "亵渎神明" ;
lin blasphemy_N = mkN "褻瀆" | mkN "亵渎" ; -- status=guess -- status=guess
lin blast_N = mkN "爆破" ;
lin blast_V = mkV "吹" | {-HSK-} mkV "爆炸" ;
lin blast_V2 = mkV2 "吹" | {-HSK-} mkV2 "爆破" ;
lin blastemal_A = mkA "胚基" ; -- open-multilingual-wordnet
lin blastoderm_N = mkN "胚盘" ; -- status=guess
lin blastodermatic_A = mkA "胚层" | mkA "胚盘" ; -- open-multilingual-wordnet
lin blastogenetic_A = mkA "促进组织增生" | mkA "种质发生" | mkA "芽生" | mkA "遗传因子造成" ; -- open-multilingual-wordnet
lin blastoma_N = mkN "胚細胞瘤" | mkN "胚细胞瘤" ; -- status=guess -- status=guess
lin blastomeric_A = mkA "分裂球" ; -- open-multilingual-wordnet
lin blastomycete_N = mkN "芽生菌" ; -- open-multilingual-wordnet
lin blastomycosis_N = mkN "芽生菌病" ; -- open-multilingual-wordnet
lin blastomycotic_A = mkA "芽生菌病" ; -- open-multilingual-wordnet
lin blastospheric_A = mkA "囊胚" ; -- open-multilingual-wordnet
lin blatant_A = mkA "喧嚣" ;
lin blaze_N = mkN "火焰" ;
lin blaze_V = mkV "燃烧" ;
lin blazer_N = mkN "运动夹克" ; -- open-multilingual-wordnet
lin blazon_N = mkN "盾徽" | mkN "纹盾" | mkN "纹章" ; -- open-multilingual-wordnet
lin blazonry_N = mkN "盾徽" | mkN "纹盾" | mkN "纹章" ; -- open-multilingual-wordnet
lin bldg_PN = foreignPN "Bldg" ; -- comment=src=eng status=guess
lin bldgs_PN = foreignPN "Bldgs" ; -- comment=src=eng status=guess
lin bleach_N = mkN "漂白" ;
lin bleach_V = mkV "漂白" ; -- status=guess, src=wikt
lin bleach_V2 = mkV2 "漂白" ;
lin bleachers_N = mkN "露天看台" ; -- open-multilingual-wordnet
lin bleak_A = mkA "苍凉" ;
lin bleakness_N = mkN "凄凉的气氛" | mkN "黯淡" ; -- open-multilingual-wordnet
lin bleary_A = mkA "朦胧" | mkA "眼睛模糊" ; -- open-multilingual-wordnet
lin bleed_V = mkV "流血" ;
lin bleed_V2 = variants {} ; -- comment=mkV "流血" ;
lin bleed_VS = mkVS "流血" ;
lin bleed_off_V = mkV "放掉" ;
lin bleeding_N = mkN "出血" | mkN "滲色" | mkN "渗色" ; -- status=guess -- status=guess -- status=guess
lin bleep_N = mkN "尖銳聲音檢查員" | mkN "尖锐声音检查员" ; -- status=guess -- status=guess
lin bleep_V = mkV "发出哔哔声" ; -- open-multilingual-wordnet
lin blemish_N = mkN "污点" ;
lin blend_N = mkN "混杂物" ;
lin blend_V = mkV "混合" ;
lin blend_V2 = mkV2 "混和" ;
lin blender_N = mkN "混合器" | {-mwn-} mkN "搅拌器" ; -- status=guess -- open-multilingual-wordnet
lin blenny_N = mkN "鳚鱼" ; -- open-multilingual-wordnet
lin blepharism_N = mkN "睑痉挛" | mkN "脸痉挛性眨眼" ; -- open-multilingual-wordnet
lin blepharitis_N = mkN "目疡" | mkN "眼睑炎" ; -- open-multilingual-wordnet
lin bless_V2 = mkV2 "保佑" ;
lin blessedly_Adv = mkAdv "幸福" | mkAdv "愉快" | mkAdv "神圣" ; -- open-multilingual-wordnet
lin blessedness_N = mkN "幸福" ; -- open-multilingual-wordnet
lin blessing_N = mkN "祝福" ;
lin bletchley_PN = mkPN "布莱奇利" ; -- comment=src=geonames status=guess
lin blidworth_PN = foreignPN "Blidworth" ; -- comment=src=geonames status=guess
lin blight_N = mkN "枯萎病" ; -- open-multilingual-wordnet
lin blight_V2 = mkV2 "枯萎病" ;
lin blimp_N = mkN "軟式小型飛船" | mkN "软式小型飞船" | {-mwn-} mkN "软式小飞艇" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin blind_A = mkA "盲目" | {-HSK-} mkA "瞎" ;
lin blind_N = mkN "借口" | {-HSK-} mkN "瞎" ;
lin blindfold_N = mkN "眼罩" ;
lin blindfold_V2 = mkV2 "蒙住眼睛" ;
lin blindness_N = mkN "失明" ;
lin blink_N = mkN "眨眼" ;
lin blink_V = mkV "闪烁" ;
lin blink_V2 = mkV2 "眨眼" ;
lin blinker_N = mkN "闪光装置" ; -- open-multilingual-wordnet
lin blip_N = mkN "物体光点" ;
lin bliss_N = mkN "極樂" | mkN "极乐" | mkN "喜悅" | mkN "喜悦" | mkN "福佑" | mkN "幸福" | {-mwn-} mkN "狂喜" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin blister_N = mkN "氣泡" | mkN "气泡" ; -- status=guess -- status=guess
lin blithe_A = mkA "愉快" ;
lin blithesome_A = mkA "快乐无忧" | mkA "愉快" | mkA "无忧无虑" ; -- open-multilingual-wordnet
lin blitz_N = mkN "闪电战" ;
lin blizzard_N = mkN "暴風雪" | mkN "暴风雪" | mkN "大風雪" | mkN "大风雪" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bloat_N = mkN "肠道炎" ; -- open-multilingual-wordnet
lin bloated_A = mkA "发胀" ;
lin bloc_N = mkN "集团" ;
lin block_N = mkN "块" ;
lin block_V2 = mkV2 "挡" | mkV2 "阻止" ;
lin block_in_V2 = prepV2 (lin V OP_block_V2) OP_in_Prep ; -- guess-p-verb
lin block_off_V2 = prepV2 (lin V OP_block_V2) OP_off_Prep ; -- guess-p-verb
lin block_out_V2 = prepV2 (lin V OP_block_V2) OP_out_Prep ; -- guess-p-verb
lin block_up_V2 = prepV2 (lin V OP_block_V2) OP_up_Prep ; -- guess-p-verb
lin blockade_N = mkN "阻塞" ;
lin blockbuster_N = mkN "大片" "部" ;
lin blocker_N = mkN "阻滞剂" ; -- open-multilingual-wordnet
lin blockhead_N = mkN "傻子" | mkN "傻瓜" | {-HSK-} mkN "木头" ; -- status=guess -- status=guess
lin blockheaded_A = mkA "傻" | mkA "傻瓜" | mkA "愚笨" | mkA "愚蠢" | mkA "愚钝" | mkA "痴呆" | mkA "笨" | mkA "笨蛋" | mkA "迟钝" ; -- open-multilingual-wordnet
lin blockhouse_N = mkN "碉堡" ; -- open-multilingual-wordnet
lin blog_N = mkN "博客" | mkN "部落格" | mkN "博落" | mkN "網誌" | mkN "网志" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin bloke_N = mkN "家伙" "个" ;
lin blond_A = mkA "金发" ;
lin blonde_A = mkA "亚麻色" ;
lin blonde_N = mkN "金发" ;
lin blood_N = L.blood_N | {-HSK-} mkN "血" "滴" ;
lin blood_V2 = mkV2 "血" ;
lin blood_bath_N = mkN "血洗" | mkN "大屠殺" | mkN "大屠杀" ; -- status=guess -- status=guess -- status=guess
lin bloodguilt_N = mkN "杀人罪" ; -- open-multilingual-wordnet
lin bloodhound_N = mkN "大猎犬" | mkN "大警犬" | mkN "猎犬" | mkN "警犬" ; -- open-multilingual-wordnet
lin bloodmobile_N = mkN "流动献血车" | mkN "采血巡回车" ; -- open-multilingual-wordnet
lin bloodroot_N = mkN "血根草" ; -- status=guess
lin bloodshed_N = mkN "流血" | {-mwn-} mkN "淤血" | mkN "瘀血" ; -- status=guess -- open-multilingual-wordnet
lin bloodstained_A = mkA "血污" ; -- status=guess
lin bloodstone_N = mkN "鸡血石" ; -- open-multilingual-wordnet
lin bloodstream_N = mkN "血液" | mkN "血流" ; -- status=guess -- status=guess
lin bloodsucker_N = mkN "吸血鬼" | {-mwn-} mkN "吸血动物" | mkN "水蛭" | mkN "蚂蟥" ; -- status=guess -- open-multilingual-wordnet
lin bloodworm_N = mkN "红虫" "只" ;
lin bloody_A = mkA "血腥" ;
lin bloody_Adv = mkAdv "血腥" ;
lin bloody_minded_A = mkA "血腥" ;
lin bloom_V = mkV "开花" ;
lin blooming_N = mkN "开花" ; -- open-multilingual-wordnet
lin blossom_N = mkN "花" "朵" | {-HSK-} mkN "花丛" ;
lin blossom_V = mkV "开花" ;
lin blot_V2 = mkV2 "擦除" ;
lin blotter_N = mkN "記事簿" | mkN "记事簿" ; -- status=guess -- status=guess
lin blotto_A = mkA "喝醉" | mkA "喝醉了" | mkA "喝醉酒" | mkA "烂醉" | mkA "酒醉" | mkA "醉" | mkA "醉醺醺" ; -- open-multilingual-wordnet
lin blouse_N = mkN "女襯衫" | mkN "女衬衫" | {-HSK-} mkN "衬衫" "件" ; -- status=guess -- status=guess
lin blow_N = mkN "吹" ;
lin blow_V = L.blow_V | {-HSK-} mkV "吹" ;
lin blow_V2 = mkV2 "吹" | {-HSK-} mkV2 "打击" ;
lin blow_away_V = advV OP_blow_V OP_away_Adv ; -- guess-p-verb
lin blow_away_V2 = mkV2 (advV OP_blow_V OP_away_Adv ) ; -- guess-p-verb
lin blow_down_V2 = prepV2 OP_blow_V OP_down_Prep ; -- guess-p-verb
lin blow_dry_V2 = variants {} ; -- guess-p-verb
lin blow_in_V = advV OP_blow_V OP_in_Adv ; -- guess-p-verb
lin blow_off_V = advV OP_blow_V OP_off_Adv ; -- guess-p-verb
lin blow_off_V2 = prepV2 OP_blow_V OP_off_Prep ; -- guess-p-verb
lin blow_out_V2 = prepV2 OP_blow_V OP_out_Prep ; -- guess-p-verb
lin blow_over_V = advV OP_blow_V OP_over_Adv ; -- guess-p-verb
lin blow_up_V = mkV "扩大" | mkV "放大" ; -- open-multilingual-wordnet
lin blow_up_V2 = prepV2 OP_blow_V OP_up_Prep ; -- guess-p-verb
lin blower_N = mkN "鼓風機" | mkN "鼓风机" | {-mwn-} mkN "鲸目动物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin blowfish_N = mkN "河豚" ; -- status=guess
lin blowfly_N = mkN "麗蠅" | mkN "丽蝇" | mkN "綠頭蒼蠅" | mkN "绿头苍蝇" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin blowgun_N = mkN "吹箭" | {-mwn-} mkN "吹火筒" | mkN "吹矢枪" | mkN "吹管" | mkN "吹箭筒" | mkN "吹风管" | mkN "喷射筒" ; -- status=guess -- open-multilingual-wordnet
lin blowing_N = mkN "吹气" ; -- open-multilingual-wordnet
lin blowlamp_N = mkN "喷灯" ; -- open-multilingual-wordnet
lin blowsy_A = mkA "不自检点" | mkA "自甘堕落" ; -- open-multilingual-wordnet
lin blowtorch_N = mkN "喷灯" ;
lin blowzy_A = mkA "不自检点" | mkA "自甘堕落" ; -- open-multilingual-wordnet
lin blucher_N = mkN "一种半统靴" | mkN "半统鞋" ; -- open-multilingual-wordnet
lin bludgeon_N = mkN "棍棒" | {-mwn-} mkN "大头棒" | mkN "短棒" ; -- status=guess -- open-multilingual-wordnet
lin bludgeon_V2 = mkV2 "恫吓" ;
lin blue_A = L.blue_A | {-HSK-} mkA "蓝" ;
lin blue_N = mkN "蓝" | {-HSK-} mkN "蓝色" [] ;
lin blue_V2 = mkV2 "使+变蓝" ;
lin blue_collar_A = mkA "蓝色" ;
lin blueberry_N = mkN "藍莓" | mkN "蓝莓" ; -- status=guess -- status=guess
lin bluebird_N = mkN "藍知更鳥" | mkN "蓝知更鸟" ; -- status=guess -- status=guess
lin blueprint_N = mkN "计划" ;
lin blues_N = mkN "藍調" | mkN "蓝调" | mkN "布魯斯" | mkN "布鲁斯" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bluestone_N = mkN "蓝砂岩" | mkN "青石" ; -- open-multilingual-wordnet
lin bluetick_N = mkN "蓝斑猎狗" | mkN "蓝色快狗" ; -- open-multilingual-wordnet
lin bluetongue_N = mkN "藍舌病" | mkN "蓝舌病" | {-mwn-} mkN "兰舌病" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bluish_A = mkA "带蓝色" ;
lin blunder_N = mkN "大错" | {-HSK-} mkN "错" "個" ;
lin blunder_V = mkV "踉跄" ;
lin blunderbuss_N = mkN "雷筒" | mkN "雷管" | {-mwn-} mkN "老式短枪" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin blunt_A = mkA "不客气" | mkA "坦率" | mkA "干脆" | {-HSK-} mkA "钝" ;
lin blunt_V2 = mkV2 "钝" ;
lin blur_V = mkV "涂污" ;
lin blur_V2 = mkV2 "使+模糊" ;
lin blurb_N = mkN "大作廣告" | mkN "大作广告" ; -- status=guess -- status=guess
lin blurt_V2 = mkV2 (mkV "脫口而出") | mkV2 (mkV "脱口而出") | mkV2 (mkV "走嘴") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin blurt_out_V2 = mkV2 "脱口而出" ;
lin blush_N = mkN "害羞" | {-HSK-} mkN "胭脂" ; -- status=guess
lin blush_V = mkV "臉紅" | mkV "脸红" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin blushful_A = mkA "涨红脸" | mkA "玫瑰红色" | mkA "红色" | mkA "脸红" | mkA "蔷薇色" ; -- open-multilingual-wordnet
lin blyth_PN = foreignPN "Blyth" ; -- comment=src=geonames status=guess
lin bma_N = mkN "英国医学会" "个" ;
lin bo'ness_PN = foreignPN "Bo'ness" ; -- comment=src=eng status=guess
lin boa_N = mkN "蟒蛇" "条" ;
lin boar_N = mkN "公豬" | mkN "公豬" | {-mwn-} mkN "公猪" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin board_1_N = mkN "板" ;
lin board_2_N = mkN "板" ;
lin board_N = mkN "板" ; -- comment=already split
lin board_V2 = mkV2 "登机" ;
lin boarding_N = mkN "登船" | mkN "乘船" | mkN "上船" | mkN "登機" | mkN "登机" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin boardroom_N = mkN "会议室" ;
lin boardwalk_N = mkN "木板人行道" ; -- open-multilingual-wordnet
lin boast_N = mkN "自夸" ; -- comment="自吹自擂说" ;
lin boast_V = mkV "吹" | mkV "夸" | {-HSK-} mkV "吹牛" ;
lin boast_V2 = mkV2 "吹" | mkV2 "夸" | {-HSK-} mkV2 "夸口说" ;
lin boast_VS = mkVS "吹" | mkVS "夸" | {-HSK-} mkVS "自夸" ;
lin boastful_A = mkA "自誇" | mkA "自夸" ; -- status=guess -- status=guess
lin boat_N = L.boat_N ;
lin boat_V = mkV "划船" ;
lin boater_N = mkN "硬草帽" "顶" ;
lin boat_house_N = mkN "停船棚屋" ; -- open-multilingual-wordnet
lin boatload_N = mkN "船舶装载量" ; -- open-multilingual-wordnet
lin bob_PN = foreignPN "Bob" ; -- comment=src=eng status=guess
lin bobbin_N = mkN "線軸" | mkN "线轴" ; -- status=guess -- status=guess
lin bobble_N = mkN "漏接" ; -- status=guess
lin bobby_PN = foreignPN "Bobby" ; -- comment=src=eng status=guess
lin bobsled_N = mkN "大雪橇" | mkN "长橇" ; -- open-multilingual-wordnet
lin bobsleigh_N = mkN "有舵雪橇" | mkN "長雪橇" | mkN "长雪橇" | mkN "長橇" | mkN "长橇" | {-mwn-} mkN "大雪橇" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bobtail_N = mkN "截短的尾巴" | mkN "短尾巴" ; -- open-multilingual-wordnet
lin bocce_N = mkN "意大利式室外地滾球戲" | mkN "意大利式室外地滚球戏" ; -- status=guess -- status=guess
lin bochum_PN = mkPN "波鸿" ; -- comment=src=geonames status=guess
lin bode_V = mkV "预示" ;
lin bode_V2 = mkV2 "预兆" ;
lin bodega_N = mkN "小杂货店" | mkN "小杂货铺" ; -- open-multilingual-wordnet
lin bodice_N = mkN "女上衣的上部" | mkN "女服的紧身衣" ; -- open-multilingual-wordnet
lin bodily_A = variants {} ;
lin bodily_Adv = adjAdv bodily_A ; -- derived
lin bodkin_N = mkN "大针眼缝针" | mkN "粗针" ; -- open-multilingual-wordnet
lin bodmin_PN = mkPN "博德明" ; -- comment=src=geonames status=guess
lin body_N = mkN "身体" | {-HSK-} mkN "身体" "個" ;
lin bodybuilder_N = mkN "健美運動人員" | mkN "健美运动人员" ; -- status=guess -- status=guess
lin bodybuilding_N = mkN "健美運動" | mkN "健美运动" ; -- status=guess -- status=guess
lin bodyguard_N = mkN "保鑣" | mkN "保镳" | mkN "護衛" | mkN "护卫" | mkN "衛士" | mkN "卫士" | {-mwn-} mkN "保镖" | mkN "警卫" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin boffin_N = mkN "科學家" | mkN "科学家" ; -- status=guess -- status=guess
lin bog_N = mkN "沼澤" | mkN "沼泽" ; -- status=guess -- status=guess
lin bog_V = mkV "沼泽" ;
lin bogeyman_N = mkN "怪物" | mkN "魔鬼" ; -- status=guess -- status=guess
lin boggy_A = mkA "似沼泽" | mkA "多沼地" | mkA "沼地" | mkA "泥泞" | mkA "浸水" | mkA "浸满水" | mkA "湿地" ; -- open-multilingual-wordnet
lin bognor_PN = foreignPN "Bognor" ; -- comment=src=eng status=guess
lin bognor_regis_PN = foreignPN "Bognor regis" ; -- comment=src=eng status=guess
lin bogota_PN = foreignPN "Bogota" ; -- comment=src=geonames status=guess
lin bogus_A = mkA "伪造" ;
lin bohrium_N = mkN "𨨏" ; -- status=guess
lin boil_N = mkN "煮" ;
lin boil_V = mkV "开" | mkV "滚" | mkV "煮" ;
lin boil_V2 = mkV2 "开" | mkV2 "滚" | mkV2 "煮" | {-HSK-} mkV2 "熬" | {-HSK-} mkV2 "涮火锅" ;
lin boil_down_to_V2 = mkV2 "归结为" ;
lin boil_over_V = mkV "因沸溢出" | mkV "沸溢" | mkV "沸腾而溢出" ; -- open-multilingual-wordnet
lin boiler_N = mkN "锅" "口" | {-HSK-} mkN "锅炉" ;
lin boilerplate_N = mkN "锅炉钢板" ; -- open-multilingual-wordnet
lin boiling_Adv = mkAdv "沸腾" ; -- open-multilingual-wordnet
lin boiling_N = mkN "沸點" | mkN "沸点" ; -- status=guess -- status=guess
lin boisterous_A = mkA "喧鬧" | mkA "喧闹" | mkA "愛鬧" | mkA "爱闹" | mkA "狂歡" | mkA "狂欢" | mkA "狂暴" | mkA "猛烈" | mkA "哄然" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin bold_1_A = mkA "胆大" ;
lin bold_2_A = mkA "胆大" ;
lin boldon_PN = foreignPN "Boldon" ; -- comment=src=eng status=guess
lin bolete_N = mkN "牛肝菌" ; -- open-multilingual-wordnet
lin bolivia_PN = mkPN "玻利维亚" ;
lin boliviano_N = mkN "博利瓦洛" ; -- open-multilingual-wordnet
lin bollard_N = mkN "带缆桩" | mkN "系船柱" ; -- open-multilingual-wordnet
lin bollington_PN = foreignPN "Bollington" ; -- comment=src=geonames status=guess
lin bollock_N = mkN "桅肩滑车" ; -- open-multilingual-wordnet
lin bollworm_N = mkN "棉红铃虫" | mkN "棉铃虫" | mkN "红铃虫" ; -- open-multilingual-wordnet
lin bologna_PN = foreignPN "Bologna" ; -- comment=src=geonames status=guess
lin bolometer_N = mkN "测辐射热仪" | mkN "辐射热测定器" ; -- open-multilingual-wordnet
lin bolometric_A = mkA "测辐射热" ; -- open-multilingual-wordnet
lin bolshy_A = mkA "刁蛮" | mkA "反叛" | mkA "蛮横" ; -- open-multilingual-wordnet
lin bolsover_PN = foreignPN "Bolsover" ; -- comment=src=geonames status=guess
lin bolster_V = mkV "加强" ;
lin bolster_V2 = mkV2 "加强" ;
lin bolt_N = mkN "螺栓" ;
lin bolt_V = mkV "螺栓" ; -- comment="螺钉" ;
lin bolt_V2 = mkV2 "脱口而出" ;
lin bolton_PN = mkPN "博尔顿" ; -- comment=src=geonames status=guess
lin bolton_le_sands_PN = foreignPN "Bolton-le-sands" ; -- comment=src=eng status=guess
lin bolzano_PN = foreignPN "Bolzano" ; -- comment=src=geonames status=guess
lin bomb_N = mkN "炸弹" ;
lin bomb_V = mkV "轰炸" ;
lin bomb_V2 = mkV2 "轰炸" ; -- comment="投弹于" ;
lin bombard_V2 = mkV2 "轰击" ;
lin bombardment_N = mkN "炮击" ;
lin bombardon_N = mkN "低音大号" | mkN "邦巴东号" ; -- open-multilingual-wordnet
lin bombast_N = mkN "夸大的言辞" ;
lin bombastic_A = mkA "做作" | mkA "夸大" | mkA "夸夸其谈" | mkA "浮夸" | mkA "空洞" | mkA "说大话" ; -- open-multilingual-wordnet
lin bombay_PN = foreignPN "Bombay" ; -- comment=src=eng status=guess
lin bomber_N = mkN "轰炸机" "架" ;
lin bombing_N = mkN "轰炸" "次" ;
lin bomblet_N = mkN "小炸弹" ; -- open-multilingual-wordnet
lin bomb_proof_A = mkA "防弹" | mkA "防炮弹" ; -- open-multilingual-wordnet
lin bombshell_N = mkN "炸弹" ;
lin bomb_sight_N = mkN "投弹瞄准器" | mkN "炸弹瞄准器" | mkN "轰炸瞄准器" ; -- open-multilingual-wordnet
lin bombycid_N = mkN "蚕蛾" ; -- open-multilingual-wordnet
lin bona_fide_A = mkA "善意" ;
lin bonanza_N = mkN "富矿带" ;
lin bond_N = mkN "券" ;
lin bond_V2 = mkV2 "结合" ;
lin bondage_N = mkN "人身依附" | mkN "綁縛" | mkN "绑缚" ; -- status=guess -- status=guess -- status=guess
lin bondman_N = mkN "奴隸" | mkN "奴隶" | mkN "農奴" | mkN "农奴" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bondwoman_N = mkN "女奴隸" | mkN "女奴隶" ; -- status=guess -- status=guess
lin bone_A = mkA "骨头" ;
lin bone_N = L.bone_N | {-HSK-} mkN "骨头" "根" ;
lin bone_V2 = mkV2 "去骨" ;
lin bone_dry_A = mkA "十分干" | mkA "干透" | mkA "极干" | mkA "非常干燥" ; -- open-multilingual-wordnet
lin bonemeal_N = mkN "骨粉" ; -- open-multilingual-wordnet
lin boner_N = mkN "勃起" ; -- status=guess
lin boneshaker_N = mkN "旧式自行车" | mkN "破车" ; -- open-multilingual-wordnet
lin bonfire_N = mkN "篝火" ;
lin bong_N = mkN "大麻煙槍" | mkN "大麻烟枪" ; -- status=guess -- status=guess
lin bongo_N = mkN "邦哥鼓" | {-mwn-} mkN "小鼓" ; -- status=guess -- open-multilingual-wordnet
lin bonito_N = mkN "鲣" ; -- open-multilingual-wordnet
lin bonn_PN = mkPN "波恩" ;
lin bonnet_N = mkN "软帽" ;
lin bonnybridge_PN = foreignPN "Bonnybridge" ; -- comment=src=geonames status=guess
lin bonnyrigg_PN = foreignPN "Bonnyrigg" ; -- comment=src=geonames status=guess
lin bonsai_N = mkN "盆景" | mkN "盆栽" | {-mwn-} mkN "盆景植物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bonus_N = mkN "奖金" | {-HSK-} mkN "红" ;
lin boo_V2 = mkV2 "发出嘘声" ;
lin boob_N = mkN "咪咪" | {-mwn-} mkN "乳房" | mkN "波" | mkN "胸" | mkN "胸部" ; -- status=guess -- open-multilingual-wordnet
lin boob_V = mkV "做错" | mkV "出大错" | mkV "犯错误" ; -- open-multilingual-wordnet
lin booby_N = mkN "塘鹅" | {-mwn-} mkN "鲣鸟" ; -- status=guess -- open-multilingual-wordnet
lin booger_N = mkN "鼻屎" | mkN "乾鼻涕" | mkN "干鼻涕" | mkN "鼻牛兒" | mkN "鼻牛儿" | mkN "鼻牛" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin boogie_N = mkN "布吉伍吉" | mkN "搏基沃基" ; -- status=guess -- status=guess
lin book_N = L.book_N | {-HSK-} mkN "书" "本" | mkN "册" ;
lin book_V2 = mkV2 "预定" ;
lin book_up_V = mkV "全部预定" | mkV "预定一空" ; -- open-multilingual-wordnet
lin bookable_A = mkA "供预约" | mkA "可预定" | mkA "可预订" ; -- open-multilingual-wordnet
lin bookcase_N = mkN "書架" | mkN "书架" | mkN "書櫥" | mkN "书橱" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin book_end_N = mkN "書擋" | mkN "书挡" | {-mwn-} mkN "书夹" | mkN "书立" | mkN "书靠" | mkN "挡书板" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin booking_N = mkN "预订" ;
lin bookish_A = mkA "勤奋" | mkA "好学" | mkA "好读书" | mkA "用功" ; -- open-multilingual-wordnet
lin book_keeper_N = mkN "簿记""本" ;
lin bookkeeping_N = mkN "记账" ;
lin booklet_N = mkN "册" | {-HSK-} mkN "小册子" ;
lin bookmaker_N = mkN "賭注登記人" | mkN "赌注登记人" | mkN "賭博業者" | mkN "赌博业者" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bookmark_N = mkN "書籤" | mkN "书签" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bookmarker_N = mkN "书签" ; -- open-multilingual-wordnet
lin bookmobile_N = mkN "汽车图书馆" | mkN "流动图书车" | mkN "流动图书馆" ; -- open-multilingual-wordnet
lin bookseller_N = mkN "書商" | mkN "书商" ; -- status=guess -- status=guess
lin bookshelf_N = mkN "书架" "個" | {-HSK-} mkN "書架" | mkN "书架" | mkN "書櫥" | mkN "书橱" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bookshop_N = mkN "書店" | mkN "书店" | {-mwn-} mkN "书报摊" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bookstall_N = mkN "书店" | mkN "书报摊" ; -- open-multilingual-wordnet
lin boom_N = mkN "繁荣" ;
lin boom_V = mkV "繁荣" ;
lin boom_V2 = mkV2 "繁荣" ;
lin boomerang_N = mkN "回飛棒" | mkN "回飞棒" | mkN "迴旋鏢" | mkN "回旋镖" | mkN "飛去來器" | mkN "飞去来器" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin boon_N = mkN "福利" ;
lin boorish_A = mkA "粗野" ;
lin boost_N = mkN "促进" | mkN "鼓舞" "個" | {-HSK-} mkN "鼓舞" ;
lin boost_V2 = mkV2 "促进" ;
lin booster_N = mkN "增压器" ;
lin boot_N = L.boot_N ;
lin boot_V2 = mkV2 (mkV "踢") ; -- status=guess, src=wikt
lin bootee_N = mkN "童用毛线鞋" ; -- open-multilingual-wordnet
lin booth_N = mkN "货摊" ;
lin boothose_N = mkN "靴用袜" ; -- open-multilingual-wordnet
lin bootjack_N = mkN "V字形脱靴器" | mkN "脱靴器" ; -- open-multilingual-wordnet
lin bootlace_N = mkN "靴带" ; -- open-multilingual-wordnet
lin bootle_PN = mkPN "布特爾" ; -- comment=src=geonames status=guess
lin bootleg_N = mkN "长统靴上部" | mkN "靴帮" ; -- open-multilingual-wordnet
lin bootleg_V2 = mkV2 "私卖" ;
lin bootstrap_N = mkN "拔靴带" | mkN "提靴带" | mkN "靴襻" ; -- open-multilingual-wordnet
lin booty_N = mkN "贓物" | mkN "赃物" | {-mwn-} mkN "战利品" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin booze_N = mkN "酒宴" "次" ;
lin booze_V = mkV "豪饮" ;
lin boracic_A = mkA "含硼" | mkA "含硼素" | mkA "硼" ; -- open-multilingual-wordnet
lin borate_N = mkN "硼酸盐" | mkN "硼酸酯" ; -- open-multilingual-wordnet
lin borated_A = mkA "搀硼酸" ; -- open-multilingual-wordnet
lin borax_N = mkN "硼砂" ; -- open-multilingual-wordnet
lin bordeaux_PN = mkPN "波尔多" ; -- comment=src=geonames status=guess
lin border_N = mkN "边境" ;
lin border_V = mkV "接界" ;
lin border_V2 = mkV2 "与+接壤" ;
lin borderland_N = mkN "边疆" ;
lin borderline_N = mkN "国境" | mkN "界线" | mkN "疆界" | mkN "边境" | mkN "边界" | mkN "边界线" ; -- open-multilingual-wordnet
lin borders_PN = foreignPN "Borders" ; -- comment=src=eng status=guess
lin bordon_PN = foreignPN "Bordon" ; -- comment=src=geonames status=guess
lin bore_N = mkN "孔" ;
lin bore_V = mkV "烦扰" ;
lin bore_V2 = mkV2 "钻孔" ;
lin bored_A = {-HSK-} mkA "无聊" ;
lin boredom_N = mkN "无聊" [] ;
lin borer_N = mkN "钻孔器" "件" ;
lin boric_A = mkA "含硼" | mkA "含硼素" | mkA "硼" ; -- open-multilingual-wordnet
lin boring_A = mkA "无聊" ;
lin boris_PN = foreignPN "Boris" ; -- comment=src=eng status=guess
lin bornite_N = mkN "斑铜矿" ; -- open-multilingual-wordnet
lin boron_N = mkN "硼" ; -- status=guess
lin boronic_A = mkA "硼" ; -- open-multilingual-wordnet
lin borosilicate_N = mkN "硼硅酸盐" ; -- open-multilingual-wordnet
lin borough_N = mkN "镇" ;
lin borrow_V = mkV "借" | {-HSK-} mkV "假" | mkV "摘" ;
lin borrow_V2 = mkV2 "借" | {-HSK-} mkV2 "假" | mkV2 "摘" ;
lin borrow_VV = mkVV "借" | {-HSK-} mkVV "假" | mkVV "摘" ;
lin borrower_N = mkN "借款人" ;
lin borrowing_N = mkN "借贷" "次" ;
lin borsch_N = mkN "罗宋汤" "碗" ;
lin borzoi_N = mkN "俄國狼狗" | mkN "俄国狼狗" ; -- status=guess -- status=guess
lin boskopoid_A = mkA "博斯科普人" ; -- open-multilingual-wordnet
lin bosom_N = mkN "胸" ;
lin bosomed_A = mkA "胸部" ; -- open-multilingual-wordnet
lin bosomy_A = mkA "丰满" | mkA "乳房丰满" | mkA "胸部丰满" ; -- open-multilingual-wordnet
lin boson_N = mkN "玻色子" ; -- status=guess
lin boss_A = mkA "老板" | {-mwn-} mkA "极其杰出" ; -- open-multilingual-wordnet
lin boss_N = L.boss_N | {-HSK-} mkN "老板" ;
lin boss_V2 = mkV2 (mkV "督责") ; -- status=guess, src=wikt
lin bossy_A = mkA "专横" | mkA "傲慢" | mkA "强制" | mkA "断然" | mkA "独裁" | mkA "盛气凌人" ; -- open-multilingual-wordnet
lin boston_PN = mkPN "波士顿" ;
lin bot_N = mkN "肤蝇的幼虫" | mkN "马胃蝇蛆" | mkN "马蝇卵" ; -- open-multilingual-wordnet
lin bota_N = mkN "酒囊" ; -- open-multilingual-wordnet
lin botanic_A = mkA "植物" | mkA "植物学" ; -- open-multilingual-wordnet
lin botanical_A = mkA "植物" ;
lin botanical_N = mkN "植物" "種" | {-HSK-} mkN "植物園" | mkN "植物园" ; -- status=guess -- status=guess
lin botanist_N = mkN "植物学家" | mkN "植物学者" ; -- status=guess -- status=guess
lin botany_N = mkN "植物学" "" ;
lin botch_V2 = mkV2 "糟蹋" ;
lin botchy_A = mkA "笨拙" ; -- open-multilingual-wordnet
lin botfly_N = mkN "馬蠅" | mkN "马蝇" | {-mwn-} mkN "狂蝇" | mkN "肤蝇" | mkN "胃蝇" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin both7and_DConj = S.both7and_DConj ;
lin both_Adv = mkAdv "两" | {-HSK-} mkAdv "俩" | mkAdv "双" ;
lin both_Det = mkpDet "两" | mkpDet "俩" | mkpDet "双" | {-HSK-} mkpDet "两个都" ;
lin bother_N = mkN "烦恼" | mkN "烦扰" | mkN "麻烦" ; -- open-multilingual-wordnet
lin bother_V = mkV "打扰" ;
lin bother_V2 = mkV2 "打扰" ;
lin bother_V2V = mkV2V "打扰" | {-HSK-} mkV2V "麻烦" ;
lin bother_VV = mkVV "打扰" | {-HSK-} mkVV "麻烦" ;
lin bothersome_A = mkA "伤脑筋" ;
lin botryoid_A = mkA "一串葡萄状" | mkA "总状" | mkA "葡萄样状" | mkA "葡萄状" ; -- open-multilingual-wordnet
lin botswana_PN = mkPN "波札那" ; -- comment=src=geonames status=guess
lin bottle_N = mkN "瓶" | {-HSK-} mkN "瓶子" "個" ;
lin bottle_V2 = mkV2 "瓶子" ;
lin bottlebrush_N = mkN "洗瓶刷" ; -- open-multilingual-wordnet
lin bottlecap_N = mkN "瓶盖" ; -- open-multilingual-wordnet
lin bottleneck_N = mkN "瓶颈" ;
lin bottom_A = mkA "底" | {-HSK-} mkA "底部" ;
lin bottom_N = mkN "底" | {-HSK-} mkN "底部" ;
lin bottom_V = mkV "到达底部" ;
lin bottomless_A = mkA "深不可测" ;
lin bottommost_A = mkA "最下" | mkA "最低" | mkA "最底下" ; -- open-multilingual-wordnet
lin bottrop_PN = mkPN "博特罗普" ; -- comment=src=geonames status=guess
lin botuliform_A = mkA "腊肠形" | mkA "腊肠状" | mkA "香肠形" ; -- open-multilingual-wordnet
lin botulin_N = mkN "肉毒杆菌毒素" ; -- open-multilingual-wordnet
lin botulinal_A = mkA "肉毒菌" ; -- open-multilingual-wordnet
lin botulism_N = mkN "香腸中毒" | mkN "香肠中毒" | mkN "波特淋菌中毒" | {-mwn-} mkN "肉毒中毒" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin boudoir_N = mkN "闺房" ; -- open-multilingual-wordnet
lin bough_N = mkN "大树枝" | mkN "树干" | mkN "粗树枝" ; -- open-multilingual-wordnet
lin bouillabaisse_N = mkN "馬賽魚湯" | mkN "马赛鱼汤" ; -- status=guess -- status=guess
lin boulder_N = mkN "漂礫" | mkN "漂砾" | mkN "磐石" | mkN "頑石" | mkN "顽石" | mkN "圓石頭" | mkN "圆石头" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin boulevard_N = mkN "林荫大道" ;
lin bounce_N = mkN "反弹" ;
lin bounce_V = mkV "弹跳" ;
lin bounce_V2 = mkV2 "弹跳" ;
lin bound_N = mkN "边界" ;
lin bound_V = mkV "束缚" ;
lin bound_V2 = mkV2 "界" ;
lin bound_V2V = mkV2V "界" ;
lin boundary_N = mkN "边界" "条" ;
lin bountied_A = mkA "以奖金为报酬" | mkA "提供津贴" | mkA "有津贴" ; -- open-multilingual-wordnet
lin bounty_N = mkN "慷慨" ;
lin bouquet_N = mkN "花束" ; -- status=guess -- open-multilingual-wordnet
lin bourbon_N = mkN "波旁酒" "杯" ;
lin bourgeois_A = variants {} ;
lin bourgeoisie_N = mkN "資產階級" | mkN "资产阶级" | mkN "布爾喬亞" | mkN "布尔乔亚" | mkN "中產階級" | mkN "中产阶级" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin bourne_PN = foreignPN "Bourne" ; -- comment=src=geonames status=guess
lin bournemouth_PN = mkPN "伯恩茅斯" ; -- comment=src=geonames status=guess
lin bourse_N = mkN "交易所" ;
lin bout_N = mkN "拳击比赛" ;
lin boutique_N = mkN "精品店" "家" ;
lin boutonniere_N = mkN "纽孔花束" ; -- open-multilingual-wordnet
lin bovid_N = mkN "牛科动物" ; -- open-multilingual-wordnet
lin bovine_A = mkA "迟钝" ;
lin bovine_N = mkN "牛海绵状脑病" | mkN "疯牛病" ; -- status=guess -- status=guess
lin bow_N = mkN "鞠躬" ;
lin bow_V = mkV "鞠躬" ;
lin bow_V2 = mkV2 "弓" ;
lin bowburn_PN = foreignPN "Bowburn" ; -- comment=src=eng status=guess
lin bowel_N = mkN "肠" "根" ;
lin bower_N = mkN "閨房" | mkN "闺房" | {-mwn-} mkN "凉亭" | mkN "藤架" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bowfin_N = mkN "弓鳍鱼" ; -- status=guess
lin bowfront_A = mkA "向外弯" | mkA "向外弯曲" ; -- open-multilingual-wordnet
lin bowl_N = mkN "碗" | {-HSK-} mkN "碗" "隻" ;
lin bowl_V = mkV "碗" ;
lin bowl_V2 = mkV2 "使+旋转" ;
lin bowler_N = mkN "投球手" "名" ;
lin bowline_N = mkN "单套结" | mkN "帆脚索" ; -- open-multilingual-wordnet
lin bowling_N = mkN "保齡球" | mkN "保龄球" ; -- status=guess -- status=guess
lin bowls_N = mkN "草地滾球" | mkN "草地滚球" ; -- status=guess -- status=guess
lin bowman_N = mkN "射手" | mkN "弓射手" | mkN "弓术家" ; -- open-multilingual-wordnet
lin bowsprit_N = mkN "船首斜桅" | mkN "艏斜桅" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bowstring_N = mkN "弓弦" | mkN "弦" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin box_N = mkN "盒" ;
lin box_V = mkV "鬥拳" | mkV "斗拳" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin box_V2 = mkV2 (mkV "鬥拳") | mkV2 (mkV "斗拳") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin boxcar_N = mkN "有盖货车" | mkN "篷车" ; -- open-multilingual-wordnet
lin boxer_N = mkN "拳击手" ;
lin boxfish_N = mkN "箱魨" ; -- open-multilingual-wordnet
lin boxful_N = mkN "一箱之量" ; -- open-multilingual-wordnet
lin boxing_N = mkN "拳击" "场" ;
lin boxing_day_PN = foreignPN "Boxing day" ; -- comment=src=eng status=guess
lin boxwood_N = mkN "万年青" | mkN "千年矮" | mkN "小黄杨" | mkN "山黄杨" | mkN "瓜子黄杨" | mkN "百日红" | mkN "豆板黄杨" | mkN "黄杨" | mkN "黄杨木" ; -- open-multilingual-wordnet
lin boy_N = L.boy_N ;
lin boycott_N = mkN "联合抵制" "次" ;
lin boycott_V2 = mkV2 "抵制" ;
lin boyfriend_N = mkN "对象" "個" | {-HSK-} mkN "男朋友" ;
lin boyish_A = mkA "孩子气" ;
lin bra_N = mkN "胸罩" "件" ;
lin brace_N = mkN "支撑" | mkN "支柱" ; -- open-multilingual-wordnet
lin brace_V = mkV "振奋" ;
lin brace_V2 = mkV2 "紧缚" ;
lin bracelet_N = mkN "手鐲" | mkN "手镯" | mkN "鐲子" | mkN "镯子" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bracer_N = mkN "兴奋剂" | mkN "提神饮料" ; -- open-multilingual-wordnet
lin brachial_A = mkA "前肢" | mkA "臂状" ; -- open-multilingual-wordnet
lin brachiopod_A = mkA "腕足门" ; -- open-multilingual-wordnet
lin brachiopod_N = mkN "腕足动物" ; -- open-multilingual-wordnet
lin brachium_N = mkN "肱" | mkN "臂状突起" | mkN "臂状部分" ; -- open-multilingual-wordnet
lin brachydactyly_N = mkN "短指" | mkN "短指畸形" | mkN "短趾" ; -- open-multilingual-wordnet
lin brachypterous_A = mkA "短翅" ; -- open-multilingual-wordnet
lin bracken_N = mkN "羊齒" | mkN "羊齿" | mkN "蕨菜" ; -- status=guess -- status=guess -- status=guess
lin bracket_N = mkN "支架" ;
lin brackish_A = mkA "汽水" | mkA "半海水" ; -- status=guess -- status=guess -- status=guess
lin bracknell_PN = mkPN "布拉克內爾" ; -- comment=src=geonames status=guess
lin bract_N = mkN "苞片" ; -- status=guess
lin bracteal_A = mkA "似苞" ; -- open-multilingual-wordnet
lin bracteate_A = mkA "有苞" ; -- open-multilingual-wordnet
lin bracteolate_A = mkA "具小苞片" ; -- open-multilingual-wordnet
lin bracteole_N = mkN "小苞片" ; -- open-multilingual-wordnet
lin brad_N = mkN "活页纸书钉" | {-mwn-} mkN "平头形钉" | mkN "平头钉" | mkN "无头钉" | mkN "曲头钉" | mkN "角钉" ; -- status=guess -- open-multilingual-wordnet
lin bradawl_N = mkN "小锥" | mkN "打眼钉" | mkN "锥钻" ; -- open-multilingual-wordnet
lin bradford_PN = mkPN "布拉德福德" ; -- comment=src=geonames status=guess
lin bradford_on_avon_PN = foreignPN "Bradford-on-avon" ; -- comment=src=eng status=guess
lin bradycardia_N = mkN "减慢心率药" ; -- open-multilingual-wordnet
lin brag_N = mkN "吹牛""" ;
lin brag_V = mkV "吹" | {-HSK-} mkV "吹牛" ;
lin braggart_N = mkN "吹牛的" | mkN "牛皮大王" ; -- status=guess -- status=guess
lin bragging_N = mkN "吹牛" "" ;
lin brahmin_N = mkN "婆羅門" | mkN "婆罗门" ; -- status=guess -- status=guess
lin brahminic_A = mkA "婆罗门" ; -- open-multilingual-wordnet
lin braid_N = mkN "辫子" "根" ;
lin braid_V2 = mkV2 (mkV "編織") | mkV2 (mkV "编织") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin brail_N = mkN "卷帆索" ; -- open-multilingual-wordnet
lin braille_N = mkN "盲文" | mkN "點字" | mkN "点字" | mkN "凸字" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin brain_N = mkN "脑" ;
lin brainchild_N = mkN "脑力劳动产物" [] ;
lin brainless_A = mkA "瞎頭子" | mkA "瞎头子" | mkA "無頭腦" | mkA "无头脑" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin brainstorm_N = mkN "奇想" | mkN "妙计" | mkN "灵感" | mkN "灵机一动" ; -- open-multilingual-wordnet
lin braintree_PN = foreignPN "Braintree" ; -- comment=src=geonames status=guess
lin brainwave_N = mkN "奇想" | mkN "妙计" | mkN "灵感" | mkN "灵机一动" ; -- open-multilingual-wordnet
lin braise_V2 = mkV2 (mkV "燉") | mkV2 (mkV "炖") | mkV2 (mkV "蒸") | mkV2 (mkV "燴") | mkV2 (mkV "烩") | mkV2 (mkV "扒") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin brake_N = mkN "制动器" ;
lin brake_V = mkV "刹车" ;
lin brake_V2 = mkV2 (mkV "剎車") | mkV2 (mkV "刹车") | mkV2 (mkV "制動") | mkV2 (mkV "制动") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin bramble_N = mkN "黑莓" ; -- status=guess
lin brambling_N = mkN "燕雀" ; -- status=guess
lin bran_N = mkN "麸" ;
lin branch_N = mkN "分支" | {-HSK-} mkN "支" | mkN "部门" "個" ;
lin branch_V = mkV "分支" ;
lin branchial_A = mkA "鳃状" ; -- open-multilingual-wordnet
lin branching_N = mkN "分叉" | mkN "分支" | mkN "叉" | mkN "叉形物" ; -- open-multilingual-wordnet
lin branchiopod_A = mkA "鳃足动物" ; -- open-multilingual-wordnet
lin brand_N = mkN "商标" ;
lin brand_V2 = mkV2 "牌子" ;
lin brand_new_A = mkA "崭新" ;
lin branderburgh_PN = foreignPN "Branderburgh" ; -- comment=src=eng status=guess
lin brandish_V2 = mkV2 "挥" | {-HSK-} mkV2 "挥舞" ;
lin brandy_N = mkN "白兰地" "杯" ;
lin brash_A = mkA "无礼傲慢" ;
lin brasilia_PN = foreignPN "Brasilia" ; -- comment=src=eng status=guess
lin brass_N = mkN "黄铜" [] ;
lin brassard_N = mkN "臂章" | mkN "臂铠" ; -- open-multilingual-wordnet
lin brasserie_N = mkN "啤酒店" ; -- open-multilingual-wordnet
lin brassiere_N = mkN "奶罩" ;
lin brassy_A = mkA "似黄铜" ; -- open-multilingual-wordnet
lin brat_N = mkN "小子" ;
lin bratislava_PN = mkPN "布拉迪斯拉发" ; -- comment=src=geonames status=guess
lin brattice_N = mkN "间壁" | mkN "风墙" | mkN "风帘" | mkN "风障" ; -- open-multilingual-wordnet
lin bratwurst_N = mkN "德國碎肉香腸" | mkN "德国碎肉香肠" ; -- status=guess -- status=guess
lin braunschweig_PN = mkPN "不伦瑞克" ; -- comment=src=geonames status=guess
lin braunton_PN = foreignPN "Braunton" ; -- comment=src=geonames status=guess
lin brave_A = mkA "勇敢" ;
lin brave_N = mkN "勇敢" ;
lin brave_V2 = mkV2 "勇敢" ;
lin bravery_N = mkN "勇敢" | {-mwn-} mkN "勇气" | mkN "胆量" ; -- status=guess -- open-multilingual-wordnet
lin brawl_N = mkN "争吵" ;
lin brawny_A = mkA "强壮" ;
lin brazen_A = mkA "黄铜" | mkA "黄铜制" ; -- open-multilingual-wordnet
lin brazen_V2 = mkV2 "厚颜无耻" ;
lin brazier_N = mkN "火盆" ; -- open-multilingual-wordnet
lin brazil_PN = mkPN "巴西" ;
lin brazilian_A = mkA "巴西" ;
lin brazilian_N = mkN "巴西人" "名" ;
lin breach_N = mkN "突破口" ;
lin breach_V2 = mkV2 "突破" ;
lin bread_N = L.bread_N ;
lin breadbasket_N = mkN "面包篮" ; -- open-multilingual-wordnet
lin breadboard_N = mkN "面包板" ; -- open-multilingual-wordnet
lin breadcrumb_N = mkN "面包屑" | mkN "面包屑" ; -- status=guess -- status=guess
lin breadfruit_N = mkN "麵包樹" | mkN "面包树" ; -- status=guess -- status=guess
lin breadth_N = mkN "宽度" ;
lin breadwinner_N = mkN "養家活口的人" | mkN "养家活口的人" | mkN "養家的人" | mkN "养家的人" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin break_N = mkN "打破" ;
lin break_V = mkV "打破" | {-HSK-} mkV "断" | mkV "破" | mkV "破坏" ;
lin break_V2 = L.break_V2 | {-HSK-} mkV2 "断" | mkV2 "破" | mkV2 "破坏" ;
lin break_apart_V = advV OP_break_V OP_apart_Adv ; -- guess-p-verb
lin break_away_V = advV OP_break_V OP_away_Adv ; -- guess-p-verb
lin break_down_V = mkV "坏" | mkV "碎" ;
lin break_down_V2 = mkV2 "坏" | mkV2 "碎" ;
lin break_in_V = advV OP_break_V OP_in_Adv ; -- guess-p-verb
lin break_in_V2 = prepV2 OP_break_V OP_in_Prep ; -- guess-p-verb
lin break_in_on_V2 = prepV2 (advV OP_break_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin break_into_V2 = prepV2 OP_break_V OP_into_Prep ; -- guess-p-verb
lin break_off_V2 = prepV2 OP_break_V OP_off_Prep ; -- guess-p-verb
lin break_out_V = mkV "发生" ;
lin break_out_V2 = mkV2 "发生" ;
lin break_out_in_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin break_out_of_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin break_through_V2 = mkV2 "闯" ;
lin break_up_V = advV OP_break_V OP_up_Adv ; -- guess-p-verb
lin break_up_V2 = prepV2 OP_break_V OP_up_Prep ; -- guess-p-verb
lin breakable_N = mkN "脆的东西" | mkN "质脆物品" ; -- open-multilingual-wordnet
lin breakage_N = mkN "破损" ;
lin breakaway_N = mkN "分离" | mkN "脱离" | mkN "脱逃" | mkN "逃跑" ; -- open-multilingual-wordnet
lin breakdown_N = mkN "分解" [] ;
lin breaker_N = mkN "断路器" ;
lin breakfast_N = mkN "早饭" [] ;
lin breakfast_V = mkV "吃早餐" ;
lin breakneck_A = mkA "极快" | mkA "非常危险" ; -- open-multilingual-wordnet
lin breakthrough_N = mkN "突破" ;
lin breakwater_N = mkN "矶" ;
lin breast_N = L.breast_N ;
lin breastfeed_V = mkV "餵奶" | mkV "哺乳" | mkV "喂奶" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin breastfeed_V2 = mkV2 (mkV "餵奶") | mkV2 (mkV "哺乳") | mkV2 (mkV "喂奶") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin breastless_A = mkA "无胸" ; -- open-multilingual-wordnet
lin breaston_PN = foreignPN "Breaston" ; -- comment=src=eng status=guess
lin breast_plate_N = mkN "胸铠" | mkN "腹甲" ; -- open-multilingual-wordnet
lin breaststroke_N = mkN "蛙泳" | mkN "俯泳" | mkN "胸泳" ; -- status=guess -- status=guess -- status=guess
lin breath_N = mkN "呼吸""次" ;
lin breathalyser_N = mkN "呼吸测醉器" | mkN "酒精测定器" ; -- open-multilingual-wordnet
lin breathalyzer_N = mkN "酒精測定器" | mkN "酒精测定器" | {-mwn-} mkN "呼吸测醉器" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin breathe_V = L.breathe_V | {-HSK-} mkV "呼吸" ;
lin breathe_V2 = mkV2 "呼吸" ;
lin breather_N = mkN "呼吸者" ;
lin breathing_N = mkN "呼吸" ;
lin breathless_A = mkA "喘不过气来" ;
lin breathtaking_A = mkA "惊险" ;
lin breccia_N = mkN "角砾岩" ; -- open-multilingual-wordnet
lin brecknock_PN = foreignPN "Brecknock" ; -- comment=src=eng status=guess
lin breda_PN = mkPN "布雷达" ; -- comment=src=geonames status=guess
lin breech_N = mkN "后膛" ; -- open-multilingual-wordnet
lin breech_block_N = mkN "枪闩" | mkN "炮闩" ; -- open-multilingual-wordnet
lin breechcloth_N = mkN "土人的腰布" | mkN "缠腰布" | mkN "缠腰带" ; -- open-multilingual-wordnet
lin breeches_N = mkN "五分褲" | mkN "五分裤" | mkN "半長褲" | mkN "半长裤" | mkN "馬褲" | mkN "马裤" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin breechloader_N = mkN "后膛枪" | mkN "后膛炮" ; -- open-multilingual-wordnet
lin breed_N = mkN "品种" | {-HSK-} mkN "品种" "個" ;
lin breed_V = mkV "繁殖" ;
lin breed_V2 = mkV2 "繁育" ;
lin breeder_N = mkN "饲养员" ;
lin breeding_N = mkN "繁殖" ;
lin breedsall_PN = foreignPN "Breedsall" ; -- comment=src=eng status=guess
lin breeze_N = mkN "微风" "" ;
lin breezy_A = mkA "活泼" ;
lin bregmatic_A = mkA "前囟" ; -- open-multilingual-wordnet
lin bremen_PN = mkPN "不来梅" ;
lin bremerhaven_PN = mkPN "不来梅哈芬" ; -- comment=src=geonames status=guess
lin brenda_PN = foreignPN "Brenda" ; -- comment=src=eng status=guess
lin brent_PN = foreignPN "Brent" ; -- comment=src=geonames status=guess
lin brentwood_PN = foreignPN "Brentwood" ; -- comment=src=geonames status=guess
lin brescia_PN = mkPN "布雷西亚" ; -- comment=src=geonames status=guess
lin brest_PN = mkPN ("布雷斯特" | "布列斯特") ; -- comment=src=geonames status=guess
lin brew_N = mkN "啤酒" "杯" ;
lin brew_V = mkV "酝" ;
lin brew_V2 = mkV2 "酿造" ;
lin brewer_N = mkN "啤酒生产商" ;
lin brewery_N = mkN "酿酒厂" ;
lin brian_PN = foreignPN "Brian" ; -- comment=src=eng status=guess
lin briar_N = mkN "石楠根烟斗" ; -- open-multilingual-wordnet
lin bribe_N = mkN "贿赂" "次" ;
lin bribe_V = mkV "贿赂" ; -- comment="收买" ;
lin bribe_V2 = mkV2 "贿赂" ;
lin bribery_N = mkN "行贿" "次" ;
lin brick_N = mkN "砖" "块" ;
lin bricket_wood_PN = foreignPN "Bricket Wood" ; -- comment=src=eng status=guess
lin brickkiln_N = mkN "烧砖炉" | mkN "砖窑" ; -- open-multilingual-wordnet
lin bricklayer_N = mkN "磚匠" | mkN "砖匠" ; -- status=guess -- status=guess
lin brickyard_N = mkN "制砖场" | mkN "砖厂" ; -- open-multilingual-wordnet
lin bride_N = mkN "新娘" ;
lin bridesmaid_N = mkN "伴娘" | mkN "女儐相" | mkN "女傧相" ; -- status=guess -- status=guess -- status=guess
lin bridge_N = mkN "桥" | {-HSK-} mkN "桥" "座" ;
lin bridge_V2 = mkV2 "使+建立联接" ;
lin bridgend_PN = foreignPN "Bridgend" ; -- comment=src=geonames status=guess
lin bridget_PN = foreignPN "Bridget" ; -- comment=src=eng status=guess
lin bridgnorth_PN = foreignPN "Bridgnorth" ; -- comment=src=geonames status=guess
lin bridgwater_PN = foreignPN "Bridgwater" ; -- comment=src=geonames status=guess
lin bridle_N = mkN "轡" | mkN "辔" | mkN "轡頭" | mkN "辔头" | mkN "馬籠頭" | mkN "马笼头" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin bridlington_PN = foreignPN "Bridlington" ; -- comment=src=geonames status=guess
lin bridoon_N = mkN "轻勒" ; -- open-multilingual-wordnet
lin bridport_PN = foreignPN "Bridport" ; -- comment=src=geonames status=guess
lin brief_A = mkA "简要" ;
lin brief_N = mkN "简要" [] ;
lin brief_V2 = mkV2 "介绍" | {-HSK-} mkV2 "简报" ;
lin briefcase_N = mkN "公文包" "个" ;
lin briefing_N = mkN "简报" ;
lin brig_N = mkN "禁闭室" ; -- open-multilingual-wordnet
lin brig_PN = foreignPN "Brig" ; -- comment=src=geonames status=guess
lin brigade_N = mkN "旅" ;
lin brigand_N = mkN "強盜" | mkN "强盗" | mkN "土匪" ; -- status=guess -- status=guess -- status=guess
lin brigandine_N = mkN "锁子甲" | mkN "锁子盔的一种" | mkN "锁子铠的一种" ; -- open-multilingual-wordnet
lin brigantine_N = mkN "双桅帆船" ; -- open-multilingual-wordnet
lin brighouse_PN = foreignPN "Brighouse" ; -- comment=src=geonames status=guess
lin bright_A = mkA "亮" | {-HSK-} mkA "光" | mkA "白" | mkA "聪明" ;
lin bright_Adv = mkAdv "亮" | mkAdv "光" | mkAdv "白" | mkAdv "聪明" | {-HSK-} mkAdv "明亮" ;
lin brighten_V2 = mkV2 "闪亮" ;
lin brightlingsea_PN = foreignPN "Brightlingsea" ; -- comment=src=geonames status=guess
lin brightness_N = mkN "明亮" ; -- status=guess
lin brighton_PN = mkPN ("布莱顿" | "布赖顿") ; -- comment=src=geonames status=guess
lin brilliance_N = mkN "辉" ; -- status=guess
lin brilliant_A = mkA "精彩" | {-HSK-} mkA "辉煌" ;
lin brilliantine_N = mkN "润发油" | mkN "生发油" ; -- open-multilingual-wordnet
lin brim_N = mkN "边" "条" ;
lin brim_V = mkV "溢出" ;
lin brimless_A = mkA "无边" | mkA "无边缘" ; -- open-multilingual-wordnet
lin brimstone_N = mkN "硫黄" ;
lin brine_N = mkN "卤水" ;
lin bring_V2 = mkV2 "带" | {-HSK-} mkV2 "带来" ;
lin bring_V3 = mkV3 "促使" | {-HSK-} mkV3 "带" | {-HSK-} mkV3 "捎" ;
lin bring_about_V2 = mkV2 "产生" | mkV2 "促使" | mkV2 "创造" | mkV2 "实现" | mkV2 "导致" | mkV2 "造成" | {-HSK-} mkV2 "带来" ;
lin bring_along_V2 = prepV2 (lin V OP_bring_V2) OP_along_Prep ; -- guess-p-verb
lin bring_around_V2 = prepV2 (lin V OP_bring_V2) OP_around_Prep ; -- guess-p-verb
lin bring_away_V2 = mkV2 (advV (lin V OP_bring_V2) OP_away_Adv ) ; -- guess-p-verb
lin bring_back_V2 = mkV2 (advV (lin V OP_bring_V2) OP_back_Adv ) ; -- guess-p-verb
lin bring_down_V2 = mkV2 "减少" | {-HSK-} mkV2 "降低" ;
lin bring_forth_V = advV (lin V OP_bring_V2) OP_forth_Adv ; -- guess-p-verb
lin bring_forth_V2 = mkV2 (advV (lin V OP_bring_V2) OP_forth_Adv ) ; -- guess-p-verb
lin bring_forward_V2 = mkV2 "提前" ;
lin bring_in_V2 = mkV2 "带来" ;
lin bring_off_V2 = prepV2 (lin V OP_bring_V2) OP_off_Prep ; -- guess-p-verb
lin bring_on_V2 = prepV2 (lin V OP_bring_V2) OP_on_Prep ; -- guess-p-verb
lin bring_out_V2 = prepV2 (lin V OP_bring_V2) OP_out_Prep ; -- guess-p-verb
lin bring_out_in_V3 = variants {} ; -- guess-p-verb
lin bring_over_V2 = prepV2 (lin V OP_bring_V2) OP_over_Prep ; -- guess-p-verb
lin bring_round_V2 = prepV2 (lin V OP_bring_V2) OP_round_Prep ; -- guess-p-verb
lin bring_to_V2 = prepV2 (lin V OP_bring_V2) OP_to_Prep ; -- guess-p-verb
lin bring_up_V2 = mkV2 "培养" ;
lin brink_N = mkN "迫近" ;
lin briny_A = mkA "鹹" ; -- status=guess
lin brioche_N = mkN "奶油糕點" | mkN "奶油糕点" ; -- status=guess -- status=guess
lin briquet_N = mkN "炭砖" | mkN "煤球" | mkN "煤砖" | mkN "煤饼" | mkN "硬固燃料" ; -- open-multilingual-wordnet
lin briquette_N = mkN "炭砖" | mkN "煤球" | mkN "煤砖" | mkN "煤饼" | mkN "硬固燃料" ; -- open-multilingual-wordnet
lin brisbane_PN = foreignPN "Brisbane" ; -- comment=src=geonames status=guess
lin brisk_A = mkA "活泼" | {-HSK-} mkA "轻快" ;
lin bristle_V = mkV "发怒" ;
lin bristletail_N = mkN "蠹虫" | mkN "衣鱼" ; -- open-multilingual-wordnet
lin bristol_PN = mkPN ("布里斯托尔" | "布里斯托爾") ; -- comment=src=geonames status=guess
lin brit_N = mkN "哲水蚤" | mkN "海中微生物" ; -- open-multilingual-wordnet
lin britain_PN = mkPN "英国" ;
lin british_A = mkA "英国" ;
lin brittle_A = mkA "脆" ;
lin brixham_PN = foreignPN "Brixham" ; -- comment=src=geonames status=guess
lin brno_PN = mkPN "布爾諾" ; -- comment=src=geonames status=guess
lin broad_A = L.broad_A | {-HSK-} mkA "宽" ;
lin broad_N = mkN "大白天" | {-HSK-} mkN "宽" ; -- status=guess
lin broadax_N = mkN "大斧" | mkN "钺" ; -- open-multilingual-wordnet
lin broadband_A = mkA "宽频带" ; -- open-multilingual-wordnet
lin broadcast_Adv = mkAdv "广播" ;
lin broadcast_N = mkN "广播" | {-HSK-} mkN "广播" "個" ;
lin broadcast_V = mkV "播送" ; -- comment="播放" ;
lin broadcast_V2 = mkV2 "播放" ;
lin broadcaster_N = mkN "散布机" ; -- open-multilingual-wordnet
lin broadcasting_N = mkN "广播" ;
lin broaden_V = mkV "扩大" ;
lin broaden_V2 = mkV2 "扩大" ;
lin broadloom_A = mkA "织为单色宽幅" ; -- open-multilingual-wordnet
lin broadloom_N = mkN "阔幅织物" ; -- open-multilingual-wordnet
lin broadside_N = mkN "宽边" "条" ;
lin broadsword_N = mkN "阔刀" ; -- open-multilingual-wordnet
lin brocade_N = mkN "錦緞" | mkN "锦缎" | mkN "錦" | mkN "锦" | {-mwn-} mkN "织锦" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin brocade_V2 = mkV2 (mkV "織錦") | mkV2 (mkV "织锦") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin broccoli_N = mkN "西蘭花" | mkN "西兰花" | {-mwn-} mkN "椰菜" | mkN "球花甘蓝" | mkN "花椰菜" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin brochure_N = mkN "小册子" ;
lin brodiaea_N = mkN "卜若地" | mkN "布罗比亚" | mkN "帝王花" ; -- open-multilingual-wordnet
lin brogan_N = mkN "笨重的鞋子" ; -- open-multilingual-wordnet
lin brogue_N = mkN "笨重的鞋子" ; -- open-multilingual-wordnet
lin broiler_N = mkN "烤焙用具" ;
lin broke_A = mkA "破产" ;
lin broken_A = {-HSK-} mkA "坏" | mkA "破" ;
lin broker_N = mkN "经纪人" ;
lin brokerage_N = mkN "佣金" ;
lin brolly_N = mkN "伞" ; -- open-multilingual-wordnet
lin bromic_A = mkA "含有溴" | mkA "溴" ; -- open-multilingual-wordnet
lin bromidic_A = mkA "单调" | mkA "无聊" | mkA "陈腐" | mkA "陈词滥调" ; -- open-multilingual-wordnet
lin bromine_N = mkN "溴" ;
lin bromley_PN = foreignPN "Bromley" ; -- comment=src=geonames status=guess
lin bromoform_N = mkN "三溴甲烷" ; -- open-multilingual-wordnet
lin bromsgrove_PN = foreignPN "Bromsgrove" ; -- comment=src=geonames status=guess
lin bronchial_A = mkA "支气管" | mkA "细支气管" ; -- open-multilingual-wordnet
lin bronchiolar_A = mkA "细支气管" ; -- open-multilingual-wordnet
lin bronchitic_A = mkA "支气管炎" ; -- open-multilingual-wordnet
lin bronchitis_N = mkN "支氣管炎" | mkN "支气管炎" | {-mwn-} mkN "支气管感染" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bronchopneumonia_N = mkN "支气管肺炎" ; -- open-multilingual-wordnet
lin bronchoscope_N = mkN "支气管镜" | mkN "气管镜" ; -- open-multilingual-wordnet
lin bronchoscopic_A = mkA "支气管镜" ; -- open-multilingual-wordnet
lin bronchus_N = mkN "支氣管" | mkN "支气管" ; -- status=guess -- status=guess
lin bronco_N = mkN "野马" ;
lin bronze_A = mkA "青銅色" | mkA "青铜色" ; -- status=guess -- status=guess
lin bronze_N = mkN "青铜" ;
lin brooch_N = mkN "胸针" ;
lin brood_N = mkN "一窝" [] ;
lin broody_A = mkA "冥想" | mkA "沉思" | mkA "爱默想" | mkA "盘算" | mkA "细想" | mkA "默想" ; -- open-multilingual-wordnet
lin brook_N = mkN "小河" | mkN "溪流" ; -- status=guess -- status=guess
lin broom_N = mkN "掃帚" | mkN "扫帚" | mkN "掃把" | mkN "扫把" | mkN "帚" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin broomstick_N = mkN "扫帚柄" ; -- open-multilingual-wordnet
lin bros_PN = foreignPN "Bros" ; -- comment=src=eng status=guess
lin broth_N = mkN "汤" | {-HSK-} mkN "肉汤" "碗" ;
lin brothel_N = mkN "妓院" ; -- status=guess
lin brother_N = mkN "兄弟" | {-HSK-} mkN "舅舅" "個" ;
lin brother_N2 = L.brother_N2 ;
lin brotherly_A = mkA "兄弟" | {-HSK-} mkA "兄弟般" ;
lin brotherly_Adv = mkAdv "兄弟" | adjAdv brotherly_A ; -- derived -- derived
lin brotula_N = mkN "深海鼬鱼" ; -- open-multilingual-wordnet
lin broughton_PN = foreignPN "Broughton" ; -- comment=src=geonames status=guess
lin brouhaha_N = mkN "骚动" ;
lin brow_N = mkN "眉毛" ;
lin browbeat_V2 = mkV2 "恫吓" ;
lin brown_A = L.brown_A ;
lin brown_N = mkN "棕色" | mkN "褐色" | mkN "咖啡色" ; -- status=guess -- status=guess -- status=guess
lin brownstone_N = mkN "褐砂石房屋" ; -- open-multilingual-wordnet
lin browse_V = mkV "浏览" ;
lin broxburn_PN = foreignPN "Broxburn" ; -- comment=src=geonames status=guess
lin bruce_PN = foreignPN "Bruce" ; -- comment=src=geonames status=guess
lin bruges_PN = foreignPN "Bruges" ; -- comment=src=geonames status=guess
lin bruin_N = mkN "熊" ; -- open-multilingual-wordnet
lin bruise_N = mkN "挫伤" ;
lin bruise_V = mkV "擦伤" ;
lin brunch_N = mkN "早午餐" ;
lin brunei_PN = mkPN "文莱" ;
lin brunetteFem_N = variants {} ; ---- sense to be split
lin brunetteMasc_N = variants {} ; ---- sense to be split
lin brunswick_PN = foreignPN "Brunswick" ; -- comment=src=geonames status=guess
lin brunt_N = mkN "首当其冲" ;
lin brush_N = mkN "刷子" "把" ;
lin brush_V = mkV "刷" ;
lin brush_V2 = mkV2 "刷" ;
lin brusque_A = mkA "唐突" | mkA "粗暴" | mkA "無禮" | mkA "无礼" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin brussels_PN = mkPN "布鲁塞尔" ;
lin brut_A = mkA "极干" ; -- open-multilingual-wordnet
lin brutal_A = mkA "残忍" ;
lin brutality_N = mkN "暴行" ;
lin brutish_A = mkA "粗野" ;
lin bryan_PN = mkPN "布賴恩" ; -- comment=src=geonames status=guess
lin bryophytic_A = mkA "苔藓植物" | mkA "苔藓植物门" ; -- open-multilingual-wordnet
lin bryozoan_N = mkN "苔藓虫" | mkN "苔藓虫门动物" ; -- open-multilingual-wordnet
lin bst_PN = foreignPN "BST" ; -- comment=src=eng status=guess
lin bt_PN = foreignPN "BT" ; -- comment=src=eng status=guess
lin bubaline_A = mkA "非洲羚羊属" ; -- open-multilingual-wordnet
lin bubble_N = mkN "泡沫" ;
lin bubble_V = mkV "嗝" | mkV "嗳气" | mkV "打嗝" | mkV "饱嗝" ; -- open-multilingual-wordnet
lin bubbly_A = mkA "兴高采烈" | mkA "欢腾" | mkA "热情奔放" | mkA "生气勃勃" | mkA "生龙活虎" ; -- open-multilingual-wordnet
lin bubbly_N = mkN "气泡" "个" ;
lin bubonic_A = mkA "横痃" | mkA "淋巴腺肿" | mkA "腹股沟淋巴结炎性" | mkA "腹股沟淋巴结炎" | mkA "腹股沟腺炎" ; -- open-multilingual-wordnet
lin bucarest_PN = foreignPN "Bucarest" ; -- comment=src=eng status=guess
lin buccaneer_N = mkN "海盗" ;
lin buck_N = mkN "雄鹿" ;
lin buck_V = mkV "降压" ;
lin buck_V2 = mkV2 "违逆" ;
lin bucket_N = mkN "桶" ;
lin buckhaven_PN = foreignPN "Buckhaven" ; -- comment=src=geonames status=guess
lin buckie_PN = foreignPN "Buckie" ; -- comment=src=geonames status=guess
lin buckingham_PN = foreignPN "Buckingham" ; -- comment=src=geonames status=guess
lin buckinghamshire_PN = foreignPN "Buckinghamshire" ; -- comment=src=eng status=guess
lin buckle_N = mkN "皮带扣" ;
lin buckle_V = mkV "皮带扣" ;
lin buckle_V2 = mkV2 "扣住" ;
lin buckle_down_V = mkV "拼命工作" | mkV "认真工作" ; -- open-multilingual-wordnet
lin buckley_PN = foreignPN "Buckley" ; -- comment=src=geonames status=guess
lin buckram_N = mkN "硬布" | mkN "硬粗布" | mkN "硬麻布" ; -- open-multilingual-wordnet
lin bucksburn_PN = foreignPN "Bucksburn" ; -- comment=src=eng status=guess
lin buckshot_N = mkN "大号铅弹" ;
lin buckskin_N = mkN "黄灰色的马" ; -- open-multilingual-wordnet
lin buckwheat_N = mkN "蕎麥" | mkN "荞麦" ; -- status=guess -- status=guess -- status=guess
lin bucolic_A = mkA "牧人" | mkA "牧羊人" ; -- open-multilingual-wordnet
lin bud_N = mkN "花蕾" ;
lin bud_V = mkV "芽" ;
lin budapest_PN = mkPN "布达佩斯" ; -- comment=src=geonames status=guess
lin buddhistFem_N = variants {} ; ---- sense to be split
lin buddhistMasc_N = variants {} ; ---- sense to be split
lin budding_N = mkN "芽接" | mkN "芽植" | mkN "芽生" ; -- open-multilingual-wordnet
lin buddy_N = mkN "伙伴" ;
lin budge_V = mkV "微微移动" ;
lin budget_N = mkN "预算" ;
lin budget_V = mkV "预算" ;
lin budget_V2 = mkV2 "列入预算" ;
lin budgetary_A = mkA "预算" ;
lin buenos_aires_PN = foreignPN "Buenos aires" ; -- comment=src=eng status=guess
lin buff_A = mkA "暗黄色" | mkA "浅黄色" | mkA "淡黄色" ; -- open-multilingual-wordnet
lin buff_N = mkN "浅黄色" ;
lin buff_V2 = mkV2 "缓冲" ;
lin buffalo_N = mkN "野牛" ; -- status=guess
lin buffalo_PN = mkPN ("水牛" | "水牛城") ; -- comment=src=geonames status=guess
lin buffer_N = mkN "缓冲区" ;
lin buffer_V2 = mkV2 "缓冲" ;
lin buffet_N = mkN "自助餐" ;
lin buffet_V2 = mkV2 "打击" ;
lin buffoon_N = mkN "小丑" ; -- status=guess
lin bug_N = mkN "错误" ;
lin bug_V2 = mkV2 (mkV "煩擾") | mkV2 (mkV "烦扰") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin bug_out_V = mkV "凸出" | mkV "突出" ; -- open-multilingual-wordnet
lin bugaboo_N = mkN "妖怪" ;
lin buggy_A = mkA "多虫" | mkA "臭虫成灾" ; -- open-multilingual-wordnet
lin bugle_N = mkN "軍號" | mkN "军号" | mkN "號角" | mkN "号角" | {-mwn-} mkN "喇叭" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bugler_N = mkN "司號員" | mkN "司号员" ; -- status=guess -- status=guess
lin bugleweed_N = mkN "丝线吊铜钟" | mkN "乃东" | mkN "六月干" | mkN "古牛草" | mkN "夏枯头" | mkN "夏枯草" | mkN "夕句" | mkN "大头花" | mkN "广谷草" | mkN "棒头柱" | mkN "棒柱头花" | mkN "棒槌草" | mkN "灯笼头" | mkN "灯笼草" | mkN "燕面" | mkN "牛佤头" | mkN "牛牯草" | mkN "铁色草" | mkN "锣锤草" | mkN "麦夏枯" ; -- open-multilingual-wordnet
lin build_N = mkN "个子" | {-HSK-} mkN "构造""" ;
lin build_V = mkV "修" | mkV "建立" | mkV "建设" | mkV "盖" ;
lin build_V2 = mkV2 "修" | mkV2 "建立" | mkV2 "建设" | mkV2 "盖" | {-HSK-} mkV2 "建造" ;
lin build_up_V2 = prepV2 OP_build_V OP_up_Prep ; -- guess-p-verb
lin builder_N = mkN "建设者" ;
lin building_N = mkN "建筑" | {-HSK-} mkN "建筑" "個" ;
lin build_up_N = mkN "增强" ;
lin built_in_A = mkA "建造" ;
lin bulb_N = mkN "粉笔" ;
lin bulbaceous_A = mkA "球根" ; -- open-multilingual-wordnet
lin bulbar_A = mkA "延髓" ; -- open-multilingual-wordnet
lin bulbed_A = mkA "有球根" | mkA "球状物" ; -- open-multilingual-wordnet
lin bulbil_N = mkN "小球茎" | mkN "球芽" | mkN "鳞芽" ; -- open-multilingual-wordnet
lin bulblike_A = mkA "球根状" | mkA "鳞茎状" ; -- open-multilingual-wordnet
lin bulgaria_PN = mkPN "保加利亚" ;
lin bulgarianFem_N = variants {} ; ---- sense to be split
lin bulgarianMasc_N = mkN "保加利亚人" ;
lin bulgarian_A = mkA "保加利亚" ;
lin bulge_V = mkV "膨胀凸出" ;
lin bulge_V2 = mkV2 (mkV "凸出") | mkV2 (mkV "突出") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin bulimarexia_N = mkN "饮食失常" ; -- open-multilingual-wordnet
lin bulimia_N = mkN "暴食症" | mkN "暴食症" ; -- status=guess -- status=guess
lin bulimic_A = mkA "善饥" | mkA "食欲过盛" ; -- open-multilingual-wordnet
lin bulk_N = mkN "体积" | {-HSK-} mkN "体积" "個" ;
lin bulkhead_N = mkN "隔板" ;
lin bulkington_PN = foreignPN "Bulkington" ; -- comment=src=geonames status=guess
lin bulky_A = mkA "庞大" ;
lin bull_N = mkN "公牛" "只" ;
lin bull_neck_N = mkN "公牛" "头" ;
lin bulla_N = mkN "印玺" ; -- open-multilingual-wordnet
lin bulldog_N = mkN "牛頭犬" | mkN "牛头犬" ; -- status=guess -- status=guess
lin bulldoze_V2 = mkV2 "强迫" ;
lin bulldozer_N = mkN "欺凌者" ;
lin bullet_N = mkN "子弹" ;
lin bulletin_N = mkN "公告" ;
lin bulletproof_A = mkA "防彈" | mkA "防弹" ; -- status=guess -- status=guess
lin bullfight_N = mkN "斗牛" ; -- open-multilingual-wordnet
lin bullfighter_N = mkN "斗牛" ;
lin bullfighting_N = mkN "公牛戰鬥" | mkN "公牛战斗" | mkN "鬥牛" | mkN "斗牛" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bullfrog_N = mkN "牛蛙" | mkN "美國牛蛙" | mkN "美国牛蛙" ; -- status=guess -- status=guess -- status=guess
lin bullhead_N = mkN "大头鱼" | mkN "杜父鱼" | mkN "美洲鲇鱼" ; -- open-multilingual-wordnet
lin bull_headed_A = mkA "冥顽不灵" | mkA "顽固" ; -- open-multilingual-wordnet
lin bullhorn_N = mkN "手提式扩音器" | mkN "扩音器" ; -- open-multilingual-wordnet
lin bullion_N = mkN "金银" "块" ;
lin bullnecked_A = mkA "粗颈" ; -- open-multilingual-wordnet
lin bullnose_N = mkN "外圆角" ; -- open-multilingual-wordnet
lin bullocky_A = mkA "小公牛似" ; -- open-multilingual-wordnet
lin bullpen_N = mkN "临时拘留所" ; -- open-multilingual-wordnet
lin bullring_N = mkN "斗牛场" ; -- open-multilingual-wordnet
lin bullshit_N = mkN "廢話" | mkN "废话" | mkN "狗屁" | mkN "放屁" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bull_terrier_N = mkN "叭喇狗" | mkN "布尔得利亚" ; -- open-multilingual-wordnet
lin bully_N = mkN "欺凌弱小者" ;
lin bully_V = mkV "欺負" | mkV "欺负" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin bully_V2 = mkV2 "欺负" ;
lin bullying_N = mkN "欺負" | mkN "欺负" | mkN "恃強欺弱" | mkN "恃强欺弱" | mkN "恃強凌弱" | mkN "恃强凌弱" | mkN "欺凌" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin bulwark_N = mkN "堡垒" ;
lin bum_A = mkA "劣等" | mkA "廉价" ; -- open-multilingual-wordnet
lin bum_N = mkN "流浪汉" "个" ;
lin bum_V = mkV "免费得到" | mkV "揩油" | mkV "敲竹杠" | mkV "讨" ; -- open-multilingual-wordnet
lin bumblebee_N = mkN "大黃蜂" | mkN "大黄蜂" | mkN "熊蜂" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bumboat_N = mkN "小販船" | mkN "小贩船" | mkN "販船" | mkN "贩船" | {-mwn-} mkN "小卖艇" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bump_Adv = mkAdv "突然" ;
lin bump_N = mkN "撞击" ;
lin bump_V = mkV "碰撞" ;
lin bump_V2 = mkV2 "撞" ;
lin bump_into_V2 = mkV2 "撞" | mkV2 "碰见" ;
lin bumper_N = mkN "保险杠" ;
lin bumpy_A = mkA "颠簸" ;
lin bun_N = mkN "小圓麵包" | mkN "小圆面包" | mkN "饅頭" | mkN "馒头" | mkN "饃" | mkN "馍" | mkN "包子" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin buna_N = mkN "丁钠橡胶" | mkN "布纳橡胶" ; -- open-multilingual-wordnet
lin bunch_N = mkN "束" [] ;
lin bunch_V = mkV "聚拢" ;
lin bunch_V2 = mkV2 "使+扎成捆" ;
lin bundle_N = mkN "包" "個" | mkN "包裹" "個" | {-HSK-} mkN "束" | {-HSK-} mkN "包袱" ;
lin bundle_V2 = mkV2 "捆" ;
lin bung_N = mkN "木塞" | mkN "气孔塞" ; -- open-multilingual-wordnet
lin bungaloid_A = mkA "平房式" ; -- open-multilingual-wordnet
lin bungee_N = mkN "蹦極" | mkN "蹦极" | {-mwn-} mkN "蹦极绳索" | mkN "蹦级绳" | mkN "高空弹跳绳" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin bungle_V = mkV "搞砸" ;
lin bungler_N = mkN "糊塗蟲" | mkN "糊涂虫" | mkN "笨手笨腳" | mkN "笨手笨脚" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin bunion_N = mkN "拇囊炎" | mkN "雞眼" | mkN "鸡眼" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin bunk_N = mkN "雙層床" | mkN "双层床" ; -- status=guess -- status=guess
lin bunk_off_V = mkV "旷工" | mkV "逃学" ; -- open-multilingual-wordnet
lin bunker_N = mkN "掩體" | mkN "掩体" | mkN "地堡" ; -- status=guess -- status=guess -- status=guess
lin bunny_N = mkN "兔子" ;
lin bunsen_N = mkN "本生灯" ; -- open-multilingual-wordnet
lin buntal_N = mkN "金丝草" ; -- open-multilingual-wordnet
lin buoy_N = mkN "浮標" | mkN "浮标" ; -- status=guess -- status=guess
lin buoy_V = mkV "支撑" ;
lin buoy_V2 = mkV2 "浮标" ;
lin buoyancy_N = mkN "浮力" ;
lin buoyant_A = mkA "轻快" ;
lin burble_VS = mkVS "窃笑" ;
lin burden_N = mkN "负荷" ;
lin burden_V2 = mkV2 "负担" ;
lin burdensome_A = mkA "累赘" ;
lin burdock_N = mkN "牛蒡" ; -- status=guess
lin bureau_N = mkN "局" ;
lin bureaucracy_N = mkN "官僚" ;
lin bureaucrat_N = mkN "官撩" ;
lin bureaucratic_A = mkA "官僚" ;
lin burette_N = mkN "滴定管" "根" ;
lin burg_N = mkN "镇" ;
lin burgeon_V = mkV "发芽" ;
lin burgess_PN = foreignPN "Burgess" ; -- comment=src=eng status=guess
lin burgher_N = mkN "市民" ;
lin burglar_N = mkN "竊盜" | mkN "窃盗" | mkN "竊賊" | mkN "窃贼" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin burglarious_A = mkA "窃盗" ; -- open-multilingual-wordnet
lin burglary_N = mkN "盗窃" "次" ;
lin burgle_V = mkV "偷窃" | mkV "抢劫" ; -- open-multilingual-wordnet
lin burgos_PN = mkPN "布尔戈斯" ; -- comment=src=geonames status=guess
lin burial_N = mkN "埋葬" ;
lin burin_N = mkN "石刻刀" | mkN "雕刻刀" ; -- open-multilingual-wordnet
lin burlap_N = mkN "粗麻布" ;
lin burlesque_A = mkA "可笑" | mkA "滑稽" | mkA "逗人笑" ; -- open-multilingual-wordnet
lin burley_PN = foreignPN "Burley" ; -- comment=src=geonames status=guess
lin burly_A = mkA "结实" ;
lin burma_PN = foreignPN "Burma" ; -- comment=src=eng status=guess
lin burn_N = mkN "烧伤" ;
lin burn_V = L.burn_V | {-HSK-} mkV "烫" ;
lin burn_V2 = mkV2 "灼烧" | {-HSK-} mkV2 "烫" ;
lin burn_down_V = advV OP_burn_V OP_down_Adv ; -- guess-p-verb
lin burn_down_V2 = prepV2 OP_burn_V OP_down_Prep ; -- guess-p-verb
lin burn_off_V2 = prepV2 OP_burn_V OP_off_Prep ; -- guess-p-verb
lin burn_out_V = advV OP_burn_V OP_out_Adv ; -- guess-p-verb
lin burn_up_V = advV OP_burn_V OP_up_Adv ; -- guess-p-verb
lin burn_up_V2 = prepV2 OP_burn_V OP_up_Prep ; -- guess-p-verb
lin burner_N = mkN "燃烧器" ;
lin burnham_on_sea_PN = foreignPN "Burnham-on-sea" ; -- comment=src=eng status=guess
lin burning_A = variants {} ;
lin burnish_V2 = mkV2 "擦亮" ;
lin burnley_PN = mkPN "伯恩利" ; -- comment=src=geonames status=guess
lin burntisland_PN = foreignPN "Burntisland" ; -- comment=src=geonames status=guess
lin burntwood_PN = foreignPN "Burntwood" ; -- comment=src=geonames status=guess
lin burn_up_N = mkN "燃料消耗" | mkN "燃耗" ; -- open-multilingual-wordnet
lin burp_N = mkN "飽嗝" | mkN "饱嗝" ; -- status=guess -- status=guess
lin burp_V = mkV "打嗝" | mkV "噯氣" | mkV "嗳气" | mkV "飽嗝" | mkV "饱嗝" | mkV "嗝" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- open-multilingual-wordnet
lin burp_V2 = mkV2 (mkV "打嗝") | mkV2 (mkV "噯氣") | mkV2 (mkV "嗳气") | mkV2 (mkV "飽嗝") | mkV2 (mkV "饱嗝") | mkV2 (mkV "嗝") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin burqa_N = mkN "布嘎" | mkN "布尔卡" | mkN "波卡" | mkN "罩袍" ; -- open-multilingual-wordnet
lin burrfish_N = mkN "刺鲀" ; -- open-multilingual-wordnet
lin burrlike_A = mkA "像刺" ; -- open-multilingual-wordnet
lin burro_N = mkN "驴子" ; -- open-multilingual-wordnet
lin burrow_N = mkN "地洞" ; -- status=guess
lin burrow_V = mkV "穿过" ; -- open-multilingual-wordnet
lin burry_port_PN = foreignPN "Burry port" ; -- comment=src=eng status=guess
lin bursal_A = mkA "囊" ; -- open-multilingual-wordnet
lin burscough_PN = foreignPN "Burscough" ; -- comment=src=eng status=guess
lin bursitis_N = mkN "滑囊炎" | mkN "粘液囊炎" ; -- open-multilingual-wordnet
lin burst_N = mkN "爆裂" | {-HSK-} mkN "阵" ;
lin burst_V = mkV "爆裂" ;
lin burst_V2 = mkV2 "爆发" ;
lin burst_into_V2 = prepV2 OP_burst_V OP_into_Prep ; -- guess-p-verb
lin burthen_N = mkN "负担" ; -- open-multilingual-wordnet
lin burton_upon_trent_PN = foreignPN "Burton-upon-trent" ; -- comment=src=eng status=guess
lin burundi_PN = mkPN "蒲隆地" ; -- comment=src=geonames status=guess
lin bury_PN = foreignPN "Bury" ; -- comment=src=geonames status=guess
lin bury_V = mkV "埋葬" ;
lin bury_V2 = mkV2 "埋葬" ;
lin bury_st__edmunds_PN = foreignPN "Bury st. edmunds" ; -- comment=src=eng status=guess
lin bus_N = mkN "公共汽车" | {-HSK-} mkN "公共汽车" "輛" ;
lin busbar_N = mkN "总线" | mkN "母线" | mkN "汇流排" | mkN "汇流条" ; -- open-multilingual-wordnet
lin busby_N = mkN "大礼帽" | mkN "高帽" | mkN "高帽子" ; -- open-multilingual-wordnet
lin bush_N = mkN "灌木丛" ;
lin bushel_N = mkN "蒲式耳" ;
lin bushing_N = mkN "套管" ; -- open-multilingual-wordnet
lin bushwhacking_A = mkA "埋伏着" ; -- open-multilingual-wordnet
lin bushy_A = mkA "浓密" ;
lin business_N = mkN "业务" "個" | mkN "事情" "件" | mkN "商业" | mkN "行业" ;
lin businesslike_A = mkA "公事公办" ;
lin businessman_N = mkN "商人" ;
lin businessperson_N = mkN "商人" ; -- status=guess
lin businesswoman_N = mkN "女商人" ; -- status=guess
lin busload_N = mkN "公共汽车运载量" ;
lin bust_N = mkN "半身像" ;
lin bust_V = mkV "逮捕" | mkV "破产" ;
lin bust_V2 = mkV2 "破产" ;
lin bustard_N = mkN "鸨鸟" "只" ;
lin buster_N = mkN "克星" ;
lin bustle_N = mkN "喧闹" ;
lin busy_A = mkA "占线" | mkA "忙" | {-HSK-} mkA "忙碌" ;
lin busy_V2 = mkV2 "使+忙于" ;
lin busybody_N = mkN "愛管閒事的人" | mkN "爱管闲事的人" ; -- status=guess -- status=guess
lin but_Adv = mkAdv "不要紧" | mkAdv "不过" | mkAdv "但是" | mkAdv "却" | mkAdv "只" | mkAdv "可是" | mkAdv "然而" | mkAdv "而" | {-HSK-} mkAdv "但" ;
lin but_Conj = mkConj "但是" ;
lin but_N = mkN "不要紧" | mkN "不过" | mkN "但是" | mkN "却" | mkN "只" | mkN "可是" | mkN "然而" | mkN "而" ;
lin but_PConj = S.but_PConj ;
lin but_Prep = mkPrep "但是" ;
lin but_Subj = mkSubj "但" ;
lin butacaine_N = mkN "布大卡因" ; -- open-multilingual-wordnet
lin butane_N = mkN "丁烷" ;
lin butanone_N = mkN "丁酮" ; -- open-multilingual-wordnet
lin butcher_N = mkN "屠夫" "位" ;
lin buteonine_A = mkA "异可利定" ; -- open-multilingual-wordnet
lin butler_N = mkN "巴特勒" "" ;
lin butt_N = mkN "对接" ;
lin butt_V = mkV "屁股" ;
lin butt_V2 = mkV2 (mkV "頂") | mkV2 (mkV "顶") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin butt_in_V = mkV "插嘴" | mkV "插话" ; -- open-multilingual-wordnet
lin butter_N = L.butter_N ;
lin butter_V2 = mkV2 (mkV "討好") | mkV2 (mkV "讨好") | mkV2 (mkV "奉承") | mkV2 (mkV "拍馬屁") | mkV2 (mkV "拍马屁") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin buttercup_N = mkN "毛茛" | mkN "金鳳花" | mkN "金凤花" ; -- status=guess -- status=guess -- status=guess
lin butterfat_N = mkN "乳脂" | mkN "牛奶中的脂肪" ; -- open-multilingual-wordnet
lin butterfly_N = mkN "蝴蝶" | {-HSK-} mkN "蝴蝶" "隻" ;
lin butterwort_N = mkN "捕虫堇" | mkN "捕虫堇属植物" ; -- open-multilingual-wordnet
lin button_N = mkN "按钮" ;
lin buttoned_up_A = mkA "守口如瓶" ;
lin buttonhole_N = mkN "紐孔" | mkN "纽孔" | {-mwn-} mkN "扣眼" | mkN "钮扣眼" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin buttonhook_N = mkN "绊钩" | mkN "钮扣钩" ; -- open-multilingual-wordnet
lin buttress_N = mkN "以扶壁支撑" | mkN "扶壁" | mkN "拱壁" | mkN "撑墙" | mkN "支持" | mkN "支持物" ; -- open-multilingual-wordnet
lin buttress_V2 = mkV2 "扶壁" ;
lin butylene_N = mkN "丁烯" ; -- open-multilingual-wordnet
lin butyraceous_A = mkA "似乳油" | mkA "含奶油" | mkA "含油" | mkA "奶油状" ; -- open-multilingual-wordnet
lin butyric_A = mkA "丁酸" | mkA "产生丁酸" | mkA "得自丁酸" | mkA "有关丁酸" | mkA "酪酸" ; -- open-multilingual-wordnet
lin butyrin_N = mkN "酪脂" ; -- open-multilingual-wordnet
lin buxton_PN = mkPN "巴克斯頓" ; -- comment=src=geonames status=guess
lin buy_N = mkN "购买" ;
lin buy_V = mkV "买" ;
lin buy_V2 = L.buy_V2 ;
lin buy_back_V2 = mkV2 (advV OP_buy_V OP_back_Adv ) ; -- guess-p-verb
lin buy_in_V2 = prepV2 OP_buy_V OP_in_Prep ; -- guess-p-verb
lin buy_into_V2 = prepV2 OP_buy_V OP_into_Prep ; -- guess-p-verb
lin buy_off_V2 = prepV2 OP_buy_V OP_off_Prep ; -- guess-p-verb
lin buy_out_V2 = prepV2 OP_buy_V OP_out_Prep ; -- guess-p-verb
lin buy_up_V2 = mkV2 "全买" ;
lin buyerFem_N = mkN "买主" ;
lin buyerMasc_N = mkN "买主" ;
lin buyout_N = mkN "买断" | mkN "全部买下" | mkN "控制股权收购" ; -- open-multilingual-wordnet
lin buzz_N = mkN "嗡嗡声" ;
lin buzz_V = mkV "嗡嗡叫" ;
lin buzz_V2 = mkV2 "嗡嗡叫" ;
lin buzzer_N = mkN "蜂鸣器" ;
lin buzzword_N = mkN "流行语" ;
lin by8agent_Prep = S.by8agent_Prep ;
lin by8means_Prep = S.by8means_Prep ;
lin by_Adv = mkAdv "以" | {-HSK-} mkAdv "经过" ;
lin by_Prep = mkPrep "由" ;
lin by_means_of_Prep = mkPrep "通过" ;
lin by_virtue_of_Prep = mkPrep "凭借" ;
lin bye_Interj = mkInterj "再见" ;
lin bye_N = mkN "轮空" ;
lin bye_bye_Interj = mkInterj "再见" ;
lin bygone_A = mkA "过去" ;
lin bygone_N = mkN "过去的事""件" ;
lin bylaw_N = mkN "次要法规" ;
lin bypass_N = mkN "小路" ;
lin bypass_V2 = mkV2 "绕行" ;
lin bypath_N = mkN "侧道" | mkN "间道" ; -- open-multilingual-wordnet
lin byproduct_N = mkN "副產品" | mkN "副产品" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin byroad_N = mkN "侧道" | mkN "间道" ; -- open-multilingual-wordnet
lin byssus_N = mkN "足丝" ; -- open-multilingual-wordnet
lin bystander_N = mkN "旁观者" ;
lin byte_N = mkN "字節" | mkN "字节" | mkN "位元組" | mkN "位元组" | {-mwn-} mkN "二进位组" | mkN "位组" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin byway_N = mkN "侧道" | mkN "间道" ; -- open-multilingual-wordnet
lin c_in_c_PN = foreignPN "C-in-c" ; -- comment=src=eng status=guess
lin c_of_e_N = mkN "居权证" ;
lin cab_N = mkN "出租汽车" "辆" ;
lin cabal_N = mkN "阴谋" ;
lin cabana_N = mkN "简易浴室" ; -- open-multilingual-wordnet
lin cabaret_N = mkN "卡巴萊" | mkN "卡巴莱" ; -- status=guess -- status=guess
lin cabbage_N = mkN "捲心菜" | mkN "卷心菜" | mkN "高麗菜" | mkN "高丽菜" | mkN "洋白菜" | mkN "包心菜" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin caber_N = mkN "投棒" | mkN "棒" | mkN "比力棒" ; -- open-multilingual-wordnet
lin cabin_N = mkN "机舱" "间" ;
lin cabinet_N = mkN "柜子" ;
lin cabinet_maker_N = mkN "細木工" | mkN "细木工" | mkN "家具木工" | mkN "細工木匠" | mkN "细工木匠" | mkN "家具師" | mkN "家具师" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin cable_N = mkN "电缆" ;
lin caboose_N = mkN "乘务车厢" ; -- open-multilingual-wordnet
lin cacao_N = mkN "可可樹" | mkN "可可树" ; -- status=guess -- status=guess
lin cache_N = mkN "高速缓冲存储器" ;
lin cachectic_A = mkA "恶病" ; -- open-multilingual-wordnet
lin cachet_N = mkN "公章" ;
lin cachexia_N = mkN "恶疾" | mkN "恶病质" | mkN "极瘦弱" | mkN "萎靡不振" ; -- open-multilingual-wordnet
lin cacodemonic_A = mkA "恶魔" ; -- open-multilingual-wordnet
lin cacodyl_N = mkN "二甲胂" | mkN "二甲胂基" ; -- open-multilingual-wordnet
lin cacodylic_A = mkA "二甲砷基" | mkA "含卡可基" ; -- open-multilingual-wordnet
lin cacogenesis_N = mkN "不生殖" | mkN "劣生" | mkN "成长异常" ; -- open-multilingual-wordnet
lin cacophony_N = mkN "不協和音" | mkN "不协和音" | mkN "雜音" | mkN "杂音" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cactus_N = mkN "仙人掌" ; -- status=guess
lin cadastral_A = mkA "地籍" | mkA "地籍图" ; -- open-multilingual-wordnet
lin cadaver_N = mkN "屍體" | mkN "尸体" ; -- status=guess -- status=guess
lin cadaverous_A = mkA "尸体" | mkA "尸体般" ; -- open-multilingual-wordnet
lin caddisworm_N = mkN "草虫" ; -- open-multilingual-wordnet
lin caddy_N = mkN "茶叶盒" ; -- open-multilingual-wordnet
lin cadenced_A = mkA "有节奏" | mkA "有韵律" | mkA "音调整齐" ; -- open-multilingual-wordnet
lin cadet_N = mkN "见习生" "位" ;
lin cadge_V2 = mkV2 "乞讨" ;
lin cadiz_PN = mkPN "加的斯" ; -- comment=src=geonames status=guess
lin cadmium_N = mkN "镉" ;
lin cadre_N = mkN "干部""" ;
lin caducean_A = mkA "双蛇杖标志" ; -- open-multilingual-wordnet
lin caecilian_A = mkA "蚓螈" ; -- open-multilingual-wordnet
lin caen_PN = mkPN "卡昂" ; -- comment=src=geonames status=guess
lin caerleon_PN = foreignPN "Caerleon" ; -- comment=src=geonames status=guess
lin caernarfon_PN = foreignPN "Caernarfon" ; -- comment=src=geonames status=guess
lin caerphilly_PN = foreignPN "Caerphilly" ; -- comment=src=geonames status=guess
lin caespitose_A = mkA "丛生" | mkA "成簇状" | mkA "簇生" ; -- open-multilingual-wordnet
lin caesural_A = mkA "休止" ; -- open-multilingual-wordnet
lin cafe_N = variants {} ;
lin cafeteria_N = mkN "自助餐厅" ;
lin caff_N = mkN "小餐馆" ; -- open-multilingual-wordnet
lin caffeine_N = mkN "咖啡因" ; -- status=guess -- open-multilingual-wordnet
lin caffeinic_A = mkA "咖啡酸" ; -- open-multilingual-wordnet
lin caffeinism_N = mkN "咖啡中毒症" ; -- open-multilingual-wordnet
lin cage_N = mkN "笼" "个" ; -- comment="兽笼" ;
lin cagey_A = mkA "有戒心" ; -- status=guess
lin cagliari_PN = mkPN "卡利亚里" ; -- comment=src=geonames status=guess
lin cagoule_N = mkN "有帽薄防风衣" ; -- open-multilingual-wordnet
lin caiman_N = mkN "凱門鱷" | mkN "凯门鳄" ; -- status=guess -- status=guess
lin cairn_N = mkN "凯恩㹴狗" ; -- open-multilingual-wordnet
lin cairned_A = mkA "石堆纪念碑" ; -- open-multilingual-wordnet
lin cairngorm_N = mkN "烟水晶" ; -- open-multilingual-wordnet
lin cairo_PN = foreignPN "Cairo" ; -- comment=src=geonames status=guess
lin caisson_N = mkN "潜箱" ; -- open-multilingual-wordnet
lin cake_N = mkN "蛋糕" | {-HSK-} mkN "蛋糕" "塊" ;
lin cake_V = mkV "结块" ;
lin calabash_N = mkN "葫蘆" | mkN "葫芦" | {-mwn-} mkN "葫芦烟斗" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin calamint_N = mkN "土霍香" | mkN "大叶薄荷" | mkN "排香草" ; -- open-multilingual-wordnet
lin calamitous_A = mkA "灾难性" ;
lin calamity_N = mkN "灾难" ;
lin calamus_N = mkN "翎管" ; -- open-multilingual-wordnet
lin calando_A = mkA "渐柔和并渐慢" ; -- open-multilingual-wordnet
lin calcaneal_A = mkA "脚跟" | mkA "跟骨" ; -- open-multilingual-wordnet
lin calcareous_A = mkA "石灰质" | mkA "碳酸钙" | mkA "钙质" ; -- open-multilingual-wordnet
lin calced_A = mkA "穿鞋" ; -- open-multilingual-wordnet
lin calceolaria_N = mkN "蒲包花" ; -- open-multilingual-wordnet
lin calceolate_A = mkA "拖鞋状" ; -- open-multilingual-wordnet
lin calcic_A = mkA "含钙" | mkA "石灰" | mkA "钙质" ; -- open-multilingual-wordnet
lin calciferous_A = mkA "含方解石" | mkA "含碳酸钙" ; -- open-multilingual-wordnet
lin calcific_A = mkA "钙化" ; -- open-multilingual-wordnet
lin calcimine_N = mkN "刷墙水粉" | mkN "可赛银粉" ; -- open-multilingual-wordnet
lin calcine_V = mkV "锻烧" ; -- open-multilingual-wordnet
lin calcitic_A = mkA "方解石" ; -- open-multilingual-wordnet
lin calcium_N = mkN "钙" ;
lin calculate_V = mkV "打算" | mkV "算" | mkV "计算" ;
lin calculate_V2 = mkV2 "打算" | mkV2 "算" | mkV2 "计算" ;
lin calculate_VS = mkVS "打算" | {-HSK-} mkVS "算" | mkVS "计算" ;
lin calculation_N = mkN "打算" "個" | {-HSK-} mkN "计算" ;
lin calculator_N = mkN "计算器" "台" ;
lin calculous_A = mkA "结石" ; -- open-multilingual-wordnet
lin calculus_N = mkN "牙石" ; -- status=guess
lin calcutta_PN = foreignPN "Calcutta" ; -- comment=src=geonames status=guess
lin caldicot_PN = foreignPN "Caldicot" ; -- comment=src=geonames status=guess
lin calendar_N = mkN "日历" | {-HSK-} mkN "日历" "張" ;
lin calender_N = mkN "砑光机" ; -- open-multilingual-wordnet
lin calendric_A = mkA "历法" | mkA "按日历" | mkA "日历" ; -- open-multilingual-wordnet
lin calf_N = mkN "小牛" | mkN "腓肠" ;
lin cali_PN = mkPN "卡利" ; -- comment=src=geonames status=guess
lin calibrate_V2 = mkV2 "校准" ;
lin calibration_N = mkN "校準" | mkN "校准" | mkN "校正" ; -- status=guess -- status=guess -- status=guess
lin calibre_N = mkN "直径" ; -- status=guess
lin caliche_N = mkN "生硝" | mkN "硝酸钠" ; -- open-multilingual-wordnet
lin calico_A = mkA "印花棉布" ; -- open-multilingual-wordnet
lin calico_N = mkN "印花布" ; -- open-multilingual-wordnet
lin california_PN = mkPN "加州" ;
lin californian_N = mkN "加利福尼亚人" ;
lin californium_N = mkN "鉲" ; -- status=guess
lin caliper_N = mkN "弯脚器" | mkN "测径器" | mkN "测径规" ; -- open-multilingual-wordnet
lin caliph_N = mkN "哈里發" | mkN "哈里发" ; -- status=guess -- status=guess
lin calisthenic_A = mkA "健身操" | mkA "柔软体操" ; -- open-multilingual-wordnet
lin calk_N = mkN "马蹄铁刺" ; -- open-multilingual-wordnet
lin call_N = mkN "呼叫" | {-HSK-} mkN "喊" ;
lin call_V = mkV "叫" | mkV "称呼" | {-HSK-} mkV "呼叫" ;
lin call_V2 = mkV2 "叫" | {-HSK-} mkV2 "称呼" ;
lin call_VS = mkVS "呼叫" ;
lin call_after_V2 = prepV2 OP_call_V OP_after_Prep ; -- guess-p-verb
lin call_around_V = advV OP_call_V OP_around_Adv ; -- guess-p-verb
lin call_back_V2 = mkV2 (advV OP_call_V OP_back_Adv ) ; -- guess-p-verb
lin call_for_V2V = variants {} ; -- guess-p-verb
lin call_forth_V2 = mkV2 (advV OP_call_V OP_forth_Adv ) ; -- guess-p-verb
lin call_in_V = mkV "打入电话" | mkV "电话告知" ; -- open-multilingual-wordnet
lin call_in_V2 = prepV2 OP_call_V OP_in_Prep ; -- guess-p-verb
lin call_off_V2 = prepV2 OP_call_V OP_off_Prep ; -- guess-p-verb
lin call_on_V = mkV "看" | mkV "访问" | {-mwn-} mkV "依赖" | mkV "求助于" | mkV "求教于" ; -- open-multilingual-wordnet
lin call_on_V2 = mkV2 "看" | mkV2 "访问" ;
lin call_out_V2 = prepV2 OP_call_V OP_out_Prep ; -- guess-p-verb
lin call_over_V = advV OP_call_V OP_over_Adv ; -- guess-p-verb
lin call_round_V = advV OP_call_V OP_round_Adv ; -- guess-p-verb
lin call_up_V2 = prepV2 OP_call_V OP_up_Prep ; -- guess-p-verb
lin callable_A = mkA "可调用" ;
lin caller_N = mkN "呼叫者" ;
lin calligrapher_N = mkN "書法家" | mkN "书法家" | mkN "書家" | mkN "书家" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin calligraphic_A = mkA "书写" | mkA "书法" | mkA "书法艺术" | mkA "善写" ; -- open-multilingual-wordnet
lin calligraphy_N = mkN "書法" | mkN "书法" | mkN "書道" | mkN "书道" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin calling_N = mkN "调用""次" ;
lin callipygian_A = mkA "臀部好看" | mkA "臀部线条优美" | mkA "臀部线条匀称" ; -- open-multilingual-wordnet
lin callous_A = mkA "無情" | mkA "无情" | mkA "鐵石心腸" | mkA "铁石心肠" | {-HSK-} mkA "狠心" | {-mwn-} mkA "冷酷" | mkA "无同情心" | mkA "无情" | mkA "硬心肠" | mkA "脸皮厚" | mkA "铁石心肠" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin calloused_A = mkA "硬结" | mkA "起老茧" ; -- open-multilingual-wordnet
lin callow_A = mkA "没经年" ; -- status=guess
lin callowness_N = mkN "幼稚" ; -- open-multilingual-wordnet
lin callus_N = mkN "胼胝" | mkN "老繭" | mkN "老茧" | mkN "繭子" | mkN "茧子" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin calm_A = mkA "冷静" | {-HSK-} mkA "安静" | mkA "平" ;
lin calm_N = mkN "冷静" | mkN "安静" | mkN "平" | {-HSK-} mkN "和平" ;
lin calm_V = mkV "冷静" ;
lin calm_V2 = mkV2 "冷静" ;
lin calmness_N = mkN "冷静" ; -- comment="镇静" ;
lin calne_PN = mkPN "卡恩" ; -- comment=src=geonames status=guess
lin calor_PN = foreignPN "Calor" ; -- comment=src=eng status=guess
lin caloric_A = mkA "卡" | mkA "卡路里" | mkA "热量" ; -- open-multilingual-wordnet
lin calorie_N = mkN "卡路里" ;
lin calorimeter_N = mkN "熱量計" | mkN "热量计" | mkN "量熱計" | mkN "量热计" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin calorimetric_A = mkA "测热" ; -- open-multilingual-wordnet
lin calosoma_N = mkN "广宥肯䖬" | mkN "胫步甲虫" | mkN "臭广宥步䖬" ; -- open-multilingual-wordnet
lin calpac_N = mkN "黑毡帽" ; -- open-multilingual-wordnet
lin calque_N = mkN "借譯" | mkN "借译" ; -- status=guess -- status=guess
lin caltrop_N = mkN "蒺藜" ; -- status=guess
lin calumet_N = mkN "长烟管" ; -- open-multilingual-wordnet
lin calumniate_V2 = mkV2 (mkV "诽谤") | mkV2 (mkV "誹謗") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin calverton_PN = foreignPN "Calverton" ; -- comment=src=geonames status=guess
lin calving_N = mkN "生小牛崽" ; -- open-multilingual-wordnet
lin calyceal_A = mkA "似花萼" | mkA "杯状" | mkA "花萼" ; -- open-multilingual-wordnet
lin calycular_A = mkA "副萼" | mkA "副萼性" | mkA "有杯状窝" | mkA "杯状构造" ; -- open-multilingual-wordnet
lin calyculate_A = mkA "有副萼" ; -- open-multilingual-wordnet
lin calyculus_N = mkN "杯状器官" ; -- open-multilingual-wordnet
lin calyptrate_A = mkA "帽状体" ; -- open-multilingual-wordnet
lin cam_N = mkN "凸轮" ; -- open-multilingual-wordnet
lin camail_N = mkN "护面具" | mkN "盔甲披肩" ; -- open-multilingual-wordnet
lin camaraderie_N = mkN "情谊" ;
lin camas_N = mkN "卡马夏属植物" ; -- open-multilingual-wordnet
lin cambial_A = mkA "形成层" ; -- open-multilingual-wordnet
lin cambodia_PN = mkPN "柬埔寨" ;
lin cambodian_A = mkA "柬埔寨" ;
lin cambourne_PN = foreignPN "Cambourne" ; -- comment=src=eng status=guess
lin cambric_N = mkN "细纺" | mkN "细薄布" | mkN "细麻布" ; -- open-multilingual-wordnet
lin cambridge_PN = mkPN ("剑桥" | "劍橋") ; -- comment=src=geonames status=guess
lin cambridgeshire_PN = foreignPN "Cambridgeshire" ; -- comment=src=eng status=guess
lin cambuslang_PN = foreignPN "Cambuslang" ; -- comment=src=eng status=guess
lin camcorder_N = mkN "攝像機" | mkN "摄像机" | {-mwn-} mkN "摄像放像机" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin camden_PN = mkPN ("卡姆登" | "肯頓") ; -- comment=src=geonames status=guess
lin camel_N = mkN "駱駝" | mkN "骆驼" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin camellia_N = mkN "茶花" | {-mwn-} mkN "山椿" | mkN "山茶" | mkN "晚山茶" | mkN "曼佗罗树" | mkN "洋茶" | mkN "耐冬" | mkN "薮春" ; -- status=guess -- open-multilingual-wordnet
lin camembert_N = mkN "金銀畢" | mkN "金银毕" | mkN "卡門培爾" | mkN "卡门培尔" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cameo_N = mkN "浮雕" ;
lin camera_N = L.camera_N | {-HSK-} mkN "照相机" "個" ;
lin cameraman_N = mkN "攝影者" | mkN "摄影者" | mkN "攝影師" | mkN "摄影师" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cameroon_PN = mkPN "喀麦隆" ; -- comment=src=geonames status=guess
lin camise_N = mkN "妇女宽衬衣" ; -- open-multilingual-wordnet
lin camisole_N = mkN "一种短便服" | mkN "女背心" ; -- open-multilingual-wordnet
lin camlet_N = mkN "驼毛呢" ; -- open-multilingual-wordnet
lin camomile_N = mkN "甘菊" ; -- status=guess
lin camouflage_N = mkN "伪装" ;
lin camouflage_V2 = mkV2 "伪装" ;
lin camp_A = mkA "不自然" | mkA "忸怩作态" | mkA "装模作样" ; -- open-multilingual-wordnet
lin camp_N = mkN "阵营" ;
lin camp_V = mkV "扎营" ;
lin camp_out_V = mkV "宿营" | mkV "扎营" | mkV "露营" ; -- open-multilingual-wordnet
lin campaign_N = mkN "运动" | {-HSK-} mkN "运动" " " ;
lin campaign_V = mkV "竞选" ;
lin campaigner_N = mkN "活动家" ;
lin campanile_N = mkN "钟塔" | mkN "钟楼" ; -- open-multilingual-wordnet
lin campanulate_A = mkA "钟状" ; -- open-multilingual-wordnet
lin campbeltown_PN = foreignPN "Campbeltown" ; -- comment=src=geonames status=guess
lin camper_N = mkN "露营者" ;
lin campestral_A = mkA "乡村" | mkA "乡间" | mkA "田野" ; -- open-multilingual-wordnet
lin camp_fire_N = mkN "營火" | mkN "营火" ; -- status=guess -- status=guess
lin camphor_N = mkN "樟腦" | mkN "樟脑" | {-mwn-} mkN "莰酮" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin camphoraceous_A = mkA "像樟脑" | mkA "樟脑特有" ; -- open-multilingual-wordnet
lin camphoric_A = mkA "含樟脑" | mkA "搀有樟脑" ; -- open-multilingual-wordnet
lin camping_N = mkN "露營" | mkN "露营" ; -- status=guess -- status=guess
lin campsite_N = mkN "露營地" | mkN "露营地" | mkN "營地" | mkN "营地" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin camp_stool_N = mkN "折凳" | mkN "折椅" | mkN "轻便折凳" | mkN "轻便折叠凳" ; -- open-multilingual-wordnet
lin campus_N = mkN "校园" ;
lin camshaft_N = mkN "凸轮轴" ; -- open-multilingual-wordnet
lin can8know_VV = S.can8know_VV ;
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_N = mkN "会" "個" | mkN "可以" | mkN "罐头" "個" | {-HSK-} mkN "罐头" ;
lin can_V2 = mkV2 "装罐" ;
lin canada_PN = mkPN "加拿大" ;
lin canadian_A = mkA "加拿大" ;
lin canal_N = mkN "运河" "条" ;
lin canalicular_A = mkA "似小管" | mkA "似微管" | mkA "小管" | mkA "微管" ; -- open-multilingual-wordnet
lin canaliculate_A = mkA "有细管" ; -- open-multilingual-wordnet
lin canary_A = mkA "淡黄色" ; -- open-multilingual-wordnet
lin canary_N = mkN "金絲雀" | mkN "金丝雀" ; -- status=guess -- status=guess
lin canavanine_N = mkN "刀豆氨酸" ; -- open-multilingual-wordnet
lin canberra_PN = mkPN "堪培拉" ; -- comment=src=geonames status=guess
lin cancan_N = mkN "康康舞" ; -- status=guess
lin cancel_V = mkV "删除" | mkV "取消" ;
lin cancel_V2 = mkV2 "删除" | mkV2 "取消" ;
lin cancellation_N = mkN "取消" | {-HSK-} mkN "消除" "次" ;
lin cancer_N = mkN "癌症" ;
lin cancer_PN = foreignPN "Cancer" ; -- comment=src=eng status=guess
lin cancerous_A = mkA "癌" ;
lin cancroid_A = mkA "一种皮肤癌" | mkA "癌状" | mkA "癌症状" ; -- open-multilingual-wordnet
lin cancroid_N = mkN "癌" ; -- open-multilingual-wordnet
lin candelabrum_N = mkN "燭臺" | mkN "燭台" | mkN "烛台" | mkN "分枝燭台" | mkN "分枝烛台" | {-mwn-} mkN "枝形大烛台" | mkN "枝状大烛台" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin candid_A = mkA "坦率" ;
lin candida_N = mkN "假丝酵母" | mkN "假丝酵母属" ; -- open-multilingual-wordnet
lin candidateFem_N = mkN "候选人" ;
lin candidateMasc_N = mkN "候选人" ;
lin candle_N = mkN "蜡烛" | {-HSK-} mkN "蜡烛" "根" ;
lin candlelight_N = mkN "烛火" ;
lin candlesnuffer_N = mkN "熄烛器" ; -- open-multilingual-wordnet
lin candlestick_N = mkN "燭臺" | mkN "燭台" | mkN "烛台" | {-mwn-} mkN "蜡烛架" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin candlewick_N = mkN "燭心" | mkN "烛心" | mkN "炷" | {-mwn-} mkN "烛芯" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin candy_N = mkN "糖" "顆" | {-HSK-} mkN "糖果" ;
lin candy_V = mkV "糖煮" ;
lin candy_V2 = mkV2 "使+结晶为砂糖" ;
lin cane_N = mkN "甘蔗" ;
lin cangue_N = mkN "枷" | mkN "木枷" | mkN "枷鎖" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin canine_A = mkA "犬" ;
lin canine_N = mkN "犬齒" | mkN "犬齿" | {-mwn-} mkN "犬科动物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin canister_N = mkN "罐" ; -- open-multilingual-wordnet
lin cankerworm_N = mkN "尺蠖" ; -- open-multilingual-wordnet
lin cannabin_N = mkN "大麻甙" | mkN "大麻脂" ; -- open-multilingual-wordnet
lin cannabis_N = mkN "大麻" ; -- status=guess -- open-multilingual-wordnet
lin cannery_N = mkN "罐头工厂" | mkN "罐头食品厂" ; -- open-multilingual-wordnet
lin cannes_PN = mkPN "戛纳" ; -- comment=src=geonames status=guess
lin cannibal_N = mkN "食人者" | mkN "吃同类的生物" ; -- status=guess -- status=guess
lin cannibalism_N = mkN "同類相食" | mkN "同类相食" | mkN "食人" | {-mwn-} mkN "嗜食同类" | mkN "自相残杀" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin cannibalistic_A = mkA "吃人肉" | mkA "食人肉" ; -- open-multilingual-wordnet
lin cannikin_N = mkN "小罐" ; -- open-multilingual-wordnet
lin cannock_PN = foreignPN "Cannock" ; -- comment=src=geonames status=guess
lin cannon_1_N = mkN "大炮" ;
lin cannon_2_N = mkN "大炮" ;
lin cannonade_N = mkN "砲擊" | mkN "炮击" ; -- status=guess -- status=guess
lin cannonball_N = mkN "炮彈" | mkN "炮弹" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cannula_N = mkN "套管" | mkN "插管" ; -- open-multilingual-wordnet
lin canny_A = mkA "精明" ;
lin canoe_N = mkN "獨木舟" | mkN "独木舟" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin canon_N = variants {} ;
lin canopy_N = mkN "盖" | {-mwn-} mkN "伞盖" | mkN "伞衣" ; -- open-multilingual-wordnet
lin cant_N = mkN "斜面" ;
lin cantab_PN = foreignPN "Cantab" ; -- comment=src=eng status=guess
lin cantaloupe_N = mkN "羅馬甜瓜" | mkN "罗马甜瓜" | mkN "哈密瓜" | mkN "香瓜" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin canteen_N = mkN "食堂""间" ;
lin canterbury_PN = mkPN "坎特伯雷" ; -- comment=src=geonames status=guess
lin cantilever_N = mkN "悬臂" ; -- open-multilingual-wordnet
lin cantle_N = mkN "鞍后桥" ; -- open-multilingual-wordnet
lin canton_PN = foreignPN "Canton" ; -- comment=src=geonames status=guess
lin cantonal_A = mkA "州" | mkA "市区" ; -- open-multilingual-wordnet
lin cantonment_N = mkN "宿营地" | mkN "营地" | mkN "露营" ; -- open-multilingual-wordnet
lin canvas_N = mkN "帆布" ;
lin canvass_N = mkN "帆布" ; -- open-multilingual-wordnet
lin canvass_V = mkV "游说" ;
lin canvey_PN = foreignPN "Canvey" ; -- comment=src=eng status=guess
lin canvey_island_PN = foreignPN "Canvey island" ; -- comment=src=eng status=guess
lin canyon_N = mkN "峡谷" ;
lin cap_1_N = L.cap_N | {-HSK-} mkN "帽子" "頂" ;
lin cap_2_N = L.cap_N | {-HSK-} mkN "帽子" "頂" ;
lin cap_V2 = mkV2 "盖子" ;
lin capability_N = mkN "功能" | mkN "本领" "項" | mkN "能" | mkN "能力" "個" | {-HSK-} mkN "能力" "种" ;
lin capable_of_A2 = mkA2 "有能力" | {-HSK-} mkA2 "棒" | mkA2 "能" | mkA2 "能力" | mkA2 "能干" | mkA2 "行" ;
lin capacitance_N = mkN "电容" | mkN "電容" | {-mwn-} mkN "电容器" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin capacitive_A = mkA "容性" | mkA "电容" ; -- open-multilingual-wordnet
lin capacitor_N = mkN "電容器" | mkN "电容器" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin capacity_N = mkN "容量" | {-HSK-} mkN "身份" ;
lin caparison_N = mkN "华丽的鞍辔" | mkN "马披" | mkN "马饰" ; -- open-multilingual-wordnet
lin cape_N = mkN "斗篷" | mkN "披肩" ; -- status=guess -- status=guess
lin cape_town_PN = foreignPN "Cape town" ; -- comment=src=eng status=guess
lin capelin_N = mkN "细鳞胡瓜鱼" | mkN "香鱼科之小鱼" ; -- open-multilingual-wordnet
lin caper_N = mkN "水瓜柳" ; -- status=guess
lin caper_V = mkV "欢跃" | mkV "蹦蹦跳跳" | mkV "雀跃" ; -- open-multilingual-wordnet
lin capful_N = mkN "一帽子" | mkN "少许" | mkN "少量" ; -- open-multilingual-wordnet
lin capillary_A = mkA "毛状" ; -- open-multilingual-wordnet
lin capillary_N = mkN "毛細管" | mkN "毛细管" | mkN "微血管" | mkN "毛細血管" | mkN "毛细血管" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin capital_1_N = variants {} ;
lin capital_2_N = variants {} ;
lin capital_3_N = variants {} ;
lin capital_A = mkA "资本" | {-HSK-} mkA "资金" | mkA "首都" ;
lin capital_N = mkN "资本" ;
lin capitalism_N = mkN "资本主义" [] ;
lin capitalist_A = mkA "资本家" ;
lin capitalist_N = mkN "资本家" ;
lin capitalistic_A = mkA "资本主义" ;
lin capitalization_N = mkN "大写" ;
lin capitalize_V = mkV "利用" ;
lin capitalize_V2 = mkV2 "利用" ;
lin capitate_A = mkA "头状" | mkA "头状花序" ; -- open-multilingual-wordnet
lin capitation_N = mkN "人头税" ; -- open-multilingual-wordnet
lin capitol_N = mkN "国会大厦" ;
lin capitular_A = mkA "牧师会" ; -- open-multilingual-wordnet
lin capitulate_V = mkV "劝降" ;
lin capitulation_N = mkN "投降" ; -- status=guess
lin capote_N = mkN "带帽长斗篷" ; -- open-multilingual-wordnet
lin cappuccino_N = mkN "卡布奇諾" | mkN "卡布奇诺" | mkN "卡布其諾" | mkN "卡布其诺" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin caprice_N = mkN "任性" | mkN "冲动" ; -- open-multilingual-wordnet
lin capricious_A = mkA "任性" ;
lin capriciousness_N = mkN "随意性" "" ;
lin capricorn_PN = foreignPN "Capricorn" ; -- comment=src=eng status=guess
lin caprine_A = mkA "公山羊" | mkA "如山羊" | mkA "山羊" ; -- open-multilingual-wordnet
lin capsaicin_N = mkN "辣椒碱" | mkN "辣椒素" ; -- open-multilingual-wordnet
lin capsicum_N = mkN "菜椒" ; -- status=guess
lin capsize_V = mkV "翻" ;
lin capsize_V2 = mkV2 "使+倾覆" ;
lin capstan_N = mkN "絞盤" | mkN "绞盘" | {-mwn-} mkN "卷扬机" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin capstone_N = mkN "压顶石" ; -- open-multilingual-wordnet
lin capsule_N = mkN "胶囊" "个" ;
lin capt_PN = foreignPN "Capt" ; -- comment=src=eng status=guess
lin captain_N = mkN "队长" ; -- comment="首领" ;
lin captain_V2 = mkV2 "带领" ;
lin caption_N = mkN "字幕" | mkN "说明" "個" | {-HSK-} mkN "標題" | mkN "标题" | {-mwn-} mkN "说明文字" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin captious_A = mkA "挑剔" ; -- status=guess
lin captivate_V2 = mkV2 "迷住" ; -- comment="迷惑" ;
lin captiveFem_N = mkN "俘虏" "名" ; ---- sense to be split
lin captiveMasc_N = mkN "俘虏" "名" ; ---- sense to be split
lin captive_A = mkA "俘虏" ;
lin captive_N = mkN "俘虏" "名" ;
lin captivity_N = mkN "囚禁" | {-mwn-} mkN "奴役" | mkN "被奴役" | mkN "被征服" ; -- status=guess -- open-multilingual-wordnet
lin capture_N = mkN "捕获" ;
lin capture_V2 = mkV2 "捕获" ;
lin capuchin_N = mkN "卷尾猴" | mkN "卷尾猴" | mkN "懸猴" | mkN "悬猴" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin caput_N = mkN "头" | mkN "头脑" | mkN "脑袋" ; -- open-multilingual-wordnet
lin capybara_N = mkN "水豚" ; -- status=guess
lin car_N = L.car_N ;
lin car_V = variants {} ;
lin carabao_N = mkN "水牛" ; -- open-multilingual-wordnet
lin carabiner_N = mkN "鐵鎖" | mkN "铁锁" ; -- status=guess -- status=guess
lin caracas_PN = mkPN "卡拉卡斯" ; -- comment=src=geonames status=guess
lin carafe_N = mkN "玻璃水瓶" | {-mwn-} mkN "饮料瓶" ; -- status=guess -- open-multilingual-wordnet
lin caramel_A = mkA "焦糖色" | mkA "酱色" ; -- open-multilingual-wordnet
lin caramel_N = mkN "焦糖" ; -- status=guess
lin carat_N = mkN "克拉" "" ;
lin caravan_N = mkN "大篷车" "辆" ;
lin caravanserai_N = mkN "商隊旅館" | mkN "商队旅馆" | {-mwn-} mkN "旅店" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin carbamate_N = mkN "氨基甲酸盐" ; -- open-multilingual-wordnet
lin carbide_N = mkN "碳化物" ;
lin carbine_N = mkN "卡宾枪" ; -- open-multilingual-wordnet
lin carbocyclic_A = mkA "碳环" ; -- open-multilingual-wordnet
lin carbohydrate_N = mkN "碳水化合物" | {-mwn-} mkN "糖类" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin carbolated_A = mkA "含石炭酸" | mkA "浸以石炭酸" | mkA "浸以石碳酸" ; -- open-multilingual-wordnet
lin carbomycin_N = mkN "碳霉素" ; -- open-multilingual-wordnet
lin carbon_N = mkN "碳" [] ;
lin carbonaceous_A = mkA "含碳" | mkA "碳" ; -- open-multilingual-wordnet
lin carbonate_N = mkN "碳酸盐" | {-mwn-} mkN "碳酸盐或酯" | mkN "碳酸酯" ; -- status=guess -- open-multilingual-wordnet
lin carbonated_A = mkA "含二氧化碳" ; -- open-multilingual-wordnet
lin carbonation_N = mkN "碳酸饱和" ; -- open-multilingual-wordnet
lin carbonic_A = mkA "含碳" | mkA "碳" ; -- open-multilingual-wordnet
lin carboniferous_A = mkA "含碳" | mkA "碳" ; -- open-multilingual-wordnet
lin carbonization_N = mkN "干馏" | mkN "碳化" | mkN "碳化作用" ; -- open-multilingual-wordnet
lin carbonyl_A = mkA "含羰基" | mkA "羰基" ; -- open-multilingual-wordnet
lin carborundum_N = mkN "碳化硅" | mkN "金刚砂" ; -- open-multilingual-wordnet
lin carboxyl_A = mkA "含羰基" | mkA "羧基" ; -- open-multilingual-wordnet
lin carboxyl_N = mkN "羧基" ; -- open-multilingual-wordnet
lin carboy_N = mkN "小口的大瓶" ; -- open-multilingual-wordnet
lin carbuncle_N = mkN "痈" | mkN "红疹" ; -- open-multilingual-wordnet
lin carburettor_N = mkN "化油器" | mkN "汽化器" ; -- open-multilingual-wordnet
lin carcass_N = mkN "尸体" "具" ;
lin carcinogen_N = mkN "致癌物質" | mkN "致癌物质" ; -- status=guess -- status=guess
lin carcinogenic_A = mkA "致癌" | {-mwn-} mkA "致癌" ; -- status=guess -- open-multilingual-wordnet
lin carcinoid_N = mkN "良性肿瘤" ; -- open-multilingual-wordnet
lin carcinoma_N = mkN "癌" ; -- open-multilingual-wordnet
lin carcinomatous_A = mkA "癌性" ; -- open-multilingual-wordnet
lin carcinosarcoma_N = mkN "癌肉瘤" ; -- open-multilingual-wordnet
lin card_1_N = mkN "卡" "张" | {-HSK-} mkN "名片" ;
lin card_2_N = mkN "卡" "张" | {-HSK-} mkN "名片" ;
lin cardamom_N = mkN "小豆蔻" | mkN "豆蔻" ; -- status=guess -- status=guess
lin cardboard_N = mkN "纸板" ;
lin cardcase_N = mkN "名片盒" ; -- open-multilingual-wordnet
lin cardenden_PN = foreignPN "Cardenden" ; -- comment=src=geonames status=guess
lin cardiac_A = mkA "心脏" ;
lin cardiff_PN = mkPN "加的夫" ; -- comment=src=geonames status=guess
lin cardigan_N = mkN "羊毛衣" "件" ;
lin cardigan_PN = foreignPN "Cardigan" ; -- comment=src=geonames status=guess
lin cardinal_N = mkN "红衣主教" "名" ;
lin cardinalfish_N = mkN "天竺鲷" ; -- open-multilingual-wordnet
lin cardinality_N = mkN "基數性" | mkN "基数性" ; -- status=guess -- status=guess
lin cardiographic_A = mkA "心动描记" ; -- open-multilingual-wordnet
lin cardioid_N = mkN "心形曲线" ; -- open-multilingual-wordnet
lin cardiologic_A = mkA "心脏病学" ; -- open-multilingual-wordnet
lin cardiologistFem_N = variants {} ; ---- sense to be split
lin cardiologistMasc_N = variants {} ; ---- sense to be split
lin cardiology_N = mkN "心臟內科" | mkN "心脏内科" | mkN "心髒病學" | mkN "心脏病学" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cardiomegaly_N = mkN "心肥大" | mkN "心脏肥大" ; -- open-multilingual-wordnet
lin cardiomyopathy_N = mkN "心肌病" ; -- open-multilingual-wordnet
lin cardiopulmonary_A = mkA "心肺" | mkA "心脏呼吸" ; -- open-multilingual-wordnet
lin cardiovascular_A = mkA "心脏血管" ; -- open-multilingual-wordnet
lin carditis_N = mkN "心炎" | mkN "心脏炎" ; -- open-multilingual-wordnet
lin cardroom_N = mkN "桥牌室" ; -- open-multilingual-wordnet
lin care_N = mkN "关心" | {-HSK-} mkN "关怀" ;
lin care_V = mkV "关心" ;
lin care_for_V2 = prepV2 OP_care_V OP_for_Prep ; -- guess-p-verb
lin careen_V = mkV "倾斜" ;
lin career_N = mkN "事业" ;
lin career_V = mkV "全速前进" | mkV "前进" | mkV "急驶" | mkV "猛冲" | mkV "飞奔" ; -- open-multilingual-wordnet
lin careerism_N = mkN "追名逐利主义" | mkN "追求名利" | mkN "野心" ; -- open-multilingual-wordnet
lin carefree_A = mkA "无忧无虑" ;
lin careful_A = mkA "仔细" | {-HSK-} mkA "小心" ;
lin careless_A = mkA "粗心" | {-HSK-} mkA "草" | mkA "马虎" ;
lin carelessness_N = mkN "粗心" | mkN "大意" | mkN "草率" ; -- status=guess -- status=guess -- status=guess
lin carer_N = variants {} ;
lin caress_V2 = mkV2 (mkV "愛撫") | mkV2 (mkV "爱抚") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin caretaker_N = mkN "看守人" ;
lin carful_N = mkN "一车之量" ; -- open-multilingual-wordnet
lin cargo_N = mkN "货物" "批" ;
lin caribou_N = mkN "驯鹿" ;
lin caricature_N = mkN "漫画" ;
lin caricature_V2 = mkV2 "将*画成漫画讽刺" ;
lin caries_N = mkN "齲齒" | mkN "龋齿" | mkN "蛀牙" | mkN "蟲牙" | mkN "虫牙" | {-mwn-} mkN "蛀牙的洞" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin carillon_N = mkN "钟琴" ;
lin carinal_A = mkA "龙骨板" ; -- open-multilingual-wordnet
lin carl_PN = foreignPN "Carl" ; -- comment=src=eng status=guess
lin carlisle_PN = mkPN ("卡莱尔" | "卡萊爾") ; -- comment=src=geonames status=guess
lin carlow_PN = foreignPN "Carlow" ; -- comment=src=geonames status=guess
lin carluke_PN = foreignPN "Carluke" ; -- comment=src=geonames status=guess
lin carmarthen_PN = mkPN "卡马森" ; -- comment=src=geonames status=guess
lin carmelite_A = mkA "卡默利特平纹薄呢" ;
lin carminative_N = mkN "驱风止痛剂" ; -- open-multilingual-wordnet
lin carnage_N = mkN "大屠杀" "场" ;
lin carnallite_N = mkN "光卤石" | mkN "光鲁石" ; -- open-multilingual-wordnet
lin carnation_A = mkA "粉红色" | mkA "肉红色" ; -- open-multilingual-wordnet
lin carnation_N = mkN "康乃馨" ; -- status=guess
lin carnelian_N = mkN "瑪" | mkN "玛" | {-mwn-} mkN "光玉髓" | mkN "红玉髓" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin carnforth_PN = foreignPN "Carnforth" ; -- comment=src=geonames status=guess
lin carnival_N = mkN "狂欢节" ; -- comment="嘉年华会" ;
lin carnivore_N = mkN "食肉动物" ;
lin carnivorous_A = mkA "食肉" ; -- status=guess
lin carnotite_N = mkN "钒钾铀矿" ; -- open-multilingual-wordnet
lin carnoustie_PN = foreignPN "Carnoustie" ; -- comment=src=geonames status=guess
lin carol_PN = foreignPN "Carol" ; -- comment=src=eng status=guess
lin carole_PN = foreignPN "Carole" ; -- comment=src=eng status=guess
lin carolina_PN = foreignPN "Carolina" ; -- comment=src=geonames status=guess
lin caroline_PN = foreignPN "Caroline" ; -- comment=src=eng status=guess
lin carolyn_PN = foreignPN "Carolyn" ; -- comment=src=eng status=guess
lin carotenemia_N = mkN "胡萝卜血症" ; -- open-multilingual-wordnet
lin carotenoid_N = mkN "类胡萝卜素" ; -- open-multilingual-wordnet
lin carotid_A = mkA "颈动脉" ; -- open-multilingual-wordnet
lin carousel_N = mkN "旋木" | mkN "旋转木马" ; -- open-multilingual-wordnet
lin carp_N = mkN "鲤鱼" ;
lin carp_V = mkV "吹毛求疵" ;
lin carpal_A = mkA "腕" ; -- open-multilingual-wordnet
lin carpal_N = mkN "腕隧道癥候群" | mkN "腕隧道症候群" ; -- status=guess -- status=guess
lin carpellary_A = mkA "心皮" ; -- open-multilingual-wordnet
lin carpenter_N = mkN "木匠" ;
lin carpentry_N = mkN "木器" "件" ;
lin carpet_N = L.carpet_N | {-HSK-} mkN "地毯" ;
lin carpet_V2 = mkV2 "铺地毯" ;
lin carpetbag_N = mkN "毯制手提包" | mkN "毯制的旅行袋" ; -- open-multilingual-wordnet
lin carpetbagger_N = mkN "投机者" ;
lin carport_N = mkN "无墙车库" | mkN "车棚" ; -- open-multilingual-wordnet
lin carposporic_A = mkA "果孢子" ; -- open-multilingual-wordnet
lin carposporous_A = mkA "有囊果" | mkA "有果孢子" ; -- open-multilingual-wordnet
lin carrack_N = mkN "大帆船" | mkN "宽身帆船" ; -- open-multilingual-wordnet
lin carrageenin_N = mkN "角叉菜胶" ; -- open-multilingual-wordnet
lin carrel_N = mkN "小单间" | mkN "小阅读室" ; -- open-multilingual-wordnet
lin carriage_N = mkN "车厢" "節" | {-HSK-} mkN "马车" "辆" ;
lin carriageway_N = mkN "行車道" | mkN "行车道" | {-mwn-} mkN "汽车道" | mkN "车行道" | mkN "车道" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin carrie_PN = foreignPN "Carrie" ; -- comment=src=eng status=guess
lin carrier_N = mkN "支架" ;
lin carron_PN = foreignPN "Carron" ; -- comment=src=eng status=guess
lin carrot_N = mkN "胡萝卜" "根" ;
lin carroty_A = mkA "橘红色" | mkA "胡萝卜色" ; -- open-multilingual-wordnet
lin carry_N = mkN "携带" [] ;
lin carry_V = mkV "带" | mkV "抱" | mkV "提" | mkV "送" | {-HSK-} mkV "携带" ;
lin carry_V2 = mkV2 "带" | mkV2 "抱" | mkV2 "提" | mkV2 "送" | {-HSK-} mkV2 "携带" | {-HSK-} mkV2 "挎" ;
lin carry_forward_V2 = mkV2 (advV OP_carry_V OP_forward_Adv ) ; -- guess-p-verb
lin carry_off_V2 = prepV2 OP_carry_V OP_off_Prep ; -- guess-p-verb
lin carry_on_V = mkV "卷" | mkV "接着" | mkV "进行" ;
lin carry_on_V2 = mkV2 "卷" | mkV2 "接着" | mkV2 "进行" ;
lin carry_on_about_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_about_Prep ; -- guess-p-verb
lin carry_on_with_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin carry_out_V = mkV "实行" | mkV "展开" | mkV "进行" ;
lin carry_out_V2 = mkV2 "实行" | mkV2 "展开" | mkV2 "进行" ;
lin carry_over_V2 = prepV2 OP_carry_V OP_over_Prep ; -- guess-p-verb
lin carry_through_V2 = prepV2 OP_carry_V OP_through_Prep ; -- guess-p-verb
lin carryall_N = mkN "大手提包" ; -- open-multilingual-wordnet
lin carrycot_N = mkN "手提式婴儿床" ; -- open-multilingual-wordnet
lin carsick_A = mkA "晕机" | mkA "晕船" | mkA "晕车" | mkA "空晕病" ; -- open-multilingual-wordnet
lin cart_N = mkN "购物车" ;
lin cart_V2 = mkV2 "用马车载" ;
lin cartagena_PN = mkPN "卡塔赫纳" ; -- comment=src=geonames status=guess
lin cartel_N = mkN "卡特尔" "" ;
lin carthorse_N = mkN "拖货车的马" ; -- open-multilingual-wordnet
lin cartilage_N = mkN "软骨" ;
lin cartilaginification_N = mkN "软骨化" ; -- open-multilingual-wordnet
lin cartload_N = mkN "运载量" ; -- open-multilingual-wordnet
lin cartographic_A = mkA "制图" | mkA "地图制作" | mkA "地图绘制" ; -- open-multilingual-wordnet
lin cartography_N = mkN "地圖學" | mkN "地图学" | mkN "製圖學" | mkN "制图学" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin carton_N = mkN "纸板箱" ;
lin cartoon_N = mkN "动画片" | {-HSK-} mkN "卡通片" ; -- comment=" 动画片" ;
lin cartoonistFem_N = variants {} ; ---- sense to be split
lin cartoonistMasc_N = variants {} ; ---- sense to be split
lin cartouche_N = mkN "卡圖什" | mkN "卡图什" | {-mwn-} mkN "弹药箱" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cartridge_N = mkN "弹药筒" "个" ;
lin caruncular_A = mkA "垂肉" | mkA "皮瘤" | mkA "种阜" | mkA "肉冠" | mkA "肉阜" ; -- open-multilingual-wordnet
lin carunculate_A = mkA "有种阜" ; -- open-multilingual-wordnet
lin carve_V = mkV "刻" | {-HSK-} mkV "雕刻" ;
lin carve_V2 = mkV2 "刻" | {-HSK-} mkV2 "雕刻" ;
lin carvedilol_N = mkN "卡维地洛" ; -- open-multilingual-wordnet
lin carving_N = mkN "雕刻" ; -- status=guess
lin caryatid_N = mkN "像柱" | mkN "女像柱" ; -- open-multilingual-wordnet
lin caryophyllaceous_A = mkA "石竹科" ; -- open-multilingual-wordnet
lin casablanca_PN = mkPN "达尔贝达" ; -- comment=src=geonames status=guess
lin cascade_N = mkN "级联" ;
lin cascade_V = mkV "级联" ;
lin cascara_N = mkN "药鼠李皮剂" ; -- open-multilingual-wordnet
lin case_N = mkN "案件" | {-HSK-} mkN "盒子" ;
lin case_V2 = mkV2 "把+装箱" ;
lin casebook_A = mkA "教科书" | mkA "课本" ; -- open-multilingual-wordnet
lin casement_N = mkN "窗扉""" ;
lin casern_N = mkN "兵营" ; -- open-multilingual-wordnet
lin cash_N = mkN "现金" ;
lin cash_V = mkV "现金" ;
lin cashbox_N = mkN "钱箱" ; -- open-multilingual-wordnet
lin cashew_N = mkN "腰果樹" | mkN "腰果树" ; -- status=guess -- status=guess
lin cashier_N = mkN "收银员" ;
lin cashmere_N = mkN "開司米" | mkN "开司米" | {-mwn-} mkN "开司米织物" | mkN "羊绒织物" | mkN "软毛织物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin casing_N = mkN "套" ;
lin casino_N = mkN "赌场" ;
lin cask_N = mkN "木桶" | {-mwn-} mkN "大琵琶桶" | mkN "桶" ; -- status=guess -- open-multilingual-wordnet
lin casket_N = mkN "棺材" ;
lin caspase_N = mkN "蛋白酶" ; -- open-multilingual-wordnet
lin casque_N = mkN "盔" ; -- open-multilingual-wordnet
lin casserole_N = mkN "法國砂鍋" | mkN "法国砂锅" | mkN "法國烤鍋" | mkN "法国烤锅" | {-mwn-} mkN "焙盘" | mkN "砂锅" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin cassette_N = mkN "盒式磁带" "盒" ;
lin cassiterite_N = mkN "锡石" ; -- open-multilingual-wordnet
lin cassock_N = mkN "法衣" | mkN "袈裟" | mkN "衲" ; -- status=guess -- status=guess -- status=guess
lin cassowary_N = mkN "鶴鴕" | mkN "鹤鸵" | mkN "食火雞" | mkN "食火鸡" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cast_N = mkN "铸件" ;
lin cast_V = mkV "投" | {-HSK-} mkV "浇" ;
lin cast_V2 = mkV2 "投" | {-HSK-} mkV2 "浇" ;
lin cast_about_for_V2 = prepV2 (advV OP_cast_V OP_about_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_around_V = advV OP_cast_V OP_around_Adv ; -- guess-p-verb
lin cast_around_for_V2 = prepV2 (advV OP_cast_V OP_around_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_aside_V2 = mkV2 (advV OP_cast_V OP_aside_Adv ) ; -- guess-p-verb
lin cast_iron_A = mkA "铁铸" ;
lin cast_off_V = advV OP_cast_V OP_off_Adv ; -- guess-p-verb
lin cast_off_V2 = prepV2 OP_cast_V OP_off_Prep ; -- guess-p-verb
lin cast_out_V2 = prepV2 OP_cast_V OP_out_Prep ; -- guess-p-verb
lin cast_round_for_V2 = prepV2 (advV OP_cast_V OP_round_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_up_V2 = prepV2 OP_cast_V OP_up_Prep ; -- guess-p-verb
lin caste_N = mkN "種姓" | mkN "种姓" | mkN "种姓制度" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin caster_N = mkN "铸工" ;
lin castigate_V2 = mkV2 "惩罚" ;
lin casting_N = mkN "铸件" "件" ;
lin castle_N = mkN "城堡" ;
lin castle_V = mkV "筑城堡" ;
lin castleford_PN = foreignPN "Castleford" ; -- comment=src=geonames status=guess
lin castor_oil_N = mkN "蓖麻油" ;
lin castrate_V2 = mkV2 (mkV "閹割") | mkV2 (mkV "阉割") | mkV2 (mkV "去勢") | mkV2 (mkV "去势") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin castration_N = mkN "宮刑" | mkN "宫刑" | mkN "去勢" | mkN "去势" | mkN "閹割" | mkN "阉割" | {-mwn-} mkN "修正" | mkN "删去" | mkN "删除" | mkN "廓清" | mkN "消去" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin casual_A = mkA "随便" ;
lin casualty_N = mkN "受害者" ;
lin casuistry_N = mkN "诡辩" ;
lin cat_N = L.cat_N | {-HSK-} mkN "猫" "隻" ;
lin catabiosis_N = mkN "细胞衰老" ; -- open-multilingual-wordnet
lin catabolism_N = mkN "異化作用" | mkN "异化作用" | {-mwn-} mkN "分解代谢" | mkN "降解代谢" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin catachrestic_A = mkA "用词不当" ; -- open-multilingual-wordnet
lin cataclysm_N = mkN "灾难" ;
lin catacomb_N = mkN "地下墓穴" | {-mwn-} mkN "地下埋葬地" | mkN "陵寝" ; -- status=guess -- open-multilingual-wordnet
lin catafalque_N = mkN "灵柩台" ; -- open-multilingual-wordnet
lin catalanFem_N = variants {} ;
lin catalanMasc_N = variants {} ;
lin catalan_A = mkA "加泰罗尼亚" ;
lin catalase_N = mkN "接触酵素" | mkN "过氧化氢酶" ; -- open-multilingual-wordnet
lin catalatic_A = mkA "过氧化氢酶" ; -- open-multilingual-wordnet
lin catalepsy_N = mkN "全身僵硬症" | mkN "强直性昏厥" ; -- open-multilingual-wordnet
lin cataleptic_A = mkA "全身僵硬症" ; -- open-multilingual-wordnet
lin catalog_N = mkN "目录" ;
lin catalogue_N = mkN "目录" ;
lin catalysis_N = mkN "催化作用" ; -- open-multilingual-wordnet
lin catalyst_N = mkN "催化剂" ;
lin catalytic_A = mkA "催化" ;
lin catamaran_N = mkN "双体船" ;
lin catania_PN = foreignPN "Catania" ; -- comment=src=geonames status=guess
lin cataphasia_N = mkN "言语重复" ; -- open-multilingual-wordnet
lin catapult_N = mkN "彈射器" | mkN "弹射器" | {-mwn-} mkN "中世的抛石机" | mkN "投石器" | mkN "投石机" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin catapult_V2 = mkV2 "发射" ;
lin catapultic_A = mkA "发射" | mkA "弹射" ; -- open-multilingual-wordnet
lin cataract_N = mkN "白内障" ;
lin catarrh_N = mkN "黏膜炎" ; -- open-multilingual-wordnet
lin catarrhal_A = mkA "卡他" | mkA "卡他性" | mkA "鼻粘膜炎" ; -- open-multilingual-wordnet
lin catastrophe_N = mkN "灾难" ;
lin catastrophic_A = mkA "灾难性" ;
lin catatonia_N = mkN "緊張症" | mkN "紧张症" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin catatonic_A = mkA "紧张性精神症" ; -- open-multilingual-wordnet
lin catboat_N = mkN "独桅艇" ; -- open-multilingual-wordnet
lin catch_N = mkN "抓" ;
lin catch_V2 = mkV2 "抓" | {-HSK-} mkV2 "拿" | mkV2 "接" ;
lin catch_at_V2 = prepV2 (lin V OP_catch_V2) OP_at_Prep ; -- guess-p-verb
lin catch_on_V = mkV "理解" ;
lin catch_out_V2 = prepV2 (lin V OP_catch_V2) OP_out_Prep ; -- guess-p-verb
lin catch_up_V = advV (lin V OP_catch_V2) OP_up_Adv ; -- guess-p-verb
lin catch_up_V2 = prepV2 (lin V OP_catch_V2) OP_up_Prep ; -- guess-p-verb
lin catch_up_in_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_in_Prep ; -- guess-p-verb
lin catch_up_on_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin catch_up_with_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin catchall_N = mkN "杂物包" ; -- open-multilingual-wordnet
lin catcher_N = mkN "捕手" ;
lin catchment_N = mkN "贮水池" ; -- open-multilingual-wordnet
lin catchphrase_N = mkN "口號" | mkN "口号" ; -- status=guess -- status=guess
lin catechetical_A = mkA "问答式教法" ; -- open-multilingual-wordnet
lin catechism_N = mkN "教義問答" | mkN "教义问答" ; -- status=guess -- status=guess
lin catechismal_A = mkA "教义问答书" ; -- open-multilingual-wordnet
lin categorematic_A = mkA "可单独使用" | mkA "范畴性" ; -- open-multilingual-wordnet
lin categorial_A = mkA "范畴" ; -- open-multilingual-wordnet
lin categoric_A = mkA "属于某一范畴" ; -- open-multilingual-wordnet
lin categorical_A = mkA "绝对" ;
lin categorize_V2 = mkV2 "分类" ;
lin category_N = mkN "类" | mkN "门" | {-HSK-} mkN "类别" | {-HSK-} mkN "范畴" ;
lin catenary_N = mkN "垂曲线" | mkN "悬链线" ; -- open-multilingual-wordnet
lin catenulate_A = mkA "成链形" | mkA "链状" ; -- open-multilingual-wordnet
lin cater_V = mkV "迎合" ;
lin caterer_N = mkN "餐饮服务商" ;
lin caterpillar_N = mkN "毛毛蟲" | mkN "毛毛虫" | mkN "毛蟲" | mkN "毛虫" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin catfish_N = mkN "鲶鱼" ;
lin catgut_N = mkN "羊肠线" | mkN "肠线" ; -- open-multilingual-wordnet
lin cath_PN = foreignPN "Cath" ; -- comment=src=eng status=guess
lin catharsis_N = mkN "洗涤" ;
lin cathectic_A = mkA "精神集中发泄" | mkA "聚精会神" ; -- open-multilingual-wordnet
lin cathedral_A = mkA "大教堂" ; -- open-multilingual-wordnet
lin cathedral_N = mkN "大教堂" "座" ;
lin catherine_PN = foreignPN "Catherine" ; -- comment=src=eng status=guess
lin catheter_N = mkN "导管" ; -- open-multilingual-wordnet
lin cathode_N = mkN "阴极" ;
lin cathodic_A = mkA "负极" ; -- open-multilingual-wordnet
lin catholicFem_N = mkN "天主教徒" ;
lin catholicMasc_N = mkN "天主教徒" ;
lin catholic_A = mkA "天主教" ;
lin cathy_PN = foreignPN "Cathy" ; -- comment=src=eng status=guess
lin cation_N = mkN "阳离子" ; -- status=guess
lin cationic_A = mkA "阳离子" ; -- open-multilingual-wordnet
lin catkinate_A = mkA "柔荑花似" ; -- open-multilingual-wordnet
lin catling_N = mkN "双刃刀" ; -- open-multilingual-wordnet
lin catoptric_A = mkA "反射" ; -- open-multilingual-wordnet
lin catsup_N = mkN "番茄酱" ;
lin cattalo_N = mkN "皮弗娄牛" ; -- open-multilingual-wordnet
lin cattle_N = mkN "黄牛" "头" ;
lin cattleman_N = mkN "牧牛者" | mkN "牧牛人" | mkN "牧場主人" | mkN "牧场主人" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cattleship_N = mkN "载运牲畜的船" ; -- open-multilingual-wordnet
lin catty_N = mkN "斤" ; -- open-multilingual-wordnet
lin catwalk_N = mkN "貓步" | mkN "猫步" | mkN "伸展臺" | mkN "伸展台" | {-mwn-} mkN "桥上人行道" | mkN "狭小通道" | mkN "狭窄甬道" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin caucasianFem_N = variants {} ; ---- sense to be split
lin caucasianMasc_N = variants {} ; ---- sense to be split
lin caudal_A = mkA "尾部" ; -- status=guess
lin caudex_N = mkN "茎基" ; -- open-multilingual-wordnet
lin caul_N = mkN "胎膜" | mkN "胎衣" ; -- status=guess -- status=guess
lin cauldron_N = mkN "釜" | mkN "大鍋" | mkN "大锅" ; -- status=guess -- status=guess -- status=guess
lin cauliflower_N = mkN "花椰菜" | mkN "菜花" ; -- status=guess -- status=guess
lin causal_A = mkA "因果" | {-HSK-} mkA "而" ;
lin causalgia_N = mkN "皮肤灼热痛" ; -- open-multilingual-wordnet
lin causality_N = mkN "因果關係" | mkN "因果关系" | mkN "因果律" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin cause_N = mkN "原因" | {-HSK-} mkN "原因" "個" | mkN "由" | mkN "缘故" ;
lin cause_V2 = mkV2 "使" | mkV2 "导致" | mkV2 "引起" | mkV2 "造成" ;
lin cause_V2V = mkV2V "使" | mkV2V "导致" | mkV2V "引起" | mkV2V "造成" ;
lin causeway_N = mkN "堤道" | mkN "砌道" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin caustic_A = mkA "腐蚀性" ;
lin cauterize_V2 = mkV2 (mkV "燒灼") | mkV2 (mkV "烧灼") | mkV2 (mkV "灼") | mkV2 (mkV "灸") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin caution_N = mkN "劝告" ;
lin caution_V = mkV "警告" ;
lin caution_V2V = mkV2V "警告" ;
lin caution_VS = mkVS "慎重" [] ;
lin cautionary_A = mkA "警告" ;
lin cautious_A = mkA "仔细" | mkA "谨慎" | {-HSK-} mkA "兢兢业业" ;
lin cavalcade_N = mkN "騎馬行列" | mkN "骑马行列" ; -- status=guess -- status=guess
lin cavalier_A = mkA "傲慢" ;
lin cavalier_N = mkN "騎士" | mkN "骑士" ; -- status=guess -- status=guess
lin cavan_PN = mkPN "卡旺" ; -- comment=src=geonames status=guess
lin cave_N = mkN "洞" "個" | {-HSK-} mkN "洞穴" ;
lin cave_V = mkV "挖洞" ;
lin cave_V2 = mkV2 (mkV "淘空") ; -- status=guess, src=wikt
lin cave_in_V = mkV "倒坍" | mkV "倒塌" | mkV "垮掉" | mkV "崩溃" | mkV "崩落" | mkV "破坏" | mkV "陷落" ; -- open-multilingual-wordnet
lin caveat_N = mkN "需要注意" ;
lin caveman_N = mkN "穴居人" ; -- status=guess
lin cavernous_A = mkA "似巨穴" ;
lin caviar_N = mkN "魚子醬" | mkN "鱼子酱" ; -- status=guess -- status=guess
lin cavil_V = mkV "吹毛求疵" | mkV "挑剔" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin cavity_N = mkN "孔穴" | mkN "空腔" ; -- status=guess -- status=guess
lin cavy_N = mkN "天竺鼠" ; -- open-multilingual-wordnet
lin cc_N = mkN "千分之一公升" | mkN "千分之一寸" | mkN "毫升" ; -- open-multilingual-wordnet
lin cd_N = mkN "光盘" ;
lin cdr_PN = foreignPN "Cdr" ; -- comment=src=eng status=guess
lin cdre_PN = foreignPN "Cdre" ; -- comment=src=eng status=guess
lin cease_N = mkN "停止" [] ;
lin cease_V = mkV "停止" ;
lin cease_V2 = mkV2 "停止" ;
lin ceasefire_N = mkN "停火" | mkN "休戰" | mkN "休战" | mkN "停戰" | mkN "停战" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin ceaseless_A = mkA "不断" ;
lin cecal_A = mkA "像盲肠" | mkA "盲肠" ; -- open-multilingual-wordnet
lin cecil_PN = foreignPN "Cecil" ; -- comment=src=eng status=guess
lin cecilia_PN = foreignPN "Cecilia" ; -- comment=src=geonames status=guess
lin cecily_PN = foreignPN "Cecily" ; -- comment=src=eng status=guess
lin cedar_N = mkN "雪松" ;
lin cedarn_A = mkA "杉" | mkA "杉木制" ; -- open-multilingual-wordnet
lin cede_V2 = mkV2 "割让" ;
lin cedilla_N = mkN "軟音符" | mkN "软音符" ; -- status=guess -- status=guess
lin cedric_PN = foreignPN "Cedric" ; -- comment=src=eng status=guess
lin cefn_mawr_PN = foreignPN "Cefn-mawr" ; -- comment=src=eng status=guess
lin ceiling_N = L.ceiling_N ;
lin celandine_N = mkN "白屈菜" ; -- status=guess
lin celebrate_V2 = mkV2 "庆祝" | {-HSK-} mkV2 "过" ;
lin celebrated_A = mkA "著名" ;
lin celebration_N = mkN "庆典" ;
lin celebratory_A = mkA "为了庆祝" | mkA "祝贺" | mkA "表示庆祝" ; -- open-multilingual-wordnet
lin celebrity_N = mkN "名人" "位" | {-HSK-} mkN "明星" ;
lin celery_N = mkN "芹菜" ; -- status=guess
lin celesta_N = mkN "钢片琴" ; -- open-multilingual-wordnet
lin celestial_A = mkA "天國" | mkA "天国" ; -- status=guess -- status=guess
lin celestite_N = mkN "天青石" ; -- open-multilingual-wordnet
lin celia_PN = foreignPN "Celia" ; -- comment=src=eng status=guess
lin celiac_A = mkA "腹" | mkA "腹腔" ; -- open-multilingual-wordnet
lin celibate_A = mkA "实行节制" | mkA "禁欲" | mkA "节制性欲" | mkA "节欲" ; -- open-multilingual-wordnet
lin celioma_N = mkN "腹部瘤" ; -- open-multilingual-wordnet
lin cell_N = mkN "细胞" ;
lin cellar_N = mkN "地窖" ;
lin cellarage_N = mkN "地窖容积" | mkN "地窖的容积" ; -- open-multilingual-wordnet
lin cellblock_N = mkN "牢房" ; -- open-multilingual-wordnet
lin cellistFem_N = mkN "大提琴演奏家" "位" ;
lin cellistMasc_N = mkN "大提琴演奏家" "位" ;
lin cello_N = mkN "大提琴" ; -- status=guess -- open-multilingual-wordnet
lin cellophane_N = mkN "玻璃紙" | mkN "玻璃纸" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cellular_A = mkA "细胞" ;
lin cellularity_N = mkN "细胞结构" ; -- open-multilingual-wordnet
lin cellulitis_N = mkN "蜂窝织炎" ; -- open-multilingual-wordnet
lin celluloid_N = mkN "赛璐珞" ;
lin cellulose_N = mkN "纖維素" | mkN "纤维素" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cellulosic_N = mkN "纤维素" ; -- open-multilingual-wordnet
lin cellulosid_A = mkA "含纤维素" | mkA "有纤维质" | mkA "纤维素制成" | mkA "纤维质" ; -- open-multilingual-wordnet
lin celtuce_N = mkN "萵筍" | mkN "莴笋" | mkN "萵苣" | mkN "莴苣" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cement_N = mkN "水泥" [] ;
lin cement_V2 = mkV2 "水泥" ;
lin cementite_N = mkN "渗碳体" | mkN "碳化铁" ; -- open-multilingual-wordnet
lin cementitious_A = mkA "似水泥" | mkA "可用于胶合" | mkA "有粘性" | mkA "有黏性" ; -- open-multilingual-wordnet
lin cemetery_N = mkN "墓地" ;
lin cenobitic_A = mkA "修道者" ; -- open-multilingual-wordnet
lin cenogenesis_N = mkN "新性发生" | mkN "新生性变异" ; -- open-multilingual-wordnet
lin cenogenetic_A = mkA "新性发生" ; -- open-multilingual-wordnet
lin cenotaph_N = mkN "衣冠冢" ; -- open-multilingual-wordnet
lin censer_N = mkN "香炉" ; -- open-multilingual-wordnet
lin censor_N = mkN "檢查員" | mkN "检查员" ; -- status=guess -- status=guess
lin censor_V2 = mkV2 "审查" ;
lin censorial_A = mkA "审查员" | mkA "检察员" | mkA "检查官" | mkA "监察" ; -- open-multilingual-wordnet
lin censorship_N = mkN "审查制度" "种" ;
lin census_N = mkN "普查" ;
lin cent_N = mkN "一分钱" ;
lin centas_N = mkN "立分" ; -- open-multilingual-wordnet
lin centenarian_N = mkN "百岁或逾百岁以上的人" ;
lin centenary_A = mkA "一百年" ;
lin centenary_N = mkN "100周年庆典" | mkN "100周年庆祝" | mkN "100周年庆祝会" | mkN "100周年纪念" | mkN "一百周年庆典" | mkN "一百周年庆祝" | mkN "一百周年庆祝会" | mkN "一百周年纪念" | mkN "百周年纪念" ; -- open-multilingual-wordnet
lin centennial_A = mkA "百周年纪念" ;
lin centennial_N = mkN "百周年纪念" [] ;
lin center_A = mkA "中央" | {-HSK-} mkA "中心" ;
lin centerline_N = mkN "中线" ; -- open-multilingual-wordnet
lin centesimal_A = mkA "百分" | mkA "百分之一" | mkA "百进制" ; -- open-multilingual-wordnet
lin centesimo_N = mkN "意大利钱币" ; -- open-multilingual-wordnet
lin centiliter_N = mkN "厘升" ; -- open-multilingual-wordnet
lin centime_N = mkN "一分" ; -- open-multilingual-wordnet
lin centimetre_N = mkN "釐米" | mkN "厘米" ; -- status=guess -- status=guess
lin centipede_N = mkN "蜈蚣" ; -- status=guess
lin central_A = mkA "中央" ;
lin central_N = mkN "中央" ;
lin centralist_A = mkA "中央集权主义" | mkA "主张中央集权" ; -- open-multilingual-wordnet
lin centralize_V = mkV "集中" | {-mwn-} mkV "使集中" | mkV "形成中心" | mkV "把集中起来" | mkV "集中，聚集" | mkV "集结" ; -- open-multilingual-wordnet
lin centralize_V2 = mkV2 "使+集中" | {-HSK-} mkV2 "集中" ;
lin centre_N = mkN "中心" ;
lin centre_V = mkV "中心" ;
lin centre_V2 = mkV2 "使+聚集在一点" ;
lin centre_board_N = mkN "活动船板" | mkN "活动防浪板" ; -- open-multilingual-wordnet
lin centrepiece_N = mkN "中心件" | mkN "中心装饰品" ; -- open-multilingual-wordnet
lin centrex_N = mkN "中央交换" ; -- open-multilingual-wordnet
lin centrifugal_A = mkA "离心" ;
lin centrifugation_N = mkN "离心分离作用" | mkN "离心过滤" ; -- open-multilingual-wordnet
lin centrifuge_N = mkN "離心機" | mkN "离心机" ; -- status=guess -- status=guess
lin centrist_A = mkA "中立派" | mkA "中间路线" | mkA "温和主义" ; -- open-multilingual-wordnet
lin centroidal_A = mkA "穿过重心" | mkA "重心" ; -- open-multilingual-wordnet
lin centromere_N = mkN "著絲點" | mkN "着丝点" | mkN "著絲粒" | mkN "着丝粒" | mkN "中節" | mkN "中节" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin centromeric_A = mkA "着丝粒" ; -- open-multilingual-wordnet
lin centrosomic_A = mkA "中心体" ; -- open-multilingual-wordnet
lin centurion_N = mkN "百夫长" ;
lin century_N = mkN "世纪" | {-HSK-} mkN "世纪" "個" ;
lin cephalhematoma_N = mkN "头血肿" | mkN "胎头血肿" ; -- open-multilingual-wordnet
lin cephalic_A = mkA "头" ; -- open-multilingual-wordnet
lin cephalopod_A = mkA "头足类动物" ; -- open-multilingual-wordnet
lin cephalopod_N = mkN "头足类动物" | mkN "头足纲动物" ; -- open-multilingual-wordnet
lin cephaloridine_N = mkN "先锋霉素Ⅱ" | mkN "头孢噻定" | mkN "头孢菌素II" ; -- open-multilingual-wordnet
lin cephalothin_N = mkN "先锋霉素I" | mkN "头孢霉菌素" ; -- open-multilingual-wordnet
lin ceramic_A = mkA "陶瓷" ;
lin ceramic_N = mkN "陶瓷" ; -- status=guess -- open-multilingual-wordnet
lin ceramics_N = mkN "制陶业" [] ;
lin cerate_N = mkN "蜡剂" | mkN "蜡膏" ; -- open-multilingual-wordnet
lin ceratodus_N = mkN "澳洲肺鱼" | mkN "角齿鱼" ; -- open-multilingual-wordnet
lin cercarial_A = mkA "摇尾幼虫" ; -- open-multilingual-wordnet
lin cereal_A = mkA "谷物" | mkA "谷类" ; -- open-multilingual-wordnet
lin cereal_N = mkN "谷类" "种" ;
lin cerebellar_A = mkA "小脑" ; -- open-multilingual-wordnet
lin cerebellum_N = mkN "小腦" | mkN "小脑" ; -- status=guess -- status=guess
lin cerebration_N = mkN "思想" | mkN "思考" | mkN "考虑" ; -- open-multilingual-wordnet
lin cerebrospinal_A = mkA "脑脊髓" ; -- open-multilingual-wordnet
lin cerebrovascular_A = mkA "脑血管" ; -- open-multilingual-wordnet
lin cerebrum_N = mkN "大腦" | mkN "大脑" ; -- status=guess -- status=guess
lin cerecloth_N = mkN "蜡布" ; -- open-multilingual-wordnet
lin ceremonial_A = mkA "仪式" ;
lin ceremonial_N = mkN "仪式" | mkN "典礼" | mkN "式" ; -- open-multilingual-wordnet
lin ceremony_N = mkN "仪式" [] ;
lin ceresin_N = mkN "地蜡" ; -- open-multilingual-wordnet
lin ceric_A = mkA "四价铈" | mkA "高铈" ; -- open-multilingual-wordnet
lin cerium_N = mkN "鈰" ; -- status=guess
lin cerous_A = mkA "三价铈" ; -- open-multilingual-wordnet
lin certain_1_A = mkA "一定" ; -- comment=NOT SURE "一定" or "某些"
lin certain_2_A = mkA "一定" ; -- comment=NOT SURE "一定" or "某些"
lin certain_A = mkA "一定" ; -- comment=NOT SURE "一定" or "某些"
lin certainty_N = mkN "把握" | {-HSK-} mkN "确定性" "" ;
lin certificate_N = mkN "签证" "個" | mkN "证明" "個" | {-HSK-} mkN "证书" ;
lin certification_N = mkN "证明" ;
lin certificatory_A = mkA "批准" | mkA "授予证书" ; -- open-multilingual-wordnet
lin certify_V = mkV "签证" | {-HSK-} mkV "证明" ;
lin certify_V2 = mkV2 "签证" | {-HSK-} mkV2 "证明" ;
lin ceruminous_A = mkA "耳垢" | mkA "耳屎" ; -- open-multilingual-wordnet
lin cerussite_N = mkN "白铅矿" ; -- open-multilingual-wordnet
lin cervical_A = mkA "颈" ;
lin cervicitis_N = mkN "子宫颈炎" ; -- open-multilingual-wordnet
lin cervine_A = mkA "似鹿" | mkA "鹿" | mkA "鹿一样" ; -- open-multilingual-wordnet
lin cervix_N = mkN "子宫颈" ;
lin cesarean_A = mkA "剖腹产" ; -- open-multilingual-wordnet
lin cessation_N = mkN "停止" ;
lin cesspit_N = mkN "污水坑" | mkN "污水渗井" ; -- open-multilingual-wordnet
lin cesspool_N = mkN "糞池" | mkN "粪池" | {-mwn-} mkN "污水坑" | mkN "污水渗井" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cetacean_A = mkA "鲸" | mkA "鲸目哺乳动物" | mkA "鲸类" | mkA "鲸鱼" ; -- open-multilingual-wordnet
lin cetacean_N = mkN "鲸目动物" ; -- open-multilingual-wordnet
lin cetrimide_N = mkN "溴棕三甲铵" ; -- open-multilingual-wordnet
lin ceylon_PN = foreignPN "Ceylon" ; -- comment=src=eng status=guess
lin cf_PN = foreignPN "Cf" ; -- comment=src=eng status=guess
lin cgs_N = mkN "CGS制" | mkN "厘米克秒制" ; -- open-multilingual-wordnet
lin chachka_N = mkN "小玩意儿" ; -- open-multilingual-wordnet
lin chad_PN = mkPN "乍得" ; -- comment=src=geonames status=guess
lin chador_N = mkN "方披巾" ; -- open-multilingual-wordnet
lin chaetodon_N = mkN "蝴蝶鱼" ; -- open-multilingual-wordnet
lin chafe_N = mkN "摩擦" | mkN "磨損" | mkN "磨损" | mkN "擦傷" | mkN "擦伤" | {-mwn-} mkN "恼怒" | mkN "烦恼" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin chafe_V = mkV "擦伤" ;
lin chaff_N = mkN "秕糠" | mkN "穀殼" | mkN "谷壳" | mkN "穀糠" | mkN "谷糠" | {-mwn-} mkN "金属箔" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin chaffy_A = mkA "多糠" | mkA "多谷壳" | mkA "粗糠多" ; -- open-multilingual-wordnet
lin chafing_dish_N = mkN "火锅" ; -- open-multilingual-wordnet
lin chagrin_N = mkN "懊惱，煩悶" ; -- status=guess
lin chain_N = mkN "连锁" ;
lin chain_V2 = mkV2 "链起" ;
lin chair_N = L.chair_N | {-HSK-} mkN "椅子" "把" ;
lin chair_V2 = mkV2 "使入座" ;
lin chair_lift_N = mkN "空中缆椅" ; -- open-multilingual-wordnet
lin chairman_N = mkN "主席" | {-HSK-} mkN "主席" "個" | mkN "总裁" ;
lin chairmanship_N = mkN "主席地位" ;
lin chaise_longue_N = mkN "躺倚" ; -- open-multilingual-wordnet
lin chalcedony_N = mkN "玉髓" ; -- open-multilingual-wordnet
lin chalcocite_N = mkN "辉铜矿" ; -- open-multilingual-wordnet
lin chalcopyrite_N = mkN "黄铜矿" ; -- open-multilingual-wordnet
lin chaldron_N = mkN "查尔特隆" | mkN "煤量名" ; -- open-multilingual-wordnet
lin chalfont_PN = foreignPN "Chalfont" ; -- comment=src=geonames status=guess
lin chalfont_st_giles_PN = foreignPN "Chalfont st giles" ; -- comment=src=eng status=guess
lin chalfont_st_peter_PN = foreignPN "Chalfont st peter" ; -- comment=src=eng status=guess
lin chalk_N = mkN "粉笔" "根" ;
lin chalk_V2 = mkV2 "记下" ;
lin chalkpit_N = mkN "白垩矿场" ; -- open-multilingual-wordnet
lin chalky_A = mkA "石灰质" | mkA "碳酸钙" | mkA "钙质" ; -- open-multilingual-wordnet
lin challenge_N = mkN "挑战" ;
lin challenge_V = mkV "挑战" ;
lin challenge_V2 = mkV2 "挑战" ;
lin challenger_N = mkN "挑战者" ;
lin chalybeate_A = mkA "含有铁质" | mkA "含铁盐" | mkA "含铁质" ; -- open-multilingual-wordnet
lin chamber_N = mkN "房间" ;
lin chambered_A = mkA "有小室" | mkA "隔成房间" ; -- open-multilingual-wordnet
lin chamberlain_N = mkN "侍從" | mkN "侍从" | mkN "管家" | mkN "內臣" | mkN "内臣" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin chamberpot_N = mkN "便壶" ; -- open-multilingual-wordnet
lin chambray_N = mkN "钱布雷绸" ; -- open-multilingual-wordnet
lin chameleon_N = mkN "變色龍" | mkN "变色龙" | mkN "變色蜥蜴" | mkN "变色蜥蜴" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin chamois_N = mkN "沙穆瓦" | mkN "麂皮" | mkN "麂皮革" | mkN "油鞣革" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin chamosite_N = mkN "鲕" | mkN "鲕绿泥石" ; -- open-multilingual-wordnet
lin champ_N = mkN "冠军" ;
lin champagne_N = mkN "香槟酒" ;
lin champion_A = mkA "优胜" | {-HSK-} mkA "冠军" ;
lin champion_Adv = mkAdv "冠军" ;
lin champion_N = mkN "冠军" | {-HSK-} mkN "冠军" "個" ;
lin champion_V2 = mkV2 "支持" ;
lin championship_N = mkN "锦标赛" ;
lin chance_N = mkN "机会" | {-HSK-} mkN "机会" "個" ;
lin chance_V = mkV "碰巧" ;
lin chance_V2 = mkV2 "使+偶然发生" ;
lin chancel_N = mkN "教堂高坛" ; -- open-multilingual-wordnet
lin chancellery_N = mkN "大法官官署" | mkN "大臣官署" | mkN "大臣官邸" | mkN "总理公署" ; -- open-multilingual-wordnet
lin chancellor_N = mkN "校长" "位" ;
lin chancery_N = mkN "大法官法庭" ; -- open-multilingual-wordnet
lin chancre_N = mkN "下疳" ; -- open-multilingual-wordnet
lin chancroid_N = mkN "軟下疳" | mkN "软下疳" | {-mwn-} mkN "软性下疳" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin chancrous_A = mkA "下疳" ; -- open-multilingual-wordnet
lin chandelier_N = mkN "枝形吊灯" "盏" ;
lin chandlery_N = mkN "蜡烛放置处" ; -- open-multilingual-wordnet
lin chanfron_N = mkN "马盔" ; -- open-multilingual-wordnet
lin changchun_PN = mkPN ("长春市" | "长春镇") ; -- comment=src=geonames status=guess
lin change_N = mkN "变化" "個" | mkN "换" | mkN "转变" "個" | mkN "零钱" | {-HSK-} mkN "改变" ;
lin change_V = mkV "变化" | mkV "改变" ;
lin change_V2 = mkV2 "变化" | mkV2 "改变" ;
lin change_over_V2 = prepV2 OP_change_V OP_over_Prep ; -- guess-p-verb
lin changeable_A = mkA "多變" | mkA "多变" ; -- status=guess -- status=guess
lin changeful_A = mkA "可改变" | mkA "多变" | mkA "易变" ; -- open-multilingual-wordnet
lin changeover_N = mkN "转换" ;
lin changing_A = variants {} ;
lin changsha_PN = mkPN ("长沙镇" | "长沙" | "長沙" | "开平") ; -- comment=src=geonames status=guess
lin channel_N = mkN "渠道" | {-HSK-} mkN "频道" ;
lin channel_V2 = mkV2 "引导" ;
lin chant_N = mkN "圣歌" "首" ;
lin chant_V = mkV "唱歌" ;
lin chant_V2 = mkV2 "圣歌" ;
lin chantlike_A = mkA "单调" | mkA "节奏单调" ; -- open-multilingual-wordnet
lin chaos_N = mkN "混乱" [] ;
lin chaotic_A = mkA "混沌" | {-HSK-} mkA "烂" ;
lin chap_N = mkN "龟裂" "次" ;
lin chapel_N = mkN "教堂" "座" ;
lin chaplain_N = mkN "牧師" | mkN "牧师" ; -- status=guess -- status=guess
lin chapman_N = mkN "叫卖商人" ;
lin chapter_N = mkN "章" ;
lin chapterhouse_N = mkN "联谊会会堂" ; -- open-multilingual-wordnet
lin char_N = mkN "炒粿條" | mkN "炒粿条" | mkN "炒貴刁" | mkN "炒贵刁" | {-mwn-} mkN "嘉鱼" | mkN "红点鲑" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin char_V2 = mkV2 "使+烧焦" ;
lin charabanc_N = variants {} ;
lin characin_N = mkN "脂鲤" ; -- open-multilingual-wordnet
lin character_1_N = mkN "字符" ;
lin character_2_N = mkN "字符" ;
lin characteristic_A = mkA "性质" | mkA "特征" | mkA "特点" | {-HSK-} mkA "特性" ;
lin characteristic_N = mkN "性质" "個" | mkN "特征" | mkN "特点" "個" | {-HSK-} mkN "特性" ;
lin characterization_N = mkN "描述" ;
lin characterize_V2 = mkV2 "表征" ;
lin characterless_A = mkA "平凡" ;
lin charades_N = mkN "詩謎" | mkN "诗谜" | mkN "謝拉德" | mkN "谢拉德" | mkN "字謎遊戲" | mkN "字谜游戏" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin charcoal_N = mkN "炭筆" | mkN "炭笔" | {-mwn-} mkN "炭画笔" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin chard_PN = foreignPN "Chard" ; -- comment=src=geonames status=guess
lin charge_1_N = mkN "费用" ;
lin charge_2_N = mkN "费用" ;
lin charge_N = mkN "费用" ;
lin charge_V = mkV "控告" | {-HSK-} mkV "闯" ;
lin charge_V2 = mkV2 "指控" | {-HSK-} mkV2 "闯" ;
lin charge_off_V = advV OP_charge_V OP_off_Adv ; -- guess-p-verb
lin charge_up_V2 = prepV2 OP_charge_V OP_up_Prep ; -- guess-p-verb
lin charge_with_V3 = variants {} ; -- guess-p-verb
lin charger_N = mkN "充电器" ;
lin chariot_N = mkN "雙輪戰車" | mkN "双轮战车" ; -- status=guess -- status=guess
lin charisma_N = mkN "人格魅力" | {-HSK-} mkN "魅力" ;
lin charismatic_A = mkA "超凡魅力" ;
lin charitable_A = mkA "慈善" ;
lin charity_N = mkN "慈善机构" ;
lin charlatan_N = mkN "江湖医生" ;
lin charles_PN = foreignPN "Charles" ; -- comment=src=eng status=guess
lin charlie_PN = foreignPN "Charlie" ; -- comment=src=eng status=guess
lin charlotte_PN = mkPN "夏洛特" ; -- comment=src=geonames status=guess
lin charm_N = mkN "魅力" | {-HSK-} mkN "魅力" [] ;
lin charm_V = mkV "吸引" ;
lin charming_A = variants {} ;
lin charnel_house_N = mkN "藏骸所" ; -- open-multilingual-wordnet
lin chart_N = mkN "图表" ;
lin chart_V2 = mkV2 "图表" ;
lin charter_N = mkN "宪章" ;
lin charter_V2 = mkV2 "宪章" | {-HSK-} mkV2 "租" ;
lin charterhouse_N = mkN "一养老院名" | mkN "查特豪斯公学" ; -- open-multilingual-wordnet
lin chartreuse_A = mkA "查特酒色" | mkA "淡黄绿色" ; -- open-multilingual-wordnet
lin charwoman_N = mkN "清潔女工" | mkN "清洁女工" | mkN "家政女工" | mkN "女保洁員" | mkN "女保洁员" | mkN "女清潔工" | mkN "女清洁工" | mkN "打雜女工" | mkN "打杂女工" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin chary_A = mkA "细心" ;
lin charybdis_PN = foreignPN "Charybdis" ; -- comment=src=eng status=guess
lin chas_PN = foreignPN "Chas" ; -- comment=src=eng status=guess
lin chase_N = mkN "追" [] ;
lin chase_V = mkV "追逐" ;
lin chase_V2 = mkV2 "追逐" ;
lin chaser_N = mkN "驱逐舰" ;
lin chassis_N = mkN "底盘" ;
lin chaste_A = mkA "纯洁" ;
lin chasten_V2 = mkV2 "惩罚" ;
lin chastise_V2 = mkV2 "严惩" ;
lin chastity_N = mkN "貞節" | mkN "贞节" | mkN "貞潔" | mkN "贞洁" | mkN "貞操" | mkN "贞操" | mkN "純潔" | mkN "纯洁" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin chasuble_N = mkN "十字褡" ; -- open-multilingual-wordnet
lin chat_N = mkN "聊天""次" ;
lin chat_V = mkV "聊天" | {-HSK-} mkV "谈" ;
lin chatham_PN = foreignPN "Chatham" ; -- comment=src=geonames status=guess
lin chattel_N = mkN "动产" ; -- open-multilingual-wordnet
lin chatter_N = mkN "唠" "次" ;
lin chatterbox_N = mkN "話匣子" | mkN "话匣子" | mkN "喋喋不休者" ; -- status=guess -- status=guess -- status=guess
lin chauffeur_N = mkN "司机" | {-HSK-} mkN "司机" "個" ;
lin chauffeur_V2 = mkV2 "运送" ;
lin chauvinism_N = mkN "沙文主义" ;
lin chauvinist_N = mkN "盲目的愛國者" | mkN "盲目的爱国者" | mkN "沙文主義者" | mkN "沙文主义者" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cheadle_PN = foreignPN "Cheadle" ; -- comment=src=geonames status=guess
lin cheap_A = mkA "便宜" | {-HSK-} mkA "廉价" ;
lin cheapen_V2 = mkV2 "贬低" ;
lin cheat_N = mkN "作弊條" | mkN "作弊条" | mkN "小抄" ; -- status=guess -- status=guess -- status=guess
lin cheat_V = mkV "骗" ;
lin cheat_V2 = mkV2 "骗" ;
lin check_N = mkN "支票" | {-HSK-} mkN "支票" "本" ;
lin check_V = mkV "查" ;
lin check_V2 = mkV2 "查" | {-HSK-} mkV2 "遏制" ;
lin check_back_V = advV OP_check_V OP_back_Adv ; -- guess-p-verb
lin check_by_V2 = prepV2 OP_check_V OP_by_Prep ; -- guess-p-verb
lin check_for_V2 = prepV2 OP_check_V OP_for_Prep ; -- guess-p-verb
lin check_in_V = advV OP_check_V OP_in_Adv ; -- guess-p-verb
lin check_in_V2 = prepV2 OP_check_V OP_in_Prep ; -- guess-p-verb
lin check_into_V2 = prepV2 OP_check_V OP_into_Prep ; -- guess-p-verb
lin check_off_V2 = prepV2 OP_check_V OP_off_Prep ; -- guess-p-verb
lin check_on_V2 = prepV2 OP_check_V OP_on_Prep ; -- guess-p-verb
lin check_out_V = advV OP_check_V OP_out_Adv ; -- guess-p-verb
lin check_out_V2 = prepV2 OP_check_V OP_out_Prep ; -- guess-p-verb
lin check_out_of_V2 = prepV2 (advV OP_check_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin check_over_V2 = prepV2 OP_check_V OP_over_Prep ; -- guess-p-verb
lin check_through_V2 = prepV2 OP_check_V OP_through_Prep ; -- guess-p-verb
lin check_up_on_V2 = prepV2 (advV OP_check_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin check_with_V2 = prepV2 OP_check_V OP_with_Prep ; -- guess-p-verb
lin checkbook_N = mkN "支票簿" "本" ;
lin checkerboard_N = mkN "棋盘" | mkN "西洋棋盘" | mkN "西洋跳棋棋盘" | mkN "西洋跳棋盘" ; -- open-multilingual-wordnet
lin checklist_N = mkN "检查清单" | mkN "检查表" ; -- status=guess -- status=guess
lin checkmate_N = mkN "將死" | mkN "将死" ; -- status=guess -- status=guess
lin checkmate_V2 = mkV2 (mkV "挫敗") | mkV2 (mkV "挫败") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin checkout_N = mkN "结账" ;
lin checkpoint_N = mkN "检查站" ;
lin checkroom_N = mkN "寄存处" | mkN "行李房" | mkN "行李暂存处" ; -- open-multilingual-wordnet
lin checksum_N = mkN "校驗和" | mkN "校验和" | mkN "檢查和" | mkN "检查和" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cheek_N = mkN "脸颊" ;
lin cheekbone_N = mkN "頰骨" | mkN "颊骨" ; -- status=guess -- status=guess
lin cheekpiece_N = mkN "马勒带" ; -- open-multilingual-wordnet
lin cheeky_A = mkA "厚脸皮" ;
lin cheer_N = mkN "欢呼" [] ;
lin cheer_V = mkV "快活起来" ;
lin cheer_V2 = mkV2 "欢呼" ;
lin cheerful_A = mkA "快乐" | {-HSK-} mkA "愉快" ;
lin cheerleader_N = mkN "啦啦队长" "名" ;
lin cheerless_A = mkA "压抑" | mkA "忧郁" | mkA "无精打采" | mkA "沉闷" | mkA "郁闷" | mkA "阴郁" ; -- open-multilingual-wordnet
lin cheers_Interj = mkInterj "干杯" ;
lin cheery_A = mkA "樱桃" ;
lin cheese_N = L.cheese_N ;
lin cheeseburger_N = mkN "起司堡" | mkN "乳酪漢堡" | mkN "乳酪汉堡" ; -- status=guess -- status=guess -- status=guess
lin cheesecake_N = mkN "乳酪蛋糕" | mkN "起士蛋糕" ; -- status=guess -- status=guess
lin cheesecloth_N = mkN "一种粗棉布" | mkN "干酪包布" ; -- open-multilingual-wordnet
lin cheetah_N = mkN "猎豹" ;
lin chef_N = mkN "厨师" ;
lin cheilitis_N = mkN "唇炎" ; -- open-multilingual-wordnet
lin cheilosis_N = mkN "传染性口角炎" ; -- open-multilingual-wordnet
lin chela_N = mkN "螯" | mkN "钳" | mkN "钳爪" ; -- open-multilingual-wordnet
lin chelate_A = mkA "似螯" | mkA "有螯" | mkA "螯形" ; -- open-multilingual-wordnet
lin chelate_N = mkN "螯合物" ; -- open-multilingual-wordnet
lin chelation_N = mkN "螯合作用" ; -- open-multilingual-wordnet
lin cheliceral_A = mkA "前肢" | mkA "螯" ; -- open-multilingual-wordnet
lin chelicerous_A = mkA "有螯角" ; -- open-multilingual-wordnet
lin cheliferous_A = mkA "具螯" | mkA "具钳爪" | mkA "带螯" | mkA "有钳爪" ; -- open-multilingual-wordnet
lin chelmsford_PN = mkPN "切爾姆斯福德" ; -- comment=src=geonames status=guess
lin chelonian_A = mkA "海龟" | mkA "海龟状" | mkA "龟类" ; -- open-multilingual-wordnet
lin chelsea_PN = mkPN ("切尔西" | "切爾西") ; -- comment=src=geonames status=guess
lin cheltenham_PN = mkPN "切爾滕納姆" ; -- comment=src=geonames status=guess
lin chelyabinsk_PN = mkPN "車里雅賓斯克" ; -- comment=src=geonames status=guess
lin chemical_A = mkA "化学" | {-HSK-} mkA "化学药品" ;
lin chemical_N = mkN "化学" ;
lin chemiluminescent_A = mkA "化学发光" ; -- open-multilingual-wordnet
lin chemise_N = mkN "宽松女服" ; -- open-multilingual-wordnet
lin chemisorption_N = mkN "化学吸收作用" ; -- open-multilingual-wordnet
lin chemistFem_N = mkN "化学家" ;
lin chemistMasc_N = mkN "化学家" ;
lin chemistry_N = mkN "化学" ;
lin chemoreceptive_A = mkA "化学感应" ; -- open-multilingual-wordnet
lin chemosis_N = mkN "球结膜水肿" ; -- open-multilingual-wordnet
lin chemosynthesis_N = mkN "化学合成" ; -- open-multilingual-wordnet
lin chemotherapeutic_A = mkA "化学治疗" | mkA "化学疗法" ; -- open-multilingual-wordnet
lin chemotherapy_N = mkN "化學療法" | mkN "化学疗法" | mkN "化療" | mkN "化疗" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin chengchow_PN = foreignPN "Chengchow" ; -- comment=src=eng status=guess
lin chengtu_PN = foreignPN "Chengtu" ; -- comment=src=eng status=guess
lin chenille_N = mkN "绳绒线" ;
lin chepstow_PN = foreignPN "Chepstow" ; -- comment=src=geonames status=guess
lin cheque_N = mkN "支票" "张" | {-HSK-} mkN "支票" "本" ;
lin chequebook_N = mkN "支票簿" | {-mwn-} mkN "支票本" | mkN "空白支票簿" ; -- status=guess -- open-multilingual-wordnet
lin cherish_V2 = mkV2 "爱惜" | mkV2 "爱护" | {-HSK-} mkV2 "珍爱" ;
lin cheroot_N = mkN "方頭雪茄煙" | mkN "方头雪茄烟" | {-mwn-} mkN "雪茄" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cherry_A = mkA "樱桃" ;
lin cherry_N = mkN "樱桃" ;
lin cherrystone_N = mkN "小圆蛤" | mkN "小蛤蜊" ; -- open-multilingual-wordnet
lin chert_N = mkN "燧石" | mkN "角岩" | mkN "黑硅石" ; -- open-multilingual-wordnet
lin cherty_A = mkA "燧石" ; -- open-multilingual-wordnet
lin cherub_N = mkN "小天使" ;
lin chesham_PN = foreignPN "Chesham" ; -- comment=src=geonames status=guess
lin cheshire_PN = foreignPN "Cheshire" ; -- comment=src=geonames status=guess
lin chess_N = mkN "国际象棋" "套" ;
lin chessboard_N = mkN "棋盤" | mkN "棋盘" | {-mwn-} mkN "国际象棋棋盘" | mkN "西洋象棋盘" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin chessman_N = mkN "国际象棋棋子" | mkN "棋子" ; -- open-multilingual-wordnet
lin chest_N = mkN "胸" ;
lin chester_PN = mkPN "切斯特" ; -- comment=src=geonames status=guess
lin chester_le_street_PN = foreignPN "Chester-le-street" ; -- comment=src=eng status=guess
lin chesterfield_PN = foreignPN "Chesterfield" ; -- comment=src=geonames status=guess
lin chestnut_A = mkA "栗色" ; -- open-multilingual-wordnet
lin chestnut_N = mkN "板栗" | mkN "栗子" ; -- status=guess -- status=guess
lin chetrum_N = mkN "切特鲁姆" ; -- open-multilingual-wordnet
lin cheval_glass_N = mkN "穿衣镜" ; -- open-multilingual-wordnet
lin chevrotain_N = mkN "鼷鹿" ; -- open-multilingual-wordnet
lin chew_N = mkN "咀嚼" "次" ;
lin chew_V = mkV "咀嚼" ;
lin chew_V2 = mkV2 "咀嚼" ;
lin chewable_A = mkA "嚼得动" ; -- open-multilingual-wordnet
lin chi_N = mkN "西" | mkN "喜" | mkN "凱" ; -- status=guess -- status=guess -- status=guess
lin chiaroscuro_N = mkN "明暗对照法" ; -- open-multilingual-wordnet
lin chic_A = mkA "别致" ;
lin chicago_PN = mkPN "芝加哥" ;
lin chicanery_N = mkN "狡辩" ;
lin chichester_PN = mkPN "奇切斯特" ; -- comment=src=geonames status=guess
lin chick_N = mkN "雛鳥" | mkN "雏鸟" ; -- status=guess -- status=guess
lin chicken_A = mkA "鸡肉" ;
lin chicken_N = mkN "鸡" "只" ;
lin chicken_out_V = mkV "打退堂鼓" | mkV "放弃" | mkV "退出" | mkV "退却" ; -- open-multilingual-wordnet
lin chickenfeed_N = mkN "零钱" ; -- open-multilingual-wordnet
lin chickenpox_N = mkN "水痘" ; -- status=guess -- open-multilingual-wordnet
lin chickpea_N = mkN "鷹嘴豆" | mkN "鹰嘴豆" ; -- status=guess -- status=guess
lin chicory_N = mkN "菊苣" ; -- status=guess
lin chide_V = mkV "斥责" ;
lin chide_V2 = mkV2 "责骂" ;
lin chief_A = mkA "长" | {-HSK-} mkA "首席" ;
lin chief_N = mkN "长" | {-HSK-} mkN "首席" ;
lin chieftainFem_N = variants {} ; ---- sense to be split
lin chieftainMasc_N = variants {} ; ---- sense to be split
lin chiffonier_N = mkN "五斗橱" | mkN "碗碟柜" | mkN "衣柜" | mkN "食橱" ; -- open-multilingual-wordnet
lin chignon_N = mkN "髮髻" | mkN "发髻" ; -- status=guess -- status=guess
lin chilblain_N = mkN "凍瘡" | mkN "冻疮" | mkN "凍傷" | mkN "冻伤" | mkN "瘃" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin child_N = L.child_N | {-HSK-} mkN "儿童" "個" | mkN "孩子" ;
lin childbearing_A = mkA "分娩" | mkA "生育" ; -- open-multilingual-wordnet
lin childbirth_N = mkN "出生" | mkN "分娩" | mkN "生產" | mkN "生产" | mkN "娩" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin childcare_N = mkN "幼托" | mkN "兒童看護" | mkN "儿童看护" ; -- status=guess -- status=guess -- status=guess
lin childhood_N = mkN "童年" ;
lin childish_A = mkA "幼稚" ;
lin childless_A = mkA "沒有兒女" | mkA "没有儿女" | mkA "無子女" | mkA "无子女" | mkA "無兒無女" | mkA "无儿无女" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin childlessness_N = mkN "无孩子" ; -- open-multilingual-wordnet
lin chile_PN = mkPN "辣椒酱" ;
lin chileanFem_N = variants {} ; ---- sense to be split
lin chileanMasc_N = variants {} ; ---- sense to be split
lin chilean_A = mkA "智利" ;
lin chili_N = mkN "辣椒" | {-HSK-} mkN "椒" ; -- status=guess -- status=guess
lin chill_N = mkN "寒意" ;
lin chill_V = mkV "变冷" ;
lin chill_V2 = mkV2 "冷冻" ;
lin chilly_A = mkA "寒冷" ;
lin chime_N = mkN "钟" | mkN "钟琴" ; -- open-multilingual-wordnet
lin chime_V = mkV "鸣响" ;
lin chime_in_V = mkV "插嘴" | mkV "插话" ; -- open-multilingual-wordnet
lin chimera_N = mkN "喀邁拉" | mkN "喀迈拉" ; -- status=guess -- status=guess
lin chimeric_A = mkA "妄想" | mkA "空想" ; -- open-multilingual-wordnet
lin chimney_N = mkN "烟囱" ;
lin chimneypot_N = mkN "烟囱顶管" ; -- open-multilingual-wordnet
lin chimneystack_N = mkN "总合烟囱" | mkN "高烟囱" ; -- open-multilingual-wordnet
lin chimpanzee_N = mkN "黑猩猩" ;
lin chin_N = mkN "下巴" ;
lin china_N = mkN "瓷器" ;
lin china_PN = mkPN "中国" ;
lin chinaware_N = mkN "瓷制的餐具" ; -- open-multilingual-wordnet
lin chinchilla_N = mkN "毛絲鼠" | mkN "毛丝鼠" | mkN "絨鼠" | mkN "绒鼠" | mkN "龍貓" | mkN "龙猫" | mkN "栗鼠" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin chinchow_PN = foreignPN "Chinchow" ; -- comment=src=eng status=guess
lin chineseFem_N = mkN "中国人" ;
lin chineseMasc_N = mkN "中国人" | {-HSK-} mkN "华裔" ;
lin chinese_A = mkA "中国" ;
lin chino_N = mkN "丝光黄斜纹布" ; -- open-multilingual-wordnet
lin chinoiserie_N = mkN "中国式" ; -- open-multilingual-wordnet
lin chintz_N = mkN "印花棉布" ; -- open-multilingual-wordnet
lin chip_N = mkN "芯片" ;
lin chip_V = mkV "切" ;
lin chipmunk_N = mkN "花栗鼠" | mkN "花鼠" ; -- open-multilingual-wordnet
lin chipolata_N = mkN "直布羅陀腸" ; -- status=guess
lin chippenham_PN = foreignPN "Chippenham" ; -- comment=src=geonames status=guess
lin chipper_A = mkA "快乐" | mkA "快活" | mkA "愉快" | mkA "活泼" ; -- open-multilingual-wordnet
lin chips_N = mkN "土豆片" | mkN "薯片" | mkN "馬鈴薯片" | mkN "马铃薯片" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin chiralgia_N = mkN "鼻痛" ; -- open-multilingual-wordnet
lin chiromantic_A = mkA "相手术" ; -- open-multilingual-wordnet
lin chiropractor_N = mkN "捏積者" | mkN "捏积者" | mkN "脊醫" | mkN "脊医" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin chirp_V = mkV "鳴" | mkV "鸣" | mkV "譟" | mkV "噪" | mkV "唧唧叫" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin chirp_V2 = mkV2 (mkV "鳴") | mkV2 (mkV "鸣") | mkV2 (mkV "譟") | mkV2 (mkV "噪") | mkV2 (mkV "唧唧叫") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin chirpy_A = mkA "快活" ;
lin chisel_N = mkN "鑿子" | mkN "凿子" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin chisel_V2 = mkV2 "雕" ;
lin chiseled_A = mkA "定义明确" | mkA "界限清楚" | mkA "轮廓分明" | mkA "轮廓清晰" ; -- open-multilingual-wordnet
lin chit_N = mkN "芽" ;
lin chitin_N = mkN "几丁质" | mkN "甲壳质" ; -- open-multilingual-wordnet
lin chitinous_A = mkA "壳质" ; -- open-multilingual-wordnet
lin chiton_N = mkN "多板目" | mkN "多板纲" | mkN "多板纲软体动物" | mkN "石鳖" ; -- open-multilingual-wordnet
lin chivalry_N = mkN "義俠" | mkN "义侠" ; -- status=guess -- status=guess
lin chive_N = mkN "細香蔥" | mkN "细香葱" ; -- status=guess -- status=guess
lin chlamydeous_A = mkA "有花被" ; -- open-multilingual-wordnet
lin chlamydia_N = mkN "衣原體" | mkN "衣原体" ; -- status=guess -- status=guess
lin chlamydial_A = mkA "衣原体" ; -- open-multilingual-wordnet
lin chlamys_N = mkN "斗篷的一种" | mkN "短氅" ; -- open-multilingual-wordnet
lin chloasma_N = mkN "褐黄斑" ; -- open-multilingual-wordnet
lin chloe_PN = foreignPN "Chloe" ; -- comment=src=eng status=guess
lin chlorate_N = mkN "氯酸盐" ; -- open-multilingual-wordnet
lin chlorenchyma_N = mkN "绿色组织" ; -- open-multilingual-wordnet
lin chloride_N = mkN "氯化物" "" ;
lin chlorine_N = mkN "氯" ;
lin chlorinity_N = mkN "氯含量" | mkN "水中氯度" ; -- open-multilingual-wordnet
lin chlorite_N = mkN "绿泥石" ; -- open-multilingual-wordnet
lin chlorobenzene_N = mkN "氯苯" ; -- open-multilingual-wordnet
lin chlorofluorocarbon_N = mkN "含氯氟烃" ;
lin chloroform_N = mkN "氯仿" | {-mwn-} mkN "三氯甲烷" ; -- status=guess -- open-multilingual-wordnet
lin chlorophyll_N = mkN "葉綠素" | mkN "叶绿素" ; -- status=guess -- status=guess
lin chlorophyllose_A = mkA "叶绿素" | mkA "含叶绿素" ; -- open-multilingual-wordnet
lin chloropicrin_N = mkN "三氯硝基甲烷" ; -- open-multilingual-wordnet
lin chloroplast_N = mkN "葉綠體" | mkN "叶绿体" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin chloroquine_N = mkN "氯喹" | mkN "氯奎" ; -- open-multilingual-wordnet
lin chlorosis_N = mkN "缺绿病" ; -- open-multilingual-wordnet
lin chlorotic_A = mkA "变色病" | mkA "萎黄病" ; -- open-multilingual-wordnet
lin chock_N = mkN "塞块" | mkN "楔" | mkN "楔子" ; -- open-multilingual-wordnet
lin chocolate_A = mkA "巧克力" | {-HSK-} mkA "巧克力色" | mkA "巧克力色" ; -- status=guess -- status=guess
lin chocolate_N = mkN "巧克力" "" | {-HSK-} mkN "巧克力" "塊" ;
lin choice_A = mkA "精选" | {-HSK-} mkA "选择" ;
lin choice_N = mkN "选择" ;
lin choir_N = mkN "合唱团" ;
lin choke_N = mkN "阻塞门" ; -- open-multilingual-wordnet
lin choke_V = mkV "窒息" ;
lin choke_V2 = mkV2 "呛" | {-HSK-} mkV2 "憋" ;
lin choke_damp_N = mkN "窒息瓦斯" | mkN "窒息空气" ; -- open-multilingual-wordnet
lin choker_N = mkN "項鍊" | mkN "项链" | {-mwn-} mkN "一种高硬领" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin choking_N = mkN "堵车" ;
lin cholangitis_N = mkN "胆管炎" | mkN "胆道炎" ; -- open-multilingual-wordnet
lin cholelithiasis_N = mkN "胆石病" ; -- open-multilingual-wordnet
lin cholera_N = mkN "霍亂" | mkN "霍乱" ; -- status=guess -- status=guess -- status=guess
lin choleraic_A = mkA "类似霍乱" | mkA "霍乱" | mkA "霍乱性" ; -- open-multilingual-wordnet
lin cholesterol_N = mkN "膽固醇" | mkN "胆固醇" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin choline_N = mkN "胆碱" ; -- open-multilingual-wordnet
lin chondrin_N = mkN "软骨素" | mkN "软骨胶" ; -- open-multilingual-wordnet
lin chondritic_A = mkA "球粒状陨石" | mkA "由小粒而成" | mkA "粒状" ; -- open-multilingual-wordnet
lin chondroma_N = mkN "软骨瘤" ; -- open-multilingual-wordnet
lin chondrosarcoma_N = mkN "软骨肉瘤" ; -- open-multilingual-wordnet
lin choose_V2 = mkV2 "举" | mkV2 "取" | {-HSK-} mkV2 "选择" ;
lin choose_VV = mkVV "举" | mkVV "取" | {-HSK-} mkVV "选择" ;
lin choose_up_V = advV (lin V OP_choose_V2) OP_up_Adv ; -- guess-p-verb
lin choose_up_V2 = prepV2 (lin V OP_choose_V2) OP_up_Prep ; -- guess-p-verb
lin chop_N = mkN "砍" "" ;
lin chop_V = mkV "砍" ;
lin chop_V2 = mkV2 "砍" ;
lin chopine_N = mkN "高底鞋" ; -- open-multilingual-wordnet
lin choppiness_N = mkN "恶劣的气候" | mkN "波涛滚滚" ; -- open-multilingual-wordnet
lin choppy_A = mkA "波浪起伏" ;
lin chopstick_N = mkN "筷子" ;
lin chopwell_PN = foreignPN "Chopwell" ; -- comment=src=eng status=guess
lin choragic_A = mkA "合唱团指挥" ; -- open-multilingual-wordnet
lin choral_A = mkA "合唱队" ; -- open-multilingual-wordnet
lin chord_N = mkN "弦" ;
lin chordal_A = mkA "和弦" | mkA "和音" ; -- open-multilingual-wordnet
lin chordate_N = mkN "脊索動物" | mkN "脊索动物" ; -- status=guess -- status=guess
lin chorditis_N = mkN "声带炎" ; -- open-multilingual-wordnet
lin chordophone_N = mkN "弦乐器" ; -- open-multilingual-wordnet
lin chore_N = mkN "苦差事" ;
lin chorea_N = mkN "舞蹈病" ; -- open-multilingual-wordnet
lin choreographer_N = mkN "編舞" | mkN "编舞" | mkN "編導" | mkN "编导" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin choreographic_A = mkA "舞蹈" | mkA "舞蹈术" | mkA "舞蹈艺术" ; -- open-multilingual-wordnet
lin choreography_N = mkN "舞蹈設計" | mkN "舞蹈设计" | mkN "編舞" | mkN "编舞" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin choric_A = mkA "合唱曲" | mkA "合唱歌舞式" ; -- open-multilingual-wordnet
lin choriomeningitis_N = mkN "脉络丛脑膜炎" ; -- open-multilingual-wordnet
lin chorionic_A = mkA "绒毛膜" ; -- open-multilingual-wordnet
lin chorley_PN = foreignPN "Chorley" ; -- comment=src=geonames status=guess
lin chortle_V = mkV "咯咯笑" ;
lin chorus_N = mkN "合唱队" "个" ;
lin chosen_A = variants {} ;
lin chow_N = mkN "食物" | {-mwn-} mkN "中国家犬" | mkN "松狮犬" ; -- status=guess -- open-multilingual-wordnet
lin chowder_N = mkN "羹" ; -- status=guess
lin chris_PN = foreignPN "Chris" ; -- comment=src=eng status=guess
lin chrissie_PN = foreignPN "Chrissie" ; -- comment=src=eng status=guess
lin chrissy_PN = foreignPN "Chrissy" ; -- comment=src=eng status=guess
lin christ_PN = foreignPN "Christ" ; -- comment=src=eng status=guess
lin christchurch_PN = mkPN "克赖斯特彻奇" ; -- comment=src=geonames status=guess
lin christian_A = mkA "基督教" ;
lin christian_N = mkN "基督教教徒" ;
lin christian_PN = foreignPN "Christian" ; -- comment=src=eng status=guess
lin christianly_A = mkA "如基督徒" ; -- open-multilingual-wordnet
lin christina_PN = foreignPN "Christina" ; -- comment=src=eng status=guess
lin christine_PN = foreignPN "Christine" ; -- comment=src=eng status=guess
lin christless_A = mkA "不信奉基督" ; -- open-multilingual-wordnet
lin christlike_A = mkA "像耶稣基督" | mkA "如基督" | mkA "如基督一样" | mkA "如耶稣一样" ; -- open-multilingual-wordnet
lin christmas_PN = foreignPN "Christmas" ; -- comment=src=geonames status=guess
lin christopher_PN = foreignPN "Christopher" ; -- comment=src=geonames status=guess
lin chromate_N = mkN "铬酸盐" | mkN "铬酸酯" ; -- open-multilingual-wordnet
lin chromatic_A = mkA "彩色" ; -- open-multilingual-wordnet
lin chromatinic_A = mkA "染色质" ; -- open-multilingual-wordnet
lin chromatogram_N = mkN "色谱" ; -- open-multilingual-wordnet
lin chromatographic_A = mkA "色谱法" ; -- open-multilingual-wordnet
lin chromatography_N = mkN "层析" | mkN "色谱法" ; -- open-multilingual-wordnet
lin chrome_N = mkN "含铬的染料" ; -- open-multilingual-wordnet
lin chromite_N = mkN "铬铁矿" ; -- open-multilingual-wordnet
lin chromium_N = mkN "鉻" | mkN "铬" ; -- status=guess -- status=guess
lin chromoblastomycosis_N = mkN "产色霉菌病" | mkN "着色芽生菌病" ; -- open-multilingual-wordnet
lin chromogen_N = mkN "发色团" | mkN "生色团" | mkN "色原" | mkN "色母" ; -- open-multilingual-wordnet
lin chromophore_N = mkN "发色团" ; -- open-multilingual-wordnet
lin chromosomal_A = mkA "染色体" ; -- open-multilingual-wordnet
lin chromosome_N = mkN "染色体" ;
lin chronic_A = mkA "慢性" ;
lin chronicle_N = mkN "编年史" "本" ;
lin chronicle_V2 = mkV2 "载入史册" ;
lin chronograph_N = mkN "記時器" | mkN "记时器" | mkN "計時碼表" | mkN "计时码表" | mkN "記時儀" | mkN "记时仪" | mkN "錄時器" | mkN "录时器" | {-mwn-} mkN "记时计" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin chronological_A = {-mwn-} mkA "按年代序" ; -- open-multilingual-wordnet
lin chronometer_N = mkN "時計" | mkN "时计" | {-mwn-} mkN "精密时计" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin chronoscope_N = mkN "千分秒表" | mkN "瞬时计" ; -- open-multilingual-wordnet
lin chrysalis_N = mkN "蛹" ; -- open-multilingual-wordnet
lin chrysanthemum_N = mkN "菊" | mkN "菊花" ; -- status=guess -- status=guess
lin chrysoberyl_N = mkN "金绿宝石" | mkN "金绿玉" ; -- open-multilingual-wordnet
lin chrysolite_N = mkN "贵橄榄石" ; -- open-multilingual-wordnet
lin chrysoprase_N = mkN "绿玉髓" ; -- open-multilingual-wordnet
lin chrysotile_N = mkN "温石棉" "张" ;
lin chuck_N = mkN "卡盘" ; -- open-multilingual-wordnet
lin chuck_V2 = mkV2 "丢弃" ;
lin chuckle_N = mkN "轻笑" ;
lin chuckle_V = mkV "轻笑" ;
lin chuckle_VS = mkVS "暗笑" ;
lin chug_N = mkN "軋軋聲" | mkN "轧轧声" | mkN "吱吱嘎嘎" ; -- status=guess -- status=guess -- status=guess
lin chug_V = mkV "发出嘎嘎声" ;
lin chukker_N = mkN "一局" ; -- open-multilingual-wordnet
lin chum_N = mkN "密友" ;
lin chungking_PN = foreignPN "Chungking" ; -- comment=src=eng status=guess
lin chunk_N = mkN "块" | {-HSK-} mkN "块" [] ;
lin chunky_A = mkA "多团" | mkA "多块" ; -- open-multilingual-wordnet
lin church_N = L.church_N ;
lin churn_N = mkN "搅乳器" ; -- open-multilingual-wordnet
lin churn_V = mkV "搅拌" ;
lin chute_N = mkN "槽" ;
lin chutney_N = mkN "酸辣醬" | mkN "酸辣酱" ; -- status=guess -- status=guess
lin chylaceous_A = mkA "乳糜" | mkA "乳糜性" ; -- open-multilingual-wordnet
lin chyliferous_A = mkA "输送乳糜" ; -- open-multilingual-wordnet
lin chylific_A = mkA "形成乳糜" ; -- open-multilingual-wordnet
lin chylomicron_N = mkN "乳糜微滴" | mkN "乳糜微粒" ; -- open-multilingual-wordnet
lin chyme_N = mkN "半流体的消化物" ; -- open-multilingual-wordnet
lin cicada_N = mkN "蟬" | mkN "蝉" ; -- status=guess -- status=guess
lin cicatrice_N = mkN "伤疤" | mkN "伤痕" | mkN "疤" | mkN "疤痕" ; -- open-multilingual-wordnet
lin cicatrix_N = mkN "伤疤" | mkN "伤痕" | mkN "疤" | mkN "疤痕" ; -- open-multilingual-wordnet
lin cichlid_N = mkN "丽鱼科鱼" | mkN "慈鲷" ; -- open-multilingual-wordnet
lin cider_N = mkN "蘋果酒" | mkN "苹果酒" ; -- status=guess -- status=guess
lin ciderpress_N = mkN "苹果榨汁机" ; -- open-multilingual-wordnet
lin cif_PN = foreignPN "Cif" ; -- comment=src=eng status=guess
lin cigar_N = mkN "雪茄" ;
lin cigarette_N = mkN "香烟" ;
lin cigarillo_N = mkN "小雪茄煙" | mkN "小雪茄烟" | {-mwn-} mkN "小雪茄" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cinch_V2 = mkV2 "紧握" ;
lin cinchona_N = mkN "金鸡纳树" | mkN "黄金鸡纳树" ; -- open-multilingual-wordnet
lin cincinnati_PN = mkPN "辛辛那提" ; -- comment=src=geonames status=guess
lin cinder_N = mkN "火山渣錐" | mkN "火山渣锥" ; -- status=guess -- status=guess
lin cinderford_PN = foreignPN "Cinderford" ; -- comment=src=geonames status=guess
lin cinema_N = mkN "电影院" ;
lin cinematic_A = mkA "影片" ;
lin cinematographer_N = mkN "電影攝影師" | mkN "电影摄影师" ; -- status=guess -- status=guess
lin cinematography_N = mkN "电影艺术" ;
lin cinerary_A = mkA "骨灰" ; -- open-multilingual-wordnet
lin cinnabar_N = mkN "朱砂" | mkN "丹砂" ; -- status=guess -- status=guess
lin cinnamon_N = mkN "肉桂" | mkN "桂皮" ; -- status=guess -- status=guess
lin cinquefoil_N = mkN "五瓣花饰" | mkN "梅花形装饰" ; -- open-multilingual-wordnet
lin circadian_A = mkA "生理节奏" ; -- open-multilingual-wordnet
lin circle_N = mkN "圆" | mkN "圈" ;
lin circle_V = mkV "回" | {-HSK-} mkV "环绕" ;
lin circle_V2 = mkV2 "回" | {-HSK-} mkV2 "环绕" ;
lin circlet_N = mkN "小圈" ; -- open-multilingual-wordnet
lin circuit_N = mkN "线路" ;
lin circuitous_A = mkA "迂曲" ;
lin circuitry_N = mkN "电路图" ; -- open-multilingual-wordnet
lin circular_A = mkA "团" | mkA "圆" ;
lin circular_N = mkN "团" | mkN "圆" ;
lin circulate_V = mkV "流传" | {-HSK-} mkV "流通" ;
lin circulate_V2 = mkV2 "传播" | {-HSK-} mkV2 "流传" ; -- comment="流传" ;
lin circulation_N = mkN "发行量" ;
lin circulative_A = mkA "循环" | mkA "循环性" ; -- open-multilingual-wordnet
lin circulatory_A = mkA "循环" ; -- open-multilingual-wordnet
lin circumcise_V2 = mkV2 (mkV "割包皮") ; -- status=guess, src=wikt
lin circumcision_N = mkN "割禮" | mkN "割礼" | mkN "割包皮" | mkN "包皮手术" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin circumference_N = mkN "周長" | mkN "周长" ; -- status=guess -- status=guess
lin circumflex_N = mkN "抑揚音符" | mkN "抑扬音符" ; -- status=guess -- status=guess
lin circumlocution_N = mkN "赘述" ;
lin circumspect_A = mkA "细心" ;
lin circumstance_N = mkN "形式" "個" | {-HSK-} mkN "环境" ;
lin circumstances_N = mkN "形势" "個" | mkN "情况" "個" | mkN "情景" "個" | mkN "条件" "個" | mkN "环境" "個" | {-mwn-} mkN "个人财政情况" | mkN "境况" | mkN "境遇" ; -- open-multilingual-wordnet
lin circumstantial_A = mkA "间接" ;
lin circumvent_V2 = mkV2 "规避" ;
lin circus_N = mkN "马戏团" ;
lin cirencester_PN = foreignPN "Cirencester" ; -- comment=src=geonames status=guess
lin cirrhosis_N = mkN "肝硬化" | mkN "硬化" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cirrus_N = mkN "卷雲" | mkN "卷云" ; -- status=guess -- status=guess
lin cistern_N = mkN "水槽" ; -- status=guess
lin citadel_N = mkN "城堡" | {-mwn-} mkN "堡垒" | mkN "要塞" ; -- status=guess -- open-multilingual-wordnet
lin citation_N = mkN "引用" ;
lin cite_V2 = mkV2 "举" | {-HSK-} mkV2 "引用" ;
lin citified_A = mkA "城市生活习惯" | mkA "有城市风气" | mkA "都市风" ; -- open-multilingual-wordnet
lin citizenFem_N = mkN "公民" ;
lin citizenMasc_N = mkN "公民" ;
lin citizenship_N = mkN "国籍" ;
lin citric_A = mkA "柠檬酸" ; -- open-multilingual-wordnet
lin citrine_N = mkN "茶晶" | mkN "黄水晶" ; -- open-multilingual-wordnet
lin citrulline_N = mkN "瓜氨酸" ; -- open-multilingual-wordnet
lin citrus_N = mkN "黃龍病" | mkN "黄龙病" ; -- status=guess -- status=guess
lin cittern_N = mkN "七弦琴" | mkN "西特琴" ; -- open-multilingual-wordnet
lin city_N = L.city_N | {-HSK-} mkN "城市" "座" ;
lin cityscape_N = mkN "城市风光画" | mkN "都市风景" ; -- open-multilingual-wordnet
lin civic_A = mkA "公民" ;
lin civics_N = mkN "公民" ;
lin civil_A = mkA "民间" ;
lin civilian_A = mkA "民用" ;
lin civilian_N = mkN "平民" "位" ;
lin civility_N = mkN "文明" ;
lin civilization_N = mkN "文化" "個" | mkN "文明" "個" | {-HSK-} mkN "文明" ;
lin civilize_V2 = mkV2 "变文明" ;
lin civvy_street_PN = foreignPN "Civvy street" ; -- comment=src=eng status=guess
lin clabber_N = mkN "凝乳" ; -- status=guess
lin clack_N = mkN "瓣阀" ; -- open-multilingual-wordnet
lin clackmannon_PN = foreignPN "Clackmannon" ; -- comment=src=eng status=guess
lin clacton_PN = foreignPN "Clacton" ; -- comment=src=eng status=guess
lin clad_V = mkV "给 + 加镀层" ;
lin clad_V2 = mkV2 "穿着" ;
lin cladode_N = mkN "叶状枝" | mkN "扁平的叶状茎" ; -- open-multilingual-wordnet
lin cladogram_N = mkN "进化分枝图" ; -- open-multilingual-wordnet
lin claim_N = mkN "声称" ;
lin claim_V = mkV "声称" ;
lin claim_V2 = mkV2 "声称" ;
lin claim_VS = mkVS "声称" ;
lin claimant_N = mkN "索赔人" ;
lin clairvoyance_N = mkN "透視" | mkN "透视" | mkN "千里眼" ; -- status=guess -- status=guess -- status=guess
lin clam_N = mkN "蚌" | mkN "蛤" | mkN "蛤蜊" | mkN "蜆" | mkN "蚬" | mkN "文蛤" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin clamatorial_A = mkA "京燕" ; -- open-multilingual-wordnet
lin clamber_V = mkV "攀登" ;
lin clammy_A = mkA "湿粘" ;
lin clamp_N = mkN "夹子" | {-HSK-} mkN "夹钳" ;
lin clamp_V = mkV "夹住" ;
lin clamp_V2 = mkV2 (mkV "鉗") | mkV2 (mkV "钳") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin clamshell_N = mkN "蛤壳" ; -- open-multilingual-wordnet
lin clan_N = mkN "集团" ;
lin clandestine_A = mkA "私下" ;
lin clang_V = mkV "铛" ;
lin clank_V = mkV "发叮当声" ;
lin clannish_A = mkA "氏族" ;
lin clap_N = mkN "鼓掌""" ;
lin clap_V = mkV "拍" | mkV "鼓掌" ;
lin clap_V2 = mkV2 "使+拍打" | {-HSK-} mkV2 "拍" | mkV2 "鼓掌" ;
lin clapper_N = mkN "快板" ; -- status=guess
lin clapperboard_N = mkN "場記板" | mkN "场记板" ; -- status=guess -- status=guess
lin claptrap_N = mkN "哗众取宠" "次" ;
lin clare_PN = foreignPN "Clare" ; -- comment=src=geonames status=guess
lin clarification_N = mkN "说明" ;
lin clarify_V = mkV "明确" | {-HSK-} mkV "阐明" ;
lin clarify_V2 = mkV2 "明确" | {-HSK-} mkV2 "澄清" ;
lin clarinet_N = mkN "单簧管" "条" ;
lin clarinetistFem_N = mkN "单簧管演奏家" "位" ;
lin clarinetistMasc_N = mkN "单簧管演奏家" "位" ;
lin clarity_N = mkN "明晰" [] ;
lin clarkston_PN = foreignPN "Clarkston" ; -- comment=src=geonames status=guess
lin claro_N = mkN "克拉洛雪茄烟" ; -- open-multilingual-wordnet
lin clarrie_PN = foreignPN "Clarrie" ; -- comment=src=eng status=guess
lin clash_N = mkN "冲突" ;
lin clash_V = mkV "冲" | {-HSK-} mkV "冲突" ;
lin clash_V2 = mkV2 "冲" ;
lin clasp_N = mkN "扣子" | mkN "鈎環" | mkN "钩环" ; -- status=guess -- status=guess -- status=guess
lin class_N = mkN "班" "個" | mkN "等" | mkN "类" | mkN "课" "堂" | mkN "课程" "堂" | mkN "门" | {-HSK-} mkN "班级" ;
lin class_V2 = mkV2 "分类" ;
lin class_conscious_A = mkA "阶级意识" ;
lin classic_A = mkA "经典" ;
lin classic_N = mkN "经典" "" ;
lin classical_A = mkA "古典" | {-HSK-} mkA "经典" ;
lin classicistic_A = mkA "古典主义" ; -- open-multilingual-wordnet
lin classics_N = mkN "经典" ;
lin classification_N = mkN "分类" ;
lin classificatory_A = mkA "分类" | mkA "类别" ; -- open-multilingual-wordnet
lin classifier_N = mkN "量詞" | mkN "量词" ; -- status=guess -- status=guess
lin classify_V2 = mkV2 "分类" | {-HSK-} mkV2 "别" ;
lin classless_A = mkA "无阶级" ;
lin classmate_N = mkN "同学" | {-HSK-} mkN "同学" "位" ;
lin classroom_N = mkN "教室" "間" | {-HSK-} mkN "课堂" ;
lin classy_A = mkA "优等" ;
lin clatter_V = mkV "发出哗啦声" | mkV "发出碰撞声" | mkV "发哐啷声" | mkV "咔哒地响" | mkV "噼啪响" | mkV "噼啪地响" ; -- open-multilingual-wordnet
lin claud_PN = foreignPN "Claud" ; -- comment=src=eng status=guess
lin claude_PN = foreignPN "Claude" ; -- comment=src=geonames status=guess
lin clausal_A = mkA "子句" ; -- open-multilingual-wordnet
lin clause_N = mkN "条款" ;
lin claustrophobia_N = mkN "幽閉恐懼症" | mkN "幽闭恐惧症" ; -- status=guess -- status=guess
lin claustrophobic_A = mkA "患幽闭恐怖症" ;
lin clavichord_N = mkN "古钢琴" | mkN "翼琴" ; -- open-multilingual-wordnet
lin clavicle_N = mkN "鎖骨" | mkN "锁骨" ; -- status=guess -- status=guess
lin claw_N = mkN "爪" ; -- status=guess
lin clawfoot_N = mkN "弓形趾" | mkN "爪形足" ; -- open-multilingual-wordnet
lin clawhammer_N = mkN "羊角锤" ; -- open-multilingual-wordnet
lin clawlike_A = mkA "爪状" ; -- open-multilingual-wordnet
lin clay_N = mkN "粘土" "块" ;
lin clay_cross_PN = foreignPN "Clay cross" ; -- comment=src=eng status=guess
lin claymore_N = mkN "克莱莫地雷" ; -- open-multilingual-wordnet
lin claystone_N = mkN "粘土岩" ; -- open-multilingual-wordnet
lin clean_A = L.clean_A | {-HSK-} mkA "干净" ;
lin clean_Adv = mkAdv "完全" | {-HSK-} mkAdv "干净" ;
lin clean_N = mkN "干净" | {-HSK-} mkN "清洁" ;
lin clean_V = mkV "打扫" | mkV "擦" | {-HSK-} mkV "清洁" ;
lin clean_V2 = mkV2 "使+干净" | {-HSK-} mkV2 "打扫" | mkV2 "擦" ; -- comment="干净的" ;
lin clean_out_V = advV OP_clean_V OP_out_Adv ; -- guess-p-verb
lin clean_out_V2 = mkV2 "清除" ;
lin clean_up_V = advV OP_clean_V OP_up_Adv ; -- guess-p-verb
lin clean_up_V2 = prepV2 OP_clean_V OP_up_Prep ; -- guess-p-verb
lin cleanable_A = mkA "可弄干净地" | mkA "可扫除干净地" | mkA "能清洁" ; -- open-multilingual-wordnet
lin cleaner_N = mkN "清洁剂" ;
lin cleaners_N = mkN "干洗店" ; -- open-multilingual-wordnet
lin cleaning_N = mkN "清洁" ;
lin cleanliness_N = mkN "清洁" ;
lin cleanly_A = mkA "干净" | mkA "清洁" ; -- open-multilingual-wordnet
lin cleanness_N = mkN "洁白" | mkN "清洁" | mkN "高尚" ; -- open-multilingual-wordnet
lin cleanse_V2 = mkV2 "净化" ;
lin cleanser_N = mkN "清洁工" ;
lin cleansing_A = mkA "净化" | mkA "纯化" ; -- open-multilingual-wordnet
lin clear_A = mkA "亮" | mkA "可见" | mkA "明显" | mkA "明白" | mkA "显然" | mkA "晴" | mkA "清楚" | mkA "白" | {-HSK-} mkA "清晰" ;
lin clear_Adv = mkAdv "亮" | mkAdv "可见" | mkAdv "明显" | mkAdv "明白" | mkAdv "显然" | mkAdv "晴" | mkAdv "清楚" | mkAdv "白" | {-HSK-} mkAdv "完全地" ;
lin clear_N = mkN "亮" | mkN "可见" | mkN "明显" | mkN "明白" | mkN "显然" | mkN "晴" | mkN "清楚" | mkN "白" | {-HSK-} mkN "清除""" ;
lin clear_V = mkV "清除" ;
lin clear_V2 = mkV2 "清除" ;
lin clear_away_V = advV OP_clear_V OP_away_Adv ; -- guess-p-verb
lin clear_away_V2 = mkV2 (advV OP_clear_V OP_away_Adv ) ; -- guess-p-verb
lin clear_off_V = advV OP_clear_V OP_off_Adv ; -- guess-p-verb
lin clear_out_V = advV OP_clear_V OP_out_Adv ; -- guess-p-verb
lin clear_out_V2 = prepV2 OP_clear_V OP_out_Prep ; -- guess-p-verb
lin clear_up_V = advV OP_clear_V OP_up_Adv ; -- guess-p-verb
lin clear_up_V2 = prepV2 OP_clear_V OP_up_Prep ; -- guess-p-verb
lin clearance_N = mkN "净空" [] ;
lin clearing_N = mkN "清除" ;
lin clearway_N = mkN "超速道路" ; -- open-multilingual-wordnet
lin cleat_N = mkN "加强角片" ; -- open-multilingual-wordnet
lin cleator_moor_PN = foreignPN "Cleator moor" ; -- comment=src=eng status=guess
lin cleavable_A = mkA "切得开" | mkA "劈得开" | mkA "可分裂" ; -- open-multilingual-wordnet
lin cleavage_N = mkN "卵裂" | {-mwn-} mkN "分裂" | mkN "劈开" | mkN "裂开" ; -- status=guess -- open-multilingual-wordnet
lin cleaver_N = mkN "菜刀" | mkN "砍肉刀" | {-mwn-} mkN "切肉刀" | mkN "切肉大刀" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cleethorpes_PN = foreignPN "Cleethorpes" ; -- comment=src=geonames status=guess
lin clef_N = mkN "谱号" ; -- status=guess
lin cleft_A = mkA "分开" | mkA "切开" | mkA "劈开" ; -- open-multilingual-wordnet
lin cleft_N = mkN "裂縫" | mkN "裂缝" | {-mwn-} mkN "缝隙" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cleistogamous_A = mkA "闭花受精" | mkA "闭花受胎" ; -- open-multilingual-wordnet
lin clem_PN = foreignPN "Clem" ; -- comment=src=eng status=guess
lin clemency_N = mkN "仁慈" | mkN "宽厚" | mkN "宽恕" | mkN "慈悲" ; -- open-multilingual-wordnet
lin clement_PN = foreignPN "Clement" ; -- comment=src=eng status=guess
lin clementine_N = mkN "小柑橘" ; -- status=guess
lin clench_V2 = mkV2 (mkV "咬緊") | mkV2 (mkV "咬紧") | mkV2 (mkV "攥緊") | mkV2 (mkV "攥紧") | mkV2 (mkV "握緊") | mkV2 (mkV "握紧") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin clerestory_N = mkN "天窗" | mkN "通风窗" | mkN "高侧窗" | mkN "高窗" ; -- open-multilingual-wordnet
lin clergy_N = mkN "教士" "位" ;
lin clergyman_N = mkN "牧师" ;
lin cleric_N = mkN "牧师" "位" ;
lin clerical_A = mkA "牧师" ;
lin clerihew_N = mkN "克萊里休詩" ; -- status=guess
lin clerk_N = mkN "书记" ;
lin clerk_V = mkV "当办事员" | mkV "当职员" ; -- open-multilingual-wordnet
lin clermont_ferrand_PN = foreignPN "Clermont-ferrand" ; -- comment=src=eng status=guess
lin clevedon_PN = foreignPN "Clevedon" ; -- comment=src=geonames status=guess
lin cleveland_PN = mkPN "克里夫蘭" ; -- comment=src=geonames status=guess
lin clever_A = L.clever_A | {-HSK-} mkA "巧妙" | mkA "快" | mkA "聪明" | {-HSK-} mkA "乖" | mkA "伶俐" ;
lin clevis_N = mkN "U形钩" | mkN "马蹄钩" ; -- open-multilingual-wordnet
lin clew_N = mkN "线索" ; -- open-multilingual-wordnet
lin click_N = mkN "单击" ;
lin click_V = mkV "點擊" | mkV "点击" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin client_N = mkN "客人" "位" | mkN "顾客" "位" | {-HSK-} mkN "客户" ;
lin clientage_N = mkN "委托关系" ; -- open-multilingual-wordnet
lin clientele_N = mkN "客户" ;
lin cliff_N = mkN "悬崖" ;
lin cliff_PN = foreignPN "Cliff" ; -- comment=src=eng status=guess
lin clifford_PN = foreignPN "Clifford" ; -- comment=src=geonames status=guess
lin climactic_A = mkA "高潮" ; -- open-multilingual-wordnet
lin climate_N = mkN "气候" | {-HSK-} mkN "气候" "種" ;
lin climatic_A = mkA "气候" ;
lin climatologist_N = mkN "氣候學家" | mkN "气候学家" ; -- status=guess -- status=guess
lin climatology_N = mkN "氣候學" | mkN "气候学" ; -- status=guess -- status=guess
lin climax_N = mkN "高潮" ; -- status=guess
lin climb_N = mkN "爬" [] ;
lin climb_V = mkV "上" | {-HSK-} mkV "爬" ;
lin climb_V2 = mkV2 "上" | {-HSK-} mkV2 "爬" ;
lin climb_down_V = mkV "飞落" ; -- open-multilingual-wordnet
lin climber_N = mkN "登山者" "名" ;
lin clime_N = mkN "气候" | mkN "风土" ; -- open-multilingual-wordnet
lin clinch_V = mkV "确定" | {-HSK-} mkV "紧抓" ;
lin clinch_V2 = mkV2 "再胜" | {-HSK-} mkV2 "确定" ;
lin clincher_N = mkN "紧钳" ; -- open-multilingual-wordnet
lin cling_V = mkV "保鲜" ;
lin clingfish_N = mkN "喉盘鱼" ; -- open-multilingual-wordnet
lin clinic_N = mkN "诊所" ;
lin clinical_A = mkA "临床" ;
lin clinker_N = mkN "炼砖" "块" ;
lin clinocephaly_N = mkN "凹顶头" | mkN "鞍形头" ; -- open-multilingual-wordnet
lin clinodactyly_N = mkN "先天性趾侧弯" | mkN "手指弯斜" ; -- open-multilingual-wordnet
lin clinometer_N = mkN "倾斜计" | mkN "测斜仪" ; -- open-multilingual-wordnet
lin clip_N = mkN "回形针" | {-HSK-} mkN "夹子" ;
lin clip_V2 = mkV2 "夹" ;
lin clipboard_N = mkN "剪貼板" | mkN "剪贴板" | mkN "剪貼簿" | mkN "剪贴簿" | {-mwn-} mkN "写字夹板" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin clipper_N = mkN "大剪刀" ; -- open-multilingual-wordnet
lin clipping_N = mkN "剪报" ;
lin clique_N = mkN "派" | {-mwn-} mkN "一帮人" | mkN "小集团" ; -- open-multilingual-wordnet
lin clitheroe_PN = foreignPN "Clitheroe" ; -- comment=src=geonames status=guess
lin clitoris_N = mkN "陰蒂" | mkN "阴蒂" | mkN "陰核" | mkN "阴核" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin clive_PN = foreignPN "Clive" ; -- comment=src=geonames status=guess
lin cloaca_N = mkN "泄殖腔" ; -- status=guess
lin cloak_N = mkN "披风" ;
lin cloak_V2 = mkV2 "遮掩" ;
lin cloakroom_N = mkN "衣帽间" ; -- open-multilingual-wordnet
lin clobber_V2 = mkV2 "击倒" ;
lin cloche_N = mkN "钟形女帽" ; -- open-multilingual-wordnet
lin clock_N = mkN "时钟" | {-HSK-} mkN "钟" ;
lin clock_V = mkV "时钟" ;
lin clock_V2 = mkV2 "计时" ;
lin clockwise_A = mkA "顺时针方向" | mkA "顺时钟方向" ; -- open-multilingual-wordnet
lin clockwise_Adv = mkAdv "順時針" | mkAdv "顺时针" ; -- status=guess -- status=guess
lin clockwork_N = mkN "发条装置" | mkN "钟表机械" ; -- open-multilingual-wordnet
lin cloddish_A = mkA "呆笨" | mkA "土头土脑" | mkA "愚笨" | mkA "愚蠢" | mkA "愚钝" | mkA "笨拙" | mkA "粗鲁" ; -- open-multilingual-wordnet
lin clodhopper_N = mkN "笨重的鞋子" ; -- open-multilingual-wordnet
lin clog_V = mkV "堵塞" ;
lin cloisonne_N = mkN "景泰藍瓷器" ; -- status=guess
lin cloister_N = mkN "迴廊" | mkN "回廊" ; -- status=guess -- status=guess
lin clomipramine_N = mkN "克罗米普拉明" | mkN "氯丙咪嗪" ; -- open-multilingual-wordnet
lin clonal_A = mkA "无性系" | mkA "无性繁殖系" | mkA "纯系" ; -- open-multilingual-wordnet
lin clone_N = mkN "克隆" ;
lin clone_V2 = mkV2 "克隆" | {-HSK-} mkV2 "复制" ;
lin clonic_A = mkA "抽筋" | mkA "阵挛" ; -- open-multilingual-wordnet
lin cloning_N = mkN "克隆" | mkN "複製" | mkN "复制" ; -- status=guess -- status=guess -- status=guess
lin clonus_N = mkN "抽筋" | mkN "抽筋痉挛" | mkN "阵挛" ; -- open-multilingual-wordnet
lin close_A = mkA "密切" | mkA "深" | {-HSK-} mkA "封闭" ;
lin close_Adv = mkAdv "关闭" | {-HSK-} mkAdv "密切" | mkAdv "深" ;
lin close_N = mkN "关闭" | {-HSK-} mkN "密切" | mkN "深" ;
lin close_V = mkV "关" | {-HSK-} mkV "关闭" | mkV "结束" ;
lin close_V2 = L.close_V2 | {-HSK-} mkV2 "关" | mkV2 "关闭" | mkV2 "结束" ;
lin close_down_V = advV OP_close_V OP_down_Adv ; -- guess-p-verb
lin close_down_V2 = prepV2 OP_close_V OP_down_Prep ; -- guess-p-verb
lin close_in_V = advV OP_close_V OP_in_Adv ; -- guess-p-verb
lin close_in_on_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin close_in_upon_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_upon_Prep ; -- guess-p-verb
lin close_off_V2 = prepV2 OP_close_V OP_off_Prep ; -- guess-p-verb
lin close_on_V2 = prepV2 OP_close_V OP_on_Prep ; -- guess-p-verb
lin close_out_V2 = prepV2 OP_close_V OP_out_Prep ; -- guess-p-verb
lin close_to_Prep = mkPrep "濒临" ;
lin close_up_V = advV OP_close_V OP_up_Adv ; -- guess-p-verb
lin close_up_V2 = prepV2 OP_close_V OP_up_Prep ; -- guess-p-verb
lin closed_A = variants {} ;
lin closeness_N = mkN "亲密" ;
lin closet_N = mkN "壁橱" ;
lin close_up_N = mkN "特写镜头" ; -- open-multilingual-wordnet
lin closing_N = mkN "關閉時間" | mkN "关闭时间" ; -- status=guess -- status=guess
lin closure_N = mkN "关闭" ;
lin clot_N = mkN "凝块" ;
lin clot_V = mkV "結塊" | mkV "结块" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin clot_V2 = mkV2 (mkV "結塊") | mkV2 (mkV "结块") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin cloth_N = mkN "布" ;
lin clothe_V2 = mkV2 "穿暖" ;
lin clothes_N = {-HSK-} mkN "服装" "身" | mkN "衣服" "件" | {-HSK-} mkN "衣裳" ;
lin clothesbrush_N = mkN "衣刷" ; -- open-multilingual-wordnet
lin clotheshorse_N = mkN "晾衣架" | {-mwn-} mkN "晒衣架" ; -- status=guess -- open-multilingual-wordnet
lin clothesline_N = mkN "曬衣繩" | mkN "晒衣绳" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin clothes_pin_N = mkN "晒衣夹" | mkN "衣夹" ; -- open-multilingual-wordnet
lin clothier_N = mkN "呢绒商" ;
lin clothing_N = mkN "服装" "件" | {-HSK-} mkN "服装" "身" | mkN "装" ;
lin cloud_N = L.cloud_N | {-HSK-} mkN "云" "朵" ;
lin cloud_V = mkV "乌云密布" ;
lin cloud_V2 = mkV2 "以云遮敝" ;
lin clouding_N = mkN "暗晦" | mkN "湿润" ; -- open-multilingual-wordnet
lin cloudy_A = mkA "多云" | {-HSK-} mkA "阴" ;
lin clout_N = mkN "影响力" ;
lin clove_N = mkN "丁香" ; -- status=guess
lin clove_hitch_N = mkN "丁香结" | mkN "卷结" | mkN "酒瓶结" ; -- open-multilingual-wordnet
lin cloven_A = mkA "偶蹄" | mkA "分趾" | mkA "分趾蹄" ; -- open-multilingual-wordnet
lin clover_N = mkN "三葉草" | mkN "三叶草" | mkN "苜" ; -- status=guess -- status=guess -- status=guess
lin cloverleaf_N = mkN "四叶式交叉" | mkN "苜蓿叶式立体交叉路口" ; -- open-multilingual-wordnet
lin clown_N = mkN "丑" | {-HSK-} mkN "小丑" "个" ;
lin clowne_PN = foreignPN "Clowne" ; -- comment=src=geonames status=guess
lin cloze_A = mkA "填充测验法" | mkA "完形填充" | mkA "完形填空" ; -- open-multilingual-wordnet
lin club_1_N = mkN "俱乐部" ;
lin club_2_N = mkN "俱乐部" ;
lin club_N = mkN "俱乐部" ;
lin club_V = mkV "用棍棒打" ;
lin club_V2 = mkV2 "筹集" ;
lin clubbable_A = mkA "爱好交际" ; -- open-multilingual-wordnet
lin clubbish_A = mkA "爱交际" ; -- open-multilingual-wordnet
lin clubfoot_N = mkN "内弯脚" | mkN "弯曲脚" ; -- open-multilingual-wordnet
lin club_footed_A = mkA "畸足" ; -- open-multilingual-wordnet
lin clubhouse_N = mkN "会所" | mkN "俱乐部会所" ; -- open-multilingual-wordnet
lin clubroom_N = mkN "俱乐部聚会室" ; -- open-multilingual-wordnet
lin clue_N = mkN "线索" ;
lin clueless_A = mkA "无知" ; -- status=guess
lin clumber_N = mkN "克伦伯猎獚" ; -- open-multilingual-wordnet
lin clump_N = mkN "丛" ;
lin clumsy_A = mkA "笨" | {-HSK-} mkA "笨拙" ;
lin clunk_V = mkV "使发砰声" | mkV "发出沉闷声" | mkV "发得得声" | mkV "砰砰作响" ; -- open-multilingual-wordnet
lin cluster_N = mkN "簇" ;
lin cluster_V2 = mkV2 "群居" ;
lin clutch_N = mkN "离合器" ;
lin clutch_V = mkV "抓住" ;
lin clutch_V2 = mkV2 "抓住" ;
lin clutter_N = mkN "杂波" ;
lin clutter_V2 = mkV2 "杂波" ;
lin clwyd_PN = foreignPN "Clwyd" ; -- comment=src=eng status=guess
lin clydach_PN = foreignPN "Clydach" ; -- comment=src=geonames status=guess
lin clydebank_PN = foreignPN "Clydebank" ; -- comment=src=geonames status=guess
lin cm_N = mkN "厘米" ;
lin co_N = mkN "合作" ;
lin co_edit_V2 = mkV2 "一氧化碳" ;
lin co_found_V2 = mkV2 "共同创立" ;
lin co_manage_V2 = mkV2 "共同管理" ;
lin co_sponsor_V2 = mkV2 "更改命令" ;
lin coach_1_N = variants {} ;
lin coach_2_N = variants {} ;
lin coach_3_N = variants {} ;
lin coach_N = mkN "教练" ;
lin coach_V = mkV "指导" | {-HSK-} mkV "辅导" ;
lin coach_V2 = mkV2 "使+接受训练" | {-HSK-} mkV2 "指导" | mkV2 "辅导" ;
lin coachman_N = mkN "馬車夫" | mkN "马车夫" ; -- status=guess -- status=guess
lin coagulable_A = mkA "可凝结" ; -- status=guess
lin coagulase_N = mkN "凝固酵素" | mkN "凝固酶" ; -- open-multilingual-wordnet
lin coagulate_V = mkV "凝結" | mkV "凝结" | mkV "凝固" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin coagulate_V2 = mkV2 (mkV "凝結") | mkV2 (mkV "凝结") | mkV2 (mkV "凝固") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin coagulation_N = mkN "凝化" | mkN "凝固" | mkN "凝结" ; -- open-multilingual-wordnet
lin coal_N = mkN "煤" | {-HSK-} mkN "煤炭" ;
lin coalbin_N = mkN "煤仓" | mkN "煤库" ; -- open-multilingual-wordnet
lin coalition_N = mkN "联盟" ;
lin coalpit_N = mkN "煤坑" | mkN "煤矿" ; -- open-multilingual-wordnet
lin coalville_PN = mkPN "科维尔" ; -- comment=src=geonames status=guess
lin coaming_N = mkN "舱口栏板" ; -- open-multilingual-wordnet
lin coarse_A = mkA "粗糙" ;
lin coast_N = mkN "岸" "個" | {-HSK-} mkN "海岸" [] ;
lin coast_V = mkV "滑行" ;
lin coastal_A = mkA "海岸" ;
lin coaster_N = mkN "过山车" ;
lin coastguard_N = mkN "海岸警衛隊" | mkN "海岸警卫队" | mkN "海岸警備隊" | mkN "海岸警备队" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin coastline_N = mkN "海岸线" "条" ;
lin coat_N = L.coat_N ;
lin coat_V2 = mkV2 "覆盖" ;
lin coatbridge_PN = foreignPN "Coatbridge" ; -- comment=src=geonames status=guess
lin coating_N = mkN "涂层" ;
lin coatrack_N = mkN "帽架" | mkN "衣帽架" ; -- open-multilingual-wordnet
lin coattail_N = mkN "男上衣后摆" ; -- open-multilingual-wordnet
lin coauthorFem_N = variants {} ; ---- sense to be split
lin coauthorMasc_N = variants {} ; ---- sense to be split
lin coax_V = mkV "诱骗" ;
lin coax_V2 = mkV2 (mkV "哄") ; -- status=guess, src=wikt
lin coax_v2 = mkV2 "哄" ;
lin cobalt_N = mkN "鈷" | mkN "钴" ; -- status=guess -- status=guess
lin cobaltite_N = mkN "砷钴矿" | mkN "辉砷钴矿" | mkN "辉钴矿" ; -- open-multilingual-wordnet
lin cobble_V2 = mkV2 "凑齐" ;
lin cobbler_N = mkN "鞋匠" | mkN "皮匠" ; -- status=guess -- status=guess
lin cobblestone_N = mkN "鵝卵石" | mkN "鹅卵石" ; -- status=guess -- status=guess
lin cobham_PN = foreignPN "Cobham" ; -- comment=src=geonames status=guess
lin cobra_N = mkN "眼鏡蛇" | mkN "眼镜蛇" ; -- status=guess -- status=guess
lin cocaine_N = mkN "可卡因" ;
lin cocarboxylase_N = mkN "焦磷酸硫胺素" | mkN "硫胺素焦磷酸酯" ; -- open-multilingual-wordnet
lin coccal_A = mkA "球菌" ; -- open-multilingual-wordnet
lin coccidioidomycosis_N = mkN "球霉菌病" ; -- open-multilingual-wordnet
lin coccidiosis_N = mkN "球虫病" ; -- open-multilingual-wordnet
lin coccoid_A = mkA "球菌样" | mkA "球菌状" ; -- open-multilingual-wordnet
lin coccygeal_A = mkA "尾骨" ; -- open-multilingual-wordnet
lin coccyx_N = mkN "尾骨" ; -- status=guess
lin cochlear_A = mkA "耳蜗" ; -- open-multilingual-wordnet
lin cock_N = mkN "雞巴" | mkN "鸡巴" | mkN "屌 鳥" ; -- status=guess -- status=guess -- status=guess
lin cockade_N = mkN "帽章" | mkN "帽徽" | {-mwn-} mkN "帽上的花结" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cockatoo_N = mkN "凤头鹦鹉" "只" ;
lin cockchafer_N = mkN "金龜子" | mkN "金龟子" ; -- status=guess -- status=guess
lin cockerel_N = mkN "小公雞" | mkN "小公鸡" ; -- status=guess -- status=guess
lin cockermouth_PN = foreignPN "Cockermouth" ; -- comment=src=geonames status=guess
lin cockeyed_A = mkA "喝醉" | mkA "喝醉了" | mkA "喝醉酒" | mkA "烂醉" | mkA "酒醉" | mkA "醉" | mkA "醉醺醺" ; -- open-multilingual-wordnet
lin cockfight_N = mkN "鬥雞" | mkN "斗鸡" ; -- status=guess -- status=guess
lin cockhorse_N = mkN "木马" ; -- open-multilingual-wordnet
lin cockle_N = mkN "泥蚶" ; -- status=guess
lin cocklebur_N = mkN "蒼耳" | mkN "苍耳" | mkN "葹" ; -- status=guess -- status=guess -- status=guess
lin cockleshell_N = mkN "轻舟" ; -- open-multilingual-wordnet
lin cockloft_N = mkN "阁楼" | mkN "顶楼" ; -- open-multilingual-wordnet
lin cockpit_N = mkN "驾驶员座舱" ;
lin cockroach_N = mkN "蟑螂" "只" ;
lin cocktail_N = mkN "鸡尾酒" ;
lin cocky_A = mkA "自大" ;
lin cocoa_N = mkN "可可" ;
lin coconut_N = mkN "椰子" ;
lin cocoon_N = mkN "繭" | mkN "茧" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cocotte_N = mkN "妓女" ;
lin cod_N = mkN "鳕" ;
lin cod_PN = foreignPN "Cod" ; -- comment=src=eng status=guess
lin cod_liver_oil_N = mkN "鱼肝油" ; -- open-multilingual-wordnet
lin coddle_V2 = mkV2 "宠爱" ;
lin code_N = mkN "密码" | {-HSK-} mkN "法规" "条" ;
lin code_V2 = mkV2 "编码" ;
lin codeine_N = mkN "可待因" ; -- status=guess -- open-multilingual-wordnet
lin codification_N = mkN "法典编纂" "本" ;
lin codify_V2 = mkV2 "编纂" ;
lin codling_N = mkN "幼鳕" ; -- open-multilingual-wordnet
lin codon_N = mkN "密码子" ; -- open-multilingual-wordnet
lin codpiece_N = mkN "裤褶" ;
lin codsall_PN = foreignPN "Codsall" ; -- comment=src=geonames status=guess
lin coefficient_N = mkN "係數" | mkN "系数" | {-mwn-} mkN "率" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin coelacanth_N = mkN "空棘魚" ; -- status=guess
lin coeliac_A = mkA "腹" | mkA "腹腔" ; -- open-multilingual-wordnet
lin coelostat_N = mkN "定天镜" | mkN "定星镜" ; -- open-multilingual-wordnet
lin coenzyme_N = mkN "辅酶" ; -- open-multilingual-wordnet
lin coerce_V2 = mkV2 "要挟" ;
lin coercion_N = mkN "强迫" ;
lin coetaneous_A = mkA "同时代" | mkA "同时期" ; -- open-multilingual-wordnet
lin coeval_A = mkA "同时代" | mkA "同时期" ; -- open-multilingual-wordnet
lin coeval_N = mkN "同时代的人" | mkN "同龄人" ; -- open-multilingual-wordnet
lin co_exist_V = mkV "共存" | mkV "和平共处" ; -- open-multilingual-wordnet
lin coexistence_N = mkN "兩立" | mkN "两立" | mkN "共存" ; -- status=guess -- status=guess -- status=guess
lin coexistent_A = mkA "同时共存" ; -- open-multilingual-wordnet
lin coffee_N = mkN "咖啡" ;
lin coffeepot_N = mkN "咖啡壶" ; -- open-multilingual-wordnet
lin coffer_N = mkN "保险箱" ;
lin coffin_N = mkN "棺材" "具" ;
lin cog_N = mkN "链齿" ; -- open-multilingual-wordnet
lin cogged_A = mkA "有齿轮" ; -- open-multilingual-wordnet
lin cogitable_A = mkA "值得考虑" ; -- open-multilingual-wordnet
lin cogitative_A = mkA "思考" | mkA "有思考力" | mkA "沉思" | mkA "深思熟虑" | mkA "考虑周到" | mkA "能思考" ; -- open-multilingual-wordnet
lin cognac_N = mkN "干邑白蘭地" | mkN "干邑白兰地" ; -- status=guess -- status=guess
lin cognate_A = mkA "同源" | {-mwn-} mkA "同宗" | mkA "同族" | mkA "同祖先" | mkA "同祖宗" | mkA "同血统" | mkA "同血缘" | mkA "有亲戚关系" | mkA "血亲" | mkA "血缘" ; -- status=guess -- open-multilingual-wordnet
lin cognate_N = mkN "同源詞" | mkN "同源词" ; -- status=guess -- status=guess
lin cognition_N = mkN "认识" | {-HSK-} mkN "认识""" ;
lin cognitive_A = mkA "认知" ;
lin cohabit_V = mkV "同居" | mkV "姘居" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin cohere_V = mkV "一致" | mkV "附着" ;
lin coherence_N = mkN "一致" ;
lin coherent_A = mkA "连贯" ;
lin cohesion_N = mkN "凝聚" ;
lin cohesive_A = mkA "紧密结合" ;
lin cohomology_N = mkN "上同调" ; -- status=guess
lin cohort_N = mkN "一群" ;
lin coif_N = mkN "修女包头巾" ; -- open-multilingual-wordnet
lin coil_N = mkN "卷" | {-HSK-} mkN "线圈" ;
lin coil_V = mkV "绕" ;
lin coil_V2 = mkV2 "绕" ;
lin coimbatore_PN = mkPN "哥印拜陀" ; -- comment=src=geonames status=guess
lin coin_N = mkN "硬币" | {-HSK-} mkN "钱" "筆" ;
lin coin_V2 = mkV2 "创造" ;
lin coincide_V = mkV "一致" ;
lin coincidence_N = mkN "巧合" ;
lin coincident_A = mkA "一致" ;
lin coincidental_A = mkA "巧合" ;
lin coinsurance_N = mkN "共同保险" ; -- open-multilingual-wordnet
lin coir_N = mkN "椰壳纤维" | mkN "椰子壳的纤维" ; -- open-multilingual-wordnet
lin coital_A = mkA "交媾" | mkA "交配" | mkA "性交" ; -- open-multilingual-wordnet
lin coitus_N = mkN "性交" ; -- status=guess
lin coke_N = mkN "焦炭" "吨" ;
lin col_PN = foreignPN "Col" ; -- comment=src=eng status=guess
lin cola_N = mkN "可乐" "瓶" ;
lin colander_N = mkN "濾器" | mkN "滤器" | mkN "漉鍋" | mkN "漉锅" | mkN "漏勺" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin colchester_PN = mkPN "科尔切斯特" ; -- comment=src=geonames status=guess
lin cold_A = L.cold_A | {-HSK-} mkA "冷" | mkA "感冒" ;
lin cold_N = mkN "冷" | mkN "感冒" "場" | {-HSK-} mkN "寒冷" ;
lin cold_hearted_A = mkA "冷淡" | mkA "冷淡无情" | mkA "冷酷" | mkA "无情" | mkA "铁石心肠" ; -- open-multilingual-wordnet
lin coldness_N = mkN "冷淡" ; -- status=guess
lin coleshill_PN = foreignPN "Coleshill" ; -- comment=src=eng status=guess
lin coleslaw_N = mkN "涼拌捲心菜" | mkN "凉拌卷心菜" ; -- status=guess -- status=guess
lin coleus_N = mkN "五色草" | mkN "彩叶草" | mkN "洋紫苏" | mkN "锦紫苏" ; -- open-multilingual-wordnet
lin colin_PN = foreignPN "Colin" ; -- comment=src=eng status=guess
lin colitis_N = mkN "结肠炎" "次" ;
lin coll_PN = foreignPN "Coll" ; -- comment=src=eng status=guess
lin collaborate_V = mkV "合作" ;
lin collaboration_N = mkN "合作" ;
lin collaborative_A = mkA "共同" ;
lin collaborator_N = mkN "合作者" "名" ;
lin collage_N = mkN "拼贴" ;
lin collagenase_N = mkN "胶原酶" ; -- open-multilingual-wordnet
lin collagenous_A = mkA "产生胶原" | mkA "胶原" ; -- open-multilingual-wordnet
lin collapse_N = mkN "崩溃" | {-HSK-} mkN "塌" ;
lin collapse_V = mkV "崩溃" ;
lin collapse_V2 = mkV2 "崩溃" ;
lin collar_N = mkN "衣领" ;
lin collard_N = mkN "羽衣甘藍" | mkN "羽衣甘蓝" ; -- status=guess -- status=guess -- status=guess
lin collarless_A = mkA "无领" ; -- open-multilingual-wordnet
lin collate_V2 = mkV2 "整理" ;
lin collateral_A = mkA "并行" ;
lin collateral_N = mkN "抵押品" ;
lin colleague_N = mkN "同事" | {-HSK-} mkN "同事" "個" ;
lin collect_A = mkA "由收件人付款" ;
lin collect_Adv = mkAdv "由收件人付款" ;
lin collect_N = mkN "收集" ;
lin collect_V = mkV "捡" | mkV "收" | {-HSK-} mkV "收集" ;
lin collect_V2 = mkV2 "捡" | mkV2 "收" | {-HSK-} mkV2 "收集" ;
lin collectible_N = mkN "收藏品" ; -- open-multilingual-wordnet
lin collection_N = mkN "汇编" ; -- comment=NOT SURE "集子" or "汇编" or "丛书"
lin collective_A = mkA "集体" ;
lin collective_N = mkN "集体" "個" | {-HSK-} mkN "集合名詞" | mkN "集合名词" ; -- status=guess -- status=guess
lin collectivism_N = mkN "集體主義" | mkN "集体主义" ; -- status=guess -- status=guess
lin collector_N = mkN "采集者" ;
lin college_N = mkN "学院" ;
lin collegial_A = mkA "学院" ; -- open-multilingual-wordnet
lin collegiate_A = mkA "大学有关" ;
lin collembolan_N = mkN "跳虫" ; -- open-multilingual-wordnet
lin collet_N = mkN "宝石座" ; -- open-multilingual-wordnet
lin collide_V = mkV "衝突" | mkV "冲突" | mkV "抵觸" | mkV "抵触" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin collie_N = mkN "柯利狗" | mkN "牧羊狗" ; -- open-multilingual-wordnet
lin colliery_N = mkN "煤矿场" ; -- open-multilingual-wordnet
lin collision_N = mkN "碰撞" ;
lin collocation_N = mkN "搭配詞" | mkN "搭配词" ; -- status=guess -- status=guess
lin collodion_N = mkN "柯罗定" | mkN "火棉胶" | mkN "胶棉" ; -- open-multilingual-wordnet
lin colloid_N = mkN "胶体" | mkN "胶质" ; -- open-multilingual-wordnet
lin colloidal_A = mkA "胶体" | mkA "胶状" | mkA "胶质" ; -- open-multilingual-wordnet
lin colloquial_A = mkA "口語" | mkA "口语" ; -- status=guess -- status=guess
lin colloquialism_N = mkN "口語" | mkN "口语" | mkN "俗語" | mkN "俗语" | mkN "白話" | mkN "白话" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin colloquium_N = mkN "座談會" | mkN "座谈会" | mkN "討論會" | mkN "讨论会" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin colloquy_N = mkN "座谈会" ;
lin colne_PN = foreignPN "Colne" ; -- comment=src=geonames status=guess
lin colobus_N = mkN "疣猴" ; -- status=guess -- open-multilingual-wordnet
lin cologne_N = mkN "科隆香水" | mkN "香水" | {-mwn-} mkN "古龙水" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cologne_PN = foreignPN "Cologne" ; -- comment=src=geonames status=guess
lin colombia_PN = mkPN "哥伦比亚共和国" ; -- comment=src=geonames status=guess
lin colombian_A = mkA "哥伦比亚" ;
lin colombo_PN = mkPN ("可倫坡" | "哥伦布") ; -- comment=src=geonames status=guess
lin colon_N = mkN "冒号" ;
lin colonel_N = mkN "上校" ;
lin colonial_A = mkA "殖民" ;
lin colonial_N = mkN "殖民地居民" ;
lin colonialism_N = mkN "殖民主義" | mkN "殖民主义" | {-mwn-} mkN "殖民政策" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin colonialist_N = mkN "殖民主义者" ;
lin colonic_A = mkA "结肠" ; -- open-multilingual-wordnet
lin colonist_N = mkN "殖民者" ;
lin colonization_N = mkN "殖民地化" ; -- status=guess
lin colonnade_N = mkN "柱廊" | mkN "列柱" ; -- status=guess -- status=guess
lin colonoscope_N = mkN "结肠镜" | mkN "结肠镜检查" ; -- open-multilingual-wordnet
lin colony_N = mkN "殖民地" ;
lin colophon_N = mkN "书尾题署" | mkN "出版社商标" | mkN "标记" | mkN "版权页标记" ; -- open-multilingual-wordnet
lin colophony_N = mkN "松香" | mkN "树脂" ; -- open-multilingual-wordnet
lin colorado_PN = foreignPN "Colorado" ; -- comment=src=geonames status=guess
lin coloratura_N = mkN "花腔" ;
lin colorectal_A = mkA "结肠直肠" ; -- open-multilingual-wordnet
lin colorimeter_N = mkN "色度计" ; -- open-multilingual-wordnet
lin colorimetric_A = mkA "比色" | mkA "色度" ; -- open-multilingual-wordnet
lin colossus_N = mkN "巨像" ;
lin colostrum_N = mkN "初乳" ; -- status=guess
lin colour_A = mkA "彩色" | {-HSK-} mkA "青" | mkA "颜色" ;
lin colour_N = mkN "色盲" | {-HSK-} mkN "青" | mkN "颜色" "個" ; -- status=guess
lin colour_V = mkV "颜色" ;
lin colour_V2 = mkV2 "上色" ;
lin colour_V2A = mkV2A "颜色" ;
lin colour_code_V2 = mkV2 "用颜色标记" ;
lin coloured_A = mkA "有色" ; -- status=guess
lin colourful_A = mkA "丰富多彩" ;
lin colourless_A = mkA "無色" | mkA "无色" ; -- status=guess -- status=guess
lin colpitis_N = mkN "阴道炎" ; -- open-multilingual-wordnet
lin colpocele_N = mkN "阴道疝" | mkN "阴道脱垂" ; -- open-multilingual-wordnet
lin colpoxerosis_N = mkN "阴道干燥" ; -- open-multilingual-wordnet
lin colt_N = mkN "駒" | mkN "驹" | mkN "駒子" | mkN "驹子" | mkN "小雄馬" | mkN "小雄马" | {-mwn-} mkN "小雄驹" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin colter_N = mkN "犁刀" ; -- open-multilingual-wordnet
lin coltish_A = mkA "作乐" | mkA "嬉戏" | mkA "嬉戏着" | mkA "欢乐" | mkA "欢闹" | mkA "爱玩耍" | mkA "爱闹着玩" | mkA "闹玩" | mkA "闹着玩" ; -- open-multilingual-wordnet
lin columbia_PN = mkPN "哥伦比亚" ;
lin columbine_N = mkN "耧斗菜" ; -- status=guess
lin columbium_N = mkN "钶" ; -- open-multilingual-wordnet
lin columbus_PN = mkPN "哥伦布" ; -- comment=src=geonames status=guess
lin columella_N = mkN "小柱" ; -- open-multilingual-wordnet
lin column_N = mkN "柱" ;
lin columnea_N = mkN "哥伦纳属植物" ; -- open-multilingual-wordnet
lin columnistFem_N = mkN "专栏作家" ;
lin columnistMasc_N = mkN "专栏作家" ;
lin colwyn_bay_PN = foreignPN "Colwyn bay" ; -- comment=src=eng status=guess
lin coma_N = mkN "昏迷" | mkN "昏睡" ; -- status=guess -- status=guess
lin comatose_A = mkA "不省人事" | mkA "昏睡" | mkA "昏迷" ; -- open-multilingual-wordnet
lin comb_N = mkN "梳子" "把" ;
lin comb_V = mkV "梳理" ;
lin comb_V2 = mkV2 "梳" ;
lin combat_N = mkN "打击" "次" ;
lin combat_V = mkV "打击" ;
lin combat_V2 = mkV2 "与战斗" ;
lin combatant_N = mkN "战士" "名" ;
lin combination_N = mkN "组合" ;
lin combinatorial_A = mkA "组合" ;
lin combine_N = mkN "结合" ;
lin combine_V = mkV "结合" | {-HSK-} mkV "联合" | mkV "融化" ;
lin combine_V2 = mkV2 "结合" | {-HSK-} mkV2 "联合" | mkV2 "融化" | {-HSK-} mkV2 "衔接" ;
lin combine_VV = mkVV "结合" | mkVV "联合" | mkVV "融化" ;
lin combined_A = variants {} ;
lin combining_N = mkN "化合" | mkN "合并" | mkN "组合" ; -- open-multilingual-wordnet
lin combo_N = mkN "組合框" | mkN "组合框" ; -- status=guess -- status=guess
lin combustion_N = mkN "燃烧" | {-HSK-} mkN "燃烧" "次" ;
lin come_V = L.come_V | {-HSK-} mkV "来" ;
lin come_about_V = mkV "产生" ;
lin come_across_V = mkV "遇到" | {-HSK-} mkV "逢" ;
lin come_across_V2 = mkV2 "遇到" ;
lin come_along_V = advV OP_come_V OP_along_Adv ; -- guess-p-verb
lin come_along_with_V2 = prepV2 (advV OP_come_V OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_apart_V = advV OP_come_V OP_apart_Adv ; -- guess-p-verb
lin come_around_V = mkV "周期性发生" ; -- open-multilingual-wordnet
lin come_around_to_V2 = prepV2 (advV OP_come_V OP_around_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_away_V = advV OP_come_V OP_away_Adv ; -- guess-p-verb
lin come_back_V = advV OP_come_V OP_back_Adv ; -- guess-p-verb
lin come_before_V2 = prepV2 OP_come_V OP_before_Prep ; -- guess-p-verb
lin come_by_V = mkV "取得" | mkV "意外取得" | mkV "意外获得" | mkV "获得" ; -- open-multilingual-wordnet
lin come_by_V2 = prepV2 OP_come_V OP_by_Prep ; -- guess-p-verb
lin come_down_V = advV OP_come_V OP_down_Adv ; -- guess-p-verb
lin come_down_on_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin come_down_upon_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_upon_Prep ; -- guess-p-verb
lin come_down_with_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forth_V = advV OP_come_V OP_forth_Adv ; -- guess-p-verb
lin come_forth_with_V2 = prepV2 (advV OP_come_V OP_forth_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forward_V = mkV "出现" | mkV "挺身而出" | mkV "涌现出来" | mkV "走到前面来" ; -- open-multilingual-wordnet
lin come_from_V2 = mkV2 "来自" ;
lin come_in_V = advV OP_come_V OP_in_Adv ; -- guess-p-verb
lin come_in_V2 = prepV2 OP_come_V OP_in_Prep ; -- guess-p-verb
lin come_in_for_V2 = prepV2 (advV OP_come_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin come_into_V2 = mkV2 "进" ;
lin come_into_use_V = variants {} ; -- guess-p-verb
lin come_off_V = mkV "以特定方式发生" | mkV "以特定方式开展" | mkV "以特定方式进行" | mkV "开展" | mkV "进行" ; -- open-multilingual-wordnet
lin come_off_V2 = prepV2 OP_come_V OP_off_Prep ; -- guess-p-verb
lin come_off_it_V = variants {} ; -- guess-p-verb
lin come_on_V = advV OP_come_V OP_on_Adv ; -- guess-p-verb
lin come_out_V = mkV "出" | {-mwn-} mkV "出现" | mkV "露面" ; -- open-multilingual-wordnet
lin come_out_in_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin come_out_of_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin come_out_with_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_over_V = advV OP_come_V OP_over_Adv ; -- guess-p-verb
lin come_over_V2 = prepV2 OP_come_V OP_over_Prep ; -- guess-p-verb
lin come_round_V = mkV "来" ;
lin come_through_V = advV OP_come_V OP_through_Adv ; -- guess-p-verb
lin come_through_with_V2 = prepV2 (advV OP_come_V OP_through_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_to_V = advV OP_come_V OP_to_Adv ; -- guess-p-verb
lin come_to_V2 = prepV2 OP_come_V OP_to_Prep ; -- guess-p-verb
lin come_up_V = mkV "出现" | mkV "呈现" | mkV "形成" ; -- open-multilingual-wordnet
lin come_up_against_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_against_Prep ; -- guess-p-verb
lin come_up_to_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_up_with_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_upon_V2 = prepV2 OP_come_V OP_upon_Prep ; -- guess-p-verb
lin come_with_V2 = prepV2 OP_come_V OP_with_Prep ; -- guess-p-verb
lin comeback_N = mkN "复出" "次" ;
lin comedian_N = mkN "喜剧演员" "位" ;
lin comedienne_N = mkN "喜劇女演員" | mkN "喜剧女演员" ; -- status=guess -- status=guess
lin comedy_N = mkN "喜剧" "出" ;
lin comer_N = mkN "到达者" ; -- open-multilingual-wordnet
lin comestible_N = mkN "食物" ;
lin comet_N = mkN "彗星" ;
lin cometary_A = mkA "彗星" | mkA "彗星似" ; -- open-multilingual-wordnet
lin comfort_N = mkN "安慰" ;
lin comfort_V2 = mkV2 "安慰" ;
lin comfortable_A = mkA "舒服" | {-HSK-} mkA "舒适" ;
lin comforter_N = mkN "棉被" | mkN "棉被" | {-mwn-} mkN "奶嘴" | mkN "橡皮奶头" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin comic_A = mkA "滑稽" ;
lin comic_N = mkN "连环漫画" ;
lin comical_A = mkA "滑稽" ;
lin coming_A = {-HSK-} mkA "未来" ;
lin coming_N = mkN "來臨" | mkN "来临" | {-HSK-} mkN "未来" "個" ; -- status=guess -- status=guess
lin comity_N = mkN "礼让" ; -- comment="友谊" ;
lin comma_N = mkN "逗號" | mkN "逗号" | mkN "逗點" | mkN "逗点" | mkN "頓號" | mkN "顿号" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin command_1_N = variants {} ;
lin command_2_N = variants {} ;
lin command_N = mkN "命令" ;
lin command_V = mkV "命令" | {-HSK-} mkV "指挥" | mkV "挥" ;
lin command_V2 = mkV2 "命令" | {-HSK-} mkV2 "指挥" | mkV2 "挥" ;
lin commandant_N = mkN "司令官" ;
lin commander_N = mkN "指挥官" "位" ;
lin commandment_N = mkN "戒律" ;
lin commando_N = mkN "突击队" "只" ;
lin commelina_N = mkN "鸭跖草属植物" ; -- open-multilingual-wordnet
lin commemorate_V2 = mkV2 "纪念" ;
lin commemoration_N = mkN "纪念" ; -- open-multilingual-wordnet
lin commemorative_A = mkA "纪念" ;
lin commence_V = mkV "开始" ;
lin commence_V2 = mkV2 "开始" ;
lin commencement_N = mkN "开始" ;
lin commend_V2 = mkV2 "称赞" | mkV2 "表扬" | {-HSK-} mkV2 "表彰" ;
lin commendable_A = mkA "值得赞美" ;
lin commendation_N = mkN "赞成" | mkN "赞许" ; -- open-multilingual-wordnet
lin commensal_A = mkA "共生" ; -- open-multilingual-wordnet
lin commensurate_A = mkA "相称" ;
lin commensurateness_N = mkN "一致" ; -- open-multilingual-wordnet
lin comment_N = mkN "评论" ;
lin comment_V = mkV "议论" | {-HSK-} mkV "评论" ;
lin comment_V2 = mkV2 "议论" | {-HSK-} mkV2 "评论" ;
lin comment_VS = mkVS "议论" | {-HSK-} mkVS "评论" ;
lin commentary_N = mkN "评论" ;
lin commentator_N = mkN "解说员" | {-HSK-} mkN "评论员" "位" ;
lin commerce_N = mkN "商业" | {-HSK-} mkN "商务" ;
lin commercial_A = mkA "商业" ;
lin commercial_N = mkN "广告" ;
lin commercialism_N = mkN "交易" | mkN "商业" | mkN "商业主义" | mkN "贸易" ; -- open-multilingual-wordnet
lin commercialize_V2 = mkV2 "使+商业化" ;
lin commiserative_A = mkA "同情" | mkA "怜悯" ; -- open-multilingual-wordnet
lin commission_N = mkN "佣金" ;
lin commission_V2 = mkV2 "佣金" | {-HSK-} mkV2 "委托" ;
lin commission_V2V = mkV2V "佣金" | {-HSK-} mkV2V "委托" ;
lin commissioner_N = mkN "专员" ;
lin commit_V2 = mkV2 "承诺" ;
lin commitment_N = mkN "义务" "項" | {-HSK-} mkN "承诺" ;
lin committee_N = mkN "委员会" ;
lin commode_1_N = mkN "五斗橱" | mkN "碗碟柜" | mkN "衣柜" | mkN "食橱" ; -- open-multilingual-wordnet
lin commode_2_N = mkN "五斗橱" | mkN "碗碟柜" | mkN "衣柜" | mkN "食橱" ; -- open-multilingual-wordnet
lin commodity_N = mkN "商品" | {-HSK-} mkN "商品" "個" ;
lin common_1_A = mkA "共同" ;
lin common_2_A = mkA "共同" ;
lin common_A = mkA "共同" ;
lin common_N = mkN "一般" | mkN "共同" | mkN "平常" | mkN "普遍" | {-HSK-} mkN "常见" [] ;
lin commonage_N = mkN "共用权" ; -- open-multilingual-wordnet
lin commoner_N = mkN "庶民" | mkN "平民" ; -- status=guess -- status=guess
lin commonplace_A = mkA "平凡" ;
lin commonplace_N = mkN "普通事物" ;
lin commons_N = variants {} ;
lin commonwealth_N = mkN "联邦" ;
lin commotion_N = mkN "驱动" ;
lin communal_A = mkA "公社" ;
lin communicate_V = mkV "沟通" | {-HSK-} mkV "转告" ;
lin communicate_V2 = mkV2 "沟通" | {-HSK-} mkV2 "转告" ;
lin communication_N = mkN "交流" | mkN "交际" | {-HSK-} mkN "沟通" ;
lin communications_N = mkN "交通" | mkN "通讯" "個" ;
lin communism_N = mkN "共产主义" [] ;
lin communist_A = mkA "共产" ;
lin communist_N = mkN "共产党党员" ;
lin community_N = mkN "社区" ;
lin commutable_A = mkA "可交换" | mkA "可代替" | mkA "可取代" ; -- open-multilingual-wordnet
lin commutative_A = mkA "交换" ;
lin commutator_N = mkN "整流器" | mkN "电流转换器" ; -- open-multilingual-wordnet
lin commute_V = mkV "交换" | {-HSK-} mkV "改判" ;
lin commute_V2 = mkV2 "交换" | {-HSK-} mkV2 (mkV "通勤") ; -- status=guess, src=wikt
lin commuter_N = mkN "通勤" ;
lin compact_A = mkA "紧凑型" ;
lin compact_N = mkN "紧凑" ;
lin compact_V2 = mkV2 "使+紧密结合" ;
lin companion_N = mkN "伙伴" | {-HSK-} mkN "伴侣" ;
lin companionable_A = mkA "陪伴" ; -- open-multilingual-wordnet
lin companionship_N = mkN "友谊" ;
lin company_1_N = mkN "公司" ;
lin company_2_N = mkN "公司" ;
lin comparability_N = mkN "可比性" "" ;
lin comparable_A = mkA "可比" ;
lin comparative_A = mkA "相当" ;
lin comparative_N = mkN "比较" | mkN "比較" ; -- status=guess -- status=guess
lin compare_N = mkN "比较" | {-HSK-} mkN "比较""次" ;
lin compare_V = mkV "比" | {-HSK-} mkV "比较" ;
lin comparison_N = mkN "对照" ;
lin compartment_N = mkN "隔间" "间" ;
lin compartmentalize_V2 = mkV2 (mkV "劃分") | mkV2 (mkV "划分") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin compass_N = mkN "指南針" | mkN "指南针" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin compassion_N = mkN "同情" | {-HSK-} mkN "爱心" "片" ;
lin compatibility_N = mkN "兼容性" ;
lin compatible_A = mkA "兼容" ;
lin compatriotFem_N = mkN "同胞" ;
lin compatriotMasc_N = mkN "同胞" ;
lin compeer_N = mkN "同行" | mkN "同辈" | mkN "同龄人" | mkN "地位相等的人" ; -- open-multilingual-wordnet
lin compel_V2 = mkV2 "强迫" ;
lin compel_V2V = mkV2V "强迫" ;
lin compel_VV = mkVV "强迫" ;
lin compensate_V = mkV "补偿" | {-HSK-} mkV "赔偿" ;
lin compensate_V2 = mkV2 "补偿" | {-HSK-} mkV2 "赔偿" ;
lin compensation_N = mkN "赔偿金" ;
lin compensatory_A = mkA "补偿" ;
lin compete_V = mkV "竞争" ;
lin competence_N = mkN "权限" | mkN "能力" ;
lin competent_A = mkA "胜任" | {-HSK-} mkA "能干" | mkA "行" ;
lin competition_N = mkN "比赛" "場" | mkN "竞争" ;
lin competitive_A = mkA "竞争" ;
lin competitiveness_N = mkN "竞争力" [] ;
lin competitor_N = mkN "竞争者" ;
lin compilation_N = mkN "编辑" "次" ;
lin compile_V2 = mkV2 "汇编" | {-HSK-} mkV2 "编辑" ;
lin compiler_N = mkN "编辑" | {-HSK-} mkN "编辑器" ;
lin complacency_N = mkN "自满" ;
lin complacent_A = mkA "得意" | {-HSK-} mkA "自满" ;
lin complain_V = mkV "抱怨" ;
lin complain_VS = mkVS "抱怨" ;
lin complainant_N = mkN "原告" ;
lin complaint_N = mkN "意见" "點" | {-HSK-} mkN "抱怨" ;
lin complement_V2 = mkV2 "补充" ;
lin complementary_A = mkA "补充" ;
lin complete_A = mkA "全部" | mkA "完" | mkA "完全" | mkA "完成" | mkA "完整" | mkA "彻底" ;
lin complete_V = mkV "完成" ;
lin complete_V2 = mkV2 "完成" ;
lin completeness_N = mkN "完全" ;
lin completion_N = mkN "完成" [] ;
lin complex_A = mkA "复杂" ;
lin complex_N = mkN "复杂" | {-HSK-} mkN "复杂" [] ;
lin complexion_N = mkN "臉色" | mkN "脸色" | mkN "面色" ; -- status=guess -- status=guess -- status=guess
lin complexity_N = mkN "复杂" ;
lin compliance_N = mkN "符合" [] ;
lin complicate_V2 = mkV2 "使+复杂" ;
lin complicated_A = {-HSK-} mkA "复杂" ;
lin complication_N = mkN "并发症" ;
lin complicity_N = mkN "同谋" ;
lin compliment_N = mkN "恭维" ;
lin compliment_V2 = mkV2 "恭维" | {-HSK-} mkV2 "称赞" ;
lin comply_V = mkV "执行" | {-HSK-} mkV "服从" ;
lin comply_V2 = mkV2 "执行" | {-HSK-} mkV2 "服从" ;
lin component_A = mkA "件" | mkA "成分" | mkA "组成" | mkA "零件" ;
lin component_N = mkN "件" | mkN "成分" "個" | mkN "组成" | mkN "零件" | {-HSK-} mkN "元件" ;
lin comport_V = mkV "为人" | mkV "作出表现" | mkV "表现" ; -- open-multilingual-wordnet
lin comportment_N = mkN "举止" | mkN "态度" | mkN "风度" ; -- open-multilingual-wordnet
lin compose_V = mkV "做" | mkV "构成" ;
lin compose_V2 = mkV2 "做" | mkV2 "构成" ;
lin composer_N = mkN "作家""位" ;
lin composite_A = mkA "综合" ;
lin composite_N = mkN "综合" ;
lin composition_N = mkN "作文" | {-HSK-} mkN "作文" "篇" | mkN "成分" "個" | mkN "结构" "座" ;
lin compositional_A = mkA "成分" ;
lin compost_N = mkN "堆肥" ; -- status=guess -- open-multilingual-wordnet
lin compound_A = mkA "混合" ;
lin compound_N = mkN "复合物" ;
lin compound_V = mkV "化合" ;
lin compound_V2 = mkV2 "复合" ;
lin comprehend_V2 = mkV2 "理解" ;
lin comprehensible_A = mkA "可懂" ; -- status=guess
lin comprehension_N = mkN "理解" ;
lin comprehensive_A = mkA "全面" | {-HSK-} mkA "综合" ;
lin comprehensiveness_N = mkN "全面性" ;
lin compress_N = mkN "冷敷" | mkN "熱敷" | mkN "热敷" | mkN "濕布" | mkN "湿布" | {-mwn-} mkN "敷布" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin compress_V2 = mkV2 "压缩" ;
lin compression_N = mkN "加压" | mkN "压榨" | mkN "压紧" | mkN "压缩" ; -- open-multilingual-wordnet
lin compressor_N = mkN "压缩机" ;
lin comprise_V2 = mkV2 "包括" ;
lin compromise_N = mkN "妥协" ;
lin compromise_V = mkV "妥协" ;
lin compromise_V2 = mkV2 "妥协" ;
lin comptroller_N = mkN "审计长" ;
lin compulsion_N = mkN "义务" [] ;
lin compulsive_A = mkA "强迫" ;
lin compulsory_A = mkA "强制" | {-HSK-} mkA "必须" ;
lin compunction_N = mkN "內疚" | mkN "内疚" ; -- status=guess -- status=guess
lin computation_N = mkN "计算" ;
lin computational_A = mkA "计算" ; -- open-multilingual-wordnet
lin compute_V = mkV "算" | mkV "计算" ;
lin compute_V2 = mkV2 "算" | mkV2 "计算" ;
lin computer_N = L.computer_N | {-HSK-} mkN "电脑" "臺" ;
lin computerization_N = mkN "電腦化" | mkN "电脑化" | mkN "計算機化" | mkN "计算机化" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin computerize_V2 = mkV2 " 将+电脑化" ;
lin computing_N = variants {} ;
lin comrade_N = mkN "伙伴" | {-HSK-} mkN "同志" "位" ;
lin comradely_A = variants {} ;
lin comradely_Adv = adjAdv comradely_A ; -- derived
lin con_N = mkN "騙子" | mkN "骗子" ; -- status=guess -- status=guess
lin con_V2 = mkV2 "精读" ;
lin concatenation_N = mkN "連鎖" | mkN "连锁" | mkN "連結" | mkN "连结" | mkN "相連" | mkN "相连" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin conceal_V = mkV "隐藏" ;
lin conceal_V2 = mkV2 "隐瞒" ;
lin concede_V = mkV "承认" ;
lin concede_V2 = mkV2 "承认" ;
lin concede_VS = mkVS "承认" ;
lin conceit_N = mkN "自负" ;
lin conceited_A = mkA "自大" | mkA "狂妄" | mkA "囂張" | {-HSK-} mkA "骄傲" | {-mwn-} mkA "自命不凡" | mkA "自我中心" | mkA "自我本位" | mkA "自负" | mkA "趾高气扬" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin conceivable_A = mkA "可以想象" ;
lin conceivableness_N = mkN "可想象" ; -- open-multilingual-wordnet
lin conceive_V = mkV "怀孕" ;
lin conceive_V2 = mkV2 "设想" ;
lin concentrate_N = mkN "浓缩" [] ;
lin concentrate_V = mkV "专心" | {-HSK-} mkV "集中" ;
lin concentrate_V2 = mkV2 "专心" | mkV2 "集中" ;
lin concentrated_A = mkA "密集" | {-HSK-} mkA "浓" | mkA "集中" ; -- status=guess
lin concentration_N = mkN "专心" | {-HSK-} mkN "浓度" [] ;
lin concept_N = mkN "概念" | {-HSK-} mkN "概念" "個" | mkN "观念" ;
lin conception_N = mkN "概念" ;
lin conceptual_A = mkA "概念上" ;
lin conceptualistic_A = mkA "概念论者" ; -- open-multilingual-wordnet
lin concern_N = mkN "关照" ;
lin concern_V2 = mkV2 "关" | mkV2 "关系" | {-HSK-} mkV2 "关心" ;
lin concerned_A = {-HSK-} mkA "关心" ;
lin concerning_Prep = variants {} ;
lin concert_N = mkN "演出" "場" | {-HSK-} mkN "音乐会" ;
lin concert_V2 = mkV2 "协调" ;
lin concertina_N = mkN "六角手風琴狀" | mkN "六角手风琴状" | {-mwn-} mkN "六角形手风琴" | mkN "六角手风琴" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin concerto_N = mkN "协奏曲" ;
lin concession_N = mkN "让步" ;
lin conch_N = mkN "海螺" | mkN "海螺壳" | mkN "贝壳" ; -- open-multilingual-wordnet
lin conciliatory_A = mkA "安抚" ;
lin conclave_N = mkN "樞機團" ; -- status=guess
lin conclude_V = mkV "总结" | mkV "结束" | mkV "结论" | {-HSK-} mkV "断定" ;
lin conclude_V2 = mkV2 "总结" | mkV2 "结束" | mkV2 "结论" | {-HSK-} mkV2 "断定" ;
lin conclude_VS = mkVS "总结" | {-HSK-} mkVS "结束" | mkVS "结论" ;
lin conclusion_N = mkN "结论" | {-HSK-} mkN "结论" "個" ;
lin conclusive_A = mkA "决定性" ;
lin concoct_V2 = mkV2 "捏造" ;
lin concoction_N = mkN "混合" ;
lin concomitant_A = mkA "附随" ;
lin concomitant_N = mkN "伴随物" ;
lin concrete_A = mkA "具体" | {-HSK-} mkA "实在" ;
lin concrete_N = mkN "具体" | {-HSK-} mkN "实在" ;
lin concrete_V = mkV "凝結" | mkV "凝结" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin concrete_V2 = mkV2 (mkV "凝結") | mkV2 (mkV "凝结") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin concretistic_A = mkA "具体主义" | mkA "具体主义者" ; -- open-multilingual-wordnet
lin concubine_N = mkN "妾" | mkN "姨太太" ; -- status=guess -- status=guess
lin concur_V = mkV "同意" ;
lin concurrence_N = mkN "同时发生" ;
lin concurrent_A = mkA "并发" ;
lin concussion_N = mkN "震盪" | mkN "震荡" ; -- status=guess -- status=guess
lin condemn_V2 = mkV2 "谴责" ;
lin condemnable_A = mkA "应受指责" | mkA "应受申斥" | mkA "应受谴责" | mkA "应斥责" | mkA "该受责备" ; -- open-multilingual-wordnet
lin condemnation_N = mkN "非难" ;
lin condensation_N = mkN "縮合" | mkN "缩合" | {-mwn-} mkN "冷凝" | mkN "凝结" | mkN "凝缩" | mkN "压缩" | mkN "浓缩" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin condense_V2 = mkV2 "凝结" ;
lin condenser_N = mkN "冷凝器" ;
lin condensing_N = mkN "冷凝" | mkN "凝结" | mkN "凝缩" | mkN "压缩" | mkN "浓缩" ; -- open-multilingual-wordnet
lin condescension_N = mkN "屈尊" "" ;
lin condiment_N = mkN "調料" | mkN "调料" | mkN "調味品" | mkN "调味品" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin condition_1_N = mkN "条件" ;
lin condition_2_N = mkN "条件" ;
lin condition_N = mkN "条件" ;
lin condition_V2 = mkV2 "以+为条件" ;
lin conditional_A = mkA "有条件" ;
lin conditionality_N = mkN "制约性" | mkN "受限制性" ; -- open-multilingual-wordnet
lin conditioner_N = mkN "调节器" ;
lin conditions_N = mkN "天气" | mkN "天气条件" ; -- open-multilingual-wordnet
lin condolence_N = mkN "哀悼" | mkN "吊慰" ; -- status=guess -- status=guess
lin condom_N = mkN "避孕套" | mkN "安全套" | mkN "陰莖套" | mkN "阴茎套" | mkN "衛生套" | mkN "卫生套" | mkN "保險套" | mkN "保险套" | mkN "套兒" | mkN "套儿" | mkN "如意套" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin condominium_N = mkN "公寓" ;
lin condone_V2 = mkV2 "宽恕" ;
lin condor_N = mkN "禿鷹" | mkN "秃鹰" ; -- status=guess -- status=guess
lin conducive_A = mkA "有益" ;
lin conduct_N = mkN "作为" | mkN "行为" | {-HSK-} mkN "行为" [] ;
lin conduct_V = mkV "举办" | mkV "办理" | mkV "指挥" | mkV "挥" | mkV "进行" ;
lin conduct_V2 = mkV2 "举办" | mkV2 "办理" | mkV2 "指挥" | mkV2 "挥" | mkV2 "进行" ;
lin conductivity_N = mkN "傳導率" | mkN "传导率" ; -- status=guess -- status=guess
lin conductor_N = mkN "导体" ;
lin conduit_N = mkN "管道" ;
lin condylar_A = mkA "髁" ; -- open-multilingual-wordnet
lin cone_N = mkN "锥" ;
lin conenose_N = mkN "锥鼻虫" ; -- open-multilingual-wordnet
lin coney_N = mkN "兔" | mkN "兔子" ; -- open-multilingual-wordnet
lin confectionery_N = mkN "糕点店" "个" ;
lin confederate_N = mkN "共犯" | mkN "同谋" ; -- open-multilingual-wordnet
lin confederate_V = mkV "联合" | mkV "联盟" ; -- open-multilingual-wordnet
lin confederation_N = mkN "联盟" ;
lin confer_V = mkV "赋予" ;
lin conference_N = mkN "会议" | {-HSK-} mkN "会议" "場" | mkN "谈判" "個" ;
lin confess_V = mkV "承认" ;
lin confess_V2 = mkV2 "坦白" ;
lin confess_VS = mkVS "承认" ;
lin confession_N = mkN "告解" ;
lin confessional_N = mkN "告解室" | {-mwn-} mkN "忏悔室" ; -- status=guess -- open-multilingual-wordnet
lin confidantFem_N = mkN "知己" ;
lin confidantMasc_N = mkN "知己" ;
lin confide_V = mkV "信赖" ;
lin confide_VS = mkVS "信任" ;
lin confidence_N = mkN "信" | mkN "信心" "個" | mkN "自信" | {-HSK-} mkN "信心" ;
lin confident_A = mkA "信心" ;
lin confidential_A = mkA "机密" ;
lin confidentiality_N = mkN "保密性" "" ;
lin configuration_N = mkN "配置" "种" ;
lin configurational_A = mkA "构形" | mkA "结构" | mkA "配置" ; -- open-multilingual-wordnet
lin configure_V2 = mkV2 "构成" ;
lin confine_N = mkN "界限" ; -- comment="边界" ;
lin confine_V2 = mkV2 "限制" ;
lin confinement_N = mkN "限制" ;
lin confirm_V2 = mkV2 "确定" | mkV2 "确认" | mkV2 "肯定" ;
lin confirm_VS = mkVS "确定" | mkVS "确认" | mkVS "肯定" ;
lin confirmation_N = mkN "确认" ;
lin confiscate_V2 = mkV2 "没收" ;
lin confiscation_N = mkN "征用" ;
lin conflagration_N = mkN "大火" | mkN "燹" | mkN "火災" | mkN "火灾" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin conflict_N = mkN "冲突" | {-HSK-} mkN "战争" "場" ;
lin conflict_V = mkV "冲突" ;
lin confluence_N = mkN "合流" ;
lin conform_V = mkV "符合" ;
lin conform_V2 = mkV2 "符合" ;
lin conformable_A = mkA "一致" | mkA "和谐" | mkA "相调和" | mkA "符合" | mkA "调和" | mkA "适合" ; -- open-multilingual-wordnet
lin conformation_N = mkN "一致" | mkN "符合" | mkN "遵守" | mkN "遵照" ; -- open-multilingual-wordnet
lin conformity_N = mkN "一致" | mkN "符合" | mkN "遵守" | mkN "遵照" ; -- open-multilingual-wordnet
lin confounding_A = mkA "反对" | mkA "混淆" ; -- open-multilingual-wordnet
lin confront_V2 = mkV2 "面对" ;
lin confrontation_N = mkN "对抗" ;
lin confrontational_A = mkA "容易引起冲突" | mkA "对抗" | mkA "挑衅" | mkA "故意寻衅" ; -- open-multilingual-wordnet
lin confuse_V2 = mkV2 "绕" | {-HSK-} mkV2 "迷惑" ;
lin confused_A = mkA "慌张" | mkA "晕" | mkA "糊涂" ;
lin confusing_A = mkA "撲朔迷離" | mkA "扑朔迷离" | mkA "含糊不清" | {-mwn-} mkA "令人困惑" | mkA "令人迷惑" | mkA "使迷惑" | mkA "混乱" | mkA "混淆" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin confusion_N = mkN "混乱" [] ;
lin congealment_N = mkN "冻结" | mkN "凝结" ; -- open-multilingual-wordnet
lin congee_N = mkN "米粥" | mkN "粥" | mkN "稀飯" | mkN "稀饭" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin congenial_A = mkA "意气相投" ;
lin conger_N = mkN "康吉鳗" | mkN "海鳗" | mkN "海鳗之类" ; -- open-multilingual-wordnet
lin congestion_N = mkN "拥挤" ;
lin congestive_A = mkA "充血" ; -- open-multilingual-wordnet
lin congleton_PN = foreignPN "Congleton" ; -- comment=src=geonames status=guess
lin conglomerate_A = mkA "成团" ;
lin conglomerate_N = mkN "砾岩" ;
lin conglomeration_N = mkN "总会" | mkN "總會" ; -- status=guess -- status=guess
lin congo_PN = foreignPN "Congo" ; -- comment=src=eng status=guess
lin congolese_A = mkA "刚果" ;
lin congratulate_V2 = mkV2 "祝贺" ;
lin congratulation_N = mkN "祝賀" | mkN "祝贺" ; -- status=guess -- status=guess
lin congratulatory_A = mkA "值得庆祝" ;
lin congregation_N = mkN "集合" ;
lin congregational_A = mkA "会众" | mkA "集合" ; -- open-multilingual-wordnet
lin congress_N = mkN "国会" ;
lin congressional_A = mkA "国会" ;
lin congressman_N = mkN "国会议员" ;
lin congresswoman_N = mkN "众议员" | mkN "众议院议员" | mkN "国会议员" ; -- open-multilingual-wordnet
lin conic_A = mkA "圆锥" | mkA "圆锥形" | mkA "锥形" ; -- open-multilingual-wordnet
lin conical_A = mkA "圆锥" | mkA "圆锥形" | mkA "锥形" ; -- open-multilingual-wordnet
lin conifer_N = mkN "針葉樹" | mkN "针叶树" | {-mwn-} mkN "球果植物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin conjecture_N = mkN "猜测" ;
lin conjecture_V = mkV "推測" | mkV "推测" | {-mwn-} mkV "使理论化" | mkV "假定" | mkV "假设" | mkV "猜想" | mkV "猜测" | mkV "理论化" ; -- status=guess, src=wikt -- status=guess, src=wikt -- open-multilingual-wordnet
lin conjecture_V2 = mkV2 (mkV "推測") | mkV2 (mkV "推测") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin conjugal_A = mkA "夫妇关系上" | mkA "婚姻" | mkA "结婚" | mkA "配偶" ; -- open-multilingual-wordnet
lin conjugate_V = mkV "使共轭" | mkV "使缀合" ; -- open-multilingual-wordnet
lin conjugation_N = mkN "變位" | mkN "变位" | {-mwn-} mkN "合并" | mkN "统一" | mkN "联合" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin conjunction_N = mkN "连结处""处" ;
lin conjunctiva_N = mkN "結膜" | mkN "结膜" ; -- status=guess -- status=guess
lin conjunctival_A = mkA "结膜" ; -- open-multilingual-wordnet
lin conjunctivitis_N = mkN "結膜炎" | mkN "结膜炎" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin conjure_V = mkV "召唤" ;
lin conjurer_N = mkN "巫師" | mkN "巫师" ; -- status=guess -- status=guess
lin conk_V = mkV "发晕" | mkV "昏倒" | mkV "昏厥" | mkV "昏过去" | mkV "昏迷" | mkV "晕厥" ; -- open-multilingual-wordnet
lin conker_N = mkN "七叶树果实" ; -- open-multilingual-wordnet
lin connah's_quay_PN = foreignPN "Connah's quay" ; -- comment=src=eng status=guess
lin connate_A = mkA "原生" | mkA "合生" ; -- open-multilingual-wordnet
lin connaught_PN = foreignPN "Connaught" ; -- comment=src=eng status=guess
lin connect_V = mkV "接" | mkV "系" | mkV "连" | {-HSK-} mkV "连接" ;
lin connect_V2 = mkV2 "接" | mkV2 "系" | mkV2 "连" | {-HSK-} mkV2 "连结" ;
lin connecticut_PN = mkPN "康涅狄格" ;
lin connection_N = mkN "联系" | {-HSK-} mkN "连接" ;
lin connective_N = mkN "结缔组织" | {-mwn-} mkN "连接物" | mkN "连结物" | mkN "连结者" ; -- status=guess -- open-multilingual-wordnet
lin connectivity_N = mkN "連通性" | mkN "连通性" | mkN "連接性" | mkN "连接性" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin connector_N = mkN "連接器" | mkN "连接器" ; -- status=guess -- status=guess
lin connie_PN = foreignPN "Connie" ; -- comment=src=eng status=guess
lin connoisseur_N = mkN "行家" ;
lin connotation_N = mkN "内涵" ;
lin connote_V2 = mkV2 "意味着" ;
lin connubial_A = mkA "夫妇关系上" | mkA "婚姻" | mkA "结婚" | mkA "配偶" ; -- open-multilingual-wordnet
lin conquer_V2 = mkV2 "克服" | {-HSK-} mkV2 "征服" ;
lin conquest_N = mkN "征服" ; -- comment="战胜" ;
lin cons_PN = foreignPN "Cons" ; -- comment=src=eng status=guess
lin consanguinity_N = mkN "同族" | {-mwn-} mkN "同宗" | mkN "姻亲关系" | mkN "血亲" | mkN "血缘" ; -- status=guess -- open-multilingual-wordnet
lin conscience_N = mkN "良心" ;
lin conscienceless_A = mkA "不受良心引导" | mkA "昧着良心" | mkA "没良心" ; -- open-multilingual-wordnet
lin conscientious_A = mkA "有良心" | {-HSK-} mkA "自觉" | mkA "认真" | mkA "负责" ;
lin conscious_A = mkA "意识到" | {-HSK-} mkA "自觉" ;
lin consciousness_N = mkN "意识" | {-HSK-} mkN "精神" "個" ;
lin conscript_N = mkN "应征士兵" ;
lin conscription_N = mkN "徵兵" | mkN "征兵" | {-mwn-} mkN "应征入伍" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin consecutive_A = mkA "连续" ;
lin consensus_N = mkN "共识" ;
lin consent_N = mkN "同意" ;
lin consent_V = mkV "同意" ;
lin consent_V2V = mkV2V "同意" ;
lin consentaneous_A = mkA "全场一致" | mkA "同意" | mkA "意见一致" | mkA "无异议" ; -- open-multilingual-wordnet
lin consequence_N = mkN "后果" ;
lin consequent_A = mkA "连续" ;
lin conservation_N = mkN "保护" [] ;
lin conservatism_N = mkN "保守主义" ;
lin conservative_1_N = mkN "保守派" ; -- status=guess
lin conservative_2_N = mkN "保守派" ; -- status=guess
lin conservative_A = mkA "保守" ;
lin conservatoire_N = mkN "音樂學校" | mkN "音乐学校" | {-mwn-} mkN "艺术学校" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin conservatory_N = mkN "温室" ;
lin conserve_V2 = mkV2 "保存" | {-HSK-} mkV2 "节约" ;
lin consett_PN = foreignPN "Consett" ; -- comment=src=geonames status=guess
lin consider_V = mkV "以为" | mkV "看" | mkV "考虑" | mkV "认为" ;
lin consider_V2 = mkV2 "以为" | mkV2 "看" | mkV2 "考虑" | mkV2 "认为" | {-HSK-} mkV2 "斟酌" ;
lin consider_V2A = mkV2A "考虑" ;
lin consider_V2V = mkV2V "以为" | mkV2V "看" | mkV2V "考虑" | mkV2V "认为" ;
lin consider_V3 = mkV3 "以为" | mkV3 "看" | mkV3 "考虑" | mkV3 "认为" ;
lin consider_VS = mkVS "以为" | mkVS "看" | mkVS "考虑" | mkVS "认为" ;
lin consider_VV = mkVV "以为" | mkVV "看" | mkVV "考虑" | mkVV "认为" ;
lin considerable_A = mkA "可观" ;
lin considerate_A = mkA "周到" | {-HSK-} mkA "體貼" | mkA "体贴" ; -- status=guess -- status=guess
lin considerateness_N = mkN "体谅" | mkN "体贴" | mkN "关切" | mkN "考虑周到" ; -- open-multilingual-wordnet
lin consideration_N = mkN "考虑" ;
lin considering_Prep = variants {} ;
lin considering_Subj = variants {} ;
lin consign_V2 = mkV2 "交付" ;
lin consignee_N = mkN "收貨人" | mkN "收货人" ; -- status=guess -- status=guess
lin consignor_N = mkN "托運人" | mkN "托运人" | mkN "發貨人" | mkN "发货人" | mkN "委託者" | mkN "委托者" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin consist_V = mkV "包括" ;
lin consistency_N = mkN "一致性" ;
lin consistent_A = mkA "一贯" ;
lin consolation_N = mkN "安慰" ;
lin console_N = mkN "机座" ; -- open-multilingual-wordnet
lin console_V2 = mkV2 "安慰" | {-HSK-} mkV2 "控制" ;
lin consolidate_V = mkV "巩固" ;
lin consolidate_V2 = mkV2 "巩固" ;
lin consolidation_N = mkN "合并" ;
lin consonant_A = mkA "辅音" ;
lin consonant_N = mkN "子音" ; -- status=guess
lin consort_N = mkN "夥伴" ; -- status=guess
lin consort_V = mkV "结合" ;
lin consortium_N = mkN "财团" ;
lin conspecific_N = mkN "同种生物" | mkN "非特异性的" ; -- open-multilingual-wordnet
lin conspicuous_A = mkA "显著" ;
lin conspiracy_N = mkN "阴谋" ;
lin conspirator_N = mkN "同谋" ;
lin conspiratorial_A = mkA "阴谋者" | {-mwn-} mkA "阴谋" ; -- status=guess -- open-multilingual-wordnet
lin conspire_V = mkV "共谋" ;
lin conspire_V2 = mkV2 (mkV "陰謀") | mkV2 (mkV "阴谋") | mkV2 (mkV "密謀") | mkV2 (mkV "密谋") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin conspire_V2V = mkV2V (mkV "陰謀") | mkV2V (mkV "阴谋") | mkV2V (mkV "密謀") | mkV2V (mkV "密谋") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin constable_N = mkN "警官" "名" ;
lin constabulary_N = mkN "公安" | mkN "警" | mkN "警察" | mkN "警方" ; -- open-multilingual-wordnet
lin constance_PN = foreignPN "Constance" ; -- comment=src=eng status=guess
lin constant_A = mkA "不断" ;
lin constant_N = mkN "不断" | {-HSK-} mkN "常量" | mkN "常數" | mkN "常数" | {-mwn-} mkN "常量" | mkN "恒量" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin constellation_N = mkN "星座" ; -- status=guess
lin consternation_N = mkN "惊愕" "" ;
lin constipation_N = mkN "便秘" ; -- status=guess
lin constituency_N = mkN "选民" ;
lin constituent_A = mkA "构成" ;
lin constituent_N = mkN "组分" ;
lin constitute_V2 = mkV2 "构成" ;
lin constitution_N = mkN "宪法" ;
lin constitutional_A = mkA "合法" ;
lin constitutional_N = mkN "保健散步" ;
lin constrain_V2 = mkV2 "压抑" ;
lin constraint_N = mkN "约束" ;
lin constrict_V2 = mkV2 "压缩" ;
lin construct_V2 = mkV2 "建筑" | mkV2 "建设" ;
lin construction_N = mkN "工作" "個" | mkN "工资" "個" | mkN "建设" | {-HSK-} mkN "施工" ;
lin constructive_A = mkA "建设" | {-HSK-} mkA "建设性" ;
lin construe_V2 = mkV2 "诠释" ;
lin construe_V2V = mkV2V "诠释" ;
lin consuetude_N = mkN "习俗" | mkN "尤指具有法律效力的习俗" | mkN "惯例" ; -- open-multilingual-wordnet
lin consul_N = mkN "领事" ;
lin consular_A = mkA "执政官" | mkA "行使领事职权" | mkA "领事" ; -- open-multilingual-wordnet
lin consulate_N = mkN "使館" | mkN "使馆" | mkN "領事館" | mkN "领事馆" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin consult_V = mkV "参考" | mkV "咨询" | mkV "商量" ;
lin consult_V2 = mkV2 "参考" | mkV2 "咨询" | mkV2 "商量" | {-HSK-} mkV2 "请教" ;
lin consultant_N = mkN "顾问" ;
lin consultation_N = mkN "参考" | mkN "咨询" ;
lin consultative_A = mkA "咨询" ; -- open-multilingual-wordnet
lin consume_V = mkV "消费" ;
lin consume_V2 = mkV2 "消耗" | {-HSK-} mkV2 "消费" ;
lin consumer_N = mkN "消费者" ;
lin consumerism_N = mkN "用户至上主义" ; -- open-multilingual-wordnet
lin consummate_A = mkA "至上" ;
lin consummate_V2 = mkV2 "完善" ;
lin consumption_N = mkN "功耗" | mkN "消费" ;
lin cont_PN = foreignPN "Cont" ; -- comment=src=eng status=guess
lin contact_N = mkN "联系" ;
lin contact_V2 = mkV2 "接触" | {-HSK-} mkV2 "联系" ;
lin contagion_N = mkN "傳染" | mkN "传染" ; -- status=guess -- status=guess
lin contagious_A = mkA "传染" | {-HSK-} mkA "感染性" ;
lin contain_V2 = mkV2 "包含" | {-HSK-} mkV2 "把" | mkV2 "控制" ;
lin container_N = mkN "包" "個" | {-HSK-} mkN "集装箱" ;
lin containment_N = mkN "牵制" ;
lin contaminant_N = mkN "污染物" | mkN "致污物" ; -- open-multilingual-wordnet
lin contaminate_V2 = mkV2 "污染" ; -- comment="弄脏" ;
lin contamination_N = mkN "污染" "個" | {-HSK-} mkN "污染" [] ;
lin contaminative_A = mkA "受到污染" | mkA "弄脏了" | mkA "污染" ; -- open-multilingual-wordnet
lin contemplate_V = mkV "沉思" ;
lin contemplate_V2 = mkV2 "沉思" ;
lin contemplate_VS = mkVS "沉思" ;
lin contemplation_N = mkN "沉思" ;
lin contemplative_A = mkA "冥想" | mkA "沉思" | mkA "爱默想" | mkA "盘算" | mkA "细想" | mkA "默想" ; -- open-multilingual-wordnet
lin contemporaneous_A = mkA "同时代" | mkA "同时期" ; -- open-multilingual-wordnet
lin contemporary_A = mkA "现代" ;
lin contemporary_N = mkN "现代" ;
lin contempt_N = mkN "蔑视" "" | {-HSK-} mkN "轻视" ;
lin contemptible_A = mkA "可鄙" ;
lin contemptuous_of_A2 = mkA2 "看不起" ;
lin contend_V = mkV "争论" | {-HSK-} mkV "竞争" ;
lin contend_VS = mkVS "争论" ;
lin contender_N = mkN "争夺者" ;
lin content_A = mkA "内容" ;
lin content_N = mkN "内容" | {-HSK-} mkN "内容" "個" ;
lin content_V2 = mkV2 "满足" ;
lin contentedness_N = mkN "安份" | mkN "满足" ; -- open-multilingual-wordnet
lin contention_N = mkN "争夺" "个" | {-HSK-} mkN "争论" "次" ;
lin contentious_A = mkA "诉讼" ;
lin contents_N = mkN "內容" | mkN "内容" | {-HSK-} mkN "目录" ; -- status=guess -- status=guess
lin contest_N = mkN "竞赛" "场" ;
lin contest_V = mkV "争辩" ;
lin contest_V2 = mkV2 "争取" ;
lin contestant_N = mkN "选手" ;
lin context_N = mkN "上下文" | {-HSK-} mkN "背景" "種" ;
lin contextual_A = mkA "上下文" ; -- open-multilingual-wordnet
lin contiguous_A = mkA "接触" ;
lin continent_N = mkN "大陆" ;
lin continental_A = mkA "陆" ;
lin contingency_N = mkN "万一" | {-HSK-} mkN "偶发事件" "个" ;
lin contingent_A = mkA "不一定" ;
lin contingent_N = mkN "分遣队" ;
lin continual_A = mkA "持续" ;
lin continuation_N = mkN "继续" ;
lin continue_V = mkV "持续" | mkV "接着" | mkV "继续" ;
lin continue_V2 = mkV2 "持续" | mkV2 "接着" | mkV2 "继续" ;
lin continue_VV = mkVV "持续" | mkVV "接着" | mkVV "继续" ;
lin continue_on_V = advV OP_continue_V OP_on_Adv ; -- guess-p-verb
lin continued_A = variants {} ;
lin continuing_A = variants {} ;
lin continuity_N = mkN "连续性" ;
lin continuous_A = mkA "不断" | {-HSK-} mkA "连续" ;
lin contortion_N = mkN "柔身術" | mkN "柔身术" | mkN "軟功" | mkN "软功" | {-mwn-} mkN "使变形" | mkN "使畸形" | mkN "扭弯" | mkN "扭曲" | mkN "扭歪" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin contortionist_N = mkN "柔術演員" | mkN "柔术演员" ; -- status=guess -- status=guess
lin contour_N = mkN "輪廓" | mkN "轮廓" ; -- status=guess -- status=guess
lin contraband_N = mkN "禁品" | mkN "違禁品" | mkN "违禁品" | {-mwn-} mkN "走私货物" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin contrabass_N = mkN "低音提琴" ; -- open-multilingual-wordnet
lin contrabassoon_N = mkN "倍低音巴松笛" | mkN "倍低音管" ; -- open-multilingual-wordnet
lin contraception_N = mkN "避孕" ; -- status=guess
lin contraceptive_A = mkA "避孕" ;
lin contraceptive_N = mkN "避孕用具" ;
lin contract_N = mkN "合同" | {-HSK-} mkN "合同" "個" ;
lin contract_V = mkV "紧缩" ;
lin contract_V2 = mkV2 "订约" ;
lin contract_V2V = mkV2V "合同" ;
lin contraction_N = mkN "收缩" "次" ;
lin contractor_N = mkN "承包商" ;
lin contractual_A = mkA "合同" ;
lin contracture_N = mkN "挛缩" ; -- open-multilingual-wordnet
lin contradict_V2 = mkV2 "反驳 " ;
lin contradiction_N = mkN "反驳" | {-HSK-} mkN "矛盾" "個" ;
lin contradictoriness_N = mkN "对立物" ; -- open-multilingual-wordnet
lin contradictory_A = mkA "反驳" | {-HSK-} mkA "矛盾" ;
lin contradictory_N = mkN "矛盾" "個" | {-mwn-} mkN "矛盾命题" | mkN "矛盾的事物" ; -- open-multilingual-wordnet
lin contralateral_A = mkA "对侧" ; -- open-multilingual-wordnet
lin contralto_N = mkN "女低音" ; -- status=guess
lin contraption_N = mkN "玩意儿" ;
lin contrariety_N = mkN "对立" | mkN "相反" | mkN "矛盾" ; -- open-multilingual-wordnet
lin contrarious_A = mkA "难对付" | mkA "难驾驭" ; -- open-multilingual-wordnet
lin contrary_A = mkA "反而" | mkA "相反" ;
lin contrary_N = mkN "反而" | mkN "相反" ;
lin contrast_N = mkN "对比" | {-HSK-} mkN "对比" "個" | mkN "比较" ;
lin contrast_V = mkV "对比" | {-HSK-} mkV "比" ;
lin contrast_V2 = mkV2 "对比" | {-HSK-} mkV2 "比" ;
lin contravene_V2 = mkV2 "违反" ;
lin contribute_V = mkV "捐" | mkV "贡献" ;
lin contribute_V2 = mkV2 "捐" | mkV2 "贡献" ;
lin contribution_N = mkN "捐" | mkN "贡献" "個" | {-HSK-} mkN "贡献" ;
lin contributor_N = mkN "贡献者" ;
lin contrition_N = mkN "不彻底忏悔" ; -- open-multilingual-wordnet
lin contrivance_N = mkN "玩意兒" | mkN "玩意儿" ; -- status=guess -- status=guess
lin control_N = mkN "控制" | {-HSK-} mkN "管制" ;
lin control_V2 = mkV2 "掌握" | {-HSK-} mkV2 "控制" ;
lin controlled_A = variants {} ;
lin controller_N = mkN "调节器" ;
lin controlling_A = mkA "控制" | mkA "能控制" | mkA "能管理" ; -- open-multilingual-wordnet
lin controversial_A = mkA "争论" ;
lin controversy_N = mkN "争议" | {-HSK-} mkN "争论" "次" ;
lin contumacious_A = mkA "不听命令" ; -- open-multilingual-wordnet
lin contumelious_A = mkA "侮辱" | mkA "侮辱性" | mkA "傲慢" | mkA "傲慢无礼" | mkA "指责" | mkA "辱骂性" ; -- open-multilingual-wordnet
lin contumely_N = mkN "侮辱" | mkN "无礼" | mkN "傲慢" | {-mwn-} mkN "虐待" | mkN "诽谤" | mkN "辱骂" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin contusion_N = mkN "挫傷" | mkN "挫伤" ; -- status=guess -- status=guess
lin conundrum_N = mkN "谜语" | {-HSK-} mkN "难题" ;
lin convalesce_V = mkV "療養" | mkV "疗养" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin convection_N = mkN "對流" | mkN "对流" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin convector_N = mkN "对流式加热机" | mkN "对流式暖房器" ; -- open-multilingual-wordnet
lin convene_V = mkV "召集" ;
lin convene_V2 = mkV2 "召集" ;
lin convenience_N = mkN "方便" ;
lin convenient_A = mkA "便" | mkA "方便" ;
lin convent_N = mkN "修道院" ;
lin conventicle_N = mkN "礼拜堂" ; -- open-multilingual-wordnet
lin convention_N = mkN "传统" "個" | {-HSK-} mkN "惯例" ;
lin conventional_A = mkA "传统" | {-HSK-} mkA "常规" ;
lin converge_V = mkV "聚合" ;
lin conversation_N = mkN "谈话" ;
lin converse_A = mkA "倒" | {-HSK-} mkA "相反" ;
lin converse_N = mkN "倒" ;
lin converse_V = mkV "谈" | {-HSK-} mkV "通話" | mkV "通话" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin conversion_N = mkN "转变" ;
lin convert_N = mkN "皈依者" ;
lin convert_V = mkV "兑换" ;
lin convert_V2 = mkV2 "转换" ;
lin converter_N = mkN "变流器" ;
lin convertibility_N = mkN "可变性" ;
lin convertible_A = mkA "可兑换" ;
lin convertible_N = mkN "可兑换" ;
lin convexity_N = mkN "凸性" ;
lin convey_V2 = mkV2 "传达" | {-HSK-} mkV2 "表达" ;
lin conveyance_N = mkN "输送" ;
lin conveyer_N = mkN "传送带" | mkN "转运带" | mkN "运送器" | mkN "运送者" ; -- open-multilingual-wordnet
lin conveyor_N = mkN "输送带" ;
lin convict_N = mkN "囚犯" | mkN "已決犯" | mkN "已决犯" ; -- status=guess -- status=guess -- status=guess
lin convict_V2 = mkV2 "定罪" ;
lin conviction_N = mkN "信念" ;
lin convince_V2 = mkV2 "说服" ;
lin convince_V2V = mkV2V "说服" ;
lin convincible_A = mkA "可说服" ; -- open-multilingual-wordnet
lin convincing_A = mkA "说服" ;
lin convivial_A = mkA "欢乐" | mkA "活跃" | mkA "随和" ; -- open-multilingual-wordnet
lin convocation_N = mkN "集会" "场" ;
lin convoke_V2 = mkV2 "召开" ;
lin convoluted_A = mkA "复杂" ;
lin convolution_N = mkN "卷积" ;
lin convolvulus_N = mkN "旋花属植物" | mkN "旋花植物" ; -- open-multilingual-wordnet
lin convoy_N = mkN "护航" "次" ;
lin convulsion_N = mkN "震动" ;
lin convulsive_A = mkA "抽搐" | mkA "抽筋" ; -- open-multilingual-wordnet
lin conwy_PN = foreignPN "Conwy" ; -- comment=src=geonames status=guess
lin cony_N = mkN "兔" | mkN "兔子" ; -- open-multilingual-wordnet
lin cook_N = mkN "厨师" ;
lin cook_V = mkV "煮" ;
lin cook_V2 = mkV2 "烹调" | {-HSK-} mkV2 "煮" ;
lin cookbook_N = mkN "食谱" ;
lin cooker_N = mkN "炊具" | mkN "厨灶" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cookfire_N = mkN "做饭用的火" ; -- open-multilingual-wordnet
lin cookham_PN = foreignPN "Cookham" ; -- comment=src=geonames status=guess
lin cookhouse_N = mkN "野外炊事处" ; -- open-multilingual-wordnet
lin cookie_N = mkN "饼干" | {-HSK-} mkN "饼干" "片" ;
lin cooking_N = mkN "烹饪" "" ;
lin cookstove_N = mkN "厨灶" | mkN "烹调用炉" ; -- open-multilingual-wordnet
lin cooky_N = mkN "饼" ;
lin cool_A = mkA "凉爽" ;
lin cool_N = mkN "凉爽" ;
lin cool_V = mkV "冷却" ;
lin cool_V2 = mkV2 "凉爽" ;
lin coolant_N = mkN "冷却液" [] ;
lin cooler_N = mkN "冷却器" ;
lin coolie_N = mkN "苦力" ; -- status=guess
lin cooling_N = mkN "冷卻" | {-mwn-} mkN "冷却方法" ; -- status=guess -- open-multilingual-wordnet
lin coondog_N = mkN "猎浣熊之猎犬" ; -- open-multilingual-wordnet
lin coonhound_N = mkN "猎浣熊的猎犬" ; -- open-multilingual-wordnet
lin coop_N = mkN "笼" | mkN "笼子" ; -- open-multilingual-wordnet
lin cooperate_V = mkV "合作" | {-HSK-} mkV "配合" ;
lin cooperation_N = mkN "合作" | {-HSK-} mkN "合作" "個" ;
lin cooperative_A = mkA "和蔼可亲" ;
lin cooperative_N = mkN "合作社" ;
lin coordinate_N = mkN "坐標" | mkN "坐标" ; -- status=guess -- status=guess
lin coordinate_V = mkV "协调" ;
lin coordinate_V2 = mkV2 "协调" ;
lin coordination_N = mkN "协调" ;
lin coordinator_N = mkN "协调员" ;
lin coot_N = mkN "白骨顶" | mkN "黑鸭" ; -- open-multilingual-wordnet
lin cop_N = mkN "警察" ;
lin cop_V2 = variants {} ;
lin copacetic_A = mkA "令人十分满意" | mkA "完美" | mkA "极好" ; -- open-multilingual-wordnet
lin cope_V = mkV "应付" ;
lin copeck_N = mkN "戈比" | mkN "苏联小铜板" ; -- open-multilingual-wordnet
lin copenhagen_PN = mkPN "哥本哈根" ; -- comment=src=geonames status=guess
lin copepod_N = mkN "桡脚类的动物" ; -- open-multilingual-wordnet
lin copilot_N = mkN "副駕駛" | mkN "副驾驶" | mkN "副機師" | mkN "副机师" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin coping_N = mkN "压顶砖" ; -- open-multilingual-wordnet
lin copious_A = mkA "丰富" ;
lin copper_N = mkN "铜" | {-HSK-} mkN "铜" "塊" ;
lin coppery_A = mkA "紫铜色" | mkA "赤褐色" | mkA "铜色" ; -- open-multilingual-wordnet
lin coppull_PN = foreignPN "Coppull" ; -- comment=src=geonames status=guess
lin coprolalia_N = mkN "污秽言语" | mkN "秽亵言语" | mkN "秽语症" | mkN "秽语癖" ; -- open-multilingual-wordnet
lin coprophagy_N = mkN "食糞性" | mkN "食粪性" | mkN "食糞症" | mkN "食粪症" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin copula_N = mkN "係詞" | mkN "系词" | mkN "連詞" | mkN "连词" | mkN "連繫動詞" | mkN "连系动词" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin copular_A = mkA "系动词" | mkA "连接" ; -- open-multilingual-wordnet
lin copy_N = mkN "份" | {-HSK-} mkN "拷贝" ;
lin copy_V = mkV "复制" | {-HSK-} mkV "抄" | mkV "模仿" ;
lin copy_V2 = mkV2 "复制" | {-HSK-} mkV2 "抄" | mkV2 "模仿" ;
lin copycat_N = mkN "无主见的人" ;
lin copyholder_N = mkN "原稿架" ; -- open-multilingual-wordnet
lin copyright_N = mkN "版权" ;
lin copyright_V2 = mkV2 "获得版权" ;
lin copywriter_N = mkN "廣告撰稿人" | mkN "广告撰稿人" ; -- status=guess -- status=guess
lin coquetry_N = mkN "風騷" | mkN "风骚" | mkN "媚態" | mkN "媚态" | mkN "嬌態" | mkN "娇态" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin coquette_N = mkN "風騷女子" | mkN "风骚女子" | mkN "狐狸精" ; -- status=guess -- status=guess -- status=guess
lin coquettish_A = mkA "卖弄风情" | mkA "爱调情" | mkA "轻浮" ; -- open-multilingual-wordnet
lin coquille_N = mkN "贝壳碟" ; -- open-multilingual-wordnet
lin coral_A = mkA "珊瑚色" | mkA "珊瑚色" | mkA "橘紅色" | mkA "橘红色" | {-mwn-} mkA "珊瑚红" | mkA "珊瑚色" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin coral_N = mkN "珊瑚" "块" ;
lin corbel_N = mkN "托架" ; -- open-multilingual-wordnet
lin corbelled_A = mkA "以承材支撑" ; -- open-multilingual-wordnet
lin corby_PN = foreignPN "Corby" ; -- comment=src=geonames status=guess
lin cord_N = mkN "绳" "条" | {-HSK-} mkN "绳子" "條" ;
lin cordage_N = mkN "绳索" | mkN "缆索" ; -- open-multilingual-wordnet
lin cordate_A = mkA "心脏形" ; -- open-multilingual-wordnet
lin cordial_A = mkA "亲切" | mkA "热情 " | mkA "诚恳" ;
lin cordial_N = mkN "亲切" | mkN "热情 " | mkN "诚恳" | {-HSK-} mkN "糖漿" | mkN "糖浆" ; -- status=guess -- status=guess
lin cordierite_N = mkN "堇青石" ; -- status=guess -- open-multilingual-wordnet
lin cordite_N = mkN "无烟火药" | mkN "无烟线状火药" | mkN "线状无烟火药" ; -- open-multilingual-wordnet
lin corditis_N = mkN "精索炎" ; -- open-multilingual-wordnet
lin cordless_A = mkA "不用电线" | mkA "无绳" ; -- open-multilingual-wordnet
lin cordoba_PN = foreignPN "Cordoba" ; -- comment=src=eng status=guess
lin cordon_N = mkN "绶带" | mkN "饰带" ; -- open-multilingual-wordnet
lin cordovan_N = mkN "科尔瓦多皮革" | mkN "马臀皮" | mkN "马革" ; -- open-multilingual-wordnet
lin corduroy_N = mkN "条绒" | mkN "灯芯绒类布" ; -- open-multilingual-wordnet
lin core_N = mkN "中心" "個" | mkN "核心" ;
lin coreference_N = mkN "互参" | mkN "互指" | mkN "互见" | mkN "同指" ; -- open-multilingual-wordnet
lin coreferential_A = mkA "互指" | mkA "同指" ; -- open-multilingual-wordnet
lin corer_N = mkN "去心器" | mkN "挖核器" ; -- open-multilingual-wordnet
lin coriaceous_A = mkA "皮般强韧" | mkA "皮质" ; -- open-multilingual-wordnet
lin coriander_N = mkN "番芫荽" | mkN "香菜" ; -- status=guess -- status=guess
lin corinthian_A = mkA "科林斯" ;
lin cork_N = mkN "軟木" | mkN "软木" | {-mwn-} mkN "浮子" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cork_PN = mkPN "科克" ; -- comment=src=geonames status=guess
lin corkage_N = mkN "开瓶费" ; -- open-multilingual-wordnet
lin corker_N = mkN "塞瓶器" ; -- open-multilingual-wordnet
lin corkscrew_N = mkN "螺丝锥" ;
lin corm_N = mkN "球莖" | mkN "球茎" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cormorant_N = mkN "鸕鶿" | mkN "鸬鹚" ; -- status=guess -- status=guess
lin corn_N = mkN "玉米" | {-HSK-} mkN "玉米" "粒" ;
lin cornea_N = mkN "角膜" ;
lin corneal_A = mkA "角膜" ; -- open-multilingual-wordnet
lin cornelian_N = mkN "光玉髓" | mkN "红玉髓" ; -- open-multilingual-wordnet
lin corner_N = mkN "角" "個" | {-HSK-} mkN "角落" ;
lin corner_V = mkV "将+逼入困境" ;
lin corner_V2 = mkV2 "垄断" ;
lin cornerstone_N = mkN "基石" ;
lin cornet_N = mkN "喇叭" | mkN "小号" ; -- open-multilingual-wordnet
lin cornfield_N = mkN "麥田" | mkN "麦田" ; -- status=guess -- status=guess
lin cornflour_N = mkN "玉米淀粉" ; -- open-multilingual-wordnet
lin cornflower_N = mkN "矢車菊" | mkN "矢车菊" ; -- status=guess -- status=guess
lin cornhusk_N = mkN "玉米的外壳" | mkN "玉米皮" | mkN "玉米穗壳" ; -- open-multilingual-wordnet
lin cornice_N = mkN "檐口" ;
lin cornsmut_N = mkN "玉米黑粉病" ; -- open-multilingual-wordnet
lin cornstarch_N = mkN "玉米淀粉" ;
lin cornucopia_N = mkN "聚宝盆" ;
lin cornwall_PN = mkPN "康沃尔" ; -- comment=src=geonames status=guess
lin corolla_N = mkN "花冠" ; -- status=guess
lin corona_N = mkN "一种长雪茄烟" ; -- open-multilingual-wordnet
lin coronary_A = mkA "冠状" ;
lin coronary_N = mkN "冠心病" ; -- status=guess
lin coronation_N = mkN "加冕" ; -- status=guess
lin coroner_N = mkN "驗屍官" | mkN "验尸官" ; -- status=guess -- status=guess
lin coronet_N = mkN "蹄冠" ; -- open-multilingual-wordnet
lin coronilla_N = mkN "小冠花" ; -- open-multilingual-wordnet
lin corozo_N = mkN "象牙棕榈" ; -- open-multilingual-wordnet
lin corp_PN = foreignPN "Corp" ; -- comment=src=eng status=guess
lin corporal_N = mkN "體罰" | mkN "体罚" ; -- status=guess -- status=guess
lin corporate_A = mkA "法人" ;
lin corporation_N = mkN "企业" "家" | mkN "公司" "家" | mkN "公里" "家" | {-HSK-} mkN "公司" ;
lin corps_N = mkN "兵种" ;
lin corpse_N = mkN "尸体" ;
lin corpulence_N = mkN "肥胖" | mkN "肥滿" | mkN "肥满" ; -- status=guess -- status=guess -- status=guess
lin corpulent_A = mkA "胖" | mkA "肥胖" | {-mwn-} mkA "肥大" | mkA "肥胖" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin corpus_N = mkN "語料庫" | mkN "语料库" ; -- status=guess -- status=guess
lin corpuscular_A = mkA "微粒子" ; -- open-multilingual-wordnet
lin corral_N = mkN "畜欄" | mkN "畜栏" | {-mwn-} mkN "牛栏" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin corral_V2 = mkV2 "捕捉" ;
lin correct_A = L.correct_A | {-HSK-} mkA "对" | mkA "正" | mkA "正确" ;
lin correct_V = mkV "改正" | {-HSK-} mkV "纠正" ;
lin correct_V2 = mkV2 "改正" | {-HSK-} mkV2 "纠正" ;
lin correct_VS = mkVS "改正" | {-HSK-} mkVS "纠正" ;
lin correctable_A = mkA "修正" | mkA "改正" | mkA "纠正" ; -- open-multilingual-wordnet
lin correction_1_N = mkN "改正" "個" | {-HSK-} mkN "更正" ;
lin correction_2_N = mkN "改正" "個" | {-HSK-} mkN "更正" ;
lin corrective_A = mkA "矫正" ;
lin corrective_N = mkN "恢复药" ; -- open-multilingual-wordnet
lin correlation_N = mkN "相关" ;
lin correlational_A = mkA "关联" ; -- open-multilingual-wordnet
lin correlative_A = mkA "关联" | mkA "有相互关系" | mkA "相关" ; -- open-multilingual-wordnet
lin correspond_V = mkV "对应" | {-HSK-} mkV "配合" ;
lin correspond_V2 = {-HSK-} mkV2 "配合" ; -- comment=mkV "对应" ;
lin correspondence_N = mkN "对应" ;
lin correspondent_N = mkN "记者" ;
lin corresponding_A = variants {} ;
lin corridor_N = mkN "走廊" ;
lin corrigendum_N = mkN "勘誤" | mkN "勘误" | mkN "刊誤" | mkN "刊误" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin corroborate_V2 = mkV2 "证实" ;
lin corroborative_A = mkA "确认" | mkA "确证" | mkA "证实" ; -- open-multilingual-wordnet
lin corrosive_N = mkN "腐蚀剂" | mkN "腐蚀物" ; -- open-multilingual-wordnet
lin corrugate_V2 = mkV2 "使起波纹" ;
lin corrugation_N = mkN "成皱" | mkN "起皱" ; -- open-multilingual-wordnet
lin corrupt_A = mkA "腐败" ;
lin corruption_N = mkN "腐败" [] ;
lin corsage_N = mkN "花束" ; -- open-multilingual-wordnet
lin corsair_N = mkN "海盗船" ; -- open-multilingual-wordnet
lin corselet_N = mkN "盔甲" ; -- open-multilingual-wordnet
lin corset_N = mkN "緊身褡" | mkN "紧身褡" | {-mwn-} mkN "紧身内衣" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin corsham_PN = foreignPN "Corsham" ; -- comment=src=geonames status=guess
lin corslet_N = mkN "盔甲" ; -- open-multilingual-wordnet
lin cortege_1_N = variants {} ; ---- sense to be split
lin cortege_2_N = variants {} ; ---- sense to be split
lin cortical_A = mkA "外皮" ; -- open-multilingual-wordnet
lin corticosteroid_N = mkN "皮质甾类" | mkN "皮质类固醇" ; -- open-multilingual-wordnet
lin corticosterone_N = mkN "皮质甾酮" ; -- open-multilingual-wordnet
lin cortina_N = mkN "丝膜" ; -- open-multilingual-wordnet
lin cortisone_N = mkN "可的松" | mkN "考的松" ; -- status=guess -- status=guess
lin corundom_N = mkN "刚玉" ; -- open-multilingual-wordnet
lin corundum_N = mkN "刚玉" ; -- open-multilingual-wordnet
lin corunna_PN = foreignPN "Corunna" ; -- comment=src=geonames status=guess
lin corvette_N = mkN "轻巡洋舰" ;
lin corvine_A = mkA "乌鸦" ; -- open-multilingual-wordnet
lin corymb_N = mkN "伞房花序" | mkN "伞状花序" ; -- open-multilingual-wordnet
lin corymbose_A = mkA "伞房状" | mkA "伞房花序" | mkA "伞状花序" ; -- open-multilingual-wordnet
lin cosecant_N = mkN "余割" ; -- open-multilingual-wordnet
lin coseismic_A = mkA "等震曲线" ; -- open-multilingual-wordnet
lin cosenza_PN = foreignPN "Cosenza" ; -- comment=src=geonames status=guess
lin cosh_N = mkN "包皮短棒" ; -- open-multilingual-wordnet
lin cosine_N = mkN "餘弦" | mkN "余弦" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cosiness_N = mkN "安逸" | mkN "畅快" | mkN "舒适" ; -- open-multilingual-wordnet
lin cosmetic_A = mkA "美容" ;
lin cosmetic_N = mkN "化妆品" ;
lin cosmetologist_N = mkN "美容师" ; -- status=guess
lin cosmic_A = mkA "宇宙" ;
lin cosmology_N = mkN "宇宙学" ; -- status=guess
lin cosmonaut_N = mkN "太空人" | mkN "宇航員" | mkN "宇航员" | mkN "航天員" | mkN "航天员" | mkN "宇宙飛行員" | mkN "宇宙飞行员" | {-mwn-} mkN "太空船上的飞行员" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin cosmos_N = mkN "宇宙" | {-HSK-} mkN "太空" ; -- status=guess -- status=guess
lin cosmotron_N = mkN "阳子加速装置" ; -- open-multilingual-wordnet
lin cost_N = mkN "成本" | {-HSK-} mkN "费用" "筆" ;
lin cost_V = mkV "成本" ;
lin cost_V2 = mkV2 "成本" ;
lin cost_up_V2 = prepV2 OP_cost_V OP_up_Prep ; -- guess-p-verb
lin costa_N = mkN "肋骨" ; -- open-multilingual-wordnet
lin costa_rica_PN = foreignPN "Costa rica" ; -- comment=src=eng status=guess
lin costa_rican_A = mkA "哥斯达黎加" ;
lin costa_rican_N = mkN "肋骨" ;
lin costal_A = mkA "肋骨" ; -- open-multilingual-wordnet
lin costly_A = mkA "昂贵" ;
lin costochondritis_N = mkN "骨软骨炎" ; -- open-multilingual-wordnet
lin costs_N = mkN "诉讼费" ; -- open-multilingual-wordnet
lin costume_N = mkN "服装" | {-HSK-} mkN "服装" "身" ; -- comment="装束" ;
lin cosy_A = mkA "舒适" | mkA "暄暖" ; -- status=guess -- status=guess
lin cosy_N = mkN "暖壸" | {-mwn-} mkN "茶壶套" ; -- status=guess -- open-multilingual-wordnet
lin cot_N = mkN "小床" ;
lin cotangent_N = mkN "餘切" | mkN "余切" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cote_N = mkN "栏" | mkN "棚" | mkN "窝" | mkN "笼" ; -- open-multilingual-wordnet
lin coterie_N = mkN "小圈子" ;
lin cotoneaster_N = mkN "栒子属植物" | mkN "车轮棠" ; -- open-multilingual-wordnet
lin cottage_N = mkN "小屋" "间" ;
lin cotton_N = mkN "棉" [] | {-HSK-} mkN "棉花" ;
lin cottontail_N = mkN "棉尾兔" ; -- open-multilingual-wordnet
lin couch_N = mkN "躺椅" ;
lin couch_V = mkV "蹲伏" ; -- comment="长沙发" ;
lin couch_V2 = mkV2 "沙发" ;
lin couchette_N = mkN "卧铺车厢" ; -- open-multilingual-wordnet
lin cougar_N = mkN "美洲狮" ; -- status=guess
lin cough_N = mkN "咳嗽" ;
lin cough_V = mkV "咳嗽" ;
lin coulisse_N = mkN "滑槽" ; -- open-multilingual-wordnet
lin coulomb_N = mkN "庫侖" | mkN "库仑" ; -- status=guess -- status=guess
lin coulter_N = mkN "犁刀" ; -- open-multilingual-wordnet
lin council_N = mkN "评议会" ;
lin councillor_N = mkN "委员" "名" ;
lin counsel_N = mkN "法律顾问" ;
lin counsel_V2 = mkV2 "建议" ;
lin counselling_N = variants {} ;
lin counsellor_N = {-mwn-} mkN "律师" | mkN "法律顾问" ; -- open-multilingual-wordnet
lin count_1_N = mkN "计数" "次" ;
lin count_2_N = mkN "计数" "次" ;
lin count_V = mkV "计算" ;
lin count_V2 = L.count_V2 | {-HSK-} mkV2 "计算" ;
lin count_against_V2 = prepV2 OP_count_V OP_against_Prep ; -- guess-p-verb
lin count_among_V2 = prepV2 OP_count_V OP_among_Prep ; -- guess-p-verb
lin count_down_V2 = prepV2 OP_count_V OP_down_Prep ; -- guess-p-verb
lin count_for_V2 = prepV2 OP_count_V OP_for_Prep ; -- guess-p-verb
lin count_in_V2 = prepV2 OP_count_V OP_in_Prep ; -- guess-p-verb
lin count_off_V2 = prepV2 OP_count_V OP_off_Prep ; -- guess-p-verb
lin count_on_V2 = mkV2 "指" ;
lin count_out_V2 = prepV2 OP_count_V OP_out_Prep ; -- guess-p-verb
lin count_towards_V2 = prepV2 OP_count_V OP_towards_Prep ; -- guess-p-verb
lin count_up_V2 = prepV2 OP_count_V OP_up_Prep ; -- guess-p-verb
lin count_upon_V2 = prepV2 OP_count_V OP_upon_Prep ; -- guess-p-verb
lin countable_A = mkA "可數" | mkA "可数" ; -- status=guess -- status=guess
lin countdown_N = mkN "倒数计数" ;
lin countenance_N = mkN "面容" ;
lin counter_Adv = mkAdv "反击" ;
lin counter_N = mkN "反击" ;
lin counter_V = mkV "计数器" | {-HSK-} mkV "针对" ;
lin counter_VS = mkVS "反驳" | {-HSK-} mkVS "针对" ;
lin counteract_V2 = mkV2 "抵消" | {-HSK-} mkV2 "杀" ;
lin counterattack_N = mkN "反击" "次" ;
lin counterattack_V = mkV "反攻" ;
lin counterbalance_V2 = mkV2 "抵消" ;
lin counterbore_N = mkN "埋头孔" | mkN "扩孔" | mkN "镗孔" ; -- open-multilingual-wordnet
lin counterclaim_N = mkN "反诉" ;
lin counterclockwise_A = mkA "反时针" | mkA "反时针方向" | mkA "逆时针" | mkA "逆时针方向" | mkA "逆时钟方向" ; -- open-multilingual-wordnet
lin counterespionage_N = mkN "反间谍" ;
lin counterfeit_A = mkA "假冒" ; -- status=guess
lin counterfeit_N = mkN "贗品" | mkN "赝品" ; -- status=guess -- status=guess
lin counterfeiter_N = mkN "偽造者" | mkN "伪造者" ; -- status=guess -- status=guess
lin counterintelligence_N = mkN "反間諜" | mkN "反间谍" ; -- status=guess -- status=guess
lin counterirritant_N = mkN "对抗刺激剂" | mkN "对抗刺激物" | mkN "抗刺激剂" | mkN "诱导剂" ; -- open-multilingual-wordnet
lin countermeasure_N = mkN "對策" | mkN "对策" ; -- status=guess -- status=guess
lin counterpart_N = mkN "对方" ;
lin counterpoint_N = mkN "旋律配合" ;
lin counterpoise_N = mkN "使平衡" | mkN "平衡" | mkN "平衡力" | mkN "等重" ; -- open-multilingual-wordnet
lin counterproductive_A = mkA "適得其反" | mkA "适得其反" | mkA "反效果" | mkA "產生反作用" | mkA "产生反作用" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin counterreformation_N = mkN "反改革" ; -- open-multilingual-wordnet
lin countersign_V2 = mkV2 (mkV "连署") | mkV2 (mkV "連署") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin countersink_N = mkN "埋头孔" | mkN "扩孔" | mkN "镗孔" ; -- open-multilingual-wordnet
lin counterspy_N = mkN "内奸" | mkN "反间谍" ; -- open-multilingual-wordnet
lin counterstain_N = mkN "复染剂" | mkN "复染色" | mkN "对比染色" | mkN "对照染色剂" ; -- open-multilingual-wordnet
lin countertenor_N = mkN "假聲男高音" | mkN "假声男高音" ; -- status=guess -- status=guess
lin countertop_N = mkN "工作台面" ; -- open-multilingual-wordnet
lin countervail_V = mkV "抵销" ;
lin counterweight_N = mkN "平衡力" ;
lin countess_N = mkN "伯爵夫人" ; -- status=guess
lin counting_house_N = mkN "会计室" | mkN "存帐室" ; -- open-multilingual-wordnet
lin countless_A = mkA "千万" | mkA "无数" ;
lin country_N = L.country_N | {-HSK-} mkN "国家" "個" ;
lin countryman_N = mkN "乡下人" ;
lin country_seat_N = mkN "乡间别墅" | mkN "乡间庄园" | mkN "乡间邸宅" ; -- open-multilingual-wordnet
lin countryside_N = mkN "农村" ;
lin county_N = mkN "县" ;
lin coup_N = mkN "政变" ;
lin coup_d'etat_N = mkN "政变" ; -- open-multilingual-wordnet
lin coup_de_grace_N = mkN "致命的一击" ;
lin couple_N = mkN "一对" | {-HSK-} mkN "对" ;
lin couple_V = mkV "结合" ;
lin couple_V2 = mkV2 "联结" ;
lin couplet_N = mkN "对联" ;
lin coupling_N = mkN "耦合" ;
lin coupon_N = mkN "优惠券" ;
lin courage_N = mkN "勇气" | {-HSK-} mkN "勇气" [] ;
lin courageous_A = mkA "勇敢" | {-HSK-} mkA "有胆量" ; -- comment="勇敢" ;
lin courier_N = mkN "信使" ;
lin course_N = mkN "经过" "個" | mkN "课" "堂" | mkN "课程" "堂" | {-HSK-} mkN "课程" ;
lin course_V = mkV "追赶" ;
lin course_V2 = mkV2 "使+跑过" ;
lin courser_N = mkN "游鸻" ; -- open-multilingual-wordnet
lin court_1_N = mkN "法庭" ;
lin court_2_N = mkN "法庭" ;
lin court_N = mkN "法庭" ;
lin court_V = mkV "法院" ;
lin court_V2 = mkV2 "招致" ;
lin courteous_A = mkA "有禮貌" | mkA "有礼貌" | mkA "客氣" | mkA "客气" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin courtesan_N = mkN "专与高级官员往来的妓女" ;
lin courtesy_N = mkN "礼貌" ;
lin courthouse_N = mkN "法庭" | mkN "法院" ; -- status=guess -- status=guess
lin courtroom_N = mkN "法庭" ;
lin courtship_N = mkN "求偶" ;
lin courtyard_N = mkN "庭院" ;
lin cousin_N = L.cousin_N ;
lin couth_A = mkA "文明" | mkA "文雅" | mkA "有教养" | mkA "温文尔雅" ; -- open-multilingual-wordnet
lin couturier_N = mkN "时装设计师" | mkN "裁缝" | mkN "设计家" | mkN "设计师" ; -- open-multilingual-wordnet
lin couvade_N = mkN "拟娩" | mkN "父代母育" ; -- open-multilingual-wordnet
lin cove_N = mkN "小伙子" ; -- status=guess
lin covenant_N = mkN "契约" ;
lin coventry_PN = mkPN "考文垂" ; -- comment=src=geonames status=guess
lin cover_N = mkN "套" | mkN "挡" | mkN "盖" | {-HSK-} mkN "盖子" ;
lin cover_V2 = mkV2 "包" | mkV2 "被" | mkV2 "采访" | {-HSK-} mkV2 "覆盖" ;
lin cover_for_V2 = prepV2 (lin V OP_cover_V2) OP_for_Prep ; -- guess-p-verb
lin cover_up_V2 = prepV2 (lin V OP_cover_V2) OP_up_Prep ; -- guess-p-verb
lin coverage_N = mkN "覆盖" ;
lin covering_N = mkN "覆盖物" "件" ;
lin coverlet_N = mkN "床罩" | mkN "被单" ; -- open-multilingual-wordnet
lin covert_A = mkA "隐蔽" ;
lin covert_N = mkN "隐蔽处" ;
lin covet_V2 = mkV2 "妄想" ;
lin covetous_A = mkA "贪婪" ;
lin cow_N = L.cow_N ;
lin cow_V2 = mkV2 "使+恐吓" ;
lin coward_N = mkN "懦夫" | {-HSK-} mkN "胆小鬼" ;
lin cowardice_N = mkN "膽怯" | mkN "胆怯" | mkN "怯懦" ; -- status=guess -- status=guess -- status=guess
lin cowardly_A = mkA "懦弱" ;
lin cowbarn_N = mkN "牛房" | mkN "牛舍" ; -- open-multilingual-wordnet
lin cowbell_N = mkN "牛铃" ; -- open-multilingual-wordnet
lin cowboy_N = mkN "牛仔" ;
lin cowcatcher_N = mkN "防护板" ; -- open-multilingual-wordnet
lin cowdenbeath_PN = foreignPN "Cowdenbeath" ; -- comment=src=geonames status=guess
lin cower_V = mkV "畏缩" ;
lin cowes_PN = foreignPN "Cowes" ; -- comment=src=geonames status=guess
lin cowgirl_N = mkN "女牛仔" ; -- status=guess
lin cowhide_N = mkN "牛皮鞭" ; -- open-multilingual-wordnet
lin cowhouse_N = mkN "牛房" | mkN "牛舍" ; -- open-multilingual-wordnet
lin cowling_N = mkN "引擎盖" | mkN "引擎罩" ; -- open-multilingual-wordnet
lin coworker_N = mkN "同事" | mkN "同僚" ; -- status=guess -- status=guess
lin cowpox_N = mkN "牛痘" ; -- status=guess -- open-multilingual-wordnet
lin cowshed_N = mkN "牛舍" | mkN "牛房" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cowskin_N = mkN "牛皮" ; -- open-multilingual-wordnet
lin coy_A = mkA "腼腆" ;
lin coyote_N = mkN "小狼" "只" ;
lin coypu_N = mkN "海狸鼠" ; -- status=guess
lin coziness_N = mkN "安逸" | mkN "畅快" | mkN "舒适" ; -- open-multilingual-wordnet
lin cozy_A = mkA "舒适" ;
lin cp_PN = foreignPN "Cp" ; -- comment=src=eng status=guess
lin cpl_PN = foreignPN "Cpl" ; -- comment=src=eng status=guess
lin crab_N = mkN "螃蟹" ;
lin crack_N = mkN "裂纹" ;
lin crack_V2 = mkV2 "使+开裂" ;
lin crackbrained_A = mkA "极端愚蠢" | mkA "白痴" | mkA "精神错乱" ; -- open-multilingual-wordnet
lin crack_down_N = mkN "鎮壓" | mkN "镇压" | mkN "痛擊" | mkN "痛击" | mkN "彈壓" | mkN "弹压" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin cracker_N = mkN "饼干" "块" | {-HSK-} mkN "饼干" "片" ;
lin cracking_N = mkN "使爆裂" | mkN "使破裂" | mkN "分裂" | mkN "破裂" ; -- open-multilingual-wordnet
lin crackle_N = mkN "劈里啪啦的响声" ; -- status=guess
lin crackle_V = mkV "发噼啪声" ;
lin cradle_N = mkN "摇篮" ;
lin craft_N = mkN "工艺" "种" ;
lin craft_V2 = mkV2 "精巧地制作" ;
lin craftsman_N = mkN "工匠" "位" ;
lin craftsmanship_N = mkN "工艺" | mkN "手段" | mkN "手艺" | mkN "技巧" | mkN "技艺" ; -- open-multilingual-wordnet
lin crafty_A = mkA "狡猾" ;
lin crag_N = mkN "峭壁" | mkN "崖" ; -- status=guess -- status=guess
lin crake_N = mkN "秧鸡" | mkN "秧鸡之类" ; -- open-multilingual-wordnet
lin cram_V = mkV "死记硬背" ;
lin cram_V2 = mkV2 "塞满" ;
lin cramlington_PN = foreignPN "Cramlington" ; -- comment=src=geonames status=guess
lin cramp_N = mkN "痉挛" ;
lin cramp_V2 = mkV2 "束缚" ;
lin crampon_N = mkN "尖铁钉" | mkN "攀登用鞋底钉" | mkN "鞋底钉" ; -- open-multilingual-wordnet
lin cran_N = mkN "鲱斗" ; -- open-multilingual-wordnet
lin cranberry_N = mkN "蔓越橘" | mkN "蔓越桔" ; -- status=guess -- status=guess
lin crane_N = mkN "起重机" ;
lin crane_V2 = mkV2 "迟疑" ;
lin cranesbill_N = mkN "老鹳草" | mkN "龙牛儿苗" ; -- open-multilingual-wordnet
lin cranial_A = mkA "头盖" ; -- open-multilingual-wordnet
lin craniometer_N = mkN "头盖测量器" | mkN "颅测量器" ; -- open-multilingual-wordnet
lin craniometric_A = mkA "头盖测量" ; -- open-multilingual-wordnet
lin crank_A = mkA "不稳" | mkA "摇晃" ; -- open-multilingual-wordnet
lin crank_N = mkN "曲柄" ;
lin crank_V2 = mkV2 "装曲柄" ;
lin crankcase_N = mkN "曲轴箱" ; -- open-multilingual-wordnet
lin crankshaft_N = mkN "曲柄轴" | mkN "曲轴" | mkN "机轴" ; -- open-multilingual-wordnet
lin crap_N = mkN "废话" "堆" ;
lin crape_N = mkN "绉呢" | mkN "绉纱" | mkN "绉绸" | mkN "绉胶" ; -- open-multilingual-wordnet
lin crash_N = mkN "崩溃" ;
lin crash_V = mkV "崩溃" ;
lin crash_dive_V = variants {} ; -- guess-p-verb
lin crash_land_V = variants {} ; -- guess-p-verb
lin crash_land_V2 = variants {} ; -- guess-p-verb
lin crash_out_V = advV OP_crash_V OP_out_Adv ; -- guess-p-verb
lin crass_A = mkA "愚钝" ;
lin crate_N = mkN "箱" ;
lin crater_N = mkN "撞擊坑" | mkN "撞击坑" ; -- status=guess -- status=guess
lin crater_V = mkV "消忘" ;
lin cravat_N = mkN "饰带" ; -- open-multilingual-wordnet
lin crave_V = mkV "渴望" | mkV "熱望" | mkV "热望" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin crave_V2 = mkV2 "渴望" ;
lin craving_N = mkN "渴望" "" ;
lin craw_N = mkN "嗉囊" | mkN "嗉子" ; -- open-multilingual-wordnet
lin crawfish_N = mkN "大螯虾" | mkN "小龙虾" | mkN "龙虾" ; -- open-multilingual-wordnet
lin crawl_N = mkN "爬行" ;
lin crawl_V = mkV "爬行" ;
lin crawley_PN = foreignPN "Crawley" ; -- comment=src=geonames status=guess
lin crayfish_N = mkN "小龍蝦" | mkN "小龙虾" ; -- status=guess -- status=guess
lin crayon_N = mkN "蠟筆" | mkN "蜡笔" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin craze_N = mkN "狂热" ;
lin crazy_A = mkA "疯狂" ;
lin creak_N = mkN "嘎吱嘎吱声""" ;
lin creak_V = mkV "发出嘎吱嘎吱声" ;
lin creaky_A = mkA "关节炎" | mkA "患风湿症" | mkA "风湿症" ; -- open-multilingual-wordnet
lin cream_N = mkN "奶油" ;
lin cream_V2 = mkV2 "奶油" ;
lin creamery_N = mkN "牛奶制品工厂" ; -- open-multilingual-wordnet
lin creamy_A = mkA "奶油" ;
lin crease_N = mkN "皺" | mkN "皱" | mkN "皺痕" | mkN "皱痕" | mkN "襞" | {-mwn-} mkN "波状刃短剑" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin creaseless_A = mkA "不起皱" ; -- open-multilingual-wordnet
lin creaseproof_A = mkA "不透油" ; -- open-multilingual-wordnet
lin create_V = mkV "创建" | {-HSK-} mkV "创造" | mkV "导致" | mkV "造成" ;
lin create_V2 = mkV2 "创建" | {-HSK-} mkV2 "创造" | mkV2 "导致" | mkV2 "造成" ;
lin creatine_N = mkN "肌肉素" | mkN "肌酸" ; -- open-multilingual-wordnet
lin creation_N = mkN "创作" ;
lin creationism_N = mkN "神創論" | mkN "神创论" ; -- status=guess -- status=guess
lin creative_A = mkA "创造性" ;
lin creativity_N = mkN "创造力" ;
lin creator_N = mkN "创造者" ;
lin creature_N = mkN "生物" ;
lin credence_N = mkN "凭证" ;
lin credenza_N = mkN "碗橱" | mkN "餐具柜" ; -- open-multilingual-wordnet
lin credibility_N = mkN "可信性" ;
lin credible_A = mkA "可信" ;
lin credit_N = mkN "信用" | {-HSK-} mkN "荣誉" ;
lin credit_V2 = mkV2 "信用" ;
lin creditable_A = mkA "值得称赞" | mkA "可称誉" ; -- open-multilingual-wordnet
lin creditor_N = mkN "债权人" ;
lin credit_worthy_A = mkA "可信赖" ; -- open-multilingual-wordnet
lin credo_N = mkN "信条" ;
lin credulity_N = mkN "轻信" "" ;
lin credulous_A = mkA "輕信" | mkA "轻信" ; -- status=guess -- status=guess
lin creed_N = mkN "信条" ;
lin creedal_A = mkA "信条" | mkA "信经" | mkA "教义" ; -- open-multilingual-wordnet
lin creel_N = mkN "柳条篮" ; -- open-multilingual-wordnet
lin creep_N = mkN "爬行""" ;
lin creep_V = mkV "爬行" ;
lin creep_up_V = mkV "悄悄地走近" | mkV "悄悄地靠近" ; -- open-multilingual-wordnet
lin creepy_A = mkA "令人毛骨悚然" ;
lin cremate_V2 = mkV2 (mkV "焚毀") ; -- status=guess, src=wikt
lin cremation_N = mkN "火葬" ; -- status=guess
lin crematorium_N = mkN "火葬场" ;
lin crenate_A = mkA "圆锯齿状" ; -- open-multilingual-wordnet
lin crenel_N = mkN "垛口" | mkN "枪眼" | mkN "炮门" ; -- open-multilingual-wordnet
lin crenulate_A = mkA "细圆齿状" ; -- open-multilingual-wordnet
lin creosote_N = mkN "煤焦杂酚油" ; -- open-multilingual-wordnet
lin crepe_1_N = variants {} ; ---- sense to be split
lin crepe_2_N = variants {} ; ---- sense to be split
lin crepitate_V = mkV "劈啪响" | mkV "劈拍劈拍响" | mkV "发劈啪声" ; -- open-multilingual-wordnet
lin cres_PN = mkPN "茨雷斯島" ; -- comment=src=geonames status=guess
lin crescendo_A = mkA "声音渐增" | mkA "渐强" | mkA "音量逐渐增强" ; -- open-multilingual-wordnet
lin crescendo_N = mkN "声音渐强" ;
lin cresol_N = mkN "甲酚" ; -- open-multilingual-wordnet
lin crest_N = mkN "波峰" ;
lin crest_V = mkV "到达绝顶" ;
lin creswell_PN = foreignPN "Creswell" ; -- comment=src=geonames status=guess
lin cretaceous_A = mkA "白垩纪" ;
lin cretinism_N = mkN "克汀病" | mkN "呆小病" | mkN "愚侏儒病" | mkN "愚侏病" | mkN "白痴病" ; -- open-multilingual-wordnet
lin cretonne_N = mkN "印花棉布" | mkN "大花窗帘棉布" ; -- open-multilingual-wordnet
lin crevasse_N = mkN "裂缝" ;
lin crevice_N = mkN "裂缝" "条" ;
lin crew_N = mkN "人员" "個" | {-HSK-} mkN "船员" ;
lin crewe_PN = mkPN "克魯" ; -- comment=src=geonames status=guess
lin crewelwork_N = mkN "绒线刺绣" ; -- open-multilingual-wordnet
lin crib_N = mkN "婴儿床" ;
lin cricket_N = mkN "蟋蟀" "只" ;
lin crieff_PN = foreignPN "Crieff" ; -- comment=src=geonames status=guess
lin crime_N = mkN "犯罪" ;
lin criminal_A = mkA "刑事" | {-HSK-} mkA "罪犯" ;
lin criminal_N = mkN "刑事" | {-HSK-} mkN "罪犯" ;
lin criminalism_N = mkN "有罪" | mkN "犯罪" ; -- open-multilingual-wordnet
lin criminalize_V2 = mkV2 "对+判处刑罚" ;
lin criminological_A = mkA "犯罪学" ; -- open-multilingual-wordnet
lin criminology_N = mkN "犯罪学" ;
lin crimp_V2 = mkV2 "使+卷曲" ;
lin crimson_A = mkA "深红" ;
lin crimson_N = mkN "艷紅色" | mkN "艳红色" ; -- status=guess -- status=guess
lin crimson_V = mkV "变红" | mkV "脸红" ; -- open-multilingual-wordnet
lin cringe_V = mkV "奉承" ;
lin cringle_N = mkN "金属圈" ; -- open-multilingual-wordnet
lin crinkle_N = mkN "皱" | mkN "皱纹" | mkN "皱褶" ; -- open-multilingual-wordnet
lin crinoid_A = mkA "海百合类" | mkA "海百合纲" ; -- open-multilingual-wordnet
lin crinoid_N = mkN "海百合类" ; -- open-multilingual-wordnet
lin cripple_N = mkN "跛子" ;
lin cripple_V2 = mkV2 "弄跛" ;
lin crisis_N = mkN "危机" ;
lin crisp_A = mkA "脆" ;
lin crispate_A = mkA "卷缩状" ; -- open-multilingual-wordnet
lin criss_cross_V2 = mkV2 "辗转反侧" ;
lin crisscross_A = mkA "交叉" | mkA "十字形" | mkA "十字架形" ; -- open-multilingual-wordnet
lin crisscross_V = mkV "交叉往来" ;
lin cristobalite_N = mkN "方石英" ; -- open-multilingual-wordnet
lin criterial_A = mkA "标准" ; -- open-multilingual-wordnet
lin criterion_N = mkN "标准" | {-HSK-} mkN "标准" "個" ;
lin crith_N = mkN "克瑞" ; -- open-multilingual-wordnet
lin critic_N = mkN "评论家" ;
lin critical_1_A = variants {} ;
lin critical_2_A = variants {} ;
lin critical_A = mkA "关键" ;
lin criticality_N = mkN "临界" | mkN "临界状态" ; -- open-multilingual-wordnet
lin criticism_N = mkN "批评" | {-HSK-} mkN "批评" "個" ;
lin criticize_V = mkV "批" | mkV "批评" ;
lin criticize_V2 = mkV2 "批" | mkV2 "批评" ;
lin critique_N = mkN "批评" ;
lin critter_N = mkN "家畜" ; -- open-multilingual-wordnet
lin croak_N = mkN "呱呱" ; -- status=guess
lin croak_V = mkV "呱呱" ; -- status=guess, src=wikt
lin croak_V2 = mkV2 "嘶哑地说" ;
lin crochet_N = mkN "鉤針編織" | mkN "钩针编织" | {-mwn-} mkN "用钩针编织" | mkN "钩边" | mkN "钩针编织品" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin crock_N = mkN "瓦罐" ; -- open-multilingual-wordnet
lin crocket_N = mkN "卷叶式凸雕" | mkN "卷叶形花饰" | mkN "卷叶花样" | mkN "卷叶饰" | mkN "花形的浮雕" ; -- open-multilingual-wordnet
lin crocodile_N = mkN "鰐" ; -- status=guess
lin crocolite_N = mkN "铬铅矿" ; -- open-multilingual-wordnet
lin croesus_PN = foreignPN "Croesus" ; -- comment=src=eng status=guess
lin croft_N = mkN "小农场" ; -- open-multilingual-wordnet
lin cromer_PN = foreignPN "Cromer" ; -- comment=src=geonames status=guess
lin cromlech_N = mkN "石棚" ; -- open-multilingual-wordnet
lin crony_N = mkN "密友" ;
lin cronyism_N = mkN "任人唯亲" ; -- status=guess
lin crook_N = mkN "弯曲" [] ;
lin crook_PN = foreignPN "Crook" ; -- comment=src=geonames status=guess
lin crook_V2 = mkV2 "使+弯曲" ;
lin crooked_A = mkA "歪" | mkA "不正當" | mkA "不正当" ; -- status=guess -- status=guess -- status=guess
lin croon_V = mkV "轻哼" ;
lin croon_V2 = mkV2 (mkV "哼") ; -- status=guess, src=wikt
lin crop_N = mkN "收成" ;
lin crop_V = mkV "收获" ;
lin crop_V2 = variants {} ; -- comment=mkV "收获" ;
lin croquet_N = mkN "槌球" ; -- status=guess
lin croquette_N = mkN "炸丸子" ; -- status=guess
lin crore_N = mkN "一千万" ; -- open-multilingual-wordnet
lin crosby_PN = foreignPN "Crosby" ; -- comment=src=geonames status=guess
lin cross_A = mkA "交叉" | {-HSK-} mkA "错" ;
lin cross_N = mkN "交叉" | {-HSK-} mkN "错" "個" ;
lin cross_V = mkV "交叉" | {-HSK-} mkV "过" ;
lin cross_V2 = mkV2 "交叉" | {-HSK-} mkV2 "过" ;
lin cross_examine_V2 = variants {} ; -- guess-p-verb
lin cross_fertilize_V2 = variants {} ; -- guess-p-verb
lin cross_index_V2 = variants {} ; -- guess-p-verb
lin cross_off_V2 = prepV2 OP_cross_V OP_off_Prep ; -- guess-p-verb
lin cross_out_V2 = prepV2 OP_cross_V OP_out_Prep ; -- guess-p-verb
lin cross_question_V2 = variants {} ; -- guess-p-verb
lin cross_up_V2 = prepV2 OP_cross_V OP_up_Prep ; -- guess-p-verb
lin crossbar_N = mkN "橫梁" | mkN "横梁" ; -- status=guess -- status=guess
lin cross_bench_N = mkN "中立议员席" ; -- open-multilingual-wordnet
lin crossbow_N = mkN "弩" ; -- status=guess -- open-multilingual-wordnet
lin crossbreed_N = mkN "杂交品种" | mkN "杂交种" | mkN "杂种" ; -- open-multilingual-wordnet
lin crossfire_N = mkN "交叉火力" ;
lin crosshead_N = mkN "十字头" ; -- open-multilingual-wordnet
lin crossing_N = mkN "路口" "个" ;
lin crossopterygian_N = mkN "总鳍鱼" ; -- open-multilingual-wordnet
lin crossover_N = mkN "人行横道" | mkN "斑马线" | mkN "行人穿越道" ; -- open-multilingual-wordnet
lin crosspiece_N = mkN "横杆" | mkN "横档" | mkN "横梁" ; -- open-multilingual-wordnet
lin crossroad_N = mkN "十字路口" ;
lin crossroads_N = mkN "十字路口" | mkN "交叉路" | mkN "交叉路口" ; -- status=guess -- status=guess -- status=guess
lin crosstalk_N = mkN "相聲" | mkN "相声" ; -- status=guess -- status=guess
lin crosswalk_N = mkN "斑馬線" | mkN "斑马线" | mkN "行人穿越道" | {-mwn-} mkN "人行横道" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin crossword_N = mkN "填字遊戲" | mkN "填字游戏" ; -- status=guess -- status=guess
lin crotalaria_N = mkN "三圆叶猪屎豆" | mkN "椭圆叶猪屎豆" | mkN "猪屎豆" ; -- open-multilingual-wordnet
lin crotch_N = mkN "岔" | mkN "丫叉" | mkN "分叉" ; -- status=guess -- status=guess -- status=guess
lin crotchet_N = mkN "四分音符" ; -- status=guess
lin crotchety_A = mkA "遐想" ;
lin crouch_N = mkN "蹲伏" "" ;
lin crouch_V = mkV "蹲" | {-HSK-} mkV "蹲伏" ;
lin croup_N = mkN "臀部" ; -- open-multilingual-wordnet
lin croupy_A = mkA "义膜性" ; -- open-multilingual-wordnet
lin crow_N = mkN "烏鴉" | mkN "乌鸦" ; -- status=guess -- status=guess
lin crow_V = mkV "报晓" ;
lin crow_VS = mkVS "啼叫" ;
lin crowbar_N = mkN "橇棍" | mkN "鐵橇" | mkN "铁橇" | mkN "撬杠" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin crowberry_N = mkN "岩高兰" ; -- open-multilingual-wordnet
lin crowborough_PN = foreignPN "Crowborough" ; -- comment=src=geonames status=guess
lin crowd_N = mkN "人群" | {-HSK-} mkN "群" ;
lin crowd_V = mkV "拥挤" | {-HSK-} mkV "挤" ;
lin crowd_V2 = mkV2 "拥挤" ;
lin crowded_A = mkA "擠滿人" | mkA "挤满人" | mkA "擠滿" | mkA "挤满" | mkA "擁擠" | mkA "拥挤" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin crowding_N = mkN "拥挤" | mkN "拥挤现象" ; -- open-multilingual-wordnet
lin crown_N = mkN "冠" ;
lin crown_V2 = mkV2 "加冕" ;
lin crowning_A = mkA "最高" ;
lin crowthorne_PN = foreignPN "Crowthorne" ; -- comment=src=geonames status=guess
lin croydon_PN = mkPN "克羅伊登" ; -- comment=src=geonames status=guess
lin crucial_A = mkA "关键" ;
lin cruciate_A = mkA "十字形" | mkA "十字状" ; -- open-multilingual-wordnet
lin crucible_N = mkN "坩埚" ;
lin cruciferous_A = mkA "十字花科" ; -- open-multilingual-wordnet
lin crucifix_N = mkN "十字架" | {-mwn-} mkN "引体向上" ; -- status=guess -- open-multilingual-wordnet
lin crucifixion_N = mkN "釘十字架" | mkN "钉十字架" | {-mwn-} mkN "折磨" | mkN "施酷刑" | mkN "苦难" | mkN "酷刑" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cruciform_A = mkA "十字形" | mkA "十字状" ; -- open-multilingual-wordnet
lin crud_N = mkN "怪病" ; -- open-multilingual-wordnet
lin crude_A = mkA "粗糙" | {-HSK-} mkA "简陋" ;
lin cruel_A = mkA "残酷" ;
lin cruelty_N = {-mwn-} mkN "残忍" | mkN "残酷" | mkN "野蛮" ; -- open-multilingual-wordnet
lin cruet_N = mkN "调味瓶" ; -- open-multilingual-wordnet
lin cruise_N = mkN "巡航" ;
lin cruise_V = mkV "巡航" ;
lin cruiser_N = mkN "巡洋舰" ;
lin crumb_N = mkN "屑" ; -- status=guess
lin crumble_V = mkV "崩溃" ;
lin crumble_V2 = mkV2 "崩溃" ;
lin crumple_V = mkV "弄皱" ;
lin crumple_V2 = mkV2 "揉碎" ;
lin crunch_N = mkN "紧缩" "次" ;
lin crunch_V = mkV "压碎" ;
lin crupper_N = mkN "牵鞍兜带" ; -- open-multilingual-wordnet
lin crural_A = mkA "股" | mkA "胫" | mkA "脚" ; -- open-multilingual-wordnet
lin crusade_N = mkN "十字军东征" ;
lin crusader_N = mkN "十字軍" | mkN "十字军" | mkN "十字軍戰士" | mkN "十字军战士" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cruse_N = mkN "壶" | mkN "罐" ; -- open-multilingual-wordnet
lin crush_N = mkN "粉碎" ;
lin crush_V = mkV "粉碎" ;
lin crush_V2 = mkV2 "粉碎" ;
lin crust_N = mkN "外壳" ;
lin crustacean_N = mkN "介蟲" | mkN "介虫" | mkN "甲殼動物" | mkN "甲壳动物" | {-mwn-} mkN "甲壳纲动物" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin crustaceous_A = mkA "外壳" | mkA "有外壳" | mkA "有硬皮" | mkA "硬皮" ; -- open-multilingual-wordnet
lin crusty_A = mkA "硬皮" ;
lin crutch_N = mkN "拐杖" ;
lin crux_N = mkN "关键" "個" | {-HSK-} mkN "關鍵" | mkN "关键" ; -- status=guess -- status=guess
lin cry_N = mkN "哭""次" | {-HSK-} mkN "喊" ;
lin cry_V = mkV "叫喊" | {-HSK-} mkV "哭" ;
lin cry_V2 = mkV2 "哭" ;
lin cry_off_V2 = prepV2 OP_cry_V OP_off_Prep ; -- guess-p-verb
lin cry_out_V = advV OP_cry_V OP_out_Adv ; -- guess-p-verb
lin crybaby_N = mkN "愛哭的人" | mkN "爱哭的人" | mkN "個愛哭鬼" | mkN "个爱哭鬼" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cryesthesia_N = mkN "冷觉过敏" ; -- open-multilingual-wordnet
lin cryoanesthesia_N = mkN "冷觉缺失" ; -- open-multilingual-wordnet
lin cryogen_N = mkN "冷冻剂" | mkN "制冷剂" ; -- open-multilingual-wordnet
lin cryogenic_A = mkA "低温" | mkA "冷冻" ; -- open-multilingual-wordnet
lin cryometer_N = mkN "低温计" ; -- open-multilingual-wordnet
lin cryoscope_N = mkN "低温测定器" | mkN "冰点测定器" ; -- open-multilingual-wordnet
lin cryostat_N = mkN "低温保持器" ; -- open-multilingual-wordnet
lin crypt_N = mkN "隱窩" | mkN "隐窝" | mkN "土窖" | mkN "地穴" | {-mwn-} mkN "地窖" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin cryptanalytic_A = mkA "关于暗号" | mkA "密码分析" | mkA "密码术" | mkA "用密码写" ; -- open-multilingual-wordnet
lin cryptobiotic_A = mkA "潜生" | mkA "隐生" ; -- open-multilingual-wordnet
lin cryptococcosis_N = mkN "新型隐球菌病" | mkN "隐球菌病" ; -- open-multilingual-wordnet
lin cryptogamic_A = mkA "隐花植物" ; -- open-multilingual-wordnet
lin cryptograph_N = mkN "密码机" | mkN "解密机" ; -- open-multilingual-wordnet
lin cryptography_N = mkN "密碼學" ; -- status=guess
lin cryptorchidy_N = mkN "隐睾病" ; -- open-multilingual-wordnet
lin crystal_N = mkN "水晶" ;
lin crystalline_A = mkA "水晶般" ;
lin crystallization_N = mkN "結晶作用" ; -- status=guess
lin crystallize_V = mkV "結晶" ; -- status=guess, src=wikt
lin crystallize_V2 = mkV2 (mkV "結晶") ; -- status=guess, src=wikt
lin ctenidium_N = mkN "栉" | mkN "栉鳃" | mkN "栉齿" ; -- open-multilingual-wordnet
lin cub_N = mkN "幼兽" "个" ;
lin cuba_PN = mkPN "古巴" ;
lin cuban_A = mkA "古巴人" ;
lin cubby_N = mkN "小房间" ; -- open-multilingual-wordnet
lin cubbyhole_N = mkN "小房间" ; -- open-multilingual-wordnet
lin cube_N = mkN "立方" | {-HSK-} mkN "立方体" ;
lin cube_V2 = mkV2 (mkV "三次方") | mkV2 (mkV "三次方") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin cubeb_N = mkN "荜澄茄香烟" ; -- open-multilingual-wordnet
lin cubic_A = mkA "立方体" ;
lin cubism_N = mkN "立體主義" | mkN "立体主义" ; -- status=guess -- status=guess
lin cubist_A = mkA "立体派" ; -- open-multilingual-wordnet
lin cubit_N = mkN "肘尺" | mkN "腕尺" ; -- open-multilingual-wordnet
lin cubitiere_N = mkN "护肘" ; -- open-multilingual-wordnet
lin cuboid_N = mkN "直平行六面体" | mkN "矩形体" | mkN "长方体" ; -- open-multilingual-wordnet
lin cuckold_N = mkN "烏龜" | mkN "乌龟" | mkN "王八" | mkN "綠帽子" | mkN "绿帽子" | mkN "綠帽" | mkN "绿帽" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin cuckold_V2 = mkV2 (mkV "使戴綠帽子") | mkV2 (mkV "使戴绿帽子") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin cuckoo_N = mkN "布谷鸟" "只" ;
lin cucumber_N = mkN "黄瓜" "条" | {-HSK-} mkN "黄瓜" "條" ;
lin cucurbitaceous_A = mkA "葫芦科" ; -- open-multilingual-wordnet
lin cuddle_N = mkN "擁抱" | mkN "拥抱" | mkN "摟抱" | mkN "搂抱" | mkN "偎抱" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin cuddle_V = mkV "輕輕地抱著" | mkV "轻轻地抱着" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin cuddle_V2 = mkV2 (mkV "輕輕地抱著") | mkV2 (mkV "轻轻地抱着") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin cuddy_N = mkN "船室兼厨房" ; -- open-multilingual-wordnet
lin cudgel_N = mkN "棍棒" ; -- open-multilingual-wordnet
lin cudworth_PN = foreignPN "Cudworth" ; -- comment=src=geonames status=guess
lin cue_N = mkN "提示" ;
lin cuff_N = mkN "袖口" | {-mwn-} mkN "翻折部分" ; -- status=guess -- open-multilingual-wordnet
lin cuff_V2 = mkV2 "上袖口" ;
lin cuffley_PN = foreignPN "Cuffley" ; -- comment=src=geonames status=guess
lin cufflink_N = mkN "袖扣" | {-mwn-} mkN "袖口链扣" | mkN "链扣" ; -- status=guess -- open-multilingual-wordnet
lin cuirass_N = mkN "上半身铠甲" | mkN "胸甲" | mkN "胸铠" ; -- open-multilingual-wordnet
lin cuisine_N = mkN "烹饪" | {-HSK-} mkN "菜" "盤" ;
lin cuisse_N = mkN "护腿甲" | mkN "腿甲" ; -- open-multilingual-wordnet
lin cul_N = mkN "死路" | {-mwn-} mkN "尽头" | mkN "末路" | mkN "死胡同" ; -- status=guess -- open-multilingual-wordnet
lin culcheth_PN = foreignPN "Culcheth" ; -- comment=src=geonames status=guess
lin culdoscope_N = mkN "后穹窿镜" | mkN "后陷凹镜" | mkN "陷凹镜" ; -- open-multilingual-wordnet
lin culinary_A = mkA "烹飪" | mkA "烹饪" | mkA "烹調" | mkA "烹调" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cull_V2 = mkV2 (mkV "撲殺") | mkV2 (mkV "扑杀") | mkV2 (mkV "淘汰") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin cullis_N = mkN "天沟" | mkN "屋檐排水槽" | mkN "排水天沟" | mkN "滑槽板" ; -- open-multilingual-wordnet
lin culm_N = mkN "竹茎" | mkN "茎" | mkN "草木茎" ; -- open-multilingual-wordnet
lin culminate_V = mkV "到绝顶" ;
lin culminate_V2 = mkV2 "到达顶点" ;
lin culmination_N = mkN "高潮" ;
lin culotte_N = mkN "女用裙裤" ; -- open-multilingual-wordnet
lin culpability_N = mkN "有罪" | mkN "有过失" ; -- open-multilingual-wordnet
lin culpable_A = mkA "有罪" ;
lin culprit_N = mkN "罪魁祸首" ;
lin cult_N = mkN "祭仪" ;
lin cultivable_A = mkA "可耕" | mkA "适于耕种" ; -- open-multilingual-wordnet
lin cultivar_N = mkN "栽培品系" ; -- open-multilingual-wordnet
lin cultivate_V2 = mkV2 "修" | mkV2 "养成" | {-HSK-} mkV2 "培养" ;
lin cultivation_N = mkN "养殖" ;
lin cultivator_N = mkN "耕田机" ; -- open-multilingual-wordnet
lin cultural_A = mkA "文化" ;
lin culture_N = mkN "培养" | mkN "文化" "個" | mkN "文明" "個" | {-HSK-} mkN "文化" ;
lin cultured_A = mkA "优雅" | mkA "文明" | mkA "文雅" | mkA "有修养" | mkA "有先进文化" | mkA "有教养" | mkA "有礼" | mkA "有礼貌" ; -- open-multilingual-wordnet
lin culverin_N = mkN "火枪" ; -- open-multilingual-wordnet
lin cum_N = mkN "潮吹" | mkN "淫水" | mkN "出水" ; -- status=guess -- status=guess -- status=guess
lin cumberland_PN = mkPN "坎伯蘭" ; -- comment=src=geonames status=guess
lin cumbernauld_PN = foreignPN "Cumbernauld" ; -- comment=src=geonames status=guess
lin cumbersome_A = mkA "笨重" ;
lin cumbria_PN = foreignPN "Cumbria" ; -- comment=src=eng status=guess
lin cumin_N = mkN "孜然" | mkN "安息茴香" | mkN "阿拉伯茴香" ; -- status=guess -- status=guess -- status=guess
lin cummerbund_N = mkN "腹帶" | mkN "腹带" | mkN "裝飾帶" | mkN "装饰带" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cumnock_PN = foreignPN "Cumnock" ; -- comment=src=geonames status=guess
lin cumulative_A = mkA "积累" | {-HSK-} mkA "累积" ;
lin cumuliform_A = mkA "积云状" ; -- open-multilingual-wordnet
lin cuneate_A = mkA "楔形" ; -- open-multilingual-wordnet
lin cuneiform_A = mkA "楔状骨" ; -- open-multilingual-wordnet
lin cuneiform_N = mkN "楔形文字" ; -- status=guess
lin cunnilingus_N = mkN "舔陰" | mkN "舔阴" ; -- status=guess -- status=guess
lin cunning_A = mkA "狡猾" ;
lin cunning_N = mkN "狡猾" ;
lin cunt_N = mkN "屄" | mkN "逼" ; -- status=guess -- status=guess
lin cup_N = mkN "杯" | {-HSK-} mkN "杯子" "個" | mkN "碗" "隻" ;
lin cup_V2 = mkV2 "使+成杯状" ;
lin cupar_PN = foreignPN "Cupar" ; -- comment=src=geonames status=guess
lin cupboard_N = mkN "橱柜" ;
lin cupcake_N = mkN "紙杯蛋糕" | mkN "纸杯蛋糕" | mkN "杯形蛋糕" ; -- status=guess -- status=guess -- status=guess
lin cupflower_N = mkN "杯花" ; -- open-multilingual-wordnet
lin cupful_N = mkN "一杯之量" | mkN "满杯" ; -- open-multilingual-wordnet
lin cupid_PN = foreignPN "Cupid" ; -- comment=src=eng status=guess
lin cupola_N = mkN "穹顶" ; -- open-multilingual-wordnet
lin cupping_N = mkN "拔罐" ; -- status=guess
lin cupric_A = mkA "二价铜" | mkA "含二价铜" ; -- open-multilingual-wordnet
lin cuprite_N = mkN "赤铜矿" ; -- open-multilingual-wordnet
lin cupro_nickel_N = mkN "白铜" | mkN "铜镍合金" ; -- open-multilingual-wordnet
lin cupule_N = mkN "杯形器" | mkN "杯形器具" ; -- open-multilingual-wordnet
lin cur_N = mkN "劣等狗" | mkN "杂种狗" ; -- open-multilingual-wordnet
lin curate_N = mkN "教区牧师" | mkN "牧师" ; -- open-multilingual-wordnet
lin curator_N = mkN "馆长" ;
lin curatorial_A = mkA "监护人" | mkA "管理者" | mkA "负责人" | mkA "馆长" ; -- open-multilingual-wordnet
lin curb_N = mkN "抑制" ;
lin curb_V2 = mkV2 "抑制" ;
lin curbside_N = mkN "路缘人行道" ; -- open-multilingual-wordnet
lin curbstone_N = mkN "路缘石" ; -- open-multilingual-wordnet
lin curdling_N = mkN "凝化" | mkN "凝固" | mkN "凝结" ; -- open-multilingual-wordnet
lin cure_N = mkN "治愈" ;
lin cure_V = mkV "治愈" | {-HSK-} mkV "治疗" ;
lin cure_V2 = mkV2 "治疗" ;
lin curette_N = mkN "刮匙" ; -- open-multilingual-wordnet
lin curfew_N = mkN "宵禁" | mkN "門禁" | mkN "门禁" ; -- status=guess -- status=guess -- status=guess
lin curio_N = mkN "珍品" | mkN "稀有物" ; -- open-multilingual-wordnet
lin curiosity_N = mkN "好奇心" "" ;
lin curious_A = mkA "好奇" ;
lin curitiba_PN = mkPN "庫里奇巴" ; -- comment=src=geonames status=guess
lin curium_N = mkN "鋦" | mkN "锔" ; -- status=guess -- status=guess
lin curl_N = variants {} ;
lin curl_V = mkV "卷曲" ;
lin curl_up_V = mkV "卷起" | mkV "蜷缩" ; -- open-multilingual-wordnet
lin curler_N = mkN "卷发筒" ; -- open-multilingual-wordnet
lin curlew_N = mkN "一种鸟" | mkN "杓鹬" | mkN "杓鹬属候鸟" | mkN "白腰杓鹬" | mkN "麻鹬" ; -- open-multilingual-wordnet
lin curling_N = mkN "冰壺" | mkN "冰壶" ; -- status=guess -- status=guess
lin curly_A = mkA "卷曲" ;
lin currency_N = mkN "货币" ;
lin current_A = mkA "当前" | {-HSK-} mkA "现在" | mkA "行" ;
lin current_1_N = mkN "当前" | {-HSK-} mkN "现在" | mkN "行" ;
lin current_2_N = mkN "当前" | {-HSK-} mkN "现在" | mkN "行" ;
lin curricular_A = mkA "课程" ; -- open-multilingual-wordnet
lin curriculum_N = mkN "课程" "节" ;
lin curriculum_vitae_N = mkN "履历" "份" ;
lin currie_PN = foreignPN "Currie" ; -- comment=src=geonames status=guess
lin curry_N = mkN "咖喱" ; -- status=guess
lin curry_V2 = mkV2 "用咖喱调味" ;
lin currycomb_N = mkN "马梳" ; -- open-multilingual-wordnet
lin curse_N = mkN "诅咒" ;
lin curse_V = mkV "诅咒" ;
lin curse_V2 = mkV2 (mkV "詛咒") | mkV2 (mkV "诅咒") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin cursive_A = mkA "手写体" | mkA "草书" | mkA "草写体" ; -- open-multilingual-wordnet
lin cursor_N = mkN "光标" ; -- open-multilingual-wordnet
lin cursorial_A = mkA "适于行走" ; -- open-multilingual-wordnet
lin curt_A = mkA "简略" ;
lin curtail_V2 = mkV2 "缩短" ;
lin curtain_N = mkN "窗帘" "张" ;
lin curtness_N = mkN "简略" ;
lin curtsey_V = mkV "行屈膝礼" ; -- open-multilingual-wordnet
lin curve_N = mkN "曲线" ;
lin curve_V = {-mwn-} mkV "使卷曲" | mkV "使弯曲" | mkV "使成曲形" | mkV "使成曲线" ; -- open-multilingual-wordnet
lin curve_V2 = variants {} ;
lin curvilineal_A = mkA "曲线" | mkA "由曲线而成" ; -- open-multilingual-wordnet
lin curvy_A = mkA "丰满" | mkA "乳房丰满" | mkA "胸部丰满" ; -- open-multilingual-wordnet
lin cushaw_N = mkN "南瓜" ; -- status=guess
lin cushion_N = mkN "垫子" ;
lin cushion_V2 = mkV2 "给+安上垫子" ;
lin cusp_N = mkN "尖顶" ; -- open-multilingual-wordnet
lin cuspate_A = mkA "尖" | mkA "尖头" | mkA "尖头形" | mkA "尖端" | mkA "有尖头" | mkA "有尖端" ; -- open-multilingual-wordnet
lin cuspidation_N = mkN "叹息" | mkN "尖形饰" | mkN "尖顶饰" ; -- open-multilingual-wordnet
lin cussed_A = mkA "不思悔改" | mkA "不悔悟" | mkA "倔强" | mkA "固执" | mkA "执拗" | mkA "顽固" | mkA "顽固不化" ; -- open-multilingual-wordnet
lin custard_N = mkN "蛋奶糕" | mkN "奶黃" | mkN "奶黄" | mkN "蛋奶凍" | mkN "蛋奶冻" | mkN "卡士達" | mkN "卡士达" | mkN "軟凍" | mkN "软冻" | mkN "卡斯塔德" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin custodial_A = mkA "监护" ;
lin custodian_N = mkN "監護人" | mkN "监护人" ; -- status=guess -- status=guess
lin custody_N = mkN "监护" ;
lin custom_N = mkN "习俗" | {-HSK-} mkN "习惯" "個" ;
lin custom_made_A = mkA "定做" ;
lin customary_A = mkA "惯常" ;
lin customerFem_N = variants {} ; ---- sense to be split
lin customerMasc_N = mkN "顾客" ;
lin customhouse_N = mkN "海关" ; -- open-multilingual-wordnet
lin customize_V2 = mkV2 "定做" ;
lin customs_N = mkN "规矩" | {-HSK-} mkN "關稅" | mkN "关税" | {-mwn-} mkN "海关税" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cut_N = mkN "断开" ;
lin cut_V = mkV "切" | mkV "刻" | mkV "推" | {-HSK-} mkV "断开" ;
lin cut_V2 = L.cut_V2 | {-HSK-} mkV2 "切" | mkV2 "刻" | mkV2 "推" ;
lin cut_across_V2 = prepV2 OP_cut_V OP_across_Prep ; -- guess-p-verb
lin cut_back_V2 = mkV2 (advV OP_cut_V OP_back_Adv ) ; -- guess-p-verb
lin cut_back_on_V2 = prepV2 (advV OP_cut_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_down_V = mkV "砍" | mkV "缩短" ;
lin cut_down_V2 = mkV2 "砍" | mkV2 "缩短" ;
lin cut_down_on_V2 = mkV2 "节省" ;
lin cut_in_V = mkV "插入" | mkV "插嘴" | mkV "超车" ; -- open-multilingual-wordnet
lin cut_in_V2 = prepV2 OP_cut_V OP_in_Prep ; -- guess-p-verb
lin cut_in_on_V2 = prepV2 (advV OP_cut_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_it_out_V2 = variants {} ; -- guess-p-verb
lin cut_off_V = mkV "断" ;
lin cut_off_V2 = mkV2 "断" ;
lin cut_out_V = advV OP_cut_V OP_out_Adv ; -- guess-p-verb
lin cut_out_V2 = prepV2 OP_cut_V OP_out_Prep ; -- guess-p-verb
lin cut_out_on_V2 = prepV2 (advV OP_cut_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_rate_A = mkA "切口" ;
lin cut_up_V = advV OP_cut_V OP_up_Adv ; -- guess-p-verb
lin cut_up_V2 = prepV2 OP_cut_V OP_up_Prep ; -- guess-p-verb
lin cutback_N = mkN "削减" ;
lin cutch_N = mkN "儿茶" | mkN "儿茶膏" | mkN "孩儿茶" | mkN "黑儿茶" ; -- open-multilingual-wordnet
lin cute_A = mkA "可爱" ;
lin cuticular_A = mkA "皮上" | mkA "表皮" ; -- open-multilingual-wordnet
lin cutlassfish_N = mkN "带鱼" ; -- open-multilingual-wordnet
lin cutlery_N = mkN "餐具" | mkN "利器" ; -- status=guess -- status=guess
lin cutlet_N = mkN "豬排" | mkN "猪排" | mkN "豬扒" | mkN "猪扒" | mkN "炸肉片" | mkN "炸肉排" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin cutoff_N = mkN "截止阀" | mkN "断流器" ; -- open-multilingual-wordnet
lin cut_out_N = mkN "剪贴画" ;
lin cutter_N = mkN "刀" "把" ;
lin cutting_N = mkN "切割" ;
lin cuttingly_Adv = mkAdv "尖刻+地" | mkAdv "挖苦+地" ; -- open-multilingual-wordnet
lin cuttlefish_N = mkN "烏賊" | mkN "乌贼" | {-mwn-} mkN "墨鱼" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cutwork_N = mkN "挖花刺绣" | mkN "空花绣" | mkN "雕空绣" | mkN "雕绣" ; -- open-multilingual-wordnet
lin cutworm_N = mkN "地蠶" | mkN "地蚕" | {-mwn-} mkN "切根虫" | mkN "糖蛾" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cwmbran_PN = foreignPN "Cwmbran" ; -- comment=src=geonames status=guess
lin cyan_N = mkN "青色" ; -- status=guess
lin cyanide_N = mkN "氰化物" ; -- status=guess
lin cyanobacterial_A = mkA "蓝藻类" ; -- open-multilingual-wordnet
lin cyanogen_N = mkN "氰" ; -- open-multilingual-wordnet
lin cyanogenetic_A = mkA "生氰" ; -- open-multilingual-wordnet
lin cyanohydrin_N = mkN "羟腈" ; -- open-multilingual-wordnet
lin cyanosis_N = mkN "黄萎病" ; -- open-multilingual-wordnet
lin cyberart_N = mkN "计算机技术" ; -- open-multilingual-wordnet
lin cybercrime_N = mkN "網絡犯罪" | mkN "网络犯罪" ; -- status=guess -- status=guess
lin cybernetic_A = mkA "人工头脑学" | mkA "控制论" ; -- open-multilingual-wordnet
lin cybernetics_N = mkN "控制論" | mkN "控制论" ; -- status=guess -- status=guess
lin cyberphobia_N = mkN "电脑恐惧症" ; -- open-multilingual-wordnet
lin cybersex_N = mkN "电脑性刺激" | mkN "网爱" | mkN "网络性行为" | mkN "网络色情" ; -- open-multilingual-wordnet
lin cyborg_N = mkN "賽博格" | mkN "赛博格" | mkN "生化人" ; -- status=guess -- status=guess -- status=guess
lin cyclamen_N = mkN "仙客來" | mkN "仙客来" ; -- status=guess -- status=guess
lin cycle_N = mkN "周期" ;
lin cycle_V = mkV "使+循环" ;
lin cyclical_A = mkA "周期性" ;
lin cycling_N = mkN "自行車運動" | mkN "自行车运动" ; -- status=guess -- status=guess
lin cyclist_N = mkN "骑自行车的人" ;
lin cyclohexanol_N = mkN "环己醇" ; -- open-multilingual-wordnet
lin cycloid_A = mkA "圆形" ; -- open-multilingual-wordnet
lin cycloid_N = mkN "圆滚线" | mkN "摆线" | mkN "旋轮线" | mkN "轮转线" ; -- open-multilingual-wordnet
lin cyclone_N = mkN "氣旋" | mkN "气旋" | mkN "龍捲風" | mkN "龙卷风" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin cyclonic_A = mkA "旋风" | mkA "飓风" ; -- open-multilingual-wordnet
lin cyclopaedia_N = mkN "百科" ; -- status=guess
lin cyclopean_A = mkA "独眼巨人" | mkA "独眼巨人库克罗普斯" ; -- open-multilingual-wordnet
lin cyclopia_N = mkN "独眼畸形" ; -- open-multilingual-wordnet
lin cyclopropane_N = mkN "环丙烷" ; -- open-multilingual-wordnet
lin cyclops_N = mkN "獨眼巨人" | mkN "独眼巨人" | mkN "庫克洛普斯" | mkN "库克洛普斯" | mkN "賽克洛斯" | mkN "赛克洛斯" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin cycloserine_N = mkN "环丝氨酸" ; -- open-multilingual-wordnet
lin cyclothymia_N = mkN "循环性精神病" ; -- open-multilingual-wordnet
lin cyclothymic_A = mkA "循环性精神病" ; -- open-multilingual-wordnet
lin cyclotron_N = mkN "迴旋加速器" | mkN "回旋加速器" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin cylinder_N = mkN "圆柱" ;
lin cyma_N = mkN "反曲线脚" ; -- open-multilingual-wordnet
lin cymbal_N = mkN "鐃鈸" | mkN "铙钹" ; -- status=guess -- status=guess
lin cyme_N = mkN "聚伞花序" ; -- open-multilingual-wordnet
lin cymene_N = mkN "对异丙基甲苯" ; -- open-multilingual-wordnet
lin cymule_N = mkN "小聚伞" ; -- open-multilingual-wordnet
lin cynic_N = mkN "愤青" ; -- status=guess
lin cynical_A = mkA "愤世嫉俗" ;
lin cynicism_N = mkN "玩世不恭" ;
lin cynophobia_N = mkN "恐犬症" ; -- open-multilingual-wordnet
lin cynthia_PN = foreignPN "Cynthia" ; -- comment=src=eng status=guess
lin cypress_N = mkN "柏樹" | mkN "柏树" ; -- status=guess -- status=guess
lin cyprinid_A = mkA "鲤科" ; -- open-multilingual-wordnet
lin cyprus_PN = mkPN "賽普勒斯" ; -- comment=src=geonames status=guess
lin cyril_PN = foreignPN "Cyril" ; -- comment=src=geonames status=guess
lin cyst_N = mkN "囊腫" | mkN "囊肿" ; -- status=guess -- status=guess
lin cysteine_N = mkN "半胱氨酸" ; -- open-multilingual-wordnet
lin cystic_A = mkA "囊" | mkA "囊状" | mkA "胞" | mkA "胞囊" | mkA "胞状" ; -- open-multilingual-wordnet
lin cystine_N = mkN "双硫丙氨酸" ; -- open-multilingual-wordnet
lin cystitis_N = mkN "膀胱炎" ; -- open-multilingual-wordnet
lin cystocele_N = mkN "膀胱突出症" ; -- open-multilingual-wordnet
lin cystoplegia_N = mkN "膀胱麻痹" ; -- open-multilingual-wordnet
lin cytochrome_N = mkN "细胞色素" ; -- open-multilingual-wordnet
lin cytogenesis_N = mkN "细胞发生" | mkN "细胞生成" ; -- open-multilingual-wordnet
lin cytogenetic_A = mkA "细胞发生" | mkA "细胞生成" | mkA "细胞遗传学" ; -- open-multilingual-wordnet
lin cytokine_N = mkN "细胞因子" ; -- open-multilingual-wordnet
lin cytokinetic_A = mkA "细胞动力学" ; -- open-multilingual-wordnet
lin cytological_A = mkA "细胞学" ; -- open-multilingual-wordnet
lin cytology_N = mkN "細胞學" | mkN "细胞学" ; -- status=guess -- status=guess
lin cytolysin_N = mkN "溶细胞素" ; -- open-multilingual-wordnet
lin cytolysis_N = mkN "细胞溶解" ; -- open-multilingual-wordnet
lin cytolytic_A = mkA "溶细胞" | mkA "细胞溶解" ; -- open-multilingual-wordnet
lin cytopenia_N = mkN "血球减少" | mkN "血细胞减少" ; -- open-multilingual-wordnet
lin cytophotometer_N = mkN "细胞光度计" ; -- open-multilingual-wordnet
lin cytophotometric_A = mkA "细胞光度学" ; -- open-multilingual-wordnet
lin cytoplasm_N = mkN "細胞質" | mkN "细胞质" ; -- status=guess -- status=guess
lin cytoplasmic_A = mkA "细胞质" ; -- open-multilingual-wordnet
lin cytoplastic_A = mkA "细胞质" | mkA "胞体质" ; -- open-multilingual-wordnet
lin cytosine_N = mkN "胞嘧啶" ; -- status=guess
lin cytotoxic_A = mkA "细胞毒" | mkA "细胞毒素" ; -- open-multilingual-wordnet
lin cytotoxicity_N = mkN "细胞毒性" ; -- open-multilingual-wordnet
lin cytotoxin_N = mkN "细胞毒素" ; -- open-multilingual-wordnet
lin czar_N = mkN "沙皇" ;
lin czarist_A = mkA "俄国帝制" | mkA "沙皇制" ; -- open-multilingual-wordnet
lin czech_A = mkA "捷克" ;
lin czech_N = mkN "捷克语" ;
lin czechoslovak_A = mkA "捷克斯洛伐克" ;
lin czechoslovak_N = mkN "捷克斯洛伐克" ;
lin czechoslovakia_PN = foreignPN "Czechoslovakia" ; -- comment=src=eng status=guess
lin d_day_PN = foreignPN "D-day" ; -- comment=src=eng status=guess
lin dab_N = mkN "比目魚" | mkN "黃蓋鰈" ; -- status=guess -- status=guess
lin dab_V = mkV "敷" | {-mwn-} mkV "拍" | mkV "轻击" | mkV "轻叩" | mkV "轻抚" | mkV "轻拍" | mkV "轻按" | mkV "轻摸" | mkV "轻敲" | mkV "轻触" ; -- status=guess, src=wikt -- open-multilingual-wordnet
lin dab_V2 = mkV2 "轻拍" ;
lin dabble_V = mkV "溅湿" ;
lin dabble_V2 = mkV2 (mkV "玩水") | mkV2 (mkV "濺濕") | mkV2 (mkV "溅湿") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin dacca_PN = foreignPN "Dacca" ; -- comment=src=eng status=guess
lin dacha_N = mkN "達恰" | mkN "达恰" | {-mwn-} mkN "俄国的乡间邸宅" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dachshund_N = mkN "臘腸犬" | mkN "腊肠犬" | {-mwn-} mkN "达克斯猎狗" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dacite_N = mkN "石英安山岩" | mkN "英安岩" ; -- open-multilingual-wordnet
lin dacitic_A = mkA "石英安山岩" | mkA "英安岩" ; -- open-multilingual-wordnet
lin dacoity_N = mkN "土匪劫掠" | mkN "强盗行为" | mkN "武装团伙抢劫" | mkN "武装抢劫" ; -- open-multilingual-wordnet
lin dacryocystitis_N = mkN "窍漏症" ; -- open-multilingual-wordnet
lin dactylic_A = mkA "扬抑抑格" | mkA "长短短格" ; -- open-multilingual-wordnet
lin dactylomegaly_N = mkN "巨指" | mkN "巨趾" ; -- open-multilingual-wordnet
lin dad_N = mkN "爸爸" ;
lin daddy_N = mkN "爸" "个" ;
lin daedal_A = mkA "千变万化" | mkA "巧妙" | mkA "灵巧" | mkA "纷繁" | mkA "错综复杂" ; -- open-multilingual-wordnet
lin daffodil_N = mkN "黃水仙" | mkN "黄水仙" ; -- status=guess -- status=guess
lin dagger_N = mkN "短劍" | mkN "短剑" | mkN "匕首" | mkN "短刀" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin daggerboard_N = mkN "活动披水板" ; -- open-multilingual-wordnet
lin dahlia_N = mkN "大麗花" | mkN "大丽花" ; -- status=guess -- status=guess
lin daily_A = mkA "日常" | {-HSK-} mkA "经常" ;
lin daily_Adv = mkAdv "日常" | {-HSK-} mkAdv "经常" ;
lin daily_N = mkN "日常" | mkN "经常" | {-HSK-} mkN "日常" [] ;
lin dairy_N = mkN "奶制品" ;
lin dais_N = mkN "讲台" ; -- open-multilingual-wordnet
lin daisy_N = mkN "雛菊" | mkN "雏菊" ; -- status=guess -- status=guess
lin daisy_PN = foreignPN "Daisy" ; -- comment=src=eng status=guess
lin daisylike_A = mkA "似雏菊" | mkA "雏菊似" ; -- open-multilingual-wordnet
lin dakar_PN = mkPN "達喀爾" ; -- comment=src=geonames status=guess
lin dakota_PN = foreignPN "Dakota" ; -- comment=src=eng status=guess
lin dalasi_N = mkN "达拉西" ; -- open-multilingual-wordnet
lin dale_N = mkN "山谷" ; -- status=guess
lin dalkeith_PN = foreignPN "Dalkeith" ; -- comment=src=geonames status=guess
lin dallas_PN = mkPN "达拉斯" ;
lin dalliance_N = mkN "戏弄" ;
lin dally_V = mkV "游戏" | mkV "玩" | mkV "玩弄" | mkV "调情" ; -- open-multilingual-wordnet
lin dalmatian_N = mkN "达尔马提亚狗" | mkN "达尔马西亚狗" ; -- open-multilingual-wordnet
lin dalry_PN = foreignPN "Dalry" ; -- comment=src=geonames status=guess
lin dalton_PN = foreignPN "Dalton" ; -- comment=src=geonames status=guess
lin dam_N = mkN "坝" ;
lin damage_N = mkN "损失" | {-HSK-} mkN "损失" "個" | mkN "破坏" ;
lin damage_V2 = mkV2 "损坏" | {-HSK-} mkV2 "损失" ;
lin damages_N = mkN "补偿" | mkN "补偿金" | mkN "赔偿" | mkN "赔偿金" ; -- open-multilingual-wordnet
lin damaging_A = variants {} ;
lin damascene_N = mkN "波形花纹" | mkN "金银镶花" ; -- open-multilingual-wordnet
lin damascus_PN = mkPN "大马士革" ; -- comment=src=geonames status=guess
lin damask_N = mkN "缎子" | mkN "花布" | mkN "花缎" | mkN "锦锻" ; -- open-multilingual-wordnet
lin dammar_N = mkN "达马树脂" | mkN "达马脂" ; -- open-multilingual-wordnet
lin dammit_Interj = mkInterj "該死" | mkInterj "该死" ; -- status=guess -- status=guess
lin damn_A = mkA "可恶" ;
lin damn_Adv = mkAdv "该死" ;
lin damn_Interj = mkInterj "该死的" ;
lin damn_N = mkN "诅咒" ;
lin damn_V2 = variants {} ;
lin damned_Adv = mkAdv "非常" ;
lin damocles_PN = foreignPN "Damocles" ; -- comment=src=eng status=guess
lin damourite_N = mkN "变白云母" | mkN "细鳞白云母" ; -- open-multilingual-wordnet
lin damp_A = mkA "潮湿" ;
lin damp_N = mkN "湿" | mkN "湿气" | mkN "潮湿" ; -- open-multilingual-wordnet
lin damp_V = mkV "变潮湿" ;
lin damp_V2 = mkV2 "潮湿" ;
lin dampen_V = mkV "抑制" ;
lin dampen_V2 = mkV2 "抑制" ;
lin dampener_N = mkN "湿润器" ; -- open-multilingual-wordnet
lin damper_N = mkN "减震器" ;
lin dampish_A = mkA "微湿" | mkA "微潮" | mkA "有些潮" | mkA "有些潮湿" | mkA "有湿气" | mkA "湿润" | mkA "潮湿" ; -- open-multilingual-wordnet
lin dampness_N = mkN "湿" | mkN "湿气" | mkN "潮湿" ; -- open-multilingual-wordnet
lin damselfish_N = mkN "雀鲷" ; -- open-multilingual-wordnet
lin damselfly_N = mkN "灯心蜻蜓" | mkN "豆娘" | mkN "豆娘蜓" ; -- open-multilingual-wordnet
lin dan_PN = foreignPN "Dan" ; -- comment=src=eng status=guess
lin danaid_N = mkN "斑蝶" ; -- open-multilingual-wordnet
lin dance_N = mkN "舞蹈" ;
lin dance_V = mkV "跳舞" ;
lin dance_V2 = mkV2 "跳舞" ;
lin danceable_A = mkA "适于跳舞" | mkA "适合跳舞" ; -- open-multilingual-wordnet
lin dancer_N = mkN "舞蹈家" ;
lin dancing_N = mkN "跳舞" ;
lin dandelion_N = mkN "蒲公英" ; -- status=guess
lin dandruff_N = mkN "頭皮屑" | mkN "头皮屑" ; -- status=guess -- status=guess
lin dandy_A = mkA "花心" ;
lin danger_N = mkN "危险" ;
lin dangerous_A = mkA "危险" ;
lin dangle_V = mkV "吊着" ;
lin dangle_V2 = mkV2 "摇晃地悬挂着" ;
lin daniel_PN = foreignPN "Daniel" ; -- comment=src=eng status=guess
lin danishFem_N = variants {} ; ---- sense to be split
lin danishMasc_N = variants {} ; ---- sense to be split
lin danish_A = mkA "丹麦" ;
lin dankness_N = mkN "湿阴" ; -- open-multilingual-wordnet
lin danny_PN = foreignPN "Danny" ; -- comment=src=eng status=guess
lin daphne_PN = mkPN "达芙妮" ; -- comment=src=geonames status=guess
lin daphnia_N = mkN "水蚤" | mkN "红虫" | mkN "金鱼虫" ; -- open-multilingual-wordnet
lin dapper_A = mkA "短小精悍" ;
lin dapsone_N = mkN "氨苯砜" ; -- open-multilingual-wordnet
lin daraf_N = mkN "倒法拉" | mkN "拉法" ; -- open-multilingual-wordnet
lin darby_PN = foreignPN "Darby" ; -- comment=src=geonames status=guess
lin dare_N = mkN "挑战""项" ;
lin dare_V2 = mkV2 "敢" ;
lin dare_VV = mkVV "敢" ;
lin daredevil_N = mkN "膽大妄為的人" | mkN "胆大妄为的人" | mkN "鋌而走險的人" | mkN "铤而走险的人" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin darenth_PN = foreignPN "Darenth" ; -- comment=src=eng status=guess
lin darfield_PN = foreignPN "Darfield" ; -- comment=src=geonames status=guess
lin daring_N = mkN "敢" ;
lin dark_A = mkA "暗" | {-HSK-} mkA "黑" ;
lin dark_N = mkN "暗" | mkN "黑" | {-HSK-} mkN "暗" "" ;
lin darkish_A = mkA "微暗" | mkA "有点黑" | mkA "浅黑" ; -- open-multilingual-wordnet
lin darkness_N = mkN "黑暗" ;
lin darkroom_N = mkN "暗室" ;
lin darling_N = mkN "宝贝" | {-HSK-} mkN "心爱的人" ;
lin darlington_PN = mkPN ("达林顿" | "達靈頓") ; -- comment=src=geonames status=guess
lin darmstadt_PN = mkPN "达姆施塔特" ; -- comment=src=geonames status=guess
lin darmstadtium_N = mkN "鐽 钅达" ; -- status=guess
lin darn_N = mkN "补丁" ; -- open-multilingual-wordnet
lin darn_V = mkV "織補" | mkV "织补" | mkV "縫補" | mkV "缝补" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin darn_V2 = mkV2 "织补" ;
lin dart_N = mkN "飞镖" "枚" ;
lin dartboard_N = mkN "靶" ; -- open-multilingual-wordnet
lin darter_N = mkN "突进物" | mkN "突进者" | mkN "行动迅速者" ; -- open-multilingual-wordnet
lin dartford_PN = mkPN "達特福德" ; -- comment=src=geonames status=guess
lin dartmouth_PN = foreignPN "Dartmouth" ; -- comment=src=geonames status=guess
lin darts_N = mkN "飛鏢" | mkN "飞镖" ; -- status=guess -- status=guess
lin darwen_PN = foreignPN "Darwen" ; -- comment=src=geonames status=guess
lin dash_N = mkN "破折号" ;
lin dash_V = mkV "猛撞" | {-HSK-} mkV "闯" ;
lin dashboard_N = mkN "仪表板" ;
lin dashiki_N = mkN "大席吉装" ; -- open-multilingual-wordnet
lin data_N = mkN "数据" | {-HSK-} mkN "材料" "個" | mkN "资料" "份" ;
lin database_N = mkN "数据库" "个" ;
lin date_1_N = variants {} ;
lin date_3_N = variants {} ;
lin date_7_N = {-mwn-} mkN "枣儿" | mkN "海枣" | mkN "金枣" ; -- open-multilingual-wordnet
lin date_N = mkN "日期" ;
lin date_V = mkV "约会" ;
lin date_V2 = mkV2 "与+约会" ;
lin dating_N = mkN "婚姻介紹所" | mkN "婚姻介绍所" | mkN "婚介所" ; -- status=guess -- status=guess -- status=guess
lin dative_N = mkN "與格" | mkN "与格" ; -- status=guess -- status=guess
lin datum_N = mkN "基准" ;
lin daub_N = mkN "乱画的画" | mkN "劣画" | mkN "拙劣的画" ; -- open-multilingual-wordnet
lin daughter_N = mkN "女儿" | {-HSK-} mkN "姑娘" "個" ;
lin daunt_V2 = mkV2 "使+气馁" ;
lin davallia_N = mkN "山椿" | mkN "山茶" | mkN "晚山茶" | mkN "曼佗罗树" | mkN "洋茶" | mkN "耐冬" | mkN "茶花" | mkN "薮春" ; -- open-multilingual-wordnet
lin dave_PN = foreignPN "Dave" ; -- comment=src=eng status=guess
lin davenport_N = mkN "坐卧两用沙发" | mkN "坐卧两用的长沙发" ; -- open-multilingual-wordnet
lin daventry_PN = foreignPN "Daventry" ; -- comment=src=geonames status=guess
lin davey_PN = foreignPN "Davey" ; -- comment=src=eng status=guess
lin david_PN = foreignPN "David" ; -- comment=src=geonames status=guess
lin davit_N = mkN "吊艇柱" | mkN "吊柱" | mkN "吊艇架" | mkN "吊架" | mkN "吊艇杆" | mkN "吊杆" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin dawdle_V = mkV "混日子" ;
lin dawley_PN = foreignPN "Dawley" ; -- comment=src=eng status=guess
lin dawlish_PN = foreignPN "Dawlish" ; -- comment=src=geonames status=guess
lin dawn_N = mkN "黎明" ;
lin dawn_PN = foreignPN "Dawn" ; -- comment=src=eng status=guess
lin dawn_V = mkV "黎明" ;
lin day_N = L.day_N | {-HSK-} mkN "日" ;
lin daybook_N = mkN "总帐" | mkN "日记簿" ; -- open-multilingual-wordnet
lin daybreak_N = mkN "破晓" ;
lin daydream_V = mkV "白日梦" ; -- status=guess, src=wikt
lin daylight_N = mkN "阳光" ;
lin days_N = mkN "时期""个" ;
lin dayspring_N = mkN "天亮" | mkN "开端" | mkN "拂晓" | mkN "早晨" | mkN "破晓" | mkN "黎明" ; -- open-multilingual-wordnet
lin daytime_N = mkN "白天" | mkN "日間" | mkN "日间" | {-mwn-} mkN "白昼" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin dayton_PN = mkPN "代顿" ; -- comment=src=geonames status=guess
lin daze_N = mkN "发呆" ;
lin daze_V2 = mkV2 (mkV "使茫然") | mkV2 (mkV "使發昏") | mkV2 (mkV "使发昏") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin dazzle_V2 = mkV2 "炫" ;
lin de_emphasize_V2 = mkV2 "不再强调" ;
lin de_facto_A = mkA "实际" ;
lin deactivate_V2 = mkV2 "关闭" ;
lin dead_A = mkA "僵死" ;
lin dead_Adv = mkAdv "死" ;
lin dead_N = mkN "死者""位" ;
lin deadeye_N = mkN "三孔滑车" | mkN "三眼木盘" ; -- open-multilingual-wordnet
lin deadhead_N = mkN "空车" ; -- open-multilingual-wordnet
lin deadlight_N = mkN "甲板厚玻璃窗" | mkN "舷窗内盖" | mkN "舷窗外盖" ; -- open-multilingual-wordnet
lin deadline_N = mkN "期限" ;
lin deadlock_N = mkN "僵局" ;
lin deadlock_V = mkV "相持不下" ;
lin deadlocked_A = mkA "僵持" ;
lin deadly_A = mkA "致命" ;
lin deadpan_A = mkA "故作嚴肅" | mkA "故作严肃" ; -- status=guess -- status=guess
lin deaf_A = mkA "聋" ;
lin deafen_V2 = mkV2 "使+聋" ;
lin deafness_N = mkN "聾" | mkN "聋" ; -- status=guess -- status=guess
lin deal_N = mkN "合约" ;
lin deal_PN = foreignPN "Deal" ; -- comment=src=geonames status=guess
lin deal_V = mkV "处理" ;
lin deal_V2 = mkV2 "对待" ;
lin dealer_N = mkN "零售商" ;
lin dealignment_N = mkN "解散联盟" ; -- open-multilingual-wordnet
lin dealing_N = mkN "处理" ;
lin deamination_N = mkN "去氨基" ; -- open-multilingual-wordnet
lin dean_N = mkN "院长" ;
lin dean_PN = foreignPN "Dean" ; -- comment=src=eng status=guess
lin dear_A = mkA "亲爱" ;
lin dear_Adv = mkAdv "高价" ;
lin dear_Interj = variants {} ;
lin dear_N = mkN "亲爱" "个" ;
lin dearth_N = mkN "缺乏" ;
lin death_N = mkN "死亡" ;
lin deathbed_N = mkN "臨終床" | mkN "临终床" ; -- status=guess -- status=guess
lin deathly_A = variants {} ;
lin deathly_Adv = adjAdv deathly_A ; -- derived
lin death_rate_N = mkN "死亡率" ; -- open-multilingual-wordnet
lin deathtrap_N = mkN "危险的地方" | mkN "危险的建筑物" | mkN "非常危险的场所" ; -- open-multilingual-wordnet
lin debasement_N = mkN "堕落" ;
lin debatable_A = mkA "值得商榷" ;
lin debate_N = mkN "争论" "次" | mkN "辩论" "場" | {-HSK-} mkN "辩论" ;
lin debate_V = mkV "争论" | {-HSK-} mkV "辩论" ;
lin debate_V2 = mkV2 "争论" ;
lin debaucheeFem_N = variants {} ; ---- sense to be split
lin debaucheeMasc_N = variants {} ; ---- sense to be split
lin debauchery_N = mkN "淫逸" | mkN "邪淫" | mkN "酒色" | mkN "放蕩" | mkN "放荡" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin debbie_PN = foreignPN "Debbie" ; -- comment=src=eng status=guess
lin debby_PN = foreignPN "Debby" ; -- comment=src=eng status=guess
lin debenture_N = mkN "债券" ;
lin debility_N = mkN "衰弱" ; -- open-multilingual-wordnet
lin debit_N = mkN "借記" | mkN "借记" ; -- status=guess -- status=guess
lin debonair_A = mkA "快乐" | mkA "快活" | mkA "愉快" | mkA "活泼" ; -- open-multilingual-wordnet
lin deborah_PN = foreignPN "Deborah" ; -- comment=src=eng status=guess
lin debris_N = mkN "碎片" ;
lin debt_N = mkN "债务" ;
lin debtor_N = mkN "债务人" ;
lin debug_V2 = mkV2 (mkV "調試") | mkV2 (mkV "调试") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin debugger_N = mkN "調試器" | mkN "调试器" | mkN "調試程序" | mkN "调试程序" | mkN "調試工具" | mkN "调试工具" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin debunk_V2 = mkV2 "揭穿" ;
lin debut_1_N = mkN "首次亮相" ;
lin debut_2_N = mkN "首次亮相" ;
lin debut_V2 = mkV2 "初次登台" ;
lin debutante_N = variants {} ;
lin dec_PN = foreignPN "Dec" ; -- comment=src=eng status=guess
lin decade_N = mkN "数十年" ;
lin decadence_N = mkN "颓废" ;
lin decadent_A = mkA "颓废" ;
lin decagon_N = mkN "十角形" | mkN "十边形" ; -- open-multilingual-wordnet
lin decahedron_N = mkN "十面體" | mkN "十面体" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin decal_N = mkN "印花样" | mkN "印花法" ; -- open-multilingual-wordnet
lin decalcification_N = mkN "脱钙" ; -- open-multilingual-wordnet
lin decameter_N = mkN "公丈" | mkN "十米" ; -- open-multilingual-wordnet
lin decanter_N = mkN "饮料瓶" ; -- open-multilingual-wordnet
lin decapitate_V2 = mkV2 (mkV "砍頭") | mkV2 (mkV "砍头") | mkV2 (mkV "斬首") | mkV2 (mkV "斩首") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin decapitation_N = mkN "斬首" | mkN "斩首" | mkN "斬罪" | mkN "斩罪" | mkN "斷頭" | mkN "断头" | mkN "杀头" | mkN "殺頭" | mkN "問斬" | mkN "问斩" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin decarboxylase_N = mkN "羧化酶" ; -- open-multilingual-wordnet
lin decarboxylation_N = mkN "去碳酸基" | mkN "脱羧作用" ; -- open-multilingual-wordnet
lin decasyllabic_A = mkA "十音节" ; -- open-multilingual-wordnet
lin decay_N = mkN "衰退" "次" ;
lin decay_V = mkV "腐烂" ; -- status=guess, src=wikt
lin decease_N = mkN "死" | mkN "死亡" ; -- open-multilingual-wordnet
lin decease_V = mkV "死" ;
lin deceased_A = mkA "已故" ; -- status=guess
lin deceive_V2 = mkV2 "欺骗" | {-HSK-} mkV2 "骗" ;
lin deceiver_N = mkN "欺詐者" | mkN "欺诈者" ; -- status=guess -- status=guess
lin decelerate_V = mkV "减速" ;
lin deceleration_N = mkN "減速" | mkN "减速" ; -- status=guess -- status=guess
lin decency_N = mkN "体面" "" ;
lin decent_A = mkA "像样" | {-HSK-} mkA "合适" ;
lin decentralization_N = mkN "下放" ;
lin decentralize_V2 = mkV2 "分散" ;
lin deception_N = mkN "欺骗" ; -- comment="欺诈" ;
lin deceptive_A = mkA "骗人" ;
lin decibel_N = mkN "分贝" ; -- open-multilingual-wordnet
lin decide_V = mkV "决定" | {-HSK-} mkV "判断" ;
lin decide_V2 = mkV2 "决定" | {-HSK-} mkV2 "判断" ;
lin decide_VS = mkVS "决定" | {-HSK-} mkVS "判断" ;
lin decide_VV = mkVV "决定" | {-HSK-} mkVV "判断" ;
lin decide_on_V2 = prepV2 OP_decide_V OP_on_Prep ; -- guess-p-verb
lin decide_upon_V2 = prepV2 OP_decide_V OP_upon_Prep ; -- guess-p-verb
lin decided_A = mkA "决定" ;
lin deciduous_A = mkA "落葉喬木" | mkA "落叶乔木" ; -- status=guess -- status=guess
lin decigram_N = mkN "公克" ; -- open-multilingual-wordnet
lin deciliter_N = mkN "1/10公升" ; -- open-multilingual-wordnet
lin decimal_A = mkA "十进制" ;
lin decimal_N = mkN "小數" | mkN "小数" | {-mwn-} mkN "十进制数" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin decimate_V2 = mkV2 "毁掉大部分" ;
lin decimeter_N = mkN "分米" ; -- open-multilingual-wordnet
lin decipher_V2 = mkV2 (mkV "解碼") | mkV2 (mkV "解码") | mkV2 (mkV "解讀") | mkV2 (mkV "解读") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin decision_N = mkN "主意" "個" | mkN "决定" "個" | {-HSK-} mkN "决定" ;
lin decision_making_N = variants {} ;
lin decisive_A = mkA "坚定" ;
lin decisiveness_N = mkN "果斷" | mkN "果断" ; -- status=guess -- status=guess
lin deck_N = mkN "甲板" ;
lin deck_V2 = mkV2 "装饰" ;
lin deckle_N = mkN "定边装置" ; -- open-multilingual-wordnet
lin declamatory_A = mkA "做作" | mkA "夸大" | mkA "夸夸其谈" | mkA "浮夸" | mkA "空洞" | mkA "说大话" ; -- open-multilingual-wordnet
lin declaration_N = mkN "声明" ;
lin declare_V = mkV "声明" | {-HSK-} mkV "宣布" | mkV "布" ;
lin declare_V2 = mkV2 "声明" | {-HSK-} mkV2 "宣布" | mkV2 "布" ;
lin declare_VS = mkVS "声明" | {-HSK-} mkVS "宣布" | mkVS "布" ;
lin declassify_V2 = mkV2 "解密" ;
lin declension_N = mkN "變格" | mkN "变格" ; -- status=guess -- status=guess
lin decline_N = mkN "拒绝" ;
lin decline_V = mkV "下" | mkV "却" | mkV "拒绝" | mkV "推" | mkV "退" | {-HSK-} mkV "下降" ;
lin decline_V2 = mkV2 "下" | mkV2 "却" | mkV2 "拒绝" | mkV2 "推" | mkV2 "退" | {-HSK-} mkV2 "下降" ;
lin decline_VV = mkVV "下" | mkVV "却" | mkVV "拒绝" | mkVV "推" | mkVV "退" | {-HSK-} mkVV "下降" ;
lin declivitous_A = mkA "向下倾斜" | mkA "相当陡" ; -- open-multilingual-wordnet
lin decoction_N = mkN "浓缩" | mkN "煎煮" | mkN "煎熬" ; -- open-multilingual-wordnet
lin decode_V2 = mkV2 "翻" ;
lin decolletage_N = mkN "低领" ; -- open-multilingual-wordnet
lin decompose_V = mkV "烂" ;
lin decompose_V2 = mkV2 "烂" ;
lin decompound_A = mkA "再混合" | mkA "多回分裂" | mkA "多回复出" ; -- open-multilingual-wordnet
lin decompression_N = mkN "減壓病" | mkN "减压症" | mkN "减压症" | {-mwn-} mkN "减压" | mkN "解压" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin decongestant_N = mkN "减充血的药剂" ; -- open-multilingual-wordnet
lin deconstructionist_A = mkA "解构主义" ; -- open-multilingual-wordnet
lin decontaminate_V2 = mkV2 "净化" ;
lin decontamination_N = mkN "净化" | mkN "去污" | mkN "排除污染" | mkN "消除污染" ; -- open-multilingual-wordnet
lin decorate_V2 = mkV2 "修" | mkV2 "打扮" | mkV2 "装饰" ;
lin decoration_N = mkN "装饰" ;
lin decorative_A = mkA "装饰" | {-HSK-} mkA "装饰性" ;
lin decorator_N = mkN "装饰者" ;
lin decorum_N = mkN "礼仪" "种" ;
lin decoy_N = mkN "囮子" ; -- status=guess
lin decrease_N = mkN "减少" | {-HSK-} mkN "缩小" ;
lin decrease_V = mkV "减少" ;
lin decrease_V2 = mkV2 "减少" ; -- comment="减小" ;
lin decree_N = mkN "法令" "条" ;
lin decree_V2 = mkV2 "颁布" ;
lin decree_nisi_N = mkN "法令" "条" ;
lin decrepit_A = mkA "破舊" | mkA "破旧" | mkA "衰老" | mkA "老弱" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin decrepitude_N = mkN "老弱" | mkN "老朽" | mkN "腐朽" | mkN "虚弱" | mkN "衰弱" | mkN "衰老" ; -- open-multilingual-wordnet
lin decrescendo_A = mkA "渐弱" ; -- open-multilingual-wordnet
lin decribe_V2 = mkV2 "描述" ;
lin decry_V2 = mkV2 "诽谤" ;
lin dedicate_V2 = mkV2 "奉献" | {-HSK-} mkV2 "贡献" ;
lin dedication_N = mkN "奉献" "" ;
lin dedifferentiation_N = mkN "使不分化" | mkN "去分化" | mkN "反分化" ; -- open-multilingual-wordnet
lin deduct_V2 = mkV2 "扣除" ;
lin deductible_A = mkA "扣税" ;
lin deduction_N = mkN "扣除" ;
lin deductive_A = mkA "推論" | mkA "推理" ; -- status=guess -- status=guess
lin deed_N = mkN "作为" | {-HSK-} mkN "行动" ;
lin deem_V2 = mkV2 "认为" ;
lin deem_V2A = mkV2A "认为" ;
lin deem_V2V = mkV2V "认为" ;
lin deep_A = mkA "大" | mkA "深" | mkA "深刻" ;
lin deep_Adv = mkAdv "大" | mkAdv "深" | mkAdv "深刻" ;
lin deep_N = mkN "大" | mkN "深" | mkN "深刻" | {-HSK-} mkN "深处""" ;
lin deep_seated_A = mkA "根深蒂固" ;
lin deepen_V = mkV "深化" ;
lin deepen_V2 = mkV2 (mkV "深化") ; -- status=guess, src=wikt
lin deepening_N = mkN "加深" | mkN "延深" | mkN "深入" ; -- open-multilingual-wordnet
lin deer_N = mkN "鹿" ;
lin deerskin_N = mkN "鹿皮" ; -- open-multilingual-wordnet
lin deerstalker_N = mkN "猎鹿帽" ; -- status=guess -- open-multilingual-wordnet
lin defacement_N = mkN "变丑" | mkN "损形" | mkN "毁容" ; -- open-multilingual-wordnet
lin defamation_N = mkN "诽谤" ;
lin defamatory_A = mkA "诽谤" ;
lin default_N = mkN "默认" ;
lin default_V = mkV "默认" ;
lin defaulter_N = mkN "缺席者" ;
lin defeat_N = mkN "失败" "次" | {-HSK-} mkN "打败" [] ;
lin defeat_V2 = mkV2 "打败" ;
lin defeatism_N = mkN "失敗主義 失败主义" ; -- status=guess
lin defecate_V = mkV "便" | {-HSK-} mkV "大便" | mkV "拉屎" | mkV "排大便" | mkV "大解" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin defecation_N = mkN "拉屎" | mkN "排便" | mkN "排粪" | mkN "通便" ; -- open-multilingual-wordnet
lin defect_N = mkN "毛病" "個" | {-HSK-} mkN "缺陷" ;
lin defect_V = mkV "叛变" ;
lin defection_N = mkN "变节" "" ;
lin defective_A = mkA "缺陷" ;
lin defectiveness_N = mkN "有缺陷" | mkN "缺乏" ; -- open-multilingual-wordnet
lin defector_N = mkN "背叛者" | mkN "逃兵" ; -- status=guess -- status=guess
lin defence_N = mkN "防御" ;
lin defend_V2 = mkV2 "保护" | mkV2 "维护" | {-HSK-} mkV2 "辩护" | {-HSK-} mkV2 "捍卫" ;
lin defendable_A = mkA "可防卫" | mkA "能保卫" | mkA "能防守" | mkA "能防御" ; -- open-multilingual-wordnet
lin defendant_N = mkN "被告" ;
lin defenderFem_N = mkN "辩护人" ;
lin defenderMasc_N = mkN "辩护人" ;
lin defense_N = mkN "防御" ; -- status=guess
lin defensible_A = mkA "可防御" ;
lin defensive_A = mkA "防御性" ;
lin defensive_N = mkN "防御" ;
lin defensiveness_N = mkN "防卫" ;
lin defer_V = mkV "推迟" | {-HSK-} mkV "服从" ;
lin defer_V2 = mkV2 "延缓" | {-HSK-} mkV2 "推迟" | mkV2 "服从" ;
lin deference_N = mkN "顺从" ;
lin deferent_A = mkA "恭敬" | mkA "敬重" | mkA "表示尊敬" | mkA "表示敬意" ; -- open-multilingual-wordnet
lin deferential_A = mkA "恭敬" | mkA "敬重" | mkA "表示尊敬" | mkA "表示敬意" ; -- open-multilingual-wordnet
lin defiance_N = mkN "挑战" ;
lin defiant_A = mkA "目中无人" ;
lin deficiency_N = mkN "不足" ;
lin deficient_A = mkA "欠" ;
lin deficit_N = mkN "赤字" ;
lin defilement_N = mkN "弄脏" | mkN "污染" | mkN "污秽" ; -- open-multilingual-wordnet
lin define_V = mkV "定义" ;
lin define_V2 = mkV2 "规定" ;
lin definite_A = mkA "具体" | mkA "明确" | mkA "确定" | mkA "肯定" ;
lin definition_N = mkN "定义" ;
lin definitive_A = mkA "最终" ;
lin deflagration_N = mkN "爆燃" | mkN "爆燃过程" ; -- open-multilingual-wordnet
lin deflate_V2 = mkV2 "放气" ;
lin deflation_N = mkN "通貨緊縮" | mkN "通货紧缩" | {-mwn-} mkN "排气" | mkN "放气" | mkN "泄气" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin deflationary_A = mkA "通货紧缩" ;
lin deflect_V2 = mkV2 "转向" ;
lin deflective_A = mkA "折射" ; -- open-multilingual-wordnet
lin deflower_V2 = mkV2 (mkV "開苞") | mkV2 (mkV "开苞") | mkV2 (mkV "破瓜") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin defoliant_N = mkN "脱叶剂" | mkN "落叶剂" ; -- open-multilingual-wordnet
lin defoliator_N = mkN "食叶动物" ; -- open-multilingual-wordnet
lin deform_V2 = mkV2 "使+变形" ;
lin deformational_A = mkA "变形" ; -- open-multilingual-wordnet
lin defraud_V2 = mkV2 "骗取" ;
lin defrayal_N = mkN "付款" | mkN "支付" ; -- open-multilingual-wordnet
lin defrayment_N = mkN "付款" | mkN "支付" ; -- open-multilingual-wordnet
lin defrost_V2 = mkV2 (mkV "除霜") | mkV2 (mkV "解凍") | mkV2 (mkV "解冻") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin defroster_N = mkN "解冻器" | mkN "除冰装置" ; -- open-multilingual-wordnet
lin deft_A = mkA "灵巧" ;
lin deftness_N = mkN "灵巧" | mkN "熟练" ; -- open-multilingual-wordnet
lin defunct_A = mkA "报废" ;
lin defuse_V2 = mkV2 "拆除引信" ;
lin defy_V2 = mkV2 "藐视" ;
lin defy_V2V = mkV2V "藐视" ;
lin degauss_V2 = mkV2 (mkV "消磁") ; -- status=guess, src=wikt
lin degaussing_N = mkN "去磁" | mkN "去高斯法" | mkN "消磁" ; -- open-multilingual-wordnet
lin degenerate_A = mkA "惡化 墮落 變質" | {-HSK-} mkA "退步" ; -- status=guess
lin degenerate_N = mkN "退步" ;
lin degenerate_V = mkV "退化" ;
lin degeneration_N = mkN "退化" ; -- status=guess
lin degradation_N = mkN "退化" ;
lin degrade_V2 = mkV2 "降下" ;
lin degree_1_N = mkN "度" ;
lin degree_2_N = mkN "度" ;
lin degree_3_N = mkN "度" ;
lin degree_N = variants {} ;
lin dehumanize_V2 = mkV2 (mkV "獸化") ; -- status=guess, src=wikt
lin dehydration_N = mkN "脫水" | mkN "脱水" ; -- status=guess -- status=guess
lin deictic_A = mkA "直接论证" | mkA "直证" ; -- open-multilingual-wordnet
lin deign_V = mkV "俯就" | mkV "屈尊" | mkV "降格" ; -- open-multilingual-wordnet
lin deirdre_PN = foreignPN "Deirdre" ; -- comment=src=eng status=guess
lin deism_N = mkN "自然神论" | mkN "自然神論" | mkN "理神论" | mkN "理神论" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin deist_A = mkA "自然神论" ; -- open-multilingual-wordnet
lin deity_N = mkN "神" | mkN "神明" | {-mwn-} mkN "上帝" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dekagram_N = mkN "十克" ; -- open-multilingual-wordnet
lin dekaliter_N = mkN "十升" ; -- open-multilingual-wordnet
lin delaware_PN = mkPN "特拉华" ;
lin delay_N = mkN "延迟" | {-HSK-} mkN "耽误" ;
lin delay_V = mkV "延迟" | {-HSK-} mkV "延长" | mkV "推" ;
lin delay_V2 = mkV2 "延长" | mkV2 "推" | {-HSK-} mkV2 "拖延" ;
lin delectable_A = mkA "美味" ;
lin delegate_N = mkN "代表" | {-HSK-} mkN "代表" "位" ;
lin delegate_V2 = mkV2 "委派+为代表" ;
lin delegation_N = mkN "代表团" ;
lin delete_V2 = mkV2 "删除" ;
lin deleterious_A = mkA "有害" ;
lin deletion_N = mkN "删除" "" ;
lin delf_N = mkN "挖掘成的洞" ; -- open-multilingual-wordnet
lin delft_N = mkN "代尔夫特精陶" | mkN "台夫特陶器" ; -- open-multilingual-wordnet
lin delhi_PN = mkPN "德里" ; -- comment=src=geonames status=guess
lin deliberate_A = mkA "故意" ;
lin deliberate_V = mkV "商议" ;
lin deliberate_V2 = mkV2 "仔细考虑" ;
lin deliberation_N = mkN "审议" "次" ;
lin deliberative_A = mkA "慎重" ;
lin delicacy_N = mkN "美味" | {-HSK-} mkN "佳肴" ;
lin delicate_A = mkA "娇嫩" | {-HSK-} mkA "嫩" ;
lin delicatessen_N = mkN "熟食店" ; -- status=guess -- open-multilingual-wordnet
lin delicious_A = mkA "好吃" | {-HSK-} mkA "美味" ;
lin delight_N = mkN "高兴" ;
lin delight_V = mkV "高兴" ;
lin delight_V2 = mkV2 "高兴" ;
lin delighted_A = {-HSK-} mkA "愉快" | mkA "痛快" ;
lin delightful_A = mkA "令人愉快" | {-HSK-} mkA "愉快" ;
lin delimitation_N = mkN "国境" | mkN "界线" | mkN "疆界" | mkN "边境" | mkN "边界" | mkN "边界线" ; -- open-multilingual-wordnet
lin delinquency_N = mkN "行为不良" ;
lin delinquent_A = mkA "有过失" ;
lin delinquent_N = mkN "犯法者" ; -- status=guess
lin delirious_A = mkA "精神错乱" ;
lin delirium_N = mkN "譫妄" | mkN "谵妄" | mkN "神志昏迷" | {-mwn-} mkN "精神错乱" | mkN "说胡话" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin deliver_V = mkV "交" | mkV "送" | {-HSK-} mkV "交付" ;
lin deliver_V2 = mkV2 "交" | mkV2 "送" | {-HSK-} mkV2 "交付" ;
lin delivery_N = mkN "交货" ;
lin deliveryman_N = mkN "送貨人" | mkN "送货人" | mkN "送貨員" | mkN "送货员" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin delouse_V2 = mkV2 "消毒。" ;
lin delta_N = mkN "三角洲" ;
lin deltoid_A = mkA "三角形" ; -- open-multilingual-wordnet
lin deluge_N = mkN "大洪水" ;
lin delusion_N = mkN "妄想" | {-HSK-} mkN "幻想" ;
lin delusive_A = mkA "不切实际" | mkA "不真实" | mkA "假" | mkA "虚假" | mkA "虚妄" ; -- open-multilingual-wordnet
lin delve_V = mkV "探究" ;
lin demagnetization_N = mkN "退磁" | mkN "除去磁性" ; -- open-multilingual-wordnet
lin demagogic_A = mkA "蛊惑人心" ;
lin demagogue_N = mkN "煽动者" ;
lin demand_N = mkN "要" | {-HSK-} mkN "需求" ;
lin demand_V2 = mkV2 "要求" | mkV2 "需要" | {-HSK-} mkV2 "需求" ;
lin demand_VS = mkVS "要求" | mkVS "需要" | {-HSK-} mkVS "需求" ;
lin demantoid_N = mkN "翠榴石" ; -- open-multilingual-wordnet
lin demarcation_N = mkN "界限" ; -- open-multilingual-wordnet
lin demean_V2 = mkV2 "贬低身分" ;
lin dementia_N = mkN "瘋病" | mkN "疯病" | {-mwn-} mkN "痴呆" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin demerit_N = mkN "短處" | mkN "短处" | mkN "缺點" | mkN "缺点" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin demigod_N = mkN "半神半人" | mkN "半神" ; -- status=guess -- status=guess
lin demijohn_N = mkN "坛" | mkN "细颈大坛" ; -- open-multilingual-wordnet
lin demilitarize_V2 = mkV2 "解除武装" ;
lin demineralization_N = mkN "去矿质" | mkN "脱矿质作用" | mkN "软化" | mkN "除盐" | mkN "除盐作用" ; -- open-multilingual-wordnet
lin demise_N = mkN "禅让" ;
lin demister_N = mkN "去雾器" ; -- open-multilingual-wordnet
lin demitasse_N = mkN "小型咖啡杯" ; -- open-multilingual-wordnet
lin demobilize_V2 = mkV2 "遣散" ;
lin democracy_N = mkN "民主" ;
lin democrat_N = mkN "民主主义者" ;
lin democratic_A = mkA "民主" ;
lin democratization_N = mkN "民主化" [] ;
lin democratize_V2 = mkV2 "民主化" ;
lin demographic_A = mkA "人口统计学" ;
lin demography_N = mkN "人口统计学" ;
lin demolish_V2 = mkV2 "毁坏" ;
lin demolition_N = mkN "拆除" ;
lin demon_N = mkN "恶魔" ;
lin demonic_A = mkA "恶魔" ;
lin demonization_N = mkN "妖魔化" ; -- status=guess
lin demonize_V2 = mkV2 "妖魔化" ;
lin demonstrate_V = mkV "显示" | mkV "表演" | {-HSK-} mkV "演示" ;
lin demonstrate_V2 = mkV2 "显示" | mkV2 "表演" | {-HSK-} mkV2 "演示" ;
lin demonstrate_VS = mkVS "显示" | mkVS "表演" | {-HSK-} mkVS "演示" ;
lin demonstration_N = mkN "示范" ;
lin demonstrator_N = mkN "示威者" ;
lin demoralize_V2 = mkV2 "使+士气低落" ;
lin demote_V2 = mkV2 "降级为" ;
lin demotion_N = mkN "降级" ;
lin demulcent_N = mkN "缓和剂" ; -- open-multilingual-wordnet
lin demur_V = mkV "反对" | mkV "提出异议" ; -- open-multilingual-wordnet
lin demur_VS = mkVS "反对" ;
lin demure_A = mkA "嫻靜" | mkA "娴静" ; -- status=guess -- status=guess
lin demyelination_N = mkN "脱髓鞘" ; -- open-multilingual-wordnet
lin den_N = mkN "巢穴" ;
lin denain_PN = mkPN "德南" ; -- comment=src=geonames status=guess
lin denationalize_V2 = mkV2 "私有化" ;
lin denaturant_N = mkN "变性剂" ; -- open-multilingual-wordnet
lin denatured_A = mkA "使变性" | mkA "使失去自然特性" ; -- open-multilingual-wordnet
lin denazification_N = mkN "去纳粹化" | mkN "消灭纳粹化" | mkN "非纳粹化" ; -- open-multilingual-wordnet
lin denbigh_PN = foreignPN "Denbigh" ; -- comment=src=geonames status=guess
lin dendrite_N = mkN "树突" ; -- status=guess
lin dendritic_A = mkA "树枝状" ; -- open-multilingual-wordnet
lin dengue_N = mkN "骨痛熱症" | mkN "骨痛热症" | {-mwn-} mkN "登革热" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin denial_N = mkN "拒绝" ;
lin denigrate_V2 = mkV2 (mkV "玷污") | mkV2 (mkV "詆毀") | mkV2 (mkV "诋毁") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin denigration_N = mkN "诋毁" ;
lin denim_N = mkN "牛仔布" | mkN "丹寧布" | mkN "丹宁布" | {-mwn-} mkN "粗斜棉布" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin denis_PN = foreignPN "Denis" ; -- comment=src=eng status=guess
lin denise_PN = foreignPN "Denise" ; -- comment=src=eng status=guess
lin denizen_N = mkN "居民" ;
lin denmark_PN = mkPN "丹麦" ;
lin dennis_PN = foreignPN "Dennis" ; -- comment=src=geonames status=guess
lin denny_PN = foreignPN "Denny" ; -- comment=src=geonames status=guess
lin denominate_V2 = mkV2 "命名" ;
lin denomination_N = mkN "面值" [] ;
lin denominator_N = mkN "分母" ;
lin denounce_V2 = mkV2 "声讨" ;
lin dense_A = mkA "浓" | {-HSK-} mkA "稠密" ;
lin densimeter_N = mkN "密度计" | mkN "比重计" ; -- open-multilingual-wordnet
lin densitometer_N = mkN "密度计" | mkN "比重计" ; -- open-multilingual-wordnet
lin density_N = mkN "密度" ;
lin dent_N = mkN "凹痕" ;
lin dental_A = mkA "牙科" ;
lin denticle_N = mkN "小牙" | mkN "小齿" | mkN "细齿" ; -- open-multilingual-wordnet
lin denticulate_A = mkA "齿状" ; -- open-multilingual-wordnet
lin dentifrice_N = mkN "牙粉" ; -- open-multilingual-wordnet
lin dentist_N = mkN "牙科医生" ;
lin dentistry_N = mkN "牙科" | mkN "牙醫學" | mkN "牙医学" ; -- status=guess -- status=guess -- status=guess
lin dentition_N = mkN "齒列" | mkN "齿列" | mkN "牙列" | mkN "齒系" | mkN "齿系" | mkN "牙系" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin denture_N = mkN "假牙" ; -- status=guess -- open-multilingual-wordnet
lin denudation_N = mkN "剥光" | mkN "剥离" | mkN "剥脱" | mkN "剥蚀" ; -- open-multilingual-wordnet
lin denude_V2 = mkV2 "使+裸露" ;
lin denver_PN = mkPN "丹佛" ;
lin deny_V2 = mkV2 "否认" ;
lin deny_V3 = mkV3 "否认" ;
lin deodorant_N = mkN "除臭剂" "支" ;
lin deossification_N = mkN "除骨质" | mkN "骨质丧失" ; -- open-multilingual-wordnet
lin deoxyribose_N = mkN "脱氧核糖" ; -- open-multilingual-wordnet
lin dep_PN = foreignPN "Dep" ; -- comment=src=eng status=guess
lin depart_V = mkV "别" | mkV "离开" ;
lin department_N = mkN "部门" | {-HSK-} mkN "部门" "個" ;
lin departmental_A = {-mwn-} mkA "各部" | mkA "部门" ; -- open-multilingual-wordnet
lin departure_N = mkN "出发" ;
lin depend_V = mkV "依赖" | {-HSK-} mkV "寄" ;
lin dependence_N = mkN "依赖" [] | {-HSK-} mkN "相关" ;
lin dependency_N = mkN "从属" ;
lin dependent_A = mkA "依赖" ;
lin dependent_N = mkN "依赖" ;
lin depending_A = variants {} ;
lin depict_V2 = mkV2 "描写" | {-HSK-} mkV2 "描绘" ;
lin depiction_N = mkN "描写" ; -- comment="叙述" ;
lin deplane_V = mkV "下飞机" | mkV "离机" ; -- open-multilingual-wordnet
lin deplete_V2 = mkV2 "耗尽" ;
lin depletion_N = mkN "消耗" [] ;
lin deplorable_A = mkA "凄惨" ;
lin deplore_V2 = mkV2 "谴责" ;
lin deploy_V = mkV "部署" ;
lin deploy_V2 = mkV2 "部署" ;
lin deployment_N = mkN "调度" ;
lin depopulation_N = mkN "人口减少" ; -- open-multilingual-wordnet
lin deport_V2 = mkV2 "驱逐" ;
lin deportation_N = mkN "放逐" ;
lin deportee_N = mkN "被驅逐出境者" | mkN "被驱逐出境者" ; -- status=guess -- status=guess
lin depose_V = mkV "发誓" | mkV "宣誓" ; -- open-multilingual-wordnet
lin depose_V2 = mkV2 "免职" ;
lin deposit_N = mkN "存" | {-HSK-} mkN "存款" ;
lin deposit_V2 = mkV2 "沉积" ;
lin deposition_N = mkN "沉积" "" ;
lin depositor_N = mkN "储户" ;
lin depository_N = mkN "保管人" ;
lin depot_N = mkN "仓库" "间" ;
lin depreciate_V = mkV "贬值" ;
lin depreciation_N = mkN "折旧" ;
lin depress_V2 = mkV2 "压抑" ;
lin depressant_A = mkA "抑制性" | mkA "有镇静作用" ; -- open-multilingual-wordnet
lin depressed_A = variants {} ;
lin depressing_A = mkA "压抑" | mkA "忧郁" | mkA "无精打采" | mkA "沉闷" | mkA "郁闷" | mkA "阴郁" ; -- open-multilingual-wordnet
lin depression_N = mkN "萧条" "次" ;
lin deprivation_N = mkN "剥夺" ;
lin deprive_V2 = mkV2 "剥夺" ;
lin dept_PN = foreignPN "Dept" ; -- comment=src=eng status=guess
lin depth_N = mkN "深度" ;
lin deputize_V = mkV "委以代理人" | mkV "委任" | mkV "担任代表" ; -- open-multilingual-wordnet
lin deputy_N = mkN "副" ;
lin derail_V2 = mkV2 "出轨" ;
lin derby_N = mkN "德比" ;
lin derby_PN = mkPN "德比" ; -- comment=src=geonames status=guess
lin derbyshire_PN = foreignPN "Derbyshire" ; -- comment=src=eng status=guess
lin deregulate_V2 = mkV2 "放松" ;
lin deregulation_N = mkN "放松管制" ;
lin dereham_PN = foreignPN "Dereham" ; -- comment=src=eng status=guess
lin derek_PN = foreignPN "Derek" ; -- comment=src=eng status=guess
lin dereliction_N = mkN "玩忽职守" ;
lin deride_V2 = mkV2 "嘲笑" ;
lin derision_N = mkN "嘲笑" ;
lin derisive_A = mkA "嘲弄" ;
lin derivation_N = mkN "来历" ;
lin derivative_A = mkA "衍生" ;
lin derivative_N = mkN "引出之物" ;
lin derive_V = mkV "派生" ;
lin derive_V2 = mkV2 "派生" ;
lin dermabrasion_N = mkN "皮肤擦除术" ; -- open-multilingual-wordnet
lin dermatitis_N = mkN "皮炎" | {-mwn-} mkN "皮肤炎" ; -- status=guess -- open-multilingual-wordnet
lin dermatoglyphic_N = mkN "纹样" ; -- open-multilingual-wordnet
lin dermatologic_A = mkA "皮肤病学" ; -- open-multilingual-wordnet
lin dermatologistFem_N = variants {} ; ---- sense to be split
lin dermatologistMasc_N = variants {} ; ---- sense to be split
lin dermatology_N = mkN "皮膚病學" | mkN "皮肤病学" ; -- status=guess -- status=guess
lin dermatome_N = mkN "植皮刀" | mkN "皮刀" ; -- open-multilingual-wordnet
lin dermatomycosis_N = mkN "皮真菌病" | mkN "皮肤真菌病" | mkN "皮霉菌病" | mkN "脚气" | mkN "香港脚" ; -- open-multilingual-wordnet
lin dermatomyositis_N = mkN "皮肌炎" ; -- open-multilingual-wordnet
lin dermatosis_N = mkN "皮肤炎" | mkN "皮肤病" ; -- open-multilingual-wordnet
lin derogation_N = mkN "毁损" ;
lin derogatory_A = mkA "贬低" ;
lin derrick_N = mkN "起重機" | mkN "起重机" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin derringer_N = mkN "德林加枪" | mkN "迪林格手枪" ; -- open-multilingual-wordnet
lin derris_N = mkN "毛鱼藤" | mkN "鱼藤属植物" ; -- open-multilingual-wordnet
lin derv_N = mkN "柴油" ; -- open-multilingual-wordnet
lin dervish_N = mkN "德爾維希" | mkN "德尔维希" ; -- status=guess -- status=guess
lin des_PN = foreignPN "Des" ; -- comment=src=eng status=guess
lin desalination_N = mkN "脫鹽" | mkN "脱盐" ; -- status=guess -- status=guess
lin descend_V = mkV "下降" | {-HSK-} mkV "降落" ;
lin descend_V2 = mkV2 "降落" ;
lin descendant_N = mkN "下降" ;
lin descent_N = mkN "降落" "" ;
lin describe_V2 = mkV2 "形容" | mkV2 "描写" | {-HSK-} mkV2 "描述" ;
lin describe_VS = mkVS "形容" | mkVS "描写" | {-HSK-} mkVS "描述" ;
lin description_N = mkN "形容" | mkN "描写" | {-HSK-} mkN "描述" ;
lin descriptive_A = mkA "描述" ;
lin desecrate_V2 = mkV2 (mkV "褻瀆") | mkV2 (mkV "亵渎") | mkV2 (mkV "污辱") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin desecration_N = mkN "亵渎神圣" ;
lin desegregation_N = mkN "种族或宗教融合" ; -- open-multilingual-wordnet
lin desensitization_N = mkN "减敏现象" | mkN "去敏作用" | mkN "脱敏作用" ; -- open-multilingual-wordnet
lin desensitizing_A = mkA "使不敏感" ; -- open-multilingual-wordnet
lin desert_A = mkA "沙漠" ; -- status=guess
lin desert_N = mkN "沙漠" | {-HSK-} mkN "沙漠" "個" ;
lin desert_V = mkV "遗弃" ;
lin desert_V2 = mkV2 "遗弃" ;
lin deserter_N = mkN "逃兵" ; -- status=guess
lin desertification_N = mkN "沙漠化" | {-mwn-} mkN "荒漠化" ; -- status=guess -- open-multilingual-wordnet
lin deserve_V = mkV "值得" | {-HSK-} mkV "应受" ;
lin deserve_V2 = mkV2 "值得" ;
lin deserve_VV = mkVV "值得" | {-HSK-} mkVV "应得" ;
lin deservingness_N = mkN "值得" | mkN "应得" ; -- open-multilingual-wordnet
lin desiccant_N = mkN "干燥剂" | mkN "脱水剂" | mkN "除湿剂" ; -- open-multilingual-wordnet
lin design_N = mkN "设计" | {-HSK-} mkN "设计" "個" ;
lin design_V = mkV "设计" ;
lin design_V2 = mkV2 "设计" ;
lin designate_A = mkA "指定" ;
lin designate_V = mkV "指定" ;
lin designate_V2 = mkV2 "划定" ;
lin designate_V2V = mkV2V "指定" ;
lin designate_VS = mkVS "指定" ;
lin designation_N = mkN "指定" ;
lin designer_N = mkN "设计师" ;
lin desirable_A = mkA "合意" | {-HSK-} mkA "理想" ;
lin desire_N = mkN "意思" "個" | mkN "愿望" "個" | {-HSK-} mkN "渴望" ;
lin desire_V2 = mkV2 "希望" | {-HSK-} mkV2 "渴望" ;
lin desired_A = variants {} ;
lin desist_V = mkV "断念" ;
lin desk_N = mkN "书桌" | {-HSK-} mkN "台" | mkN "桌子" "張" ;
lin desktop_N = mkN "桌面" "个" ;
lin desmond_PN = foreignPN "Desmond" ; -- comment=src=eng status=guess
lin desolate_A = mkA "荒凉" ;
lin desorption_N = mkN "脱附作用" | mkN "解吸作用" | mkN "解吸附作用" ; -- open-multilingual-wordnet
lin despair_N = mkN "绝望" "次" ;
lin despair_V = mkV "失望" | {-HSK-} mkV "绝望" ;
lin desperate_A = mkA "绝望" ;
lin despicable_A = mkA "卑劣" ;
lin despise_V2 = mkV2 "看不起" | mkV2 "轻视" | {-HSK-} mkV2 "鄙视" ;
lin despite_N = mkN "尽管" ;
lin despite_Prep = mkPrep "尽管" ;
lin despondent_A = mkA "懊喪" | mkA "懊丧" | mkA "抑鬱" | mkA "抑郁" | mkA "氣餒" | mkA "气馁" | mkA "灰心" | mkA "沮喪" | mkA "沮丧" | mkA "哀傷" | mkA "哀伤" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin despot_N = mkN "暴君" ;
lin despotism_N = mkN "專制" | mkN "专制" | {-mwn-} mkN "专制政治" | mkN "专制政治论" | mkN "僭主政治" | mkN "暴政" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dessau_PN = mkPN "德绍" ; -- comment=src=geonames status=guess
lin dessert_N = mkN "点心" | {-HSK-} mkN "餐后甜点" "份" ;
lin dessertspoon_N = mkN "一点心匙" ; -- open-multilingual-wordnet
lin dessertspoonful_N = mkN "一点心匙" ; -- open-multilingual-wordnet
lin dessiatine_N = mkN "俄亩" ; -- open-multilingual-wordnet
lin destalinization_N = mkN "贬斯大林运动" | mkN "非斯大林化" ; -- open-multilingual-wordnet
lin destination_N = mkN "目的地" "个" ;
lin destiny_N = mkN "命运" | {-HSK-} mkN "命运" "個" ;
lin destitute_A = mkA "困" ;
lin destroy_V2 = mkV2 "吃" | mkV2 "破坏" ;
lin destruction_N = mkN "毁坏" [] | {-HSK-} mkN "破坏" ;
lin destructive_A = mkA "破坏" ;
lin desuetude_N = mkN "不用" | mkN "废弃" | mkN "废止" | mkN "废除" ; -- open-multilingual-wordnet
lin desultory_A = mkA "散漫" ;
lin detach_V2 = mkV2 "分离" ;
lin detail_N = mkN "环境" ;
lin detail_V2 = mkV2 "细节" ;
lin detailed_A = {-HSK-} mkA "详细" ;
lin detain_V2 = mkV2 "扣留" ;
lin detect_V2 = mkV2 "检测" ;
lin detectable_A = mkA "检出" ;
lin detection_N = variants {} ;
lin detective_N = mkN "侦探" "个" ;
lin detector_N = mkN "探测器" ;
lin detention_N = mkN "扣留" ;
lin deter_V2 = mkV2 "阻止" ;
lin detergent_A = mkA "使干净" | mkA "使清洁" | mkA "净化" | mkA "去垢" | mkA "清洗" ; -- open-multilingual-wordnet
lin detergent_N = mkN "洗涤剂" "支" ;
lin deteriorate_V = mkV "恶化" ;
lin deteriorate_V2 = mkV2 "恶化" ;
lin deterioration_N = mkN "恶化" [] ;
lin determination_N = mkN "决心" "個" | {-HSK-} mkN "决心" [] ;
lin determine_V = mkV "判断" | mkV "确定" ;
lin determine_V2 = mkV2 "决定" | {-HSK-} mkV2 "判断" | mkV2 "确定" ;
lin determine_V2V = mkV2V "判断" | mkV2V "确定" ;
lin determine_VS = mkVS "判断" | mkVS "确定" ;
lin determine_VV = mkVV "判断" | mkVV "确定" ;
lin determined_A = {-HSK-} mkA "决心" | mkA "坚决" ;
lin determiner_N = mkN "限定詞" | mkN "限定词" ; -- status=guess -- status=guess
lin deterministic_A = mkA "决定论" | mkA "确定性" ; -- open-multilingual-wordnet
lin deterrent_N = mkN "震慑" [] ;
lin detest_V2 = mkV2 "厌恶" ;
lin dethrone_V2 = mkV2 "废王位" ;
lin detonate_V = mkV "爆炸" ; -- status=guess, src=wikt
lin detonate_V2 = mkV2 (mkV "爆炸") ; -- status=guess, src=wikt
lin detonation_N = mkN "爆炸" | {-mwn-} mkN "引爆" | mkN "起爆" ; -- status=guess -- open-multilingual-wordnet
lin detonator_N = mkN "雷管" ; -- status=guess -- open-multilingual-wordnet
lin detour_N = mkN "绕道" "" ;
lin detox_N = mkN "戒毒所" | mkN "戒瘾病房" | mkN "戒瘾诊所" ; -- open-multilingual-wordnet
lin detract_V = mkV "贬低" ;
lin detractive_A = mkA "减损" ; -- open-multilingual-wordnet
lin detractor_N = mkN "诽谤者" ;
lin detrain_V = mkV "下火车" ; -- open-multilingual-wordnet
lin detriment_N = mkN "损害" ;
lin detrimental_A = mkA "不利" ;
lin detritus_N = mkN "岩屑" | mkN "碎石" ; -- open-multilingual-wordnet
lin detroit_PN = mkPN "底特律" ; -- comment=src=geonames status=guess
lin deuce_N = mkN "二点" | mkN "二点的纸牌" ; -- open-multilingual-wordnet
lin deuterium_N = mkN "氘" ; -- open-multilingual-wordnet
lin deutzia_N = mkN "溲疏属植物" ; -- open-multilingual-wordnet
lin devaluation_N = mkN "货币贬值" ;
lin devalue_V2 = mkV2 "贬值" ;
lin devastate_V2 = mkV2 "毁灭" ;
lin devastation_N = mkN "毁坏" [] ;
lin develop_V = mkV "冲" | mkV "发" | mkV "发展" | mkV "发挥" | mkV "发达" | mkV "开发" | mkV "长" ;
lin develop_V2 = mkV2 "冲" | mkV2 "发" | mkV2 "发展" | mkV2 "发挥" | mkV2 "发达" | mkV2 "开发" | mkV2 "长" ;
lin developed_A = {-HSK-} mkA "发达" ;
lin developer_N = mkN "开发人员" ;
lin developing_A = variants {} ;
lin development_N = mkN "发展" ;
lin developmental_A = mkA "发展" | mkA "开发" ; -- open-multilingual-wordnet
lin deviant_A = mkA "越轨" ;
lin deviate_V = mkV "偏离" ;
lin deviation_N = mkN "偏差" ;
lin device_N = mkN "设备" ;
lin devil_N = mkN "魔鬼" ;
lin devilish_A = mkA "非常" ; -- status=guess
lin devious_A = mkA "歪" ;
lin devise_N = mkN "遗赠" | mkN "遗赠财产" ; -- open-multilingual-wordnet
lin devise_V2 = mkV2 "设计" ;
lin devitalization_N = mkN "丧失活力" | mkN "失去活力" | mkN "失去生命力" | mkN "没有生气" ; -- open-multilingual-wordnet
lin devizes_PN = foreignPN "Devizes" ; -- comment=src=geonames status=guess
lin devoid_A = mkA "缺乏" ;
lin devon_PN = foreignPN "Devon" ; -- comment=src=geonames status=guess
lin devote_V2 = mkV2 "奉献" | {-HSK-} mkV2 "贡献" ;
lin devoted_A = variants {} ;
lin devotee_N = mkN "信徒" ;
lin devotion_N = mkN "奉献" ;
lin devour_V2 = mkV2 "挥霍" ;
lin devout_A = mkA "虔诚" ;
lin dew_N = mkN "弄湿" | {-HSK-} mkN "露" ;
lin dewdrop_N = mkN "露" ; -- open-multilingual-wordnet
lin dewsbury_PN = mkPN "迪斯伯里" ; -- comment=src=geonames status=guess
lin dewy_A = mkA "露湿" ; -- open-multilingual-wordnet
lin dexterity_N = mkN "灵巧" ;
lin dexterous_A = mkA "機巧" | mkA "机巧" | mkA "靈巧" | mkA "灵巧" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin dextrorotary_A = mkA "右旋性" | mkA "向右旋转" | mkA "向右转" ; -- open-multilingual-wordnet
lin dextrose_N = mkN "右旋糖" | mkN "葡萄糖" ; -- open-multilingual-wordnet
lin dg_PN = foreignPN "Dg" ; -- comment=src=eng status=guess
lin dhoti_N = mkN "印度腰带" | mkN "腰布" ; -- open-multilingual-wordnet
lin dhow_N = mkN "独桅三角帆船" ; -- open-multilingual-wordnet
lin di_PN = foreignPN "Di" ; -- comment=src=eng status=guess
lin diabetes_N = mkN "糖尿病" [] ;
lin diabetic_N = mkN "糖尿病患者" ;
lin diachronic_A = mkA "歷時" | mkA "历时" | {-mwn-} mkA "历史" | mkA "史实" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin diacritic_N = mkN "附加符號" | mkN "附加符号" | mkN "讀音符號" | mkN "读音符号" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin diadem_N = mkN "王冠" ; -- open-multilingual-wordnet
lin diaeresis_N = mkN "分音符號" | mkN "分音符号" | mkN "分音符" ; -- status=guess -- status=guess -- status=guess
lin diagnose_V2 = mkV2 "诊断" ;
lin diagnosis_N = mkN "诊断" | {-HSK-} mkN "诊断" "次" ;
lin diagnostic_A = mkA "诊断" ;
lin diagonal_A = mkA "對角" | mkA "对角" | {-mwn-} mkA "倾斜" | mkA "歪" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin diagonalizable_A = mkA "可对角化" ; -- open-multilingual-wordnet
lin diagram_N = mkN "图表" "张" ;
lin diakinesis_N = mkN "丝球期" | mkN "终变期" ; -- open-multilingual-wordnet
lin dial_N = mkN "转盘" ;
lin dial_V2 = mkV2 "拨号" ;
lin dialect_N = mkN "方言" ;
lin dialectal_A = mkA "方言" ; -- open-multilingual-wordnet
lin dialectic_A = mkA "方言" | mkA "辩证" | mkA "辩证法" ; -- open-multilingual-wordnet
lin dialectical_A = mkA "方言" | mkA "辩证" | mkA "辩证法" ; -- open-multilingual-wordnet
lin dialectology_N = mkN "方言學" | mkN "方言学" ; -- status=guess -- status=guess
lin dialog_N = mkN "对话" "個" | {-HSK-} mkN "對話" | mkN "对话" | mkN "會話" | mkN "会话" | mkN "對白" | mkN "对白" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin dialogue_N = mkN "对话" ;
lin dialysis_N = mkN "透析" ; -- status=guess
lin dialyzer_N = mkN "渗析器" | mkN "滤膜分析器" | mkN "透析器" ; -- open-multilingual-wordnet
lin diamagnet_N = mkN "抗磁体" ; -- open-multilingual-wordnet
lin diamagnetic_A = mkA "反磁性" | mkA "抗磁" ; -- open-multilingual-wordnet
lin diamantine_A = mkA "像钻石" | mkA "含钻石" | mkA "钻石" ; -- open-multilingual-wordnet
lin diameter_N = mkN "直径" ;
lin diametral_A = mkA "与直径有关" | mkA "径向" | mkA "正好相反" | mkA "沿直径" | mkA "直径" ; -- open-multilingual-wordnet
lin diametric_A = mkA "与直径有关" | mkA "径向" | mkA "正好相反" | mkA "沿直径" | mkA "直径" ; -- open-multilingual-wordnet
lin diamine_N = mkN "二胺" | mkN "联胺" ; -- open-multilingual-wordnet
lin diamond_N = mkN "钻石" "棵" ;
lin diana_PN = foreignPN "Diana" ; -- comment=src=eng status=guess
lin diaper_N = mkN "尿布" ;
lin diaphone_N = mkN "雾笛" ; -- open-multilingual-wordnet
lin diaphoretic_N = mkN "发汗剂" | mkN "发汗药" ; -- open-multilingual-wordnet
lin diaphragm_N = mkN "光圈快门" ; -- open-multilingual-wordnet
lin diaphyseal_A = mkA "骨干" ; -- open-multilingual-wordnet
lin diarchy_N = mkN "兩頭政治" | mkN "两头政治" ; -- status=guess -- status=guess
lin diarrhea_N = mkN "痢疾" ;
lin diarrhoea_N = mkN "痢疾" ; -- open-multilingual-wordnet
lin diary_N = mkN "日记" | {-HSK-} mkN "日记" "則" ;
lin diaspora_N = mkN "散居" | mkN "僑民" | mkN "侨民" | mkN "離散" | mkN "离散" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin diastolic_A = mkA "心脏舒张" | mkA "舒张" ; -- open-multilingual-wordnet
lin diastrophism_N = mkN "地壳变动" ; -- open-multilingual-wordnet
lin diathesis_N = mkN "特异质" ; -- open-multilingual-wordnet
lin diatomic_A = mkA "双原子" ; -- open-multilingual-wordnet
lin diazepam_N = mkN "地西泮" ; -- status=guess
lin diazo_A = mkA "二氮化合物" ; -- open-multilingual-wordnet
lin diazonium_N = mkN "重氮化合物" | mkN "重氮基" ; -- open-multilingual-wordnet
lin dibber_N = mkN "挖洞器" | mkN "挖穴器" ; -- open-multilingual-wordnet
lin dibble_N = mkN "挖洞器" | mkN "挖穴器" ; -- open-multilingual-wordnet
lin dibble_V2 = mkV2 "点" ;
lin dibranchiate_N = mkN "二鳃目" | mkN "二鳃目软体动物" ; -- open-multilingual-wordnet
lin dibucaine_N = mkN "二丁卡因" ; -- open-multilingual-wordnet
lin dicarboxylic_A = mkA "二羧基" ; -- open-multilingual-wordnet
lin dice_N = mkN "骰子" "颗" ;
lin dicer_N = mkN "切丁器" ; -- open-multilingual-wordnet
lin dicey_A = mkA "不确定" | mkA "不确实" | mkA "冒险" | mkA "危险" ; -- open-multilingual-wordnet
lin dichloride_N = mkN "二氯化合物" | mkN "二氯化物" ; -- open-multilingual-wordnet
lin dichotomization_N = mkN "二分" | mkN "二分化" | mkN "二分法" ; -- open-multilingual-wordnet
lin dichotomous_A = mkA "分成两个" | mkA "叉状分枝" ; -- open-multilingual-wordnet
lin dichotomy_N = mkN "二分法" ;
lin dichromacy_N = mkN "二色性色觉盲" | mkN "二色视" ; -- open-multilingual-wordnet
lin dichromatic_A = mkA "二色性色盲" ; -- open-multilingual-wordnet
lin dick_N = mkN "雞巴" | mkN "鸡巴" | mkN "屌" ; -- status=guess -- status=guess -- status=guess
lin dick_PN = foreignPN "Dick" ; -- comment=src=eng status=guess
lin dicker_V = mkV "还价" ;
lin dickey_N = mkN "衬衫的胸襟" | mkN "衬衫的胸部" ; -- open-multilingual-wordnet
lin dicky_N = mkN "衬衫的胸襟" | mkN "衬衫的胸部" ; -- open-multilingual-wordnet
lin dicky_PN = foreignPN "Dicky" ; -- comment=src=eng status=guess
lin dictaphone_N = mkN "录音机" ;
lin dictate_N = mkN "主宰" "" ;
lin dictate_V = mkV "主宰" ;
lin dictate_V2 = mkV2 "口述" ;
lin dictate_VS = mkVS "主宰" ;
lin dictation_N = mkN "听写" ;
lin dictator_N = mkN "独裁者" ;
lin dictatorial_A = mkA "独裁" ; -- comment="专政" ;
lin dictatorship_N = mkN "专政" ;
lin diction_N = mkN "吐字" | {-mwn-} mkN "措辞" | mkN "用语" | mkN "语言表达" ; -- status=guess -- open-multilingual-wordnet
lin dictionary_N = mkN "字典" "本" | {-HSK-} mkN "字典" "部" ;
lin dictostylium_N = mkN "粘菌" ; -- open-multilingual-wordnet
lin dictyopteran_A = mkA "时髦" ; -- open-multilingual-wordnet
lin dicumarol_N = mkN "双香豆素" | mkN "紫苜蓿酚" ; -- open-multilingual-wordnet
lin didactic_A = mkA "说教" ;
lin didcot_PN = foreignPN "Didcot" ; -- comment=src=geonames status=guess
lin die_N = mkN "股子" ;
lin die_V = L.die_V | {-HSK-} mkV "去世" | mkV "死" | mkV "走" ;
lin die_away_V = advV OP_die_V OP_away_Adv ; -- guess-p-verb
lin die_back_V = advV OP_die_V OP_back_Adv ; -- guess-p-verb
lin die_down_V = advV OP_die_V OP_down_Adv ; -- guess-p-verb
lin die_for_V2 = prepV2 OP_die_V OP_for_Prep ; -- guess-p-verb
lin die_off_V = mkV "消失" | mkV "灭绝" | mkV "绝迹" ; -- open-multilingual-wordnet
lin die_out_V = mkV "消失" | mkV "灭绝" | mkV "绝迹" ; -- open-multilingual-wordnet
lin dieback_N = mkN "顶枯病" ; -- open-multilingual-wordnet
lin diesel_N = mkN "柴油机" ;
lin diestock_N = mkN "板牙铰手" ; -- open-multilingual-wordnet
lin diestrous_A = mkA "间情期" ; -- open-multilingual-wordnet
lin diestrus_N = mkN "动情间期" | mkN "间情期" ; -- open-multilingual-wordnet
lin diet_N = mkN "饮食" ;
lin diet_V = mkV "节食" ;
lin dietary_A = mkA "饮食" ; -- open-multilingual-wordnet
lin dietary_N = mkN "膳食纖維" | mkN "膳食纤维" | mkN "飲食纖維" | mkN "饮食纤维" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin dietitian_N = mkN "飲食學家" | mkN "饮食学家" | mkN "營養學家" | mkN "营养学家" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin differ_V = mkV "不同" ;
lin difference_N = mkN "分别" | mkN "区别" "個" | mkN "差别" | {-HSK-} mkN "差异" ;
lin different_A = mkA "不同" ;
lin differentiable_A = mkA "可微" ; -- open-multilingual-wordnet
lin differential_A = mkA "微分" ;
lin differential_N = mkN "微分" ;
lin differentiate_V = mkV "区分" ;
lin differentiate_V2 = mkV2 "区分" ;
lin differentiation_N = variants {} ;
lin difficult_A = mkA "困难" | {-HSK-} mkA "艰苦" | mkA "难" ;
lin difficulty_N = mkN "困难" | {-HSK-} mkN "困难" "個" | mkN "难" ;
lin diffuse_V = mkV "传" | mkV "传播" | mkV "使广为人知" | mkV "广为传播" | mkV "推广" | mkV "散布" | mkV "散播" | mkV "铺开" ; -- open-multilingual-wordnet
lin diffuser_N = mkN "均匀散射灯" ; -- open-multilingual-wordnet
lin diffusion_N = mkN "擴散" | mkN "扩散" ; -- status=guess -- status=guess
lin dig_N = mkN "戳" ; -- comment="掘" ;
lin dig_V = L.dig_V ;
lin dig_V2 = mkV2 "挖" ;
lin dig_in_V = advV OP_dig_V OP_in_Adv ; -- guess-p-verb
lin dig_into_V2 = prepV2 OP_dig_V OP_into_Prep ; -- guess-p-verb
lin dig_out_V2 = prepV2 OP_dig_V OP_out_Prep ; -- guess-p-verb
lin dig_up_V2 = prepV2 OP_dig_V OP_up_Prep ; -- guess-p-verb
lin digest_N = mkN "文摘" | {-HSK-} mkN "消化" ; -- status=guess
lin digest_V = mkV "消化" ; -- status=guess, src=wikt
lin digest_V2 = mkV2 "消化" ;
lin digester_N = mkN "煮解器" | mkN "蒸煮器" ; -- open-multilingual-wordnet
lin digestion_N = mkN "消化" ; -- status=guess
lin digestive_A = mkA "消化" ;
lin digestive_N = mkN "消化" | {-HSK-} mkN "消化餅乾" | mkN "消化饼干" ; -- status=guess -- status=guess
lin digger_N = mkN "怪手" ; -- status=guess
lin digging_N = mkN "挖掘" ;
lin digit_N = mkN "数字" | {-HSK-} mkN "数字" "個" ;
lin digital_A = mkA "数字" | {-HSK-} mkA "数据" | mkA "数码" ;
lin digitalis_N = mkN "指顶花" | mkN "毛地黄属植物" ; -- open-multilingual-wordnet
lin digitizer_N = mkN "数字化转换器" | mkN "数字转换器" ; -- open-multilingual-wordnet
lin digitoxin_N = mkN "洋地黄毒甙" | mkN "洋地黄毒苷" | mkN "狄吉妥辛" ; -- open-multilingual-wordnet
lin dignify_V2 = mkV2 "增威严" ;
lin dignitary_N = mkN "权贵" "位" ;
lin dignity_N = mkN "尊严" | {-HSK-} mkN "身份" ;
lin dihydrostreptomycin_N = mkN "二氢链霉素" | mkN "双氢链霉素" ; -- open-multilingual-wordnet
lin dijon_PN = mkPN "第戎" ; -- comment=src=geonames status=guess
lin dike_N = mkN "坝" | mkN "堤坝" | mkN "堰" | mkN "水坝" ; -- open-multilingual-wordnet
lin dilapidated_A = mkA "荒废" ;
lin dilapidation_N = mkN "破坏" | mkN "破壞" ; -- status=guess -- status=guess
lin dilation_N = mkN "扩大" | mkN "扩张" | mkN "膨胀" ; -- open-multilingual-wordnet
lin dilator_N = mkN "扩张器" ; -- open-multilingual-wordnet
lin dildo_N = mkN "假陰莖" | mkN "假阴茎" | mkN "按摩棒" ; -- status=guess -- status=guess -- status=guess
lin dilemma_N = mkN "困境" ;
lin dilettante_N = mkN "業餘人士；一知半解的人" ; -- status=guess
lin diligence_N = mkN "勤勉" "" ;
lin diligent_A = mkA "刻苦" | mkA "耐勞" | mkA "耐劳" | mkA "努力" | mkA "勤奮" | mkA "勤勞" | mkA "勤劳" | mkA "勤劳" | mkA "勤勉" | {-HSK-} mkA "勤奋" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin dill_N = mkN "蒔蘿" | mkN "莳萝" ; -- status=guess -- status=guess
lin dilutant_N = mkN "冲淡剂" | mkN "稀释剂" | mkN "稀释液" ; -- open-multilingual-wordnet
lin dilute_V = mkV "稀释" ;
lin dilute_V2 = mkV2 "稀" ;
lin dilution_N = mkN "稀释" ;
lin diluvian_A = mkA "大洪水" | mkA "洪水" ; -- open-multilingual-wordnet
lin dim_A = mkA "暗淡" ;
lin dim_V = mkV "变模糊" ;
lin dim_V2 = mkV2 "使+暗淡" ;
lin dime_N = mkN "一角银币" ;
lin dimension_N = mkN "尺寸" ;
lin dimensional_A = mkA "維" | mkA "维" | {-mwn-} mkA "尺寸" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dimethylglyoxime_N = mkN "二甲基乙二肟" ; -- open-multilingual-wordnet
lin diminish_V = mkV "减" ;
lin diminish_V2 = mkV2 "减" ;
lin diminuendo_N = mkN "漸弱" | mkN "渐弱" ; -- status=guess -- status=guess
lin diminution_N = mkN "减少" "" ;
lin diminutive_A = mkA "小" ; -- comment="小型" ;--"微小" ;
lin dimity_N = mkN "凸纹条格" | mkN "凸花条纹布" | mkN "麻纱" ; -- open-multilingual-wordnet
lin dimmer_N = mkN "调光器" ; -- open-multilingual-wordnet
lin dimorphic_A = mkA "二形" | mkA "二态" | mkA "同种二形" ; -- open-multilingual-wordnet
lin dimple_N = mkN "酒窩" | mkN "酒窝" | mkN "靨" | mkN "靥" | mkN "酒渦" | mkN "酒涡" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin din_N = mkN "耳鳴" | mkN "耳鸣" | mkN "吵鬧" | mkN "吵闹" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin dinar_N = mkN "第納爾" | mkN "第纳尔" ; -- status=guess -- status=guess
lin dine_V = mkV "进餐" ;
lin diner_N = mkN "用餐者" ;
lin dinghy_N = mkN "划艇" | mkN "小舟" ; -- open-multilingual-wordnet
lin dinginess_N = mkN "微黑" | mkN "肮脏" | mkN "黯淡" ; -- open-multilingual-wordnet
lin dingle_PN = foreignPN "Dingle" ; -- comment=src=geonames status=guess
lin dingo_N = mkN "澳大利亞野犬" | mkN "澳大利亚野犬" | mkN "澳洲野犬" | mkN "丁格犬" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin dining_N = mkN "餐饮" "次" ;
lin dining_room_N = mkN "餐厅" | mkN "饭厅" ; -- open-multilingual-wordnet
lin dinky_A = mkA "极小" ;
lin dinky_N = mkN "小型机车" | mkN "轻便机车" | mkN "集材小机车" ; -- open-multilingual-wordnet
lin dinner_N = mkN "晚餐" "顿" ;
lin dinner_party_N = mkN "宴会" "席" ;
lin dinnertime_N = mkN "晚餐时间" | mkN "正餐就餐时间" ; -- open-multilingual-wordnet
lin dinnerware_N = mkN "整套的餐具" | mkN "正餐餐具" ; -- open-multilingual-wordnet
lin dinnington_PN = foreignPN "Dinnington" ; -- comment=src=geonames status=guess
lin dinocerate_N = mkN "恐角目动物" ; -- open-multilingual-wordnet
lin dinosaur_N = mkN "恐龙" ;
lin diocesan_A = mkA "主教管区" | mkA "教区" ; -- open-multilingual-wordnet
lin diocese_N = mkN "教區" | mkN "教区" ; -- status=guess -- status=guess
lin diode_N = mkN "二極管" | mkN "二极管" ; -- status=guess -- status=guess
lin diol_N = mkN "二醇" ; -- open-multilingual-wordnet
lin diopter_N = mkN "屈光度" ; -- open-multilingual-wordnet
lin dioxide_N = mkN "二氧化碳" [] ;
lin dioxin_N = mkN "二氧杂芑" ; -- open-multilingual-wordnet
lin dip_N = mkN "浸" ;
lin dip_V = mkV "浸" ;
lin dip_V2 = mkV2 "浸" ;
lin dip_ed_N = mkN "下沉" [] ;
lin diphtheria_N = mkN "白喉" ;
lin diphthong_N = mkN "雙元音" | mkN "双元音" ; -- status=guess -- status=guess
lin diplegia_N = mkN "两侧麻痹" | mkN "双侧瘫痪" ; -- open-multilingual-wordnet
lin diploid_A = mkA "二倍體" | mkA "二倍体" ; -- status=guess -- status=guess
lin diploidy_N = mkN "二倍体" | mkN "二倍性" ; -- open-multilingual-wordnet
lin diploma_N = mkN "毕业证书" ; -- comment="学位证书" ;
lin diplomacy_N = mkN "外交" | {-HSK-} mkN "外交" "個" ;
lin diplomat_N = mkN "外交官" ;
lin diplomatic_A = mkA "外交" ;
lin diplomatist_N = mkN "外交官" | mkN "外交家" ; -- open-multilingual-wordnet
lin diplopia_N = mkN "复视" ; -- open-multilingual-wordnet
lin diplotene_N = mkN "双线期" ; -- open-multilingual-wordnet
lin dipolar_A = mkA "兩極性" | {-mwn-} mkA "两极" | mkA "两极性" | mkA "偶极" ; -- status=guess -- open-multilingual-wordnet
lin dipstick_N = mkN "测深尺" | mkN "浸量尺" | mkN "量杆" | mkN "量油尺" | mkN "量油计" ; -- open-multilingual-wordnet
lin dipterous_A = mkA "双翅" | mkA "双翅目昆虫" | mkA "双翅类" | mkA "属双翅目" ; -- open-multilingual-wordnet
lin dire_A = mkA "可怕" ;
lin direct_A = mkA "导演" | mkA "直接" ;
lin direct_Adv = mkAdv "导演" | mkAdv "直接" ;
lin direct_V = mkV "对" | mkV "指导" | mkV "指挥" | {-HSK-} mkV "直接" ;
lin direct_V2 = mkV2 "对" | mkV2 "指导" | mkV2 "指挥" | {-HSK-} mkV2 "直接" ;
lin direction_N = mkN "向" | mkN "方" | mkN "方向" "個" | {-HSK-} mkN "方向" ;
lin directional_A = mkA "定向" | mkA "方向" ; -- open-multilingual-wordnet
lin directive_N = mkN "指示" ;
lin director_N = mkN "导演" | mkN "经理" "個" | {-HSK-} mkN "理事" ;
lin directorate_N = mkN "董事会" ;
lin directorship_N = mkN "董事职务" ;
lin directory_N = mkN "目录" ;
lin dirigible_N = mkN "飛艇" | mkN "飞艇" | mkN "飛船" | mkN "飞船" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin dirk_N = mkN "匕首" "把" ;
lin dirndl_N = mkN "紧身连衫裙式的女服" ; -- open-multilingual-wordnet
lin dirt_N = mkN "污垢" [] ;
lin dirty_A = L.dirty_A | {-HSK-} mkA "脏" ;
lin dirty_V = mkV "变脏" ;
lin dirty_V2 = mkV2 "使+变脏" ;
lin disability_N = mkN "残疾" ;
lin disable_V2 = mkV2 "使+失去能力" ;
lin disabled_A = {-HSK-} mkA "残疾" ;
lin disabled_N = mkN "残疾" ;
lin disaccharidase_N = mkN "二糖酶" | mkN "双糖酶" ; -- open-multilingual-wordnet
lin disaccharide_N = mkN "二糖" | mkN "双糖" ; -- open-multilingual-wordnet
lin disadvantage_N = mkN "坏处" ;
lin disaffected_A = mkA "不满" ;
lin disaffection_N = mkN "不满" ;
lin disagree_V = mkV "不同意" ;
lin disagree_V2 = mkV2 "不同意" ;
lin disagree_VS = mkVS "不同意" ;
lin disagreeable_A = mkA "不愉快" ;
lin disagreement_N = mkN "不一致" ;
lin disallow_V2 = mkV2 "禁止" ;
lin disambiguation_N = mkN "解疑" | mkN "澄清" ; -- status=guess -- status=guess
lin disappear_V = mkV "消失" ;
lin disappearance_N = mkN "失踪" ;
lin disappoint_V2 = mkV2 "辜负" ;
lin disappointing_A = mkA "令人失望" ;
lin disappointment_N = mkN "失望" ;
lin disapproval_N = mkN "不赞成" ;
lin disapprove_V = mkV "不赞成" ;
lin disapprove_V2 = mkV2 "不赞成" ;
lin disarm_V = mkV "撤防" ;
lin disarm_V2 = mkV2 "解除武装" ;
lin disarmament_N = mkN "裁军" ;
lin disarrangement_N = mkN "瓦解" | mkN "组织的破坏" | mkN "解体" ; -- open-multilingual-wordnet
lin disarray_N = mkN "杂乱" [] ;
lin disassociate_V2 = mkV2 "分离" ;
lin disassociation_N = mkN "分离" ; -- open-multilingual-wordnet
lin disaster_N = mkN "灾难" ;
lin disastrous_A = mkA "不得了" | {-HSK-} mkA "灾难性" ;
lin disavow_V2 = mkV2 "否认" ;
lin disband_V = mkV "解散" ;
lin disband_V2 = mkV2 "解散" ;
lin disbelief_N = mkN "怀疑" ;
lin disburse_V2 = mkV2 "支付" ;
lin disbursement_N = mkN "支出" ;
lin disc_N = mkN "圆盘" ;
lin discalced_A = mkA "不穿鞋" | mkA "赤脚" | mkA "赤足" ; -- open-multilingual-wordnet
lin discard_V2 = mkV2 "丢弃" ;
lin discern_V2 = mkV2 "识别" ;
lin discernible_A = mkA "可辨" ;
lin discerning_A = mkA "有辨别能力" ;
lin discharge_N = mkN "排放" [] ; -- comment=[mark]或卸货，解雇 5
lin discharge_V = mkV "排出" ;
lin discharge_V2 = mkV2 "解雇" ;
lin disciform_A = mkA "盘状" ; -- open-multilingual-wordnet
lin disciple_N = mkN "门徒" "名" ;
lin disciplinary_A = mkA "惩戒" ;
lin discipline_N = mkN "纪律" | {-HSK-} mkN "规律" ;
lin discipline_V2 = mkV2 "训练" ;
lin disclose_V = mkV "透露" ;
lin disclose_V2 = mkV2 "揭露" ;
lin disclose_VS = mkVS "透露" ;
lin disclosure_N = mkN "泄露" ;
lin disco_1_N = mkN "迪斯科" ;
lin disco_2_N = mkN "迪斯科" ;
lin discoid_A = mkA "圆盘" | mkA "圆盘形" | mkA "平圆形" | mkA "铁饼状" ; -- open-multilingual-wordnet
lin discoloration_N = mkN "變色" | mkN "变色" ; -- status=guess -- status=guess
lin discomfit_V2 = mkV2 "扰乱" ;
lin discomfort_N = mkN "不适" ;
lin discomycete_N = mkN "盘菌" ; -- open-multilingual-wordnet
lin discomycetous_A = mkA "盘菌" ; -- open-multilingual-wordnet
lin disconfirming_A = mkA "阴性" ; -- open-multilingual-wordnet
lin disconnect_V2 = mkV2 "断开" ;
lin disconnection_N = mkN "分裂" | mkN "断开" ; -- open-multilingual-wordnet
lin discontent_N = mkN "不满" [] ;
lin discontinuance_N = mkN "废止" ;
lin discontinue_V = mkV "中止" ;
lin discontinue_V2 = mkV2 "中止" ;
lin discontinuity_N = mkN "不连贯" | mkN "断断续续" | mkN "缺乏连续性" ; -- open-multilingual-wordnet
lin discord_N = mkN "不和" ;
lin discordant_A = mkA "不和谐" ;
lin discotheque_N = mkN "迪斯科舞厅" ;
lin discount_N = mkN "折扣" ;
lin discount_V = mkV "折扣" ;
lin discount_V2 = mkV2 "折扣" ;
lin discourage_V2 = mkV2 "阻碍" ;
lin discouragement_N = mkN "沮丧" ;
lin discourse_N = mkN "话语" ;
lin discourse_V = mkV "談論" | mkV "谈论" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin discourtesy_N = mkN "不恭" | mkN "伤感情" | mkN "冒犯" | mkN "失礼" | mkN "得罪" | mkN "无礼" | mkN "无礼貌" | mkN "粗鲁" ; -- open-multilingual-wordnet
lin discover_V = mkV "发现" ;
lin discover_V2 = mkV2 "发现" ;
lin discover_VS = mkVS "发现" ;
lin discovererFem_N = variants {} ; ---- sense to be split
lin discovererMasc_N = variants {} ; ---- sense to be split
lin discovery_N = mkN "发现" ;
lin discredit_N = mkN "不名誉" | mkN "坏名声" ; -- open-multilingual-wordnet
lin discredit_V2 = mkV2 "不信" ;
lin discreditable_A = mkA "不光彩" | mkA "不名誉" | mkA "丢脸" | mkA "可耻" | mkA "有失身份" | mkA "有损信誉" | mkA "羞辱" | mkA "耻辱" ; -- open-multilingual-wordnet
lin discreet_A = mkA "小心" ;
lin discrepancy_N = mkN "矛盾" ;
lin discrepant_A = mkA "有差异" | mkA "矛盾" ; -- open-multilingual-wordnet
lin discrete_A = mkA "离散" ;
lin discreteness_N = mkN "个别性" | mkN "区别性" | mkN "独特性" ; -- open-multilingual-wordnet
lin discretion_N = mkN "慎重" ;
lin discretionary_A = mkA "酌" ;
lin discriminate_V = mkV "区别" ;
lin discriminate_V2 = mkV2 "区别" ;
lin discrimination_N = mkN "歧视" [] ;
lin discriminatory_A = mkA "歧视" ;
lin discursive_A = mkA "離題" | mkA "漫無邊際" ; -- status=guess -- status=guess
lin discuss_V = mkV "洽谈" ;
lin discuss_V2 = mkV2 "商量" | mkV2 "讨论" | mkV2 "议论" | mkV2 "谈" ;
lin discuss_VS = mkVS "商量" | mkVS "讨论" | mkVS "议论" | mkVS "谈" ;
lin discussion_N = mkN "讨论" | {-HSK-} mkN "议论" "個" ;
lin disdain_N = mkN "蔑视" ;
lin disdain_V2 = mkV2 "蔑视" ;
lin disdainful_A = mkA "輕蔑" | mkA "轻蔑" | mkA "侮辱" ; -- status=guess -- status=guess -- status=guess
lin disease_N = mkN "疾病" ;
lin diseased_A = mkA "害病" ;
lin disembark_V = mkV "登陆" ;
lin disembark_V2 = mkV2 (mkV "登陸") | mkV2 (mkV "登陆") | mkV2 (mkV "下船") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin disembody_V2 = mkV2 "使+脱离肉体" ;
lin disenchant_V2 = mkV2 "使清醒" ;
lin disengage_V2 = mkV2 "脱离" ;
lin disequilibrium_N = mkN "不平衡" | mkN "不稳定" | mkN "失去平衡" | mkN "失调" ; -- open-multilingual-wordnet
lin disesteem_N = mkN "冷遇" | mkN "轻视" ; -- open-multilingual-wordnet
lin disfigure_V2 = mkV2 (mkV "變醜") | mkV2 (mkV "变丑") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin disfigurement_N = mkN "变丑" | mkN "损形" | mkN "毁容" ; -- open-multilingual-wordnet
lin disgorge_V2 = mkV2 "吐出" ;
lin disgrace_N = mkN "耻辱" "" ;
lin disgraceful_A = mkA "可耻" ; -- comment="可耻" ;
lin disgruntled_A = mkA "不满" ;
lin disguise_N = mkN "伪装" "" ;
lin disguise_V2 = mkV2 "伪装" ;
lin disgust_N = mkN "厌恶" ;
lin disgust_V2 = mkV2 "厌恶" ;
lin disgusting_A = mkA "令人厌恶" | {-HSK-} mkA "讨厌" ;
lin dish_N = mkN "盘" | {-HSK-} mkN "盘子" "個" ;
lin dish_V2 = mkV2 "装盘" ;
lin dishcloth_N = mkN "刷碗布" | mkN "洗碟布" ; -- open-multilingual-wordnet
lin dishearten_V2 = mkV2 (mkV "令人愁悶") | mkV2 (mkV "令人愁闷") | mkV2 (mkV "使沮喪") | mkV2 (mkV "使沮丧") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin disheveled_A = mkA "散乱" | mkA "蓬散" ; -- open-multilingual-wordnet
lin dishevelled_A = mkA "散乱" | mkA "蓬散" ; -- open-multilingual-wordnet
lin dishonest_A = mkA "不诚实" ;
lin dishonesty_N = mkN "不诚实""次" ;
lin dishpan_N = mkN "洗碟用盆子" | mkN "洗碟盆" ; -- open-multilingual-wordnet
lin dishrag_N = mkN "刷碗布" | mkN "洗碟布" ; -- open-multilingual-wordnet
lin dishtowel_N = mkN "干抹布" | mkN "茶巾" ; -- open-multilingual-wordnet
lin dishwasher_N = mkN "洗碗工" ;
lin dishwater_N = mkN "洗盘水" | mkN "洗碗水" | mkN "洗碟水" ; -- open-multilingual-wordnet
lin disillusionment_N = mkN "幻灭" ;
lin disinclination_N = mkN "不情愿" | mkN "犹豫" | mkN "踌躇" | mkN "迟疑" ; -- open-multilingual-wordnet
lin disinfect_V2 = mkV2 (mkV "消毒") ; -- status=guess, src=wikt
lin disinfectant_A = mkA "杀菌" | mkA "杀菌性" | mkA "消毒" ; -- open-multilingual-wordnet
lin disinfectant_N = mkN "消毒剂" "瓶" ;
lin disinfection_N = mkN "消毒" ; -- status=guess
lin disinflation_N = mkN "通货紧缩" "次" ;
lin disinformation_N = mkN "假情報" | mkN "假情报" ; -- status=guess -- status=guess
lin disingenuous_A = mkA "不老实" ;
lin disintegrate_V = mkV "瓦解" ;
lin disintegrate_V2 = mkV2 (mkV "解體") | mkV2 (mkV "解体") | mkV2 (mkV "瓦解") | mkV2 (mkV "瓦解") | mkV2 (mkV "崩潰") | mkV2 (mkV "崩溃") | mkV2 (mkV "粉碎") | mkV2 (mkV "崩裂") | mkV2 (mkV "分崩離析") | mkV2 (mkV "分崩离析") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin disintegration_N = mkN "瓦解" ;
lin disinterested_A = mkA "无私" ;
lin disinvestment_N = mkN "收回投资" | mkN "蚀本" ; -- open-multilingual-wordnet
lin disjoint_A = mkA "不相交" ; -- open-multilingual-wordnet
lin disjointedness_N = mkN "不相交性" ; -- open-multilingual-wordnet
lin disjunction_N = mkN "分裂" | mkN "断开" ; -- open-multilingual-wordnet
lin disk_N = mkN "圆盘" ;
lin diskette_N = mkN "軟盤" | mkN "软盘" | mkN "磁盤" | mkN "磁盘" | mkN "磁碟" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin dislike_N = mkN "反感" ;
lin dislike_V2 = mkV2 "不喜欢" ;
lin dislocation_N = mkN "混乱" [] ;
lin dislodgement_N = mkN "赶出" | mkN "逐出" | mkN "驱逐" ; -- open-multilingual-wordnet
lin dislodgment_N = mkN "赶出" | mkN "逐出" | mkN "驱逐" ; -- open-multilingual-wordnet
lin disloyal_A = mkA "不忠" ;
lin disloyalty_N = mkN "不忠" [] ;
lin dismal_A = mkA "惨淡" ;
lin dismantle_V2 = mkV2 "拆卸" ;
lin dismay_N = mkN "沮丧" ;
lin dismay_V = mkV "沮丧" ;
lin dismay_V2 = mkV2 "使沮丧" ;
lin dismember_V2 = mkV2 "肢解" ;
lin dismiss_V2 = mkV2 "解雇" ;
lin dismissal_N = mkN "解雇" [] ;
lin disobedience_N = mkN "抗命" "次" ;
lin disobey_V2 = mkV2 "违抗" ;
lin disorder_N = mkN "乱" | {-HSK-} mkN "紊乱" [] ;
lin disorderly_A = mkA "混乱" ;
lin disparage_V2 = mkV2 "贬低" ;
lin disparate_A = mkA "不同" ;
lin disparity_N = mkN "差别" | {-HSK-} mkN "差距" "" ;
lin dispatch_N = mkN "派遣" ;
lin dispatch_V2 = mkV2 "派" | {-HSK-} mkV2 "派遣" ;
lin dispatch_V2V = mkV2V "派" | {-HSK-} mkV2V "派遣" ;
lin dispatcher_N = mkN "調度" | mkN "调度" ; -- status=guess -- status=guess
lin dispel_V2 = mkV2 "消除" ;
lin dispensary_N = mkN "医务室" ; -- open-multilingual-wordnet
lin dispensation_N = mkN "分配" ;
lin dispense_V = mkV "分配" ; -- comment="分发" ;
lin dispense_V2 = mkV2 "分与" ;
lin dispenser_N = mkN "分配者" | mkN "药剂师" ; -- open-multilingual-wordnet
lin dispersal_N = mkN "传播" | mkN "散布" | mkN "散播" ; -- open-multilingual-wordnet
lin disperse_V = mkV "分散" | {-HSK-} mkV "挥" ;
lin disperse_V2 = mkV2 "分散" | {-HSK-} mkV2 "挥" ;
lin dispersion_N = mkN "传播" | mkN "散布" | mkN "散播" ; -- open-multilingual-wordnet
lin displace_V2 = mkV2 "替换" ;
lin displacement_N = mkN "位移" ; -- status=guess
lin display_N = mkN "显示" | {-HSK-} mkN "表现" ;
lin display_V2 = mkV2 "发挥" | mkV2 "显示" | mkV2 "表现" ;
lin display_VS = mkVS "发挥" | mkVS "显示" | mkVS "表现" ;
lin displease_V2 = mkV2 "得罪" ;
lin disposable_A = mkA "一次性" ;
lin disposable_N = mkN "可支配收入" ; -- status=guess
lin disposal_N = mkN "处置" ;
lin dispose_V = mkV "部署" ;
lin dispose_V2 = mkV2 "部署" ;
lin disposition_N = mkN "性情" | {-HSK-} mkN "性格" "個" | mkN "脾气" "個" ;
lin disproportion_N = mkN "不均衡" | mkN "不相称" ; -- open-multilingual-wordnet
lin disproportionate_A = mkA "不成比例" ;
lin disprove_VS = mkVS "驳斥" ;
lin dispute_N = mkN "争议" ;
lin dispute_V = mkV "争议" ;
lin dispute_V2 = mkV2 "争议" ;
lin disqualification_N = mkN "不合格" ;
lin disqualify_V2 = mkV2 "使+丧失资格" ;
lin disquieting_A = mkA "令人不安" ;
lin disregard_N = mkN "无视" ;
lin disregard_V2 = mkV2 "漠视" ;
lin disrepair_N = mkN "失修" ; -- open-multilingual-wordnet
lin disreputable_A = mkA "不名誉" | mkA "名声不好" | mkA "名誉不好" | mkA "声名狼藉" ; -- open-multilingual-wordnet
lin disrepute_N = mkN "不名誉" | mkN "坏名声" ; -- open-multilingual-wordnet
lin disrespectful_A = mkA "不恭" | mkA "不敬" ; -- status=guess -- status=guess
lin disrupt_V = mkV "破坏" ;
lin disrupt_V2 = mkV2 "破坏" ;
lin disruption_N = mkN "瓦解" "次" ;
lin disruptive_A = mkA "破坏性" ;
lin dissatisfaction_N = mkN "不满" "种" ;
lin dissatisfy_V2 = mkV2 "使+不满足" ;
lin dissect_V2 = mkV2 "解剖" ;
lin dissection_N = mkN "解剖" "" ;
lin disseminate_V = mkV "传播" | {-HSK-} mkV "宣传" ;
lin disseminate_V2 = mkV2 "传播" | {-HSK-} mkV2 "宣传" ;
lin dissemination_N = mkN "传播" ;
lin dissension_N = mkN "纠纷" "场" ;
lin dissent_N = mkN "异议" ;
lin dissent_V = mkV "不同意" ;
lin dissenter_N = mkN "不同意者" ;
lin dissertation_N = mkN "論文" | mkN "论文" ; -- status=guess -- status=guess
lin disservice_N = mkN "伤害" ;
lin dissident_A = mkA "持不同政见" ;
lin dissident_N = mkN "异己" ;
lin dissimilar_A = mkA "不同" ;
lin dissimilation_N = mkN "分解代谢" | mkN "异化作用" | mkN "降解代谢" ; -- open-multilingual-wordnet
lin dissimulate_V = mkV "伪装" | mkV "佯装" | mkV "假装" | mkV "掩饰" ; -- open-multilingual-wordnet
lin dissimulative_A = mkA "假装" | mkA "掩饰" ; -- open-multilingual-wordnet
lin dissipate_V = mkV "消散" ;
lin dissociable_A = mkA "可分" | mkA "可分开" | mkA "可分离" | mkA "可分裂" ; -- open-multilingual-wordnet
lin dissociate_V2 = mkV2 "分裂" ;
lin dissociative_A = mkA "使分离" | mkA "使游离" ; -- open-multilingual-wordnet
lin dissoluble_A = mkA "可分解" | mkA "可液化" | mkA "可溶解" | mkA "可融化" ; -- open-multilingual-wordnet
lin dissolute_A = mkA "淫蕩" | mkA "淫荡" ; -- status=guess -- status=guess
lin dissolution_N = mkN "分解" ; -- comment="溶解" ;
lin dissolvable_A = mkA "可分解" | mkA "可液化" | mkA "可溶解" | mkA "可融化" ; -- open-multilingual-wordnet
lin dissolve_V = mkV "溶解" | {-HSK-} mkV "融化" ;
lin dissolve_V2 = mkV2 "溶解" | {-HSK-} mkV2 "融化" ;
lin dissolving_N = mkN "溶解" ; -- open-multilingual-wordnet
lin dissonance_N = mkN "不和谐" ;
lin dissonant_A = mkA "有差异" | mkA "矛盾" ; -- open-multilingual-wordnet
lin dissuade_V2 = mkV2 "劝阻" ;
lin distaff_N = mkN "纺纱杆" ; -- open-multilingual-wordnet
lin distal_A = mkA "末梢部" | mkA "末梢部" | {-mwn-} mkA "末梢" | mkA "末梢部" | mkA "末端" | mkA "远端" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin distance_N = mkN "距离" "個" | {-HSK-} mkN "距离" [] ;
lin distance_N3 = L.distance_N3 ;
lin distance_V2 = mkV2 "疏远" ;
lin distant_A = mkA "远" | {-HSK-} mkA "遥远" ;
lin distaste_N = mkN "厌恶" ;
lin distasteful_A = mkA "令人不快" ;
lin distil_V = mkV "蒸餾" | mkV "蒸馏" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin distil_V2 = mkV2 "蒸馏" ;
lin distillate_N = mkN "餾液" | {-mwn-} mkN "蒸馏液" | mkN "馏出物" | mkN "馏液" ; -- status=guess -- open-multilingual-wordnet
lin distillation_N = mkN "蒸餾" | mkN "蒸馏" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin distiller_N = mkN "蒸馏器" ;
lin distillery_N = mkN "酒厂" "间" ;
lin distinct_A = mkA "不同" | {-HSK-} mkA "明显" | mkA "清楚" | mkA "独特" ;
lin distinction_N = mkN "区别" | {-HSK-} mkN "差别" ;
lin distinctive_A = mkA "独特" ;
lin distinctiveness_N = mkN "特殊性" ;
lin distinguish_V = mkV "分别" | mkV "别" | mkV "区别" | {-HSK-} mkV "区分" ;
lin distinguish_V2 = mkV2 "分别" | mkV2 "别" | mkV2 "区别" | {-HSK-} mkV2 "区分" ;
lin distinguished_A = variants {} ;
lin distort_V2 = mkV2 "扭曲" ;
lin distortion_N = mkN "扭曲" ;
lin distract_V = mkV "转移" ;
lin distract_V2 = mkV2 "转移" ;
lin distraction_N = mkN "注意力分散" ;
lin distraught_A = mkA "懊惱" | mkA "懊恼" | mkA "煩亂" | mkA "烦乱" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin distress_N = mkN "苦恼" ;
lin distress_V2 = mkV2 "折磨" ;
lin distressful_A = mkA "痛苦" ;
lin distressing_A = mkA "痛苦" ;
lin distribute_V2 = mkV2 "分布" | mkV2 "分配" ;
lin distributed_A = {-HSK-} mkA "分布" ;
lin distribution_N = mkN "分发" ;
lin distributional_A = mkA "分布" ; -- open-multilingual-wordnet
lin distributor_N = mkN "总代理" ;
lin district_N = mkN "区域" ;
lin distrust_N = mkN "不信任" ;
lin distrustful_A = mkA "多疑" | {-mwn-} mkA "不信任" | mkA "怀疑" ; -- status=guess -- open-multilingual-wordnet
lin disturb_V2 = mkV2 "影响" | mkV2 "打扰" ;
lin disturbance_N = mkN "骚乱" "场" ;
lin disturbing_A = variants {} ;
lin disunion_N = mkN "不统一" | mkN "分开" | mkN "分裂" ; -- open-multilingual-wordnet
lin disunity_N = mkN "一盘散沙" | mkN "不一致" | mkN "不和" | mkN "不团结" | mkN "不统一" ; -- open-multilingual-wordnet
lin disuse_N = mkN "废止" | mkN "忽视" | mkN "无视" | mkN "轻视" ; -- open-multilingual-wordnet
lin disyllabic_A = mkA "二音节" | mkA "双音节" ; -- open-multilingual-wordnet
lin ditch_N = mkN "沟壕" ;
lin ditch_V = mkV "开沟" ; -- open-multilingual-wordnet
lin dither_N = mkN "慌乱" | mkN "紧张" ; -- open-multilingual-wordnet
lin dither_V = mkV "抖动" ;
lin dithering_N = mkN "抖动" ; -- open-multilingual-wordnet
lin dithyrambic_A = mkA "充满激情" | mkA "激情洋溢" | mkA "狂热" ; -- open-multilingual-wordnet
lin ditto_N = mkN "同上" ;
lin ditty_N = mkN "小曲" ; -- status=guess
lin diva_N = mkN "迪娃" | mkN "迪瓦" | mkN "女名" | mkN "歌後" | mkN "歌后" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin divan_N = mkN "沙发床" | mkN "长沙发" ; -- open-multilingual-wordnet
lin divarication_N = mkN "分叉" | mkN "分支" | mkN "叉开" ; -- open-multilingual-wordnet
lin dive_N = mkN "潜水" [] ;
lin dive_V = mkV "潜水" ;
lin diver_N = mkN "潜水者" ;
lin diverge_V = mkV "偏离" ;
lin divergence_N = mkN "差异" ;
lin divergent_A = mkA "发散" ;
lin divers_A = mkA "不一样" | mkA "不同种类" | mkA "各式各样" | mkA "各种各样" | mkA "种种" ; -- open-multilingual-wordnet
lin diverse_A = mkA "多种" | {-HSK-} mkA "纷纷" ;
lin diverseness_N = mkN "变化" | mkN "多样性" ; -- open-multilingual-wordnet
lin diversification_N = mkN "多样化" [] ;
lin diversify_V = mkV "多样化" ;
lin diversify_V2 = mkV2 "使+多样化" ;
lin diversion_N = mkN "转移" ;
lin diversionary_A = mkA "牵制性" ;
lin diversity_N = mkN "多样性" | {-HSK-} mkN "差别" ;
lin divert_V = mkV "转移" ;
lin diverticulitis_N = mkN "憩室炎" ; -- open-multilingual-wordnet
lin diverticulosis_N = mkN "憩室病" ; -- open-multilingual-wordnet
lin diverticulum_N = mkN "憩室" ; -- open-multilingual-wordnet
lin dives_PN = foreignPN "Dives" ; -- comment=src=eng status=guess
lin divest_V2 = mkV2 "剥离" ;
lin dividable_A = mkA "能被整除" ; -- open-multilingual-wordnet
lin divide_N = mkN "分水岭" ;
lin divide_V = mkV "分" | mkV "除" | {-HSK-} mkV "划分" ;
lin divide_V2 = mkV2 "分" | mkV2 "除" | {-HSK-} mkV2 "划分" ;
lin divide_up_V2 = prepV2 OP_divide_V OP_up_Prep ; -- guess-p-verb
lin dividend_N = mkN "红利" ;
lin divination_N = mkN "卜筮" | mkN "占卜" | mkN "卜卦" ; -- status=guess -- status=guess -- status=guess
lin divine_A = mkA "神圣" ;
lin divinity_N = mkN "神性" ; -- status=guess
lin division_1_N = variants {} ;
lin division_2_N = variants {} ;
lin division_3_N = variants {} ;
lin division_N = mkN "部门" ;
lin divisional_A = mkA "分区" ;
lin divisor_N = mkN "除數" | mkN "除数" ; -- status=guess -- status=guess
lin divorce_N = mkN "离婚" ;
lin divorce_V2 = mkV2 "离婚" ;
lin divorcee_N = mkN "離婚者" | mkN "离婚者" ; -- status=guess -- status=guess
lin divulge_V2 = mkV2 "漏" ;
lin divvy_N = mkN "红利" | mkN "股利" | mkN "股息" ; -- open-multilingual-wordnet
lin dixie_N = mkN "露营用大锅" ; -- open-multilingual-wordnet
lin dizygotic_A = mkA "两合子" ; -- open-multilingual-wordnet
lin dizziness_N = mkN "头昏眼花" ;
lin dizzy_A = mkA "晕" ;
lin dizzy_V2 = mkV2 "头晕" ;
lin djibouti_PN = mkPN ("吉布地市" | "吉布提") ; -- comment=src=geonames status=guess
lin dm_N = mkN "分米" ; -- open-multilingual-wordnet
lin dnepropetrovsk_PN = foreignPN "Dnepropetrovsk" ; -- comment=src=eng status=guess
lin do_N = mkN "聚会""场" ;
lin do_V2 = mkV2 "从事" | mkV2 "做" | mkV2 "干" | mkV2 "弄" | mkV2 "搞" | mkV2 "行" | mkV2 "进行" ;
lin dobbin_N = mkN "道宾马" ; -- open-multilingual-wordnet
lin dobra_N = mkN "多布拉" ; -- open-multilingual-wordnet
lin docile_A = mkA "温顺" ;
lin dock_N = mkN "码头" ;
lin docket_N = mkN "案卷" ;
lin docking_N = mkN "對接" | mkN "对接" ; -- status=guess -- status=guess
lin dockyard_N = mkN "船廠" | mkN "船厂" | mkN "造船所" ; -- status=guess -- status=guess -- status=guess
lin doctor_N = L.doctor_N | {-HSK-} mkN "先生" "個" | mkN "医生" "個" | mkN "博士" | mkN "大夫" "個" ;
lin doctor_V2 = mkV2 "就医" ;
lin doctoral_A = mkA "博士" | mkA "博士学位" ; -- open-multilingual-wordnet
lin doctorate_N = mkN "博士学位" ;
lin doctrinal_A = mkA "教条" ; -- open-multilingual-wordnet
lin doctrine_N = mkN "原则" "個" | {-HSK-} mkN "教义" ;
lin document_N = mkN "文件" | {-HSK-} mkN "文件" "份" ;
lin document_V2 = mkV2 "文件" ;
lin documentary_A = mkA "纪实" ;
lin documentary_N = mkN "纪录片" ;
lin documentation_N = mkN "文档" "份" ;
lin dodder_N = mkN "吐丝子" | mkN "无娘藤米米" | mkN "缠龙子" | mkN "菟丝子" | mkN "菟丝实" | mkN "萝丝子" | mkN "豆须子" | mkN "黄丝子" | mkN "黄网子" | mkN "黄萝子" | mkN "黄藤子" | mkN "龙须子" ; -- open-multilingual-wordnet
lin dodder_V = mkV "摇摆" ;
lin dodecagon_N = mkN "十二角形" | mkN "十二边形" ; -- open-multilingual-wordnet
lin dodecahedron_N = mkN "正十二面體" | mkN "正十二面体" | {-mwn-} mkN "十二面体" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dodge_V = mkV "躲避" ;
lin dodge_V2 = mkV2 (mkV "躲避") | mkV2 (mkV "躲開") | mkV2 (mkV "躲开") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin doe_N = mkN "母鹿" | mkN "麀" | mkN "雌鹿" ; -- status=guess -- status=guess -- status=guess
lin doer_N = mkN "实干家" ;
lin doeskin_N = mkN "驼丝绵" | mkN "驼丝锦" ; -- open-multilingual-wordnet
lin dog_N = L.dog_N | {-HSK-} mkN "狗" "隻" ;
lin dog_V2 = mkV2 "跟踪" ;
lin dog_eared_A = mkA "狗耳" ;
lin doggy_N = mkN "後背體位" ; -- status=guess
lin doghouse_N = mkN "犬舍" | mkN "狗屋" | mkN "狗房" | mkN "狗窝" | mkN "狗舍" ; -- open-multilingual-wordnet
lin dogma_N = mkN "教条" ;
lin dogsled_N = mkN "狗拖的雪橇" ; -- open-multilingual-wordnet
lin dogtooth_N = mkN "犬牙饰" ; -- open-multilingual-wordnet
lin dogwood_N = mkN "山茱萸" ; -- status=guess
lin doing_N = variants {} ;
lin dolabriform_A = mkA "斧形" ; -- open-multilingual-wordnet
lin dole_V2 = mkV2 "发放救济" ;
lin doll_N = mkN "洋娃娃" ;
lin dollar_N = mkN "美元" ;
lin dollop_N = mkN "一些" | mkN "块" ; -- open-multilingual-wordnet
lin dolly_N = mkN "娃娃" | mkN "洋娃娃" | mkN "玩偶" ; -- open-multilingual-wordnet
lin dolly_PN = foreignPN "Dolly" ; -- comment=src=eng status=guess
lin dolmen_N = mkN "石棚" ; -- open-multilingual-wordnet
lin dolomite_N = mkN "白云石" ; -- open-multilingual-wordnet
lin dolomitic_A = mkA "含白云石" | mkA "白云石" ; -- open-multilingual-wordnet
lin dolphin_N = mkN "海豚" ;
lin dolt_N = mkN "傻瓜" ;
lin doltish_A = mkA "呆笨" | mkA "土头土脑" | mkA "愚笨" | mkA "愚蠢" | mkA "愚钝" | mkA "笨拙" | mkA "粗鲁" ; -- open-multilingual-wordnet
lin domain_N = mkN "域" | {-HSK-} mkN "领域" ;
lin dome_N = mkN "拱顶" ;
lin domed_A = mkA "成圆顶状" | mkA "拱状" ; -- open-multilingual-wordnet
lin domesday_PN = foreignPN "Domesday" ; -- comment=src=eng status=guess
lin domestic_A = mkA "国内" ;
lin domestic_N = mkN "家貓" | mkN "家猫" ; -- status=guess -- status=guess
lin domicile_N = mkN "住所" | mkN "住宅" | {-mwn-} mkN "住处" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin domiciliary_A = mkA "住处" | mkA "住家" ; -- open-multilingual-wordnet
lin dominance_N = mkN "优势" | {-HSK-} mkN "霸主地位" [] ;
lin dominant_A = mkA "主导" ;
lin dominate_V = mkV "主宰" ;
lin dominate_V2 = mkV2 "主宰" ;
lin domination_N = mkN "支配" ;
lin domineer_V = mkV "跋扈" ;
lin dominic_PN = foreignPN "Dominic" ; -- comment=src=eng status=guess
lin dominica_PN = mkPN "多米尼克" ; -- comment=src=geonames status=guess
lin dominion_N = mkN "领土" ;
lin domino_N = mkN "多米诺" "副" ;
lin dominoes_N = mkN "多米諾" | mkN "多米诺" | mkN "骨牌" ; -- status=guess -- status=guess -- status=guess
lin don_N = mkN "先生" "位" ;
lin don_PN = foreignPN "Don" ; -- comment=src=geonames status=guess
lin don_V2 = mkV2 "穿上" ;
lin donald_PN = foreignPN "Donald" ; -- comment=src=eng status=guess
lin donate_V = mkV "捐" | mkV "输" | {-HSK-} mkV "捐赠" ;
lin donate_V2 = mkV2 "捐" | mkV2 "输" | {-HSK-} mkV2 "捐赠" ;
lin donation_N = mkN "捐款" ;
lin doncaster_PN = mkPN "唐卡斯特" ; -- comment=src=geonames status=guess
lin donegal_PN = foreignPN "Donegal" ; -- comment=src=geonames status=guess
lin donetsk_PN = mkPN "頓涅茨克" ; -- comment=src=geonames status=guess
lin dong_N = mkN "盾" | mkN "越南盾" | mkN "越盾" | {-mwn-} mkN "东" | mkN "越南货币单位" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin dongle_N = mkN "加密狗" | {-mwn-} mkN "保护锁" ; -- status=guess -- open-multilingual-wordnet
lin donjon_N = mkN "城堡主塔" | mkN "城堡主楼" | mkN "城堡的主楼" | mkN "楼橹" ; -- open-multilingual-wordnet
lin donkey_N = mkN "驢" | mkN "驴" | mkN "驢子" | mkN "驴子" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin donnish_A = mkA "卖弄学问" | mkA "学究式" ; -- open-multilingual-wordnet
lin donor_N = mkN "捐助""次" ;
lin doodlebug_N = mkN "蚁狮" ; -- open-multilingual-wordnet
lin doom_N = mkN "厄运" "次" ;
lin doom_V2 = mkV2 "判决" ;
lin doomsday_PN = foreignPN "Doomsday" ; -- comment=src=eng status=guess
lin door_N = L.door_N | {-HSK-} mkN "门" ;
lin door_to_door_A = mkA "送货上门" ;
lin doorbell_N = mkN "門鈴" | mkN "门铃" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin doorcase_N = mkN "门框" ; -- open-multilingual-wordnet
lin doorframe_N = mkN "门框" ; -- open-multilingual-wordnet
lin doorhandle_N = mkN "门把" | mkN "门把手" ; -- open-multilingual-wordnet
lin doorjamb_N = mkN "门柱" ; -- open-multilingual-wordnet
lin doorkeeper_N = mkN "把門人" | mkN "把门人" ; -- status=guess -- status=guess
lin doorknob_N = mkN "門把手" | mkN "门把手" | mkN "門把" | mkN "门把" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin doorknocker_N = mkN "門環" | mkN "门环" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin doorlock_N = mkN "门锁" ; -- open-multilingual-wordnet
lin doorman_N = mkN "看门人" "位" ;
lin doormat_N = mkN "門墊" | mkN "门垫" | mkN "門口地墊" | mkN "门口地垫" | mkN "擦腳墊" | mkN "擦脚垫" | {-mwn-} mkN "门毯" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin doornail_N = mkN "大头钉" | mkN "护门帽钉" | mkN "门钉" ; -- open-multilingual-wordnet
lin doorplate_N = mkN "门牌" ; -- open-multilingual-wordnet
lin doorpost_N = mkN "门柱" ; -- open-multilingual-wordnet
lin doorsill_N = mkN "入口" | mkN "门槛" | mkN "门阶" ; -- open-multilingual-wordnet
lin doorstep_N = mkN "门口" ;
lin doorstop_N = mkN "制门器" ; -- open-multilingual-wordnet
lin doorstopper_N = mkN "制门器" ; -- open-multilingual-wordnet
lin doorway_N = mkN "门" | {-HSK-} mkN "门口" "个" ;
lin dooryard_N = mkN "庭院" ; -- open-multilingual-wordnet
lin dopa_N = mkN "二羟基苯丙氨酸" | mkN "二羟苯丙氨酸" ; -- open-multilingual-wordnet
lin dopamine_N = mkN "多巴胺" ; -- status=guess
lin dope_N = mkN "笨蛋" ;
lin doppelganger_N = mkN "分身" ; -- status=guess
lin dora_PN = foreignPN "Dora" ; -- comment=src=geonames status=guess
lin dorbeetle_N = mkN "欧洲粪金龟" | mkN "金龟子的一种" ; -- open-multilingual-wordnet
lin dorchester_PN = foreignPN "Dorchester" ; -- comment=src=geonames status=guess
lin dordrecht_PN = foreignPN "Dordrecht" ; -- comment=src=geonames status=guess
lin doreen_PN = foreignPN "Doreen" ; -- comment=src=eng status=guess
lin doric_A = mkA "多立斯风格" ; -- open-multilingual-wordnet
lin doris_PN = foreignPN "Doris" ; -- comment=src=eng status=guess
lin dorking_PN = foreignPN "Dorking" ; -- comment=src=geonames status=guess
lin dormant_A = mkA "蛰伏" ;
lin dormer_N = mkN "天窗" ; -- open-multilingual-wordnet
lin dormitory_N = mkN "宿舍" "間" | {-HSK-} mkN "宿舍" "间" ;
lin dormouse_N = mkN "睡鼠" | {-mwn-} mkN "榛睡鼠" ; -- status=guess -- open-multilingual-wordnet
lin dorothy_PN = foreignPN "Dorothy" ; -- comment=src=eng status=guess
lin dorsal_A = mkA "离开轴心" | mkA "轴外" | mkA "远轴" ; -- open-multilingual-wordnet
lin dorset_PN = foreignPN "Dorset" ; -- comment=src=eng status=guess
lin dorsiflexion_N = mkN "背侧屈" | mkN "背屈" | mkN "背曲" ; -- open-multilingual-wordnet
lin dortmund_PN = mkPN "多特蒙德" ; -- comment=src=geonames status=guess
lin dosage_N = mkN "剂量" "" ;
lin dose_N = mkN "剂量" "" ;
lin dosemeter_N = mkN "剂量仪" | mkN "剂量计" ; -- open-multilingual-wordnet
lin dossal_N = mkN "幔布" ; -- open-multilingual-wordnet
lin dossier_N = mkN "卷宗" ;
lin dot_N = mkN "点" "个" ;
lin dot_V2 = mkV2 "点" ;
lin dotage_N = mkN "老耄" | mkN "老迷糊" | mkN "失智症" ; -- status=guess -- status=guess -- status=guess
lin douai_PN = mkPN "杜埃" ; -- comment=src=geonames status=guess
lin double_A = mkA "双" | {-HSK-} mkA "双重" ;
lin double_Adv = mkAdv "一倍" | {-HSK-} mkAdv "双" ;
lin double_N = mkN "两倍" | {-HSK-} mkN "双" ;
lin double_V = mkV "双倍" ;
lin double_V2 = mkV2 "双倍" ;
lin double_as_V2 = prepV2 OP_double_V OP_as_Prep ; -- guess-p-verb
lin double_back_V = mkV "由原路返回" | mkV "走回头路" | mkV "返回" ; -- open-multilingual-wordnet
lin double_breasted_A = mkA "双排" ;
lin double_check_V2 = variants {} ; -- guess-p-verb
lin double_cross_V2 = mkV2 "两倍" ;
lin double_edged_A = mkA "两面性" ;
lin double_over_V = mkV "弯着身子" | mkV "弯腰" ; -- open-multilingual-wordnet
lin double_park_V = variants {} ; -- guess-p-verb
lin double_park_V2 = variants {} ; -- guess-p-verb
lin double_up_V = advV OP_double_V OP_up_Adv ; -- guess-p-verb
lin double_up_as_V2 = prepV2 (advV OP_double_V OP_up_Adv ) OP_as_Prep ; -- guess-p-verb
lin doubler_N = mkN "倍压器" | mkN "倍增器" | mkN "倍频器" ; -- open-multilingual-wordnet
lin double_think_N = mkN "雙想" | mkN "双想" | mkN "雙重思想" | mkN "双重思想" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin doubletree_N = mkN "双驾横木" ; -- open-multilingual-wordnet
lin doubloon_N = mkN "达布隆" | mkN "都布隆" ; -- open-multilingual-wordnet
lin doubt_N = mkN "怀疑" ;
lin doubt_V2 = mkV2 "怀疑" ;
lin doubt_VS = mkVS "怀疑" ;
lin doubtful_A = mkA "可疑" ;
lin doubting_A = mkA "怀疑" | mkA "怀疑性" | mkA "怀疑论" | mkA "质疑" ; -- open-multilingual-wordnet
lin doubtless_Adv = mkAdv "无疑" ;
lin doug_PN = foreignPN "Doug" ; -- comment=src=eng status=guess
lin dough_N = mkN "麵團" | mkN "面团" | mkN "生麵糰" | mkN "生面团" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin doughnut_N = mkN "油炸圈饼" ;
lin douglas_PN = mkPN "道格拉斯" ; -- comment=src=geonames status=guess
lin dove_N = mkN "鸽子" ;
lin dovecote_N = mkN "鴿棚" | mkN "鸽棚" | {-mwn-} mkN "鸽房" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dover_PN = mkPN ("多佛" | "多佛尔") ; -- comment=src=geonames status=guess
lin dovetail_V = mkV "吻合" ;
lin dowdy_A = mkA "寒酸" ;
lin dowel_N = mkN "木钉" | {-mwn-} mkN "暗榫" ; -- status=guess -- open-multilingual-wordnet
lin dowitcher_N = mkN "半蹼鹬" | mkN "短喙半蹼鹬" | mkN "短嘴半蹼鹬" | mkN "长喙半蹼鹬" | mkN "长嘴半蹼鹬" ; -- open-multilingual-wordnet
lin down_A = mkA "下" | mkA "毛" | {-HSK-} mkA "向下" ;
lin down_Adv = mkAdv "下" | {-HSK-} mkAdv "毛" ;
lin down_N = mkN "下" | mkN "毛" | {-HSK-} mkN "羽绒" ;
lin down_PN = foreignPN "Down" ; -- comment=src=eng status=guess
lin down_Prep = mkPrep "往下" ;
lin down_V2 = mkV2 "打倒" ;
lin down_to_earth_A = mkA "实际" ;
lin downbeat_N = mkN "停滞" ;
lin downbound_A = mkA "下行" ; -- open-multilingual-wordnet
lin downfall_N = mkN "倒台" ;
lin downfield_A = mkA "在前场" ; -- open-multilingual-wordnet
lin downgrade_V2 = mkV2 "下坡" ;
lin downhill_Adv = mkAdv "向下" ;
lin downing_street_PN = foreignPN "Downing street" ; -- comment=src=eng status=guess
lin download_N = mkN "下載" | mkN "下载" ; -- status=guess -- status=guess
lin down_market_A = mkA "价廉质次" | mkA "低端市场" ; -- open-multilingual-wordnet
lin downplay_V2 = mkV2 "不予重视" ;
lin downpour_N = mkN "大雨" | mkN "傾盆大雨" | mkN "倾盆大雨" ; -- status=guess -- status=guess -- status=guess
lin downright_A = mkA "明白" ;
lin downright_Adv = mkAdv "彻头彻尾" ;
lin downscale_A = mkA "下阶层" ; -- open-multilingual-wordnet
lin downsize_V2 = mkV2 "缩小尺寸" ;
lin downstage_A = mkA "在舞台前方" ; -- open-multilingual-wordnet
lin downstairs_Adv = mkAdv "楼下" ;
lin downstream_A = mkA "顺流" ;
lin downtime_N = mkN "停機時間" | mkN "停机时间" ; -- status=guess -- status=guess
lin downtown_A = mkA "市中心" ; -- open-multilingual-wordnet
lin downtown_N = mkN "市中心" | mkN "中央商業區" | mkN "中央商业区" ; -- status=guess -- status=guess -- status=guess
lin downtrodden_A = mkA "受压迫" ;
lin downturn_N = mkN "衰退" | mkN "下降" ; -- status=guess -- status=guess
lin downward_A = mkA "向下" ;
lin downward_Adv = mkAdv "向下" ;
lin downwards_Adv = mkAdv "下" ;
lin downy_A = mkA "毛茸茸" ; -- status=guess
lin dowry_N = mkN "嫁妝" | mkN "嫁妆" ; -- status=guess -- status=guess
lin dowser_N = mkN "占卜杖" | mkN "探水杖" | mkN "探矿杖" ; -- open-multilingual-wordnet
lin dowsing_N = mkN "探尋水源" | mkN "探寻水源" | mkN "尋水術" | mkN "寻水术" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin doxology_N = mkN "三一頌" | mkN "三一颂" ; -- status=guess -- status=guess
lin doxorubicin_N = mkN "亚德利亚霉素" ; -- open-multilingual-wordnet
lin doyen_N = mkN "老資格" | mkN "老资格" | mkN "元老" ; -- status=guess -- status=guess -- status=guess
lin doze_V = mkV "打瞌睡" | mkV "打盹" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin dozen_N = mkN "一打" ; -- comment=NOT SURE "一打" or "多数"
lin dr_PN = foreignPN "Dr" ; -- comment=src=eng status=guess
lin drab_A = mkA "单调" ;
lin dracaena_N = mkN "不才树" | mkN "狭叶龙血树" | mkN "长花龙血树" | mkN "马骡蔗树" | mkN "龙血树" ; -- open-multilingual-wordnet
lin drachma_N = mkN "德拉克馬" | mkN "德拉克马" ; -- status=guess -- status=guess
lin draconian_A = mkA "严峻" ;
lin draft_N = mkN "草案" ;
lin draft_V2 = mkV2 "起草" ;
lin draftsman_N = mkN "起草者" ;
lin drag_N = mkN "拖" "" ;
lin drag_V = mkV "拉" | {-HSK-} mkV "拖动" ;
lin drag_V2 = mkV2 "拉" | {-HSK-} mkV2 "拖动" ;
lin drag_down_V = advV OP_drag_V OP_down_Adv ; -- guess-p-verb
lin drag_in_V = advV OP_drag_V OP_in_Adv ; -- guess-p-verb
lin drag_on_V = advV OP_drag_V OP_on_Adv ; -- guess-p-verb
lin dragee_N = mkN "糖衣药丸" ; -- open-multilingual-wordnet
lin draggled_A = mkA "全身泥污" | mkA "被泥弄脏" ; -- open-multilingual-wordnet
lin dragon_N = mkN "龙" "条" | {-HSK-} mkN "龙" "條" ;
lin dragonet_N = mkN "龙鱼" ; -- open-multilingual-wordnet
lin dragonfly_N = mkN "蜻蜓" ; -- status=guess -- open-multilingual-wordnet
lin drain_N = mkN "排水" ;
lin drain_V = mkV "流干" ;
lin drain_V2 = mkV2 "使+流出" ;
lin drainage_N = {-mwn-} mkN "使流出" | mkN "排掉水" | mkN "放干" | mkN "流干" ; -- open-multilingual-wordnet
lin drainplug_N = mkN "放泄塞" ; -- open-multilingual-wordnet
lin dram_N = mkN "微量" ;
lin drama_N = mkN "戏剧" | {-HSK-} mkN "戏曲" ;
lin dramatic_A = mkA "戏剧性" ;
lin dramatization_N = mkN "戏剧" "场" ;
lin dramaturgic_A = mkA "戏剧作法" | mkA "演出" ; -- open-multilingual-wordnet
lin dramaturgy_N = mkN "戏剧艺术" | mkN "演出法" | mkN "舞台演出艺术" ; -- open-multilingual-wordnet
lin drape_N = mkN "窗帘" "块" ;
lin drape_V2 = mkV2 "悬垂" ;
lin drastic_A = mkA "激烈" ;
lin draughts_N = mkN "國際跳棋" | mkN "国际跳棋" | mkN "跳棋" ; -- status=guess -- status=guess -- status=guess
lin draw_1_V2 = mkV2 "画" ;
lin draw_2_V2 = mkV2 "画" ;
lin draw_N = mkN "平局" ;
lin draw_V = mkV "平" | mkV "拉" | mkV "画" | {-HSK-} mkV "绘制" ;
lin draw_V2 = mkV2 "画" ;
lin draw_back_V2 = mkV2 (advV OP_draw_V OP_back_Adv ) ; -- guess-p-verb
lin draw_down_V2 = prepV2 OP_draw_V OP_down_Prep ; -- guess-p-verb
lin draw_even_V = advV OP_draw_V OP_even_Adv ; -- guess-p-verb
lin draw_in_V = advV OP_draw_V OP_in_Adv ; -- guess-p-verb
lin draw_into_V2 = prepV2 OP_draw_V OP_into_Prep ; -- guess-p-verb
lin draw_off_V = advV OP_draw_V OP_off_Adv ; -- guess-p-verb
lin draw_on_V = advV OP_draw_V OP_on_Adv ; -- guess-p-verb
lin draw_on_V2 = prepV2 OP_draw_V OP_on_Prep ; -- guess-p-verb
lin draw_out_V2 = prepV2 OP_draw_V OP_out_Prep ; -- guess-p-verb
lin draw_up_V = mkV "制定" ;
lin draw_up_V2 = mkV2 "制定" ;
lin drawback_N = mkN "缺陷" "个" ;
lin drawbridge_N = mkN "弔橋" | mkN "吊橋" | mkN "吊桥" ; -- status=guess -- status=guess -- status=guess
lin drawer_N = mkN "开票人" | {-HSK-} mkN "抽屉" ;
lin drawing_N = mkN "绘画" ;
lin drawknife_N = mkN "拉刮刀" ; -- open-multilingual-wordnet
lin drawl_N = mkN "拉长声音说话" ;
lin drawnwork_N = mkN "抽花绣" ; -- open-multilingual-wordnet
lin dray_N = mkN "運貨馬車" | mkN "运货马车" ; -- status=guess -- status=guess
lin drayton_PN = foreignPN "Drayton" ; -- comment=src=eng status=guess
lin dread_N = mkN "恐惧" [] ;
lin dread_V = mkV "恐怕" | {-HSK-} mkV "惧怕" ;
lin dread_V2 = mkV2 "恐怕" | {-HSK-} mkV2 "惧怕" ;
lin dreadful_A = mkA "可怕" ;
lin dreadnought_N = mkN "无畏级战舰" ; -- open-multilingual-wordnet
lin dream_N = mkN "梦" "場" | {-HSK-} mkN "梦想" ;
lin dream_V = mkV "梦想" ;
lin dream_V2 = mkV2 "梦想" ;
lin dream_of_V2 = prepV2 OP_dream_V OP_of_Prep ; -- guess-p-verb
lin dream_up_V2 = prepV2 OP_dream_V OP_up_Prep ; -- guess-p-verb
lin dreamer_N = mkN "空想家" ; -- status=guess
lin dreamless_A = mkA "不做梦" | mkA "无梦" ; -- open-multilingual-wordnet
lin dreamlike_A = mkA "不真实" | mkA "梦一般" | mkA "玄妙" | mkA "超现实" ; -- open-multilingual-wordnet
lin dreamworld_N = mkN "梦境" ; -- status=guess
lin dreamy_A = mkA "梦想" ;
lin dreary_A = mkA "枯燥" ;
lin dreg_N = mkN "少量" | mkN "微量" | mkN "渣滓量" ; -- open-multilingual-wordnet
lin drenching_N = mkN "淋" ;
lin dresden_PN = mkPN "德累斯顿" ; -- comment=src=geonames status=guess
lin dress_A = mkA "服装" | mkA "装" ;
lin dress_N = mkN "服装" "身" | mkN "装" | {-HSK-} mkN "穿着" ;
lin dress_V = mkV "打扮" | mkV "穿" | {-HSK-} mkV "穿着" ;
lin dress_V2 = mkV2 "打扮" | mkV2 "穿" | {-HSK-} mkV2 "穿衣" ;
lin dress_down_V = advV OP_dress_V OP_down_Adv ; -- guess-p-verb
lin dress_down_V2 = prepV2 OP_dress_V OP_down_Prep ; -- guess-p-verb
lin dress_up_V = advV OP_dress_V OP_up_Adv ; -- guess-p-verb
lin dress_up_V2 = prepV2 OP_dress_V OP_up_Prep ; -- guess-p-verb
lin dresser_N = mkN "五斗柜" | mkN "抽屉柜" | mkN "衣柜" ; -- open-multilingual-wordnet
lin dressing_N = mkN "穿衣" "次" ;
lin dressmaker_N = mkN "裁縫" | mkN "裁缝" ; -- status=guess -- status=guess
lin dressmaking_N = mkN "制衣" ;
lin dribble_V = mkV "滴涎" ; -- status=guess, src=wikt
lin dribble_V2 = mkV2 (mkV "滴涎") ; -- status=guess, src=wikt
lin driblet_N = mkN "点滴" ; -- open-multilingual-wordnet
lin driffield_PN = foreignPN "Driffield" ; -- comment=src=geonames status=guess
lin drift_N = mkN "漂移" ;
lin drift_V = mkV "漂移" ;
lin drift_V2 = mkV2 "使+漂移" ;
lin drift_apart_V = mkV "疏远" ;
lin drill_N = mkN "练习" "個" | {-HSK-} mkN "钻子" ;
lin drill_V = mkV "演练" | {-HSK-} mkV "训练" ;
lin drill_V2 = mkV2 "练习" | {-HSK-} mkV2 "训练" ;
lin drink_N = mkN "饮料" | {-HSK-} mkN "饮料" "杯" ;
lin drink_V = mkV "喝" ;
lin drink_V2 = L.drink_V2 ;
lin drink_up_V2 = prepV2 OP_drink_V OP_up_Prep ; -- guess-p-verb
lin drinkable_A = mkA "可飲用" | mkA "可饮用" | {-mwn-} mkA "可以喝" | mkA "适于饮用" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin drinker_N = mkN "酒徒" ;
lin drinking_N = mkN "饮用水" [] ;
lin drip_N = mkN "水滴""滴" ;
lin drip_V = mkV "滴" | {-HSK-} mkV "滴下" ;
lin drip_V2 = mkV2 "使+滴下" | {-HSK-} mkV2 "滴" ;
lin dripstone_N = mkN "滴水石" ; -- open-multilingual-wordnet
lin drive_N = mkN "驱动" ;
lin drive_V = mkV "驾驶" ;
lin drive_V2 = mkV2 "驱动" ;
lin drive_V2V = mkV2V "驱动" ;
lin drive_away_V2 = mkV2 (advV OP_drive_V OP_away_Adv ) ; -- guess-p-verb
lin drive_back_V2 = mkV2 (advV OP_drive_V OP_back_Adv ) ; -- guess-p-verb
lin drive_by_V = advV OP_drive_V OP_by_Adv ; -- guess-p-verb
lin drive_down_V = advV OP_drive_V OP_down_Adv ; -- guess-p-verb
lin drive_off_V = advV OP_drive_V OP_off_Adv ; -- guess-p-verb
lin drive_out_V2 = prepV2 OP_drive_V OP_out_Prep ; -- guess-p-verb
lin drive_up_V = advV OP_drive_V OP_up_Adv ; -- guess-p-verb
lin drive_up_V2 = prepV2 OP_drive_V OP_up_Prep ; -- guess-p-verb
lin drivel_N = mkN "胡说" ;
lin driverFem_N = mkN "司机" ;
lin driverMasc_N = mkN "司机" ;
lin driver_N = mkN "司机" "個" | {-HSK-} mkN "司機" | mkN "司机" | mkN "開車人" | mkN "开车人" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin driveshaft_N = mkN "传动轴" | mkN "驱动轴" ; -- open-multilingual-wordnet
lin driveway_N = mkN "車道" | mkN "车道" | mkN "專用支路" | mkN "专用支路" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin driving_A = variants {} ;
lin driving_N = mkN "驾驶" "次" ;
lin drizzle_N = mkN "細雨" | mkN "细雨" | mkN "毛毛雨" | mkN "小雨" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin drizzly_A = mkA "下毛毛雨" | mkA "下雨" | mkA "湿淋淋" | mkA "蒙蒙细雨" ; -- open-multilingual-wordnet
lin drogheda_PN = mkPN "德羅赫達" ; -- comment=src=geonames status=guess
lin drogue_N = mkN "刹车伞" ; -- open-multilingual-wordnet
lin droitwich_PN = foreignPN "Droitwich" ; -- comment=src=geonames status=guess
lin dromedary_N = mkN "單峰駝" | mkN "单峰驼" | mkN "單峰駱駝" | mkN "单峰骆驼" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin dronabinol_N = mkN "屈大麻酚" ; -- open-multilingual-wordnet
lin drone_N = mkN "雄蜂" ; -- status=guess
lin dronfield_PN = foreignPN "Dronfield" ; -- comment=src=geonames status=guess
lin drool_V = mkV "流口水" ;
lin droop_N = mkN "下垂""" ;
lin droop_V = mkV "下垂" ;
lin droop_V2 = mkV2 "使+下垂" ;
lin drop_N = mkN "下降" | {-HSK-} mkN "点" ;
lin drop_V = mkV "下降" | {-HSK-} mkV "掉" ;
lin drop_V2 = mkV2 "下降" | {-HSK-} mkV2 "掉" ;
lin drop_around_V = advV OP_drop_V OP_around_Adv ; -- guess-p-verb
lin drop_around_V2 = prepV2 OP_drop_V OP_around_Prep ; -- guess-p-verb
lin drop_away_V = advV OP_drop_V OP_away_Adv ; -- guess-p-verb
lin drop_back_V = advV OP_drop_V OP_back_Adv ; -- guess-p-verb
lin drop_by_V = advV OP_drop_V OP_by_Adv ; -- guess-p-verb
lin drop_in_V = advV OP_drop_V OP_in_Adv ; -- guess-p-verb
lin drop_in_on_V2 = prepV2 (advV OP_drop_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin drop_off_V = advV OP_drop_V OP_off_Adv ; -- guess-p-verb
lin drop_off_V2 = prepV2 OP_drop_V OP_off_Prep ; -- guess-p-verb
lin drop_out_V = mkV "中途退出" | mkV "放弃" | mkV "退出" | mkV "退学" ; -- open-multilingual-wordnet
lin drop_out_of_V2 = prepV2 (advV OP_drop_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin drop_over_V = advV OP_drop_V OP_over_Adv ; -- guess-p-verb
lin drop_round_V = advV OP_drop_V OP_round_Adv ; -- guess-p-verb
lin drop_round_V2 = prepV2 OP_drop_V OP_round_Prep ; -- guess-p-verb
lin drop_someone_in_it_V2 = variants {} ; -- guess-p-verb
lin drop_through_V = advV OP_drop_V OP_through_Adv ; -- guess-p-verb
lin droplet_N = mkN "小滴" ; -- status=guess
lin dropout_N = mkN "肄业生" ;
lin dropper_N = mkN "点滴器" ; -- open-multilingual-wordnet
lin droppings_N = mkN "糞" | mkN "粪" | {-mwn-} mkN "屎" | mkN "粪肥" | mkN "肥" | mkN "肥料" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin drought_N = mkN "干旱" ;
lin drove_N = mkN "移动的一群" ;
lin drown_V = mkV "淹没" ;
lin drown_V2 = mkV2 "溺" ;
lin drowsiness_N = mkN "睡意" | {-mwn-} mkN "困倦" | mkN "昏昏睡睡" | mkN "瞌睡" ; -- status=guess -- open-multilingual-wordnet
lin drowsy_A = mkA "想睡" | mkA "昏昏欲睡" | mkA "睏" | mkA "困" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin drubbing_N = mkN "殴打" ;
lin drudge_V = mkV "忙碌工作" | mkV "辛劳工作" | mkV "辛苦工作" ; -- open-multilingual-wordnet
lin drudgery_N = mkN "苦差事" ; -- status=guess
lin drug_N = mkN "药" "種" | {-HSK-} mkN "药物" ;
lin drug_V2 = mkV2 "使+服麻醉药" ;
lin drugget_N = mkN "粗毛毯" ; -- open-multilingual-wordnet
lin drugstore_N = mkN "药店" ;
lin druid_N = mkN "德魯伊" | mkN "德鲁伊" ; -- status=guess -- status=guess
lin drum_N = mkN "鼓" ;
lin drum_V = mkV "鼓" ;
lin drumhead_N = mkN "鼓面" ; -- open-multilingual-wordnet
lin drummer_N = mkN "鼓手" "名" ;
lin drumstick_N = mkN "雞腿" | mkN "鸡腿" ; -- status=guess -- status=guess
lin drunk_A = mkA "喝醉" ;
lin drunk_N = mkN "醉汉" ;
lin drunkard_N = mkN "酒鬼" | mkN "醉鬼" | mkN "酒徒" | mkN "酒客" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin drunkenness_N = mkN "醉态" ;
lin drupaceous_A = mkA "核果" | mkA "核果性" ; -- open-multilingual-wordnet
lin drupe_N = mkN "核果" ; -- open-multilingual-wordnet
lin drupelet_N = mkN "小核果" ; -- open-multilingual-wordnet
lin dry_A = L.dry_A ;
lin dry_N = mkN "乾洗" | mkN "干洗" ; -- status=guess -- status=guess
lin dry_V = mkV "干" ;
lin dry_V2 = mkV2 "干" ;
lin dry_clean_V2 = mkV2 (advV OP_dry_V OP_clean_Adv ) ; -- guess-p-verb
lin dry_off_V2 = prepV2 OP_dry_V OP_off_Prep ; -- guess-p-verb
lin dry_out_V = advV OP_dry_V OP_out_Adv ; -- guess-p-verb
lin dry_out_V2 = prepV2 OP_dry_V OP_out_Prep ; -- guess-p-verb
lin dry_up_V = advV OP_dry_V OP_up_Adv ; -- guess-p-verb
lin dry_up_V2 = prepV2 OP_dry_V OP_up_Prep ; -- guess-p-verb
lin dryer_N = mkN "烘乾機" | mkN "烘干机" | mkN "乾衣機" | mkN "干衣机" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin drygoods_N = mkN "纺织品" ; -- open-multilingual-wordnet
lin dryness_N = mkN "干燥" ;
lin dryopithecine_N = mkN "森林古猿" ; -- open-multilingual-wordnet
lin dual_A = mkA "双重" ;
lin dub_V2 = mkV2 "打击" ;
lin dub_V3 = mkV3 "配音" ;
lin dubbin_N = mkN "皮革用防水油" ; -- open-multilingual-wordnet
lin dubbing_N = mkN "配音" | {-mwn-} mkN "皮革用防水油" ; -- status=guess -- open-multilingual-wordnet
lin dubiety_N = mkN "不确定" | mkN "怀疑" ; -- open-multilingual-wordnet
lin dubious_A = mkA "可疑" ;
lin dubiousness_N = mkN "怀疑" | mkN "疑问" | mkN "质询" | mkN "问题" ; -- open-multilingual-wordnet
lin dublin_PN = mkPN ("都伯林" | "都柏林") ; -- comment=src=geonames status=guess
lin dubnium_N = mkN "𨧀" ; -- status=guess
lin ducal_A = mkA "与公爵有关" | mkA "公爵" ; -- open-multilingual-wordnet
lin ducat_N = mkN "达克特" ; -- open-multilingual-wordnet
lin duchess_N = mkN "公爵夫人" ; -- status=guess
lin duchy_N = mkN "公國" | mkN "公国" ; -- status=guess -- status=guess
lin duck_N = mkN "鸭" "只" ;
lin duck_V = mkV "没入水中" ;
lin duckling_N = mkN "小鸭子" "只" ;
lin duckpin_N = mkN "鸭柱" ; -- open-multilingual-wordnet
lin duckweed_N = mkN "苹" | mkN "萍" | mkN "浮萍" | mkN "水萍" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin duct_N = mkN "用导管输送" ;
lin ductless_A = mkA "无管" ; -- open-multilingual-wordnet
lin dud_N = mkN "哑弹" ;
lin dude_N = mkN "家伙" | mkN "小伙子" ; -- status=guess -- status=guess
lin dudgeon_N = mkN "愤怒" "" ;
lin dudley_PN = mkPN "達德利" ; -- comment=src=geonames status=guess
lin due_A = mkA "应有" ;
lin due_Adv = mkAdv "应有" ;
lin due_N = mkN "应付款" ;
lin duel_N = mkN "决斗" ;
lin duel_V = mkV "決鬥" | mkV "决斗" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin duet_N = mkN "二重奏" ;
lin duffel_N = mkN "一种粗呢" | mkN "粗厚起绒呢料" ; -- open-multilingual-wordnet
lin duffer_N = mkN "笨蛋" "个" ;
lin duffle_N = mkN "一种粗呢" | mkN "粗厚起绒呢料" ; -- open-multilingual-wordnet
lin dugong_N = mkN "儒艮" ; -- status=guess
lin dugout_N = mkN "防空壕" ; -- open-multilingual-wordnet
lin duisburg_PN = mkPN "杜伊斯堡" ; -- comment=src=geonames status=guess
lin duke_N = mkN "公爵" ;
lin dukinfield_PN = foreignPN "Dukinfield" ; -- comment=src=geonames status=guess
lin dull_A = L.dull_A ;
lin dull_V = mkV "减少" ;
lin dull_V2 = mkV2 "使+迟钝" ;
lin dullness_N = mkN "迟钝" ;
lin duly_AdV = mkAdV "适当地" ;
lin duly_Adv = variants {} ; -- comment=mkAdV "适当地" ;
lin dumb_A = mkA "哑" ;
lin dumbarton_PN = mkPN "邓巴顿" ; -- comment=src=geonames status=guess
lin dumbbell_N = mkN "啞鈴" | mkN "哑铃" ; -- status=guess -- status=guess
lin dumbfound_V2 = mkV2 "使+惊讶得发呆" ;
lin dumbwaiter_N = mkN "升降机" ; -- open-multilingual-wordnet
lin dumdum_N = mkN "达姆弹" ; -- open-multilingual-wordnet
lin dumfries_PN = foreignPN "Dumfries" ; -- comment=src=geonames status=guess
lin dummy_N = mkN "傀儡" ;
lin dump_N = mkN "垃圾场" ;
lin dump_V = mkV "倾倒" ;
lin dump_V2 = mkV2 "倾倒" ;
lin dumpcart_N = mkN "垃圾车" ; -- open-multilingual-wordnet
lin dumper_N = mkN "自倾货车" | mkN "自动倾卸卡车" | mkN "自动式倾卸汽车" ; -- open-multilingual-wordnet
lin dumping_N = mkN "傾銷" | mkN "倾销" ; -- status=guess -- status=guess
lin dumpling_N = mkN "饺子" "個" | {-HSK-} mkN "饺子""颗" ;
lin dumps_N = mkN "忧郁" | mkN "沮丧" | mkN "郁闷" ; -- open-multilingual-wordnet
lin dun_A = mkA "暗褐色" ; -- open-multilingual-wordnet
lin dun_N = mkN "灰兔褐色马" ; -- open-multilingual-wordnet
lin dun_laoghaire_PN = foreignPN "Dun laoghaire" ; -- comment=src=eng status=guess
lin duncan_PN = foreignPN "Duncan" ; -- comment=src=geonames status=guess
lin dundalk_PN = mkPN "邓多克" ; -- comment=src=geonames status=guess
lin dundee_PN = mkPN "邓迪" ; -- comment=src=geonames status=guess
lin dune_N = mkN "沙丘" "座" ;
lin dunfermline_PN = foreignPN "Dunfermline" ; -- comment=src=geonames status=guess
lin dung_N = mkN "粪" "坨" ;
lin dungeon_N = mkN "城堡主樓" | mkN "城堡主楼" | mkN "樓櫓" | mkN "楼橹" | {-mwn-} mkN "土牢" | mkN "地牢" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin dunghill_N = mkN "糞堆" | mkN "粪堆" ; -- status=guess -- status=guess
lin dunk_N = mkN "扣籃" | mkN "扣篮" ; -- status=guess -- status=guess
lin dunkirk_PN = foreignPN "Dunkirk" ; -- comment=src=geonames status=guess
lin dunoon_PN = foreignPN "Dunoon" ; -- comment=src=geonames status=guess
lin dunstable_PN = mkPN "鄧斯特布爾" ; -- comment=src=geonames status=guess
lin duo_N = mkN "二重唱" | mkN "二重奏" ; -- status=guess -- status=guess
lin duodenal_A = mkA "十二指肠" ;
lin duodenum_N = mkN "十二指腸" | mkN "十二指肠" ; -- status=guess -- status=guess
lin dupe_V2 = mkV2 "欺骗" ;
lin dupl_PN = foreignPN "Dupl" ; -- comment=src=eng status=guess
lin duplex_A = mkA "双重" ; -- status=guess -- status=guess
lin duplicate_N = mkN "複本" | mkN "复本" | mkN "複製" | mkN "复制" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin duplicate_V2 = mkV2 "复制" | {-HSK-} mkV2 "重复" ;
lin duplication_N = mkN "复制" ;
lin duplicator_N = mkN "复印机" ; -- open-multilingual-wordnet
lin duplicity_N = mkN "双重性" "种" ;
lin durability_N = mkN "耐久性" "" ;
lin durable_A = mkA "耐用" ;
lin durable_N = mkN "耐用" [] ;
lin dural_A = mkA "硬脊膜" | mkA "硬脑膜" ; -- open-multilingual-wordnet
lin durance_N = mkN "监禁" ; -- open-multilingual-wordnet
lin duration_N = mkN "持续" ;
lin durative_N = mkN "持续时态" ; -- open-multilingual-wordnet
lin durban_PN = mkPN "德班" ; -- comment=src=geonames status=guess
lin durham_PN = mkPN ("德罕" | "達拉謨") ; -- comment=src=geonames status=guess
lin durian_N = mkN "榴連果" | mkN "榴连果" | mkN "榴潑果" | mkN "榴泼果" | mkN "榴蓮果" | mkN "榴莲果" | mkN "榴槤果" | mkN "榴槤果" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin during_Prep = S.during_Prep ;
lin durrington_PN = foreignPN "Durrington" ; -- comment=src=geonames status=guess
lin dursley_PN = foreignPN "Dursley" ; -- comment=src=geonames status=guess
lin dusk_N = mkN "黄昏" ;
lin dusseldorf_PN = foreignPN "Dusseldorf" ; -- comment=src=eng status=guess
lin dust_N = L.dust_N | {-HSK-} mkN "灰" | mkN "灰尘" ;
lin dust_V2 = mkV2 "拂尘" ;
lin dustbin_N = mkN "垃圾桶" ;
lin dustcart_N = mkN "垃圾车" ; -- open-multilingual-wordnet
lin dustcloth_N = mkN "抹布" | mkN "防尘布" ; -- open-multilingual-wordnet
lin duster_N = mkN "抹布" ; -- status=guess
lin dustlike_A = mkA "尘[粉]状" | mkA "尘状" ; -- open-multilingual-wordnet
lin dustmop_N = mkN "墩布" ; -- open-multilingual-wordnet
lin dustpan_N = mkN "掃把和簸箕" | mkN "扫把和簸箕" | mkN "垃圾鏟" | mkN "垃圾铲" | mkN "簸箕" | mkN "usually made of bamboo or wicker)" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin dusty_A = mkA "含糊" ;
lin dutchFem_N = mkN "荷兰人" ;
lin dutchMasc_N = mkN "荷兰人" ;
lin dutch_A = mkA "荷兰" ;
lin dutiable_A = mkA "应纳关税" ; -- open-multilingual-wordnet
lin dutiful_A = mkA "忠实" ;
lin duty_N = mkN "义务" "項" | mkN "任务" "項" | mkN "责任" "個" | {-HSK-} mkN "责任" ;
lin duty_free_A = mkA "免税" ;
lin duvet_N = mkN "羽絨被" | mkN "羽绒被" ; -- status=guess -- status=guess
lin dwarf_N = mkN "矮人" ;
lin dwarf_V2 = mkV2 "变矮" ;
lin dwarfism_N = mkN "侏儒症" ; -- open-multilingual-wordnet
lin dwell_V = mkV "住" ;
lin dweller_N = mkN "居民" ;
lin dwelling_N = mkN "住宅" ;
lin dwindle_V = mkV "缩小" ;
lin dye_N = mkN "染料" "种" ;
lin dye_V = mkV "染" ;
lin dye_V2 = mkV2 "染料" ;
lin dyed_in_the_wool_A = mkA "生染得" ;
lin dyestuff_N = mkN "染料" | mkN "染液" | mkN "染色剂" ; -- open-multilingual-wordnet
lin dyfed_PN = foreignPN "Dyfed" ; -- comment=src=eng status=guess
lin dyke_N = mkN "坝" | mkN "堤坝" | mkN "堰" | mkN "水坝" ; -- open-multilingual-wordnet
lin dynamic_A = mkA "动态" ;
lin dynamic_N = mkN "动态" [] ;
lin dynamics_N = mkN "動力學" | mkN "动力学" ; -- status=guess -- status=guess
lin dynamism_N = mkN "活力" ;
lin dynamite_N = mkN "炸药" "包" ;
lin dynamo_N = mkN "发电机" ;
lin dynamometer_N = mkN "功率计" | mkN "电功率计" ; -- open-multilingual-wordnet
lin dynastic_A = mkA "朝代" | mkA "王朝" ; -- open-multilingual-wordnet
lin dynasty_N = mkN "朝" | mkN "朝代" ;
lin dyne_N = mkN "达因" ; -- open-multilingual-wordnet
lin dysaphia_N = mkN "触觉迟钝" | mkN "触觉障碍" ; -- open-multilingual-wordnet
lin dysarthria_N = mkN "发音困难" ; -- open-multilingual-wordnet
lin dyscalculia_N = mkN "计算障碍" ; -- open-multilingual-wordnet
lin dyschezia_N = mkN "大便困难" ; -- open-multilingual-wordnet
lin dyscrasia_N = mkN "体液不调" | mkN "恶液质" ; -- open-multilingual-wordnet
lin dysentery_N = mkN "痢疾" | mkN "白痢" | mkN "赤痢" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin dysfunction_N = mkN "功能障礙" | mkN "功能障碍" | {-mwn-} mkN "机能不良" | mkN "机能障碍" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dysgenesis_N = mkN "发育不全" | mkN "发育不良" | mkN "生殖力障碍" ; -- open-multilingual-wordnet
lin dysgenic_A = mkA "劣生" | mkA "种族退化" | mkA "非优生学" ; -- open-multilingual-wordnet
lin dysgraphia_N = mkN "书写困难" ; -- open-multilingual-wordnet
lin dyskinesia_N = mkN "运动障碍" ; -- open-multilingual-wordnet
lin dyslexia_N = mkN "失讀症" | {-mwn-} mkN "失读症" | mkN "难语症" ; -- status=guess -- open-multilingual-wordnet
lin dyslogia_N = mkN "难语症" ; -- open-multilingual-wordnet
lin dysmenorrhea_N = mkN "月经困难" | mkN "痛经" ; -- open-multilingual-wordnet
lin dysosmia_N = mkN "嗅觉障碍" ; -- open-multilingual-wordnet
lin dyspepsia_N = mkN "消化不良" | mkN "肚子痛" ; -- open-multilingual-wordnet
lin dyspeptic_A = mkA "消化不良" | mkA "胃弱" ; -- open-multilingual-wordnet
lin dysphagia_N = mkN "吞咽困难" ; -- open-multilingual-wordnet
lin dysphonia_N = mkN "发声困难" ; -- open-multilingual-wordnet
lin dysplasia_N = mkN "发育不良" ; -- open-multilingual-wordnet
lin dysplastic_A = mkA "发育不良" | mkA "发育异常" ; -- open-multilingual-wordnet
lin dyspnea_N = mkN "呼吸困難" | mkN "呼吸困难" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dysprosium_N = mkN "鏑" | mkN "镝" ; -- status=guess -- status=guess
lin dysthymia_N = mkN "抑郁性抑郁症" ; -- open-multilingual-wordnet
lin dystopia_N = mkN "反烏托邦" | mkN "反乌托邦" ; -- status=guess -- status=guess
lin dystrophy_N = mkN "萎縮症" | mkN "萎缩症" | {-mwn-} mkN "营养失调" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin dysuria_N = mkN "排尿困难" ; -- open-multilingual-wordnet
lin each_Adv = mkAdv "各" | mkAdv "各自" | mkAdv "每" | {-HSK-} mkAdv "每个" ;
lin each_Det = mkpDet "各" | mkpDet "各自" | mkpDet "每" | {-HSK-} mkpDet "皆" ;
lin eager_A = mkA "急于" ;
lin eagerness_N = mkN "渴望" [] ;
lin eagle_N = mkN "鹰" "只" ;
lin eaglescliffe_PN = foreignPN "Eaglescliffe" ; -- comment=src=geonames status=guess
lin eaglet_N = mkN "小鷹" | mkN "小鹰" ; -- status=guess -- status=guess
lin ealing_PN = mkPN "伊灵" ; -- comment=src=geonames status=guess
lin ear_N = L.ear_N | {-HSK-} mkN "耳朵" "隻" ;
lin earache_N = mkN "耳痛" ; -- open-multilingual-wordnet
lin eardrum_N = mkN "鼓膜" | mkN "耳鼓" | mkN "耳膜" ; -- status=guess -- status=guess -- status=guess
lin earflap_N = mkN "帽耳" | mkN "耳扇" | mkN "耳罩" ; -- open-multilingual-wordnet
lin earl_N = mkN "伯爵" "位" ;
lin earl_shilton_PN = foreignPN "Earl shilton" ; -- comment=src=eng status=guess
lin earless_A = mkA "沒有耳朵" | mkA "没有耳朵" ; -- status=guess -- status=guess
lin earlier_A = mkA "早" ;
lin earlier_Adv = mkAdv "早期" ;
lin earlobe_N = mkN "朵" ;
lin early_A = mkA "先" | {-HSK-} mkA "早" ;
lin early_Adv = mkAdv "先" | {-HSK-} mkAdv "早" ;
lin early_on_Adv = mkAdv "在早期" ;
lin earmark_V2 = mkV2 "耳上记号" ;
lin earmuff_N = mkN "耳套" | mkN "耳罩" | mkN "耳包子" | {-mwn-} mkN "御寒耳罩" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin earn_V = mkV "赚" ;
lin earn_V2 = mkV2 "赚得" ;
lin earnest_A = mkA "认真" ;
lin earnest_N = mkN "认真" | {-HSK-} mkN "认真" [] ;
lin earning_N = variants {} ;
lin earphone_N = mkN "耳機" | mkN "耳机" | {-mwn-} mkN "受话器" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin earpiece_N = mkN "受话器" | mkN "耳机" ; -- open-multilingual-wordnet
lin earplug_N = mkN "耳塞" | mkN "耳栓" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin earring_N = mkN "耳环" "只" ; -- comment="耳饰" ;
lin earth_N = L.earth_N ;
lin earthen_A = mkA "泥制" ; -- open-multilingual-wordnet
lin earthenware_N = mkN "陶器" ; -- status=guess -- open-multilingual-wordnet
lin earthlike_A = mkA "土壤色" ; -- open-multilingual-wordnet
lin earthly_A = mkA "丑" | {-HSK-} mkA "尘世" ;
lin earthquake_N = mkN "地震" ;
lin earthstar_N = mkN "地星" | mkN "地蜘蛛" | mkN "米屎菰" ; -- open-multilingual-wordnet
lin earthtongue_N = mkN "地舌菌" ; -- open-multilingual-wordnet
lin earthwork_N = mkN "土木工事" | mkN "土木工程" ; -- open-multilingual-wordnet
lin earthworm_N = mkN "蚯蚓" ;
lin earthy_A = mkA "泥土" ;
lin earwax_N = mkN "耳屎" | mkN "耳垢" | mkN "耵聹" | mkN "耵聍" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin earwig_N = mkN "蠼螋" ; -- status=guess -- open-multilingual-wordnet
lin ease_N = mkN "安逸" [] ;
lin ease_V = mkV "减轻" | {-HSK-} mkV "缓解" ;
lin ease_V2 = mkV2 "缓解" ;
lin ease_off_V2 = prepV2 OP_ease_V OP_off_Prep ; -- guess-p-verb
lin ease_up_V = advV OP_ease_V OP_up_Adv ; -- guess-p-verb
lin easel_N = mkN "黑板架" | mkN "畫架" | mkN "画架" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin easement_N = mkN "地役权" | {-mwn-} mkN "减轻" | mkN "缓和" ; -- status=guess -- open-multilingual-wordnet
lin easington_PN = foreignPN "Easington" ; -- comment=src=geonames status=guess
lin east_A = mkA "东" | {-HSK-} mkA "东方" ;
lin east_Adv = mkAdv "东" ;
lin east_N = mkN "东" | {-HSK-} mkN "东" "" ;
lin east_dereham_PN = foreignPN "East dereham" ; -- comment=src=eng status=guess
lin east_grinstead_PN = foreignPN "East grinstead" ; -- comment=src=eng status=guess
lin east_kilbride_PN = foreignPN "East kilbride" ; -- comment=src=eng status=guess
lin east_retford_PN = foreignPN "East retford" ; -- comment=src=eng status=guess
lin eastbourne_PN = mkPN "伊斯特本" ; -- comment=src=geonames status=guess
lin easter_PN = foreignPN "Easter" ; -- comment=src=eng status=guess
lin easterly_A = variants {} ;
lin easterly_Adv = adjAdv easterly_A ; -- derived
lin eastern_A = mkA "东" ;
lin easterner_N = mkN "東方人" | mkN "东方人" ; -- status=guess -- status=guess
lin eastleigh_PN = mkPN "伊斯特利" ; -- comment=src=geonames status=guess
lin eastward_Adv = mkAdv "向东" ;
lin easy_A = mkA "便" | mkA "容易" | mkA "轻" | {-HSK-} mkA "简单" ;
lin easy_A2V = L.easy_A2V ;
lin easy_Adv = mkAdv "便" | mkAdv "容易" | mkAdv "轻" ;
lin easy_V2V = mkV2V "发出停止命令" ;
lin easygoing_A = mkA "逍遥自在" ;
lin eat_V = mkV "吃" ;
lin eat_V2 = L.eat_V2 ;
lin eat_away_V = advV OP_eat_V OP_away_Adv ; -- guess-p-verb
lin eat_away_V2 = mkV2 (advV OP_eat_V OP_away_Adv ) ; -- guess-p-verb
lin eat_in_V = advV OP_eat_V OP_in_Adv ; -- guess-p-verb
lin eat_into_V2 = prepV2 OP_eat_V OP_into_Prep ; -- guess-p-verb
lin eat_out_V = advV OP_eat_V OP_out_Adv ; -- guess-p-verb
lin eat_up_V2 = prepV2 OP_eat_V OP_up_Prep ; -- guess-p-verb
lin eater_N = mkN "食者" ;
lin eating_N = mkN "吃" "次" ;
lin eau_de_cologne_N = mkN "古龙水" | mkN "科隆香水" | mkN "香水" ; -- open-multilingual-wordnet
lin eaves_N = mkN "屋檐" | mkN "檐" | {-mwn-} mkN "房檐" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin eavesdrop_V = mkV "窃听" ;
lin ebb_N = mkN "退潮" ;
lin ebb_V = mkV "衰退" ;
lin ebbw_vale_PN = foreignPN "Ebbw vale" ; -- comment=src=eng status=guess
lin ebon_A = mkA "乌黑发亮" | mkA "乌黑色" | mkA "似乌木" | mkA "黑檀树色" ; -- open-multilingual-wordnet
lin ebonite_N = mkN "硬膠" | mkN "硬胶" | mkN "硬橡膠" | mkN "硬橡胶" | {-mwn-} mkN "硬化橡皮" | mkN "硬质橡胶" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin ebony_A = mkA "乌黑发亮" | mkA "乌黑色" | mkA "似乌木" | mkA "黑檀树色" ; -- open-multilingual-wordnet
lin ebony_N = mkN "烏黑" | mkN "乌黑" ; -- status=guess -- status=guess
lin ebracteate_A = mkA "无苞" ; -- open-multilingual-wordnet
lin ebullient_A = mkA "热情洋溢" ;
lin eburnation_N = mkN "骨质致密化" | mkN "骨质象牙化" ; -- open-multilingual-wordnet
lin eccentric_A = mkA "偏心" ;
lin eccentric_N = mkN "古怪的人" ;
lin eccles_PN = foreignPN "Eccles" ; -- comment=src=geonames status=guess
lin ecclesiastical_A = mkA "传教士" | mkA "教会" | mkA "牧师" | mkA "神职" ; -- open-multilingual-wordnet
lin echelon_N = mkN "梯形" ;
lin echidna_N = mkN "針鼴" | mkN "针鼹" ; -- status=guess -- status=guess
lin echinococcosis_N = mkN "包虫病" ; -- open-multilingual-wordnet
lin echinoderm_N = mkN "棘皮动物" ; -- open-multilingual-wordnet
lin echinus_N = mkN "钟形圆饰" ; -- open-multilingual-wordnet
lin echo_N = mkN "呼应" "次" ;
lin echo_V = mkV "反射" ;
lin echo_V2 = mkV2 "呼应" ;
lin echocardiograph_N = mkN "心回波仪" | mkN "超声波心动仪" ; -- open-multilingual-wordnet
lin echoencephalograph_N = mkN "回波脑造影仪" | mkN "脑回波图仪" ; -- open-multilingual-wordnet
lin echoless_A = mkA "无回声" ; -- open-multilingual-wordnet
lin eclampsia_N = mkN "子痫惊厥" | mkN "惊厥" ; -- open-multilingual-wordnet
lin eclectic_A = mkA "折衷" ;
lin eclecticism_N = mkN "折衷主义" ; -- status=guess
lin eclipse_N = mkN "日食" | mkN "日蝕" | mkN "日蚀" | mkN "月食" | mkN "月蝕" | mkN "月蚀" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin eclipse_V2 = mkV2 "使变暗" ;
lin ecological_A = mkA "生态" ;
lin ecology_N = mkN "生態" | mkN "生态" | mkN "生態學" | mkN "生态学" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin econometric_A = mkA "计量经济学" ; -- open-multilingual-wordnet
lin econometrics_N = mkN "计量经济学" ; -- status=guess
lin economic_A = mkA "实用" | {-HSK-} mkA "经济" ;
lin economical_A = mkA "经济" ;
lin economics_N = mkN "经济学" [] ;
lin economist_N = mkN "经济学家" ;
lin economize_V = mkV "省" | mkV "节" | mkV "节约" ;
lin economize_V2 = mkV2 "省" | mkV2 "节" | mkV2 "节约" ;
lin economy_1_N = {-mwn-} mkN "经济" | mkN "经济体系" ; -- open-multilingual-wordnet
lin economy_2_N = variants {} ;
lin economy_N = mkN "经济" ;
lin ecosystem_N = mkN "生態系" | mkN "生态系" | mkN "生態系統" | mkN "生态系统" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin ecotourism_N = mkN "生態旅遊" | mkN "生态旅游" | mkN "生態觀光" | mkN "生态观光" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin ecstasy_N = mkN "搖頭丸" | mkN "摇头丸" ; -- status=guess -- status=guess
lin ecstatic_A = mkA "狂喜" ;
lin ectodermal_A = mkA "外胚层" ; -- open-multilingual-wordnet
lin ectoproct_N = mkN "外肛苔藓虫" ; -- open-multilingual-wordnet
lin ecuador_PN = mkPN "厄瓜多尔" ; -- comment=src=geonames status=guess
lin eczema_N = mkN "濕疹" | mkN "湿疹" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ed_PN = foreignPN "Ed" ; -- comment=src=geonames status=guess
lin eddie_PN = foreignPN "Eddie" ; -- comment=src=eng status=guess
lin eddy_PN = foreignPN "Eddy" ; -- comment=src=eng status=guess
lin eddy_V = mkV "使成漩涡" | mkV "打旋" | mkV "旋动" | mkV "旋转" | mkV "涡动" | mkV "漩涡" | mkV "起漩涡" ; -- open-multilingual-wordnet
lin edelweiss_N = mkN "雪絨花" | mkN "雪绒花" ; -- status=guess -- status=guess
lin edema_N = mkN "水腫" | mkN "水肿" | mkN "浮腫" | mkN "浮肿" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin eden_PN = foreignPN "Eden" ; -- comment=src=geonames status=guess
lin edenbridge_PN = foreignPN "Edenbridge" ; -- comment=src=geonames status=guess
lin edental_A = mkA "贫齿类" ; -- open-multilingual-wordnet
lin edentate_N = mkN "贫齿类动物" ; -- open-multilingual-wordnet
lin edentulous_A = mkA "缺齿" ; -- open-multilingual-wordnet
lin edgar_PN = foreignPN "Edgar" ; -- comment=src=geonames status=guess
lin edge_N = mkN "边缘" ;
lin edge_V = mkV "边缘" ;
lin edge_up_V = mkV "挤入" | mkV "挤进" ; -- open-multilingual-wordnet
lin edgeless_A = mkA "无棱" | mkA "无边" | mkA "无锋" | mkA "钝" ; -- open-multilingual-wordnet
lin edger_N = mkN "修边器" ; -- open-multilingual-wordnet
lin edging_N = mkN "边缘" ; -- open-multilingual-wordnet
lin edgy_A = mkA "锋利" ;
lin edible_A = mkA "可食用" ;
lin edifice_N = mkN "大厦" | mkN "大建筑物" | mkN "建筑" | mkN "建筑物" | mkN "房屋" | mkN "更常指大而气派的建筑" ; -- open-multilingual-wordnet
lin edinburgh_PN = mkPN "爱丁堡" ; -- comment=src=geonames status=guess
lin edit_V2 = mkV2 "编辑" ;
lin edith_PN = foreignPN "Edith" ; -- comment=src=eng status=guess
lin editing_N = mkN "編輯" | mkN "编辑" ; -- status=guess -- status=guess
lin edition_N = mkN "版" ;
lin editor_N = mkN "编辑" ;
lin editorial_A = mkA "社论" ;
lin editorial_N = mkN "社论" ;
lin edmund_PN = foreignPN "Edmund" ; -- comment=src=eng status=guess
lin educate_V2 = mkV2 "教育" ;
lin education_N = mkN "教育" ;
lin educational_A = mkA "教育" ;
lin educator_N = mkN "教育家" "位" ;
lin edward_PN = foreignPN "Edward" ; -- comment=src=eng status=guess
lin eel_N = mkN "鳗鱼" ;
lin eelblenny_N = mkN "北鳚" ; -- open-multilingual-wordnet
lin eellike_A = mkA "似鳗" ; -- open-multilingual-wordnet
lin eelworm_N = mkN "线虫类" | mkN "鳗蛔虫" ; -- open-multilingual-wordnet
lin eerie_A = mkA "可怕" ;
lin eeriness_N = mkN "怪诞" ;
lin eery_A = mkA "怪诞" ;
lin effect_N = mkN "作用" | mkN "效果" "個" | {-HSK-} mkN "效果" ;
lin effect_V2 = mkV2 "产生" ;
lin effective_A = mkA "有效" | {-HSK-} mkA "行" ;
lin effectiveness_N = mkN "效益" "个" ;
lin effects_N = mkN "动产" ; -- open-multilingual-wordnet
lin effectual_A = mkA "有力" | mkA "有效" | mkA "有效果" ; -- open-multilingual-wordnet
lin effeminate_A = mkA "柔弱" | mkA "娘娘腔" | mkA "女人氣" | mkA "女人气" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin effendi_N = mkN "阿凡提" ; -- status=guess
lin effete_A = mkA "疲惫" ;
lin efficacy_N = mkN "功效" | mkN "效力" ; -- status=guess -- status=guess
lin efficiency_N = mkN "效率" ;
lin efficient_A = mkA "高效" ;
lin effigy_N = mkN "假人" | mkN "雕像" | mkN "肖像" | {-mwn-} mkN "塑像" | mkN "画像" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin efflorescent_A = mkA "开花" ; -- open-multilingual-wordnet
lin effluent_N = mkN "廢水" | mkN "废水" | mkN "污水" | mkN "髒水" | mkN "脏水" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin effluvium_N = mkN "恶臭" | mkN "臭气" ; -- open-multilingual-wordnet
lin efflux_N = mkN "流出" | mkN "涌出" | mkN "益处" ; -- open-multilingual-wordnet
lin effort_N = mkN "功夫" | {-HSK-} mkN "工夫" ;
lin effortless_A = mkA "不费力" ;
lin effrontery_N = mkN "厚颜无耻" ;
lin effusive_A = mkA "热情洋溢" ;
lin eg_PN = foreignPN "Eg" ; -- comment=src=geonames status=guess
lin egad_Interj = mkInterj "哦天呐" ;
lin egalitarianism_N = mkN "平等主义" "" ;
lin egg_N = L.egg_N | {-HSK-} mkN "鸡蛋" "個" ;
lin eggar_N = mkN "枯叶蛾之类" ; -- open-multilingual-wordnet
lin egg_cup_N = mkN "蛋杯" ; -- open-multilingual-wordnet
lin eggnog_N = mkN "蛋酒" | mkN "蛋奶酒" | mkN "蛋諾類" | mkN "蛋诺类" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin eggplant_N = mkN "茄子" ; -- status=guess
lin eggshell_N = mkN "蛋殼" | mkN "蛋壳" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ego_N = mkN "自我" "" ;
lin egoism_N = mkN "自我主義" | mkN "自我主义" | mkN "利己主義" | mkN "利己主义" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin egoist_N = mkN "自我主義者" | mkN "自我主义者" | mkN "利己主義者" | mkN "利己主义者" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin egotist_N = mkN "自高自大者" ;
lin egotistic_A = mkA "自命不凡" | mkA "自我中心" | mkA "自我本位" | mkA "自负" | mkA "趾高气扬" ; -- open-multilingual-wordnet
lin egotrip_V = mkV "自私地行事" | mkV "追名逐利" ; -- open-multilingual-wordnet
lin egregious_A = mkA "过分" ;
lin egremont_PN = foreignPN "Egremont" ; -- comment=src=geonames status=guess
lin egret_N = mkN "白鷺" | mkN "白鹭" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin egypt_PN = mkPN "埃及" ; -- comment=src=geonames status=guess
lin egyptian_A = mkA "埃及" ;
lin eiche_PN = foreignPN "Eiche" ; -- comment=src=eng status=guess
lin eidetic_A = mkA "似在眼前" | mkA "历历在目" | mkA "异常清晰" | mkA "极为逼真" ; -- open-multilingual-wordnet
lin eightpence_N = mkN "八便士" ; -- open-multilingual-wordnet
lin eileen_PN = foreignPN "Eileen" ; -- comment=src=eng status=guess
lin eindhoven_PN = mkPN "埃因霍温" ; -- comment=src=geonames status=guess
lin einsteinium_N = mkN "锿" ; -- status=guess
lin either7or_DConj = S.either7or_DConj ;
lin either_Adv = mkAdv "或" ;
lin either_Det = mkpDet "或" ;
lin ejaculate_V2 = mkV2 (mkV "射精") ; -- status=guess, src=wikt
lin ejaculation_N = mkN "射精" | mkN "射出" ; -- status=guess -- status=guess
lin eject_V = mkV "排除" ; -- status=guess, src=wikt
lin eject_V2 = mkV2 "喷出" ;
lin ejector_N = mkN "退壳器" ; -- open-multilingual-wordnet
lin eke_V2 = mkV2 "补充" ;
lin el_salvador_PN = mkPN "萨尔瓦多" ; -- comment=src=geonames status=guess
lin elaborate_A = mkA "雕饰" ;
lin elaborate_V = mkV "阐述" ;
lin elaborate_V2 = mkV2 "精心制作" ;
lin elaine_PN = foreignPN "Elaine" ; -- comment=src=eng status=guess
lin eland_N = mkN "大羚羊" | mkN "大角斑羚" ; -- open-multilingual-wordnet
lin elapse_V = mkV "逝去" ;
lin elapsed_A = mkA "过去" ; -- open-multilingual-wordnet
lin elastic_A = mkA "彈性" | mkA "弹性" | mkA "有彈力" | mkA "有弹力" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin elastic_N = mkN "彈性極限" | mkN "弹性极限" | {-mwn-} mkN "弹性织品" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin elasticity_N = mkN "彈性" | mkN "弹性" ; -- status=guess -- status=guess
lin elastosis_N = mkN "弹性组织变性" ; -- open-multilingual-wordnet
lin elation_N = mkN "得意" ;
lin elbow_N = mkN "肘部" ;
lin elder_A = mkA "年長" | mkA "年长" | {-HSK-} mkA "长" | {-mwn-} mkA "老" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin elder_1_N = mkN "长" | {-HSK-} mkN "长老" ;
lin elder_2_N = mkN "长" | {-HSK-} mkN "长老" ;
lin elderly_A = mkA "老年" ;
lin elderslie_PN = foreignPN "Elderslie" ; -- comment=src=geonames status=guess
lin eldest_A = mkA "大" ;
lin eleanor_PN = foreignPN "Eleanor" ; -- comment=src=geonames status=guess
lin elect_V = mkV "举" | mkV "推" | mkV "选举" ;
lin elect_V2 = mkV2 "举" | mkV2 "推" | mkV2 "选举" ;
lin elect_V2V = mkV2V "举" | mkV2V "推" | mkV2V "选举" ;
lin elect_V3 = mkV3 "举" | mkV3 "推" | mkV3 "选举" ;
lin elected_A = variants {} ;
lin election_N = mkN "选举" | {-HSK-} mkN "选举" "次" ;
lin electioneering_N = mkN "競選活動" | mkN "竞选活动" ; -- status=guess -- status=guess
lin elective_A = mkA "选修" ;
lin elector_N = mkN "選舉人" | mkN "选举人" ; -- status=guess -- status=guess
lin electoral_A = mkA "选举" ;
lin electorate_N = mkN "选民" ;
lin electric_A = mkA "电动" ;
lin electric_N = mkN "電動車" | mkN "电动车" | {-mwn-} mkN "电车" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin electrical_A = mkA "电动" ;
lin electrician_N = mkN "电工" ;
lin electricity_N = mkN "电力" ;
lin electrification_N = mkN "電氣化" | mkN "电气化" | mkN "電化" | mkN "电化" | mkN "帶電" | mkN "带电" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin electrify_V2 = mkV2 "使+电气化" ;
lin electrocardiogram_N = mkN "心电图" ;
lin electrocardiograph_N = mkN "心动描记器" | mkN "心动电描记器" | mkN "心电描记器" ; -- open-multilingual-wordnet
lin electrocardiographic_A = mkA "心电图仪" ; -- open-multilingual-wordnet
lin electrochemical_A = mkA "电化学" | mkA "电气化学" ; -- open-multilingual-wordnet
lin electrocution_N = mkN "觸電" | mkN "触电" ; -- status=guess -- status=guess
lin electrode_N = mkN "电极" ;
lin electrodeposition_N = mkN "电极淀积" | mkN "电沉积" ; -- open-multilingual-wordnet
lin electrodynamometer_N = mkN "力测电流计" | mkN "电力测功计" | mkN "电功率计" | mkN "电测力计" ; -- open-multilingual-wordnet
lin electroencephalogram_N = mkN "脑电图" ; -- status=guess
lin electroencephalograph_N = mkN "电脑波测量图" | mkN "脑电图仪" | mkN "脑电描记器" ; -- open-multilingual-wordnet
lin electroencephalographic_A = mkA "脑电图仪" | mkA "脑电描记器" ; -- open-multilingual-wordnet
lin electrolysis_N = mkN "电解" ;
lin electrolyte_N = mkN "电解液" | mkN "电解质" ; -- open-multilingual-wordnet
lin electrolytic_N = mkN "电解质电容器" ; -- open-multilingual-wordnet
lin electromagnet_N = mkN "电磁铁" ;
lin electromagnetic_A = mkA "電磁" | mkA "电磁" | {-mwn-} mkA "电磁" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin electromagnetism_N = mkN "電磁學" | mkN "电磁学" | mkN "電磁" | mkN "电磁" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin electromechanical_A = mkA "机电" | mkA "电动机械" | mkA "电机" ; -- open-multilingual-wordnet
lin electrometer_N = mkN "电位计" | mkN "量电表" | mkN "静电计" ; -- open-multilingual-wordnet
lin electromyograph_N = mkN "肌电描记器" ; -- open-multilingual-wordnet
lin electron_N = mkN "电子" "个" ;
lin electronegativity_N = mkN "電負性" | mkN "电负性" ; -- status=guess -- status=guess
lin electronic_A = mkA "电子" ;
lin electronics_N = mkN "电子" ;
lin electrophoresis_N = mkN "电泳" | mkN "电泳分离法" | mkN "电解渗入法" ; -- open-multilingual-wordnet
lin electrophoretic_A = mkA "电泳" ; -- open-multilingual-wordnet
lin electroplate_N = mkN "电镀物品" ; -- open-multilingual-wordnet
lin electroscope_N = mkN "验电器" ; -- open-multilingual-wordnet
lin electrostatic_A = mkA "静电" | mkA "静电学" ; -- open-multilingual-wordnet
lin electrostatics_N = mkN "靜電學" | mkN "静电学" ; -- status=guess -- status=guess
lin electrum_N = mkN "琥珀金" | mkN "金银合金" | mkN "银金矿" ; -- open-multilingual-wordnet
lin eleemosynary_A = mkA "慈善" | {-mwn-} mkA "乐善好施" | mkA "博爱" | mkA "慈善" | mkA "行善" ; -- status=guess -- open-multilingual-wordnet
lin elegance_N = mkN "高雅" | mkN "優雅" | mkN "优雅" ; -- status=guess -- status=guess -- status=guess
lin elegant_A = mkA "优美" | {-HSK-} mkA "优雅" ;
lin elegy_N = mkN "挽歌" | mkN "哀歌" ; -- status=guess -- status=guess
lin element_N = mkN "元素" | {-HSK-} mkN "因素" "個" | mkN "成分" "個" | mkN "组成" ;
lin elemental_A = mkA "元素" | mkA "单一" | mkA "基本" | mkA "未化合" ; -- open-multilingual-wordnet
lin elementary_A = mkA "初级" | {-HSK-} mkA "基本" ;
lin elemi_N = mkN "榄香" | mkN "榄香脂" ; -- open-multilingual-wordnet
lin elephant_N = mkN "大象" "隻" | {-HSK-} mkN "象" "只" ;
lin elevate_V2 = mkV2 "提升" ;
lin elevation_N = mkN "海拔" [] ;
lin elevator_N = mkN "电梯" "臺" | {-HSK-} mkN "电梯" "部" ;
lin elf_N = mkN "精靈" | mkN "精灵" ; -- status=guess -- status=guess
lin elfish_A = mkA "如小精灵" | mkA "小妖精" | mkA "小精灵" | mkA "淘气" | mkA "调皮" | mkA "象小妖精" ; -- open-multilingual-wordnet
lin elgin_PN = mkPN "埃爾金" ; -- comment=src=geonames status=guess
lin eligible_A = mkA "合格" ;
lin eliminate_V2 = mkV2 "消除" | {-HSK-} mkV2 "除" ;
lin elimination_N = mkN "肃清" ;
lin elision_N = mkN "省略" ; -- status=guess
lin elite_N = mkN "精英" "个" ;
lin elitistFem_N = mkN "优秀人才" "位" ;
lin elitistMasc_N = mkN "优秀人才" "位" ;
lin elixir_N = mkN "万能药" "种" ;
lin eliza_PN = foreignPN "Eliza" ; -- comment=src=eng status=guess
lin elizabeth_PN = mkPN "伊麗莎白" ; -- comment=src=geonames status=guess
lin ell_N = mkN "厢房" ; -- open-multilingual-wordnet
lin elland_PN = foreignPN "Elland" ; -- comment=src=geonames status=guess
lin ellen_PN = foreignPN "Ellen" ; -- comment=src=eng status=guess
lin ellesmere_PN = foreignPN "Ellesmere" ; -- comment=src=geonames status=guess
lin ellesmere_port_PN = foreignPN "Ellesmere port" ; -- comment=src=eng status=guess
lin ellie_PN = foreignPN "Ellie" ; -- comment=src=eng status=guess
lin ellipse_N = mkN "橢圓" | mkN "椭圆" ; -- status=guess -- status=guess
lin ellipsis_N = mkN "……" | mkN "刪節號" | mkN "删节号" | mkN "省略號" | mkN "省略号" | {-mwn-} mkN "省略" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin ellipsoid_A = mkA "回转椭圆体" | mkA "椭圆体" ; -- open-multilingual-wordnet
lin ellipsoid_N = mkN "椭圆体" | mkN "椭球" | mkN "椭面" ; -- open-multilingual-wordnet
lin elliptical_A = mkA "椭圆" ;
lin elloughton_PN = foreignPN "Elloughton" ; -- comment=src=eng status=guess
lin elm_N = mkN "榆木" ; -- status=guess
lin elocutionistFem_N = variants {} ; ---- sense to be split
lin elocutionistMasc_N = variants {} ; ---- sense to be split
lin elongate_V2 = mkV2 "伸长" ;
lin elongation_N = mkN "伸长" | mkN "延长" ; -- open-multilingual-wordnet
lin elope_V = mkV "出走" | mkV "私奔" ; -- open-multilingual-wordnet
lin eloquence_N = mkN "口才" [] ;
lin eloquent_A = mkA "雄辩" ;
lin else_Adv = mkAdv "其他" | {-HSK-} mkAdv "否则" | mkAdv "还" ;
lin elsewhere_Adv = mkAdv "别处" ;
lin elsie_PN = foreignPN "Elsie" ; -- comment=src=eng status=guess
lin elstree_PN = foreignPN "Elstree" ; -- comment=src=geonames status=guess
lin eluate_N = mkN "洗出液" ; -- open-multilingual-wordnet
lin elude_V2 = mkV2 "逃避" ;
lin elusive_A = mkA "难懂" ;
lin elution_N = mkN "洗提" ; -- open-multilingual-wordnet
lin elvish_A = mkA "如小精灵" | mkA "小妖精" | mkA "小精灵" | mkA "淘气" | mkA "调皮" | mkA "象小妖精" ; -- open-multilingual-wordnet
lin ely_PN = mkPN "伊利" ; -- comment=src=geonames status=guess
lin elysian_A = mkA "乐土" | mkA "天堂似" | mkA "极乐世界" | mkA "象天堂" ; -- open-multilingual-wordnet
lin elysium_PN = foreignPN "Elysium" ; -- comment=src=eng status=guess
lin email_N = mkN "来自" | mkN "电子邮件" "封" ;
lin emancipate_V2 = mkV2 "解放" ;
lin emancipation_N = mkN "解放" ; -- status=guess
lin emancipative_A = mkA "旨在解放" | mkA "有助于解放" | mkA "解放" ; -- open-multilingual-wordnet
lin emarginate_A = mkA "顶端微凹" ; -- open-multilingual-wordnet
lin emasculate_V2 = mkV2 "阉割" ;
lin emasculation_N = mkN "去雄" "" ;
lin embankment_N = mkN "堤岸" | {-mwn-} mkN "土堤" | mkN "堤" | mkN "堤围" ; -- status=guess -- open-multilingual-wordnet
lin embargo_N = mkN "禁令" ;
lin embargo_V2 = mkV2 "禁运" ;
lin embark_V = mkV "上船" ;
lin embark_V2 = mkV2 "从事" ;
lin embarkation_N = mkN "登船" | mkN "乘船" | mkN "上船" ; -- status=guess -- status=guess -- status=guess
lin embarrass_V2 = mkV2 "捉弄" ;
lin embarrassed_A = {-mwn-} mkA "不好意思" | mkA "局促不安" | mkA "窘迫" | mkA "羞愧" ; -- open-multilingual-wordnet
lin embarrassing_A = mkA "尴尬" ;
lin embarrassment_N = mkN "困窘" ;
lin embassy_N = mkN "大使馆" | {-HSK-} mkN "大使馆" "座" ;
lin embattled_A = mkA "心烦意乱" ;
lin embed_V2 = mkV2 "嵌" ;
lin embellish_V2 = mkV2 "修" | {-HSK-} mkV2 "修饰" ;
lin ember_N = mkN "餘燼" | mkN "余烬" ; -- status=guess -- status=guess
lin embezzle_V2 = mkV2 "盗用" ;
lin embezzlement_N = mkN "挪用公款" "" ;
lin embitter_V2 = mkV2 "使+怨恨" ;
lin embitterment_N = mkN "愤懑" ; -- open-multilingual-wordnet
lin emblem_N = mkN "象征" ;
lin emblematic_A = mkA "象征" ;
lin embodiment_N = mkN "化身" ; -- status=guess
lin embody_V2 = mkV2 "体现" | mkV2 "包含" | {-HSK-} mkV2 "收录" ;
lin embolden_V2 = mkV2 "壮胆" ;
lin embolic_A = mkA "与栓塞有关" ; -- open-multilingual-wordnet
lin embolism_N = mkN "栓塞" ; -- status=guess -- open-multilingual-wordnet
lin embolus_N = mkN "栓塞" ; -- open-multilingual-wordnet
lin embrace_N = mkN "拥抱""个" ;
lin embrace_V = mkV "拥抱" ;
lin embrace_V2 = mkV2 "拥抱" ;
lin embrocation_N = mkN "搽剂" | mkN "擦剂" | mkN "涂抹剂" ; -- open-multilingual-wordnet
lin embroider_V = mkV "刺繡" | mkV "刺绣" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin embroider_V2 = mkV2 (mkV "刺繡") | mkV2 (mkV "刺绣") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin embroidery_N = mkN "刺绣" ;
lin embroil_V = mkV "卷入" ;
lin embroil_V2 = mkV2 "使+卷入" ;
lin embryo_N = mkN "胎" ;
lin embryology_N = mkN "胚胎學" | mkN "胚胎学" ; -- status=guess -- status=guess
lin embryonic_A = mkA "胚胎" ;
lin emerald_N = mkN "綠寶石" | mkN "绿宝石" ; -- status=guess -- status=guess
lin emerge_V = mkV "出现" ;
lin emergence_N = mkN "产生" | {-HSK-} mkN "出现" ;
lin emergency_N = mkN "突发事件" | {-HSK-} mkN "紧急" ;
lin emeritus_A = mkA "退休" ;
lin emery_N = mkN "刚玉粉" | mkN "金刚砂" ; -- open-multilingual-wordnet
lin emetic_N = mkN "催吐剂" | mkN "致吐剂" ; -- open-multilingual-wordnet
lin emigrant_N = mkN "移民" ;
lin emigrate_V = mkV "依据" ;
lin emigration_N = mkN "移民" ;
lin emily_PN = foreignPN "Emily" ; -- comment=src=eng status=guess
lin eminent_A = mkA "杰出" ;
lin emissary_N = mkN "派遣" ;
lin emission_N = mkN "发射" "次" ;
lin emit_V2 = mkV2 "发出" ;
lin emma_PN = foreignPN "Emma" ; -- comment=src=eng status=guess
lin emmenagogue_N = mkN "调经剂" | mkN "通经剂" | mkN "通经药" ; -- open-multilingual-wordnet
lin emmetropia_N = mkN "屈光正常" | mkN "正常眼" ; -- open-multilingual-wordnet
lin emoticon_N = mkN "表情符號" | mkN "表情符号" ; -- status=guess -- status=guess
lin emotion_N = mkN "情感" [] | {-HSK-} mkN "感情" "個" ;
lin emotional_A = mkA "情绪" ;
lin emotive_A = mkA "情感" | mkA "感情" ; -- open-multilingual-wordnet
lin empathic_A = mkA "感情移入" ; -- open-multilingual-wordnet
lin empathize_V = mkV "移情" ;
lin empathy_N = mkN "移情" | mkN "同感" ; -- status=guess -- status=guess
lin emperor_N = mkN "皇帝" | {-HSK-} mkN "皇帝" "個" ;
lin emphasis_N = mkN "重点" ;
lin emphasize_V2 = mkV2 "强调" ;
lin emphasize_VS = mkVS "强调" ;
lin emphatic_A = mkA "強調" | mkA "强调" ; -- status=guess -- status=guess
lin empire_N = mkN "帝国" ;
lin empirical_A = mkA "经验主义" ; -- comment="完全根据经验" ;
lin emplacement_N = mkN "安置" | mkN "定位" | mkN "指出位置" | mkN "放置" ; -- open-multilingual-wordnet
lin emplane_V = mkV "上飞机" | mkV "乘飞机" | mkV "搭乘飞机" ; -- open-multilingual-wordnet
lin employ_N = mkN "使用""" ;
lin employ_V2 = mkV2 "使" | mkV2 "使用" | mkV2 "用" | mkV2 "雇佣" | {-HSK-} mkV2 "采用" ;
lin employee_N = mkN "职员" ;
lin employer_N = mkN "雇主" ;
lin employment_N = mkN "雇用" ;
lin emporium_N = mkN "大百货店" | mkN "百货公司" | mkN "百货商场" | mkN "百货商店" ; -- open-multilingual-wordnet
lin empower_V2 = mkV2 "授权" ;
lin empower_V2V = mkV2V "授权" ;
lin empress_N = mkN "皇后" | {-HSK-} mkN "女皇" ; -- status=guess -- status=guess
lin emptiness_N = mkN "空虛" | mkN "空虚" | mkN "空洞" ; -- status=guess -- status=guess -- status=guess
lin empty_A = L.empty_A | {-HSK-} mkA "白" ;
lin empty_N = mkN "白" | {-HSK-} mkN "空巢" | {-mwn-} mkN "空容器" ; -- status=guess -- open-multilingual-wordnet
lin empty_V = mkV "空" ;
lin empty_V2 = mkV2 "留空" ;
lin emptying_N = mkN "倒空" | mkN "排空" | mkN "搬空" ; -- open-multilingual-wordnet
lin empurpled_A = mkA "华而不实" | mkA "辞藻华丽" | mkA "过分华丽" ; -- open-multilingual-wordnet
lin empyema_N = mkN "积脓" | mkN "积脓症" | mkN "脓胸" ; -- open-multilingual-wordnet
lin emsworth_PN = foreignPN "Emsworth" ; -- comment=src=geonames status=guess
lin emu_N = mkN "鴯鶓" | mkN "鸸鹋" | mkN "鴯" | mkN "鸸" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin emulate_V2 = mkV2 "模仿" | {-HSK-} mkV2 "赶超" ;
lin emulsifier_N = mkN "乳化器" ; -- open-multilingual-wordnet
lin emulsion_N = mkN "感光乳剂" ; -- open-multilingual-wordnet
lin enable_V2 = mkV2 "使" ;
lin enable_V2V = mkV2V "使" ;
lin enable_VS = mkVS "使" | {-HSK-} mkVS "使能够" ;
lin enact_V2 = mkV2 "制定" ;
lin enactment_N = mkN "制定" [] ;
lin enamel_N = mkN "琺瑯質" ; -- status=guess
lin enamelware_N = mkN "搪瓷器" | mkN "搪瓷器皿" | mkN "搪瓷炊具" ; -- open-multilingual-wordnet
lin enamine_N = mkN "烯胺" ; -- open-multilingual-wordnet
lin enantiomorph_N = mkN "对映体" | mkN "对映结构体" ; -- open-multilingual-wordnet
lin enantiomorphism_N = mkN "对映形态" ; -- open-multilingual-wordnet
lin enate_A = mkA "娘家" | mkA "母系" | mkA "母系亲戚" ; -- open-multilingual-wordnet
lin enc_PN = foreignPN "Enc" ; -- comment=src=eng status=guess
lin encamp_V = mkV "宿营" | mkV "扎营" | mkV "露营" ; -- open-multilingual-wordnet
lin encapsulation_N = mkN "包装" | mkN "包裹" | mkN "封装" ; -- open-multilingual-wordnet
lin encase_V2 = mkV2 "包住" | {-HSK-} mkV2 "套" ;
lin encaustic_N = mkN "蜡画" ; -- open-multilingual-wordnet
lin encephalitis_N = mkN "腦炎" | mkN "脑炎" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin encephalocele_N = mkN "脑突出" | mkN "脑膨出" ; -- open-multilingual-wordnet
lin encephalogram_N = mkN "气脑图" | mkN "气脑造影照片" | mkN "脑造影照片" ; -- open-multilingual-wordnet
lin encephalomyelitis_N = mkN "脑脊髓炎" ; -- open-multilingual-wordnet
lin enchant_V2 = mkV2 (mkV "迷惑") ; -- status=guess, src=wikt
lin enchanter_N = mkN "魔法師" | mkN "魔法师" ; -- status=guess -- status=guess
lin enchantment_N = mkN "魅力" ; -- status=guess
lin enchantress_N = mkN "女妖" | mkN "女巫" | mkN "妖精" | {-mwn-} mkN "巫婆" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin enchondroma_N = mkN "内生软骨瘤" ; -- open-multilingual-wordnet
lin encircle_V2 = mkV2 "包围" ;
lin encirclement_N = mkN "包圍" | mkN "包围" ; -- status=guess -- status=guess
lin enclose_V2 = mkV2 "装入" ;
lin enclosure_1_N = mkN "圍場" | mkN "围场" ; -- status=guess -- status=guess
lin enclosure_2_N = mkN "圍場" | mkN "围场" ; -- status=guess -- status=guess
lin enclosure_3_N = mkN "圍場" | mkN "围场" ; -- status=guess -- status=guess
lin encoding_N = mkN "編碼" | mkN "编码" ; -- status=guess -- status=guess
lin encomium_N = mkN "赞美" ; -- status=guess
lin encompass_V2 = mkV2 "包围" | {-HSK-} mkV2 "周围" ;
lin encompassment_N = mkN "包含" ; -- open-multilingual-wordnet
lin encopresis_N = mkN "大便失禁" ; -- open-multilingual-wordnet
lin encore_N = mkN "重言" ;
lin encounter_N = mkN "遇到" ;
lin encounter_V2 = mkV2 "遭遇" ;
lin encourage_V2 = mkV2 "鼓励" ;
lin encourage_V2V = mkV2V "鼓励" ;
lin encouragement_N = mkN "鼓励" ;
lin encouraging_A = mkA "鼓舞" ;
lin encroach_V = mkV "侵占" ;
lin encroachment_N = mkN "侵略" ;
lin encrust_V2 = mkV2 "形成外皮" ;
lin encrypt_V2 = mkV2 "加密" ;
lin encumber_V2 = mkV2 "设置产权负担" ;
lin encyclopedia_N = mkN "百科全書" | mkN "百科全书" ; -- status=guess -- status=guess
lin encyclopedic_A = mkA "百科全书式" ;
lin encysted_A = mkA "被囊" ; -- open-multilingual-wordnet
lin end_1_N = mkN "终结" ;
lin end_2_N = mkN "终结" ;
lin end_N = mkN "终结" ;
lin end_V = mkV "结束" ;
lin end_V2 = mkV2 "结束" ;
lin end_VS = mkVS "结束" ;
lin end_in_V2 = prepV2 OP_end_V OP_in_Prep ; -- guess-p-verb
lin end_tail_V2 = mkV2 "结束" ;
lin end_up_V2 = prepV2 OP_end_V OP_up_Prep ; -- guess-p-verb
lin end_up_with_V2 = prepV2 (advV OP_end_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin endanger_V2 = mkV2 "危害" ;
lin endarteritis_N = mkN "动脉内膜炎" ; -- open-multilingual-wordnet
lin endeavour_N = mkN "努力" ; -- status=guess
lin endeavour_V = mkV "努力" ; -- status=guess, src=wikt
lin endermic_A = mkA "涂在皮肤上" ; -- open-multilingual-wordnet
lin endgame_N = mkN "殘局" | mkN "残局" | mkN "殘棋" | mkN "残棋" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin ending_N = mkN "终点" ;
lin endive_N = mkN "苦苣" ; -- status=guess
lin endless_A = mkA "无穷" ;
lin endocarditis_N = mkN "心内膜炎" ; -- open-multilingual-wordnet
lin endocervicitis_N = mkN "子宫颈内膜炎" ; -- open-multilingual-wordnet
lin endodontic_A = mkA "牙髓学" ; -- open-multilingual-wordnet
lin endogamy_N = mkN "同部族婚姻" ; -- open-multilingual-wordnet
lin endometrial_A = mkA "子宫内膜" ; -- open-multilingual-wordnet
lin endonuclease_N = mkN "内切核酸酶" | mkN "核酸内切酶" ; -- open-multilingual-wordnet
lin endorphin_N = mkN "腦內啡" | mkN "脑内啡" | mkN "安多芬" | mkN "內啡呔" | mkN "内啡呔" | {-mwn-} mkN "内啡肽" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin endorse_V2 = mkV2 "拥护" ;
lin endorsement_N = mkN "背书" [] ;
lin endoscopic_A = mkA "内诊镜" ; -- open-multilingual-wordnet
lin endothelial_A = mkA "内皮" ; -- open-multilingual-wordnet
lin endow_V2 = mkV2 "赋予" ;
lin endowment_N = mkN "才" | {-HSK-} mkN "捐赠" "" ;
lin endurable_A = mkA "可忍受" | mkA "可忍耐" | mkA "能忍耐" ; -- open-multilingual-wordnet
lin endure_V = mkV "克服" | {-HSK-} mkV "忍受" ;
lin endure_V2 = mkV2 "克服" | {-HSK-} mkV2 "忍受" | {-HSK-} mkV2 "挨" ;
lin enduring_A = variants {} ;
lin enema_N = mkN "灌腸劑" | mkN "灌肠剂" | mkN "灌腸" | mkN "灌肠" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin enemy_N = L.enemy_N | {-HSK-} mkN "敌人" "個" ;
lin energetic_A = mkA "积极" | {-HSK-} mkA "精力充沛" ;
lin energizer_N = mkN "供能装置" ; -- open-multilingual-wordnet
lin energy_N = mkN "精力" | mkN "能源" "個" | {-HSK-} mkN "能源" ;
lin enfield_PN = foreignPN "Enfield" ; -- comment=src=geonames status=guess
lin enforce_V2 = mkV2 "执行" ;
lin enforcement_N = mkN "强制" ;
lin engage_V = mkV "从事" ;
lin engage_V2 = mkV2 "从事" ;
lin engagement_N = mkN "约会" "次" | {-HSK-} mkN "订婚" ;
lin engender_V2 = mkV2 "产生" ;
lin engine_N = mkN "引擎" ;
lin engineer_N = mkN "工程师" | {-HSK-} mkN "工程师" "個" ;
lin engineer_V = mkV "设计" ;
lin engineer_V2 = mkV2 "工程师" ;
lin engineering_N = mkN "工程" ;
lin enginery_N = mkN "机器" ; -- open-multilingual-wordnet
lin england_PN = foreignPN "England" ; -- comment=src=geonames status=guess
lin englishFem_N = mkN "英文" ;
lin englishMasc_N = mkN "英文" ;
lin english_A = mkA "英国" ;
lin engrave_V2 = mkV2 "刻" | {-HSK-} mkV2 "铭记" ;
lin engraving_N = mkN "雕刻" | mkN "鐫刻" | mkN "镌刻" ; -- status=guess -- status=guess -- status=guess
lin engross_V2 = mkV2 (mkV "全神贯注") ; -- status=guess, src=wikt
lin engulf_V2 = mkV2 "吞噬" ;
lin enhance_V2 = mkV2 "提高" ;
lin enhanced_A = variants {} ;
lin enhancement_N = mkN "增强" ;
lin enigma_N = mkN "谜" ;
lin enjoin_V2 = mkV2 "命令" ;
lin enjoy_V2 = mkV2 "享受" | {-HSK-} mkV2 "欣赏" ;
lin enjoy_VV = mkVV "享受" | {-HSK-} mkVV "欣赏" ;
lin enjoyable_A = mkA "愉快" ;
lin enjoyment_N = mkN "享受" ;
lin enkephalin_N = mkN "脑啡肽" ; -- open-multilingual-wordnet
lin enlarge_V = mkV "扩大" | {-HSK-} mkV "放大" ;
lin enlarge_V2 = mkV2 "扩大" ;
lin enlighten_V2 = mkV2 "启发" ; -- comment="启蒙" ;
lin enlightenment_N = mkN "启迪" ;
lin enlist_V = mkV "报名" ;
lin enlist_V2 = mkV2 "使+入伍" | {-HSK-} mkV2 "报名" ;
lin enliven_V2 = mkV2 "活跃" ;
lin ennui_N = mkN "厌倦" ;
lin ennumerate_V2 = mkV2 "列举" ;
lin enoch_PN = foreignPN "Enoch" ; -- comment=src=geonames status=guess
lin enol_N = mkN "烯醇" ; -- status=guess -- open-multilingual-wordnet
lin enolic_A = mkA "烯醇" ; -- open-multilingual-wordnet
lin enormous_A = mkA "巨大" ;
lin enough_A = mkA "足够" ;
lin enough_N = mkN "足够" [] ;
lin enough_Predet = variants {} ;
lin enplane_V = mkV "上飞机" | mkV "乘飞机" | mkV "搭乘飞机" ; -- open-multilingual-wordnet
lin enquire_V = mkV "查询" ;
lin enquire_V2 = mkV2 "查询" ;
lin enquiry_N = mkN "查询" "次" ;
lin enrage_V2 = mkV2 "激怒" ;
lin enrich_V2 = mkV2 "丰富" ;
lin enroll_V = mkV "录取" | mkV "报名" | mkV "注册" ;
lin enroll_V2 = mkV2 "录取" | mkV2 "报名" | mkV2 "注册" | {-HSK-} mkV2 (mkV "註冊") | mkV2 (mkV "注册") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin enrolment_N = mkN "註冊" | mkN "注册" | {-mwn-} mkN "入学" | mkN "招收" | mkN "登记" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin enschede_PN = mkPN "恩斯赫德" ; -- comment=src=geonames status=guess
lin ensconce_V2 = mkV2 "安置" ;
lin ensemble_N = mkN "全体" [] ;
lin ensiform_A = mkA "剑形" | mkA "剑形状" ; -- open-multilingual-wordnet
lin ensign_N = mkN "少尉" ; -- status=guess
lin ensue_V = mkV "接着" | {-HSK-} mkV "跟着发生" ;
lin ensure_V = mkV "保证" | {-HSK-} mkV "确定" ;
lin ensure_V2 = mkV2 "保证" | mkV2 "确定" | {-HSK-} mkV2 "确保" ;
lin ensure_VS = mkVS "保证" | mkVS "确定" | {-HSK-} mkVS "确保" ;
lin entablature_N = mkN "柱上楣构" | mkN "柱顶盘" | mkN "柱顶部" ; -- open-multilingual-wordnet
lin entail_V2 = mkV2 "使需要" ; -- comment="必需" ;
lin entangle_V2 = mkV2 "纠缠" ;
lin entasis_N = mkN "圆柱收分曲线" | mkN "圆柱收分线" | mkN "柱上的微凸线" ; -- open-multilingual-wordnet
lin enter_V = mkV "输" | mkV "进" | {-HSK-} mkV "进入" ;
lin enter_V2 = mkV2 "输" | mkV2 "进" | {-HSK-} mkV2 "进入" ;
lin enter_for_V2 = prepV2 OP_enter_V OP_for_Prep ; -- guess-p-verb
lin enter_into_V2 = prepV2 OP_enter_V OP_into_Prep ; -- guess-p-verb
lin enteric_A = mkA "肠" | mkA "肠内" ; -- open-multilingual-wordnet
lin enteritis_N = mkN "小湯炎" | mkN "小汤炎" | {-mwn-} mkN "小肠炎" | mkN "肠炎" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin enterobiasis_N = mkN "蛲虫病" ; -- open-multilingual-wordnet
lin enterokinase_N = mkN "肠激酶" ; -- open-multilingual-wordnet
lin enterolithiasis_N = mkN "肠石病" ; -- open-multilingual-wordnet
lin enteropathy_N = mkN "肠下垂" | mkN "肠病" ; -- open-multilingual-wordnet
lin enteroptosis_N = mkN "内脏下垂" | mkN "肠下垂" ; -- open-multilingual-wordnet
lin enterostenosis_N = mkN "肠狭窄" ; -- open-multilingual-wordnet
lin enterotoxemia_N = mkN "肠原性毒血症" ; -- open-multilingual-wordnet
lin enterotoxin_N = mkN "肠毒素" ; -- open-multilingual-wordnet
lin enterprise_N = mkN "企业" | {-HSK-} mkN "企业" "家" ;
lin enterprising_A = mkA "有事业心" ;
lin entertain_V2 = mkV2 "娱乐" | mkV2 "招待" ;
lin entertainer_N = mkN "演艺人员" "位" ;
lin entertaining_A = mkA "娱乐" ;
lin entertainment_N = mkN "娱乐" ;
lin enthusiasm_N = mkN "热心" | {-HSK-} mkN "热情" [] ;
lin enthusiast_N = mkN "爱好者" ;
lin enthusiastic_A = mkA "热心" | {-HSK-} mkA "热情 " ;
lin entice_V2 = mkV2 "诱惑" ;
lin entire_A = mkA "一" | mkA "全部" | mkA "完" | mkA "整个" ;
lin entirety_N = mkN "全部" ;
lin entitle_V2V = mkV2V "赋予" ;
lin entitle_VS = mkVS "称为" ;
lin entitlement_N = mkN "权利" ;
lin entity_N = mkN "实体" ;
lin entomb_V2 = mkV2 "埋葬" ;
lin entomological_A = mkA "昆虫学" ; -- open-multilingual-wordnet
lin entomologist_N = mkN "昆蟲學家" | mkN "昆虫学家" ; -- status=guess -- status=guess
lin entomology_N = mkN "昆蟲學" | mkN "昆虫学" ; -- status=guess -- status=guess
lin entomophobia_N = mkN "昆虫恐怖" ; -- open-multilingual-wordnet
lin entoproct_N = mkN "内肛动物" ; -- open-multilingual-wordnet
lin entourage_N = mkN "随行人员" ;
lin entrain_V = mkV "乘火车" ; -- open-multilingual-wordnet
lin entrance_N = mkN "入口" ;
lin entrance_V2 = mkV2 "使+出神" ;
lin entrant_N = mkN "进入者" ;
lin entrench_V2 = mkV2 "侵犯" ;
lin entrenchment_N = mkN "壕沟" "条" ;
lin entrepreneur_N = mkN "企业家" ;
lin entrepreneurial_A = mkA "企业家" ; -- comment="创业者" ;
lin entropy_N = mkN "熵" ; -- status=guess
lin entrust_V2 = mkV2 "委托" | {-HSK-} mkV2 "寄" ;
lin entry_1_N = variants {} ;
lin entry_2_N = variants {} ;
lin entry_N = mkN "入口" ;
lin entwine_V2 = mkV2 "缠住" ;
lin enumerate_V2 = mkV2 "举" ;
lin enunciation_N = mkN "吐字" ; -- status=guess
lin enured_A = mkA "使变硬" ; -- open-multilingual-wordnet
lin envelope_N = mkN "信封" | {-HSK-} mkN "信封" "個" ;
lin enviable_A = mkA "可羡慕" ;
lin envious_A = mkA "羡慕" | {-mwn-} mkA "妄羡" | mkA "妒忌" | mkA "嫉妒" ; -- open-multilingual-wordnet
lin environment_N = mkN "周围" | mkN "环境" "個" | {-HSK-} mkN "环境" ;
lin environmental_A = mkA "环境" ;
lin environmentalism_N = mkN "環境保護主義" | mkN "环境保护主义" ; -- status=guess -- status=guess
lin environmentalist_N = mkN "環保人士" | mkN "环保人士" | mkN "環境論者" | mkN "环境论者" | mkN "環境保護論者" | mkN "环境保护论者" | mkN "環境保護主義者" | mkN "环境保护主义者" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin envisage_V2 = mkV2 "设想" ;
lin envision_V2 = mkV2 "设想" ;
lin envision_VS = mkVS "想象" ;
lin envisioned_A = mkA "想象" ; -- open-multilingual-wordnet
lin envoy_N = mkN "使" | {-HSK-} mkN "使者" ;
lin envy_N = mkN "羡慕" | {-HSK-} mkN "羡慕" [] ;
lin envy_V2 = mkV2 "羡慕" ;
lin enzymatic_A = mkA "酶" ; -- open-multilingual-wordnet
lin enzyme_N = mkN "酶" "毫升" ;
lin eolith_N = mkN "原始石器" | mkN "原石器" | mkN "始石器" ; -- open-multilingual-wordnet
lin eolithic_A = mkA "原始石器时代" ; -- open-multilingual-wordnet
lin eon_N = mkN "永世" "" ;
lin eonian_A = mkA "永久" | mkA "永远" ; -- open-multilingual-wordnet
lin eosin_N = mkN "曙红类染料" | mkN "鲜红色的染料" ; -- open-multilingual-wordnet
lin eosinopenia_N = mkN "嗜酸细胞减少" ; -- open-multilingual-wordnet
lin eosinophilia_N = mkN "嗜酸细胞增多" ; -- open-multilingual-wordnet
lin eosinophilic_A = mkA "嗜曙红细胞" ; -- open-multilingual-wordnet
lin eparchial_A = mkA "主教管区" ; -- open-multilingual-wordnet
lin epaulet_N = mkN "肩章" ; -- status=guess -- open-multilingual-wordnet
lin epaulette_N = mkN "肩章" ; -- open-multilingual-wordnet
lin epauliere_N = mkN "肩甲" ; -- open-multilingual-wordnet
lin epee_N = mkN "重劍" | mkN "重剑" ; -- status=guess -- status=guess
lin epenthetic_A = mkA "寄生" | mkA "寄生虫" | mkA "由寄生虫引起" ; -- open-multilingual-wordnet
lin ephah_N = mkN "伊法" ; -- open-multilingual-wordnet
lin ephedrine_N = mkN "麻黃素" | mkN "麻黄素" | mkN "麻黃鹼" | mkN "麻黄碱" | {-mwn-} mkN "麻黄硷" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin ephemera_N = mkN "朝生暮死者" | mkN "生命极短促之物" ; -- open-multilingual-wordnet
lin ephemerid_N = mkN "蜉蝣" ; -- open-multilingual-wordnet
lin ephemeron_N = mkN "短命的东西" | mkN "短命的事物" | mkN "蜉蝣" ; -- open-multilingual-wordnet
lin epic_N = mkN "史诗" ;
lin epicarpal_A = mkA "外果皮" ; -- open-multilingual-wordnet
lin epicentre_N = mkN "震央" | mkN "震中" | mkN "震中心" ; -- status=guess -- status=guess -- status=guess
lin epicondylitis_N = mkN "上髁炎" ; -- open-multilingual-wordnet
lin epicycle_N = mkN "本轮" ; -- open-multilingual-wordnet
lin epicyclic_A = mkA "周转圆" | mkA "本轮" ; -- open-multilingual-wordnet
lin epicycloid_N = mkN "外摆线" ; -- open-multilingual-wordnet
lin epidemic_N = mkN "疫情" ;
lin epidemiologic_A = mkA "流行病学" ; -- open-multilingual-wordnet
lin epidemiologist_N = mkN "流行病学" ;
lin epidemiology_N = mkN "流行病學" | mkN "流行病学" ; -- status=guess -- status=guess
lin epidermis_N = mkN "表皮" ; -- status=guess
lin epidiascope_N = mkN "反射幻灯机" | mkN "幻灯机" ; -- open-multilingual-wordnet
lin epididymis_N = mkN "附睾" ; -- status=guess
lin epididymitis_N = mkN "附睾炎" ; -- open-multilingual-wordnet
lin epigenesis_N = mkN "外力变质" ; -- open-multilingual-wordnet
lin epiglottis_N = mkN "會厭" | mkN "会厌" ; -- status=guess -- status=guess
lin epiglottitis_N = mkN "會厭炎" | mkN "会厌炎" | {-mwn-} mkN "会厌" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin epigrammatic_A = mkA "格言" | mkA "警句" | mkA "金玉良言" ; -- open-multilingual-wordnet
lin epigraph_N = mkN "題詞" | mkN "题词" | mkN "碑文" ; -- status=guess -- status=guess -- status=guess
lin epigraphy_N = mkN "金石學" | mkN "金石学" ; -- status=guess -- status=guess
lin epilation_N = mkN "脱毛" | mkN "脫髮" | mkN "脱发" ; -- status=guess -- status=guess -- status=guess
lin epilepsy_N = mkN "癫痫" ; -- comment="癫痫症" ;
lin epilepticFem_N = mkN "癫痫患者" ;
lin epilepticMasc_N = mkN "癫痫患者" ;
lin epileptic_A = mkA "与癫痫有关" | mkA "像癫痫那样" | mkA "犹如癫痫发作" ; -- open-multilingual-wordnet
lin epilithic_A = mkA "长在石头上" ; -- open-multilingual-wordnet
lin epinephrine_N = mkN "腎上腺素" | mkN "肾上腺素" ; -- status=guess -- status=guess
lin epiphany_N = mkN "頓悟" | mkN "顿悟" | mkN "洞察" | mkN "領悟" | mkN "领悟" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin epiphany_PN = foreignPN "Epiphany" ; -- comment=src=eng status=guess
lin epiphyseal_A = mkA "骨骺" ; -- open-multilingual-wordnet
lin epiphytic_A = mkA "体表寄生植物" | mkA "附生植物" ; -- open-multilingual-wordnet
lin episcia_N = mkN "喜荫花" | mkN "红桐草" ; -- open-multilingual-wordnet
lin episcleritis_N = mkN "巩膜表层炎" ; -- open-multilingual-wordnet
lin episcopal_A = mkA "主教" | mkA "属于主教" ; -- open-multilingual-wordnet
lin episode_N = mkN "插曲" ;
lin episodic_A = mkA "插话" ;
lin epispadias_N = mkN "尿道上裂" ; -- open-multilingual-wordnet
lin epistemic_A = mkA "认识论" ; -- open-multilingual-wordnet
lin epitaph_N = mkN "墓誌銘" | mkN "墓志铭" | mkN "碑文" ; -- status=guess -- status=guess -- status=guess
lin epitaxy_N = mkN "外延附生" ; -- open-multilingual-wordnet
lin epithelial_A = mkA "上皮细胞" ; -- open-multilingual-wordnet
lin epitheliod_A = mkA "类似上皮细胞" ; -- open-multilingual-wordnet
lin epithelioma_N = mkN "上皮瘤" ; -- open-multilingual-wordnet
lin epithelium_N = mkN "上皮" ; -- status=guess
lin epithet_N = mkN "稱號" | mkN "称号" | mkN "綽號" | mkN "绰号" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin epitome_N = mkN "縮影" | mkN "缩影" ; -- status=guess -- status=guess
lin epitomize_V2 = mkV2 "摘要" ;
lin epizoan_A = mkA "附生动物" ; -- open-multilingual-wordnet
lin epoch_N = mkN "时代" "個" | {-HSK-} mkN "時代" | mkN "时代" | {-mwn-} mkN "时期" | mkN "纪元" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin epochal_A = mkA "划时代" | mkA "开新纪元" | mkA "新纪元" ; -- open-multilingual-wordnet
lin eponym_N = mkN "名祖" ; -- status=guess
lin eponymous_A = mkA "齐名" ; -- open-multilingual-wordnet
lin epping_PN = mkPN "埃潘" ; -- comment=src=geonames status=guess
lin epsilon_N = mkN "伊普西隆" | mkN "艾撲西龍" | mkN "艾扑西龙" ; -- status=guess -- status=guess -- status=guess
lin epsom_PN = mkPN "埃普索姆" ; -- comment=src=geonames status=guess
lin equal_A = mkA "平" | mkA "平等" | mkA "当" | {-HSK-} mkA "等于" ;
lin equal_N = mkN "对手" | {-HSK-} mkN "平" | mkN "平等" | mkN "当" ;
lin equal_V2 = mkV2 "等于" ;
lin equality_N = mkN "平等" ;
lin equalize_V2 = mkV2 (mkV "均等化") | mkV2 (mkV "等化") | mkV2 (mkV "平等化") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin equate_V2 = mkV2 "等同" ;
lin equation_N = mkN "方程" ;
lin equator_N = mkN "赤道" ; -- status=guess
lin equerry_N = mkN "大司马" ; -- status=guess
lin equestrian_N = mkN "骑手" ;
lin equiangular_A = mkA "各角相等" | mkA "等角" ; -- open-multilingual-wordnet
lin equilateral_N = mkN "等边三角形" ; -- status=guess
lin equilibrium_N = mkN "均衡" [] | {-HSK-} mkN "平衡" ;
lin equine_A = mkA "马科" ; -- open-multilingual-wordnet
lin equine_N = mkN "马科动物" ; -- open-multilingual-wordnet
lin equinoctial_A = mkA "春分或秋分" ; -- open-multilingual-wordnet
lin equinox_N = mkN "晝夜平分點" | mkN "昼夜平分点" | mkN "二分點" | mkN "二分点" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin equip_V2 = mkV2 "装备" ;
lin equipment_N = mkN "装备" | {-HSK-} mkN "设备" "個" ;
lin equipoise_N = mkN "均衡" | mkN "平衡" ; -- open-multilingual-wordnet
lin equipoised_A = mkA "均衡" | mkA "平衡" ; -- open-multilingual-wordnet
lin equitable_A = mkA "公平" ;
lin equity_N = mkN "公平" ;
lin equivalent_A = mkA "等价" ;
lin equivalent_N = mkN "当量" ;
lin equivocal_A = mkA "意义不明确" | mkA "模棱两可" ; -- open-multilingual-wordnet
lin er_Interj = mkInterj "呃" ;
lin era_N = mkN "年代" "個" | mkN "时代" "個" | {-HSK-} mkN "时代" ;
lin eradicate_V2 = mkV2 "吃" | {-HSK-} mkV2 "根除" ;
lin erase_V2 = mkV2 "抹去" | {-HSK-} mkV2 "擦" ;
lin eraser_N = mkN "橡皮" | mkN "橡皮擦子" | mkN "橡皮擦" ; -- status=guess -- status=guess -- status=guess
lin erasure_N = mkN "擦除" ;
lin erbium_N = mkN "鉺" ; -- status=guess
lin erect_A = mkA "安装" ;
lin erect_V2 = mkV2 "安装" | {-HSK-} mkV2 "支" ;
lin erection_N = mkN "勃起" ; -- status=guess
lin erfurt_PN = mkPN "埃尔福特" ; -- comment=src=geonames status=guess
lin erg_N = mkN "尔格" ; -- open-multilingual-wordnet
lin ergonomic_A = mkA "人体工程学" | mkA "人类工程学" | mkA "人类环境改造学" | mkA "工效学" ; -- open-multilingual-wordnet
lin ergonomics_N = mkN "人體工程學" | mkN "人体工程学" ; -- status=guess -- status=guess
lin ergosterol_N = mkN "麦角固醇" ; -- open-multilingual-wordnet
lin ergot_N = mkN "麦角症" ; -- open-multilingual-wordnet
lin ergotamine_N = mkN "麦角胺" ; -- open-multilingual-wordnet
lin ergotic_A = mkA "麦角病" | mkA "麦角症" ; -- open-multilingual-wordnet
lin ergotism_N = mkN "麦角中毒" ; -- open-multilingual-wordnet
lin ergotropic_A = mkA "增进抵抗力" ; -- open-multilingual-wordnet
lin eric_PN = foreignPN "Eric" ; -- comment=src=eng status=guess
lin erica_PN = foreignPN "Erica" ; -- comment=src=eng status=guess
lin erin_PN = foreignPN "Erin" ; -- comment=src=geonames status=guess
lin eriogonum_N = mkN "绒毛属植物" ; -- open-multilingual-wordnet
lin eritrea_PN = mkPN "厄立特里亚" ; -- comment=src=geonames status=guess
lin eritrean_A = mkA "厄立特里亚" ;
lin erlangen_PN = mkPN "埃尔朗根" ; -- comment=src=geonames status=guess
lin ermine_N = mkN "白鼬" ; -- status=guess
lin ernest_PN = foreignPN "Ernest" ; -- comment=src=eng status=guess
lin ernie_PN = foreignPN "Ernie" ; -- comment=src=eng status=guess
lin erode_V = mkV "侵蚀" ;
lin erode_V2 = mkV2 "侵蚀" ;
lin erogenous_A = mkA "动情" | mkA "动欲" | mkA "唤起情欲" ; -- open-multilingual-wordnet
lin erosion_N = mkN "侵蚀" ; -- comment="腐蚀" ;
lin erotic_A = mkA "色情" | mkA "引起性欲" | mkA "性愛" | mkA "性爱" | {-mwn-} mkA "令人性兴奋" | mkA "引起性欲" | mkA "性爱" | mkA "色情" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin eroticism_N = mkN "好色" | mkN "性的兴奋" ; -- open-multilingual-wordnet
lin err_V = mkV "犯错" ;
lin errand_N = mkN "差事" ;
lin errant_A = mkA "迷失" ; -- status=guess
lin erratic_A = mkA "不稳定" ;
lin erratum_N = mkN "勘误表" ;
lin erroneous_A = mkA "错误" ;
lin error_N = mkN "错" "個" | mkN "错误" "個" | {-HSK-} mkN "错误" ;
lin ersatz_N = mkN "代用品" ; -- status=guess
lin erudite_A = mkA "博学" ;
lin erudition_N = mkN "博學" | mkN "博学" | mkN "學識" | mkN "学识" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin erupt_V = mkV "爆发" ;
lin eruption_N = mkN "火山喷发" ;
lin eryngo_N = mkN "甜海冬根" ; -- open-multilingual-wordnet
lin erysipelas_N = mkN "丹毒" ; -- open-multilingual-wordnet
lin erythema_N = mkN "红斑" ; -- open-multilingual-wordnet
lin erythematous_A = mkA "红斑" | mkA "红斑状" ; -- open-multilingual-wordnet
lin erythroblastosis_N = mkN "成红细胞增多" ; -- open-multilingual-wordnet
lin erythroderma_N = mkN "红皮病" ; -- open-multilingual-wordnet
lin erythroid_A = mkA "红血球" ; -- open-multilingual-wordnet
lin erythropoiesis_N = mkN "红细胞生成" ; -- open-multilingual-wordnet
lin erythropoietic_A = mkA "红细胞生成" ; -- open-multilingual-wordnet
lin erythropoietin_N = mkN "红细胞生成素" ; -- open-multilingual-wordnet
lin escalate_V = mkV "逐步上升" ;
lin escalate_V2 = mkV2 "升级" ;
lin escalation_N = mkN "上升" "" ;
lin escalator_N = mkN "自动扶梯" ;
lin escapade_N = mkN "欢乐" ; -- open-multilingual-wordnet
lin escape_N = mkN "逃避" ;
lin escape_V = mkV "脱" | mkV "逃" | mkV "逃避" | {-HSK-} mkV "逃生" ;
lin escape_V2 = mkV2 "脱" | mkV2 "逃" | mkV2 "逃避" | {-HSK-} mkV2 "逃生" ;
lin escape_VS = mkVS "脱" | mkVS "逃" | mkVS "逃避" ; -- comment="避免" ;
lin escapement_N = mkN "摆轮" | mkN "擒纵轮" | mkN "棘轮装置" ; -- open-multilingual-wordnet
lin escarpment_N = mkN "壕沟内壁" | mkN "悬崖" ; -- open-multilingual-wordnet
lin eschatological_A = mkA "有关世界末日" | mkA "末世学" | mkA "末世论" | mkA "终局论" ; -- open-multilingual-wordnet
lin eschew_V2 = mkV2 "避开" ;
lin escort_N = mkN "护送者" | mkN "伴侣" ;
lin escort_V2 = mkV2 "陪同" ;
lin escutcheon_N = mkN "盾状物" | mkN "锁眼盖" | mkN "附有纹章的盾" ; -- open-multilingual-wordnet
lin esfahan_PN = foreignPN "Esfahan" ; -- comment=src=eng status=guess
lin esophageal_A = mkA "食管" | mkA "食道" ; -- open-multilingual-wordnet
lin esophagitis_N = mkN "食管炎" ; -- open-multilingual-wordnet
lin esophagoscope_N = mkN "食管镜" ; -- open-multilingual-wordnet
lin esoteric_A = mkA "秘传" ;
lin esp_N = mkN "电子稳定系统" ;
lin espadrille_N = mkN "平底凉鞋" ; -- open-multilingual-wordnet
lin espalier_N = mkN "墙树" | mkN "树篱" ; -- open-multilingual-wordnet
lin especial_A = mkA "特别是" ;
lin espionage_N = mkN "间谍" ;
lin esplanade_N = mkN "休闲地" ; -- open-multilingual-wordnet
lin espousal_N = mkN "拥护" ;
lin espouse_V2 = mkV2 "拥护" ;
lin espresso_N = mkN "浓咖啡" "杯" ;
lin esprit_de_corps_N = mkN "团队精神" ;
lin esq_PN = foreignPN "Esq" ; -- comment=src=eng status=guess
lin essay_N = mkN "文章" "篇" ;
lin essay_V = mkV "尝试" ;
lin essay_V2 = mkV2 "使+尝试" ;
lin essayist_N = mkN "散文家" "名" ;
lin essen_PN = mkPN "埃森" ; -- comment=src=geonames status=guess
lin essence_N = mkN "本质" | mkN "精神" "個" | {-HSK-} mkN "本质" "种" ;
lin essential_A = mkA "必要" | mkA "必需" | {-HSK-} mkA "本质" ;
lin essential_N = mkN "必要" | mkN "必需" | {-HSK-} mkN "必要" [] ;
lin essex_PN = foreignPN "Essex" ; -- comment=src=geonames status=guess
lin establish_V2 = mkV2 "建立" | {-HSK-} mkV2 "成立" ;
lin established_A = {-HSK-} mkA "悠久" ;
lin establishment_N = mkN "编制" ;
lin estaminet_N = mkN "小咖啡馆" | mkN "小酒店" ; -- open-multilingual-wordnet
lin estate_N = mkN "房地产" ;
lin esteem_N = mkN "尊敬" | {-HSK-} mkN "尊重" ;
lin ester_N = mkN "酯" ; -- status=guess -- open-multilingual-wordnet
lin esther_PN = foreignPN "Esther" ; -- comment=src=geonames status=guess
lin esthetic_N = mkN "美学" ; -- open-multilingual-wordnet
lin esthetical_A = mkA "审美" | mkA "富美感" | mkA "有美感" | mkA "美" | mkA "美学" ; -- open-multilingual-wordnet
lin esthetics_N = mkN "美学" ; -- open-multilingual-wordnet
lin estimate_N = mkN "预算" ;
lin estimate_V = mkV "估计" ;
lin estimate_V2 = mkV2 "估计" ;
lin estimate_V2V = mkV2V "估计" ;
lin estimate_VS = mkVS "估计" ;
lin estimated_A = variants {} ;
lin estimation_N = mkN "预算" ;
lin estradiol_N = mkN "雌二醇" | mkN "雌甾二醇" ; -- open-multilingual-wordnet
lin estrange_V2 = mkV2 "疏远" ;
lin estrangement_N = mkN "隔阂" | {-mwn-} mkN "不和" | mkN "疏远" | mkN "离间" ; -- open-multilingual-wordnet
lin estriol_N = mkN "雌三醇" ; -- open-multilingual-wordnet
lin estrogen_N = mkN "雌激素" ; -- status=guess -- open-multilingual-wordnet
lin estrogenic_A = mkA "动情激素" | mkA "雌激素" ; -- open-multilingual-wordnet
lin estrous_A = mkA "动情周期" | mkA "动情期" | mkA "发情期" | mkA "求偶期" ; -- open-multilingual-wordnet
lin estrus_N = mkN "动情周期" | mkN "动情期" | mkN "发情" ; -- open-multilingual-wordnet
lin estuarine_A = mkA "河口" | mkA "港湾" ; -- open-multilingual-wordnet
lin estuary_N = mkN "河口" | mkN "出海口" | mkN "入海口" ; -- status=guess -- status=guess -- status=guess
lin et_al_PN = foreignPN "Et al" ; -- comment=src=eng status=guess
lin et_seq_PN = foreignPN "Et seq" ; -- comment=src=eng status=guess
lin eta_N = mkN "艾塔" | mkN "伊塔" ; -- status=guess -- status=guess
lin etagere_N = mkN "放置古玩" ; -- open-multilingual-wordnet
lin etamine_N = mkN "筛绢" | mkN "纱罗" ; -- open-multilingual-wordnet
lin etc_PN = foreignPN "Etc" ; -- comment=src=eng status=guess
lin etcetera_N = mkN "等等" | mkN "诸如此类" ; -- open-multilingual-wordnet
lin eternal_A = mkA "永恒" | {-HSK-} mkA "永远" ;
lin eternity_N = mkN "永遠" | mkN "永远" ; -- status=guess -- status=guess
lin ethane_N = mkN "乙烷" ; -- status=guess
lin ethanol_N = mkN "乙醇" ; -- status=guess
lin ethel_PN = foreignPN "Ethel" ; -- comment=src=eng status=guess
lin ether_N = mkN "醚" ; -- status=guess
lin ethereal_A = mkA "空靈" | mkA "空灵" | {-mwn-} mkA "乙醚" | mkA "含乙醚" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ethic_N = mkN "伦理" [] ;
lin ethical_A = mkA "合乎道德" ;
lin ethics_N = {-HSK-} mkN "道德" "種" | {-mwn-} mkN "伦理学" ; -- open-multilingual-wordnet
lin ethiopia_PN = mkPN "埃塞俄比亚" ; -- comment=src=geonames status=guess
lin ethiopian_A = mkA "埃塞俄比亚" ;
lin ethnic_A = mkA "民族" ;
lin ethnic_N = mkN "種族清洗" | mkN "种族清洗" | mkN "民族凈化" | mkN "民族净化" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin ethnicity_N = mkN "民族" ; -- status=guess
lin ethnocentric_A = mkA "民族中心主义" | mkA "民族优越感" | mkA "种族优越感" ; -- open-multilingual-wordnet
lin ethnocentrism_N = mkN "民族優越感" | mkN "民族优越感" | mkN "民族优越感" ; -- status=guess -- status=guess -- status=guess
lin ethnographic_A = mkA "民族志学" ; -- open-multilingual-wordnet
lin ethnological_A = mkA "人种学" | mkA "民族" ; -- open-multilingual-wordnet
lin ethos_N = mkN "社会思潮" | mkN "民族精神" ;
lin ethyl_N = mkN "乙酸乙酯" | {-mwn-} mkN "乙基" ; -- status=guess -- open-multilingual-wordnet
lin ethylene_N = mkN "乙烯" ; -- status=guess -- open-multilingual-wordnet
lin etiquette_N = mkN "礼仪" ;
lin etui_N = mkN "小盒子" ; -- open-multilingual-wordnet
lin etymological_A = mkA "词源学" ; -- open-multilingual-wordnet
lin etymology_N = mkN "詞源" | mkN "词源" | mkN "語源" | mkN "语源" | mkN "字源" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin etymon_N = mkN "字根" ; -- status=guess
lin eucalyptus_N = mkN "桉树" ;
lin euclidean_A = mkA "欧几里得" ; -- open-multilingual-wordnet
lin eudemonic_A = mkA "幸福" ; -- open-multilingual-wordnet
lin eudiometer_N = mkN "測氣管" | {-mwn-} mkN "测气管" ; -- status=guess -- open-multilingual-wordnet
lin eugene_PN = mkPN "尤金" ; -- comment=src=geonames status=guess
lin eugenic_A = mkA "优生" | mkA "优生学" ; -- open-multilingual-wordnet
lin eukaryote_N = mkN "真核生物" ; -- status=guess
lin eukaryotic_A = mkA "真核细胞" ; -- open-multilingual-wordnet
lin eulogize_V2 = mkV2 "赞美" ;
lin eunice_PN = foreignPN "Eunice" ; -- comment=src=geonames status=guess
lin eunuch_N = mkN "閹人" | mkN "阉人" ; -- status=guess -- status=guess
lin euphemism_N = mkN "委婉语" "句" ;
lin euphonic_A = mkA "悦耳" ; -- open-multilingual-wordnet
lin euphonium_N = mkN "上低音大号" | mkN "次中音号" | mkN "粗管上低音号" ; -- open-multilingual-wordnet
lin euphorbium_N = mkN "大戟胶树脂" | mkN "大载乳脂" ; -- open-multilingual-wordnet
lin euphoria_N = mkN "欣快" ;
lin euphoriant_N = mkN "安乐药" | mkN "欣快剂" ; -- open-multilingual-wordnet
lin eurasia_PN = foreignPN "Eurasia" ; -- comment=src=eng status=guess
lin eurhythmics_N = mkN "艺术体操" | mkN "韵律体操" | mkN "韵律操" | mkN "韵律舞蹈" | mkN "韵律舞蹈体操" | mkN "韵律运动" ; -- open-multilingual-wordnet
lin euro_N = mkN "欧元" ;
lin eurodollar_N = mkN "欧洲美元" ;
lin europe_PN = mkPN "欧洲" ;
lin european_A = mkA "欧洲" ;
lin european_N = mkN "欧洲" [] ;
lin europium_N = mkN "銪" | mkN "铕" ; -- status=guess -- status=guess
lin eurovision_PN = foreignPN "Eurovision" ; -- comment=src=eng status=guess
lin eurythmics_N = mkN "艺术体操" | mkN "韵律体操" | mkN "韵律操" | mkN "韵律舞蹈" | mkN "韵律舞蹈体操" | mkN "韵律运动" ; -- open-multilingual-wordnet
lin eurythmy_N = mkN "艺术体操" | mkN "韵律体操" | mkN "韵律操" | mkN "韵律舞蹈" | mkN "韵律舞蹈体操" | mkN "韵律运动" ; -- open-multilingual-wordnet
lin eusporangium_N = mkN "厚孢子囊" | mkN "真孢子囊" ; -- open-multilingual-wordnet
lin eutectic_N = mkN "低共熔混合物" | mkN "易熔质" ; -- open-multilingual-wordnet
lin euthanasia_N = mkN "安樂死" | mkN "安乐死" ; -- status=guess -- status=guess
lin eutherian_A = mkA "真哺乳亚纲" ; -- open-multilingual-wordnet
lin eutrophic_A = mkA "富營養化" | mkA "富营养化" ; -- status=guess -- status=guess
lin eutrophication_N = mkN "富營養化" | mkN "富营养化" ; -- status=guess -- status=guess
lin eva_PN = foreignPN "Eva" ; -- comment=src=eng status=guess
lin evacuate_V2 = mkV2 "疏散" ;
lin evacuation_N = mkN "疏散" "次" ;
lin evade_V2 = mkV2 "逃避" ;
lin evaluate_V = mkV "评价" | {-HSK-} mkV "评估" ;
lin evaluate_V2 = mkV2 "评价" | {-HSK-} mkV2 "评估" ;
lin evaluation_N = mkN "评估" ;
lin evaluative_A = mkA "评价" | mkA "评估" ; -- open-multilingual-wordnet
lin evangelical_A = mkA "福音" ;
lin evangelist_N = mkN "福音传道者" "名" ;
lin evangelistic_A = mkA "福音传道者" ; -- open-multilingual-wordnet
lin evaporable_A = mkA "可蒸发" | mkA "挥发性" | mkA "蒸发" | mkA "蒸发性" ; -- open-multilingual-wordnet
lin evaporate_V = mkV "蒸发" ;
lin evaporate_V2 = mkV2 (mkV "蒸发掉") | mkV2 (mkV "消失") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin evaporate_VS = mkVS "使+蒸发" ;
lin evaporation_N = mkN "蒸发" ;
lin evaporative_A = mkA "蒸发" ; -- open-multilingual-wordnet
lin evaporite_N = mkN "蒸发岩" | mkN "蒸发盐" ; -- open-multilingual-wordnet
lin evasion_N = mkN "逃避" ;
lin eve_N = mkN "前夕" ;
lin eve_PN = foreignPN "Eve" ; -- comment=src=eng status=guess
lin evelyn_PN = foreignPN "Evelyn" ; -- comment=src=eng status=guess
lin even_1_A = mkA "哪怕" | mkA "均匀" | mkA "整齐" | mkA "甚至" | mkA "还" | {-HSK-} mkA "平均" ;
lin even_2_A = mkA "哪怕" | mkA "均匀" | mkA "整齐" | mkA "甚至" | mkA "还" | {-HSK-} mkA "平均" ;
lin even_AdA = mkAdA "甚至" ;
lin even_AdV = mkAdV "甚至" ;
lin even_Adv = mkAdv "哪怕" | mkAdv "均匀" | mkAdv "整齐" | mkAdv "甚至" | mkAdv "还" ;
lin even_N = mkN "偶数" | {-HSK-} mkN "哪怕" | mkN "均匀" | mkN "整齐" | mkN "甚至" | mkN "还" ;
lin even_V2 = mkV2 "平坦" ;
lin even_though_Subj = mkSubj "即使" ;
lin evening_N = mkN "晚间" ;
lin evensong_N = mkN "晚祷" ;
lin event_N = mkN "事件" ;
lin eventful_A = mkA "多事" | mkA "多變故" | mkA "多变故" ; -- status=guess -- status=guess -- status=guess
lin eventide_N = mkN "傍晚" | mkN "晚上" | mkN "薄暮" | mkN "黄昏" ; -- open-multilingual-wordnet
lin eventration_N = mkN "腹脏突出" ; -- open-multilingual-wordnet
lin eventual_A = mkA "最终" ;
lin ever_AdV = mkAdV "曾经" ;
lin ever_Adv = mkAdv "尝" | mkAdv "曾经" ;
lin evergreen_A = mkA "常青" ; -- status=guess
lin evergreen_N = mkN "常青樹" | mkN "常青树" | {-mwn-} mkN "常绿植物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin everlasting_A = mkA "永恒" ;
lin every_Det = S.every_Det | {-HSK-} mkpDet "一切" | mkpDet "凡是" | mkpDet "各" | mkpDet "每" ;
lin everybody_NP = S.everybody_NP ;
lin everyday_A = mkA "日常" | mkA "经常" ;
lin everyone_NP = mkNPword "每一个人" ;
lin everything_NP = S.everything_NP ;
lin everywhere_Adv = S.everywhere_Adv | {-HSK-} mkAdv "到处" | mkAdv "遍" ;
lin evesham_PN = foreignPN "Evesham" ; -- comment=src=geonames status=guess
lin evict_V2 = mkV2 (mkV "驅逐") | mkV2 (mkV "驱逐") | mkV2 (mkV "赶出") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin eviction_N = mkN "驅逐" | mkN "驱逐" | mkN "赶出" ; -- status=guess -- status=guess -- status=guess
lin evidence_1_N = mkN "证据" ;
lin evidence_2_N = mkN "证据" ;
lin evidence_N = mkN "证据" ;
lin evidence_V2 = mkV2 "证明" ;
lin evident_A = mkA "明显" | {-HSK-} mkA "显然" ;
lin evidential_A = mkA "作证据用" | mkA "证据" | mkA "证明" ; -- open-multilingual-wordnet
lin evil_A = mkA "邪恶" ;
lin evil_N = mkN "罪恶" ;
lin evince_V2 = mkV2 "表示出" ;
lin eviscerate_V2 = mkV2 "除去内脏" ;
lin evisceration_N = mkN "失去力量" | mkN "抽取精华" | mkN "挫伤元气" ; -- open-multilingual-wordnet
lin evitable_A = mkA "可避免" | mkA "可避开" | mkA "可防止" ; -- open-multilingual-wordnet
lin evocative_A = mkA "令人回味" ;
lin evoke_V2 = mkV2 "唤起" ;
lin evolution_N = mkN "进化" [] ;
lin evolutionary_A = mkA "进化" ;
lin evolutionistFem_N = variants {} ; ---- sense to be split
lin evolutionistMasc_N = variants {} ; ---- sense to be split
lin evolve_V = mkV "发展" ;
lin evolve_V2 = mkV2 "发展" ;
lin ewe_N = mkN "母羊" ; -- status=guess -- open-multilingual-wordnet
lin ewell_PN = foreignPN "Ewell" ; -- comment=src=geonames status=guess
lin ex_officio_A = mkA "按照职务" ;
lin exacerbate_V2 = mkV2 "加剧" ;
lin exacerbation_N = mkN "加剧" | mkN "加重" | mkN "增剧" | mkN "恶化" | mkN "更恶化" ; -- open-multilingual-wordnet
lin exact_A = mkA "准确" | {-HSK-} mkA "确切" ;
lin exactness_N = mkN "精確" | mkN "精确" | mkN "準確度" | mkN "准确度" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin exaggerate_V = mkV "夸" | {-HSK-} mkV "夸大" ;
lin exaggerate_V2 = mkV2 "夸" | {-HSK-} mkV2 "夸大" ;
lin exaggeration_N = mkN "誇大" | mkN "夸大" | mkN "誇張" | mkN "夸张" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin exam_N = mkN "考试" "场" | {-HSK-} mkN "考试" "次" ;
lin examination_N = mkN "检查" | {-HSK-} mkN "试" ;
lin examine_V2 = mkV2 "检查" | {-HSK-} mkV2 "观察" ;
lin examiner_N = mkN "检查员" ;
lin example_N = mkN "例子" ;
lin exanthem_N = mkN "疹" ; -- open-multilingual-wordnet
lin exasperate_V2 = mkV2 (mkV "使恼怒") ; -- status=guess, src=wikt
lin exasperating_A = mkA "使更恶化" | mkA "恶化" ; -- open-multilingual-wordnet
lin exasperation_N = mkN "恼怒" ;
lin excavate_V = mkV "挖掘" ;
lin excavation_N = variants {} ;
lin excavator_N = mkN "挖掘机" ;
lin exceed_V2 = mkV2 "超过" | {-HSK-} mkV2 "越" ;
lin exceeding_A = mkA "超额" ;
lin excel_V = mkV "擅长" ;
lin excel_V2 = mkV2 (mkV "擅長") | mkV2 (mkV "擅长") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin excellence_N = mkN "卓越" ;
lin excellent_A = mkA "优秀" ;
lin except_Conj = variants {} ;
lin except_Prep = S.except_Prep ;
lin except_V2 = mkV2 "除" ;
lin except_for_Prep = mkPrep "除了" ;
lin exception_N = mkN "例外" ;
lin exceptional_A = mkA "优秀" | {-HSK-} mkA "非常" ;
lin excerpt_N = mkN "摘录" ;
lin excess_A = mkA "多余" ;
lin excess_N = mkN "多余" ;
lin excessive_A = mkA "过分" | {-HSK-} mkA "过多" ;
lin exchange_N = mkN "交流" | mkN "换" | {-HSK-} mkN "兑换" ;
lin exchange_V2 = mkV2 "交换" | {-HSK-} mkV2 "交流" ;
lin exchangeable_A = mkA "可兑换" ;
lin exchequer_N = mkN "国库" ;
lin excise_N = mkN "消费税" ;
lin excise_V2 = mkV2 "消费税" ;
lin excision_N = mkN "切除" "" ;
lin excitant_A = mkA "使兴奋" | mkA "兴奋" | mkA "刺激" | mkA "刺激性" ; -- open-multilingual-wordnet
lin excite_V2 = mkV2 "刺激" | mkV2 "激动" | {-HSK-} mkV2 "激发" ;
lin excited_A = {-HSK-} mkA "兴奋" ;
lin excitement_N = mkN "兴奋" | {-HSK-} mkN "激动" [] ;
lin exciting_A = mkA "扣人心弦" | {-HSK-} mkA "激动" ;
lin excl_PN = foreignPN "Excl" ; -- comment=src=eng status=guess
lin exclaim_V2 = mkV2 "喊叫" ;
lin exclamation_N = mkN "叫喊" | mkN "感嘆" | mkN "感叹" ; -- status=guess -- status=guess -- status=guess
lin exclude_V2 = mkV2 "排除" | {-HSK-} mkV2 "除" ;
lin exclusion_N = mkN "排除" [] ;
lin exclusive_A = mkA "独家" ;
lin exclusive_N = mkN "專有權" | mkN "专有权" ; -- status=guess -- status=guess
lin excogitation_N = mkN "发明" | mkN "构思" ; -- open-multilingual-wordnet
lin excogitative_A = mkA "发明" | mkA "想出" ; -- open-multilingual-wordnet
lin excommunication_N = mkN "逐出教會" | mkN "逐出教会" ; -- status=guess -- status=guess
lin excoriate_V2 = mkV2 "批判" ;
lin excrement_N = mkN "大便" | mkN "屎" | mkN "糞" | mkN "粪" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin excrete_V2 = mkV2 (mkV "排泄") ; -- status=guess, src=wikt
lin excretion_N = mkN "排泄" ; -- open-multilingual-wordnet
lin excretory_A = mkA "分泌" | mkA "排泄" ; -- open-multilingual-wordnet
lin excursion_N = mkN "偏移" ;
lin excuse_N = mkN "借" | {-HSK-} mkN "借口" ;
lin excuse_V2 = mkV2 "原谅" ;
lin excuse_me_Interj = mkInterj "原谅我" ;
lin execute_V2 = mkV2 "执行" | {-HSK-} mkV2 "进行" ;
lin execution_N = mkN "执行" ;
lin executive_A = mkA "执行" ;
lin executive_N = mkN "管理人" ;
lin executor_N = mkN "执行者" ;
lin exegetic_A = mkA "注释" | mkA "解经" | mkA "评释" ; -- open-multilingual-wordnet
lin exemplar_N = mkN "典型" | mkN "榜样" | mkN "模范" ; -- open-multilingual-wordnet
lin exemplary_A = mkA "典范" ;
lin exemplify_V2 = mkV2 "例证" ;
lin exempt_A = mkA "豁免" ;
lin exempt_V2 = mkV2 "豁免" ;
lin exemption_N = mkN "豁免" "次" ;
lin exercise_N = mkN "练习" "個" | {-HSK-} mkN "锻炼" ;
lin exercise_V = mkV "活动" | {-HSK-} mkV "锻炼" ;
lin exercise_V2 = mkV2 "活动" | {-HSK-} mkV2 "练习" ;
lin exercise_VV = mkVV "活动" | {-HSK-} mkVV "练习" ;
lin exert_V2 = mkV2 "发挥" ;
lin exeter_PN = mkPN "埃克塞特" ; -- comment=src=geonames status=guess
lin exfoliation_N = mkN "去角質" | mkN "去角质" ; -- status=guess -- status=guess
lin exhale_V = mkV "呼气" ;
lin exhaust_N = mkN "废气" ;
lin exhaust_V2 = mkV2 "吃" | {-HSK-} mkV2 "排气" ;
lin exhausting_A = mkA "辛苦" ;
lin exhaustion_N = mkN "枯竭" ;
lin exhaustive_A = mkA "详细" ;
lin exhibit_N = mkN "证物" ;
lin exhibit_V2 = mkV2 "发挥" | mkV2 "展览" | mkV2 "摆" | {-HSK-} mkV2 "展出" ;
lin exhibition_N = mkN "展览" | {-HSK-} mkN "展览" "個" | mkN "表演" "場" ;
lin exhibitionism_N = mkN "暴露癖" | mkN "露陰癖" | mkN "露阴癖" | mkN "露體癖" | mkN "露体癖" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin exhibitionistic_A = mkA "表现狂" | mkA "表现癖" | mkA "风头主义" ; -- open-multilingual-wordnet
lin exhibitor_N = mkN "展出者" ;
lin exhilaration_N = mkN "愉快" ;
lin exhort_V2 = mkV2 "告诫" | {-HSK-} mkV2 "嘱咐" ;
lin exhumation_N = mkN "發掘" | mkN "发掘" ; -- status=guess -- status=guess
lin exhume_V2 = mkV2 (mkV "發掘") | mkV2 (mkV "发掘") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin exigency_N = mkN "紧急事故" | mkN "紧急情况" ; -- open-multilingual-wordnet
lin exile_N = mkN "流放" ; -- comment="充军" ;
lin exile_V2 = mkV2 "流放" ;
lin exilic_A = mkA "放逐" | mkA "流亡" ; -- open-multilingual-wordnet
lin exist_V = mkV "在" | mkV "存在" | mkV "有" ;
lin existence_N = mkN "存在" [] ;
lin existent_A = mkA "存在" ;
lin existential_A = mkA "存在主義" | mkA "存在主义" ; -- status=guess -- status=guess
lin existentialism_N = mkN "存在主義" | mkN "存在主义" ; -- status=guess -- status=guess
lin existentialist_A = mkA "存在主义" ; -- open-multilingual-wordnet
lin existentialist_N = mkN "存在主义" ;
lin existing_A = variants {} ;
lin exit_N = mkN "出口" ;
lin exit_V = mkV "退出" ;
lin exmouth_PN = foreignPN "Exmouth" ; -- comment=src=geonames status=guess
lin exobiology_N = mkN "天體生物學" | mkN "外空生物学" | mkN "太空生物学" ; -- status=guess -- status=guess -- status=guess
lin exocrine_A = mkA "外分泌" | mkA "外分泌腺" ; -- open-multilingual-wordnet
lin exodus_N = mkN "出埃及记" ;
lin exogamy_N = mkN "异族结婚" ; -- open-multilingual-wordnet
lin exomphalos_N = mkN "脐突出" ; -- open-multilingual-wordnet
lin exon_N = mkN "外顯子" ; -- status=guess
lin exonerate_V2 = mkV2 "开脱" ;
lin exonuclease_N = mkN "核酸外切酶" ; -- open-multilingual-wordnet
lin exophthalmos_N = mkN "眼球突出" ; -- open-multilingual-wordnet
lin exorbitant_A = mkA "过高" ;
lin exorcise_V2 = mkV2 "驱邪" ;
lin exorcism_N = mkN "驅魔" | mkN "驱魔" | mkN "破魔" ; -- status=guess -- status=guess -- status=guess
lin exostosis_N = mkN "外生性骨疣" | mkN "外生骨疣" ; -- open-multilingual-wordnet
lin exoteric_A = mkA "通俗" ; -- status=guess
lin exotic_A = mkA "异国情调" ;
lin exotoxin_N = mkN "外毒素" | mkN "外泌毒" ; -- open-multilingual-wordnet
lin expand_V = mkV "发展" | mkV "扩大" ;
lin expand_V2 = mkV2 "发展" | mkV2 "扩大" ;
lin expandable_A = mkA "可扩展" ; -- status=guess
lin expanse_N = mkN "宽阔" ;
lin expansion_N = mkN "扩张" ;
lin expansionist_A = mkA "扩张主义" ; -- open-multilingual-wordnet
lin expansive_A = mkA "膨胀" ;
lin expatriate_N = mkN "僑民" | mkN "侨民" | mkN "僑居國外者" | mkN "侨居国外者" | mkN "海外國民" | mkN "海外国民" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin expect_V = mkV "期望" ;
lin expect_V2 = mkV2 "期望" ;
lin expect_V2V = mkV2V "希望" ;
lin expect_VS = mkVS "期望" ;
lin expect_VV = mkVV "期望" ;
lin expectancy_N = mkN "期望" ;
lin expectant_A = mkA "期待" ;
lin expectation_N = mkN "期待" | {-HSK-} mkN "期望" ;
lin expected_A = variants {} ;
lin expectorant_N = mkN "祛痰剂" | mkN "除痰剂" ; -- open-multilingual-wordnet
lin expectorate_V = mkV "吐出" | mkV "吐痰" ; -- open-multilingual-wordnet
lin expedient_N = mkN "权宜之计" ;
lin expedite_V2 = mkV2 "促进" | {-HSK-} mkV2 "催" ;
lin expedition_N = mkN "远征""次" ;
lin expeditious_A = mkA "迅速" ;
lin expel_V2 = mkV2 "驱逐" ;
lin expend_V2 = mkV2 "花费" ;
lin expendable_A = mkA "可消耗" ;
lin expenditure_N = mkN "支出" | {-HSK-} mkN "费用" "筆" ;
lin expense_N = mkN "费用" | {-HSK-} mkN "费用" "筆" ;
lin expensive_A = mkA "昂贵" | {-HSK-} mkA "贵" ;
lin experience_N = mkN "经历" "個" | mkN "经验" ;
lin experience_V2 = mkV2 "更" | mkV2 "经验" ;
lin experienced_A = mkA "有经验" | {-HSK-} mkA "老" ;
lin experiment_N = mkN "实验" | {-HSK-} mkN "试" ;
lin experiment_V = mkV "实验" ;
lin experiment_V2 = mkV2 "实验" | {-HSK-} mkV2 "尝试" ;
lin experimental_A = mkA "实验" ;
lin experimentation_N = mkN "实验" "次" ;
lin experimenterFem_N = variants {} ; ---- sense to be split
lin experimenterMasc_N = variants {} ; ---- sense to be split
lin expert_A = mkA "专家" | {-HSK-} mkA "大方" ;
lin expert_N = mkN "专家" | {-HSK-} mkN "专家" "個" | mkN "大方" ;
lin expertise_N = mkN "专门知识" ;
lin expiatory_A = mkA "补偿" ; -- open-multilingual-wordnet
lin expiration_N = mkN "期满" ;
lin expiratory_A = mkA "吐气" | mkA "呼气" ; -- open-multilingual-wordnet
lin expire_V = mkV "到期" ;
lin expire_V2 = mkV2 "到期" ;
lin expire_VS = mkVS "到期" ;
lin expiry_N = mkN "死" | mkN "死亡" ; -- open-multilingual-wordnet
lin explain_V2 = mkV2 "白" | mkV2 "解释" | mkV2 "讲" | mkV2 "说明" ;
lin explain_VS = mkVS "白" | mkVS "解释" | mkVS "讲" | mkVS "说明" ;
lin explain_away_V = advV (lin V OP_explain_V2) OP_away_Adv ; -- guess-p-verb
lin explanation_N = mkN "解释" | {-HSK-} mkN "解释" "個" | mkN "说明" "個" ;
lin explanatory_A = mkA "解释" ;
lin expletive_N = mkN "脏话" ;
lin explicate_V2 = mkV2 (mkV "阐明") ; -- status=guess, src=wikt
lin explicit_A = mkA "明确" ;
lin explode_V = mkV "爆炸" ;
lin exploit_N = mkN "利用" | mkN "开发" | {-HSK-} mkN "利用" "" ;
lin exploit_V2 = mkV2 "利用" ;
lin exploitation_N = mkN "开发" "次" ;
lin exploiter_N = mkN "剝削者" | mkN "剥削者" ; -- status=guess -- status=guess
lin exploration_N = mkN "探索" ;
lin exploratory_A = mkA "探索" ;
lin explore_V2 = mkV2 "探索" ;
lin explore_VS = mkVS "探索" ;
lin explorerFem_N = variants {} ; ---- sense to be split
lin explorerMasc_N = variants {} ; ---- sense to be split
lin explosion_N = mkN "爆炸" ;
lin explosive_A = mkA "爆炸性" ;
lin explosive_N = mkN "爆炸物" ;
lin expo_N = mkN "博览会" ;
lin exponent_1_N = mkN "指数" ; -- status=guess
lin exponent_2_N = mkN "指数" ; -- status=guess
lin exponential_A = mkA "指数" ; -- open-multilingual-wordnet
lin exponential_N = mkN "指数函数" ; -- open-multilingual-wordnet
lin export_N = mkN "出口" ;
lin export_V = mkV "出口" ;
lin export_V2 = mkV2 "出口" ;
lin exporterFem_N = mkN "出口" ;
lin exporterMasc_N = mkN "出口" ;
lin expose_V = mkV "暴露" | {-HSK-} mkV "露" ;
lin expose_V2 = mkV2 "暴露" | {-HSK-} mkV2 "露" ;
lin exposition_N = mkN "博览会" ;
lin exposure_N = mkN "曝光" ;
lin expound_V2 = mkV2 (mkV "闡述") | mkV2 (mkV "阐述") | mkV2 (mkV "闡明") | mkV2 (mkV "阐明") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin expound_VS = mkVS "阐述" ;
lin express_A = mkA "明确" ;
lin express_Adv = mkAdv "迅速" ;
lin express_N = mkN "快车" ;
lin express_V2 = mkV2 "表示" | mkV2 "表达" ;
lin expression_N = mkN "表情" | mkN "表现" | mkN "词语" | {-HSK-} mkN "表达" ;
lin expressionism_N = mkN "表現主義" | mkN "表现主义" ; -- status=guess -- status=guess
lin expressionistFem_N = variants {} ; ---- sense to be split
lin expressionistMasc_N = variants {} ; ---- sense to be split
lin expressionist_A = mkA "表现主义" ; -- open-multilingual-wordnet
lin expressionless_A = mkA "呆" ;
lin expressive_A = mkA "表现" ;
lin expressway_N = mkN "高速公路" ; -- status=guess -- status=guess
lin expulsion_N = mkN "開除" | mkN "开除" | mkN "驅逐" | mkN "驱逐" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin expunction_N = mkN "删掉" | mkN "抹掉" | mkN "擦掉" | mkN "消去" | mkN "除去" ; -- open-multilingual-wordnet
lin expunge_V2 = mkV2 "删掉" ;
lin expurgation_N = mkN "修正" | mkN "删去" | mkN "删除" | mkN "廓清" | mkN "消去" ; -- open-multilingual-wordnet
lin exquisite_A = mkA "精致" | {-HSK-} mkA "讲究" ;
lin extend_V = mkV "伸" | mkV "延长" | mkV "接" | mkV "推广" ;
lin extend_V2 = mkV2 "伸" | mkV2 "延长" | mkV2 "接" | mkV2 "推广" | {-HSK-} mkV2 "扩展" ;
lin extended_A = variants {} ;
lin extension_N = mkN "延期" ;
lin extensive_A = mkA "广泛" ;
lin extent_N = mkN "程度" | {-HSK-} mkN "范围" "個" | mkN "规模" "個" ;
lin extenuation_N = mkN "减轻" | mkN "缓和" ; -- open-multilingual-wordnet
lin exterior_A = mkA "外部" ;
lin exterior_N = mkN "外部" ;
lin extermination_N = mkN "灭绝" ;
lin external_A = mkA "外" | {-HSK-} mkA "外部" ;
lin external_N = mkN "外" | {-HSK-} mkN "外部""" ;
lin exteroceptive_A = mkA "外感受性" | mkA "感受外界刺激" ; -- open-multilingual-wordnet
lin exterritorial_A = mkA "治外法权" ; -- open-multilingual-wordnet
lin extinct_A = mkA "灭绝" ;
lin extinction_N = mkN "灭绝" ;
lin extinguish_V2 = mkV2 "熄灭" ;
lin extinguisher_N = mkN "灭火器" ; -- open-multilingual-wordnet
lin extort_V = mkV "敲诈" ;
lin extort_V2 = mkV2 "敲诈" ;
lin extortion_N = mkN "敲诈" "次" ;
lin extra_A = mkA "零" | {-HSK-} mkA "额外" ;
lin extra_Adv = mkAdv "零" | {-HSK-} mkAdv "額外" | mkAdv "额外" | mkAdv "超級" | mkAdv "超级" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin extra_N = mkN "零" | {-HSK-} mkN "额外" "" ;
lin extract_N = mkN "提取物" ;
lin extract_V2 = mkV2 "提取" ;
lin extraction_N = mkN "取出" ;
lin extractor_N = mkN "吸油煙機" | mkN "吸油烟机" | mkN "抽油煙機" | mkN "抽油烟机" | {-mwn-} mkN "火炮抽筒子" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin extracurricular_A = mkA "业余" ;
lin extradite_V2 = mkV2 "引渡" ;
lin extradition_N = mkN "引渡" "次" ;
lin extrados_N = mkN "拱背线" ; -- open-multilingual-wordnet
lin extragalactic_A = mkA "银河系外" ; -- open-multilingual-wordnet
lin extralinguistic_A = mkA "语言之外" | mkA "语言外" ; -- open-multilingual-wordnet
lin extramarital_A = mkA "婚外" ;
lin extramural_A = mkA "市外" ;
lin extraneous_A = mkA "无关" ;
lin extraneousness_N = mkN "无关" ; -- open-multilingual-wordnet
lin extraordinary_A = mkA "了不起" | mkA "挺" | mkA "特殊" | mkA "非常" | {-HSK-} mkA "非凡" ;
lin extrasensory_A = mkA "超感官" | mkA "超感觉" ; -- open-multilingual-wordnet
lin extrasystolic_A = mkA "期前收缩" | mkA "过早搏动" | mkA "额外收缩" ; -- open-multilingual-wordnet
lin extraterrestrial_A = mkA "地球外" | {-mwn-} mkA "地球外" | mkA "天外" ; -- status=guess -- open-multilingual-wordnet
lin extraterritorial_A = mkA "治外法权" ; -- open-multilingual-wordnet
lin extravagance_N = mkN "奢侈" [] ;
lin extravagant_A = mkA "奢靡" ;
lin extravasation_N = mkN "外渗" | mkN "流出" ; -- open-multilingual-wordnet
lin extreme_A = mkA "极端" | {-HSK-} mkA "非常" ;
lin extreme_N = mkN "极端" | {-HSK-} mkN "非常" ;
lin extremism_N = mkN "極端主義" | mkN "极端主义" | mkN "過激主義" | mkN "过激主义" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin extremist_N = mkN "极端主义者" ;
lin extremity_N = mkN "末端" ; -- status=guess
lin extricate_V2 = mkV2 "解救" ;
lin extrusion_N = mkN "挤出" [] ;
lin exuberance_N = mkN "丰富" [] ;
lin exudate_N = mkN "分泌液" | mkN "分泌物" ; -- open-multilingual-wordnet
lin exude_V = mkV "滲出" | mkV "渗出" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin exude_V2 = mkV2 "散发着" ;
lin exultation_N = mkN "大喜" | mkN "歡騰" | mkN "欢腾" ; -- status=guess -- status=guess -- status=guess
lin eye_N = L.eye_N | {-HSK-} mkN "眼睛" "隻" ;
lin eye_V2 = mkV2 "注视" ;
lin eye_catching_A = mkA "有吸引力" ;
lin eyeball_N = mkN "眼球" "只" ;
lin eyeball_V2 = mkV2 "盯住看" ;
lin eyebath_N = mkN "洗眼杯" ; -- open-multilingual-wordnet
lin eyebrow_N = mkN "眉" | {-HSK-} mkN "眉毛" "根" ;
lin eyecup_N = mkN "视杯" ; -- open-multilingual-wordnet
lin eyeglass_N = mkN "眼镜" ;
lin eyelash_N = mkN "睫毛" ; -- status=guess
lin eyelessness_N = mkN "无眼" ; -- open-multilingual-wordnet
lin eyelet_N = mkN "金属圈" ; -- open-multilingual-wordnet
lin eyelid_N = mkN "眼皮" | mkN "瞼" | mkN "睑" ; -- status=guess -- status=guess -- status=guess
lin eyeliner_N = mkN "眼線筆" | mkN "眼线笔" | mkN "眼線膏" | mkN "眼线膏" | {-mwn-} mkN "眼线液" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin eyepatch_N = mkN "眼罩" ; -- open-multilingual-wordnet
lin eyepiece_N = mkN "目鏡" | mkN "目镜" | mkN "接目鏡" | mkN "接目镜" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin eye_shadow_N = mkN "眼影" ; -- open-multilingual-wordnet
lin eyestrain_N = mkN "眼疲劳" | mkN "眼睛疲劳" | mkN "视疲劳" ; -- open-multilingual-wordnet
lin eyewash_N = mkN "洗眼药" ; -- open-multilingual-wordnet
lin eyewitness_N = mkN "目击者" ;
lin eyrie_N = mkN "鷹巢" | mkN "鹰巢" | {-mwn-} mkN "巢" | mkN "雏" | mkN "高处的城堡" | mkN "高处的房子" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin eyry_N = mkN "巢" | mkN "雏" | mkN "高处的城堡" | mkN "高处的房子" ; -- open-multilingual-wordnet
lin fable_N = mkN "寓言" ; -- status=guess
lin fabled_A = mkA "传说中" ;
lin fabric_N = mkN "布" [] ;
lin fabricate_V2 = mkV2 "编造" ;
lin fabrication_N = mkN "制造业" ;
lin fabulous_A = mkA "难以置信" ;
lin facade_N = mkN "正面" ;
lin face_N = mkN "脸" "張" | mkN "表面" | {-HSK-} mkN "面对" ;
lin face_V = mkV "向" | mkV "对" | mkV "面对" ;
lin face_V2 = mkV2 "向" | mkV2 "对" | mkV2 "面对" ;
lin face_off_V2 = prepV2 OP_face_V OP_off_Prep ; -- guess-p-verb
lin face_saving_A = mkA "爱面子" ;
lin face_up_to_V2 = prepV2 (advV OP_face_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin faceless_A = mkA "無臉" | mkA "无脸" | mkA "無面" | mkA "无面" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin facet_N = mkN "刻面" | {-mwn-} mkN "方面" ; -- status=guess -- open-multilingual-wordnet
lin faceted_A = mkA "有小面" ; -- open-multilingual-wordnet
lin facetious_A = mkA "诙谐" ;
lin facial_A = mkA "面部" ;
lin facial_N = mkN "鬍子" | mkN "胡子" ; -- status=guess -- status=guess
lin facile_A = mkA "有口才" | mkA "雄辩" ; -- open-multilingual-wordnet
lin facilitate_V2 = mkV2 "便利" ;
lin facility_N = mkN "设施" ;
lin facing_N = mkN "朝" | {-HSK-} mkN "饰面" ;
lin facsimile_N = mkN "传真" ;
lin fact_N = mkN "事实" ;
lin fact_finding_A = mkA "事实调查" ;
lin faction_N = mkN "派" | {-HSK-} mkN "派别" ;
lin factor_N = mkN "因素" | {-HSK-} mkN "因素" "個" | mkN "条件" "個" ;
lin factorial_A = mkA "因子" | mkA "阶乘" ; -- open-multilingual-wordnet
lin factorial_N = mkN "階乘" ; -- status=guess
lin factory_N = L.factory_N | {-HSK-} mkN "工厂" "家" ;
lin factual_A = mkA "事实" ;
lin faculty_N = mkN "学院" ;
lin fad_N = mkN "时尚" ;
lin fade_N = mkN "褪色""" ;
lin fade_V = mkV "褪色" ;
lin fade_V2 = mkV2 "褪色" ;
lin fag_N = mkN "同志" ; -- status=guess
lin faggot_N = mkN "捆" | mkN "束" | mkN "束薪" | mkN "柴把" ; -- open-multilingual-wordnet
lin fagot_N = mkN "捆" | mkN "束" | mkN "束薪" | mkN "柴把" ; -- open-multilingual-wordnet
lin faience_N = mkN "彩釉" | mkN "精巧彩色陶器" ; -- open-multilingual-wordnet
lin fail_N = mkN "不及格""" ;
lin fail_V = mkV "失败" ;
lin fail_V2 = mkV2 "失败" ;
lin fail_VV = mkVV "失败" ;
lin failing_N = mkN "失败" ;
lin faille_N = mkN "罗缎" | mkN "菲尔绸" ; -- open-multilingual-wordnet
lin failure_N = mkN "失败" | {-HSK-} mkN "失败" "次" ;
lin fain_Adv = mkAdv "乐意+地" | mkAdv "欢喜+地" | mkAdv "欣然+地" | mkAdv "高兴+地" ; -- open-multilingual-wordnet
lin faint_A = mkA "晕" | {-HSK-} mkA "虚弱" ;
lin faint_N = mkN "昏厥" | {-HSK-} mkN "晕" ; -- status=guess
lin faint_V = mkV "模糊" ;
lin fair_A = mkA "公平" | {-HSK-} mkA "合理" ;
lin fair_Adv = {-HSK-} mkAdv "公平" | mkAdv "合理" ;
lin fair_N = mkN "公平" | mkN "合理" | {-HSK-} mkN "市集" | mkN "展览会" ;
lin fairlead_N = mkN "导索器" ; -- open-multilingual-wordnet
lin fairly_Adv = {-HSK-} mkAdv "比较" | mkAdv "相当" | mkAdv "还" | adjAdv fair_A ; -- derived
lin fairness_N = mkN "公平" [] ;
lin fairway_N = mkN "航路" "条" ;
lin fairy_N = mkN "仙女" ;
lin fairyland_N = mkN "仙境" | mkN "洞天" ; -- status=guess -- status=guess
lin fait_accompli_N = mkN "既成事实" ;
lin faith_N = mkN "信仰" ;
lin faithful_A = mkA "忠实" ;
lin fake_A = mkA "假" | {-HSK-} mkA "僞" | mkA "伪" | mkA "贗" | mkA "赝" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin fake_N = mkN "假" ;
lin fake_V2 = mkV2 "冒充" ;
lin falcate_A = mkA "镰刀形" | mkA "镰状" ; -- open-multilingual-wordnet
lin falchion_N = mkN "弯形大刀" ; -- open-multilingual-wordnet
lin falcon_N = mkN "隼" "只" ;
lin falconine_A = mkA "猎鹰" | mkA "猎鹰似" ; -- open-multilingual-wordnet
lin falkirk_PN = foreignPN "Falkirk" ; -- comment=src=geonames status=guess
lin fall_1_N = variants {} ;
lin fall_2_N = variants {} ;
lin fall_N = mkN "下降" ;
lin fall_V = mkV "下跌" | {-HSK-} mkV "掉" | mkV "摔" ;
lin fall_about_V = advV OP_fall_V OP_about_Adv ; -- guess-p-verb
lin fall_apart_V = mkV "崩溃" ;
lin fall_back_V = advV OP_fall_V OP_back_Adv ; -- guess-p-verb
lin fall_back_on_V2 = prepV2 (advV OP_fall_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin fall_behind_V = mkV "落后" ;
lin fall_behind_in_V2 = prepV2 (advV OP_fall_V OP_behind_Adv ) OP_in_Prep ; -- guess-p-verb
lin fall_down_V = mkV "倒下" | mkV "掉下" | mkV "落下" ; -- open-multilingual-wordnet
lin fall_for_V2 = prepV2 OP_fall_V OP_for_Prep ; -- guess-p-verb
lin fall_in_V = mkV "倒坍" | mkV "倒塌" | mkV "垮掉" | mkV "崩溃" | mkV "崩落" | mkV "破坏" | mkV "陷落" ; -- open-multilingual-wordnet
lin fall_into_V2 = prepV2 OP_fall_V OP_into_Prep ; -- guess-p-verb
lin fall_off_V = advV OP_fall_V OP_off_Adv ; -- guess-p-verb
lin fall_out_V = advV OP_fall_V OP_out_Adv ; -- guess-p-verb
lin fall_out_with_V2 = prepV2 (advV OP_fall_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin fall_over_V = advV OP_fall_V OP_over_Adv ; -- guess-p-verb
lin fall_through_V = mkV "吹" | mkV "黄" | {-mwn-} mkV "失败" | mkV "完全失败" ; -- open-multilingual-wordnet
lin fall_under_V2 = prepV2 OP_fall_V OP_under_Prep ; -- guess-p-verb
lin fallacious_A = mkA "荒谬" ;
lin fallboard_N = mkN "铰链板" ; -- open-multilingual-wordnet
lin fallible_A = mkA "犯错误" ;
lin fallout_N = mkN "辐射" ;
lin fallow_A = mkA "休耕" ;
lin fallow_N = mkN "黇鹿" ; -- status=guess
lin falls_N = mkN "瀑布" ; -- open-multilingual-wordnet
lin falmouth_PN = mkPN "法尔茅斯" ; -- comment=src=geonames status=guess
lin false_A = mkA "假" | {-HSK-} mkA "错误" ;
lin false_Adv = mkAdv "假" ;
lin falseness_N = mkN "虚伪性" "" ;
lin falsetto_N = mkN "假聲" | mkN "假声" ; -- status=guess -- status=guess
lin falsie_N = mkN "假乳房" ; -- open-multilingual-wordnet
lin falsify_V2 = mkV2 "伪造" ;
lin falter_V = mkV "衰退" ;
lin fame_N = mkN "名誉" | {-HSK-} mkN "闻" ;
lin fame_V2 = mkV2 "名声" ; -- comment="名望" ;
lin familial_A = mkA "家庭" | {-mwn-} mkA "家庭" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin familiar_A = mkA "亲切" | mkA "密切" | {-HSK-} mkA "熟悉" ;
lin familiar_N = mkN "亲切" | mkN "密切" | {-HSK-} mkN "常客""位" ;
lin familiar_with_A2 = mkA2 "熟悉" ;
lin familiarity_N = mkN "熟悉" ; -- comment="精通" ;
lin familiarization_N = mkN "熟悉" ; -- status=guess
lin familiarize_V2 = mkV2 "熟悉" ;
lin family_N = mkN "家" | mkN "家庭" "戶" | mkN "门" | {-HSK-} mkN "家庭" ;
lin famine_N = mkN "饥荒" ;
lin famous_A = mkA "有名" | mkA "著名" | mkA "闻" ;
lin fan_1_N = mkN "爱好者" ;
lin fan_2_N = mkN "爱好者" ;
lin fan_3_N = mkN "爱好者" ;
lin fan_N = variants {} ;
lin fan_V = variants {} ; -- comment=mkV2 "煽动" ;
lin fan_V2 = mkV2 "煽动" ;
lin fanaticFem_N = mkN "狂热" ;
lin fanaticMasc_N = mkN "狂热" ;
lin fanatic_A = mkA "狂热" ;
lin fanaticism_N = mkN "狂熱" | mkN "狂热" | mkN "狂信" ; -- status=guess -- status=guess -- status=guess
lin fanciful_A = mkA "稀奇" ;
lin fancy_A = mkA "花样" ;
lin fancy_N = mkN "花式" ;
lin fancy_V2 = mkV2 "想象" | {-HSK-} mkV2 "花俏" ;
lin fandom_N = mkN "迷文化" ; -- status=guess
lin fanfare_N = mkN "炫耀" ;
lin fang_N = mkN "尖牙" "根" ;
lin fanged_A = mkA "有尖牙" | mkA "有毒牙" ; -- open-multilingual-wordnet
lin fanion_N = mkN "小旗" ; -- open-multilingual-wordnet
lin fanjet_N = mkN "涡喷发动机" | mkN "涡轮风扇" ; -- open-multilingual-wordnet
lin fanlight_N = mkN "扇形气窗" ; -- open-multilingual-wordnet
lin fanlike_A = mkA "扇状" ; -- open-multilingual-wordnet
lin fanny_N = mkN "舳" ;
lin fanny_PN = foreignPN "Fanny" ; -- comment=src=eng status=guess
lin fantail_N = mkN "扇形尾端" | mkN "扇形船尾" | mkN "甲板突出部" | mkN "鸭尾艄" ; -- open-multilingual-wordnet
lin fantasize_V = mkV "幻想" ;
lin fantastic_A = mkA "奇妙" ;
lin fantastically_Adv = mkAdv "奇特地" | mkAdv "难以置信地" ; -- status=guess -- status=guess
lin fantasy_N = mkN "幻想" ;
lin fantods_N = mkN "烦燥" | mkN "病态" ; -- open-multilingual-wordnet
lin far_A = mkA "远" ;
lin far_AdA = mkAdA "遥远" ;
lin far_V2 = mkV2 "使+远" ;
lin far_flung_A = mkA "偏远" ;
lin far_reaching_A = mkA "深远" ;
lin farad_N = mkN "法拉" ; -- status=guess
lin farce_N = mkN "闹剧" ;
lin fare_N = mkN "票价" ;
lin fare_V = mkV "旅行" ;
lin farewell_N = mkN "告別" | mkN "告别" | mkN "送別" | mkN "送别" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin farinaceous_A = mkA "粉状" | mkA "粒状" ; -- open-multilingual-wordnet
lin farm_N = mkN "农场" ;
lin farm_V = mkV "种田" ;
lin farm_V2 = mkV2 "种田" ;
lin farmer_N = mkN "农民" ;
lin farmhand_N = mkN "农场工人" | mkN "雇农" ; -- status=guess -- status=guess
lin farmhouse_N = mkN "农舍" ; -- open-multilingual-wordnet
lin farming_N = mkN "农业" ;
lin farmland_N = mkN "農田" | mkN "农田" | mkN "田地" ; -- status=guess -- status=guess -- status=guess
lin farmplace_N = mkN "农庄" ; -- open-multilingual-wordnet
lin farmstead_N = mkN "农庄" ;
lin farmyard_N = mkN "农业场地" | mkN "农场场地" | mkN "农家庭院" | mkN "场院" ; -- open-multilingual-wordnet
lin farnham_PN = foreignPN "Farnham" ; -- comment=src=geonames status=guess
lin farnworth_PN = foreignPN "Farnworth" ; -- comment=src=geonames status=guess
lin farrow_N = mkN "下小猪" ; -- open-multilingual-wordnet
lin far_sighted_A = mkA "能看到远处" | mkA "能看得很远" | mkA "远视" | mkA "远视眼" ; -- open-multilingual-wordnet
lin fart_N = mkN "屁" | mkN "放屁" ; -- status=guess -- status=guess
lin fart_V = mkV "放屁" ; -- status=guess, src=wikt
lin farther_Adv = mkAdv "更远" ;
lin farthing_N = mkN "法寻" | mkN "法新" ; -- ? | mkN "英国旧时铜币，相当于四分之一便士" ; -- open-multilingual-wordnet
lin farthingale_N = mkN "裙环" | mkN "鲸骨衬箍" ; -- open-multilingual-wordnet
lin fascia_N = mkN "仪表板" | mkN "仪表盘" | mkN "汽车仪表" ; -- open-multilingual-wordnet
lin fasciculation_N = mkN "肌束颤搐" ; -- open-multilingual-wordnet
lin fascinate_V2 = mkV2 "吸引" ;
lin fascinating_A = mkA "有趣" | {-HSK-} mkA "迷人" ;
lin fascination_N = mkN "魅力" ;
lin fascioliasis_N = mkN "片吸虫病" ; -- open-multilingual-wordnet
lin fasciolopsiasis_N = mkN "姜片虫病" ; -- open-multilingual-wordnet
lin fascism_N = mkN "法西斯主义" ;
lin fascist_A = mkA "法西斯主义" ;
lin fascist_N = mkN "法西斯" ;
lin fashion_N = mkN "时尚" ;
lin fashion_V2 = mkV2 "塑造" ;
lin fashionable_A = mkA "时髦" | {-HSK-} mkA "流行" ;
lin fast_A = mkA "快" | {-HSK-} mkA "迅速" ;
lin fast_N = mkN "快" | {-HSK-} mkN "迅速" ;
lin fast_V = mkV "禁食" ;
lin fastball_N = mkN "快球" ;
lin fasten_V = mkV "扎牢" ;
lin fasten_V2 = mkV2 (mkV "系住") | mkV2 (mkV "扣住") | mkV2 (mkV "閂上") | mkV2 (mkV "闩上") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin fastener_N = mkN "紧固件" ;
lin fastidious_A = mkA "难取悦" ;
lin fat_A = mkA "肥" | {-HSK-} mkA "胖" ;
lin fat_N = L.fat_N | {-HSK-} mkN "胖" ;
lin fatal_A = mkA "致命" ;
lin fatalistFem_N = variants {} ; ---- sense to be split
lin fatalistMasc_N = variants {} ; ---- sense to be split
lin fatalist_A = mkA "宿命论" | mkA "宿命论者" ; -- open-multilingual-wordnet
lin fatalistic_A = mkA "宿命论" | mkA "宿命论者" ; -- open-multilingual-wordnet
lin fatality_N = mkN "病死率" ;
lin fate_N = mkN "命运" | {-HSK-} mkN "命运" "個" ;
lin father_N = mkN "父亲" | {-HSK-} mkN "父亲" "個" | mkN "爷爷" "個" | mkN "爸爸" "個" ;
lin father_N2 = L.father_N2 ;
lin father_V2 = mkV2 "使+成为父亲" ;
lin father_in_law_N = mkN "岳父" ;
lin fatherland_N = mkN "祖国" ;
lin fathom_N = mkN "一臂长" | {-mwn-} mkN "英寸" ; -- status=guess -- open-multilingual-wordnet
lin fatigue_N = mkN "疲劳" | {-HSK-} mkN "疲勞" | mkN "倦怠" | mkN "乏力" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin fatigue_V2 = mkV2 (mkV "疲勞") | mkV2 (mkV "疲勞") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin fatso_N = mkN "胖子" | mkN "肥仔" ; -- status=guess -- status=guess
lin fatten_V = mkV "养肥" ;
lin fatten_V2 = mkV2 "养肥" ;
lin fatuous_A = mkA "愚笨" ;
lin fatwa_N = mkN "法特瓦" ; -- status=guess
lin faucal_A = mkA "咽喉" | mkA "咽门" ; -- open-multilingual-wordnet
lin faucet_N = mkN "龙头" ; -- open-multilingual-wordnet
lin fauld_N = mkN "腹甲" ; -- open-multilingual-wordnet
lin fauldhouse_PN = foreignPN "Fauldhouse" ; -- comment=src=geonames status=guess
lin fault_N = mkN "故障" | {-HSK-} mkN "毛病" "個" | mkN "短" | mkN "缺点" "個" | mkN "错" "個" ;
lin fault_V2 = mkV2 "挑剔" ;
lin faultless_A = mkA "完美" ;
lin faulty_A = mkA "有错误" ;
lin fauna_N = mkN "動物誌" | mkN "动物志" ; -- status=guess -- status=guess
lin fauteuil_N = mkN "太师椅" | mkN "安乐椅" | mkN "扶手椅" ; -- open-multilingual-wordnet
lin fauvism_N = mkN "野獸派" | mkN "野兽派" ; -- status=guess -- status=guess
lin faux_pas_N = mkN "出丑" | mkN "失态" | mkN "失礼" ; -- open-multilingual-wordnet
lin faversham_PN = foreignPN "Faversham" ; -- comment=src=geonames status=guess
lin favism_N = mkN "蚕豆病" | mkN "豆类中毒" ; -- open-multilingual-wordnet
lin favour_N = mkN "赞成" | mkN "恩惠" | mkN "好意" | mkN "幫忙" | mkN "帮忙" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin favour_V = mkV "支持" ; -- comment=mkV2 "青睐" ;
lin favour_V2 = mkV2 "青睐" | mkV2 "促成" ;
lin favour_VS = mkVS "赞成" ;
lin favourable_A = mkA "有利" | mkA "优惠" | mkA "良好" ;
lin favouriteFem_N = mkN "最爱" [] ;
lin favouriteMasc_N = mkN "最爱" [] ;
lin favourite_A = mkA "特别喜爱" | mkA "最喜愛" | mkA "最喜爱" ; -- status=guess -- status=guess
lin favouritism_N = mkN "偏爱" | mkN "偏袒" | mkN "徇私" | mkN "歧视" ; -- open-multilingual-wordnet
lin favus_N = mkN "头部鳞癣" | mkN "毛囊癣" | mkN "瘌痢" | mkN "黄癣" ; -- open-multilingual-wordnet
lin fawley_PN = foreignPN "Fawley" ; -- comment=src=eng status=guess
lin fawn_N = mkN "淡黃褐色" | mkN "淡黄褐色" ; -- status=guess -- status=guess
lin fawn_V = mkV "奉承" ;
lin fax_N = {-HSK-} mkN "传真" ;
lin fbi_PN = foreignPN "FBI" ; -- comment=src=eng status=guess
lin fear_N = mkN "恐怕" | {-HSK-} mkN "恐惧" ;
lin fear_V = mkV "恐惧" ;
lin fear_V2 = L.fear_V2 ;
lin fear_VS = L.fear_VS ;
lin fearful_A = mkA "可怕" ;
lin fearless_A = mkA "无畏" ;
lin fearsome_A = mkA "可怕" ;
lin feasibility_N = mkN "可行性" ;
lin feasible_A = mkA "可行" ;
lin feast_N = mkN "宴会" "席" | {-HSK-} mkN "盛宴" ;
lin feast_V = mkV "盛宴" ;
lin feast_V2 = mkV2 "使+款待" ;
lin feat_N = mkN "功绩" ;
lin feather_N = L.feather_N | {-HSK-} mkN "毛" ;
lin featherbed_N = mkN "羽毛褥垫" ; -- open-multilingual-wordnet
lin featherbedding_N = mkN "强迫雇用" | mkN "额外雇工" ; -- open-multilingual-wordnet
lin featheredge_N = mkN "薄缘" ; -- open-multilingual-wordnet
lin featherstone_PN = foreignPN "Featherstone" ; -- comment=src=geonames status=guess
lin feature_N = mkN "特征" | {-HSK-} mkN "特点" "個" ;
lin feature_V2 = mkV2 "放映" ;
lin featureless_A = mkA "无特色" ;
lin feb_PN = foreignPN "Feb" ; -- comment=src=eng status=guess
lin febrile_A = mkA "发烧" | mkA "发热" | mkA "有热病症状" ; -- open-multilingual-wordnet
lin feckless_A = mkA "软弱" ;
lin fecula_N = mkN "虫粪" ; -- open-multilingual-wordnet
lin feculent_A = mkA "充满污物" | mkA "充满渣滓" ; -- open-multilingual-wordnet
lin fecundity_N = mkN "繁殖力" | mkN "生殖力" | mkN "生育力" ; -- status=guess -- status=guess -- status=guess
lin fed_N = mkN "喂" ;
lin federal_A = mkA "联邦" ;
lin federalization_N = mkN "同盟化" | mkN "联邦化" ; -- open-multilingual-wordnet
lin federate_A = mkA "同盟" | mkA "联合" | mkA "联邦制度下" ; -- open-multilingual-wordnet
lin federate_V = mkV "使成同盟" | mkV "使成联邦" ; -- open-multilingual-wordnet
lin federation_N = mkN "联盟" ;
lin fee_N = mkN "费用" ;
lin feeble_A = mkA "弱" | {-HSK-} mkA "微弱" ; -- comment="无力" ;
lin feed_N = mkN "饲料" ;
lin feed_V = mkV "喂" ;
lin feed_V2 = mkV2 "喂养" ;
lin feed_off_V2 = prepV2 OP_feed_V OP_off_Prep ; -- guess-p-verb
lin feed_on_V2 = prepV2 OP_feed_V OP_on_Prep ; -- guess-p-verb
lin feed_up_V2 = prepV2 OP_feed_V OP_up_Prep ; -- guess-p-verb
lin feedback_N = mkN "反馈" ;
lin feedlot_N = mkN "肥育地" | mkN "饲育场" ; -- open-multilingual-wordnet
lin feel_N = mkN "感觉" ;
lin feel_V = mkV "感觉" | {-HSK-} mkV "摸" | mkV "觉得" | mkV "认为" ;
lin feel_V2 = mkV2 "感觉" | {-HSK-} mkV2 "摸" | mkV2 "觉得" | mkV2 "认为" ;
lin feel_VA = mkVA "感觉" | {-HSK-} mkVA "摸" | mkVA "觉得" | mkVA "认为" ;
lin feel_VS = mkVS "感觉" | {-HSK-} mkVS "摸" | mkVS "觉得" | mkVS "认为" ;
lin feel_out_V = advV OP_feel_V OP_out_Adv ; -- guess-p-verb
lin feel_up_V2 = prepV2 OP_feel_V OP_up_Prep ; -- guess-p-verb
lin feel_up_to_V2 = prepV2 (advV OP_feel_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin feeler_N = mkN "触角" ;
lin feeling_N = mkN "情绪" "種" | mkN "感情" "個" | mkN "感觉" "個" | {-HSK-} mkN "感觉" ;
lin feign_V2 = mkV2 "假装" | mkV2 "做" | {-HSK-} mkV2 (mkV "假裝") | mkV2 (mkV "假装") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin feijoa_N = mkN "費約果" | mkN "费约果" ; -- status=guess -- status=guess
lin feist_N = mkN "一种杂种小狗" | mkN "小犬" | mkN "小狗" ; -- open-multilingual-wordnet
lin feldspar_N = mkN "长石" ; -- open-multilingual-wordnet
lin felicity_PN = foreignPN "Felicity" ; -- comment=src=eng status=guess
lin feline_A = mkA "猫一样" ;
lin feline_N = mkN "猫科动物" | mkN "猫科的动物" ; -- open-multilingual-wordnet
lin felix_PN = foreignPN "Felix" ; -- comment=src=eng status=guess
lin felixstowe_PN = mkPN "费利克斯托" ; -- comment=src=geonames status=guess
lin fell_A = mkA "凶猛" ;
lin fell_V2 = mkV2 "掉下" ;
lin fellatio_N = mkN "口交" | mkN "口淫" ; -- status=guess -- status=guess
lin felloe_N = mkN "外轮" | mkN "轮缘" | mkN "轮辋" | mkN "辋" ; -- open-multilingual-wordnet
lin fellow_A = variants {} ;
lin fellow_N = mkN "同伴" ;
lin fellowship_N = mkN "友谊" ;
lin felon_N = mkN "罪" ;
lin felony_N = mkN "重罪" ;
lin felspar_N = mkN "长石" ; -- open-multilingual-wordnet
lin felt_N = mkN "毛氈" | mkN "毛毡" | {-mwn-} mkN "毡" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin felted_A = mkA "毡制" | mkA "黏结起来" ; -- open-multilingual-wordnet
lin felucca_N = mkN "三桅小帆船" ; -- open-multilingual-wordnet
lin fem_PN = foreignPN "Fem" ; -- comment=src=eng status=guess
lin female_A = mkA "女性" ;
lin female_N = mkN "女性" ;
lin feminine_A = mkA "女性" | {-HSK-} mkA "阴" ;
lin feminine_N = mkN "阴" | {-HSK-} mkN "阴性" ; -- status=guess
lin femininity_N = mkN "温柔" [] ;
lin feminism_N = mkN "女权主义" "种" ;
lin feministFem_N = mkN "女权主义者" "位" ;
lin feministMasc_N = mkN "女权主义者" "位" ;
lin feminist_A = mkA "女权主义者" ;
lin feminization_N = mkN "女性化" | mkN "阴性化" | mkN "雌性化" ; -- open-multilingual-wordnet
lin femtometer_N = mkN "毫微微米" | mkN "非姆托米" ; -- open-multilingual-wordnet
lin femtosecond_N = mkN "飞秒" ; -- open-multilingual-wordnet
lin femtovolt_N = mkN "毫微微伏" | mkN "飞姆托伏" ; -- open-multilingual-wordnet
lin femur_N = mkN "股骨" ; -- status=guess
lin fen_N = mkN "沼泽" | mkN "沼泽地" | mkN "沼泽地方" | mkN "湿地" ; -- open-multilingual-wordnet
lin fence_N = mkN "栅栏" ;
lin fencing_N = mkN "围墙" ;
lin fend_V = mkV "挡开" ;
lin fend_off_V2 = mkV2 "挡开" ;
lin fender_N = mkN "挡泥板" ;
lin fenestral_A = mkA "如窗" | mkA "窗孔" ; -- open-multilingual-wordnet
lin fennel_N = mkN "茴香" ;
lin fenugreek_N = mkN "胡蘆巴" | mkN "胡芦巴" ; -- status=guess -- status=guess
lin feoff_N = mkN "封地" | mkN "采邑" | mkN "领地" ; -- open-multilingual-wordnet
lin feral_A = mkA "野生" | {-mwn-} mkA "凶猛" | mkA "野生" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin fergusonite_N = mkN "褐钇铌矿" ; -- open-multilingual-wordnet
lin ferial_A = mkA "假日" ; -- open-multilingual-wordnet
lin fermanagh_PN = foreignPN "Fermanagh" ; -- comment=src=eng status=guess
lin ferment_N = mkN "发酵" | mkN "发酵作用" ; -- open-multilingual-wordnet
lin fermentable_A = mkA "发酵性" | mkA "可发酵" ; -- open-multilingual-wordnet
lin fermentation_N = mkN "发酵" | mkN "发酵作用" ; -- open-multilingual-wordnet
lin fermium_N = mkN "鐨" | mkN "镄" ; -- status=guess -- status=guess
lin fern_N = mkN "蕨類" | mkN "蕨类" ; -- status=guess -- status=guess
lin ferocious_A = mkA "凶猛" | {-HSK-} mkA "厉害" ;
lin ferrara_PN = foreignPN "Ferrara" ; -- comment=src=geonames status=guess
lin ferret_N = mkN "雪貂" | {-mwn-} mkN "白鼬" ; -- status=guess -- open-multilingual-wordnet
lin ferret_V = mkV "搜出" ;
lin ferric_A = mkA "含铁" | mkA "铁" ; -- open-multilingual-wordnet
lin ferricyanide_N = mkN "铁氰化物" ; -- open-multilingual-wordnet
lin ferrite_N = mkN "铁素体" | mkN "铁酸盐" ; -- open-multilingual-wordnet
lin ferritin_N = mkN "铁朊" | mkN "铁蛋白" ; -- open-multilingual-wordnet
lin ferrocerium_N = mkN "铈铁" ; -- open-multilingual-wordnet
lin ferroconcrete_N = mkN "钢筋混凝土" | mkN "钢骨水泥" ; -- open-multilingual-wordnet
lin ferrocyanide_N = mkN "亚铁氰化物" | mkN "氰亚铁酸盐" ; -- open-multilingual-wordnet
lin ferromagnetic_A = mkA "铁磁" ; -- open-multilingual-wordnet
lin ferrous_A = mkA "含铁" | mkA "铁" ; -- open-multilingual-wordnet
lin ferrule_N = mkN "金属包头" | mkN "金属箍" ; -- open-multilingual-wordnet
lin ferry_N = mkN "渡船" "艘" ;
lin ferry_V = mkV "摆渡" | mkV "渡过" ; -- open-multilingual-wordnet
lin ferry_V2 = mkV2 "摆渡" ;
lin ferryhill_PN = foreignPN "Ferryhill" ; -- comment=src=geonames status=guess
lin fertile_A = mkA "肥沃" ;
lin fertility_N = mkN "生育" ;
lin fertilization_N = mkN "施肥" ;
lin fertilize_V2 = mkV2 "施肥" ;
lin fertilizer_N = mkN "化肥" ;
lin ferule_N = mkN "戒尺" | mkN "教鞭" ; -- open-multilingual-wordnet
lin fervent_A = mkA "热" | {-HSK-} mkA "热切" ;
lin fervour_N = mkN "兴奋" | mkN "刺激" | mkN "激动" | mkN "激情" | mkN "热情" ; -- open-multilingual-wordnet
lin fesse_N = mkN "中带" ; -- open-multilingual-wordnet
lin fester_N = mkN "产生脓" | mkN "化脓" | mkN "脓疮" | mkN "轻微溃疡" ; -- open-multilingual-wordnet
lin fester_V = mkV "溃烂" ;
lin festination_N = mkN "慌张步伐" | mkN "慌张步态" ; -- open-multilingual-wordnet
lin festival_N = mkN "节" | mkN "节日" "個" | {-HSK-} mkN "节日" ;
lin festive_A = mkA "节日" ;
lin festivity_N = mkN "欢庆" ;
lin festoon_V2 = mkV2 "结花彩于" ;
lin fetal_A = mkA "胎儿" ;
lin fetch_V2 = mkV2 "取" ;
lin fetching_A = mkA "迷人" ;
lin fetish_N = mkN "物神" ;
lin fetishism_N = mkN "拜物教" | mkN "拜物主義" | mkN "拜物主义" ; -- status=guess -- status=guess -- status=guess
lin fetoprotein_N = mkN "胎蛋白" ; -- open-multilingual-wordnet
lin fetoscope_N = mkN "胎儿镜" ; -- open-multilingual-wordnet
lin fetter_N = mkN "鐐" | mkN "镣" | {-mwn-} mkN "脚镣" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin fetter_V2 = mkV2 (mkV "束縛") | mkV2 (mkV "束缚") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin fettle_N = mkN "健康" ; -- open-multilingual-wordnet
lin fetus_N = mkN "胎兒" | mkN "胎儿" | mkN "胎" ; -- status=guess -- status=guess -- status=guess
lin feud_N = mkN "不和" ;
lin feudal_A = mkA "封建制度" ;
lin feudalism_N = mkN "封建" ; -- status=guess
lin feude_V = mkV "争执" ;
lin fever_N = mkN "发烧" ;
lin feverish_A = mkA "发烧" | mkA "发热" | mkA "有热病症状" ; -- open-multilingual-wordnet
lin few_A = mkA "些" | mkA "小" | mkA "少" | {-HSK-} mkA "很少" ;
lin few_Det = S.few_Det | {-HSK-} mkpDet "些" | mkpDet "小" | mkpDet "少" ;
lin few_N = mkN "些" | mkN "小" | mkN "少" | {-HSK-} mkN "很少数" ;
lin few_Num = mkNum "少数" ;
lin fewer_Det = variants {} ;
lin fewer_than_AdN = mkAdN "比少" ;
lin fez_N = mkN "土耳其帽" | mkN "土耳其毯帽" | mkN "塔布什帽" ; -- open-multilingual-wordnet
lin fiasco_N = mkN "惨败" ;
lin fiat_N = mkN "命令" ;
lin fib_N = mkN "谎言" | mkN "谎话" ; -- open-multilingual-wordnet
lin fiberboard_N = mkN "纤维板" ; -- open-multilingual-wordnet
lin fiberglass_N = mkN "玻璃丝" | mkN "玻璃纤维" ; -- open-multilingual-wordnet
lin fiberscope_N = mkN "纤维镜" ; -- open-multilingual-wordnet
lin fibre_N = mkN "纤维" ;
lin fibreboard_N = mkN "纤维板" ; -- open-multilingual-wordnet
lin fibreglass_N = mkN "玻璃丝" | mkN "玻璃纤维" ; -- open-multilingual-wordnet
lin fibril_N = mkN "原纤维" | mkN "小纤维" ; -- open-multilingual-wordnet
lin fibrillation_N = mkN "原纤维形成" ; -- open-multilingual-wordnet
lin fibrillose_A = mkA "有原纤维" | mkA "由原纤维组成" ; -- open-multilingual-wordnet
lin fibrin_N = mkN "纤维素" | mkN "纤维蛋白" | mkN "血纤蛋白" ; -- open-multilingual-wordnet
lin fibrinogen_N = mkN "纤维蛋白素原" ; -- open-multilingual-wordnet
lin fibrinolysis_N = mkN "纤维蛋白溶解" ; -- open-multilingual-wordnet
lin fibrinopeptide_N = mkN "血纤维蛋白肽" ; -- open-multilingual-wordnet
lin fibrinous_A = mkA "含血纤维蛋白" | mkA "有纤维素" ; -- open-multilingual-wordnet
lin fibroadenoma_N = mkN "纤维腺瘤" ; -- open-multilingual-wordnet
lin fibrocartilaginous_A = mkA "纤维软骨" ; -- open-multilingual-wordnet
lin fibroma_N = mkN "纤维瘤" ; -- open-multilingual-wordnet
lin fibromyositis_N = mkN "纤维肌炎" ; -- open-multilingual-wordnet
lin fibrosis_N = mkN "纤维症" ; -- open-multilingual-wordnet
lin fibrositis_N = mkN "纤维组织炎" ; -- open-multilingual-wordnet
lin fibrous_A = mkA "嚼不动" | mkA "纤维" | mkA "纤维性" ; -- open-multilingual-wordnet
lin fichu_N = mkN "三角形披肩" ; -- open-multilingual-wordnet
lin fickle_A = mkA "浮躁" ;
lin fickleness_N = mkN "浮躁" ;
lin fiction_N = mkN "小说" | {-HSK-} mkN "小说" "本" ;
lin fictional_A = mkA "虚构" ;
lin fictitious_A = mkA "虚构" ;
lin fiddle_N = mkN "小提琴" ;
lin fiddle_V2 = mkV2 (mkV "摸索") ; -- status=guess, src=wikt
lin fiddlestick_N = mkN "拉提琴的弓" ; -- open-multilingual-wordnet
lin fidget_V = mkV "坐立不安" ;
lin fiducial_A = mkA "基准" ; -- open-multilingual-wordnet
lin fiduciary_A = mkA "信托" | mkA "受信托" ; -- open-multilingual-wordnet
lin fief_N = mkN "封地" | mkN "采邑" | mkN "领地" ; -- open-multilingual-wordnet
lin fiefdom_N = mkN "埰邑" | mkN "采邑" ; -- status=guess -- status=guess
lin field_1_N = mkN "领域" ;
lin field_2_N = mkN "领域" ;
lin field_3_N = mkN "领域" ;
lin field_4_N = mkN "领域" ;
lin field_N = mkN "领域" ;
lin field_V = mkV "上场" ;
lin field_V2 = mkV2 "使+上场" ;
lin fieldstone_N = mkN "大卵石" | mkN "散石" | mkN "毛石" | mkN "粗石" ; -- open-multilingual-wordnet
lin fieldwork_N = mkN "野战工事" ; -- open-multilingual-wordnet
lin fiend_N = mkN "迷" | mkN "迷" ; -- status=guess -- status=guess
lin fiendish_A = mkA "惡魔似" | mkA "恶魔似" ; -- status=guess -- status=guess
lin fierce_A = mkA "激烈" ;
lin fiery_A = mkA "火热" ;
lin fife_N = mkN "橫笛" | mkN "横笛" | mkN "龠" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin fife_PN = foreignPN "Fife" ; -- comment=src=geonames status=guess
lin fig_N = variants {} ;
lin fight_N = mkN "打" ;
lin fight_V = mkV "打" | {-HSK-} mkV "杀" ;
lin fight_V2 = L.fight_V2 | {-HSK-} mkV2 "杀" ;
lin fight_back_V = advV OP_fight_V OP_back_Adv ; -- guess-p-verb
lin fight_back_V2 = mkV2 (advV OP_fight_V OP_back_Adv ) ; -- guess-p-verb
lin fight_it_out_V2 = variants {} ; -- guess-p-verb
lin fight_off_V2 = prepV2 OP_fight_V OP_off_Prep ; -- guess-p-verb
lin fighter_N = mkN "战斗机" ;
lin fighting_N = mkN "奋斗""次" ;
lin figural_A = mkA "形象" ; -- open-multilingual-wordnet
lin figurative_A = mkA "比喻" ;
lin figure_1_N = mkN "数字" ; -- comment=NOT SURE "数字" or "图像" or "人物"
lin figure_2_N = mkN "数字" ; -- comment=NOT SURE "数字" or "图像" or "人物"
lin figure_N = mkN "数字" ; -- comment=NOT SURE "数字" or "图像" or "人物"
lin figure_V = mkV "弄清楚" | {-HSK-} mkV "算" ;
lin figure_VS = mkVS "盘算" | {-HSK-} mkVS "算" ;
lin figure_on_V2 = prepV2 OP_figure_V OP_on_Prep ; -- guess-p-verb
lin figure_out_V2 = prepV2 OP_figure_V OP_out_Prep ; -- guess-p-verb
lin figure_up_V2 = prepV2 OP_figure_V OP_up_Prep ; -- guess-p-verb
lin figurine_N = mkN "小塑像" | mkN "人形" | {-mwn-} mkN "塑像" | mkN "小铸像" | mkN "小雕像" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin figwort_N = mkN "元参" | mkN "咸" | mkN "山当归" | mkN "正马" | mkN "水萝卜" | mkN "玄参" | mkN "玄台" | mkN "端" | mkN "逐马" | mkN "重台" | mkN "野脂麻" | mkN "馥草" | mkN "鬼藏" | mkN "鹿肠" | mkN "黑参" ; -- open-multilingual-wordnet
lin fiji_PN = mkPN "斐濟" ; -- comment=src=geonames status=guess
lin filament_N = mkN "纖維" | mkN "纤维" | {-mwn-} mkN "灯丝" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin filamentous_A = mkA "丝状" | mkA "细丝状" ; -- open-multilingual-wordnet
lin filar_A = mkA "丝" | mkA "丝状" | mkA "线" ; -- open-multilingual-wordnet
lin filarial_A = mkA "丝虫" ; -- open-multilingual-wordnet
lin filariasis_N = mkN "丝虫病" ; -- open-multilingual-wordnet
lin filariid_A = mkA "丝虫" | mkA "丝虫引起" | mkA "血丝虫" ; -- open-multilingual-wordnet
lin filature_N = mkN "卷丝轴" ; -- open-multilingual-wordnet
lin filbert_N = mkN "榛子" ;
lin filch_V2 = mkV2 "窃" ;
lin file_N = mkN "文件" | {-HSK-} mkN "文件" "份" ;
lin file_V = mkV "归档" ;
lin file_V2 = mkV2 "归档" ;
lin file_away_V2 = mkV2 (advV OP_file_V OP_away_Adv ) ; -- guess-p-verb
lin file_for_V2 = prepV2 OP_file_V OP_for_Prep ; -- guess-p-verb
lin filefish_N = mkN "豚鱼" | mkN "魨" ; -- open-multilingual-wordnet
lin filename_N = mkN "文件名" ; -- status=guess
lin filet_N = mkN "方格网" | mkN "方眼花边网" | mkN "网格状花边" ; -- open-multilingual-wordnet
lin filial_A = mkA "孝顺" ;
lin filibuster_N = mkN "阻挠行动" ;
lin filibuster_V = mkV "阻挠议事进程" | mkV "阻碍议案通过" ; -- open-multilingual-wordnet
lin filigree_N = mkN "细丝工艺" | mkN "细线细工" | mkN "金银丝细工" ; -- open-multilingual-wordnet
lin filing_N = mkN "檔案櫃" | mkN "档案柜" ; -- status=guess -- status=guess
lin filipino_A = mkA "菲律宾" ;
lin filipino_N = mkN "菲律宾人" ;
lin fill_N = mkN "装填物" ;
lin fill_V = mkV "充满" | {-HSK-} mkV "满" ;
lin fill_V2 = mkV2 "填充" | {-HSK-} mkV2 "满" ;
lin fill_in_V = advV OP_fill_V OP_in_Adv ; -- guess-p-verb
lin fill_in_V2 = prepV2 OP_fill_V OP_in_Prep ; -- guess-p-verb
lin fill_in_for_V2 = prepV2 (advV OP_fill_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin fill_in_on_V3 = variants {} ; -- guess-p-verb
lin fill_out_V = advV OP_fill_V OP_out_Adv ; -- guess-p-verb
lin fill_out_V2 = prepV2 OP_fill_V OP_out_Prep ; -- guess-p-verb
lin fill_up_V2 = prepV2 OP_fill_V OP_up_Prep ; -- guess-p-verb
lin filling_N = mkN "填充物" ;
lin filly_N = mkN "小雌马" ;
lin film_1_N = variants {} ;
lin film_2_N = {-mwn-} mkN "薄层" ; -- open-multilingual-wordnet
lin film_N = mkN "电影" ;
lin film_V = mkV "贴膜" ;
lin film_V2 = mkV2 "拍摄" ;
lin filmmaking_N = mkN "電影製作" | mkN "电影制作" ; -- status=guess -- status=guess
lin fils_N = mkN "菲尔斯" ; -- open-multilingual-wordnet
lin filter_N = mkN "滤波器" ;
lin filter_V = mkV "滤过" ;
lin filter_V2 = mkV2 "过滤" ;
lin filth_N = mkN "污垢" ;
lin filthy_A = mkA "肮脏" ;
lin filtration_N = mkN "过滤" ;
lin fimbriate_A = mkA "有毛缘" ; -- open-multilingual-wordnet
lin fin_N = mkN "鱼鳍""" ;
lin finagle_V2 = mkV2 "哄骗" ;
lin final_A = mkA "最后" | {-HSK-} mkA "最终" ;
lin final_N = mkN "决赛" | {-HSK-} mkN "最后" ;
lin finale_N = mkN "结尾" ; -- status=guess
lin finalist_N = mkN "入围" "" ;
lin finalize_V2 = mkV2 "敲定" ;
lin finally_Adv = {-HSK-} mkAdv "到底" | mkAdv "总算" | mkAdv "最后" | mkAdv "终于" | adjAdv final_A ; -- derived
lin finance_N = mkN "金融" ;
lin finance_V2 = mkV2 "资助" ;
lin financial_A = mkA "金融" ;
lin financier_N = mkN "金融家" ;
lin finch_N = mkN "燕雀" | mkN "雀" ; -- status=guess -- status=guess
lin find_N = mkN "发现" ;
lin find_V = mkV "发现" | mkV "找" | {-HSK-} mkV "寻找" ;
lin find_V2 = L.find_V2 | {-HSK-} mkV2 "发现" | mkV2 "找" ;
lin find_V2A = mkV2A "发现" ;
lin find_VS = mkVS "发现" | {-HSK-} mkVS "找" ;
lin find_out_V = mkV "了解" ;
lin find_out_V2 = mkV2 "了解" ;
lin finder_N = mkN "发现者" ;
lin finding_N = mkN "发现物" ;
lin fine_A = mkA "优美" | mkA "晴" | mkA "罚款" | mkA "良好" | {-HSK-} mkA "精细" ;
lin fine_Adv = mkAdv "优美" | mkAdv "晴" | mkAdv "罚款" | mkAdv "良好" | {-HSK-} mkAdv "好地 " ;
lin fine_N = mkN "优美" | mkN "晴" | mkN "罚款" | mkN "良好" ;
lin fine_V2 = mkV2 "罚款" ;
lin finery_N = mkN "服饰" ;
lin finesse_V2 = mkV2 "用计谋处理" ;
lin finger_N = mkN "手指" | {-HSK-} mkN "手指" "個" | mkN "指" ;
lin finger_V2 = mkV2 "用手指拨弄" ;
lin fingerboard_N = mkN "指板" ; -- open-multilingual-wordnet
lin fingering_N = mkN "指法" ; -- status=guess
lin fingerless_A = mkA "無指" | mkA "无指" ; -- status=guess -- status=guess
lin fingerling_N = mkN "小鱼" | mkN "幼鱼" | mkN "鱼苗" ; -- open-multilingual-wordnet
lin fingernail_N = L.fingernail_N ;
lin fingerprint_N = mkN "指纹" ;
lin fingerstall_N = mkN "护指套" | mkN "护指罩" ; -- open-multilingual-wordnet
lin finial_N = mkN "尖顶饰" ; -- open-multilingual-wordnet
lin finical_A = mkA "挑剔" | mkA "爱挑剔" | mkA "过分周到" | mkA "过分注意" | mkA "过分讲究" ; -- open-multilingual-wordnet
lin finicky_A = mkA "挑剔" | mkA "爱挑剔" | mkA "过分周到" | mkA "过分注意" | mkA "过分讲究" ; -- open-multilingual-wordnet
lin finish_N = mkN "结束" [] ;
lin finish_V = mkV "完" | mkV "结束" | {-HSK-} mkV "完成" ;
lin finish_V2 = mkV2 "完" | mkV2 "结束" ;
lin finish_off_V2 = prepV2 OP_finish_V OP_off_Prep ; -- guess-p-verb
lin finish_up_V = mkV "最终成为" | mkV "结果成为" ; -- open-multilingual-wordnet
lin finish_up_with_V2 = prepV2 (advV OP_finish_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin finish_with_V2 = prepV2 OP_finish_V OP_with_Prep ; -- guess-p-verb
lin finished_A = variants {} ;
lin finite_A = mkA "有限" ;
lin finland_PN = mkPN "芬兰" ;
lin finnishFem_N = variants {} ;
lin finnishMasc_N = variants {} ;
lin finnish_A = mkA "芬兰语" ;
lin fiona_PN = foreignPN "Fiona" ; -- comment=src=eng status=guess
lin fipple_N = mkN "音栓" ; -- open-multilingual-wordnet
lin fir_N = mkN "冷杉" ; -- status=guess
lin fire_1_N = L.fire_N ;
lin fire_2_N = L.fire_N ;
lin fire_N = variants {} ;
lin fire_V = mkV "射击" | {-HSK-} mkV "开火" ;
lin fire_V2 = mkV2 "射击" | {-HSK-} mkV2 "燃烧" ;
lin fire_away_V = advV OP_fire_V OP_away_Adv ; -- guess-p-verb
lin fire_back_V = advV OP_fire_V OP_back_Adv ; -- guess-p-verb
lin fire_off_V2 = prepV2 OP_fire_V OP_off_Prep ; -- guess-p-verb
lin fire_up_V = advV OP_fire_V OP_up_Adv ; -- guess-p-verb
lin fire_up_V2 = prepV2 OP_fire_V OP_up_Prep ; -- guess-p-verb
lin firearm_N = mkN "枪" "支" | {-HSK-} mkN "火器" | mkN "槍械" | mkN "枪械" | mkN "火槍" | mkN "火枪" | {-mwn-} mkN "火器" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin fireball_N = mkN "火球" ;
lin firebase_N = mkN "重火力点" ; -- open-multilingual-wordnet
lin fireboat_N = mkN "救火艇" | mkN "消防艇" ; -- open-multilingual-wordnet
lin firebomb_N = mkN "燃烧弹" ; -- open-multilingual-wordnet
lin firebox_N = mkN "火室" | mkN "燃烧室" ; -- open-multilingual-wordnet
lin firebrick_N = mkN "耐火砖" ; -- open-multilingual-wordnet
lin firebug_N = mkN "萤火虫" ; -- open-multilingual-wordnet
lin fireclay_N = mkN "火泥" | mkN "耐火土" ; -- open-multilingual-wordnet
lin firecracker_N = mkN "爆竹" | mkN "鞭炮" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin firedamp_N = mkN "沼气" | mkN "矿井瓦斯" ; -- open-multilingual-wordnet
lin firedog_N = mkN "柴架" | mkN "薪架" ; -- open-multilingual-wordnet
lin firefly_N = mkN "螢火蟲" | mkN "萤火虫" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin fireguard_N = mkN "火炉栏" ; -- open-multilingual-wordnet
lin firelighter_N = mkN "引火物" ; -- open-multilingual-wordnet
lin fireman_N = mkN "消防队员" "位" ;
lin firenze_PN = foreignPN "Firenze" ; -- comment=src=eng status=guess
lin fireplace_N = mkN "壁炉" ;
lin fireplug_N = mkN "消防栓" | mkN "消防龙头" | mkN "灭火塞" ; -- open-multilingual-wordnet
lin fire_power_N = mkN "火力" ; -- status=guess
lin fireside_N = mkN "家" | mkN "家庭" ; -- open-multilingual-wordnet
lin firewall_N = mkN "防火牆" | mkN "防火墙" ; -- status=guess -- status=guess
lin firewater_N = mkN "烈酒" ;
lin firewood_N = mkN "柴火" | mkN "木柴" ; -- status=guess -- status=guess
lin firework_N = mkN "焰火" ;
lin fireworks_N = mkN "花炮" | mkN "煙火" | mkN "烟火" ; -- status=guess -- status=guess -- status=guess
lin firing_N = mkN "行刑隊" | mkN "行刑队" ; -- status=guess -- status=guess
lin firkin_N = mkN "木制小桶" ; -- open-multilingual-wordnet
lin firm_A = mkA "企业" | mkA "公司" | mkA "公里" | mkA "坚决" | mkA "硬" | {-HSK-} mkA "坚定" ;
lin firm_Adv = mkAdv "企业" | mkAdv "公司" | mkAdv "公里" | mkAdv "坚决" | mkAdv "硬" ;
lin firm_N = mkN "企业" "家" | mkN "公司" "家" | mkN "公里" "家" | mkN "坚决" | mkN "硬" | {-HSK-} mkN "公司" ;
lin firm_V = mkV "公司" ;
lin firm_V2 = mkV2 "使+牢固" ;
lin firmamental_A = mkA "天空" | mkA "苍天" ; -- open-multilingual-wordnet
lin firmness_N = mkN "坚定" [] ;
lin firmware_N = mkN "固件" | mkN "韌體" | mkN "韧体" | mkN "塑體" | mkN "塑体" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin first_Adv = mkAdv "元" | mkAdv "先" | mkAdv "最初" | mkAdv "第一" | mkAdv "首先" | {-HSK-} mkAdv "最先" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin first_class_A = mkA "第一" ;
lin first_rate_A = mkA "一流" ;
lin first_hand_A = mkA "从来源处接收到" | mkA "直接" | mkA "直接得来" | mkA "第一手" ; -- open-multilingual-wordnet
lin firstly_Adv = variants {} ;
lin fisc_N = mkN "国库" ; -- open-multilingual-wordnet
lin fiscal_A = mkA "财务" ;
lin fish_N = L.fish_N ;
lin fish_V = mkV "捕鱼" ;
lin fish_V2 = mkV2 "鱼" ;
lin fishbone_N = mkN "鱼骨" ; -- open-multilingual-wordnet
lin fishbowl_N = mkN "玻璃鱼缸" | mkN "鱼缸" ; -- open-multilingual-wordnet
lin fisher_N = mkN "魚夫" | mkN "鱼夫" ; -- status=guess -- status=guess
lin fisherman_N = mkN "渔夫" "名" ;
lin fishery_N = mkN "渔业" [] ;
lin fisheye_A = mkA "宽角度" | mkA "超广角" ; -- open-multilingual-wordnet
lin fish_hook_N = mkN "魚鉤" | mkN "鱼钩" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin fishing_N = mkN "钓鱼" [] ;
lin fishmonger_N = mkN "魚商" | mkN "鱼商" ; -- status=guess -- status=guess
lin fishnet_N = mkN "渔网" ; -- open-multilingual-wordnet
lin fishplate_N = mkN "接合板" | mkN "鱼尾板" ; -- open-multilingual-wordnet
lin fishy_A = mkA "魚" | mkA "鱼" | mkA "腥" ; -- status=guess -- status=guess -- status=guess
lin fission_N = mkN "核分裂" | mkN "核裂变" ; -- open-multilingual-wordnet
lin fissure_N = mkN "裂隙" ;
lin fist_N = mkN "拳头" ;
lin fistfight_N = mkN "互殴" | mkN "拳击" ; -- status=guess -- status=guess
lin fistular_A = mkA "中空" | mkA "管状" ; -- open-multilingual-wordnet
lin fit_A = mkA "适合" ;
lin fit_N = mkN "适合" [] ;
lin fit_V = mkV "合适" | mkV "适合" | mkV "适应" | mkV "配合" ;
lin fit_V2 = mkV2 "合适" | mkV2 "适合" | mkV2 "适应" | mkV2 "配合" ;
lin fit_in_V = mkV "一致" | mkV "协调" | mkV "和谐" | mkV "相一致" | mkV "符合" ; -- open-multilingual-wordnet
lin fit_in_V2 = prepV2 OP_fit_V OP_in_Prep ; -- guess-p-verb
lin fit_in_with_V2 = prepV2 (advV OP_fit_V OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin fit_into_V2 = prepV2 OP_fit_V OP_into_Prep ; -- guess-p-verb
lin fit_out_V2 = prepV2 OP_fit_V OP_out_Prep ; -- guess-p-verb
lin fit_out_with_V2 = prepV2 (advV OP_fit_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin fit_up_V2 = prepV2 OP_fit_V OP_up_Prep ; -- guess-p-verb
lin fitment_N = mkN "家具" | mkN "用具" ; -- open-multilingual-wordnet
lin fitness_N = mkN "健身" [] ;
lin fitter_N = mkN "鉗工" | mkN "钳工" ; -- status=guess -- status=guess
lin fitting_A = mkA "合适" | {-HSK-} mkA "适合" ;
lin fitting_N = mkN "合适" | {-HSK-} mkN "装配" "" ;
lin fivefold_A = mkA "五倍" ;
lin fivepence_N = mkN "五便士" ; -- open-multilingual-wordnet
lin fiver_N = mkN "五美元钞票" ; -- open-multilingual-wordnet
lin fix_N = mkN "安装" | {-HSK-} mkN "方位" | mkN "困境" ;
lin fix_V = mkV "固定" | {-HSK-} mkV "弄" | mkV "确定" | mkV "装" | mkV "规定" ;
lin fix_V2 = mkV2 "修理" | {-HSK-} mkV2 "弄" | mkV2 "确定" | mkV2 "装" | mkV2 "规定" ;
lin fix_up_V2 = prepV2 OP_fix_V OP_up_Prep ; -- guess-p-verb
lin fixation_N = mkN "固定术" ;
lin fixative_N = mkN "固色剂" | mkN "定色剂" ; -- open-multilingual-wordnet
lin fixed_A = {-HSK-} mkA "一定" | mkA "固定" | mkA "确定" ;
lin fixer_N = mkN "定影劑" | mkN "定影剂" | mkN "固定劑" | mkN "固定剂" | {-mwn-} mkN "一种镇痛剂" | mkN "美沙酮" | mkN "镇痛剂" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin fixture_N = mkN "夹具" ;
lin fizzle_V = mkV "失败" ;
lin fizzle_out_V = mkV "半途而废" | mkV "逐渐停止" | mkV "逐渐枯竭" ; -- open-multilingual-wordnet
lin fizzy_A = mkA "嘶嘶" | mkA "泡沫腾涌" ; -- open-multilingual-wordnet
lin fjord_N = mkN "峽灣" | mkN "峡湾" ; -- status=guess -- status=guess
lin flabbergast_V2 = mkV2 "哑然失色" ;
lin flabbiness_N = mkN "软弱" ;
lin flag_N = mkN "旗" ;
lin flag_V = mkV "旗" ;
lin flag_V2 = mkV2 (mkV "用旗子標示") | mkV2 (mkV "用旗子标示") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin flagellate_A = mkA "有鞭毛" | mkA "鞭样" | mkA "鞭状" ; -- open-multilingual-wordnet
lin flageolet_N = mkN "六孔竖笛" ; -- open-multilingual-wordnet
lin flagitious_A = mkA "凶恶" | mkA "极恶" | mkA "残忍" | mkA "残暴" | mkA "罪大恶极" ; -- open-multilingual-wordnet
lin flagon_N = mkN "大肚壶" | mkN "酒壶" ; -- open-multilingual-wordnet
lin flagpole_N = mkN "旗竿" | mkN "旗杆" ; -- status=guess
lin flagrant_A = mkA "公然" ;
lin flagship_N = mkN "旗舰" ;
lin flail_N = mkN "連枷" | mkN "连枷" | mkN "枷" | mkN "耞" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin flair_N = mkN "风骚" ;
lin flak_N = mkN "防空兵器" | mkN "高射炮" ; -- open-multilingual-wordnet
lin flake_N = mkN "小片" | mkN "薄片" | {-HSK-} mkN "片" | {-mwn-} mkN "断片" | mkN "碎片" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin flake_V = mkV "剝落" | mkV "剥落" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin flaky_A = mkA "薄片" ;
lin flambeau_N = mkN "火把" ; -- open-multilingual-wordnet
lin flamboyant_A = mkA "艳丽" ;
lin flame_N = mkN "火焰" "束" ;
lin flame_V = mkV "焚烧" ;
lin flamenco_N = mkN "佛拉明柯舞曲" ; -- status=guess
lin flamethrower_N = mkN "火焰噴射器" | mkN "火焰喷射器" | {-mwn-} mkN "喷火器" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin flamingo_N = mkN "火鶴" | mkN "火鹤" | mkN "火烈鳥" | mkN "火烈鸟" | mkN "紅鶴" | mkN "红鹤" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin flammable_A = mkA "易燃" ;
lin flange_N = mkN "法蘭片" | {-mwn-} mkN "凸缘" | mkN "法兰片" | mkN "轮缘" ; -- status=guess -- open-multilingual-wordnet
lin flank_V = mkV "侧翼攻击" ;
lin flannel_N = mkN "绒布" "块" ;
lin flannelette_N = mkN "棉织法兰绒" | mkN "绒布" ; -- open-multilingual-wordnet
lin flap_N = mkN "拍打" "次" ;
lin flap_V = mkV "拍动" ;
lin flare_V = mkV "使+闪耀" ;
lin flare_V2 = mkV2 (mkV "勃發") | mkV2 (mkV "勃发") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin flash_N = mkN "闪光" "次" ;
lin flash_V = mkV "闪" ;
lin flashback_N = mkN "倒叙" "" ;
lin flashboard_N = mkN "插板" | mkN "闸板" ; -- open-multilingual-wordnet
lin flasher_N = mkN "闪光装置" ; -- open-multilingual-wordnet
lin flashgun_N = mkN "閃光燈" | mkN "闪光灯" ; -- status=guess -- status=guess
lin flashing_N = mkN "盖片" | mkN "防雨板" ; -- open-multilingual-wordnet
lin flashlight_N = mkN "闪光灯" ;
lin flashpoint_N = mkN "闪点" "" ;
lin flashy_A = mkA "瞬息" ;
lin flask_N = mkN "水壺" | mkN "水壶" | mkN "長頸瓶" | mkN "长颈瓶" | {-mwn-} mkN "烧瓶" | mkN "细颈瓶" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin flat_A = mkA "平" | {-HSK-} mkA "平坦" | {-HSK-} mkA "匾" ;
lin flat_Adv = mkAdv "平" ;
lin flat_N = mkN "公寓" | {-HSK-} mkN "平" ;
lin flatbed_N = mkN "平台型" | mkN "平板载货车" ; -- open-multilingual-wordnet
lin flat_car_N = mkN "平车" ; -- open-multilingual-wordnet
lin flatfoot_N = mkN "扁平足" ; -- status=guess
lin flathead_N = mkN "鲬鱼" ; -- open-multilingual-wordnet
lin flat_iron_N = mkN "熨斗" | mkN "铬铁" ; -- open-multilingual-wordnet
lin flatlet_N = mkN "单间公寓" | mkN "套房" | mkN "小公寓" ; -- open-multilingual-wordnet
lin flatness_N = mkN "平坦" ;
lin flatten_V = mkV "弄平" ;
lin flatten_V2 = mkV2 "弄平" ;
lin flatter_V2 = mkV2 (mkV "討好") | mkV2 (mkV "讨好") | mkV2 (mkV "奉承") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin flattery_N = mkN "奉承" ;
lin flatulence_N = mkN "屁" | mkN "脹氣" | mkN "胀气" ; -- status=guess -- status=guess -- status=guess
lin flatwork_N = mkN "机械熨烫件" ; -- open-multilingual-wordnet
lin flaunt_V = mkV "炫耀" ;
lin flaunt_V2 = mkV2 "炫耀" ;
lin flavin_N = mkN "核黄素" | mkN "黄素" ; -- open-multilingual-wordnet
lin flavorful_A = mkA "味浓" | mkA "好风味" | mkA "有味道" | mkA "有香味" ; -- open-multilingual-wordnet
lin flavour_N = mkN "香味" "种" | mkN "口味" | mkN "味道" | mkN "尝" ;
lin flaw_N = mkN "缺陷" ;
lin flaw_V2 = mkV2 "破裂" ;
lin flawless_A = mkA "无瑕疵" ;
lin flax_N = mkN "亞麻" | mkN "亚麻" ; -- status=guess -- status=guess
lin flay_V2 = mkV2 "剥夺" ;
lin flea_N = mkN "跳蚤" ;
lin fleabag_N = mkN "低廉的旅馆" | mkN "廉价的旅店" | mkN "破旧的旅馆" | mkN "简陋的小客栈" ; -- open-multilingual-wordnet
lin fleapit_N = mkN "跳蚤窝" ; -- open-multilingual-wordnet
lin fledgling_N = mkN "新手" ; -- comment=[mark]或无经验的人
lin flee_V = mkV "逃" | {-HSK-} mkV "逃跑" | {-HSK-} mkV "窜" ;
lin flee_V2 = mkV2 "逃" | {-HSK-} mkV2 "逃走" ;
lin fleece_N = mkN "羊毛" ; -- status=guess
lin fleece_V2 = mkV2 "剪下羊毛" ;
lin fleeceable_A = mkA "易受骗" ; -- open-multilingual-wordnet
lin fleet_A = mkA "快速" ;
lin fleet_N = mkN "舰队" ;
lin fleet_PN = foreignPN "Fleet" ; -- comment=src=geonames status=guess
lin fleet_street_PN = foreignPN "Fleet street" ; -- comment=src=eng status=guess
lin fleeting_A = mkA "短暂" ;
lin fleetwood_PN = foreignPN "Fleetwood" ; -- comment=src=geonames status=guess
lin flemish_A = mkA "佛兰德" ;
lin flesh_N = mkN "肉" "块" | {-HSK-} mkN "肌肉" ;
lin fleshy_A = mkA "似肉" | mkA "肉" | mkA "肉状" ; -- open-multilingual-wordnet
lin flexibility_N = mkN "灵活性" ;
lin flexible_A = mkA "灵活" | {-HSK-} mkA "软" ;
lin flexuous_A = mkA "弯曲" ; -- open-multilingual-wordnet
lin flick_N = mkN "拂去" ;
lin flick_V2 = mkV2 "拂去" ;
lin flicker_N = mkN "摆动" | mkN "摇摆" | mkN "摇曳" ; -- open-multilingual-wordnet
lin flicker_V = mkV "闪烁" ;
lin flier_N = mkN "飞行物" "个" ;
lin flight_N = mkN "飞行" ;
lin flightless_A = mkA "不能飞" ; -- open-multilingual-wordnet
lin flighty_A = mkA "易惊" | mkA "神经" | mkA "神经过敏" ; -- open-multilingual-wordnet
lin flimsy_A = mkA "脆弱" ;
lin flinch_V = mkV "退缩" ;
lin fling_N = mkN "扔" "次" ;
lin fling_V = mkV "一扔" | {-HSK-} mkV "甩" ;
lin fling_V2 = mkV2 "掷" | {-HSK-} mkV2 "甩" ;
lin flint_N = mkN "燧石" ; -- status=guess
lin flint_PN = mkPN "弗林特" ; -- comment=src=geonames status=guess
lin flintlock_N = mkN "明火枪" | mkN "燧发枪" ; -- open-multilingual-wordnet
lin flintstone_N = mkN "打火石" | mkN "燧石" ; -- open-multilingual-wordnet
lin flip_A = mkA "轻率" ;
lin flip_N = mkN "翻动" "" ;
lin flip_V = mkV "轻击" ;
lin flip_V2 = mkV2 "翻动" ;
lin flippant_A = mkA "轻率" ;
lin flirt_V = mkV "调情" ;
lin flirtation_N = mkN "挑逗" ;
lin flirtatious_A = mkA "卖弄风情" | mkA "爱调情" | mkA "轻浮" ; -- open-multilingual-wordnet
lin flit_N = mkN "搬家""" ;
lin flit_V = mkV "掠过" ;
lin float_N = mkN "漂流物" ;
lin float_V = L.float_V | {-HSK-} mkV "飘" ;
lin floatplane_N = mkN "水上飞机" | mkN "浮筒飞机" | mkN "飞行艇" ; -- open-multilingual-wordnet
lin flocculation_N = mkN "絮凝" ; -- open-multilingual-wordnet
lin floccule_N = mkN "絮状物" ; -- open-multilingual-wordnet
lin flock_N = mkN "羊群" | {-HSK-} mkN "群" ;
lin flock_V = mkV "聚集" ;
lin floe_N = mkN "浮冰" | mkN "凘" ; -- status=guess -- status=guess
lin flog_V2 = mkV2 "鞭打" ;
lin flogging_N = mkN "鞭打" ; -- status=guess
lin flood_N = mkN "洪水" ;
lin flood_V = mkV "淹没" ;
lin flood_V2 = mkV2 "淹没" ;
lin flooding_N = mkN "洪水" ; -- status=guess
lin floodplain_N = mkN "河漫灘" | mkN "河漫滩" ; -- status=guess -- status=guess
lin floor_N = L.floor_N | {-HSK-} mkN "楼" "層" ;
lin floorboard_N = mkN "一块地板" ; -- open-multilingual-wordnet
lin flooring_N = mkN "地板" ;
lin flop_N = mkN "失败" ;
lin flop_V = mkV "拍击" | mkV "失败" ;
lin flop_V2 = mkV2 "拍击" ;
lin flophouse_N = mkN "小客栈" ; -- open-multilingual-wordnet
lin floppy_A = mkA "松软" ;
lin flora_N = mkN "植物群" ; -- status=guess
lin flora_PN = foreignPN "Flora" ; -- comment=src=geonames status=guess
lin floral_A = mkA "花" ;
lin florence_1_PN = mkPN ("弗洛伦斯" | "佛罗伦萨" | "佛羅倫薩") ; -- comment=src=geonames status=guess
lin florence_2_PN = mkPN ("弗洛伦斯" | "佛罗伦萨" | "佛羅倫薩") ; -- comment=src=geonames status=guess
lin floricultural_A = mkA "养花" | mkA "种花" ; -- open-multilingual-wordnet
lin florida_PN = mkPN "佛罗里达" ;
lin florist_N = mkN "花商" | {-mwn-} mkN "花店" ; -- status=guess -- open-multilingual-wordnet
lin florrie_PN = foreignPN "Florrie" ; -- comment=src=eng status=guess
lin floss_N = mkN "牙线" ; -- open-multilingual-wordnet
lin flotation_N = mkN "浮选" "" ;
lin flotilla_N = mkN "小舰队" ;
lin flotsam_N = mkN "投弃物" ; -- open-multilingual-wordnet
lin flounder_N = mkN "川鰈" | mkN "川鲽" ; -- status=guess -- status=guess
lin flounder_V = mkV "挣扎" ;
lin flour_N = mkN "面粉" "包" ;
lin flourish_V = mkV "繁荣" ;
lin flout_V2 = mkV2 "藐视" ;
lin flow_N = mkN "流" ;
lin flow_V = L.flow_V ;
lin flower_N = L.flower_N | {-HSK-} mkN "朵" | mkN "花" "朵" ;
lin flower_V = mkV "开花" ;
lin flowerbed_N = mkN "花床" ; -- open-multilingual-wordnet
lin flowerpot_N = mkN "花盆" ; -- status=guess -- open-multilingual-wordnet
lin floxuridine_N = mkN "氟尿苷" ; -- open-multilingual-wordnet
lin flu_N = mkN "流感" ;
lin fluctuate_V = mkV "波动" ;
lin fluctuation_N = mkN "波动" ;
lin flue_N = mkN "通气管" ; -- open-multilingual-wordnet
lin fluency_N = mkN "掌握" | {-HSK-} mkN "流暢" | mkN "流畅" ; -- status=guess -- status=guess
lin fluent_A = mkA "流利" | {-HSK-} mkA "流畅" ;
lin fluff_N = mkN "绒毛" ;
lin fluffy_A = mkA "蓬松" ;
lin flugelhorn_N = mkN "粗管短号" ; -- open-multilingual-wordnet
lin fluid_A = mkA "流动" ;
lin fluid_N = mkN "液体" ;
lin fluke_N = mkN "侥幸" ;
lin flume_N = mkN "人工水道" | mkN "人工渠道" ; -- open-multilingual-wordnet
lin flunk_V = mkV "失败" ;
lin flunk_V2 = mkV2 "失败" ;
lin flunky_N = mkN "仆人" ;
lin fluorapatite_N = mkN "氟磷灰石" | mkN "氟磷酸钙" ; -- open-multilingual-wordnet
lin fluorescein_N = mkN "荧光素" ; -- open-multilingual-wordnet
lin fluorescent_N = mkN "熒光燈" | mkN "荧光灯" ; -- status=guess -- status=guess
lin fluoridation_N = mkN "加氟作用" | mkN "氟化反应" | mkN "氟化处理" | mkN "用氟化物处理" ; -- open-multilingual-wordnet
lin fluoride_N = mkN "氟化物" ;
lin fluoridization_N = mkN "加氟作用" | mkN "氟化反应" | mkN "氟化处理" | mkN "用氟化物处理" ; -- open-multilingual-wordnet
lin fluorine_N = mkN "氟" ; -- status=guess
lin fluorite_N = mkN "氟石" | mkN "荧石" | mkN "萤石" ; -- open-multilingual-wordnet
lin fluoroboride_N = mkN "氟硼酸盐" ; -- open-multilingual-wordnet
lin fluorocarbon_N = mkN "碳氟化合物" ; -- open-multilingual-wordnet
lin fluorochrome_N = mkN "荧光染料" | mkN "荧色物" ; -- open-multilingual-wordnet
lin fluoroform_N = mkN "三氟甲烷" ; -- open-multilingual-wordnet
lin fluoroscope_N = mkN "荧光检查器" ; -- open-multilingual-wordnet
lin fluorosis_N = mkN "氟中毒" ; -- open-multilingual-wordnet
lin fluorouracil_N = mkN "氟脲嘧啶" ; -- open-multilingual-wordnet
lin fluosilicate_N = mkN "氟硅酸盐" ; -- open-multilingual-wordnet
lin fluoxetine_N = mkN "氟西汀" | mkN "氟苯氧丙胺" ; -- status=guess -- status=guess
lin fluphenazine_N = mkN "氟非那嗪" ; -- open-multilingual-wordnet
lin flurry_N = mkN "慌张" ;
lin flush_A = mkA "激动" ; -- comment="洋溢" ;
lin flush_N = mkN "抽水馬桶" | mkN "抽水马桶" ; -- status=guess -- status=guess
lin flush_V = mkV "冲" | {-HSK-} mkV "冲洗" ;
lin flush_V2 = mkV2 "冲" | {-HSK-} mkV2 "冲洗" ;
lin flute_N = mkN "長笛" | mkN "长笛" | mkN "笛" | {-mwn-} mkN "横笛" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin fluting_N = mkN "演奏长笛" "" ;
lin flutter_N = mkN "摆动" ;
lin flutter_V = mkV "飘动" ;
lin flutter_V2 = mkV2 "使+焦急" ;
lin fluvial_A = mkA "河" | mkA "河流" ; -- open-multilingual-wordnet
lin flux_N = mkN "流" "" ;
lin fluxmeter_N = mkN "磁通计" | mkN "通量计" ; -- open-multilingual-wordnet
lin fly_A = mkA "敏捷" ;
lin fly_N = mkN "苍蝇" ;
lin fly_V = L.fly_V ;
lin fly_V2 = mkV2 "飞" ;
lin fly_about_V = advV OP_fly_V OP_about_Adv ; -- guess-p-verb
lin fly_around_V = advV OP_fly_V OP_around_Adv ; -- guess-p-verb
lin fly_at_V2 = prepV2 OP_fly_V OP_at_Prep ; -- guess-p-verb
lin fly_by_V = advV OP_fly_V OP_by_Adv ; -- guess-p-verb
lin fly_fish_V = variants {} ; -- guess-p-verb
lin fly_into_V2 = prepV2 OP_fly_V OP_into_Prep ; -- guess-p-verb
lin fly_out_V = advV OP_fly_V OP_out_Adv ; -- guess-p-verb
lin flyer_N = mkN "傳單" | mkN "传单" ; -- status=guess -- status=guess
lin flyleaf_N = mkN "扉頁" | mkN "扉页" | mkN "襯頁" | mkN "衬页" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin flypaper_N = mkN "捕蝇纸" | mkN "粘蝇纸" ; -- open-multilingual-wordnet
lin flyspeck_N = mkN "苍蝇斑点" ; -- open-multilingual-wordnet
lin flytrap_N = mkN "捕蝇器" ; -- open-multilingual-wordnet
lin flywheel_N = mkN "飛輪" | mkN "飞轮" | {-mwn-} mkN "惯性轮" | mkN "整速轮" | mkN "调速轮" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin fm_N = mkN "调频" ;
lin fo'c'sle_N = mkN "艏楼" ; -- open-multilingual-wordnet
lin fo_N = mkN "淡出""" ;
lin foal_N = mkN "駒子" | mkN "驹子" | mkN "駒" | mkN "驹" | {-mwn-} mkN "雏马" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin foam_N = mkN "泡沫" ;
lin foam_V = mkV "泡沫" ;
lin focal_A = mkA "焦点" ; -- comment="在焦点上" ;
lin focalization_N = mkN "使聚集" | mkN "对焦" | mkN "聚焦" | mkN "调焦" | mkN "集中焦点" ; -- open-multilingual-wordnet
lin focus_N = mkN "焦点" ;
lin focus_V = mkV "集中" ;
lin focus_V2 = mkV2 "集中" ;
lin focus_on_V2 = prepV2 OP_focus_V OP_on_Prep ; -- guess-p-verb
lin fodder_N = mkN "饲料" ;
lin foe_N = mkN "敌人" ;
lin foetal_A = mkA "有关胎儿" | mkA "胎" | mkA "胎儿" | mkA "胚胎" ; -- open-multilingual-wordnet
lin fog_N = L.fog_N | {-HSK-} mkN "雾" "場" ;
lin fog_V2 = mkV2 "使+模糊" ;
lin foggia_PN = foreignPN "Foggia" ; -- comment=src=geonames status=guess
lin foggy_A = mkA "模糊" ;
lin foglamp_N = mkN "雾灯" ; -- open-multilingual-wordnet
lin foible_N = mkN "剑刃" ; -- open-multilingual-wordnet
lin foil_N = mkN "箔" ;
lin foil_V2 = mkV2 "挫败" ;
lin fold_N = {-mwn-} mkN "合拢" | mkN "折" | mkN "折叠" ; -- open-multilingual-wordnet
lin fold_V = mkV "折叠" ;
lin fold_V2 = mkV2 "折叠" ;
lin folder_N = mkN "夹子" | {-HSK-} mkN "文件夹" ;
lin folderal_N = mkN "废话" | mkN "装饰品" ; -- open-multilingual-wordnet
lin foldout_N = mkN "插頁" | mkN "插页" | mkN "摺頁" | mkN "折页" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin foliaceous_A = mkA "叶" | mkA "叶子似" | mkA "叶状" ; -- open-multilingual-wordnet
lin foliage_N = mkN "叶子" "片" | {-HSK-} mkN "葉子" | mkN "叶子" | {-mwn-} mkN "叶状饰" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin foliate_A = mkA "叶片状" | mkA "有叶形装饰" | mkA "有叶花或枝饰" | mkA "有叶饰" | mkA "由叶饰构成" ; -- open-multilingual-wordnet
lin foliation_N = mkN "叶层结构" ; -- status=guess
lin folio_N = mkN "页码" "次" ;
lin folk_N = mkN "人们" [] ;
lin folkestone_PN = mkPN "福克斯通" ; -- comment=src=geonames status=guess
lin folklore_N = mkN "传说" | {-HSK-} mkN "民俗学" "" ;
lin folks_N = mkN "人们" ; -- open-multilingual-wordnet
lin folksy_A = mkA "有民间风味" ;
lin folktale_N = mkN "民間故事" | mkN "民间故事" | mkN "民間傳說" | mkN "民间传说" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin follicle_N = mkN "小囊" | mkN "濾泡" | mkN "滤泡" | mkN "毛囊" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin follicular_A = mkA "小囊" ; -- open-multilingual-wordnet
lin folliculitis_N = mkN "毛囊炎" ; -- status=guess
lin follow_V = mkV "则" | mkV "接着" | mkV "由" | {-HSK-} mkV "跟随" ;
lin follow_V2 = mkV2 "则" | mkV2 "接着" | mkV2 "由" | {-HSK-} mkV2 "跟随" ;
lin follow_VS = mkVS "则" | mkVS "接着" | mkVS "由" | {-HSK-} mkVS "跟随" ;
lin follow_on_V = advV OP_follow_V OP_on_Adv ; -- guess-p-verb
lin follow_on_from_V2 = prepV2 (advV OP_follow_V OP_on_Adv ) OP_from_Prep ; -- guess-p-verb
lin follow_through_V = advV OP_follow_V OP_through_Adv ; -- guess-p-verb
lin follow_up_V2 = prepV2 OP_follow_V OP_up_Prep ; -- guess-p-verb
lin follower_N = mkN "追随者" "个" ;
lin following_A = mkA "以下" | {-HSK-} mkA "以后" | mkA "随着" ;
lin following_N = mkN "以下" [] | {-HSK-} mkN "以后" | mkN "随着" ;
lin following_Prep = variants {} ;
lin folly_N = mkN "愚蠢" ;
lin foment_V2 = mkV2 "煽动" ;
lin fomentation_N = mkN "熱敷" | mkN "热敷" ; -- status=guess -- status=guess
lin fond_A = mkA "喜爱" ;
lin fondle_V2 = mkV2 (mkV "愛撫") | mkV2 (mkV "爱抚") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin fondness_N = mkN "喜爱" "" ;
lin fondue_N = mkN "干酪火鍋" | mkN "干酪火锅" | mkN "巧克力火鍋" | mkN "巧克力火锅" | mkN "火鍋" | mkN "火锅" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin font_N = mkN "字體" | mkN "字体" | mkN "字形" | {-mwn-} mkN "洗礼所" | mkN "洗礼用桶" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin fontanelle_N = mkN "囟門" | mkN "囟门" | mkN "囟腦門兒" | mkN "囟脑门儿" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin foochow_PN = foreignPN "Foochow" ; -- comment=src=eng status=guess
lin food_N = mkN "食品" "種" | mkN "食物" "種" | {-HSK-} mkN "食物" ;
lin foodless_A = mkA "沒有食物" | mkA "没有食物" | {-mwn-} mkA "缺乏食物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin foodstuff_N = mkN "粮食" | {-HSK-} mkN "粮食" "種" | mkN "食品" "種" ;
lin fool_N = mkN "傻瓜" ;
lin fool_V2 = mkV2 "傻瓜" | {-HSK-} mkV2 "骗" ;
lin fool_around_V = mkV "无所事事" | mkV "瞎弄" | mkV "胡闹" | mkV "闹哄" | mkV "鬼混" ; -- open-multilingual-wordnet
lin fool_with_V2 = mkV2 "弄" ;
lin foolhardy_A = mkA "蛮干" ;
lin foolish_A = mkA "傻" | mkA "呆" | mkA "笨" | {-HSK-} mkA "愚蠢" ;
lin foot_N = L.foot_N | {-HSK-} mkN "脚" "雙" ;
lin foot_V = mkV "步行" ;
lin foot_V2 = mkV2 "步行" ;
lin footage_N = mkN "以尺计算长度" ;
lin football_N = mkN "足球" ;
lin footballer_N = mkN "足球員" | mkN "足球员" | mkN "足球選手" | mkN "足球选手" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin foot_bath_N = mkN "洗脚盆" | mkN "脚盆" ; -- open-multilingual-wordnet
lin footboard_N = mkN "床踏板" ; -- open-multilingual-wordnet
lin footbridge_N = mkN "人行桥" ; -- open-multilingual-wordnet
lin foothill_N = mkN "山麓" ; -- status=guess
lin foothold_N = mkN "立足点" ;
lin footing_N = mkN "基础" ;
lin footle_V = mkV "做笨事" | mkV "干傻事" | mkV "干蠢事" | mkV "说傻话" | mkV "说呆话" ; -- open-multilingual-wordnet
lin footlocker_N = mkN "扁平箱" ; -- open-multilingual-wordnet
lin footnote_N = mkN "脚注" ;
lin footpath_N = mkN "人行小徑" | mkN "人行小径" ; -- status=guess -- status=guess
lin footplate_N = mkN "踏板" ; -- open-multilingual-wordnet
lin footprint_N = mkN "腳印" | mkN "脚印" | mkN "足印" ; -- status=guess -- status=guess -- status=guess
lin footsore_A = mkA "脚痛" | mkA "脚酸" | mkA "走痛了脚" ; -- open-multilingual-wordnet
lin footstep_N = mkN "脚步" ;
lin footstool_N = mkN "腳台" | mkN "脚台" | mkN "腳凳" | mkN "脚凳" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin footsure_A = mkA "稳当" | mkA "脚步稳" ; -- open-multilingual-wordnet
lin footwear_N = mkN "鞋类" ;
lin for_Adv = {-HSK-} mkAdv "为" | mkAdv "对" | mkAdv "无奈" | mkAdv "种" | mkAdv "给" ; -- comment=S.for_Prep ;
lin for_PConj = variants {} ;
lin for_Prep = S.for_Prep ;
lin for_example_Adv = mkAdv "举例" | {-HSK-} mkAdv "例如" | mkAdv "比如" ;
lin for_instance_Adv = mkAdv "例如" | {-HSK-} mkAdv "比如" ;
lin for_starters_Adv = mkAdv "首先" ;
lin for_the_sake_of_Prep = mkPrep "为了" ;
lin forage_V = mkV "搜尋" | mkV "搜寻" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin foray_N = mkN "冒险" | {-HSK-} mkN "突袭" "次" ;
lin forbear_V = mkV "克制" | mkV "制止" | mkV "忍耐" | mkV "抑制" ; -- open-multilingual-wordnet
lin forbearance_N = mkN "自制" ;
lin forbid_V2 = mkV2 "禁止" ;
lin force_N = mkN "力量" ;
lin force_V = mkV "强迫" ;
lin force_V2 = mkV2 "强迫" ;
lin force_V2V = mkV2V "强制" ;
lin force_VS = mkVS "强制" ;
lin force_feed_V2 = variants {} ; -- guess-p-verb
lin force_land_V = variants {} ; -- guess-p-verb
lin force_land_V2 = variants {} ; -- guess-p-verb
lin force_out_V = mkV "夺取" | mkV "封杀" | mkV "挤出" | mkV "迫使屈服" | mkV "迫使离开" | mkV "迫使让步" ; -- open-multilingual-wordnet
lin forceful_A = mkA "有力" ;
lin forcefulness_N = mkN "力量" ;
lin forceps_N = mkN "鑷子" | mkN "镊子" | mkN "鉗子" | mkN "钳子" | mkN "產鉗" | mkN "产钳" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin forcible_A = variants {} ;
lin forcipate_A = mkA "钳形" | mkA "钳状" ; -- open-multilingual-wordnet
lin ford_N = mkN "淺灘" | mkN "浅滩" | mkN "津" ; -- status=guess -- status=guess -- status=guess
lin ford_V2 = mkV2 (mkV "涉過") | mkV2 (mkV "涉过") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin fore_N = mkN "前面" [] ;
lin forearm_N = mkN "前臂" | mkN "下臂" ; -- status=guess -- status=guess
lin forecast_N = mkN "预报" | {-HSK-} mkN "预测" ;
lin forecast_V = mkV "预测" ;
lin forecast_V2 = mkV2 "预测" ;
lin forecast_VS = mkVS "预测" ;
lin forecaster_N = mkN "预报员" ;
lin forecastle_N = mkN "前甲板" | {-mwn-} mkN "艏楼" ; -- status=guess -- open-multilingual-wordnet
lin foreclose_V = mkV "止赎" ;
lin foreclose_V2 = mkV2 "阻止" ;
lin foreclosure_N = mkN "止赎" "次" ;
lin forecourt_N = mkN "前院" ; -- open-multilingual-wordnet
lin foredeck_N = mkN "前甲板" ; -- open-multilingual-wordnet
lin forefather_N = mkN "祖先" "位" ;
lin forefinger_N = mkN "食指" ; -- status=guess -- open-multilingual-wordnet
lin forefoot_N = mkN "前足" ; -- open-multilingual-wordnet
lin forefront_N = mkN "前线" ;
lin foregather_V = mkV "使聚拢" | mkV "使聚集" | mkV "相遇" | mkV "聚会" | mkV "聚拢" | mkV "聚集" | mkV "集会" | mkV "集合" ; -- open-multilingual-wordnet
lin forego_V2 = mkV2 "放弃" ;
lin foreground_N = mkN "前景" ;
lin forehead_N = mkN "前额" ;
lin foreign_1_A = mkA "国外" ;
lin foreign_2_A = mkA "国外" ;
lin foreign_A = mkA "国外" ;
lin foreigner_N = mkN "外国人" ;
lin foreleg_N = mkN "前腳" | mkN "前脚" | mkN "前腿" | mkN "前肢" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin forelimb_N = mkN "上肢" | mkN "前肢" ; -- open-multilingual-wordnet
lin foreman_N = mkN "工头" ;
lin foremast_N = mkN "前桅" ; -- status=guess -- open-multilingual-wordnet
lin foremost_A = mkA "最重要" ;
lin foremost_Adv = mkAdv "最重要" ;
lin forename_N = mkN "名字" ; -- status=guess
lin forenoon_N = mkN "中午""" ;
lin forensic_A = mkA "法医" ;
lin forepaw_N = mkN "前爪" | mkN "前蹄" ; -- open-multilingual-wordnet
lin foreplay_N = mkN "前戲" | mkN "前戏" ; -- status=guess -- status=guess
lin forerunner_N = mkN "先行者" ;
lin foresail_N = mkN "前桅帆" | mkN "前桅的大帆" ; -- open-multilingual-wordnet
lin foresee_V2 = mkV2 "预知" ;
lin foreseeable_A = mkA "可预见" ;
lin foreshadow_V2 = mkV2 "预示" ;
lin foresight_N = mkN "先见" ; -- comment="远见" ;
lin forest_N = mkN "森林" | {-HSK-} mkN "森林" "片" ;
lin forested_A = mkA "草木丛生" | mkA "被森林所覆盖" ; -- open-multilingual-wordnet
lin forester_N = mkN "林務官" | mkN "林务官" ; -- status=guess -- status=guess
lin forestry_N = mkN "林业" "" ;
lin forever_Adv = mkAdv "永远" | {-HSK-} mkAdv "长" ;
lin forewing_N = mkN "前翼" ; -- open-multilingual-wordnet
lin forfar_PN = foreignPN "Forfar" ; -- comment=src=geonames status=guess
lin forfeit_V2 = mkV2 "丧失" ;
lin forfeiture_N = mkN "没收" [] ;
lin forgather_V = mkV "使聚拢" | mkV "使聚集" | mkV "相遇" | mkV "聚会" | mkV "聚拢" | mkV "聚集" | mkV "集会" | mkV "集合" ; -- open-multilingual-wordnet
lin forge_N = mkN "熔炉" ; -- comment="锻铁炉" ;
lin forge_V = mkV "锻造" ;
lin forge_V2 = mkV2 "打制" ;
lin forger_N = mkN "铁匠" ;
lin forgery_N = mkN "伪造" ;
lin forget_V = mkV "忘" | {-HSK-} mkV "忘记" ;
lin forget_V2 = L.forget_V2 | {-HSK-} mkV2 "忘记" ;
lin forget_VS = mkVS "忘记" ;
lin forgetful_A = mkA "健忘" | mkA "丟三落四" | mkA "丢三落四" | {-mwn-} mkA "不小心" | mkA "不注意" | mkA "不留心" | mkA "不留意" | mkA "不经心" | mkA "漫不经心" | mkA "疏忽" | mkA "粗心大意" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin forging_N = mkN "锻造" [] ;
lin forgive_V = mkV "原谅" ;
lin forgive_V2 = mkV2 "原谅" ;
lin forgiveness_N = mkN "饶恕" "次" ;
lin forgivingly_Adv = mkAdv "宽大+地" | mkAdv "慈悲+地" ; -- open-multilingual-wordnet
lin forgo_V2 = mkV2 "放弃" ;
lin fork_1_N = mkN "叉" "只" ;
lin fork_3_N = variants {} ;
lin fork_4_N = variants {} ;
lin fork_N = variants {} ;
lin fork_V = mkV "复制" ;
lin forklift_N = mkN "叉車" | mkN "叉车" | mkN "鏟車" | mkN "铲车" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin forli_PN = foreignPN "Forli" ; -- comment=src=eng status=guess
lin forlorn_A = mkA "绝望" ;
lin form_N = mkN "形式" | {-HSK-} mkN "形式" "個" | mkN "形状" "個" | mkN "形象" "個" | mkN "表格" "張" ;
lin form_V = mkV "养成" | mkV "形成" | mkV "构成" ;
lin form_V2 = mkV2 "养成" | mkV2 "形成" | mkV2 "构成" ;
lin formal_A = mkA "正式" ;
lin formaldehyde_N = mkN "蚁醛" ;
lin formalin_N = mkN "福爾馬林" | mkN "福尔马林" | {-mwn-} mkN "甲醛溶液" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin formalism_N = mkN "形式主義" | mkN "形式主义" ; -- status=guess -- status=guess
lin formalistic_A = mkA "形式主义" ; -- open-multilingual-wordnet
lin formality_N = mkN "礼节" ;
lin formalize_V2 = mkV2 "正规化" ;
lin formalwear_N = mkN "夜礼服" ; -- open-multilingual-wordnet
lin format_N = mkN "格式" ;
lin formation_N = mkN "编队" ;
lin formby_PN = foreignPN "Formby" ; -- comment=src=geonames status=guess
lin former_A = mkA "以前" | {-HSK-} mkA "先" | mkA "原来" | mkA "旧" | mkA "曾经" | mkA "过去" ;
lin former_N = mkN "先" | mkN "原来" | mkN "旧" | mkN "曾经" | mkN "过去" | {-HSK-} mkN "模型""座" ;
lin formic_A = mkA "甲酸" | mkA "蚁酸" ; -- open-multilingual-wordnet
lin formidable_A = mkA "可怕" | mkA "艰巨" | {-HSK-} mkA "强大" ;
lin formosa_PN = mkPN "福莫萨" ; -- comment=src=geonames status=guess
lin formula_N = mkN "公式" ;
lin formulary_A = mkA "公式" ; -- open-multilingual-wordnet
lin formulate_V2 = mkV2 "制定" | {-HSK-} mkV2 "规定" ;
lin formulation_N = mkN "构想" ;
lin fornication_N = mkN "通奸" | mkN "姦淫" | mkN "奸淫" | mkN "亂倫" | mkN "乱伦" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin forsake_V2 = mkV2 "离弃" ;
lin forsythia_N = mkN "連翹" ; -- status=guess
lin fort_N = mkN "要塞" | mkN "碉堡" | mkN "城堡" | mkN "堡壘" | mkN "堡垒" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin fort_lauderdale_PN = foreignPN "Fort lauderdale" ; -- comment=src=eng status=guess
lin fort_william_PN = foreignPN "Fort william" ; -- comment=src=eng status=guess
lin fort_worth_PN = foreignPN "Fort worth" ; -- comment=src=eng status=guess
lin fortaleza_PN = mkPN "福塔雷萨" ; -- comment=src=geonames status=guess
lin forte_N = mkN "長處" | mkN "长处" ; -- status=guess -- status=guess
lin forth_Adv = mkAdv "向前" ;
lin forthcoming_A = mkA "即将到来" ;
lin forthright_A = mkA "快" | {-HSK-} mkA "直率" ;
lin forthwith_Adv = mkAdv "立刻" ;
lin fortification_N = mkN "防禦工事" | mkN "防御工事" | mkN "工事" | mkN "堡壘" | mkN "堡垒" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin fortnight_N = mkN "两星期" "个" ;
lin fortnightly_A = variants {} ;
lin fortnightly_Adv = adjAdv fortnightly_A ; -- derived
lin fortress_N = mkN "要塞" | mkN "城堡" | mkN "堡壘" | mkN "堡垒" | {-mwn-} mkN "碉堡" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin fortuitous_A = mkA "偶然" ;
lin fortunate_A = mkA "幸运" ;
lin fortunately_Adv = {-HSK-} mkAdv "幸亏" | adjAdv fortunate_A ; -- derived
lin fortune_N = mkN "幸运" | {-HSK-} mkN "运气" "次" ;
lin fortuneteller_N = mkN "算命家" ; -- status=guess
lin forum_N = mkN "论坛" ;
lin forward_A = mkA "向前" ;
lin forward_Adv = mkAdv "向前" ;
lin forward_N = mkN "前锋" ;
lin forward_V2 = mkV2 "促进" ;
lin forwards_Adv = mkAdv "向前地" ;
lin fosse_N = mkN "城河" | mkN "壕沟" | mkN "护城河" ; -- open-multilingual-wordnet
lin fossil_A = mkA "化石" | mkA "有化石特征" | mkA "构成化石" | mkA "石化" ; -- open-multilingual-wordnet
lin fossil_N = mkN "化石" ;
lin fossiliferous_A = mkA "含化石" | mkA "含有化石" ; -- open-multilingual-wordnet
lin fossorial_A = mkA "适于掘土" | mkA "适于掘地" ; -- open-multilingual-wordnet
lin foster_V2 = mkV2 "培养" ;
lin foul_A = mkA "违反规则" ;
lin foul_N = mkN "穢語" | mkN "秽语" | mkN "粗話" | mkN "粗话" | mkN "髒話" | mkN "脏话" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin foul_V = mkV "犯规" ;
lin foul_V2 = mkV2 "弄脏" ;
lin foul_mouthed_A = mkA "满嘴脏话" ;
lin foulard_N = mkN "仿薄软绸" | mkN "薄软绸" ; -- open-multilingual-wordnet
lin found_V2 = mkV2 "发现" | {-HSK-} mkV2 "建立" ;
lin foundation_N = mkN "基础" | {-HSK-} mkN "基础" "個" | mkN "本" | mkN "根据" "個" ;
lin founder_N = mkN "创办人" ;
lin founder_V = mkV "破坏" ;
lin foundry_N = mkN "鑄造廠" | mkN "铸造厂" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin fount_N = mkN "液体贮存器" ; -- open-multilingual-wordnet
lin fountain_N = mkN "喷泉" "口" ;
lin four_part_A = mkA "四部分" ;
lin fourfold_Adv = mkAdv "四倍+地" | mkAdv "四重+地" ; -- open-multilingual-wordnet
lin fourhanded_A = mkA "四个玩家" | mkA "有四人参加" ; -- open-multilingual-wordnet
lin foursquare_A = mkA "不妥协" | mkA "坚定" | mkA "坚定不移" ; -- open-multilingual-wordnet
lin fowey_PN = foreignPN "Fowey" ; -- comment=src=geonames status=guess
lin fowl_N = mkN "家禽" "只" ;
lin fox_N = mkN "狐狸" "只" ;
lin foxglove_N = mkN "指頂花" | {-mwn-} mkN "指顶花" | mkN "毛地黄属植物" ; -- status=guess -- open-multilingual-wordnet
lin foxhole_N = mkN "单人战壕" ; -- open-multilingual-wordnet
lin foxhound_N = mkN "猎狐犬" | mkN "猎狐用猎狗" ; -- open-multilingual-wordnet
lin foyer_N = mkN "门厅" ;
lin fr_PN = foreignPN "Fr" ; -- comment=src=eng status=guess
lin fracas_N = mkN "吵闹" ;
lin fraction_N = mkN "分" | mkN "零" | {-HSK-} mkN "分数" ;
lin fractional_A = mkA "部分" | {-HSK-} mkA "零" ;
lin fractious_A = mkA "易怒" ;
lin fracture_N = mkN "骨折" ;
lin fracture_V = mkV "使断裂" ;
lin fracture_V2 = mkV2 "折断" ;
lin fragile_A = mkA "脆弱" ;
lin fragility_N = mkN "脆弱性" ;
lin fragment_N = mkN "碎片" ;
lin fragment_V = mkV "弄碎" ;
lin fragment_V2 = mkV2 "使+破碎" ;
lin fragmentary_A = mkA "碎" | mkA "零" ;
lin fragmentation_N = mkN "破碎" ;
lin fragrance_N = mkN "香味" ;
lin fragrant_A = mkA "愉快" | {-HSK-} mkA "香" ;
lin frail_A = mkA "脆弱" ;
lin frail_N = mkN "灯心草篓" ; -- open-multilingual-wordnet
lin frailty_N = mkN "脆弱" ;
lin fraise_N = mkN "防御工事" | mkN "障碍物" ; -- open-multilingual-wordnet
lin frame_N = mkN "框架" ;
lin frame_V = mkV "设计" ;
lin frame_V2 = mkV2 "框架" ;
lin framework_N = mkN "框架" ;
lin frampton_cotterell_PN = foreignPN "Frampton cotterell" ; -- comment=src=eng status=guess
lin fran_PN = foreignPN "Fran" ; -- comment=src=eng status=guess
lin franc_N = mkN "法郎" ;
lin france_PN = mkPN "法国" ;
lin frances_PN = foreignPN "Frances" ; -- comment=src=eng status=guess
lin franchise_N = mkN "专营权" ;
lin francis_PN = foreignPN "Francis" ; -- comment=src=geonames status=guess
lin franciscan_A = mkA "圣方济修会" ;
lin franciscan_N = mkN "方济会修士" "位" ;
lin francium_N = mkN "钫" | mkN "鍅" ; -- status=guess -- status=guess
lin frank_A = mkA "坦率" | {-HSK-} mkA "直" ;
lin frank_N = mkN "坦率" | mkN "直" | {-mwn-} mkN "一种香肠" | mkN "法兰克福香肠" | mkN "维也纳香肠" ; -- open-multilingual-wordnet
lin frank_PN = foreignPN "Frank" ; -- comment=src=eng status=guess
lin frankfurt_PN = mkPN "法兰克福" ;
lin frankfurter_N = mkN "一种香肠" | mkN "法兰克福香肠" | mkN "维也纳香肠" ; -- open-multilingual-wordnet
lin frankie_PN = foreignPN "Frankie" ; -- comment=src=eng status=guess
lin frankincense_N = mkN "乳香" ; -- status=guess -- open-multilingual-wordnet
lin frankly_Adv = adjAdv frank_A ; -- derived
lin frantic_A = mkA "狂乱" ;
lin fraserburgh_PN = foreignPN "Fraserburgh" ; -- comment=src=geonames status=guess
lin fraternal_A = mkA "兄弟" ; -- status=guess
lin fraternity_N = mkN "兄弟会" "次" ;
lin fraternize_V = mkV "亲善" | mkV "友善" | mkV "友善地交往" | mkV "友好" | mkV "结有深交" ; -- open-multilingual-wordnet
lin fraud_N = mkN "骗局" ;
lin fraudulence_N = mkN "恶作剧" | mkN "欺诈" | mkN "欺骗" | mkN "瞒骗" | mkN "骗局" ; -- open-multilingual-wordnet
lin fraudulent_A = mkA "欺诈" ;
lin fraught_A = mkA "忧虑" ;
lin fray_N = mkN "争论" ;
lin fray_V = mkV "磨损" ;
lin fray_V2 = mkV2 "磨损" ;
lin frazzle_N = mkN "疲惫" | mkN "疲惫不堪" | mkN "精疲力竭" ; -- open-multilingual-wordnet
lin freak_N = mkN "狂" ;
lin freak_V = mkV "怪物" ;
lin freak_V2 = mkV2 (mkV "發瘋") | mkV2 (mkV "发疯") | mkV2 (mkV "嚇壞") | mkV2 (mkV "吓坏") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin freakish_A = mkA "滑稽可笑" ;
lin freckle_N = mkN "雀斑" | mkN "斑點" | mkN "斑点" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin freckle_V = mkV "有雀斑" | mkV "長雀斑" | mkV "长雀斑" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin freckle_V2 = mkV2 (mkV "有雀斑") | mkV2 (mkV "長雀斑") | mkV2 (mkV "长雀斑") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin freckleton_PN = foreignPN "Freckleton" ; -- comment=src=geonames status=guess
lin fred_PN = foreignPN "Fred" ; -- comment=src=eng status=guess
lin freda_PN = foreignPN "Freda" ; -- comment=src=eng status=guess
lin freddie_PN = foreignPN "Freddie" ; -- comment=src=eng status=guess
lin freddy_PN = foreignPN "Freddy" ; -- comment=src=eng status=guess
lin frederick_PN = mkPN "弗雷德里克" ; -- comment=src=geonames status=guess
lin frederiksberg_PN = mkPN "腓特烈斯贝" ; -- comment=src=geonames status=guess
lin free_1_A = mkA "免费" | mkA "自由" | {-HSK-} mkA "无偿" ;
lin free_2_A = mkA "免费" | mkA "自由" | {-HSK-} mkA "无偿" ;
lin free_N = mkN "免费" | mkN "自由" "個" | {-HSK-} mkN "自由軟件" | mkN "自由软件" ; -- status=guess -- status=guess
lin free_V2 = mkV2 "免费" | {-HSK-} mkV2 "放" ;
lin free_V2V = mkV2V "免费" | {-HSK-} mkV2V "放" ;
lin free_of_A2 = mkA2 "免费" ;
lin free_standing_A = mkA "独立" ;
lin free_up_V2 = prepV2 (lin V OP_free_V2) OP_up_Prep ; -- guess-p-verb
lin freebie_N = mkN "免費的東西" | mkN "免费的东西" | {-mwn-} mkN "不花钱的东西" | mkN "免费品" | mkN "免费赠品" | mkN "赠品" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin freedom_N = mkN "自由" | {-HSK-} mkN "自由" "個" ;
lin freeholder_N = mkN "世袭地产保有人" ;
lin freelancer_N = mkN "自由職業者" | mkN "自由职业者" ; -- status=guess -- status=guess
lin freeloader_N = mkN "不速之客" | mkN "食客" ; -- status=guess -- status=guess
lin freemasonry_N = mkN "伙伴关系" | mkN "同情" | mkN "同病相怜" | mkN "意气相投" | mkN "默契" ; -- open-multilingual-wordnet
lin freesia_N = mkN "鸢尾科" ; -- status=guess
lin freestyle_N = mkN "自由泳" ; -- status=guess
lin freetail_N = mkN "游离尾蝠" ; -- open-multilingual-wordnet
lin freeware_N = mkN "免費軟件" | mkN "免费软件" ; -- status=guess -- status=guess
lin freeway_N = mkN "高速公路" | {-HSK-} mkN "高速公路" "条" ;
lin freewheel_N = mkN "自由飞轮" ; -- open-multilingual-wordnet
lin freeze_N = mkN "冻结" ;
lin freeze_V = L.freeze_V | {-HSK-} mkV "冻" ;
lin freeze_V2 = mkV2 "冻" | {-HSK-} mkV2 "冻结" ;
lin freezer_N = mkN "冰箱" "台" ;
lin freiburg_PN = foreignPN "Freiburg" ; -- comment=src=geonames status=guess
lin freight_N = mkN "货物" ;
lin freight_V2 = mkV2 "运送" ;
lin freighter_N = mkN "货船" ;
lin frenchFem_N = mkN "法国人" ;
lin frenchMasc_N = mkN "法国人" ;
lin french_A = mkA "法语" ;
lin frenetic_A = mkA "狂热" ;
lin frenzied_A = mkA "疯狂" ;
lin frenzy_N = mkN "狂妄" ;
lin frequency_N = mkN "频率" | {-HSK-} mkN "频道" ;
lin frequent_A = mkA "频繁" ;
lin frequent_V2 = mkV2 "常去" ;
lin fresco_N = mkN "壁画" "幅" ;
lin fresh_A = mkA "新鲜" | {-HSK-} mkA "淡" ;
lin fresh_Adv = mkAdv "刚才" | {-HSK-} mkAdv "新鲜" | mkAdv "淡" ;
lin fresher_N = mkN "中学一年级学生" | mkN "大学一年级学生" | mkN "新生" ; -- open-multilingual-wordnet
lin freshman_N = mkN "大一学生" ;
lin freshness_N = mkN "新鲜" ;
lin freshwater_PN = foreignPN "Freshwater" ; -- comment=src=geonames status=guess
lin fret_N = mkN "烦恼" ;
lin fret_V = mkV "发愁" | {-HSK-} mkV "烦恼" ;
lin fret_V2 = mkV2 "发愁" ;
lin fret_VS = mkVS "发愁" | {-HSK-} mkVS "烦躁" ;
lin fretsaw_N = mkN "竖锯" | mkN "线锯" ; -- open-multilingual-wordnet
lin fretwork_N = mkN "格子" | mkN "格构" ; -- open-multilingual-wordnet
lin fri_PN = foreignPN "Fri" ; -- comment=src=eng status=guess
lin friar_N = mkN "修士" ;
lin friary_N = mkN "修道院" | mkN "男修道院" ; -- open-multilingual-wordnet
lin fricative_N = mkN "擦音" ; -- status=guess
lin friction_N = mkN "摩擦" "" ;
lin frictional_A = mkA "由摩擦而生" ; -- open-multilingual-wordnet
lin frictionless_A = mkA "无摩擦" ; -- open-multilingual-wordnet
lin fridge_N = L.fridge_N ;
lin friend_N = L.friend_N | {-HSK-} mkN "朋友" "個" ;
lin friendliness_N = mkN "亲切" | {-HSK-} mkN "友好" "" ;
lin friendly_A = mkA "友好" ;
lin friendly_N = mkN "友好" | {-HSK-} mkN "友谊赛""场" ;
lin friendship_N = mkN "友谊" | {-HSK-} mkN "友谊" [] ;
lin frier_N = mkN "做油炸食品的人" "名" ;
lin frieze_N = mkN "起绒粗呢" ;
lin frigate_N = mkN "护卫舰" ;
lin fright_N = mkN "惊骇" ;
lin frighten_V2 = mkV2 "吓" | {-HSK-} mkV2 "吓唬" ;
lin frighten_away_V2 = mkV2 (advV (lin V OP_frighten_V2) OP_away_Adv ) ; -- guess-p-verb
lin frighten_off_V2 = prepV2 (lin V OP_frighten_V2) OP_off_Prep ; -- guess-p-verb
lin frightened_A = variants {} ;
lin frightening_A = mkA "可怕" | {-HSK-} mkA "恐怖" ;
lin frightful_A = mkA "可怕" | mkA "恐怖" ;
lin frill_N = mkN "废话" | mkN "装饰品" ; -- open-multilingual-wordnet
lin fringe_N = mkN "边缘" ;
lin frinton_PN = foreignPN "Frinton" ; -- comment=src=eng status=guess
lin frippery_N = mkN "无用的东西" ;
lin fritillary_N = mkN "豹纹蝶" ; -- open-multilingual-wordnet
lin fritter_V2 = mkV2 "浪费" ;
lin frivolous_A = mkA "轻" | {-HSK-} mkA "轻浮" ;
lin fro_Adv = mkAdv "向前" ;
lin frock_N = mkN "罩袍" "种" ;
lin frodsham_PN = foreignPN "Frodsham" ; -- comment=src=geonames status=guess
lin frog_N = mkN "青蛙" "只" ;
lin frogfish_N = mkN "襞鱼" | mkN "襞鱼科" ; -- open-multilingual-wordnet
lin froghopper_N = mkN "吹沫虫" | mkN "沫蝉" ; -- open-multilingual-wordnet
lin frogman_N = mkN "潜水员" "个" ;
lin frolic_V = mkV "嬉戏" ;
lin frolicsome_A = mkA "作乐" | mkA "嬉戏" | mkA "嬉戏着" | mkA "欢乐" | mkA "欢闹" | mkA "爱玩耍" | mkA "爱闹着玩" | mkA "闹玩" | mkA "闹着玩" ; -- open-multilingual-wordnet
lin from_Prep = S.from_Prep ;
lin from_home_Adv = mkAdv "自家里" ;
lin frome_PN = foreignPN "Frome" ; -- comment=src=geonames status=guess
lin frond_N = mkN "叶" ;
lin front_A = variants {} ;
lin front_N = mkN "前面" ;
lin front_V = mkV "朝向" ;
lin front_V2 = mkV2 "使+面对" ;
lin frontal_A = mkA "额" ;
lin frontal_N = mkN "外观" | mkN "建筑物的正面" | mkN "表面" ; -- open-multilingual-wordnet
lin frontier_N = mkN "前沿" "" ;
lin frontlet_N = mkN "额前饰" | mkN "额饰" ; -- open-multilingual-wordnet
lin frost_N = mkN "嚴寒" | mkN "严寒" | mkN "冰凍" | mkN "冰冻" | mkN "寒冷" | mkN "霜" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin frost_V = mkV "生气" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin frost_V2 = mkV2 (mkV "生气") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin frostbite_N = mkN "凍瘡" | mkN "冻疮" | mkN "凍傷" | mkN "冻伤" | mkN "瘃" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin frosty_A = mkA "冷冰冰" ;
lin froth_N = mkN "泡沫" ;
lin froth_V = mkV "泡沫" ; -- comment="泡" ;
lin frothy_A = mkA "多泡" ;
lin frown_N = mkN "愁眉苦臉" | mkN "愁眉苦脸" ; -- status=guess -- status=guess
lin frown_V = mkV "皱眉" ;
lin frozen_A = variants {} ;
lin fructose_N = mkN "果糖" | {-mwn-} mkN "左旋糖" ; -- status=guess -- open-multilingual-wordnet
lin fructosuria_N = mkN "果糖尿" ; -- open-multilingual-wordnet
lin frugal_A = mkA "节俭" | {-HSK-} mkA "节约" ;
lin frugality_N = mkN "节俭" ;
lin fruit_N = L.fruit_N | {-HSK-} mkN "果实" | mkN "水果" "個" ;
lin fruit_V = mkV "结果实" ;
lin fruiterer_N = mkN "水果商" ; -- status=guess
lin fruitful_A = mkA "富有成效" ;
lin fruition_N = mkN "结果" ;
lin fruitless_A = mkA "不成功" | mkA "徒劳" ;
lin fruitlet_N = mkN "一串聚花果" | mkN "小水果" ; -- open-multilingual-wordnet
lin frumpy_A = mkA "单调" ;
lin frustrate_V2 = mkV2 "阻挠" ;
lin frustration_N = mkN "挫折" "次" ;
lin frustum_N = mkN "平截头体" | mkN "截头体" ; -- open-multilingual-wordnet
lin fry_N = mkN "油炸食物" ;
lin fry_V = mkV "油炸" | {-HSK-} mkV "炒" ;
lin fry_V2 = mkV2 "炒" ;
lin frying_N = mkN "平底鍋" | mkN "平底锅" ; -- status=guess -- status=guess
lin ft_PN = foreignPN "FT" ; -- comment=src=eng status=guess
lin fuchsia_N = mkN "紫紅色" | mkN "紫红色" | mkN "品紅色" | mkN "品红色" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin fuck_V = mkV "干" ;
lin fuck_V2 = mkV2 "干" ;
lin fucking_A = variants {} ;
lin fucking_Adv = mkAdv "干" ;
lin fuel_N = mkN "燃料" ;
lin fuel_V = mkV "得到燃料" ;
lin fuel_V2 = mkV2 "加燃料" ;
lin fug_N = mkN "闷浊空气" ; -- open-multilingual-wordnet
lin fugal_A = mkA "赋格曲" ; -- open-multilingual-wordnet
lin fuggy_A = mkA "闷气" | mkA "闷热" ; -- open-multilingual-wordnet
lin fugitive_N = mkN "逃亡者" ;
lin fugue_N = mkN "賦格" | mkN "赋格" ; -- status=guess -- status=guess
lin fulcrum_N = mkN "支点" ; -- open-multilingual-wordnet
lin fulfil_V2 = mkV2 "履行" ;
lin fulfill_V2 = mkV2 "实践" | {-HSK-} mkV2 "履行" ;
lin fulgurating_A = mkA "钻心" ; -- open-multilingual-wordnet
lin full_A = L.full_A | {-HSK-} mkA "充分" | mkA "满" ;
lin full_blown_A = mkA "充分" ;
lin full_fledged_A = mkA "经过充分训练" ;
lin full_length_A = mkA "全长" ; -- comment="完整" ;
lin full_page_A = mkA "整版" ;
lin full_scale_A = mkA "全面" ;
lin full_time_A = mkA "全职" ;
lin full_time_Adv = mkAdv "全日" ;
lin fullerene_N = mkN "富勒烯" ; -- open-multilingual-wordnet
lin fully_Adv = {-HSK-} mkAdv "满" | adjAdv full_A ; -- derived
lin fulminate_N = mkN "雷酸盐" ; -- open-multilingual-wordnet
lin fulmination_N = mkN "轰鸣" "" ;
lin fulsome_A = mkA "奉承" | mkA "油嘴" | mkA "油嘴滑舌" | mkA "爱说奉承话" | mkA "谄媚" | mkA "过分恭维" | mkA "过誉" | mkA "阿谀奉承" ; -- open-multilingual-wordnet
lin fumble_V = mkV "摸索" ; -- status=guess, src=wikt
lin fumble_V2 = mkV2 (mkV "摸索") ; -- status=guess, src=wikt
lin fume_N = mkN "烟" ;
lin fume_V = mkV "熏" | mkV "冒烟" ;
lin fume_VS = mkVS "发怒" ;
lin fumigant_N = mkN "熏蒸剂" | mkN "熏蒸消毒剂" | mkN "薰剂" ; -- open-multilingual-wordnet
lin fun_A = {-HSK-} mkA "娱乐" ;
lin fun_AV = L.fun_AV ;
lin fun_N = mkN "乐趣" | {-HSK-} mkN "娱乐" ;
lin funambulistFem_N = variants {} ; ---- sense to be split
lin funambulistMasc_N = variants {} ; ---- sense to be split
lin function_N = mkN "作用" | mkN "功能" ;
lin function_V = mkV "活动" ;
lin functional_A = mkA "功能" | {-HSK-} mkA "实用" ;
lin functionality_N = mkN "功能" | mkN "功能性" ; -- status=guess -- status=guess
lin functionary_N = mkN "职员" ;
lin functor_N = mkN "函子" ; -- status=guess
lin fund_N = mkN "基金" "支" ;
lin fund_V2 = mkV2 "投资" ;
lin fundamental_A = mkA "基本" | mkA "根本" ;
lin fundamental_N = mkN "基本" | mkN "根本" "個" | {-HSK-} mkN "根本" ;
lin fundamentalism_N = mkN "原教旨主义" ;
lin fundamentalist_A = mkA "基要主义" ; -- open-multilingual-wordnet
lin fundamentalist_N = mkN "信奉正统派基督教的人" ;
lin funding_N = {-HSK-} mkN "资金" ;
lin fundraising_N = mkN "籌款" | mkN "筹款" ; -- status=guess -- status=guess
lin funds_N = mkN "資金" | mkN "资金" | {-HSK-} mkN "项" | {-mwn-} mkN "财源" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin funeral_N = mkN "白" | {-HSK-} mkN "葬礼" "场" ;
lin funerary_A = mkA "葬礼" ; -- open-multilingual-wordnet
lin fungal_A = mkA "海绵状" | mkA "真菌" ; -- open-multilingual-wordnet
lin fungible_N = mkN "代替物" | mkN "替代品" ; -- open-multilingual-wordnet
lin fungicidal_A = mkA "抗真菌" ; -- open-multilingual-wordnet
lin fungicide_N = mkN "抗真菌药" | mkN "抗霉菌药" | mkN "杀真菌药" | mkN "杀菌剂" ; -- open-multilingual-wordnet
lin fungoid_A = mkA "菌类" ; -- open-multilingual-wordnet
lin fungous_A = mkA "海绵状" | mkA "真菌" ; -- open-multilingual-wordnet
lin fungus_N = mkN "真菌" ;
lin funicular_A = mkA "索道" ; -- open-multilingual-wordnet
lin funicular_N = mkN "纜索鐵路" | mkN "缆索铁路" | {-mwn-} mkN "缆车铁路" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin funiculitis_N = mkN "精索炎" ; -- open-multilingual-wordnet
lin funk_N = mkN "放克" | mkN "魂克" ; -- status=guess -- status=guess
lin funk_V = mkV "畏缩" | mkV "退却" | mkV "退缩" ; -- open-multilingual-wordnet
lin funnel_N = mkN "漏斗" ; -- status=guess
lin funnel_V2 = mkV2 "成漏斗形" ;
lin funny_A = mkA "滑稽" ;
lin fur_N = mkN "毛皮" "" ;
lin furbelow_N = mkN "荷叶边装饰" | mkN "裙饰" | mkN "褶裥花边" | mkN "褶襞" | mkN "边饰" ; -- open-multilingual-wordnet
lin furcation_N = mkN "分叉" | mkN "分歧" | mkN "叉形" ; -- open-multilingual-wordnet
lin furcula_N = mkN "鎖骨" | mkN "锁骨" ; -- status=guess -- status=guess
lin furious_A = mkA "激烈" ;
lin furl_V = mkV "卷收" | mkV "卷起" | mkV "叠" | mkV "收拢" ; -- open-multilingual-wordnet
lin furlough_N = mkN "休假" "次" ;
lin furnace_N = mkN "火炉" ; -- comment="熔炉" ;
lin furnish_V2 = mkV2 "提供" ;
lin furniture_N = mkN "家具" "件" ;
lin furore_N = mkN "狂热" "种" ;
lin furrier_N = mkN "皮货商" ;
lin furring_N = mkN "钉板条" ; -- open-multilingual-wordnet
lin furrow_N = mkN "壟溝" | mkN "垄沟" | mkN "溝" | mkN "沟" | {-mwn-} mkN "犁沟" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin furrow_V = mkV "耕" ;
lin furry_A = mkA "毛茸茸" ; -- status=guess
lin furth_PN = foreignPN "Furth" ; -- comment=src=geonames status=guess
lin further_A = mkA "进一步" ;
lin further_AdV = mkAdV "进一步" ;
lin further_Adv = mkAdv "进一步" ;
lin further_V2 = mkV2 "进一步" ;
lin furthermore_Adv = mkAdv "另外" | mkAdv "并且" | mkAdv "更" | mkAdv "此外" | mkAdv "而且" ;
lin furunculosis_N = mkN "疖病" ; -- open-multilingual-wordnet
lin fury_N = mkN "狂暴" ;
lin fuscous_A = mkA "暗褐色" | mkA "灰褐色" ; -- open-multilingual-wordnet
lin fuse_N = mkN "融合" ;
lin fuse_V = mkV "保融合" | {-HSK-} mkV "融化" ;
lin fuse_V2 = mkV2 "融化" | {-HSK-} mkV2 (mkV "熔化") | mkV2 (mkV "混合") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin fuselage_N = mkN "機身" | mkN "机身" ; -- status=guess -- status=guess
lin fushun_PN = mkPN "抚顺市" ; -- comment=src=geonames status=guess
lin fusil_N = mkN "明火枪" | mkN "燧发枪" | mkN "轻型燧发枪" ; -- open-multilingual-wordnet
lin fusillade_N = mkN "猛射" "顿" ;
lin fusion_N = mkN "聚变" "次" ;
lin fuss_N = variants {} ;
lin fuss_V = mkV "忙乱" ;
lin fussy_A = mkA "挑剔" | {-mwn-} mkA "挑剔" | mkA "爱挑剔" | mkA "过分周到" | mkA "过分注意" | mkA "过分讲究" ; -- status=guess -- open-multilingual-wordnet
lin fustian_N = mkN "纬起毛织物" ; -- open-multilingual-wordnet
lin futile_A = mkA "无用" ;
lin futility_N = mkN "无用" ;
lin futon_N = mkN "布團" | mkN "布团" | mkN "坐垫" | mkN "蒲團" | mkN "蒲团" | {-mwn-} mkN "床垫" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin future_1_N = {-mwn-} mkN "今后" | mkN "以后" | mkN "将来" | mkN "未来" ; -- open-multilingual-wordnet
lin future_3_N = variants {} ;
lin future_A = mkA "将来" | mkA "未来" ;
lin future_N = mkN "未来" ;
lin futurism_N = mkN "未來主義" | mkN "未来主义" ; -- status=guess -- status=guess
lin futuristFem_N = variants {} ; ---- sense to be split
lin futuristMasc_N = variants {} ; ---- sense to be split
lin futuristic_A = mkA "未来主义" ; -- open-multilingual-wordnet
lin futurology_N = mkN "未來學" | mkN "未来学" ; -- status=guess -- status=guess
lin fuzzy_A = mkA "模糊" | {-HSK-} mkA "毛绒绒" ;
lin fwd_PN = foreignPN "Fwd" ; -- comment=src=eng status=guess
lin g_N = mkN "英语字母的第七个字母" ;
lin gab_N = mkN "廢話" | mkN "废话" ; -- status=guess -- status=guess
lin gabardine_N = mkN "华达呢" | mkN "工作服" ; -- open-multilingual-wordnet
lin gabble_N = mkN "滔滔不绝" ;
lin gaberdine_N = mkN "华达呢" | mkN "工作服" ; -- open-multilingual-wordnet
lin gable_N = mkN "人字板_山形墙" ; -- open-multilingual-wordnet
lin gabon_PN = mkPN "加蓬" ; -- comment=src=geonames status=guess
lin gaddi_N = mkN "垫子" ; -- open-multilingual-wordnet
lin gadfly_N = mkN "牛虻" ; -- open-multilingual-wordnet
lin gadget_N = mkN "小配件" ;
lin gadoid_N = mkN "鳕科的鱼" ; -- open-multilingual-wordnet
lin gadolinite_N = mkN "硅铍钇矿" ; -- open-multilingual-wordnet
lin gadolinium_N = mkN "釓" | mkN "钆" ; -- status=guess -- status=guess
lin gaelic_A = mkA "盖尔语" ;
lin gaffe_N = mkN "過失" | mkN "过失" | mkN "出醜" | mkN "出丑" | {-mwn-} mkN "失态" | mkN "失礼" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin gaffer_N = mkN "膠布" | mkN "胶布" | mkN "電器膠帶" | mkN "电器胶带" | mkN "絕緣膠帶" | mkN "绝缘胶带" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin gaffsail_N = mkN "斜桁帆" ; -- open-multilingual-wordnet
lin gag_N = mkN "塞口之物" ; -- open-multilingual-wordnet
lin gain_N = mkN "好处" "個" | mkN "成果" "個" | {-HSK-} mkN "收益" ;
lin gain_V = mkV "获得" ;
lin gain_V2 = mkV2 "获得" ;
lin gain_back_V = advV OP_gain_V OP_back_Adv ; -- guess-p-verb
lin gainer_N = mkN "赢家" "位" ;
lin gainsborough_PN = foreignPN "Gainsborough" ; -- comment=src=geonames status=guess
lin gait_N = mkN "步法" ; -- status=guess
lin gala_N = mkN "祝贺" ;
lin galactagogue_N = mkN "催乳药" | mkN "催奶剂" ; -- open-multilingual-wordnet
lin galactic_A = mkA "星系" | mkA "银河系" ; -- open-multilingual-wordnet
lin galactocele_N = mkN "乳性囊性积液" ; -- open-multilingual-wordnet
lin galactose_N = mkN "半乳糖" ; -- open-multilingual-wordnet
lin galactosemia_N = mkN "半乳糖血" ; -- open-multilingual-wordnet
lin galactosis_N = mkN "乳汁分泌" | mkN "乳汁生成" ; -- open-multilingual-wordnet
lin galago_N = mkN "丛猴" ; -- open-multilingual-wordnet
lin galangal_N = mkN "高良薑" ; -- status=guess
lin galashiels_PN = foreignPN "Galashiels" ; -- comment=src=geonames status=guess
lin galaxy_N = mkN "银河" ;
lin galbanum_N = mkN "枫子香" ; -- open-multilingual-wordnet
lin gale_N = mkN "強風" | mkN "强风" ; -- status=guess -- status=guess
lin galea_N = mkN "盔瓣" ; -- open-multilingual-wordnet
lin galena_N = mkN "方铅矿" ; -- open-multilingual-wordnet
lin gall_N = mkN "胆汁" [] ;
lin gallant_A = mkA "英勇" ;
lin gallantry_N = mkN "勇敢" | mkN "英勇" | mkN "勇氣" | mkN "勇气" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin galleon_N = mkN "西班牙大帆船" ; -- status=guess
lin gallery_N = mkN "画廊" ;
lin galley_N = mkN "船上廚房" | mkN "船上厨房" ; -- status=guess -- status=guess
lin gallfly_N = mkN "五倍子虫" | mkN "瘿蚊" | mkN "瘿蜂" | mkN "瘿蝇" ; -- open-multilingual-wordnet
lin gallinaceous_A = mkA "家禽似" | mkA "鸡形目禽鸟" ; -- open-multilingual-wordnet
lin gallinule_N = mkN "番鸟" | mkN "秧鸡科水鸟" | mkN "骨顶鸡" | mkN "鹁类小鸟" ; -- open-multilingual-wordnet
lin gallium_N = mkN "镓" ;
lin gallon_N = mkN "加仑" [] ;
lin gallop_V = mkV "飞驰" ;
lin gallop_V2 = mkV2 (mkV "奔騰") | mkV2 (mkV "奔腾") | mkV2 (mkV "馳騁") | mkV2 (mkV "驰骋") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin galloway_PN = foreignPN "Galloway" ; -- comment=src=eng status=guess
lin gallows_N = mkN "絞刑架" | mkN "绞刑架" | mkN "絞台" | mkN "绞台" | {-mwn-} mkN "断头台" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin gallstone_N = mkN "胆石" ;
lin gallup_PN = foreignPN "Gallup" ; -- comment=src=geonames status=guess
lin galosh_N = mkN "套鞋" | mkN "膠鞋" | mkN "胶鞋" | {-mwn-} mkN "橡胶套鞋" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin galvanic_A = mkA "电流" ; -- open-multilingual-wordnet
lin galvanize_V2 = mkV2 "镀锌" ;
lin galvanize_VS = mkVS "镀锌" ;
lin galvanometer_N = mkN "检流计" | mkN "电流测定器" | mkN "电流计" ; -- open-multilingual-wordnet
lin galway_PN = foreignPN "Galway" ; -- comment=src=eng status=guess
lin gambia_PN = mkPN "冈比亚共和国" ; -- comment=src=geonames status=guess
lin gambit_N = mkN "话题" ;
lin gamble_N = mkN "赌博" "场" ;
lin gamble_V = mkV "赌博" ;
lin gamble_V2 = mkV2 (mkV "賭博") | mkV2 (mkV "赌博") | mkV2 (mkV "賭錢") | mkV2 (mkV "赌钱") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin gambler_N = mkN "赌徒" ;
lin gambling_N = mkN "赌博" "次" ;
lin gambrel_N = mkN "复折式屋顶" | mkN "斜折线屋顶" ; -- open-multilingual-wordnet
lin game_1_N = mkN "游戏" ;
lin game_2_N = mkN "游戏" ;
lin game_3_N = mkN "游戏" ;
lin game_A = mkA "勇敢" | {-HSK-} mkA "游戏" ;
lin game_N = mkN "游戏" ;
lin game_V = mkV "赌博" ;
lin game_V2 = mkV2 "使+玩游戏" ;
lin game_bag_N = mkN "狩猎袋" ; -- open-multilingual-wordnet
lin gamelan_N = mkN "甘美蘭" | mkN "甘美兰" ; -- status=guess -- status=guess
lin gametangium_N = mkN "配子囊" ; -- open-multilingual-wordnet
lin gametophore_N = mkN "配子托" | mkN "配子枝" ; -- open-multilingual-wordnet
lin gamma_N = mkN "伽马" ;
lin gammopathy_N = mkN "丙种球蛋白病" ; -- open-multilingual-wordnet
lin gamp_N = mkN "伞" ; -- open-multilingual-wordnet
lin gamut_N = mkN "域" ;
lin gander_N = mkN "雄鵝" | mkN "雄鹅" ; -- status=guess -- status=guess
lin gang_N = mkN "帮派" ;
lin ganglion_N = mkN "神经节" ;
lin gangrene_N = mkN "壞疽" | mkN "坏疽" ; -- status=guess -- status=guess
lin gangsaw_N = mkN "排锯" ; -- open-multilingual-wordnet
lin gangster_N = mkN "流氓" ;
lin gangway_N = mkN "通道" | {-mwn-} mkN "走道" | mkN "过道" ; -- status=guess -- open-multilingual-wordnet
lin gannet_N = mkN "塘鹅" | mkN "鲱鸟" ; -- open-multilingual-wordnet
lin ganoid_N = mkN "硬鳞鱼" ; -- open-multilingual-wordnet
lin ganoin_N = mkN "硬鳞层" ; -- open-multilingual-wordnet
lin gantry_N = mkN "龍門架" | mkN "龙门架" | mkN "跨貴信號架" | mkN "跨轨信号杆" | {-mwn-} mkN "木桶架" | mkN "构台" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin gap_N = mkN "差距" ;
lin gape_V = mkV "张开" ; -- comment="张开" ;
lin gar_N = mkN "尖颚鱼" | mkN "长颚鱼" ; -- open-multilingual-wordnet
lin garage_N = mkN "车库" ;
lin garb_N = mkN "打扮" | mkN "服装" | mkN "穿衣" | mkN "衣着" ; -- open-multilingual-wordnet
lin garbage_N = mkN "垃圾" ;
lin garboard_N = mkN "龙骨翼板" ; -- open-multilingual-wordnet
lin garden_N = L.garden_N | {-HSK-} mkN "花园" "座" ;
lin garden_V = mkV "种" ;
lin gardenerFem_N = mkN "园丁" "位" ;
lin gardenerMasc_N = mkN "园丁" "位" ;
lin gardenia_N = mkN "梔子" | mkN "栀子" | {-mwn-} mkN "山栀" | mkN "白蟾" | mkN "黄栀子" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gardening_N = mkN "园艺" ;
lin gareth_PN = foreignPN "Gareth" ; -- comment=src=eng status=guess
lin garforth_PN = foreignPN "Garforth" ; -- comment=src=geonames status=guess
lin gargantuan_A = mkA "庞大" ;
lin gargle_V = mkV "漱口" | mkV "漱" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin gargle_V2 = mkV2 (mkV "漱口") | mkV2 (mkV "漱") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin gargoyle_N = mkN "石像鬼" | mkN "石像鬼" | {-mwn-} mkN "笕嘴" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin garish_A = mkA "炫耀" ;
lin garland_N = mkN "茼蒿" ; -- status=guess
lin garlic_N = {-mwn-} mkN "大蒜" | mkN "蒜头" ; -- open-multilingual-wordnet
lin garlicky_A = mkA "如大蒜" | mkA "有蒜臭味" ; -- open-multilingual-wordnet
lin garment_N = mkN "服装" "套" ;
lin garner_V2 = mkV2 "存储" ;
lin garnet_N = mkN "石榴石" ; -- status=guess -- open-multilingual-wordnet
lin garnierite_N = mkN "硅镁镍矿" ; -- open-multilingual-wordnet
lin garret_N = mkN "閣樓" | mkN "阁楼" ; -- status=guess -- status=guess
lin garrison_N = mkN "要塞" ;
lin garrowhill_PN = foreignPN "Garrowhill" ; -- comment=src=eng status=guess
lin garrulous_A = mkA "喋喋不休" | {-mwn-} mkA "多嘴" | mkA "爱讲闲话" | mkA "贫嘴" | mkA "饶舌" ; -- status=guess -- open-multilingual-wordnet
lin garter_N = mkN "襪帶" | mkN "袜带" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gary_PN = mkPN "加里" ; -- comment=src=geonames status=guess
lin gas_N = mkN "气体" | {-HSK-} mkN "汽油" "升" ;
lin gas_station_N = mkN "加油站" ;
lin gasbag_N = mkN "气囊" ; -- open-multilingual-wordnet
lin gaseous_A = mkA "气态" ;
lin gasification_N = mkN "气化" | mkN "气化过程" ; -- open-multilingual-wordnet
lin gasify_V = mkV "氣化" | mkV "气化" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin gasify_V2 = mkV2 (mkV "氣化") | mkV2 (mkV "气化") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin gasket_N = mkN "墊片" | mkN "垫片" | {-mwn-} mkN "密封垫" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gaskin_N = mkN "胚部" ; -- open-multilingual-wordnet
lin gaslight_N = mkN "煤氣燈" | mkN "煤气灯" ; -- status=guess -- status=guess
lin gas_mask_N = mkN "防毒面具" ; -- open-multilingual-wordnet
lin gasohol_N = mkN "汽油醇" ; -- open-multilingual-wordnet
lin gasoline_N = mkN "汽油" | {-HSK-} mkN "汽油" "升" ;
lin gasp_V = mkV "气喘吁吁的说" ;
lin gasp_V2 = mkV2 "喘气" ;
lin gasteromycete_N = mkN "腹菌" ; -- open-multilingual-wordnet
lin gastric_A = mkA "胃部" ;
lin gastritis_N = mkN "胃炎" ; -- status=guess -- open-multilingual-wordnet
lin gastroenteritis_N = mkN "胃腸炎" | mkN "胃肠炎" ; -- status=guess -- status=guess
lin gastroenterologistFem_N = variants {} ; ---- sense to be split
lin gastroenterologistMasc_N = variants {} ; ---- sense to be split
lin gastroenterology_N = mkN "腸胃科" | mkN "肠胃科" ; -- status=guess -- status=guess
lin gastroesophageal_A = mkA "胃食管" | mkA "胃食道" ; -- open-multilingual-wordnet
lin gastronomic_A = mkA "烹任学" ; -- open-multilingual-wordnet
lin gastronomy_N = mkN "美食學" | mkN "美食学" | mkN "烹飪法" | mkN "烹饪法" | mkN "美食法" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin gastropod_N = mkN "单壳软体动物" | mkN "腹足动物" | mkN "腹足类动物" | mkN "腹足纲软体动物" ; -- open-multilingual-wordnet
lin gastroscope_N = mkN "胃窥器" | mkN "胃镜" ; -- open-multilingual-wordnet
lin gastrulation_N = mkN "原肠胚形成" ; -- open-multilingual-wordnet
lin gasworks_N = mkN "煤气厂" ; -- open-multilingual-wordnet
lin gat_N = mkN "手枪" ; -- open-multilingual-wordnet
lin gate_N = mkN "门" ;
lin gate_V2 = mkV2 "使+装大门" ;
lin gateau_N = mkN "奶油水果大蛋糕" ; -- status=guess
lin gatehouse_N = mkN "警卫室" ; -- open-multilingual-wordnet
lin gatepost_N = mkN "门柱" ; -- open-multilingual-wordnet
lin gateshead_PN = mkPN "蓋茨黑德" ; -- comment=src=geonames status=guess
lin gateway_N = mkN "网关" | {-HSK-} mkN "门" ;
lin gather_N = mkN "聚集""次" ;
lin gather_V = mkV "会" | mkV "捡" | mkV "集合" | {-HSK-} mkV "收集" ;
lin gather_V2 = mkV2 "会" | mkV2 "捡" | mkV2 "集合" | {-HSK-} mkV2 "收集" ;
lin gatherer_N = mkN "收集器" ;
lin gathering_N = mkN "聚会" | {-HSK-} mkN "集会" "次" ;
lin gauche_A = mkA "粗魯" ; -- status=guess
lin gaucherie_N = mkN "出丑" | mkN "失态" | mkN "失礼" ; -- open-multilingual-wordnet
lin gaudy_A = mkA "花哨" | mkA "俗麗" | mkA "俗丽" | {-mwn-} mkA "俗丽" | mkA "华而不实" | mkA "浮华" | mkA "炫耀" | mkA "绚丽" | mkA "艳丽" | mkA "花哨" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin gauge_N = mkN "标准度量" ;
lin gauge_V2 = mkV2 "估计" ;
lin gaunt_A = mkA "瘦削" ; -- status=guess
lin gauze_N = mkN "纱布" "块" ;
lin gavel_N = mkN "槌" ; -- open-multilingual-wordnet
lin gavial_N = mkN "恒河鱷" | mkN "恒河鳄" ; -- status=guess -- status=guess
lin gavin_PN = foreignPN "Gavin" ; -- comment=src=eng status=guess
lin gawky_A = mkA "笨拙" ;
lin gawp_V = mkV "痴呆着看" | mkV "直瞪瞪地注视" | mkV "眼睛睁视" ; -- open-multilingual-wordnet
lin gay_A = mkA "同性恋" | {-HSK-} mkA "春" ;
lin gay_N = mkN "同志" | mkN "同性戀者" | mkN "同性恋者" | {-HSK-} mkN "春" ; -- status=guess -- status=guess -- status=guess
lin gaze_N = mkN "凝视" "次" ;
lin gaze_V = mkV "凝视" ;
lin gazebo_N = mkN "凉亭" | mkN "观景亭" ; -- open-multilingual-wordnet
lin gazelle_N = mkN "羚羊" | {-mwn-} mkN "瞪羚" ; -- status=guess -- open-multilingual-wordnet
lin gazette_N = mkN "公报""份" ;
lin gazette_V2 = mkV2 "使+在报上刊载" ;
lin gazetteer_N = mkN "地名辞典" ; -- status=guess
lin gb_PN = foreignPN "Gb" ; -- comment=src=eng status=guess
lin gdansk_PN = foreignPN "Gdansk" ; -- comment=src=eng status=guess
lin gdn_PN = foreignPN "Gdn" ; -- comment=src=eng status=guess
lin gdns_PN = foreignPN "Gdns" ; -- comment=src=eng status=guess
lin gean_N = mkN "欧洲甜樱桃" | mkN "洋樱桃" ; -- open-multilingual-wordnet
lin gear_N = mkN "挡" | {-HSK-} mkN "齿轮" ;
lin gear_V = mkV "开始" ;
lin gear_V2 = mkV2 "安排" ;
lin gearbox_N = mkN "變速器" | mkN "变速器" | {-mwn-} mkN "齿轮箱" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gearing_N = mkN "传动系" | mkN "传动装置" | mkN "档" | mkN "齿轮装置" ; -- open-multilingual-wordnet
lin gecko_N = mkN "壁虎" ; -- status=guess
lin geek_N = mkN "極客" | mkN "极客" | mkN "宅男" | mkN "宅女" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin geezer_N = mkN "老拙" | mkN "老頭" | mkN "老头" | mkN "老頭子" | mkN "老头子" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin geisha_N = mkN "藝妓" | mkN "艺妓" | mkN "藝伎" | mkN "艺伎" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin gel_N = mkN "凝膠" | mkN "凝胶" ; -- status=guess -- status=guess
lin gelatin_N = mkN "明胶" ;
lin gelatine_N = mkN "明膠" | mkN "明胶" | mkN "吉利丁" | {-mwn-} mkN "动物胶" | mkN "骨胶" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin gelatinous_A = mkA "膠狀" | mkA "胶状" | mkA "膠質" | mkA "胶质" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin gelding_N = mkN "騸馬" | mkN "骟马" ; -- status=guess -- status=guess
lin gelechiid_N = mkN "麦蛾" ; -- open-multilingual-wordnet
lin gelignite_N = mkN "吉里那特" | mkN "炸胶" | mkN "爆炸胶" | mkN "硝铵炸药" | mkN "葛里炸药" ; -- open-multilingual-wordnet
lin gelligaer_PN = foreignPN "Gelligaer" ; -- comment=src=geonames status=guess
lin gelsenkirchen_PN = mkPN "盖尔森基兴" ; -- comment=src=geonames status=guess
lin gem_N = mkN "宝石" ;
lin gemini_PN = foreignPN "Gemini" ; -- comment=src=geonames status=guess
lin gemmiferous_A = mkA "发芽" | mkA "发芽生殖" | mkA "生芽" ; -- open-multilingual-wordnet
lin gempylid_N = mkN "蛇鲭鱼" ; -- open-multilingual-wordnet
lin gen_PN = foreignPN "Gen" ; -- comment=src=eng status=guess
lin gendarme_N = mkN "宪兵" "个" ;
lin gender_1_N = mkN "性别" ;
lin gender_2_N = mkN "性别" ;
lin gene_N = mkN "基因" ;
lin gene_PN = foreignPN "Gene" ; -- comment=src=eng status=guess
lin genealogic_A = mkA "宗谱" | mkA "系谱" ; -- open-multilingual-wordnet
lin genealogical_A = mkA "宗谱" | mkA "系谱" ; -- open-multilingual-wordnet
lin general_A = mkA "一般" | {-HSK-} mkA "普遍" ;
lin general_N = mkN "一般" | mkN "普遍" | {-HSK-} mkN "将领" ;
lin generalissimo_N = mkN "大元帥" | mkN "大元帅" ; -- status=guess -- status=guess
lin generalization_N = mkN "泛化" ;
lin generalize_V = mkV "概括" ;
lin generalize_V2 = mkV2 "概括" | {-HSK-} mkV2 (mkV "普遍化") ; -- status=guess, src=wikt
lin generally_Adv = {-HSK-} mkAdv "一般" | adjAdv general_A ; -- derived
lin generate_V2 = mkV2 "产生" ;
lin generation_N = mkN "一代" | {-HSK-} mkN "产生" ;
lin generational_A = mkA "一代" | mkA "世代" ; -- open-multilingual-wordnet
lin generative_A = mkA "有生产力" | mkA "能生产" ; -- open-multilingual-wordnet
lin generator_N = mkN "发电机" ;
lin generic_A = mkA "通用" ;
lin generosity_N = mkN "宽厚" ; -- status=guess
lin generous_A = mkA "厚" | {-HSK-} mkA "大方" ;
lin genesis_N = mkN "起源" ;
lin genet_N = mkN "獛" ; -- status=guess
lin genetic_A = mkA "基因" ;
lin geneticist_N = mkN "遗传学家" ;
lin genetics_N = mkN "遺傳學" | mkN "遗传学" ; -- status=guess -- status=guess
lin geneva_PN = foreignPN "Geneva" ; -- comment=src=geonames status=guess
lin genial_A = mkA "亲切" ; -- comment="友好" ;
lin genic_A = mkA "基因" | mkA "由基因引起" | mkA "遗传因子" ; -- open-multilingual-wordnet
lin geniculate_A = mkA "弯曲成膝状" ; -- open-multilingual-wordnet
lin genie_N = mkN "妖怪" ;
lin genital_A = mkA "生殖" ;
lin genitalia_N = mkN "生殖器" | mkN "外生殖器" | mkN "陰部" | mkN "阴部" | {-HSK-} mkN "阴" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin genitive_A = mkA "所有" | {-mwn-} mkA "所有" ; -- status=guess -- open-multilingual-wordnet
lin genitive_N = mkN "屬格" | mkN "属格" | mkN "所有格" ; -- status=guess -- status=guess -- status=guess
lin genius_N = mkN "天才" ;
lin genius_loci_N = mkN "土地" "片" | {-HSK-} mkN "守护神" ;
lin genlisea_N = mkN "螺旋狸藻" | mkN "金雀花" ; -- open-multilingual-wordnet
lin genoa_PN = foreignPN "Genoa" ; -- comment=src=geonames status=guess
lin genocide_N = mkN "种族灭绝" ;
lin genome_N = mkN "基因組" | mkN "基因组" | mkN "基因體" | mkN "基因体" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin genomics_N = mkN "基因组学" ; -- status=guess
lin genotype_N = mkN "基因型" ; -- status=guess
lin genotypical_A = mkA "基因型" ; -- open-multilingual-wordnet
lin genova_PN = foreignPN "Genova" ; -- comment=src=eng status=guess
lin genre_N = mkN "类型" ;
lin gentamicin_N = mkN "庆大霉素" ; -- status=guess -- status=guess
lin genteel_A = mkA "文雅" ;
lin gentile_A = mkA "非犹太人" ;
lin gentility_N = mkN "文雅" ;
lin gentle_A = mkA "温和" | {-HSK-} mkA "轻" | mkA "轻松" ;
lin gentleman_N = mkN "绅士" ;
lin gentleness_N = mkN "温柔" ;
lin gentry_N = mkN "人们" ;
lin genuine_A = mkA "地道" | mkA "真" | mkA "真正" ;
lin genus_N = mkN "屬" | mkN "属" ; -- status=guess -- status=guess
lin geochemistry_N = mkN "地球化學" | mkN "地球化学" ; -- status=guess -- status=guess
lin geode_N = mkN "晶洞" ;
lin geodesic_N = mkN "大地线" | mkN "最短程线" | mkN "测地线" ; -- open-multilingual-wordnet
lin geodesy_N = mkN "大地測量學" | mkN "大地测量学" | mkN "測地學" | mkN "测地学" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin geodetic_A = mkA "测地学" | mkA "测地线" | mkA "测量" ; -- open-multilingual-wordnet
lin geoduck_N = mkN "象拔蚌" | mkN "太平洋潛泥蛤" | mkN "太平洋潜泥蛤" | mkN "皇帝蚌" | mkN "女神蛤" | {-mwn-} mkN "大文蛤" | mkN "陆蛤" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin geoff_PN = foreignPN "Geoff" ; -- comment=src=eng status=guess
lin geoffrey_PN = foreignPN "Geoffrey" ; -- comment=src=eng status=guess
lin geographer_N = mkN "地理學家" | mkN "地理学家" ; -- status=guess -- status=guess
lin geographical_A = mkA "地理" ;
lin geography_N = mkN "地理" ;
lin geological_A = mkA "地质" ;
lin geologistFem_N = variants {} ; ---- sense to be split
lin geologistMasc_N = variants {} ; ---- sense to be split
lin geology_N = mkN "地质学" ;
lin geometric_A = mkA "几何学" ;
lin geometrical_A = mkA "几何" ;
lin geometrid_N = mkN "尺蠖蛾" ; -- open-multilingual-wordnet
lin geometry_N = mkN "几何学" [] ;
lin geomorphologic_A = mkA "地形学" | mkA "形态学" ; -- open-multilingual-wordnet
lin geophysical_A = mkA "地球物理学" ; -- open-multilingual-wordnet
lin geophysics_N = mkN "地球物理學" | mkN "地球物理学" ; -- status=guess -- status=guess
lin geophyte_N = mkN "地下芽植物" ; -- open-multilingual-wordnet
lin geophytic_A = mkA "地下芽植物" ; -- open-multilingual-wordnet
lin geopolitical_A = mkA "地缘政治学" ; -- open-multilingual-wordnet
lin geopolitics_N = mkN "地緣政治學" | mkN "地缘政治学" ; -- status=guess -- status=guess
lin george_PN = mkPN "喬治" ; -- comment=src=geonames status=guess
lin georgette_N = mkN "乔其纱" ; -- open-multilingual-wordnet
lin georgia_PN = mkPN "格鲁吉亚" ;
lin georgian_A = mkA "格鲁吉亚" ;
lin georgie_PN = foreignPN "Georgie" ; -- comment=src=eng status=guess
lin geostrategic_A = mkA "地缘政治学" ; -- open-multilingual-wordnet
lin geothermal_A = mkA "地温" | mkA "地热" ; -- open-multilingual-wordnet
lin gerald_PN = foreignPN "Gerald" ; -- comment=src=geonames status=guess
lin geraldine_PN = foreignPN "Geraldine" ; -- comment=src=eng status=guess
lin geranium_N = mkN "天竺葵" | mkN "洋绣球" ; -- open-multilingual-wordnet
lin gerard_PN = foreignPN "Gerard" ; -- comment=src=eng status=guess
lin gerbil_N = mkN "沙鼠" ; -- status=guess -- open-multilingual-wordnet
lin geriatric_A = mkA "老人医学" | mkA "老年医学" | mkA "老年学" | mkA "老年病学" ; -- open-multilingual-wordnet
lin geriatrics_N = mkN "老年病學" | mkN "老年病学" ; -- status=guess -- status=guess
lin germ_N = mkN "胚芽" ;
lin germanFem_N = variants {} ;
lin germanMasc_N = variants {} ;
lin german_A = mkA "德语" ;
lin germander_N = mkN "石蚕属植物" ; -- open-multilingual-wordnet
lin germaneness_N = mkN "恰当" | mkN "有关" ; -- open-multilingual-wordnet
lin germanite_N = mkN "亚锗酸盐" | mkN "锗石" ; -- open-multilingual-wordnet
lin germanium_N = mkN "鍺" | mkN "锗" ; -- status=guess -- status=guess
lin germany_PN = mkPN "德国" ;
lin germfree_A = mkA "无外来污染" | mkA "无菌" | mkA "没细菌" ; -- open-multilingual-wordnet
lin germinate_V = mkV "使发芽" | mkV "发芽" | mkV "抽条" | mkV "萌芽" ; -- open-multilingual-wordnet
lin germy_A = mkA "不洁" | mkA "受细菌感染" | mkA "带有细菌" ; -- open-multilingual-wordnet
lin gerry_PN = foreignPN "Gerry" ; -- comment=src=eng status=guess
lin gertie_PN = foreignPN "Gertie" ; -- comment=src=eng status=guess
lin gertrude_PN = foreignPN "Gertrude" ; -- comment=src=eng status=guess
lin gerund_N = mkN "動名詞" | mkN "动名词" ; -- status=guess -- status=guess
lin gerundial_A = mkA "动名词" ; -- open-multilingual-wordnet
lin gesneria_N = mkN "苦苣苔属植物" ; -- open-multilingual-wordnet
lin gesneriad_N = mkN "苦苣苔类" ; -- open-multilingual-wordnet
lin gestational_A = mkA "妊娠" | mkA "妊娠期" ; -- open-multilingual-wordnet
lin gesture_N = mkN "手势" ;
lin gesture_V = mkV "做手势" | {-HSK-} mkV "比" ;
lin get_N = mkN "生殖" "" ; ---- ??
lin get_V2 = mkV2 "收到" ;
lin get_V2V = mkV2V "取" | mkV2V "获得" | {-HSK-} mkV2V "得到" ;
lin get_VV = mkVV "取" | mkVV "获得" | {-HSK-} mkVV "得到" ;
lin get_about_V = advV (lin V OP_get_V2) OP_about_Adv ; -- guess-p-verb
lin get_above_V2 = prepV2 (lin V OP_get_V2) OP_above_Prep ; -- guess-p-verb
lin get_across_V = advV (lin V OP_get_V2) OP_across_Adv ; -- guess-p-verb
lin get_across_V2 = prepV2 (lin V OP_get_V2) OP_across_Prep ; -- guess-p-verb
lin get_across_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_across_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_after_V2 = prepV2 (lin V OP_get_V2) OP_after_Prep ; -- guess-p-verb
lin get_ahead_V = advV (lin V OP_get_V2) OP_ahead_Adv ; -- guess-p-verb
lin get_ahead_of_V2 = prepV2 (advV (lin V OP_get_V2) OP_ahead_Adv ) OP_of_Prep ; -- guess-p-verb
lin get_along_V = mkV "过" ;
lin get_along_in_V2 = prepV2 (advV (lin V OP_get_V2) OP_along_Adv ) OP_in_Prep ; -- guess-p-verb
lin get_along_with_V2 = mkV2 "与" ;
lin get_around_V = advV (lin V OP_get_V2) OP_around_Adv ; -- guess-p-verb
lin get_around_V2 = prepV2 (lin V OP_get_V2) OP_around_Prep ; -- guess-p-verb
lin get_around_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_around_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_at_V2 = prepV2 (lin V OP_get_V2) OP_at_Prep ; -- guess-p-verb
lin get_away_V = advV (lin V OP_get_V2) OP_away_Adv ; -- guess-p-verb
lin get_away_from_V2 = mkV2 "脱" ;
lin get_away_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_away_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_back_V = advV (lin V OP_get_V2) OP_back_Adv ; -- guess-p-verb
lin get_back_V2 = mkV2 (advV (lin V OP_get_V2) OP_back_Adv ) ; -- guess-p-verb
lin get_back_at_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_at_Prep ; -- guess-p-verb
lin get_back_into_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_into_Prep ; -- guess-p-verb
lin get_back_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_back_together_V = variants {} ; -- guess-p-verb
lin get_behind_V2 = prepV2 (lin V OP_get_V2) OP_behind_Prep ; -- guess-p-verb
lin get_behind_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_behind_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_by_V = mkV "办理" | mkV "处理" | mkV "对付" | mkV "设法" | mkV "设法对付" ; -- open-multilingual-wordnet
lin get_by_V2 = prepV2 (lin V OP_get_V2) OP_by_Prep ; -- guess-p-verb
lin get_by_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_by_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_by_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_by_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_down_V = advV (lin V OP_get_V2) OP_down_Adv ; -- guess-p-verb
lin get_down_V2 = prepV2 (lin V OP_get_V2) OP_down_Prep ; -- guess-p-verb
lin get_down_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_down_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_down_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_even_V = advV (lin V OP_get_V2) OP_even_Adv ; -- guess-p-verb
lin get_in_V = advV (lin V OP_get_V2) OP_in_Adv ; -- guess-p-verb
lin get_in_V2 = prepV2 (lin V OP_get_V2) OP_in_Prep ; -- guess-p-verb
lin get_in_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_in_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_into_V2 = prepV2 (lin V OP_get_V2) OP_into_Prep ; -- guess-p-verb
lin get_it_V = variants {} ; -- guess-p-verb
lin get_it_off_V = variants {} ; -- guess-p-verb
lin get_it_off_with_V2 = variants {} ; -- guess-p-verb
lin get_it_on_V = variants {} ; -- guess-p-verb
lin get_it_on_with_V2 = variants {} ; -- guess-p-verb
lin get_it_together_V = variants {} ; -- guess-p-verb
lin get_it_up_V = variants {} ; -- guess-p-verb
lin get_off_V = advV (lin V OP_get_V2) OP_off_Adv ; -- guess-p-verb
lin get_off_V2 = prepV2 (lin V OP_get_V2) OP_off_Prep ; -- guess-p-verb
lin get_off_it_V2 = variants {} ; -- guess-p-verb
lin get_off_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_off_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_off_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_on_1_V2 = variants {} ; -- guess-p-verb
lin get_on_2_V2 = variants {} ; -- guess-p-verb
lin get_on_V = advV (lin V OP_get_V2) OP_on_Adv ; -- guess-p-verb
lin get_on_at_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_at_Prep ; -- guess-p-verb
lin get_on_for_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_for_Prep ; -- guess-p-verb
lin get_on_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_on_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_onto_V2 = prepV2 (lin V OP_get_V2) OP_onto_Prep ; -- guess-p-verb
lin get_out_V = advV (lin V OP_get_V2) OP_out_Adv ; -- guess-p-verb
lin get_out_V2 = prepV2 (lin V OP_get_V2) OP_out_Prep ; -- guess-p-verb
lin get_out_of_V2 = prepV2 (advV (lin V OP_get_V2) OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin get_over_V = advV (lin V OP_get_V2) OP_over_Adv ; -- guess-p-verb
lin get_over_V2 = prepV2 (lin V OP_get_V2) OP_over_Prep ; -- guess-p-verb
lin get_over_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_over_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_round_V = advV (lin V OP_get_V2) OP_round_Adv ; -- guess-p-verb
lin get_round_V2 = prepV2 (lin V OP_get_V2) OP_round_Prep ; -- guess-p-verb
lin get_round_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_round_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_through_V = mkV "通过" ;
lin get_through_V2 = mkV2 "通过" ;
lin get_through_V3 = mkV3 "通过" ;
lin get_through_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_through_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_to_V2 = prepV2 (lin V OP_get_V2) OP_to_Prep ; -- guess-p-verb
lin get_together_V = mkV "聚会" ;
lin get_up_V = mkV "起床" ;
lin get_up_V2 = mkV2 "起床" ;
lin get_up_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin geyser_N = mkN "喷泉" "汪" ;
lin ghana_PN = mkPN "加纳" ; -- comment=src=geonames status=guess
lin gharry_N = mkN "出租马车" ; -- open-multilingual-wordnet
lin ghastly_A = mkA "阴森" ;
lin ghatti_N = mkN "轧的树胶" ; -- open-multilingual-wordnet
lin ghee_N = mkN "酥油" | mkN "液體黃油" | mkN "液体黄油" ; -- status=guess -- status=guess -- status=guess
lin ghent_PN = foreignPN "Ghent" ; -- comment=src=eng status=guess
lin gherkin_N = mkN "小黃瓜" | mkN "小黄瓜" ; -- status=guess -- status=guess
lin ghetto_N = mkN "贫民区" ;
lin ghillie_N = mkN "活结无舌鞋" ; -- open-multilingual-wordnet
lin ghost_N = mkN "幽灵" ;
lin ghostly_A = mkA "幽灵" ;
lin ghost_writer_N = mkN "捉刀手" | mkN "代筆者" | mkN "代笔者" | {-mwn-} mkN "代笔人" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin ghoul_N = mkN "食屍鬼" | mkN "食尸鬼" ; -- status=guess -- status=guess
lin ghq_PN = foreignPN "Ghq" ; -- comment=src=eng status=guess
lin giant_A = variants {} ;
lin giant_N = mkN "巨人" ;
lin giardiasis_N = mkN "肠梨形鞭虫病" ; -- open-multilingual-wordnet
lin gib_N = mkN "阉猫" ; -- open-multilingual-wordnet
lin gibberellin_N = mkN "赤霉素" ; -- open-multilingual-wordnet
lin gibberish_N = mkN "胡言乱语" ;
lin gibbon_N = mkN "長臂猿" | mkN "长臂猿" ; -- status=guess -- status=guess
lin gibbsite_N = mkN "三水铝矿" ; -- open-multilingual-wordnet
lin gibingly_Adv = mkAdv "取笑+地" | mkAdv "嘲弄+地" | mkAdv "嘲笑+地" ; -- open-multilingual-wordnet
lin giblet_N = mkN "雜碎" | mkN "杂碎" ; -- status=guess -- status=guess
lin gibraltar_PN = mkPN "直布罗陀" ; -- comment=src=geonames status=guess
lin giddy_A = mkA "头晕" | {-HSK-} mkA "晕" ;
lin giffnock_PN = foreignPN "Giffnock" ; -- comment=src=geonames status=guess
lin gift_N = mkN "才" | mkN "礼物" "件" | {-HSK-} mkN "礼物" ;
lin gift_V2 = mkV2 "礼物" ;
lin gig_N = mkN "旋转物" ;
lin gigabyte_N = mkN "千兆字節" | mkN "千兆字节" ; -- status=guess -- status=guess
lin gigantic_A = mkA "巨大" ;
lin giggle_N = mkN "傻笑" ;
lin giggle_V = mkV "傻笑" | mkV "痴笑" | mkV "嘻" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin gigolo_N = mkN "舞男" ;
lin gilbert_PN = mkPN "吉尔伯特" ; -- comment=src=geonames status=guess
lin gild_N = mkN "俱乐部" | mkN "团体" ; -- open-multilingual-wordnet
lin gild_V2 = mkV2 "镀金" ;
lin gilding_N = mkN "镀金" ;
lin giles_PN = foreignPN "Giles" ; -- comment=src=eng status=guess
lin gilfach_goch_PN = foreignPN "Gilfach goch" ; -- comment=src=eng status=guess
lin gill_N = mkN "鰓" | mkN "鳃" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gill_PN = foreignPN "Gill" ; -- comment=src=geonames status=guess
lin gillian_PN = foreignPN "Gillian" ; -- comment=src=eng status=guess
lin gillie_N = mkN "活结无舌鞋" ; -- open-multilingual-wordnet
lin gillingham_PN = foreignPN "Gillingham" ; -- comment=src=geonames status=guess
lin gilt_N = mkN "镀金" ;
lin gimbal_N = mkN "平衡环" ; -- open-multilingual-wordnet
lin gimbaled_A = mkA "装有万向接头" ; -- open-multilingual-wordnet
lin gimmick_N = mkN "花招" "个" ;
lin gin_N = mkN "杜松子酒" ;
lin gina_PN = foreignPN "Gina" ; -- comment=src=eng status=guess
lin ginger_A = mkA "姜" ;
lin ginger_N = mkN "姜" ;
lin gingerbread_N = mkN "薑餅" | mkN "姜饼" ; -- status=guess -- status=guess
lin gingerly_A = mkA "小心翼翼" ;
lin gingerol_N = mkN "姜辣素" ; -- open-multilingual-wordnet
lin gingery_A = mkA "姜色" | mkA "姜黄色" | mkA "淡赤黄色" ; -- open-multilingual-wordnet
lin gingham_N = mkN "条纹棉布" ; -- open-multilingual-wordnet
lin gingival_A = mkA "齿龈" ; -- open-multilingual-wordnet
lin gingivitis_N = mkN "牙齦炎" | mkN "牙龈炎" | {-mwn-} mkN "齿龈炎" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gingko_N = mkN "銀杏" | mkN "银杏" ; -- status=guess -- status=guess
lin ginkgo_N = mkN "銀杏" | mkN "银杏" ; -- status=guess -- status=guess
lin ginseng_N = mkN "人参" ;
lin gipsyFem_N = variants {} ; ---- sense to be split
lin gipsyMasc_N = variants {} ; ---- sense to be split
lin giraffe_N = mkN "長頸鹿" | mkN "长颈鹿" ; -- status=guess -- status=guess
lin girandole_N = mkN "旋转喷火" | mkN "旋转烟火" | mkN "装饰烛台" ; -- open-multilingual-wordnet
lin gird_V = mkV "准备" ;
lin girder_N = mkN "梁" ;
lin girdle_N = mkN "带" "條" | {-mwn-} mkN "紧身内衣" | mkN "紧身褡" ; -- open-multilingual-wordnet
lin girl_N = L.girl_N | {-HSK-} mkN "姑娘" "個" ;
lin girlfriend_N = mkN "女朋友" | {-HSK-} mkN "对象" "個" ;
lin girlish_A = mkA "少女" ; -- status=guess
lin girth_N = mkN "束马鞍肚带" ; -- open-multilingual-wordnet
lin girvan_PN = foreignPN "Girvan" ; -- comment=src=geonames status=guess
lin gist_N = mkN "主旨" | {-HSK-} mkN "精神" "個" ;
lin give_N = mkN "弹性""" ;
lin give_V = mkV "与" | mkV "给" ;
lin give_V2 = mkV2 "与" | mkV2 "给" ;
lin give_V3 = L.give_V3 | {-HSK-} mkV3 "与" | mkV3 "给" ;
lin give_away_V = advV OP_give_V OP_away_Adv ; -- guess-p-verb
lin give_away_V2 = mkV2 (advV OP_give_V OP_away_Adv ) ; -- guess-p-verb
lin give_back_V2 = mkV2 (advV OP_give_V OP_back_Adv ) ; -- guess-p-verb
lin give_in_V = advV OP_give_V OP_in_Adv ; -- guess-p-verb
lin give_in_V2 = prepV2 OP_give_V OP_in_Prep ; -- guess-p-verb
lin give_in_to_V2 = prepV2 (advV OP_give_V OP_in_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_it_to_V2 = variants {} ; -- guess-p-verb
lin give_it_up_for_V2 = variants {} ; -- guess-p-verb
lin give_it_up_to_V2 = variants {} ; -- guess-p-verb
lin give_of_V2 = prepV2 OP_give_V OP_of_Prep ; -- guess-p-verb
lin give_off_V = advV OP_give_V OP_off_Adv ; -- guess-p-verb
lin give_off_V2 = prepV2 OP_give_V OP_off_Prep ; -- guess-p-verb
lin give_onto_V2 = prepV2 OP_give_V OP_onto_Prep ; -- guess-p-verb
lin give_out_V = advV OP_give_V OP_out_Adv ; -- guess-p-verb
lin give_out_V2 = prepV2 OP_give_V OP_out_Prep ; -- guess-p-verb
lin give_over_V = advV OP_give_V OP_over_Adv ; -- guess-p-verb
lin give_over_V2 = prepV2 OP_give_V OP_over_Prep ; -- guess-p-verb
lin give_over_to_V3 = variants {} ; -- guess-p-verb
lin give_up_V = mkV "放弃" | {-mwn-} mkV "抛弃" ; -- open-multilingual-wordnet
lin give_up_V2 = mkV2 "放弃" ;
lin give_up_on_V2 = prepV2 (advV OP_give_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin give_up_to_V2 = prepV2 (advV OP_give_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_way_V = advV OP_give_V OP_way_Adv ; -- guess-p-verb
lin give_way_to_V2 = prepV2 (advV OP_give_V OP_way_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_yourself_up_V = variants {} ; -- guess-p-verb
lin give_yourself_up_to_V2 = variants {} ; -- guess-p-verb
lin giveaway_N = mkN "赠品" ;
lin given_A = {-HSK-} mkA "一定" | mkA "受到" ;
lin given_N = mkN "一定" | mkN "受到" | {-HSK-} mkN "基本事实" ;
lin giver_N = mkN "給予者" | mkN "给予者" | mkN "捐贈者" | mkN "捐赠者" | mkN "送禮者" | mkN "送礼者" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin gizzard_N = mkN "室" | mkN "砂囊" | mkN "肫" | mkN "胃" | mkN "胃磨" | mkN "胗" ; -- open-multilingual-wordnet
lin glacial_A = mkA "冰" ;
lin glacier_N = mkN "冰川" | mkN "冰河" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin glad_A = mkA "高兴" ;
lin gladden_V2 = mkV2 (mkV "使高興") | mkV2 (mkV "使高兴") | mkV2 (mkV "使喜悅") | mkV2 (mkV "使喜悦") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin glade_N = mkN "林间空地" "片" ;
lin gladiator_N = mkN "角鬥士" | mkN "角斗士" | mkN "劍鬥士" | mkN "剑斗士" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin gladiatorial_A = mkA "争论" | mkA "斗剑者" ; -- open-multilingual-wordnet
lin gladiolus_N = mkN "劍蘭" | mkN "剑兰" ; -- status=guess -- status=guess
lin gladys_PN = foreignPN "Gladys" ; -- comment=src=eng status=guess
lin glamor_N = mkN "魅力" ;
lin glamorgan_PN = foreignPN "Glamorgan" ; -- comment=src=eng status=guess
lin glamorize_V2 = mkV2 "美化" ;
lin glamorous_A = mkA "美艳" ;
lin glamour_N = mkN "魅力" ;
lin glance_N = mkN "一瞥" ;
lin glance_V = mkV "扫视" ;
lin glance_V2 = mkV2 "浏览" ;
lin gland_N = mkN "腺" ; -- status=guess
lin glanders_N = mkN "鼻疽病" ; -- open-multilingual-wordnet
lin glandular_A = mkA "腺" | {-mwn-} mkA "有腺" ; -- status=guess -- open-multilingual-wordnet
lin glans_N = mkN "龜頭" | mkN "龟头" ; -- status=guess -- status=guess
lin glare_N = mkN "眩光" ;
lin glare_V = mkV "瞪眼" ;
lin glare_V2 = mkV2 "强光" ;
lin glaring_A = mkA "耀眼" ;
lin glasgow_PN = mkPN "格拉斯哥" ; -- comment=src=geonames status=guess
lin glasnost_N = mkN "開放政策" | mkN "开放政策" ; -- status=guess -- status=guess
lin glass_1_N = mkN "杯子" "個" | mkN "玻璃" "張" | {-HSK-} mkN "玻璃" ;
lin glass_2_N = mkN "杯子" "個" | mkN "玻璃" "張" | {-HSK-} mkN "玻璃" ;
lin glass_V2 = mkV2 "使+成玻璃状" ;
lin glassful_N = mkN "一杯的容量" ; -- open-multilingual-wordnet
lin glasshouse_N = mkN "室苗圃" | mkN "温室" ; -- open-multilingual-wordnet
lin glassware_N = mkN "玻璃器皿" ; -- open-multilingual-wordnet
lin glassworks_N = mkN "玻璃制造厂" | mkN "玻璃厂" | mkN "玻璃工厂" ; -- open-multilingual-wordnet
lin glastonbury_PN = mkPN "格拉斯頓伯里" ; -- comment=src=geonames status=guess
lin glaucoma_N = mkN "青光眼" | {-mwn-} mkN "绿内障" ; -- status=guess -- open-multilingual-wordnet
lin glauconite_N = mkN "海绿石" ; -- open-multilingual-wordnet
lin glaucous_A = mkA "绿灰色" | mkA "蓝绿色" ; -- open-multilingual-wordnet
lin glaze_V = mkV "变得光滑" ;
lin glazier_N = mkN "玻璃工" | mkN "玻璃剪裁工" ; -- status=guess -- status=guess
lin gleam_V = mkV "闪光" ;
lin glean_V2 = mkV2 "收集" ;
lin glebe_N = mkN "教会属地" | mkN "教会附属地" ; -- open-multilingual-wordnet
lin glee_N = mkN "欢乐" [] ;
lin gleeful_A = mkA "愉快" ;
lin glen_PN = foreignPN "Glen" ; -- comment=src=eng status=guess
lin glenrothes_PN = foreignPN "Glenrothes" ; -- comment=src=geonames status=guess
lin glial_A = mkA "神经胶质" ; -- open-multilingual-wordnet
lin glib_A = mkA "巧舌如簧" ;
lin glide_V = mkV "滑翔" ;
lin glider_N = mkN "滑翔機" | mkN "滑翔机" ; -- status=guess -- status=guess
lin glimmer_N = mkN "线" ;
lin glimpse_N = mkN "一瞥" ;
lin glint_N = mkN "闪烁" ;
lin glioblastoma_N = mkN "脂母细胞瘤" ; -- open-multilingual-wordnet
lin glioma_N = mkN "神经胶质瘤" ; -- open-multilingual-wordnet
lin glissando_Adv = mkAdv "滑奏法" ; -- open-multilingual-wordnet
lin glissando_N = mkN "刮奏" | mkN "滑音" ; -- status=guess -- status=guess
lin glisten_V = mkV "輝耀" | mkV "辉耀" | mkV "閃光" | mkV "闪光" | mkV "閃耀" | mkV "闪耀" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin glitter_N = mkN "闪光" ;
lin glitter_V = mkV "閃耀" | mkV "闪耀" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin gloaming_N = mkN "黃昏" | mkN "黄昏" | {-mwn-} mkN "傍晚" | mkN "暮色" | mkN "薄暮" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gloat_V = mkV "幸灾乐祸" ;
lin gloat_VS = mkVS "幸灾乐祸" ;
lin gloatingly_Adv = mkAdv "沾沾自喜+地" ; -- open-multilingual-wordnet
lin global_A = mkA "全球" ;
lin globe_N = mkN "地球" [] ;
lin globin_N = mkN "球蛋白" ; -- open-multilingual-wordnet
lin globulin_N = mkN "球蛋白" ; -- open-multilingual-wordnet
lin glochidium_N = mkN "倒刺毛" | mkN "钩毛" ; -- open-multilingual-wordnet
lin glockenspiel_N = mkN "钟琴" ; -- open-multilingual-wordnet
lin glomerular_A = mkA "肾小球" ; -- open-multilingual-wordnet
lin glomerule_N = mkN "团伞花序" ; -- open-multilingual-wordnet
lin glomerulonephritis_N = mkN "肾小球性肾炎" ; -- open-multilingual-wordnet
lin gloom_N = mkN "幽暗" ;
lin gloomy_A = mkA "暗" | {-HSK-} mkA "阴沉" ;
lin gloria_PN = foreignPN "Gloria" ; -- comment=src=geonames status=guess
lin glorious_A = mkA "辉煌" ;
lin glory_N = mkN "荣耀" | {-HSK-} mkN "荣誉" ;
lin gloss_V2 = mkV2 "发光" ;
lin glossalgia_N = mkN "舌痛" ; -- open-multilingual-wordnet
lin glossary_N = mkN "詞匯表" | mkN "詞彙表" | mkN "词汇表" | mkN "詞匯 or 詞彙" | mkN "词汇" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin glossitis_N = mkN "舌炎" ; -- open-multilingual-wordnet
lin glossolalia_N = mkN "胡言乱语" | mkN "言语不清" ; -- open-multilingual-wordnet
lin glossop_PN = foreignPN "Glossop" ; -- comment=src=geonames status=guess
lin glossopharyngeal_A = mkA "舌与咽" | mkA "舌咽" ; -- open-multilingual-wordnet
lin glossy_A = mkA "光滑" ;
lin glossy_N = mkN "光滑" ;
lin glottal_A = mkA "声门" ; -- open-multilingual-wordnet
lin glottis_N = mkN "嗓門" | mkN "嗓门" ; -- status=guess -- status=guess
lin gloucester_PN = mkPN "格洛斯特" ; -- comment=src=geonames status=guess
lin gloucestershire_PN = foreignPN "Gloucestershire" ; -- comment=src=eng status=guess
lin glove_N = L.glove_N | {-HSK-} mkN "手套" "雙" ;
lin glow_N = mkN "光辉" ;
lin glow_V = mkV "发光" ;
lin glower_V = mkV "怒视" | mkV "皱眉" | mkV "蹙眉" | mkV "蹙额" ; -- open-multilingual-wordnet
lin gloweringly_Adv = mkAdv "怒目而视+地" ; -- open-multilingual-wordnet
lin glowingly_Adv = mkAdv "灼热+地" | mkAdv "热心+地" | mkAdv "热情洋溢+地" ; -- open-multilingual-wordnet
lin glow_worm_N = mkN "螢火蟲" | mkN "萤火虫" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gloxinia_N = mkN "六雪尼" | mkN "大岩桐" | mkN "落雪泥" ; -- open-multilingual-wordnet
lin glucocorticoid_N = mkN "糖皮质激素" ; -- open-multilingual-wordnet
lin glucose_N = mkN "葡萄糖" ;
lin glucoside_N = mkN "葡萄糖苷" | mkN "配糖体" | mkN "配糖物" ; -- open-multilingual-wordnet
lin glucosuria_N = mkN "葡糖尿" ; -- open-multilingual-wordnet
lin glue_N = mkN "胶水" ;
lin gluey_A = mkA "膠狀" | mkA "胶状" | mkA "膠質" | mkA "胶质" | mkA "粘著" | mkA "粘着" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin glum_A = mkA "阴沉" ;
lin glume_N = mkN "颖片" ; -- open-multilingual-wordnet
lin glusburn_PN = foreignPN "Glusburn" ; -- comment=src=geonames status=guess
lin glut_N = mkN "供过于求" "" ;
lin glut_V2 = mkV2 "使+充满" ;
lin glutamate_N = mkN "谷氨酸盐" | mkN "谷氨酸脂" ; -- open-multilingual-wordnet
lin glutamine_N = mkN "谷氨酸盐" ; -- open-multilingual-wordnet
lin gluteal_A = mkA "臀" | mkA "臀肌" | mkA "近臀肌" ; -- open-multilingual-wordnet
lin glutelin_N = mkN "谷蛋白" ; -- open-multilingual-wordnet
lin gluten_N = mkN "麵筋" | mkN "面筋" ; -- status=guess -- status=guess
lin glutton_N = mkN "暴食者" | mkN "饞嘴" | mkN "馋嘴" | mkN "饕餮" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin gluttonous_A = mkA "貪嘴" | mkA "贪嘴" | mkA "暴食" | mkA "饞" | mkA "馋" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin gluttony_N = mkN "暴食" | mkN "貪食" | mkN "贪食" ; -- status=guess -- status=guess -- status=guess
lin glyceraldehyde_N = mkN "甘油醛" ; -- open-multilingual-wordnet
lin glyceride_N = mkN "甘油酯" ; -- open-multilingual-wordnet
lin glycerine_N = mkN "甘油" | mkN "丙三醇" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin glycerite_N = mkN "甘油剂" | mkN "甘油溶液" ; -- open-multilingual-wordnet
lin glycerol_N = mkN "丙三醇" | mkN "甘油" ; -- open-multilingual-wordnet
lin glycogen_N = mkN "动物淀粉" | mkN "糖原质" ; -- open-multilingual-wordnet
lin glycogenic_A = mkA "生糖" | mkA "生糖原" | mkA "糖原" | mkA "肝糖" ; -- open-multilingual-wordnet
lin glycolysis_N = mkN "糖酵解" | {-mwn-} mkN "糖解" ; -- status=guess -- open-multilingual-wordnet
lin glycoprotein_N = mkN "糖蛋白" ; -- open-multilingual-wordnet
lin glycoside_N = mkN "苷" | {-mwn-} mkN "葡萄糖甙" | mkN "配糖" | mkN "配糖体" | mkN "配糖类" ; -- status=guess -- open-multilingual-wordnet
lin glycosuria_N = mkN "糖尿病之一种" ; -- open-multilingual-wordnet
lin glyptics_N = mkN "宝石雕刻术" ; -- open-multilingual-wordnet
lin gmt_PN = foreignPN "Gmt" ; -- comment=src=eng status=guess
lin gnarled_A = mkA "多瘤" | mkA "多节" | mkA "粗糙" ; -- open-multilingual-wordnet
lin gnat_N = mkN "蚋" | mkN "蚊" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gnaw_V = mkV "咬" ;
lin gnaw_V2 = mkV2 (mkV "啃") | mkV2 (mkV "咬") | mkV2 (mkV "噬") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin gneiss_N = mkN "片麻岩" ; -- status=guess -- open-multilingual-wordnet
lin gnomic_A = mkA "含格言" | mkA "格言" | mkA "用格言" ; -- open-multilingual-wordnet
lin gnomon_N = mkN "指时针" ; -- open-multilingual-wordnet
lin gnp_N = mkN "国民生产总值" [] ;
lin gnu_N = mkN "牛羚" | mkN "角馬" | mkN "角马" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin go_A = mkA "走" ;
lin go_N = mkN "围棋" [] ;
lin go_V = L.go_V | {-HSK-} mkV "到" | mkV "去" | mkV "抄" | mkV "游览" | mkV "行" | mkV "走" ;
lin go_VA = mkVA "到" | mkVA "去" | mkVA "抄" | mkVA "游览" | mkVA "行" | mkVA "走" ;
lin go_VV = mkVV "到" | mkVV "去" | mkVV "抄" | mkVV "游览" | mkVV "行" | mkVV "走" ;
lin go_about_V = mkV "开始" ; -- open-multilingual-wordnet
lin go_about_V2 = prepV2 OP_go_V OP_about_Prep ; -- guess-p-verb
lin go_across_V = mkV "渡过" | mkV "穿过" | mkV "经过" | mkV "过" ; -- open-multilingual-wordnet
lin go_after_V2 = mkV2 "追逐" ;
lin go_against_V2 = mkV2 "顶" ;
lin go_ahead_V = mkV "继续进行" ; -- open-multilingual-wordnet
lin go_ahead_with_V2 = prepV2 (advV OP_go_V OP_ahead_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_along_V = mkV "流逝" | mkV "消逝" | mkV "过" | mkV "过去" | mkV "逝去" ; -- open-multilingual-wordnet
lin go_along_with_V2 = prepV2 (advV OP_go_V OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_around_V = advV OP_go_V OP_around_Adv ; -- guess-p-verb
lin go_at_V2 = prepV2 OP_go_V OP_at_Prep ; -- guess-p-verb
lin go_away_V = mkV "走" ;
lin go_back_V = mkV "却" | mkV "回" ;
lin go_back_V2 = mkV2 "却" | mkV2 "回" ;
lin go_back_on_V2 = prepV2 (advV OP_go_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin go_before_V = advV OP_go_V OP_before_Adv ; -- guess-p-verb
lin go_below_V = advV OP_go_V OP_below_Adv ; -- guess-p-verb
lin go_by_V = advV OP_go_V OP_by_Adv ; -- guess-p-verb
lin go_by_V2 = prepV2 OP_go_V OP_by_Prep ; -- guess-p-verb
lin go_down_V = mkV "下" ;
lin go_down_on_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin go_down_to_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_down_with_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_for_V = mkV "从事" ;
lin go_for_V2 = mkV2 "从事" ;
lin go_for_it_V = variants {} ; -- guess-p-verb
lin go_forth_V = advV OP_go_V OP_forth_Adv ; -- guess-p-verb
lin go_forward_V = mkV "前进" | mkV "进行" ; -- open-multilingual-wordnet
lin go_in_V = mkV "入" | mkV "进" | mkV "进入" ; -- open-multilingual-wordnet
lin go_in_for_V2 = mkV2 "搞" ;
lin go_in_with_V2 = prepV2 (advV OP_go_V OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_into_V2 = mkV2 "上" ;
lin go_it_V = variants {} ; -- guess-p-verb
lin go_it_alone_V = variants {} ; -- guess-p-verb
lin go_off_V = advV OP_go_V OP_off_Adv ; -- guess-p-verb
lin go_off_V2 = prepV2 OP_go_V OP_off_Prep ; -- guess-p-verb
lin go_off_with_V2 = prepV2 (advV OP_go_V OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_on_V = advV OP_go_V OP_on_Adv ; -- guess-p-verb
lin go_on_V2 = prepV2 OP_go_V OP_on_Prep ; -- guess-p-verb
lin go_on_about_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_about_Prep ; -- guess-p-verb
lin go_on_at_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_at_Prep ; -- guess-p-verb
lin go_on_to_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_on_with_V2 = mkV2 "继续" ;
lin go_one_V = variants {} ; -- guess-p-verb
lin go_out_V = mkV "出" | {-mwn-} mkV "熄灭" ; -- open-multilingual-wordnet
lin go_out_for_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin go_out_to_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_out_with_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_over_V = mkV "过" | mkV "过去" ;
lin go_over_V2 = mkV2 "过" | mkV2 "过去" ;
lin go_over_to_V2 = prepV2 (advV OP_go_V OP_over_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_past_V2 = prepV2 OP_go_V OP_past_Prep ; -- guess-p-verb
lin go_round_V = mkV "绕" ;
lin go_through_V = mkV "经过" ;
lin go_through_V2 = mkV2 "经过" ;
lin go_through_with_V2 = prepV2 (advV OP_go_V OP_through_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_to_V2 = mkV2 "去" ;
lin go_together_V = advV OP_go_V OP_together_Adv ; -- guess-p-verb
lin go_towards_V2 = prepV2 OP_go_V OP_towards_Prep ; -- guess-p-verb
lin go_under_V = advV OP_go_V OP_under_Adv ; -- guess-p-verb
lin go_up_V = mkV "上" | {-HSK-} mkV "向上走" ;
lin go_up_to_V2 = prepV2 (advV OP_go_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_with_V2 = mkV2 "就" | mkV2 "跟" ;
lin go_without_V2 = prepV2 OP_go_V OP_without_Prep ; -- guess-p-verb
lin goal_1_N = mkN "目标" | {-HSK-} mkN "目标" "個" | mkN "目的" "個" ;
lin goal_2_N = mkN "目标" | {-HSK-} mkN "目标" "個" | mkN "目的" "個" ;
lin goalkeeper_N = variants {} ;
lin goalless_A = mkA "没得分" ; -- open-multilingual-wordnet
lin goalmouth_N = mkN "球门口" ; -- open-multilingual-wordnet
lin goalpost_N = mkN "门柱" ; -- open-multilingual-wordnet
lin goat_N = mkN "山羊" "只" ;
lin goatee_N = mkN "羊咩须" ;
lin goateed_A = mkA "有山羊胡" | mkA "蓄山羊胡" ; -- open-multilingual-wordnet
lin goatskin_N = mkN "山羊皮" ; -- open-multilingual-wordnet
lin gobble_V = mkV "狼吞虎咽" ;
lin gobbledygook_N = mkN "官样文章" "篇" ;
lin goblet_N = mkN "高脚杯" ; -- open-multilingual-wordnet
lin goblin_N = mkN "妖精" ;
lin go_by_N = mkN "蝦虎魚" | mkN "虾虎鱼" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin god_N = mkN "神" ;
lin god_PN = foreignPN "God" ; -- comment=src=eng status=guess
lin godalming_PN = foreignPN "Godalming" ; -- comment=src=geonames status=guess
lin goddam_Adv = mkAdv "坏透了+地" | mkAdv "该死+地" ; -- open-multilingual-wordnet
lin goddess_N = mkN "女神" ;
lin godfather_N = mkN "乾爹" | mkN "干爹" | mkN "教父" ; -- status=guess -- status=guess -- status=guess
lin godfrey_PN = foreignPN "Godfrey" ; -- comment=src=geonames status=guess
lin godless_A = mkA "無神" | mkA "无神" ; -- status=guess -- status=guess
lin godlike_A = mkA "似神" ; -- status=guess
lin godliness_N = mkN "虔誠" | mkN "虔诚" ; -- status=guess -- status=guess
lin godly_A = mkA "虔诚" | mkA "敬神" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin godmanchester_PN = foreignPN "Godmanchester" ; -- comment=src=geonames status=guess
lin godmother_N = mkN "乾娘" | mkN "干娘" | mkN "教母" ; -- status=guess -- status=guess -- status=guess
lin godown_N = mkN "仓库" | mkN "货仓" ; -- open-multilingual-wordnet
lin godparent_N = mkN "乾爹" | mkN "干爹" | mkN "教父" | mkN "乾娘" | mkN "干娘" | mkN "教母" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin godwit_N = mkN "塍鹬" | mkN "棕塍鹬" | mkN "长嘴涉水鸟" | mkN "黑尾豫" ; -- open-multilingual-wordnet
lin goffer_N = mkN "褶皱" ; -- open-multilingual-wordnet
lin goffs_oak_PN = foreignPN "Goffs oak" ; -- comment=src=eng status=guess
lin goggle_V = mkV "痴呆着看" | mkV "直瞪瞪地注视" | mkV "眼睛睁视" ; -- open-multilingual-wordnet
lin goggles_N = mkN "風鏡" | mkN "风镜" | mkN "護眼鏡" | mkN "护眼镜" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin going_N = mkN "去" ;
lin goiter_N = mkN "甲状腺肿" | mkN "瘤" | mkN "肿物" ; -- open-multilingual-wordnet
lin goitre_N = mkN "甲状腺肿" | mkN "瘤" | mkN "肿物" ; -- open-multilingual-wordnet
lin goitrogen_N = mkN "形成甲状肿之化合物" | mkN "致甲状腺肿因子" ; -- open-multilingual-wordnet
lin golbourne_PN = foreignPN "Golbourne" ; -- comment=src=eng status=guess
lin gold_A = {-HSK-} mkA "黄金" ;
lin gold_N = L.gold_N | {-HSK-} mkN "黄金" ;
lin golden_A = mkA "金色" ;
lin goldfinch_N = mkN "金翅雀" ; -- status=guess -- status=guess
lin goldfish_N = mkN "金魚" | mkN "金鱼" ; -- status=guess -- status=guess
lin goldsmith_N = mkN "冶金匠" ; -- status=guess
lin goldstone_N = mkN "嵌有黄铜粉的茶色玻璃" ; -- open-multilingual-wordnet
lin golem_N = mkN "机器人" | mkN "机械人" | mkN "自动机" | mkN "自动机器" | mkN "遥控机械" ; -- open-multilingual-wordnet
lin golf_N = mkN "高尔夫球" ;
lin golf_V = mkV "打高尔夫球" ;
lin golf_club_N = mkN "高尔夫球棒" | mkN "高尔夫球球棒" ; -- open-multilingual-wordnet
lin golfcart_N = mkN "推车" | mkN "高尔夫球车" ; -- open-multilingual-wordnet
lin golfer_N = mkN "高尔夫球手" "位" ;
lin goliath_N = mkN "巨人" "个" ;
lin golosh_N = mkN "套鞋" | mkN "橡胶套鞋" | mkN "胶鞋" ; -- open-multilingual-wordnet
lin gonadal_A = mkA "性腺" ; -- open-multilingual-wordnet
lin gonadotropic_A = mkA "刺激生殖腺" ; -- open-multilingual-wordnet
lin gondola_N = mkN "贡多拉" | {-mwn-} mkN "吊舱" ; -- status=guess -- open-multilingual-wordnet
lin gong_N = mkN "鑼" | mkN "锣" | {-mwn-} mkN "钟" | mkN "钟琴" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gonorrhea_N = mkN "淋病" ; -- status=guess -- open-multilingual-wordnet
lin gonorrhoea_N = mkN "淋病" ; -- open-multilingual-wordnet
lin goo_N = mkN "感伤""" ;
lin good_A = mkA "好" ;
lin good_N = mkN "商品" "個" | mkN "好" | mkN "硬" | mkN "良好" ;
lin good_afternoon_Interj = mkInterj "你好" ;
lin good_evening_Interj = mkInterj "下午好" ;
lin good_looking_A = mkA "好看" ;
lin good_luck_Interj = mkInterj "祝你好运" ;
lin good_morning_Interj = mkInterj "早上好" ;
lin good_natured_A = mkA "和蔼" ;
lin good_night_Interj = mkInterj "晚安" ;
lin goodbye_Interj = mkInterj "再见" ;
lin goodness_N = mkN "天哪" ;
lin goods_N = mkN "产品" "個" | {-HSK-} mkN "產品" | mkN "产品" | mkN "貨物" | mkN "货物" | mkN "製品" | mkN "制品" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin goodwill_N = mkN "友好" [] ;
lin goody_N = mkN "伪善者" ;
lin goof_V = mkV "做错" | mkV "出大错" | mkV "犯错误" ; -- open-multilingual-wordnet
lin googol_N = mkN "古戈尔" | mkN "大数" ; -- open-multilingual-wordnet
lin googolplex_N = mkN "10的古戈尔次方" | mkN "古戈尔普勒克斯" ; -- open-multilingual-wordnet
lin goole_PN = foreignPN "Goole" ; -- comment=src=geonames status=guess
lin goose_N = mkN "鹅" "只" ;
lin gooseberry_N = mkN "醋栗" ;
lin gooseneck_N = mkN "曲如鹅颈之线" ; -- open-multilingual-wordnet
lin gordon_PN = foreignPN "Gordon" ; -- comment=src=geonames status=guess
lin gore_N = mkN "瘀血" | mkN "淤血" | {-mwn-} mkN "流血" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gore_V2 = mkV2 "刺伤" ;
lin gorge_N = mkN "峽谷" | mkN "峡谷" ; -- status=guess -- status=guess
lin gorge_V = mkV "狼吞虎咽" | {-mwn-} mkV "使吃得过饱" | mkV "吃过量" | mkV "大口吞食" | mkV "暴食" ; -- status=guess, src=wikt -- open-multilingual-wordnet
lin gorge_V2 = mkV2 (mkV "狼吞虎咽") ; -- status=guess, src=wikt
lin gorgeous_A = mkA "华丽" ;
lin gorgerin_N = mkN "柱颈" ; -- open-multilingual-wordnet
lin gorget_N = mkN "护喉甲胄" | mkN "颈甲" ; -- open-multilingual-wordnet
lin gorgon_N = mkN "戈耳工" ; -- status=guess
lin gorilla_N = mkN "大猩猩" "只" ;
lin gorky_PN = foreignPN "Gorky" ; -- comment=src=eng status=guess
lin gormandize_V = mkV "使吃得过饱" | mkV "吃过量" | mkV "大口吞食" | mkV "暴食" | mkV "狼吞虎咽" ; -- open-multilingual-wordnet
lin gorseinon_PN = foreignPN "Gorseinon" ; -- comment=src=geonames status=guess
lin gospel_N = mkN "真理" ;
lin gosport_PN = mkPN "戈斯波特" ; -- comment=src=geonames status=guess
lin gossamer_N = mkN "薄紗" ; -- status=guess
lin gossip_N = mkN "小道传闻" "条" ;
lin gossip_V = mkV "聊天" | mkV "说话" | {-HSK-} mkV "闲聊" ;
lin gothenburg_PN = foreignPN "Gothenburg" ; -- comment=src=geonames status=guess
lin gothic_A = mkA "哥特式" ;
lin gottingen_PN = foreignPN "Gottingen" ; -- comment=src=eng status=guess
lin goulash_N = mkN "匈牙利湯" ; -- status=guess
lin gourd_N = mkN "葫蘆" | mkN "葫芦" | {-mwn-} mkN "葫芦瓠" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gourmet_N = mkN "美食家" ;
lin gourock_PN = foreignPN "Gourock" ; -- comment=src=geonames status=guess
lin gout_N = mkN "痛風" | mkN "痛风" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gouty_A = mkA "痛风" ;
lin gov_PN = foreignPN "Gov" ; -- comment=src=eng status=guess
lin govern_V = mkV "治理" | {-HSK-} mkV "统治" ;
lin govern_V2 = mkV2 "治理" | {-HSK-} mkV2 "统治" ;
lin governance_N = mkN "统治" ;
lin government_N = mkN "官" "個" | mkN "政府" "個" | mkN "朝" | {-HSK-} mkN "政府" ;
lin governmental_A = mkA "政府" ;
lin governor_N = mkN "管理者" ;
lin gown_N = mkN "袍" "条" ;
lin gp_N = mkN "类属编程" "次" ;
lin grab_N = mkN "抓斗" ;
lin grab_V = mkV "抢" ;
lin grab_V2 = mkV2 "抢" ;
lin grace_N = mkN "恩典" [] ;
lin grace_V2 = mkV2 "优雅" ;
lin graceful_A = mkA "优美" | mkA "帅" | {-HSK-} mkA "优雅" ;
lin gracefulness_N = mkN "優雅" | mkN "优雅" | mkN "優美" | mkN "优美" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin gracilariid_N = mkN "细蛾" ; -- open-multilingual-wordnet
lin gracious_A = mkA "亲切" ;
lin grade_N = mkN "年级" "個" | mkN "等" | {-HSK-} mkN "等级" ;
lin grade_V2 = mkV2 "使+分等级" ;
lin gradual_A = mkA "逐步" ;
lin graduate_N = mkN "毕业生" ;
lin graduate_V = mkV "毕业" ;
lin graduate_V2 = mkV2 "授予学位" | {-HSK-} mkV2 "毕业" ;
lin graduation_N = mkN "毕业" ;
lin graffito_N = mkN "涂鸦" ; -- open-multilingual-wordnet
lin graft_N = mkN "嫁接" ;
lin graft_V2 = mkV2 "移植" ;
lin grain_N = mkN "粒" | {-HSK-} mkN "粮食" ;
lin gram_N = mkN "克" | {-HSK-} mkN "克" [] ;
lin gramicidin_N = mkN "短杆菌肽" ; -- open-multilingual-wordnet
lin grammar_N = L.grammar_N | {-HSK-} mkN "语法" ;
lin grammatical_A = mkA "语法" ;
lin gramme_N = mkN "克" | mkN "公克" ; -- open-multilingual-wordnet
lin gramophone_N = mkN "留聲機" | mkN "留声机" | mkN "唱機" | mkN "唱机" | mkN "電唱機" | mkN "电唱机" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin grampian_PN = foreignPN "Grampian" ; -- comment=src=eng status=guess
lin granada_PN = mkPN "格拉纳达" ; -- comment=src=geonames status=guess
lin granary_N = mkN "筒倉" | mkN "筒仓" | mkN "糧倉" | mkN "粮仓" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin grand_A = mkA "盛大" | {-HSK-} mkA "雄伟" ;
lin grand_prix_N = mkN "国际长途汽车大奖赛" ;
lin grandad_N = mkN "外公" | mkN "外祖父" | mkN "爷爷" | mkN "祖父" ; -- open-multilingual-wordnet
lin grandchild_N = mkN "孙子" "位" ;
lin granddad_N = mkN "外公" | mkN "外祖父" | mkN "爷爷" | mkN "祖父" ; -- open-multilingual-wordnet
lin granddaughter_N = mkN "孫女" | mkN "孙女" | mkN "外孫女" | mkN "外孙女" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin grandee_N = mkN "贵族" ;
lin grandeur_N = mkN "庄严" ;
lin grandfather_N = mkN "爷爷" | mkN "祖父" "位" ;
lin grandiose_A = mkA "雄伟" ;
lin grandmother_N = mkN "奶奶" | mkN "祖母" ;
lin grandpa_N = mkN "外公" | mkN "外祖父" | mkN "爷爷" | mkN "祖父" ; -- open-multilingual-wordnet
lin grandparent_N = mkN "祖父母" ;
lin grandson_N = mkN "孙子" ;
lin grandstand_N = mkN "看台" | {-mwn-} mkN "大看台" ; -- status=guess -- open-multilingual-wordnet
lin grange_N = mkN "农庄" ;
lin grangemouth_PN = foreignPN "Grangemouth" ; -- comment=src=geonames status=guess
lin granite_N = mkN "花岗岩" "块" ;
lin granny_N = mkN "反平结" ; -- open-multilingual-wordnet
lin grant_N = mkN "授与" ;
lin grant_V2 = mkV2 "准许" ;
lin grant_V3 = mkV3 "补助" ;
lin grantham_PN = mkPN "格兰瑟姆" ; -- comment=src=geonames status=guess
lin granular_A = mkA "粒状" ;
lin granule_N = mkN "粒" | {-HSK-} mkN "顆粒" | mkN "颗粒" ; -- status=guess -- status=guess
lin granuliferous_A = mkA "具颗粒" | mkA "结粒状之实" ; -- open-multilingual-wordnet
lin granulocytic_A = mkA "颗粒细胞" ; -- open-multilingual-wordnet
lin granuloma_N = mkN "肉芽肿" ; -- open-multilingual-wordnet
lin granulomatous_A = mkA "肉芽肿" ; -- open-multilingual-wordnet
lin grape_N = mkN "葡萄" ;
lin grapefruit_N = mkN "柚子" | mkN "葡萄柚" ; -- status=guess -- status=guess
lin grapelike_A = mkA "似葡萄" ; -- open-multilingual-wordnet
lin grapeshot_N = mkN "葡萄弹" ; -- open-multilingual-wordnet
lin grapevine_N = mkN "小道消息" ;
lin grapey_A = mkA "似葡萄" ; -- open-multilingual-wordnet
lin graph_N = mkN "图" "张" ;
lin graphic_A = mkA "图形" ;
lin graphic_N = mkN "漫畫" | mkN "漫画" ; -- status=guess -- status=guess
lin graphics_N = mkN "图像" ;
lin graphite_N = mkN "石墨" ;
lin grapnel_N = mkN "小锚" ; -- open-multilingual-wordnet
lin grapple_V = mkV "格斗" ;
lin grasp_N = mkN "理解" "" ;
lin grasp_V = mkV "把" | mkV "把握" | mkV "掌握" ;
lin grasp_V2 = mkV2 "把" | mkV2 "把握" | mkV2 "掌握" ;
lin grass_N = L.grass_N | {-HSK-} mkN "草" "棵" ;
lin grass_V = mkV "长草" ;
lin grass_V2 = mkV2 "使+长满草" ;
lin grasshopper_N = mkN "蚱蜢" | mkN "螞蚱" | mkN "蚂蚱" | {-mwn-} mkN "蝗虫" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin grassland_N = mkN "草原" ; -- status=guess
lin grassy_A = mkA "长满草" ;
lin grate_V = mkV "使发出刺耳的声音" | mkV "刮出刺耳声" | mkV "发出刺耳的摩擦声" | mkV "发刺耳声地摩擦" ; -- open-multilingual-wordnet
lin grateful_A = mkA "感激" | mkA "感谢" ;
lin grater_N = mkN "礤床" | mkN "擦子" | mkN "擦菜板" | {-mwn-} mkN "磨碎机" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin gratifying_A = mkA "令人愉快" | mkA "令人满足" | mkA "快乐" ; -- open-multilingual-wordnet
lin grating_N = mkN "衍射光栅" ; -- open-multilingual-wordnet
lin gratingly_Adv = mkAdv "刺耳+地" ; -- open-multilingual-wordnet
lin gratis_A = mkA "免费" | mkA "赠送" ; -- open-multilingual-wordnet
lin gratitude_N = mkN "感谢" ;
lin gratuitous_A = mkA "无理由" | {-HSK-} mkA "白" ; -- comment="无端" ;
lin gratuity_N = mkN "酬金" ;
lin grave_A = mkA "严重" ;
lin grave_N = mkN "严重" | {-HSK-} mkN "坟墓" ;
lin gravel_N = mkN "碎石" "块" ;
lin graveness_N = mkN "严肃" | mkN "严重" | mkN "认真" ; -- open-multilingual-wordnet
lin gravenhage_PN = foreignPN "Gravenhage" ; -- comment=src=eng status=guess
lin graver_N = mkN "雕刻工具" ; -- open-multilingual-wordnet
lin gravesend_PN = mkPN "格雷夫森德" ; -- comment=src=geonames status=guess
lin gravestone_N = mkN "墓碑" | mkN "墓石" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin graveyard_N = mkN "墓地" "块" ;
lin gravidity_N = mkN "妊娠" | mkN "怀孕" ; -- open-multilingual-wordnet
lin graving_dock_N = mkN "干船坞" ;
lin gravitation_N = mkN "重力" | mkN "引力" ; -- status=guess -- status=guess
lin gravitational_A = mkA "万有引力" | mkA "地球引力" | mkA "重力" ; -- open-multilingual-wordnet
lin gravity_N = mkN "重力" ;
lin gravy_N = mkN "肉汁" [] ;
lin graz_PN = mkPN "格拉茨" ; -- comment=src=geonames status=guess
lin graze_V = mkV "放牧" ;
lin grease_N = mkN "油脂" "块" ;
lin greasepaint_N = mkN "演员化妆用油" ; -- open-multilingual-wordnet
lin greasy_A = mkA "膩" | mkA "腻" ; -- status=guess -- status=guess
lin great_A = mkA "伟大" | {-HSK-} mkA "大" ;
lin great_N = mkN "伟大" | mkN "大" | {-HSK-} mkN "大师""位" ;
lin great_harwood_PN = foreignPN "Great harwood" ; -- comment=src=eng status=guess
lin great_malvern_PN = foreignPN "Great malvern" ; -- comment=src=eng status=guess
lin great_shelford_PN = foreignPN "Great shelford" ; -- comment=src=eng status=guess
lin great_yarmouth_PN = foreignPN "Great yarmouth" ; -- comment=src=eng status=guess
lin greatest_A = mkA "太" | {-mwn-} mkA "最伟大" | mkA "最好" | mkA "最高级" ; -- open-multilingual-wordnet
lin greatly_Adv = adjAdv great_A ; -- derived
lin greatness_N = mkN "伟大" ;
lin greave_N = mkN "护胫" | mkN "护胫甲" | mkN "胫甲" ; -- open-multilingual-wordnet
lin grebe_N = mkN "鸊鷉" ; -- open-multilingual-wordnet
lin greece_PN = mkPN "希腊" ;
lin greed_N = mkN "贪心" ;
lin greedy_A = mkA "贪婪" ;
lin greekFem_N = mkN "希腊人" ;
lin greekMasc_N = mkN "希腊人" ;
lin green_A = L.green_A | {-HSK-} mkA "绿" ;
lin green_N = mkN "绿" | {-HSK-} mkN "绿色""股" ;
lin greenback_N = mkN "美元" "张" ;
lin greenbottle_N = mkN "丽蝇" ; -- open-multilingual-wordnet
lin greenery_N = mkN "绿叶" ; -- open-multilingual-wordnet
lin greeneye_N = mkN "青眼鱼" ; -- open-multilingual-wordnet
lin greenfly_N = mkN "牙虫的一种" | mkN "蚜虫" ; -- open-multilingual-wordnet
lin greengrocer_N = mkN "蔬菜水果店" ; -- status=guess
lin greengrocery_N = mkN "蔬菜水果店" ; -- open-multilingual-wordnet
lin greenhorn_N = mkN "新手" | mkN "生手" | mkN "初學者" | mkN "初学者" | mkN "菜鳥" | mkN "菜鸟" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin greenhouse_A = mkA "温室效应" ; -- open-multilingual-wordnet
lin greenhouse_N = mkN "温室" ;
lin greenish_A = mkA "呈绿色" ;
lin greenling_N = mkN "六线鱼" | mkN "长蛇齿鱼" ; -- open-multilingual-wordnet
lin greenness_N = mkN "绿色" | mkN "青色" ; -- open-multilingual-wordnet
lin greenock_PN = mkPN "格里诺克" ; -- comment=src=geonames status=guess
lin greenockite_N = mkN "硫镉矿" ; -- open-multilingual-wordnet
lin greenroom_N = mkN "演员休息室" ; -- open-multilingual-wordnet
lin greens_N = mkN "绿地""块" ;
lin greensand_N = mkN "海绿石砂" | mkN "海绿石砂地层" | mkN "绿砂" ; -- open-multilingual-wordnet
lin greenside_A = mkA "靠近球穴区" ; -- open-multilingual-wordnet
lin greenwich_PN = mkPN "格林尼治" ; -- comment=src=geonames status=guess
lin greet_V2 = mkV2 "迎接" ;
lin greeting_N = {-mwn-} mkN "迎接" | mkN "问候" ; -- open-multilingual-wordnet
lin greg_PN = foreignPN "Greg" ; -- comment=src=eng status=guess
lin gregarious_A = mkA "社交" | {-mwn-} mkA "群居" ; -- status=guess -- open-multilingual-wordnet
lin gregory_PN = foreignPN "Gregory" ; -- comment=src=geonames status=guess
lin grenada_PN = mkPN "格林纳达" ; -- comment=src=geonames status=guess
lin grenade_N = mkN "手榴弹" "枚" ;
lin grenadier_N = mkN "长尾鳕" ; -- open-multilingual-wordnet
lin grey_A = mkA "灰" | {-HSK-} mkA "灰色" ;
lin grey_N = mkN "灰" | {-HSK-} mkN "灰色" | mkN "灰色地帯" | mkN "灰色地帶" | {-mwn-} mkN "灰色马" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin grey_V = mkV "变灰白" ;
lin greybeard_N = mkN "土制酒壶" | mkN "贝拉明酒瓶" ; -- open-multilingual-wordnet
lin greyhound_N = mkN "灰獵犬" | mkN "灰猎犬" | {-mwn-} mkN "灰狗" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin greyish_A = mkA "呈灰色" | mkA "微带灰色" | mkA "浅灰色" | mkA "淡灰色" | mkA "灰白" | mkA "灰色" ; -- open-multilingual-wordnet
lin grid_N = mkN "格子" ;
lin griddle_N = mkN "圆烤盘" | mkN "平底锅" | mkN "煎锅" ; -- open-multilingual-wordnet
lin gridiron_N = mkN "烤架" ;
lin gridlock_N = mkN "僵局" ; -- status=guess
lin grief_N = mkN "悲痛" ;
lin grievance_N = mkN "沮丧" [] ;
lin grieve_V = mkV "伤心" ;
lin grieve_V2 = mkV2 "伤心" ;
lin grievous_A = mkA "惨重" ;
lin griffin_N = mkN "獅鷲" | mkN "狮鹫" ; -- status=guess -- status=guess
lin grigri_N = mkN "护身符" ; -- open-multilingual-wordnet
lin grill_N = mkN "燒烤" | mkN "烧烤" | mkN "烤" | {-mwn-} mkN "格架" | mkN "烤架" | mkN "铁格子" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin grill_V = mkV "提问" ;
lin grill_V2 = mkV2 "提问" | {-HSK-} mkV2 "烧" ; -- comment="烤" ;
lin grillroom_N = mkN "烤肉馆" ; -- open-multilingual-wordnet
lin grim_A = mkA "冷酷" ;
lin grimace_N = mkN "鬼脸" ;
lin grimace_V = mkV "扮鬼脸" ;
lin grime_N = mkN "变脏" | mkN "污秽" ; -- open-multilingual-wordnet
lin grimethorpe_PN = foreignPN "Grimethorpe" ; -- comment=src=geonames status=guess
lin griminess_N = mkN "污秽" ; -- open-multilingual-wordnet
lin grimness_N = mkN "严格" ;
lin grimsby_PN = mkPN "格里姆斯比" ; -- comment=src=geonames status=guess
lin grimy_A = mkA "污秽" | mkA "肮脏" ; -- open-multilingual-wordnet
lin grin_N = mkN "露齿笑" ;
lin grin_V = mkV "露齿而笑" ;
lin grind_N = mkN "磨""" ;
lin grind_V = mkV "磨" ;
lin grind_V2 = mkV2 "使+磨碎" ;
lin grinder_N = mkN "研磨机" "台" ;
lin grindstone_N = mkN "磨石" | mkN "磨子" | mkN "磨" | {-mwn-} mkN "旋转磨石" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin grinstead_PN = foreignPN "Grinstead" ; -- comment=src=eng status=guess
lin grip_N = mkN "紧握" [] ;
lin grip_V2 = mkV2 "握" ;
lin gripe_VS = mkVS "抱怨" ;
lin grippe_N = mkN "流感" | mkN "流行性感冒" ; -- open-multilingual-wordnet
lin gripsack_N = mkN "手提包" | mkN "手提箱" | mkN "旅行用手提包" | mkN "旅行袋" ; -- open-multilingual-wordnet
lin grisly_A = mkA "可怕" ;
lin gristle_N = mkN "軟骨" | mkN "软骨" | mkN "脆骨" ; -- status=guess -- status=guess -- status=guess
lin gristmill_N = mkN "磨坊" | mkN "磨粉厂" ; -- open-multilingual-wordnet
lin gritty_A = mkA "坚韧不拔" ;
lin grizzle_N = mkN "斑白的假发" ; -- open-multilingual-wordnet
lin grizzly_N = mkN "灰熊" ; -- status=guess
lin groan_N = mkN "呻吟聲" | mkN "呻吟声" ; -- status=guess -- status=guess
lin groan_V = mkV "呻吟" ;
lin groan_V2 = variants {} ; -- comment=mkV "呻吟" ;
lin grocer_N = mkN "雜貨店" | mkN "杂货店" ; -- status=guess -- status=guess
lin grocery_N = mkN "杂货店" ;
lin grog_N = mkN "格羅格酒" | mkN "格罗格酒" ; -- status=guess -- status=guess
lin groin_N = mkN "腹股溝" | mkN "腹股沟" | mkN "鼠蹊" | {-mwn-} mkN "防波堤" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin groningen_PN = mkPN "格罗宁根" ; -- comment=src=geonames status=guess
lin groove_N = mkN "凹槽" ;
lin groover_N = mkN "挖槽器" | mkN "挖槽机" ; -- open-multilingual-wordnet
lin grope_V = mkV "摸" | {-HSK-} mkV "摸索" ; -- status=guess, src=wikt
lin grope_V2 = mkV2 "摸" | {-HSK-} mkV2 (mkV "摸索") ; -- status=guess, src=wikt
lin gropingly_Adv = mkAdv "摸索着" | mkAdv "暗中摸索+地" ; -- open-multilingual-wordnet
lin grosgrain_N = mkN "罗缎" ; -- open-multilingual-wordnet
lin gross_A = mkA "毛" ;
lin gross_N = mkN "國內生產總值" | mkN "国内生产总值" | {-mwn-} mkN "总收入" | mkN "收入" | mkN "毛利" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gross_V2 = mkV2 "总共赚得" ;
lin grosz_N = mkN "格罗西" ; -- open-multilingual-wordnet
lin grotesque_A = mkA "怪诞" ;
lin grotto_N = mkN "石窟" ; -- status=guess
lin ground_1_N = mkN "地面" ;
lin ground_2_N = mkN "地面" ;
lin ground_N = mkN "地面" ;
lin ground_V = mkV "使+搁浅" ;
lin ground_V2 = mkV2 "压迫" ;
lin groundcover_N = mkN "地被" ; -- open-multilingual-wordnet
lin ground_fish_N = mkN "底层鱼" | mkN "底栖鱼" ; -- open-multilingual-wordnet
lin grounding_N = mkN "接地" "" ;
lin groundless_A = mkA "无根据" | mkA "无稽" ; -- open-multilingual-wordnet
lin groundmass_N = mkN "基质" | mkN "石基" ; -- open-multilingual-wordnet
lin groundnut_N = mkN "花生" "粒" | {-mwn-} mkN "花生" | mkN "落花生" ; -- open-multilingual-wordnet
lin grounds_N = mkN "理由" "個" | {-mwn-} mkN "庭院" | mkN "院子" ; -- open-multilingual-wordnet
lin groundsheet_N = mkN "防潮布" ; -- open-multilingual-wordnet
lin groundspeed_N = mkN "地速" | mkN "对地速率" ; -- open-multilingual-wordnet
lin groundwork_N = mkN "基础" ;
lin group_N = mkN "会" "個" | mkN "团" | mkN "派" | mkN "群" | {-HSK-} mkN "组" ;
lin group_V = variants {} ; -- comment=mkV2 "聚合" ;
lin group_V2 = mkV2 "聚合" ;
lin grouper_N = mkN "石斑魚" | mkN "石斑鱼" | {-mwn-} mkN "鲈科之鱼" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin grouping_N = mkN "分组" "次" ;
lin grouse_N = mkN "岩雷鳥" | mkN "岩雷鸟" | mkN "松雞" | mkN "松鸡" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin grouse_VS = mkVS "埋怨" ;
lin grout_N = mkN "水泥浆" | mkN "用薄泥浆填塞" | mkN "薄浆" ; -- open-multilingual-wordnet
lin grove_N = mkN "小树林" "片" ;
lin grovel_V = mkV "匍匐" ;
lin groveller_N = mkN "五体投地者" | mkN "卑恭屈节者" ; -- open-multilingual-wordnet
lin grow_V = mkV "发展" | mkV "增长" | mkV "成长" | mkV "长" | {-HSK-} mkV "生长" ;
lin grow_V2 = mkV2 "发展" | mkV2 "增长" | mkV2 "成长" | mkV2 "长" ;
lin grow_VA = mkVA "发展" | mkVA "增长" | mkVA "成长" | mkVA "长" ;
lin grow_apart_V = advV OP_grow_V OP_apart_Adv ; -- guess-p-verb
lin grow_away_from_V2 = prepV2 (advV OP_grow_V OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin grow_back_V = advV OP_grow_V OP_back_Adv ; -- guess-p-verb
lin grow_from_V2 = prepV2 OP_grow_V OP_from_Prep ; -- guess-p-verb
lin grow_into_V2 = prepV2 OP_grow_V OP_into_Prep ; -- guess-p-verb
lin grow_on_V2 = prepV2 OP_grow_V OP_on_Prep ; -- guess-p-verb
lin grow_out_V = advV OP_grow_V OP_out_Adv ; -- guess-p-verb
lin grow_out_of_V2 = prepV2 (advV OP_grow_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin grow_to_V = advV OP_grow_V OP_to_Adv ; -- guess-p-verb
lin grow_together_V = advV OP_grow_V OP_together_Adv ; -- guess-p-verb
lin grow_under_V = advV OP_grow_V OP_under_Adv ; -- guess-p-verb
lin grow_up_V = mkV "成长" ;
lin grow_up_on_V2 = prepV2 (advV OP_grow_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin grow_upon_V2 = prepV2 OP_grow_V OP_upon_Prep ; -- guess-p-verb
lin grower_N = mkN "种植者" ;
lin growing_A = variants {} ;
lin growl_V = mkV "怒吠" ;
lin growl_V2 = mkV2 (mkV "嗥叫") | mkV2 (mkV "咆哮") | mkV2 (mkV "吼") | mkV2 (mkV "嘊") | mkV2 (mkV "啀") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin growth_N = mkN "发展" | {-HSK-} mkN "成长" ;
lin groyne_N = mkN "防波堤" ; -- open-multilingual-wordnet
lin grub_N = mkN "幼蟲" | mkN "幼虫" | {-mwn-} mkN "蛆" | mkN "蛴螬" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin grubbiness_N = mkN "污秽" ; -- open-multilingual-wordnet
lin grubstake_N = mkN "资助" ; -- open-multilingual-wordnet
lin grudge_N = mkN "不满" | mkN "怨恨" ; -- open-multilingual-wordnet
lin grudging_A = mkA "勉强" ;
lin gruel_N = mkN "粥" | mkN "稀飯" | mkN "稀饭" ; -- status=guess -- status=guess -- status=guess
lin gruesome_A = mkA "匆忙" ;
lin gruff_A = mkA "粗暴" ;
lin grumble_V = mkV "抱怨" | {-HSK-} mkV "啰唆" ;
lin grumble_VS = mkVS "抱怨" ;
lin grunt_N = mkN "石鲈" ; -- open-multilingual-wordnet
lin guadalajara_PN = mkPN "瓜达拉哈拉" ; -- comment=src=geonames status=guess
lin guanaco_N = mkN "原駝" | mkN "原驼" ; -- status=guess -- status=guess
lin guanine_N = mkN "鳥嘌呤" | mkN "鸟嘌呤" ; -- status=guess -- status=guess
lin guano_N = mkN "海鳥糞" | mkN "海鸟粪" ; -- status=guess -- status=guess
lin guarantee_N = mkN "保证" | {-HSK-} mkN "保证" "個" ;
lin guarantee_V = mkV "保证" ;
lin guarantee_V2 = mkV2 "保证" ;
lin guarantee_VS = mkVS "保证" ;
lin guarantor_N = mkN "担保人" "个" ;
lin guard_N = mkN "看守" ;
lin guard_V = mkV "看" | {-HSK-} mkV "防止" ;
lin guard_V2 = mkV2 "看" | {-HSK-} mkV2 "看守" ;
lin guardhouse_N = mkN "禁闭室" | mkN "警卫室" ; -- open-multilingual-wordnet
lin guardian_N = mkN "监护人" ; -- comment="保护人" ;
lin guardrail_N = mkN "護欄" | mkN "护栏" ; -- status=guess -- status=guess
lin guatemala_PN = mkPN "危地马拉" ; -- comment=src=geonames status=guess
lin guatemala_city_PN = foreignPN "Guatemala city" ; -- comment=src=eng status=guess
lin guava_N = mkN "番石榴" ; -- status=guess
lin guayaquil_PN = mkPN "瓜亞基爾" ; -- comment=src=geonames status=guess
lin gubernatorial_A = mkA "地方长官" | mkA "总督" | mkA "管辖者" | mkA "统治者" ; -- open-multilingual-wordnet
lin guenon_N = mkN "長尾猴" | mkN "长尾猴" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin guerdon_N = mkN "奖赏" | mkN "报酬" ; -- open-multilingual-wordnet
lin gueridon_N = mkN "小圆桌" ; -- open-multilingual-wordnet
lin guerrilla_N = mkN "游击队" "支" ;
lin guess_N = mkN "猜测" ;
lin guess_V = mkV "猜" | {-HSK-} mkV "猜测" ;
lin guess_V2 = mkV2 "猜" ;
lin guess_VS = mkVS "猜" ;
lin guesswork_N = mkN "猜测" ;
lin guest_N = mkN "客人" "位" | {-HSK-} mkN "嘉宾" ;
lin guesthouse_N = mkN "宾馆" "個" | {-mwn-} mkN "客房" ; -- open-multilingual-wordnet
lin guffaw_N = mkN "哄笑" ; -- status=guess
lin guffaw_V = mkV "哄笑" ; -- status=guess, src=wikt
lin guidance_N = mkN "指导" | {-HSK-} mkN "指导" "個" ;
lin guide_N = mkN "引导" [] ;
lin guide_V2 = mkV2 "引导" | {-HSK-} mkV2 "指导" ;
lin guidebook_N = mkN "手册" | mkN "指南" ; -- open-multilingual-wordnet
lin guideline_N = mkN "指引" ;
lin guidepost_N = mkN "准则" | mkN "指导方针" | mkN "指导路线" ; -- open-multilingual-wordnet
lin guild_N = mkN "公会" "个" ;
lin guilder_N = mkN "荷兰盾" ;
lin guildford_PN = mkPN "吉爾福德" ; -- comment=src=geonames status=guess
lin guild_hall_N = mkN "同业公会" ; -- open-multilingual-wordnet
lin guile_N = mkN "诡计" ;
lin guileless_A = mkA "坦率" | mkA "耿直" | mkA "诚实" ; -- open-multilingual-wordnet
lin guilloche_N = mkN "扭索状装饰" | mkN "连结环" ; -- open-multilingual-wordnet
lin guillotine_N = mkN "斷頭台" | mkN "断头台" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin guilt_N = mkN "有罪" [] ;
lin guiltiness_N = mkN "有罪" | mkN "罪状" | mkN "罪疚" | mkN "罪行" ; -- open-multilingual-wordnet
lin guiltless_A = mkA "无罪" | mkA "无辜" | mkA "清白" ; -- open-multilingual-wordnet
lin guilty_A = mkA "有罪" ;
lin guinea_N = mkN "基尼" ;
lin guinea_PN = mkPN "几内亚" ; -- comment=src=geonames status=guess
lin guisborough_PN = foreignPN "Guisborough" ; -- comment=src=geonames status=guess
lin guise_N = mkN "伪装" ;
lin guitar_N = mkN "吉他" "只" ;
lin guitarist_N = mkN "吉他手" ; -- status=guess
lin gulag_N = mkN "古拉格" ; -- status=guess -- open-multilingual-wordnet
lin gulf_N = mkN "海湾" ;
lin gull_1_N = mkN "海鷗" | mkN "海鸥" | {-mwn-} mkN "鸥" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gull_2_N = mkN "海鷗" | mkN "海鸥" | {-mwn-} mkN "鸥" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gullet_N = mkN "食道" | mkN "食管" ; -- status=guess -- status=guess
lin gullibility_N = mkN "易受骗" ; -- status=guess
lin gullible_A = mkA "轻信" ;
lin gum_N = mkN "胶" ;
lin gumboil_N = mkN "齿龈溃疡" ; -- open-multilingual-wordnet
lin gumma_N = mkN "树胶肿" ; -- open-multilingual-wordnet
lin gummosis_N = mkN "流胶病" ; -- open-multilingual-wordnet
lin gumshoe_N = mkN "套鞋" | mkN "橡胶套鞋" | mkN "胶鞋" ; -- open-multilingual-wordnet
lin gun_N = mkN "枪" "支" ;
lin gun_V2 = mkV2 "射击" ;
lin gunboat_N = mkN "小炮舰" | mkN "炮艇" ; -- open-multilingual-wordnet
lin guncotton_N = mkN "硝化纤维素" ; -- open-multilingual-wordnet
lin gunflint_N = mkN "枪击燧石" | mkN "枪机燧石" ; -- open-multilingual-wordnet
lin gunite_N = mkN "压力喷浆" | mkN "喷浆" ; -- open-multilingual-wordnet
lin gunlock_N = mkN "扳机" | mkN "枪机" ; -- open-multilingual-wordnet
lin gunman_N = mkN "枪手" ;
lin gunmetal_N = mkN "炮合金" | mkN "炮铜" | mkN "青铜" ; -- open-multilingual-wordnet
lin gunnel_N = mkN "锦鳚" ; -- open-multilingual-wordnet
lin gunner_N = mkN "枪手" ;
lin gunnery_N = mkN "大炮" | mkN "重炮" ; -- open-multilingual-wordnet
lin gunny_N = mkN "麻布袋" ;
lin gunnysack_N = mkN "粗麻布袋" | mkN "麻袋" ; -- open-multilingual-wordnet
lin gunpoint_N = mkN "枪口" ;
lin gunpowder_N = mkN "火藥" | mkN "火药" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin gunshot_N = mkN "炮击" ;
lin gunsight_N = mkN "射击瞄准具" | mkN "瞄准器" ; -- open-multilingual-wordnet
lin gunsmith_N = mkN "火砲工坊" ; -- status=guess
lin gunwale_N = mkN "舷邊" | mkN "舷边" | mkN "舷" | {-mwn-} mkN "舷的上端" | mkN "舷缘" | mkN "船的边缘" | mkN "船舷上缘" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin gurnard_N = mkN "鲂鱼" ; -- open-multilingual-wordnet
lin gurney_N = mkN "轮床" ; -- status=guess
lin guru_N = mkN "大师" ;
lin gush_V = mkV "涌出" ;
lin gusher_N = mkN "喷油井" ; -- open-multilingual-wordnet
lin gushingly_Adv = mkAdv "易动感情+地" | mkAdv "过分热情+地" ; -- open-multilingual-wordnet
lin gustation_N = mkN "味儿" | mkN "味觉" | mkN "味道" | mkN "气味" ; -- open-multilingual-wordnet
lin gustatory_A = mkA "味覺" | {-mwn-} mkA "味觉" | mkA "味觉" | mkA "尝味" ; -- status=guess -- open-multilingual-wordnet
lin gusto_N = mkN "爱好" ;
lin gut_N = mkN "肠道" "条" ;
lin gut_V2 = mkV2 "取内脏" ;
lin guts_N = L.guts_N ;
lin gutter_N = mkN "排水沟" ;
lin guttural_A = mkA "咽喉" | mkA "喉" | mkA "喉咙" ; -- open-multilingual-wordnet
lin guy's_PN = foreignPN "Guy's" ; -- comment=src=eng status=guess
lin guy_N = mkN "家伙" ;
lin guy_PN = foreignPN "Guy" ; -- comment=src=eng status=guess
lin guyana_PN = mkPN "圭亚那" ; -- comment=src=geonames status=guess
lin guzzle_V = mkV "狂饮" ;
lin guzzle_V2 = mkV2 (mkV "暴飲") | mkV2 (mkV "暴饮") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin gwen_PN = foreignPN "Gwen" ; -- comment=src=eng status=guess
lin gwendoline_PN = foreignPN "Gwendoline" ; -- comment=src=eng status=guess
lin gwent_PN = foreignPN "Gwent" ; -- comment=src=eng status=guess
lin gwersyllt_PN = foreignPN "Gwersyllt" ; -- comment=src=eng status=guess
lin gwynedd_PN = foreignPN "Gwynedd" ; -- comment=src=eng status=guess
lin gym_N = mkN "健身房" | {-HSK-} mkN "體育館" | mkN "体育馆" ; -- status=guess -- status=guess -- status=guess
lin gymnasium_N = mkN "健身房" ; -- status=guess
lin gymnast_N = mkN "體操運動員" | mkN "体操运动员" ; -- status=guess -- status=guess
lin gymnastic_A = mkA "体操" ;
lin gymnastics_N = mkN "体操" "" ;
lin gymnospermous_A = mkA "裸子植物" ; -- open-multilingual-wordnet
lin gymslip_N = mkN "无袖制服" ; -- open-multilingual-wordnet
lin gynaecological_A = mkA "妇产科医学" ; -- open-multilingual-wordnet
lin gynecological_A = mkA "妇产科医学" ; -- open-multilingual-wordnet
lin gynecologistFem_N = variants {} ; ---- sense to be split
lin gynecologistMasc_N = variants {} ; ---- sense to be split
lin gynecology_N = mkN "婦科" | mkN "妇科" ; -- status=guess -- status=guess
lin gynecomastia_N = mkN "男子女性型乳房" ; -- open-multilingual-wordnet
lin gynoecium_N = mkN "雌蕊" ; -- open-multilingual-wordnet
lin gynogenesis_N = mkN "雌核发育" | mkN "雌核生殖" ; -- open-multilingual-wordnet
lin gynophobia_N = mkN "恐女症" ; -- open-multilingual-wordnet
lin gypsum_N = mkN "石膏" ; -- open-multilingual-wordnet
lin gypsy_N = mkN "吉卜赛人" "名" ;
lin gyral_A = mkA "大脑回转" | mkA "脑回" ; -- open-multilingual-wordnet
lin gyrate_V = mkV "回旋" ;
lin gyration_N = mkN "回转" ;
lin gyro_N = mkN "回旋装置" | mkN "回转仪" | mkN "陀螺仪" ; -- open-multilingual-wordnet
lin gyromitra_N = mkN "河豚菌" | mkN "鹿花菌" | mkN "鹿花蕈" ; -- open-multilingual-wordnet
lin gyroscope_N = mkN "陀螺儀" | mkN "陀螺仪" | mkN "迴轉儀" | mkN "回转仪" | {-mwn-} mkN "回旋装置" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin gyroscopic_A = mkA "回转仪" | mkA "陀螺" ; -- open-multilingual-wordnet
lin gyrostabilizer_N = mkN "回转仪稳定器" | mkN "回转稳定器" | mkN "陀螺稳定器" ; -- open-multilingual-wordnet
lin gyrus_N = mkN "腦回" | mkN "脑回" | mkN "回" ; -- status=guess -- status=guess -- status=guess
lin ha'p'orth_N = mkN "半便士的价值" ; -- open-multilingual-wordnet
lin ha'penny_N = mkN "半便士" ; -- open-multilingual-wordnet
lin ha_Interj = variants {} ;
lin haarlem_PN = mkPN "哈勒姆" ; -- comment=src=geonames status=guess
lin haberdashery_N = mkN "杂货店" ;
lin habit_N = mkN "习惯" | {-HSK-} mkN "习惯" "個" ;
lin habitat_N = mkN "栖息地" ;
lin habitual_A = mkA "习惯" | {-mwn-} mkA "习惯" | mkA "平常" | mkA "惯常" ; -- status=guess -- open-multilingual-wordnet
lin habitude_N = mkN "习俗" | mkN "习惯" ; -- open-multilingual-wordnet
lin hack_N = mkN "砍" ;
lin hack_V = mkV "劈" ;
lin hackberry_N = mkN "朴" ; -- status=guess
lin hacker_N = mkN "黑客" ; -- status=guess
lin hackney_PN = foreignPN "Hackney" ; -- comment=src=geonames status=guess
lin hacksaw_N = mkN "鋼鋸" | mkN "钢锯" ; -- status=guess -- status=guess
lin hadal_A = mkA "海沟" ; -- open-multilingual-wordnet
lin haddington_PN = foreignPN "Haddington" ; -- comment=src=geonames status=guess
lin haddock_N = mkN "黑線鱈" | mkN "黑线鳕" ; -- status=guess -- status=guess
lin hades_PN = foreignPN "Hades" ; -- comment=src=eng status=guess
lin hadith_N = mkN "聖訓" | mkN "圣训" ; -- status=guess -- status=guess
lin haemophilia_N = mkN "血友病" ; -- open-multilingual-wordnet
lin haemophilic_A = mkA "患血友病" | mkA "血友病" ; -- open-multilingual-wordnet
lin haemorrhage_N = mkN "出血" ; -- status=guess
lin hafnium_N = mkN "鉿" | mkN "铪" ; -- status=guess -- status=guess
lin haft_N = mkN "把手" | mkN "柄" ; -- open-multilingual-wordnet
lin hag_N = mkN "黃臉婆" | mkN "黄脸婆" | mkN "老太婆" ; -- status=guess -- status=guess -- status=guess
lin hagberry_N = mkN "朴树果" ; -- open-multilingual-wordnet
lin hagen_PN = foreignPN "Hagen" ; -- comment=src=geonames status=guess
lin haggard_A = mkA "枯槁" ; -- status=guess
lin haggle_V = mkV "争论" ;
lin hagley_PN = foreignPN "Hagley" ; -- comment=src=geonames status=guess
lin haik_N = mkN "白罩袍" | mkN "长方形布" ; -- open-multilingual-wordnet
lin haiku_N = mkN "俳句" ; -- status=guess
lin hail_N = mkN "冰雹" ;
lin hail_V = mkV "冰雹" ;
lin hail_V2 = mkV2 "冰雹" ;
lin hailsham_PN = foreignPN "Hailsham" ; -- comment=src=geonames status=guess
lin haiphong_PN = mkPN "海防市" ; -- comment=src=geonames status=guess
lin hair_N = L.hair_N | {-HSK-} mkN "毛" ;
lin hairbrush_N = mkN "髮刷" | mkN "发刷" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin haircloth_N = mkN "毛布" ; -- open-multilingual-wordnet
lin haircut_N = mkN "理髮" | mkN "理发" ; -- status=guess -- status=guess
lin hairdresser_N = mkN "理发师" "位" ;
lin hairdressing_N = mkN "理发" ;
lin hairless_A = mkA "無毛" | mkA "无毛" ; -- status=guess -- status=guess
lin hairlike_A = mkA "毛一般" | mkA "毛状" ; -- open-multilingual-wordnet
lin hairline_N = mkN "发际线" ;
lin hairnet_N = mkN "髮網" | mkN "发网" | mkN "頭套" | mkN "头套" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hairpin_N = mkN "釵" | mkN "钗" | mkN "簪" | mkN "髮夾" | mkN "发夹" | mkN "髮卡" | mkN "发卡" | {-mwn-} mkN "发簪" | mkN "夹发针" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hairspring_N = mkN "细发条" ; -- open-multilingual-wordnet
lin hairstreak_N = mkN "小灰蝶" ; -- open-multilingual-wordnet
lin hairstyle_N = mkN "髮型" | mkN "发型" | mkN "髮式" | mkN "发式" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin hairy_A = mkA "毛茸茸" ;
lin haiti_PN = mkPN "海地" ; -- comment=src=geonames status=guess
lin hajj_N = mkN "朝覲" | mkN "朝觐" | mkN "朝聖" | mkN "朝圣" | mkN "麥加朝聖" | mkN "麦加朝圣" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin hal_PN = foreignPN "Hal" ; -- comment=src=eng status=guess
lin halal_A = mkA "清真" ; -- status=guess
lin halberd_N = mkN "戟" | mkN "斧槍" | mkN "斧枪" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin halesowen_PN = foreignPN "Halesowen" ; -- comment=src=geonames status=guess
lin half_A = mkA "一半" | {-HSK-} mkA "半" ;
lin half_Adv = mkAdv "半" ;
lin half_N = mkN "一半" | {-HSK-} mkN "半" ;
lin half_Predet = mkPredet "半" ;
lin half_baked_A = mkA "一半" ;
lin halfbeak_N = mkN "鱼箴科鱼" ; -- open-multilingual-wordnet
lin halfpenny_N = mkN "半便士" ; -- open-multilingual-wordnet
lin halfpennyworth_N = mkN "半便士的价值" ; -- open-multilingual-wordnet
lin halftime_N = mkN "中场休息" ; -- open-multilingual-wordnet
lin halftone_N = mkN "照相雕刻术" ; -- open-multilingual-wordnet
lin halfway_A = mkA "中途" ;
lin halfway_Adv = mkAdv "到一半" ;
lin halibut_N = mkN "大比目魚" | mkN "大比目鱼" ; -- status=guess -- status=guess
lin halifax_PN = foreignPN "Halifax" ; -- comment=src=geonames status=guess
lin halite_N = mkN "岩盐" | mkN "石盐" ; -- open-multilingual-wordnet
lin halitosis_N = mkN "口臭" ; -- status=guess -- open-multilingual-wordnet
lin halitus_N = mkN "呼出气" ; -- open-multilingual-wordnet
lin hall_N = mkN "大厅" ;
lin halle_PN = mkPN "哈莱" ; -- comment=src=geonames status=guess
lin halliard_N = mkN "升降索" | mkN "吊索" ; -- open-multilingual-wordnet
lin hallmark_N = mkN "标志" ;
lin hallow_V2 = mkV2 "使+神圣" ;
lin hallowe'en_PN = foreignPN "Hallowe'en" ; -- comment=src=eng status=guess
lin hall_stand_N = mkN "衣帽架" ; -- open-multilingual-wordnet
lin hallucination_N = mkN "幻覺" | mkN "幻觉" | mkN "幻想" ; -- status=guess -- status=guess -- status=guess
lin hallucinatory_A = mkA "引起幻觉" ; -- open-multilingual-wordnet
lin hallucinogen_N = mkN "致幻剂" | mkN "迷幻剂" ; -- open-multilingual-wordnet
lin hallucinosis_N = mkN "幻觉症" | mkN "精神错乱症" ; -- open-multilingual-wordnet
lin halo_N = mkN "晕" ;
lin haloform_N = mkN "卤仿" ; -- open-multilingual-wordnet
lin halogen_N = mkN "鹵 卤素" | mkN "鹵族" ; -- status=guess -- status=guess
lin halstead_PN = foreignPN "Halstead" ; -- comment=src=geonames status=guess
lin halt_A = mkA "停止" ;
lin halt_N = mkN "停止" ;
lin halt_V = mkV "停止" | {-HSK-} mkV "站" ;
lin halt_V2 = mkV2 "停止" | {-HSK-} mkV2 "站" ;
lin halter_N = mkN "韁繩" | mkN "缰绳" ; -- status=guess -- status=guess
lin haltingly_Adv = mkAdv "迟疑不决地" ;
lin halve_V2 = mkV2 "二等分" ;
lin halyard_N = mkN "升降索" | mkN "吊索" ; -- open-multilingual-wordnet
lin ham_N = mkN "火腿" ;
lin ham_V = mkV "演得过火" ;
lin ham_V2 = mkV2 (mkV "有意誇張") | mkV2 (mkV "有意夸张") | mkV2 (mkV "表演過火") | mkV2 (mkV "表演过火") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin ham_handed_A = mkA "笨手笨脚" ;
lin hamartoma_N = mkN "错构瘤" ; -- open-multilingual-wordnet
lin hamburg_PN = mkPN "汉堡" ;
lin hamburger_N = mkN "汉堡" ;
lin hamelia_N = mkN "长隔木属植物" ; -- open-multilingual-wordnet
lin hamhung_PN = foreignPN "Hamhung" ; -- comment=src=eng status=guess
lin hamilton_PN = mkPN ("汉密尔顿" | "漢密爾頓" | "哈密尔顿") ; -- comment=src=geonames status=guess
lin hamlet_N = mkN "村莊" | mkN "村庄" | mkN "小村" ; -- status=guess -- status=guess -- status=guess
lin hammer_N = mkN "锤" "个" ;
lin hammer_V = mkV "铁锤" ;
lin hammer_V2 = mkV2 "锤打" ;
lin hammersmith_PN = mkPN "哈默史密斯" ; -- comment=src=geonames status=guess
lin hammock_N = mkN "吊床" ; -- status=guess -- open-multilingual-wordnet
lin hammy_A = mkA "闹剧" ; -- open-multilingual-wordnet
lin hamper_V2 = mkV2 "阻碍" ;
lin hampreston_PN = foreignPN "Hampreston" ; -- comment=src=eng status=guess
lin hampshire_PN = foreignPN "Hampshire" ; -- comment=src=geonames status=guess
lin hamster_N = mkN "倉鼠" | mkN "仓鼠" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hamstring_V2 = mkV2 "割断腿筋" ;
lin hand_N = L.hand_N ;
lin hand_V2 = mkV2 "递交" ;
lin hand_back_V2 = mkV2 (advV (lin V OP_hand_V2) OP_back_Adv ) ; -- guess-p-verb
lin hand_carry_V2 = mkV2 "手提" ;
lin hand_down_V2 = mkV2 "流传" ;
lin hand_in_V2 = prepV2 (lin V OP_hand_V2) OP_in_Prep ; -- guess-p-verb
lin hand_on_V2 = prepV2 (lin V OP_hand_V2) OP_on_Prep ; -- guess-p-verb
lin hand_out_V2 = prepV2 (lin V OP_hand_V2) OP_out_Prep ; -- guess-p-verb
lin hand_over_V2 = mkV2 "交" | mkV2 "递" ;
lin hand_picked_A = mkA "拣选" ;
lin handbag_N = mkN "皮包" | {-mwn-} mkN "手提包" | mkN "钱包" ; -- status=guess -- open-multilingual-wordnet
lin handball_N = mkN "手球" ; -- status=guess
lin handbell_N = mkN "手摇铃" | mkN "手铃" ; -- open-multilingual-wordnet
lin handbill_N = mkN "传单""张" ;
lin handbook_N = mkN "手册" ;
lin handbow_N = mkN "手弓" ; -- open-multilingual-wordnet
lin handbrake_N = mkN "手掣" | mkN "手剎車" | mkN "手刹车" | mkN "手閘" | mkN "手闸" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin handbreadth_N = mkN "一手宽" | mkN "手宽" ; -- open-multilingual-wordnet
lin handcar_N = mkN "手摇车" | mkN "手泵车" ; -- open-multilingual-wordnet
lin handcart_N = mkN "手車" | mkN "手车" | mkN "手推車" | mkN "手推车" | mkN "手拉車" | mkN "手拉车" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin handcuff_N = mkN "手铐" ;
lin handcuff_V2 = mkV2 "给+戴上手铐" ;
lin handful_N = mkN "少数" ;
lin handgun_N = mkN "短槍" | mkN "短枪" | mkN "手槍" | mkN "手枪" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin handicap_N = mkN "妨碍" ;
lin handicap_V2 = mkV2 "阻碍" ;
lin handicapped_A = {-HSK-} mkA "残疾" ;
lin handicraft_N = mkN "手工業" | mkN "手工业" | mkN "手藝" | mkN "手艺" | mkN "手工藝" | mkN "手工艺" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin handiwork_N = mkN "手工" | {-mwn-} mkN "手工制品" | mkN "手工艺品" ; -- status=guess -- open-multilingual-wordnet
lin handkerchief_N = mkN "手帕" | mkN "手絹" | mkN "手绢" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin handle_N = mkN "处理" "次" ;
lin handle_V = mkV "从事" | mkV "办理" | mkV "处理" | mkV "弄" | mkV "符合" ;
lin handle_V2 = mkV2 "从事" | mkV2 "办理" | mkV2 "处理" | mkV2 "弄" | mkV2 "符合" ;
lin handlebar_N = mkN "手把" | mkN "龙头" ; -- open-multilingual-wordnet
lin handleless_A = mkA "无柄" ; -- open-multilingual-wordnet
lin handler_N = mkN "处理者" "名" ;
lin handline_N = mkN "手执的钓丝" | mkN "无竿钓丝" | mkN "简便钓丝" ; -- open-multilingual-wordnet
lin handling_N = mkN "处理" "次" ;
lin handrail_N = mkN "扶手" | {-mwn-} mkN "栏杆" | mkN "栏杆的支柱" | mkN "楼梯栏杆小柱" ; -- status=guess -- open-multilingual-wordnet
lin handrest_N = mkN "放手架" ; -- open-multilingual-wordnet
lin handsaw_N = mkN "手鋸" | mkN "手锯" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin handset_N = mkN "話筒" | mkN "话筒" ; -- status=guess -- status=guess
lin handshake_N = mkN "握手" ;
lin handsome_A = mkA "帅" | {-HSK-} mkA "英俊" ;
lin handsomeness_N = mkN "帥氣" | mkN "帅气" | mkN "英俊" | mkN "俊俏" | mkN "漂亮" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin handspike_N = mkN "手杆" | mkN "手竿" | mkN "推杆" | mkN "木梃" ; -- open-multilingual-wordnet
lin handspring_N = mkN "翻斤斗" | mkN "翻筋斗" ; -- open-multilingual-wordnet
lin handstand_N = mkN "倒立" ;
lin handwork_N = mkN "手工" | {-mwn-} mkN "手工制品" | mkN "手工艺品" ; -- status=guess -- open-multilingual-wordnet
lin handwriting_N = mkN "手写" ;
lin handwritten_A = mkA "手写" ; -- open-multilingual-wordnet
lin handy_A = mkA "便" | {-HSK-} mkA "便利" ;
lin hang_N = mkN "悬挂""" ;
lin hang_V = mkV "挂" ;
lin hang_V2 = mkV2 "悬挂" ;
lin hang_about_V = advV OP_hang_V OP_about_Adv ; -- guess-p-verb
lin hang_around_V = advV OP_hang_V OP_around_Adv ; -- guess-p-verb
lin hang_around_V2 = prepV2 OP_hang_V OP_around_Prep ; -- guess-p-verb
lin hang_back_V = mkV "拖" | mkV "拖拉" | mkV "落后" | mkV "落后于" | mkV "迟缓" ; -- open-multilingual-wordnet
lin hang_back_from_V2 = prepV2 (advV OP_hang_V OP_back_Adv ) OP_from_Prep ; -- guess-p-verb
lin hang_in_there_V = variants {} ; -- guess-p-verb
lin hang_it_up_V = variants {} ; -- guess-p-verb
lin hang_on_V = mkV "不屈不挠" | mkV "坚持" | mkV "坚持不懈" | mkV "孜孜不倦" ; -- open-multilingual-wordnet
lin hang_onto_V2 = prepV2 OP_hang_V OP_onto_Prep ; -- guess-p-verb
lin hang_out_V = advV OP_hang_V OP_out_Adv ; -- guess-p-verb
lin hang_out_V2 = prepV2 OP_hang_V OP_out_Prep ; -- guess-p-verb
lin hang_out_for_V2 = prepV2 (advV OP_hang_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin hang_over_V2 = mkV2 "悬挂" ;
lin hang_together_V = mkV "互相依赖" | mkV "前后照应" | mkV "团结一致" ; -- open-multilingual-wordnet
lin hang_up_V = advV OP_hang_V OP_up_Adv ; -- guess-p-verb
lin hang_up_V2 = prepV2 OP_hang_V OP_up_Prep ; -- guess-p-verb
lin hang_up_on_V2 = prepV2 (advV OP_hang_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin hang_with_V2 = prepV2 OP_hang_V OP_with_Prep ; -- guess-p-verb
lin hangar_N = mkN "飞机库" "间" ;
lin hangchon_PN = foreignPN "Hangchon" ; -- comment=src=eng status=guess
lin hanger_N = mkN "衣架" | {-mwn-} mkN "悬挂工具" ; -- status=guess -- open-multilingual-wordnet
lin hanging_N = mkN "悬挂" "次" ;
lin hangnail_N = mkN "倒刺" | mkN "肉刺" ; -- status=guess -- status=guess
lin hangover_N = mkN "宿醉" ;
lin hank_N = mkN "束" [] ;
lin hanker_V = mkV "渴望" ; -- open-multilingual-wordnet
lin hanky_N = mkN "手帕" | mkN "手绢" ; -- open-multilingual-wordnet
lin hanoi_PN = mkPN "河內市" ; -- comment=src=geonames status=guess
lin hanover_PN = foreignPN "Hanover" ; -- comment=src=geonames status=guess
lin hao_N = mkN "角" ; -- open-multilingual-wordnet
lin haphazard_A = mkA "偶然" | mkA "雜亂無章 杂乱无章" ; -- status=guess -- status=guess
lin haphazard_Adv = mkAdv "乱七八糟+地" | mkAdv "草率+地" | mkAdv "随意+地" ; -- open-multilingual-wordnet
lin hapless_A = mkA "倒霉" ;
lin haploidy_N = mkN "单倍性" ; -- open-multilingual-wordnet
lin haply_Adv = mkAdv "偶尔+地" | mkAdv "偶然+地" | mkAdv "意外+地" | mkAdv "碰巧" ; -- open-multilingual-wordnet
lin happen_V = mkV "出" | mkV "发生" ;
lin happen_VV = mkVV "出" | mkVV "发生" ;
lin happening_N = mkN "事件" ;
lin happiness_N = mkN "幸福" | {-HSK-} mkN "幸福" "" ;
lin happy_A = mkA "幸福" | mkA "快乐" | mkA "愉快" | mkA "高兴" ;
lin harangue_N = mkN "高谈阔论" ;
lin harass_V2 = mkV2 "使+困扰" ;
lin harassment_N = mkN "骚扰" "次" ;
lin harbin_PN = foreignPN "Ha’erbin" ; -- comment=src=geonames status=guess
lin harbinger_N = mkN "先驱" ;
lin harbour_N = L.harbour_N ;
lin hard_1_A = variants {} ;
lin hard_2_A = {-mwn-} mkA "困难" | mkA "艰苦" | mkA "艰难" | mkA "难" | mkA "难以" ; -- open-multilingual-wordnet
lin hard_bitten_A = mkA "强硬" ;
lin hard_boiled_A = mkA "煮过熟了" | mkA "不动感情" ;
lin hardback_N = mkN "硬封面书" | mkN "硬封面的书" | mkN "精装书" | mkN "精装本" ; -- open-multilingual-wordnet
lin hardbound_A = mkA "精装" ;
lin hardcover_N = mkN "精装" ;
lin harden_V2 = mkV2 "变硬" ;
lin hardening_N = mkN "使强壮" | mkN "强化" | mkN "硬化" ; -- open-multilingual-wordnet
lin hard_headed_A = mkA "务实" | mkA "实践" | mkA "实际" | mkA "讲究实际" ; -- open-multilingual-wordnet
lin hardliner_N = mkN "强硬路线" ;
lin hardly_AdV = mkAdV "硬" | {-HSK-} mkAdV "艰苦" | mkAdV "辛苦" ; -- comment=NOT SURE "硬" or "困难"
lin hardly_Adv = mkAdv "仅仅" | mkAdv "几乎不" | mkAdv "简直不" | mkAdv "简直没有" ; -- open-multilingual-wordnet
lin hardship_N = mkN "困苦" "" | {-HSK-} mkN "苦" ;
lin hardtop_N = mkN "硬顶汽车" ; -- open-multilingual-wordnet
lin hardware_N = mkN "硬件" ;
lin hardwood_N = mkN "硬木" ;
lin hardworking_A = mkA "刻苦" | mkA "勤劳" | mkA "勤奋" | {-HSK-} mkA "努力工作" ;
lin hardy_A = mkA "坚强" ;
lin hare_N = mkN "兔子" "隻" | {-HSK-} mkN "野兔" | mkN "兔子" ; -- status=guess -- status=guess
lin hare_V = mkV "飞跑" ; -- open-multilingual-wordnet
lin harebrained_A = mkA "愚蠢" | mkA "极愚蠢" | mkA "荒唐" | mkA "非常愚蠢" ; -- open-multilingual-wordnet
lin harelip_N = mkN "兔唇" ; -- status=guess -- open-multilingual-wordnet
lin harem_N = mkN "後宮" | mkN "后宫" | {-mwn-} mkN "闺房" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin haringey_PN = foreignPN "Haringey" ; -- comment=src=eng status=guess
lin harlequin_N = mkN "醜鴨" | mkN "丑鸭" ; -- status=guess -- status=guess
lin harley_street_PN = foreignPN "Harley street" ; -- comment=src=eng status=guess
lin harlow_PN = foreignPN "Harlow" ; -- comment=src=geonames status=guess
lin harm_N = mkN "伤害" "次" ;
lin harm_V2 = mkV2 "伤害" | {-HSK-} mkV2 "危害" ;
lin harmful_A = mkA "有害" ;
lin harmless_A = mkA "无害" ;
lin harmonica_N = mkN "口琴" ; -- status=guess -- open-multilingual-wordnet
lin harmonious_A = mkA "和谐" | {-HSK-} mkA "和睦" | mkA "融洽" ;
lin harmonium_N = mkN "小风琴" ; -- open-multilingual-wordnet
lin harmonizable_A = mkA "可调和" ; -- open-multilingual-wordnet
lin harmonize_V = mkV "协调" ;
lin harmonize_V2 = mkV2 "协调" ;
lin harmony_N = mkN "和" | {-HSK-} mkN "和谐" [] ;
lin harness_N = mkN "挽具" ; -- status=guess
lin harness_V2 = mkV2 "治理" ;
lin harold_PN = foreignPN "Harold" ; -- comment=src=eng status=guess
lin harp_N = mkN "豎琴" | mkN "竖琴" | {-mwn-} mkN "口琴" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin harp_V = mkV "喋喋不休" ;
lin harpenden_PN = foreignPN "Harpenden" ; -- comment=src=geonames status=guess
lin harpoon_N = mkN "魚叉" | mkN "鱼叉" | {-mwn-} mkN "鱼镖" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin harpsichord_N = mkN "大鍵琴" | mkN "大键琴" | {-mwn-} mkN "拨弦古钢琴" | mkN "拨弦键琴" | mkN "羽管键琴" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin harpsichordist_N = mkN "大鍵琴演奏家" | mkN "大键琴演奏家" ; -- status=guess -- status=guess
lin harpullia_N = mkN "假山萝属植物" ; -- open-multilingual-wordnet
lin harridan_N = mkN "老太婆" | mkN "老潑婦" | mkN "老泼妇" ; -- status=guess -- status=guess -- status=guess
lin harriet_PN = foreignPN "Harriet" ; -- comment=src=eng status=guess
lin harrogate_PN = foreignPN "Harrogate" ; -- comment=src=geonames status=guess
lin harrow_N = mkN "耙" | mkN "耖" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin harrow_PN = foreignPN "Harrow" ; -- comment=src=geonames status=guess
lin harry_PN = foreignPN "Harry" ; -- comment=src=eng status=guess
lin harry_V2 = mkV2 "打" ;
lin harsh_A = mkA "苛刻" ;
lin harshness_N = mkN "刺耳" ;
lin hartebeest_N = mkN "狷羚" | mkN "麋羚" | {-mwn-} mkN "大羚羊" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hartlepool_PN = mkPN "哈特爾浦" ; -- comment=src=geonames status=guess
lin hartley_PN = foreignPN "Hartley" ; -- comment=src=geonames status=guess
lin harvest_N = mkN "收成" ;
lin harvest_V2 = mkV2 "收割" ;
lin harvester_N = mkN "收割机" | mkN "收获机" | mkN "采伐机械" ; -- open-multilingual-wordnet
lin harvestman_N = mkN "盲蛛" ; -- status=guess
lin harvey_PN = foreignPN "Harvey" ; -- comment=src=geonames status=guess
lin harwich_PN = foreignPN "Harwich" ; -- comment=src=geonames status=guess
lin harwood_PN = foreignPN "Harwood" ; -- comment=src=eng status=guess
lin harworth_PN = foreignPN "Harworth" ; -- comment=src=eng status=guess
lin hash_N = mkN "井號" | mkN "井号" | mkN "井字" | {-mwn-} mkN "印度大麻" | mkN "大麻" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hash_V2 = mkV2 "哈希" ;
lin hash_out_V = mkV "洽谈" | mkV "讨论" | mkV "谈" | mkV "谈论" ; -- open-multilingual-wordnet
lin hashish_N = mkN "印度大麻" "" ;
lin haslemere_PN = foreignPN "Haslemere" ; -- comment=src=geonames status=guess
lin haslingden_PN = foreignPN "Haslingden" ; -- comment=src=geonames status=guess
lin hassium_N = mkN "𨭆" ; -- status=guess
lin hassle_N = mkN "麻烦" ;
lin hassle_V = mkV "騷攪" | mkV "骚搅" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin hassle_V2 = mkV2 (mkV "騷攪") | mkV2 (mkV "骚搅") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin haste_N = mkN "赶快" ;
lin hasten_V2 = mkV2 "赶快" ;
lin hastings_PN = mkPN ("黑斯廷斯" | "海斯廷斯") ; -- comment=src=geonames status=guess
lin hasty_A = mkA "匆" | {-HSK-} mkA "匆忙" ;
lin hat_N = L.hat_N | {-HSK-} mkN "帽子" "頂" ;
lin hatband_N = mkN "帽帶" | mkN "帽带" | {-mwn-} mkN "帽圈" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hatbox_N = mkN "帽盒" ; -- open-multilingual-wordnet
lin hatch_N = mkN "艙口" | mkN "舱口" | {-mwn-} mkN "开口" | mkN "舱口盖" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hatch_V = mkV "孵化" | mkV "孵出" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin hatch_V2 = mkV2 "策划" ;
lin hatchback_N = mkN "掀背車" | mkN "掀背车" ; -- status=guess -- status=guess
lin hatchel_N = mkN "麻梳" ; -- open-multilingual-wordnet
lin hatchet_N = mkN "斧头" "把" ;
lin hatchway_N = mkN "舱门" ; -- open-multilingual-wordnet
lin hate_N = mkN "憎恨" ;
lin hate_V2 = L.hate_V2 | {-HSK-} mkV2 "恨" ;
lin hate_VV = mkVV "恨" ;
lin hate_on_V2 = prepV2 (lin V OP_hate_V2) OP_on_Prep ; -- guess-p-verb
lin hatemonger_N = mkN "煽動仇恨者" | mkN "煽动仇恨者" ; -- status=guess -- status=guess
lin hater_N = mkN "仇恨者" ; -- status=guess
lin hatfield_PN = mkPN "哈特菲尔德" ; -- comment=src=geonames status=guess
lin hatpin_N = mkN "帽针" ; -- open-multilingual-wordnet
lin hatred_N = mkN "憎恨" ;
lin hatter_N = mkN "帽匠" ; -- status=guess
lin hauberk_N = mkN "锁子甲" ; -- open-multilingual-wordnet
lin haughty_A = mkA "傲慢" ;
lin haul_N = mkN "拉" "" ;
lin haul_V = mkV "拖拉" ;
lin haul_V2 = mkV2 "拖运" ;
lin haul_out_V2 = mkV2 "用力拖拉" ;
lin haulage_N = mkN "托运" [] | {-HSK-} mkN "运输" "個" ;
lin haulm_N = mkN "稻草" | mkN "茎" | mkN "豆秸" | mkN "麦秸" ; -- open-multilingual-wordnet
lin haunch_N = mkN "腰腿" ; -- open-multilingual-wordnet
lin haunt_N = mkN "栖息地" "片" ;
lin haunt_V2 = mkV2 "出没" ;
lin hausmannite_N = mkN "黑锰矿" ; -- open-multilingual-wordnet
lin hauteur_N = mkN "傲慢" "次" ;
lin havana_PN = mkPN "哈瓦那" ; -- comment=src=geonames status=guess
lin have_V = mkV "具备" | mkV "所有" | mkV "有" ;
lin have_V2 = S.have_V2 | {-HSK-} mkV2 "具备" | mkV2 "所有" | mkV2 "有" ;
lin have_VV = mkVV "具备" | mkVV "所有" | mkVV "有" ;
lin have_against_V2 = prepV2 OP_have_V OP_against_Prep ; -- guess-p-verb
lin have_around_V2 = prepV2 OP_have_V OP_around_Prep ; -- guess-p-verb
lin have_down_as_V3 = variants {} ; -- guess-p-verb
lin have_in_V2 = prepV2 OP_have_V OP_in_Prep ; -- guess-p-verb
lin have_it_away_V = variants {} ; -- guess-p-verb
lin have_it_in_for_V2 = variants {} ; -- guess-p-verb
lin have_it_off_V = variants {} ; -- guess-p-verb
lin have_it_out_with_V2 = variants {} ; -- guess-p-verb
lin have_off_V2 = prepV2 OP_have_V OP_off_Prep ; -- guess-p-verb
lin have_on_V = advV OP_have_V OP_on_Adv ; -- guess-p-verb
lin have_on_V2 = prepV2 OP_have_V OP_on_Prep ; -- guess-p-verb
lin have_over_V2 = prepV2 OP_have_V OP_over_Prep ; -- guess-p-verb
lin have_round_V2 = prepV2 OP_have_V OP_round_Prep ; -- guess-p-verb
lin have_up_V2 = prepV2 OP_have_V OP_up_Prep ; -- guess-p-verb
lin havelock_N = mkN "遮阳布" | mkN "遮颈布" ; -- open-multilingual-wordnet
lin haven_N = mkN "避风港" ;
lin haverfordwest_PN = mkPN "哈弗福韦斯特" ; -- comment=src=geonames status=guess
lin haverhill_PN = foreignPN "Haverhill" ; -- comment=src=geonames status=guess
lin havering_PN = foreignPN "Havering" ; -- comment=src=eng status=guess
lin haversack_N = mkN "帆布背包" | mkN "背包" | mkN "背囊" ; -- open-multilingual-wordnet
lin havoc_N = mkN "浩劫" ;
lin hawaii_PN = mkPN "夏威夷" ;
lin hawick_PN = foreignPN "Hawick" ; -- comment=src=geonames status=guess
lin hawk_N = mkN "鹰" ;
lin hawk_V2 = mkV2 "清嗓" ;
lin hawke's_bay_PN = foreignPN "Hawke's bay" ; -- comment=src=eng status=guess
lin hawker_N = mkN "小贩" "个" ;
lin hawkmoth_N = mkN "天蛾科之蛾" ; -- open-multilingual-wordnet
lin hawse_N = mkN "锚链孔" | mkN "锚链筒" ; -- open-multilingual-wordnet
lin hawthorn_N = mkN "山楂" | {-mwn-} mkN "山里果" | mkN "山里红" | mkN "山里红果" | mkN "红果" | mkN "红果子" | mkN "酸枣" | mkN "酸里红" ; -- status=guess -- open-multilingual-wordnet
lin hay_N = mkN "干草" ;
lin hayfield_N = mkN "牧场" | mkN "草地" ; -- open-multilingual-wordnet
lin hayfork_N = mkN "干草叉" ; -- open-multilingual-wordnet
lin hayling_PN = foreignPN "Hayling" ; -- comment=src=eng status=guess
lin hayloft_N = mkN "储藏干草料的顶棚" | mkN "干草棚" | mkN "贮放干草的顶阁" ; -- open-multilingual-wordnet
lin haymow_N = mkN "储藏干草料的顶棚" | mkN "干草棚" | mkN "贮放干草的顶阁" ; -- open-multilingual-wordnet
lin hayrack_N = mkN "干草架" ; -- open-multilingual-wordnet
lin haystack_N = mkN "草垛" ; -- status=guess
lin haywards_heath_PN = foreignPN "Haywards heath" ; -- comment=src=eng status=guess
lin hazard_N = mkN "风险" ;
lin hazardous_A = mkA "危险" ;
lin hazardousness_N = mkN "危险" ; -- open-multilingual-wordnet
lin hazel_A = mkA "淡褐色" | mkA "赤褐色" | mkA "黄褐色" ; -- open-multilingual-wordnet
lin hazel_PN = foreignPN "Hazel" ; -- comment=src=eng status=guess
lin hazelnut_N = mkN "榛子" ; -- status=guess
lin he_Pron = S.he_Pron ;
lin head_A = {-HSK-} mkA "脑袋" | mkA "长" ;
lin head_N = L.head_N | {-HSK-} mkN "脑袋" "顆" | mkN "长" ;
lin head_V = mkV "率领" ;
lin head_V2 = mkV2 "率领" ;
lin head_for_V2 = prepV2 OP_head_V OP_for_Prep ; -- guess-p-verb
lin head_off_V = advV OP_head_V OP_off_Adv ; -- guess-p-verb
lin head_off_V2 = prepV2 OP_head_V OP_off_Prep ; -- guess-p-verb
lin head_out_V = advV OP_head_V OP_out_Adv ; -- guess-p-verb
lin head_up_V2 = prepV2 OP_head_V OP_up_Prep ; -- guess-p-verb
lin headache_N = mkN "头痛" "" ;
lin headband_N = mkN "頭帶" | mkN "头带" | {-mwn-} mkN "头巾" | mkN "束带" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin headboard_N = mkN "床头板" ; -- open-multilingual-wordnet
lin headdress_N = mkN "头饰" ; -- open-multilingual-wordnet
lin headfast_N = mkN "船首系索" | mkN "艏系索" ; -- open-multilingual-wordnet
lin headgear_N = mkN "帽子" | {-mwn-} mkN "头饰" ; -- status=guess -- open-multilingual-wordnet
lin heading_N = mkN "标题" "个" ;
lin headlamp_N = mkN "前燈" | mkN "前灯" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin headless_A = mkA "無頭" | mkA "无头" ; -- status=guess -- status=guess
lin headlight_N = mkN "大灯" ;
lin headline_N = mkN "标题" ;
lin headlong_Adv = mkAdv "头向前" ;
lin headmaster_N = mkN "校长" "位" ;
lin headpin_N = mkN "中央瓶" ; -- open-multilingual-wordnet
lin headquarters_N = variants {} ;
lin headrace_N = mkN "导水渠" | mkN "引水渠道" | mkN "送水渠" ; -- open-multilingual-wordnet
lin headrest_N = mkN "头枕" ;
lin headscarf_N = mkN "頭巾" | mkN "头巾" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin headset_N = mkN "耳机" ;
lin headspace_N = mkN "顶端空间" | mkN "顶部空间" ; -- open-multilingual-wordnet
lin headstand_N = mkN "倒立" | mkN "头倒立" | mkN "头手倒立" ; -- open-multilingual-wordnet
lin headstock_N = mkN "主轴承" | mkN "头座" ; -- open-multilingual-wordnet
lin headstone_N = mkN "墓石" | {-mwn-} mkN "墓碑" ; -- status=guess -- open-multilingual-wordnet
lin headstrong_A = mkA "任性" ; -- status=guess
lin headway_N = mkN "进展" ;
lin headword_N = mkN "標題字" | mkN "标题字" ; -- status=guess -- status=guess
lin heady_A = mkA "风头正劲" ;
lin heal_V = mkV "治愈" ;
lin heal_V2 = mkV2 "治愈" ;
lin healer_N = mkN "医疗者" | mkN "治疗学家" ; -- open-multilingual-wordnet
lin healing_N = mkN "康复" ; -- open-multilingual-wordnet
lin health_N = mkN "健康" | {-HSK-} mkN "身体" "個" ;
lin healthy_A = mkA "健康" ;
lin heanor_PN = foreignPN "Heanor" ; -- comment=src=geonames status=guess
lin heap_N = mkN "堆" ;
lin heap_V2 = mkV2 "堆" ;
lin heaps_Adv = mkAdv "很" | mkAdv "非常" ; -- open-multilingual-wordnet
lin hear_V = mkV "听" | {-HSK-} mkV "闻" ;
lin hear_V2 = L.hear_V2 | {-HSK-} mkV2 "听" | mkV2 "闻" ;
lin hear_V2V = mkV2V "听" | mkV2V "闻" | {-HSK-} mkV2V "听说" ;
lin hear_VS = mkVS "听" | {-HSK-} mkVS "闻" ;
lin hear_about_V2 = prepV2 OP_hear_V OP_about_Prep ; -- guess-p-verb
lin hear_from_V2 = prepV2 OP_hear_V OP_from_Prep ; -- guess-p-verb
lin hear_of_V2 = mkV2 "听说" ;
lin hear_of_V3 = variants {} ; -- guess-p-verb
lin hear_out_V2 = prepV2 OP_hear_V OP_out_Prep ; -- guess-p-verb
lin hearing_N = mkN "听力" ;
lin hearsay_N = mkN "傳聞" | mkN "传闻" | mkN "風聞" | mkN "风闻" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin hearse_N = mkN "柩車" | mkN "柩车" | mkN "殯車" | mkN "殡车" | mkN "靈車" | mkN "灵车" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin heart_N = L.heart_N | {-HSK-} mkN "中心" "個" | mkN "心脏" "顆" | mkN "胸" ;
lin heart_rending_A = mkA "令人心碎" ;
lin heartache_N = mkN "心痛" | {-mwn-} mkN "悲伤" | mkN "痛苦" ; -- status=guess -- open-multilingual-wordnet
lin heartbeat_N = mkN "心跳" ;
lin heartbreak_N = mkN "悲伤" | mkN "痛苦" ; -- open-multilingual-wordnet
lin heartburn_N = mkN "燒心" | mkN "烧心" | mkN "胃灼熱" | mkN "胃灼热" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hearten_V2 = mkV2 "鼓励" ;
lin heartening_A = mkA "可喜" | {-HSK-} mkA "鼓舞" ; -- status=guess
lin heartfelt_A = mkA "衷心" ;
lin hearth_N = mkN "爐床" | mkN "炉床" | mkN "爐邊" | mkN "炉边" | {-mwn-} mkN "壁炉" | mkN "暖炉" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hearthrug_N = mkN "壁炉前地毯" | mkN "炉前的地毯" ; -- open-multilingual-wordnet
lin hearthstone_N = mkN "炉石" | mkN "砌炉的石块" ; -- open-multilingual-wordnet
lin heartland_N = mkN "中心地带" ;
lin heartless_A = mkA "殘忍" | mkA "残忍" | mkA "無情" | mkA "无情" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin heartrot_N = mkN "心腐病" ; -- open-multilingual-wordnet
lin hearts_N = mkN "紅桃" | mkN "红桃" ; -- status=guess -- status=guess
lin heartstrings_N = mkN "心弦" ; -- status=guess
lin heartwood_N = mkN "中心木材" | mkN "心材" | mkN "树干" | mkN "赤木质" ; -- open-multilingual-wordnet
lin hearty_A = mkA "热烈" ;
lin heat_N = mkN "热" ;
lin heat_V = mkV "发热" ;
lin heat_V2 = mkV2 "加热" ;
lin heat_up_V2 = mkV2 "热" ;
lin heated_A = mkA "加热" ;
lin heater_N = mkN "加热器" ;
lin heathen_A = mkA "異教" ; -- status=guess
lin heathen_N = mkN "異教徒" ; -- status=guess
lin heather_PN = foreignPN "Heather" ; -- comment=src=eng status=guess
lin heathlike_A = mkA "像荒地一样" ; -- open-multilingual-wordnet
lin heating_N = mkN "加热" [] ;
lin heatstroke_N = mkN "中暑" ; -- open-multilingual-wordnet
lin heatwave_N = mkN "熱浪" | mkN "热浪" ; -- status=guess -- status=guess
lin heaume_N = mkN "大头盔" ; -- open-multilingual-wordnet
lin heave_N = mkN "举起""" ;
lin heave_V = mkV "举起" ;
lin heave_V2 = mkV2 "举起" ;
lin heaven_N = mkN "天空" ;
lin heavenly_A = mkA "天" ; -- status=guess
lin heaver_N = mkN "杠杆" ; -- open-multilingual-wordnet
lin heaves_N = mkN "马慢性肺气肿" ; -- open-multilingual-wordnet
lin heavily_Adv = adjAdv heavy_A ; -- derived
lin heaviside_PN = foreignPN "Heaviside" ; -- comment=src=eng status=guess
lin heavy_A = L.heavy_A | {-HSK-} mkA "重" ;
lin heavy_Adv = mkAdv "大量" | {-HSK-} mkAdv "重" ;
lin heavy_N = mkN "重" | {-HSK-} mkN "重物""件" ;
lin heavy_handed_A = mkA "笨手笨脚" ;
lin heavyweight_N = mkN "重量级人物" ;
lin hebden_royal_PN = foreignPN "Hebden royal" ; -- comment=src=eng status=guess
lin hebdomadal_A = mkA "一周" | mkA "一周一次" | mkA "每七天" | mkA "每周" ; -- open-multilingual-wordnet
lin hebephrenia_N = mkN "青春期痴呆者" ; -- open-multilingual-wordnet
lin hebephrenic_A = mkA "精神分裂症" ; -- open-multilingual-wordnet
lin heck_N = mkN "饲草架" ;
lin heckelphone_N = mkN "上低音双簧管" | mkN "黑克尔管" ; -- open-multilingual-wordnet
lin heckle_V2 = mkV2 "诘问" ;
lin hectare_N = {-mwn-} mkN "公顷" ; -- open-multilingual-wordnet
lin hectic_A = mkA "兴奋" ;
lin hectogram_N = mkN "百克" ; -- open-multilingual-wordnet
lin hectograph_N = mkN "胶版" | mkN "胶版誊写机" ; -- open-multilingual-wordnet
lin hectoliter_N = mkN "一百公升" | mkN "百升" ; -- open-multilingual-wordnet
lin hectometer_N = mkN "一百公尺" | mkN "百米" ; -- open-multilingual-wordnet
lin hedge_N = mkN "对冲" ;
lin hedge_V = mkV "对冲" ;
lin hedge_V2 = mkV2 "把+用树篱围起来" ;
lin hedge_end_PN = foreignPN "Hedge end" ; -- comment=src=eng status=guess
lin hedgehog_N = mkN "刺蝟" | mkN "刺猬" ; -- status=guess -- status=guess
lin hedgehop_V = mkV "低飞" | mkV "极低空飞行" | mkV "超低空飞行" ; -- open-multilingual-wordnet
lin hedgerow_N = mkN "树篱" | mkN "灌木树篱" | mkN "篱墙" | mkN "篱笆" ; -- open-multilingual-wordnet
lin hedonism_N = mkN "享樂主義" | mkN "享乐主义" ; -- status=guess -- status=guess
lin heed_N = mkN "留意" ;
lin heed_V2 = mkV2 "注意" | {-HSK-} mkV2 "理睬" ;
lin heel_N = mkN "脚跟" | {-HSK-} mkN "跟" ;
lin hefty_A = mkA "沉重" ;
lin hegemony_N = mkN "霸权" "" ;
lin heidelburg_PN = foreignPN "Heidelburg" ; -- comment=src=eng status=guess
lin heifer_N = mkN "小母牛" ; -- open-multilingual-wordnet
lin height_N = mkN "个子" | {-HSK-} mkN "高度" ;
lin heighten_V = mkV "增高" ;
lin heighten_V2 = mkV2 "提高" ;
lin heinous_A = mkA "可憎" ;
lin heir_N = mkN "继承者" ;
lin heirloom_N = mkN "传家宝" | mkN "祖传家产" | mkN "祖传遗物" ; -- open-multilingual-wordnet
lin helen_PN = foreignPN "Helen" ; -- comment=src=eng status=guess
lin helensburgh_PN = foreignPN "Helensburgh" ; -- comment=src=geonames status=guess
lin helicon_N = mkN "圈形大号" ; -- open-multilingual-wordnet
lin helicopter_N = mkN "直升机" "架" ;
lin heliotrope_N = mkN "鸡血石" ; -- open-multilingual-wordnet
lin heliport_N = mkN "直升飞机场" ; -- open-multilingual-wordnet
lin helium_N = mkN "氦" | mkN "Literary Chinese: 氦" ; -- status=guess -- status=guess
lin helix_N = mkN "螺旋" ; -- status=guess
lin hell_Interj = mkInterj "见鬼去吧" ;
lin hell_N = mkN "地狱" [] ;
lin hellfire_N = mkN "地獄之火" | mkN "地狱之火" ; -- status=guess -- status=guess
lin hellgrammiate_N = mkN "水虿" ; -- open-multilingual-wordnet
lin hello_Interj = mkInterj "你好" ;
lin helm_N = mkN "舵" ;
lin helmet_N = variants {} ;
lin helmeted_A = mkA "佩戴头盔" ;
lin helminthiasis_N = mkN "蠕虫病" ; -- open-multilingual-wordnet
lin helmsman_N = mkN "舵手" ; -- status=guess
lin help_N = mkN "帮助" ;
lin help_V = mkV "与" | mkV "帮助" | mkV "帮忙" | mkV "扶" ;
lin help_V2 = mkV2 "与" | mkV2 "帮助" | mkV2 "帮忙" | mkV2 "扶" ;
lin help_V2V = mkV2V "与" | mkV2V "帮助" | mkV2V "帮忙" | mkV2V "扶" ;
lin help_out_V2 = mkV2 "方便" ;
lin help_to_VV = variants {} ; -- guess-p-verb
lin helperFem_N = variants {} ; ---- sense to be split
lin helperMasc_N = variants {} ; ---- sense to be split
lin helpful_A = mkA "有帮助" ;
lin helping_N = mkN "一份食物" ; -- open-multilingual-wordnet
lin helpless_A = mkA "无助" ;
lin helsinki_PN = mkPN "赫尔辛基" ; -- comment=src=geonames status=guess
lin helston_PN = foreignPN "Helston" ; -- comment=src=geonames status=guess
lin helve_N = mkN "把手" | mkN "柄" ; -- open-multilingual-wordnet
lin helvella_N = mkN "弹性马鞍菌" | mkN "马鞍菌" ; -- open-multilingual-wordnet
lin hem_N = mkN "边缘" ;
lin hem_V = mkV "縫邊" | mkV "缝边" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin hem_V2 = mkV2 (mkV "縫邊") | mkV2 (mkV "缝边") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin hemagglutination_N = mkN "红血球凝聚" | mkN "血凝反应" ; -- open-multilingual-wordnet
lin hemal_A = mkA "血液" | mkA "血管" ; -- open-multilingual-wordnet
lin hemangioma_N = mkN "血管瘤" ; -- open-multilingual-wordnet
lin hematinic_N = mkN "补血药" ; -- open-multilingual-wordnet
lin hematocele_N = mkN "积血" ; -- open-multilingual-wordnet
lin hematochezia_N = mkN "便血" | mkN "圊血" | mkN "清血" | mkN "肠风便血" ; -- open-multilingual-wordnet
lin hematochrome_N = mkN "血色素" | mkN "赤血素" ; -- open-multilingual-wordnet
lin hematocytopenia_N = mkN "血质不良" ; -- open-multilingual-wordnet
lin hematocyturia_N = mkN "血细胞尿" ; -- open-multilingual-wordnet
lin hematologic_A = mkA "血液学" ; -- open-multilingual-wordnet
lin hematopoiesis_N = mkN "造血" | {-mwn-} mkN "生血作用" | mkN "血产生" | mkN "血液生成" | mkN "血生成" | mkN "造血作用" ; -- status=guess -- open-multilingual-wordnet
lin hematopoietic_A = mkA "生血" | mkA "造血" ; -- open-multilingual-wordnet
lin hematuria_N = mkN "血尿" | mkN "血尿症" ; -- open-multilingual-wordnet
lin heme_N = mkN "血红素" ; -- open-multilingual-wordnet
lin hemel_hempstead_PN = foreignPN "Hemel hempstead" ; -- comment=src=eng status=guess
lin hemeralopia_N = mkN "昼盲" ; -- open-multilingual-wordnet
lin hemianopia_N = mkN "一侧视力缺失" | mkN "偏侧盲" | mkN "偏盲" ; -- open-multilingual-wordnet
lin hemic_A = mkA "血" | mkA "血性" ; -- open-multilingual-wordnet
lin hemiepiphyte_N = mkN "半附生植物" ; -- open-multilingual-wordnet
lin hemimorphite_N = mkN "异极矿" ; -- open-multilingual-wordnet
lin hemin_N = mkN "氯高铁血红素" | mkN "红褐色氯化血红素" ; -- open-multilingual-wordnet
lin hemiparasite_N = mkN "半寄生植物" | mkN "半寄生物" ; -- open-multilingual-wordnet
lin hemiparasitic_A = mkA "半寄生植物" ; -- open-multilingual-wordnet
lin hemiplegia_N = mkN "偏瘫" | mkN "半身不遂" ; -- open-multilingual-wordnet
lin hemisphere_N = mkN "半球" ;
lin hemispheric_A = mkA "半球" | mkA "大脑半球" ; -- open-multilingual-wordnet
lin hemispherical_A = mkA "半球" | mkA "半球体" ; -- open-multilingual-wordnet
lin hemlock_N = mkN "鐵杉" | mkN "铁杉" | mkN "毒草名" ; -- status=guess -- status=guess -- status=guess
lin hemochromatosis_N = mkN "血色沉著病" | mkN "血色沉着病" | mkN "血色病" | mkN "青銅色糖尿病" | mkN "青铜色糖尿病" | {-mwn-} mkN "血色素沉着" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hemodynamics_N = mkN "血流動力學" ; -- status=guess
lin hemoglobin_N = mkN "血红蛋白" ;
lin hemoglobinemia_N = mkN "血红蛋白血" ; -- open-multilingual-wordnet
lin hemoglobinopathy_N = mkN "血红蛋白病" ; -- open-multilingual-wordnet
lin hemoglobinuria_N = mkN "血红蛋白尿" ; -- open-multilingual-wordnet
lin hemolysis_N = mkN "溶血" | mkN "血细胞溶解" ; -- open-multilingual-wordnet
lin hemolytic_A = mkA "溶血" ; -- open-multilingual-wordnet
lin hemophilia_N = mkN "血友病" ; -- open-multilingual-wordnet
lin hemoprotein_N = mkN "血红素蛋白" ; -- open-multilingual-wordnet
lin hemoptysis_N = mkN "咯血" | mkN "咳血" ; -- open-multilingual-wordnet
lin hemorrhage_V = mkV "大出血" ;
lin hemorrhage_V2 = mkV2 "出血" ;
lin hemorrhagic_A = mkA "出血" ; -- open-multilingual-wordnet
lin hemorrhoid_N = mkN "痔瘡" | mkN "痔疮" | mkN "痔" | {-mwn-} mkN "痔疾" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hemosiderin_N = mkN "含铁血黄素" | mkN "血铁黄素" | mkN "血铁黄蛋白" ; -- open-multilingual-wordnet
lin hemostat_N = mkN "止血钳" | mkN "止血钳子" ; -- open-multilingual-wordnet
lin hemothorax_N = mkN "血胸" ; -- open-multilingual-wordnet
lin hemp_N = mkN "大麻" | {-mwn-} mkN "绞索" ; -- status=guess -- open-multilingual-wordnet
lin hempen_A = mkA "纤维" | mkA "纤维性" | mkA "纤维构成" ; -- open-multilingual-wordnet
lin hemstitch_N = mkN "结穗花饰" ; -- open-multilingual-wordnet
lin hemsworth_PN = foreignPN "Hemsworth" ; -- comment=src=geonames status=guess
lin hen_N = mkN "母鸡""只" ;
lin hence_Adv = mkAdv "于是" | mkAdv "用" | {-HSK-} mkAdv "从今以后" ;
lin henceforth_Adv = mkAdv "从此" | {-HSK-} mkAdv "從此" | mkAdv "從此以後" | mkAdv "从此以后" | mkAdv "此後" | mkAdv "此后" | mkAdv "今後" | mkAdv "今后" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin hencoop_N = mkN "鸡舍" ; -- open-multilingual-wordnet
lin henhouse_N = mkN "雞舍" | mkN "鸡舍" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin henley_on_thames_PN = foreignPN "Henley-on-thames" ; -- comment=src=eng status=guess
lin henna_N = mkN "指甲花染料" | mkN "散沫花染剂" | mkN "红褐色染料" ; -- open-multilingual-wordnet
lin henpecked_A = mkA "怕老婆" | mkA "懼內" | mkA "惧内" ; -- status=guess -- status=guess -- status=guess
lin henroost_N = mkN "埘" | mkN "鸡窝" ; -- open-multilingual-wordnet
lin henry_PN = foreignPN "Henry" ; -- comment=src=geonames status=guess
lin hepatic_A = mkA "作用于肝" | mkA "保肝" | mkA "肝" | mkA "肝脏" ; -- open-multilingual-wordnet
lin hepatitis_N = mkN "肝炎" ;
lin hepatoma_N = mkN "肝细胞瘤" ; -- open-multilingual-wordnet
lin hepatomegaly_N = mkN "肝肿大" ; -- open-multilingual-wordnet
lin hepatotoxic_A = mkA "毒害肝细胞" | mkA "肝毒性" | mkA "肝毒素" ; -- open-multilingual-wordnet
lin hepatotoxin_N = mkN "肝毒素" ; -- open-multilingual-wordnet
lin heptagon_N = mkN "七边形" ; -- open-multilingual-wordnet
lin heptane_N = mkN "庚烷" ; -- status=guess
lin herald_V2 = mkV2 "通报" ;
lin heraldry_N = mkN "紋章學" | mkN "纹章学" | {-mwn-} mkN "纹章" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin herb_N = mkN "香草" "份" ; -- comment="药草" ;
lin herb_PN = foreignPN "Herb" ; -- comment=src=eng status=guess
lin herbaceous_A = mkA "草本" | mkA "非木质" ; -- open-multilingual-wordnet
lin herbal_A = mkA "草药" ;
lin herbalist_N = mkN "中醫師" | mkN "中医师" | mkN "草藥醫生" | mkN "草药医生" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin herbarium_N = mkN "蠟葉標本" | mkN "蜡叶标本" | mkN "植物標本" | mkN "植物标本" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin herbert_PN = foreignPN "Herbert" ; -- comment=src=eng status=guess
lin herbicide_N = mkN "除草劑" | mkN "除草剂" ; -- status=guess -- status=guess
lin herbivore_N = mkN "食草動物" | mkN "食草动物" ; -- status=guess -- status=guess
lin herd_N = mkN "兽群" ; -- comment="畜群" ;
lin herd_V = mkV "群" ;
lin herd_V2 = mkV2 "群" ;
lin herdsman_N = mkN "牧民" | mkN "牧人" ; -- status=guess -- status=guess
lin here7from_Adv = S.here7from_Adv ;
lin here7to_Adv = S.here7to_Adv ;
lin here_Adv = mkAdv "这儿" | {-HSK-} mkAdv "这里" ;
lin hereabouts_Adv = mkAdv "在附近一带" ;
lin hereafter_Adv = mkAdv "此后" ;
lin hereafter_N = mkN "今后" | mkN "以后" | mkN "将来" | mkN "未来" ; -- open-multilingual-wordnet
lin hereditament_N = mkN "不动产" | mkN "可继承的财产" ; -- open-multilingual-wordnet
lin hereditary_A = mkA "遗传" ;
lin heredity_N = mkN "遗传" ;
lin hereford_PN = mkPN "赫里福德" ; -- comment=src=geonames status=guess
lin hereinafter_Adv = mkAdv "在下文" | mkAdv "在下文中" ; -- open-multilingual-wordnet
lin hereinbefore_Adv = mkAdv "在上文中" ; -- open-multilingual-wordnet
lin hereness_N = mkN "在此" ; -- open-multilingual-wordnet
lin hereof_Adv = mkAdv "于此" | mkAdv "关于此点" ; -- open-multilingual-wordnet
lin heresy_N = mkN "異端" | mkN "异端" | mkN "邪說" | mkN "邪说" | mkN "異教" | mkN "异教" | mkN "邪教" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin heretic_N = mkN "異教徒" | mkN "异教徒" | mkN "異教者" | mkN "异教者" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin heretical_A = mkA "异教" ;
lin heretofore_Adv = mkAdv "直到此时" ;
lin heritable_A = mkA "可继承" ; -- open-multilingual-wordnet
lin heritage_N = mkN "遗产" "份" ;
lin herm_N = mkN "头像方碑" ; -- open-multilingual-wordnet
lin hermaphrodite_N = mkN "陰陽人" | mkN "阴阳人" | mkN "兩性人" | mkN "两性人" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin hermit_N = mkN "寄生蟹" ; -- status=guess
lin hermitage_N = mkN "隐居处" ; -- status=guess -- open-multilingual-wordnet
lin herne_PN = mkPN "黑尔讷" ; -- comment=src=geonames status=guess
lin herne_bay_PN = foreignPN "Herne bay" ; -- comment=src=eng status=guess
lin hernia_N = mkN "疝氣" | mkN "疝气" | mkN "小腸串氣" | mkN "小肠串气" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hero_N = mkN "英雄" | {-HSK-} mkN "英雄" "個" ;
lin heroic_A = mkA "英勇" ;
lin heroin_N = {-mwn-} mkN "二乙酰吗啡" | mkN "海洛因" ; -- open-multilingual-wordnet
lin heroine_N = mkN "女英雄" "位" ;
lin heroism_N = mkN "英雄主義" | mkN "英雄主义" | mkN "豪氣" | mkN "豪气" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin heron_N = mkN "鹭" "只" ;
lin herpes_N = mkN "皰疹" | mkN "疱疹" ; -- status=guess -- status=guess
lin herring_N = mkN "鲱鱼" ;
lin herringbone_N = mkN "人字呢" | mkN "海力蒙" ; -- open-multilingual-wordnet
lin herself_NP = mkNPword "她自己" ;
lin hertford_PN = foreignPN "Hertford" ; -- comment=src=geonames status=guess
lin hertfordshire_PN = foreignPN "Hertfordshire" ; -- comment=src=eng status=guess
lin hertz_N = mkN "赫" | mkN "赫兹" ; -- status=guess -- status=guess
lin hesitancy_N = mkN "不情愿" | mkN "犹豫" | mkN "踌躇" | mkN "迟疑" ; -- open-multilingual-wordnet
lin hesitant_A = mkA "迟疑" ;
lin hesitate_V = mkV "犹豫" | {-HSK-} mkV "迟疑" ;
lin hesitate_VV = mkVV "犹豫" ;
lin hesitation_N = mkN "犹豫" ;
lin heterocercal_A = mkA "不等鳍" | mkA "歪形尾" ; -- open-multilingual-wordnet
lin heterodyne_A = mkA "产生外差效果" | mkA "外差式" ; -- open-multilingual-wordnet
lin heterogeneous_A = mkA "多相" ;
lin heteroploidy_N = mkN "异倍体" ; -- open-multilingual-wordnet
lin heterosexual_A = mkA "異性戀" | mkA "异性恋" ; -- status=guess -- status=guess
lin heterosexual_N = mkN "異性戀者" | mkN "异性恋者" ; -- status=guess -- status=guess
lin heterosexuality_N = mkN "異性戀" | mkN "异性恋" ; -- status=guess -- status=guess
lin heterosporous_A = mkA "具异形孢子" ; -- open-multilingual-wordnet
lin heterospory_N = mkN "孢子异型" ; -- open-multilingual-wordnet
lin heterotroph_N = mkN "异养生物" ; -- open-multilingual-wordnet
lin heterotrophic_A = mkA "异养" ; -- open-multilingual-wordnet
lin heterozygosity_N = mkN "杂合性" ; -- open-multilingual-wordnet
lin hetton_PN = foreignPN "Hetton" ; -- comment=src=eng status=guess
lin heuristic_A = mkA "启发" ;
lin heuristic_N = mkN "启发" "個" | {-HSK-} mkN "啟發法" | mkN "启发法" ; -- status=guess -- status=guess
lin hew_V = mkV "砍掉" ;
lin hexachlorophene_N = mkN "六氯酚" ; -- open-multilingual-wordnet
lin hexadecimal_A = mkA "十六进制" | {-mwn-} mkA "十六进制" ; -- status=guess -- open-multilingual-wordnet
lin hexagonal_A = mkA "六方" | {-mwn-} mkA "六角" | mkA "六角形" | mkA "有六角" ; -- status=guess -- open-multilingual-wordnet
lin hexahedron_N = mkN "六面體" | mkN "六面体" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hexane_N = mkN "己烷" ; -- status=guess
lin hexangular_A = mkA "六角" | mkA "六角形" | mkA "有六角" ; -- open-multilingual-wordnet
lin hexestrol_N = mkN "己烷雌酚" ; -- open-multilingual-wordnet
lin hexham_PN = foreignPN "Hexham" ; -- comment=src=geonames status=guess
lin hexose_N = mkN "六碳糖" | mkN "己糖" ; -- open-multilingual-wordnet
lin hey_Interj = mkInterj "嗨" | {-HSK-} mkInterj "哟" | mkInterj "嘿" ;
lin heyday_N = mkN "全盛期" ;
lin heysham_PN = foreignPN "Heysham" ; -- comment=src=eng status=guess
lin heywood_PN = foreignPN "Heywood" ; -- comment=src=geonames status=guess
lin hi_Interj = mkInterj "你好" ;
lin hiatus_N = mkN "裂孔" ;
lin hibachi_N = mkN "日本式火钵" | mkN "火盆" ; -- open-multilingual-wordnet
lin hibernate_V = mkV "冬眠" ; -- status=guess, src=wikt
lin hibernation_N = mkN "冬眠" ; -- status=guess
lin hibiscus_N = mkN "木槿" ; -- status=guess
lin hiccough_N = mkN "呃逆" | mkN "打嗝" | mkN "打嗝儿" ; -- open-multilingual-wordnet
lin hiccough_V = mkV "打嗝" | mkV "打嗝儿" ; -- open-multilingual-wordnet
lin hiccup_N = mkN "打嗝" | mkN "呃逆" | {-mwn-} mkN "打嗝儿" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hiccup_V = mkV "打嗝" | mkV "呃逆" | {-mwn-} mkV "打嗝儿" ; -- status=guess, src=wikt -- status=guess, src=wikt -- open-multilingual-wordnet
lin hick_N = mkN "乡巴佬" ;
lin hickey_N = mkN "吻痕" | mkN "草莓" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hidden_A = {-HSK-} mkA "暗" | mkA "阴" ;
lin hiddenite_N = mkN "翠绿锂浑石" ; -- open-multilingual-wordnet
lin hide_N = mkN "隐藏" "" ;
lin hide_V = mkV "隐藏" ;
lin hide_V2 = mkV2 "隐藏" ;
lin hide_away_V = advV OP_hide_V OP_away_Adv ; -- guess-p-verb
lin hide_away_V2 = mkV2 (advV OP_hide_V OP_away_Adv ) ; -- guess-p-verb
lin hide_out_V = advV OP_hide_V OP_out_Adv ; -- guess-p-verb
lin hideaway_N = mkN "隐匿处" ;
lin hidebound_A = mkA "死板" ;
lin hideous_A = mkA "可怕" ;
lin hide_out_N = mkN "隱匿處" | mkN "隐匿处" | mkN "巢穴" ; -- status=guess -- status=guess -- status=guess
lin hiding_N = mkN "藏" ;
lin hidrotic_A = mkA "出汗" | mkA "汗" ; -- open-multilingual-wordnet
lin hierarch_N = mkN "主牧师" | mkN "大主教" | mkN "教主" | mkN "高僧" | mkN "高级教士" ; -- open-multilingual-wordnet
lin hierarchical_A = mkA "分等级" ;
lin hierarchy_N = mkN "层级" ;
lin hieroglyph_N = mkN "象形文字" | mkN "圖畫文字" | mkN "图画文字" ; -- status=guess -- status=guess -- status=guess
lin hieroglyphic_A = mkA "象形文字" ; -- open-multilingual-wordnet
lin hift_V = mkV "转移" ;
lin high_A = mkA "高" ;
lin high_Adv = mkAdv "高" ;
lin high_N = mkN "高" ;
lin high_grade_A = mkA "优质" | {-HSK-} mkA "高档" | mkA "高级" ;
lin high_handed_A = mkA "专横" ;
lin high_level_A = mkA "高级" ;
lin high_minded_A = mkA "大度" ;
lin high_octane_A = mkA "高度" ;
lin high_powered_A = mkA "高度" ;
lin high_priced_A = mkA "高价位" ;
lin high_ranking_A = mkA "高级" ;
lin high_rise_A = mkA "高度" ;
lin high_speed_A = mkA "高速" ;
lin high_spen_PN = foreignPN "High spen" ; -- comment=src=eng status=guess
lin high_toned_A = mkA "年久变色" ;
lin high_wycombe_PN = foreignPN "High wycombe" ; -- comment=src=eng status=guess
lin highboard_N = mkN "高台跳水板" ; -- open-multilingual-wordnet
lin highboy_N = mkN "高脚五斗橱" | mkN "高脚柜" ; -- open-multilingual-wordnet
lin highchair_N = mkN "高腳椅" | mkN "高脚椅" | mkN "高椅" | mkN "高椅" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin highflying_A = mkA "抱负高" | mkA "有极大抱负" | mkA "野心勃勃" ; -- open-multilingual-wordnet
lin highjacking_N = mkN "劫机" ; -- open-multilingual-wordnet
lin highland_N = mkN "高地" ; -- status=guess
lin highland_PN = foreignPN "Highland" ; -- comment=src=geonames status=guess
lin highlight_N = mkN "重头戏" ;
lin highlight_V2 = mkV2 "突出" ;
lin highlighter_N = mkN "熒光筆" | mkN "荧光笔" | {-mwn-} mkN "彩色标记笔" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin highly_Adv = adjAdv high_A ; -- derived
lin highroad_N = mkN "干道" | mkN "高速公路" ; -- open-multilingual-wordnet
lin highway_N = mkN "公路" | {-HSK-} mkN "高速公路" ;
lin hijab_N = mkN "頭巾" | mkN "头巾" ; -- status=guess -- status=guess
lin hijack_N = mkN "劫持" | mkN "劫機" | mkN "劫机" ; -- status=guess -- status=guess -- status=guess
lin hijack_V2 = mkV2 (mkV "劫持") | mkV2 (mkV "攔路搶劫") | mkV2 (mkV "拦路抢劫") | mkV2 (mkV "劫機") | mkV2 (mkV "劫机") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin hike_N = mkN "远足" ;
lin hike_V = mkV "远足" ;
lin hiker_N = mkN "徒步旅行者" ;
lin hilarious_A = mkA "欢闹" ;
lin hilary_PN = foreignPN "Hilary" ; -- comment=src=eng status=guess
lin hilda_PN = foreignPN "Hilda" ; -- comment=src=eng status=guess
lin hill_N = L.hill_N ;
lin hillingdon_PN = foreignPN "Hillingdon" ; -- comment=src=eng status=guess
lin hillside_N = mkN "山坡" ;
lin hilly_A = mkA "丘陵" ;
lin hilt_N = mkN "柄" | mkN "刀柄" | {-mwn-} mkN "刀把" | mkN "剑柄" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin himself_NP = mkNPword "他自己" ;
lin hinckley_PN = foreignPN "Hinckley" ; -- comment=src=geonames status=guess
lin hind_N = mkN "後肢" | mkN "后肢" ; -- status=guess -- status=guess
lin hinder_V2 = mkV2 "妨碍" | mkV2 "挡" | {-HSK-} mkV2 "阻碍" ;
lin hindfoot_N = mkN "后足" ; -- open-multilingual-wordnet
lin hindrance_N = mkN "障礙" | mkN "障碍" | mkN "阻力" | mkN "阻礙" | mkN "阻碍" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin hindsight_N = mkN "事后诸葛亮" ; -- status=guess
lin hinge_N = mkN "鉸鏈" | mkN "铰链" ; -- status=guess -- status=guess
lin hinge_V = mkV "依*转移" ;
lin hint_N = mkN "暗示" ;
lin hint_V = mkV "暗示" ;
lin hint_V2 = variants {} ; -- comment=mkV "暗示" ;
lin hint_VS = mkVS "暗示" ;
lin hinterland_N = mkN "腹地" ;
lin hip_N = mkN "臀部" ;
lin hip_flask_N = mkN "小酒瓶" ; -- open-multilingual-wordnet
lin hiplength_A = mkA "长至臀部" ; -- open-multilingual-wordnet
lin hippie_N = mkN "嬉皮士" ;
lin hippodrome_N = mkN "賽馬場" | mkN "赛马场" | mkN "競技場" | mkN "竞技场" | {-mwn-} mkN "跑马场" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hippopotamus_N = mkN "河馬" | mkN "河马" ; -- status=guess -- status=guess
lin hircine_A = mkA "山羊般气味" | mkA "羊膻味" ; -- open-multilingual-wordnet
lin hire_N = mkN "租金" [] ;
lin hire_V2 = mkV2 "租" | mkV2 "雇佣" | {-HSK-} mkV2 "聘请" ;
lin hire_V2V = mkV2V "租" | mkV2V "雇佣" ;
lin hiroshima_PN = foreignPN "Hiroshima" ; -- comment=src=eng status=guess
lin hiss_V = mkV "嘶" | mkV "嘯" | mkV "啸" | mkV "噝" | mkV "噝" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin hiss_V2 = mkV2 (mkV "嘶") | mkV2 (mkV "嘯") | mkV2 (mkV "啸") | mkV2 (mkV "噝") | mkV2 (mkV "噝") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin hiss_VQ = mkVQ (mkV "嘘声") ;
lin histamine_N = mkN "組胺" | mkN "组胺" ; -- status=guess -- status=guess -- status=guess
lin histidine_N = mkN "组氨酸" ; -- status=guess
lin histoincompatibility_N = mkN "组织不相容性" | mkN "组织排斥性" ; -- open-multilingual-wordnet
lin histological_A = mkA "组织学" ; -- open-multilingual-wordnet
lin histone_N = mkN "组织蛋白" ; -- open-multilingual-wordnet
lin historian_N = mkN "历史学家" ;
lin historic_A = mkA "历史性" ;
lin historical_A = mkA "历史" ;
lin historicize_V2 = mkV2 "使+历史化" ;
lin history_N = mkN "历史" | {-HSK-} mkN "历史" "門" ;
lin hit_N = mkN "击中" ;
lin hit_V = mkV "撞" | mkV "敲" | {-HSK-} mkV "撞击" ;
lin hit_V2 = L.hit_V2 | {-HSK-} mkV2 "撞" | mkV2 "敲" ;
lin hit_back_V2 = mkV2 (advV OP_hit_V OP_back_Adv ) ; -- guess-p-verb
lin hit_for_V3 = variants {} ; -- guess-p-verb
lin hit_it_off_V = variants {} ; -- guess-p-verb
lin hit_it_off_with_V2 = variants {} ; -- guess-p-verb
lin hit_on_V2 = prepV2 OP_hit_V OP_on_Prep ; -- guess-p-verb
lin hit_out_at_V2 = prepV2 (advV OP_hit_V OP_out_Adv ) OP_at_Prep ; -- guess-p-verb
lin hit_up_V = advV OP_hit_V OP_up_Adv ; -- guess-p-verb
lin hit_up_V2 = prepV2 OP_hit_V OP_up_Prep ; -- guess-p-verb
lin hit_up_on_V2 = prepV2 (advV OP_hit_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin hit_upon_V2 = prepV2 OP_hit_V OP_upon_Prep ; -- guess-p-verb
lin hit_with_V3 = variants {} ; -- guess-p-verb
lin hitch_N = mkN "拴住" "" | mkN "故障" ;
lin hitch_V = mkV "挂" ;
lin hitch_V2 = mkV2 "拴住" | {-HSK-} mkV2 "挂" ;
lin hitchhike_V = mkV "搭便車" | mkV "搭便车" | mkV "順風車" | mkV "顺风车" | mkV "搭車" | mkV "搭车" ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin hitchhiker_N = mkN "搭車者" | mkN "搭车者" | mkN "搭車人" | mkN "搭车人" | mkN "搭車的" | mkN "搭车的" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin hitchin_PN = foreignPN "Hitchin" ; -- comment=src=geonames status=guess
lin hitchrack_N = mkN "拴马杆" ; -- open-multilingual-wordnet
lin hither_Adv = mkAdv "到这里" ;
lin hitherto_Adv = mkAdv "迄今" ;
lin hitless_A = mkA "无命中" ; -- open-multilingual-wordnet
lin hm_PN = foreignPN "Hm" ; -- comment=src=eng status=guess
lin hmso_PN = foreignPN "Hmso" ; -- comment=src=eng status=guess
lin hoard_N = mkN "囤积" ;
lin hoard_V2 = mkV2 "贮藏" ;
lin hoarder_N = mkN "囤积者" ;
lin hoarding_N = mkN "囤积" ;
lin hoarfrost_N = mkN "霜" ; -- status=guess
lin hoarse_A = mkA "嗄" ; -- status=guess
lin hoax_N = mkN "騙局" | mkN "骗局" | mkN "惡作劇" | mkN "恶作剧" | {-mwn-} mkN "欺诈" | mkN "欺骗" | mkN "瞒骗" ; -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hoax_V2 = mkV2 (mkV "欺騙") | mkV2 (mkV "欺骗") | mkV2 (mkV "作弄") | mkV2 (mkV "戲弄") | mkV2 (mkV "戏弄") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin hob_N = mkN "铁架" ; -- open-multilingual-wordnet
lin hobbit_N = mkN "霍比特人" | mkN "哈比人" ; -- status=guess -- status=guess
lin hobble_V2 = mkV2 "蹒" ;
lin hobby_N = mkN "嗜好" "个" | {-HSK-} mkN "娱乐" | mkN "爱好" "個" ;
lin hobbyhorse_N = mkN "木马" ; -- open-multilingual-wordnet
lin hobnail_N = mkN "平头钉" | mkN "鞋钉" ; -- open-multilingual-wordnet
lin hobnob_V = mkV "亲切交往" | mkV "亲近" | mkV "过从甚密" ; -- open-multilingual-wordnet
lin hobo_N = mkN "流浪汉" ;
lin hobson_PN = foreignPN "Hobson" ; -- comment=src=eng status=guess
lin hock_N = mkN "踝关节" ;
lin hockey_N = mkN "曲棍球" | mkN "冰球" ; -- status=guess -- status=guess
lin hockley_PN = foreignPN "Hockley" ; -- comment=src=geonames status=guess
lin hod_N = mkN "灰浆桶" | mkN "灰砂斗" | mkN "砖斗" | mkN "砖泥斗" | mkN "轻便无盖挂斗" ; -- open-multilingual-wordnet
lin hoddesdon_PN = foreignPN "Hoddesdon" ; -- comment=src=geonames status=guess
lin hodgepodge_N = mkN "大杂烩" ;
lin hodoscope_N = mkN "描迹仪" ; -- open-multilingual-wordnet
lin hoe_N = mkN "鋤" | mkN "锄" | {-mwn-} mkN "锄头" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hoe_V2 = mkV2 "锄头" ;
lin hofei_PN = foreignPN "Hofei" ; -- comment=src=eng status=guess
lin hog_N = mkN "猪" "口" | {-HSK-} mkN "豕" ;
lin hog_V2 = mkV2 "使+拱起" ;
lin hogan_N = mkN "泥盖木屋" ; -- open-multilingual-wordnet
lin hogmanay_PN = foreignPN "Hogmanay" ; -- comment=src=eng status=guess
lin hogshead_N = mkN "大桶" ; -- status=guess
lin hoist_V2 = mkV2 "使+升起" | {-HSK-} mkV2 "升" ;
lin hold_N = mkN "持有" ;
lin hold_V = mkV "举办" | mkV "保持" | mkV "做" | mkV "包" | mkV "把" | mkV "把握" | mkV "抱" | mkV "拿" ;
lin hold_V2 = L.hold_V2 | {-HSK-} mkV2 "举办" | mkV2 "保持" | mkV2 "做" | mkV2 "包" | mkV2 "把" | mkV2 "把握" | mkV2 "抱" | mkV2 "拿" | {-HSK-} mkV2 "叼" ;
lin hold_VS = mkVS "举办" | mkVS "保持" | mkVS "做" | mkVS "包" | mkVS "把" | mkVS "把握" | mkVS "抱" | mkVS "拿" | {-HSK-} mkVS "持有" ;
lin hold_against_V3 = variants {} ; -- guess-p-verb
lin hold_back_V = advV OP_hold_V OP_back_Adv ; -- guess-p-verb
lin hold_back_V2 = mkV2 (advV OP_hold_V OP_back_Adv ) ; -- guess-p-verb
lin hold_back_from_V2 = prepV2 (advV OP_hold_V OP_back_Adv ) OP_from_Prep ; -- guess-p-verb
lin hold_down_V2 = prepV2 OP_hold_V OP_down_Prep ; -- guess-p-verb
lin hold_forth_V = advV OP_hold_V OP_forth_Adv ; -- guess-p-verb
lin hold_off_V = advV OP_hold_V OP_off_Adv ; -- guess-p-verb
lin hold_off_V2 = prepV2 OP_hold_V OP_off_Prep ; -- guess-p-verb
lin hold_off_on_V2 = prepV2 (advV OP_hold_V OP_off_Adv ) OP_on_Prep ; -- guess-p-verb
lin hold_on_V = mkV "不屈不挠" | mkV "坚持" | mkV "坚持不懈" | mkV "孜孜不倦" ; -- open-multilingual-wordnet
lin hold_on_to_V2 = prepV2 (advV OP_hold_V OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin hold_onto_V = variants {} ; -- guess-p-verb
lin hold_onto_V2 = prepV2 OP_hold_V OP_onto_Prep ; -- guess-p-verb
lin hold_out_V = advV OP_hold_V OP_out_Adv ; -- guess-p-verb
lin hold_out_V2 = prepV2 OP_hold_V OP_out_Prep ; -- guess-p-verb
lin hold_out_against_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_against_Prep ; -- guess-p-verb
lin hold_out_for_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin hold_out_on_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin hold_over_V2 = prepV2 OP_hold_V OP_over_Prep ; -- guess-p-verb
lin hold_together_V = advV OP_hold_V OP_together_Adv ; -- guess-p-verb
lin hold_up_V2 = mkV2 "举" ;
lin hold_with_V2 = prepV2 OP_hold_V OP_with_Prep ; -- guess-p-verb
lin holdall_N = mkN "大手提包" ; -- open-multilingual-wordnet
lin holder_N = mkN "持有人" ;
lin holding_N = mkN "保持" ;
lin hold_up_N = mkN "持枪抢劫" "次" ;
lin hole_N = mkN "孔" | {-HSK-} mkN "洞" "個" ;
lin hole_V = mkV "打洞" ;
lin holiday_N = mkN "节" | mkN "节日" "個" | {-HSK-} mkN "节日" ;
lin holiday_V = mkV "度假" ;
lin holistic_A = mkA "全方位" | mkA "全盤" | mkA "全盘" | mkA "全面" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin holland_PN = foreignPN "Holland" ; -- comment=src=geonames status=guess
lin holler_V = mkV "发牢骚" ;
lin hollow_A = mkA "空洞" ;
lin hollow_N = mkN "窪地" | mkN "洼地" ; -- status=guess -- status=guess
lin hollowware_N = mkN "凹形器皿" | mkN "盘子" | mkN "碟子" ; -- open-multilingual-wordnet
lin holly_N = mkN "冬青" "个" ;
lin hollyhock_N = mkN "蜀葵" ; -- status=guess
lin hollywood_PN = mkPN "好莱坞" ;
lin holmfirth_PN = foreignPN "Holmfirth" ; -- comment=src=geonames status=guess
lin holmium_N = mkN "鈥" | mkN "钬" ; -- status=guess -- status=guess
lin holocaust_N = mkN "燔祭" ; -- status=guess
lin hologram_N = mkN "全息图" ; -- open-multilingual-wordnet
lin holograph_N = mkN "全息图" ; -- open-multilingual-wordnet
lin holography_N = mkN "全息攝影" | mkN "全息摄影" ; -- status=guess -- status=guess
lin holometabola_N = mkN "全变态类" | mkN "完全变态类" ; -- open-multilingual-wordnet
lin holonymy_N = mkN "整体部分关系" ; -- open-multilingual-wordnet
lin holster_N = mkN "皮套" | mkN "皮囊" ; -- status=guess -- status=guess
lin holy_A = mkA "神圣" ;
lin holy_N = mkN "宗教戰爭" | mkN "宗教战争" | mkN "聖戰" | mkN "圣战" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin holyhead_PN = foreignPN "Holyhead" ; -- comment=src=geonames status=guess
lin homage_N = mkN "敬意" [] ;
lin home_A = mkA "国内" | {-HSK-} mkA "家" ;
lin home_Adv = mkAdv "家" ;
lin home_N = mkN "家" ;
lin homecoming_N = mkN "归国" ;
lin homeland_N = mkN "家园" | {-HSK-} mkN "祖国" ;
lin homeless_A = mkA "无家可归" ;
lin homelessness_N = mkN "無家可歸" | mkN "无家可归" | mkN "露宿街頭" | mkN "露宿街头" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin homeopathic_A = mkA "同种疗法" | mkA "顺势疗法" ; -- open-multilingual-wordnet
lin homeopathy_N = mkN "順勢療法" | mkN "顺势疗法" ; -- status=guess -- status=guess
lin homeostasis_N = mkN "体内平衡" | {-mwn-} mkN "自我平衡" ; -- status=guess -- open-multilingual-wordnet
lin homeostatic_A = mkA "原状稳定" | mkA "自我平衡" ; -- open-multilingual-wordnet
lin homeowner_N = mkN "屋主" ; -- status=guess
lin homer_V = mkV "本垒打" ;
lin homesick_A = mkA "思鄉" | mkA "思乡" | mkA "想家" | mkA "鄉愁" | mkA "乡愁" | mkA "懷鄉" | mkA "怀乡" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin homesickness_N = mkN "思鄉" | mkN "思乡" | mkN "想家" | mkN "鄉愁" | mkN "乡愁" | mkN "懷鄉" | mkN "怀乡" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin homespun_N = mkN "土布" ; -- open-multilingual-wordnet
lin homestead_N = mkN "家宅" ; -- open-multilingual-wordnet
lin homestretch_N = mkN "最后直线赛程" | mkN "终点直道" ; -- open-multilingual-wordnet
lin hometown_N = mkN "家乡" | mkN "故鄉" | mkN "故乡" | {-HSK-} mkN "家乡" "個" ; -- status=guess -- status=guess -- status=guess
lin homeward_Adv = mkAdv "回家" ; -- status=guess
lin homework_N = mkN "作业" "個" | {-HSK-} mkN "家庭作业" ;
lin homicide_N = mkN "杀人犯" "名" ;
lin hominid_N = mkN "人科的动物" | mkN "类人动物" ; -- open-multilingual-wordnet
lin hominoid_N = mkN "人科之动物" ; -- open-multilingual-wordnet
lin homo_N = mkN "人" | mkN "人类" ; -- open-multilingual-wordnet
lin homo_sapiens_N = mkN "人类" "" ;
lin homocercal_A = mkA "正型" ; -- open-multilingual-wordnet
lin homogeneous_A = mkA "同質" | mkA "同质" | {-HSK-} mkA "均匀" ; -- status=guess -- status=guess
lin homogenize_V2 = mkV2 (mkV "均質") | mkV2 (mkV "均质") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin homograph_N = mkN "同音異義詞" | mkN "同音异义词" | mkN "同音詞" | mkN "同音词" | mkN "多音字" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin homoiothermic_A = mkA "恒温" | mkA "温血" ; -- open-multilingual-wordnet
lin homology_N = mkN "同调" | mkN "同调群" ; -- status=guess -- status=guess
lin homophobia_N = mkN "同性戀恐懼症" | mkN "同性恋恐惧症" ; -- status=guess -- status=guess
lin homophone_N = mkN "同音詞" | mkN "同音词" | mkN "同音字" ; -- status=guess -- status=guess -- status=guess
lin homophonous_A = mkA "发音相同" | mkA "同音" | mkA "同音异义" ; -- open-multilingual-wordnet
lin homosexual_A = mkA "同性恋" ;
lin homosexual_N = mkN "同性恋" ;
lin homosexuality_N = mkN "同性戀" | mkN "同性恋" ; -- status=guess -- status=guess
lin homosporous_A = mkA "具同形孢子" ; -- open-multilingual-wordnet
lin homospory_N = mkN "具同形孢子" | mkN "孢子同型" ; -- open-multilingual-wordnet
lin homozygosity_N = mkN "纯合性" ; -- open-multilingual-wordnet
lin homozygote_N = mkN "純合子" | mkN "纯合子" ; -- status=guess -- status=guess
lin hon_PN = foreignPN "Hon" ; -- comment=src=eng status=guess
lin honduran_A = mkA "洪都拉斯" ;
lin honduran_N = mkN "洪都拉斯" ;
lin honduras_PN = mkPN "洪都拉斯" ; -- comment=src=geonames status=guess
lin hone_N = mkN "磨刀石" ; -- status=guess
lin hone_V2 = mkV2 "用磨刀石磨" ;
lin honest_A = mkA "方" | mkA "老实" | mkA "诚实" | mkA "诚恳" ;
lin honesty_N = mkN "诚实" ;
lin honey_A = mkA "蜜黄色" ; -- open-multilingual-wordnet
lin honey_N = mkN "亲爱" ;
lin honeybee_N = mkN "蜜蜂" "隻" ;
lin honeycomb_N = mkN "蜂窩" | mkN "蜂窝" | mkN "蜂巢" ; -- status=guess -- status=guess -- status=guess
lin honeydew_N = mkN "白蘭瓜" | mkN "蘭州蜜瓜" | mkN "华莱士" | mkN "蜜瓜" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin honeylike_A = mkA "甜如蜜" ; -- open-multilingual-wordnet
lin honeymoon_N = mkN "蜜月" ;
lin honeymoon_V = mkV "度蜜月" | mkV "新婚旅行" ; -- open-multilingual-wordnet
lin hong_kong_PN = mkPN "香港" ;
lin honiton_PN = foreignPN "Honiton" ; -- comment=src=geonames status=guess
lin honk_N = mkN "嘟嘟響" | mkN "嘟嘟响" | mkN "嘟嘟聲" | mkN "嘟嘟声" | mkN "嘟" | mkN "嘟嘟" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin honk_V = mkV "嘟嘟響" | mkV "嘟嘟响" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin honkytonk_N = mkN "低级夜总会" | mkN "低级舞厅" ; -- open-multilingual-wordnet
lin honor_N = mkN "荣誉" ;
lin honor_V2 = mkV2 "荣誉" ;
lin honorable_A = mkA "诚实" ;
lin honorarium_N = mkN "酬金" ;
lin honorary_A = mkA "名誉" ;
lin honorific_A = mkA "尊敬" | mkA "给予荣誉" | mkA "表示尊敬" | mkA "表示敬意" ; -- open-multilingual-wordnet
lin honorific_N = mkN "敬語" | mkN "敬语" ; -- status=guess -- status=guess
lin honour_N = mkN "荣誉" ;
lin honour_V2 = mkV2 "荣誉" ;
lin honourable_A = {-mwn-} mkA "值得尊敬" | mkA "值得称颂" | mkA "光荣" | mkA "可敬" | mkA "荣耀" ; -- open-multilingual-wordnet
lin hoo_PN = foreignPN "Hoo" ; -- comment=src=geonames status=guess
lin hood_N = mkN "头巾" ;
lin hoodlum_N = mkN "阿飛" | mkN "阿飞" | mkN "流氓" | mkN "歹徒" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin hoodoo_N = mkN "不祥之物" ; -- open-multilingual-wordnet
lin hoodwink_V2 = mkV2 "欺骗" | {-HSK-} mkV2 "骗" ;
lin hoof_N = mkN "蹄" | mkN "蹢" ; -- status=guess -- status=guess
lin hooflike_A = mkA "似蹄" ; -- open-multilingual-wordnet
lin hook_N = mkN "挂钩" ;
lin hook_V = mkV "钩住" ;
lin hook_V2 = mkV2 "钩住" ;
lin hookah_N = mkN "水煙" | mkN "水烟" | mkN "水煙筒" | mkN "水烟筒" | mkN "水煙袋" | mkN "水烟袋" | {-mwn-} mkN "一种水烟袋" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hooklike_A = mkA "似钩" ; -- open-multilingual-wordnet
lin hook_up_N = mkN "装配" ; -- open-multilingual-wordnet
lin hooligan_N = mkN "流氓" | mkN "歹徒" | mkN "阿飛" | mkN "阿飞" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin hooliganism_N = mkN "流氓行为" ;
lin hoop_N = mkN "箍" | mkN "圈" | {-mwn-} mkN "球篮" | mkN "篮子" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hoop_la_N = mkN "投环套物游戏" ;
lin hoopskirt_N = mkN "圈环裙" | mkN "有裙撑的裙子" ; -- open-multilingual-wordnet
lin hoosegow_N = mkN "班房" | mkN "监牢" | mkN "监狱拘留所" ; -- open-multilingual-wordnet
lin hooter_N = mkN "猫头鹰" | mkN "鸮" ; -- open-multilingual-wordnet
lin hop_N = mkN "跳跃" ;
lin hop_V = mkV "跳" ;
lin hope_N = mkN "希望" ;
lin hope_PN = mkPN "霍普" ; -- comment=src=geonames status=guess
lin hope_V = mkV "希望" ;
lin hope_VS = L.hope_VS ;
lin hope_VV = mkVV "希望" ;
lin hopeful_A = mkA "乐观" | {-HSK-} mkA "怀抱希望" ;
lin hopeless_A = mkA "绝望" ;
lin hopelessness_N = mkN "絕望" | mkN "绝望" ; -- status=guess -- status=guess
lin hopsacking_N = mkN "席纹呢" | mkN "方平织物" ; -- open-multilingual-wordnet
lin hopscotch_N = mkN "跳房子" | mkN "跳格子" ; -- status=guess -- status=guess
lin hopscotch_V = mkV "跳房子" ;
lin horace_PN = foreignPN "Horace" ; -- comment=src=geonames status=guess
lin horary_A = mkA "以钟点计算" | mkA "指示钟点" | mkA "表示时间" ; -- open-multilingual-wordnet
lin horde_N = mkN "部落" ;
lin horizon_N = mkN "地平线" [] ;
lin horizontal_A = mkA "横" | {-HSK-} mkA "水平" ;
lin horizontal_N = mkN "横" | mkN "水平" | {-HSK-} mkN "水平线""" ;
lin horley_PN = foreignPN "Horley" ; -- comment=src=geonames status=guess
lin hormonal_A = mkA "荷尔蒙" ; -- open-multilingual-wordnet
lin hormone_N = mkN "激素" ;
lin horn_N = L.horn_N | {-HSK-} mkN "角" "個" ;
lin hornblende_N = mkN "角闪石" ; -- open-multilingual-wordnet
lin hornet_N = mkN "大黃蜂" | mkN "大黄蜂" | {-mwn-} mkN "胡蜂" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hornfels_N = mkN "角页岩" ; -- open-multilingual-wordnet
lin horniness_N = mkN "急切" | mkN "性冲动" | mkN "热切" ; -- open-multilingual-wordnet
lin hornless_A = mkA "无角" ; -- open-multilingual-wordnet
lin hornsea_PN = foreignPN "Hornsea" ; -- comment=src=geonames status=guess
lin horny_A = mkA "角質" | mkA "角质" ; -- status=guess -- status=guess
lin horoscope_N = mkN "星象" ;
lin horrible_A = mkA "可怕" ;
lin horrific_A = mkA "可怕" ;
lin horror_N = mkN "惊骇" ;
lin hors_de_combat_A = mkA "丧失战斗力" ;
lin horse_N = L.horse_N | {-HSK-} mkN "马" ;
lin horse_around_V = mkV "无所事事" | mkV "瞎弄" | mkV "胡闹" | mkV "闹哄" | mkV "鬼混" ; -- open-multilingual-wordnet
lin horseback_Adv = mkAdv "馬上" | mkAdv "马上" | {-mwn-} mkAdv "在马背上" | mkAdv "马背" | mkAdv "骑在马上" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin horseback_N = mkN "馬背" | mkN "马背" ; -- status=guess -- status=guess
lin horsebox_N = mkN "运马拖车" ; -- open-multilingual-wordnet
lin horsecar_N = mkN "轨道马车" ; -- open-multilingual-wordnet
lin horsecloth_N = mkN "马衣" ; -- open-multilingual-wordnet
lin horsefly_N = mkN "虻" | {-mwn-} mkN "马蝇" ; -- status=guess -- open-multilingual-wordnet
lin horsehair_N = mkN "馬毛" | mkN "马毛" | {-mwn-} mkN "马毛织物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin horsehide_N = mkN "马革" ; -- open-multilingual-wordnet
lin horseleech_N = mkN "马蝗" ; -- open-multilingual-wordnet
lin horseman_N = mkN "騎手" | mkN "骑手" ; -- status=guess -- status=guess
lin horsemeat_N = mkN "馬肉" | mkN "马肉" ; -- status=guess -- status=guess
lin horsepower_N = mkN "马力" ;
lin horseradish_N = mkN "辣根" ; -- status=guess
lin horseshoe_N = mkN "馬掌" | mkN "马掌" | mkN "馬蹄鐵" | mkN "马蹄铁" | mkN "馬蹄" | mkN "马蹄" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin horsetail_N = mkN "木贼属植物" ; -- open-multilingual-wordnet
lin horsewhip_N = mkN "马鞭" ; -- open-multilingual-wordnet
lin horsham_PN = foreignPN "Horsham" ; -- comment=src=geonames status=guess
lin horsley_PN = foreignPN "Horsley" ; -- comment=src=geonames status=guess
lin horticultural_A = mkA "园艺" ;
lin horticulture_N = mkN "园艺" ;
lin horticulturist_N = mkN "园艺家" ;
lin horwich_PN = foreignPN "Horwich" ; -- comment=src=geonames status=guess
lin hosanna_N = mkN "和撒那" ;
lin hose_N = mkN "软管" "条" ;
lin hose_V2 = mkV2 "软管" ;
lin hosepipe_N = mkN "软管" ; -- open-multilingual-wordnet
lin hosp_PN = foreignPN "Hosp" ; -- comment=src=eng status=guess
lin hospice_N = mkN "奧斯皮斯" | mkN "奥斯皮斯" ; -- status=guess -- status=guess
lin hospitable_A = mkA "热情友好" ;
lin hospital_N = mkN "医院" "所" ;
lin hospitality_N = mkN "亲切" | {-HSK-} mkN "好客" [] ;
lin hospitalization_N = mkN "住院治疗" ;
lin hospitalize_V2 = mkV2 "就医" ;
lin host_N = mkN "主人" "個" | {-HSK-} mkN "主持人" ;
lin host_V2 = mkV2 "做东" ;
lin hostage_N = mkN "人质" | mkN "抵押品" ;
lin hostel_N = mkN "宿舍" "間" | {-HSK-} mkN "旅社""间" ;
lin hostelry_N = mkN "宿舍" | mkN "招待所" | mkN "旅店" | mkN "旅社" | mkN "旅舍" ; -- open-multilingual-wordnet
lin hostess_N = mkN "女主人" ; -- status=guess
lin hostile_A = mkA "敌意" ;
lin hostile_N = mkN "敌人" ; -- status=guess -- status=guess
lin hostility_N = mkN "敌意" ;
lin hot_A = L.hot_A | {-HSK-} mkA "烫" | mkA "热" | mkA "辣" ;
lin hot_V = mkV "变热" ;
lin hot_V2 = mkV2 "使+增加" ;
lin hot_tempered_A = mkA "急性子" ;
lin hotbed_N = mkN "温床" ; -- open-multilingual-wordnet
lin hotdog_N = mkN "一种香肠" | mkN "法兰克福香肠" | mkN "维也纳香肠" ; -- open-multilingual-wordnet
lin hotel_N = mkN "旅馆" ;
lin hotelier_N = mkN "旅馆老板" "位" ;
lin hothouse_N = mkN "温室" ; -- open-multilingual-wordnet
lin hotplate_N = mkN "电烤盘" ; -- open-multilingual-wordnet
lin houghton_PN = foreignPN "Houghton" ; -- comment=src=geonames status=guess
lin hound_N = mkN "獵犬" | mkN "猎犬" | {-mwn-} mkN "猎狗" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hound_V2 = mkV2 "追猎" ;
lin hounslow_PN = foreignPN "Hounslow" ; -- comment=src=geonames status=guess
lin hour_N = mkN "小时" | {-HSK-} mkN "小时" "個" ;
lin hourglass_N = mkN "沙漏" | mkN "沙鐘" | mkN "沙钟" | mkN "沙壺" | mkN "沙壶" | {-mwn-} mkN "时漏" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin houri_N = mkN "天女" | mkN "天仙" ; -- status=guess -- status=guess
lin hourly_A = mkA "每小时" ;
lin hourly_Adv = adjAdv hourly_A ; -- derived
lin house_N = L.house_N | {-HSK-} mkN "屋子" "間" | mkN "门" ;
lin house_V2 = mkV2 "驻扎" ;
lin houseboat_N = mkN "船屋" ; -- open-multilingual-wordnet
lin housebreaking_N = mkN "侵入住宅" | mkN "入室行窃" | mkN "非法进入" ; -- open-multilingual-wordnet
lin housedog_N = mkN "家犬" | mkN "看家狗" | mkN "看门狗" ; -- open-multilingual-wordnet
lin houseful_N = mkN "满屋" ; -- open-multilingual-wordnet
lin household_N = mkN "家庭" | {-HSK-} mkN "家庭" "戶" ;
lin housekeeper_N = mkN "主妇" ;
lin housemaid_N = mkN "佣妇" | mkN "侍女" | mkN "女仆" | mkN "女佣" ; -- open-multilingual-wordnet
lin houseman_N = mkN "男仆" ;
lin housemate_N = mkN "室友" | mkN "同屋" ; -- status=guess -- status=guess
lin houseplant_N = mkN "室内植物" ; -- open-multilingual-wordnet
lin houseroom_N = mkN "住宿处" ; -- open-multilingual-wordnet
lin housetop_N = mkN "屋顶" | mkN "房顶" ; -- open-multilingual-wordnet
lin housewife_N = mkN "家庭主妇" ;
lin housework_N = mkN "家务" | {-HSK-} mkN "家务" [] ;
lin housing_N = mkN "住房" ;
lin houston_PN = mkPN "休斯顿" ;
lin hove_PN = foreignPN "Hove" ; -- comment=src=geonames status=guess
lin hover_V = mkV "徘徊" ;
lin hovercraft_N = mkN "氣墊船" | mkN "气垫船" | {-mwn-} mkN "气垫运载工具" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin how8many_IDet = S.how8many_IDet ;
lin how8much_IAdv = S.how8much_IAdv ;
lin how_IAdv = S.how_IAdv ;
lin how_much_IDet = mkIDet "多少" ; -- comment=orig. how8much??
lin howard_PN = foreignPN "Howard" ; -- comment=src=geonames status=guess
lin howdah_N = mkN "象轿" ; -- open-multilingual-wordnet
lin however_Adv = mkAdv "不过" | mkAdv "但是" | mkAdv "却" | mkAdv "可是" | mkAdv "然而" ;
lin howitzer_N = mkN "榴弹炮" ;
lin howl_N = mkN "嗥叫" ;
lin howl_V = mkV "咆哮" ;
lin howl_V2 = mkV2 (mkV "吼") ; -- status=guess, src=wikt
lin howler_N = mkN "吼猴" ; -- status=guess -- status=guess
lin hoylake_PN = foreignPN "Hoylake" ; -- comment=src=geonames status=guess
lin hoyland_nether_PN = foreignPN "Hoyland nether" ; -- comment=src=eng status=guess
lin hq_PN = foreignPN "Hq" ; -- comment=src=eng status=guess
lin hrh_PN = foreignPN "Hrh" ; -- comment=src=eng status=guess
lin hryvnia_N = mkN "格里夫納" | mkN "格里夫纳" | mkN "赫里夫尼亞" | mkN "赫里夫尼亚" | mkN "烏克蘭元" | mkN "乌克兰元" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin huarache_N = mkN "平跟皮凉鞋" ; -- open-multilingual-wordnet
lin hub_N = mkN "中心" ;
lin hubbub_N = mkN "喧嘩" | mkN "喧哗" | mkN "吵鬧" | mkN "吵闹" | mkN "塵囂" | mkN "尘嚣" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin hubcap_N = mkN "轮毂罩" | mkN "轮踏盖" ; -- open-multilingual-wordnet
lin hubert_PN = foreignPN "Hubert" ; -- comment=src=eng status=guess
lin huck_N = mkN "一种粗麻布" ; -- open-multilingual-wordnet
lin huckaback_N = mkN "一种粗麻布" ; -- open-multilingual-wordnet
lin hucknall_PN = foreignPN "Hucknall" ; -- comment=src=geonames status=guess
lin huddersfield_PN = mkPN "哈德斯菲爾德" ; -- comment=src=geonames status=guess
lin huddle_V = mkV "挤作一团" ;
lin hue_N = mkN "色調" | mkN "色调" | mkN "色彩" ; -- status=guess -- status=guess -- status=guess
lin hueless_A = mkA "无色彩" | mkA "无色泽" ; -- open-multilingual-wordnet
lin huff_N = mkN "无谓的争吵" ; -- open-multilingual-wordnet
lin huff_V = mkV "喘粗气" ; -- open-multilingual-wordnet
lin hug_N = mkN "拥抱" ;
lin hug_V2 = mkV2 "拥抱" ;
lin huge_A = mkA "大" | mkA "巨大" ;
lin hugely_Adv = mkAdv "大大" | adjAdv huge_A ; -- status=guess -- derived -- derived
lin hugh_PN = foreignPN "Hugh" ; -- comment=src=eng status=guess
lin hughie_PN = foreignPN "Hughie" ; -- comment=src=eng status=guess
lin huhehot_PN = foreignPN "Huhehot" ; -- comment=src=eng status=guess
lin hulk_N = mkN "废船" ;
lin hull_N = mkN "船体" | mkN "船壳" ; -- open-multilingual-wordnet
lin hullabaloo_N = mkN "喧嚣" ;
lin hum_N = mkN "嗡嗡声" ;
lin hum_V = mkV "哼" ;
lin human_A = mkA "人道" ;
lin human_N = mkN "人" ;
lin humane_A = mkA "有人情" | mkA "人道" ; -- status=guess -- status=guess
lin humanism_N = mkN "人道主义" ;
lin humanitarian_A = mkA "人道主义" ;
lin humanitarian_N = mkN "人道主義者" ; -- status=guess
lin humanitarianism_N = mkN "人道主義" | mkN "人道主义" ; -- status=guess -- status=guess
lin humanities_N = mkN "人文科學" | mkN "人文科学" ; -- status=guess -- status=guess
lin humanity_N = mkN "人类" ;
lin humanize_V2 = mkV2 "使+人性化" ;
lin humankind_N = mkN "人類" | mkN "人类" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin humanness_N = mkN "人性" ; -- open-multilingual-wordnet
lin humberside_PN = foreignPN "Humberside" ; -- comment=src=eng status=guess
lin humberston_PN = foreignPN "Humberston" ; -- comment=src=geonames status=guess
lin humble_A = mkA "谦逊" ;
lin humble_V2 = mkV2 "使谦恭" ;
lin humerus_N = mkN "肱骨" ; -- status=guess
lin humic_A = mkA "腐殖" | mkA "腐殖质" ; -- open-multilingual-wordnet
lin humid_A = mkA "湿" ;
lin humidity_N = mkN "濕度" | mkN "湿度" | {-mwn-} mkN "湿气" | mkN "潮湿" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin humification_N = mkN "腐殖质形成" | mkN "腐质土化" ; -- open-multilingual-wordnet
lin humified_A = mkA "腐殖化" ; -- open-multilingual-wordnet
lin humiliate_V2 = mkV2 (mkV "羞辱") | mkV2 (mkV "侮辱") | mkV2 (mkV "污辱") | mkV2 (mkV "欺侮") | mkV2 (mkV "辱罵") | mkV2 (mkV "辱骂") ; -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt -- status=guess, src=wikt
lin humiliation_N = mkN "屈辱" ;
lin humility_N = mkN "谦卑" ; -- comment="谦逊" ;
lin hummingbird_N = mkN "蜂鳥" | mkN "蜂鸟" ; -- status=guess -- status=guess
lin humor_N = mkN "幽默" ;
lin humoral_A = mkA "体液" | mkA "来自体液" | mkA "由体液引起" ; -- open-multilingual-wordnet
lin humorist_N = mkN "幽默家" ;
lin humorous_A = mkA "幽默" ; -- status=guess
lin humour_N = mkN "幽默" "" ;
lin humpback_N = mkN "駝背" | mkN "驼背" | mkN "駝子" | mkN "驼子" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin humpbacked_A = mkA "駝背" | mkA "驼背" ; -- status=guess -- status=guess
lin humphrey_PN = foreignPN "Humphrey" ; -- comment=src=eng status=guess
lin humus_N = mkN "腐殖質" | mkN "腐殖质" ; -- status=guess -- status=guess
lin hunch_N = mkN "预感" ;
lin hunch_V2 = mkV2 "弯腰驼背" ;
lin hundredfold_Adv = mkAdv "百倍+地" ; -- open-multilingual-wordnet
lin hundredweight_N = mkN "英担" ;
lin hungarian_A = mkA "匈牙利" ;
lin hungarian_N = mkN "匈牙利人" ;
lin hungary_PN = mkPN "匈牙利" ;
lin hunger_N = mkN "渴望" [] ;
lin hungry_A = mkA "饿" | {-HSK-} mkA "饿了" ;
lin hunk_N = mkN "大块" ;
lin hunt_N = mkN "狩猎" "场" ;
lin hunt_V = mkV "狩猎" ;
lin hunt_V2 = L.hunt_V2 ;
lin hunter_N = mkN "猎人" ;
lin hunting_N = mkN "狩猎" "次" ;
lin huntingdon_PN = mkPN "亨丁頓" ; -- comment=src=geonames status=guess
lin huntsman_N = mkN "巨蟹蛛" | {-mwn-} mkN "猎人" ; -- status=guess -- open-multilingual-wordnet
lin hurdle_N = mkN "障碍" ;
lin hurdy_gurdy_N = mkN "手提管风琴" ; -- open-multilingual-wordnet
lin hurl_V2 = mkV2 "用力投掷" ;
lin hurricane_N = mkN "飓风" ;
lin hurried_A = mkA "匆忙" ;
lin hurry_N = mkN "匆忙" ;
lin hurry_V = mkV "赶快" ;
lin hurstpierpoint_PN = foreignPN "Hurstpierpoint" ; -- comment=src=geonames status=guess
lin hurt_N = mkN "伤害" ;
lin hurt_V = mkV "伤害" ;
lin hurt_V2 = mkV2 "伤害" ;
lin hurtle_V = mkV "猛冲" ;
lin husband_N = L.husband_N | {-HSK-} mkN "丈夫" "個" | mkN "先生" "個" ;
lin husband_V2 = mkV2 "使+节俭使用" ;
lin husbandry_N = mkN "养殖业" | mkN "农业" | mkN "农事" | mkN "畜牧业" | mkN "耕作" ; -- open-multilingual-wordnet
lin hush_N = mkN "安靜" | mkN "安静" ; -- status=guess -- status=guess
lin hush_V = mkV "安靜" | mkV "安静" ; -- status=guess, src=wikt -- status=guess, src=wikt
lin hush_V2 = mkV2 (mkV "安靜") | mkV2 (mkV "安静") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin hush_hush_A = mkA "机密" ;
lin husk_N = mkN "皮" ;
lin husky_A = mkA "声音沙哑" ;
lin hussar_N = mkN "輕騎兵" | mkN "轻骑兵" ; -- status=guess -- status=guess
lin hustle_V = mkV "猛推" ;
lin hustler_N = mkN "催促者" ;
lin hut_N = mkN "棚屋" "个" ;
lin hutment_N = mkN "临时营房" ; -- open-multilingual-wordnet
lin hwainan_PN = foreignPN "Hwainan" ; -- comment=src=eng status=guess
lin hyacinth_N = mkN "風信子" | {-mwn-} mkN "五色水仙" | mkN "时样锦" | mkN "洋水仙" | mkN "西洋水仙" | mkN "风信子" ; -- status=guess -- open-multilingual-wordnet
lin hyaena_N = mkN "土狼" | mkN "鬣狗" ; -- open-multilingual-wordnet
lin hyaline_A = mkA "玻璃似" | mkA "玻璃状" | mkA "透明" ; -- open-multilingual-wordnet
lin hyalinization_N = mkN "透明样变化" ; -- open-multilingual-wordnet
lin hyaloplasmic_A = mkA "透明质" ; -- open-multilingual-wordnet
lin hybrid_A = mkA "混合" ;
lin hybrid_N = mkN "杂种" ; -- comment="混血儿" ;
lin hybridization_N = mkN "雜交" | mkN "杂交" ; -- status=guess -- status=guess
lin hydantoin_N = mkN "乙内酰脲" ; -- open-multilingual-wordnet
lin hydathode_N = mkN "排水器" | mkN "排水孔" ; -- open-multilingual-wordnet
lin hydatid_N = mkN "囊" | mkN "囊肿" | mkN "水胞体" ; -- open-multilingual-wordnet
lin hyde_PN = foreignPN "Hyde" ; -- comment=src=geonames status=guess
lin hyderabad_PN = mkPN "海得拉巴" ; -- comment=src=geonames status=guess
lin hydra_N = mkN "水螅" ; -- status=guess
lin hydramnios_N = mkN "羊水过多" ; -- open-multilingual-wordnet
lin hydrangea_N = mkN "繡球花" | mkN "绣球花" | {-mwn-} mkN "绣球属植物" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hydrant_N = mkN "水龙头" ; -- open-multilingual-wordnet
lin hydrarthrosis_N = mkN "关节积水" ; -- open-multilingual-wordnet
lin hydrate_N = mkN "水合物" ; -- status=guess
lin hydration_N = mkN "水合" | mkN "水合作用" ; -- open-multilingual-wordnet
lin hydraulic_A = mkA "液压" ;
lin hydrazine_N = mkN "肼" ; -- status=guess
lin hydrazoite_N = mkN "叠氨酸盐" ; -- open-multilingual-wordnet
lin hydremia_N = mkN "稀血症" ; -- open-multilingual-wordnet
lin hydric_A = mkA "水生" | mkA "湿生" ; -- open-multilingual-wordnet
lin hydrocarbon_N = mkN "碳氢化合物" ;
lin hydrocele_N = mkN "水囊肿" ; -- open-multilingual-wordnet
lin hydrocephalic_A = mkA "脑积水" ; -- open-multilingual-wordnet
lin hydrocephalus_N = mkN "腦積水" | mkN "脑积水" | mkN "腦水腫" | mkN "脑水肿" | mkN "水腦症" | mkN "水脑症" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hydrochloride_N = mkN "氢氯化物" ; -- open-multilingual-wordnet
lin hydrocolloid_N = mkN "水状胶体" ; -- open-multilingual-wordnet
lin hydrocracking_N = mkN "加氢裂化" | mkN "氢化裂解" ; -- open-multilingual-wordnet
lin hydrodynamic_A = mkA "水动力学" ; -- open-multilingual-wordnet
lin hydroelectric_A = mkA "水力发电" ;
lin hydroflumethiazide_N = mkN "氢氟噻嗪" ; -- open-multilingual-wordnet
lin hydrofoil_N = mkN "水翼船" ; -- status=guess -- open-multilingual-wordnet
lin hydrogel_N = mkN "水凝胶" ; -- open-multilingual-wordnet
lin hydrogen_N = mkN "氢原子" "个" ;
lin hydrogenation_N = mkN "加氢" ; -- open-multilingual-wordnet
lin hydrographic_A = mkA "水道学" | mkA "水道测量数" ; -- open-multilingual-wordnet
lin hydrokinetic_A = mkA "流体动力" | mkA "液体动力" ; -- open-multilingual-wordnet
lin hydrologist_N = mkN "水文學者" | mkN "水文学者" ; -- status=guess -- status=guess
lin hydrolysate_N = mkN "水解产物" | mkN "水解液" ; -- open-multilingual-wordnet
lin hydrolysis_N = mkN "加水分解" | mkN "水解作用" ; -- open-multilingual-wordnet
lin hydrolyzable_A = mkA "可水解" ; -- open-multilingual-wordnet
lin hydrometer_N = mkN "比重计" ; -- open-multilingual-wordnet
lin hydronephrosis_N = mkN "肾盂积水" ; -- open-multilingual-wordnet
lin hydropathic_A = mkA "水疗法" ; -- open-multilingual-wordnet
lin hydrophobia_N = mkN "恐水病" | mkN "狂犬病" | mkN "蚓状体" ; -- open-multilingual-wordnet
lin hydrophytic_A = mkA "水生" ; -- open-multilingual-wordnet
lin hydroplane_N = mkN "水翼船" ; -- open-multilingual-wordnet
lin hydrostatic_A = mkA "流体静力学" | mkA "静水学" ; -- open-multilingual-wordnet
lin hydrothorax_N = mkN "胸膜积水" ; -- open-multilingual-wordnet
lin hydrous_A = mkA "与水结合" | mkA "含水" | mkA "水化" | mkA "水和" | mkA "水状" ; -- open-multilingual-wordnet
lin hydroxy_A = mkA "羟基" ; -- open-multilingual-wordnet
lin hydroxyl_N = mkN "羥基" | mkN "羟基" ; -- status=guess -- status=guess
lin hydroxyproline_N = mkN "羟胆碱" ; -- open-multilingual-wordnet
lin hyena_N = mkN "未完成体" ;
lin hygiene_N = mkN "卫生用品" ;
lin hygienic_A = mkA "衛生" | mkA "卫生" | {-mwn-} mkA "保健" | mkA "卫生" | mkA "清洁" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hygrodeik_N = mkN "图示湿度计" | mkN "干湿球湿度表" ; -- open-multilingual-wordnet
lin hygrometer_N = mkN "湿度计" ; -- open-multilingual-wordnet
lin hygrophytic_A = mkA "需要大量水分" ; -- open-multilingual-wordnet
lin hygroscope_N = mkN "湿度计" | mkN "验湿器" ; -- open-multilingual-wordnet
lin hygroscopic_A = mkA "吸湿性" | mkA "容易吸收水分" | mkA "容易潮湿" ; -- open-multilingual-wordnet
lin hymen_N = mkN "處女膜" | mkN "处女膜" ; -- status=guess -- status=guess
lin hymenal_A = mkA "处女膜" ; -- open-multilingual-wordnet
lin hymenopterous_A = mkA "膜翅类" ; -- open-multilingual-wordnet
lin hymn_N = mkN "頌" | mkN "颂" | mkN "讚美詩" | mkN "赞美诗" | mkN "聖歌" | mkN "圣歌" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin hyoid_A = mkA "舌骨" ; -- open-multilingual-wordnet
lin hyoscyamine_N = mkN "天仙子胺" | mkN "茛菪素" | mkN "豆素" ; -- open-multilingual-wordnet
lin hypallage_N = mkN "換置法" | mkN "换置法" ; -- status=guess -- status=guess
lin hype_V2 = mkV2 "大肆宣传" ;
lin hyperbola_N = mkN "雙曲線" | mkN "双曲线" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hyperbole_N = mkN "誇飾" ; -- status=guess
lin hyperboloid_N = mkN "双曲面" ; -- open-multilingual-wordnet
lin hyperboloidal_A = mkA "双曲面" ; -- open-multilingual-wordnet
lin hypercalcemia_N = mkN "血钙过多" ; -- open-multilingual-wordnet
lin hypercalciuria_N = mkN "高尿钙症" ; -- open-multilingual-wordnet
lin hypercapnia_N = mkN "多碳酸血" | mkN "高碳酸血" | mkN "高碳酸血症" ; -- open-multilingual-wordnet
lin hypercellularity_N = mkN "细胞过多" ; -- open-multilingual-wordnet
lin hypercholesterolemia_N = mkN "高胆固醇血" ; -- open-multilingual-wordnet
lin hypercoaster_N = mkN "过山车" ; -- open-multilingual-wordnet
lin hyperemia_N = mkN "充血" ; -- open-multilingual-wordnet
lin hyperemic_A = mkA "充血" ; -- open-multilingual-wordnet
lin hyperextension_N = mkN "伸展过度" | mkN "过伸" | mkN "过度伸展" ; -- open-multilingual-wordnet
lin hyperfine_A = mkA "超微" | mkA "超精细" | mkA "超细" ; -- open-multilingual-wordnet
lin hyperglycemia_N = mkN "多糖症" | mkN "血糖过多症" | mkN "高血糖症" ; -- open-multilingual-wordnet
lin hyperhidrosis_N = mkN "剧汗" | mkN "多汗" | mkN "多汗症" | mkN "汗分泌过多" ; -- open-multilingual-wordnet
lin hypericism_N = mkN "金丝桃素" | mkN "金丝桃素皮炎" ; -- open-multilingual-wordnet
lin hyperinflation_N = mkN "恶性通货膨胀" ;
lin hyperkalemia_N = mkN "血钾过多" | mkN "高钾" ; -- open-multilingual-wordnet
lin hyperlink_N = mkN "超鏈接" | mkN "超链接" | mkN "超聯結" | mkN "超联结" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin hyperlipoproteinemia_N = mkN "血脂蛋白过多" ; -- open-multilingual-wordnet
lin hypermarket_N = mkN "大规模市场" ;
lin hypermotility_N = mkN "运动过度" | mkN "运动过强" ; -- open-multilingual-wordnet
lin hypernatremia_N = mkN "高钠血" ; -- open-multilingual-wordnet
lin hypernym_N = mkN "上位詞" | mkN "上位词" ; -- status=guess -- status=guess
lin hypernymy_N = mkN "上位关系" ; -- open-multilingual-wordnet
lin hyperopia_N = mkN "远视" | mkN "远视眼" ; -- open-multilingual-wordnet
lin hyperopic_A = mkA "远视" ; -- open-multilingual-wordnet
lin hyperpigmentation_N = mkN "色素沉着过度" ; -- open-multilingual-wordnet
lin hyperpituitarism_N = mkN "垂体功能亢进" ; -- open-multilingual-wordnet
lin hyperplasia_N = mkN "增生" ; -- open-multilingual-wordnet
lin hyperpyrexia_N = mkN "体温过高" | mkN "高烧" ; -- open-multilingual-wordnet
lin hypersecretion_N = mkN "分泌亢进" ; -- open-multilingual-wordnet
lin hypersensitive_A = mkA "患过敏症" | mkA "过敏" | mkA "过敏性" | mkA "过敏症" ; -- open-multilingual-wordnet
lin hypersomnia_N = mkN "嗜睡症" | mkN "睡眠过度" ; -- open-multilingual-wordnet
lin hypersplenism_N = mkN "脾功能亢进" ; -- open-multilingual-wordnet
lin hypertension_N = mkN "高血壓症" | mkN "高血压症" ; -- status=guess -- status=guess
lin hypertext_N = mkN "超文本" ; -- status=guess
lin hyperthermal_A = mkA "超高温" ; -- open-multilingual-wordnet
lin hyperthermia_N = mkN "高熱" | mkN "高热" | mkN "中暑" | {-mwn-} mkN "高烧" | mkN "高热症" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hyperthyroidism_N = mkN "甲状腺官能症" ; -- open-multilingual-wordnet
lin hypertonia_N = mkN "张力亢进" | mkN "张力过强" | mkN "高张性" ; -- open-multilingual-wordnet
lin hypertonicity_N = mkN "张力亢进" | mkN "张力过强" | mkN "高张性" ; -- open-multilingual-wordnet
lin hypertrophy_N = mkN "肥大" | {-mwn-} mkN "异常增大" ; -- status=guess -- open-multilingual-wordnet
lin hypervelocity_N = mkN "极速" | mkN "超速" | mkN "超高速" ; -- open-multilingual-wordnet
lin hypervitaminosis_N = mkN "维生素过多症" ; -- open-multilingual-wordnet
lin hypervolemia_N = mkN "血容量增加" | mkN "血容量过多" ; -- open-multilingual-wordnet
lin hyphema_N = mkN "眼前房出血" | mkN "眼前房积血" ; -- open-multilingual-wordnet
lin hyphen_N = mkN "連字號" | mkN "连字号" ; -- status=guess -- status=guess
lin hypnophobia_N = mkN "睡眠恐怖" ; -- open-multilingual-wordnet
lin hypnosis_N = mkN "催眠" | {-mwn-} mkN "似睡眠的状态" | mkN "受催眠的状态" ; -- status=guess -- open-multilingual-wordnet
lin hypnotic_A = mkA "催眠" ;
lin hypnotism_N = mkN "催眠術" | mkN "催眠术" ; -- status=guess -- status=guess
lin hypnotize_V2 = mkV2 "催眠" ;
lin hypo_N = mkN "皮下注射器" ; -- open-multilingual-wordnet
lin hypobasidium_N = mkN "下担子" | mkN "分离担子" ; -- open-multilingual-wordnet
lin hypocalcemia_N = mkN "低血钙症" ; -- open-multilingual-wordnet
lin hypocapnia_N = mkN "缺碳酸血症" ; -- open-multilingual-wordnet
lin hypochlorite_N = mkN "次氯酸盐" ; -- open-multilingual-wordnet
lin hypochondria_N = mkN "疑心病" | mkN "疑病症" ; -- open-multilingual-wordnet
lin hypocrisy_N = mkN "虚伪" [] ;
lin hypocrite_N = mkN "伪君子" ;
lin hypocritical_A = mkA "虛偽" | mkA "虚伪" | mkA "假惺惺" | mkA "偽善" | mkA "伪善" | {-mwn-} mkA "伪善" | mkA "虚伪" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hypocycloid_N = mkN "次摆圆" ; -- open-multilingual-wordnet
lin hypodermal_A = mkA "下皮" | mkA "皮下" | mkA "表皮下" ; -- open-multilingual-wordnet
lin hypodermic_A = mkA "皮下" ; -- open-multilingual-wordnet
lin hypodermic_N = mkN "皮下注射器" ; -- open-multilingual-wordnet
lin hypoesthesia_N = mkN "感觉减退" ; -- open-multilingual-wordnet
lin hypoglycemic_A = mkA "低血糖" | mkA "低血糖症" | mkA "血糖过低" ; -- open-multilingual-wordnet
lin hypogonadism_N = mkN "性腺功能减退" ; -- open-multilingual-wordnet
lin hypokalemia_N = mkN "低钾血" ; -- open-multilingual-wordnet
lin hypolipoproteinemia_N = mkN "低脂蛋白血症" ; -- open-multilingual-wordnet
lin hyponatremia_N = mkN "低钠血" ; -- open-multilingual-wordnet
lin hyponymy_N = mkN "上下位关系" | mkN "下义关系" ; -- open-multilingual-wordnet
lin hypophyseal_A = mkA "脑下垂体" ; -- open-multilingual-wordnet
lin hypopigmentation_N = mkN "着色不足" | mkN "色素减退" ; -- open-multilingual-wordnet
lin hypoplasia_N = mkN "发育不全" ; -- open-multilingual-wordnet
lin hypoproteinemia_N = mkN "低蛋白血" ; -- open-multilingual-wordnet
lin hyposmia_N = mkN "嗅觉不灵" ; -- open-multilingual-wordnet
lin hypospadias_N = mkN "尿道下裂" ; -- open-multilingual-wordnet
lin hypotension_N = mkN "低血壓症" | mkN "低血压症" ; -- status=guess -- status=guess
lin hypotenuse_N = mkN "斜邊" | mkN "斜边" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin hypothalamic_A = mkA "下丘脑" | {-mwn-} mkA "下丘脑" | mkA "丘脑下部" ; -- status=guess -- open-multilingual-wordnet
lin hypothalamus_N = mkN "下丘脑" ; -- status=guess
lin hypothermic_A = mkA "低体温" | mkA "体温过低" ; -- open-multilingual-wordnet
lin hypothesis_N = mkN "假设" "次" ;
lin hypothesize_V2 = mkV2 "假设" ;
lin hypothetical_A = mkA "假想" ;
lin hypothrombinemia_N = mkN "低凝血酶血" ; -- open-multilingual-wordnet
lin hypothyroidism_N = mkN "甲狀腺功能減退症" | mkN "甲状腺功能减退症" | mkN "甲狀腺功能減退" | mkN "甲状腺功能减退" | mkN "甲減" | mkN "甲减" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin hypotonia_N = mkN "张力减退" ; -- open-multilingual-wordnet
lin hypotonicity_N = mkN "张力减退" ; -- open-multilingual-wordnet
lin hypovolemia_N = mkN "血容量过低" ; -- open-multilingual-wordnet
lin hypovolemic_A = mkA "血容量减少" ; -- open-multilingual-wordnet
lin hypoxia_N = mkN "低氧" | mkN "氧不足" | mkN "氧过少" ; -- open-multilingual-wordnet
lin hypsometer_N = mkN "沸点测高计" | mkN "测高计" ; -- open-multilingual-wordnet
lin hysterectomy_N = mkN "子宮切除術" | mkN "子宫切除术" ; -- status=guess -- status=guess
lin hysteria_N = mkN "歇斯底里" ;
lin hysterical_A = mkA "歇斯底里" ;
lin hysterics_N = mkN "歇斯底里爆发" ; -- open-multilingual-wordnet
lin hythe_PN = foreignPN "Hythe" ; -- comment=src=geonames status=guess
lin iFem_Pron = S.i_Pron ;
lin i_Pron = S.i_Pron ;
lin iamb_N = mkN "抑揚格" | mkN "抑扬格" ; -- status=guess -- status=guess
lin iambic_A = mkA "抑扬格" ;
lin ian_PN = foreignPN "Ian" ; -- comment=src=eng status=guess
lin ibadan_PN = mkPN "伊巴丹" ; -- comment=src=geonames status=guess
lin ibid_PN = foreignPN "Ibid" ; -- comment=src=eng status=guess
lin ibis_N = mkN "朱鹭" | mkN "鹮" ; -- open-multilingual-wordnet
lin ibuprofen_N = mkN "布洛芬" ; -- status=guess
lin ice_N = L.ice_N ;
lin ice_V = mkV "冰冻" ; -- status=guess, src=wikt -- open-multilingual-wordnet
lin ice_V2 = mkV2 "冰镇" ;
lin iceberg_N = mkN "冰山" ;
lin iceboat_N = mkN "冰上滑艇" | mkN "冰上滑行船" | mkN "冰船" ; -- open-multilingual-wordnet
lin icebox_N = mkN "冰箱" "臺" ;
lin icebreaker_N = mkN "破冰船" ; -- status=guess
lin icehouse_N = mkN "冰室" | mkN "冰库" ; -- open-multilingual-wordnet
lin iceland_PN = mkPN "冰岛" ; -- comment=src=geonames status=guess
lin icepick_N = mkN "碎冰錐" | mkN "碎冰锥" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin ice_tray_N = mkN "冰格" ; -- open-multilingual-wordnet
lin ichorous_A = mkA "脓水" ; -- open-multilingual-wordnet
lin ichthyology_N = mkN "魚類學" | mkN "鱼类学" ; -- status=guess -- status=guess
lin ichthyosaur_N = mkN "魚龍" | mkN "鱼龙" ; -- status=guess -- status=guess
lin ichthyosis_N = mkN "魚鱗病" | mkN "鱼鳞病" | {-mwn-} mkN "干皮病" | mkN "鳞癣" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin icicle_N = mkN "冰柱" ; -- status=guess
lin icing_N = mkN "糖霜" ; -- status=guess
lin icon_N = mkN "图标" ;
lin iconic_A = mkA "图标" ; -- open-multilingual-wordnet
lin iconography_N = mkN "图像记录" ; -- open-multilingual-wordnet
lin iconoscope_N = mkN "光电/摄象管" | mkN "光电摄像管" | mkN "光电析像管" | mkN "光电析象管" | mkN "映像管" ; -- open-multilingual-wordnet
lin icosahedral_A = mkA "二十面体" ; -- open-multilingual-wordnet
lin icosahedron_N = mkN "二十面体" ; -- open-multilingual-wordnet
lin ictal_A = mkA "发作" ; -- open-multilingual-wordnet
lin icterogenic_A = mkA "致黄疸" ; -- open-multilingual-wordnet
lin id_N = mkN "身份证" ;
lin ida_PN = foreignPN "Ida" ; -- comment=src=eng status=guess
lin idaho_PN = foreignPN "Idaho" ; -- comment=src=eng status=guess
lin idea_N = mkN "主意" "個" | mkN "念" | mkN "思想" "個" | mkN "意思" "個" | mkN "意见" "點" | mkN "概念" "個" | {-HSK-} mkN "想法" ;
lin idea_of_N2 = mkN2 "想法" ;
lin ideal_A = mkA "完美" | {-HSK-} mkA "理想" ;
lin ideal_N = mkN "理想" | {-HSK-} mkN "理想" "個" ;
lin idealism_N = mkN "唯心论" ;
lin idealist_N = mkN "理想主义者" ;
lin idealistic_A = mkA "理想化" ;
lin idealize_V2 = mkV2 "理想化" ;
lin ideally_Adv = adjAdv ideal_A ; -- derived
lin idem_PN = foreignPN "Idem" ; -- comment=src=eng status=guess
lin idempotent_A = mkA "全幂等" | mkA "幂等" | mkA "等幂" ; -- open-multilingual-wordnet
lin identical_A = mkA "同一" | {-HSK-} mkA "相同" ;
lin identifiable_A = mkA "可辨认" ;
lin identification_N = mkN "证明" "個" | {-HSK-} mkN "鉴定" "次" ;
lin identify_V = mkV "鉴定" ;
lin identify_V2 = mkV2 "识别" ;
lin identity_N = mkN "身份" ;
lin ideogram_N = mkN "指事" ; -- status=guess
lin ideographic_A = mkA "会意" | mkA "表意" ; -- open-multilingual-wordnet
lin ideological_A = mkA "思想" ;
lin ideology_N = mkN "思想" "個" | mkN "观念" | {-HSK-} mkN "意识形态" ;
lin idiocy_N = mkN "白痴" "位" ;
lin idiographic_A = mkA "个案研究" | mkA "个案解释" | mkA "特殊规律研究法" | mkA "研究特殊规律" ; -- open-multilingual-wordnet
lin idiom_N = mkN "成語" | mkN "成语" | mkN "習慣用語" | mkN "习惯用语" | mkN "俗語" | mkN "俗语" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin idiomatic_A = mkA "惯用" ;
lin idiopathic_A = mkA "个人特有" | mkA "先天" | mkA "自发" ; -- open-multilingual-wordnet
lin idiosyncrasy_N = mkN "特性" ; -- status=guess
lin idiosyncratic_A = mkA "特质" ;
lin idiot_N = mkN "白痴" ;
lin idiotic_A = mkA "白痴" | mkA "愚蠢" ; -- status=guess -- status=guess
lin idle_A = mkA "休闲" | mkA "空闲" | {-HSK-} mkA "闲置" ;
lin idle_N = mkN "休闲" | mkN "空闲" ;
lin idle_V = mkV "虚度" ;
lin idle_V2 = mkV2 "怠" ;
lin idler_N = mkN "懶惰者" | mkN "懒惰者" ; -- status=guess -- status=guess
lin idol_N = mkN "偶像" | mkN "萬人迷" | mkN "万人迷" | {-mwn-} mkN "上帝" | mkN "神" | mkN "神像" ; -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin idolatrous_A = mkA "崇拜偶像" ; -- open-multilingual-wordnet
lin ie_PN = foreignPN "IE" ; -- comment=src=eng status=guess
lin if_Subj = S.if_Subj ;
lin if_then_Conj = S.if_then_Conj ;
lin igloo_N = mkN "拱形圆顶小屋" ; -- open-multilingual-wordnet
lin igneous_A = mkA "火成" ; -- status=guess
lin ignite_V = mkV "点" ;
lin ignite_V2 = mkV2 "点" | {-HSK-} mkV2 "点燃" ;
lin ignition_N = mkN "点火""" ;
lin ignoble_A = mkA "卑鄙" ;
lin ignominious_A = mkA "可耻" ;
lin ignominy_N = mkN "丑行" | mkN "羞愧" | mkN "羞耻" | mkN "羞辱" | mkN "耻" | mkN "耻辱" | mkN "辱" ; -- open-multilingual-wordnet
lin ignoramus_N = mkN "不学无术的人" ;
lin ignorance_N = mkN "无知" ;
lin ignorant_A = mkA "無知" | mkA "无知" ; -- status=guess -- status=guess
lin ignore_V = mkV "忽略" | {-HSK-} mkV "忽视" ;
lin ignore_V2 = mkV2 "忽略" | {-HSK-} mkV2 "忽视" ;
lin iguana_N = mkN "鬣蜥" ; -- status=guess
lin ikon_N = mkN "圣像" ; -- open-multilingual-wordnet
lin ileitis_N = mkN "回肠炎" ; -- open-multilingual-wordnet
lin ilfracombe_PN = foreignPN "Ilfracombe" ; -- comment=src=geonames status=guess
lin iliac_A = mkA "肠骨" | mkA "髂骨" ; -- open-multilingual-wordnet
lin ilk_N = mkN "亲属" ;
lin ilkeston_PN = foreignPN "Ilkeston" ; -- comment=src=geonames status=guess
lin ilkley_PN = foreignPN "Ilkley" ; -- comment=src=geonames status=guess
lin ill_1_A = mkA "生病" ;
lin ill_2_A = mkA "生病" ;
lin ill_AdV = mkAdV "不利地" ;
lin ill_N = mkN "病" ;
lin ill_advised_A = mkA "欠考虑" ;
lin ill_disposed_A = mkA "疾病" ;
lin ill_fated_A = mkA "被命运诅咒" ;
lin ill_gotten_A = mkA "来路不正" ;
lin ill_mannered_A = mkA "粗野" ;
lin illative_A = mkA "推理" | mkA "推理上" | mkA "推论" | mkA "推论上" | mkA "演绎" ; -- open-multilingual-wordnet
lin illegal_A = mkA "非法" ;
lin illegal_N = mkN "非法移民" ; -- status=guess
lin illegality_N = mkN "违法" ;
lin illegible_A = mkA "難以辨認" | mkA "难以辨认" | mkA "很難看懂" | mkA "很难看懂" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin illegitimate_A = mkA "私生" ;
lin illicit_A = mkA "非法" ;
lin illinois_PN = mkPN "伊利诺伊州" ;
lin illiteracy_N = mkN "文盲" ;
lin illiterate_A = mkA "文盲" ; -- status=guess
lin illiterate_N = mkN "文盲" ; -- status=guess
lin illness_N = mkN "疾病" "种" ;
lin illogical_A = mkA "不合理" ;
lin illuminant_N = mkN "光源" | mkN "发光体" ; -- open-multilingual-wordnet
lin illuminate_V2 = mkV2 "阐明" ; -- comment="说明" ;
lin illumination_N = mkN "光明" | {-HSK-} mkN "照明" ; -- status=guess
lin illusion_N = mkN "错觉" ;
lin illusional_A = mkA "幻影" | mkA "错觉" ; -- open-multilingual-wordnet
lin illusionist_N = mkN "魔术师" ;
lin illusive_A = mkA "幻影" | mkA "迷惑人" | mkA "错觉" ; -- open-multilingual-wordnet
lin illusory_A = mkA "幻影" | mkA "迷惑人" | mkA "错觉" ; -- open-multilingual-wordnet
lin illustrate_V = mkV "显示" | mkV "说明" ;
lin illustrate_V2 = mkV2 "显示" | mkV2 "说明" ;
lin illustrate_VS = mkVS "显示" | mkVS "说明" ;
lin illustration_N = mkN "图解" ;
lin illustrator_N = mkN "插圖畫家" | mkN "插图画家" ; -- status=guess -- status=guess
lin illustrious_A = mkA "有名" | mkA "著名" | mkA "优秀" | mkA "辉煌" | mkA "灿烂" | mkA "杰出" | mkA "杰出" | mkA "昭" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin ilmenite_N = mkN "钛铁矿" ; -- open-multilingual-wordnet
lin image_N = mkN "像" | mkN "形象" "個" | {-HSK-} mkN "图像" ;
lin imagery_N = mkN "比喻" ;
lin imaginable_A = mkA "可以想象" ;
lin imaginary_A = mkA "虚构" ;
lin imagination_N = mkN "想像力" ;
lin imaginative_A = mkA "想像" ;
lin imagine_V = mkV "想像" | {-HSK-} mkV "想象" ;
lin imagine_V2 = mkV2 "想象" | {-HSK-} mkV2 "设想" ;
lin imagine_VS = mkVS "想像" | {-HSK-} mkVS "想象" ;
lin imam_N = mkN "伊馬目" | mkN "伊马目" | mkN "阿訇" | mkN "教長" | mkN "教长" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess
lin imbalance_N = mkN "不平衡" [] ;
lin imbibe_V2 = mkV2 (mkV "饮") | mkV2 (mkV "喝") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin imbricate_A = mkA "叠瓦状" | mkA "覆瓦状" | mkA "重叠成瓦状" | mkA "鳞状" ; -- open-multilingual-wordnet
lin imbrication_N = mkN "搭接叠覆" | mkN "鳞状重叠" ; -- open-multilingual-wordnet
lin imbroglio_N = mkN "纠葛" "单" ;
lin imitate_V2 = mkV2 "则" | mkV2 "模仿" ;
lin imitation_N = mkN "模仿" "" ;
lin immanence_N = mkN "内在" | mkN "固有" ; -- open-multilingual-wordnet
lin immature_A = mkA "嫩" | mkA "未成熟" | mkA "幼小" ; -- status=guess -- status=guess -- status=guess
lin immaturity_N = mkN "未成年" "种" ;
lin immediacy_N = mkN "直接" [] ;
lin immediate_A = mkA "即时" | {-HSK-} mkA "直接" | mkA "立刻" ;
lin immense_A = mkA "巨大" ;
lin immerse_V2 = mkV2 "沉浸" ;
lin immersion_N = mkN "浸入" ; -- status=guess
lin immigrant_N = mkN "移民" ;
lin immigrate_V = mkV "移民" ;
lin immigration_N = mkN "移民" ;
lin imminence_N = mkN "危急" | mkN "急迫" | mkN "燃眉之急" | mkN "迫切" ; -- open-multilingual-wordnet
lin imminent_A = mkA "紧迫" ;
lin immingham_PN = foreignPN "Immingham" ; -- comment=src=geonames status=guess
lin immodest_A = mkA "不谦虚" ;
lin immolation_N = mkN "獻祭" | mkN "献祭" | mkN "供物" ; -- status=guess -- status=guess -- status=guess
lin immoral_A = mkA "不道德" ;
lin immorality_N = mkN "不道德" ;
lin immortal_A = mkA "不朽" ; -- status=guess
lin immortality_N = mkN "不朽" | mkN "永生" ; -- status=guess -- status=guess
lin immune_A = mkA "免疫" ;
lin immune_N = mkN "免疫系統" | mkN "免疫系统" ; -- status=guess -- status=guess
lin immunity_N = mkN "免疫力" ;
lin immunochemical_A = mkA "免疫化学" ; -- open-multilingual-wordnet
lin immunodeficiency_N = mkN "免疫缺陷" ; -- open-multilingual-wordnet
lin immunoelectrophoresis_N = mkN "免疫电泳" ; -- open-multilingual-wordnet
lin immunogen_N = mkN "免疫剂" | mkN "免疫原" ; -- open-multilingual-wordnet
lin immunohistochemistry_N = mkN "免疫組織化學" | mkN "免疫组织化学" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin immunological_A = mkA "免疫学" ; -- open-multilingual-wordnet
lin immunology_N = mkN "免疫学" ; -- status=guess
lin immunosuppressant_N = mkN "免疫抑制剂" ; -- open-multilingual-wordnet
lin immunosuppressed_A = mkA "抑制免疫" ; -- open-multilingual-wordnet
lin immunosuppression_N = mkN "免疫抑制" ; -- open-multilingual-wordnet
lin immunosuppressive_A = mkA "免疫抑制" ; -- open-multilingual-wordnet
lin immunotherapeutic_A = mkA "免疫疗法" ; -- open-multilingual-wordnet
lin immure_V2 = mkV2 (mkV "监禁") | mkV2 (mkV "禁闭") ; -- status=guess, src=wikt -- status=guess, src=wikt
lin immutable_A = mkA "不变" | mkA "不可变" | mkA "不易变" | mkA "不能变" ; -- open-multilingual-wordnet
lin imp_N = mkN "惡魔" | mkN "恶魔" | mkN "邪鬼" ; -- status=guess -- status=guess -- status=guess
lin impact_N = mkN "作用" | {-HSK-} mkN "影响" ;
lin impact_V2 = mkV2 "碰撞" ;
lin impair_V2 = mkV2 "削弱" ;
lin impairment_N = mkN "减值" ;
lin impalement_N = mkN "穿刺" | mkN "刺穿" | {-mwn-} mkN "刺刑" | mkN "戳穿" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin impart_V2 = mkV2 "给予" ; -- comment="传授" ;
lin impartial_A = mkA "公平" | mkA "客观" | {-HSK-} mkA "公正" ;
lin impassable_A = mkA "死" ;
lin impasse_N = mkN "僵局" ;
lin impassioned_A = mkA "充满热情" ;
lin impassive_A = mkA "冷漠" ;
lin impassiveness_N = mkN "FOO" ;
lin impatience_N = mkN "不耐烦" | {-HSK-} mkN "急躁" ;
lin impatient_A = mkA "不耐烦" ;
lin impeach_V2 = mkV2 "弹劾" ;
lin impeachability_N = mkN "有责任" ; -- open-multilingual-wordnet
lin impeachment_N = mkN "弹劾" [] ;
lin impeccable_A = mkA "无可挑剔" ;
lin impeccant_A = mkA "无罪" | mkA "无罪过" | mkA "无错误" | mkA "清白" ; -- open-multilingual-wordnet
lin impecuniousness_N = mkN "缺钱" ; -- open-multilingual-wordnet
lin impede_V2 = mkV2 "阻碍" ;
lin impediment_N = mkN "口吃" ;
lin impedimenta_N = mkN "包袱" | mkN "辎重" ; -- open-multilingual-wordnet
lin impel_V2 = mkV2 "促使" ;
lin impeller_N = mkN "叶轮" | mkN "叶轮片" ; -- open-multilingual-wordnet
lin impend_V = mkV "即将发生" ;
lin impenetrable_A = mkA "费解" ;
lin imperative_A = mkA "必要" ; -- comment="势在必行" ;
lin imperative_N = mkN "祈使語氣" | mkN "祈使语气" ; -- status=guess -- status=guess
lin imperfect_A = mkA "有瑕疵" ;
lin imperfect_N = mkN "进行时" | mkN "进行时态" ; -- open-multilingual-wordnet
lin imperfection_N = mkN "缺陷" ;
lin imperfective_N = mkN "未完成體" | mkN "未完成体" | {-mwn-} mkN "未完成体动词" ; -- status=guess -- status=guess -- open-multilingual-wordnet
lin imperial_A = mkA "御" | {-HSK-} mkA "龙" ;
lin imperial_N = mkN "龙" "條" | {-mwn-} mkN "马车车顶行李" ; -- open-multilingual-wordnet
lin imperialism_N = mkN "帝国主义" ;
lin imperialist_N = mkN "帝国主义者" ;
lin imperialistic_A = mkA "帝国主义" | mkA "帝国主义者" ; -- open-multilingual-wordnet
lin imperile_V2 = mkV2 "危害" ;
lin imperious_A = mkA "专横" ;
lin impersonation_N = mkN "模仿" "" ;
lin impersonator_N = mkN "冒领" ;
lin impertinent_A = mkA "不慎" | mkA "冒失" | mkA "无礼" | mkA "莽撞" | mkA "过于大胆" | mkA "鲁莽" ; -- open-multilingual-wordnet
lin impervious_A = mkA "不受影响" ;
lin impetiginous_A = mkA "小脓疹" | mkA "脓疱病" ; -- open-multilingual-wordnet
lin impetigo_N = mkN "小脓庖疹" | mkN "脓疱病" ; -- open-multilingual-wordnet
lin impetuous_A = mkA "冲动" ;
lin impetus_N = mkN "刺激" ;
lin impious_A = mkA "不恭" | mkA "不敬" ; -- status=guess -- status=guess
lin impish_A = mkA "恶作剧" | mkA "淘气" | mkA "顽皮" ; -- open-multilingual-wordnet
lin implant_N = mkN "植入" | mkN "植入管" | mkN "移植物" | mkN "深植" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin implant_V2 = mkV2 "灌输" ;
lin implausible_A = mkA "难以置信" ;
lin implement_N = mkN "工具" | {-HSK-} mkN "执行" | {-mwn-} mkN "器具" | mkN "用具" ; -- status=guess -- open-multilingual-wordnet
lin implement_V2 = mkV2 "实施" | {-HSK-} mkV2 "实现" | mkV2 "实行" ;
lin implementation_N = mkN "实现" ;
lin implicate_V2 = mkV2 "牵涉" ;
lin implication_N = mkN "含义" ;
lin implicit_A = mkA "含蓄" | {-HSK-} mkA "阴" ;
lin implore_V2 = mkV2 "恳求" ;
lin implore_VS = mkVS "恳求" ;
lin implosion_N = mkN "內爆" | mkN "内爆" | mkN "爆縮" | mkN "爆缩" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin imply_V = mkV "意味" ;
lin imply_V2 = mkV2 "意味" ;
lin imply_VS = mkVS "暗示" ;
lin impolite_A = mkA "不客气" | {-HSK-} mkA "不禮貌" | mkA "不礼貌" ; -- status=guess -- status=guess
lin imponderable_N = mkN "无法衡量的事物" "件" ;
lin import_N = mkN "进口" ;
lin import_V2 = mkV2 "输入" | mkV2 "进口" ;
lin importance_N = mkN "重要性" ;
lin important_A = L.important_A | {-HSK-} mkA "要" | mkA "重要" ;
lin importerFem_N = mkN "进口商" ;
lin importerMasc_N = mkN "进口商" ;
lin impose_V = mkV "强加" ;
lin impose_V2 = mkV2 "施加" ;
lin imposing_A = mkA "氣勢" | mkA "气势" | {-HSK-} mkA "雄伟" ; -- status=guess -- status=guess
lin imposition_N = mkN "课税" ;
lin impossible_A = mkA "不可能" ;
lin imposter_N = mkN "冒名顶替者" | mkN "骗子" ; -- open-multilingual-wordnet
lin impostor_N = mkN "冒名顶替者" | mkN "骗子" ; -- open-multilingual-wordnet
lin impound_V2 = mkV2 "关在栏中" ;
lin impoverish_V2 = mkV2 "使+贫穷" ;
lin impractical_A = mkA "不切实际" ;
lin impregnability_N = mkN "不会受伤害" | mkN "刀枪不入" ; -- open-multilingual-wordnet
lin impresario_N = mkN "演出經理人" | mkN "演出经理人" ; -- status=guess -- status=guess
lin impress_V = mkV "给人印象" ;
lin impress_V2 = mkV2 "盖印" ;
lin impression_N = mkN "印象" | {-HSK-} mkN "印象" "個" ;
lin impressionable_A = mkA "敏感" | mkA "易感" | mkA "易感动" ; -- open-multilingual-wordnet
lin impressionist_A = mkA "印象主义" ; -- open-multilingual-wordnet
lin impressive_A = mkA "引人注目" ;
lin imprison_V2 = mkV2 "监禁" ;
lin imprisonment_N = mkN "监禁""次" ;
lin improbability_N = mkN "疑惑" ;
lin improbable_A = mkA "不大可能" ;
lin impromptu_A = mkA "即兴" ;
lin improper_A = mkA "不当" ;
lin improve_V = mkV "完善" | mkV "改善" | mkV "改进" | mkV "进步" ;
lin improve_V2 = mkV2 "完善" | mkV2 "改善" | mkV2 "改进" | mkV2 "进步" ;
lin improved_A = variants {} ;
lin improvement_N = mkN "改善" | {-HSK-} mkN "进步" "個" ;
lin improver_N = mkN "增加" | mkN "增加物" | mkN "增加部分" | mkN "添加" | mkN "附加" | mkN "附加物" ; -- open-multilingual-wordnet
lin improvisation_N = mkN "即兴创作" [] ;
lin improvise_V = mkV "即兴发挥" ;
lin impudence_N = mkN "厚脸皮" | mkN "厚颜" | mkN "无耻" ; -- status=guess -- status=guess -- status=guess
lin impudent_A = mkA "厚颜无耻" ;
lin impugn_V2 = mkV2 "抨击" ;
lin impulse_N = mkN "冲动" ;
lin impulsive_A = mkA "冲动" ;
lin impunity_N = mkN "不受惩罚" ;
lin impure_A = mkA "不純" | mkA "不纯" ; -- status=guess -- status=guess
lin impurity_N = mkN "雜質" | mkN "杂质" ; -- status=guess -- status=guess
lin impute_V2 = mkV2 "归咎于" ;
lin in8front_Prep = S.in8front_Prep ;
lin in_1_Adv = mkAdv "在" ;
lin in_2_Adv = mkAdv "在" ;
lin in_A = mkA "其中" | mkA "在" | {-HSK-} mkA "在里面" ;
lin in_Adv = mkAdv "在" ;
lin in_N = mkN "其中" | mkN "在" ;
lin in_Prep = S.in_Prep ;
lin in_accordance_with_Prep = mkPrep "与...一致" ;
lin in_addition_Adv = mkAdv "另外" | mkAdv "外" | mkAdv "并且" | mkAdv "此外" | mkAdv "而且" | mkAdv "还" ;
lin in_addition_to_Prep = mkPrep "除了" ;
lin in_case_of_Prep = mkPrep "万一" ;
lin in_front_of_Prep = mkPrep [] "面前" ;
lin in_general_Adv = mkAdv "一般" ;
lin in_lieu_of_Prep = mkPrep "代替" ;
lin in_place_of_Prep = mkPrep "在" ;
lin in_point_of_Prep = mkPrep "关于" ;
lin in_spite_of_Prep = mkPrep "尽管" ;
lin inability_N = mkN "无力" [] ;
lin inaccessible_A = mkA "人迹罕至" ;
lin inaccuracy_N = mkN "错误" ;
lin inaccurate_A = mkA "不准确" ;
lin inaction_N = mkN "不活动" ;
lin inadequacy_N = mkN "不足" ;
lin inadequate_A = mkA "不足" ;
lin inadvertence_N = mkN "漫不经心" ;
lin inadvertent_A = mkA "疏忽" ;
lin inanimate_A = mkA "不活跃" | mkA "无生命" | mkA "死气沉沉" | mkA "没生命" ; -- open-multilingual-wordnet
lin inapplicability_N = mkN "不适用" ; -- open-multilingual-wordnet
lin inapplicable_A = mkA "不能适用" | mkA "不适合" | mkA "不适用" ; -- open-multilingual-wordnet
lin inappreciable_A = mkA "可忽略不计" | mkA "微不足道" | mkA "微小" ; -- open-multilingual-wordnet
lin inappropriate_A = mkA "不当" ;
lin inasmuch_as_Adv = mkAdv "因为" ;
lin inattention_N = mkN "不留心" ;
lin inaugural_A = mkA "就职典礼" ;
lin inaugurate_V2 = mkV2 "开创" ;
lin inauguration_N = mkN "就职" "" ;
lin inauspicious_A = mkA "不祥" ;
lin inbound_A = mkA "入境" ;
lin inc_PN = foreignPN "Inc" ; -- comment=src=eng status=guess
lin incalculable_A = mkA "无数" ;
lin incantation_N = mkN "咒語" | mkN "咒语" | mkN "咒文" ; -- status=guess -- status=guess -- status=guess
lin incapable_A = mkA "无能力" ;
lin incarcerate_V2 = mkV2 "监禁" ;
lin incarceration_N = mkN "下獄" | mkN "下狱" | mkN "監禁" | mkN "监禁" | mkN "有期徒刑" | {-mwn-} mkN "关押" | mkN "囚禁" | mkN "奴役" | mkN "束缚" ; -- status=guess -- status=guess -- status=guess -- status=guess -- status=guess -- open-multilingual-wordnet
lin incarnate_V2 = mkV2 "体现" ;
lin incendiarism_N = mkN "放火" | mkN "纵火" ; -- open-multilingual-wordnet
lin incendiary_A = mkA "放火" | {-mwn-} mkA "放火" | mkA "纵火" ; -- status=guess -- open-multilingual-wordnet
lin incendiary_N = mkN "燃烧弹" ; -- open-multilingual-wordnet
lin incense_N = mkN "香" ;
lin incentive_N = mkN "激励" ;
lin inception_N = mkN "起初" ;
lin incertitude_N = mkN "不确定" | mkN "怀疑" ; -- open-multilingual-wordnet
lin incessant_A = mkA "不断" ;
lin incest_N = mkN "乱伦" ;
lin incestuous_A = mkA "乱伦" | mkA "血亲相奸" | mkA "近亲相奸" ; -- open-multilingual-wordnet
lin inch_N = mkN "寸" ;
lin inch_V = mkV "寸" ;
lin inchoative_N = mkN "表始动词" ; -- open-multilingual-wordnet
lin inchon_PN = foreignPN "Inchon" ; -- comment=src=eng status=guess
lin incidence_N = mkN "发生率" ;
lin incident_N = mkN "事件" ;
lin incidental_A = mkA "附带" ;
lin incineration_N = mkN "焚化" "场" ;
lin incinerator_N = mkN "焚烧炉" ;
lin incision_N = mkN "切口" "道" ;
lin incisor_N = mkN "門牙" | mkN "门牙" | mkN "門齒" | mkN "门齿" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin incisure_N = mkN "切迹" ; -- open-multilingual-wordnet
lin incite_V2 = mkV2 "煽动" ;
lin incl_PN = foreignPN "Incl" ; -- comment=src=eng status=guess
lin inclination_N = mkN "倾角" ;
lin incline_V = mkV "低" | {-HSK-} mkV "倾斜" ;
lin incline_V2 = mkV2 "低" | {-HSK-} mkV2 "倾斜" ;
lin incline_V2V = mkV2V "低" | {-HSK-} mkV2V "倾斜" ;
lin inclined_A = {-HSK-} mkA "斜" ;
lin include_V = mkV "包" | mkV "包含" | mkV "包括" ;
lin include_V2 = mkV2 "包" | mkV2 "包含" | mkV2 "包括" ;
lin including_N = mkN "连" ;
lin including_Prep = variants {} ;
lin inclusion_N = mkN "包容" ;
lin incognito_Adv = mkAdv "匿名+地" | mkAdv "用假名+地" | mkAdv "隐姓埋名+地" ; -- open-multilingual-wordnet
lin incoherent_A = mkA "语无伦次" ;
lin income_N = mkN "收入" | {-HSK-} mkN "收入" "筆" ;
lin incoming_A = mkA "引入" ;
lin incommutable_A = mkA "不能交换" | mkA "不能变换" ; -- open-multilingual-wordnet
lin incompatibility_N = mkN "不相容" ;
lin incompatible_A = mkA "不兼容" ;
lin incompetence_N = mkN "无资格" ;
lin incompetency_N = mkN "不称职" ;
lin incompetent_A = mkA "无能力" ; -- comment="不胜任" ;
lin incomplete_A = mkA "半" | mkA "片" | {-HSK-} mkA "残缺" ;
lin incompleteness_N = mkN "不完全" ; -- open-multilingual-wordnet
lin incomprehensible_A = mkA "難以理解" | mkA "难以理解" | mkA "費解" | mkA "费解" ; -- status=guess -- status=guess -- status=guess -- status=guess
lin inconceivability_N = mkN "不可思议" ; -- open-multilingual-wordnet
lin inconceivable_A = mkA "不可思议" ;
lin inconclusive_A = mkA "尚无定论" ;
lin incongruity_N = mkN "不协调" ;
lin incongruous_A = mkA "不一致" | mkA "不协调" ; -- open-multilingual-wordnet
lin inconsiderable_A = mkA "不足取" ;
lin inconsiderate_A = mkA "不體貼" | mkA "不体贴" ; -- status=guess -- status=guess
lin inconsistency_N = mkN "不一致" ;
lin inconsistent_A = mkA "不符" ;
lin incontinence_N = mkN "失禁" ; -- status=guess
lin inconvenience_N = mkN "不方便" ;
l