-- Modified by Daniel Vidal Hussey (DVH)

concrete DictionaryCat of Dictionary = CatCat
    ** open ParadigmsCat, MorphoCat, IrregCat, (L=LexiconCat), (S=StructuralCat), (E = ExtraCat), Prelude, BeschCat in {

flags
  coding=utf8 ;

oper  mkInterj : Str -> Interj
    = \s -> lin Interj (ss s) ;
oper  mkDet : Str -> Det = \s -> lin Det {s,sp
    = \\_,c => prepCase c ++ s ; n = Sg ; s2 = [] ; isNeg = False} ;
oper mkSubj : Str -> Mood -> Subj = \s,md -> ss s ** {m = md ; lock_Subj = <>} ;
oper mkConj : Str -> Conj
    = \s -> lin Conj {s1 = [] ; s2 = s ; n = Pl} ;
oper optProDrop : Pron -> Pron = \p -> p | E.ProDrop p ;

oper prepV2 : V -> Prep -> V2 = \v,p -> mkV2 v p ;
oper advV : V -> Adv -> V = \v,a -> mkV v a.s ;

lin a_posteriori_A = mkA "a posteriori" ; --auto
lin a_priori_Adv = mkAdv "a priori" ; --auto
lin abaca_N = mkN "abacà" masculine ; --auto
lin abacus_N = mkN "àbac" masculine ; --auto
lin abampere_N = mkN "abampere" masculine ; --auto
lin abandon_V2 = mkV2 "abandonar" ; --auto
lin abandonment_N = mkN "abandonament" masculine | mkN "abandó" masculine ; --auto
lin abate_V = mkV "calmar" ; --auto
lin abate_V2 = mkV2 "calmar" ; --auto
lin abatement_N = mkN "reducció" feminine ; --auto
lin abbey_N = mkN "abadia" feminine ; --auto
lin abbot_N = mkN "abat" masculine ; --auto
lin abbreviate_V2 = mkV2 "abreujar" ; --auto
lin abbreviation_N = mkN "abreviatura" feminine ; --auto
lin abdicate_V = mkV "abdicar" ; --auto
lin abdicate_V2 = mkV2 "abdicar" ; --auto
lin abdication_N = mkN "abdicació" feminine ; --auto
lin abdomen_N = mkN "abdomen" masculine | mkN "ventre" masculine ; --auto
lin abdominal_A = mkA "abdominal" ; --auto
lin abduct_V2 = mkV2 "segrestar" ; --auto
lin abduction_N = mkN "abducció" feminine ; --auto
lin aberrant_A = mkA "aberrant" ; --auto
lin aberration_N = mkN "aberració" feminine ; --auto
lin abet_V = mkV "instigar" ; --auto
lin abet_V2 = mkV2 "instigar" ; --auto
lin abhor_V2 = mkV2 "avorrir" ; --auto
lin abide_V = mkV "suportar" ; --auto
lin abide_V2 = mkV2 "suportar" ; --auto
lin ability_N = mkN "habilitat" feminine ; --split "capacitat" fem (skill vs. iherent ability to do something)
lin abiogenesis_N = mkN "abiogènesi" feminine ; --auto
lin abject_A = mkA "abjecte" ; --auto
lin abjuration_N = mkN "abjuració" feminine ; --auto
lin abjure_V2 = mkV2 "abjurar" ; --auto
lin ablation_N = mkN "ablació" feminine ; --auto
lin ablative_N = mkN "ablatiu" masculine ; --auto
lin able_A = mkA "capaç" ;
lin ablution_N = mkN "ablució" feminine ; --auto
lin abnegation_N = mkN "abnegació" feminine ; --auto
lin abnormal_A = mkA "anormal" ; --auto
lin abnormality_N = mkN "anormalitat" feminine ; --auto
lin aboard_Adv = mkAdv "a bord" ; --auto
lin abode_N = mkN "domicili" masculine ; --auto
lin abolish_V2 = mkV2 "abolir" ; --auto
lin abolition_N = mkN "abolició" feminine ; --auto
lin abolitionism_N = mkN "abolicionisme" masculine ; --auto
lin abolitionist_N = mkN "abolicionista" ; --auto
lin abominable_A = mkA "abominable" ; --auto
lin abomination_N = mkN "abominació" feminine ; --auto
lin aboriginal_A = mkA "aborigen" ; --auto
lin aborigine_N = mkN "aborigen" ; --auto
lin abort_V = mkV "avortar" ; --auto
lin abort_V2 = mkV2 "avortar" ; --auto
lin abortion_N = mkN "avortament" masculine ; --auto
lin abortionistFem_N = variants {} ; ---- sense to be split
lin abortionistMasc_N = variants {} ; ---- sense to be split
lin abortive_A = mkA "malmès" ; --auto
lin abound_V = mkV "abundar" ; --auto
lin about_AdN = mkAdv "aproximadament" ; --auto
lin about_Adv = mkAdv "aproximadament" ;
lin about_Prep = mkPrep "sobre" ;
lin above_Adv = mkAdv "per sobre" | mkAdv "dalt" | mkAdv "damunt" ; --auto
lin above_Prep = S.above_Prep ;
lin above_board_Adv = mkAdv "honestament" ; --auto
lin abrasion_N = mkN "abrasió" feminine ; --auto
lin abrasive_A = mkA "abrasiu" ; --auto
lin abrasive_N = mkN "abrasiu" masculine ; --auto
lin abreast_Adv = mkAdv "de costat" ; --auto
lin abroad_Adv = mkAdv "a l'estranger" ; --auto
lin abrogation_N = mkN "abrogació" feminine ; --auto
lin abrupt_A = mkA "sobtat" ; --auto
lin abruptness_N = mkN "brusquedat" feminine ; --auto
lin abscissa_N = mkN "abscissa" feminine ; --auto
lin absence_N = mkN "absència" feminine ; --auto
lin absent_A = mkA "absent" ; --auto
lin absenteeism_N = mkN "absentisme" masculine ; --auto
lin absolute_A = mkA "absolut" ; --auto
lin absolution_N = mkN "absolució" feminine ; --auto
lin absolutism_N = mkN "absolutisme" masculine ; --auto
lin absolve_V2 = mkV2 "absoldre" ; --auto
lin absorb_V2 = mkV2 "absorbir" ; --auto
lin absorbent_A = mkA "absorbent" ; --auto
lin absorbent_N = mkN "absorbent" masculine ; --auto
lin absorber_N = mkN "absorbidor" masculine ; --auto
lin absorption_N = mkN "absorbiment" masculine | mkN "absorció" feminine ; --auto
lin absorptivity_N = mkN "absortivitat" feminine ; --auto
lin abstain_V = mkV "abstenir" ; --auto
lin abstemious_A = mkA "abstemi" ; --auto
lin abstemiousness_N = mkN "sobrietat" feminine ; --auto
lin abstention_N = mkN "abstenció" feminine ; --auto
lin abstinence_N = mkN "abstinència" feminine ; --auto
lin abstract_A = mkA "abstracte" ; --auto
lin abstraction_N = mkN "abstracció" feminine ; --auto
lin abstractionism_N = mkN "abstraccionisme" masculine ; --auto
lin absurd_A = mkA "absurd" ; --auto
lin absurdity_N = mkN "absurditat" feminine ; --auto
lin abulia_N = mkN "abúlia" feminine ; --auto
lin abundance_N = mkN "abundància" feminine ; --auto
lin abundant_A = mkA "abundant" | mkA "abundós" ; --auto
lin abuse_N = mkN "abús" masculine ; --auto
lin abusive_A = mkA "injuriós" ; --auto
lin abvolt_N = mkN "abvolt" masculine ; --auto
lin abysmal_A = mkA "abismal" ; --auto
lin abyss_N = mkN "abisme" masculine ; --auto
lin abyssal_A = mkA "abissal" ; --auto
lin academic_A = mkA "acadèmic" ; --auto
lin academicianFem_N = variants {} ; ---- sense to be split
lin academicianMasc_N = variants {} ; ---- sense to be split
lin academy_N = mkN "acadèmia" feminine ; --auto
lin acanthocyte_N = mkN "acantòcit" masculine ; --auto
lin acanthocytosis_N = mkN "acantocitosi" feminine ; --auto
lin acanthosis_N = mkN "acantosi" feminine ; --auto
lin acanthus_N = mkN "acant" masculine ; --auto
lin acaricide_N = mkN "acaricida" feminine ; --auto
lin acarus_N = mkN "àcar" masculine ; --auto
lin accelerate_V = mkV "accelerar" ; --auto
lin accelerate_V2 = mkV2 "accelerar" ; --auto
lin acceleration_N = mkN "acceleració" feminine ; --auto
lin accelerator_N = mkN "accelerador" masculine ; --auto
lin accelerometer_N = mkN "acceleròmetre" masculine ; --auto
lin accent_N = mkN "accent" masculine ; --auto
lin accentual_A = mkA "accentual" ; --auto
lin accentuation_N = mkN "accentuació" feminine ; --auto
lin accept_V = mkV "acceptar" ;
lin accept_V2 = mkV2 (mkV "acceptar") ;
lin accept_VS = mkVS (mkV "acceptar") ;
lin acceptable_A = mkA "acceptable" ; --auto
lin acceptance_N = mkN "acceptació" feminine ; --auto
lin acceptor_N = mkN "acceptor" masculine ; --auto
lin access_N = mkN "accés" masculine ;
lin access_V2 = mkV2 "accedir" ; --auto
lin accessibility_N = mkN "accessibilitat" feminine ; --auto
lin accessible_A = mkA "accessible" ; --auto
lin accession_N = mkN "accessió" feminine ; --auto
lin accident_N = mkN "accident" masculine ;
lin accidental_A = mkA "accidental" ; --auto
lin acclaim_V2 = mkV2 "aclamar" ; --auto
lin acclamation_N = mkN "aclamació" feminine ; --auto
lin acclimate_V = mkV "aclimatar" ; --auto
lin acclimate_V2 = mkV2 "aclimatar" ; --auto
lin accommodate_V = mkV "acomodar" ; --auto
lin accommodate_V2 = mkV2 "acomodar" ; --auto
lin accommodation_N = mkN "allotjament" masculine | mkN "hostatge" masculine ; --auto
lin accompaniment_N = mkN "acompanyament" masculine ; --auto
lin accompany_V2 = mkV2 "acompanyar" ; --auto
lin accomplish_V2 = mkV2 "acomplir" ; --auto
lin accord_N = mkN "acord" masculine ; --auto
lin according_to_Prep = mkPrep "segons" ;
lin accordingly_Adv = mkAdv "consegüentment" ; --auto
lin accordion_N = mkN "acordió" masculine ; --auto
lin account_N = mkN "compte" masculine ;
lin account_for_V2 = prepV2 OP_account_V OP_for_Prep ; -- guess-p-verb
lin accountancy_N = mkN "comptabilitat" feminine ; --auto
lin accountant_N = mkN "comptable" ; --auto
lin accounting_N = mkN "comptabilitat" feminine ; --auto
lin accredit_V2 = mkV2 "acreditar" ; --auto
lin accretion_N = mkN "acreció" feminine ; --auto
lin acculturation_N = mkN "aculturació" feminine ; --auto
lin accumulate_V = mkV "acumular" ; --auto
lin accumulate_V2 = mkV2 "acumular" ; --auto
lin accumulation_N = mkN "acumulació" feminine ; --auto
lin accumulator_N = mkN "acumulador" masculine ; --auto
lin accuracy_N = mkN "precisió" feminine ; --auto
lin accurate_A = mkA "acurat" ; --auto
lin accuse_V2 = mkV2 "acusar" ; --auto
lin accused_N = mkN "acusat" feminine | mkN "acusat" | mkN "acusat" masculine ; --auto
lin accuserFem_N = variants {} ; ---- sense to be split
lin accuserMasc_N = variants {} ; ---- sense to be split
lin accustom_V2 = mkV2 "acostumar" ; --auto
lin ace_N = mkN "as" masculine ; --auto
lin acephalia_N = mkN "acefàlia" feminine ; --auto
lin acephalous_A = mkA "acèfal" ; --auto
lin acetabulum_N = mkN "acetàbul" masculine ; --auto
lin acetal_N = mkN "acetal" masculine ; --auto
lin acetate_N = mkN "acetat" masculine ; --auto
lin acetic_A = mkA "acètic" ; --auto
lin acetone_N = mkN "acetona" feminine ; --auto
lin acetylcholine_N = mkN "acetilcolina" feminine ; --auto
lin achievable_A = mkA "realitzable" ; --auto
lin achieve_V2 = mkV2 (mkV (servir_101 "aconseguir")) ;
lin achievement_N = mkN "consecució" feminine ; --auto
lin achromatic_A = mkA "acromàtic" ; --auto
lin acid_N = mkN "àcid" masculine ; --auto
lin acidic_A = mkA "acídic" ; --auto
lin acidification_N = mkN "acidificació" feminine ; --auto
lin acidify_V = mkV "acidificar" ; --auto
lin acidify_V2 = mkV2 "acidificar" ; --auto
lin acidimetry_N = mkN "acidimetria" feminine ; --auto
lin acidity_N = mkN "acidesa" feminine ; --auto
lin acidosis_N = mkN "acidosi" feminine ; --auto
lin acknowledge_V2 = mkV2 "reconèixer" ; --auto
lin acme_N = mkN "acme" masculine ; --auto
lin acne_N = mkN "acne" masculine ; --auto
lin aconite_N = mkN "acònit" masculine ; --auto
lin acorn_N = mkN "gla" feminine ; --auto
lin acoustic_A = mkA "acústic" ; --auto
lin acoustics_N = mkN "acústica" feminine ; --auto
lin acquire_V2 = mkV2 "adquirir" ; --auto
lin acquisition_N = mkN "adquisició" feminine ; --auto
lin acquisitive_A = mkA "cobdiciós" ; --auto
lin acre_N = mkN "acre" masculine ; --auto
lin acrobatFem_N = variants {} ; ---- sense to be split
lin acrobatMasc_N = variants {} ; ---- sense to be split
lin acrobatics_N = mkN "acrobàcia" feminine ; --auto
lin acromegaly_N = mkN "acromegàlia" feminine ; --auto
lin acromion_N = mkN "acromi" masculine ; --auto
lin acronym_N = mkN "acrònim" masculine ; --auto
lin acrosome_N = mkN "acrosoma" masculine ; --auto
lin across_Prep = mkPrep "a través de" ;
lin acrylic_N = mkN "acrílic" feminine | mkN "acrílic" masculine ; --auto
lin act_N = mkN "acte" masculine ;
lin act_V = mkV "actuar" ;
lin act_V2 = mkV2 (mkV "actuar") ;
lin act_on_V2 = prepV2 OP_act_V OP_on_Prep ; -- guess-p-verb
lin act_out_V2 = prepV2 OP_act_V OP_out_Prep ; -- guess-p-verb
lin act_up_V = advV OP_act_V OP_up_Adv ; -- guess-p-verb
lin act_upon_V2 = prepV2 OP_act_V OP_upon_Prep ; -- guess-p-verb
lin actin_N = mkN "actina" feminine ; --auto
lin acting_A = mkA "suplent" ; --auto
lin actinium_N = mkN "actini" masculine ; --auto
lin actinolite_N = mkN "actinolita" feminine ; --auto
lin actinometer_N = mkN "actinòmetre" masculine ; --auto
lin actinometry_N = mkN "actinometria" feminine ; --auto
lin action_N = mkN "acció" masculine ;
lin activator_N = mkN "activador" feminine | mkN "activador" masculine ; --auto
lin active_A = mkA "actiu" ;
lin activism_N = mkN "activisme" masculine ; --auto
lin activistFem_N = variants {} ; ---- sense to be split
lin activistMasc_N = variants {} ; ---- sense to be split
lin activity_N = mkN "activitat" feminine ;
lin actomyosin_N = mkN "actomiosina" feminine ; --auto
lin actor_1_N = variants {} ; ---- sense to be split
lin actor_2_N = variants {} ; ---- sense to be split
lin actress_N = mkN "actriu" feminine ; --auto
lin actual_A = mkA "actual" ;
lin actuality_N = mkN "actualitat" feminine ; --auto
lin actually_Adv = mkAdv "de fet" ;
lin actuarial_A = mkA "actuarial" ; --auto
lin actuary_N = mkN "actuari" feminine | mkN "actuari" masculine ; --auto
lin actuate_V2 = mkV2 "activar" ; --auto
lin actuator_N = mkN "accionador" masculine | mkN "actuador" masculine ; --auto
lin acuity_N = mkN "acuïtat" feminine ; --auto
lin acupuncture_N = mkN "acupuntura" feminine ; --auto
lin acute_A = mkA "agut" ; --auto
lin acyclic_A = mkA "acíclic" ; --auto
lin ad_N = mkN "anunci" masculine ; --auto
lin ad_hoc_A = mkA "ad hoc" ; --auto
lin ad_infinitum_Adv = mkAdv "ad infinitum" ; --auto
lin ad_nauseam_Adv = mkAdv "ad nauseam" ; --auto
lin adage_N = mkN "adagi" masculine ; --auto
lin adapt_V = mkV "adaptar" ; --auto
lin adapt_V2 = mkV2 "adaptar" ; --auto
lin adaptability_N = mkN "adaptabilitat" feminine ; --auto
lin adaptable_A = mkA "adaptable" ; --auto
lin adaptation_N = mkN "adaptació" feminine ; --auto
lin adapter_N = mkN "adaptador" masculine ; --auto
lin add_V = mkV "afegir" ;
lin add_V2 = mkV2 (mkV "afegir") ;
lin add_VS = mkVS (mkV "afegir") ;
lin add_in_V = advV OP_add_V OP_in_Adv ; -- guess-p-verb
lin add_on_to_V2 = prepV2 OP_add_V OP_on_Prep ; -- guess-p-verb
lin add_up_V = advV OP_add_V OP_up_Adv ; -- guess-p-verb
lin add_up_V2 = prepV2 OP_add_V OP_up_Prep ; -- guess-p-verb
lin add_up_to_V2 = prepV2 (advV OP_add_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin addend_N = mkN "sumand" masculine ; --auto
lin addendum_N = mkN "addenda" feminine ; --auto
lin adder_N = mkN "sumador" masculine ; --auto
lin addict_N = mkN "addicte" | mkN "addicte" feminine | mkN "addicte" | mkN "addicte" masculine ; --auto
lin addiction_N = mkN "addicció" feminine ; --auto
lin addition_N = mkN "suma" feminine ;
lin additional_A = mkA "addicional" ;
lin additionally_Adv = mkAdv "a més" ; --auto
lin additive_A = mkA "additiu" ; --auto
lin additive_N = mkN "additiu" masculine ; --auto
lin address_N = mkN "adreça" feminine ; --auto
lin address_V2 = mkV2 "abordar" | mkV2 "adreçar" ; --auto
lin addressable_A = mkA "adreçable" ; --auto
lin addressee_N = mkN "destinatari" | mkN "destinatari" ; --auto
lin adduce_V2 = mkV2 "adduir" ; --auto
lin adenine_N = mkN "adenina" feminine ; --auto
lin adenoidectomy_N = mkN "adenoïdectomia" feminine ; --auto
lin adenoma_N = mkN "adenoma" masculine ; --auto
lin adenopathy_N = mkN "adenopatia" feminine ; --auto
lin adenosine_N = mkN "adenosina" feminine ; --auto
lin adequate_A = mkA "adequat" ; --auto
lin adherent_N = mkN "partidari" | mkN "partidari" ; --auto
lin adhesion_N = mkN "adhesió" feminine ; --auto
lin adhesive_A = mkA "adhesiu" ; --auto
lin adhocracy_N = mkN "adhocràcia" feminine ; --auto
lin adiabatic_A = mkA "adiabàtic" ; --auto
lin adipose_A = mkA "adipós" ; --auto
lin adjacent_A = mkA "adjacent" ; --auto
lin adjectival_A = mkA "adjectival" ; --auto
lin adjective_N = mkN "adjectiu" masculine ; --auto
lin adjudication_N = mkN "adjudicació" feminine ; --auto
lin adjudicator_N = mkN "adjudicatari" feminine | mkN "adjudicatari" masculine ; --auto
lin adjust_V = mkV "ajustar" ; --auto
lin adjust_V2 = mkV2 "ajustar" ; --auto
lin adjustment_N = mkN "ajustament" masculine | mkN "ajustatge" masculine | mkN "graduació" feminine ; --auto
lin administer_V = mkV "administrar" ; --auto
lin administer_V2 = mkV2 "administrar" ; --auto
lin administration_N = mkN "administració" ;
lin administrative_A = mkA "administratiu" ; --auto
lin administratorFem_N = variants {} ; ---- sense to be split
lin administratorMasc_N = variants {} ; ---- sense to be split
lin admirable_A = mkA "admirable" ; --auto
lin admiral_N = mkN "almirall" ; --auto
lin admiralty_N = mkN "almirallat" masculine ; --auto
lin admiration_N = mkN "admiració" feminine ; --auto
lin admire_V2 = mkV2 "admirar" ; --auto
lin admissibility_N = mkN "admissibilitat" feminine ; --auto
lin admissible_A = mkA "admissible" ; --auto
lin admit_V = mkV (admetre_2 "admetre") ;
lin admit_V2 = mkV2 (mkV (admetre_2 "admetre")) ;
lin admit_VS = mkVS (mkV (admetre_2 "admetre")) ;
lin admittedly_Adv = mkAdv "certament" ; --auto
lin admonish_V2 = mkV2 "amonestar" ; --auto
lin admonitory_A = mkA "admonitori" ; --auto
lin adolescence_N = mkN "adolescència" feminine ; --auto
lin adopt_V2 = mkV2 (mkV "adoptar") ;
lin adoption_N = mkN "adopció" feminine ; --auto
lin adoptive_A = mkA "adoptiu" ; --auto
lin adoration_N = mkN "adoració" feminine ; --auto
lin adore_V2 = mkV2 "adorar" ; --auto
lin adorn_V2 = mkV2 "adornar" ; --auto
lin adsorbate_N = mkN "adsorbat" masculine ; --auto
lin adsorbent_N = mkN "adsorbent" masculine ; --auto
lin adsorption_N = mkN "adsorció" feminine ; --auto
lin adulation_N = mkN "adulació" feminine ; --auto
lin adult_N = mkN "adult" masculine ;
lin adulterate_V2 = mkV2 "adulterar" ; --auto
lin adulteration_N = mkN "adulteració" feminine ; --auto
lin adulterer_N = mkN "adúlter" | mkN "adúlter" ; --auto
lin adulterous_A = mkA "adulterí" ; --auto
lin adultery_N = mkN "adulteri" masculine ; --auto
lin adulthood_N = mkN "adultesa" feminine ; --auto
lin advance_N = mkN "avançament" masculine | mkN "avenç" masculine ; --auto
lin advance_V = mkV "avançar" ; --auto
lin advance_V2 = mkV2 "avançar" ; --auto
lin advancement_N = mkN "avenç" masculine ; --auto
lin advantage_N = mkN "avantatge" masculine ;
lin advantageous_A = mkA "avantatjós" ; --auto
lin advection_N = mkN "advecció" feminine ; --auto
lin adventistFem_N = variants {} ; ---- sense to be split
lin adventistMasc_N = variants {} ; ---- sense to be split
lin adventitious_A = mkA "adventici" ; --auto
lin adventure_N = mkN "aventura" feminine ; --auto
lin adventurer_N = mkN "aventurer" | mkN "aventurer" ; --auto
lin adventurous_A = mkA "aventurer" ; --auto
lin adverb_N = mkN "adverbi" masculine ; --auto
lin adverbial_A = mkA "adverbial" ; --auto
lin adverse_A = mkA "advers" ; --auto
lin adversity_N = mkN "adversitat" feminine ; --auto
lin advert_N = mkN "anunci" masculine ; --auto
lin advertise_V = mkV "anunciar" ; --auto
lin advertise_V2 = mkV2 "anunciar" ; --auto
lin advertisement_N = mkN "anunci" masculine ; --auto
lin advertising_N = mkN "publicitat" feminine ; --auto
lin advice_N = mkN "consell" masculine ;
lin advisable_A = mkA "aconsellable" ; --auto
lin advise_V = mkV "aconsellar" ; --auto
lin advise_V2 = mkV2 "aconsellar" ; --auto
lin adviserFem_N = variants {} ; ---- sense to be split
lin adviserMasc_N = variants {} ; ---- sense to be split
lin advisory_A = mkA "aconsellable" ; --auto
lin advocateFem_N = variants {} ; ---- sense to be split
lin advocateMasc_N = variants {} ; ---- sense to be split
lin advocate_V2 = mkV2 "advocar" | mkV2 "defensar" ; --auto
lin adze_N = mkN "aixol" masculine ; --auto
lin aerator_N = mkN "airejador" masculine ; --auto
lin aerial_A = mkA "aeri" ; --auto
lin aerobic_A = mkA "aeròbic" ; --auto
lin aerobiosis_N = mkN "aerobiosi" feminine ; --auto
lin aerodynamic_A = mkA "aerodinàmic" ; --auto
lin aerodynamics_N = mkN "aerodinàmica" feminine ; --auto
lin aerology_N = mkN "aerologia" feminine ; --auto
lin aeronautical_A = mkA "aeronàutic" ; --auto
lin aeronautics_N = mkN "aeronàutica" feminine ; --auto
lin aeroplane_N = mkN "avió" masculine ; --auto
lin aerosol_N = mkN "aerosol" masculine ; --auto
lin aerospace_A = mkA "aeroespacial" ; --auto
lin aestheteFem_N = variants {} ; ---- sense to be split
lin aestheteMasc_N = variants {} ; ---- sense to be split
lin aesthetic_A = mkA "estètic" ; --auto
lin aesthetics_N = mkN "estètica" feminine ; --auto
lin affair_N = mkN "assumpte" masculine | mkN "afer" masculine ; --split "aventura" fem (topic vs. romantic affiar)
lin affect_V2 = mkV2 (mkV "afectar") ;
lin affection_N = mkN "afecte" masculine ; --auto
lin affidavit_N = mkN "afidàvit" masculine ; --auto
lin affiliate_V = mkV "afiliar" ; --auto
lin affiliate_V2 = mkV2 "afiliar" ; --auto
lin affine_A = mkA "afí" ; --auto
lin affinity_N = mkN "afinitat" feminine ; --auto
lin affirm_V = mkV "afirmar" ; --auto
lin affirm_V2 = mkV2 "afirmar" ; --auto
lin affirmation_N = mkN "afirmació" feminine ; --auto
lin affirmative_A = mkA "afirmatiu" ; --auto
lin affix_N = mkN "afix" masculine ; --auto
lin affix_V2 = mkV2 "afixar" ; --auto
lin affixation_N = mkN "afixació" feminine ; --auto
lin afflict_V2 = mkV2 "afligir" ; --auto
lin affliction_N = mkN "aflicció" feminine ; --auto
lin affluent_A = mkA "opulent" ; --auto
lin affordable_A = mkA "assequible" ; --auto
lin afforestation_N = mkN "aforestació" feminine ; --auto
lin affrication_N = mkN "africació" feminine ; --auto
lin afghanFem_N = variants {} ; ---- sense to be split
lin afghanMasc_N = variants {} ; ---- sense to be split
lin afghan_A = mkA "afganès" ; --auto
lin afghanistaniFem_N = variants {} ; ---- sense to be split
lin afghanistaniMasc_N = variants {} ; ---- sense to be split
lin afraid_A = mkA "temorós" ; --auto
lin africanFem_N = variants {} ; ---- sense to be split
lin africanMasc_N = variants {} ; ---- sense to be split
lin african_A = mkA "africà" ; --auto
lin afrikanerFem_N = variants {} ; ---- sense to be split
lin afrikanerMasc_N = variants {} ; ---- sense to be split
lin afro_americanFem_N = variants {} ; ---- sense to be split
lin afro_americanMasc_N = variants {} ; ---- sense to be split
lin aft_Adv = mkAdv "a popa" ; --auto
lin after_Adv = mkAdv "després" ; --auto
lin after_Prep = S.after_Prep ;
lin after_Subj = mkSubj "després que" Indic ;
lin afterbirth_N = mkN "secundina" feminine ; --auto
lin afternoon_N = mkN "tarda" feminine ;
lin aftertaste_N = mkN "regust" masculine ; --auto
lin afterwards_Adv = mkAdv "després" ; --auto
lin again_Adv = mkAdv "un altre cop" ; -- should be "tornar a X"
lin against_Prep = mkPrep "en contra de" ; --split mkPrep "a" ("lean against the wall")
lin agate_N = mkN "àgata" feminine ; --auto
lin age_N = mkN "edat" feminine ;
lin age_V = mkV "envellir" ; --auto
lin agency_N = mkN "agència" feminine ;
lin agenda_N = mkN "ordre del dia" masculine ; --auto
lin agentFem_N = variants {} ; ---- sense to be split
lin agentMasc_N = variants {} ; ---- sense to be split
lin agglutinate_V2 = mkV2 "aglutinar" ; --auto
lin agglutination_N = mkN "aglutinació" feminine ; --auto
lin agglutinative_A = mkA "aglutinant" | mkA "aglutinatiu" ; --auto
lin aggravate_V2 = mkV2 "agreujar" ; --auto
lin aggravating_A = mkA "agreujant" ; --auto
lin aggravation_N = mkN "agreujament" masculine ; --auto
lin aggregate_N = mkN "àrid" masculine ; --auto
lin aggregate_V = mkV "agregar" ; --auto
lin aggregate_V2 = mkV2 "agregar" ; --auto
lin aggregation_N = mkN "agregació" feminine ; --auto
lin aggressive_A = mkA "agressiu" ; --auto
lin aggressiveness_N = mkN "agressivitat" feminine ; --auto
lin aggressorFem_N = variants {} ; ---- sense to be split
lin aggressorMasc_N = variants {} ; ---- sense to be split
lin agile_A = mkA "àgil" ; --auto
lin aging_N = mkN "envelliment" masculine ; --auto
lin agitate_V = mkV "agitar" ; --auto
lin agitate_V2 = mkV2 "agitar" ; --auto
lin agitation_N = mkN "agitació" feminine ; --auto
lin agnail_N = mkN "repeló" masculine ; --auto
lin agnosia_N = mkN "agnòsia" feminine ; --auto
lin agnostic_A = mkA "agnòstic" ; --auto
lin agnostic_N = mkN "agnòstic" | mkN "agnòstic" ; --auto
lin agnosticism_N = mkN "agnosticisme" masculine ; --auto
lin ago_Adv = mkAdv "fa" ; --auto
lin agony_N = mkN "agonia" feminine ; --auto
lin agora_N = mkN "àgora" feminine ; --auto
lin agoraphobia_N = mkN "agorafòbia" feminine ; --auto
lin agraphia_N = mkN "agrafia" feminine ; --auto
lin agrarian_A = mkA "agrari" ; --auto
lin agree_V = mkV "acordar" | mkV "concordar" | mkV "estar d'acord" ; --auto
lin agree_VS = mkVS (mkV "acordar") ;
lin agree_VV = mkVV (mkV "acordar") ;
lin agree_on_V = advV OP_agree_V OP_on_Adv ; -- guess-p-verb
lin agree_with_V2 = prepV2 OP_agree_V OP_with_Prep ; -- guess-p-verb
lin agreeable_A = mkA "agradable" ; --auto
lin agreed_A = mkA "acordat" ; --auto
lin agreement_N = mkN "acord" masculine ;
lin agricultural_A = mkA "agrícola" ; --auto
lin agriculture_N = mkN "agricultura" feminine ; --auto
lin agrobiology_N = mkN "agrobiologia" feminine ; --auto
lin agrology_N = mkN "agrologia" feminine ; --auto
lin agronomic_A = mkA "agronòmic" ; --auto
lin agronomist_N = mkN "agrònom" | mkN "agrònom" ; --auto
lin agronomy_N = mkN "agronomia" feminine ; --auto
lin ahead_Adv = mkAdv "per davant" ;
lin ahead_of_Prep = mkPrep "al capdavant de" ; --auto
lin aid_N = mkN "ajuda" feminine ;
lin aide_N = mkN "assessor" masculine ; --auto
lin aileron_N = mkN "aleró" masculine ; --auto
lin ailment_N = mkN "dolència" feminine ; --auto
lin aim_N = mkN "objectiu" ;
lin aim_V = mkV "apuntar" ;
lin aim_V2 = mkV2 (mkV "apuntar") ;
lin aim_VV = mkVV (mkV (atendre_8 "pretendre")) ;
lin aim_at_V2 = prepV2 OP_aim_V OP_at_Prep ; -- guess-p-verb
lin air_N = mkN "aire" masculine ;
lin airbus_N = mkN "aerobús" masculine ; --auto
lin aircraft_N = mkN "aeronau" feminine ; --auto
lin airfield_N = mkN "aeròdrom" masculine ; --auto
lin airline_N = mkN "línia aèria" feminine ; --auto
lin airliner_N = mkN "avió" masculine ; --auto
lin airplane_N = mkN "avió" masculine ; --auto
lin airport_N = mkN "aeroport" masculine ;
lin airship_N = mkN "dirigible" masculine ; --auto
lin akin_A = mkA "semblant" ; --auto
lin alabaster_N = mkN "alabastre" masculine ; --auto
lin alarm_N = mkN "alarma" feminine | mkN "alerta" feminine ; --auto
lin alarm_V2 = mkV2 "alarmar" ; --auto
lin alarming_A = mkA "alarmant" ; --auto
lin alarmism_N = mkN "alarmisme" masculine ; --auto
lin albanian_A = mkA "albanès" ; --auto
lin albanian_N = mkN "albanès" | mkN "albanès" ; --auto
lin albatross_N = mkN "albatros" masculine | mkN "albatros" masculine ; --auto
lin albedo_N = mkN "albedo" masculine ; --auto
lin albino_N = mkN "albí" | mkN "albí" ; --auto
lin albite_N = mkN "albita" feminine ; --auto
lin album_N = mkN "àlbum" masculine ; --auto
lin albumin_N = mkN "albúmina" feminine ; --auto
lin alchemic_A = mkA "alquímic" ; --auto
lin alchemist_N = mkN "alquimista" ; --auto
lin alchemy_N = mkN "alquímia" feminine ; --auto
lin alcohol_N = mkN "alcohol" masculine ; --auto
lin alcoholic_A = mkA "alcohòlic" ; --auto
lin alcoholic_N = mkN "alcohòlic" feminine | mkN "alcohòlic" masculine ; --auto
lin alcoholism_N = mkN "alcoholisme" masculine ; --auto
lin alcove_N = mkN "alcova" feminine ; --auto
lin aldehyde_N = mkN "aldehid" masculine ; --auto
lin aldose_N = mkN "aldosa" feminine ; --auto
lin alert_N = mkN "alerta" feminine ; --auto
lin alert_V2 = mkV2 "alertar" ; --auto
lin aleurone_N = mkN "aleurona" feminine ; --auto
lin alexandrite_N = mkN "alexandrita" feminine ; --auto
lin alexia_N = mkN "alèxia" feminine ; --auto
lin alfalfa_N = mkN "alfals" masculine | mkN "alfals" masculine ; --auto
lin alga_N = mkN "alga" feminine ; --auto
lin algal_A = mkA "d'algues" ; --auto
lin algebra_N = mkN "àlgebra" feminine ; --auto
lin algebraic_A = mkA "algebraic" ; --auto
lin algebraist_N = mkN "algebrista" ; --auto
lin algerian_A = mkA "argelí" ; --auto
lin algorithm_N = mkN "algorisme" masculine | mkN "algoritme" masculine ; --auto
lin algorithmic_A = mkA "algorítmic" ; --auto
lin alias_N = mkN "àlies" masculine | mkN "àlies" masculine | mkN "àlies" ; --auto
lin alienFem_N = variants {} ; ---- sense to be split
lin alienMasc_N = variants {} ; ---- sense to be split
lin alienate_V2 = mkV2 "alienar" ; --auto
lin alienation_N = mkN "alienació" feminine ; --auto
lin alienism_N = mkN "estrangeria" feminine ; --auto
lin align_V = mkV "alinear" ; --auto
lin align_V2 = mkV2 "alinear" ; --auto
lin alike_A = mkA "semblant" ; --auto
lin alike_Adv = mkAdv "igualment" ; --auto
lin alimentary_A = mkA "alimentari" | mkA "alimentós" ; --auto
lin aliquot_N = mkN "alíquota" feminine ; --auto
lin alive_A = mkA "viu" ; --auto
lin alkalimetry_N = mkN "alcalimetria" feminine ; --auto
lin alkaline_A = mkA "alcalí" ; --auto
lin alkaloid_N = mkN "alcaloide" masculine ; --auto
lin alkalosis_N = mkN "alcalosi" feminine ; --auto
lin allegation_N = mkN "al·legació" feminine ; --auto
lin allege_V2 = mkV2 "al·legar" ; --auto
lin allegedly_AdA = mkAdv "presumptament" ; --auto
lin allegedly_AdV = mkAdv "presumptament" ; --auto
lin allegory_N = mkN "al·legoria" feminine ; --auto
lin allegretto_Adv = mkAdv "allegretto" ; --auto
lin allegro_Adv = mkAdv "allegro" ; --auto
lin allele_N = mkN "al·lel" masculine ; --auto
lin allergen_N = mkN "al·lergogen" masculine ; --auto
lin allergic_A = mkA "al·lèrgic" ; --auto
lin allergy_N = mkN "al·lèrgia" feminine ; --auto
lin alleviate_V2 = mkV2 "alleujar" ; --auto
lin alleviation_N = mkN "atenuant" masculine ; --auto
lin alley_N = mkN "carreró" masculine ; --auto
lin alliance_N = mkN "aliança" feminine ; --auto
lin alligator_N = mkN "caiman" masculine ; --auto
lin alliteration_N = mkN "al·literació" feminine ; --auto
lin allocate_V = mkV "destinar" ; --auto
lin allocate_V2 = mkV2 "destinar" ; --auto
lin allocation_N = mkN "assignació" feminine ; --auto
lin allomorphic_A = mkA "al·lomòrfic" ; --auto
lin allopatric_A = mkA "al·lopàtric" ; --auto
lin allophone_N = mkN "al·lòfon" masculine ; --auto
lin allow_V2 = mkV2 (verbV (admetre_2 "permetre")) ;
lin allow_V2V = mkV2V (verbV (admetre_2 "permetre")) ParadigmsCat.accusative ParadigmsCat.genitive ;
lin allow_for_V2 = prepV2 (lin V OP_allow_V2) OP_for_Prep ; -- guess-p-verb
lin allow_of_V2 = prepV2 (lin V OP_allow_V2) OP_of_Prep ; -- guess-p-verb
lin allowance_N = mkN "pensió" feminine ; --auto
lin alloy_N = mkN "aliatge" masculine ; --auto
lin allude_V = mkV "al·ludir" ; --auto
lin allusion_N = mkN "al·lusió" feminine ; --auto
lin alluvial_A = mkA "al·luvial" ; --auto
lin ally_N = mkN "aliat" feminine | mkN "aliat" masculine ; --auto
lin almanac_N = mkN "almanac" masculine ; --auto
lin almandine_N = mkN "almandina" feminine ; --auto
lin almond_N = mkN "ametla" feminine | mkN "ametlla" feminine ; --auto
lin almost_AdA = mkAdv "casi" | mkAdv "gairebé" | mkAdv "quasi" ; --auto
lin almost_AdN = mkAdv "casi" | mkAdv "gairebé" | mkAdv "quasi" ; --auto
lin almost_Adv = mkAdv "quasi" | mkAdv "gairebé" ;
lin alms_N = mkN "almoina" feminine | mkN "almoina" feminine ; --auto
lin aloft_Adv = mkAdv "a dalt" ; --auto
lin alone_A = mkA "sol" ;
lin along_Adv = mkAdv "al llarg de" ;
lin along_Prep = mkPrep "al llarg de" ;
lin alongside_Adv = mkAdv "de costat" ; --auto
lin alopecia_N = mkN "alopècia" feminine ; --auto
lin alpaca_N = mkN "alpaca" feminine ; --auto
lin alpha_N = mkN "alfa" feminine ; --auto
lin alphabet_N = mkN "abecedari" masculine | mkN "alfabet" masculine ; --auto
lin alphabetic_A = mkA "alfabètic" ; --auto
lin alphanumeric_A = mkA "alfanumèric" ; --auto
lin alpine_A = mkA "alpí" ; --auto
lin already_AdV = mkAdv "ja" ; --auto
lin already_Adv = L.already_Adv ;
lin alright_Adv = mkAdv "bé" ; --auto
lin alsatianFem_N = variants {} ; ---- sense to be split
lin alsatianMasc_N = variants {} ; ---- sense to be split
lin also_AdV = mkAdv "també" ; --auto
lin also_Adv = mkAdv "també" | mkAdv "a més a més" ;
lin altar_N = mkN "altar" masculine ; --auto
lin altar_piece_N = mkN "retaule" masculine ; --auto
lin altazimuth_N = mkN "altazimut" masculine ; --auto
lin alter_V = mkV "alterar" ; --auto
lin alter_V2 = mkV2 "alterar" ; --auto
lin alteration_N = mkN "alteració" feminine ; --auto
lin altercation_N = mkN "altercat" masculine ; --auto
lin alternate_V = mkV "alternar" ; --auto
lin alternate_V2 = mkV2 "alternar" ; --auto
lin alternation_N = mkN "alternança" feminine ; --auto
lin alternative_A = mkA "alternatiu" ; --auto
lin alternative_N = mkN "alternativa" feminine ; --auto
lin alternator_N = mkN "alternador" masculine ; --auto
lin although_Subj = S.although_Subj ;
lin altitude_N = mkN "altitud" feminine ; --auto
lin altitudinal_A = mkA "altitudinal" ; --auto
lin altocumulus_N = mkN "altocúmul" masculine | mkN "altocúmulus" masculine ; --auto
lin altogether_Adv = mkAdv "en total" ; --auto
lin altostratus_N = mkN "altostratus" masculine | mkN "altostratus" masculine ; --auto
lin altruism_N = mkN "altruisme" masculine ; --auto
lin altruist_N = mkN "altruista" ; --auto
lin altruistic_A = mkA "altruista" ; --auto
lin alum_N = mkN "alum" masculine ; --auto
lin alumina_N = mkN "alúmina" feminine ; --auto
lin aluminium_N = mkN "alumini" masculine ; --auto
lin aluminous_A = mkA "aluminós" ; --auto
lin aluminum_N = mkN "alumini" masculine ; --auto
lin alveolar_A = mkA "alveolar" ; --auto
lin always_AdV = mkAdv "sempre" ; --auto
lin always_Adv = S.always_AdV ;
lin amalgam_N = mkN "amalgama" feminine ; --auto
lin amalgamation_N = mkN "amalgamació" feminine ; --auto
lin amalgamator_N = mkN "amalgamador" masculine ; --auto
lin amateurFem_N = variants {} ; ---- sense to be split
lin amateurMasc_N = variants {} ; ---- sense to be split
lin amateurism_N = mkN "amateurisme" masculine ; --auto
lin amaurosis_N = mkN "amaurosi" feminine ; --auto
lin amazing_A = mkA "increïble" ; --auto
lin amazon_N = mkN "amazona" feminine ; --auto
lin ambassador_N = mkN "ambaixador" | mkN "ambaixador" ; --auto
lin amber_N = mkN "ambre" masculine ; --auto
lin ambient_A = mkA "ambiental" ; --auto
lin ambiguity_N = mkN "ambigüitat" feminine ; --auto
lin ambiguous_A = mkA "ambigu" ; --auto
lin ambition_N = mkN "ambició" feminine ; --auto
lin ambitious_A = mkA "ambiciós" ; --auto
lin ambivalence_N = mkN "ambivalència" feminine ; --auto
lin ambivalent_A = mkA "ambivalent" ; --auto
lin amblygonite_N = mkN "ambligonita" feminine ; --auto
lin amblyopia_N = mkN "ambliopia" feminine ; --auto
lin ambrosia_N = mkN "ambrosia" feminine ; --auto
lin ambulance_N = mkN "ambulància" feminine ; --auto
lin ameloblast_N = mkN "ameloblast" masculine ; --auto
lin amend_V = mkV "esmenar" ; --auto
lin amend_V2 = mkV2 "esmenar" ; --auto
lin amendment_N = mkN "esmena" feminine ; --auto
lin americanFem_N = variants {} ; ---- sense to be split
lin americanMasc_N = variants {} ; ---- sense to be split
lin american_A = mkA "americà" ; --auto
lin americanism_N = mkN "americanisme" masculine ; --auto
lin americium_N = mkN "americi" masculine ; --auto
lin amethyst_N = mkN "ametista" feminine ; --auto
lin ametropia_N = mkN "ametropia" feminine ; --auto
lin amicable_A = mkA "amigable" ; --auto
lin amid_Prep = mkPrep "entre" ; --auto
lin amide_N = mkN "amida" feminine ; --auto
lin amidships_Adv = mkAdv "al mig del vaixell" ; --auto
lin amine_N = mkN "amina" feminine ; --auto
lin amino_A = mkA "aminat" ; --auto
lin amitosis_N = mkN "amitosi" feminine ; --auto
lin amitotic_A = mkA "amitòtic" ; --auto
lin ammeter_N = mkN "amperímetre" masculine ; --auto
lin ammine_N = mkN "ammina" feminine ; --auto
lin ammonia_N = mkN "amoníac" masculine ; --auto
lin ammonification_N = mkN "amonificació" feminine ; --auto
lin ammonium_N = mkN "amoni" masculine ; --auto
lin amnesty_N = mkN "amnistia" feminine ; --auto
lin amniocentesis_N = mkN "amniocentesi" feminine ; --auto
lin amnion_N = mkN "amni" masculine ; --auto
lin amoeba_N = mkN "ameba" feminine ; --auto
lin among_Prep = mkPrep "entre" ;
lin amongst_Prep = mkPrep "entre" ; --auto
lin amorphous_A = mkA "amorf" ; --auto
lin amount_N = mkN "quantitat" feminine ;
lin amperage_N = mkN "amperatge" masculine ; --auto
lin ampere_N = mkN "ampere" masculine ; --auto
lin ampersand_N = mkN "àmpersand" masculine ; --auto
lin amphetamine_N = mkN "amfetamina" feminine ; --auto
lin amphibian_N = mkN "amfibi" masculine ; --auto
lin amphibious_A = mkA "amfibi" ; --auto
lin amphibology_N = mkN "amfibologia" feminine ; --auto
lin amphitheatre_N = mkN "amfiteatre" masculine ; --auto
lin ampicillin_N = mkN "ampicil·lina" feminine ; --auto
lin amplification_N = mkN "amplificació" feminine ; --auto
lin amplifier_N = mkN "amplificador" masculine ; --auto
lin amplify_V2 = mkV2 "amplificar" ; --auto
lin amplitude_N = mkN "amplitud" feminine ; --auto
lin amputate_V2 = mkV2 "amputar" ; --auto
lin amputation_N = mkN "amputació" feminine ; --auto
lin amulet_N = mkN "amulet" masculine ; --auto
lin amuse_V2 = mkV2 "divertir" ; --auto
lin amusement_N = mkN "distracció" feminine ; --auto
lin amygdalotomy_N = mkN "amigdalotomia" feminine ; --auto
lin amyl_N = mkN "amil" masculine ; --auto
lin amylase_N = mkN "amilasa" feminine ; --auto
lin amyloid_N = mkN "amiloide" masculine ; --auto
lin amyloidosis_N = mkN "amiloïdosi" feminine ; --auto
lin anabolism_N = mkN "anabolisme" masculine ; --auto
lin anachronism_N = mkN "anacronisme" masculine ; --auto
lin anachronistic_A = mkA "anacrònic" ; --auto
lin anaclitic_A = mkA "anaclític" ; --auto
lin anaemia_N = mkN "anèmia" feminine ; --auto
lin anaerobic_A = mkA "anaeròbic" ; --auto
lin anaesthesia_N = mkN "anestèsia" feminine ; --auto
lin anaesthetic_A = mkA "anestèsic" ; --auto
lin anaesthetic_N = mkN "anestèsic" masculine ; --auto
lin anaesthetist_N = mkN "anestesista" ; --auto
lin anal_A = mkA "anal" ; --auto
lin analgesia_N = mkN "analgèsia" feminine ; --auto
lin analgesic_A = mkA "analgèsic" ; --auto
lin analgesic_N = mkN "analgèsic" masculine ; --auto
lin analogous_A = mkA "anàleg" ; --auto
lin analysis_N = mkN "anàlisi" feminine ;
lin analyst_N = mkN "analista" ; --auto
lin analytic_A = mkA "analític" ; --auto
lin analytical_A = mkA "analític" ; --auto
lin analyze_V2 = mkV2 "analitzar" ; --auto
lin anaphase_N = mkN "anafase" feminine ; --auto
lin anaphora_N = mkN "anàfora" feminine ; --auto
lin anaphoric_A = mkA "anafòric" ; --auto
lin anaphylaxis_N = mkN "anafilaxi" feminine ; --auto
lin anarchic_A = mkA "anàrquic" ; --auto
lin anarchism_N = mkN "anarquisme" masculine ; --auto
lin anarchistFem_N = variants {} ; ---- sense to be split
lin anarchistMasc_N = variants {} ; ---- sense to be split
lin anarchy_N = mkN "anarquia" feminine ; --auto
lin anastomosis_N = mkN "anastomosi" feminine ; --auto
lin anatomical_A = mkA "anatòmic" ; --auto
lin anatomist_N = mkN "anatomista" ; --auto
lin anatomy_N = mkN "anatomia" feminine ; --auto
lin anatoxin_N = mkN "anatoxina" feminine ; --auto
lin ancestor_N = mkN "avantpassat" | mkN "avantpassat" ; --auto
lin anchor_N = mkN "àncora" feminine ; --auto
lin anchor_V = mkV "ancorar" ; --auto
lin anchor_V2 = mkV2 "ancorar" ; --auto
lin anchovy_N = mkN "anxova" feminine ; --auto
lin ancient_A = mkA "antic" ; --auto
lin ancillary_A = mkA "subsidiari" ; --auto
lin and_Conj = S.and_Conj ;
lin andante_Adv = mkAdv "andante" ; --auto
lin andesite_N = mkN "andesita" feminine ; --auto
lin andorran_A = mkA "andorrà" ; --auto
lin andorran_N = mkN "andorrà" | mkN "andorrà" ; --auto
lin andradite_N = mkN "andradita" feminine ; --auto
lin android_N = mkN "androide" masculine ; --auto
lin anecdote_N = mkN "anècdota" feminine ; --auto
lin anechoic_A = mkA "anecoic" ; --auto
lin anemometer_N = mkN "anemòmetre" masculine ; --auto
lin anemometry_N = mkN "anemometria" feminine ; --auto
lin anemone_N = mkN "anemone" feminine ; --auto
lin anemophilous_A = mkA "anemòfil" ; --auto
lin anergy_N = mkN "anèrgia" feminine ; --auto
lin anew_Adv = mkAdv "de nou" ; --auto
lin angel_N = mkN "àngel" masculine ; --auto
lin angelic_A = mkA "angèlic" ; --auto
lin anger_N = mkN "ràbia" feminine ; --auto
lin anger_V2 = mkV2 "enfurir" ; --auto
lin angina_N = mkN "angina" feminine ; --auto
lin angiology_N = mkN "angiologia" feminine ; --auto
lin angioma_N = mkN "angioma" masculine ; --auto
lin angiosperm_N = mkN "angiosperma" feminine ; --auto
lin angle_N = mkN "angle" masculine ; --auto
lin angler_N = mkN "rap" masculine ; --auto
lin anglicism_N = mkN "anglicisme" masculine ; --auto
lin anglophilFem_N = variants {} ; ---- sense to be split
lin anglophilMasc_N = variants {} ; ---- sense to be split
lin anglophileFem_N = variants {} ; ---- sense to be split
lin anglophileMasc_N = variants {} ; ---- sense to be split
lin angolan_A = mkA "angolès" ; --auto
lin angora_N = mkN "angora" feminine ; --auto
lin angry_A = mkA "enfadat" ; --auto
lin angular_A = mkA "angular" ; --auto
lin anhydride_N = mkN "anhídrid" masculine ; --auto
lin animal_A = mkA "animal" ; --auto
lin animal_N = L.animal_N ;
lin animation_N = mkN "animació" feminine ; --auto
lin animatism_N = mkN "animatisme" masculine ; --auto
lin anime_N = mkN "anime" masculine ; --auto
lin animism_N = mkN "animisme" masculine ; --auto
lin animosity_N = mkN "animositat" feminine ; --auto
lin anion_N = mkN "anió" masculine ; --auto
lin anise_N = mkN "anís" masculine ; --auto
lin aniseikonia_N = mkN "anisoiconia" feminine ; --auto
lin anisometropia_N = mkN "anisometropia" feminine ; --auto
lin anisotropic_A = mkA "anisòtrop" ; --auto
lin anisotropy_N = mkN "anisotropia" feminine ; --auto
lin ankle_N = mkN "turmell" masculine ; --auto
lin ankylosis_N = mkN "anquilosi" feminine ; --auto
lin anneal_V2 = mkV2 "trempar" ; --auto
lin annelid_N = mkN "anèl·lid" masculine ; --auto
lin annex_N = mkN "annex" masculine ; --auto
lin annex_V2 = mkV2 "annexionar" ; --auto
lin annexation_N = mkN "annexió" feminine ; --auto
lin annihilate_V2 = mkV2 "aniquilar" ; --auto
lin annihilation_N = mkN "anihilació" feminine ; --auto
lin anniversary_N = mkN "aniversari" masculine ; --auto
lin announce_V2 = mkV2 (mkV "anunciar") ;
lin announce_VS = mkVS (mkV "anunciar") ;
lin announcement_N = mkN "anunci" masculine | mkN "convocatòria" feminine ; --auto
lin annoy_V2 = mkV2 "incomodar" | mkV2 "molestar" ; --auto
lin annoyance_N = mkN "molèstia" feminine ; --auto
lin annoying_A = mkA "molest" ; --auto
lin annual_A = mkA "anual" ;
lin annuity_N = mkN "anualitat" feminine ; --auto
lin annular_A = mkA "anular" ; --auto
lin anode_N = mkN "ànode" masculine ; --auto
lin anointing_N = mkN "unció" feminine ; --auto
lin anomalous_A = mkA "anòmal" ; --auto
lin anomaly_N = mkN "anomalia" feminine ; --auto
lin anomie_N = mkN "anomia" feminine ; --auto
lin anonymity_N = mkN "anonimat" masculine ; --auto
lin anonymous_A = mkA "anònim" ; --auto
lin anorak_N = mkN "anorac" masculine ; --auto
lin anorexia_N = mkN "anorèxia" feminine ; --auto
lin anorthite_N = mkN "anortita" feminine ; --auto
lin anosmia_N = mkN "anòsmia" feminine ; --auto
lin anoxemia_N = mkN "anoxèmia" feminine ; --auto
lin anoxia_N = mkN "anòxia" feminine ; --auto
lin answer_N = mkN "resposta" feminine ;
lin answer_V = mkV "contestar" ;
lin answer_V2 = mkV2 (mkV "contestar") ;
lin answer_back_V2 = mkV2 (advV OP_answer_V OP_back_Adv ) ; -- guess-p-verb
lin answer_for_V2 = prepV2 OP_answer_V OP_for_Prep ; -- guess-p-verb
lin ant_N = mkN "formiga" feminine ; --auto
lin antagonist_N = mkN "antagonista" ; --auto
lin antarctic_A = mkA "antàrtic" ; --auto
lin ant_eater_N = mkN "formiguer" masculine ; --auto
lin antecedence_N = mkN "antecedència" feminine ; --auto
lin antecedent_N = mkN "antecedent" masculine ; --auto
lin antechamber_N = mkN "avantcambra" feminine ; --auto
lin antedate_V2 = mkV2 "antedatar" ; --auto
lin antelope_N = mkN "antílop" masculine ; --auto
lin antenna_N = mkN "antena" feminine ; --auto
lin antepenultimate_A = mkA "antepenúltim" ; --auto
lin anther_N = mkN "antera" feminine ; --auto
lin antheridium_N = mkN "anteridi" masculine ; --auto
lin antherozoid_N = mkN "anterozoide" masculine ; --auto
lin anthology_N = mkN "antologia" feminine ; --auto
lin anthracite_N = mkN "antracita" feminine ; --auto
lin anthropocentrism_N = mkN "antropocentrisme" masculine ; --auto
lin anthropological_A = mkA "antropològic" ; --auto
lin anthropologistFem_N = variants {} ; ---- sense to be split
lin anthropologistMasc_N = variants {} ; ---- sense to be split
lin anthropology_N = mkN "antropologia" feminine ; --auto
lin anthropometry_N = mkN "antropometria" feminine ; --auto
lin anthropomorphism_N = mkN "antropomorfisme" masculine ; --auto
lin anthropophagy_N = mkN "antropofàgia" feminine ; --auto
lin antibiosis_N = mkN "antibiosi" feminine ; --auto
lin antibiotic_N = mkN "antibiòtic" masculine ; --auto
lin antibody_N = mkN "anticòs" masculine ; --auto
lin anticipate_V = mkV "anticipar-se" ; --auto
lin anticipation_N = mkN "anticipació" feminine ; --auto
lin anticlinal_A = mkA "anticlinal" ; --auto
lin anticlockwise_Adv = mkAdv "en el sentit contrari de les agulles del rellotge" ; --auto
lin anticoagulant_N = mkN "anticoagulant" masculine ; --auto
lin anticyclone_N = mkN "anticicló" masculine ; --auto
lin anticyclonic_A = mkA "anticiclònic" ; --auto
lin antidote_N = mkN "antídot" masculine ; --auto
lin antiferromagnetic_A = mkA "antiferromagnètic" ; --auto
lin antiferromagnetism_N = mkN "antiferromagnetisme" masculine ; --auto
lin antifreeze_N = mkN "anticongelant" masculine ; --auto
lin antigen_N = mkN "antigen" masculine ; --auto
lin antihistamine_N = mkN "antihistamínic" masculine ; --auto
lin antimatter_N = mkN "antimatèria" feminine ; --auto
lin antimony_N = mkN "antimoni" masculine ; --auto
lin antinode_N = mkN "antinode" masculine ; --auto
lin antioxidant_N = mkN "antioxidant" masculine ; --auto
lin antiparallel_A = mkA "antiparal·lel" ; --auto
lin antiparticle_N = mkN "antipartícula" feminine ; --auto
lin antipathy_N = mkN "antipatia" feminine ; --auto
lin antiphony_N = mkN "antífona" feminine ; --auto
lin antique_A = mkA "antic" ; --auto
lin antiquity_N = mkN "antiguitat" feminine ; --auto
lin antisepsis_N = mkN "antisèpsia" feminine ; --auto
lin antisocial_A = mkA "antisocial" ; --auto
lin antistrophe_N = mkN "antístrofa" feminine ; --auto
lin antithesis_N = mkN "antítesi" feminine ; --auto
lin antitussive_N = mkN "antitussigen" masculine ; --auto
lin antonym_N = mkN "antònim" masculine ; --auto
lin antonymy_N = mkN "antonímia" feminine ; --auto
lin antrum_N = mkN "antre" masculine ; --auto
lin anus_N = mkN "anus" masculine | mkN "anus" masculine ; --auto
lin anxiety_N = mkN "angoixa" feminine | mkN "ànsia" feminine | mkN "ansietat" feminine ; --auto
lin anxious_A = mkA "ansiós" ; --auto
lin anyhow_Adv = mkAdv "de tota manera" ; --auto
lin anything_NP = variants {} ; --TODO qualsevol cosa
lin anyway_Adv = mkAdv "de totes maneres" ;
lin anywhere_Adv = mkAdv "a qualsevol lloc" ; --auto
lin aorist_N = mkN "aorist" masculine ; --auto
lin aorta_N = mkN "aorta" feminine ; --auto
lin apart_Adv = mkAdv "separats" ;
lin apart_from_Prep = mkPrep "a banda de" | mkPrep "a part de" ; --auto
lin apartheid_N = mkN "apartheid" masculine ; --auto
lin apartment_N = L.apartment_N ;
lin apathetic_A = mkA "apàtic" ; --auto
lin apathy_N = mkN "apatia" feminine ; --auto
lin apatite_N = mkN "apatita" feminine ; --auto
lin ape_N = mkN "simi" masculine ; --auto
lin apex_N = mkN "àpex" masculine ; --auto
lin aphaeresis_N = mkN "afèresi" feminine ; --auto
lin aphasia_N = mkN "afàsia" feminine ; --auto
lin aphonia_N = mkN "afonia" feminine ; --auto
lin aphorism_N = mkN "aforisme" masculine ; --auto
lin aphrodisiac_A = mkA "afrodisíac" ; --auto
lin apiculture_N = mkN "apicultura" feminine ; --auto
lin aplasia_N = mkN "aplàsia" feminine ; --auto
lin apocalypse_N = mkN "apocalipsi" feminine ; --auto
lin apocope_N = mkN "apòcope" masculine ; --auto
lin apologetic_A = mkA "apologètic" ; --auto
lin apology_N = mkN "disculpa" feminine ; --auto
lin aponeurosis_N = mkN "aponeurosi" feminine ; --auto
lin apophysis_N = mkN "apòfisi" feminine ; --auto
lin apostle_N = mkN "apòstol" masculine ; --auto
lin apostrophe_N = mkN "apòstrof" masculine ; --auto
lin apparent_A = mkA "aparent" ; --auto
lin apparition_N = mkN "aparició" feminine ; --auto
lin appeal_N = mkN "atracció" feminine ;
lin appeal_V = mkV "apel·lar" ; --auto
lin appeal_V2 = mkV2 "apel·lar" ; --auto
lin appealable_A = mkA "apel·lable" ; --auto
lin appear_V = mkV "semblar" ;
lin appear_VA = mkVA (mkV "semblar") ;
lin appear_VS = mkVS (mkV "semblar") ;
lin appear_VV = mkVV (mkV "semblar") ; --subcat mkVS
lin appearance_N = mkN "aspecte" masculine ;
lin appease_V2 = mkV2 "apaivagar" ; --auto
lin appellant_N = mkN "apel·lant" ; --auto
lin appendix_N = mkN "apèndix" masculine ; --auto
lin apperception_N = mkN "apercepció" feminine ; --auto
lin appetite_N = mkN "apetit" masculine ; --auto
lin applaud_V = mkV "aplaudir" ; --auto
lin applaud_V2 = mkV2 "aplaudir" ; --auto
lin applause_N = mkN "aplaudiment" masculine ; --auto
lin apple_N = L.apple_N ;
lin applet_N = mkN "miniaplicació" feminine ; --auto
lin appliance_N = mkN "electrodomèstic" masculine ; --auto
lin applicability_N = mkN "aplicabilitat" feminine ; --auto
lin applicable_A = mkA "aplicable" ; --auto
lin applicant_1_N = mkN "aspirant" ; --auto
lin applicant_2_N = mkN "aspirant" ; --auto
lin applicant_3_N = mkN "aspirant" ; --auto
lin application_N = mkN "aplicació" masculine ;--split "sol·licitud" (form) ;
lin apply_V = mkV "aplicar" ;
lin apply_V2 = mkV2 (mkV "aplicar") ; -- "apuntar-se a" "demanar" "sol·licitar" (ask for in various contexts)
lin apply_V2V = mkV2V (mkV "aplicar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin apply_VV = deVV (mkV "demanar") ;
lin apply_for_V2 = prepV2 OP_apply_V OP_for_Prep ; -- guess-p-verb
lin appoint_V2 = mkV2 "fixar" | mkV2 "nomenar" ; --auto
lin appointment_N = mkN "cita" feminine ; --auto
lin apposition_N = mkN "aposició" feminine ; --auto
lin appraise_V2 = mkV2 "valorar" ; --auto
lin appreciable_A = mkA "apreciable" ; --auto
lin appreciate_V = mkV "apreciar" ; --auto
lin appreciate_V2 = mkV2 "apreciar" ; --auto
lin appreciation_N = mkN "agraïment" masculine ; --auto
lin apprehension_N = mkN "aprehensió" feminine ; --auto
lin approach_N = mkN "enfocament" masculine | mkN "plantejament" masculine ;
lin approach_V = mkV "acostar" ;
lin approach_V2 = mkV2 (mkV "acostar") ;
lin appropriate_A = mkA "adequat" ;
lin appropriation_N = mkN "apropiació" feminine ; --auto
lin approval_N = mkN "aprovació" feminine ; --auto
lin approve_V = mkV "aprovar" ; --auto
lin approve_V2 = mkV2 "aprovar" ; --auto
lin approximate_A = mkA "aproximat" ; --auto
lin approximate_V = mkV "aproximar" ; --auto
lin approximate_V2 = mkV2 "aproximar" ; --auto
lin approximation_N = mkN "aproximació" feminine ; --auto
lin apraxia_N = mkN "apràxia" feminine ; --auto
lin apricot_N = mkN "albercoc" masculine ; --auto
lin apron_N = mkN "davantal" masculine ; --auto
lin apse_N = mkN "absis" masculine | mkN "absis" masculine ; --auto
lin apt_A = mkA "apte" ; --auto
lin apterous_A = mkA "àpter" ; --auto
lin aptitude_N = mkN "aptitud" feminine ; --auto
lin aquaculture_N = mkN "aqüicultura" feminine ; --auto
lin aquamarine_N = mkN "aiguamarina" feminine ; --auto
lin aquarium_N = mkN "aquàrium" masculine ; --auto
lin aquatic_A = mkA "aquàtic" ; --auto
lin aqueduct_N = mkN "aqüeducte" masculine ; --auto
lin aqueous_A = mkA "aquós" ; --auto
lin aquifer_N = mkN "aqüífer" masculine ; --auto
lin arab_A = mkA "àrab" ; --auto
lin arab_N = mkN "àrab" ; --auto
lin arabianFem_N = variants {} ; ---- sense to be split
lin arabianMasc_N = variants {} ; ---- sense to be split
lin arable_A = mkA "cultivable" ; --auto
lin arachnid_N = mkN "aràcnid" masculine ; --auto
lin arachnoid_N = mkN "aracnoide" masculine ; --auto
lin aragonite_N = mkN "aragonita" feminine ; --auto
lin arbitrary_A = mkA "arbitrari" ; --auto
lin arbitrate_V = mkV "arbitrar" ; --auto
lin arbitrate_V2 = mkV2 "arbitrar" ; --auto
lin arboriculture_N = mkN "arboricultura" feminine ; --auto
lin arcade_N = mkN "arcada" feminine ; --auto
lin arch_N = mkN "arc" masculine ; --auto
lin arch_V = mkV "arquejar" ; --auto
lin arch_V2 = mkV2 "arquejar" ; --auto
lin archaeologist_N = mkN "arqueòleg" | mkN "arqueòleg" ; --auto
lin archaeology_N = mkN "arqueologia" feminine ; --auto
lin archaic_A = mkA "arcaic" ; --auto
lin archaism_N = mkN "arcaisme" masculine ; --auto
lin archangel_N = mkN "arcàngel" masculine ; --auto
lin archbishop_N = mkN "arquebisbe" masculine ; --auto
lin archduchess_N = mkN "arxiduquesa" feminine ; --auto
lin archduke_N = mkN "arxiduc" masculine ; --auto
lin archipelago_N = mkN "arxipèlag" masculine ; --auto
lin architectFem_N = variants {} ; ---- sense to be split
lin architectMasc_N = variants {} ; ---- sense to be split
lin architectural_A = mkA "arquitectònic" ; --auto
lin architecture_N = mkN "arquitectura" feminine ; --auto
lin architrave_N = mkN "arquitrau" masculine ; --auto
lin archival_A = mkA "arxivístic" ; --auto
lin archivist_N = mkN "arxiver" feminine | mkN "arxiver" masculine ; --auto
lin arctic_A = mkA "àrtic" ; --auto
lin ardor_N = mkN "cremor" feminine ; --auto
lin ardour_N = mkN "fervor" masculine ; --auto
lin arduous_A = mkA "ardu" ; --auto
lin area_1_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_2_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_3_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_4_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_5_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin area_6_N = mkN "àrea" feminine | mkN "zona" feminine ;
lin areal_A = mkA "areal" ; --auto
lin areflexia_N = mkN "areflèxia" feminine ; --auto
lin arena_N = mkN "camp" masculine ; --auto
lin arenicolous_A = mkA "arenícola" ; --auto
lin areola_N = mkN "arèola" feminine ; --auto
lin argentinian_A = mkA "argentí" ; --auto
lin argentinian_N = mkN "argentí" | mkN "argentí" ; --auto
lin arginine_N = mkN "arginina" feminine ; --auto
lin argon_N = mkN "argó" masculine ; --auto
lin argue_V = mkV (servir_101 "discutir") ;
lin argue_V2 = mkV2 (mkV (servir_101 "discutir")) ;
lin argue_VS = mkVS (mkV (servir_101 "discutir")) ;
lin argue_down_V2 = prepV2 OP_argue_V OP_down_Prep ; -- guess-p-verb
lin argue_out_V2 = prepV2 OP_argue_V OP_out_Prep ; -- guess-p-verb
lin argument_N = mkN "discussió" feminine ;
lin argumentation_N = mkN "argumentació" feminine ; --auto
lin aria_N = mkN "ària" feminine ; --auto
lin arid_A = mkA "àrid" ; --auto
lin arietta_N = mkN "arieta" feminine ; --auto
lin arise_V = mkV (servir_101 "sorgir") ;
lin aristocracy_N = mkN "aristocràcia" feminine ; --auto
lin aristocrat_N = mkN "aristòcrata" ; --auto
lin aristocratic_A = mkA "aristocràtic" ; --auto
lin arithmetic_N = mkN "aritmètica" feminine ; --auto
lin arithmetical_A = mkA "aritmètic" ; --auto
lin arithmetician_N = mkN "aritmètic" feminine | mkN "aritmètic" masculine ; --auto
lin ark_N = mkN "arca" feminine ; --auto
lin arm_1_N = mkN "braç" masculine ;
lin arm_2_N = mkN "braç" masculine ;
lin arm_V = mkV "armar" ; --auto
lin arm_V2 = mkV2 "armar" ; --auto
lin armament_N = mkN "armament" masculine ; --auto
lin armchair_N = mkN "butaca" feminine ; --auto
lin armed_A = mkA "armat" ; --auto
lin armistice_N = mkN "armistici" masculine ; --auto
lin armored_A = mkA "blindat" ; --auto
lin armour_N = mkN "armadura" feminine ; --auto
lin armoury_N = mkN "blasó" masculine ; --auto
lin armpit_N = mkN "aixella" feminine ; --auto
lin army_N = mkN "exèrcit" masculine ;
lin arnica_N = mkN "àrnica" feminine ; --auto
lin aroma_N = mkN "aroma" feminine ; --auto
lin aromatic_A = mkA "aromàtic" ; --auto
lin around_AdN = mkAdv "al voltant" ; --auto
lin around_Adv = mkAdv "al voltant de" ;
lin around_Prep = mkPrep "al voltant de" ;
lin arouse_V2 = mkV2 "despertar" | mkV2 "excitar" ; --auto
lin arrange_V = mkV "organitzar" ;
lin arrange_V2 = mkV2 (mkV "organitzar") ;
lin arrangement_N = mkN "acord" masculine ; --split "configuració" fem (agreement vs. placement, order, etc)
lin array_N = mkN "varietat" feminine ; --auto
lin arrest_N = mkN "arrest" masculine | mkN "detenció" feminine ; --auto
lin arrest_V2 = mkV2 "arrestar" ; --auto
lin arrester_N = mkN "descarregador" feminine | mkN "descarregador" masculine ; --auto
lin arrival_N = mkN "arribada" feminine ; --auto
lin arrive_V = mkV "arribar" ;
lin arrogance_N = mkN "arrogància" feminine ; --auto
lin arrogant_A = mkA "arrogant" ; --auto
lin arrow_N = mkN "fletxa" feminine ; --auto
lin arsenal_N = mkN "arsenal" masculine ; --auto
lin arsenate_N = mkN "arseniat" masculine ; --auto
lin arsenic_N = mkN "arsènic" masculine ; --auto
lin arsenide_N = mkN "arseniür" masculine ; --auto
lin arsine_N = mkN "arsina" feminine ; --auto
lin art_N = L.art_N ;
lin arterial_A = mkA "arterial" ; --auto
lin arteriole_N = mkN "arteriola" feminine ; --auto
lin arteriosclerosis_N = mkN "arteriosclerosi" feminine ; --auto
lin artery_N = mkN "artèria" feminine ; --auto
lin arthralgia_N = mkN "artràlgia" feminine ; --auto
lin arthrodesis_N = mkN "artròdesi" feminine ; --auto
lin arthropod_N = mkN "artròpode" masculine ; --auto
lin arthroscope_N = mkN "artroscopi" masculine ; --auto
lin arthroscopy_N = mkN "artroscòpia" feminine ; --auto
lin artichoke_N = mkN "carxofa" feminine ; --auto
lin article_N = mkN "article" masculine ;
lin articular_A = mkA "articular" ; --auto
lin articulate_A = mkA "articulat" ; --auto
lin articulate_V = mkV "articular" ; --auto
lin articulate_V2 = mkV2 "articular" ; --auto
lin articulation_N = mkN "articulació" feminine ; --auto
lin articulatory_A = mkA "articulatori" ; --auto
lin artifact_N = mkN "artefacte" masculine ; --auto
lin artificial_A = mkA "artificial" ; --auto
lin artillery_N = mkN "artilleria" feminine ; --auto
lin artisan_N = mkN "artesà" feminine | mkN "artesà" masculine ; --auto
lin artist_N = mkN "artista" ;
lin artistic_A = mkA "artístic" ; --auto
lin aryanFem_N = variants {} ; ---- sense to be split
lin aryanMasc_N = variants {} ; ---- sense to be split
lin as_Prep = mkPrep "com" ;
lin as_Subj = mkSubj "com" Indic | mkSubj "tal com" Indic ;
lin as_for_Prep = mkPrep "quant a" ; --auto
lin as_regards_Prep = mkPrep "respecte a" ; --auto
lin as_well_Adv = mkAdv "també" ; --auto
lin asbestos_N = mkN "asbest" masculine | mkN "asbest" masculine ; --auto
lin ascendant_N = mkN "ascendent" masculine ; --auto
lin ascendent_N = mkN "ascendent" ; --auto
lin ascertain_V2 = mkV2 "constatar" ; --auto
lin ascetic_N = mkN "asceta" ; --auto
lin asceticism_N = mkN "ascetisme" masculine ; --auto
lin ascribe_V2 = mkV2 "adscriure" ; --auto
lin asepsis_N = mkN "asèpsia" feminine ; --auto
lin aseptic_A = mkA "asèptic" ; --auto
lin asexual_A = mkA "asexual" ; --auto
lin ash_N = mkN "cendra" feminine ; --auto
lin ashamed_A = mkA "avergonyit" ; --auto
lin ashlar_N = mkN "carreu" masculine ; --auto
lin ashore_Adv = mkAdv "en terra" ; --auto
lin ashtray_N = mkN "cendrer" masculine ; --auto
lin asian_A = mkA "asiàtic" ; --auto
lin asian_N = mkN "asiàtic" | mkN "asiàtic" ; --auto
lin aside_Adv = mkAdv "de banda" ; --auto
lin ask_V = mkV "preguntar" ;
lin ask_V2 = mkV2 (mkV "preguntar") ;
lin ask_V2V = mkV2V (mkV "demanar") ParadigmsCat.dative ParadigmsCat.genitive ;
lin ask_VQ = mkVQ (mkV "preguntar") ;
lin ask_about_V2 = prepV2 OP_ask_V OP_about_Prep ; -- guess-p-verb
lin ask_after_V2 = prepV2 OP_ask_V OP_after_Prep ; -- guess-p-verb
lin ask_around_V = advV OP_ask_V OP_around_Adv ; -- guess-p-verb
lin ask_around_V2 = prepV2 OP_ask_V OP_around_Prep ; -- guess-p-verb
lin ask_for_V2 = prepV2 OP_ask_V OP_for_Prep ; -- guess-p-verb
lin ask_for_V3 = variants {} ; -- guess-p-verb
lin ask_in_V2 = prepV2 OP_ask_V OP_in_Prep ; -- guess-p-verb
lin ask_out_V2 = prepV2 OP_ask_V OP_out_Prep ; -- guess-p-verb
lin ask_over_V2 = prepV2 OP_ask_V OP_over_Prep ; -- guess-p-verb
lin ask_round_V2 = prepV2 OP_ask_V OP_round_Prep ; -- guess-p-verb
lin askance_Adv = mkAdv "de reüll" ; --auto
lin asleep_A = mkA "adormit" ; --auto
lin asocial_A = mkA "asocial" ; --auto
lin asp_N = mkN "àspid" masculine ; --auto
lin aspect_N = mkN "aspecte" masculine ;
lin aspectual_A = mkA "aspectual" ; --auto
lin asphalt_N = mkN "asfalt" masculine ; --auto
lin asphalt_V2 = mkV2 "asfaltar" ; --auto
lin asphaltic_A = mkA "asfàltic" ; --auto
lin asphyxia_N = mkN "asfíxia" feminine ; --auto
lin aspic_N = mkN "gelatina" feminine ; --auto
lin aspirator_N = mkN "aspirador" masculine ; --auto
lin aspirin_N = mkN "aspirina" feminine ; --auto
lin ass_N = mkN "ase" masculine ; --auto
lin assailant_N = mkN "assaltador" | mkN "assaltador" ; --auto
lin assault_N = mkN "agressió" feminine ; --auto
lin assault_V2 = mkV2 "assaltar" ; --auto
lin assemble_V = mkV "reunir" ; --auto
lin assemble_V2 = mkV2 "reunir" ; --auto
lin assembler_N = mkN "assemblador" masculine ; --auto
lin assembly_N = mkN "assemblea" feminine ; --auto
lin assent_N = mkN "assentiment" masculine ; --auto
lin assent_V = mkV "assentir" ; --auto
lin assert_V = mkV "afirmar" ; --auto
lin assert_V2 = mkV2 "afirmar" ; --auto
lin assertion_N = mkN "asserció" feminine ; --auto
lin assess_V2 = mkV2 "avaluar" ; --auto
lin assessment_N = mkN "avaluació" feminine ;
lin asset_N = mkN "avantatge" masculine ; --auto
lin assibilation_N = mkN "assibilació" feminine ; --auto
lin assiduity_N = mkN "assiduïtat" feminine ; --auto
lin assign_V2 = mkV2 "assignar" ; --auto
lin assignor_N = mkN "cedent" masculine ; --auto
lin assimilable_A = mkA "assimilable" ; --auto
lin assimilate_V = mkV "assimilar" ; --auto
lin assimilate_V2 = mkV2 "assimilar" ; --auto
lin assimilation_N = mkN "assimilació" feminine ; --auto
lin assist_V = mkV "assistir" ; --auto
lin assist_V2 = mkV2 "assistir" ; --auto
lin assistance_N = mkN "assistència" feminine ; --auto
lin assistantFem_N = variants {} ; ---- sense to be split
lin assistantMasc_N = variants {} ; ---- sense to be split
lin associate_V = mkV "associar" ;
lin associate_V2 = mkV2 (mkV "associar") ;
lin association_N = mkN "associació" masculine ;
lin assonance_N = mkN "assonància" feminine ; --auto
lin assortment_N = mkN "assortiment" masculine ; --auto
lin assume_V2 = mkV2 (mkV (servir_101 "assumir")) ;
lin assume_VS = mkVS (mkV (servir_101 "assumir")) ;
lin assumption_N = mkN "suposició" feminine ; --auto
lin assurance_N = mkN "garantia" feminine ; --auto
lin assure_V2 = mkV2 "assegurar" ; --auto
lin astatic_A = mkA "astàtic" ; --auto
lin astatine_N = mkN "àstat" masculine ; --auto
lin aster_N = mkN "àster" masculine ; --auto
lin asterisk_N = mkN "asterisc" masculine ; --auto
lin asterism_N = mkN "asterisme" masculine ; --auto
lin asteroid_N = mkN "asteroide" masculine ; --auto
lin asthenia_N = mkN "astènia" feminine ; --auto
lin asthenosphere_N = mkN "astenosfera" feminine ; --auto
lin asthma_N = mkN "asma" feminine ; --auto
lin astigmatism_N = mkN "astigmatisme" masculine ; --auto
lin astonish_V2 = mkV2 "asombrar" ; --auto
lin astonishment_N = mkN "sorpresa" feminine ; --auto
lin astride_Adv = mkAdv "cama ací, cama allà" ; --auto
lin astrocyte_N = mkN "astròcit" masculine ; --auto
lin astrolabe_N = mkN "astrolabi" masculine ; --auto
lin astrologer_N = mkN "astròleg" | mkN "astròleg" ; --auto
lin astrology_N = mkN "astrologia" feminine ; --auto
lin astronaut_N = mkN "astronauta" ; --auto
lin astronomer_N = mkN "astrònom" | mkN "astrònom" ; --auto
lin astronomical_A = mkA "astronòmic" ; --auto
lin astronomy_N = mkN "astronomia" feminine ; --auto
lin astrophysicist_N = mkN "astrofísic" | mkN "astrofísic" ; --auto
lin astrophysics_N = mkN "astrofísica" feminine ; --auto
lin asylum_N = mkN "asil" masculine ; --auto
lin asymmetric_A = mkA "asimètric" ; --auto
lin asymmetry_N = mkN "asimetria" feminine ; --auto
lin asymptote_N = mkN "asímptota" feminine ; --auto
lin asymptotic_A = mkA "asimptòtic" ; --auto
lin asynchronous_A = mkA "asíncron" ; --auto
lin asyndetic_A = mkA "asindètic" ; --auto
lin asyndeton_N = mkN "asíndeton" masculine ; --auto
lin at_Prep = mkPrep "a" | mkPrep "en" ; --Depends on the definiteness of what follows it.
lin at_all_Adv = mkAdv "en absolut" | mkAdv "gens" ; --auto
lin at_least_AdN = mkAdv "almenys" | mkAdv "com a mínim" | mkAdv "si més no" ; --auto
lin ataxia_N = mkN "atàxia" feminine ; --auto
lin atelectasis_N = mkN "atelèctasi" feminine ; --auto
lin atenolol_N = mkN "atenolol" masculine ; --auto
lin atheism_N = mkN "ateisme" masculine ; --auto
lin atheist_N = mkN "ateu" | mkN "ateu" ; --auto
lin atheistic_A = mkA "ateu" ; --auto
lin athenianFem_N = variants {} ; ---- sense to be split
lin athenianMasc_N = variants {} ; ---- sense to be split
lin athens_1_PN = variants {} ; ---- sense to be split
lin athens_2_PN = variants {} ; ---- sense to be split
lin atheroma_N = mkN "ateroma" masculine ; --auto
lin atherosclerosis_N = mkN "aterosclerosi" feminine ; --auto
lin athetosis_N = mkN "atetosi" feminine ; --auto
lin athlete_N = mkN "atleta" ; --auto
lin athletic_A = mkA "atlètic" ; --auto
lin athletics_N = mkN "atletisme" masculine ; --auto
lin atlantic_A = mkA "atlàntic" ; --auto
lin atlas_N = mkN "atles" masculine | mkN "atles" masculine ; --auto
lin atmosphere_N = mkN "atmosfera" feminine ; --auto
lin atmospheric_A = mkA "atmosfèric" ; --auto
lin atoll_N = mkN "atol" masculine ; --auto
lin atom_N = mkN "àtom" masculine ; --auto
lin atomic_A = mkA "atòmic" ; --auto
lin atomism_N = mkN "atomisme" masculine ; --auto
lin atomistic_A = mkA "atomístic" ; --auto
lin atomizer_N = mkN "atomitzador" masculine ; --auto
lin atonic_A = mkA "àton" ; --auto
lin atonicity_N = mkN "atonicitat" feminine ; --auto
lin atresia_N = mkN "atrèsia" feminine ; --auto
lin atrium_N = mkN "atri" masculine ; --auto
lin atrocity_N = mkN "atrocitat" feminine ; --auto
lin atrophy_N = mkN "atròfia" feminine ; --auto
lin atropine_N = mkN "atropina" feminine ; --auto
lin attach_V = mkV "adjuntar" | mkV "subjectar" ; --auto
lin attach_V2 = mkV2 "adjuntar" | mkV2 "subjectar" ; --auto
lin attachable_A = mkA "embargable" ; --auto
lin attack_N = mkN "atac" masculine ;
lin attack_V2 = mkV2 (mkV "atacar") ;
lin attacker_N = mkN "atacant" ; --auto
lin attain_V = mkV "assolir" ; --auto
lin attain_V2 = mkV2 "assolir" ; --auto
lin attainable_A = mkA "realitzable" ; --auto
lin attainment_N = mkN "assoliment" masculine ; --auto
lin attempt_1_N = variants {} ; ---- sense to be split
lin attempt_2_N = variants {} ; ---- sense to be split
lin attempt_V2 = mkV2 (mkV "intentar") ;
lin attempt_VV = mkVV (mkV "intentar") ;
lin attend_V = mkV (servir_101 "assistir") ;
lin attend_V2 = mkV2 (mkV (servir_101 "assistir")) ;
lin attendant_N = mkN "encarregat" | mkN "encarregat" ; --auto
lin attention_N = mkN "atenció" feminine ;
lin attentive_A = mkA "atent" ; --auto
lin attest_V = mkV "testificar" ; --auto
lin attest_V2 = mkV2 "testificar" ; --auto
lin attestation_N = mkN "atestació" feminine ; --auto
lin attic_N = mkN "àtic" masculine ; --auto
lin attitude_N = mkN "actitud" feminine ;
lin attorney_N = mkN "advocat" masculine ; --auto
lin attract_V2 = mkV2 "atreure" ; --auto
lin attraction_N = mkN "atracció" feminine ; --auto
lin attractive_A = mkA "atractiu" ; --auto
lin attribute_N = mkN "atribut" masculine ; --auto
lin attribute_V2 = mkV2 "atribuir" ; --auto
lin attribution_N = mkN "atribució" feminine ; --auto
lin aubergine_N = mkN "albergínia" feminine ; --auto
lin auction_N = mkN "subhasta" feminine ; --auto
lin auction_V2 = mkV2 "subhastar" ; --auto
lin auctioneer_N = mkN "subhastador" | mkN "subhastador" ; --auto
lin audacious_A = mkA "audaç" ; --auto
lin audacity_N = mkN "gosadia" feminine ; --auto
lin audibility_N = mkN "audibilitat" feminine ; --auto
lin audible_A = mkA "audible" | mkA "sonor" ; --auto
lin audience_N = mkN "públic" masculine ;
lin audio_N = mkN "àudio" masculine ; --auto
lin audiogram_N = mkN "audiograma" masculine ; --auto
lin audiometer_N = mkN "audiòmetre" masculine ; --auto
lin audiometry_N = mkN "audiometria" feminine ; --auto
lin audiovisual_A = mkA "audiovisual" ; --auto
lin audit_N = mkN "auditoria" feminine ; --auto
lin audit_V2 = mkV2 "auditar" ; --auto
lin audition_N = mkN "audició" feminine ; --auto
lin auditor_N = mkN "auditor" | mkN "auditor" ; --auto
lin auditorium_N = mkN "auditori" masculine ; --auto
lin augite_N = mkN "augita" feminine ; --auto
lin augur_N = mkN "àugur" masculine ; --auto
lin aunt_N = mkN "tia" feminine ; --auto
lin aura_N = mkN "aura" feminine ; --auto
lin aureole_N = mkN "aurèola" feminine ; --auto
lin auricula_N = mkN "aurícula" feminine ; --auto
lin auricular_A = mkA "auricular" ; --auto
lin auscultation_N = mkN "auscultació" feminine ; --auto
lin auspice_N = mkN "auspici" masculine ; --auto
lin austenite_N = mkN "austenita" feminine ; --auto
lin australianFem_N = variants {} ; ---- sense to be split
lin australianMasc_N = variants {} ; ---- sense to be split
lin australian_A = mkA "australià" ; --auto
lin austrianFem_N = variants {} ; ---- sense to be split
lin austrianMasc_N = variants {} ; ---- sense to be split
lin austrian_A = mkA "austríac" ; --auto
lin autarchic_A = mkA "autàrquic" ; --auto
lin autarchy_N = mkN "autarquia" feminine ; --auto
lin authentic_A = mkA "autèntic" ; --auto
lin authenticate_V2 = mkV2 "autenticar" ; --auto
lin author_N = mkN "autor" ;
lin authoritarian_A = mkA "autoritari" ; --auto
lin authoritarianism_N = mkN "autoritarisme" masculine ; --auto
lin authority_1_N = mkN "autoritat" feminine ;
lin authority_2_N = mkN "autoritat" feminine ;
lin autism_N = mkN "autisme" masculine ; --auto
lin auto_N = mkN "cotxe" masculine ; --auto
lin autoantibody_N = mkN "autoanticòs" masculine ; --auto
lin autobiographical_A = mkA "autobiogràfic" ; --auto
lin autobiography_N = mkN "autobiografia" feminine ; --auto
lin autocatalysis_N = mkN "autocatàlisi" feminine ; --auto
lin autochthonous_A = mkA "autòcton" ; --auto
lin autoclave_N = mkN "autoclau" feminine ; --auto
lin autocratic_A = mkA "autocràtic" ; --auto
lin autogamy_N = mkN "autogàmia" feminine ; --auto
lin autograft_N = mkN "autoempelt" masculine ; --auto
lin autoimmunity_N = mkN "autoimmunitat" feminine ; --auto
lin autolysis_N = mkN "autòlisi" feminine ; --auto
lin automate_V2 = mkV2 "automatitzar" ; --auto
lin automatic_A = mkA "automàtic" ; --auto
lin automation_N = mkN "automatització" feminine ; --auto
lin automatism_N = mkN "automatisme" masculine ; --auto
lin automaton_N = mkN "autòmat" masculine ; --auto
lin autonomic_A = mkA "autonòmic" ; --auto
lin autonomous_A = mkA "autònom" ; --auto
lin autonomy_N = mkN "autonomia" feminine ; --auto
lin autopsy_N = mkN "autòpsia" feminine ; --auto
lin autosome_N = mkN "autosoma" masculine ; --auto
lin autosuggestion_N = mkN "autosuggestió" feminine ; --auto
lin autotrophic_A = mkA "autòtrof" ; --auto
lin autumn_N = mkN "tardor" feminine ; --auto
lin auxiliary_A = mkA "auxiliar" ; --auto
lin auxiliary_N = mkN "auxiliar" ; --auto
lin availability_N = mkN "disponibilitat" feminine ; --auto
lin available_A = mkA "disponible" ;
lin avalanche_N = mkN "allau" feminine ; --auto
lin avarice_N = mkN "avarícia" feminine ; --auto
lin avatar_N = mkN "avatar" masculine ; --auto
lin avenge_V2 = mkV2 "venjar" ; --auto
lin avenue_N = mkN "avinguda" feminine ; --auto
lin average_A = mkA "mitjà" ; --auto
lin average_N = mkN "mitjana" feminine ; --auto
lin aversion_N = mkN "aversió" feminine ; --auto
lin avian_A = mkA "aviari" ; --auto
lin aviation_N = mkN "aviació" feminine ; --auto
lin aviatorFem_N = variants {} ; ---- sense to be split
lin aviatorMasc_N = variants {} ; ---- sense to be split
lin avid_A = mkA "àvid" ; --auto
lin avionics_N = mkN "aviònica" feminine ; --auto
lin avitaminosis_N = mkN "avitaminosi" feminine ; --auto
lin avocado_N = mkN "alvocat" masculine ; --auto
lin avoid_V2 = mkV2 (mkV "evitar") ;
lin avoid_VV = mkVV (mkV "evitar") ;
lin avoidable_A = mkA "evitable" ; --auto
lin avoidance_N = mkN "evitació" feminine ; --auto
lin await_V2 = mkV2 "esperar" ; --auto
lin awake_A = mkA "despert" ; --auto
lin awake_V = mkV "despertar" ; --auto
lin awaken_V2 = mkV2 "despertar" ; --auto
lin award_N = mkN "premi" masculine ;
lin award_V2 = mkV2 (mkV "atorgar") ;
lin award_V3 = dirdirV3 (mkV "atorgar") ;
lin aware_A = mkA "conscient" ;
lin awareness_N = mkN "conscienciació" feminine ; --auto
lin away_1_Adv = mkAdv "fora" ; --in Catalan should be incorporated into the verb "marxar" vs "go away"
lin away_2_Adv = mkAdv "fora" ; --in Catalan should be incorporated into the verb "marxar" vs "go away"
lin awful_A = mkA "terrible" ; --auto
lin awkward_A = mkA "incòmode" ; --auto
lin awl_N = mkN "alena" feminine ; --auto
lin awning_N = mkN "tendal" masculine ; --auto
lin axe_N = mkN "destral" feminine ; --auto
lin axial_A = mkA "axial" ; --auto
lin axillary_A = mkA "axil·lar" ; --auto
lin axiology_N = mkN "axiologia" feminine ; --auto
lin axiom_N = mkN "axioma" masculine ; --auto
lin axiomatic_A = mkA "axiomàtic" ; --auto
lin axis_N = mkN "eix" masculine ; --auto
lin axle_N = mkN "eix" masculine ; --auto
lin axolemma_N = mkN "axolemma" masculine ; --auto
lin axon_N = mkN "axó" masculine ; --auto
lin azalea_N = mkN "azalea" feminine ; --auto
lin azimuth_N = mkN "azimut" masculine ; --auto
lin azimuthal_A = mkA "azimutal" ; --auto
lin azurite_N = mkN "atzurita" feminine ; --auto
lin baboon_N = mkN "mandril" masculine ; --auto
lin baby_N = L.baby_N ;
lin bacillus_N = mkN "bacil" masculine ; --auto
lin bacitracin_N = mkN "bacitracina" feminine ; --auto
lin back_A = mkA "posterior" ; --auto
lin back_Adv = mkAdv "enrere" ;
lin back_N = L.back_N ;
lin back_V = mkV "donar suport a" | mkV "recular" ; --auto
lin back_away_V = advV OP_back_V OP_away_Adv ; -- guess-p-verb
lin back_down_V = advV OP_back_V OP_down_Adv ; -- guess-p-verb
lin back_into_V3 = variants {} ; -- guess-p-verb
lin back_off_V = advV OP_back_V OP_off_Adv ; -- guess-p-verb
lin back_out_V = advV OP_back_V OP_out_Adv ; -- guess-p-verb
lin back_out_of_V2 = prepV2 (advV OP_back_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin back_out_of_V3 = variants {} ; -- guess-p-verb
lin back_up_V = advV OP_back_V OP_up_Adv ; -- guess-p-verb
lin back_up_1_V2 = prepV2 OP_back_V OP_up_Prep ; -- guess-p-verb
lin back_up_2_V2 = prepV2 OP_back_V OP_up_Prep ; -- guess-p-verb
lin backdrop_N = mkN "rerefons" masculine | mkN "rerefons" masculine ; --auto
lin backerFem_N = variants {} ; ---- sense to be split
lin backerMasc_N = variants {} ; ---- sense to be split
lin backflow_N = mkN "reflux" masculine ; --auto
lin background_N = mkN "fons" masculine ;
lin backpack_N = mkN "motxilla" feminine ; --auto
lin backstage_Adv = mkAdv "entre bastidors" | mkAdv "rereescenari" ; --auto
lin backstitch_N = mkN "repunt" masculine ; --auto
lin back_up_N = mkN "còpia de seguretat" feminine ; --auto
lin backyard_N = mkN "pati del darrere" masculine ; --auto
lin bacon_N = mkN "cansalada" feminine ; --auto
lin bacteremia_N = mkN "bacterèmia" feminine ; --auto
lin bactericide_N = mkN "bactericida" feminine ; --auto
lin bacteriological_A = mkA "bacteriològic" ; --auto
lin bacteriologist_N = mkN "bacteriòleg" feminine | mkN "bacteriòleg" masculine ; --auto
lin bacteriology_N = mkN "bacteriologia" feminine ; --auto
lin bacteriolysis_N = mkN "bacteriòlisi" feminine ; --auto
lin bacterium_N = mkN "bacteri" masculine ; --auto
lin bad_A = L.bad_A ;
lin badge_N = mkN "placa" feminine ; --auto
lin badger_N = mkN "teixó" masculine ; --auto
lin badminton_N = mkN "bàdminton" masculine ; --auto
lin baffle_V2 = mkV2 "desconcertar" ; --auto
lin bag_N = mkN "bossa" feminine ;
lin bagatelle_N = mkN "bagatel·la" feminine ; --auto
lin baggage_N = mkN "equipatge" masculine ; --auto
lin bagger_N = mkN "ensacador" feminine | mkN "ensacador" masculine ; --auto
lin bagpipe_N = mkN "gaita" feminine ; --auto
lin bail_N = mkN "fiança" feminine ; --auto
lin bailiff_N = mkN "algutzir" masculine ; --auto
lin bait_N = mkN "esquer" masculine ; --auto
lin bake_V = mkV "coure" ; --auto
lin bake_V2 = mkV2 "coure" ; --auto
lin bakelite_N = mkN "baquelita" feminine ; --auto
lin baker_N = mkN "forner" | mkN "forner" ; --auto
lin bakery_N = mkN "fleca" feminine ; --auto
lin baking_powder_N = mkN "llevat en pols" masculine ; --auto
lin balance_N = mkN "equilibri" masculine ;
lin balance_V = mkV "equilibrar" ; --auto
lin balance_V2 = mkV2 "equilibrar" ; --auto
lin balance_sheet_N = mkN "balanç de situació" masculine ; --auto
lin balcony_N = mkN "balcó" masculine ; --auto
lin baldness_N = mkN "calvície" feminine ; --auto
lin bale_N = mkN "paca" feminine ; --auto
lin ball_N = mkN "pilota" feminine ;
lin ballade_N = mkN "balada" feminine ; --auto
lin ballast_N = mkN "llast" masculine ; --auto
lin ballet_N = mkN "ballet" masculine ; --auto
lin ballistic_A = mkA "balístic" ; --auto
lin ballistics_N = mkN "balística" feminine ; --auto
lin balloon_N = mkN "baló" masculine ; --auto
lin balm_N = mkN "bàlsam" masculine ; --auto
lin balsam_N = mkN "bàlsam" masculine ; --auto
lin baluster_N = mkN "balustre" masculine ; --auto
lin bamboo_N = mkN "bambú" masculine ; --auto
lin ban_N = mkN "prohibició" feminine ; --auto
lin ban_V2 = mkV2 "prohibir" ; --auto
lin banana_N = mkN "plàtan" masculine ; --auto
lin band_N = mkN "grup" masculine ;
lin band_V = mkV "embolcar" ; --auto
lin band_V2 = mkV2 "embolcar" ; --auto
lin bandage_N = mkN "bena" feminine | mkN "embenat" masculine ; --auto
lin bandit_N = mkN "bandit" feminine | mkN "bandit" masculine ; --auto
lin bandwidth_N = mkN "ample de banda" masculine ; --auto
lin bang_N = mkN "cop de porta" masculine | mkN "estrèpit" masculine | mkN "portada" feminine ; --auto
lin bang_V = mkV "petar" ; --auto
lin bang_V2 = mkV2 "petar" ; --auto
lin bangle_N = mkN "polsera" feminine ; --auto
lin banish_V2 = mkV2 "esfumar" ; --auto
lin banishment_N = mkN "desterrament" masculine ; --auto
lin banister_N = mkN "brèndola" feminine ; --auto
lin bank_1_N = L.bank_N ;
lin bank_2_N = L.bank_N ;
lin bank_V = mkV "amuntegar" ; --auto
lin bank_V2 = mkV2 "amuntegar" ; --auto
lin banker_N = mkN "banquer" | mkN "banquer" ; --auto
lin banking_N = mkN "banca" feminine ; --auto
lin bankruptcy_N = mkN "bancarrota" feminine ; --auto
lin banner_N = mkN "pancarta" feminine ; --auto
lin banquet_N = mkN "banquet" masculine ; --auto
lin baptism_N = mkN "baptisme" masculine ; --auto
lin bar_1_N = mkN "bar" masculine ;
lin bar_2_N = mkN "bar" masculine ;
lin barb_N = mkN "dicteri" masculine ; --auto
lin barbarian_N = mkN "bàrbar" feminine | mkN "bàrbar" masculine ; --auto
lin barbaric_A = mkA "bàrbar" ; --auto
lin barbarism_N = mkN "barbarisme" masculine ; --auto
lin barbecue_N = mkN "barbacoa" feminine ; --auto
lin barbershop_N = mkN "barberia" feminine ; --auto
lin barcarole_N = mkN "barcarola" feminine ; --auto
lin bard_N = mkN "bard" masculine ; --auto
lin barefoot_A = mkA "descalç" ; --auto
lin barely_Adv = mkAdv "a penes" ; --auto
lin bargain_N = mkN "ganga" feminine | mkN "negoci" masculine ; --auto
lin baritone_N = mkN "baríton" masculine ; --auto
lin barium_N = mkN "bari" masculine ; --auto
lin bark_N = mkN "lladruc" masculine ; --auto
lin bark_V = mkV "bordar" ; --auto
lin bark_V2 = mkV2 "bordar" ; --auto
lin barley_N = mkN "ordi" masculine ; --auto
lin barograph_N = mkN "barògraf" masculine ; --auto
lin barometer_N = mkN "baròmetre" masculine ; --auto
lin barometric_A = mkA "baromètric" ; --auto
lin baron_N = mkN "baró" feminine | mkN "baró" masculine ; --auto
lin barony_N = mkN "baronia" feminine ; --auto
lin baroque_N = mkN "barroc" masculine ; --auto
lin barrack_N = mkN "barraca" feminine ; --auto
lin barracks_N = mkN "caserna" feminine ; --auto
lin barrel_N = mkN "tonell" masculine ; --auto
lin barren_A = mkA "estèril" ; --auto
lin barricade_N = mkN "barricada" feminine ; --auto
lin barrier_N = mkN "barrera" feminine ; --auto
lin barter_N = mkN "permuta" feminine ; --auto
lin barycenter_N = mkN "baricentre" masculine ; --auto
lin baryon_N = mkN "barió" masculine ; --auto
lin baryta_N = mkN "barita" feminine ; --auto
lin basal_A = mkA "basal" ; --auto
lin basalt_N = mkN "basalt" masculine ; --auto
lin base_N = mkN "base" feminine ;
lin base_V = mkV "basar" | mkV "fonamentar" ;
lin base_V2 = mkV2 (mkV "basar") | mkV2 (mkV "fonamentar") ;
lin baseball_N = mkN "beisbol" masculine ; --auto
lin basic_A = mkA "bàsic" ;
lin basically_Adv = mkAdv "bàsicament" ; --auto
lin basil_N = mkN "alfàbrega" feminine ; --auto
lin basilica_N = mkN "basílica" feminine ; --auto
lin basis_N = mkN "base" feminine ;
lin basket_N = mkN "cistella" feminine ; --auto
lin basketball_N = mkN "bàsquet" masculine ; --auto
lin basophilia_N = mkN "basofília" feminine ; --auto
lin basque_A = mkA "basc" ; --auto
lin bass_N = mkN "baix" masculine ; --auto
lin bassoon_N = mkN "fagot" masculine ; --auto
lin bast_N = mkN "líber" masculine ; --auto
lin bastion_N = mkN "baluard" masculine ; --auto
lin bat_N = mkN "bat" masculine | mkN "ratpenat" masculine ; --auto
lin batch_N = mkN "lot" masculine | mkN "tanda" feminine ; --auto
lin bath_N = mkN "banyera" feminine | mkN "bany" masculine ; --auto
lin bathe_V = mkV "banyar" ; --auto
lin bathe_V2 = mkV2 "banyar" ; --auto
lin bathroom_N = mkN "bany" masculine ; --auto
lin bathyal_A = mkA "batial" ; --auto
lin batik_N = mkN "bàtik" masculine ; --auto
lin batiste_N = mkN "batista" feminine ; --auto
lin baton_N = mkN "batuta" feminine ; --auto
lin battery_1_N = mkN "bateria" feminine | mkN "pila" feminine ; --auto
lin battery_2_N = mkN "bateria" feminine | mkN "pila" feminine ; --auto
lin batting_N = mkN "batuda" feminine ; --auto
lin battle_N = mkN "batalla" feminine ;
lin battlefront_N = mkN "front de batalla" masculine ; --auto
lin battleship_N = mkN "cuirassat" masculine ; --auto
lin baud_N = mkN "baud" masculine ; --auto
lin bauxite_N = mkN "bauxita" feminine ; --auto
lin bay_N = mkN "badia" feminine | mkN "llorer" masculine ; --auto
lin bayonet_N = mkN "baioneta" feminine ; --auto
lin bazaar_N = mkN "basar" masculine ; --auto
lin beach_N = mkN "platja" feminine ; --auto
lin beacon_N = mkN "balisa" feminine ; --auto
lin bead_N = mkN "gra" masculine ; --auto
lin beading_N = mkN "bordonament" masculine ; --auto
lin beak_N = mkN "bec" masculine ; --auto
lin beaker_N = mkN "gobelet" masculine ; --auto
lin beam_N = mkN "biga" feminine ; --auto
lin bean_N = mkN "mongeta" feminine ; --auto
lin bear_N = mkN "ós" | mkN "ós" ; --auto
lin bear_V = mkV "aguantar" | mkV "suportar" ;
lin bear_V2 = mkV2 (mkV "suportar") | mkV2 (mkV "agunatar") ;
lin bear_down_on_V2 = prepV2 (advV OP_bear_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin bear_on_V2 = prepV2 OP_bear_V OP_on_Prep ; -- guess-p-verb
lin bear_out_V2 = prepV2 OP_bear_V OP_out_Prep ; -- guess-p-verb
lin bear_up_V = advV OP_bear_V OP_up_Adv ; -- guess-p-verb
lin bear_up_under_V2 = prepV2 (advV OP_bear_V OP_up_Adv ) OP_under_Prep ; -- guess-p-verb
lin bear_with_V2 = prepV2 OP_bear_V OP_with_Prep ; -- guess-p-verb
lin bearable_A = mkA "suportable" ; --auto
lin beard_N = mkN "barba" feminine ; --auto
lin bearer_N = mkN "portador" | mkN "portador" ; --auto
lin beast_N = mkN "bèstia" feminine ; --auto
lin beat_N = mkN "batec" masculine ; --auto
lin beat_V = mkV "derrotar" ; --split "pegar" (win vs. hit)
lin beat_V2 = mkV2 (mkV "derrotar") ; --split
lin beat_back_V = advV OP_beat_V OP_back_Adv ; -- guess-p-verb
lin beat_down_V = advV OP_beat_V OP_down_Adv ; -- guess-p-verb
lin beat_down_V2 = prepV2 OP_beat_V OP_down_Prep ; -- guess-p-verb
lin beat_out_V2 = prepV2 OP_beat_V OP_out_Prep ; -- guess-p-verb
lin beat_up_V2 = prepV2 OP_beat_V OP_up_Prep ; -- guess-p-verb
lin beau_N = mkN "pretendent" ; --auto
lin beautician_N = mkN "esteticista" ; --auto
lin beautiful_A = L.beautiful_A ;
lin beauty_N = mkN "bellesa" feminine ; --auto
lin beaver_N = mkN "castor" masculine ; --auto
lin because_Subj = S.because_Subj ;
lin because_of_Prep = mkPrep "a causa de" ; --auto
lin become_V = reflV (mkV "tornar") ;
lin become_V2 = mkV2 (reflV (verbV (servir_101 "convertir"))) (mkPrep "en") ;
lin become_VA = L.become_VA ;
lin bed_N = mkN "llit" masculine ;
lin bed_V2 = mkV2 "encastar" ; --auto
lin bedroom_N = mkN "dormitori" masculine ; --auto
lin bedspread_N = mkN "cobrellit" masculine ; --auto
lin bee_N = mkN "abella" feminine ; --auto
lin beech_N = mkN "faig" masculine ; --auto
lin beechnut_N = mkN "radioenllaç" masculine ; --auto
lin beef_1_N = mkN "vedella" feminine ; --auto
lin beef_2_N = mkN "vedella" feminine ; --auto
lin beer_N = L.beer_N ;
lin beetle_N = mkN "escarabat" masculine ; --auto
lin beetroot_N = mkN "remolatxa" feminine ; --auto
lin before_Adv = variants {} ; -- S.before_Prep ;
lin before_Prep = S.before_Prep ;
lin before_Subj = mkSubj "abans que" Conjunct ;
lin beforehand_Adv = mkAdv "per endavant" ; --auto
lin beg_V = variants {} ; -- L.beg_V2V ; -- comment=CHECKED
lin beg_V2 = variants {} ; -- L.beg_V2V ; -- comment=CHECKED
lin beggar_N = mkN "captaire" ; --auto
lin begin_V = mkV "començar" ;
lin begin_V2 = mkV2 (mkV "començar") ;
lin beginner_N = mkN "principiant" ; --auto
lin beginning_N = mkN "inici" masculine ;
lin behave_V = mkV "comportar-se" ; --auto
lin behaviour_N = mkN "comportament" masculine ;
lin behaviourism_N = mkN "behaviorisme" masculine | mkN "conductisme" masculine ; --auto
lin behaviourist_N = mkN "conductista" ; --auto
lin behind_Adv = variants {} ; -- S.behind_Prep ;
lin behind_Prep = S.behind_Prep ;
lin beige_A = mkA "beix" ; --auto
lin being_N = mkN "ésser" masculine | mkN "ser" masculine ; --auto
lin belated_A = mkA "tardà" ; --auto
lin belgian_A = mkA "belga" ;
lin belief_N = mkN "creença" feminine ;
lin believe_V = verbV (creure_34 "creure") ;
lin believe_V2 = mkV2 (verbV (creure_34 "creure")) ;
lin believe_VS = mkVS (verbV (creure_34 "creure")) ;
lin believer_N = mkN "creient" ; --auto
lin bell_N = mkN "campana" feminine | mkN "timbre" masculine ; --auto
lin bellboy_N = mkN "grum" masculine ; --auto
lin belligerency_N = mkN "bel·ligerància" feminine ; --auto
lin belligerent_A = mkA "bel·ligerant" ; --auto
lin belly_N = L.belly_N ;
lin belonging_N = mkN "pertinença" feminine ; --auto
lin below_Adv = mkAdv "sota" ;
lin below_Prep = mkPrep "sota" ; --auto
lin belt_N = mkN "cinturó" masculine | mkN "corretja" feminine ; --auto
lin bench_N = mkN "banc" masculine ; --auto
lin bend_N = mkN "corba" feminine | mkN "revolt" masculine ; --auto
lin bend_V = mkV "doblegar" | mkV "inclinar" ; --auto
lin bend_V2 = mkV2 "doblegar" | mkV2 "inclinar" ; --auto
lin bend_down_V = advV OP_bend_V OP_down_Adv ; -- guess-p-verb
lin bend_over_V = advV OP_bend_V OP_over_Adv ; -- guess-p-verb
lin bend_over_backwards_V = variants {} ; -- guess-p-verb
lin bending_N = mkN "torcement" masculine ; --auto
lin beneath_Adv = mkAdv "a sota" ; --auto
lin beneficial_A = mkA "beneficiós" ; --auto
lin benefit_N = mkN "benefici" masculine ;
lin benefit_V = mkV "beneficiar" ; --auto
lin benefit_V2 = mkV2 "beneficiar" ; --auto
lin benevolence_N = mkN "benevolença" feminine ; --auto
lin benevolent_A = mkA "benèvol" ; --auto
lin benign_A = mkA "benigne" ; --auto
lin bentonite_N = mkN "bentonita" feminine ; --auto
lin benzine_N = mkN "benzina" feminine ; --auto
lin benzocaine_N = mkN "benzocaïna" feminine ; --auto
lin bequeath_V2 = mkV2 "llegar" ; --auto
lin berkelium_N = mkN "berkeli" masculine ; --auto
lin berlin_N = mkN "berlina" feminine ; --auto
lin berm_N = mkN "relleix" masculine ; --auto
lin beryllium_N = mkN "beril·li" masculine ; --auto
lin beside_Prep = mkPrep "al costat de" ; --auto
lin besides_Adv = mkAdv "a més" ; --auto
lin besiege_V2 = mkV2 "assetjar" ; --auto
lin best_Adv = mkAdv "millor" ;
lin bestial_A = mkA "bestial" ; --auto
lin bestiality_N = mkN "bestialitat" feminine ; --auto
lin best_seller_N = mkN "best seller" masculine ; --auto
lin bet_N = mkN "aposta" feminine ; --auto
lin bet_V = mkV "apostar" ; --auto
lin bet_V2 = mkV2 "apostar" ; --auto
lin beta_N = mkN "beta" feminine ; --auto
lin betatron_N = mkN "betatró" masculine ; --auto
lin betel_N = mkN "bètel" masculine ; --auto
lin betray_V2 = mkV2 "trair" ; --auto
lin betrayal_N = mkN "traïció" feminine ; --auto
lin betrayer_N = mkN "traïdor" | mkN "traïdor" ; --auto
lin betrothedFem_N = variants {} ; ---- sense to be split
lin betrothedMasc_N = variants {} ; ---- sense to be split
lin better_Adv = mkAdv "millor" ;
lin between_Prep = S.between_Prep ;
lin bevatron_N = mkN "bevatró" masculine ; --auto
lin bevel_N = mkN "bisell" masculine ; --auto
lin bewitch_V2 = mkV2 "embruixar" ; --auto
lin beyond_Adv = mkAdv "més enllà" ; --auto
lin beyond_Prep = mkPrep "més enllà de" ;
lin bezel_N = mkN "xató" masculine ; --auto
lin bias_N = mkN "biaix" masculine ; --auto
lin bias_V2 = mkV2 "predisposar" ; --auto
lin bib_N = mkN "pitet" masculine ; --auto
lin bible_N = mkN "bíblia" feminine ; --auto
lin biblical_A = mkA "bíblic" ; --auto
lin bibliographer_N = mkN "bibliògraf" | mkN "bibliògraf" ; --auto
lin bibliographic_A = mkA "bibliogràfic" ; --auto
lin bibliography_N = mkN "bibliografia" feminine ; --auto
lin bibliomania_N = mkN "bibliomania" feminine ; --auto
lin bicameral_A = mkA "bicameral" ; --auto
lin bicarbonate_N = mkN "bicarbonat" masculine ; --auto
lin biceps_N = mkN "bíceps" masculine | mkN "bíceps" masculine ; --auto
lin biconvex_A = mkA "biconvex" ; --auto
lin bicycle_N = mkN "bicicleta" feminine ; --auto
lin bid_N = mkN "intent" masculine | mkN "oferta" feminine ; --auto
lin bid_V = mkV "licitar" ; --auto
lin bid_V2 = mkV2 "licitar" ; --auto
lin bidder_N = mkN "licitador" feminine | mkN "licitador" masculine ; --auto
lin bidding_N = mkN "licitació" feminine ; --auto
lin bidet_N = mkN "bidet" masculine ; --auto
lin bidirectional_A = mkA "bidireccional" ; --auto
lin biennial_A = mkA "biennal" ; --auto
lin bifocals_N = mkN "bifocals" masculine ; --auto
lin bifurcation_N = mkN "bifurcació" feminine ; --auto
lin big_A = L.big_A ;
lin bigamist_N = mkN "bígam" | mkN "bígam" ; --auto
lin bigamous_A = mkA "bígam" ; --auto
lin bigamy_N = mkN "bigàmia" feminine ; --auto
lin bike_N = L.bike_N ;
lin bikini_N = mkN "biquini" masculine ; --auto
lin bilabial_A = mkA "bilabial" ; --auto
lin bilateral_A = mkA "bilateral" ; --auto
lin bilaterality_N = mkN "bilateralitat" feminine ; --auto
lin bilberry_N = mkN "mirtil" masculine ; --auto
lin bilingual_A = mkA "bilingüe" ; --auto
lin bilingualism_N = mkN "bilingüisme" masculine ; --auto
lin bilirubin_N = mkN "bilirubina" feminine ; --auto
lin bill_N = mkN "bitllet" masculine ; --split "llei" (bank bill vs. law)
lin bill_V = mkV "enunciar" ; --auto
lin bill_V2 = mkV2 "enunciar" ; --auto
lin billet_N = mkN "hostatge" masculine ; --auto
lin billet_V2 = mkV2 "allotjar" ; --auto
lin billhook_N = mkN "podall" masculine ; --auto
lin billion_N = mkN "mil-milions" masculine | mkN "mil milions" masculine | mkN "mil milions" masculine ; --auto
lin billy_goat_N = mkN "boc" masculine ; --auto
lin binary_A = mkA "binari" ; --auto
lin binaural_A = mkA "binaural" ; --auto
lin bind_V = mkV (servir_101 "unir") ;
lin bind_V2 = mkV2 (mkV (servir_101 "unir")) ;
lin binder_N = mkN "aglomerant" masculine | mkN "lligant" masculine ; --auto
lin binding_A = mkA "obligatori" ; --auto
lin binoculars_N = mkN "prismàtics" masculine ; --auto
lin binomial_A = mkA "binomial" ; --auto
lin binomial_N = mkN "binomi" masculine ; --auto
lin biochemical_A = mkA "bioquímic" ; --auto
lin biochemist_N = mkN "bioquímic" feminine | mkN "bioquímic" masculine ; --auto
lin biochemistry_N = mkN "bioquímica" feminine ; --auto
lin bioclimatic_A = mkA "bioclimàtic" ; --auto
lin bioclimatology_N = mkN "bioclimatologia" feminine ; --auto
lin biodegradable_A = mkA "biodegradable" ; --auto
lin bioethics_N = mkN "bioètica" feminine ; --auto
lin biogenesis_N = mkN "biogènesi" feminine ; --auto
lin biogeography_N = mkN "biogeografia" feminine ; --auto
lin biographer_N = mkN "biògraf" | mkN "biògraf" ; --auto
lin biographical_A = mkA "biogràfic" ; --auto
lin biography_N = mkN "biografia" feminine ; --auto
lin biological_A = mkA "biològic" ; --auto
lin biologist_N = mkN "biòleg" | mkN "biòleg" ; --auto
lin biology_N = mkN "biologia" feminine ; --auto
lin bioluminescence_N = mkN "bioluminescència" feminine ; --auto
lin biomass_N = mkN "biomassa" feminine ; --auto
lin biome_N = mkN "bioma" masculine ; --auto
lin biomedicine_N = mkN "biomedicina" feminine ; --auto
lin biometrics_N = mkN "biometria" feminine ; --auto
lin biophysicist_N = mkN "biofísic" feminine | mkN "biofísic" masculine ; --auto
lin biophysics_N = mkN "biofísica" feminine ; --auto
lin biopsy_N = mkN "biòpsia" feminine ; --auto
lin biosphere_N = mkN "biosfera" feminine ; --auto
lin biosynthesis_N = mkN "biosíntesi" feminine ; --auto
lin biotechnology_N = mkN "biotecnologia" feminine ; --auto
lin biotic_A = mkA "biòtic" ; --auto
lin biotite_N = mkN "biotita" feminine ; --auto
lin biotype_N = mkN "biotip" masculine ; --auto
lin bipolar_A = mkA "bipolar" ; --auto
lin biquadratic_A = mkA "biquadràtic" ; --auto
lin birch_N = mkN "bedoll" masculine ; --auto
lin bird_N = L.bird_N ;
lin birefringent_A = mkA "birefringent" ; --auto
lin birth_N = mkN "naixement" masculine ; --auto
lin birthday_N = mkN "aniversari" masculine ; --auto
lin biscuit_N = mkN "galeta" feminine ; --auto
lin bisect_V2 = mkV2 "bisecar" ; --auto
lin bisection_N = mkN "bisecció" feminine ; --auto
lin bisexuality_N = mkN "bisexualitat" feminine ; --auto
lin bishop_N = mkN "bisbe" masculine ; --auto
lin bishopric_N = mkN "bisbat" masculine ; --auto
lin bismuth_N = mkN "bismut" masculine ; --auto
lin bison_N = mkN "bisó" masculine ; --auto
lin bit_N = mkN "mica" feminine ;
lin bite_N = mkN "mossegada" feminine | mkN "picada" feminine ; --auto
lin bite_V = variants {} ; -- L.bite_V2 ;
lin bite_V2 = L.bite_V2 ;
lin bitter_A = mkA "amarg" ; --auto
lin bitterness_N = mkN "amargor" feminine ; --auto
lin bitumen_N = mkN "betum" masculine ; --auto
lin bituminous_A = mkA "bituminós" ; --auto
lin bivalve_A = mkA "bivalve" ; --auto
lin bivouac_N = mkN "bivac" masculine ; --auto
lin bizarre_A = mkA "estrany" ; --auto
lin black_A = L.black_A ;
lin black_N = mkN "negre" | mkN "negre" feminine | mkN "negre" | mkN "negre" masculine ; --auto
lin blackberry_N = mkN "móra" feminine ; --auto
lin blackbird_N = mkN "merla" feminine ; --auto
lin blackboard_N = mkN "pissarra" feminine ; --auto
lin blacken_V = mkV "ennegrir" ; --auto
lin blacken_V2 = mkV2 "ennegrir" ; --auto
lin blackening_N = mkN "ennegriment" masculine ; --auto
lin blackhead_N = mkN "barb" masculine ; --auto
lin blackmail_N = mkN "xantatge" masculine ; --auto
lin blackmailer_N = mkN "xantatgista" ; --auto
lin blackout_N = mkN "apagada" feminine ; --auto
lin blackthorn_N = mkN "aranyoner" masculine ; --auto
lin bladder_N = mkN "bufeta" feminine ; --auto
lin blade_N = mkN "fulla" feminine ; --auto
lin blame_N = mkN "culpa" feminine ; --auto
lin blame_V = mkV "culpar" ; --auto
lin blame_V2 = mkV2 "culpar" ; --auto
lin blameless_A = mkA "irreprotxable" ; --auto
lin blank_N = mkN "espai" masculine ; --auto
lin blanket_N = mkN "manta" feminine ; --auto
lin blasphemous_A = mkA "blasfem" ; --auto
lin blasphemy_N = mkN "blasfèmia" feminine ; --auto
lin blast_N = mkN "explosió" feminine ; --auto
lin blast_V = mkV "atacar" | mkV "volar" ; --auto
lin blast_V2 = mkV2 "atacar" | mkV2 "volar" ; --auto
lin blastema_N = mkN "blastema" masculine ; --auto
lin blastocoel_N = mkN "blastocel" masculine ; --auto
lin blastocyst_N = mkN "blastocist" masculine ; --auto
lin blastocyte_N = mkN "blastòcit" masculine ; --auto
lin blastoderm_N = mkN "blastoderma" masculine ; --auto
lin blastomere_N = mkN "blastòmer" masculine ; --auto
lin blastopore_N = mkN "blastòpor" masculine ; --auto
lin blastula_N = mkN "blàstula" feminine ; --auto
lin blatant_A = mkA "descarat" ; --auto
lin bleach_N = mkN "lleixiu" masculine ; --auto
lin bleach_V = mkV "blanquejar" ; --auto
lin bleach_V2 = mkV2 "blanquejar" ; --auto
lin bleacher_N = mkN "blanquejador" masculine ; --auto
lin bleat_V = mkV "belar" ; --auto
lin bleat_V2 = mkV2 "belar" ; --auto
lin bleeding_N = mkN "hemorràgia" feminine ; --auto
lin blend_N = mkN "mescla" feminine ; --auto
lin blend_V = mkV "mesclar" ; --auto
lin blend_V2 = mkV2 "mesclar" ; --auto
lin blender_N = mkN "mescladora" feminine ; --auto
lin blepharism_N = mkN "blefarisme" masculine ; --auto
lin bless_V2 = mkV2 "beneir" ; --auto
lin blessing_N = mkN "benedicció" feminine ; --auto
lin blind_A = mkA "cec" ; --auto
lin blind_V2 = mkV2 "cegar" ; --auto
lin blindness_N = mkN "ceguesa" feminine ; --auto
lin blindworm_N = mkN "lliseta" feminine ; --auto
lin blink_V = mkV "parpellejar" ; --auto
lin blink_V2 = mkV2 "parpellejar" ; --auto
lin bloated_A = mkA "inflat" ; --auto
lin block_N = mkN "bloc" masculine | mkN "bloqueig" masculine ; --auto
lin block_V2 = mkV2 "blocar" ; --auto
lin block_in_V2 = prepV2 (lin V OP_block_V2) OP_in_Prep ; -- guess-p-verb
lin block_off_V2 = prepV2 (lin V OP_block_V2) OP_off_Prep ; -- guess-p-verb
lin block_out_V2 = prepV2 (lin V OP_block_V2) OP_out_Prep ; -- guess-p-verb
lin block_up_V2 = prepV2 (lin V OP_block_V2) OP_up_Prep ; -- guess-p-verb
lin blockade_N = mkN "bloqueig" masculine ; --auto
lin blocking_N = mkN "blocatge" masculine ; --auto
lin blog_N = mkN "blog" masculine ; --auto
lin blogger_N = mkN "blocaire" ; --auto
lin blond_A = mkA "ros" ; --auto
lin blood_N = L.blood_N ;
lin blood_group_N = mkN "grup sanguini" masculine ; --auto
lin blood_vessel_N = mkN "vas sanguini" masculine ; --auto
lin bloodless_A = mkA "exsangüe" ; --auto
lin blood_letting_N = mkN "sagnia" feminine ; --auto
lin bloodshed_N = mkN "carnisseria" feminine ; --auto
lin bloodstream_N = mkN "torrent sanguini" masculine ; --auto
lin bloodsucker_N = mkN "sangonera" feminine ; --auto
lin bloom_V = mkV "florir" ; --auto
lin blouse_N = mkN "brusa" feminine ; --auto
lin blow_N = mkN "colp" masculine | mkN "cop" masculine ; --auto
lin blow_V = L.blow_V ;
lin blow_V2 = variants {} ; -- L.blow_V ;
lin blow_away_V = advV OP_blow_V OP_away_Adv ; -- guess-p-verb
lin blow_away_V2 = mkV2 (advV OP_blow_V OP_away_Adv ) ; -- guess-p-verb
lin blow_down_V2 = prepV2 OP_blow_V OP_down_Prep ; -- guess-p-verb
lin blow_dry_V2 = variants {} ; -- guess-p-verb
lin blow_in_V = advV OP_blow_V OP_in_Adv ; -- guess-p-verb
lin blow_off_V = advV OP_blow_V OP_off_Adv ; -- guess-p-verb
lin blow_off_V2 = prepV2 OP_blow_V OP_off_Prep ; -- guess-p-verb
lin blow_out_V2 = prepV2 OP_blow_V OP_out_Prep ; -- guess-p-verb
lin blow_over_V = advV OP_blow_V OP_over_Adv ; -- guess-p-verb
lin blow_up_V = advV OP_blow_V OP_up_Adv ; -- guess-p-verb
lin blow_up_V2 = prepV2 OP_blow_V OP_up_Prep ; -- guess-p-verb
lin blowing_N = mkN "bufat" masculine ; --auto
lin blue_A = L.blue_A ;
lin blue_N = mkN "blau" masculine ; --auto
lin blueberry_N = mkN "nabiu" masculine ; --auto
lin blueprint_N = mkN "cianografia" feminine | mkN "projecte" masculine ; --auto
lin blues_N = mkN "blues" masculine | mkN "blues" masculine ; --auto
lin bluff_N = mkN "cingle" masculine ; --auto
lin bluish_A = mkA "blavós" ; --auto
lin blunder_N = mkN "espifiada" feminine ; --auto
lin blunt_A = mkA "rom" ; --auto
lin blunt_V2 = mkV2 "esmussar" ; --auto
lin blur_V = mkV "entelar" ; --auto
lin blur_V2 = mkV2 "entelar" ; --auto
lin boa_N = mkN "boa" feminine ; --auto
lin board_1_N = mkN "tauló" masculine ; --split "junta directiva"
lin board_2_N = mkN "tauló" masculine ; --split "junta directiva"
lin board_V2 = mkV2 "entaular" ; --auto
lin boarding_N = mkN "abordatge" masculine ; --auto
lin boast_V = mkV "presumir" ; --auto
lin boast_V2 = mkV2 "presumir" ; --auto
lin boaster_N = mkN "fanfarró" masculine ; --auto
lin boastfulness_N = mkN "jactància" feminine ; --auto
lin boat_N = L.boat_N ;
lin boat_race_N = mkN "regata" feminine ; --auto
lin bobsled_N = mkN "bobsleigh" masculine ; --auto
lin bodice_N = mkN "cosset" masculine ; --auto
lin body_N = mkN "cos" masculine ;
lin bodybuilder_N = mkN "culturista" | mkN "fisicoculturista" ; --auto
lin bodyguard_N = mkN "guardaespatles" | mkN "guardaespatlles" ; --auto
lin bodywork_N = mkN "carrosseria" feminine ; --auto
lin bohemian_A = mkA "bohemi" ; --auto
lin boil_V = mkV "bullir" ; --auto
lin boil_V2 = mkV2 "bullir" ; --auto
lin boiler_N = mkN "caldera" feminine ; --auto
lin bold_1_A = mkA "atrevit" ; --auto
lin bold_2_A = mkA "atrevit" ; --auto
lin boldface_N = mkN "negreta" feminine ; --auto
lin bolivian_A = mkA "bolivià" ; --auto
lin bolivian_N = mkN "bolivià" | mkN "bolivià" ; --auto
lin bolometer_N = mkN "bolòmetre" masculine ; --auto
lin bolshevik_N = mkN "bolxevic" ; --auto
lin bolt_V = mkV "empernar" ; --auto
lin bolt_V2 = mkV2 "empernar" ; --auto
lin bomb_N = mkN "bomba" feminine ; --auto
lin bomb_V = mkV "bombardejar" ; --auto
lin bomb_V2 = mkV2 "bombardejar" ; --auto
lin bombardment_N = mkN "bombardeig" masculine ; --auto
lin bombardon_N = mkN "bombardó" masculine ; --auto
lin bombast_N = mkN "pompositat" feminine ; --auto
lin bomber_N = mkN "bombarder" masculine ; --auto
lin bond_N = mkN "vincle" masculine ; --auto
lin bond_holder_N = mkN "obligacionista" ; --auto
lin bonding_N = mkN "vinculació" feminine ; --auto
lin bone_N = L.bone_N ;
lin bonfire_N = mkN "foguera" feminine ; --auto
lin bonnet_N = mkN "barret" masculine ; --auto
lin bonsai_N = mkN "bonsai" masculine ; --auto
lin bonus_N = mkN "bonificació" feminine | mkN "paga extraordinària" feminine ; --auto
lin book_N = L.book_N ;
lin book_V2 = mkV2 "reservar" ; --auto
lin bookbinder_N = mkN "enquadernador" feminine | mkN "enquadernador" masculine ; --auto
lin bookseller_N = mkN "llibreter" | mkN "llibreter" ; --auto
lin bookshop_N = mkN "llibreria" feminine ; --auto
lin boom_N = mkN "boom" masculine ; --auto
lin boomerang_N = mkN "bumerang" masculine ; --auto
lin boor_N = mkN "barroer" | mkN "barroer" ; --auto
lin boost_N = mkN "impuls" masculine ; --auto
lin boost_V2 = mkV2 "augmentar" | mkV2 "estimular" ; --auto
lin boot_N = L.boot_N ;
lin boot_V2 = mkV2 "xutar" ; --auto
lin booty_N = mkN "botí" masculine ; --auto
lin borate_N = mkN "borat" masculine ; --auto
lin border_N = mkN "frontera" feminine | mkN "vora" feminine ; --auto
lin bore_N = mkN "trepant" masculine ; --auto
lin bore_V = mkV "avorrir" ; --auto
lin bore_V2 = mkV2 "avorrir" ; --auto
lin boredom_N = mkN "avorriment" masculine ; --auto
lin borer_N = mkN "cucat" masculine ; --auto
lin boring_A = mkA "avorrit" ; --auto
lin boring_N = mkN "mandrinatge" masculine ; --auto
lin bornite_N = mkN "bornita" feminine ; --auto
lin boron_N = mkN "bor" masculine ; --auto
lin borough_N = mkN "burg" masculine ; --auto
lin borrow_V = mkV "manllevar" ; --auto
lin borrow_V2 = mkV2 "manllevar" ; --auto
lin borrower_N = mkN "prestatari" feminine | mkN "prestatari" masculine ; --auto
lin boson_N = mkN "bosó" masculine ; --auto
lin boss_N = L.boss_N ;
lin botanic_A = mkA "botànic" ; --auto
lin botanist_N = mkN "botànic" | mkN "botànic" ; --auto
lin botany_N = mkN "botànica" feminine ; --auto
lin botch_N = mkN "nyap" masculine ; --auto
lin both_Adv = mkAdv "tots dos" ; --TODO needs agreement
lin bother_V = mkV "molestar" ; --auto
lin bother_V2 = mkV2 "molestar" ; --auto
lin bottle_N = mkN "ampolla" feminine | mkN "botella" feminine ; --auto
lin bottle_V2 = mkV2 "embotellar" ; --auto
lin bottom_A = mkA "inferior" ; --auto
lin bottom_N = mkN "fons" masculine | mkN "fons" masculine ; --auto
lin bouillabaisse_N = mkN "bullabessa" feminine ; --auto
lin boulevard_N = mkN "bulevard" masculine ; --auto
lin bounce_V = mkV "botar" ; --auto
lin bounce_V2 = mkV2 "botar" ; --auto
lin bound_V = mkV "saltar" ; --auto
lin bound_V2 = mkV2 "saltar" ; --auto
lin boundary_N = mkN "frontera" feminine ; --auto
lin boundless_A = mkA "il·limitat" ; --auto
lin bouquet_N = mkN "ram" masculine ; --auto
lin bourgeois_N = mkN "burgès" | mkN "burgès" ; --auto
lin bourgeoisie_N = mkN "burgesia" feminine ; --auto
lin boutique_N = mkN "boutique" feminine ; --auto
lin bovine_A = mkA "boví" ; --auto
lin bow_N = mkN "arquet" masculine | mkN "llaç" masculine ; --auto
lin bow_V = mkV "acatxar-se" | mkV "ajupir-se" | mkV "inclinar" ; --auto
lin bowel_N = mkN "intestí" masculine ; --auto
lin bowl_N = mkN "bola" feminine | mkN "bol" masculine ; --auto
lin box_N = mkN "caixa" ; --"capsa" (strong vs. flimsy box)
lin box_V = mkV "boxejar" ; --auto
lin box_V2 = mkV2 "boxejar" ; --auto
lin boxer_N = mkN "boxejador" feminine | mkN "boxejador" masculine ; --auto
lin boxing_N = mkN "boxa" feminine ; --auto
lin boy_N = L.boy_N ;
lin boycott_N = mkN "boicot" masculine ; --auto
lin boycott_V2 = mkV2 "boicotejar" ; --auto
lin boyfriend_N = mkN "xicot" masculine ; --auto
lin bra_N = mkN "sostenidor" masculine ; --auto
lin brace_N = mkN "tirant" masculine ; --auto
lin bracelet_N = mkN "braçalet" masculine ; --auto
lin brachycephaly_N = mkN "braquicefàlia" feminine ; --auto
lin brackish_A = mkA "salabrós" ; --auto
lin bract_N = mkN "bràctea" feminine ; --auto
lin bradycardia_N = mkN "bradicàrdia" feminine ; --auto
lin brain_N = mkN "cervell" masculine ; --auto
lin brainless_A = mkA "tòtil" ; --auto
lin brake_N = mkN "fre" masculine ; --auto
lin brake_V = mkV "frenar" ; --auto
lin brake_V2 = mkV2 "frenar" ; --auto
lin bramble_N = mkN "esbarzer" masculine ; --auto
lin bran_N = mkN "segó" masculine ; --auto
lin branch_N = mkN "branca" feminine ;
lin brand_N = mkN "marca" feminine ; --auto
lin brandish_V2 = mkV2 "brandir" ; --auto
lin brass_N = mkN "llautó" masculine ; --auto
lin brassiere_N = variants {} ;
lin brat_N = mkN "marrec" masculine ; --auto
lin brave_A = mkA "valent" ; --auto
lin brave_V2 = mkV2 "afrontar" ; --auto
lin brawler_N = mkN "busca-raons" | mkN "busca-raons" ; --auto
lin brazilian_A = mkA "brasiler" ; --auto
lin brazilian_N = mkN "brasiler" | mkN "brasiler" ; --auto
lin breach_N = mkN "ruptura" feminine ; --auto
lin breach_V2 = mkV2 "incomplir" ; --auto
lin bread_N = L.bread_N ;
lin breadwinner_N = mkN "suport de la família" masculine ; --auto
lin break_N = mkN "trencament" masculine ; --auto
lin break_V = mkV "trencar" ;
lin break_V2 = L.break_V2 ;
lin break_apart_V = advV OP_break_V OP_apart_Adv ; -- guess-p-verb
lin break_away_V = advV OP_break_V OP_away_Adv ; -- guess-p-verb
lin break_down_V = advV OP_break_V OP_down_Adv ; -- guess-p-verb
lin break_down_V2 = prepV2 OP_break_V OP_down_Prep ; -- guess-p-verb
lin break_in_V = advV OP_break_V OP_in_Adv ; -- guess-p-verb
lin break_in_V2 = prepV2 OP_break_V OP_in_Prep ; -- guess-p-verb
lin break_in_on_V2 = prepV2 (advV OP_break_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin break_into_V2 = prepV2 OP_break_V OP_into_Prep ; -- guess-p-verb
lin break_off_V2 = prepV2 OP_break_V OP_off_Prep ; -- guess-p-verb
lin break_out_V = advV OP_break_V OP_out_Adv ; -- guess-p-verb
lin break_out_V2 = prepV2 OP_break_V OP_out_Prep ; -- guess-p-verb
lin break_out_in_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin break_out_of_V2 = prepV2 (advV OP_break_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin break_through_V2 = prepV2 OP_break_V OP_through_Prep ; -- guess-p-verb
lin break_up_V = advV OP_break_V OP_up_Adv ; -- guess-p-verb
lin break_up_V2 = prepV2 OP_break_V OP_up_Prep ; -- guess-p-verb
lin breakdown_N = mkN "desglossament" masculine ; --auto
lin breaker_N = mkN "rompent" masculine | mkN "ruptor" masculine ; --auto
lin breakfast_N = mkN "esmorzar" masculine ; --auto
lin breakthrough_N = mkN "avançada" feminine ; --auto
lin breakwater_N = mkN "trencaonades" masculine | mkN "trencaonades" masculine ; --auto
lin bream_N = mkN "besuc" masculine ; --auto
lin breast_N = L.breast_N ;
lin breaststroke_N = mkN "braça" feminine ; --auto
lin breath_N = mkN "respiració" feminine ; --auto
lin breathe_V = L.breathe_V ;
lin breathe_V2 = variants {} ; -- L.breathe_V ;
lin breather_N = mkN "respirador" masculine ; --auto
lin breathing_N = mkN "respiració" feminine ; --auto
lin breed_N = mkN "raça" feminine ; --auto
lin breed_V = mkV "criar" ; --auto
lin breed_V2 = mkV2 "criar" ; --auto
lin breeder_N = mkN "reproductor" feminine | mkN "reproductor" masculine ; --auto
lin breeze_N = mkN "brisa" feminine ; --auto
lin breve_N = mkN "quadrada" feminine ; --auto
lin breviary_N = mkN "breviari" masculine ; --auto
lin brewery_N = mkN "cerveseria" feminine ; --auto
lin bribe_V = mkV "subornar" ; --auto
lin bribe_V2 = mkV2 "subornar" ; --auto
lin brick_N = mkN "maó" masculine ; --auto
lin bricklayer_N = mkN "paleta" ; --auto
lin bride_N = mkN "nuvi" feminine ; --auto
lin bridegroom_N = mkN "nuvi" masculine ; --auto
lin bridesmaid_N = mkN "dama d'honor" feminine ; --auto
lin bridge_N = mkN "pont" masculine ; --auto
lin brief_A = mkA "breu" ; --auto
lin brief_V2 = mkV2 "informar" ; --auto
lin briefcase_N = mkN "maletí" masculine ; --auto
lin brig_N = mkN "bergantí" masculine ; --auto
lin brigade_N = mkN "brigada" feminine ; --auto
lin bright_A = mkA "brillant" ; --auto
lin brilliant_A = mkA "brillant" ; --auto
lin brimstone_N = mkN "sofre" masculine ; --auto
lin brine_N = mkN "salmorra" feminine ; --auto
lin bring_V2 = mkV2 (mkV "portar") ;
lin bring_V3 = mkV3 (mkV "portar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin bring_about_V2 = prepV2 (lin V OP_bring_V2) OP_about_Prep ; -- guess-p-verb
lin bring_along_V2 = prepV2 (lin V OP_bring_V2) OP_along_Prep ; -- guess-p-verb
lin bring_around_V2 = prepV2 (lin V OP_bring_V2) OP_around_Prep ; -- guess-p-verb
lin bring_away_V2 = mkV2 (advV (lin V OP_bring_V2) OP_away_Adv ) ; -- guess-p-verb
lin bring_back_V2 = mkV2 (advV (lin V OP_bring_V2) OP_back_Adv ) ; -- guess-p-verb
lin bring_down_V2 = prepV2 (lin V OP_bring_V2) OP_down_Prep ; -- guess-p-verb
lin bring_forth_V = advV (lin V OP_bring_V2) OP_forth_Adv ; -- guess-p-verb
lin bring_forth_V2 = mkV2 (advV (lin V OP_bring_V2) OP_forth_Adv ) ; -- guess-p-verb
lin bring_forward_V2 = mkV2 (advV (lin V OP_bring_V2) OP_forward_Adv ) ; -- guess-p-verb
lin bring_in_V2 = prepV2 (lin V OP_bring_V2) OP_in_Prep ; -- guess-p-verb
lin bring_off_V2 = prepV2 (lin V OP_bring_V2) OP_off_Prep ; -- guess-p-verb
lin bring_on_V2 = prepV2 (lin V OP_bring_V2) OP_on_Prep ; -- guess-p-verb
lin bring_out_V2 = prepV2 (lin V OP_bring_V2) OP_out_Prep ; -- guess-p-verb
lin bring_out_in_V3 = variants {} ; -- guess-p-verb
lin bring_over_V2 = prepV2 (lin V OP_bring_V2) OP_over_Prep ; -- guess-p-verb
lin bring_round_V2 = prepV2 (lin V OP_bring_V2) OP_round_Prep ; -- guess-p-verb
lin bring_to_V2 = prepV2 (lin V OP_bring_V2) OP_to_Prep ; -- guess-p-verb
lin bring_up_V2 = prepV2 (lin V OP_bring_V2) OP_up_Prep ; -- guess-p-verb
lin brink_N = mkN "caire" masculine ; --auto
lin brioche_N = mkN "brioix" masculine ; --auto
lin briquette_N = mkN "briqueta" feminine ; --auto
lin british_A = mkA "britànic" ; --auto
lin brittle_A = mkA "trencadís" ; --auto
lin broad_A = L.broad_A ;
lin broadcast_N = mkN "emissió" feminine | mkN "radiodifusió" feminine ; --auto
lin broadcast_V = mkV "retransmetre" ; --auto
lin broadcast_V2 = mkV2 "retransmetre" ; --auto
lin broadcaster_N = mkN "radioemissor" masculine ; --auto
lin broaden_V = mkV "ampliar" ; --auto
lin broaden_V2 = mkV2 "ampliar" ; --auto
lin broadening_N = mkN "eixamplament" masculine ; --auto
lin broadside_Adv = mkAdv "de costat" ; --auto
lin brocade_N = mkN "brocat" masculine ; --auto
lin broccoli_N = mkN "bròquil" masculine ; --auto
lin brochette_N = mkN "broqueta" feminine ; --auto
lin broker_N = mkN "agent de borsa" ; --auto
lin brokerage_N = mkN "corretatge" masculine ; --auto
lin bromide_N = mkN "bromur" masculine ; --auto
lin bromine_N = mkN "brom" masculine ; --auto
lin bronchial_A = mkA "bronquial" ; --auto
lin bronchiole_N = mkN "bronquíol" masculine ; --auto
lin bronchus_N = mkN "bronqui" masculine ; --auto
lin bronze_N = mkN "bronze" masculine ; --auto
lin bronze_V = mkV "bronzejar" ; --auto
lin bronze_V2 = mkV2 "bronzejar" ; --auto
lin brooch_N = mkN "fermall" masculine ; --auto
lin brook_N = mkN "rierol" masculine ; --auto
lin broom_N = mkN "escombra" feminine | mkN "granera" feminine ; --auto
lin broth_N = mkN "brou" masculine ; --auto
lin brothel_N = mkN "bordell" masculine ; --auto
lin brother_N = mkN "germà" masculine ;
lin brotherhood_N = mkN "fraternitat" feminine ; --auto
lin brown_A = L.brown_A ;
lin brown_N = mkN "marró" masculine ; --auto
lin brownish_A = mkA "marronós" ; --auto
lin browser_N = mkN "navegador" masculine ; --auto
lin bruise_N = mkN "blau" masculine ; --auto
lin brunetteFem_N = variants {} ; ---- sense to be split
lin brunetteMasc_N = variants {} ; ---- sense to be split
lin brush_N = mkN "escombreta" feminine | mkN "pinzell" masculine | mkN "raspall" masculine ; --auto
lin brush_V = mkV "raspallar" ; --auto
lin brush_V2 = mkV2 "raspallar" ; --auto
lin brusque_A = mkA "brusc" ; --auto
lin brutal_A = mkA "brutal" ; --auto
lin brutality_N = mkN "brutalitat" feminine ; --auto
lin bubble_N = mkN "bambolla" feminine | mkN "bombolla" feminine ; --auto
lin bubble_V = mkV "borbollejar" ; --auto
lin buccal_A = mkA "bucal" ; --auto
lin buccaneer_N = mkN "bucaner" feminine | mkN "bucaner" masculine ; --auto
lin bucket_N = mkN "catúfol" masculine | mkN "galleda" feminine | mkN "poal" masculine ; --auto
lin buckwheat_N = mkN "fajol" masculine ; --auto
lin buddhistFem_N = variants {} ; ---- sense to be split
lin buddhistMasc_N = variants {} ; ---- sense to be split
lin budget_N = mkN "pressupost" masculine ;
lin budgetary_A = mkA "pressupostari" ; --auto
lin buffet_N = mkN "bufet" masculine ; --auto
lin buffoonery_N = mkN "bufonada" feminine ; --auto
lin build_N = mkN "complexió" feminine ; --auto
lin build_V = verbV (servir_101 "construir") ;
lin build_V2 = mkV2 (verbV (servir_101 "construir")) ;
lin build_up_V2 = prepV2 OP_build_V OP_up_Prep ; -- guess-p-verb
lin builder_N = mkN "constructor" ; --auto
lin building_N = mkN "edifici" masculine ;
lin bulb_N = mkN "bombeta" feminine ; --auto
lin bulbous_A = mkA "bulbós" ; --auto
lin bulgarianFem_N = variants {} ; ---- sense to be split
lin bulgarianMasc_N = variants {} ; ---- sense to be split
lin bulgarian_A = mkA "búlgar" ;
lin bulimia_N = mkN "bulímia" feminine ; --auto
lin bulky_A = mkA "voluminós" ; --auto
lin bull_N = mkN "brau" masculine ; --auto
lin bulldozer_N = mkN "buldòzer" masculine ; --auto
lin bullet_N = mkN "bala" feminine ; --auto
lin bulletin_N = mkN "butlletí" masculine ; --auto
lin bulletproof_A = mkA "antibala" ; --auto
lin bully_N = mkN "perdonavides" masculine | mkN "perdonavides" masculine ; --auto
lin bullying_N = mkN "assetjament" masculine ; --auto
lin bumblebee_N = mkN "abellot" masculine ; --auto
lin bump_N = mkN "sotrac" masculine ; --auto
lin bump_V = mkV "xocar" ; --auto
lin bump_V2 = mkV2 "xocar" ; --auto
lin bumper_N = mkN "para-xocs" masculine | mkN "para-xocs" masculine ; --auto
lin bun_N = mkN "panet" masculine ; --auto
lin buna_N = mkN "buna" feminine ; --auto
lin bunch_N = mkN "grapat" masculine | mkN "ram" masculine ; --auto
lin bundle_N = mkN "farcell" masculine ; --auto
lin bung_N = mkN "bonda" feminine ; --auto
lin bungalow_N = mkN "bungalow" masculine ; --auto
lin bungler_N = mkN "potiner" | mkN "potiner" ; --auto
lin bunion_N = mkN "galindó" masculine ; --auto
lin bunk_N = mkN "llitera" feminine ; --auto
lin bunker_N = mkN "búnquer" masculine ; --auto
lin buoy_N = mkN "boia" feminine ; --auto
lin burble_V = mkV "murmurejar" ; --auto
lin burden_N = mkN "càrrega" feminine ; --auto
lin burden_V2 = mkV2 "carregar" ; --auto
lin bureau_N = mkN "agència" feminine ; --auto
lin bureaucracy_N = mkN "burocràcia" feminine ; --auto
lin bureaucrat_N = mkN "buròcrata" ; --auto
lin bureaucratic_A = mkA "burocràtic" ; --auto
lin burgeon_V = mkV "rebrotar" ; --auto
lin burial_N = mkN "enterrament" masculine ; --auto
lin burlap_N = mkN "xarpellera" feminine ; --auto
lin burmese_A = mkA "birmà" ; --auto
lin burn_N = mkN "cremada" feminine ; --auto
lin burn_V = L.burn_V ;
lin burn_V2 = variants {} ; -- L.burn_V ;
lin burn_down_V = advV OP_burn_V OP_down_Adv ; -- guess-p-verb
lin burn_down_V2 = prepV2 OP_burn_V OP_down_Prep ; -- guess-p-verb
lin burn_off_V2 = prepV2 OP_burn_V OP_off_Prep ; -- guess-p-verb
lin burn_out_V = advV OP_burn_V OP_out_Adv ; -- guess-p-verb
lin burn_up_V = advV OP_burn_V OP_up_Adv ; -- guess-p-verb
lin burn_up_V2 = prepV2 OP_burn_V OP_up_Prep ; -- guess-p-verb
lin burner_N = mkN "cremador" masculine ; --auto
lin burning_A = mkA "ardent" ; --auto
lin burnish_V = mkV "brunyir" ; --auto
lin burnish_V2 = mkV2 "brunyir" ; --auto
lin burst_N = mkN "explosió" feminine ; --auto
lin burst_V = mkV "esclatar" ; --auto
lin burst_V2 = mkV2 "esclatar" ; --auto
lin burst_into_V2 = prepV2 OP_burst_V OP_into_Prep ; -- guess-p-verb
lin bury_V = mkV "enterrar" ; --auto
lin bury_V2 = mkV2 "enterrar" ; --auto
lin bus_N = mkN "autobús" masculine ;
lin bush_N = mkN "arbust" masculine ; --auto
lin business_N = mkN "empresa" feminine ; --difficult to translate, usually translated in context
lin businessman_N = mkN "home de negocis" masculine ; --auto
lin businesswoman_N = mkN "dona de negocis" feminine ; --auto
lin bust_N = mkN "bust" masculine ; --auto
lin bustard_N = mkN "avitarda" feminine ; --auto
lin bustle_N = mkN "renou" masculine ; --auto
lin busy_A = mkA "ocupat" ; --auto
lin but_Conj = {s1 = [] ; s2="però" ; n=Sg} ;
lin but_Prep = mkPrep "excepte" ; --auto
lin butcher_N = mkN "carnisser" | mkN "carnisser" ; --auto
lin butter_N = L.butter_N ;
lin butterfingers_N = mkN "matusser" | mkN "matusser" ; --auto
lin butterfly_N = mkN "papallona" feminine ; --auto
lin buttock_N = mkN "natja" feminine ; --auto
lin button_N = mkN "botó" masculine ; --auto
lin butyl_N = mkN "butil" masculine ; --auto
lin buy_V = mkV "compar" ;
lin buy_V2 = L.buy_V2 ;
lin buy_back_V2 = mkV2 (advV OP_buy_V OP_back_Adv ) ; -- guess-p-verb
lin buy_in_V2 = prepV2 OP_buy_V OP_in_Prep ; -- guess-p-verb
lin buy_into_V2 = prepV2 OP_buy_V OP_into_Prep ; -- guess-p-verb
lin buy_off_V2 = prepV2 OP_buy_V OP_off_Prep ; -- guess-p-verb
lin buy_out_V2 = prepV2 OP_buy_V OP_out_Prep ; -- guess-p-verb
lin buy_up_V2 = prepV2 OP_buy_V OP_up_Prep ; -- guess-p-verb
lin buyerFem_N = variants {} ; ---- sense to be split
lin buyerMasc_N = variants {} ; ---- sense to be split
lin buzz_V = mkV "brunzir" ; --auto
lin buzz_V2 = mkV2 "brunzir" ; --auto
lin buzzer_N = mkN "brunzidor" masculine ; --auto
lin by_Prep = S.by8agent_Prep | S.by8means_Prep ;
lin by_means_of_Prep = mkPrep "mitjançant" | mkPrep "per mitjà de" ; --auto
lin bye_Interj = mkInterj "adéu" ;
lin byproduct_N = mkN "subproducte" masculine ; --auto
lin byte_N = mkN "byte" masculine ; --auto
lin byzantine_A = mkA "bizantí" ; --auto
lin cabbage_N = mkN "col" feminine ; --auto
lin cabin_N = mkN "cabana" feminine | mkN "cabina" feminine ; --auto
lin cabinet_N = mkN "armari" masculine ;
lin cabinet_maker_N = mkN "ebenista" ; --auto
lin cabinetmaking_N = mkN "ebenisteria" feminine ; --auto
lin cable_N = mkN "cable" masculine ; --auto
lin cablegram_N = mkN "cablegrama" masculine ; --auto
lin cachexia_N = mkN "caquèxia" feminine ; --auto
lin cacique_N = mkN "cacic" masculine ; --auto
lin cacophony_N = mkN "cacofonia" feminine ; --auto
lin cactus_N = mkN "cactus" masculine | mkN "cactus" masculine ; --auto
lin cadastral_A = mkA "cadastral" ; --auto
lin cadence_N = mkN "cadència" feminine ; --auto
lin cadet_N = mkN "cadet" masculine ; --auto
lin cadmium_N = mkN "cadmi" masculine ; --auto
lin caducous_A = mkA "caduc" ; --auto
lin caesura_N = mkN "cesura" feminine ; --auto
lin cafe_N = mkN "cafeteria" feminine ; --auto
lin cafeteria_N = mkN "cafeteria" ;
lin caffeine_N = mkN "cafeïna" feminine ; --auto
lin cage_N = mkN "gàbia" feminine ; --auto
lin cagily_Adv = mkAdv "cautelosament" ; --auto
lin cake_N = mkN "pastís" masculine ; --auto
lin calamity_N = mkN "calamitat" feminine ; --auto
lin calcareous_A = mkA "calcari" ; --auto
lin calcic_A = mkA "càlcic" ; --auto
lin calcicolous_A = mkA "calcícola" ; --auto
lin calcification_N = mkN "calcificació" feminine ; --auto
lin calcination_N = mkN "calcinació" feminine ; --auto
lin calcite_N = mkN "calcita" feminine ; --auto
lin calcium_N = mkN "calci" masculine ; --auto
lin calculable_A = mkA "calculable" ; --auto
lin calculate_V = mkV "calcular" ; --auto
lin calculate_V2 = mkV2 "calcular" ; --auto
lin calculation_N = mkN "càlcul" masculine ; --auto
lin calculator_N = mkN "calculadora" feminine ; --auto
lin calculus_N = mkN "càlcul" masculine ; --auto
lin calendar_N = mkN "calendari" masculine ; --auto
lin calender_V2 = mkV2 "calandrar" ; --auto
lin caliber_N = mkN "vàlua" feminine ; --auto
lin calibrate_V2 = mkV2 "calibrar" ; --auto
lin calico_N = mkN "calicó" masculine ; --auto
lin californian_A = mkA "californià" ; --auto
lin californium_N = mkN "californi" masculine ; --auto
lin caliph_N = mkN "califa" feminine ; --auto
lin calk_V2 = mkV2 "calafatar" ; --auto
lin call_N = mkN "crida" feminine ;
lin call_V = mkV "trucar" ;
lin call_V2 = mkV2 (mkV "trucar") ParadigmsCat.dative ;
lin call_after_V2 = prepV2 OP_call_V OP_after_Prep ; -- guess-p-verb
lin call_around_V = advV OP_call_V OP_around_Adv ; -- guess-p-verb
lin call_back_V2 = mkV2 (advV OP_call_V OP_back_Adv ) ; -- guess-p-verb
lin call_for_V2V = variants {} ; -- guess-p-verb
lin call_forth_V2 = mkV2 (advV OP_call_V OP_forth_Adv ) ; -- guess-p-verb
lin call_in_V = advV OP_call_V OP_in_Adv ; -- guess-p-verb
lin call_in_V2 = prepV2 OP_call_V OP_in_Prep ; -- guess-p-verb
lin call_off_V2 = prepV2 OP_call_V OP_off_Prep ; -- guess-p-verb
lin call_on_V = advV OP_call_V OP_on_Adv ; -- guess-p-verb
lin call_on_V2 = prepV2 OP_call_V OP_on_Prep ; -- guess-p-verb
lin call_out_V2 = prepV2 OP_call_V OP_out_Prep ; -- guess-p-verb
lin call_over_V = advV OP_call_V OP_over_Adv ; -- guess-p-verb
lin call_round_V = advV OP_call_V OP_round_Adv ; -- guess-p-verb
lin call_up_V2 = prepV2 OP_call_V OP_up_Prep ; -- guess-p-verb
lin calligraphy_N = mkN "cal·ligrafia" feminine ; --auto
lin callosity_N = mkN "durícia" feminine ; --auto
lin calm_A = mkA "serè" | mkA "tranquil" ; --auto
lin calm_N = mkN "calma" feminine ; --auto
lin calm_V = mkV "calmar" ; --auto
lin calm_V2 = mkV2 "calmar" ; --auto
lin caloric_A = mkA "calòric" ; --auto
lin calorie_N = mkN "caloria" feminine ; --auto
lin calorimeter_N = mkN "calorímetre" masculine ; --auto
lin calorimetry_N = mkN "calorimetria" feminine ; --auto
lin calque_N = mkN "calc" masculine ; --auto
lin calvaria_N = mkN "calvària" feminine ; --auto
lin cam_N = mkN "lleva" feminine ; --auto
lin camber_N = mkN "bombat" masculine ; --auto
lin camel_N = mkN "camell" | mkN "camell" ; --auto
lin camembert_N = mkN "camembert" masculine ; --auto
lin camera_N = L.camera_N ;
lin cameroonian_A = mkA "camerunès" ; --auto
lin cameroonian_N = mkN "camerunès" | mkN "camerunès" ; --auto
lin camomile_N = mkN "camamilla" feminine ; --auto
lin camouflage_N = mkN "camuflament" masculine ; --auto
lin camp_N = mkN "campament" masculine ; --auto
lin camp_V = mkV "acampar" ; --auto
lin camp_V2 = mkV2 "acampar" ; --auto
lin campaign_N = mkN "campanya" feminine ;
lin campaign_V = mkV "fer campanya" ; --auto
lin camphor_N = mkN "càmfora" feminine ; --auto
lin camping_N = mkN "càmping" masculine ; --auto
lin campus_N = mkN "campus" masculine | mkN "campus" masculine ; --auto
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_N = mkN "llauna" feminine ; --auto
lin canadian_A = mkA "canadenc" ; --auto
lin canadian_N = mkN "canadenc" | mkN "canadenc" ; --auto
lin canaliculus_N = mkN "canalicle" masculine ; --auto
lin cancan_N = mkN "cancan" masculine ; --auto
lin cancel_V = mkV "anul·lar" | mkV "cancel·lar" ; --auto
lin cancel_V2 = mkV2 "anul·lar" | mkV2 "cancel·lar" ; --auto
lin cancellation_N = mkN "anulació" feminine | mkN "cancel·lació" feminine ; --auto
lin cancer_N = mkN "càncer" masculine ; --auto
lin candid_A = mkA "franc" ; --auto
lin candidateFem_N = variants {} ; ---- sense to be split
lin candidateMasc_N = variants {} ; ---- sense to be split
lin candidature_N = mkN "candidatura" feminine ; --auto
lin candidiasis_N = mkN "candidiasi" feminine ; --auto
lin candle_N = mkN "espelma" feminine ; --auto
lin candy_N = mkN "caramel" masculine ; --auto
lin cane_N = mkN "canya" feminine ; --auto
lin canine_A = mkA "caní" ; --auto
lin canister_N = mkN "granada" feminine ; --auto
lin cannibal_N = mkN "caníbal" ; --auto
lin cannibalism_N = mkN "canibalisme" masculine ; --auto
lin cannon_1_N = mkN "canó" masculine ;
lin cannon_2_N = mkN "carambola" ;
lin cannula_N = mkN "cànula" feminine ; --auto
lin canoeist_N = mkN "piragüista" ; --auto
lin canon_N = variants {} ;
lin canonical_A = mkA "canònic" ; --auto
lin cantata_N = mkN "cantata" feminine ; --auto
lin canteen_N = mkN "menjador" masculine ; --auto
lin canton_N = mkN "cantó" masculine ; --auto
lin cantonal_A = mkA "cantonal" ; --auto
lin canvas_N = mkN "tela" feminine ; --auto
lin canyon_N = mkN "canyó" masculine ; --auto
lin cap_1_N = L.cap_N ;
lin cap_2_N = L.cap_N ;
lin capability_N = mkN "capacitat" feminine ; --auto
lin capable_of_A2 = mkA2 (mkA "capaç") ParadigmsCat.genitive ; --auto
lin capacity_N = mkN "capacitat" feminine ; --auto
lin cape_N = mkN "cap" masculine ; --auto
lin caper_N = mkN "tàpera" feminine ; --auto
lin capillarity_N = mkN "capil·laritat" feminine ; --auto
lin capillary_N = mkN "capil·lar" masculine ; --auto
lin capital_1_N = mkN "capital" feminine ; --split (city) vs. "capital" masc. (amount of money)
lin capital_2_N = mkN "capital" feminine ; --split (city) vs. "capital" masc. (amount of money)
lin capital_3_N = mkN "capital" feminine ; --split (city) vs. "capital" masc. (amount of money)
lin capital_A = mkA "capital" ; --auto
lin capitalism_N = mkN "capitalisme" masculine ; --auto
lin capitalist_A = mkA "capitalista" ; --auto
lin capitalist_N = mkN "capitalista" ; --auto
lin capitation_N = mkN "capitació" feminine ; --auto
lin capitulate_V = mkV "capitular" ; --auto
lin capitulate_V2 = mkV2 "capitular" ; --auto
lin capitulation_N = mkN "capitulació" feminine ; --auto
lin capsid_N = mkN "càpsida" feminine ; --auto
lin capsize_V = mkV "capgirar" ; --auto
lin capsize_V2 = mkV2 "capgirar" ; --auto
lin capstan_N = mkN "cabrestant" masculine ; --auto
lin capsule_N = mkN "càpsula" feminine ; --auto
lin captain_N = mkN "capità" feminine | mkN "capità" masculine ; --auto
lin captivate_V2 = mkV2 "captivar" ; --auto
lin captiveFem_N = variants {} ; ---- sense to be split
lin captiveMasc_N = variants {} ; ---- sense to be split
lin captive_A = mkA "captiu" ; --auto
lin captivity_N = mkN "captivitat" feminine ; --auto
lin capture_N = mkN "captura" feminine ; --auto
lin capture_V2 = mkV2 "capturar" ; --auto
lin car_N = L.car_N ;
lin carat_N = mkN "quirat" masculine ; --auto
lin caravan_N = mkN "caravana" feminine ; --auto
lin carbide_N = mkN "carbur" masculine ; --auto
lin carbohydrate_N = mkN "carbohidrat" masculine ; --auto
lin carbon_N = mkN "carboni" masculine ; --auto
lin carbonaceous_A = mkA "carbònic" ; --auto
lin carbonate_N = mkN "carbonat" masculine ; --auto
lin carboy_N = mkN "bombona" feminine ; --auto
lin carbuncle_N = mkN "carboncle" masculine ; --auto
lin carburettor_N = mkN "carburador" masculine ; --auto
lin carcinoma_N = mkN "carcinoma" masculine ; --auto
lin card_1_N = mkN "targeta" feminine ;
lin card_2_N = mkN "targeta" feminine ;
lin cardamom_N = mkN "cardamom" masculine ; --auto
lin cardboard_N = mkN "cartolina" feminine | mkN "cartó" masculine | mkN "cartró" masculine ; --auto
lin cardia_N = mkN "càrdies" masculine | mkN "càrdies" masculine ; --auto
lin cardiac_A = mkA "cardíac" ; --auto
lin cardinal_A = mkA "cardinal" ; --auto
lin cardinal_N = mkN "cardenal" masculine ; --auto
lin cardinality_N = mkN "cardinalitat" feminine ; --auto
lin cardioid_N = mkN "cardioide" masculine ; --auto
lin cardiologistFem_N = variants {} ; ---- sense to be split
lin cardiologistMasc_N = variants {} ; ---- sense to be split
lin cardiomegaly_N = mkN "cardiomegàlia" feminine ; --auto
lin cardiospasm_N = mkN "cardiospasme" masculine ; --auto
lin cardiovascular_A = mkA "cardiovascular" ; --auto
lin care_N = mkN "cura" feminine | mkN "atenció" feminine ;
lin care_V = mkV "preocupar-se" ; --auto
lin care_for_V2 = prepV2 OP_care_V OP_for_Prep ; -- guess-p-verb
lin career_N = mkN "carrera" feminine ;
lin careful_A = mkA "prudent" ; --auto
lin careless_A = mkA "distret" ; --auto
lin carer_N = mkN "cuidador" | mkN "cuidador" ; --auto
lin caricature_N = mkN "caricatura" feminine ; --auto
lin caricature_V2 = mkV2 "caricaturar" ; --auto
lin caricaturist_N = mkN "caricaturista" ; --auto
lin carmine_N = mkN "carmí" masculine ; --auto
lin carnallite_N = mkN "carnal·lita" feminine ; --auto
lin carnation_N = mkN "clavell" masculine ; --auto
lin carnival_N = mkN "carnaval" masculine | mkN "carnestoltes" masculine ; --auto
lin carnivore_N = mkN "carnívor" masculine ; --auto
lin carnivorous_A = mkA "carnívor" ; --auto
lin carp_N = mkN "carpa" feminine ; --auto
lin carpel_N = mkN "carpel" masculine ; --auto
lin carpenter_N = mkN "fuster" feminine | mkN "fuster" masculine ; --auto
lin carpentry_N = mkN "fusteria" feminine ; --auto
lin carpet_N = L.carpet_N ;
lin carpet_V2 = mkV2 "encatifar" ; --auto
lin carrack_N = mkN "carraca" feminine ; --auto
lin carriage_N = mkN "cotxe" masculine | mkN "transport" masculine | mkN "vagó" masculine ; --auto
lin carrier_N = mkN "transportista" ; --auto
lin carrion_N = mkN "carronya" feminine ; --auto
lin carrot_N = mkN "pastanaga" feminine ; --auto
lin carry_V = mkV "portar" | verbV (dur_45 "dur") ;
lin carry_V2 = mkV2 (mkV "portar") | mkV2 (verbV (dur_45 "dur")) ;
lin carry_forward_V2 = mkV2 (advV OP_carry_V OP_forward_Adv ) ; -- guess-p-verb
lin carry_off_V2 = prepV2 OP_carry_V OP_off_Prep ; -- guess-p-verb
lin carry_on_V = advV OP_carry_V OP_on_Adv ; -- guess-p-verb
lin carry_on_V2 = prepV2 OP_carry_V OP_on_Prep ; -- guess-p-verb
lin carry_on_about_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_about_Prep ; -- guess-p-verb
lin carry_on_with_V2 = prepV2 (advV OP_carry_V OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin carry_out_V = advV OP_carry_V OP_out_Adv ; -- guess-p-verb
lin carry_out_V2 = prepV2 OP_carry_V OP_out_Prep ; -- guess-p-verb
lin carry_over_V2 = prepV2 OP_carry_V OP_over_Prep ; -- guess-p-verb
lin carry_through_V2 = prepV2 OP_carry_V OP_through_Prep ; -- guess-p-verb
lin cartel_N = mkN "càrtel" masculine ; --auto
lin cartilage_N = mkN "cartílag" masculine ; --auto
lin cartilaginous_A = mkA "cartilaginós" ; --auto
lin cartload_N = mkN "carretada" feminine ; --auto
lin cartographer_N = mkN "cartògraf" | mkN "cartògraf" ; --auto
lin cartographic_A = mkA "cartogràfic" ; --auto
lin cartography_N = mkN "cartografia" feminine ; --auto
lin cartoonistFem_N = variants {} ; ---- sense to be split
lin cartoonistMasc_N = variants {} ; ---- sense to be split
lin cartridge_N = mkN "cartutx" masculine ; --auto
lin cartwright_N = mkN "carreter" masculine ; --auto
lin caruncle_N = mkN "carúncula" feminine ; --auto
lin caryatid_N = mkN "cariàtide" feminine ; --auto
lin case_N = mkN "cas" masculine ;
lin casein_N = mkN "caseïna" feminine ; --auto
lin cash_N = mkN "efectiu" masculine ;
lin cashier_N = mkN "caixer" | mkN "caixer" ; --auto
lin cashmere_N = mkN "caixmir" masculine ; --auto
lin casino_N = mkN "casino" masculine ; --auto
lin casket_N = mkN "arqueta" feminine ; --auto
lin cassava_N = mkN "mandioca" feminine ; --auto
lin casserole_N = mkN "cassola" feminine ; --auto
lin cassette_N = mkN "casset" masculine ; --auto
lin cassiterite_N = mkN "cassiterita" feminine ; --auto
lin cast_N = mkN "repartiment" masculine ; --auto
lin cast_V = mkV "llançar" ; --auto
lin cast_V2 = mkV2 "llançar" ; --auto
lin cast_about_for_V2 = prepV2 (advV OP_cast_V OP_about_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_around_V = advV OP_cast_V OP_around_Adv ; -- guess-p-verb
lin cast_around_for_V2 = prepV2 (advV OP_cast_V OP_around_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_aside_V2 = mkV2 (advV OP_cast_V OP_aside_Adv ) ; -- guess-p-verb
lin cast_off_V = advV OP_cast_V OP_off_Adv ; -- guess-p-verb
lin cast_off_V2 = prepV2 OP_cast_V OP_off_Prep ; -- guess-p-verb
lin cast_out_V2 = prepV2 OP_cast_V OP_out_Prep ; -- guess-p-verb
lin cast_round_for_V2 = prepV2 (advV OP_cast_V OP_round_Adv ) OP_for_Prep ; -- guess-p-verb
lin cast_up_V2 = prepV2 OP_cast_V OP_up_Prep ; -- guess-p-verb
lin caste_N = mkN "casta" feminine ; --auto
lin caster_N = mkN "rutlla" feminine ; --auto
lin casting_N = mkN "buidatge" masculine | mkN "càsting" masculine | mkN "fosa" feminine | mkN "peça de foneria" feminine ; --auto
lin castle_N = mkN "castell" masculine ; --auto
lin castrate_V2 = mkV2 "castrar" ; --auto
lin castration_N = mkN "castració" feminine ; --auto
lin casual_A = mkA "casual" ; --auto
lin casuistry_N = mkN "casuística" feminine ; --auto
lin cat_N = L.cat_N ;
lin catabolism_N = mkN "catabolisme" masculine ; --auto
lin catacomb_N = mkN "catacumba" feminine ; --auto
lin catalanFem_N = variants {} ;
lin catalanMasc_N = variants {} ;
lin catalan_A = mkA "català" ;
lin catalase_N = mkN "catalasa" feminine ; --auto
lin catalepsy_N = mkN "catalèpsia" feminine ; --auto
lin catalog_V2 = mkV2 "catalogar" ; --auto
lin catalogue_N = mkN "catàleg" masculine ; --auto
lin catalysis_N = mkN "catàlisi" feminine ; --auto
lin catalyst_N = mkN "catalitzador" masculine ; --auto
lin catalytic_A = mkA "catalític" ; --auto
lin catapult_N = mkN "catapulta" feminine ; --auto
lin catapult_V2 = mkV2 "catapultar" ; --auto
lin cataract_N = mkN "cataracta" feminine ; --auto
lin catarrh_N = mkN "catarro" masculine ; --auto
lin catastrophe_N = mkN "catàstrofe" feminine ; --auto
lin catch_V2 = mkV2 (mkV "agafar") ;
lin catch_at_V2 = prepV2 (lin V OP_catch_V2) OP_at_Prep ; -- guess-p-verb
lin catch_on_V = advV (lin V OP_catch_V2) OP_on_Adv ; -- guess-p-verb
lin catch_out_V2 = prepV2 (lin V OP_catch_V2) OP_out_Prep ; -- guess-p-verb
lin catch_up_V = advV (lin V OP_catch_V2) OP_up_Adv ; -- guess-p-verb
lin catch_up_V2 = prepV2 (lin V OP_catch_V2) OP_up_Prep ; -- guess-p-verb
lin catch_up_in_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_in_Prep ; -- guess-p-verb
lin catch_up_on_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin catch_up_with_V2 = prepV2 (advV (lin V OP_catch_V2) OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin catcher_N = mkN "atrapador" masculine ; --auto
lin catchment_N = mkN "captació" feminine ; --auto
lin catchword_N = mkN "reclam" masculine ; --auto
lin catechism_N = mkN "catecisme" masculine ; --auto
lin categorematic_A = mkA "categoremàtic" ; --auto
lin categorial_A = mkA "categorial" ; --auto
lin categorical_A = mkA "categòric" ; --auto
lin category_N = mkN "categoria" feminine ;
lin catena_N = mkN "catena" feminine ; --auto
lin catenary_N = mkN "catenària" feminine ; --auto
lin cater_V = mkV "proveir" ; --auto
lin catering_N = mkN "abastament" masculine ; --auto
lin caterpillar_N = mkN "eruga" feminine ; --auto
lin catharsis_N = mkN "catarsi" feminine ; --auto
lin cathartic_A = mkA "catàrtic" ; --auto
lin cathedral_N = mkN "catedral" feminine ; --auto
lin catheter_N = mkN "catèter" masculine | mkN "sonda" feminine ; --auto
lin cathode_N = mkN "càtode" masculine ; --auto
lin catholicFem_N = variants {} ; ---- sense to be split
lin catholicMasc_N = variants {} ; ---- sense to be split
lin catholic_A = mkA "catòlic" ; --auto
lin cation_N = mkN "catió" masculine ; --auto
lin catkin_N = mkN "ament" masculine ; --auto
lin cattail_N = mkN "boga" feminine ; --auto
lin cattle_N = mkN "bestiar" masculine ; --auto
lin caucasianFem_N = variants {} ; ---- sense to be split
lin caucasianMasc_N = variants {} ; ---- sense to be split
lin cauliflower_N = mkN "coliflor" feminine ; --auto
lin causal_A = mkA "causal" ; --auto
lin causality_N = mkN "causalitat" feminine ; --auto
lin cause_N = mkN "causa" feminine ;
lin cause_V2 = mkV2 (mkV "causar") ;
lin cause_V2V = mkV2V (mkV "causar") ParadigmsCat.accusative ParadigmsCat.genitive ;
lin caustic_A = mkA "càustic" ; --auto
lin caution_N = mkN "amonestació" feminine ; --auto
lin cautious_A = mkA "cautelós" ; --auto
lin cavalier_A = mkA "desdenyós" ; --auto
lin cave_N = mkN "cova" feminine ; --auto
lin cavernous_A = mkA "cavernós" ; --auto
lin caviar_N = mkN "caviar" masculine ; --auto
lin cavity_N = mkN "cavitat" feminine ; --auto
lin cease_V = mkV "deixar de" ; --auto
lin cedar_N = mkN "cedre" masculine ; --auto
lin ceiling_N = L.ceiling_N ;
lin celebrate_V2 = mkV2 "celebrar" ; --auto
lin celebrated_A = mkA "celebrat" ; --auto
lin celebration_N = mkN "celebració" feminine ; --auto
lin celebrity_N = mkN "celebritat" feminine ; --auto
lin celery_N = mkN "api" masculine ; --auto
lin celestial_A = mkA "celestial" ; --auto
lin celibacy_N = mkN "celibat" masculine ; --auto
lin cell_N = mkN "cèl·lula" feminine ;
lin cellar_N = mkN "celler" masculine ; --auto
lin cellistFem_N = variants {} ; ---- sense to be split
lin cellistMasc_N = variants {} ; ---- sense to be split
lin cellophane_N = mkN "cel·lofana" feminine ; --auto
lin cellular_A = mkA "cel·lular" ; --auto
lin celluloid_N = mkN "cel·luloide" masculine ; --auto
lin cellulose_N = mkN "cel·lulosa" feminine ; --auto
lin celom_N = mkN "celoma" masculine ; --auto
lin celtic_A = mkA "celta" ; --auto
lin cement_N = mkN "ciment" masculine ; --auto
lin cementite_N = mkN "cementita" feminine ; --auto
lin cemetery_N = mkN "cementeri" masculine | mkN "cementiri" masculine ; --auto
lin censor_V2 = mkV2 "censurar" ; --auto
lin censorship_N = mkN "censura" feminine ; --auto
lin census_N = mkN "cens" masculine ; --auto
lin cent_N = mkN "cèntim" masculine ; --auto
lin centenarian_A = mkA "centenari" ; --auto
lin centiliter_N = mkN "centilitre" masculine ; --auto
lin centimetre_N = mkN "centímetre" masculine ; --auto
lin centipede_N = mkN "centpeus" masculine | mkN "centpeus" masculine ; --auto
lin central_A = mkA "central" | mkA "cèntric" ;
lin centralism_N = mkN "centralisme" masculine ; --auto
lin centralist_A = mkA "centralista" ; --auto
lin centre_N = mkN "centre" masculine ;
lin centre_V = mkV "centrar" ; --auto
lin centre_V2 = mkV2 "centrar" ; --auto
lin centrifugal_A = mkA "centrífug" ; --auto
lin centrifugation_N = mkN "centrifugació" feminine ; --auto
lin centrifuge_N = mkN "centrifugadora" feminine ; --auto
lin centriole_N = mkN "centríol" masculine ; --auto
lin centrist_N = mkN "centrista" ; --auto
lin centrosome_N = mkN "centrosoma" masculine ; --auto
lin centurion_N = mkN "centurió" masculine ; --auto
lin century_N = mkN "segle" masculine ;
lin cephalic_A = mkA "cefàlic" ; --auto
lin cephalopod_N = mkN "cefalòpode" masculine ; --auto
lin ceramic_A = mkA "ceràmic" ; --auto
lin cereal_N = mkN "cereal" masculine ; --auto
lin cerebellum_N = mkN "cerebel" masculine ; --auto
lin cerebral_A = mkA "cerebral" ; --auto
lin ceremony_N = mkN "cerimònia" feminine ; --auto
lin cerium_N = mkN "ceri" masculine ; --auto
lin certain_1_A = mkA "convençut" ; --split "segur" I'm convinced vs. it's a certain thing
lin certain_2_A = mkA "convençut" ; --split "segur" I'm convinced vs. it's a certain thing
lin certainty_N = mkN "certesa" feminine ; --auto
lin certificate_N = mkN "certificat" masculine ; --auto
lin certification_N = mkN "certificació" feminine ; --auto
lin certify_V = mkV "certificar" ; --auto
lin certify_V2 = mkV2 "certificar" ; --auto
lin cervical_A = mkA "cervical" ; --auto
lin cesium_N = mkN "cesi" masculine ; --auto
lin cessation_N = mkN "cessació" feminine ; --auto
lin cession_N = mkN "cessió" feminine ; --auto
lin chain_N = mkN "cadena" feminine ; --auto
lin chain_V2 = mkV2 "encadenar" ; --auto
lin chair_N = L.chair_N ;
lin chair_V2 = mkV2 "presidir" ; --auto
lin chairman_N = mkN "president" ;
lin chaise_N = mkN "chaise" masculine ; --auto
lin chalcedony_N = mkN "calcedònia" feminine ; --auto
lin chalk_N = mkN "guix" masculine ; --auto
lin challenge_N = mkN "desafiament" masculine | mkN "repte" masculine ; --auto
lin challenge_V = mkV "desafiar" ; --auto
lin challenge_V2 = mkV2 "desafiar" ; --auto
lin chamber_N = mkN "cambra" feminine | mkN "saló" masculine ; --auto
lin chameleon_N = mkN "camaleó" masculine ; --auto
lin champagne_N = mkN "xampany" masculine ; --auto
lin champion_N = mkN "campió" | mkN "campió" ; --auto
lin championship_N = mkN "campionat" masculine ; --auto
lin chance_N = mkN "oportunitat" feminine ; --split "oportunitat" (opportunity) "atzar" (chance hhad it...)
lin chancellery_N = mkN "cancelleria" feminine ; --auto
lin chancellor_N = mkN "canceller" | mkN "canceller" ; --auto
lin chancre_N = mkN "xancre" masculine ; --auto
lin change_N = mkN "canvi" masculine ;
lin change_V = mkV "canviar" ;
lin change_V2 = mkV2 (mkV "canviar") ;
lin change_over_V2 = prepV2 OP_change_V OP_over_Prep ; -- guess-p-verb
lin changeable_A = mkA "canviable" ; --auto
lin channel_N = mkN "canal" masculine | mkN "rigola" feminine ; --auto
lin chaos_N = mkN "caos" masculine | mkN "caos" masculine ; --auto
lin chaotic_A = mkA "caòtic" ; --auto
lin chapel_N = mkN "capella" feminine ; --auto
lin chaplain_N = mkN "capellà" masculine ; --auto
lin chapter_N = mkN "capítol" masculine ;
lin char_V = mkV "socarrimar" ; --auto
lin char_V2 = mkV2 "socarrimar" ; --auto
lin charabanc_N = variants {} ;
lin character_1_N = mkN "personatge" masculine ; --split "personalitat" (character in a book vs. personality)
lin character_2_N = mkN "personatge" masculine ; --split "personalitat" (character in a book vs. personality)
lin characteristic_A = mkA "característic" ; --auto
lin characteristic_N = mkN "característica" feminine ; --auto
lin chard_N = mkN "bleda" feminine ; --auto
lin charge_1_N = mkN "cost" masculine | mkN "preu" masculine ; --split "càrrega" fem (police or military, electric charge...)
lin charge_2_N = mkN "cost" masculine | mkN "preu" masculine ; --split "càrrega" fem (police or military, electric charge...)
lin charge_V = mkV "carregar" ;
lin charge_V2 = mkV2 (mkV "carregar") ;
lin charge_off_V = advV OP_charge_V OP_off_Adv ; -- guess-p-verb
lin charge_up_V2 = prepV2 OP_charge_V OP_up_Prep ; -- guess-p-verb
lin charge_with_V3 = variants {} ; -- guess-p-verb
lin charisma_N = mkN "carisma" masculine ; --auto
lin charismatic_A = mkA "carismàtic" ; --auto
lin charitable_A = mkA "benèfic" | mkA "caritatiu" ; --auto
lin charity_N = mkN "caritat" feminine ; --auto
lin charlatan_N = mkN "xarlatà" feminine | mkN "xarlatà" masculine ; --auto
lin charleston_N = mkN "xarleston" masculine ; --auto
lin charm_N = mkN "encant" masculine | mkN "simpatia" feminine ; --auto
lin charming_A = mkA "encantador" ; --auto
lin chart_N = mkN "gràfic" masculine | mkN "mapa" masculine ; --auto
lin chase_N = mkN "persecució" feminine ; --auto
lin chase_V = mkV "empaitar" ; --auto
lin chase_V2 = mkV2 "empaitar" ; --auto
lin chassis_N = mkN "xassís" masculine | mkN "xassís" masculine ; --auto
lin chat_N = mkN "xat" masculine | mkN "xerrada" feminine ; --auto
lin chat_V = mkV "xarrar" | mkV "xerrar" ; --auto
lin chatter_N = mkN "xerradissa" feminine ; --auto
lin chauffeur_N = mkN "xofer" ; --auto
lin chauvinism_N = mkN "xovinisme" masculine ; --auto
lin chauvinist_N = mkN "xovinista" ; --auto
lin chauvinistic_A = mkA "xovinista" ; --auto
lin cheap_A = mkA "barat" ; --auto
lin cheapness_N = mkN "barator" feminine ; --auto
lin cheat_N = mkN "trampós" feminine | mkN "trampós" masculine ; --auto
lin cheat_V = mkV "enganyar" ; --auto
lin cheat_V2 = mkV2 "enganyar" ; --auto
lin check_N = mkN "control" masculine ; --auto
lin check_V = mkV "comprovar" ;
lin check_V2 = mkV2 (mkV "comprovar") ;
lin check_back_V = advV OP_check_V OP_back_Adv ; -- guess-p-verb
lin check_by_V2 = prepV2 OP_check_V OP_by_Prep ; -- guess-p-verb
lin check_for_V2 = prepV2 OP_check_V OP_for_Prep ; -- guess-p-verb
lin check_in_V = advV OP_check_V OP_in_Adv ; -- guess-p-verb
lin check_in_V2 = prepV2 OP_check_V OP_in_Prep ; -- guess-p-verb
lin check_into_V2 = prepV2 OP_check_V OP_into_Prep ; -- guess-p-verb
lin check_off_V2 = prepV2 OP_check_V OP_off_Prep ; -- guess-p-verb
lin check_on_V2 = prepV2 OP_check_V OP_on_Prep ; -- guess-p-verb
lin check_out_V = advV OP_check_V OP_out_Adv ; -- guess-p-verb
lin check_out_V2 = prepV2 OP_check_V OP_out_Prep ; -- guess-p-verb
lin check_out_of_V2 = prepV2 (advV OP_check_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin check_over_V2 = prepV2 OP_check_V OP_over_Prep ; -- guess-p-verb
lin check_through_V2 = prepV2 OP_check_V OP_through_Prep ; -- guess-p-verb
lin check_up_on_V2 = prepV2 (advV OP_check_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin check_with_V2 = prepV2 OP_check_V OP_with_Prep ; -- guess-p-verb
lin checklist_N = mkN "llista de control" feminine ; --auto
lin checkmate_N = mkN "escac i mat" masculine | mkN "escac i mat" masculine ; --auto
lin checkpoint_N = mkN "punt de control" masculine ; --auto
lin checkroom_N = mkN "consigna" feminine ; --auto
lin cheek_N = mkN "galta" feminine ; --auto
lin cheekbone_N = mkN "pòmul" masculine ; --auto
lin cheer_V = mkV "aclamar" | mkV "alegrar" ; --auto
lin cheer_V2 = mkV2 "aclamar" | mkV2 "alegrar" ; --auto
lin cheers_Interj = mkInterj "salut" ;
lin cheerful_A = mkA "alegre" ; --auto
lin cheese_N = L.cheese_N ;
lin chelate_N = mkN "quelat" masculine ; --auto
lin chelation_N = mkN "quelació" feminine ; --auto
lin chelicera_N = mkN "quelícer" masculine ; --auto
lin chemical_A = mkA "químic" ; --auto
lin chemical_N = mkN "substància química" feminine ; --auto
lin chemiluminescence_N = mkN "quimioluminescència" feminine ; --auto
lin chemistFem_N = variants {} ; ---- sense to be split
lin chemistMasc_N = variants {} ; ---- sense to be split
lin chemistry_N = mkN "química" feminine ; --auto
lin chemosis_N = mkN "quemosi" feminine ; --auto
lin chemotaxis_N = mkN "quimiotaxi" feminine ; --auto
lin chemotherapy_N = mkN "quimioteràpia" feminine ; --auto
lin chenille_N = mkN "xenilla" feminine ; --auto
lin cheque_N = mkN "xec" masculine ; --auto
lin chequebook_N = mkN "talonari de xecs" masculine ; --auto
lin cherimoya_N = mkN "xirimoia" feminine ; --auto
lin cherry_N = mkN "cirera" feminine ; --auto
lin cherub_N = mkN "querubí" masculine ; --auto
lin chess_N = mkN "escac" masculine | mkN "escac" masculine | mkN "escac" masculine ; --auto
lin chessboard_N = mkN "tauler d'escacs" masculine ; --auto
lin chest_N = mkN "pit" masculine ; --auto
lin chestnut_N = mkN "castanya" feminine ; --auto
lin chevron_N = mkN "galó" masculine ; --auto
lin chew_V = mkV "mastegar" ; --auto
lin chew_V2 = mkV2 "mastegar" ; --auto
lin chewing_gum_N = mkN "xiclet" masculine ; --auto
lin chiasmus_N = mkN "quiasme" masculine ; --auto
lin chick_N = mkN "pollet" masculine ; --auto
lin chicken_N = mkN "pollastre" masculine ;
lin chicory_N = mkN "xicoira" feminine ; --auto
lin chief_N = mkN "cap" masculine ; --auto
lin chieftainFem_N = variants {} ; ---- sense to be split
lin chieftainMasc_N = variants {} ; ---- sense to be split
lin chiffonier_N = mkN "xifonier" masculine ; --auto
lin chilblain_N = mkN "penelló" masculine ; --auto
lin child_N = L.child_N ;
lin childbirth_N = mkN "part" masculine ; --auto
lin childhood_N = mkN "infantesa" feminine ; --auto
lin childish_A = mkA "infantil" ; --auto
lin chileanFem_N = variants {} ; ---- sense to be split
lin chileanMasc_N = variants {} ; ---- sense to be split
lin chilean_A = mkA "xilè" ; --auto
lin chill_N = mkN "fred" masculine ; --auto
lin chimaera_N = mkN "quimera" feminine ; --auto
lin chime_N = mkN "repic" masculine ; --auto
lin chimney_N = mkN "xemeneia" feminine | mkN "ximenera" feminine ; --auto
lin chimpanzee_N = mkN "ximpanzé" masculine ; --auto
lin chin_N = mkN "barbeta" feminine ; --auto
lin china_N = mkN "porcellana" feminine ; --auto
lin chineseFem_N = variants {} ; ---- sense to be split
lin chineseMasc_N = variants {} ; ---- sense to be split
lin chinese_A = mkA "xinès" ; --auto
lin chink_N = mkN "dring" masculine ; --auto
lin chip_N = mkN "tros" masculine | mkN "xip" masculine ; --auto
lin chitin_N = mkN "quitina" feminine ; --auto
lin chloasma_N = mkN "cloasma" masculine ; --auto
lin chlorenchyma_N = mkN "clorènquima" masculine ; --auto
lin chloride_N = mkN "clorur" masculine ; --auto
lin chlorination_N = mkN "cloració" feminine ; --auto
lin chlorine_N = mkN "clor" masculine ; --auto
lin chlorite_N = mkN "clorita" feminine ; --auto
lin chlorofluorocarbon_N = mkN "clorofluorocarbur" masculine ; --auto
lin chloroform_N = mkN "cloroform" masculine ; --auto
lin chloroplast_N = mkN "cloroplast" masculine ; --auto
lin chlorosis_N = mkN "clorosi" feminine ; --auto
lin chlorotic_A = mkA "cloròtic" ; --auto
lin chocolate_N = mkN "xocolata" feminine ; --auto
lin choice_N = mkN "elecció" masculine ;
lin choir_N = mkN "cor" masculine ; --auto
lin choke_N = mkN "estàrter" masculine | mkN "ofec" masculine ; --auto
lin choke_V = mkV "obturar" ; --auto
lin choke_V2 = mkV2 "obturar" ; --auto
lin cholera_N = mkN "còlera" masculine ; --auto
lin cholesterol_N = mkN "colesterol" masculine ; --auto
lin choline_N = mkN "pujol" masculine ; --auto
lin choose_V2 = mkV2 (mkV "triar") ;
lin choose_VV = deVV (mkV "triar") ;
lin choose_up_V = advV (lin V OP_choose_V2) OP_up_Adv ; -- guess-p-verb
lin choose_up_V2 = prepV2 (lin V OP_choose_V2) OP_up_Prep ; -- guess-p-verb
lin choral_A = mkA "coral" ; --auto
lin chord_N = mkN "acord" masculine ; --auto
lin chorea_N = mkN "corea" feminine ; --auto
lin choreographer_N = mkN "coreògraf" | mkN "coreògraf" ; --auto
lin choreographic_A = mkA "coreogràfic" ; --auto
lin choreography_N = mkN "coreografia" feminine ; --auto
lin chorion_N = mkN "cori" masculine ; --auto
lin chorister_N = mkN "corista" ; --auto
lin chorus_N = mkN "cor" masculine ; --auto
lin christian_A = mkA "cristià" ; --auto
lin christian_N = mkN "cristià" | mkN "cristià" ; --auto
lin christianity_N = mkN "cristianisme" masculine ; --auto
lin christmas_N = mkN "nadal" masculine ; --auto
lin chromatic_A = mkA "cromàtic" ; --auto
lin chromatid_N = mkN "cromàtide" feminine ; --auto
lin chromatin_N = mkN "cromatina" feminine ; --auto
lin chromatism_N = mkN "cromatisme" masculine ; --auto
lin chromatogram_N = mkN "cromatograma" masculine ; --auto
lin chromatographic_A = mkA "cromatogràfic" ; --auto
lin chromatography_N = mkN "cromatografia" feminine ; --auto
lin chromite_N = mkN "cromita" feminine ; --auto
lin chromium_N = mkN "crom" masculine ; --auto
lin chromoplast_N = mkN "cromoplast" masculine ; --auto
lin chromosomal_A = mkA "cromosòmic" ; --auto
lin chromosome_N = mkN "cromosoma" masculine ; --auto
lin chronic_A = mkA "crònic" ; --auto
lin chronicle_N = mkN "crònica" feminine ; --auto
lin chronicler_N = mkN "cronista" ; --auto
lin chronograph_N = mkN "cronògraf" masculine ; --auto
lin chronological_A = mkA "cronològic" ; --auto
lin chronology_N = mkN "cronologia" feminine ; --auto
lin chronometer_N = mkN "cronòmetre" masculine ; --auto
lin chrysalis_N = mkN "crisàlide" feminine ; --auto
lin chrysanthemum_N = mkN "crisantem" masculine ; --auto
lin chrysolite_N = mkN "crisolita" feminine ; --auto
lin chuck_N = mkN "portabroques" masculine | mkN "portabroques" masculine ; --auto
lin chuck_V2 = mkV2 "tirar" ; --auto
lin church_N = L.church_N ;
lin churn_N = mkN "manteguera" feminine ; --auto
lin cicada_N = mkN "cigala" feminine ; --auto
lin cigar_N = mkN "cigar" masculine ; --auto
lin cigarette_N = mkN "cigarreta" feminine | mkN "cigarret" masculine ; --auto
lin ciliary_A = mkA "ciliar" ; --auto
lin ciliate_N = mkN "ciliat" masculine ; --auto
lin cilium_N = mkN "cili" masculine ; --auto
lin cinema_N = mkN "cinema" masculine ;
lin cinnabar_N = mkN "cinabri" masculine ; --auto
lin cinnamon_N = mkN "canyella" feminine ; --auto
lin circle_N = mkN "cercle" masculine ; --auto
lin circuit_N = mkN "circuit" masculine ; --auto
lin circular_A = mkA "circular" ; --auto
lin circular_N = mkN "circular" feminine ; --auto
lin circulate_V = mkV "circular" ; --auto
lin circulate_V2 = mkV2 "circular" ; --auto
lin circulation_N = mkN "circulació" feminine ; --auto
lin circulatory_A = mkA "circulatori" ; --auto
lin circumcision_N = mkN "circumcisió" feminine ; --auto
lin circumference_N = mkN "circumferència" feminine ; --auto
lin circumflex_N = mkN "circumflex" masculine ; --auto
lin circumscribe_V2 = mkV2 "circumscriure" ; --auto
lin circumspection_N = mkN "circumspecció" feminine ; --auto
lin circumstance_N = mkN "circumstància" feminine ;
lin circumstantial_A = mkA "circumstancial" ; --auto
lin circus_N = mkN "circ" masculine ; --auto
lin cirrhosis_N = mkN "cirrosi" feminine ; --auto
lin cirrocumulus_N = mkN "cirrocúmul" masculine | mkN "cirrocúmulus" masculine ; --auto
lin cirrostratus_N = mkN "cirrostrat" masculine | mkN "cirrostratus" masculine | mkN "cirrostratus" masculine ; --auto
lin cirrus_N = mkN "cirrus" masculine | mkN "cirrus" masculine ; --auto
lin citadel_N = mkN "ciutadella" feminine ; --auto
lin cite_V2 = mkV2 "citar" ; --auto
lin citizenFem_N = variants {} ; ---- sense to be split
lin citizenMasc_N = variants {} ; ---- sense to be split
lin citizenship_N = mkN "ciutadania" feminine ; --auto
lin citric_A = mkA "cítric" ; --auto
lin citrine_N = mkN "citrina" feminine ; --auto
lin citrus_N = mkN "cítric" masculine ; --auto
lin city_N = L.city_N ;
lin civic_A = mkA "cívic" ; --auto
lin civil_A = mkA "civil" ;
lin civilian_N = mkN "civil" masculine ; --auto
lin civilisation_N = mkN "civilització" feminine ; --auto
lin clade_N = mkN "clada" feminine ; --auto
lin cladistics_N = mkN "cladística" feminine ; --auto
lin cladogram_N = mkN "cladograma" masculine ; --auto
lin claim_N = mkN "reivindicació" masculine ; --split (denounce something that should be made right) "declaració" (simple statement)
lin claim_V = mkV "afirmar" ;
lin claim_V2 = mkV2 (mkV "afirmar") ;
lin claim_VS = mkVS (mkV "afirmar") ;
lin clam_N = mkN "cloïssa" feminine ; --auto
lin clamour_N = mkN "clamor" masculine ; --auto
lin clamp_N = mkN "serjant" masculine ; --auto
lin clan_N = mkN "clan" masculine ; --auto
lin clap_N = mkN "aplaudiment" masculine ; --auto
lin clapper_N = mkN "batall" masculine ; --auto
lin clarification_N = mkN "aclariment" masculine ; --auto
lin clarify_V = mkV "aclarir" ; --auto
lin clarify_V2 = mkV2 "aclarir" ; --auto
lin clarinet_N = mkN "clarinet" masculine ; --auto
lin clarinetistFem_N = variants {} ; ---- sense to be split
lin clarinetistMasc_N = variants {} ; ---- sense to be split
lin clarion_N = mkN "clarí" masculine ; --auto
lin clarity_N = mkN "claredat" feminine ; --auto
lin clash_N = mkN "enfrontament" masculine ; --auto
lin class_N = mkN "aula" feminine ; --split "classe" feminine educational vs. generic type
lin classic_A = mkA "clàssic" ; --auto
lin classic_N = mkN "clàssic" masculine ; --auto
lin classical_A = mkA "clàssic" ; --auto
lin classicism_N = mkN "classicisme" masculine ; --auto
lin classification_N = mkN "classificació" feminine ; --auto
lin classify_V2 = mkV2 "classificar" | mkV2 "enquadrar" ; --auto
lin classroom_N = mkN "aula" feminine | mkN "classe" feminine ; --auto
lin clast_N = mkN "clast" masculine ; --auto
lin clause_N = mkN "clàusula" feminine ; --auto
lin claustrophobia_N = mkN "claustrofòbia" feminine ; --auto
lin claustrophobic_A = mkA "claustrofòbic" ; --auto
lin clavichord_N = mkN "clavicordi" masculine ; --auto
lin clavicle_N = mkN "clavícula" feminine ; --auto
lin clay_N = mkN "argila" feminine ; --auto
lin clean_A = L.clean_A ;
lin clean_V = mkV "netejar" ; --auto
lin clean_V2 = mkV2 "netejar" ; --auto
lin clean_out_V = advV OP_clean_V OP_out_Adv ; -- guess-p-verb
lin clean_out_V2 = prepV2 OP_clean_V OP_out_Prep ; -- guess-p-verb
lin clean_up_V = advV OP_clean_V OP_up_Adv ; -- guess-p-verb
lin clean_up_V2 = prepV2 OP_clean_V OP_up_Prep ; -- guess-p-verb
lin cleaner_N = mkN "netejador" | mkN "netejador" ; --auto
lin cleaning_N = mkN "neteja" feminine ; --auto
lin cleanness_N = mkN "netedat" feminine ; --auto
lin cleansing_A = mkA "netejador" ; --auto
lin clear_A = mkA "transparent" ; --split "obvi" | "clar"
lin clear_V = mkV "buidar" ; --cannot be translated as a single word, requires more context
lin clear_V2 = mkV2 (mkV "buidar") ;
lin clear_away_V = advV OP_clear_V OP_away_Adv ; -- guess-p-verb
lin clear_away_V2 = mkV2 (advV OP_clear_V OP_away_Adv ) ; -- guess-p-verb
lin clear_off_V = advV OP_clear_V OP_off_Adv ; -- guess-p-verb
lin clear_out_V = advV OP_clear_V OP_out_Adv ; -- guess-p-verb
lin clear_out_V2 = prepV2 OP_clear_V OP_out_Prep ; -- guess-p-verb
lin clear_up_V = advV OP_clear_V OP_up_Adv ; -- guess-p-verb
lin clear_up_V2 = prepV2 OP_clear_V OP_up_Prep ; -- guess-p-verb
lin clemency_N = mkN "clemència" feminine ; --auto
lin clergy_N = mkN "clergat" masculine ; --auto
lin clergyman_N = mkN "clergue" masculine ; --auto
lin clerical_A = mkA "clerical" ; --auto
lin clericalism_N = mkN "clericalisme" masculine ; --auto
lin clerk_N = mkN "empleat" masculine | mkN "passant" masculine ; --auto
lin clerkship_N = mkN "passantia" feminine ; --auto
lin clever_A = L.clever_A ;
lin click_N = mkN "clic" masculine ; --auto
lin client_N = mkN "client" ;
lin clientele_N = mkN "clientela" feminine ; --auto
lin cliff_N = mkN "penya-segat" masculine ; --auto
lin climate_N = mkN "clima" masculine ; --auto
lin climatic_A = mkA "climàtic" ; --auto
lin climatology_N = mkN "climatologia" feminine ; --auto
lin climax_N = mkN "clímax" masculine ; --auto
lin climb_V = mkV "ascendir" ; --auto
lin climb_V2 = mkV2 "ascendir" ; --auto
lin climb_down_V = advV OP_climb_V OP_down_Adv ; -- guess-p-verb
lin climber_N = mkN "escalador" | mkN "escalador" ; --auto
lin cling_V = mkV "aferrar-se" ; --auto
lin clinic_N = mkN "clínica" feminine ; --auto
lin clinical_A = mkA "clínic" ; --auto
lin clinker_N = mkN "cagaferro" masculine ; --auto
lin clinodactyly_N = mkN "clinodactília" feminine ; --auto
lin clinometer_N = mkN "clinòmetre" masculine ; --auto
lin clip_N = mkN "clip" masculine ; --auto
lin clipper_N = mkN "clíper" masculine ; --auto
lin clipping_N = mkN "retall" masculine ; --auto
lin clitoridectomy_N = mkN "clitoridectomia" feminine ; --auto
lin clitoris_N = mkN "clítoris" masculine | mkN "clítoris" masculine ; --auto
lin cloaca_N = mkN "cloaca" feminine ; --auto
lin clock_N = mkN "rellotge" masculine ; --auto
lin clockwise_Adv = mkAdv "en el sentit de les agulles del rellotge" ; --auto
lin clod_N = mkN "terròs" masculine ; --auto
lin clog_N = mkN "esclop" masculine ; --auto
lin clone_N = mkN "clon" masculine ; --auto
lin clone_V2 = mkV2 "clonar" ; --auto
lin cloning_N = mkN "clonatge" masculine ; --auto
lin close_A = mkA "proper" ;
lin close_Adv = mkAdv "a prop" ;
lin close_V = mkV "tancar" ;
lin close_V2 = L.close_V2 ;
lin close_down_V = advV OP_close_V OP_down_Adv ; -- guess-p-verb
lin close_down_V2 = prepV2 OP_close_V OP_down_Prep ; -- guess-p-verb
lin close_in_V = advV OP_close_V OP_in_Adv ; -- guess-p-verb
lin close_in_on_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin close_in_upon_V2 = prepV2 (advV OP_close_V OP_in_Adv ) OP_upon_Prep ; -- guess-p-verb
lin close_off_V2 = prepV2 OP_close_V OP_off_Prep ; -- guess-p-verb
lin close_on_V2 = prepV2 OP_close_V OP_on_Prep ; -- guess-p-verb
lin close_out_V2 = prepV2 OP_close_V OP_out_Prep ; -- guess-p-verb
lin close_up_V = advV OP_close_V OP_up_Adv ; -- guess-p-verb
lin close_up_V2 = prepV2 OP_close_V OP_up_Prep ; -- guess-p-verb
lin closet_N = mkN "armari" masculine ; --auto
lin closing_N = mkN "tancament" masculine ; --auto
lin closure_N = mkN "clausura" feminine ; --auto
lin clot_N = mkN "coàgul" masculine | mkN "grumoll" masculine ; --auto
lin cloth_N = mkN "drap" masculine | mkN "roba" feminine | mkN "tela" feminine ; --auto
lin clothes_N = mkN "roba" feminine ;
lin clothing_N = mkN "indumentària" feminine | mkN "roba" feminine ; --auto
lin cloud_N = L.cloud_N ;
lin cloudburst_N = mkN "ruixat" masculine ; --auto
lin cloudiness_N = mkN "nuvolositat" feminine ; --auto
lin cloudless_A = mkA "serè" ; --auto
lin clover_N = mkN "trèvol" masculine ; --auto
lin clown_N = mkN "pallasso" | mkN "pallasso" ; --auto
lin club_1_N = mkN "club" masculine ;
lin club_2_N = mkN "club" masculine ;
lin clue_N = mkN "pista" feminine ; --auto
lin clumsiness_N = mkN "matusseria" feminine ; --auto
lin clumsy_A = mkA "maldestre" ; --auto
lin cluster_N = mkN "grup" masculine ; --auto
lin clutch_V = mkV "agafar fort" ; --auto
lin clutter_V2 = mkV2 "desendreçar" ; --auto
lin coach_1_N = variants {} ; ---- sense to be split
lin coach_2_N = variants {} ; ---- sense to be split
lin coach_3_N = variants {} ; ---- sense to be split
lin coachman_N = mkN "cotxer" feminine | mkN "cotxer" masculine ; --auto
lin coagulation_N = mkN "coagulació" feminine ; --auto
lin coal_N = mkN "carbó" masculine ; --auto
lin coalescence_N = mkN "coalescència" feminine ; --auto
lin coalition_N = mkN "coalició" feminine ; --auto
lin coarse_A = mkA "tosc" ; --auto
lin coarseness_N = mkN "tosquedat" feminine ; --auto
lin coast_N = mkN "costa" feminine ; --auto
lin coastal_A = mkA "coster" ; --auto
lin coat_N = L.coat_N ;
lin coating_N = mkN "recobriment" masculine ; --auto
lin coauthorFem_N = variants {} ; ---- sense to be split
lin coauthorMasc_N = variants {} ; ---- sense to be split
lin coaxial_A = mkA "coaxial" ; --auto
lin cobalt_N = mkN "cobalt" masculine ; --auto
lin cobra_N = mkN "cobra" feminine ; --auto
lin cobweb_N = mkN "teranyina" feminine ; --auto
lin cocaine_N = mkN "cocaïna" feminine ; --auto
lin coccidiosis_N = mkN "coccidiosi" feminine ; --auto
lin cochlea_N = mkN "còclea" feminine ; --auto
lin cochlear_A = mkA "coclear" ; --auto
lin cock_N = mkN "gall" masculine ; --auto
lin cockloft_N = mkN "sostremort" masculine ; --auto
lin cocktail_N = mkN "còctel" masculine ; --auto
lin coconut_N = mkN "coco" masculine ; --auto
lin cocoon_N = mkN "capoll" masculine ; --auto
lin cod_N = mkN "bacallà" masculine ; --auto
lin coda_N = mkN "coda" feminine ; --auto
lin code_N = mkN "codi" masculine ; --auto
lin codex_N = mkN "còdex" masculine ; --auto
lin codicil_N = mkN "codicil" masculine ; --auto
lin codon_N = mkN "codó" masculine ; --auto
lin coeducation_N = mkN "coeducació" feminine ; --auto
lin coefficient_N = mkN "coeficient" masculine ; --auto
lin coelenterate_N = mkN "celenterat" masculine ; --auto
lin coerce_V2 = mkV2 "coaccionar" ; --auto
lin coercive_A = mkA "coactiu" | mkA "coercitiu" ; --auto
lin coexistence_N = mkN "coexistència" feminine ; --auto
lin coffee_N = mkN "cafè" masculine ;
lin coffer_N = mkN "cassetó" masculine ; --auto
lin coffin_N = mkN "taüt" masculine ; --auto
lin cognition_N = mkN "cognició" feminine ; --auto
lin cognitive_A = mkA "cognitiu" ; --auto
lin cohabit_V = mkV "cohabitar" ; --auto
lin cohabitation_N = mkN "cohabitació" feminine ; --auto
lin coherence_N = mkN "coherència" feminine ; --auto
lin coherent_A = mkA "coherent" ; --auto
lin cohesion_N = mkN "cohesió" feminine ; --auto
lin cohort_N = mkN "cohort" feminine ; --auto
lin coil_N = mkN "bobina" feminine ; --auto
lin coin_N = mkN "moneda" feminine ; --auto
lin coin_V2 = mkV2 "encunyar" ; --auto
lin coincide_V = mkV "coincidir" ; --auto
lin coincidence_N = mkN "coincidència" feminine ; --auto
lin coitus_N = mkN "coit" masculine ; --auto
lin cold_A = L.cold_A ;
lin cold_N = mkN "fred" masculine | mkN "refredat" masculine ; --auto
lin colic_N = mkN "còlic" masculine ; --auto
lin collaborate_V = mkV "col·laborar" ; --auto
lin collaboration_N = mkN "col·laboració" feminine ; --auto
lin collaborationist_N = mkN "col·laboracionista" ; --auto
lin collaborator_N = mkN "col·laborador" | mkN "col·laborador" ; --auto
lin collage_N = mkN "collage" masculine ; --auto
lin collapse_N = mkN "esfondrament" masculine ; --auto
lin collapse_V = mkV "col·lapsar" ; --auto
lin collapse_V2 = mkV2 "col·lapsar" ; --auto
lin collapsible_A = mkA "plegable" ; --auto
lin collate_V2 = mkV2 "acarar" ; --auto
lin collateral_A = mkA "col·lateral" ; --auto
lin collation_N = mkN "col·lació" feminine ; --auto
lin colleague_N = mkN "company" ;
lin collect_V = mkV "col·leccionar" ;
lin collect_V2 = mkV2 (mkV "col·leccionar") ;
lin collection_N = mkN "col·lecció" feminine ;
lin collective_A = mkA "col·lectiu" ; --auto
lin collectivism_N = mkN "col·lectivisme" masculine ; --auto
lin collectivist_N = mkN "col·lectivista" ; --auto
lin collector_N = mkN "col·leccionista" ; --auto
lin college_N = mkN "universitat" masculine ;
lin collembolan_N = mkN "col·lèmbol" masculine ; --auto
lin collide_V = mkV "col·lidir" ; --auto
lin collimation_N = mkN "col·limació" feminine ; --auto
lin collimator_N = mkN "col·limador" feminine | mkN "col·limador" masculine ; --auto
lin collision_N = mkN "col·lisió" feminine ; --auto
lin colloid_N = mkN "col·loide" masculine ; --auto
lin colloquial_A = mkA "col·loquial" ; --auto
lin colloquium_N = mkN "col·loqui" masculine ; --auto
lin collotype_N = mkN "col·lotípia" feminine ; --auto
lin collusion_N = mkN "col·lusió" feminine ; --auto
lin colombian_A = mkA "colombià" ; --auto
lin colombian_N = mkN "colombià" ; --auto
lin colon_N = mkN "còlon" masculine ; --auto
lin colonel_N = mkN "coronel" ; --auto
lin colonial_A = mkA "colonial" ; --auto
lin colonialism_N = mkN "colonialisme" masculine ; --auto
lin colonialist_N = mkN "colonialista" ; --auto
lin colonist_N = mkN "colonitzador" feminine | mkN "colonitzador" masculine ; --auto
lin colonnade_N = mkN "columnata" feminine ; --auto
lin colony_N = mkN "colònia" feminine ; --auto
lin colophon_N = mkN "colofó" masculine ; --auto
lin colophony_N = mkN "colofònia" feminine ; --auto
lin colorimeter_N = mkN "colorímetre" masculine ; --auto
lin colorimetric_A = mkA "colorimètric" ; --auto
lin colorimetry_N = mkN "colorimetria" feminine ; --auto
lin colossal_A = mkA "colossal" ; --auto
lin colossus_N = mkN "colós" masculine ; --auto
lin colostrum_N = mkN "calostre" masculine ; --auto
lin colour_N = mkN "color" masculine ;
lin colour_V = mkV "enrojolar-se" | mkV "pintar" ; --auto
lin colourful_A = mkA "vívid" ; --auto
lin colourless_A = mkA "incolor" ; --auto
lin colpocele_N = mkN "colpocele" masculine ; --auto
lin columbarium_N = mkN "columbari" masculine ; --auto
lin columbium_N = mkN "columbi" masculine ; --auto
lin columella_N = mkN "columel·la" feminine ; --auto
lin column_N = mkN "columna" feminine ; --auto
lin columnar_A = mkA "columnar" ; --auto
lin columnistFem_N = variants {} ; ---- sense to be split
lin columnistMasc_N = variants {} ; ---- sense to be split
lin coma_N = mkN "coma" masculine ; --auto
lin comb_V = mkV "pentinar" ; --auto
lin comb_V2 = mkV2 "pentinar" ; --auto
lin combat_N = mkN "combat" masculine ; --auto
lin combat_V = mkV "combatre" ; --auto
lin combat_V2 = mkV2 "combatre" ; --auto
lin comber_N = mkN "pentinadora" feminine ; --auto
lin combinable_A = mkA "combinable" ; --auto
lin combination_N = mkN "combinació" feminine ; --auto
lin combine_V = mkV "combinar" ; --auto
lin combine_V2 = mkV2 "combinar" ; --auto
lin combustibility_N = mkN "combustibilitat" feminine ; --auto
lin combustion_N = mkN "combustió" feminine ; --auto
lin come_V = L.come_V ;
lin come_about_V = advV OP_come_V OP_about_Adv ; -- guess-p-verb
lin come_across_V = advV OP_come_V OP_across_Adv ; -- guess-p-verb
lin come_across_V2 = prepV2 OP_come_V OP_across_Prep ; -- guess-p-verb
lin come_along_V = advV OP_come_V OP_along_Adv ; -- guess-p-verb
lin come_along_with_V2 = prepV2 (advV OP_come_V OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_apart_V = advV OP_come_V OP_apart_Adv ; -- guess-p-verb
lin come_around_V = advV OP_come_V OP_around_Adv ; -- guess-p-verb
lin come_around_to_V2 = prepV2 (advV OP_come_V OP_around_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_away_V = advV OP_come_V OP_away_Adv ; -- guess-p-verb
lin come_back_V = advV OP_come_V OP_back_Adv ; -- guess-p-verb
lin come_before_V2 = prepV2 OP_come_V OP_before_Prep ; -- guess-p-verb
lin come_by_V = advV OP_come_V OP_by_Adv ; -- guess-p-verb
lin come_by_V2 = prepV2 OP_come_V OP_by_Prep ; -- guess-p-verb
lin come_down_V = advV OP_come_V OP_down_Adv ; -- guess-p-verb
lin come_down_on_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin come_down_upon_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_upon_Prep ; -- guess-p-verb
lin come_down_with_V2 = prepV2 (advV OP_come_V OP_down_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forth_V = advV OP_come_V OP_forth_Adv ; -- guess-p-verb
lin come_forth_with_V2 = prepV2 (advV OP_come_V OP_forth_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_forward_V = advV OP_come_V OP_forward_Adv ; -- guess-p-verb
lin come_from_V2 = prepV2 OP_come_V OP_from_Prep ; -- guess-p-verb
lin come_in_V = advV OP_come_V OP_in_Adv ; -- guess-p-verb
lin come_in_V2 = prepV2 OP_come_V OP_in_Prep ; -- guess-p-verb
lin come_in_for_V2 = prepV2 (advV OP_come_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin come_into_V2 = prepV2 OP_come_V OP_into_Prep ; -- guess-p-verb
lin come_into_use_V = variants {} ; -- guess-p-verb
lin come_off_V = advV OP_come_V OP_off_Adv ; -- guess-p-verb
lin come_off_V2 = prepV2 OP_come_V OP_off_Prep ; -- guess-p-verb
lin come_off_it_V = variants {} ; -- guess-p-verb
lin come_on_V = advV OP_come_V OP_on_Adv ; -- guess-p-verb
lin come_out_V = advV OP_come_V OP_out_Adv ; -- guess-p-verb
lin come_out_in_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_in_Prep ; -- guess-p-verb
lin come_out_of_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin come_out_with_V2 = prepV2 (advV OP_come_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_over_V = advV OP_come_V OP_over_Adv ; -- guess-p-verb
lin come_over_V2 = prepV2 OP_come_V OP_over_Prep ; -- guess-p-verb
lin come_round_V = advV OP_come_V OP_round_Adv ; -- guess-p-verb
lin come_through_V = advV OP_come_V OP_through_Adv ; -- guess-p-verb
lin come_through_with_V2 = prepV2 (advV OP_come_V OP_through_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_to_V = advV OP_come_V OP_to_Adv ; -- guess-p-verb
lin come_to_V2 = prepV2 OP_come_V OP_to_Prep ; -- guess-p-verb
lin come_up_V = advV OP_come_V OP_up_Adv ; -- guess-p-verb
lin come_up_against_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_against_Prep ; -- guess-p-verb
lin come_up_to_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin come_up_with_V2 = prepV2 (advV OP_come_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin come_upon_V2 = prepV2 OP_come_V OP_upon_Prep ; -- guess-p-verb
lin come_with_V2 = prepV2 OP_come_V OP_with_Prep ; -- guess-p-verb
lin comedian_N = mkN "comediant" | mkN "comediant" ; --auto
lin comedy_N = mkN "comèdia" feminine ; --auto
lin comet_N = mkN "cometa" feminine | mkN "cometa" masculine ; --auto
lin comfort_N = mkN "comoditat" feminine | mkN "consol" masculine ; --auto
lin comfort_V2 = mkV2 "consolar" ; --auto
lin comfortable_A = mkA "còmode" ; --auto
lin comic_N = mkN "còmic" feminine | mkN "còmic" masculine ; --auto
lin coming_A = mkA "esdevenidor" ; --auto
lin comma_N = mkN "coma" feminine ; --auto
lin command_1_N = variants {} ; ---- sense to be split
lin command_2_N = variants {} ; ---- sense to be split
lin command_V = mkV "manar" ; --auto
lin command_V2 = mkV2 "manar" ; --auto
lin commander_N = mkN "comandant" masculine ; --auto
lin commando_N = mkN "comando" masculine ; --auto
lin commemoration_N = mkN "commemoració" feminine ; --auto
lin commence_V = mkV "començar" ; --auto
lin commence_V2 = mkV2 "començar" ; --auto
lin commensal_N = mkN "comensal" ; --auto
lin commensalism_N = mkN "comensalisme" masculine ; --auto
lin commensurable_A = mkA "commensurable" ; --auto
lin comment_N = mkN "comentari" masculine ;
lin comment_V = mkV "comentar" ; --auto
lin comment_V2 = mkV2 "comentar" ; --auto
lin commentator_N = mkN "comentarista" ; --auto
lin commerce_N = mkN "comerç" masculine ; --auto
lin commercial_A = mkA "comercial" ;
lin commercial_N = mkN "anunci" masculine ; --auto
lin commercialism_N = mkN "comercialisme" masculine ; --auto
lin commissariat_N = mkN "comissaria" feminine ; --auto
lin commission_N = mkN "comissió" feminine ;
lin commission_V2 = mkV2 "encarregar" ; --auto
lin commissioner_N = mkN "comissari" | mkN "comissari" ; --auto
lin commissure_N = mkN "comissura" feminine ; --auto
lin commit_V2 = mkV2 (mkV (admetre_2 "cometre")) ;
lin commitment_N = mkN "compromís" masculine ;
lin committed_A = mkA "compromès" ; --auto
lin committee_N = mkN "comitè" masculine ;
lin commodity_N = mkN "mercaderia" feminine ; --auto
lin common_1_A = mkA "comú" | mkA "habitual" ;
lin common_2_A = mkA "comú" | mkA "habitual" ;
lin commonplace_N = mkN "tòpic" masculine ; --auto
lin communal_A = mkA "comunal" ; --auto
lin communicate_V = mkV "comunicar" ; --auto
lin communicate_V2 = mkV2 "comunicar" ; --auto
lin communication_N = mkN "comunicació" feminine ;
lin communicative_A = mkA "comunicatiu" ; --auto
lin communicator_N = mkN "comunicador" | mkN "comunicador" ; --auto
lin communism_N = mkN "comunisme" masculine ; --auto
lin communist_A = mkA "comunista" ; --auto
lin communist_N = mkN "comunista" ; --auto
lin community_N = mkN "comunitat" feminine ;
lin compact_A = mkA "compacte" ; --auto
lin compact_V2 = mkV2 "compactar" ; --auto
lin compactness_N = mkN "compacitat" feminine ; --auto
lin companion_N = mkN "company" | mkN "company" ; --auto
lin company_1_N = mkN "companyia" masculine ; --split mkN "empresa" fem
lin company_2_N = mkN "companyia" masculine ; --split mkN "empresa" fem
lin comparability_N = mkN "comparabilitat" feminine ; --auto
lin comparable_A = mkA "comparable" ; --auto
lin comparative_A = mkA "comparatiu" ; --auto
lin compare_V = mkV "comparar" ;
lin comparison_N = mkN "comparació" feminine ; --auto
lin compartment_N = mkN "compartiment" masculine ; --auto
lin compass_N = mkN "compàs" masculine ; --auto
lin compassion_N = mkN "compassió" feminine ; --auto
lin compatibility_N = mkN "compatibilitat" feminine ; --auto
lin compatible_A = mkA "compatible" ; --auto
lin compatriotFem_N = variants {} ; ---- sense to be split
lin compatriotMasc_N = variants {} ; ---- sense to be split
lin compel_V2 = mkV2 "obligar" ; --auto
lin compensate_V = mkV "compensar" ; --auto
lin compensate_V2 = mkV2 "compensar" ; --auto
lin compensation_N = mkN "indemnització" feminine ; --auto
lin compensatory_A = mkA "compensatori" ; --auto
lin compete_V = mkV "competir" ; --auto
lin competent_A = mkA "competent" ; --auto
lin competition_N = mkN "concurs" masculine ; --split "competència" (game vs. economic competition)
lin competitive_A = mkA "competitiu" ; --auto
lin competitiveness_N = mkN "competitivitat" feminine ; --auto
lin competitor_N = mkN "competidor" feminine | mkN "competidor" masculine ; --auto
lin compilation_N = mkN "recopilació" feminine ; --auto
lin compile_V2 = mkV2 "compilar" ; --auto
lin compiler_N = mkN "compilador" masculine ; --auto
lin complain_V = mkV "queixar-se" ; --auto
lin complainant_N = mkN "querellant" masculine ; --auto
lin complaint_N = mkN "denúncia" feminine | mkN "queixa" feminine ; --auto
lin complement_V2 = mkV2 "complementar" ; --auto
lin complementarity_N = mkN "complementarietat" feminine ; --auto
lin complementary_A = mkA "complementari" ; --auto
lin complementation_N = mkN "complementació" feminine ; --auto
lin complete_A = mkA "complet" ;
lin complete_V = mkV "completar" ;
lin complete_V2 = mkV2 (mkV "completar") ;
lin completeness_N = mkN "completesa" feminine ; --auto
lin completion_N = mkN "conclusió" feminine ; --auto
lin complex_A = mkA "complex" ;
lin complex_N = mkN "complex" masculine ; --auto
lin complexity_N = mkN "complexitat" feminine ; --auto
lin compliance_N = mkN "conformitat" feminine ; --auto
lin complicate_V2 = mkV2 "complicar" | mkV2 "enredar" ; --auto
lin complication_N = mkN "complicació" feminine ; --auto
lin complicity_N = mkN "complicitat" feminine ; --auto
lin component_N = mkN "component" masculine ; --auto
lin comport_V = mkV "comportar" ; --auto
lin comport_V2 = mkV2 "comportar" ; --auto
lin compose_V = mkV "compondre" ; --auto
lin compose_V2 = mkV2 "compondre" ; --auto
lin composer_N = mkN "compositor" | mkN "compositor" ; --auto
lin composition_N = mkN "composició" feminine ; --auto
lin compote_N = mkN "compota" feminine ; --auto
lin compound_A = mkA "compost" ; --auto
lin compound_N = mkN "compost" masculine ; --auto
lin comprehensibility_N = mkN "comprensibilitat" feminine ; --auto
lin comprehensible_A = mkA "comprensible" ; --auto
lin comprehensive_A = mkA "comprensible" ; --auto
lin compress_V2 = mkV2 "comprimir" ; --auto
lin compressibility_N = mkN "compressibilitat" feminine ; --auto
lin compressible_A = mkA "compressible" ; --auto
lin compression_N = mkN "compressió" feminine ; --auto
lin compressor_N = mkN "compressor" masculine ; --auto
lin comprise_V2 = mkV2 "comprendre" ; --auto
lin compulsive_A = mkA "compulsiu" ; --auto
lin compulsory_A = mkA "obligatori" ; --auto
lin computation_N = mkN "computació" feminine ; --auto
lin computational_A = mkA "computacional" ; --auto
lin compute_V = mkV "computar" ; --auto
lin compute_V2 = mkV2 "computar" ; --auto
lin computer_N = L.computer_N ;
lin computer_science_N = mkN "informàtica" feminine ; --auto
lin computing_N = mkN "informàtica" feminine ; --auto
lin comrade_N = mkN "camarada" ; --auto
lin con_N = mkN "contra" feminine ; --auto
lin concatenation_N = mkN "concatenació" feminine ; --auto
lin concave_A = mkA "còncau" ; --auto
lin concavity_N = mkN "concavitat" feminine ; --auto
lin conceal_V2 = mkV2 "encobrir" ; --auto
lin concede_V = mkV "admetre" | mkV "concedir" ; --auto
lin concede_V2 = mkV2 "admetre" | mkV2 "concedir" ; --auto
lin conceivable_A = mkA "concebible" ; --auto
lin conceive_V = mkV "concebre" ; --auto
lin conceive_V2 = mkV2 "concebre" ; --auto
lin concentrate_V = mkV "concentrar" ;
lin concentrate_V2 = mkV2 (mkV "concentrar") ;
lin concentration_N = mkN "concentració" feminine ; --auto
lin concentric_A = mkA "concèntric" ; --auto
lin concept_N = mkN "concepte" masculine ;
lin conception_N = mkN "concepció" feminine ; --auto
lin conceptual_A = mkA "conceptual" ; --auto
lin conceptualism_N = mkN "conceptualisme" masculine ; --auto
lin concern_N = mkN "preocupació" masculine ;
lin concern_V2 = mkV2 "concernir" | mkV2 "preocupar" ; --auto
lin concerned_A = mkA "preocupat" ;
lin concerning_Prep = mkPrep "respecte de" ; --auto
lin concert_N = mkN "concert" masculine ; --auto
lin concertina_N = mkN "concertina" feminine ; --auto
lin concerto_N = mkN "concert" masculine ; --auto
lin conciliate_V2 = mkV2 "conciliar" ; --auto
lin conciliation_N = mkN "conciliació" feminine ; --auto
lin conciliatory_A = mkA "conciliador" ; --auto
lin concise_A = mkA "concís" ; --auto
lin conclude_V = mkV "concloure" ; --auto
lin conclude_V2 = mkV2 "concloure" ; --auto
lin conclusion_N = mkN "conclusció" feminine ;
lin conclusive_A = mkA "concloent" ; --auto
lin concomitant_A = mkA "concomitant" ; --auto
lin concordat_N = mkN "concordat" masculine ; --auto
lin concrete_A = mkA "concret" ; --auto
lin concrete_N = mkN "formigó" masculine ; --auto
lin concretion_N = mkN "concreció" feminine ; --auto
lin concubinage_N = mkN "concubinat" masculine ; --auto
lin concurrent_A = mkA "concurrent" ; --auto
lin condemn_V2 = mkV2 "condemnar" ; --auto
lin condemnable_A = mkA "condemnable" ; --auto
lin condemnatory_A = mkA "condemnatori" ; --auto
lin condensate_N = mkN "condensat" masculine ; --auto
lin condensation_N = mkN "condensació" feminine ; --auto
lin condense_V = mkV "condensar" ; --auto
lin condense_V2 = mkV2 "condensar" ; --auto
lin condenser_N = mkN "condensador" masculine ; --auto
lin condiment_N = mkN "condiment" masculine ; --auto
lin condition_1_N = mkN "condició" feminine ;
lin condition_2_N = mkN "condició" feminine ;
lin condition_V2 = mkV2 "condicionar" ; --auto
lin conditional_A = mkA "condicional" ; --auto
lin conditioner_N = mkN "condicionador" masculine ; --auto
lin conditioning_N = mkN "condicionament" masculine ; --auto
lin condolence_N = mkN "condol" masculine ; --auto
lin condom_N = mkN "condó" masculine | mkN "preservatiu" masculine ; --auto
lin condominium_N = mkN "condomini" masculine ; --auto
lin condonation_N = mkN "condonació" feminine ; --auto
lin condone_V2 = mkV2 "condonar" ; --auto
lin condor_N = mkN "còndor" masculine ; --auto
lin conduct_N = mkN "conducta" feminine ; --auto
lin conduct_V = mkV "conduir" | mkV "dirigir" ; --auto
lin conduct_V2 = mkV2 "conduir" | mkV2 "dirigir" ; --auto
lin conductance_N = mkN "conductància" feminine ; --auto
lin conduction_N = mkN "conducció" feminine ; --auto
lin conductive_A = mkA "conductor" ; --auto
lin conductivity_N = mkN "conductivitat" feminine ; --auto
lin conductor_N = mkN "director" | mkN "director" ; --auto
lin condyle_N = mkN "còndil" masculine ; --auto
lin cone_N = mkN "con" masculine ; --auto
lin confectioner_N = mkN "pastisser" | mkN "pastisser" ; --auto
lin confectionery_N = mkN "pastisseria" feminine ; --auto
lin confederation_N = mkN "confederació" feminine ; --auto
lin confer_V = mkV "conferir" ; --auto
lin conference_N = mkN "conferència" feminine ;
lin confess_V = mkV "confessar" ; --auto
lin confess_V2 = mkV2 "confessar" ; --auto
lin confession_N = mkN "confessió" feminine ; --auto
lin confetti_N = mkN "paperet" masculine ; --auto
lin confidantFem_N = variants {} ; ---- sense to be split
lin confidantMasc_N = variants {} ; ---- sense to be split
lin confidence_N = mkN "confiança" feminine ;
lin confident_A = mkA "desenfadat" | mkA "segur" ; --auto
lin confidential_A = mkA "confidencial" ; --auto
lin confidentiality_N = mkN "confidencialitat" feminine ; --auto
lin configuration_N = mkN "configuració" feminine ; --auto
lin configure_V2 = mkV2 "configurar" ; --auto
lin confine_V2 = mkV2 "confinar" | mkV2 "limitar" ; --auto
lin confinement_N = mkN "confinament" masculine ; --auto
lin confirm_V2 = mkV2 (mkV "confirmar") ;
lin confirm_VS = mkVS (mkV "confirmar") ;
lin confirmation_N = mkN "confirmació" feminine ; --auto
lin confiscate_V2 = mkV2 "confiscar" ; --auto
lin conflict_N = mkN "conflicte" masculine ;
lin conform_V = mkV "adaptar-se" ; --auto
lin conformist_N = mkN "conformista" ; --auto
lin conformity_N = mkN "conformitat" feminine ; --auto
lin confront_V2 = mkV2 "afrontar" ; --auto
lin confuse_V2 = mkV2 "confondre" ; --auto
lin confusion_N = mkN "confusió" feminine ; --auto
lin congeal_V = mkV "coagular" ; --auto
lin congeal_V2 = mkV2 "coagular" ; --auto
lin congenital_A = mkA "congenital" ; --auto
lin congestion_N = mkN "congestió" feminine ; --auto
lin conglomerate_N = mkN "conglomerant" masculine | mkN "conglomerat" masculine ; --auto
lin congolese_A = mkA "congolès" ; --auto
lin congolese_N = mkN "congolès" | mkN "congolès" ; --auto
lin congratulate_V2 = mkV2 "felicitar" ; --auto
lin congratulation_N = mkN "felicitació" feminine ; --auto
lin congregation_N = mkN "congregació" feminine ; --auto
lin congress_N = mkN "congrés" masculine ; --auto
lin congressman_N = mkN "congressista" ; --auto
lin congresswoman_N = mkN "congressista" ; --auto
lin congruent_A = mkA "congruent" ; --auto
lin conical_A = mkA "cònic" ; --auto
lin conidium_N = mkN "conidi" masculine ; --auto
lin conifer_N = mkN "conífera" feminine ; --auto
lin coniferous_A = mkA "conífer" ; --auto
lin conjecture_N = mkN "conjectura" feminine ; --auto
lin conjoint_A = mkA "conjunt" ; --auto
lin conjugal_A = mkA "conjugal" ; --auto
lin conjugation_N = mkN "conjugació" feminine ; --auto
lin conjunction_N = mkN "conjunció" feminine ; --auto
lin conjunctival_A = mkA "conjuntival" ; --auto
lin conjunctive_N = mkN "conjuntiva" feminine ; --auto
lin conjuncture_N = mkN "conjuntura" feminine ; --auto
lin conjurer_N = mkN "prestidigitador" | mkN "prestidigitador" ; --auto
lin connect_V = mkV "connectar" ; --auto
lin connect_V2 = mkV2 "connectar" ; --auto
lin connection_N = mkN "connexió" feminine ;
lin connectivity_N = mkN "connectivitat" feminine ; --auto
lin connector_N = mkN "connector" masculine ; --auto
lin connoisseur_N = mkN "coneixedor" | mkN "coneixedor" ; --auto
lin connotation_N = mkN "connotació" feminine ; --auto
lin conquer_V2 = mkV2 "conquerir" ; --auto
lin conquest_N = mkN "conquesta" feminine ; --auto
lin consanguinity_N = mkN "consanguinitat" feminine ; --auto
lin conscientious_A = mkA "conscienciós" ; --auto
lin conscious_A = mkA "conscient" ; --auto
lin consciousness_N = mkN "consciència" feminine ; --auto
lin consecrate_V2 = mkV2 "consagrar" ; --auto
lin consecration_N = mkN "consagració" feminine ; --auto
lin consecutive_A = mkA "consecutiu" ; --auto
lin consensus_N = mkN "consens" masculine ; --auto
lin consent_N = mkN "consentiment" masculine ; --auto
lin consent_V = mkV "consentir" ; --auto
lin consequence_N = mkN "conseqüència" ;
lin consequent_A = mkA "consegüent" ; --auto
lin consequential_A = mkA "consegüent" ; --auto
lin conservation_N = mkN "conservació" feminine ; --auto
lin conservatism_N = mkN "conservadorisme" masculine ; --auto
lin conservative_1_N = variants {} ; ---- sense to be split
lin conservative_2_N = variants {} ; ---- sense to be split
lin conservative_A = mkA "conservador" ; --auto
lin conservatoire_N = mkN "conservatori" masculine ; --auto
lin conserve_V2 = mkV2 "conservar" ; --auto
lin consider_V = mkV "considerar" ;
lin consider_V2 = mkV2 (mkV "considerar") ;
lin consider_V2A = mkV2A (mkV "considerar") ParadigmsCat.accusative (mkPrep "com") ;
lin consider_V2V = mkV2V (mkV "considerar") ParadigmsCat.accusative (mkPrep "com") ;
lin consider_V3 = mkV3 (mkV "considerar") ParadigmsCat.accusative (mkPrep "com") ;
lin consider_VS = mkVS (mkV "considerava") ;
lin consider_VV = deVV (mkV "considerar") | deVV (mkV "pensar") ;
lin considerable_A = mkA "considerable" ;
lin consideration_N = mkN "consideració" feminine ;
lin consign_V2 = mkV2 "consignar" ; --auto
lin consist_V = mkV "consistir" ; --auto
lin consistency_N = mkN "consistència" feminine ; --auto
lin consistent_A = mkA "compatible" | mkA "conseqüent" ; --auto
lin consistory_N = mkN "consistori" masculine ; --auto
lin consolation_N = mkN "consol" masculine ; --auto
lin console_N = mkN "consola" feminine ; --auto
lin consolidate_V = mkV "consolidar" ; --auto
lin consolidate_V2 = mkV2 "consolidar" ; --auto
lin consolidation_N = mkN "consolidació" feminine ; --auto
lin consonance_N = mkN "consonància" feminine ; --auto
lin consonant_N = mkN "consonant" feminine ; --auto
lin consonantal_A = mkA "consonàntic" ; --auto
lin consortium_N = mkN "consorci" masculine ; --auto
lin conspiracy_N = mkN "conspiració" feminine ; --auto
lin conspire_V = mkV "conspirar" ; --auto
lin conspire_V2 = mkV2 "conspirar" ; --auto
lin constant_A = mkA "constant" ; --auto
lin constant_N = mkN "constant" feminine ; --auto
lin constellation_N = mkN "constel·lació" feminine ; --auto
lin consternation_N = mkN "consternació" feminine ; --auto
lin constipation_N = mkN "restrenyiment" masculine ; --auto
lin constituent_N = mkN "constituent" masculine ; --auto
lin constitute_V2 = mkV2 "constituir" ; --auto
lin constitution_N = mkN "constitució" feminine ; --auto
lin constitutional_A = mkA "constitucional" ; --auto
lin constitutionalism_N = mkN "constitucionalisme" masculine ; --auto
lin constrain_V2 = mkV2 "constrènyer" ; --auto
lin constraint_N = mkN "constrenyiment" masculine ; --auto
lin constriction_N = mkN "constricció" feminine ; --auto
lin construct_V2 = mkV2 "construir" ; --auto
lin construction_N = mkN "construcció" feminine ; --auto
lin constructive_A = mkA "constructiu" ; --auto
lin constructivism_N = mkN "constructivisme" masculine ; --auto
lin constructor_N = mkN "constructor" feminine | mkN "constructor" | mkN "constructor" masculine ; --auto
lin consul_N = mkN "cònsol" ; --auto
lin consular_A = mkA "consular" ; --auto
lin consulate_N = mkN "consolat" masculine ; --auto
lin consult_V = mkV "consultar" ; --auto
lin consult_V2 = mkV2 "consultar" ; --auto
lin consultancy_N = mkN "consultoria" feminine ; --auto
lin consultant_N = mkN "assessor" masculine ; --auto
lin consultation_N = mkN "consulta" feminine ; --auto
lin consultative_A = mkA "consultiu" ; --auto
lin consume_V = mkV "consumir" ; --auto
lin consume_V2 = mkV2 "consumir" ; --auto
lin consumer_N = mkN "consumidor" ;
lin consummate_V2 = mkV2 "consumar" ; --auto
lin consumption_N = mkN "consum" masculine ; --auto
lin contact_N = mkN "contacte" masculine ;
lin contact_V2 = mkV2 "contactar" ; --auto
lin contagion_N = mkN "contagi" masculine ; --auto
lin contagious_A = mkA "contagiós" ; --auto
lin contain_V2 = mkV2 (mkV (tenir_108 "contenir")) ;
lin container_N = mkN "contenidor" masculine | mkN "envàs" masculine ; --auto
lin containment_N = mkN "contenció" feminine ; --auto
lin contaminant_N = mkN "contaminant" masculine ; --auto
lin contaminate_V2 = mkV2 "contaminar" ; --auto
lin contamination_N = mkN "contaminació" feminine ; --auto
lin contemplate_V = mkV "contemplar" ; --auto
lin contemplate_V2 = mkV2 "contemplar" ; --auto
lin contemplation_N = mkN "contemplació" feminine ; --auto
lin contemporaneity_N = mkN "contemporaneïtat" feminine ; --auto
lin contemporary_A = mkA "contemporani" ; --auto
lin contempt_N = mkN "desacatament" masculine | mkN "menyspreu" masculine ; --auto
lin content_N = mkN "contingut" masculine ;
lin content_V2 = mkV2 "acontentar" ; --auto
lin contention_N = mkN "contesa" feminine ; --auto
lin contentious_A = mkA "contenciós" ; --auto
lin contest_N = mkN "competició" feminine | mkN "concurs" masculine ; --auto
lin contest_V = mkV "disputar" ; --auto
lin contest_V2 = mkV2 "disputar" ; --auto
lin contestable_A = mkA "contestable" ; --auto
lin context_N = mkN "context" masculine ;
lin contextual_A = mkA "contextual" ; --auto
lin contiguity_N = mkN "contigüitat" feminine ; --auto
lin contiguous_A = mkA "contigu" ; --auto
lin continent_N = mkN "continent" masculine ; --auto
lin continental_A = mkA "continental" ; --auto
lin contingency_N = mkN "contingència" feminine ; --auto
lin contingent_A = mkA "contingent" ; --auto
lin contingent_N = mkN "contingent" masculine ; --auto
lin continuation_N = mkN "continuació" feminine ; --auto
lin continue_V = mkV "continuar" ;
lin continue_V2 = mkV2 (mkV "continuar") ;
lin continue_VV = mkVV (mkV "continuar") ; --subcat: continuar + gerund
lin continue_on_V = advV OP_continue_V OP_on_Adv ; -- guess-p-verb
lin continuity_N = mkN "continuïtat" feminine ; --auto
lin continuous_A = mkA "continu" ; --auto
lin continuum_N = mkN "continu" masculine ; --auto
lin contortionist_N = mkN "contorsionista" ; --auto
lin contour_N = mkN "contorn" masculine ; --auto
lin contrabass_N = mkN "contrabaix" masculine ; --auto
lin contraception_N = mkN "contracepció" feminine ; --auto
lin contraceptive_A = mkA "anticonceptiu" ; --auto
lin contraceptive_N = mkN "contraceptiu" masculine ; --auto
lin contract_N = mkN "contracte" masculine ;
lin contract_V = mkV "contreure" ; --auto
lin contract_V2 = mkV2 "contreure" ; --auto
lin contractile_A = mkA "contràctil" ; --auto
lin contraction_N = mkN "contracció" feminine ; --auto
lin contractor_N = mkN "contractista" ; --auto
lin contractual_A = mkA "contractual" ; --auto
lin contracture_N = mkN "contractura" feminine ; --auto
lin contradict_V2 = mkV2 "contradir" ; --auto
lin contradiction_N = mkN "contradicció" feminine ; --auto
lin contradictory_A = mkA "contradictori" ; --auto
lin contraindication_N = mkN "contraindicació" feminine ; --auto
lin contrapuntist_N = mkN "contrapuntista" ; --auto
lin contrary_A = mkA "contrari" ; --auto
lin contrast_N = mkN "contrast" masculine ;
lin contrast_V = mkV "contrastar" ; --auto
lin contrast_V2 = mkV2 "contrastar" ; --auto
lin contravene_V2 = mkV2 "contravenir" ; --auto
lin contravention_N = mkN "contravenció" feminine ; --auto
lin contribute_V = mkV "aportar" | mkV "contribuir" ; --auto
lin contribute_V2 = mkV2 "aportar" | mkV2 "contribuir" ; --auto
lin contribution_N = mkN "contribució" feminine ;
lin contributor_N = mkN "col·laborador" masculine ; --auto
lin contributory_A = mkA "contribuïdor" ; --auto
lin contrive_V = mkV "idear" ; --auto
lin contrive_V2 = mkV2 "idear" ; --auto
lin control_N = mkN "control" masculine ;
lin control_V2 = mkV2 (mkV "controlar") ;
lin controllable_A = mkA "controlable" ; --auto
lin controller_N = mkN "controlador" feminine | mkN "controlador" masculine ; --auto
lin controversial_A = mkA "controvertit" | mkA "polèmic" ; --auto
lin controversy_N = mkN "controvèrsia" feminine | mkN "polèmica" feminine ; --auto
lin convalescence_N = mkN "convalescència" feminine ; --auto
lin convection_N = mkN "convecció" feminine ; --auto
lin convenience_N = mkN "comoditat" feminine ; --auto
lin convenient_A = mkA "convenient" ; --auto
lin convent_N = mkN "convent" masculine ; --auto
lin convention_N = mkN "convenció" feminine | mkN "conveni" masculine ; --auto
lin conventional_A = mkA "convencional" ; --auto
lin converge_V = mkV "convergir" ; --auto
lin convergence_N = mkN "convergència" feminine ; --auto
lin convergent_A = mkA "convergent" ; --auto
lin conversation_N = mkN "conversa" feminine ;
lin conversational_A = mkA "conversacional" ; --auto
lin converse_V = mkV "conversar" ; --auto
lin conversion_N = mkN "conversió" feminine ; --auto
lin convert_V = mkV "convertir" ; --auto
lin convert_V2 = mkV2 "convertir" ; --auto
lin converter_N = mkN "convertidor" masculine ; --auto
lin convertible_A = mkA "convertible" | mkA "transformable" ; --auto
lin convex_A = mkA "convex" ; --auto
lin convexity_N = mkN "convexitat" feminine ; --auto
lin convey_V2 = mkV2 "transmetre" | mkV2 "transportar" ; --auto
lin conveyor_N = mkN "transportador" masculine ; --auto
lin convict_N = mkN "condemnat" feminine | mkN "condemnat" masculine | mkN "galiot" masculine ; --auto
lin convict_V2 = mkV2 "condemnar" ; --auto
lin conviction_N = mkN "condemna" feminine ; --auto
lin convince_V2 = mkV2 "convèncer" ; --auto
lin convoy_N = mkN "comboi" masculine ; --auto
lin convulsion_N = mkN "convulsió" feminine ; --auto
lin cook_N = mkN "cuiner" | mkN "cuiner" ; --auto
lin cook_V = mkV "cuinar" ; --auto
lin cook_V2 = mkV2 "cuinar" ; --auto
lin cooker_N = mkN "cuina" feminine ; --auto
lin cookie_N = mkN "galeta" feminine ; --auto
lin cooking_N = mkN "cuina" feminine ; --auto
lin cool_A = mkA "fresc" ; --auto
lin cool_V = mkV "refredar" ; --auto
lin cool_V2 = mkV2 "refredar" ; --auto
lin cooling_N = mkN "refredament" masculine ; --auto
lin coolness_N = mkN "fredor" feminine ; --auto
lin coop_N = mkN "galliner" masculine ; --auto
lin cooper_N = mkN "boter" feminine | mkN "boter" masculine ; --auto
lin cooperate_V = mkV "cooperar" ; --auto
lin cooperation_N = mkN "cooperació" feminine ; --auto
lin cooperative_A = mkA "cooperatiu" ; --auto
lin cooperative_N = mkN "cooperativa" feminine ; --auto
lin coordinate_N = mkN "coordenada" feminine ; --auto
lin coordinate_V = mkV "coordinar" ; --auto
lin coordinate_V2 = mkV2 "coordinar" ; --auto
lin coordination_N = mkN "coordinació" feminine ; --auto
lin coordinator_N = mkN "coordinador" | mkN "coordinador" ; --auto
lin copal_N = mkN "copal" masculine ; --auto
lin copartner_N = mkN "consoci" | mkN "consoci" ; --auto
lin copartnership_N = mkN "coparticipació" feminine ; --auto
lin cope_V = mkV "sortir-se'n" | mkV "suportar" ; --auto
lin coplanar_A = mkA "coplanari" ; --auto
lin copolymer_N = mkN "copolímer" masculine ; --auto
lin copper_N = mkN "coure" masculine ; --auto
lin coprophagy_N = mkN "coprofàgia" feminine ; --auto
lin copse_N = mkN "boscany" masculine ; --auto
lin copula_N = mkN "còpula" feminine ; --auto
lin copulation_N = mkN "copulació" feminine ; --auto
lin copy_N = mkN "còpia" feminine ;
lin copy_V = mkV "copiar" ; --auto
lin copy_V2 = mkV2 "copiar" ; --auto
lin copyright_N = mkN "copyright" masculine ; --auto
lin coral_N = mkN "corall" masculine | mkN "coral" masculine ; --auto
lin coral_reef_N = mkN "escull de coral" masculine ; --auto
lin cord_N = mkN "cordó" masculine ; --auto
lin cordial_A = mkA "cordial" ; --auto
lin cordless_A = mkA "sense fil" ; --auto
lin corduroy_N = mkN "pana" feminine ; --auto
lin core_N = mkN "nucli" masculine ; --auto
lin coriander_N = mkN "coriandre" masculine ; --auto
lin cork_N = mkN "suro" masculine ; --auto
lin corkscrew_N = mkN "tirabuixó" masculine ; --auto
lin corm_N = mkN "corm" masculine ; --auto
lin corn_N = mkN "blat de moro" masculine | mkN "dacsa" feminine ; --auto
lin cornea_N = mkN "còrnia" feminine ; --auto
lin corneal_A = mkA "corneal" ; --auto
lin cornelian_N = mkN "cornalina" feminine ; --auto
lin corner_N = mkN "racó" masculine ;
lin cornflour_N = mkN "farina de blat de moro" feminine ; --auto
lin cornflower_N = mkN "blauet" masculine ; --auto
lin cornice_N = mkN "cornisa" feminine ; --auto
lin cornstarch_N = mkN "farina de blat de moro" feminine ; --auto
lin corolla_N = mkN "corol·la" feminine ; --auto
lin corollary_N = mkN "corol·lari" masculine ; --auto
lin coronary_A = mkA "coronari" ; --auto
lin coronation_N = mkN "coronació" feminine ; --auto
lin corporal_A = mkA "corporal" ; --auto
lin corporate_A = mkA "corporatiu" ; --auto
lin corporation_N = mkN "empresa" feminine ; --auto
lin corporatism_N = mkN "corporativisme" masculine ; --auto
lin corps_N = mkN "cos" masculine ; --auto
lin corpse_N = mkN "cadàver" masculine ; --auto
lin corpuscle_N = mkN "corpuscle" masculine ; --auto
lin corpuscular_A = mkA "corpuscular" ; --auto
lin correct_A = L.correct_A ;
lin correct_V = mkV "corregir" ; --auto
lin correct_V2 = mkV2 "corregir" ; --auto
lin correctable_A = mkA "corregible" ; --auto
lin correction_1_N = mkN "correcció" feminine ; --auto
lin correction_2_N = mkN "correcció" feminine ; --auto
lin correlate_V = mkV "correlacionar" | mkV "correlar" ; --auto
lin correlate_V2 = mkV2 "correlacionar" | mkV2 "correlar" ; --auto
lin correlation_N = mkN "correlació" feminine ; --auto
lin correlative_A = mkA "correlatiu" ; --auto
lin correspond_V = mkV "correspondre" ; --auto
lin correspond_V2 = mkV2 "correspondre" ; --auto
lin correspondence_N = mkN "correspondència" feminine ; --auto
lin correspondent_N = mkN "corresponsal" ; --auto
lin corresponding_A = mkA "corresponent" ; --auto
lin corridor_N = mkN "passadís" masculine ; --auto
lin corroborate_V2 = mkV2 "corroborar" ; --auto
lin corroboration_N = mkN "corroboració" feminine ; --auto
lin corrode_V = mkV "corroir" ; --auto
lin corrode_V2 = mkV2 "corroir" ; --auto
lin corrosion_N = mkN "corrosió" feminine ; --auto
lin corrupt_A = mkA "corrupte" ; --auto
lin corrupt_V = mkV "corrompre" ; --auto
lin corrupt_V2 = mkV2 "corrompre" ; --auto
lin corruption_N = mkN "corrupció" feminine ; --auto
lin cortege_1_N = variants {} ; ---- sense to be split
lin cortege_2_N = variants {} ; ---- sense to be split
lin cortisone_N = mkN "cortisona" feminine ; --auto
lin corundum_N = mkN "corindó" masculine ; --auto
lin corvette_N = mkN "corbeta" feminine ; --auto
lin corymb_N = mkN "corimbe" masculine ; --auto
lin cosecant_N = mkN "cosecant" feminine ; --auto
lin cosmetic_A = mkA "cosmètic" ; --auto
lin cosmetic_N = mkN "cosmètic" masculine ; --auto
lin cosmic_A = mkA "còsmic" ; --auto
lin cosmogony_N = mkN "cosmogonia" feminine ; --auto
lin cosmologist_N = mkN "cosmologista" ; --auto
lin cosmology_N = mkN "cosmologia" feminine ; --auto
lin cosmos_N = mkN "cosmos" masculine ; --auto
lin cosmotron_N = mkN "cosmotró" masculine ; --auto
lin cost_N = mkN "cost" masculine ;
lin cost_V = mkV "costar" ;
lin cost_V2 = mkV2 (mkV "costar") ;
lin cost_up_V2 = prepV2 OP_cost_V OP_up_Prep ; -- guess-p-verb
lin costly_A = mkA "costós" ; --auto
lin costume_N = mkN "disfressa" feminine | mkN "vestit" masculine ; --auto
lin cotangent_N = mkN "cotangent" feminine ; --auto
lin cottage_N = mkN "casa de camp" feminine ; --auto
lin cotton_N = mkN "cotó" masculine ; --auto
lin cotyledon_N = mkN "cotiledó" masculine ; --auto
lin cougar_N = mkN "puma" masculine ; --auto
lin cough_N = mkN "tos" feminine | mkN "tos" feminine | mkN "tos" feminine | mkN "tos" feminine ; --auto
lin coulomb_N = mkN "coulomb" masculine ; --auto
lin council_N = mkN "ajuntament" masculine ;
lin council_chamber_N = mkN "saló de plens de l'ajuntament" masculine ; --auto
lin councillor_N = mkN "conseller" feminine | mkN "conseller" masculine | mkN "regidor" feminine | mkN "regidor" | mkN "regidor" masculine ; --auto
lin counsel_N = mkN "consell" masculine ; --auto
lin counsel_V2 = mkV2 "aconsellar" ; --auto
lin counsellor_N = mkN "assessor" ; --auto
lin count_1_N = mkN "comte" masculine | mkN "recompte" masculine ; --auto
lin count_2_N = mkN "comte" masculine | mkN "recompte" masculine ; --auto
lin count_V = variants {} ; -- L.count_V2 ;
lin count_V2 = L.count_V2 ;
lin count_against_V2 = prepV2 OP_count_V OP_against_Prep ; -- guess-p-verb
lin count_among_V2 = prepV2 OP_count_V OP_among_Prep ; -- guess-p-verb
lin count_down_V2 = prepV2 OP_count_V OP_down_Prep ; -- guess-p-verb
lin count_for_V2 = prepV2 OP_count_V OP_for_Prep ; -- guess-p-verb
lin count_in_V2 = prepV2 OP_count_V OP_in_Prep ; -- guess-p-verb
lin count_off_V2 = prepV2 OP_count_V OP_off_Prep ; -- guess-p-verb
lin count_on_V2 = prepV2 OP_count_V OP_on_Prep ; -- guess-p-verb
lin count_out_V2 = prepV2 OP_count_V OP_out_Prep ; -- guess-p-verb
lin count_towards_V2 = prepV2 OP_count_V OP_towards_Prep ; -- guess-p-verb
lin count_up_V2 = prepV2 OP_count_V OP_up_Prep ; -- guess-p-verb
lin count_upon_V2 = prepV2 OP_count_V OP_upon_Prep ; -- guess-p-verb
lin countable_A = mkA "comptable" ; --auto
lin counter_N = mkN "comptador" masculine | mkN "taulell" masculine ; --auto
lin counter_V = mkV "contraatacar" ; --auto
lin counterattack_N = mkN "contraatac" masculine ; --auto
lin counterbalance_V2 = mkV2 "contrarestar" ; --auto
lin counterclaim_N = mkN "contradenúncia" feminine ; --auto
lin counterclockwise_Adv = mkAdv "en el sentit contrari de les agulles del rellotge" ; --auto
lin counterculture_N = mkN "contracultura" feminine ; --auto
lin counterespionage_N = mkN "contraespionatge" masculine ; --auto
lin counter_example_N = mkN "contraexemple" masculine ; --auto
lin counteroffensive_N = mkN "contraofensiva" feminine ; --auto
lin counterpane_N = mkN "vànova" feminine ; --auto
lin counterpoint_N = mkN "contrapunt" masculine ; --auto
lin counterpunch_N = mkN "contrapunxó" masculine ; --auto
lin countersignature_N = mkN "contrasignatura" feminine ; --auto
lin counterweight_N = mkN "contrapès" masculine ; --auto
lin countess_N = mkN "comte" feminine ; --auto
lin countless_A = mkA "incomptable" ; --auto
lin country_N = L.country_N ;
lin countryside_N = mkN "camp" masculine ; --auto
lin county_N = mkN "municipi" masculine ;
lin couple_N = mkN "parella" feminine ;
lin coupon_N = mkN "cupó" masculine ; --auto
lin courage_N = mkN "valor" masculine ; --auto
lin courageous_A = mkA "coratjós" ; --auto
lin course_N = mkN "curs" masculine ; --split mkN "rumb"
lin court_1_N = mkN "jutjat" masculine ;
lin court_2_N = mkN "jutjat" masculine ;
lin courtesy_N = mkN "cortesia" feminine ; --auto
lin courtier_N = mkN "cortesà" | mkN "cortesà" ; --auto
lin courtship_N = mkN "festeig" masculine ; --auto
lin courtyard_N = mkN "pati" masculine ; --auto
lin couscous_N = mkN "cuscús" masculine | mkN "cuscús" masculine ; --auto
lin cousin_N = L.cousin_N ;
lin couvade_N = mkN "covada" feminine ; --auto
lin covalent_A = mkA "covalent" ; --auto
lin covariance_N = mkN "covariància" feminine ; --auto
lin covariant_A = mkA "covariant" ; --auto
lin cover_N = mkN "coberta" feminine | mkN "funda" feminine | mkN "portada" feminine ; --auto
lin cover_V2 = mkV2 (mkV "tapar") ;
lin cover_for_V2 = prepV2 (lin V OP_cover_V2) OP_for_Prep ; -- guess-p-verb
lin cover_up_V2 = prepV2 (lin V OP_cover_V2) OP_up_Prep ; -- guess-p-verb
lin coverage_N = mkN "cobertura" feminine ; --auto
lin covering_N = mkN "cobertura" feminine ; --auto
lin cow_N = L.cow_N ;
lin coward_N = mkN "covard" ; --auto
lin cowardice_N = mkN "covardia" feminine ; --auto
lin cowardly_A = mkA "covard" ; --auto
lin cowboy_N = mkN "cowboy" masculine | mkN "vaquer" masculine ; --auto
lin cowgirl_N = mkN "vaquer" feminine ; --auto
lin cowshed_N = mkN "estable" masculine ; --auto
lin coyote_N = mkN "coiot" masculine ; --auto
lin crab_N = mkN "cranc" masculine ; --auto
lin crack_N = mkN "esquerda" feminine ; --auto
lin crack_V2 = mkV2 "esquerdar" ; --auto
lin crackle_V = mkV "crepitar" ; --auto
lin cradle_N = mkN "bressol" masculine ; --auto
lin craft_N = mkN "embarcació" feminine | mkN "habilitat" feminine | mkN "ofici" masculine ; --auto
lin crag_N = mkN "penya" feminine ; --auto
lin cranberry_N = mkN "nabiu" masculine ; --auto
lin crane_N = mkN "grua" feminine ; --auto
lin cranial_A = mkA "cranial" ; --auto
lin crankshaft_N = mkN "cigonyal" masculine ; --auto
lin crap_V = mkV "cagar" ; --auto
lin crash_N = mkN "accident" masculine | mkN "crac" masculine | mkN "xoc" masculine ; --auto
lin crash_V = mkV "xocar" ; --auto
lin crash_dive_V = variants {} ; -- guess-p-verb
lin crash_land_V = variants {} ; -- guess-p-verb
lin crash_land_V2 = variants {} ; -- guess-p-verb
lin crash_out_V = advV OP_crash_V OP_out_Adv ; -- guess-p-verb
lin crater_N = mkN "cràter" masculine ; --auto
lin craton_N = mkN "crató" masculine ; --auto
lin crazy_A = mkA "boig" ; --auto
lin creak_V = mkV "grinyolar" ; --auto
lin cream_N = mkN "crema" feminine | mkN "nata" feminine ; --auto
lin crease_V = mkV "arrugar" ; --auto
lin crease_V2 = mkV2 "arrugar" ; --auto
lin create_V = mkV "crear" ;
lin create_V2 = mkV2 (mkV "crear") ;
lin creatine_N = mkN "creatina" feminine ; --auto
lin creation_N = mkN "creació" feminine ; --auto
lin creative_A = mkA "creatiu" ; --auto
lin creativity_N = mkN "creativitat" feminine ; --auto
lin creator_N = mkN "creador" | mkN "creador" ; --auto
lin creature_N = mkN "criatura" feminine ; --auto
lin credibility_N = mkN "credibilitat" feminine ; --auto
lin credible_A = mkA "creïble" ; --auto
lin credit_N = mkN "crèdit" masculine ;
lin credit_V2 = mkV2 "abonar" ; --auto
lin creditor_N = mkN "creditor" | mkN "creditor" ; --auto
lin creed_N = mkN "credo" masculine ; --auto
lin creek_N = mkN "cala" feminine ; --auto
lin creep_V = mkV "arrossegar-se" ; --auto
lin cremation_N = mkN "cremació" feminine ; --auto
lin crematory_N = mkN "crematori" masculine ; --auto
lin creole_A = mkA "crioll" ; --auto
lin crepe_1_N = variants {} ; ---- sense to be split
lin crepe_2_N = variants {} ; ---- sense to be split
lin crest_N = mkN "cresta" feminine ; --auto
lin cretonne_N = mkN "cretona" feminine ; --auto
lin crew_N = mkN "tripulació" feminine ; --auto
lin crewman_N = mkN "tripulant" ; --auto
lin crib_N = mkN "bressol" masculine ; --auto
lin cricket_N = mkN "criquet" masculine ; --auto
lin crime_N = mkN "crim" masculine ;
lin criminal_A = mkA "criminal" ; --auto
lin criminal_N = mkN "criminal" | mkN "delinqüent" ; --auto
lin criminologist_N = mkN "criminòleg" masculine ; --auto
lin criminology_N = mkN "criminologia" feminine ; --auto
lin crimp_V2 = mkV2 "arrissar" ; --auto
lin crimson_A = mkA "carmesí" ; --auto
lin cripple_N = mkN "esguerrat" | mkN "esguerrat" ; --auto
lin cripple_V2 = mkV2 "esguerrar" ; --auto
lin crisis_N = mkN "crisi" feminine ; --auto
lin criterion_N = mkN "criteri" masculine ; --auto
lin critic_N = mkN "crític" | mkN "crític" ; --auto
lin critical_1_A = variants {} ; ---- sense to be split
lin critical_2_A = variants {} ; ---- sense to be split
lin criticism_N = mkN "crítica" feminine | mkN "criticisme" masculine ; --auto
lin crocodile_N = mkN "cocodril" masculine ; --auto
lin crook_N = mkN "pocavergonya" ; --auto
lin crooked_A = mkA "corb" ; --auto
lin crop_N = mkN "collita" feminine | mkN "cultiu" masculine ; --auto
lin croquet_N = mkN "croquet" masculine ; --auto
lin croquette_N = mkN "croqueta" feminine ; --auto
lin cross_N = mkN "creu" feminine ; --auto
lin cross_V = mkV "creuar" ;
lin cross_V2 = mkV2 (mkV "creuar") ;
lin cross_examine_V2 = variants {} ; -- guess-p-verb
lin cross_fertilize_V2 = variants {} ; -- guess-p-verb
lin cross_index_V2 = variants {} ; -- guess-p-verb
lin cross_off_V2 = prepV2 OP_cross_V OP_off_Prep ; -- guess-p-verb
lin cross_out_V2 = prepV2 OP_cross_V OP_out_Prep ; -- guess-p-verb
lin cross_question_V2 = variants {} ; -- guess-p-verb
lin cross_up_V2 = prepV2 OP_cross_V OP_up_Prep ; -- guess-p-verb
lin crossbar_N = mkN "travesser" masculine ; --auto
lin crossbow_N = mkN "ballesta" feminine ; --auto
lin crosshead_N = mkN "creuera" feminine ; --auto
lin crossing_N = mkN "cruïlla" feminine | mkN "encreuament" masculine ; --auto
lin crow_N = mkN "corb" masculine ; --auto
lin crowbar_N = mkN "alçaprem" masculine ; --auto
lin crowd_N = mkN "multitud" feminine ; --auto
lin crowd_V = mkV "omplir" ; --auto
lin crowd_V2 = mkV2 "omplir" ; --auto
lin crown_N = mkN "corona" feminine ; --auto
lin crucial_A = mkA "crucial" ; --auto
lin crucifer_N = mkN "crucífera" feminine ; --auto
lin crucifix_N = mkN "crucifix" masculine ; --auto
lin crude_A = mkA "cru" ; --auto
lin cruel_A = mkA "cruel" ; --auto
lin cruelty_N = mkN "crueltat" feminine ; --auto
lin cruet_N = mkN "setrilleres" feminine | mkN "setrilleres" feminine ; --auto
lin cruller_N = mkN "xurro" masculine ; --auto
lin crumb_N = mkN "engruna" feminine ; --auto
lin crumble_V = mkV "esmicolar" ; --auto
lin crumble_V2 = mkV2 "esmicolar" ; --auto
lin crumbly_A = mkA "engrunable" ; --auto
lin crunch_N = mkN "cruixit" masculine ; --auto
lin crusade_N = mkN "croada" feminine ; --auto
lin crush_V = mkV "aixafar" ; --auto
lin crush_V2 = mkV2 "aixafar" ; --auto
lin crusher_N = mkN "trituradora" feminine ; --auto
lin crustacean_N = mkN "crustaci" masculine ; --auto
lin crutch_N = mkN "crossa" feminine ; --auto
lin cry_N = mkN "crit" masculine ; --auto
lin cry_V = mkV "plorar" ;
lin cry_V2 = mkV2 (mkV "cridar") ;
lin cry_off_V2 = prepV2 OP_cry_V OP_off_Prep ; -- guess-p-verb
lin cry_out_V = advV OP_cry_V OP_out_Adv ; -- guess-p-verb
lin cryogenic_A = mkA "criogènic" ; --auto
lin cryostat_N = mkN "criòstat" masculine ; --auto
lin crypt_N = mkN "cripta" feminine ; --auto
lin cryptogam_N = mkN "criptògama" feminine ; --auto
lin cryptogram_N = mkN "criptograma" masculine ; --auto
lin cryptography_N = mkN "criptografia" feminine ; --auto
lin crystal_N = mkN "cristall" masculine ; --auto
lin crystalline_A = mkA "cristal·lí" ; --auto
lin crystallography_N = mkN "cristal·lografia" feminine ; --auto
lin cuban_A = mkA "cubà" ; --auto
lin cube_N = mkN "cub" masculine ; --auto
lin cubic_A = mkA "cúbic" ; --auto
lin cubism_N = mkN "cubisme" masculine ; --auto
lin cubital_A = mkA "cubital" ; --auto
lin cucumber_N = mkN "cogombre" masculine ; --auto
lin culminate_V = mkV "culminar" ; --auto
lin culminate_V2 = mkV2 "culminar" ; --auto
lin culmination_N = mkN "culminació" feminine ; --auto
lin culpability_N = mkN "culpabilitat" feminine ; --auto
lin culprit_N = mkN "culpable" ; --auto
lin cult_N = mkN "culte" masculine ; --auto
lin cultivate_V2 = mkV2 "conrear" ; --auto
lin cultivation_N = mkN "cultiu" masculine ; --auto
lin cultivator_N = mkN "conreadora" feminine ; --auto
lin cultural_A = mkA "cultural" ;
lin culture_N = mkN "cultura" feminine ;
lin cultured_A = mkA "cultivat" ; --auto
lin cumbersome_A = mkA "feixuc" ; --auto
lin cumulative_A = mkA "acumulable" | mkA "acumulatiu" | mkA "cumulatiu" ; --auto
lin cumulonimbus_N = mkN "cumulonimbe" masculine | mkN "cumulonimbus" masculine ; --auto
lin cumulus_N = mkN "cúmul" masculine | mkN "cúmulus" masculine ; --auto
lin cuneiform_A = mkA "cuneïforme" ; --auto
lin cunning_A = mkA "astut" ; --auto
lin cunt_N = mkN "cony" masculine ; --auto
lin cup_N = mkN "got" masculine ;
lin cupboard_N = mkN "armari" masculine ; --auto
lin cupid_N = mkN "cupido" masculine ; --auto
lin cuprite_N = mkN "cuprita" feminine ; --auto
lin curator_N = mkN "conservador" feminine | mkN "conservador" masculine ; --auto
lin curd_N = mkN "recuit" masculine ; --auto
lin cure_N = variants {} ;
lin cure_V = mkV "curar" ; --auto
lin cure_V2 = mkV2 "curar" ; --auto
lin curie_N = mkN "curie" masculine ; --auto
lin curiosity_N = mkN "curiositat" feminine ; --auto
lin curious_A = mkA "curiós" ; --auto
lin curium_N = mkN "curi" masculine ; --auto
lin curl_N = mkN "rínxol" masculine ; --auto
lin curler_N = mkN "arrissador" masculine ; --auto
lin currency_N = mkN "moneda" feminine ; --auto
lin current_A = mkA "actual" ;
lin current_1_N = mkN "corrent" masculine ; --auto
lin current_2_N = mkN "corrent" masculine ; --auto
lin curriculum_N = mkN "currículum" masculine ; --auto
lin curry_N = mkN "curri" masculine ; --auto
lin currycomb_N = mkN "estríjol" masculine ; --auto
lin curse_N = mkN "maledicció" feminine ; --auto
lin curse_V = mkV "maleir" ; --auto
lin curse_V2 = mkV2 "maleir" ; --auto
lin cursor_N = mkN "cursor" masculine ; --auto
lin cursory_A = mkA "superficial" ; --auto
lin curtailment_N = mkN "restricció" feminine ; --auto
lin curtain_N = mkN "cortina" feminine | mkN "teló" masculine ; --auto
lin curvature_N = mkN "curvatura" feminine ; --auto
lin curve_N = mkN "corba" feminine ; --auto
lin curve_V = mkV "tòrcer" ; --auto
lin curve_V2 = mkV2 "tòrcer" ; --auto
lin cusp_N = mkN "cúspide" feminine ; --auto
lin custody_N = mkN "custòdia" feminine ; --auto
lin custom_N = mkN "costum" masculine ; --auto
lin customary_A = mkA "consuetudinari" ; --auto
lin customerFem_N = variants {} ; ---- sense to be split
lin customerMasc_N = variants {} ; ---- sense to be split
lin customs_N = mkN "duana" feminine | mkN "duana" feminine ; --auto
lin cut_N = mkN "tallada" feminine | mkN "tall" masculine ; --auto
lin cut_V = mkV "tallar" ;
lin cut_V2 = L.cut_V2 ;
lin cut_across_V2 = prepV2 OP_cut_V OP_across_Prep ; -- guess-p-verb
lin cut_back_V2 = mkV2 (advV OP_cut_V OP_back_Adv ) ; -- guess-p-verb
lin cut_back_on_V2 = prepV2 (advV OP_cut_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_down_V = advV OP_cut_V OP_down_Adv ; -- guess-p-verb
lin cut_down_V2 = prepV2 OP_cut_V OP_down_Prep ; -- guess-p-verb
lin cut_down_on_V2 = prepV2 (advV OP_cut_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_in_V = advV OP_cut_V OP_in_Adv ; -- guess-p-verb
lin cut_in_V2 = prepV2 OP_cut_V OP_in_Prep ; -- guess-p-verb
lin cut_in_on_V2 = prepV2 (advV OP_cut_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_it_out_V2 = variants {} ; -- guess-p-verb
lin cut_off_V = advV OP_cut_V OP_off_Adv ; -- guess-p-verb
lin cut_off_V2 = prepV2 OP_cut_V OP_off_Prep ; -- guess-p-verb
lin cut_out_V = advV OP_cut_V OP_out_Adv ; -- guess-p-verb
lin cut_out_V2 = prepV2 OP_cut_V OP_out_Prep ; -- guess-p-verb
lin cut_out_on_V2 = prepV2 (advV OP_cut_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin cut_up_V = advV OP_cut_V OP_up_Adv ; -- guess-p-verb
lin cut_up_V2 = prepV2 OP_cut_V OP_up_Prep ; -- guess-p-verb
lin cutaneous_A = mkA "cutani" ; --auto
lin cuticle_N = mkN "cutícula" feminine ; --auto
lin cutter_N = mkN "coltell" masculine | mkN "cúter" masculine | mkN "guardacostes" masculine | mkN "tallador" masculine ; --auto
lin cutting_N = mkN "esqueix" masculine ; --auto
lin cyanide_N = mkN "cianur" masculine ; --auto
lin cyanogen_N = mkN "cianogen" masculine ; --auto
lin cyanohydrin_N = mkN "cianohidrina" feminine ; --auto
lin cyanosis_N = mkN "cianosi" feminine ; --auto
lin cybernaut_N = mkN "cibernauta" ; --auto
lin cybernetics_N = mkN "cibernètica" feminine ; --auto
lin cycle_N = mkN "cicle" masculine ; --auto
lin cycling_N = mkN "ciclisme" masculine ; --auto
lin cyclist_N = mkN "ciclista" ; --auto
lin cycloid_N = mkN "cicloide" masculine ; --auto
lin cyclonic_A = mkA "ciclònic" ; --auto
lin cyclosis_N = mkN "ciclosi" feminine ; --auto
lin cyclostome_N = mkN "ciclòstom" masculine ; --auto
lin cyclothymia_N = mkN "ciclotímia" feminine ; --auto
lin cyclotron_N = mkN "ciclotró" masculine ; --auto
lin cylinder_N = mkN "cilindre" masculine ; --auto
lin cylindrical_A = mkA "cilíndric" ; --auto
lin cymbal_N = mkN "platet" masculine ; --auto
lin cynic_N = mkN "cínic" | mkN "cínic" ; --auto
lin cynicism_N = mkN "cinisme" masculine ; --auto
lin cypress_N = mkN "xiprer" masculine ; --auto
lin cypriot_A = mkA "xipriota" ; --auto
lin cypriot_N = mkN "xipriota" ; --auto
lin cyrillic_A = mkA "ciríl·lic" ; --auto
lin cyst_N = mkN "quist" masculine ; --auto
lin cysteine_N = mkN "cisteïna" feminine ; --auto
lin cystocele_N = mkN "cistocele" masculine ; --auto
lin cytogenesis_N = mkN "citogènesi" feminine ; --auto
lin cytogenetics_N = mkN "citogenètica" feminine ; --auto
lin cytokinesis_N = mkN "citocinesi" feminine ; --auto
lin cytological_A = mkA "citològic" ; --auto
lin cytologist_N = mkN "citòleg" feminine | mkN "citòleg" masculine ; --auto
lin cytology_N = mkN "citologia" feminine ; --auto
lin cytolysis_N = mkN "citòlisi" feminine ; --auto
lin cytomegalovirus_N = mkN "citomegalovirus" masculine | mkN "citomegalovirus" masculine ; --auto
lin cytoplasm_N = mkN "citoplasma" masculine ; --auto
lin cytoplasmic_A = mkA "citoplasmàtic" ; --auto
lin cytosine_N = mkN "citosina" feminine ; --auto
lin cytoskeleton_N = mkN "citosquelet" masculine ; --auto
lin cytostome_N = mkN "citostoma" masculine ; --auto
lin cytotoxicity_N = mkN "citotoxicitat" feminine ; --auto
lin czechoslovak_A = mkA "txecoslovac" ; --auto
lin dacite_N = mkN "dacita" feminine ; --auto
lin dactyl_N = mkN "dàctil" masculine ; --auto
lin dad_N = mkN "papà" masculine ; --auto
lin daddy_N = mkN "papà" masculine ; --auto
lin dagger_N = mkN "daga" feminine ; --auto
lin daily_A = mkA "diari" | mkA "quotidià" ; --auto
lin daily_Adv = mkAdv "diàriament" ; --auto
lin damage_N = mkN "desperfecte" masculine ;
lin damage_V2 = mkV2 "avariar" ; --auto
lin damascene_N = mkN "damasquí" feminine | mkN "damasquí" masculine ; --auto
lin damascene_V2 = mkV2 "damasquinar" ; --auto
lin damask_N = mkN "domàs" masculine ; --auto
lin damn_Interj = mkInterj "merda" ;
lin damp_A = mkA "humit" ; --auto
lin dampen_V = mkV "humitejar" ; --auto
lin dampen_V2 = mkV2 "humitejar" ; --auto
lin damper_N = mkN "esmorteïdor" masculine ; --auto
lin dance_N = mkN "ball" masculine | mkN "dansa" feminine ; --auto
lin dance_V = mkV "ballar" ; --auto
lin dance_V2 = mkV2 "ballar" ; --auto
lin dancer_N = mkN "ballador" feminine | mkN "ballador" masculine | mkN "ballarí" feminine | mkN "ballarí" masculine ; --auto
lin dancing_N = mkN "dansa" feminine ; --auto
lin dandelion_N = mkN "dent de lleó" feminine ; --auto
lin dandy_N = mkN "dandi" masculine ; --auto
lin danger_N = mkN "perill" masculine ;
lin dangerous_A = mkA "perillós" ; --auto
lin dangerousness_N = mkN "perillositat" feminine | mkN "perillositat" feminine ; --auto
lin danishFem_N = variants {} ;
lin danishMasc_N = variants {} ;
lin danish_A = mkA "danès" ;
lin dark_A = mkA "fosc" ;
lin dark_N = mkN "fosca" feminine ; --auto
lin darken_V = mkV "enfosquir" ; --auto
lin darken_V2 = mkV2 "enfosquir" ; --auto
lin darkness_N = mkN "foscor" feminine | mkN "foscor" feminine ; --auto
lin darling_N = mkN "estimat" | mkN "estimat" ; --auto
lin darning_N = mkN "sargit" masculine ; --auto
lin data_N = mkN "dades" feminine ;
lin database_N = mkN "base de dades" feminine ; --auto
lin date_1_N = mkN "data" ; --split "cita" (calendar date vs. romantic date)
lin date_3_N = mkN "data" ; --split "cita" (calendar date vs. romantic date)
lin date_7_N = mkN "data" ; --split "cita" (calendar date vs. romantic date)
lin date_V = mkV "datar" ; --auto
lin date_V2 = mkV2 "datar" ; --auto
lin dating_N = mkN "datació" feminine ; --auto
lin daughter_N = mkN "filla" feminine ;
lin daunting_A = mkA "intimidant" ; --auto
lin daw_N = mkN "cornella" feminine ; --auto
lin day_N = L.day_N ;
lin dazzle_V2 = mkV2 "enlluernar" ; --auto
lin de_facto_A = mkA "de facto" ; --auto
lin deacon_N = mkN "diaca" feminine ; --auto
lin deactivation_N = mkN "desactivació" feminine ; --auto
lin dead_A = mkA "mort" ;
lin deadline_N = mkN "data límit" feminine ; --auto
lin deadlock_N = mkN "interbloqueig" masculine ; --auto
lin deadly_A = mkA "mortífer" ; --auto
lin deaf_A = mkA "sord" ; --auto
lin deafening_A = mkA "ensordidor" ; --auto
lin deafness_N = mkN "sordesa" feminine ; --auto
lin deal_N = mkN "pacte" masculine ; --split (reach a deal) vs. "oferta" masc. (a good deal on a product)
lin deal_V = mkV "repartir" ;-- split "vendre" (drugs) ;
lin deal_V2 = mkV2 (mkV "repartir") ; --split "encarregar-se de" (deal with a somthing)
lin dealer_N = mkN "comerciant" ; --auto
lin dean_N = mkN "degà" | mkN "degà" ; --auto
lin deanship_N = mkN "deganat" masculine ; --auto
lin dear_A = mkA "benvolgut" | mkA "estimat" ; --auto
lin dear_Adv = mkAdv "benvolgut/da" | mkAdv "benvolguts/des" ; --auto
lin death_N = mkN "mort" feminine ;
lin debatable_A = mkA "discutible" ; --auto
lin debate_N = mkN "debat" ;
lin debate_V = mkV "debatre" ; --auto
lin debate_V2 = mkV2 "debatre" ; --auto
lin debaucheeFem_N = variants {} ; ---- sense to be split
lin debaucheeMasc_N = variants {} ; ---- sense to be split
lin debit_N = mkN "dèbit" masculine ; --auto
lin debit_V2 = mkV2 "reprovar" ; --auto
lin debris_N = variants {} ;
lin debt_N = mkN "deute" masculine ;
lin debtor_N = mkN "deutor" feminine | mkN "deutor" masculine ; --auto
lin debug_V2 = mkV2 "depurar" ; --auto
lin debugger_N = mkN "depurador" masculine ; --auto
lin debut_1_N = variants {} ; ---- sense to be split
lin debut_2_N = variants {} ; ---- sense to be split
lin debut_V2 = mkV2 "debutar" ; --auto
lin debutante_N = variants {} ;
lin decade_N = mkN "dècada" feminine ; --auto
lin decadence_N = mkN "decadència" feminine ; --auto
lin decadent_A = mkA "decadent" ; --auto
lin decagon_N = mkN "decàgon" masculine ; --auto
lin decalcification_N = mkN "descalcificació" feminine ; --auto
lin decalcomania_N = mkN "calcomania" feminine ; --auto
lin decant_V2 = mkV2 "decantar" ; --auto
lin decantation_N = mkN "decantació" feminine ; --auto
lin decanter_N = mkN "decantador" masculine ; --auto
lin decapitation_N = mkN "decapitació" feminine ; --auto
lin decasyllable_N = mkN "decasíl·lab" masculine ; --auto
lin decathlon_N = mkN "decatló" masculine ; --auto
lin decay_N = mkN "càries" feminine | mkN "decadència" feminine | mkN "desintegració" feminine | mkN "càries" feminine ; --auto
lin decease_N = mkN "decés" masculine ; --auto
lin deceased_A = mkA "difunt" ; --auto
lin deceit_N = mkN "dol" masculine ; --auto
lin deceitful_A = mkA "enganyós" ; --auto
lin deceitfulness_N = mkN "falsedat" feminine ; --auto
lin deceive_V2 = mkV2 "enganyar" ; --auto
lin decelerate_V = mkV "descelerar" ; --auto
lin decelerate_V2 = mkV2 "descelerar" ; --auto
lin decency_N = mkN "decència" feminine ; --auto
lin decent_A = mkA "decent" ; --auto
lin deception_N = mkN "engany" masculine ; --auto
lin deceptive_A = mkA "enganyós" ; --auto
lin decibel_N = mkN "decibel" masculine ; --auto
lin decide_V = verbV (servir_101 "decidir") ;
lin decide_V2 = mkV2 (verbV (servir_101 "decidir")) ;
lin decide_VS = mkVS (verbV (servir_101 "decidir")) ;
lin decide_VV = deVV (verbV (servir_101 "decidir")) ;
lin decide_on_V2 = prepV2 OP_decide_V OP_on_Prep ; -- guess-p-verb
lin decide_upon_V2 = prepV2 OP_decide_V OP_upon_Prep ; -- guess-p-verb
lin decidua_N = mkN "decídua" feminine ; --auto
lin deciduous_A = mkA "caducifoli" ; --auto
lin decile_N = mkN "decil" masculine ; --auto
lin decimal_A = mkA "decimal" ; --auto
lin decimal_N = mkN "decimal" masculine ; --auto
lin decimate_V2 = mkV2 "delmar" ; --auto
lin decision_N = mkN "decisió" feminine ;
lin decisive_A = mkA "decisiu" ; --auto
lin declaim_V = mkV "declamar" ; --auto
lin declaim_V2 = mkV2 "declamar" ; --auto
lin declarative_A = mkA "declaratiu" ; --auto
lin declare_V = mkV "declarar" ; --auto
lin declare_V2 = mkV2 "declarar" ; --auto
lin declination_N = mkN "declinació" feminine ; --auto
lin decline_N = mkN "decadència" feminine | mkN "disminució" feminine ; --auto
lin decline_V = mkV "declinar" ; --auto
lin decline_V2 = mkV2 "declinar" ; --auto
lin declutch_V = mkV "desembragar" ; --auto
lin decoction_N = mkN "decocció" feminine ; --auto
lin decode_V2 = mkV2 "descodificar" ; --auto
lin decoder_N = mkN "descodificador" masculine ; --auto
lin decoding_N = mkN "descodificació" feminine ; --auto
lin decompose_V = mkV "descompondre" ; --auto
lin decompose_V2 = mkV2 "descompondre" ; --auto
lin decomposition_N = mkN "descomposició" feminine ; --auto
lin decompress_V2 = mkV2 "descomprimir" ; --auto
lin decompression_N = mkN "descompressió" feminine ; --auto
lin decontaminate_V2 = mkV2 "descontaminar" ; --auto
lin decontamination_N = mkN "descontaminació" feminine ; --auto
lin decorate_V2 = mkV2 "decorar" ; --auto
lin decoration_N = mkN "decoració" feminine ; --auto
lin decorative_A = mkA "decoratiu" ; --auto
lin decorator_N = mkN "decorador" | mkN "decorador" ; --auto
lin decorous_A = mkA "decorós" ; --auto
lin decoy_N = mkN "cimbell" masculine ; --auto
lin decrease_N = mkN "disminució" feminine ; --auto
lin decree_N = mkN "decret" masculine ; --auto
lin decree_V2 = mkV2 "decretar" ; --auto
lin dedicate_V2 = mkV2 "dedicar" ; --auto
lin dedication_N = mkN "dedicació" feminine ; --auto
lin deduce_V2 = mkV2 "deduir" ; --auto
lin deductible_A = mkA "deduïble" ; --auto
lin deduction_N = mkN "deducció" feminine ; --auto
lin deep_A = mkA "profund" ;
lin deepen_V = mkV "aprofundir" ; --auto
lin deepen_V2 = mkV2 "aprofundir" ; --auto
lin deer_N = mkN "cérvol" masculine ; --auto
lin defeat_N = mkN "derrota" feminine ; --auto
lin defeat_V2 = mkV2 "derrotar" ; --auto
lin defeatism_N = mkN "derrotisme" masculine ; --auto
lin defeatist_N = mkN "derrotista" ; --auto
lin defecation_N = mkN "defecació" feminine ; --auto
lin defect_N = mkN "defecte" masculine ; --auto
lin defective_A = mkA "defectiu" | mkA "defectuós" ; --auto
lin defence_N = mkN "defensa" feminine ;
lin defenceless_A = mkA "indefens" ; --auto
lin defend_V2 = mkV2 "defensar" ; --auto
lin defendant_N = mkN "acusat" ; --auto
lin defenderFem_N = variants {} ; ---- sense to be split
lin defenderMasc_N = variants {} ; ---- sense to be split
lin defensive_A = mkA "defensiu" ; --auto
lin deferential_A = mkA "deferencial" ; --auto
lin defibrillation_N = mkN "desfibril·lació" feminine ; --auto
lin deficient_A = mkA "deficient" ; --auto
lin deficit_N = mkN "dèficit" masculine ; --auto
lin definable_A = mkA "definible" ; --auto
lin define_V = mkV (servir_101 "definir") ;
lin define_V2 = mkV2 (mkV (servir_101 "definir")) ;
lin definite_A = mkA "definitiu" ; --auto
lin definition_N = mkN "definició" feminine ; --auto
lin definitive_A = mkA "definitiu" ; --auto
lin deflation_N = mkN "deflació" feminine ; --auto
lin deflator_N = mkN "deflactor" masculine ; --auto
lin deflector_N = mkN "deflector" masculine ; --auto
lin defoliant_N = mkN "defoliant" masculine ; --auto
lin defoliation_N = mkN "defoliació" feminine ; --auto
lin deforest_V2 = mkV2 "desforestar" ; --auto
lin deform_V2 = mkV2 "deformar" ; --auto
lin deformation_N = mkN "deformació" feminine ; --auto
lin deformity_N = mkN "deformitat" feminine ; --auto
lin defraud_V2 = mkV2 "defraudar" ; --auto
lin defroster_N = mkN "descongelador" masculine ; --auto
lin defy_V2 = mkV2 "desafiar" ; --auto
lin degenerate_A = mkA "degenerat" ; --auto
lin degeneration_N = mkN "degeneració" feminine ; --auto
lin degradation_N = mkN "degradació" feminine ; --auto
lin degrade_V2 = mkV2 "degradar" ; --auto
lin degree_1_N = mkN "grau" masculine ;
lin degree_2_N = mkN "grau" masculine ;
lin degree_3_N = mkN "grau" masculine ;
lin dehydrate_V2 = mkV2 "deshidratar" ; --auto
lin dehydration_N = mkN "deshidratació" feminine ; --auto
lin dejection_N = mkN "dejecció" feminine ; --auto
lin delay_N = mkN "retard" masculine ; --auto
lin delay_V = mkV "retardar" ; --auto
lin delay_V2 = mkV2 "retardar" ; --auto
lin delegate_N = mkN "delegat" | mkN "delegat" ; --auto
lin delegate_V2 = mkV2 "delegar" ; --auto
lin delegation_N = mkN "delegació" feminine ; --auto
lin delete_V2 = mkV2 "eliminar" ; --auto
lin deliberate_A = mkA "deliberat" ; --auto
lin deliberation_N = mkN "deliberació" feminine ; --auto
lin delicacy_N = mkN "delicadesa" feminine ; --auto
lin delicate_A = mkA "delicat" ; --auto
lin delicatessen_N = mkN "xarcuteria" feminine ; --auto
lin delicious_A = mkA "deliciós" ; --auto
lin delight_N = mkN "delícia" feminine ; --auto
lin delightful_A = mkA "deliciós" ; --auto
lin delimit_V2 = mkV2 "acotar" | mkV2 "delimitar" ; --auto
lin delimitation_N = mkN "delimitació" feminine ; --auto
lin delinquency_N = mkN "delinqüència" feminine ; --auto
lin delinquent_A = mkA "morós" ; --auto
lin deliver_V = mkV "repartir" ; --auto
lin deliver_V2 = mkV2 "repartir" ; --auto
lin delivery_N = mkN "entrega" feminine | mkN "lliurament" masculine ; --auto
lin delta_N = mkN "delta" feminine ; --auto
lin deltoid_N = mkN "deltoide" masculine ; --auto
lin deluge_N = mkN "diluvi" masculine ; --auto
lin demagogic_A = mkA "demagògic" ; --auto
lin demagogy_N = mkN "demagògia" feminine ; --auto
lin demand_N = mkN "petició" masculine ;
lin demand_V2 = mkV2 (mkV (servir_101 "exigir")) ;
lin demand_VS = mkVS (mkV (servir_101 "exigir")) ;
lin demanding_A = mkA "exigent" ; --auto
lin demantoid_N = mkN "demantoide" masculine ; --auto
lin demarcate_V2 = mkV2 "demarcar" ; --auto
lin demarcation_N = mkN "demarcació" feminine ; --auto
lin demeanour_N = mkN "posat" masculine ; --auto
lin demise_N = mkN "defunció" feminine ; --auto
lin democracy_N = mkN "democràcia" feminine ; --auto
lin democrat_N = mkN "demòcrata" ; --auto
lin democratic_A = mkA "democràtic" ; --auto
lin demodulation_N = mkN "desmodulació" feminine ; --auto
lin demographer_N = mkN "demògraf" masculine ; --auto
lin demography_N = mkN "demografia" feminine ; --auto
lin demolish_V2 = mkV2 "derrocar" ; --auto
lin demolition_N = mkN "enderroc" masculine ; --auto
lin demon_N = mkN "dimoni" masculine ; --auto
lin demoniac_A = mkA "demoníac" ; --auto
lin demonstrate_V = mkV "demostrar" | mkV "manifestar-se" ; --auto
lin demonstration_N = mkN "manifestació" feminine ; --auto
lin demonstrator_N = mkN "manifestant" ; --auto
lin dendrite_N = mkN "dendrita" feminine ; --auto
lin denial_N = mkN "denegació" feminine ; --auto
lin denigration_N = mkN "denigració" feminine ; --auto
lin denominate_V2 = mkV2 "denominar" ; --auto
lin denomination_N = mkN "denominació" feminine ; --auto
lin denominator_N = mkN "denominador" feminine | mkN "denominador" masculine ; --auto
lin denote_V2 = mkV2 "denotar" ; --auto
lin denouement_N = mkN "desenllaç" masculine ; --auto
lin denounce_V2 = mkV2 "denunciar" ; --auto
lin dense_A = mkA "dens" | mkA "espès" ; --auto
lin densimeter_N = mkN "densímetre" masculine ; --auto
lin densitometer_N = mkN "densitòmetre" masculine ; --auto
lin densitometry_N = mkN "densitometria" feminine ; --auto
lin density_N = mkN "densitat" feminine ; --auto
lin dent_N = mkN "abonyegadura" feminine ; --auto
lin dent_V = mkV "abonyegar" ; --auto
lin dent_V2 = mkV2 "abonyegar" ; --auto
lin dental_A = mkA "dental" ; --auto
lin denticle_N = mkN "denticle" masculine ; --auto
lin dentine_N = mkN "dentina" feminine ; --auto
lin dentist_N = mkN "dentista" ; --auto
lin dentition_N = mkN "dentició" feminine ; --auto
lin denture_N = mkN "dentadura" feminine ; --auto
lin denudation_N = mkN "denudació" feminine ; --auto
lin denunciation_N = mkN "denúncia" feminine ; --auto
lin deny_V2 = mkV2 (mkV "negar") ;
lin deny_V3 = dirdirV3 (mkV "negar") ;
lin deodorant_N = mkN "desodorant" masculine ; --auto
lin department_N = mkN "departament" masculine ;
lin departure_N = mkN "sortida" feminine ; --auto
lin depend_V = mkV (dependre_36 "dependre") ;
lin dependence_N = mkN "dependència" feminine ; --auto
lin dependency_N = mkN "dependència" feminine ; --auto
lin dependent_A = mkA "dependent" ; --auto
lin depict_V2 = mkV2 "descriure" ; --auto
lin depilation_N = mkN "depilació" feminine ; --auto
lin deplete_V2 = mkV2 "exhaurir" ; --auto
lin deplorable_A = mkA "deplorable" ; --auto
lin deploy_V = mkV "desplegar" ; --auto
lin deploy_V2 = mkV2 "desplegar" ; --auto
lin deployment_N = mkN "desplegament" masculine ; --auto
lin depopulation_N = mkN "despoblament" masculine ; --auto
lin deport_V2 = mkV2 "deportar" ; --auto
lin deportation_N = mkN "deportació" feminine ; --auto
lin depose_V = mkV "deposar" ; --auto
lin depose_V2 = mkV2 "deposar" ; --auto
lin deposit_N = mkN "dipòsit" masculine ; --auto
lin deposit_V2 = mkV2 "dipositar" ; --auto
lin depreciate_V = mkV "depreciar" ; --auto
lin depreciate_V2 = mkV2 "depreciar" ; --auto
lin depreciation_N = mkN "depreciació" feminine ; --auto
lin depress_V2 = mkV2 "deprimir" ; --auto
lin depression_N = mkN "depressió" feminine ; --auto
lin deprivation_N = mkN "marginament" masculine ; --auto
lin deprive_V2 = mkV2 "privar" ; --auto
lin depth_N = mkN "profunditat" feminine ; --auto
lin deputation_N = mkN "diputació" feminine ; --auto
lin deputy_N = mkN "ajudant" | mkN "diputat" feminine | mkN "diputat" masculine ; --auto
lin derail_V2 = mkV2 "descarrilar" ; --auto
lin derailment_N = mkN "descarrilament" masculine ; --auto
lin derision_N = mkN "derisió" feminine ; --auto
lin derivable_A = mkA "derivable" ; --auto
lin derivative_A = mkA "derivat" ; --auto
lin derivative_N = mkN "derivat" masculine ; --auto
lin derive_V = mkV "derivar" ; --auto
lin derive_V2 = mkV2 "derivar" ; --auto
lin dermatologistFem_N = variants {} ; ---- sense to be split
lin dermatologistMasc_N = variants {} ; ---- sense to be split
lin dermatology_N = mkN "dermatologia" feminine ; --auto
lin dermatosis_N = mkN "dermatosi" feminine ; --auto
lin derogate_V = mkV "derogar" ; --auto
lin derogation_N = mkN "derogació" feminine ; --auto
lin derogatory_A = mkA "derogatori" ; --auto
lin descend_V = mkV "descendir" ; --auto
lin descend_V2 = mkV2 "descendir" ; --auto
lin descendant_N = mkN "descendent" ; --auto
lin descent_N = mkN "descens" masculine ; --auto
lin describable_A = mkA "descriptible" ; --auto
lin describe_V2 = mkV2 (verbV (escriure_50 "descriure")) ;
lin describe_VS = mkVS (verbV (escriure_50 "descriure")) ;
lin description_N = mkN "descripció" feminine ;
lin descriptive_A = mkA "descriptiu" ; --auto
lin descriptor_N = mkN "descriptor" masculine ; --auto
lin desecrate_V2 = mkV2 "profanar" ; --auto
lin desert_N = mkN "desert" masculine ; --auto
lin desert_V = mkV "desertar" ; --auto
lin desert_V2 = mkV2 "desertar" ; --auto
lin deserter_N = mkN "desertor" | mkN "desertor" ; --auto
lin desertification_N = mkN "desertificació" feminine ; --auto
lin desertion_N = mkN "deserció" feminine ; --auto
lin deserve_V = mkV "merèixer" ; --auto
lin deserve_V2 = mkV2 "merèixer" ; --auto
lin desiccant_N = mkN "dessecant" masculine ; --auto
lin design_N = mkN "disseny" masculine ;
lin design_V = mkV "dissenyar" ;
lin design_V2 = mkV2 (mkV "dissenyar") ;
lin designate_V = mkV "designar" ; --auto
lin designate_V2 = mkV2 "designar" ; --auto
lin designation_N = mkN "assenyalament" masculine ; --auto
lin designer_N = mkN "dissenyador" feminine | mkN "dissenyador" masculine ; --auto
lin desirable_A = mkA "desitjable" ; --auto
lin desire_N = mkN "desig" masculine ; --auto
lin desire_V2 = mkV2 "desitjar" ; --auto
lin desirous_A = mkA "desitjós" ; --auto
lin desist_V = mkV "desistir" ; --auto
lin desk_N = mkN "escriptori" masculine | mkN "pupitre" masculine ; --auto
lin desolation_N = mkN "desolació" feminine ; --auto
lin desorption_N = mkN "desorció" feminine ; --auto
lin despair_N = mkN "desesperació" feminine ; --auto
lin desperate_A = mkA "desesperat" ; --auto
lin despise_V2 = mkV2 "menysprear" ; --auto
lin despite_Prep = mkPrep "tot i" ;
lin despot_N = mkN "dèspota" ; --auto
lin despotism_N = mkN "despotisme" masculine ; --auto
lin desquamation_N = mkN "descamació" feminine ; --auto
lin dessert_N = mkN "postres" feminine | mkN "postres" feminine ; --auto
lin destination_N = mkN "destinació" feminine ; --auto
lin destitution_N = mkN "indigència" feminine ; --auto
lin destroy_V2 = mkV2 "destruir" ; --auto
lin destroyer_N = mkN "destructor" masculine ; --auto
lin destruction_N = mkN "destrucció" feminine ; --auto
lin destructive_A = mkA "destructiu" ; --auto
lin detachable_A = mkA "separable" ; --auto
lin detachment_N = mkN "destacament" masculine ; --auto
lin detail_N = mkN "detall" masculine ;
lin detail_V2 = mkV2 "detallar" ; --auto
lin detain_V2 = mkV2 "detenir" ; --auto
lin detect_V2 = mkV2 "detectar" ; --auto
lin detection_N = mkN "detecció" feminine ; --auto
lin detective_N = mkN "detectiu" ; --auto
lin detector_N = mkN "detector" feminine | mkN "detector" masculine ; --auto
lin detention_N = mkN "detenció" feminine ; --auto
lin deter_V2 = mkV2 "dissuadir" ; --auto
lin detergent_N = mkN "detergent" masculine ; --auto
lin deterioration_N = mkN "deterioració" feminine ; --auto
lin determinable_A = mkA "determinable" ; --auto
lin determinant_N = mkN "determinant" masculine ; --auto
lin determinate_A = mkA "determinat" ; --auto
lin determination_N = mkN "determinació" feminine ; --auto
lin determine_V = mkV "determinar" ;
lin determine_V2 = mkV2 (mkV "determinar") ;
lin determine_V2V = mkV2V (mkV "determinar") ParadigmsCat.accusative (mkPrep "per") ;
lin determine_VS = mkVS (mkV "determinar") ;
lin determinism_N = mkN "determinisme" masculine ; --auto
lin deterministic_A = mkA "determinista" ; --auto
lin deterrence_N = mkN "dissuasió" feminine ; --auto
lin detest_V2 = mkV2 "detestar" ; --auto
lin detestable_A = mkA "detestable" ; --auto
lin detonate_V = mkV "detonar" ; --auto
lin detonate_V2 = mkV2 "detonar" ; --auto
lin detonation_N = mkN "detonació" feminine ; --auto
lin detonator_N = mkN "detonador" masculine ; --auto
lin detour_N = mkN "trencall" masculine ; --auto
lin detoxification_N = mkN "destoxicació" feminine ; --auto
lin detractor_N = mkN "detractor" | mkN "detractor" ; --auto
lin detriment_N = mkN "detriment" masculine ; --auto
lin deuterium_N = mkN "deuteri" masculine ; --auto
lin deuteron_N = mkN "deuteró" masculine ; --auto
lin devaluate_V2 = mkV2 "devaluar" ; --auto
lin devaluation_N = mkN "devaluació" feminine ; --auto
lin devastate_V2 = mkV2 "devastar" ; --auto
lin devastation_N = mkN "devastació" feminine ; --auto
lin develop_V = mkV "desenvolupar" ;
lin develop_V2 = mkV2 (mkV "desenvolupar") ;
lin developer_N = mkN "desenvolupador" | mkN "desenvolupador" | mkN "revelador" masculine ; --auto
lin developing_A = mkA "en desenvolupament" ; --auto
lin development_N = mkN "desenvolupament" masculine ;
lin developmental_A = mkA "del desenvolupament" ; --auto
lin deviation_N = mkN "desviació" feminine ; --auto
lin deviationism_N = mkN "desviacionisme" masculine ; --auto
lin device_N = mkN "aparell" masculine | mkN "dispositiu" masculine ; --auto
lin devil_N = mkN "diable" | mkN "diable" ; --auto
lin devise_V2 = mkV2 "enginyar" ; --auto
lin devote_V2 = mkV2 "dedicar" ; --auto
lin devotion_N = mkN "devoció" feminine ; --auto
lin devour_V2 = mkV2 "devorar" ; --auto
lin dew_N = mkN "rosada" feminine ; --auto
lin dewlap_N = mkN "papada" feminine ; --auto
lin dexter_A = mkA "dretà" ; --auto
lin dextrose_N = mkN "dextrosa" feminine ; --auto
lin diabolical_A = mkA "diabòlic" ; --auto
lin diachronic_A = mkA "diacrònic" ; --auto
lin diacritic_A = mkA "diacrític" ; --auto
lin diadem_N = mkN "diadema" feminine ; --auto
lin diagnose_V2 = mkV2 "diagnosticar" ; --auto
lin diagnosis_N = mkN "diagnosi" feminine ; --auto
lin diagonal_A = mkA "diagonal" ; --auto
lin diagonal_N = mkN "diagonal" feminine ; --auto
lin diagram_N = mkN "diagrama" masculine | mkN "esquema" masculine ; --auto
lin diakinesis_N = mkN "diacinesi" feminine ; --auto
lin dial_N = mkN "dial" masculine ; --auto
lin dialect_N = mkN "dialecte" masculine ; --auto
lin dialectic_A = mkA "dialèctic" ; --auto
lin dialectics_N = mkN "dialèctica" feminine ; --auto
lin dialectology_N = mkN "dialectologia" feminine ; --auto
lin dialog_N = mkN "diàleg" masculine ; --auto
lin dialogue_N = mkN "diàleg" masculine ; --auto
lin dialysis_N = mkN "diàlisi" feminine ; --auto
lin diamagnetism_N = mkN "diamagnetisme" masculine ; --auto
lin diameter_N = mkN "diàmetre" masculine ; --auto
lin diametral_A = mkA "diametral" ; --auto
lin diamond_N = mkN "diamant" masculine ; --auto
lin diapason_N = mkN "diapasó" masculine ; --auto
lin diapedesis_N = mkN "diapedesi" feminine ; --auto
lin diaper_N = mkN "bolquer" masculine ; --auto
lin diaphysis_N = mkN "diàfisi" feminine ; --auto
lin diarrhoea_N = mkN "diarrea" feminine ; --auto
lin diary_N = mkN "agenda" feminine | mkN "diari" masculine | mkN "dietari" masculine ; --auto
lin diaspora_N = mkN "diàspora" feminine ; --auto
lin diastasis_N = mkN "diàstasi" feminine ; --auto
lin diastema_N = mkN "diastema" masculine ; --auto
lin diastole_N = mkN "diàstole" masculine ; --auto
lin diastrophism_N = mkN "diastrofisme" masculine ; --auto
lin diathermy_N = mkN "diatèrmia" feminine ; --auto
lin diathesis_N = mkN "diàtesi" feminine ; --auto
lin diatomic_A = mkA "diatòmic" ; --auto
lin diatonic_A = mkA "diatònic" ; --auto
lin dichotomous_A = mkA "dicotòmic" ; --auto
lin dichotomy_N = mkN "dicotomia" feminine ; --auto
lin dichroism_N = mkN "dicroisme" masculine ; --auto
lin dichromat_N = mkN "dicromat" masculine ; --auto
lin dictate_V = mkV "dictar" ; --auto
lin dictate_V2 = mkV2 "dictar" ; --auto
lin dictation_N = mkN "dictat" masculine ; --auto
lin dictator_N = mkN "dictador" | mkN "dictador" ; --auto
lin dictatorial_A = mkA "dictatorial" ; --auto
lin dictatorship_N = mkN "dictadura" feminine ; --auto
lin diction_N = mkN "dicció" feminine ; --auto
lin dictionary_N = mkN "diccionari" masculine ; --auto
lin didactic_A = mkA "didàctic" ; --auto
lin die_N = mkN "dau" masculine ; --auto
lin die_V = L.die_V ;
lin die_away_V = advV OP_die_V OP_away_Adv ; -- guess-p-verb
lin die_back_V = advV OP_die_V OP_back_Adv ; -- guess-p-verb
lin die_down_V = advV OP_die_V OP_down_Adv ; -- guess-p-verb
lin die_for_V2 = prepV2 OP_die_V OP_for_Prep ; -- guess-p-verb
lin die_off_V = advV OP_die_V OP_off_Adv ; -- guess-p-verb
lin die_out_V = advV OP_die_V OP_out_Adv ; -- guess-p-verb
lin diencephalon_N = mkN "diencèfal" masculine ; --auto
lin diesel_N = mkN "dièsel" masculine ; --auto
lin diet_N = mkN "alimentació" feminine | mkN "dieta" feminine | mkN "règim" masculine ; --auto
lin dietary_A = mkA "dietètic" ; --auto
lin differ_V = mkV "diferir" ; --auto
lin difference_N = mkN "diferència" feminine ;
lin different_A = mkA "diferent" ;
lin differentiable_A = mkA "diferenciable" ; --auto
lin differential_A = mkA "diferencial" ; --auto
lin differential_N = mkN "diferencial" masculine ; --auto
lin differentiate_V = mkV "diferenciar" ; --auto
lin differentiate_V2 = mkV2 "diferenciar" ; --auto
lin differentiation_N = mkN "diferenciació" feminine ; --auto
lin differentiator_N = mkN "diferenciador" feminine | mkN "diferenciador" masculine ; --auto
lin difficult_A = mkA "difícil" ;
lin difficulty_N = mkN "dificultat" feminine ;
lin diffraction_N = mkN "difracció" feminine ; --auto
lin diffuse_A = mkA "difús" ; --auto
lin diffuser_N = mkN "difusor" | mkN "difusor" ; --auto
lin diffusion_N = mkN "difusió" feminine ; --auto
lin dig_V = L.dig_V ;
lin dig_V2 = variants {} ; -- L.dig_V ;
lin dig_in_V = advV OP_dig_V OP_in_Adv ; -- guess-p-verb
lin dig_into_V2 = prepV2 OP_dig_V OP_into_Prep ; -- guess-p-verb
lin dig_out_V2 = prepV2 OP_dig_V OP_out_Prep ; -- guess-p-verb
lin dig_up_V2 = prepV2 OP_dig_V OP_up_Prep ; -- guess-p-verb
lin digester_N = mkN "digestor" masculine ; --auto
lin digestion_N = mkN "digestió" feminine ; --auto
lin digestive_A = mkA "digestiu" ; --auto
lin digger_N = mkN "excavadora" feminine ; --auto
lin digit_N = mkN "dígit" masculine | mkN "guarisme" masculine ; --auto
lin digital_A = mkA "digital" ; --auto
lin digitizer_N = mkN "digitalitzador" masculine ; --auto
lin dignify_V2 = mkV2 "dignificar" ; --auto
lin dignity_N = mkN "dignitat" feminine ; --auto
lin digraph_N = mkN "dígraf" masculine ; --auto
lin digression_N = mkN "digressió" feminine ; --auto
lin dilapidated_A = mkA "ruïnós" ; --auto
lin dilatation_N = mkN "dilatació" feminine ; --auto
lin dilate_V = mkV "dilatar" ; --auto
lin dilate_V2 = mkV2 "dilatar" ; --auto
lin dilatory_A = mkA "dilatori" ; --auto
lin dilemma_N = mkN "dilema" masculine ; --auto
lin dilettante_N = mkN "diletant" ; --auto
lin diligent_A = mkA "diligent" ; --auto
lin dill_N = mkN "anet" masculine ; --auto
lin dilute_V = mkV "diluir" ; --auto
lin dilute_V2 = mkV2 "diluir" ; --auto
lin dilution_N = mkN "dilució" feminine ; --auto
lin dimension_N = mkN "dimensió" feminine ; --auto
lin dimensional_A = mkA "dimensional" ; --auto
lin dimer_N = mkN "dímer" masculine ; --auto
lin diminish_V = mkV "disminuir" ; --auto
lin diminish_V2 = mkV2 "disminuir" ; --auto
lin dimorphism_N = mkN "dimorfisme" masculine ; --auto
lin din_N = mkN "xivarri" masculine ; --auto
lin dinar_N = mkN "dinar" masculine ; --auto
lin dine_V = mkV "sopar" ; --auto
lin dinner_N = mkN "sopar" masculine ;
lin dinosaur_N = mkN "dinosaure" masculine ; --auto
lin diocese_N = mkN "diòcesi" feminine ; --auto
lin diode_N = mkN "díode" masculine ; --auto
lin diorite_N = mkN "diorita" feminine ; --auto
lin dioxide_N = mkN "diòxid" masculine ; --auto
lin dioxin_N = mkN "dioxina" feminine ; --auto
lin dip_N = mkN "cabussament" masculine ; --auto
lin diphtheria_N = mkN "diftèria" feminine ; --auto
lin diphthong_N = mkN "diftong" masculine ; --auto
lin diplococcus_N = mkN "diplococ" masculine ; --auto
lin diploid_A = mkA "diploide" ; --auto
lin diploma_N = mkN "diploma" masculine ; --auto
lin diplomacy_N = mkN "diplomàcia" feminine ; --auto
lin diplomat_N = mkN "diplomàtic" | mkN "diplomàtic" ; --auto
lin diplomatic_A = mkA "diplomàtic" ; --auto
lin dipole_N = mkN "dipol" masculine ; --auto
lin dipper_N = mkN "cullerot" masculine ; --auto
lin dipsomania_N = mkN "dipsomania" feminine ; --auto
lin diptych_N = mkN "díptic" masculine ; --auto
lin direct_A = mkA "directe" ;
lin direct_V = mkV "dirigir" ; --auto
lin direct_V2 = mkV2 "dirigir" ; --auto
lin direction_N = mkN "direcció" masculine ;
lin directional_A = mkA "direccional" ; --auto
lin directive_N = mkN "directiva" feminine ; --auto
lin directivity_N = mkN "directivitat" feminine ; --auto
lin director_N = mkN "cost" masculine | mkN "preu" masculine ; --split "càrrega" fem (police or military, electric charge...)
lin directory_N = mkN "directori" masculine ; --auto
lin dirt_N = mkN "brutícia" feminine ; --auto
lin dirty_A = L.dirty_A ;
lin disability_N = mkN "incapacitat" feminine ; --auto
lin disable_V2 = mkV2 "impossibilitar" ; --auto
lin disabled_A = mkA "discapacitat" | mkA "invàlid" ; --auto
lin disadvantage_N = mkN "desavantatge" masculine ; --auto
lin disagree_V = mkV "discrepar" ; --auto
lin disagree_V2 = mkV2 "discrepar" ; --auto
lin disagreement_N = mkN "desacord" masculine ; --auto
lin disappear_V = mkV "desaparèixer" ; --auto
lin disappearance_N = mkN "desaparició" feminine ; --auto
lin disappoint_V2 = mkV2 "decebre" ; --auto
lin disappointing_A = mkA "decebedor" ; --auto
lin disappointment_N = mkN "decepció" feminine ; --auto
lin disapproval_N = mkN "desaprovació" feminine ; --auto
lin disapprove_V = mkV "desaprovar" ; --auto
lin disapprove_V2 = mkV2 "desaprovar" ; --auto
lin disarm_V = mkV "desarmar" ; --auto
lin disarm_V2 = mkV2 "desarmar" ; --auto
lin disarmament_N = mkN "desarmament" masculine ; --auto
lin disaster_N = mkN "desastre" masculine ; --auto
lin disastrous_A = mkA "desastrós" ; --auto
lin disburse_V = mkV "desemborsar" ; --auto
lin disburse_V2 = mkV2 "desemborsar" ; --auto
lin disc_N = mkN "disc" masculine ; --auto
lin discern_V2 = mkV2 "albirar" ; --auto
lin discharge_N = mkN "cabal" masculine ; --auto
lin discharge_V = mkV "alliberar" | mkV "descarregar" | mkV "supurar" ; --auto
lin discharge_V2 = mkV2 "alliberar" | mkV2 "descarregar" | mkV2 "supurar" ; --auto
lin disciple_N = mkN "deixeble" | mkN "deixeble" feminine | mkN "deixeble" | mkN "deixeble" masculine ; --auto
lin disciplinary_A = mkA "disciplinari" ; --auto
lin discipline_N = mkN "disciplina" feminine ; --auto
lin discipline_V2 = mkV2 "disciplinar" ; --auto
lin disclose_V = mkV "revelar" ; --auto
lin disclose_V2 = mkV2 "revelar" ; --auto
lin disclosure_N = mkN "revelació" feminine ; --auto
lin disco_1_N = mkN "disco" ;
lin disco_2_N = mkN "discoteca" feminine ;
lin discoloration_N = mkN "decoloració" feminine ; --auto
lin discomfort_N = mkN "incomoditat" feminine | mkN "neguit" masculine ; --auto
lin disconcerting_A = mkA "desconcertant" ; --auto
lin disconnection_N = mkN "desconnexió" feminine ; --auto
lin discontent_N = mkN "disgust" masculine ; --auto
lin discontinue_V = mkV "descatalogar" | mkV "discontinuar" | mkV "interrompre" ; --auto
lin discontinue_V2 = mkV2 "descatalogar" | mkV2 "discontinuar" | mkV2 "interrompre" ; --auto
lin discontinuity_N = mkN "discontinuïtat" feminine ; --auto
lin discontinuous_A = mkA "discontinu" ; --auto
lin discord_N = mkN "discòrdia" feminine ; --auto
lin discotheque_N = mkN "discoteca" feminine ; --auto
lin discount_N = mkN "descompte" masculine | mkN "rebaixa" feminine ; --auto
lin discount_V = mkV "descomptar" ; --auto
lin discount_V2 = mkV2 "descomptar" ; --auto
lin discourage_V2 = mkV2 "descoratjar" ; --auto
lin discourse_N = mkN "discurs" masculine ; --auto
lin discover_V = mkV (servir_101 "descobrir") ;
lin discover_V2 = mkV2 (mkV (servir_101 "descobrir")) ;
lin discover_VS = mkVS (mkV (servir_101 "descobrir")) ;
lin discovererFem_N = variants {} ; ---- sense to be split
lin discovererMasc_N = variants {} ; ---- sense to be split
lin discovery_N = mkN "descoberta" feminine ; --auto
lin discreet_A = mkA "discret" ; --auto
lin discrepancy_N = mkN "discrepància" feminine ; --auto
lin discrete_A = mkA "discret" ; --auto
lin discretion_N = mkN "discreció" feminine ; --auto
lin discretionary_A = mkA "discrecional" ; --auto
lin discriminate_V = mkV "discriminar" ; --auto
lin discriminate_V2 = mkV2 "discriminar" ; --auto
lin discrimination_N = mkN "discriminació" feminine ; --auto
lin discriminatory_A = mkA "discriminatori" ; --auto
lin discuss_V2 = mkV2 (mkV (perdre_83 "debatre")) ;
lin discuss_VS = mkVS (mkV (perdre_83 "debatre")) ;
lin discussion_N = mkN "debat" masculine ;
lin disdain_N = mkN "desdeny" masculine ; --auto
lin disdain_V2 = mkV2 "desdenyar" ; --auto
lin disease_N = mkN "malaltia" feminine ;
lin disembark_V = mkV "desembarcar" ; --auto
lin disembark_V2 = mkV2 "desembarcar" ; --auto
lin disenchantment_N = mkN "desencantament" masculine ; --auto
lin disequilibrium_N = mkN "desequilibri" masculine ; --auto
lin disgruntled_A = mkA "descontent" ; --auto
lin disgust_N = mkN "fàstic" masculine ; --auto
lin disgust_V2 = mkV2 "repugnar" ; --auto
lin disgusting_A = mkA "fastigós" ; --auto
lin dish_N = mkN "plat" masculine ; --auto
lin dish_V2 = mkV2 "embotir" ; --auto
lin disharmony_N = mkN "disharmonia" feminine ; --auto
lin dishonest_A = mkA "deshonest" ; --auto
lin dishonesty_N = mkN "deshonestedat" feminine ; --auto
lin dishonour_N = mkN "deshonor" masculine ; --auto
lin dishonour_V2 = mkV2 "deshonrar" ; --auto
lin dishwasher_N = mkN "rentaplats" masculine | mkN "rentaplats" masculine ; --auto
lin disillusion_V2 = mkV2 "desil·lusionar" ; --auto
lin disillusionment_N = mkN "desil·lusió" feminine ; --auto
lin disinfect_V2 = mkV2 "desinfectar" ; --auto
lin disinfectant_N = mkN "desinfectant" masculine ; --auto
lin disinfection_N = mkN "desinfecció" feminine ; --auto
lin disinherit_V2 = mkV2 "desheretar" ; --auto
lin disinheritance_N = mkN "desheretament" masculine ; --auto
lin disintegrate_V = mkV "desintegrar" ; --auto
lin disintegrate_V2 = mkV2 "desintegrar" ; --auto
lin disintegration_N = mkN "desintegració" feminine ; --auto
lin disjoint_A = mkA "disjunt" ; --auto
lin disjunction_N = mkN "disjunció" feminine ; --auto
lin disk_N = mkN "disc" masculine ; --auto
lin diskette_N = mkN "disquet" masculine ; --auto
lin dislike_N = mkN "aversió" feminine ; --auto
lin dislike_V2 = mkV2 "desagradar" ; --auto
lin dislocation_N = mkN "desbaratament" masculine ; --auto
lin disloyal_A = mkA "deslleial" ; --auto
lin dismantle_V2 = mkV2 "desmantellar" ; --auto
lin dismantlement_N = mkN "desmantellament" masculine ; --auto
lin dismay_V = mkV "desanimar" ; --auto
lin dismay_V2 = mkV2 "desanimar" ; --auto
lin dismiss_V2 = mkV2 "despatxar" | mkV2 "rebutjar" ; --auto
lin dismissal_N = mkN "acomiadament" masculine ; --auto
lin disobedience_N = mkN "desobediència" feminine ; --auto
lin disorder_N = mkN "desordre" masculine ; --auto
lin disorient_V2 = mkV2 "desorientar" ; --auto
lin disparity_N = mkN "disparitat" feminine ; --auto
lin dispatch_N = mkN "despatx" masculine ; --auto
lin dispatcher_N = mkN "expedidor" | mkN "expedidor" ; --auto
lin dispel_V2 = mkV2 "esvair" ; --auto
lin dispensary_N = mkN "ambulatori" masculine ; --auto
lin dispensation_N = mkN "administració" feminine ; --auto
lin dispense_V = mkV "dispensar" ; --auto
lin dispense_V2 = mkV2 "dispensar" ; --auto
lin dispenser_N = mkN "dispensador" feminine | mkN "dispensador" masculine ; --auto
lin disperse_V = mkV "dispersar" ; --auto
lin disperse_V2 = mkV2 "dispersar" ; --auto
lin dispersion_N = mkN "dispersió" feminine ; --auto
lin displace_V2 = mkV2 "desplaçar" ; --auto
lin displacement_N = mkN "cubicatge" masculine ; --auto
lin display_N = mkN "exhibició" feminine | mkN "pantalla" feminine | mkN "visualitzador" masculine ; --auto
lin display_V2 = mkV2 "mostrar" ; --auto
lin disposal_N = mkN "disposició" feminine | mkN "eliminació" feminine ; --auto
lin dispose_V = mkV "col·locar" ; --auto
lin dispose_V2 = mkV2 "col·locar" ; --auto
lin disposition_N = mkN "tarannà" masculine ; --auto
lin disproportion_N = mkN "desproporció" feminine ; --auto
lin disproportionate_A = mkA "desproporcionat" ; --auto
lin dispute_N = mkN "disputa" feminine ; --auto
lin disqualification_N = mkN "desqualificació" feminine ; --auto
lin disquisition_N = mkN "disquisició" feminine ; --auto
lin disregard_V2 = mkV2 "desatendre" ; --auto
lin disrespect_N = mkN "falta de respecte" feminine ; --auto
lin disrespectful_A = mkA "irrespectuós" ; --auto
lin disruption_N = mkN "disrupció" feminine ; --auto
lin dissatisfaction_N = mkN "insatisfacció" feminine ; --auto
lin dissect_V2 = mkV2 "dissecar" ; --auto
lin dissection_N = mkN "dissecció" feminine ; --auto
lin dissemble_V = mkV "dissimular" ; --auto
lin dissemble_V2 = mkV2 "dissimular" ; --auto
lin disseminate_V = mkV "disseminar" ; --auto
lin disseminate_V2 = mkV2 "disseminar" ; --auto
lin dissemination_N = mkN "disseminació" feminine ; --auto
lin dissent_N = mkN "dissenció" feminine ; --auto
lin dissent_V = mkV "dissentir" ; --auto
lin dissertation_N = mkN "dissertació" feminine ; --auto
lin dissidence_N = mkN "dissidència" feminine ; --auto
lin dissident_A = mkA "dissident" ; --auto
lin dissimilation_N = mkN "dissimilació" feminine ; --auto
lin dissimulation_N = mkN "dissimulació" feminine ; --auto
lin dissipate_V = mkV "dissipar" ; --auto
lin dissipate_V2 = mkV2 "dissipar" ; --auto
lin dissipation_N = mkN "dissipació" feminine ; --auto
lin dissociate_V2 = mkV2 "dissociar" ; --auto
lin dissociation_N = mkN "dissociació" feminine ; --auto
lin dissolution_N = mkN "dissolució" feminine ; --auto
lin dissolve_V = mkV "dissoldre" ; --auto
lin dissolve_V2 = mkV2 "dissoldre" ; --auto
lin dissonance_N = mkN "dissonància" feminine ; --auto
lin dissonant_A = mkA "dissonant" ; --auto
lin dissyllable_N = mkN "disíl·lab" masculine ; --auto
lin distance_N = mkN "distància" feminine ;
lin distant_A = mkA "distant" ; --auto
lin distend_V = mkV "distendre" ; --auto
lin distend_V2 = mkV2 "distendre" ; --auto
lin distention_N = mkN "distensió" feminine ; --auto
lin distillate_N = mkN "destil·lat" masculine ; --auto
lin distillation_N = mkN "destil·lació" feminine ; --auto
lin distinct_A = mkA "distint" ; --auto
lin distinction_N = mkN "distinció" feminine ; --auto
lin distinctive_A = mkA "distintiu" ; --auto
lin distinguish_V = mkV "distingir" ; --auto
lin distinguish_V2 = mkV2 "distingir" ; --auto
lin distinguished_A = mkA "assenyalat" ; --auto
lin distort_V2 = mkV2 "distorsionar" ; --auto
lin distortion_N = mkN "distorsió" feminine ; --auto
lin distract_V = mkV "distreure" ; --auto
lin distract_V2 = mkV2 "distreure" ; --auto
lin distractedly_Adv = mkAdv "distretament" ; --auto
lin distraction_N = mkN "distracció" feminine ; --auto
lin distress_N = mkN "aflicció" feminine ; --auto
lin distress_V2 = mkV2 "afligir" ; --auto
lin distribute_V2 = mkV2 "distribuir" ; --auto
lin distribution_N = mkN "distribució" feminine ;
lin distributional_A = mkA "distribucional" ; --auto
lin distributor_N = mkN "distribuïdor" feminine | mkN "distribuïdor" masculine ; --auto
lin district_N = mkN "districte" masculine ;
lin distrust_N = mkN "recel" masculine ; --auto
lin disturb_V2 = mkV2 "destorbar" | mkV2 "trastornar" ; --auto
lin disturbance_N = mkN "aldarull" masculine ; --auto
lin disuse_N = mkN "desús" masculine ; --auto
lin disyllabic_A = mkA "disil·làbic" ; --auto
lin dithyramb_N = mkN "ditirambe" masculine ; --auto
lin diuresis_N = mkN "diüresi" feminine ; --auto
lin diurnal_A = mkA "diürn" ; --auto
lin divan_N = mkN "divan" masculine ; --auto
lin dive_N = mkN "capbussament" masculine ; --auto
lin diver_N = mkN "bussejador" | mkN "bussejador" ; --auto
lin diverge_V = mkV "divergir" ; --auto
lin divergence_N = mkN "divergència" feminine ; --auto
lin divergent_A = mkA "divergent" ; --auto
lin diverse_A = mkA "divers" ; --auto
lin diversification_N = mkN "diversificació" feminine ; --auto
lin diversity_N = mkN "diversitat" feminine ; --auto
lin divert_V = mkV "desviar" ; --auto
lin diverticulosis_N = mkN "diverticulosi" feminine ; --auto
lin diverticulum_N = mkN "diverticle" masculine ; --auto
lin divide_V = mkV "dividir" ; --auto
lin divide_V2 = mkV2 "dividir" ; --auto
lin divide_up_V2 = prepV2 OP_divide_V OP_up_Prep ; -- guess-p-verb
lin dividend_N = mkN "dividend" masculine ; --auto
lin divine_A = mkA "diví" ; --auto
lin diving_N = mkN "busseig" masculine | mkN "busseig" masculine ; --auto
lin divinity_N = mkN "divinitat" feminine ; --auto
lin divisibility_N = mkN "divisibilitat" feminine ; --auto
lin division_1_N = mkN "divisió" masculine ;
lin division_2_N = mkN "divisió" masculine ;
lin division_3_N = mkN "divisió" masculine ;
lin divisional_A = mkA "divisori" ; --auto
lin divorce_N = mkN "divorci" masculine ; --auto
lin divorce_V2 = mkV2 "divorciar" ; --auto
lin divulge_V2 = mkV2 "divulgar" ; --auto
lin do_V2 = mkV2 (mkV (fer_56 "fer")) ;
lin docile_A = mkA "dòcil" ; --auto
lin dock_N = mkN "moll" masculine ; --auto
lin docker_N = mkN "estibador" feminine | mkN "estibador" masculine ; --auto
lin dockyard_N = mkN "drassana" feminine ; --auto
lin doctor_N = L.doctor_N ;
lin doctorate_N = mkN "doctorat" masculine ; --auto
lin doctrine_N = mkN "doctrina" feminine ; --auto
lin document_N = mkN "document" masculine ;
lin document_V2 = mkV2 "documentar" ; --auto
lin documentary_A = mkA "documental" ; --auto
lin documentary_N = mkN "documental" masculine ; --auto
lin documentation_N = mkN "documentació" feminine ; --auto
lin dodecagon_N = mkN "dodecàgon" masculine ; --auto
lin dodecahedron_N = mkN "dodecaedre" masculine | mkN "dodecàedre" masculine ; --auto
lin dog_N = L.dog_N ;
lin dogma_N = mkN "dogma" masculine ; --auto
lin dogmatic_A = mkA "dogmàtic" ; --auto
lin dogmatism_N = mkN "dogmatisme" masculine ; --auto
lin dogmatist_N = mkN "dogmàtic" | mkN "dogmàtic" ; --auto
lin doll_N = mkN "nina" feminine ; --auto
lin dollar_N = mkN "dòlar" masculine ; --auto
lin dolphin_N = mkN "dofí" masculine ; --auto
lin domain_N = mkN "àmbit" masculine ; --auto
lin dome_N = mkN "dom" masculine ; --auto
lin domestic_A = mkA "domèstic" ;
lin domestication_N = mkN "domesticació" feminine ; --auto
lin domicile_N = mkN "domicili" masculine ; --auto
lin domiciliary_A = mkA "domiciliari" ; --auto
lin dominant_A = mkA "dominant" ; --auto
lin dominate_V = mkV "dominar" ; --auto
lin dominate_V2 = mkV2 "dominar" ; --auto
lin domination_N = mkN "dominació" feminine ; --auto
lin dominican_A = mkA "dominicà" ; --auto
lin donate_V = mkV "donar" ; --auto
lin donate_V2 = mkV2 "donar" ; --auto
lin donation_N = mkN "donació" feminine | mkN "donatiu" masculine ; --auto
lin donkey_N = mkN "ruc" | mkN "ruc" ; --auto
lin doom_N = mkN "fat" masculine ; --auto
lin door_N = L.door_N ;
lin dopamine_N = mkN "dopamina" feminine ; --auto
lin dope_V2 = mkV2 "dopar" ; --auto
lin doric_A = mkA "dòric" ; --auto
lin dormer_N = mkN "llucana" feminine ; --auto
lin dormitory_N = mkN "dormitori" masculine ; --auto
lin dormouse_N = mkN "liró" masculine ; --auto
lin dorsal_A = mkA "dorsal" ; --auto
lin dosage_N = mkN "dosatge" masculine ; --auto
lin dose_N = mkN "dosi" feminine ; --auto
lin dosimetry_N = mkN "dosímetre" masculine ; --auto
lin dossier_N = mkN "dossier" masculine ; --auto
lin dot_N = mkN "punt" masculine ; --auto
lin double_A = mkA "doble" ; --auto
lin double_N = mkN "doble" masculine ; --auto
lin double_V = mkV "doblar" | mkV "plegar" ; --auto
lin double_V2 = mkV2 "doblar" | mkV2 "plegar" ; --auto
lin double_as_V2 = prepV2 OP_double_V OP_as_Prep ; -- guess-p-verb
lin double_back_V = advV OP_double_V OP_back_Adv ; -- guess-p-verb
lin double_bass_N = mkN "contrabaix" masculine ; --auto
lin double_check_V2 = variants {} ; -- guess-p-verb
lin double_cross_V2 = variants {} ; -- guess-p-verb
lin double_over_V = advV OP_double_V OP_over_Adv ; -- guess-p-verb
lin double_park_V = variants {} ; -- guess-p-verb
lin double_park_V2 = variants {} ; -- guess-p-verb
lin double_up_V = advV OP_double_V OP_up_Adv ; -- guess-p-verb
lin double_up_as_V2 = prepV2 (advV OP_double_V OP_up_Adv ) OP_as_Prep ; -- guess-p-verb
lin doublet_N = mkN "doblet" masculine ; --auto
lin doubt_N = mkN "dubte" masculine ;
lin doubt_V2 = mkV2 "dubtar" ; --auto
lin doubtful_A = mkA "dubtós" ; --auto
lin doubtless_Adv = mkAdv "indubtablement" ; --auto
lin doughnut_N = mkN "dònut" masculine ; --auto
lin down_Adv = mkAdv "avall" ;
lin down_Prep = mkPrep "avall" ;
lin downfall_N = mkN "ensulsiada" feminine ; --auto
lin download_N = mkN "descàrrega" feminine ; --auto
lin downloadable_A = mkA "descarregable" ; --auto
lin downstairs_Adv = mkAdv "a baix" ; --auto
lin downstream_Adv = mkAdv "riu avall" ; --auto
lin downtown_A = mkA "cèntric" ; --auto
lin downward_A = mkA "descendent" ; --auto
lin downward_Adv = mkAdv "a baix" ; --auto
lin downwards_Adv = mkAdv "cap avall" ; --auto
lin dowry_N = mkN "dot" masculine ; --auto
lin dozen_N = mkN "dotzena" feminine ; --auto
lin drachma_N = mkN "dracma" feminine ; --auto
lin draft_N = mkN "esborrany" masculine | mkN "lletra de canvi" feminine ; --auto
lin draft_V2 = mkV2 "reclutar" | mkV2 "redactar" ; --auto
lin drag_V = mkV "arrossegar" | mkV "dragar" ; --auto
lin drag_V2 = mkV2 "arrossegar" | mkV2 "dragar" ; --auto
lin drag_down_V = advV OP_drag_V OP_down_Adv ; -- guess-p-verb
lin drag_in_V = advV OP_drag_V OP_in_Adv ; -- guess-p-verb
lin drag_on_V = advV OP_drag_V OP_on_Adv ; -- guess-p-verb
lin dragon_N = mkN "drac" masculine ; --auto
lin dragonfly_N = mkN "libèl·lula" feminine ; --auto
lin drain_N = mkN "dren" masculine ; --auto
lin drain_V = mkV "desguassar" | mkV "drenar" ; --auto
lin drain_V2 = mkV2 "desguassar" | mkV2 "drenar" ; --auto
lin drainage_N = mkN "drenatge" masculine ; --auto
lin drama_N = mkN "drama" masculine | mkN "obra" feminine | mkN "teatre" masculine ; --auto
lin dramatic_A = mkA "dramàtic" ; --auto
lin dramatist_N = mkN "dramaturg" masculine ; --auto
lin drastic_A = mkA "dràstic" ; --auto
lin draught_N = mkN "glop" masculine ; --auto
lin draw_1_V2 = mkV2 (mkV "dibuixar") ; --split "treure" (draw from something)
lin draw_2_V2 = mkV2 (mkV "dibuixar") ; --split "treure" (draw from something)
lin draw_N = mkN "sorteig" masculine ; --auto
lin draw_V = mkV "dibuixar" ;
lin draw_back_V2 = mkV2 (advV OP_draw_V OP_back_Adv ) ; -- guess-p-verb
lin draw_down_V2 = prepV2 OP_draw_V OP_down_Prep ; -- guess-p-verb
lin draw_even_V = advV OP_draw_V OP_even_Adv ; -- guess-p-verb
lin draw_in_V = advV OP_draw_V OP_in_Adv ; -- guess-p-verb
lin draw_into_V2 = prepV2 OP_draw_V OP_into_Prep ; -- guess-p-verb
lin draw_off_V = advV OP_draw_V OP_off_Adv ; -- guess-p-verb
lin draw_on_V = advV OP_draw_V OP_on_Adv ; -- guess-p-verb
lin draw_on_V2 = prepV2 OP_draw_V OP_on_Prep ; -- guess-p-verb
lin draw_out_V2 = prepV2 OP_draw_V OP_out_Prep ; -- guess-p-verb
lin draw_up_V = advV OP_draw_V OP_up_Adv ; -- guess-p-verb
lin draw_up_V2 = prepV2 OP_draw_V OP_up_Prep ; -- guess-p-verb
lin drawee_N = mkN "lliurat" masculine ; --auto
lin drawer_N = mkN "calaix" masculine ; --auto
lin drawing_N = mkN "dibuix" masculine ; --auto
lin dreadful_A = mkA "terrible" ; --auto
lin dream_N = mkN "somni" masculine ; --auto
lin dream_V = mkV "somiar" ; --auto
lin dream_V2 = mkV2 "somiar" ; --auto
lin dream_of_V2 = prepV2 OP_dream_V OP_of_Prep ; -- guess-p-verb
lin dream_up_V2 = prepV2 OP_dream_V OP_up_Prep ; -- guess-p-verb
lin dredge_V = mkV "dragar" ; --auto
lin dredge_V2 = mkV2 "dragar" ; --auto
lin dredger_N = mkN "dragador" masculine ; --auto
lin dregs_N = mkN "pòsit" masculine ; --auto
lin dress_N = mkN "vestit" masculine ; --auto
lin dress_V = mkV "vestir" ; --auto
lin dress_V2 = mkV2 "vestir" ; --auto
lin dress_down_V = advV OP_dress_V OP_down_Adv ; -- guess-p-verb
lin dress_down_V2 = prepV2 OP_dress_V OP_down_Prep ; -- guess-p-verb
lin dress_up_V = advV OP_dress_V OP_up_Adv ; -- guess-p-verb
lin dress_up_V2 = prepV2 OP_dress_V OP_up_Prep ; -- guess-p-verb
lin dresser_N = mkN "tocador" masculine ; --auto
lin dressing_N = mkN "apòsit" masculine ; --auto
lin dribble_N = mkN "driblatge" masculine ; --auto
lin dribbler_N = mkN "driblador" masculine ; --auto
lin drift_N = mkN "drift" masculine ; --auto
lin drift_V = mkV "anar a la deriva" ; --auto
lin drink_N = mkN "beguda" feminine ;
lin drink_V = mkV (beure_11 "beure") ;
lin drink_V2 = L.drink_V2 ;
lin drink_up_V2 = prepV2 OP_drink_V OP_up_Prep ; -- guess-p-verb
lin drip_V = mkV "gotejar" ; --auto
lin drip_V2 = mkV2 "gotejar" ; --auto
lin drive_N = mkN "accionament" masculine | mkN "passeig" masculine ; --auto
lin drive_V = mkV (reduir_94 "conduir") ;
lin drive_V2 = mkV2 (mkV (reduir_94 "conduir")) ;
lin drive_V2V = mkV2V (mkV "portar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin drive_away_V2 = mkV2 (advV OP_drive_V OP_away_Adv ) ; -- guess-p-verb
lin drive_back_V2 = mkV2 (advV OP_drive_V OP_back_Adv ) ; -- guess-p-verb
lin drive_by_V = advV OP_drive_V OP_by_Adv ; -- guess-p-verb
lin drive_down_V = advV OP_drive_V OP_down_Adv ; -- guess-p-verb
lin drive_off_V = advV OP_drive_V OP_off_Adv ; -- guess-p-verb
lin drive_out_V2 = prepV2 OP_drive_V OP_out_Prep ; -- guess-p-verb
lin drive_up_V = advV OP_drive_V OP_up_Adv ; -- guess-p-verb
lin drive_up_V2 = prepV2 OP_drive_V OP_up_Prep ; -- guess-p-verb
lin driverFem_N = mkN "conductor" | mkN "conductor" ; --auto ---- sense to be split
lin driverMasc_N = mkN "conductor" | mkN "conductor" ; --auto ---- sense to be split
lin driver_N = mkN "conductor" | mkN "conductor" ; --auto
lin driveway_N = mkN "gual" masculine ; --auto
lin driving_N = mkN "comandament" masculine | mkN "conducció" feminine ; --auto
lin drizzle_N = mkN "plugim" masculine ; --auto
lin dromedary_N = mkN "dromedari" masculine ; --auto
lin drone_N = mkN "vagarro" masculine ; --auto
lin drop_N = mkN "baixada" feminine | mkN "gota" feminine ; --auto
lin drop_V = mkV (caure_18 "caure") ;
lin drop_around_V = advV OP_drop_V OP_around_Adv ; -- guess-p-verb
lin drop_around_V2 = prepV2 OP_drop_V OP_around_Prep ; -- guess-p-verb
lin drop_away_V = advV OP_drop_V OP_away_Adv ; -- guess-p-verb
lin drop_back_V = advV OP_drop_V OP_back_Adv ; -- guess-p-verb
lin drop_by_V = advV OP_drop_V OP_by_Adv ; -- guess-p-verb
lin drop_in_V = advV OP_drop_V OP_in_Adv ; -- guess-p-verb
lin drop_in_on_V2 = prepV2 (advV OP_drop_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin drop_off_V = advV OP_drop_V OP_off_Adv ; -- guess-p-verb
lin drop_off_V2 = prepV2 OP_drop_V OP_off_Prep ; -- guess-p-verb
lin drop_out_V = advV OP_drop_V OP_out_Adv ; -- guess-p-verb
lin drop_out_of_V2 = prepV2 (advV OP_drop_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin drop_over_V = advV OP_drop_V OP_over_Adv ; -- guess-p-verb
lin drop_round_V = advV OP_drop_V OP_round_Adv ; -- guess-p-verb
lin drop_round_V2 = prepV2 OP_drop_V OP_round_Prep ; -- guess-p-verb
lin drop_someone_in_it_V2 = variants {} ; -- guess-p-verb
lin drop_through_V = advV OP_drop_V OP_through_Adv ; -- guess-p-verb
lin droplet_N = mkN "goteta" feminine ; --auto
lin dropper_N = mkN "comptagotes" masculine | mkN "comptagotes" masculine ; --auto
lin dropsy_N = mkN "hidropesia" feminine ; --auto
lin drought_N = mkN "sequera" feminine ; --auto
lin drown_V = mkV "inundar" | mkV "ofegar-se" ; --auto
lin drug_N = mkN "droga" feminine ;
lin drug_V2 = mkV2 "drogar" ; --auto
lin drugstore_N = mkN "farmàcia" feminine ; --auto
lin drum_N = mkN "barril" masculine | mkN "tambor" masculine | mkN "timbal" masculine ; --auto
lin drunk_A = mkA "borratxo" ; --auto
lin drunkard_N = mkN "borratxo" | mkN "borratxo" ; --auto
lin drunkenness_N = mkN "embriaguesa" feminine ; --auto
lin drupe_N = mkN "drupa" feminine ; --auto
lin dry_A = L.dry_A ;
lin dry_V = mkV "assecar" ; --auto
lin dry_V2 = mkV2 "assecar" ; --auto
lin dry_clean_V2 = mkV2 (advV OP_dry_V OP_clean_Adv ) ; -- guess-p-verb
lin dry_off_V2 = prepV2 OP_dry_V OP_off_Prep ; -- guess-p-verb
lin dry_out_V = advV OP_dry_V OP_out_Adv ; -- guess-p-verb
lin dry_out_V2 = prepV2 OP_dry_V OP_out_Prep ; -- guess-p-verb
lin dry_up_V = advV OP_dry_V OP_up_Adv ; -- guess-p-verb
lin dry_up_V2 = prepV2 OP_dry_V OP_up_Prep ; -- guess-p-verb
lin dryer_N = mkN "assecador" masculine ; --auto
lin dryness_N = mkN "sequedat" feminine ; --auto
lin dual_A = mkA "dual" ; --auto
lin dualism_N = mkN "dualisme" masculine ; --auto
lin duality_N = mkN "dualitat" feminine ; --auto
lin dub_V2 = mkV2 "batejar" ; --auto
lin dubbing_N = mkN "doblatge" masculine ; --auto
lin duck_N = mkN "ànec" masculine ; --auto
lin ductile_A = mkA "dúctil" ; --auto
lin ductility_N = mkN "ductilitat" feminine ; --auto
lin due_A = mkA "esperat" ; --sense cannot be conveyed by a single word
lin due_to_Prep = mkPrep "a causa de" ; --auto
lin duel_N = mkN "duel" masculine ; --auto
lin duet_N = mkN "duet" masculine ; --auto
lin duke_N = mkN "duc" feminine | mkN "duc" masculine ; --auto
lin dull_A = L.dull_A ;
lin dull_V = mkV "atenuar" | mkV "desllustrar" ; --auto
lin dull_V2 = mkV2 "atenuar" | mkV2 "desllustrar" ; --auto
lin dumb_A = mkA "mut" ; --auto
lin dumbness_N = mkN "mudesa" feminine ; --auto
lin dump_N = mkN "abocador" masculine ; --auto
lin dump_V = mkV "abocar" | mkV "bolcar" | mkV "desfer-se de" ; --auto
lin dumper_N = mkN "dúmper" masculine ; --auto
lin dumping_N = mkN "dumping" masculine ; --auto
lin dune_N = mkN "duna" feminine ; --auto
lin dungeon_N = mkN "masmorra" feminine ; --auto
lin duodecimal_A = mkA "duodecimal" ; --auto
lin duodenal_A = mkA "duodenal" ; --auto
lin dupe_V2 = mkV2 "enredar" ; --auto
lin duplicate_A = mkA "duplicat" ; --auto
lin duplicate_N = mkN "duplicat" masculine ; --auto
lin duplicate_V2 = mkV2 "duplicar" ; --auto
lin duplication_N = mkN "duplicació" feminine ; --auto
lin durability_N = mkN "durabilitat" feminine ; --auto
lin durable_A = mkA "durador" ; --auto
lin duration_N = mkN "duració" feminine ; --auto
lin during_Prep = S.during_Prep ;
lin dusk_N = mkN "crepuscle" masculine ; --auto
lin dust_N = L.dust_N ;
lin duster_N = mkN "empolsadora" feminine ; --auto
lin dustpan_N = mkN "recollidor" masculine ; --auto
lin dutchFem_N = variants {} ;
lin dutchMasc_N = variants {} ;
lin dutch_A = mkA "holandès" ;
lin dutiful_A = mkA "obedient" ; --auto
lin duty_N = mkN "deure" masculine ;
lin duvet_N = mkN "edredó" masculine ; --auto
lin dwarf_N = mkN "nan" | mkN "nan" ; --auto
lin dwarfism_N = mkN "enanisme" masculine ; --auto
lin dyadic_A = mkA "diàdic" ; --auto
lin dye_N = mkN "tint" masculine ; --auto
lin dye_V = mkV "tenyir" ; --auto
lin dye_V2 = mkV2 "tenyir" ; --auto
lin dyeing_N = mkN "tintura" feminine ; --auto
lin dyke_N = mkN "muralleta" feminine ; --auto
lin dynamic_A = mkA "dinàmic" ; --auto
lin dynamics_N = mkN "dinàmica" feminine ; --auto
lin dynamism_N = mkN "dinamisme" masculine ; --auto
lin dynamite_N = mkN "dinamita" feminine ; --auto
lin dynamometer_N = mkN "dinamòmetre" masculine ; --auto
lin dynast_N = mkN "dinasta" masculine ; --auto
lin dynastic_A = mkA "dinàstic" ; --auto
lin dynasty_N = mkN "dinastia" feminine ; --auto
lin dyne_N = mkN "dina" feminine ; --auto
lin dysentery_N = mkN "disenteria" feminine ; --auto
lin dysfunction_N = mkN "disfunció" feminine ; --auto
lin dyslexia_N = mkN "dislèxia" feminine ; --auto
lin dysmenorrhea_N = mkN "dismenorrea" feminine ; --auto
lin dyspepsia_N = mkN "dispèpsia" feminine ; --auto
lin dysplasia_N = mkN "displàsia" feminine ; --auto
lin dyspnea_N = mkN "dispnea" feminine ; --auto
lin dysprosium_N = mkN "disprosi" feminine ; --auto
lin dystrophy_N = mkN "distròfia" feminine ; --auto
lin each_Det = S.every_Det ;
lin eager_A = mkA "frisós" ; --auto
lin eagerness_N = mkN "ànsia" feminine ; --auto
lin eagle_N = mkN "àguila" feminine ; --auto
lin ear_N = L.ear_N ;
lin eardrum_N = mkN "timpà" masculine ; --auto
lin earl_N = mkN "comte" masculine ; --auto
lin earlier_Adv = mkAdv "més d'hora" ; --auto
lin early_A = mkA "aviat" ;
lin early_Adv = mkAdv "aviat" ;
lin earn_V = mkV "cobrar" | mkV "guanyar" ; --auto
lin earn_V2 = mkV2 "cobrar" | mkV2 "guanyar" ; --auto
lin earnings_N = mkN "ingrés" masculine ; --auto
lin earplug_N = mkN "tap per a les orelles" masculine ; --auto
lin earring_N = mkN "arracada" feminine ; --auto
lin earth_N = L.earth_N ;
lin earthly_A = mkA "terrenal" ; --auto
lin earthquake_N = mkN "terratrèmol" masculine ; --auto
lin earthy_A = mkA "groller" ; --auto
lin ease_N = mkN "facilitat" feminine ; --auto
lin ease_V = mkV "alleujar" ; --auto
lin ease_V2 = mkV2 "alleujar" ; --auto
lin ease_off_V2 = prepV2 OP_ease_V OP_off_Prep ; -- guess-p-verb
lin ease_up_V = advV OP_ease_V OP_up_Adv ; -- guess-p-verb
lin east_A = mkA "de l'est" | mkA "est" ; --auto
lin east_Adv = mkAdv "a l'est" ; --auto
lin east_N = mkN "est" masculine ; --auto
lin eastern_A = mkA "oriental" ; --auto
lin eastward_Adv = mkAdv "cap a l'est" ; --auto
lin eastwards_Adv = mkAdv "cap a l'est" ; --auto
lin easy_A = mkA "fàcil" ;
lin eat_V = mkV "menjar" ;
lin eat_V2 = L.eat_V2 ;
lin eat_away_V = advV OP_eat_V OP_away_Adv ; -- guess-p-verb
lin eat_away_V2 = mkV2 (advV OP_eat_V OP_away_Adv ) ; -- guess-p-verb
lin eat_in_V = advV OP_eat_V OP_in_Adv ; -- guess-p-verb
lin eat_into_V2 = prepV2 OP_eat_V OP_into_Prep ; -- guess-p-verb
lin eat_out_V = advV OP_eat_V OP_out_Adv ; -- guess-p-verb
lin eat_up_V2 = prepV2 OP_eat_V OP_up_Prep ; -- guess-p-verb
lin eavesdropper_N = mkN "tafaner" | mkN "tafaner" ; --auto
lin ebullient_A = mkA "exaltat" ; --auto
lin eccentric_A = mkA "excèntric" ; --auto
lin eccentricity_N = mkN "excentricitat" feminine ; --auto
lin ecchymosis_N = mkN "equimosi" feminine ; --auto
lin ecclesiastical_A = mkA "eclesiàstic" ; --auto
lin echelon_N = mkN "escalafó" masculine ; --auto
lin echidna_N = mkN "equidna" feminine ; --auto
lin echinoderm_N = mkN "equinoderm" masculine ; --auto
lin echo_N = mkN "eco" masculine ; --auto
lin echo_V = mkV "repetir" | mkV "ressonar" ; --auto
lin echo_V2 = mkV2 "repetir" | mkV2 "ressonar" ; --auto
lin eclampsia_N = mkN "eclàmpsia" feminine ; --auto
lin eclectic_N = mkN "eclèctic" feminine | mkN "eclèctic" masculine ; --auto
lin eclecticism_N = mkN "eclecticisme" masculine ; --auto
lin eclipse_N = mkN "eclipsi" masculine ; --auto
lin ecliptic_N = mkN "eclíptica" feminine ; --auto
lin eclogue_N = mkN "ègloga" feminine ; --auto
lin ecological_A = mkA "ecològic" ; --auto
lin ecologist_N = mkN "ecòleg" feminine | mkN "ecòleg" masculine ; --auto
lin ecology_N = mkN "ecologia" feminine ; --auto
lin economic_A = mkA "econòmic" ;
lin economical_A = mkA "econòmic" ; --auto
lin economics_N = mkN "economia" feminine ; --auto
lin economist_N = mkN "economista" ; --auto
lin economizer_N = mkN "economitzador" masculine ; --auto
lin economy_1_N = mkN "economia" feminine ;
lin economy_2_N = mkN "economia" feminine ;
lin ecosystem_N = mkN "ecosistema" masculine ; --auto
lin ecstasy_N = mkN "èxtasi" masculine ; --auto
lin ectoderm_N = mkN "ectoderma" masculine ; --auto
lin ectodermal_A = mkA "ectodèrmic" ; --auto
lin ectoplasm_N = mkN "ectoplasma" masculine ; --auto
lin ecuadorian_A = mkA "equatorià" ; --auto
lin eczema_N = mkN "èczema" masculine ; --auto
lin eddy_N = mkN "remolí" masculine ; --auto
lin edema_N = mkN "edema" masculine ; --auto
lin edge_N = mkN "vora" feminine ;
lin edgewise_Adv = mkAdv "de costat" ; --auto
lin edible_A = mkA "comestible" ; --auto
lin edict_N = mkN "ban" masculine | mkN "edicte" masculine ; --auto
lin edit_V2 = mkV2 "editar" ; --auto
lin edition_N = mkN "edició" feminine ; --auto
lin editor_N = mkN "editor" ; --auto
lin editorial_N = mkN "editorial" masculine ; --auto
lin educate_V2 = mkV2 "educar" ; --auto
lin education_N = mkN "educació" masculine ;
lin educational_A = mkA "educatiu" ; --auto
lin educative_A = mkA "educatiu" ; --auto
lin educator_N = mkN "educador" | mkN "educador" ; --auto
lin eel_N = mkN "anguila" feminine ; --auto
lin effect_N = mkN "efecte" masculine ;
lin effect_V2 = mkV2 "efectuar" ; --auto
lin effective_A = mkA "efectiu" ;
lin effectiveness_N = mkN "efectivitat" feminine ; --auto
lin effector_N = mkN "efector" masculine ; --auto
lin effervescence_N = mkN "efervescència" feminine ; --auto
lin efficacy_N = mkN "eficàcia" feminine ; --auto
lin efficiency_N = mkN "eficàcia" feminine ; --auto
lin efficient_A = mkA "eficaç" ; --auto
lin efflorescence_N = mkN "eflorescència" feminine ; --auto
lin effluent_N = mkN "efluent" masculine ; --auto
lin effort_N = mkN "esforç" masculine ;
lin egalitarian_A = mkA "igualitari" ; --auto
lin egalitarianism_N = mkN "igualitarisme" masculine ; --auto
lin egg_N = L.egg_N ;
lin egg_cup_N = mkN "ouera" feminine ; --auto
lin eggnog_N = mkN "ponx d'ou" masculine ; --auto
lin eggplant_N = mkN "albergínia" feminine ; --auto
lin egocentric_A = mkA "egocèntric" ; --auto
lin egoist_N = mkN "egoista" ; --auto
lin egoistic_A = mkA "egoista" ; --auto
lin egotism_N = mkN "egotisme" masculine ; --auto
lin egotist_N = mkN "egòlatra" feminine ; --auto
lin egotistic_A = mkA "egòlatra" ; --auto
lin egyptian_A = mkA "egipci" ; --auto
lin egyptian_N = mkN "egipci" | mkN "egipci" ; --auto
lin eider_N = mkN "èider" masculine ; --auto
lin eiderdown_N = mkN "edredó" masculine ; --auto
lin einsteinium_N = mkN "einsteini" masculine ; --auto
lin either_Adv = mkAdv "tampoc" ;
lin either_Det = mkDet "o" | mkDet "o bé" ;
lin ejaculate_V2 = mkV2 "ejacular" ; --auto
lin ejaculation_N = mkN "ejaculació" feminine ; --auto
lin ejector_N = mkN "expulsor" masculine ; --auto
lin elaborate_V = mkV "elaborar" ; --auto
lin elaborate_V2 = mkV2 "elaborar" ; --auto
lin elastance_N = mkN "elastància" feminine ; --auto
lin elastic_A = mkA "elàstic" ; --auto
lin elastic_N = mkN "elàstic" masculine ; --auto
lin elastin_N = mkN "elastina" feminine ; --auto
lin elastomer_N = mkN "elastòmer" masculine ; --auto
lin elbow_N = mkN "colze" masculine ; --auto
lin elder_A = mkA "gran" ; --auto
lin elder_1_N = mkN "major" ;
lin elder_2_N = mkN "saüc" masculine ;
lin elderly_A = mkA "ancià" ; --auto
lin elect_A = mkA "electe" ; --auto
lin elect_V = mkV "elegir" ; --auto
lin elect_V2 = mkV2 "elegir" ; --auto
lin election_N = mkN "tria" feminine | mkN "elecció" feminine ; --split "eleccions" (choose vs. political elections)
lin electoral_A = mkA "electoral" ; --auto
lin electorate_N = mkN "electorat" masculine ; --auto
lin electric_A = mkA "elèctric" ; --auto
lin electrical_A = mkA "elèctric" ; --auto
lin electricity_N = mkN "electricitat" feminine ; --auto
lin electrochemical_A = mkA "electroquímic" ; --auto
lin electrochemistry_N = mkN "electroquímica" feminine ; --auto
lin electrocution_N = mkN "electrocució" feminine ; --auto
lin electrode_N = mkN "elèctrode" masculine ; --auto
lin electrodynamometer_N = mkN "electrodinamòmetre" masculine ; --auto
lin electrolysis_N = mkN "electròlisi" feminine ; --auto
lin electrolyte_N = mkN "electròlit" masculine ; --auto
lin electrolytic_A = mkA "electrolític" ; --auto
lin electromagnet_N = mkN "electroimant" masculine ; --auto
lin electromagnetic_A = mkA "electromagnètic" ; --auto
lin electromagnetism_N = mkN "electromagnetisme" masculine ; --auto
lin electromechanical_A = mkA "electromecànic" ; --auto
lin electrometer_N = mkN "electròmetre" masculine ; --auto
lin electromotive_A = mkA "electromotor" ; --auto
lin electron_N = mkN "electró" masculine ; --auto
lin electronegativity_N = mkN "electronegativitat" feminine ; --auto
lin electronic_A = mkA "electrònic" ; --auto
lin electronics_N = mkN "electrònica" feminine ; --auto
lin electrophoresis_N = mkN "electroforesi" feminine ; --auto
lin electrophorus_N = mkN "electròfor" masculine ; --auto
lin electroscope_N = mkN "electroscopi" masculine ; --auto
lin electrostatic_A = mkA "electrostàtic" ; --auto
lin electrostatics_N = mkN "electrostàtica" feminine ; --auto
lin electrum_N = mkN "electre" masculine ; --auto
lin elegance_N = mkN "elegància" feminine ; --auto
lin elegant_A = mkA "elegant" ; --auto
lin elegy_N = mkN "elegia" feminine ; --auto
lin element_N = mkN "element" masculine ;
lin elemental_A = mkA "elemental" ; --auto
lin elementary_A = mkA "elemental" ; --auto
lin elephant_N = mkN "elefant" feminine | mkN "elefant" masculine ; --auto
lin elephantiasis_N = mkN "elefantiasi" feminine ; --auto
lin elevate_V2 = mkV2 "elevar" ; --auto
lin elevation_N = mkN "alçat" masculine ; --auto
lin elevator_N = mkN "ascensor" masculine ; --auto
lin eligibility_N = mkN "elegibilitat" feminine ; --auto
lin eligible_A = mkA "elegible" ; --auto
lin eliminate_V2 = mkV2 "eliminar" ; --auto
lin elimination_N = mkN "eliminació" feminine ; --auto
lin elite_N = mkN "elit" feminine ; --auto
lin elitism_N = mkN "elitisme" masculine ; --auto
lin elitistFem_N = variants {} ; ---- sense to be split
lin elitistMasc_N = variants {} ; ---- sense to be split
lin elixir_N = mkN "elixir" masculine ; --auto
lin elk_N = mkN "ant" masculine ; --auto
lin ell_N = mkN "alna" feminine ; --auto
lin ellipse_N = mkN "el·lipse" feminine ; --auto
lin ellipsoid_N = mkN "el·lipsoide" masculine ; --auto
lin elliptical_A = mkA "el·líptic" ; --auto
lin elm_N = mkN "om" masculine ; --auto
lin elocution_N = mkN "elocució" feminine ; --auto
lin elocutionistFem_N = variants {} ; ---- sense to be split
lin elocutionistMasc_N = variants {} ; ---- sense to be split
lin elongation_N = mkN "allargament" masculine ; --auto
lin else_Adv = mkAdv "més" ;
lin elsewhere_Adv = mkAdv "en qualsevol altre lloc" ; --auto
lin eluate_N = mkN "eluat" masculine ; --auto
lin elucidate_V2 = mkV2 "dilucidar" ; --auto
lin elution_N = mkN "elució" feminine ; --auto
lin elver_N = mkN "angula" feminine ; --auto
lin email_N = mkN "correu electrònic" masculine | mkN "email" masculine ; --auto
lin emanate_V = mkV "emanar" ; --auto
lin emanation_N = mkN "emanació" feminine ; --auto
lin emancipation_N = mkN "emancipació" feminine ; --auto
lin embalm_V2 = mkV2 "embalsamar" ; --auto
lin embargo_N = mkN "embargament" masculine ; --auto
lin embark_V = mkV "embarcar" ; --auto
lin embark_V2 = mkV2 "embarcar" ; --auto
lin embarrass_V2 = mkV2 "avergonyir" ; --auto
lin embarrassing_A = mkA "engavanyador" ; --auto
lin embarrassment_N = mkN "desconcert" masculine | mkN "vergonya" feminine ; --auto
lin embassy_N = mkN "ambaixada" feminine ; --auto
lin embellishment_N = mkN "adorn" masculine ; --auto
lin ember_N = mkN "caliu" masculine ; --auto
lin embezzle_V2 = mkV2 "malversar" ; --auto
lin embezzlement_N = mkN "desfalc" masculine ; --auto
lin emblem_N = mkN "emblema" masculine ; --auto
lin emblematic_A = mkA "emblemàtic" ; --auto
lin embody_V2 = mkV2 "encarnar" ; --auto
lin embolism_N = mkN "embòlia" feminine ; --auto
lin embrace_N = mkN "abraçada" feminine ; --auto
lin embrace_V = mkV "abraçar" ; --auto
lin embrace_V2 = mkV2 "abraçar" ; --auto
lin embrasure_N = mkN "tronera" feminine ; --auto
lin embroider_V = mkV "brodar" ; --auto
lin embroider_V2 = mkV2 "brodar" ; --auto
lin embroidery_N = mkN "brodat" masculine ; --auto
lin embryo_N = mkN "embrió" masculine ; --auto
lin embryologist_N = mkN "embriòleg" | mkN "embriòleg" ; --auto
lin embryology_N = mkN "embriologia" feminine ; --auto
lin embryonic_A = mkA "embrionari" ; --auto
lin emerald_N = mkN "maragda" feminine ; --auto
lin emerge_V = mkV (servir_101 "sorgir") ;
lin emergence_N = mkN "aparició" feminine ; --auto
lin emergency_N = mkN "emergència" feminine ; --auto
lin emergent_A = mkA "emergent" ; --auto
lin emery_N = mkN "esmeril" masculine ; --auto
lin emigrant_N = mkN "emigrant" ; --auto
lin emigrate_V = mkV "emigrar" ; --auto
lin emigration_N = mkN "emigració" feminine ; --auto
lin eminence_N = mkN "eminència" feminine ; --auto
lin eminent_A = mkA "eminent" ; --auto
lin emir_N = mkN "emir" masculine ; --auto
lin emirate_N = mkN "emirat" masculine ; --auto
lin emission_N = mkN "emissió" feminine ; --auto
lin emotion_N = mkN "emoció" feminine ; --auto
lin emotional_A = mkA "emocional" ; --auto
lin emotionality_N = mkN "emocionabilitat" feminine ; --auto
lin emotive_A = mkA "emotiu" ; --auto
lin empathic_A = mkA "empàtic" ; --auto
lin empathy_N = mkN "empatia" feminine ; --auto
lin emperor_N = mkN "emperador" masculine ; --auto
lin emphasis_N = mkN "èmfasi" feminine ; --auto
lin emphatic_A = mkA "emfàtic" ; --auto
lin emphysema_N = mkN "emfisema" masculine ; --auto
lin empire_N = mkN "imperi" masculine ; --auto
lin empirical_A = mkA "empíric" ; --auto
lin empiricism_N = mkN "empirisme" masculine ; --auto
lin employ_V2 = mkV2 (mkV "contractar") ;
lin employee_N = mkN "empleat" masculine ;
lin employer_N = mkN "cap" ;
lin employment_N = mkN "ocupació" feminine ;
lin empower_V2 = mkV2 "facultar" ; --auto
lin empress_N = mkN "emperador" feminine ; --auto
lin empty_A = L.empty_A ;
lin empyema_N = mkN "empiema" masculine ; --auto
lin emulate_V2 = mkV2 "emular" ; --auto
lin emulation_N = mkN "emulació" feminine ; --auto
lin emulator_N = mkN "emulador" masculine ; --auto
lin emulsifier_N = mkN "emulsor" masculine ; --auto
lin emulsify_V2 = mkV2 "emulsionar" ; --auto
lin emulsion_N = mkN "emulsió" feminine ; --auto
lin en_masse_Adv = mkAdv "en massa" ; --auto
lin enable_V2 = mkV2 (mkV "habilitar") ;
lin enable_V2V = mkV2V (mkV (admetre_2 "permetre")) ParadigmsCat.accusative ParadigmsCat.accusative ;
lin enable_VS = mkVS (mkV (admetre_2 "permetre")) ;
lin enamel_N = mkN "esmalt" masculine ; --auto
lin enantiomorphism_N = mkN "enantiomorfisme" masculine ; --auto
lin encapsulation_N = mkN "encapsulació" feminine ; --auto
lin enchant_V2 = mkV2 "encantar" ; --auto
lin enchantment_N = mkN "encantament" masculine ; --auto
lin encircle_V2 = mkV2 "cenyir" ; --auto
lin enclave_N = mkN "enclavament" masculine ; --auto
lin enclose_V2 = mkV2 "incloure" | mkV2 "tancar" ; --auto
lin enclosure_1_N = mkN "clos" masculine ; --auto
lin enclosure_2_N = mkN "clos" masculine ; --auto
lin enclosure_3_N = mkN "clos" masculine ; --auto
lin encode_V2 = mkV2 "codificar" ; --auto
lin encounter_N = mkN "encontre" masculine ; --auto
lin encounter_V2 = mkV2 "trobar" ; --auto
lin encourage_V2 = mkV2 (mkV "impular") ;
lin encourage_V2V = mkV2V (mkV "animar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin encouragement_N = mkN "encoratjament" masculine ; --auto
lin encrypt_V2 = mkV2 "encriptar" ; --auto
lin encryption_N = mkN "encriptació" feminine ; --auto
lin encyclopaedia_N = mkN "enciclopèdia" feminine ; --auto
lin encyclopaedic_A = mkA "enciclopèdic" ; --auto
lin end_1_N = mkN "final" masculine ; --split "final" feminine, "fi" feminine, "fi" masculine (for mor info cf. DIEC)
lin end_2_N = mkN "final" masculine ; --split "final" feminine, "fi" feminine, "fi" masculine (for mor info cf. DIEC)
lin end_V = mkV "acabar" ;
lin end_V2 = mkV2 (mkV "acabar") ;
lin end_in_V2 = prepV2 OP_end_V OP_in_Prep ; -- guess-p-verb
lin end_tail_V2 = variants {} ; -- guess-p-verb
lin end_up_V2 = prepV2 OP_end_V OP_up_Prep ; -- guess-p-verb
lin end_up_with_V2 = prepV2 (advV OP_end_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin endemic_A = mkA "endèmic" ; --auto
lin ending_N = mkN "finalització" feminine | mkN "final" feminine ; --auto
lin endive_N = mkN "endívia" feminine ; --auto
lin endless_A = mkA "inacabable" ; --auto
lin endocrine_A = mkA "endocrí" ; --auto
lin endocrinologist_N = mkN "endocrinòleg" feminine | mkN "endocrinòleg" masculine ; --auto
lin endocrinology_N = mkN "endocrinologia" feminine ; --auto
lin endoderm_N = mkN "endoderma" masculine ; --auto
lin endodontics_N = mkN "endodòncia" feminine ; --auto
lin endodontist_N = mkN "endodontista" ; --auto
lin endogamy_N = mkN "endogàmia" feminine ; --auto
lin endogenous_A = mkA "endogen" ; --auto
lin endometriosis_N = mkN "endometriosi" feminine ; --auto
lin endometrium_N = mkN "endometri" masculine ; --auto
lin endoplasm_N = mkN "endoplasma" masculine ; --auto
lin endorse_V2 = mkV2 "aprovar" | mkV2 "endossar" ; --auto
lin endorsement_N = mkN "endossament" masculine | mkN "suport" masculine ; --auto
lin endorser_N = mkN "endossant" ; --auto
lin endoscope_N = mkN "endoscopi" masculine ; --auto
lin endoscopy_N = mkN "endoscòpia" feminine ; --auto
lin endoskeleton_N = mkN "endosquelet" masculine ; --auto
lin endosperm_N = mkN "endosperma" masculine ; --auto
lin endothelium_N = mkN "endoteli" masculine ; --auto
lin endothermic_A = mkA "endotèrmic" ; --auto
lin endotoxin_N = mkN "endotoxina" feminine ; --auto
lin endow_V2 = mkV2 "dotar" ; --auto
lin endowment_N = mkN "dotació" feminine ; --auto
lin endways_Adv = mkAdv "de punta" ; --auto
lin endwise_Adv = mkAdv "de cantó" ; --auto
lin enema_N = mkN "ènema" masculine ; --auto
lin enemy_N = L.enemy_N ;
lin energetic_A = mkA "energètic" ; --auto
lin energy_N = mkN "energia" feminine ;
lin enervate_V2 = mkV2 "enervar" ; --auto
lin engage_V = mkV "comprometre" ; --auto
lin engage_V2 = mkV2 "comprometre" ; --auto
lin engagement_N = mkN "compromís" masculine ; --auto
lin engine_N = mkN "motor" masculine ;
lin engineer_N = mkN "enginyer" | mkN "enginyer" ; --auto
lin engineering_N = mkN "enginyeria" feminine ; --auto
lin englishFem_N = variants {} ;
lin englishMasc_N = variants {} ;
lin english_A = mkA "anglès" ;
lin engraver_N = mkN "gravador" feminine | mkN "gravador" masculine ; --auto
lin engraving_N = mkN "gravat" masculine ; --auto
lin enhance_V2 = mkV2 "realçar" ; --auto
lin enhancement_N = mkN "realçament" masculine | mkN "trucatge" masculine ; --auto
lin enigma_N = mkN "enigma" masculine ; --auto
lin enjoy_V2 = mkV2 (mkV (servir_101 "gaudir")) ParadigmsCat.genitive ;
lin enjoy_VV = mkVV (mkV (servir_101 "gaudir")) ;
lin enjoyment_N = mkN "diversió" feminine ; --auto
lin enlarge_V = mkV "ampliar" ; --auto
lin enlarge_V2 = mkV2 "ampliar" ; --auto
lin enlarger_N = mkN "ampliadora" feminine ; --auto
lin enlistment_N = mkN "allistament" masculine ; --auto
lin enmity_N = mkN "enemistat" feminine ; --auto
lin enormous_A = mkA "enorme" ; --auto
lin enquiry_N = mkN "consulta" feminine | mkN "investigació" feminine ; --auto
lin enrich_V2 = mkV2 "enriquir" ; --auto
lin enrichment_N = mkN "enriquiment" masculine ; --auto
lin enrol_V = mkV "matricular" ; --auto
lin enrol_V2 = mkV2 "matricular" ; --auto
lin ensure_V = mkV "assegurar" ;
lin ensure_V2 = mkV2 (mkV "assegurar") ;
lin ensure_VS = mkVS (mkV "assegurar") ;
lin entelechy_N = mkN "entelèquia" feminine ; --auto
lin entente_N = mkN "entesa" feminine ; --auto
lin enter_V = mkV "entrar" ;
lin enter_V2 = mkV2 (mkV "entrar") ParadigmsCat.dative ;
lin enter_for_V2 = prepV2 OP_enter_V OP_for_Prep ; -- guess-p-verb
lin enter_into_V2 = prepV2 OP_enter_V OP_into_Prep ; -- guess-p-verb
lin enterovirus_N = mkN "enterovirus" masculine | mkN "enterovirus" masculine ; --auto
lin enterprise_N = mkN "empresa" feminine ; --auto
lin entertain_V2 = mkV2 "entretenir" ; --auto
lin entertainer_N = mkN "artista" ; --auto
lin entertainment_N = mkN "diversió" feminine ; --auto
lin enthronement_N = mkN "entronització" feminine ; --auto
lin enthusiasm_N = mkN "entusiasme" masculine ; --auto
lin enthusiast_N = mkN "entusiasta" ; --auto
lin enthusiastic_A = mkA "entusiasta" ; --auto
lin entire_A = mkA "sencer" ; --auto
lin entity_N = mkN "entitat" feminine ; --auto
lin entomologist_N = mkN "entomòleg" feminine | mkN "entomòleg" masculine ; --auto
lin entomology_N = mkN "entomologia" feminine ; --auto
lin entrance_N = mkN "entrada" feminine ; --auto
lin entrapment_N = mkN "atrapament" masculine ; --auto
lin entropy_N = mkN "entropia" feminine ; --auto
lin entrust_V2 = mkV2 "confiar" ; --auto
lin entry_1_N = mkN "entrada" feminine ;
lin entry_2_N = mkN "entrada" feminine ;
lin enucleation_N = mkN "enucleació" feminine ; --auto
lin enumerate_V2 = mkV2 "enumerar" ; --auto
lin enumeration_N = mkN "enumeració" feminine ; --auto
lin enuresis_N = mkN "enuresi" feminine ; --auto
lin envelope_N = mkN "envolupant" feminine | mkN "sobre" masculine ; --auto
lin environment_N = mkN "entorn" masculine ;
lin environmental_A = mkA "mediambiental" ;
lin environmentalist_N = mkN "ecologista" ; --auto
lin envoy_N = mkN "enviat" | mkN "enviat" ; --auto
lin envy_N = mkN "enveja" feminine ; --auto
lin envy_V2 = mkV2 "envejar" ; --auto
lin enzymatic_A = mkA "enzimàtic" ; --auto
lin enzyme_N = mkN "enzim" masculine ; --auto
lin enzymology_N = mkN "enzimologia" feminine ; --auto
lin eosin_N = mkN "eosina" feminine ; --auto
lin eosinophilia_N = mkN "eosinofília" feminine ; --auto
lin epenthesis_N = mkN "epèntesi" feminine ; --auto
lin epenthetic_A = mkA "epentètic" ; --auto
lin ephemeral_A = mkA "efímer" ; --auto
lin ephemeris_N = mkN "efemèride" feminine ; --auto
lin epic_N = mkN "èpica" feminine ; --auto
lin epicanthus_N = mkN "epicant" masculine ; --auto
lin epicardium_N = mkN "epicardi" masculine ; --auto
lin epicarp_N = mkN "epicarpi" masculine ; --auto
lin epicentre_N = mkN "epicentre" masculine ; --auto
lin epicureanism_N = mkN "epicureisme" masculine ; --auto
lin epicycloid_N = mkN "epicicloide" feminine ; --auto
lin epidemic_N = mkN "epidèmia" feminine ; --auto
lin epidemiologist_N = mkN "epidemiòleg" feminine | mkN "epidemiòleg" masculine ; --auto
lin epidemiology_N = mkN "epidemiologia" feminine ; --auto
lin epididymis_N = mkN "epidídim" masculine ; --auto
lin epigastric_A = mkA "epigàstric" ; --auto
lin epigastrium_N = mkN "epigastri" masculine ; --auto
lin epigone_N = mkN "epígon" masculine ; --auto
lin epigram_N = mkN "epigrama" masculine ; --auto
lin epigraphy_N = mkN "epigrafia" feminine ; --auto
lin epilepsy_N = mkN "epilèpsia" feminine ; --auto
lin epilepticFem_N = variants {} ; ---- sense to be split
lin epilepticMasc_N = variants {} ; ---- sense to be split
lin epileptic_A = mkA "epilèptic" ; --auto
lin epilogue_N = mkN "epíleg" masculine ; --auto
lin epinephrine_N = mkN "epinefrina" feminine ; --auto
lin epiphysis_N = mkN "epífisi" feminine ; --auto
lin episcopalian_A = mkA "episcopal" ; --auto
lin episode_N = mkN "episodi" masculine ; --auto
lin epistemic_A = mkA "epistèmic" ; --auto
lin epistle_N = mkN "epístola" feminine ; --auto
lin epitaph_N = mkN "epitafi" masculine ; --auto
lin epithalamium_N = mkN "epitalami" masculine ; --auto
lin epithelium_N = mkN "epiteli" masculine ; --auto
lin epithet_N = mkN "epítet" masculine ; --auto
lin equal_A = mkA "igual" ; --auto
lin equal_N = mkN "igual" masculine ; --auto
lin equality_N = mkN "igualtat" feminine ; --auto
lin equalizer_N = mkN "equalitzador" masculine ; --auto
lin equanimity_N = mkN "equanimitat" feminine ; --auto
lin equate_V2 = mkV2 "equiparar" ; --auto
lin equation_N = mkN "equació" feminine ; --auto
lin equator_N = mkN "equador" masculine ; --auto
lin equatorial_A = mkA "equatorial" ; --auto
lin equidistant_A = mkA "equidistant" ; --auto
lin equilateral_A = mkA "equilàter" ; --auto
lin equilibrium_N = mkN "equilibri" masculine ; --auto
lin equinoctial_A = mkA "equinoccial" ; --auto
lin equinox_N = mkN "equinocci" masculine ; --auto
lin equip_V2 = mkV2 "equipar" ; --auto
lin equipment_N = mkN "equipament" masculine ;
lin equity_N = mkN "equitat" feminine ; --auto
lin equivalence_N = mkN "equivalència" feminine ; --auto
lin equivalent_A = mkA "equivalent" ; --auto
lin equivalent_N = mkN "equivalent" masculine ; --auto
lin equivocal_A = mkA "equívoc" ; --auto
lin era_N = mkN "era" feminine ; --auto
lin eradicate_V2 = mkV2 "eradicar" ; --auto
lin eradication_N = mkN "eradicació" feminine ; --auto
lin erase_V2 = mkV2 "esborrar" ; --auto
lin erbium_N = mkN "erbi" masculine ; --auto
lin erect_V2 = mkV2 "aixecar" ; --auto
lin erection_N = mkN "erecció" feminine ; --auto
lin ergodic_A = mkA "ergòdic" ; --auto
lin ergonomic_A = mkA "ergonòmic" ; --auto
lin ergonomics_N = mkN "ergonomia" feminine ; --auto
lin eristic_N = mkN "erística" feminine ; --auto
lin eritrean_A = mkA "eritreu" ; --auto
lin ermine_N = mkN "ermini" masculine ; --auto
lin erode_V = mkV "erosionar" ; --auto
lin erode_V2 = mkV2 "erosionar" ; --auto
lin erosion_N = mkN "erosió" feminine ; --auto
lin erroneous_A = mkA "erroni" ; --auto
lin error_N = mkN "error" masculine ; --auto
lin eructation_N = mkN "rot" masculine ; --auto
lin erudite_A = mkA "erudit" ; --auto
lin eruption_N = mkN "erupció" feminine ; --auto
lin erysipelas_N = mkN "erisipela" feminine ; --auto
lin erythroblast_N = mkN "eritroblast" masculine ; --auto
lin erythroblastosis_N = mkN "eritroblastosi" feminine ; --auto
lin erythropoiesis_N = mkN "eritropoesi" feminine ; --auto
lin escalope_N = mkN "escalopa" feminine ; --auto
lin escape_N = mkN "escapada" feminine ; --auto
lin escape_V = mkV "escapar" | mkV "fugir" ; --auto
lin escape_V2 = mkV2 "escapar" | mkV2 "fugir" ; --auto
lin escarpment_N = mkN "escarpament" masculine ; --auto
lin eschatology_N = mkN "escatologia" feminine ; --auto
lin escritoire_N = mkN "arquimesa" feminine ; --auto
lin escrow_N = mkN "plica" feminine ; --auto
lin esoteric_A = mkA "esotèric" ; --auto
lin espadrille_N = mkN "espardenya" feminine ; --auto
lin espionage_N = mkN "espionatge" masculine ; --auto
lin essay_N = mkN "assaig" masculine ; --auto
lin essayist_N = mkN "assagista" ; --auto
lin essence_N = mkN "essència" feminine ; --auto
lin essential_A = mkA "essencial" ;
lin establish_V2 = mkV2 (mkV (establir_53 "establir")) ;
lin establishment_N = mkN "establiment" masculine ; --auto
lin estate_N = mkN "patrimoni" masculine ;
lin esteem_N = mkN "estima" feminine ; --auto
lin ester_N = mkN "èster" masculine ; --auto
lin estimate_N = mkN "estimació" feminine | mkN "pressupost" masculine ; --auto
lin estimate_V = mkV "calcular" ; --auto
lin estimate_V2 = mkV2 "calcular" ; --auto
lin estimation_N = mkN "valoració" feminine ; --auto
lin estivation_N = mkN "estivació" feminine ; --auto
lin estrus_N = mkN "zel" masculine ; --auto
lin estuary_N = mkN "estuari" masculine ; --auto
lin etching_N = mkN "aiguafort" masculine ; --auto
lin eternal_A = mkA "etern" | mkA "eternal" ; --auto
lin eternity_N = mkN "eternitat" feminine ; --auto
lin ethanol_N = mkN "etanol" masculine ; --auto
lin ether_N = mkN "èter" masculine ; --auto
lin ethereal_A = mkA "eteri" ; --auto
lin ethical_A = mkA "ètic" ; --auto
lin ethiopian_A = mkA "etiòpic" ; --auto
lin ethnic_A = mkA "ètnic" ; --auto
lin ethnicity_N = mkN "etnicitat" feminine ; --auto
lin ethnocentrism_N = mkN "etnocentrisme" masculine ; --auto
lin ethnographer_N = mkN "etnògraf" | mkN "etnògraf" ; --auto
lin ethnographic_A = mkA "etnogràfic" ; --auto
lin ethnography_N = mkN "etnografia" feminine ; --auto
lin ethnological_A = mkA "etnològic" ; --auto
lin ethnologist_N = mkN "etnòleg" | mkN "etnòleg" ; --auto
lin ethnology_N = mkN "etnologia" feminine ; --auto
lin ethologist_N = mkN "etologista" ; --auto
lin ethology_N = mkN "etologia" feminine ; --auto
lin ethyl_N = mkN "etil" masculine ; --auto
lin etiology_N = mkN "etiologia" feminine ; --auto
lin etymological_A = mkA "etimològic" ; --auto
lin etymologist_N = mkN "etimòleg" feminine | mkN "etimòleg" masculine ; --auto
lin etymology_N = mkN "etimologia" feminine ; --auto
lin etymon_N = mkN "ètim" masculine ; --auto
lin eucalyptus_N = mkN "eucaliptus" masculine | mkN "eucaliptus" masculine ; --auto
lin euclidean_A = mkA "euclidià" ; --auto
lin eudiometer_N = mkN "eudiòmetre" masculine ; --auto
lin eugenics_N = mkN "eugenèsia" feminine ; --auto
lin eukaryotic_A = mkA "eucariota" ; --auto
lin eunuch_N = mkN "eunuc" masculine ; --auto
lin euphemism_N = mkN "eufemisme" masculine ; --auto
lin euphemistic_A = mkA "eufemístic" ; --auto
lin euphony_N = mkN "eufonia" feminine ; --auto
lin euphoria_N = mkN "eufòria" feminine ; --auto
lin euphoric_A = mkA "eufòric" ; --auto
lin euro_N = mkN "euro" masculine ;
lin eurodollar_N = mkN "eurodòlar" masculine ; --auto
lin european_A = mkA "europeu" ; --auto
lin europium_N = mkN "europi" masculine ; --auto
lin eutectic_N = mkN "eutèctic" masculine ; --auto
lin euthanasia_N = mkN "eutanàsia" feminine ; --auto
lin eutrophic_A = mkA "eutròfic" ; --auto
lin eutrophication_N = mkN "eutrofització" feminine ; --auto
lin evacuate_V2 = mkV2 "evacuar" ; --auto
lin evacuation_N = mkN "evacuació" feminine ; --auto
lin evade_V2 = mkV2 "eludir" ; --auto
lin evaluate_V = mkV "avaluar" ; --auto
lin evaluate_V2 = mkV2 "avaluar" ; --auto
lin evaluation_N = mkN "avaluació" feminine ; --auto
lin evaluator_N = mkN "avaluador" | mkN "avaluador" ; --auto
lin evangelist_N = mkN "evangelista" ; --auto
lin evaporate_V = mkV "evaporar" ; --auto
lin evaporate_V2 = mkV2 "evaporar" ; --auto
lin evaporation_N = mkN "evaporació" feminine ; --auto
lin even_AdA = mkAdv "àdhuc" | mkAdv "fins i tot" ; --auto
lin even_AdV = mkAdv "àdhuc" | mkAdv "fins i tot" ; --auto
lin even_Adv = mkAdv "àdhuc" | mkAdv "fins i tot" ; --auto
lin evening_N = mkN "vespre" masculine ;
lin event_N = mkN "acte" masculine ;
lin eventual_A = mkA "eventual" ; --auto
lin eventuality_N = mkN "eventualitat" feminine ; --auto
lin ever_AdV = mkAdv "mai" ; --auto
lin ever_Adv = mkAdv "mai" ;
lin evergreen_A = mkA "perennifoli" ; --auto
lin evermore_Adv = mkAdv "eternament" ; --auto
lin eversion_N = mkN "eversió" feminine ; --auto
lin every_Det = S.every_Det ;
lin everybody_NP = S.everybody_NP ;
lin everyday_A = mkA "diari" ; --auto
lin everyone_NP = S.everybody_NP ;
lin everything_NP = S.everything_NP ;
lin everywhere_Adv = S.everywhere_Adv ;
lin eviction_N = mkN "desnonament" masculine ; --auto
lin evidence_1_N = mkN "prova" feminine ;
lin evidence_2_N = mkN "prova" feminine ;
lin evident_A = mkA "evident" ; --auto
lin evidential_A = mkA "probatori" ; --auto
lin evil_N = mkN "mal" masculine ; --auto
lin evisceration_N = mkN "evisceració" feminine ; --auto
lin evocation_N = mkN "evocació" feminine ; --auto
lin evoke_V2 = mkV2 "evocar" ; --auto
lin evolution_N = mkN "evolució" feminine ; --auto
lin evolutionary_A = mkA "evolutiu" ; --auto
lin evolutionistFem_N = variants {} ; ---- sense to be split
lin evolutionistMasc_N = variants {} ; ---- sense to be split
lin evolve_V = mkV "evolucionar" ; --auto
lin evolve_V2 = mkV2 "evolucionar" ; --auto
lin exacerbate_V2 = mkV2 "exacerbar" ; --auto
lin exact_A = mkA "exacte" ; --auto
lin exaction_N = mkN "exacció" feminine ; --auto
lin exaggerate_V = mkV "exagerar" ; --auto
lin exaggerate_V2 = mkV2 "exagerar" ; --auto
lin exaggeration_N = mkN "exageració" feminine ; --auto
lin exaltation_N = mkN "exaltació" feminine ; --auto
lin exam_N = mkN "examen" masculine ; --auto
lin examination_N = mkN "examen" masculine | mkN "inspecció" feminine | mkN "interrogatori" masculine ; --auto
lin examine_V2 = mkV2 (mkV "examinar") ;
lin examiner_N = mkN "examinador" feminine | mkN "examinador" masculine ; --auto
lin example_N = mkN "exemple" masculine ;
lin exarch_N = mkN "exarca" feminine ; --auto
lin exasperate_V2 = mkV2 "desesperar" ; --auto
lin exasperation_N = mkN "exasperació" feminine ; --auto
lin excavate_V = mkV "excavar" ; --auto
lin excavate_V2 = mkV2 "excavar" ; --auto
lin excavation_N = mkN "excavació" feminine ; --auto
lin exceed_V2 = mkV2 "excedir" | mkV2 "sobrepassar" | mkV2 "superar" | mkV2 "ultrapassar" ; --auto
lin excellence_N = mkN "excel·lència" feminine ; --auto
lin excellent_A = mkA "excel·lent" ;
lin except_Conj = mkConj "excepte" ;
lin except_Prep = S.except_Prep ;
lin except_V2 = mkV2 "exceptuar" ; --auto
lin except_for_Prep = mkPrep "excepte" ; --auto
lin exception_N = mkN "excepció" feminine ; --auto
lin exceptional_A = mkA "excepcional" ; --auto
lin excess_A = mkA "sobrant" ; --auto
lin excess_N = mkN "excés" masculine ; --auto
lin excessive_A = mkA "excessiu" ; --auto
lin exchange_N = mkN "intercanvi" masculine ;
lin exchange_V2 = mkV2 "intercanviar" ; --auto
lin exchangeable_A = mkA "bescanviable" ; --auto
lin exchanger_N = mkN "bescanviador" masculine ; --auto
lin excitation_N = mkN "excitació" feminine ; --auto
lin excite_V2 = mkV2 "entusiasmar" ; --auto
lin excitement_N = mkN "emoció" feminine ; --auto
lin exciting_A = mkA "apassionant" ; --auto
lin exclaim_V2 = mkV2 "exclamar" ; --auto
lin exclamation_N = mkN "exclamació" feminine ; --auto
lin exclude_V2 = mkV2 "excloure" ; --auto
lin exclusion_N = mkN "exclusió" feminine ; --auto
lin exclusive_A = mkA "exclusiu" ; --auto
lin excrement_N = mkN "excrement" masculine ; --auto
lin excrescence_N = mkN "carnot" masculine ; --auto
lin excretion_N = mkN "excreció" feminine ; --auto
lin exculpatory_A = mkA "exculpatori" ; --auto
lin excursion_N = mkN "excursió" feminine ; --auto
lin excuse_N = mkN "excusa" feminine ; --auto
lin excuse_V2 = mkV2 "disculpar" ; --auto
lin excuse_me_Interj = mkInterj "perdona" ;
lin execute_V2 = mkV2 "executar" ; --auto
lin execution_N = mkN "execució" feminine ; --auto
lin executive_A = mkA "executiu" ; --auto
lin executive_N = mkN "executiu" ;
lin exegesis_N = mkN "exegesi" feminine ; --auto
lin exemplary_A = mkA "exemplar" ; --auto
lin exemplification_N = mkN "exemplificació" feminine ; --auto
lin exemplify_V2 = mkV2 "exemplificar" ; --auto
lin exemption_N = mkN "exempció" feminine ; --auto
lin exercise_N = mkN "exercici" masculine ;
lin exercise_V = mkV "exercitar" ; --auto
lin exercise_V2 = mkV2 "exercitar" ; --auto
lin exert_V2 = mkV2 "exercir" ; --auto
lin exfoliation_N = mkN "exfoliació" feminine ; --auto
lin exhalation_N = mkN "exhalació" feminine ; --auto
lin exhale_V = mkV "exhalar" ; --auto
lin exhale_V2 = mkV2 "exhalar" ; --auto
lin exhaust_V2 = mkV2 "esgotar" ; --auto
lin exhaustible_A = mkA "exhaurible" ; --auto
lin exhausting_A = mkA "esgotador" ; --auto
lin exhaustive_A = mkA "exhaustiu" ; --auto
lin exhibit_N = mkN "evidència" feminine | mkN "exposició" feminine | mkN "prova" feminine ; --auto
lin exhibit_V2 = mkV2 "exhibir" ; --auto
lin exhibition_N = mkN "exposició" feminine ;
lin exhibitionism_N = mkN "exhibicionisme" masculine ; --auto
lin exhibitor_N = mkN "expositor" feminine | mkN "expositor" masculine ; --auto
lin exhort_V2 = mkV2 "exhortar" ; --auto
lin exhumation_N = mkN "exhumació" feminine ; --auto
lin exhume_V2 = mkV2 "exhumar" ; --auto
lin exile_N = mkN "exili" masculine ; --auto
lin exile_V2 = mkV2 "exilar" ; --auto
lin exist_V = mkV (servir_101 "existir") ;
lin existence_N = mkN "existència" feminine ;
lin existent_A = mkA "existent" ; --auto
lin existential_A = mkA "existencial" ; --auto
lin existentialism_N = mkN "existencialisme" masculine ; --auto
lin existing_A = mkA "existent" ;
lin exit_N = mkN "sortida" feminine ; --auto
lin exocentric_A = mkA "exocèntric" ; --auto
lin exodontist_N = mkN "exodontista" ; --auto
lin exodus_N = mkN "èxode" masculine ; --auto
lin exogamy_N = mkN "exogàmia" feminine ; --auto
lin exoneration_N = mkN "exoneració" feminine ; --auto
lin exophthalmos_N = mkN "exoftàlmia" feminine ; --auto
lin exorcist_N = mkN "exorcista" ; --auto
lin exoskeleton_N = mkN "exosquelet" masculine ; --auto
lin exosphere_N = mkN "exosfera" feminine ; --auto
lin exostosis_N = mkN "exostosi" feminine ; --auto
lin exothermic_A = mkA "exotèrmic" ; --auto
lin exotic_A = mkA "exòtic" ; --auto
lin exotoxin_N = mkN "exotoxina" feminine ; --auto
lin expand_V = mkV "ampliar" | mkV "expandir" ; --auto
lin expand_V2 = mkV2 "ampliar" | mkV2 "expandir" ; --auto
lin expandable_A = mkA "expansible" ; --auto
lin expansion_N = mkN "expansió" feminine ; --auto
lin expansionism_N = mkN "expansionisme" masculine ; --auto
lin expansionist_A = mkA "expansionista" ; --auto
lin expect_V = mkV "esperar" ;
lin expect_V2 = mkV2 (mkV "esperar") ;
lin expect_V2V = mkV2V (mkV "esperar") ParadigmsCat.accusative ParadigmsCat.genitive ;
lin expect_VS = mkVS (mkV "esperar") ;
lin expect_VV = mkVV (mkV "esperar") ;
lin expectancy_N = mkN "expectació" feminine ; --auto
lin expectation_N = mkN "expectativa" feminine ; --auto
lin expectoration_N = mkN "expectoració" feminine ; --auto
lin expedition_N = mkN "expedició" feminine ; --auto
lin expel_V2 = mkV2 "expulsar" ; --auto
lin expendable_A = mkA "consumible" ; --auto
lin expenditure_N = mkN "despesa" feminine ; --auto
lin expense_N = mkN "despesa" feminine ; --auto
lin expensive_A = mkA "car" ; --auto
lin experience_N = mkN "experiència" feminine ;
lin experience_V2 = mkV2 (mkV "experimentar") ;
lin experiment_N = mkN "experiment" masculine ; --auto
lin experimental_A = mkA "experimental" ; --auto
lin experimentation_N = mkN "experimentació" feminine ; --auto
lin experimenterFem_N = variants {} ; ---- sense to be split
lin experimenterMasc_N = variants {} ; ---- sense to be split
lin expert_A = mkA "expert" ; --auto
lin expert_N = mkN "expert" | mkN "expert" | mkN "perit" masculine ; --auto
lin expertise_N = mkN "perícia" feminine ; --auto
lin expiation_N = mkN "expiació" feminine ; --auto
lin explain_V2 = mkV2 (mkV "explicar") ;
lin explain_VS = mkVS (mkV "explicar") ;
lin explain_away_V = advV (lin V OP_explain_V2) OP_away_Adv ; -- guess-p-verb
lin explainable_A = mkA "explicable" ; --auto
lin explanation_N = mkN "aclariment" masculine | mkN "explicació" feminine ; --auto
lin explanatory_A = mkA "explicatiu" ; --auto
lin explicit_A = mkA "explícit" ; --auto
lin explode_V = mkV "explotar" | mkV "fer explotar" | mkV "rebatre" ; --auto
lin exploit_N = mkN "proesa" feminine ; --auto
lin exploit_V2 = mkV2 "explotar" ; --auto
lin exploitation_N = mkN "explotació" feminine ; --auto
lin exploration_N = mkN "exploració" feminine ; --auto
lin exploratory_A = mkA "exploratori" ; --auto
lin explore_V2 = mkV2 "explorar" ; --auto
lin explorerFem_N = variants {} ; ---- sense to be split
lin explorerMasc_N = variants {} ; ---- sense to be split
lin explosion_N = mkN "explosió" feminine ; --auto
lin explosive_A = mkA "explosiu" ; --auto
lin explosive_N = mkN "explosiu" masculine ; --auto
lin expo_N = mkN "expo" feminine ; --auto
lin exponent_1_N = mkN "exponent" ; --auto
lin exponent_2_N = mkN "指数" ; -- status=guess
lin exponential_A = mkA "exponencial" ; --auto
lin export_N = mkN "exportació" feminine ; --auto
lin export_V = mkV "exportar" ; --auto
lin export_V2 = mkV2 "exportar" ; --auto
lin exporterFem_N = variants {} ; ---- sense to be split
lin exporterMasc_N = variants {} ; ---- sense to be split
lin expose_V = mkV "desemmascarar" | mkV "exposar" ; --auto
lin expose_V2 = mkV2 "desemmascarar" | mkV2 "exposar" ; --auto
lin exposure_N = mkN "exposició" feminine ; --auto
lin express_V2 = mkV2 (mkV "expressar") ;
lin expressible_A = mkA "expressable" ; --auto
lin expression_N = mkN "expressió" feminine ;
lin expressionism_N = mkN "expressionisme" masculine ; --auto
lin expressionistFem_N = variants {} ; ---- sense to be split
lin expressionistMasc_N = variants {} ; ---- sense to be split
lin expressive_A = mkA "expressiu" ; --auto
lin expropriation_N = mkN "expropiació" feminine ; --auto
lin expulsion_N = mkN "expulsió" feminine ; --auto
lin exquisite_A = mkA "exquisit" ; --auto
lin extend_V = reflV (mkV (atendre_8 "estendre")) ;
lin extend_V2 = mkV2 (reflV (mkV (atendre_8 "estendre"))) ;
lin extension_N = mkN "ampliació" feminine | mkN "extensió" feminine ; --auto
lin extensive_A = mkA "extens" ; --auto
lin extent_N = mkN "extensió" feminine ;
lin extenuating_A = mkA "atenuant" ; --auto
lin exterior_A = mkA "exterior" ; --auto
lin exterminate_V2 = mkV2 "exterminar" ; --auto
lin extermination_N = mkN "exterminació" feminine ; --auto
lin exterminator_N = mkN "exterminador" feminine | mkN "exterminador" masculine ; --auto
lin external_A = mkA "exterior" | mkA "extern" ; --auto
lin extinct_A = mkA "extint" ; --auto
lin extinction_N = mkN "extinció" feminine ; --auto
lin extinguish_V2 = mkV2 "extingir" ; --auto
lin extinguisher_N = mkN "extintor" masculine ; --auto
lin extirpation_N = mkN "extirpació" feminine ; --auto
lin extort_V = mkV "extorsionar" ; --auto
lin extort_V2 = mkV2 "extorsionar" ; --auto
lin extortion_N = mkN "extorsió" feminine ; --auto
lin extra_A = mkA "extra" ;
lin extra_N = mkN "extra" | mkN "figurant" ; --auto
lin extract_N = mkN "extracte" masculine ; --auto
lin extract_V2 = mkV2 "extreure" ; --auto
lin extraction_N = mkN "extracció" feminine ; --auto
lin extracurricular_A = mkA "extracurricular" ; --auto
lin extradition_N = mkN "extradició" feminine ; --auto
lin extrados_N = mkN "extradós" masculine ; --auto
lin extrajudicial_A = mkA "extrajudicial" ; --auto
lin extramarital_A = mkA "extramatrimonial" ; --auto
lin extramural_A = mkA "extrauniversitari" ; --auto
lin extraneous_A = mkA "aliè" ; --auto
lin extraordinary_A = mkA "extraordinari" ; --auto
lin extrapolate_V = mkV "extrapolar" ; --auto
lin extrapolate_V2 = mkV2 "extrapolar" ; --auto
lin extrapolation_N = mkN "extrapolació" feminine ; --auto
lin extraterrestrial_A = mkA "extraterrestre" ; --auto
lin extraterritorial_A = mkA "extraterritorial" ; --auto
lin extravagant_A = mkA "extravagant" ; --auto
lin extreme_A = mkA "extrem" ; --auto
lin extreme_N = mkN "extrem" masculine ; --auto
lin extremism_N = mkN "extremisme" masculine ; --auto
lin extremist_A = mkA "extremista" ; --auto
lin extremist_N = mkN "extremista" ; --auto
lin extremity_N = mkN "extremitat" feminine ; --auto
lin extrusion_N = mkN "extrusió" feminine ; --auto
lin exuberance_N = mkN "exuberància" feminine ; --auto
lin exudate_N = mkN "exsudat" masculine ; --auto
lin exudation_N = mkN "exsudació" feminine ; --auto
lin eye_N = L.eye_N ;
lin eyebrow_N = mkN "cella" feminine ; --auto
lin eyelash_N = mkN "pestanya" feminine ; --auto
lin eyelet_N = mkN "trau" masculine ; --auto
lin fabric_N = mkN "teixit" masculine ; --auto
lin fabulist_N = mkN "fabulista" ; --auto
lin face_N = mkN "cara" feminine ;
lin face_V = reflV (mkV "enfrontar") ; --subcat not possible, requires an object
lin face_V2 = mkV2 (reflV (mkV "enfrontar")) ParadigmsCat.dative ;
lin face_off_V2 = prepV2 OP_face_V OP_off_Prep ; -- guess-p-verb
lin face_up_to_V2 = prepV2 (advV OP_face_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin facet_N = mkN "faceta" feminine ; --auto
lin facial_A = mkA "facial" ; --auto
lin facile_A = mkA "simple" ; --auto
lin facilitate_V2 = mkV2 "facilitar" ; --auto
lin facilitation_N = mkN "facilitació" feminine ; --auto
lin facility_N = mkN "facilitat" feminine ;
lin facsimile_N = mkN "facsímil" masculine ; --auto
lin fact_N = mkN "fet" masculine ;
lin faction_N = mkN "facció" feminine ; --auto
lin factitious_A = mkA "factici" ; --auto
lin factor_N = mkN "factor" masculine ;
lin factorial_A = mkA "factorial" ; --auto
lin factory_N = L.factory_N ;
lin faculty_N = mkN "facultat" feminine ; --auto
lin fade_V = mkV "destenyir-se" | mkV "pansir-se" ; --auto
lin faecal_A = mkA "fecal" ; --auto
lin fail_V = mkV "fracassar" ;
lin fail_V2 = mkV2 (mkV (aprendre_6 "suspendre")) ;
lin fail_VV = mkVV (mkV (servir_101 "aconseguir")) ; --subcat requires "no va aconseguir ..."
lin failure_N = mkN "fracàs" masculine ;
lin fair_A = mkA "just" ;
lin fair_N = mkN "fira" feminine ; --auto
lin fairly_Adv = mkAdv "justament" ;
lin fairy_N = mkN "fada" feminine ; --auto
lin faith_N = mkN "fe" feminine ; --auto
lin faithful_A = mkA "fidel" ; --auto
lin faithless_A = mkA "descregut" ; --auto
lin fake_N = mkN "falsificació" feminine ; --auto
lin fake_V2 = mkV2 "falsificar" ; --auto
lin fakir_N = mkN "faquir" masculine ; --auto
lin falangist_N = mkN "falangista" ; --auto
lin falcon_N = mkN "falcó" masculine ; --auto
lin falconry_N = mkN "falconeria" feminine ; --auto
lin fall_1_N = variants {} ; ---- sense to be split
lin fall_2_N = variants {} ; ---- sense to be split
lin fall_V = verbV (caure_18 "caure") ;
lin fall_about_V = advV OP_fall_V OP_about_Adv ; -- guess-p-verb
lin fall_apart_V = advV OP_fall_V OP_apart_Adv ; -- guess-p-verb
lin fall_back_V = advV OP_fall_V OP_back_Adv ; -- guess-p-verb
lin fall_back_on_V2 = prepV2 (advV OP_fall_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin fall_behind_V = advV OP_fall_V OP_behind_Adv ; -- guess-p-verb
lin fall_behind_in_V2 = prepV2 (advV OP_fall_V OP_behind_Adv ) OP_in_Prep ; -- guess-p-verb
lin fall_down_V = advV OP_fall_V OP_down_Adv ; -- guess-p-verb
lin fall_for_V2 = prepV2 OP_fall_V OP_for_Prep ; -- guess-p-verb
lin fall_in_V = advV OP_fall_V OP_in_Adv ; -- guess-p-verb
lin fall_into_V2 = prepV2 OP_fall_V OP_into_Prep ; -- guess-p-verb
lin fall_off_V = advV OP_fall_V OP_off_Adv ; -- guess-p-verb
lin fall_out_V = advV OP_fall_V OP_out_Adv ; -- guess-p-verb
lin fall_out_with_V2 = prepV2 (advV OP_fall_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin fall_over_V = advV OP_fall_V OP_over_Adv ; -- guess-p-verb
lin fall_through_V = advV OP_fall_V OP_through_Adv ; -- guess-p-verb
lin fall_under_V2 = prepV2 OP_fall_V OP_under_Prep ; -- guess-p-verb
lin fallacious_A = mkA "fal·laç" ; --auto
lin fallacy_N = mkN "fal·làcia" feminine ; --auto
lin fallible_A = mkA "fal·lible" ; --auto
lin fallow_N = mkN "guaret" masculine ; --auto
lin false_A = mkA "fals" ; --auto
lin falsify_V2 = mkV2 "falsificar" ; --auto
lin falsity_N = mkN "falsedat" feminine ; --auto
lin fame_N = mkN "fama" feminine ; --auto
lin familiar_A = mkA "familiar" ; --auto
lin familiarity_N = mkN "familiaritat" feminine ; --auto
lin family_N = mkN "familia" feminine ;
lin famous_A = mkA "famós" ;
lin fan_1_N = variants {} ; ---- sense to be split
lin fan_2_N = variants {} ; ---- sense to be split
lin fan_3_N = variants {} ; ---- sense to be split
lin fan_V = mkV "ventar" ; --auto
lin fan_V2 = mkV2 "ventar" ; --auto
lin fanaticFem_N = variants {} ; ---- sense to be split
lin fanaticMasc_N = variants {} ; ---- sense to be split
lin fanatical_A = mkA "fanàtic" ; --auto
lin fanaticism_N = mkN "fanatisme" masculine ; --auto
lin fancy_A = mkA "elegant" ; --auto
lin fanfare_N = mkN "xaranga" feminine ; --auto
lin fang_N = mkN "ullal" masculine ; --auto
lin fantasize_V = mkV "fantasiar" ; --auto
lin fantastic_A = mkA "fantàstic" ; --auto
lin fantastically_Adv = mkAdv "fantàsticament" ; --auto
lin fantasy_N = mkN "fantasia" feminine ; --auto
lin far_A = mkA "lluny" ;
lin far_AdA = mkAdv "lluny" ; --auto
lin farad_N = mkN "farad" masculine ; --auto
lin farce_N = mkN "farsa" feminine ; --auto
lin fare_N = mkN "bitllet" masculine ; --auto
lin farm_N = mkN "granja" feminine ;
lin farm_V = mkV "cultivar" ; --auto
lin farm_V2 = mkV2 "cultivar" ; --auto
lin farmer_N = mkN "pagès" ;
lin farming_N = mkN "agricultura" feminine ; --auto
lin farmyard_N = mkN "corral" masculine ; --auto
lin fart_N = mkN "pet" masculine ; --auto
lin fascia_N = mkN "fàscia" feminine ; --auto
lin fascicle_N = mkN "quadern" masculine ; --auto
lin fasciculation_N = mkN "fasciculació" feminine ; --auto
lin fascination_N = mkN "fascinació" feminine ; --auto
lin fascism_N = mkN "feixisme" masculine ; --auto
lin fascist_A = mkA "feixista" ; --auto
lin fascist_N = mkN "feixista" ; --auto
lin fashion_N = mkN "manera" feminine | mkN "moda" feminine ; --auto
lin fashionable_A = mkA "de moda" ; --auto
lin fast_A = mkA "ràpid" ; --auto
lin fast_N = mkN "dejuni" masculine ; --auto
lin fat_A = mkA "gras" ; --auto
lin fat_N = L.fat_N ;
lin fatal_A = mkA "fatal" ; --auto
lin fatalism_N = mkN "fatalisme" masculine ; --auto
lin fatalistFem_N = variants {} ; ---- sense to be split
lin fatalistMasc_N = variants {} ; ---- sense to be split
lin fatalistic_A = mkA "fatalista" ; --auto
lin fate_N = mkN "destí" masculine ; --auto
lin fateful_A = mkA "fatídic" ; --auto
lin father_N = mkN "pare" masculine ;
lin fathomless_A = mkA "insondable" ; --auto
lin fatigue_N = mkN "fatiga" feminine ; --auto
lin fatten_V = mkV "engreixar" ; --auto
lin fatten_V2 = mkV2 "engreixar" ; --auto
lin fatty_A = mkA "gras" ; --auto
lin fault_N = mkN "culpa" feminine | mkN "falla" feminine | mkN "falta" feminine ; --auto
lin faun_N = mkN "faune" masculine ; --auto
lin fauna_N = mkN "fauna" feminine ; --auto
lin favorable_A = mkA "favorable" ; --auto
lin favour_N = mkN "favor" masculine ; --auto
lin favour_V = mkV "afavorir" ; --auto
lin favour_V2 = mkV2 "afavorir" ; --auto
lin favourable_A = mkA "favorable" | mkA "propici" ; --auto
lin favouriteFem_N = variants {} ; ---- sense to be split
lin favouriteMasc_N = variants {} ; ---- sense to be split
lin favourite_A = mkA "favorit" ; --auto
lin favouritism_N = mkN "favoritisme" masculine ; --auto
lin fawn_N = mkN "cervatell" masculine ; --auto
lin fear_N = mkN "por" feminine ;
lin fear_V = variants {} ; -- L.fear_V2 ;
lin fear_V2 = L.fear_V2 ;
lin fear_VS = L.fear_VS ;
lin fearful_A = mkA "temorós" ; --auto
lin fearless_A = mkA "agosarat" ; --auto
lin fearsome_A = mkA "temible" ; --auto
lin feasibility_N = mkN "viabilitat" feminine ; --auto
lin feasible_A = mkA "factible" ; --auto
lin feast_N = mkN "tiberi" masculine ; --auto
lin feather_N = L.feather_N ;
lin feature_N = mkN "característica" feminine ;
lin feature_V2 = mkV2 "constar" | mkV2 "presentar" ; --auto
lin fecundity_N = mkN "fecunditat" feminine ; --auto
lin federal_A = mkA "federal" ; --auto
lin federalism_N = mkN "federalisme" masculine ; --auto
lin federation_N = mkN "federació" feminine ; --auto
lin fee_N = mkN "cost" masculine ; --auto
lin feeble_A = mkA "feble" ; --auto
lin feed_V = mkV "alimentar" ; --auto
lin feed_V2 = mkV2 "alimentar" ; --auto
lin feed_off_V2 = prepV2 OP_feed_V OP_off_Prep ; -- guess-p-verb
lin feed_on_V2 = prepV2 OP_feed_V OP_on_Prep ; -- guess-p-verb
lin feed_up_V2 = prepV2 OP_feed_V OP_up_Prep ; -- guess-p-verb
lin feedback_N = mkN "retroalimentació" feminine ; --auto
lin feeder_N = mkN "alimentador" masculine ; --auto
lin feedstock_N = mkN "matèria primera" feminine ; --auto
lin feel_V = verbV (sentir_100 "sentir") ; --subcat
lin feel_V2 = mkV2 (verbV (sentir_100 "sentir")) ;
lin feel_VA = mkVA (verbV (sentir_100 "sentir")) ;
lin feel_VS = mkVS (verbV (sentir_100 "sentir")) ;
lin feel_out_V = advV OP_feel_V OP_out_Adv ; -- guess-p-verb
lin feel_up_V2 = prepV2 OP_feel_V OP_up_Prep ; -- guess-p-verb
lin feel_up_to_V2 = prepV2 (advV OP_feel_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin feeling_N = mkN "sentiment" masculine ;
lin feldspar_N = mkN "feldspat" masculine ; --auto
lin felicitous_A = mkA "adient" ; --auto
lin feline_A = mkA "felí" ; --auto
lin fellatio_N = mkN "felació" feminine ; --auto
lin fellow_A = mkA "amic" ; --auto
lin fellow_N = mkN "company" | mkN "membre" masculine ; --auto
lin fellowship_N = mkN "companyonia" feminine ; --auto
lin felon_N = mkN "panadís" masculine ; --auto
lin felt_N = mkN "feltre" masculine ; --auto
lin female_A = mkA "femella" ; --auto
lin female_N = mkN "dona" feminine | mkN "femella" feminine ; --auto
lin feminine_A = mkA "femení" ; --auto
lin femininity_N = mkN "feminitat" feminine ; --auto
lin feminism_N = mkN "feminisme" masculine ; --auto
lin feministFem_N = variants {} ; ---- sense to be split
lin feministMasc_N = variants {} ; ---- sense to be split
lin feminist_A = mkA "feminista" ; --auto
lin femur_N = mkN "fèmur" masculine ; --auto
lin fence_N = mkN "obstacle" masculine | mkN "tanca" feminine ; --auto
lin fencer_N = mkN "tirador" feminine | mkN "tirador" masculine ; --auto
lin fencing_N = mkN "esgrima" feminine ; --auto
lin fender_N = mkN "guardafoc" masculine ; --auto
lin fenestration_N = mkN "fenestració" feminine ; --auto
lin fennel_N = mkN "fenoll" masculine | mkN "fonoll" masculine ; --auto
lin ferment_V = mkV "fermentar" ; --auto
lin ferment_V2 = mkV2 "fermentar" ; --auto
lin fermentation_N = mkN "fermentació" feminine ; --auto
lin fermion_N = mkN "fermió" masculine ; --auto
lin fermium_N = mkN "fermi" masculine ; --auto
lin fern_N = mkN "falguera" feminine ; --auto
lin ferret_N = mkN "fura" feminine ; --auto
lin ferric_A = mkA "fèrric" ; --auto
lin ferrite_N = mkN "ferrita" feminine ; --auto
lin ferritin_N = mkN "ferritina" feminine ; --auto
lin ferromagnetic_A = mkA "ferromagnètic" ; --auto
lin ferromagnetism_N = mkN "ferromagnetisme" masculine ; --auto
lin ferrous_A = mkA "ferrós" ; --auto
lin ferry_N = mkN "transbordador" masculine ; --auto
lin fertile_A = mkA "fèrtil" ; --auto
lin fertility_N = mkN "fertilitat" feminine ; --auto
lin fertilizer_N = mkN "adob" masculine ; --auto
lin fervent_A = mkA "fervent" ; --auto
lin festival_N = mkN "festival" masculine ; --auto
lin festive_A = mkA "festiu" ; --auto
lin festivity_N = mkN "festivitat" feminine ; --auto
lin festoon_N = mkN "fistó" masculine ; --auto
lin fetal_A = mkA "fetal" ; --auto
lin fetid_A = mkA "fètid" ; --auto
lin fetishism_N = mkN "fetitxisme" masculine ; --auto
lin fetishist_N = mkN "fetitxista" ; --auto
lin fetoscopy_N = mkN "fetoscòpia" feminine ; --auto
lin fetter_N = mkN "trava" feminine ; --auto
lin feudal_A = mkA "feudal" ; --auto
lin feudalism_N = mkN "feudalisme" masculine ; --auto
lin feudatory_A = mkA "feudatari" ; --auto
lin fever_N = mkN "febre" feminine ; --auto
lin feverish_A = mkA "febril" ; --auto
lin few_Det = S.few_Det ;
lin fiasco_N = mkN "fiasco" masculine ; --auto
lin fiber_N = mkN "fibra" feminine ; --auto
lin fiberscope_N = mkN "fibroscopi" masculine ; --auto
lin fibre_N = mkN "fibra" feminine ; --auto
lin fibril_N = mkN "fibril·la" feminine ; --auto
lin fibrillation_N = mkN "fibril·lació" feminine ; --auto
lin fibrin_N = mkN "fibrina" feminine ; --auto
lin fibrinogen_N = mkN "fibrinogen" masculine ; --auto
lin fibrinolysis_N = mkN "fibrinòlisi" feminine ; --auto
lin fibroadenoma_N = mkN "fibroadenoma" masculine ; --auto
lin fibroblast_N = mkN "fibroblast" masculine ; --auto
lin fibroma_N = mkN "fibroma" masculine ; --auto
lin fibrosis_N = mkN "fibrosi" feminine ; --auto
lin fibrous_A = mkA "fibrós" ; --auto
lin fibula_N = mkN "peroné" masculine ; --auto
lin fiction_N = mkN "ficció" feminine ; --auto
lin fictitious_A = mkA "fictici" ; --auto
lin fidelity_N = mkN "fidelitat" feminine ; --auto
lin fiduciary_A = mkA "fiduciari" ; --auto
lin field_1_N = mkN "camp" masculine ;
lin field_2_N = mkN "camp" masculine ;
lin field_3_N = mkN "camp" masculine ;
lin field_4_N = mkN "camp" masculine ;
lin fierce_A = mkA "feroç" ; --auto
lin fig_N = mkN "figa" feminine ; --auto
lin fight_N = mkN "baralla" feminine | mkN "combat" masculine | mkN "lluita" feminine ; --auto
lin fight_V = mkV "lluitar" ;
lin fight_V2 = L.fight_V2 ;
lin fight_back_V = advV OP_fight_V OP_back_Adv ; -- guess-p-verb
lin fight_back_V2 = mkV2 (advV OP_fight_V OP_back_Adv ) ; -- guess-p-verb
lin fight_it_out_V2 = variants {} ; -- guess-p-verb
lin fight_off_V2 = prepV2 OP_fight_V OP_off_Prep ; -- guess-p-verb
lin fighter_N = mkN "lluitador" | mkN "lluitador" ; --auto
lin fighting_N = mkN "baralla" feminine ; --auto
lin figure_1_N = mkN "figura" feminine ; --split mkN "gràfic" masculine
lin figure_2_N = mkN "figura" feminine ; --split mkN "gràfic" masculine
lin figure_V = mkV "imaginar" | mkV "representar" ; --auto
lin figure_on_V2 = prepV2 OP_figure_V OP_on_Prep ; -- guess-p-verb
lin figure_out_V2 = prepV2 OP_figure_V OP_out_Prep ; -- guess-p-verb
lin figure_up_V2 = prepV2 OP_figure_V OP_up_Prep ; -- guess-p-verb
lin filament_N = mkN "filament" masculine ; --auto
lin file_N = mkN "arxiu" masculine ;
lin file_V = mkV "arxivar" ; --auto
lin file_V2 = mkV2 "arxivar" ; --auto
lin file_away_V2 = mkV2 (advV OP_file_V OP_away_Adv ) ; -- guess-p-verb
lin file_for_V2 = prepV2 OP_file_V OP_for_Prep ; -- guess-p-verb
lin filial_A = mkA "filial" ; --auto
lin filigree_N = mkN "filigrana" feminine ; --auto
lin filing_N = mkN "llimada" feminine ; --auto
lin fill_V = mkV "emplenar" ;
lin fill_V2 = mkV2 (mkV "emplenar") ;
lin fill_in_V = advV OP_fill_V OP_in_Adv ; -- guess-p-verb
lin fill_in_V2 = prepV2 OP_fill_V OP_in_Prep ; -- guess-p-verb
lin fill_in_for_V2 = prepV2 (advV OP_fill_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin fill_in_on_V3 = variants {} ; -- guess-p-verb
lin fill_out_V = advV OP_fill_V OP_out_Adv ; -- guess-p-verb
lin fill_out_V2 = prepV2 OP_fill_V OP_out_Prep ; -- guess-p-verb
lin fill_up_V2 = prepV2 OP_fill_V OP_up_Prep ; -- guess-p-verb
lin fillet_N = mkN "rellom" masculine ; --auto
lin filling_N = mkN "empastament" masculine ; --auto
lin film_1_N = mkN "pel·lícula" feminine ;
lin film_2_N = mkN "pel·lícula" feminine ;
lin film_V = mkV "filmar" ; --auto
lin film_V2 = mkV2 "filmar" ; --auto
lin filter_N = mkN "filtre" masculine ; --auto
lin filter_V = mkV "filtrar" ; --auto
lin filter_V2 = mkV2 "filtrar" ; --auto
lin fimbria_N = mkN "fímbria" feminine ; --auto
lin final_A = mkA "final" ;
lin final_N = mkN "final" feminine ; --auto
lin finalist_N = mkN "finalista" ; --auto
lin finally_Adv = mkAdv "finalment" ;
lin finance_N = mkN "finança" feminine ; --auto
lin finance_V2 = mkV2 "finançar" ; --auto
lin financial_A = mkA "financer" ;
lin financier_N = mkN "financer" masculine ; --auto
lin find_V = mkV "trobar" ;
lin find_V2 = L.find_V2 ;
lin find_V2A = mkV2A (mkV "trobar") ParadigmsCat.accusative ParadigmsCat.accusative ;
lin find_VS = mkVS (mkV "trobar") ;
lin find_out_V = advV OP_find_V OP_out_Adv ; -- guess-p-verb
lin find_out_V2 = prepV2 OP_find_V OP_out_Prep ; -- guess-p-verb
lin finder_N = mkN "visor" masculine ; --auto
lin finding_N = mkN "descobriment" masculine ; --auto
lin fine_A = mkA "fi" ; --split "bé" "bo" (thin vs. good)
lin fine_Adv = mkAdv "bé" ; --auto
lin fine_N = mkN "multa" feminine ; --auto
lin fine_V2 = mkV2 "multar" ; --auto
lin finger_N = mkN "dit" masculine ;
lin finish_N = mkN "acabat" masculine | mkN "arribada" feminine ; --auto
lin finish_V = mkV "acabar" ;
lin finish_V2 = mkV2 (mkV "acabar") ;
lin finish_off_V2 = prepV2 OP_finish_V OP_off_Prep ; -- guess-p-verb
lin finish_up_V = advV OP_finish_V OP_up_Adv ; -- guess-p-verb
lin finish_up_with_V2 = prepV2 (advV OP_finish_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin finish_with_V2 = prepV2 OP_finish_V OP_with_Prep ; -- guess-p-verb
lin finite_A = mkA "finit" ; --auto
lin finnishFem_N = variants {} ;
lin finnishMasc_N = variants {} ;
lin finnish_A = mkA "finlandès" ;
lin fiord_N = mkN "fiord" masculine ; --auto
lin fir_N = mkN "avet" masculine ; --auto
lin fire_1_N = L.fire_N ;
lin fire_2_N = L.fire_N ;
lin fire_V = mkV "acomiadar" | mkV "disparar" ; --auto
lin fire_V2 = mkV2 "acomiadar" | mkV2 "disparar" ; --auto
lin fire_away_V = advV OP_fire_V OP_away_Adv ; -- guess-p-verb
lin fire_back_V = advV OP_fire_V OP_back_Adv ; -- guess-p-verb
lin fire_off_V2 = prepV2 OP_fire_V OP_off_Prep ; -- guess-p-verb
lin fire_up_V = advV OP_fire_V OP_up_Adv ; -- guess-p-verb
lin fire_up_V2 = prepV2 OP_fire_V OP_up_Prep ; -- guess-p-verb
lin firearm_N = mkN "arma de foc" feminine ; --auto
lin fireman_N = mkN "bomber" masculine ; --auto
lin fireplace_N = mkN "llar de foc" feminine ; --auto
lin firewood_N = mkN "llenya" feminine ; --auto
lin firm_A = mkA "ferm" ; --auto
lin firm_N = mkN "empresa" feminine ;
lin firmament_N = mkN "fermament" masculine ; --auto
lin firmness_N = mkN "fermesa" feminine ; --auto
lin first_Adv = mkAdv "primer" ; --auto
lin firstly_Adv = mkAdv "en primer lloc" | mkAdv "primerament" ; --auto
lin fiscal_A = mkA "fiscal" ; --auto
lin fish_N = L.fish_N ;
lin fish_V = mkV "pescar" ; --auto
lin fish_V2 = mkV2 "pescar" ; --auto
lin fisherman_N = mkN "pescador" masculine ; --auto
lin fishing_N = mkN "pesca" feminine ; --auto
lin fishmonger_N = mkN "peixateria" feminine ; --auto
lin fishplate_N = mkN "eclissa" feminine ; --auto
lin fission_N = mkN "fissió" feminine ; --auto
lin fist_N = mkN "puny" masculine ; --auto
lin fistula_N = mkN "fístula" feminine ; --auto
lin fit_A = mkA "apte" ; --auto
lin fit_V = mkV (cabre_13 "cabre") ;
lin fit_V2 = mkV2 (mkV (cabre_13 "cabre")) ;
lin fit_in_V = advV OP_fit_V OP_in_Adv ; -- guess-p-verb
lin fit_in_V2 = prepV2 OP_fit_V OP_in_Prep ; -- guess-p-verb
lin fit_in_with_V2 = prepV2 (advV OP_fit_V OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin fit_into_V2 = prepV2 OP_fit_V OP_into_Prep ; -- guess-p-verb
lin fit_out_V2 = prepV2 OP_fit_V OP_out_Prep ; -- guess-p-verb
lin fit_out_with_V2 = prepV2 (advV OP_fit_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin fit_up_V2 = prepV2 OP_fit_V OP_up_Prep ; -- guess-p-verb
lin fitful_A = mkA "irregular" ; --auto
lin fitter_N = mkN "ajustador" | mkN "ajustador" ; --auto
lin fivefold_A = mkA "quíntuple" ; --auto
lin fix_V = mkV "arreglar" | mkV "fixar" ; --auto
lin fix_V2 = mkV2 "arreglar" | mkV2 "fixar" ; --auto
lin fix_up_V2 = prepV2 OP_fix_V OP_up_Prep ; -- guess-p-verb
lin fixation_N = mkN "fixació" feminine ; --auto
lin fixed_A = mkA "fix" ; --auto
lin flabbergast_V2 = mkV2 "estupefactar" ; --auto
lin flaccid_A = mkA "flàccid" ; --auto
lin flaccidity_N = mkN "flacciditat" feminine ; --auto
lin flag_N = mkN "bandera" feminine ; --auto
lin flagellum_N = mkN "flagel" masculine ; --auto
lin flagrant_A = mkA "flagrant" ; --auto
lin flail_N = mkN "batolla" feminine ; --auto
lin flake_N = mkN "escata" feminine ; --auto
lin flaky_A = mkA "escamós" ; --auto
lin flame_N = mkN "flama" feminine ; --auto
lin flammability_N = mkN "inflamabilitat" feminine ; --auto
lin flammable_A = mkA "inflamable" ; --auto
lin flange_N = mkN "vorell" masculine ; --auto
lin flank_N = mkN "flanc" masculine ; --auto
lin flannel_N = mkN "franel·la" feminine ; --auto
lin flap_N = mkN "solapa" feminine ; --auto
lin flare_N = mkN "bengala" feminine ; --auto
lin flash_N = mkN "flaix" masculine ; --auto
lin flash_V = mkV "centellejar" | mkV "llampegar" ; --auto
lin flat_A = mkA "pla" ; --auto
lin flat_N = mkN "pis" masculine ; --auto
lin flatter_V2 = mkV2 "afalagar" ; --auto
lin flatulence_N = mkN "flatulència" feminine ; --auto
lin flautist_N = mkN "flautista" ; --auto
lin flavonoid_N = mkN "flavonoide" masculine ; --auto
lin flavour_N = mkN "sabor" masculine ; --auto
lin flavour_V2 = mkV2 "assaonar" ; --auto
lin flawless_A = mkA "impecable" ; --auto
lin flea_N = mkN "puça" feminine ; --auto
lin flee_V = mkV "fugir" ; --auto
lin flee_V2 = mkV2 "fugir" ; --auto
lin fleet_N = mkN "flota" feminine ; --auto
lin fleeting_A = mkA "fugaç" ; --auto
lin flemish_A = mkA "flamenc" ; --auto
lin flesh_N = mkN "carn" feminine | mkN "polpa" feminine | mkN "polpa" feminine | mkN "polpa" feminine ; --auto
lin fleshy_A = mkA "carnós" ; --auto
lin flex_V2 = mkV2 "flectir" ; --auto
lin flexibility_N = mkN "flexibilitat" feminine ; --auto
lin flexible_A = mkA "flexible" ; --auto
lin flight_N = mkN "vol" masculine ; --auto
lin flint_N = mkN "sílex" masculine ; --auto
lin flip_N = mkN "ditada" feminine ; --auto
lin float_N = mkN "flotador" masculine ; --auto
lin float_V = L.float_V ;
lin flocculation_N = mkN "floculació" feminine ; --auto
lin flock_N = mkN "floca" feminine ; --auto
lin flood_N = mkN "crescuda" feminine | mkN "inundació" feminine ; --auto
lin flood_V = mkV "inundar" ; --auto
lin flood_V2 = mkV2 "inundar" ; --auto
lin floor_N = L.floor_N ;
lin floppy_A = mkA "flexible" ; --auto
lin flora_N = mkN "flora" feminine ; --auto
lin floral_A = mkA "floral" ; --auto
lin florence_1_PN = variants {} ; ---- sense to be split
lin florence_2_PN = variants {} ; ---- sense to be split
lin floriculture_N = mkN "floricultura" feminine ; --auto
lin florist_N = mkN "florista" ; --auto
lin floss_N = mkN "pelussa" feminine ; --auto
lin flotation_N = mkN "flotació" feminine ; --auto
lin flotilla_N = mkN "flotilla" feminine ; --auto
lin flour_N = mkN "farina" feminine ; --auto
lin flow_N = mkN "flux" masculine ; --auto
lin flow_V = L.flow_V ;
lin flower_N = L.flower_N ;
lin flower_V = mkV "florir" ; --auto
lin flowerpot_N = mkN "test" masculine ; --auto
lin flowery_A = mkA "florit" ; --auto
lin flu_N = mkN "grip" feminine ; --auto
lin fluctuate_V = mkV "fluctuar" ; --auto
lin fluctuation_N = mkN "fluctuació" feminine ; --auto
lin fluent_A = mkA "fluent" ; --auto
lin fluff_N = mkN "borrissol" masculine ; --auto
lin fluid_A = mkA "fluid" ; --auto
lin fluid_N = mkN "fluïd" masculine ; --auto
lin fluidity_N = mkN "fluïdesa" feminine ; --auto
lin fluorescein_N = mkN "fluoresceïna" feminine ; --auto
lin fluorescence_N = mkN "fluorescència" feminine ; --auto
lin fluorescent_A = mkA "fluorescent" ; --auto
lin fluoridation_N = mkN "fluoració" feminine ; --auto
lin fluoride_N = mkN "fluorur" masculine ; --auto
lin fluorine_N = mkN "fluor" masculine ; --auto
lin fluorite_N = mkN "fluorita" feminine ; --auto
lin fluorosis_N = mkN "fluorosi" feminine ; --auto
lin flute_N = mkN "flauta" feminine ; --auto
lin flutter_N = mkN "aleteig" masculine ; --auto
lin fluvial_A = mkA "fluvial" ; --auto
lin fly_N = mkN "mosca" feminine ; --auto
lin fly_V = L.fly_V ;
lin fly_V2 = mkV2 (mkV "volar") ;
lin fly_about_V = advV OP_fly_V OP_about_Adv ; -- guess-p-verb
lin fly_around_V = advV OP_fly_V OP_around_Adv ; -- guess-p-verb
lin fly_at_V2 = prepV2 OP_fly_V OP_at_Prep ; -- guess-p-verb
lin fly_by_V = advV OP_fly_V OP_by_Adv ; -- guess-p-verb
lin fly_fish_V = variants {} ; -- guess-p-verb
lin fly_into_V2 = prepV2 OP_fly_V OP_into_Prep ; -- guess-p-verb
lin fly_out_V = advV OP_fly_V OP_out_Adv ; -- guess-p-verb
lin flyer_N = mkN "aviador" feminine | mkN "aviador" masculine ; --auto
lin foal_N = mkN "poltre" masculine ; --auto
lin foam_N = mkN "escuma" feminine ; --auto
lin foam_V = mkV "escumejar" ; --auto
lin focal_A = mkA "focal" ; --auto
lin focus_N = mkN "focus" masculine | mkN "focus" masculine ; --auto
lin focus_V = mkV "centrar" | mkV "enfocar" ; --auto
lin focus_V2 = mkV2 "centrar" | mkV2 "enfocar" ; --auto
lin focus_on_V2 = prepV2 OP_focus_V OP_on_Prep ; -- guess-p-verb
lin foetus_N = mkN "fetus" masculine | mkN "fetus" masculine ; --auto
lin fog_N = L.fog_N ;
lin foil_N = mkN "floret" masculine ; --auto
lin fold_N = mkN "plec" masculine ; --auto
lin fold_V = mkV "plegar" ; --auto
lin fold_V2 = mkV2 "plegar" ; --auto
lin folder_N = mkN "carpeta" feminine ; --auto
lin foliage_N = mkN "fullatge" masculine ; --auto
lin foliation_N = mkN "foliació" feminine ; --auto
lin folio_N = mkN "foli" masculine ; --auto
lin folklore_N = mkN "folklore" masculine ; --auto
lin follicle_N = mkN "fol·licle" masculine ; --auto
lin follicular_A = mkA "fol·licular" ; --auto
lin follow_V = verbV (servir_101 "seguir") ;
lin follow_V2 = mkV2 (verbV (servir_101 "seguir")) ;
lin follow_VS = mkVS (reflV (mkV (servir_101 "seguir"))) ;
lin follow_on_V = advV OP_follow_V OP_on_Adv ; -- guess-p-verb
lin follow_on_from_V2 = prepV2 (advV OP_follow_V OP_on_Adv ) OP_from_Prep ; -- guess-p-verb
lin follow_through_V = advV OP_follow_V OP_through_Adv ; -- guess-p-verb
lin follow_up_V2 = prepV2 OP_follow_V OP_up_Prep ; -- guess-p-verb
lin follower_N = mkN "seguidor" masculine ; --auto
lin following_A = mkA "següent" ;
lin following_N = mkN "seguidor" masculine ; --auto
lin folly_N = mkN "follia" feminine ; --auto
lin fond_A = mkA "afectuós" ; --auto
lin fondue_N = mkN "fondue" feminine ; --auto
lin font_N = mkN "font" feminine ; --auto
lin fontanelle_N = mkN "fontanel·la" feminine ; --auto
lin food_N = mkN "menjar" masculine ;
lin fool_N = mkN "ximplet" | mkN "ximplet" ; --auto
lin foolish_A = mkA "ximple" ; --auto
lin foolishness_N = mkN "ximpleria" feminine ; --auto
lin foot_N = L.foot_N ;
lin football_N = mkN "pilota de futbol" feminine | mkN "futbol" masculine | mkN "pilota de futbol" feminine ; --auto
lin footballer_N = mkN "futbolista" ; --auto
lin footpath_N = mkN "viarany" masculine ; --auto
lin footprint_N = mkN "petjada" feminine ; --auto
lin footstool_N = mkN "escambell" masculine ; --auto
lin footwear_N = mkN "calçat" masculine ; --auto
lin for_Adv = variants {} ; -- S.for_Prep ;
lin for_PConj = ss "per a" ;
lin for_Prep = S.for_Prep ;
lin for_example_Adv = mkAdv "per exemple" ; --auto
lin for_sure_Adv = mkAdv "segur" ; --auto
lin forbid_V2 = mkV2 "prohibir" ; --auto
lin force_N = mkN "força" feminine ;
lin force_V = mkV "forçar" ;
lin force_V2 = mkV2 (mkV "forçar") ;
lin force_V2V = mkV2V (mkV "obligar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin force_VS = mkVS (mkV "forçar") ; --subcat
lin force_feed_V2 = variants {} ; -- guess-p-verb
lin force_land_V = variants {} ; -- guess-p-verb
lin force_land_V2 = variants {} ; -- guess-p-verb
lin force_majeure_N = mkN "força major" feminine ; --auto
lin force_out_V = advV OP_force_V OP_out_Adv ; -- guess-p-verb
lin forceful_A = mkA "enèrgic" ; --auto
lin forceps_N = mkN "fòrceps" masculine | mkN "fòrceps" masculine ; --auto
lin forearm_N = mkN "avantbraç" masculine ; --auto
lin forecast_N = mkN "previsió" feminine ; --auto
lin forehead_N = mkN "front" masculine ; --auto
lin foreign_1_A = mkA "estranger" ;
lin foreign_2_A = mkA "estranger" ;
lin foreigner_N = mkN "estranger" | mkN "estranger" ; --auto
lin foremost_A = mkA "primer" ; --auto
lin forensic_A = mkA "forense" ; --auto
lin foresee_V2 = mkV2 "preveure" ; --auto
lin forest_N = mkN "bosc" masculine ;
lin forester_N = mkN "guardabosc" masculine ; --auto
lin forever_Adv = mkAdv "per sempre" ; --auto
lin forge_V = mkV "forjar" ; --auto
lin forge_V2 = mkV2 "forjar" ; --auto
lin forget_V = mkV "oblidar" ;
lin forget_V2 = L.forget_V2 ;
lin forget_VS = mkVS (mkV "oblidar") ;
lin forgive_V = mkV "perdonar" ; --auto
lin forgive_V2 = mkV2 "perdonar" ; --auto
lin fork_1_N = variants {} ; ---- sense to be split
lin fork_3_N = variants {} ; ---- sense to be split
lin fork_4_N = variants {} ; ---- sense to be split
lin fork_V = mkV "bifurcar-se" | mkV "enforcar" ; --auto
lin form_N = mkN "formulari" masculine ;
lin form_V = mkV "formar" ;
lin form_V2 = mkV2 (mkV "formar") ;
lin formal_A = mkA "formal" ; --DVH 31/08/2014
lin formaldehyde_N = mkN "formaldehid" masculine ; --auto
lin formalism_N = mkN "formalisme" masculine ; --auto
lin format_N = mkN "format" masculine ; --auto
lin formation_N = mkN "formació" feminine ; --auto
lin formative_A = mkA "formatiu" ; --auto
lin former_A = mkA "anterior" ; --auto
lin formidable_A = mkA "formidable" ; --auto
lin formula_N = mkN "fórmula" feminine ; --auto
lin formulate_V2 = mkV2 "formular" ; --auto
lin formulation_N = mkN "formulació" feminine ; --auto
lin fort_N = mkN "fort" masculine ; --auto
lin forte_Adv = mkAdv "forte" ; --auto
lin forthcoming_A = mkA "pròxim" ; --auto
lin forthwith_Adv = mkAdv "de seguida" ; --auto
lin fortify_V2 = mkV2 "enfortir" ; --auto
lin fortissimo_Adv = mkAdv "fortissimo" ; --auto
lin fortnight_N = mkN "quinzena" feminine ; --auto
lin fortnightly_Adv = mkAdv "cada quinze dies" ; --auto
lin fortress_N = mkN "fortalesa" feminine ; --auto
lin fortunate_A = mkA "afortunat" ; --auto
lin fortunately_Adv = mkAdv "afortunadament" ; --auto
lin fortune_N = mkN "fortuna" feminine ; --auto
lin forum_N = mkN "fòrum" masculine ; --auto
lin forward_Adv = mkAdv "endavant" ;
lin forward_N = mkN "davanter" | mkN "davanter" ; --auto
lin forward_V2 = mkV2 "enviar" ; --auto
lin fossil_N = mkN "fòssil" masculine ; --auto
lin foster_A = mkA "adoptiu" ; --auto
lin found_V2 = mkV2 "fundar" ; --auto
lin foundation_N = mkN "fundació" feminine ; --auto
lin founder_N = mkN "fundador" feminine | mkN "fundador" masculine ; --auto
lin foundry_N = mkN "foneria" feminine ; --auto
lin fountain_N = mkN "font" feminine ; --auto
lin fovea_N = mkN "fòvea" feminine ; --auto
lin fowl_N = mkN "au" feminine ; --auto
lin fox_N = mkN "guineu" feminine | mkN "rabosa" feminine ; --auto
lin foxglove_N = mkN "didalera" feminine ; --auto
lin fraction_N = mkN "fracció" feminine | mkN "trencat" masculine ; --auto
lin fractional_A = mkA "fraccionari" ; --auto
lin fractionation_N = mkN "fraccionament" masculine ; --auto
lin fracture_N = mkN "fractura" feminine ; --auto
lin fragile_A = mkA "fràgil" ; --auto
lin fragment_N = mkN "fragment" masculine ; --auto
lin fragmentation_N = mkN "fragmentació" feminine ; --auto
lin fragrant_A = mkA "fragant" ; --auto
lin frame_N = mkN "bastidor" masculine | mkN "bastiment" masculine | mkN "carcassa" feminine | mkN "estructura" feminine | mkN "marc" masculine | mkN "xassís" masculine ; --auto
lin frame_V = mkV "emmarcar" ; --auto
lin frame_V2 = mkV2 "emmarcar" ; --auto
lin framework_N = mkN "marc" masculine ; --auto
lin franchise_N = mkN "franquícia" feminine ; --auto
lin franciscan_A = mkA "franciscà" ; --auto
lin frank_A = mkA "franc" ; --auto
lin franklin_N = mkN "franklin" masculine ; --auto
lin frankly_Adv = mkAdv "francament" ; --auto
lin frankness_N = mkN "franquesa" feminine ; --auto
lin frantic_A = mkA "frenètic" ; --auto
lin fraternal_A = mkA "fraternal" ; --auto
lin fratricide_N = mkN "fratricidi" masculine ; --auto
lin fraud_N = mkN "frau" masculine ; --auto
lin fraudulence_N = mkN "fraudulència" feminine ; --auto
lin fraudulent_A = mkA "fraudulent" ; --auto
lin free_1_A = mkA "lliure" ;
lin free_2_A = mkA "lliure" ;
lin free_V2 = mkV2 "alliberar" ; --auto
lin free_up_V2 = prepV2 (lin V OP_free_V2) OP_up_Prep ; -- guess-p-verb
lin freedom_N = mkN "llibertat" feminine ; --auto
lin freelance_N = mkN "autònom" | mkN "autònom" ; --auto
lin freemasonry_N = mkN "francmaçoneria" feminine ; --auto
lin freeze_N = mkN "congelació" feminine ; --auto
lin freeze_V = L.freeze_V ;
lin freeze_V2 = variants {} ; -- L.freeze_V ;
lin freezer_N = mkN "congelador" masculine ; --auto
lin freight_N = mkN "càrrega" feminine | mkN "noli" masculine ; --auto
lin frenchFem_N = variants {} ; ---- sense to be split
lin frenchMasc_N = variants {} ; ---- sense to be split
lin french_A = mkA "francès" ; --auto
lin frequency_N = mkN "freqüència" feminine ; --auto
lin frequent_A = mkA "freqüent" ; --auto
lin fresco_N = mkN "fresc" masculine ; --auto
lin fresh_A = mkA "fresc" ;
lin freshen_V = mkV "refrescar" ; --auto
lin freshen_V2 = mkV2 "refrescar" ; --auto
lin freshness_N = mkN "frescor" feminine ; --auto
lin freshwater_A = mkA "d'aigua dolça" ; --auto
lin freshwater_N = mkN "aigua dolça" feminine ; --auto
lin freudian_A = mkA "freudià" ; --auto
lin friability_N = mkN "friabilitat" feminine ; --auto
lin friable_A = mkA "friable" ; --auto
lin friar_N = mkN "frare" masculine ; --auto
lin fricassee_N = mkN "fricandó" masculine ; --auto
lin friction_N = mkN "fricció" feminine ; --auto
lin frictional_A = mkA "friccional" ; --auto
lin fridge_N = L.fridge_N ;
lin friend_N = L.friend_N ;
lin friendliness_N = mkN "amabilitat" feminine ; --auto
lin friendly_A = mkA "amistós" ; --auto
lin friendship_N = mkN "amistat" feminine ; --auto
lin frieze_N = mkN "fris" masculine ; --auto
lin frigate_N = mkN "fragata" feminine ; --auto
lin fright_N = mkN "esglai" masculine ; --auto
lin frighten_V2 = mkV2 "espantar" ; --auto
lin frighten_away_V2 = mkV2 (advV (lin V OP_frighten_V2) OP_away_Adv ) ; -- guess-p-verb
lin frighten_off_V2 = prepV2 (lin V OP_frighten_V2) OP_off_Prep ; -- guess-p-verb
lin frightful_A = mkA "espantós" ; --auto
lin frigidity_N = mkN "frigidesa" feminine ; --auto
lin fringe_N = mkN "serrell" masculine ; --auto
lin fringe_V2 = mkV2 "franjar" ; --auto
lin frivolous_A = mkA "frívol" ; --auto
lin frock_N = mkN "hàbit" masculine ; --auto
lin frog_N = mkN "granota" feminine ; --auto
lin from_Prep = S.from_Prep ;
lin front_A = mkA "devanter" ;
lin front_N = mkN "davant" masculine ;
lin frontal_A = mkA "frontal" ; --auto
lin frontier_N = mkN "frontera" feminine ; --auto
lin frontispiece_N = mkN "frontispici" masculine ; --auto
lin frost_N = mkN "gebrada" feminine ; --auto
lin frown_V = mkV "arrufar les celles" ; --auto
lin fruit_N = L.fruit_N ;
lin fruitful_A = mkA "fructífer" ; --auto
lin fruitless_A = mkA "infructuós" ; --auto
lin frustrate_V2 = mkV2 "frustrar" ; --auto
lin frustration_N = mkN "frustració" feminine ; --auto
lin fry_V = mkV "fregir" ; --auto
lin fry_V2 = mkV2 "fregir" ; --auto
lin fuck_V = mkV "fotre" ; --auto
lin fuck_V2 = mkV2 "fotre" ; --auto
lin fucking_A = mkA "maleït" ; --auto
lin fuel_N = mkN "carburant" masculine | mkN "combustible" masculine | mkN "fuel" masculine ; --auto
lin fugitive_A = mkA "fugitiu" ; --auto
lin fugitive_N = mkN "fugitiu" feminine | mkN "fugitiu" masculine ; --auto
lin fulcrum_N = mkN "fulcre" masculine ; --auto
lin fulfil_V2 = mkV2 "complir" ; --auto
lin fulfillment_N = mkN "compliment" masculine ; --auto
lin full_A = L.full_A ;
lin full_time_Adv = mkAdv "a jornada plena" ; --auto
lin fully_Adv = mkAdv "completament" ;
lin fulminate_N = mkN "fulminat" masculine ; --auto
lin fumigant_N = mkN "fumigant" masculine ; --auto
lin fumigation_N = mkN "fumigació" feminine ; --auto
lin fun_A = mkA "divertit" ; --auto
lin fun_N = mkN "diversió" feminine ; --auto
lin funambulistFem_N = variants {} ; ---- sense to be split
lin funambulistMasc_N = variants {} ; ---- sense to be split
lin function_N = mkN "funció" masculine ;
lin function_V = mkV "funcionar" ; --auto
lin functional_A = mkA "funcional" ; --auto
lin functionalism_N = mkN "funcionalisme" masculine ; --auto
lin functionalist_N = mkN "funcionalista" ; --auto
lin functionality_N = mkN "funcionalitat" feminine ; --auto
lin fund_N = mkN "fons" masculine ; --split (deposit) vs. "recursos" / "finançament" (company, monetary funds)
lin fund_V2 = mkV2 "finançar" ; --auto
lin fundamental_A = mkA "fonamental" ; --auto
lin fundamentalism_N = mkN "fonamentalisme" masculine ; --auto
lin fundamentalist_N = mkN "fonamentalista" ; --auto
lin funding_N = mkN "finançament" masculine ; --auto
lin funeral_N = mkN "funeral" masculine ; --auto
lin fungible_A = mkA "fungible" ; --auto
lin fungicide_N = mkN "fungicida" feminine ; --auto
lin fungus_N = mkN "fong" masculine ; --auto
lin funicular_N = mkN "funicular" masculine ; --auto
lin funiculus_N = mkN "funicle" masculine ; --auto
lin funnel_N = mkN "embut" masculine ; --auto
lin funny_A = mkA "graciós" ; --auto
lin fur_N = mkN "pell" feminine ; --auto
lin furan_N = mkN "furan" masculine ; --auto
lin furcation_N = mkN "furcació" feminine ; --auto
lin furious_A = mkA "furiós" ; --auto
lin furnish_V2 = mkV2 "moblar" ; --auto
lin furniture_N = mkN "mobiliari" masculine ; --auto
lin furrier_N = mkN "pellaire" masculine ; --auto
lin further_AdV = mkAdv "més enllà" ; --auto
lin further_Adv = mkAdv "més lluny" | mkAdv "més enllà" ;
lin furthermore_Adv = mkAdv "a més" ; --auto
lin fury_N = mkN "fúria" feminine ; --auto
lin fuse_N = mkN "fusible" masculine ; --auto
lin fuse_V = mkV "fusionar" ; --auto
lin fuse_V2 = mkV2 "fusionar" ; --auto
lin fuselage_N = mkN "buc" masculine ; --auto
lin fusible_A = mkA "fusible" ; --auto
lin fusion_N = mkN "fusió" feminine ; --auto
lin fuss_N = mkN "daltabaix" masculine ; --auto
lin futile_A = mkA "va" ; --auto
lin future_1_N = mkN "futur" masculine ;
lin future_3_N = mkN "futur" masculine ;
lin future_A = mkA "futur" ;
lin futurism_N = mkN "futurisme" masculine ; --auto
lin futuristFem_N = variants {} ; ---- sense to be split
lin futuristMasc_N = variants {} ; ---- sense to be split
lin futuristic_A = mkA "futurista" ; --auto
lin fuzzy_A = mkA "borrós" ; --auto
lin gadolinium_N = mkN "gadolini" masculine ; --auto
lin gaelic_A = mkA "gaèlic" ; --auto
lin gain_N = mkN "benefici" masculine | mkN "guany" masculine ; --auto
lin gain_V = mkV (obtenir_78 "obtenir") ;
lin gain_V2 = mkV2 (mkV (obtenir_78 "obtenir_78")) ;
lin gain_back_V = advV OP_gain_V OP_back_Adv ; -- guess-p-verb
lin gaiter_N = mkN "polaina" feminine ; --auto
lin galactic_A = mkA "galàctic" ; --auto
lin galaxy_N = mkN "galàxia" feminine ; --auto
lin gale_N = mkN "vendaval" masculine ; --auto
lin gall_N = mkN "fel" masculine ; --auto
lin gallery_N = mkN "galeria" feminine ; --auto
lin gallicism_N = mkN "gal·licisme" masculine ; --auto
lin gallium_N = mkN "gal·li" masculine ; --auto
lin gallon_N = mkN "galó" masculine ; --auto
lin gallop_N = mkN "galop" masculine ; --auto
lin gallop_V = mkV "galopar" ; --auto
lin gallop_V2 = mkV2 "galopar" ; --auto
lin galvanic_A = mkA "galvànic" ; --auto
lin galvanometer_N = mkN "galvanòmetre" masculine ; --auto
lin gamble_N = mkN "aposta" feminine ; --auto
lin gambling_N = mkN "joc" masculine ; --auto
lin game_1_N = mkN "joc" masculine ;
lin game_2_N = mkN "joc" masculine ;
lin game_3_N = mkN "joc" masculine ;
lin gamete_N = mkN "gàmeta" masculine ; --auto
lin gametocyte_N = mkN "gametòcit" masculine ; --auto
lin gametogenesis_N = mkN "gametogènesi" feminine ; --auto
lin gametophyte_N = mkN "gametòfit" masculine ; --auto
lin gamopetalous_A = mkA "gamopètal" ; --auto
lin gang_N = mkN "colla" feminine ; --auto
lin ganglion_N = mkN "gangli" masculine ; --auto
lin gangrene_N = mkN "gangrena" feminine ; --auto
lin gangster_N = mkN "gàngster" ; --auto
lin gangway_N = mkN "portaló" masculine ; --auto
lin gaoler_N = mkN "escarceller" feminine | mkN "escarceller" masculine ; --auto
lin gap_N = mkN "buit" masculine ; --auto
lin garage_N = mkN "garatge" masculine ; --auto
lin garden_N = L.garden_N ;
lin gardenerFem_N = variants {} ; ---- sense to be split
lin gardenerMasc_N = variants {} ; ---- sense to be split
lin gardening_N = mkN "jardineria" feminine ; --auto
lin gargle_N = mkN "gàrgara" feminine ; --auto
lin gargoyle_N = mkN "gàrgola" feminine ; --auto
lin garlic_N = mkN "all" masculine ; --auto
lin garnet_N = mkN "granat" masculine ; --auto
lin garnish_V2 = mkV2 "guarnir" ; --auto
lin garret_N = mkN "entresolat" masculine ; --auto
lin garrotte_N = mkN "garrot" masculine ; --auto
lin gas_N = mkN "gas" masculine ;
lin gas_mask_N = mkN "màscara antigas" feminine ; --auto
lin gas_station_N = mkN "gasolinera" feminine ; --auto
lin gaseous_A = mkA "gasós" ; --auto
lin gasification_N = mkN "gasificació" feminine ; --auto
lin gasify_V = mkV "gasificar" ; --auto
lin gasify_V2 = mkV2 "gasificar" ; --auto
lin gasoline_N = mkN "gasolina" feminine ; --auto
lin gassing_N = mkN "gasejat" masculine ; --auto
lin gastric_A = mkA "gàstric" ; --auto
lin gastroenterologistFem_N = variants {} ; ---- sense to be split
lin gastroenterologistMasc_N = variants {} ; ---- sense to be split
lin gastroscopy_N = mkN "gastroscòpia" feminine ; --auto
lin gastrula_N = mkN "gàstrula" feminine ; --auto
lin gastrulation_N = mkN "gastrulació" feminine ; --auto
lin gate_N = mkN "comporta" feminine | mkN "porta" feminine ; --auto
lin gateway_N = mkN "porta" feminine ; --auto
lin gather_V = mkV "reunir" ; --auto
lin gather_V2 = mkV2 "reunir" ; --auto
lin gauge_N = mkN "gauge" masculine ; --auto
lin gauss_N = mkN "gauss" masculine | mkN "gauss" masculine ; --auto
lin gay_N = mkN "gai" masculine ; --auto
lin gaze_V = mkV "mirar fixament" ; --auto
lin gazelle_N = mkN "gasela" feminine ; --auto
lin gazette_N = mkN "gaseta" feminine ; --auto
lin gear_N = mkN "engranatge" masculine | mkN "equip" masculine | mkN "marxa" feminine ; --auto
lin gearing_N = mkN "dentatge" masculine ; --auto
lin gelatinous_A = mkA "gelatinós" ; --auto
lin gemination_N = mkN "geminació" feminine ; --auto
lin gender_1_N = mkN "gènere" masculine ; --auto
lin gender_2_N = mkN "gènere" masculine ; --auto
lin gene_N = mkN "gen" masculine ; --auto
lin genealogical_A = mkA "genealògic" ; --auto
lin genealogist_N = mkN "genealogista" ; --auto
lin genealogy_N = mkN "genealogia" feminine ; --auto
lin general_A = mkA "general" ;
lin general_N = mkN "general" ;
lin generality_N = mkN "generalitat" feminine ; --auto
lin generally_Adv = mkAdv "normalment" ;
lin generate_V2 = mkV2 "generar" ; --auto
lin generation_N = mkN "generació" feminine ;
lin generator_N = mkN "generador" masculine ; --auto
lin generic_A = mkA "genèric" ; --auto
lin generosity_N = mkN "generositat" feminine ; --auto
lin generous_A = mkA "generós" ; --auto
lin genesis_N = mkN "gènesi" feminine ; --auto
lin genetic_A = mkA "genètic" ; --auto
lin genetics_N = mkN "genètica" feminine ; --auto
lin genial_A = mkA "afable" ; --auto
lin genic_A = mkA "gènic" ; --auto
lin genital_A = mkA "genital" ; --auto
lin genitalia_N = mkN "genitals" masculine ; --auto
lin genitive_N = mkN "genitiu" masculine ; --auto
lin genitor_N = mkN "genitor" masculine ; --auto
lin genius_N = mkN "geni" masculine ; --auto
lin genocide_N = mkN "genocidi" masculine ; --auto
lin genome_N = mkN "genoma" masculine ; --auto
lin genomics_N = mkN "genòmica" feminine ; --auto
lin genotype_N = mkN "genotip" masculine ; --auto
lin genre_N = mkN "gènere" masculine ; --auto
lin gentian_N = mkN "genciana" feminine ; --auto
lin gentile_A = mkA "gentil" ; --auto
lin gentle_A = mkA "suau" ; --auto
lin gentleman_N = mkN "senyor" masculine ; --auto
lin genuine_A = mkA "genuí" ; --auto
lin geocentric_A = mkA "geocèntric" ; --auto
lin geochemistry_N = mkN "geoquímica" feminine ; --auto
lin geodesy_N = mkN "geodèsia" feminine ; --auto
lin geographer_N = mkN "geògraf" | mkN "geògraf" ; --auto
lin geographic_A = mkA "geogràfic" ; --auto
lin geography_N = mkN "geografia" feminine ; --auto
lin geological_A = mkA "geològic" ; --auto
lin geologistFem_N = variants {} ; ---- sense to be split
lin geologistMasc_N = variants {} ; ---- sense to be split
lin geology_N = mkN "geologia" feminine ; --auto
lin geometer_N = mkN "geòmetra" ; --auto
lin geometric_A = mkA "geomètric" ; --auto
lin geometrical_A = mkA "geomètric" ; --auto
lin geometry_N = mkN "geometria" feminine ; --auto
lin geophysics_N = mkN "geofísica" feminine ; --auto
lin geophyte_N = mkN "geòfit" masculine ; --auto
lin geopolitical_A = mkA "geopolític" ; --auto
lin geostrategy_N = mkN "geoestratègia" feminine ; --auto
lin geothermal_A = mkA "geotèrmic" ; --auto
lin geranium_N = mkN "gerani" masculine ; --auto
lin geriatrics_N = mkN "geriatria" feminine ; --auto
lin germ_N = mkN "germen" masculine ; --auto
lin germanFem_N = variants {} ;
lin germanMasc_N = variants {} ;
lin german_A = mkA "alemany" ;
lin germanic_A = mkA "germànic" ; --auto
lin germanium_N = mkN "germani" masculine ; --auto
lin germinal_A = mkA "germinal" ; --auto
lin germinate_V = mkV "germinar" ; --auto
lin germinate_V2 = mkV2 "germinar" ; --auto
lin germination_N = mkN "germinació" feminine ; --auto
lin gerontology_N = mkN "gerontologia" feminine ; --auto
lin gerund_N = mkN "gerundi" masculine ; --auto
lin gestation_N = mkN "gestació" feminine ; --auto
lin gesticulation_N = mkN "gesticulació" feminine ; --auto
lin gesture_N = mkN "gest" masculine ; --auto
lin get_V2 = mkV2 (mkV (tenir_108 "obtenir")) ;
lin get_V2V = mkV2V (verbV (servir_101 "aconseguir")) ParadigmsCat.accusative ParadigmsCat.dative ; --subcat mkVS (verbV (servir_101 "aconseguir"))
lin get_VV = deVV IrregCat.haver_V ;
lin get_about_V = advV (lin V OP_get_V2) OP_about_Adv ; -- guess-p-verb
lin get_above_V2 = prepV2 (lin V OP_get_V2) OP_above_Prep ; -- guess-p-verb
lin get_across_V = advV (lin V OP_get_V2) OP_across_Adv ; -- guess-p-verb
lin get_across_V2 = prepV2 (lin V OP_get_V2) OP_across_Prep ; -- guess-p-verb
lin get_across_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_across_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_after_V2 = prepV2 (lin V OP_get_V2) OP_after_Prep ; -- guess-p-verb
lin get_ahead_V = advV (lin V OP_get_V2) OP_ahead_Adv ; -- guess-p-verb
lin get_ahead_of_V2 = prepV2 (advV (lin V OP_get_V2) OP_ahead_Adv ) OP_of_Prep ; -- guess-p-verb
lin get_along_V = advV (lin V OP_get_V2) OP_along_Adv ; -- guess-p-verb
lin get_along_in_V2 = prepV2 (advV (lin V OP_get_V2) OP_along_Adv ) OP_in_Prep ; -- guess-p-verb
lin get_along_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_around_V = advV (lin V OP_get_V2) OP_around_Adv ; -- guess-p-verb
lin get_around_V2 = prepV2 (lin V OP_get_V2) OP_around_Prep ; -- guess-p-verb
lin get_around_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_around_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_at_V2 = prepV2 (lin V OP_get_V2) OP_at_Prep ; -- guess-p-verb
lin get_away_V = advV (lin V OP_get_V2) OP_away_Adv ; -- guess-p-verb
lin get_away_from_V2 = prepV2 (advV (lin V OP_get_V2) OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin get_away_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_away_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_back_V = advV (lin V OP_get_V2) OP_back_Adv ; -- guess-p-verb
lin get_back_V2 = mkV2 (advV (lin V OP_get_V2) OP_back_Adv ) ; -- guess-p-verb
lin get_back_at_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_at_Prep ; -- guess-p-verb
lin get_back_into_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_into_Prep ; -- guess-p-verb
lin get_back_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_back_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_back_together_V = variants {} ; -- guess-p-verb
lin get_behind_V2 = prepV2 (lin V OP_get_V2) OP_behind_Prep ; -- guess-p-verb
lin get_behind_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_behind_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_by_V = advV (lin V OP_get_V2) OP_by_Adv ; -- guess-p-verb
lin get_by_V2 = prepV2 (lin V OP_get_V2) OP_by_Prep ; -- guess-p-verb
lin get_by_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_by_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_by_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_by_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_down_V = advV (lin V OP_get_V2) OP_down_Adv ; -- guess-p-verb
lin get_down_V2 = prepV2 (lin V OP_get_V2) OP_down_Prep ; -- guess-p-verb
lin get_down_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_down_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_down_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_even_V = advV (lin V OP_get_V2) OP_even_Adv ; -- guess-p-verb
lin get_in_V = advV (lin V OP_get_V2) OP_in_Adv ; -- guess-p-verb
lin get_in_V2 = prepV2 (lin V OP_get_V2) OP_in_Prep ; -- guess-p-verb
lin get_in_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_in_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_into_V2 = prepV2 (lin V OP_get_V2) OP_into_Prep ; -- guess-p-verb
lin get_it_V = variants {} ; -- guess-p-verb
lin get_it_off_V = variants {} ; -- guess-p-verb
lin get_it_off_with_V2 = variants {} ; -- guess-p-verb
lin get_it_on_V = variants {} ; -- guess-p-verb
lin get_it_on_with_V2 = variants {} ; -- guess-p-verb
lin get_it_together_V = variants {} ; -- guess-p-verb
lin get_it_up_V = variants {} ; -- guess-p-verb
lin get_off_V = advV (lin V OP_get_V2) OP_off_Adv ; -- guess-p-verb
lin get_off_V2 = prepV2 (lin V OP_get_V2) OP_off_Prep ; -- guess-p-verb
lin get_off_it_V2 = variants {} ; -- guess-p-verb
lin get_off_on_V2 = prepV2 (advV (lin V OP_get_V2) OP_off_Adv ) OP_on_Prep ; -- guess-p-verb
lin get_off_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_on_1_V2 = variants {} ; -- guess-p-verb
lin get_on_2_V2 = variants {} ; -- guess-p-verb
lin get_on_V = advV (lin V OP_get_V2) OP_on_Adv ; -- guess-p-verb
lin get_on_at_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_at_Prep ; -- guess-p-verb
lin get_on_for_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_for_Prep ; -- guess-p-verb
lin get_on_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_on_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_onto_V2 = prepV2 (lin V OP_get_V2) OP_onto_Prep ; -- guess-p-verb
lin get_out_V = advV (lin V OP_get_V2) OP_out_Adv ; -- guess-p-verb
lin get_out_V2 = prepV2 (lin V OP_get_V2) OP_out_Prep ; -- guess-p-verb
lin get_out_of_V2 = prepV2 (advV (lin V OP_get_V2) OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin get_over_V = advV (lin V OP_get_V2) OP_over_Adv ; -- guess-p-verb
lin get_over_V2 = prepV2 (lin V OP_get_V2) OP_over_Prep ; -- guess-p-verb
lin get_over_with_V2 = prepV2 (advV (lin V OP_get_V2) OP_over_Adv ) OP_with_Prep ; -- guess-p-verb
lin get_round_V = advV (lin V OP_get_V2) OP_round_Adv ; -- guess-p-verb
lin get_round_V2 = prepV2 (lin V OP_get_V2) OP_round_Prep ; -- guess-p-verb
lin get_round_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_round_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_through_V = advV (lin V OP_get_V2) OP_through_Adv ; -- guess-p-verb
lin get_through_V2 = prepV2 (lin V OP_get_V2) OP_through_Prep ; -- guess-p-verb
lin get_through_V3 = variants {} ; -- guess-p-verb
lin get_through_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_through_Adv ) OP_to_Prep ; -- guess-p-verb
lin get_to_V2 = prepV2 (lin V OP_get_V2) OP_to_Prep ; -- guess-p-verb
lin get_together_V = advV (lin V OP_get_V2) OP_together_Adv ; -- guess-p-verb
lin get_up_V = advV (lin V OP_get_V2) OP_up_Adv ; -- guess-p-verb
lin get_up_V2 = prepV2 (lin V OP_get_V2) OP_up_Prep ; -- guess-p-verb
lin get_up_to_V2 = prepV2 (advV (lin V OP_get_V2) OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin geyser_N = mkN "guèiser" masculine ; --auto
lin ghost_N = mkN "fantasma" ; --auto
lin giant_A = mkA "gegant" ; --auto
lin giant_N = mkN "gegant" | mkN "gegant" ; --auto
lin gibraltarian_A = mkA "gibraltareny" ; --auto
lin gibraltarian_N = mkN "gibraltareny" | mkN "gibraltareny" ; --auto
lin giddiness_N = mkN "frivolitat" feminine ; --auto
lin gift_N = mkN "do" masculine | mkN "regal" masculine ; --auto
lin gifted_A = mkA "dotat" ; --auto
lin gig_N = mkN "actuació" feminine ; --auto
lin gigantic_A = mkA "gegantí" ; --auto
lin gigantism_N = mkN "gigantisme" masculine ; --auto
lin giggle_N = mkN "rialleta" feminine ; --auto
lin gilbert_N = mkN "gilbert" masculine ; --auto
lin gild_V2 = mkV2 "daurar" ; --auto
lin gilder_N = mkN "daurador" feminine | mkN "daurador" masculine ; --auto
lin gilding_N = mkN "dauradura" feminine ; --auto
lin gilt_N = mkN "daurat" masculine ; --auto
lin ginger_N = mkN "gingebre" masculine ; --auto
lin gingival_A = mkA "gingival" ; --auto
lin gipsyFem_N = variants {} ; ---- sense to be split
lin gipsyMasc_N = variants {} ; ---- sense to be split
lin giraffe_N = mkN "girafa" feminine ; --auto
lin girl_N = L.girl_N ;
lin girlfriend_N = mkN "xicot" feminine ; --auto
lin give_V = verbV (donar_43 "donar") ;
lin give_V2 = mkV2 (verbV (donar_43 "donar")) ;
lin give_V3 = L.give_V3 ;
lin give_away_V = advV OP_give_V OP_away_Adv ; -- guess-p-verb
lin give_away_V2 = mkV2 (advV OP_give_V OP_away_Adv ) ; -- guess-p-verb
lin give_back_V2 = mkV2 (advV OP_give_V OP_back_Adv ) ; -- guess-p-verb
lin give_in_V = advV OP_give_V OP_in_Adv ; -- guess-p-verb
lin give_in_V2 = prepV2 OP_give_V OP_in_Prep ; -- guess-p-verb
lin give_in_to_V2 = prepV2 (advV OP_give_V OP_in_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_it_to_V2 = variants {} ; -- guess-p-verb
lin give_it_up_for_V2 = variants {} ; -- guess-p-verb
lin give_it_up_to_V2 = variants {} ; -- guess-p-verb
lin give_of_V2 = prepV2 OP_give_V OP_of_Prep ; -- guess-p-verb
lin give_off_V = advV OP_give_V OP_off_Adv ; -- guess-p-verb
lin give_off_V2 = prepV2 OP_give_V OP_off_Prep ; -- guess-p-verb
lin give_onto_V2 = prepV2 OP_give_V OP_onto_Prep ; -- guess-p-verb
lin give_out_V = advV OP_give_V OP_out_Adv ; -- guess-p-verb
lin give_out_V2 = prepV2 OP_give_V OP_out_Prep ; -- guess-p-verb
lin give_over_V = advV OP_give_V OP_over_Adv ; -- guess-p-verb
lin give_over_V2 = prepV2 OP_give_V OP_over_Prep ; -- guess-p-verb
lin give_over_to_V3 = variants {} ; -- guess-p-verb
lin give_up_V = advV OP_give_V OP_up_Adv ; -- guess-p-verb
lin give_up_V2 = prepV2 OP_give_V OP_up_Prep ; -- guess-p-verb
lin give_up_on_V2 = prepV2 (advV OP_give_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin give_up_to_V2 = prepV2 (advV OP_give_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_way_V = advV OP_give_V OP_way_Adv ; -- guess-p-verb
lin give_way_to_V2 = prepV2 (advV OP_give_V OP_way_Adv ) OP_to_Prep ; -- guess-p-verb
lin give_yourself_up_V = variants {} ; -- guess-p-verb
lin give_yourself_up_to_V2 = variants {} ; -- guess-p-verb
lin gizzard_N = mkN "pedrer" masculine ; --auto
lin glabella_N = mkN "glabel·la" feminine ; --auto
lin glacial_A = mkA "glacial" ; --auto
lin glaciation_N = mkN "glaciació" feminine ; --auto
lin glacier_N = mkN "glacera" feminine ; --auto
lin glad_A = mkA "feliç" ; --auto
lin gladden_V2 = mkV2 "alegrar" ; --auto
lin gladiator_N = mkN "gladiador" feminine | mkN "gladiador" masculine ; --auto
lin glance_N = mkN "mirada" feminine ; --auto
lin glance_V = mkV "mirar" ; --auto
lin glance_V2 = mkV2 "mirar" ; --auto
lin gland_N = mkN "glàndula" feminine ; --auto
lin glans_N = mkN "gland" masculine ; --auto
lin glare_N = mkN "enlluernament" masculine ; --auto
lin glasnost_N = mkN "glàsnost" masculine ; --auto
lin glass_1_N = mkN "vidre" masculine ;
lin glass_2_N = mkN "vidre" masculine ;
lin glassmaker_N = mkN "vidrier" feminine | mkN "vidrier" masculine ; --auto
lin glassware_N = mkN "cristalleria" feminine ; --auto
lin glassy_A = mkA "vidriós" ; --auto
lin glaucoma_N = mkN "glaucoma" masculine ; --auto
lin glaze_V = mkV "envernissar" | mkV "vernissar" ; --auto
lin glaze_V2 = mkV2 "envernissar" | mkV2 "vernissar" ; --auto
lin glide_V = mkV "lliscar" ; --auto
lin glider_N = mkN "planador" masculine ; --auto
lin glimpse_N = mkN "cop d'ull" masculine | mkN "ullada" feminine ; --auto
lin glimpse_V2 = mkV2 "entreveure" ; --auto
lin glisten_V = mkV "resplendir" ; --auto
lin global_A = mkA "global" ; --auto
lin globe_N = mkN "globus" masculine | mkN "globus" masculine ; --auto
lin globin_N = mkN "globina" feminine ; --auto
lin globular_A = mkA "globular" ; --auto
lin globule_N = mkN "glòbul" masculine ; --auto
lin globulin_N = mkN "globulina" feminine ; --auto
lin glorification_N = mkN "glorificació" feminine ; --auto
lin glorify_V2 = mkV2 "glorificar" ; --auto
lin glorious_A = mkA "gloriós" | mkA "magnífic" ; --auto
lin glory_N = mkN "glòria" feminine ; --auto
lin gloss_N = mkN "glossa" feminine ; --auto
lin gloss_V2 = mkV2 "glossar" ; --auto
lin glossary_N = mkN "glossari" masculine ; --auto
lin glottochronology_N = mkN "glotocronologia" feminine ; --auto
lin glove_N = L.glove_N ;
lin glow_N = mkN "fulgor" masculine ; --auto
lin glucagon_N = mkN "glucagó" masculine ; --auto
lin glucocorticoid_N = mkN "glucocorticoide" masculine ; --auto
lin glucose_N = mkN "glucosa" feminine ; --auto
lin glue_N = mkN "cola" feminine ; --auto
lin gluon_N = mkN "gluó" masculine ; --auto
lin glutamine_N = mkN "glutamina" feminine ; --auto
lin gluten_N = mkN "gluten" masculine ; --auto
lin gluttony_N = mkN "golosia" feminine ; --auto
lin glycerol_N = mkN "glicerol" masculine ; --auto
lin glycine_N = mkN "glicina" feminine ; --auto
lin glycogen_N = mkN "glicogen" masculine ; --auto
lin glycogenesis_N = mkN "glicogènesi" feminine ; --auto
lin glycolysis_N = mkN "glucòlisi" feminine ; --auto
lin glycoprotein_N = mkN "glicoproteïna" feminine ; --auto
lin gnathion_N = mkN "gnati" masculine ; --auto
lin gnome_N = mkN "gnom" masculine ; --auto
lin gnomon_N = mkN "gnòmon" masculine ; --auto
lin go_V = L.go_V ;
lin go_VA = mkVA L.go_V ;
lin go_VV = aVV (mkV (anar_4 "anar")) ;
lin go_about_V = advV OP_go_V OP_about_Adv ; -- guess-p-verb
lin go_about_V2 = prepV2 OP_go_V OP_about_Prep ; -- guess-p-verb
lin go_across_V = advV OP_go_V OP_across_Adv ; -- guess-p-verb
lin go_after_V2 = prepV2 OP_go_V OP_after_Prep ; -- guess-p-verb
lin go_against_V2 = prepV2 OP_go_V OP_against_Prep ; -- guess-p-verb
lin go_ahead_V = advV OP_go_V OP_ahead_Adv ; -- guess-p-verb
lin go_ahead_with_V2 = prepV2 (advV OP_go_V OP_ahead_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_along_V = advV OP_go_V OP_along_Adv ; -- guess-p-verb
lin go_along_with_V2 = prepV2 (advV OP_go_V OP_along_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_around_V = advV OP_go_V OP_around_Adv ; -- guess-p-verb
lin go_at_V2 = prepV2 OP_go_V OP_at_Prep ; -- guess-p-verb
lin go_away_V = advV OP_go_V OP_away_Adv ; -- guess-p-verb
lin go_back_V = advV OP_go_V OP_back_Adv ; -- guess-p-verb
lin go_back_V2 = mkV2 (advV OP_go_V OP_back_Adv ) ; -- guess-p-verb
lin go_back_on_V2 = prepV2 (advV OP_go_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin go_before_V = advV OP_go_V OP_before_Adv ; -- guess-p-verb
lin go_below_V = advV OP_go_V OP_below_Adv ; -- guess-p-verb
lin go_by_V = advV OP_go_V OP_by_Adv ; -- guess-p-verb
lin go_by_V2 = prepV2 OP_go_V OP_by_Prep ; -- guess-p-verb
lin go_down_V = advV OP_go_V OP_down_Adv ; -- guess-p-verb
lin go_down_on_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin go_down_to_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_down_with_V2 = prepV2 (advV OP_go_V OP_down_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_for_V = advV OP_go_V OP_for_Adv ; -- guess-p-verb
lin go_for_V2 = prepV2 OP_go_V OP_for_Prep ; -- guess-p-verb
lin go_for_it_V = variants {} ; -- guess-p-verb
lin go_forth_V = advV OP_go_V OP_forth_Adv ; -- guess-p-verb
lin go_forward_V = advV OP_go_V OP_forward_Adv ; -- guess-p-verb
lin go_in_V = advV OP_go_V OP_in_Adv ; -- guess-p-verb
lin go_in_for_V2 = prepV2 (advV OP_go_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin go_in_with_V2 = prepV2 (advV OP_go_V OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_into_V2 = prepV2 OP_go_V OP_into_Prep ; -- guess-p-verb
lin go_it_V = variants {} ; -- guess-p-verb
lin go_it_alone_V = variants {} ; -- guess-p-verb
lin go_off_V = advV OP_go_V OP_off_Adv ; -- guess-p-verb
lin go_off_V2 = prepV2 OP_go_V OP_off_Prep ; -- guess-p-verb
lin go_off_with_V2 = prepV2 (advV OP_go_V OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_on_V = advV OP_go_V OP_on_Adv ; -- guess-p-verb
lin go_on_V2 = prepV2 OP_go_V OP_on_Prep ; -- guess-p-verb
lin go_on_about_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_about_Prep ; -- guess-p-verb
lin go_on_at_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_at_Prep ; -- guess-p-verb
lin go_on_to_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_on_with_V2 = prepV2 (advV OP_go_V OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_one_V = variants {} ; -- guess-p-verb
lin go_out_V = advV OP_go_V OP_out_Adv ; -- guess-p-verb
lin go_out_for_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin go_out_to_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_out_with_V2 = prepV2 (advV OP_go_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_over_V = advV OP_go_V OP_over_Adv ; -- guess-p-verb
lin go_over_V2 = prepV2 OP_go_V OP_over_Prep ; -- guess-p-verb
lin go_over_to_V2 = prepV2 (advV OP_go_V OP_over_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_past_V2 = prepV2 OP_go_V OP_past_Prep ; -- guess-p-verb
lin go_round_V = advV OP_go_V OP_round_Adv ; -- guess-p-verb
lin go_through_V = advV OP_go_V OP_through_Adv ; -- guess-p-verb
lin go_through_V2 = prepV2 OP_go_V OP_through_Prep ; -- guess-p-verb
lin go_through_with_V2 = prepV2 (advV OP_go_V OP_through_Adv ) OP_with_Prep ; -- guess-p-verb
lin go_to_V2 = prepV2 OP_go_V OP_to_Prep ; -- guess-p-verb
lin go_together_V = advV OP_go_V OP_together_Adv ; -- guess-p-verb
lin go_towards_V2 = prepV2 OP_go_V OP_towards_Prep ; -- guess-p-verb
lin go_under_V = advV OP_go_V OP_under_Adv ; -- guess-p-verb
lin go_up_V = advV OP_go_V OP_up_Adv ; -- guess-p-verb
lin go_up_to_V2 = prepV2 (advV OP_go_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin go_with_V2 = prepV2 OP_go_V OP_with_Prep ; -- guess-p-verb
lin go_without_V2 = prepV2 OP_go_V OP_without_Prep ; -- guess-p-verb
lin goal_1_N = mkN "objectiu" masculine ;
lin goal_2_N = mkN "gol" masculine ;
lin goat_N = mkN "cabra" feminine ; --auto
lin goblin_N = mkN "follet" masculine ; --auto
lin god_N = mkN "déu" masculine ; --auto
lin goddess_N = mkN "déu" feminine ; --auto
lin godfather_N = mkN "padrí" masculine ; --auto
lin godmother_N = mkN "padrina" feminine ; --auto
lin godson_N = mkN "fillol" feminine | mkN "fillol" masculine ; --auto
lin goitre_N = mkN "goll" masculine ; --auto
lin gold_N = L.gold_N ;
lin golden_A = mkA "daurat" ; --auto
lin gonad_N = mkN "gònada" feminine ; --auto
lin gondola_N = mkN "gòndola" feminine ; --auto
lin gong_N = mkN "gong" masculine ; --auto
lin goniometer_N = mkN "goniòmetre" masculine ; --auto
lin gonion_N = mkN "goni" masculine ; --auto
lin gonioscopy_N = mkN "gonioscòpia" feminine ; --auto
lin good_A = L.good_A ;
lin good_N = mkN "bé" masculine ;
lin good_afternoon_Interj = mkInterj "bon dia" ;
lin good_evening_Interj = mkInterj "bona tarda" ;
lin good_luck_Interj = mkInterj "sort" ;
lin good_morning_Interj = mkInterj "bon dia" ;
lin good_night_Interj = mkInterj "bona nit" ;
lin goodbye_Interj = mkInterj "adéu" | mkInterj "a reveure" ;
lin goodness_N = mkN "bondat" feminine ; --auto
lin goose_N = mkN "oca" feminine ; --auto
lin gordian_A = mkA "gordià" ; --auto
lin gorge_N = mkN "congost" masculine ; --auto
lin gorilla_N = mkN "goril·la" ; --auto
lin gossip_N = mkN "xafarderia" feminine ; --auto
lin gothic_A = mkA "gòtic" ; --auto
lin gothic_N = mkN "gòtic" feminine | mkN "gòtic" masculine ; --auto
lin gouge_N = mkN "gúbia" feminine ; --auto
lin gourmet_N = mkN "gourmet" masculine ; --auto
lin gout_N = mkN "poagre" masculine ; --auto
lin govern_V = mkV "governar" ; --auto
lin govern_V2 = mkV2 "governar" ; --auto
lin government_N = mkN "govern" masculine ;
lin governmental_A = mkA "governamental" ; --auto
lin governor_N = mkN "governador" | mkN "governador" ; --auto
lin grace_N = mkN "gràcia" feminine ; --auto
lin graceless_A = mkA "desairós" ; --auto
lin gradation_N = mkN "gradació" feminine ; --auto
lin grade_N = mkN "grau" masculine | mkN "nota" feminine ; --auto
lin grader_N = mkN "anivelladora" feminine ; --auto
lin gradient_N = mkN "gradient" masculine ; --auto
lin gradual_A = mkA "gradual" ; --auto
lin graduate_N = mkN "llicenciat" feminine | mkN "llicenciat" masculine ; --auto
lin graduate_V = mkV "graduar" ; --auto
lin graduate_V2 = mkV2 "graduar" ; --auto
lin graduation_N = mkN "graduació" feminine ; --auto
lin grain_N = mkN "fibra" feminine | mkN "gra" masculine ; --auto
lin gram_N = mkN "gram" masculine ; --auto
lin grammar_N = L.grammar_N ;
lin grammarian_N = mkN "gramàtic" masculine ; --auto
lin grammatical_A = mkA "gramatical" ; --auto
lin gramme_N = mkN "gram" masculine ; --auto
lin gramophone_N = mkN "gramòfon" masculine ; --auto
lin granary_N = mkN "graner" masculine ; --auto
lin grand_A = mkA "magnífic" ; --auto
lin grandchild_N = mkN "nét" masculine ; --auto
lin granddaughter_N = mkN "nét" feminine ; --auto
lin grandfather_N = mkN "avi" masculine | mkN "avi" masculine ; --auto
lin grandmaster_N = mkN "gran mestre" masculine ; --auto
lin grandmother_N = mkN "avi" feminine ; --auto
lin grandparent_N = mkN "avi" masculine | mkN "avi" masculine ; --auto
lin grandson_N = mkN "nét" masculine ; --auto
lin grandstand_N = mkN "tribuna" feminine ; --auto
lin granite_N = mkN "granit" masculine ; --auto
lin grant_N = mkN "beca" feminine | mkN "subvenció" feminine ; --auto
lin grant_V2 = mkV2 (mkV (servir_101 "concedir")) ;
lin grant_V3 = dirdirV3 (mkV (servir_101 "concedir")) ;
lin granular_A = mkA "granular" ; --auto
lin granularity_N = mkN "granularitat" feminine ; --auto
lin granulate_V = mkV "granular" ; --auto
lin granulate_V2 = mkV2 "granular" ; --auto
lin granulation_N = mkN "granulació" feminine ; --auto
lin granule_N = mkN "grànul" masculine ; --auto
lin granulocyte_N = mkN "granulòcit" masculine ; --auto
lin granuloma_N = mkN "granuloma" masculine ; --auto
lin grape_N = mkN "raïm" masculine ; --auto
lin grapefruit_N = mkN "aranja" feminine ; --auto
lin graph_N = mkN "graf" masculine ; --auto
lin graphic_A = mkA "gràfic" ; --auto
lin graphics_N = mkN "gràfic" masculine ; --auto
lin graphite_N = mkN "grafit" masculine ; --auto
lin graphologist_N = mkN "grafòleg" feminine | mkN "grafòleg" masculine ; --auto
lin graphology_N = mkN "grafologia" feminine ; --auto
lin grapnel_N = mkN "ancorot" masculine ; --auto
lin grasp_V = mkV "agafar" | mkV "copsar" ; --auto
lin grasp_V2 = mkV2 "agafar" | mkV2 "copsar" ; --auto
lin grass_N = L.grass_N ;
lin grassland_N = mkN "gramenet" masculine | mkN "herbassar" masculine | mkN "prada" feminine ; --auto
lin grateful_A = mkA "agraït" ; --auto
lin grater_N = mkN "ratlladora" feminine ; --auto
lin gratify_V2 = mkV2 "gratificar" ; --auto
lin gratitude_N = mkN "agraïment" masculine ; --auto
lin grave_N = mkN "tomba" feminine ; --auto
lin gravestone_N = mkN "làpida" feminine ; --auto
lin gravimeter_N = mkN "gravímetre" masculine ; --auto
lin gravitation_N = mkN "gravitació" feminine ; --auto
lin gravitational_A = mkA "gravitacional" ; --auto
lin graviton_N = mkN "gravitó" masculine ; --auto
lin gravity_N = mkN "gravetat" feminine ; --auto
lin graze_V = mkV "pasturar" ; --auto
lin graze_V2 = mkV2 "pasturar" ; --auto
lin grazier_N = mkN "ramader" ; --auto
lin grease_N = mkN "greix" masculine ; --auto
lin grease_V2 = mkV2 "greixar" ; --auto
lin greaser_N = mkN "greixador" masculine ; --auto
lin greasy_A = mkA "greixós" ; --auto
lin great_A = mkA "genial" | mkA "increïble" ;
lin greatly_Adv = mkAdv "molt" ; --auto
lin greatness_N = mkN "grandesa" feminine ; --auto
lin greed_N = mkN "cobdícia" feminine ; --auto
lin greekFem_N = variants {} ; ---- sense to be split
lin greekMasc_N = variants {} ; ---- sense to be split
lin greek_A = mkA "grec" ; --auto
lin green_A = L.green_A ;
lin green_N = mkN "verd" masculine ; --auto
lin greengrocer_N = mkN "verdulaire" ; --auto
lin greengrocery_N = mkN "verdureria" feminine ; --auto
lin greenish_A = mkA "verdós" ; --auto
lin greet_V2 = mkV2 "saludar" ; --auto
lin greeting_N = mkN "salutació" feminine ; --auto
lin gregorian_A = mkA "gregorià" ; --auto
lin grenadian_A = mkA "grenadià" ; --auto
lin grenadier_N = mkN "granader" masculine ; --auto
lin grenadine_N = mkN "granadina" feminine ; --auto
lin grey_A = mkA "gris" ; --auto
lin grey_N = mkN "gris" masculine ; --auto
lin greyhound_N = mkN "llebrer" masculine ; --auto
lin grid_N = mkN "reixat" masculine ; --auto
lin grievance_N = mkN "queixa" feminine ; --auto
lin griffin_N = mkN "griu" masculine ; --auto
lin grille_N = mkN "reixa" feminine ; --auto
lin grim_A = mkA "sinistre" ; --auto
lin grimace_N = mkN "ganyota" feminine ; --auto
lin grin_V = mkV "somriure d'orella a orella" ; --auto
lin grind_V = mkV "moldre" ; --auto
lin grind_V2 = mkV2 "moldre" ; --auto
lin grinder_N = mkN "molinet" masculine ; --auto
lin grip_N = mkN "agafador" masculine ; --auto
lin grisaille_N = mkN "grisalla" feminine ; --auto
lin grit_N = mkN "sauló" masculine ; --auto
lin groan_V = mkV "gemegar" ; --auto
lin groan_V2 = mkV2 "gemegar" ; --auto
lin groin_N = mkN "engonal" masculine ; --auto
lin groom_N = mkN "nuvi" masculine ; --auto
lin groove_N = mkN "solc" masculine ; --auto
lin groove_V2 = mkV2 "estriar" ; --auto
lin groover_N = mkN "galzador" masculine ; --auto
lin gropingly_Adv = mkAdv "a les palpentes" ; --auto
lin gross_A = mkA "brut" ; --auto
lin gross_N = mkN "brut" masculine ; --auto
lin ground_1_N = mkN "terra" masculine ; --split "terra" feminine : the floor vs. dug up earth
lin ground_2_N = mkN "terra" masculine ; --split "terra" feminine : the floor vs. dug up earth
lin groundhog_N = mkN "marmota" feminine ; --auto
lin groundless_A = mkA "infundat" ; --auto
lin group_N = mkN "grup" masculine ;
lin group_V = mkV "agrupar" ; --auto
lin group_V2 = mkV2 "agrupar" ; --auto
lin grouper_N = mkN "mero" masculine ; --auto
lin grouping_N = mkN "agrupació" feminine ; --auto
lin grouse_N = mkN "gall fer" masculine | mkN "gall salvatge" masculine ; --auto
lin grow_V = mkV "créixer" ;
lin grow_V2 = mkV2 (mkV "plantar") ; --split "fer créixer" plants vs. anything else
lin grow_VA = mkVA (reflV (mkV "tornar")) ;
lin grow_apart_V = advV OP_grow_V OP_apart_Adv ; -- guess-p-verb
lin grow_away_from_V2 = prepV2 (advV OP_grow_V OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin grow_back_V = advV OP_grow_V OP_back_Adv ; -- guess-p-verb
lin grow_from_V2 = prepV2 OP_grow_V OP_from_Prep ; -- guess-p-verb
lin grow_into_V2 = prepV2 OP_grow_V OP_into_Prep ; -- guess-p-verb
lin grow_on_V2 = prepV2 OP_grow_V OP_on_Prep ; -- guess-p-verb
lin grow_out_V = advV OP_grow_V OP_out_Adv ; -- guess-p-verb
lin grow_out_of_V2 = prepV2 (advV OP_grow_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin grow_to_V = advV OP_grow_V OP_to_Adv ; -- guess-p-verb
lin grow_together_V = advV OP_grow_V OP_together_Adv ; -- guess-p-verb
lin grow_under_V = advV OP_grow_V OP_under_Adv ; -- guess-p-verb
lin grow_up_V = advV OP_grow_V OP_up_Adv ; -- guess-p-verb
lin grow_up_on_V2 = prepV2 (advV OP_grow_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin grow_upon_V2 = prepV2 OP_grow_V OP_upon_Prep ; -- guess-p-verb
lin grower_N = mkN "productor" masculine ; --auto
lin growl_V = mkV "grunyir" ; --auto
lin growl_V2 = mkV2 "grunyir" ; --auto
lin growth_N = mkN "creixement" masculine ;
lin grudge_N = mkN "rancúnia" feminine ; --auto
lin grumpy_A = mkA "rondinaire" ; --auto
lin guanaco_N = mkN "guanac" masculine ; --auto
lin guanine_N = mkN "guanina" feminine ; --auto
lin guarantee_N = mkN "aval" masculine | mkN "garantia" feminine ; --auto
lin guarantee_V = mkV "garantir" ; --auto
lin guarantee_V2 = mkV2 "garantir" ; --auto
lin guarantor_N = mkN "avalador" | mkN "avalador" ; --auto
lin guard_N = mkN "guàrdia" feminine ; --auto
lin guardian_N = mkN "guardià" | mkN "guardià" ; --auto
lin guatemalan_A = mkA "guatemalenc" ; --auto
lin guatemalan_N = mkN "guatemalenc" | mkN "guatemalenc" ; --auto
lin guerrilla_N = mkN "guerrilla" feminine ; --auto
lin guess_N = mkN "suposició" feminine ; --auto
lin guess_V = mkV "endevinar" ; --auto
lin guess_V2 = mkV2 "endevinar" ; --auto
lin guest_N = mkN "convidat" feminine | mkN "convidat" masculine | mkN "hoste" masculine ; --auto
lin guesthouse_N = mkN "pensió" feminine ; --auto
lin guffaw_N = mkN "riallada" feminine ; --auto
lin guidance_N = mkN "guiatge" masculine ; --auto
lin guide_N = mkN "guia" feminine | mkN "guia" masculine ; --auto
lin guide_V2 = mkV2 "guiar" ; --auto
lin guideline_N = mkN "directriu" feminine ; --auto
lin guild_N = mkN "gremi" masculine ; --auto
lin guilder_N = mkN "florí" masculine ; --auto
lin guillotine_N = mkN "guillotina" feminine ; --auto
lin guilty_A = mkA "culpable" ; --auto
lin guinean_A = mkA "guineà" ; --auto
lin guise_N = mkN "guisa" feminine ; --auto
lin guitar_N = mkN "guitarra" feminine ; --auto
lin guitarist_N = mkN "guitarrista" ; --auto
lin gulf_N = mkN "golf" masculine ; --auto
lin gull_1_N = mkN "gavina" feminine ; --auto
lin gull_2_N = mkN "gavina" feminine ; --auto
lin gully_N = mkN "escorranc" masculine ; --auto
lin gum_V2 = mkV2 "engomar" ; --auto
lin gummosis_N = mkN "gomosi" feminine ; --auto
lin gun_N = mkN "arma de foc" feminine | mkN "pistola" feminine ; --auto
lin gunboat_N = mkN "canoner" masculine ; --auto
lin gunite_N = mkN "gunita" feminine ; --auto
lin gunman_N = mkN "home armat" masculine ; --auto
lin gunnel_N = mkN "borda" feminine ; --auto
lin gunpowder_N = mkN "pólvora" feminine ; --auto
lin guttural_A = mkA "guttural" ; --auto
lin guy_N = mkN "xicot" masculine ; --auto
lin guyanese_A = mkA "guyanès" ; --auto
lin gym_N = mkN "gimnàs" masculine ; --auto
lin gymnasium_N = mkN "gimnàs" masculine ; --auto
lin gymnast_N = mkN "gimnasta" ; --auto
lin gymnastic_A = mkA "gimnàstic" ; --auto
lin gymnastics_N = mkN "gimnàstica" feminine ; --auto
lin gymnosperm_N = mkN "gimnosperma" feminine ; --auto
lin gynaecologist_N = mkN "ginecòleg" | mkN "ginecòleg" ; --auto
lin gynaecology_N = mkN "ginecologia" feminine ; --auto
lin gynecologistFem_N = variants {} ; ---- sense to be split
lin gynecologistMasc_N = variants {} ; ---- sense to be split
lin gynecomastia_N = mkN "ginecomàstia" feminine ; --auto
lin gypsum_N = mkN "guix" masculine ; --auto
lin gyroscope_N = mkN "giroscopi" masculine ; --auto
lin gyroscopic_A = mkA "giroscòpic" ; --auto
lin habanera_N = mkN "havanera" feminine ; --auto
lin haberdasher_N = mkN "mercer" feminine | mkN "mercer" masculine ; --auto
lin haberdashery_N = mkN "merceria" feminine ; --auto
lin habit_N = mkN "costum" masculine | mkN "hàbit" masculine ; --auto
lin habitat_N = mkN "hàbitat" masculine ; --auto
lin hadron_N = mkN "hadró" masculine ; --auto
lin hafnium_N = mkN "hafni" masculine ; --auto
lin hagiographer_N = mkN "hagiògraf" feminine | mkN "hagiògraf" masculine ; --auto
lin hagiography_N = mkN "hagiografia" feminine ; --auto
lin hailstorm_N = mkN "calamarsada" feminine ; --auto
lin hair_N = L.hair_N ;
lin haircut_N = mkN "tall de cabell" masculine ; --auto
lin hairdresser_N = mkN "perruquer" | mkN "perruquer" ; --auto
lin hairy_A = mkA "pelut" ; --auto
lin haitian_A = mkA "haitià" ; --auto
lin haitian_N = mkN "haitià" | mkN "haitià" ; --auto
lin hake_N = mkN "lluç" masculine ; --auto
lin half_A = mkA "mig" ; --auto
lin half_Adv = mkAdv "mig" ; --auto
lin half_N = mkN "mig" masculine ;
lin half_Predet = {s = \\a,c => prepCase c ++ "mig" ; c = Nom ; a = PNoAg} ;
lin half_brother_N = mkN "mig germà" masculine ; --auto
lin half_sister_N = mkN "mig germà" feminine ; --auto
lin halftone_N = mkN "tramat" masculine ; --auto
lin halide_N = mkN "halur" masculine ; --auto
lin halite_N = mkN "halita" feminine ; --auto
lin halitosis_N = mkN "halitosi" feminine ; --auto
lin hall_N = mkN "vestíbul" masculine ;
lin hallelujah_N = mkN "al·leluia" masculine ; --auto
lin hallucination_N = mkN "al·lucinació" feminine ; --auto
lin hallucinogen_N = mkN "al·lucinogen" masculine ; --auto
lin halo_N = mkN "halo" masculine ; --auto
lin halogen_N = mkN "halogen" masculine ; --auto
lin halophyte_N = mkN "halòfit" masculine ; --auto
lin halt_V = mkV "aturar" ; --auto
lin halt_V2 = mkV2 "aturar" ; --auto
lin halter_N = mkN "cabestre" masculine ; --auto
lin ham_N = mkN "pernil" masculine ; --auto
lin hamburger_N = mkN "hamburguesa" feminine ; --auto
lin hamlet_N = mkN "llogarret" masculine ; --auto
lin hammer_N = mkN "martell" masculine ; --auto
lin hammer_V = mkV "picar" ; --auto
lin hammer_V2 = mkV2 "picar" ; --auto
lin hammock_N = mkN "hamaca" feminine ; --auto
lin hamper_V2 = mkV2 "dificultar" ; --auto
lin hamster_N = mkN "hàmster" masculine ; --auto
lin hand_N = L.hand_N ;
lin hand_V2 = mkV2 "entregar" ; --auto
lin hand_back_V2 = mkV2 (advV (lin V OP_hand_V2) OP_back_Adv ) ; -- guess-p-verb
lin hand_carry_V2 = variants {} ; -- guess-p-verb
lin hand_down_V2 = prepV2 (lin V OP_hand_V2) OP_down_Prep ; -- guess-p-verb
lin hand_in_V2 = prepV2 (lin V OP_hand_V2) OP_in_Prep ; -- guess-p-verb
lin hand_on_V2 = prepV2 (lin V OP_hand_V2) OP_on_Prep ; -- guess-p-verb
lin hand_out_V2 = prepV2 (lin V OP_hand_V2) OP_out_Prep ; -- guess-p-verb
lin hand_over_V2 = prepV2 (lin V OP_hand_V2) OP_over_Prep ; -- guess-p-verb
lin handball_N = mkN "handbol" masculine ; --auto
lin handicapped_A = mkA "minusvàlid" ; --auto
lin handicraft_N = mkN "manualitat" feminine ; --auto
lin handkerchief_N = mkN "mocador" masculine ; --auto
lin handle_N = mkN "mànec" masculine | mkN "maneta" feminine ; --auto
lin handle_V = mkV "manejar" ; --auto
lin handle_V2 = mkV2 "manejar" ; --auto
lin handlebar_N = mkN "manillar" masculine ; --auto
lin handmade_A = mkA "fet a mà" ; --auto
lin handshake_N = mkN "encaixada" feminine ; --auto
lin handsome_A = mkA "maco" ; --auto
lin handstamp_N = mkN "mata-segells" masculine | mkN "mata-segells" masculine ; --auto
lin handwriting_N = mkN "lletra" feminine ; --auto
lin handwritten_A = mkA "manuscrit" ; --auto
lin handy_A = mkA "manejable" ; --auto
lin hang_V = mkV "penjar" ;
lin hang_V2 = mkV2 (mkV "penjar") ;
lin hang_about_V = advV OP_hang_V OP_about_Adv ; -- guess-p-verb
lin hang_around_V = advV OP_hang_V OP_around_Adv ; -- guess-p-verb
lin hang_around_V2 = prepV2 OP_hang_V OP_around_Prep ; -- guess-p-verb
lin hang_back_V = advV OP_hang_V OP_back_Adv ; -- guess-p-verb
lin hang_back_from_V2 = prepV2 (advV OP_hang_V OP_back_Adv ) OP_from_Prep ; -- guess-p-verb
lin hang_in_there_V = variants {} ; -- guess-p-verb
lin hang_it_up_V = variants {} ; -- guess-p-verb
lin hang_on_V = advV OP_hang_V OP_on_Adv ; -- guess-p-verb
lin hang_onto_V2 = prepV2 OP_hang_V OP_onto_Prep ; -- guess-p-verb
lin hang_out_V = advV OP_hang_V OP_out_Adv ; -- guess-p-verb
lin hang_out_V2 = prepV2 OP_hang_V OP_out_Prep ; -- guess-p-verb
lin hang_out_for_V2 = prepV2 (advV OP_hang_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin hang_over_V2 = prepV2 OP_hang_V OP_over_Prep ; -- guess-p-verb
lin hang_together_V = advV OP_hang_V OP_together_Adv ; -- guess-p-verb
lin hang_up_V = advV OP_hang_V OP_up_Adv ; -- guess-p-verb
lin hang_up_V2 = prepV2 OP_hang_V OP_up_Prep ; -- guess-p-verb
lin hang_up_on_V2 = prepV2 (advV OP_hang_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin hang_with_V2 = prepV2 OP_hang_V OP_with_Prep ; -- guess-p-verb
lin hangar_N = mkN "hangar" masculine ; --auto
lin hanger_N = mkN "penjador" masculine ; --auto
lin hangman_N = mkN "botxí" masculine ; --auto
lin hangover_N = mkN "ressaca" feminine ; --auto
lin haphazard_A = mkA "fortuït" ; --auto
lin hapless_A = mkA "desventurat" ; --auto
lin haploid_A = mkA "haploide" ; --auto
lin happen_V = mkV "passar" | verbV (córrer_30 "ocórrer") ;
lin happiness_N = mkN "felicitat" feminine ; --auto
lin happy_A = mkA "feliç" | mkA "content" ;
lin harass_V2 = mkV2 "assetjar" ; --auto
lin harbour_N = L.harbour_N ;
lin hard_1_A = mkA "difícil" ; --split "dur" (difficult vs. mineral hardness)
lin hard_2_A = mkA "difícil" ; --split "dur" (difficult vs. mineral hardness)
lin hardly_AdV = mkAdv "a penes" | mkAdv "difícilment" ; --auto
lin hardness_N = mkN "duresa" feminine ; --auto
lin hardship_N = mkN "tràngol" masculine ; --auto
lin hardware_N = mkN "maquinari" masculine ; --auto
lin hardy_A = mkA "fort" ; --auto
lin hare_N = mkN "llebre" feminine ; --auto
lin harem_N = mkN "harem" masculine ; --auto
lin haricot_N = mkN "monjeta" feminine ; --auto
lin harlequin_N = mkN "arlequí" masculine ; --auto
lin harm_N = mkN "mal" masculine ; --auto
lin harmful_A = mkA "nociu" ; --auto
lin harmonic_A = mkA "harmònic" ; --auto
lin harmonic_N = mkN "harmònic" masculine ; --auto
lin harmonica_N = mkN "harmònica" feminine ; --auto
lin harmonious_A = mkA "harmoniós" ; --auto
lin harmonium_N = mkN "harmònium" masculine ; --auto
lin harmony_N = mkN "harmonia" feminine ; --auto
lin harp_N = mkN "arpa" feminine ; --auto
lin harpist_N = mkN "arpista" ; --auto
lin harpoon_N = mkN "arpó" masculine ; --auto
lin harrow_V2 = mkV2 "rasclar" ; --auto
lin harsh_A = mkA "dur" ; --auto
lin harvest_N = mkN "collita" feminine ; --auto
lin harvest_V2 = mkV2 "collir" ; --auto
lin haste_N = mkN "pressa" feminine ; --auto
lin hasty_A = mkA "precipitat" ; --auto
lin hat_N = L.hat_N ;
lin hatch_V = mkV "covar" ; --auto
lin hatch_V2 = mkV2 "covar" ; --auto
lin hate_N = mkN "odi" masculine ; --auto
lin hate_V2 = L.hate_V2 ;
lin hate_VV = variants {} ; -- L.hate_V2 ;
lin hate_on_V2 = prepV2 (lin V OP_hate_V2) OP_on_Prep ; -- guess-p-verb
lin hatred_N = mkN "aversió" feminine ; --auto
lin haustorium_N = mkN "haustori" masculine ; --auto
lin have_V = mkV (tenir_108 "tenir") ;
lin have_V2 = S.have_V2 ;
lin have_VV = deVV IrregCat.haver_V ; -- doesn't seem to lin correctly
lin have_against_V2 = prepV2 OP_have_V OP_against_Prep ; -- guess-p-verb
lin have_around_V2 = prepV2 OP_have_V OP_around_Prep ; -- guess-p-verb
lin have_down_as_V3 = variants {} ; -- guess-p-verb
lin have_in_V2 = prepV2 OP_have_V OP_in_Prep ; -- guess-p-verb
lin have_it_away_V = variants {} ; -- guess-p-verb
lin have_it_in_for_V2 = variants {} ; -- guess-p-verb
lin have_it_off_V = variants {} ; -- guess-p-verb
lin have_it_out_with_V2 = variants {} ; -- guess-p-verb
lin have_off_V2 = prepV2 OP_have_V OP_off_Prep ; -- guess-p-verb
lin have_on_V = advV OP_have_V OP_on_Adv ; -- guess-p-verb
lin have_on_V2 = prepV2 OP_have_V OP_on_Prep ; -- guess-p-verb
lin have_over_V2 = prepV2 OP_have_V OP_over_Prep ; -- guess-p-verb
lin have_round_V2 = prepV2 OP_have_V OP_round_Prep ; -- guess-p-verb
lin have_up_V2 = prepV2 OP_have_V OP_up_Prep ; -- guess-p-verb
lin hay_N = mkN "fenc" masculine ; --auto
lin haystack_N = mkN "paller" masculine ; --auto
lin hazardous_A = mkA "perillós" ; --auto
lin haze_N = mkN "calima" feminine ; --auto
lin hazel_N = mkN "avellaner" masculine ; --auto
lin hazelnut_N = mkN "avellana" feminine ; --auto
lin hazy_A = mkA "boirós" ; --auto
lin he_Pron = optProDrop S.he_Pron ;
lin head_N = L.head_N ;
lin head_V = mkV "encapçalar" ; --auto
lin head_V2 = mkV2 "encapçalar" ; --auto
lin head_for_V2 = prepV2 OP_head_V OP_for_Prep ; -- guess-p-verb
lin head_off_V = advV OP_head_V OP_off_Adv ; -- guess-p-verb
lin head_off_V2 = prepV2 OP_head_V OP_off_Prep ; -- guess-p-verb
lin head_out_V = advV OP_head_V OP_out_Adv ; -- guess-p-verb
lin head_up_V2 = prepV2 OP_head_V OP_up_Prep ; -- guess-p-verb
lin headache_N = mkN "mal de cap" masculine ; --auto
lin headband_N = mkN "cinta" feminine ; --auto
lin header_N = mkN "encapçalament" masculine ; --auto
lin head_hunter_N = mkN "caçatalents" | mkN "caçatalents" ; --auto
lin headline_N = mkN "titular" ; --auto
lin headquarters_N = mkN "seu" feminine ; --auto
lin headrest_N = mkN "recolzacap" masculine ; --auto
lin heal_V = mkV "guarir-se" ; --auto
lin health_N = mkN "salut" feminine ;
lin healthy_A = mkA "sa" | mkA "saludable" ; --auto
lin hear_V = verbV (sentir_100 "sentir") ;
lin hear_V2 = mkV2 (verbV (sentir_100 "sentir")) ;
lin hear_V2V = mkV2V (verbV (sentir_100 "sentir")) ParadigmsCat.accusative ParadigmsCat.accusative ;
lin hear_VS = mkVS (verbV (sentir_100 "sentir")) ;
lin hear_about_V2 = prepV2 OP_hear_V OP_about_Prep ; -- guess-p-verb
lin hear_from_V2 = prepV2 OP_hear_V OP_from_Prep ; -- guess-p-verb
lin hear_of_V2 = prepV2 OP_hear_V OP_of_Prep ; -- guess-p-verb
lin hear_of_V3 = variants {} ; -- guess-p-verb
lin hear_out_V2 = prepV2 OP_hear_V OP_out_Prep ; -- guess-p-verb
lin hearing_N = mkN "audiència" feminine | mkN "oïda" feminine | mkN "vista" feminine ; --auto
lin heart_N = L.heart_N ;
lin hearth_N = mkN "llar de foc" feminine ; --auto
lin heat_N = mkN "calor" feminine ; --auto
lin heat_V = mkV "calfar" | mkV "escalfar" ; --auto
lin heat_V2 = mkV2 "calfar" | mkV2 "escalfar" ; --auto
lin heater_N = mkN "escalfador" masculine ; --auto
lin heath_N = mkN "bruc" masculine ; --auto
lin heathen_N = mkN "pagà" | mkN "pagà" ; --auto
lin heating_N = mkN "calefacció" feminine ; --auto
lin heave_V = mkV "alçar" ; --auto
lin heave_V2 = mkV2 "alçar" ; --auto
lin heaven_N = mkN "cel" masculine ; --auto
lin heavenly_A = mkA "celestial" ; --auto
lin heavenward_Adv = mkAdv "cap al cel" ; --auto
lin heavenwards_Adv = mkAdv "cap al cel" ; --auto
lin heavily_Adv = mkAdv "fortament" ; --auto
lin heavy_A = L.heavy_A ;
lin hebrew_A = mkA "hebreu" ; --auto
lin hectare_N = mkN "hectàrea" feminine ; --auto
lin hedge_N = mkN "tanca" feminine ; --auto
lin hedgehog_N = mkN "eriçó" masculine ; --auto
lin heedless_A = mkA "despreocupat" ; --auto
lin heel_N = mkN "taló" masculine ; --auto
lin hegemony_N = mkN "hegemonia" feminine ; --auto
lin height_N = mkN "alçada" feminine | mkN "alçària" feminine | mkN "cota" feminine | mkN "estatura" feminine ; --auto
lin heir_N = mkN "hereu" masculine ; --auto
lin heiress_N = mkN "hereu" feminine ; --auto
lin helicopter_N = mkN "helicòpter" masculine ; --auto
lin heliocentric_A = mkA "heliocèntric" ; --auto
lin heliograph_N = mkN "heliògraf" masculine ; --auto
lin heliotherapy_N = mkN "helioteràpia" feminine ; --auto
lin heliotrope_N = mkN "heliotropi" masculine ; --auto
lin heliozoan_N = mkN "heliozou" masculine ; --auto
lin heliport_N = mkN "heliport" masculine ; --auto
lin helium_N = mkN "heli" masculine ; --auto
lin hell_N = mkN "infern" masculine ; --auto
lin hello_Interj = mkInterj "hola" ;
lin hellenic_A = mkA "hel·lènic" ; --auto
lin helmet_N = mkN "casc" masculine ; --auto
lin helminth_N = mkN "helmint" masculine ; --auto
lin helminthiasis_N = mkN "helmintiasi" feminine ; --auto
lin helmsman_N = mkN "timoner" feminine | mkN "timoner" masculine ; --auto
lin help_N = mkN "ajuda" ;
lin help_V = mkV "ajudar" ;
lin help_V2 = mkV2 (mkV "ajudar" ) ;
lin help_V2V = mkV2V (mkV "ajudar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin help_out_V2 = prepV2 OP_help_V OP_out_Prep ; -- guess-p-verb
lin help_to_VV = variants {} ; -- guess-p-verb
lin helperFem_N = variants {} ; ---- sense to be split
lin helperMasc_N = variants {} ; ---- sense to be split
lin helpful_A = mkA "útil" ; --auto
lin hemagglutination_N = mkN "hemaglutinació" feminine ; --auto
lin hemangioma_N = mkN "hemangioma" masculine ; --auto
lin hematemesis_N = mkN "hematèmesi" feminine ; --auto
lin hematocrit_N = mkN "hematòcrit" masculine ; --auto
lin hematology_N = mkN "hematologia" feminine ; --auto
lin hematoma_N = mkN "hematoma" masculine ; --auto
lin hematopoiesis_N = mkN "hematopoesi" feminine ; --auto
lin hematuria_N = mkN "hematúria" feminine ; --auto
lin hemeralopia_N = mkN "hemeralopia" feminine ; --auto
lin hemiparasite_N = mkN "hemiparàsit" masculine ; --auto
lin hemiplegia_N = mkN "hemiplegia" feminine ; --auto
lin hemisphere_N = mkN "hemisferi" masculine ; --auto
lin hemispherical_A = mkA "hemisfèric" | mkA "semiesfèric" ; --auto
lin hemodialysis_N = mkN "hemodiàlisi" feminine ; --auto
lin hemoglobin_N = mkN "hemoglobina" feminine ; --auto
lin hemolysin_N = mkN "hemolisina" feminine ; --auto
lin hemolysis_N = mkN "hemòlisi" feminine ; --auto
lin hemophilia_N = mkN "hemofília" feminine ; --auto
lin hemoptysis_N = mkN "hemoptisi" feminine ; --auto
lin hemorrhoid_N = mkN "hemorroide" masculine ; --auto
lin hemosiderosis_N = mkN "hemosiderosi" feminine ; --auto
lin hemp_N = mkN "cànem" masculine ; --auto
lin hen_N = mkN "gallina" feminine ; --auto
lin hence_Adv = mkAdv "per això" ; --auto
lin henceforth_Adv = mkAdv "des d'ara" ; --auto
lin henceforward_Adv = mkAdv "des d'ara" ; --auto
lin henna_N = mkN "henna" feminine ; --auto
lin heparin_N = mkN "heparina" feminine ; --auto
lin hepatic_A = mkA "hepàtic" ; --auto
lin hepatitis_N = mkN "hepatitis" feminine | mkN "hepatitis" feminine ; --auto
lin hepatomegaly_N = mkN "hepatomegàlia" feminine ; --auto
lin heptagon_N = mkN "heptàgon" masculine ; --auto
lin herald_N = mkN "herald" masculine ; --auto
lin heraldry_N = mkN "heràldica" feminine ; --auto
lin herbicide_N = mkN "herbicida" feminine ; --auto
lin herbivore_N = mkN "herbívor" masculine ; --auto
lin herbivorous_A = mkA "herbívor" ; --auto
lin herd_N = mkN "ramat" masculine ; --auto
lin here_Adv = mkAdv "aquí" ;
lin hereabouts_Adv = mkAdv "per aquí a prop" ; --auto
lin hereafter_Adv = mkAdv "des d'ara" ; --auto
lin hereby_Adv = mkAdv "des d'ara" ; --auto
lin hereditary_A = mkA "hereditari" ; --auto
lin heredity_N = mkN "herència" feminine ; --auto
lin hereinafter_Adv = mkAdv "des d'ara" ; --auto
lin hereof_Adv = mkAdv "d'això" ; --auto
lin heretic_N = mkN "heretge" ; --auto
lin heretofore_Adv = mkAdv "fins ara" ; --auto
lin hereupon_Adv = mkAdv "consegüentment" ; --auto
lin heritage_N = mkN "patrimoni" masculine ; --auto
lin hermaphrodite_N = mkN "hermafrodita" ; --auto
lin hermaphroditism_N = mkN "hermafroditisme" masculine ; --auto
lin hermeneutics_N = mkN "hermenèutica" feminine ; --auto
lin hermitage_N = mkN "ermita" feminine ; --auto
lin hernia_N = mkN "hèrnia" feminine ; --auto
lin hero_N = mkN "heroi" masculine ; --auto
lin heroic_A = mkA "heroic" ; --auto
lin heroin_N = mkN "heroïna" feminine ; --auto
lin heroine_N = mkN "heroi" feminine ; --auto
lin heroism_N = mkN "heroïcitat" feminine ; --auto
lin herpes_N = mkN "herpes" masculine | mkN "herpes" masculine ; --auto
lin herpetology_N = mkN "herpetologia" feminine ; --auto
lin herring_N = mkN "areng" masculine ; --auto
lin hesitant_A = mkA "indecís" ; --auto
lin hesitate_V = mkV "dubtar" | mkV "vacil·lar" ; --auto
lin heterocyclic_A = mkA "heterocíclic" ; --auto
lin heterogeneity_N = mkN "heterogeneïtat" feminine ; --auto
lin heterogeneous_A = mkA "heterogeni" ; --auto
lin heteronym_N = mkN "heterònim" masculine ; --auto
lin heterosexual_A = mkA "heterosexual" ; --auto
lin heterosexuality_N = mkN "heterosexualitat" feminine ; --auto
lin heterotrophic_A = mkA "heteròtrof" ; --auto
lin heterozygote_N = mkN "heterozigot" masculine ; --auto
lin heuristic_A = mkA "heurístic" ; --auto
lin heuristics_N = mkN "heurística" feminine ; --auto
lin hexadecimal_A = mkA "hexadecimal" ; --auto
lin hexagon_N = mkN "hexàgon" masculine ; --auto
lin hexagonal_A = mkA "hexagonal" ; --auto
lin hexameter_N = mkN "hexàmetre" masculine ; --auto
lin hexane_N = mkN "hexà" masculine ; --auto
lin hexose_N = mkN "hexosa" feminine ; --auto
lin hiatus_N = mkN "hiat" masculine ; --auto
lin hibernation_N = mkN "hibernació" feminine ; --auto
lin hide_N = mkN "amagatall" masculine ; --auto
lin hide_V = mkV "amagar" ; --auto
lin hide_V2 = mkV2 "amagar" ; --auto
lin hide_away_V = advV OP_hide_V OP_away_Adv ; -- guess-p-verb
lin hide_away_V2 = mkV2 (advV OP_hide_V OP_away_Adv ) ; -- guess-p-verb
lin hide_out_V = advV OP_hide_V OP_out_Adv ; -- guess-p-verb
lin hierarchical_A = mkA "jeràrquic" ; --auto
lin hierarchy_N = mkN "jerarquia" feminine ; --auto
lin hieroglyph_N = mkN "jeroglífic" masculine ; --auto
lin hieroglyphic_A = mkA "jeroglífic" ; --auto
lin high_A = mkA "alt" ;
lin high_Adv = mkAdv "alt" ; --auto
lin highlight_N = mkN "punt destacat" masculine ; --auto
lin highlight_V2 = mkV2 "destacar" ; --auto
lin highly_Adv = mkAdv "altament" ;
lin highway_N = mkN "autopista" feminine | mkN "carretera" feminine ; --auto
lin hill_N = L.hill_N ;
lin hilum_N = mkN "hil" masculine ; --auto
lin hinder_V2 = mkV2 "obstaculitzar" ; --auto
lin hinduism_N = mkN "hinduisme" masculine ; --auto
lin hinge_N = mkN "golfo" masculine ; --auto
lin hint_N = mkN "pista" feminine ; --auto
lin hip_N = mkN "maluc" masculine ; --auto
lin hippocampus_N = mkN "hipocamp" masculine ; --auto
lin hippodrome_N = mkN "hipòdrom" masculine ; --auto
lin hippopotamus_N = mkN "hipopòtam" masculine ; --auto
lin hippy_N = mkN "hippy" ; --auto
lin hire_N = mkN "lloguer" masculine ; --auto
lin hire_V2 = mkV2 "contractar" ; --auto
lin hispanic_A = mkA "hispànic" ; --auto
lin histamine_N = mkN "histamina" feminine ; --auto
lin histiocyte_N = mkN "histiòcit" masculine ; --auto
lin histiocytosis_N = mkN "histiocitosi" feminine ; --auto
lin histocompatibility_N = mkN "histocompatibilitat" feminine ; --auto
lin histogram_N = mkN "histograma" masculine ; --auto
lin histoincompatibility_N = mkN "histoincompatibilitat" feminine ; --auto
lin histologist_N = mkN "històleg" feminine | mkN "històleg" masculine ; --auto
lin histology_N = mkN "histologia" feminine ; --auto
lin histone_N = mkN "histona" feminine ; --auto
lin historian_N = mkN "historiador" | mkN "historiador" ; --auto
lin historical_A = mkA "històric" ; --auto
lin historiography_N = mkN "historiografia" feminine ; --auto
lin history_N = mkN "història" feminine ;
lin hit_N = mkN "èxit" masculine | mkN "impacte" masculine ; --auto
lin hit_V = mkV (trencar_112 "picar") ;
lin hit_V2 = L.hit_V2 ;
lin hit_back_V2 = mkV2 (advV OP_hit_V OP_back_Adv ) ; -- guess-p-verb
lin hit_for_V3 = variants {} ; -- guess-p-verb
lin hit_it_off_V = variants {} ; -- guess-p-verb
lin hit_it_off_with_V2 = variants {} ; -- guess-p-verb
lin hit_on_V2 = prepV2 OP_hit_V OP_on_Prep ; -- guess-p-verb
lin hit_out_at_V2 = prepV2 (advV OP_hit_V OP_out_Adv ) OP_at_Prep ; -- guess-p-verb
lin hit_up_V = advV OP_hit_V OP_up_Adv ; -- guess-p-verb
lin hit_up_V2 = prepV2 OP_hit_V OP_up_Prep ; -- guess-p-verb
lin hit_up_on_V2 = prepV2 (advV OP_hit_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin hit_upon_V2 = prepV2 OP_hit_V OP_upon_Prep ; -- guess-p-verb
lin hit_with_V3 = variants {} ; -- guess-p-verb
lin hitherto_Adv = mkAdv "fins aquí" ; --auto
lin hoarding_N = mkN "abassegament" masculine ; --auto
lin hoarfrost_N = mkN "gebre" masculine ; --auto
lin hobble_N = mkN "coixesa" feminine ; --auto
lin hobby_N = mkN "hobby" masculine ; --auto
lin hockey_N = mkN "hoquei" masculine ; --auto
lin hodgepodge_N = mkN "poti-poti" masculine ; --auto
lin hoist_N = mkN "muntacàrregues" masculine | mkN "muntacàrregues" masculine | mkN "polispast" masculine ; --auto
lin hold_N = mkN "agafament" masculine | mkN "bodega" feminine | mkN "control" masculine ; --auto
lin hold_V = mkV "aguantar" ;
lin hold_V2 = L.hold_V2 ;
lin hold_VS = mkVS (verbV (obtenir_78 "sostenir")) ;
lin hold_against_V3 = variants {} ; -- guess-p-verb
lin hold_back_V = advV OP_hold_V OP_back_Adv ; -- guess-p-verb
lin hold_back_V2 = mkV2 (advV OP_hold_V OP_back_Adv ) ; -- guess-p-verb
lin hold_back_from_V2 = prepV2 (advV OP_hold_V OP_back_Adv ) OP_from_Prep ; -- guess-p-verb
lin hold_down_V2 = prepV2 OP_hold_V OP_down_Prep ; -- guess-p-verb
lin hold_forth_V = advV OP_hold_V OP_forth_Adv ; -- guess-p-verb
lin hold_off_V = advV OP_hold_V OP_off_Adv ; -- guess-p-verb
lin hold_off_V2 = prepV2 OP_hold_V OP_off_Prep ; -- guess-p-verb
lin hold_off_on_V2 = prepV2 (advV OP_hold_V OP_off_Adv ) OP_on_Prep ; -- guess-p-verb
lin hold_on_V = advV OP_hold_V OP_on_Adv ; -- guess-p-verb
lin hold_on_to_V2 = prepV2 (advV OP_hold_V OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin hold_onto_V = variants {} ; -- guess-p-verb
lin hold_onto_V2 = prepV2 OP_hold_V OP_onto_Prep ; -- guess-p-verb
lin hold_out_V = advV OP_hold_V OP_out_Adv ; -- guess-p-verb
lin hold_out_V2 = prepV2 OP_hold_V OP_out_Prep ; -- guess-p-verb
lin hold_out_against_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_against_Prep ; -- guess-p-verb
lin hold_out_for_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin hold_out_on_V2 = prepV2 (advV OP_hold_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin hold_over_V2 = prepV2 OP_hold_V OP_over_Prep ; -- guess-p-verb
lin hold_together_V = advV OP_hold_V OP_together_Adv ; -- guess-p-verb
lin hold_up_V2 = prepV2 OP_hold_V OP_up_Prep ; -- guess-p-verb
lin hold_with_V2 = prepV2 OP_hold_V OP_with_Prep ; -- guess-p-verb
lin holder_N = mkN "titular" ; --auto
lin holding_N = mkN "holding" masculine ; --auto
lin hole_N = mkN "forat" masculine ;
lin holiday_N = mkN "vacances" feminine ;
lin holism_N = mkN "holisme" masculine ; --auto
lin hollow_A = mkA "buit" ; --auto
lin holmium_N = mkN "holmi" masculine ; --auto
lin holocaust_N = mkN "holocaust" masculine ; --auto
lin hologram_N = mkN "holograma" masculine ; --auto
lin holograph_N = mkN "hològraf" masculine ; --auto
lin holography_N = mkN "holografia" feminine ; --auto
lin holster_N = mkN "pistolera" feminine ; --auto
lin holy_A = mkA "sagrat" ; --auto
lin homage_N = mkN "homenatge" masculine ; --auto
lin home_Adv = mkAdv "a casa" ; --auto
lin home_N = mkN "casa" feminine ;
lin homeland_N = mkN "pàtria" feminine ; --auto
lin homeostasis_N = mkN "homeòstasi" feminine ; --auto
lin homestead_N = mkN "mas" masculine ; --auto
lin homework_N = mkN "deure" masculine ; --auto
lin homicide_N = mkN "homicidi" masculine ; --auto
lin hominid_N = mkN "homínid" masculine ; --auto
lin homoeopath_N = mkN "homeòpata" ; --auto
lin homoeopathy_N = mkN "homeopatia" feminine ; --auto
lin homogeneity_N = mkN "homogeneïtat" feminine ; --auto
lin homograph_N = mkN "homògraf" masculine ; --auto
lin homologous_A = mkA "homòleg" ; --auto
lin homology_N = mkN "homologia" feminine ; --auto
lin homomorphism_N = mkN "homomorfisme" masculine ; --auto
lin homonym_N = mkN "homònim" masculine ; --auto
lin homonymy_N = mkN "homonímia" feminine ; --auto
lin homophone_N = mkN "homòfon" masculine ; --auto
lin homophony_N = mkN "homofonia" feminine ; --auto
lin homosexual_A = mkA "homosexual" ; --auto
lin homosexual_N = mkN "homosexual" ; --auto
lin homosexuality_N = mkN "homosexualitat" feminine ; --auto
lin homozygote_N = mkN "homozigot" masculine ; --auto
lin honduran_A = mkA "hondureny" ; --auto
lin honduran_N = mkN "hondureny" | mkN "hondureny" ; --auto
lin honest_A = mkA "sincer" ; --auto
lin honesty_N = mkN "honradesa" feminine ; --auto
lin honey_N = mkN "mel" feminine ; --auto
lin honeymoon_N = mkN "lluna de mel" feminine ; --auto
lin honor_N = mkN "honor" masculine ; --auto
lin honour_N = mkN "honor" masculine | mkN "honra" feminine ; --auto
lin honour_V2 = mkV2 "honrar" ; --auto
lin honourable_A = mkA "honorable" ; --auto
lin hood_N = mkN "capot" masculine ; --auto
lin hook_N = mkN "ganxo" masculine | mkN "ham" masculine ; --auto
lin hooligan_N = mkN "fanàtic" ; --auto
lin hoop_N = mkN "congreny" masculine ; --auto
lin hoopoe_N = mkN "puput" masculine ; --auto
lin hope_N = mkN "esperança" feminine ;
lin hope_V = mkV "esperar" ;
lin hope_VS = L.hope_VS ;
lin hope_VV = mkVV (mkV "esperar") ;
lin hopeful_A = mkA "esperançador" ; --auto
lin hopeless_A = mkA "desesperat" ; --auto
lin hopper_N = mkN "tremuja" feminine ; --auto
lin horizon_N = mkN "horitzó" masculine ; --auto
lin horizontal_A = mkA "horitzontal" ; --auto
lin horizontal_N = mkN "horitzontal" feminine ; --auto
lin hormone_N = mkN "hormona" feminine ; --auto
lin horn_N = L.horn_N ;
lin hornblende_N = mkN "hornblenda" feminine ; --auto
lin horned_A = mkA "banyut" ; --auto
lin horoscope_N = mkN "horòscop" masculine ; --auto
lin horrible_A = mkA "horrible" ; --auto
lin horrify_V2 = mkV2 "horroritzar" ; --auto
lin horror_N = mkN "horror" masculine ; --auto
lin horse_N = L.horse_N ;
lin horseshoe_N = mkN "ferradura" feminine ; --auto
lin horticultural_A = mkA "hortícola" ; --auto
lin horticulture_N = mkN "horticultura" feminine ; --auto
lin horticulturist_N = mkN "horticultor" | mkN "horticultor" ; --auto
lin hose_N = mkN "mànega" feminine ; --auto
lin hospice_N = mkN "hospici" masculine ; --auto
lin hospitable_A = mkA "hospitalari" ; --auto
lin hospital_N = mkN "hospital" masculine ;
lin hospitality_N = mkN "hospitalitat" feminine ; --auto
lin host_N = mkN "amfitrió" feminine | mkN "amfitrió" masculine ; --auto
lin hostage_N = mkN "ostatge" ; --auto
lin hostel_N = mkN "alberg" masculine ; --auto
lin hostess_N = mkN "hoste" feminine ; --auto
lin hostile_A = mkA "hostil" ; --auto
lin hostility_N = mkN "hostilitat" feminine ; --auto
lin hot_A = L.hot_A ;
lin hotel_N = mkN "hotel" masculine ;
lin hour_N = mkN "hora" feminine ;
lin house_N = L.house_N ;
lin house_V2 = mkV2 "albergar" ; --auto
lin housecoat_N = mkN "bata" feminine ; --auto
lin household_N = mkN "casa" feminine ; --auto
lin housing_N = mkN "allotjament" masculine | mkN "carcassa" feminine ; --auto
lin hover_V = mkV "voltar" ; --auto
lin hovercraft_N = mkN "aerolliscador" masculine ; --auto
lin how_IAdv = mkAdv "com" ; --auto
lin however_Adv = mkAdv "tot i això" | mkAdv "això no obstant" ;
lin howitzer_N = mkN "obús" masculine ; --auto
lin howl_N = mkN "udol" masculine ; --auto
lin huge_A = mkA "immens" ;
lin hugely_Adv = mkAdv "molt" ; --auto
lin human_A = mkA "humà" ;
lin human_N = mkN "ésser humà" masculine ; --auto
lin humanism_N = mkN "humanisme" masculine ; --auto
lin humanist_N = mkN "humanista" ; --auto
lin humanistic_A = mkA "humanístic" ; --auto
lin humanitarian_A = mkA "humanitari" ; --auto
lin humble_A = mkA "humil" ; --auto
lin humerus_N = mkN "húmer" masculine ; --auto
lin humic_A = mkA "húmic" ; --auto
lin humid_A = mkA "humit" ; --auto
lin humidity_N = mkN "humitat" feminine ; --auto
lin humification_N = mkN "humificació" feminine ; --auto
lin humiliate_V2 = mkV2 "humiliar" ; --auto
lin humiliation_N = mkN "humiliació" feminine ; --auto
lin humility_N = mkN "humilitat" feminine ; --auto
lin humin_N = mkN "humina" feminine ; --auto
lin humor_N = mkN "humor" masculine ; --auto
lin humoral_A = mkA "humoral" ; --auto
lin humorist_N = mkN "humorista" ; --auto
lin humorous_A = mkA "humorístic" ; --auto
lin humour_N = mkN "humor" masculine ; --auto
lin hump_N = mkN "monticle" masculine ; --auto
lin humus_N = mkN "humus" masculine | mkN "humus" masculine ; --auto
lin hungarian_A = mkA "hongarès" ; --auto
lin hungry_A = mkA "afamat" ; --auto
lin hunt_V = variants {} ; -- L.hunt_V2 ;
lin hunt_V2 = L.hunt_V2 ;
lin hunter_N = mkN "caçador" | mkN "caçador" ; --auto
lin hunting_N = mkN "caça" feminine | mkN "cacera" feminine ; --auto
lin hurricane_N = mkN "huracà" masculine ; --auto
lin hurry_N = mkN "pressa" feminine ; --auto
lin hurry_V = mkV "apressar-se" ; --auto
lin hurt_V = mkV "fer mal" ; --auto
lin hurtful_A = mkA "perjudicial" ; --auto
lin husband_N = L.husband_N ;
lin hussar_N = mkN "hússar" masculine ; --auto
lin hut_N = mkN "cabana" feminine ; --auto
lin hyacinth_N = mkN "jacint" masculine ; --auto
lin hyaloplasm_N = mkN "hialoplasma" masculine ; --auto
lin hybrid_A = mkA "híbrid" ; --auto
lin hybrid_N = mkN "híbrid" masculine ; --auto
lin hybridoma_N = mkN "hibridoma" masculine ; --auto
lin hydrant_N = mkN "hidrant" masculine ; --auto
lin hydrarthrosis_N = mkN "hidrartrosi" feminine ; --auto
lin hydrate_N = mkN "hidrat" masculine ; --auto
lin hydraulic_A = mkA "hidràulic" ; --auto
lin hydraulics_N = mkN "hidràulica" feminine ; --auto
lin hydrazine_N = mkN "hidrazina" feminine ; --auto
lin hydride_N = mkN "hidrur" masculine ; --auto
lin hydrocarbon_N = mkN "hidrocarbur" masculine ; --auto
lin hydrocephalus_N = mkN "hidrocefàlia" feminine ; --auto
lin hydrocracking_N = mkN "hidrocraqueig" masculine ; --auto
lin hydrodynamic_A = mkA "hidrodinàmic" ; --auto
lin hydrodynamics_N = mkN "hidrodinàmica" feminine ; --auto
lin hydroelectric_A = mkA "hidroelèctric" ; --auto
lin hydrogen_N = mkN "hidrogen" masculine ; --auto
lin hydrogenation_N = mkN "hidrogenació" feminine ; --auto
lin hydrographic_A = mkA "hidrogràfic" ; --auto
lin hydrography_N = mkN "hidrografia" feminine ; --auto
lin hydrologist_N = mkN "hidròleg" feminine | mkN "hidròleg" masculine ; --auto
lin hydrology_N = mkN "hidrologia" feminine ; --auto
lin hydrolysis_N = mkN "hidròlisi" feminine ; --auto
lin hydrometer_N = mkN "hidròmetre" masculine ; --auto
lin hydronephrosis_N = mkN "hidronefrosi" feminine ; --auto
lin hydrophilic_A = mkA "hidròfil" ; --auto
lin hydrophobia_N = mkN "hidrofòbia" feminine ; --auto
lin hydrophobic_A = mkA "hidrofòbic" ; --auto
lin hydroplane_N = mkN "hidroavió" masculine ; --auto
lin hydrostatic_A = mkA "hidrostàtic" ; --auto
lin hydrostatics_N = mkN "hidrostàtica" feminine ; --auto
lin hydroxide_N = mkN "hidròxid" masculine ; --auto
lin hyena_N = mkN "hiena" feminine ; --auto
lin hygiene_N = mkN "higiene" feminine ; --auto
lin hygienic_A = mkA "higiènic" ; --auto
lin hygrometer_N = mkN "higròmetre" masculine ; --auto
lin hygrophyte_N = mkN "higròfit" masculine ; --auto
lin hygroscope_N = mkN "higroscopi" masculine ; --auto
lin hygroscopic_A = mkA "higroscòpic" ; --auto
lin hymen_N = mkN "himen" masculine ; --auto
lin hymn_N = mkN "himne" masculine ; --auto
lin hyoid_N = mkN "hioide" masculine ; --auto
lin hyperbaton_N = mkN "hipèrbaton" masculine ; --auto
lin hyperbola_N = mkN "hipèrbola" feminine ; --auto
lin hyperbole_N = mkN "hipèrbole" masculine ; --auto
lin hyperbolic_A = mkA "hiperbòlic" ; --auto
lin hyperboloid_N = mkN "hiperboloide" masculine ; --auto
lin hypercapnia_N = mkN "hipercàpnia" feminine ; --auto
lin hyperemesis_N = mkN "hiperèmesi" feminine ; --auto
lin hyperemia_N = mkN "hiperèmia" feminine ; --auto
lin hyperfine_A = mkA "hiperfi" ; --auto
lin hyperhidrosis_N = mkN "hiperhidrosi" feminine ; --auto
lin hypermarket_N = mkN "hipermercat" masculine ; --auto
lin hypermedia_N = mkN "hipermèdia" feminine ; --auto
lin hyperon_N = mkN "hiperó" masculine ; --auto
lin hyperparathyroidism_N = mkN "hiperparatiroïdisme" masculine ; --auto
lin hyperplasia_N = mkN "hiperplàsia" feminine ; --auto
lin hyperpnea_N = mkN "hiperpnea" feminine ; --auto
lin hyperpyrexia_N = mkN "hiperpirèxia" feminine ; --auto
lin hypersplenism_N = mkN "hipersplenisme" masculine ; --auto
lin hyperthermia_N = mkN "hipertèrmia" feminine ; --auto
lin hyperthyroidism_N = mkN "hipertiroïdisme" masculine ; --auto
lin hypervitaminosis_N = mkN "hipervitaminosi" feminine ; --auto
lin hypha_N = mkN "hifa" feminine ; --auto
lin hyphen_N = mkN "guionet" masculine | mkN "guió" masculine ; --auto
lin hypnoanalysis_N = mkN "hipnoanàlisi" feminine ; --auto
lin hypnosis_N = mkN "hipnosi" feminine ; --auto
lin hypnotherapy_N = mkN "hipnoteràpia" feminine ; --auto
lin hypnotic_A = mkA "hipnòtic" ; --auto
lin hypochondria_N = mkN "hipocondria" feminine ; --auto
lin hypochondrium_N = mkN "hipocondri" masculine ; --auto
lin hypocrisy_N = mkN "hipocresia" feminine ; --auto
lin hyponym_N = mkN "hipònim" masculine ; --auto
lin hyponymy_N = mkN "hiponímia" feminine ; --auto
lin hypoparathyroidism_N = mkN "hipoparatiroïdisme" masculine ; --auto
lin hypoplasia_N = mkN "hipoplàsia" feminine ; --auto
lin hypostasis_N = mkN "hipòstasi" feminine ; --auto
lin hypotension_N = mkN "hipotensió" feminine ; --auto
lin hypotenuse_N = mkN "hipotenusa" feminine ; --auto
lin hypothalamus_N = mkN "hipotàlem" masculine ; --auto
lin hypothermia_N = mkN "hipotèrmia" feminine ; --auto
lin hypothesis_N = mkN "hipòtesi" feminine ; --auto
lin hypothetical_A = mkA "hipotètic" ; --auto
lin hypothyroidism_N = mkN "hipotiroïdisme" masculine ; --auto
lin hypovolemia_N = mkN "hipovolèmia" feminine ; --auto
lin hypoxia_N = mkN "hipòxia" feminine ; --auto
lin hypsography_N = mkN "hipsografia" feminine ; --auto
lin hypsometer_N = mkN "hipsòmetre" masculine ; --auto
lin hypsometry_N = mkN "hipsometria" feminine ; --auto
lin hyssop_N = mkN "hisop" masculine ; --auto
lin hysteresis_N = mkN "histèresi" feminine ; --auto
lin hysteria_N = mkN "histèria" feminine ; --auto
lin iFem_Pron = optProDrop E.i8fem_Pron ;
lin i_Pron = optProDrop S.i_Pron ;
lin iamb_N = mkN "iambe" masculine ; --auto
lin ibidem_Adv = mkAdv "ibídem" ; --auto
lin ibuprofen_N = mkN "ibuprofén" masculine ; --auto
lin ice_N = L.ice_N ;
lin ice_cream_N = mkN "gelat" masculine ; --auto
lin iceberg_N = mkN "iceberg" masculine ; --auto
lin icebreaker_N = mkN "trencaglaç" masculine ; --auto
lin icelandic_A = mkA "islandès" ; --auto
lin icelandic_N = mkN "islandès" | mkN "islandès" ; --auto
lin ichthyologist_N = mkN "ictiòleg" feminine | mkN "ictiòleg" masculine ; --auto
lin ichthyology_N = mkN "ictiologia" feminine ; --auto
lin ichthyosis_N = mkN "ictiosi" feminine ; --auto
lin icon_N = mkN "icona" feminine ; --auto
lin iconic_A = mkA "icònic" ; --auto
lin iconoscope_N = mkN "iconoscopi" masculine ; --auto
lin icosahedron_N = mkN "icosàedre" masculine ; --auto
lin idea_N = mkN "idea" feminine ;
lin ideal_A = mkA "ideal" ; --auto
lin ideal_N = mkN "ideal" masculine ; --auto
lin idealism_N = mkN "idealisme" masculine ; --auto
lin idealist_N = mkN "idealista" ; --auto
lin idealistic_A = mkA "idealista" ; --auto
lin ideality_N = mkN "idealitat" feminine ; --auto
lin ideally_Adv = mkAdv "idealment" ; --auto
lin ideation_N = mkN "ideació" feminine ; --auto
lin idempotent_A = mkA "idempotent" ; --auto
lin identical_A = mkA "idèntic" ; --auto
lin identifiable_A = mkA "identificable" ; --auto
lin identification_N = mkN "identificació" feminine ; --auto
lin identifier_N = mkN "identificador" masculine ; --auto
lin identify_V = mkV "identificar" ;
lin identify_V2 = mkV2 (mkV "identificar") ;
lin identity_N = mkN "identitat" feminine ; --auto
lin ideography_N = mkN "ideografia" feminine ; --auto
lin ideological_A = mkA "ideològic" ; --auto
lin ideologist_N = mkN "ideòleg" | mkN "ideòleg" ; --auto
lin ideology_N = mkN "ideologia" feminine ; --auto
lin idiographic_A = mkA "idiogràfic" ; --auto
lin idiolect_N = mkN "idiolecte" masculine ; --auto
lin idiom_N = mkN "modisme" masculine ; --auto
lin idiomatic_A = mkA "idiomàtic" ; --auto
lin idiosyncrasy_N = mkN "idiosincràsia" feminine ; --auto
lin idiosyncratic_A = mkA "idiosincràtic" ; --auto
lin idiot_N = mkN "idiota" ; --auto
lin idol_N = mkN "ídol" masculine ; --auto
lin idyll_N = mkN "idil·li" masculine ; --auto
lin if_Subj = S.if_Subj ;
lin ignite_V = mkV "incendiar" ; --auto
lin ignite_V2 = mkV2 "incendiar" ; --auto
lin ignominious_A = mkA "ignominiós" ; --auto
lin ignominy_N = mkN "ignomínia" feminine ; --auto
lin ignorance_N = mkN "ignorància" feminine ; --auto
lin ignorant_A = mkA "ignorant" ; --auto
lin ignore_V = mkV "ignorar" ;
lin ignore_V2 = mkV2 (mkV "ignorar") ;
lin ileum_N = mkN "ili" masculine ; --auto
lin ill_1_A = mkA "malalt" ;
lin ill_2_A = mkA "malalt" ;
lin illegal_A = mkA "il·legal" ; --auto
lin illegality_N = mkN "il·legalitat" feminine ; --auto
lin illegitimacy_N = mkN "il·legitimitat" feminine ; --auto
lin illegitimate_A = mkA "il·legítim" ; --auto
lin illicit_A = mkA "il·lícit" ; --auto
lin illiteracy_N = mkN "analfabetisme" masculine ; --auto
lin illiterate_A = mkA "analfabet" ; --auto
lin illiterate_N = mkN "analfabet" | mkN "analfabet" ; --auto
lin illness_N = mkN "malaltia" feminine ; --auto
lin illogical_A = mkA "il·lògic" ; --auto
lin illumination_N = mkN "il·luminació" feminine ; --auto
lin illusion_N = mkN "il·lusió" feminine ; --auto
lin illustrate_V = mkV "il·lustrar" ; --auto
lin illustrate_V2 = mkV2 "il·lustrar" ; --auto
lin illustration_N = mkN "il·lustració" feminine ; --auto
lin illustrator_N = mkN "il·lustrador" | mkN "il·lustrador" ; --auto
lin image_N = mkN "imatge" feminine ;
lin imagery_N = mkN "imatgeria" feminine ; --auto
lin imaginary_A = mkA "imaginari" ; --auto
lin imagination_N = mkN "imaginació" feminine ; --auto
lin imaginative_A = mkA "imaginatiu" ; --auto
lin imagine_V = mkV "imaginar" ;
lin imagine_V2 = mkV2 (mkV "imaginar") ;
lin imagine_VS = mkVS (mkV "imaginar") ;
lin imbecile_N = mkN "imbècil" ; --auto
lin imbecility_N = mkN "imbecil·litat" feminine ; --auto
lin imitate_V2 = mkV2 "imitar" ; --auto
lin imitation_N = mkN "imitació" feminine ; --auto
lin immanence_N = mkN "immanència" feminine ; --auto
lin immaterial_A = mkA "immaterial" ; --auto
lin immature_A = mkA "immadur" ; --auto
lin immaturity_N = mkN "immaduresa" feminine ; --auto
lin immediate_A = mkA "immediat" ; --auto
lin immemorial_A = mkA "immemorial" ; --auto
lin immense_A = mkA "immens" ; --auto
lin immersion_N = mkN "immersió" feminine ; --auto
lin immigrant_N = mkN "immigrant" ; --auto
lin immigrate_V = mkV "immigrar" ; --auto
lin immigration_N = mkN "immigració" feminine ; --auto
lin imminent_A = mkA "imminent" ; --auto
lin immoderate_A = mkA "desmesurat" ; --auto
lin immoral_A = mkA "immoral" ; --auto
lin immorality_N = mkN "immoralitat" feminine ; --auto
lin immortal_A = mkA "immortal" ; --auto
lin immortality_N = mkN "immortalitat" feminine ; --auto
lin immovable_A = mkA "immoble" | mkA "inamovible" ; --auto
lin immune_A = mkA "immune" ; --auto
lin immunity_N = mkN "immunitat" feminine ; --auto
lin immunoassay_N = mkN "immunoassaig" masculine ; --auto
lin immunodeficiency_N = mkN "immunodeficiència" feminine ; --auto
lin immunoelectrophoresis_N = mkN "immunoelectroforesi" feminine ; --auto
lin immunofluorescence_N = mkN "immunofluorescència" feminine ; --auto
lin immunogenicity_N = mkN "immunogenicitat" feminine ; --auto
lin immunoglobulin_N = mkN "immunoglobulina" feminine ; --auto
lin immunological_A = mkA "immunològic" ; --auto
lin immunologist_N = mkN "immunòleg" feminine | mkN "immunòleg" masculine ; --auto
lin immunology_N = mkN "immunologia" feminine ; --auto
lin immunosuppression_N = mkN "immunosupressió" feminine ; --auto
lin immunotherapy_N = mkN "immunoteràpia" feminine ; --auto
lin immutable_A = mkA "immutable" ; --auto
lin impact_N = mkN "impacte" masculine ;
lin impairment_N = mkN "empitjorament" masculine ; --auto
lin impartial_A = mkA "imparcial" ; --auto
lin impartiality_N = mkN "imparcialitat" feminine ; --auto
lin impassable_A = mkA "impracticable" ; --auto
lin impasse_N = mkN "impasse" masculine ; --auto
lin impassioned_A = mkA "apassionat" ; --auto
lin impatience_N = mkN "impaciència" feminine ; --auto
lin impatient_A = mkA "impacient" ; --auto
lin impedance_N = mkN "impedància" feminine ; --auto
lin impenetrable_A = mkA "impenetrable" ; --auto
lin imperative_A = mkA "imperatiu" ; --auto
lin imperceptible_A = mkA "imperceptible" ; --auto
lin imperfect_A = mkA "imperfecte" ; --auto
lin imperfection_N = mkN "imperfecció" feminine ; --auto
lin imperial_A = mkA "imperial" ; --auto
lin imperialism_N = mkN "imperialisme" masculine ; --auto
lin impermeability_N = mkN "impermeabilitat" feminine ; --auto
lin impermeable_A = mkA "impermeable" ; --auto
lin impersonal_A = mkA "impersonal" ; --auto
lin impertinence_N = mkN "impertinència" feminine ; --auto
lin impetuosity_N = mkN "impetuositat" feminine ; --auto
lin impetuous_A = mkA "impetuós" ; --auto
lin impetus_N = mkN "ímpetu" masculine ; --auto
lin implant_N = mkN "implant" masculine ; --auto
lin implant_V2 = mkV2 "implantar" ; --auto
lin implantation_N = mkN "implantació" feminine ; --auto
lin implement_V2 = mkV2 "implementar" ; --auto
lin implementation_N = mkN "implementació" feminine ; --auto
lin implication_N = mkN "implicació" feminine ; --auto
lin implicit_A = mkA "implícit" ; --auto
lin implosion_N = mkN "implosió" feminine ; --auto
lin imply_V = mkV "implicar" ; --auto
lin imply_V2 = mkV2 "implicar" ; --auto
lin impolite_A = mkA "descortès" ; --auto
lin import_N = mkN "importació" feminine ; --auto
lin import_V2 = mkV2 "importar" ; --auto
lin importance_N = mkN "importància" feminine ;
lin important_A = L.important_A ;
lin importerFem_N = variants {} ; ---- sense to be split
lin importerMasc_N = variants {} ; ---- sense to be split
lin impose_V = mkV "imposar" ; --auto
lin impose_V2 = mkV2 "imposar" ; --auto
lin impossibility_N = mkN "impossibilitat" feminine ; --auto
lin impossible_A = mkA "impossible" ;
lin impostor_N = mkN "impostor" | mkN "impostor" ; --auto
lin impotence_N = mkN "impotència" feminine ; --auto
lin impotent_A = mkA "impotent" ; --auto
lin impound_V2 = mkV2 "embargar" ; --auto
lin impoverish_V2 = mkV2 "empobrir" ; --auto
lin impoverishment_N = mkN "empobriment" masculine ; --auto
lin impractical_A = mkA "inconvenient" ; --auto
lin imprecation_N = mkN "imprecació" feminine ; --auto
lin imprecise_A = mkA "imprecís" ; --auto
lin imprecision_N = mkN "imprecisió" feminine ; --auto
lin impregnate_V2 = mkV2 "impregnar" ; --auto
lin impress_V = mkV "impressionar" ; --auto
lin impress_V2 = mkV2 "impressionar" ; --auto
lin impression_N = mkN "impressió" feminine ; --auto
lin impressionable_A = mkA "impressionable" ; --auto
lin impressionism_N = mkN "impressionisme" masculine ; --auto
lin impressionist_A = mkA "impressionista" ; --auto
lin impressionist_N = mkN "impressionista" ; --auto
lin impressionistic_A = mkA "impressionista" ; --auto
lin impressive_A = mkA "impressionant" ; --auto
lin imprison_V2 = mkV2 "empresonar" ; --auto
lin imprisonment_N = mkN "empresonament" masculine ; --auto
lin improbable_A = mkA "improbable" ; --auto
lin improper_A = mkA "impropi" ; --auto
lin impropriety_N = mkN "impropietat" feminine ; --auto
lin improve_V = mkV "millorar" ;
lin improve_V2 = mkV2 (mkV "millorar") ;
lin improvement_N = mkN "millora" feminine ;
lin improvisation_N = mkN "improvisació" feminine ; --auto
lin improvise_V = mkV "improvisar" ; --auto
lin improvise_V2 = mkV2 "improvisar" ; --auto
lin imprudent_A = mkA "imprudent" ; --auto
lin impugn_V2 = mkV2 "impugnar" ; --auto
lin impugnable_A = mkA "impugnable" ; --auto
lin impulse_N = mkN "impuls" masculine ; --auto
lin impulsive_A = mkA "impulsiu" ; --auto
lin impunity_N = mkN "impunitat" feminine ; --auto
lin impure_A = mkA "impur" ; --auto
lin impurity_N = mkN "impuresa" feminine ; --auto
lin impute_V2 = mkV2 "imputar" ; --auto
lin in_1_Adv = mkAdv "dins" ;
lin in_2_Adv = mkAdv "dins" ;
lin in_Prep = S.in_Prep ;
lin in_accordance_with_Prep = mkPrep "d'acord amb" ; --auto
lin in_addition_Adv = mkAdv "a més a més" ; --auto
lin in_addition_to_Prep = mkPrep "a més a més de" | mkPrep "a més de" ; --auto
lin in_front_of_Prep = mkPrep "davant de" | mkPrep "davant" ; --auto
lin in_general_Adv = mkAdv "en general" ; --auto
lin in_order_to_Prep = mkPrep "per tal de" ; --auto
lin in_particular_Adv = mkAdv "en particular" ; --auto
lin in_situ_Adv = mkAdv "in situ" ; --auto
lin in_spite_of_Prep = mkPrep "malgrat" ; --auto
lin inability_N = mkN "incapacitat" feminine ; --auto
lin inaccessibility_N = mkN "inaccessibilitat" feminine ; --auto
lin inaccessible_A = mkA "inaccessible" ; --auto
lin inaccuracy_N = mkN "inexactitud" feminine ; --auto
lin inaccurate_A = mkA "inexacte" ; --auto
lin inaction_N = mkN "inacció" feminine ; --auto
lin inadequate_A = mkA "inadequat" ; --auto
lin inadmissibility_N = mkN "improcedència" feminine ; --auto
lin inadmissible_A = mkA "inadmissible" ; --auto
lin inalienable_A = mkA "inalienable" ; --auto
lin inapplicable_A = mkA "inaplicable" ; --auto
lin inappropriate_A = mkA "inadequat" ; --auto
lin inarticulate_A = mkA "inarticulat" ; --auto
lin inaudible_A = mkA "inaudible" ; --auto
lin inaugurate_V2 = mkV2 "inaugurar" ; --auto
lin inauguration_N = mkN "inauguració" feminine ; --auto
lin incalculable_A = mkA "incalculable" ; --auto
lin incandescence_N = mkN "incandescència" feminine ; --auto
lin incapable_A = mkA "incapaç" ; --auto
lin incapacitate_V2 = mkV2 "incapacitar" ; --auto
lin incendiary_A = mkA "incendiari" ; --auto
lin incense_N = mkN "encens" masculine ; --auto
lin incentive_N = mkN "incentiu" masculine ; --auto
lin incessant_A = mkA "incessant" ; --auto
lin incest_N = mkN "incest" masculine ; --auto
lin incestuous_A = mkA "incestuós" ; --auto
lin inch_N = mkN "polzada" feminine ; --auto
lin incidence_N = mkN "incidència" feminine ; --auto
lin incident_N = mkN "incident" masculine ; --auto
lin incidental_A = mkA "incidental" ; --auto
lin incinerate_V2 = mkV2 "incinerar" ; --auto
lin incineration_N = mkN "incineració" feminine ; --auto
lin incision_N = mkN "incisió" feminine ; --auto
lin incisive_A = mkA "incisiu" ; --auto
lin incisor_N = mkN "incisiu" masculine ; --auto
lin incite_V2 = mkV2 "incitar" ; --auto
lin inclement_A = mkA "inclement" ; --auto
lin inclination_N = mkN "inclinació" feminine ; --auto
lin incline_V = mkV "inclinar" ; --auto
lin incline_V2 = mkV2 "inclinar" ; --auto
lin include_V = verbV (complaure_24 "incloure") ;
lin include_V2 = mkV2 (verbV (complaure_24 "incloure")) ;
lin including_Prep = mkPrep "incloent-hi" ; --auto
lin inclusion_N = mkN "inclusió" feminine ; --auto
lin inclusive_A = mkA "inclòs" ; --auto
lin incognito_Adv = mkAdv "d'incògnit" ; --auto
lin incoherent_A = mkA "incoherent" ; --auto
lin income_N = mkN "ingressos" masculine ;
lin incommensurable_A = mkA "incommensurable" ; --auto
lin incommutable_A = mkA "incommutable" ; --auto
lin incomparable_A = mkA "incomparable" ; --auto
lin incompatibility_N = mkN "incompatibilitat" feminine ; --auto
lin incompatible_A = mkA "incompatible" ; --auto
lin incompetence_N = mkN "incompetència" feminine ; --auto
lin incompetent_A = mkA "incompetent" ; --auto
lin incomplete_A = mkA "incomplet" ; --auto
lin incompleteness_N = mkN "incompletud" feminine ; --auto
lin incomprehensible_A = mkA "incomprensible" ; --auto
lin inconceivable_A = mkA "inconcebible" ; --auto
lin incongruous_A = mkA "incongruent" ; --auto
lin inconsequential_A = mkA "intranscendent" ; --auto
lin inconsiderate_A = mkA "desconsiderat" ; --auto
lin incontestable_A = mkA "incontestable" ; --auto
lin incontinence_N = mkN "incontinència" feminine ; --auto
lin incontrovertible_A = mkA "incontrovertible" ; --auto
lin inconvenience_N = mkN "inconveniència" feminine ; --auto
lin inconvenient_A = mkA "inconvenient" ; --auto
lin inconvertible_A = mkA "inconvertible" ; --auto
lin incorporate_V2 = mkV2 "incorporar" ; --auto
lin incorporation_N = mkN "incorporació" feminine ; --auto
lin increase_N = mkN "augment" masculine ;
lin increase_V = mkV "augmentar" | mkV "incrementar" ;
lin increase_V2 = mkV2 (mkV "augmentar") | mkV2 (mkV "incrementar") ;
lin increasing_A = mkA "creixent" ; --auto
lin increasingly_AdA = mkAdv "cada cop més" | mkAdv "cada vegada més" ; --auto
lin increasingly_AdV = mkAdv "cada cop més" | mkAdv "cada vegada més" ; --auto
lin increasingly_Adv = mkAdv "cada cop més" ;
lin incredible_A = mkA "increïble" ; --auto
lin incremental_A = mkA "incremental" ; --auto
lin incriminate_V2 = mkV2 "incriminar" ; --auto
lin incubation_N = mkN "incubació" feminine ; --auto
lin incubator_N = mkN "incubadora" feminine ; --auto
lin incumbent_A = mkA "incumbent" ; --auto
lin incurable_A = mkA "incurable" ; --auto
lin incursion_N = mkN "incursió" feminine ; --auto
lin indebtedness_N = mkN "endeutament" masculine ; --auto
lin indecent_A = mkA "indecent" ; --auto
lin indeed_AdV = mkAdv "de fet" ; --auto
lin indeed_Adv = mkAdv "certament" ;
lin indefensible_A = mkA "indefensable" ; --auto
lin indefinite_A = mkA "indefinit" ; --auto
lin indemnify_V2 = mkV2 "indemnitzar" ; --auto
lin indentation_N = mkN "sagnia" feminine ; --auto
lin independence_N = mkN "independència" feminine ; --auto
lin independent_1_A = mkA "independent" ;
lin independent_2_A = mkA "independent" ;
lin indeterminable_A = mkA "indeterminable" ; --auto
lin indeterminate_A = mkA "indeterminat" ; --auto
lin index_N = mkN "índex" masculine ; --auto
lin indexing_N = mkN "indexació" feminine ; --auto
lin indianFem_1_N = variants {} ; ---- sense to be split
lin indianFem_2_N = variants {} ; ---- sense to be split
lin indianMasc_1_N = variants {} ; ---- sense to be split
lin indianMasc_2_N = variants {} ; ---- sense to be split
lin indian_A = mkA "indi" ; --auto
lin indicate_V2 = mkV2 (mkV "indicar") ;
lin indicate_VS = mkVS (mkV "indicar") ;
lin indication_N = mkN "indicació" feminine ; --auto
lin indicator_N = mkN "indicador" masculine ; --auto
lin indictment_N = mkN "acusació" feminine ; --auto
lin indifference_N = mkN "indiferència" feminine ; --auto
lin indifferent_A = mkA "indiferent" ; --auto
lin indigestible_A = mkA "indigerible" ; --auto
lin indigestion_N = mkN "indigestió" feminine ; --auto
lin indignation_N = mkN "indignació" feminine ; --auto
lin indignity_N = mkN "indignitat" feminine ; --auto
lin indirect_A = mkA "indirecte" ; --auto
lin indiscernible_A = mkA "indiscernible" ; --auto
lin indiscipline_N = mkN "indisciplina" feminine ; --auto
lin indiscretion_N = mkN "indiscreció" feminine ; --auto
lin indispensable_A = mkA "imprescindible" | mkA "indispensable" ; --auto
lin indisposition_N = mkN "indisposició" feminine ; --auto
lin indisputability_N = mkN "indisputabilitat" feminine ; --auto
lin indisputable_A = mkA "indiscutible" ; --auto
lin individual_A = mkA "individual" ;
lin individual_N = mkN "individu" masculine ;
lin individualism_N = mkN "individualisme" masculine ; --auto
lin individuality_N = mkN "individualitat" feminine ; --auto
lin indivisible_A = mkA "indivisible" ; --auto
lin indoctrination_N = mkN "adoctrinament" masculine ; --auto
lin indonesian_A = mkA "indonesi" ; --auto
lin indoor_A = mkA "interior" ; --auto
lin indoors_Adv = mkAdv "a dins" ; --auto
lin induce_V2 = mkV2 "induir" ; --auto
lin inducement_N = mkN "al·licient" masculine ; --auto
lin induction_N = mkN "inducció" feminine ; --auto
lin indulgence_N = mkN "indulgència" feminine ; --auto
lin indulgent_A = mkA "indulgent" ; --auto
lin industrial_A = mkA "industrial" ;
lin industrious_A = mkA "treballador" ; --auto
lin industry_N = L.industry_N ;
lin ineffective_A = mkA "ineficaç" ; --auto
lin ineligibility_N = mkN "inelegibilitat" feminine ; --auto
lin ineligible_A = mkA "inelegible" ; --auto
lin inept_A = mkA "inepte" ; --auto
lin ineptitude_N = mkN "ineptitud" feminine ; --auto
lin inequality_N = mkN "desigualtat" feminine ; --auto
lin inequity_N = mkN "injustícia" feminine ; --auto
lin inert_A = mkA "inert" ; --auto
lin inertia_N = mkN "inèrcia" feminine ; --auto
lin inertial_A = mkA "inercial" ; --auto
lin inevitability_N = mkN "inevitabilitat" feminine ; --auto
lin inevitable_A = mkA "inevitable" ; --auto
lin inexorable_A = mkA "inexorable" ; --auto
lin inexpensive_A = mkA "econòmic" ; --auto
lin inexperienced_A = mkA "inexpert" ; --auto
lin infamy_N = mkN "infàmia" feminine ; --auto
lin infancy_N = mkN "infància" feminine ; --auto
lin infant_N = mkN "infant" masculine ; --auto
lin infanticide_N = mkN "infanticidi" masculine ; --auto
lin infantry_N = mkN "infanteria" feminine ; --auto
lin infarct_N = mkN "infart" masculine ; --auto
lin infect_V = mkV "infectar" ; --auto
lin infect_V2 = mkV2 "infectar" ; --auto
lin infection_N = mkN "infecció" feminine ; --auto
lin infectious_A = mkA "contagiós" ; --auto
lin infer_V2 = mkV2 "inferir" ; --auto
lin inference_N = mkN "inferència" feminine ; --auto
lin inferior_A = mkA "inferior" ; --auto
lin inferiority_N = mkN "inferioritat" feminine ; --auto
lin infertility_N = mkN "infertilitat" feminine ; --auto
lin infest_V2 = mkV2 "infestar" ; --auto
lin infidelity_N = mkN "infidelitat" feminine ; --auto
lin infiltrate_V = mkV "infiltrar-se" ; --auto
lin infiltration_N = mkN "infiltració" feminine ; --auto
lin infinite_A = mkA "infinit" ; --auto
lin infinitesimal_A = mkA "infinitèsim" | mkA "infinitesimal" ; --auto
lin infinitive_N = mkN "infinitiu" masculine ; --auto
lin infinity_N = mkN "infinitat" feminine ; --auto
lin infirmary_N = mkN "infermeria" feminine ; --auto
lin infix_N = mkN "infix" masculine ; --auto
lin inflammable_A = mkA "inflamable" ; --auto
lin inflammation_N = mkN "inflamació" feminine ; --auto
lin inflatable_A = mkA "inflable" ; --auto
lin inflate_V = mkV "inflar" | mkV "unflar" ; --auto
lin inflate_V2 = mkV2 "inflar" | mkV2 "unflar" ; --auto
lin inflation_N = mkN "inflació" feminine ; --auto
lin inflationary_A = mkA "inflacionista" ; --auto
lin inflection_N = mkN "inflexió" feminine ; --auto
lin inflectional_A = mkA "inflexional" ; --auto
lin inflict_V2 = mkV2 "infligir" ; --auto
lin inflorescence_N = mkN "inflorescència" feminine ; --auto
lin influence_N = mkN "influència" feminine ;
lin influence_V2 = mkV2 "influir" ; --auto
lin influential_A = mkA "influent" ; --auto
lin influenza_N = mkN "grip" feminine ; --auto
lin influx_N = mkN "afluència" feminine ; --auto
lin infomercial_N = mkN "publireportatge" masculine ; --auto
lin inform_V = mkV "informar" ; --auto
lin inform_V2 = mkV2 "informar" ; --auto
lin informal_A = mkA "informal" ; --auto
lin information_N = mkN "informació" feminine ;
lin informational_A = mkA "informatiu" ; --auto
lin informative_A = mkA "informatiu" ; --auto
lin infraction_N = mkN "infracció" feminine ; --auto
lin infra_red_A = mkA "infraroig" ; --auto
lin infrastructure_N = mkN "infraestructura" feminine ; --auto
lin infrequent_A = mkA "infreqüent" ; --auto
lin infringement_N = mkN "contravenció" feminine ; --auto
lin infructescence_N = mkN "infructescència" feminine ; --auto
lin infundibulum_N = mkN "infundíbul" masculine ; --auto
lin infusion_N = mkN "infusió" feminine ; --auto
lin ingenious_A = mkA "ingeniós" ; --auto
lin ingot_N = mkN "lingot" masculine ; --auto
lin ingratitude_N = mkN "ingratitud" feminine ; --auto
lin ingredient_N = mkN "ingredient" masculine ; --auto
lin inhabit_V2 = mkV2 "habitar" ; --auto
lin inhabitant_N = mkN "habitant" ; --auto
lin inhalation_N = mkN "inhalació" feminine ; --auto
lin inhale_V = mkV "inhalar" ; --auto
lin inhale_V2 = mkV2 "inhalar" ; --auto
lin inhaler_N = mkN "inhalador" masculine ; --auto
lin inherent_A = mkA "inherent" ; --auto
lin inherit_V = mkV "heretar" ; --auto
lin inherit_V2 = mkV2 "heretar" ; --auto
lin inheritable_A = mkA "heretable" ; --auto
lin inheritance_N = mkN "herència" feminine ; --auto
lin inheritorFem_N = variants {} ; ---- sense to be split
lin inheritorMasc_N = variants {} ; ---- sense to be split
lin inhibit_V2 = mkV2 "inhibir" ; --auto
lin inhibition_N = mkN "inhibició" feminine ; --auto
lin inhibitory_A = mkA "inhibitori" ; --auto
lin inhuman_A = mkA "inhumà" ; --auto
lin iniquity_N = mkN "iniquitat" feminine ; --auto
lin initial_A = mkA "inicial" ; --auto
lin initial_N = mkN "inicial" feminine ; --auto
lin initiate_V2 = mkV2 "iniciar" ; --auto
lin initiation_N = mkN "iniciació" feminine ; --auto
lin initiative_N = mkN "iniciativa" feminine ; --auto
lin inject_V2 = mkV2 "injectar" ; --auto
lin injection_N = mkN "injecció" feminine ; --auto
lin injector_N = mkN "injector" masculine ; --auto
lin injure_V2 = mkV2 "ferir" | mkV2 "lesionar" ; --auto
lin injurious_A = mkA "injuriós" ; --auto
lin injury_N = mkN "lesió" feminine ;
lin injustice_N = mkN "injustícia" feminine ; --auto
lin ink_N = mkN "tinta" feminine ; --auto
lin inlet_N = mkN "entrada" feminine ; --auto
lin inn_N = mkN "fonda" feminine ; --auto
lin innate_A = mkA "innat" ; --auto
lin inner_A = mkA "interior" ; --auto
lin innervation_N = mkN "innervació" feminine ; --auto
lin innocence_N = mkN "innocència" feminine ; --auto
lin innocent_A = mkA "innocent" ; --auto
lin innocuous_A = mkA "innocu" ; --auto
lin innovation_N = mkN "innovació" feminine ; --auto
lin innovative_A = mkA "innovador" ; --auto
lin innovator_N = mkN "innovador" feminine | mkN "innovador" masculine ; --auto
lin innumerable_A = mkA "innombrable" ; --auto
lin inoculate_V2 = mkV2 "inocular" ; --auto
lin inoculation_N = mkN "inoculació" feminine ; --auto
lin inoperable_A = mkA "inoperable" | mkA "inoperant" ; --auto
lin inorganic_A = mkA "inorgànic" ; --auto
lin input_N = mkN "entrada" feminine ; --auto
lin inquiry_N = mkN "consulta" feminine | mkN "investigació" feminine ; --auto
lin inquisition_N = mkN "inquisició" feminine ; --auto
lin inquisitor_N = mkN "inquisidor" | mkN "inquisidor" ; --auto
lin insane_A = mkA "dement" ; --auto
lin inscribe_V2 = mkV2 "inscriure" ; --auto
lin inscrutable_A = mkA "inescrutable" ; --auto
lin insect_N = mkN "insecte" masculine ; --auto
lin insecticide_N = mkN "insecticida" feminine ; --auto
lin insectivore_N = mkN "insectívor" masculine ; --auto
lin insectivorous_A = mkA "insectívor" ; --auto
lin insecurity_N = mkN "inseguretat" feminine ; --auto
lin inseminate_V2 = mkV2 "inseminar" ; --auto
lin insemination_N = mkN "inseminació" feminine ; --auto
lin insensitive_A = mkA "insensible" ; --auto
lin inseparable_A = mkA "inseparable" ; --auto
lin insert_V2 = mkV2 "inserir" ; --auto
lin insertion_N = mkN "inserció" feminine ; --auto
lin inside_Adv = mkAdv "dins" ; --auto
lin inside_N = mkN "interior" masculine ; --auto
lin inside_Prep = mkPrep "dins" ;
lin insidious_A = mkA "insidiós" ; --auto
lin insight_N = mkN "idea" feminine ; --auto
lin insignia_N = mkN "insígnia" feminine ; --auto
lin insignificant_A = mkA "insignificant" ; --auto
lin insinuate_V2 = mkV2 "insinuar" ; --auto
lin insinuation_N = mkN "insinuació" feminine ; --auto
lin insist_V = mkV (servir_101 "insistir") ;
lin insist_V2 = mkV2 (mkV (servir_101 "insistir")) (mkPrep "en") ;
lin insist_VS = mkVS (mkV (servir_101 "insistir")) ;
lin insistence_N = mkN "insistència" feminine ; --auto
lin insistent_A = mkA "insistent" ; --auto
lin insolence_N = mkN "insolència" feminine ; --auto
lin insolent_A = mkA "insolent" ; --auto
lin insoluble_A = mkA "insoluble" ; --auto
lin insolvency_N = mkN "insolvència" feminine ; --auto
lin insolvent_A = mkA "insolvent" ; --auto
lin inspect_V2 = mkV2 "inspeccionar" ; --auto
lin inspection_N = mkN "inspecció" feminine ; --auto
lin inspector_N = mkN "inspector" | mkN "inspector" ; --auto
lin inspiration_N = mkN "inspiració" feminine ; --auto
lin inspire_V2 = mkV2 "inspirar" ; --auto
lin install_V = mkV "instal·lar" ; --auto
lin install_V2 = mkV2 "instal·lar" ; --auto
lin installation_N = mkN "instal·lació" feminine ; --auto
lin instance_N = mkN "cas" masculine ;
lin instant_N = mkN "instant" masculine ; --auto
lin instantaneous_A = mkA "instantani" ; --auto
lin instead_Adv = mkAdv "en el seu lloc" ;
lin instead_of_Prep = mkPrep "en comptes de" ; --auto
lin instep_N = mkN "empenya" feminine ; --auto
lin instigation_N = mkN "instigació" feminine ; --auto
lin instigator_N = mkN "instigador" | mkN "instigador" ; --auto
lin instinct_N = mkN "instint" masculine ; --auto
lin institute_N = mkN "institut" masculine ; --auto
lin institution_N = mkN "instituació" feminine ;
lin institutional_A = mkA "institucional" ; --auto
lin instruct_V2 = mkV2 "instruir" ; --auto
lin instruction_N = mkN "instrucció" feminine ; --auto
lin instructor_N = mkN "instructor" | mkN "instructor" ; --auto
lin instrument_N = mkN "instrument" masculine ; --auto
lin instrumental_A = mkA "instrumental" ; --auto
lin instrumentalism_N = mkN "instrumentalisme" masculine ; --auto
lin instrumentalist_N = mkN "instrumentista" ; --auto
lin instrumentation_N = mkN "instrumentació" feminine ; --auto
lin insubordination_N = mkN "insubordinació" feminine ; --auto
lin insufficiency_N = mkN "insuficiència" feminine ; --auto
lin insufficient_A = mkA "insuficient" ; --auto
lin insular_A = mkA "insular" ; --auto
lin insulator_N = mkN "aïllant" masculine ; --auto
lin insulin_N = mkN "insulina" feminine ; --auto
lin insult_N = mkN "injúria" feminine | mkN "insult" masculine ; --auto
lin insulting_A = mkA "insultant" ; --auto
lin insurable_A = mkA "assegurable" ; --auto
lin insurance_N = mkN "assegurança" ;
lin insure_V = mkV "assegurar" ; --auto
lin insure_V2 = mkV2 "assegurar" ; --auto
lin insurgent_A = mkA "insurgent" ; --auto
lin insurrection_N = mkN "insurrecció" feminine ; --auto
lin intact_A = mkA "intacte" ; --auto
lin intangible_A = mkA "intangible" ; --auto
lin integer_N = mkN "enter" masculine ; --auto
lin integral_A = mkA "integral" ; --auto
lin integral_N = mkN "integral" feminine ; --auto
lin integrate_V = mkV "integrar" ; --auto
lin integrate_V2 = mkV2 "integrar" ; --auto
lin integrated_A = mkA "integrat" ; --auto
lin integration_N = mkN "integració" feminine ; --auto
lin integrator_N = mkN "integrador" masculine ; --auto
lin integrity_N = mkN "integritat" feminine ; --auto
lin intellect_N = mkN "intel·lecte" masculine ; --auto
lin intellectual_A = mkA "intel·lectual" ; --auto
lin intellectual_N = mkN "intel·lectual" ; --auto
lin intelligence_1_N = variants {} ; ---- sense to be split
lin intelligence_2_N = variants {} ; ---- sense to be split
lin intelligent_A = mkA "intel·ligent" ; --auto
lin intelligibility_N = mkN "intel·ligibilitat" feminine ; --auto
lin intelligible_A = mkA "intel·ligible" ; --auto
lin intend_VV = mkVV (mkV "pensar") ;
lin intense_A = mkA "intens" ; --auto
lin intensification_N = mkN "intensificació" feminine ; --auto
lin intensify_V = mkV "intensificar" ; --auto
lin intensify_V2 = mkV2 "intensificar" ; --auto
lin intensity_N = mkN "intensitat" feminine ; --auto
lin intensive_A = mkA "intensiu" ; --auto
lin intention_N = mkN "intenció" feminine ; --auto
lin intentional_A = mkA "intencional" | mkA "intencionat" ; --auto
lin intentionality_N = mkN "intencionalitat" feminine ; --auto
lin inter_alia_Adv = mkAdv "inter alia" ; --auto
lin interact_V = mkV "interaccionar" ; --auto
lin interaction_N = mkN "interacció" feminine ; --auto
lin interactive_A = mkA "interactiu" ; --auto
lin intercept_V2 = mkV2 "interceptar" ; --auto
lin interception_N = mkN "intercepció" feminine ; --auto
lin interchange_N = mkN "intercanvi" masculine ; --auto
lin interchangeable_A = mkA "intercanviable" ; --auto
lin intercommunication_N = mkN "intercomunicació" feminine ; --auto
lin interconnect_V = mkV "interconnectar" ; --auto
lin interconnect_V2 = mkV2 "interconnectar" ; --auto
lin interconnection_N = mkN "interconnexió" masculine ; --auto
lin intercontinental_A = mkA "intercontinental" ; --auto
lin interdependent_A = mkA "interdependent" ; --auto
lin interdict_N = mkN "interdicte" masculine ; --auto
lin interdiction_N = mkN "interdicció" feminine ; --auto
lin interdisciplinary_A = mkA "interdisciplinari" ; --auto
lin interest_1_N = mkN "interès" masculine ;
lin interest_2_N = mkN "interès" masculine ;
lin interest_V = mkV "interessar" ; --auto
lin interest_V2 = mkV2 "interessar" ; --auto
lin interested_A = mkA "interessat" ;
lin interesting_A = mkA "interessant" ;
lin interface_N = mkN "interfície" masculine ; --auto
lin interfere_V = mkV "interferir" ; --auto
lin interference_N = mkN "interferència" feminine ; --auto
lin interferometer_N = mkN "interferòmetre" masculine ; --auto
lin interferon_N = mkN "interferó" masculine ; --auto
lin intergalactic_A = mkA "intergalàctic" ; --auto
lin interim_A = mkA "interí" ; --auto
lin interior_N = mkN "interior" masculine ; --auto
lin interjection_N = mkN "interjecció" feminine ; --auto
lin interlocutory_A = mkA "interlocutori" ; --auto
lin interloper_N = mkN "intrús" masculine ; --auto
lin intermediary_N = mkN "intermediari" | mkN "intermediari" ; --auto
lin intermediate_A = mkA "intermedi" ; --auto
lin interminable_A = mkA "interminable" ; --auto
lin intermission_N = mkN "entreacte" masculine ; --auto
lin intermittent_A = mkA "intermitent" ; --auto
lin intermolecular_A = mkA "intermolecular" ; --auto
lin intern_N = mkN "intern" | mkN "intern" ; --auto
lin internal_A = mkA "intern" ;
lin international_A = mkA "internacional" ;
lin internet_N = mkN "internet" feminine ; --auto
lin internment_N = mkN "internament" masculine ; --auto
lin internode_N = mkN "entrenús" masculine ; --auto
lin interoperability_N = mkN "interoperabilitat" feminine ; --auto
lin interpellation_N = mkN "interpel·lació" feminine ; --auto
lin interpersonal_A = mkA "interpersonal" ; --auto
lin interphone_N = mkN "intèrfon" masculine ; --auto
lin interplanetary_A = mkA "interplanetari" ; --auto
lin interplay_N = mkN "interacció" feminine ; --auto
lin interpolation_N = mkN "interpolació" feminine ; --auto
lin interpose_V = mkV "interposar" ; --auto
lin interpose_V2 = mkV2 "interposar" ; --auto
lin interposition_N = mkN "interposició" feminine ; --auto
lin interpret_V = mkV "interpretar" ; --auto
lin interpret_V2 = mkV2 "interpretar" ; --auto
lin interpretation_N = mkN "interpretació" feminine ; --auto
lin interpretative_A = mkA "interpretatiu" ; --auto
lin interpreter_N = mkN "intèrpret" ; --auto
lin interregnum_N = mkN "interregne" masculine ; --auto
lin interrelate_V = mkV "interrelacionar" ; --auto
lin interrelate_V2 = mkV2 "interrelacionar" ; --auto
lin interrelation_N = mkN "interrelació" feminine ; --auto
lin interrelationship_N = mkN "interrelació" feminine ; --auto
lin interrogate_V2 = mkV2 "interrogar" ; --auto
lin interrogation_N = mkN "interrogatori" masculine ; --auto
lin interrogator_N = mkN "interrogador" feminine | mkN "interrogador" masculine ; --auto
lin interrupt_V = mkV "interrompre" ; --auto
lin interrupt_V2 = mkV2 "interrompre" ; --auto
lin interruption_N = mkN "interrupció" feminine ; --auto
lin intersect_V = mkV "encreuar" ; --auto
lin intersect_V2 = mkV2 "encreuar" ; --auto
lin intersection_N = mkN "intersecció" feminine ; --auto
lin interstellar_A = mkA "interestel·lar" ; --auto
lin interval_N = mkN "intermedi" masculine | mkN "interval" masculine ; --auto
lin intervene_V = mkV "intervenir" ; --auto
lin intervention_N = mkN "intervenció" feminine ; --auto
lin interview_N = mkN "entrevista" feminine ; --auto
lin interview_V2 = mkV2 "entrevistar" ; --auto
lin interviewer_N = mkN "entrevistador" | mkN "entrevistador" ; --auto
lin interweave_V2 = mkV2 "entrellaçar" ; --auto
lin intestate_A = mkA "intestat" ; --auto
lin intestinal_A = mkA "intestinal" ; --auto
lin intimate_A = mkA "íntim" ; --auto
lin intimation_N = mkN "intimació" feminine ; --auto
lin intimidate_V2 = mkV2 "intimidar" ; --auto
lin intimidation_N = mkN "intimidació" feminine ; --auto
lin into_Prep = mkPrep "cap a" ;
lin intolerable_A = mkA "intolerable" ; --auto
lin intolerance_N = mkN "intolerància" feminine ; --auto
lin intonation_N = mkN "entonació" feminine ; --auto
lin intoxicate_V2 = mkV2 "intoxicar" ; --auto
lin intoxication_N = mkN "intoxicació" feminine ; --auto
lin intracellular_A = mkA "intracel·lular" ; --auto
lin intractable_A = mkA "intractable" ; --auto
lin intrados_N = mkN "intradós" masculine ; --auto
lin intravenous_A = mkA "intravenós" ; --auto
lin intricate_A = mkA "intricat" ; --auto
lin intrigue_N = mkN "intriga" feminine ; --auto
lin intrinsic_A = mkA "intrínsec" ; --auto
lin introduce_V2 = mkV2 (mkV "presentar") ;
lin introduction_N = mkN "introducció" feminine ;
lin introductory_A = mkA "introductori" ; --auto
lin introjection_N = mkN "introjecció" feminine ; --auto
lin intron_N = mkN "intró" masculine ; --auto
lin introspection_N = mkN "introspecció" feminine ; --auto
lin introspective_A = mkA "introspectiu" ; --auto
lin introversion_N = mkN "introversió" feminine ; --auto
lin intruder_N = mkN "intrús" | mkN "intrús" ; --auto
lin intrusion_N = mkN "intrusió" feminine ; --auto
lin intrusive_A = mkA "intrús" ; --auto
lin intuition_N = mkN "intuïció" feminine ; --auto
lin intuitionism_N = mkN "intuïcionisme" masculine ; --auto
lin intuitive_A = mkA "intuïtiu" ; --auto
lin inulin_N = mkN "inulina" feminine ; --auto
lin inundate_V2 = mkV2 "inundar" ; --auto
lin inundation_N = mkN "inundació" feminine ; --auto
lin invade_V2 = mkV2 "envair" ; --auto
lin invader_N = mkN "invasor" | mkN "invasor" ; --auto
lin invagination_N = mkN "invaginació" feminine ; --auto
lin invalid_A = mkA "nul" ; --auto
lin invalid_N = mkN "invàlid" | mkN "invàlid" ; --auto
lin invalidate_V2 = mkV2 "invalidar" ; --auto
lin invalidation_N = mkN "invalidació" feminine ; --auto
lin invalidity_N = mkN "invalidesa" feminine ; --auto
lin invaluable_A = mkA "inavaluable" ; --auto
lin invariable_A = mkA "invariable" ; --auto
lin invariance_N = mkN "invariància" feminine ; --auto
lin invariant_A = mkA "invariable" ; --auto
lin invariant_N = mkN "invariant" feminine ; --auto
lin invasion_N = mkN "invasió" feminine ; --auto
lin invasive_A = mkA "invasiu" ; --auto
lin invent_V = mkV "inventar" ; --auto
lin invent_V2 = mkV2 "inventar" ; --auto
lin invention_N = mkN "invenció" feminine ; --auto
lin inventive_A = mkA "enginyós" ; --auto
lin inventiveness_N = mkN "inventiva" feminine ; --auto
lin inventor_N = mkN "inventor" | mkN "inventor" ; --auto
lin inventory_N = mkN "inventari" masculine ; --auto
lin invertebrate_N = mkN "invertebrat" masculine ; --auto
lin invertible_A = mkA "invertible" ; --auto
lin invest_V = mkV "invertir" ; --auto
lin invest_V2 = mkV2 "invertir" ; --auto
lin investigate_V = mkV "investigar" ; --auto
lin investigate_V2 = mkV2 "investigar" ; --auto
lin investigation_N = mkN "investigació" feminine ;
lin investigator_N = mkN "detectiu" ; --auto
lin investiture_N = mkN "investidura" feminine ; --auto
lin investment_N = mkN "inversió" feminine ;
lin investor_N = mkN "inversor" | mkN "inversor" ; --auto
lin invincible_A = mkA "invencible" ; --auto
lin inviolable_A = mkA "inviolable" ; --auto
lin invisible_A = mkA "invisible" ; --auto
lin invitation_N = mkN "invitació" feminine ; --auto
lin invite_V2 = mkV2 "convidar" ; --auto
lin invite_in_V = advV (lin V OP_invite_V2) OP_in_Adv ; -- guess-p-verb
lin invocation_N = mkN "invocació" feminine ; --auto
lin invoice_N = mkN "factura" feminine ; --auto
lin invoice_V2 = mkV2 "facturar" ; --auto
lin invoke_V2 = mkV2 "invocar" ; --auto
lin involuntary_A = mkA "involuntari" ; --auto
lin involution_N = mkN "involució" feminine ; --auto
lin involve_V = mkV "implicar" ;
lin involve_V2 = mkV2 (mkV "implicar") ;
lin involve_VS = mkVS (mkV "implicar") ;
lin involvement_N = mkN "implicació" feminine ; --auto
lin inwards_Adv = mkAdv "cap a dins" ; --auto
lin iodide_N = mkN "iodur" masculine ; --auto
lin iodine_N = mkN "iode" masculine ; --auto
lin ion_N = mkN "ió" masculine ; --auto
lin ionic_A = mkA "iònic" ; --auto
lin ionosphere_N = mkN "ionosfera" feminine ; --auto
lin iranianFem_N = variants {} ; ---- sense to be split
lin iranianMasc_N = variants {} ; ---- sense to be split
lin iranian_A = mkA "iranià" ; --auto
lin iraqi_A = mkA "iraquià" ; --auto
lin irascible_A = mkA "iracund" ; --auto
lin ire_N = mkN "ira" feminine ; --auto
lin iridectomy_N = mkN "iridectomia" feminine ; --auto
lin iridescence_N = mkN "iridescència" feminine ; --auto
lin iridescent_A = mkA "iridescent" ; --auto
lin iridium_N = mkN "iridi" masculine ; --auto
lin iridotomy_N = mkN "iridotomia" feminine ; --auto
lin iris_N = mkN "iris" masculine | mkN "iris" masculine ; --auto
lin irishFem_N = variants {} ; ---- sense to be split
lin irishMasc_N = variants {} ; ---- sense to be split
lin irish_A = mkA "irlandès" ; --auto
lin iron_N = L.iron_N ;
lin iron_V = mkV "planxar" ; --auto
lin iron_V2 = mkV2 "planxar" ; --auto
lin ironic_A = mkA "irònic" ; --auto
lin ironing_N = mkN "planxat" masculine ; --auto
lin ironmongery_N = mkN "ferreteria" feminine ; --auto
lin irony_N = mkN "ironia" feminine ; --auto
lin irradiate_V2 = mkV2 "radiar" ; --auto
lin irradiation_N = mkN "irradiació" feminine ; --auto
lin irrational_A = mkA "irracional" ; --auto
lin irrationality_N = mkN "irracionalitat" feminine ; --auto
lin irreducible_A = mkA "irreductible" ; --auto
lin irrefutable_A = mkA "fefaent" | mkA "irrefutable" ; --auto
lin irregular_A = mkA "irregular" ; --auto
lin irregularity_N = mkN "irregularitat" feminine ; --auto
lin irrelevant_A = mkA "irrellevant" ; --auto
lin irrepressible_A = mkA "incontenible" ; --auto
lin irresponsibility_N = mkN "irresponsabilitat" feminine ; --auto
lin irresponsible_A = mkA "irresponsable" ; --auto
lin irretrievable_A = mkA "irrecuperable" ; --auto
lin irreverent_A = mkA "irreverent" ; --auto
lin irreversibility_N = mkN "irreversibilitat" feminine ; --auto
lin irreversible_A = mkA "irreversible" ; --auto
lin irrevocable_A = mkA "irrevocable" ; --auto
lin irrigate_V2 = mkV2 "irrigar" ; --auto
lin irrigation_N = mkN "regatge" masculine ; --auto
lin irritate_V2 = mkV2 "irritar" ; --auto
lin irritation_N = mkN "irritació" feminine ; --auto
lin irruption_N = mkN "irrupció" feminine ; --auto
lin ischium_N = mkN "isqui" masculine ; --auto
lin islamic_A = mkA "islàmic" ; --auto
lin island_N = mkN "illa" feminine ;
lin islander_N = mkN "illenc" | mkN "illenc" ; --auto
lin isoantibody_N = mkN "isoanticòs" masculine ; --auto
lin isobar_N = mkN "isòbara" feminine ; --auto
lin isochronal_A = mkA "isòcron" ; --auto
lin isochrone_N = mkN "isòcrona" feminine ; --auto
lin isoclinal_A = mkA "isoclí" ; --auto
lin isocyanate_N = mkN "isocianat" masculine ; --auto
lin isogamy_N = mkN "isogàmia" feminine ; --auto
lin isogon_N = mkN "isògona" feminine ; --auto
lin isogonic_A = mkA "isogònic" ; --auto
lin isogram_N = mkN "isograma" masculine ; --auto
lin isohel_N = mkN "isohèlia" feminine ; --auto
lin isolate_V2 = mkV2 "aïllar" ; --auto
lin isolated_A = mkA "aïllat" | mkA "incomunicat" | mkA "isolat" ; --auto
lin isolation_N = mkN "aïllament" masculine ; --auto
lin isolationism_N = mkN "aïllacionisme" masculine ; --auto
lin isolationist_A = mkA "aïllacionista" ; --auto
lin isomer_N = mkN "isòmer" masculine ; --auto
lin isometric_A = mkA "isomètric" ; --auto
lin isometry_N = mkN "isometria" feminine ; --auto
lin isomorphic_A = mkA "isomorf" | mkA "isomòrfic" ; --auto
lin isomorphism_N = mkN "isomorfisme" masculine ; --auto
lin isosceles_A = mkA "isòsceles" ; --auto
lin isostasy_N = mkN "isostàsia" feminine ; --auto
lin isotherm_N = mkN "isoterma" feminine ; --auto
lin isothermal_A = mkA "isoterm" | mkA "isotèrmic" ; --auto
lin isotope_N = mkN "isòtop" masculine ; --auto
lin isotopic_A = mkA "isotòpic" ; --auto
lin isotropic_A = mkA "isòtrop" ; --auto
lin isotropy_N = mkN "isotropia" feminine ; --auto
lin israeli_A = mkA "israelià" ; --auto
lin issue_1_N = mkN "tema" masculine ; --split mkN "problema"
lin issue_2_N = mkN "tema" masculine ; --split mkN "problema"
lin issue_V = mkV (servir_101 "expedir") ;
lin issue_V2 = mkV2 (mkV (servir_101 "expedir")) ;
lin issue_forth_V = advV OP_issue_V OP_forth_Adv ; -- guess-p-verb
lin isthmus_N = mkN "istme" masculine ; --auto
lin it_Pron = optProDrop S.it_Pron ;
lin italianFem_N = variants {} ;
lin italianMasc_N = variants {} ;
lin italian_A = mkA "italià" ;
lin itch_N = mkN "coïssor" feminine ; --auto
lin item_N = mkN "article" masculine ;
lin iterate_V2 = mkV2 "iterar" ; --auto
lin iterative_A = mkA "iteratiu" ; --auto
lin itinerant_A = mkA "itinerant" ; --auto
lin ivory_N = mkN "vori" masculine ; --auto
lin jackal_N = mkN "xacal" masculine ; --auto
lin jacket_N = mkN "funda" feminine | mkN "jaqueta" feminine ; --auto
lin jacobinism_N = mkN "jacobinisme" masculine ; --auto
lin jacquard_N = mkN "jacquard" masculine ; --auto
lin jade_N = mkN "jade" masculine ; --auto
lin jadeite_N = mkN "jadeïta" feminine ; --auto
lin jaguar_N = mkN "jaguar" masculine ; --auto
lin jail_N = mkN "presó" feminine ; --auto
lin jam_N = mkN "embós" masculine | mkN "embús" masculine | mkN "melmelada" feminine ; --auto
lin jamaican_A = mkA "jamaicà" ; --auto
lin jamaican_N = mkN "jamaicà" | mkN "jamaicà" ; --auto
lin japaneseFem_N = variants {} ; ---- sense to be split
lin japaneseMasc_N = variants {} ; ---- sense to be split
lin japanese_A = mkA "japonès" ; --auto
lin jar_N = mkN "pot" masculine ; --auto
lin jargon_N = mkN "argot" masculine ; --auto
lin jasmine_N = mkN "gessamí" feminine | mkN "gessamí" masculine ; --auto
lin jasper_N = mkN "jaspi" masculine ; --auto
lin jaundice_N = mkN "icterícia" feminine ; --auto
lin jaunty_A = mkA "desenfadat" ; --auto
lin javelin_N = mkN "javelina" feminine ; --auto
lin jaw_N = mkN "mandíbula" feminine ; --auto
lin jawbone_N = mkN "maxil·lar inferior" masculine ; --auto
lin jay_N = mkN "gaig" masculine ; --auto
lin jazz_N = mkN "jazz" masculine ; --auto
lin jealous_A = mkA "gelós" ; --auto
lin jealousy_N = mkN "gelosia" feminine ; --auto
lin jeans_N = mkN "texans" masculine ; --auto
lin jeep_N = mkN "jeep" masculine ; --auto
lin jelly_N = mkN "gelea" feminine ; --auto
lin jellyfish_N = mkN "medusa" feminine ; --auto
lin jersey_N = mkN "suèter" masculine ; --auto
lin jest_N = mkN "broma" feminine ; --auto
lin jet_N = mkN "jet" masculine ; --auto
lin jetty_N = mkN "espigó" masculine ; --auto
lin jewel_N = mkN "joia" feminine ; --auto
lin jewellery_N = mkN "joieria" feminine | mkN "joia" feminine | mkN "joia" feminine ; --auto
lin jewelry_N = mkN "joia" feminine | mkN "joia" feminine ; --auto
lin jewish_A = mkA "jueu" ; --auto
lin jihad_N = mkN "gihad" masculine | mkN "jihad" feminine ; --auto
lin job_N = mkN "feina" feminine ;
lin join_V = mkV "ajuntar" ;
lin join_V2 = mkV2 (mkV "ajuntar") ;
lin join_up_V = advV OP_join_V OP_up_Adv ; -- guess-p-verb
lin joint_A = mkA "conjunt" ;
lin joint_N = mkN "articulació" feminine | mkN "junta" feminine | mkN "juntura" feminine | mkN "queix" masculine ; --auto
lin joint_V2 = mkV2 "ajuntar" ; --auto
lin joke_N = mkN "acudit" masculine ; --auto
lin joker_N = mkN "jòquer" masculine ; --auto
lin jokingly_Adv = mkAdv "de broma" ; --auto
lin jordanian_A = mkA "jordà" ; --auto
lin joule_N = mkN "joule" masculine ; --auto
lin journal_N = mkN "revista" feminine ; --auto
lin journalism_N = mkN "periodisme" masculine ; --auto
lin journalist_N = mkN "periodista" ; --auto
lin journalistic_A = mkA "periodístic" ; --auto
lin journey_N = mkN "viatge" masculine ; --auto
lin joy_N = mkN "alegria" feminine ; --auto
lin joyous_A = mkA "joiós" ; --auto
lin jubilation_N = mkN "gaubança" feminine ; --auto
lin judaic_A = mkA "judaic" ; --auto
lin judge_N = mkN "jutge" ;
lin judge_V = mkV "jutjar" ; --auto
lin judge_V2 = mkV2 "jutjar" ; --auto
lin judgement_N = mkN "judici" masculine | mkN "sentència" feminine ; --auto
lin judgment_N = mkN "judici" masculine | mkN "sentència" feminine ; --auto
lin judicature_N = mkN "judicatura" feminine ; --auto
lin judicial_A = mkA "judicial" ; --auto
lin jug_N = mkN "gerra" feminine ; --auto
lin jugglerMasc_N = mkN "malabarista" ; --auto
lin jugglerFem_N = mkN "malabarista" ; --auto
lin juice_1_N = mkN "suc" masculine ; --auto
lin juice_2_N = mkN "suc" masculine ; --auto
lin julian_A = mkA "julià" ; --auto
lin jump_N = mkN "salt" masculine ; --auto
lin jump_V = L.jump_V ;
lin jump_V2 = variants {} ; -- L.jump_V ;
lin jump_at_V2 = prepV2 OP_jump_V OP_at_Prep ; -- guess-p-verb
lin jump_in_V = advV OP_jump_V OP_in_Adv ; -- guess-p-verb
lin jump_on_V2 = prepV2 OP_jump_V OP_on_Prep ; -- guess-p-verb
lin jump_to_V2 = prepV2 OP_jump_V OP_to_Prep ; -- guess-p-verb
lin jumper_N = mkN "jersei" masculine ; --auto
lin junction_N = mkN "embrancament" masculine | mkN "encreuament" masculine | mkN "entroncament" masculine ; --auto
lin juncture_N = mkN "conjuntura" feminine ; --auto
lin jungle_N = mkN "jungla" feminine | mkN "selva" feminine ; --auto
lin junior_N = mkN "jove" ; --auto
lin juniper_N = mkN "ginebrer" masculine ; --auto
lin junk_N = mkN "endergues" feminine ; --auto
lin juridical_A = mkA "jurídic" ; --auto
lin jurisdiction_N = mkN "jurisdicció" feminine ; --auto
lin jurisprudence_N = mkN "jurisprudència" feminine ; --auto
lin jurisprudential_A = mkA "jurisprudencial" ; --auto
lin jurist_N = mkN "jurista" ; --auto
lin jury_N = mkN "jurat" masculine ; --auto
lin just_A = mkA "just" ; --auto
lin just_AdV = mkAdv "exactament" | mkAdv "just" | mkAdv "només" ; --auto
lin just_Adv = mkAdv "només" ;
lin justice_N = mkN "justícia" feminine ; --auto
lin justifiable_A = mkA "justificable" ; --auto
lin justification_N = mkN "justificació" feminine ; --auto
lin justify_V2 = mkV2 "justificar" ; --auto
lin jute_N = mkN "jute" masculine ; --auto
lin juvenile_A = mkA "juvenil" ; --auto
lin juxtapose_V2 = mkV2 "juxtaposar" ; --auto
lin juxtaposition_N = mkN "juxtaposició" feminine ; --auto
lin kafkaesque_A = mkA "kafkià" ; --auto
lin kaiser_N = mkN "kàiser" masculine ; --auto
lin kamikaze_N = mkN "kamikaze" masculine ; --auto
lin kaolin_N = mkN "caolí" masculine ; --auto
lin kaolinite_N = mkN "caolinita" feminine ; --auto
lin kaon_N = mkN "kaó" masculine ; --auto
lin kapok_N = mkN "capoc" masculine ; --auto
lin karate_N = mkN "karate" masculine ; --auto
lin karyotype_N = mkN "cariotip" masculine ; --auto
lin katabatic_A = mkA "catabàtic" ; --auto
lin kayak_N = mkN "caiac" masculine ; --auto
lin keen_A = mkA "delerós" | mkA "entusiàstic" ; --auto
lin keep_V = mkV "guardar" ;
lin keep_V2 = mkV2 (mkV "guardar") ;
lin keep_V2A = mkV2A (mkV "mantenir") ParadigmsCat.accusative ParadigmsCat.genitive ;
lin keep_VV = mkVV (mkV "continuar") ;
lin keep_around_V2 = prepV2 OP_keep_V OP_around_Prep ; -- guess-p-verb
lin keep_at_V2 = prepV2 OP_keep_V OP_at_Prep ; -- guess-p-verb
lin keep_away_V2 = mkV2 (advV OP_keep_V OP_away_Adv ) ; -- guess-p-verb
lin keep_back_V = advV OP_keep_V OP_back_Adv ; -- guess-p-verb
lin keep_back_V2 = mkV2 (advV OP_keep_V OP_back_Adv ) ; -- guess-p-verb
lin keep_down_V2 = prepV2 OP_keep_V OP_down_Prep ; -- guess-p-verb
lin keep_from_V2 = prepV2 OP_keep_V OP_from_Prep ; -- guess-p-verb
lin keep_in_V2 = prepV2 OP_keep_V OP_in_Prep ; -- guess-p-verb
lin keep_ing_V2V = variants {} ; -- guess-p-verb
lin keep_off_V2 = prepV2 OP_keep_V OP_off_Prep ; -- guess-p-verb
lin keep_on_V = advV OP_keep_V OP_on_Adv ; -- guess-p-verb
lin keep_on_V2 = prepV2 OP_keep_V OP_on_Prep ; -- guess-p-verb
lin keep_out_V = advV OP_keep_V OP_out_Adv ; -- guess-p-verb
lin keep_out_V2 = prepV2 OP_keep_V OP_out_Prep ; -- guess-p-verb
lin keep_over_V2 = prepV2 OP_keep_V OP_over_Prep ; -- guess-p-verb
lin keep_to_V2 = prepV2 OP_keep_V OP_to_Prep ; -- guess-p-verb
lin keep_to_V2V = variants {} ; -- guess-p-verb
lin keep_up_V = advV OP_keep_V OP_up_Adv ; -- guess-p-verb
lin keep_up_V2 = prepV2 OP_keep_V OP_up_Prep ; -- guess-p-verb
lin keep_up_at_V2 = prepV2 (advV OP_keep_V OP_up_Adv ) OP_at_Prep ; -- guess-p-verb
lin keep_up_with_V2 = prepV2 (advV OP_keep_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin keloid_N = mkN "queloide" masculine ; --auto
lin kennel_N = mkN "canera" feminine ; --auto
lin kenyan_A = mkA "kenyà" ; --auto
lin kenyan_N = mkN "kenyà" | mkN "kenyà" ; --auto
lin keratin_N = mkN "queratina" feminine ; --auto
lin keratoplasty_N = mkN "queratoplàstia" feminine ; --auto
lin keratosis_N = mkN "ceratosi" feminine ; --auto
lin kerb_N = mkN "vorada" feminine ; --auto
lin ketone_N = mkN "cetona" feminine ; --auto
lin kettle_N = mkN "bullidor" masculine ; --auto
lin key_1_N = mkN "clau" feminine ;
lin key_2_N = mkN "clau" feminine ;
lin key_3_N = variants {} ; ---- sense to be split
lin key_A = mkA "clau" ;
lin keyboard_N = mkN "teclat" masculine ; --auto
lin khaki_A = mkA "caqui" ; --auto
lin khaki_N = mkN "caqui" masculine ; --auto
lin kick_N = mkN "puntada de peu" feminine | mkN "xut" masculine ; --auto
lin kick_V = mkV "donar una patada a" | mkV "xutar" ; --auto
lin kick_about_V2 = prepV2 OP_kick_V OP_about_Prep ; -- guess-p-verb
lin kick_around_V2 = prepV2 OP_kick_V OP_around_Prep ; -- guess-p-verb
lin kick_around_with_V2 = prepV2 (advV OP_kick_V OP_around_Adv ) OP_with_Prep ; -- guess-p-verb
lin kick_back_V = advV OP_kick_V OP_back_Adv ; -- guess-p-verb
lin kick_back_V2 = mkV2 (advV OP_kick_V OP_back_Adv ) ; -- guess-p-verb
lin kick_down_V2 = prepV2 OP_kick_V OP_down_Prep ; -- guess-p-verb
lin kick_in_V = advV OP_kick_V OP_in_Adv ; -- guess-p-verb
lin kick_in_V2 = prepV2 OP_kick_V OP_in_Prep ; -- guess-p-verb
lin kick_off_V = advV OP_kick_V OP_off_Adv ; -- guess-p-verb
lin kick_off_V2 = prepV2 OP_kick_V OP_off_Prep ; -- guess-p-verb
lin kick_out_V2 = prepV2 OP_kick_V OP_out_Prep ; -- guess-p-verb
lin kick_through_V = advV OP_kick_V OP_through_Adv ; -- guess-p-verb
lin kick_up_V = advV OP_kick_V OP_up_Adv ; -- guess-p-verb
lin kickoff_N = mkN "servei" masculine ; --auto
lin kid_V = mkV "bromejar" ; --auto
lin kid_V2 = mkV2 "bromejar" ; --auto
lin kidnap_V2 = mkV2 "segrestar" ; --auto
lin kidnapper_N = mkN "segrestador" | mkN "segrestador" ; --auto
lin kidnapping_N = mkN "segrest" masculine ; --auto
lin kidney_N = mkN "ronyó" masculine ; --auto
lin kill_V = mkV "matar" ;
lin kill_V2 = L.kill_V2 ;
lin kill_off_V2 = prepV2 OP_kill_V OP_off_Prep ; -- guess-p-verb
lin killing_N = mkN "assassinat" masculine ; --auto
lin kilo_N = mkN "quilo" masculine ; --auto
lin kilobyte_N = mkN "kilobyte" masculine | mkN "kilooctet" masculine ; --auto
lin kilogram_N = mkN "quilogram" masculine ; --auto
lin kilometre_N = mkN "quilòmetre" masculine ; --auto
lin kilowatt_N = mkN "quilovat" masculine | mkN "quilowatt" masculine ; --auto
lin kimberlite_N = mkN "kimberlita" feminine ; --auto
lin kind_A = mkA "amable" ; --auto
lin kind_N = mkN "tipus" "tipus" masculine | mkN "mena" feminine ;
lin kindergarten_N = mkN "guarderia" feminine | mkN "llar d'infants" feminine ; --auto
lin kindness_N = mkN "bondat" feminine ; --auto
lin kindred_N = mkN "parentela" feminine ; --auto
lin kinescope_N = mkN "cinescopi" masculine ; --auto
lin kinesthesia_N = mkN "cinestèsia" feminine ; --auto
lin kinetics_N = mkN "cinètica" feminine ; --auto
lin king_N = L.king_N ;
lin kingdom_N = mkN "regne" masculine ; --auto
lin kinship_N = mkN "parentiu" masculine ; --auto
lin kiosk_N = mkN "quiosc" masculine ; --auto
lin kiss_N = mkN "besada" feminine | mkN "petó" masculine ; --auto
lin kiss_off_V = advV (lin V OP_kiss_V2) OP_off_Adv ; -- guess-p-verb
lin kiss_off_V2 = prepV2 (lin V OP_kiss_V2) OP_off_Prep ; -- guess-p-verb
lin kiss_up_to_V2 = prepV2 (advV (lin V OP_kiss_V2) OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin kit_N = mkN "caixa" feminine ; --auto
lin kitchen_N = mkN "cuina" feminine ;
lin kite_N = mkN "estel" masculine ; --auto
lin kitten_N = mkN "gatet" masculine ; --auto
lin kleptomania_N = mkN "cleptomania" feminine ; --auto
lin kleptomaniac_N = mkN "cleptòman" | mkN "cleptòman" ; --auto
lin klystron_N = mkN "clistró" masculine ; --auto
lin km_N = mkN "km" masculine | mkN "km" masculine | mkN "km" masculine ; --auto
lin knack_N = mkN "habilitat" feminine ; --auto
lin knead_V = mkV "pastar" ; --auto
lin knead_V2 = mkV2 "pastar" ; --auto
lin knee_N = L.knee_N ;
lin kneel_V = mkV "agenollar" ; --auto
lin knife_N = mkN "ganivet" masculine ; --auto
lin knight_N = mkN "cavaller" masculine ; --auto
lin knightly_A = mkA "cavalleresc" ; --auto
lin knit_V = mkV "teixir" ; --auto
lin knit_V2 = mkV2 "teixir" ; --auto
lin knock_N = mkN "colp" masculine | mkN "cop" masculine ; --auto
lin knock_V = mkV "trucar" ; --auto
lin knock_V2 = mkV2 "trucar" ; --auto
lin knock_about_V2 = prepV2 OP_knock_V OP_about_Prep ; -- guess-p-verb
lin knock_around_V2 = prepV2 OP_knock_V OP_around_Prep ; -- guess-p-verb
lin knock_back_V2 = mkV2 (advV OP_knock_V OP_back_Adv ) ; -- guess-p-verb
lin knock_down_V2 = prepV2 OP_knock_V OP_down_Prep ; -- guess-p-verb
lin knock_it_off_V2 = variants {} ; -- guess-p-verb
lin knock_off_V = advV OP_knock_V OP_off_Adv ; -- guess-p-verb
lin knock_off_V2 = prepV2 OP_knock_V OP_off_Prep ; -- guess-p-verb
lin knock_out_V = advV OP_knock_V OP_out_Adv ; -- guess-p-verb
lin knock_out_V2 = prepV2 OP_knock_V OP_out_Prep ; -- guess-p-verb
lin knock_over_V = advV OP_knock_V OP_over_Adv ; -- guess-p-verb
lin knock_together_V2 = mkV2 (advV OP_knock_V OP_together_Adv ) ; -- guess-p-verb
lin knock_up_V = advV OP_knock_V OP_up_Adv ; -- guess-p-verb
lin knock_up_V2 = prepV2 OP_knock_V OP_up_Prep ; -- guess-p-verb
lin knot_N = mkN "nus" masculine ; --auto
lin knotty_A = mkA "nodós" ; --auto
lin knout_N = mkN "knut" masculine ; --auto
lin know_V = L.saberV ;
lin know_V2 = L.know_V2 ;
lin know_VQ = L.know_VQ ;
lin know_VS = L.know_VS ;
lin knowledge_N = mkN "coneixement" masculine ;
lin knowledgeable_A = mkA "savi" ; --auto
lin known_A = mkA "conegut" ; --auto
lin knuckle_N = mkN "artell" masculine ; --auto
lin koala_N = mkN "coala" masculine ; --auto
lin korean_A = mkA "coreà" ; --auto
lin kraurosis_N = mkN "craurosi" feminine ; --auto
lin krona_N = mkN "corona" ;
lin krone_N = mkN "corona" ;
lin kroon_N = mkN "corona" ;
lin krypton_N = mkN "criptó" masculine ; --auto
lin kunzite_N = mkN "kunzita" feminine ; --auto
lin kuwaiti_A = mkA "kuwaitià" ; --auto
lin kyanite_N = mkN "cianita" feminine ; --auto
lin kymograph_N = mkN "quimògraf" masculine ; --auto
lin kyphosis_N = mkN "cifosi" feminine ; --auto
lin lab_N = mkN "laboratori" masculine ; --auto
lin label_N = mkN "etiqueta" feminine | mkN "rètol" masculine ; --auto
lin label_V = mkV "etiquetar" ; --auto
lin label_V2 = mkV2 "etiquetar" ; --auto
lin labial_A = mkA "labial" ; --auto
lin labium_N = mkN "làbium" masculine ; --auto
lin labor_N = mkN "mà d'obra" feminine | mkN "treball" masculine ; --auto
lin laboratory_N = mkN "laboratori" masculine ; --auto
lin labour_N = mkN "treball" masculine ; --split "part" masc (work vs child-birth)
lin labourer_N = mkN "peó" | mkN "peó" ; --auto
lin labyrinth_N = mkN "laberint" masculine ; --auto
lin lace_N = mkN "encaix" masculine ; --auto
lin lace_V = mkV "cordar" ; --auto
lin lace_V2 = mkV2 "cordar" ; --auto
lin lack_N = mkN "falta" feminine ;
lin lack_V = mkV "no tenir" ; --auto
lin lack_V2 = mkV2 "no tenir" ; --auto
lin lacking_A = mkA "mancat" ; --auto
lin lacquer_N = mkN "laca" feminine ; --auto
lin lacrimal_A = mkA "lacrimal" ; --auto
lin lactation_N = mkN "alletament" masculine ; --auto
lin lactose_N = mkN "lactosa" feminine ; --auto
lin lacustrine_A = mkA "lacustre" ; --auto
lin ladle_N = mkN "cullerot" masculine ; --auto
lin lady_N = mkN "dona" feminine ;
lin ladybird_N = mkN "marieta" feminine ; --auto
lin ladybug_N = mkN "marieta" feminine ; --auto
lin lagophthalmos_N = mkN "lagoftàlmia" feminine ; --auto
lin lake_N = L.lake_N ;
lin lamb_N = mkN "anyell" masculine ; --auto
lin lambda_N = mkN "lambda" feminine ; --auto
lin lame_A = mkA "coix" ; --auto
lin laminate_N = mkN "estratificat" masculine ; --auto
lin laminate_V = mkV "laminar" ; --auto
lin laminate_V2 = mkV2 "laminar" ; --auto
lin lamp_N = L.lamp_N ;
lin lampshade_N = mkN "pàmpol" masculine ; --auto
lin lance_N = mkN "llança" feminine ; --auto
lin lancet_N = mkN "llanceta" feminine ; --auto
lin land_N = mkN "terra" feminine ;
lin land_V = mkV "aterrar" ; --auto
lin land_V2 = mkV2 "aterrar" ; --auto
lin land_in_V2 = prepV2 OP_land_V OP_in_Prep ; -- guess-p-verb
lin land_up_in_V2 = prepV2 (advV OP_land_V OP_up_Adv ) OP_in_Prep ; -- guess-p-verb
lin land_with_V3 = variants {} ; -- guess-p-verb
lin landfall_N = mkN "recalada" feminine ; --auto
lin landing_N = mkN "aterratge" masculine ; --auto
lin landlord_N = mkN "amo" masculine ; --auto
lin landscape_N = mkN "paisatge" masculine ; --auto
lin landslide_N = mkN "esllavissada" feminine | mkN "lliscament de terres" masculine ; --auto
lin lane_N = mkN "camí" masculine | mkN "carril" masculine ; --auto
lin language_N = L.language_N ;
lin lantern_N = mkN "llanterna" feminine ; --auto
lin lap_V = mkV "lapidar" ; --auto
lin lap_V2 = mkV2 "lapidar" ; --auto
lin laparoscopy_N = mkN "laparoscòpia" feminine ; --auto
lin laparotomy_N = mkN "laparotomia" feminine ; --auto
lin lapidarian_A = mkA "lapidari" ; --auto
lin lapse_N = mkN "lapse" masculine ; --auto
lin laptop_N = mkN "portàtil" masculine ; --auto
lin larch_N = mkN "làrix" masculine ; --auto
lin lard_N = mkN "llard" masculine ; --auto
lin large_A = mkA "gran" ;
lin largo_Adv = mkAdv "largo" ; --auto
lin lark_N = mkN "alosa" feminine ; --auto
lin larva_N = mkN "larva" feminine ; --auto
lin laryngectomy_N = mkN "laringectomia" feminine ; --auto
lin laryngoscope_N = mkN "laringoscopi" masculine ; --auto
lin laryngospasm_N = mkN "laringospasme" masculine ; --auto
lin lasciviousness_N = mkN "lascívia" feminine ; --auto
lin laser_N = mkN "làser" masculine ; --auto
lin last_1_A = mkA "últim" ;
lin last_2_A = mkA "últim" ;
lin last_V = mkV "durar" ; --auto
lin lasting_A = mkA "durador" ; --auto
lin latch_N = mkN "pestell" masculine ; --auto
lin late_A = mkA "tard" ;
lin late_Adv = mkAdv "tard" ;
lin lately_Adv = mkAdv "darrerament" | mkAdv "últimament" ; --auto
lin latency_N = mkN "latència" feminine ; --auto
lin latent_A = mkA "latent" ; --auto
lin later_Adv = mkAdv "més tard" ;
lin lateral_A = mkA "lateral" ; --auto
lin laterite_N = mkN "laterita" feminine ; --auto
lin lathe_N = mkN "torn" masculine ; --auto
lin latin_A = mkA "llatí" ; --auto
lin latinist_N = mkN "llatinista" ; --auto
lin latitude_N = mkN "latitud" feminine ; --auto
lin latrine_N = mkN "latrina" feminine ; --auto
lin latter_A = mkA "segon" | mkA "últim" ; --"the latter" -> els segons, els últims
lin lattice_N = mkN "enreixat" masculine ; --auto
lin laugh_N = mkN "riure" masculine ; --auto
lin laugh_V = L.laugh_V ;
lin laugh_V2 = mkV2 L.laugh_V ParadigmsCat.genitive ;
lin laugh_VS = mkVS L.laugh_V ; --subcat
lin laugh_at_V2 = prepV2 OP_laugh_V OP_at_Prep ; -- guess-p-verb
lin laugh_off_V2 = prepV2 OP_laugh_V OP_off_Prep ; -- guess-p-verb
lin laughter_N = mkN "riure" masculine ; --auto
lin launch_N = mkN "llançament" masculine | mkN "llanxa" feminine ; --auto
lin launch_V = mkV "llançar" ;
lin launch_V2 = mkV2 (mkV "llançar") ;
lin launching_N = mkN "llançament" masculine ; --auto
lin laundry_N = mkN "roba bruta" feminine ; --auto
lin laureateFem_N = variants {} ; ---- sense to be split
lin laureateMasc_N = variants {} ; ---- sense to be split
lin laurel_N = mkN "llorer" masculine ; --auto
lin lava_N = mkN "lava" feminine ; --auto
lin lavender_N = mkN "espígol" masculine ; --auto
lin lavishness_N = mkN "fastuositat" feminine ; --auto
lin law_1_N = mkN "llei" feminine ; --split mkN "dret" masculine (specific law vs. field)
lin law_2_N = mkN "llei" feminine ; --split mkN "dret" masculine (specific law vs. field)
lin lawful_A = mkA "lícit" ; --auto
lin lawfulness_N = mkN "legalitat" feminine ; --auto
lin lawless_A = mkA "anàrquic" ; --auto
lin lawmaker_N = mkN "legislador" ; --auto
lin lawn_N = mkN "gespa" feminine ; --auto
lin lawyer_N = mkN "advocat" feminine | mkN "advocat" masculine ; --auto
lin lay_V = mkV "estirar" ;
lin lay_V2 = mkV2 (mkV "estirar") ;
lin lay_away_V2 = mkV2 (advV OP_lay_V OP_away_Adv ) ; -- guess-p-verb
lin lay_down_V = advV OP_lay_V OP_down_Adv ; -- guess-p-verb
lin lay_down_V2 = prepV2 OP_lay_V OP_down_Prep ; -- guess-p-verb
lin lay_in_on_V2 = prepV2 (advV OP_lay_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin lay_into_V2 = prepV2 OP_lay_V OP_into_Prep ; -- guess-p-verb
lin lay_off_V2 = prepV2 OP_lay_V OP_off_Prep ; -- guess-p-verb
lin lay_on_V2 = prepV2 OP_lay_V OP_on_Prep ; -- guess-p-verb
lin lay_out_V2 = prepV2 OP_lay_V OP_out_Prep ; -- guess-p-verb
lin layer_N = mkN "capa" feminine | mkN "estrat" masculine ; --auto
lin layman_N = mkN "llec" masculine ; --auto
lin lay_out_N = mkN "traçat" masculine ; --auto
lin laziness_N = mkN "ganduleria" feminine ; --auto
lin lazy_A = mkA "gandul" ; --auto
lin lead_N = mkN "plom" masculine ;
lin lead_V = verbV (reduir_94 "conduir") ;
lin lead_V2 = mkV2 (verbV (reduir_94 "conduir")) ;
lin lead_V2V = mkV2V (verbV (reduir_94 "conduir")) ParadigmsCat.accusative ParadigmsCat.dative ;
lin lead_on_V2 = prepV2 OP_lead_V OP_on_Prep ; -- guess-p-verb
lin lead_to_V2 = prepV2 OP_lead_V OP_to_Prep ; -- guess-p-verb
lin lead_up_V = advV OP_lead_V OP_up_Adv ; -- guess-p-verb
lin leader_N = mkN "líder" | mkN "cap" ;
lin leadership_N = mkN "lideratge" masculine ; --auto
lin leading_A = mkA "davanter" ; --auto
lin leading_N = mkN "interlineat" masculine ; --auto
lin leaf_N = L.leaf_N ;
lin leaflet_N = mkN "folíol" masculine ; --auto
lin league_1_N = mkN "lliga" feminine ;
lin league_2_N = mkN "lliga" feminine ;
lin leak_N = mkN "filtració" feminine ; --auto
lin leak_V = mkV "filtrar" | mkV "gotejar" ; --auto
lin leak_V2 = mkV2 "filtrar" | mkV2 "gotejar" ; --auto
lin leakproof_A = mkA "estanc" ; --auto
lin lean_A = mkA "magre" ; --auto
lin lean_V = mkV "recolzar" ; --auto
lin lean_V2 = mkV2 "recolzar" ; --auto
lin lean_on_V2 = prepV2 OP_lean_V OP_on_Prep ; -- guess-p-verb
lin leap_N = mkN "salt" masculine ; --auto
lin leap_V = mkV "saltar" ; --auto
lin leap_V2 = mkV2 "saltar" ; --auto
lin learn_V = verbV (aprendre_6 "aprendre") ;
lin learn_V2 = L.learn_V2 ;
lin learn_VS = mkVS (verbV (aprendre_6 "aprendre")) ;
lin learn_VV = aVV (verbV (aprendre_6 "aprendre")) ;
lin learning_N = mkN "aprenentatge" masculine | mkN "saber" masculine ; --auto
lin lease_N = mkN "arrendament" masculine ; --auto
lin lease_V2 = mkV2 "arrendar" ; --auto
lin least_Adv = mkAdv "menys" ;
lin leather_N = L.leather_N ;
lin leave_V = mkV "marxar" ;
lin leave_V2 = L.leave_V2 ;
lin leave_V2V = mkV2V (mkV "deixar") ParadigmsCat.accusative ParadigmsCat.accusative ;
lin leave_behind_V = advV OP_leave_V OP_behind_Adv ; -- guess-p-verb
lin leave_off_V = advV OP_leave_V OP_off_Adv ; -- guess-p-verb
lin leave_on_V2 = prepV2 OP_leave_V OP_on_Prep ; -- guess-p-verb
lin leave_open_V = advV OP_leave_V OP_open_Adv ; -- guess-p-verb
lin leave_out_V2 = prepV2 OP_leave_V OP_out_Prep ; -- guess-p-verb
lin leave_over_V = advV OP_leave_V OP_over_Adv ; -- guess-p-verb
lin lebaneseFem_N = variants {} ; ---- sense to be split
lin lebaneseMasc_N = variants {} ; ---- sense to be split
lin lebanese_A = mkA "libanès" ; --auto
lin lectin_N = mkN "lectina" feminine ; --auto
lin lecture_N = mkN "conferència" feminine ; --auto
lin lecturer_N = mkN "conferenciant" ; --auto
lin leech_N = mkN "sangonera" feminine ; --auto
lin leek_N = mkN "porro" masculine ; --auto
lin leeward_N = mkN "sotavent" masculine ; --auto
lin left_A = mkA "erquerra" ;
lin left_N = mkN "esquerra" feminine ; --auto
lin leftover_A = mkA "sobrant" ; --auto
lin leftover_N = mkN "resquícies" feminine ; --auto
lin leg_N = L.leg_N ;
lin legal_A = mkA "legal" ;
lin legalism_N = mkN "legalisme" masculine ; --auto
lin legation_N = mkN "legació" feminine ; --auto
lin legend_N = mkN "llegenda" feminine ; --auto
lin legion_N = mkN "legió" feminine ; --auto
lin legionary_N = mkN "legionari" masculine ; --auto
lin legislate_V = mkV "legislar" ; --auto
lin legislate_V2 = mkV2 "legislar" ; --auto
lin legislation_N = mkN "legislació" feminine ;
lin legislative_A = mkA "legislatiu" ; --auto
lin legislator_N = mkN "legislador" | mkN "legislador" feminine | mkN "legislador" ; --auto
lin legislature_N = mkN "legislatura" feminine ; --auto
lin legitimacy_N = mkN "legitimitat" feminine ; --auto
lin legitimate_A = mkA "legítim" ; --auto
lin leishmaniasis_N = mkN "leishmaniosi" feminine ; --auto
lin leisure_N = mkN "lleure" masculine | mkN "oci" masculine ; --auto
lin leitmotiv_N = mkN "leitmotiv" masculine | mkN "leitmotiv" masculine ; --auto
lin lemma_N = mkN "lema" masculine ; --auto
lin lemniscus_N = mkN "lemnisc" masculine ; --auto
lin lemon_N = mkN "llimona" feminine | mkN "llimó" feminine ; --auto
lin lemonade_N = mkN "llimonada" feminine ; --auto
lin lemur_N = mkN "lèmur" masculine ; --auto
lin lend_V = mkV "deixar" ; --auto
lin lend_V2 = mkV2 "deixar" ; --auto
lin lender_N = mkN "prestador" feminine | mkN "prestador" masculine ; --auto
lin length_N = mkN "llargada" feminine ;
lin lengthwise_Adv = mkAdv "al llarg" ; --auto
lin lengthy_A = mkA "llarg" ; --auto
lin lens_N = mkN "lent" feminine ; --auto
lin lenticel_N = mkN "lenticel·la" feminine ; --auto
lin lentil_N = mkN "llentia" feminine ; --auto
lin leonine_A = mkA "lleoní" ; --auto
lin leopard_N = mkN "lleopard" masculine ; --auto
lin lepidocrocite_N = mkN "lepidocrocita" feminine ; --auto
lin lepidolite_N = mkN "lepidolita" feminine ; --auto
lin leprosy_N = mkN "lepra" feminine ; --auto
lin lepton_1_N = mkN "leptó" masculine ; --auto
lin lepton_2_N = mkN "leptó" masculine ; --auto
lin lesbian_A = mkA "lesbiana" ; --auto
lin lesbian_N = mkN "lesbiana" feminine ; --auto
lin lesbianism_N = mkN "lesbianisme" masculine ; --auto
lin less_AdA = mkAdv "menys" ; --auto
lin less_Adv = mkAdv "menys" ;
lin less_Det = mkDet "menys" ;
lin lesser_A = mkA "menor" ; --auto
lin lesson_N = mkN "lliçó" feminine ; --auto
lin let_V2V = mkV2V (mkV "deixar") ParadigmsCat.accusative ParadigmsCat.accusative ;
lin lethal_A = mkA "letal" ; --auto
lin lethargy_N = mkN "letargia" feminine ; --auto
lin letter_1_N = mkN "carta" feminine ; --split "lletra" (alphabet)
lin letter_2_N = mkN "carta" feminine ; --split "lletra" (alphabet)
lin lettuce_N = mkN "enciam" masculine ; --auto
lin leu_N = mkN "leu" "lei" masculine ;
lin leucine_N = mkN "leucina" feminine ; --auto
lin leucocyte_N = mkN "leucòcit" masculine ; --auto
lin leukaemia_N = mkN "leucèmia" feminine ; --auto
lin leukocytosis_N = mkN "leucocitosi" feminine ; --auto
lin leukoderma_N = mkN "leucodèrmia" feminine ; --auto
lin leukopenia_N = mkN "leucopènia" feminine ; --auto
lin lev_N = mkN "lev" "lev" masculine ;
lin levanter_N = mkN "llevant" masculine ; --auto
lin level_1_N = mkN "nivell" masculine ;
lin level_2_N = mkN "nivell" masculine ;
lin level_V = mkV "anivellar" ; --auto
lin level_V2 = mkV2 "anivellar" ; --auto
lin lever_N = mkN "palanca" feminine ; --auto
lin levitation_N = mkN "levitació" feminine ; --auto
lin lewd_A = mkA "luxuriós" ; --auto
lin lexeme_N = mkN "lexema" masculine ; --auto
lin lexical_A = mkA "lèxic" ; --auto
lin lexicographerFem_N = variants {} ; ---- sense to be split
lin lexicographerMasc_N = variants {} ; ---- sense to be split
lin lexicography_N = mkN "lexicografia" feminine ; --auto
lin lexicology_N = mkN "lexicologia" feminine ; --auto
lin lexicon_N = mkN "lèxic" masculine ; --auto
lin liability_N = mkN "responsabilitat" feminine ; --auto
lin liable_A = mkA "propens" ; --auto
lin liaison_N = mkN "enllaç" masculine ; --auto
lin liar_N = mkN "mentider" | mkN "mentider" ; --auto
lin liberal_A = mkA "liberal" | mkA "lliberal" ; --auto
lin liberalism_N = mkN "liberalisme" masculine ; --auto
lin liberality_N = mkN "liberalitat" feminine ; --auto
lin liberator_N = mkN "llibertador" feminine | mkN "llibertador" masculine ; --auto
lin liberian_A = mkA "liberià" ; --auto
lin libertarian_A = mkA "llibertari" ; --auto
lin libertarianism_N = mkN "llibertarisme" masculine ; --auto
lin libidinous_A = mkA "libidinós" ; --auto
lin libido_N = mkN "libido" masculine ; --auto
lin librarian_N = mkN "bibliotecari" | mkN "bibliotecari" ; --auto
lin librarianship_N = mkN "biblioteconomia" feminine ; --auto
lin library_N = mkN "biblioteca" feminine ;
lin libyan_A = mkA "libi" ; --auto
lin licence_N = mkN "llicència" feminine ; --auto
lin license_N = mkN "llicència" feminine ; --auto
lin licit_A = mkA "lícit" ; --auto
lin lick_V2 = mkV2 "llepar" ; --auto
lin licking_N = mkN "pallissa" feminine ; --auto
lin lid_N = mkN "parpella" feminine | mkN "tapa" feminine ; --auto
lin lie_1_V = mkV (mentir_66 "mentir") ;
lin lie_2_V = reflV (mkV "estirar") ;
lin lie_N = mkN "mentida" feminine ; --auto
lin lie_VS = mkVS (verbV (mentir_66 "mentir")) ;
lin lie_around_V = advV OP_lie_V OP_around_Adv ; -- guess-p-verb
lin lie_back_V = advV OP_lie_V OP_back_Adv ; -- guess-p-verb
lin lie_down_V = advV OP_lie_V OP_down_Adv ; -- guess-p-verb
lin lie_down_on_V2 = prepV2 (advV OP_lie_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin lie_with_V2 = prepV2 OP_lie_V OP_with_Prep ; -- guess-p-verb
lin lieutenant_N = mkN "lloctinent" feminine | mkN "lloctinent" masculine | mkN "tinent" ; --auto
lin life_N = mkN "vida" feminine ;
lin lifeguard_N = mkN "socorrista" ; --auto
lin lifestyle_N = mkN "estil de vida" masculine ; --auto
lin lift_N = mkN "ascensor" masculine | mkN "impuls" masculine ; --auto
lin lift_V = mkV "aixecar" ;
lin lift_V2 = mkV2 (mkV "aixecar") ;
lin lift_off_V = advV OP_lift_V OP_off_Adv ; -- guess-p-verb
lin ligament_N = mkN "lligament" masculine ; --auto
lin ligand_N = mkN "lligand" masculine ; --auto
lin light_1_A = mkA "lluminós" ;
lin light_2_A = mkA "lluminós" ;
lin light_N = mkN "llum" feminine ; --split "llum" masculine (light vs lamp)
lin light_V = mkV "encendre" | mkV "il·luminar" ; --auto
lin light_V2 = mkV2 "encendre" | mkV2 "il·luminar" ; --auto
lin light_out_V = advV OP_light_V OP_out_Adv ; -- guess-p-verb
lin light_up_V = advV OP_light_V OP_up_Adv ; -- guess-p-verb
lin light_up_V2 = prepV2 OP_light_V OP_up_Prep ; -- guess-p-verb
lin lighten_V = mkV "alleugerir" ; --auto
lin lighten_V2 = mkV2 "alleugerir" ; --auto
lin lighter_N = mkN "encenedor" masculine ; --auto
lin lighting_N = mkN "enllumenat" masculine ; --auto
lin lightning_N = mkN "llampec" masculine | mkN "parallamps" masculine ; --auto
lin lightweight_A = mkA "lleuger" ; --auto
lin lignin_N = mkN "lignina" feminine ; --auto
lin lignite_N = mkN "lignit" masculine ; --auto
lin like_Prep = mkPrep "com" ;
lin like_V2 = L.like_V2 ;
lin like_VS = mkVS (mkV "agradar") ;
lin like_VV = mkVV (mkV "agradar") ;
lin likely_A = mkA "probable" ;
lin likewise_Adv = mkAdv "així mateix" ; --auto
lin lilac_N = mkN "lilà" masculine ; --auto
lin lily_N = mkN "lliri" masculine ; --auto
lin lime_1_N = mkN "llima" feminine ; --auto
lin lime_2_N = mkN "llima" feminine ; --auto
lin limestone_N = mkN "calcària" feminine ; --auto
lin limit_N = mkN "límit" masculine ; --auto
lin limit_V2 = mkV2 (mkV "limitar") ;
lin limit_V2V = mkV2V (mkV "limitar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin limitation_N = mkN "limitació" feminine ; --auto
lin limiter_N = mkN "limitador" feminine | mkN "limitador" masculine ; --auto
lin limnology_N = mkN "limnologia" feminine ; --auto
lin limonite_N = mkN "limonita" feminine ; --auto
lin limousine_N = mkN "limusina" feminine ; --auto
lin limp_V = mkV "coixejar" ; --auto
lin linden_N = mkN "tell" masculine | mkN "til·ler" masculine ; --auto
lin line_N = mkN "línia" feminine ;
lin line_V = mkV "folrar" | mkV "ratllar" ; --auto
lin line_V2 = mkV2 "folrar" | mkV2 "ratllar" ; --auto
lin lineage_N = mkN "llinatge" masculine ; --auto
lin linear_A = mkA "lineal" ; --auto
lin linen_N = mkN "lli" masculine ; --auto
lin linesman_N = mkN "linier" masculine ; --auto
lin lingerie_N = mkN "llenceria" feminine ; --auto
lin lingual_A = mkA "lingual" ; --auto
lin linguist_N = mkN "lingüista" ; --auto
lin linguistic_A = mkA "lingüístic" ; --auto
lin linguistics_N = mkN "lingüística" feminine ; --auto
lin lining_N = mkN "folre" masculine ; --auto
lin link_N = mkN "enllaç" masculine ;
lin link_V = mkV "enllaçar" ;
lin link_V2 = mkV2 (mkV "enllaçar") ;
lin link_up_V2 = prepV2 OP_link_V OP_up_Prep ; -- guess-p-verb
lin link_up_with_V2 = prepV2 (advV OP_link_V OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin linkage_N = mkN "connexió" feminine ; --auto
lin linoleum_N = mkN "linòleum" masculine ; --auto
lin lint_N = mkN "pelussa" feminine ; --auto
lin lintel_N = mkN "llinda" feminine ; --auto
lin lion_N = mkN "lleó" feminine | mkN "lleó" masculine ; --auto
lin lip_N = mkN "llavi" masculine ;
lin lipase_N = mkN "lipasa" feminine ; --auto
lin lipid_N = mkN "lípid" masculine ; --auto
lin lipoma_N = mkN "lipoma" masculine ; --auto
lin lipomatosis_N = mkN "lipomatosi" feminine ; --auto
lin lipoprotein_N = mkN "lipoproteïna" feminine ; --auto
lin liposome_N = mkN "liposoma" masculine ; --auto
lin lipstick_N = mkN "pintallavis" masculine | mkN "pintallavis" masculine ; --auto
lin liquefaction_N = mkN "liqüefacció" feminine ; --auto
lin liquefy_V = mkV "liquar" ; --auto
lin liquefy_V2 = mkV2 "liquar" ; --auto
lin liqueur_N = mkN "licor" masculine ; --auto
lin liquid_A = mkA "líquid" ; --auto
lin liquid_N = mkN "líquid" masculine ; --auto
lin liquidity_N = mkN "liquiditat" feminine ; --auto
lin liquor_N = mkN "licor" masculine ; --auto
lin liquorice_N = mkN "regalèssia" feminine ; --auto
lin list_N = mkN "llista" feminine ;
lin list_V = mkV "llistar" ; --auto
lin list_V2 = mkV2 "llistar" ; --auto
lin listen_V = mkV "escoltar" ;
lin listen_in_V = advV OP_listen_V OP_in_Adv ; -- guess-p-verb
lin listen_out_for_V2 = prepV2 (advV OP_listen_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin listen_up_V = advV OP_listen_V OP_up_Adv ; -- guess-p-verb
lin listenerFem_N = variants {} ; ---- sense to be split
lin listenerMasc_N = variants {} ; ---- sense to be split
lin listing_N = mkN "llistat" masculine ; --auto
lin litany_N = mkN "lletania" feminine ; --auto
lin literacy_N = mkN "alfabetització" feminine ; --auto
lin literal_A = mkA "literal" ; --auto
lin literal_N = mkN "literal" masculine ; --auto
lin literary_A = mkA "literari" ; --auto
lin literate_A = mkA "alfabet" | mkA "culte" ; --auto
lin literature_N = mkN "literatura" feminine ; --auto
lin lithiasis_N = mkN "litiasi" feminine ; --auto
lin lithium_N = mkN "liti" masculine ; --auto
lin lithographer_N = mkN "litògraf" feminine | mkN "litògraf" masculine ; --auto
lin lithographic_A = mkA "litogràfic" ; --auto
lin lithography_N = mkN "litografia" feminine ; --auto
lin lithosphere_N = mkN "litosfera" feminine ; --auto
lin litigate_V = mkV "barallar" ; --auto
lin litigate_V2 = mkV2 "barallar" ; --auto
lin litigious_A = mkA "litigiós" ; --auto
lin litotes_N = mkN "lítote" masculine ; --auto
lin litre_N = mkN "litre" masculine ; --auto
lin litter_V = mkV "embrutar" ; --auto
lin litter_V2 = mkV2 "embrutar" ; --auto
lin little_A = L.small_A ;
lin littoral_A = mkA "litoral" ; --auto
lin liturgical_A = mkA "litúrgic" ; --auto
lin liturgy_N = mkN "litúrgia" feminine ; --auto
lin live_A = mkA "viu" ; --auto
lin live_Adv = mkAdv "en directe" ; --auto
lin live_V = L.live_V ;
lin live_by_V2 = prepV2 OP_live_V OP_by_Prep ; -- guess-p-verb
lin live_down_V2 = prepV2 OP_live_V OP_down_Prep ; -- guess-p-verb
lin live_for_V2 = prepV2 OP_live_V OP_for_Prep ; -- guess-p-verb
lin live_in_V = advV OP_live_V OP_in_Adv ; -- guess-p-verb
lin live_it_up_V2 = variants {} ; -- guess-p-verb
lin live_off_V2 = prepV2 OP_live_V OP_off_Prep ; -- guess-p-verb
lin live_on_V = advV OP_live_V OP_on_Adv ; -- guess-p-verb
lin live_on_V2 = prepV2 OP_live_V OP_on_Prep ; -- guess-p-verb
lin live_out_V = advV OP_live_V OP_out_Adv ; -- guess-p-verb
lin live_out_V2 = prepV2 OP_live_V OP_out_Prep ; -- guess-p-verb
lin live_through_V2 = prepV2 OP_live_V OP_through_Prep ; -- guess-p-verb
lin live_together_V = advV OP_live_V OP_together_Adv ; -- guess-p-verb
lin live_up_V = advV OP_live_V OP_up_Adv ; -- guess-p-verb
lin live_up_to_V2 = prepV2 (advV OP_live_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin live_with_V2 = prepV2 OP_live_V OP_with_Prep ; -- guess-p-verb
lin liveliness_N = mkN "vivacitat" feminine ; --auto
lin lively_A = mkA "viu" ; --auto
lin liver_N = L.liver_N ;
lin livestock_N = mkN "bestiar" masculine ; --auto
lin living_A = mkA "vivent" ;
lin living_room_N = mkN "sala d'estar" feminine ; --auto
lin lizard_N = mkN "llangardaix" masculine ; --auto
lin llama_N = mkN "llama" feminine ; --auto
lin load_N = mkN "carregament" masculine | mkN "càrrega" feminine ; --auto
lin load_V = mkV "carregar" ; --auto
lin load_V2 = mkV2 "carregar" ; --auto
lin loafer_N = mkN "gandul" | mkN "gandul" ; --auto
lin loan_N = mkN "préstec" masculine ;
lin loan_V2 = mkV2 "prestar" ; --auto
lin lobule_N = mkN "lòbul" masculine ; --auto
lin local_A = mkA "local" ;
lin localism_N = mkN "localisme" masculine ; --auto
lin locate_V = mkV "localitzar" ; --auto
lin locate_V2 = mkV2 "localitzar" ; --auto
lin location_N = mkN "ubicació" feminine ; --auto
lin lock_N = mkN "fiador" masculine | mkN "pany" masculine | mkN "resclosa" feminine ; --auto
lin lock_V = mkV "tancar amb clau" ; --auto
lin lock_away_V2 = mkV2 (advV OP_lock_V OP_away_Adv ) ; -- guess-p-verb
lin lock_down_V2 = prepV2 OP_lock_V OP_down_Prep ; -- guess-p-verb
lin lock_in_V2 = prepV2 OP_lock_V OP_in_Prep ; -- guess-p-verb
lin lock_onto_V2 = prepV2 OP_lock_V OP_onto_Prep ; -- guess-p-verb
lin lock_out_V2 = prepV2 OP_lock_V OP_out_Prep ; -- guess-p-verb
lin lock_up_V2 = prepV2 OP_lock_V OP_up_Prep ; -- guess-p-verb
lin lock_yourself_away_V = variants {} ; -- guess-p-verb
lin lockout_N = mkN "locaut" masculine ; --auto
lin locksmith_N = mkN "manyà" feminine | mkN "manyà" masculine ; --auto
lin lockup_N = mkN "garjola" feminine ; --auto
lin locomotion_N = mkN "locomoció" feminine ; --auto
lin locomotive_N = mkN "locomotora" feminine ; --auto
lin locus_N = mkN "locus" masculine | mkN "locus" masculine ; --auto
lin lodestone_N = mkN "magnetita" feminine ; --auto
lin lodge_V = mkV "allotjar" ; --auto
lin lodge_V2 = mkV2 "allotjar" ; --auto
lin loft_N = mkN "golfes" feminine | mkN "golfes" feminine ; --auto
lin logarithmic_A = mkA "logarítmic" ; --auto
lin loge_N = mkN "llotja" feminine ; --auto
lin logic_N = mkN "lògica" feminine ; --auto
lin logical_A = mkA "lògic" ; --auto
lin logicism_N = mkN "logicisme" masculine ; --auto
lin logistical_A = mkA "logístic" ; --auto
lin logistics_N = mkN "logística" feminine ; --auto
lin lone_A = mkA "solitari" ; --auto
lin lonely_A = mkA "solitari" ; --auto
lin long_A = L.long_A ;
lin longevity_N = mkN "longevitat" feminine ; --auto
lin longingly_Adv = mkAdv "amb desig" ; --auto
lin longitudinal_A = mkA "longitudinal" ; --auto
lin longways_Adv = mkAdv "al llarg" ; --auto
lin look_N = mkN "mirada" feminine ; --split "aparença" (eye look vs. general look)
lin look_V = mkV "mirar" ;
lin look_V2 = mkV2 (mkV "mirar") ;
lin look_VA = mkVA (mkV "mirar") ;
lin look_after_V2 = prepV2 OP_look_V OP_after_Prep ; -- guess-p-verb
lin look_ahead_to_V2 = prepV2 (advV OP_look_V OP_ahead_Adv ) OP_to_Prep ; -- guess-p-verb
lin look_around_V = advV OP_look_V OP_around_Adv ; -- guess-p-verb
lin look_around_at_V2 = prepV2 (advV OP_look_V OP_around_Adv ) OP_at_Prep ; -- guess-p-verb
lin look_at_V2 = prepV2 OP_look_V OP_at_Prep ; -- guess-p-verb
lin look_back_V = advV OP_look_V OP_back_Adv ; -- guess-p-verb
lin look_back_on_V2 = prepV2 (advV OP_look_V OP_back_Adv ) OP_on_Prep ; -- guess-p-verb
lin look_down_V = advV OP_look_V OP_down_Adv ; -- guess-p-verb
lin look_down_on_V2 = prepV2 (advV OP_look_V OP_down_Adv ) OP_on_Prep ; -- guess-p-verb
lin look_for_V2 = prepV2 OP_look_V OP_for_Prep ; -- guess-p-verb
lin look_forward_V = advV OP_look_V OP_forward_Adv ; -- guess-p-verb
lin look_forward_to_V2 = prepV2 (advV OP_look_V OP_forward_Adv ) OP_to_Prep ; -- guess-p-verb
lin look_in_V2 = prepV2 OP_look_V OP_in_Prep ; -- guess-p-verb
lin look_in_on_V2 = prepV2 (advV OP_look_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin look_into_V2 = prepV2 OP_look_V OP_into_Prep ; -- guess-p-verb
lin look_on_V = advV OP_look_V OP_on_Adv ; -- guess-p-verb
lin look_on_as_V3 = variants {} ; -- guess-p-verb
lin look_out_V = advV OP_look_V OP_out_Adv ; -- guess-p-verb
lin look_out_for_V2 = prepV2 (advV OP_look_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin look_over_V2 = prepV2 OP_look_V OP_over_Prep ; -- guess-p-verb
lin look_round_V2 = prepV2 OP_look_V OP_round_Prep ; -- guess-p-verb
lin look_through_V2 = prepV2 OP_look_V OP_through_Prep ; -- guess-p-verb
lin look_to_V2 = prepV2 OP_look_V OP_to_Prep ; -- guess-p-verb
lin look_toward_V2 = prepV2 OP_look_V OP_toward_Prep ; -- guess-p-verb
lin look_up_V = advV OP_look_V OP_up_Adv ; -- guess-p-verb
lin look_up_V2 = prepV2 OP_look_V OP_up_Prep ; -- guess-p-verb
lin look_up_to_V2 = prepV2 (advV OP_look_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin look_upon_as_V3 = variants {} ; -- guess-p-verb
lin lookout_N = mkN "vigia" ; --auto
lin loom_N = mkN "teler" masculine ; --auto
lin loom_V = mkV "amenaçar" ; --auto
lin loop_1_N = mkN "bucle" masculine ; --auto
lin loop_2_N = mkN "bucle" masculine ; --auto
lin loose_A = mkA "solt" ; --auto
lin lord_N = mkN "senyor" masculine ; --auto
lin lordosis_N = mkN "lordosi" feminine ; --auto
lin lorry_N = mkN "camió" masculine ; --auto
lin lose_V = verbV (perdre_83 "perdre") ;
lin lose_V2 = L.lose_V2 ;
lin lose_out_V = advV OP_lose_V OP_out_Adv ; -- guess-p-verb
lin lose_out_on_V2 = prepV2 (advV OP_lose_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin lose_out_to_V2 = prepV2 (advV OP_lose_V OP_out_Adv ) OP_to_Prep ; -- guess-p-verb
lin lose_up_V = advV OP_lose_V OP_up_Adv ; -- guess-p-verb
lin loser_N = mkN "perdedor" | mkN "perdedor" ; --auto
lin loss_N = mkN "pèrdua" feminine ;
lin lossless_A = mkA "sense pèrdues" ; --auto
lin lossy_A = mkA "dissipat" ; --auto
lin lot_1_N = mkN "lot" masculine ;
lin lot_2_N = mkN "lot" masculine ;
lin lot_3_N = mkN "lot" masculine ;
lin lotion_N = mkN "loció" feminine ; --auto
lin lottery_N = mkN "loteria" feminine ; --auto
lin lotus_N = mkN "lotus" masculine | mkN "lotus" masculine ; --auto
lin louse_N = mkN "poll" masculine ; --auto
lin lovable_A = mkA "encantador" ; --auto
lin love_N = L.love_N ;
lin love_V2 = L.love_V2 ;
lin love_VV = mkVV (reflV (mkV "encantar")) ;
lin lovely_A = mkA "hermós" | mkA "preciós" ; --auto
lin lover_N = mkN "amant" ; --auto
lin loving_A = mkA "amorós" ; --auto
lin low_A = mkA "baix" ;
lin low_Adv = mkAdv "baix" ; --auto
lin lower_V = mkV "abaixar" ; --auto
lin lower_V2 = mkV2 "abaixar" ; --auto
lin loyal_A = mkA "lleial" ; --auto
lin loyalty_N = mkN "lleialtat" feminine ; --auto
lin lubricant_N = mkN "lubrificant" masculine ; --auto
lin lubricate_V2 = mkV2 "lubrificar" ; --auto
lin luck_N = mkN "sort" feminine ; --auto
lin luckily_Adv = mkAdv "afortunadament" | mkAdv "per sort" ; --auto
lin lucky_A = mkA "afortunat" ; --auto
lin lucre_N = mkN "lucre" masculine ; --auto
lin luggage_N = mkN "equipatge" masculine ; --auto
lin lumbago_N = mkN "lumbago" masculine ; --auto
lin lumbar_A = mkA "lumbar" ; --auto
lin lumber_N = mkN "fusta" feminine ; --auto
lin lumberjack_N = mkN "llenyataire" ; --auto
lin luminescence_N = mkN "luminescència" feminine ; --auto
lin luminescent_A = mkA "luminescent" ; --auto
lin luminous_A = mkA "lluminós" ; --auto
lin lump_N = mkN "tros" masculine ; --auto
lin lunar_A = mkA "lunar" ; --auto
lin lunatic_N = mkN "llunàtic" feminine | mkN "llunàtic" masculine ; --auto
lin lunch_N = mkN "dinar" masculine ; --auto
lin lunch_V = mkV "dinar" ; --auto
lin lunch_V2 = mkV2 "dinar" ; --auto
lin lunchroom_N = mkN "menjador" masculine ; --auto
lin lung_N = mkN "pulmó" masculine ; --auto
lin lupus_N = mkN "lupus" masculine | mkN "lupus" masculine ; --auto
lin lust_N = mkN "luxúria" feminine ; --auto
lin lute_N = mkN "llaüt" masculine ; --auto
lin lutetium_N = mkN "luteci" masculine ; --auto
lin luxation_N = mkN "luxació" feminine ; --auto
lin luxury_N = mkN "luxe" masculine ; --auto
lin lymph_N = mkN "limfa" feminine ; --auto
lin lymphadenopathy_N = mkN "limfadenopatia" feminine ; --auto
lin lymphatic_A = mkA "limfàtic" ; --auto
lin lymphoblast_N = mkN "limfoblast" masculine ; --auto
lin lymphocyte_N = mkN "limfòcit" masculine ; --auto
lin lymphocytosis_N = mkN "limfocitosi" feminine ; --auto
lin lymphogranuloma_N = mkN "limfogranuloma" masculine ; --auto
lin lymphoma_N = mkN "limfoma" masculine ; --auto
lin lymphopoiesis_N = mkN "limfopoesi" feminine ; --auto
lin lynch_V2 = mkV2 "linxar" ; --auto
lin lynching_N = mkN "linxament" masculine ; --auto
lin lyre_N = mkN "lira" feminine ; --auto
lin lyric_A = mkA "líric" ; --auto
lin lyric_N = mkN "lírica" feminine | mkN "lletra" feminine | mkN "lletra" feminine | mkN "lírica" feminine ; --auto
lin lyricism_N = mkN "lirisme" masculine ; --auto
lin lysis_N = mkN "lisi" feminine ; --auto
lin macadam_N = mkN "macadam" masculine ; --auto
lin machete_N = mkN "matxet" masculine ; --auto
lin machiavellian_A = mkA "maquiavèl·lic" ; --auto
lin machination_N = mkN "maquinació" feminine ; --auto
lin machine_N = mkN "màquina" masculine ;
lin machinery_N = mkN "maquinària" feminine | mkN "mecanisme" masculine ; --auto
lin mackerel_N = mkN "verat" masculine ; --auto
lin macrocephaly_N = mkN "macrocefàlia" feminine ; --auto
lin macroglossia_N = mkN "macroglòssia" feminine ; --auto
lin macromolecular_A = mkA "macromolecular" ; --auto
lin macromolecule_N = mkN "macromolècula" feminine ; --auto
lin macroscopic_A = mkA "macroscòpic" ; --auto
lin macula_N = mkN "màcula" feminine ; --auto
lin mad_A = mkA "boig" | mkA "foll" ; --auto
lin madden_V2 = mkV2 "embogir" ; --auto
lin madman_N = mkN "boig" masculine ; --auto
lin madness_N = mkN "bogeria" feminine ; --auto
lin madrigal_N = mkN "madrigal" masculine ; --auto
lin mafia_N = mkN "màfia" feminine ; --auto
lin magazine_N = mkN "magatzem" masculine | mkN "magazín" masculine | mkN "revista" feminine ; --auto
lin magenta_N = mkN "magenta" masculine ; --auto
lin magic_A = mkA "màgic" ; --auto
lin magic_N = mkN "màgia" feminine ; --auto
lin magician_N = mkN "mag" | mkN "mag" ; --auto
lin magistrate_N = mkN "magistrat" | mkN "magistrat" ; --auto
lin magma_N = mkN "magma" masculine ; --auto
lin magnanimity_N = mkN "magnanimitat" feminine ; --auto
lin magnesite_N = mkN "magnesita" feminine ; --auto
lin magnesium_N = mkN "magnesi" masculine ; --auto
lin magnet_N = mkN "imant" masculine | mkN "magneto" masculine ; --auto
lin magnetic_A = mkA "magnètic" ; --auto
lin magnetism_N = mkN "magnetisme" masculine ; --auto
lin magnetite_N = mkN "magnetita" feminine ; --auto
lin magnetohydrodynamics_N = mkN "magnetohidrodinàmica" feminine ; --auto
lin magnetometer_N = mkN "magnetòmetre" masculine ; --auto
lin magneton_N = mkN "magnetó" masculine ; --auto
lin magnetosphere_N = mkN "magnetosfera" feminine ; --auto
lin magnetron_N = mkN "magnetró" masculine ; --auto
lin magnificent_A = mkA "grandiós" | mkA "magnífic" ; --auto
lin magnitude_N = mkN "magnitud" feminine ; --auto
lin magpie_N = mkN "garça" feminine ; --auto
lin magyarFem_N = variants {} ; ---- sense to be split
lin magyarMasc_N = variants {} ; ---- sense to be split
lin mahogany_N = mkN "caoba" feminine ; --auto
lin maid_N = mkN "mosso" feminine | mkN "servent" feminine ; --auto
lin maiden_A = mkA "virginal" ; --auto
lin mail_N = mkN "correu" masculine | mkN "estafeta" feminine | mkN "mail" masculine | mkN "missatgeria" feminine ; --auto
lin mailbox_N = mkN "bústia" feminine ; --auto
lin mailing_N = mkN "publitramesa" feminine ; --auto
lin mailman_N = mkN "carter" ; --auto
lin main_A = mkA "principal" ;
lin mainly_Adv = mkAdv "principalment" ;
lin mainstay_N = mkN "puntal" masculine ; --auto
lin mainstream_N = mkN "idea dominant" feminine ; --auto
lin maintain_V = mkV "mantenir" ;
lin maintain_V2 = mkV2 (mkV "mantenir") ;
lin maintain_VS = mkVS (mkV (tenir_108 "sostenir")) ;
lin maintenance_N = mkN "manteniment" masculine ; --auto
lin majesty_N = mkN "majestat" feminine ; --auto
lin major_A = mkA "important" ;
lin majority_N = mkN "majoria" feminine ;
lin make_N = mkN "marca" feminine ; --auto
lin make_V = mkV (fer_56 "fer") ;
lin make_V2 = mkV2 (mkV (fer_56 "fer")) ;
lin make_V2A = mkV2A (mkV (fer_56 "fer")) ParadigmsCat.accusative ParadigmsCat.genitive ;
lin make_V2V = mkV2V (mkV (fer_56 "fer")) ParadigmsCat.accusative ParadigmsCat.accusative ;
lin make_after_V = advV OP_make_V OP_after_Adv ; -- guess-p-verb
lin make_away_with_V2 = prepV2 (advV OP_make_V OP_away_Adv ) OP_with_Prep ; -- guess-p-verb
lin make_do_with_V2 = variants {} ; -- guess-p-verb
lin make_for_V2 = prepV2 OP_make_V OP_for_Prep ; -- guess-p-verb
lin make_into_V2 = prepV2 OP_make_V OP_into_Prep ; -- guess-p-verb
lin make_it_V = variants {} ; -- guess-p-verb
lin make_it_up_to_V2 = variants {} ; -- guess-p-verb
lin make_of_V3 = variants {} ; -- guess-p-verb
lin make_off_V = advV OP_make_V OP_off_Adv ; -- guess-p-verb
lin make_off_with_V2 = prepV2 (advV OP_make_V OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin make_out_V = advV OP_make_V OP_out_Adv ; -- guess-p-verb
lin make_out_V2 = prepV2 OP_make_V OP_out_Prep ; -- guess-p-verb
lin make_out_with_V2 = prepV2 (advV OP_make_V OP_out_Adv ) OP_with_Prep ; -- guess-p-verb
lin make_over_V2 = prepV2 OP_make_V OP_over_Prep ; -- guess-p-verb
lin make_towards_V2 = prepV2 OP_make_V OP_towards_Prep ; -- guess-p-verb
lin make_up_V = advV OP_make_V OP_up_Adv ; -- guess-p-verb
lin make_up_V2 = prepV2 OP_make_V OP_up_Prep ; -- guess-p-verb
lin make_up_for_V2 = prepV2 (advV OP_make_V OP_up_Adv ) OP_for_Prep ; -- guess-p-verb
lin make_up_to_V2 = prepV2 (advV OP_make_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin make_with_V2 = prepV2 OP_make_V OP_with_Prep ; -- guess-p-verb
lin maker_N = mkN "fabricant" ; --auto
lin malachite_N = mkN "malaquita" feminine ; --auto
lin malacia_N = mkN "malàcia" feminine ; --auto
lin malacology_N = mkN "malacologia" feminine ; --auto
lin maladjusted_A = mkA "inadaptat" ; --auto
lin maladjustment_N = mkN "inadaptació" feminine ; --auto
lin malaria_N = mkN "malària" feminine ; --auto
lin malawian_A = mkA "malawià" ; --auto
lin malaysian_A = mkA "malai" ; --auto
lin male_A = mkA "mascle" ;
lin male_N = mkN "home" masculine ; --auto
lin malefactor_N = mkN "malfactor" feminine | mkN "malfactor" masculine ; --auto
lin malevolence_N = mkN "malvolença" feminine ; --auto
lin malevolent_A = mkA "malèvol" ; --auto
lin malformation_N = mkN "malformació" feminine ; --auto
lin malice_N = mkN "malícia" feminine ; --auto
lin malignancy_N = mkN "malignitat" feminine ; --auto
lin malignant_A = mkA "maligne" ; --auto
lin malleability_N = mkN "mal·leabilitat" feminine ; --auto
lin malleable_A = mkA "mal·leable" ; --auto
lin mallow_N = mkN "malva" feminine ; --auto
lin malnutrition_N = mkN "desnutrició" feminine ; --auto
lin malt_N = mkN "malt" masculine ; --auto
lin malteseFem_N = variants {} ; ---- sense to be split
lin malteseMasc_N = variants {} ; ---- sense to be split
lin maltese_A = mkA "maltès" ; --auto
lin maltose_N = mkN "maltosa" feminine ; --auto
lin maltreatment_N = mkN "maltractament" masculine ; --auto
lin mammal_N = mkN "mamífer" masculine ; --auto
lin mammalian_A = mkA "mamífer" ; --auto
lin mammalogy_N = mkN "mastologia" feminine ; --auto
lin mammary_A = mkA "mamari" ; --auto
lin mammography_N = mkN "mastografia" feminine ; --auto
lin mammoth_N = mkN "mamut" masculine ; --auto
lin man_N = L.man_N ;
lin manacle_V2 = mkV2 "emmanillar" ; --auto
lin manage_V = mkV "gestionar" ;
lin manage_V2 = mkV2 (mkV "gestionar") ;
lin manage_VV = mkVV (mkV (servir_101 "aconseguir")) ;
lin manageable_A = mkA "gestionable" ; --auto
lin management_N = mkN "gestió" masculine ;
lin manager_N = mkN "encarregat" masculine ;
lin managerial_A = mkA "directiu" ; --auto
lin managing_A = mkA "gestor" ; --auto
lin mandate_N = mkN "mandat" masculine ; --auto
lin mandator_N = mkN "mandatari" | mkN "mandatari" ; --auto
lin mandible_N = mkN "maxil·lar inferior" masculine ; --auto
lin mandibular_A = mkA "mandibular" ; --auto
lin mane_N = mkN "cabellera" feminine ; --auto
lin manganese_N = mkN "manganès" masculine ; --auto
lin mangrove_N = mkN "manglar" masculine | mkN "mangle" masculine ; --auto
lin mania_N = mkN "mania" feminine ; --auto
lin manicure_N = mkN "manicura" feminine ; --auto
lin manicurist_N = mkN "manicur" feminine | mkN "manicur" masculine ; --auto
lin manifest_V2 = mkV2 "manifestar" ; --auto
lin manifold_N = mkN "col·lector" masculine ; --auto
lin manipulate_V2 = mkV2 "manipular" ; --auto
lin manipulation_N = mkN "manipulació" feminine ; --auto
lin manipulator_N = mkN "manipulador" masculine ; --auto
lin mankind_N = mkN "humanitat" feminine ; --auto
lin manna_N = mkN "mannà" masculine ; --auto
lin manner_N = mkN "comportament" masculine ;
lin mannerism_N = mkN "deix" masculine ; --auto
lin manoeuvre_N = mkN "maniobra" feminine ; --auto
lin manoeuvre_V = mkV "maniobrar" ; --auto
lin manoeuvre_V2 = mkV2 "maniobrar" ; --auto
lin manometer_N = mkN "manòmetre" masculine ; --auto
lin manservant_N = mkN "servent" masculine ; --auto
lin mansion_N = mkN "mansió" feminine ; --auto
lin mantissa_N = mkN "mantissa" feminine ; --auto
lin mantle_N = mkN "mantell" masculine ; --auto
lin manual_A = mkA "manual" ; --auto
lin manual_N = mkN "manual" masculine ; --auto
lin manufacture_N = mkN "fabricació" feminine ; --auto
lin manufacture_V2 = mkV2 "fabricar" ; --auto
lin manufacturer_N = mkN "fabricant" ; --auto
lin manufacturing_N = mkN "fabricació" feminine | mkN "manufactura" feminine ; --auto
lin manumission_N = mkN "manumissió" feminine ; --auto
lin manuscript_N = mkN "manuscrit" masculine ; --auto
lin many_Det = S.many_Det ;
lin map_N = mkN "mapa" masculine ; --auto
lin maple_N = mkN "auró" masculine ; --auto
lin mapping_N = mkN "mapatge" masculine ; --auto
lin maquis_N = mkN "màquia" feminine ; --auto
lin maraca_N = mkN "maraca" feminine ; --auto
lin marathon_N = mkN "marató" feminine ; --auto
lin marble_N = mkN "marbre" masculine ; --auto
lin marbled_A = mkA "jaspiat" ; --auto
lin marchioness_N = mkN "marquès" feminine ; --auto
lin mare_N = mkN "euga" masculine ; --auto
lin margarine_N = mkN "margarina" feminine ; --auto
lin margin_N = mkN "marge" masculine ; --auto
lin marginal_A = mkA "insignificant" ; --auto
lin marihuana_N = mkN "marihuana" feminine ; --auto
lin marinade_N = mkN "escabetx" masculine ; --auto
lin marine_A = mkA "marí" ; --auto
lin marine_N = mkN "marina" feminine ; --auto
lin marital_A = mkA "marital" ; --auto
lin maritime_A = mkA "marítim" ; --auto
lin mark_N = mkN "marca" feminine ; --auto
lin mark_V2 = mkV2 (mkV "marcar") ;
lin mark_V3 = mkV3 (mkV "marcar") ParadigmsCat.accusative (mkPrep "amb") ;
lin mark_down_V2 = prepV2 (lin V OP_mark_V2) OP_down_Prep ; -- guess-p-verb
lin mark_down_as_V3 = variants {} ; -- guess-p-verb
lin mark_off_V2 = prepV2 (lin V OP_mark_V2) OP_off_Prep ; -- guess-p-verb
lin mark_out_V2 = prepV2 (lin V OP_mark_V2) OP_out_Prep ; -- guess-p-verb
lin mark_out_for_V3 = variants {} ; -- guess-p-verb
lin mark_out_from_V3 = variants {} ; -- guess-p-verb
lin mark_up_V2 = prepV2 (lin V OP_mark_V2) OP_up_Prep ; -- guess-p-verb
lin marked_A = mkA "marcat" ; --auto
lin market_1_N = mkN "mercat" masculine ;
lin market_2_N = mkN "mercat" masculine ;
lin marketable_A = mkA "vendible" ; --auto
lin marketing_N = mkN "màrqueting" masculine ; --auto
lin marmot_N = mkN "marmota" feminine ; --auto
lin marquee_N = mkN "envelat" masculine ; --auto
lin marquess_N = mkN "marquès" masculine ; --auto
lin marquetry_N = mkN "marqueteria" feminine ; --auto
lin marquis_N = mkN "marquès" masculine ; --auto
lin marriage_N = mkN "casament" masculine ;
lin married_A = mkA "casat" ; --auto
lin marry_V = reflV (mkV "casar") ;
lin marry_V2 = mkV2 (reflV (mkV "casar")) (mkPrep "amb") ;
lin marry_in_V = advV OP_marry_V OP_in_Adv ; -- guess-p-verb
lin marry_out_V = advV OP_marry_V OP_out_Adv ; -- guess-p-verb
lin marsh_N = mkN "pantà" masculine ; --auto
lin marshal_N = mkN "mariscal" masculine ; --auto
lin marsupial_N = mkN "marsupial" masculine ; --auto
lin marsupium_N = mkN "marsupi" masculine ; --auto
lin marten_N = mkN "marta" feminine ; --auto
lin martensite_N = mkN "martensita" feminine ; --auto
lin martial_A = mkA "marcial" ; --auto
lin martingale_N = mkN "martingala" feminine ; --auto
lin martyr_N = mkN "màrtir" ; --auto
lin martyrdom_N = mkN "martiri" masculine ; --auto
lin marvellous_A = mkA "meravellós" ; --auto
lin marxism_N = mkN "marxisme" masculine ; --auto
lin marxistFem_N = variants {} ; ---- sense to be split
lin marxistMasc_N = variants {} ; ---- sense to be split
lin mascara_N = mkN "rímmel" masculine ; --auto
lin masculine_A = mkA "masculí" ; --auto
lin masculinity_N = mkN "masculinitat" feminine ; --auto
lin maser_N = mkN "màser" masculine ; --auto
lin mash_V2 = mkV2 "amassar" ; --auto
lin mask_N = mkN "màscara" feminine ; --auto
lin mask_V2 = mkV2 "emmascarar" ; --auto
lin masking_N = mkN "emmascarament" masculine ; --auto
lin masochism_N = mkN "masoquisme" masculine ; --auto
lin masochist_N = mkN "masoquista" ; --auto
lin masochistic_A = mkA "masoquista" ; --auto
lin masonry_N = mkN "maçoneria" feminine ; --auto
lin mass_1_N = mkN "massa" feminine ; --auto
lin mass_2_N = mkN "massa" feminine ; --auto
lin mass_3_N = mkN "massa" feminine ; --auto
lin mass_V = mkV "concentrar" ; --auto
lin mass_V2 = mkV2 "concentrar" ; --auto
lin massacre_N = mkN "massacre" feminine ; --auto
lin massage_N = mkN "massatge" masculine ; --auto
lin masseter_N = mkN "masseter" masculine ; --auto
lin massive_A = mkA "massiu" ; --auto
lin mastectomy_N = mkN "mastectomia" feminine ; --auto
lin master_1_N = mkN "amo" ;
lin master_2_N = mkN "director" ;
lin masterpiece_N = mkN "obra mestra" feminine ; --auto
lin mastic_N = mkN "màstic" masculine ; --auto
lin mastication_N = mkN "masticació" feminine ; --auto
lin mastiff_N = mkN "mastí" masculine ; --auto
lin mastodon_N = mkN "mastodont" masculine ; --auto
lin mastoidectomy_N = mkN "mastoïdectomia" feminine ; --auto
lin mastopathy_N = mkN "mastopatia" feminine ; --auto
lin masturbation_N = mkN "masturbació" feminine ; --auto
lin mat_A = mkA "mat" ; --auto
lin mat_N = mkN "estora" feminine ; --auto
lin match_1_N = mkN "partit" masculine ;
lin match_2_N = mkN "misto" masculine ;
lin match_3_N = mkN "coincidència" feminine ;
lin match_up_V = advV (lin V OP_match_V2) OP_up_Adv ; -- guess-p-verb
lin mateFem_1_N = variants {} ; ---- sense to be split
lin mateFem_2_N = variants {} ; ---- sense to be split
lin mateMasc_1_N = variants {} ; ---- sense to be split
lin mateMasc_2_N = variants {} ; ---- sense to be split
lin mate_N = mkN "company" | mkN "mat" masculine ; --auto
lin material_A = mkA "material" ; --auto
lin material_N = mkN "material" masculine ;
lin materialism_N = mkN "materialisme" masculine ; --auto
lin materiality_N = mkN "materialitat" feminine ; --auto
lin maternal_A = mkA "maternal" ; --auto
lin math_N = mkN "matemàtiques" feminine | mkN "matemàtiques" feminine ; --auto
lin mathematical_A = mkA "matemàtic" ; --auto
lin mathematicianFem_N = variants {} ; ---- sense to be split
lin mathematicianMasc_N = variants {} ; ---- sense to be split
lin mathematics_N = mkN "matemàtica" feminine | mkN "matemàtiques" feminine | mkN "matemàtiques" feminine ; --auto
lin maths_N = mkN "matemàtiques" feminine | mkN "matemàtiques" feminine ; --auto
lin matriarchy_N = mkN "matriarcat" masculine ; --auto
lin matricide_N = mkN "matricidi" masculine ; --auto
lin matrilineal_A = mkA "matrilineal" ; --auto
lin matrimonial_A = mkA "matrimonial" ; --auto
lin matrix_N = mkN "matriu" feminine ; --auto
lin matron_N = mkN "matrona" feminine ; --auto
lin matt_A = mkA "mat" ; --auto
lin matter_1_N = mkN "assumpte" masculine ; --split "matèria" topic vs. physical matter
lin matter_2_N = mkN "assumpte" masculine ; --split "matèria" topic vs. physical matter
lin matter_V = mkV "importar" ; --auto
lin mattress_N = mkN "matalàs" masculine ; --auto
lin mature_A = mkA "madur" ; --auto
lin mature_V = mkV "madurar" ; --auto
lin mature_V2 = mkV2 "madurar" ; --auto
lin maturity_1_N = variants {} ; ---- sense to be split
lin maturity_2_N = variants {} ; ---- sense to be split
lin maturity_3_N = variants {} ; ---- sense to be split
lin matutinal_A = mkA "matutí" ; --auto
lin mauritanian_A = mkA "maurità" ; --auto
lin mausoleum_N = mkN "mausoleu" masculine ; --auto
lin maverick_N = mkN "dissident" ; --auto
lin maxillary_A = mkA "maxil·lar" ; --auto
lin maxim_N = mkN "màxima" feminine ; --auto
lin maximal_A = mkA "màxim" ; --auto
lin maximum_A = mkA "màxim" ; --auto
lin maximum_N = mkN "màxim" masculine ; --auto
lin maxwell_N = mkN "maxwell" masculine ; --auto
lin may_1_VV = variants {} ; ---- sense to be split
lin may_2_VV = variants {} ; ---- sense to be split
lin maybe_Adv = mkAdv "potser" ;
lin mayonnaise_N = mkN "maionesa" feminine ; --auto
lin mayor_N = mkN "alcalde" feminine | mkN "alcalde" masculine ; --auto
lin mead_N = mkN "aiguamel" feminine ; --auto
lin meadow_N = mkN "prat" masculine ; --auto
lin meal_N = mkN "àpat" masculine ;
lin mean_A = mkA "roí" ; --auto
lin mean_V2 = mkV2 (verbV (voler_120 "voler")) ; --subcat "vull dir que"
lin mean_V2V = mkV2V (verbV (voler_120 "voler")) ParadigmsCat.accusative ParadigmsCat.dative ; --subcat
lin mean_VS = mkVS (verbV (voler_120 "voler")) ; --subcat "vull dir que"
lin mean_VV = mkVV (mkV "pensar") ; -- "tenia la intenció de"
lin meander_N = mkN "meandre" masculine ; --auto
lin meander_V = mkV "serpejar" ; --auto
lin meaning_N = mkN "sentit" masculine ;
lin meaningful_A = mkA "significatiu" ; --auto
lin meaningless_A = mkA "sense sentit" ; --auto
lin means_N = mkN "mitjà" masculine ;
lin meantime_Adv = mkAdv "mentrestant" ; --auto
lin meanwhile_Adv = mkAdv "entretant" | mkAdv "mentrestant" ; --auto
lin measurable_A = mkA "mesurable" ; --auto
lin measure_N = mkN "mesura" feminine ;
lin measure_V = mkV "mesurar" ;
lin measure_V2 = mkV2 (mkV "mesurar") ;
lin measure_against_V3 = variants {} ; -- guess-p-verb
lin measure_off_V2 = prepV2 OP_measure_V OP_off_Prep ; -- guess-p-verb
lin measure_out_V2 = prepV2 OP_measure_V OP_out_Prep ; -- guess-p-verb
lin measure_up_V = advV OP_measure_V OP_up_Adv ; -- guess-p-verb
lin measure_up_V2 = prepV2 OP_measure_V OP_up_Prep ; -- guess-p-verb
lin measure_up_to_V2 = prepV2 (advV OP_measure_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin measurement_N = mkN "mesurament" masculine | mkN "mida" feminine ; --auto
lin measurer_N = mkN "mesurador" masculine ; --auto
lin meat_N = L.meat_N ;
lin meatball_N = mkN "mandonguilla" feminine ; --auto
lin meatus_N = mkN "meat" masculine ; --auto
lin mechanic_N = mkN "mecànic" feminine | mkN "mecànic" masculine ; --auto
lin mechanical_A = mkA "mecànic" ; --auto
lin mechanics_N = mkN "mecànica" feminine ; --auto
lin mechanism_N = mkN "mecanisme" masculine ; --auto
lin meconium_N = mkN "meconi" masculine ; --auto
lin medal_N = mkN "medalla" feminine ; --auto
lin medallion_N = mkN "medalló" masculine ; --auto
lin media_N = compN (mkN "mitjà") "de comunicació" ;
lin mediaeval_A = mkA "medieval" ; --auto
lin medial_A = mkA "medial" ; --auto
lin mediastinum_N = mkN "mediastí" masculine ; --auto
lin medical_A = mkA "mèdic" ;
lin medication_N = mkN "medicació" feminine ; --auto
lin medicinal_A = mkA "medicinal" ; --auto
lin medicine_N = mkN "medicament" masculine | mkN "medicina" feminine ; --auto
lin medieval_A = mkA "medieval" ; --auto
lin mediocre_A = mkA "mediocre" ; --auto
lin meditation_N = mkN "meditació" feminine ; --auto
lin mediterranean_A = mkA "mediterrani" ; --auto
lin medium_N = mkN "medi" masculine ; --auto
lin medlar_N = mkN "nespra" feminine ; --auto
lin medullary_A = mkA "medul·lar" ; --auto
lin meet_V = verbV (conèixer_27 "conèixer") ;
lin meet_V2 = mkV2 (verbV (conèixer_27 "conèixer")) ;
lin meet_up_V = advV OP_meet_V OP_up_Adv ; -- guess-p-verb
lin meet_with_V2 = prepV2 OP_meet_V OP_with_Prep ; -- guess-p-verb
lin meeting_N = mkN "reunió" feminine ; --split "trobada" (business vs. generic)
lin megabit_N = mkN "megabit" masculine ; --auto
lin megabyte_N = mkN "megaoctet" masculine ; --auto
lin megacolon_N = mkN "megacòlon" masculine ; --auto
lin megakaryocyte_N = mkN "megacariòcit" masculine ; --auto
lin megalith_N = mkN "megàlit" masculine ; --auto
lin megalithic_A = mkA "megalític" ; --auto
lin megaloblast_N = mkN "megaloblast" masculine ; --auto
lin megalocyte_N = mkN "megalòcit" masculine ; --auto
lin megalomania_N = mkN "megalomania" feminine ; --auto
lin megalopolis_N = mkN "megalòpoli" masculine ; --auto
lin megaphone_N = mkN "megàfon" masculine ; --auto
lin megaton_N = mkN "megatón" masculine ; --auto
lin meiosis_N = mkN "meiosi" feminine ; --auto
lin meiotic_A = mkA "meiòtic" ; --auto
lin melamine_N = mkN "melamina" feminine ; --auto
lin melancholic_A = mkA "malenconiós" ; --auto
lin melange_N = mkN "barreja" feminine ; --auto
lin melanin_N = mkN "melanina" feminine ; --auto
lin melanocyte_N = mkN "melanòcit" masculine ; --auto
lin melanoderma_N = mkN "melanodèrmia" feminine ; --auto
lin melanoma_N = mkN "melanoma" masculine ; --auto
lin melanosis_N = mkN "melanosi" feminine ; --auto
lin mellow_A = mkA "dolç" ; --auto
lin melodic_A = mkA "melòdic" ; --auto
lin melodious_A = mkA "melodiós" ; --auto
lin melodrama_N = mkN "melodrama" masculine ; --auto
lin melodramatic_A = mkA "melodramatic" ; --auto
lin melody_N = mkN "melodia" feminine ; --auto
lin melon_N = mkN "meló" masculine ; --auto
lin melt_V = mkV "fondre" ; --auto
lin melt_V2 = mkV2 "fondre" ; --auto
lin melting_pot_N = mkN "gresol" masculine ; --auto
lin member_N = mkN "membre" masculine ;
lin membership_N = mkN "afiliació" feminine ; --auto
lin membrane_N = mkN "membrana" feminine ; --auto
lin membranous_A = mkA "membranós" ; --auto
lin memorandum_N = mkN "memoràndum" masculine ; --auto
lin memorial_N = mkN "memorial" masculine ; --auto
lin memory_N = mkN "memòria" feminine ;
lin menarche_N = mkN "menarquia" feminine ; --auto
lin mend_V = mkV "sargir" ; --auto
lin mend_V2 = mkV2 "sargir" ; --auto
lin mendelevium_N = mkN "mendelevi" masculine ; --auto
lin menhir_N = mkN "menhir" masculine ; --auto
lin meningocele_N = mkN "meningocele" masculine ; --auto
lin meniscus_N = mkN "menisc" masculine ; --auto
lin menopause_N = mkN "menopausa" feminine ; --auto
lin menorrhagia_N = mkN "menorràgia" feminine ; --auto
lin menstruation_N = mkN "menstruació" feminine ; --auto
lin mental_A = mkA "mental" ; --auto
lin mentality_N = mkN "mentalitat" feminine ; --auto
lin menthol_N = mkN "mentol" masculine ; --auto
lin mention_V = mkV "mencionar" ;
lin mention_V2 = mkV2 (mkV "mencionar") ;
lin mention_VS = mkVS (mkV "mencionar") ;
lin mentor_N = mkN "mentor" | mkN "mentor" ; --auto
lin menu_N = mkN "carta" feminine | mkN "menú" masculine ; --auto
lin meralgia_N = mkN "meràlgia" feminine ; --auto
lin mercantile_A = mkA "mercantil" ; --auto
lin mercenary_N = mkN "mercenari" | mkN "mercenari" ; --auto
lin merciless_A = mkA "despietat" ; --auto
lin mercury_N = mkN "mercuri" masculine ; --auto
lin mercy_N = mkN "pietat" feminine ; --auto
lin mere_A = mkA "mer" ; --auto
lin merge_V = mkV "fusionar" ; --auto
lin merge_V2 = mkV2 "fusionar" ; --auto
lin merger_N = mkN "fusió" feminine ; --auto
lin meridian_A = mkA "meridià" ; --auto
lin meridian_N = mkN "meridià" masculine ; --auto
lin meridional_A = mkA "meridional" ; --auto
lin meristem_N = mkN "meristema" masculine ; --auto
lin merit_N = mkN "mèrit" masculine ; --auto
lin merit_V2 = mkV2 "meritar" ; --auto
lin merry_A = mkA "alegre" ; --auto
lin mesenchyme_N = mkN "mesènquima" masculine ; --auto
lin mesenteric_A = mkA "mesentèric" ; --auto
lin mesentery_N = mkN "mesenteri" masculine ; --auto
lin mesh_V = mkV "engranar" ; --auto
lin mesh_V2 = mkV2 "engranar" ; --auto
lin mesocarp_N = mkN "mesocarpi" masculine ; --auto
lin mesocolon_N = mkN "mesocòlon" masculine ; --auto
lin mesoderm_N = mkN "mesoderma" masculine ; --auto
lin meson_N = mkN "mesó" masculine ; --auto
lin mesophyte_N = mkN "mesòfit" masculine ; --auto
lin mesosphere_N = mkN "mesosfera" feminine ; --auto
lin mess_N = mkN "desordre" masculine ; --auto
lin message_N = mkN "missatge" masculine ;
lin messenger_N = mkN "missatger" | mkN "missatger" ; --auto
lin metabolic_A = mkA "metabòlic" ; --auto
lin metabolism_N = mkN "metabolisme" masculine ; --auto
lin metabolite_N = mkN "metabòlit" masculine ; --auto
lin metacarpus_N = mkN "metacarp" masculine ; --auto
lin metacentric_A = mkA "metacèntric" ; --auto
lin metal_N = mkN "metall" masculine ; --auto
lin metalanguage_N = mkN "metallenguatge" masculine ; --auto
lin metallic_A = mkA "metàl·lic" ; --auto
lin metallurgical_A = mkA "metal·lúrgic" ; --auto
lin metallurgist_N = mkN "metal·lúrgic" feminine | mkN "metal·lúrgic" masculine ; --auto
lin metallurgy_N = mkN "metal·lúrgia" feminine ; --auto
lin metamorphic_A = mkA "metamòrfic" ; --auto
lin metamorphism_N = mkN "metamorfisme" masculine ; --auto
lin metamorphosis_N = mkN "metamorfosi" feminine ; --auto
lin metaphase_N = mkN "metafase" feminine ; --auto
lin metaphor_N = mkN "metàfora" feminine ; --auto
lin metaphorical_A = mkA "metafòric" ; --auto
lin metaphysical_A = mkA "metafísic" ; --auto
lin metaphysics_N = mkN "metafísica" feminine ; --auto
lin metaphysis_N = mkN "metàfisi" feminine ; --auto
lin metastable_A = mkA "metastable" ; --auto
lin metastasis_N = mkN "metàstasi" feminine ; --auto
lin metatarsus_N = mkN "metatars" masculine ; --auto
lin metathesis_N = mkN "metàtesi" feminine ; --auto
lin meteor_N = mkN "meteor" masculine ; --auto
lin meteoric_A = mkA "meteòric" ; --auto
lin meteorite_N = mkN "meteorit" masculine ; --auto
lin meteorological_A = mkA "meteorològic" ; --auto
lin meteorologist_N = mkN "meteoròleg" | mkN "meteoròleg" ; --auto
lin meteorology_N = mkN "meteorologia" feminine ; --auto
lin methane_N = mkN "metà" masculine ; --auto
lin methanol_N = mkN "metanol" masculine ; --auto
lin methionine_N = mkN "metionina" feminine ; --auto
lin method_N = mkN "mètode" masculine ;
lin methodical_A = mkA "metòdic" ; --auto
lin methodological_A = mkA "metodològic" ; --auto
lin methodology_N = mkN "metodologia" feminine ; --auto
lin methyl_N = mkN "metil" masculine ; --auto
lin metonymic_A = mkA "metonímic" ; --auto
lin metonymy_N = mkN "metonímia" feminine ; --auto
lin metopion_N = mkN "metopi" masculine ; --auto
lin metre_N = mkN "metre" masculine ; --auto
lin metric_A = mkA "mètric" ; --auto
lin metrology_N = mkN "metrologia" feminine ; --auto
lin metronome_N = mkN "metrònom" masculine ; --auto
lin metropolis_N = mkN "metròpoli" masculine ; --auto
lin metropolitan_A = mkA "metropolità" ; --auto
lin metroptosis_N = mkN "metroptosi" feminine ; --auto
lin metrorrhagia_N = mkN "metrorràgia" feminine ; --auto
lin mexican_A = mkA "mexicà" ; --auto
lin mexican_N = mkN "mexicà" | mkN "mexicà" ; --auto
lin mezzanine_N = mkN "entresol" masculine ; --auto
lin micelle_N = mkN "micel·la" feminine ; --auto
lin microbalance_N = mkN "microbalança" feminine ; --auto
lin microbe_N = mkN "microbi" masculine ; --auto
lin microbial_A = mkA "microbià" ; --auto
lin microbiologist_N = mkN "microbiòleg" feminine | mkN "microbiòleg" masculine ; --auto
lin microbiology_N = mkN "microbiologia" feminine ; --auto
lin microcephaly_N = mkN "microcefàlia" feminine ; --auto
lin microcrystalline_A = mkA "microcristal·lí" ; --auto
lin microcyte_N = mkN "micròcit" masculine ; --auto
lin microfilm_N = mkN "microfilm" masculine ; --auto
lin microglia_N = mkN "micròglia" feminine ; --auto
lin micrometer_N = mkN "micròmetre" masculine ; --auto
lin micron_N = mkN "micró" masculine ; --auto
lin microorganism_N = mkN "microorganisme" masculine ; --auto
lin microphone_N = mkN "micròfon" masculine ; --auto
lin microphotometer_N = mkN "microfotòmetre" masculine ; --auto
lin microprocessor_N = mkN "microprocessador" masculine ; --auto
lin micropyle_N = mkN "micròpil" masculine ; --auto
lin microscope_N = mkN "microscopi" masculine ; --auto
lin microscopic_A = mkA "microscòpic" ; --auto
lin microscopy_N = mkN "microscòpia" feminine ; --auto
lin microsecond_N = mkN "microsegon" masculine ; --auto
lin microsome_N = mkN "microsoma" masculine ; --auto
lin microtubule_N = mkN "microtúbul" masculine ; --auto
lin microwave_N = mkN "microones" masculine | mkN "microones" masculine ; --auto
lin midday_N = mkN "migdia" masculine | mkN "migjorn" masculine ; --auto
lin middle_N = mkN "mig" masculine ; --auto
lin middlemanFem_N = variants {} ; ---- sense to be split
lin middlemanMasc_N = variants {} ; ---- sense to be split
lin midnight_N = mkN "mitjanit" feminine ; --auto
lin midway_Adv = mkAdv "a mig camí" ; --auto
lin midwife_N = mkN "llevadora" feminine ; --auto
lin migraine_N = mkN "migranya" feminine ; --auto
lin migrant_A = mkA "emigrant" ; --auto
lin migrate_V = mkV "emigrar" | mkV "migrar" ; --auto
lin migration_N = mkN "migració" feminine ; --auto
lin migratory_A = mkA "migrador" | mkA "migratori" ; --auto
lin mild_A = mkA "suau" ; --auto
lin mildew_N = mkN "míldiu" masculine ; --auto
lin mile_N = mkN "milla" feminine ;
lin milestone_N = mkN "fita" feminine ; --auto
lin militant_A = mkA "militant" ; --auto
lin militant_N = mkN "militant" ; --auto
lin militarism_N = mkN "militarisme" masculine ; --auto
lin militarist_N = mkN "militarista" ; --auto
lin militaristic_A = mkA "militarista" ; --auto
lin military_A = mkA "militar" ;
lin military_N = mkN "exèrcit" masculine ; --auto
lin militia_N = mkN "milícia" feminine ; --auto
lin milk_N = L.milk_N ;
lin milk_V = mkV "munyir" ; --auto
lin milk_V2 = mkV2 "munyir" ; --auto
lin milkmaid_N = mkN "lletera" feminine ; --auto
lin milky_A = mkA "lletós" ; --auto
lin mill_N = mkN "molí" masculine ; --auto
lin mill_V = mkV "fresar" ; --auto
lin mill_V2 = mkV2 "fresar" ; --auto
lin millennium_N = mkN "mil·lenni" masculine ; --auto
lin millet_N = mkN "mill" masculine ; --auto
lin milliampere_N = mkN "mil·liampere" masculine ; --auto
lin milliequivalent_N = mkN "mil·liequivalent" masculine ; --auto
lin milligram_N = mkN "mil·ligram" masculine ; --auto
lin millimetre_N = mkN "mil·límetre" masculine ; --auto
lin milliner_N = mkN "capeller" feminine | mkN "capeller" masculine ; --auto
lin milling_N = mkN "fresatge" masculine ; --auto
lin million_N = mkN "milió" masculine ; --auto
lin millionaire_N = mkN "milionari" | mkN "milionari" ; --auto
lin millipede_N = mkN "milpeus" masculine | mkN "milpeus" masculine ; --auto
lin millisecond_N = mkN "mil·lisegon" masculine ; --auto
lin millivolt_N = mkN "mil·livolt" masculine ; --auto
lin mimosa_N = mkN "mimosa" feminine ; --auto
lin minaret_N = mkN "minaret" masculine ; --auto
lin mince_V = mkV "trinxar" ; --auto
lin mince_V2 = mkV2 "trinxar" ; --auto
lin mind_N = mkN "ment" feminine ;
lin mind_V = mkV "importar" ; --auto
lin mind_V2 = mkV2 (reflV (mkV "importar")) ; --split "anar amb compte amb"
lin mind_VS = mkVS (reflV (mkV "importar")) ;
lin minder_N = mkN "guardador" feminine | mkN "guardador" masculine ; --auto
lin mine_A = mkA "meu" ; --auto
lin mine_N = mkN "mina" feminine ; --auto
lin miner_N = mkN "miner" | mkN "miner" ; --auto
lin mineral_A = mkA "mineral" ; --auto
lin mineral_N = mkN "mineral" masculine ; --auto
lin mineralogist_N = mkN "mineralogista" ; --auto
lin mineralogy_N = mkN "mineralogia" feminine ; --auto
lin minesweeper_N = mkN "pescamines" masculine | mkN "pescamines" masculine ; --auto
lin miniature_N = mkN "miniatura" feminine ; --auto
lin minibus_N = mkN "minibús" masculine ; --auto
lin minicomputer_N = mkN "miniordinador" masculine ; --auto
lin minim_N = mkN "blanca" feminine ; --auto
lin minimal_A = mkA "mínim" ; --auto
lin minimum_A = mkA "mínim" ; --auto
lin minimum_N = mkN "mínim" masculine ; --auto
lin minion_N = mkN "minyona" feminine ; --auto
lin minister_1_N = mkN "ministre" ;
lin minister_2_N = mkN "ministre" ;
lin ministerial_A = mkA "ministerial" ; --auto
lin ministry_N = mkN "ministeri" masculine ; --auto
lin mink_N = mkN "visó" masculine ; --auto
lin minor_A = mkA "menor" ; --auto
lin minor_N = mkN "menor" ; --auto
lin minority_N = mkN "minoria" feminine ; --auto
lin minotaur_N = mkN "minotaure" masculine ; --auto
lin mint_N = mkN "menta" feminine ; --auto
lin minuend_N = mkN "minuend" masculine ; --auto
lin minuet_N = mkN "minuet" masculine ; --auto
lin minus_Prep = mkPrep "menys" ; --auto
lin minute_N = mkN "minut" masculine ;
lin miracle_N = mkN "miracle" masculine ; --auto
lin mirage_N = mkN "miratge" masculine ; --auto
lin mirror_N = mkN "espill" masculine | mkN "mirall" masculine ; --auto
lin misalignment_N = mkN "desalineació" feminine ; --auto
lin misanthrope_N = mkN "misantrop" feminine | mkN "misantrop" masculine ; --auto
lin misanthropy_N = mkN "misantropia" feminine ; --auto
lin miscible_A = mkA "miscible" ; --auto
lin misconception_N = mkN "error" masculine ; --auto
lin miserable_A = mkA "desgraciat" | mkA "miserable" ; --auto
lin misfortune_N = mkN "desgràcia" feminine | mkN "misèria" feminine ; --auto
lin misgovernment_N = mkN "desgovern" masculine ; --auto
lin mishap_N = mkN "contratemps" masculine | mkN "contratemps" masculine ; --auto
lin misogyny_N = mkN "misogínia" feminine ; --auto
lin misology_N = mkN "misologia" feminine ; --auto
lin miss_V = mkV "fallar" ;
lin miss_V2 = mkV2 (mkV "fallar") ; --split "enyorar"/"trobar a flatar" (hit and miss vs. miss sosomeone)
lin miss_out_V = advV OP_miss_V OP_out_Adv ; -- guess-p-verb
lin miss_out_V2 = prepV2 OP_miss_V OP_out_Prep ; -- guess-p-verb
lin miss_out_on_V2 = prepV2 (advV OP_miss_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin missile_N = mkN "míssil" masculine ; --auto
lin missing_A = mkA "desaparegut" ; --auto
lin mission_N = mkN "missió" feminine ; --auto
lin missionary_A = mkA "missioner" ; --auto
lin mist_N = mkN "boirina" feminine ; --auto
lin mistake_N = mkN "equivocació" feminine ; --auto
lin mistaken_A = mkA "equivocat" ; --auto
lin mistletoe_N = mkN "vesc" masculine ; --auto
lin mistral_N = mkN "mestral" masculine ; --auto
lin misunderstanding_N = mkN "malentès" masculine ; --auto
lin misuse_N = mkN "abús" masculine ; --auto
lin mitigate_V2 = mkV2 "mitigar" ; --auto
lin mitigation_N = mkN "atenuació" feminine ; --auto
lin mitochondrial_A = mkA "mitocondrial" ; --auto
lin mitochondrion_N = mkN "mitocondri" masculine ; --auto
lin mitosis_N = mkN "mitosi" feminine ; --auto
lin mitotic_A = mkA "mitòtic" ; --auto
lin mitre_N = mkN "mitra" feminine ; --auto
lin mitten_N = mkN "mitena" feminine ; --auto
lin mix_N = mkN "barreja" feminine ; --auto
lin mix_V = mkV "barrejar" ; --auto
lin mix_V2 = mkV2 "barrejar" ; --auto
lin mix_up_V2 = prepV2 OP_mix_V OP_up_Prep ; -- guess-p-verb
lin mixed_A = mkA "mixt" ; --auto
lin mixture_N = mkN "mescla" feminine ; --auto
lin mnemonic_A = mkA "mnemònic" | mkA "mnemotècnic" ; --auto
lin moan_N = mkN "gemec" masculine ; --auto
lin mob_N = mkN "trepa" feminine ; --auto
lin mobile_A = mkA "mòbil" ; --auto
lin mobile_N = mkN "mòbil" masculine ; --auto
lin mobility_N = mkN "mobilitat" feminine ; --auto
lin mock_A = mkA "simulat" ; --auto
lin mockery_N = mkN "burla" feminine ; --auto
lin modal_A = mkA "modal" ; --auto
lin mode_N = mkN "moda" feminine | mkN "mode" masculine ; --auto
lin model_N = mkN "model" ;
lin modeller_N = mkN "modelador" feminine | mkN "modelador" masculine ; --auto
lin modelling_N = mkN "modelat" masculine ; --auto
lin modem_N = mkN "mòdem" masculine ; --auto
lin moderate_V = mkV "moderar" ; --auto
lin moderate_V2 = mkV2 "moderar" ; --auto
lin moderation_N = mkN "moderació" feminine ; --auto
lin modern_A = mkA "modern" ;
lin modernism_N = mkN "modernisme" masculine ; --auto
lin modest_A = mkA "modest" ; --auto
lin modesty_N = mkN "modèstia" feminine ; --auto
lin modifiable_A = mkA "modificable" ; --auto
lin modification_N = mkN "modificació" feminine ; --auto
lin modifier_N = mkN "modificador" feminine | mkN "modificador" masculine ; --auto
lin modify_V2 = mkV2 "modificar" ; --auto
lin modiolus_N = mkN "modíol" masculine ; --auto
lin modular_A = mkA "modular" ; --auto
lin modulate_V = mkV "modular" ; --auto
lin modulate_V2 = mkV2 "modular" ; --auto
lin modulation_N = mkN "modulació" feminine ; --auto
lin module_N = mkN "mòdul" masculine ; --auto
lin moistening_N = mkN "humidificació" feminine ; --auto
lin molality_N = mkN "molalitat" feminine ; --auto
lin molar_A = mkA "molar" ; --auto
lin molarity_N = mkN "molaritat" feminine ; --auto
lin molasses_N = mkN "melassa" feminine ; --auto
lin mole_N = mkN "mol" masculine | mkN "talp" masculine ; --auto
lin molecular_A = mkA "molecular" ; --auto
lin molecule_N = mkN "molècula" feminine ; --auto
lin mollusc_N = mkN "mol·lusc" masculine ; --auto
lin molybdenum_N = mkN "molibdè" masculine ; --auto
lin moment_N = mkN "moment" masculine ;
lin momentary_A = mkA "momentani" ; --auto
lin momentum_N = mkN "moment" masculine ; --auto
lin monad_N = mkN "mònade" masculine ; --auto
lin monarch_N = mkN "monarca" ; --auto
lin monarchic_A = mkA "monàrquic" ; --auto
lin monarchism_N = mkN "monarquisme" masculine ; --auto
lin monarchist_N = mkN "monàrquic" | mkN "monàrquic" ; --auto
lin monarchy_N = mkN "monarquia" feminine ; --auto
lin monastery_N = mkN "monestir" masculine ; --auto
lin monaural_A = mkA "monofònic" ; --auto
lin monegasque_A = mkA "monegasc" ; --auto
lin monetarism_N = mkN "monetarisme" masculine ; --auto
lin monetary_A = mkA "monetari" ; --auto
lin money_N = mkN "diners" "diners" masculine ;
lin mongolian_A = mkA "mongol" ; --auto
lin mongolian_N = mkN "mongol" | mkN "mongol" ; --auto
lin mongrel_A = mkA "mestís" ; --auto
lin monism_N = mkN "monisme" masculine ; --auto
lin monitor_N = mkN "monitor" masculine ; --auto
lin monitor_V = mkV "controlar" ; --auto
lin monitor_V2 = mkV2 "controlar" ; --auto
lin monitoring_N = mkN "control" masculine ; --auto
lin monk_N = mkN "monjo" masculine ; --auto
lin monkey_N = mkN "mona" feminine ; --auto
lin monkey_wrench_N = mkN "clau anglesa" feminine ; --auto
lin monoblast_N = mkN "monoblast" masculine ; --auto
lin monochromatic_A = mkA "monocromàtic" ; --auto
lin monochrome_A = mkA "monocrom" ; --auto
lin monocle_N = mkN "monocle" masculine ; --auto
lin monoclinic_A = mkA "monoclínic" ; --auto
lin monoculture_N = mkN "monocultura" feminine ; --auto
lin monocyte_N = mkN "monòcit" masculine ; --auto
lin monocytosis_N = mkN "monocitosi" feminine ; --auto
lin monogamy_N = mkN "monogàmia" feminine ; --auto
lin monogenesis_N = mkN "monogènesi" feminine ; --auto
lin monogram_N = mkN "monograma" masculine ; --auto
lin monograph_N = mkN "monografia" feminine ; --auto
lin monolingual_A = mkA "monolingüe" ; --auto
lin monolith_N = mkN "monòlit" masculine ; --auto
lin monolithic_A = mkA "monolític" ; --auto
lin monologue_N = mkN "monòleg" masculine ; --auto
lin monomer_N = mkN "monòmer" masculine ; --auto
lin monopolist_N = mkN "monopolitzador" | mkN "monopolitzador" ; --auto
lin monopolistic_A = mkA "monopolitzador" ; --auto
lin monopoly_N = mkN "monopoli" masculine ; --auto
lin monorail_N = mkN "monocarril" masculine ; --auto
lin monosaccharide_N = mkN "monosacàrid" masculine ; --auto
lin monosemy_N = mkN "monosèmia" feminine ; --auto
lin monosyllabic_A = mkA "monosíl·lab" ; --auto
lin monosyllable_N = mkN "monosíl·lab" masculine ; --auto
lin monotheism_N = mkN "monoteisme" masculine ; --auto
lin monotheistic_A = mkA "monoteista" ; --auto
lin monotreme_N = mkN "monotrema" masculine ; --auto
lin monotype_N = mkN "monotípia" feminine ; --auto
lin monoxide_N = mkN "monòxid" masculine ; --auto
lin monsoon_N = mkN "monsó" masculine ; --auto
lin monster_N = mkN "monstre" masculine ; --auto
lin monstrosity_N = mkN "monstruositat" feminine ; --auto
lin month_N = mkN "mes" masculine ;
lin monthly_A = mkA "mensual" ; --auto
lin monument_N = mkN "monument" masculine ; --auto
lin monumental_A = mkA "monumental" ; --auto
lin mood_N = mkN "humor" masculine | mkN "mode" masculine ; --auto
lin moon_N = L.moon_N ;
lin moor_N = mkN "erm" masculine ; --auto
lin mooring_N = mkN "amarratge" masculine ; --auto
lin moped_N = mkN "ciclomotor" masculine ; --auto
lin moraine_N = mkN "morena" feminine ; --auto
lin moral_A = mkA "moral" ; --auto
lin moral_N = mkN "moralitat" feminine ; --auto
lin morality_N = mkN "moralitat" feminine ; --auto
lin moratorium_N = mkN "moratòria" feminine ; --auto
lin more_Adv = mkAdv "més" ;
lin moreover_Adv = mkAdv "a més" ; --auto
lin morganatic_A = mkA "morganàtic" ; --auto
lin morganite_N = mkN "morganita" feminine ; --auto
lin morning_N = mkN "matí" masculine ;
lin moroccan_A = mkA "marroquí" ; --auto
lin moroccan_N = mkN "marroquí" | mkN "marroquí" ; --auto
lin morpheme_N = mkN "morfema" masculine ; --auto
lin morphemic_A = mkA "morfèmic" ; --auto
lin morphine_N = mkN "morfina" feminine ; --auto
lin morphogenesis_N = mkN "morfogènesi" feminine ; --auto
lin morphological_A = mkA "morfològic" ; --auto
lin morphology_N = mkN "morfologia" feminine ; --auto
lin morphophoneme_N = mkN "morfofonema" masculine ; --auto
lin morse_N = mkN "morse" masculine ; --auto
lin mortal_A = mkA "mortal" ; --auto
lin mortality_N = mkN "mortalitat" feminine ; --auto
lin mortar_N = mkN "morter" masculine ; --auto
lin mortarboard_N = mkN "birret" masculine ; --auto
lin mortgage_N = mkN "hipoteca" feminine ; --auto
lin mortgage_V2 = mkV2 "hipotecar" ; --auto
lin mortify_V = mkV "mortificar" ; --auto
lin mortify_V2 = mkV2 "mortificar" ; --auto
lin mortise_N = mkN "mortasa" feminine ; --auto
lin mortise_V2 = mkV2 "mortasar" ; --auto
lin morula_N = mkN "mòrula" feminine ; --auto
lin mosaic_N = mkN "mosaic" masculine ; --auto
lin moscow_1_PN = variants {} ; ---- sense to be split
lin moscow_2_PN = variants {} ; ---- sense to be split
lin mosque_N = mkN "mesquita" feminine ; --auto
lin mosquito_N = mkN "mosquit" masculine ; --auto
lin moss_N = mkN "molsa" feminine ; --auto
lin most_Adv = mkAdv "la majoria de" ;
lin most_Det = mkDet "la majoria de" ;
lin mostly_Adv = mkAdv "majoritàriament" ; --auto
lin motel_N = mkN "motel" masculine ; --auto
lin motet_N = mkN "motet" masculine ; --auto
lin moth_N = mkN "arna" feminine ; --auto
lin mother_N = mkN "mare" feminine ;
lin motherhood_N = mkN "maternitat" feminine ; --auto
lin motion_N = mkN "moció" feminine | mkN "moviment" masculine ; --auto
lin motionless_A = mkA "immòbil" ; --auto
lin motivate_V2 = mkV2 "motivar" ; --auto
lin motivation_N = mkN "motivació" feminine ; --auto
lin motivational_A = mkA "motivacional" ; --auto
lin motor_N = mkN "motor" masculine ; --auto
lin motorbike_N = mkN "moto" feminine ; --auto
lin motorcycle_N = mkN "motocicleta" feminine ; --auto
lin motorcycling_N = mkN "motociclisme" masculine ; --auto
lin motoring_N = mkN "automobilisme" masculine ; --auto
lin motorist_N = mkN "automobilista" ; --auto
lin mould_1_N = mkN "floridura" feminine ; --auto
lin mould_2_N = mkN "floridura" feminine ; --auto
lin mould_3_N = mkN "floridura" feminine ; --auto
lin mount_N = mkN "mont" masculine | mkN "muntura" feminine | mkN "puig" masculine ; --auto
lin mount_V = mkV "muntar" ; --auto
lin mount_V2 = mkV2 "muntar" ; --auto
lin mount_up_V = advV OP_mount_V OP_up_Adv ; -- guess-p-verb
lin mountain_N = L.mountain_N ;
lin mountaineer_N = mkN "alpinista" ; --auto
lin mountaineering_N = mkN "alpinisme" masculine ; --auto
lin mountainous_A = mkA "muntanyós" ; --auto
lin mounting_N = mkN "muntura" feminine ; --auto
lin mouse_N = mkN "ratolí" masculine ; --auto
lin moussaka_N = mkN "mussaca" feminine ; --auto
lin moustache_N = mkN "bigoti" masculine ; --auto
lin mouth_N = L.mouth_N ;
lin movable_A = mkA "movible" ; --auto
lin move_1_V = verbV (moure_72 "moure") ;
lin move_2_V = verbV (moure_72 "moure") ;
lin move_N = mkN "jugada" feminine ;
lin move_V2 = mkV2 (verbV (moure_72 "moure")) ;
lin move_ahead_V = advV OP_move_V OP_ahead_Adv ; -- guess-p-verb
lin move_along_V = advV OP_move_V OP_along_Adv ; -- guess-p-verb
lin move_away_V = advV OP_move_V OP_away_Adv ; -- guess-p-verb
lin move_away_from_V2 = prepV2 (advV OP_move_V OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin move_down_V2 = prepV2 OP_move_V OP_down_Prep ; -- guess-p-verb
lin move_in_V = advV OP_move_V OP_in_Adv ; -- guess-p-verb
lin move_in_on_V2 = prepV2 (advV OP_move_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin move_into_V2 = prepV2 OP_move_V OP_into_Prep ; -- guess-p-verb
lin move_on_V = advV OP_move_V OP_on_Adv ; -- guess-p-verb
lin move_on_V2 = prepV2 OP_move_V OP_on_Prep ; -- guess-p-verb
lin move_out_V = advV OP_move_V OP_out_Adv ; -- guess-p-verb
lin move_out_V2 = prepV2 OP_move_V OP_out_Prep ; -- guess-p-verb
lin move_towards_V2 = prepV2 OP_move_V OP_towards_Prep ; -- guess-p-verb
lin move_up_V = advV OP_move_V OP_up_Adv ; -- guess-p-verb
lin move_up_V2 = prepV2 OP_move_V OP_up_Prep ; -- guess-p-verb
lin movement_N = mkN "moviment" masculine ;
lin movie_N = mkN "pel·lícula" feminine ; --auto
lin moving_A = mkA "emotiu" ; --auto
lin mozambican_A = mkA "moçambiquès" ; --auto
lin much_AdA = mkAdv "gaire" | mkAdv "molt" ; --auto
lin much_Adv = mkAdv "gaire" ;
lin much_Det = S.much_Det ;
lin mucilage_N = mkN "mucílag" masculine ; --auto
lin mucin_N = mkN "mucina" feminine ; --auto
lin mucus_N = mkN "moc" masculine | mkN "mucositat" feminine ; --auto
lin mud_N = mkN "fang" masculine ; --auto
lin muddy_A = mkA "fangós" | mkA "tèrbol" ; --auto
lin muff_N = mkN "maneguí" masculine ; --auto
lin muffle_N = mkN "mufla" feminine ; --auto
lin mulch_N = mkN "jaç" masculine ; --auto
lin mule_N = mkN "mul" masculine ; --auto
lin multicellular_A = mkA "pluricel·lular" ; --auto
lin multidimensional_A = mkA "multidimensional" ; --auto
lin multi_lingual_A = mkA "multilingüe" ; --auto
lin multimedia_N = mkN "multimèdia" feminine ; --auto
lin multiple_A = mkA "múltiple" ; --auto
lin multiple_N = mkN "múltiple" masculine ; --auto
lin multiplex_N = mkN "múltiplex" masculine ; --auto
lin multiplexer_N = mkN "multiplexor" masculine ; --auto
lin multiplicand_N = mkN "multiplicand" masculine ; --auto
lin multiplication_N = mkN "multiplicació" feminine ; --auto
lin multiplicity_N = mkN "multiplicitat" feminine ; --auto
lin multiplier_N = mkN "multiplicador" masculine ; --auto
lin multiply_V = mkV "multiplicar" ; --auto
lin multiply_V2 = mkV2 "multiplicar" ; --auto
lin multiprocessing_N = mkN "multiprocessament" masculine ; --auto
lin multiprocessor_N = mkN "multiprocessador" masculine ; --auto
lin multipurpose_A = mkA "multiús" ; --auto
lin multitudinous_A = mkA "multitudinari" ; --auto
lin mum_N = mkN "mama" feminine ; --auto
lin mummification_N = mkN "momificació" feminine ; --auto
lin mummy_N = mkN "mòmia" feminine ; --auto
lin mumps_N = mkN "galteres" feminine | mkN "galteres" feminine ; --auto
lin mundane_A = mkA "mundà" ; --auto
lin municipal_A = mkA "municipal" ; --auto
lin municipality_N = mkN "municipi" masculine ; --auto
lin muon_N = mkN "muó" masculine ; --auto
lin murder_N = mkN "assassinat" masculine ; --auto
lin murder_V2 = mkV2 "assassinar" ; --auto
lin murderer_N = mkN "assassí" | mkN "assassí" ; --auto
lin murmur_N = mkN "murmuri" masculine ; --auto
lin muscle_N = mkN "múscul" masculine ; --auto
lin muscovite_A = mkA "moscovita" ; --auto
lin muscovite_N = mkN "moscovita" ; --auto
lin muscular_A = mkA "muscular" ; --auto
lin muse_N = mkN "musa" feminine ; --auto
lin museum_N = mkN "museu" masculine ;
lin mushroom_N = mkN "bolet" masculine ; --auto
lin music_N = L.music_N ;
lin musical_A = mkA "musical" ; --auto
lin musicality_N = mkN "musicalitat" feminine ; --auto
lin musicianFem_N = variants {} ; ---- sense to be split
lin musicianMasc_N = variants {} ; ---- sense to be split
lin musicologist_N = mkN "musicòleg" | mkN "musicòleg" ; --auto
lin musicology_N = mkN "musicologia" feminine ; --auto
lin musk_N = mkN "almesc" masculine ; --auto
lin musketeer_N = mkN "mosqueter" feminine | mkN "mosqueter" masculine ; --auto
lin muslim_A = mkA "musulmà" ; --auto
lin muslim_N = mkN "musulmà" | mkN "musulmà" ; --auto
lin mussel_N = mkN "musclo" masculine ; --auto
lin mustard_N = mkN "mostassa" feminine ; --auto
lin mutant_A = mkA "mutant" ; --auto
lin mutant_N = mkN "mutant" ; --auto
lin mutation_N = mkN "mutació" feminine ; --auto
lin mute_A = mkA "mut" ; --auto
lin mutilate_V = mkV "mutilar" ; --auto
lin mutilate_V2 = mkV2 "mutilar" ; --auto
lin mutilation_N = mkN "mutilació" feminine ; --auto
lin mutter_V = mkV "murmurar" ; --auto
lin mutter_V2 = mkV2 "murmurar" ; --auto
lin mutual_A = mkA "mutu" ; --auto
lin mutuality_N = mkN "mutualitat" feminine ; --auto
lin muzzle_N = mkN "morro" masculine ; --auto
lin myalgia_N = mkN "miàlgia" feminine ; --auto
lin mycology_N = mkN "micologia" feminine ; --auto
lin mycoplasma_N = mkN "micoplasma" masculine ; --auto
lin mydriasis_N = mkN "midriasi" feminine ; --auto
lin myelencephalon_N = mkN "mielencèfal" masculine ; --auto
lin myelin_N = mkN "mielina" feminine ; --auto
lin myeloblast_N = mkN "mieloblast" masculine ; --auto
lin myelocyte_N = mkN "mielòcit" masculine ; --auto
lin myelofibrosis_N = mkN "mielofibrosi" feminine ; --auto
lin myeloma_N = mkN "mieloma" masculine ; --auto
lin myocardium_N = mkN "miocardi" masculine ; --auto
lin myofibril_N = mkN "miofibril·la" feminine ; --auto
lin myoglobin_N = mkN "mioglobina" feminine ; --auto
lin myoma_N = mkN "mioma" masculine ; --auto
lin myopathy_N = mkN "miopatia" feminine ; --auto
lin myope_N = mkN "miop" ; --auto
lin myopia_N = mkN "miopia" feminine ; --auto
lin myosin_N = mkN "miosina" feminine ; --auto
lin myriad_N = mkN "miríada" feminine ; --auto
lin myriapod_N = mkN "miriàpode" masculine ; --auto
lin myringoplasty_N = mkN "miringoplàstia" feminine ; --auto
lin myringotomy_N = mkN "miringotomia" feminine ; --auto
lin myrrh_N = mkN "mirra" feminine ; --auto
lin mysterious_A = mkA "misteriós" ; --auto
lin mystery_N = mkN "misteri" masculine ; --auto
lin mysticFem_N = variants {} ; ---- sense to be split
lin mysticMasc_N = variants {} ; ---- sense to be split
lin mystic_A = mkA "místic" ; --auto
lin mysticism_N = mkN "misticisme" masculine ; --auto
lin myth_N = mkN "mite" masculine ; --auto
lin mythical_A = mkA "mític" ; --auto
lin mythological_A = mkA "mitològic" ; --auto
lin mythology_N = mkN "mitologia" feminine ; --auto
lin myxedema_N = mkN "mixedema" masculine ; --auto
lin myxoma_N = mkN "mixoma" masculine ; --auto
lin myxomatosis_N = mkN "mixomatosi" feminine ; --auto
lin nacre_N = mkN "nacre" masculine ; --auto
lin nacreous_A = mkA "nacrat" ; --auto
lin nadir_N = mkN "nadir" masculine ; --auto
lin nag_N = mkN "rossí" masculine ; --auto
lin nail_N = mkN "clau" masculine | mkN "ungla" feminine ; --auto
lin nail_V2 = mkV2 "clavar" ; --auto
lin naive_A = variants {} ;
lin naivety_N = mkN "ingenuïtat" feminine ; --auto
lin naked_A = mkA "despullat" ; --auto
lin nakedness_N = mkN "nuesa" feminine ; --auto
lin name_N = L.name_N ;
lin name_V2 = mkV2 "anomenar" ; --auto
lin namely_Adv = mkAdv "és a dir" ; --auto
lin namibianFem_N = variants {} ; ---- sense to be split
lin namibianMasc_N = variants {} ; ---- sense to be split
lin nanny_N = mkN "mainadera" feminine ; --auto
lin nanotechnology_N = mkN "nanotecnologia" feminine ; --auto
lin napalm_N = mkN "napalm" masculine ; --auto
lin nape_N = mkN "clatell" masculine ; --auto
lin napkin_N = mkN "tovalló" masculine ; --auto
lin napoleonic_A = mkA "napoleònic" ; --auto
lin narcissism_N = mkN "narcisisme" masculine ; --auto
lin narcissist_N = mkN "narcisista" ; --auto
lin narcissus_N = mkN "narcís" masculine ; --auto
lin narcolepsy_N = mkN "narcolèpsia" feminine ; --auto
lin narcosis_N = mkN "narcosi" feminine ; --auto
lin narcotic_N = mkN "narcòtic" masculine ; --auto
lin narrative_A = mkA "narratiu" ; --auto
lin narrative_N = mkN "narrativa" feminine ; --auto
lin narrator_N = mkN "narrador" feminine | mkN "narrador" masculine ; --auto
lin narrow_A = L.narrow_A ;
lin narrowing_N = mkN "estrenyiment" masculine ; --auto
lin narthex_N = mkN "nàrtex" masculine ; --auto
lin nasal_A = mkA "nasal" ; --auto
lin nasality_N = mkN "nasalitat" feminine ; --auto
lin nasion_N = mkN "nasi" masculine ; --auto
lin nasty_A = mkA "dolent" ; --auto
lin natal_A = mkA "natal" ; --auto
lin nation_N = mkN "nació" feminine ;
lin national_A = mkA "nacional" ;
lin nationalism_N = mkN "nacionalisme" masculine ; --auto
lin nationalist_A = mkA "nacionalista" ; --auto
lin nationalist_N = mkN "nacionalista" ; --auto
lin nationality_N = mkN "nacionalitat" feminine ; --auto
lin nationwide_Adv = mkAdv "a escala nacional" ; --auto
lin native_A = mkA "indígena" | mkA "natiu" ; --auto
lin native_N = mkN "nadiu" feminine | mkN "nadiu" masculine ; --auto
lin nativism_N = mkN "indigenisme" masculine ; --auto
lin natural_A = mkA "natural" ;
lin naturalism_N = mkN "naturalisme" masculine ; --auto
lin naturalistic_A = mkA "naturalista" ; --auto
lin nature_N = mkN "natura" feminine ;
lin naughty_A = mkA "entremaliat" ; --auto
lin nausea_N = mkN "nàusea" feminine ; --auto
lin nautical_A = mkA "nàutic" ; --auto
lin naval_A = mkA "naval" ; --auto
lin nave_N = mkN "nau" feminine ; --auto
lin navel_N = mkN "melic" masculine ; --auto
lin navigable_A = mkA "navigable" ; --auto
lin navigation_N = mkN "navegació" feminine ; --auto
lin navigator_N = mkN "explorador" feminine | mkN "explorador" masculine ; --auto
lin navy_N = mkN "armada" feminine ; --auto
lin nazi_A = mkA "nazi" ; --auto
lin nazi_N = mkN "nazi" ; --auto
lin nazism_N = mkN "nazisme" masculine ; --auto
lin near_A = L.near_A ;
lin near_Adv = mkAdv "a prop" ; --auto
lin near_Prep = mkPrep "a prop de" ;
lin nearby_A = mkA "proper" ; --auto
lin nearly_Adv = mkAdv "quasi" ;
lin neat_A = mkA "polit" ; --auto
lin nebula_N = mkN "nebulosa" feminine ; --auto
lin necessary_A = mkA "necessari" ;
lin neck_N = L.neck_N ;
lin necklace_N = mkN "collaret" masculine ; --auto
lin necrobiosis_N = mkN "necrobiosi" feminine ; --auto
lin necrosis_N = mkN "necrosi" feminine ; --auto
lin nectar_N = mkN "nèctar" masculine ; --auto
lin nectary_N = mkN "nectari" feminine | mkN "nectari" masculine ; --auto
lin need_N = mkN "necessitat" masculine ;
lin need_V = IrregCat.haver_V ;
lin need_V2 = mkV2 IrregCat.haver_V ;
lin need_VV = deVV IrregCat.haver_V ;
lin needle_N = mkN "agulla" feminine ; --auto
lin negation_N = mkN "negació" feminine ; --auto
lin negative_A = mkA "negatiu" ; --auto
lin neglect_N = mkN "negligència" feminine ; --auto
lin neglect_V2 = mkV2 "negligir" ; --auto
lin negligence_N = mkN "negligència" feminine ; --auto
lin negligent_A = mkA "imprudent" ; --auto
lin negligible_A = mkA "insignificant" ; --auto
lin negotiable_A = mkA "negociable" ; --auto
lin negotiate_V = mkV "negociar" ; --auto
lin negotiate_V2 = mkV2 "negociar" ; --auto
lin negotiation_N = mkN "negociació" feminine | mkN "gestió" feminine ; --auto
lin negotiator_N = mkN "negociador" | mkN "negociador" ; --auto
lin neighbour_N = mkN "veí" feminine | mkN "veí" masculine ; --auto
lin neighbourhood_N = mkN "barri" masculine ; --auto
lin neighbouring_A = mkA "veí" ; --auto
lin neighbourly_A = mkA "amical" ; --auto
lin neither_Adv = mkAdv "tampoc" ; --auto
lin nematode_N = mkN "nematode" masculine ; --auto
lin neoclassicism_N = mkN "neoclassicisme" masculine ; --auto
lin neocolonialism_N = mkN "neocolonialisme" masculine ; --auto
lin neodymium_N = mkN "neodimi" masculine ; --auto
lin neoliberalism_N = mkN "neoliberalisme" masculine ; --auto
lin neologism_N = mkN "neologisme" masculine ; --auto
lin neon_N = mkN "neó" masculine ; --auto
lin neonatal_A = mkA "neonatal" ; --auto
lin neophyte_N = mkN "neòfit" | mkN "neòfit" ; --auto
lin neoplasia_N = mkN "neoplàsia" feminine ; --auto
lin nepalese_A = mkA "nepalès" ; --auto
lin nepalese_N = mkN "nepalès" | mkN "nepalès" ; --auto
lin nepaliFem_N = variants {} ; ---- sense to be split
lin nepaliMasc_N = variants {} ; ---- sense to be split
lin nephew_N = mkN "nebot" masculine ; --auto
lin nephrectomy_N = mkN "nefrectomia" feminine ; --auto
lin nephrite_N = mkN "nefrita" feminine ; --auto
lin nephrolithiasis_N = mkN "nefrolitiasi" feminine ; --auto
lin nephron_N = mkN "nefró" masculine ; --auto
lin nephroptosis_N = mkN "nefroptosi" feminine ; --auto
lin nephrosclerosis_N = mkN "nefrosclerosi" feminine ; --auto
lin nepotism_N = mkN "nepotisme" masculine ; --auto
lin neptunium_N = mkN "neptuni" masculine ; --auto
lin nerve_N = mkN "nervi" masculine ; --auto
lin nervous_A = mkA "nerviós" ; --auto
lin nervousness_N = mkN "nerviositat" feminine ; --auto
lin nest_N = mkN "niu" masculine ; --auto
lin net_A = mkA "net" ; --auto
lin net_N = mkN "xarxa" feminine ; --auto
lin nettle_N = mkN "ortiga" feminine ; --auto
lin network_N = mkN "xarxa" feminine ;
lin neural_A = mkA "neuronal" ; --auto
lin neuralgia_N = mkN "neuràlgia" feminine ; --auto
lin neurasthenia_N = mkN "neurastènia" feminine ; --auto
lin neurectomy_N = mkN "neurectomia" feminine ; --auto
lin neuroblast_N = mkN "neuroblast" masculine ; --auto
lin neuroepithelium_N = mkN "neuroepiteli" masculine ; --auto
lin neurofibroma_N = mkN "neurofibroma" masculine ; --auto
lin neurofibromatosis_N = mkN "neurofibromatosi" feminine ; --auto
lin neuroglia_N = mkN "neuròglia" feminine ; --auto
lin neurologistFem_N = variants {} ; ---- sense to be split
lin neurologistMasc_N = variants {} ; ---- sense to be split
lin neurology_N = mkN "neurologia" feminine ; --auto
lin neuromuscular_A = mkA "neuromuscular" ; --auto
lin neuropteron_N = mkN "neuròpter" masculine ; --auto
lin neurosis_N = mkN "neurosi" feminine ; --auto
lin neurotransmitter_N = mkN "neurotransmissor" masculine ; --auto
lin neuter_A = mkA "neutre" ; --auto
lin neutral_A = mkA "neutre" ; --auto
lin neutralism_N = mkN "neutralisme" masculine ; --auto
lin neutralist_N = mkN "neutralista" ; --auto
lin neutrality_N = mkN "neutralitat" feminine ; --auto
lin neutrino_N = mkN "neutrí" masculine | mkN "neutrí" masculine ; --auto
lin neutron_N = mkN "neutró" masculine ; --auto
lin neutropenia_N = mkN "neutropènia" feminine ; --auto
lin never_AdV = mkAdv "mai" ; --auto
lin never_Adv = mkAdv "mai" ;
lin nevertheless_Adv = mkAdv "tot i això" ;
lin new_A = L.new_A ;
lin newcomer_N = mkN "nouvingut" | mkN "nouvingut" ; --auto
lin news_N = mkN "notícies" feminine ;
lin newscast_N = mkN "telenotícies" masculine | mkN "noticiari" masculine | mkN "telenotícies" masculine ; --auto
lin newspaper_N = L.newspaper_N ;
lin newton_N = mkN "newton" masculine ; --auto
lin next_A = mkA "proper" | mkA "pròxim" | mkA "vinent" ; --auto
lin nicaraguan_A = mkA "nicaragüenc" ; --auto
lin nicaraguan_N = mkN "nicaragüenc" ; --auto
lin nice_A = mkA "bonic" ;
lin niche_N = mkN "nínxol" masculine ; --auto
lin nick_N = mkN "cran" masculine ; --auto
lin nickel_N = mkN "níquel" masculine ; --auto
lin nickname_N = mkN "renom" masculine ; --auto
lin nicotine_N = mkN "nicotina" feminine ; --auto
lin niece_N = mkN "nebot" feminine ; --auto
lin nigerian_A = mkA "nigerià" ; --auto
lin nigerian_N = mkN "nigerià" | mkN "nigerià" ; --auto
lin night_N = L.night_N ;
lin nightclub_N = mkN "cabaret" masculine ; --auto
lin nightingale_N = mkN "rossinyol" masculine ; --auto
lin nightmare_N = mkN "malson" masculine ; --auto
lin nihilism_N = mkN "nihilisme" masculine ; --auto
lin nihilistic_A = mkA "nihilista" ; --auto
lin nil_N = mkN "zero" masculine ; --auto
lin nilpotent_A = mkA "nilpotent" ; --auto
lin nimbus_N = mkN "nimbus" masculine | mkN "nimbus" masculine ; --auto
lin niobium_N = mkN "niobi" masculine ; --auto
lin nitrate_N = mkN "nitrat" masculine ; --auto
lin nitric_A = mkA "nítric" ; --auto
lin nitride_N = mkN "nitrur" masculine ; --auto
lin nitrification_N = mkN "nitrificació" feminine ; --auto
lin nitrile_N = mkN "nitril" masculine ; --auto
lin nitrite_N = mkN "nitrit" masculine ; --auto
lin nitrogen_N = mkN "nitrogen" masculine ; --auto
lin nitrogenous_A = mkA "nitrogenat" ; --auto
lin nitroglycerine_N = mkN "nitroglicerina" feminine ; --auto
lin no_Interj = mkInterj "no" ;
lin no_Quant = S.no_Quant ;
lin no_longer_AdV = mkAdv "ja no" ; --auto
lin no_man's_land_N = mkN "terra de ningú" feminine ; --auto
lin nobelium_N = mkN "nobeli" masculine ; --auto
lin nobility_N = mkN "noblesa" feminine ; --auto
lin nobleFem_N = variants {} ; ---- sense to be split
lin nobleMasc_N = variants {} ; ---- sense to be split
lin noble_A = mkA "noble" ; --auto
lin nobody_NP = S.nobody_NP ;
lin nocturnal_A = mkA "nocturn" ; --auto
lin nocturne_N = mkN "nocturn" masculine ; --auto
lin nod_V = mkV "assentir amb el cap" | mkV "saludar amb el cap" ; --auto
lin nod_off_V = advV OP_nod_V OP_off_Adv ; -- guess-p-verb
lin nod_through_V2 = prepV2 OP_nod_V OP_through_Prep ; -- guess-p-verb
lin node_N = mkN "node" masculine ; --auto
lin nodule_N = mkN "nòdul" masculine ; --auto
lin nogging_N = mkN "forjat" masculine ; --auto
lin noise_N = mkN "soroll" masculine ; --auto
lin noisy_A = mkA "sorollós" ; --auto
lin nomad_N = mkN "nòmada" feminine ; --auto
lin nomadic_A = mkA "nòmada" ; --auto
lin nomenclature_N = mkN "nomenclatura" feminine ; --auto
lin nominal_A = mkA "nominal" ; --auto
lin nominalism_N = mkN "nominalisme" masculine ; --auto
lin nominate_V2 = mkV2 "nomenar" ; --auto
lin nomination_N = mkN "nomenament" masculine ; --auto
lin nominee_N = mkN "candidat" ; --auto
lin nomogram_N = mkN "nomograma" masculine ; --auto
lin nonagon_N = mkN "enneàgon" masculine ; --auto
lin nonappearance_N = mkN "incompareixença" feminine ; --auto
lin nonetheless_Adv = mkAdv "no obstant això" ; --auto
lin nonexistence_N = mkN "inexistència" feminine ; --auto
lin nonpareil_N = mkN "nomparell" masculine ; --auto
lin nonsense_N = mkN "bestiesa" feminine ; --auto
lin noodle_N = mkN "fideu" masculine ; --auto
lin noon_N = mkN "migdia" masculine ; --auto
lin noose_N = mkN "llaç" masculine ; --auto
lin nor_Conj = mkConj "ni" ;
lin noria_N = mkN "sínia" feminine ; --auto
lin norm_N = mkN "norma" feminine ; --auto
lin normal_A = mkA "normal" ;
lin normality_N = mkN "normalitat" feminine ; --auto
lin normative_A = mkA "normatiu" ; --auto
lin north_A = mkA "del nord" | mkA "nord" ; --auto
lin north_Adv = mkAdv "cap al nord" ; --auto
lin north_N = mkN "nord" masculine ;
lin northeast_Adv = mkAdv "cap al nord-est" ; --auto
lin northeast_N = mkN "nord-est" masculine ; --auto
lin northeastern_A = mkA "nord-oriental" ; --auto
lin northern_A = mkA "del nord" ; --auto
lin northerner_N = mkN "del nord" | mkN "del nord" ; --auto
lin northwest_Adv = mkAdv "cap al nord-oest" ; --auto
lin northwest_N = mkN "nord-oest" masculine ; --auto
lin norwegianFem_N = variants {} ;
lin norwegianMasc_N = variants {} ;
lin norwegian_A = mkA "noruec" ;
lin nose_N = L.nose_N ;
lin nostalgia_N = mkN "nostàlgia" feminine ; --auto
lin nostril_N = mkN "nariu" masculine ; --auto
lin notable_A = mkA "notable" ; --auto
lin notary_N = mkN "notari" feminine | mkN "notari" masculine ; --auto
lin notation_N = mkN "notació" feminine ; --auto
lin notch_V2 = mkV2 "entallar" ; --auto
lin note_1_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin note_2_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin note_3_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin note_V = mkV "anotar" ; --auto
lin note_V2 = mkV2 "anotar" ; --auto
lin note_down_V2 = prepV2 OP_note_V OP_down_Prep ; -- guess-p-verb
lin notebook_N = mkN "llibreta" feminine ; --auto
lin nothing_NP = S.nothing_NP ;
lin notice_N = mkN "anunci" masculine | mkN "avís" masculine ; --auto
lin notice_V2 = mkV2 (reflV (mkV "adonar")) ParadigmsCat.genitive ;
lin notice_VS = mkVS (reflV (mkV "adonar")) ;
lin notification_N = mkN "notificació" feminine ; --auto
lin notify_V2 = mkV2 "notificar" ; --auto
lin notion_N = mkN "idea" feminine ; --auto
lin notochord_N = mkN "notocordi" masculine ; --auto
lin notoriety_N = mkN "notorietat" feminine ; --auto
lin notorious_A = mkA "notori" ; --auto
lin noun_N = mkN "substantiu" masculine ; --auto
lin nourish_V2 = mkV2 "nodrir" ; --auto
lin nourishment_N = mkN "nodriment" masculine ; --auto
lin novation_N = mkN "novació" feminine ; --auto
lin novel_A = mkA "novell" ; --auto
lin novel_N = mkN "novel·la" feminine ; --auto
lin novelist_N = mkN "novel·lista" ; --auto
lin novelty_N = mkN "novetat" feminine ; --auto
lin novice_N = mkN "novençà" | mkN "novençà" ; --auto
lin now_AdV = mkAdv "ara" ; --auto
lin now_Adv = L.now_Adv ;
lin nowadays_Adv = mkAdv "avui dia" ; --auto
lin nowhere_Adv = mkAdv "enlloc" ; --auto
lin nozzle_N = mkN "tovera" feminine ; --auto
lin nuance_N = mkN "matís" masculine ; --auto
lin nuclear_A = mkA "nuclear" ;
lin nucleolus_N = mkN "nuclèol" masculine ; --auto
lin nucleon_N = mkN "nucleó" masculine ; --auto
lin nucleoplasm_N = mkN "nucleoplasma" masculine ; --auto
lin nucleoside_N = mkN "nucleòsid" masculine ; --auto
lin nucleosynthesis_N = mkN "nucleosíntesi" feminine ; --auto
lin nucleotide_N = mkN "nucleòtid" masculine ; --auto
lin nucleus_N = mkN "nucli" masculine ; --auto
lin nude_A = mkA "nu" ; --auto
lin nudism_N = mkN "nudisme" masculine ; --auto
lin nudist_N = mkN "nudista" ; --auto
lin nuisance_N = mkN "nosa" feminine ; --auto
lin nullity_N = mkN "nul·litat" feminine ; --auto
lin number_1_N = L.number_N ;
lin number_2_N = L.number_N ;
lin number_3_N = L.number_N ;
lin number_V2 = mkV2 "numerar" ; --auto
lin numberless_A = mkA "innumerable" ; --auto
lin numeral_A = mkA "numeral" ; --auto
lin numeral_N = mkN "nombre" masculine ; --auto
lin numerator_N = mkN "numerador" masculine ; --auto
lin numeric_A = mkA "numèric" ; --auto
lin numerical_A = mkA "numèric" ; --auto
lin numerologistFem_N = variants {} ; ---- sense to be split
lin numerologistMasc_N = variants {} ; ---- sense to be split
lin numerology_N = mkN "numerologia" feminine ; --auto
lin numerous_A = mkA "nombrós" ; --auto
lin numismatist_N = mkN "numismàtic" feminine | mkN "numismàtic" masculine ; --auto
lin nun_N = mkN "monjo" feminine ; --auto
lin nuptial_A = mkA "nupcial" ; --auto
lin nurse_N = mkN "infermer" feminine | mkN "infermer" masculine ; --auto
lin nurseryman_N = mkN "planterista" ; --auto
lin nut_N = mkN "fruita seca" feminine | mkN "rosca" feminine ; --auto
lin nutcracker_N = mkN "trencanous" masculine | mkN "trencanous" masculine ; --auto
lin nutrient_N = mkN "nutrient" masculine ; --auto
lin nutrition_N = mkN "nutrició" feminine ; --auto
lin nutritional_A = mkA "nutritiu" ; --auto
lin nutritious_A = mkA "nutritiu" ; --auto
lin nyctalopia_N = mkN "nictalopia" feminine ; --auto
lin nylon_N = mkN "niló" masculine ; --auto
lin nymph_N = mkN "nimfa" feminine ; --auto
lin nymphomania_N = mkN "nimfomania" feminine ; --auto
lin nymphomaniac_A = mkA "nimfòman" ; --auto
lin nystagmus_N = mkN "nistagme" masculine ; --auto
lin oak_N = mkN "roure" masculine ; --auto
lin oar_N = mkN "rem" masculine ; --auto
lin oasis_N = mkN "oasi" masculine ; --auto
lin obedience_N = mkN "obediència" feminine ; --auto
lin obedient_A = mkA "obedient" ; --auto
lin obelisk_N = mkN "obelisc" masculine ; --auto
lin obese_A = mkA "obès" ; --auto
lin obesity_N = mkN "obesitat" feminine ; --auto
lin obey_V = mkV "obeir" ; --auto
lin obey_V2 = mkV2 "obeir" ; --auto
lin obituary_N = mkN "necrologia" feminine ; --auto
lin object_N = mkN "objecte" masculine ;
lin object_V = mkV "objectar" ; --auto
lin object_V2 = mkV2 "objectar" ; --auto
lin objection_N = mkN "objecció" feminine ; --auto
lin objective_A = mkA "objectiu" ; --auto
lin objective_N = mkN "objectiu" masculine ;
lin objectivity_N = mkN "objectivitat" feminine ; --auto
lin objector_N = mkN "objector" | mkN "objector" ; --auto
lin obligation_N = mkN "obligació" feminine ; --auto
lin obliterate_V2 = mkV2 "obliterar" ; --auto
lin obliteration_N = mkN "obliteració" feminine ; --auto
lin oboe_N = mkN "oboè" masculine ; --auto
lin oboist_N = mkN "oboista" ; --auto
lin obscene_A = mkA "obscè" ; --auto
lin obscenity_N = mkN "obscenitat" feminine ; --auto
lin obscurantism_N = mkN "obscurantisme" masculine ; --auto
lin obscure_A = mkA "obscur" ; --auto
lin obscure_V2 = mkV2 "obscurir" ; --auto
lin obscurity_N = mkN "obscuritat" feminine ; --auto
lin observable_A = mkA "observable" ; --auto
lin observance_N = mkN "observança" feminine ; --auto
lin observant_A = mkA "observador" ; --auto
lin observation_N = mkN "observació" feminine ; --auto
lin observatory_N = mkN "observatori" masculine ; --auto
lin observe_V2 = mkV2 (mkV "observar") ;
lin observe_VS = mkVS (mkV "observar") ;
lin observer_N = mkN "observador" | mkN "observador" ; --auto
lin obsession_N = mkN "obsessió" feminine ; --auto
lin obsessive_A = mkA "obsessiu" ; --auto
lin obsidian_N = mkN "obsidiana" feminine ; --auto
lin obsolescence_N = mkN "obsolescència" feminine ; --auto
lin obsolete_A = mkA "obsolet" ; --auto
lin obstacle_N = mkN "obstacle" masculine ; --auto
lin obstetrics_N = mkN "obstetrícia" feminine ; --auto
lin obstinacy_N = mkN "obstinació" feminine ; --auto
lin obstruct_V2 = mkV2 "obstruir" ; --auto
lin obstruction_N = mkN "obstrucció" feminine ; --auto
lin obstructionism_N = mkN "obstruccionisme" masculine ; --auto
lin obstructive_A = mkA "obstruccionista" ; --auto
lin obtain_V = mkV (tenir_108 "obtenir") ;
lin obtain_V2 = mkV2 (mkV (tenir_108 "obtenir")) ;
lin obtainable_A = mkA "assequible" ; --auto
lin obtrusive_A = mkA "inoportú" ; --auto
lin obtuse_A = mkA "obtús" | mkA "obtusangle" ; --auto
lin obverse_N = mkN "anvers" masculine ; --auto
lin obvious_A = mkA "obvi" ;
lin ocarina_N = mkN "ocarina" feminine ; --auto
lin occasion_N = mkN "ocasió" feminine ;
lin occasional_A = mkA "ocasional" ; --auto
lin occidental_A = mkA "occidental" ; --auto
lin occipital_A = mkA "occipital" ; --auto
lin occiput_N = mkN "occípit" masculine ; --auto
lin occlusion_N = mkN "oclusió" feminine ; --auto
lin occultism_N = mkN "ocultisme" masculine ; --auto
lin occupant_N = mkN "ocupant" ; --auto
lin occupation_N = mkN "ocupació" feminine ; --auto
lin occupational_A = mkA "ocupacional" ; --auto
lin occupy_V = mkV "ocupar" ; --auto
lin occupy_V2 = mkV2 "ocupar" ; --auto
lin occur_V = mkV "passar" ;
lin occur_to_V2 = prepV2 OP_occur_V OP_to_Prep ; -- guess-p-verb
lin occurrence_N = mkN "ocurrència" feminine ; --auto
lin ocean_N = mkN "oceà" masculine ; --auto
lin oceanic_A = mkA "oceànic" ; --auto
lin oceanography_N = mkN "oceanografia" feminine ; --auto
lin ocelot_N = mkN "ocelot" masculine ; --auto
lin ochre_N = mkN "ocre" masculine ; --auto
lin ochronosis_N = mkN "ocrònosi" feminine ; --auto
lin octagon_N = mkN "octàgon" masculine | mkN "octògon" masculine ; --auto
lin octahedron_N = mkN "octàedre" masculine ; --auto
lin octal_A = mkA "octal" ; --auto
lin octant_N = mkN "octant" masculine ; --auto
lin octave_N = mkN "octava" feminine ; --auto
lin octet_N = mkN "octet" masculine ; --auto
lin octogenarian_N = mkN "octogenari" | mkN "octogenari" ; --auto
lin octopus_N = mkN "pop" masculine | mkN "pop" masculine ; --auto
lin octosyllable_N = mkN "octosíl·lab" masculine ; --auto
lin ocular_A = mkA "ocular" ; --auto
lin oculist_N = mkN "oculista" ; --auto
lin odd_A = mkA "estrany" | mkA "imparell" | mkA "senar" ; --auto
lin oddity_N = mkN "raresa" feminine ; --auto
lin ode_N = mkN "oda" feminine ; --auto
lin odour_N = mkN "olor" feminine ; --auto
lin odourless_A = mkA "inodor" ; --auto
lin oersted_N = mkN "oersted" masculine ; --auto
lin oesophagus_N = mkN "esòfag" masculine ; --auto
lin of_Prep = ParadigmsCat.genitive ; --mkPrep "de" ;
lin of_course_Adv = mkAdv "naturalment" ; --auto
lin off_Adv = mkAdv "fora" ; --auto
lin off_Prep = mkPrep "fora" ;
lin offal_N = mkN "menut" masculine ; --auto
lin offence_N = mkN "delicte" masculine | mkN "ofensa" feminine ; --auto
lin offend_V = mkV "ofendre" ; --auto
lin offend_V2 = mkV2 "ofendre" ; --auto
lin offenderFem_N = variants {} ; ---- sense to be split
lin offenderMasc_N = variants {} ; ---- sense to be split
lin offensive_A = mkA "ofensiu" ; --auto
lin offensive_N = mkN "ofensiva" feminine ; --auto
lin offer_N = mkN "oferta" feminine ;
lin offer_V2 = mkV2 (verbV (servir_101 "oferir")) ;
lin offer_VV = aVV (verbV (servir_101 "oferir")) ;
lin offer_up_V = advV (lin V OP_offer_V2) OP_up_Adv ; -- guess-p-verb
lin offerer_N = mkN "ofertor" feminine | mkN "ofertor" masculine ; --auto
lin office_N = mkN "oficina" feminine ;
lin officer_1_N = mkN "oficial" ; --split "director" (in a company) "agent de policia" (police)
lin officer_2_N = mkN "oficial" ; --split "director" (in a company) "agent de policia" (police)
lin officer_3_N = mkN "oficial" ; --split "director" (in a company) "agent de policia" (police)
lin officialFem_N = variants {} ; ---- sense to be split
lin officialMasc_N = variants {} ; ---- sense to be split
lin official_A = mkA "oficial" ; --auto
lin officious_A = mkA "oficiós" ; --auto
lin offline_A = mkA "offline" ; --auto
lin offprint_N = mkN "separata" feminine ; --auto
lin offset_N = mkN "offset" masculine | mkN "òfset" masculine ; --auto
lin often_AdA = mkAdv "sovint" ; --auto
lin often_AdV = mkAdv "sovint" ; --auto
lin often_Adv = mkAdv "sovint" ;
lin ogre_N = mkN "ogre" masculine ; --auto
lin ohm_N = mkN "ohm" masculine ; --auto
lin ohmic_A = mkA "òhmic" ; --auto
lin ohmmeter_N = mkN "ohmímetre" masculine | mkN "òhmmetre" masculine ; --auto
lin oil_N = L.oil_N ;
lin oil_tanker_N = mkN "petrolier" masculine ; --auto
lin oiler_N = mkN "setrill" masculine ; --auto
lin oily_A = mkA "greixós" ; --auto
lin ointment_N = mkN "ungüent" masculine ; --auto
lin okay_Adv = mkAdv "d'acord" | mkAdv "entesos" ;
lin old_A = L.old_A ;
lin olfactory_A = mkA "olfactori" ; --auto
lin oligarch_N = mkN "oligarca" ; --auto
lin oligarchy_N = mkN "oligarquia" feminine ; --auto
lin oligodendrocyte_N = mkN "oligodendròcit" masculine ; --auto
lin oligodendroglia_N = mkN "oligodendròglia" feminine ; --auto
lin oligopoly_N = mkN "oligopoli" masculine ; --auto
lin oligosaccharide_N = mkN "oligosacàrid" masculine ; --auto
lin oliguria_N = mkN "oligúria" feminine ; --auto
lin olive_N = mkN "oliva" feminine ; --auto
lin olivine_N = mkN "olivina" feminine ; --auto
lin olympic_A = mkA "olímpic" ; --auto
lin omani_A = mkA "omanita" ; --auto
lin ominous_A = mkA "ominós" ; --auto
lin omissible_A = mkA "omissible" ; --auto
lin omission_N = mkN "omissió" feminine ; --auto
lin omit_V2 = mkV2 "ometre" ; --auto
lin omnibus_N = mkN "òmnibus" masculine | mkN "òmnibus" masculine ; --auto
lin omnipotent_A = mkA "omnipotent" ; --auto
lin omnivorous_A = mkA "omnívor" ; --auto
lin on_Adv = mkAdv "sobre" ;
lin on_Prep = S.on_Prep ;
lin on_behalf_of_Prep = mkPrep "en nom de" ; --auto
lin on_top_of_Prep = mkPrep "sobre" ; --auto
lin once_AdV = mkAdv "una vegada" | mkAdv "un cop" ; --auto
lin once_Adv = mkAdv "un cop" | mkAdv "una vegada" ;
lin once_Subj = mkSubj "un cop" Conjunct ;
lin oncoming_A = mkA "venidor" ; --auto
lin oneiric_A = mkA "oníric" ; --auto
lin onerous_A = mkA "onerós" ; --auto
lin ongoing_A = mkA "actual" ; --auto
lin onion_N = mkN "ceba" feminine ; --auto
lin online_A = mkA "en línia" | mkA "online" ; --auto
lin only_Adv = mkAdv "només" | mkAdv "tan sols" ;
lin only_Predet = S.only_Predet ;
lin onomastic_A = mkA "onomàstic" ; --auto
lin onomastics_N = mkN "onomàstica" feminine ; --auto
lin onomatopoeia_N = mkN "onomatopeia" feminine ; --auto
lin onomatopoeic_A = mkA "onomatopeic" ; --auto
lin onto_Prep = mkPrep "a" ; --auto
lin ontological_A = mkA "ontològic" ; --auto
lin ontology_N = mkN "ontologia" feminine ; --auto
lin onwards_Adv = mkAdv "cap avant" | mkAdv "cap endavant" ; --auto
lin onychosis_N = mkN "onicosi" feminine ; --auto
lin oocyte_N = mkN "oòcit" masculine ; --auto
lin oogenesis_N = mkN "oogènesi" feminine ; --auto
lin opacity_N = mkN "opacitat" feminine ; --auto
lin opal_N = mkN "òpal" masculine ; --auto
lin opalescence_N = mkN "opalescència" feminine ; --auto
lin opaque_A = mkA "opac" ; --auto
lin open_A = mkA "obert" ;
lin open_V = verbV (obrir_77 "obrir") ;
lin open_V2 = L.open_V2 ;
lin open_up_V = advV OP_open_V OP_up_Adv ; -- guess-p-verb
lin open_up_V2 = prepV2 OP_open_V OP_up_Prep ; -- guess-p-verb
lin opener_N = mkN "obrellaunes" masculine | mkN "obridor" masculine ; --auto
lin opening_N = mkN "obertura" feminine ; --auto
lin openness_N = mkN "transparència" feminine ; --auto
lin opera_N = mkN "òpera" feminine ; --auto
lin operable_A = mkA "operable" ; --auto
lin operand_N = mkN "operand" masculine ; --auto
lin operate_V = mkV "operar" ;
lin operate_V2 = mkV2 (mkV "operar") ;
lin operate_on_V2 = prepV2 OP_operate_V OP_on_Prep ; -- guess-p-verb
lin operatic_A = mkA "operístic" ; --auto
lin operating_theatre_N = mkN "quiròfan" masculine ; --auto
lin operation_N = mkN "operació" feminine ;
lin operational_A = mkA "operacional" ; --auto
lin operative_A = mkA "operatiu" ; --auto
lin operator_N = mkN "operador" | mkN "operador" ; --auto
lin operculum_N = mkN "opercle" masculine ; --auto
lin operetta_N = mkN "opereta" feminine ; --auto
lin ophthalmia_N = mkN "oftàlmia" feminine ; --auto
lin ophthalmic_A = mkA "oftàlmic" ; --auto
lin ophthalmologist_N = mkN "oftalmologista" ; --auto
lin ophthalmology_N = mkN "oftalmologia" feminine ; --auto
lin ophthalmoscope_N = mkN "oftalmoscopi" masculine ; --auto
lin ophthalmoscopy_N = mkN "oftalmoscòpia" feminine ; --auto
lin opinion_N = mkN "opinió" feminine ;
lin opium_N = mkN "opi" masculine ; --auto
lin opponentFem_N = variants {} ; ---- sense to be split
lin opponentMasc_N = variants {} ; ---- sense to be split
lin opportunism_N = mkN "oportunisme" masculine ; --auto
lin opportunistFem_N = variants {} ; ---- sense to be split
lin opportunistMasc_N = variants {} ; ---- sense to be split
lin opportunist_A = mkA "oportunista" ; --auto
lin opportunity_N = mkN "oportunitat" feminine | mkN "ocasió" masculine ;
lin opposable_A = mkA "oposable" ; --auto
lin oppose_V = mkV "oposar-se" ; --auto
lin opposite_A = mkA "oposat" ; --auto
lin opposite_N = mkN "contrari" feminine | mkN "contrari" masculine ; --auto
lin opposition_N = mkN "oposició" feminine ;
lin opprobrium_N = mkN "oprobi" masculine ; --auto
lin opt_V = mkV "optar" ; --auto
lin optical_A = mkA "òptic" ; --auto
lin optician_N = mkN "òptic" feminine | mkN "òptic" masculine ; --auto
lin optics_N = mkN "òptica" feminine ; --auto
lin optimal_A = mkA "òptim" ; --auto
lin optimism_N = mkN "optimisme" masculine ; --auto
lin optimistFem_N = variants {} ; ---- sense to be split
lin optimistMasc_N = variants {} ; ---- sense to be split
lin optimistic_A = mkA "optimista" ; --auto
lin optimum_A = mkA "òptim" ; --auto
lin option_N = mkN "opció" masculine ;
lin optional_A = mkA "opcional" ; --auto
lin optometrist_N = mkN "optometrista" ; --auto
lin optometry_N = mkN "optometria" feminine ; --auto
lin or_Conj = S.or_Conj ;
lin oracle_N = mkN "oracle" masculine ; --auto
lin oral_A = mkA "oral" ; --auto
lin orange_1_N = variants {} ; ---- sense to be split
lin orange_2_N = variants {} ; ---- sense to be split
lin orange_A = mkA "taronja" ; --auto
lin orangeade_N = mkN "taronjada" feminine ; --auto
lin orangutan_N = mkN "orangutan" masculine ; --auto
lin oratorFem_N = variants {} ; ---- sense to be split
lin oratorMasc_N = variants {} ; ---- sense to be split
lin oratory_N = mkN "oratòria" feminine ; --auto
lin orbit_N = mkN "òrbita" feminine ; --auto
lin orbit_V = mkV "orbitar" ; --auto
lin orbit_V2 = mkV2 "orbitar" ; --auto
lin orbital_A = mkA "orbitari" ; --auto
lin orchard_N = mkN "hort" masculine ; --auto
lin orchestra_N = mkN "orquestra" feminine ; --auto
lin orchestral_A = mkA "orquestral" ; --auto
lin orchestration_N = mkN "orquestració" feminine ; --auto
lin orchid_N = mkN "orquídia" feminine ; --auto
lin orchidectomy_N = mkN "orquidectomia" feminine ; --auto
lin ordeal_N = mkN "calvari" masculine | mkN "ordalia" feminine ; --auto
lin order_N = mkN "ordre" masculine ; --split mkN "comanda" fem (commercial order), mkN "ordre" feminine (command, order someone to do something)
lin order_V = mkV "ordenar" ;
lin order_V2 = mkV2 (mkV "ordenar") ;
lin order_V2V = mkV2V (mkV "ordenar") ParadigmsCat.accusative ParadigmsCat.dative ; --subcat "va ordenar a algú que fes X"
lin order_VS = mkVS (mkV "ordenar") ;
lin orderly_A = mkA "ordenat" ; --auto
lin ordinal_A = mkA "ordinal" ; --auto
lin ordinal_N = mkN "ordinal" masculine ; --auto
lin ordinary_A = mkA "comú" ;
lin ordinate_N = mkN "ordenada" feminine ; --auto
lin ore_N = mkN "mena" feminine ; --auto
lin organ_N = mkN "òrgan" masculine | mkN "orgue" masculine ; --auto
lin organdie_N = mkN "organdí" masculine ; --auto
lin organelle_N = mkN "orgànul" masculine ; --auto
lin organic_A = mkA "orgànic" ; --auto
lin organicism_N = mkN "organicisme" masculine ; --auto
lin organisation_N = mkN "organització" feminine ;
lin organism_N = mkN "organisme" masculine ; --auto
lin organist_N = mkN "organista" ; --auto
lin organization_N = mkN "organizació" feminine ;
lin orgasm_N = mkN "orgasme" masculine ; --auto
lin orgy_N = mkN "orgia" feminine ; --auto
lin oriel_N = mkN "mirador" masculine ; --auto
lin orient_V2 = mkV2 "orientar" ; --auto
lin oriental_A = mkA "oriental" ; --auto
lin orientalism_N = mkN "orientalisme" masculine ; --auto
lin orientalistFem_N = variants {} ; ---- sense to be split
lin orientalistMasc_N = variants {} ; ---- sense to be split
lin orientation_N = mkN "orientació" feminine ; --auto
lin orifice_N = mkN "orifici" masculine ; --auto
lin oriflamme_N = mkN "oriflama" feminine ; --auto
lin origin_N = mkN "origen" masculine ; --auto
lin original_A = mkA "original" ;
lin original_N = mkN "original" masculine ; --auto
lin originality_N = mkN "originalitat" feminine ; --auto
lin originate_V = mkV "originar" ; --auto
lin originate_V2 = mkV2 "originar" ; --auto
lin originatorFem_N = variants {} ; ---- sense to be split
lin originatorMasc_N = variants {} ; ---- sense to be split
lin ornament_N = mkN "adornament" masculine | mkN "ornament" masculine ; --auto
lin ornamental_A = mkA "ornamental" ; --auto
lin ornithologistFem_N = variants {} ; ---- sense to be split
lin ornithologistMasc_N = variants {} ; ---- sense to be split
lin ornithology_N = mkN "ornitologia" feminine ; --auto
lin orogeny_N = mkN "orogènia" feminine ; --auto
lin orologistFem_N = variants {} ; ---- sense to be split
lin orologistMasc_N = variants {} ; ---- sense to be split
lin orphan_N = mkN "orfe" masculine ; --auto
lin orphanage_N = mkN "orfenat" masculine ; --auto
lin orthicon_N = mkN "orticó" masculine ; --auto
lin orthoclase_N = mkN "ortòclasi" feminine ; --auto
lin orthodontics_N = mkN "ortodòncia" feminine ; --auto
lin orthodox_A = mkA "ortodox" ; --auto
lin orthoepy_N = mkN "ortologia" feminine ; --auto
lin orthogonal_A = mkA "ortogonal" ; --auto
lin orthogonality_N = mkN "ortogonalitat" feminine ; --auto
lin orthopaedics_N = mkN "ortopèdia" feminine ; --auto
lin orthopedist_N = mkN "ortopedista" ; --auto
lin oscillate_V = mkV "oscil·lar" ; --auto
lin oscillate_V2 = mkV2 "oscil·lar" ; --auto
lin oscillator_N = mkN "oscil·lador" masculine ; --auto
lin oscillatory_A = mkA "oscil·latori" ; --auto
lin oscillogram_N = mkN "oscil·lograma" masculine ; --auto
lin oscillograph_N = mkN "oscil·lògraf" masculine ; --auto
lin oscilloscope_N = mkN "oscil·loscopi" masculine ; --auto
lin osculation_N = mkN "osculació" feminine ; --auto
lin osier_N = mkN "vímet" masculine ; --auto
lin osmium_N = mkN "osmi" masculine ; --auto
lin osseous_A = mkA "ossi" ; --auto
lin ossification_N = mkN "ossificació" feminine ; --auto
lin ostentation_N = mkN "ostentació" feminine ; --auto
lin osteoblast_N = mkN "osteoblast" masculine ; --auto
lin osteoclast_N = mkN "osteoclast" masculine ; --auto
lin osteocyte_N = mkN "osteòcit" masculine ; --auto
lin osteolysis_N = mkN "osteòlosi" feminine ; --auto
lin osteomalacia_N = mkN "osteomalàcia" feminine ; --auto
lin osteopetrosis_N = mkN "osteopetrosi" feminine ; --auto
lin osteophyte_N = mkN "osteòfit" masculine ; --auto
lin osteoporosis_N = mkN "osteoporosi" feminine ; --auto
lin osteosarcoma_N = mkN "osteosarcoma" masculine ; --auto
lin osteosclerosis_N = mkN "osteosclerosi" feminine ; --auto
lin ostiole_N = mkN "ostíol" masculine ; --auto
lin ostracism_N = mkN "ostracisme" masculine ; --auto
lin ostrich_N = mkN "estruç" masculine ; --auto
lin other_A = mkA "altre" ;
lin other_N = mkN "altre" ;
lin otherwise_Adv = mkAdv "si no" | mkAdv "altrament" ; --auto
lin otology_N = mkN "otologia" feminine ; --auto
lin otoplasty_N = mkN "otoplàstia" feminine ; --auto
lin otosclerosis_N = mkN "otosclerosi" feminine ; --auto
lin otoscope_N = mkN "otoscopi" masculine ; --auto
lin otter_N = mkN "llúdria" feminine ; --auto
lin ottomanFem_N = variants {} ; ---- sense to be split
lin ottomanMasc_N = variants {} ; ---- sense to be split
lin ounce_N = mkN "unça" feminine ; --auto
lin out_Adv = mkAdv "fora" ;
lin out_Prep = mkPrep "fora de" ; --auto
lin out_of_Prep = mkPrep "fora de" | mkPrep "fora" ; --auto
lin out_of_doors_Adv = mkAdv "a l'aire lliure" ; --auto
lin outbreak_N = mkN "esclat" masculine ; --auto
lin outcome_N = mkN "resultat" masculine ; --auto
lin outcrop_N = mkN "aflorament" masculine ; --auto
lin outdoor_A = mkA "exterior" ; --auto
lin outdoors_Adv = mkAdv "a l'aire lliure" ; --auto
lin outer_A = mkA "exterior" ; --auto
lin outlay_N = mkN "desemborsament" masculine ; --auto
lin outline_N = mkN "contorn" masculine | mkN "esbós" masculine ; --auto
lin outline_V2 = mkV2 "perfilar" ; --auto
lin outlook_N = mkN "punt de vista" masculine ; --auto
lin outport_N = mkN "avantport" masculine ; --auto
lin output_N = mkN "producció" feminine | mkN "sortida" feminine ; --auto
lin outrage_N = mkN "ultratge" masculine ; --auto
lin outrigger_N = mkN "volada" feminine ; --auto
lin outright_Adv = mkAdv "francament" ; --auto
lin outside_A = mkA "exterior" ; --auto
lin outside_Adv = mkAdv "enfora" | mkAdv "fora" ; --auto
lin outside_N = mkN "exterior" masculine ; --auto
lin outside_Prep = mkPrep "fora" ;
lin outskirts_N = mkN "afores" masculine ; --auto
lin outstanding_A = mkA "excepcional" ; --auto
lin outward_Adv = mkAdv "cap enfora" ; --auto
lin outwards_Adv = mkAdv "cap enfora" ; --auto
lin oval_A = mkA "ovalat" ; --auto
lin oval_N = mkN "oval" masculine ; --auto
lin ovarian_A = mkA "ovàric" ; --auto
lin ovary_N = mkN "ovari" masculine ; --auto
lin ovation_N = mkN "ovació" feminine ; --auto
lin oven_N = mkN "estufa" feminine | mkN "forn" masculine ; --auto
lin over_Adv = mkAdv "un altre cop" ; -- should be "tornar a X"
lin over_Prep = mkPrep "per sobre" | mkPrep "sobre" ;
lin overall_A = mkA "global" ; --auto
lin overall_Adv = mkAdv "en general" ; --auto
lin overcome_V = mkV "vèncer" ; --auto
lin overcome_V2 = mkV2 "vèncer" ; --auto
lin overdose_N = mkN "sobredosi" feminine ; --auto
lin overdraft_N = mkN "descobert" masculine ; --auto
lin overestimate_V2 = mkV2 "sobrevalorar" ; --auto
lin overexploitation_N = mkN "sobreexplotació" feminine ; --auto
lin overexposure_N = mkN "sobreexposició" feminine ; --auto
lin overflow_N = mkN "desbordament" masculine ; --auto
lin overhead_A = mkA "elevat" ; --auto
lin overheat_V2 = mkV2 "sobrecalfar" | mkV2 "sobreescalfar" ; --auto
lin overlap_V = mkV "solapar" ; --auto
lin overlap_V2 = mkV2 "solapar" ; --auto
lin overnight_Adv = mkAdv "a la nit" ; --auto
lin overpopulation_N = mkN "superpoblació" feminine ; --auto
lin overpressure_N = mkN "sobrepressió" feminine ; --auto
lin overproduction_N = mkN "sobreproducció" feminine ; --auto
lin overriding_A = mkA "primordial" ; --auto
lin overseas_Adv = mkAdv "a l'estranger" | mkAdv "ultramar" ; --auto
lin oversight_N = mkN "descuit" masculine ; --auto
lin overthrow_N = mkN "enderrocament" masculine ; --auto
lin overtone_N = mkN "sobretò" masculine ; --auto
lin overturn_N = mkN "bolcada" feminine ; --auto
lin overvaluation_N = mkN "sobrevaluació" feminine ; --auto
lin overwhelm_V2 = mkV2 "aclaparar" ; --auto
lin overwhelming_A = mkA "aclaparador" ; --auto
lin oviduct_N = mkN "oviducte" masculine ; --auto
lin oviparous_A = mkA "ovípar" ; --auto
lin ovoid_A = mkA "ovoide" ; --auto
lin ovoviviparous_A = mkA "ovovivípar" ; --auto
lin ovulation_N = mkN "ovulació" feminine ; --auto
lin ovule_N = mkN "òvul" masculine ; --auto
lin owe_V = mkV "deure" ; --auto
lin owe_V2 = mkV2 "deure" ; --auto
lin owing_to_Prep = mkPrep "per causa de" ; --auto
lin owl_N = mkN "mussol" masculine ; --auto
lin own_A = mkA "propi" ; --auto
lin own_V2 = mkV2 "posseir" ; --auto
lin own_up_V = advV (lin V OP_own_V2) OP_up_Adv ; -- guess-p-verb
lin owner_N = mkN "propietari" ;
lin ownership_N = mkN "propietat" feminine ; --auto
lin oxidant_N = mkN "oxidant" masculine ; --auto
lin oxidation_N = mkN "oxidació" feminine ; --auto
lin oxide_N = mkN "òxid" masculine ; --auto
lin oxidoreductase_N = mkN "oxidoreductasa" feminine ; --auto
lin oxygen_N = mkN "oxigen" masculine ; --auto
lin oxymoron_N = mkN "oxímoron" masculine ; --auto
lin oxytocin_N = mkN "oxitocina" feminine ; --auto
lin oyster_N = mkN "ostra" feminine ; --auto
lin ozone_N = mkN "ozó" masculine ; --auto
lin pace_N = mkN "pas" masculine | mkN "ritme" masculine ; --auto
lin pacification_N = mkN "pacificació" feminine ; --auto
lin pacifism_N = mkN "pacifisme" masculine ; --auto
lin pacifistFem_N = variants {} ; ---- sense to be split
lin pacifistMasc_N = variants {} ; ---- sense to be split
lin pacify_V2 = mkV2 "pacificar" ; --auto
lin pack_N = mkN "grup" masculine | mkN "paquet" masculine ; --auto
lin pack_V = mkV "empaquetar" | mkV "envasar" | mkV "fer les maletes" ; --auto
lin pack_away_V2 = mkV2 (advV OP_pack_V OP_away_Adv ) ; -- guess-p-verb
lin pack_in_V = advV OP_pack_V OP_in_Adv ; -- guess-p-verb
lin pack_in_V2 = prepV2 OP_pack_V OP_in_Prep ; -- guess-p-verb
lin pack_it_in_V = variants {} ; -- guess-p-verb
lin pack_off_V2 = prepV2 OP_pack_V OP_off_Prep ; -- guess-p-verb
lin pack_out_V2 = prepV2 OP_pack_V OP_out_Prep ; -- guess-p-verb
lin pack_up_V = advV OP_pack_V OP_up_Adv ; -- guess-p-verb
lin pack_up_V2 = prepV2 OP_pack_V OP_up_Prep ; -- guess-p-verb
lin package_N = mkN "paquet" masculine ;
lin packaging_N = mkN "embalatge" masculine | mkN "envasament" masculine ; --auto
lin packer_N = mkN "empaquetador" feminine | mkN "empaquetador" masculine ; --auto
lin packet_N = mkN "paquet" masculine ; --auto
lin pact_N = mkN "pacte" masculine ; --auto
lin pad_V = mkV "embuatar" ; --auto
lin pad_V2 = mkV2 "embuatar" ; --auto
lin paddle_wheel_N = mkN "roda de paletes" feminine ; --auto
lin paddy_N = mkN "arrossar" masculine ; --auto
lin padlock_N = mkN "cadenat" masculine ; --auto
lin pagan_A = mkA "pagà" ; --auto
lin page_N = mkN "pàrgina" feminine ;
lin pagination_N = mkN "paginació" feminine ; --auto
lin pagoda_N = mkN "pagoda" feminine ; --auto
lin pain_N = mkN "dolor" masculine ;
lin painful_A = mkA "dolorós" ; --auto
lin painkiller_N = mkN "calmant" masculine ; --auto
lin painless_A = mkA "indolor" ; --auto
lin painstaking_A = mkA "laboriós" ; --auto
lin paint_N = mkN "pintura" feminine ; --auto
lin paint_V = variants {} ; -- L.paint_V2A ; -- comment=CHECKED
lin paint_V2 = variants {} ; -- L.paint_V2A ; -- comment=CHECKED
lin painter_N = mkN "pintor" | mkN "pintor" ; --auto
lin painting_N = mkN "quadre" masculine ;
lin pair_N = mkN "parell" masculine ;
lin pakistaniFem_N = variants {} ; ---- sense to be split
lin pakistaniMasc_N = variants {} ; ---- sense to be split
lin palace_N = mkN "palau" masculine ; --auto
lin palaeontologist_N = mkN "paleontòleg" masculine ; --auto
lin palaeontology_N = mkN "paleontologia" feminine ; --auto
lin palatal_A = mkA "palatal" ; --auto
lin palate_N = mkN "paladar" masculine ; --auto
lin palatine_A = mkA "palatí" ; --auto
lin pale_A = mkA "pàl·lid" ; --auto
lin paleness_N = mkN "pal·lidesa" feminine ; --auto
lin paleocerebellum_N = mkN "paleocerebel" masculine ; --auto
lin paleogeography_N = mkN "paleogeografia" feminine ; --auto
lin paleontological_A = mkA "paleontològic" ; --auto
lin palestinian_A = mkA "palestí" ; --auto
lin palette_N = mkN "paleta" feminine ; --auto
lin palimpsest_N = mkN "palimpsest" masculine ; --auto
lin palindrome_N = mkN "palíndrom" masculine ; --auto
lin palisade_N = mkN "estacada" feminine ; --auto
lin palladium_N = mkN "pal·ladi" masculine ; --auto
lin palliative_A = mkA "pal·liatiu" ; --auto
lin palliative_N = mkN "pal·liatiu" masculine ; --auto
lin pallium_N = mkN "pal·li" masculine ; --auto
lin palm_1_N = mkN "palmell" masculine ; --auto
lin palm_2_N = mkN "palmell" masculine ; --auto
lin palm_3_N = mkN "palmell" masculine ; --auto
lin palmate_A = mkA "palmat" ; --auto
lin palmer_N = mkN "pàlmer" masculine ; --auto
lin palpable_A = mkA "palpable" ; --auto
lin palpation_N = mkN "palpació" feminine ; --auto
lin pamphlet_N = mkN "pamflet" masculine ; --auto
lin pamphleteerFem_N = variants {} ; ---- sense to be split
lin pamphleteerMasc_N = variants {} ; ---- sense to be split
lin pan_N = mkN "cassola" feminine ; --auto
lin panacea_N = mkN "panacea" feminine ; --auto
lin panamanian_A = mkA "panameny" ; --auto
lin panamanian_N = mkN "panameny" | mkN "panameny" ; --auto
lin pancake_N = mkN "crep" masculine ; --auto
lin panchromatic_A = mkA "pancromàtic" ; --auto
lin pancreas_N = mkN "pàncrees" masculine | mkN "pàncrees" masculine ; --auto
lin pancreatic_A = mkA "pancreàtic" ; --auto
lin panegyric_N = mkN "panegíric" masculine ; --auto
lin panel_N = mkN "plafó" masculine | mkN "tauler" masculine ; --auto
lin panic_N = mkN "pànic" masculine ; --auto
lin panicle_N = mkN "panícula" feminine ; --auto
lin pannier_N = mkN "sàrria" feminine ; --auto
lin panorama_N = mkN "panorama" masculine ; --auto
lin panoramic_A = mkA "panoràmic" ; --auto
lin pantheism_N = mkN "panteisme" masculine ; --auto
lin pantheon_N = mkN "panteó" masculine ; --auto
lin panther_N = mkN "pantera" feminine ; --auto
lin pantograph_N = mkN "pantògraf" masculine ; --auto
lin pantomime_N = mkN "pantomima" feminine ; --auto
lin paper_N = L.paper_N ;
lin paperboard_N = mkN "cartonet" masculine ; --auto
lin paperwork_N = mkN "paperassa" feminine ; --auto
lin papilla_N = mkN "papil·la" feminine ; --auto
lin papillary_A = mkA "papil·lar" ; --auto
lin papilloma_N = mkN "papil·loma" masculine ; --auto
lin papyrus_N = mkN "papir" masculine ; --auto
lin parabola_N = mkN "paràbola" feminine ; --auto
lin parabolic_A = mkA "parabòlic" ; --auto
lin paraboloid_N = mkN "paraboloide" masculine ; --auto
lin parachute_N = mkN "paracaiguda" feminine ; --auto
lin parachutist_N = mkN "paracaigudista" ; --auto
lin parade_N = mkN "desfilada" feminine ; --auto
lin parade_V = mkV "desfilar" ; --auto
lin parade_V2 = mkV2 "desfilar" ; --auto
lin paradigm_N = mkN "paradigma" masculine ; --auto
lin paradigmatic_A = mkA "paradigmàtic" ; --auto
lin paradise_N = mkN "paradís" masculine ; --auto
lin paradoxical_A = mkA "paradoxal" ; --auto
lin paraffin_N = mkN "parafina" feminine ; --auto
lin paragraph_N = mkN "paràgraf" masculine ; --auto
lin paraguayan_A = mkA "paraguaià" ; --auto
lin paraguayan_N = mkN "paraguaià" | mkN "paraguaià" ; --auto
lin parakeet_N = mkN "periquito" masculine ; --auto
lin parallel_A = mkA "paral·lel" ; --auto
lin parallelepiped_N = mkN "paral·lelepípede" masculine ; --auto
lin parallelism_N = mkN "paral·lelisme" masculine ; --auto
lin parallelogram_N = mkN "paral·lelogram" masculine ; --auto
lin paralogism_N = mkN "paralogisme" masculine ; --auto
lin paralyse_V2 = mkV2 "paralitzar" ; --auto
lin paralysis_N = mkN "paràlisi" feminine ; --auto
lin paramagnetism_N = mkN "paramagnetisme" masculine ; --auto
lin parameter_N = mkN "paràmetre" masculine ; --auto
lin parametric_A = mkA "paramètric" ; --auto
lin paramnesia_N = mkN "paramnèsia" feminine ; --auto
lin paramount_A = mkA "primordial" ; --auto
lin paranoia_N = mkN "paranoia" feminine ; --auto
lin paranoiac_N = mkN "paranoic" | mkN "paranoic" ; --auto
lin paraparesis_N = mkN "paraparèsia" feminine ; --auto
lin parapet_N = mkN "ampit" masculine ; --auto
lin paraphrase_N = mkN "paràfrasi" feminine ; --auto
lin paraplegia_N = mkN "paraplegia" feminine ; --auto
lin parasite_N = mkN "paràsit" masculine ; --auto
lin parasitic_A = mkA "paràsit" ; --auto
lin parasitical_A = mkA "parasitari" ; --auto
lin parasitism_N = mkN "parasitisme" masculine ; --auto
lin parasol_N = mkN "para-sol" masculine ; --auto
lin parcel_N = mkN "paquet" masculine ; --auto
lin parchment_N = mkN "pergamí" masculine ; --auto
lin pardon_N = mkN "perdó" masculine ; --auto
lin parenchyma_N = mkN "parènquima" masculine ; --auto
lin parent_N = mkN "pare" masculine ;
lin parental_A = mkA "parental" ; --auto
lin paresis_N = mkN "parèsia" feminine ; --auto
lin paresthesia_N = mkN "parestèsia" feminine ; --auto
lin parietal_A = mkA "parietal" ; --auto
lin paris_1_PN = variants {} ; ---- sense to be split
lin paris_2_PN = variants {} ; ---- sense to be split
lin parish_N = mkN "parròquia" feminine ; --auto
lin parisian_A = mkA "parisenc" ; --auto
lin parisian_N = mkN "parisenc" masculine ; --auto
lin parity_N = mkN "paritat" feminine ; --auto
lin park_N = mkN "parc" masculine ;
lin park_V = mkV "aparcar" ; --auto
lin park_V2 = mkV2 "aparcar" ; --auto
lin parking_N = mkN "aparcament" masculine ; --auto
lin parliament_N = mkN "parlament" masculine ;
lin parliamentary_A = mkA "parlamentari" ; --auto
lin parody_N = mkN "paròdia" feminine ; --auto
lin paronychia_N = mkN "paroníquia" feminine ; --auto
lin paroxysm_N = mkN "paroxisme" masculine ; --auto
lin parquet_N = mkN "parquet" masculine ; --auto
lin parricide_N = mkN "parricidi" masculine ; --auto
lin parrot_N = mkN "lloro" masculine ; --auto
lin parsec_N = mkN "parsec" masculine | mkN "pàrsec" masculine ; --auto
lin parsimony_N = mkN "parsimònia" feminine ; --auto
lin parsley_N = mkN "julivert" masculine ; --auto
lin part_N = mkN "part" feminine ;
lin part_V = mkV "separar" ; --auto
lin part_V2 = mkV2 "separar" ; --auto
lin part_time_Adv = mkAdv "a temps parcial" ; --auto
lin parthenocarpy_N = mkN "partenocàrpia" feminine ; --auto
lin parthenogenesis_N = mkN "partenogènesi" feminine ; --auto
lin partial_A = mkA "parcial" ; --auto
lin participant_N = mkN "participant" ; --auto
lin participate_V = mkV "participar" ; --auto
lin participate_V2 = mkV2 "participar" ; --auto
lin participation_N = mkN "participació" feminine ; --auto
lin participatory_A = mkA "participatiu" ; --auto
lin participle_N = mkN "participi" masculine ; --auto
lin particle_N = mkN "partícula" feminine ; --auto
lin particular_A = mkA "particular" | mkA "concret" ;
lin particularism_N = mkN "particularisme" masculine ; --auto
lin partition_N = mkN "partició" feminine ; --auto
lin partly_Adv = mkAdv "en part" ; --auto
lin partner_N = mkN "parella" feminine ; --split "soci" (romantic vs. business)
lin partnership_N = mkN "societat" feminine ; --auto
lin partridge_N = mkN "perdiu" feminine ; --auto
lin party_1_N = mkN "partit" masculine ; --split mkN "festa" mkN "expedició"
lin party_2_N = mkN "partit" masculine ; --split mkN "festa" mkN "expedició"
lin pascal_N = mkN "pascal" masculine ; --auto
lin pass_N = mkN "passi" masculine ; --auto
lin pass_V = mkV "passar" ; --split "aprovar" (pass an exam)
lin pass_around_V2 = prepV2 OP_pass_V OP_around_Prep ; -- guess-p-verb
lin pass_as_V2 = prepV2 OP_pass_V OP_as_Prep ; -- guess-p-verb
lin pass_away_V = advV OP_pass_V OP_away_Adv ; -- guess-p-verb
lin pass_back_V2 = mkV2 (advV OP_pass_V OP_back_Adv ) ; -- guess-p-verb
lin pass_by_V = advV OP_pass_V OP_by_Adv ; -- guess-p-verb
lin pass_by_V2 = prepV2 OP_pass_V OP_by_Prep ; -- guess-p-verb
lin pass_down_V2 = prepV2 OP_pass_V OP_down_Prep ; -- guess-p-verb
lin pass_for_V2 = prepV2 OP_pass_V OP_for_Prep ; -- guess-p-verb
lin pass_off_V = advV OP_pass_V OP_off_Adv ; -- guess-p-verb
lin pass_off_V2 = prepV2 OP_pass_V OP_off_Prep ; -- guess-p-verb
lin pass_on_V = advV OP_pass_V OP_on_Adv ; -- guess-p-verb
lin pass_on_V2 = prepV2 OP_pass_V OP_on_Prep ; -- guess-p-verb
lin pass_on_to_V2 = prepV2 (advV OP_pass_V OP_on_Adv ) OP_to_Prep ; -- guess-p-verb
lin pass_out_V = advV OP_pass_V OP_out_Adv ; -- guess-p-verb
lin pass_out_V2 = prepV2 OP_pass_V OP_out_Prep ; -- guess-p-verb
lin pass_over_V = advV OP_pass_V OP_over_Adv ; -- guess-p-verb
lin pass_over_V2 = prepV2 OP_pass_V OP_over_Prep ; -- guess-p-verb
lin pass_round_V2 = prepV2 OP_pass_V OP_round_Prep ; -- guess-p-verb
lin pass_through_V2 = prepV2 OP_pass_V OP_through_Prep ; -- guess-p-verb
lin pass_to_V2 = prepV2 OP_pass_V OP_to_Prep ; -- guess-p-verb
lin pass_up_V2 = prepV2 OP_pass_V OP_up_Prep ; -- guess-p-verb
lin passage_N = mkN "pas" masculine | mkN "passatge" masculine ; --auto
lin passenger_N = mkN "passatger" | mkN "passatger" ; --auto
lin passing_N = mkN "mort" feminine | mkN "pas" masculine ; --auto
lin passion_N = mkN "passió" feminine ; --auto
lin passionate_A = mkA "apassionat" ; --auto
lin passive_A = mkA "passiu" ; --auto
lin passivity_N = mkN "passivitat" feminine ; --auto
lin passport_N = mkN "passaport" masculine ; --auto
lin password_N = mkN "contrasenya" feminine ; --auto
lin past_A = mkA "passat" ;
lin past_N = mkN "passat" masculine ;
lin pastime_N = mkN "passatemps" masculine | mkN "passatemps" masculine ; --auto
lin pastoral_A = mkA "pastoral" ; --auto
lin pastoral_N = mkN "pastoral" feminine ; --auto
lin pasture_N = mkN "pastura" feminine ; --auto
lin pasty_A = mkA "pastós" ; --auto
lin patching_N = mkN "apedaçament" masculine ; --auto
lin pate_1_N = variants {} ; ---- sense to be split
lin pate_2_N = variants {} ; ---- sense to be split
lin patent_N = mkN "patent" feminine ; --auto
lin patent_V2 = mkV2 "patentar" ; --auto
lin paternal_A = mkA "paternal" ; --auto
lin path_N = mkN "camí" masculine ;
lin pathogen_N = mkN "patogen" masculine ; --auto
lin pathogenesis_N = mkN "patogènesi" feminine ; --auto
lin pathological_A = mkA "patològic" ; --auto
lin pathologist_N = mkN "patòleg" feminine | mkN "patòleg" masculine ; --auto
lin pathology_N = mkN "patologia" feminine ; --auto
lin pathos_N = mkN "patetisme" masculine ; --auto
lin patience_N = mkN "paciència" feminine ; --auto
lin patient_A = mkA "pacient" ; --auto
lin patient_N = mkN "pacient" ;
lin patina_N = mkN "pàtina" feminine ; --auto
lin patriarch_N = mkN "patriarca" ; --auto
lin patriarchy_N = mkN "patriarcat" masculine ; --auto
lin patrilineal_A = mkA "patrilineal" ; --auto
lin patriot_N = mkN "patriota" ; --auto
lin patriotic_A = mkA "patriòtic" ; --auto
lin patriotism_N = mkN "patriotisme" masculine ; --auto
lin patrol_N = mkN "patrulla" feminine ; --auto
lin patronage_N = mkN "patronatge" masculine ; --auto
lin patter_N = mkN "remolinador" feminine | mkN "remolinador" masculine ; --auto
lin pattern_N = mkN "patró" masculine ;
lin pauperism_N = mkN "pauperisme" masculine ; --auto
lin pause_N = mkN "pausa" feminine ; --auto
lin pause_V = mkV "parar" ; --auto
lin pave_V2 = mkV2 "pavimentar" ; --auto
lin pavilion_N = mkN "pavelló" masculine ; --auto
lin paving_N = mkN "pavimentació" feminine ; --auto
lin pawn_N = mkN "peó" masculine ; --auto
lin pawn_V2 = mkV2 "empenyorar" ; --auto
lin pay_N = mkN "paga" feminine ; --auto
lin pay_V = mkV "pagar" ;
lin pay_V2 = mkV2 (mkV "pagar") ;
lin pay_V2V = mkV2V (mkV "pagar") ParadigmsCat.accusative (mkPrep "per") ;
lin pay_V3 = dirdirV3 (mkV "pagar") ;
lin pay_back_V = advV OP_pay_V OP_back_Adv ; -- guess-p-verb
lin pay_back_V2 = mkV2 (advV OP_pay_V OP_back_Adv ) ; -- guess-p-verb
lin pay_down_V2 = prepV2 OP_pay_V OP_down_Prep ; -- guess-p-verb
lin pay_for_V3 = variants {} ; -- guess-p-verb
lin pay_into_V3 = variants {} ; -- guess-p-verb
lin pay_off_V = advV OP_pay_V OP_off_Adv ; -- guess-p-verb
lin pay_off_V2 = prepV2 OP_pay_V OP_off_Prep ; -- guess-p-verb
lin pay_out_V = advV OP_pay_V OP_out_Adv ; -- guess-p-verb
lin pay_up_V = advV OP_pay_V OP_up_Adv ; -- guess-p-verb
lin payable_A = mkA "pagable" ; --auto
lin payday_N = mkN "dia de pagament" masculine ; --auto
lin payer_N = mkN "pagador" feminine | mkN "pagador" masculine ; --auto
lin payment_N = mkN "pagament" masculine ;
lin payroll_N = mkN "nòmina" feminine ; --auto
lin payslip_N = mkN "rebut de salari" masculine ; --auto
lin pea_N = mkN "pèsol" masculine ; --auto
lin peace_N = L.peace_N ;
lin peaceful_A = mkA "pacífic" ; --auto
lin peacemaker_N = mkN "pacificador" feminine | mkN "pacificador" masculine ; --auto
lin peach_N = mkN "préssec" masculine ; --auto
lin peacock_N = mkN "paó" masculine ; --auto
lin peafowl_N = mkN "paó" ; --auto
lin peahen_N = mkN "paó" feminine ; --auto
lin peak_N = mkN "cim" masculine ; --auto
lin peal_N = mkN "repic" masculine ; --auto
lin peanut_N = mkN "cacauet" masculine ; --auto
lin pear_N = mkN "pera" feminine ; --auto
lin peasantFem_N = variants {} ; ---- sense to be split
lin peasantMasc_N = variants {} ; ---- sense to be split
lin peasantry_N = mkN "pagesia" feminine ; --auto
lin peat_N = mkN "torba" feminine ; --auto
lin peaty_A = mkA "torbós" ; --auto
lin pebble_N = mkN "còdol" masculine ; --auto
lin pectin_N = mkN "pectina" feminine ; --auto
lin pectoral_A = mkA "pectoral" ; --auto
lin peculiar_A = mkA "estrany" | mkA "peculiar" ; --auto
lin peculiarity_N = mkN "peculiaritat" feminine ; --auto
lin pecuniary_A = mkA "pecuniari" ; --auto
lin pedagogical_A = mkA "pedagògic" ; --auto
lin pedagogueFem_N = variants {} ; ---- sense to be split
lin pedagogueMasc_N = variants {} ; ---- sense to be split
lin pedagogy_N = mkN "pedagogia" feminine ; --auto
lin pedal_A = mkA "pedial" ; --auto
lin pedal_N = mkN "pedal" masculine ; --auto
lin pedant_N = mkN "pedant" ; --auto
lin pedantic_A = mkA "pedant" ; --auto
lin pederast_N = mkN "pederasta" masculine ; --auto
lin pederastic_A = mkA "pederàstic" ; --auto
lin pederasty_N = mkN "pederàstia" feminine ; --auto
lin pedestrian_N = mkN "vianant" ; --auto
lin pediatrician_N = mkN "pediatre" | mkN "pediatre" feminine | mkN "pediatre" | mkN "pediatre" masculine ; --auto
lin pediatrics_N = mkN "pediatria" feminine ; --auto
lin pedicel_N = mkN "pedicel" masculine ; --auto
lin pediculosis_N = mkN "pediculosi" feminine ; --auto
lin pedicure_N = mkN "pedicura" feminine ; --auto
lin pedigree_N = mkN "pedigrí" masculine ; --auto
lin pediment_N = mkN "pediment" masculine ; --auto
lin pedophilia_N = mkN "pedofília" feminine ; --auto
lin peduncle_N = mkN "peduncle" masculine ; --auto
lin peel_N = mkN "pela" feminine ; --auto
lin peel_V = mkV "pelar" ; --auto
lin peel_V2 = mkV2 "pelar" ; --auto
lin peephole_N = mkN "espiell" masculine ; --auto
lin peer_V = mkV "mirar atentament" ; --auto
lin peg_N = mkN "clàvia" feminine ; --auto
lin pegmatite_N = mkN "pegmatita" feminine ; --auto
lin pejorative_A = mkA "despectiu" | mkA "pejoratiu" ; --auto
lin pellagra_N = mkN "pel·lagra" feminine ; --auto
lin pellet_N = mkN "piloteta" feminine ; --auto
lin pelvic_A = mkA "pèlvic" ; --auto
lin pelvis_N = mkN "pelvi" feminine ; --auto
lin pen_1_N = L.pen_N ;
lin pen_2_N = L.pen_N ;
lin penal_A = mkA "penal" ; --auto
lin penalty_N = mkN "penalització" feminine | mkN "pena" feminine ; --auto
lin penance_N = mkN "penitència" feminine ; --auto
lin pencil_N = mkN "llapis" masculine | mkN "llapis" masculine ; --auto
lin pendant_N = mkN "pendant" masculine | mkN "penjoll" masculine ; --auto
lin pendulum_N = mkN "pèndol" masculine ; --auto
lin penetrability_N = mkN "penetrabilitat" feminine ; --auto
lin penetrate_V = mkV "penetrar" ; --auto
lin penetrate_V2 = mkV2 "penetrar" ; --auto
lin penetration_N = mkN "penetració" feminine ; --auto
lin penguin_N = mkN "pingüí" masculine ; --auto
lin penicillin_N = mkN "penicil·lina" feminine ; --auto
lin peninsula_N = mkN "península" feminine ; --auto
lin peninsular_A = mkA "peninsular" ; --auto
lin penis_N = mkN "penis" masculine | mkN "penis" masculine ; --auto
lin penknife_N = mkN "navalla" feminine ; --auto
lin pennant_N = mkN "gallardet" masculine ; --auto
lin penny_N = mkN "penic" masculine ; --auto
lin pension_N = mkN "pensió" feminine ; --auto
lin pentagon_N = mkN "pentàgon" masculine ; --auto
lin pentagonal_A = mkA "pentagonal" ; --auto
lin pentahedron_N = mkN "pentaedre" masculine ; --auto
lin pentameter_N = mkN "pentàmetre" masculine ; --auto
lin pentathlete_N = mkN "pentatleta" ; --auto
lin pentathlon_N = mkN "pentatló" masculine ; --auto
lin pentode_N = mkN "pèntode" masculine ; --auto
lin pentose_N = mkN "pentosa" feminine ; --auto
lin penultimate_A = mkA "penúltim" ; --auto
lin people_N = mkN "gent" "gent" feminine ;
lin peoples_N = mkN "poble" masculine ; --auto
lin pepper_N = mkN "pebre" masculine | mkN "pebrot" masculine ; --auto
lin pepsin_N = mkN "pepsina" feminine ; --auto
lin peptide_N = mkN "pèptid" masculine ; --auto
lin per_Prep = mkPrep "per" ;
lin perceivable_A = mkA "perceptible" ; --auto
lin perceive_V2 = mkV2 "percebre" ; --auto
lin percent_N = mkN "percentatge" masculine ;
lin percentage_N = mkN "percentatge" masculine ; --auto
lin perception_N = mkN "percepció" feminine ; --auto
lin perceptive_A = mkA "perspicaç" ; --auto
lin perch_N = mkN "perxa" feminine ; --auto
lin percolation_N = mkN "percolació" feminine ; --auto
lin percolator_N = mkN "percolador" masculine ; --auto
lin percussion_N = mkN "percussió" feminine ; --auto
lin percussionist_N = mkN "percussionista" ; --auto
lin peremptory_A = mkA "peremptori" ; --auto
lin perennial_A = mkA "perenne" ; --auto
lin perestroika_N = mkN "perestroika" feminine ; --auto
lin perfect_A = mkA "perfecte" ; --auto
lin perfect_V2 = mkV2 "perfeccionar" ; --auto
lin perfection_N = mkN "perfecció" feminine ; --auto
lin perfectionism_N = mkN "perfeccionisme" masculine ; --auto
lin perfectionist_N = mkN "perfeccionista" ; --auto
lin perforce_Adv = mkAdv "per força" ; --auto
lin perform_V = mkV "representar" ; --split same as above
lin perform_V2 = mkV2 (mkV "representar") ; -- split "realitzar" "fer" (acting vs. do)
lin performance_1_N = mkN "actuació" masculine ; --split "rendiment" (theatre vs. physical performance)
lin performance_2_N = mkN "actuació" masculine ; --split "rendiment" (theatre vs. physical performance)
lin performer_N = mkN "intèrpret" ; --auto
lin perfume_N = mkN "perfum" masculine ; --auto
lin perfume_V2 = mkV2 "perfumar" ; --auto
lin perfumerFem_N = variants {} ; ---- sense to be split
lin perfumerMasc_N = variants {} ; ---- sense to be split
lin perfumery_N = mkN "perfumeria" feminine ; --auto
lin perhaps_Adv = mkAdv "potser" ;
lin perianth_N = mkN "periant" masculine ; --auto
lin pericardium_N = mkN "pericardi" masculine ; --auto
lin pericarp_N = mkN "pericarpi" masculine ; --auto
lin peridot_N = mkN "peridot" masculine ; --auto
lin peridotite_N = mkN "peridotita" feminine ; --auto
lin perihelion_N = mkN "periheli" masculine ; --auto
lin perilymph_N = mkN "perilimfa" feminine ; --auto
lin perimeter_N = mkN "perímetre" masculine ; --auto
lin perimysium_N = mkN "perimisi" feminine ; --auto
lin perineal_A = mkA "perineal" ; --auto
lin perineum_N = mkN "perineu" masculine ; --auto
lin perineurium_N = mkN "perineuri" masculine ; --auto
lin period_1_N = mkN "període" masculine ; --split mkN "regla" feminine
lin period_2_N = mkN "període" masculine ; --split mkN "regla" feminine
lin period_3_N = mkN "període" masculine ; --split mkN "regla" feminine
lin periodic_A = mkA "periòdic" ; --auto
lin periosteum_N = mkN "periosti" feminine ; --auto
lin peripheral_A = mkA "perifèric" ; --auto
lin peripheral_N = mkN "perifèric" masculine ; --auto
lin periphery_N = mkN "perifèria" feminine ; --auto
lin periphrasis_N = mkN "perífrasi" feminine ; --auto
lin periphrastic_A = mkA "perifràstic" ; --auto
lin peripteral_A = mkA "perípter" ; --auto
lin periscope_N = mkN "periscopi" masculine ; --auto
lin perishable_A = mkA "perible" ; --auto
lin perithelium_N = mkN "periteli" masculine ; --auto
lin peritoneum_N = mkN "peritoneu" masculine ; --auto
lin perjury_N = mkN "perjuri" masculine ; --auto
lin permafrost_N = mkN "pergelisòl" masculine ; --auto
lin permanence_N = mkN "permanència" feminine ; --auto
lin permanent_A = mkA "permanent" ; --auto
lin permeability_N = mkN "permeabilitat" feminine ; --auto
lin permeable_A = mkA "permeable" ; --auto
lin permissible_A = mkA "permissible" ; --auto
lin permission_N = mkN "permís" masculine ; --auto
lin permit_N = mkN "permís" masculine ; --auto
lin permit_V = mkV "permetre" ; --auto
lin permit_V2 = mkV2 "permetre" ; --auto
lin permutation_N = mkN "permutació" feminine ; --auto
lin peroxide_N = mkN "peròxid" masculine ; --auto
lin perpendicular_A = mkA "perpendicular" ; --auto
lin perpendicular_N = mkN "perpendicular" feminine ; --auto
lin perpendicularity_N = mkN "perpendicularitat" feminine ; --auto
lin perpetual_A = mkA "perpetu" ; --auto
lin perpetuate_V2 = mkV2 "perpetuar" ; --auto
lin persecution_N = mkN "persecució" feminine ; --auto
lin persianFem_N = variants {} ; ---- sense to be split
lin persianMasc_N = variants {} ; ---- sense to be split
lin persian_A = mkA "persa" ; --auto
lin persimmon_N = mkN "persimó" masculine ; --auto
lin persist_V = mkV "persistir" ; --auto
lin persistence_N = mkN "persistència" feminine ; --auto
lin persistent_A = mkA "persistent" ; --auto
lin person_N = L.person_N ;
lin personal_A = mkA "personal" ;
lin personality_N = mkN "personalitat" feminine ; --auto
lin personification_N = mkN "personificació" feminine ; --auto
lin personnel_N = mkN "personal" masculine ; --auto
lin perspective_N = mkN "perspectiva" feminine ; --auto
lin perspicacity_N = mkN "perspicàcia" feminine ; --auto
lin persuade_V2 = mkV2 "persuadir" ; --auto
lin persuasion_N = mkN "persuasió" feminine ; --auto
lin pertinent_A = mkA "pertinent" | mkA "procedent" ; --auto
lin perturb_V2 = mkV2 "pertorbar" ; --auto
lin perturbation_N = mkN "pertorbació" feminine ; --auto
lin peruvian_A = mkA "peruà" ; --auto
lin peruvian_N = mkN "peruà" | mkN "peruà" ; --auto
lin perverse_A = mkA "pervers" ; --auto
lin perversion_N = mkN "perversió" feminine ; --auto
lin perversity_N = mkN "perversitat" feminine ; --auto
lin pervert_V2 = mkV2 "pervertir" ; --auto
lin peseta_N = mkN "pesseta" feminine ; --auto
lin pessary_N = mkN "pessari" masculine ; --auto
lin pessimism_N = mkN "pessimisme" masculine ; --auto
lin pessimistFem_N = variants {} ; ---- sense to be split
lin pessimistMasc_N = variants {} ; ---- sense to be split
lin pessimistic_A = mkA "pessimista" ; --auto
lin pest_N = mkN "plaga" feminine ; --auto
lin pet_N = mkN "animal de companyia" masculine | mkN "mascota" feminine ; --auto
lin petal_N = mkN "pètal" masculine ; --auto
lin petechia_N = mkN "petèquia" feminine ; --auto
lin petiole_N = mkN "pecíol" masculine ; --auto
lin petrify_V = mkV "petrificar" ; --auto
lin petrify_V2 = mkV2 "petrificar" ; --auto
lin petrochemical_N = mkN "producte petroquímic" masculine ; --auto
lin petrol_N = mkN "gasolina" feminine ; --auto
lin petroleum_N = mkN "petroli" masculine ; --auto
lin petrology_N = mkN "petrologia" feminine ; --auto
lin phagocyte_N = mkN "fagòcit" masculine ; --auto
lin phagocytosis_N = mkN "fagocitosi" feminine ; --auto
lin phallic_A = mkA "fàl·lic" ; --auto
lin phalloplasty_N = mkN "faloplàstia" feminine ; --auto
lin phallus_N = mkN "fal·lus" masculine | mkN "fal·lus" masculine ; --auto
lin pharaoh_N = mkN "faraó" masculine ; --auto
lin pharmaceutical_A = mkA "farmacèutic" ; --auto
lin pharmacologist_N = mkN "farmacòleg" feminine | mkN "farmacòleg" masculine ; --auto
lin pharmacology_N = mkN "farmacologia" feminine ; --auto
lin pharmacopoeia_N = mkN "farmacopea" feminine ; --auto
lin pharmacy_1_N = mkN "farmàcia" feminine ; --auto
lin pharmacy_2_N = mkN "farmàcia" feminine ;
lin phase_N = mkN "fase" feminine ; --auto
lin pheasant_N = mkN "faisà" feminine | mkN "faisà" masculine ; --auto
lin phenol_N = mkN "fenol" masculine ; --auto
lin phenomenal_A = mkA "fenomenal" ; --auto
lin phenomenology_N = mkN "fenomenologia" feminine ; --auto
lin phenomenon_N = mkN "fenomen" masculine ; --auto
lin phenothiazine_N = mkN "fenotiazina" feminine ; --auto
lin phenotype_N = mkN "fenotip" masculine ; --auto
lin phenylbutazone_N = mkN "fenilbutazona" feminine ; --auto
lin pheromone_N = mkN "feromona" feminine ; --auto
lin philippine_A = mkA "filipí" ; --auto
lin philistine_N = mkN "filisteu" feminine | mkN "filisteu" masculine ; --auto
lin philological_A = mkA "filològic" ; --auto
lin philologist_N = mkN "filòleg" | mkN "filòleg" ; --auto
lin philology_N = mkN "filologia" feminine ; --auto
lin philosopher_N = mkN "filòsof" | mkN "filòsof" ; --auto
lin philosophical_A = mkA "filosòfic" ; --auto
lin philosophy_N = mkN "filosofia" feminine ; --auto
lin phimosis_N = mkN "fimosi" feminine ; --auto
lin phloem_N = mkN "floema" masculine ; --auto
lin phlogopite_N = mkN "flogopita" feminine ; --auto
lin phobia_N = mkN "fòbia" feminine ; --auto
lin phocomelia_N = mkN "focomèlia" feminine ; --auto
lin phone_N = mkN "telèfon" masculine ;
lin phone_V = mkV "telefonar" ; --auto
lin phone_V2 = mkV2 "telefonar" ; --auto
lin phoneme_N = mkN "fonema" masculine ; --auto
lin phonemic_A = mkA "fonemàtic" ; --auto
lin phonemics_N = mkN "fonemàtica" feminine ; --auto
lin phonetician_N = mkN "fonetista" ; --auto
lin phonetics_N = mkN "fonètica" feminine ; --auto
lin phoney_A = mkA "farsant" ; --auto
lin phonic_A = mkA "fònic" ; --auto
lin phonogram_N = mkN "fonograma" masculine ; --auto
lin phonograph_N = mkN "fonògraf" masculine ; --auto
lin phonological_A = mkA "fonològic" ; --auto
lin phonologist_N = mkN "fonòleg" feminine | mkN "fonòleg" masculine ; --auto
lin phonology_N = mkN "fonologia" feminine ; --auto
lin phony_A = mkA "farsant" ; --auto
lin phosphate_N = mkN "fosfat" masculine ; --auto
lin phosphine_N = mkN "fosfina" feminine ; --auto
lin phosphocreatine_N = mkN "fosfocreatina" feminine ; --auto
lin phospholipid_N = mkN "fosfolípid" masculine ; --auto
lin phosphorescence_N = mkN "fosforescència" feminine ; --auto
lin phosphorus_N = mkN "fòsfor" masculine ; --auto
lin photo_N = mkN "foto" feminine ; --auto
lin photochemical_A = mkA "fotoquímic" ; --auto
lin photocopier_N = mkN "fotocopiadora" feminine ; --auto
lin photocopy_N = mkN "fotocòpia" feminine ; --auto
lin photocopy_V2 = mkV2 "fotocopiar" ; --auto
lin photoelectric_A = mkA "fotoelèctric" ; --auto
lin photograph_N = mkN "fotografia" feminine ; --auto
lin photograph_V2 = mkV2 "fotografiar" ; --auto
lin photographer_N = mkN "fotògraf" | mkN "fotògraf" ; --auto
lin photographic_A = mkA "fotogràfic" ; --auto
lin photography_N = mkN "fotografia" feminine ; --auto
lin photomechanics_N = mkN "fotomecànica" feminine ; --auto
lin photometer_N = mkN "fotòmetre" masculine ; --auto
lin photometric_A = mkA "fotomètric" ; --auto
lin photometry_N = mkN "fotometria" feminine ; --auto
lin photon_N = mkN "fotó" masculine ; --auto
lin photosynthesis_N = mkN "fotosíntesi" feminine ; --auto
lin photosynthetic_A = mkA "fotosintètic" ; --auto
lin photovoltaic_A = mkA "fotovoltaic" ; --auto
lin phrase_N = mkN "frase" feminine ; --auto
lin phraseology_N = mkN "fraseologia" feminine ; --auto
lin phreatic_A = mkA "freàtic" ; --auto
lin phthisis_N = mkN "tisi" feminine ; --auto
lin phylogenetic_A = mkA "filogenètic" ; --auto
lin physical_A = mkA "físic" ;
lin physicist_N = mkN "físic" feminine | mkN "físic" masculine ; --auto
lin physics_N = mkN "física" feminine ; --auto
lin physiological_A = mkA "fisiològic" ; --auto
lin physiologist_N = mkN "fisiòleg" feminine | mkN "fisiòleg" masculine ; --auto
lin physiology_N = mkN "fisiologia" feminine ; --auto
lin physiotherapist_N = mkN "fisioterapeuta" ; --auto
lin physiotherapy_N = mkN "fisioteràpia" feminine ; --auto
lin phytoplankton_N = mkN "fitoplàncton" masculine ; --auto
lin pianistFem_N = variants {} ; ---- sense to be split
lin pianistMasc_N = variants {} ; ---- sense to be split
lin piano_Adv = mkAdv "piano" ; --auto
lin piano_N = mkN "piano" masculine ; --auto
lin picaresque_A = mkA "picaresc" ; --auto
lin pick_V = mkV "triar" ;
lin pick_V2 = mkV2 (mkV "triar") ; --split "collir" (choose vs fruit picking)
lin pick_at_V2 = prepV2 OP_pick_V OP_at_Prep ; -- guess-p-verb
lin pick_away_V = advV OP_pick_V OP_away_Adv ; -- guess-p-verb
lin pick_off_V2 = prepV2 OP_pick_V OP_off_Prep ; -- guess-p-verb
lin pick_on_V2 = prepV2 OP_pick_V OP_on_Prep ; -- guess-p-verb
lin pick_out_V2 = prepV2 OP_pick_V OP_out_Prep ; -- guess-p-verb
lin pick_through_V2 = prepV2 OP_pick_V OP_through_Prep ; -- guess-p-verb
lin pick_up_V = advV OP_pick_V OP_up_Adv ; -- guess-p-verb
lin pick_up_V2 = prepV2 OP_pick_V OP_up_Prep ; -- guess-p-verb
lin pick_up_after_V2 = prepV2 (advV OP_pick_V OP_up_Adv ) OP_after_Prep ; -- guess-p-verb
lin pick_up_on_V2 = prepV2 (advV OP_pick_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin pick_yourself_up_V = variants {} ; -- guess-p-verb
lin pickaxe_N = mkN "piqueta" feminine ; --auto
lin picket_N = mkN "piquet" masculine ; --auto
lin pickle_N = mkN "decapant" masculine ; --auto
lin pickpocket_N = mkN "carterista" ; --auto
lin picnic_N = mkN "pícnic" masculine ; --auto
lin picofarad_N = mkN "picofarad" masculine ; --auto
lin pictographic_A = mkA "pictogràfic" ; --auto
lin pictorial_A = mkA "pictòric" ; --auto
lin picture_N = mkN "dibuix" masculine ;
lin picturesque_A = mkA "pintoresc" ; --auto
lin pie_N = mkN "pastell" masculine | mkN "pastís" masculine ; --auto
lin piece_N = mkN "tros" masculine ;
lin piedmont_N = mkN "piemont" masculine ; --auto
lin piezoelectric_A = mkA "piezoelèctric" ; --auto
lin piezoelectricity_N = mkN "piezoelectricitat" feminine ; --auto
lin piezometer_N = mkN "piezòmetre" masculine ; --auto
lin pig_N = mkN "porc" masculine ; --auto
lin pigeon_N = mkN "colom" feminine | mkN "colom" masculine ; --auto
lin pigeonhole_N = mkN "caseller" masculine ; --auto
lin piggyback_Adv = mkAdv "a coll" ; --auto
lin piglet_N = mkN "garrí" masculine ; --auto
lin pigment_N = mkN "pigment" masculine ; --auto
lin pilaster_N = mkN "pilastra" feminine ; --auto
lin pile_N = mkN "estaca" feminine | mkN "pila" feminine ; --auto
lin pilgrim_N = mkN "pelegrí" | mkN "pelegrí" ; --auto
lin pilgrimage_N = mkN "pelegrinatge" masculine ; --auto
lin pill_N = mkN "píndola" feminine ; --auto
lin pillage_N = mkN "pillatge" masculine ; --auto
lin pillar_N = mkN "pilar" masculine ; --auto
lin pillory_N = mkN "picota" feminine ; --auto
lin pilot_N = mkN "pilot" ; --auto
lin pilot_V2 = mkV2 "pilotar" ; --auto
lin pimp_N = mkN "proxeneta" ; --auto
lin pin_N = mkN "agulla de cap" feminine | mkN "clavilla" feminine | mkN "passador" masculine ; --auto
lin pin_V2 = mkV2 "clavar" ; --auto
lin pinch_N = mkN "polsim" masculine ; --auto
lin pinch_V = mkV "pessigar" ; --auto
lin pinch_V2 = mkV2 "pessigar" ; --auto
lin pine_N = mkN "pi" masculine ; --auto
lin pineapple_N = mkN "pinya" feminine ; --auto
lin pinion_N = mkN "pinyó" masculine ; --auto
lin pink_A = mkA "rosa" | mkA "rosat" ; --auto
lin pink_N = mkN "rosa" masculine ; --auto
lin pinocytosis_N = mkN "pinocitosi" feminine ; --auto
lin pint_N = mkN "pinta" feminine ; --auto
lin pion_N = mkN "pió" masculine ; --auto
lin pioneer_N = mkN "pioner" | mkN "pioner" ; --auto
lin pioneer_V = mkV "iniciar" ; --auto
lin pioneer_V2 = mkV2 "iniciar" ; --auto
lin pious_A = mkA "piadós" | mkA "pietós" ; --auto
lin pipe_1_N = mkN "canonada" feminine | mkN "conducte" masculine | mkN "pipa" feminine | mkN "tub" masculine ; --auto
lin pipe_2_N = mkN "canonada" feminine | mkN "conducte" masculine | mkN "pipa" feminine | mkN "tub" masculine ; --auto
lin pipe_V = mkV "canalitzar" ; --auto
lin pipe_V2 = mkV2 "canalitzar" ; --auto
lin pipeline_N = mkN "conducció" feminine | mkN "gasoducte" masculine | mkN "oleoducte" masculine ; --auto
lin pipette_N = mkN "pipeta" feminine ; --auto
lin piracy_N = mkN "pirateria" feminine ; --auto
lin pirate_N = mkN "pirata" ; --auto
lin pirate_V2 = mkV2 "piratejar" ; --auto
lin pirouette_N = mkN "pirueta" feminine ; --auto
lin pistil_N = mkN "pistil" masculine ; --auto
lin pit_N = mkN "fossa" feminine ; --auto
lin pitch_N = mkN "aiguavés" masculine | mkN "brea" feminine | mkN "to" masculine ; --auto
lin pitcher_N = mkN "cànter" masculine | mkN "càntir" masculine ; --auto
lin pitching_N = mkN "capcineig" masculine ; --auto
lin pitiful_A = mkA "llastimós" ; --auto
lin pittance_N = mkN "misèria" feminine ; --auto
lin pituitary_N = mkN "pituïtària" feminine ; --auto
lin pity_N = mkN "llàstima" feminine | mkN "pena" feminine | mkN "llàstima" feminine | mkN "llàstima" feminine ; --auto
lin pity_V2 = mkV2 "compadir" ; --auto
lin pityriasis_N = mkN "pitiriasi" feminine ; --auto
lin pixel_N = mkN "píxel" masculine ; --auto
lin pizza_N = mkN "pizza" feminine ; --auto
lin pizzicato_Adv = mkAdv "pizzicato" ; --auto
lin place_N = mkN "lloc" masculine ;
lin place_V2 = mkV2 (mkV "col·locar") ;
lin placebo_N = mkN "placebo" masculine ; --auto
lin placenta_N = mkN "placenta" feminine ; --auto
lin placer_N = mkN "placer" masculine ; --auto
lin placing_N = mkN "col·locació" feminine ; --auto
lin plagiarism_N = mkN "plagi" masculine ; --auto
lin plagioclase_N = mkN "plagiòclasi" feminine ; --auto
lin plague_N = mkN "pesta" feminine ; --auto
lin plaice_N = mkN "pelaia" feminine ; --auto
lin plain_A = mkA "senzill" ; --auto
lin plain_N = mkN "planada" feminine | mkN "plana" feminine ; --auto
lin plait_N = mkN "trena" feminine ; --auto
lin plan_N = mkN "pla" masculine ;
lin plan_V = mkV "planejar" ;
lin plan_V2 = mkV2 (mkV "planejar") ;
lin plan_V2V = mkV2V (mkV "planificar") ParadigmsCat.accusative ParadigmsCat.dative ; --subcat should be a VS
lin plan_VS = mkVS (mkV "planejar") ;
lin plan_VV = mkVV (mkV "planejar") ;
lin planar_A = mkA "planar" ; --auto
lin planation_N = mkN "arrasament" masculine ; --auto
lin plane_N = mkN "avió" masculine | mkN "pla" masculine | mkN "ribot" masculine ; --auto
lin planet_N = L.planet_N ;
lin planetary_A = mkA "planetari" ; --auto
lin plankton_N = mkN "plàncton" masculine ; --auto
lin planner_N = mkN "planificador" feminine | mkN "planificador" masculine ; --auto
lin planning_N = mkN "planificació" feminine ;
lin plant_1_N = mkN "planta" feminine ;
lin plant_2_N = mkN "planta" feminine ;
lin plant_V2 = mkV2 "plantar" ; --auto
lin plant_out_V2 = prepV2 (lin V OP_plant_V2) OP_out_Prep ; -- guess-p-verb
lin plantation_N = mkN "plantació" feminine ; --auto
lin planting_N = mkN "plantada" feminine ; --auto
lin plasma_N = mkN "plasma" masculine ; --auto
lin plasmapheresis_N = mkN "plasmafèresi" feminine ; --auto
lin plasmid_N = mkN "plasmidi" masculine ; --auto
lin plasmodium_N = mkN "plasmodi" masculine ; --auto
lin plaster_N = mkN "guix" masculine ; --auto
lin plaster_V2 = mkV2 "enguixar" ; --auto
lin plastic_A = mkA "plàstic" ; --auto
lin plastic_N = L.plastic_N ;
lin plasticity_N = mkN "plasticitat" feminine ; --auto
lin plasticizer_N = mkN "plastificant" masculine ; --auto
lin plastid_N = mkN "plastidi" masculine ; --auto
lin plastron_N = mkN "plastró" masculine ; --auto
lin plate_N = mkN "làmina" feminine | mkN "placa" feminine | mkN "planxa" feminine | mkN "plat" masculine ; --auto
lin plate_V2 = mkV2 "xapar" ; --auto
lin plateau_N = mkN "planell" masculine ; --auto
lin platelet_N = mkN "plaqueta" feminine ; --auto
lin platen_N = mkN "platina" feminine ; --auto
lin platform_N = mkN "plataforma" feminine ; --auto
lin platinum_N = mkN "platí" masculine ; --auto
lin platitudinous_A = mkA "banal" ; --auto
lin platonic_A = mkA "platònic" ; --auto
lin platypus_N = mkN "ornitorinc" masculine ; --auto
lin plausible_A = mkA "versemblant" ; --auto
lin play_1_V = L.play_V ;
lin play_1_V2 = L.play_V2 ;
lin play_2_V = L.play_V ;
lin play_2_V2 = L.play_V2 ;
lin play_3_V = L.play_V ;
lin play_3_V2 = L.play_V2 ;
lin play_N = compN (mkN "obra") "de teatre" ;
lin play_along_V = advV OP_play_V OP_along_Adv ; -- guess-p-verb
lin play_around_V = advV OP_play_V OP_around_Adv ; -- guess-p-verb
lin play_at_V2 = prepV2 OP_play_V OP_at_Prep ; -- guess-p-verb
lin play_away_V = advV OP_play_V OP_away_Adv ; -- guess-p-verb
lin play_back_V2 = mkV2 (advV OP_play_V OP_back_Adv ) ; -- guess-p-verb
lin play_down_V2 = prepV2 OP_play_V OP_down_Prep ; -- guess-p-verb
lin play_off_V = advV OP_play_V OP_off_Adv ; -- guess-p-verb
lin play_off_V2 = prepV2 OP_play_V OP_off_Prep ; -- guess-p-verb
lin play_on_V = advV OP_play_V OP_on_Adv ; -- guess-p-verb
lin play_on_V2 = prepV2 OP_play_V OP_on_Prep ; -- guess-p-verb
lin play_out_V = advV OP_play_V OP_out_Adv ; -- guess-p-verb
lin play_out_V2 = prepV2 OP_play_V OP_out_Prep ; -- guess-p-verb
lin play_up_V = advV OP_play_V OP_up_Adv ; -- guess-p-verb
lin play_up_V2 = prepV2 OP_play_V OP_up_Prep ; -- guess-p-verb
lin play_up_to_V2 = prepV2 (advV OP_play_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin play_upon_V2 = prepV2 OP_play_V OP_upon_Prep ; -- guess-p-verb
lin play_with_V2 = prepV2 OP_play_V OP_with_Prep ; -- guess-p-verb
lin playboy_N = mkN "playboy" masculine ; --auto
lin player_N = mkN "jugador" ;
lin playground_N = mkN "pati" masculine ; --auto
lin play_off_N = mkN "play-off" masculine ; --auto
lin plea_N = mkN "descàrrec" masculine ; --auto
lin pleasant_A = mkA "agradable" ; --auto
lin please_Adv = mkAdv "si et plau" ;
lin please_V = mkV "complaure" ; --auto
lin please_V2 = mkV2 "complaure" ; --auto
lin please_Voc = S.please_Voc ;
lin pleasure_N = mkN "plaer" masculine ; --auto
lin plebeian_N = mkN "plebeu" feminine | mkN "plebeu" masculine ; --auto
lin plebiscite_N = mkN "plebiscit" masculine ; --auto
lin plectrum_N = mkN "plectre" masculine ; --auto
lin pledge_N = mkN "promesa" feminine ; --auto
lin pledge_V2 = mkV2 "prometre" ; --auto
lin plenipotentiary_N = mkN "plenipotenciari" feminine | mkN "plenipotenciari" masculine ; --auto
lin plenty_N = mkN "abundància" feminine ; --auto
lin pleochroism_N = mkN "pleocroisme" masculine ; --auto
lin pleonasm_N = mkN "pleonasme" masculine ; --auto
lin pleonastic_A = mkA "pleonàstic" ; --auto
lin pleura_N = mkN "pleura" feminine ; --auto
lin pleural_A = mkA "pleural" ; --auto
lin pleurodynia_N = mkN "pleurodínia" feminine ; --auto
lin plexus_N = mkN "plexe" masculine ; --auto
lin pliers_N = mkN "alicates" feminine ; --auto
lin plosion_N = mkN "plosió" feminine ; --auto
lin plot_N = mkN "complot" masculine | mkN "parcel·la" feminine | mkN "trama" feminine ; --auto
lin plough_V = mkV "llaurar" ; --auto
lin plough_V2 = mkV2 "llaurar" ; --auto
lin plug_N = mkN "bugia" feminine | mkN "clavilla" feminine | mkN "endoll" masculine | mkN "tap" masculine ; --auto
lin plum_N = mkN "pruna" feminine ; --auto
lin plumage_N = mkN "plomatge" masculine ; --auto
lin plumb_V2 = mkV2 "aplomar" ; --auto
lin plume_N = mkN "plomall" masculine ; --auto
lin plunder_V = mkV "saquejar" ; --auto
lin plunder_V2 = mkV2 "saquejar" ; --auto
lin plunger_N = mkN "desembussador" masculine ; --auto
lin pluperfect_N = mkN "plusquamperfet" masculine ; --auto
lin plural_A = mkA "plural" ; --auto
lin plural_N = mkN "plural" masculine ; --auto
lin pluralism_N = mkN "pluralisme" masculine ; --auto
lin pluralist_N = mkN "pluralista" ; --auto
lin plurality_N = mkN "pluralitat" feminine ; --auto
lin plus_N = mkN "plus" masculine ; --auto
lin plus_Prep = mkPrep "més" ;
lin plutocratic_A = mkA "plutocràtic" ; --auto
lin plutonium_N = mkN "plutoni" masculine ; --auto
lin ply_N = mkN "xapa" feminine ; --auto
lin plywood_N = mkN "contraplacat" masculine | mkN "contraxapat" masculine ; --auto
lin pneumatic_A = mkA "pneumàtic" ; --auto
lin pneumatics_N = mkN "pneumàtica" feminine ; --auto
lin pneumococcus_N = mkN "pneumococ" masculine ; --auto
lin pneumoconiosis_N = mkN "pneumoconiosi" feminine ; --auto
lin pneumonia_N = mkN "pneumònia" feminine ; --auto
lin pocket_N = mkN "butxaca" feminine ; --auto
lin pod_N = mkN "tavella" feminine ; --auto
lin podiatry_N = mkN "podologia" feminine ; --auto
lin podium_N = mkN "pòdium" masculine ; --auto
lin poem_N = mkN "poema" masculine ; --auto
lin poet_N = mkN "poeta" ; --auto
lin poetic_A = mkA "poètic" ; --auto
lin poetics_N = mkN "poètica" feminine ; --auto
lin poetry_N = mkN "poesia" feminine ; --auto
lin pogrom_N = mkN "pogrom" masculine ; --auto
lin poignant_A = mkA "patètic" ; --auto
lin poikilothermic_A = mkA "poikiloterm" ; --auto
lin point_1_N = mkN "punt" masculine ;
lin point_2_N = mkN "punt" masculine ;
lin point_V = mkV "assenyalar" ;
lin point_V2 = mkV2 (mkV "assenyalar") ;
lin point_out_V2 = prepV2 OP_point_V OP_out_Prep ; -- guess-p-verb
lin point_out_VS = variants {} ; -- guess-p-verb
lin point_up_V = advV OP_point_V OP_up_Adv ; -- guess-p-verb
lin pointed_A = mkA "puntegut" ; --auto
lin pointer_N = mkN "punter" masculine ; --auto
lin poison_N = mkN "verí" masculine ; --auto
lin poison_V2 = mkV2 "enverinar" ; --auto
lin poisoner_N = mkN "enverinador" feminine | mkN "enverinador" masculine ; --auto
lin poisoning_N = mkN "emmetzinament" masculine | mkN "enverinament" masculine ; --auto
lin poisonous_A = mkA "verinós" ; --auto
lin poker_N = mkN "pòquer" masculine ; --auto
lin polar_A = mkA "polar" ; --auto
lin polarimeter_N = mkN "polarímetre" masculine ; --auto
lin polarity_N = mkN "polaritat" feminine ; --auto
lin polarography_N = mkN "polarografia" feminine ; --auto
lin pole_N = mkN "pal" masculine | mkN "pol" masculine ; --auto
lin polecat_N = mkN "fura" feminine ; --auto
lin polemic_A = mkA "polèmic" ; --auto
lin polemicist_N = mkN "polemista" ; --auto
lin police_N = mkN "policia" feminine ;
lin police_station_N = mkN "estació de policia" feminine ; --auto
lin policeman_N = L.policeman_N ;
lin policewoman_N = mkN "policia" feminine ; --auto
lin policy_N = mkN "política" feminine ;
lin polishFem_N = mkN "abrillantador" masculine ; --auto ---- sense to be split
lin polishMasc_N = mkN "abrillantador" masculine ; --auto ---- sense to be split
lin polish_A = mkA "polon" ;
lin polish_N = mkN "abrillantador" masculine ; --auto
lin polish_V = mkV "lustrar" ; --auto
lin polish_V2 = mkV2 "lustrar" ; --auto
lin polisher_N = mkN "polidor" feminine | mkN "polidor" masculine ; --auto
lin polite_A = mkA "educat" ; --auto
lin political_A = mkA "polític" ;
lin politician_N = mkN "polític" feminine | mkN "polític" masculine ; --auto
lin politics_N = mkN "política" feminine ;
lin polka_N = mkN "polca" feminine ; --auto
lin poll_N = mkN "enquesta" feminine ; --auto
lin poll_V = mkV "enquestar" ; --auto
lin poll_V2 = mkV2 "enquestar" ; --auto
lin pollen_N = mkN "pol·len" masculine ; --auto
lin pollination_N = mkN "pol·linització" feminine ; --auto
lin pollinator_N = mkN "pol·linitzador" masculine ; --auto
lin pollster_N = mkN "enquestador" | mkN "enquestador" ; --auto
lin pollucite_N = mkN "pol·lucita" feminine ; --auto
lin pollutant_N = mkN "contaminant" masculine ; --auto
lin pollute_V2 = mkV2 "contaminar" ; --auto
lin pollution_N = mkN "contaminació" feminine ; --auto
lin polonium_N = mkN "poloni" masculine ; --auto
lin polyamide_N = mkN "poliamida" feminine ; --auto
lin polyandry_N = mkN "poliàndria" feminine ; --auto
lin polyatomic_A = mkA "poliatòmic" ; --auto
lin polycrystalline_A = mkA "policristal·lí" ; --auto
lin polycythemia_N = mkN "policitèmia" feminine ; --auto
lin polyester_N = mkN "poliester" masculine ; --auto
lin polygamist_N = mkN "polígam" masculine ; --auto
lin polygamous_A = mkA "polígam" ; --auto
lin polygamy_N = mkN "poligàmia" feminine ; --auto
lin polygenic_A = mkA "poligènic" ; --auto
lin polyglotFem_N = variants {} ; ---- sense to be split
lin polyglotMasc_N = variants {} ; ---- sense to be split
lin polygon_N = mkN "polígon" masculine ; --auto
lin polygyny_N = mkN "poligínia" feminine ; --auto
lin polyhedral_A = mkA "polièdric" ; --auto
lin polyhedron_N = mkN "poliedre" masculine | mkN "políedre" masculine ; --auto
lin polymer_N = mkN "polímer" masculine ; --auto
lin polymerase_N = mkN "polimerasa" feminine ; --auto
lin polymeric_A = mkA "polimèric" ; --auto
lin polymorphic_A = mkA "polimòrfic" ; --auto
lin polymorphism_N = mkN "polimorfisme" masculine ; --auto
lin polynomial_A = mkA "polinòmic" ; --auto
lin polynomial_N = mkN "polinomi" masculine ; --auto
lin polyp_N = mkN "pòlip" masculine ; --auto
lin polypeptide_N = mkN "polipèptid" masculine ; --auto
lin polyphonic_A = mkA "polifònic" ; --auto
lin polyphony_N = mkN "polifonia" feminine ; --auto
lin polyploid_A = mkA "poliploide" ; --auto
lin polysaccharide_N = mkN "polisacàrid" masculine ; --auto
lin polysemy_N = mkN "polisèmia" feminine ; --auto
lin polysyllabic_A = mkA "polisíl·lab" ; --auto
lin polysyllable_N = mkN "polisíl·lab" masculine ; --auto
lin polysyndeton_N = mkN "polisíndeton" masculine ; --auto
lin polytheism_N = mkN "politeisme" masculine ; --auto
lin polytheist_N = mkN "politeista" ; --auto
lin polytheistic_A = mkA "politeista" ; --auto
lin polyunsaturated_A = mkA "poliinsaturat" ; --auto
lin polyvalent_A = mkA "polivalent" ; --auto
lin pomegranate_N = mkN "magrana" feminine ; --auto
lin pomologist_N = mkN "pomòleg" feminine | mkN "pomòleg" masculine ; --auto
lin pomology_N = mkN "pomologia" feminine ; --auto
lin pomp_N = mkN "pompa" feminine ; --auto
lin poncho_N = mkN "ponxo" masculine ; --auto
lin pond_N = mkN "bassa" feminine ; --auto
lin pontifex_N = mkN "pontífex" masculine ; --auto
lin pontificate_N = mkN "pontificat" masculine ; --auto
lin pony_N = mkN "poni" masculine ; --auto
lin poodle_N = mkN "caniche" masculine ; --auto
lin pool_N = mkN "grup" masculine | mkN "piscina" feminine ; --auto
lin poor_1_A = mkA "pobre" ;
lin poor_2_A = mkA "pobre" ;
lin poor_3_A = mkA "pobre" ;
lin pop_N = mkN "pop" masculine ; --auto
lin pop_V2 = mkV2 "rebentar" ; --auto
lin pope_N = mkN "papa" masculine ; --auto
lin poplar_N = mkN "pollancre" masculine ; --auto
lin poppy_N = mkN "rosella" feminine ; --auto
lin popular_A = mkA "popular" ;
lin popularity_N = mkN "popularitat" feminine ; --auto
lin populate_V2 = mkV2 "poblar" ; --auto
lin population_N = mkN "població" feminine ;
lin populism_N = mkN "populisme" masculine ; --auto
lin porch_N = mkN "porxo" masculine ; --auto
lin pore_N = mkN "porus" masculine | mkN "porus" masculine ; --auto
lin pork_N = mkN "porc" masculine ; --auto
lin pornography_N = mkN "pornografia" feminine ; --auto
lin porosity_N = mkN "porositat" feminine ; --auto
lin porous_A = mkA "porós" ; --auto
lin porphyria_N = mkN "porfíria" feminine ; --auto
lin porridge_N = mkN "farinetes" feminine | mkN "farinetes" feminine ; --auto
lin port_A = mkA "portuari" ; --auto
lin port_N = mkN "port" masculine ; --auto
lin portable_A = mkA "portàtil" ; --auto
lin portal_N = mkN "portal" masculine ; --auto
lin portfolio_N = mkN "carpeta" feminine ; --auto
lin porthole_N = mkN "portell" masculine ; --auto
lin portico_N = mkN "pòrtic" masculine ; --auto
lin portion_N = mkN "porció" feminine ; --auto
lin portrait_N = mkN "retrat" masculine ; --auto
lin portray_V2 = mkV2 "retratar" ; --auto
lin portuguese_A = mkA "portuguès" ; --auto
lin pose_N = mkN "posa" feminine ; --auto
lin pose_V = mkV "plantejar" ; --auto
lin pose_V2 = mkV2 "plantejar" ; --auto
lin posit_V2 = mkV2 "postular" ; --auto
lin position_N = mkN "posició" masculine ; --split mkN "lloc de treball" masculine
lin position_V2 = mkV2 "col·locar" ; --auto
lin positional_A = mkA "posicional" ; --auto
lin positive_A = mkA "positiu" ;
lin positive_N = mkN "positiu" masculine ; --auto
lin positivism_N = mkN "positivisme" masculine ; --auto
lin positivist_A = mkA "positivista" ; --auto
lin positron_N = mkN "positró" masculine ; --auto
lin possess_V2 = mkV2 "posseir" ; --auto
lin possession_N = mkN "possessió" feminine | mkN "tinença" feminine ; --auto
lin possessive_A = mkA "possessiu" ; --auto
lin possessor_N = mkN "posseïdor" | mkN "posseïdor" ; --auto
lin possibility_N = mkN "possibilitat" feminine ;
lin possible_A = mkA "possible" ;
lin post_N = mkN "correu" masculine ;
lin postage_N = mkN "franqueig" masculine ; --auto
lin postage_stamp_N = mkN "segell de correus" masculine ; --auto
lin postal_A = mkA "postal" ; --auto
lin postcard_N = mkN "postal" feminine ; --auto
lin poster_N = mkN "cartell" masculine | mkN "pòster" masculine ; --auto
lin posterior_A = mkA "posterior" ; --auto
lin posterity_N = mkN "posteritat" feminine ; --auto
lin postgraduate_N = mkN "postgrau" masculine ; --auto
lin posthumous_A = mkA "pòstum" ; --auto
lin postman_N = mkN "carter" ; --auto
lin postpone_V2 = mkV2 "ajornar" ; --auto
lin postponement_N = mkN "postergació" feminine ; --auto
lin postscript_N = mkN "postdata" feminine ; --auto
lin postulant_N = mkN "postulant" ; --auto
lin postulate_N = mkN "postulat" masculine ; --auto
lin posture_N = mkN "postura" feminine ; --auto
lin pot_N = mkN "olla" feminine | mkN "pot" masculine | mkN "test" masculine ; --auto
lin potassium_N = mkN "potassi" masculine ; --auto
lin potato_N = mkN "patata" feminine ; --auto
lin potential_A = mkA "potencial" ;
lin potential_N = mkN "potencial" masculine ; --auto
lin potentiality_N = mkN "potencialitat" feminine ; --auto
lin potentiometer_N = mkN "potenciòmetre" masculine ; --auto
lin pothole_N = mkN "sot" masculine ; --auto
lin potion_N = mkN "poció" feminine ; --auto
lin potter_N = mkN "terrisser" feminine | mkN "terrisser" masculine ; --auto
lin pouch_N = mkN "cartutxera" feminine ; --auto
lin pouffe_N = mkN "puf" masculine ; --auto
lin pounce_V = mkV "estergir" ; --auto
lin pound_1_N = mkN "lliura" feminine ;
lin pound_2_N = mkN "lliura" feminine ;
lin pour_V = mkV "abocar" ; --auto
lin pour_V2 = mkV2 "abocar" ; --auto
lin pour_down_V = advV OP_pour_V OP_down_Adv ; -- guess-p-verb
lin pour_forth_V = advV OP_pour_V OP_forth_Adv ; -- guess-p-verb
lin pour_in_V2 = prepV2 OP_pour_V OP_in_Prep ; -- guess-p-verb
lin pour_out_V = advV OP_pour_V OP_out_Adv ; -- guess-p-verb
lin poverty_N = mkN "misèria" feminine | mkN "pobresa" feminine ; --auto
lin powder_N = mkN "pólvora" feminine | mkN "pólvora" feminine | mkN "pólvora" feminine ; --auto
lin powder_V = mkV "polvoritzar" ; --auto
lin powder_V2 = mkV2 "polvoritzar" ; --auto
lin power_N = mkN "poder" masculine ;
lin powerful_A = mkA "poderós" ;
lin powerless_A = mkA "impotent" ; --auto
lin practicable_A = mkA "practicable" ; --auto
lin practical_A = mkA "pràctic" ;
lin practice_N = mkN "pràctica" feminine ;
lin practice_V = mkV "practicar" ; --auto
lin practice_V2 = mkV2 "practicar" ; --auto
lin practise_V = mkV "practicar" ; --auto
lin practise_V2 = mkV2 "practicar" ; --auto
lin practitionerFem_N = mkN "practicant" ; --auto
lin practitionerMasc_N = mkN "practicant" ; --auto
lin praetorium_N = mkN "pretori" masculine ; --auto
lin pragmatic_A = mkA "pragmàtic" ; --auto
lin pragmatism_N = mkN "pragmatisme" masculine ; --auto
lin pragmatist_N = mkN "pragmatista" ; --auto
lin praise_N = mkN "elogi" masculine ; --auto
lin praise_V2 = mkV2 "elogiar" | mkV2 "lloar" ; --auto
lin pram_N = mkN "cotxet" masculine ; --auto
lin prank_N = mkN "broma" feminine ; --auto
lin praseodymium_N = mkN "praseodimi" masculine ; --auto
lin prawn_N = mkN "llagostí" masculine ; --auto
lin pray_V = mkV "pregar" ; --auto
lin pray_V2 = mkV2 "pregar" ; --auto
lin prayer_N = mkN "oració" feminine ; --auto
lin preach_V = mkV "predicar" ; --auto
lin preach_V2 = mkV2 "predicar" ; --auto
lin preacher_N = mkN "predicador" | mkN "predicador" ; --auto
lin preamble_N = mkN "preàmbul" masculine ; --auto
lin precarious_A = mkA "precari" ; --auto
lin precede_V2 = mkV2 "precedir" ; --auto
lin precedence_N = mkN "precedència" feminine ; --auto
lin precedent_N = mkN "precedent" masculine ; --auto
lin precentor_N = mkN "xantre" masculine ; --auto
lin precept_N = mkN "precepte" masculine ; --auto
lin precession_N = mkN "precessió" feminine ; --auto
lin precious_A = mkA "preciós" ; --auto
lin precipitant_N = mkN "precipitant" masculine ; --auto
lin precipitate_N = mkN "precipitat" feminine ; --auto
lin precipitate_V2 = mkV2 "precipitar" ; --auto
lin precipitation_N = mkN "precipitació" feminine ; --auto
lin precipitator_N = mkN "precipitador" masculine ; --auto
lin precise_A = mkA "precís" ; --auto
lin precision_N = mkN "precisió" feminine ; --auto
lin preclude_V2 = mkV2 "impedir" ; --auto
lin precocious_A = mkA "precoç" ; --auto
lin precocity_N = mkN "precocitat" feminine ; --auto
lin precursor_N = mkN "precursor" | mkN "precursor" ; --auto
lin predator_N = mkN "depredador" feminine | mkN "depredador" masculine ; --auto
lin predatory_A = mkA "depredador" ; --auto
lin predecessor_N = mkN "predecessor" | mkN "predecessor" ; --auto
lin predestination_N = mkN "predestinació" feminine ; --auto
lin predetermine_V2 = mkV2 "predeterminar" ; --auto
lin predicate_N = mkN "predicat" masculine ; --auto
lin predict_V2 = mkV2 "pronosticar" ; --auto
lin predictable_A = mkA "predicible" | mkA "predictible" | mkA "previsible" ; --auto
lin prediction_N = mkN "predicció" feminine ; --auto
lin predictive_A = mkA "predictiu" ; --auto
lin predilection_N = mkN "predilecció" feminine ; --auto
lin predisposition_N = mkN "predisposició" feminine ; --auto
lin prednisone_N = mkN "prednisona" feminine ; --auto
lin predominance_N = mkN "predomini" masculine ; --auto
lin predominant_A = mkA "predominant" ; --auto
lin predominate_V = mkV "predominar" ; --auto
lin preemption_N = mkN "preempció" feminine ; --auto
lin prefabricate_V2 = mkV2 "prefabricar" ; --auto
lin prefer_V2 = mkV2 (mkV (servir_101 "preferir")) ;
lin prefer_VV = mkVV (mkV (servir_101 "preferir")) ;
lin preferable_A = mkA "preferible" ; --auto
lin preference_N = mkN "preferència" feminine ; --auto
lin preferential_A = mkA "preferent" ; --auto
lin prefix_N = mkN "prefix" masculine ; --auto
lin prefix_V2 = mkV2 "prefixar" ; --auto
lin prefixation_N = mkN "prefixació" feminine ; --auto
lin pregnancy_N = mkN "embaràs" masculine ; --auto
lin pregnant_A = mkA "embarassat" ; --auto
lin prehensile_A = mkA "prènsil" ; --auto
lin prehistoric_A = mkA "prehistòric" ; --auto
lin prehistory_N = mkN "prehistòria" feminine ; --auto
lin prejudge_V2 = mkV2 "prejutjar" ; --auto
lin prejudice_N = mkN "prejudici" masculine ; --auto
lin prejudice_V2 = mkV2 "perjudicar" ; --auto
lin prelate_N = mkN "prelat" masculine ; --auto
lin preliminary_A = mkA "preliminar" ; --auto
lin prelude_N = mkN "preludi" masculine ; --auto
lin premarital_A = mkA "prematrimonial" ; --auto
lin premature_A = mkA "prematur" ; --auto
lin premeditation_N = mkN "premeditació" feminine ; --auto
lin premise_N = mkN "premissa" feminine ; --auto
lin premium_N = mkN "prima" feminine ; --auto
lin premolar_N = mkN "premolar" masculine ; --auto
lin premonition_N = mkN "premonició" feminine ; --auto
lin preparation_N = mkN "confecció" feminine | mkN "elaboració" feminine | mkN "preparació" feminine ; --auto
lin preparatory_A = mkA "preparatori" ; --auto
lin prepare_V = mkV "preparar" ;
lin prepare_V2 = mkV2 (mkV "preparar") ;
lin prepare_V2V = mkV2V (mkV "preparar") ParadigmsCat.accusative (mkPrep "per") ;
lin preposition_N = mkN "preposició" feminine ; --auto
lin prepositional_A = mkA "preposicional" ; --auto
lin prerogative_N = mkN "prerrogativa" feminine ; --auto
lin presbyter_N = mkN "presbiterià" feminine | mkN "presbiterià" masculine ; --auto
lin presbytery_N = mkN "presbiteri" masculine ; --auto
lin prescribe_V = mkV "prescriure" ; --auto
lin prescribe_V2 = mkV2 "prescriure" ; --auto
lin prescription_N = mkN "recepta" feminine ; --auto
lin presence_N = mkN "presència" feminine ;
lin present_A = mkA "present" ;
lin present_N = mkN "regal" masculine ;
lin present_V2 = mkV2 (mkV "presentar") ;
lin presentable_A = mkA "presentable" ; --auto
lin presentation_N = mkN "presentació" feminine ; --auto
lin presenter_N = mkN "presentador" | mkN "presentador" ; --auto
lin presentiment_N = mkN "pressentiment" masculine ; --auto
lin preservation_N = mkN "preservació" feminine ; --auto
lin preservative_N = mkN "conservant" masculine ; --auto
lin preserve_N = mkN "conserva" feminine ; --auto
lin preserve_V2 = mkV2 "conservar" | mkV2 "preservar" ; --auto
lin presidency_N = mkN "presidència" feminine ; --auto
lin presidentFem_N = variants {} ; ---- sense to be split
lin presidentMasc_N = variants {} ; ---- sense to be split
lin presidential_A = mkA "presidencial" ; --auto
lin press_N = mkN "premsa" feminine ;
lin press_V = mkV "apretar" ;
lin press_V2 = mkV2 (mkV "apretar") ;
lin press_ahead_V = advV OP_press_V OP_ahead_Adv ; -- guess-p-verb
lin press_for_V2 = prepV2 OP_press_V OP_for_Prep ; -- guess-p-verb
lin press_forward_with_V2 = prepV2 (advV OP_press_V OP_forward_Adv ) OP_with_Prep ; -- guess-p-verb
lin press_into_V2 = prepV2 OP_press_V OP_into_Prep ; -- guess-p-verb
lin press_on_V = advV OP_press_V OP_on_Adv ; -- guess-p-verb
lin press_upon_V2 = prepV2 OP_press_V OP_upon_Prep ; -- guess-p-verb
lin pressing_N = mkN "premsatge" masculine ; --auto
lin pressure_N = mkN "pressió" feminine ;
lin prestige_N = mkN "prestigi" masculine ; --auto
lin prestigious_A = mkA "prestigiós" ; --auto
lin prestissimo_Adv = mkAdv "prestissimo" ; --auto
lin presto_Adv = mkAdv "presto" ; --auto
lin presumable_A = mkA "presumible" ; --auto
lin presumably_Adv = mkAdv "presumiblement" ; --auto
lin presumption_N = mkN "presumpció" feminine ; --auto
lin presumptive_A = mkA "presumpte" ; --auto
lin presumptuous_A = mkA "presumptuós" ; --auto
lin presuppose_V2 = mkV2 "pressuposar" ; --auto
lin presupposition_N = mkN "pressupòsit" masculine ; --auto
lin pretence_N = mkN "pretensió" feminine ; --auto
lin pretend_V = mkV "pretendre" ; --auto
lin pretend_V2 = mkV2 "pretendre" ; --auto
lin pretentious_A = mkA "pretensiós" ; --auto
lin pretext_N = mkN "pretext" masculine ; --auto
lin pretty_A = mkA "bonic" ; --auto
lin prevail_V = mkV "prevaler" ; --auto
lin prevaricate_V = mkV "prevaricar" ; --auto
lin prevarication_N = mkN "prevaricació" feminine ; --auto
lin prevent_V2 = mkV2 (mkV (prevenir_88 "prevenir")) ;
lin preventable_A = mkA "evitable" ; --auto
lin prevention_N = mkN "prevenció" feminine ; --auto
lin preventive_A = mkA "precautori" | mkA "preventiu" ; --auto
lin preview_N = mkN "preestrena" feminine ; --auto
lin previous_A = mkA "anterior" ;
lin prey_N = mkN "presa" feminine ; --auto
lin price_N = mkN "preu" masculine ;
lin price_V = mkV "taxar" ; --auto
lin price_V2 = mkV2 "taxar" ; --auto
lin priceless_A = mkA "inapreciable" ; --auto
lin pricing_N = mkN "preuació" feminine ; --auto
lin prickly_A = mkA "espinós" ; --auto
lin pride_N = mkN "orgull" masculine ; --auto
lin priest_N = L.priest_N ;
lin priesthood_N = mkN "sacerdoci" masculine ; --auto
lin priestly_A = mkA "sacerdotal" ; --auto
lin primacy_N = mkN "primacia" feminine ; --auto
lin primary_A = mkA "primari" ;
lin primate_N = mkN "primat" masculine ; --auto
lin prime_A = mkA "principal" ;
lin prime_N = mkN "albor" feminine ; --auto
lin prime_V2 = mkV2 "preparar" ; --auto
lin primer_N = mkN "beceroles" feminine ; --auto
lin priming_N = mkN "encebament" masculine ; --auto
lin primitive_A = mkA "primitiu" ; --auto
lin primogeniture_N = mkN "primogenitura" feminine ; --auto
lin primrose_N = mkN "prímula" feminine ; --auto
lin prince_N = mkN "príncep" masculine ; --auto
lin princess_N = mkN "príncep" feminine ; --auto
lin principal_A = mkA "cabdal" | mkA "principal" ; --auto
lin principle_N = mkN "principi" masculine ;
lin print_N = mkN "empremta" feminine | mkN "estampat" masculine | mkN "impremta" feminine ; --auto
lin print_V = mkV "imprimir" ; --auto
lin print_V2 = mkV2 "imprimir" ; --auto
lin print_out_V2 = prepV2 OP_print_V OP_out_Prep ; -- guess-p-verb
lin printable_A = mkA "imprimible" ; --auto
lin printer_N = mkN "impressora" feminine ; --auto
lin printing_N = mkN "estampat" masculine | mkN "impremta" feminine | mkN "impressió" feminine ; --auto
lin prion_N = mkN "prió" masculine ; --auto
lin prior_A = mkA "previ" ; --auto
lin priority_N = mkN "prioritat" feminine ; --auto
lin prism_N = mkN "prisma" masculine ; --auto
lin prismatic_A = mkA "prismàtic" ; --auto
lin prismatoid_N = mkN "prismatoide" masculine ; --auto
lin prison_N = mkN "presó" feminine ;
lin prisoner_N = mkN "pres" feminine | mkN "pres" masculine | mkN "presoner" | mkN "presoner" | mkN "reclús" feminine | mkN "reclús" masculine ; --auto
lin privacy_N = mkN "intimitat" feminine | mkN "privacitat" feminine ; --auto
lin private_A = mkA "privat" ;
lin privatisation_N = mkN "privatització" feminine ; --auto
lin privilege_N = mkN "privilegi" masculine ; --auto
lin privileged_A = mkA "privilegiat" ; --auto
lin prize_N = mkN "premi" masculine ; --auto
lin pro_tempore_Adv = mkAdv "pro tempore" ; --auto
lin probabilism_N = mkN "probabilisme" masculine ; --auto
lin probabilistic_A = mkA "probabilista" | mkA "probabilístic" ; --auto
lin probability_N = mkN "probabilitat" feminine ; --auto
lin probable_A = mkA "probable" ; --auto
lin probe_N = mkN "sonda" feminine ; --auto
lin problem_N = mkN "problema" masculine ;
lin problematic_A = mkA "problemàtic" ; --auto
lin proboscis_N = mkN "probòscide" masculine ; --auto
lin procedural_A = mkA "processal" ; --auto
lin procedure_N = mkN "procediment" masculine ;
lin proceed_V = mkV "anar" | mkV "procedir" ; --auto
lin process_N = mkN "procés" masculine ;
lin process_V = mkV "processar" ; --auto
lin process_V2 = mkV2 "processar" ; --auto
lin processing_N = mkN "processament" masculine ; --auto
lin procession_N = mkN "processó" feminine ; --auto
lin processor_N = mkN "processador" masculine ; --auto
lin proclaim_V2 = mkV2 "proclamar" ; --auto
lin proconsul_N = mkN "procònsol" masculine ; --auto
lin proconsulate_N = mkN "proconsolat" masculine ; --auto
lin procreation_N = mkN "procreació" feminine ; --auto
lin procurement_N = mkN "aprovisionament" masculine ; --auto
lin prodrome_N = mkN "pròdrom" masculine ; --auto
lin produce_N = mkN "producte" masculine ; --auto
lin produce_V = verbV (reduir_94 "produir") ;
lin produce_V2 = mkV2 (verbV (reduir_94 "produir")) ;
lin producer_N = mkN "productor" | mkN "productor" ; --auto
lin product_N = mkN "producte" masculine ;
lin production_N = mkN "producció" feminine ;
lin productive_A = mkA "productiu" ; --auto
lin productivity_N = mkN "productivitat" feminine ; --auto
lin profane_A = mkA "profà" ; --auto
lin profession_N = mkN "professió" feminine ; --auto
lin professional_A = mkA "professional" ;
lin professional_N = mkN "professional" ; --auto
lin professionalism_N = mkN "professionalitat" feminine ; --auto
lin professor_N = mkN "professor" ; --auto
lin profile_N = mkN "perfil" masculine ; --auto
lin profit_N = mkN "benefici" masculine ;
lin profitable_A = mkA "profitós" ; --auto
lin profound_A = mkA "profund" ; --auto
lin progenitor_N = mkN "progenitor" | mkN "progenitor" ; --auto
lin prognathism_N = mkN "prognatisme" masculine ; --auto
lin prognosis_N = mkN "pronòstic" masculine ; --auto
lin program_N = mkN "programa" masculine ; --auto
lin program_V2 = mkV2 "programar" ; --auto
lin programmable_A = mkA "programable" ; --auto
lin programme_N = mkN "programa" feminine ;
lin programmerFem_N = variants {} ; ---- sense to be split
lin programmerMasc_N = variants {} ; ---- sense to be split
lin programming_N = mkN "programació" feminine ; --auto
lin progress_N = mkN "progrés" masculine ;
lin progress_V = mkV "progressar" ; --auto
lin progress_V2 = mkV2 "progressar" ; --auto
lin progression_N = mkN "progressió" feminine ; --auto
lin progressive_A = mkA "progressista" | mkA "progressiu" ; --auto
lin prohibit_V = mkV "prohibir" ; --auto
lin prohibit_V2 = mkV2 "prohibir" ; --auto
lin prohibition_N = mkN "prohibició" feminine ; --auto
lin prohibitory_A = mkA "prohibitori" ; --auto
lin project_N = mkN "projecte" masculine ;
lin project_V = mkV "projectar" | mkV "sobresortir" ; --auto
lin project_V2 = mkV2 "projectar" | mkV2 "sobresortir" ; --auto
lin projectile_N = mkN "projectil" masculine ; --auto
lin projection_N = mkN "projecció" feminine ; --auto
lin projector_N = mkN "projector" masculine ; --auto
lin prolapse_N = mkN "prolapse" masculine ; --auto
lin prolepsis_N = mkN "prolepsi" feminine ; --auto
lin proletarian_N = mkN "proletari" | mkN "proletari" ; --auto
lin proletariat_N = mkN "proletariat" masculine ; --auto
lin proliferate_V = mkV "proliferar" ; --auto
lin proliferate_V2 = mkV2 "proliferar" ; --auto
lin proliferation_N = mkN "proliferació" feminine ; --auto
lin prolongation_N = mkN "prolongació" feminine ; --auto
lin promenade_N = mkN "passeig" masculine ; --auto
lin promethium_N = mkN "prometi" masculine ; --auto
lin prominence_N = mkN "prominència" feminine ; --auto
lin prominent_A = mkA "prominent" ; --auto
lin promise_N = mkN "promesa" feminine ; --auto
lin promise_V = mkV (admetre_2 "prometre") ;
lin promise_V2 = mkV2 (mkV (admetre_2 "prometre")) ;
lin promise_VS = mkVS (mkV (admetre_2 "prometre")) ;
lin promise_VV = mkVV (mkV (admetre_2 "prometre")) ;
lin promissory_A = mkA "promissori" ; --auto
lin promontory_N = mkN "promontori" masculine ; --auto
lin promote_V = mkV "impulsar" | mkV "promoure" ; --auto
lin promote_V2 = mkV2 "impulsar" | mkV2 "promoure" ; --auto
lin promoter_N = mkN "promotor" | mkN "promotor" ; --auto
lin promotion_N = mkN "ascens" masculine | mkN "promoció" feminine ; --auto
lin prompt_A = mkA "puntual" ; --auto
lin prompt_V2 = mkV2 "apuntar" | mkV2 "incitar" ; --auto
lin prompter_N = mkN "apuntador" masculine ; --auto
lin promulgation_N = mkN "promulgació" feminine ; --auto
lin pronominal_A = mkA "pronominal" ; --auto
lin pronoun_N = mkN "pronom" masculine ; --auto
lin pronounce_V = mkV "pronunciar" ; --auto
lin pronounce_V2 = mkV2 "pronunciar" ; --auto
lin pronunciation_N = mkN "pronunciació" feminine ; --auto
lin proof_N = mkN "prova" feminine ; --auto
lin prop_V2 = mkV2 "apuntalar" ; --auto
lin propaedeutic_N = mkN "propedèutica" feminine ; --auto
lin propaganda_N = mkN "propaganda" feminine ; --auto
lin propagandist_N = mkN "propagandista" ; --auto
lin propagate_V = mkV "propagar" ; --auto
lin propagate_V2 = mkV2 "propagar" ; --auto
lin propagation_N = mkN "propagació" feminine ; --auto
lin propel_V2 = mkV2 "propulsar" ; --auto
lin propellant_N = mkN "propulsor" masculine ; --auto
lin propeller_N = mkN "hèlice" masculine ; --auto
lin propensity_N = mkN "propensió" feminine ; --auto
lin proper_A = mkA "adequat" ;
lin property_1_N = mkN "propietat" masculine ; --split "casa"
lin property_2_N = mkN "propietat" masculine ; --split "casa"
lin prophase_N = mkN "profase" feminine ; --auto
lin prophet_N = mkN "profeta" ; --auto
lin prophylaxis_N = mkN "profilaxi" feminine ; --auto
lin propjet_N = mkN "turbopropulsor" masculine ; --auto
lin proportion_N = mkN "proporció" feminine ;
lin proportional_A = mkA "proporcional" ; --auto
lin proportionate_A = mkA "proporcionat" ; --auto
lin proposal_N = mkN "proposta" feminine ;
lin propose_V = mkV "declarar-se" | mkV "proposar" ; --auto
lin proposition_N = mkN "proposició" feminine ; --auto
lin proprietary_A = mkA "propietari" ; --auto
lin propulsion_N = mkN "propulsió" feminine ; --auto
lin proscenium_N = mkN "prosceni" masculine ; --auto
lin proscription_N = mkN "proscripció" feminine ; --auto
lin prose_N = mkN "prosa" feminine ; --auto
lin prosecutorFem_N = variants {} ; ---- sense to be split
lin prosecutorMasc_N = variants {} ; ---- sense to be split
lin proselytism_N = mkN "proselitisme" masculine ; --auto
lin prosodic_A = mkA "prosòdic" ; --auto
lin prosody_N = mkN "prosòdia" feminine ; --auto
lin prospect_N = mkN "perspectiva" feminine ; --auto
lin prospective_A = mkA "probable" ; --auto
lin prosperity_N = mkN "prosperitat" feminine ; --auto
lin prostaglandin_N = mkN "prostaglandina" feminine ; --auto
lin prostate_N = mkN "pròstata" feminine ; --auto
lin prosthesis_N = mkN "pròtesi" feminine ; --auto
lin prostitute_N = mkN "prostituta" feminine ; --auto
lin prostitute_V2 = mkV2 "prostituir" ; --auto
lin prostitution_N = mkN "prostitució" feminine ; --auto
lin prostration_N = mkN "prostració" feminine ; --auto
lin prostyle_A = mkA "pròstil" ; --auto
lin protagonist_N = mkN "protagonista" ; --auto
lin protect_V = mkV (servir_101 "protegir") ;
lin protect_V2 = mkV2 (mkV (servir_101 "protegir")) ;
lin protection_N = mkN "protecció" masculine ;
lin protectionism_N = mkN "proteccionisme" masculine ; --auto
lin protectionistFem_N = variants {} ; ---- sense to be split
lin protectionistMasc_N = variants {} ; ---- sense to be split
lin protective_A = mkA "protector" ; --auto
lin protector_N = mkN "protector" masculine ; --auto
lin protectorate_N = mkN "protectorat" masculine ; --auto
lin protege_N = mkN "protegit" feminine | mkN "protegit" masculine ; --auto
lin protein_N = mkN "proteïna" feminine ; --auto
lin proteinaceous_A = mkA "proteic" ; --auto
lin proteolysis_N = mkN "proteòlisi" feminine ; --auto
lin protest_N = mkN "protesta" feminine ; --auto
lin protest_V = mkV "protestar" ; --auto
lin protest_V2 = mkV2 "protestar" ; --auto
lin protestant_A = mkA "protestant" ; --auto
lin protestantism_N = mkN "protestantisme" masculine ; --auto
lin prothrombin_N = mkN "protrombina" feminine ; --auto
lin protocol_N = mkN "protocol" masculine ; --auto
lin protohistory_N = mkN "protohistòria" feminine ; --auto
lin proton_N = mkN "protó" masculine ; --auto
lin protoplasm_N = mkN "protoplasma" masculine ; --auto
lin prototype_N = mkN "prototipus" masculine | mkN "prototip" masculine | mkN "prototipus" masculine ; --auto
lin protrusion_N = mkN "protrusió" feminine ; --auto
lin protuberance_N = mkN "protuberància" feminine ; --auto
lin proud_A = mkA "orgullós" ; --auto
lin provable_A = mkA "demostrable" ; --auto
lin prove_V = mkV "demostrar" ;
lin prove_V2 = mkV2 (mkV "demostrar") ;
lin prove_VA = mkVA (mkV "demostrar") ; --subcat "it proved hard" in English? "it proved to be"
lin prove_VS = mkVS (mkV "demostrar") ;
lin proverb_N = mkN "proverbi" masculine ; --auto
lin proverbial_A = mkA "proverbial" ; --auto
lin provide_V = verbV (lluir_64 "proveir") ;
lin provide_V2 = mkV2 (verbV (lluir_64 "proveir")) ;
lin providence_N = mkN "providència" feminine ; --auto
lin provider_N = mkN "proveïdor" masculine ; --auto
lin province_N = mkN "província" feminine ; --auto
lin provincial_A = mkA "provincial" ; --auto
lin provincialism_N = mkN "provincialisme" masculine ; --auto
lin provision_N = mkN "provisió" feminine ;
lin provisional_A = mkA "provisional" ; --auto
lin provocation_N = mkN "provocació" feminine ; --auto
lin provoke_V2 = mkV2 "provocar" ; --auto
lin prowess_N = mkN "coratge" masculine ; --auto
lin proxemics_N = mkN "proxèmica" feminine ; --auto
lin proximal_A = mkA "proximal" ; --auto
lin prudence_N = mkN "prudència" feminine ; --auto
lin prudential_A = mkA "prudencial" ; --auto
lin pruning_N = mkN "poda" feminine ; --auto
lin psalm_N = mkN "salm" masculine ; --auto
lin psalmody_N = mkN "salmòdia" feminine ; --auto
lin psaltery_N = mkN "saltiri" masculine ; --auto
lin pseudonym_N = mkN "pseudònim" masculine ; --auto
lin pseudoscience_N = mkN "pseudociència" feminine ; --auto
lin pseudoscientific_A = mkA "pseudocientífic" ; --auto
lin psilomelane_N = mkN "psilomelana" feminine ; --auto
lin psittacosis_N = mkN "psitacosi" feminine ; --auto
lin psoriasis_N = mkN "psoriasi" feminine ; --auto
lin psyche_N = mkN "psique" feminine ; --auto
lin psychiatric_A = mkA "psiquiàtric" ; --auto
lin psychiatrist_N = mkN "psiquiatre" | mkN "psiquiatre" | mkN "psiquiatre" ; --auto
lin psychic_A = mkA "psíquic" ; --auto
lin psychoactive_A = mkA "psicotròpic" ; --auto
lin psychological_A = mkA "psicològic" ; --auto
lin psychologist_N = mkN "psicòleg" | mkN "psicòleg" ; --auto
lin psychology_N = mkN "psicologia" feminine ; --auto
lin psychopath_N = mkN "psicòpata" ; --auto
lin psychosomatic_A = mkA "somatopsíquic" ; --auto
lin psychrometer_N = mkN "psicròmetre" masculine ; --auto
lin pteridophyte_N = mkN "pteridòfit" masculine ; --auto
lin pterion_N = mkN "pteri" masculine ; --auto
lin pterygium_N = mkN "pterigi" masculine ; --auto
lin ptosis_N = mkN "ptosi" feminine ; --auto
lin ptyalin_N = mkN "ptialina" feminine ; --auto
lin ptyalism_N = mkN "ptialisme" masculine ; --auto
lin pub_N = mkN "pub" masculine ;
lin puberty_N = mkN "pubertat" feminine ; --auto
lin pubic_A = mkA "púbic" ; --auto
lin pubis_N = mkN "pubis" masculine | mkN "pubis" masculine ; --auto
lin public_A = mkA "públic" ;
lin public_N = mkN "públic" masculine ;
lin publication_N = mkN "publicació" feminine ; --auto
lin publicity_N = mkN "publicitat" feminine ; --auto
lin publish_V = mkV "publicar" ;
lin publish_V2 = mkV2 (mkV "publicar") ;
lin publisher_N = mkN "editorial" feminine | mkN "editor" | mkN "editor" ; --auto
lin publishing_A = mkA "editorial" ; --auto
lin publishing_N = mkN "editorial" feminine ; --auto
lin pudding_N = mkN "púding" masculine ; --auto
lin puddle_N = mkN "bassal" masculine ; --auto
lin pugilism_N = mkN "pugilisme" masculine ; --auto
lin pull_N = mkN "atracció" feminine ; --auto
lin pull_V = mkV "estirar" ;
lin pull_V2 = L.pull_V2 ;
lin pull_ahead_V = advV OP_pull_V OP_ahead_Adv ; -- guess-p-verb
lin pull_apart_V2 = mkV2 (advV OP_pull_V OP_apart_Adv ) ; -- guess-p-verb
lin pull_away_V = advV OP_pull_V OP_away_Adv ; -- guess-p-verb
lin pull_back_V = advV OP_pull_V OP_back_Adv ; -- guess-p-verb
lin pull_back_V2 = mkV2 (advV OP_pull_V OP_back_Adv ) ; -- guess-p-verb
lin pull_down_V = advV OP_pull_V OP_down_Adv ; -- guess-p-verb
lin pull_down_V2 = prepV2 OP_pull_V OP_down_Prep ; -- guess-p-verb
lin pull_for_V2 = prepV2 OP_pull_V OP_for_Prep ; -- guess-p-verb
lin pull_in_V = advV OP_pull_V OP_in_Adv ; -- guess-p-verb
lin pull_in_V2 = prepV2 OP_pull_V OP_in_Prep ; -- guess-p-verb
lin pull_off_V = advV OP_pull_V OP_off_Adv ; -- guess-p-verb
lin pull_off_V2 = prepV2 OP_pull_V OP_off_Prep ; -- guess-p-verb
lin pull_on_V2 = prepV2 OP_pull_V OP_on_Prep ; -- guess-p-verb
lin pull_out_V = advV OP_pull_V OP_out_Adv ; -- guess-p-verb
lin pull_out_V2 = prepV2 OP_pull_V OP_out_Prep ; -- guess-p-verb
lin pull_over_V2 = prepV2 OP_pull_V OP_over_Prep ; -- guess-p-verb
lin pull_through_V = advV OP_pull_V OP_through_Adv ; -- guess-p-verb
lin pull_to_V2 = prepV2 OP_pull_V OP_to_Prep ; -- guess-p-verb
lin pull_together_V = advV OP_pull_V OP_together_Adv ; -- guess-p-verb
lin pull_up_V = advV OP_pull_V OP_up_Adv ; -- guess-p-verb
lin pull_up_V2 = prepV2 OP_pull_V OP_up_Prep ; -- guess-p-verb
lin pull_yourself_together_V = variants {} ; -- guess-p-verb
lin pullover_N = mkN "pul·lòver" masculine ; --auto
lin pulmonary_A = mkA "pulmonar" ; --auto
lin pulpit_N = mkN "púlpit" masculine ; --auto
lin pulsar_N = mkN "púlsar" masculine ; --auto
lin pulse_N = mkN "pols" masculine ; --auto
lin pump_N = mkN "bomba" feminine ; --auto
lin pump_V = mkV "bombar" ; --auto
lin pump_V2 = mkV2 "bombar" ; --auto
lin punch_N = mkN "cop de puny" masculine | mkN "perforadora" feminine | mkN "ponx" masculine | mkN "punxó" masculine | mkN "punyada" feminine ; --auto
lin punch_V2 = mkV2 "pegar" | mkV2 "punxonar" ; --auto
lin punctilious_A = mkA "meticulós" ; --auto
lin punctual_A = mkA "puntual" ; --auto
lin punctuation_N = mkN "puntuació" feminine ; --auto
lin puncture_N = mkN "punxada" feminine ; --auto
lin puncture_V = mkV "punxar" ; --auto
lin puncture_V2 = mkV2 "punxar" ; --auto
lin pungency_N = mkN "acritud" feminine ; --auto
lin pungent_A = mkA "punyent" ; --auto
lin punish_V2 = mkV2 "castigar" ; --auto
lin punishable_A = mkA "punible" ; --auto
lin punishment_N = mkN "càstig" masculine ; --auto
lin pupa_N = mkN "pupa" feminine ; --auto
lin pupil_N = mkN "alumne" ;
lin pupillary_A = mkA "pupil·lar" ; --auto
lin puppet_N = mkN "titella" feminine ; --auto
lin purchase_N = mkN "compra" feminine ; --auto
lin purchase_V2 = mkV2 "adquirir" ; --auto
lin purchaser_N = mkN "comprador" ; --auto
lin pure_A = mkA "pur" ; --auto
lin purgative_N = mkN "purgant" masculine ; --auto
lin purgatory_N = mkN "purgatori" masculine ; --auto
lin purge_N = mkN "purga" feminine ; --auto
lin purification_N = mkN "purificació" feminine ; --auto
lin purify_V2 = mkV2 "purificar" ; --auto
lin purism_N = mkN "purisme" masculine ; --auto
lin purist_N = mkN "purista" ; --auto
lin puritan_N = mkN "purità" | mkN "purità" ; --auto
lin puritanism_N = mkN "puritanisme" masculine ; --auto
lin purity_N = mkN "puresa" feminine ; --auto
lin purple_A = mkA "morat" | mkA "porprat" ; --auto
lin purple_N = mkN "porpra" feminine | mkN "púrpura" feminine ; --auto
lin purportedly_Adv = mkAdv "suposadament" ; --auto
lin purpose_N = mkN "finalitat" feminine ;
lin purposeful_A = mkA "resolut" ; --auto
lin purposeless_A = mkA "irresolut" ; --auto
lin purposely_Adv = mkAdv "expressament" ; --auto
lin purpura_N = mkN "púrpura" feminine ; --auto
lin purse_V2 = mkV2 "arrufar" ; --auto
lin purser_N = mkN "sobrecàrrec" masculine ; --auto
lin pursue_V = mkV "perseguir" | mkV "prosseguir" ; --auto
lin pursue_V2 = mkV2 "perseguir" | mkV2 "prosseguir" ; --auto
lin pursuit_N = mkN "persecució" feminine | mkN "recerca" feminine ; --auto
lin push_N = mkN "empenta" feminine | mkN "espenta" feminine ; --auto
lin push_V = mkV (atènyer_59 "empènyer") ;
lin push_V2 = L.push_V2 ;
lin push_V2V = mkV2V (mkV (atènyer_59 "empènyer")) ParadigmsCat.accusative ParadigmsCat.dative ;
lin push_VS = mkVS (mkV (atènyer_59 "empènyer")) ; --subcat
lin push_ahead_V = advV OP_push_V OP_ahead_Adv ; -- guess-p-verb
lin push_around_V = advV OP_push_V OP_around_Adv ; -- guess-p-verb
lin push_back_V = advV OP_push_V OP_back_Adv ; -- guess-p-verb
lin push_in_V2 = prepV2 OP_push_V OP_in_Prep ; -- guess-p-verb
lin push_through_V = advV OP_push_V OP_through_Adv ; -- guess-p-verb
lin push_up_V2 = prepV2 OP_push_V OP_up_Prep ; -- guess-p-verb
lin pusillanimous_A = mkA "pusil·lànime" ; --auto
lin pustule_N = mkN "pústula" feminine ; --auto
lin put_V2 = L.put_V2 ;
lin put_across_V = advV (lin V OP_put_V2) OP_across_Adv ; -- guess-p-verb
lin put_across_V2 = prepV2 (lin V OP_put_V2) OP_across_Prep ; -- guess-p-verb
lin put_aside_V = advV (lin V OP_put_V2) OP_aside_Adv ; -- guess-p-verb
lin put_away_V = advV (lin V OP_put_V2) OP_away_Adv ; -- guess-p-verb
lin put_away_V2 = mkV2 (advV (lin V OP_put_V2) OP_away_Adv ) ; -- guess-p-verb
lin put_back_V2 = mkV2 (advV (lin V OP_put_V2) OP_back_Adv ) ; -- guess-p-verb
lin put_by_V2 = prepV2 (lin V OP_put_V2) OP_by_Prep ; -- guess-p-verb
lin put_down_V = advV (lin V OP_put_V2) OP_down_Adv ; -- guess-p-verb
lin put_down_V2 = prepV2 (lin V OP_put_V2) OP_down_Prep ; -- guess-p-verb
lin put_down_for_V3 = variants {} ; -- guess-p-verb
lin put_down_to_V3 = variants {} ; -- guess-p-verb
lin put_forth_V = advV (lin V OP_put_V2) OP_forth_Adv ; -- guess-p-verb
lin put_in_V = advV (lin V OP_put_V2) OP_in_Adv ; -- guess-p-verb
lin put_in_V2 = prepV2 (lin V OP_put_V2) OP_in_Prep ; -- guess-p-verb
lin put_in_for_V2 = prepV2 (advV (lin V OP_put_V2) OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin put_off_V = advV (lin V OP_put_V2) OP_off_Adv ; -- guess-p-verb
lin put_off_V2 = prepV2 (lin V OP_put_V2) OP_off_Prep ; -- guess-p-verb
lin put_on_V = advV (lin V OP_put_V2) OP_on_Adv ; -- guess-p-verb
lin put_on_V2 = prepV2 (lin V OP_put_V2) OP_on_Prep ; -- guess-p-verb
lin put_out_V = advV (lin V OP_put_V2) OP_out_Adv ; -- guess-p-verb
lin put_out_V2 = prepV2 (lin V OP_put_V2) OP_out_Prep ; -- guess-p-verb
lin put_over_V2 = prepV2 (lin V OP_put_V2) OP_over_Prep ; -- guess-p-verb
lin put_through_V2 = prepV2 (lin V OP_put_V2) OP_through_Prep ; -- guess-p-verb
lin put_together_V2 = mkV2 (advV (lin V OP_put_V2) OP_together_Adv ) ; -- guess-p-verb
lin put_towards_V2 = prepV2 (lin V OP_put_V2) OP_towards_Prep ; -- guess-p-verb
lin put_up_V = advV (lin V OP_put_V2) OP_up_Adv ; -- guess-p-verb
lin put_up_V2 = prepV2 (lin V OP_put_V2) OP_up_Prep ; -- guess-p-verb
lin put_up_V2V = variants {} ; -- guess-p-verb
lin put_up_with_V2 = prepV2 (advV (lin V OP_put_V2) OP_up_Adv ) OP_with_Prep ; -- guess-p-verb
lin put_upon_V = variants {} ; -- guess-p-verb
lin puzzle_N = mkN "trencaclosques" masculine | mkN "trencaclosques" masculine ; --auto
lin pylorus_N = mkN "pílor" masculine ; --auto
lin pyramid_N = mkN "piràmide" feminine ; --auto
lin pyramidal_A = mkA "piramidal" ; --auto
lin pyrite_N = mkN "pirita" feminine ; --auto
lin pyroelectricity_N = mkN "piroelectricitat" feminine ; --auto
lin pyrolysis_N = mkN "piròlisi" feminine ; --auto
lin pyromaniac_N = mkN "piròman" feminine | mkN "piròman" masculine ; --auto
lin pyrometer_N = mkN "piròmetre" masculine ; --auto
lin pyrope_N = mkN "pirop" masculine ; --auto
lin pyrophyllite_N = mkN "pirofil·lita" feminine ; --auto
lin pyrotechnics_N = mkN "pirotècnia" feminine ; --auto
lin python_N = mkN "pitó" masculine ; --auto
lin pyxis_N = mkN "píxide" masculine ; --auto
lin quadrangle_N = mkN "quadrangle" masculine ; --auto
lin quadrangular_A = mkA "quadrangular" ; --auto
lin quadrant_N = mkN "quadrant" masculine ; --auto
lin quadraphony_N = mkN "quadrifonia" feminine ; --auto
lin quadratic_A = mkA "quadràtic" ; --auto
lin quadrature_N = mkN "quadratura" feminine ; --auto
lin quadriceps_N = mkN "quàdriceps" masculine | mkN "quàdriceps" masculine ; --auto
lin quadrilateral_N = mkN "quadrilàter" masculine ; --auto
lin quadruple_N = mkN "quàdruple" masculine ; --auto
lin quail_N = mkN "guatlla" feminine ; --auto
lin quaint_A = mkA "pintoresc" ; --auto
lin qualification_N = mkN "capacitat" feminine | mkN "qualificació" feminine ; --auto
lin qualified_A = mkA "qualificat" ; --auto
lin qualifier_N = mkN "qualificador" feminine | mkN "qualificador" masculine ; --auto
lin qualify_V = mkV "classificar-se" | mkV "qualificar" | mkV "titular-se" ; --auto
lin qualitative_A = mkA "qualitatiu" ; --auto
lin quality_N = mkN "qualitat" feminine ;
lin quantifiable_A = mkA "quantificable" ; --auto
lin quantification_N = mkN "quantificació" feminine ; --auto
lin quantifier_N = mkN "quantificador" masculine ; --auto
lin quantify_V2 = mkV2 "quantificar" ; --auto
lin quantitative_A = mkA "quantitatiu" ; --auto
lin quantity_N = mkN "quantitat" feminine ; --auto
lin quantum_N = mkN "quàntum" masculine ; --auto
lin quarantine_N = mkN "quarentena" feminine ; --auto
lin quark_N = mkN "quark" masculine ; --auto
lin quarrel_N = mkN "baralla" feminine ; --auto
lin quarry_N = mkN "pedrera" feminine ; --auto
lin quarter_N = mkN "quart" masculine ; --split "barri" masc (1/4 vs neighbourhood)
lin quarter_V2 = mkV2 "aquarterar" ; --auto
lin quarterly_A = mkA "trimestral" ; --auto
lin quartet_N = mkN "quartet" masculine ; --auto
lin quartz_N = mkN "quars" masculine | mkN "quars" masculine ; --auto
lin quartzite_N = mkN "quarsita" feminine ; --auto
lin quasar_N = mkN "quàsar" masculine ; --auto
lin quaver_N = mkN "corxera" feminine ; --auto
lin queen_N = L.queen_N ;
lin query_N = mkN "consulta" feminine ; --auto
lin quest_N = mkN "recerca" feminine ; --auto
lin question_N = L.question_N ;
lin question_V2 = mkV2 "qüestionar" ; --auto
lin question_mark_N = mkN "signe d'interrogació" masculine ; --auto
lin questionable_A = mkA "qüestionable" ; --auto
lin questionnaire_N = mkN "qüestionari" masculine ; --auto
lin quick_A = mkA "ràpid" ; --auto
lin quick_Adv = mkAdv "ràpidament" ; --auto
lin quicksilver_N = mkN "argent viu" masculine ; --auto
lin quiet_A = mkA "tranquil" ; --auto
lin quietly_Adv = mkAdv "baix" ; --auto
lin quill_N = mkN "pua" feminine ; --auto
lin quilt_N = mkN "edredó" masculine ; --auto
lin quince_N = mkN "codony" masculine ; --auto
lin quinine_N = mkN "quinina" feminine ; --auto
lin quintet_N = mkN "quintet" masculine ; --auto
lin quipu_N = mkN "quipu" masculine ; --auto
lin quite_Adv = S.quite_Adv ;
lin quixotic_A = mkA "quixotesc" ; --auto
lin quorum_N = mkN "quòrum" masculine ; --auto
lin quota_N = mkN "quota" feminine ; --auto
lin quotation_N = mkN "esment" masculine ; --auto
lin quote_V = mkV "citar" ; --auto
lin quote_V2 = mkV2 "citar" ; --auto
lin quotient_N = mkN "quocient" masculine ; --auto
lin rabbi_N = mkN "rabí" masculine ; --auto
lin rabbit_N = mkN "conill" feminine | mkN "conill" masculine ; --auto
lin rabies_N = mkN "ràbia" feminine ; --auto
lin race_1_N = mkN "raça" feminine ;
lin race_2_N = mkN "cursa" feminine ;
lin race_V = mkV "córrer" ; --auto
lin race_V2 = mkV2 "córrer" ; --auto
lin race_off_V = advV OP_race_V OP_off_Adv ; -- guess-p-verb
lin raceway_N = mkN "raceway" masculine ; --auto
lin racial_A = mkA "racial" ; --auto
lin racing_N = mkN "cursa" feminine ; --auto
lin racism_N = mkN "racisme" masculine ; --auto
lin racistFem_N = variants {} ; ---- sense to be split
lin racistMasc_N = variants {} ; ---- sense to be split
lin racist_A = mkA "racista" ; --auto
lin rad_N = mkN "rad" masculine ; --auto
lin radar_N = mkN "radar" masculine ; --auto
lin radial_A = mkA "radial" ; --auto
lin radian_N = mkN "radian" masculine ; --auto
lin radiance_N = mkN "radiància" feminine ; --auto
lin radiant_A = mkA "radiant" ; --auto
lin radiation_N = mkN "radiació" feminine ; --auto
lin radical_A = mkA "radical" ; --auto
lin radical_N = mkN "radical" masculine ; --auto
lin radicalism_N = mkN "radicalisme" masculine ; --auto
lin radicle_N = mkN "radícula" feminine ; --auto
lin radio_A = mkA "radiofònic" ; --auto
lin radio_N = L.radio_N ;
lin radio_telescope_N = mkN "radiotelescopi" masculine ; --auto
lin radioactive_A = mkA "radioactiu" ; --auto
lin radioactivity_N = mkN "radioactivitat" feminine ; --auto
lin radiochemistry_N = mkN "radioquímica" feminine ; --auto
lin radiogram_N = mkN "radiograma" masculine ; --auto
lin radiographic_A = mkA "radiogràfic" ; --auto
lin radioimmunoassay_N = mkN "radioimmunoassaig" masculine ; --auto
lin radioisotope_N = mkN "radioisòtop" masculine ; --auto
lin radiologist_N = mkN "radiòleg" feminine | mkN "radiòleg" masculine ; --auto
lin radiology_N = mkN "radiologia" feminine ; --auto
lin radiometer_N = mkN "radiòmetre" masculine ; --auto
lin radioscopy_N = mkN "radioscòpia" feminine ; --auto
lin radiotelegraph_N = mkN "radiotelègraf" masculine ; --auto
lin radiotelephone_N = mkN "radiotelèfon" masculine ; --auto
lin radiotherapy_N = mkN "radioteràpia" feminine ; --auto
lin radish_N = mkN "rave" masculine ; --auto
lin radium_N = mkN "radi" masculine ; --auto
lin radius_N = mkN "radi" masculine ; --auto
lin radon_N = mkN "radó" masculine ; --auto
lin raffia_N = mkN "ràfia" feminine ; --auto
lin raft_N = mkN "rai" masculine ; --auto
lin rage_N = mkN "arravatament" masculine | mkN "còlera" feminine | mkN "ràbia" feminine ; --auto
lin raid_N = mkN "batuda" feminine ; --auto
lin raid_V = mkV "assaltar" ; --auto
lin raid_V2 = mkV2 "assaltar" ; --auto
lin rail_N = mkN "barana" feminine | mkN "barra" feminine | mkN "rail" masculine ; --auto
lin railcar_N = mkN "automotor" masculine ; --auto
lin railroad_N = mkN "ferrocarril" masculine ; --auto
lin railway_N = mkN "ferrocarril" masculine ;
lin rain_N = L.rain_N ;
lin rain_V = mkV "ploure" ; --auto
lin rain_V2 = mkV2 "ploure" ; --auto
lin rainbow_N = mkN "arc de Sant Martí" masculine ; --auto
lin raincoat_N = mkN "impermeable" masculine ; --auto
lin rainfall_N = mkN "pluviositat" feminine ; --auto
lin rainstorm_N = mkN "temporal de pluges" masculine ; --auto
lin rainy_A = mkA "plujós" ; --auto
lin raise_V2 = mkV2 (mkV "augmentar") ;
lin raisin_N = mkN "pansa" feminine ; --auto
lin rake_N = mkN "rampill" masculine | mkN "rasclet" masculine ; --auto
lin rally_N = mkN "ral·li" masculine ; --auto
lin ram_N = mkN "carner" masculine ; --auto
lin ramie_N = mkN "rami" masculine ; --auto
lin ramification_N = mkN "ramificació" feminine ; --auto
lin ramjet_N = mkN "estatoreactor" masculine ; --auto
lin rampart_N = mkN "muralla" feminine ; --auto
lin ranch_N = mkN "ranxo" masculine ; --auto
lin rancher_N = mkN "granger" | mkN "granger" ; --auto
lin rancid_A = mkA "ranci" ; --auto
lin random_A = mkA "aleatori" ; --auto
lin randomness_N = mkN "aleatorietat" feminine ; --auto
lin range_N = mkN "interval" masculine ;
lin range_V = mkV "alinear" | mkV "variar" ; --auto
lin rank_N = mkN "fila" feminine | mkN "graduació" feminine | mkN "grau" masculine | mkN "posició" feminine | mkN "rang" masculine ; --auto
lin ranker_N = mkN "rànker" masculine ; --auto
lin ransom_N = mkN "rescat" masculine ; --auto
lin rape_N = mkN "estupre" masculine ; --auto
lin rapeseed_N = mkN "colza" feminine ; --auto
lin rapid_A = mkA "ràpid" ; --auto
lin rapidity_N = mkN "rapidesa" feminine ; --auto
lin rapist_N = mkN "violador" feminine | mkN "violador" masculine ; --auto
lin rappel_N = mkN "ràpel" masculine ; --auto
lin rare_A = mkA "rar" ; --auto
lin rascal_N = mkN "bergant" feminine | mkN "bergant" masculine ; --auto
lin raspberry_N = mkN "gerd" masculine ; --auto
lin raster_N = mkN "ràster" masculine ; --auto
lin rat_N = mkN "rata" feminine ; --auto
lin ratchet_N = mkN "trinquet" masculine ; --auto
lin rate_N = mkN "tipus" "tipus" masculine ;
lin rate_V = mkV "valorar" ; --auto
lin rate_V2 = mkV2 "valorar" ; --auto
lin rather_Adv = mkAdv "millor" ;
lin rather_than_Prep = mkPrep "més que" ; --auto
lin ratify_V2 = mkV2 "ratificar" ; --auto
lin rating_N = mkN "índex" masculine ; --auto
lin ratio_N = mkN "proporció" feminine ; --auto
lin ration_N = mkN "ració" feminine ; --auto
lin rational_A = mkA "racional" ; --auto
lin rationalism_N = mkN "racionalisme" masculine ; --auto
lin rationalistFem_N = variants {} ; ---- sense to be split
lin rationalistMasc_N = variants {} ; ---- sense to be split
lin rationality_N = mkN "racionalitat" feminine ; --auto
lin rationing_N = mkN "racionament" masculine ; --auto
lin rattle_N = mkN "zing-zing" masculine ; --auto
lin raven_N = mkN "corb" masculine ; --auto
lin ravine_N = mkN "barranc" masculine ; --auto
lin ravioli_N = mkN "ravioli" masculine ; --auto
lin raw_A = mkA "cru" ; --auto
lin ray_N = mkN "raig" masculine ; --auto
lin rayon_N = mkN "raió" masculine ; --auto
lin razor_N = mkN "navalla" feminine ; --auto
lin reach_V = mkV "arribar" ;
lin reach_V2 = mkV2 (mkV "arribo") ParadigmsCat.dative ;
lin reach_out_V = advV OP_reach_V OP_out_Adv ; -- guess-p-verb
lin reach_out_for_V2 = prepV2 (advV OP_reach_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin reach_out_to_V2 = prepV2 (advV OP_reach_V OP_out_Adv ) OP_to_Prep ; -- guess-p-verb
lin react_V = mkV "reaccionar" ; --auto
lin reactance_N = mkN "reactància" feminine ; --auto
lin reactant_N = mkN "reactant" masculine ; --auto
lin reaction_N = mkN "reacció" feminine ;
lin reactionary_A = mkA "reaccionari" ; --auto
lin reactionary_N = mkN "reaccionari" | mkN "reaccionari" ; --auto
lin reactivate_V2 = mkV2 "reactivar" ; --auto
lin reactivity_N = mkN "reactivitat" feminine ; --auto
lin reactor_N = mkN "reactor" masculine ; --auto
lin read_V = verbV (servir_101 "llegir") ;
lin read_V2 = L.read_V2 ;
lin read_VS = mkVS (verbV (servir_101 "llegir")) ;
lin read_off_V2 = prepV2 OP_read_V OP_off_Prep ; -- guess-p-verb
lin read_out_V2 = prepV2 OP_read_V OP_out_Prep ; -- guess-p-verb
lin read_up_on_V2 = prepV2 (advV OP_read_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin readability_N = mkN "amenitat" feminine ; --auto
lin readable_A = mkA "llegible" ; --auto
lin reader_N = mkN "lector" ;
lin reading_N = mkN "lectura" feminine ; --auto
lin readjust_V2 = mkV2 "reajustar" ; --auto
lin readjustment_N = mkN "reajustament" masculine ; --auto
lin ready_A = mkA "preparat" ;
lin reagent_N = mkN "reactiu" masculine ; --auto
lin real_A = mkA "real" ;
lin realism_N = mkN "realisme" masculine ; --auto
lin realistic_A = mkA "realista" ; --auto
lin reality_N = mkN "realitat" feminine ;
lin realize_V2 = mkV2 (reflV (mkV "adonar")) ParadigmsCat.genitive ;
lin realize_VS = mkVS (reflV (mkV "adonar")) ;
lin reallocation_N = mkN "reassignació" feminine ; --auto
lin realm_N = mkN "reaialme" masculine | mkN "reialme" masculine ; --auto
lin ream_N = mkN "raima" feminine ; --auto
lin reanimate_V2 = mkV2 "reanimar" ; --auto
lin reappear_V = mkV "reaparèixer" ; --auto
lin rear_A = mkA "de darrere" ; --auto
lin rear_N = mkN "darrere" masculine ; --auto
lin rearm_V = mkV "rearmar" ; --auto
lin rearm_V2 = mkV2 "rearmar" ; --auto
lin rearrangement_N = mkN "redisposició" feminine ; --auto
lin reason_N = L.reason_N ;
lin reason_V = mkV "raonar" ; --auto
lin reason_V2 = mkV2 "raonar" ; --auto
lin reasonable_A = mkA "raonable" ; --auto
lin reasoning_N = mkN "raonament" masculine ; --auto
lin reassurance_N = mkN "tranquil·litat" feminine ; --auto
lin reassure_V2 = mkV2 "tranquil·litzar" ; --auto
lin rebel_N = mkN "rebel" ; --auto
lin rebel_V = mkV "rebel·lar-se" ; --auto
lin rebellion_N = mkN "rebel·lió" feminine ; --auto
lin rebellious_A = mkA "rebel" ; --auto
lin rebound_N = mkN "rebot" masculine ; --auto
lin rebound_V = mkV "rebotar" ; --auto
lin rebound_V2 = mkV2 "rebotar" ; --auto
lin rebuild_V2 = mkV2 "reconstruir" ; --auto
lin rebuke_N = mkN "reprensió" feminine ; --auto
lin recalculation_N = mkN "recàlcul" masculine ; --auto
lin recall_V2 = mkV2 "recordar" ; --auto
lin recapitulate_V = mkV "recapitular" ; --auto
lin recapitulate_V2 = mkV2 "recapitular" ; --auto
lin receipt_N = mkN "rebut" masculine | mkN "recepció" feminine ; --auto
lin receive_V = verbV (rebre_92 "rebre") ;
lin receive_V2 = mkV2 (verbV (rebre_92 "rebre")) ;
lin receiver_N = mkN "auricular" masculine ; --auto
lin recent_A = mkA "recent" ;
lin receptacle_N = mkN "receptacle" masculine ; --auto
lin reception_N = mkN "recepció" feminine ; --auto
lin receptionist_N = mkN "recepcionista" ; --auto
lin receptor_N = mkN "receptor" feminine | mkN "receptor" masculine ; --auto
lin recess_N = mkN "galze" masculine | mkN "recés" masculine ; --auto
lin recess_V2 = mkV2 "rebaixar" ; --auto
lin recession_N = mkN "recessió" feminine ; --auto
lin recipe_N = mkN "recepta" feminine ; --auto
lin recipient_N = mkN "destinatari" ; --auto
lin reciprocal_A = mkA "recíproc" ; --auto
lin reciprocal_N = mkN "recíproca" feminine ; --auto
lin reciprocity_N = mkN "reciprocitat" feminine ; --auto
lin recirculation_N = mkN "recirculació" feminine ; --auto
lin recitative_N = mkN "recitatiu" masculine ; --auto
lin recite_V = mkV "recitar" ; --auto
lin recite_V2 = mkV2 "recitar" ; --auto
lin reckless_A = mkA "temerari" ; --auto
lin recoding_N = mkN "recodificació" feminine ; --auto
lin recognition_N = mkN "reconeixement" masculine ; --auto
lin recognizable_A = mkA "reconeixedor" ; --auto
lin recognize_1_V2 = mkV2 (mkV (conèixer_27 "reconèixer")) ;
lin recognize_4_V2 = mkV2 (mkV (admetre_2 "admetre")) ;
lin recognize_VS = mkVS (mkV (admetre_2 "admetre")) ;
lin recombination_N = mkN "recombinació" feminine ; --auto
lin recommend_V2 = mkV2 "recomanar" ; --auto
lin recommendation_N = mkN "recomanació" feminine ; --auto
lin reconcile_V2 = mkV2 "reconciliar" ; --auto
lin reconciliation_N = mkN "reconciliació" feminine ; --auto
lin reconfiguration_N = mkN "reconfiguració" feminine ; --auto
lin reconsider_V2 = mkV2 "reconsiderar" ; --auto
lin reconstruct_V2 = mkV2 "reconstruir" ; --auto
lin reconstruction_N = mkN "reconstrucció" feminine ; --auto
lin record_1_N = mkN "registre" masculine ;
lin record_2_N = mkN "registre" masculine ;
lin record_3_N = mkN "registre" masculine ;
lin record_V2 = mkV2 (mkV "grabar") ;
lin record_player_N = mkN "tocadiscs" masculine | mkN "tocadiscs" masculine | mkN "tocadiscs" masculine ; --auto
lin recording_N = mkN "enregistrament" masculine | mkN "gravació" feminine | mkN "registre" masculine ; --auto
lin re_count_N = mkN "recompte" masculine ; --auto
lin recover_V = mkV "recuperar" ; --auto
lin recoverable_A = mkA "recuperable" ; --auto
lin recovery_N = mkN "recuperació" feminine ; --auto
lin recreate_V2 = mkV2 "recrear" ; --auto
lin recreation_N = mkN "recreació" feminine ; --auto
lin recreational_A = mkA "recreatiu" ; --auto
lin recrimination_N = mkN "recriminació" feminine ; --auto
lin recruit_N = mkN "recluta" ; --auto
lin recruitment_N = mkN "reclutament" masculine ; --auto
lin rectal_A = mkA "rectal" ; --auto
lin rectangle_N = mkN "rectangle" masculine ; --auto
lin rectangular_A = mkA "rectangular" ; --auto
lin rectification_N = mkN "rectificació" feminine ; --auto
lin rectilinear_A = mkA "rectilini" ; --auto
lin rector_N = mkN "rector" | mkN "rector" ; --auto
lin rectorship_N = mkN "rectorat" masculine ; --auto
lin rectum_N = mkN "recte" masculine ; --auto
lin recuperate_V = mkV "recuperar" ; --auto
lin recuperate_V2 = mkV2 "recuperar" ; --auto
lin recurrent_A = mkA "recurrent" ; --auto
lin recursion_N = mkN "recursivitat" feminine ; --auto
lin recursive_A = mkA "recursiu" ; --auto
lin recycle_V2 = mkV2 "reciclar" ; --auto
lin recycling_N = mkN "reciclatge" masculine ; --auto
lin red_A = L.red_A ;
lin red_N = mkN "roig" feminine | mkN "roig" masculine | mkN "vermell" masculine ; --auto
lin reddish_A = mkA "vermellós" ; --auto
lin redeem_V2 = mkV2 "redimir" ; --auto
lin redefine_V2 = mkV2 "redefinir" ; --auto
lin redesign_N = mkN "redefinició" feminine ; --auto
lin rediffusion_N = mkN "reemissió" feminine ; --auto
lin redistribute_V2 = mkV2 "redistribuir" ; --auto
lin redistribution_N = mkN "redistribució" feminine ; --auto
lin redo_V2 = mkV2 "refer" ; --auto
lin reduce_V = mkV (reduir_94 "reduir") ;
lin reduce_V2 = mkV2 (mkV (reduir_94 "reduir")) ;
lin reducible_A = mkA "reductible" ; --auto
lin reduction_N = mkN "reducció" feminine ; --auto
lin reductionism_N = mkN "reduccionisme" masculine ; --auto
lin redundancy_N = mkN "redundància" feminine ; --auto
lin redundant_A = mkA "redundant" ; --auto
lin redwood_N = mkN "sequoia" feminine ; --auto
lin reef_N = mkN "escull" masculine ; --auto
lin reel_V = mkV "debanar" ; --auto
lin reel_V2 = mkV2 "debanar" ; --auto
lin reelection_N = mkN "reelecció" feminine ; --auto
lin reeler_N = mkN "debanador" feminine | mkN "debanador" masculine ; --auto
lin re_entry_N = mkN "reingrés" masculine ; --auto
lin reexamine_V = mkV "reexaminar" ; --auto
lin refer_V = mkV (admetre_2 "remtre") ;
lin refer_V2 = mkV2 (mkV (admetre_2 "remetre")) ParadigmsCat.dative ;
lin referee_N = mkN "àrbitre" ; --auto
lin reference_N = mkN "referència" feminine ;
lin referendum_N = mkN "referèndum" masculine ; --auto
lin referent_N = mkN "referent" masculine ; --auto
lin referential_A = mkA "referencial" ; --auto
lin refill_N = mkN "recanvi" masculine ; --auto
lin refined_A = mkA "refinat" ; --auto
lin refinement_N = mkN "refinament" masculine ; --auto
lin refiner_N = mkN "refinador" masculine ; --auto
lin refinery_N = mkN "refineria" feminine ; --auto
lin refining_N = mkN "refinatge" masculine ; --auto
lin reflation_N = mkN "reactivació" feminine ; --auto
lin reflect_V = mkV "pensar" | mkV "reflexionar" ;
lin reflect_V2 = mkV2 (mkV (servir_101 "reflectir")) ;
lin reflection_N = mkN "reflexió" feminine | mkN "reflex" masculine ; --auto
lin reflective_A = mkA "reflectant" ; --auto
lin reflectometer_N = mkN "reflectòmetre" masculine ; --auto
lin reflector_N = mkN "reflector" masculine ; --auto
lin reflexive_A = mkA "reflexiu" ; --auto
lin reflexivity_N = mkN "reflexivitat" feminine ; --auto
lin reflexology_N = mkN "reflexologia" feminine ; --auto
lin reform_N = mkN "reforma" feminine ;
lin re_form_V = mkV "reformar" ; --auto
lin re_form_V2 = mkV2 "reformar" ; --auto
lin reformatory_N = mkN "reformatori" masculine ; --auto
lin reformer_N = mkN "reformista" ; --auto
lin reformism_N = mkN "reformisme" masculine ; --auto
lin refraction_N = mkN "refracció" feminine ; --auto
lin refractivity_N = mkN "refractivitat" feminine ; --auto
lin refractometer_N = mkN "refractòmetre" masculine ; --auto
lin refractory_A = mkA "refractari" ; --auto
lin refrain_N = mkN "refrena" feminine ; --auto
lin refrigerant_N = mkN "refrigerant" masculine ; --auto
lin refrigeration_N = mkN "refrigeració" feminine ; --auto
lin refrigerator_N = mkN "nevera" feminine ; --auto
lin refugee_N = mkN "refugiat" | mkN "refugiat" ; --auto
lin refund_N = mkN "reemborsament" masculine ; --auto
lin refusal_N = mkN "desestimació" feminine | mkN "negativa" feminine ; --auto
lin refuse_N = mkN "residu" masculine | mkN "residu" masculine ; --auto
lin refuse_V = reflV (mkV "negar") ;
lin refuse_V2 = mkV2 (mkV "rebutjar") ;
lin refuse_VV = aVV (reflV (mkV "negar")) ;
lin refutation_N = mkN "refutació" feminine ; --auto
lin regal_A = mkA "regi" ; --auto
lin regard_N = mkN "consideració" feminine ; --auto
lin regard_V = mkV "considerar" ;
lin regard_V2 = mkV2 (mkV "considerar") ;
lin regarding_Prep = mkPrep "pel que fa a" | mkPrep "quant a" ; --auto
lin regardless_Adv = mkAdv "malgrat tot" ; --auto
lin regency_N = mkN "regència" feminine ; --auto
lin regenerate_V = mkV "regenerar" ; --auto
lin regenerate_V2 = mkV2 "regenerar" ; --auto
lin regeneration_N = mkN "regeneració" feminine ; --auto
lin regent_N = mkN "regent" ; --auto
lin regicide_N = mkN "regicidi" masculine ; --auto
lin regime_1_N = variants {} ; ---- sense to be split
lin regime_2_N = variants {} ; ---- sense to be split
lin regiment_N = mkN "regiment" masculine ; --auto
lin region_N = mkN "regió" feminine ;
lin regional_A = mkA "regional" ;
lin regionalism_N = mkN "regionalisme" masculine ; --auto
lin register_N = mkN "registre" masculine ; --auto
lin register_V = mkV "registrar" ; --auto
lin register_V2 = mkV2 "registrar" ; --auto
lin registrar_N = mkN "registrador" | mkN "registrador" ; --auto
lin registration_N = mkN "inscripció" feminine ; --auto
lin registry_N = mkN "registre" masculine ; --auto
lin regosol_N = mkN "regosòl" masculine ; --auto
lin regression_N = mkN "regressió" feminine ; --auto
lin regret_N = mkN "remordiment" masculine ; --auto
lin regret_V2 = mkV2 "lamentar" ; --auto
lin regrettable_A = mkA "lamentable" ; --auto
lin regular_A = mkA "regular" ;
lin regularity_N = mkN "regularitat" feminine ; --auto
lin regulate_V2 = mkV2 "regular" ; --auto
lin regulation_N = mkN "regulació" masculine ;
lin regulator_N = mkN "regulador" masculine ; --auto
lin regulatory_A = mkA "regulador" ; --auto
lin rehabilitate_V2 = mkV2 "rehabilitar" ; --auto
lin rehabilitation_N = mkN "rehabilitació" feminine ; --auto
lin rehearsal_N = mkN "assaig" masculine ; --auto
lin reign_N = mkN "regnat" masculine ; --auto
lin reign_V = mkV "regnar" ; --auto
lin reimbursement_N = mkN "reembors" masculine ; --auto
lin rein_N = mkN "regna" feminine ; --auto
lin reincarnation_N = mkN "reencarnació" feminine ; --auto
lin reindeer_N = mkN "ren" masculine ; --auto
lin reinforce_V2 = mkV2 "reforçar" ; --auto
lin reinforcement_N = mkN "reforç" masculine ; --auto
lin reinstate_V2 = mkV2 "restablir" ; --auto
lin reinsurance_N = mkN "reassegurança" feminine ; --auto
lin reintegration_N = mkN "reintegració" feminine ; --auto
lin reinvest_V2 = mkV2 "reinvertir" ; --auto
lin reissue_V2 = mkV2 "reestrenar" ; --auto
lin reiterate_V2 = mkV2 "reiterar" ; --auto
lin reiteration_N = mkN "reiteració" feminine ; --auto
lin reject_V2 = mkV2 "refusar" ; --auto
lin rejection_N = mkN "rebuig" masculine ; --auto
lin rejoinder_N = mkN "contrarèplica" feminine ; --auto
lin rejuvenate_V = mkV "rejovenir" ; --auto
lin rejuvenate_V2 = mkV2 "rejovenir" ; --auto
lin relate_V = mkV "relacionar" ; --subcat? Should be "relate to" in English?
lin relate_V2 = mkV2 (reflV (mkV "relacionar")) (mkPrep "amb") ;
lin relation_N = mkN "relació" feminine ;
lin relational_A = mkA "relacional" ; --auto
lin relationship_N = mkN "relació" feminine ;
lin relative_A = mkA "relatiu" ; --auto
lin relative_N = mkN "parent" ; --auto
lin relativism_N = mkN "relativisme" masculine ; --auto
lin relativistic_A = mkA "relativista" ; --auto
lin relativity_N = mkN "relativitat" feminine ; --auto
lin relax_V = mkV "relaxar" ; --auto
lin relax_V2 = mkV2 "relaxar" ; --auto
lin relaxation_N = mkN "relaxació" feminine ; --auto
lin relay_N = mkN "relè" masculine ; --auto
lin release_N = mkN "alliberament" masculine | mkN "emissió" feminine | mkN "excarceració" feminine | mkN "versió" feminine ; --auto
lin release_V2 = mkV2 (mkV "alliberar") ;
lin relentless_A = mkA "implacable" ; --auto
lin relevance_N = mkN "pertinència" feminine ; --auto
lin relevant_A = mkA "rellevant" ;
lin reliability_N = mkN "fiabilitat" feminine ; --auto
lin reliable_A = mkA "fiable" ; --auto
lin relief_N = mkN "alleujament" masculine ;
lin relieve_V2 = mkV2 "alleujar" | mkV2 "rellevar" ; --auto
lin religion_N = L.religion_N ;
lin religious_A = mkA "religiós" ;
lin religiousness_N = mkN "religiositat" feminine ; --auto
lin relocate_V = mkV "reubicar" ; --auto
lin relocate_V2 = mkV2 "reubicar" ; --auto
lin reluctant_A = mkA "reticent" ; --auto
lin reluctivity_N = mkN "reluctivitat" feminine ; --auto
lin rely_V = mkV "confiar" ; --auto
lin rely_V2 = mkV2 "confiar" ; --auto
lin rely_on_V = advV OP_rely_V OP_on_Adv ; -- guess-p-verb
lin rely_on_V2V = variants {} ; -- guess-p-verb
lin remain_V = verbV (romandre_97 "romandre") ;
lin remain_V2 = mkV2 "quedar" | mkV2 "restar" | mkV2 "romandre" ; --auto
lin remain_VA = mkVA (mkV "estar") | mkVA (mkV "quedar") ;
lin remain_VV = mkVV (mkV "continuar") ; --subcat continuava + GERUNDI | quedar-se + GERUNDI
lin remainder_N = mkN "resta" feminine ; --auto
lin remaining_A = mkA "restant" ; --auto
lin remains_N = mkN "resta" feminine ; --auto
lin remark_N = mkN "comentari" masculine ; --auto
lin remark_V = mkV "remarcar" ; --auto
lin remarkable_A = mkA "notable" | mkA "remarcable" ; --auto
lin rematch_N = mkN "rematx" masculine ; --auto
lin remedial_A = mkA "terapèutic" ; --auto
lin remedy_N = mkN "remei" masculine ; --auto
lin remedy_V2 = mkV2 "remeiar" ; --auto
lin remember_V = mkV "recordar" ;
lin remember_V2 = mkV2 (mkV "recordar") ;
lin remember_VS = mkVS (mkV "recordar") ;
lin remind_V2 = mkV2 "recordar" ; --auto
lin reminder_N = mkN "recordatori" masculine ; --auto
lin reminiscence_N = mkN "reminiscència" feminine ; --auto
lin remit_V = mkV "remetre" ; --auto
lin remit_V2 = mkV2 "remetre" ; --auto
lin remnant_N = mkN "romanent" masculine ; --auto
lin remodel_V = mkV "remodelar" ; --auto
lin remodel_V2 = mkV2 "remodelar" ; --auto
lin remorse_N = mkN "remordiment" masculine ; --auto
lin remorseless_A = mkA "implacable" ; --auto
lin remote_A = mkA "remot" ; --auto
lin remount_V = mkV "remuntar el vol" ; --auto
lin removable_A = mkA "desmuntable" ; --auto
lin removal_N = mkN "extracció" feminine | mkN "trasllat" masculine ; --auto
lin remove_V = mkV "eliminar" | mkV "retirar" ;
lin remove_V2 = mkV2 (mkV "eliminar") | mkV2 (mkV "retirar") ;
lin renaissance_N = mkN "renaixement" masculine ; --auto
lin renal_A = mkA "renal" ; --auto
lin rename_V2 = mkV2 "rebatejar" ; --auto
lin renegadeFem_N = variants {} ; ---- sense to be split
lin renegadeMasc_N = variants {} ; ---- sense to be split
lin renegotiate_V2 = mkV2 "renegociar" ; --auto
lin renew_V2 = mkV2 "renovar" ; --auto
lin renewable_A = mkA "renovable" ; --auto
lin renewal_N = mkN "renovació" feminine ; --auto
lin rennet_N = mkN "quall" masculine ; --auto
lin renounce_V2 = mkV2 "renunciar" ; --auto
lin renovation_N = mkN "renovació" feminine ; --auto
lin renown_N = mkN "anomenada" feminine ; --auto
lin renowned_A = mkA "famós" ; --auto
lin rent_N = mkN "lloguer" masculine ; --auto
lin rent_V = mkV "llogar" ; --auto
lin rent_V2 = mkV2 "llogar" ; --auto
lin rental_N = mkN "lloguer" masculine ; --auto
lin rentier_N = mkN "rendista" ; --auto
lin renunciation_N = mkN "renúncia" feminine ; --auto
lin reopen_V = mkV "reobrir" ; --auto
lin reopen_V2 = mkV2 "reobrir" ; --auto
lin reorient_V = mkV "reorientar" ; --auto
lin reorient_V2 = mkV2 "reorientar" ; --auto
lin repair_N = mkN "reparació" feminine ; --auto
lin repair_V = mkV "reparar" ; --auto
lin repair_V2 = mkV2 "reparar" ; --auto
lin repairable_A = mkA "reparable" ; --auto
lin repatriation_N = mkN "repatriació" feminine ; --auto
lin repayable_A = mkA "reintegrable" ; --auto
lin repayment_N = mkN "reemborsament" masculine ; --auto
lin repeat_V = mkV (servir_101 "repetir") ;
lin repeat_V2 = mkV2 (mkV (servir_101 "repetir")) ;
lin repeat_VS = mkVS (mkV (servir_101 "repetir")) ;
lin repel_V2 = mkV2 "repel·lir" ; --auto
lin repellent_N = mkN "repel·lent" masculine ; --auto
lin repercussion_N = mkN "repercussió" feminine ; --auto
lin repertoire_N = mkN "repertori" masculine ; --auto
lin repetition_N = mkN "repetició" feminine ; --auto
lin repetitive_A = mkA "repetitiu" ; --auto
lin replace_V2 = mkV2 (mkV (servir_101 "substituir")) ;
lin replacement_N = mkN "reemplaçament" masculine | mkN "substitució" feminine ; --auto
lin replenish_V2 = mkV2 "reomplir" ; --auto
lin replication_N = mkN "replicació" feminine ; --auto
lin reply_N = mkN "rèplica" feminine | mkN "resposta" feminine ; --auto
lin reply_V = mkV "contestar" ;
lin reply_VS = mkVS (mkV "contestar") ;
lin report_N = mkN "informe" masculine ; --split mkN "reportatge" (general vs. journalistic report)
lin report_V = mkV "informar" ;
lin report_V2 = mkV2 (mkV "informar") ParadigmsCat.genitive ;
lin report_VS = mkVS (mkV "informar") ;
lin report_in_V = advV OP_report_V OP_in_Adv ; -- guess-p-verb
lin reportedly_Adv = mkAdv "segons es diu" | mkAdv "segons hom diu" ; --auto
lin reporterFem_N = variants {} ; ---- sense to be split
lin reporterMasc_N = variants {} ; ---- sense to be split
lin reposition_V2 = mkV2 "recol·locar" ; --auto
lin represent_V = mkV "representar" ;
lin represent_V2 = mkV2 (mkV "representar") ;
lin representable_A = mkA "representable" ; --auto
lin representation_N = mkN "representació" feminine ; --auto
lin representativeFem_N = variants {} ; ---- sense to be split
lin representativeMasc_N = variants {} ; ---- sense to be split
lin representative_A = mkA "representatiu" ; --auto
lin repression_N = mkN "repressió" feminine ; --auto
lin reprieve_N = mkN "indult" masculine ; --auto
lin reprint_N = mkN "reimpressió" feminine ; --auto
lin reprisal_N = mkN "represàlia" feminine ; --auto
lin reproach_N = mkN "retret" masculine ; --auto
lin reproach_V2 = mkV2 "retreure" ; --auto
lin reproduce_V = mkV "reproduir" ; --auto
lin reproduce_V2 = mkV2 "reproduir" ; --auto
lin reproducer_N = mkN "reproductora" feminine ; --auto
lin reproducibility_N = mkN "reproductibilitat" feminine ; --auto
lin reproducible_A = mkA "reproduïble" ; --auto
lin reproduction_N = mkN "reproducció" feminine ; --auto
lin reptile_N = mkN "rèptil" masculine ; --auto
lin reptilian_A = mkA "rèptil" ; --auto
lin republic_N = mkN "república" feminine ; --auto
lin republican_A = mkA "republicà" ; --auto
lin republican_N = mkN "republicà" | mkN "republicà" ; --auto
lin republicanism_N = mkN "republicanisme" masculine ; --auto
lin repudiation_N = mkN "repudiació" feminine ; --auto
lin repugnant_A = mkA "repugnant" ; --auto
lin repulsion_N = mkN "repulsió" feminine ; --auto
lin repulsive_A = mkA "repulsiu" ; --auto
lin repurchase_V2 = mkV2 "recomprar" ; --auto
lin reputation_N = mkN "reputació" feminine ; --auto
lin request_N = mkN "petició" feminine | mkN "prec" masculine | mkN "requeriment" masculine ; --auto
lin request_V2 = mkV2 "demanar" | mkV2 "sol·licitar" ; --auto
lin requiem_N = mkN "rèquiem" masculine ; --auto
lin require_V = mkV "requerir" ; --auto
lin require_V2 = mkV2 "requerir" ; --auto
lin requirement_N = mkN "requisit" masculine ;
lin requisition_V2 = mkV2 "requisar" ; --auto
lin reread_V2 = mkV2 "rellegir" ; --auto
lin rerun_V2 = mkV2 "estrenar" ; --auto
lin rescript_N = mkN "rescripte" masculine ; --auto
lin rescue_N = mkN "rescat" masculine | mkN "salvament" masculine ; --auto
lin rescue_V2 = mkV2 "rescatar" ; --auto
lin rescuerFem_N = variants {} ; ---- sense to be split
lin rescuerMasc_N = variants {} ; ---- sense to be split
lin research_N = mkN "recerca" feminine ;
lin research_V = mkV "investigar" ; --auto
lin research_V2 = mkV2 "investigar" ; --auto
lin researcherFem_N = variants {} ; ---- sense to be split
lin researcherMasc_N = variants {} ; ---- sense to be split
lin resemblance_N = mkN "semblança" feminine ; --auto
lin resentment_N = mkN "ressentiment" masculine ; --auto
lin reservation_N = mkN "reserva" feminine ; --auto
lin reserve_N = mkN "reserva" feminine ; --auto
lin reserve_V = mkV "reservar" ; --auto
lin reserve_V2 = mkV2 "reservar" ; --auto
lin reservist_N = mkN "reservista" ; --auto
lin reset_N = mkN "reinicialització" feminine ; --auto
lin reside_V = mkV "residir" ; --auto
lin residence_N = mkN "residència" feminine ; --auto
lin resident_A = mkA "resident" ; --auto
lin resident_N = mkN "resident" ; --auto
lin residential_A = mkA "residencial" ; --auto
lin residual_A = mkA "residual" ; --auto
lin residue_N = mkN "residu" masculine | mkN "residu" masculine ; --auto
lin resign_V = mkV "dimitir" ; --auto
lin resign_V2 = mkV2 "dimitir" ; --auto
lin resignation_N = mkN "dimissió" feminine ; --auto
lin resin_N = mkN "resina" feminine ; --auto
lin resinous_A = mkA "resinós" ; --auto
lin resist_V = mkV "resistir" ; --auto
lin resist_V2 = mkV2 "resistir" ; --auto
lin resistance_N = mkN "resistència" feminine ; --auto
lin resistant_A = mkA "resistent" ; --auto
lin resistivity_N = mkN "resistivitat" feminine ; --auto
lin resistor_N = mkN "resistor" masculine ; --auto
lin resolution_N = mkN "disposició" feminine | mkN "resolució" feminine ; --auto
lin resolve_V = mkV "resoldre" ; --auto
lin resolve_V2 = mkV2 "resoldre" ; --auto
lin resonance_N = mkN "ressonància" feminine ; --auto
lin resonant_A = mkA "ressonant" ; --auto
lin resonator_N = mkN "ressonador" masculine ; --auto
lin resort_N = mkN "recurs" masculine ; --auto
lin resort_V = mkV "recórrer" ; --auto
lin resource_N = mkN "recurs" masculine ;
lin respect_N = mkN "respecte" masculine ;
lin respect_V2 = mkV2 "respectar" ; --auto
lin respectability_N = mkN "respectabilitat" feminine ; --auto
lin respectable_A = mkA "respectable" ; --auto
lin respectful_A = mkA "respectuós" ; --auto
lin respective_A = mkA "respectiu" ; --auto
lin respiration_N = mkN "respiració" feminine ; --auto
lin respiratory_A = mkA "respiratori" ; --auto
lin respond_V = mkV "contestar" ;
lin respond_VS = mkVS (mkV "contestar") ;
lin respondent_N = mkN "enquestat" | mkN "enquestat" ; --auto
lin response_N = mkN "resposta" feminine ;
lin responsibility_N = mkN "responsabilitat" feminine ;
lin responsible_A = mkA "responsable" ;
lin rest_N = mkN "resta" feminine ;
lin rest_V2 = mkV2 "descansar" ; --auto
lin restart_V = mkV "reprendre" ; --auto
lin restart_V2 = mkV2 "reprendre" ; --auto
lin restate_V2 = mkV2 "reafirmar" ; --auto
lin restaurant_N = L.restaurant_N ;
lin restitution_N = mkN "restitució" feminine ; --auto
lin restless_A = mkA "inquiet" ; --auto
lin restlessness_N = mkN "inquietud" feminine ; --auto
lin restoration_N = mkN "restauració" feminine ; --auto
lin restore_V2 = mkV2 "restaurar" ; --auto
lin restrain_V2 = mkV2 "refrenar" ; --auto
lin restraint_N = mkN "restricció" feminine ; --auto
lin restrict_V = mkV "restringir" ; --auto
lin restrict_V2 = mkV2 "restringir" ; --auto
lin restriction_N = mkN "restricció" feminine ; --auto
lin restructure_V = mkV "reestructurar" ; --auto
lin restructure_V2 = mkV2 "reestructurar" ; --auto
lin result_N = mkN "resultat" masculine ;
lin result_V = mkV "resultar" ;
lin resultant_A = mkA "resultant" ; --auto
lin resultant_N = mkN "resultant" masculine ; --auto
lin resumption_N = mkN "represa" feminine ; --auto
lin resurgence_N = mkN "ressurgència" feminine ; --auto
lin resurrect_V = mkV "ressuscitar" ; --auto
lin resurrect_V2 = mkV2 "ressuscitar" ; --auto
lin resurrection_N = mkN "resurrecció" feminine ; --auto
lin retail_N = mkN "venda al detall" feminine ; --auto
lin retailer_N = mkN "detallista" ; --auto
lin retailing_N = mkN "venda al detall" feminine ; --auto
lin retain_V2 = mkV2 "retenir" ; --auto
lin retainer_N = mkN "retenidor" feminine | mkN "retenidor" masculine ; --auto
lin retake_V2 = mkV2 "recuperar" ; --auto
lin retard_V2 = mkV2 "endarrerir" ; --auto
lin reticle_N = mkN "reticle" masculine ; --auto
lin reticulocyte_N = mkN "reticulòcit" masculine ; --auto
lin retina_N = mkN "retina" feminine ; --auto
lin retinoblastoma_N = mkN "retinoblastoma" masculine ; --auto
lin retinopathy_N = mkN "retinopatia" feminine ; --auto
lin retire_V = mkV "retirar-se" ; --auto
lin retirement_N = mkN "jubilació" feminine ; --auto
lin retort_N = mkN "retorta" feminine ; --auto
lin retort_V2 = mkV2 "replicar" ; --auto
lin retouch_V2 = mkV2 "retocar" ; --auto
lin retractable_A = mkA "retràctil" ; --auto
lin retreat_N = mkN "retir" masculine ; --auto
lin retreat_V = mkV "retrocedir" ; --auto
lin retrieve_V = mkV "recuperar" ; --auto
lin retrieve_V2 = mkV2 "recuperar" ; --auto
lin retroactive_A = mkA "retroactiu" ; --auto
lin retrograde_A = mkA "retrògrad" ; --auto
lin retrospective_A = mkA "retrospectiu" ; --auto
lin retroversion_N = mkN "retroversió" feminine ; --auto
lin retrovirus_N = mkN "retrovirus" masculine | mkN "retrovirus" masculine ; --auto
lin return_N = mkN "retorn" masculine ;
lin return_V = mkV "tornar" ;
lin return_V2 = mkV2 (mkV "tornar") ;
lin returnable_A = mkA "reintegrable" ; --auto
lin reunion_N = mkN "retrobament" masculine ; --auto
lin reveal_V2 = mkV2 (mkV "revelar") ;
lin reveal_VS = mkVS (mkV "revelar") ;
lin revenue_N = mkN "ingrés" masculine | mkN "ingrés" masculine ; --auto
lin reverberation_N = mkN "reverberació" feminine ; --auto
lin reverence_N = mkN "reverència" feminine ; --auto
lin reverend_A = mkA "reverend" ; --auto
lin reverend_N = mkN "reverend" masculine ; --auto
lin reverie_N = mkN "somieig" masculine ; --auto
lin reverse_A = mkA "invers" ; --auto
lin reverse_N = mkN "inrevés" masculine ; --auto
lin reverse_V = mkV "fer marxa arrere" | mkV "fer marxa enrere" | mkV "invertir" | mkV "revocar" ; --auto
lin reversible_A = mkA "reversible" ; --auto
lin reversionary_A = mkA "reversionari" ; --auto
lin review_N = mkN "ressenya" feminine ;
lin review_V = mkV "ressenyar" | mkV "revisar" ; --auto
lin review_V2 = mkV2 "ressenyar" | mkV2 "revisar" ; --auto
lin revise_V = mkV "revisar" ; --auto
lin revise_V2 = mkV2 "revisar" ; --auto
lin revision_N = mkN "revisió" feminine ; --auto
lin revisionism_N = mkN "revisionisme" masculine ; --auto
lin revisionistFem_N = variants {} ; ---- sense to be split
lin revisionistMasc_N = variants {} ; ---- sense to be split
lin revival_N = mkN "ressorgiment" masculine ; --auto
lin revive_V = mkV "reviure" ; --auto
lin revive_V2 = mkV2 "reviure" ; --auto
lin revocable_A = mkA "revocable" ; --auto
lin revoke_V = mkV "revocar" ; --auto
lin revoke_V2 = mkV2 "revocar" ; --auto
lin revolt_V = mkV "repugnar" ; --auto
lin revolt_V2 = mkV2 "repugnar" ; --auto
lin revolution_N = mkN "revolució" feminine ; --auto
lin revolutionary_A = mkA "revolucionari" ; --auto
lin revolutionary_N = mkN "revolucionari" | mkN "revolucionari" ; --auto
lin revolver_N = mkN "revòlver" masculine ; --auto
lin reward_N = mkN "recompensa" feminine | mkN "retribució" feminine ; --auto
lin reward_V2 = mkV2 "premiar" ; --auto
lin rewrite_V2 = mkV2 "reescriure" ; --auto
lin rewriting_N = mkN "reescriptura" feminine ; --auto
lin rhapsody_N = mkN "rapsòdia" feminine ; --auto
lin rhenium_N = mkN "reni" masculine ; --auto
lin rheology_N = mkN "reologia" feminine ; --auto
lin rheostat_N = mkN "reòstat" masculine ; --auto
lin rhetoric_N = mkN "retòrica" feminine ; --auto
lin rhetorical_A = mkA "retòric" ; --auto
lin rheum_N = mkN "lleganya" feminine ; --auto
lin rheumatism_N = mkN "reumatisme" masculine ; --auto
lin rhino_N = mkN "rinoceront" masculine ; --auto
lin rhinoceros_N = mkN "rinoceront" masculine ; --auto
lin rhinopathy_N = mkN "rinopatia" feminine ; --auto
lin rhinoscope_N = mkN "rinoscopi" masculine ; --auto
lin rhinoscopy_N = mkN "rinoscòpia" feminine ; --auto
lin rhizome_N = mkN "rizoma" masculine ; --auto
lin rhizopod_N = mkN "rizòpode" masculine ; --auto
lin rhodium_N = mkN "rodi" masculine ; --auto
lin rhododendron_N = mkN "rododèndron" masculine ; --auto
lin rhodolite_N = mkN "rodolita" feminine ; --auto
lin rhodonite_N = mkN "rodonita" feminine ; --auto
lin rhombic_A = mkA "ròmbic" ; --auto
lin rhombohedral_A = mkA "romboèdric" ; --auto
lin rhombohedron_N = mkN "rombòedre" masculine ; --auto
lin rhomboid_N = mkN "romboide" masculine ; --auto
lin rhombus_N = mkN "rombe" masculine ; --auto
lin rhubarb_N = mkN "ruibarbre" masculine ; --auto
lin rhyme_N = mkN "rima" feminine ; --auto
lin rhyme_V = mkV "rimar" ; --auto
lin rhyme_V2 = mkV2 "rimar" ; --auto
lin rhythm_N = mkN "ritme" masculine ; --auto
lin rhythmical_A = mkA "rítmic" ; --auto
lin rib_N = mkN "costella" feminine | mkN "xulla" feminine ; --auto
lin ribosome_N = mkN "ribosoma" masculine ; --auto
lin rice_N = mkN "arròs" masculine ; --auto
lin rich_A = mkA "ric" ;
lin rid_V2 = mkV2 "lliurar" ; --auto
lin riddle_N = mkN "enigma" masculine ; --auto
lin ride_N = mkN "passeig" masculine | mkN "passejada" feminine ; --auto
lin ride_V = mkV "muntar" ; --auto
lin ride_V2 = mkV2 "muntar" ; --auto
lin ride_off_V = advV OP_ride_V OP_off_Adv ; -- guess-p-verb
lin ride_on_V2 = prepV2 OP_ride_V OP_on_Prep ; -- guess-p-verb
lin ride_out_V2 = prepV2 OP_ride_V OP_out_Prep ; -- guess-p-verb
lin ride_up_V = advV OP_ride_V OP_up_Adv ; -- guess-p-verb
lin riderFem_N = variants {} ; ---- sense to be split
lin riderMasc_N = variants {} ; ---- sense to be split
lin ridicule_V2 = mkV2 "ridiculitzar" ; --auto
lin ridiculous_A = mkA "ridícul" ; --auto
lin riding_N = mkN "equitació" feminine ; --auto
lin riding_school_N = mkN "escola d'equitació" feminine ; --auto
lin rifle_N = mkN "rifle" masculine ; --auto
lin rift_N = mkN "rift" masculine ; --auto
lin right_1_A = mkA "correcte" ;
lin right_1_Adv = mkAdv "bé" ; --split mkAdv "a la dreta"
lin right_2_A = mkA "correcte" ;
lin right_2_Adv = mkAdv "bé" ; --split mkAdv "a la dreta"
lin right_3_A = mkA "correcte" ;
lin right_N = mkN "dreta" feminine ; --split mkN "dret" masculine (direction vs. legal right)
lin rigid_A = mkA "rígid" ; --auto
lin rigidity_N = mkN "rigidesa" feminine ; --auto
lin rigorous_A = mkA "rigorós" ; --auto
lin rigour_N = mkN "rigor" masculine ; --auto
lin rim_N = mkN "brocal" masculine ; --auto
lin ring_4_V2 = mkV2 (mkV "trucar") ParadigmsCat.dative ;
lin ring_6_V2 = variants {} ; -- guess-p-verb
lin ring_N = mkN "anella" feminine | mkN "anell" masculine | mkN "cercle" masculine | mkN "cèrcol" masculine | mkN "virolla" feminine ; --auto
lin ring_V = mkV "trucar" ;
lin ring_back_V2 = mkV2 (advV OP_ring_V OP_back_Adv ) ; -- guess-p-verb
lin ring_finger_N = mkN "dit anular" masculine ; --auto
lin ring_in_V = advV OP_ring_V OP_in_Adv ; -- guess-p-verb
lin ring_off_V = advV OP_ring_V OP_off_Adv ; -- guess-p-verb
lin ring_out_V = advV OP_ring_V OP_out_Adv ; -- guess-p-verb
lin ring_round_V = advV OP_ring_V OP_round_Adv ; -- guess-p-verb
lin ring_up_V = advV OP_ring_V OP_up_Adv ; -- guess-p-verb
lin ring_up_V2 = prepV2 OP_ring_V OP_up_Prep ; -- guess-p-verb
lin ring_with_V2 = prepV2 OP_ring_V OP_with_Prep ; -- guess-p-verb
lin ringer_N = mkN "campaner" masculine ; --auto
lin riot_N = mkN "aldarull" masculine | mkN "amotinament" masculine ; --auto
lin rip_V = mkV "estripar" ; --auto
lin rip_V2 = mkV2 "estripar" ; --auto
lin ripe_A = mkA "madur" ; --auto
lin ripper_N = mkN "ripadora" feminine ; --auto
lin ripple_N = mkN "rugositat" feminine ; --auto
lin rise_N = mkN "augment" ;
lin rise_V = mkV "augmentar" ;
lin rise_V2 = mkV2 (mkV "augmentar") ;
lin risk_N = mkN "risc" masculine ;
lin risk_V2 = mkV2 "arriscar" ; --auto
lin risky_A = mkA "arriscat" ; --auto
lin rite_N = mkN "ritu" masculine ; --auto
lin ritual_A = mkA "ritual" ; --auto
lin ritual_N = mkN "ritual" masculine ; --auto
lin ritualism_N = mkN "ritualisme" masculine ; --auto
lin ritualistic_A = mkA "ritualista" ; --auto
lin rival_A = mkA "rival" ; --auto
lin rival_N = mkN "rival" ; --auto
lin rivalry_N = mkN "rivalitat" feminine ; --auto
lin rive_V = mkV "esberlar" ; --auto
lin rive_V2 = mkV2 "esberlar" ; --auto
lin river_N = L.river_N ;
lin rivet_N = mkN "rivet" masculine ; --auto
lin road_N = L.road_N ;
lin roadstead_N = mkN "rada" feminine ; --auto
lin roar_N = mkN "brogit" masculine ; --auto
lin roar_V = mkV "rugir" ; --auto
lin roar_V2 = mkV2 "rugir" ; --auto
lin roast_N = mkN "rostit" masculine ; --auto
lin rob_V2 = mkV2 "atracar" | mkV2 "robar" ; --auto
lin robin_N = mkN "pit-roig" masculine ; --auto
lin robot_N = mkN "robot" masculine ; --auto
lin robotic_A = mkA "robòtic" ; --auto
lin robotics_N = mkN "robòtica" feminine ; --auto
lin robust_A = mkA "robust" ; --auto
lin robustness_N = mkN "robustesa" feminine ; --auto
lin rock_1_N = L.rock_N ;
lin rock_2_N = L.rock_N ;
lin rock_V = mkV "engrunsar" | mkV "gronxar" | mkV "sacsejar" ; --auto
lin rock_V2 = mkV2 "engrunsar" | mkV2 "gronxar" | mkV2 "sacsejar" ; --auto
lin rocket_1_N = mkN "coet" masculine ; --auto
lin rocket_2_N = mkN "coet" masculine ; --auto
lin rocky_A = mkA "rocós" ; --auto
lin rococo_N = mkN "rococó" masculine ; --auto
lin rod_N = mkN "vareta" feminine ; --auto
lin rodent_N = mkN "rosegador" feminine | mkN "rosegador" masculine ; --auto
lin roebuck_N = mkN "cabirol" masculine ; --auto
lin roentgenium_N = mkN "roentgeni" masculine | mkN "roentgueni" masculine ; --auto
lin role_N = mkN "paper" masculine ;
lin roll_N = mkN "rotlle" masculine ; --auto
lin roll_V = mkV "caragolar" | mkV "cargolar" | mkV "rodolar" ; --auto
lin roll_V2 = mkV2 "caragolar" | mkV2 "cargolar" | mkV2 "rodolar" ; --auto
lin roll_back_V = advV OP_roll_V OP_back_Adv ; -- guess-p-verb
lin roll_back_V2 = mkV2 (advV OP_roll_V OP_back_Adv ) ; -- guess-p-verb
lin roll_by_V = advV OP_roll_V OP_by_Adv ; -- guess-p-verb
lin roll_down_V = advV OP_roll_V OP_down_Adv ; -- guess-p-verb
lin roll_in_V = advV OP_roll_V OP_in_Adv ; -- guess-p-verb
lin roll_on_V = advV OP_roll_V OP_on_Adv ; -- guess-p-verb
lin roll_on_V2 = prepV2 OP_roll_V OP_on_Prep ; -- guess-p-verb
lin roll_out_V2 = prepV2 OP_roll_V OP_out_Prep ; -- guess-p-verb
lin roll_over_V = advV OP_roll_V OP_over_Adv ; -- guess-p-verb
lin roll_up_V = advV OP_roll_V OP_up_Adv ; -- guess-p-verb
lin roller_N = mkN "roleu" masculine ; --auto
lin rolling_N = mkN "rodament" masculine ; --auto
lin roman_A = mkA "romà" ; --auto
lin roman_N = mkN "romà" | mkN "romà" ; --auto
lin romance_A = mkA "romànic" ; --auto
lin romance_N = mkN "idil·li" masculine ; --auto
lin romanianFem_N = variants {} ; ---- sense to be split
lin romanianMasc_N = variants {} ; ---- sense to be split
lin romanian_A = mkA "romanès" ; --auto
lin romantic_A = mkA "romàntic" ; --auto
lin romanticism_N = mkN "romanticisme" masculine ; --auto
lin rondo_N = mkN "rondó" masculine ; --auto
lin roof_N = L.roof_N ;
lin rook_N = mkN "torre" feminine ; --auto
lin room_1_N = mkN "habitació" feminine ;
lin room_2_N = mkN "habitació" feminine ;
lin rooster_N = mkN "gall" masculine ; --auto
lin root_N = L.root_N ;
lin root_V = mkV "arrelar" ; --auto
lin root_V2 = mkV2 "arrelar" ; --auto
lin rooting_N = mkN "arrelament" masculine ; --auto
lin rope_N = L.rope_N ;
lin ropeway_N = mkN "telefèric" masculine ; --auto
lin roquefort_N = mkN "rocafort" masculine ; --auto
lin rosary_N = mkN "rosari" masculine ; --auto
lin rose_N = mkN "rosa" feminine ; --auto
lin rosebay_N = mkN "baladre" masculine ; --auto
lin rosette_N = mkN "roseta" feminine ; --auto
lin rot_N = mkN "podridura" feminine ; --auto
lin rot_V = mkV "podrir" ; --auto
lin rot_V2 = mkV2 "podrir" ; --auto
lin rotary_A = mkA "rotatiu" ; --auto
lin rotation_N = mkN "rotació" feminine ; --auto
lin rotational_A = mkA "rotacional" ; --auto
lin rotatory_A = mkA "rotatori" ; --auto
lin rotogravure_N = mkN "rotogravat" masculine ; --auto
lin rotor_N = mkN "rotor" masculine ; --auto
lin rotten_A = L.rotten_A ;
lin rouble_N = mkN "ruble" masculine ; --auto
lin rouge_N = mkN "coloret" masculine ; --auto
lin rough_A = mkA "aspre" ; --auto
lin roughly_AdV = mkAdv "aproximadament" | mkAdv "més o menys" ; --auto
lin roughness_N = mkN "aspresa" feminine | mkN "aspresa" feminine ; --auto
lin roulette_N = mkN "ruleta" feminine ; --auto
lin round_A = L.round_A ;
lin round_Adv = mkPrep "al voltant de" ;
lin round_N = mkN "assalt" masculine | mkN "ronda" feminine ; --auto
lin round_Prep = mkPrep "al voltant de" ;
lin round_V = mkV "arrodonir" ; --auto
lin round_V2 = mkV2 "arrodonir" ; --auto
lin round_the_clock_Adv = mkAdv "les vint-i quatre hores del dia" ; --auto
lin roundabout_N = mkN "rotonda" feminine ; --auto
lin route_N = mkN "ruta" feminine ;
lin router_N = mkN "encaminador" feminine | mkN "encaminador" masculine ; --auto
lin routine_A = mkA "rutinari" ; --auto
lin routine_N = mkN "rutina" feminine ; --auto
lin row_N = mkN "baralla" feminine | mkN "fila" feminine ; --auto
lin row_V = mkV "remar" | mkV "vogar" ; --auto
lin row_V2 = mkV2 "remar" | mkV2 "vogar" ; --auto
lin rower_N = mkN "remer" feminine | mkN "remer" masculine ; --auto
lin rowing_club_N = mkN "club de rem" masculine ; --auto
lin royal_A = mkA "reial" ;
lin royalism_N = mkN "reialisme" masculine ; --auto
lin royalty_N = mkN "reialesa" feminine ; --auto
lin rub_V = variants {} ; -- L.rub_V2 ;
lin rub_V2 = L.rub_V2 ;
lin rubber_N = mkN "cautxú" masculine | mkN "goma" feminine ; --auto
lin rubble_N = mkN "codolar" masculine ; --auto
lin rubidium_N = mkN "rubidi" masculine ; --auto
lin rucksack_N = mkN "motxilla" feminine ; --auto
lin rudder_N = mkN "timó" masculine ; --auto
lin rude_A = mkA "mal educat" ; --auto
lin rudeness_N = mkN "rudesa" feminine ; --auto
lin rudimentary_A = mkA "rudimentari" ; --auto
lin rue_N = mkN "ruda" feminine ; --auto
lin rugged_A = mkA "abrupte" ; --auto
lin ruin_N = mkN "deteriorament" masculine | mkN "ruïna" feminine ; --auto
lin ruin_V2 = mkV2 "espatllar" ; --auto
lin rule_N = L.rule_N ;
lin rule_V = mkV "governar" ; --auto
lin rule_V2 = mkV2 "governar" ; --auto
lin rule_out_V2 = prepV2 OP_rule_V OP_out_Prep ; -- guess-p-verb
lin ruler_N = mkN "governant" | mkN "regle" masculine ; --auto
lin ruling_A = mkA "governant" ; --auto
lin rum_N = mkN "rom" masculine ; --auto
lin rumble_N = mkN "remor" feminine ; --auto
lin ruminant_A = mkA "remugant" ; --auto
lin ruminant_N = mkN "remugant" masculine ; --auto
lin rumour_N = mkN "rumor" masculine ; --auto
lin rump_N = mkN "anca" feminine ; --auto
lin run_N = mkN "cursa" feminine ;
lin run_V = L.run_V ;
lin run_V2 = mkV2 (mkV "engegar") | mkV2 (verbV (atendre_8 "encendre")) ;
lin run_across_V2 = prepV2 OP_run_V OP_across_Prep ; -- guess-p-verb
lin run_after_V2 = prepV2 OP_run_V OP_after_Prep ; -- guess-p-verb
lin run_against_V2 = prepV2 OP_run_V OP_against_Prep ; -- guess-p-verb
lin run_along_V = advV OP_run_V OP_along_Adv ; -- guess-p-verb
lin run_around_V = advV OP_run_V OP_around_Adv ; -- guess-p-verb
lin run_away_V = advV OP_run_V OP_away_Adv ; -- guess-p-verb
lin run_away_from_V2 = prepV2 (advV OP_run_V OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin run_down_V = advV OP_run_V OP_down_Adv ; -- guess-p-verb
lin run_down_V2 = prepV2 OP_run_V OP_down_Prep ; -- guess-p-verb
lin run_for_V2 = prepV2 OP_run_V OP_for_Prep ; -- guess-p-verb
lin run_in_V = advV OP_run_V OP_in_Adv ; -- guess-p-verb
lin run_in_V2 = prepV2 OP_run_V OP_in_Prep ; -- guess-p-verb
lin run_into_V2 = prepV2 OP_run_V OP_into_Prep ; -- guess-p-verb
lin run_off_V = advV OP_run_V OP_off_Adv ; -- guess-p-verb
lin run_off_V2 = prepV2 OP_run_V OP_off_Prep ; -- guess-p-verb
lin run_on_V2 = prepV2 OP_run_V OP_on_Prep ; -- guess-p-verb
lin run_out_V = advV OP_run_V OP_out_Adv ; -- guess-p-verb
lin run_out_of_V2 = prepV2 (advV OP_run_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin run_over_V = advV OP_run_V OP_over_Adv ; -- guess-p-verb
lin run_over_V2 = prepV2 OP_run_V OP_over_Prep ; -- guess-p-verb
lin run_through_V2 = prepV2 OP_run_V OP_through_Prep ; -- guess-p-verb
lin run_to_V2 = prepV2 OP_run_V OP_to_Prep ; -- guess-p-verb
lin run_up_V = advV OP_run_V OP_up_Adv ; -- guess-p-verb
lin run_up_V2 = prepV2 OP_run_V OP_up_Prep ; -- guess-p-verb
lin run_up_against_V2 = prepV2 (advV OP_run_V OP_up_Adv ) OP_against_Prep ; -- guess-p-verb
lin run_up_on_V2 = prepV2 (advV OP_run_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin run_with_V2 = prepV2 OP_run_V OP_with_Prep ; -- guess-p-verb
lin runic_A = mkA "rúnic" ; --auto
lin runner_N = mkN "corredor" | mkN "corredor" ; --auto
lin running_N = mkN "cursa" feminine ; --auto
lin runtime_N = mkN "temps d'execució" masculine ; --auto
lin rupee_N = mkN "rupia" feminine ; --auto
lin rural_A = mkA "rural" ; --auto
lin rush_N = mkN "pressa" feminine ; --auto
lin rush_V = mkV "afanyar-se" ; --auto
lin rush_away_V = advV OP_rush_V OP_away_Adv ; -- guess-p-verb
lin rush_into_V2 = prepV2 OP_rush_V OP_into_Prep ; -- guess-p-verb
lin rush_off_V = advV OP_rush_V OP_off_Adv ; -- guess-p-verb
lin rush_out_V2 = prepV2 OP_rush_V OP_out_Prep ; -- guess-p-verb
lin russianFem_N = variants {} ;
lin russianMasc_N = variants {} ;
lin russian_A = mkA "rus" ;
lin rust_V = mkV "rovellar" ; --auto
lin rust_V2 = mkV2 "rovellar" ; --auto
lin rut_N = mkN "rodera" feminine ; --auto
lin ruthenium_N = mkN "ruteni" masculine ; --auto
lin ruthless_A = mkA "cruel" ; --auto
lin rutile_N = mkN "rútil" masculine ; --auto
lin rye_N = mkN "sègol" masculine ; --auto
lin sabbath_N = mkN "sàbat" masculine ; --auto
lin sabbatical_A = mkA "sabàtic" ; --auto
lin sabotage_N = mkN "sabotatge" masculine ; --auto
lin saboteurFem_N = variants {} ; ---- sense to be split
lin saboteurMasc_N = variants {} ; ---- sense to be split
lin sabre_N = mkN "sabre" masculine ; --auto
lin saccule_N = mkN "sàcul" masculine ; --auto
lin sacerdotal_A = mkA "sacerdotal" ; --auto
lin sack_N = mkN "sac" masculine ; --auto
lin sack_V2 = mkV2 "acomiadar" ; --auto
lin sacral_A = mkA "sacre" ; --auto
lin sacrament_N = mkN "sagrament" masculine ; --auto
lin sacramental_A = mkA "sacramental" ; --auto
lin sacred_A = mkA "sagrat" ; --auto
lin sacrifice_N = mkN "sacrifici" masculine ; --auto
lin sacrifice_V = mkV "sacrificar" ; --auto
lin sacrifice_V2 = mkV2 "sacrificar" ; --auto
lin sacrilege_N = mkN "sacrilegi" masculine ; --auto
lin sacristy_N = mkN "sagristia" feminine ; --auto
lin sacrosanct_A = mkA "sacrosant" ; --auto
lin sacrum_N = mkN "sacre" masculine ; --auto
lin sad_A = mkA "trist" ; --auto
lin sadden_V = mkV "entristir" ; --auto
lin sadden_V2 = mkV2 "entristir" ; --auto
lin saddle_N = mkN "sella" feminine ; --auto
lin saddler_N = mkN "baster" feminine | mkN "baster" masculine ; --auto
lin sadism_N = mkN "sadisme" masculine ; --auto
lin sadist_N = mkN "sàdic" | mkN "sàdic" ; --auto
lin sadistic_A = mkA "sàdic" ; --auto
lin sadness_N = mkN "tristesa" feminine | mkN "tristor" feminine ; --auto
lin sadomasochism_N = mkN "sadomasoquisme" masculine ; --auto
lin sadomasochistFem_N = variants {} ; ---- sense to be split
lin sadomasochistMasc_N = variants {} ; ---- sense to be split
lin safari_N = mkN "safari" masculine ; --auto
lin safe_A = mkA "segur" ;
lin safeguard_N = mkN "salvaguarda" feminine ; --auto
lin safekeeping_N = mkN "custòdia" feminine ; --auto
lin safety_N = mkN "seguretat" feminine ;
lin safflower_N = mkN "càrtam" masculine ; --auto
lin saga_N = mkN "saga" feminine ; --auto
lin sage_N = mkN "sàlvia" feminine ; --auto
lin sail_N = mkN "aspa" feminine | mkN "vela" feminine ; --auto
lin sail_V = mkV "navegar" ; --auto
lin sail_into_V2 = prepV2 OP_sail_V OP_into_Prep ; -- guess-p-verb
lin sail_through_V2 = prepV2 OP_sail_V OP_through_Prep ; -- guess-p-verb
lin sailboat_N = mkN "veler" masculine ; --auto
lin sailing_N = mkN "navegació" feminine ; --auto
lin sailor_N = mkN "mariner" | mkN "mariner" ; --auto
lin saint_N = mkN "sant" | mkN "sant" ; --auto
lin sake_1_N = variants {} ; ---- sense to be split
lin sake_2_N = variants {} ; ---- sense to be split
lin salad_N = mkN "amanida" feminine ; --auto
lin salaried_A = mkA "assalariat" ; --auto
lin salary_N = mkN "salari" masculine ; --auto
lin sale_N = mkN "venta" feminine ;
lin saline_A = mkA "salí" ; --auto
lin salinity_N = mkN "salinitat" feminine ; --auto
lin saliva_N = mkN "saliva" feminine ; --auto
lin salivary_A = mkA "salival" ; --auto
lin salivate_V = mkV "salivar" ; --auto
lin salivation_N = mkN "salivació" feminine ; --auto
lin salmon_N = mkN "salmó" masculine ; --auto
lin salmonella_N = mkN "salmonel·la" feminine ; --auto
lin salmonellosis_N = mkN "salmonel·losi" feminine ; --auto
lin salt_N = L.salt_N ;
lin saltworks_N = mkN "salina" feminine ; --auto
lin salty_A = mkA "salat" ; --auto
lin salvation_N = mkN "salvació" feminine ; --auto
lin samara_N = mkN "sàmara" feminine ; --auto
lin samarium_N = mkN "samari" masculine ; --auto
lin samoan_A = mkA "samoà" ; --auto
lin sample_N = mkN "mostra" feminine ;
lin sampler_N = mkN "mostrejador" feminine | mkN "mostrejador" masculine ; --auto
lin sampling_N = mkN "mostratge" masculine ; --auto
lin sanatorium_N = mkN "sanatori" masculine ; --auto
lin sanctify_V2 = mkV2 "santificar" ; --auto
lin sanction_N = mkN "sanció" feminine ; --auto
lin sanction_V2 = mkV2 "sancionar" ; --auto
lin sanctuary_N = mkN "santuari" masculine ; --auto
lin sand_N = L.sand_N ;
lin sandal_N = mkN "sàndal" masculine ; --auto
lin sandblast_V2 = mkV2 "sorrejar" ; --auto
lin sandblaster_N = mkN "sorrejador" feminine | mkN "sorrejador" masculine ; --auto
lin sandstone_N = mkN "marès" masculine ; --auto
lin sandwich_N = mkN "sandvitx" masculine ; --auto
lin sandy_A = mkA "sorrenc" ; --auto
lin sanitary_A = mkA "sanitari" ; --auto
lin sap_N = mkN "saba" feminine ; --auto
lin sapling_N = mkN "plançó" masculine ; --auto
lin sapphire_N = mkN "safir" masculine ; --auto
lin sapphirine_N = mkN "safirina" feminine ; --auto
lin saprolite_N = mkN "saprolita" feminine ; --auto
lin sapropel_N = mkN "sapropel" masculine ; --auto
lin saprophagous_A = mkA "sapròfag" ; --auto
lin saprophyte_N = mkN "sapròfit" masculine ; --auto
lin sapwood_N = mkN "albeca" feminine ; --auto
lin sarcasm_N = mkN "sarcasme" masculine ; --auto
lin sarcoidosis_N = mkN "sarcoïdosi" feminine ; --auto
lin sarcolemma_N = mkN "sarcolemma" masculine ; --auto
lin sarcomere_N = mkN "sarcòmer" masculine ; --auto
lin sarcophagus_N = mkN "sarcòfag" masculine ; --auto
lin sarcoplasm_N = mkN "sarcoplasma" masculine ; --auto
lin sarcosome_N = mkN "sarcosoma" masculine ; --auto
lin sardine_N = mkN "sardina" feminine ; --auto
lin satellite_N = mkN "satèl·lit" masculine ; --auto
lin satiate_V2 = mkV2 "sadollar" ; --auto
lin satiety_N = mkN "sacietat" feminine ; --auto
lin satin_N = mkN "setí" masculine ; --auto
lin satire_N = mkN "sàtira" feminine ; --auto
lin satirical_A = mkA "satíric" ; --auto
lin satirist_N = mkN "satíric" feminine | mkN "satíric" masculine ; --auto
lin satisfaction_N = mkN "satisfacció" feminine ; --auto
lin satisfactory_A = mkA "satisfactori" ; --auto
lin satisfied_A = mkA "satisfet" ; --auto
lin satisfy_V2 = mkV2 "satisfer" ; --auto
lin satrap_N = mkN "sàtrapa" feminine ; --auto
lin saturation_N = mkN "saturació" feminine ; --auto
lin satyr_N = mkN "sàtir" masculine ; --auto
lin sauce_N = mkN "salsa" feminine ; --auto
lin saucepan_N = mkN "cassó" masculine ; --auto
lin sauna_N = mkN "sauna" feminine ; --auto
lin saurian_N = mkN "saure" masculine | mkN "sauri" masculine ; --auto
lin sausage_N = mkN "fuet" masculine | mkN "salsitxa" feminine ; --auto
lin savage_N = mkN "salvatge" ; --auto
lin savannah_N = mkN "sabana" feminine ; --auto
lin save_V = mkV "salvar" ; --split "estalviar" (general vs. save money)
lin save_V2 = mkV2 (mkV "save") ; --split ídem as underneath
lin save_on_V2 = prepV2 OP_save_V OP_on_Prep ; -- guess-p-verb
lin save_up_V2 = prepV2 OP_save_V OP_up_Prep ; -- guess-p-verb
lin saver_N = mkN "estalviador" | mkN "estalviador" ; --auto
lin saving_N = mkN "estalvi" masculine ; --auto
lin saw_N = mkN "serra" feminine ; --auto
lin saw_V = mkV "serrar" ; --auto
lin saw_V2 = mkV2 "serrar" ; --auto
lin sawdust_N = mkN "serradís" masculine ; --auto
lin sawmill_N = mkN "serradora" feminine ; --auto
lin saxicolous_A = mkA "saxícola" ; --auto
lin saxon_A = mkA "saxó" ; --auto
lin saxon_N = mkN "saxó" | mkN "saxó" ; --auto
lin saxophone_N = mkN "saxofon" masculine | mkN "saxòfon" masculine ; --auto
lin saxophonist_N = mkN "saxofonista" ; --auto
lin say_V = IrregCat.dir_V ;
lin say_V2 = mkV2 IrregCat.dir_V ;
lin say_VS = L.say_VS ;
lin saying_N = mkN "refrany" masculine ; --auto
lin scab_N = mkN "clapat" masculine | mkN "clivellat" masculine ; --auto
lin scabies_N = mkN "sarna" feminine ; --auto
lin scalar_A = mkA "escalar" ; --auto
lin scale_N = mkN "escala" feminine ;
lin scalene_A = mkA "escalè" ; --auto
lin scalp_N = mkN "cuir" masculine ; --auto
lin scaly_A = mkA "escatós" ; --auto
lin scan_N = mkN "escàner" masculine ; --auto
lin scan_V = mkV "escannejar" ; --auto
lin scan_V2 = mkV2 "escannejar" ; --auto
lin scandal_N = mkN "escàndol" masculine ; --auto
lin scandinavian_A = mkA "escandinau" ; --auto
lin scandinavian_N = mkN "escandinau" | mkN "escandinau" ; --auto
lin scandium_N = mkN "escandi" masculine ; --auto
lin scanner_N = mkN "escàner" masculine | mkN "escànner" masculine ; --auto
lin scanning_N = mkN "escombratge" masculine ; --auto
lin scaphopod_N = mkN "escafòpode" masculine ; --auto
lin scapula_N = mkN "escàpula" feminine ; --auto
lin scar_N = mkN "cicatriu" feminine ; --auto
lin scarce_A = mkA "escàs" ; --auto
lin scare_N = mkN "ensurt" masculine ; --auto
lin scare_V = mkV "espantar" ; --auto
lin scare_V2 = mkV2 "espantar" ; --auto
lin scarecrow_N = mkN "espantaocells" masculine | mkN "espantaocells" masculine ; --auto
lin scarf_N = mkN "bufanda" feminine ; --auto
lin scarlet_A = mkA "escarlata" ; --auto
lin scarlet_N = mkN "escarlata" feminine ; --auto
lin scarp_N = mkN "escarpa" feminine ; --auto
lin scatter_V = mkV "escampar" ; --auto
lin scatter_V2 = mkV2 "escampar" ; --auto
lin scenario_N = mkN "escenari" masculine ; --auto
lin scene_N = mkN "escena" feminine ; --split "escenari" masc (film scene vs. stage)
lin scenery_N = mkN "decorat" masculine ; --auto
lin scenic_A = mkA "escènic" ; --auto
lin scent_N = mkN "fragància" feminine ; --auto
lin scentless_A = mkA "inodor" ; --auto
lin scepter_N = mkN "ceptre" masculine ; --auto
lin sceptic_N = mkN "escèptic" | mkN "escèptic" ; --auto
lin scepticism_N = mkN "escepticisme" masculine ; --auto
lin schedule_N = mkN "horari" masculine | mkN "programa" masculine ; --auto
lin schedule_V = mkV "planificar" ; --auto
lin schedule_V2 = mkV2 "planificar" ; --auto
lin scheelite_N = mkN "scheelita" feminine ; --auto
lin schematic_A = mkA "esquemàtic" ; --auto
lin scheme_N = mkN "pla" masculine ;
lin scheme_V = mkV "maquinar" ; --auto
lin scheme_V2 = mkV2 "maquinar" ; --auto
lin schist_N = mkN "esquist" masculine ; --auto
lin schizophrenic_A = mkA "esquizofrènic" ; --auto
lin schizophrenic_N = mkN "esquizofrènic" | mkN "esquizofrènic" ; --auto
lin scholar_N = mkN "becari" feminine | mkN "becari" masculine | mkN "erudit" feminine | mkN "erudit" masculine ; --auto
lin scholarly_A = mkA "erudit" ; --auto
lin scholarship_N = mkN "beca" feminine ; --auto
lin scholastic_A = mkA "escolàstic" ; --auto
lin scholasticism_N = mkN "escolàstica" feminine ; --auto
lin school_1_N = L.school_N ;
lin school_2_N = L.school_N ;
lin sciatica_N = mkN "ciàtica" feminine ; --auto
lin science_N = L.science_N ;
lin scientific_A = mkA "científic" ; --auto
lin scientist_N = mkN "científic" feminine | mkN "científic" masculine ; --auto
lin scissors_N = mkN "tisores" feminine ; --auto
lin scleroderma_N = mkN "esclerodèrmia" feminine ; --auto
lin sclerometer_N = mkN "escleròmetre" masculine ; --auto
lin scleroprotein_N = mkN "escleroproteïna" feminine ; --auto
lin sclerosis_N = mkN "esclerosi" feminine ; --auto
lin sclerotomy_N = mkN "esclerotomia" feminine ; --auto
lin scolding_N = mkN "reny" masculine ; --auto
lin scoliosis_N = mkN "escoliosi" feminine ; --auto
lin scoop_N = mkN "exclusiva" feminine ; --auto
lin scooter_N = mkN "patinet" masculine ; --auto
lin scope_N = mkN "abast" masculine ; --auto
lin score_N = mkN "partitura" feminine | mkN "puntuació" feminine | mkN "resultat" masculine ; --auto
lin score_V = mkV "marcar" | mkV "puntuar" ; --auto
lin score_V2 = mkV2 "marcar" | mkV2 "puntuar" ; --auto
lin scorer_N = mkN "anotador" feminine | mkN "anotador" masculine ; --auto
lin scornful_A = mkA "menyspreador" ; --auto
lin scorpion_N = mkN "escorpí" masculine ; --auto
lin scotoma_N = mkN "escotoma" masculine ; --auto
lin scottish_A = mkA "escocès" ; --auto
lin scoundrel_N = mkN "pocavergonya" ; --auto
lin scour_N = mkN "soscavació" feminine ; --auto
lin scour_V = mkV "escorcollar" ; --auto
lin scour_V2 = mkV2 "escorcollar" ; --auto
lin scourer_N = mkN "fregall" masculine ; --auto
lin scourge_N = mkN "assot" masculine ; --auto
lin scrap_N = mkN "ferralla" feminine ; --auto
lin scrape_V = mkV "rascar" ; --auto
lin scrape_V2 = mkV2 "rascar" ; --auto
lin scraper_N = mkN "escarpell" masculine | mkN "rascador" masculine | mkN "raspador" masculine ; --auto
lin scratch_N = mkN "rascada" feminine ; --auto
lin scratch_V = variants {} ; -- L.scratch_V2 ;
lin scratch_V2 = L.scratch_V2 ;
lin scream_N = mkN "xiscle" masculine ; --auto
lin scream_V = mkV "xisclar" ; --auto
lin scream_V2 = mkV2 "xisclar" ; --auto
lin scree_N = mkN "tarter" feminine | mkN "tarter" masculine ; --auto
lin screen_N = mkN "pantalla" feminine ; --auto
lin screening_N = mkN "cribratge" masculine | mkN "exploració" feminine ; --auto
lin screw_N = mkN "caragol" masculine | mkN "cargol" masculine | mkN "vis" masculine ; --auto
lin screwdriver_N = mkN "tornavís" masculine ; --auto
lin scribe_N = mkN "escribà" feminine | mkN "escribà" masculine ; --auto
lin scriber_N = mkN "rosset" masculine ; --auto
lin script_1_N = mkN "guió" masculine ; --auto
lin script_2_N = mkN "guió" masculine ; --auto
lin script_3_N = mkN "guió" masculine ; --auto
lin scrotum_N = mkN "escrot" masculine ; --auto
lin scrub_N = mkN "matollar" masculine ; --auto
lin scruple_N = mkN "escrúpol" masculine ; --auto
lin scuffle_N = mkN "batussa" feminine ; --auto
lin sculptor_N = mkN "escultor" | mkN "escultor" ; --auto
lin sculptural_A = mkA "escultòric" ; --auto
lin sculpture_N = mkN "escultura" feminine ; --auto
lin scum_N = mkN "biofilm" masculine ; --auto
lin scupper_N = mkN "embornal" masculine ; --auto
lin sea_N = L.sea_N ;
lin sea_urchin_N = mkN "eriçó de mar" masculine ; --auto
lin seaboard_N = mkN "litoral" masculine ; --auto
lin seafarer_N = mkN "navegant" ; --auto
lin seagull_N = mkN "gavina" feminine ; --auto
lin seal_N = mkN "foca" feminine | mkN "juntura" feminine | mkN "segell" masculine ; --auto
lin seal_V = mkV "segellar" ; --auto
lin seal_V2 = mkV2 "segellar" ; --auto
lin search_N = mkN "cerca" feminine | mkN "escorcoll" masculine | mkN "recerca" feminine ; --auto
lin searcher_N = mkN "cercador" masculine ; --auto
lin seashell_N = mkN "petxina" feminine ; --auto
lin seasickness_N = mkN "mareig" masculine ; --auto
lin season_N = mkN "nota" feminine ; --split (small reminder), "bitllet" masc (bank note), "apunts" (longer class notes)
lin season_V = mkV "condimentar" ; --auto
lin season_V2 = mkV2 "condimentar" ; --auto
lin seasonal_A = mkA "estacional" ; --auto
lin seat_N = mkN "seient" masculine ;
lin seawards_Adv = mkAdv "mar endins" ; --auto
lin sea_water_N = mkN "aigua de mar" feminine ; --auto
lin seaweed_N = mkN "alga" feminine ; --auto
lin seborrhea_N = mkN "seborrea" feminine ; --auto
lin secant_N = mkN "secant" feminine ; --auto
lin secession_N = mkN "secessió" feminine ; --auto
lin secessionism_N = mkN "secessionisme" masculine ; --auto
lin seclusion_N = mkN "reclusió" feminine ; --auto
lin second_N = mkN "segon" masculine ;
lin second_V2 = mkV2 "secundar" ; --auto
lin secondary_A = mkA "secundari" ; --auto
lin secondly_Adv = mkAdv "en segon lloc" ; --auto
lin secrecy_N = mkN "clandestinitat" feminine ; --auto
lin secret_A = mkA "secret" ; --auto
lin secret_N = mkN "secret" masculine ; --auto
lin secretariat_N = mkN "secretariat" masculine ; --auto
lin secretary_N = mkN "secretari" ;
lin secrete_V2 = mkV2 "ocultar" ; --auto
lin secretion_N = mkN "ocultament" masculine ; --auto
lin secretory_A = mkA "secretor" ; --auto
lin sect_N = mkN "secta" feminine ; --auto
lin section_N = mkN "part" masculine | mkN "secció" feminine ;
lin sector_N = mkN "sector" masculine ;
lin sectorial_A = mkA "sectorial" ; --auto
lin secular_A = mkA "secular" ; --auto
lin secure_A = mkA "segur" ; --auto
lin secure_V2 = mkV2 "assegurar" ; --auto
lin security_N = mkN "seguretat" feminine ;
lin sedation_N = mkN "sedació" feminine ; --auto
lin sedative_N = mkN "sedant" masculine ; --auto
lin sedentary_A = mkA "sedentari" ; --auto
lin sediment_N = mkN "sediment" masculine ; --auto
lin sedition_N = mkN "sedició" feminine ; --auto
lin seditious_A = mkA "sediciós" ; --auto
lin seduce_V2 = mkV2 "seduir" ; --auto
lin seducer_N = mkN "seductor" masculine ; --auto
lin seduction_N = mkN "seducció" feminine ; --auto
lin seductive_A = mkA "seductor" ; --auto
lin seductress_N = mkN "seductor" feminine ; --auto
lin see_V = verbV (veure_118 "veure") ; --Discourse marker value: "I see" -> "Sí", "Ho entenc"
lin see_V2 = L.see_V2 ;
lin see_V2V = mkV2V (verbV (veure_118 "veure")) ParadigmsCat.accusative (mkPrep "per") ;
lin see_VQ = mkVQ (verbV (veure_118 "veure")) ;
lin see_VS = mkVS (verbV (veure_118 "veure")) ;
lin see_about_V2 = prepV2 OP_see_V OP_about_Prep ; -- guess-p-verb
lin see_into_V3 = variants {} ; -- guess-p-verb
lin see_off_V2 = prepV2 OP_see_V OP_off_Prep ; -- guess-p-verb
lin see_out_V2 = prepV2 OP_see_V OP_out_Prep ; -- guess-p-verb
lin see_through_V2 = prepV2 OP_see_V OP_through_Prep ; -- guess-p-verb
lin see_to_V2 = prepV2 OP_see_V OP_to_Prep ; -- guess-p-verb
lin seed_N = L.seed_N ;
lin seed_V = mkV "sembrar" ; --auto
lin seed_V2 = mkV2 "sembrar" ; --auto
lin seedbed_N = mkN "sementer" masculine ; --auto
lin seek_V2 = L.seek_V2 ;
lin seek_VV = mkVV (mkV "buscar") ;
lin seek_out_V2 = prepV2 (lin V OP_seek_V2) OP_out_Prep ; -- guess-p-verb
lin seem_VA = mkVA (mkV "semblar") ;
lin seem_VS = mkVS (mkV "semblar") ;
lin seem_VV = mkVV (mkV "semblar") ;
lin seer_N = mkN "vident" ; --auto
lin segment_N = mkN "segment" masculine ; --auto
lin segmentation_N = mkN "segmentació" feminine ; --auto
lin segregation_N = mkN "segregació" feminine ; --auto
lin segregationism_N = mkN "segregacionisme" masculine ; --auto
lin seiche_N = mkN "seixa" feminine ; --auto
lin seismogram_N = mkN "sismograma" masculine ; --auto
lin seismograph_N = mkN "sismògraf" masculine ; --auto
lin seismologist_N = mkN "sismòleg" feminine | mkN "sismòleg" masculine ; --auto
lin seismology_N = mkN "sismologia" feminine ; --auto
lin seize_V = mkV "agafar" | mkV "confiscar" ; --auto
lin seize_V2 = mkV2 "agafar" | mkV2 "confiscar" ; --auto
lin seize_up_V = advV OP_seize_V OP_up_Adv ; -- guess-p-verb
lin seldom_Adv = mkAdv "rarament" ; --auto
lin select_V = mkV "seleccionar" ; --auto
lin select_V2 = mkV2 "seleccionar" ; --auto
lin selection_N = mkN "selecció" feminine ; --auto
lin selective_A = mkA "selectiu" ; --auto
lin selectivity_N = mkN "selectivitat" feminine ; --auto
lin selector_N = mkN "selector" masculine ; --auto
lin selenium_N = mkN "seleni" masculine ; --auto
lin selfishness_N = mkN "egoisme" masculine ; --auto
lin sell_V = verbV (vendre_116 "vendre") ;
lin sell_V2 = mkV2 (verbV (vendre_116 "vendre")) ;
lin sell_back_V = advV OP_sell_V OP_back_Adv ; -- guess-p-verb
lin sell_off_V2 = prepV2 OP_sell_V OP_off_Prep ; -- guess-p-verb
lin sell_on_V2 = prepV2 OP_sell_V OP_on_Prep ; -- guess-p-verb
lin sell_out_V = advV OP_sell_V OP_out_Adv ; -- guess-p-verb
lin sell_out_V2 = prepV2 OP_sell_V OP_out_Prep ; -- guess-p-verb
lin sell_up_V2 = prepV2 OP_sell_V OP_up_Prep ; -- guess-p-verb
lin sellerFem_N = variants {} ; ---- sense to be split
lin sellerMasc_N = variants {} ; ---- sense to be split
lin sellout_N = mkN "exhauriment" masculine ; --auto
lin semantic_A = mkA "semàntic" ; --auto
lin semanticist_N = mkN "semantista" ; --auto
lin semaphore_N = mkN "semàfor" masculine ; --auto
lin semen_N = mkN "semen" masculine ; --auto
lin semester_N = mkN "semestre" masculine ; --auto
lin semiannual_A = mkA "semestral" ; --auto
lin semiaquatic_A = mkA "semiaquàtic" ; --auto
lin semiconductor_N = mkN "semiconductor" masculine ; --auto
lin semi_final_N = mkN "semifinal" feminine ; --auto
lin semifinalist_N = mkN "semifinalista" ; --auto
lin seminal_A = mkA "seminal" ; --auto
lin seminar_N = mkN "seminari" masculine ; --auto
lin seminarist_N = mkN "seminarista" ; --auto
lin semiquaver_N = mkN "semicorxera" feminine ; --auto
lin semitone_N = mkN "semitò" masculine ; --auto
lin semitrailer_N = mkN "semiremolc" masculine ; --auto
lin semolina_N = mkN "sèmola" feminine ; --auto
lin senate_N = mkN "senat" masculine ; --auto
lin senator_N = mkN "senador" | mkN "senador" ; --auto
lin senatorial_A = mkA "senatorial" ; --auto
lin send_V = mkV "enviar" ;
lin send_V2 = mkV2 (mkV "enviar") ;
lin send_V2V = mkV2V (mkV "eviar") ParadigmsCat.accusative ParadigmsCat.dative ;
lin send_back_V2 = mkV2 (advV OP_send_V OP_back_Adv ) ; -- guess-p-verb
lin send_for_V2 = prepV2 OP_send_V OP_for_Prep ; -- guess-p-verb
lin send_in_V = advV OP_send_V OP_in_Adv ; -- guess-p-verb
lin send_in_V2 = prepV2 OP_send_V OP_in_Prep ; -- guess-p-verb
lin send_off_V2 = prepV2 OP_send_V OP_off_Prep ; -- guess-p-verb
lin send_off_for_V2 = prepV2 (advV OP_send_V OP_off_Adv ) OP_for_Prep ; -- guess-p-verb
lin send_out_V2 = prepV2 OP_send_V OP_out_Prep ; -- guess-p-verb
lin send_out_for_V2 = prepV2 (advV OP_send_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin send_up_V2 = prepV2 OP_send_V OP_up_Prep ; -- guess-p-verb
lin sending_N = mkN "enviament" masculine ; --auto
lin senegalese_A = mkA "senegalès" ; --auto
lin seneschal_N = mkN "senescal" masculine ; --auto
lin senior_A = mkA "superior" ;
lin senior_N = mkN "sènior" ; --auto
lin sensationalism_N = mkN "sensacionalisme" masculine ; --auto
lin sense_N = mkN "sensació" feminine ;
lin sense_V2 = mkV2 "notar" ; --auto
lin sensible_A = mkA "sensat" ; --auto
lin sensitive_A = mkA "sensible" ; --auto
lin sensitivity_N = mkN "sensibilitat" feminine ; --auto
lin sensor_N = mkN "sensor" masculine ; --auto
lin sensory_A = mkA "sensorial" ; --auto
lin sensual_A = mkA "sensual" ; --auto
lin sensualism_N = mkN "sensualisme" masculine ; --auto
lin sensualist_N = mkN "sensualista" ; --auto
lin sensuality_N = mkN "sensualitat" feminine ; --auto
lin sentence_N = mkN "oració" feminine ;
lin sentence_V = mkV "sentenciar" ; --auto
lin sentence_V2 = mkV2 "sentenciar" ; --auto
lin sentential_A = mkA "oracional" ; --auto
lin sentimental_A = mkA "sentimental" ; --auto
lin sentimentalism_N = mkN "sentimentalisme" masculine ; --auto
lin sentry_N = mkN "sentinella" ; --auto
lin sepal_N = mkN "sèpal" masculine ; --auto
lin separability_N = mkN "separabilitat" feminine ; --auto
lin separate_A = mkA "separat" ;
lin separate_V = mkV "separar" ; --auto
lin separate_V2 = mkV2 "separar" ; --auto
lin separation_N = mkN "separació" feminine ; --auto
lin sepia_N = mkN "sèpia" feminine ; --auto
lin sepsis_N = mkN "sèpsia" feminine ; --auto
lin septet_N = mkN "septet" masculine ; --auto
lin septic_A = mkA "sèptic" ; --auto
lin septicemia_N = mkN "septicèmia" feminine ; --auto
lin septum_N = mkN "septe" masculine ; --auto
lin sequela_N = mkN "seqüela" feminine ; --auto
lin sequence_N = mkN "seqüència" feminine ; --auto
lin sequencer_N = mkN "seqüenciador" masculine ; --auto
lin sequential_A = mkA "seqüencial" ; --auto
lin sequoia_N = mkN "sequoia" feminine ; --auto
lin serbian_A = mkA "serbi" ; --auto
lin serenade_N = mkN "serenata" feminine ; --auto
lin serenity_N = mkN "serenitat" feminine ; --auto
lin serge_N = mkN "sarja" feminine ; --auto
lin sergeant_N = mkN "sergent" ; --auto
lin serial_N = mkN "serial" masculine ; --auto
lin series_N = L.fire_N ;
lin serious_A = mkA "seriós" ;
lin seriousness_N = mkN "serietat" feminine ; --auto
lin sermon_N = mkN "sermó" masculine ; --auto
lin serology_N = mkN "serologia" feminine ; --auto
lin serotonin_N = mkN "serotonina" feminine ; --auto
lin serum_N = mkN "sèrum" masculine ; --auto
lin servantFem_N = variants {} ; ---- sense to be split
lin servantMasc_N = variants {} ; ---- sense to be split
lin serve_V = mkV (servir_101 "servir") ;
lin serve_V2 = mkV2 (mkV (servir_101 "servir")) ;
lin server_N = mkN "servidor" masculine ; --auto
lin service_N = mkN "servei" masculine ;
lin serviceable_A = mkA "servible" ; --auto
lin servitude_N = mkN "servitud" feminine ; --auto
lin sesame_N = mkN "sèsam" masculine ; --auto
lin session_N = mkN "sessió" feminine ;
lin set_1_N = mkN "col·lecció" masculine ; --split "joc" (collection vs sports set)
lin set_2_N = mkN "col·lecció" masculine ; --split "joc" (collection vs sports set)
lin set_V2 = mkV2 (verbV (servir_101 "definir")) ;
lin set_about_V2 = prepV2 (lin V OP_set_V2) OP_about_Prep ; -- guess-p-verb
lin set_apart_V2 = mkV2 (advV (lin V OP_set_V2) OP_apart_Adv ) ; -- guess-p-verb
lin set_aside_V2 = mkV2 (advV (lin V OP_set_V2) OP_aside_Adv ) ; -- guess-p-verb
lin set_back_V = advV (lin V OP_set_V2) OP_back_Adv ; -- guess-p-verb
lin set_back_V2 = mkV2 (advV (lin V OP_set_V2) OP_back_Adv ) ; -- guess-p-verb
lin set_forth_V = advV (lin V OP_set_V2) OP_forth_Adv ; -- guess-p-verb
lin set_forth_V2 = mkV2 (advV (lin V OP_set_V2) OP_forth_Adv ) ; -- guess-p-verb
lin set_in_V = advV (lin V OP_set_V2) OP_in_Adv ; -- guess-p-verb
lin set_off_V = advV (lin V OP_set_V2) OP_off_Adv ; -- guess-p-verb
lin set_off_V2 = prepV2 (lin V OP_set_V2) OP_off_Prep ; -- guess-p-verb
lin set_on_V2 = prepV2 (lin V OP_set_V2) OP_on_Prep ; -- guess-p-verb
lin set_out_V = advV (lin V OP_set_V2) OP_out_Adv ; -- guess-p-verb
lin set_out_V2 = prepV2 (lin V OP_set_V2) OP_out_Prep ; -- guess-p-verb
lin set_to_V = advV (lin V OP_set_V2) OP_to_Adv ; -- guess-p-verb
lin set_up_V = advV (lin V OP_set_V2) OP_up_Adv ; -- guess-p-verb
lin set_up_V2 = prepV2 (lin V OP_set_V2) OP_up_Prep ; -- guess-p-verb
lin set_upon_V2 = prepV2 (lin V OP_set_V2) OP_upon_Prep ; -- guess-p-verb
lin setscrew_N = mkN "presoner" masculine ; --auto
lin setter_N = mkN "setter" masculine ; --auto
lin setting_N = mkN "enquadrament" masculine | mkN "muntatge" masculine ; --auto
lin settle_V = mkV (absoldre_1 "resoldre") ; --split "calmar-se" (settle a dispute vs. settle down)
lin settle_V2 = mkV2 (mkV (absoldre_1 "resoldre")) ;
lin settle_back_V = advV OP_settle_V OP_back_Adv ; -- guess-p-verb
lin settle_down_V = advV OP_settle_V OP_down_Adv ; -- guess-p-verb
lin settle_for_V2 = prepV2 OP_settle_V OP_for_Prep ; -- guess-p-verb
lin settle_in_V = advV OP_settle_V OP_in_Adv ; -- guess-p-verb
lin settle_on_V2 = prepV2 OP_settle_V OP_on_Prep ; -- guess-p-verb
lin settle_up_V = advV OP_settle_V OP_up_Adv ; -- guess-p-verb
lin settlement_N = mkN "poblament" masculine ; --auto
lin several_Det = mkDet "diversos" ;
lin severe_A = mkA "sever" ; --auto
lin severity_N = mkN "severitat" feminine ; --auto
lin sew_V = mkV "cosir" ; --auto
lin sew_V2 = mkV2 "cosir" ; --auto
lin sewage_N = mkN "aigües residuals" feminine ; --auto
lin sewer_N = mkN "cosidor" masculine ; --auto
lin sewerage_N = mkN "clavegueram" masculine ; --auto
lin sewing_N = mkN "costura" feminine ; --auto
lin sex_1_N = mkN "sexe" masculine ;
lin sex_2_N = mkN "sexe" masculine ;
lin sexagesimal_A = mkA "sexagesimal" ; --auto
lin sexless_A = mkA "asexuat" ; --auto
lin sextant_N = mkN "sextant" masculine ; --auto
lin sextet_N = mkN "sextet" masculine ; --auto
lin sexual_A = mkA "sexual" ;
lin sexuality_N = mkN "sexualitat" feminine ; --auto
lin sexy_A = mkA "sexy" ; --auto
lin shackle_N = mkN "grilló" masculine ; --auto
lin shade_N = mkN "ombra" feminine ; --auto
lin shade_V = mkV "ombrejar" ; --auto
lin shade_V2 = mkV2 "ombrejar" ; --auto
lin shadow_N = mkN "ombra" feminine ; --auto
lin shady_A = mkA "ombrívol" ; --auto
lin shaft_N = mkN "fust" masculine ; --auto
lin shake_N = mkN "sacsejada" feminine ; --auto
lin shake_V = mkV "sacsejar" ;
lin shake_V2 = mkV2 (mkV "sacsejar") ;
lin shake_down_V2 = prepV2 OP_shake_V OP_down_Prep ; -- guess-p-verb
lin shake_off_V2 = prepV2 OP_shake_V OP_off_Prep ; -- guess-p-verb
lin shake_out_V2 = prepV2 OP_shake_V OP_out_Prep ; -- guess-p-verb
lin shake_up_V2 = prepV2 OP_shake_V OP_up_Prep ; -- guess-p-verb
lin shallow_A = mkA "superficial" ; --auto
lin shaman_N = mkN "xaman" masculine ; --auto
lin shamanism_N = mkN "xamanisme" masculine ; --auto
lin shame_N = mkN "pena" feminine | mkN "vergonya" feminine ; --auto
lin shameful_A = mkA "vergonyós" ; --auto
lin shameless_A = mkA "desvergonyit" ; --auto
lin shampoo_N = mkN "xampú" masculine ; --auto
lin shank_N = mkN "cama" feminine ; --auto
lin shantytown_N = mkN "barriada" feminine ; --auto
lin shape_N = mkN "forma" feminine ;
lin shape_up_V = advV OP_shape_V OP_up_Adv ; -- guess-p-verb
lin shapeless_A = mkA "deforme" ; --auto
lin share_N = mkN "acció" feminine ; --split "part" (stock share vs. a part of something)
lin share_V = mkV (servir_101 "compartir") ;
lin share_V2 = mkV2 (mkV (servir_101 "compartir")) ;
lin share_out_V = advV OP_share_V OP_out_Adv ; -- guess-p-verb
lin sharecropper_N = mkN "parcer" feminine | mkN "parcer" masculine ; --auto
lin shareholder_N = mkN "accionista" ; --auto
lin shark_N = mkN "tauró" masculine ; --auto
lin sharp_A = L.sharp_A ;
lin sharpen_V = mkV "aguditzar" ; --auto
lin sharpen_V2 = mkV2 "aguditzar" ; --auto
lin sharpness_N = mkN "agudesa" feminine ; --auto
lin shatter_V = mkV "destrossar" ; --auto
lin shatter_V2 = mkV2 "destrossar" ; --auto
lin shave_V = mkV "afaitar" ; --auto
lin shave_V2 = mkV2 "afaitar" ; --auto
lin shaver_N = mkN "rasquet" masculine ; --auto
lin shawl_N = mkN "xal" masculine ; --auto
lin she_Pron = optProDrop S.she_Pron ;
lin shear_V2 = mkV2 "cisallar" ; --auto
lin shearing_N = mkN "cisallament" masculine ; --auto
lin shears_N = mkN "cisalla" feminine ; --auto
lin shed_N = mkN "cabana" feminine | mkN "rafal" masculine ; --auto
lin shed_V2 = mkV2 "vessar" ; --auto
lin sheep_N = L.sheep_N ;
lin sheet_N = mkN "llençol" masculine ; --split "full" (bed sheets vs. paper sheets)
lin sheik_N = mkN "xeic" masculine ; --auto
lin shelf_N = mkN "lleixa" feminine | mkN "prestatge" masculine ; --auto
lin shell_N = mkN "closca" feminine | mkN "petxina" feminine ; --auto
lin shell_V = mkV "pelar" ; --auto
lin shell_V2 = mkV2 "pelar" ; --auto
lin sheller_N = mkN "esclofolladora" feminine ; --auto
lin shelter_N = mkN "refugi" masculine ; --auto
lin shepherd_N = mkN "pastor" masculine ; --auto
lin shepherdess_N = mkN "pastor" feminine ; --auto
lin sherbet_N = mkN "sorbet" masculine ; --auto
lin sheriff_N = mkN "xèrif" feminine | mkN "xèrif" masculine ; --auto
lin sherry_N = mkN "xerès" masculine ; --auto
lin shield_N = mkN "escut" masculine ; --auto
lin shift_N = mkN "canvi" masculine | mkN "decalatge" masculine | mkN "torn" masculine ; --auto
lin shift_V = mkV "canviar" | mkV "moure" ; --auto
lin shift_V2 = mkV2 "canviar" | mkV2 "moure" ; --auto
lin shilling_N = mkN "xíling" masculine ; --auto
lin shine_N = mkN "brillantor" feminine | mkN "llustre" masculine ; --auto
lin shine_V = mkV "brillar" ; --auto
lin shine_V2 = mkV2 "brillar" ; --auto
lin shinguard_N = mkN "canyellera" feminine ; --auto
lin shiny_A = mkA "lluent" ; --auto
lin ship_N = L.ship_N ;
lin ship_V = mkV "embarcar" ; --auto
lin ship_V2 = mkV2 "embarcar" ; --auto
lin shipowner_N = mkN "navilier" feminine | mkN "navilier" masculine ; --auto
lin shipping_N = mkN "navili" masculine ; --auto
lin shipwreck_N = mkN "naufragi" masculine ; --auto
lin shirt_N = L.shirt_N ;
lin shit_N = mkN "merda" feminine ; --auto
lin shit_V = mkV "cagar" ; --auto
lin shiver_N = mkN "calfred" masculine ; --auto
lin shiver_V = mkV "tremolar" ; --auto
lin shock_N = mkN "commoció" feminine | mkN "xoc" masculine ; --auto
lin shock_V2 = mkV2 "impressionar" ; --auto
lin shocking_A = mkA "impressionant" ; --auto
lin shoddy_A = mkA "matusser" ; --auto
lin shoe_N = L.shoe_N ;
lin shoe_V2 = mkV2 "calçar" ; --auto
lin shoehorn_N = mkN "calçador" masculine ; --auto
lin shoemaker_N = mkN "sabater" | mkN "sabater" ; --auto
lin shoot_N = mkN "brot" masculine ; --auto
lin shoot_V = mkV "disparar" ;
lin shoot_V2 = mkV2 (mkV "disparar") ;
lin shoot_away_V = advV OP_shoot_V OP_away_Adv ; -- guess-p-verb
lin shoot_back_V = advV OP_shoot_V OP_back_Adv ; -- guess-p-verb
lin shoot_for_V2 = prepV2 OP_shoot_V OP_for_Prep ; -- guess-p-verb
lin shoot_off_V = advV OP_shoot_V OP_off_Adv ; -- guess-p-verb
lin shoot_out_V = advV OP_shoot_V OP_out_Adv ; -- guess-p-verb
lin shoot_up_V = advV OP_shoot_V OP_up_Adv ; -- guess-p-verb
lin shoot_up_V2 = prepV2 OP_shoot_V OP_up_Prep ; -- guess-p-verb
lin shooting_N = mkN "afusellament" masculine | mkN "tiroteig" masculine ; --auto
lin shop_N = L.shop_N ;
lin shopperFem_N = variants {} ; ---- sense to be split
lin shopperMasc_N = variants {} ; ---- sense to be split
lin shopping_N = mkN "compra" feminine ; --auto
lin shore_N = mkN "riba" feminine ; --auto
lin short_A = L.short_A ;
lin shortage_N = mkN "escassetat" feminine ; --auto
lin shortcut_N = mkN "drecera" feminine ; --auto
lin shorten_V = mkV "escurçar" ; --auto
lin shorten_V2 = mkV2 "escurçar" ; --auto
lin shortening_N = mkN "abreujament" masculine | mkN "escurçament" masculine ; --auto
lin shorthand_N = mkN "taquigrafia" feminine ; --auto
lin shortness_N = mkN "brevetat" feminine ; --auto
lin shortstop_N = mkN "interbase" masculine ; --auto
lin shot_N = mkN "tir" masculine | mkN "tret" masculine ; --auto
lin shotgun_N = mkN "escopeta" feminine ; --auto
lin shoulder_N = mkN "espatlla" feminine ;
lin shout_N = mkN "crit" masculine ; --auto
lin shout_V = mkV "cridar" ; --auto
lin shout_V2 = mkV2 "cridar" ; --auto
lin shout_down_V2 = prepV2 OP_shout_V OP_down_Prep ; -- guess-p-verb
lin shout_out_V2 = prepV2 OP_shout_V OP_out_Prep ; -- guess-p-verb
lin show_N = mkN "espectacle" masculine ;
lin show_V = mkV "ensenyar" ;
lin show_V2 = mkV2 (mkV "ensenyar") ;
lin show_VQ = mkVQ (mkV "ensenyar") ;
lin show_VS = mkVS (mkV "ensenyar") ;
lin show_around_V2 = prepV2 OP_show_V OP_around_Prep ; -- guess-p-verb
lin show_in_V2 = prepV2 OP_show_V OP_in_Prep ; -- guess-p-verb
lin show_off_V = advV OP_show_V OP_off_Adv ; -- guess-p-verb
lin show_off_V2 = prepV2 OP_show_V OP_off_Prep ; -- guess-p-verb
lin show_out_V2 = prepV2 OP_show_V OP_out_Prep ; -- guess-p-verb
lin show_over_V3 = variants {} ; -- guess-p-verb
lin show_round_V2 = prepV2 OP_show_V OP_round_Prep ; -- guess-p-verb
lin show_through_V = advV OP_show_V OP_through_Adv ; -- guess-p-verb
lin show_up_V = advV OP_show_V OP_up_Adv ; -- guess-p-verb
lin show_up_V2 = prepV2 OP_show_V OP_up_Prep ; -- guess-p-verb
lin shower_N = mkN "dutxa" feminine | mkN "xàfec" masculine ; --auto
lin shower_V = mkV "ploure" ; --auto
lin shower_V2 = mkV2 "ploure" ; --auto
lin showy_A = mkA "vistós" ; --auto
lin shrapnel_N = mkN "metralla" feminine ; --auto
lin shredder_N = mkN "trituradora" feminine ; --auto
lin shrew_N = mkN "musaranya" feminine ; --auto
lin shrewd_A = mkA "perspicaç" ; --auto
lin shrewdness_N = mkN "sagacitat" feminine ; --auto
lin shrimp_N = mkN "gamba" feminine ; --auto
lin shrink_V = mkV "encongir" ; --auto
lin shrink_V2 = mkV2 "encongir" ; --auto
lin shrinkage_N = mkN "encongiment" masculine ; --auto
lin shrinking_N = mkN "retrocés" masculine ; --auto
lin shrug_off_V2 = prepV2 (lin V OP_shrug_V2) OP_off_Prep ; -- guess-p-verb
lin shudder_N = mkN "estremiment" masculine ; --auto
lin shudder_V = mkV "estremir-se" ; --auto
lin shun_V2 = mkV2 "defugir" ; --auto
lin shunt_N = mkN "xunt" masculine ; --auto
lin shut_V2 = mkV2 "tancar" ; --auto
lin shut_away_V2 = mkV2 (advV (lin V OP_shut_V2) OP_away_Adv ) ; -- guess-p-verb
lin shut_down_V2 = prepV2 (lin V OP_shut_V2) OP_down_Prep ; -- guess-p-verb
lin shut_in_V2 = prepV2 (lin V OP_shut_V2) OP_in_Prep ; -- guess-p-verb
lin shut_off_V = advV (lin V OP_shut_V2) OP_off_Adv ; -- guess-p-verb
lin shut_off_V2 = prepV2 (lin V OP_shut_V2) OP_off_Prep ; -- guess-p-verb
lin shut_out_V2 = prepV2 (lin V OP_shut_V2) OP_out_Prep ; -- guess-p-verb
lin shut_out_of_V2 = prepV2 (advV (lin V OP_shut_V2) OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin shut_up_V2 = prepV2 (lin V OP_shut_V2) OP_up_Prep ; -- guess-p-verb
lin shut_yourself_away_V = variants {} ; -- guess-p-verb
lin shutter_N = mkN "finestró" masculine ; --auto
lin shy_A = mkA "tímid" ; --auto
lin sialolith_N = mkN "sialòlit" masculine ; --auto
lin siamese_A = mkA "siamès" ; --auto
lin siberian_A = mkA "siberià" ; --auto
lin sibilant_A = mkA "sibilant" ; --auto
lin sic_Adv = mkAdv "sic" ; --auto
lin sick_A = mkA "malalt" ; --auto
lin side_N = mkN "costat" masculine ;
lin sideboard_N = mkN "trinxant" masculine ; --auto
lin sidecar_N = mkN "sidecar" masculine ; --auto
lin siderite_N = mkN "siderita" feminine ; --auto
lin siderocyte_N = mkN "sideròcit" masculine ; --auto
lin siderosis_N = mkN "siderosi" feminine ; --auto
lin sidewalk_N = mkN "vorera" feminine ; --auto
lin sidewards_Adv = mkAdv "de costat" ; --auto
lin sideways_Adv = mkAdv "de costat" ; --auto
lin siding_N = mkN "apartador" masculine ; --auto
lin siege_N = mkN "setge" masculine ; --auto
lin sieve_N = mkN "garbell" masculine ; --auto
lin sieve_V2 = mkV2 "garbellar" ; --auto
lin sift_V = mkV "garbellar" ; --auto
lin sift_V2 = mkV2 "garbellar" ; --auto
lin sigh_N = mkN "sospir" masculine ; --auto
lin sigh_V = mkV "sospirar" ; --auto
lin sigh_V2 = mkV2 "sospirar" ; --auto
lin sight_N = mkN "vista" feminine ;
lin sign_N = mkN "senyal" masculine ;
lin sign_V = mkV "signar" ;
lin sign_V2 = mkV2 (mkV "signar") ;
lin sign_away_V2 = mkV2 (advV OP_sign_V OP_away_Adv ) ; -- guess-p-verb
lin sign_for_V3 = variants {} ; -- guess-p-verb
lin sign_in_V = advV OP_sign_V OP_in_Adv ; -- guess-p-verb
lin sign_in_V2 = prepV2 OP_sign_V OP_in_Prep ; -- guess-p-verb
lin sign_into_V2 = prepV2 OP_sign_V OP_into_Prep ; -- guess-p-verb
lin sign_off_V = advV OP_sign_V OP_off_Adv ; -- guess-p-verb
lin sign_off_V2 = prepV2 OP_sign_V OP_off_Prep ; -- guess-p-verb
lin sign_off_on_V2 = prepV2 (advV OP_sign_V OP_off_Adv ) OP_on_Prep ; -- guess-p-verb
lin sign_on_V = advV OP_sign_V OP_on_Adv ; -- guess-p-verb
lin sign_on_V2 = prepV2 OP_sign_V OP_on_Prep ; -- guess-p-verb
lin sign_on_with_V2 = prepV2 (advV OP_sign_V OP_on_Adv ) OP_with_Prep ; -- guess-p-verb
lin sign_out_V = advV OP_sign_V OP_out_Adv ; -- guess-p-verb
lin sign_out_V2 = prepV2 OP_sign_V OP_out_Prep ; -- guess-p-verb
lin sign_out_of_V2 = prepV2 (advV OP_sign_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin sign_up_V = advV OP_sign_V OP_up_Adv ; -- guess-p-verb
lin sign_with_V2 = prepV2 OP_sign_V OP_with_Prep ; -- guess-p-verb
lin signal_N = mkN "senyal" masculine ; --auto
lin signal_V2 = mkV2 "assenyalar" ; --auto
lin signature_N = mkN "signatura" feminine ; --auto
lin significance_N = mkN "importància" feminine ; --auto
lin significant_A = mkA "signifinicant" ;
lin signpost_N = mkN "panell" masculine ; --auto
lin silence_N = mkN "silenci" masculine ; --auto
lin silent_A = mkA "silenciós" ; --auto
lin silhouette_N = mkN "silueta" feminine ; --auto
lin silica_N = mkN "sílice" masculine ; --auto
lin silicate_N = mkN "silicat" masculine ; --auto
lin silicon_N = mkN "silici" masculine ; --auto
lin silicone_N = mkN "silicona" feminine ; --auto
lin silicosis_N = mkN "silicosi" feminine ; --auto
lin silk_N = mkN "seda" feminine ; --auto
lin silly_A = mkA "ximple" ; --auto
lin silt_N = mkN "llim" masculine ; --auto
lin silty_A = mkA "llimós" ; --auto
lin silver_N = L.silver_N ;
lin silverware_N = mkN "cobert" masculine ; --auto
lin similar_A = mkA "semblant" ;
lin similarity_N = mkN "semblança" feminine ; --auto
lin simile_N = mkN "símil" masculine ; --auto
lin simony_N = mkN "simonia" feminine ; --auto
lin simple_A = mkA "senzill" ;
lin simpleton_N = mkN "capsigrany" masculine ; --auto
lin simplicity_N = mkN "simplicitat" feminine ; --auto
lin simplification_N = mkN "simplificació" feminine ; --auto
lin simplify_V = mkV "simplificar" ; --auto
lin simplify_V2 = mkV2 "simplificar" ; --auto
lin simulate_V2 = mkV2 "simular" ; --auto
lin simulation_N = mkN "simulacre" masculine ; --auto
lin simulator_N = mkN "simulador" masculine ; --auto
lin simultaneity_N = mkN "simultaneïtat" feminine ; --auto
lin simultaneous_A = mkA "simultani" ; --auto
lin sin_N = mkN "pecat" masculine ; --auto
lin sin_V = mkV "pecar" ; --auto
lin since_Adv = mkAdv "de llavors ençà" ; --auto
lin since_Prep = mkPrep "des de" ;
lin since_Subj = mkSubj "des que" Indic ;
lin since_then_Adv = mkAdv "d'aleshores ençà" | mkAdv "des de llavors" ; --auto
lin sincere_A = mkA "sincer" ; --auto
lin sincerity_N = mkN "sinceritat" feminine ; --auto
lin sine_N = mkN "sinus" masculine | mkN "sinus" masculine ; --auto
lin sine_die_Adv = mkAdv "sine die" ; --auto
lin sinew_N = mkN "tendó" masculine ; --auto
lin sing_V = L.sing_V ;
lin sing_V2 = mkV2 "cantar" ;
lin sing_along_V = advV OP_sing_V OP_along_Adv ; -- guess-p-verb
lin sing_out_V = advV OP_sing_V OP_out_Adv ; -- guess-p-verb
lin sing_up_V = advV OP_sing_V OP_up_Adv ; -- guess-p-verb
lin singaporeanFem_N = variants {} ; ---- sense to be split
lin singaporeanMasc_N = variants {} ; ---- sense to be split
lin singer_N = mkN "cantant" ; --auto
lin singing_N = mkN "cant" masculine ; --auto
lin single_1_A = mkA "únic" ; --split "solter" (only one vs not dating anyone)
lin single_2_A = mkA "únic" ; --split "solter" (only one vs not dating anyone)
lin singlet_N = mkN "singlet" masculine ; --auto
lin singular_A = mkA "singular" ; --auto
lin singular_N = mkN "singular" masculine ; --auto
lin singularity_N = mkN "singularitat" feminine ; --auto
lin sinister_A = mkA "sinistre" ; --auto
lin sink_V = mkV "enfonsar-se" ; --auto
lin sink_in_V = advV OP_sink_V OP_in_Adv ; -- guess-p-verb
lin sinkhole_N = mkN "bòfia" feminine ; --auto
lin sinking_N = mkN "enfonsament" masculine ; --auto
lin sinner_N = mkN "pecador" | mkN "pecador" ; --auto
lin sinus_N = mkN "si" masculine ; --auto
lin sinusoid_N = mkN "sinusoide" masculine ; --auto
lin sinusoidal_A = mkA "sinusoïdal" ; --auto
lin sip_N = mkN "xarrup" masculine ; --auto
lin sir_N = mkN "senyor" masculine ;
lin sirocco_N = mkN "xaloc" masculine ; --auto
lin sisal_N = mkN "sisal" masculine ; --auto
lin sister_N = L.sister_N ;
lin sit_V = L.sit_V ;
lin sit_V2 = mkV2 (verbV (seure_102 "seure")) ;
lin sit_about_V = advV OP_sit_V OP_about_Adv ; -- guess-p-verb
lin sit_around_V = advV OP_sit_V OP_around_Adv ; -- guess-p-verb
lin sit_back_V = advV OP_sit_V OP_back_Adv ; -- guess-p-verb
lin sit_by_V = advV OP_sit_V OP_by_Adv ; -- guess-p-verb
lin sit_down_V2 = prepV2 OP_sit_V OP_down_Prep ; -- guess-p-verb
lin sit_for_V2 = prepV2 OP_sit_V OP_for_Prep ; -- guess-p-verb
lin sit_in_V2 = prepV2 OP_sit_V OP_in_Prep ; -- guess-p-verb
lin sit_in_for_V2 = prepV2 (advV OP_sit_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin sit_in_on_V2 = prepV2 (advV OP_sit_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin sit_on_V2 = prepV2 OP_sit_V OP_on_Prep ; -- guess-p-verb
lin sit_out_V2 = prepV2 OP_sit_V OP_out_Prep ; -- guess-p-verb
lin sit_over_V2 = prepV2 OP_sit_V OP_over_Prep ; -- guess-p-verb
lin sit_through_V2 = prepV2 OP_sit_V OP_through_Prep ; -- guess-p-verb
lin sit_up_V = advV OP_sit_V OP_up_Adv ; -- guess-p-verb
lin sit_with_V2 = prepV2 OP_sit_V OP_with_Prep ; -- guess-p-verb
lin site_N = mkN "lloc" masculine ;
lin situate_V2 = mkV2 "situar" ; --auto
lin situation_N = mkN "situació" feminine ;
lin size_N = mkN "mida" feminine ;
lin skate_V = mkV "patinar" ; --auto
lin skateboard_N = mkN "monopatí" masculine ; --auto
lin skater_N = mkN "patinador" | mkN "patinador" ; --auto
lin skating_N = mkN "patinatge" masculine ; --auto
lin skeletal_A = mkA "esquelètic" ; --auto
lin skeleton_N = mkN "esquelet" masculine ; --auto
lin skeptical_A = mkA "escèptic" ; --auto
lin sketch_N = mkN "croquis" masculine | mkN "esquetx" masculine | mkN "croquis" masculine ; --auto
lin skew_A = mkA "torcejat" ; --auto
lin skew_V2 = mkV2 "esbiaixar" ; --auto
lin skewer_N = mkN "ast" masculine ; --auto
lin ski_N = mkN "esquí" masculine ; --auto
lin skid_N = mkN "patinada" feminine ; --auto
lin skier_N = mkN "esquiador" | mkN "esquiador" ; --auto
lin skiff_N = mkN "esquif" masculine ; --auto
lin skill_N = mkN "habilitat" feminine ;
lin skilled_A = mkA "especialitzat" ; --auto
lin skillful_A = mkA "hàbil" ; --auto
lin skimmer_N = mkN "escumadora" feminine ; --auto
lin skin_N = L.skin_N ;
lin skinny_A = mkA "magre" ; --auto
lin skirt_N = mkN "faldilla" feminine ; --auto
lin skittle_N = mkN "bitlla" feminine ; --auto
lin skull_N = mkN "crani" masculine ; --auto
lin sky_N = L.sky_N ;
lin skyscraper_N = mkN "gratacel" masculine ; --auto
lin skyward_Adv = mkAdv "cap al cel" ; --auto
lin skywards_Adv = mkAdv "cap al cel" ; --auto
lin slacken_V = mkV "afluixar" ; --auto
lin slacken_V2 = mkV2 "afluixar" ; --auto
lin slalom_N = mkN "eslàlom" masculine ; --auto
lin slam_N = mkN "rematada" feminine ; --auto
lin slam_V = mkV "tancar de colp" | mkV "tancar de cop" ; --auto
lin slanderer_N = mkN "difamador" | mkN "difamador" ; --auto
lin slang_N = mkN "argot" masculine ; --auto
lin slap_N = mkN "bufetada" feminine ; --auto
lin slat_N = mkN "llistó" masculine ; --auto
lin slaughterhouse_N = mkN "escorxador" masculine ; --auto
lin slave_N = mkN "esclau" | mkN "esclau" ; --auto
lin slavery_N = mkN "esclavitud" feminine ; --auto
lin sled_N = mkN "trineu" masculine ; --auto
lin sleep_N = mkN "son" masculine ; --auto
lin sleep_V = L.sleep_V ;
lin sleep_in_V = advV OP_sleep_V OP_in_Adv ; -- guess-p-verb
lin sleep_off_V2 = prepV2 OP_sleep_V OP_off_Prep ; -- guess-p-verb
lin sleep_on_V2 = prepV2 OP_sleep_V OP_on_Prep ; -- guess-p-verb
lin sleep_over_V = advV OP_sleep_V OP_over_Adv ; -- guess-p-verb
lin sleep_through_V2 = prepV2 OP_sleep_V OP_through_Prep ; -- guess-p-verb
lin sleepless_A = mkA "insomne" ; --auto
lin sleeplessness_N = mkN "insomni" masculine ; --auto
lin sleet_N = mkN "aiguaneu" masculine ; --auto
lin sleeve_N = mkN "funda" feminine | mkN "màniga" feminine | mkN "maniguet" masculine ; --auto
lin sleeved_A = mkA "manigut" ; --auto
lin slice_N = mkN "tall" masculine ; --auto
lin slide_N = mkN "portaobjectes" masculine | mkN "portaobjectes" masculine ; --auto
lin slider_N = mkN "colissa" feminine ; --auto
lin slight_A = mkA "lleu" ; --auto
lin slim_A = mkA "esvelt" ; --auto
lin slime_N = mkN "llot" masculine ; --auto
lin sling_1_N = mkN "cabestrell" masculine ; --auto
lin sling_2_N = mkN "cabestrell" masculine ; --auto
lin sling_V = mkV "llançar" ; --auto
lin sling_V2 = mkV2 "llançar" ; --auto
lin slip_N = mkN "eslip" masculine ; --auto
lin slip_V = mkV "esmunyir-se" | mkV "relliscar" ; --auto
lin slip_away_V = advV OP_slip_V OP_away_Adv ; -- guess-p-verb
lin slip_by_V = advV OP_slip_V OP_by_Adv ; -- guess-p-verb
lin slip_down_V = advV OP_slip_V OP_down_Adv ; -- guess-p-verb
lin slip_in_V2 = prepV2 OP_slip_V OP_in_Prep ; -- guess-p-verb
lin slip_into_V2 = prepV2 OP_slip_V OP_into_Prep ; -- guess-p-verb
lin slip_off_V = advV OP_slip_V OP_off_Adv ; -- guess-p-verb
lin slip_off_V2 = prepV2 OP_slip_V OP_off_Prep ; -- guess-p-verb
lin slip_off_to_V2 = prepV2 (advV OP_slip_V OP_off_Adv ) OP_to_Prep ; -- guess-p-verb
lin slip_on_V2 = prepV2 OP_slip_V OP_on_Prep ; -- guess-p-verb
lin slip_out_V = advV OP_slip_V OP_out_Adv ; -- guess-p-verb
lin slip_up_V = advV OP_slip_V OP_up_Adv ; -- guess-p-verb
lin slippery_A = mkA "relliscós" ; --auto
lin slipway_N = mkN "escar" masculine ; --auto
lin slogan_N = mkN "eslògan" masculine ; --auto
lin slope_N = mkN "baixada" feminine | mkN "pendent" masculine | mkN "pujada" feminine | mkN "vessant" masculine ; --auto
lin slow_A = mkA "lent" ; --auto
lin slow_Adv = mkAdv "a poc a poc" ; --auto
lin slow_V = mkV "alentir" ; --auto
lin slow_V2 = mkV2 "alentir" ; --auto
lin slowness_N = mkN "lentitud" feminine ; --auto
lin slug_N = mkN "llimac" masculine ; --auto
lin slum_N = mkN "tuguri" masculine ; --auto
lin slump_N = mkN "recessió" feminine ; --auto
lin slurry_N = mkN "beurada" feminine ; --auto
lin slyness_N = mkN "astúcia" feminine ; --auto
lin small_A = L.small_A ;
lin smart_A = mkA "llest" ; --auto
lin smash_N = mkN "xoc" masculine ; --auto
lin smash_V = mkV "estavellar-se" | mkV "trencar" ; --auto
lin smear_N = mkN "frotis" masculine | mkN "frotis" masculine ; --auto
lin smell_N = mkN "olfacte" masculine | mkN "olor" feminine ; --auto
lin smell_V = L.smell_V ;
lin smell_V2 = variants {} ; -- L.smell_V ;
lin smell_VA = variants {} ; -- L.smell_V ;
lin smelter_N = mkN "fonedor" feminine | mkN "fonedor" masculine ; --auto
lin smile_N = mkN "somriure" masculine ;
lin smile_V = mkV (escriure_50 "somriure") ;
lin smith_N = mkN "ferrer" feminine | mkN "ferrer" masculine ; --auto
lin smog_N = mkN "boirum" masculine ; --auto
lin smoke_N = L.smoke_N ;
lin smoke_V = mkV "fumar" ; --auto
lin smoke_V2 = mkV2 "fumar" ; --auto
lin smoke_out_V2 = prepV2 OP_smoke_V OP_out_Prep ; -- guess-p-verb
lin smoker_N = mkN "fumador" | mkN "fumador" ; --auto
lin smokestack_N = mkN "xemeneia" feminine ; --auto
lin smooth_A = L.smooth_A ;
lin smooth_V = mkV "suavitzar" ; --auto
lin smooth_V2 = mkV2 "suavitzar" ; --auto
lin smuggler_N = mkN "contrabandista" ; --auto
lin smuggling_N = mkN "contraban" masculine ; --auto
lin snack_N = mkN "mos" masculine | mkN "mos" masculine ; --auto
lin snail_N = mkN "caragol" masculine | mkN "cargol" masculine ; --auto
lin snake_N = L.snake_N ;
lin snap_V = mkV "espetegar" | mkV "trencar-se" ; --auto
lin snap_back_V = advV OP_snap_V OP_back_Adv ; -- guess-p-verb
lin snap_off_V2 = prepV2 OP_snap_V OP_off_Prep ; -- guess-p-verb
lin snap_out_of_V2 = prepV2 (advV OP_snap_V OP_out_Adv ) OP_of_Prep ; -- guess-p-verb
lin snap_to_it_V2 = variants {} ; -- guess-p-verb
lin snap_up_V2 = prepV2 OP_snap_V OP_up_Prep ; -- guess-p-verb
lin snatch_V = mkV "arrabassar" ; --auto
lin snatch_V2 = mkV2 "arrabassar" ; --auto
lin sneeze_N = mkN "esternut" masculine ; --auto
lin sniff_V = mkV "ensumar" ; --auto
lin sniff_V2 = mkV2 "ensumar" ; --auto
lin sniper_N = mkN "franctirador" | mkN "franctirador" ; --auto
lin snob_N = mkN "esnob" masculine ; --auto
lin snore_N = mkN "ronc" masculine ; --auto
lin snort_V = mkV "esbufegar" ; --auto
lin snort_V2 = mkV2 "esbufegar" ; --auto
lin snout_N = mkN "musell" masculine ; --auto
lin snow_N = L.snow_N ;
lin snowman_N = mkN "ninot de neu" masculine ; --auto
lin so_Adv = mkAdv "tan" ;
lin so_Subj = mkSubj "així que" Indic ;
lin soak_V = mkV "remullar" ; --auto
lin soak_V2 = mkV2 "remullar" ; --auto
lin soap_N = mkN "sabó" masculine ; --auto
lin soapy_A = mkA "sabonós" ; --auto
lin sober_A = mkA "serè" ; --auto
lin sobriety_N = mkN "sobrietat" feminine ; --auto
lin sociable_A = mkA "sociable" ; --auto
lin social_A = mkA "social" ;
lin socialism_N = mkN "socialisme" masculine ; --auto
lin socialist_A = mkA "socialista" ; --auto
lin socialist_N = mkN "socialista" ; --auto
lin society_N = mkN "societat" feminine ;
lin sociobiology_N = mkN "sociobiologia" feminine ; --auto
lin socioeconomic_A = mkA "socioeconòmic" ; --auto
lin sociolinguist_N = mkN "sociolingüista" ; --auto
lin sociolinguistic_A = mkA "sociolingüístic" ; --auto
lin sociolinguistics_N = mkN "sociolingüística" feminine ; --auto
lin sociological_A = mkA "sociològic" ; --auto
lin sociologist_N = mkN "sociòleg" | mkN "sociòleg" ; --auto
lin sociology_N = mkN "sociologia" feminine ; --auto
lin sociometry_N = mkN "sociometria" feminine ; --auto
lin sock_N = L.sock_N ;
lin socket_N = mkN "casquet" masculine ; --auto
lin socratic_A = mkA "socràtic" ; --auto
lin soda_N = mkN "refresc" masculine ; --auto
lin sodalite_N = mkN "sodalita" feminine ; --auto
lin sodium_N = mkN "sodi" masculine ; --auto
lin sofa_N = mkN "sofà" masculine ; --auto
lin soft_A = mkA "tou" ;
lin soften_V = mkV "estovar" | mkV "suavitzar" ; --auto
lin soften_V2 = mkV2 "estovar" | mkV2 "suavitzar" ; --auto
lin softness_N = mkN "suavitat" feminine ; --auto
lin software_N = mkN "programari" masculine ;
lin soil_N = mkN "sòl" masculine | mkN "terra" masculine ; --auto
lin soiree_N = mkN "vetlada" feminine | mkN "vetllada" feminine ; --auto
lin solar_A = mkA "solar" ; --auto
lin solder_V2 = mkV2 "soldar" ; --auto
lin soldier_N = mkN "soldat" ; --auto
lin sole_A = mkA "únic" ; --auto
lin sole_N = mkN "llenguado" masculine | mkN "sola" feminine ; --auto
lin solecism_N = mkN "solecisme" masculine ; --auto
lin solemn_A = mkA "solemne" ; --auto
lin solenoid_N = mkN "solenoide" masculine ; --auto
lin solicit_V = mkV "sol·licitar" ; --auto
lin solicit_V2 = mkV2 "sol·licitar" ; --auto
lin solicitorFem_N = variants {} ; ---- sense to be split
lin solicitorMasc_N = variants {} ; ---- sense to be split
lin solid_A = mkA "sòlid" ; --auto
lin solid_N = mkN "sòlid" masculine ; --auto
lin solidarity_N = mkN "solidaritat" feminine ; --auto
lin solidification_N = mkN "solidificació" feminine ; --auto
lin solidify_V = mkV "solidificar" ; --auto
lin solidify_V2 = mkV2 "solidificar" ; --auto
lin solitaire_N = mkN "solitari" masculine ; --auto
lin solitary_A = mkA "solitari" ; --auto
lin solitude_N = mkN "solitud" feminine ; --auto
lin solo_N = mkN "solo" masculine ; --auto
lin soloist_N = mkN "solista" ; --auto
lin solstice_N = mkN "solstici" masculine ; --auto
lin solubility_N = mkN "solubilitat" feminine ; --auto
lin soluble_A = mkA "soluble" ; --auto
lin solute_N = mkN "solut" masculine ; --auto
lin solution_1_N = mkN "sol·lució" feminine ;
lin solution_2_N = mkN "sol·lució" feminine ;
lin solvable_A = mkA "resoluble" | mkA "solucionable" ; --auto
lin solvation_N = mkN "solvatació" feminine ; --auto
lin solve_V2 = mkV2 "solucionar" ; --auto
lin solvent_A = mkA "solvent" ; --auto
lin solvent_N = mkN "solvent" masculine ; --auto
lin soma_N = mkN "soma" masculine ; --auto
lin somaliFem_N = variants {} ; ---- sense to be split
lin somaliMasc_N = variants {} ; ---- sense to be split
lin somali_A = mkA "somali" ; --auto
lin somalianFem_N = variants {} ; ---- sense to be split
lin somalianMasc_N = variants {} ; ---- sense to be split
lin somebody_NP = S.somebody_NP ;
lin somehow_AdV = mkAdv "d'alguna manera" ; --auto
lin somehow_Adv = mkAdv "d'alguna manera" ; --auto
lin someplace_Adv = mkAdv "en algun lloc" ; --auto
lin somersault_N = mkN "tombarella" feminine ; --auto
lin something_NP = S.something_NP ;
lin sometime_Adv = mkAdv "alguna vegada" | mkAdv "algun cop" ; --auto
lin sometimes_Adv = mkAdv "a vegades" ;
lin somewhat_Adv = mkAdv "una mica" ; --auto
lin somewhere_Adv = S.somewhere_Adv ;
lin somnambulism_N = mkN "somnambulisme" masculine ; --auto
lin son_N = mkN "fill" ;
lin sonar_N = mkN "sonar" masculine ; --auto
lin sonata_N = mkN "sonata" feminine ; --auto
lin song_N = L.song_N ;
lin songwriter_N = mkN "compositor" ; --auto
lin sonic_A = mkA "sònic" ; --auto
lin sonnet_N = mkN "sonet" masculine ; --auto
lin sonneteer_N = mkN "sonetista" ; --auto
lin sonogram_N = mkN "sonograma" masculine ; --auto
lin sonority_N = mkN "sonoritat" feminine ; --auto
lin soon_AdV = mkAdv "aviat" ; --auto
lin soon_Adv = mkAdv "aviat" ;
lin sooner_Adv = mkAdv "més aviat" ; --auto
lin soot_N = mkN "sutge" masculine ; --auto
lin sophism_N = mkN "sofisma" masculine ; --auto
lin sophistFem_N = variants {} ; ---- sense to be split
lin sophistMasc_N = variants {} ; ---- sense to be split
lin sophisticated_A = mkA "sofisticat" ; --auto
lin sophistication_N = mkN "sofisticació" feminine ; --auto
lin sorcery_N = mkN "fetilleria" feminine ; --auto
lin sore_A = mkA "adolorit" ; --auto
lin sore_N = mkN "nafra" feminine ; --auto
lin sorption_N = mkN "sorció" feminine ; --auto
lin sorrel_N = mkN "agrella" feminine ; --auto
lin sorry_A = mkA "patètic" ;
lin sorry_Interj = mkInterj "perdoni" ;
lin sort_N = mkN "tipus" "tipus" masculine ; --split mkN "classificació"
lin sort_V = mkV "ordenar" ; --auto
lin sort_V2 = mkV2 "ordenar" ; --auto
lin sort_out_V2 = prepV2 OP_sort_V OP_out_Prep ; -- guess-p-verb
lin sorter_N = mkN "classificador" masculine ; --auto
lin sotto_voce_Adv = mkAdv "sotto voce" ; --auto
lin souffle_N = mkN "buf" masculine ; --auto
lin soul_N = mkN "ànima" feminine ; --auto
lin sound_N = mkN "so" masculine ;
lin sound_V = mkV "sonar" ;
lin sound_V2 = mkV2 (mkV "sonar") ;
lin sound_VA = mkVA (mkV "sonar") ;
lin sound_VS = mkVS (mkV "sonar") ; --subcat in English?
lin sound_off_V = advV OP_sound_V OP_off_Adv ; -- guess-p-verb
lin sound_out_V2 = prepV2 OP_sound_V OP_out_Prep ; -- guess-p-verb
lin sounding_board_N = mkN "caixa de ressonància" feminine ; --auto
lin soundless_A = mkA "insonor" ; --auto
lin soundtrack_N = mkN "banda sonora" feminine ; --auto
lin soup_N = mkN "sopa" feminine ; --auto
lin sour_A = mkA "àcid" | mkA "agre" ; --auto
lin source_N = mkN "font" feminine | mkN "origen" masculine ;
lin south_A = mkA "del sud" | mkA "sud" ; --auto
lin south_Adv = mkAdv "cap al sud" ; --auto
lin south_N = mkN "sud" masculine ;
lin southeast_Adv = mkAdv "cap al sud-est" ; --auto
lin southern_A = mkA "del sud" ; --auto
lin southerner_N = mkN "meridional" ; --auto
lin southwest_Adv = mkAdv "cap al sud-oest" ; --auto
lin southwest_N = mkN "sud-oest" masculine ; --auto
lin sovereign_A = mkA "sobirà" ; --auto
lin sovereign_N = mkN "sobirà" | mkN "sobirà" ; --auto
lin sovereignty_N = mkN "sobirania" feminine ; --auto
lin soviet_A = mkA "soviètic" ; --auto
lin sow_N = mkN "truja" feminine ; --auto
lin sower_N = mkN "sembrador" feminine | mkN "sembrador" masculine ; --auto
lin soy_N = mkN "soia" feminine | mkN "soja" feminine ; --auto
lin spa_N = mkN "balneari" masculine ; --auto
lin space_1_N = mkN "espai" masculine ;
lin space_2_N = mkN "espai" masculine ;
lin space_V2 = mkV2 "espaiar" ; --auto
lin spacecraft_N = mkN "aeronau" feminine ; --auto
lin spacetime_N = mkN "espai-temps" masculine | mkN "espai-temps" masculine ; --auto
lin spacing_N = mkN "espaiat" masculine ; --auto
lin spade_N = mkN "fanga" feminine ; --auto
lin spandex_N = mkN "espàndex" masculine ; --auto
lin spandrel_N = mkN "carcanyol" masculine ; --auto
lin spangle_N = mkN "lluentó" masculine ; --auto
lin spanishFem_N = variants {} ; ---- sense to be split
lin spanishMasc_N = variants {} ; ---- sense to be split
lin spanish_A = mkA "espanyol" ;
lin spar_N = mkN "espat" masculine ; --auto
lin spare_A = mkA "sobrer" ; --auto
lin spare_N = mkN "recanvi" masculine ; --auto
lin spare_V = mkV "estalviar" ; --auto
lin spare_V2 = mkV2 "estalviar" ; --auto
lin spark_N = mkN "espurna" feminine ; --auto
lin sparring_N = mkN "espàrring" masculine ; --auto
lin sparrow_N = mkN "pardal" masculine ; --auto
lin sparse_A = mkA "espars" ; --auto
lin spartanFem_N = variants {} ; ---- sense to be split
lin spartanMasc_N = variants {} ; ---- sense to be split
lin spartan_A = mkA "espartà" ; --auto
lin spate_of_N2 = mkN2 (mkN "devesall" masculine) ParadigmsCat.genitive ; --auto
lin spatial_A = mkA "espacial" ; --auto
lin speak_V = mkV "parlar" ;
lin speak_V2 = L.speak_V2 ;
lin speak_out_V = advV OP_speak_V OP_out_Adv ; -- guess-p-verb
lin speak_up_V = advV OP_speak_V OP_up_Adv ; -- guess-p-verb
lin speaker_N = mkN "orador" | mkN "ponent" ;
lin special_A = mkA "especial" ;
lin specialist_N = mkN "especialista" ; --auto
lin speciality_N = mkN "especialitat" feminine ; --auto
lin speciation_N = mkN "especiació" feminine ; --auto
lin species_N = mkN "espècie" feminine ;
lin specifiable_A = mkA "especificable" ; --auto
lin specific_A = mkA "específic" ;
lin specification_N = mkN "especificació" feminine ; --auto
lin specificity_N = mkN "especificitat" feminine ; --auto
lin specifier_N = mkN "especificador" masculine ; --auto
lin specify_V = mkV "especificar" ; --auto
lin specify_V2 = mkV2 "especificar" ; --auto
lin specimen_N = mkN "espècimen" masculine ; --auto
lin spectacle_N = mkN "ullera" feminine ; --auto
lin spectacular_A = mkA "espectacular" ; --auto
lin spectatorFem_N = variants {} ; ---- sense to be split
lin spectatorMasc_N = variants {} ; ---- sense to be split
lin spectral_A = mkA "espectral" ; --auto
lin spectrogram_N = mkN "espectrograma" masculine ; --auto
lin spectrograph_N = mkN "espectrògraf" masculine ; --auto
lin spectrographic_A = mkA "espectrogràfic" ; --auto
lin spectrophotometer_N = mkN "espectrofotòmetre" masculine ; --auto
lin spectroscope_N = mkN "espectroscopi" masculine ; --auto
lin spectroscopy_N = mkN "espectroscòpia" feminine ; --auto
lin spectrum_N = mkN "espectre" masculine ; --auto
lin speculation_N = mkN "especulació" feminine ; --auto
lin speculative_A = mkA "especulatiu" ; --auto
lin speculatorFem_N = variants {} ; ---- sense to be split
lin speculatorMasc_N = variants {} ; ---- sense to be split
lin speculum_N = mkN "espècul" masculine ; --auto
lin speech_N = mkN "discurs" masculine ;
lin speechless_A = mkA "mut" ; --auto
lin speed_N = mkN "velocitat" feminine ;
lin speed_V = mkV "accelerar" ; --auto
lin speed_V2 = mkV2 "accelerar" ; --auto
lin spell_N = mkN "encanteri" masculine | mkN "període" masculine ; --auto
lin spell_V = mkV "lletrejar" ; --auto
lin spell_V2 = mkV2 "lletrejar" ; --auto
lin spelling_N = mkN "ortografia" feminine ; --auto
lin spelt_N = mkN "espelta" feminine ; --auto
lin spend_V = mkV "gastar" ; --split mkV "passar" money vs. time
lin spend_V2 = mkV2 (mkV "gastar") ; --split
lin spender_N = mkN "gastador" feminine | mkN "gastador" masculine ; --auto
lin sperm_N = mkN "esperma" masculine ; --auto
lin spermatid_N = mkN "espermàtida" feminine ; --auto
lin spermatocele_N = mkN "espermatocele" masculine ; --auto
lin spermatocyte_N = mkN "espermatòcit" masculine ; --auto
lin spermatogenesis_N = mkN "espermatogènesi" feminine ; --auto
lin spermatophyte_N = mkN "espermatòfit" masculine ; --auto
lin sphere_N = mkN "esfera" feminine ; --auto
lin spherical_A = mkA "esfèric" ; --auto
lin spherocyte_N = mkN "esferòcit" masculine ; --auto
lin spheroid_N = mkN "esferoide" masculine ; --auto
lin spherometer_N = mkN "esferòmetre" masculine ; --auto
lin sphincter_N = mkN "esfínter" masculine ; --auto
lin spice_N = mkN "espècia" feminine ; --auto
lin spicy_A = mkA "picant" ; --auto
lin spider_N = mkN "aranya" feminine ; --auto
lin spigot_N = mkN "botana" feminine ; --auto
lin spiky_A = mkA "punxegut" ; --auto
lin spill_N = mkN "vessament" masculine ; --auto
lin spill_V = mkV "vessar" ; --auto
lin spill_V2 = mkV2 "vessar" ; --auto
lin spin_N = mkN "espín" masculine | mkN "spin" masculine ; --auto
lin spin_V = mkV "centrifugar" | mkV "filar" | mkV "giravoltar" ; --auto
lin spin_V2 = mkV2 "centrifugar" | mkV2 "filar" | mkV2 "giravoltar" ; --auto
lin spinach_N = mkN "espinac" masculine ; --auto
lin spinal_A = mkA "espinal" ; --auto
lin spindle_N = mkN "fus" masculine ; --auto
lin spine_N = mkN "dors" masculine ; --auto
lin spinel_N = mkN "espinel·la" feminine ; --auto
lin spineless_A = mkA "invertebrat" ; --auto
lin spinet_N = mkN "espineta" feminine ; --auto
lin spinning_N = mkN "filatura" feminine ; --auto
lin spiracle_N = mkN "espiracle" masculine ; --auto
lin spirit_N = mkN "esperit" masculine ;
lin spirit_level_N = mkN "nivell de bombolla" masculine ; --auto
lin spiritual_A = mkA "espiritual" ; --auto
lin spiritualism_N = mkN "espiritualisme" masculine ; --auto
lin spiritualistFem_N = variants {} ; ---- sense to be split
lin spiritualistMasc_N = variants {} ; ---- sense to be split
lin spiritualistic_A = mkA "espiritualista" ; --auto
lin spirituality_N = mkN "espiritualitat" feminine ; --auto
lin spit_N = mkN "escopinada" feminine ; --auto
lin spit_V = L.spit_V ;
lin spit_V2 = variants {} ; -- L.spit_V ;
lin spite_N = mkN "despit" masculine ; --auto
lin splendid_A = mkA "esplèndid" ; --auto
lin splendour_N = mkN "esplendor" feminine ; --auto
lin splenic_A = mkA "esplènic" ; --auto
lin splenomegaly_N = mkN "esplenomegàlia" feminine ; --auto
lin splice_V2 = mkV2 "empalmar" ; --auto
lin splint_N = mkN "fèrula" feminine ; --auto
lin split_N = mkN "ruptura" feminine ; --auto
lin split_V = variants {} ; -- L.split_V2 ;
lin split_V2 = L.split_V2 ;
lin split_up_V = advV OP_split_V OP_up_Adv ; -- guess-p-verb
lin split_up_V2 = prepV2 OP_split_V OP_up_Prep ; -- guess-p-verb
lin spoilage_N = mkN "maculatura" feminine ; --auto
lin spokesman_N = mkN "portaveu" ; --auto
lin spokesperson_N = mkN "portaveu" ; --auto
lin spokeswoman_N = mkN "portaveu" feminine ; --auto
lin spondylolisthesis_N = mkN "espondilolitesi" feminine ; --auto
lin sponge_N = mkN "esponja" feminine ; --auto
lin spongy_A = mkA "esponjós" ; --auto
lin sponsor_N = mkN "patrocinador" | mkN "patrocinador" ; --auto
lin sponsor_V2 = mkV2 "patrocinar" ; --auto
lin sponsorship_N = mkN "patrocini" masculine ; --auto
lin spontaneity_N = mkN "espontaneïtat" feminine ; --auto
lin spontaneous_A = mkA "espontani" ; --auto
lin spoon_N = mkN "cullera" feminine ; --auto
lin sporadic_A = mkA "esporàdic" ; --auto
lin sporangium_N = mkN "esporangi" masculine ; --auto
lin spore_N = mkN "espora" feminine ; --auto
lin sporophyte_N = mkN "esporòfit" masculine ; --auto
lin sport_N = mkN "esport" masculine ;
lin sportive_A = mkA "esportiu" ; --auto
lin sportsman_N = mkN "esportista" ; --auto
lin sporty_A = mkA "esportista" ; --auto
lin spot_N = mkN "espot" masculine | mkN "granet" masculine | mkN "gra" masculine | mkN "lloc" masculine | mkN "taca" feminine ; --auto
lin spotless_A = mkA "immaculat" ; --auto
lin spouseFem_N = variants {} ; ---- sense to be split
lin spouseMasc_N = variants {} ; ---- sense to be split
lin sprain_N = mkN "esquinç" masculine | mkN "torçada" feminine ; --auto
lin spray_N = mkN "esprai" masculine ; --auto
lin spread_V = mkV "divulgar" | mkV "estendre" | mkV "untar" ; --auto
lin spread_V2 = mkV2 "divulgar" | mkV2 "estendre" | mkV2 "untar" ; --auto
lin spread_out_V2 = prepV2 OP_spread_V OP_out_Prep ; -- guess-p-verb
lin spring_1_N = mkN "primavera" feminine ;
lin spring_2_N = mkN "ressort" ;
lin spring_3_N = mkN "font" feminine ;
lin spring_4_N = variants {} ;
lin spring_V = mkV "saltar" ; --auto
lin spring_V2 = mkV2 "saltar" ; --auto
lin springboard_N = mkN "trampolí" masculine ; --auto
lin springer_N = mkN "salmer" masculine ; --auto
lin sprinkler_N = mkN "aspersor" masculine | mkN "ruixador" masculine ; --auto
lin sprint_N = mkN "esprint" masculine ; --auto
lin sprinter_N = mkN "esprintador" | mkN "esprintador" ; --auto
lin sprout_V = mkV "brotar" ; --auto
lin sprout_V2 = mkV2 "brotar" ; --auto
lin sprue_N = mkN "esprue" masculine ; --auto
lin spur_N = mkN "esperó" masculine ; --auto
lin spur_V = mkV "esperonar" ; --auto
lin spur_V2 = mkV2 "esperonar" ; --auto
lin spurt_N = mkN "embranzida" feminine ; --auto
lin spy_N = mkN "espia" ; --auto
lin spy_V = mkV "espiar" ; --auto
lin spy_V2 = mkV2 "espiar" ; --auto
lin squandering_N = mkN "dilapidació" feminine ; --auto
lin square_A = mkA "quadrat" ; --auto
lin square_N = mkN "plaça" feminine ; --auto
lin square_V = mkV "quadrar" ; --auto
lin square_V2 = mkV2 "quadrar" ; --auto
lin squeeze_N = mkN "espremuda" feminine | mkN "premuda" feminine ; --auto
lin squeeze_V = variants {} ; -- L.squeeze_V2 ;
lin squeeze_V2 = L.squeeze_V2 ;
lin squid_N = mkN "calamar" masculine ; --auto
lin squirrel_N = mkN "esquirol" masculine ; --auto
lin stab_V = variants {} ; -- L.stab_V2 ;
lin stab_V2 = L.stab_V2 ;
lin stability_N = mkN "estabilitat" feminine ; --auto
lin stabilizer_N = mkN "estabilitzador" masculine ; --auto
lin stable_A = mkA "estable" ; --auto
lin stable_N = mkN "establa" feminine | mkN "estable" masculine | mkN "quadra" feminine ; --auto
lin stableboy_N = mkN "mosso de quadra" masculine ; --auto
lin stabling_N = mkN "estabulació" feminine ; --auto
lin stacker_N = mkN "apiladora" feminine ; --auto
lin stadium_N = mkN "estadi" masculine ; --auto
lin staff_1_N = mkN "personal" masculine ;
lin staff_2_N = mkN "personal" masculine ;
lin stage_N = mkN "escenari" masculine ; --split "estadi" (theater vs. conceptual stage)
lin stage_V = mkV "escenificar" | mkV "posar en escena" ; --auto
lin stagehand_N = mkN "tramoista" ; --auto
lin stagflation_N = mkN "estagflació" feminine ; --auto
lin stagnate_V = mkV "estancar" ; --auto
lin stagnation_N = mkN "estancament" masculine ; --auto
lin stain_N = mkN "taca" feminine ; --auto
lin stainless_1_A = mkA "inoxidable" ; --auto
lin stainless_2_A = mkA "inoxidable" ; --auto
lin stair_N = mkN "esglaó" masculine | mkN "graó" masculine | mkN "escala" feminine | mkN "escala" feminine | mkN "esglaó" masculine ; --auto
lin staircase_N = mkN "badalot" masculine | mkN "escala" feminine ; --auto
lin stake_N = mkN "estaca" feminine | mkN "participació" feminine ; --auto
lin stalactite_N = mkN "estalactita" feminine ; --auto
lin stalagmite_N = mkN "estalagmita" feminine ; --auto
lin stalemate_N = mkN "impasse" masculine ; --auto
lin stall_N = mkN "parada" feminine ; --auto
lin stall_V = mkV "parar" ; --auto
lin stall_V2 = mkV2 "parar" ; --auto
lin stallion_N = mkN "semental" masculine ; --auto
lin stamen_N = mkN "estam" masculine ; --auto
lin stammer_N = mkN "quequeig" masculine ; --auto
lin stammer_V = mkV "quequejar" ; --auto
lin stammer_V2 = mkV2 "quequejar" ; --auto
lin stamp_1_N = mkN "segell" masculine ; --auto
lin stamp_2_N = mkN "segell" masculine ; --auto
lin stamp_V = mkV "estampar" | mkV "picar de peus" ; --auto
lin stanchion_N = mkN "cuixera" feminine ; --auto
lin stand_N = mkN "estand" masculine | mkN "parada" feminine | mkN "posició" feminine | mkN "suport" masculine ; --auto
lin stand_V = L.stand_V ;
lin stand_V2 = mkV2 (mkV "suportar") | mkV2 (mkV "aguantar") ;
lin stand_about_V = advV OP_stand_V OP_about_Adv ; -- guess-p-verb
lin stand_around_V = advV OP_stand_V OP_around_Adv ; -- guess-p-verb
lin stand_aside_V = advV OP_stand_V OP_aside_Adv ; -- guess-p-verb
lin stand_back_V = advV OP_stand_V OP_back_Adv ; -- guess-p-verb
lin stand_by_V = advV OP_stand_V OP_by_Adv ; -- guess-p-verb
lin stand_by_V2 = prepV2 OP_stand_V OP_by_Prep ; -- guess-p-verb
lin stand_down_V = advV OP_stand_V OP_down_Adv ; -- guess-p-verb
lin stand_for_V2 = prepV2 OP_stand_V OP_for_Prep ; -- guess-p-verb
lin stand_in_for_V2 = prepV2 (advV OP_stand_V OP_in_Adv ) OP_for_Prep ; -- guess-p-verb
lin stand_out_V = advV OP_stand_V OP_out_Adv ; -- guess-p-verb
lin stand_up_V = advV OP_stand_V OP_up_Adv ; -- guess-p-verb
lin stand_up_V2 = prepV2 OP_stand_V OP_up_Prep ; -- guess-p-verb
lin stand_up_for_V2 = prepV2 (advV OP_stand_V OP_up_Adv ) OP_for_Prep ; -- guess-p-verb
lin stand_up_to_V2 = prepV2 (advV OP_stand_V OP_up_Adv ) OP_to_Prep ; -- guess-p-verb
lin standard_A = mkA "estàndard" ;
lin standard_N = mkN "estàndard" masculine ;
lin stanza_N = mkN "estrofa" feminine ; --auto
lin stapler_N = mkN "engrapadora" feminine ; --auto
lin star_N = L.star_N ;
lin star_V2 = mkV2 (mkV "protagonitzar") ;
lin starch_N = mkN "midó" masculine ; --auto
lin stare_N = mkN "mirada fixa" feminine ; --auto
lin stare_V = mkV "mirar fixament" ; --auto
lin stark_A = mkA "dur" ; --auto
lin starry_A = mkA "estrellat" ; --auto
lin start_N = mkN "començament" masculine ;
lin start_V = mkV "començar" ;
lin start_V2 = mkV2 (mkV "començar") ;
lin start_ing_VV = variants {} ; -- guess-p-verb
lin start_off_V = advV OP_start_V OP_off_Adv ; -- guess-p-verb
lin start_off_V2 = prepV2 OP_start_V OP_off_Prep ; -- guess-p-verb
lin start_off_on_V2 = prepV2 (advV OP_start_V OP_off_Adv ) OP_on_Prep ; -- guess-p-verb
lin start_on_V2 = prepV2 OP_start_V OP_on_Prep ; -- guess-p-verb
lin start_on_at_V2 = prepV2 (advV OP_start_V OP_on_Adv ) OP_at_Prep ; -- guess-p-verb
lin start_out_V = advV OP_start_V OP_out_Adv ; -- guess-p-verb
lin start_out_as_V2 = prepV2 (advV OP_start_V OP_out_Adv ) OP_as_Prep ; -- guess-p-verb
lin start_out_to_V2 = prepV2 (advV OP_start_V OP_out_Adv ) OP_to_Prep ; -- guess-p-verb
lin start_over_V = advV OP_start_V OP_over_Adv ; -- guess-p-verb
lin start_to_VV = variants {} ; -- guess-p-verb
lin start_up_V = advV OP_start_V OP_up_Adv ; -- guess-p-verb
lin start_up_V2 = prepV2 OP_start_V OP_up_Prep ; -- guess-p-verb
lin starter_1_N = variants {} ; ---- sense to be split
lin starter_2_N = variants {} ; ---- sense to be split
lin starter_3_N = variants {} ; ---- sense to be split
lin starter_4_N = variants {} ; ---- sense to be split
lin starter_5_N = variants {} ; ---- sense to be split
lin starter_6_N = variants {} ; ---- sense to be split
lin starter_7_N = variants {} ; ---- sense to be split
lin starvation_N = mkN "inanició" feminine ; --auto
lin stasis_N = mkN "estasi" feminine ; --auto
lin state_1_N = mkN "estat" masculine ;
lin state_2_N = mkN "estat" masculine ;
lin state_V2 = mkV2 (mkV "declarar") ;
lin state_VS = mkVS (mkV "declarar") ;
lin statement_N = mkN "declaració" feminine ;
lin statesman_N = mkN "estadista" ; --auto
lin static_A = mkA "estàtic" ; --auto
lin statics_N = mkN "estàtica" feminine ; --auto
lin station_1_N = mkN "estació" masculine ;
lin station_2_N = mkN "estació" masculine ;
lin statistic_N = mkN "estadística" feminine ; --auto
lin statistical_A = mkA "estadístic" ; --auto
lin statisticianFem_N = variants {} ; ---- sense to be split
lin statisticianMasc_N = variants {} ; ---- sense to be split
lin statistics_N = mkN "estadístic" feminine ; --auto
lin stator_N = mkN "estator" masculine ; --auto
lin statue_N = mkN "estàtua" feminine ; --auto
lin stature_N = mkN "estatura" feminine ; --auto
lin status_N = mkN "estat" masculine ;
lin statute_N = mkN "estatut" masculine ; --auto
lin statutory_A = mkA "estatutari" | mkA "reglamentari" ; --auto
lin staunch_V2 = mkV2 "estroncar" ; --auto
lin stay_N = mkN "estada" feminine ; --auto
lin stay_V = reflV (mkV "quedar") ;
lin stay_VA = mkVA (reflV (mkV "quedar")) ;
lin stay_away_V = advV OP_stay_V OP_away_Adv ; -- guess-p-verb
lin stay_away_from_V2 = prepV2 (advV OP_stay_V OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin stay_in_V = advV OP_stay_V OP_in_Adv ; -- guess-p-verb
lin stay_on_V = advV OP_stay_V OP_on_Adv ; -- guess-p-verb
lin stay_out_V = advV OP_stay_V OP_out_Adv ; -- guess-p-verb
lin stay_over_V = advV OP_stay_V OP_over_Adv ; -- guess-p-verb
lin stay_up_V = advV OP_stay_V OP_up_Adv ; -- guess-p-verb
lin steak_N = mkN "bistec" masculine ; --auto
lin steal_V = mkV "robar" ; --auto
lin steal_V2 = mkV2 "robar" ; --auto
lin steal_away_V = advV OP_steal_V OP_away_Adv ; -- guess-p-verb
lin steal_out_V = advV OP_steal_V OP_out_Adv ; -- guess-p-verb
lin steal_over_V2 = prepV2 OP_steal_V OP_over_Prep ; -- guess-p-verb
lin steal_up_V = advV OP_steal_V OP_up_Adv ; -- guess-p-verb
lin steal_up_on_V2 = prepV2 (advV OP_steal_V OP_up_Adv ) OP_on_Prep ; -- guess-p-verb
lin steam_N = mkN "vapor" masculine ; --auto
lin stearin_N = mkN "estearina" feminine ; --auto
lin steel_N = L.steel_N ;
lin steel_V2 = mkV2 "acerar" ; --auto
lin steelworks_N = mkN "acereria" feminine ; --auto
lin steep_A = mkA "costerut" ; --auto
lin steering_wheel_N = mkN "volant" masculine ; --auto
lin stellar_A = mkA "estel·lar" ; --auto
lin stem_N = mkN "arrel" feminine | mkN "tija" feminine ; --auto
lin stencil_N = mkN "estergidor" masculine ; --auto
lin stenosis_N = mkN "estenosi" feminine ; --auto
lin step_N = mkN "esglaó" masculine ; --split "pas" masculine
lin step_V = mkV "fer un pas" ; --auto
lin step_aside_V = advV OP_step_V OP_aside_Adv ; -- guess-p-verb
lin step_back_V = advV OP_step_V OP_back_Adv ; -- guess-p-verb
lin step_down_V = advV OP_step_V OP_down_Adv ; -- guess-p-verb
lin step_down_V2 = prepV2 OP_step_V OP_down_Prep ; -- guess-p-verb
lin step_forward_V = advV OP_step_V OP_forward_Adv ; -- guess-p-verb
lin step_in_V = advV OP_step_V OP_in_Adv ; -- guess-p-verb
lin step_on_it_V2 = variants {} ; -- guess-p-verb
lin step_out_V = advV OP_step_V OP_out_Adv ; -- guess-p-verb
lin step_to_V2 = prepV2 OP_step_V OP_to_Prep ; -- guess-p-verb
lin step_up_V2 = prepV2 OP_step_V OP_up_Prep ; -- guess-p-verb
lin stepbrother_N = mkN "germanastre" | mkN "germanastre" masculine ; --auto
lin stepdaughter_N = mkN "fillastre" | mkN "fillastre" feminine ; --auto
lin stepmother_N = mkN "madrastra" feminine ; --auto
lin steppe_N = mkN "estepa" feminine ; --auto
lin stepsister_N = mkN "germanastre" | mkN "germanastre" feminine ; --auto
lin stepson_N = mkN "fillastre" | mkN "fillastre" masculine ; --auto
lin steradian_N = mkN "estereoradiant" masculine ; --auto
lin stereophonic_A = mkA "estereofònic" ; --auto
lin stereoscope_N = mkN "estereoscopi" masculine ; --auto
lin stereotype_N = mkN "estereotip" masculine ; --auto
lin sterility_N = mkN "esterilitat" feminine ; --auto
lin sterling_N = mkN "lliura esterlina" feminine ; --auto
lin stern_N = mkN "popa" feminine ; --auto
lin sternum_N = mkN "estern" masculine ; --auto
lin steroid_N = mkN "esteroide" masculine ; --auto
lin stethoscope_N = mkN "estetoscopi" masculine ; --auto
lin stew_N = mkN "estofat" masculine ; --auto
lin stew_V = mkV "estofar" ; --auto
lin stew_V2 = mkV2 "estofar" ; --auto
lin stick_N = L.stick_N ;
lin stick_V = mkV "enganxar" ;
lin stick_V2 = mkV2 (mkV "enganxar") ;
lin stick_around_V = advV OP_stick_V OP_around_Adv ; -- guess-p-verb
lin stick_at_V2 = prepV2 OP_stick_V OP_at_Prep ; -- guess-p-verb
lin stick_by_V2 = prepV2 OP_stick_V OP_by_Prep ; -- guess-p-verb
lin stick_down_V2 = prepV2 OP_stick_V OP_down_Prep ; -- guess-p-verb
lin stick_it_to_V2 = variants {} ; -- guess-p-verb
lin stick_out_V = advV OP_stick_V OP_out_Adv ; -- guess-p-verb
lin stick_out_V2 = prepV2 OP_stick_V OP_out_Prep ; -- guess-p-verb
lin stick_out_for_V2 = prepV2 (advV OP_stick_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin stick_to_V2 = prepV2 OP_stick_V OP_to_Prep ; -- guess-p-verb
lin stick_together_V = advV OP_stick_V OP_together_Adv ; -- guess-p-verb
lin stick_up_V = advV OP_stick_V OP_up_Adv ; -- guess-p-verb
lin stick_up_V2 = prepV2 OP_stick_V OP_up_Prep ; -- guess-p-verb
lin stick_up_for_V2 = prepV2 (advV OP_stick_V OP_up_Adv ) OP_for_Prep ; -- guess-p-verb
lin stick_with_V2 = prepV2 OP_stick_V OP_with_Prep ; -- guess-p-verb
lin sticker_N = mkN "adhesiu" masculine ; --auto
lin sticky_A = mkA "enganxós" ; --auto
lin stiffen_V = mkV "enrigidir" ; --auto
lin stiffen_V2 = mkV2 "enrigidir" ; --auto
lin stiffener_N = mkN "enrigidor" masculine ; --auto
lin stigma_N = mkN "estigma" masculine ; --auto
lin stigmatic_A = mkA "estigmàtic" ; --auto
lin still_A = mkA "quiet" ; --auto
lin still_AdA = mkAdv "encara" ; --auto
lin still_AdV = mkAdv "encara" ; --auto
lin still_Adv = mkAdv "encara" ;
lin stillborn_A = mkA "nascut mort" ; --auto
lin stimulant_N = mkN "estimulant" masculine ; --auto
lin stimulate_V2 = mkV2 "estimular" ; --auto
lin stimulating_A = mkA "estimulant" ; --auto
lin stimulation_N = mkN "estimulació" feminine ; --auto
lin stimulus_N = mkN "estímul" masculine ; --auto
lin sting_N = mkN "agulló" masculine | mkN "picada" feminine | mkN "punxada" feminine ; --auto
lin stingy_A = mkA "gasiu" ; --auto
lin stink_N = mkN "pudor" masculine ; --auto
lin stink_V = mkV "fer pudor" ; --auto
lin stipulate_V = mkV "estipular" ; --auto
lin stipulate_V2 = mkV2 "estipular" ; --auto
lin stipulation_N = mkN "estipulació" feminine ; --auto
lin stir_N = mkN "enrenou" masculine ; --auto
lin stir_V = mkV "remenar" ; --auto
lin stir_V2 = mkV2 "remenar" ; --auto
lin stir_up_V2 = prepV2 OP_stir_V OP_up_Prep ; -- guess-p-verb
lin stochastic_A = mkA "estocàstic" ; --auto
lin stock_A = mkA "accionari" ; --auto
lin stock_N = mkN "acció" masculine ; --split "existències" fem (economic stock vs. warehouse stock)
lin stockholder_N = mkN "accionista" ; --auto
lin stocking_N = mkN "mitja" feminine ; --auto
lin stoichiometric_A = mkA "estequiomètric" ; --auto
lin stoichiometry_N = mkN "estequiometria" feminine ; --auto
lin stoicism_N = mkN "estoïcisme" masculine ; --auto
lin stole_N = mkN "estola" feminine ; --auto
lin stolidness_N = mkN "impassibilitat" feminine ; --auto
lin stoma_N = mkN "estoma" masculine ; --auto
lin stomach_N = mkN "estómac" masculine ; --auto
lin stomach_ache_N = mkN "mal de panxa" masculine ; --auto
lin stone_1_N = L.stone_N ;
lin stone_2_N = L.stone_N ;
lin stoning_N = mkN "esmerilament" masculine ; --auto
lin stop_N = mkN "aturada" feminine | mkN "parada" feminine ; --auto
lin stop_V = L.stop_V ;
lin stop_V2 = mkV2 (mkV "parar") ;
lin stop_VV = deVV (mkV "parar") ;
lin stop_around_V = advV OP_stop_V OP_around_Adv ; -- guess-p-verb
lin stop_back_V = advV OP_stop_V OP_back_Adv ; -- guess-p-verb
lin stop_behind_V = advV OP_stop_V OP_behind_Adv ; -- guess-p-verb
lin stop_by_V2 = prepV2 OP_stop_V OP_by_Prep ; -- guess-p-verb
lin stop_in_V = advV OP_stop_V OP_in_Adv ; -- guess-p-verb
lin stop_off_V = advV OP_stop_V OP_off_Adv ; -- guess-p-verb
lin stop_out_V = advV OP_stop_V OP_out_Adv ; -- guess-p-verb
lin stop_over_V = advV OP_stop_V OP_over_Adv ; -- guess-p-verb
lin stop_up_V = advV OP_stop_V OP_up_Adv ; -- guess-p-verb
lin stop_up_V2 = prepV2 OP_stop_V OP_up_Prep ; -- guess-p-verb
lin storage_N = mkN "emmagatzematge" masculine ; --auto
lin store_N = mkN "botiga" feminine ; --auto
lin store_V2 = mkV2 "emmagatzemar" ; --auto
lin stork_N = mkN "cigonya" feminine ; --auto
lin storm_N = mkN "tempesta" feminine | mkN "temporal" masculine ; --auto
lin stormy_A = mkA "tempestuós" ; --auto
lin story_N = mkN "història" feminine | mkN "conte" masculine ;
lin stove_N = mkN "cuina" feminine | mkN "estufa" feminine ; --auto
lin stowaway_N = mkN "polissó" masculine ; --auto
lin strabismus_N = mkN "estrabisme" masculine ; --auto
lin straight_A = L.straight_A ;
lin straight_Adv = mkAdv "directe" ;
lin straightedge_N = mkN "regla" feminine ; --auto
lin straightforward_A = mkA "sincer" ; --auto
lin straightness_N = mkN "rectitud" feminine ; --auto
lin strain_N = mkN "tensió" feminine | mkN "torçada" feminine ; --auto
lin strainer_N = mkN "colador" masculine ; --auto
lin strand_N = mkN "bri" masculine ; --auto
lin strange_A = mkA "estrany" ;
lin stranger_N = mkN "desconegut" feminine | mkN "desconegut" masculine ; --auto
lin strapping_N = mkN "emplastre" masculine ; --auto
lin strategic_A = mkA "estratègic" ; --auto
lin strategist_N = mkN "estrateg" | mkN "estrateg" ; --auto
lin strategy_N = mkN "estratègia" feminine ;
lin stratification_N = mkN "estratificació" feminine ; --auto
lin stratify_V = mkV "estratificar" ; --auto
lin stratify_V2 = mkV2 "estratificar" ; --auto
lin stratigraphy_N = mkN "estratigrafia" feminine ; --auto
lin stratosphere_N = mkN "estratosfera" feminine ; --auto
lin stratum_N = mkN "estrat" masculine ; --auto
lin stratus_N = mkN "estratus" masculine | mkN "estratus" masculine ; --auto
lin straw_N = mkN "palla" feminine ; --auto
lin strawberry_N = mkN "maduixa" feminine ; --auto
lin stray_A = mkA "perdut" ; --auto
lin streaky_A = mkA "ratllat" ; --auto
lin stream_N = mkN "corrent" masculine ; --auto
lin street_N = mkN "carrer" masculine ;
lin streetcar_N = mkN "tramvia" masculine ; --auto
lin strength_N = mkN "força" feminine ;
lin strengthen_V2 = mkV2 "enfortir" ; --auto
lin strengthening_N = mkN "enfortiment" masculine ; --auto
lin strenuous_A = mkA "esgotador" ; --auto
lin streptococcus_N = mkN "estreptococ" masculine ; --auto
lin stress_N = mkN "èmfasi" feminine | mkN "estrès" masculine | mkN "tensió" feminine ; --auto
lin stress_V2 = mkV2 "accentuar" | mkV2 "estressar" ; --auto
lin stretch_N = mkN "tram" masculine ; --auto
lin stretch_V = mkV "estendre" ; --auto
lin stretch_V2 = mkV2 "estendre" ; --auto
lin stretch_out_V = advV OP_stretch_V OP_out_Adv ; -- guess-p-verb
lin stretcher_N = mkN "llitera" feminine ; --auto
lin strict_A = mkA "estricte" ; --auto
lin strident_A = mkA "estrident" ; --auto
lin stridor_N = mkN "estridor" ; --auto
lin strike_1_N = variants {} ; ---- sense to be split
lin strike_2_N = variants {} ; ---- sense to be split
lin strike_V = mkV "pegar" ;
lin strike_V2 = mkV2 (mkV "pegar") ;
lin strike_back_V = advV OP_strike_V OP_back_Adv ; -- guess-p-verb
lin strike_down_V = advV OP_strike_V OP_down_Adv ; -- guess-p-verb
lin strike_down_V2 = prepV2 OP_strike_V OP_down_Prep ; -- guess-p-verb
lin strike_off_V2 = prepV2 OP_strike_V OP_off_Prep ; -- guess-p-verb
lin strike_on_V2 = prepV2 OP_strike_V OP_on_Prep ; -- guess-p-verb
lin strike_out_V = advV OP_strike_V OP_out_Adv ; -- guess-p-verb
lin strike_out_V2 = prepV2 OP_strike_V OP_out_Prep ; -- guess-p-verb
lin strike_up_V = advV OP_strike_V OP_up_Adv ; -- guess-p-verb
lin strike_up_V2 = prepV2 OP_strike_V OP_up_Prep ; -- guess-p-verb
lin strike_upon_V2 = prepV2 OP_strike_V OP_upon_Prep ; -- guess-p-verb
lin striker_N = mkN "percussor" masculine ; --auto
lin striking_A = mkA "cridaner" ; --auto
lin string_N = mkN "corda" feminine ; --auto
lin strip_N = mkN "cinta" feminine | mkN "tira" feminine ; --auto
lin strip_V = mkV "desposseir" | mkV "despullar-se" ; --auto
lin stripe_N = mkN "ratlla" feminine ; --auto
lin striped_A = mkA "rallat" ; --auto
lin striptease_N = mkN "striptease" masculine ; --auto
lin stroboscope_N = mkN "estroboscopi" masculine ; --auto
lin stroke_N = mkN "atac" masculine | mkN "ictus" masculine | mkN "traç" masculine ; --auto
lin stroke_V2 = mkV2 "acariciar" ; --auto
lin stroll_V = mkV "passejar" ; --auto
lin stroma_N = mkN "estroma" masculine ; --auto
lin strong_A = mkA "fort" ;
lin strontium_N = mkN "estronci" masculine ; --auto
lin structural_A = mkA "estructural" ; --auto
lin structuralism_N = mkN "estructuralisme" masculine ; --auto
lin structure_N = mkN "estructura" feminine ;
lin structure_V2 = mkV2 "estructurar" ; --auto
lin struggle_N = mkN "lluita" feminine ; --auto
lin struggle_V = mkV "lluitar" ; --auto
lin struggle_back_V = advV OP_struggle_V OP_back_Adv ; -- guess-p-verb
lin strut_N = mkN "muntant" masculine | mkN "puntal" masculine | mkN "tirant" masculine ; --auto
lin stub_N = mkN "burilla" feminine ; --auto
lin stubble_N = mkN "rostoll" masculine ; --auto
lin stubborn_A = mkA "tossut" ; --auto
lin stubbornness_N = mkN "tossuderia" feminine ; --auto
lin stucco_N = mkN "estuc" masculine ; --auto
lin studentFem_N = variants {} ; ---- sense to be split
lin studentMasc_N = variants {} ; ---- sense to be split
lin studio_N = mkN "estudi" masculine ;
lin studious_A = mkA "estudiós" ; --auto
lin study_N = mkN "estudi" masculine ;
lin study_V = mkV "estudiar" ;
lin study_V2 = mkV2 (mkV "estudiar") ;
lin stuff_N = mkN "coses" ; --TODO always plural
lin stuff_V2 = mkV2 "embotir" | mkV2 "farcir" ; --auto
lin stuffing_N = mkN "embotit" masculine ; --auto
lin stupendous_A = mkA "estupend" ; --auto
lin stupid_A = L.stupid_A ;
lin stupidity_N = mkN "estupidesa" feminine ; --auto
lin stupify_V2 = mkV2 "estupefactar" ; --auto
lin sturgeon_N = mkN "esturió" masculine ; --auto
lin stutter_N = mkN "quequeig" masculine ; --auto
lin stutter_V = mkV "quequejar" ; --auto
lin stutter_V2 = mkV2 "quequejar" ; --auto
lin sty_N = mkN "mussol" masculine ; --auto
lin stye_N = mkN "ordèol" masculine ; --auto
lin style_N = mkN "estil" masculine ;
lin stylist_N = mkN "estilista" ; --auto
lin stylistic_A = mkA "estilístic" ; --auto
lin subatomic_A = mkA "subatòmic" ; --auto
lin subclass_N = mkN "subclasse" feminine ; --auto
lin subclavian_A = mkA "subclavi" ; --auto
lin subcommittee_N = mkN "subcomitè" masculine ; --auto
lin subconsciousness_N = mkN "subconsciència" feminine ; --auto
lin subcontract_N = mkN "subcontracte" masculine ; --auto
lin subcontract_V = mkV "subcontractar" ; --auto
lin subcontract_V2 = mkV2 "subcontractar" ; --auto
lin subcontractor_N = mkN "subcontractista" ; --auto
lin subculture_N = mkN "subcultura" feminine ; --auto
lin subdirectory_N = mkN "subdirectori" masculine ; --auto
lin subdivision_N = mkN "subdivisió" feminine ; --auto
lin subduction_N = mkN "subducció" feminine ; --auto
lin subfamily_N = mkN "subfamília" feminine ; --auto
lin subgroup_N = mkN "subgrup" masculine ; --auto
lin subject_1_N = mkN "subjecte" masculine ; --split mkN "tema" masculine (grammatical vs. conversation topic)
lin subject_2_N = mkN "subjecte" masculine ; --split mkN "tema" masculine (grammatical vs. conversation topic)
lin subject_A = mkA "subjecte" ; --auto
lin subject_V2 = mkV2 "sotmetre" ; --auto
lin subjective_A = mkA "subjectiu" ; --auto
lin subjectivism_N = mkN "subjectivisme" masculine ; --auto
lin subjectivity_N = mkN "subjectivitat" feminine ; --auto
lin subjugation_N = mkN "subjugació" feminine ; --auto
lin subjunctive_N = mkN "subjuntiu" masculine ; --auto
lin sublimate_V2 = mkV2 "sublimar" ; --auto
lin sublimation_N = mkN "sublimació" feminine ; --auto
lin sublime_A = mkA "sublim" ; --auto
lin subliminal_A = mkA "subliminal" ; --auto
lin submarine_N = mkN "submarí" masculine ; --auto
lin submerge_V = mkV "submergir" ; --auto
lin submerge_V2 = mkV2 "submergir" ; --auto
lin submission_N = mkN "submissió" feminine ; --auto
lin submissive_A = mkA "submís" ; --auto
lin submit_V = mkV "entregar" | mkV "sotmetre" ; --auto
lin submit_V2 = mkV2 "entregar" | mkV2 "sotmetre" ; --auto
lin suborder_N = mkN "subordre" masculine ; --auto
lin subordinate_V2 = mkV2 "subordinar" ; --auto
lin subordination_N = mkN "subordinació" feminine ; --auto
lin subordinative_A = mkA "subordinant" ; --auto
lin subrogation_N = mkN "subrogació" feminine ; --auto
lin subscriber_N = mkN "abonat" feminine | mkN "abonat" masculine | mkN "subscriptor" ; --auto
lin subscript_N = mkN "subíndex" masculine ; --auto
lin subscription_N = mkN "subscripció" feminine ; --auto
lin subsequent_A = mkA "subsegüent" ; --auto
lin subset_N = mkN "subconjunt" masculine ; --auto
lin subsidiary_A = mkA "subsidiari" ; --auto
lin subsidiary_N = mkN "filial" feminine ; --auto
lin subsidy_N = mkN "subvenció" feminine ; --auto
lin subsoil_N = mkN "subsòl" masculine ; --auto
lin subsonic_A = mkA "subsònic" ; --auto
lin subspecies_N = mkN "subespècie" feminine ; --auto
lin substance_N = mkN "substància" feminine ; --auto
lin substantial_A = mkA "substancial" ; --auto
lin substantiality_N = mkN "substancialitat" feminine ; --auto
lin substantive_A = mkA "substantiu" ; --auto
lin substantive_N = mkN "substantiu" masculine ; --auto
lin substitute_N = mkN "substitut" | mkN "substitut" ; --auto
lin substitute_V = mkV "substituir" ; --auto
lin substitute_V2 = mkV2 "substituir" ; --auto
lin substitution_N = mkN "substitució" feminine ; --auto
lin substrate_N = mkN "substrat" masculine ; --auto
lin substring_N = mkN "subcadena" feminine ; --auto
lin substructure_N = mkN "subestructura" feminine ; --auto
lin subsystem_N = mkN "subsistema" masculine ; --auto
lin subterfuge_N = mkN "subterfugi" masculine ; --auto
lin subterranean_A = mkA "subterrani" ; --auto
lin subtle_A = mkA "subtil" ; --auto
lin subtract_V2 = mkV2 "restar" ; --auto
lin subtraction_N = mkN "sostració" feminine | mkN "substracció" feminine ; --auto
lin subtractive_A = mkA "subtractiu" ; --auto
lin subtrahend_N = mkN "subtrahend" masculine ; --auto
lin suburb_N = mkN "raval" masculine | mkN "suburbi" masculine ; --auto
lin suburban_A = mkA "suburbà" ; --auto
lin subway_N = mkN "metro" masculine ; --auto
lin succeed_V = mkV "tenir èxit" ; --auto
lin success_N = mkN "èxit" masculine ;
lin successful_A = mkA "exitós" ;
lin succession_N = mkN "successió" feminine ; --auto
lin successive_A = mkA "successiu" ; --auto
lin successor_N = mkN "successor" | mkN "successor" ; --auto
lin succinct_A = mkA "succint" ; --auto
lin succulent_A = mkA "suculent" ; --auto
lin succussion_N = mkN "sucussió" feminine ; --auto
lin such_as_Prep = mkPrep "com ara" | mkPrep "com" ; --auto
lin suck_V = variants {} ; -- L.suck_V2 ;
lin suck_V2 = L.suck_V2 ;
lin suckerFem_N = variants {} ; ---- sense to be split
lin suckerMasc_N = variants {} ; ---- sense to be split
lin suckle_V2 = mkV2 "alletar" ; --auto
lin sudanese_A = mkA "sudanès" ; --auto
lin sudanese_N = mkN "sudanès" | mkN "sudanès" ; --auto
lin sudden_A = mkA "sobtat" ; --auto
lin sue_V = mkV "demandar" ; --auto
lin sue_V2 = mkV2 "demandar" ; --auto
lin suffer_V = mkV (sofrir_103 "sofrir") ;
lin suffer_V2 = mkV2 (mkV (sofrir_103 "sofrir")) ;
lin suffering_N = mkN "sofriment" masculine ; --auto
lin suffice_V = mkV "bastar" ; --auto
lin suffice_V2 = mkV2 "bastar" ; --auto
lin sufficiency_N = mkN "suficiència" feminine ; --auto
lin sufficient_A = mkA "suficient" ; --auto
lin suffix_N = mkN "sufix" masculine ; --auto
lin suffixation_N = mkN "sufixació" feminine ; --auto
lin suffocate_V = mkV "asfixiar" ; --auto
lin suffocate_V2 = mkV2 "asfixiar" ; --auto
lin suffrage_N = mkN "sufragi" masculine ; --auto
lin suffragist_N = mkN "sufragista" ; --auto
lin sugar_N = mkN "sucre" masculine ; --auto
lin suggest_V = verbV (servir_101 "suggerir") ;
lin suggest_V2 = mkV2 (verbV (servir_101 "suggerir")) ;
lin suggest_VS = mkVS (verbV (servir_101 "suggerir")) ;
lin suggestion_N = mkN "suggeriment" masculine | mkN "suggestió" feminine ; --auto
lin suicidal_A = mkA "suïcida" ; --auto
lin suicide_N = mkN "suïcidi" masculine ; --auto
lin suit_N = mkN "plet" masculine | mkN "vestit jaqueta" masculine | mkN "vestit" masculine ; --auto
lin suit_V = mkV "adaptar" | mkV "convenir" ; --auto
lin suit_V2 = mkV2 "adaptar" | mkV2 "convenir" ; --auto
lin suit_up_V = advV OP_suit_V OP_up_Adv ; -- guess-p-verb
lin suitability_N = mkN "conveniència" feminine ; --auto
lin suitable_A = mkA "adequat" | mkA "adient" ; --auto
lin suitcase_N = mkN "maleta" feminine ; --auto
lin suite_N = mkN "suite" feminine ; --auto
lin sulfamethoxazole_N = mkN "sulfametoxazole" masculine ; --auto
lin sulfanilamide_N = mkN "sulfanilamida" feminine ; --auto
lin sullenness_N = mkN "sorruderia" feminine ; --auto
lin sulphate_N = mkN "sulfat" masculine ; --auto
lin sulphide_N = mkN "sulfur" masculine ; --auto
lin sulphur_N = mkN "sofre" masculine ; --auto
lin sulphurous_A = mkA "sulfúric" ; --auto
lin sum_N = mkN "suma" feminine ; --auto
lin summary_A = mkA "sumari" ; --auto
lin summary_N = mkN "recapitulació" feminine | mkN "resum" masculine | mkN "sumari" masculine ; --auto
lin summer_N = mkN "estiu" masculine ;
lin summit_N = mkN "cimera" feminine ; --auto
lin summon_V2 = mkV2 "convocar" ; --auto
lin sumptuary_A = mkA "sumptuari" ; --auto
lin sun_N = L.sun_N ;
lin sunflower_N = mkN "gira-sol" masculine ; --auto
lin sunless_A = mkA "obac" ; --auto
lin sunlight_N = mkN "llum solar" feminine ; --auto
lin sunny_A = mkA "assolellat" ; --auto
lin superb_A = mkA "magnífic" ; --auto
lin superclass_N = mkN "superclasse" feminine ; --auto
lin superconductivity_N = mkN "superconductivitat" feminine ; --auto
lin supercritical_A = mkA "supercrític" ; --auto
lin supererogation_N = mkN "supererogació" feminine ; --auto
lin superficial_A = mkA "superficial" ; --auto
lin superimpose_V2 = mkV2 "superposar" ; --auto
lin superior_A = mkA "superior" ; --auto
lin superiority_N = mkN "superioritat" feminine ; --auto
lin superlative_A = mkA "excepcional" ; --auto
lin superlative_N = mkN "superlatiu" masculine ; --auto
lin superman_N = mkN "superhome" masculine ; --auto
lin supermarket_N = mkN "supermercat" masculine ;
lin supernatural_A = mkA "sobrenatural" | mkA "supranatural" ; --auto
lin supernova_N = mkN "supernova" feminine ; --auto
lin supernumerary_N = mkN "supernumerari" masculine ; --auto
lin superscript_N = mkN "superíndex" masculine ; --auto
lin supersonic_A = mkA "supersònic" ; --auto
lin superstition_N = mkN "superstició" feminine ; --auto
lin superstitious_A = mkA "supersticiós" ; --auto
lin superstructure_N = mkN "superestructura" feminine ; --auto
lin supertanker_N = mkN "superpetrolier" feminine | mkN "superpetrolier" masculine ; --auto
lin supervise_V = mkV "supervisar" ; --auto
lin supervise_V2 = mkV2 "supervisar" ; --auto
lin supervision_N = mkN "supervisió" feminine ; --auto
lin supervisor_N = mkN "supervisor" | mkN "supervisor" ; --auto
lin supervisory_A = mkA "supervisor" ; --auto
lin supplement_N = mkN "suplement" masculine ; --auto
lin supplementary_A = mkA "suplementari" ; --auto
lin supplementation_N = mkN "suplementació" feminine ; --auto
lin supplier_N = mkN "proveïdor" feminine | mkN "proveïdor" masculine ; --auto
lin supply_N = mkN "oferta" feminine ;
lin supply_V2 = mkV2 (mkV (lluir_64 "proveir")) ;
lin support_N = mkN "suport" masculine ;
lin support_V2 = mkV2 (mkV "aguantar") ;
lin supporter_N = mkN "seguidor" ; --auto
lin suppose_V2 = mkV2 (mkV "suposar") ;
lin suppose_VS = mkVS (mkV "suposar") ;
lin supposed_A = mkA "suposat" ; --auto
lin supposition_N = mkN "supòsit" masculine ; --auto
lin suppository_N = mkN "supositori" masculine ; --auto
lin suppress_V2 = mkV2 "reprimir" | mkV2 "suprimir" ; --auto
lin supra_Adv = mkAdv "més amunt" ; --auto
lin supraorbital_A = mkA "supraorbital" ; --auto
lin supremacy_N = mkN "supremacia" feminine ; --auto
lin supreme_A = mkA "suprem" ; --auto
lin sure_A = mkA "segur" ;
lin sure_Adv = mkAdv "segur" ; --auto
lin surface_N = mkN "superfície" feminine ;
lin surface_V = mkV "emergir" ; --auto
lin surface_V2 = mkV2 "emergir" ; --auto
lin surfacing_N = mkN "cilindratge" masculine ; --auto
lin surfer_N = mkN "surfista" ; --auto
lin surgeon_N = mkN "cirurgià" | mkN "cirurgià" ; --auto
lin surgery_N = mkN "cirurgia" feminine ; --auto
lin surgical_A = mkA "quirúrgic" ; --auto
lin surname_N = mkN "cognom" masculine ; --auto
lin surpass_V2 = mkV2 "superar" ; --auto
lin surplus_N = mkN "superàvit" masculine ; --auto
lin surprise_N = mkN "sorpresa" feminine ; --auto
lin surprise_V2 = mkV2 "sorprendre" ; --auto
lin surprising_A = mkA "sorprenent" ; --auto
lin surrender_N = mkN "rendició" feminine ; --auto
lin surrender_V = mkV "rendir-se" ; --auto
lin surreptitious_A = mkA "subreptici" ; --auto
lin surround_V2 = mkV2 "envoltar" ; --auto
lin surrounding_A = mkA "circumdant" ; --auto
lin surroundings_N = mkN "entorn" masculine | mkN "entorn" masculine ; --auto
lin surveillance_N = mkN "vigilància" feminine ; --auto
lin survey_N = mkN "enquest" feminine ;
lin survival_N = mkN "supervivència" feminine ; --auto
lin survive_V = mkV (viure_119 "sobreviure") ;
lin survive_V2 = mkV2 (mkV (viure_119 "sobreviure")) ;
lin survivor_N = mkN "supervivent" ; --auto
lin susceptibility_N = mkN "susceptibilitat" feminine ; --auto
lin susceptible_A = mkA "susceptible" ; --auto
lin suspect_N = mkN "sospitós" feminine | mkN "sospitós" masculine ; --auto
lin suspect_V2 = mkV2 "sospitar" ; --auto
lin suspend_V = mkV "suspendre" ; --auto
lin suspend_V2 = mkV2 "suspendre" ; --auto
lin suspense_N = mkN "suspens" masculine ; --auto
lin suspension_N = mkN "suspensió" feminine ; --auto
lin suspicion_N = mkN "sospita" feminine ; --auto
lin suspicious_A = mkA "sospitós" ; --auto
lin sustain_V2 = mkV2 "sostenir" ; --auto
lin sustainability_N = mkN "sostenibilitat" feminine ; --auto
lin sustainable_A = mkA "sostenible" ; --auto
lin suture_N = mkN "sutura" feminine ; --auto
lin swab_N = mkN "escovilló" masculine ; --auto
lin swallow_N = mkN "trago" masculine ; --auto
lin swallow_V = mkV "empassar-se" ; --auto
lin swan_N = mkN "cigne" masculine ; --auto
lin swarm_N = mkN "eixam" masculine ; --auto
lin sway_V = mkV "balancejar" ; --auto
lin sway_V2 = mkV2 "balancejar" ; --auto
lin swear_V = mkV "jurar" ; --auto
lin swear_V2 = mkV2 "jurar" ; --auto
lin swearing_N = mkN "jurament" masculine ; --auto
lin swearword_N = mkN "renec" masculine ; --auto
lin sweat_N = mkN "suor" feminine | mkN "suor" feminine | mkN "suor" feminine | mkN "suor" feminine ; --auto
lin sweat_V = mkV "suar" ; --auto
lin sweat_V2 = mkV2 "suar" ; --auto
lin sweater_N = mkN "suèter" masculine ; --auto
lin sweatshirt_N = mkN "dessuadora" feminine ; --auto
lin swedeFem_N = variants {} ;
lin swedeMasc_N = variants {} ;
lin swedishFem_N = variants {} ;
lin swedishMasc_N = variants {} ;
lin swedish_A = mkA "suec" ;
lin sweep_V = mkV "agranar" | mkV "escombrar" ; --auto
lin sweep_V2 = mkV2 "agranar" | mkV2 "escombrar" ; --auto
lin sweep_through_V2 = prepV2 OP_sweep_V OP_through_Prep ; -- guess-p-verb
lin sweet_A = mkA "dolç" ; --auto
lin sweet_N = mkN "llaminadura" feminine ; --auto
lin swell_N = mkN "inflor" feminine ; --auto
lin swell_V = L.swell_V ;
lin swell_V2 = variants {} ; -- L.swell_V ;
lin swelling_N = mkN "inflament" masculine ; --auto
lin swift_A = mkA "veloç" ; --auto
lin swift_N = mkN "falciot" masculine ; --auto
lin swim_V = L.swim_V ;
lin swim_V2 = variants {} ; -- L.swim_V ;
lin swimmer_N = mkN "nedador" | mkN "nedador" ; --auto
lin swimming_N = mkN "natació" feminine ; --auto
lin swimming_pool_N = mkN "piscina" feminine ; --auto
lin swimsuit_N = mkN "banyador" masculine ; --auto
lin swindle_N = mkN "estafa" feminine ; --auto
lin swindler_N = mkN "estafador" | mkN "estafador" ; --auto
lin swine_N = mkN "porc" masculine ; --auto
lin swing_N = mkN "canvi" masculine | mkN "gronxador" masculine | mkN "oscil·lació" feminine ; --auto
lin swing_V = mkV "balancejar" ; --auto
lin swing_V2 = mkV2 "balancejar" ; --auto
lin swing_around_V = advV OP_swing_V OP_around_Adv ; -- guess-p-verb
lin swing_at_V2 = prepV2 OP_swing_V OP_at_Prep ; -- guess-p-verb
lin swing_by_V = advV OP_swing_V OP_by_Adv ; -- guess-p-verb
lin swing_round_V = advV OP_swing_V OP_round_Adv ; -- guess-p-verb
lin swiss_A = mkA "suís" ; --auto
lin switch_N = mkN "canvi" masculine | mkN "commutador" masculine | mkN "interruptor" masculine ; --auto
lin switch_V = mkV "canviar de" ; --auto
lin switch_off_V2 = prepV2 OP_switch_V OP_off_Prep ; -- guess-p-verb
lin switch_on_V2 = prepV2 OP_switch_V OP_on_Prep ; -- guess-p-verb
lin switchboard_N = mkN "centraleta" feminine ; --auto
lin sword_N = mkN "espasa" feminine ; --auto
lin sycamore_N = mkN "sicòmor" masculine ; --auto
lin syllabic_A = mkA "sil·làbic" ; --auto
lin syllable_N = mkN "síl·laba" feminine ; --auto
lin syllepsis_N = mkN "sil·lepsi" feminine ; --auto
lin syllogism_N = mkN "sil·logisme" masculine ; --auto
lin syllogistic_A = mkA "sil·logístic" ; --auto
lin symbiosis_N = mkN "simbiosi" feminine ; --auto
lin symbiotic_A = mkA "simbiòtic" ; --auto
lin symbol_N = mkN "símbol" masculine ; --auto
lin symbolic_A = mkA "simbòlic" ; --auto
lin symbolism_N = mkN "simbolisme" masculine ; --auto
lin symmetrical_A = mkA "simètric" ; --auto
lin symmetry_N = mkN "simetria" feminine ; --auto
lin sympathetic_A = mkA "compassiu" ; --auto
lin sympathy_N = mkN "compassió" feminine | mkN "simpatia" feminine ; --auto
lin sympatric_A = mkA "simpàtric" ; --auto
lin symphonic_A = mkA "simfònic" ; --auto
lin symphonist_N = mkN "simfonista" ; --auto
lin symphony_N = mkN "simfonia" feminine ; --auto
lin symphysis_N = mkN "símfisi" feminine ; --auto
lin symposium_N = mkN "simposi" masculine ; --auto
lin symptom_N = mkN "símptoma" masculine ; --auto
lin synagogue_N = mkN "sinagoga" feminine ; --auto
lin synchrocyclotron_N = mkN "sincrociclotró" masculine ; --auto
lin synchronism_N = mkN "sincronisme" masculine ; --auto
lin synchronous_A = mkA "síncron" ; --auto
lin synchrony_N = mkN "sincronia" feminine ; --auto
lin synchrotron_N = mkN "sincrotró" masculine ; --auto
lin synclinal_A = mkA "sinclinal" ; --auto
lin syncretism_N = mkN "sincretisme" masculine ; --auto
lin syndic_N = mkN "síndic" masculine ; --auto
lin syndicalistFem_N = variants {} ; ---- sense to be split
lin syndicalistMasc_N = variants {} ; ---- sense to be split
lin syndrome_N = mkN "síndrome" feminine ; --auto
lin synechia_N = mkN "sinèquia" feminine ; --auto
lin synergetic_A = mkA "sinergètic" ; --auto
lin synergistic_A = mkA "sinèrgic" ; --auto
lin synergy_N = mkN "sinergia" feminine ; --auto
lin synod_N = mkN "sínode" masculine ; --auto
lin synonym_N = mkN "sinònim" masculine ; --auto
lin synonymous_A = mkA "sinònim" ; --auto
lin syntactic_A = mkA "sintàctic" ; --auto
lin syntagma_N = mkN "sintagma" masculine ; --auto
lin syntagmatic_A = mkA "sintagmàtic" ; --auto
lin syntax_N = mkN "sintaxi" feminine ; --auto
lin synthesis_N = mkN "síntesi" feminine ; --auto
lin synthetic_A = mkA "sintètic" ; --auto
lin syrian_A = mkA "sirià" ; --auto
lin syrian_N = mkN "sirià" | mkN "sirià" ; --auto
lin syringe_N = mkN "xeringa" feminine ; --auto
lin syrup_N = mkN "almívar" masculine | mkN "xarop" masculine ; --auto
lin system_N = mkN "sistema" masculine ;
lin systematic_A = mkA "sistemàtic" ; --auto
lin systematics_N = mkN "sistemàtica" feminine ; --auto
lin systole_N = mkN "sístole" feminine ; --auto
lin tab_N = mkN "tabulador" masculine ; --auto
lin table_1_N = L.table_N ;
lin table_2_N = L.table_N ;
lin tablet_N = mkN "comprimit" masculine | mkN "pastilla" feminine ; --auto
lin tableware_N = mkN "vaixella" feminine ; --auto
lin tabular_A = mkA "tabular" ; --auto
lin tabulate_V2 = mkV2 "tabular" ; --auto
lin tabulation_N = mkN "tabulació" feminine ; --auto
lin tachograph_N = mkN "tacògraf" masculine ; --auto
lin tachometer_N = mkN "tacòmetre" masculine ; --auto
lin tachymeter_N = mkN "taquímetre" masculine ; --auto
lin tacit_A = mkA "tàcit" ; --auto
lin tackle_V = mkV "emprendre" ; --auto
lin tackle_V2 = mkV2 "emprendre" ; --auto
lin tactical_A = mkA "tàctic" ; --auto
lin tactics_N = mkN "tàctica" feminine ; --auto
lin tactile_A = mkA "tàctil" ; --auto
lin tadpole_N = mkN "capgròs" masculine ; --auto
lin taenia_N = mkN "tènia" feminine ; --auto
lin tail_N = L.tail_N ;
lin tailor_N = mkN "sastre" feminine | mkN "sastre" masculine ; --auto
lin tailpiece_N = mkN "cul-de-llàntia" feminine ; --auto
lin taiwaneseFem_N = variants {} ; ---- sense to be split
lin taiwaneseMasc_N = variants {} ; ---- sense to be split
lin taiwanese_A = mkA "taiwanès" ; --auto
lin take_V2 = mkV2 (mkV "agafar") ;
lin take_after_V2 = prepV2 (lin V OP_take_V2) OP_after_Prep ; -- guess-p-verb
lin take_apart_V2 = mkV2 (advV (lin V OP_take_V2) OP_apart_Adv ) ; -- guess-p-verb
lin take_aside_V2 = mkV2 (advV (lin V OP_take_V2) OP_aside_Adv ) ; -- guess-p-verb
lin take_away_V2 = mkV2 (advV (lin V OP_take_V2) OP_away_Adv ) ; -- guess-p-verb
lin take_back_V = advV (lin V OP_take_V2) OP_back_Adv ; -- guess-p-verb
lin take_back_V2 = mkV2 (advV (lin V OP_take_V2) OP_back_Adv ) ; -- guess-p-verb
lin take_down_V2 = prepV2 (lin V OP_take_V2) OP_down_Prep ; -- guess-p-verb
lin take_for_V2 = prepV2 (lin V OP_take_V2) OP_for_Prep ; -- guess-p-verb
lin take_in_V = advV (lin V OP_take_V2) OP_in_Adv ; -- guess-p-verb
lin take_in_V2 = prepV2 (lin V OP_take_V2) OP_in_Prep ; -- guess-p-verb
lin take_it_V2 = variants {} ; -- guess-p-verb
lin take_it_out_on_V2 = variants {} ; -- guess-p-verb
lin take_it_upon_yourself_V = variants {} ; -- guess-p-verb
lin take_off_V = advV (lin V OP_take_V2) OP_off_Adv ; -- guess-p-verb
lin take_off_V2 = prepV2 (lin V OP_take_V2) OP_off_Prep ; -- guess-p-verb
lin take_on_V = advV (lin V OP_take_V2) OP_on_Adv ; -- guess-p-verb
lin take_on_V2 = prepV2 (lin V OP_take_V2) OP_on_Prep ; -- guess-p-verb
lin take_out_V = advV (lin V OP_take_V2) OP_out_Adv ; -- guess-p-verb
lin take_out_V2 = prepV2 (lin V OP_take_V2) OP_out_Prep ; -- guess-p-verb
lin take_over_V = advV (lin V OP_take_V2) OP_over_Adv ; -- guess-p-verb
lin take_over_V2 = prepV2 (lin V OP_take_V2) OP_over_Prep ; -- guess-p-verb
lin take_through_V2 = prepV2 (lin V OP_take_V2) OP_through_Prep ; -- guess-p-verb
lin take_to_V2 = prepV2 (lin V OP_take_V2) OP_to_Prep ; -- guess-p-verb
lin take_up_V = advV (lin V OP_take_V2) OP_up_Adv ; -- guess-p-verb
lin take_up_V2 = prepV2 (lin V OP_take_V2) OP_up_Prep ; -- guess-p-verb
lin takeover_N = mkN "presa de poder" feminine ; --auto
lin talc_N = mkN "talc" masculine ; --auto
lin tale_N = mkN "conte" masculine ; --auto
lin talent_N = mkN "talent" masculine ; --auto
lin talisman_N = mkN "talismà" masculine ; --auto
lin talk_N = mkN "parla" feminine ;
lin talk_V = mkV "parlar" ;
lin talk_V2 = mkV2 (mkV "parlar") ParadigmsCat.genitive ;
lin talk_around_V2 = prepV2 OP_talk_V OP_around_Prep ; -- guess-p-verb
lin talk_at_V2 = prepV2 OP_talk_V OP_at_Prep ; -- guess-p-verb
lin talk_back_V = advV OP_talk_V OP_back_Adv ; -- guess-p-verb
lin talk_back_to_V2 = prepV2 (advV OP_talk_V OP_back_Adv ) OP_to_Prep ; -- guess-p-verb
lin talk_down_V2 = prepV2 OP_talk_V OP_down_Prep ; -- guess-p-verb
lin talk_down_to_V2 = prepV2 (advV OP_talk_V OP_down_Adv ) OP_to_Prep ; -- guess-p-verb
lin talk_into_V3 = variants {} ; -- guess-p-verb
lin talk_out_V2 = prepV2 OP_talk_V OP_out_Prep ; -- guess-p-verb
lin talk_out_of_V3 = variants {} ; -- guess-p-verb
lin talk_over_V2 = prepV2 OP_talk_V OP_over_Prep ; -- guess-p-verb
lin talk_round_V2 = prepV2 OP_talk_V OP_round_Prep ; -- guess-p-verb
lin talk_through_V3 = variants {} ; -- guess-p-verb
lin talk_up_V2 = prepV2 OP_talk_V OP_up_Prep ; -- guess-p-verb
lin talk_yourself_out_V = variants {} ; -- guess-p-verb
lin tall_A = mkA "alt" ; --auto
lin tallow_N = mkN "sèu" masculine ; --auto
lin tally_N = mkN "compte" masculine ; --auto
lin tambour_1_N = variants {} ; ---- sense to be split
lin tambour_2_N = variants {} ; ---- sense to be split
lin tambourine_N = mkN "pandereta" feminine ; --auto
lin tamer_N = mkN "domador" | mkN "domador" ; --auto
lin tamp_V2 = mkV2 "pitjar" ; --auto
lin tampon_N = mkN "tampó" masculine ; --auto
lin tan_N = mkN "bronzejat" masculine ; --auto
lin tandem_Adv = mkAdv "en tàndem" ; --auto
lin tangency_N = mkN "tangència" feminine ; --auto
lin tangent_1_N = mkN "tangent" feminine ; --auto
lin tangent_2_N = mkN "tangent" feminine ; --auto
lin tangential_A = mkA "tangencial" ; --auto
lin tangible_A = mkA "tangible" ; --auto
lin tank_N = mkN "dipòsit" masculine | mkN "tanc" masculine ; --auto
lin tantalum_N = mkN "tàntal" masculine ; --auto
lin tantrum_N = mkN "rabiola" feminine ; --auto
lin tap_N = mkN "aixeta" feminine | mkN "copet" masculine ; --auto
lin tap_V = mkV "donar copets a" ; --auto
lin tap_for_V3 = variants {} ; -- guess-p-verb
lin tap_into_V2 = prepV2 OP_tap_V OP_into_Prep ; -- guess-p-verb
lin tap_off_with_V2 = prepV2 (advV OP_tap_V OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin tap_out_V2 = prepV2 OP_tap_V OP_out_Prep ; -- guess-p-verb
lin tap_up_V2 = prepV2 OP_tap_V OP_up_Prep ; -- guess-p-verb
lin tape_N = mkN "cinta" feminine ; --auto
lin taper_V = mkV "afuar" ; --auto
lin taper_V2 = mkV2 "afuar" ; --auto
lin tapestry_N = mkN "tapís" masculine ; --auto
lin tarantula_N = mkN "taràntula" feminine ; --auto
lin target_N = mkN "objectiu" masculine ;
lin target_V2 = mkV2 "apuntar" ; --auto
lin tariff_N = mkN "aranzel" masculine ; --auto
lin tarpaulin_N = mkN "encert" masculine ; --auto
lin tarsus_N = mkN "tars" masculine ; --auto
lin tartan_N = mkN "tartan" masculine ; --auto
lin tartar_N = mkN "tàrtar" masculine ; --auto
lin task_N = mkN "tasca" feminine ;
lin tassel_N = mkN "borla" feminine ; --auto
lin taste_N = mkN "gust" masculine | mkN "tast" masculine ; --auto
lin taste_V = mkV "degustar" | mkV "tastar" | mkV "tenir gust" ; --auto
lin tasteless_A = mkA "insípid" ; --auto
lin taut_A = mkA "tibant" ; --auto
lin tautology_N = mkN "tautologia" feminine ; --auto
lin tax_N = mkN "impost" masculine ;
lin tax_V2 = mkV2 "gravar" ; --auto
lin taxation_N = mkN "impost" masculine | mkN "impost" masculine ; --auto
lin taxer_N = mkN "taxador" feminine | mkN "taxador" masculine ; --auto
lin taxi_N = mkN "taxi" masculine ; --auto
lin taximeter_N = mkN "taxímetre" masculine ; --auto
lin taxonomist_N = mkN "taxonomista" ; --auto
lin taxonomy_N = mkN "taxonomia" feminine ; --auto
lin taxpayer_N = mkN "contribuent" ; --auto
lin tea_N = mkN "te" masculine ;
lin teach_V = mkV "ensenyar" ;
lin teach_V2 = L.teach_V2 ;
lin teach_V2V = mkV2V (mkV "ensenyar") ParadigmsCat.dative ParadigmsCat.dative ;
lin teacherFem_N = variants {} ; ---- sense to be split
lin teacherMasc_N = variants {} ; ---- sense to be split
lin teaching_N = mkN "ensenyament" masculine ; --auto
lin teak_N = mkN "tec" masculine ; --auto
lin teal_N = mkN "xarxet" masculine ; --auto
lin team_N = mkN "equip" masculine ;
lin tear_N = mkN "estrip" masculine | mkN "llàgrima" feminine ; --auto
lin tear_V = mkV "estripar" ; --auto
lin tear_V2 = mkV2 "estripar" ; --auto
lin tear_apart_V2 = mkV2 (advV OP_tear_V OP_apart_Adv ) ; -- guess-p-verb
lin tear_at_V2 = prepV2 OP_tear_V OP_at_Prep ; -- guess-p-verb
lin tear_away_V2 = mkV2 (advV OP_tear_V OP_away_Adv ) ; -- guess-p-verb
lin tear_down_V2 = prepV2 OP_tear_V OP_down_Prep ; -- guess-p-verb
lin tear_into_V2 = prepV2 OP_tear_V OP_into_Prep ; -- guess-p-verb
lin tear_off_V = advV OP_tear_V OP_off_Adv ; -- guess-p-verb
lin tear_off_V2 = prepV2 OP_tear_V OP_off_Prep ; -- guess-p-verb
lin tear_out_V = advV OP_tear_V OP_out_Adv ; -- guess-p-verb
lin tear_up_V = advV OP_tear_V OP_up_Adv ; -- guess-p-verb
lin tear_up_V2 = prepV2 OP_tear_V OP_up_Prep ; -- guess-p-verb
lin teaspoon_N = mkN "cullereta" feminine ; --auto
lin teat_N = mkN "tetina" feminine ; --auto
lin technical_A = mkA "tècnic" ;
lin technician_N = mkN "tècnic" feminine | mkN "tècnic" masculine ; --auto
lin technique_N = mkN "tècnica" feminine ;
lin technocrat_N = mkN "tecnòcrata" ; --auto
lin technological_A = mkA "tecnològic" ; --auto
lin technology_N = mkN "tecnologia" feminine ;
lin tectonic_1_A = mkA "tectònic" ; --auto
lin tectonic_2_A = mkA "tectònic" ; --auto
lin tectonics_N = mkN "tectònica" feminine ; --auto
lin tedious_A = mkA "tediós" ; --auto
lin teenage_A = mkA "adolescent" ; --auto
lin teenager_N = mkN "adolescent" ; --auto
lin tektite_N = mkN "tectita" feminine ; --auto
lin telecommunication_N = mkN "telecomunicació" feminine ; --auto
lin telefilm_N = mkN "telefilm" masculine ; --auto
lin telegram_N = mkN "telegrama" masculine ; --auto
lin telegraph_N = mkN "telègraf" masculine ; --auto
lin telegraphic_A = mkA "telegràfic" ; --auto
lin telegraphy_N = mkN "telegrafia" feminine ; --auto
lin teleology_N = mkN "teleologia" feminine ; --auto
lin telepathy_N = mkN "telepatia" feminine ; --auto
lin telephone_N = mkN "telèfon" masculine ;
lin telephone_V = mkV "telefonar" ; --auto
lin telephone_V2 = mkV2 "telefonar" ; --auto
lin telephonic_A = mkA "telefònic" ; --auto
lin telephonistFem_N = variants {} ; ---- sense to be split
lin telephonistMasc_N = variants {} ; ---- sense to be split
lin telephony_N = mkN "telefonia" feminine ; --auto
lin teleprompter_N = mkN "teleapuntador" masculine ; --auto
lin telescope_N = mkN "telescopi" masculine ; --auto
lin telescopic_A = mkA "telescòpic" ; --auto
lin teletypewriter_N = mkN "teleimpressor" masculine ; --auto
lin televise_V2 = mkV2 "televisar" ; --auto
lin television_N = L.television_N ;
lin telex_N = mkN "tèlex" masculine ; --auto
lin tell_V = IrregCat.dir_V ;
lin tell_V2 = mkV2 IrregCat.dir_V ;
lin tell_V2S = mkV2S IrregCat.dir_V ParadigmsCat.dative ;
lin tell_V2V = mkV2V IrregCat.dir_V ParadigmsCat.dative ParadigmsCat.accusative ;
lin tell_V3 = dirdirV3 IrregCat.dir_V ; --meaning difference?
lin tell_VS = mkVS IrregCat.dir_V ;
lin tell_apart_V2 = mkV2 (advV OP_tell_V OP_apart_Adv ) ; -- guess-p-verb
lin tell_from_V3 = variants {} ; -- guess-p-verb
lin tell_off_V2 = prepV2 OP_tell_V OP_off_Prep ; -- guess-p-verb
lin tell_on_V2 = prepV2 OP_tell_V OP_on_Prep ; -- guess-p-verb
lin telluric_A = mkA "tel·lúric" ; --auto
lin tellurium_N = mkN "tel·luri" masculine ; --auto
lin temper_V = mkV "temperar" ; --auto
lin temper_V2 = mkV2 "temperar" ; --auto
lin temperament_N = mkN "temperament" masculine ; --auto
lin temperate_A = mkA "temperat" ; --auto
lin temperature_N = mkN "temperatura" feminine ; --auto
lin template_N = mkN "plantilla" feminine ; --auto
lin temple_N = mkN "temple" masculine ; --auto
lin tempo_N = mkN "tempo" masculine ; --auto
lin temporary_A = mkA "provisional" ; --auto
lin tempt_V2 = mkV2 "temptar" ; --auto
lin temptation_N = mkN "temptació" feminine ; --auto
lin tenant_N = mkN "inquilí" feminine | mkN "inquilí" masculine ; --auto
lin tench_N = mkN "tenca" feminine ; --auto
lin tend_V2 = mkV2 (mkV "cuidar") ;
lin tend_VV = aVV (mkV "acostumar") ;
lin tendency_N = mkN "tendència" feminine ; --auto
lin tender_A = mkA "tendre" ; --auto
lin tender_N = mkN "oferta" feminine ; --auto
lin tenderness_N = mkN "tendresa" feminine ; --auto
lin tenesmus_N = mkN "tenesme" masculine ; --auto
lin tennis_N = mkN "tennis" masculine | mkN "tennis" masculine ; --auto
lin tenor_N = mkN "tenor" masculine ; --auto
lin tense_V = mkV "tensar" ; --auto
lin tense_V2 = mkV2 "tensar" ; --auto
lin tensiometer_N = mkN "tensiòmetre" masculine ; --auto
lin tension_N = mkN "tensió" feminine ; --auto
lin tensional_A = mkA "tensional" ; --auto
lin tensor_N = mkN "tensor" masculine ; --auto
lin tent_N = mkN "tenda" feminine ; --auto
lin tentacle_N = mkN "tentacle" masculine ; --auto
lin tentative_A = mkA "provisional" ; --auto
lin tenuous_A = mkA "tènue" ; --auto
lin tepal_N = mkN "tèpal" masculine ; --auto
lin teratoma_N = mkN "teratoma" masculine ; --auto
lin terbium_N = mkN "terbi" masculine ; --auto
lin term_N = mkN "terme" masculine ;
lin terminal_A = mkA "terminal" ; --auto
lin terminal_N = mkN "born" masculine | mkN "terminal" feminine ; --auto
lin terminate_V = mkV "rescindir" ; --auto
lin terminate_V2 = mkV2 "rescindir" ; --auto
lin terminological_A = mkA "terminològic" ; --auto
lin terminology_N = mkN "terminologia" feminine ; --auto
lin termite_N = mkN "tèrmit" masculine ; --auto
lin terms_N = mkN "terme" masculine ;
lin ternary_A = mkA "ternari" ; --auto
lin terrace_N = mkN "terrassa" feminine ; --auto
lin terrain_N = mkN "terreny" masculine ; --auto
lin terrestrial_A = mkA "terrestre" ; --auto
lin terrible_A = mkA "terrible" ; --auto
lin terrific_A = mkA "fabulós" ; --auto
lin terrify_V2 = mkV2 "aterrir" ; --auto
lin territorial_A = mkA "territorial" ; --auto
lin territoriality_N = mkN "territorialitat" feminine ; --auto
lin territory_N = mkN "territori" masculine ; --auto
lin terror_N = mkN "terror" masculine ; --auto
lin terrorism_N = mkN "terrorisme" masculine ; --auto
lin terrorist_N = mkN "terrorista" ; --auto
lin tertiary_A = mkA "terciari" ; --auto
lin tesla_N = mkN "tesla" feminine ; --auto
lin test_N = mkN "prova" feminine ; --"examen"
lin test_V2 = mkV2 (mkV "provar") ;
lin testamentary_A = mkA "testamentari" ; --auto
lin testator_N = mkN "testador" feminine | mkN "testador" masculine ; --auto
lin testicle_N = mkN "testicle" masculine ; --auto
lin testicular_A = mkA "testicular" ; --auto
lin testify_V = mkV "testificar" ; --auto
lin testify_V2 = mkV2 "testificar" ; --auto
lin testing_N = mkN "testatge" masculine ; --auto
lin tetanus_N = mkN "tètan" masculine ; --auto
lin tetany_N = mkN "tetània" feminine ; --auto
lin tetragonal_A = mkA "tetragonal" ; --auto
lin tetrahedron_N = mkN "tetràedre" masculine ; --auto
lin tetravalent_A = mkA "tetravalent" ; --auto
lin text_N = mkN "text" masculine ;
lin textile_A = mkA "tèxtil" ; --auto
lin textual_A = mkA "textual" ; --auto
lin texture_N = mkN "textura" feminine ; --auto
lin thaiFem_N = variants {} ; ---- sense to be split
lin thaiMasc_N = variants {} ; ---- sense to be split
lin thai_A = mkA "tailandès" ; --auto
lin thalamus_N = mkN "tàlem" masculine ; --auto
lin than_Subj = mkSubj "que" Indic ;
lin thanatology_N = mkN "tanatologia" feminine ; --auto
lin thank_V2 = mkV2 (mkV (servir_101 "agrair")) ;
lin thankless_A = mkA "ingrat" ; --auto
lin thanks_to_Prep = mkPrep "gràcies a" ; --auto
lin thanks_Interj = mkInterj "gràcies" ;
lin that_Quant = S.that_Quant ;
lin that_Subj = S.that_Subj ;
lin thaw_N = mkN "desglaç" masculine ; --auto
lin thaw_V = mkV "desglaçar" ; --auto
lin thaw_V2 = mkV2 "desglaçar" ; --auto
lin theatre_N = mkN "teatre" masculine ;
lin theatrical_A = mkA "teatral" ; --auto
lin theft_N = mkN "robatori" masculine ; --auto
lin theism_N = mkN "teisme" masculine ; --auto
lin theist_N = mkN "teista" ; --auto
lin thematic_A = mkA "temàtic" ; --auto
lin theme_N = mkN "tema" masculine ; --auto
lin then_Adv = mkAdv "llavors" ;
lin thenar_N = mkN "tènar" masculine ; --auto
lin thence_Adv = mkAdv "d'allí" ; --auto
lin thenceforth_Adv = mkAdv "des d'aleshores" ; --auto
lin thenceforward_Adv = mkAdv "des d'aleshores" ; --auto
lin theocracy_N = mkN "teocràcia" feminine ; --auto
lin theocratic_A = mkA "teocràtic" ; --auto
lin theodicy_N = mkN "teodicea" feminine ; --auto
lin theodolite_N = mkN "teodolit" masculine ; --auto
lin theologian_N = mkN "teòleg" | mkN "teòleg" ; --auto
lin theological_A = mkA "teològic" ; --auto
lin theology_N = mkN "teologia" feminine ; --auto
lin theorem_N = mkN "teorema" masculine ; --auto
lin theoretical_A = mkA "teòric" ; --auto
lin theorist_N = mkN "teòric" | mkN "teòric" ; --auto
lin theory_N = mkN "teoria" feminine ;
lin theosophy_N = mkN "teosofia" feminine ; --auto
lin therapeutic_A = mkA "terapèutic" ; --auto
lin therapeutics_N = mkN "terapèutica" feminine ; --auto
lin therapist_N = mkN "terapeuta" ; --auto
lin therapy_N = mkN "teràpia" feminine ; --auto
lin there_Adv = S.there_Adv ;
lin thereabouts_Adv = mkAdv "més o menys" ; --auto
lin thereafter_Adv = mkAdv "després" ; --auto
lin thereby_Adv = mkAdv "així" ; --auto
lin therefore_Adv = mkAdv "per tant" ;
lin thereof_Adv = mkAdv "d'açò" | mkAdv "d'això" ; --auto
lin thereunder_Adv = mkAdv "més avall" ; --auto
lin therm_N = mkN "tèrmia" feminine ; --auto
lin thermal_A = mkA "tèrmic" ; --auto
lin thermionic_A = mkA "termoiònic" ; --auto
lin thermistor_N = mkN "termistor" masculine ; --auto
lin thermochemistry_N = mkN "termoquímica" feminine ; --auto
lin thermocoagulation_N = mkN "termocoagulació" feminine ; --auto
lin thermocouple_N = mkN "termoparell" masculine ; --auto
lin thermodynamic_A = mkA "termodinàmic" ; --auto
lin thermodynamics_N = mkN "termodinàmica" feminine ; --auto
lin thermoelectric_A = mkA "termoelèctric" ; --auto
lin thermoelectricity_N = mkN "termoelectricitat" feminine ; --auto
lin thermogram_N = mkN "termograma" masculine ; --auto
lin thermograph_N = mkN "termògraf" masculine ; --auto
lin thermography_N = mkN "termografia" feminine ; --auto
lin thermogravimetry_N = mkN "termogravimetria" feminine ; --auto
lin thermometer_N = mkN "termòmetre" masculine ; --auto
lin thermometric_A = mkA "termomètric" ; --auto
lin thermometry_N = mkN "termometria" feminine ; --auto
lin thermonuclear_A = mkA "termonuclear" ; --auto
lin thermoplastic_A = mkA "termoplàstic" ; --auto
lin thermosetting_A = mkA "termoendurible" ; --auto
lin thermosphere_N = mkN "termosfera" feminine ; --auto
lin thermostat_N = mkN "termòstat" masculine ; --auto
lin thesaurus_N = mkN "tesaurus" masculine | mkN "tesaurus" masculine ; --auto
lin thesis_N = mkN "tesi" feminine ; --auto
lin theyFem_Pron = optProDrop E.they8fem_Pron ;
lin they_Pron = optProDrop S.they_Pron ;
lin thick_A = L.thick_A ;
lin thicken_V = mkV "espessir" ; --auto
lin thicken_V2 = mkV2 "espessir" ; --auto
lin thicket_N = mkN "matoll" masculine ; --auto
lin thickness_N = mkN "espessor" masculine | mkN "gruix" masculine ; --auto
lin thief_N = mkN "lladre" ; --auto
lin thimble_N = mkN "didal" masculine ; --auto
lin thin_A = L.thin_A ;
lin thin_V = mkV "aprimar" ; --auto
lin thin_V2 = mkV2 "aprimar" ; --auto
lin thing_N = mkN "cosa" ;
lin think_V = L.think_V ;
lin think_V2 = mkV2 L.think_V (mkPrep "en") ;
lin think_VS = mkVS L.think_V ;
lin think_over_V2 = prepV2 OP_think_V OP_over_Prep ; -- guess-p-verb
lin think_through_V2 = prepV2 OP_think_V OP_through_Prep ; -- guess-p-verb
lin think_up_V2 = prepV2 OP_think_V OP_up_Prep ; -- guess-p-verb
lin thinkerFem_N = variants {} ; ---- sense to be split
lin thinkerMasc_N = variants {} ; ---- sense to be split
lin thinking_N = mkN "pensament" masculine ; --auto
lin thinness_N = mkN "primesa" feminine ; --auto
lin thirst_N = mkN "set" feminine | mkN "set" feminine ; --auto
lin this_Quant = S.this_Quant ;
lin thistle_N = mkN "card" masculine ; --auto
lin thoracocentesis_N = mkN "toracocentesi" feminine ; --auto
lin thorax_N = mkN "tòrax" masculine ; --auto
lin thorium_N = mkN "tori" masculine ; --auto
lin thorough_A = mkA "minuciós" ; --auto
lin though_Adv = mkAdv "tot i que" ;
lin though_Subj = mkSubj "encara que" Conjunct | mkSubj "tot i que" Conjunct ;
lin thought_N = mkN "pensament" masculine ;
lin thoughtful_A = mkA "considerat" | mkA "pensarós" ; --auto
lin thoughtless_A = mkA "desconsiderat" ; --auto
lin thread_N = mkN "fil" masculine | mkN "rosca" feminine ; --auto
lin thread_V2 = mkV2 "roscar" ; --auto
lin threat_N = mkN "amenaça" feminine ;
lin threaten_V = mkV "amenaçar" ;
lin threaten_V2 = mkV2 (mkV "amenaçar") ;
lin threaten_VS = mkVS (mkV "amenaçar") ;
lin threaten_VV = deVV (mkV "amenaçar") ;
lin threshold_N = mkN "llindar" masculine ; --auto
lin thrice_Adv = mkAdv "tres vegades" ; --auto
lin thrill_N = mkN "emoció" feminine ; --auto
lin thrill_V = mkV "emocionar" ; --auto
lin thrill_V2 = mkV2 "emocionar" ; --auto
lin thriller_N = mkN "thriller" masculine ; --auto
lin thrive_V = mkV "créixer" ; --auto
lin throat_N = mkN "gola" feminine | mkN "gorja" feminine ; --auto
lin thrombin_N = mkN "trombina" feminine ; --auto
lin thrombocytosis_N = mkN "trombocitosi" feminine ; --auto
lin thrombosis_N = mkN "trombosi" feminine ; --auto
lin thrombus_N = mkN "trombe" masculine ; --auto
lin throne_N = mkN "tron" masculine ; --auto
lin through_Adv = mkAdv "a través de" ;
lin through_Prep = S.through_Prep ;
lin throughout_Adv = mkAdv "pertot arreu" ; --auto
lin throughout_Prep = mkPrep "durant" ; --difficult to convey, requires adding "tot"
lin throw_V = mkV "llençar" ;
lin throw_V2 = L.throw_V2 ;
lin throw_away_V2 = mkV2 (advV OP_throw_V OP_away_Adv ) ; -- guess-p-verb
lin throw_in_V = advV OP_throw_V OP_in_Adv ; -- guess-p-verb
lin throw_in_V2 = prepV2 OP_throw_V OP_in_Prep ; -- guess-p-verb
lin throw_off_V = advV OP_throw_V OP_off_Adv ; -- guess-p-verb
lin throw_off_V2 = prepV2 OP_throw_V OP_off_Prep ; -- guess-p-verb
lin throw_on_V2 = prepV2 OP_throw_V OP_on_Prep ; -- guess-p-verb
lin throw_out_V2 = prepV2 OP_throw_V OP_out_Prep ; -- guess-p-verb
lin throw_over_V2 = prepV2 OP_throw_V OP_over_Prep ; -- guess-p-verb
lin throw_together_V2 = mkV2 (advV OP_throw_V OP_together_Adv ) ; -- guess-p-verb
lin throw_up_V = advV OP_throw_V OP_up_Adv ; -- guess-p-verb
lin throw_up_V2 = prepV2 OP_throw_V OP_up_Prep ; -- guess-p-verb
lin throw_yourself_at_V2 = variants {} ; -- guess-p-verb
lin throw_yourself_into_V2 = variants {} ; -- guess-p-verb
lin thrusterFem_N = variants {} ; ---- sense to be split
lin thrusterMasc_N = variants {} ; ---- sense to be split
lin thug_N = mkN "perdonavides" masculine ; --auto
lin thulium_N = mkN "tuli" masculine ; --auto
lin thumb_N = mkN "polze" masculine ; --auto
lin thumbtack_N = mkN "xinxeta" feminine ; --auto
lin thunder_N = mkN "tro" masculine ; --auto
lin thunder_V = mkV "tronar" ; --auto
lin thunder_V2 = mkV2 "tronar" ; --auto
lin thunderbolt_N = mkN "llamp" masculine ; --auto
lin thus_Adv = mkAdv "per tant" ; --split "així" | "així doncs"
lin thyme_N = mkN "farigola" feminine ; --auto
lin thyroid_A = mkA "tiroide" ; --auto
lin thyroidectomy_N = mkN "tiroïdectomia" feminine ; --auto
lin thyroxine_N = mkN "tiroxina" feminine ; --auto
lin tibia_N = mkN "tíbia" feminine ; --auto
lin tibial_A = mkA "tibial" ; --auto
lin tic_N = mkN "tic" masculine ; --auto
lin tick_N = mkN "tic-tac" masculine ; --auto
lin tick_V = mkV "fer tic-tac" ; --auto
lin ticket_N = mkN "bitllet" masculine | mkN "entrada" feminine | mkN "tiquet" masculine ; --auto
lin ticking_N = mkN "cussolí" masculine | mkN "tic-tac" masculine ; --auto
lin tide_N = mkN "marea" feminine ; --auto
lin tidy_A = mkA "ordenat" ; --auto
lin tie_N = mkN "corbata" feminine | mkN "empat" masculine | mkN "lligam" masculine | mkN "vincle" masculine ; --auto
lin tie_V = variants {} ; -- L.tie_V2 ;
lin tie_V2 = L.tie_V2 ;
lin tie_back_V2 = mkV2 (advV OP_tie_V OP_back_Adv ) ; -- guess-p-verb
lin tie_down_V2 = prepV2 OP_tie_V OP_down_Prep ; -- guess-p-verb
lin tie_in_V = advV OP_tie_V OP_in_Adv ; -- guess-p-verb
lin tie_in_V2 = prepV2 OP_tie_V OP_in_Prep ; -- guess-p-verb
lin tie_in_with_V2 = prepV2 (advV OP_tie_V OP_in_Adv ) OP_with_Prep ; -- guess-p-verb
lin tie_up_V2 = prepV2 OP_tie_V OP_up_Prep ; -- guess-p-verb
lin tiger_N = mkN "tigre" feminine | mkN "tigre" masculine ; --auto
lin tight_A = mkA "estanc" ; --auto
lin tighten_V = mkV "estrènyer" | mkV "tibar" ; --auto
lin tighten_V2 = mkV2 "estrènyer" | mkV2 "tibar" ; --auto
lin tightness_N = mkN "estanquitat" feminine ; --auto
lin tilde_N = mkN "titlla" feminine ; --auto
lin tile_V2 = mkV2 "enrajolar" ; --auto
lin time_1_N = mkN "temps" "temps" masculine ;
lin time_2_N = mkN "temps" "temps" masculine ;
lin time_V2 = mkV2 "cronometrar" ; --auto
lin time_limit_N = mkN "termini màxim" masculine ; --auto
lin timekeeper_N = mkN "cronometrador" feminine | mkN "cronometrador" masculine ; --auto
lin timely_A = mkA "oportú" ; --auto
lin timer_N = mkN "temporitzador" masculine ; --auto
lin timetable_N = mkN "horari" masculine ; --auto
lin timidity_N = mkN "timidesa" feminine ; --auto
lin tin_N = mkN "estany" masculine | mkN "llauna" feminine ; --auto
lin tinder_N = mkN "esca" feminine ; --auto
lin tinkle_N = mkN "dringadissa" feminine ; --auto
lin tinkle_V = mkV "dringar" ; --auto
lin tinkle_V2 = mkV2 "dringar" ; --auto
lin tiny_A = mkA "minúscul" ; --auto
lin tip_N = mkN "consell" masculine | mkN "propina" feminine | mkN "punta" feminine ; --auto
lin tip_V = mkV "abocar" | mkV "donar una propina a" ; --auto
lin tirade_N = mkN "diatriba" feminine ; --auto
lin tire_N = mkN "pneumàtic" masculine ; --auto
lin tired_A = mkA "cansat" ;
lin tireless_A = mkA "incansable" ; --auto
lin tissue_N = mkN "mocador" masculine | mkN "teixit" masculine ; --auto
lin titanic_A = mkA "titànic" ; --auto
lin titanium_N = mkN "titani" masculine ; --auto
lin title_N = mkN "títol" masculine ;
lin to_Adv = variants {} ; --TODO "pull the door to" -> "ajustar la porta", can't find any more senses
lin to_Prep = S.to_Prep ;
lin to_date_Adv = mkAdv "fins avui" ; --auto
lin toad_N = mkN "gripau" masculine ; --auto
lin toast_N = mkN "brindis" masculine | mkN "brindis" masculine | mkN "torrada" feminine ; --auto
lin toast_V = mkV "torrar" ; --auto
lin toast_V2 = mkV2 "torrar" ; --auto
lin toaster_N = mkN "torradora" feminine ; --auto
lin tobacco_N = mkN "tabac" masculine ; --auto
lin today_Adv = L.today_Adv ;
lin toe_N = mkN "dit del peu" masculine | mkN "dit" masculine ; --auto
lin toenail_N = mkN "ungla" feminine ; --auto
lin toga_N = mkN "toga" feminine ; --auto
lin together_A = mkA "junt" ; --auto
lin together_Adv = mkAdv "junt" ;
lin toilet_N = mkN "lavabo" masculine ;
lin toilet_paper_N = mkN "paper higiènic" masculine ; --auto
lin tolerate_V2 = mkV2 "tolerar" ; --auto
lin toll_N = mkN "peatge" masculine ; --auto
lin tomato_N = mkN "tomàquet" masculine ; --auto
lin tombola_N = mkN "tómbola" feminine ; --auto
lin tomorrow_Adv = mkAdv "demà" ;
lin ton_N = mkN "tona" feminine ; --auto
lin tonal_A = mkA "tonal" ; --auto
lin tonality_N = mkN "tonalitat" feminine ; --auto
lin tone_N = mkN "to" masculine ; --auto
lin toneless_A = mkA "fluix" ; --auto
lin toner_N = mkN "tòner" masculine ; --auto
lin tongue_N = L.tongue_N ;
lin tonic_A = mkA "tònic" ; --auto
lin tonight_Adv = mkAdv "aquesta nit" ;
lin tonnage_N = mkN "arqueig" masculine ; --auto
lin tonne_N = mkN "tona" feminine ; --auto
lin tonsil_N = mkN "amígdala" feminine ; --auto
lin too_AdA = mkAdv "també" ; --auto
lin too_Adv = mkAdv "també" ;
lin tool_N = mkN "eina" feminine ; --auto
lin tooth_N = L.tooth_N ;
lin toothache_N = mkN "mal de queixal" masculine ; --auto
lin toothbrush_N = mkN "raspall de dents" masculine ; --auto
lin toothed_A = mkA "dentat" ; --auto
lin toothless_A = mkA "desdentegat" ; --auto
lin toothpaste_N = mkN "dentifrici" masculine ; --auto
lin toothpick_N = mkN "escuradents" masculine | mkN "escuradents" masculine ; --auto
lin top_N = mkN "capdamunt" masculine ;--split (mountain) mkN "cim" masculine ;
lin top_V2 = mkV2 "coronar" ; --auto
lin topic_N = mkN "tema" masculine ; --auto
lin topical_A = mkA "tòpic" ; --auto
lin topmast_N = mkN "masteler" masculine ; --auto
lin topographical_A = mkA "topogràfic" ; --auto
lin topography_N = mkN "topografia" feminine ; --auto
lin topological_A = mkA "topològic" ; --auto
lin topology_N = mkN "topologia" feminine ; --auto
lin toponymy_N = mkN "toponímia" feminine ; --auto
lin topping_N = mkN "escapça" feminine ; --auto
lin torch_1_N = variants {} ; --auto
lin torch_2_N = mkN "llanterna" feminine ; --auto
lin torch_3_N = variants {} ; --auto
lin torment_N = mkN "turment" masculine ; --auto
lin tornado_N = mkN "tornado" masculine ; --auto
lin toroid_N = mkN "toroide" feminine ; --auto
lin torpedo_N = mkN "torpede" masculine ; --auto
lin torrent_N = mkN "torrent" masculine ; --auto
lin torrential_A = mkA "torrencial" ; --auto
lin torsion_N = mkN "torsió" feminine ; --auto
lin torticollis_N = mkN "torticoli" masculine ; --auto
lin tortuous_A = mkA "tortuós" ; --auto
lin torture_N = mkN "tortura" feminine ; --auto
lin torture_V2 = mkV2 "torturar" ; --auto
lin total_A = mkA "total" ;
lin total_N = mkN "total" masculine ; --auto
lin totalitarian_A = mkA "totalitari" ; --auto
lin totalitarianism_N = mkN "totalitarisme" masculine ; --auto
lin totem_N = mkN "tòtem" masculine ; --auto
lin totemism_N = mkN "totemisme" masculine ; --auto
lin touch_N = mkN "tacte" masculine ; --auto
lin touch_V = mkV "tocar" ;
lin touch_V2 = mkV2 (mkV "tocar") ;
lin touch_down_V = advV OP_touch_V OP_down_Adv ; -- guess-p-verb
lin touch_for_V3 = variants {} ; -- guess-p-verb
lin touch_off_V2 = prepV2 OP_touch_V OP_off_Prep ; -- guess-p-verb
lin touch_on_V2 = prepV2 OP_touch_V OP_on_Prep ; -- guess-p-verb
lin touch_type_V = variants {} ; -- guess-p-verb
lin touch_up_V2 = prepV2 OP_touch_V OP_up_Prep ; -- guess-p-verb
lin touch_upon_V2 = prepV2 OP_touch_V OP_upon_Prep ; -- guess-p-verb
lin tough_A = mkA "dur" ; --auto
lin toughen_V = mkV "endurir" ; --auto
lin toughen_V2 = mkV2 "endurir" ; --auto
lin tour_N = mkN "gira" feminine | mkN "visita" feminine ; --auto
lin tour_V = mkV "anar de viatge" ; --auto
lin tourism_N = mkN "turisme" masculine ; --auto
lin tourist_N = mkN "turista" ; --auto
lin tourmaline_N = mkN "turmalina" feminine ; --auto
lin tournament_N = mkN "torneig" masculine ; --auto
lin tourniquet_N = mkN "torniquet" masculine ; --auto
lin tow_V2 = mkV2 "remolcar" ; --auto
lin toward_Prep = mkPrep "cap a" ; --auto
lin towards_Prep = mkPrep "cap a" ;
lin towel_N = mkN "tovallola" feminine ; --auto
lin tower_N = mkN "torre" feminine ; --auto
lin town_N = mkN "poble" masculine ;
lin toxic_A = mkA "tòxic" ; --auto
lin toxicologist_N = mkN "toxicòleg" feminine | mkN "toxicòleg" masculine ; --auto
lin toxicology_N = mkN "toxicologia" feminine ; --auto
lin toxin_N = mkN "toxina" feminine ; --auto
lin toxoplasmosis_N = mkN "toxoplasmosi" feminine ; --auto
lin toy_N = mkN "joguina" feminine ; --auto
lin trabecula_N = mkN "trabècula" feminine ; --auto
lin trace_N = mkN "traça" feminine ; --auto
lin trace_V = mkV "localitzar" | mkV "traçar" ; --auto
lin trace_V2 = mkV2 "localitzar" | mkV2 "traçar" ; --auto
lin traceable_A = mkA "localitzable" ; --auto
lin tracheal_A = mkA "traqueal" ; --auto
lin tracheostomy_N = mkN "traqueostomia" feminine ; --auto
lin trachoma_N = mkN "tracoma" masculine ; --auto
lin track_N = mkN "via" feminine ; --split "petjada" (train vs. foot)
lin track_V = mkV "seguir" ; --auto
lin track_V2 = mkV2 "seguir" ; --auto
lin tracker_N = mkN "rastrejador" | mkN "rastrejador" ; --auto
lin tractability_N = mkN "tractabilitat" feminine ; --auto
lin traction_N = mkN "tracció" feminine ; --auto
lin tractive_A = mkA "tractor" ; --auto
lin tractor_N = mkN "tractor" masculine ; --auto
lin trade_N = mkN "comerç" masculine ;
lin trade_V = mkV "comerciar" ; --auto
lin trade_V2 = mkV2 "comerciar" ; --auto
lin trade_away_V = advV OP_trade_V OP_away_Adv ; -- guess-p-verb
lin trade_down_V = advV OP_trade_V OP_down_Adv ; -- guess-p-verb
lin trade_in_V2 = prepV2 OP_trade_V OP_in_Prep ; -- guess-p-verb
lin trade_off_V2 = prepV2 OP_trade_V OP_off_Prep ; -- guess-p-verb
lin trade_on_V2 = prepV2 OP_trade_V OP_on_Prep ; -- guess-p-verb
lin trade_union_N = mkN "sindicat" masculine ; --auto
lin trade_unionist_N = mkN "sindicalista" ; --auto
lin trade_up_V = advV OP_trade_V OP_up_Adv ; -- guess-p-verb
lin trade_upon_V2 = prepV2 OP_trade_V OP_upon_Prep ; -- guess-p-verb
lin trademark_N = mkN "marca" feminine ; --auto
lin trader_N = mkN "comerciant" ; --auto
lin trading_N = mkN "comerç" masculine ; --auto
lin tradition_N = mkN "tradició" feminine ;
lin traditional_A = mkA "tradicional" ;
lin traditionalism_N = mkN "tradicionalisme" masculine ; --auto
lin traditionalist_N = mkN "tradicionalista" ; --auto
lin traditionalistic_A = mkA "tradicionalista" ; --auto
lin traffic_N = mkN "trànsit" masculine ;
lin trafficker_N = mkN "traficant" ; --auto
lin tragedy_N = mkN "tragèdia" feminine ; --auto
lin tragic_A = mkA "tràgic" ; --auto
lin tragus_N = mkN "trague" masculine ; --auto
lin trail_N = mkN "deixant" masculine ; --auto
lin trailer_N = mkN "tràiler" masculine ; --auto
lin train_N = L.train_N ;
lin train_V = mkV "entrenar" ;
lin train_V2 = mkV2 (mkV "entrenar") ;
lin train_V2V = mkV2V (mkV "entrenar") ParadigmsCat.accusative (mkPrep "per") ;
lin train_up_V2 = prepV2 OP_train_V OP_up_Prep ; -- guess-p-verb
lin traineeFem_N = variants {} ; ---- sense to be split
lin traineeMasc_N = variants {} ; ---- sense to be split
lin trainer_N = mkN "entrenador" ; --auto
lin training_N = mkN "entrenament" masculine ; --split "formació" (sports vs. work training)
lin tram_N = mkN "tramvia" masculine ; --auto
lin tram_car_N = mkN "tramvia" masculine ; --auto
lin tramp_N = mkN "mercant" masculine ; --auto
lin tramway_N = mkN "tramvia" masculine ; --auto
lin tranquillizer_N = mkN "tranquil·litzant" masculine ; --auto
lin transact_V2 = mkV2 "tramitar" ; --auto
lin transaction_N = mkN "transacció" feminine ; --auto
lin transatlantic_A = mkA "transatlàntic" ; --auto
lin transcendence_N = mkN "transcendència" feminine ; --auto
lin transcendental_A = mkA "transcendental" ; --auto
lin transcendentalism_N = mkN "transcendentalisme" masculine ; --auto
lin transcribe_V2 = mkV2 "transcriure" ; --auto
lin transcriber_N = mkN "transcriptor" feminine | mkN "transcriptor" masculine ; --auto
lin transcription_N = mkN "transcripció" feminine ; --auto
lin transfer_N = mkN "transbordament" masculine | mkN "transbord" masculine | mkN "transferència" feminine | mkN "trasllat" masculine ; --auto
lin transfer_V = mkV "fer transbord" | mkV "transferir" ; --auto
lin transform_V2 = mkV2 "transformar" ; --auto
lin transformation_N = mkN "transformació" feminine ; --auto
lin transformer_N = mkN "transformador" masculine ; --auto
lin transfusion_N = mkN "transfusió" feminine ; --auto
lin transgress_V = mkV "transgredir" ; --auto
lin transgress_V2 = mkV2 "transgredir" ; --auto
lin transgression_N = mkN "transgressió" feminine ; --auto
lin transgressor_N = mkN "transgressor" | mkN "transgressor" ; --auto
lin transient_A = mkA "transitori" ; --auto
lin transistor_N = mkN "transistor" masculine ; --auto
lin transition_N = mkN "transició" feminine ; --auto
lin transitivity_N = mkN "transitivitat" feminine ; --auto
lin transitory_A = mkA "transitori" ; --auto
lin translate_V = mkV "traduir" ; --auto
lin translate_V2 = mkV2 "traduir" ; --auto
lin translation_N = mkN "traducció" feminine ; --auto
lin translator_N = mkN "traductor" | mkN "traductor" ; --auto
lin transliterate_V2 = mkV2 "transliterar" ; --auto
lin translocation_N = mkN "translocació" feminine ; --auto
lin translucent_A = mkA "translúcid" ; --auto
lin transmission_N = mkN "transmissió" feminine ; --auto
lin transmit_V2 = mkV2 "transmetre" ; --auto
lin transmittance_N = mkN "transmitància" feminine ; --auto
lin transmitter_N = mkN "transmissor" masculine ; --auto
lin transmutation_N = mkN "transmutació" feminine ; --auto
lin transoceanic_A = mkA "transoceànic" ; --auto
lin transparency_N = mkN "transparència" feminine ; --auto
lin transparent_A = mkA "transparent" ; --auto
lin transpiration_N = mkN "transpiració" feminine ; --auto
lin transplant_V = mkV "trasplantar" ; --auto
lin transplant_V2 = mkV2 "trasplantar" ; --auto
lin transplantation_N = mkN "trasplantament" masculine ; --auto
lin transport_N = mkN "transport" masculine ;
lin transport_V2 = mkV2 "transportar" ; --auto
lin transportation_N = mkN "transport" masculine ; --auto
lin transporter_N = mkN "transbordador" | mkN "transbordador" ; --auto
lin transpose_V2 = mkV2 "transposar" ; --auto
lin transposition_N = mkN "transposició" feminine ; --auto
lin transposon_N = mkN "transposó" masculine ; --auto
lin transvestism_N = mkN "transvestisme" masculine ; --auto
lin trap_N = mkN "purgador" masculine | mkN "trampa" feminine ; --auto
lin trap_V = mkV "atrapar" ; --auto
lin trap_V2 = mkV2 "atrapar" ; --auto
lin trapeze_N = mkN "trapezi" masculine ; --auto
lin trapezohedron_N = mkN "trapezòedre" masculine ; --auto
lin trapezoid_N = mkN "trapezoide" masculine ; --auto
lin trapezoidal_A = mkA "trapezoïdal" ; --auto
lin trauma_N = mkN "trauma" masculine ; --auto
lin traumatic_A = mkA "traumàtic" ; --auto
lin traumatology_N = mkN "traumatologia" feminine ; --auto
lin travel_N = mkN "viatge" masculine ; --auto
lin travel_V = L.travel_V ;
lin travel_V2 = mkV2 (mkV "viatjar") ;
lin traveller_N = mkN "viatger" | mkN "viatger" ; --auto
lin travelling_N = mkN "tràveling" masculine ; --auto
lin traverse_N = mkN "travessada" feminine ; --auto
lin tray_N = mkN "safata" feminine ; --auto
lin treacherous_A = mkA "traïdor" ; --auto
lin tread_N = mkN "estesa" feminine ; --auto
lin tread_V = mkV "calcar" ; --auto
lin tread_V2 = mkV2 "calcar" ; --auto
lin treasonable_A = mkA "traïdor" ; --auto
lin treasure_N = mkN "tresor" masculine ; --auto
lin treasure_V2 = mkV2 "atresorar" ; --auto
lin treasurer_N = mkN "tresorer" | mkN "tresorer" ; --auto
lin treasury_N = mkN "ministeri d'hisenda" masculine ; --auto
lin treat_V = mkV "tractar" ;
lin treat_V2 = mkV2 (mkV "tractar") ;
lin treatment_N = mkN "tractament" masculine ;
lin treaty_N = mkN "tractat" masculine ; --auto
lin treble_A = mkA "triple" ; --auto
lin treble_N = mkN "aguts" masculine | mkN "aguts" masculine ; --auto
lin tree_N = L.tree_N ;
lin trek_N = mkN "caminada" feminine ; --auto
lin trellis_N = mkN "enreixat" masculine ; --auto
lin tremble_V = mkV "tremolar" ; --auto
lin tremendous_A = mkA "enorme" ; --auto
lin tremolite_N = mkN "tremolita" feminine ; --auto
lin tremor_N = mkN "tremolor" masculine ; --auto
lin trench_N = mkN "trinxera" feminine ; --auto
lin trend_N = mkN "tendència" feminine ; --auto
lin trial_N = mkN "assaig" masculine ; --split "judici" masc (test vs. court)
lin triangle_N = mkN "triangle" masculine ; --auto
lin triangular_A = mkA "triangular" ; --auto
lin triangulation_N = mkN "triangulació" feminine ; --auto
lin tribal_A = mkA "tribal" ; --auto
lin tribe_N = mkN "tribu" feminine ; --auto
lin tribune_N = mkN "tribú" masculine ; --auto
lin tributary_N = mkN "afluent" masculine ; --auto
lin tribute_N = mkN "tribut" masculine ; --auto
lin trichinosis_N = mkN "triquinosi" feminine ; --auto
lin trichomoniasis_N = mkN "tricomoniasi" feminine ; --auto
lin trichotomy_N = mkN "tricotomia" feminine ; --auto
lin trichroism_N = mkN "tricroisme" masculine ; --auto
lin trick_N = mkN "truc" masculine ; --auto
lin trick_V2 = mkV2 "burlar" ; --auto
lin tricky_A = mkA "delicat" ; --auto
lin triclinic_A = mkA "triclínic" ; --auto
lin tricycle_N = mkN "tricicle" masculine ; --auto
lin trifle_N = mkN "fotesa" feminine ; --auto
lin trigger_N = mkN "gallet" masculine ; --auto
lin trigger_V2 = mkV2 "provocar" ; --auto
lin triglyceride_N = mkN "triglicèrid" masculine ; --auto
lin trigonometric_A = mkA "trigonomètric" ; --auto
lin trigonometry_N = mkN "trigonometria" feminine ; --auto
lin trill_N = mkN "trinat" masculine ; --auto
lin trillion_N = mkN "bilió" masculine ; --auto
lin trilogy_N = mkN "trilogia" feminine ; --auto
lin trimer_N = mkN "trímer" masculine ; --auto
lin trimming_N = mkN "desbarbament" masculine ; --auto
lin trio_N = mkN "trio" masculine ; --auto
lin triode_N = mkN "tríode" masculine ; --auto
lin trip_N = mkN "viatge" masculine ; --auto
lin trip_V = mkV "ensopegar" ; --auto
lin triple_A = mkA "triple" ; --auto
lin triple_N = mkN "terna" feminine ; --auto
lin triptych_N = mkN "tríptic" masculine ; --auto
lin trismus_N = mkN "trisme" masculine ; --auto
lin trisomy_N = mkN "trisomia" feminine ; --auto
lin tritium_N = mkN "triti" masculine ; --auto
lin triton_N = mkN "tritó" masculine ; --auto
lin triumph_N = mkN "triomf" masculine ; --auto
lin triumph_V = mkV "triomfar" ; --auto
lin triumvirate_N = mkN "triumvirat" masculine ; --auto
lin trivial_A = mkA "de pa sucat amb oli" | mkA "trivial" ; --auto
lin trivium_N = mkN "trivi" masculine ; --auto
lin trochanter_N = mkN "trocànter" masculine ; --auto
lin troika_N = mkN "troica" feminine ; --auto
lin trojan_A = mkA "troià" ; --auto
lin trolleybus_N = mkN "troleibús" masculine ; --auto
lin trombone_N = mkN "trombó" masculine ; --auto
lin troop_N = mkN "tropa" feminine ; --auto
lin trophoblast_N = mkN "trofoblast" masculine ; --auto
lin trophozoite_N = mkN "trofozoït" masculine ; --auto
lin trophy_N = mkN "trofeu" masculine ; --auto
lin tropic_N = mkN "tròpic" masculine ; --auto
lin tropical_A = mkA "tropical" ; --auto
lin tropism_N = mkN "tropisme" masculine ; --auto
lin tropopause_N = mkN "tropopausa" feminine ; --auto
lin troposphere_N = mkN "troposfera" feminine ; --auto
lin trot_N = mkN "trot" masculine ; --auto
lin trouble_N = mkN "problema" masculine ;
lin troubled_A = mkA "turbulent" ; --auto
lin trousseau_N = mkN "aixovar" masculine ; --auto
lin trowel_N = mkN "aixadell" masculine ; --auto
lin truce_N = mkN "treva" feminine ; --auto
lin truck_N = mkN "camió" masculine ; --auto
lin true_A = mkA "vertader" | mkA "cert" ;
lin truncate_V2 = mkV2 "truncar" ; --auto
lin truncation_N = mkN "truncament" masculine ; --auto
lin trunk_N = mkN "portaequipatge" masculine | mkN "tronc" masculine ; --auto
lin trust_N = mkN "confiança" feminine ;
lin trustworthy_A = mkA "fidedigne" ; --auto
lin truth_N = mkN "veritat" feminine ;
lin truthful_A = mkA "veraç" ; --auto
lin try_V = mkV "intentar" ;--subcat, in catalan only V2 possible ;
lin try_V2 = mkV2 (mkV "provar") ; --split "tastar"
lin try_VV = deVV (mkV "intentar") ;
lin try_back_V = advV OP_try_V OP_back_Adv ; -- guess-p-verb
lin try_for_V2 = prepV2 OP_try_V OP_for_Prep ; -- guess-p-verb
lin try_it_on_V = variants {} ; -- guess-p-verb
lin try_on_V2 = prepV2 OP_try_V OP_on_Prep ; -- guess-p-verb
lin try_out_V = advV OP_try_V OP_out_Adv ; -- guess-p-verb
lin try_out_V2 = prepV2 OP_try_V OP_out_Prep ; -- guess-p-verb
lin try_out_for_V2 = prepV2 (advV OP_try_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin tub_N = mkN "cubell" masculine ; --auto
lin tuba_N = mkN "tuba" feminine ; --auto
lin tube_N = mkN "metro" masculine | mkN "tub" masculine ; --auto
lin tuber_N = mkN "tubèrcul" masculine ; --auto
lin tubercle_N = mkN "tubercle" masculine ; --auto
lin tuberculosis_N = mkN "tuberculosi" feminine ; --auto
lin tuberosity_N = mkN "tuberositat" feminine ; --auto
lin tubular_A = mkA "tubular" ; --auto
lin tubule_N = mkN "túbul" masculine ; --auto
lin tuck_V = mkV "entaforar" ; --auto
lin tuck_V2 = mkV2 "entaforar" ; --auto
lin tulip_N = mkN "tulipa" feminine ; --auto
lin tumor_N = mkN "tumor" masculine ; --auto
lin tumult_N = mkN "tumult" masculine ; --auto
lin tuna_N = mkN "tonyina" feminine ; --auto
lin tundra_N = mkN "tundra" feminine ; --auto
lin tune_N = mkN "tonada" feminine ; --auto
lin tuner_N = mkN "afinador" masculine ; --auto
lin tungsten_N = mkN "tungstè" masculine ; --auto
lin tunic_N = mkN "túnica" feminine ; --auto
lin tuning_N = mkN "sintonia" feminine ; --auto
lin tunnel_N = mkN "túnel" masculine ; --auto
lin turban_N = mkN "turbant" masculine ; --auto
lin turbidity_N = mkN "turbiditat" feminine ; --auto
lin turbine_N = mkN "turbina" feminine ; --auto
lin turbot_N = mkN "rèmol" masculine ; --auto
lin turbulence_N = mkN "turbulència" feminine ; --auto
lin turbulent_A = mkA "turbulent" ; --auto
lin tureen_N = mkN "sopera" feminine ; --auto
lin turkey_N = mkN "gall dindi" masculine ; --auto
lin turkishFem_N = variants {} ; ---- sense to be split
lin turkishMasc_N = variants {} ; ---- sense to be split
lin turkish_A = mkA "turc" ; --auto
lin turn_N = mkN "gir" masculine ; --split "torn" (turn a car vs turn in a game)
lin turn_V = L.turn_V ;
lin turn_V2 = mkV2 (mkV "girar") ;
lin turn_VA = mkVA (reflV (mkV "tornar")) ;
lin turn_against_V2 = prepV2 OP_turn_V OP_against_Prep ; -- guess-p-verb
lin turn_around_V2 = prepV2 OP_turn_V OP_around_Prep ; -- guess-p-verb
lin turn_away_V = advV OP_turn_V OP_away_Adv ; -- guess-p-verb
lin turn_away_V2 = mkV2 (advV OP_turn_V OP_away_Adv ) ; -- guess-p-verb
lin turn_back_V = advV OP_turn_V OP_back_Adv ; -- guess-p-verb
lin turn_down_V2 = prepV2 OP_turn_V OP_down_Prep ; -- guess-p-verb
lin turn_in_V = advV OP_turn_V OP_in_Adv ; -- guess-p-verb
lin turn_in_V2 = prepV2 OP_turn_V OP_in_Prep ; -- guess-p-verb
lin turn_into_V2 = prepV2 OP_turn_V OP_into_Prep ; -- guess-p-verb
lin turn_off_V2 = prepV2 OP_turn_V OP_off_Prep ; -- guess-p-verb
lin turn_on_V = advV OP_turn_V OP_on_Adv ; -- guess-p-verb
lin turn_on_V2 = prepV2 OP_turn_V OP_on_Prep ; -- guess-p-verb
lin turn_out_V = advV OP_turn_V OP_out_Adv ; -- guess-p-verb
lin turn_out_V2 = prepV2 OP_turn_V OP_out_Prep ; -- guess-p-verb
lin turn_over_V = advV OP_turn_V OP_over_Adv ; -- guess-p-verb
lin turn_over_V2 = prepV2 OP_turn_V OP_over_Prep ; -- guess-p-verb
lin turn_to_V2 = prepV2 OP_turn_V OP_to_Prep ; -- guess-p-verb
lin turn_up_V = advV OP_turn_V OP_up_Adv ; -- guess-p-verb
lin turn_up_V2 = prepV2 OP_turn_V OP_up_Prep ; -- guess-p-verb
lin turncoat_N = mkN "oportunista" ; --auto
lin turner_N = mkN "torner" feminine | mkN "torner" masculine ; --auto
lin turnery_N = mkN "torneria" feminine ; --auto
lin turning_N = mkN "tombant" masculine | mkN "tornejat" masculine ; --auto
lin turnip_N = mkN "nap" masculine ; --auto
lin turnover_N = mkN "facturació" feminine ; --auto
lin turntable_N = mkN "giradiscos" masculine | mkN "giradiscos" masculine ; --auto
lin turpentine_N = mkN "aiguarràs" masculine ; --auto
lin turquoise_N = mkN "turquesa" feminine ; --auto
lin turret_N = mkN "torreta" feminine ; --auto
lin turtle_N = mkN "tortuga" feminine ; --auto
lin tutor_N = mkN "tutor" | mkN "tutor" ; --auto
lin tuxedo_N = mkN "esmòquing" masculine ; --auto
lin twice_Adv = mkAdv "dues vegades" ; --auto
lin twig_N = mkN "branqueta" feminine ; --auto
lin twin_N = mkN "bessó" feminine | mkN "bessó" masculine ; --auto
lin twin_V2 = mkV2 "germanar" ; --auto
lin twist_N = mkN "gir" masculine | mkN "torsió" feminine ; --auto
lin twist_V2 = mkV2 "serpentejar" | mkV2 "tergiversar" | mkV2 "torçar" ; --auto
lin twofold_A = mkA "doble" ; --auto
lin tycoon_N = mkN "magnat" ; --auto
lin tympanic_A = mkA "timpànic" ; --auto
lin type_N = mkN "tipus" "tipus" masculine ;
lin type_V = mkV "escriure" ; --auto
lin type_V2 = mkV2 "escriure" ; --auto
lin typhoon_N = mkN "tifó" masculine ; --auto
lin typhus_N = mkN "tifus" masculine | mkN "tifus" masculine ; --auto
lin typical_1_A = variants {} ; ---- sense to be split
lin typical_2_A = variants {} ; ---- sense to be split
lin typical_3_A = variants {} ; ---- sense to be split
lin typification_N = mkN "tipificació" feminine ; --auto
lin typist_N = mkN "teclista" ; --auto
lin typology_N = mkN "tipologia" feminine ; --auto
lin tyrannical_A = mkA "tirànic" ; --auto
lin tyranny_N = mkN "tirania" feminine ; --auto
lin tyrant_N = mkN "tirà" | mkN "tirà" ; --auto
lin tyre_N = mkN "pneumàtic" masculine ; --auto
lin tzar_N = mkN "tsar" masculine ; --auto
lin ubiquity_N = mkN "ubiqüitat" feminine ; --auto
lin ugandan_A = mkA "ugandès" ; --auto
lin ugly_A = L.ugly_A ;
lin ulcer_N = mkN "úlcera" feminine ; --auto
lin ulceration_N = mkN "ulceració" feminine ; --auto
lin ultimate_A = mkA "definitiu" ; --auto
lin ultimatum_N = mkN "ultimàtum" masculine ; --auto
lin ultrasonic_A = mkA "ultrasònic" ; --auto
lin ultrasound_N = mkN "ultrasò" masculine ; --auto
lin ultraviolet_A = mkA "ultraviolat" ; --auto
lin ultraviolet_N = mkN "ultraviolat" masculine ; --auto
lin umbel_N = mkN "umbel·la" feminine ; --auto
lin umbilical_A = mkA "umbilical" ; --auto
lin umbrella_N = mkN "paraigua" masculine ; --auto
lin unable_A = mkA "incapaç" ; --auto
lin unacceptable_A = mkA "inacceptable" ; --auto
lin unambiguous_A = mkA "inequívoc" ; --auto
lin unanimity_N = mkN "unanimitat" feminine ; --auto
lin unanimous_A = mkA "unànime" ; --auto
lin unappealable_A = mkA "inapel·lable" ; --auto
lin unashamed_A = mkA "desvergonyit" ; --auto
lin unavailable_A = mkA "inutilitzable" ; --auto
lin unavoidable_A = mkA "inevitable" ; --auto
lin unaware_A = mkA "inconscient" ; --auto
lin unawares_Adv = mkAdv "per sorpresa" ; --auto
lin unbalance_V2 = mkV2 "desquadrar" ; --auto
lin unblock_V2 = mkV2 "desbloquejar" ; --auto
lin uncertain_A = mkA "incert" ; --auto
lin uncertainty_N = mkN "incertesa" feminine ; --auto
lin unchain_V2 = mkV2 "desencadenar" ; --auto
lin unchanged_A = mkA "inalterat" ; --auto
lin uncle_N = mkN "oncle" masculine ; --auto
lin uncomfortable_A = mkA "incòmode" ; --auto
lin unconditional_A = mkA "incondicional" ; --auto
lin unconnected_A = mkA "inconnex" ; --auto
lin unconsciousness_N = mkN "inconsciència" feminine ; --auto
lin unconstitutional_A = mkA "anticonstitucional" ; --auto
lin uncontrolled_A = mkA "incontrolat" ; --auto
lin uncooked_A = mkA "cru" ; --auto
lin uncultured_A = mkA "illetrat" ; --auto
lin undecagon_N = mkN "hendecàgon" masculine ; --auto
lin undecided_A = mkA "indecís" ; --auto
lin under_Adv = variants {} ; -- S.under_Prep ;
lin under_Prep = S.under_Prep ;
lin underdeveloped_A = mkA "subdesenvolupat" ; --auto
lin underdevelopment_N = mkN "subdesenvolupament" masculine ; --auto
lin undergo_V2 = mkV2 "experimentar" ; --auto
lin undergraduate_N = mkN "universitari" | mkN "universitari" ; --auto
lin underground_A = mkA "subterrani" ; --auto
lin underground_N = mkN "subterrani" masculine ; --auto
lin underline_V2 = mkV2 "subratllar" ; --auto
lin underlying_A = mkA "subjacent" ; --auto
lin undermine_V2 = mkV2 "soscavar" ; --auto
lin underneath_Adv = mkAdv "per sota" ; --auto
lin understand_V = verbV (atendre_8 "entendre") ;
lin understand_V2 = mkV2 (verbV (atendre_8 "entendre")) ;
lin understand_VS = mkVS (verbV (atendre_8 "entendre")) ;
lin understanding_N = mkN "entesa" feminine ;
lin understudyFem_N = variants {} ; ---- sense to be split
lin understudyMasc_N = variants {} ; ---- sense to be split
lin undertake_V2 = mkV2 "emprendre" ; --auto
lin undertaking_N = mkN "garantia" feminine | mkN "tasca" feminine ; --auto
lin undervaluation_N = mkN "menysvaloració" feminine ; --auto
lin undervalue_V2 = mkV2 "infravalorar" ; --auto
lin underwater_A = mkA "submarí" ; --auto
lin underwear_N = mkN "roba interior" feminine ; --auto
lin undesirable_A = mkA "indesitjable" ; --auto
lin undisciplined_A = mkA "indisciplinat" ; --auto
lin undo_V2 = mkV2 "desfer" ; --auto
lin undoubted_A = mkA "indubtable" ; --auto
lin undress_V = mkV "despullar" ; --auto
lin undress_V2 = mkV2 "despullar" ; --auto
lin undue_A = mkA "indegut" ; --auto
lin uneconomic_A = mkA "antieconòmic" ; --auto
lin uneducated_A = mkA "sense educació" ; --auto
lin unemployed_A = mkA "desocupat" | mkA "parat" ; --auto
lin unemployment_N = mkN "atur" masculine | mkN "desocupació" feminine ; --auto
lin unequal_A = mkA "desigual" ; --auto
lin unequalled_A = mkA "sense igual" ; --auto
lin uneven_1_A = mkA "desigual" ; --auto
lin uneven_2_A = mkA "desigual" ; --auto
lin unexpected_A = mkA "inesperat" ; --auto
lin unfair_A = mkA "injust" ; --auto
lin unfinished_A = mkA "inacabat" ; --auto
lin unfit_V2 = mkV2 "desajustar" ; --auto
lin unforeseen_A = mkA "imprevist" ; --auto
lin unforgivable_A = mkA "imperdonable" ; --auto
lin unfortunately_Adv = mkAdv "malauradament" ; --auto
lin unfounded_A = mkA "immotivat" ; --auto
lin ungrammatical_A = mkA "agramatical" ; --auto
lin ungulate_N = mkN "ungulat" masculine ; --auto
lin unhappiness_N = mkN "infelicitat" feminine ; --auto
lin unhappy_A = mkA "infeliç" ; --auto
lin unicellular_A = mkA "unicel·lular" ; --auto
lin unicorn_N = mkN "unicorn" masculine ; --auto
lin unidirectional_A = mkA "unidireccional" ; --auto
lin unification_N = mkN "unificació" feminine ; --auto
lin uniform_A = mkA "uniforme" ; --auto
lin uniform_N = mkN "uniforme" masculine ; --auto
lin uniformity_N = mkN "uniformitat" feminine ; --auto
lin unify_V2 = mkV2 "unificar" ; --auto
lin unilateral_A = mkA "unilateral" ; --auto
lin unimportance_N = mkN "insignificància" feminine ; --auto
lin unimportant_A = mkA "sense importància" ; --auto
lin uninhabited_A = mkA "inhabitat" ; --auto
lin uninsurable_A = mkA "inassegurable" ; --auto
lin unintelligent_A = mkA "inintel·ligent" ; --auto
lin unintelligibility_N = mkN "inintel·ligibilitat" feminine ; --auto
lin unintelligible_A = mkA "inintel·ligible" ; --auto
lin unintentional_A = mkA "involuntari" ; --auto
lin union_N = mkN "unió" feminine ;
lin unipolar_A = mkA "unipolar" ; --auto
lin unique_A = mkA "únic" ; --auto
lin uniqueness_N = mkN "unicitat" feminine ; --auto
lin unit_1_N = mkN "unitat" feminine ;
lin unit_2_N = mkN "unitat" feminine ;
lin unit_3_N = mkN "unitat" feminine ;
lin unit_4_N = mkN "unitat" feminine ;
lin unit_5_N = mkN "unitat" feminine ;
lin unit_6_N = mkN "unitat" feminine ;
lin unitarianism_N = mkN "unitarisme" masculine ; --auto
lin unitary_A = mkA "unitari" ; --auto
lin unite_V = mkV "unir" ; --auto
lin unite_V2 = mkV2 "unir" ; --auto
lin unity_N = mkN "unitat" feminine ; --auto
lin universal_A = mkA "universal" ; --auto
lin universalism_N = mkN "universalisme" masculine ; --auto
lin universality_N = mkN "universalitat" feminine ; --auto
lin universe_N = mkN "univers" masculine ; --auto
lin university_N = L.university_N ;
lin unkind_A = mkA "antipàtic" ; --auto
lin unknowable_A = mkA "incognoscible" ; --auto
lin unknown_A = mkA "desconegut" ; --auto
lin unless_Subj = mkSubj "si no és que" Indic ;
lin unlike_A = mkA "diferent" ; --auto
lin unlike_Prep = mkPrep "a diferència de" ; --auto
lin unlikely_A = mkA "inversemblant" ; --auto
lin unload_V = mkV "descarregar" ; --auto
lin unload_V2 = mkV2 "descarregar" ; --auto
lin unlucky_A = mkA "desafortunat" ; --auto
lin unmask_V = mkV "desemmascarar" ; --auto
lin unmask_V2 = mkV2 "desemmascarar" ; --auto
lin unmodifiable_A = mkA "immodificable" ; --auto
lin unnatural_A = mkA "antinatural" ; --auto
lin unnecessary_A = mkA "innecessari" ; --auto
lin unnoticed_A = mkA "inadvertit" ; --auto
lin unobserved_A = mkA "desapercebut" ; --auto
lin unofficial_A = mkA "oficiós" ; --auto
lin unpack_V = mkV "desempaquetar" ; --auto
lin unpack_V2 = mkV2 "desempaquetar" ; --auto
lin unpleasant_A = mkA "desagradable" ; --auto
lin unplug_V = mkV "desendollar" ; --auto
lin unplug_V2 = mkV2 "desendollar" ; --auto
lin unpopular_A = mkA "impopular" ; --auto
lin unpredictable_A = mkA "imprevisible" ; --auto
lin unprotected_A = mkA "desprotegit" ; --auto
lin unquestionable_A = mkA "inqüestionable" ; --auto
lin unreadable_A = mkA "illegible" ; --auto
lin unreal_A = mkA "irreal" ; --auto
lin unreality_N = mkN "irrealitat" feminine ; --auto
lin unrecognizable_A = mkA "irrecognoscible" ; --auto
lin unrelated_A = mkA "inconnex" ; --auto
lin unrest_N = mkN "malestar" masculine ; --auto
lin unripe_A = mkA "verd" ; --auto
lin unroll_V = mkV "desenrotllar" ; --auto
lin unroll_V2 = mkV2 "desenrotllar" ; --auto
lin unsatisfactory_A = mkA "insatisfactori" ; --auto
lin unsatisfied_A = mkA "insatisfet" ; --auto
lin unscrew_V = mkV "descaragolar" | mkV "descargolar" ; --auto
lin unscrew_V2 = mkV2 "descaragolar" | mkV2 "descargolar" ; --auto
lin unseen_A = mkA "ocult" ; --auto
lin unsociability_N = mkN "insociabilitat" feminine ; --auto
lin unsolved_A = mkA "no resolt" ; --auto
lin unstable_A = mkA "inestable" ; --auto
lin unsteadiness_N = mkN "inestabilitat" feminine ; --auto
lin unsuitable_A = mkA "inapropiat" ; --auto
lin unsure_A = mkA "insegur" ; --auto
lin unsuspecting_A = mkA "confiat" ; --auto
lin unthinkable_A = mkA "impensable" ; --auto
lin until_Prep = mkPrep "fins a" ;
lin until_Subj = mkSubj "fins que" Conjunct | mkSubj "fins que" Indic ;
lin unusual_A = mkA "insòlit" | mkA "inusual" ; --auto
lin unveil_V = mkV "descobrir" ; --auto
lin unveil_V2 = mkV2 "descobrir" ; --auto
lin unwanted_A = mkA "indesitjat" ; --auto
lin unwilling_A = mkA "poc disposat" ; --auto
lin unworthy_A = mkA "indigne" ; --auto
lin up_Adv = mkAdv "amunt" ;
lin up_Prep = mkPrep "amunt" ;
lin up_to_Prep = mkPrep "fins a" ; --auto
lin up_to_date_A = mkA "actualitzat" ; --auto
lin update_N = mkN "actualització" feminine ; --auto
lin update_V2 = mkV2 "actualitzar" ; --auto
lin upholster_V2 = mkV2 "entapissar" ; --auto
lin upholstery_N = mkN "tapisseria" feminine ; --auto
lin upland_N = mkN "serrat" masculine ; --auto
lin upon_Prep = mkPrep "a sobre de" ; --split "tan bon punt"
lin upper_A = mkA "superior" ; --auto
lin uppermost_Adv = mkAdv "a sobre" ; --auto
lin uprising_N = mkN "revolta" feminine ; --auto
lin upriver_Adv = mkAdv "riu amunt" ; --auto
lin uproar_N = mkN "esvalot" masculine ; --auto
lin upset_A = mkA "preocupat" ; --auto
lin upset_V = mkV "disgustar" | mkV "trastornar" ; --auto
lin upset_V2 = mkV2 "disgustar" | mkV2 "trastornar" ; --auto
lin upsetter_N = mkN "recalcadora" feminine ; --auto
lin upside_down_Adv = mkAdv "al revés" ; --auto
lin upstage_Adv = mkAdv "al fons de l'escenari" ; --auto
lin upstairs_Adv = mkAdv "al pis de dalt" ; --auto
lin upstream_Adv = mkAdv "riu amunt" ; --auto
lin upward_A = mkA "alcista" | mkA "ascendent" ; --auto
lin upward_Adv = mkAdv "a dalt" ; --auto
lin upwards_Adv = mkAdv "cap amunt" | mkAdv "enlaire" ; --auto
lin upwind_Adv = mkAdv "contra el vent" ; --auto
lin uranium_N = mkN "urani" masculine ; --auto
lin uranoplasty_N = mkN "uranoplàstia" feminine ; --auto
lin urban_A = mkA "urbà" ; --auto
lin ureter_N = mkN "urèter" masculine ; --auto
lin urethra_N = mkN "uretra" feminine ; --auto
lin urethral_A = mkA "uretral" ; --auto
lin urge_N = mkN "impuls" masculine ; --auto
lin urge_V2 = mkV2 "instar" ; --auto
lin urge_on_V2 = prepV2 (lin V OP_urge_V2) OP_on_Prep ; -- guess-p-verb
lin urge_upon_V2 = prepV2 (lin V OP_urge_V2) OP_upon_Prep ; -- guess-p-verb
lin urgency_N = mkN "urgència" feminine ; --auto
lin urgent_A = mkA "urgent" ; --auto
lin urinate_V = mkV "orinar" ; --auto
lin urine_N = mkN "orina" feminine ; --auto
lin urn_N = mkN "urna" feminine ; --auto
lin urobilinogen_N = mkN "urobilinogen" masculine ; --auto
lin urologist_N = mkN "uròleg" feminine | mkN "uròleg" masculine ; --auto
lin urology_N = mkN "urologia" feminine ; --auto
lin uruguayan_A = mkA "uruguaià" ; --auto
lin uruguayan_N = mkN "uruguaià" | mkN "uruguaià" ; --auto
lin usable_A = mkA "utilitzable" ; --auto
lin usage_N = mkN "ús" masculine ; --auto
lin use_N = mkN "utilitat" feminine ; --mkN "ús" masculine (utilitat: what it's used for, ús: how it's used)
lin use_V = mkV "utilitzar" ;
lin use_V2 = mkV2 (mkV "utilitzar") ; --TODO "fer servir" how to get these compounds?
lin use_VV = mkVV (mkV "soler") ; --"soler" verb defectiu. TODO BeschCat has a note saying it's wasn't found, so not implemented?
lin use_up_V = advV OP_use_V OP_up_Adv ; -- guess-p-verb
lin use_up_V2 = prepV2 OP_use_V OP_up_Prep ; -- guess-p-verb
lin useful_A = mkA "útil" ;
lin useless_A = mkA "inútil" ; --auto
lin userFem_N = variants {} ; ---- sense to be split
lin userMasc_N = variants {} ; ---- sense to be split
lin usual_A = mkA "normal" ;
lin usufruct_N = mkN "usdefruit" masculine ; --auto
lin usufructuary_N = mkN "usufructuari" | mkN "usufructuari" ; --auto
lin usurp_V2 = mkV2 "usurpar" ; --auto
lin usurper_N = mkN "usurpador" | mkN "usurpador" ; --auto
lin usury_N = mkN "usura" feminine ; --auto
lin utensil_N = mkN "estri" masculine ; --auto
lin uterine_A = mkA "uterí" ; --auto
lin utility_N = mkN "utilitat" feminine ; --auto
lin utopia_N = mkN "utopia" feminine ; --auto
lin utopian_A = mkA "utòpic" ; --auto
lin utterance_N = mkN "enunciació" feminine ; --auto
lin uvula_N = mkN "úvula" feminine ; --auto
lin uxoricide_N = mkN "uxoricidi" masculine ; --auto
lin vacancy_N = mkN "vacant" feminine ; --auto
lin vacant_A = mkA "vacant" ; --auto
lin vacation_N = mkN "vacances" feminine | mkN "vacances" feminine ; --auto
lin vaccination_N = mkN "vaccinació" feminine ; --auto
lin vaccine_N = mkN "vacuna" feminine ; --auto
lin vacillation_N = mkN "vacil·lació" feminine ; --auto
lin vacuole_N = mkN "vacúol" masculine ; --auto
lin vagabond_N = mkN "vagabund" | mkN "vagabund" ; --auto
lin vagina_N = mkN "vagina" feminine ; --auto
lin vaginal_A = mkA "vaginal" ; --auto
lin vague_A = mkA "imprecís" ; --auto
lin vain_A = mkA "vanitós" ; --auto
lin valence_N = mkN "valència" feminine ; --auto
lin valency_N = mkN "valència" feminine ; --auto
lin valid_A = mkA "vàlid" | mkA "vigent" ; --auto
lin validate_V2 = mkV2 "validar" ; --auto
lin validation_N = mkN "validació" feminine ; --auto
lin validity_N = mkN "validesa" feminine ; --auto
lin valley_N = mkN "aiguafons" masculine | mkN "vall" feminine ; --auto
lin valuable_A = mkA "valuós" ; --auto
lin valuation_N = mkN "taxació" feminine ; --auto
lin value_N = mkN "valor" masculine ;
lin value_V = mkV "valorar" ; --auto
lin value_V2 = mkV2 "valorar" ; --auto
lin vamp_N = mkN "vampiressa" feminine ; --auto
lin vampire_N = mkN "vampir" masculine ; --auto
lin van_N = mkN "camioneta" feminine | mkN "furgoneta" feminine | mkN "furgó" masculine ; --auto
lin vanadium_N = mkN "vanadi" masculine ; --auto
lin vandal_N = mkN "vàndal" masculine ; --auto
lin vandalism_N = mkN "vandalisme" masculine ; --auto
lin vanilla_N = mkN "vainilla" feminine ; --auto
lin vanity_N = mkN "vanitat" feminine ; --auto
lin vaporizer_N = mkN "evaporador" masculine ; --auto
lin vaporous_A = mkA "vaporós" ; --auto
lin vapour_N = mkN "vapor" masculine ; --auto
lin variability_N = mkN "variabilitat" feminine ; --auto
lin variable_A = mkA "variable" ; --auto
lin variable_N = mkN "variable" feminine ; --auto
lin variance_N = mkN "variància" feminine ; --auto
lin variant_N = mkN "variant" feminine ; --auto
lin variation_N = mkN "variació" feminine ; --auto
lin varied_A = mkA "divers" | mkA "variat" ; --auto
lin variegated_A = mkA "bigarrat" ; --auto
lin variety_1_N = mkN "varietat" feminine ;
lin variety_2_N = mkN "varietat" feminine ;
lin variolation_N = mkN "variolació" feminine ; --auto
lin various_A = mkA "diversos" ;
lin varnisher_N = mkN "envernissador" feminine | mkN "envernissador" masculine | mkN "vernissador" feminine | mkN "vernissador" masculine ; --auto
lin vary_V = mkV "variar" ;
lin vary_V2 = mkV2 (mkV "variar") ;
lin varying_A = mkA "variable" ; --auto
lin vascular_A = mkA "vascular" ; --auto
lin vase_N = mkN "gerro" masculine | mkN "pitxer" masculine ; --auto
lin vasodilation_N = mkN "vasodilatació" feminine ; --auto
lin vassal_N = mkN "vassall" masculine ; --auto
lin vassalage_N = mkN "vassallatge" masculine ; --auto
lin vast_A = mkA "vast" ; --auto
lin vastness_N = mkN "vastitud" feminine ; --auto
lin vat_N = mkN "tina" feminine ; --auto
lin vault_N = mkN "volta" feminine ; --auto
lin vector_N = mkN "vector" masculine ; --auto
lin vegetable_N = mkN "verdura" feminine ; --auto
lin vegetal_A = mkA "vegetal" ; --auto
lin vegetarianFem_N = variants {} ; ---- sense to be split
lin vegetarianMasc_N = variants {} ; ---- sense to be split
lin vegetarian_A = mkA "vegetarià" ; --auto
lin vegetation_N = mkN "vegetació" feminine ; --auto
lin vegetative_A = mkA "vegetatiu" ; --auto
lin vehement_A = mkA "vehement" ; --auto
lin vehicle_N = mkN "vehicle" ;
lin vehicular_A = mkA "vehicular" ; --auto
lin veil_N = mkN "vel" masculine ; --auto
lin vein_N = mkN "vena" feminine ; --auto
lin velocipede_N = mkN "velocípede" masculine ; --auto
lin velocity_N = mkN "velocitat" feminine ; --auto
lin velodrome_N = mkN "velòdrom" masculine ; --auto
lin velvet_N = mkN "vellut" masculine ; --auto
lin vendor_N = mkN "venedor" masculine ; --auto
lin venerable_A = mkA "venerable" ; --auto
lin venerate_V2 = mkV2 "venerar" ; --auto
lin venereologistFem_N = variants {} ; ---- sense to be split
lin venereologistMasc_N = variants {} ; ---- sense to be split
lin venetian_A = mkA "venecià" ; --auto
lin venezuelan_A = mkA "venezolà" ; --auto
lin venezuelan_N = mkN "veneçolà" | mkN "veneçolà" ; --auto
lin venial_A = mkA "venial" ; --auto
lin venous_A = mkA "venós" ; --auto
lin ventilate_V2 = mkV2 "ventilar" ; --auto
lin ventilation_N = mkN "ventilació" feminine ; --auto
lin ventral_A = mkA "ventral" ; --auto
lin ventricle_N = mkN "ventricle" masculine ; --auto
lin venture_N = mkN "aventura" feminine ; --auto
lin venue_N = mkN "local" masculine ; --auto
lin venule_N = mkN "vènula" feminine ; --auto
lin veracity_N = mkN "veracitat" feminine ; --auto
lin veranda_N = mkN "veranda" feminine ; --auto
lin verb_N = mkN "verb" masculine ; --auto
lin verbal_A = mkA "verbal" ; --auto
lin verbose_A = mkA "verbós" ; --auto
lin verbosity_N = mkN "verbositat" feminine ; --auto
lin verdict_N = mkN "veredicte" masculine ; --auto
lin verifiable_A = mkA "verificable" ; --auto
lin verify_V2 = mkV2 "verificar" ; --auto
lin vernacular_A = mkA "vernacle" ; --auto
lin vernacular_N = mkN "llengua vernacle" feminine ; --auto
lin versatile_A = mkA "versàtil" ; --auto
lin verse_N = mkN "vers" masculine ; --auto
lin version_N = mkN "versió" feminine ;
lin vertebra_N = mkN "vèrtebra" feminine ; --auto
lin vertebral_A = mkA "vertebral" ; --auto
lin vertebrate_A = mkA "vertebrat" ; --auto
lin vertebrate_N = mkN "vertebrat" masculine ; --auto
lin vertical_A = mkA "vertical" ; --auto
lin vertiginous_A = mkA "vertiginós" ; --auto
lin very_A = mkA "molt" ;
lin vesical_A = mkA "vesical" ; --auto
lin vesicle_N = mkN "vesícula" feminine ; --auto
lin vessel_N = mkN "vaixell" masculine ; --auto
lin vestibular_A = mkA "vestibular" ; --auto
lin vesuvianite_N = mkN "vesuvianita" feminine ; --auto
lin vetch_N = mkN "veça" feminine ; --auto
lin veteran_N = mkN "veterà" | mkN "veterà" ; --auto
lin veterinarian_N = mkN "veterinari" | mkN "veterinari" ; --auto
lin veterinary_A = mkA "veterinari" ; --auto
lin vexation_N = mkN "vexació" feminine ; --auto
lin via_Prep = mkPrep "via" ; --auto
lin viability_N = mkN "viabilitat" feminine ; --auto
lin viable_A = mkA "viable" ; --auto
lin viaduct_N = mkN "viaducte" masculine ; --auto
lin vibrant_A = mkA "vibrant" ; --auto
lin vibrate_V = mkV "vibrar" ; --auto
lin vibrate_V2 = mkV2 "vibrar" ; --auto
lin vibration_N = mkN "vibració" feminine ; --auto
lin vibrator_N = mkN "vibrador" masculine ; --auto
lin vibratory_A = mkA "vibratori" ; --auto
lin vicar_N = mkN "vicari" masculine ; --auto
lin vicarious_A = mkA "vicari" ; --auto
lin vice_N = mkN "vici" masculine ; --auto
lin vice_president_N = mkN "vicepresident" ; --auto
lin vice_versa_Adv = mkAdv "viceversa" ; --auto
lin viceroy_N = mkN "virrei" masculine ; --auto
lin vicinity_N = mkN "proximitat" feminine ; --auto
lin vicious_A = mkA "viciós" ; --auto
lin victim_N = mkN "víctima" feminine ;
lin victorian_A = mkA "victorià" ; --auto
lin victorious_A = mkA "victoriós" ; --auto
lin victory_N = mkN "victòria" feminine ; --auto
lin video_N = mkN "vídeo" masculine ;
lin videocassette_N = mkN "videocasset" masculine ; --auto
lin videodisk_N = mkN "videodisc" masculine ; --auto
lin vietnamese_A = mkA "vietnamita" ; --auto
lin vietnamese_N = mkN "vietnamita" ; --auto
lin view_1_N = mkN "vista" feminine ; -- mkN "paisatge"
lin view_2_N = mkN "vista" feminine ; -- mkN "paisatge"
lin view_V2 = mkV2 "veure" ; --auto
lin viewer_N = mkN "espectador" feminine | mkN "espectador" masculine ; --auto
lin viewpoint_N = mkN "punt de vista" masculine ; --auto
lin vigorous_A = mkA "vigorós" ; --auto
lin vigour_N = mkN "vigor" masculine ; --auto
lin vile_A = mkA "vil" ; --auto
lin villa_N = mkN "vil·la" feminine ; --auto
lin village_N = L.village_N ;
lin vinaigrette_N = mkN "vinagreta" feminine ; --auto
lin vine_N = mkN "parra" feminine ; --auto
lin vinegar_N = mkN "vinagre" masculine ; --auto
lin vineyard_N = mkN "vinya" feminine ; --auto
lin vintage_N = mkN "verema" feminine ; --auto
lin vintager_N = mkN "veremador" feminine | mkN "veremador" masculine ; --auto
lin vinyl_N = mkN "vinil" masculine ; --auto
lin viola_N = mkN "viola" feminine ; --auto
lin violence_N = mkN "violència" feminine ; --auto
lin violent_A = mkA "violent" ; --auto
lin violet_N = mkN "violat" masculine ; --auto
lin violin_N = mkN "violí" masculine ; --auto
lin violinistFem_N = variants {} ; ---- sense to be split
lin violinistMasc_N = variants {} ; ---- sense to be split
lin violistFem_N = variants {} ; ---- sense to be split
lin violistMasc_N = variants {} ; ---- sense to be split
lin virgin_A = mkA "verge" ; --auto
lin virgin_N = mkN "verge" feminine ; --auto
lin virilism_N = mkN "virilisme" masculine ; --auto
lin viroid_N = mkN "viroide" masculine ; --auto
lin virology_N = mkN "virologia" feminine ; --auto
lin virtual_A = mkA "virtual" ; --auto
lin virtue_N = mkN "virtut" feminine ; --auto
lin virtuosity_N = mkN "virtuositat" feminine ; --auto
lin virulence_N = mkN "virulència" feminine ; --auto
lin virus_N = mkN "virus" masculine | mkN "virus" masculine ; --auto
lin visa_N = mkN "visat" masculine ; --auto
lin viscosity_N = mkN "viscositat" feminine ; --auto
lin viscous_A = mkA "viscós" ; --auto
lin visibility_N = mkN "visibilitat" feminine ; --auto
lin visible_A = mkA "visible" ; --auto
lin vision_N = mkN "visió" feminine ; --auto
lin visit_N = mkN "visita" ;
lin visit_V = mkV "visitar" ;
lin visit_V2 = mkV2 (mkV "visitar") ;
lin visitor_N = mkN "visitant" ;
lin visor_N = mkN "visera" feminine ; --auto
lin visual_A = mkA "visual" ; --auto
lin vital_A = mkA "vital" ; --auto
lin vitalist_N = mkN "vitalista" ; --auto
lin vitality_N = mkN "vitalitat" feminine ; --auto
lin vitamin_N = mkN "vitamina" feminine ; --auto
lin viticulture_N = mkN "viticultura" feminine ; --auto
lin vitrectomy_N = mkN "vitrectomia" feminine ; --auto
lin vitrification_N = mkN "vitrificació" feminine ; --auto
lin vituperation_N = mkN "vituperació" feminine ; --auto
lin vivacity_N = mkN "vivacitat" feminine ; --auto
lin vivid_A = mkA "vívid" ; --auto
lin viviparous_A = mkA "vivípar" ; --auto
lin vivisection_N = mkN "vivisecció" feminine ; --auto
lin vizier_N = mkN "visir" masculine ; --auto
lin vocabulary_N = mkN "vocabulari" masculine ; --auto
lin vocal_A = mkA "vocal" ; --auto
lin vocalic_A = mkA "vocàlic" ; --auto
lin vocalist_N = mkN "vocalista" ; --auto
lin vocation_N = mkN "vocació" feminine ; --auto
lin vocational_A = mkA "vocacional" ; --auto
lin vocative_N = mkN "vocatiu" masculine ; --auto
lin vodka_N = mkN "vodka" masculine ; --auto
lin voice_N = mkN "veu" feminine ;
lin volatile_A = mkA "volàtil" ; --auto
lin volatility_N = mkN "volatilitat" feminine ; --auto
lin volcanic_A = mkA "volcànic" ; --auto
lin volcano_N = mkN "volcà" masculine ; --auto
lin volleyball_N = mkN "voleibol" masculine ; --auto
lin volt_N = mkN "volt" masculine ; --auto
lin voltage_N = mkN "voltatge" masculine ; --auto
lin voltmeter_N = mkN "voltímetre" masculine ; --auto
lin volume_N = mkN "volum" masculine ;
lin volumeter_N = mkN "volúmetre" masculine ; --auto
lin volumetric_A = mkA "volumètric" ; --auto
lin voluntary_A = mkA "voluntari" ; --auto
lin volunteerFem_N = variants {} ; ---- sense to be split
lin volunteerMasc_N = variants {} ; ---- sense to be split
lin vomit_N = mkN "vòmit" masculine ; --auto
lin vomit_V = mkV "vomitar" ; --auto
lin vomit_V2 = mkV2 "vomitar" ; --auto
lin vote_N = mkN "vot" masculine ;
lin vote_V = mkV "votar" ; --auto
lin vote_V2 = mkV2 "votar" ; --auto
lin vote_down_V = advV OP_vote_V OP_down_Adv ; -- guess-p-verb
lin voter_N = mkN "votant" ; --auto
lin vow_V2 = mkV2 "jurar" ; --auto
lin vowel_N = mkN "vocal" feminine ; --auto
lin voyage_N = mkN "viatge" masculine ; --auto
lin voyeurism_N = mkN "escopofília" feminine | mkN "voyeurisme" masculine ; --auto
lin vulgar_A = mkA "vulgar" ; --auto
lin vulgarity_N = mkN "vulgaritat" feminine ; --auto
lin vulnerability_N = mkN "vulnerabilitat" feminine ; --auto
lin vulnerable_A = mkA "vulnerable" ; --auto
lin vulture_N = mkN "voltor" masculine ; --auto
lin vulva_N = mkN "vulva" feminine ; --auto
lin vulvectomy_N = mkN "vulvectomia" feminine ; --auto
lin wafer_N = mkN "oblia" feminine ; --auto
lin waffle_N = mkN "xerrameca" feminine ; --auto
lin wage_N = mkN "sou" masculine ;
lin wagon_N = mkN "carro" masculine ; --auto
lin wail_N = mkN "lament" masculine ; --auto
lin wainscot_N = mkN "arrimador" masculine ; --auto
lin waist_N = mkN "cintura" feminine ; --auto
lin waistband_N = mkN "cinturilla" feminine ; --auto
lin wait_V = mkV "esperar" ;
lin wait_V2 = L.wait_V2 ;
lin wait_VV = mkVV (mkV "esperar") ;
lin wait_about_V = advV OP_wait_V OP_about_Adv ; -- guess-p-verb
lin wait_around_V = advV OP_wait_V OP_around_Adv ; -- guess-p-verb
lin wait_behind_V = advV OP_wait_V OP_behind_Adv ; -- guess-p-verb
lin wait_in_V = advV OP_wait_V OP_in_Adv ; -- guess-p-verb
lin wait_on_V2 = prepV2 OP_wait_V OP_on_Prep ; -- guess-p-verb
lin wait_out_V2 = prepV2 OP_wait_V OP_out_Prep ; -- guess-p-verb
lin wait_up_V = advV OP_wait_V OP_up_Adv ; -- guess-p-verb
lin wait_up_for_V2 = prepV2 (advV OP_wait_V OP_up_Adv ) OP_for_Prep ; -- guess-p-verb
lin wait_upon_V2 = prepV2 OP_wait_V OP_upon_Prep ; -- guess-p-verb
lin waiter_N = mkN "cambrer" masculine ; --auto
lin waitress_N = mkN "cambrer" feminine ; --auto
lin wake_V = mkV "despertar" ; --auto
lin wake_V2 = mkV2 "despertar" ; --auto
lin wake_up_V = advV OP_wake_V OP_up_Adv ; -- guess-p-verb
lin wake_up_V2 = prepV2 OP_wake_V OP_up_Prep ; -- guess-p-verb
lin walk_N = mkN "passeig" masculine | mkN "passejada" feminine ; --auto
lin walk_V = L.walk_V ;
lin walk_V2 = mkV2 (mkV "caminar") ;
lin walk_away_from_V2 = prepV2 (advV OP_walk_V OP_away_Adv ) OP_from_Prep ; -- guess-p-verb
lin walk_away_with_V2 = prepV2 (advV OP_walk_V OP_away_Adv ) OP_with_Prep ; -- guess-p-verb
lin walk_back_from_V2 = prepV2 (advV OP_walk_V OP_back_Adv ) OP_from_Prep ; -- guess-p-verb
lin walk_by_V = advV OP_walk_V OP_by_Adv ; -- guess-p-verb
lin walk_in_V = advV OP_walk_V OP_in_Adv ; -- guess-p-verb
lin walk_in_on_V2 = prepV2 (advV OP_walk_V OP_in_Adv ) OP_on_Prep ; -- guess-p-verb
lin walk_into_V2 = prepV2 OP_walk_V OP_into_Prep ; -- guess-p-verb
lin walk_off_V2 = prepV2 OP_walk_V OP_off_Prep ; -- guess-p-verb
lin walk_off_with_V2 = prepV2 (advV OP_walk_V OP_off_Adv ) OP_with_Prep ; -- guess-p-verb
lin walk_on_V = advV OP_walk_V OP_on_Adv ; -- guess-p-verb
lin walk_out_V = advV OP_walk_V OP_out_Adv ; -- guess-p-verb
lin walk_out_on_V2 = prepV2 (advV OP_walk_V OP_out_Adv ) OP_on_Prep ; -- guess-p-verb
lin walk_through_V3 = variants {} ; -- guess-p-verb
lin walk_up_V = advV OP_walk_V OP_up_Adv ; -- guess-p-verb
lin walking_N = mkN "excursionisme" masculine ; --auto
lin wall_N = mkN "paret" masculine ;
lin wall_V2 = mkV2 "emmurallar" ; --auto
lin wallet_N = mkN "cartera" feminine ; --auto
lin walnut_N = mkN "nou" feminine ; --auto
lin walrus_N = mkN "morsa" feminine ; --auto
lin wand_N = mkN "vareta" feminine ; --auto
lin wander_V = mkV "vagar" ; --auto
lin wander_off_V = advV OP_wander_V OP_off_Adv ; -- guess-p-verb
lin wane_V = mkV "decaure" ; --auto
lin want_V = verbV (voler_120 "voler") ;
lin want_V2 = mkV2 (verbV (voler_120 "voler")) ;
lin want_V2V = mkV2V (verbV (voler_120 "voler")) ParadigmsCat.accusative ParadigmsCat.accusative ; --subcat, only VV possible
lin want_VV = S.want_VV ;
lin want_in_V = advV OP_want_V OP_in_Adv ; -- guess-p-verb
lin want_out_V = advV OP_want_V OP_out_Adv ; -- guess-p-verb
lin wanton_A = mkA "maliciós" ; --auto
lin war_N = L.war_N ;
lin warden_N = mkN "alcaid" masculine ; --auto
lin wardrobe_N = mkN "armari" masculine | mkN "vestuari" masculine ; --auto
lin warehouse_N = mkN "magatzem" masculine ; --auto
lin warm_A = L.warm_A ;
lin warm_V = mkV "animar" ; --auto
lin warm_V2 = mkV2 "animar" ; --auto
lin warmongering_N = mkN "bel·licisme" masculine ; --auto
lin warmth_N = mkN "escalfor" feminine ; --auto
lin warn_V = mkV "avisar" ;
lin warn_V2 = mkV2 (mkV "avisar") ;
lin warn_V2V = mkV2V (mkV "avisar") ParadigmsCat.accusative ParadigmsCat.genitive ;
lin warn_VS = mkVS (mkV "avisar") ;
lin warning_N = mkN "advertència" feminine | mkN "advertiment" masculine | mkN "avís" masculine ; --auto
lin warp_N = mkN "ordit" masculine ; --auto
lin warranty_N = mkN "garantia" feminine ; --auto
lin warrior_N = mkN "guerrer" | mkN "guerrer" ; --auto
lin wart_N = mkN "berruga" feminine ; --auto
lin wary_A = mkA "caut" ; --auto
lin wash_N = mkN "rentada" feminine ; --auto
lin wash_V = variants {} ; -- L.wash_V2 ;
lin wash_V2 = L.wash_V2 ;
lin wash_away_V2 = mkV2 (advV OP_wash_V OP_away_Adv ) ; -- guess-p-verb
lin wash_down_V2 = prepV2 OP_wash_V OP_down_Prep ; -- guess-p-verb
lin wash_out_V2 = prepV2 OP_wash_V OP_out_Prep ; -- guess-p-verb
lin wash_over_V2 = prepV2 OP_wash_V OP_over_Prep ; -- guess-p-verb
lin wash_up_V = advV OP_wash_V OP_up_Adv ; -- guess-p-verb
lin wash_up_V2 = prepV2 OP_wash_V OP_up_Prep ; -- guess-p-verb
lin washbowl_N = mkN "gibrell" masculine | mkN "llibrell" masculine ; --auto
lin washing_N = mkN "rentatge" masculine | mkN "rentat" masculine ; --auto
lin washing_machine_N = mkN "llavadora" feminine | mkN "rentadora" feminine ; --auto
lin waste_N = mkN "malbaratament" masculine | mkN "residu" masculine | mkN "residu" masculine ; --auto
lin waste_V = mkV "malgastar" ; --auto
lin waste_V2 = mkV2 "malgastar" ; --auto
lin waste_away_V = advV OP_waste_V OP_away_Adv ; -- guess-p-verb
lin wasteful_A = mkA "malgastador" ; --auto
lin waster_N = mkN "malgastador" | mkN "malgastador" ; --auto
lin watch_1_V2 = L.watch_V2 ;
lin watch_2_V2 = L.watch_V2 ;
lin watch_N = mkN "rellotge" masculine ; --auto
lin watch_V = mkV "mirar" | mkV "vigilar" ;
lin watch_V2V = mkV2V (mkV "mirar") ParadigmsCat.accusative ParadigmsCat.accusative ; --subcat
lin watch_VS = mkVS (mkV "procurar") ;
lin watch_out_V = advV OP_watch_V OP_out_Adv ; -- guess-p-verb
lin watch_out_for_V2 = prepV2 (advV OP_watch_V OP_out_Adv ) OP_for_Prep ; -- guess-p-verb
lin watch_over_V2 = prepV2 OP_watch_V OP_over_Prep ; -- guess-p-verb
lin watchdog_N = mkN "vigilant" ; --auto
lin watcherFem_N = variants {} ; ---- sense to be split
lin watcherMasc_N = variants {} ; ---- sense to be split
lin watchmaker_N = mkN "rellotger" feminine | mkN "rellotger" masculine ; --auto
lin watchtower_N = mkN "talaia" feminine ; --auto
lin water_N = L.water_N ;
lin water_V = mkV "abreurar" ; --auto
lin water_V2 = mkV2 "abreurar" ; --auto
lin watercolour_N = mkN "aquarel·la" feminine ; --auto
lin waterfall_N = mkN "cascada" feminine ; --auto
lin watering_N = mkN "reg" masculine ; --auto
lin watermelon_N = mkN "síndria" feminine ; --auto
lin waterproof_A = mkA "impermeable" ; --auto
lin watt_N = mkN "vat" masculine | mkN "watt" masculine ; --auto
lin wattmeter_N = mkN "wattímetre" masculine ; --auto
lin wave_N = mkN "onada" feminine | mkN "ona" feminine ; --auto
lin wave_V = mkV "agitar" | mkV "onejar" ; --auto
lin wave_V2 = mkV2 "agitar" | mkV2 "onejar" ; --auto
lin wave_aside_V2 = mkV2 (advV OP_wave_V OP_aside_Adv ) ; -- guess-p-verb
lin wave_away_V = advV OP_wave_V OP_away_Adv ; -- guess-p-verb
lin wave_down_V2 = prepV2 OP_wave_V OP_down_Prep ; -- guess-p-verb
lin wave_off_V2 = prepV2 OP_wave_V OP_off_Prep ; -- guess-p-verb
lin wave_on_V2 = prepV2 OP_wave_V OP_on_Prep ; -- guess-p-verb
lin wavelength_N = mkN "longitud d'ona" feminine ; --auto
lin wax_N = mkN "cera" feminine ; --auto
lin way_1_N = mkN "manera" feminine | mkN "mitjà" masculine ;
lin way_2_N = mkN "manera" feminine | mkN "mitjà" masculine ;
lin wayward_A = mkA "capritxós" ; --auto
lin weFem_Pron = optProDrop E.we8fem_Pron ;
lin we_Pron = optProDrop S.we_Pron ;
lin weak_A = mkA "dèbil" ; --auto
lin weaken_V = mkV "debilitar" ; --auto
lin weaken_V2 = mkV2 "debilitar" ; --auto
lin weakening_N = mkN "debilitament" masculine ; --auto
lin weakling_N = mkN "nyicris" | mkN "nyicris" ; --auto
lin weakness_N = mkN "debilitat" feminine | mkN "decaïment" masculine ; --auto
lin wealth_N = mkN "riquesa" feminine ; --auto
lin wealthy_A = mkA "ric" ; --auto
lin weaning_N = mkN "deslletament" masculine ; --auto
lin weapon_N = mkN "arma" feminine | mkN "arma" feminine ; --auto
lin wear_N = mkN "desgast" masculine ; --auto
lin wear_V = mkV (dur_45 "dur") ;
lin wear_V2 = mkV2 (mkV (dur_45 "dur")) ;
lin wear_away_V2 = mkV2 (advV OP_wear_V OP_away_Adv ) ; -- guess-p-verb
lin wear_down_V2 = prepV2 OP_wear_V OP_down_Prep ; -- guess-p-verb
lin wear_off_V = advV OP_wear_V OP_off_Adv ; -- guess-p-verb
lin wear_out_V = advV OP_wear_V OP_out_Adv ; -- guess-p-verb
lin wear_out_V2 = prepV2 OP_wear_V OP_out_Prep ; -- guess-p-verb
lin weather_N = mkN "temps" masculine | mkN "temps" masculine ; --auto
lin weather_station_N = mkN "estació meteorològica" feminine ; --auto
lin weathercock_N = mkN "penell" masculine ; --auto
lin weave_V = mkV "tramar" ; --auto
lin weave_V2 = mkV2 "tramar" ; --auto
lin weaverFem_N = variants {} ; ---- sense to be split
lin weaverMasc_N = variants {} ; ---- sense to be split
lin weaving_N = mkN "trenat" masculine ; --auto
lin web_1_N = variants {} ; ---- sense to be split
lin web_2_N = variants {} ; ---- sense to be split
lin website_N = mkN "pàgina web" feminine ; --auto
lin wedding_N = mkN "boda" feminine | mkN "casament" masculine | mkN "noces" feminine ; --auto
lin week_N = mkN "setmana" feminine ;
lin weekend_N = compN (mkN "cap") "de setmana" ;
lin weekly_A = mkA "setmanal" ; --auto
lin weekly_Adv = mkAdv "setmanalment" ; --auto
lin weep_V = mkV "plorar" ; --auto
lin weep_V2 = mkV2 "plorar" ; --auto
lin weevil_N = mkN "corc" masculine ; --auto
lin weigh_V = mkV "pesar" ; --auto
lin weigh_V2 = mkV2 "pesar" ; --auto
lin weight_N = mkN "pes" masculine ;
lin weightlifting_N = mkN "halterofília" feminine ; --auto
lin weird_A = mkA "estrany" ; --auto
lin welcome_A = mkA "benvingut" ; --auto
lin welcome_N = mkN "benvinguda" feminine ; --auto
lin welding_N = mkN "soldadura" feminine ; --auto
lin welfare_N = mkN "benestar" masculine ; --auto
lin well_Interj = mkInterj "bé" ;
lin welsh_A = mkA "gal·lès" ; --auto
lin werewolf_N = mkN "home llop" masculine ; --auto
lin west_A = mkA "de l'oest" | mkA "oest" ; --auto
lin west_Adv = mkAdv "cap a l'oest" ; --auto
lin west_N = mkN "oest" masculine ; --auto
lin western_A = mkA "occidental" ;
lin wet_A = L.wet_A ;
lin wet_V2 = mkV2 "mullar" ; --auto
lin whale_N = mkN "balena" feminine ; --auto
lin whaler_N = mkN "balener" feminine | mkN "balener" masculine ; --auto
lin wheat_N = mkN "blat" masculine ; --auto
lin wheel_N = mkN "roda" feminine | mkN "volant" masculine ; --auto
lin wheelbase_N = mkN "intereix" masculine ; --auto
lin when_IAdv = mkAdv "quan" ; --auto
lin when_Subj = S.when_Subj ;
lin whence_Adv = mkAdv "d'on" ; --auto
lin where_IAdv = mkAdv "a on" | mkAdv "on" ; --auto
lin where_Subj = mkSubj "on" Indic ;
lin wherever_Adv = mkAdv "onsevulga que" ; --auto
lin whether_Subj = ss "si" ** {m = Indic} ;
lin whey_N = mkN "sèrum de llet" masculine ; --auto
lin which_IQuant = S.which_IQuant ;
lin while_N = mkN "estona" feminine ; --auto
lin while_Subj = mkSubj "while" Conjunct ;
lin whim_N = mkN "caprici" masculine | mkN "capritx" masculine ; --auto
lin whip_N = mkN "fuet" masculine ; --auto
lin whiskey_N = mkN "whisky" masculine ; --auto
lin whisper_N = mkN "murmuri" masculine ; --auto
lin whisper_V = mkV "xiuxiuejar" ; --auto
lin whisper_V2 = mkV2 "xiuxiuejar" ; --auto
lin whistle_N = mkN "xiulet" masculine ; --auto
lin whistle_V = mkV "xiular" ; --auto
lin whistle_V2 = mkV2 "xiular" ; --auto
lin white_A = L.white_A ;
lin white_N = mkN "blanc" masculine ; --auto
lin whiting_N = mkN "maire" masculine ; --auto
lin whitish_A = mkA "blanquinós" ; --auto
lin whole_A = mkA "sencer" ;
lin whole_N = mkN "tot" ;
lin wholesale_A = mkA "majorista" ; --auto
lin wholesale_Adv = mkAdv "a l'engròs" ; --auto
lin wholesaler_N = mkN "majorista" ; --auto
lin whore_N = mkN "puta" feminine ; --auto
lin why_IAdv = mkAdv "per què" ; --auto
lin wicked_A = mkA "malvat" ; --auto
lin wide_A = L.wide_A ;
lin widen_V2 = mkV2 "eixamplar" ; --auto
lin widening_N = mkN "sobreample" masculine ; --auto
lin widespread_A = mkA "estès" ; --auto
lin widow_N = mkN "vidu" feminine ; --auto
lin widowed_A = mkA "vidu" ; --auto
lin widower_N = mkN "vidu" masculine ; --auto
lin widowhood_N = mkN "viduatge" masculine ; --auto
lin width_N = mkN "amplada" feminine | mkN "amplària" feminine ; --auto
lin wield_V2 = mkV2 "brandir" ; --auto
lin wife_N = L.wife_N ;
lin wild_A = mkA "salvatge" ; --auto
lin wildcat_N = mkN "gat fer" masculine | mkN "gat salvatge" masculine ; --auto
lin wildlife_N = mkN "flora i fauna" feminine ; --auto
lin wilful_A = mkA "obstinat" ; --auto
lin will_N = mkN "voluntat" feminine ; --split "testament" (the will to do vs. last will and testament)
lin willing_A = mkA "disposat" ; --auto
lin willingness_N = mkN "disposició" feminine | mkN "disposició" feminine ; --auto
lin willy_nilly_Adv = mkAdv "de grat o per força" ; --auto
lin win_V = mkV "guanyar" ;
lin win_V2 = L.win_V2 ;
lin win_back_V = advV OP_win_V OP_back_Adv ; -- guess-p-verb
lin win_down_V = advV OP_win_V OP_down_Adv ; -- guess-p-verb
lin win_over_V = advV OP_win_V OP_over_Adv ; -- guess-p-verb
lin win_up_V = advV OP_win_V OP_up_Adv ; -- guess-p-verb
lin wind_N = L.wind_N ;
lin wind_down_V = advV OP_wind_V OP_down_Adv ; -- guess-p-verb
lin wind_down_V2 = prepV2 OP_wind_V OP_down_Prep ; -- guess-p-verb
lin wind_on_V = advV OP_wind_V OP_on_Adv ; -- guess-p-verb
lin wind_up_V = advV OP_wind_V OP_up_Adv ; -- guess-p-verb
lin wind_up_V2 = prepV2 OP_wind_V OP_up_Prep ; -- guess-p-verb
lin window_N = L.window_N ;
lin windscreen_N = mkN "parabrisa" feminine ; --auto
lin windward_N = mkN "sobrevent" masculine ; --auto
lin windy_A = mkA "ventós" ; --auto
lin wine_N = L.wine_N ;
lin winery_N = mkN "bodega" feminine ; --auto
lin wing_N = L.wing_N ;
lin wink_N = mkN "ullet" masculine ; --auto
lin winner_N = mkN "guanyador" | mkN "guanyador" ; --auto
lin winning_A = mkA "guanyador" ; --auto
lin winter_N = mkN "hivern" masculine ;
lin wintry_A = mkA "hivernal" ; --auto
lin wipe_V = variants {} ; -- L.wipe_V2 ;
lin wipe_V2 = L.wipe_V2 ;
lin wipe_out_V = advV OP_wipe_V OP_out_Adv ; -- guess-p-verb
lin wipe_out_V2 = prepV2 OP_wipe_V OP_out_Prep ; -- guess-p-verb
lin wiper_N = mkN "eixugaparabrisa" feminine ; --auto
lin wire_N = mkN "cable" masculine | mkN "filferro" masculine | mkN "fil" masculine ; --auto
lin wireless_A = mkA "sense fil" ; --auto
lin wisdom_N = mkN "saviesa" feminine | mkN "seny" masculine ; --auto
lin wise_A = mkA "assenyat" | mkA "savi" ; --auto
lin wish_N = mkN "desig" masculine | mkN "voluntat" feminine ; --auto
lin wish_V = mkV "desitjar" ;
lin wish_V2 = mkV2 (mkV "desitjar") ;
lin wish_V2V = mkV2V (mkV "desitjar") ParadigmsCat.accusative ParadigmsCat.genitive ; --subcat should render as VS
lin wish_VS = mkVS (mkV "desitjar") ;
lin wish_VV = mkVV (mkV (voler_120 "voler")) ;
lin wit_N = mkN "enginy" masculine ; --auto
lin witch_N = mkN "bruixa" feminine ; --auto
lin witchcraft_N = mkN "bruixeria" feminine ; --auto
lin with_Prep = S.with_Prep ;
lin with_a_view_to_Prep = mkPrep "amb vista a" ; --auto
lin with_regard_to_Prep = mkPrep "amb relació a" | mkPrep "respecte a" ; --auto
lin withdraw_V = mkV "retirar" ; --auto
lin withdraw_V2 = mkV2 "retirar" ; --auto
lin withdrawal_N = mkN "retirada" feminine ; --auto
lin within_Adv = mkAdv "dins" | mkAdv "dintre" | mkAdv "endins" ; --auto
lin within_Prep = mkPrep "a dins de" | mkPrep "a l'interior de" ;
lin without_Prep = S.without_Prep ;
lin witless_A = mkA "curt" ; --auto
lin witness_N = mkN "testimoni" ; --auto
lin witness_V = mkV "presenciar" ; --auto
lin witness_V2 = mkV2 "presenciar" ; --auto
lin wizard_N = mkN "bruixot" masculine ; --auto
lin wobble_N = mkN "baldereig" masculine ; --auto
lin wolf_N = mkN "llop" feminine | mkN "llop" masculine ; --auto
lin wollastonite_N = mkN "wol·lastonita" feminine ; --auto
lin woman_N = L.woman_N ;
lin wonder_N = mkN "meravella" feminine ; --auto
lin wonder_V = reflV (mkV "preguntar") ;
lin wonder_VQ = L.wonder_VQ ;
lin wonderful_A = mkA "meravellós" ; --auto
lin wood_N = L.wood_N ;
lin wooden_A = mkA "de fusta" ; --auto
lin woodworm_N = mkN "corc" masculine ; --auto
lin woody_A = mkA "llenyós" ; --auto
lin wool_N = mkN "llana" feminine ; --auto
lin word_N = mkN "paraula" feminine ;
lin work_1_V = mkV "treballar" ;
lin work_2_V = mkV "treballar" ;
lin work_N = mkN "feina" feminine ;
lin work_V2 = mkV2 (mkV "treballar") ;
lin work_off_V2 = prepV2 OP_work_V OP_off_Prep ; -- guess-p-verb
lin work_on_V2 = prepV2 OP_work_V OP_on_Prep ; -- guess-p-verb
lin work_out_V = advV OP_work_V OP_out_Adv ; -- guess-p-verb
lin work_out_V2 = prepV2 OP_work_V OP_out_Prep ; -- guess-p-verb
lin work_over_V2 = prepV2 OP_work_V OP_over_Prep ; -- guess-p-verb
lin work_through_V2 = prepV2 OP_work_V OP_through_Prep ; -- guess-p-verb
lin work_together_V = advV OP_work_V OP_together_Adv ; -- guess-p-verb
lin work_up_V = advV OP_work_V OP_up_Adv ; -- guess-p-verb
lin workable_A = mkA "factible" ; --auto
lin workbench_N = mkN "taulell" masculine ; --auto
lin workday_N = mkN "dia de treball" masculine ; --auto
lin worker_N = mkN "treballador" | mkN "empleat" ;
lin workforce_N = mkN "mà d'obra" feminine ; --auto
lin working_A = mkA "treballador" ;
lin works_N = mkN "feina" feminine ;
lin workshop_N = mkN "taller" masculine ; --auto
lin workstation_N = mkN "estació de treball" feminine ; --auto
lin world_N = mkN "món" masculine ;
lin worldwide_Adv = mkAdv "a tot el món" ; --auto
lin worm_N = L.worm_N ;
lin worrisome_A = mkA "preocupant" ; --auto
lin worry_N = mkN "preocupació" feminine ; --auto
lin worry_V = reflV (mkV "preocupar") ;
lin worry_V2 = mkV2 (reflV (mkV "preocupar")) ParadigmsCat.genitive ;
lin worsen_V = mkV "empitjorar" ; --auto
lin worsen_V2 = mkV2 "empitjorar" ; --auto
lin worship_N = mkN "adoració" feminine | mkN "veneració" feminine ; --auto
lin worth_N = mkN "valor" masculine ; --auto
lin worthwhile_A = mkA "interessant" ; --auto
lin worthy_A = mkA "digne" ; --auto
lin wound_N = mkN "ferida" feminine ; --auto
lin wrap_V = mkV "embolicar" ; --auto
lin wrap_V2 = mkV2 "embolicar" ; --auto
lin wrapping_N = mkN "embolcall" masculine ; --auto
lin wrench_N = mkN "clau" feminine ; --auto
lin wrinkle_N = mkN "arruga" feminine ; --auto
lin wrist_N = mkN "canell" masculine ; --auto
lin wristband_N = mkN "canellera" feminine ; --auto
lin write_V = verbV (escriure_50 "escriure") ;
lin write_V2 = L.write_V2 ;
lin write_VS = mkVS (verbV (escriure_50 "escriure")) ;
lin write_down_V2 = prepV2 OP_write_V OP_down_Prep ; -- guess-p-verb
lin write_in_V = advV OP_write_V OP_in_Adv ; -- guess-p-verb
lin write_off_V2 = prepV2 OP_write_V OP_off_Prep ; -- guess-p-verb
lin write_out_V2 = prepV2 OP_write_V OP_out_Prep ; -- guess-p-verb
lin write_up_V2 = prepV2 OP_write_V OP_up_Prep ; -- guess-p-verb
lin writer_N = mkN "escriptor" ;
lin writing_N = mkN "escriptura" feminine | mkN "escrit" masculine | mkN "redacció" feminine ; --auto
lin wrong_A = mkA "incorrecte" ;
lin wrong_Adv = mkAdv "malament" ; --auto
lin wry_A = mkA "tort" ; --auto
lin wulfenite_N = mkN "wulfenita" feminine ; --auto
lin xanthoma_N = mkN "xantoma" masculine ; --auto
lin xanthomatosis_N = mkN "xantomatosi" feminine ; --auto
lin xenon_N = mkN "xenó" masculine ; --auto
lin xerographic_A = mkA "xerogràfic" ; --auto
lin xerography_N = mkN "xerografia" feminine ; --auto
lin xylem_N = mkN "xilema" masculine ; --auto
lin xylophone_N = mkN "xilòfon" masculine ; --auto
lin yacht_N = mkN "iot" masculine ; --auto
lin yard_N = mkN "iarda" feminine | mkN "pati" masculine ; --auto
lin yardarm_N = mkN "penol" masculine ; --auto
lin yaw_N = mkN "guinyada" feminine ; --auto
lin yawl_N = mkN "iol" masculine ; --auto
lin yawn_N = mkN "badall" masculine ; --auto
lin yawn_V = mkV "badallar" ; --auto
lin yeah_Interj = mkInterj "sí" | mkInterj "i tant" ;
lin year_N = L.year_N ;
lin yearbook_N = mkN "anuari" masculine ; --auto
lin yearly_A = mkA "anual" ; --auto
lin yeast_N = mkN "llevat" masculine ; --auto
lin yellow_A = L.yellow_A ;
lin yellow_N = mkN "groc" masculine ; --auto
lin yellowish_A = mkA "groguenc" ; --auto
lin yen_N = mkN "ien" masculine ; --auto
lin yes_Interj = mkInterj "sí" ;
lin yesterday_Adv = mkAdv "ahir" ;
lin yet_1_Adv = mkAdv "encara" ;
lin yet_2_Adv = mkAdv "encara" ;
lin yet_AdV = mkAdv "encara" ; --auto
lin yew_N = mkN "teix" masculine ; --auto
lin yield_N = mkN "collita" feminine ; --auto
lin yield_V2 = mkV2 "cedir" ; --auto
lin yoga_N = mkN "ioga" feminine ; --auto
lin yoghourt_N = mkN "iogurt" masculine ; --auto
lin yoke_N = mkN "jou" masculine ; --auto
lin youPlFem_Pron = optProDrop E.youPl8fem_Pron ;
lin youPl_Pron = optProDrop S.youPl_Pron ;
lin youPolFem_Pron = optProDrop E.youPol8fem_Pron ;
lin youPol_Pron = optProDrop S.youPol_Pron ;
lin youSgFem_Pron = optProDrop E.youSg8fem_Pron ;
lin youSg_Pron = optProDrop S.youSg_Pron ;
lin young_A = L.young_A ;
lin youngster_N = mkN "jove" | mkN "xaval" ; --auto
lin youth_N = mkN "joventut" feminine ; --auto
lin yttrium_N = mkN "itri" masculine ; --auto
lin yugoslav_A = mkA "iugoslau" ; --auto
lin yugoslav_N = mkN "iugoslau" ; --auto
lin yugoslavian_N = mkN "iugoslau" | mkN "iugoslau" ; --auto
lin zeal_N = mkN "zel" masculine ; --auto
lin zealotFem_N = variants {} ; ---- sense to be split
lin zealotMasc_N = variants {} ; ---- sense to be split
lin zealous_A = mkA "zelós" ; --auto
lin zebra_N = mkN "zebra" feminine ; --auto
lin zenithal_A = mkA "zenital" ; --auto
lin zeolite_N = mkN "zeolita" feminine ; --auto
lin zeppelin_N = mkN "zèppelin" masculine ; --auto
lin zero_N = mkN "zero" masculine ; --auto
lin zinc_N = mkN "zinc" masculine ; --auto
lin zip_N = mkN "cremallera" feminine ; --auto
lin zircon_N = mkN "zircó" masculine ; --auto
lin zirconium_N = mkN "zirconi" masculine ; --auto
lin zither_N = mkN "cítara" feminine ; --auto
lin zoanthropy_N = mkN "zoantropia" feminine ; --auto
lin zodiac_N = mkN "zodíac" masculine ; --auto
lin zodiacal_A = mkA "zodiacal" ; --auto
lin zombie_N = mkN "zombi" masculine ; --auto
lin zonal_A = mkA "zonal" ; --auto
lin zone_N = mkN "zona" feminine ; --auto
lin zone_V2 = mkV2 "qualificar" ; --auto
lin zoning_N = mkN "zonificació" feminine ; --auto
lin zonule_N = mkN "zònula" feminine ; --auto
lin zoo_N = mkN "zoo" masculine ;
lin zoological_A = mkA "zoològic" ; --auto
lin zoologist_N = mkN "zoòleg" | mkN "zoòleg" ; --auto
lin zoology_N = mkN "zoologia" feminine ; --auto
lin zoom_N = mkN "zoom" masculine ; --auto
lin zoonosis_N = mkN "zoonosi" feminine ; --auto
lin zooplankton_N = mkN "zooplàncton" masculine ; --auto
lin zygoma_N = mkN "zigoma" masculine ; --auto
lin zygomatic_A = mkA "zigomàtic" ; --auto
lin zygote_N = mkN "zigot" masculine ; --auto
oper OP_by_Prep : Prep = S.by8agent_Prep | S.by8means_Prep ;
oper OP_for_Prep : Prep = S.for_Prep ;
oper OP_on_Prep : Prep = S.on_Prep ;
oper OP_out_Prep : Prep = mkPrep "fora de" ; --auto
oper OP_upon_Prep : Prep = mkPrep "a sobre de" ; --split "tan bon punt"
oper OP_up_Prep : Prep = mkPrep "amunt" ;
oper OP_to_Prep : Prep = S.to_Prep ;
oper OP_with_Prep : Prep = S.with_Prep ;
oper OP_at_Prep : Prep = mkPrep "a" | mkPrep "en" ; --Depends on the definiteness of what follows it.
oper OP_of_Prep : Prep = ParadigmsCat.genitive ; --mkPrep "de" ;
oper OP_down_Prep : Prep = mkPrep "avall" ;
oper OP_about_Prep : Prep = mkPrep "sobre" ;
oper OP_after_Prep : Prep = S.after_Prep ;
oper OP_around_Prep : Prep = mkPrep "al voltant de" ;
oper OP_in_Prep : Prep = S.in_Prep ;
oper OP_over_Prep : Prep = mkPrep "per sobre" | mkPrep "sobre" ;
oper OP_round_Prep : Prep = mkPrep "al voltant de" ;
oper OP_off_Prep : Prep = mkPrep "fora" ;
oper OP_into_Prep : Prep = mkPrep "cap a" ;
oper OP_under_Prep : Prep = S.under_Prep ;
oper OP_through_Prep : Prep = S.through_Prep ;
oper OP_along_Prep : Prep = mkPrep "al llarg de" ;
oper OP_across_Prep : Prep = mkPrep "a través de" ;
oper OP_before_Prep : Prep = S.before_Prep ;
oper OP_from_Prep : Prep = S.from_Prep ;
oper OP_against_Prep : Prep = mkPrep "en contra de" ; --split mkPrep "a" ("lean against the wall")
oper OP_among_Prep : Prep = mkPrep "entre" ;
oper OP_towards_Prep : Prep = mkPrep "cap a" ;
oper OP_as_Prep : Prep = mkPrep "com" ;
oper OP_onto_Prep : Prep = mkPrep "a" ; --auto
oper OP_above_Prep : Prep = S.above_Prep ;
oper OP_behind_Prep : Prep = S.behind_Prep ;
oper OP_past_Prep : Prep = variants {} ;
oper OP_without_Prep : Prep = S.without_Prep ;
oper OP_toward_Prep : Prep = mkPrep "cap a" ; --auto
oper OP_up_Adv : Adv = mkAdv "amunt" ; --auto
oper OP_in_Adv : Adv = mkAdv "dins" ;
oper OP_on_Adv : Adv = mkAdv "sobre" ;
oper OP_back_Adv : Adv = mkAdv "enrere" ;
oper OP_around_Adv : Adv = mkAdv "al voltant de" ;
oper OP_away_Adv : Adv = mkAdv "fora" ; --in Catalan should be incorporated into the verb "marxar" vs "go away"
oper OP_down_Adv : Adv = mkAdv "avall" ; --auto
oper OP_off_Adv : Adv = mkAdv "fora" ; --auto
oper OP_out_Adv : Adv = mkAdv "fora" ; --auto
oper OP_about_Adv : Adv = mkAdv "aproximadament" ;
oper OP_over_Adv : Adv = mkAdv "un altre cop" ; -- should be "tornar a X"
oper OP_apart_Adv : Adv = mkAdv "separats" ;
oper OP_along_Adv : Adv = mkAdv "al llarg de" ;
oper OP_forth_Adv : Adv = variants {} ;
oper OP_forward_Adv : Adv = mkAdv "endavant" ;
oper OP_aside_Adv : Adv = mkAdv "de banda" ; --auto
oper OP_under_Adv : Adv = variants{}; -- S.under_Prep ;
oper OP_round_Adv : Adv = mkPrep "al voltant de" ;
oper OP_together_Adv : Adv = mkAdv "junt" ;
oper OP_across_Adv : Adv = variants {} ;
oper OP_by_Adv : Adv = variants {} ;
oper OP_through_Adv : Adv = mkAdv "a través de" ;
oper OP_to_Adv : Adv = variants{}; --TODO "pull the door to" -> "ajustar la porta", can't find any more senses
oper OP_even_Adv : Adv = mkAdv "àdhuc" | mkAdv "fins i tot" ; --auto
oper OP_clean_Adv : Adv = variants {} ;
oper OP_behind_Adv : Adv = variants{}; -- S.behind_Prep ;
oper OP_ahead_Adv : Adv = mkAdv "per davant" ;
oper OP_way_Adv : Adv = variants {} ;
oper OP_before_Adv : Adv = variants{}; -- S.before_Prep ;
oper OP_below_Adv : Adv = mkAdv "sota" ;
oper OP_for_Adv : Adv = variants{}; -- S.for_Prep ;
oper OP_open_Adv : Adv = variants {} ;
oper OP_after_Adv : Adv = mkAdv "després" ; --auto
oper OP_clear_Adv : Adv = variants {} ;
oper OP_account_V : V = variants {} ;
oper OP_act_V : V = mkV "actuar" ;
oper OP_add_V : V = mkV "afegir" ;
oper OP_agree_V : V = mkV "acordar" | mkV "concordar" | mkV "estar d'acord" ; --auto
oper OP_aim_V : V = mkV "apuntar" ;
oper OP_answer_V : V = mkV "contestar" ;
oper OP_apply_V : V = mkV "aplicar" ;
oper OP_argue_V : V = mkV (servir_101 "discutir") ;
oper OP_ask_V : V = mkV "preguntar" ;
oper OP_back_V : V = mkV "donar suport a" | mkV "recular" ; --auto
oper OP_bear_V : V = mkV "aguantar" | mkV "suportar" ;
oper OP_beat_V : V = mkV "derrotar" ; --split "pegar" (win vs. hit)
oper OP_bend_V : V = mkV "doblegar" | mkV "inclinar" ; --auto
oper OP_blow_V : V = L.blow_V ;
oper OP_break_V : V = mkV "trencar" ;
oper OP_build_V : V = verbV (servir_101 "construir") ;
oper OP_burn_V : V = L.burn_V ;
oper OP_burst_V : V = mkV "esclatar" ; --auto
oper OP_buy_V : V = mkV "compar" ;
oper OP_call_V : V = mkV "trucar" ;
oper OP_care_V : V = mkV "preocupar-se" ; --auto
oper OP_carry_V : V = mkV "portar" | verbV (dur_45 "dur") ;
oper OP_cast_V : V = mkV "llançar" ; --auto
oper OP_change_V : V = mkV "canviar" ;
oper OP_charge_V : V = mkV "carregar" ;
oper OP_check_V : V = mkV "comprovar" ;
oper OP_clean_V : V = mkV "netejar" ; --auto
oper OP_clear_V : V = mkV "buidar" ; --cannot be translated as a single word, requires more context
oper OP_climb_V : V = mkV "ascendir" ; --auto
oper OP_close_V : V = mkV "tancar" ;
oper OP_come_V : V = L.come_V ;
oper OP_continue_V : V = mkV "continuar" ;
oper OP_cost_V : V = mkV "costar" ;
oper OP_count_V : V = variants{}; -- L.count_V2 ;
oper OP_crash_V : V = mkV "xocar" ; --auto
oper OP_cross_V : V = mkV "creuar" ;
oper OP_cry_V : V = mkV "plorar" ;
oper OP_cut_V : V = mkV "tallar" ;
oper OP_decide_V : V = verbV (servir_101 "decidir") ;
oper OP_die_V : V = L.die_V ;
oper OP_dig_V : V = L.dig_V ;
oper OP_divide_V : V = mkV "dividir" ; --auto
oper OP_double_V : V = mkV "doblar" | mkV "plegar" ; --auto
oper OP_drag_V : V = mkV "arrossegar" | mkV "dragar" ; --auto
oper OP_draw_V : V = mkV "dibuixar" ;
oper OP_dream_V : V = mkV "somiar" ; --auto
oper OP_dress_V : V = mkV "vestir" ; --auto
oper OP_drink_V : V = mkV (beure_11 "beure") ;
oper OP_drive_V : V = mkV (reduir_94 "conduir") ;
oper OP_drop_V : V = mkV (caure_18 "caure") ;
oper OP_dry_V : V = mkV "assecar" ; --auto
oper OP_ease_V : V = mkV "alleujar" ; --auto
oper OP_eat_V : V = mkV "menjar" ;
oper OP_end_V : V = mkV "acabar" ;
oper OP_enter_V : V = mkV "entrar" ;
oper OP_face_V : V = reflV (mkV "enfrontar") ; --subcat not possible, requires an object
oper OP_fall_V : V = verbV (caure_18 "caure") ;
oper OP_feed_V : V = mkV "alimentar" ; --auto
oper OP_feel_V : V = verbV (sentir_100 "sentir") ; --subcat
oper OP_fight_V : V = mkV "lluitar" ;
oper OP_figure_V : V = mkV "imaginar" | mkV "representar" ; --auto
oper OP_file_V : V = mkV "arxivar" ; --auto
oper OP_fill_V : V = mkV "emplenar" ;
oper OP_find_V : V = mkV "trobar" ;
oper OP_finish_V : V = mkV "acabar" ;
oper OP_fire_V : V = mkV "acomiadar" | mkV "disparar" ; --auto
oper OP_fit_V : V = mkV (cabre_13 "cabre") ;
oper OP_fix_V : V = mkV "arreglar" | mkV "fixar" ; --auto
oper OP_fly_V : V = L.fly_V ;
oper OP_focus_V : V = mkV "centrar" | mkV "enfocar" ; --auto
oper OP_follow_V : V = verbV (servir_101 "seguir") ;
oper OP_force_V : V = mkV "forçar" ;
oper OP_gain_V : V = mkV (obtenir_78 "obtenir") ;
oper OP_give_V : V = verbV (donar_43 "donar") ;
oper OP_go_V : V = L.go_V ;
oper OP_grow_V : V = mkV "créixer" ;
oper OP_hang_V : V = mkV "penjar" ;
oper OP_have_V : V = mkV (tenir_108 "tenir") ;
oper OP_head_V : V = mkV "encapçalar" ; --auto
oper OP_hear_V : V = verbV (sentir_100 "sentir") ;
oper OP_help_V : V = mkV "ajudar" ;
oper OP_hide_V : V = mkV "amagar" ; --auto
oper OP_hit_V : V = mkV (trencar_112 "picar") ;
oper OP_hold_V : V = mkV "aguantar" ;
oper OP_issue_V : V = mkV (servir_101 "expedir") ;
oper OP_join_V : V = mkV "ajuntar" ;
oper OP_jump_V : V = L.jump_V ;
oper OP_keep_V : V = mkV "guardar" ;
oper OP_kick_V : V = mkV "donar una patada a" | mkV "xutar" ; --auto
oper OP_kill_V : V = mkV "matar" ;
oper OP_knock_V : V = mkV "trucar" ; --auto
oper OP_land_V : V = mkV "aterrar" ; --auto
oper OP_laugh_V : V = L.laugh_V ;
oper OP_lay_V : V = mkV "estirar" ;
oper OP_lead_V : V = verbV (reduir_94 "conduir") ;
oper OP_lean_V : V = mkV "recolzar" ; --auto
oper OP_leave_V : V = mkV "marxar" ;
oper OP_lie_V : V = variants {} ;
oper OP_lift_V : V = mkV "aixecar" ;
oper OP_light_V : V = mkV "encendre" | mkV "il·luminar" ; --auto
oper OP_link_V : V = mkV "enllaçar" ;
oper OP_listen_V : V = mkV "escoltar" ;
oper OP_live_V : V = L.live_V ;
oper OP_lock_V : V = mkV "tancar amb clau" ; --auto
oper OP_look_V : V = mkV "mirar" ;
oper OP_lose_V : V = verbV (perdre_83 "perdre") ;
oper OP_make_V : V = mkV (fer_56 "fer") ;
oper OP_marry_V : V = reflV (mkV "casar") ;
oper OP_measure_V : V = mkV "mesurar" ;
oper OP_meet_V : V = verbV (conèixer_27 "conèixer") ;
oper OP_miss_V : V = mkV "fallar" ;
oper OP_mix_V : V = mkV "barrejar" ; --auto
oper OP_mount_V : V = mkV "muntar" ; --auto
oper OP_move_V : V = verbV (moure_72 "moure") ;
oper OP_nod_V : V = mkV "assentir amb el cap" | mkV "saludar amb el cap" ; --auto
oper OP_note_V : V = mkV "anotar" ; --auto
oper OP_occur_V : V = mkV "passar" ;
oper OP_open_V : V = verbV (obrir_77 "obrir") ;
oper OP_operate_V : V = mkV "operar" ;
oper OP_pack_V : V = mkV "empaquetar" | mkV "envasar" | mkV "fer les maletes" ; --auto
oper OP_pass_V : V = mkV "passar" ; --split "aprovar" (pass an exam)
oper OP_pay_V : V = mkV "pagar" ;
oper OP_pick_V : V = mkV "triar" ;
oper OP_play_V : V = L.play_V ;
oper OP_point_V : V = mkV "assenyalar" ;
oper OP_pour_V : V = mkV "abocar" ; --auto
oper OP_press_V : V = mkV "apretar" ;
oper OP_print_V : V = mkV "imprimir" ; --auto
oper OP_pull_V : V = mkV "estirar" ;
oper OP_push_V : V = mkV (atènyer_59 "empènyer") ;
oper OP_race_V : V = mkV "córrer" ; --auto
oper OP_reach_V : V = mkV "arribar" ;
oper OP_read_V : V = verbV (servir_101 "llegir") ;
oper OP_rely_V : V = mkV "confiar" ; --auto
oper OP_report_V : V = mkV "informar" ;
oper OP_ride_V : V = mkV "muntar" ; --auto
oper OP_ring_V : V = mkV "trucar" ;
oper OP_roll_V : V = mkV "caragolar" | mkV "cargolar" | mkV "rodolar" ; --auto
oper OP_rule_V : V = mkV "governar" ; --auto
oper OP_run_V : V = L.run_V ;
oper OP_rush_V : V = mkV "afanyar-se" ; --auto
oper OP_sail_V : V = mkV "navegar" ; --auto
oper OP_save_V : V = mkV "salvar" ; --split "estalviar" (general vs. save money)
oper OP_see_V : V = verbV (veure_118 "veure") ; --Discourse marker value: "I see" -> "Sí", "Ho entenc"
oper OP_seize_V : V = mkV "agafar" | mkV "confiscar" ; --auto
oper OP_sell_V : V = verbV (vendre_116 "vendre") ;
oper OP_send_V : V = mkV "enviar" ;
oper OP_settle_V : V = mkV (absoldre_1 "resoldre") ; --split "calmar-se" (settle a dispute vs. settle down)
oper OP_shake_V : V = mkV "sacsejar" ;
oper OP_shape_V : V = variants {} ;
oper OP_share_V : V = mkV (servir_101 "compartir") ;
oper OP_shoot_V : V = mkV "disparar" ;
oper OP_shout_V : V = mkV "cridar" ; --auto
oper OP_show_V : V = mkV "ensenyar" ;
oper OP_sign_V : V = mkV "signar" ;
oper OP_sing_V : V = L.sing_V ;
oper OP_sink_V : V = mkV "enfonsar-se" ; --auto
oper OP_sit_V : V = L.sit_V ;
oper OP_sleep_V : V = L.sleep_V ;
oper OP_slip_V : V = mkV "esmunyir-se" | mkV "relliscar" ; --auto
oper OP_smoke_V : V = mkV "fumar" ; --auto
oper OP_snap_V : V = mkV "espetegar" | mkV "trencar-se" ; --auto
oper OP_sort_V : V = mkV "ordenar" ; --auto
oper OP_sound_V : V = mkV "sonar" ;
oper OP_speak_V : V = mkV "parlar" ;
oper OP_split_V : V = variants{}; -- L.split_V2 ;
oper OP_spread_V : V = mkV "divulgar" | mkV "estendre" | mkV "untar" ; --auto
oper OP_stand_V : V = L.stand_V ;
oper OP_start_V : V = mkV "començar" ;
oper OP_stay_V : V = reflV (mkV "quedar") ;
oper OP_steal_V : V = mkV "robar" ; --auto
oper OP_step_V : V = mkV "fer un pas" ; --auto
oper OP_stick_V : V = mkV "enganxar" ;
oper OP_stir_V : V = mkV "remenar" ; --auto
oper OP_stop_V : V = L.stop_V ;
oper OP_stretch_V : V = mkV "estendre" ; --auto
oper OP_strike_V : V = mkV "pegar" ;
oper OP_struggle_V : V = mkV "lluitar" ; --auto
oper OP_suit_V : V = mkV "adaptar" | mkV "convenir" ; --auto
oper OP_sweep_V : V = mkV "agranar" | mkV "escombrar" ; --auto
oper OP_swing_V : V = mkV "balancejar" ; --auto
oper OP_switch_V : V = mkV "canviar de" ; --auto
oper OP_talk_V : V = mkV "parlar" ;
oper OP_tap_V : V = mkV "donar copets a" ; --auto
oper OP_tear_V : V = mkV "estripar" ; --auto
oper OP_tell_V : V = IrregCat.dir_V ;
oper OP_think_V : V = L.think_V ;
oper OP_throw_V : V = mkV "llençar" ;
oper OP_tie_V : V = variants{}; -- L.tie_V2 ;
oper OP_touch_V : V = mkV "tocar" ;
oper OP_trade_V : V = mkV "comerciar" ; --auto
oper OP_train_V : V = mkV "entrenar" ;
oper OP_try_V : V = mkV "intentar" ;--subcat, in catalan only V2 possible
oper OP_turn_V : V = L.turn_V ;
oper OP_use_V : V = mkV "utilitzar" ;
oper OP_vote_V : V = mkV "votar" ; --auto
oper OP_wait_V : V = mkV "esperar" ;
oper OP_wake_V : V = mkV "despertar" ; --auto
oper OP_walk_V : V = L.walk_V ;
oper OP_wander_V : V = mkV "vagar" ; --auto
oper OP_want_V : V = verbV (voler_120 "voler") ;
oper OP_wash_V : V = variants{}; -- L.wash_V2 ;
oper OP_waste_V : V = mkV "malgastar" ; --auto
oper OP_watch_V : V = mkV "mirar" | mkV "vigilar" ;
oper OP_wave_V : V = mkV "agitar" | mkV "onejar" ; --auto
oper OP_wear_V : V = mkV (dur_45 "dur") ;
oper OP_win_V : V = mkV "guanyar" ;
oper OP_wind_V : V = variants {} ;
oper OP_wipe_V : V = variants{}; -- L.wipe_V2 ;
oper OP_work_V : V = mkV "treballar" ;
oper OP_write_V : V = verbV (escriure_50 "escriure") ;
oper OP_allow_V2 : V2 = mkV2 (verbV (admetre_2 "permetre")) ;
oper OP_block_V2 : V2 = mkV2 "blocar" ; --auto
oper OP_bring_V2 : V2 = mkV2 (mkV "portar") ;
oper OP_catch_V2 : V2 = mkV2 (mkV "agafar") ;
oper OP_choose_V2 : V2 = mkV2 (mkV "triar") ;
oper OP_cover_V2 : V2 = mkV2 (mkV "tapar") ;
oper OP_explain_V2 : V2 = mkV2 (mkV "explicar") ;
oper OP_free_V2 : V2 = mkV2 "alliberar" ; --auto
oper OP_frighten_V2 : V2 = mkV2 "espantar" ; --auto
oper OP_get_V2 : V2 = mkV2 (mkV (tenir_108 "obtenir")) ;
oper OP_hand_V2 : V2 = mkV2 "entregar" ; --auto
oper OP_hate_V2 : V2 = L.hate_V2 ;
oper OP_invite_V2 : V2 = mkV2 "convidar" ; --auto
oper OP_kiss_V2 : V2 = variants {} ;
oper OP_mark_V2 : V2 = mkV2 (mkV "marcar") ;
oper OP_match_V2 : V2 = variants {} ;
oper OP_offer_V2 : V2 = mkV2 (verbV (servir_101 "oferir")) ;
oper OP_own_V2 : V2 = mkV2 "posseir" ; --auto
oper OP_plant_V2 : V2 = mkV2 "plantar" ; --auto
oper OP_put_V2 : V2 = L.put_V2 ;
oper OP_seek_V2 : V2 = L.seek_V2 ;
oper OP_set_V2 : V2 = mkV2 (verbV (servir_101 "definir")) ;
oper OP_shrug_V2 : V2 = variants {} ;
oper OP_shut_V2 : V2 = mkV2 "tancar" ; --auto
oper OP_take_V2 : V2 = mkV2 (mkV "agafar") ;
oper OP_urge_V2 : V2 = mkV2 "instar" ; --auto
}
