--# -path=.:prelude:alltenses

-- regN  - Regular Nouns
-- mkNF  - Femenine Nouns
-- mkNUN - Uncountable Nouns

-- In noun cases if you don't provide any parameter
-- Here is the default forms it takes
{-
-- Default animacy : nonliving (inanimate)
-- Default Honorific form : 3rd Person Low grade Honorofic(Pers3_L)
-- Default gender : masculine
-- human/profession/living : Living 
-}
-- ParadigmsNep for details


concrete LexiconNep of Lexicon = CatNep ** 
  open ParadigmsNep, MorphoNep, Prelude in {

  flags 
    -- optimize=values ;
    coding = utf8;

  lin
  airplane_N = regN "हवाईजहाज" ; -- हवाईजहाज   
  answer_V2S = mkV2 (compoundV "उत्तर" (mkV "दिनु")) ; -- उत्तर दिनु
  apartment_N = regN "कोठा" ; -- कोठा
  apple_N = regN "स्याऊ"; -- स्याऊ
  art_N = regN "कला" ; -- कला
  ask_V2Q = mkV2 (mkV "सोध्नु") ; -- सोध्नु
  baby_N = regN "बच्चा" living ; -- बच्चा
  bad_A = mkA "खराब" ; -- खराब
  bank_N = regN "ब्याङ्क" ; -- ब्याङ्क
  beautiful_A = mkA "राम्रो" ; -- राम्रो
  become_VA = mkV "हुनु" ; -- हुनु
  beer_N = regN "बियर" ; -- बियर
  beg_V2V =  mkV2V (compoundV "आग्रह" do_V2) lai "" False ; -- आग्रह
  big_A = mkA "ठुलो" ; -- ठुलो
  bike_N = regN "साइकल" ; --साइकल
  bird_N = regN "चरा" living ; -- चरा
  black_A =  mkA "कालो" ; -- कालो
  blue_A = mkA "निलो" ; -- निलो
  boat_N = regN "डुङ्गा" ; -- डुङ्गा
  book_N = regN "किताब" ; -- किताब
  boot_N = regN "जुत्ता"; -- जुत्ता
  boss_N = regN "हाकिम" human Pers3_H ; -- हाकिम
  boy_N = regN "केटा" human; -- केटा 
  bread_N = regN "रोटी" ; -- रोटी
  break_V2 = mkV2 (mkV "भाँच्नु") ; -- भाँच्नु
  broad_A = mkA "फराकिलो" ; -- फराकिलो
  brother_N2 = mkN2 (regN "दाजु" human Pers3_H) (mkPrep "को") ""; 
  brown_A = mkA "खैरो" ; -- खैरो
  butter_N = mkNUC "नौनी" feminine; -- नौनी
  buy_V2 = mkV2 (mkV "किन्नु"); -- किन्नु
  camera_N = regN "क्यामरा" ; -- क्यामरा
  cap_N = regN "टोपि" ; -- टोपि
  car_N = regN "कार" ; -- कार
  carpet_N = regN "कार्रपेट" ; -- कार्रपेट
  cat_N = regN "बिरालो" ; -- बिरालो
  ceiling_N = regN "छत" ; -- छत
  chair_N = regN "कुर्सी" ; -- कुर्सी
  cheese_N = mkNF "चिज" ; --चिज
  child_N = regN "बच्चा" living ; -- बच्चा
  church_N = regN "गिर्जाघर" ; -- चर्च , गिर्जाघर
  city_N = regN "शहर" ; -- शहर
  clean_A = mkA "सफा" ; -- सफा
  clever_A = mkA "बाठो" ; -- बाठो
  close_V2 =  mkV2 (compoundV "बन्द" do_V2) ; --  बन्द गर्नु
  coat_N = regN "कोट" ; -- कोट
  cold_A = mkA "चिसो" ; -- चिसो
  come_V = mkV "आउनु" ; -- आउनु
  computer_N = regN "कम्प्युटर" ; -- कम्प्युटर
  country_N = regN "देश" ; -- देश
  cousin_N = regN "काका" ; -- काका
  cow_N = mkNF "गाई" living Pers3_M ; -- गाई
  die_V = mkV "मर्नु" ; -- मर्नु
  dirty_A = mkA "फोहोर" ; -- फोहोर
  distance_N3 = mkN3 (regN "दुरी") (mkPrep "देखि") (mkPrep "सम्म") "को"  ; -- दुरी, देखी, सम्म, त्यहाँ
  doctor_N = regN "डाक्टर" profession Pers3_H ; -- डाक्टर, / Cikitx:sk - चिकित्सक
  dog_N = regN "कुकुर" living; -- कुकुर
  door_N = regN "ढोका" ; -- ढोका
  drink_V2 = mkV2 (mkV "पिउनु") ; -- पिउनु
  --easy_A2V = mkA "सजीलो" ; -- सजीलो
  eat_V2 = mkV2 (mkV "खानु") "" ; -- खानु
  empty_A = mkA "खाली" ; -- खाली
  enemy_N = regN "शत्रु" living ; -- शत्रु
  factory_N = regN "कारखाना" ; -- कारखाना
  father_N2 = mkN2 (regN "बुबा" living Pers3_H) (mkPrep "को") "" ; -- बुबा, बाबु
  fear_VS = mkV "डराउनु"; -- डराउनु
  find_V2 = mkV2 (mkV "पाउनु") ; -- पाउनु
  fish_N = regN "माछा" living ; -- माछा
  floor_N = regN "भुँई" ; -- भुँई
  forget_V2 = mkV2 (mkV "बिर्सनु") ; -- बिर्सनु 
  fridge_N = regN "फ्रिज" ; -- फ्रिज
  friend_N = regN "साथी" living Pers3_M ; -- साथी
  fruit_N = regN "फल" ; -- फल
  --fun_AV = mkAdV "रमाइलो" ; -- रमाइलो
  garden_N = regN "बगैँचा" ; -- बगैँचा
  girl_N = mkNF "केटी" living ; -- केटी  
  glove_N = regN "पञ्जा"; -- पञ्जा
  gold_N = regN "सुन" ; -- सुन
  good_A = mkA "राम्रो" ; -- राम्रो
  go_V = mkV "जानु" ; -- जानु
  green_A = mkA "हरियो" ; -- हरियो
  harbour_N = regN "बन्दरगाह" ; -- बन्दरगाह
  hate_V2 = mkV2 (compoundV "घृणा" do_V2) ; -- घृणा
  hat_N = regN "टोपी" ; -- टोपी
  -- have_V2 = dirV2 (mk5V "हa?े" "हास" "हाद" "हाद" "हa??नग") ; ????MAY BE NOT APPLICABLE
  hear_V2 = mkV2 (mkV "सुन्नु") ; -- सुन्नु
  hill_N = regN "पहाड" ; -- पहाड
  hope_VS = (compoundV "आशा" do_V2); -- आशा
  horse_N = regN "घोडा" living ; -- घोडा
  hot_A = mkA "तातो" ; -- तातो
  house_N = regN "घर" ; -- घर
  important_A = mkA "जरुरी" ; -- जरुरी
  industry_N = regN "उधोग" ; -- उधोग
  iron_N = regN "फलाम" ; -- फलाम
  king_N = regN "राजा" living Pers3_H; -- राजा
  know_V2 = mkV2 (mkV "चिन्नु") ; -- चिन्नु 
  know_VS = (mkV "थाहा पाउनु") ; -- थाहा पाउनु
  know_VQ = (compoundV "थाहा" (mkV2 (mkV "पाउनु"))) ; -- थाहा पाउनु
  lake_N = regN "ताल" ; -- ताल
  lamp_N = regN "बत्ति" ; -- बत्ति
  learn_V2 = mkV2 (mkV "सिक्नु") ; -- सिक्नु
  leather_N = regN "छाला" ; -- छाला
  leave_V2 = mkV2 (mkV "छोड्नु") ; -- छोड्नु
  like_V2 = mkV2 (compoundV "मन" (mkV "पर्नु")); -- मन पर्नु ???? NOT COVERED BY RULE
  listen_V2 = mkV2 (mkV "सुन्नु") ; -- सुन्नु
  live_V = mkV "जिउनु" ; -- जिउनु -- px:rtkx:z प्रतक्ष
  long_A = mkA "लामो" ; -- लामो
  lose_V2 = mkV2 (mkV "हराउनु") ; -- हराउनु
  love_N = regN "माया" ; -- माया
  love_V2 = mkV2 (compoundV "माया" do_V2) lai ; -- "नौण"; -- माया गर्नु
  man_N = regN "मान्छे" human ; -- मान्छे
  married_A2 = mkA "विवाहित" "सँग" ; -- सँग विवाहित
  meat_N = mkNUC "मासु" masculine ; -- मासु
  milk_N = mkNUC "दुध" masculine ; -- दुध
  moon_N = regN "चन्र्दमा" ; -- चन्र्दमा ??
  mother_N2 = mkN2 (mkNF "आमा" living Pers3_H) (mkPrep "को") ""  ;   -- need ko discuss
  mountain_N = regN "हिमाल" ; -- हिमाल
  music_N = regN "संगीत" ; -- संगीत
  narrow_A = mkA "सांगुरो" ; -- सांगुरो
  new_A = mkA "नायाँ" ; -- नायाँ
  newspaper_N = regN "समाचारपत्र" ; -- समाचारपत्र
  oil_N = mkNUC "तेल" masculine ; -- तेल
  --old_A = mkA "पुरानो" ; -- पुरानो
  old_A = mkA "बुढो" ; -- बुढो
  open_V2 = mkV2 (mkV "खोल्नु") ; -- खोल्नु
  paint_V2A = mkV2 (compoundV "रँग" (mkV2 (mkV "लागाउनु"))) lai ; 
  paper_N = regN "कागज" ; -- कागज
  paris_PN = mkPN "पेरिस" ; -- ???? DEFAULT AS MALE (inflection) is this correct ????
  peace_N = mkNUC "शान्ति" masculine ; -- शान्ति ???? Not sure
  pen_N = regN "कलम" ; -- कलम
  planet_N = regN "ग्रह" ; -- ग्रह
  plastic_N = regN "पाल्स्टिक" ; -- पाल्स्टिक
  play_V2 = mkV2 (mkV "खेल्नु") ; -- खेल्नु
  policeman_N = regN "प्रहरी" human Pers3_M ; -- प्रहरी 
  priest_N = regN "पुरोहित" human Pers3_H ; -- पुरोहित
  -- probable_AS = mkAdj1S (regA "पr?बाबले") ;
  queen_N = mkNF "रानी" human Pers3_H ; -- रानी
  radio_N = regN "रेडियो"; -- रेडियो
  rain_V0 = compoundV "बर्षा" (mkV "हुनु" ) ; -- बर्षा ???? hunu/bhayo irregular case need to be added
  read_V2 = mkV2 (mkV "पढ्नु"); -- पढ्नु 
  red_A = mkA "रातो" ; -- रातो  
  religion_N = regN "धर्म" ; -- धर्म
  restaurant_N = regN "रेस्टुरेन्ट" ; -- रेस्टुरेन्ट
  river_N = regN "खोला" ; --खोला
  rock_N = regN "ढुङ्गा" ; -- ढुङ्गा
  roof_N = regN "छाना" ; -- छाना
  rubber_N = regN "रबर" ; -- रबर
  run_V = mkV "कुद्नु" ; -- कुद्नु
  say_VS = mkV "भन्नु" ; -- भन्नु
  school_N = regN "विधालय" ; -- विधालय
  science_N = regN "विज्ञन" ; -- विज्ञन
  sea_N = regN "समुन्द्र" ; -- समुन्द्र
  seek_V2 = mkV2 (mkV "खोज्नु" ) ;
  sell_V3 = mkV3 (mkV "बेच्नु") "" lai ; --  बेच्नु   ram(le) sita (lai) kitab bachyo
  send_V3 = mkV3 (mkV "पठाउनु") "" lai ; -- पठाउनु 
  sheep_N = regN "भेडा" living ; -- भेडा
  ship_N = regN "जहाज" ; -- जहाज
  shirt_N = regN "सर्" ; -- सर्ट
  shoe_N = regN "जुत्ता" ; -- जुत्ता
  shop_N = regN "पसल" ; -- पसल
  short_A = mkA "छोटो" ; --छोटो
  silver_N = regN "चाँदि" ; -- चाँदि
  sister_N = mkNF "दीदी" human Pers3_H ; -- दीदी
  sleep_V = mkV "सुत्नु" ; -- सुत्नु
  small_A = mkA "सानो" ; -- सानो
  snake_N = regN "र्षप" ; -- र्षप
  sock_N = regN "मोजा" ; -- मोजा
  speak_V2 = mkV2 (mkV "बोल्नु") ; -- बोल्नु
  star_N = regN "तारा" ; -- तारा
  steel_N = regN "स्टिल" ; -- स्टिल
  stone_N = regN "ढुङ्गा" ; -- ढुङ्गा
  stove_N = regN "चुलो" ; -- चुलो
  student_N = regN "बिध्यार्थि" human ; --बिध्यार्थि
  stupid_A = mkA "मुर्ख" ; -- मुर्ख
  sun_N = regN "सुर्य"; -- सुर्य
  switch8off_V2 = mkV2 (compoundV "स्विच अफ" do_V2) ; -- स्विच अन्
  switch8on_V2 = mkV2 (compoundV "स्विच अन्" do_V2) ; -- स्विच अफ
  table_N = regN "टेबल" ; -- टेबल
  talk_V3 = mkV3 (compoundV "कुरा" (mkV2 (mkV "गर्नु"))) "सँग" ""; -- कुरा गर्नु सँग
  teacher_N = regN "शिक्षक" human Pers3_H ; -- शिक्षक
  teach_V2 = mkV2 (mkV "पढाउनु") ; -- पढाउनु
  television_N = regN "टेलिभिजन्" ; -- टेलिभिजन्
  thick_A = mkA "बाक्लो" ; -- बाक्लो
  thin_A = mkA "पातलो" ; -- पातलो
  train_N = regN "रेल" ; -- रेल
  travel_V = (compoundV "यात्रा" do_V2) ; -- Gumx:nu -- घुम्नु / यात्रा
  tree_N = regN "रुख" ; -- रुख
  ugly_A = mkA "नराम्रो" ; -- नराम्रो
  understand_V2 = mkV2 (mkV "बुझ्नु") ; -- बुझ्नु
  university_N = regN "बिश्वबिध्यालय" ; -- बिश्वबिध्यालय
  village_N = regN "गाऊँ" ; -- गाऊँ
  wait_V2 = mkV2 (mkV "पर्खनु") ; -- पर्खनु 
  walk_V = mkV "हिड्नु" ; -- हिड्नु
  warm_A = mkA "तातो" ; -- तातो
  war_N = regN "लडाई" ; -- लडाई
  watch_V2 = mkV2 (mkV "हेर्नु") ; -- हेर्नु
  water_N = mkNUC "पानी" feminine ; 
  white_A = mkA "सेतो" ; -- सेतो
  window_N = regN "झ्याल" ; -- झ्याल
  wine_N = regN "वाईन" ; -- वाईन
  win_V2 = mkV2 (mkV "जित्नु") ; -- जित्नु
  woman_N = mkNF "आईमाई" Living Pers3_M ; -- आईमाई
  wonder_VQ = compoundV "अचम्म" (mkV "हुनु") ; -- अचम्म हुनु
  wood_N = regN "काठ" ; -- काठ
  write_V2 = mkV2 (mkV "लेख्नु") ; -- लेख्नु
  yellow_A = mkA "पहेलो" ; --पहेलो
  young_A = mkA "जवान" ; -- जवान
  do_V2 = mkV2 (mkV "गर्नु") ; -- गर्नु
  now_Adv = mkAdv "अहीले" ; -- अहीले
  already_Adv = mkAdv "अघिनै" ; -- अघिनै
  song_N = regN "गीत" ; -- गित
  add_V3 = mkV3 (mkV "जोड्नु") "सँग" "" ; -- जोड्नु
  number_N = regN "संख्या" ; -- संख्या
  put_V2 = mkV2 (mkV "राख्नु") ; -- राख्नु
  stop_V = mkV "रोक्नु" ; -- रोक्नु
  jump_V = mkV "उफ्रनु" ; -- उफ्रनु 
  left_Ord = {s = "बायाँ" ; n = singular}; -- ????
  right_Ord = {s = "दायाँ" ; n = singular}; -- ????
  far_Adv = mkAdv "टाढा" ; -- टाढा
  correct_A = mkA "ठिक" ; -- ठिक
  dry_A = mkA "सुख्खा" ; -- सुख्खा
  dull_A = mkA "मन्ध" ; -- मन्ध
  full_A = mkA "भरि" ; -- भरि
  heavy_A = mkA "भारी" ; -- भारी
  near_A = mkA "नजिक" ; -- नजिक
  rotten_A = mkA "कुहिa:को" ; -- कुहिएको
  round_A = mkA "गोलो" ; -- गोलो
  sharp_A = mkA "तीखो" ; -- तीखो
  smooth_A = mkA "समतल" ; -- समतल
  straight_A = mkA "सिधा" ; -- सिधा
  wet_A = mkA "चिसो" ; -- चिसो
  wide_A = mkA "फराकिलो" ; -- फराकिलो
  animal_N = regN "जनावार" ; -- जनावार
  ashes_N = mkNUC "खरानी" masculine ; -- खरानी
  back_N = regN "आङ" ; -- आङ
  bark_N = regN "बोक्रा" ; -- बोक्रा
  belly_N = regN "पेट" ; -- पेट
  blood_N = mkNUC "रगत" feminine ; -- रगत
  bone_N = regN "हड्डी" ; -- हड्डी
  breast_N = regN "स्तन" ; -- स्तन
  cloud_N = regN "बादल" ; -- बादल
  day_N = regN "दिन" ; -- दिन
  dust_N = regN "धुलो" ; -- धुलो
  ear_N = regN "कान" ; -- कान
  earth_N = regN "पृथ्वि" ; -- पृथ्वि
  egg_N = regN "अण्डा" ; -- अण्डा
  eye_N = regN "आँखा" ; -- आँखा
  fat_N = regN "मोटो" ; -- मोटो 
  feather_N = regN "प्वाँख" ; -- प्वाँख
  fingernail_N = regN "नङ" ; -- नङ
  fire_N = regN "आगो" ; -- आगो
  flower_N = regN "फुल" ; -- फुल
  fog_N = mkNUC "कुईरो" feminine ; --  कुईरो 
  foot_N = regN "खुट्टा" ; -- खुट्टा
  forest_N = regN "जँगल" ; -- जँगल
  grass_N = mkNUC "घाँस" masculine ; -- घाँस
  guts_N = regN "गत" ; -- FIXME: no singular
  hair_N = mkNUC "कपाल" masculine ; -- कपाल
  hand_N = regN "हात" ; -- हात
  head_N = regN "टाउकोस" ; -- टाउको
  heart_N = regN "मुटु" ; -- मुटु
  horn_N = regN "हर्न" ; -- हर्न
  husband_N = regN "पति" human Pers3_M ; -- पति
  ice_N = mkNUC "हिऊँ" masculine ; -- हिऊँ
  knee_N = regN "घुँडा" ; -- घुँडा
  leaf_N = regN "पात" ; -- पात
  leg_N = regN "खुट्टा" ; -- खुट्टा
  liver_N = regN "कलेजो" ; -- कलेजो
  louse_N = regN "जुम्रा" ; -- जुम्रा
  mouth_N = regN "मुख" ; -- मुख
  name_N = regN "नाम" ; -- नाम
  neck_N = regN "घाँटी" ; -- घाँटी
  night_N = regN "रात" ; -- रात
  nose_N = regN "नाक" ; -- नाक
  person_N = regN "मानिस" ; -- मानिस
  rain_N = mkNUC "बर्षा" feminine ; -- बर्षा
  road_N = regN "सषक" ; -- सडक
  root_N = regN "जड" ; -- जड
  rope_N = regN "डोरी" ; -- डोरी
  salt_N = mkNUC "नुन" masculine ; -- नुन
  sand_N = mkNUC "बालुवा" masculine ; -- बालुवा
  seed_N = regN "बिउ" ; -- बिउ
  see_V2 = mkV2 (mkV "हेर्नु" ) lai ; -- हेर्नु
  skin_N = regN "छाला" ; -- छाला
  sky_N  = regN "आकाश" ; -- आकाश
  smoke_N = mkNUC "धुवाँ" masculine ; -- धुवाँ
  snow_N = regN "हिउँ" ; -- हिउँ
  stick_N = regN "लठ्ठि" ; -- लठ्ठि
  tail_N = regN "पुच्छर" ; -- पुच्छर
  tongue_N = regN "जिब्रो" ; -- जिब्रो
  tooth_N = regN "दाँत" ; -- दाँत 
  wife_N = mkNF "पत्नी" Living ; -- पत्नी
  wind_N = regN "हुरी" ; -- हुरी
  wing_N = regN "पंखा" ; -- पंखा
  worm_N = regN "जुगा" ; -- जुगा
  year_N = regN "बर्ष" ; -- बर्ष
  blow_V = mkV "प्रहार" ; -- प्रहार
  breathe_V = compoundV "सास" (mkV "फेर्नु" ) ; -- सास फेर्नु
  burn_V = mkV "बाल्नु" ; -- बाल्नु
  dig_V = mkV "खन्नु" ; -- खन्नु
  fall_V = mkV "झर्नु" ; -- झर्नु
  float_V = mkV "उत्रनु" ; -- उत्रनु
  flow_V = mkV "बहनु" ; -- बहनु
  fly_V = mkV "उड्नु" ; -- उड्नु
  freeze_V = mkV "जमाउनु" ; -- जमाउनु
  give_V3 = mkV3 (mkV "दिनु") lai "" ; -- दिनु
  laugh_V = mkV "हास्नु" ; -- हास्नु  
  lie_V = compoundV "झुटो" (mkV "बोल्नु"); -- झुटो बोल्नु  
  play_V = mkV "खेल्नु" ; -- खेल्नु
  sit_V = mkV "बस्नु" ; -- बस्नु
  sew_V = mkV "सिउनु" ; -- सिउनु
  sing_V = mkV "गाउनु" ; -- गाउनु  
  smell_V = mkV "सुगन्ध" ; -- सुगन्ध
  spit_V = mkV "थुक्नु" ; -- थुक्नु
  stand_V = mkV "उठ्नु" ; -- उठ्नु
  swell_V = mkV "सुनिनु" ; -- सुनिनु
  swim_V = compoundV "पौडी" (mkV "खेल्नु" ) ;
  think_V = mkV "सोच्नु" ; -- सोच्नु
  turn_V = mkV "पल्टिनु" ; -- पल्टिनु
  vomit_V = mkV "छादनु" ; -- छादनु
  bite_V2 = mkV2 (mkV "टोक्नु") ; -- टोक्नु
  count_V2 = mkV2 (mkV "गन्नु") ; -- गन्नु
  cut_V2 = mkV2 (mkV "काटनु") ; -- काटनु
  fear_V2 = mkV2 (mkV "डराउनु") ; -- डराउनु
  fight_V2 = mkV2 (mkV "लड्नु") ; -- लड्नु
  hit_V2 = mkV2 (mkV "हान्नु" ) lai ; -- हान्‌नु
  hold_V2 = mkV2 (mkV "समात्नु") ; -- समात्नु
  hunt_V2 = mkV2 (compoundV "शिकार" do_V2) ; -- शिकार
  kill_V2 =  mkV2 (mkV "मार्नु") ;  -- मार्नु
  pull_V2 = mkV2 (mkV "तान्नु"); -- तान्नु
  push_V2 = mkV2 (compoundV "धक्का" (mkV "दिनु")) lai ;
  rub_V2 = mkV2 (mkV "माडनु") ; -- माडनु
  scratch_V2 = mkV2 (mkV "कोर्नु") lai ; -- कोर्नु
  split_V2 = mkV2 (mkV "चिर्नु") lai ; -- चिर्नु
  squeeze_V2 = mkV2 (mkV "थिच्नु") lai ; -- थिच्नु
  stab_V2 = mkV2 (compoundV "छुरा" hit_V2) ; -- छुरा हान्नु
  suck_V2 = mkV2 (mkV "चुस्नु") ; -- चुस्नु
  throw_V2 = mkV2 (mkV "फाल्नु") ; -- फाल्नु
  tie_V2 = mkV2 (mkV "बाँधनु") ; -- बाँधनु
  wash_V2 = mkV2 (mkV "धुनु") ; -- धुनु
  wipe_V2 = mkV2 (mkV "पुछ्नु"); -- पुछ्नु  
--b  other_A = mkA "अरु" ; -- अरु  NOT IN ABSTRACT
  grammar_N = regN "व्याकरण" ; -- व्याकरण
  language_N = regN "भाषा" ; -- भाषा
  rule_N = regN "नियम" ; -- नियम

-- added 4/6/2007
  john_PN = mkPN "जोन" masculine human Pers3_L ;
  question_N = regN "प्रश्न" ; -- प्रश्न
  ready_A = mkA "तयार" ; -- तयार
  reason_N = regN "कारण" ; -- कारण
  today_Adv = mkAdv "आज" ; -- आज
  uncertain_A = mkA "अनिश्चित" ; -- अनिश्चित

oper
  lai = "लाई" ;

} ;
