-- LexiconMlt.gf: test lexicon of 300 content words
--
-- Maltese GF Resource Grammar
-- John J. Camilleri 2011 -- 2013
-- Licensed under LGPL

--# -path=.:../abstract:../common:../prelude

concrete LexiconMlt of Lexicon = CatMlt **
  open Prelude, ParadigmsMlt, IrregMlt, DictMlt in {

  flags
    optimize=values ;
    coding=utf8 ;

  -- Nouns
  lin
    airplane_N     = mkN "ajruplan" "ajruplani" ;
    animal_N       = mkN "annimal" "annimali" ;
    apartment_N    = mkN "appartament" "appartamenti" ;
    apple_N        = mkNColl "tuffieħa" "tuffieħ" "tuffieħat" ;
    art_N          = mkNNoPlural "arti" feminine ;
    ashes_N        = mkN "rmied" "rmiet" ;
    baby_N         = mkN "tarbija" "trabi" ;
    back_N         = possN (mkN "dahar" "dhur") ;
    bank_N         = mkN "bank" "bankijiet" ;
    bark_N         = mkN "qoxra" "qoxriet" ;
    beer_N         = mkN "birra" "birer" ;
    belly_N        = possN (mkN "żaqq" "żquq") ;
    bike_N         = mkN "rota" "roti" ;
    bird_N         = mkN "għasfur" "għasafar" ; -- genderedN
    blood_N        = possN (mkNColl "demm" "dmija") ;
    boat_N         = mkN "dgħajsa" "dgħajjes" ;
    bone_N         = mkNColl "għadma" "għadam" "għadmiet" ;
    book_N         = mkN "ktieb" "kotba" ;
    boot_N         = mkNColl "żarbuna" "żarbun" "żraben" ;
    boss_N         = mkN "mgħallem" "mgħallmin" ;
    boy_N          = mkN "tifel" "subien" ;
    bread_N        = mkNColl "ħobża" "ħobż" "ħobżiet" ;
    breast_N       = possN (mkN "sider" "sdur") ;
    brother_N2     = mkN2 (possN (mkN "ħu" "aħwa")) ;
    butter_N       = mkNColl "butir" "butirijiet" ;
    camera_N       = mkN "kamera" "kameras" ;
    cap_N          = mkN "kappell" "kpiepel" ;
    car_N          = mkN "karozza" "karozzi" ;
    carpet_N       = mkN "tapit" "twapet" ;
    cat_N          = mkN "qattus" "qtates" ; -- genderedN
    ceiling_N      = mkN "saqaf" "soqfa" ;
    chair_N        = mkN "siġġu" "siġġijiet" ;
    cheese_N       = mkNColl "ġobna" "ġobon" "ġobniet" ;
    child_N        = mkN "tifel / tifla" "tfal" ; -- genderedN
    church_N       = mkN "knisja" "knejjes" ;
    city_N         = mkN "belt" "bliet" feminine ;
    cloud_N        = mkNColl "sħaba" "sħab" "sħabiet" ;
    coat_N         = mkN "kowt" "kowtijiet" ;
    computer_N     = mkN "kompjuter" "kompjuters" ;
    country_N      = possN (mkN "pajjiż" "pajjiżi") ;
    cousin_N       = mkN "kuġin" "kuġini" ; -- genderedN
    cow_N          = mkNColl "baqra" "baqar" "baqriet" ;
    day_N          = mkN "ġurnata" "ġranet" ;
    distance_N3    = mkN3 (mkN "distanza") saP minnP ;
    doctor_N       = mkN "tabib" "tobba" ; -- genderedN
    dog_N          = mkN "kelb" "klieb" ;
    door_N         = mkN "bieb" "bibien" ;
    dust_N         = mkNColl "traba" "trab" "trabiet" ;
    ear_N          = possN (mkNDual "widna" "widnejn" "widniet") ;
    earth_N        = mkN "art" "artijiet" feminine ;
    egg_N          = mkNColl "bajda" "bajd" "bajdiet" ;
    enemy_N        = mkN "għadu" "għedewwa" ;
    eye_N          = possN (mkNDual "għajn" "għajnejn" "għajnejn" "għejun" feminine) ;
    factory_N      = mkN "fabbrika" "fabbriki" ;
    fat_N          = mkNColl "xaħma" "xaħam" "xaħmiet" "xaħmijiet" ;
    father_N2      = mkN2 (possN (mkN "missier" "missirijiet")) ;
    feather_N      = mkNColl "rixa" "rix" "rixiet" ;
    fingernail_N   = possN (mkNDual "difer" "difrejn" "dwiefer") ;
    fire_N         = mkN "nar" "nirien" ;
    fish_N         = mkNColl "ħuta" "ħut" "ħutiet" ;
    floor_N        = mkN "art" "artijiet" feminine ;
    flower_N       = mkN "fjura" "fjuri" ;
    fog_N          = mkNColl "ċpar" ;
    foot_N         = possN (mkNDual "sieq" "saqajn" "saqajn" feminine) ;
    forest_N       = mkN "foresta" "foresti" ;
    fridge_N       = mkN "friġġ" "friġġijiet" ;
    friend_N       = possN (mkN "ħabib" "ħbieb") ; -- genderedN
    fruit_N        = mkNColl "frotta" "frott" "frottiet" "frottijiet" ;
    garden_N       = mkN "ġnien" "ġonna" ;
    girl_N         = mkN "tifla" "tfajliet" ;
    glove_N        = mkN "ingwanta" "ingwanti" ;
    gold_N         = mkNColl "deheb" "dehbijiet" ;
    grammar_N      = mkN "grammatika" "grammatiki" ;
    grass_N        = mkNColl "ħaxixa" "ħaxix" "ħxejjex" ;
    guts_N         = possN (mkN "musrana" "musraniet" "msaren") ;
    hair_N         = possN (mkNColl "xagħara" "xagħar" "xagħariet" "xgħur") ;
    hand_N         = possN (mkNDual "id" "idejn" "idejn" feminine) ;
    harbour_N      = mkN "port" "portijiet" ;
    hat_N          = mkN "kappell" "kpiepel" ;
    head_N         = possN (mkN "ras" "rjus" feminine) ;
    heart_N        = possN (mkN "qalb" "qlub" feminine) ;
    hill_N         = mkN "għolja" "għoljiet" ;
    horn_N         = mkN "ħorn" "ħornijiet" ;
    horse_N        = mkN "żiemel" "żwiemel" ;
    house_N        = mkN "dar" "djar" feminine ;
    husband_N      = mkN "raġel" "rġiel" ;
    ice_N          = mkN "silġ" "silġiet" ;
    industry_N     = mkN "industrija" "industriji" ;
    iron_N         = mkNColl "ħadida" "ħadid" "ħadidiet" "ħdejjed" ;
    king_N         = mkN "re" "rejjiet" ;
    knee_N         = possN (mkNDual "rkoppa" "rkopptejn" "rkoppiet") ;
    lake_N         = mkN "għadira" "għadajjar" ;
    lamp_N         = mkN "lampa" "lampi" ;
    language_N     = mkN "lingwa" "lingwi" ;
    leaf_N         = mkNDual "werqa" "werqtejn" "werqiet" ;
    leather_N      = mkN "ġilda" "ġildiet" ;
    leg_N          = (mkNDual "riġel" "riġlejn" "riġlejn") ;
    liver_N        = mkN "fwied" "ifdwa" ;
    louse_N        = mkN "qamla" "qamliet" ;
    love_N         = mkN "mħabba" "mħabbiet" ;
    man_N          = mkN "raġel" "rġiel" ;
    meat_N         = mkNColl "laħma" "laħam" "laħmiet" "laħmijiet" ;
    milk_N         = mkNColl "ħalib" "ħalibijiet" ;
    moon_N         = mkN "qamar" "oqmra" ;
    mother_N2      = mkN2 (possN (mkN "omm" "ommijiet" feminine)) ;
    mountain_N     = mkN "muntanja" "muntanji" ;
    mouth_N        = possN (mkN "ħalq" "ħluq") ;
    music_N        = mkN "mużika" "mużiki" ;
    name_N         = possN (mkN "isem" "ismijiet") ;
    neck_N         = possN (mkN "għonq" "għenuq") ;
    newspaper_N    = mkN "gazzetta" "gazzetti" ;
    night_N        = mkN "lejl" "ljieli" ;
    nose_N         = possN (mkN "mnieħer" "mniħrijiet") ;
    number_N       = mkN "numru" "numrui" ;
    oil_N          = mkN "żejt" "żjut" ;
    paper_N        = mkN "karta" "karti" ;
    peace_N        = mkN "paċi" "paċijiet" feminine ;
    pen_N          = mkN "pinna" "pinen" ;
    person_N       = mkNColl "persuna" "persuni" ;
    planet_N       = mkN "pjaneta" "pjaneti" ;
    plastic_N      = mkNNoPlural "plastik" ;
    policeman_N    = mkNNoPlural "pulizija" ;
    priest_N       = mkN "qassis" "qassisin" ;
    queen_N        = mkN "reġina" "rġejjen" ;
    question_N     = mkN "mistoqsija" "mistoqsijiet" ;
    radio_N        = mkN "radju" "radjijiet" ;
    rain_N         = mkNNoPlural "xita" ;
    reason_N       = mkN "raġun" "raġunijiet" ;
    religion_N     = mkN "reliġjon" "reliġjonijiet" ;
    restaurant_N   = mkN "restorant" "restoranti" ;
    river_N        = mkN "xmara" "xmajjar" ;
    road_N         = mkN "triq" "triqat" "toroq" feminine ;
    rock_N         = mkNColl "blata" "blat" "blatiet" ;
    roof_N         = mkN "saqaf" "soqfa" ;
    root_N         = mkN "qħerq" "qħeruq" ;
    rope_N         = mkN "ħabel" "ħbula" ;
    rubber_N       = mkN "gomma" "gomom" ;
    rule_N         = mkN "regola" "regoli" ;
    salt_N         = mkN "melħ" "melħiet" ;
    sand_N         = mkNColl "ramla" "ramel" "ramliet" ;
    school_N       = mkN "skola" "skejjel" ;
    science_N      = mkN "xjenza" "xjenzi" ;
    sea_N          = mkNDual "baħar" "baħrejn" "ibħra" ;
    seed_N         = mkN "żerriegħa" "żerrigħat" ;
    sheep_N        = mkNColl "nagħġa" "ngħaġ" "nagħġiet" ;
    ship_N         = mkN "vapur" "vapuri" ;
    shirt_N        = mkN "qmis" "qomos" feminine ;
    shoe_N         = mkN "żarbun" "żraben" ;
    shop_N         = mkN "ħanut" "ħwienet" ;
    silver_N       = mkN "fidda" "fided" ;
    sister_N       = (mkN "oħt" "aħwa" feminine) ;
    skin_N         = mkN "ġilda" "ġildiet" ;
    sky_N          = mkN "sema" "smewwiet" masculine ;
    smoke_N        = mkN "duħħan" "dħaħen" ;
    snake_N        = mkN "serp" "sriep" ;
    snow_N         = mkNColl "borra" ;
    sock_N         = mkN "kalzetta" "kalzetti" ;
    song_N         = mkN "kanzunetta" "kanzunetti" ;
    star_N         = mkN "stilla" "stilel" ;
    steel_N        = mkNNoPlural "azzar" ;
    stick_N        = mkN "lasta" "lasti" ;
    stone_N        = mkNColl "ġebla" "ġebel" "ġebliet" "ġbiel" ;
    stove_N        = mkN "kuker" "kukers" ;
    student_N      = mkN "student" "studenti" ;
    sun_N          = mkN "xemx" "xmux" feminine ;
    table_N        = mkN "mejda" "mwejjed" ;
    tail_N         = (mkN "denb" "dnieb") ;
    teacher_N      = mkN "għalliem" "għalliema" ; -- genderedN
    television_N   = mkN "televixin" "televixins" ;
    tongue_N       = possN (mkN "lsien" "ilsna") ;
    tooth_N        = possN (mkN "sinna" "sinniet" "snien") ;
    train_N        = mkN "ferrovija" "ferroviji" ;
    tree_N         = mkNColl "siġra" "siġar" "siġriet" ;
    university_N   = mkN "università" "universitàjiet" ;
    village_N      = mkN "raħal" "rħula" ;
    war_N          = mkN "gwerra" "gwerrer" ;
    water_N        = mkN "ilma" "ilmijiet" masculine ;
    wife_N         = mkN "mara" "nisa" ;
    wind_N         = mkN "riħ" "rjieħ" ;
    window_N       = mkN "tieqa" "twieqi" ;
    wine_N         = mkNColl "nbid" "nbejjed" ;
    wing_N         = mkN "ġewnaħ" "ġwienaħ" ;
    woman_N        = mkN "mara" "nisa" ;
    wood_N         = mkN "injam" "injamiet" ;
    worm_N         = mkNColl "dudu" "dud" "dudiet" ;
    year_N         = mkNDual "sena" "sentejn" "snin" ;

  -- Verbs
  lin
    add_V3         = mkV3 zied_ZJD_1_10424_V maP ;
    answer_V2S     = lilV2 (wiegeb_WGB_3_10033_V) ;
    ask_V2Q        = lilV2 (saqsa_SQSJ_1_7268_V) ;
    become_VA      = sar_SJR_1_9797_V ;
    beg_V2V        = mkV2V ttallab_TLB_5_9893_V ghalP minnP ;
    bite_V2        = lilV2 (gidem_GDM_1_8009_V) ;
    blow_V         = nefah_NFH_1_8966_V ;
    break_V2       = dirV2 (kiser_KSR_1_8636_V) ;
    breathe_V      = mkV "respira" ; -- ĦA N-NIFS
    burn_V         = haraq_HRQ_1_8367_V ;
    buy_V2         = dirV2 (xtara_XRJ_8_10296_V) ;
    close_V2       = dirV2 (ghalaq_GHLQ_1_10530_V) ;
    come_V         = gie_GJ'_1_8123_V ;
    count_V2       = dirV2 (ghadd_GHDD_1_10460_V) ;
    cut_V2         = dirV2 (qata'_QTGH_1_9305_V) ;
    die_V          = miet_MWT_1_8923_V ;
    dig_V          = haffer_HFR_2_8236_V ;
    do_V2          = dirV2 (ghamel_GHML_1_10544_V) ;
    drink_V2       = dirV2 (xorob_XRB_1_10231_V) ;
    eat_V2         = dirV2 (kiel_KJL_1_8672_V) ;
    fall_V         = waqa'_WQGH_1_10070_V ;
    fear_V2        = prepV2 (beza'_BZGH_1_7541_V) minnP ;
    fear_VS        = beza'_BZGH_1_7541_V;
    fight_V2       = prepV2 (ggieled_GLD_6_8074_V) maP ;
    find_V2        = lilV2 (sab_SJB_1_9779_V) ;
    float_V        = gham_GHWM_1_10750_V ; ---
    flow_V         = ghadda_GHDJ_2_10679_V ;
    fly_V          = tar_TJR_1_9972_V ;
    forget_V2      = lilV2 (nesa_NSJ_1_9126_V) ;
    freeze_V       = ffriza_V ;
    give_V3        = mkV3 ta_GHTJ_1_10767_V lilP ;
    go_V           = mar_MWR_1_8918_V ;
    hate_V2        = lilV2 (baghad_BGHD_1_7402_V) ;
    hear_V2        = lilV2 (sema'_SMGH_1_9698_V) ;
    hit_V2         = lilV2 (laqat_LQT_1_8772_V) ;
    hold_V2        = lilV2 (zamm_ZMM_1_10392_V) ;
    hope_VS        = xtaq_XWQ_8_10313_V ;
    hunt_V2        = prepV2 (kaccac_KCC_2_8571_V) ghalP ;
    jump_V         = qabez_QBZ_1_9182_V ;
    kill_V2        = lilV2 (qatel_QTL_1_9312_V) ;
    know_V2        = lilV2 (af_''F_1_10774_V) ;
    know_VQ        = af_''F_1_10774_V ;
    know_VS        = af_''F_1_10774_V ;
    laugh_V        = dahak_DHK_1_7688_V ;
    learn_V2       = dirV2 (tghallem_GHLM_5_10527_V) ;
    leave_V2       = prepV2 (telaq_TLQ_1_9903_V) minnP ;
    lie_V          = mtedd_MDD_8_8816_V ; -- lie down
    like_V2        = lilV2 (ghogob_GHGB_1_10485_V) ;
    listen_V2      = lilV2 (sema'_SMGH_1_9698_V) ;
    live_V         = ghex_GHJX_1_10711_V ;
    lose_V2        = lilV2 (tilef_TLF_1_9895_V) ;
    love_V2        = lilV2 (habb_HBB_1_8174_V) ;
    open_V2        = dirV2 (fetah_FTH_1_7932_V) ;
    paint_V2A      = dirV2 (zeba'_ZBGH_1_10339_V) ; -- dirV2 (pitter_PTR_2_9152_V) ;
    play_V         = daqq_DQQ_1_7736_V ;
    play_V2        = prepV2 (laghab_LGHB_1_8724_V) maP ;
    pull_V2        = lilV2 (gibed_GBD_1_8043_V) ;
    push_V2        = dirV2 (mbotta_V) ; -- GĦAFAS
    put_V2         = lilV2 (qieghed_QGHD_3_9212_V) ;
    rain_V0        = xita_XTW_1_10297_V ; -- TAGĦMEL IX-XITA
    read_V2        = dirV2 (qara_QRJ_1_9350_V) ;
    rub_V2         = dirV2 (ghorok_GHRK_1_10599_V) ;
    run_V          = gera_GRJ_1_8131_V ;
    say_VS         = qal_QWL_1_9357_V ;
    scratch_V2     = lilV2 (barax_BRX_1_7504_V) ;
    see_V2         = lilV2 (ra_R'J_1_9513_V) ;
    seek_V2        = lilV2 (fittex_FTX_2_7952_V) ;
    sell_V3        = mkV3 biegh_BJGH_1_7565_V lilP ;
    send_V3        = mkV3 baghat_BGHT_1_7412_V lilP ;
    sew_V          = hat_HJT_1_8508_V ;
    sing_V         = kanta_KNTJ_1_7016_V ;
    sit_V          = pogga_PGJ_2_9157_V ;
    sleep_V        = raqad_RQD_1_9469_V ;
    smell_V        = xamm_XMM_1_10207_V ;
    speak_V2       = prepV2 (kellem_KLM_2_8597_V) maP ;
    spit_V         = bezaq_BZQ_1_7549_V ;
    split_V2       = lilV2 (qasam_QSM_1_9292_V) ;
    squeeze_V2     = dirV2 (ghasar_GHSR_1_10625_V) ;
    stab_V2        = lilV2 (mewwes_MWS_2_8921_V) ;
    stand_V        = qaghad_QGHD_1_9210_V ;
    stop_V         = waqaf_WQF_1_10067_V ;
    suck_V2        = lilV2 (rada'_RDGH_1_9388_V) ;
    swell_V        = ntefah_NFH_8_8970_V ;
    swim_V         = gham_GHWM_1_10750_V ;
    switch8off_V2  = dirV2 (tefa_TFJ_1_9960_V) ;
    switch8on_V2   = dirV2 (xeghel_XGHL_1_10155_V) ;
    talk_V3        = mkV3 kellem_KLM_2_8597_V maP fuqP ; -- PAĊPAĊ, PARLA
    teach_V2       = lilV2 (ghallem_GHLM_2_10526_V) ;
    think_V        = haseb_HSB_1_8387_V ;
    throw_V2       = dirV2 (waddab_WDB_2_10027_V) ;
    tie_V2         = dirV2 (qafel_QFL_1_9206_V) ;
    travel_V       = vvjagga_V ;
    turn_V         = dar_DWR_1_7803_V ;
    understand_V2  = lilV2 (fehem_FHM_1_10830_V) ;
    vomit_V        = qala'_QLGH_1_9223_V ;
    wait_V2        = lilV2 (stenna_'NJ_10_10781_V) ;
    walk_V         = mexa_MXJ_1_8926_V ;
    wash_V2        = lilV2 (hasel_HSL_1_8395_V) ;
    watch_V2       = dirV2 (ra_R'J_1_9513_V) ;
    win_V2         = dirV2 (rebah_RBH_1_9371_V) ;
    wipe_V2        = dirV2 (mesah_MSH_1_8881_V) ;
    wonder_VQ      = kkuntempla_V ;
    write_V2       = dirV2 (kiteb_KTB_1_8641_V) ;

  -- Adjectives
  lin
    bad_A          = brokenA "ħażin" "hżiena" "agħar" ;
    beautiful_A    = brokenA "sabiħ" "sbieħ" "isbaħ" ;
    big_A          = brokenA "kbir" "kbar" "ikbar" ;
    black_A        = mkA "iswed" "sewda" "suwed" ;
    blue_A         = sameA "blu" ;
    broad_A        = mkA "wiesgħa" "wiesgħa" "wiesgħin" ;
    brown_A        = sameA "kannella" ;
    clean_A        = brokenA "nadif" "nodfa" ;
    clever_A       = mkA "bravu" ;
    cold_A         = mkA "kiesaħ" "kiesħa" "kesħin" ;
    correct_A      = mkA "korrett" ;
    dirty_A        = mkA "maħmuġ" ;
    dry_A          = mkA "niexef" ;
    dull_A         = sameA "tad-dwejjaq" ;
    easy_A2V       = dirA2 (sameA "faċli") ;
    empty_A        = mkA "vojt" "vojta" "vojta" ;
    full_A         = mkA "mimli" ;
    fun_AV         = sameA "pjaċevoli" ;
    good_A         = mkA "tajjeb" "tajba" "tajbin" ;
    green_A        = mkA "aħdar" "ħadra" "ħodor" ;
    heavy_A        = brokenA "tqil" "tqal" "itqal" ;
    hot_A          = mkA "jaħraq" "taħraq" "jaħarqu" ;
    important_A    = sameA "importanti" ;
    long_A         = brokenA "twil" "twal" "itwal" ;
    married_A2     = mkA2 (mkA "miżżewweġ" "miżżewġa") lilP ;
    narrow_A       = mkA "dejjaq" "dejqa" "dojoq" "idjaq" ;
    near_A         = mkA "viċin" ;
    new_A          = brokenA "ġdid" "ġodda" ;
    old_A          = brokenA "qadim" "qodma" "eqdem" ; -- xiħ
    probable_AS    = mkAS (sameA "probabbli") ;
    ready_A        = mkA "lest" ;
    red_A          = mkA "aħmar" "ħamra" "ħomor" ;
    rotten_A       = mkA "mħassar" "mħassra" "mħassrin" ;
    round_A        = mkA "tond" ;
    sharp_A        = mkA "jaqta'" "taqta'" "jaqtgħu" ;
    short_A        = brokenA "qasir" "qosra" "iqsar" ;
    small_A        = brokenA "zgħir" "zgħar" "iżgħar" ;
    smooth_A       = mkA "lixx" ;
    straight_A     = mkA "dritt" ;
    stupid_A       = mkA "iblah" "belha" "boloh" ;
    thick_A        = mkA "oħxon" "ħoxna" "ħoxnin" "eħxen" ;
    thin_A         = brokenA "rqiq" "rqaq" "rqaq" ;
    ugly_A         = mkA "ikrah" "kerha" "koroh" ;
    uncertain_A    = mkA "inċert" ;
    warm_A         = brokenA "sħun" "sħan" ;
    wet_A          = mkA "mxarrab" "mxarrba" "mxarrbin" ;
    white_A        = mkA "abjad" "bajda" "bojod" ;
    wide_A         = broad_A ;
    yellow_A       = mkA "isfar" "safra" "sofor" ;
    young_A        = small_A ;

  -- Others
  lin
    alas_Interj    = ss "sfortunatament" ;
    already_Adv    = mkAdv "diġà" ;
    far_Adv        = mkAdv "il-bogħod" ; -- use glue?
    john_PN        = mkPN "Ġanni" masculine singular ;
    left_Ord       = mkOrd "xellug" ;
    now_Adv        = mkAdv "issa" ;
    paris_PN       = mkPN "Pariġi" feminine singular ;
    right_Ord      = mkOrd "lemin" ;
    today_Adv      = mkAdv "illum" ;

  oper
    fuqP = mkPrep "fuq" ;
    ghandP = mkPrep "għand" ;
    ghalP = mkPrep "għal" ;
    minnP = mkPrep "minn" ;
    goP = mkPrep "ġo" ;
    lilP = mkPrep "lil" ;
    maP = mkPrep "ma'" ;
    taP = mkPrep "ta'" ;
    saP = mkPrep "sa" ;
    biP = mkPrep "bi" ;
    fiP = mkPrep "fi" ;

    lilV2 : V -> V2 ;
    lilV2 v = prepV2 v (mkPrep "lil") ;

    genderedN : N = overload {
      genderedN : Str -> Str -> N = \qattus,qtates ->
        let
          m : N = mkN qattus qtates masculine ;
          f : N = mkN (qattus+"a") qtates feminine ;
        in (m | f) ;
      genderedN : Str -> Str -> Str -> N = \qattus,qattusa,qtates ->
        let
          m : N = mkN qattus qtates masculine ;
          f : N = mkN qattusa qtates feminine ;
        in (m | f) ;
      } ;
} ;
