-- (c) 2010 Aarne Ranta under LGPL
--# -coding=latin1

concrete WordsSwe of Words = SentencesSwe ** 
    open SyntaxSwe, ParadigmsSwe, IrregSwe, (L = LexiconSwe), ExtraSwe, Prelude in {

  lin

-- kinds of food

    Apple = mkCN L.apple_N ;
    Beer = mkCN L.beer_N ;
    Bread = mkCN L.bread_N ;
    Cheese = mkCN (mkN "ost") ;
    Chicken = mkCN (mkN "kyckling") ;
    Coffee = mkCN (mkN "kaffe" neutrum) ;
    Fish = mkCN L.fish_N ;
    Meat = mkCN (mkN "ktt" "ktt") ;
    Milk = mkCN L.milk_N ;
    Pizza = mkCN (mkN "pizza") ;
    Salt = mkCN L.salt_N ;
    Tea = mkCN (mkN "te" neutrum) ;
    Water = mkCN L.water_N ;
    Wine = mkCN L.wine_N ;

-- properties

    Bad = L.bad_A ;
    Cheap = mkA "billig" ;
    Boring = mkA "trkig" ;
    Cold = L.cold_A ;
    Delicious = mkA "lcker" ;
    Expensive = mkA "dyr" ;
    Fresh = mkA "frsk" ;
    Good = L.good_A ;
    Suspect = mkA "suspekt" "suspekt" ;
    Warm = L.warm_A ;

-- places

    Airport = mkPlace (mkN "flygplats" "flygplatser") "p" ;
    AmusementPark = mkPlace (mkN "njespark" "njesparker") "i" ;
    Bank = mkPlace (mkN "bank" "banker") "i" ;
    Bar = mkPlace (mkN "bar" "barer") "i" ;
    Cafeteria = mkPlace (mkN "caf" "caf") "p" ;
    Center = mkPlace (mkN "innerstad" "innerstder") "p" ; ----
    Church = mkPlace (mkN "kyrka") "i" ;
    Cinema = mkPlace (mkN "bio" "bion" "biografer" "biograferna") "p" ; ---- ?
    Disco = mkPlace (mkN "diskotek" "diskotek") "p" ;
    Hospital = mkPlace (mkN "sjukhus" "sjukhus") "p" ;
    Hotel = mkPlace (mkN "hotell" "hotell") "p" ;
    Museum = mkPlace (mkN "museum" "museet" "museer" "museerna") "p" ;
    Park = mkPlace (mkN "park" "parker") "i" ;
    Parking = mkPlace (mkN "parkering") "p" ;
    Pharmacy = mkPlace (mkN "apotek" "apotek") "i" ;
    PostOffice = mkPlace (mkN "post" "poster") "p" ;
    Pub = mkPlace (mkN "pub") "p" ;
    Restaurant = mkPlace (mkN "restaurang" "restauranger") "p" ;
    Shop = mkPlace (mkN "affr" "affrer") "i" ;
    School = mkPlace (mkN "skola") "p" ;
    Station = mkPlace (mkN "station" "stationer") "p" ;
    Supermarket = mkPlace (mkN "snabbkp" "snabbkp") "p" ;
    Theatre = mkPlace (mkN "teater" "teatrar") "p" ;
    Toilet = mkPlace2 (mkN "toalett" "toaletter") "p" "p" ;
    University = mkPlace (mkN "universitet" "universitet") "p" ;
    Zoo = mkPlace (mkN "djurpark" "djurparker") "i" ;

    CitRestaurant cit = 
      mkCNPlace (mkCN cit (mkN "restaurang" "restauranger")) on_Prep to_Prep ;

-- currencies

    DanishCrown = mkCN (mkA "dansk") (mkN "krona") | mkCN (mkN "krona") ;
    Dollar = mkCN (mkN "dollar" "dollar") ;
    Euro = mkCN (mkN "euro" "euro") ;
    Lei = mkCN (mkN "lei" "lei") ;
    Leva = mkCN (mkN "leva" "leva") ;
    NorwegianCrown = mkCN (mkA "norsk") (mkN "krona") | mkCN (mkN "krona") ;
    Pound = mkCN (mkN "pund" "pund") ; ---- ett pund ?
    Rouble = mkCN (mkN "rubel" "rubeln" "rubel" "rubeln") ; ---- ?
    Rupee = mkCN (mkN "rupee" "rupee") ; ---- 
    SwedishCrown = mkCN (mkA "svensk") (mkN "krona") | mkCN (mkN "krona") ;
    Zloty = mkCN (mkN "zloty" "zloty") ;
    Yuan = mkCN (mkN "yuan" "yuan") ;

-- nationalities

    Belgian = mkA "belgisk" ;
    Belgium = mkNP (mkPN "Belgien") ;
    Bulgarian = mkNat "bulgarisk" "Bulgarien" ;
    Catalan = mkNat "katalansk" "Katalonien" ;
    China = mkNat "kinesisk" "Kina" ;
    Danish = mkNat "dansk" "Danmark" ;
    Dutch = mkNat "nederlndsk" "Nederlnderna" ;
    English = mkNat "engelsk" "England" ;
    Finnish = mkNat "finsk" "Finland" ;
    Flemish = mkNP (mkPN "flamlndska") ;
    French = mkNat "fransk" "Frankrike" ;
    German = mkNat "tysk" "Tyskland" ;
    Hindi = mkNP (mkPN "hindi") ;
    Indian = mkA "indisk" ; 
    India = mkNP (mkPN "Indien") ;
    Italian = mkNat "italiensk" "Italien" ;
    Norwegian = mkNat "norsk" "Norge" ;
    Polish = mkNat "polsk" "Polen" ;
    Romanian = mkNat "rumnsk" "Rumnien" ;
    Russian = mkNat "rysk" "Ryssland" ;
    Spanish = mkNat "spansk" "Spanien" ;
    Swedish = mkNat "svensk" "Sverige" ;

-- means of transportation 

    Bike = mkTransport L.bike_N ; 
    Bus = mkTransport (mkN "buss") ;
    Car = mkTransport L.car_N ;
    Ferry = mkTransport (mkN "frja") ;
    Plane = mkTransport L.airplane_N ;
    Subway = mkTransport (mkN "tunnelbana") ;
    Taxi = mkTransport (mkN "taxi" "taxin" "taxibilar" "taxibilarna") ; ----
    Train = mkTransport L.train_N ;
    Tram = mkTransport (mkN "sprvagn") ;

    ByFoot = ParadigmsSwe.mkAdv "till fots" ;

-- actions

    AHasAge p num = mkCl p.name (mkNP num L.year_N) ;
    AHasName p name = mkCl p.name (mkV2 (mkV "heter")) name ;
    AHasChildren p num = mkCl p.name have_V2 (mkNP num L.child_N) ;
    AHasRoom p num = mkCl p.name have_V2 
      (mkNP (mkNP a_Det (mkN "rum" "rum")) 
        (SyntaxSwe.mkAdv for_Prep (mkNP num (mkN "person" "personer")))) ;
    AHasTable p num = mkCl p.name have_V2 
      (mkNP (mkNP a_Det (mkN "bord" "bord")) 
        (SyntaxSwe.mkAdv for_Prep (mkNP num (mkN "person" "personer")))) ;
    AHungry p = mkCl p.name (mkA "hungrig") ;
    AIll p = mkCl p.name (mkA "sjuk") ;
    AKnow p = mkCl p.name (mkV "veta" "vet" "vet" "visste" "vetat" "visst") ; 
    ALike p item = mkCl p.name (mkV2 (mkV "tycker") (mkPrep "om")) item ;
    ALive p co = mkCl p.name (mkVP (mkVP (mkV "bo")) (SyntaxSwe.mkAdv in_Prep co)) ;
    ALove p q = mkCl p.name (mkV2 (mkV "lska")) q.name ;
    AMarried p = mkCl p.name (mkA "gift") ;
    AReady p = mkCl p.name (mkA "frdig") ;
    AScared p = mkCl p.name (mkA "rdd") ;
    ASpeak p lang = mkCl p.name  (mkV2 (mkV "tala")) lang ;
    AThirsty p = mkCl p.name (mkA "trstig") ;
    ATired p = mkCl p.name (mkA "trtt") ;
    AUnderstand p = mkCl p.name (mkV "frst" "frstod" "frsttt") ;
    AWant p obj = mkCl p.name want_VV (mkVP have_V2 obj) ;
    AWantGo p place = mkCl p.name want_VV (mkVP (mkVP L.go_V) place.to) ;

-- miscellaneous

    QWhatName p = mkQS (mkQCl whatSg_IP p.name (mkV2 (mkV "heter"))) ;
    QWhatAge p = mkQS (mkQCl (ICompAP (mkAP L.old_A)) p.name) ;
    HowMuchCost item = mkQS (mkQCl how8much_IAdv (mkCl item (mkV "kosta"))) ; 
    ItCost item price = mkCl item (mkV2 (mkV "kosta")) price ;

    PropOpen p = mkCl p.name open_A ;
    PropClosed p = mkCl p.name closed_A ;
    PropOpenDate p d = mkCl p.name (mkVP (mkVP open_A) d) ; 
    PropClosedDate p d = mkCl p.name (mkVP (mkVP closed_A) d) ; 
    PropOpenDay p d = mkCl p.name (mkVP (mkVP open_A) d.habitual) ; 
    PropClosedDay p d = mkCl p.name (mkVP (mkVP closed_A) d.habitual) ; 

-- Building phrases from strings is complicated: the solution is to use
-- mkText : Text -> Text -> Text ;

    PSeeYouDate d = mkText (lin Text (ss ("vi ses"))) (mkPhrase (mkUtt d)) ;
    PSeeYouPlace p = mkText (lin Text (ss ("vi ses"))) (mkPhrase (mkUtt p.at)) ;
    PSeeYouPlaceDate p d = 
      mkText (lin Text (ss ("vi ses"))) 
        (mkText (mkPhrase (mkUtt p.at)) (mkPhrase (mkUtt d))) ;

-- Relations are expressed as "my wife" or "my son's wife", as defined by $xOf$
-- below. Languages without productive genitives must use an equivalent of
-- "the wife of my son" for non-pronouns.

    Wife = xOf sing (mkN "fru" "fruar") ;
    Husband = xOf sing L.man_N ;
    Son = xOf sing (mkN "son" "sner") ;
    Daughter = xOf sing (mkN "dotter" "dttrar") ;
    Children = xOf plur L.child_N ;

-- week days

    Monday = mkDay "mndag" ;
    Tuesday = mkDay "tisdag" ;
    Wednesday = mkDay "onsdag" ;
    Thursday = mkDay "torsdag" ;
    Friday = mkDay "fredag" ;
    Saturday = mkDay "lrdag" ;
    Sunday = mkDay "sndag" ;

    Tomorrow = ParadigmsSwe.mkAdv "imorgon" ;

-- transports

    HowFar place = 
      mkQS (mkQCl far_IAdv (mkCl (mkVP place.to))) ;
    HowFarFrom x y = 
      mkQS (mkQCl far_IAdv (mkCl (mkVP (mkVP y.to) 
                    (SyntaxSwe.mkAdv from_Prep x.name)))) ;
    HowFarFromBy x y t = 
      mkQS (mkQCl far_IAdv (mkCl (mkVP (mkVP (mkVP y.to) 
                    (SyntaxSwe.mkAdv from_Prep x.name)) t))) ;
    HowFarBy place t = 
      mkQS (mkQCl far_IAdv (mkCl (mkVP (mkVP place.to) t))) ;

    WhichTranspPlace trans place = 
      mkQS (mkQCl (mkIP which_IDet trans.name) (mkVP (mkVP L.go_V) place.to)) ;

    IsTranspPlace trans place =
      mkQS (mkQCl (mkCl (mkCN trans.name place.to))) ;

-- modifiers of places

    TheBest = mkSuperl L.good_A ;
    TheClosest = mkSuperl L.near_A ; 
    TheCheapest = mkSuperl (mkA "billig") ;
    TheMostExpensive = mkSuperl (mkA "dyr") ;
    TheMostPopular = mkSuperl (mkA "populr") ;
    TheWorst = mkSuperl L.bad_A ;

    SuperlPlace sup p = placeNP sup p ;

  oper
    mkNat : Str -> Str -> NPNationality = \nat,co -> 
      mkNPNationality (mkNP (mkPN (nat + "a"))) (mkNP (mkPN co)) (mkA nat) ;

    mkDay : Str -> {name : NP ; point : Adv ; habitual : Adv} = \d ->
      let day = mkNP (mkPN d) in 
      mkNPDay day (SyntaxSwe.mkAdv on_Prep day) 
        (SyntaxSwe.mkAdv on_Prep (mkNP a_Quant plNum (mkCN (mkN d)))) ;

    mkPlace : N -> Str -> {name : CN ; at : Prep ; to : Prep ; isPl : Bool} = \p,i -> 
      mkCNPlace (mkCN p) (mkPrep i) to_Prep ;
    mkPlace2 : N -> Str -> Str -> {name : CN ; at : Prep ; to : Prep ; isPl : Bool} = 
      \p,i,t -> mkCNPlace (mkCN p) (mkPrep i) (mkPrep t) ;

    open_A = mkA "ppen" "ppet" ;
    closed_A = mkA "stngd" "stngt" ;

    xOf : GNumber -> N -> NPPerson -> NPPerson = \n,x,p -> 
      relativePerson n (mkCN x) (\a,b,c -> mkNP (GenNP b) a c) p ;

    mkTransport : N -> {name : CN ; by : Adv} = \n -> {
      name = mkCN n ; 
      by = SyntaxSwe.mkAdv with_Prep (mkNP n)
      } ;

    mkSuperl : A -> Det = \a -> mkDet the_Art (mkOrd a) ;

    far_IAdv = ExtraSwe.IAdvAdv L.far_Adv ;

--------------------------------------------------
-- New 30/11/2011 AR
--------------------------------------------------

  lin
    Thai = mkNPNationality (mkNP (mkPN "thai")) (mkNP (mkPN "Thailand")) (mkA "thailndsk") ;
    Baht = mkCN (mkN "baht" "baht") ;

    Rice = mkCN (mkN "ris" "ris") ;
    Pork = mkCN (mkN "flsk" "flsk") ;
    Beef = mkCN (mkN "ntktt" "ntktt") ;
    Egg = mkCN L.egg_N ;
    Noodles = mkCN (mkN "nudel" "nudlar") ;
    Shrimps = mkCN (mkN "rka") ;
    Chili = mkCN (mkN "chili" "chilier") ;
    Garlic = mkCN (mkN "vitlk") ;
    Durian = mkCN (mkN "durian" "durianer") ;
    Mango = mkCN (mkN "mango" "mangoer") ;
    Pineapple = mkCN (mkN "ananas" "ananaser") ;
    Coke = mkCN (mkN "kola") ;
    IceCream = mkCN (mkN "glass") ;
    Salad = mkCN (mkN "sallad" "sallader") ;
    OrangeJuice = mkCN (mkN "apelsinjuice" "apelsinjuicer") ;
    Lemonade = mkCN (mkN "lsk") ;
    Beach = mkPlace (mkN "badstrand" "badstrnder") "p" ;

    ItsRaining = mkCl (mkVP L.rain_V0) ;
    ItsCold = mkCl (mkVP L.cold_A) ;
    ItsWarm = mkCl (mkVP L.warm_A) ;
    ItsWindy = mkCl (mkVP (mkV "blser")) ;
    SunShine = mkCl (mkNP the_Det L.sun_N) (skina_V) ;

    Smoke = mkVP (mkV "rker") ;

    ADoctor = mkProfession (mkN "lkare" "lkare") ;
    AProfessor = mkProfession (mkN "professor" "professorer") ;
    ALawyer = mkProfession (mkN "jurist" "jurister") ;
    AEngineer =  mkProfession (mkN "ingenjr" "ingenjrer") ;
    ATeacher = mkProfession (mkN "lrare" "lrare") ;
    ACook = mkProfession (mkN "kock") ;
    AStudent = mkProfession (mkN "student" "srudenter") ;
    ABusinessman = mkProfession (mkN "affrsman" "affrsmannen" "affrsmn" "affrsmnnen") ;

  oper
    mkProfession : N -> NPPerson -> Cl = \n,p -> mkCl p.name (mkVP (CompBareCN (mkCN n))) ;

}
