concrete LexiconChi of Lexicon = CatChi ** 
  open ParadigmsChi, ResChi, Prelude in {

flags 
  coding = utf8 ;

lin

-- LexiconCmn

  man_N = mkN "nánrén" "gè";        -- "nanren" "ge" first being noun, second is classifier(counter)
  woman_N = mkN "nǚrén" "gè";      -- "nvren"  "ge" classifier behaves like the "cup" in "cup of tea"
  house_N = mkN "fángzǐ" "jiān";      -- "fangzi" "jian"
  tree_N = mkN "shù" "kē";         -- "shu"  "ke"
  big_A = mkA "dà" ;          -- "da"
  small_A = mkA "xiaǒ" ;        -- "xiao"
  green_A = mkA "lǜ" ;        -- "lv"
  walk_V = mkV "zoǔ" ;             -- "zou"
  sleep_V = mkV "shuìjiaò" ;            -- "shui"
  love_V2 = mkV2 "aì" ;            -- "ai"
  watch_V2 = mkV2 "kān" ;            -- "kan"
  know_VS = mkV "zhīdaò" ;          -- "zhidao"
  wonder_VQ = mkV "haǒjī" ;        -- "haoqi" 
  john_PN = mkPN "yaōhàn"  ;        -- "yuehan"


-- Swadesh

long_A = mkA "cháng" ;
wide_A = mkA "kuān" ;
thick_A = mkA "hoù" ;
heavy_A = mkA "chóng" ;
short_A = mkA "duǎn" ;
narrow_A = mkA "zhaǐ" ;
thin_A = mkA "bó" ;   -- [mark] for person mkA "shoù"
child_N = mkN "haízǐ" ;
wife_N = mkN "qīzǐ" | mkN "aìrén" ;
husband_N = mkN "zhàngfū" ;
animal_N = mkN "dòngwù" "qí"; -- [mark] added classifier for nouns
fish_N = mkN "yú" "tiaó";
bird_N = mkN "niaǒ" "qí";
dog_N = mkN "goǔ" "qí";
louse_N = mkN "shī" "qí";
snake_N = mkN "shé" "tiaó";
worm_N = mkN "chóng" "qí";
forest_N = mkN "sēnlín" "piān";
stick_N = mkN "shùzhī" ;
fruit_N = mkN "shuǐguǒ" ;
seed_N = mkN "zhǒngzǐ" "lì";
leaf_N = mkN "yèzǐ" "piān"; -- [mark] "yè" -> "yèzǐ" , "yè" is often treated as morpheme
root_N = mkN "shùgēn" ; -- [mark] "gēn" --> "shùgēn"(tree root)
bark_N = mkN "shùpí" "kuaī";
flower_N = mkN "huā" "duǒ";
grass_N = mkN "caǒ" "kē";
rope_N = mkN "shéng" "gēn";
skin_N = mkN "pí" "kuaī";
meat_N = mkN "roù" "kuaī";
blood_N = mkN "xiě" "dī"; -- [mark] several classifiers, "dī"(drop), "tān"(puddle)
bone_N = mkN "gǔtoú" "kuaī"; -- [mark] "gǔ" -> "gǔtoú" , "gǔ" is often treated as morpheme
fat_N = mkN "zhīfáng" "duī"; -- [mark] often without classifier
egg_N = mkN "dàn" "kē";
horn_N = mkN "jiaǒ" "gēn";
tail_N = mkN "weǐbā" "tiaó"; -- [mark] "weǐ" -> "weǐbā" , "weǐ" is often treated as morpheme, or if stands alone, it is a classifier itself
feather_N = mkN "yǔmaó" "gēn";
hair_N = mkN "toúfā" "gēn"; -- [mark] several classifiers , "gēn"(single hair), "bǎ"(several hairs)
head_N = mkN "toú" "kē"; 
ear_N = mkN "ěrduǒ" "qí";
eye_N = mkN "yǎnjīng" "qí";
nose_N = mkN "bízǐ" ;
mouth_N = mkN "zuǐ" "zhāng";
tooth_N = mkN "yáchǐ" "kē";
tongue_N = mkN "shé" "gēn";
fingernail_N = mkN "zhǐjiǎ" "piān";
foot_N = mkN "jiaǒ" "qí";
leg_N = mkN "tuǐ" "tiaó";
knee_N = mkN "xīgaì" ; -- [mark] "xī" -> "xīgaì"
hand_N = mkN "shoǔ" "qí";
wing_N = mkN "chìbǎng" "qí"; -- [mark] "yì" -> "chìbǎng", "chìbǎng" is the common form for wing.
belly_N = mkN "dǔzǐ" ;
guts_N = mkN "chángzǐ" "gēn";
neck_N = mkN "bózǐ" ;
back_N = mkN "beī" ; 
breast_N = mkN "xiōng" ;
heart_N = mkN "xīnzāng" "kē";
liver_N = mkN "gān" ;
drink_V2 = mkV2 "hē" ;
eat_V2 = mkV2 "chī" ;
bite_V2 = mkV2 "yaǒ" ;
suck_V2 = mkV2 "xī" ;
spit_V = mkV "tǔ" ;
vomit_V = mkV "oǔ" ;
blow_V = mkV "chuī" ;
breathe_V = mkV "hūxī" ;
laugh_V = mkV "xiaò" ;
see_V2 = mkV2 "kān" ;
hear_V2 = mkV2 "tīng" ;
think_V = mkV "xiǎng" ;
smell_V = mkV "wén" ; -- [mark] "xiù" -> "wén", "wén" is the common form for smell.
fear_V2 = mkV2 "pà" ;
live_V = mkV "huó" ;
die_V = mkV "sǐ" ;
kill_V2 = mkV2 "shā" ;
fight_V2 = mkV2 "dájià" ; -- [mark] "chaǒjià" -> "dájià", "chaǒjià" = quarrel, argue
hunt_V2 = mkV2 "dáliè" ; -- [mark] "dáliè" is iv, can't think of proper translation in v2 form for hunt 
hit_V2 = mkV2 "dá" ;
cut_V2 = mkV2 "gē" ;
split_V2 = mkV2 "pīkaī" ;
stab_V2 = mkV2 "cì" ;
scratch_V2 = mkV2 "saō" ;
dig_V = mkV "wā" ;
swim_V = mkV "yoúyǒng" ;
fly_V = mkV "feī" ;
come_V = mkV "laí" ;
lie_V = mkV "tǎng" ;
sit_V = mkV "zuò" ;
stand_V = mkV "zhàn" ;
turn_V = mkV "zhuǎn" ;
fall_V = mkV "làxià" ;
hold_V2 = mkV2 "wò" ;
squeeze_V2 = mkV2 "jǐ" ;
rub_V2 = mkV2 "roú" ;
wash_V2 = mkV2 "xǐ" ;
wipe_V2 = mkV2 "cā" ;
pull_V2 = mkV2 "lā" ;
push_V2 = mkV2 "tuī" ;
throw_V2 = mkV2 "rēng" ;
tie_V2 = mkV2 "bǎng" ;
sew_V = mkV "féng" ;
count_V2 = mkV2 "shǔ" ;
say_VS = mkVS (mkV "shuì") ;
sing_V = mkV "chànggē" ;
play_V = mkV "wán" ;
float_V = mkV "fú" ;
flow_V = mkV "liú" ;
freeze_V = mkV "jiēbīng" ;
swell_V = mkV "péngzhàng" ;
sun_N = mkN "taìyáng" ;
moon_N = mkN "yuèliàng" ;
star_N = mkN "xīngxīng" "kē";
water_N = mkN "shuǐ" "dī";
rain_N = mkN "yǔ" "chǎng";
river_N = mkN "hé" "tiaó";
lake_N = mkN "hú" ;
sea_N = mkN "haǐ" "piān";
salt_N = mkN "yán" "píng";
stone_N = mkN "dàntoú" "kuaī";
sand_N = mkN "shā" "lì";
dust_N = mkN "chéntǔ" [];
earth_N = mkN "deqiú" ;
cloud_N = mkN "yún" "duǒ";
fog_N = mkN "wù" "chǎng";
sky_N = mkN "tiānkōng" "piān";
wind_N = mkN "fēng" "zhèn";
snow_N = mkN "xuě" "chǎng";
ice_N = mkN "bīng" "kuaī";
smoke_N = mkN "yān" "zhèn";
fire_N = mkN "huǒ" "chǎng";
ashes_N = mkN "huī" [];
burn_V = mkV "shaō" ;
road_N = mkN "lù" "tiaó";
mountain_N = mkN "shān" "zuò";
red_A = mkA "hóng" ;
yellow_A = mkA "huáng" ;
white_A = mkA "baí" ;
black_A = mkA "heī" ;
night_N = mkN "yèwǎn" ; -- [mark] "yèwǎn" 's classifier is "gè"
day_N = mkN "baítiān" []; -- [mark] "baítiān" -> "tiān", "tiān" itself is classifier
year_N = mkN "nián" [] ; -- [mark] "nián" itself is classifier
warm_A = mkA "wēnnuǎn" ;
cold_A = mkA "lěng" ;
full_A = mkA "mǎn" ;
new_A = mkA "xīn" ;
old_A = mkA "laǒ" ; -- [mark] "laǒ" for person, "jiù" for things
good_A = mkA "haǒ" ;
bad_A = mkA "huaì" ;
rotten_A = mkA "làn" ;
dirty_A = mkA "zāng" ;
straight_A = mkA "zhí" ;
round_A = mkA "yuán" ;
sharp_A = mkA "jiān" ;
dull_A = mkA "dùn" ;
smooth_A = mkA "guānggǔ" ;
wet_A = mkA "shī" ;
dry_A = mkA "gān" ;
correct_A = mkA "duì" ;
near_A = mkA "jìn" ;
--far_A = mkA "yuǎn" ;
left_Ord = ss "zuǒ" ;
right_Ord = ss "yoù" ;
name_N = mkN "míngzì" ; -- [mark] "míng" --> "míngzì"

-- HSK

add_V3 = mkV3 "jiā" ;
airplane_N = mkN "feījī" "jià";
already_Adv = mkAdv "yǐjīng" ;
answer_V2S = mkV2S (mkV "huídā") ;
apple_N = mkN "pínguǒ" ;
art_N = mkN "yìshù" []; -- [mark] usually without classifier
ask_V2Q = mkV2Q (mkV "wèn") ;
bank_N = mkN "yínháng" "jiān";
beautiful_A = mkA "piaōliàng" ;
become_VA = mkV "biàn" ;
beer_N = mkN "píjiǔ" "beī";
bike_N = mkN "zìhángchē" "taí";
blue_A = mkA "la" ;
boat_N = mkN "chuán" "saō";
book_N = mkN "shū" "běn";
bread_N = mkN "miànbaō" ;
buy_V2 = mkV2 "maǐ" ;
cap_N = mkN "maòzǐ" "dǐng";
car_N = mkN "qìchē" "taí";
chair_N = mkN "yǐzǐ" "bǎ";
city_N = mkN "chéngshì" ; -- [mark] "shì" --> "chéngshì"
clean_A = mkA "gānjìng" ;
coat_N = mkN "yīfú" "jiàn";
country_N = mkN "guójiā" ; -- [mark] "guó" --> "guójiā"
cow_N = mkN "niú" "toú";
do_V2 = mkV2 "zuò" ;
doctor_N = mkN "yīshēng" "míng";
door_N = mkN "mén" "shān";
factory_N = mkN "gōngchǎng" "jiān";
far_Adv = mkAdv "yuǎn" ;
fear_VS = mkVS (mkV "pà") ;
find_V2 = mkV2 "fāxiàn" ;
forget_V2 = mkV2 "wàng" ;
friend_N = mkN "péngyoǔ" ;
girl_N = mkN "gūniáng" ;
give_V3 = mkV3 "geǐ" ;
go_V = mkV "qù" ;
grammar_N = mkN "yǔfǎ" ;
hat_N = mkN "maòzǐ" "dǐng";
hill_N = mkN "shān" "zuò";
hope_VS = mkV "xīwàng" ;
horse_N = mkN "mǎ" "pī";
hot_A = mkA "rè" ;
important_A = mkA "chóngyaō" ;
industry_N = mkN "gōngyè" [];
jump_V = mkV "tiaò" ;
know_V2 = mkV2 "zhīdaò" ;
know_VQ = mkV "zhīdaò" ;
lamp_N = mkN "dēng" "zhǎn";
language_N = mkN "yǔyán" "zhǒng";
learn_V2 = mkV2 "xué" ;
leave_V2 = mkV2 "líkaī" ; --[mark] "lí" --> "líkaī", "lí" itself is either a morpheme, or a marker indicating distance
like_V2 = mkV2 "xǐhuān" ;
listen_V2 = mkV2 "tīng" ;
lose_V2 = mkV2 "diū" ;
love_V2 = mkV2 "aì" ;
music_N = mkN "yīnlè" [] ; -- [mark] usually without classifier
newspaper_N = mkN "baòzhǐ" "zhāng"; --[mark] "baò" --> "baòzhǐ"
now_Adv = mkAdv "xiànzaì" timeAdvType ;
number_N = mkN "haómǎ" ; -- [mark] "haó" --> "haómǎ"
open_V2 = mkV2 "kaī" ;
paint_V2A = mkV2A (mkV "huà") ;
paper_N = mkN "zhǐ" "zhāng";
pen_N = mkN "bǐ" "qí";
person_N = mkN "rén" ;
play_V2 = mkV2 "wán" ; --[mark] "wánér" --> "wán"
put_V2 = mkV2 "baǐ" ;
question_N = mkN "wèntí" ;

rain_V0 = mkV "xiàyǔ";
read_V2 = mkV2 "doù" ;
reason_N = mkN "daòlǐ" ;
restaurant_N = mkN "fàndiàn" "jiān";
run_V = mkV "paǒ" ;
school_N = mkN "xuéjiaò" "suǒ";
science_N = mkN "kēxué" []; -- [mark] usually without classifier
sell_V3 = mkV3 "maì" ;
send_V3 = mkV3 "jì" ;
sheep_N = mkN "yáng" "qí";
ship_N = mkN "chuán" "saō";
shoe_N = mkN "xié" "qí";
shop_N = mkN "shāngdiàn" "jiān";
song_N = mkN "gē" "shoǔ";
speak_V2 = mkV2 "shuì" ;
student_N = mkN "xuéshēng" "míng" ;
table_N = mkN "zhuōzǐ" "zhāng";
talk_V3 = mkV3 "shuì" ;
teach_V2 = mkV2 "jiaō" ;
teacher_N = mkN "laǒshī" "míng";
television_N = mkN "diànshì" "taí";
today_Adv = mkAdv "jīntiān" timeAdvType ;
train_N = mkN "huǒchē" "liàng";
travel_V = mkV "lǚháng" ;
understand_V2 = mkV2 "dǒng" ;
university_N = mkN "dàxué" "suǒ";
wait_V2 = mkV2 "děng" ;
watch_V2 = mkV2 "kān" ;
win_V2 = mkV2 "yíng" ;
window_N = mkN "chuāng" "shān";
wine_N = mkN "jiǔ" "píng";
write_V2 = mkV2 "xiě" ;
young_A = mkA "niánqīng" ;

-- from Google

apartment_N = mkN "gōngyù" "jiān" ;
baby_N = mkN "yīngér" ;
boot_N = mkN "xuēzǐ" "qí" ; -- [mark] "jī" --> "xuēzǐ"
boss_N = mkN "laǒbǎn" ;
boy_N = mkN "nánhaí" ;
brother_N2 = mkN2 "dìdì" ;
butter_N = mkN "huángyoú" "hé";
camera_N = mkN "shèxiàngtoú" ;
carpet_N = mkN "detǎn" "zhāng";
cat_N = mkN "maō" "qí" ;
ceiling_N = mkN "tiānhuābǎn" ; --[mark] "tiānhuābǎnshàng" --> "tiānhuābǎn"
cheese_N = mkN "naǐlaò" "kuaī";
church_N = mkN "jiaōtáng" "suǒ" ;
computer_N = mkN "jìsuànjī" "taí" ;
cousin_N = mkN "biaǒdì" ;
distance_N3 = mkN3 (mkN "dejùlí") emptyPrep emptyPrep ; ----
enemy_N = mkN "dírén" ;
father_N2 = mkN2 "fùqīn" ;
floor_N = mkN "debǎn" ; -- [mark] floor "debǎn"(have you cleaned the floor) "loúcéng"(which floor do you live?)
fridge_N = mkN "bīngxiāng" "taí" ;
garden_N = mkN "huāyuán" "zuò";
glove_N = mkN "shoǔtaò" "fù";
gold_N = mkN "jīnzǐ" "kuaī"; -- [mark] also without classifier
harbour_N = mkN "haǐgǎng" ;
iron_N = mkN "tiě" "kuaī"; -- [mark] also without classifier
king_N = mkN "guówáng" ;
leather_N = mkN "pígé" "kuaī";
love_N = mkN "aì" [] ; -- [mark] "kuaī" --> [], often without classifier
milk_N = mkN "niúnaǐ" "beī" ; -- [mark] "naǐ" --> "niúnaǐ", which literaly means cow milk
mother_N2 = mkN2 "mǔqīn";
oil_N = mkN "yoú" "tǒng" ; -- [mark] rewritten
peace_N = mkN "hépíng" []; -- [mark]  often without classifier
planet_N = mkN "xīngqiú" ;
plastic_N = mkN "sùliaò" "kuaī";  -- [mark] "sùliaòzhìchéng" --> "sùliaò" often without classifier
policeman_N = mkN "jǐngchá" "míng" ;
priest_N = mkN "mùshī" "weì";
queen_N = mkN "nǚwáng" ;
radio_N = mkN "shoūyīnjī" "taí" ;
religion_N = mkN "zōngjiaō" []; -- [mark]  also without classifier
rock_N = mkN "dàntoú" "kuaī" ;
roof_N = mkN "wūdǐng" ;
rubber_N = mkN "xiàngjiaō" "kuaī";
rule_N = mkN "guīzé" "xiàng"; -- [mark] "yuánzé" --> "guīzé"
shirt_N = mkN "chènshān" "jiàn" ;
silver_N = mkN "yínzǐ" "kuaī"; -- [mark] "yín" --> "yínzǐ"
sister_N = mkN "meìmeì" ;
sock_N = mkN "wàzǐ" "qí";
steel_N = mkN "gāng" "kuaī"; 
stove_N = mkN "lúzǐ" ;
village_N = mkN "cūnzhuāng" "zuò";
war_N = mkN "zhànzhēng" "chǎng" ; -- [mark] rewritten
wood_N = mkN "mùtoú" "kuaī" ; -- [mark] "mù" --> "mùtoú"


-- from scratch, by Jolene

lin
  alas_Interj = ssword "aī" ;  
  beg_V2V = mkV2V (mkV "qǐqiú") ;  -- beg him to do something
  break_V2 = mkV2 "dápò" ; 
  broad_A = mkA "kuān" ; 
  brown_A = mkA "zōng" ; 
  clever_A = mkA "cōngmíng" ; 
  close_V2 = mkV2 "guānbì" ;  
  easy_A2V = mkA2 "jiǎnchán" ;  
  empty_A = mkA "kōng" ; 
  fun_AV = mkA "yoǔqù" ;  
  hate_V2 = mkV2 "taǒyàn" ; 
  married_A2 = mkA2 "jiēhūn" ; 
  paris_PN = mkPN "bālí" ; 
  probable_AS = mkA "kěnéng" ;  
  ready_A = mkA "zhǔnbeìhaǒ" ; -- [mark] "zhǔnbeìhaǒ":  准备(v) + 好(adj,complement)
  seek_V2 = mkV2 "xúnqiú" ; 
  stop_V = mkV "tíngzhǐ" ; 
  stupid_A = mkA "bèn" ; 
  switch8off_V2 = mkV2 "guān" ;  
  switch8on_V2 = mkV2 "kaī" ; 
  ugly_A = mkA "choǔ" ; 
  uncertain_A = mkA "bùquèdìng" ; -- [mark] "bùquèdìng":  不("un-") + 确定("certain")



}
