module Main where

import CfFormat
import MorphFormat
import TypeFormat
import FileFormat

-- dialogue interface to functional grammar format. AR 1998

main =
   do
   putStr "\nGive grammar file names (two separated by space or just one). "
   f <- getLine
   (case words f of i:o:l -> mainTransl i o
                    _     -> mainOne f)

mainOne f =
   do
   g <- readFile f
   if last f == 'p' then mainDep g else 
    if last f == 'm' then mainM g else mainCf g

mainTransl i o =
   do
   g <- readFile i
   h <- readFile o
   let p = head (PMGrammar g)
       q = head (PMGrammar h)
       G = fst p
       H = fst q
       G' = StripMGrammar G
       N = [BuildNet (SelectRules G' (Cat k)) | k <- [0..11]] 
       P = PC G' (Cat 0) in
    do
--    print G
--    print G'
--    print N
    putStr (if snd p /= [] then "syntax error at " ++ take 77 (snd p) else "OK")
    putStr (if snd q /= [] then "syntax error at " ++ take 77 (snd p) else "OK")
    parseDialogueTransl G H P


mainCf g =
   let G = fst (head (PGrammar g))
       N = [BuildNet (SelectRules G (Cat k)) | k <- [0..11]] 
       P = PC G (Cat 0) in
    do
    print G
    print N
    parseDialogueCf G P

mainM g =
   let p = head (PMGrammar g)
       G = fst p
       G' = StripMGrammar G
       N = [BuildNet (SelectRules G' (Cat k)) | k <- [0..11]] 
       P = PC G' (Cat 0) in
    do
    print G
--    print G'
--    print N
    putStr (if snd p /= [] then "syntax error at " ++ take 77 (snd p) else "OK")
    parseDialogueM G P

mainDep g = 
   do
   let p = head (PMGramm g)
       G0 = fst p
       G  = StripGramm G0
       G' = StripMGrammar G
       N = [BuildNet (SelectRules G' (Cat k)) | k <- [0..11]] 
       P = PC G' (Cat 0) in
    do
    print G
    print G'
    print N
    putStr (if snd p /= [] then "syntax error at " ++ take 77 (snd p) else "OK")
    parseDialogueDep G P

parseDialogueCf G P =
   do
   putStr "\nGive a string to parse.\n\n"
   s <- getLine
   let t = P (words s) in
    do
    print (showParses t)
  --  print (map ((Lin G) . fst) t)
    parseDialogueCf G P

parseDialogueM G P =
   do
   putStr "\nGive a string to parse.\n\n"
   s <- getLine
   let t = P (words s) in
    do
    print (showParses t)
    putStr (foldl sss "" 
           (map (\x -> MLin G (fst x) []) (filter ((==[]) . snd) t)))
    parseDialogueM G P

parseDialogueDep G P =
   do
   putStr "\nGive a string to parse.\n\n"
   s <- getLine
   let 
     t = P (words s) in
    do
    print (showParses t)
--    print (showTerms t)
    putStr (foldl sss "" 
           (map (\x -> MLin G (fst x) []) (filter ((==[]) . snd) t)))
    parseDialogueDep G P

parseDialogueTransl G H P =
   do
   putStr "\nGive a string to parse.\n\n"
   s <- getLine
   let t = P (words s) in
    do
    print (showParses t)
    putStr "\n"
    putStr (foldl sss "" 
           (map (\x -> MLin G (fst x) []) (filter ((==[]) . snd) t)))
    putStr "\n"
    putStr (foldl sss "" 
           (map (\x -> MLin H (fst x) []) (filter ((==[]) . snd) t)))
    parseDialogueTransl G H P

sss x y = x ++ "\n" ++ y


-- pretty printing syntax trees

showTree :: Tree -> String
showTree (Place (Var x)) = x
showTree (Apply (Fun F) L) = F ++
 case L of [] -> ""
           L  -> "(" ++ foldl1 (\x y -> x ++ "," ++ y) (map showTree L) ++ ")"

showParses :: [(Tree,[String])] -> [String]
showParses P = [showTree C | (C,l) <- P, l==[]]

showTerms :: [(Tree,[String])] -> [String]
showTerms P = [ShowTerm (ITree C) | (C,l) <- P, l==[]]

--showTypeParses :: [((Tree,Cat),[String])] -> [String]
--showTypeParses P = [showTree C | ((C,A),l) <- P, l==[]]

