/* vim: expandtab sw=4 sts=4 ts=8
 **********************************************************
  * getAbsPath.c
   *
    * Copyright 2004, Philippe Stellwag <linux[at]mp3s[dot]name>, Germany
     * 
      * This program is free software; you can redistribute it and/or
       * modify it under the terms of the GNU General Publice License,
        * version 2 or any later. The license is contained in the COPYING
         * file that comes with the getAbsPath distribution.
          *
           * ansi c getAbsPath source code file
            */

#ifdef _WIN32
    #include <direct.h>
    #include <stdlib.h>
#else
    #include <unistd.h>
#endif

#include <stdio.h>
#include <string.h>

#ifdef _WIN32
    const int win32 = 1;
#else
    const int win32 = 0;
#endif

#define VERSION "1.4"

char cwdPath[16384];

int usage(char *mesg);
int main(int argc,char* argv[]);
char* getAbsPath(char* relPath);

int usage(char *mesg)
{
    fprintf(stderr,"\ngetAbsPath v%s -- convert relativ unix/linux/win32 pathes to absolute ones\n", VERSION);
    fprintf(stderr,"(c)2004 by Philippe Stellwag <linux[at]mp3s[dot]name>\n\n");
    fprintf(stderr,"USAGE: getAbsPath <CWD_PATH> [REL_PATH]\n\n");
    fprintf(stderr,"CWD_PATH\tthe path of the current working directory (optional)\n");
    fprintf(stderr,"REL_PATH\ta relative path (e.g. ./../init.d/bluetooth or\n");
    fprintf(stderr,"\t\t./../../../etc/X11/../init.d/network), which should be\n");
    fprintf(stderr,"\t\tconverted to an absolute one\n\n");
    if(mesg!=NULL) fprintf(stderr,"error: %s\n\n",mesg);
    return 1;
}

int main(int argc,char* argv[])
{
    if((argc!=2)&&(argc!=3))
    {
        usage("wrong usage of arguments");
        return 5;
    }

    if(argc==2)
    {
        #ifdef _WIN32
            if(_getcwd(cwdPath,16384)==NULL)
            {
                fprintf(stderr,"_getcwd error\n");
                return 10;
            }
        #else
            if(getcwd(cwdPath,16384)==NULL)
            {
                fprintf(stderr,"getcwd error\n");
                return 15;
            }
        #endif
        printf("%s\n",getAbsPath(argv[1]));
    }else{
        strcpy(cwdPath,argv[1]);
        printf("%s\n",getAbsPath(argv[2]));
    }

    return 0;
}

char* getAbsPath(char* relPath)
{
    int sizeRelPath = strlen(relPath);
    int lastState = 0;
    int i = 0, u = 0, o = 0;

    if(win32==1) /* WIN32 */
    {
        int c = 0;
        for(;c<sizeRelPath;c++) if(relPath[c]=='/') relPath[c]='\\';

        if(relPath[1]==':') return relPath;
        if(strncmp(relPath,"\\\\",2)==0) return relPath;
        
        for(;i<sizeRelPath;i++)
        {
            if(relPath[i]=='\\')
            {
                char curPath[16384];
                int j = 0, l = 0;

                for(;l<16384;l++) curPath[l]='\0';

                for(j=lastState;j<=i;j++) curPath[j-lastState] = relPath[j];
                
                curPath[j] = '\0';
                lastState = j;

                if(strcmp(curPath,"..\\")==0)
                {
                    int d = strlen(cwdPath);

                    while(cwdPath[d]!='\\') d--;

                    cwdPath[d] = '\0';
                }else if(strcmp(curPath,".\\")!=0){
                    if(cwdPath[strlen(cwdPath)-1]!='\\') strcat(cwdPath,"\\");

                    strcat(cwdPath,curPath);

                    if(cwdPath[strlen(cwdPath)-1]=='\\') cwdPath[strlen(cwdPath)-1]='\0';
                }
            }
        }

        for(u=strlen(cwdPath);u<16384;u++) cwdPath[u]='\0';

        if(cwdPath[strlen(cwdPath)-1]!='\\') strcat(cwdPath,"\\");

        for(o=lastState;o<sizeRelPath;o++) cwdPath[strlen(cwdPath)]=relPath[o];
        
        cwdPath[strlen(cwdPath)] = '\0';

    }else{ /* UNIX */

        if(relPath[0]=='/') return relPath;

        for(;i<sizeRelPath;i++)
        {
            if(relPath[i]=='/')
            {
                char curPath[16384];
                int j = 0, l = 0;

                for(;l<16384;l++) curPath[l]='\0';

                for(j=lastState;j<=i;j++)
                {
                    curPath[j-lastState] = relPath[j];
                }
                
                curPath[j] = '\0';
                lastState = j;

                if(strcmp(curPath,"../")==0)
                {
                    int d = strlen(cwdPath);

                    while(cwdPath[d]!='/') d--;

                    cwdPath[d] = '\0';
                }else if(strcmp(curPath,"./")!=0){
                    if(cwdPath[strlen(cwdPath)-1]!='/') strcat(cwdPath,"/");

                    strcat(cwdPath,curPath);

                    if(cwdPath[strlen(cwdPath)-1]=='/') cwdPath[strlen(cwdPath)-1]='\0';
                }
            }
        }

        for(u=strlen(cwdPath);u<16384;u++) cwdPath[u]='\0';

        if(cwdPath[strlen(cwdPath)-1]!='/') strcat(cwdPath,"/");

        for(o=lastState;o<sizeRelPath;o++) cwdPath[strlen(cwdPath)]=relPath[o];
        
        cwdPath[strlen(cwdPath)] = '\0';
    }

    return cwdPath;
}
