if(NOT VOLE_MODULE_LIST)
	return()
endif()

# Debug output
vole_debug_message("Available modules:")
foreach(module ${VOLE_MODULE_LIST})
	list(GET ${module} 0 module_name)
	list(GET ${module} 1 module_description)
	list(GET ${module} 2 dependencies_found)
	list(GET ${module} 3 module_variable)
	list(GET ${module} 4 required_modules)
	list(GET ${module} 5 required_dependencies)
	list(GET ${module} 6 command_list)
	list(GET ${module} 7 module_ok)

	set(command_names)
	foreach(command ${${command_list}})
		list(GET ${command} 0 command_name)
		list(GET ${command} 1 command_header)
		list(GET ${command} 2 command_class)

		list(APPEND command_names ${command_name})
	endforeach()

	vole_debug_message("  * ${module_name}: ${module_description}")
	vole_debug_message("    Variable: ${module_variable} = ${${module_variable}}")
	vole_debug_message("    Required modules: ${${required_modules}}")
	vole_debug_message("    Required dependencies: ${${required_dependencies}}")
	vole_debug_message("    Commands: ${command_names}")
endforeach()
vole_debug_message(" ")

# Check dependencies
set(finished FALSE)
while(NOT finished)
	set(finished TRUE)

	foreach(module ${VOLE_MODULE_LIST})
		list(GET ${module} 0 module_name)
		list(GET ${module} 4 required_modules)
		list(GET ${module} 7 module_ok)

			if(${module_ok})
			foreach(check_module ${${required_modules}})
				vole_check_module(${check_module} ok available variable)
				if(NOT ok)
					set(${module_ok} FALSE)
					set(finished FALSE)
				endif()
			endforeach()
		endif()
	endforeach()
endwhile()

# Debug output
set(error_message)
set(fatal_error FALSE)
foreach(module ${VOLE_MODULE_LIST})
	list(GET ${module} 0 module_name)
	list(GET ${module} 1 module_description)
	list(GET ${module} 2 dependencies_found)
	list(GET ${module} 3 module_variable)
	list(GET ${module} 4 required_modules)
	list(GET ${module} 5 required_dependencies)
	list(GET ${module} 6 command_list)
	list(GET ${module} 7 module_ok)

	if(NOT ${module_ok})
		if(${module_variable})
			set(fatal_error TRUE)
		endif()

		set(error_message "${error_message}Cannot build module \"${module_name}\"!\n")

		if(NOT dependencies_found)
			foreach(dependency ${${required_dependencies}})
				if(NOT ${dependency}_FOUND)
					list(FIND VOLE_PACKAGE_LIST ${dependency} package_available)

					if(${package_available} LESS 0)
						set(error_message "${error_message}  * Package \"${dependency}\" is not available!\n")
						set(error_message "${error_message}    Currently available packages are: ${VOLE_PACKAGE_LIST}\n")
					else()
						set(error_message "${error_message}  * Package \"${dependency}\" not found!\n")
						if(${dependency}_HELP_MESSAGE)
							set(error_message "${error_message}    ${${dependency}_HELP_MESSAGE}\n")
						endif()
					endif()
				endif()
			endforeach()
		endif()

		foreach(module ${${required_modules}})
			vole_check_module(${module} ok available variable)
			if(NOT available)
				set(error_message "${error_message}  * Module \"${module}\" is not available!\n")
			else()
				if(NOT ok)
					set(error_message "${error_message}  * Module \"${module}\" cannot be build!\n")
				endif()
			endif()
		endforeach()

		set(error_message "${error_message}")
	endif()

endforeach()
vole_debug_message("${error_message}")

if(VOLE_CHECK_DEPENDENCIES)
	if(fatal_error)
		message(FATAL_ERROR "${error_message}")
	endif()
endif()
