/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.filesystem;

import com.gemstone.gemfire.cache.lucene.internal.filesystem.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class FileOutputStream
extends OutputStream {
    private final File file;
    private ByteBuffer buffer;
    private boolean open = true;
    private long length;
    private int chunks;

    public FileOutputStream(File file) {
        this.file = file;
        this.buffer = ByteBuffer.allocate(file.getChunkSize());
        this.length = file.length;
        this.chunks = file.chunks;
        if (this.chunks > 0 && file.length % (long)file.getChunkSize() != 0L) {
            --this.chunks;
            byte[] previousChunkData = file.getFileSystem().getChunk(file, this.chunks);
            this.buffer.put(previousChunkData);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.assertOpen();
        if (this.buffer.remaining() == 0) {
            this.flushBuffer();
        }
        this.buffer.put((byte)b);
        ++this.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.assertOpen();
        while (len > 0) {
            if (this.buffer.remaining() == 0) {
                this.flushBuffer();
            }
            int min = Math.min(this.buffer.remaining(), len);
            this.buffer.put(b, off, min);
            off += min;
            len -= min;
            this.length += (long)min;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.flushBuffer();
            this.file.modified = System.currentTimeMillis();
            this.file.length = this.length;
            this.file.chunks = this.chunks;
            this.file.getFileSystem().updateFile(this.file);
            this.open = false;
            this.buffer = null;
        }
    }

    private void flushBuffer() {
        byte[] chunk = Arrays.copyOfRange(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position());
        this.file.getFileSystem().putChunk(this.file, this.chunks++, chunk);
        this.buffer.rewind();
    }

    private void assertOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Closed");
        }
    }
}

