/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.filesystem;

import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

public class ChunkKey
implements DataSerializableFixedID {
    UUID fileId;
    int chunkId;

    public ChunkKey() {
    }

    ChunkKey(UUID fileName, int chunkId) {
        this.fileId = fileName;
        this.chunkId = chunkId;
    }

    public UUID getFileId() {
        return this.fileId;
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fileId.hashCode();
        result = 31 * result + this.chunkId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChunkKey)) {
            return false;
        }
        ChunkKey other = (ChunkKey)obj;
        if (this.chunkId != other.chunkId) {
            return false;
        }
        return !(this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId));
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2169;
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.chunkId);
        out.writeLong(this.fileId.getMostSignificantBits());
        out.writeLong(this.fileId.getLeastSignificantBits());
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.chunkId = in.readInt();
        long high = in.readLong();
        long low = in.readLong();
        this.fileId = new UUID(high, low);
    }
}

