/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.distributed;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.lucene.internal.distributed.CollectorManager;
import com.gemstone.gemfire.cache.lucene.internal.distributed.LuceneFunctionContext;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntries;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollector;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class TopEntriesFunctionCollector
implements ResultCollector<TopEntriesCollector, TopEntries> {
    final CollectorManager<TopEntriesCollector> manager;
    private final CountDownLatch waitForResults = new CountDownLatch(1);
    final String id;
    private final GemFireCacheImpl cache;
    private static final Logger logger = LogService.getLogger();
    private final Collection<TopEntriesCollector> subResults = new ArrayList<TopEntriesCollector>();
    private TopEntriesCollector mergedResults;

    public TopEntriesFunctionCollector() {
        this(null);
    }

    public TopEntriesFunctionCollector(LuceneFunctionContext<TopEntriesCollector> context) {
        this(context, null);
    }

    public TopEntriesFunctionCollector(LuceneFunctionContext<TopEntriesCollector> context, GemFireCacheImpl cache) {
        this.cache = cache;
        this.id = cache == null ? String.valueOf(this.hashCode()) : cache.getName();
        int limit = context == null ? 0 : context.getLimit();
        this.manager = context != null && context.getCollectorManager() != null ? context.getCollectorManager() : new TopEntriesCollectorManager(this.id, limit);
    }

    public TopEntries getResult() throws FunctionException {
        try {
            this.waitForResults.await();
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted while waiting for result collection", (Throwable)e);
            Thread.currentThread().interrupt();
            if (this.cache != null) {
                this.cache.getCancelCriterion().checkCancelInProgress((Throwable)e);
            }
            throw new FunctionException((Throwable)e);
        }
        return this.aggregateResults();
    }

    public TopEntries getResult(long timeout, TimeUnit unit) throws FunctionException {
        try {
            boolean result = this.waitForResults.await(timeout, unit);
            if (!result) {
                throw new FunctionException("Did not receive results from all members within wait time");
            }
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted while waiting for result collection", (Throwable)e);
            Thread.currentThread().interrupt();
            if (this.cache != null) {
                this.cache.getCancelCriterion().checkCancelInProgress((Throwable)e);
            }
            throw new FunctionException((Throwable)e);
        }
        return this.aggregateResults();
    }

    private TopEntries aggregateResults() {
        Collection<TopEntriesCollector> collection = this.subResults;
        synchronized (collection) {
            if (this.mergedResults != null) {
                return this.mergedResults.getEntries();
            }
            try {
                this.mergedResults = this.manager.reduce(this.subResults);
                return this.mergedResults.getEntries();
            }
            catch (IOException e) {
                logger.debug("Error while merging function execution results", (Throwable)e);
                throw new FunctionException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endResults() {
        Collection<TopEntriesCollector> collection = this.subResults;
        synchronized (collection) {
            this.waitForResults.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResults() {
        Collection<TopEntriesCollector> collection = this.subResults;
        synchronized (collection) {
            if (this.waitForResults.getCount() == 0L) {
                throw new IllegalStateException("This collector is closed and cannot accept anymore results");
            }
            this.subResults.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(DistributedMember memberID, TopEntriesCollector resultOfSingleExecution) {
        Collection<TopEntriesCollector> collection = this.subResults;
        synchronized (collection) {
            if (this.waitForResults.getCount() == 0L) {
                throw new IllegalStateException("This collector is closed and cannot accept anymore results");
            }
            this.subResults.add(resultOfSingleExecution);
        }
    }
}

